﻿USE sofia;
DROP TABLE IF EXISTS sofia.gvn_vpl;
CREATE TABLE gvn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gvn_vpl WRITE;
INSERT INTO gvn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","2","Jakalbaku Godungku jiri balkan, yala bubu. Bubu wubulku nandajin banabu. Godumu wawu walngkan-walngkan jarra wangkar-wangkar bananga. Nguwul-nguwul bajaku yiringkurrku. ");
INSERT INTO gvn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","5","Godungku yalaman, “Yalbayku dayirrmaka.” Yinyamun yalbayku dayirrmanda. Godungku ngulkurr bajaku dayirr nyajin balbajinya. Nyulu yalaman, “Dayirr ngulkurr.” Nyulu dayirranga burri dajin, wungar. Nyulu dayirr ngami-ngami-bungan nguwul-nguwulmun. Nyulu nguwul-nguwulumu burri dajin, wujurr. Yinya day first one. ");
INSERT INTO gvn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","8","Warngku yindu Godungku kuku dajin baja, ngurrban dakanda banamun bada-badamun, wangkar jiringa bundanda. Godungku ngurrban ngami-ngami-bungan banamun. Godungku jiri jirida burri dalkin. Yinya day number two. ");
INSERT INTO gvn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","13","Warngku yindu Godungku kuku dajin baja, jalun murumanda, bubu marral warrmbamanda. Godungku bubu bubuda burri dalkin and jalun jalunda burri dalkin. Bubu and jalun ngulkurr Godundumunbu miyilba. Yinyamun nyulu kuku dajin baja, jurrbu walu-yindu walu-yindu, duduy walu-yindu walu-yindu, juku walu-yindu walu-yindu dakarinda. Jana dakarin, diburr walu-yindu walu-yindu balkajinya, daranya, jurrbu, duduy, juku wubulmarinya diburrmun. God wawu jirray junjuy-junjuynku nyulu nyajin. Yinya day number 3. ");
INSERT INTO gvn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","19","Warngku yindu Godungku kuku dajin baja, wungar, kija, dawar wubulku nguwimalman. Godungku wungara balkan warngku yindu-yindu dakanka, bubu balbanka wungaraburr. Nyulu kijanda and dawar-dawaranda balkan bubu balbanka wujurrbu. Wawu yinyamun wungarabu balban wungaraburr, kijangka, dawar-dawarangka balban wujurrdurr. Godungku wungarabu ngami-ngami-bungan, bulurijila, wungarijila and kambarala. Yinya day number 4. ");
INSERT INTO gvn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","23","Warngku yindu Godungku kuku dajin baja, jana wubulku junjuy-junjuy bananga bundandarin, kuyu walu-yindu walu-yindu warrmbamarinda bananga. Kaykay-kaykay walu-yindu walu-yindu balkajinya, jaba-jabamarinya, jananga kaykay-kaykay balkajinya baja. Yalaku. Jana wubulmarinda. Godungku dikal walu-yindu walu-yindu yalarrku balkan. Diburr walu-yindu walu-yindu balkajinya, dalkarinya, jaba-jabamarinya, wubulmarinya. Yinya day number 5. ");
INSERT INTO gvn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","31","Warngku yindu Godungku kuku dajin baja, minya walu-yindu walu-yindu warrmbamarinda, bubungu bundandarinya. Godungku yalarrku jarba walu-yindu walu-yindu balkan, junjuy-junjuy walu-yindu walu-yindu bububurr dunganya balkan. Wawu balkanyamun Godungku jananin nyajin, wawurr-wawurrman jananka. Yinyamun Godungku yalaman, “Ngana bamada balkanka. Ngana jananin balkal yala ngana. Jana majamal kuyunku wubulinkaku, majamal dikalanka wubulinkaku, majamal minyanka wubulinkaku. Kanbal minya and dikal wild-bala, kanbal minday, yamba bama majamal wubulinkaku.” Yinyamun Godungku bama bubumun balkan. Nyulu wawu dajin bamandamunbu bujilba, nyulu bama juranman. Wawu yinyamun Godungku wubulku biku-nyajin, wawurr-wawurrmankuda. Yinya day number 6. ");
INSERT INTO gvn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","4","Yala-yala Godungku bubu, jiri, wubulku kunbay-manin. Warngku 7-balaman God wawu-balangajin, kari workmanijin baja. Yala-yalaku bubu, jiri, wubulku Godungku balkan. ");
INSERT INTO gvn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","10","Wawu yinyamun Godungku garden yala park balkan bubungu Eden. Nyulu bama gardenba yijarrin. Nyulu juku wubulku balkan ngulkurrku, kanbal mayiji ngulkurrji. Dindarra gardenba juku jambul janjanan. Nyubunyinja jukubu bama juran-bunganya. Kaki bamangka mayi nukal yinyamun jukumun, nyulu wuljaljiku juranku bundanday. Yinduyngku jukubu bama binal-bunganya. Kaki bamangka mayi nukal yinyamun jukumun, nyulu binal bajaku junjuy-junjuynku, wanyu ngulkurr, wanyu buyun. Wawubaja wanarrin gardendarr, wubulku junjuy-junjuy juranku kujinka. ");
INSERT INTO gvn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","17","Wawu yinyamun Godungku bama gardenba yijarrin, garden ngulkurrduku kujinka. Godungku bamanda yalaman, “Yundu mayi nuka jukumun wubulmunku gardenba, yamba yundu jukumun dindarrmun mayi kari nuka. Yinyamundu jukubu bama binal-bungal. Yundu kari bajaku mayi yinyamun jukumun nuka. Kaki yundu nukal, yundu wulaykuda.” ");
INSERT INTO gvn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","20","Jananin wubulku minya walu-yindu walu-yindu, dikal walu-yindu walu-yindu, jananin Godungku bubumun balkan. Yinyamun nyulu jananin dingkaranda wundin, dingkarangka burri dajinka jananga. Yala-yalaku dingkarangka jananga wubulbuku burri dajin. ");
INSERT INTO gvn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","24","Yinyamun Godungku yalaman, “Yinya ngulkurr kari nyulu yinya dingkar nyulurrku bundanka. Ngayu jalbu balkal nyungunku. Jalbungku nyungu mara dajil, manyarrmanka nyungu.” Godungku dingkar warngku-kaja-bungan, bajibay walngan yinkanmun, yinkan nandan baja. Nyulu jalbu balkan bajibaymun yinkanmun. Yinyamun nyulu dingkar wandin, Godungku jalbu dingkaranda wundinda. Dingkarangka yinya jalbu nyajin, nyulu yalaman, “Yundu yala ngayu. Godungku yunun balkan ngaykuwunmun bajibaymun, ngayu yunu burri dajil, jalbu.” Dingkarangka yinyaynka nyiku-nyiku nyungu nganjan and ngamu bawalda, nyunguwunji manyarranji wuljaljiku bunday. Bula manyarrinyu yala nyubunmalkuda. ");
INSERT INTO gvn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","5","Nyulu jarba mala-nganyi bajaku, binal bajaku. Jarbangka jalbundu babajin, “Yala yunundu Godungku balkan mayi kari nukanka yinyarrinmun jukumun?” Jalbungku yalaman, “Kari. Ngalin nukalarrku mayi kanbalmun jukumun, yamba ngalin kari nukal mayi yinyamun jukumun dindarra janjanay. Kaki ngalin karrbal, nukal, ngalin wulayarrku.” Jarbangka yalaman, “Yubal kari wulay nukanyamun. Yubal binalmal wanyu ngulkurr, wanyu buyun. Kaki yubal mayila nukal, yubal yala Godmal. Nyulu God binal yubal walu-yindumal.” ");
INSERT INTO gvn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","7","Jalbungku juku ngulkurrijin nyajin, balu mayi ngulkurr bajaku nukanka, wawu jirray mala-nganyimanka. Yinyaynka nyulu mayi manin, nukankuda. Nyulu nyunguwunbu dunyundu yalarrku dajin, dunyungku nukanda. Bula walu-yinduman, binalmankuda. Bula nyajijinda, bulanga kambi yamba-kari. Wawu yinyamun bula birra jukumun manin, muru-bungan, damanda, kambi balkanka bulangaku. ");
INSERT INTO gvn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","13","Yilay-yilayman God jilba dungan bubungu. Bula yanja nyajin God, bula ngakijin dingalba jukungu. God yirrkanda, “Yubal wanjabu?” Dingkarangka yalaman, “Ngayu yunun yanja nyajin. Ngayu kambi-karimanya, ngayu yinyilman, ngakijinda.” Godungku yalaman, “Wanyangka yubalanda balkan yubal kambi-kari? Wanyu? Yubal nukan mayi yinyamun jukumun ngayu yubalanda balkan kari nukanka?” Dingkarangka yalaman, “Yundu ngaykundu yinya jalbu dajin. Nyulu yinyangka ngayku mayi dajin, ngayu nukanda.” Godungku jalbundu babajin, “Yundu wanyurrinku nukan, wanyurrinku dunyundu dajin?” Jalbungku yalaman, “Jarbangka nganya jurril-bungan, yinyaynka ngayu mayi nukanda.” ");
INSERT INTO gvn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","19","Yinyamun Godungku jarbanda yalaman, “Ngayu yunun punishim-bal, yundu bulanin jurril-bunganya. Yundu jiba-badaku warri bulburuburr. Yubal jalbu kuli-kuliku bunday. Nyungu jawun-karra and yunu jawun-karra kuli-kuliku bunday. Yunuwundu jawun-karrangka jalbumu jawun-karra jina baykal. Nyunguwundu jawun-karrangka yunun dukul kunil.” Godungku jalbundu yalaman, “Yundu kangkal manil yirrngajiku. Yamba yundu dunyunku wawu jirray, nyulu yununku majamal.” Godungku dingkaranda yalaman, “Yundu manyarranda milka-jananya, yundu nukan mayi yinyamun jukumun ngayu yubalanda balkan kari nukanka. Yinyaynka ngayu bubu buyun-damal. Yundu yaykarr bajaku workmaka, mayi maninka bubumun. Buljundu mayi buyun-damal. Yundu yaykarrku workmaka, mayi maninka yinyarrinmun jurrbumun. Juma yundu wulay. Jakalbaku yundu bubumun balkajin, juma yundu wulay, yundu bubumal baja.” ");
INSERT INTO gvn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","24","Adamangka nyunguwunbu manyarranga burri dajin, Eve. Nyulu burri Eve dajin, bama wubulku nyungundumun kadari. Yinyamun Godungku minya yulban wundin, balkan kambi bulanga, didanka. Godungku bulanin yunganda gardenmun, workmanijinka bubungu ngalkalba. Godungku angel miyilji bawan gardenba. Nyulu naybu yalbay ngalkalba yijarrin. Naybu yala ngalurri, jurrkin-jurrkijin, bama kari yuba kadanka. God wawu kari jana yubamanka, jana mayi nukanji yinyamun jukumun. Kaki jana nukal, jana wuljaljiku juranku bundayarrku. ");
INSERT INTO gvn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","7","Adam and Eveamu kangkal-bulal dingkar-bulal jambul burri Cain and Abel. Abel nyulu shepherdman, nyulu minya sheep kujil-kujinya. Cainamu work yala farmer, nyulu mayi diburr nandanya bubungu, jurrbumun mayi maninya. Juma Cainangka mayi manin bubumun, Godundu dajinka. Abelangka yalarrku present dajinka Godundu. Nyulu minya sheep ngulkurrku wundin, kunin, wayjun kuljinga. God wawurr-wawurrmanijin Abelandamunku presentka, yamba nyulu kari wawurr-wawurrmanijin Cainandamunku presentka. Yinyaynka Cain kuli-kadanda. Godungku nyungundu yalaman, “Wanyurrinku yundu kuli-kaday? Yundu buyunman, yinyaynka yundu kari wawurr-wawurrku bunday. Yundu ngulkurrmanyaku, yundu ngala-ngalaku dunganyaku. Kari buyunmaka. Kaki yundu buyunmal, buyundu yunun kajal. Buyun bawada.” Yamba Cain kari milka-janan. ");
INSERT INTO gvn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Yinyamun Cainangka yabajundu yalaman, “Ngali duduymbu duwanka.” Bula yinyaymba kadan, Cainangka nyungu yabaju Abel yarkinkaku kunin. ");
INSERT INTO gvn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","16","Godungku Cainanda babajin, “Yunu yabaju wanjabu?” Cainangka yalaman, “Ngayu binal kari. Wanyu? Ngayu kari nyungun kujil-kujinya.” Godungku yalaman, “Yundu wanjarrman? Yunuwunbu yabajungu mula bubungu wunanayda. Ngayu yunun punishim-bal, yundu yunu yabaju yarkinkaku kuninya. Wawu yinyamun yundu bubu bakal mayika, yamba yundu mayi jirray kari manil, mayi bubanku yundu manil. Yundu wabiji bubungu yindu-yinduymbu dungay.” Cainangka Godundu yalaman, “Yundu nganya buyun-damanyarrku yinyamundu punishmentmundu. Yundu nganya yunundumun yunganya bubungu kala-kalbaymba. Ngayu wabiji dungay, bamangka nganya nyajil, nganya kunilda.” Godungku yalaman, “Kari. Ngayu yunun markim-bal, yala bulki brandim-bal. Yinyamun bamangka nyajil, jana yunun kari yarkinkaku kunil.” Yinyamun Cainangka God bawan, bubungu nakamun Edenmun dungan. Bama wubulmarin Cainandamun. ");
INSERT INTO gvn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","(4.25—5.26) Adamangka, nyunguwundu manyarrangka yindu kangkal manin, burri Seth. Sethangka Abel karrnga-dajin, Cainangka Abel kuninya. Yinyamun Adamandamundu manyarrangka kangkal-kangkal wubul manin. Adam ngadi bajaku bundan, wulmanman, 930 yearsman, wulaynda. Sethangka kangkal manin, burri Enosh. Yala-yala bamangka God buyay-maninda. Nyubun dingkar burri Enoch. Nyunguwundu manyarrangka kangkal manin, burri Methuselah. Enochangka God kuku-nyajinya, nyulu kari wulan. Godungku nyungun wangkar-wangkar jiringa juranku wundin. Methuselah ngadingkaku bundan, wulmanmanda, 969 yearsman. Nyulu jarra mukul bamanka kanbalanka. ");
INSERT INTO gvn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","3","Bama wubulmarin. Jana ngami-ngamiman, yiringkurrku dungan. Godungku yalaman, “Ngayu wawu kari bama nyajinka wuljaljiku bubungu bundanka, jana buyunmanya. Nyikumun jana jarra buban juranku bunday, 120 yearsmunku.” ");
INSERT INTO gvn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","7","Juma Godungku nyajin bamangka jirray bajaku buyun-damanya. Bama buyun bajaku. Jana buyun-daman baja, buyun-daman baja, milkanga buyunjiku bundandan. Nyulu milka-bujarman nyulu jananin bama balkanya, bubungu yijarrinya. Nyulu nyuluku yalaman, “Ngayu bama, minya, dikal kari balkanyaku. Ngayu jananin wubulku yarkin-bal. Ngayu wanyurrinku balkan?” ");
INSERT INTO gvn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","21","Yamba nyubun bama, nyulu kari buyunman. Yinyaynka God nyungunku wawurr-wawurrmanijin. Nyulu bama burri Noah. Nyulu Godunji balkawanya, nyungun wukurrinya, buyay-maninya. Yinyaynka Godungku Noahnda yalaman, “Yundu boat yalbay balka yulalmun. Balka kalbaliku, 133 metres, 22 metres dindarra, 13 metres jarra-jarra yala juku kalbali. Floor kulur balka, yala bayan kulur, nyubun bada bajaku, yindu dindarra, nyubun jarra-jarra baja. Karrngka window nyubun balka dindarranga bayanba. Nyubun door yalarrku balka boatmunbu.” Godungku yalaman baja Noahnda, “Ngayu jalungkarr yungal bubungu, bubu yiringkurrku nandaji. Bama-bama, minya-minya, dikal-dikal wubulku bujil-janjilkuda. Wubulku wulaykuda, yamba ngayu yunu promise dajil. Kaba kadanjiku, yunu manyarr, yunu kangkal-kangkal kuluruku, jananga manyarr-karra boatmunbu-bunga. Yundu yalarrku dingkar nyubun and jalbu nyubun minya walu-yindu walu-yindu boatmunbu walay-mana. Yundu minya marajiku, bijijiku, jinajiku mana, boatmunbu walay-mana. Kanbal minya ngulkurr, ngaykundu dajinka. Jananin 7-bala walay-mana, yalarrku dikal walu-yindu walu-yindu 7-bala. Yala yundu mayi jirrayku walay-mana yurranka, and jananka wubulinkaku.” ");
INSERT INTO gvn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","(6.22-7.9) Yinyamun Noahngka Godumu kuku wukurrin, yala Godungkuku balkan. Nyulu 600 years oldman, nyulu boat kunbay-manin. Yinyamun nyulu and nyungu jawun-karra boatmunbu walan. Minyangka yindu-yinduynju Noah jambul-jambulku wukurrin boatmunbu. Wawu walanyamun Godungku door nandankuda boatmunbu. ");
INSERT INTO gvn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","23","Yinyamun jana Noah Godunkuda waitmanijin. Jana warngku 7-bala waitman. Wawu yinyamun Godungku kaba jirray yungan bubungu. Kaba kadan, kadan, kadan, warngku wubul bajaku, 40 daysmunku. Juma banabu jikan nandan, bana dajaliman, juku wubulku nandan. Bama wubulku, minya-minya and dikal-dikal wubulku bujil-janjirin. Manjal jarra-jarra bajaku nandajin. Bubu yamba-kariman, bama jananka. Yinya boat walngkanda. Godungku jananin Noah ngulkurrduku kujin yala nyulu promiseim-ban, yamba janajin kanbal wubulku bujil-janjirin. ");
INSERT INTO gvn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","12","Juma kaba kunbaynda, yamba bana kariku kunbayn. Muyarabu bana wulmbarrin, wungarabu bana balban. Bana waymbulku bada walan. Juma boat manjalba jajirrijin. Yinyamun bubu jarra-jarra manjalba nguwimal milbijin. Noahngka window walngan, nyulu dikal yala waja ngalkalba yungan. Yinya dikal kari kadan baja. Juma Noahngka dikal bakamu yungan, yamba nyulu bubu kari warrmba-ban. Yinyaynka nyulu boatmunbu kadan baja. Warngku 7-balaman nyulu bakamu yungan baja. Nyulu bakamu kadan baja, yamba nyulu birra jirakal ngandalba jarra-kulbal-kulban. Yinyaynka nyulu Noah binalmanda, bubu marralmalmanda. Juma Noahngka yindu dikal yungan, dikal kari kadan baja, nyulu bubu warrmba-banya. ");
INSERT INTO gvn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","19","Yinyamun Noahngka door walngan, bubu nyajin, marralmalmanda. Juma bubu marralmankuda, Godungku Noahnda yalamanda, “Noah, yundu manyarr, kangkal-kangkal, minya wubulku ngalkalba yunga, jana wubulmarinka.” Jana minya-minya, dikal-dikal wubulku boatmun wandirin, bubungu bundarin, wubulmarin. ");
INSERT INTO gvn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","22","Noah boatmun wandin, nyulu kulji wubul muru-bungan, minya wayjunku Godumu. Nyulu minya ngulkurrku, dikal ngulkurrku manin, kuljinga yijarrin. Yinyamun nyulu minya wayjun, Godumu dajinda. Godungku jila nyuman, nyuluku yalaman, “Ngayu binal bama buyun, yamba ngayu jananin and junjuy-junjuy wubulku kari yalaku buyun-damal baja jalungkarrda. Ngayu buluriji, wungariji, kambar, wujurr and wungar wuljaljiku yungal.” ");
INSERT INTO gvn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","17","Godungku Noahnda and nyunguwunbu kangkal-kangkalanda yalaman, “Yurranga jawun-karra wubulmal, ngami-ngamiku dungari bubungu yindu-yinduymbu. Yurra majamal junjuy-junjuynku bubungu yiringkurrku, bananga yiringkurrku. Ngayu yurranda kuku junkayku dajil, ngayu bubu kari buyun-damal baja jalungkarrda. Ngayu yiril jiringa yijarril, bamangka nyajil, jana ngaykuwunku promisemunku kari milka-wulay. Ngayu promiseim-ban ngayu bubu jalungkarrda kari buyun-damanka baja. Ngayu yiril nyajil, ngayu yalarrku kari milka-wulay promisemunku ngayu balkan junjuy-junjuynku wubulinkaku.” ");
INSERT INTO gvn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","27","Noahngka bubu bakan, diburr mayi grape nandan. Nyungu kangkal-kangkal burri Ham, Shem, Japheth. Hamamu kangkal burri Canaan. Hamangka nyungu nganjan buyun-daman. Yinyaynka Noahngka yalaman, “Nyikumun jana bama Shemandamun and jana bama Japhethandamun kaday, jana majamal Hamandamunku kangkal-kangkalanka. Jana bama nyunguwunmun kangkalandamun Canaanandamun kaday, jana slave-warramal Japhethamu.” Noahngka yalaman baja, “Ngayu wawu Godungku bama Japhethandamun wubul-bunganka, majamanka.” ");
INSERT INTO gvn_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","10","Nyubun bama Noahndamun, nyulu burri Nimrod. Nyulu maja jirrayman bubungu Babylonia. ");
INSERT INTO gvn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","9","Jakalbaku bama wubulku kuku nyubunku balkawan. Juma jana bulmbuyman, yalaman, “Ngana wawu kari ngami-ngamimanka. Ngana muruku bunday, ngana junkurrjimal. Ngana town yalbay balkanka, bayan wubul bajaku ngaranka. Ngana bayan nyubun dindarranga ngaral, jarra-jarra bajaku yala manjal.” Yinyamun jana bayan ngaral-ngaranda, God wangkar-wangkarmun kadan, bayan nyajinka. Godungku nyuluku yalaman, “Ngayu binal jananka bamanka. Jana nganya kari kuku-nyajil, jana wawu janankaku junjuy-junjuy yalbay balkanka. Ngayu wawu kari jana bulmbuymanka.” Yinyaynka Godungku kuku walu-yindu walu-yindu bamanda dajin. Yinyamun jana walu-ngangkan-ngangkarin kukuku, jana binal kari. Yinyaynka jana bayan yalbay kari kunbay-manin, kari ngaran baja. Godungku bama ngami-ngami-bungan, yiringkurrku yungan bubungu yindu-yinduymbu. Jananga kuku wubulmarin. Yinyaynka jana yinya town burri dajin, Babylon. ");
INSERT INTO gvn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","32","Bama wubulmarin Shemandamun. Juma dingkar nyubun balkajin nyungundumun, burri Terah. Terah yalbayman, nyunguwundu manyarrangka kangkal kulur manin, burri Abram, Nahor, Haran. Haran yalbayman, nyunguwundu manyarrangka dingkar manin, burri Lot. Haran wulan bubungu Chaldea. Abramangka Sara marryim-ban. Yamba Sarangka kangkal murruji manin. Yinyamun jana Terah, Abram, Sara, Lot, jana town bawan, burri Ur. Jana bubungu Canaan dunganka. Yamba jana half-way kadan, townbu Haran, jana yinyay bundan. Terah yinyay wulan. ");
INSERT INTO gvn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","3","Jana bubungu Haran bundandan, Godungku Abramanda yalaman, “Yundu yunu bubu and jawun-karra bawa, yinduymbu bubungu dungay ngayu yunundu milbil. Yunu jawun-karra wubulmal. Yundu maja jirraymal. Ngayu bama wubulku wawurr-wawurr-bungal yununku, bamanka yunundumun kaday. Kaki bama yununku ngulkurrmal, ngayu jananka ngulkurrmal. Kaki jana yununku buyunmal, ngayu jananka buyunmal.” ");
INSERT INTO gvn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","9","Wawu yinyamun Abram dungan townmun Haranmun yala Godungku nyungundu balkan. Nyulu bubungu Canaan dunganka. Nyulu bulanin wundin, manyarr Sara, mukay Lot. Yalarrku workingman wubulku, yamba-yamba jirray nyulu wundin. Juma jana bubungu Canaan kadan. Jana bububurr Canaandarr dungan, jukungu kadan, burri Moreh. Yinyaymba jana bundandan, God nguwimal milbijin Abramanda. Nyulu yalaman, “Abram, bama yunundumun wubulmal. Ngayu jananga yanyu bubu Canaan dajil.” Abramangka yinya kuku nyajin, nyulu kulji muru-ban, minya wuyar yijarrin, wayjun, Godundu dajinka, buyay-maninka. Yinyamun nyulu naka dungan dindarranga townbu Bethel and townbu Ai. Yinyaymba nyulu wuburrbu bundan, God buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","7","Abram, nyungu money jirray, minya sheep, minya goat, minya bulki wubul bajaku. Nyulu jikan nubin minyanka. Yinyaynka nyulu bubungu yala bundanya, dunganya baja, yala buban bundanya, dunganya baja, yalaku, yalaku. Juma nyulu dindarrangaku kadan baja townbuku Bethel, townbuku Ai. Yinyaymba nyulu God buyay-manin baja. Abramamu mukay, Lot, nyulu yalarrku rich-balaman, minya sheep, minya goat, minya bulki jirray. Jikan buban yinyay bubungu minya-minyanka. Yinyaynka Abramamu workingmen and Lotamu workingmen kurru-jindawan jikanka. ");
INSERT INTO gvn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","13","Yinyamun Abramangka yalaman Lotanda, “Yundu ngayku mukay, ngali kari kurru-jindawanka jikanka. Bubu yaluy jirray bajaku. Yundu yarrabi yinduymbu bubungu dungay, ngayu yarra yinduymbu bubungu dungay.” Lotangka walu-wukurrin. Nyulu bubu balay nyajin yubaku wawubajanga Jordan. Yinya bubu balay, bana jirray, yala Godumu Garden of Eden. Yinyaynka Lotangka bubu balay wangkanin. Nyulu Abram bawan, bada dungan bubungu balaymba yubaku townbu Sodom. Bama yinyay buyun bajaku, Godunku wawu kari. Lot townbu Sodom bundandan, Abram bubungu Canaanku bundandan. ");
INSERT INTO gvn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","18","Lotangka Abram bawan. Yinyamun Godungku Abramanda yalaman, “Yundu bubu walu-wukurrika. Ngayu yanyu bubu wubulku dajil yunu, and yunuwunbu jawun-karranda. Bubu yunuku wuljaljiku.” Abram jurrkijin, dungan bubungu Hebron. Yinyaymba nyulu bundan yubaku jukungu jirraymba burri Mamre. Nyulu God buyay-manin yinyaymba. ");
INSERT INTO gvn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","12","Yala-yalaku maja-maja king 4-bala bubumun yindumun kadan, kuniwanka maja-majanji kinganji 5-balanji. Jana king 5-bala, nyubun maja townku Sodomanka and janajin kanbal maja townku yubanka. Jana kingangka 4-balangka kanbal king 5-bala kangan janawunmun townmun. Kanbal wuburrbu warrin. Jana kingangka 4-balangka bama and yamba-yamba wubulku ngakin townmun Sodommun and townmun Gomorrahmun. Jana Abramamu mukay Lot yalarrku karrban, nyungun wundinyarrku. ");
INSERT INTO gvn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","16","Yamba dingkar nyubun townmun Sodommun warrin Abramanda. Nyulu Abramanda yalaman, “Bama kuli-baka kadarin townbu Sodom, bama kanbal kuninka. Jana yunu mukay karrban, wundin.” Abramangka yinya kuku nyajin, nyulu nyungu workingman kunjan, muru-ban. Jana Abramangka jananin wubulku 4-bala king kuli-baka juru-wukurrin. Wujurrman, jana Abram bamanji kuli-warranji kuniwan. Nyulu Abramangka jananin kuli-baka kunin, kangan. Abramangka jananin Lot warrmba-ban, jananin and jananga yamba-yamba wubulku wundin baja. ");
INSERT INTO gvn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","20","Nyulu Abram bayanbaku kankadan, maja-bulal nyungundu maku-janan. Nyubun maja townmunku Sodomanka, nyubun townmunku Salemanka. Nyungu burri Melchizedek. Bula kadan, Abramanda maku-jananka. Nyulu Melchizedek Godumu priest, binal bajaku Godundumunku junkurrku. Nyulu mayi bread, yira wine wundin, Abramanda dajin. Nyulu yalaman, “Ngananga God jiringa, nyulu bubu and jiri wubulku balkan. Nyulu yinyangka Godungku yunun junkurrji-bungan, walay-bungan bamanka kuli-bakanka. Ngana nyungun buyay-maninka.” Yinyamun Abramangka kanbal yamba-yamba bamandamun kuli-bakandamun dajin Melchizedekanda, one tenth. ");
INSERT INTO gvn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","24","Majangka kingangka townmunku Sodomanka Abramanda yalaman, “Yundu ngayku bama and jananga yamba-yamba bamandamun kuli-bakandamun manin. Yundu jananin bama yunga baja ngaykundu, yamba yundu yamba-yamba kujirrku.” Kari. Abramangka kinganda yalamanda, “Kari. Ngayu yunu yamba-yamba kari kujil. Godungku nganya junkurrji-bungan, jananka kuli-bakanka. Kaki ngayu yamba-yamba manil yunundumun, yundu juma balkanji, ‘Ngayu Abram rich-bala-bungan.’ Ngayu junjuy-junjuy kari manil yunundumun. Yamba yinyajin junjuy-junjuy ngaykuwundu soldier-soldierangka manin, balu janaku kuji.” ");
INSERT INTO gvn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","6","Wawu yinyamun Abramangka bijarrin. Nyulu God nyajin yalamanya, “Abram, yundu kari yinyilmaka. Ngayu yunun ngulkurrduku kujil. Ngayu yunu present jirray bajaku dajil.” Abramangka Godundu babajin, “Yundu kangkal dingkar ngayku daya? Ngayku kangkal yamba-kari.” Majangka Godungku nyungun ngalkalba wundin, yalaman, “Yundu dawar jiringa nyaka. Dawar wubul bajaku. Yunu jawun-karra wubulmalkuda yala dawar jiringa.” Abramangka God kuku-nyajin. Godungku yalaman, “Nyulu Abram ngulkurr bajaku, junkay bajaku, nyulu nganya kuku-nyajinya.” ");
INSERT INTO gvn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","6","Abram ngadingka bundan, wulmanman, 99 yearsman, God nguwimal milbijin nyungundu. Nyulu Godungku yalaman, “Ngayu God junkurrji bajaku. Nganya wukurrika, junkayku dunganka. Ngayu yunun promiseim-bungal. Ngayku kuku manubajaku wunay wuljaljiku, kari kunbay. Yunu jawun-karra wubulmal.” Abram dukul badaman, God kuku-nyajinka. Godungku yalaman baja, “Ngayu yunundu promise dajil, yunu jawun-karra bubungu yinduymbu dungay, yinyaymba bundanka. Yunu jawun-karra wubulmanya, ngayu yunun burri yinduda jurrkil, burri Abraham. Ngayu yunu God, yalarrku ngayu yunuwunbu jawun-karramu God.” ");
INSERT INTO gvn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","12","Godungku yalaman baja, “Yurra yalarrku ngaykundu promise daya. Ngayu wawu nyajinka yurra nganya kuku-nyajinka, yundu and yunuwundu jawun-karrangka. Yurra dingkar-dingkar wubulku yulban yaka. Kaki dingkar ngawa warngku 8-balamal, yurra nyungu yulban yaka. Yurra murrka nyajil, yurra kari milka-wulay ngayu yurranin promiseim-bungan.” ");
INSERT INTO gvn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","22","Godungku Abrahamanda yalaman baja, “Bama wubulmal yunuwunmun manyarrandamun Sarandamun. Ngayu yubalanga kangkal dingkar dajil. Yundu nyungundu burri daya, Isaac. Yunu jawun-karra wubulmal nyungundumun. Ngayu promise nyungu kujil wuljaljiku.” God kuku kunban, nyulu Abraham bawanda. ");
INSERT INTO gvn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","8","Wawu yinyamun Abraham doorngu tentmunbu bundandan, nyulu dingkar-dingkar kulur nyajin janjananya jakalba. Abraham jinbalku warrin jananda, maku-janan. Nyulu dukul badaman, yalaman, “Kaday, wabarrba wawu-balangajika. Ngayu mayi and bana manil yurranga. Yurra jina julurrijika, mayi nuka, wawu yinyamun dungarikada.” Jana yalaman, “Yala.” Abraham tentmunbu jinbalku walan, Saranda yalaman, “Mayi bread wayju jinbaldaku.” Yinyamun Abrahamangka minya bulki karrkay wandul manin, workingmananda dajin, kuninka, wayjunku. Mayi wayjunda, Abrahamangka mayi dajinda dingkar-dingkaranda. Jana nukanda. ");
INSERT INTO gvn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","15","Dingkar-dingkarangka mayi kunbay-manin, jana Abrahamanda babajin, “Yunu manyarr Sara wanjabu?” Abrahamangka yalaman, “Nyulu kananga tentmunbuku.” Nyubun dingkar nyulu Maja God. Nyulu Abrahamanda yalaman, “Ngayu next year kaday baja, nyulu Sarangka kangkal dingkar manil.” Nyulu Sarangka yinya kuku nyajin kanamun, nyulu yajarrijin kirayku. Nyulu nyulurrku balkawan, “Ngalin ngayku dunyu mukul bajakudabi, kangkal maninka. Ngayu wanjarr kangkal manil?” Majangka Godungku Abrahamanda babajin, “Sara wanyurrinku yajarrijin? Ngayu God, binal bajaku junjuy-junjuynku balkanka. Nyulu Sarangka next year kangkalkuda manil.” Sara yinyilmanya, nyulu jurrilda yalaman, “Ngayu kari yajarrijin.” Godungku yalamanda, “Yuwu, yundu yajarrijinkuda.” ");
INSERT INTO gvn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","22","Jana dingkar-dingkar wandin, dunganka townbu Sodomanda. Abraham jananji dingkulbu dungan. Nyubun dingkar nyulu Maja God. Nyulu nyuluku yalaman, “Ngayu Abrahamanda balkal ngayu wanjarrmal bamanda townbu Sodomanda, townbu Gomorrahnda.” Nyulu Abrahamanda yalaman, “Ngayu kuku nyajin jananka bamanka Sodom-warranka and Gomorrah-warranka, jana buyun bajaku. Ngayuku bada dungay, nyajinka. Kaki jana buyun bajaku, ngayu jananin buyun-damalarrku.” Bula jambul dingkar jurrkijin, dungan townbu Sodom. ");
INSERT INTO gvn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","33","Yamba Abrahamangka bamanka Majanda babajin, “Yundu bama ngulkurr-ngulkurr yalarrku buyun-damal jananji buyun-buyunyunji? Kaki bama 50-bala ngulkurr-ngulkurr yinyay townbu bundanday, yundu wubulku yarkinkaku kunil? Yunduku bubuku wubulkuku maja jirray. Yundu buyun kari balkal, yundu ngulkurrku balkal-balkal.” Godungku Abrahamanda yalaman, “Kaki ngayu 50-bala bama ngulkurr warrmba-bal townbu Sodom, ngayu yinya town kari buyun-damalarrku.” Abrahamangka Godundu yalaman baja, “Kari kulimaka ngaykunku. Kaki bama 45-bala ngulkurrku bundanday townbu, yundu jananin buyun-damalarrku?” Godungku yalaman, “Kari. Ngayu 45-bala bama ngulkurr warrmba-bal, ngayu town kari buyun-damal.” Abrahamangka Godundu babajin baja, babajin baja manun-manunmanka jananka bamanka townbu Sodom and Gomorrahnda. Godungku yalaman, “Yaladabi. Kaki bama ngulkurrku bundanday, ngayu manun-manunmal jananka bamanka townbu.” Abrahamangka yalaman baja, “Maja, kari kuli-kaday ngaykunku. Ngayu yunundu nyubunkuda babaji baja. Kaki bama 10-bala ngulkurrku bundanday, yundu wubulku buyun-damal?” Godungku yalaman, “Kari. Kaki bama 10-bala ngulkurrku bundanday, ngayu kanbal kari kunil.” Yinyamun nyulu God dungaynda. Abraham nyunban baja bayanbaku. ");
INSERT INTO gvn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","3","Yilay-yilayman angel-bulal jambul Godundumun townbu Sodom kadan. Lot, nyulu Abrahamamu mukay, nyulu jakalba townbu gateba bundandan. Nyulu bulanin angel nyajin, maku-jananda. Nyulu Lotangka yalaman, “Yubal ngaykuwunbu bayanba kaday, wunanka.” Bula angelangka yalaman, “Kari. Ngalin ngalkalba wunay.” Lotangka bulanin kunjan baja, kadanka bayanba. Bula kanangada walan Lotanji, mayida nukan. ");
INSERT INTO gvn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","11","Bula angel wunanjiku, dingkar-dingkar wubulku Sodom-warra Lotanda kadan, yirrkan, “Bula wanjabuda? Bulanin wundi nganjinanda. Nganjin bulanin karrbanka, buyun-damanka.” Lot ngalkalba dungan, door nandan. Nyulu yalaman, “Kari buyunmaka. Yurra ngayku kangkal maral-bulal wundi, dingkar-bulal kari buyun-dama.” Dingkar-dingkarangka Sodom-warrangka yalaman, “Yundu wanyurrinku nganjinanda balkal? Yundu nganjinanga maja karibi! Yundu ngarrbalku kadan. Yundu wanyurrinku nganjinanda yala balkal? Nganjin kuli-kaday yununku.” Bula angelangka Lot kulban, kananga-bungan, door nandan baja. Bula angelangka jananin dingkar-dingkar wubulku miyil-kari-bunganyarrku, jana door kari warrmba-bunganka. ");
INSERT INTO gvn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","14","Bula angel Lotanji balkawan, yalaman, “Godungku yaluyjin bama nyajin, jana buyun bajaku. Yunu manyarr, kangkal-bulal wundi townmun. Ngalin town buyun-damalarrku.” Lot jinbalku dungan, ngalayan milka-bakan, yamba bula ngalayanangka Lot kari kuku-nyajin. ");
INSERT INTO gvn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","21","Mudu-wayjul-wayjunda, bula angelangka yaykarrdaku balkan Lotanda, “Jinbal! Dungayda, bawada!” Yamba Lot nguju-ngujurin, kariku dungan. Bula jananin Lot, nyungu manyarr, maral-bulal, bula jananin mara karrban, wundinka townmun. Bula yalaman, “Jinbal! Kari kudamundu nyaka. Wuburrbu warri, yurra wulanji.” Lotangka yalaman, “Ngayu yinyilji wuburrbu dunganka. Yalada nganjin townbu yubaku dunganka? Yinyaymba townbu Zoar?” Bula yalaman, “Yalada. Jinbal!” ");
INSERT INTO gvn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","29","Wungar dakan, jana Lot kadan townbu Zoar. Yinyamun Godungku baya yilban townbu Sodom, townbu Gomorrah, wayjujinkuda. Baya darankuda yala kabakulu. Lotandamundu manyarrda kudamundu nyajin, nyulu saltmanda, yala statue. Yalibalaku Abrahamangka bada nyajin towndurr, nyulu kubukuda nyajin. ");
INSERT INTO gvn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","8","Abraham wulmanmanda, 100 yearsman, Sara kulngkulman, kangkal manin yala nyuluku Godungkuku ngadiku balkan Abrahamanda. Abrahamangka burri dajin, Isaac. Isaac warngku 8-balaman, nyunguwundu nganjanangka yulban yakan. Sarangka yalaman, “God ngaykunku ngulkurrman. Ngalin ngayku dunyu mukulman, ngadimun; kari, ngayu kangkal dingkar manin. Bama wawurr-wawurrmalda, yajarrijida.” Juma nyulu Sarangka kari bibi dajin baja Isaacamu. Yinyamun Abrahamangka mayi jirray wayjun, partyka, bamanga wubulbuku wambanda. ");
INSERT INTO gvn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","13","Abrahamamu manyarr yindu burri Hagar. Ishmael, nyulu kangkal dingkar Hagaramu and Abrahamamu, nyulu warru. Sarangka Ishmael nyajin Isaacamu kuli dajinya. Nyulu Abrahamanda yalaman, “Bulanin Hagar yunga yaluymun. Kaki yundu wulay, Ishmaelangka yamba-yamba yunundumun maninji.” Godungku Abrahamanda yalaman, “Yundu kari jiba-badi bulanka, Hagaranka and Ishmaelanka. Nyulu Ishmael yunu kangkal, nyungu jawun-karra wubulmal, yamba ngayu Isaacanda yalamal, ‘Yundu Abrahamamu kangkalkuda. Ngayu yunun Abrahamamu dajin, ngayu promiseim-bunganya.’” ");
INSERT INTO gvn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Yalibalaku Abrahamangka mayi and bana dajin Hagaranda, nyungundu yalaman, “Dungayda.” Bula, Hagar, nyungu kangkal, bula dungaynda. Bula jilbaku dungan-dungan, bubungu yindu-yinduymbu, kadanda bubungu bana yamba-kariku, Beersheba. ");
INSERT INTO gvn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","21","Bulanga bana yamba-kariman, Hagarangka Ishmael bawan bada-bada duduymbu. Nyulu buban dungan baja, bundanda. Nyulu nyuluku balkawan, “Ngayu wawu kari nyajinka ngayku kangkal wulanya.” Nyulu badin. Yinyamun angel kadan Godundumun, Hagaranda yirrkan, “Kari yinyilmaka. Ngayu Ishmael nyajin warrngkan-warrngkanya. Nyulu kari wulay, nyungu jawun-karra wubulmal.” Godungku nyungundu burayda springda milbin. Nyulu bana manin, dajinda kangkalba. Kangkal juranmanda. Wawu yinyamun Ishmael jirrayman, bundan bubungu Paran. Nyulu jalbu bubumun Egyptmun wunan. ");
INSERT INTO gvn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","2","Wawu yinyamun Godungku Abraham baban, binalmanka, nyulu wanjarrmal nyunguwunbu kangkalanda. Godungku Abrahamanda yalaman, “Yundu Isaacanka wawu jirray bajaku. Nyungunin wundi bubungu Moriah. Wuburrbu yinyaymba yundu nyungunin ngaykundu daya, nyungunin bayanga wayju, yala yundu minya ngaykundu dajinya.” ");
INSERT INTO gvn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","8","Warngku yindu yalibalaku Abrahamangka baya mukungu donkeynda yijarrin. Yinyamun nyulu Isaac and workingman jambul kunjan, jana wubulku dungarin. Jana dungan, dungan, dungan, warngku jambulman kadan bubungu Moriah. Abrahamangka dingkar-bulalanda yalaman, “Yubal yalamundu kuji. Ngalin, ngayku kangkal, ngalin dungayda wuburrbu, balkawanka Godunji. Ngalin kaday baja.” Isaacangka baya jarra-kulban. Abrahamangka naybu and ngunjil wundin. Bula dungan-dungan, Isaacangka nganjananda babajin, “Nganjan, minya wanjabu dajinka Godundu?” Abrahamangka yalaman, “Kari, Godungku minya dajil ngalinda.” ");
INSERT INTO gvn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","14","Bula bubungu kadan, Abrahamangka kulji wubul muru-bungan, baya yijarrin kuljinga, yamba kariku wayjun. Nyulu Isaac karrabu kajan, nyungun yijarrin bayanga, naybu manin, kangkalda kuninka. Kari, nyulu angel Godundumun yirrkan Abrahamanda, “Abraham, kangkal kari kuni! Godungku yunun nyajin-nyajil, nyulu binalda yundu nyungun kuku-nyajil-nyajinya.” Abrahamangka walu-wukurrin, minya nyajin jaybajinya duduymbu. Nyulu kangkal walngan, minya yijarrin kuljinga. Nyulu minya kunin, wayjun, dajinda Godundu. Abrahamangka yalaman, “God ngalinka ngulkurr bajaku, ngalinga minya dajinya.” ");
INSERT INTO gvn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","19","Godungku Abrahamanda yalaman, “Yundu wawurr-wawurrduku Isaac dajin ngaykundu. Yundu nyungun kari kurinya ngaykundumun, ngayu yunun wawurr-wawurr-bungal manubajabuku. Yunu jawun-karra wubulmal, wubulmal yala dawar jiringa. Yunu jawun-karra wubulmanya, bama kanbal yiringkurrku wawurr-wawurrmal. Ngayuku balkalarrku.” Jana, Abraham, Isaac, workingman-bulal, jana bubunguku Beershebaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","20","Nyulu Sara 127 years oldman, nyulu wulan townbu Hebron, bubungu Canaan. Abraham banbadin nyungunwunku manyarranka. Yinyamun nyulu nyungu manyarr nandan bulkajimunbu cavemunbu bubungu Canaanba. ");
INSERT INTO gvn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","9","Abraham, nyulu wulman bajaku. Nyubun dingkar, nyulu maja Abrahamandamunku workingmananka. Nyulu Abrahamangka yinya dingkar kunjan, yalaman, “Yundu maral mana, Isaacangka manyarr-bunganka. Maral yaluymun bubumun kari mana. Ngaykuwunbu jawun-karranda dungay. Ngayu wawu nyajinka yundu nganya kuku-nyajinka. Ngayu wawu yundu nganya promiseim-bunganka. Godungku yunun nyajil nganya promiseim-bunganya.” Dingkarangka yalaman, “Kaki maral wawu kari yalaymba kadanka, yalada ngayu Isaac wundil bubungu yunuwunbu jawun-karrandamunbu?” Abrahamangka yalaman, “Kari. Ngayku kangkal kari bajaku wundi yinyaymba bubungu. Godungku angel jakalba yungal, yununku yanday-bunganka. Kaki jalbu wawu kari kadanka, yalada, bawada.” Dingkarangka yalaman, “Yalada. Ngayu dungayda.” ");
INSERT INTO gvn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","11","Nyulu dingkarangka junjuy-junjuy wubul bangkan, yijarrin camelanda 10-balanda. Nyulu dunganda bubungu Mesopotamia, kadan yubaku townbu Abrahamamu jawun-karra bundandan. Nyungu camel-camel yubaku wellba wawu-balangajinda. ");
INSERT INTO gvn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","14","Nyulu dingkarangka Godundu babajin, “God, yundu ngulkurrmaka Abrahamanka, ngaykundu maral milbi. Jana maral-maral townmun wellba kaday, ngayu nyubunyimba babaji ngayku bana dajinka. Kaki nyulu yalarrku bana dajil camel-camelanda, ngayu binalmal yundu yinya jalbu dajinka Isaacanda, manyarrmanka.” ");
INSERT INTO gvn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","25","Nyulu dingkar Godunji balkan-balkawanku, maral burri Rebecca kadan, bana maninka. Nyulu ngulkurrijin bajaku, dingkaranji kariku wunan. Dingkarangka nyungundu babajin, “Bana ngayku wundi, ngayu nukanka.” Rebeccangka bana jinbaldaku wundin nyungundu, yalaman, “Ngayu yalarrku bana manil yunuwunbu camel-camelumu.” Maralangka bana manil-manin, dingkarangka nyungun biku-nyajil-nyajin, binalmanka nguba Godungku yinya maral nyungundu milbin, nguba kari. Nyulu dingkarangka Rebeccamu ring dajin, junjuy jambul goldmun dakilka dajin, babajin, “Yunu nganjan wanya? Nyungu bayan jirray? Ngayu bundanka yurranji.” Rebeccangka yalaman, “Ngayku nganjan Bethuel. Ngayku babi Milchah, kami Nahor. Nganjin mayiji, bayan jirray. Yundu nganjinanji bunday.” ");
INSERT INTO gvn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","27","Dingkar dukul badaman, God buyay-manin. Nyulu Godundu yalaman, “God, yundu junkurrji bajaku. Abraham milkanga yununjiku bundandanya. Yundu nyungunku ngulkurrman, nganya junkayku wundin nyunguwunbu jawun-karranda.” ");
INSERT INTO gvn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","31","Rebecca ngamundu warrin, balkanka. Maralamu yaba, Laban, nyulu kadan wellba, dingkar maku-nyajinka. Nyulu Labanangka yalaman, “Kaday, bunday nganjinanji. Ngayu bayan yanday-bungan, yalarrku room jirray camel-camelanka.” Dingkar Labananji dungan. ");
INSERT INTO gvn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","49","Labanangka mayi dajin camel-camelamu, bana wundin dingkaranda, janjinka, mayi wundin nyungu. Dingkarangka yalaman, “Mayi kariku daya, ngaykundurr milka-janay. Ngayu kukuji kadan Abrahamandamun. Wawu yinyamun ngayu mayida nukal. Ngayu Abrahamandamunbu workingmanamu maja. Godungku Abraham ngulkurrduku kujin, wawurr-wawurr-bungan. Nyungu yamba-yamba jirray bajaku. Bula Sara, Abraham mukulman, bulanga kangkal balkajin, burri Isaac. Kaki Abraham wulay, Isaacangka yamba-yamba wubulku manil. Abrahamangka ngaykundu yalaman, ‘Yundu dungay ngaykuwunbu jawun-karranda, Isaacamu manyarr maninka. Godungku yunundu maral milbil. Kaki yinya maral wawu kari kadanka, yalada, bawa.’ Ngayu wellba kadan, Godundu babajin, ‘Maral ngaykundu milbi, Isaacamu manyarr.’ Junkaynjaku Godungku ngaykunduda Rebecca milbin. Yurra Rebecca yunganka kangkalba Abrahamandamunbu? Balkada, ngayu binalmanka.” ");
INSERT INTO gvn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","61","Bula Bethuel, nyulu Rebeccamu nganjan, Laban, nyulu Rebeccamu yaba, bula yalaman, “Godungkuku milbin, nganjin kari kiril. Rebecca yununji dungay.” Dingkarangka jananga junjuy-junjuy wubul presents dajinda. Warngku yindu nyulu dungankada, yamba bula, Rebeccandamundu nganjanangka, ngamungku, bula yalaman, “Warngku 10-bala bunday. Wawu yinyamun nyulu yununji dungayda.” Dingkarangka yalaman, “Kari, ngayu dungankada.” Bula Rebeccanda babajin, “Yundu nyiku dunganka dingkaranji?” Rebeccangka yalaman, “Yala, ngayu dungayda.” Bula yabangka, ngamungku, bula yalaman, “Yalada. Ngalin wawu nyajinka yundu kangkal-kangkal wubul maninka, bama wubulmal yunundumun.” Yinyamun jana, Rebecca, bama nyungundu workmanijinya, jana dingkaranji dunganda. ");
INSERT INTO gvn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","67","Jana dungan, dungan, dungan, yubaku kadan Abrahamandamunbu bayanba. Yilay-yilay Isaac jilba dungan-dungan, nyulu camel-camel nyajin kankadanya kala-kalbaymunkuku. Rebeccangka Isaac nyajin, jalaman camelundumun, dingkaranda babajin, “Yinya dingkar wanya?” Dingkarangka yalaman, “Nyulu Isaac, yunu dunyu.” Rebecca walu nandajinda kambibu. Dingkarangka Isaacanda balkan nyulu wanjarrman. Isaacangka Rebecca wundin nyunguwunbu bayanba. Nyulu nyungu manyarrmanda. ");
INSERT INTO gvn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","9","Abraham wulmanman, 175 years oldman, nyulu wulan. Nyunguwundu kangkal-bulalangka Isaacangka Ishmaelangka nyungun nandan cavemunbu jana nyungu manyarr Sara nandan. ");
INSERT INTO gvn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","26","Rebecca kangkal kariku. Yinyaynka Isaac Majanda Godundu babajin manyarr kulngkulmanka. Godungku Isaac kuku-nyajin, Rebecca kulngkulmankuda. Juma dingkar-bulal jambul balkajin muruku. Yaba jarra ngala-ngala, mungka jirray bangkarrba. Ngamungku and nganjanangka burri dalkin Esau. Yabaju balkajin yabamu jina karrban-karrbanya. Ngamungku and nganjanangka nyungun burri dalkin Jacob. ");
INSERT INTO gvn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","28","Bula yaba-yabaju jirrayman, Esau mala-minya, yarbarrka jilba dungan. Jacob walu-yindu, nyulu bayandarrku workmanijinya, wawu kari jilba dunganka. Nganjan Isaac Esaunku wawu-jirrayman, nyulu wawu nukanka minya Esaungku wundinya. Yamba ngamu Rebecca Jacobankaku wawu-jirray. ");
INSERT INTO gvn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","34","One day Jacobangka milkul wayjul-wayjun, Esau dakuynji kadan jilbamun. Nyulu Jacobanda yalaman, “Ngayu dakuy bajaku, yinya mayi ngayku daya.” Jacobangka yalaman, “Yundu yaba. Yinyaynka yundu majamal. Nganjan wulay, nyulu junjuy-junjuy jirray yununduku bawal. Kaki yundu ngaykundu wubulku dajil, ngayu yunu mayi dajil.” Esaungku yalaman, “Ngayu dakuynji wulay. Ngayu wulay, ngayu kari yamba-yamba manil.” Jacobangka yalaman, “Nganya manubajabuku promiseim-bunga wubulku junjuy-junjuy dajinka.” Esaungku manubajabuku promiseim-ban, wubulku dajinka. Yinyamun Jacobangka mayi dajin, bread, milkul. Esaungku nukan, dunganda. Esaulu, nyulu yaba, nyuluku maninyaku. Jana yalaku, yabangka nganjanandamun jirray maninya, nganjan wulan. Yamba nyulu wubulku dajin yabajundu. ");
INSERT INTO gvn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","4","Isaac wulman bajaku, miyil-burraman. Nyulu kangkal jakalbamunku kunjan, nyungundu yalaman, “Ya, ngayu wulman bajaku, wanja-wanja baja wulay. Bow and arrow mana, jilba dungay, ngayku minya damanka. Yinya minya wayju, ngulkurr bajaku, yalaku wayju ngayuku nukanka. Ngayu nukal, yinyamun yunun blessing-bunganka, ngayu wulanjiku.” ");
INSERT INTO gvn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","13","Kari. Rebeccangka Isaac nyajin Esaunji balkan-balkawanya. Esau jilba dungan, Rebeccangka Jacobanda yalaman, “Ngaykundu milka-janay. Goat karrkay-bulal jambul mana, wandul. Ngayu wayjunku yalaku yunuku nganjanku wawu. Yundu nyungundu daya, nyulu yunun blessing-bungal, nyulu wulanjiku.” Jacobangka ngamundu yalaman, “Kari. Esau mungka jirray bangkarrba. Nganjanangka nganya nguba marabu karrbal. Mungka yamba-kari ngaykundu dakilba, nyulu binalmalda ngayu nyungun jurril-bal-bal. Yinyamun nyulu nganya kari blessing-bungal, nyulu Godundu babaji nganya buyun-damanka.” Ngamungku yalaman, “Kari. Kaki nyulu Godundu babaji yunun buyun-damanka, balu nyulu babajika. Godungku nganyaku buyun-damal, yunun kari. Yundu nganya kuku-nyaka.” ");
INSERT INTO gvn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","17","Jacobangka ngamu kuku-nyajin. Nyulu minya manin, ngamundu dajin, ngamungku minya wayjun, yala nganjanku wawu. Nyulu Esaumu kambi ngulkurr manin, Jacobanda diday-manin. Rebeccangka goat yulban manin, Jacobanda dakilba, manungu diday-manin. Nyulu mayi dajin Jacobanda, minya, bread. ");
INSERT INTO gvn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","25","Jacob nganjananda dungan, yalaman, “Ya, nganjan.” Isaacangka babajin, “Yundu wanya?” Nyulu miyil-burra. Jacobangka jurril balkan, “Ngayu Esau, yunu kangkal jakalbamun. Ngayu minya manin yala yundu balkan. Dakada, minya nukanka, yala nganya blessing-bungankada.” Isaacangka babajin, “Wanjarrku yundu minya jinbaldaku manin?” Jacobangka yalaman, “Godungku ngaykundu minya milbin.” Isaacangka yalaman, “Yuba kadayngarr, ngayu baranka if yundu Esau. Jacob nganjananda yuba kadan, nganjanangka nyungun baran, yalamanda, “Bulu yala Jacobamu, yamba dakil Esaumu.” Isaacangka balu nyajin Esau, mungka dakilba, yala Esaumu dakil. Nyulu babajin baja, “Yala yundu Esau?” Jacobangka yalaman, “Ngayu Esaukuda.” Nganjanangka yalaman, “Ngayku minya daya. Wawu mayimun ngayu yunun blessing-bungalda.” Jacobangka nyungu mayi dajin, minya jirray wamban, yira wine dajin nukanka. ");
INSERT INTO gvn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","29","Nganjanangka Jacobanda yalaman, “Yubamaka, nganya kissim-bunga.” Jacob nganjananda yuba kadan, nganjanangka kambi nyuman, Jacob blessing-bunganda. Nyulu yalaman, “Yunu kambi jila yala bubu Godungku ngulkurrduku balkan. Ngayu wawu nyajinka Godungku kaba yunganya mayika, bubu ngulkurrku yunu dajinka. Ngayu wawu nyajinka Godungku mayi jirray-bunganka, yunuwunbu bubungu. Ngayu wawu yunun nyajinka majamanka bamanka bubumun yindu-yindumun, bama wubulku yunundu milka-jananka. Ngayu wawu yunun nyajinka majamanka yunuwunku jawun-karranka, jana yunundu milka-jananka. Kaki bamangka yunun buyun-damal, Godungku yalarrku jananin buyun-damal. Kaki bama yunundu ngulkurrku bunday, God yalarrku jananda ngulkurrmal.” Isaacangka Jacob yalaku blessing-bungan. Jacobangka nganjan bawanda. ");
INSERT INTO gvn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","40","Jacobangka nganjan bawan, yinyamun Esau jilbamun kadan, minyaji. Nyulu Esaungku minya wayjun, nganjananda wundin, yalaman, “Ya, nganjan, dakada, minya nukanka ngayu yunu wundin, yundu nganya blessing-bunganka.” Isaacangka babajin, “Yundu wanya?” Esaungku yalaman, “Ngayu Esau, yunu kangkal jakalbamun.” Isaac yararrinda, babajin, “Yala wanyangka ngayku minya dajin jakalbaku? Ngayu yinya minya nukan before yundu kadanjiku. Ngayu nyungun blessing-bungankuda, yinya blessing kari kunbay baja, nyungukuda.” Esau yaykarrku badinda, yalaman, “Nganya yalarrku blessing-bunga.” Yamba Isaacangka yalaman, “Yunuwundu yabajungku nganya jurril-bungan, ngayu nyungun blessing-bungankuda.” Esaungku babajin baja, “Nganya blessing-bunga, nganjan. Kaki blessing yalbay yamba-kari, blessing buban dayarrku.” Nyulu banbadin. Isaacangka yalaman, “Yundu bunday bubungu marralba, mayi buban bajaku. Yundu bamanji kuniway mayika, yamba-yambaka. Bama Jacobandamun majamal yunuwunku bama-bamanka wubulinkaku, yamba juma jana free-balamalda.” ");
INSERT INTO gvn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","45","Nganjanangka Jacob blessing-bunganya, Esau Jacobanka wawu-karimanijin, nyungun yarkinkaku kuninka. Rebecca yinyaynka binalman, nyulu Jacobanda balkan dunganka kulimun. Nyulu Jacobanda yalaman, “Yunuwundu yabangka yunun yarkinkaku kuninka, payim back-bunganka, yundu nyungundumun blessing ngakinya. Nyaka. Dungayda ngaykuwunbu yabanda, burri Laban, nyulu bubungu Haran bundanday. Nyungunji bunday, balu yaba kulika milka-wulay.” ");
INSERT INTO gvn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeccangka Isaacanda yalaman, “Ngayu wawu kari Esaundumunku manyarr-bulalanka, bula yaluymun bubumun. Ngayu wawu kari nyajinka Jacob jalbu yala yinya-bulal marryim-banka.” ");
INSERT INTO gvn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","5","Isaacangka Jacob kunjan, nyungundu yalaman, “Jalbu yaluymun kari wunay. Kalnganda, ngajindaku dungay baja, jalbu-jalbu kambanmu-karra yinyamun bubumun wunay. Ngayu wawu nyajinka Godungku kangkal-kangkal wubul yunu dajinka. Ngadiku Godungku yunu kami bubuku promiseim-ban, ngayu wawu nyajinka nyulu yinya bubu yunu dajinka.” Isaacangka Jacob yunganda, kalnganda Labananda. ");
INSERT INTO gvn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","15","Jacobangka ngamu, nganjan bawanda. Nyulu bubungu maku Haran dungan-dungan, wungar daran, nyulu warngku wunan, dukul yijarrin kuljinga. Nyulu ladder bijarrin, ladder jirimun bubungurrku. Angel-angel ladderburr bada-bada kankadan, wangkar-wangkar dakal-dakan. Nyulu Maja God bijarrin, nyungunjiku janjananya. Godungku yalaman, “Ngayu Maja God Abrahamamu, Isaacamu, bula ngaykundu milka-janan. Ngayu bubu yanyu dajil yunundu, and bamamu yunundumun kaday. Jana wubulmal, jananga bubu yalbay-bungal. Ngayu bama wubulku yiringkurrku blessing-bungal yununku, and bamanka yunundumun kaday. Milkanga kuji, ngayu yununji dungay, yunun ngulkurrduku kujil, wundil baja yalaymbaku. Ngayku kuku ngayu manubajabuku yunundu balkal.” ");
INSERT INTO gvn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","22","Jacob warngkumun wandin, yalaman, “Ya, God yaluykuda. Ngayu binal kari.” Nyulu yinyilji, yalaman baja, “God yaluy bundandan, yanyu bubu yala gate jiringa.” Jacob yalibalaku wandin, kulji manin dukulmun, jajirrin, bijarrka kari milka-wulanka. Nyulu oil nyangarrin kuljinga, bubu burri dalkin, Bethel. Janawunbu kukungu Bethel mean Bayan Godumu. Jacobangka promise dajinda Majanda Godundu. Nyulu Godundu yalaman, “Kaki yundu ngaykunji dungay and ngayku mayi, kambi dajil and nganya wundil nganjanandamunbuku bayanbaku, ngayu yunun kuku-nyajil. Bamangka yunun buyay-manil yaluy bubungu. Yundu ngayku dajil, ngayu yunundu kanbal dajil baja, one tenth.” ");
INSERT INTO gvn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","12","Jacobangka bubu Bethel bawan, kadan bubungu Haran. Nyulu wellba kadan, sheep wubul bajaku yubaku wellba wunanan. Kulji yalbay bajaku wuyar wellba wunanan, well nandanka. Sheep wubulku wellba kadanya, jana dingkarangka shepherdangka yinya kulji walnganya wellmun, sheepanda wubulbuku bana dajinya, well nandanya baja kuljibu. Jacobangka jananda dingkaranda shepherdanda babajin, “Yurra wanjamun?” Jana yalaman, “Bubumun Haranmun.” Nyulu babajin, “Yurra Labananka binal?” Jana yalaman, “Yuwu, nyungunku binalkuda.” Nyulu babajin, “Nyulu ngulkurrku bundanday?” Jana yalaman, “Yuwu, nyulu ngulkurrku bundanday. Nyaka, yinya jalbu kankaday, yinya nyungu kangkal burri Rachel, nyulu kankaday nyunguwunji sheepanji.” Jana balkan-balkawan, Rachel kadan sheepanji. Jacob wellba dungan, kulji wellmun walngan, bana sheepamu dajin. Yinyamun nyulu Rachelanda yalaman, “Ngayu yunuwunbu nganjanamu juway.” ");
INSERT INTO gvn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","14","Nyulu Rachel nganjananda warrin, balkanda. Labanangka nyajin, nyulu juwayanda warrin, nyungun kissim-ban, wundinda bayanba. Jacobangka nyungundu balkan nyunguwunku jawun-karranka. Labanangka yalaman, “Yundu ngayku juway bajakuda.” ");
INSERT INTO gvn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","19","Labanamu kangkal jalbu-bulal jambul, babarr Leah, jinkurr Rachel. Kija nyubunman Labanangka Jacobanda yalaman, “Yundu ngaykundu kari workmaniji money-karikaku. Ngayu yunu wanjarrku pay dajil?” Jacob bujanji Rachelanka, nyulu Labananda yalaman, “Ngayu yunundu 7 yearsanka workmaniji, yundu yunu kangkal Rachel daya ngayku, manyarr-banka.” Labanangka yalaman, “Yala. Ngayu nyungun yunu dajil.” ");
INSERT INTO gvn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","30","Jacob Labananda 7 yearsanka workmanijin, Rachel maninka, manyarr-banka. Yinyamun Jacobangka Labananda yalaman, “7 yearsmanda, Rachel ngayku daya.” Labanangka mayi jirray-bungan weddingka, wubulku kunjan mayika. Wujurrman, Jacobangka Rachel kujil-kujin, yamba Labanangka babarr Leah wundin Jacobanda, manyarr-bunganka, Rachel kari. Warngku yindu wungar wandin, Jacob binalmanda, nyulu jalbu Leah manin, Rachel kari. Nyulu Labananda dungan, yalaman, “Yundu wanyurrinku nganya jurril-bungan? Rachelankaku ngayu workmanijin, Leahnka kari.” Labanangka yalaman, “Nganjin yalaku, babarrngarr dajil, yinyamun jinkurrda. Yundu warngku 7-bala bunday Leahnji. Ngayu Rachelda dajil, yundu 7 yearsanka workmanijika baja Rachelanka.” Jacobangka yalaman, “Yala.” 7 daysman, Labanangka Rachel Jacobanda dajin, manyarr-banka. Jacob Rachelanka wawu jirray, Leahnka jarra yala. Nyulu Labananda workmanijin baja 7 yearsanka. ");
INSERT INTO gvn_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","(29.32-30.36) Jacobamu kangkal-kangkal dingkar-dingkar burri Reuben, Simeon, Levi, Judah, Dan, Naphtali, Gad, Asher, Isaachar, Zebulon, Joseph. Wawu Josephandamun Jacobangka Labananda yalaman, “Nganjinin yungada, ngayu bayanbaku dunganka, nganjanandaku, bubunguku.” Labanangka yalaman, “Ngayu binal Godungku ngayku sheep, goats jirray-bungan, yundu ngaykundu workmanijinya. Ngayu wanjarrku yunun payim-bal, yundu ngaykundu workmanijinka baja?” Jacobangka yalaman, “Ngayu moneyka wawu kari. Ngayku wubulku sheep daya kaykay-kaykayku, ngumbu, wubulku goat kaykay-kaykayku, jinjurr-jinjurr. Kaki yundu ngaykundu yinyarrin dajil, ngayu yunundu workmal baja.” Labanangka yalaman, “Yala.” Yamba Labanangka same day goat jinjurr-jinjurr, sheep ngumbu manin, ngami-ngami-bungan yindu-yindumun kanbalmun, dajin nyunguwunbu dingkar-dingkaranda kangkal-kangkalanda, kujinka. Nyulu jananin kala-kalbay yungan. Jacobangka kanbal goat, sheep kujin Labanamu. ");
INSERT INTO gvn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","43","Jacobangka juku kayal nyandan, dumbul buban-bubanku walngan. Kaki goat junkurrji yinduymbu dakanka, nyulu yinyay juku yijarrin, jakalba goatundu. Yinyangkala goatangka kangkal jinjurr-jinjurrda manin. Jacobangka goat yalaku junkurrjiku maninya, kala-burrala Labanangka maninya. Yinyamun Jacobamu junjuy-junjuy jirrayman. Bama wubul nyungundu workmanijinya, nyulu majamanda. ");
INSERT INTO gvn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","2","Jacobangka kuku nyajin Labanandamundu kangkal-kangkalangka balkanya, “Jacobangka ngananganbu nganjananga junjuy-junjuy wubulku manin, sheep, goat, yamba-yamba.” Jacob binalmanda Laban nyungunku wawu-kariman. ");
INSERT INTO gvn_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","18","Yinyamun Godungku Jacobanda yalaman, “Yunuwunbuku bubunguku dungay baja, jawun-karrandaku. Ngayu yalarrku yununji dungay.” Jacobangka kuku yungan manyarr-bulalanda, Rachelanda, Leahnda, nyungundu kadanka paddockmunbu. Nyulu bulanda yalaman, “Yubalanga nganjan ngaykunku wawu-kariman. Yamba God ngaykunji bundanday. Yubal binal ngayu yubalandamunbu nganjananda ngulkurrku workmanijin, yamba nyulu nganya jurril-bungan, ngaykundu buyunman. Yamba Godungku nyungun kari letim-ban nganya buyun-damanka. Godungku ngaykundu balkan ngaykuwunbuku bubunguku dunganka baja.” Rachel bula Leahngka Jacobanda yalaman, “God kuku-nyaka.” Jacob readymanda, nganjanandaku dunganka baja bubunguku Canaanandaku. Nyulu junjuy-junjuy wubulku wundin, manyarr-bulal, kangkal-kangkal, nyungu goat, sheep, camel, donkey, bulki wubulku. Jana dungarinda. ");
INSERT INTO gvn_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","55","Warngku kulurman Labanangka kuku nyajin jana Jacob warrinya. Nyulu jananin juru-wukurrinda. Warngku 7-balaman nyulu Jacob juru-manin, nyungundu yalaman, “Yundu wanjarrmalmal? Wanyurrinku nganya jurril-bungan, wanyurrinku ngayku kangkal-bulal ngakin, wanyurrinku kirayku ngakijin? Kiru-kari bajaku! Ngayu junkurrji, yunun kuninyaku. Kari. Wujurrbuku yunuwundu Godungku nganya milka-bakan, yunun kari kuninka.” Jacob kuli-kadanda. Nyulu yalaman, “Ngayu wurrmay-baka kari, ngayu 20 yearsanka yunundu ngulkurrku workmanijin, junjuy-junjuy yunundumun kari ngakin. Yala-yalaku ngayu yunundu workmanmanijin, yunu sheep, goat wubulman, ngayu yunu minya kari nukan. Yunu sheep or goat walu-kunbanya, ngayu yunu ngaykundumun dajinya. Yundu ngaykundu buyunmanya, yamba Godungku nganya ngulkurrduku kujinya. Nyulu wujurrbuku yunun murru-kangan.” Labanangka Jacobanda yalaman, “Ngali promise balkanka. Ngali kulji muru-bungal, ngalingan milka-bakanka ngali promise balkan.” Bula kulji wubul muru-bungan, promise balkanda. Labanangka yalaman, “Ngali ngami-ngamiku bundanday, Godungku ngaliyan nyajin-nyajil. Ngayu ngundu-ngundu kuljinga bunday, yundu naka-naka kuljinga bunday. Ngayu kari walkuku dungay yarra kuljiburr, yunun kuninka. Yundu kari walkuku yarra kuljiburr kaday, nganya kuninka.” Yalakuda bula promise balkanda. Warngku yindu Labanangka kangkal-bulal, jija-karra baru karrban, bayanbaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","2","Jacob dungan-dungan, angel-angelangka nyungunda maku-nyajin. Nyulu Jacobangka yalaman, “God yaluyda bundanday.” ");
INSERT INTO gvn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","12","Jacobangka bama yungan kukuji yabanda Esaundu, bubungu Edom. Jana Esaundu balkan, “Yunu yabaju Jacob Labananji bundandan, yamba nyulu kankadayda. Yundu majamal nyungunku, nyulu yunundu milka-jananka.” Jana kukuji Jacobandaku kadan baja, yalaman, “Nganjin yunuwunbu yabanda dungan; nyulu kankadayda, yunundu maku-warrinka. Nyulu dingkar-dingkaranji 400-balanji kankaday.” Jacob yinyilman, worry-balaman. Nyulu junjuy-junjuy, bama-bama ngami-ngami-bungan, kanbal yarra yungan, kanbal yarra naka yungan. Nyulu nyulurrku balkawan, “Kaki Esaungku kanbal kunil, kanbal nguba warriri.” Yinyamun nyulu Godunji balkawan, “God, yundu kamimu Abrahamamu God, nganjanamu Isaacamu God. Ngaykundu milka-janay. Maja God, yundu ngaykundu balkan bubunguku dunganka baja, jawun-karrandaku. Yundu balkan yundu nganya ngulkurrduku kujil. Ngayu buyun bajaku, yamba yundu ngaykunku ngulkurr bajaku. Nganya kujinka ngaykuwundumun yabandamun. Ngayu yinyilmal, nyulu nganjinin yarkinkaku kuninji, jalbu-jalbu, kaykay-kaykay, wubulku kuninji. Yundu nganya promiseim-ban ngulkurrduku kujinka, bama ngaykundumun wubulmanka.” Jacobangka yalaku Godundu balkan. ");
INSERT INTO gvn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","21","Warngku yindu Jacobangka minya-minya mujan, present dajinka Esaundu. Nyulu minya-minya ngulkurr-ngulkurrku wangkanyin, sheep, goat, camel, donkey, bulki. Yinyamun nyulu jakalbada yungan, Esaumu dajinka. Nyulu nyulurrku balkawan, “Kaki ngayu nyungu junjuy-junjuy jirray dajil, nyulu nguba kulika milka-wulay.” ");
INSERT INTO gvn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","32","Wawu yinyamun Jacobangka bama wubulku yungan jakalba, jana nyungu yamba-yamba wundin ngubar-ngubar wawubajanga Jabbok. Nyulu nyulurrku bawajin. Nyubun dingkar nyungundu kadan, nyungunji wrestleman, mudu-wayjulmalmanda. Mudu-wayjun, bula kariku kunban, junkurrku dungan-dungan. Dingkarangka Jacob malbin kunin, bajibay wabamun wandin. Nyulu dingkarangka Jacobanda yalaman, “Nganya yungada, wungar juma wandilda.” Jacobangka yalaman, “Kariku, nganya blessing-bungarr, ngayu yunun yungalda.” Dingkarangka babajin, “Yunu burri wanya?” Jacobangka yalaman, “Jacob.” Dingkarangka yalaman, “Yunu burri Jacob karida. Yundu wrestleman Godunji, and bamanji, yundu beatim-ban. Yinyaynka ngayu yunun burri dalkil, Israel.” Yinyamun nyulu Jacob blessing-bungan. Jacobangka yalaman, “Ngayu God nyajinda, yamba ngayu juranku, kari wulan.” Wungar dakan, Jacob dungan baja, yalkan-yalkajinda, bajibay wandinya wabamun. ");
INSERT INTO gvn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","16","Jacobangka Esau nyajin kankadanya dingkar-dingkaranji, nyulu Jacob jakalba dungan, manyarr-karra, kangkal-kangkal kudamundu. Jacob, Esau bula yuba kadan, Esau warrin Jacobanda, nyulu kuli kunbaynda Jacobanji. Bula banbadinda. Jacobangka Esaundu wubulku milbin, nyungu manyarr-karra, kangkal-kangkal. Esaungku wawu kari present maninka Jacobandamun, yamba Jacobangka yarbarrka yalaman, “Manada, manada.” Esaungku maninda, dungan baja nyunguwunbuku bayanbaku. ");
INSERT INTO gvn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","12","Godungku Jacobanda yalaman, “Bubunguku Bethelbuku dungay baja, yinyaymbaku bunday.” Jana Jacob bubunguku Bethelbuku dungan baja, yinyayda bundan. Yinyaymba Godungku nyungundu yalaman, “Ngayu ngadiku yanyu bubu dajin Abrahamanda, Isaacanda, ngayu yanyu bubu yalarrku dajil yunu, yunuwunbu jawun-karramu yunundumun kaday.” ");
INSERT INTO gvn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","19","Wawu yinyamun jana bubu Bethel bawan. Jana dungan-dunganda, ngawa karrkay burri Benjamin balkajin. Nyulu balkajin, ngamu Rachel wulanda. Jana nyungun nandan juljalba yubaku baralba. ");
INSERT INTO gvn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","29","Jacob nganjananda Isaacanda kadan, townbu Mamre. Isaac wulmanman bajaku, 180 years oldmanda, nyulu wulanda. Nyunguwundu kangkal-bulalangka Esaungku, Jacobangka nyungun nandanda. ");
INSERT INTO gvn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","4","Jacob kangkalanka Josephanka wawu jirray bajaku, nyulu balkajinya Jacobandamun wulmanandamunku. Joseph nyungu kurrbar. Jacobangka Josephamu kambi ngulkurrijin balkan, kambi kalbali, dakil kalbali, yala maja-majangka didal. Jana yaba-karrangka nyungun ngura-nyajin, kuliku bundandan. ");
INSERT INTO gvn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","11","Josephangka bijarrin, nyulu yaba-karranda bijarr balkan. Nyulu yalaman, “Ngana wheat paddockmunbu workmanmanijin, mayi wheat muru-bungal-bunganya, kajal-kajanya. Mayi ngayu kajanya, yinya mayi janarinya, mayi yurra kajanya dukul badamarin ngaykuwunbu mayinga, yala bama dukul badamal kinganda.” Yaba-karrangka murru-kangan, yalaman, “Yundu nganjinanka kari bajaku majamal.” Jana nyungunku wawu kari bajaku bijarrka. Juma Josephangka bijarrin baja, balkan nganjananda, yaba-karranda. Nyulu yalaman, “Jana, wungar, kija, dawar 11-bala, jana dukul badamarin ngaykundu.” Nganjanangka nyungun murru-kangan, yalaman, “Nganjin, ngayu, yunu ngamu, yunu yaba-karra, nganjin yunundu kari dukul badamal, yundu kari majamal nganjinanka.” Josephamu yaba-karra kuli-kadarin, wawu-kariman bajaku nyungunku. Yamba nganjanangka bijarr milkabu wukurrin. ");
INSERT INTO gvn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","24","Josephandamundu yaba-karrangka sheep-sheep kujil-kujinya bubungu Shechem. Jacobangka Joseph jananda yungan, nyajinka, jana nguba ngulkurrku bundandan, nguba kari. Joseph dunganda, yaba-karrangka nyungun nyajin kankadanya. Jana yalaman, “Nyulukulu bijarr-bakakulu kankaday. Ngana nyungun yarkinkaku kuninka, nganjananda balkanka minyabu kulijingka nyungun kunin, yarkin-bankuda. Nyungu bijarr kari manubajamalda.” Reuben, nyulu jakalbamunku, nyulu wawu kari Joseph yarkinkaku kuninka. Nyulu yalaman, “Kari kuni. Yilba wellmunbu dajalimunbu.” Yinya well marral, bana yamba-kari. Joseph kadan, jana nyungun karrban, nyungundumun kambi walngan, nyungun yilban wellmunbu. ");
INSERT INTO gvn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","28","Jana mayinga nukan-nukajin, kanbal dingkar-dingkar janandarrku kankadan, dungan-dunganya bubungu Egyptmunbu. Judahngka yalaman, “Ngana Joseph kari kuni, nyulu ngananga yabaju. Nyungun dingkar-dingkaranda sellim-banka moneyka.” Jana Joseph wellmun jarra-kulban, sellim-ban moneyka. Jana dingkar-dingkarangka nyungun naka wundin bubungu Egypt. ");
INSERT INTO gvn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","35","Nyunguwundu yaba-karrangka goat kunin, nyungu kambi mulabu daman. Jana kambi wundin nganjananda, yalaman, “Nganjin yanyu kambi warrmba-bungan. Yinya yunuwunbu kangkalba?” Jacobangka yalaman, “Yuwu, yinya kambi ngaykuwunbu kangkalamu. Minyabu kulijingka nyungun yarkin-ban.” Jacob Josephanka badin wuljaljiku. ");
INSERT INTO gvn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","(37:36; 39:1-6) Jana dingkar-dingkarangka Joseph bubungu Egyptmunbu wundin, sellim-ban Potipharanda. Potiphar, nyulu maja bubuku Egyptanka. God Josephanji bundanya, Joseph ngulkurr bajaku workmanijin. Potipharangka Joseph nyajin ngulkurrku workmanijinya, nyulu Joseph maja-bungan nyunguwunku bayanka, yamba-yambaka. Godungku yinyaynka Potipharamu junjuy-junjuy, and yamba-yamba jirray-ban. ");
INSERT INTO gvn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","23","Joseph ngulkurrijin bajaku. Potipharamu manyarr kuruku bundan Josephanka. Nyulu Josephanda yalaman, “Ngaykunji wunay.” Josephangka yalaman, “Kari. Ngayu wawu kari yununji wunanka. Potipharangka nganya maja-bungan yamba-yambaka wubulkuku, yamba yundu nyunguku manyarr. Kaki ngayu yunun wunay, God kuli-kaday ngaykunku.” Warngku yindu-yindu Potipharandamundu manyarrangka Joseph kunjanya, yamba Josephangka kari wunan nyungun. Wawu yinyamun Joseph bayanba walan workmanijinka. Potipharamu manyarr, nyulu nyulurrku bayanba, kanbal ngalkalba. Nyulu Potipharandamundu manyarrangka Josephamu kambi karrban, yalaman, “Ngaykunji wunayda.” Josephangka kambi bawan, ngalkalbada warrin. Nyulu manyarr kuli-kadan Josephanka, kanbal kunjan. Nyulu jurrilda balkan jananda, “Yinya dingkar, nyulu balu ngaykunji wunanyaku; kari, ngayu jinbalku yirrkajin, nyulu warrinda. Nyaka, kambi nyungu yanyunya.” Potiphar bayanbaku kadan, nyulu manyarr nyungu kuku jurril nyajin, nyulu yalarrku kuli-kadan. Nyulu Joseph mumban jailmunbu. Kari, Godungku Joseph nyajil-nyajin, buliman nyungunku ngulkurr bajaku. Nyulu bulimanangka Joseph maja-bungan kanbalanka jailba. ");
INSERT INTO gvn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","8","Nyubun bama king bubuku Egyptmunku. Nyulu kuli-kadan dingkar-bulalanka jambulinka nyungundu workmalman. Nyulu nyubunyinja wine wundinya kinganda, yindu baker kingamu. Nyulu kingangka bulanin mumban jailba yinyay Joseph bundandan. Bula ngadingka jailba bundan. Bula juma jambulinjaku jailba bijarrin. Warngku yindu Joseph bulanda kadan, bula jirrbu-jirrbuku bundandan. Nyulu bulanda babajin, “Yubal wanyurrinku milka-bujarmalmal?” Bula yalaman, “Ngalin bijarrin, yamba bama yamba-kari, ngalinyanda bijarr milkanga-bunganka.” Josephangka yalaman, “Godku binal bajaku bijarrka. Ngaykundu balka.” ");
INSERT INTO gvn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","15","Yinyayangka dingkarangka wine wundin-wundinya kinganda, nyulu bijarr balkan Josephanda. Nyulu yalaman, “Ngayu kalal grape nyajin, dakil kulur. Nganka balkajin, mayi kulbulmanda. Ngayu mayi dingkan, yira manin, kingandamunbu cupmunbu nyangarrin, nyungu dajinda.” Josephangka nyungundu yalaman, “Ngayu bijarr milkanga-bungal. Yinya dakil kulur yala warngku kulur. Warngku kulurmal kingangka yunun kunjal, wine nyungu wundinka baja yala yundu jakalbaku wundin. Yundu dungay baja, kinganda balka ngaykunku, ngayu kari buyunman. Jana nganya wumbabuku mumban jailba.” ");
INSERT INTO gvn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","19","Yinyamun yinyangka bakerangka Josephanda yalaman, “Ngayu bijarr balkal yunundu. Ngayu balji kulur mayiji jarra-kulbal-kulban dukulbu. Baljinga wuyar cake walu-yindu walu-yindu. Dikalangka wubuliynjaku yinya cake nukal-nukan.” Josephangka yalaman, “Ngayu bijarr milkanga-bungal. Balji kulur yala warngku kulur. Warngku kulurmal kingangka yunun dukul kankuruku nyandal, yarkin walngkan-damal jukungu. Dikalangka wubuliynjaku yunun bangkarr nukal.” ");
INSERT INTO gvn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","23","Warngku kulurman kingamu birthday. Nyulu mayi jirray wayjun partyka, nyunguwunbu workingmananga. Kingangka dingkar kunjan, wine nyungu wundinka baja nyunguwunbu bayanba, yala Josephangkaku balkan. Nyuluji baker, kingangka nyungun yarkinkaku dukul nyandan, yarkin walngkan-daman yala Josephangkaku balkan. Wawu yinyamun yinyayangka wine wundinya kinganda, nyulu Josephanka milka-wulanda, kinganda kari balkan nyungunku. ");
INSERT INTO gvn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","8","Wawu yinyamun years jambulman, kingangka bijarr jambul bijarrin. Nyungu bijarr yalaku: nyulu king wawubajanga Nile janjanan, bulki 7-bala wandul bajaku wawubajamun wandin. Jana bulkingka jikan nukal-nukan, bulki 7-bala jirburr-jirburr wawubajamun wandinda, jananin bulki wandul-wandul nukanda. Nyulu king warngkumun wandinda, yinyamun warngku wunan baja, bijarrin baja. Bijarr yalaku: jurrbu nyubun dakan, corn, dakil 7-bala mayiji jaba-jabaji. Mayi 7-bala yindu balkajinda, buyun bajaku. Yinyamundu buyundu mayingka ngulkurr mayi buyun-daman. Warngku yindu nyulu king milka-bujarman, jana nyungundu bijarr kari milkanga-bungan. ");
INSERT INTO gvn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","13","Dingkarangka wine wundinya kingamu, nyulu kinganda yalaman, “Ya, ngayu Josephanka milka-wulan, ngayu binal nyungunku. Ngadiku yundu kuli-kadan ngalinyanka bakeranka, ngalinyan mumban jailba. Ngalin jailba bijarr-bijarrji wunan. Joseph nyulu ngalinyanda bijarr milkanga-bungan. Nyulu balkan yundu nganya kunjal, yundu baker yarkinkaku yakal. Nyulu junkaynjaku balkan, manubajabuku.” ");
INSERT INTO gvn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","24","Kingangka Joseph kunjan. Joseph walarr yakajin, kambi ngulkurr didan, kinganda kadan. Kingangka Josephanda yalaman, “Ngayu bijarrin, yamba bamangka murruji bijarr milkanga-bunganka. Ngayu yununku kuku nyajin, yundu bijarr milkanga-bungal.” Josephangka yalaman, “Ngaykuwundu Godungku yunu bijarr milkanga-bungal, kuku ngulkurr dajil.” Kingangka Josephanda yalaman, “Ngayu bijarrin, ngayu wawubajanga Nile janjanan, bulki 7-bala wandul bajaku, ngulkurr bajaku wawubajamun wandin. Jana bulkingka wandulungku jikan nukal-nukan, bulki 7-bala jirburr-jirburr wawubajamun wandin. Jana jirburr-jirburrungku bulki wandul-wandul nukanda. Ngayu warngkumun wandinda, yinyamun warngku wunan baja, bijarrin baja. Jurrbu nyubun dakan, corn, dakil 7-bala mayiji jaba-jabaji. Mayi 7-bala yindu balkajinda, buyun bajaku. Yinyamundu buyundu mayingka ngulkurr mayi buyun-daman. Ngayu bamanda bijarr balkan, yamba jana murruji milkanga-bungan.” ");
INSERT INTO gvn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","36","Josephangka kinganda yalaman, “Jambul bijarr, yamba kuku nyubunku. Godungku yunun milka-bakan, nyulu wanjarrmanka. Bulki 7-bala wandul-wandul and 7-bala mayi jaba-jaba yala-karrajiku, 7 yearanka. Bulki 7-bala jirburr-jirburr, 7-bala mayi buyun yalarrku 7 yearsanka. Yaluy bubungu Egypt mayi jirraymal 7 yearsmunku. Wawu yinyamun mayi yamba-karimalda 7 yearsmunku. Yundu dingkar binal bajaku mana, junjuy-junjuynku binal yindu-yinduynku. Mayi jirraymal, nyulu dingkarangkala dingkar-dingkar kanbal yungal, mayi mujanka. Jana yinya mayi yalbaymba binba yijarrinka, townbuku yindu-yinduymbu kujinka bamanka wubulkuku. 7 yearsmal mayi kari dakil baja, bamangka yinya mayi binmun buban-bubanku nukal-nukal, mayi townmun manil.” ");
INSERT INTO gvn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","45","Kingangka Josephanda yalaman, “Godungku yunun binal-bungan. Yundu majamaka bubuku Egyptmunku. Yundu ngayku junjuy-junjuy kuji, yundu bama bubuku Egyptmunku ngulkurrduku kuji ngaykunku.” Kingangka nyungu ring walngan maramun, Josephanda maranga didan, milbinka bamanda Joseph majamanda. Nyulu king maja bajaku, yamba nyulu Joseph yalarrku maja. Nyulu kingangka kambi ngulkurr bajaku dajin Josephamu, necklace ngulkurr yalarrku dajin. Nyulu Josephamu jalbu ngulkurr dajin manyarr-bunganka. Jalbu burri Asenath. Bula kangkal dingkar-bulal jambul manin, burri dajin Mannasseh and Ephraim. ");
INSERT INTO gvn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","57","Joseph 30 years oldmanda yala-yala nyulu kingandada workmalman. Yala-yalaku mayi jirray dakal-dakarin, Josephangka dingkar-dingkar yungan, jana mayi jirray mujal-mujan, townbu yindu-yinduymbu wubulku yijarrin. Wawu yinyamun mayi yamba-karimanda. Bama kinganda babajin mayika. Kingangka yalaman, “Josephanda dungay, nyungun kuku-nyaka.” Josephangka mayi manin jana mujan, bamanda dajin moneyka. Bubungu wubulbuku mayi yamba-kariman, jana bama bubumun wubulmunku kadan, mayi maninka Josephandamun moneyjiku. ");
INSERT INTO gvn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","4","Bubungu Canaan mayi yamba-kariman. Jacobangka kuku nyajin mayi jirray bajaku bubungu Egypt. Nyulu kangkal-kangkalanda yalaman, “Yurra bubungu Egyptmunbu dungay, mayi moneybu mana ngananga.” Josephamu yaba-karra 10-bala dungarinda. Jacobangka kangkal Benjamin kari yungan yaba-karranji, nyulu kudamundumun. Nyulu Jacobangka yalaman, “Ngayu murru-kaday nyungunku, nyulu yurrajinji.” ");
INSERT INTO gvn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","7","Josephamu yaba-karra bubungu Egyptanda kadan, jana Josephanda dukul badaman. Nyulu jananka binal, yamba jana nyungunku binal kari. Nyulu jurrilman, kuli-murubuku yalaman, “Yurra wanjamun?” Jana yalaman, “Nganjin bubumun Canaanmun kadan, mayi maninka.” ");
INSERT INTO gvn_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","17","Nyungundu Josephanda bijarrda milkanga kadan nyunguwunku yaba-karranka. Nyulu yalaman, “Yurra kadan bama nyajinka, bubu walu-wukurrinka. Yurra juma kaday baja bamanji kulijinji, kuniwanka nganjinanji.” Jana yalaman, “Kari. Nganjin kadan mayi maninka. Nganjin yaba-yabaju, nganjananka nyubunyinkaku bubungu Canaan. Yabaju kudamundumun nganjananjiku bundanday, yabaju nyubun wulaynda.” Josephangka yalaman, “Ngayu binalmanka, kaki yurranga kuku manubajaku. Kaki yurranga yabaju kadayda, yurra bayanbaku dungay baja bubunguku. Nyubunku yurrandamun dungay, yurranga yabaju wundi baja. Yurra kanbal jailba bunday. Kaki yurranga kuku manubajaku kari, ngayu yurranka binalmalda, yurra kadan, nganjinanji kuniwanka.” Nyulu jananin wubulku mumban warngku kulur jailba. ");
INSERT INTO gvn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","25","Warngku kulurman Josephangka jananda yaba-karranda yalaman, “Yurra nganya kuku-nyaka. Nyubun nyulurrku bunday jailba, yurrajin kanbal dungay, mayi wundi jawun-karranda. Kaki yurra yabaju wundil ngaykundu, ngayu binalmal yurranga kuku manubajaku. Kaki yurranga kuku manubajaku, ngayu yurranin kari kunil.” Jana yaba-karra kukuku Egyptmunku binal kari. Joseph jurrilman, nyulu janawunku kukuku binal. Yinyaynka nyulu jananda balkan kukubu Egyptmundu. Yindu dingkar yinyaymba janjanan, nyulu kukuku jambulku binal. Nyulu yaba-karranda janawundu kukubu balkan wanyu Josephangka balkan, Josephanda kukubu Egyptmundu balkan wanyu yaba-karrangka balkan. Yaba-karra balkawan jana-karrajiku kukubu janangunduku. Jana yalaman, “Ngana yabajunku buyunman, Josephanka. Ngana nyungun nyajin milka-bujarmanya, banbadinya, because ngana nyungun sellim-banka, yamba ngana bayjan, nyungun kari kuku-nyajin. Yinyaynka Godungku kuli dajil-dajin ngananda.” Reubenangka yalaman, “Ngayu yurranda balkan kari buyunmanyaku yabajunku. Yamba yurra kari milka-janan.” Nyulu Joseph binal janawunku kukuku. Yinyaynka nyulu dumu jurrkijin janandamun, nyulu badinda. Wawu yinyamun nyulu Simeon karrban, karrabu kajan. Josephangka kiraynjaku yalaman dingkar-dingkaranda workingmananda, “Canaan-warranga kurmun jakal-bunga mayibu. Jananga money mumba baja kurmunbuku, mayi daya jananga, baraldarr nukanka.” Jana dingkar-dingkarangka yalaman, “Yalada.” ");
INSERT INTO gvn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","28","Josephandamundu yaba-karrangka mayi kajan donkeynda, dungaynda. Wujurrman jana miyil warngku-kadanda baraldarrku, nyulu nyubunyinja yabangka mayi walngan kurmunmun, dajinka donkeynda. Nyulu money nyajin mayinga wuyar wunananya. Nyulu yaba-karranda yalaman, “Ngayku money kurmunbuku wunanay.” Jana yinyilmarin, yalaman, “Godungku wanjarrmalmal ngananda?” ");
INSERT INTO gvn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","38","Jana nganjanandaku Jacobandaku kadan baja, nyungundu balkan junjuy-junjuynku. Jacobangka jananda yalaman, “Bula Joseph, Simeon yaluy kari. Yurra Benjaminkuda wundinka. Yinyangka nganya milka-bujar-manil.” Reubenangka nganjananda yalaman, “Ngayuku Benjamin ngulkurrduku kujil. Kaki ngayu nyungun kari wundil baja yunundu, yundu ngayku kangkal-bulal kuni.” Jacobangka yalaman, “Ngayku kangkal kari yurranji dungay, ngayu kari yungal.” ");
INSERT INTO gvn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","14","Jananga mayi bubumun Egyptmun kunbanda, nganjanangka Jacobangka yalaman, “Dungay baja, mayi maninka ngananga.” Judahngka yalaman, “Kaki nganjin Benjamin kari wundil nganjinanji, nyulu majangka mayi kari dajil.” Nyulu Jacob wawu-kari yunganka, yala-yalaku. Yamba nyulu juma yalaman, “Yala. Yunu yabaju wundi, present ngulkurr majanda daya. Money kurmunbu wunananya daya baja nyungunduku. Jana nguba milka-wulan moneyka. Money kanbal wundi baja, mayi maninka. Dungayda.” ");
INSERT INTO gvn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","24","Jana dungarinda. Jana Josephanda kadarin, nyulu Benjamin nyajin. Nyulu yalaman dingkaranda nyungu bayan kujil-kujinya, “Yundu jananin dingkar-dingkar bayanba walay-mana. Mayi, minya yalbayku wayju. Jana ngaykunji mayi nukal.” Dingkarangka mayi yalbayku wayjun. Jana yaba-karra Josephandamunbu bayanba kadarin, jana yinyilmarin, yalaman dingkaranda Josephanda workmanmanijinya, “Nganjin binal kari, wanjungku baja money yijarrin nganjinandamunbu kurmunbu jakalbaku? Nganjin yinya money wundin baja, nganjin yalarrku money kanbal wundin mayika.” Dingkarangka yalaman, “Kari yinyilmarika. Ngayu yurranga money jakalbaku manin. Kunka Godungku kanbal money yijarrin yurrawunbu kurmunbu.” Yinyamun dingkarangka Simeon walngan jailmun, jana wubulku Josephandamunbu bayanba walan. ");
INSERT INTO gvn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","34","Joseph bayanbaku kadanda, nyungu yaba-karra dukul badaman nyungundu, present dajin nyungundu. Josephangka babajin, “Yurranga nganjan yalada?” Jana yalaman, “Nyulu yalada, ngulkurrku bundanday.” Jana Josephanda dukul badaman baja. Nyulu Josephangka Benjamin nyajin, jananda babajin, “Yanyuji yurranga yabaju?” Nyulu wawurr-wawurrmanijin, Benjaminanda yalaman, “Ngayu wawu nyajinka Godungku yunun wawurr-wawurr-bunganka.” Nyulu balu badinka; kari, nyulu wawu kari badinka jananda miyilba. Nyulu jinbalku yinduymbu kananga walan, badin, badin, kunbayn. Nyulu walu julurrijin, kadan baja. Jana mayi nukanjiku, nyulu Josephangka yabangarr jakalba bunday-manin, yabaju kanbal karangkalba, yalaku. Jana kungkurr-kadarin, jana-karrajiku nyajiwan, yalaman, “Nyulu wanjarrku binal, nganjinin yalaku bunday-maninka, jakalbamun bada warrundumunku?” Josephangka mayi jananda wamban, nyulu mayi yalbayku wamban Benjaminamu. Jana nukajinda. ");
INSERT INTO gvn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","9","Josephangka juma yalaman dingkaranda nyungundu workmanijinya, “Jananga dingkar-dingkaramu kurmun wubulku jakal-bunga mayibu, ngami-ngamiku money mumba janawunbu kurmunbu. Ngayku cup ngulkurr mumba kurmunbu Benjaminandamunbu.” Dingkarangka mayibu kurmun jakal-bungan, money, cup mumban. Warngku yindu Josephamu yaba-karra dungarinda, bayanbaku dungarinka baja. Josephangka workingmananda yalaman, “Yundu jananin juru-mana, jananda balka jana ngayku cup ngulkurr ngakin.” Dingkarangka jananin juru-manin, babajin, “Wanyangka majamu cup ngulkurr ngakin?” Jana yalaman, “Kari. Nganjin cup kari ngakin. Kaki yundu wanyandamunbu kurmunbu warrmba-bungal, yundu nyungun yarkinkaku kuni. Nganjin kanbal yunuwunbu majamu slavemal.” ");
INSERT INTO gvn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","17","Dingkarangka yalaman, “Kari. Yinyayangkaku cup ngakin, nyuluku slavemal. Yurra kanbal dungarika.” Nyulu cup nubin, yindu-yinduymbu kurmunbu nyajin, nyulu kurmunbu Benjaminandamunbu cup warrmba-bungan. Josephamu yaba-karra kungkurr-kadarin, yinyilmarin. Jana Josephanda nyunbarin baja, yinyiljiku, dukul badamarin nyungundu. Josephangka yalaman, “Ngayu yurranka binal bajaku. Yurra wanyurrinku cup ngakin?” Judahngka yalaman, “Nganjin binal kari, yundu nganjinanda wanjarrmal? Nganjin buyunman, yundu nganjinin slave-bungal.” Josephangka yalaman, “Kari. Yinyangkaku ngayku cup ngakin, nyuluku slavemal. Yurra kanbal yurrandamunbuku nganjanandaku dungarika baja.” ");
INSERT INTO gvn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","34","Judahngka Josephanda balkan, “Maja, balu ngayu yununji balkawaka. Yundu maja bajaku, yala king. Ngaykunku kari kuli-kaday. Nganjin jakalbaku kadan, yundu nganjinanda babajin, ‘Yurranga nganjan wunay? Yabaju yindu wunay?’ Nganjin balkan, ‘Nganjinanga nganjan wulman bajaku, yabaju bayanbaku, nyulu balkajin nganjanandamunku wulmanandamun. Nganjinanga yabaju yindu wulan, bulanga ngamu nyubunku. Nganjinanga nganjan nyungunku wawu jirray bajaku.’ Yundu nganjinanda balkan yabaju wundinka, yundu nyajinka. Nganjin balkan yabajungku nganjan kari bawal, nganjan wulanji. Yundu yalaman, ‘Kaki yurra yabaju kari wundil, yurra nganya kari nyajil baja, mayi kari manil ngaykundumun.’ Nganjin nganjanandaku dungarin baja, yunu kuku balkan nyungundu. Juma nyulu yalaman baja, ‘Yurra dungarika baja, mayi maninka.’ Nganjin nyungundu balkan baja, ‘Nganjin kari dungari yabaju-kariku. Kaki yabaju nganjinanji kari, majangka nganjinin kari nyajil. Nganjin must yabaju wundi.’ Nganjanangka yalaman, ‘Ngaykuwunbu manyarramu Rachelamu kangkal-bulal jambul. Nyubun minyabu kulijingka nyungun yarkin-ban, ngayu nyungun kari nyajin baja. Kaki yurra Benjamin ngaykundumun wundil, nyulu nguba kari kaday baja. Ngayu wulayda, milka-bujarku.’” Judahngka yalaman baja Josephanda, “Kaki ngayu nganjanandaku dungay baja yabaju-kariku, nyulu wulaykuda, milka-bujarku. Ngayu nyungun promiseim-ban, yabaju wundinka baja. Kaki ngayu nyungun kari wundil baja, ngayu malaji. Yinyaynka yundu nganyaku slave-bunga, ngayu yabaju karrnga-dajinka. Nyungun nganjanandaku yunga. Ngayu kari nganjanandaku dungay baja yabaju-kari. Ngayu wawu kari nganjan nyajinka milka-bujarku wulanka.” Judahngka yalaku Josephanda balkan. ");
INSERT INTO gvn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","15","Nyulu Josephangka yinya kuku nyajin, nyulu balu badinyaku. Josephangka nyungu workingman ngalkalba yungan. Nyulu yaykarrku badinda. Egypt-warrangka nyungun nyajin banbadinya, jana kinganda balkan. Nyulu Josephangka yaba-karranda yalaman, “Ngayu yurranga yabaju Joseph. Ngayku nganjan juranku?” Yaba-karra yinyilmarinyarrku, kungkurr-kadarinyarrku, kuku-karimarin. Nyulu yalaman, “Yurra nganya ngadiku dajin bamanda, jana nganya yalaymba bubungu Egypt wundin. Yurra kari nyajijika. Godungkuku nganya jakalba yungan, yurranin juran-bunganka mayibu. Nyulu nganya maja-bungan, ngayu bama bubuku Egyptmunku ngulkurrduku kujil-kujil. 2 yearsmunku nganjin mayi kari nyajin dakanya yaluy bubungu; 5 yearsmunku mayi kari nyajil baja. Godungkuku nganya jakalba yungan yurranka, yurra mayijiku bundandanka. Nyulu wawu kari nyajinka yurranin wularinya. Nyulu wawu yurranga kangkal-kangkal juranku bundandanka. Yurra kari nganya yungan, Godungkuku. Nyulu Godungku nganya maja-bungan bubuku Egyptmunku. Nganjanandaku jinbalku dungay baja, nyungundu balka nyulu jawun-karra, junjuy-junjuy wubulku wundi bubungu Egyptmunbu. Mayi yamba-kariburr ngayu yurranin ngulkurrduku kujinka. Ngayu wawu kari nyajinka yurranin mayi-karimun wularinya. Ngayu Josephkuda. Ngayu manubajabuku yurranda balkan-balkal.” Nyulu Benjamin baru karrban, milbal muruku, yinyamun yaba-karrada. Yinyamun jana balkawan. ");
INSERT INTO gvn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","24","Kingangka kuku nyajin Josephandamunku yaba-karranka, nyulu wawurr-wawurrmanijin. Nyulu Josephanda yalaman, “Yaba-karranda balka wagon wubul wundinka janawunbu bubungu, nganjan and jawun-karra maninka, yaluy wundinka, bundanka.” Josephangka jananga mayi, kambi dajin baralka. Nyulu Benjaminamu money jirrayku dajin, kambi wubulku. Nyulu mayi and minya yungan nganjananga. ");
INSERT INTO gvn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","28","Yaba-karra dungan baja bubunguku Canaanku, nganjananda Jacobanda balkan Josephanka. Jacob kungkurr-kadan, kuku-kariman. Juma nyulu yalaman, “Ngayu yurranin kari kuku-nyajil. Yurra jurril-bal-bal.” Yamba nyulu wagon wubul nyajin Josephangka yungan. Yinyaynka nyulu yalaman, “Yurra junkaynjaku balkan, jurril kari. Joseph jurankubi. Ngayu dungay, nyungun nyajinka, ngayu wulanjiku.” ");
INSERT INTO gvn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","4","Jacobangka nyungu yamba-yamba wubulku manin, dungan townbu Beersheba. Nyulu minya wayjun, dajin Godundu, nyungun buyay-maninka. Godungku nyungundu yalaman, “Ngayu God. Yunuwundu nganjanangka nganya kuku-nyajin, nyulu milkanga ngaykunjiku bundandanya. Kari yinyilmaka bubungu Egyptmunbu dunganka. Ngayu yinyaymba bama yunundumun wubul-bungal. Ngayu yununji dungay, bama yunundumun wundil baja. Yundu yinyaymba Josephandaku wulay.” ");
INSERT INTO gvn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","27","Jana, Jacob, nyungu kangkal-kangkal and jananga kangkal-kangkal, jana naka bubungu Egyptmunbu dunganda. Jana Egyptmunbu kadan, yala Jacobamu jawun-karra 70-bala. ");
INSERT INTO gvn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","34","Jacobangka Judah jakalba yungan Josephanda, balkanka jananin maku-nyajinka bubungu Goshen. Joseph kadan, nyulu nganjan baru karrban, ngadingka badin. Nyunguwundu nganjanangka yalaman, “Ngayu yunun nyajinda, ngayu wawurr-wawurrku wulayda.” Josephangka yalaman jananda, “Ngayu dungayda, kinganda balkanka yurra kadarinda, minya minday wubulku wundinda. Yurra nyungundu balka yurra minya minday kujil-kujinya. Bama bubuku Egyptmunku, jana wawu kari nyajinka bama minya minday kujil-kujinya. Yinyaynka kingangka yurrangan yinduymbu bubungu yungal, bubungu ngulkurrbuku Goshen.” ");
INSERT INTO gvn_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","6","Joseph kinganda dungan, nyungundu balkanda, “Ngayku nganjan and jawun-karra bubungu Goshen bundanka.” Nyulu Josephangka yaba-karra 5-bala wundin, kinganda milbinka. Kingangka jananda babajin, “Yurranga work wanyu?” Jana yalaman, “Nganjin minya minday kujil-kujinya yala nganjanangka, kamingka. Mayi yamba-kari minyanka bubungu Canaan. Nganjinin bubungu Goshen yunga.” Kingangka Josephanda yalaman, “Yunuwunbu nganjananda and yaba-karranda balka bubungu ngulkurrbuku bundanka Goshen. Kaki kanbal binal bajaku minyanka, jananda balka ngayku minya minday yalarrku kujinka.” ");
INSERT INTO gvn_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","12","Josephangka nganjan wundin kinganda. Kingangka babajin, “Yundu wanjarrkuda, wulman?” Jacobangka yalaman, “Ngayu ngadimun bajaku, ngayu wulman bajaku, 130 years old.” Jacobangka kinganda yalaman, “Ngayu wawu nyajinka God ngulkurrmanka yununku.” Yinyamun nyulu king bawanda. Josephangka nganjanamu and yaba-karramu bubu ngulkurr dajin, mayi yungan jananga. ");
INSERT INTO gvn_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","19","Mayi yamba-kari bubungu Canaan, bubungu Egypt. Bamangka mayi moneybu manin Josephandamun, nyulu money dajin kinganda. Juma bamangka Egyptmunku Josephanda yalaman, “Nganjinanga money yamba-karida. Nganjin yararri bajaku, mayi yamba-karimun. Mayi daya.” Josephangka yalaman, “Minya minday daya ngaykundu, ngayu mayi yurranga dajilda.” Bamangka minya minday dajin Josephanda, nyulu jananga mayi dajin. Jana bama juma Josephanda kadan baja, yalaman, “Nganjinanga money and minya minday kunbanda. Nganjin yararri bajaku, mayi yamba-karimun. Nganjinamu bubu mana, or nganjin yunundu workmaniji, mayi maninka. Kaki yundu nganjinanga mayi dajil nukanka, diburr yalarrku daya nandanka, nganjin yunu junjuy-junjuy wubulku dajinka baja.” ");
INSERT INTO gvn_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","26","Josephangka jananda bamanda bubungu Egyptmunbu yalaman, “Kari milka-wulay yurra kinganda daya baja, diburrmun yurra mayi manil. Mayi balkajida, yurra buban daya kinganda, kanbal kuji mayika, diburrku.” Bama wawurr-wawurrmanijin, yalaman, “Nganjin juranku bundayda, kari wulay. Nganjin wawurr-wawurrku workmaniji kinganda.” ");
INSERT INTO gvn_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","9","Bamangka juma Josephanda yalaman, “Yunu nganjan bambayman.” Yinyaynka Joseph, nyungu kangkal-bulal dingkar-bulal jambul, Manasseh and Ephraim, jana dungarin, Jacob nyajinka. Jacobangka Josephanda yalaman, “God nguwimal milbijin ngaykundu, townbu Bethel, bubungu Canaan. Nyulu ngaykundu balkan bama wubulmanka ngaykundumun, nyulu Godungku jananga bubu Canaan dajinka. Yunu kangkal-bulal, bula balkajin bubungu Egyptmunbu, ngayu kadanjiku, yamba bula yalarrku ngayku. Bulanin wundi ngaykundu, ngayu bulanin blessing-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","22","Nyulu Jacob wulman bajaku, nyulu miyil-burraman. Josephangka bulanin Ephraim, Manasseh yubaku wundin nyungundu, Jacobangka bulanin baru karrban. Nyulu Josephanda yalaman, “Ngayu kunbayda yurranka; Godungku nganya kujinyarrku, yunun and yunu kangkal-bulal nyajinka.” Josephangka yaba Mannaseh yijarrin yubaku Jacobanda right handanda, yabaju Ephraim yuba-bungan Jacobanda left handanda. Jana yalaku, right hand yijarrinya kangkalanda jakalbamun. Kari, Jacobangka nyungu right hand yijarrin Ephraimanda dukulbu, nyungu left hand yijarrin Manassehnda dukulbu. Josephangka nyajin, nyulu nganjanamu mara manin, yalaman, “Manasseh jakalbamun. Yundu yunu right hand yijarrika nyunguwunbu dukulbu.” Jacobangka yalaman, “Kari, ngayu binal ngayu wanjarrmalmal. Bama wubulmal Manassehndamun, yamba bama wubulmal bajaku Ephraimandamun.” Jacobangka yalaman, “Godungku ngulkurrduku kujin, Abraham, Isaac, nganya. Ngayu wawu nyulu yalarrku yaluy-bulal warru-bulal ngulkurrduku kujinka.” Nyulu Josephanda yalaman, “Ngayu kunbayda yurranka. God yununji bunday, yunuwunji kangkal-kangkalanji. Nyulu yurrangan wundil baja bubunguku Canaanku.” ");
INSERT INTO gvn_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","27","Jacobangka kangkal-kangkal wubulku kunjan, jananda balkanka juma jana wanjarrmanka. Nyulu Judahnda yalaman, “Bama Judahndamun wubulmal. Jana maja-majamal; juma maja jirray bajaku kaday. Wubuliynjaku bamangka nyungun kuku-nyajil.” Nyulu kangkal-kangkalanda wubuliymbaku balkan, nyubunyimba-nyubunyimbaku. ");
INSERT INTO gvn_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Jacobamu kangkal-kangkal 12-bala. Bama janandamun kadan, burri Israel-warra, burri yindu Jew-warra. Israel-warramu jawun-karra wubulman yaba-karrandamun, Jacobandamun kangkal-kangkalandamun. ");
INSERT INTO gvn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","33","Jacobangka yalaman, “Ngayu kunbayda yurranka. Nganya nanda cavemunbu kuljinga bubungu Canaan.” Jacob kuku kunban, nyulu wulanda. Nyulu 147 years old. ");
INSERT INTO gvn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","13","Josephangka nganjan karrban, banbadinda. Nyulu workingmananda balkan junjuy-junjuynju julngkanka, nyungu nganjan bangkarr buyunmanji, kabumanji. Kija kulur jana banbadarin. Josephangka dingkar-dingkar kukuji yungan kinganda, balkanka, “Ngayu nganjan promiseim-ban ngayu nyungun nandanka bubungu Canaanbaku. Nganya yungada. Ngayu nyungun nandal, kaday baja.” Kingangka kuku yungan, “Yala, dungayda.” Jana, Joseph, nyungu yaba-karra, maja-maja wubul bubuku Egyptmunku, jana bubungu Canaan dungarinda. Jana bubungu Canaan kadarin, warngku wubul yaykarrku badirin. Jacobandamundu kangkal-kangkalangka nyungun nandanda kuljinga, karangkalba nganjananda, kaminda. ");
INSERT INTO gvn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","21","Jana, Joseph, nyungu yaba-karra, bama wubulku nyungunji, jana bubunguku Egyptmunbuku kadarin baja. Yaba-karra Josephanka yinyilman. Jana murru-kadarin nyungunku, nyulu nguba kuli-kaday, jana ngadiku nyungu kuli dajinya. Jana yalaman nyungundu, “Ngadiku nganjin buyunman yununku. Nganjin milka-bujar yinyaynka buyun-buyunku. Yundu milka-wulayda buyunku nganjin balkanya. Nganjin yunun kuku-nyajilarrku.” Joseph badinda, kuku ngulkurrku balkawan jananda. Nyulu yalaman, “Kari yinyilmaka. Yurra ngaykunku ngadiku buyunman; kari, Godungku nyulu bama wubulku juran-bunganka ngaykundumundurr. Godungku nyuluku yurranin mambarrin nganya jananda bamanda dajinka, bama wubul juran-bunganka, mayibu. Ngayu yurranin ngulkurrduku kujinka.” ");
INSERT INTO gvn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","26","Jana, Joseph, nyungu jawun-karra, jana bubungu Egypt bundandan. Nyulu Joseph wulmanman, ngadingka bundan, 110 yearsanka. Nyulu nyunguwunbu jijanga kangkal-kangkal nyajin. Nyulu jawun-karranda yalaman, “Ngayu kunbayda yurranka. Godungku yurranin wundil baja bubunguku Canaanku. Nyulu yinya bubu dajin Abrahamamu, Isaacamu, Jacobamu. Yurra nganya promiseim-bunga, yurra nganya wundinka baja yurranjiku, nganya nanda bubungu Canaanku.” Joseph wulanda, jana junjuynju nyungun bangkarr julngkan, kabumanji. Yinyamun jana nyungun yarkin mumban yulalba. ");
INSERT INTO gvn_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","7","Jacobamu jawun-karra 70-bala, jana bubungu Egypt dungarin. Joseph, nyulu bubungu Egypt jakalba dungan. Juma Joseph, nyungu yaba-yabuju-karra wubulku wularin, yamba bama janandamun Israel-warra, jana wubulmarin bubungu Egypt. ");
INSERT INTO gvn_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","14","Yinyamun nyubun bama walu-yindu kingman bubuku Egyptmunku. Nyulu binal kari Josephanka. Nyulu nyunguwunbu bamanda Egypt-warranda yalaman, “Jana Israel-warra wubulmarinda, junkurrjida. Jana ngananji kuniwanji. Ngana wawu kari jananin nyajinka wubulmanka baja.” Yinyaynka Egypt-warrangka jananin slave-bungan, wawu-buyun-bunganka. Israel-warrangka town wubul balkan Egypt-warranga. Egypt-warrangka jananin Israel-warra buyun-daman, yamba jana Israel-warra wubulmalmankuda. Yinyaynka Egypt-warrangka jananin workim-ban baja, workim-ban baja, towndurr, paddockmundurr, jananka kari jiba-badin. ");
INSERT INTO gvn_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","22","Yinyamun majangka kingangka jananda Egypt-warranda yalaman, “Israel-warra ngawa-ngawa dingkar-dingkar balkaji, jananin mana, wawubajanga Nilemunbu yilba. Yamba jana kaykay-kaykay maral-maral balu juranku bundarika.” ");
INSERT INTO gvn_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","4","Nyubun bama, nyulu Levi-warrandamun, nyulu jalbu nyubun wunan, yalarrku Levi-warrandamun. Bulanga kangkal dingkar balkajin. Bula karrkay ngakin kija kulur, wawu kari wawubajanga yilbanka. Nyulu karrkay jarra yalbayman, ngamungku balji wukurrin, junjuynju yala burriwajabu julngkan, bana kari walanji. Nyulu ngawa kananga yijarrin baljinga, balji jikanba yijarrin yikinba wawubajanga. Karrkayamu babarr yubaku janan, jikanmun nyajil-nyajin. ");
INSERT INTO gvn_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","10","Kingamu kangkal jalbu wawubajanga kadan, janjinka. Nyungu jalbu-jalbu nyungundu workmalman, jana yikindarr dungan-dungan. Kingandamunbu kangkalanda balji nyajijin jikanba. Nyulu nyubun jalbu yungan, balji maninka. Kingandamundu kangkalangka balji walngan, ngawa nyajin, banbadinya. Nyulu jiba-badin nyungunku. Nyulu yalaman, “Ya, karrkay Israel-warrandamunbi!” Karrkayamu babarr nyulu warrin kingandamunbu kangkalanda, babajin, “Yundu wawu ngayu warrinka, jalbu Israel-warrandamun maninka, karrkay ngulkurrduku kujinka?” Kingandamundu kangkalda yalaman, “Yuwu, yala, dungayda!” Karrkayamu babarr warrin, bulangaku ngamu manin. Kingandamundu kangkalda ngawa ngawandamunbu ngamundu dajin. Nyulu ngamundu yalaman, “Yundu yanyu ngawa bayanbaku wundi, ngulkurrduku kuji. Ngayu yunun payim-bal.” Ngamungku ngawa bayanbaku kujin. Karrkay yalbayman, ngamungku nyungun kingandamunbu kangkalanda dajin. Kingandamundu kangkalda nyungun kangkal bamban, nyulu nyungu kangkalman. Nyulu nyuluku yalaman, “Ngayu nyungun banamun manin. Yinyaynka ngayu nyungun burri dalkil Moses.” Jananga kuku Moses mean ‘manin’. ");
INSERT INTO gvn_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","12","Nyulu Moses jaba-jabaman, nyulu kingandamun bayanmun dungan, nyungu jawun-karra nyajinka. Nyulu nyajin jana Egypt-warrangka nyungu jawun-karra slave-bunganya. Nyulu nyajin nyubunyinja dingkarangka Egyptmun nyubun dingkar Israelmun yarkinkaku kuninya. Yinyaynka Mosesangka yarra kuwa nyajin, yarra naka nyajin, yinyamun nyulu yinya dingkar Egyptmun yarkinkaku kunin. Nyulu nyungun yarkin jukaranga nandan. ");
INSERT INTO gvn_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","14","Warngku yindu nyulu jambul Israel-warra nyajin kunil-kuniwanya. Mosesangka nyubunyimba yalaman, “Yubal Israel-warra wanyurrinku jawun-karrajiku kunil-kuniway?” Nyulu dingkarangka yalaman, “Wanjungku yunun maja-bungan nganjinanka? Kuda yundu nganya kuninka yala yundu yinya dingkar Egyptmun yilayku kunin?” Moses yinyilmanda, nyuluku yalaman, “Jana binalmanda ngayu yinya bama yarkinkaku kunin.” ");
INSERT INTO gvn_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Nyulu kingangka yinya kuku nyajin, nyulu Moses kuninka, yamba Moses ngakijin, warrin bubungu Midiananda. ");
INSERT INTO gvn_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","21","Bubungu Midian Moses wellba bundandan, maral-maral 7-bala kadan, bana maninka janawunbu minyanga sheepanga, goatanga. Jana priestamu kangkal-kangkal, jananga nganjan priest burri Jethro. Jana yuba kadan wellba, kanbalangka shepherdangka jananin maral-maral kangan. Mosesangka yinya nyajin, nyulu kuli-kadan jananka shepherdanka, maral-maralanda hand dajin, minyanga bana dajinka. Juma jana maral-maral bayanbaku kadan, janawundu nganjanangka babajin, “Yurra wanyurrinku jinbalku bayanbaku kadan baja?” Jana yalaman, “Nyubun dingkar Egyptmun, nyulu wellba bundandan. Nyulu jananin shepherd kuli-baka kangan, nganawunbu minyanga bana dajin.” Nganjan babajin, “Nyulu wanjabuda? Yurra nyungun kari yinyaymba bawanyaku. Dungay, nyungun mana, nyulu ngananji mayi nukal.” Nyulu Moses jananji bundan, juma nganjanangka Mosesanda nyungu kangkal maral burri Zipporah dajin, wunanka. ");
INSERT INTO gvn_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","6","Yala-yalaku Mosesangka nyungu ngalayinamu minya sheep, minya goat kujil-kujin. Nyulu jananin bububurr marraldarr wundin, manjalba kadan, burri Sinai. Yinya Godumu manjal. Yuba manjalba Mosesangka baya nyajin duduymbu, yamba yinya duduy kari wayjujin. Mosesangka nyuluku yalaman, “Ya, yinya duduy wanyurrinku kari wayjuji? Ngayu yubaku dungay, nyajinka.” Moses yubaku dunganka, yamba Godungku nyungundu yirrkan duduymun. Nyulu yalaman, “Moses, Moses.” Mosesangka yalaman, “Yuwu, ngayu kukuuu.” Godungku yalaman, “Kari yuba kaday. Yundu dambal walnga, ngayu God yaluy, yundu bubungu dayirr-dayirrba janjanayda. Ngayu yunuwunbu nganjan-karramu God. Ngayu Abrahamamu God, Isaacamu God, Jacobamu God.” Mosesangka yinya kuku nyajin, nyulu yinyilman, walu nandajin, God kari nyajinka. ");
INSERT INTO gvn_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","10","Godungku Mosesanda yalaman, “Ngayu ngayku bama nyajin bubungu Egyptanda. Ngayu Egypt-warra nyajin jananin buyun-damanya. Ngayu binal jana warrngkan-warrngkay, binal jana yirrkan-yirrkay, bubumun Egyptmun wandinka. Yinyaynka ngayu bubungu kadan, jananin wandi-maninka, bubungu ngulkurrbu wundinka. Ngayu yunun yungal kinganda Egyptmunbu, yundu ngayku bama bubumun Egyptmun wandi-maninka.” ");
INSERT INTO gvn_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","20","Yamba Mosesangka Godundu yalaman, “Ngayu jarra yala. Ngayu murruji kinganda dungay, Israel-warra bubumun Egyptmun wundinka.” Godungku yalaman Mosesanda, “Ngayuda yununji dungay. Yundu jananin Egyptmun wandi-manil, yurra nganya buyay-manil yalaymba manjalba. Yinyamundu yundu binalmal ngayuku yunun yungan.” Yamba Mosesangka yalaman, “Ngayu jananda Israel-warranda dungay, balkal, ‘Nganjan-karrandamundu Godungku nganya yungan.’ Jana nguba balkal, ‘Yinya God burri wanju?’ Ngayu wanyu balkalda jananda?” Godungku yalaman, “Ngayu God wuljaljiku juranku bundan, wuljaljiku juranku bunday. Yundu jananda balka ngayu yinya God wuljaljiku. Jananda balka ngayuku Maja God Abrahamamu, Isaacamu, Jacobamu, janawundu majangka Godungku yunun yungan. Bamangka nganya yalaku bamba, Maja God wuljaljiku. Dungayda, Israel-warramu maja-maja muru-bunga, jananda balka Abrahamamu, Isaacamu, Jacobamu God yunundu nguwimal milbijin. Jananda balka ngayu jananin nyajin warrngkan-warrngkanya bubungu Egyptanda. Balka ngayu jananin bubumun Egyptmun wandi-maninka, bubungu ngulkurrbu wundinka. Yundu jananji maja-majanji kinganda dungay, nyungundu babajika yurranin yunganka bubungu jirrbu-jirrbungu, nganya buyay-maninka. Nyulu kingangka wawu kari yurranin yunganka, yamba ngayu nyungun junkurr-murubuku mambarril yurranin yunganka. Ngayu jananin Egypt-warra yinyil-bungal, jana yurranin yunganka.” ");
INSERT INTO gvn_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","5","Mosesangka Godundu yalaman, “Jana Israel-warrangka nganya nguba kari kuku-nyajil. Jana nguba balkal, ‘Godku kari nguwimal milbijin yunundu.’” Godungku yalaman Mosesanda, “Yunuwunbu maranga wanyu?” Mosesangka yalaman, “Yinya juku.” Godungku yalaman, “Bubungu yilba.” Mosesangka juku yilban, juku jarbaman. Moses warrinda jarbandamun. Yamba Godungku yalaman, “Kari, biji karrba.” Mosesangka karrban, jarba jukuman baja. Godungku yalaman Mosesanda, “Kaki jana yunun kari believeim-bal, yundu juku jarba-bunga jananda miyilbaku. Yinyamun jana Israel-warra binalmal ngayu manubajaku nguwimal milbijin yunundu. Jana binalda ngayu yinya God nguwimal milbijin Abrahamanda, Isaacanda, Jacobanda.” ");
INSERT INTO gvn_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","9","Godungku Mosesanda balkan baja, yalaman, “Yunu mara kananga kambinga yijarrika.” Mosesangka yijarrin, walngan baja. Nyungu mara bingajiman, bajiji, leprosymunji. Yinyamun Godungku yalaman, “Mara yijarrika baja.” Mosesangka yijarrin, nyungu mara ngulkurrman baja. Godungku yalaman, “Yundu yalamaka, miracle milbi jananda Israel-warranda, jana yunun believeim-bunganka. Kaki jana kariku believeim-bal, yundu bana mana wawubajamun Nilemun, bubungu yilba. Yinya bana mulamal.” ");
INSERT INTO gvn_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","12","Yamba Mosesangka yalaman Godundu, “Kari, Maja, nganya kari yunga jananda Israel-warranda. Ngayu mala-kuku kari. Ngayu kuku waymbulku balkan-balkaway.” Godungku yalaman, “Wanyangka bamanda ngandal dajin? Wanyangka jananda milka ngulkurr or milka buyun dajin? Wanyangka jananda miyil ngulkurr or miyil buyun dajin? Ngayuku jananda dajinkuda. Dungayda! Ngayu yunun mala-kuku-bungal, ngayu yunundu kuku dajil, balkanka.” ");
INSERT INTO gvn_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","17","Yamba Mosesangka yalaman, “Kari, Maja, nganya kari yunga, yindu yunga.” Yinyaynka God kuli-kadan Mosesanka, yalaman, “Yala yunu yaba, Aaron? Nyulu mala-kuku. Nyulu kankadayda, yunundu maku-janay. Yundu nyungundu kuku balka, nyulu bamanda balka. Ngayu yubalan junkurrji-bungal, kuku balkanka. Ngayu yubalan balkal wanjarrmanka. Aaronangka kuku yunundumun balkal bamanda. Yundu yala Godmal, nyungundu ngayku kuku dajil, bamanda balkanka. Yanyu juku yununji wundi, miracles milbinka. ");
INSERT INTO gvn_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Wawu yinyamun Moses nyunguwunbu ngalayinanda dungan, yalaman, “Nganya yunga bubungu Egypt, ngayku jawun-karra nyajinka. Jana nguba wularin, nguba juranku.” Ngalayinangka Jethrongku yalaman, “Yala, dungayda.” Moses dunganjiku, Godungku nyungundu yalaman, “Yundu bubungu Egypt dungayda, jana yunun kuninka, jana wubulku wularinkuda.” ");
INSERT INTO gvn_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","21","Yinyamun Moses, nyungu manyarr and nyungu kangkal-bulal jambul, jana donkeynji dungan bubungu Egypt. Mosesangka yalarrku juku wundin Godungku balkan wundinka. Godungku yalaman, “Yundu jukubu miracles jirray balka bubungu Egypt. Yamba ngayu king dukul-dandi-bungal, nyulu yurranin kari yungal.” ");
INSERT INTO gvn_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","31","Bula Moses and Aaron Egyptanda kadan, bula maja-maja Israel-warra muru-bungan. Aaronangka jananda balkan yinyarrin kuku Godungku Mosesanda balkan. Yinyamun Mosesangka miracles milbin jananda Israel-warranda. Jana maja-majangka Israel-warrangka kuku believeim-banda. Jana binalman Godungku nyajin Egypt-warra jananin buyun-damal-damanya. Yinyanka jana dukul badaman, God buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","5","Moses bula Aaron kinganda dungan, yalaman, “Israel-warrandamundu majangka Godungku balkal, ‘Ngayku bama yunga. Jana nganya buyay-maninka bubungu jirrbu-jirrbungu.’” Nyulu kingangka yalaman, “Wanya jananga maja God? Ngayu wanyurrinku jananin yunganyaku? Ngayu yinyaynka majanka Godunku binal kari. Ngayu jananin kari yungal.” ");
INSERT INTO gvn_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","11","Yilay-yilayman kingangka maja-majanda Egypt-warranda yalaman, “Yurra Israel-warranda kari straw daya baja, bricks balkanka. Jananin yunga, balu janangaku straw warrmba-bunganka. Yamba jana must bricks jirray still balka yala jakalbaku. Jananga work nguba buban. Yinyaynka jana ngaykundu babajin dunganka, God buyay-maninka. Jana must yaykarrku workmaka. Yinyamun jana time-karimal, kuku jurril nyajinka.” Maja-maja Egypt-warra Israel-warranda dungan, yalaman, “Nyulu kingangka yalaman, ‘Yurra yurrangaku straw warrmba-bungada, yamba yurra still bricks jirray balka yala jakalbaku.’” ");
INSERT INTO gvn_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","21","Jana bama yiringkurrku dunganda, straw nubinka. Jana ngadingka nubil-nubin, yinyaynka jana jarra bubanku bricks balkan. Yinyaynka jana maja-majangka Israel-warra wuybubu kulban. Yinyamun Israel-warrangka kanbal bama kinganda yungan, yalaman, “Nganjinanga straw yamba-kari, yamba yundu wawu nganjin bricks jirray balkanka yala jakalbaku. Jana maja-majangka nganjinin wuybubu kulbal-kulbal.” Nyulu kingangka jananda yalaman, “Yurra majarr bajaku, lazy-bala. Yinyaynka yurra bubungu yinduymbu dunganka, God buyay-maninka. Dungayda! Workmakada! Ngayu yurranda straw kari dajil, yamba yurra bricks jirray still balka, yala jakalbaku.” Jana bamangka Israel-warrangka king bawal-bawan, jana bulanin Moses and Aaron maku-nyajin. Jana bulanda yalaman, “Nyulu king ngananka wawu kari bajaku. Yinya yubalanga fault, nganjin yubalin wujirrngal. Nyulu ngananin juma yarkin-bal.” ");
INSERT INTO gvn_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","(5.22—6.1) Mosesangka Godundu balkan baja, yalaman, “Maja, yundu wanyurrinku yunu bama buyun-damanka? Ngayu kinganda balkanya, nyulu jananin buyun-daman, yamba yundu jananin kari helpim-bungan.” Yinyamun Godungku Mosesanda yalaman, “Yunduku nyakada. Ngayu king mambarril, ngayku bama yunganka bubumun Egyptmun.” ");
INSERT INTO gvn_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","13","Godungku bulanda Mosesanda, Aaronanda yalaman, “Yubal kinganda dungay baja. Kaki nyulu babaji Godumu junkurr nyajinka, Aaronanda balka nyungu juku bubungu yilbanka kinganda miyilbaku. Yinya juku jarbamalda.” Bula Moses, Aaron kinganda dungan, yala Godungkuku balkan. Aaronangka nyungu juku yilban jakalba kinganda and nyunguwunbu workingmananda. Juku jarbamanda. Yinyamun nyulu kingangka nyungu dingkar-dingkar mari-doctor kunjan. Jana yalarrku juku jarba-ban. Jana juku bubungu yilban, juku jarbaman. Yamba Aaronandamundu jukubu jananga juku yurmbin. Nyulu kingangka yinya nyajin, yamba nyulu dukul-dandiman, yala Godungkuku balkan Mosesanda. ");
INSERT INTO gvn_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","18","Yinyamun Godungku Mosesanda yalaman, “Nyulu king dukul-dandimalman, bama wawu kari yunganka. Wunkun yalibalaku nyulu wawubajanga kaday. Yundu nyungun maku-nyaka yinyay. Yundu juku wundi, nyungunku waitmaka yikinba. Nyulu kaday, yundu nyungundu balka, ‘Israel-warrandamundu Godungku yanyu kuku yunundu yungan. Yundu Godumu bama yunga, jana nyungun buyay-maninka bubungu jirrbu-jirrbungu. Yamba yundu Godundu kari milka-janan. Yundu nyakada! Yundu Godunku binalmalda, nyulu yunundu junjuy-junjuy jirray miracle milbil. Nyaka, ngayu bana wawubaja kunil jukubu. Yinya bana mulamalda, kuyu wubulku wulayda, bana kabumalkuda, bamangka kari nukal baja.’” ");
INSERT INTO gvn_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","24","Wawu yinyamun Godungku Mosesanda yalaman, “Aaronanda balka, ‘Yundu juku kuji wuyara bananga yiringkurrku bubungu Egypt. Bana yiringkurrku mulamalda.’” Bula Mosesangka Godumu kuku wukurrin. Kinganda miyilbaku Aaronangka wawubaja bana kunin jukubu. Bana mulaman, kuyu wubulku wularin, kabumankuda. Mula yiringkurrku bubungu Egypt. Yamba jana mari-doctorangka yalarrku bana mula-bungan. Yinyaynka nyulu king dukul-dandiman baja. Nyulu kari milka-janan bulanda Mosesanda, yala Godungkuku balkan. Nyulu nyunguwunbu bayanba dungan, bulanin bayjan. Bana buyunmanya wawubajanga, jana Egypt-warrangka bubu bakan yikinba banaka nukanka. ");
INSERT INTO gvn_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","4","Warngku 7-balaman Godungku Mosesanda yalaman, “Yundu kinganda dungay baja, yanyu kuku nyungundu daya ngaykundumun. Yalamaka, ‘Ngayku bama yunga, jana nganya buyay-maninka. Kaki yundu kari yungal, ngayu yurranga bubu buyun-damal. Ngayu yirku-yirku yiringkurrku yungal bubungu Egypt. Jana yirku-yirkungku wawubaja bawal, yurrawunbu bayanba walal. Jana bedroommunbu walal, bedba walal, kitchenba walal, stovemunbu walal. Jana yiringkurrku bamanda jalamalkuda.’” ");
INSERT INTO gvn_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","7","Yinyamun Godungku Mosesanda yalaman baja, “Yundu Aaronanda balka nyungu juku wawubajanga, walngkanga wuyar kuji. Yinyamun jana yirku-yirkungku bana bawal, yiringkurrku dungay bubungu Egypt.” Aaronangka Godumu kuku wukurrin, jana yirku-yirku wubulman bubungu. Yamba jana mari-doctorngka yalarrku yirku-yirku balkan magicmundu. ");
INSERT INTO gvn_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","11","Yinyamun kingangka bulanin Moses, Aaron kunjan, yalaman, “Praymaka yubalandamunbu Godundu. Babajika nyulu yirku-yirku kunbay-maninka. Yinyamun ngayu yubalanga bama yungal, God buyay-maninka.” Mosesangka yalaman, “Ngayu Godundu praymal yurranka Egypt-warranka. Yinyamun jana yirku-yirku wulari bubungu. Bubanku wawubajanga bunday, yala jakalbaku. Wanja-wanja yundu wawu ngayu praymanka?” Kingangka yalaman, “Wunkun.” Mosesangka yalaman, “Yalada. Ngayu yunu kuku wukurril. Yinyamun yundu binalmal nganjinanga God junkurrji yindu-yinduynku. Yirku-yirku juma yamba-karimal bubungu. Wawubajangaku jana bunday baja.” ");
INSERT INTO gvn_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","15","Bula Mosesangka king bawan, Moses Godundu babajin yirku-yirku kunbay-maninka. Godungku Moses kuku-nyajin, nyulu yirku-yirku wubulku wulay-manin. Yarkin-yarkin yiringkurrku bubungu, kabumankuda. Yamba nyulu kingangka yarkin-yarkin nyajin, nyulu dukul-dandiman baja. Yinyaynka nyulu kari bulanda Mosesanda, Aaronanda milka-janan, yala Godungkuku balkan. ");
INSERT INTO gvn_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","19","Godungku Mosesanda yalaman, “Aaronanda balka bubu kuninka jukubu. Yinyamun bulbur yiringkurrku munyurrimal.” Aaronangka bubu kunin jukubu, bulbur wubulku munyurriman. Munyurrimundu bubu kanbin. Jana mari-doctorngka yalarrku munyurri balkanka bulburmun magicmundu, yamba jana murruji balkan. Munyurri yiringkurrku dungan, bama baykanka, buyun-damanka. Jana mari-doctorngka kinganda yalaman, “Godungkuku yanyu balkan,” yamba nyulu king walu-dandiman baja, bulanda Mosesanda, Aaronanda kari milka-janan, yala Godungkuku balkan. ");
INSERT INTO gvn_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","24","Godungku Mosesanda balkan, “Yundu wunkun yalibalaku wawubajanga dungay, king maku-nyajinka. Nyungundu yanyu kuku ngayku daya. Yalamaka, ‘Godumu bama yunga, jana nyungun buyay-maninka. Kaki yundu kari yungal, Godungku burul-burul wubul bajaku yungal Egypt-warranda. Burul-burul yiringkurrku dungay, bayanba, bubungu. Yamba nyulu burul-burul kari yungal nyunguwunbu bamanda Israel-warranda bubungu Goshen. Yundu yinya nyajil, yundu binalmalda nyuluku Maja God. Yundu yalarrku binal nyulu nyungu bama Israel-warra ngulkurrduku kujil. Wunkun nyulu burul-burul yungal.’” Warngku yindu Godungku burul-burul wubul bajaku yungan kingandamunbu bayanba, nyunguwunbu workingmananda, bubungu yiringkurrku. Burul-buruldu bubu buyun-daman. ");
INSERT INTO gvn_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","32","Yinyamun kingangka bulanin Moses, Aaron kunjan, yalaman, “Dungayda, yurra Israel-warrangka yurranga God buyay-mana yaluy bubungu Egypt.” Yamba Mosesangka yalaman, “Kari, nganjin God kari buyay-manil yaluy. Kaki jana Egypt-warrangka nganjinan nyajil minya kuninya, wayjunyu, Godundu dajinya, jana kuli-kaday nganjinanka. Jana nganjinan yarkin-bal, wubulku. Nganjin bubungu kala-kalbay dunganka. Nganjin warngku kulur dungay, kaday, yinyaymba God buyay-maninka yala nyulu nganjinanda balkan.” Nyulu kingangka yalaman, “Ngayu yurranin bubungu jirrbu-jirrbungu yungal, yamba yurra kari kala-kalbay dungay. Godundu praymaka ngaykunku.” Mosesangka yalaman, “Ngayu yunun bawalda, ngayu Godundu babaji nyulu wunkun yurrandamun burul-burul yunganka. Yamba yundu nganjinin kari jurril-bunga baja, nganjinin kari kiri baja, God buyay-maninka.” Moses dunganda, Godundu babajin burul-burul bubumun yunganka. Godungku Mosesamu kuku nyajin, burul-burul bubumun yungankuda. Jana wubulku dungaynda. Yamba nyulu king dukul-dandiman baja, jananin Godumu bama kari yungan. ");
INSERT INTO gvn_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","7","Godungku Mosesanda yalaman, “Dungay, kinganda balka, ‘Israel-warrandamundu Godungku balkalda, “Ngayku bama yunga, jana nganya buyay-maninka. Kaki yundu kari yungal, ngayu bambay jirray yungal yurrawunbu yarramananda, donkeynda, camelundu, bulkinda, sheepanda, nanny goatundu. Jana minya yurranga wulari. Yamba ngayu Israel-warramu minya kari bambay-bungal, jananga minya kari wulari. Ngayu wunkun bambay jirray yungal.” ’” Warngku yindu Maja Godungku bambay yungan, minya wubulku wularin, Egypt-warramu. Yamba Israel-warramu minya kari bambayman, kari wularin. Nyulu kingangka babajin, “Yala Israel-warramu minya? Jana wularin or kari?” Nyulu binalmanda, jananga minya kari wularin. Yamba nyulu walu-dandiman baja, Godumu bama kari yungan. ");
INSERT INTO gvn_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","12","Godungku bulanda Mosesanda yalaman, “Nulu bayamun mana, kinganda dungay. Nulu jiringa yilba kinganda miyilbaku. Nulu yala bulburmal, bubungu yiringkurrku dungay. Nulumun balamu balkaji, bamanda, minyanda.” Yala, bula Mosesangka nulu manin, kinganda dungan. Moses jakalba kinganda janan, nyulu nulu jiringa yilban. Nulumun balamu balkajin, bamanda, minyanda. Jana mari-doctor kari Mosesanda kadan, jana yalarrku bambaymanya balamunji. Yamba Majangka Godungku king walu-dandi-bungan. Yinyaynka nyulu king bulanda Mosesanda, Aaronanda kari milka-janan, yala Godungkuku balkan. ");
INSERT INTO gvn_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","19","Majangka Godungku Mosesanda yalaman, “Wunkun yundu yalibalaku king maku-nyaka, nyungundu balka, ‘Majangka Godungku balkan, “Yundu ngayku bama yunga, jana nganya buyay-maninka. Ngayu yununin punishim-bal, yundu binalmalda, ngayuku God junkurrji. Ngayu yurranin Egypt-warra kari bambay jirray-bungan, yurranin kari kunbay-manin. Ngayu ngayku junkurr milbinka bamanda bubungu yiringkurrku. Yinyaynka ngayu Egypt-warra kari yarkin-bungan. Yamba yundu dukul-dandimanya, ngayku bama kari yungan. Wunkun ngayu kaba dandi yala ice blocks yungal jirimun. Bamangka Egypt-warrangka jakalbaku kariku yala nyajin, ngayu yunganka. Yundu bamanda balka jananga minya wubulku bayanba walay-mana. Kaki bama, minya ngalkalba bunday, kababu dandibu jananin yarkin-bal.” ’” ");
INSERT INTO gvn_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","21","Kanbalda kingandamundu workingmanangka yinya kuku nyajin, jana yinyilmarin, minya bayanba walay-manin. Yamba kanbalda Godumu kuku bayjan, jananga slave-warra and minya ngalkalba bawan. ");
INSERT INTO gvn_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","26","Yinyamun Godungku Mosesanda yalaman, “Yunu mara wangkar-bunga, kaba dandi yala ice blocks jirimun daray yiringkurrku bubungu Egypt. Kaba dandi daray bamanda, minyanda, mayinga jurrbungu paddockmunbu.” Mosesangka juku wangkar-bungan jiringa, Godungku jarramali, kaba dandi yala ice blocks yungan. Nyulu balbay jirray yungan bubungu, jana Egypt-warrangka jakalbaku yala kari nyajin, jarramali yalbay. Bama and minya ngalkalba, jana wubulku wularin. Mayi paddockmunbu wubulku buyunmarin, kabamun dandimun. Yamba Israel-warramu bubu Goshen kari buyunman, kaba dandi yamba-kari. ");
INSERT INTO gvn_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","30","Kingangka yinya nyajin, nyulu bulanin Moses kunjan, yalaman, “Ngayu buyunmanda. Nyulu Maja God junkay, ngayku bama wadu-wadu. Godundu praymaka, jarramali, kaba dandi kunbay-maninka. Ngayu promiseim-bungal yurranin bama yunganka.” Mosesangka nyungundu yalaman, “Ngayu townmun dungay, mara wangkar-bungal, Godundu praymal. Yinyamun jarramali and kaba dandi kunbay, yurra binalmanka bubu yiringkurrku Godumukuda. Yamba yundu and yunu workingman kariku Godunku yinyilmal baja.” ");
INSERT INTO gvn_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","32","Kababu dandibu mayi kulbul buyun-daman. Yamba mayi wheat kayalku, yinyaynka mayi wheat kari buyunman. ");
INSERT INTO gvn_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","35","Yinyamun Mosesangka king bawan, town bawan, mara wangkar-bungan, Godundu prayman. Godungku jarramali and kaba yala ice blocks kunbay-manin. Kingangka nyajin jarramali kunbanya, nyulu buyun-daman baja. Nyulu and nyungu workingman walu-dandiman baja. Yala Godungku balkan, nyulu kingangka Israel-warra kari yungan. ");
INSERT INTO gvn_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","Godungku Mosesanda yalaman, “Yundu kinganda dungay baja. Ngayu nyungun and nyungu workingman walu-dandi-ban. Ngayu jananin dukul-dandi-ban, jana nganya nyajinka, miracles junkurr-murubuku balkanya. Ngayu jananin dukul-dandi-ban, yurra kangkal-kangkalanda, jija-karranda, kaminjarr-karranda balkanka ngayu Egypt-warra kuya-ban miraclesmundu. Yurra wubulku binalda ngayuku Maja God.” ");
INSERT INTO gvn_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","7","Yinyamun bula Moses, Aaron kinganda dungan, yalaman, “Maja God babaji, ‘Yundu wanja-wanja ngaykundu milka-janay? Ngayku bama yunga, jana nganya buyay-maninka. Kaki yundu kari yungal, ngayu yinja-yinja yunuwunbu bubungu yungal wunkun. Jana yinja-yinja wubulmal, bubu yiringkurrku nandal. Jikan, mayi wheat, birra jukungu, jana yinja-yinjangka wubulku nukal. Jana bayanba walal yiringkurrku. Yurrawundu nganjan-karrangka jakalbaku yala kari yinja-yinja jirray nyajin.” Moses kuku kunban, nyulu jurrkijin, king bawan. Yamba kingandamundu workingmanangka nyungundu yalaman, “Nyulu bamangka wanja-wanja ngananka trouble kunbay-manil? Jananin Israel-warra yunga, jananga God buyay-maninka. Godungku ngananga bubu Egypt buyun-damanyarrkuda.” ");
INSERT INTO gvn_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","11","Yinyamun kingangka bulanin Moses kunjan baja, babajin, “Wanya dungarinka, yurranga God buyay-maninka?” Mosesangka yalaman, “Nganjin wubulku dungarinka. Nganjinanga yarrka-yarrka, binga-binga, kamba-kamba, wubulku dungarinka. Nganjin minya sheep, nanny goat, bulki wubulku wundil, mayi jirray wayjunku, God buyay-maninka.” Nyulu kingangka yalaman, “Kari bajaku! Ngayu yurranga manyarr-karra, kangkal-kangkal kari yungal. Kaki yurra wubulku dungari, ngayu binal yurra nganya buyun-damanka. Kari. Ngayu yurranin dingkar-dingkarku yungal, God buyay-maninka.” Wawu kukumun jana Egypt-warrangka bulanin Moses, Aaron kingandamun kangan. ");
INSERT INTO gvn_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","20","Yinyamun Godungku Mosesanda yalaman, “Mara wangkar-bunga, yinja-yinja wundinka. Jana jikan, birra, mayi wubulku nukal kariku buyun-damajin kabamun dandimun.” Mosesangka juku wangkar-ban, Godungku muyar yungan nakamun. Muyar nakamun wanarrin wungaraburr, wujurrdurr. Yalibalaku jana yinja-yinja kadan muyariji. Jana yiringkurrku dungan, wubul bajaku. Jana bubu nandan, bubu ngumbuman. Bamangka yala kari yinja-yinja jirray nyajin jakalbaku. Jana yinja-yinjangka jikan, birra, mayi wubulku nukan, green-bala yamba-karikuda. Yinyamun nyulu kingangka bulanin Moses, Aaron kunjan, yalaman, “Yunuwunbu Godundu praymaka, ngayu God kari kuku-nyajinya. Godundu babajika nganya kari punishim-bunganka baja.” Mosesangka king bawan, Godundu prayman. Godungku muyar nakamun jurrki-manin, muyar jibarrmun kadanda. Muyarabu yinja-yinja yilbanda, Red Seamunbu. Yinja-yinja wubulku warririn bubumun Egyptmun. Yamba Godungku king walu-dandi-ban, nyulu Israel-warra kari yunganka. ");
INSERT INTO gvn_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","29","Godungku Mosesanda yalaman, “Mara wangkar-bunga, bubu Egypt nguwul-nguwul-bunga.” Mosesangka mara wangkar-ban, bubu Egypt warngku kulur nguwul-nguwulku bundan. Jana Egypt-warra jana-karrajiku kari nyajiwan, bayan kari bawan. Yamba jana Israel-warrangka wungar nyajin, light jirray janawunbu bubungu. Nyulu kingangka Moses kunjan, yalaman, “Ngayu yurranin wubulku yungal, God buyay-maninka, jalbu-jalbu, kangkal-kangkal, wubulku, yamba yurra minya sheep, nanny goat, bulki kari wundi.” Mosesangka yalaman, “Nganjin must minya bulki, sheep, nanny goat wundil, wayjunku, Godundu dajinka. Kari, nganjin minya kari bawal, nganjin must kanbal wangkanyinka, Godundu dajinka, nyungun buyay-maninka. Nganjin must minya wangkanyinka yinyaymba bubungu.” Yamba Godungku king walu-dandi-ban, nyulu kingangka jananin kari yungan. Nyulu Mosesanda yalaman, “Dungayda, ngayu yunun wawu kari nyajinka baja. Ngayu yunun nyajil baja, yundu wulay.” Mosesangka yalaman, “Yundu junkayku balkan. Yundu nganya kari nyajil baja.” ");
INSERT INTO gvn_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Godungku Mosesanda balkan, “Ngayu punishment nyubunku yungal baja kinganda, and Egypt-warranda. Wawu yinyamun nyulu kingangka yurranin yungal baja bubumun. Nyulu yurranin kangalkuda, wawu kari yurra bundanka baja.” ");
INSERT INTO gvn_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","8","Mosesangka king kariku bawan. Nyulu kinganda balkan, “Godungku balkan, ‘Juma ngayu bububurr Egyptmundurr dungay. Kangkal dingkar jakalbamun wubulku juma kunarangkalba wularida. Yunu kangkal dingkar jakalbamun yalarrku wulay. Slave-warramu kangkal-kangkal jakalbamun yalarrku wulari. Kangkal-kangkal bulkimu jakalbamun yalarrku wubulku wulari. Bamamu wubulbuku kangkal-kangkal jakalbamun wularikuda.’” Wawu kukumun Moses kuli jirray, king bawan. ");
INSERT INTO gvn_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","27a","Godungku bulanda Mosesanda, Aaronanda yalaman, “Yubal Israel-warranda yanyu kuku balka: warngku 10-balamal yurra minya sheep karrkay or minya nanny goat karrkay wangkanyika, minya dingkar 1 year old. Minya ngulkurr wangkanyika, bambay kari, barrka-buyun kari. Yinyamun warngku 4-balamal, yilay-yilaymal Israel-warrangka wubulduku kunida, yinyarrin minya jana wangkanyin. Jana mula minyamun wangkar-wangkar doorngu julngka, yalarrku julngka doorngu karangkalba, jambulurr sidemunbu. Yinyamun jana minya wayju, nukada. Bread balan-balan, mayi nganja-burra yalarrku nuka. Minya wayju, kari kayalku nuka. Wubulku nukarrku, dukul, jina, julbi, jiba, burrkul, birra, wubulku yalaku nuka. Minya yanday kari bawa, bayanga wayjurrku. Yurra nukanjiku, yurra readymaka dunganka, dambal dida, jaba marabu kuji, readymanka dunganka. Yurra readymal, minyada, mayida jinbaldaku nuka. Wawu mayimun ngayu bububurr Egyptmundurr dungay, kangkal-kangkal dingkar-dingkar jakalbamun wubulku yarkin-bunganka, bama-bama, minya-minya. Ngayu Maja God. Kaki ngayu mula nyajil wangkar-wangkar doorngu, sidemunbu jambulurr, ngayu yinyaymba bayanba kari walal; kari, ngayu walkuku dungay, pass overmaniji, kangkal jakalbamun kari yarkin-bungal. Yamba ngayu bayanba mula-kariymba walal, jananin punishim-bunganka, kangkal jakalbamun yarkin-bunganka, Egypt-warra. Ngayu wawu yurra every year mayi Passover nukanka, kari milka-wulanka ngayu yurranin bubumun Egyptmun wundin kuli-bakandamun.” Godungku yalaku kuku dajin Israel-warranda. ");
INSERT INTO gvn_vpl VALUES ("EX12_27b","003_12_27b","EXO","12","27b","28","Yinyamun kukumun jana Israel-warra bungkubu janan, God buyay-manin. Wawu yinyamun jana Godumu kuku wukurrin yala Mosesangkaku balkan. ");
INSERT INTO gvn_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","30","Kunarangkalba Godungku Egypt-warra kangkal-kangkal dingkar-dingkar jakalbamun wubulku yarkin-bungan. Kingamu kangkal jakalbamun wulan, yalarrku jail-warramu kangkal-kangkal jakalbamun wularin. Janawunbu minyamu kangkal-kangkal jakalbamun yalarrku wularin. Nyirraynja nyungun king and nyungu workingman warngkumun wandi-manin, jana bama nyajin banbadirinya. Bayanba yiringkurrku kangkal jakalbamun wulan. ");
INSERT INTO gvn_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","33","Nyulu kingangka bulanin Moses, Aaron jinbalku kunjan, yalaman, “Dungayda, yurra Israel-warra! Yanyu bubu bawa, yurranga God buyay-mana. Yurranga bulki, sheep, nanny goat wubulku wundijika. Ngaykunku praymaka yurrawunbu Godundu.” Jana Egypt-warrangka Israel-warranda yalaman, “Jinbal, yurra dungayda. Kaki yurra kari dungari, nganjin wubulku wulari.” ");
INSERT INTO gvn_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","36","Jana Israel-warrangka bread balan-balan dingkan dishmunbu, kambibu mulun-ban, bindabuku jarra-kulban. Jana Mosesamu kuku wukurrin, Egypt-warranda babajin kambika, goldmunku, silvermunku. Jana Egypt-warrangka jananda dajin. Yinyaynka jana Egypt-warramu yamba-yamba and jewelry jananji wundin bubumun. Jana Joseph yarkin yalarrku jananji wundin. Josephangka ngadi bajaku yalaman, “Godungku Israel-warra juma yaluymun wundil. Jana nganya yarkin yalarrku wundida.” ");
INSERT INTO gvn_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","39","Jana Israel-warra bubumun Egyptmun dungarin. Bama wubul bajaku dungarin, dingkar-dingkar 6 hundred thousand, jalbu-jalbu and kangkal-kangkal wubul bajaku. Minya bulki, sheep, nanny goat wubul bajaku jana wundin. Kanbal Egypt-warra yalarrku jananji dungarin. Jana bubu Egypt bawanjiku, jana bread balan-balan dingkan. Jana time kari, bread kujinka, yeastmun wubajinka. ");
INSERT INTO gvn_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","42","Jana Israel-warra ngadingka bubungu Egypt bundandan, 430 years. Yinyamun jana Godundumundu bamangka wubulduku bubu Egypt bawan. Nyulu Godungku jananin ngulkurrduku kujin, kunarangkalba nyulu jananin jakalbamun-karra kari yarkin-bungan, yala nyulu Egypt-warra jakalbamun-karra yarkin-bungan. Nyiku-nyiku jana Jew-warrangka still Passover nukal, kari milka-wulanka Godungku jananin Egyptmun wundin kuli-bakandamun. ");
INSERT INTO gvn_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","22","Wungaraburr God ngurrbanba, nyulu jananda jakalba dungan, jana nyungun wukurrinka. Wujurrdurr yinya ngurrban dayirr-dayirr yala light, jana wujurrdurr wukurrinka. Ngurrban jakalba dungan, jana kudamundu kadan, wukurrin. ");
INSERT INTO gvn_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","9","Kingangka kuku nyajin jana Israel-warra ngakijinya. Nyulu, kanbalda maja-majangka kuku jurrkinda, yalaman, “Ngana wanjarrman? Jana Israel-warra nganandamun ngakijin, ngananga slave yamba-karida.” Kingangka nyungu buggy manin, soldier-soldier muru-ban. Yinyamun nyulu buggy kanbal manin baja, driveranji ngulkurr-ngulkurranjiku, warmunku readyman. Godungku king dukul-dandi-bungan, Israel-warra wukurrinka. Israel-warrangka bubu Egypt wawurr-wawurrduku bawan. Jana Egypt-warrangka wukurrin, wukurrin, janangan juru-manin Red Seamunbu bundandarin. ");
INSERT INTO gvn_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","14","Jana Israel-warrangka nyajin jananin soldier-soldier kankadanya, janandarrku maku-janjanan, jana yinyilmarin, Godunduda yirrkan helpmunku. Jana kanbalda Mosesanda babajin, “Bubu yamba-kari Egyptanda juljalka? Yundu nganjinin yaluy bajaku wundin wulanka. Nyaka, yundu wanyurrinku nganjinin Egyptmun wundin? Nganjin yunundu balkanda ngana juma yarraku wulari. Yundu nganjinin bawanyaku, jananda Egypt-warranda workmalmanyaku, nganjin wuljaljiku yinyay bundanyaku. Nganjin wawu kari yarra wularinka, bubungu marralba.” Mosesangka jananda yalaman, “Kari yinyilmaka. Junkayku janay, junkurrjiku. Yurra nyajilda Godungku yurranin kujil Egypt-warrandamun, yurra jananin kari nyajil baja. Godku yurranka kuniway, yurra yalaku bundarika.” ");
INSERT INTO gvn_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","18","Godungku Mosesandada yalaman, “Wanyurrinku yundu helpmunku yirrkan-yirrkay? Jananda balka Red Seamundurr dungarinka. Juku wangkar-bunga, jalundurr wuyaraburr kuji. Jalun ngami-ngamimalda, yurra Israel-warra dindarrdarr dungay jinabuku, bububurr marraldarr. Ngayu baral yurranga balkal. Ngayu jananin Egypt-warra dukul-dandi-bungal, yurranin wukurrinka. Ngayu jananin winim-bungal. Ngayu winim-bungal, jana binalmalda ngayu Maja God bajaku.” ");
INSERT INTO gvn_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","Godumu angel jananda Israel-warranda jakalba bundandan, nyulu kudamunduda dungan, dindarranga Egypt-warranda, Israel-warranda. Ngurrban Godunji yalarrku dungan dindarra jananda. Ngurrbanangka nguwul-nguwul-bungan Egypt-warranka, yamba bubu dayirrku kujin Israel-warranka. Jana Egypt-warra yinyamun jananda kari kadan baja wujurrdurr. ");
INSERT INTO gvn_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","31","Mosesangka nyungu mara kujin wuyar jalundurr, Godungku muyarabu junkurrdu jalun ngami-ngami-bungan. Muyar kadan, kadan, jalun marralmanda. Jalun junkayku janan, yala ngamar, jambulku side, jananga baralda balkan. Jana Israel-warra dungaynda yinyayngkarr baraldarr. Jana Egypt-warrangka jananin wukurrin, buggynji yarramanangka kulbal-kulbanya. Mudu-wayjun, Godungku jananin Egypt-warra kunkun-bal-ban ngurrbanmun, jananin walu-ngangkal-ngangkal-bungan. Nyulu jananga buggy jaybi-manin kambal-kambalba. Jana murruji jurrkin. Egypt-warrangka yalaman, “God jananka Israel-warranka kunin-kuniway, ngananji. Ngana dungarinkakuda!” Godungku Mosesanda yalamanda, “Yunu mara wuyar jalundurr kuji baja, jalun murumal janandaku, Egypt-warranda, jananin bujil-janji-manil.” Mosesangka nyungu mara kujinda jalundurr. Wungar dakan, jalun muruman baja. Jana Egypt-warra jalunmun ngakijinyaku, yamba Godungku jananin jalunbuku yilban baja. Jalundu jananin wubulku nandan, yarraman, buggy, soldier-soldier. Jana wubulku bujil-janjin, nyubunku Godungku kari bawan. Yamba jana Israel-warra marralku dungan jalundurr, bububurr marraldarr. Godungku yalaku jananin Israel-warra kujin Egypt-warrandamun. Jana Israel-warrangka jananin Egypt-warra nyajinda yarkinku wunananya yikandarr. Jana Israel-warrangka Godumu junkurr nyajin, jana yinyilmarin nyungundumun. Jana God bulangan Moses kuku-nyajinda, bulanin wukurrinka baja. ");
INSERT INTO gvn_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Yinyamun Mosesangka, Israel-warrangka wulngku yirrkanda Godundu. Nyulu yalaku yirrkan, “Ngayu wulngku yirrkay Godundu, nyulu ngananin kujinya, nyulu jananin Egypt-warra jalundurr yilbanya, yarraman muruku.” ");
INSERT INTO gvn_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","21","Miriam Mosesamu bulanga Aaronamu babarr, nyulu junjuy manin, burri dudanka. Nyungun kanbalda jalbu-jalbungku yalarrku wukurrin, burri dudal-dudan, dancemalmanda. Miriam wulngku badin jananka, “Wulngku yirrkay Godundu, nyulu ngananin kujinya, nyulu jananin Egypt-warra jalundurr yilbanya, yarraman muruku.” ");
INSERT INTO gvn_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","26","Yinyamun Mosesangka jananin Israel-warra Red Seaandamun wundin, kala-kalbay bububurr marraldarr burri Shur. Jana warngku kulur jinabuku dungarin, yamba bana kari warrmba-ban. Jana dungan, dungan, bubungu Marah kadan. Jana bana yinyay warrmba-ban, baban, bana yinya kaka bajaku, jana kari nukan. Yinyaynka jana burri dalkin, Marah. Jananga kuku Marah mean kaka. Jana Israel-warra kuli-kadarin, Mosesanda babajinda, “Ngana wanyu nukal?” Moses Majanda babajin, helpim-banka. Nyungundu Majangka juku milbin. Mosesangka juku manin, bananga yilban. Bana ngulkurrmaynda, nukanka. Majangka yalamanda, “Ngayu maja bajaku, yurrangan manubajabuku kujin-kujil buyunmun.” ");
INSERT INTO gvn_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","12","Jana Israel-warrangka yinya bubu bawan, dungan, dungan, yinduymbu bubungu marralba kadan. Jana yinyay kadan, mayi-kariman. Jana Mosesanda, and Aaronanda yalamanda, “Majangka nganjinin bawanyaku bubungu Egypt. Yaluy bubu mayi kari, minya kari. Nganjin Egypt bundandan, nganjin yanjiku dungan-dunganya. Yamba yubal nganjinin yarra wundin bubungu marralba, ngana wulay, mayi-karimun.” Majangka Mosesanda yalaman, “Ngayu yurranga mayi yungal, yala kaba jirimun. Yurra yalibalaburr dakal, yurranga mayi maninka, wungaranka, wujurrinka. Yalibalamal baja, ngayu yurranga mayi yungal baja. Ngayu yalaku yurrangan nyajil, kaki yurra nganyaku wukurril. Warngku 6-balamal, yurra mayi jirray bangka, wunkunyinka yalarrku.” Bula Moses and Aaronangka jananda Israel-warranda yalaman, “Nyiku yilay-yilaymal yurra binalmalda yurrangan Majangka Egyptmun wundin. Yalibalamal yurra light junkurrji nyajil. Yinyamundu lightmundu Maja milbil. Nyulu yurrangan nyajin kuku daman-damajinya nyungunku. Yuwu, nyungunku kuda. Yurra balu ngalinyin murru-kal-kal; kari, yurra Majaku murru-kal-kal, ngalin nyunguku kuku nyajil-nyajinya.” Yinyamun Mosesangka yalamanda, “Nyuluku Majangkaku yilay-yilaymundurr minya yurranda dajil nukanka, mayi bread dajil nukanka yalibalaburr, nyulu yurranda milka-janjananya kuku-daman-damajinya.” Mosesangka yinyamun Aaronandada yalaman, “Jananda wubuliymbaku balka yaluy kadanka, Majanda jananka, nyulu jananin nyajinya kuku-daman-damajinya.” Aaron jananda balkawan, jana jurrkijin, naka-naka bubu marral walu-wukurrin. Yinyamun nyulu Maja milbijinda, lightmun ngurrbanmun. Majangka Mosesandada yalaman, “Ngayu jananin Israel-warra nyajin kuku-daman-damajinya. Jananda balka, nguwul-nguwulmanijinjiku, ngayu jananga minyada dajil. Yalibalamal ngayu jananga bread dajil, janangan yanji-bungankarrku. Jana binalmalda, ngayu jananga Maja, God jiringa.” ");
INSERT INTO gvn_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","26","Yilay-yilayman dikal kaki wubul kadarin, wubul bajaku, jananga bayan nandanyarrku. Yalibalaman dewungku bubu kanbinyarrku ngalkalba bayandarr. Dew kunban, junjuy bawajin, bubungu wuyar wunanan, kima-kima bajaku. Jana Israel-warrangka nyajin, jana ngangkarin, jana-karrajiku babajin, “Wanyu yinya?” Mosesangka jananda yalaman, “Yanyu junjuy mayida Majangka ngananda yungan, nukanka. Majangka balkan yurra wubuliynjaku mayi yanyu bangka, wungarinka, and wujurrinka, yurrangan yanji-bunganka.” Jana Israel-warra dungaynda, mayi mujanka, wungarinka, wujurrinka. Kanbalangka wubul manin, kanbalangka buban manin. Yamba yinyarrinyangka wubul manin kariyirrku kunbay-manin. Janaji kanbalangka buban mujan, jana yalarrku kariyirrku kunbay-manin. Jana mujan wungarinka, wujurrinka. Mosesangka jananda yalaman baja, “Yurra mayi kari kuji wunkunyinka.” Yamba kanbal kari milka-janan, mayi kanbal kujin wunkunyinka. Jana yalibalaku wandin, mayi jananga kabuman, kandarrji. Moses jananka kulimanda. Yalibalaburr jana Israel-warrangka mayi bangkanya janangaku. Wungar wumbulmanya, mayi bubungu wunananya burranya. Warngku 6-balamanya baja jana mayi jirray bangkanya, wunkunyinka. Jana maja-majangka Mosesandada balkan, “Ngana wanjarrmal mayiji wubuliynji? Kunka ngananga mayi kabumal wunkunyinka.” Mosesangka jananda yalaman, “Wunkun Godumu day, bama milkanga nyungunjiku bundarika, kari wunkun workmaka. Nyikuku mayi wayju, wunkunyinka, nyikunku.” Jana Moses kuku-nyajin, mayi wayjunda. Warngku yindu mayi kari kabuman, kari kandarrjiman. Mosesangka yalamanda, “Yanyu mayi nyiku nuka because nyiku Godumu day, bama kari workmaka. Yurra mayi kari warrmba-bal. Yurra mayi muja 6 daysanka, warngku yindu Godumu day, mayi yamba-karimal.” ");
INSERT INTO gvn_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","31","Warngku 7-balaman, jana kanbal kari milka-janan Mosesanda, dungaynda, mayika nubijinka. Yamba jana mayi kari warrmba-ban. Majangka Mosesanda babajin, “Yunu jawun-karra wanja-wanja ngaykundu milka-janay? Ngayuku Majangkaku yurranda warngku nyubun dajin wawu-balangajinka. Yinyaynka 6 daymal, ngayu yurrangan mayi jirray dajil, warngku jambulinka. Bama wubulku bayanbaku bunday ngaykuwunbu daymunbu, bayan kari bawa workmunku.” Yinyamun janajin bama kari workmanijin nyunguwunbu daymunbu. Jana Israel-warrangka mayi Godundumun manin, burri dalkin manna. Yinya mayi yala diburr karrkay, bingaji. ");
INSERT INTO gvn_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","6","Jana Israel-warrangka yinya bubu marral bawanda, yala dungan-dungan bubungu yindu-yinduymbu yala Godungkuku jananda balkal-balkan. Jana kadan bubungu Rephidim, yinyada jana bayan ngaran. Bana yamba-kari yinyaymba bubungu. Jana kuku-damajin baja Mosesanda, yalaman, “Nganjinanda bana daya, nukanka.” Mosesangka yalaman, “Yurra wanyurrinku kuku-damaji? Yurra wanyurrinku Maja ngingal-ngingal?” Yamba jana bama wawu-wulan bajaku banaka, Mosesanda kuku-daman-damajinku. Jana yalaman, “Yundu nganjinin wanyurrinku Egyptmun wundin? Yundu nganjinin wubulku wulay-maninka bana-karimun.” Moses praymanijinda Majanda manubajaku, yalaman, “Ngayu wanjarrmal yinyarrinyanji bama-bamanji? Jana juma nganya kuljibu mungkil.” Majangka Mosesanda yalaman, “Jananin maja-maja mana, jakalba dungay janandamun kanbalandamun. Yinya juku yalarrku wundi yundu kujil-kujil. Ngayu kuljinga janay yunundu jakalba, kuljinga bubungu burri Mt. Sinai. Kulji jukubu kuni, bana kuljimun wandil yurranga, nukanka.” Mosesangka kulji jukubu kunin jananda maja-majandaku miyilbaku, bana wandinda, bama-bamanka wubulkuku. ");
INSERT INTO gvn_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","13","Jana Amelek-warra kadan, Israel-warranji kuniwanka bubungu Rephidim. Mosesangka Joshuanda yalaman, “Kanbal dingkar-dingkar mana, jananji Amelek-warranji wunkun kuniwanka. Ngayu wangkar wuburrbu janay jukuji Godungku ngaykundu balkan wundinka.” Joshuangka Moses kuku-nyajin, dunganda, dingkar-dingkar muru-banka, kuniwanka. Janajin Moses, Aaron, Hur wangkar-wangkar wuburrbu dungan. Mosesangka dakil jambulurr jiringa kujil-kujinya, jana Israel-warrangka winim-bal-banya. Nyulu dakil bada-banya, jana Amalek-warrangka winim-bal-banya, yalaku, yalaku. Mosesamu dakil baja-burranda, Aaronangka, Hurangka kulji yalbayku wundin Mosesanda, nyulu bundanka. Moses bundan, bula Aaronangka and Hurangka nyungu dakil jambulurr junkayku kujil-kujin, balu wungar daranyarrku. Joshuangka yalaku janangan Amelek-warra kunbay-manin. ");
INSERT INTO gvn_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","9a","Jana Israel-warrangka bubu Rephidim bawanda, dungan, dungan, bubungu marralba Sinaimunbu kadan. Jana jananga bayan ngaran bada-bada wuburrbu Mount Sinaimunbu. Moses wangkar-wangkar wuburrbu dakan, maku-jananka Godundu. Godungku nyungundu balkan jananda Israel-warranda balkanka, “Yurra nganya nyajin Egypt-warra buyun-damanya. Ngayu yurrangan ngulkurrduku kujin yala wandingka nyungu kangkal kujil. Ngayu yurrangan yaluy wundin, ngaykundu. Kaki yurra nganya kuku-nyajil and law wukurril, yurra ngaykukuda bama. Bubu wubulku yiringkurrku ngayku, yamba ngayu yurraninku wangkanin ngaykumanka, nganyaku wukurrinka.” Moses wuburrmun walanda, council-council muru-bungan, jananda balkanda junjuy-junjuy Godungku nyungundu balkan. Yinyamun jana Israel-warrangka murubuku yalaman, “Nganjin God kuku-nyajil, nyunguku kuku wukurril.” Mosesangka Godundu balkan. Godungku Mosesanda yalaman, “Ngayu yurranda kaday, ngurrbanji yalbaynji, jana Israel-warrangka nganya nyajinka yununji balkal-balkawanya ngurrbanmun. Yinyamun jana yunun manubajabuku kuku-nyajilda.” ");
INSERT INTO gvn_vpl VALUES ("EX19_9b","003_19_9b","EXO","19","9b","12","Mosesangka Godundu balkan wanyu jana Israel-warrangka yalaman. Godungku nyungundu yalaman, “Jananda bama-bamanda balka nyiku, wunkun dayirrmanka, nganya buyay-maninka. Jana kambi julurrika, warngku yindumal readymanka ngaykunku. Warngku yindu ngayu jirimun kaday Mount Sinaimunbu, jana wubuliynjaku ngayku junkurr nyajinka. Mark wuburrdurr balka, jananda balka kari naka-naka markmunbu dunganka. Jananda balka kari wuburrbu kaday, yalarrku kari yuba kaday. Kaki bama wuburrbu kaday, nyulu wulay.” ");
INSERT INTO gvn_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","19","Warngku kulurman yalibalaku jarramali, balbay muruku kadan. Ngurrban yalbay bajaku milbijin wuburrbu. Jana trumpet wuburrmun milkabu nyajin, yaykarr bajaku yirrkanya. Jana Israel-warra yinyilmarin, yararrinkuda. Mosesangka jananin wundinda, Godundu maku-jananka. Jana bada-bada wuburrbu janarin. Kububu wuburr kanbinyarrku, Maja God bayaji kadan. Kubu dakan yala ngalkumun, jirray bajaku. Jana yinyilmarin baja, numburr trumpetmun jirraymalman. Bula God, Moses balkawaynda. ");
INSERT INTO gvn_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","2","Godungku kuku dajin, yalaman, “Ngayuku yurranga Maja, yurranga God. Ngayuku yurranin ngulkurrduku bubumun Egyptmun wundin kulimun. ");
INSERT INTO gvn_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Kari kanbal god wukurrika, kari Dubu wukurrika. ");
INSERT INTO gvn_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","6","“Kari ngurma junjuy-junjuy balka, Dubu wukurrinka. Kari yinyarrinyanda junjuy-junjuyundu dukul badamaka. Ngayuku yurranga Maja, yinyarrin junjuy-junjuy kari. Kaki bama ngaykunku wawu-karimal, ngayu nyungun punishim-bungal, nyungun, and nyungu jawun-karra nyungundumun kaday. Kaki bama ngaykunku wawu jirray bajaku and ngayku kuku wukurril, ngayu manubajaku jananka wawumal, yalarrku wawu bamanka janandamun kaday. ");
INSERT INTO gvn_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Ngayku burri kari buyun-dama junjuy-junjuynku. Ngayuku yurranga Maja, ngayuku yurrangan manubajabuku punishim-bungal. ");
INSERT INTO gvn_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","11","“Saturday ngaykuku. Saturdaymundurr wawu-balangajika, milkanga ngaykunjiku bunday; yinya ngayku day. Ngayu yurranga 6 days dajin workmanijinka, warngku yindumalda wawu-balangajika, milkanga ngaykunjiku bundarika. Ngayu yurranda balkal baja, kari workmaka ngaykuwunbu daymunbu, wawu-balangajika. Yurra, yurranga kangkal-kangkal, yurranga workingman, yurranga minya-minya, yalarrku bama ngarrbal-ngarrbal yurranji bundanday, bubumun yindumun, yurra wubulku wawu-balangajika. Ngayu yanyu bubu balkan, ngayu yalarrku jiri, jalun, junjuy-junjuy wubulku balkan 6 daysmunbu. Warngku yinduman ngayu bundan, wawu-balangajin. Yinyaynka ngayu yanyu day ngayku-bungan, bama wawu-balangajinka. ");
INSERT INTO gvn_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Ngamu, nganjan kuku-nyakaku, yurra yinyaynka ngadingka bunday yinyaymba bubungu ngayu yurranda dajil. ");
INSERT INTO gvn_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kari bama yarkinkaku kuni. ");
INSERT INTO gvn_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Kari manyarr, dunyu yindu-yindu mana. ");
INSERT INTO gvn_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kari junjuy-junjuy ngaki. ");
INSERT INTO gvn_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Kari kuku jurril daya bama-bamanka. ");
INSERT INTO gvn_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Kari yindu-yinduymbu bamamu junjuy-junjuy ngura-nyaka, yala nyungu bayan, nyungu manyarr, nyungu workingman, nyungu minya-minya, nyungu yamba-yamba, junjuy-junjuy wubulku kari ngura-nyaka.” ");
INSERT INTO gvn_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","21","Jana Israel-warrangka numburr nyajin jarramalindamun, trumpetmun, jana balbay nyajin, wuburr kubuji, jana yinyilmarin, kala-kalbay janarin. Jana Mosesanda yalaman, “Yundu nganjinanda balkawaka, nganjin yunundu milka-janay. Yamba nganjin yinyilmari; kaki God nganjinanda balkaway, nganjin wularikuda.” Mosesangka jananda balkan, “Kari yinyilmaka. Godungku yurranin milka-bakanka, yurranin yinyil-bungal-bunganka, because nyulu yurranin wawu kari nyajinka buyun balkanka.” Yamba jana kala-kalbayku janjanarin. Yinyamun Mosesku yuba kadan Godundu, ngurrbanba ngumbungu. ");
INSERT INTO gvn_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","7","Mosesangka jananda Israel-warranda balkaynda wanyu Godungku nyungundu balkan. Jana muruku yirrkan, “Nganjin kuku wubulku wukurril nyulu yunundu balkan.” Mosesangka Godumu kuku wubulku writeim-bungan kabanba. Warngku yindu nyulu yalibalaku dakan, kulji muru-bungan, altar balkan bada-bada wuburrmun. Nyulu kulji 12-bala jajirrin, Israelandamunku kangkal-kangkalanka 12-balanka. Yinyamun nyulu dingkar-dingkarda yungan, bulki maninka, Godundu dajinka. Jana minya bulki kuljinga wuyar yijarrin, wayjunda, Godumu. Jana wayjunjiku, Mosesangka mula kanbal manin, kuljinga yilbanka, milbinka jana Godunji wawumanya. Yinyamun nyulu nyungu kabanda manin Godundumunji kukuji, nyulu yaykarrdaku readim-ban Israel-warranda. Jana yalaman, “Nganjin Godku kuku-nyajil, nyunguku kuku wukurril yala nyuluku balkan.” ");
INSERT INTO gvn_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","18","Godungku juma Mosesanda yalaman, “Wangkar-wangkar wuburrbu kaday ngaykundu. Yundu yaluy kadayda, ngayu yunundu kulji jambul dajil. Yinyaymba kuljinga ngayu ngayku kuku writeim-ban ngayu yurranda dajin, wukurrinka.” Moses bula Joshua readyman, buban dungan, yamba Mosesangka Joshua nyungunyurrku bawan, dungan baja Godundu. Nyulu wangkar-wangkar wuburrbu dakan, ngurrbanda wuburr nandan. Bula wuburrbu bundan 40 daysanka. ");
INSERT INTO gvn_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","6","Moses wuburrbu bundandan 40 daysanka, jana Israel-warrangka nyungun kari nyajin. Jana murumarin, Aaronanda yalamanda, “Yala Moses wanjabu? Nyulukubi nganjinin Egyptmun wundin, yamba nyulu nganjinanka walu-kunbanda. Ngurma balka yala God, nganjinin wundinka baja.” Aaronangka jananda yalaman, “Yurranga junjuy-junjuy goldmun ngaykundu wundi.” Jana junjuy-junjuy goldmun mujan, Aaronanda wundin. Nyulu manin, gold meltim-bungan bayabu, nyulu junjuymbu yijarrin, ngurma statue balkanka yala bulki. Nyulu yinyamundu bulkida balkan, goldmun. Jana Israel-warra jana-karrajiku balkawan, “Yurra, yanyuda ngananga god, nyuluku ngananin Egyptmun wundin.” Aaronangka altar ngaran, jakalba bulkinga goldmun, yalaman, “Ngana wunkun party haveim-banka, Godunku.” Warngku yindu jana yalibalaku minya-minya wundin, wayjunku, kanbal dajinka yinyayanda bulkinga goldmun jana balkan, kanbal nukanka. Jana mayi jirray nukan, yinyamun kamukamu nukan, drunkmanijirin, manyarr, dunyu yindu-yindu manin, God buyun-daman. ");
INSERT INTO gvn_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","14","Majangka Godungku Mosesanda yalaman, “Bama-bamandaku dungay baja. Yundu jananin Egyptmun wundin, yamba jana buyunman, ngaykundumun jurrkijin. Jana ngayku kuku kari wukurril baja. Jana bulki statue goldmun balkan, burri dalkin god, buyay-manin, minya dajin. Jana jana-karrajiku balkaway, ‘Yanyu ngananga god, nyulu ngananin Egyptmun wundin.’ Ngayu jananka binal, jana dukul-dandi bajaku. Nganya kari kiri. Ngayu kuliji jananka, janangan kunbay-maninka. Yinyamun ngayu bama yunundumun wubul-bungal, junkurrji-bungal, jana kanbal Israel-warra karrnga-dajinka.” Yamba Moses walu-dandiku Godundu babajin Israel-warranka. Nyulu Godundu yalaman, “Maja, yunuwunku bama-bamanka kari kulimaka. Yunduku jananin Egyptmun junkurr-murubuku wundin. Kaki yundu jananin kunbay-manil, jana Egypt-warrangka balkanji, ‘Godungku nyungu bama yaluymun wundin, wuburrbu kunbay-maninkarrku.’ Kari kulimaka baja. Kuku jurrki. Yunu bama-bama kari kunbay-mana.” Moses Godundu babajinya, Godungku kuku jurrkin, nyungu bama-bama kari kunbay-manin. ");
INSERT INTO gvn_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","18","Moses bula Joshua bada-bada wuburrmun walan baja, kuljiji jambulinji Godundumunji kukuji. Godungkuku wuburrbuku yinya kulji jambul-bulal balan-balan-bungan, nyungu kuku kuljingada writeim-bungan. Joshuangka nyirray nyajin, Mosesanda yalaman, “Jana nguba kunin-kuniway, mabarrka, warmunku.” Yamba Mosesangka yalaman, “Kari. Mabarrka kari. Jana wulngku banbadi.” ");
INSERT INTO gvn_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","20","Moses yuba campmunbu kadan, nyulu bulki statue nyajin, bama nyajin wurin-wurinya. Nyulu kuli-kadan bajaku. Nyulu kulji jambul-bulal kukuji yilban, dumbarrin. Nyulu bulki statue manin, bayabu kima-bungan, dirka-bungan, bananga murnin. Yinyamun nyulu Israel-warra mambarrin yinya bana goldji nukanka. ");
INSERT INTO gvn_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","24","Nyulu Aaronanda yalaman, “Jana bamangka yunundu wanjarrman? Yundu wanyurrinku jananin mambarrin buyunmanka?” Aaronangka yalaman, “Ngaykunku kari kulimaka. Yundu jananka binal, jana wawu jirray buyun wukurrinka. Jana ngaykundu yalaman, ‘Nyulu Moses wanjabu? Bama yamba-kari, ngananin wundinka baja. Ngananga god balka, ngananin wundinka baja.’” Aaronangka yalaman baja, “Ngayu jananda balkan jananga rings and junjuy-junjuy goldmun ngaykundu wundinka, ngayu yinyarrin junjuy-junjuy bayanga yilban, yanyu bulki statue wandinda, bayamun.” Nyulu jurril yalaku balkan. ");
INSERT INTO gvn_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","35","Yinyamun Mosesangka Majanda Godundu yalaman, “Jana bamangka buyun jirray balkan. Jana ngurma bulki goldmun balkan, burri dalkin god, yinya bulki buyay-manin. Yamba yundu janawunku buyun-buyunku milka-wulayda. Yundu burri wubulku yunuwunbu bama-bamamu writeim-ban yunuwunbu kabanba. Jana yunundumun jurrkijinya, yundu jananga burri nguba rubim-bungal yunuwunmun kabanmun. Kaki yundu janawunku buyun-buyunku kari milka-wulay, ngayku burri yalarrku rubim-bunga yunuwunmun kabanmun. Kaki yundu janawunku buyunku kari milka-wulay, ngayu wawu kari yunu bamamanka baja.” Yamba Majangka yalaman, “Kaki bama ngaykundumun jurrkiji, ngayu janangaku burri rubim-bal kabanmun. Yundu dungayda, jananin wundi bubungu ngayuku yunundu balkan. Milkabu kuji, ngaykuwundu angelangka yunun wundil. Yamba ngayu juma jananin bama punishim-bungal, buyun-buyunku jana balkan. Ngayu kari milka-wulay.” Godungku bama-bama bambay-bunganda, jana Aaron mambarrinya bulki statue balkanka. ");
INSERT INTO gvn_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","4","Majangka Godungku Mosesanda yalaman, “Kulji jambul-bulal balan-balan-bunga, yala yinya kulji jambul yundu dumbarrin. Ngayu kuku writeim-banka baja, yala ngayu kuljinga jakalbaku writeim-ban. Yundu wunkun yalibalaku ngaykundu kaday, wangkar-wangkar wuburrbu Mount Sinaimunbu jarra-jarranga. Kari bama yununji wundi; kari bama wuburrbu yuba kaday, sheep, and bulki wuburrbu yalarrku kari yuba kaday jikanka.” Mosesangka kulji jambul balan-balan-bungan, nyulu warngku yindu yalibalaku wandin, jarra-jarranga wuburrbu Mount Sinaimunbu wundinda, yala Majangkaku balkan. ");
INSERT INTO gvn_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","8","Maja God ngurrbanji bada kadan, Mosesandaku janan. Maja jakalba Mosesanda walkuku dungan, yalaman, “Ngayu Maja God. Ngayu bamanka manun-manun bajaku, kari jinbalku kulimal, bamanka wawu jirray bajaku, jananin kari bawal. Ngayu ngayku promise kujilarrku bamanda wubulbuku.” Moses jinbalku dukul badaman, Maja God buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses Majanji 40 daysanka bundandan, nyulu kari mayi nukan, bana kari nukan. Godungku kuljinga jambulbu nyungu kuku writeim-ban baja, Ten Commandments. ");
INSERT INTO gvn_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","30","Moses bada-bada wuburrmun Mount Sinaimun walanda, kulji jarra-kulbal-kulbanya, Ten Commandmentsmunji. Nyulu walu dayirr bajaku, Majanji Godunji balkan-balkawanya. Yamba nyulu yinyaynka binal kari nyulu walu dayirrman. Jana, Aaron, bama-bama wubulku, jana Moses nyajin walu dayirr bajaku, jana yinyilmarin, yuba kadanka Mosesanda. ");
INSERT INTO gvn_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","(Exodus 35-40) Godungku Mosesanda yalaman, “Bamangka ngayku tent balka, ngayu jananji bundanka. Tent, junjuy-junjuy balka yala ngayu yunundu balkal.” Mosesangka Israel-warranda yalaman, “Majangka Godungku yurranda kuku dajin. Junjuy-junjuy Majamu daya. Kaki bamangka wawurr-wawurrduku dajinka, nyulu junjuy-junjuy wundi, gold, silver, bronze, mararr, wool, mararr goatundumun mungkamun balkan, sheep yulban ngala-ngala, bulki yulban, juku ngulkurr yamba-yamba balkanka, oil, spices, kulji jewels wundi.” Jana Israel-warrangka jirray bajaku wawurr-wawurrduku wundin, Godumu dajinka. Jana yinyarrinmun junjuy-junjuymun Godumu tent and junjuy-junjuy balkan, yala nyuluku jananda kuku dajin. Room jambul tentmunbu, jana curtain walngkan-daman, room jambul-bunganka. Jana box ngulkurr balkan Godumu, yijarrin tentmunbu roommunbu kananga bajaku. Jana yinya-bulal kulji balan-balan jambul-bulal Godundumunji kukuji yijarrin boxmunbu. Jana junjuy-junjuy Godumu yalarrku balkan, tentmunbu yijarrin. Jana wubulku Godumu kunbay-manin, tent dayirr-dayirr bajaku, bamanda milbin, God yinyaymba. Jana dunganya, tent ngami-ngami-bunganya, jarra-kulbanya. Jana bundanya baja, tent ngaranya baja, yalaku, yalaku. Godungku Aaron wangkanin priestmanka. Nyungu kangkal-kangkal dingkar-dingkar nganjanandamun priestmanya, jananga kangkal-kangkal dingkar-dingkar nganjanandamun priestmanya, yalaku, yalaku. Godungku kuku dajin, holidaymunku. Jana Saturdaymundurr kari workmanijinya, wawu-balangajinya. Nyulu holiday Passover dajin, bamangka milkanga kujinka Godungku jananin kulimun wundin, bubumun Egyptmun. Nyulu yindu-yindu holiday yalarrku dajin. ");
INSERT INTO gvn_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","28","Moses Godundu babajin, “Maja, nganya naka-naka wawubajanga Jordanba yunga. Ngayu bubu Canaan nyajinka, bubu ngulkurr-ngulkurr bajaku.” Yamba Godungku nyungundu yalaman, “Kari. Kari babajika baja. Jarra-jarranga wuburrbu Mount Pisgahmunbu dungay, yinyamun bubu wubulku walu-wukurrika. Bubu mumbarabuku nyaka, yundu yinyaymba bubungu kari dungay. Joshuanda kuku daya. Nyungun junkurrji-bunga, nyuluda jananin Israel-warra yinyaymba bubungu wundil.” ");
INSERT INTO gvn_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","(6.4-5;11.26-28) Mosesangka Israel-warranda yalaman, “Yurra, milkabu yanyu kuji. God nyuluku ngananga Maja. Nyungunku wawumaka manubajaku, wawumaka junkurr-muruku, wawurr-wawurrku wawumaka. Ngayu yurranda babaji, yurra wanyaku wukurrinka? Yurra ngulkurrku bundanka or buyunku? Kaki yurra Majandaku milka-janay, nyulu yurranin ngulkurrduku kujil, wawurr-wawurr-bungal. Kaki yurra walu-dandiku nyungun kuku kari nyajil, and yindu god-god wukurril, nyulu yurranin buyun-damal.” ");
INSERT INTO gvn_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Mosesangka yalaman baja, “Nyulu nyubun bama juma yurranda yungal, nyulu yurrandamun balkaji. Nyulu yala ngayu. Yurra nyungundu kuku-nyaka.” ");
INSERT INTO gvn_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","8","Mosesangka Joshuada kunjan, jananda Israel-warranda miyilbaku yalaman, “Junkurrjimaka. Munamakada. Yunduda jananin Israel-warra wundil bubungu Godungku nganawunbu jawun-karranda promiseim-bungan. Godku yununji dungay, nyuluku yunun wundil. Nyulu yunun kari bawal, yinyaynka kari yinyilmaka, munamaka.” ");
INSERT INTO gvn_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Mosesangka yalaman baja, “Yurra Israel-warra, yurra wawurr-wawurrku bundanday. Bama kanbal yamba-kari yala yurra. Godungkuku yurranin ngulkurrduku kujil wawurr-wawurrku. Bama-bama kuliji yurranda kaday, kuniwanka, Godungkuku yurranin junkurrji-bungal, yurra jananin kangalkuda.” ");
INSERT INTO gvn_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","8","Moses wuburrbu Mount Pisgahnda dakan, yinyamun Godungku nyungundu bubuda milbin, bubu Godungku juma Israel-warramu dajil. Mosesangka walu-wukurrinda. Yinyamun Moses, Godumu jawun yinyayda wulan, yala Godungkuku nyungundu balkan. Godungku yinyayku nyungun nandan. Bama wubulku binal kari nyunguwunku juljalanka. Moses wulman bajaku, nyulu 120 years oldman, wulaynda. Jana Israel-warra nyungunku badin 30 days. ");
INSERT INTO gvn_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","10","Jana Israel-warra ngadiku bububurr marraldarr dungan-dungan, bama buyun-buyun bubumun Canaanmun kangan-kangan, Godungku miracle yalbay wubul junkurr-murubuku balkan, jananga help dajinka. Jana janandamunbu kangkal-kangkalanda balkan, Godunku, miracleka. Jana mukulman, wulan, jananga kangkal-kangkal yalbayman. Yamba jana kangkal-kangkalangka kuku nganjan-karrandamun kari wukurrin, jana God bawan. ");
INSERT INTO gvn_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","19","Jana Israel-warra buyunmanda Godunku. Jana yinduda god wukurrin, burri Baal, nyulu Dubundumun. Majangka Godungku ngadiku jananga nganjan-karra bubumun Egyptmun wundin, yamba jana nyungunku wawu-kariman. Jana yalaku walu-dandimalman, god yindu-yindu wukurril-wukurrinya. Yinyamun Maja God jananka kuli-kadaynda. Nyulu bama buyun-buyun kari nyandinya, jananji kuniwanka, junjuy-junjuy ngakinka. Godungku bama kuli-baka junkurrji-bunganya, jananin Israel-warra ngangkal-ngangkal-bunganya. Yinyamun Godungku nyubun bama ngulkurr Israel-warrandamun wangkaninya, majamanka, kanbal helpim-bunganka. Godungku yinya bama junkurrji-bunganya, jana Israel-warrangka jananin bama kuli-baka kanganya. Yamba jana Israel-warrangka jananin ngulkurr-ngulkurr kari kuku-nyajinya. Jana Israel-warra dukul-dandi bajaku, God wawu kari wukurrinka. Janawundu nganjan-karrangka ngadiku Joshua wukurrin, Joshuanji bama buyun-buyun kangan bubumun Canaanmun, yamba nyiku-nyiku jana God bawanda, kari manubajabuku wukurrin. Godungku jananga bama ngulkurr dajinya janandamunku, nyulu yinya bama junkurrji-bunganya, jananin ngulkurrduku kujinka bamandamun kuli-bakandamun. Yinyamun dingkar ngulkurr wulanya, jana Israel-warra buyunmanya baja. Jana buyunman baja, buyunman baja, Godungku bama kuli-baka yunganya baja. Jana Israel-warra Godundu yirrkanya helpmunku, nyulu jananga bama ngulkurr yunganya. Yinya bama wulanya, jana buyunmanya baja, yalaku, yalaku. ");
INSERT INTO gvn_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","16","Jana Israel-warra buyunmalmanya baja Godundu, nyulu yinyamun Midian-warra yungan, jananka Israel-warranka majamanka 7 yearsanka. Jana Midian-warra kadan, maja-majaman bajaku, mayi ngakin, yamba-yamba junjuy-junjuy ngakin, bubu buyun-daman. Israel-warra yalaku bundandanda, ngangkal-ngangkalku. Yinyamun jana Israel-warra Godundu yirrkan helpmunku. Jana yirrkan, yirrkan, Godumu angel juma kadan jukungu nyubunyimba. Yinya bubu Joashamu. Nyungu kangkal Gideon, nyulu jankungu yalbaymba kiraynjaku mayi wheat dudal-dudan, mayi maninka. Nyulu jankungu dudal-dudan, jana Midian-warrangka nyungun nyajinji, mayi ngakinji. Godumu angel nyungundu milbijin, yalaman, “Godku yununji, yundu munamal, junkurr-muruku dungay-dungay.” Gideonangka yalaman, “Ngayu yununduda babajinka. Kaki Maja God nganjinanji, wanyurrinku yalarrin bama kuliji kadan? Nganjinandamundu nganjan-karrangka nganjinanda kuku balkan miraclemunku Godungku junkurr-murubuku balkan, jananin kulimun wundinka, bubumun Egyptmun. Yamba Godungku nganjinin bawanda, jana Midian-warra majaman nganjinanka.” Yinyamun Maja Godungku yalamanda, “Junkurr-muruku dungayda, Midian-warra kanganka yurrawunmun bubumun. Ngayuku yunun yungal-yungal.” Gideonangka yalaman, “Ngayu wanjarr janangan Midian-warra kangal? Ngayku jawun-karra jarra yala, junkurrji kari. Jana kanbal nganjinanda kari milka-janay.” Maja Godungku yalamanda, “Yundu jananin Midian-warra kangalarrku, ngayuku yunun junkurrji-bunganya.” ");
INSERT INTO gvn_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","31","Jana Israel-warrangka yindu god burri Baal wukurrin. Nyulu Baal buyun bajaku, Dubundumun. Gideonangka Baalamu altar dumbarrin, bubunguda yilban, yinduda altar balkan Godumu. Warngku yindu jana bama yalibalaku warngkumun dakarin. Jana altar Baalamu nyajin bubungu wunananya, kankur-kankurku. Jana jana-karrajiku babajin, “Wanyangka dumbarrin?” Jana babajin, babajin, binalmaynda, Gideonanka, Joashamu kangkal, nyulu dumbarrin. Yinyamun jana Joashanda yalaman, “Yunu kangkal yaluy wundi, nganjin nyungun yarkin-bunganka. Nyulu nganjinanga altar dumbarrinya.” Yamba Joashangka jananda yalaman, “Wanyurrinku yurra Baal wukurrinka? Bamangka nyungun buyay-manil, jana wularikuda. Kaki nyulu Baal maja God, balu nyuluku kujijika. Nyungukubi altar dumbarrijin.” ");
INSERT INTO gvn_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","40","Yinyamun Gideonangka Godundu yalaman, “Yundu ngaykundu balkan yundu nganya yungal, Israel-warra kujinka. Ngaykundu yunu junkurr milbi. Ngayu yanyu wool bubungu yijarril. Kaki yanyu wool dunamal dewmun, yamba bubu kari dunamal, ngayu manubajaku binalmalda yundu nganya yungan, Israel-warra helpim-bunganka.” Warngku yinduman Gideon yalibalaku dakan, dungan, woolda dingkan, bowl jakal-bunganyarrku banabu. Yamba bubu marralku bundan. Yinyamun Gideonangka Godundu yalaman baja, “Kari ngaykunku kulimaka. Ngayu yununji balkawanka baja. Ngayu yanyu wool bawal baja. Yanyu wool marralku kuji, yamba bubuku dunaka.” Warngku yinduman baja, Gideon yalibalaku dakan, dungaynda, wool karrbanka. Wool marral-marralku wunanan, bubuku duna. ");
INSERT INTO gvn_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","8","Yala-yalaku Gideon, soldier-soldier wubul bajaku murumarin yubaku buraymba, jana yinyayda wunan. Midian-warramu camp naka-naka janandamun, bada-bada balaymba. Majangka Godungku Gideonandada yalaman, “Yunu soldier-soldier wubul bajaku. Kanbal yunga baja. Jana balu janaku Midian-warra kangal janawunduku junkurrduku, ngaykuwundu junkurrdu kari. Yinyamun jana bulmbuymanji, nganya kari kuku-nyajinji baja. Jananda balka, ‘Kaki yurra yinyil, yurra bayanbaku dungay baja. Nganjin kanbal yaluy bunday.’” Gideonangka God kuku-nyajin, jana kanbal yinyilji, jana bayanbaku dungarinda. Kanbal bundarin, kulur. Yamba Majangka Gideonanda yalaman baja, “Yunu soldier-soldier still wubul bajaku. Kanbal yunga baja. Jananin bada-bada yilkinga wundi, ngayuku jananin ngami-ngami-bungal. Kaki jana badamal, bungkubu bunday, bana ngandalda nukanka, jananin bayanbaku yunga baja. Kaki jana marabuku bana manil, dakal baja, bana nukanka, jananin yununjiku kuji.” Gideonangka jananin wubulku banangada wundin, 300-balangka bana marabuku manin, dakan baja, nukanka. Jana kanbal wubul, jana badaman, bungkubu bundan, bana ngandalda nukanka. Godungku Gideonanda yalaman, “Ngayuku yurranin juran-bungal, Midian-warrandamun. Ngayu jananin 300-bala useim-bungal, Midian-warra winim-bunganka. Jananin kanbal yunga baja bayanbaku.” Gideonangka jananin kanbal bayanbaku yungan baja, wubul bajaku. Nyulu 300-balaku nyungunji kujin, yala Godungkuku balkan. Jana 300-balangka trumpets kujin, yalarrku kalka and junjuy-junjuy kuniwanka warmunku kujin. ");
INSERT INTO gvn_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","22","Wujurrman nguwul-nguwulman, Gideonangka 300-balanda yalaman, “Wandida! Godungku jananin Midian-warra kangalkuda.” Nyulu 300-bala soldier-soldier ngami-ngami-bungan, 100-bala yarra yunganka, 100-bala yarra yunganka, 100-bala yarra yunganka, yalaku. Yinyamun nyulu wubuliymbaku soldier-soldieranda dajin, trumpet and junjuy yala dubal and jidi. Jidi kananga dubalba wayjun-wayjujinya, Midian-warrangka light kari nyajin. Gideonangka soldier-soldieranda yalaman, “Ngayu janandamunbu campmunbu yuba kaday, nganya kunkun-bunga, balka yala ngayu balkal. Nganjin 100-bala janawunbu campmunbu yuba kaday, nganjin trumpet yaykarrdaku balkal. Yurra nyajil, yurrada trumpet yalarrku yaykarrdaku balkal, yirrkayda, ‘Majanka Godunku, and Gideonanka.’” Gideonangka 100-bala nyungunji wundin, kanbal yungan, jana yinyayngkarr Midian-warrandamundurr campmundurr jananka. Nyulu 100-balanji campmunbu yuba kadan, jana trumpet yaykarrdaku balkan, junjuy yala dubal dumbarrin, jidibu balbanka. Jana wubuliynjaku yinyarrin junjuy yala dubal dumbarrinda. Jana jidi kujin marabu nyubunyinja, trumpet kujin marabu yinduynju, yaykarrku yirrkan, “Naybu Majanka, and Gideonanka.” Jana 300-bala jidijiku janjananya campmundurr, jana Midian-warrangka light wubul bajaku nyajin, balu soldier-soldier wubul bajaku. Jana Midian-warra warrarin, yinyil-yinyiljiku, kawal yirrkay-yirrkanya. Jana 300-balangka trumpet balkan-balkan, Majangka Godungku Midian-warra mambarrin jana-karrajiku kuniwanka, damawanka. Jana Midian-warra warrarinkuda. ");
INSERT INTO gvn_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","23","Wawu yinyamun Israel-warrangka Gideonanda yalaman, “Nganjinanga majamaka, kingmaka. Juma yunu kangkal yunundumun kingmal, yalaku.” Yamba Gideonangka yalaman, “Ngayu yurranka kari majamal, ngayku kangkal yalarrku kari. Maja Godku ngananga maja bajaku, king.” ");
INSERT INTO gvn_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","(Judges 13-16) Jana Israel-warra buyunman baja. Yinyaynka Godungku jananin Philistine-warra kari nyandin Israel-warranka majamanka. Jana Philistine-warra ngadingka majaman Israel-warranka, 40 years. ");
INSERT INTO gvn_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","25","Yala-yala nyubun bama, burri Manoah townbu Zorah bundandan. Nyunguwundu manyarrangka murruji kangkal manin. Yamba angel nyungundu kadan, yalaman, “Yundu kangkal kariku, yamba yundu juma kulngkulmal, kangkal dingkar balkajida. Milka-janay, yundu mayi yirmbal and kamu-kamu kari nuka. Yunu kangkal balkaji, nyulu Godumu bamamal. Yinyaynka nyulu kamu-kamu kari nuka, mungka kari yakajika. Nyulu jaba-jabamal, nyulu Israel-warra help dajil, Philistine-warra yurrandamun kanganka.” Juma ngawa dingkar balkajin, ngamungku nyungun burri dalkin, Samson. Nyulu yalbaymalman, Godungku nyungun junkurrji-bungan. ");
INSERT INTO gvn_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","4","Samson townbu Timnah dungan. Yinyaymba nyulu maral nyajin Philistinemunku. Nyulu bayanbaku kadan baja, bulanda ngamundu, nganjananda yalaman, “Ngayu Philistinemunku maral nyubun nyajin townbu Timnah. Ngayu nyungunku bujanji, wunanka. Yubal nyunguwunji ngamunji, nganjananji balkawaka, maral mana, ngayku dajinka.” Yamba bula ngamungku, nganjanangka yalaman, “Yundu wanyurrinku maral Philistinemunku wunanka? Yundu maral nganandamun bubumun warrmba-bunga.” Yamba Samsonangka yalaman, “Ngayu yinyaynka jalbunku bujanji wunanka. Yubal mana, ngayku dajinka.” Bula ngamu, nganjan binal kari Godungku Samson Philistine-warranda yunganka, kuninka, jana maja-karimal baja Israel-warranka. ");
INSERT INTO gvn_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","7","Yala-yala Samson, nyungu ngamu, nganjan, jana townbu Timnah dungan-dungan. Jana baraldarr dungan-dungan, Samsonangka lion nyajin yirrkanya. Godungku Samson jinbaldaku junkurrji-ban. Samsonangka baral nyulurrku bawan, lion karrban, dumbarrin yala nanny goat, yarkin bawan. Yinyamun nyulu maralanda dungan, nyungunji balkawan. Nyulu nyungunku bujanji. ");
INSERT INTO gvn_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","20","Juma nyulu townbu Timnah dungan baja, maral wunanka. Nyulu dungan-dungan, nyulu baral bawan, yarkin lion nyajinka. Kari, nyulu mayi wunba nyajin yarkinba. Nyulu wunba yarkinmun manin, nukan. Nyulu ngamundu, nganjananda yalarrku wunba dajin. Nyulu maral wunan, yamba juma nyulu nyungun bawan. Wawu yinyamun jalbundumundu nganjanangka, ngamungku nyungu manyarr yinduymbu bamanda dajin, wunanka. ");
INSERT INTO gvn_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","2","Juma Samson dungan baja, nyungu manyarr nyajinka. Nyulu binal kari nyunguwundu manyarrangka yindu bama wunan. Nyulu nanny goat karrkay wundin, manyarranda dajinka. Nyulu manyarrandamunbu nganjananda yalaman, “Ngayu manyarr nyajinka.” Yamba nganjanangka nyungun kirin, yalaman, “Ngayu balu yunun nyajin, balu yundu nyungun bawan. Yinyaynka ngayu nyungun bamanda yinduymbu dajin. Nyungu jinkurr jarra walu-mini-mini nyungunku. Yundu nyungun mana, wunanka.” ");
INSERT INTO gvn_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","5","Yamba Samson kuli-kadan, yalaman, “Ngayu Philistine-warra buyun-damalkuda.” Mayi wheat kulbulman paddockmunbu bubungu Philistine-warramu. Samsonangka kaya dingo 300-bala karrban, jambul-jambulku biji karrabu kajan, jidi kajan bijinga. Nyulu jidi wubulku wayjun, kaya dingo yiringkurrku yungan Philistine-warrandamunbu paddockmunbu. Mayi wheat kulbul wubulku wayjujin, yalarrku mayi olive jukungu wayjujinkuda. ");
INSERT INTO gvn_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","8","Philistine-warra babajin, “Wanyangka bayabu mayi wayjun?” Jana binalman Samsonangka wayjun, nyunguwundu ngalayinangka manyarr nyungu yinduymbu dajinya. Yinyaynka jana Philistine-warrangka nyunguwunbu ngalayinamu bayan wayjun, Samsonamu manyarr bayanga yilban, wayjujin. Samsonangka kuku nyajin, nyulu yalaman, “Yurra yala, ngayku manyarr yarkinkaku kuninya, ngayu yurranin yalarrku kunil.” Nyulu kuniwan jananji Philistine-warranji, wubul bajaku yarkin-ban. Yinyamun nyulu cavemunbu dungan, ngamaranga. ");
INSERT INTO gvn_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","10","Jana Philistine-warra soldier-soldier bubungu Judah kadarin, town nyubun buyun-daman. Jana Israel-warra townmun babajin, “Yurra wanyurrinku nganjinanji kuniwanka?” Jana yalaman, “Nganjin Samson karrbanka, jailba mumbanka, nyulu nganjinin buyun-damanya.” ");
INSERT INTO gvn_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","13","Yinyamun Israel-warra dingkar-dingkar 3000-bala Samsonanda cavemunbu dungan, nyungundu yalaman, “Jana Philistine-warra junkurrji, ngananga maja. Yundu jananin kuli-kaday-manin, ngananin buyun-damanka.” Samsonangka yalaman, “Jana nganya buyun-daman, ngayu jananin buyun-daman baja.” Yinyamun jana Israel-warrangka Samsonanda yalaman, “Nganjin yaluy kadan, yunun karrabu kajanka, jananda Philistine-warranda dajinka.” Samsonangka yalaman, “Yurra promiseim-bunga yurra nganya kari yarkin-bunga?” Jana yalaman, “Yalada, nganjin yunun kari yarkinkaku kunil. Nganjin yunun karrabu kajal, jananda mambarril.” Jana Israel-warrangka karra jirakal manin, Samson kajan, cavemun wundin. ");
INSERT INTO gvn_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","15","Jana Philistine-warrangka nyungun nyajin, jana nyungundu warrin, yirrkan-yirrkanya. Yamba Godungku Samson junkurrji-ban, Samsonangka karra dumbarrin yala bayabu wayjujinya. Nyulu bajibay karrban bubumun, jananin Philistine-warra wubul yarkinkaku kunin, 1000-bala. ");
INSERT INTO gvn_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","19","Yinyamun Samson wawu-wulan banaka. Nyulu Godundu yalaman, “Yundu nganya junkurrji-ban, Philistine-warra yarkinkaku kuninka, yamba ngayu wulayda, bana kari.” Yinyamun Godungku jirka balkan banaji, bana jirkamun warrin. Samsonangka bana nukan, ngulkurrmanda. ");
INSERT INTO gvn_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Samson Israel-warranka maja, 20 years, yamba Philistine-warra maja jirray bubuku Judahnka. ");
INSERT INTO gvn_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","5","Wawu yinyamun Samson bujanji yinduynku jalbunku, burri Delilah. Nyulu yalarrku Philistinemunku. Jana maja-maja Philistine-warra Delilahnda kadan, yalaman, “Yundu Samson jurril-bunga, ngana binalmanka nyulu wanyurrimun junkurr manin. Ngana binalmal, ngana nyungun burdal-bungal, karrbanka. Yundu nyungun jurril-bungal, nganjin wubuliynjaku ngami-ngamibuku yunu money jirray dajil, 11 hundred dollars.” ");
INSERT INTO gvn_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","9","Yinyaynka Delilahngka Samsonanda yalaman, “Yundu wanyurrimun junkurr manin? Kaki bamangka yunun burdal-bunganka, karrbanka, jana wanjarrmal yunundu?” Samsonangka nyungundu kari balkan, yamba nyulu Delilah nyungundu babajin baja, babajin baja. Samsonangka nyungun jurril-bungan, yalaman, “Bamangka 7-bala karra jirakal mana, karra bow and arrowmunku. Kaki jana nganya yinyarrinyandamundu karrabu kajal, ngayu burdalmalda.” Delilahngka 7-bala karra jirakal bow and arrowmunku manin, Samson yinyarrinyandamundu karrabu kajan. Jana Philistine-warra kadan, Delilah yirrkan, “Samson, Philistine-warra kankadarida!” Yamba Samsonangka yinyarrin karra easy-balabuku dumbarrin. ");
INSERT INTO gvn_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","12","Delilah babajin baja, babajin baja. Nyulu yalaman, “Yundu nganya jurril-bungan, kari manubajabuku balkan. Bamangka wanjarrmal, yunun burdal-bunganka?” Samsonangka jurril-bungan baja, yalaman, “Kaki bamangka nganya karrabu jirakalda kajal, ngayu burdalmal, yala bama kanbal.” Delilahngka karra jirakal manin, Samson karrabu jirakalda kajan. Philistine-warra kadan, Delilah yirrkan, “Samson, Philistine-warra kankadarida!” Yamba Samsonangka jinbaldaku easy-balabuku karra dumbarrin. ");
INSERT INTO gvn_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","17","Delilah yalaku Samsonanda babajin baja, babajin baja. Samsonangka nyungun jurril-bungan baja, jurril-bungan baja. Yamba nyulu juma baja-burraynda, manyarr babajinya, nyulu manubajabuku balkanda. Nyulu yalaman, “Ngayu mungka kariku yakajin. Kaki ngayu mungka kari yakaji, ngayu junkurrjiku bunday, junkurrji Godundumunji. Kaki ngayu yakaji, ngayu burdalmal yala kanbal bama.” ");
INSERT INTO gvn_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","22","Nyulu Delilah binal Samsonangka kuku manubajabuku balkan. Yinyaynka nyulu kuku yungan maja-majanda, yalaman, “Nyulu ngaykundu kuku manubajabuku balkan.” Jana maja-maja kadan, money wundin, Delilahnda dajinka. Yinyamun Delilahngka Samson manubu-wundin, nyungu dukul barungu wunay-manin, Samson warngku wunay-manin. Nyulu bama kunjan, nyulu bamangka Samsonamu mungka yakan. Yinyamun Delilah yirrkan, “Samson, wandida, jana Philistine-warra kankadarida.” Samson warngkumun wandin, nyuluku yalaman, “Ngayu junkurrji, jana nganya kari karrbal.” Yamba nyulu binal kari Godungku nyungun bawanda, mungka yakajinya. Jana Philistine-warrangka nyungun karrban, miyil naybubu bakan, nyungun miyil-burra-bunganka. Jana nyungun townbu Gaza wundin, chainda kajan. Yinyay nyulu workmanijin Philistine-warranda. Yamba juma nyungu mungka kalbayman baja. ");
INSERT INTO gvn_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","25","Jana Philistine-warra murumarin, jananga god buyay-maninka. Jana singman, “Ngananga god junkurrji. Nyulu nganangan junkurrji-bungan, Samson karrbanka.” Yinyamun jana Samson jailmun wundin, nyungun kuya-bunganka. Philistine-warrangka nyungun nyajin, jana janawunbu godundu singman baja, yalaman, “Yanyu bama kuli-baka, ngananin buyun-damanya. Yamba ngananga god junkurrji, ngananin junkurrji-bungan nyungunku.” ");
INSERT INTO gvn_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","30","Nyubunyinja karrkayangka Samson wayan. Samsonangka nyungundu yalaman, “Nganya postmunbu bada-bada bayanba waya, ngayu nalmbarrijinka.” Philistine-warra jirray yinyay, maja-maja 5-bala, bama 3000-bala. Jana wangkar-wangkar jijinga bundandan, Samson kuya-bungal-bungan. Yinyamun Samson Godundu prayman, yalaman, “Ngayku Maja God, ngaykunku kari milka-wulay. Nganya junkurrji-bunga baja, ngayu Philistine-warra kuninka baja, jana nganya miyil-burra-bunganya.” Samsonangka post jambul karrban bada-bada bayanba, yaykarrdaku jurrngan, yirrkan, “Balu ngayu wulay Philistine-warranji!” Nyulu post jambul jurrngan, bayan darankuda. Jana maja-maja 5-bala, and bama wubulku wularinkuda. Samson wulan, yamba nyulu yalarrku bama wubulku yarkin-bungan. ");
INSERT INTO gvn_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Yinyamun Samsonamu yabaju-karra kadan, yarkin bubungu Judah wundin. Jana nyungun juljalba nandan yuba nganjananda. Samson Israel-warranga maja 20 years. ");
INSERT INTO gvn_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","5","Ngadiku nyubun bama bubungu Israel, townbu Bethlehem bundandan. Nyungu burri Elimelech. Nyungu manyarr Naomi, kangkal dingkar-bulal jambul Mahlon, Chilion. Mayi yamba-kariman, jana bubungu Moab jurrkijin, mayika. Jana Moab bundandan, Elimelech wulan. Yinyamun bula yaba-yabajungku jalbu-bulal yinyamun bubumun manyarr-bungan, jalbu-bulal burri Orpah, Ruth. Wawu ten yearsmun dingkar-bulal wulan, jana jalbu-jalbu janarrku bundandan. Naomi dunyu-kari, kangkal-karimanda. ");
INSERT INTO gvn_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","14a","Jana, Naomi, buykuji-bulal Orpah, Ruth, jana bubungu Moab bundandan. Naomingka kuku nyajinda Majangka Godungku mayi jirray-bungan baja nyunguwunbu bamanga bubungu Israel. Yinyaynka nyulu readyman, bubunguku dunganka baja buykuji-bulalanji. Yamba jana bubanku dungan, Naomingka bulanda yalamanda, “Yubal ngamunduku dungay baja, yubalandamunbuku bubunguku. Ngayu Godundu babaji yubalanka manun-manunmanka, yala yubal manun-manunman ngaykunku, ngaykuwunku kangkal-bulalanka. Ngayu Godundu babaji yubalanda dunyu-bulal yindu dajinka, yubal wawurr-wawurrku bundanka, milka-marriku.” Yinyamun Naomingka bulangan kissim-bungan, yunganka. Yamba bula badin, yalaman, “Kari. Ngalin yununji dunganka, yunuwunbu jawun-karranda.” Yamba Naomingka yalaman, “Nyunbay baja, wanyurrinku ngaykunji kadanka? Ngayku kangkal dingkar yamba-kari, yubalanda dajinka, dunyu-bunganka. Jawun-karrandaku dungay baja. Ngayu wulbuman bajaku, kari marrymal baja, kangkal kari manil baja, yubalanda dajinka, dunyu-bunganka. God ngaykunku milka-wulan, nganya kari nyajil baja. Dungayda. Ngayu yubalanka jiba-badi.” Jana badin baja. Yinyamun Orpahngka biwul kissim-bungan, goodby-bunganka, jurrkijin, jawun-karrandaku dunganka baja. ");
INSERT INTO gvn_vpl VALUES ("RT1_14b","009_1_14b","RUT","1","14b","22","Yamba Ruthungku biwul karrban, wawu kari bawanka. Naomingka nyungundu yalaman, “Nyaka. Babarr jawun-karrandaku dungan baja, nyunguwunbuku godunduku. Nyungunji dungayda.” Yamba Ruthungku yalaman, “Kari. Ngayu yunun kari bawal. Ngayu yununjiku kadanka. Kaki yundu dungay, ngayu yalarrku dungay. Kaki yundu bunday, ngayu yalarrku bunday. Yunu jawun-karra ngaykumalkuda. Yunu God ngaykumalkuda. Bubungu yundu wulay, yinyaymba ngayu wulay, yinyaymba jana nganya nandal. Ngali juranku, ngayu yunundumun kari ngami-ngamimal; ngali muruku bundayarrku. Kaki ngayu yunun bawal, Godungku balu nganya yaykarrdaku punishim-bunganka.” Naomi binalmanda Ruth nyungunji dunganka, nyulu yalaman, “Yala. Ngali dungayda.” Bula muruku dungan, dungan, dungan, townbu Bethlehem kadan. ");
INSERT INTO gvn_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","3","Bama nyubun burri Boaz, nyulu jawun Naomindamunbu dunyumu. Nyulu money jirray bajaku, bama nyungundu milka-jananya. Ruthungku Naominda yalaman, “Nganya yunga paddockmunbu, mujanka mayi jana workingmanangka bawal.” Jana Israel-warra yalaku, jana workingmanangka mayi mujal-mujanya paddockmun, jana kanbal mayi daray-maninya, bawanya. Yinyamun jana bama money-karilu, jana kudamundu dunganya, mayi bubumun mujanya. Ruthungku mayi yalaku kudamundu mujal-mujanka bulanga, money yamba-kari. Yinyaynka Ruthungku biwulundu babajin, nyungun yunganka, mayi mujanka. Biwulungku yalaman, “Yala, dungayda.” Ruth nyubunyimba paddockmunbu dunganda, jananda workingmananda kudamundu dungan, mayi mujal-mujanya jana bawanya. Yinya paddock Boazamu, yamba Ruth nyungunku binal kari. ");
INSERT INTO gvn_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","13","Juma Boaz townmun kadan, balkawanka jananji workingmananji. Nyulu Ruth nyajin, jananda babajin, “Yinya jalbu wanya?” Jana yalaman, “Nyulu yinya ngarrbal Naominji kadan, bubumun Moabmun. Nyulu nganjinanda babajin, ‘Yalada ngayu kudamundu workingmananda mayi mujal?’ Nyulu yalibalaku kadan, yaykarrku workmanijin. Nyulu nyiku-nyikula wawu-balangajin wabarrba.” Boaz Ruthundu dungan, yalaman, “Nganya kuku-nyaka. Paddockmunbu yinduymbu kari dungay. Bunday yaluy. Jalbu-jalbunji workmaka, jananji bunday. Ngayu jananda workingmananda balkan yunun kari buyun-damanka. Kaki yundu wawu-wulay, bana nuka bottlemun jana wundin.” Ruth dukul badaman, Boazanda yalaman, “Yundu wanyurrinku ngaykunku ngulkurrmal? Wanyurrinku ngarrbalanka manun-manunmal?” Boazangka yalaman, “Ngayu yununku kuku nyajin. Yunu dunyu wulan, yamba yundu biwul ngulkurrduku kujin, ngamu, nganjan, bubu bawanyarrku, yalaymba kadan, biwulundumunbu jawun-karranda. Ngayu wawu nyajinka Majangka Godungku yunun wawurr-wawurr-bunganka, yundu biwul ngulkurrduku kujinya. God Israel-warramu, yamba yundu nyungundu kadan, nyulu yunun ngulkurrduku kujinka.” Ruthungku yalaman, “Yundu ngaykunku manun-manun bajaku, nganya wawu-ngulkurr-bungal.” ");
INSERT INTO gvn_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","16","Mayi readymanda, Boazangka Ruthundu yalaman, “Kaday, nganjinanji mayi nuka.” Ruth bundaynda jananji, Boazangka mayi dajin. Ruthungku mayi nukan, yinyamun nyulu yanjimanda, kanbal yanday nyulu wundin. Nyulu dungaynda, mayi mujanka baja. Boazangka workingmananda yalaman, “Balu nyulu muja bundlemun yurra bawan. Kari nyungun kiri. Mayi bundlemun kulba, bubungu bawa, balu nyulu kaday, mujanka.” ");
INSERT INTO gvn_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","20","Nyulu Ruthungku mayi mujan, mujan, yilay-yilayman. Nyulu mayi dudan, mayi ngami-ngami-banka jikanmun, diburrku kujinka. Nyulu mayi wundinda, biwulundu milbinka, nyulu mayi jirray bangkan. Nyulu mayi yanday yalarrku wundin, biwulundu dajin. Naomi nyungundu babajin, “Yundu walay, mayi wanjamun bangkan? Yundu wanyamba paddockmunbu workmalman? Ngayu wawu nyajinka Majangka Godungku nyungun ngulkurrduku kujinka, yala nyulu yunun kujin.” Ruthungku Naominda balkan, “Ngayu paddockmunbu workmalman, paddock wanyanga Boazanga.” Naomingka yalaman baja, “Ngayu wawu nyajinka Majangka Godungku Boaz ngulkurrduku kujinka. Godungku manubajaku junjuy-junjuy balkal, nyulu jurril kari balkal bamanda.” Nyulu yalaman baja, “Yinya dingkar ngaykuwunbu dunyungu mukay. Nyulu ngaliyan manubajabuku kujil.” ");
INSERT INTO gvn_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","17","Yinyamun Boazangka Ruth manyarr-banda, bayanbaku wundin. God Ruthunku ngulkurr bajaku, nyungun ngulkurrduku kujin. Nyulu Ruth kulngkulmanda. Nyulu kangkal dingkar manin, burri dalkinda Obed. Obed nganjanman Jessemu. Jesse nganjanman Davidamukuda. ");
INSERT INTO gvn_vpl VALUES ("S11_1","010_1_1","1SA","1","1","10a","Eli, nyulu priest. Nyulu Godundumunbu tentmunbu bundan, townbu Shiloh. Nyubun jalbu burri Hannah Godundumunbu tentmunbu kadan, nyulu Godundu praymalman. Nyulu Hannah kangkal kari. Nyulu banbadin, praymalman Godundu, kangkal dajinka nyungu. ");
INSERT INTO gvn_vpl VALUES ("S11_10b","010_1_10b","1SA","1","10b","18","Eli doorngu bundandan, nyungun nyajin. Hannahngka Godundu balkan, “Maja God, ngayu yunun wukurrinka. Nganya nyaka, kari milka-wulay. Kaki yundu ngaykundu ngawa dingkar dajil, ngayu nyungun yununduku dajil baja, yunundu workmanka.” Nyulu Godundu yayngkarabu balkan, yimbibuku. Yinyaynka Elingka milkabu baykan, balu Hannahngka kamu-kamu nukan. Elingka nyungundu yalaman, “Wanyurrinku yundu kamu-kamu nukan? Kari nuka baja.” Hannahngka yalaman, “Kari, ngayu kamu-kamumun kari. Ngayu Godundu ngadingka prayman, ngayu milka-bujarmanya.” Elingka yalaman, “Yalada, dungayda. Ngayu wawu Godungku yunundu dajilda.” Hannahngka yalaman, “Ngayu dungayda. Yundu manun-manunmaka ngaykunku.” Yinyamun nyulu bayanbaku dungan baja, mayi nukan, kari milka-bujarman baja. ");
INSERT INTO gvn_vpl VALUES ("S11_20","010_1_20","1SA","1","20","28","Yinyamun Hannah kulngkulman, kangkal dingkar manin. Nyulu burri dalkin Samuel, Godungku nyungun dajinya. Jananga kuku Samuel mean “Godundu babajin.” Karrkayangka bibi bawan, Hannahngka nyungun Godundumunbu bayanba wundin, townbu Shiloh. Jana karrkay priestanda Elinda wundin. Hannahangka Elinda babajin, “Yundu ngaykunku binalku? Yundu nganya ngadiku nyajin praymalmanya yaluy. Ngayu Godundu babajin yanyuynku kangkalanka, nyulu dajinda. Ngayuda Godundu dajinka. Nyulu Samuel wuljaljiku Godumukuda.” Yinyamun jana wubulduku God buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("S12_12","010_2_12","1SA","2","12","17","Elimu kangkal-bulal jambul, burri Hophni, Phinehas. Bula yalarrku priestman Godundumunbu bayanba townbu Shiloh. Yamba bula buyunman Godundumunbu miyilba, bula jumbunmanya minyaka bamangka Godundu dajinka. Bamangka minya wundin, Godundu dajinka, bula kanbal jumbunduku manin, bulangaku. ");
INSERT INTO gvn_vpl VALUES ("S12_22","010_2_22","1SA","2","22","25","Nyulu Elingka kuku nyajin nyunguwunku kangkal-bulalanka, nyulu bulanda yalaman, “Yubal wanyurrinku yalaku balkal? Bamangka ngaykundu balkal yubal buyun-daman-damal. Kari yalaku buyun-dama baja. Godumu bama yubalanka balkan-balkaway. Kaki bamangka yindu bama buyun-damal, Godungku nyungun helpim-bungal. Kaki yubal God buyun-damal, wanjungku baja yubalin helpim-bungal? Yubal kari buyunmaka baja.” Yamba bula nganjananda kari milka-janan. Yinyaynka Godungku bulanin juma yarkin-bunganka. ");
INSERT INTO gvn_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Nyulu Samuel jirraymalman, jana bama and God wawurr-wawurrmanda nyungunku. ");
INSERT INTO gvn_vpl VALUES ("S13_2","010_3_2","1SA","3","2","9","Yala-yala nyulu Eli miyil-burra, nyulu wujurrbu nyunguwunbu roommunbu warngku wunanan. Nyulu Samuel warngku wunanan yuba roommunbu Godumu box bundandan. Mudu-wayjunjiku, Majangka Godungku Samuel kunjan. Samuelangka kuku nyajin, nyulu yalaman, “Yuwu, ngayu kukuuu.” Nyulu jinbalku Elinda warrin, babajin, “Yundu nganya kunjan?” Yamba Elingka yalaman, “Kari, ngayu yunun kari kunjan, bedbaku dungay baja.” Samuel bedbaku dungan baja. Majangka Godungku nyungun kunjan baja. Samuel binal kari Godungkuku nyungundu balkal-balkal, Godungku jakalbaku kariku balkanya nyungundu. Nyulu Elinda dungan baja, yalaman, “Yundu nganya kunjan, ngayu wanjarrmal?” Elingka yalaman, “Kari, ngayu yunun kari kunjan, bedbaku dungay baja.” Yinyamun Godungku Samuel kunjan baja, nyulu Elinda dungan baja, babajin wanyurrinku. Eli binalmanda, Godungkuku Samuel kunjal-kunjan. Nyulu Samuelanda yalaman, “Yundu bedbaku dungay baja. Kaki Godungku yunun kunjal baja, yundu balka, ‘Yundu kuku balka, Maja, ngayu milka-janay.’” Samuel bedbaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("S13_10","010_3_10","1SA","3","10","14","Yinyamun Maja God kadan baja, yalaman, “Samuel, Samuel!” Samuelangka yalaman, “Kuku balka, ngayu milka-janjanay.” Majangka Godungku nyungundu yalaman, “Juma ngayu Israel-warra jirray bajaku buyun-damal. Bamangka nyajil, jana kungkurr-kaday. Ngayu Elimu jawun-karra family punishim-bal, nyunguwundu kangkal-bulalangka kuku buyun balkanya ngaykunku. Eli binal bulanka, yamba nyulu bulanin kari nyandin. Yinyaynka ngayu bulandamunku buyun-buyunku kari milka-wulay baja.” ");
INSERT INTO gvn_vpl VALUES ("S13_15","010_3_15","1SA","3","15","18","Samuel bedba bundandan. Yalibalaku nyulu wandin, doors walngan Godundumunbu bayanba. Yamba nyulu wawu kari yinya kuku Godundumun balkanka Elinda. Yamba Elingka nyungun kunjan, babajin, “Godungku wanyu kuku balkan yunundu? Kuku ngaykundumun kari kuji. Godungku yunun yaykarrdaku punishim-bal, if yundu kari balkal.” Yinyaynka Samuelangka Godumu kuku wubulku balkan Elinda. Elingka yalaman, “Yalada, nyulu Majakuda. Nyulu yalamanka, nyulu yalamal.” ");
INSERT INTO gvn_vpl VALUES ("S14_1","010_4_1","1SA","4","1","4","Yala-yala jana Philistine-warra murumarin, Israel-warranji kuniwanka. Israel-warra murumarin bubungu Ebenezer yala jana Philistine-warra murumarin bubungu Aphek. Jana kuniwan, Philistine-warrangka Israel-warra kangan, 4000-bala yarkinkaku kunin. Jana kanbal Israel-warra bayanbaku kadan baja, jana babajin, “Wanyurrinku Godungku jananin mambarrin ngananin kanganka? Ngana townbu Shiloh dungayda, Godumu box maninka. Ngana yinya box wundil, nguba Godungku ngananin junkurrji-bungal Philistine-warranka.” Godumu box wunan Godundumunbu tentmunbu. God bundan nyunguwunbu tentmunbu. Jana Israel-warra binal God junkurrji bajaku, dayirr bajaku. Yinyaynka jana jana-karrajiku balkawan, “Kaki ngana Godumu box wundil, nyulu nganangan junkurrji-bungal, Philistine-warra kanganka.” Yala-yala jana kukuji yungan, Godumu box manin. Elimu kangkal-bulal jambul priests, bula boxmunji kadan. Jana Israel-warrangka Godumu box jananji wundin, Philistine-warranji kuniwanka baja. ");
INSERT INTO gvn_vpl VALUES ("S14_10","010_4_10","1SA","4","10","18","Jana kuniwan, yamba Philistine-warra jarra junkurrji Israel-warranka, jananin kanbal kangan, kanbal yarkin-ban. Nyubun bama yinyamun bubumun warrin townbu Shiloh. Nyulu Eli baralba karangkalba bundandan, nyulu wawu-dudan-dudajin Godundumunku boxmunku. Nyulu bama yiringkurrku towndurr warrin, bamanda balkal-balkan Philistine-warranka. Nyulu Elingka nyurra nyajin, yamba nyulu wulman, miyil-burra. Nyulu babajin, “Wanyurrinku nyurra?” Nyulu bama Elinda kadan, yalaman, “Ngayu bubumun warmun yaluy warrin.” Elingka babajin, “Bama wanjarrman yinyaymba?” Bamangka yalaman, “Ngana Israel-warra wubulku warririn Philistine-warrandamun. Jana ngananin kunin, kangan, yunu kangkal-bulal jambul yarkin-ban, yalarrku jana Godumu box ngakin.” Elingka kuku nyajin Godundumunku boxmunku, nyulu chairmun muku-mukuku daran. Nyulu wulman bajaku, wandul bajaku. Nyulu daran, nyulu jakay bajibay dumbarrijin, wulankuda. Nyulu maja bubungu Israel 40 years. ");
INSERT INTO gvn_vpl VALUES ("S15_1","010_5_1","1SA","5","1","4","Jana Philistine-warrangka Godumu box yinyamun wundin janawunbu townbu Ashdod. Jananga god burri Dagon, nyulu God bajaku kari, walu-yindu. Nyungu ngurma statue bayanba bundandan. Jana Godumu box bayanba yijarrin ngurmanji. Warngku nyubunman yalibalaku jana bayanba walan, jana ngurma statue nyajin bubungu wunananya jakalba Godundumunbu boxmunbu. Yinyamun jana nyungun statue jarra-kulban, yijarrin baja. Warngku nyubunman baja yalibalaku, jana bayanba walan baja, ngurma statue nyajin bubungu wunananya jakalba Godundumunbu boxmunbu. Nyulu ngurma dukul, mara jambulku kankurku wunanan doorngu. ");
INSERT INTO gvn_vpl VALUES ("S16_6","010_6_6","1SA","6","6","12","Jana Philistine-warrangka Godumu box kari maninyaku, jana bawanyaku bubungu Israel. Yinyaynka Godungku jananin yaykarrdaku punishim-ban. Nyulu jananin bambay-bunganya, jana yinyilmarin. Jana yalaman, “Israel-warrandamundu Godungku ngananin and ngananga god Dagon punishim-bungalda. Ngana Godumu box yalaymun yunga baja.” Yinyaynka jana Godumu box bubungu Israel yungan baja. ");
INSERT INTO gvn_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Jana Israel-warrangka Godumu box townbu karrkaymba yijarrin, yinyaymba bawan, 20 years. ");
INSERT INTO gvn_vpl VALUES ("S17_3","010_7_3","1SA","7","3","6","Jana yindu-yindu god wubul wukurrin. Yamba jana God bajaku yalarrku wukurrinka. Samuelangka jananda yalaman, “Yurra kari bajaku God jiringa and same time god yindu-yindu wukurrika. Yurra nyubunku, God bajaku wukurrika.” Yinyamun jana ngurma idols and yindu god-god kunbay-maninyarrku. Jana townbu Mizpah murumarin, God bajaku buyay-maninka. Jana yalaman, “Ngana buyunman, God kari manubajabuku wukurrinya.” Samuel jananka prayman. ");
INSERT INTO gvn_vpl VALUES ("S17_7","010_7_7","1SA","7","7","11","Jana Philistine-warrangka kuku nyajin Israel-warra murumarinya townbu Mizpah. Yinyaynka jana kadarin, Israel-warranji kuniwanka baja. Jana Israel-warra yinyilmarin, Samuelanda yalaman praymanka. Samuelangka minya sheep karrkay kunin, wayjun kuljinga, Godundu dajin. Yinyamun nyulu Godundu babajin Israel-warra junkurrji-bunganka Philistine-warranka. Jana Philistine-warra kankadan, Godungku jarramali and balbay jirimun yungan jananda. Jana ngangkan-ngangkarin, warririnkuda. Israel-warrangka jananin kangan, kunin. ");
INSERT INTO gvn_vpl VALUES ("S17_12","010_7_12","1SA","7","12","17","Yinyamun Samuelangka kulji jirray jajirrin dindarranga townbu Mizpah, townbu Shen, yalaman, “Ngana yinya kulji nyajil, ngana kari milka-wulay Godungku ngananin helpim-bungan, Philistine-warra kanganka.” Yinyamun Samuel nyunguwunbuku bayanbaku dungan baja townbu Ramah, majaman Israel-warranka. ");
INSERT INTO gvn_vpl VALUES ("S18_1","010_8_1","1SA","8","1","7","Nyulu Samuel wulmanman, nyulu nyungu kangkal-kangkal maja-bungan Israel-warranka. Yamba jana kari ngulkurr, yala kari jananga nganjan. Jana nganjan kari wukurrin. Jana jumbun moneyka, maja buyunman Israel-warranka. Yinyaynka kanbal Israel-warra Samuelanda kadan, yalaman, “Yundu wulmanmalmalda, yamba yunuwundu kangkal-kangkalangka yunun kari wukurril. Nganjin bama nyubun king-bunganka, nganjinanka majamanka yala bama kanbal bubungu yindu-yinduymbu.” Samuelangka wawu kari bama king-bunganka. Yinyaynka nyulu Godundu prayman. Godungku yalaman, “Yundu jananda milka-janay. Jana yunun kari bayjan, jana nganyaku bayjan. Ngayuku jananga king, yamba jana ngaykunku wawu kari.” ");
INSERT INTO gvn_vpl VALUES ("S19_1","010_9_1","1SA","9","1","3","Nyubun bama burri Kish, nyulu rich-bala. Nyungu kangkal burri Saul, nyulu kalbali, ngulkurrijin. Kishamu donkeys ngakijin, nyulu Kishangka kangkalanda Saulundu yalaman, “Yundu workingman mana, yubal dungay, donkeynka nubijinka.” ");
INSERT INTO gvn_vpl VALUES ("S19_4","010_9_4","1SA","9","4","17","Bula yiringkurrku dungan-dungan, yamba donkeys kari warrmba-bungan. Bula yubaku townbu Samuelanda kankadan, God Samuelanda kadan, yalaman, “Ngayu bama nyubun yunundu yungal, nyulu Benjamin-warrandamun. Yundu nyungun olive-oildu dukul-dama, milbinka nyulu kingmanka Israel-warranka.” Warngku yindu bula Saul yubaku townbu kadan. Nyulu workingmananda yalaman, “Ngali bayanbaku dungay baja, nguba ngayku nganjan milka-bujarmal ngalinka.” Yamba nyulu workingmanangka yalaman, “Kariku, nyubun prophet yalaymba townbu bundandayda. Ngali nyungundu dungay, babajinka wanjabu donkeys.” Bula townbu dunganda, Samuel nyajin kankadanya. Nyulu churchmunbu dungay-dungan, God buyay-maninka. Nyulu Samuelangka Saul nyajin, Godungku nyungundu yalaman, “Yinya bama ngayu yunundu balkan. Nyulu majamal, kingmal ngaykuwunku bamanka.” ");
INSERT INTO gvn_vpl VALUES ("S19_18","010_9_18","1SA","9","18","20","Yinyamun Saul Samuelanda dungan, babajin, “Nyulu prophet wanjabu bundanday?” Samuelangka yalaman, “Ngayu prophet. Yubal churchmunbu dungay, ngaykunji mayinga nukajikada. Wunkun yalibalaku ngayu yubalin yungal baja bayanbaku. Jana yunu donkeys warrmba-bungan. Jana Israel-warra yununku, yunuwunku jawun-karranka wawu jirray.” ");
INSERT INTO gvn_vpl VALUES ("S19_26","010_9_26","1SA","9","26","27","Yalibalaku Samuelangka Saul warngkumun walngan, yalaman, “Wandida, ngayu yubalan bayanbaku yungankada.” Jana ngalkalba townmun kadan, Samuelangka yalaman Saulundu, “Yunu workingman jakalba yunga, yundu buban ngaykunji bunday. Ngayu yunundu balkal wanyu Godungku yalaman.” ");
INSERT INTO gvn_vpl VALUES ("S110_1","010_10_1","1SA","10","1","9","Yinyamun Samuelangka olive-oil manin, Saulundumunbu dukulbu nyangarrin, nyungun kissim-ban. Jana Israel-warra yalaku, jana dingkar oildu dukul-damal, yinyamun kissim-bungal. Samuelangka yalaman, “Majangka Godungku yunun juma maja-bungal bamanka Israel-warranka. Yundu jananka majamal, jananin ngulkurrduku kujil bamanka kuli-bakanka.” Yinyamun Godungku Saulumu wawu walu-yindu-bungan, ngulkurr-bungan. ");
INSERT INTO gvn_vpl VALUES ("S110_17","010_10_17","1SA","10","17","24","Samuelangka kuku yungan Israel-warranda wubuliymbaku, yalaman, “Ngana wubulku murumarinka townbu Mizpah, king wangkanyinka.” Jana murumarin, Godungku jananda balkan Saul king-bunganka. Yamba jana Saul murruji warrmba-bungan. Yinyamun jana Godundu babajin baja, nyulu yalaman, “Nyulu Saul ngakin-ngakiji kudamundu yamba-yambanga.” Jana nyungun manin, jakalba jajirrin bamanda. Nyulu kalbali bajaku. Samuelangka yalaman, “Yanyu bama yurranga king Godungku wangkanyin. Nyulu ngulkurrkuda.” Bamangka wubulduku yalaman, “Yalada, ngananga king ngadingka juranku bunday.” ");
INSERT INTO gvn_vpl VALUES ("S111_1","010_11_1","1SA","11","1","2","Juma jana Ammon-warrangka soldier-soldier yungan, Israel-warranji kuniwanka bubungu Gilead. Jana Israel-warrangka Ammon-warranda yalaman, “Ngana jawun-jawunmanka.” Yamba Ammon-warrangka yalaman, “Kaki nganjin yurranin wubulku nyubun miyil-burra-bungal, ngana jawun-jawunmal.” ");
INSERT INTO gvn_vpl VALUES ("S111_3","010_11_3","1SA","11","3","7","Yinyamun jana Israel-warrangka kuku yungan kanbalanda Israel-warranda helpmunku. Jana kukuji Saulundu kadan, Godundumundu wawubu Saulumu wawu junkurrji-bungan. Nyulu yinya kuku nyajin Ammon-warranka, nyulu kuli-kadan. Nyulu bulki jambul yarkinkaku kunin, yakan, kankur-kankur-bungan, minya buban-buban yungan Israel-warranda yiringkurrku. Nyulu Israel-warra milka-bakan, yalaman, “Kaki yurra ngalinin Samuel kari wukurril, jananji Ammon-warranji kuniwanka, ngayu yurranga bulki wubulku kankur-kankur-bungal yala yanyu minya.” Israel-warra wubulku yinyilmarin, balu Godungku jananin buyun-damal. Yinyaynka jana wubulku murumarin, Ammon-warranji kuniwanka. ");
INSERT INTO gvn_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Warngku nyubunman yalibalaku Saulungku jananin soldier-soldier ngami-ngami-bungan, jana sidesmun kulurmun Ammon-warranda warrin, walan, jananji kuniwanka. Wungar jarra-jarraman, Israel-warrangka Ammon-warra yaykarrdaku kunin, jananin kanganda. ");
INSERT INTO gvn_vpl VALUES ("S115_1","010_15_1","1SA","15","1","3","Samuelangka Saulundu yalaman, “Godungku ngadiku nganya yungan yunun king-bunganka Israel-warranka. Yundu nyungundu milka-janay. Nyulu Amalek-warra punishim-bunganka, jana ngadiku Israel-warra buyun-damanya, Israel-warra bubumun Egyptmun kankadanya. Dungay, jananin Amalek-warra yarkin-bunga. Jananin dingkar-dingkar, jalbu-jalbu, kaykay-kaykay, minya bulki, sheep, camel, donkey wubulku yarkinkaku kunikuda.” ");
INSERT INTO gvn_vpl VALUES ("S115_4","010_15_4","1SA","15","4","9","Saulungku soldier-soldier wubulku muru-bungan, jananji Amalek-warranji kuniwanka. Jana Saulungku Amalek-warra wubulku yarkinkaku kuninkuda. Yamba Saulungku Godumu kuku kari mumbarabuku wukurrin. Nyulu Amalek-warramu king kari yarkinkaku kunin. Nyulu yalarrku bulki and sheep ngulkurr kari yarkinkaku kunin. Godungku balkan wubulku yarkinkaku kuninka, yamba Saulungku kari kuku-nyajin. ");
INSERT INTO gvn_vpl VALUES ("S115_10","010_15_10","1SA","15","10","11","Godungku Samuelanda yalaman, “Ngayu milka-bujar ngayu Saul king-bunganya. Nyulu ngaykundumun jurrkijin, nganya kuku kari wukurril baja.” Samuel wujurr-kalbay prayman Godundu. ");
INSERT INTO gvn_vpl VALUES ("S115_12","010_15_12","1SA","15","12","23","Yinyamun nyulu Saulundu dungan bubungu warmunbu. Saulungku Samuel nyajin, nyulu yalaman, “Ngayu wawu God ngulkurrmanka yununku. Ngayu nyungu kuku wukurrinkuda.” Samuelangka yalaman, “Kaki yundu kuku wukurrin, wanyurrinku ngayu bulki and sheep nyajil yirrkan-yirrkanya? Godungku kuku dajin yundu bulki and sheep wubulku yarkinkaku kuninka. Yundu nyungu kuku kari wukurrin.” Saul jurrilman soldier-soldieranka. Nyulu yalaman, “Ngaykuwundu soldier-soldierangka jananin minya ngulkurr-ngulkurr manin Amalek-warrandamun, jana kuninka, Godundu dajinka. Kanbal nganjin wubulku kuninyarrkukuda.” Samuelangka yalaman, “Ngulkurr minya wayjunku, Godundu dajinka, yamba ngulkurr bajaku Godumu kuku wubulku wukurrinkarrku. Bama Godundumun jurrkiji, nyulu Dubumu way wukurril, ngurma idol buyay-manil. Yundu Godundumun jurrkijinya, nyungun bayjanya, nyulu yunun bawan. Yundu juma kari kingmal baja. Godungku yindu king-bungal.” ");
INSERT INTO gvn_vpl VALUES ("S116_1","010_16_1","1SA","16","1","3","Godungku Samuelanda yalaman, “Yundu kari jiba-badi Saulunku. Ngayu nyungun bawan, nyulu juma kunbay kingmanka. Ngayu wawu yunun yungalda, townbu Bethlehem bamanda burri Jesse. Ngayu kangkal nyungu nyubunku wangkanyin, king-bunganka. Yundu olive-oil wundi, yinya warru oildu dukul-dama, king-bunganka.” Samuelangka Godundu yalaman, “Kari. Kaki ngayu nyungun dukul-damal king-bunganka, Saulungku nganya yarkin-bungal.” Godungku yalaman, “Bulki karrkay wundi, bamanda balka yundu kuninka, wayjunku, ngaykundu dajinka. Yamba yundu Jesse kunja, yununji nukajinka. Yinyamun ngayu yunundu balkal wanjarrmanka. Ngayu bama nyubun wangkanyil, yundu oildu dukul-damanka, king-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("S116_4","010_16_4","1SA","16","4","5","Yinyamun Samuelangka Godumu kuku wukurrin. Nyulu townbu Bethlehem dungan, jana maja-maja townku babajin, “Yundu kari kuli-kadan?” Samuelangka yalaman, “Kari, ngayu minya wayjunku, Godundu dajinka. Yurra yurraku ngulkurr-bungajika Godundumunbu miyilba yala nyuluku kukubuku balkan. Yinyamun ngaykundu kaday.” Samuelangka yinya kuku yalarrku Jessenda and nyunguwunbu kangkal-kangkalanda balkan. ");
INSERT INTO gvn_vpl VALUES ("S116_6","010_16_6","1SA","16","6","7","Jana Samuelanda kadan, nyulu Jessemu kangkal burri Eliab nyajin, nyuluku yalaman, “Yanyu nguba Godumu bama kingmanka.” Yamba Godungku Samuelanda yalaman, “Yinya bama kalbali, ngulkurrijin, bangkarr ngulkurr. Yamba yundu nyungun bayja. Ngayu nyungun kari wangkanyin. Ngayu Maja God. Ngayu kari milkabu wukurril yala bamangka. Ngayu kananga wawungu nyajil, yamba yurra bamangka ngalkalba bangkarrku nyajil, wangkanyinka.” ");
INSERT INTO gvn_vpl VALUES ("S116_8","010_16_8","1SA","16","8","12a","Jessengka nyungu kangkal-kangkal dingkar-dingkar 7-bala Samuelanda wundin. Yamba Samuelangka yalaman, “Kari, Godungku jananin kari wangkanyin, king-bunganka.” Nyulu Jessenda babajin baja, “Yanyu yalakubada yunu kangkal-kangkal?” Jessengka yalaman, “Kari, nyubunku kudamundumun. Yamba nyulu yaluy kari. Nyulu bubungu jirrbu-jirrbungu minya sheep kujil-kujilda.” Samuelangka yalaman, “Nyungun kunja. Ngana nyungunku waitmal, balu nyulu kaday, ngana minyada wayjul, Godundu dajinka.” Jessengka nyungunku yungan. ");
INSERT INTO gvn_vpl VALUES ("S116_12b","010_16_12b","1SA","16","12b","13","Nyulu kadan, Samuelangka nyajin nyulu warru ngulkurr, dandi. Godungku Samuelanda yalaman, “Yinyadabi! Nyungun oildu dukul-dama!” Samuelangka David olive-oildu dukul-daman nyunguwunbu yaba-karranda miyilbaku. Yinyamun Godumu wawu jinbalku Davidandamunbu wawungu walan, nyungunji bundan. Yinyamun Samuel bayanbaku dungan baja townbu Ramah. ");
INSERT INTO gvn_vpl VALUES ("S116_14","010_16_14","1SA","16","14","18","Godundumundu wawubu Saul bawan, dubu Godungku nyungundu yungan. Saul dubunjiku bundandan. Nyunguwundu workingmanangka nyungundu yalaman, “Nganjin binal Godungku dubu yunundu yungan. Yundu wawu nganjin bama nubinka, wulngku harp balkanka? Yinyamun nyulu dubu yunundu kaday, yinyangka bamangka nyungu wulngku harp balkal yunundu, yundu ngulkurrmanka baja.” Saulungku yalaman, “Yalada, bama mana.” Nyubunyinja workingmanangka yalaman, “Jessemu kangkal townbu Bethlehem, nyulu wulngkuku harpanka binal bajaku. Nyulu yalarrku burrkul-dandi soldier, yalarrku mala-kuku. God nyungunji bundanday.” ");
INSERT INTO gvn_vpl VALUES ("S116_19","010_16_19","1SA","16","19","23","Yinyamun Saulungku kuku yungan Jessenda, yalaman, “Yunu kangkal David, nyulu sheep kujil-kujil. Nyungun ngaykundu yunga.” Jessengka David Saulundu yungan. Nyulu mayi donkeynda mukungu karrabu kajan, nanny goat manin, Davidanji yungan. David Saulundumunbu bayanba kadan, nyungundu workmanijinda. Saul Davidanka wawu jirray, nyungun wangkanyin, nyungu kalka jarra-kulbanka. Yinyamun Saulungku kuku yungan Jessenda, yalaman, “Ngayu Davidanka wawu jirray. Balu nyulu ngaykunji bunday, ngaykundu workmanka.” Wawu yinyamun kaki dubu Saulundu kadan, Davidangka nyungu wulngku harp balkan. Yinyamun dubu dungan baja, Saul bangkarr ngulkurrman baja. ");
INSERT INTO gvn_vpl VALUES ("S117_1","010_17_1","1SA","17","1","11","Jana Philistine-warra soldier-soldier murumarin wuburrbu, Israel-warranji kuniwanka. Saul, nyungu Israel-warra soldier-soldier, jana yalarrku murumarin wuburrbu yinduymbu. Nyubun bama Philistinemunku burri Goliath, nyulu yalbay bajaku, kalbali bajaku, giant. Nyulu kalbali, 3 metres. Nyungu kambi iron, kalka kanbinka, kambi kulngkul bajaku, 57 kilos. Nyungu kalka yalbay bajaku, dukul kulngkul, 7 kilos. Yindu soldier jakalba nyungundu dungan, nyungu kunjuri shield jarra-kulbal-kulban. Nyulu Goliath jakalba kanbalba Philistine-warranda janjanan, Israel-warranda yirrkan, “Yurra wanyurrinku yinyay wuburrbu murumarin, nganjinanji kuniwanka? Ngayu Philistinemunku, yurra Saulumu slave-warra. Nyubun bama yurrandamun wangkanyika, ngaykunji kuniwanka. Kaki nyulu nganya yarkinkaku kunil, nganjin yurranga slave-warramal. Kaki ngayu nyungun yarkinkaku kunil, yurraji nganjinanga slave-warramal. Nyubun wangkanyika, ngaykunji kuniwanka.” Nyulu Saulungku, nyunguwundu soldier-soldierangka yinya nyajin, jana yinyilmarin bajaku. ");
INSERT INTO gvn_vpl VALUES ("S117_12","010_17_12","1SA","17","12","15","David kangkal Jessemu. Nyulu townmun Bethlehemmun, bubumun Judahmun. Saul kingman, nyulu Jesse wulman bajaku. Nyungu kangkal-kangkal dingkar-dingkar 8-bala. Kangkal-kangkal kulur jakalbamun, jana soldierman Saulundumunbu armynga. David, nyulu kudamundumun. Nyungu yaba-karra kulur Saulunji bundanya. Nyulu David nganjanandamun jananda dunganya, buban bundanya, yinyamun jananin bawanya, bayanbaku dunganya baja, nganjanamu minya sheep kujil-kujinya, yinyamun yaba-karrandaku dunganya baja, yalaku, yalaku. ");
INSERT INTO gvn_vpl VALUES ("S117_16","010_17_16","1SA","17","16","20a","Yala-yala Goliathangka balkan Israel-warrangka bama nyubun wangkanyinka, nyungunji kuniwanka. Nyulu balkan baja, balkan baja 40 daysmunku. David nganjananji bundandan. Juma Jessengka Davidanda yalaman, “Yundu yanyu mayi flour, mayi bread mana, yunuwunbu yaba-karranda wundi. Yundu yalarrku yanyu mayi cheese wundi, majanda soldier-soldierankaku daya. Yundu nyaka, yunu yaba-karra nguba ngulkurr, nguba kari. Yundu jananin nyaka, kaday baja. Nyulu King Saul, Israel-warra, jana bubungu Elah Philistine-warranji kunin-kuniway.” David yalibalaku wandin, minya sheep workingmananji bawan, nganjanamu kuku wukurrin. ");
INSERT INTO gvn_vpl VALUES ("S117_20b","010_17_20b","1SA","17","20b","25","Nyulu David jananda Israel-warranda kadan, mayi bawan majanji, yaba-karranda warrin. Jana balkan-balkawan, nyulu Goliath jakalba kadan, yirrkan Israel-warranda nyubunku nyungunji kuniwanka. Israel-warrangka nyungun nyajin, jana yinyilmarin bajaku, warririn. Jana jana-karrajiku balkawan, “Nyungun nyaka, nyulu nyubun bama nganandamun kunjal-kunjal, kuniwanka. Kaki bamangka nyungun yarkinkaku kunil, King Saulungku nyungundu kulji jirray dajil, yalarrku nyungu kangkal maral dajil, manyarrmanka.” ");
INSERT INTO gvn_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Davidangka Goliath nyajin Israel-warra yajarrinya, nyulu soldier-soldieranda babajin, “Saulungku wanyu dajil, bamangka nyungun Goliath yarkinkaku kunil? Ngana nyungun kari mambarrinyaku ngananda yalaku balkanka. Ngana Godumu bama, nyulu Godunku binal kari.” ");
INSERT INTO gvn_vpl VALUES ("S117_31","010_17_31","1SA","17","31","37","Kanbalda soldier-soldierangka yinya kuku nyajin, jana Saulundu dungan, Davidamu kuku balkan. Saulungku David kunjan. Nyulu Saulundu yalaman, “Ngana kari yinyilmanyaku nyungunku. Ngayu dungay, nyungunji kuniway.” Yamba Saulungku yalaman, “Kari, yundu warruku. Nyulu binal bajaku kuniwanka. Nyulu ngadiku soldierman armynga.” Davidangka yalaman baja, “Ngayu minya sheep kujil-kujin bubungu jirrbu-jirrbungu. Kaki lion or bear kadanya minya karrbanka, ngayu nyungun manu karrbanya, yarkin-bunganya. Ngayu lion and bear kunin, ngayu yalarrku yanyu bama kunil. Nyulu Godumu soldier-soldier yajarrin-yajarril. Godungku nganya ngulkurrduku kujin lionandamun, bearandamun, nyulu nganya yalarrku kujil nyungundumun Philistine-warrandamun.” Saulungku yalamanda, “Yalada, dungayda, Godungku yunun ngulkurrduku kujil.” ");
INSERT INTO gvn_vpl VALUES ("S117_38","010_17_38","1SA","17","38","40","Saulungku nyungu kambi iron Davidanda dajin, didanka. Davidangka didan, naybu kalbay sword manin, yamba kulngkul bajaku. Davidangka Saulundu yalaman, “Kari, ngayu murruji kuniway yalanguynji. Ngayu binal kari.” Nyulu kambi iron walngan baja. Yinyamun nyulu nyungu juku manin, kulji 5-bala wangkanyin yilkimun, kurmunbu yijarrin. Nyulu shanghai ready-bungan, Goliathanda dungan. ");
INSERT INTO gvn_vpl VALUES ("S117_41","010_17_41","1SA","17","41","47","Goliathangka David nyajin kankadanya, nyulu Davidanda kuli-muruku maku-warrin. Nyulu Goliath yuba kadan, nyajin David warruku. Nyulu Davidanda yalaman, “Ya, wanyurrinku yundu jukuji kankaday, ngayu kaya kari.” Nyulu Goliathangka David yukin, Davidanda yalamanda, “Kaday, ngayu yunun yarkin dikalanda and minyanda kulijinda dajil, nukanka.” Davidangka nyungundu yalaman, “Yundu ngaykundu kankaday naybuji, kalkaji, yamba ngayu yunundu kankaday junkurrji Godundumunji. Nyulu God junkurrji Israel-warranji dungay, yurranji kuniwanka. Nyiku Godungku nganya junkurrji-bungal, yunun yarkinkaku kuninka. Ngayu yunu dukul yakal. Ngayu yunu soldier-soldier yarkin-yarkin dikalanda, minyanda kulijinda dajil, nukanka. Yinyamun bama yiringkurrku binalmalda, God nganjinanji Israel-warranji. Jana binalmalda nganjinandamundu Godungku kalka and naybu kari useim-bungal, nyungu bama ngulkurrduku kujinka. Nyulu nganjinin junkurrji-bungal, yurranin kuninka.” ");
INSERT INTO gvn_vpl VALUES ("S117_48","010_17_48","1SA","17","48","51a","Goliathangka yinya kuku nyajin, nyulu kadan baja Davidanda. David jinbalku warrin nyungundu. Nyulu kulji kurmunmun manin, shanghaimba yijarrin, yilbankuda. Kulji junkayku dungan, Goliath munju kunin, dukul bajibay dumbarrinkuda. Goliath bubungu daran. David jinbalku nyungundu warrinda, naybu nyungundumun manin, dukul yakan, kankuruku, yarkin-bungan. ");
INSERT INTO gvn_vpl VALUES ("S117_51b","010_17_51b","1SA","17","51b","52","Jana Philistine-warrangka nyajin jananga bama junkurrji wulanya, jana warririnkuda. Jana Israel-warrangka kawal yirrkan, jananin kangan. Israel-warrangka Philistine-warra janawunbuku bubunguku kangankuda. ");
INSERT INTO gvn_vpl VALUES ("S118_1","010_18_1","1SA","18","1","4","Saulumu kangkal dingkar nyubun burri Jonathan. Nyulu Davidanka wawu jirray. Davidangka Goliath yarkinkaku kunin, yinyamun Saulungku David nyunguwunbu bayanba kujin, David kari nganjananji bundan baja. Jonathan Davidanka wawumanya, nyulu nyungu kambi, nyungu kunjuri shield, naybu, wayarri Davidamu dajin. ");
INSERT INTO gvn_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Saulungku David soldier-bungan, nyungun yungan, bamanji kuli-bakanji kuniwanka. David binalman kuniwanka, bama kuli-baka kuninyarrkuda. Yinyaynka Saulungku nyungun maja-bungan kanbalanka soldier-soldieranka. Jana soldier-soldier wawurr-wawurrman, David jananka majamanya. ");
INSERT INTO gvn_vpl VALUES ("S118_6","010_18_6","1SA","18","6","9","Davidangka Goliath yarkinkaku kunin, yinyamun jana David, Saul, soldier-soldier wubulku bayanbaku dungarin baja. Jalbu-jalbungku yiringkurrku jananin maku-nyajin, singman, wulngku balkan, dancemanijin. Jana jalbu-jalbu singman, yalaman, “Saulungku bama kuli-baka wubul kunin, yamba Davidangka wubul bajaku kunin.” Saulungku yinya kuku nyajin, nyulu kuli-kadan, yalaman, “Juma jana David king-bunganka, nyulu nganya karrnga-dajinka.” Yinyaynka Saulungku ngura-nyajin David, nyungunku wawu-kariman. ");
INSERT INTO gvn_vpl VALUES ("S118_10","010_18_10","1SA","18","10","16","Warngku nyubunman dubu Godundumun Saulundu walan, nyulu Saul kiru-kariman. Davidangka wulngku harp balkal-balkan, Saulungku nyungun kalkabu damanka. Saulungku kalka jambul yilban Davidanda, yamba David jinbalku jurrkijin, Saulungku nyungun nyundan. Saul binal God Davidanji, yamba Godungku nyungun Saul bawan. Yinyaynka Saul yinyilman Davidanka. Saul yinyilmanya Davidanka, nyulu David nyungundumun yungan. Nyulu David maja-bungan soldier-soldieranka 1000-balanka, jananin bubungu yindu-yinduymbu yungan, bamanji kuli-bakanji kuniwanka. God Davidanji bundandanya, David junkurrjiman bamanka kuli-bakanka, jananin kangan. Saulungku yinya kuku nyajin, nyulu David ngura-nyajin baja. Yamba jana Israel-warra Davidanka wawu jirray, nyulu binalmanya kuniwanka, bama kuli-baka kanganka. Davidangka juma Saulumu kangkal marryim-ban. ");
INSERT INTO gvn_vpl VALUES ("S119_1","010_19_1","1SA","19","1","3","Saulungku nyunguwunbu kangkalanda Jonathananda yalaman, “Ngayu David yarkinkaku kuninka.” Nyulu yalarrku jananda maja-majanda soldier-soldierankaku balkan. Yamba Jonathan Davidanka wawu jirray. Nyulu Davidanda yalaman, “Ngaykuwundu nganjanangka yunun yarkinkaku kuninka. Yundu mumbarmaka wunkun, ngakijika. Ngayu nganjananda dungay, balkawanka yununku. Yinyamun ngayu kaday baja, yunundu balkal baja.” ");
INSERT INTO gvn_vpl VALUES ("S119_4","010_19_4","1SA","19","4","7","Jonathan Saulundu dungan, yalaman, “Yundu David kari buyun-dama. Nyulu yununku kari buyunman. Kari, nyulu yunun helpim-bungan, kari buyun-daman. Goliath junkurrji bajaku. Nyulu David yarkinkaku kuninyaku, yamba Godungku David junkurrji-bungan, Goliath yarkinkaku kuninka. Nyulu Goliath yarkinkaku kunin, yundu wawurr-wawurrman. Wanyurrinku yundu nyungun yarkinkaku kuninka?” Saulungku Jonathanamu kuku nyajin, nyulu murru-kadan, yalaman, “Yuwu, yunu kuku junkay. Ngayu David kari yarkinkaku kunilda.” Jonathanangka David kunjan, Saulundu wundin. David Saulundu workman baja yala ngadiku. ");
INSERT INTO gvn_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Jana Philistine-warra kadan baja, kuniwanka baja Israel-warranji. David, nyungu soldier-soldier jananji kuniwan, jananin kangan bubumun Israelmun. ");
INSERT INTO gvn_vpl VALUES ("S119_9","010_19_9","1SA","19","9","10","Juma Godungku dubu yungan baja Saulundu. Saul bayanba bundandan, kalkaji. Davidangka wulngku harp balkal-balkan Saulundu. Saulungku David kalkabu damanka baja. Nyulu kalka yilban, yamba nyulu David jurrkijin, Saulungku nyundan, kalka wallbu jaybin. David warrinkuda. ");
INSERT INTO gvn_vpl VALUES ("S119_11","010_19_11","1SA","19","11","12","Bubu wujurrman Saulungku soldier-soldier yungan, Davidamu bayan nyajinka, David wunkun yarkinkaku kuninka. Yamba Davidandamundu manyarrangka Davidanda yalaman, “Yundu dungayda, kari waitmaka. Jana wunkun yunun yarkinkaku kuninji.” Yinyamun nyulu David karrabu bada bubungu yungan windowburr. David warrinda, ngakijin. ");
INSERT INTO gvn_vpl VALUES ("S120_1","010_20_1","1SA","20","1","23","Yinyamun David townmun Ramahmun dungan, Jonathan nubinka. Nyulu Jonathananda yalaman, “Ngayu wanjarrman, yunuwundu nganjanangka nganya yarkinkaku kuninka?” Jonathanangka yalaman, “Kari, yinya kuku manubaja kari. Nyulu yunun kari yarkinkaku kuninka.” Yamba Davidangka yalaman, “Yunu nganjan binal yundu ngaykunku wawu jirray. Yinyaynka nyulu yunundu kari balkan nyulu nganya yarkinkaku kuninka. Ngana wunkun mayi jirray nukal holidaymunku kijaka jirakalka. Ngayu kinganji nukajinyaku, yamba ngayu kari dungay. Kaki yunuwundu nganjanangka nyajil ngayu mayinga kari kaday, yundu balka ngayu ngaykuwunbu nganjananda dungan. Kaki yunu nganjan kuli-kaday, ngali binal nyulu still nganya yarkinkaku kuninka.” Jonathanangka Davidanda yalaman, “Yala. Wunkun yindu paddockmunbu kaday, ngakijika kudamundu kuljinga. Ngayu bow and arrow wundil, warru ngaykunji kaday. Ngayu arrow yilbal, warrundu balkal maninka. Kaki ngayu warrundu balkal, ‘Ngundu, ngundu,’ yundu binalmalda yalada kadankada. Kaki ngayu warrundu yirrkay, ‘Dungay baja,’ yundu binalmalda Godungku yunun yungalda. Ngali ngadiku promiseim-bungawan jawun-karrajiku bundanka. Godungku ngaliyan junkurrji-bungal, yinya promise kari bawanka.” Yinyamun bula bawawan. ");
INSERT INTO gvn_vpl VALUES ("S120_24","010_20_24","1SA","20","24","34","Warngku yindu jana king mayinga jirraymba nukan-nukajin, Saulungku David kari yinyay nyajin. Nyulu Jonathananda babajin, “Wanyurrinku David kari mayinga jirraymba kadan?” Jonathanangka yalaman, “Nyulu ngaykundu babajin nganjananda dunganka, mayi jirray nganjananji nukanka. Ngayu nyungun yunganda.” Saul kuli-kadan Jonathananka, yalaman, “Ngayu binalda yundu nyungundu jurrkijin ngaykundumun, nyungunku kurrkal-warrin. Nyulu juranku bundanday, yundu kari kingmalkuda. Dungay, nyungun mana. Nyulu must wulay.” Jonathanangka babajin, “Nyulu wanyurrinku wulanyaku?” Saulungku kalka karrban, yilban Jonathananda, yamba nyungun nyundan. Jonathan kuli-kadan, nganjan bawanda. ");
INSERT INTO gvn_vpl VALUES ("S120_35","010_20_35","1SA","20","35","42","Jonathanangka bow and arrow manin, paddockmunbu warrunji dungan, arrow yilban. Nyulu warrundu yalaman, “Yundu arrow mana.” Warru dungan, yuba kuljinga kadan, David kudamundu ngakin-ngakijin. Jonathanangka warrundu yirrkan, “Dungay baja, ngayu arrow kala-kalbay yilban.” Davidangka yinya kuku nyajin, nyulu binalmanda Saulungku nyungun still yarkinkaku kuninka. Yinyaynka nyulu yinya bubu bawan, ngakijin Saulundumun. ");
INSERT INTO gvn_vpl VALUES ("S121_1","010_21_1","1SA","21","1","6","David Saulundumun warrin, nyulu townbu Nob kadan. Yinyaymba nyulu churchmunbu dungan, priestanda babajin mayika breadka. Priestangka yalaman, “Mayi bread yaluy, yamba yinya bread Godumukuda.” Yamba nyulu yinya bread Davidanda dajin. ");
INSERT INTO gvn_vpl VALUES ("S121_8","010_21_8","1SA","21","8","15","Davidangka priestanda babajin baja, “Yundu kalka or naybu wunay?” Priestangka yalaman, “Goliathamu naybu kalbay sword churchmunbu wunanay. Yundu wawubu, yundu wundi.” Davidangka yalaman, “Yuwu, yinya naybu sword ngulkurr, ngayu wundil.” Yinyamun David dungan baja, townbu Gath kadan. Yinyaymba nyulu kinganda dungan, burri Achish. Yamba kingangka nyungun kari yulmbarrin. ");
INSERT INTO gvn_vpl VALUES ("S122_1","010_22_1","1SA","22","1","2","Yinyamun David townmun Gathmun dungan, cavemunbu ngakijin. Nyunguwundu yaba-karrangka juma kuku nyajin nyulu cavemunbu bundandanya. Jana dungan, nyungunji bundan. Yindu-yindu dingkar-dingkar yalarrku Davidanji murumarin, 400-bala. Nyulu jananga majaman. ");
INSERT INTO gvn_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","(22.9-23.24) Juma Saulungku kuku nyajinya David and nyungu soldier-soldier cavemunbu bundandanya. Saulungku and nyunguwundu soldier-soldierangka David juru-wukurrinya, yarkinkaku kuninka. Yamba Davidangka kuku nyajinya jana kankadanya. Yinyaynka nyulu and nyungu soldier-soldier manjalba dunganya, ngakijinka. Yamba Saulungku kuku nyajinya baja, jananin David juru-wukurrinya baja, yalaku, yalaku. ");
INSERT INTO gvn_vpl VALUES ("S123_25","010_23_25","1SA","23","25","29","One time Saul, nyungu soldier-soldier yuba kadan jananda Davidanda. Jana Daid wanarrin Saulundumun, yamba Saulungku jananin balu karrban. Jana Saul yuba kankadan jananda Davidanda, nyubun bama kukuji Saulundu kadan, yalaman, “Kaday, kaday! Jinbal! Jana Philistine-warra kankadayda, ngananji kuniwanka!” Yinyaynka Saul jinbalku jurrkijin, jananin David kari wukurrin baja. Yinyamun jana David bubungu jirrbu-jirrbungu dungarin, burri Engedi, yinyay bundandarin. ");
INSERT INTO gvn_vpl VALUES ("S124_1","010_24_1","1SA","24","1","6","Nyulu Saul kunban Philistine-warranji kuniwanka, jana nyungun balkan David bubungu jirrbu-jirrbungu bundandan. Yinyamun Saulungku soldier-soldier wubul, 3000-bala manin, jananin David wukurrin, yarkinkaku kuninka. Nyulu Saul cavemunbu kadan, kananga walan. Yamba yinya cave yalbay, jana David yalarrku yinyaymba cavemunbu, ngakin-ngakijin kudamundu. Saulungku jananin David kari nyajin. Davidandamundu soldier-soldierangka Davidanda yalaman, “Yala, yanyu yunu chance, Saul yarkinkaku kuninka.” Yamba Davidangka jananda yalaman, “Kari. Godungku nyungun wangkanyin kingmanka. Ngana nyungun kari buyun-damal.” Yinyamun David kirayku kudamundu Saulundu karangajin, buban Saulundumun kambimun yakan naybubu. Nyulu Saulundu milbinka nyulu Saul wawu kari yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("S124_7","010_24_7","1SA","24","7","22","Yinyamun Saul cavemun wandin, Davidangka nyungun wukurrin, yirrkan, “Ya, Saul, ngayku king.” Saul jurrkijin, David nyajin. Davidangka yalamanda, “Ngayu wawu yundu binalmanka ngayu yunun kari buyun-damanka. Yundu nyaka, yanyu yunuwunmun kambimun. Ngayu naybubu yakan, yamba ngayu yunun kari yarkin-bungan. Yinyamundu yundu binalmal ngayu yunun kari buyun-damanka. Wanya buyun Godundumunbu miyilba, nguba yundu?” Saulungku yinya kuku nyajin, nyulu milka-bujarman, yalaman, “Yundu ngulkurr, ngayu buyun. Yundu ngulkurrman ngaykunku, yamba ngayu buyunman yununku. Godungku yunu chance dajin, nganya yarkinkaku kuninka, yamba yundu kari kunin.” Yinyamun Saulungku David bawan, bayanbaku dungan baja. Jana David bubungu jirrbu-jirrbungu dungarin baja. ");
INSERT INTO gvn_vpl VALUES ("S126_1","010_26_1","1SA","26","1","5","Saul kuli-kadan baja Davidanka, kuku jurrkin, yalaman, “Ngayu David yarkinkaku kuninka.” Bamangka nyungundu balkan David wanjabu bundandan. Yinyamun Saulungku soldier-soldier jirray, 3000-bala kunjan, David wukurrinka, yarkinkaku kuninka. David binalman Saul kankadanya. Nyulu soldier-soldier yungan, karangajinka, binalmanka wanjabu Saul balnji wunanan. Saulumu soldier-soldier murumarin, balnji wunanka, Saul dindarra wunan. ");
INSERT INTO gvn_vpl VALUES ("S126_6","010_26_6","1SA","26","6","12","Davidangka kuku nyajin Saulunku, nyulu nyubunyimba soldieranda babajin nyungunji dunganka. Wujurrman bula David kirayku Saulundumunbu campmunbu karangajin. Bula Saul warrmba-bungan warngku wunananya dindarra soldier-soldieranda. Nyulu wunanjiku, nyulu nyungu kalka bubungu janay-manin yuba nyunguwunbu dukulbu. Bula yuba kadan, nyulu soldierangka Davidanda yalaman, “Godungku yunu chance dajin, Saul yarkinkaku kuninka. Ngayu nyunguwundu kalkabu nyungun damalkuda.” Yamba Davidangka yalaman, “Kari. Godungku nyungun wangkanyin kingmanka. Ngali nyungun kari yarkinkaku kuni. God readymal, nyuluku Saul wulay-manil. Ngali nyungu kalka and mayal banaji manil, dungayda.” Bula manin, dungan baja. Jana Saulundumundu soldier-soldierangka bulanin kari nyajin, Godungku jananin warngku-kaja-bungan. ");
INSERT INTO gvn_vpl VALUES ("S126_13","010_26_13","1SA","26","13","16","Yinyamun bula Davidangka bubu balay bawan, dakan wuburrbu yuba Saulundumunbu campmunbu. Yinyamun wuburrmun Davidangka soldieranda nyubunyimba Abneranda yirrkan. Abner, nyulu maja soldier-soldieranka kanbalanka. Davidangka yalaman, “Ya, Abner! Yundu nganya milkabu nyajil?” Abner warngkumun wandin, yalaman, “Ya, wanjungku nyungun king wandi-manil warngkumun?” David yirrkan baja, “Ya, Abner! Yundu maja jirray bajaku bubungu Israel. Wanyurrinku yundu nyungun king kari ngulkurrduku miyil-kujil? Yurra wubulku wulanyaku, nyungun kari mumbarabuku miyil-kujinya. Nyaka, kingamu kalka wanjabu? Nyungu mayal banaji wanjabu?” ");
INSERT INTO gvn_vpl VALUES ("S126_17","010_26_17","1SA","26","17","20","Saul warngkumun wandin, Davidanka buluku binalman. Nyulu babajin, “Yinya yundu David?” Davidangka yalaman, “Yuwu, maja, yundu wanyurrinku nganya wukurril-wukurril, kuninka? Ngayu wanjarrman, yundu nganya yarkin-bunganka? Kaki Godungku yunun yungan, ngayu nyungundu praymal. Kaki bamangka yungan, Godungku jananin buyun-damal. Jana nganya kanbin ngaykuwunbu bubungu kadanka. Ngayu wawu kari yalaymba wulanka, kala-kalbay Godundumun. Ngayu jarra yala, jirray kari. Yundu king bajaku, wanyurrinku nganya wukurril-wukurril, yarkinkaku kuninka?” ");
INSERT INTO gvn_vpl VALUES ("S126_21","010_26_21","1SA","26","21","25","Saulungku yinya kuku nyajin, nyulu yalaman, “Ngayu buyunman. Yundu kaday, David. Ngayu yunun kari buyun-damal baja, yundu nganya kari yarkin-bunganya. Ngayu kiru-kari bajaku, yunun kari juru-wukurrinyaku.” Davidangka yalaman, “Yunu kalka yaluy; bama yunga, maninka. Nyiku Godungku nganya junkurrji-bungan, yunun yarkinkaku kuninka, yamba ngayu kari kunin. Ngayu wawu Godungku nganya yalarrku ngulkurrduku miyil-kujinka.” Saulungku Davidanda yalaman, “Ngayu wawu Godungku yunun ngulkurrduku kujinka.” Yinyamun David dunganda, Saul bayanbaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("S131_1","010_31_1","1SA","31","1","5","Jana Philistine-warra kadan baja, kuniwanka Israel-warranji. Jana bubungu Mount Gilboa kadan, yinyay kuniwan. Philistine-warrangka jananin kanbal Israel-warra yarkin-bungan, kanbal Israel-warra warririn. Jana Saul and nyungu kangkal-kangkal kulur, jana yalarrku warririn Philistine-warrandamun. Yamba jana Philistine-warrangka jananin wukurrin, Saulumu kangkal-kangkal yarkinkaku kuninyarrku. Nyulu Saul Philistine-warranji kuniwan, yamba jana nyungun bow and arrowmundu kunin. Nyulu mula wanarrin, yamba nyulu kariku wulan. Nyulu nyubunyundu soldieranda yalaman, “Yundu nganya naybubu swordmundu baka, yarkin-bunga. Ngayu wawu kari jana Philistine-warrangka nganya yarkinkaku kuninka.” Yamba nyulu soldier yinyilman, nyungun kari naybubu bakan, kari yarkin-bungan. Yinyaynka Saul nyuluku wuyar nyunguwunbu swordmunbu daran, bakajin, wulanyarrkuda. Nyulu soldierangka nyajin Saul wulanya, nyulu yalarrku nyuluku swordmunbu daran, bakajin, Saulunji wulankuda. ");
INSERT INTO gvn_vpl VALUES ("S21_1","011_1_1","2SA","1","1","12","Jana David townbu Ziklag bundandan warngku jambul. Nyubun bama yinyaymba kadan warmun. Nyulu Davidanda dungan, bubungu badaman. David nyungundu babajin, “Yundu wanjamun?” Nyulu yalaman, “Ngayu ngakijin Israel-warrandamun campmun.” Davidangka yalaman, “Ngaykundu balka. Yurra wanjarrman?” Bamangka yalaman, “Nganjin Philistine-warrandamun warririn. Bama wubul bajaku wularin. Nyulu Saul and nyungu kangkal-kangkal dingkar-dingkar yalarrku wularinyarrku.” Davidangka nyungu kambi dumbarrin, nyunguwundu soldier-soldierangka yalarrku kambi dumbarrin. Jana yalaku, milka-bujarmanya. Jana wungar-kalbayku badirin, mayi kari nukan, Saul, Jonathan, Israel-warra wubul wularinya. ");
INSERT INTO gvn_vpl VALUES ("S22_1","011_2_1","2SA","2","1","4","David Godundu babajin, “Yundu wawu ngayu majamanka nyubunyinka townku bubungu Judah?” Godungku yalaman, “Yuwu, yundu townku Hebronmunku majamaka.” Yinyamun David townbu Hebron bundan. Nyulu manyarr jambul wundin, yalarrku nyungu soldier-soldier, jananga manyarr-karra wundin. Yinyamun jana Israel-warra bubungu Judah bundandan, jana David jananga king-bungan. ");
INSERT INTO gvn_vpl VALUES ("S22_8","011_2_8","2SA","2","8","10","Godumu bama Israel-warra, jana bubungu jambuliymba bundandan. Bubu nyubun burri Judah. David kingman bubuku Judahmunku. Yindu bubu burri Israel. Saulumu kangkal kingman bubuku Israelmunku. Yinya bubu yarra kuwa bubumun Judahmun, yamba jana bama wubulku Jacobandamun. Saulumu kangkal 2 years kingman Israel-warranka, bubungu Israelmunbu bundandan. ");
INSERT INTO gvn_vpl VALUES ("S24_7","011_4_7","2SA","4","7","12","Yinyamun soldierangka jambuldu Saulumu kangkal dukul naybubu yakan, yarkin-bungan. Bula dukul Davidanda wundin. Davidangka yinya nyajin, nyulu kuli-kadan. Nyulu nyunguwunbu soldier-soldieranda yalaman, “Bulanin kuni, yarkin-bunga.” Soldier-soldierangka bulanin yarkin-bungankuda, bula king yarkin-bunganya. ");
INSERT INTO gvn_vpl VALUES ("S25_3","011_5_3","2SA","5","3","4","Wawu yinyamun jana maja-maja bubungu Israel Davidanda kadan townbu Hebron. Jana David king-bungan janawunku bubuku. Yinyamun David kingman bamanka Israel-warranka wubulkuku, bubuku Judahka and bubuku Israelmunku. Nyulu jananka kingman ngadingka. ");
INSERT INTO gvn_vpl VALUES ("S25_6","011_5_6","2SA","5","6","10","Nyubun town burri Jerusalem bubungu Judah. Yamba Israel-warra kari townbu Jerusalem bundan. Jebusite-warra yinyaymba bundan. David, nyungu soldier-soldier townbu Jerusalem dungan, Jebusite-warranji kuniwanka, jananin townmun Jerusalemmun kanganka. Wall junkurrji bajaku yinyayngkarrku towndurr Jerusalemmundurr. Yinyaynka jana Jebusite-warrangka David yajarrin, yalaman, “Yundu yaluy kari bajaku walal. Miyil-burrangka and barrka-buyunyungku yurranin kanbil, walanka.” Yamba Davidangka jananin Jebusite-warra townmun Jerusalemmun kangan. Yinyamun nyulu jurrkijin townmun Hebronmun, townbu Jerusalem bundan. Jana Jerusalem burri dalkin, “Davidamu Town.” David junkurrjimalman, God nyungunji bundandanya. ");
INSERT INTO gvn_vpl VALUES ("S26_1","011_6_1","2SA","6","1","2","Davidangka yalaman, “Ngayu Godumu box yalaymba townbu Jerusalem wundinka.” Ngadiku jana Godumu box bawan nyubunyimba bamandamunbu bayanba bubungu Judah. Davidangka soldier-soldier wubul muru-bungan, 30,000-bala. Jana dungarin, Godumu box maninka, townbu Jerusalem wundinka. ");
INSERT INTO gvn_vpl VALUES ("S26_3","011_6_3","2SA","6","3","5","Jana box manin, buggynga jirakalba yijarrin, bulkingka jambuldu kulban. Jana singmanijin, dancemanijin, wawurr-wawurrku dungan-dungarin. Jambul dingkar-bulal yubaku boxmunbu dungan-dungan. ");
INSERT INTO gvn_vpl VALUES ("S26_6","011_6_6","2SA","6","6","7","Jana dungan-dungarin, bulkingka durru yilban. Nyubun dingkar balu box buggymun daranji, nyulu box karrban. Yamba God kuli-kadan nyungunku, Godungku ngadiku kuku dajinya bamangka nyungu box kari karrbanka. Yinyaynka Godungku yinya dingkar yarkin-bungan. ");
INSERT INTO gvn_vpl VALUES ("S26_9","011_6_9","2SA","6","9","12","David yinyilmanda, Godungku yinya dingkar yarkinkaku kuninya. Davidangka Godumu box bawanda, bamanji nyubunyinji. Godumu box nyungunji bundandan, Godungku yinya bama yalbayku blessing dajin. Davidangka yinya kuku nyajin, nyulu Godumu box manin baja, wundinka baja townbu Jerusalem. ");
INSERT INTO gvn_vpl VALUES ("S26_13","011_6_13","2SA","6","13","17","Jana dungan-dungarin, David dancemanijin, God buyay-maninka. Jana Godumu box wundin, townbu Jerusalem kadan, trumpet balkan-balkanya, box yulmbarrin-yulmbarrinya. Jana Godumu box wundin, Godundumunbu tentmunbu yijarrin. Yinyamun jana minya kunin, wayjun, Godundu dajin, nyungun buyay-maninka. ");
INSERT INTO gvn_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","David kingman, nyulu bayanba yalbaymba bundan. Godungku nyungun ngulkurrduku kujin bamandamun kuli-bakandamun. ");
INSERT INTO gvn_vpl VALUES ("S27_2","011_7_2","2SA","7","2","3","Davidangka prophetanda Nathananda yalaman, “Ngayu bayanba ngulkurrbu bundanday, yamba Godumu bayan tent. Ngayu bayan ngulkurr ngaral, Godumu box kujinka.” Nathanangka yalaman, “Yalada, yunduku-baja.” ");
INSERT INTO gvn_vpl VALUES ("S27_4","011_7_4","2SA","7","4","17","Yamba wujurrbu Godungku Nathananda yalaman, “Yundu Davidanda balka, ‘Yundu ngadiku sheep-sheep kujin-kujin, yamba ngayu yunun wangkanyin maja king-bunganka ngaykuwunku bamanka Israel-warranka. Kaki yundu wulay, ngayu yunu kangkal king-bungal. Ngayu nyungun junkurrji-bungal, yanya bubu ngulkurrduku kujinka. Ngayu yala nyungu nganjanmal, nyulu yala ngayku kangkalmal. Kaki nyulu buyunmal, ngayu nyungun punishim-bungal, yala nganjanangka nyungu kangkal punishim-bungal buyunmanya. Yamba ngayu nyungun kari bawal, yala ngayu King Saul bawan. Bama yunundumun wuljaljiku bunday. Nyubunyinja kangkalangka yunuwundu ngayku bayan ngaral, yundu kari.’” Nathanangka yinya kuku Godundumun balkan Davidanda. ");
INSERT INTO gvn_vpl VALUES ("S28_1","011_8_1","2SA","8","1","15","David, nyungu soldier-soldier dungarin, Philistine-warranji kuniwanka. Nyulu jananin beatim-bungan, kingman jananka. Yinyamun nyulu Moab-warra beatim-bungan, wubul yarkin-bungan. Nyulu jananka kingman, jana nyungundu tax money dajin. Yinyamun nyulu Syria-warra beatim-bungan. Nyulu jananin soldier-soldier wubul karrban, 20,000-bala, yalarrku janandamun yarraman wubul manin. Nyulu kanbal yarraman yarkinkaku kunin, kanbal nyulu kujin. Yamba Damascus-warrangka soldier-soldier yungan, Syria-warra helpim-bunganka. Davidangka jananin yalarrku beatim-bungan, soldier-soldier wubul yarkin-bungan, 22,000-bala. Davidangka Edom-warra yalarrku beatim-bungan, 18,000-bala yarkin-bungan. David junkurrjimalman, nyungu bubu yalbaymalman. Nyulu nyungu soldier-soldier yiringkurrku yijarrin, bawan, bama junkayku kujinka. Nyulu bama bubungu Israel ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Wungarijimanya timeda, kingangka soldier-soldier wundinka, kuniwanka. Davidangka nyungu maja-maja soldier-soldieranka and nyungu soldier-soldier yungan, Ammon-warranji kuniwanka. Yamba nyulu jananji kari dungan, bayanbaku bundan. ");
INSERT INTO gvn_vpl VALUES ("S211_2","011_11_2","2SA","11","2","5","Yilay-yilayman David warngkumun wandin, verandamunbu dungan. Veranda jarra-jarra, Davidangka yinyaymun maku towndurr nyajin. Nyulu jalbu nyubun nyajin janjil-janjinya. Yinya jalbu ngulkurrijin bajaku, David bujanji nyungunku. Davidangka bama kukuji yungan, binalmanka jalbunku. Nyulu binalman nyulu burri Bathsheba, dunyu nyungu burri Uriah. Uriah, nyulu Davidamu soldier armynga. Davidangka kukuji yungan baja, yinya jalbu nyungundu kadanka. Nyulu jalbu Davidanda kadan. Bula wunan, nyulu jalbu dungan baja bayanbaku. Nyulu juma nyajijin, kulngkul. Nyulu Davidanda kuku yunganda, nyulu kulngkulda. ");
INSERT INTO gvn_vpl VALUES ("S211_14","011_11_14","2SA","11","14","27","Davidangka kaban yungan majanda armynka, yalaman, “Yundu Uriah jakalba yunga, yinyaymba jana yaykarrku kunil-kuniway, jana nyungun yarkin-bunganka.” Majangka armynga nyungu kuku wukurrin, jana Uriah yinyamun yarkin-bungan. Yinyamun Davidangka Uriahmu manyarr marryim-bungan, bulanga kangkal balkajinda. Yamba Godungku yinya nyajin, nyulu kari wawurr-wawurrman Davidanka. ");
INSERT INTO gvn_vpl VALUES ("S212_1","011_12_1","2SA","12","1","4","Yinyamun Godungku prophet Nathan Davidanda yungan. Nathan Davidanda kadan, yalaman, “Bama jambul nyubunyimba townbu bundandan. Nyubun rich-bala, yindu poor-bala. Rich-bala minya bulki and sheep wubul bajaku, yamba poor-bala minya sheep karrkay nyubunku. Nyulu poor-balangka minya sheep karrkay ngulkurrduku kujin, nyunguwunbu bayanba kangkal-kangkalanji. Nyulu bana and mayi nyungu dajin minyanga sheepanga. Yinya sheep yala nyunguku kangkal. Juma bama ngarrbal rich-balandamunbu bayanba kadan. Rich-balangka ngarrbalanka mayi jirray wayjunku, yamba nyulu nyunguku minya kari kuninka. Yinyaynka nyulu poor-balamu minya sheep karrkay kunin, wayjun, mayi jirray-bungan ngarrbalanka.” ");
INSERT INTO gvn_vpl VALUES ("S212_5","011_12_5","2SA","12","5","6","Davidangka yinya kuku nyajin, nyulu kuli-kadan. Nyulu yalaman, “Nyulu rich-bala buyun bajaku. Nyulu wulanyaku. Nyulu poor-bala buyun-damanya, nyulu must payim-bunga moneybu jirraynja.” ");
INSERT INTO gvn_vpl VALUES ("S212_7","011_12_7","2SA","12","7","12","Nathanangka Davidanda yalaman, “Yunduda yala yinya bama rich-bala storymunbu. Godungku yanyu kuku dajin yunundu, ‘Ngayu yunun king-bungan Israel-warranka, yunun ngulkurrduku kujin King Saulundumun. Ngayu yunundu Saulumu bubu, nyungu manyarr-karra dajin. Yundu ngaykundu babajinyaku, ngayu yunundu jirray dajinyaku. Yundu wanyurrinku ngayku kuku kari wukurrin, wanyurrinku buyun-daman? Yundu Uriah yarkinkaku kunin, nyungu manyarr manin. Yinyaynka bamangka kuli-bakangka kanbal bama yunundumun yarkinkaku kunil. Ngayu yunu kangkal walu-dandi-bungal, nyulu yunu trouble dajil.’” Yinya kuku Godundumun Nathanangka Davidanda balkan. ");
INSERT INTO gvn_vpl VALUES ("S212_13","011_12_13","2SA","12","13","15a","Davidangka yinya kuku nyajin, nyulu wawu-buyunman buyunmanya, yalaman, “Ngayu God buyun-daman.” Nyulu Godunduku jurrkijinka baja. Nathanangka yalaman, “Godungku yunu buyun-buyun kidal, yundu kari wulay. Yamba yundu God buyun-damanya, yubalanga Bathshebanga kangkal juma wulay.” Yinyamun Nathan bayanbaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("S212_15b","011_12_15b","2SA","12","15b","18","Godungku yinya kangkal bulanga bambay-bungan. Davidangka Godundu prayman, kangkal ngulkurr-bunganka. Yamba warngku 7-balaman kangkal wulan. ");
INSERT INTO gvn_vpl VALUES ("S212_24","011_12_24","2SA","12","24","25","Bula David, manyarr Bathsheba badin kangkalanka. Yinyamun Bathshebangka kangkal yindu manin. Davidangka nyungun burri dalkin Solomon. God nyungunku wawu jirray. ");
INSERT INTO gvn_vpl VALUES ("K12_1","012_2_1","1KI","2","1","4","David wulmanman, nyulu nyungu kangkal Solomon kunjan, yalaman, “Ngayu wulman bajaku, ngayu kunbay yurranka. Wawu wulanyamun yundu kingmal. Yundu junkayku dungay, Godumu kuku wukurrika, kuku nyulu Mosesanda dajin. Kaki yundu God wukurril, nyulu yunun ngulkurrduku kujil yala nyulu ngadiku promiseim-bungan. ");
INSERT INTO gvn_vpl VALUES ("K12_10","012_2_10","1KI","2","10","12","Wawu yinyamun David wulan. Jana nyungun juljalba nandan townbu Jerusalem. Nyulu kingman bamanka Israel-warranka 40 years. Yinyamun Solomon, Davidamu kangkal, nyulu kingman. Nyulu bama Israel-warra ngulkurrduku kujin, junkurrjiman. ");
INSERT INTO gvn_vpl VALUES ("K13_3","012_3_3","1KI","3","3","9","Solomon Godunku wawu jirray. Nyulu nganjanamu Davidamu kuku wukurrin. Yala-yala nyulu townbu Gibeon dungan. Wujurrbu nyulu bijarrin. God nyungundu kadan bijarr, Solomonanda babajin, “Yundu wawubu ngayu yunundu wanyu dajinka?” Solomonangka yalaman, “Yundu ngaykuwunku nganjananka wawu jirray, nyungun ngulkurrduku kujin. Ngayu nyungu kangkal jarra warruku, yamba yundu nganya king-bungan. Yundu nganya king-bungan yunuwunku bamanka wubulinkaku. Yundu nganya dukul-ngulkurr-bunga, ngayu binalmanka wanyu ngulkurr, wanyu buyun. Ngayu ngangkal-ngangkal, jananin bama ngulkurrduku kujinka.” ");
INSERT INTO gvn_vpl VALUES ("K13_10","012_3_10","1KI","3","10","15","Godungku yinya kuku nyajin, nyulu wawurr-wawurrman, yalaman, “Yundu kari babajin yundu ngadingka bundanka bubungu or rich-balamanka or junkurrjimanka bamanka kuli-bakanka, yamba yundu babajin dukul-ngulkurrmanka. Ngayu yunu dajilda, yundu yinyaynka babajinya. Ngayu yunun yalarrku rich-bala-bungal, bamangka yunun buyay-manil. Kaki yundu ngayku kuku wukurril yala yunuwundu nganjanangka wukurrin, yundu ngadingka juranku bunday.” Solomon warngkumun wandin, nyulu binal Godungkuku nyungundu balkan. Yinyamun nyulu townbu Jerusalem dungan baja, God buyay-manin jakalba Godundumunbu boxmunbu. ");
INSERT INTO gvn_vpl VALUES ("K13_16","012_3_16","1KI","3","16","27","Solomon nyunguwunbu bayanba bundandan, jalbu-bulal jambul nyungundu kadan. Nyubunyinja Solomonanda yalaman, “Ngalin bayanba nyubunyimba bundanday. Ngayku kangkal ngawa balkajin, warngku jambulman nyungu yinduymbu kangkal balkajin. Ngalinku nyajin, kanbalda kari. Wujurrbuku nyulu jurrkijin, nyungundu kanban nyarrijin, nyungu kangkal wulan. Yinyamun nyulu wandin, ngayku kangkal juranku manin, nyunguwunbu bedba yijarrin. Yamba nyulu nyungu kangkal yarkin ngaykuwunbu bedba yijarrin. Yalibalaku ngayu warngkumun wandin, ngaykuwunbu kangkalba bibi dajinka, ngayu nyajin, nyulu wulan. Kari, ngayu nyungun kunkun-bungan, nyajin nyulu ngayku kari kangkal.” Yamba jalbungku yinduynju yalaman, “Kari, kangkal juranku ngayku, kangkal yarkin yunu.” Yinduynju yalaman, “Kari bajaku. Kangkal yarkin yunu, ngayku juranku.” Bula yalaku murru-kangawan jakalba kinganda. Solomonangka yalaman, “Yubal jambuliynjaku balkal yinya karrkay juranku yubalanga.” Yinyamun nyulu workingmananda balkan naybu sword maninka. Wawu maninyamun nyulu workingmananda yalaman, “Ngawa juranku kankuruku yaka, half daya nyubunyimba, half yinduymbu daya.” Nyulu ngamu bajaku kangkalanka wawu jirray, wawu kari nyajinka nyungu kangkal wulanka. Yinyaynka nyulu kinganda yalaman, “Kari yaka, ngawa yinduymbu daya.” Yamba ngamu-karingka yalaman, “Yalada, yakada.” Yinyamun Solomonangka yalaman, “Ngawa kari yaka, yinyanda jalbundu daya, nyulu wawu kari nyajinka wulanka. Nyuluku ngamu bajaku.” ");
INSERT INTO gvn_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Jana Israel-warrangka yinya kuku nyajin Solomonanka, jana nyungun buyay-manin, binal nyulu dukul-ngulkurr, jananin ngulkurrduku kujinka. ");
INSERT INTO gvn_vpl VALUES ("K15_1","012_5_1","1KI","5","1","5","Juku mirrbangku yamba-kari bubungu Israel, Godumu bayan ngaranka, yamba juku mirrbangku jirray bajaku bubungu Lebanon. Yinyaynka Solomonangka kuku yungan kinganda Lebanonanka, yalaman, “Yundu binal ngayku nganjan kuniwanya kinganji kanbalanji. Yinyaynka nyulu kari Godumu bayan ngaran. Yamba ngayu kari kuniwayda, bama kuli-baka yamba-karimanya. Yinyaynka ngayu bayan ngaranka Godumu. Ngayu wawu yundu yunu workingman wubul yunga, juku mirrbangku nyandanka. Ngayku workingman kari mala-juku yala yunu. Ngayu yunu workingman payim-bungal yala yundu balkal.” ");
INSERT INTO gvn_vpl VALUES ("K15_7","012_5_7","1KI","5","7","11","Hiram, nyulu king bubuku Lebanonanka. Nyulu yinya kuku Solomonandamun nyajin, nyulu wawurr-wawurrman, yalaman, “Ngayu God buyay-manilda, nyulu Davidamu kangkal dukul-ngulkurr-bunganya, kingmanka.” Nyulu Solomonanda kuku yungan, yalaman, “Ngayu juku mirrbangku yungal yala yundu babajin. Ngaykuwundu bamangka juku mirrbangku muru-bungal, karrabu kajal, jalundurr walngkal yunuwunbu bubungu. Ngayu wawubu yundu mayi yunganka ngaykuwunku workingmananka.” Bula yalaku dajiwan. ");
INSERT INTO gvn_vpl VALUES ("K16_1","012_6_1","1KI","6","1","37","Solomonangka carpenter-warranda balkan Godumu bayan ngaranka. Jana ngaran kuljimun, yulalmun, goldmun. Jana rooms wubul balkan priest-warranka, mayi jananga kujinka. Jana room nyubun balkan, Godumu box kujinka. Yinya room ngulkurr bajaku, walls wubulku nandajin goldmunbu. Jana ngadingka Godumu bayan ngaral-ngaran, 7 years. ");
INSERT INTO gvn_vpl VALUES ("K18_1","012_8_1","1KI","8","1","4","King Solomonangka Israel-warra maja-maja yiringkurrmun kunjan, townbu Jerusalem kadanka. Jana wubulku murumarin, jana priest-warrangka Godumu box jarra-kulban tentmun, Godundumunbu bayanba yijarrin. ");
INSERT INTO gvn_vpl VALUES ("K18_22","012_8_22","1KI","8","22","30","Wawu yinyamun Solomon jakalba altermunbu janan, mara jiringa wangkar-bungan, Godundu prayman. Nyulu yalaman, “Maja God Israel-warranka. Yundu God jirray bajaku. Yindu god yala yundu yamba-kari jiringa, bubungu. Yundu God bajaku, manubajaku bunday, yunuwunku bamanka wawu jirray. Kaki jana yunun wukurril, yundu jananin ngulkurrduku kujil. Yunu bama kuku nyakangarr, jana praymal yunundu.” Solomon yalaku prayman Godundu. ");
INSERT INTO gvn_vpl VALUES ("K18_62","012_8_62","1KI","8","62","62","Yinyamun jana bamangka wubuliynjaku minya kunin, wayjun, Godundu dajin, nyungun buyay-maninka. ");
INSERT INTO gvn_vpl VALUES ("K110_1","012_10_1","1KI","10","1","3","Nyubunyinja Queenangka bubumun Shebamun, nyulu kuku nyajin Solomonanka. Nyulu kuku nyajin Solomon binal bajaku, dukul-ngulkurr bajaku. Yinyaynka nyulu Solomonanda kadan, kuku nyungun babanka. Nyulu presents jirray nyungunji wundin, Solomonanda dajinka. Nyulu kuku nyungun baban, yamba Solomonangka kuku wubulku mala-yirrkan. ");
INSERT INTO gvn_vpl VALUES ("K110_14","012_10_14","1KI","10","14","29","Solomonangka bayan wubul ngaran, dishes goldmun kananga yijarrin. Nyulu boat wubul yungan jalundurr, jana gold, silver, monkeys wundin nyunguwunbu bubungu. Nyulu jarra rich-balaman jananka kinganka yiringkurrku. Nyulu yalarrku army jirray-bungan, soldier-soldier wubul, yarraman wubul. Nyulu junkurrjiman, bama nyunguwunbu bubungu ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("K111_1","012_11_1","1KI","11","1","13","Jakalbaku Solomon ngulkurrku bundandan. Yamba juma nyulu buyunman. Nyulu jalbu-jalbu bubumun yindu-yindumun wubul marryim-bungan, jalbu-jalbu Israel-warrandamun kari. Ngadiku Godungku Israel-warranda yalaman, “Yurra bubungu Canaan bundanday, yurra Canaan-warra kari marryim-bunga. Kaki yurra jananin marryim-bungal, yurra jananga god wukurrinji.” Yamba Solomon Godundu kari milka-janan, yala nyungu nganjan Godundu milka-janan. Nyulu Solomon wulmanman, nyulu manyarr-karramu god wubulku buyay-manin. Yinyaynka Maja God jirimun kuli-kadan nyungunku, Solomonanda yalaman, “Yundu ngayku kuku kari wukurrinya, ngayu yunu jawun-karra yunundumun kari wuljaljiku ngulkurrduku kujil. Yundu wulay, yunu kangkal kingmal, yamba nyulu kingmal bubanka bamanka. Ngayu Israel-warra ngami-ngami-bal, yunu kangkal kingmal kanbalanka, yamba bama yindu kingmal kanbalanka, bubungu yinduymbu. Nyungu bama wubul.” ");
INSERT INTO gvn_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Juma Solomon wulan, jana nyungun juljalba nandan townbu Jerusalem. Yinyamun nyungu kangkal kingman. ");
INSERT INTO gvn_vpl VALUES ("K112_1","012_12_1","1KI","12","1","20","Solomonamu kangkal kingman Israel-warranka, yamba nyulu jananka buyunman. Yinyaynka kanbalda nyungun bawan, yindu bama king-bungan. Yinyamun jana Israel-warra ngami-ngamiman, bubungu jambulbu bundan. Kanbal naka bubungu Judah bundandarin, Solomonamu kangkal jananga king. Kanbal wubul bajaku, jana kuwa bubungu Israelmunbu bundandarin, yindu king jananga. ");
INSERT INTO gvn_vpl VALUES ("K112_26","012_12_26","1KI","12","26","30","Nyulu king bubuku Israelmunku, nyulu Godundumun jurrkijin, yalarrku bama jurrki-manin Godundumun. Nyulu bulki statue jambul goldmun balkan, nyubun townbu Bethel jajirrin, yindu townbu Dan jajirrin. Nyulu bamanda balkan bulki statue buyay-maninka, balkan yinya Maja God, God bajaku kari. ");
INSERT INTO gvn_vpl VALUES ("K114_1","012_14_1","1KI","14","1","11","Nyulu king bubuku Israelmunku Godundumun jurrkijinya, Godungku nyungu kangkal bambay-bungan. Yinyamun kingangka nyungu manyarr prophetanda yungan, babajinka kangkalanka. Prophetangka kingandamunbu manyarranda yalaman, “Yundu kinganda balka, ‘Yundu kajaka buyunman, nganya bawan, Dubu wukurrin, idol bulki statue buyay-manin. Yinyaynka bama dingkar-dingkar yunundumun kaday, jana wubulku wulari. Yunu kangkal kari ngulkurrmal baja bambaymun, nyulu juma wulayda. Yundu buyunmanya, ngayu yunun and bama yunuwunmun bubumun bawalkuda.” ");
INSERT INTO gvn_vpl VALUES ("K116_1","012_16_1","1KI","16","1","28","Jana bamangka bubungu Israel bama nyubun king-bunganya, nyulu king buyunmanya, jana bamangka yalarrku God bawanya, nyulu king wulanda. Jana yindu king-bunganya, nyulu buyunmanya, wulanda. Yalaku jana bundan bubungu Israel. ");
INSERT INTO gvn_vpl VALUES ("K116_29","012_16_29","1KI","16","29","33","Juma nyubun bama kingman, burri Ahab. Nyulu jarra buyun kanbalanka kinganka. Nyungu manyarr burri Jezebel. Nyulu Jezebel buyun bajaku, nyulu Dubu wukurril-wukurrin, ngurma statue burri Baal buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Nyubun prophet bubungu Israel, burri Elijah. Nyulu kuku maninya Godundumun, dajinya bamanda. Nyulu King Ahabanda yalaman, “Ngayu Maja God wukurril. Nyulu junkurrji bajaku, wuljaljiku Israel-warranka God. Nyulu ngaykundu balkan kaba kari kaday baja 3 yearsmunku.” ");
INSERT INTO gvn_vpl VALUES ("K117_2","012_17_2","1KI","17","2","7","Yinyamun Godungku Elijahnda yalaman, “Yanyu bubu bawa, dungay yilkinga ngayu yunundu milbil, yuba wawubajanga Jordan. Yundu yinyaymba bunday, bana nuka yilkimun. Ngayu dikalanda wajanda balkan yunu mayi wundinka.” Elijahngka Godumu kuku wukurrin, bubungu jirrbu-jirrbungu bundan. Nyulu bana nukan yilkimun, wajangka nyungundu mayi bread, minya wundin yalibalaburr, yilay-yilaynjarr. Yamba juma yilki marralman, kaba kunbanya. ");
INSERT INTO gvn_vpl VALUES ("K117_8","012_17_8","1KI","17","8","16","Yinyamun Godungku Elijahnda yalaman, “Yundu townbu Sidon dungay, bundanka. Ngayu nyubunyimba bunjilanda jalbundu balkan yunu mayi dajinka.” Elijah townbu dungan, nyulu bunjil nyajin, baya mujal-mujanya. Nyulu bunjilanda yalaman, “Ngayku bana dayangarr.” Bunjil dungay-dungan bana maninka, Elijah yirrkan, “Ngayku yalarrku mayi bread wundi.” Bunjilangka yalaman, “Ngayu manubajabuku balkal, ngayku mayi bread yamba-kari. Ngayku bubanku flour and olive-oil wunay. Ngayu bayada mujan-mujal, yinya mayi wayjunku, ngayku, ngaykuwunbu kangkalamu. Yinyamun ngalin wulay, mayi-karimun.” Elijahngka yalaman, “Yalada, kari worry-balamaka. Buban mana, wayju, ngaykungurr daya. Yinyamun yundu kanbal wayju yubalanga. Nyulu Majangka Godungku ngaykundu balkan yinya mayi kari kunbay, kaba kadanjiku.” Nyulu bunjilangka Elijah kuku-nyajin, jana mayi jirray nukan. Elijah bunjilanji bundandan, yinya mayi flour and oil kari kunban, Godungku jirray-bunganya. ");
INSERT INTO gvn_vpl VALUES ("K117_17","012_17_17","1KI","17","17","24","Juma bunjilamu kangkal bambayman, wulankuda. Bunjilangka Elijahnda yalaman, “Yundu wanyurrinku ngaykundu kadan, bundanka? Kuda yundu kadan, Godundu balkanka ngaykuwunku buyun-buyunku, nyulu ngayku kangkal wulay-maninka?” Elijahngka yalaman, “Yunu kangkal ngaykundu daya.” Nyulu karrkay yarkin ngamundumun manin, wangkar nyunguwunbu roommunbu jarra-kulban, bedba yijarrin. Wawu yinyamun nyulu Godunduda prayman, yalaman, “Ngayku God, yundu wanyurrinku yanyu bunjil buyun-daman? Nyulu nganya ngulkurrduku kujil-kujin, yamba yundu nyungu kangkal yarkin-banda. Yundu ngayku God, yundu yanyu karrkay juran-bunga baja.” Godungku Elijahmu kuku nyajin, nyulu karrkay juran-bungan baja. Elijahngka karrkay bada-bada wundin baja, ngamundu dajin. Bunjilangka yalaman, “Ngayu binalda yundu Godumu bama, binalda yundu Godumu kuku balkal-balkal.” ");
INSERT INTO gvn_vpl VALUES ("K118_1","012_18_1","1KI","18","1","19","Kaba kari kadan 3 yearsmunku. Yinyaynka bubu yiringkurrku marralman, mayi kari balkajin baja. Yala-yala nyulu Godungku Elijahnda yalaman, “Yundu King Ahabanda dungay, ngayu kaba yungalda.” Kingangka kuku nyajin Elijah nyungundu kankadanya, nyulu Elijahnda maku-warrin. Nyulu Elijah nyajin, nyulu yalaman, “Yundu yinyadakay! Yundu ngadingka bajaku kuli nganjinanga dajin-dajilkuda.” Yamba Elijahngka yalaman, “Kari, yunduku-baja kuli bamanda dajin-dajil, yundu Godundu kari milka-jananya. Yundu Dubu wukurrin-wukurril, ngurma statue Baal buyay-manin-manil, God kari. Yinyaynka ngayu yunundu milbil wanya junkurrji bajaku, nguba God, nguba Dubu.” Ahab babajin, “Yundu wanjarrku milbil?” Elijahngka yalaman, “Ngayu bamanda wubulbuku milbinka. Yundu dungay, bama wubulku muru-bunga. Ngayu yurranin maku-nyajil manjalba, Mount Carmel. Kari milka-wulay jananin Baalamu priest wundinka.” ");
INSERT INTO gvn_vpl VALUES ("K118_20","012_18_20","1KI","18","20","24","Nyulu King Ahab dungan, jananin muru-bunganka. Yinyamun bama wubul bajaku manjalba murumarin, nyajinka wanjarrmanka. Nyulurrku Elijahku Godundu milka-janan, kanbal kari. Jana wubulku murumarin, Elijah yaykarrku yirrkan, yalaman, “Yurra bama, ngaykundu milka-janay. Yurra Dubu wukurrin-wukurril, Baal buyay-manin-manil. Ngayu God bajaku jiringa wukurrin-wukurril. Kaki yurranga god Baal junkurrji, nyungunin wukurrika. Kaki ngayku God jiringa junkurrji, nyunguninku wukurrika.” Jana bama kuku-karimarin. Yinyaynka Elijahngka kuku balkan baja, yalaman, “Ngana yurranga god Baal nyajinka, nyulu nguba junkurrji, nguba kari. Bulki jambul wundi. Yurrawundu priest-warrangka balu bulki nyubun yarkin-bunga, minya kuljinga yijarrinka, baya yijarrinka, kariku wayju. Ngayu yindu bulki yalarrku kunil, minya kuljinga yijarril. Yinyamun yurranga priest-warra wubulku janawunbu godundu Baalanda yirrkay, nyulu baya wangkar-wangkarmun yunganka, minya bulki wayjunku. Wawu yinyamun ngayu yalarrku ngaykuwunbu Godundu yirrkay, baya yunganka jirimun. Wanyangkaku baya yungal, nyuluku God junkurrji bajaku.” Jana bamangka yinya kuku nyajin, jana wubuliynjaku yalaman, “Yalakudabi!” ");
INSERT INTO gvn_vpl VALUES ("K118_25","012_18_25","1KI","18","25","29","Jana priest-warrangka bulki nyubun kankuruku yakan, kuljinga yijarrin. Yinyamun jana janandamunbu godundu Baalanda yirrkan baja, yirrkan baja, yamba nyulu Baalangka baya kari yungan wangkar-wangkarmun. Elijahngka jananin yajarrin, yalaman, “Yaykarrku yirrkay. Yurranga god Baal nguba warngku wunanay. Nyulu nguba kala-kalbay dungan.” Jana priest-warra wurin baja, yirrkan baja, yamba janawundu godungku baya kari yungan, minya bulki wayjunku. Juma jana kunban. ");
INSERT INTO gvn_vpl VALUES ("K118_30","012_18_30","1KI","18","30","35","Yinyamun Elijahngka bama wubulku kunjan, yuba kadanka Godundumunbu alternga. Godumu alter kadaban, bamangka kari useim-bungan baja. Yamba Elijahngka ngulkurr-ban baja, janku bakan yinyangkarr alterburr. Nyulu baya yijarrin, minya wuyar yijarrin. Yinyamun nyulu yalaman, “Yurra, bana jirray nyangarrika minyanga, bayanga.” Jana bana jirray nyangarrinda, minyanga, bayanga, janku jakal-bungan banabu. ");
INSERT INTO gvn_vpl VALUES ("K118_36","012_18_36","1KI","18","36","39","Wawu yinyamun Elijah Godundu prayman, yalaman, “Maja God, bamanda milbi, yunduku junkurrji bajaku, yunduku God bajaku jiringa.” Wawu kukumun Godungku baya jinbaldaku jirimun yungan, minyanga, kuljinga. Bayabu minya bulki, juku, kulji, bana wubulku wayjunyarrkukuda. Jana bamangka yinya nyajin, jana kungkurr-kadarin, yalaman, “Maja jirimun, nyuluku God bajakukuda. Maja jirimun, nyuluku junkurrji bajaku.” ");
INSERT INTO gvn_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Jana priest-warrangka yinya nyajin, jana warririn, yamba bamangka jananin karrban, yarkinkaku kuninda. ");
INSERT INTO gvn_vpl VALUES ("K118_41","012_18_41","1KI","18","41","46","Elijahngka King Ahabanda yalaman, “Dungayda, mayi nukada. Ngayu numburr jirray nyajin kankadanyada.” King Ahab dungan, nukanka, Elijah wangkar manjalba dakan, dukul badaman. Nyulu workingmananda yalaman, “Dungay, jalunbu nyaka.” Workingman dungan, kadan baja, yalaman, “Ngayu ngurrban kari nyajin.” Elijahngka nyungun 7 times yungan, nyajinka. Last time nyulu kadan baja, yalaman, “Ngayu ngurrban karrkay nyajin, yala ngayku maranguy.” Elijahngka workingmananda yalaman, “Dungay, King Ahabanda balka nyulu bayanbaku dungay, kaba kadanjiku.” Juma ngurrban ngumbu jirray jiringa kadan, muyar warrin, kaba jirray kadan. King Ahab buggyji jinbalku warrin. Yamba Godungku junkurr jirray dajin Elijahnda, nyulu Elijah jakalba yarramananda warrin townbuku. ");
INSERT INTO gvn_vpl VALUES ("K119_1","012_19_1","1KI","19","1","2","King Ahabamu manyarr Jezebel buyun bajaku. Ahabangka nyunguwunbu manyarranda balkan Elijahngka jananin Baalamu priest-warra wulay-manin. Jezebelangka yinya kuku nyajin, nyulu kuli-kadan, kuku yungan Elijahnda, yalaman, “Yundu jananin priest-warra yarkin-banya, ngayu soldier-soldier yungal, yunun wunkun yalarrku yarkin-banka.” ");
INSERT INTO gvn_vpl VALUES ("K119_3","012_19_3","1KI","19","3","9a","Elijahngka yinya kuku nyajin, nyulu yinyilman, yinyamun bubumun warrin, bubungu Judah dungan. Yinyamun nyulu jilba dungan baja bubungu jirrbu-jirrbungu, bundan wabarrba. Nyulu milka-bujarman, Godundu prayman, yalaman, “Ngayku wawu mana, ngayu wulankada.” Yinyamun nyulu warngku wunan jukungu dingalba wabarrba. Yamba angelangka nyungun marabu karrban, yalaman, “Warngkumun wandi, mayi nuka.” Elijah wandin, mayi bread, bana nyajin wunananya. Nyulu mayi and bana nukan, warngku wunan baja. Yamba angelangka nyungun wandi-manin baja, yalaman, “Mayi nuka baja, junkurrjimaka, yundu kala-kalbay dunganka.” Elijahngka mayi nukan, junkurrjiman, nyulu kala-kalbay 40 days dungan, manjalba Sinai kadan. Yinya Godumu manjal. Yinyaymba Elijah cavemunbu walan, warngku wunan baja. ");
INSERT INTO gvn_vpl VALUES ("K119_9b","012_19_9b","1KI","19","9b","18","Elijah cavemunbu warngku wunanan, God nyungundu babajin, “Elijah, yundu wanyurrinku yaluy bundanday?” Elijahngka yalaman, “Maja God, ngayurrku yunun wuljaljiku wukurril, kanbalda kari. Jana Israel-warrangka yunu kuku bawan, yunu kulji alter dumbarrin, yunu prophet-warra yarkin-ban. Ngayurrku yunun wukurrin-wukurrilda, jana nganya yalarrku yarkinkaku kuninka.” Godungku Elijahnda yalaman, “Wangkar daka yinyaymba manjalba.” Elijah manjalba dakan, Godungku muyar jirray yungan, kulji dumbarrin, yamba Godungku nyungu wawu muyaranji kari yungan. Muyar kunban, Godungku bubu bulngan, earthquake. Yamba Godumu wawu kari earthquakemunbu. Earthquake kunban, Godungku baya jirray yungan, yamba Godumu wawu kari bayanga. Baya kunban, Elijahngka yayngkar nyajin. Nyulu kambibu walu nandajin, ngalkalba cavemun wandin. God yayngkarabu babajin, “Elijah, wanyurrinku yundu yaluy bundanday?” Elijahngka yalaman, “Maja God, ngayurrku yunun wuljaljiku wukurril, kanbalda kari. Jana Israel-warrangka yunu kuku bawan, yunu kulji alter dumbarrin, yunu prophet-warra yarkin-ban. Ngayurrku yunun wukurrin-wukurrilda, jana nganya yalarrku yarkinkaku kuninka.” Godungku yalaman, “Bubungu jirrbu-jirrbungu dungay, yuba townbu Damascus. Yinyamun townbu wala, bama burri Jehu olive-oildu dukul-dama; nyulu juma kingmanka bubuku Israelmunku. Yinyamun bama burri Elisha olive-oildu dukul-dama. Nyulu yunun karrnga-dajil. Kari. Yundurrku kari nganya wukurril. Bamangka 7000-balangka yalarrku god Baal kari buyay-manil bubungu Israel.” ");
INSERT INTO gvn_vpl VALUES ("K119_19","012_19_19","1KI","19","19","21","Yinyamun Elijah dungan baja, nyulu Elisha warrmba-bungan workmanmanijinya. Elijahngka coat walngan, Elishanda diday-manin, milbinka Elishangka Elijah karrnga-dajinka. Elisha Elijahnji dungaynda, helpim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("K121_1","012_21_1","1KI","21","1","3","King Ahab nyunguwunbu bayanba bundandan. Garden mayiji grapemunji yuba nyunguwunbu bayanba, yamba yinya garden nyungu kari. Garden bamamu nyubunyimba, Nabothamu. Ahab wawu jirray yinyanka gardenka, yamba nyulu Nabothangka wawu kari sellim-banka. Yinyaynka Ahab milka-bujarman. ");
INSERT INTO gvn_vpl VALUES ("K121_4","012_21_4","1KI","21","4","7","Nyunguwundu manyarrangka Jezebelangka nyungun nyajin milka-bujarku bundandanya, nyulu babajin, “Wanyurrinku yundu yalaku bundanday?” Ahabangka yalaman, “Yinyangka bamangka Nabothangka nyungu garden kari sellim-bal ngaykundu.” Jezebelangka yalaman, “Yundu maja king or kari? Ngayu yinya garden manil yunu.” ");
INSERT INTO gvn_vpl VALUES ("K121_8","012_21_8","1KI","21","8","16","Yinyamun nyulu Jezebelangka kaban yungan maja-majanda yiringkurrku bubungu Israel. Nyulu jananda yalaman, “Murumaka, mayi jirray wayju, holidaymunku. Naboth yalarrku kunja, mayinga kadanka. Kaki nyulu kaday, yurra nyungun jurril-bunga. Balka nyulu God and king buyun-daman. Nyungun nyuya buyun-buyunku, ngana nyungun kuljibu yarkinkaku kuninka.” Jana maja-majangka Jezebelamu kuku wukurrin, Naboth kuljibu yarkinkaku kunin. Nyulu Jezebelangka kuku nyajin Nabothanka, nyulu dunyundu kinganda dungan, yalaman, “Naboth, nyulu wulankuda. Dungayda, nyungu garden mana, yunuku kujida.” King Ahab wawurr-wawurrman, yinya garden nyungukuda. ");
INSERT INTO gvn_vpl VALUES ("K121_17","012_21_17","1KI","21","17","24","Yamba Godingku Elijahnda yalaman, “Kinganda dungay, ngayku kuku balka nyungundu. Ngayu yanyu kuku yungal Ahabanda, ‘Yundu Naboth yarkin-ban, nyungu garden maninka. Yundu nyungun yarkinkaku kuninya, yundu yalarrku wulay. Kaya-kayangka yunu mula bijal yala jana Nabothamu mula bijan. Yamba jana kayangka Jezebel bangkarr nukal.” Elijahngka God kuku-nyajin, nyungu kuku balkan Kinganda Ahabanda. ");
INSERT INTO gvn_vpl VALUES ("K122_1","012_22_1","1KI","22","1","40","Juma jana King Ahab kuniwan Syria-warranji warmunbu. Jana nyungun arrowbu daman, nyulu yarkinman. Nyulu mula warrin, kaya-kayangka mula bijan yala Godungkuku yalaman. ");
INSERT INTO gvn_vpl VALUES ("K22_1","013_2_1","2KI","2","1","10","Elisha, nyulu Elijah helpim-bal-ban. Elijah bula Elisha townmun Gilgalmun dungan-dungan, Elijahngka Elishanda yalaman, “Yaluy bunday. Godungku nganya kunjan, townbu Bethel dunganka.” Yamba Elishangka yalaman, “Kari, ngayu yunun kari bawal.” Yinyamun bula jambulku townbu Bethel dungan. Elijahngka Elishanda yalaman baja, “Yaluy bunday. Godungku ngaykundu balkan townbu Jericho dunganka.” Yamba Elishangka yalaman, “Kari. Ngayu yunun kari bawal.” Yinyamun bula townbu Jericho dungan. Elijahngka Elishanda yalaman baja, “Yaluy bunday. Godungku ngaykundu balkan wawubajanga Jordan dunganka.” Yamba Elishangka yalaman, “Kari, ngayu yunun kari bajaku bawal.” Bula dungan baja, prophet-prophetangka wubuldu, 50-balangka bulanin wukurrin wawubajanga Jordan. Bula wawubajanga janjanan, Elijahngka nyungu kambi coat mulun-bungan, kambibu bana kunin, bana ngami-ngamiman, bula ngubar-ngubar dungan bububurr marraldarr. Bula ngubar-ngubar kadan, Elijah Elishanda babajin, “Godungku nganya maninjiku, ngayu wanjarrmal yununku?” Elishangka yalaman, “Ngayu wawu yundu yunu junkurr jirray Godundumun ngaykundu daya.” Elijahngka yalaman, “Kaki yundu nganya nyajil heavenba dakanya, yundu junkurr Godundumun manil, yala ngayu. Kaki yundu nganya kari nyajil dunganya, yundu yinya junkur kari manil.” ");
INSERT INTO gvn_vpl VALUES ("K22_11","013_2_11","2KI","2","11","12","Bula dungan baja, balkan-balkawan. Kari, jinbalku Elishangka baya jirimun nyajin kankadanya. Yinya baya yala yarraman jambul buggyji. Bula yarraman buggyji kadan, Elijah bulal Elisha ngami-ngami-ban. Yinyamun muyarabu jirraynja Elijah heavenba dakay-manin. Elishangka yinya nyajin, nyulu Elijahnda yirrkan, “Ngayku nganjan. Yundu Israel-warra ngulkurrduku kujin. Yundu nganjinandamun dungankuda!” Yinyamun nyulu Elijah kari nyajin baja. Nyulu banbadin, kambi dumbarrin. ");
INSERT INTO gvn_vpl VALUES ("K22_13","013_2_13","2KI","2","13","15","Elijahmu kambi coat nyungundumun daran, nyulu dakanjiku. Elishangka yinya kambi manin, wawubajangaku Jordanku dungan baja. Nyulu kambibu bana kunin, yalaman, “Elijahmu God, yundu wanjabu?” Nyulu bana kunin baja kambibu, bana ngami-ngamiman baja, nyulu bububurr marraldarr ngubar-ngubar dungan. Jana prophet-prophetangka yinya nyajin, jana yalaman, “Godungku Elishamu junkurr dajin Elijahndamun.” ");
INSERT INTO gvn_vpl VALUES ("K24_8","013_4_8","2KI","4","8","10","Elisha townbu Shunem dungan. Yinyaymba jalbu rich-bala bundandan. Nyulu Elishanda yalaman, “Yundu ngaykuwunbu bayanba kaday, mayi nukanka.” Yinyamun Elisha townbu Shunem dunganya, nyulu jalbunji rich-balanji, nyunguwunji dunyunji mayinga nukajinya. Nyulu jalbungku dunyundu yalaman, “Yinya dingkar Godumu bama. Ngali room balkanka wuyar bayanba, nyulu dingkar Godumu townbu kaday, nyulu yinyaymba roommunbu bundanka.” Bula room ngaranda, Elishamu. ");
INSERT INTO gvn_vpl VALUES ("K24_11","013_4_11","2KI","4","11","17","Elisha bula nyungu workingman kadan baja, bula yinyaymba roommunbu bundan. Elishangka nyunguwunbu workingmananda yalaman, “Yinyayngka jalbungku yanyu room ngaran ngaykunku, ngayu wanjarrmal nyungunku?” Workingmanangka yalaman, “Nyulu jalbu kangkal yamba-kari, dunyu wulmankuda.” Elishangka yalaman, “Jalbundu balka yaluy kadanka.” Jalbu kadan, Elishangka yalaman, “Yundu juma kangkal dingkar manil.” Nyulu jalbungku kari believeim-banya, nyulu yalaman, “Kari jurrilmaka.” Yamba nyulu juma kulngkulman, kangkal dingkar manin. ");
INSERT INTO gvn_vpl VALUES ("K24_18","013_4_18","2KI","4","18","30","Yinya karrkay jarra yalbayman, nyulu nganjananji paddockmunbu dungan. Kari, nyulu jinbalku yirrkan, “Ngayu dukul wurrkal-wurrkal.” Nganjanangka workingmananda yalaman, “Nyungun ngamundu wundi.” Nyulu wundin, ngamungku kangkal barungu kujin, wungar jarra-jarraman. Nyulu karrkay wulankuda. Ngamungku yarkin wangkar Elishandamunbu roommunbu wundin, bawan. Yinyamun jalbungku dunyundu balkan donkey wundinka, nyulu Elishanda dunganka. Jalbu donkeynda dakan, jinbalku Elishanda dungan manjalba Carmel. Nyulu Elishanda yalaman, “Yundu ngaykunji kadayarr.” Bula dungan baja, jalbundumunbu bayanbaku. ");
INSERT INTO gvn_vpl VALUES ("K24_32","013_4_32","2KI","4","32","37","Elisha bayanba kadan, nyulu roommunbu dungan, yarkin nyajin bedba wunananya. Nyulu door nandan, Godundu prayman. Nyulu wuyar yarkinba wunan, yarkin wumbulman, miyil walngajin, juranmankuda. Elishangka ngamu kunjan, yalaman, “Yunu kangkal yalada.” Jalbu bungkubu janan jakalba Elishanda, dukul badaman. Yinyamun nyulu kangkal manin, dunganda. ");
INSERT INTO gvn_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Nyubun dingkar burri Naaman, nyulu maja jirray armynga bubungu Syria. Nyulu king bubuku Syriamunku, nyulu Naamananka wawu jirray. Yamba Naaman bambay, yulban buyunman leprosymunji. ");
INSERT INTO gvn_vpl VALUES ("K25_2","013_5_2","2KI","5","2","3","Jana Syria-warra ngadiku kuniwan Israel-warranji warmunbu. Yala-yala jana Syria-warrangka karrkay jalbu Israel-warrandamun ngakin. Yinya karrkay Naamanandamunku manyarranka workmanmanijin, bubungu Syria. Nyulu karrkayangka Naaman bambay nyajin, nyulu Naamanandamunbu manyarranda yalaman, “Ngayu wawubu yunu dunyu prophetanda Elishanda dunganka bubungu Israel. Nyulu yunu dunyu ngulkurr-bungal bambaymun leprosymun.” ");
INSERT INTO gvn_vpl VALUES ("K25_5","013_5_5","2KI","5","5","10","Yinyaynka Naaman buggyji dungan, Elisha nyajinka. Nyulu Elishandamunbu bayanba kadan, Elishangka workingman Naamananda yungan kukuji. Nyulu kukujingka Naamananda yalaman, “Yundu wawubajanga Jordan dungay, janji baja, janji baja 7 times. Yinyamun bambay leprosy kunbay.” ");
INSERT INTO gvn_vpl VALUES ("K25_11","013_5_11","2KI","5","11","13","Yamba Naaman kuli-kadan, yalaman, “Nyulu Elishaku ngaykundu kadanyaku, nyulu nyunguwunbu Godundu praymanyaku, nganya ngulkurr-bunganka. Ngayu kari wawubajanga Jordan dungay. Nganjinanga wawubaja bubungu Syria jarra ngulkurr wawubajaka Israelmunku. Kari, ngayu kari bajaku wawubajanga Jordan janjilkuda.” Yamba Naamanandamundu workingmanangka nyungundu yalaman, “Nyulu prophetangka balkanyaku yundu junjuy hard-bala doim-bunganka, yundu nyungu kuku wukurrinyaku. Yundu dungay, janji, nguba yundu ngulkurrmalda.” ");
INSERT INTO gvn_vpl VALUES ("K25_14","013_5_14","2KI","5","14","19","Nyulu Naaman workingmananda milka-janan, wawubajanga Jordan dungan yalaku Elishangkaku balkan. Nyulu janjin baja, janjin baja 7 times, nyulu yulban ngulkurrmankuda, leprosy kunbankuda. Naaman nyajijin, nyulu Elishanda dungan baja, yalaman, “Ngayu binalda God jirray bajaku bubungu Israel. Ngayu yunundu present dajinka.” Yamba Elishangka yalaman, “Kari. Ngayu Godumukuda workingman. Ngayu yunundumun present kari manil.” Wawu yinyamun Naamanangka Elisha bawanda. ");
INSERT INTO gvn_vpl VALUES ("K25_20","013_5_20","2KI","5","20","24","Yamba Elishandamundu workingmanangka nyuluku yalaman, “Ngaykuwundu majangka present maninyaku Naamanandamun. Ngayu nyungun Naaman wukurril, yinya present maninka ngaykuku.” Nyulu Naaman wukurrin, juru-manin, Naaman janan, babajin, “Wanyurrinku yundu nganya wukurrin?” Workingman jurrilman, yalaman, “Ngaykuwundu majangka nganya yungan, yunundu balkanka money jirray daya prophetanda kanbalanda.” Naamanangka yalaman, “Kari, ngayu yunundu money jirray bajaku dajil, jananda dajinka.” Nyulu money kurmunbu yijarrin, workingmananda dajin, dungan baja. ");
INSERT INTO gvn_vpl VALUES ("K25_25","013_5_25","2KI","5","25","27","Elishamu workingman bayanbaku kadan baja, nyulu money bayanba yijarrin. Elisha workingmananda babajin, “Yundu wanjabu dungan?” Nyulu workingman jurrilman, yalaman, “Kari, ngayu bayan kari bawan.” Yamba Godundumundu wawubu Elishanda balkan nyunguwunku workingmananka. Nyulu Elisha binal workingmanangka money present manin Naamanandamun. Nyulu yalaman, “Ngana present bamandamun kari maninyaku, present yala money, kambi, bubu garden, minya sheep and bulki. Yundu Naamanandamun present maninya, nyungundumun bambay leprosy yalarrku manil. Yundu and yunu kangkal-kangkal leprosymunjiku wuljaljiku bunday.” Nyulu workingmanamu yulban bingajiman, nyulu leprosymunjiku dunganda.");
INSERT INTO gvn_vpl VALUES ("K29_30","013_9_30","2KI","9","30","37","King Ahab wulan warmunbu. Yinyamun Jehu kingman. Nyulu Jehu Ahabandamunbu bayanba dungan, yinyaymba bundanka. Yamba Jezebel yinyayku bundandan. Nyulu Jehu nyajin kankadanya, wangkarmun verandamun. Jehu yuba kadan, Jezebelangka nyungun yukin. Kanbal bama Jezebelanji verandamunbu janjanan. Jehungku jananda yalaman, “Yurra, ngaykunku kurrkal-warri, nyungun Jezebel wangkarmun verandamun yilba.” Jana nyungun Jezebel karrban, bada bubungu yilban, yarkin-ban. Jana yarkin bawan, kaya-kayangka nyungun yarkin nukan, yala Godungkuku yalaman.");
INSERT INTO gvn_vpl VALUES ("K215_15","013_15_15","2KI","15","15","16","Jana Israel-warra bubungu jambulbu bundandan, bubungu Israel, bubungu Judah. Jana Israel-warra bubungu Israel prophet-prophetanda kari milka-janan. Jana king-kingangka buyun-buyun wukurrin baja, buyun-buyun wukurrin baja. Yinyaynka jana Israel-warrangka yalarrku buyun-buyun wukurrin. Jana God kari mumbarabuku wukurrin. Jana alters kuljimun ngaran wuburrbu yiringkurrku. Jana ngurma idol statues balkan, jananin buyay-maninka, Dubu wukurrinka, yala jana Canaan-warrangka. Yinyaynka God kuli-kadan jananka. Jana kangkal-kangkal yarkin-ban, wayjun altermunbu yala Canaan-warrangka jananga kangkal-kangkal wayjun. Jana mari-doctoranda dungan, Dubu wukurrinka, God kari. Yinyaynka Godungku Israel-warra bubungu Israel bawan, jananji kari bundan baja. Yamba nyulu Israel-warra bubungu Judah kari bawan. ");
INSERT INTO gvn_vpl VALUES ("K217_1","013_17_1","2KI","17","1","4","Israel-warramu king bubungu Israel kudamundumun burri Hoshea. Nyulu yalarrku God kari wukurrin. Jana bubumun Assyriamun Israel-warranji bubuku Israelmunku kuniwan, beatim-ban. Yinyamun King Hosheangka tax money payim-ban kinganda bubungu Assyria. Yamba juma nyulu tax money kari payim-banya baja. King bubumun Assyriamun kadan baja, King Hoshea jailba mumban. ");
INSERT INTO gvn_vpl VALUES ("K217_5","013_17_5","2KI","17","5","23","Jana Assyria-warra bubungu Israel kadan, Israel-warra buyun-daman. Jana Israel-warra prisoner-bungan, bubungu Assyria wundin, slave-bungan. Jana Israel-warrangka buyun-buyun wukurrinya, Godungku Assyria-warra kari kirin Israel-warra slave-bunganka. Yinyamun Israel-warra kari bubungu Israel bundan baja. ");
INSERT INTO gvn_vpl VALUES ("K218_1","013_18_1","2KI","18","1","8","Hezekiah 25 years oldman, nyulu kingman bubuku Judahmunku. Nyulu jananka king 29 years. Nyulu king ngulkurr, Godumu kuku wukurrin. Nyunguwundu workingmanangka ngurma idol Dubumu wubulku dumbarrin. Jana Israel-warrangka bubungu Judah God bajaku kari wukurrin, yamba Hezekiahngka jananin junkayku wundin. Nyulu God wukurrinya, Godungku nyungun and Israel-warra ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("K218_18","013_18_18","2KI","18","18","18","(18.13-19.34) Jana Assyria-warra bubungu Judah kadan, town wubul buyun-daman. Jana juma townbu Jerusalem kadanka. King Hezekiah Godundumunbu bayanba dungan, Godundu prayman. Prophetangka Isaiahngka kuku Godundumun balkan Hezekiahnda. Nyulu yalaman, “Godungku balkan, ‘Jana Assyria-warra yalaymba townbu Jerusalem kari walal. Jana arrows kari yilbal townbu. Jana soldier-soldier kari yuba kaday. Jana jurrkiji baja, dungay baja baraldarr janaku kadan. Ngayuku Godungkuku yinya kuku balkan. Ngayu yanyu town Jerusalem ngulkurrduku kujil, ngayu ngadiku David promiseim-bunganya.’” ");
INSERT INTO gvn_vpl VALUES ("K219_35","013_19_35","2KI","19","35","36","Jana soldier-soldier bubumun Assyriamun balnji wunan bubungu Judah. Yamba wujurrbu Godungku angel yungan, jananin soldier-soldier kuninka, yarkin-yarkin-bunganka. Nyulu 185,000-bala yarkin-ban. Yalibalaku jana yarkin-yarkin wubulku campmunbu wunanarin. Yinyamun jana soldier-soldier jurrkijirin baja, janawunbuku bubunguku Assyriaku dungarin baja. ");
INSERT INTO gvn_vpl VALUES ("K220_1","013_20_1","2KI","20","1","7","King Hezekiah balamumun bambayman, balu wulan. Prophet Isaiah kinganda dungan, yalaman, “Yundu wulay bambaymun, readymaka wulanka.” Yamba Hezekiah milka-bujarman, Godundu prayman. Nyulu yalaman, “Maja God, yundu binal ngayu yunun junkaynjaku wukurrin. Ngayu kari jurrkijin yunundumun.” Yinyamun nyulu milka-bujarku badin. Isaiahngka King Hezekiah bawan, yamba nyulu bayanmun kankadan, Godungku nyungundu yalaman, “Nyunbay baja kingandaku, nyungundu yanyu kuku balka, ‘Ngayu Davidamu God. Ngayu yunu milbal nyajin daranya, yunun nyajin ngaykundu praymanya. Ngayu yunun ngulkurr-bungalda bambaymun. Warngku kulurmal yundu ngaykuwunbu bayanba dungay. Yundu juranku bunday baja, 15 years. Ngayu yanyu town Jerusalem ngulkurrduku kujil Assyria-warrandamun, ngayu Davidanda promise dajinya.’” Yinya kuku Godungku Hezekiahanda balkan. Yinyamun Isaiahangka kingandamunbu workingmananda yalaman, “Medicine balka mayimun figmun, kinganda balamumunbu yijarrika, nyulu ngulkurrmalda.” ");
INSERT INTO gvn_vpl VALUES ("K220_12","013_20_12","2KI","20","12","13","Nyulu kingangka bubumun Babyloniamun kuku nyajin King Hezekiah ngulkurrmanya bambaymun. Yinyaynka nyulu bama kukuji yungan, present dajinka Hezekiahnda. Hezekiahngka jananin kukuji yulmbarrin, jananda nyungu money silver and gold milbin, nyungu mayi jirray and soldier-soldier wubulku nyulu milbin Babylonia-warranda. ");
INSERT INTO gvn_vpl VALUES ("K220_14","013_20_14","2KI","20","14","19","Yinyamun prophet Isaiah Hezekiahnda babajin, “Jana bama wanjamun kadarin? Yundu jananda wanyu milbin?” Hezekiahngka yalaman, “Jana kala-kalbaymun kadarin, bubumun Babyloniamun.” Isaiah babajin, “Jana wanyu nyajin yunuwunbu bayanba?” Hezekiahngka yalaman, “Jana wubulku nyajin, mayi, money, soldier-soldier.” Isaiahngka yalaman, “Godungku balkan jana Babylonia-warrangka juma junjuy-junjuy wubulku yalaymun ngakil, wundil janawunbu bubungu. Jana yanyu bubu buyun-damal, bama Israel-warra jananga slave-warramal.” Hezekiahngka yinya kuku nyajin, nyulu yalaman, “Kaki Godungku balkanka, balu nyulu balka.” ");
INSERT INTO gvn_vpl VALUES ("K220_20","013_20_20","2KI","20","20","21","Wawu 15 yearsmun Hezekiah wulan, nyungu kangkal Manasseh kingman. ");
INSERT INTO gvn_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","3","Bama yindu kingman bubuku Babyloniamunku. Godungku nyungundu yalaman, “Yundu ngayku bama Israel-warra janawunbuku bubunguku yunga baja, ngayku bayan ngaranka baja.” Nyulu kingangka kaban yiringkurrku yungan Israel-warranda nyunguwunbu bubungu. Nyulu kabanba balkan, “God jirimunku, nyuluku nganya king-bungan. Nyulu ngaykundu balkan nyungu bayan ngaranka baja bubungu Judah, townbu Jerusalem. Ngayu wawu yurrawundu Godungku yurranin Israel-warra ngulkurrduku kujinka. Ngayu wawu yurra yurrawunbuku townbuku Jerusalemku dungarika baja, Godumu bayan ngaranka baja.” ");
INSERT INTO gvn_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","(1.5-3.8) Jana Israel-warrangka wubuldu jananga yamba-yamba muru-ban, bubu and bayan bawan, janawunbuku bubunguku dungarinka baja. Jana townbu Jerusalem kadarin, jana startman, Godumu bayan ngaranka baja. ");
INSERT INTO gvn_vpl VALUES ("ER4_1","016_4_1","EZR","4","1","5","Kanbal bama bubumun yindu-yindumun bubungu Judah bundandarin, jana Israel-warranka wawu kari. Jana Israel-warranda dungarin, jurril balkan, yalaman, “Nganjin yurranga God yalarrku buyay-manil. Nganjin yurranda mara dajinka, Godumu bayan ngaranka baja.” Yamba Israel-warrangka yalaman, “Kari, nganjin yurrawunku helpmunku wawu kari. Kingangka nganjininku yungan, ngaranka, yurranin kari.” Yinyamun jana bama bubungu Judah bundandarin, jana jananin Israel-warra kirinka, Godumu bayan ngaranka baja. ");
INSERT INTO gvn_vpl VALUES ("ER7_1","016_7_1","EZR","7","1","7","Kanbal bama Israel-warra kariku bubunguku Judahku kadan baja Babyloniamun. Nyubun bama priest burri Ezra bubunguku Babyloniaku. Nyulu bama kunjan, murumarinka, jana yalarrku bubunguku Judahku dungarinka baja. Kingangka jananin yalarrku yungan, yala jananin Israel-warra yindu-yindu jakalbaku. ");
INSERT INTO gvn_vpl VALUES ("ER9_1","016_9_1","EZR","9","1","1","(9.1-10.12) Yamba jana townbu Jerusalem kadarin, nyulu Ezrangka kuku nyajin jana bama jakalbaku kadarin, jana manyarr bubumun yindu-yindumun wunan, Israel-warra kari. Yinyaynka Ezrangka jananin murru-kangan, yalaman, “Yurra bamangka jalbu-jalbu bubumun yindu-yindumun wunan, yurra Godumu law kari bajaku wukurrin. Yurra ngami-ngamimaka janandamun ngarrbalandamun. Kari wunay baja jalbu-jalbu bubumun yindu-yindumun.” Jana Israel-warrangka yalaman, “Yuwu, yundu kuku junkay balkan. Nganjin yinya kuku wukurrilkuda.” ");
INSERT INTO gvn_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","1","(1.1-2.10) Kanbal Israel-warra still bubunguku Babyloniaku bundandan. Nyubun bama burri Nehemiah kinganda dungan, babajin jananin Israel-warra bubunguku Judahku yunganka. Kingangka jananin yungan Nehemiahnji. ");
INSERT INTO gvn_vpl VALUES ("NH2_11","017_2_11","NEH","2","11","11","(2.11-6.16) Jana townbu Jerusalem kadarin, Nehemiahngka nyajin walls townbu kariku ngulkurr-bungajin. Walls yiringkurrku dumbarrijin. Yinyaynka Nehemiahngka bama kunjan, muru-bunganka. Nyulu bamanda yalaman, “Ngana walls ngaranka baja.” Yinyamun jana startman ngaranka, yamba kanbalangka ngarrbalangka jananin Israel-warra kirinka, walls ngulkurr-bunganka baja. Jana Nehemiah Godundu praymanda, Godungku jananin helpim-bunganka, walls ngaranka baja. Nehemiahngka workingmananda kalka, bow and arrow dajin. Nyulu yalaman, “Kaki jana kuli-baka kaday, ngana kuniway, jana nganangan kari kirinka walls ngulkurr-bunganka baja.” Kanbal miyilji bundan, kanbal workmanijin. Yalaku jana walls townbu Jerusalem kunbay-manin, Godungku jananin helpim-bunganya. ");
INSERT INTO gvn_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","(8.1-10.29) Juma jana Israel-warra wubulku janawunbuku bayanba bundandan bubungu Judah. Yinyamun jana wubulku murumarin townbu Jerusalem. Yinyaymba jana Ezranda babajin Godumu kuku readim-bunganka, jana nyajinka. Godungku ngadiku yinya kuku law Mosesanda dajin, Mosesangka kabanba balkan. Ezrangka kaban law manin, bamanda wubulbuku readim-ban. Nyulu yalibalaku startmanijin, kunbay-manin wungar jarra-jarra. Yinyamun jana buyun-buyunku mala-yirrkan Godundu, God promiseim-ban nyungu kuku wukurrinka. ");
INSERT INTO gvn_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","5","Ngadi bajaku nyubun bama burri Job bubungu yinduymbu bundandan. Nyulu God buyay-maninya, junkaynjaku wukurrinya. Nyulu dingkar ngulkurr, buyun-buyun kari wukurrinya. Nyungu kangkal-kangkal dingkar-dingkar 7-bala, jalbu-jalbu kulur. Nyulu rich-bala bajaku, nyungu bulki wubul, minya sheep wubul, camel wubul, donkey wubul. Nyungu workingman wubul bajaku, nyulu rich-bala bajaku. Kangkal-kangkal murumarinya, mayi jirray nukanya. Wawu mayimun, Jobungku bulki kuninya, wayjunyu altermunbu, Godundu dajinka, buyay-maninka. Nyulu Godundu babajinya, kangkal-kangkalandamun buyun-buyun kidanka. ");
INSERT INTO gvn_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","12","Juma God jiringa Dubunji Satananji balkawan, nyulu yalaman, “Yala, yundu ngayku bama Job nyajin? Bama yamba-kari yala nyulu, buyun-buyunku junkurrji. Nyulu ngaykundu milka-jananya, buyun-buyun kari wukurrinya.” Dubungku Godundu yalaman, “Job yunundu milka-janay because yundu nyungun ngulkurrduku kujinya, yamba-yamba and minya jirray dajinya. Kari. Junjuy-junjuy wubulku nyungundumun mana. Yinyamun nyulu yunun yukil.” Godungku Dubundu yalaman, “Yalada. Ngayu yunu junkurr dajil, nyungundumun junjuy-junjuy maninka, yamba yundu nyungun bangkarr kari buyun-dama.” ");
INSERT INTO gvn_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","19","Wawu yinyamun Dubungku Jobumu kangkal-kangkal, minya-minya, yamba-yamba, junjuy-junjuy wubulku buyun-daman. Nyubun kukuji Jobundu kadan, yalaman, “Nganjin farmmunbu workmalman, jana bama ngarrbal kadarin, cheeky-bala. Jana yunu bulki wubulku and donkey wubulku ngakin.” Yindu kukuji kadanda, Jobundu yalaman, “Jarramalibu minya sheep and shepherds dalbarrin, yarkin-ban. Ngayurrku bawajinda juranku.” Yindu workingman kadanda, yalaman, “Bama ngarrbal kadarin, cheeky-bala, nganjinanji kuniwan, yarkin-ban, camel wubulku ngakin. Ngayurrku juranku bawajin, jinbalku kukuji yunundu kadanka.” Nyulu kukuji kunbanjiku, yindu workingman kukuji kadan, yalaman, “Yunu kangkal-kangkal mayinga nukan-nukajin, balbay, jarramali, muyar jirray kadan, bayan daray-manin, wubulku yarkin-bungan. Ngayurrku juranku bawajin.” ");
INSERT INTO gvn_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","22","Jobungku yinya kuku nyajin, nyulu janan, kambi dumbarrin, milka-bujarman. Jana yalaku, milka-bujarmal, jana kambi dumbarril. Nyulu bubungu daran, yirrkan, Godundu yalaman, “Ngayu yalaku balkajin yamba-yamba, junjuy-junjuy yamba-kari. Ngayu yalarrku wulay, junjuy-junjuy yamba-kari. Godungkuku dajin, nyuluku manin baja. Ngayu Godundu milka-janay, nyungun buyay-manil.” Jobumu junjuy-junjuy yamba-kariman, nyungu kangkal-kangkal wularin. Yamba nyulu God kari nyuyan, nyungun kari buyun-daman. ");
INSERT INTO gvn_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","6","Wawu yinyamun Godungku Dubundu yalaman baja, “Yala yundu ngayku bama Job nyajin? Bama yindu yamba-kari yala nyulu, buyun-buyunku junkurrji. Nyulu ngaykundu milka-jananya, buyun-buyun kari wukurrinya. Yundu nganya balkan yunun yunganka, nyungun wumbabuku buyun-damanka, yamba nyulu still junkurrji buyun-buyunku, kari buyun-daman.” Dubungku Godundu yalaman, “Bama janawunku yamba-yambaka kari worry-balamal. Yamba yundu jananin bangkarr buyun-damal, jana yunun yukilda. Kaki yundu Job bangkarr buyun-damal, nyulu yunun yukilkuda.” Godungku Dubundu yalaman, “Yalada, ngayu yunundu junkurr dajil, nyungu bangkarr buyun-damanka, yamba nyungun kari yarkin-bunga.” ");
INSERT INTO gvn_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","10","Dubungku God bawan, Job bambay-bungan. Baji balamu balkajin Jobundu bangkarrba. Job dungan, burrkun balamumun yurrin. Nyunguwundu manyarrangka nyungundu yalaman, “Godungku yunun buyun-daman, yundu wanyurrinku nyungun wukurril-wukurril? Nyungun yuki, wulayda.” Jobungku manyarranda yalaman, “Yundu kuku kiru-kariku balkan-balkaway. Kaki Godungku ngananda ngulkurr dajil, ngana wawurr-wawurrmal, yinyarrin ngulkurr manilda. Kaki nyulu buyun dajil, ngana nyungun kari buyun-dama, kari yuki.” Job warrngkal-warrngkan, yamba nyulu God kari buyun-daman. ");
INSERT INTO gvn_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","13","Jobundumundu jawunyungku kulurungku kuku nyajin Job warrngkan-warrngkanya. Jana nyungundu kadarin, kuku ngulkurr nyungundu balkanka. Jana kala-kalbaymun nyungun nyajin bundandanya, yamba jana nyungunku binal kari. Jana yuba kadan, jana nyungun nyajin, yayji bajaku. Jana jiba-badirin Jobunku, kambi dumbarrin, badirin. Jana nyungunji bubungu bundan warngku 7-bala. Jana kuku-karimarin, nyulu warrngkan-warrngkanya. ");
INSERT INTO gvn_vpl VALUES ("JB19_25","019_19_25","JOB","19","25","27","Job balu wulan, milka-bujarmanya, yamba nyulu yalaman, “Ngayu binal Godunku jiringa, nyulu ngaykunku wawu, nganya ngulkurrduku kujin-kujil. Ngayu binal ngayu juma God nyajilkuda. Ngayu juma nyungun nyajil ngaykuwunduku miyildaku, nyulu ngarrbal kari.” Jakalbaku Job bulmbuyman, yamba God nyungunji balkawan. Yinyamun Job nyuluku buban-bungajin, kari bulmbuyman baja Godundumunbu miyilbaku. Yinyaynka Godungku Job wawurr-wawurr-bungan, nyungundu kangkal-kangkal yindu-yindu dajin baja, dingkar-dingkar 7-bala, jalbu-jalbu kulur. Godungku Jobumu yalarrku junjuy-junjuy jirray dajin baja. ");
INSERT INTO gvn_vpl VALUES ("IS1_1","024_1_1","ISA","1","1","1","Jana kings and Israel-warra bubungu Judah buyunman Godundumunbu miyilba. Yinyaynka Godungku prophet Isaiah jananda yungan. Isaiahngka kabanba balkan, wanjarrku Godungku nyungun kunjan. ");
INSERT INTO gvn_vpl VALUES ("IS1_2","024_1_2","ISA","1","2","3","Israel-warra dukul-dandimanya, Isaiahngka jananda yalaman, “Godungku yalaman, ‘Bubu and jiri, yubal ngaykundu milka-janay. Yarrkay-yarrka ngayu jirray-bungan, jana ngaykundumun jurrkijirin. Yarraman and donkey janawunku majanka binalmal, yamba ngayku bama ngaykunku binal kari. Jana wanyurrinku ngaykunku wawu kari?’” ");
INSERT INTO gvn_vpl VALUES ("IS1_15","024_1_15","ISA","1","15","19","Isaiahngka bamanda wubulbuku balkan, “Godungku yalaman, ‘Yurra buyun-buyun wukurril, yinyamun yurra mara wangkar-bungal, ngaykundu praymanka. Kari. Ngayu yurranda kari milka-janay, yurranga mara yala mulabu kanbin, malajikuda. Ngayu yurranga wawu nyajil. Yurranga wawu, dukurr yala mula-mula, milbinka yurra yarbarrka buyun-damal-damanya. Jurrkijika buyun-buyunmun, ngaykundu mambarrijika. Buyun-buyundu yurranga wawu mula-mula-bungan, yamba ngayu dayirr-bungal yala kambi bingaji bajaku. Kaki yurra ngaykundu milka-janay, and nganya wukurril, ngayu yurranin ngulkurrduku kujil. Kaki yurra nganya bayjal and ngaykunku wawu kari, yurra wulari.’” Yinya kuku Godumu Isaiahngka balkan Israel-warranda. ");
INSERT INTO gvn_vpl VALUES ("IS3_16","024_3_16","ISA","3","16","22","Isaiahngka jalbu-jalbundu yalaman, “Godungku yalaman, ‘Yurra kambi flash-bala and jewelry flash-bala didal, bulmbuy bajaku. Yamba yurra nganya bayjal.’” ");
INSERT INTO gvn_vpl VALUES ("IS5_8","024_5_8","ISA","5","8","8","Isaiahngka Israel-warranda yalaman, “Yurra bayan jirray ngaral, yamba juma yinya bayan maru-marumal.” ");
INSERT INTO gvn_vpl VALUES ("IS5_11","024_5_11","ISA","5","11","14","Isaiahngka Israel-warranda yalaman, “Yurra yalibalaku wandil, kamu-kamu nukanka, wujurrdurr yurra drunkmal. Yurra mayi jirray nukal, dancemaniji, kamu-kamumun burra-warri. Yurra ngaykunku binal kari. Yinyaynka jana kuli-bakangka yurranin karrbal, prisoner-bungal, janawunbu bubungu wundil.” ");
INSERT INTO gvn_vpl VALUES ("IS5_23","024_5_23","ISA","5","23","23","Isaiahngka Israel-warranda maja-majanda Godumu kuku balkan, yalaman, “Yurra money manil, kuku jurril balkanka, bama buyun-damanka courtcasemunbu. God yinyaynka wawu kari bajaku.” ");
INSERT INTO gvn_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","10","Isaiahngka yalaku kabanba balkan, “King Uzziah wulan. Yinyamun ngayu Maja God nyajin. Nyulu nyunguwunbu chairnga yalbaymba bundandan, bayanba nyunguwunbu. Angel walu-yindu walu-yindu nyungundurr janjanan. Yinyarrinyanga angelanga nangki 6-bala. Jana nangkibu jambuldu walu nandajin, nangkibu jambuldu bangkarr nandajin, nangkiji jambulji flyman. Jana yirrkan, yalaman, ‘Maja God junkurrji bajaku, dayirr bajaku. Nyungu light jirray bubungu yiringkurrku.’ Janawundu bulubu Godumu bayan bulngan, kububu bayan kanbin. Ngayu yinya nyajin, ngayu yalaman, ‘Ngayu buyun bajaku. Ngayu bama bajaku, ngayku jawun-karra bama bajaku, ngana wubulku buyun bajaku. Yamba ngayu ngaykuwunduku miyilda nyungun bajakuda nyajin, king. Nyulu Maja God junkurrji bajaku.’ Yinyamun nyubun angel ngaykundu flyman, ngunjil wundin. Nyulu ngunjil ngaykuwunbu yimbinga yijarrin, manin baja, yalaman, ‘Yundu malaji karida, yunu buyun-buyun kidanda.’ Yinyamun ngayu Maja God nyajin balkanya, ‘Wanya dungay, ngayku kuku yirrkanka?’ Ngayu yalaman, ‘Ngayuku dungay, nganya yunga.’ Yinyamun nyulu ngaykundu yalaman, ‘Yundu dungayda, bamanda yanyu kuku balka, “Yurra Godundumun jurrkijin, nyungunku wawu-kariman. Yinyaynka yurra milkabu nyajil, yamba yurra kari binalmal. Yurra miyilda nyajil, yamba yurra ngangkal-ngangkalku bundari.” ’ Godungku ngaykundu yalaman baja, ‘Kaki yundu ngayku kuku jananda yirrkay, jana yala milka-karimal, yala miyil-burramal. Yinyaynka jana kari binalmal. Jana binalmanyaku, jana ngaykundu jurrkijinyaku, jananga buyun-buyun kidanyaku.’ Godungku yalaku balkan ngaykundu.” ");
INSERT INTO gvn_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","6","Godungku Isaiahnda nyungu kuku dajin bamanka Godundumun juma kadanka. Nyulu bama Godundumun kariku balkajin, yamba Isaiahngka yalaman, “Nyulu juma balkaji.” Nyulu yalaman, “Bama nguwul-nguwulbu bundanday, jana light jirray nyajil. Jana nguwul-nguwulbu bundanday, yamba lightmundu jananin balbalda. Yala-yala bama Godundumun balkaji, bamangka balkal, ‘Ngawa balkajin ngananka. Godungku ngawa dingkar dajin ngananga. Nyulu ngawa ngananka majamal. Nyulu ngulkurr bajaku. Nyulu ngananda kuku ngulkurr dajil. Nyulu Maja God junkurrji. Nyulu ngananga nganjan wuljaljiku, ngananga wawu ngulkurr-bungal, ngana junkayku bundanka.’” ");
INSERT INTO gvn_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","6","God wawu bama binalmanka bamanka Godundumun. Yinyayangka bamangka buyun-buyun kidanka bamandamun wawumun. Yinyaynka Godungku Isaiahnda balkan yanyu kuku kabanba balkanka. “Ngana warrngkanyaku, ngana buyunmanya, yamba nyulu bama Godundumun warrngkan ngananka. Ngana balu nyajin Godungku nyungun punishim-bunganya, nyulu buyunmanya. Kari. Godungku nyungun punishim-bungan, Godungku nganangan kari punishim-bunganka. Nyulu ngananga place takeim-bungan. Ngana wulanyaku, yamba nyulu ngananka wulan. Nganawundu buyun-buyundu nyungun warrngkay-manin. Jana nyungun yarkinkaku kunin nganawunku buyun-buyunku. Nyulu warrngkanya, ngananga wawu ngulkurrman. Ngana nganangaku way wukurrinya, ngana wubulku nubijin yala minya sheep. Yamba Majangka Godungku yinya bama punishim-bungan nganawunku buyun-buyunku. Godungku ngananin punishim-bunganyaku, yamba nyulu yinya bama punishim-ban, nganangan kari.” Godungku prophet-prophet kukuji yungan baja, yungan baja Israel-warranda, jananin milka-bakanka janawunku buyun-buyunku, yamba jana Israel-warrangka God bayjan, yindu-yindu gods wukurrin. Jana prophet-prophetangka Israel-warra milka-bakan, yalaman, “Juma Godungku yurranin punishim-bal, bama kuli-baka yurranda yungal. Yamba yurra nyungundu kari milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("JR25_8","025_25_8","JER","25","8","11","Ngadiku nyulu prophet Jeremiah Godumu kuku yirrkan, yalaman, “Yurra Israel-warra! Jana Babylonia-warrangka yurranin karrbal, janawunbu bubungu wundil, yurra Godundu kari milka-jananya. Yurra yinyaymba bunday 70 yearmunku. Wawu 70 yearsmun, ngayu yurranin wundil baja yurrawunbuku bubunguku.” ");
INSERT INTO gvn_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","2","Nyulu king bubuku Babylonianka, nyulu bijarr bijarrin. Nyulu milka-jalkinba wunanda, wawu-dudajin bijarrka. Yinyaynka nyulu mari-doctor kunjan, jana nyungundu milkanga-bunganka bijarr. ");
INSERT INTO gvn_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","13","Jana nyungundu kadan, kingangka yalaman, “Ngayu wawu-dudaji bijarrka. Ngayu wawu yurra ngaykundu balkanka yinya bijarr ngayu bijarrin.” Jana mari-doctorangka yalaman, “Yalada, king, yundu nganjinanda balka wanyu yundu bijarrin. Yinyamun nganjin explainim-bungal.” Yamba kingangka yalaman, “Kari. Ngayu kari balkal yinya bijarr ngayu bijarrin. Yurraku ngaykundu balka yinya bijarr. Yinyamun bijarr explainim-bunga. Kaki yurra murruji bijarr explainim-bungal, ngayu yurranin yaykarrdaku buyun-damal, yarkin-bungal. Kaki yurra bijarr explainim-bungal, ngayu yurranda money and yamba-yamba jirray dajil.” Jana mari-doctorangka yalaman baja, “Maja king, yundu balka yinya bijarr yundu bijarrin, yinyamun nganjin explainim-bal.” King kuli-kadanda, yalaman, “Yurra majarr bajaku, jurril bajaku. Kaki yurra ngaykundu balkal yinya bijarr, ngayu binalda yurra yalarrku explainim-bal.” Mari-doctorangka yalaman, “Bama binal kari. Nganjin bama bajaku, God kari. Nganjin yunundu yinya bijarr can't balkal.” Yinyamun nyulu king kuli-kadan bajaku, yalaman, “Yurra mari-doctor and council-council, yurra wubulku wularikuda.” Kingangka Daniel yalarrku yarkin-banka, because nyulu councilmunbu too. ");
INSERT INTO gvn_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","19","Danielangka yinya kuku nyajin, nyulu majanda soldier-soldierankaku dungan, babajin, “Nyulu kingangka wanyurrinku nganjinan yarkinkaku kuninka?” Majangka Danielanda kuku balkan kingandamunku bijarrka. Daniel kinganda dungan, yalaman, “Yundu ngaykundu buban time daya. Yinyamun ngayu bijarr milkanga-bungal yunundu.” Daniel bayanbaku dungan, jawun-karranda yalaman, “Yurra, Godundu praymaka, babajika nyulu nganya binal-bunganka kingandamunku bijarrka. Ngayu kinganda balkal, nyulu ngananin kari yarkinkaku kuninka.” Wujurrbu God nguwimal milbijin Danielanda, nyungun binal-bungan kingandamunku bijarrka. ");
INSERT INTO gvn_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","45","Daniel kinganda dungan, yalaman, “Ngayku God jiringa. Nyulu junjuy-junjuynku wubulkuku binalkuda. Nyulu yunu bijarr milkanga-bungan ngaykundu. Ngayu yunundu milkanga-bungalda. Yundu bubu 4-bala bijarrin. Bama bubungu nyubunyimba junkurrjiman. Yinyarrin bama yunuwunbu bubungu, jana junkurrji bajaku. Yamba juma jana bama kari junkurrjiku bunday baja. Yinyamun bama yindumun bubumun jarra buban junkurrjimal. Yamba jana juma kari junkurrjiku bunday baja, yinyamun bama yindumun bubumun jarra buban junkurrjimal. Yinyamun jana kari junkurrjiku bunday baja, bama yindumun bubumun jarra buban junkurrjimalda. Jana juma kari junkurrjiku bunday baja. Wawu yinyarrinmun bubumun 4-balamun God majamalkuda. Nyulu wubulkuku majamal, bubuku yindu-yinduynku, bamanka wubuliynkaku. Nyulu wuljaljiku majamal, kari kunbay. Nyulu jananin kuli-baka buyun-damal, bamangka wubuliynjaku nyungun bambalda, Maja.” ");
INSERT INTO gvn_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","48","Nyulu kingangka yinya kuku nyajin bijarrka, nyulu Danielanda yalaman, “Yunu God junkurrji bajaku kanbalanka godunku. Nyulu junjuy-junjuynku wubulkuku binalkuda.” Yinyamun kingangka Danielanda presents dajin, nyungun maja jirray-bungan bubuku Babyloniamunku. ");
INSERT INTO gvn_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","6","Nyulu king bubuku Babyloniamunku, nyulu ngurma idol statue balkan. Yinya statue kalbali bajaku, 27 metres. Yinyamun kingangka nyungu maja-maja wubulku kunjan yiringkurrmun bubumun. Jana wubulku jakalba ngurmanga janan. Nyulu kingangka yalamanda, “Yurra bama yiringkurrmun, yurra wulngku music nyajil, ngayu wawu yurra wubulku badamanka jakalba ngurmanga, nyungun buyay-maninka. Kaki yurra kari badamal, jana yurranin bayanga yilbal.” ");
INSERT INTO gvn_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","12","Kanbal Babylonia-warra jananka Israel-warranka wawu kari. Jana nyajin Danielamu jawun kulur kari badaman jakalba ngurmanga. Yinyaynka jana kuli-baka kinganda dungan, yalaman, “Maja king, yundu bamanda balkan jana wubulku must badamaka jakalba ngurmanga, nyungun buyay-maninka. Kaki jana kari badamal, yundu jananin bayanga yilbal. Kulur dingkar-dingkar Israel-warra kari badaman jakalba yunuwunbu ngurmanga. Jana yunu kuku kari wukurrin, ngurma kari buyay-manin.” ");
INSERT INTO gvn_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","18","Kingangka yinya kuku nyajin, nyulu kuli-kadan bajaku. Nyulu yalaman, “Yurra jananin dingkar-dingkar kulur ngaykundu wundi.” Jana kuli-bakangka jananin kulur Israel-warra jakalba kinganda janay-manin, nyulu jananda yalaman, “Ngayu kuku nyajin yurra ngaykuwunbu ngurmanga kari badaman, kari buyay-manin. Ngayu yurranda yindu chance dajil badamanka. Yurra wulngku music nyajil, yurra badamaka, ngurma statue buyay-mana. Kaki yurra kari badamal, ngayu yurranin bayanga jirraymba yilbal. Yurrawundu Godungku yurranin kari juran-bal bayamun.” Jana Israel-warrangka kinganda yalaman, “Maja king, nganjin kari warmbiji yinyaynka kukuku. Nganjinandamundu Godungku nganjinin nguba juran-bungal bayamun, nguba kari. Kaki nyulu wawubu, nyulu nganjinin juran-bungalkuda. Yamba yundu binalmaka, nganjin kari bajaku yunu ngurma buyay-manil.” ");
INSERT INTO gvn_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","23","Yinyamun kingamu walu walu-yindurrmanyarrku, kuliji jananka Israel-warranka kuluruku. Nyulu workingmananda yalaman, “Yurra, baya jirray bajaku wayju, wumbul-bungarrku.” Yinyamun workingmanangka jananin Israel-warra karrabu kajan, bayanga yilban. Yinyangka bayabu wumbuldu jananin workingman wayjun, yarkin-banyarrku, wumbul bajaku. Jana Israel-warra karrajiku bayanga daran. ");
INSERT INTO gvn_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","25","Nyulu kingangka baya kunkun-bungan; kari, nyulu kungkurr-kadan. Nyulu bama 4-bala nyajin bayaburr jinabu dungan-dunganya! Nyulu workingmananda babajin, “Ngana dingkar-dingkar kulurku bayanga yilban. Wanyurrinku ngayu bama 4-bala nyajilda? Jana kari karrajiku bundandayda, kari wayjul-wayjujida. Nyubun bama yala God.” ");
INSERT INTO gvn_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","30","Yinyamun nyulu king bayanga dungan, jananda Israel-warranda kulurundu yirrkan, “Ya, yurra bama Godumu, yurra bayamun wandida!” Jana jinbalku wandinda. Jana maja-maja and kingumu workingman wubulku murumarin, jananin bama kulur biku-nyajinka. Jananga kulurumu mungka and kambi kari wayjujin. Kubu kari nyumajin janawunbu kambinga. Kingangka yalaman, “Janawundu Godungku angel yungan, jananin juran-bunganka bayamun, jana Godku wukurrinya, nyungunku buyay-maninya. Janangaku Godku junkurrji.” Nyulu kingangka jananin bama kulur maja jirray-bunganda. ");
INSERT INTO gvn_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","4","Juma yinya king wulan, yindu bama kingmanda bubuku Babyloniamunku. Nyulu kingangka mayi jirray wayjun, partyka. Nyulu bama rich-bala wubul bajaku kunjan, 1000-bala. Nyulu workingmananda balkan dishes gold-ones wundinka, yinyarrinmun dishmun kamu-kamu nukanka. Ngadiku Babylonia-warrangka yinyarrin dish ngakin Godundumun bayanmun townbu Jerusalem. ");
INSERT INTO gvn_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","8","Jana party jirray haveim-bal-ban. Kari, jinbalku bamamu mara nguwimalman, kuku wallmunbu writeim-bunganya, yamba jana binal kari yinyaynka kukuku. Nyulu kingangka yinya mara nyajin kuku wallmunbu writeim-bal-banya, nyulu yinyilman, bungku yararrin. Nyulu yirrkan, “Jinbal, jananin mari-doctor kunja.” Jana mari-doctor kadarin, kingangka jananda yalaman, “Kaki bamangka yinya kuku readim-bal, and ngaykundu milkanga-bungal, ngayu nyungundu present jirray dajil, nyungun maja jirray-bungal.” Yamba jana mari-doctorangka yinya kuku murruji readim-ban, murruji milkanga-bungan. Yinyaynka nyulu king yinyilmanyarrkuda. Jana binal kari, wanjarrmanka baja. ");
INSERT INTO gvn_vpl VALUES ("DN5_10","028_5_10","DAN","5","10","12","Nyulu king jarra warruku. Yinyaynka nyulu kuku kariku nyajin Danielanka. Yamba nyunguwundu ngamungku kinganda yalaman, “Ngadiku yunuwundu nganjanangka nyubun bama burri Daniel wundin bubumun Judahmun. Nyulu Daniel maja-bungan, Danielangka bijarr milkanga-bunganya. Nyungun Daniel kunja, nyulu yinya kuku milkanga-bungal.” ");
INSERT INTO gvn_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","29","Jana Daniel jinbaldaku kinganda wundin partynga. Danielangka kinganda kuku milkanga-bungan, yalaman, “Yinya kuku yalaku: Godungku yunun kirin kingmanka baja. Yundu kunbayda. Nyulu bama yindu king-bungal bubumun yindumun.” Nyulu kingangka Danielanda presents dajinda, nyungun maja jirray-bungan. ");
INSERT INTO gvn_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","31","Mudu-wayjul-wayjunjiku yinya king wulan. Jana nyungun yarkinkaku kunin. Yindu king bubumun Persiamun kingman bubuku Babyloniamunku. ");
INSERT INTO gvn_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","3","Nyulu king jirakal muruman nyunguwunji maja-majanji. Nyulu maja-maja 120-bala wangkanyin, majamanka bubuku yindu-yinduynku yala shiresmunku. Nyulu 3-bala maja-bungan jananka kanbalanka maja-majanka, nyubun maja Daniel. Nyulu Daniel dukul-ngulkurr bajaku. Yinyanka kingangka nyuluku yalaman, “Ngayu juma Daniel maja jirray-bungal bubuku yiringkurrku.” ");
INSERT INTO gvn_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","9","Yamba jana maja-majangka kanbalda ngura-nyajin Daniel. Jana jana-karrajiku balkawan, yalaman, “Ngana king mambarril Daniel buyun-damanka.” Yinyaynka jana kinganda dungan, yalaman, “Maja king, nganjin maja-maja wubulku wawu yundu kabanba balkanka bama must yununduku kaday, junjuynku babajinka. Jana kija nyubun yinduymbu bamanda, or Godundu kari babajika junjuynku. Kaki jana yinduymbu babaji, yundu jananin lionanda kulijinda yilba. Kaki yundu yalaku kabanba balkal, bamangka or maja-majangka or kingangka kari bajaku yinya law walu-yindu-bunga.” Nyulu kingangka kabanba balkan, yinya kuku lawman. ");
INSERT INTO gvn_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","Daniel binalman yinyaynka kabanka, nyulu bayanbaku dungan. Nyulu wangkar dakan bayanba, windownguku bungkubu janan, Godundu prayman yala jakalbaku. Nyulu yalaku, 3 times a day Godunji balkawan. Nyulu windowngu bundanya, bamangka nyungun nyajin. ");
INSERT INTO gvn_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","13","Jana maja-majangka nyungun nyajin Godundu praymanya, jana jinbalku kinganda warririn, yalaman, “Maja king, yundu kabanba law balkan bama yununduku junjuynku must babajika. Kaki bamangka yinya law dumbarril, yundu nyungun lionanda yilbal.” Kingangka yalaman, “Yuwu, ngayu yinya law kabanba balkan, yinya law ngana murruji walu-yindu-bungal.” Yinyamun jana maja-majangka kinganda yalaman, “Nyulu Danielangka yunu law kari wukurrin-wukurril. Nyulu Godundu praymanya yalibalaku, wungar jarr-jarra, yilay-yilay.” ");
INSERT INTO gvn_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","15","Nyulu king milka-bujarmanda. Nyulu wawu kari Daniel lionanda kulijinda yilbanka. Nyulu wungar-kalbay milkabu wukurrin wanjarrku Daniel lionandamun juran-bunganka. Yamba yilay-yilayman jana maja-maja kadarin baja, nyungun king mambarrin Daniel lionanda yilbanka. Kingangka yinya law jakalbaku kabanba balkanya, nyulu can't yinya law walu-yindu-bungal. Jana must Daniel lionanda yilba, Danielangka law dumbarrinya, Godunji balkawanya. ");
INSERT INTO gvn_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","18","Jana Daniel karrban, jankungu yilban lionanda wubulbu. King Danielanda yirrkan, yalaman, “Nguba yunuwundu Godungku yununin juran-bungal janandamun lionandamun.” Yinyamun nyulu king bayanbaku dungan, yamba nyulu kari warngku wunan, wawu-buyunku bundan. ");
INSERT INTO gvn_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","23","Nyulu king warngku yindu yalibalaku jankungu warrin, Danielanda yirrkan. Nyulu babajin, “Daniel, yundu yalada? Kuda yunuwundu Godungku yunun juran-bungan janandamun lionandamun?” Danielangka yalaman, “Maja king, Godungku nyungu angel yungan, nganya juran-bunganka. Nyulu jananin lion minday-bungan, nganya kari baykanka. God binal ngayu malaji kari, yunun kari buyun-daman. Yinyaynka nyulu jananin lion minday-bungan.” Nyulu king wawurr-wawurrman, workingmananda balkan Daniel wangkar-wangkar kulbanka. Jana kulban, nyajin Daniel yalada, nyulu Godundu milka-jananya. ");
INSERT INTO gvn_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","Yinyamun kingangka bulimananda balkan jananin maja-maja kuli-baka karrbanka. Bulimanangka maja-maja kuli-baka, jananga manyarr-karra, kangkal-kangkal wubulku karrban, jankungu yilban lion-lionanda. Jana lionangka jananin bama jinbaldaku karrban, bajibay dumbarrin, nukankuda. ");
INSERT INTO gvn_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","27","Wawu yinyamun kingangka kaban yungan yiringkurrku nyunguwunbu bubungu. Nyulu kabanba balkan, “Yurra bama! Ngayu wawu bama yiringkurrku Danielamu God buyay-maninka, nyungundu milka-jananka. Nyulu God juranku bundanday. Nyulu nyungu bama ngulkurrduku kujil, junjuy-junjuy miracle balkal jiringa and bubungu. Nyulu Daniel juran-bungan janandamun lionandamun.” ");
INSERT INTO gvn_vpl VALUES ("JH1_1","033_1_1","JON","1","1","2","Nyubun bama burri Jonah. Godungku nyungundu balkan, “Yundu yinduymbu townbu yalbaymba dungay, townbu yalbaymba burri Nineveh, jananda balka, ‘Yurra bama buyun bajaku, Godungku yurranin punishim-bungalkuda, yurra buyun-damanya. God binal yurranka. Nyulu yurranin nyajin buyun-buyun-damanya.’ Yinya kuku yalaku balka jananda Nineveh-warranda.” ");
INSERT INTO gvn_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Yamba Jonahngka God kari kuku-nyajin. Nyulu kuwa townbu Nineveh kari dungan; kari, nyulu jurrkijin, naka-naka jalunburr dunganka, ngakijinka Godundumun. Nyulu bada townbu Joppa dungan, boat warrmba-bungan, naka-naka bubungu Spain dunganka. Nyulu money dajin, ticket manin, boatbu dakan, kala-kalbayku ngakijinka Godundumun. ");
INSERT INTO gvn_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5a","Yamba nyulu murruji ngakijin Godundumun. Godungku muyar jirray jalunbu yungan. Muyarabu mulngku jirray yungan, jaba-jabaku, boat balu bujil-janjin. Jana sailor-sailor yinyilmarin, yirrkan janandamunbuku wubulimbaku godundu. Jana balu nyajin jananga god junkurrji, yala God bajaku. Jana yamba-yamba jalunbu yilban, boat burdal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("JH1_5b","033_1_5b","JON","1","5b","16","Yala, Jonah bada-bada warngku-kaja wunanan. Jana sailor-sailor balkawan, yalaman, “Ngana dice yilbanka, binalmanka wanya buyunman. Godungku muyar jirray ngananda yungan.” Jana dice yilban, binalmanda Jonah malaji. Jana nyungundu yalaman, “Balkada! Yanyu muyar yununku? Wanyurrinku yundu nganjinanji kadan? Yundu wanjamun? Bubu yunu wanjabu?” Jonahngka yalaman, “Ngayu Jew, Maja God heavenba ngayku God. Ngayu nyungunku wukurril. Nyuluku bubu, jalun ngadiku balkan.” Jonahngka jananda balkan nyulu ngakin-ngakijin Godundumun. Jana sailor-sailor yinyilmarin, nyungundu yalaman, “Yinya buyun bajaku!” Muyar, mulngku jirraymalman, jana sailor-sailorangka nyungundu babajin, “Nganjin wanjarrmal yunundu, Godungku jalun marrka-bunganka?” Jonahngka yalaman, “Nganya jalunbu yilba, jalun marrkamalkuda. Mulngku, muyar jirrayku wanarri, ngaykunku. Ngayuku kiru-kariman.” Yamba jana wawu kari Jonah yilbanka. Yinyaynka jana birungubaymunduku kulban baja, yaykarrdaku. Kari, muyar, mulngku jirraymalman baja, jana murruji birungubaymundu kulban. Jana Majanda Godundu yirrkanda, “God, nganjinin kari punishim-bunga, yanyu bama wulanya. Yunduku muyar yungan nyungunku.” Jana Jonah yilbankuda jalunbu, jalun jinbalku marrkaman. Marrkamanda, jana sailor-sailor yinyilmarin. Jana God promiseim-bungan jana nyungunkuda kuku-nyajil. ");
INSERT INTO gvn_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yala, Jonah wanjarrman jalunbu? Godungku kuyu yalbay yungan, Jonah yurmbinka. Jonah kuyundu waralba bundan warngku kulur. ");
INSERT INTO gvn_vpl VALUES ("JH2_1","033_2_1","JON","2","1","9","Waralba kuyundu Jonah Godundu balkawan. Nyulu yalaman, “Maja God, ngayu milka-bujarda, yunuwunbu kukungu kari milka-jananya. Ngayu yunundu yirrkay, yundu milka-janay ngaykundu. Yundu nganya yungan, bada-bada bajaku. Ngayu balu nyajin yundu nganya yunganyarrku, balu wulanyarrkuda; kari, ngayu juranku. Ngayu wulanjiku, ngayu yunundu yirrkan helpim-banka, yundu nganya kuku-nyajin. Ngayu yunun buyay-maninka, wulngku badinka yunundu. Ngayu balkalkuda, yala ngayu yununduku promiseim-bungan. Majangkaku Godungkuku juran-bungalarrku.” Jonahngka yalaku balkan Godundu. ");
INSERT INTO gvn_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Yinyamun Majangka Godungku kuyundu balkan Jonah kalji-maninka. Kuyungku Jonah kalji-manin, beachmunbuku. ");
INSERT INTO gvn_vpl VALUES ("JH3_1","033_3_1","JON","3","1","10","Godungku Jonahnda balkan baja, “Yundu yinyaymba townbu yalbaymba dungay, townbu Nineveh, jananda balka kuku ngayu yunundu jakalbaku dajin jananda balkanka.” Jonahngka God kuku-nyajin, townbu Ninevehda dungan. Town Nineveh yalbay bajaku. Kaki bama naka-naka townbu dunganka, nyulu warngku kulur jinabu dungan towndurr. Jonah warngku nyubun jinabu dungan, dungan, yilay-yilayman nyulu yirrkan, “40 daysmal Godungku yanyu town buyun-damalarrku, kunbay-manilarrku.” Jana Nineveh-warrangka yinya kuku Godundumun nyajin, believeim-ban. Jana jana-karrajiku balkawan mayi kari nukanka baja, kambi kurmunmun didanka, Godundu milbinka jana milka-bujarkuda buyunku, buyun-buyunmun jurrkijinka. Jana yalaku, mayi kari nukanya, kambi kurmunmun didanya, milbinka milka-bujarmankuda buyun-buyunku, buyun-buyunmun jurrkijinka. Nyubun bama king, maja jirray townku Ninevehnka. Nyulu Jonahmu kuku nyajin, kambi walngan, kambi kurmunmun didan, bundan nulungu. Jana yalaku, milka-bujarbuku milbinka buyun-buyunku. Nyulu kingangka kuku dajin Nineveh-warranda, “Bamangka kari bajaku mayi nuka. Bulki-bulkingka, sheep-sheepangka yalarrku kari nuka. Bamangka kambi kurmunmun dida. Wubuliynjaku Godundu manubajaku balka, jana buyun-buyunmun jurrkijinka, bama kanbal kari kuninka baja. Kaki bama buyun-buyunmun jurrkiji, God nguba kari kulimal baja ngananka, nguba ngananin kari buyun-damal.” Godungku jananin nyajinda buyun-buyunmun jurrkijinya. Yinyaynka nyulu jananin kari buyun-daman baja. ");
INSERT INTO gvn_vpl VALUES ("JH4_1","033_4_1","JON","4","1","4","Yamba Jonah kuli-kadan, wawu kari God manun-manunmanka jananka Nineveh-warranka. Nyulu Godundu yalaman, “Maja, ngayu ngayku bubu bawanjiku, ngayu binal yundu manun-manun, bamanka wawu jirray. Ngayu binal yundu bamanka waitmalmal yunundu jurrkijinka, yundu wawu kari bama punishim-bunganka. Ngayu binal, yinyaynka ngayu bubungu Spain ngakijinka. Maja, nganya wulay-mana. Ngayu wulanka, wawu kari juranku bundanka baja. Ngayu wawu kari Nineveh-warra nyajinka baja juran-juranku bundanya.” Majangka Godungku babajin, “Wanyurrinku yundu kuli-kaday?” ");
INSERT INTO gvn_vpl VALUES ("JH4_5","033_4_5","JON","4","5","6","Jonah kuwa ngalkalba townmun dungan, bundan. Nyulu bayan wabarrka ngaran, wabarrba bundan, waitmalman, nyajinka Godungku wanjarrmanka Nineveh-warranda. Yinya bubu wumbul bajaku. Godungku kalal jirray-bungan, Jonah wabarrba bundanka, bujarku bundanka wabarrba. Jonah wawurr-wawurrmanijin kalalka. ");
INSERT INTO gvn_vpl VALUES ("JH4_7","033_4_7","JON","4","7","11","Yamba warngku yindu Godungku mujurr yungan, yinya kalal nukanka, kalal wulay-maninka. Wungar dakan, Godungku muyar wumbul bajaku kuwamun yungan. Jonah walu-dungan-dungan wumbulmun, dukul wungara, wabarr yamba-karimun. Nyulu wawu-wulanka, bubu wumbul bajaku, yalaman, “Ngulkurr ngayu wulanka. Buyun juranku bundanka, wumbul bajaku.” Godungku nyungundu yalaman, “Wanyurrinku kuli-kaday kalalka?” Jonahngka yalaman, “Yinya buyun kari, kuli-kadanka kalalka. Kalal kari wulanyaku.” Godungku nyungundu yalaman, “Yanyu kalal warngku nyubun jirrayman, warngku yindu yamba-kariman. Yunduku karibi jirray-bungan, wanyurrinku kuli-kaday? Yundu yaluynku kalalka jiba-badi, kalal wulanya, yamba yundu Nineveh-warranka kari jiba-badi. Bama wubul bajaku townbu, yarrkay-yarrka yalarrku. Jana buyunmun jurrkijinya, ngayu jananka jiba-badi, jananin kari buyun-damalda,” Godungku yalaman. ");
INSERT INTO gvn_vpl VALUES ("HG1_8","038_1_8","HAG","1","8","8","Yamba nyubun bama burri Haggai, nyulu kuku Godundumun manin, balkan Israel-warranda. Nyulu yalaman, “Dungayda manjalba, timber mana, Godumu bayan kunbay-mana.” Jana Israel-warra dungan, Godumu bayan ngarankuda. ");
INSERT INTO gvn_vpl VALUES ("ML3_1","040_3_1","MAL","3","1","1","Prophetangka Malachiangka Godumu kuku bamanda balkan, juma wanjarrmanka. Nyulu yalaman, “Godungku balkan, ‘Ngayu juma ngayku bama kukuji yungal, baral yanday-bunganka ngaykunku. Yinyamun bama ngaykundumun, yurranga Maja nyunguwunbu bayanba kaday. Nyulu ngayku promise kujil, yurra nyajinka.’” ");
INSERT INTO gvn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yanyu kaban Jesus Christanka, nyunguwunku jawun-karranka ngadimunku. Jesus Christ, nyulu Davidandamun. David, nyulu Abrahamandamun. ");
INSERT INTO gvn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham nganjan Isaacanga; Isaac nganjan Jacobanga. Jacob nganjan Judahnga, nyunguwunbu yabaju-karranga. ");
INSERT INTO gvn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah nganjan Perezanga, Zerahnga; bulanga ngamu Tamar. Perez nganjan Hezronanga, Hezron nganjan Ramanga. ");
INSERT INTO gvn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram nganjan Amminadabanga. Amminadab nganjan Nahshonungu. Nahshon nganjan Salmonanga. ");
INSERT INTO gvn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon nganjan Boazanga. Boazanga ngamu Rahab. Boaz nganjan Obedanga; Obedanga ngamu Ruth. Obed nganjan Jessenga. ");
INSERT INTO gvn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse nganjan King Davidanga. Time Abrahamandamun Davidandarrku, dingkar-dingkar 14-bala nyubun-nyubunku yalakuda nganjan-karraman. Davidangka Uriahanga manyarr wunan; nyulu nganjan Solomonungu. ");
INSERT INTO gvn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon nganjan Rehoboamanga; Rehoboam nganjan Abijahnga; Abijah nganjan Asanga. ");
INSERT INTO gvn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nganjan Jehoshophatanga; Jehoshaphat nganjan Joramanga; Joram nganjan Uzziahnga. ");
INSERT INTO gvn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah nganjan Jothamanga; Jotham nganjan Ahazanga; Ahaz nganjan Hezekiahnga. ");
INSERT INTO gvn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah nganjan Manassehnga; Mannaseh nganjan Amonanga; Amon nganjan Josiahnga. ");
INSERT INTO gvn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah nganjan Jechoniahnga, nyunguwunbu yabaju-karranga. Yala-yala bama bubumun Babylonmun, jana bama Jew-warra karrban, wundin janawunbu bubungu, Babylon. Time Davidandamun Jechoniahndarrku, dingkar-dingkar 14-bala nyubun-nyubunku yalakuda nganjan-karraman. ");
INSERT INTO gvn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yinyamun Jechoniah nganjan Shealtielanga; Shealtiel nganjan Zerubbabelanga. ");
INSERT INTO gvn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel nganjan Abiudanga; Abiud nganjan Eliakimanga; Eliakim nganjan Azoranga. ");
INSERT INTO gvn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor nganjan Zadokanga; Zadok nganjan Achimanga; Achim nganjan Eliudanga. ");
INSERT INTO gvn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud nganjan Eleazarnga; Eleazar nganjan Matthananga. Matthan nganjan Jacobanga. ");
INSERT INTO gvn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob nganjan Josephanga. Joseph dunyu Marynga. Mary, nyulu ngamu Jesusanga. Jesus, nyulu Christ, nyulu kadan Godundumun. Time Jechoniahndamun Jesusandarrku, kangkal-kangkal 14-bala nyubun-nyubunku yalakuda balkajirin. ");
INSERT INTO gvn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Time Abrahamandamun Davidandarrku, kangkal-kangkal 14-bala yalakuda balkajirin. Juma kuli-bakangka Jew-warra wundin townbu Babylon. Time Davidandamun Babylonandarrku kangkal-kangkal 14-bala yalakuda balkajirin. Juma Jesus balkajin. Time Babylonmun Jesusandarrku kangkal-kangkal yalakuda 14-bala balkajirin. ");
INSERT INTO gvn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Christ yalaku balkajin. Nyungu ngamu burri Mary. Ngamungku, nganjanangka nyungun mambarrin dingkaranda burri Joseph. Bula wunanjiku, nyulu nyajijin, nyulu kulngkulman. Godundumundu Wawubu dayirrda nyungun kulngkul-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph ngulkurrku bundandan, junkayku. Nyulu wawu kari Mary buyun-damanka bamanka. Yinyaynka nyulu engagement kiraynjaku dumbarrinka. ");
INSERT INTO gvn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nyulu yinya milkabu wukurril-wukurrin, nyulu angel Majandamun Godundumun bijarrin. Angelangka yalaman Josephanda, “Joseph, yundu Davidandamun. Kari yinyilmaka Mary wunanka, manyarr-bunganka. Godundumundu Wawubu dayirrda nyungun kulngkul-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Marymu kangkal balkaji, dingkar. Nyungun burri dalki Jesus. Nyulu nyunguwunmun bamandamun buyun-buyun kidal, jananin juran-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Ngadiku nyubunyinja dingkarangka kuku manin Godundumun. Nyulu prophet. Nyulu balkan, “Nyubun jalbu, nyulu kariku wunan dingkaranji, yamba nyulu kulngkulmal. Nyulu kangkal manil, dingkar, nyulu kangkal burri Emmanuel.” Ngananga kuku yinya mean God ngananji.” Mary kulngkulman, yinya kuku manubajamankuda. ");
INSERT INTO gvn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nyulu Joseph wandin. Nyulu Mary wunan, yala angelangka Majandamun Godundumun nyungundu balkan. ");
INSERT INTO gvn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bula marrymanijin, yamba bula kari muruku wunan, Marymu kangkal balkajinjiku. Ngawa balkajin, Josephangka burri dajin, Jesus. ");
INSERT INTO gvn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus, nyulu balkajin bubungu Judea, townbu Bethlehem. Herod, nyulu maja jirray, king. Yinyamun kanbal dingkar-dingkar kadarin townbu Jerusalem nakamun kala-kalbaymun. Jananga work dawaranka binalmanka, nyajil-nyajinya. Jana ngadingka nyubun dawar kunkun-bungan-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jana babajin, “Wanjabu ngawa, nyulu majamanka bamanka Jew-warranka? Nganjin dawar nyungu nyajin nakamun dakal-dakanya. Nganjin kadarin, nyungun buyay-maninka.” ");
INSERT INTO gvn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nyulu King Herodangka kuku nyajin jananka, nyulu wawu-buyunmaynda. Jana wubulku townbu Jerusalem yinyilmarin. ");
INSERT INTO gvn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nyulu Herodangka wubulku kunjan, jananin maja-maja Godundumunku bayanka and teacher-teacher lawmunku. Nyulu jananda babajin, “Wanjabu nyulu bama Godundumun balkaji, Christ?” ");
INSERT INTO gvn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jana nyungundu balkan, “Townbu Bethlehem, bubungu Judea. Dingkarangka prophetangka ngadiku kuku manin Godundumun, nyulu kabanba balkan, ");
INSERT INTO gvn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bethlehem bubungu Judea, yinya town karrkay bajaku. Kari, maja jirray bajaku kaday yinyamun townmun. Nyulu majangka ngayku bama Jew-warra miyil-kujil.’” ");
INSERT INTO gvn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nyulu Herodangka bama naka-dingalmun kiraynjaku kunjan. Nyulu jananda babajin, “Dawar yundu wanja-wanjaku nyajin dakanya?” ");
INSERT INTO gvn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nyulu jananda balkan, “Yurra townmunbu Bethlehem dungarika, mumbarabuku karrkay nubi. Yurra nguwimal-bungal nyungun karrkay, ngaykundu kuku yunga. Yinyamun ngayu dunganka, nyajinka, nyungundu milka-jananka, buyay-maninka.” Yamba nyulu jurril-bungan, kari buyay-maninka. Nyulu jananin yungaynda. ");
INSERT INTO gvn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yinyamun jana dungarin. Jana dungan-dungarin, jana dawar nyajin, same oneku jana nyajin yinya dawar naka-dingalmun. Nyulu yinya dawar jakalba dungan jananka. Yinya dawar kadan, janan wangkar-wangkar yinyaymba karrkay wunanan. ");
INSERT INTO gvn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jana wawurr-wawurrmanijinyarrkuda, yinya dawar jana nyajinya. ");
INSERT INTO gvn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jana bayanba walarin, yinya karrkay nyajin nyunguwunji ngamunji Marynji. Jana bungkubu janan, miyil nandajin nyungunku, buyay-manin. Jana kurmun walngan, nyungu presents dajin, kulji, frankincense, jila ngulkurr and myrrh. ");
INSERT INTO gvn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Godungku jananin milka-bakan bijarrda, “Kari dungarika baja King Herodandaku.” Jana dungarin baja janawunbuku bubunguku yinduynjurr baraldarr. ");
INSERT INTO gvn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jana dingkar-dingkar dungarin, angel Majandamun Godundumun kadan Josephanda bijarr. Nyulu yalaman, “Wandi, karrkay wundi, nyungu ngamu. Yurra ngakijika bubungu Egypt. Yinyaymba bundarika, ngayu juma yurranda balkanka kadanka baja. Nyulu King Herod karrkayanka nubin-nubiji kuninka.” ");
INSERT INTO gvn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph, nyulu wandin, nyulu bulanin manin, ngamu-manda. Jana wujurrbu dungarin, bubungu Egypt dungarinka. ");
INSERT INTO gvn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jana bundarin yinyaymba bubungu. Ngadiku nyubunyinja dingkarangka prophetangka kuku manin Godundumun, nyulu kabanba balkan, “Ngayu kangkal kunjan, bubumun Egyptmun.” Jana Jesus bubumun Egyptmun kadari baja, yinya kuku Godundumun manubajaman. ");
INSERT INTO gvn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yala, jana Joseph bubungu Egypt dungan-dungarin, nyulu King Herod binalman jananka dingkar-dingkaranka nakamunku nyungun manubu-wundin. Nyulu yinyamun kuli jirray bajaku. Nyulu kuku dajin soldier-soldieranda, kaykay-kaykay dingkar-dingkar yarkinkaku kuninka townbu Bethlehem, yinyangkarrku townbuku. Jana kuninka jarra yalbay, 2 years old, and ngawa-ngawa. Nyulu King Herodangka yinya kuku dajin soldier-soldieranda, kaykay-kaykay kuninka. Nyulu yinya kuku dajin, dingkar-dingkarangka nakamun nyungundu balkanya timeka dawar milbijin. ");
INSERT INTO gvn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ngadiku nyubun dingkar prophet burri Jeremiah. Nyulu kuku manin Godundumun, kabanba balkan. Yinya kuku yalaku: “Nyirray nyajil bubungu Ramah, ngamu-karra banbadirinya, kaykay-kaykay kunil-kuninya. Jana kari nyirray kunbay, kaykay-kaykay wubulku wularinda.” Jana soldier-soldierangka kaykay-kaykay kunin, yinya kuku manubajaman. ");
INSERT INTO gvn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yinyamun nyulu King Herod wulan, angel Majandamun Godundumun kadan Josephanda, bubungu Egypt. Nyulu bijarr walan Josephanda. ");
INSERT INTO gvn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nyulu yalaman, “Wandi, bulanin wundi, ngamu-manda. Dungay baja, bubunguku Israelku. Jana yinya kaykay kuninka, jana yinyarrin wularinda.” ");
INSERT INTO gvn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joseph, nyulu wandin baja, ngamu-manda manin, jana dungarin baja bubunguku Israelku. ");
INSERT INTO gvn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nyulu kuku nyajin King Herodamu kangkal, burri Archelaus, nyulu kingman bubuku Judeamunku. Nyulu Joseph yinyilmaynda, yinyaymba bubungu bundanka. Godungku nyungun milka-bakan, bijarrba. Josephangka kuku nyajin bijarr, jana dungarin baja bubungu Galilee. ");
INSERT INTO gvn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yinyaymba bubungu town burri Nazareth. Yinyaymba townbu jana bundarin. Nyulu Jesus townbu Nazareth bundan, kuku Godundumun manubajamaynda. Prophetangka ngadiku kuku manin Godundumun, nyulu balkan, “Jana balkal, ‘Nyulu Jesus Nazarethmunku.’” ");
INSERT INTO gvn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yala-yalaku ngadiku nyulu John the Baptist kadan. Nyulu bama banabu dukul-damal-damanya. Nyulu kuku yirrkay-yirrkan bubungu jirrbu-jirrbungu Judeanga. ");
INSERT INTO gvn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nyulu yalaman, “Yurra jurrkijika buyun-buyunmun. Bama nyikuku Godundumun kaday. Godungku nyungu bama ngulkurrduku kujinka. Nyulu majamal wubulkuku.” ");
INSERT INTO gvn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ngadiku prophetangka Isaiahangka kuku Godundumun manin Johnunku. Isaiahangka kuku kabanba balkan, “Bama nyubun yirrkan-yirrkay bubungu jirrbu-jirrbungu. Nyulu yirrkay, ‘Readymakada, Maja God kadanyamunku. Junkayku dungay, ngulkurrku dungay. Readymaka nyungunku.’” ");
INSERT INTO gvn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johnumu kambi balkan camelandamun mungkamun. Nyulu wayarri yulban didan nyunguwundurr yinkandarr. Nyungu mayi yinja-yinja and wunba. ");
INSERT INTO gvn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bama wubulku nyungundu kadarin, townmun Jerusalemmun, bubumun Judeamun, bubumun wawubajamun Jordanmun. ");
INSERT INTO gvn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jana mala-yirrkan Godundu, nyulu Johnungku jananin banabu dukul-daman wawubajanga Jordan. ");
INSERT INTO gvn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kanbal yinyarrin Pharisee-warra. Jana law janangaku ngulkurrduku kujin, yamba jana kanbalanka bamanka wawu kari. Kanbal yinyarrin Sadducee-warra. Johnungku jananin Pharisee-warra, Sadducee-warra nyajin, nyungundu kankadanya, banabu dukul-damajinka. Nyulu jananda yalaman, “Yurra yala jarba kuliji. Nyulu Godungku juma kuli jirray yungal bubungu. Yurrangan wanyangka milka-bakan Godundumun kulimun ngakijinka? ");
INSERT INTO gvn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Junkaymakada. Ngulkurrmakada, yurra bamanda milbi yurra buyun-buyunmun jurrkijinda. ");
INSERT INTO gvn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yurra yurraku balkal, ‘Ngana bama Jew-warra, Abrahamandamun, ngana yalada. Ngana kari must jurrkijika.’ Kari, yurra manubajaku kari. Yurra must jurrkijika. Yurra Abrahamandamunkuda, yamba yinyanka kari yurra Godundu dungay. Yurra must jurrkijika. Ngayu yurranda balkanka, kaki God wawu, nyulu bama Abrahamandamun balkal yinyamun kuljimun. ");
INSERT INTO gvn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bama yala juku mayiji. Kaki mayi kari balkaji, bamangka nyandal, yilbal bayanga. Nyulu waymbil ready-bungal, juku nyandanka, bada-bada bajaku, ngara. Yinya yala God. Nyulu readyda, kuli yunganka bamanda, jana kari ngulkurrku bundanya, kari junkayku dunganya. ");
INSERT INTO gvn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngayu yurrangan dukul-damal banabu, bamanda milbinka yurra buyun-buyunmun jurrkijinda. Kari, nyubun bama kaday, ngaykunku kudamundu. Ngayu jarra buban nyungunku. Nyulu yurranin dukul-damal Godundumundu Wawubu dayirrda. Nyulu yala baya, buyun-buyun wayjunku. Nyulu maja yalbay bajaku, ngayu karrkay bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","God yala bama marra yanday-bungal. Bamangka marra mujal, wayjul, yinyamun dudal, dirka-bungal, baljingada yijarril, bananga ngabal. Yinyamun kaka yilbaji wuyarmun. Kaka kunbay, bamangka nukalda. God yala yinya bama. Nyulu bama wubulku mujal, nyulu bama buyun yilbal bayanga, bama ngulkurr kujil nyungunji.” ");
INSERT INTO gvn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yala-yalaku nyulu Jesus bubumun Galileemun dungan, wawubajanga Jordan. Nyulu Johnundu kadan, babajin, “Yundu nganya banabu dukul-dama?” ");
INSERT INTO gvn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yamba Johnungku wawu kari nyungun banabu dukul-damanka. Johnungku Jesusanda yalaman, “Yinya wadu-wadu. Ngayu jarra buban yununku. Yunduku nganya banabu dukul-dama, ngayu yunun kari banabu dukul-dama.” ");
INSERT INTO gvn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yamba Jesusangka yalaman nyungundu, “Kari, yalada. Yinyamundu ngali God kuku nyajil, nyungu kuku wukurrilkuda.” John wawumaynda, Jesus banabu dukul-damaynda. ");
INSERT INTO gvn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Johnungku Jesus banabu dukul-daman, Jesus banamun wandinda. Yinyamun Jesusangka jiri nyajin walngajinya. Nyulu Jesusangka Godumu Wawu dayirr nyajin bada-bada kankadanya. Godumu Wawu dayirr yala bakamu, Jesusanda jalaman. ");
INSERT INTO gvn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nyulu kuku jirimun nyajin Godundumun. Godungku yalaman, “Yinya ngaykuku kangkal, nyungunku ngayu wawurr-wawurrmal. Ngayu nyungunku wawu jirray bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yinyamun Godundumundu Wawubu Jesus wundin bubungu jirrbu-jirrbungu. Dubungku Jesus milka-bakanka buyun-damanka. Yamba Jesus Dubundu kari milka-janan. ");
INSERT INTO gvn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesus yinyaymba warngku 40-bala bundan, mayi-kariku. Nyulu dakwuymaynda. ");
INSERT INTO gvn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yinyamun Dubu kadan, nyungundu yalaman, “Kaki yundu kangkal Godumu, yundu yinya kulji jurrki, bread-bunga.” ");
INSERT INTO gvn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesusangka yalaman, “Godundumundu kabanda balkan, ‘Mayibu kari bamanga wawu dandi-bungal. Godundumundu kukubuku wawu dandi-bungal.’” ");
INSERT INTO gvn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yinyamun Dubungku Jesus wundin townbu Jerusalemmunbu, wangkar-wangkar Godundumunbu bayanba, jijinga. ");
INSERT INTO gvn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nyulu Jesusanda yalaman, “Kaki yundu kangkal Godumu, yundu yunduku bubungu yilbajika. Godundumundu kabanda balkal, ‘Godungku angel-angel yungal, yunun ngulkurrduku kujinka. Jana yunun marabu jarra-kulbal, yunu jina kari kunijinka kuljibu.’” ");
INSERT INTO gvn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesusangka yalaman, “Kari, Godundumundu kabanda yalarrku yalamal, ‘Yurra God kari wumbabuku baba.’” ");
INSERT INTO gvn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yinyamun Dubungku Jesus wundin manjalba jarra-jarranga. Nyulu Jesusanda milbin bubu yindu-yindu, junjuy-junjuy ngulkurr bajaku bubungu yindu-yinduymbu. ");
INSERT INTO gvn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nyulu Jesusanda yalaman, “Kaki yundu jakalba ngaykundu bungkubu janay, and milka-janay, and nganya buyay-manil, ngayu yunu wubulku dajilkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesusangka Dubundu yalaman, “Dungayda, Dubu. Godundumundu kabanda balkal, ‘Godku buyay-mana. Godunduku milka-janay. Godunduku praymaka.’” ");
INSERT INTO gvn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dubungku Jesus bawaynda. Yinyamun angel-angel kadarin, Jesus ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nyulu Jesusangka kuku nyajin jana John mumbanya jailba. Nyulu yinyamun dungaynda bubungu Galilee. ");
INSERT INTO gvn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nyulu kari bundan townbu Nazareth. Nyulu dungan townbu Capernaum yubaku jalunbu Galilee, yinyaymba bundan. Yinya town dindarra bubungu Zebulon, bubungu Naphtali. ");
INSERT INTO gvn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Ngadiku prophetangka Isaiahangka kuku manin Godundumun. Nyulu kabanba balkan, “Bubu Zebulon, bubu Naphtali, bula wunay yubaku jalunbu, ngubar-ngubar wawubajanga Jordan. Bama Gentile-warra yinyaymba bubungu Galilee bundarin. Jana yala nguwul-nguwulbu bundandari. Jana light yalbay nyajilda. Jananga wawu wulan, jana buyunmanya, yala nguwul-nguwulbu bundanday. Kari, lightmundu janangan bama balbal.” Jesus yinyaymba bubungu dungan, yinya kuku manubajamaynda. ");
INSERT INTO gvn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yinyamun Jesus kukuji dungan. Nyulu kuku yirrkan, “Buyun-buyunmun jurrkijikada. Time yuba kadan, Godungku nyungu jawun-karra ngulkurrduku kujinka.” ");
INSERT INTO gvn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nyulu Jesus jalundurr Galileemundurr dungan-dungan, nyulu bulangan nyajin, yaba-yabaju. Nyubun burri Simon, nyungu burri yindu Peter. Yabaju burri Andrew. Bula makarrda kuyu manil-manin, yinya bulanga work. ");
INSERT INTO gvn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesusangka bulanda yalaman, “Kaday ngaykunji. Ngayu yubalan binal-bungal bama maninka kukubu ngulkurrdu, yala yubalda kuyu maninda.” ");
INSERT INTO gvn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bula makarr bawaynda, Jesusanjikuda dungaynda. ");
INSERT INTO gvn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jana Jesus dungarin baja. Jana yinya bulal yindu yaba-yabaju nyajin, bula burri James and John. Bulanga nganjan Zebedee. Bula boatbu bulawunji nganjananji Zebedeenji makarr yanday-bungal-bungan. Jesusangka bulanin kunjan. ");
INSERT INTO gvn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bula boat bawaynda, nganjan bawan, dungaynda Jesusanjida. ");
INSERT INTO gvn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nyulu Jesus dungan yiringkurrku bubungu Galileemunbu. Nyulu kuku dajil-dajin bamanda janawunbu churchmunbu, binal-bungal-bungan kukuku ngulkurrku, bama Godunduku jurrkijinkada, Godungku nyungu jawun-karra ngulkurrduku kujinka. Nyulu yalarrku bambay-bambay ngulkurr-bungan, bambay walu-yindu walu-yindu. ");
INSERT INTO gvn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jana bama Syria-warra, jana wubulduku kuku nyajin Jesusanka. Jana bambay-bambay wubulku nyungundu wundin. Bambay-bambay walu-yindu walu-yindu. Kanbalanda yinyarrinyanda Dubu walan janawunbu dukurrbu. Kanbal yinyarrin daranya, yaykarrku bulngajinya. Kanbal yinyarrin waba buyunman. Kanbal dakil buyunman. Jana bama yalanguy Jesusanda wundin. Jesusangka jananin wubulku ngulkurr-bunganda. ");
INSERT INTO gvn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bamangka wubulduku nyungun wukurrinda, bubumun Galileemun, bubumun Ten Townsmun, townmun Jerusalemmun, bubumun Judeamun, bubumun ngubar-ngubarmun wawubajamun Jordanmun, jana wubulduku nyungunin wukurrin. ");
INSERT INTO gvn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nyulu Jesusangka bama wubul bajaku nyajin, nyulu wuburrbu dakan, yinyaymba nyulu bundan. Nyungu jawun-karra 12-bala nyungunduku bundarin. Bamangka kanbalda nyungun ngulkurrduku wukurrin, jana nyungundu yalarrku kadarin. ");
INSERT INTO gvn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nyulu jananda kukukuda dajin, jananin binal-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nyulu yalaman, “Yurra nguba binal yurra yurraku wawuku murruji dayirr-bungaji. Yurra nguba wawu Godungku yurranin dayirr-bunganka, ngulkurr-bunganka. Godungku yurranin ngulkurrduku kujilkuda. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kaki yurra milka-bujarmal, Godungku yurranin helpim-bungal, milka-wulanka. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kaki yurra yinyarrin bulmbuy karilu, and kuli-kuli karilu bundarikuda, yurra ngaykunji bundarikuda nganandamunbu bubungu, ngayu kaday baja. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kaki yurra wawu jirray bajaku dayirrmanka, junkaymanka, ngulkurrmanka, and wawu kari bajaku buyun-buyunmanka, Godungku yurranin dayirr-bungal, helpim-bungal junkayku bundankakuda. Yurra milka-marrimalda, wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kaki yurra bamanka manun-manunmal, nyulu God yurranka yalarrku manun-manunmalda. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kaki yurra junkayku bunday Godunku and wawu-dayirrku bunday, and kari bulu-durayku bunday, yurra wawurr-wawurrmalda. Yurra Godunjida wuljaljiku bunday wangkar-wangkar jiringa. ");
INSERT INTO gvn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kaki yurra bama walmbaji warri, jananin helpim-bunganka jawun-jawun-banka baja, Godungku yurranin kangkal-kangkalkuda bambal. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bamangka nguba yurranga kuli dajil, yurra nganya kuku wukurrinya. Yalada. Godungku yurranin ngulkurrduku kujilkuda. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Yurra nganya kuku wukurrinya, bamangka nguba buyun balkal yurranka, kuku jurril dajil. Jana nguba kuli jirray dajil yurranga, nguba yurrangan jurungu-jurungu kunil ngaykunku. Yamba yurra kari milka-bujarmaka yinyaynka. ");
INSERT INTO gvn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yurra wangkar-wangkar heavenba dungay, Godungku yurranga jirray bajaku dajil baja, wawu ngulkurrku dajil baja. Yurra wawurr-wawurrmanijida. Yinya yala ngadiku. Jana prophet-prophetangka ngadiku kuku Godundumun dajin bamanda. Bamangka prophet-prophetamu kuli jirray bajaku dajin, jana wawu kari Godundumunku kukuku. Yamba jana prophet-prophet wangkar-wangkarkuda Nganjananjikuda bundandayda jiringa.” ");
INSERT INTO gvn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesusangka yalaman baja, “Yurra yala salt. Bamangka mayi ngulkurr-bungal saltmundu. Saltmundu minya kaka-bungal, minya kari kabumal. Kaki salt buyunmal, bamangka yilbal, mayi kari damal baja. Kaki salt buyunmal, bamangka yilbal, jinabu nyarril. Yurra yala yinya salt ngulkurr. Bamangka yurranin nyajil ngulkurrku bundanya, jana yalarrku ngulkurrku bundanka. ");
INSERT INTO gvn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yurra yala light bamanga. Yurra junkayku bunday, bamangka nyajinkaku, binalmankaku yurra ngaykukuda. Kaki town wangkar-wangkar wuburrbu, bamangka yinya town nyajilarrku. Kaki yurra junkayku bunday, bamangka nyajilda, binalmalkuda, yurra ngaykukuda. ");
INSERT INTO gvn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bamangka light wayjul, wangkar-wangkar yijarril, bamangka nyajinka. Bamangka lightmundu bayanba nguwul-nguwulbu nyajinka. Jana light kari nanda. ");
INSERT INTO gvn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yurra yala light. Yurra junkayku bunday, bamangka yurranin nyajinkaku junkayku bundarinyakuda. Yinyaynka jana God jiringa buyay-maninka.” ");
INSERT INTO gvn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesusangka yalaman baja, “Ngadi bajaku Godungku kuku dajin Mosesanda, and dingkar-dingkaranda prophet-prophetanda ngulkurr-ngulkurrbuku. Jana kabanba balkan. Yinya law Godundumun. Ngayu kari kadan law buyun-damanka. Kari. Ngayu kadan lawmunku mumbarabuku binal-bunganka, bamanda milbinka law ngulkurrduku kuku nyajinka. Ngayu kadan law manubaja-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Milkabu kuji! Bubu kunbay, jiri kunbay, yamba yinya kuku wunayarrkukuda, kari bajaku kunbay. Law wubulku wunanayarrku till wubulku manubajamankarrku. Juma Godungku bubu, and jiri buyun-damal, yamba Godumu kuku still wunanayarrkukuda. ");
INSERT INTO gvn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Godungku nyungu jawun-karra ngulkurrduku kujin-kujil. Bamangka nyubunyinja nguba law buban kari wukurril. Nyulu nguba bama yindu-yindu yalarrku binal-bungal law kari wukurrinka. Nyulu bubanmal Godundumunku jawun-karranka yindu-yinduynku. Bamangka yinduynju nguba Godumu law mumbarabuku wukurril. Nyulu nguba bama yindu-yindu yalarrku binal-bungal wukurrinka. Nyulu yala majamalkuda Godundumunku bamanka yindu-yinduynku. ");
INSERT INTO gvn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngayu yurranda balkal. Yurra jananin teacher-teacher and Pharisee-warra nyajil junkayku bundanya lawmunku. Yurra must jarra junkayku bunday jananka, must Godundu mumbarku milka-janay. Kaki yurra kari mumbarku Godundu milka-janay, yurra kari Godumu jawunmal, nyulu yurranin kari ngulkurrduku kujil.” ");
INSERT INTO gvn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesusangka yalaman baja, “Yurra lawmunku binal. Bamangka ngadiku law manin Godundumun. Teacher-teacherangka bamanda balkan, ‘Yurra kari yarkinkaku kuni. Kaki bamangka yarkinkaku kunil, jana courtcase haveim-bungal nyungunku.’ ");
INSERT INTO gvn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kari. Ngayu yurranda balkal. Kaki bama kuli-kaday bamanka yinduynku, Godungku nyungun punishim-bungal. Kaki bamangka kuli-murubuku balkal bamanda, Godungku nyungun church councilanda yungal, courtcasemunku. Bama nyubun nguba bamanka yinduynku wawu kari bajaku. Nyulu nguba nyungundu balkal, ‘Yundu kiru-kari bajaku.’ Godungku yinya bama yungalda bada-bada bayanga. ");
INSERT INTO gvn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Bamangka nguba money dajinka Godumu. Nyulu nguba yinya money wundil churchmunbu. Kari, nyungundu milkanga nguba kaday, nyulu yinduymbukuda kuli dajin. ");
INSERT INTO gvn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nyulu wanjarrmalda? Nyulu yinduymbu bamanda dungay, jawun-jawunmaka baja. Yinyamun money daya baja Godunduku. ");
INSERT INTO gvn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Bamangka yununin nguba nyuyal junjuynku buyunku. Kaki nyulu buliman yungal yunun karrbanka, yundu jinbalku jawun-jawunmaka baja, courtcase haveim-bunganjiku. Bulimanangka yunun jailba mumbanji. ");
INSERT INTO gvn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nyulu nguba yunun jailba mumbal. Nyulu yunun kari yungal baja, yundu fine payim-bungalarrku.” ");
INSERT INTO gvn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesusangka yalaman baja, “Yurra lawmunku binal. Teacher-teacherangka lawmunku balkan, ‘Kaki jalbu yunu manyarr kari, nyungunji kari bajaku wunay.’ ");
INSERT INTO gvn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yamba ngayu yurranda balkal baja. Dingkarangka nyubunyinja nguba manyarr kari jalbu kunkun-bungal, wunanka. Yinya buyun-buyun nyungundu milkanga kadan, yinya yala nyulu jalbunji wunanay. ");
INSERT INTO gvn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kaki yundu junjuy ngulkurr nyajil, and wawu kari bawanka, yundu nguba yinya junjuy ngakinka. Yundu miyilda nyajinya buyunmanka, yundu miyil walnga, yilbada. Yundu nguba wawu kari miyil walnganka. Yinya jarra ngulkurr yununku, yunun bayanga yunganji. ");
INSERT INTO gvn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yundu nguba marabu buyun-damal. Yundu mara nyandajika, yilbada. Yundu nguba wawu kari mara nyandajinka. Yinya jarra ngulkurr yununku, yunun bayanga yunganji.” ");
INSERT INTO gvn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesusangka yalaman baja, “Teacher-teacherangka lawmunku balkan, ‘Kaki bamangka manyarr bawanka, nyulu kabanba balka, “Yanyu ngayku manyarr karida.” Nyulu bamangka yinya kaban manyarranda daya, nyungun yungada. Bula kunbayda manyarrinyumalmanya.’ ");
INSERT INTO gvn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kari. Yala kari. Ngayu yurranda balkal. Bamangka nguba manyarr bawanka. Nyulu manyarr dunyunji yinduynji kari wunan. Yamba dunyungku still bawanka. Nyulu nguba bawal, jalbu nguba dingkaranji yinduynji wunay. Yinya yala nyulu dingkarangka yinya jalbu mambarril kalngarmanka. Nyulu dunyu yindu yalarrku kalngarmal. Yinya jakalbaku dunyumuku fault bula buyunman.” ");
INSERT INTO gvn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesusangka yalaman baja, “Teacher-teacherangka lawmunku ngadiku balkan, ‘Yurra kari jurrilmaka, promise kuji. Kaki yurra yalamal, “Mumbarku Godundu jiringa,” yurra manubajamakada.’ ");
INSERT INTO gvn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Kaki yurra wawu kanbalda yurranin believeim-bunganka, kari balka, ‘Mumbarku Godundu jiringa.’ Kari balka heaven or bubu or town Jerusalem or yurranga dukul. Godungkuku junjuy-junjuy wubulku balkan. Bamangka kari. Yurra murruji bubu balkal, murruji mungka bingaji-bungal, murruji ngumbu-bungal. Godungkuku. ");
INSERT INTO gvn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yurra manubajabuku balka. Balka, ‘Yuwu’ or ‘Kari,’ yinya wubulkuda. Manubajabuku balka, junkaynjaku. Kari kuku jurril. Kuku yala ‘Mumbarku Godundu jiringa,’ yinya kuku Dubundumun.” ");
INSERT INTO gvn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesusangka yalaman baja, “Teacher-teacherangka lawmunku balkan, ‘Kaki yundu miyil bamandamun walngal, nyulu yunu miyil yalarrku walnga baja. Kaki yundu bamandamun dirra walngal, nyulu yunu dirra yalarrku walnga baja.’ ");
INSERT INTO gvn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kari. Yala kari. Ngayu yurranda balkal, kari kuli daya baja. Kaki bamangka yununin kunil, nyungun kari kuni baja. Kari nyungunku wawu-karimaka. Balu nyulu yunun kuni baja. ");
INSERT INTO gvn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bamangka nguba yunun wundil courtcasemunbu yunu kambi maninka. Yundu yalarrku nyungu coat daya. Kari nyungunku wawu-karimaka. Dayada. ");
INSERT INTO gvn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kaki soldierangka yunun mambarril junjuy-junjuy 1 kilometre jarra-kulbanka, yinya yalada. Kari nyungunku wawu-karimaka. Nyungu junjuy-junjuy jarra-kulba baja 2 kilometres. ");
INSERT INTO gvn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kaki bamangka yunundu babaji junjuynku, daya. Kari jumbunmaka. Jawaymakarrku. Dayada. Kaki bamangka yunu junjuy useim-bunganka, nyungundu daya.” ");
INSERT INTO gvn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesusangka yalaman baja, “Teacher-teacherangka lawmunku ngadiku balkan, ‘Jawun-karrankaku wawumaka. Bamanka buyun-buyunyunku wawu-karimaka.’ ");
INSERT INTO gvn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kari. Yala kari. Ngayu yurranda balkal, bamanka buyun-buyunyunku yalarrku wawumaka. Kaki bamangka yunu kuli dajil, Godundu babajika nyungun bama buyun helpim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bamanka buyun-buyunyunku ngulkurrmaka, yinyamun yundu kangkalkuda Godumu. God yurranga nganjankuda. Nyulu wangkar-wangkar heavenba. Nyulu ngadiku wungar balkan. Nyulu yalibala-yalibala wungar dakay-manil, yilaylaymal, nyulu daray-manilda. Bama wubulku wungar-wungara bundari, bama buyun, and bama ngulkurr. Nganjanangka jirimun yalarrku kaba yungal, bamanda buyunyundu, and bamanda ngulkurrbu. ");
INSERT INTO gvn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bama kanbal yununku wawu. Yundu nguba janankaku wawu, yindu-yinduynku wawu kari. Yinya ngulkurr kari. Bama buyun-buyun janawunkuku jawun-karrankaku wawumal. Bamangka money bangkal Governmentamu, jana yinyarrin yalaku bundari. Yamba Godumu jawun-karra yindu-yinduynku bamanka wubulkuku wawu. ");
INSERT INTO gvn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yundu nguba jawun-karranjiku jawun-jawunku balkaway, yamba kanbal bayjal. Yinya ngulkurr kari. Bama Godunku wawu kari, janaku yalaku bundari. Yamba Godumu jawun-karra jawun-jawunku balkaway bamanji wubulinjiku. ");
INSERT INTO gvn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","God yurranga nganjankuda. Nyulu ngulkurr bajakukuda, dayirr bajakukuda, junkay bajakukuda. Yurra yalamaka nganjankulu. Yurra yalarrku ngulkurrmaka, dayirrmaka, junkaymaka yala nganjankula.” ");
INSERT INTO gvn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesusangka yalaman baja, “Kaki yundu wawu praymanka Godundu, kari ngalkalba kuku daya bamanda miyilba. Kiraynjaku kuku daya. Kaki yundu bulmbuymal kukuji, Godungku yunu junjuy-junjuy kari dajil. ");
INSERT INTO gvn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kaki bama dakwuy-dakwuy bundanday, and yundu mayi dajinka, yundu kari daya bamanda miyilba. Jana bulmbuy-bulmbuyngku yalaku mayi dajil bamanda miyilba. Jana wawu bamangka janangan buyay-maninka. Yamba Godungku janangan kari buyay-manilda. ");
INSERT INTO gvn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yundu kari yalamaka. Kaki yundu ngulkurrduku dajinka, kiraynjaku daya. Kari bulmbuymaka. Kiraynjaku ngulkurrduku balka, kanbalda kari nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yunuwundu nganjanangka heavenba yununin nyajil kirayku ngulkurrmanijinya. Nyulu yunun ngulkurrduku kujil, junjuy-junjuy dajil baja.” ");
INSERT INTO gvn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesusangka yalaman baja, “Kaki yundu praymanka Godundu, kari churchmunbu and baralba townbu dungay bamanda miyilba. Kari, yala kari. Jana bulmbuy-bulmbuy yalaku praymal. Bamangka janangan nyajil, yamba Godungku jananin kari buyay-manil. ");
INSERT INTO gvn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kaki yundu Godundu balkanka, yundu yundurrku bunday. Godunji kirayku balkawaka, yunun bamangka kari nyajinka. Yundu God kari nyajil, yamba nyulu yunun kuku nyajil, yundu kiraynjaku balkanya. Nyulu yununku wawurr-wawurrmalda, yunundu milka-janayda. ");
INSERT INTO gvn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kaki yundu Godundu balkal, kari wumbabuku balka kuku. Jana Gentile-warra Godunku binal kari, jana balu kuku Godundu kalbali bajaku. Balu ngadingka balkal, Godungku dajilda. ");
INSERT INTO gvn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kari. Yala kari. Yunu nganjan yununku binalkuda. Kaki yundu junjuy-junjuynku wawu, nyulu yinyaynka binal, yundu nyungundu babajinjiku. ");
INSERT INTO gvn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yundu Godundu yalaku balka, ‘Nganjinanga nganjan jiringa, yundu ngulkurr bajaku. Nganjin yunun kuku nyakaku. ");
INSERT INTO gvn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yundu yunduku majamaka bubungu yala yundu maja jiringa. ");
INSERT INTO gvn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nganjinanga mayi daya nyikunku. ");
INSERT INTO gvn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nganjinandamunku buyun-buyunku milka-wulay, yala nganjin buyun-buyunku milka-wulay kanbalda balkan nganjinanda. ");
INSERT INTO gvn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yundu nganjinin nyakaku. Dubu kanbi, nyulu kari milka-bakanka, buyun-damanka. Yunduku majakuda, yunduku junkurrjikuda, yunduku dayirr-dayirrkuda. Yalakubada.’ ");
INSERT INTO gvn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kaki bamangka yunun buyun-damal, yundu must milka-wulay yinyaynka buyun-buyunku. Wanyurrinku milka-wulay? Kaki yundu janawunku buyun-buyunku milka-wulay, Nganjan God yalarrku milka-wulay yunuwunku buyun-buyunku. ");
INSERT INTO gvn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kaki yundu bamandamunku buyun-buyunku kari milka-wulay, Nganjan God yalarrku yunuwunku buyun-buyunku kari milka-wulay.” ");
INSERT INTO gvn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesusangka yalaman baja, “Yundu nguba mayi kari nukal, mumbarku Godunji balkawanka. Kaki yundu yalaku mayi kari nukal, yundu walu wawurr-wawurrku dungay. Kari walu-yindumanijika, kari milka-bujarmaka, bamangka yunun nyajinka. Kaki bamangka yununin nyajil and buyay-manil, yinya yunu paykuda. God yununku kari wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kaki yundu Godunku mayi kari nukal, julurrijika, mungkamanijika. ");
INSERT INTO gvn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kari walu-yindumanijika. Yundu wawu kari yunun bamangka nyajinka. Nganjanangkaku Godungkuku yunun nyajil mayi kari nukanya. Yinyaynka nyulu yunun ngulkurrduku kujil, junjuy-junjuy dajil baja.” ");
INSERT INTO gvn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesusangka yalaman baja, “Kari jumbunduku money and yamba-yamba bangka yalaymba bubungu. Bubungu yamba-yamba buyunmal kababu, rustmundu bulbun-bungal. Wurrmay-bakangka ngakinji. ");
INSERT INTO gvn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kari. Yala kari. Ngulkurr balka. Ngulkurrmaka, junkayku bunday. Yinya yala yundu junjuy-junjuy jakalba yununku yungal wangkar-wangkar heavenba, yinyaymba kujinka. Yinyaymba junjuy-junjuy kari buyun-damaji, wurrmay-baka kari walal, ngakinka. ");
INSERT INTO gvn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kaki yundu jumbundu bangkal, yundu milka moneyjiku bunday, milkanga junjuy-junjuynjiku. Kaki yundu junjuy-junjuynku kari jumbunku bunday, yundu milkanga Godunjiku bunday.” ");
INSERT INTO gvn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesusangka yalaman baja, “Kaki yunu miyil lightmunji, ngulkurrda. Yundu ngulkurrduku nyajilda, junkayku dunganka, kari daranka. Yunu miyil yala yunu wawu. Kaki yunu wawu lightmunji, ngulkurrda. Yundu binalda junkayku dunganka, buyunmun jurrkijinka. ");
INSERT INTO gvn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kaki yunu miyil kari lightmunji, buyunda. Yundu yala nguwul-nguwulbu bundanday. Yundu kurru-kurru dunganji, daranji. Kaki yunu wawu buyun, yinya yala miyil-buyun, yundu kari junkayku dungay. Yundu kala-kalbay bunday Godundumun, nguwul-nguwulbu.” ");
INSERT INTO gvn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesusangka yalaman baja, “Kaki yundu money and yamba-yamba maja-bungal, God yunu maja kari bajaku. Kaki yundu God maja-bungal, yundu kari money and yamba-yamba junbunduku bangkal. Yundu can't milkanga jambuliynjiku bunday, Godunjiku and moneyjiku. ");
INSERT INTO gvn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ngayu yurranda balkalda. Kari bangkarr wawu-buyunmaka mayika, banaka, kambika. Yundu bangkarr juranku bunday. Yinya enoughkuda, kari wawu-buyunmaka mayika, kambika. ");
INSERT INTO gvn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Dikal-dikalanda miyil-janay. Dikal-dikalangka kari diburr nandal gardenba, mayi maninka, yamba yurrandamundu nganjanangka jananda mayi dajil-dajil. God yurranka wawu jirray jarra dikalanka. ");
INSERT INTO gvn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kari worry-balamaka. Yinyamundu yunun kari juran dandiku kujil. ");
INSERT INTO gvn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kambika kari wawu-buyunmaka. Nganka nyaka. Nganka balkaji, jirraymal, yamba jana nganka kari wawu-buyunmal, kambi damanka. Godungku nganka ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngadiku nyubun bama money jirray, burri Solomon. Nyulu kambi jirray, kambiji mini-miniji, ngulkurr bajaku nyajiji. Yamba yanyu nganka jarra ngulkurrijin Solomonandamunku kambika. ");
INSERT INTO gvn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nganka jinbalku nyarraymal, bamangka wayjulda. Kaki Godungku nganka ngulkurrijin-bungal, nyulu yalarrku ngananin ngulkurrduku kujil. Yurra God bubanku trustim-bungan-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kari wawu-buyunmakada. Kari yalamaka, ‘Ngananga mayi wanjamun manil? Bana wanjabu? Kambi wanjamun manil?’ Godungku yurranin ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bama Gentile-warra Godunku binal kari, jana yinyarrin milkanga junjuy-junjuynjiku bunday, mayijiku, kambijiku. Nganjan binal yundu mayi-kariku bunday, bana-kariku, kambi-kariku. ");
INSERT INTO gvn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yinyaynka yundu Godngarr jakalba-bunga, maja-bunga, junkayku dungay. Yinyamun nyulu yunundu dajilkuda, mayi, bana, juranku bundanka. ");
INSERT INTO gvn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kari wawu-buyunmaka wunkunyunku. Wunkunmal, timeda milkabu wukurrinka. Nyikuku milkabu wukurrika.” ");
INSERT INTO gvn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesusangka yalaman baja, “Yundu nguba kuku nyajil bamanka. Kari jinbalku kuli warri, bama nyuyanka. Godungku yalarrku yunun nyuyanji, yunuwunku buyun-buyunku. ");
INSERT INTO gvn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Godungku yunundu balkal yala yundu bamanda yinduymbu balkal. ");
INSERT INTO gvn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Buyun-buyun yala juku bamandamunbu miyilba. Juku karrkay bamanda yinduymbu miyilba. Yundu nyajil, balkal, ‘Yunuwunbu miyilba juku.’ Yunuwunbukulu miyilba juku yalbay bajaku, yamba yundu ngambaku bundanday. ");
INSERT INTO gvn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kaki juku jirray yunuwunbu miyilba, yundu juku kari nyaka bamanda yinduymbu miyilba. ");
INSERT INTO gvn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaki yundu yalaku bunday, yundu bulu-duray. Yundu wawu yindu-yindu helpim-bunganka buyunmun jurrkijinka, yamba yundu yalarrku buyun. Yundu juku jirray walnga miyilmun yunuwunmun. Yinyamun yundu ngulkurrduku nyajil, juku karrkay walnganka bamandamun yinduyndumun miyilmun. ");
INSERT INTO gvn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yurra minya ngulkurr kari kayanda daya, yinya bamanga. Minya yanday kayamu. Yalarrku yurra junjuy ngulkurr kari bikibikinda daya. Jana nyarril, kuli-muruku yurranda jurrkijinji, baykanji.” Jesusangka yinya kuku balkan, binal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesusangka yalaman baja, “Yurra God nubi, nyungun warrmba-bungalda. Nyungundu babajika, nyulu yurranda milka-janayda. Nyungundu balka, nyulu nyajilkuda. Nyulu yurranda dajilkuda. ");
INSERT INTO gvn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaki yurra God nubil, yurra nyungun warrmba-bungal. Kaki bamangka Godundu balkal, Godungku nyajilkuda. Kaki bamangka Godundu babaji, Godungku dajilkuda. ");
INSERT INTO gvn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","10","Kaki yunuwundu kangkalda mayika babaji, yundu nyungu mayikuda dajil, kari bubu dajil. Kaki nyulu minyaka kuyuku babaji, yundu nyungu minyakuda dajil, kari jarba kuliji. ");
INSERT INTO gvn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yundu jarra buyun, yamba yundu still binal ngulkurr dajinka kangkal-kangkalba. Nganjan heavenba ngulkurr bajaku. Yinyaynka nyulu mumbarku binalkuda nyunguwunbu kangkal-kangkalanda ngulkurr-ngulkurr dajinka, jana nyungundu babajinya. ");
INSERT INTO gvn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Milkabu wukurrika kuku jana ngadiku balkan, Mosesangka and prophet-prophetangka. Yinya kuku yalaku: ‘Yundu kanbalka bamanka ngulkurrmaka yala yundu wawu jana yununku ngulkurrmanka.’” ");
INSERT INTO gvn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jesusangka yalaman baja, “Gate jambul wunay; baral jambul wunay. Gate nyubun yalbay. Bama easy-balaku yinyayngkarrku dungay baraldarr balaynjarr. Bama wubulku yinyayngkarrbi dungan-dungay. Yamba yinya baral bada-bada bayanga dungan-dungay. Kari. Yurra gatemundurr darraburr dungay. Kaki yurra Godundumunbu bubungu dunganka, yurra gatemundurr darraburr dungay nyunguwunbu bubungu. Yinyaymba yurra juranku wuljaljiku bunday. Baral Godundumunbu bubungu rough-bala bajaku, kari easy-bala. Bama jarra kulur Godundu dungay baraldarr rough-balaburr.” ");
INSERT INTO gvn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesusangka yalaman baja, “Kanbal bama jurrilmal Godunku. Jana balkal jana kuku Godundumun balkal-balkal, yamba jana jurrilmalmal. Jananka mumbarmaka, kari milka-janay. Yurra balu jana kuku ngulkurr binal-bungan-bungal, yamba jana yini-yini yala bikibiki yalbay kuliji. ");
INSERT INTO gvn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yundu wanjarrku binal bamanka? Jananin nyakaku. Kanbal ngulkurrku dungay, kanbalda buyun-buyun wukurril. Yinya yala mayi jukungu. Yurra mayi kurruy jukumun milimun kari manil. Bama jurril-baka yalarrku kari junkayku bunday. Nyulu yinyanka bama kari helpim-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Yinya yala juku mayiji. Mayi buyun kari balkaji jukungu ngulkurrbu. Yalarrku mayi ngulkurr kari balkaji jukungu buyunbu. ");
INSERT INTO gvn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kaki juku mayiji ngulkurrji kari, bamangka yinya juku nyandal, bayanga yilbal. ");
INSERT INTO gvn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yurra mayi ngulkurr nyajil jukungu, yurra binal yinya juku ngulkurr. Mayi buyun jukungu, yinya juku yalarrku buyun. Yurra teacher-teacher nyaka yala yurra juku mayiji nyajil. Yurra teacher nyajil junkayku dunganya, yurra nyunguwunbu kukungu milka-janay, wukurrika. Yamba teacher wadu-waduku dungan-dungay, nyungun kari wukurrika.” ");
INSERT INTO gvn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesusangka yalaman baja, “Kanbalda bamangka ngaykundu balkal, ‘Yundu ngayku maja.’ Yamba jana nganya kari wukurril, jana jurrilmalmal. Kaki jana nganya jurrilda bambal maja, jana kari Godumu kangkal-kangkal. Godungku jananin kari ngulkurrduku kujil. Wanju Godumu kangkal-kangkal? Bamangka ngayku nganjan heavenba kuku nyajil-nyajin, wukurril-wukurril, jana yinyarrin Godumukuda kangkal-kangkalkuda. ");
INSERT INTO gvn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juma bama wubulku ngaykundu jakalba janay courtcasemunku. Kanbalda yalamal, ‘Maja, nganjin kuku ngulkurr balkan yunuwundu junkurrdu. Nganjin dubu-dubu kangan yunuwundu junkurrdu. Nganjin junjuy-junjuy miracle yalbay balkan yunuwundu junkurrdu.’ ");
INSERT INTO gvn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yamba ngayu jananda balkalda, ‘Yurra ngayku kari bama. Ngayu yurranga junkurr kari dajin. Yurra buyun balkan, yurra buyun bajaku. Yurra ngayku kari. Ngaykundumun dungayda.’” ");
INSERT INTO gvn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesusangka yalaman baja, “Kaki bamangka nganya kuku nyajil, nyulu yala bamangka bayan ngulkurrduku ngaran bubungu kulji-kuljinga. Yinya dingkar binal bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Juma kaba kadan, jalungkarr warrin. Muyar jirray kadan, yamba yinya bayan kari dumbarrijin, bamangka ngaranya bubungu kulji-kuljinga. ");
INSERT INTO gvn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Kaki bamangka nganya kari kuku nyajil, nyulu yala bamangka bayan buyundu ngaran jukaranga. Yinya dingkar ngangkan-ngangkan bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Juma kaba kadan, jalungkarr warrin, muyar jirray kadan, bayan dumbarrinyarrkukuda.” ");
INSERT INTO gvn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesusamu kuku kunbaynda. Jana bama kungkurr-kadarin nyunguwunku kukuku. ");
INSERT INTO gvn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jana yalaman, “Nganjin nyungundu milka-jananka. Nyulu kari binal-bungal yala teacher-teacherangka lawmunku. Nyulu ngananin junkurr-murubuku binal-bungal, ngulkurrduku, Godundumundu junkurrdu.” ");
INSERT INTO gvn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus nyulu kadan wuburrmun. Bamangka wubulduku nyungun juru-wukurrin. ");
INSERT INTO gvn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bama nyubun nyungundu kadan, bajiji, leprosymunji. Nyulu bungkubu janan nyungundu. Nyulu yalaman, “Maja, kaki yundu wawu, ngayku baji kida. Yundu nganya kida, baji kunbay-mana, dayirr-bunga.” ");
INSERT INTO gvn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesusangka nyungun karrban. Nyulu yalaman, “Ngayu wawu. Dayirrmaka.” Bajibu leprosymundu dingkar jinbaldaku bawankuda. ");
INSERT INTO gvn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesusangka nyungundu yalaman, “Milka-janay! Yundu yinya kari balka bamanda. Yundu junkayku dungay yinyayanda priestanda Godundumunbu bayanba. Nyungundu babajika nyulu yunun biku-nyajinka. Junjuy Godundu daya, yala Mosesangka ngadiku balkan, bamanda milbinka yundu dayirrmaynda.” ");
INSERT INTO gvn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus townbu Capernaum dungan. Bama nyubun yinyaymba, nyulu townmun Romemun. Nyulu maja soldier-soldieramu. Nyulu Jesus maku-nyajin, nyungundu babajin helpmunku. ");
INSERT INTO gvn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nyulu yalaman, “Maja, ngayku workingman bayanbaku wunanay, bambay. Nyulu kari burrki baja, warrngkan-warrngkay, bambay jirray bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesusangka yalaman, “Ngayu nyungundu dungay, nyungun ngulkurr-bungalda.” ");
INSERT INTO gvn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yamba majangka yalaman, “Kari. Ngayu yunun kari kunjal ngaykuwunbu bayanba kadanka. Ngayu buyun bajaku. Yundu kukubuku balkal, ngayku bama ngulkurrmalda. ");
INSERT INTO gvn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngayu yala yundu, majanji. Ngayu yalarrku maja soldier-soldieramu. Ngayu nyubunyundu yinyanda balkal dunganka, nyulu dungaykuda. Ngayu nyungundu yinyanda yinduymbu balkal kadanka, nyulu kadaykuda. Ngayu ngaykuwunbu workingmananda balkal, jana yinya doim-bungalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus kungkurr-kadan yinyaynka kukuku. Nyulu yalaman bamanda nyungun juru-wukurril-wukurrin, “Ngayu yurranda balkal. Nyulu bama Jew kari. Nyulu Gentile. Yamba nyulu nganya trustim-bungalarrku. Jana Jew-warrangka nganya kari yalaku trustim-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Milkabu kuji. Bama Gentile-warra wubul kadari bubumun yindu-yindumun, jibarrmun, kuwamun, nakamun, kungkarrmun kadari. Jana bundarinka tablebu, mayi nukanka jananji, Abrahamanji, Isaacanji, Jacobanji. Godungku jananin ngulkurrduku kujilda. ");
INSERT INTO gvn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bama wubulku Jew-warra balu jana murumal Godundumunji jawun-karranji. Kari. Kanbal kari junkayku bunday. Godungku jananin ngalkalba yilbal, bubungu nguwul-nguwulbu. Jana yinyay banbadida, warrngkan-warrngkaykuda, dirra baykaji.” ");
INSERT INTO gvn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesusangka yalaman yinyayanda soldieranda, “Dungayda bayanbaku. Yundu ngaykuwunbu kukungu milka-jananya, ngayu balkalkuda.” Majamu workingman nyulu yala-yala ngulkurrmaynda. ");
INSERT INTO gvn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus nyulu dungan Peterandamunbu bayanba. Nyulu Peteramu biwul nyajin, bambay wunananya bedba, feverji. ");
INSERT INTO gvn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nyulu mara karrban nyungu, feverbu bawanda. Nyulu jalbu wandin, mayikuda dajin jananga. ");
INSERT INTO gvn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yilay-yilaymaynda, bama wubulku kadarin Jesusanda. Kanbal bama dubunji. Jesusangka dubu-dubu kukubu kanganda. Kanbal bama bambay, nyulu jananin ngulkurr-bungan bambaymun. ");
INSERT INTO gvn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngadiku nyubun bama prophet, Isaiah, nyulu kuku manin Godundumun. Nyulu kabanba balkan, “Nyuluku ngananga bambay kidanka.” Jesusangka bama ngulkurr-bungan, Isaiahmu kuku manubajamaynda. ");
INSERT INTO gvn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesusangka bama wubulku nyajin nyungundurrku. Nyulu nyunguwunbu jawun-karranda balkan disciplesanda, naka-naka jalun-jalun dunganka. ");
INSERT INTO gvn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nyubun bama teacher lawmunku, nyulu Jesusanda kadan. Nyulu yalaman, “Teacher, ngayu readymalda, dunganka yununji wanjabu yundu dungay.” ");
INSERT INTO gvn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesusangka nyungundu yalaman, “Kaya dingkumu bayan bulkaji, dikalamu bayan bulka. Yamba ngayku bayan yamba-kari, wunanka warngku. Ngayu bamanga wubulbuku yaba.” ");
INSERT INTO gvn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yindu dingkar, nyulu jawun Jesusamu, disciple. Nyulu Jesusanda yalaman, “Maja, yundu nganya yungada, ngayku nganjan nandanka juljalba. Yinyamun ngayu yunun wukurrilda.” ");
INSERT INTO gvn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yamba Jesusangka yalaman nyungundu, “Yundu nganya wukurrikada. Kanbalba bamanga wawu wularinda, jana God kari kuku nyajinya. Jana balu janangaku yarkin-yarkin nanda. Yundu nganyaku wukurrikada.” ");
INSERT INTO gvn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus boatji dungaynda. Nyungu jawun-karra 12-bala nyungunji dungarin. ");
INSERT INTO gvn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jarramali jinbalku kadan. Mulngkubu jalundu boat kanbinda. Yamba Jesus warngku wunanan. ");
INSERT INTO gvn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jana jawun-karra disciples nyungundu dungan, nyungun walngan, yalaman, “Maja, nganjinin juran-bunga, wulanjiku.” ");
INSERT INTO gvn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesusangka yalaman, “Wanyurrinku yurra yinyilmalmal? Yurra ngaykunku bubanku binal. Yurra should nganya trustim-bungarrku.” Nyulu janan, kuku yirrkanda jarramalinda and muyaranda. Jalun marrkamaynda. ");
INSERT INTO gvn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jana wubulku kungkurr-kadarinda. Jana yalaman, “Wanju yinya dingkar? Jarramalingka, muyarangka, jalundu nyungun kuku nyajil.” ");
INSERT INTO gvn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jana Jesus bubungu Gadara kadarin, jalunbu. Jana Gadara-warra, jana yarkin-yarkin bulkajimunbu bawan, kari bubungu nandan. Dingkar-bulal jambul bulkajimunbu yarkin-yarkinanji bundandan, bula dubu-dubunji. Bula kuliji bajaku, dubu-dubu dukurrbu walanya. Bama yinyangkarr baraldarr kari bajaku dungarin bulanka, kuliji bajaku. Bula Jesusanda kadanda. ");
INSERT INTO gvn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bula yaykarrku yirrkajin, “Yundu Godumu kangkal. Wanyurrinku yundu ngalinyanda kadan? Yundu ngalinyin punishim-bunganka, right time kadanjiku? Godungku juma ngalinyin punishim-bungalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bikibiki wubul bajaku mayinga nukan-nukajirin yalaku yubakuna. ");
INSERT INTO gvn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dubu-dubungku Jesusanda yalaman, “Kaki yundu nganjinin kanganka, yunga bikibikinda.” ");
INSERT INTO gvn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesusangka jananda yalaman, “Dungarikada.” Jana dungarinda, bikibikindakuda walarin. Bikibiki wubulku warririnkuda, ngamarmunkuda dararin, jalunburrku. Jana bujil-janjirinkuda. ");
INSERT INTO gvn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kanbalda dingkar-dingkarangka yinyarrinyangka bikibiki ngulkurrduku kujil-kujin. Jana townbukuda warririn, bamanda junjuy-junjuy wubulku balkan yinya-bulalanka, dingkar-bulalanka, dubu-dubumunjila. ");
INSERT INTO gvn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bama wubulku yinyamun townmun dungarin, Jesus maku-nyajinka. Jana nyungun maku-nyajin, babajin jananga bubu bawanka, jana yinyilmarinya. ");
INSERT INTO gvn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jana Jesus boatbu dakarin, nyunguwunbuku bubunguku dungarin baja, townbuku. ");
INSERT INTO gvn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kanbalda bamangka dingkar barrka-buyun nyungundu wundin, wunananya bilangkurrbu. Jesusangka nyajin jana nyungun trustim-bunganya. Nyulu barrka-buyunyundu yalaman, “Warru, kari yinyilmaka. God milka-wulan yunuwunku buyun-buyunku. Ngayu yunu wawu dayirr-bungal.” ");
INSERT INTO gvn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kanbal teacher-teacher lawmunku, jana jana-karrajiku balkawan, “Nyulu dingkar God kari. Nyulu bama bajaku. Nyulu can't wawu dayirr-bungal. Nyulu yala Godmanka, nyulu buyun bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus nyulu binal wanyu jana dukulbu kujil-kujin. Nyulu babajin, “Yurra wanyurrinku buyun-buyun kujil-kujil? ");
INSERT INTO gvn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngayu nyungundu balkan ngayu nyungu wawu dayirr-bunganka. Yamba yurra yurra-karrajiku yalaman, ‘Nguba, nguba kari. Nyulu still wunanay, bambaynji.’ Kari. Ngayu nyungundu balkalda, ‘Wandida, jinabu dungayda.’ ");
INSERT INTO gvn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yalakudabi ngayu yurranda milbil ngayu bamanga wubulbuku yaba, bubungu kadan. Yalakudabi ngayu milbil ngayu junkurrji, bamanga wawu dayirr-bunganka.” Nyulu dingkaranda barrka-buyunyundu yalamanda, “Dakada, bilangkurr mana, dungayda, bayanbaku.” ");
INSERT INTO gvn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nyulu dingkar dakan, bayanbaku dungaynda. ");
INSERT INTO gvn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bamangka nyajin yinya, jana yinyilmarinda. Jana God buyay-manin, nyulu Godungku Jesusanda junkurr dajinya, bambay-bambay ngulkurr-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesusangka yinya bubu bawan. Nyulu dungan-dungan, nyulu nyubun dingkar burri Matthew nyajin bundandanya nyunguwunbu officemunbu. Nyulu Matthewungku tax money mujal-mujan, Governmentamu. Jesusangka Matthewundu yalaman, “Nganya wukurrika.” Matthew nyulu dakan, nyungun wukurrinda. ");
INSERT INTO gvn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jana Jesusangka, nyunguwundu jawun-karrangka 12-balangka mayi nukan-nukan Matthewundumunbu bayanba, bama wubul nyungundu kadarin, jananji mayi nukanka. Yinyarrinyangka kanbalda tax money mujal-mujan Governmentamu. Kanbal yinyarrin buyun bajaku. Jana wubulkuda murukuda mayinga nukal-nukajin. ");
INSERT INTO gvn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kanbalda Pharisee-warrangka yinya nyajin, Jesusandamunbu jawun-karranda yalaman, “Wanyurrinku yurrandamundu teacherangka mayi nukal jananji, bamanji buyunyunji, bamanji yinyarrinyanji tax money mujal-mujal?” ");
INSERT INTO gvn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesusangka kuku nyajin, yalaman, “Bama yinyarrin ngulkurr, doctor jananda kari kaday. Yinyarrinku bama bambay, janandaku yinyarrinyandaku doctor kaday. ");
INSERT INTO gvn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ngadiku dingkarangka kuku manin Godundumun. Nyulu Godumu kuku kabanba balkan. Godungku yalaman, ‘Ngayu wawu kari yurra minya wayjunku, ngaykundu dajinka. Ngayu wawu yurra bamanka manun-manunmanka, ngulkurrmanka.’ Yurra binalmaka yinyaynka kukuku. Jana bama ngulkurrku bundanday, ngayu yinyarrin kari kunjal. Ngayu yinyayku bama buyun kunjal.” ");
INSERT INTO gvn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kanbalda bamangka John the Baptist wukurril-wukurrin. Kanbal Johnumu jawun-karra Jesusanda kadarinda, babajinda, “Nganjin and jana Pharisee-warrangka, nganjin mayi jururr-jururr bawal, Godunji balkawanka baja. Yamba yurra wanyurrinku mayi kari bawal, Godunji balkawanka baja?” ");
INSERT INTO gvn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesusangka yalaman, “Kari. Ngayu yala bridegroom. Bama weddingba kari milka-bujarmal, bridegroom jananjiku. Yamba juma bamangka bridegroom karrbal, ngaykuwundu bamangka mayida bawal.” ");
INSERT INTO gvn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesusangka yalaman, “Kambi mukul nguba kankaji. Bamangka kambibu jirakalda mukul kari ngulkurr-bungal. Julurrinya kambi jirakal nyarray-bungal. Kaki nyulu kambibu jirakalda mukul ngulkurr-bungal, kanka jirray-bungal, yalbaymalarrku, kambi jirakal nyarraymalkuda. ");
INSERT INTO gvn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ngana kurmun yulbanmun balkal, yira wine yijarrinka. Bamangka yira wine jirakal kari nyangarril kurmunbu mukulbu. Kaki nyulu kurmunbu mukulbu nyangarril, kurmun mukul dalkay, yira wine nyangarrijinji bubungu. Kari. Bamangka yira wine jirakal nyangarril kurmunbu jirakalba. Bula jambulku ngulkurr.” ");
INSERT INTO gvn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus, nyulu balkal-balkawan jananji, nyubun bama nyungundu kadan, bungkubu janan nyungundu. Nyulu bama Jew, nyulu maja. Nyulu Jesusanda yalaman, “Ngayku kangkal nyikula wulan. Kaday, mara yijarrika nyungundu, nyungun juran-bunganka baja.” ");
INSERT INTO gvn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nyulu Jesus dakan, nyungun wukurrin. Jesusamu jawun-karra 12-bala nyungunji dungarin. ");
INSERT INTO gvn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yala-yala jana dungan-dungarin, nyubun jalbu Jesusanda kadan. Nyulu mula wanarrin, 12 yearsmunku. Nyulu kadan kudamundu Jesusanda, kambi biji karrban. ");
INSERT INTO gvn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nyulu nyulurrku balkawan, “Kaki ngayu kambi karrbal nyungu, ngayu ngulkurrmalda.” ");
INSERT INTO gvn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus nyulu jurrkijin, nyungun nyajin. Nyulu yalaman, “Kari yinyilmaka, jalbu. Yundu nganya trustim-bunganya, yundu ngulkurrmalda.” Yinyamun nyulu jalbu ngulkurrmaynda. ");
INSERT INTO gvn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wawu yinyamun jana majandamunbu bayanba kadarin. Jesus nyulu walan bayanba. Nyulu nyajin bamangka music balkan-balkanya yarkinka, nyajin bamangka nyurra bangkal-bangkanya. ");
INSERT INTO gvn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nyulu yalaman, “Wandirika, yurra bama. Nyulu yinya maral kari wulan, nyulu warngku wunanay.” Jana wubulduku nyungun yaykarrdaku yajarrin-yajarrinda. ");
INSERT INTO gvn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesusangka jananin ngalkalba kangan, nyulu walan karrkayandamunbu maralandamunbu roommunbu. Nyulu mara karrban, nyulu maral dakaynda. ");
INSERT INTO gvn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yinya kuku yiringkurrku dungaynda. ");
INSERT INTO gvn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesusangka yinya bubu bawan. Nyulu dungan-dungan, dingkar-bulalangka miyil-burra-bulalangka nyungun wukurril-wukurrin. Bula yirrkan, “Yundu Davidandamun. Manun-manunmaka ngalinyanka.” ");
INSERT INTO gvn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus bayanba walan, bula miyil-burra nyungundu kadan. Jesusangka bulanda babajin, “Kuda yubal nganya believeim-bungal, ngayu yubalin miyil ngulkurr-bungal?” Bula yalaman, “Yuwu. Ngalin yunun believeim-bungalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesusangka bulanga miyil marabu karrban, yalaman, “Ngayu yubalan ngulkurr-bungal, yala yubal nganya kuku nyajil.” ");
INSERT INTO gvn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bulanga miyil ngulkurrmaynda, bula bubu nyajinda. Jesusangka junkurr-murubuku balkan bulanda, “Bamanda kari bajaku balka, ngayu yubalanga miyil ngulkurr-bungan.” ");
INSERT INTO gvn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yamba bula kari milka-janan. Bula nyungun bawan, bamanda wubulbuku balkan Jesusanka, bubungu yiringkurrku. ");
INSERT INTO gvn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bula dungan-dungan, kanbalda bamangka dingkar Jesusanda wundin, kuku-kari. Nyulu dingkar yinya dubunji, yinyaynka nyulu kuku-kari. ");
INSERT INTO gvn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesusangka dubu kangan, nyulu dingkar kukujimaynda. Wubulku bama kungkurr-kadarinda. Jana yalaman, “Nganjin yala junjuy kari nyajin ngadiku, bubungu Israel.” ");
INSERT INTO gvn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yamba jana Pharisee-warrangka yalaman, “Majangka dubu-dubundumundu nyungu junkurr dajin, dubu-dubu kanganka.” Yamba jana wadu-wadu balkan. ");
INSERT INTO gvn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus yindu-yinduymbu townbu dungan. Nyulu Jew-warrandamunbu churchmunbu binal-bungan, kuku ngulkurrku balkan, Godungku bama wubulku ngulkurrduku kujinka. Nyulu bama wubulku ngulkurr-bungan bambaymun walu-yindu walu-yindumun. ");
INSERT INTO gvn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nyulu bama wubulku nyajin, jiba-badinda jananka. Jana milka-bujarman, wawu-buyunman. Jana yala sheep maja kari dungan-dungari. Maja yamba-kari, jananin ngulkurrdukulu kujinka. ");
INSERT INTO gvn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nyulu jawun-karranda 12-balanda yalaman, “Jana bama yala mayi jirray gardenba. Yamba workingmen yamba-kari, mayi mujanka. ");
INSERT INTO gvn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Godundu babajika bama wubul yunganka, jananin bama wubulku wundinka nyungundu.” ");
INSERT INTO gvn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesusangka nyungu jawun-karra 12-bala kunjan, murumarinka, nyulu jananda kuku dajinka. Jananda junkurr dajinka dubu-dubu kanganka bamandamun. Junkurr dajinka bambay-bambay ngulkurr-bunganka, bambaymun walu-yindu walu-yindumun. ");
INSERT INTO gvn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nyulu jawun-karra 12-bala yunganka. Jana burri yanyu: Peter, nyulu burri yindu Simon. Nyulu jarra jirray yindu-yinduynku. Nyungu yabaju Andrew. James bula John, bula yaba-yabaju, bulanga nganjan burri Zebedee. ");
INSERT INTO gvn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, Bartholomew, Thomas, Thaddeus, Matthew, nyulu ngadiku tax money mujan-mujan governmentamu. James, nyungu nganjan burri Alphaeus. ");
INSERT INTO gvn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yindu dingkar burri Simon, jana nyungun yindu burri dalkin, Patriot. Judas, nyulu bubumun Iscariotmun, nyulu juma Jesus mambarrin buliman-bulimananda. ");
INSERT INTO gvn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Jesusangka jananin 12-bala yunganka. Yunganjiku, nyulu kuku dajin. Nyulu yalaman, “Bamanda Jew-warrandaku dungay, kuku ngulkurr balkanka. Bamanda walu-yindu walu-yinduymbu kari dungay, jana Gentile-warra. Janandamunbu bubungu kari dungay. Bamanda Samaria-warranda kari dungay. Jew-warrandaku. Jana Jew-warra yala minya sheep nubijinya, ngami-ngamiman Godundumun. ");
INSERT INTO gvn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bamanda kuku yirrkay, ‘Time kadanda, Godungku nyungu jawun-karra ngulkurrduku kujinka.’ ");
INSERT INTO gvn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yurra dungay, bambay-bambay ngulkurr-bunga, yarkin-yarkin juran-bunga baja, dubu-dubu kanga bamandamun. Kaki bama bajiji leprosymunji, yulban dayirr-bunga. Moneyka kari babajika ngulkurr-bunganka. Ngayu yurranin binal-bungan, moneyka kari, junkurr dajin moneyka kari. Yurra jananda yalarrku daya, moneyka kari. ");
INSERT INTO gvn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yurra money kari wundi. ");
INSERT INTO gvn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kurmun kari wundi mayika. Kambi yindu kari wundi. Dambal yindu, jaba yindu kari wundi. Yurra Godunku workmanijinya, bamangka yurranin ngulkurrduku kujida. ");
INSERT INTO gvn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Yurra townbu walal, bama ngulkurrku nubi, bama yurranka wawurr-wawurrmanijinka. Nyungunjiku bunday, yurra yinyamun townmun dungarinyamunkurrku. ");
INSERT INTO gvn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yurra bayanba walal, jananda balka, ‘Yurra yalada? Ngalin wawu Godungku yurranin ngulkurrduku kujinka.’ ");
INSERT INTO gvn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kaki jana yurranin wawurr-wawurrduku walay-manil, Godungku jananin ngulkurrduku kujilkuda, yala yurra balkan. Kaki jana yurrangan kari wawurr-wawurrduku walay-manil, Godungku jananin kari ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yurra nguba townbu kaday. Bamangka wubulduku yurrangan nguba bayjal, bayanba nguba kari walay-manil. Yurra yinya town bawada. Yurra dungay, jina bulngajika, bulbur jinamun kidajinka. Bamangka yinyaymba townbu yurrangan nyajil bulngajinya, jana binalda yurra janandamun jurrkin-jurrkijikuda, jananin bawan-bawalkuda. Bama Jew-warra yalaku, kaki jana yinduynku wawu kari, jana bulbur jinamun kidal. ");
INSERT INTO gvn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngayu yurranda manubajabuku balkal. Jana yinyaynka townku juma jakalba Godundu janay, courtcasemunku. Godungku yalamal, ‘Yurra buyun bajaku, ngayku kuku bayjanya. Yurra ngaykuwunbu bamanda kari milka-janan.’ Nyulu yalaku kuku balkal jananda. Ngadi bajaku kanbal bama townbu jambulbu bundandan, townbu Sodom, townbu Gomorrah. Jana buyun bajaku, yamba jana ngaykuwunku kukuku binal kari. Yinyaynka ngayu jananin kari yaykarrdaku punishim-bungal. Bama townbu yurra dungay, jana ngaykuwunku kukuku binal, yurra balkanya. Kaki jana bayjal, Godungku jananin must yaykarrdaku punishim-bungal.” ");
INSERT INTO gvn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesusangka yalaman baja, “Milka-janay. Ngayu yurranin yungal bamanda kuli-bakanda. Yinya yala minya sheep yungal-yungal kaya-kayanda kulijinda. Mumbarmakada; dukul-ngulkurrku dungay. Kari kiru-karimaka. Kari kulimaka, wawu-jankamaka. ");
INSERT INTO gvn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mumbarmaka. Bamangka kulijingka yurranin karrbal, wundil courtcasemunku. Jana yurranin wuybubu kulbal Jew-warrandamunbu churchmunbu. ");
INSERT INTO gvn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yurra ngaykundu milka-jananya, yinyaynka jana yurranin karrbal, wundil maja-majanda jirrayanda, courtcasemunku. Yurra jananda kuku ngulkurr balkada ngaykunku. Bamangka kanbalda yurranin karrbal, jana Gentile-warra. Jana Gentile-warrangka yurranin wundil courtcasemunbu, yurra jananin balka kuku ngulkurr ngaykunku. ");
INSERT INTO gvn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yurra jananda jakalba janay, kari wawu-buyunmaka kukuku jananda balkanka. Kari. Godundumundu Wawubu kuku yurranda balkalda, wanyu balkanka. ");
INSERT INTO gvn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kuku yurra balkalda, yinya kuku kari yurrandamun. Kari. Yinya kuku Godundumun Wawumun. Yinyaynka yurra junkaynjaku balkal, kuku Godundumun Wawumun. ");
INSERT INTO gvn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Yala-yala yurranga jawun-karra yurranka wawu kari bajaku. Jana yurranin mambarril bulimananda, yarkinkaku kuninka. Yabangka yabaju mambarril bulimananda, yarkinkaku kuninka. Yabajungku yaba yalarrku mambarril. Nganjanangka kangkal mambarril, kangkal-kangkalangka ngamu and nganjan mambarril bulimananda, yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bama wubulku yurranka wawu kari bajaku, yurra nganya wukurrinya. Bamangka nganya wukurril-wukurrilku, kari bawal, nyulu Godunji bundayarrkukuda wuljaljiku. ");
INSERT INTO gvn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bama nyubunyimba townbu, jana yurranda nguba kuli dajil. Warrida, townbu yinduymbu. Bama yinyaymba nguba kuli dajil baja. Warrida yinduymbu townbu. Yurra must townbu yindu-yinduymbu bubungu Israel kukujiku dungay. Yurra kunbay-maninjiku, ngayu kaday baja. Ngayu yaba bamanga wubulbuku.” ");
INSERT INTO gvn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jesusangka jananda kuku balkan baja. “Bama jambul nguba bundanday. Nyubun teacher, yindu bama teacherandamun binalmalmal. Wanyaku binal bajaku? Nguba teacher? Nguba bama binalmalmal? Kari. Nyulu teacher binal bajaku. Wanju jarra jirray? Workingman or maja? Nyulu maja, nyulu jarra jirray workingmananka. Nyuluku maja. ");
INSERT INTO gvn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kaki bamangka kuli dajil teacheranda, jana yalarrku kuli dajil bamanda binalmalmanya teacherandamun. Kaki bamangka majamu kuli dajil, jana yalarrku kuli dajil nyunguwunbu workingmanamu. Yinya yala ngayu and ngayku bama. Kaki bamangka ngayku kuli dajil, jana yalarrku yurranga kuli dajil, yurra nganya wukurril-wukurrinya. Yalada, kari wawu-buyunmaka. Nganya wukurril-wukurrikaku. Jana ngaykungurr kuli dajin. Kanbalda jana nganya Dubu burri dalkin, burri Beelzebub. Jana yurrangan yalarrku buyun burri kulbal. Burri buyun bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesusangka yalaman baja, “Jananka kari yinyilmakada. Bamangka kiraynjaku balkal, juma bama wubulku binalmalkuda. ");
INSERT INTO gvn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngana nganarrku bundanday, kiraynjaku balkan-balkaway. Yindu-yindu kari milka-janay. Yamba yurra juma bamanda wubulbuku balkal, wubulduku nyajinka kuku ngayu yurranda balkan. ");
INSERT INTO gvn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kari yinyilmaka bamanka yurranin yarkinkaku kuninka. Jana yurranga bangkarr kunil, yamba wawu yurranga jana can't kunil. Kari. Godunkuku yinyilmaka. Nyulu wawubu, nyulu bama yungal bada-bada bayanga. Nyulu wawubulu, nyulu bamanga bangkarr and bamanga wawu bayanga yilbal.” ");
INSERT INTO gvn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jesusangka jananda balkan baja, “Bamangka nguba dikal sparrow jambul buy-im-bunganka. Nyulu moneybu bubanda buy-im-bungal, dikal sparrow karrkay bajaku, kari yalbay. Yamba God binal dikalanka sparrow-sparrowunku. Nyubun sparrow nguba bubungu daray, wulay. Godungku nyajil, yinya right time Godungku balkan yinya dikal wulanka. ");
INSERT INTO gvn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Godungku yurranin yalarrku nyajin-nyajil, ngulkurrduku kujin-kujil. God yurranka binal bajaku. Nyulu binal bajaku yurrawunku mungkaka dukulbu wunanay. ");
INSERT INTO gvn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Godunku kari yinyilmaka. Nyulu yurranka wawu jirray. Yurra jarra jirray bajaku yinyarrinyanka dikalanka.” ");
INSERT INTO gvn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesusangka yalaman baja, “Yurra bamanda balka, ‘Jesus ngayku maja, ngayu nyungun wukurril-wukurril.’ Balka bamanda, jana wubulduku kuku nyajinka. Yurra juma jakalba Godundu janay, courtcasemunku. Yala-yala ngayu janay, Godundu balkalda, ‘Jana bama ngaykukuda.’ Yurra ngaykunku balka, ngayu yalarrku balkal yurranka. ");
INSERT INTO gvn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yamba bamangka nguba kanbalba yalamal, ‘Jesus ngayku kari maja. Ngayu nyungun kari wukurril.’ Ngayu Godundu balkalda, ‘Yanyu bama ngayku kari.’ Kaki bamangka nganya darrbil, ngayu nyungun yalarrku darrbil.” ");
INSERT INTO gvn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesusangka yalaman baja, “Kanbalda yalamal, ‘Nyulu Jesus kadan, bama wubulku jawun-jawunku bundarinka.’ Kari. Yala kari. Kanbal ngaykuwunku bamanka wawu kari bajaku, ngaykuwundu bamangka nganya wukurrinya. Jana ngaykuwunji bamanji kuniwanka, kanbal yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Dingkar nyunguwunku nganjananka wawu kari bajaku. Maral ngamunku wawu kari bajaku. Jalbu biwulunku wawu kari bajaku. Jawun-karra bayanba nyubunyimba kuli-kuliku bundari, ngaykunku. ");
INSERT INTO gvn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bama nyubun nguba ngamunku and nganjananka wawu jirray bajaku, yamba nyulu ngaykunkulu jarra yala. Yinyaynka nyulu nganya kari maja-bungal. Bama yindu nguba kangkal-kangkalka wawu jirray bajaku, yamba nyulu ngaykunkulu jarra yala. Yinyaynka nyulu nganya kari maja-bungal. Bama yinyanguy ngayku kari. Kaki bama jawun-karranka wawu jirray, and ngaykunku bubanku wawu, nyulu ngayku karida. ");
INSERT INTO gvn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kanbalda bamangka ngaykundu kuli dajil, jana yalarrku ngaykuwunbu bamanda kuli dajil. Kaki bama wawu kari warrngkanka ngaykunku, and jana wawu kari ngaykunku wulanka, jana yinyanguy ngayku kari bama. ");
INSERT INTO gvn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bamangka nguba nganya bawal, wulanji bajalu. Yinyanguy bama ngaykunji kari bunday wuljaljiku. Bamangka yinduynju nguba kuli bayjal, nyulu nganya junkurr-murubuku wukurril, nganya kari bawal. Kulijingka nguba nyungun yarkinkaku kuninji, nyulu nganya wukurrinya. Yamba nyulu ngaykunji wuljaljiku bunday heavenba.” ");
INSERT INTO gvn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesusangka yalaman baja, “Bamangka nguba yurranin bayanba walay-manil, yurranda milka-janay kukuku ngaykunku. Yinya yala nyulu nganya bayanba walay-manil, yala ngaykundu milka-janay. Kaki bamangka nganya bayanba walay-manil and ngaykundu milka-janay, yinya yala nyulu God bayanba walay-manil, yala nyulu Godundu milka-janay. Godungku nganya yungan. ");
INSERT INTO gvn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bamangka nguba dingkar Godundumunji kukuji walay-manil nyunguwunbu bayanba. Nyulu Godundumunjiku kukujiku bundanya, Godungku yinyayanda dingkaranda dajil baja. Nyulu dingkar kukuji ngulkurrduku kujinya, yinyaynka Godungku nyungundu dajil baja. Yalarrku nguba bamangka dingkar ngulkurr walay-manil nyunguwunbu bayanba. Yala nyulu ngulkurrku bundanya, Godungku yinyayanda bamanda dajil baja. Nyulu dingkar ngulkurr ngulkurrduku kujinya, yinyaynka Godungku nyungundu dajil baja. ");
INSERT INTO gvn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kanbal ngayku bama, jana jirray kari, jana buban. Jana ngayku bama, nganya kuku wukurrinya. Bamangka yinduynju ngaykuwunbu bamanda nguba bana kiway-kiway dajil, ngaykuwundu bamangka nganya kuku wukurrinya. Ngayu manubajabuku balkal, Godungku nyungundu dajil baja, nyulu bana kiway-kiway dajinya ngaykuwunbu bamanda.” ");
INSERT INTO gvn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus kunbaynda nyunguwunbu jawun-karranda 12-balanda kuku dajil-dajinya, nyulu dunganda townbu yindu-yinduymbu, bama binal-bunganka, kuku yirrkanka. ");
INSERT INTO gvn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nyubun bama, nyulu burri John the Baptist, nyulu bama wubul banabu dukul-damal-damanya. Nyulu jailba bundandan. Nyulu kuku nyajin Jesusanka balkanya. Nyulu Johnungku jawun-karra kanbal yungan baja Jesusanda, nyulu binalmanka Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jana Jesusanda yalaman, “Nganjinanda balka. Yunduda dingkar Johnungku balkan kadanka? Or kari? Yala nganjin yindu kari kujil?” ");
INSERT INTO gvn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesusangka jananda yalaman, “Dungay baja, Johnundu balka wanyu yurra nyajil-nyajin. ");
INSERT INTO gvn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Johnundu balka, yinyarrin miyil-burra, jana miyilda nyajilkuda. Yalkay-yalkayalu ngulkurrku dungan-dungaykuda, jana bajiji leprosymunji, jana yulban dayirrda. Yala jana yinyanguy bama milka-karilu, milkajimaynda. Ngayu jananin yarkin-yarkinmun juran-bungal baja. Ngayu kuku ngulkurr Godundumun yirrkan-yirrkay bamanda jawun-jawun-karinda. ");
INSERT INTO gvn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bamangka nguba nganya believeim-bungal Godundumun kadanya. Nyulu nguba nganya kari warmbil. Nyulu wawurr-wawurrmanijida. Yurra Johnundu yinya kuku balka.” ");
INSERT INTO gvn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Johnumu jawun-karra dungan baja. Jesusangka balkanda bamanda wubulbuku nyungundu murumarin. Nyulu balkan Johnunku. Nyulu yalaman, “Yurra ngadiku wanyurrimbu bubungu jirrbu-jirrbungu dungarin, John nyajinka? Kuda binalmanka nyungunku? Nyulu wawu kima kari, kari yala jikan bulngan-bulngaji muyara. ");
INSERT INTO gvn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yurra wanyurrimbu dungarin? Nguba bama nyajinka kambiji ngulkurrijinji? Kari. Bama kambiji ngulkurrijinji, jana bayanba yalbaymba ngulkurrbu bundanday. John yala kari. ");
INSERT INTO gvn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yurra wanyurrimbu dungarin? Yurra dungarin, bama prophet nyajinka, balkal-balkanya kuku ngulkurr Godundumun. Yamba John jarra jirray prophet-prophetanka yindu-yinduynku. ");
INSERT INTO gvn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ngadiku bamangka nyubunyinja kuku manin Godundumun. Yinya kuku Johnunku. Nyulu bamangka Godumu kuku kabanba balkan. Nyulu balkan, ‘Nyaka! Ngayu bama kukuji yungal, bamanda balkanka yundu kadanyamunkuda. Nyulu Kukujingka bama yanday-bungal yununku.’ ");
INSERT INTO gvn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngayu yurranda manubajabuku balkal. John, nyulu jarra jirray bamanka wubulkuku yindu-yinduynku jakalbamunku ngaykunku. Kaki bamangka nganya wukurril, nyulu jarra jirray Johnunku, nyulu Godumu jawunmanya. Godungku nyungu jawun-karra ngulkurrduku kujil. Godumu jawun nyubun nguba jarra buban Godundumunku jawun-karranka yindu-yinduynku, yamba nyulu jarra jirray Johnunku. ");
INSERT INTO gvn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ngadiku Johnungku kuku yirrkan-yirrkan. Yinyamun nyikurrku bamangka kulijingka bama yindu-yindu nyandinka Godundu jurrkijinka. Jana bamangka buyunyungku wawu kari nyajinka Godungku nyungu bama ngulkurrduku kujinya. ");
INSERT INTO gvn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngadiku Godungku kuku dajin bamanda wubulbu, prophet-prophetanda, jana nyungu kuku kabanba balkan. Mosesangkangarr Godumu law kabanba balkan, yinyamun jana prophet-prophetangka wubuldu Godumu kuku kabanba balkan. Jana wubulduku balkan Godungku juma nyungu bama ngulkurrduku kujinka. Jana Mosesandamun nyikurrku yalaku balkan. ");
INSERT INTO gvn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jana balkan nyubun dingkar yala prophet Elijah kadanka. Yinya dingkar, nyulu John. Nyulu yala Elijah. Yurra must yinya kuku believeim-bunga. ");
INSERT INTO gvn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yurra yinya kuku nyakakuda, binalmaka. ");
INSERT INTO gvn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Yurra bama wubulku, yurra yala wanju? Yurra yala kaykay-kaykay ngalkalba kinkay-kinkan. Jana kaykay-kaykayanda yindu-yinduymbu yalaman, ");
INSERT INTO gvn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nganjin wumbaku singmanijin, yurra kari kadarin wurinka. Nganjin wumbaku badirin, yurra kari kadarin badirinka nganjinanji.’ Yurra yala jana kaykay-kaykay. ");
INSERT INTO gvn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Johnungku mayi kari nukan, Godunji balkawanka baja. Nyulu wine kari nukan. Kanbalda nyungunku yalaman, ‘Dubu nyungundu dukurrbu walankuda.’ ");
INSERT INTO gvn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngayu kadanda, ngayu yaba bamanga wubulbuku. Ngayu yala yindu-yindu, mayinga, bananga nukal-nukaji. Yamba kanbalda ngaykunku yalamal, ‘Yinyayanda dingkaranda miyil-janay. Nyulu jumbun mayika, nyulu kamu-kamu-baka. Nyulu jawun bamanga buyun-buyunbu, jananga yinyarrinyamba money mujal-mujal governmentamu.’ Yamba Godumu bama manubajaku binal. Godungku kukuku manubajaku milkabu wukurril. Kaki bama yinyayanda kukungu milka-janay, jana ngulkurrmal.” Jesusangka yinya kuku balkan bamanda wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wawu yinyamun Jesus milka-bujarman bamanka townbu Chorazin, townbu Bethsaida, townbu Capernaum. Nyulu Godundumundu junkurrdu miracles balkan baja, balkan baja, jana bamangka townbu nyajinka. Yamba jana buyun-buyunmun kari jurrkijin Godundu. Jesusangka jananin murru-kanganda. ");
INSERT INTO gvn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nyulu yalaman, “Yurra bama townku Chorazinanka, townku Bethsaidanka, yurra Godumu kuku bayjal-bayjan. Kuli jirray yurranda kaday. Jana bama ngadiku bundandan townbu Tyre, townbu Sidon, jana buyun bajaku. Jana nganya nyajinyaku miracles balkanya, jana Godundu jurrkijinyaku buyun-buyunmun. Jana milka-bujarmanyaku buyun-buyunku. Yamba yurra yala kari. Ngayu Godundumundu junkurrdu miracles balkan yurranga, yamba yurra kari buyun-buyunmun jurrkijin. Yurra kari milka-bujarman buyun-buyunku yurrawunku. Yinyaynka yurra milka-bujarmal, kuli yurranda kaday. ");
INSERT INTO gvn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngayu manubajabuku balkal. Juma bama wubulku jakalba Godundu janay, courtcasemunku. Yala-yala Godungku bamanda Tyreanka, Sidonanka yalamal, ‘Yurra bama buyun.’ Nyulu jananin yilbalda, bada-bada bayanga. Yamba nyulu yurranda yalamal, ‘Yurra bama buyun bajaku, yurra ngayku kangkal bayjanya ngulkurr balkanya.’ Nyulu yurranin yilbalda, bada-bada bayanga. ");
INSERT INTO gvn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yurra bama townku Capernaummunku, nyaka. Yurra balu Godungku yurranin wangkar-wangkar wundil, heavenba. Kari. Nyulu yurranin bada-bada yilbal bayanga, yurra nganya bayjanya Godundumundu junkurrdu miracles balkanya. Ngayu townbu buyunbu Sodom miracles balkanyaku, jana nganya kuku nyajinyaku, yinya town kari kunbanyaku. ");
INSERT INTO gvn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngayu manubajabuku balkal. Bama wubulku juma jakalba Godundu janay. Godungku yurrangan yaykarrdaku punishim-bungal, yurra nganya bayjanya miracles balkanya. Yurra kari Godundu jurrkijinda. Godungku bama townku Sodomanka jarra buban punishim-bungal, jana bama ngangkarin ngaykunku miracles balkanya.” ");
INSERT INTO gvn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wawu yinyamun Jesusangka God buyay-manin. Nyulu Godundu yalaman, “Nganjan, yundu maja jirray, bamanka jiringa, bamanka bubungu. Ngayu yunun thankim-bungal, yundu mumbarabuku binal-bungan bama yinyarrin yununku binal kari. Yamba kanbal bama balu jana binal bajaku yununku. Yundu yinyarrin bama kari binal-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yuwu, Nganjan, yinya yala yunduku wawuman.” ");
INSERT INTO gvn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yinyamun Jesusangka bamanda yalaman, “Ngaykuwundu nganjanangka jakalbaku ngaykundu wubulku dajin. Wanju manubajaku binal ngaykunku, Godundumunku kangkalanka? Ngaykuku Nganjanku ngaykunku binal. Wanju Nganjananka manubajaku binal? Ngayuku, nyunguku kangkalku. Ngayu kanbal bama wangkanil binal-bunganka Godunku, jana nyungu bamamanka. ");
INSERT INTO gvn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kanbal yurra wawu-wulan-wulay, baja-burran-burray, kulngkul jarra-kulbal-kulbanya. Ngaykundu kaday, ngayu kulngkul yilbanka, yurrangan ngalu-ngalu-bunganka. Nguba yurra milka-bujar, buyun-buyunmun. Yinya yala buyundu kulngkuldu yurrangan nyarril-nyarrin. Ngaykundu kaday, ngayu buyun kidanka, yurrangan wawu-ngulkurr-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngayu manun-manun yurranka. Ngayu kari kuli-muruku bunday. Yurra ngaykundu mumbarku milka-janay, ngayku kuku milkanga kuji. Yurra nganya kuku nyaka, yurra ngalu-ngalumalda, wawu-ngulkurrmalda. ");
INSERT INTO gvn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaki yurra nganya kuku nyajil, ngaykuwundu junkurrdu yurrangan ngalu-ngalu-bungalda.” ");
INSERT INTO gvn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wawu yinyamun Saturdaymunbu jana Jesus jinabu dungay-dungarin. Jana mayi wheat paddockmundurr dungan-dungarin, mayiburr wheatmundurr. Nyungu jawun-karra 12-bala dakwuy. Jana mayi wheat mujan, nukan. ");
INSERT INTO gvn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jana Pharisee-warrangka yinya nyajin, jana Jesusanda yalaman, “Nyaka, nyiku Saturday. Nganandamundu lawmundu ngananin kiril workmanijinya Saturdaymundurr. Jana yinya mayi kari mujanyaku Saturdaymunbu.” ");
INSERT INTO gvn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesusangka yalaman, “Yurra nguba Godumu kaban kariku nyajin. Jana David ngadiku dakwuynji bundandan, jana wanjarrman? ");
INSERT INTO gvn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ngadiku nyulu, nyungu jawun-karra dakwuyman, Godundumunbu bayanba walan, mayi bread nukan. Jana bread wanyamba nukan? Bread bamangka Godundu dajin. Lawmundu yinya yalarrku kiril, yinya bread nukanka. Jana maja-majangkaku priest-warrangkaku yinya bread nukanyaku. ");
INSERT INTO gvn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yurra nguba Mosesamu kaban kariku nyajin. Maja-maja Godundumunku bayanka, jana Saturdaymundurrku workmanijika Godundumunbu bayanba, yinyaynka jana law dumbarrinya. Yamba jana malaji kari, Godungku jananin kari nyuyal. ");
INSERT INTO gvn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngayu yurranda balkal, maja jirray yaluy, nyulu jarra jirray Godundumunku bayanka. ");
INSERT INTO gvn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godundumundu kukubu balkal, ‘Ngayu bama nyajinka manun-manunmanya. Kaki bama kari manun-manunmal, ngayu wawu kari minyaka nyungundumun.’ Kaki yurra yinyaynka kukuku mumbarku binalmalda, yurra bama ngulkurr kari nyuyal baja. ");
INSERT INTO gvn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngayu yaba wubulbuku. Ngayu maja Saturdaymunku.” ");
INSERT INTO gvn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus dungaynda, Jew-warrandamunbu churchmunbu dungan. ");
INSERT INTO gvn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nyubun bama, nyungu mara wulan. Kanbal bama yinyaymba, jana Jesus nyuyanka buyun-damanka. Yinyaynka jana nyungun babajin, “Kaki yundu bama bambaymun ngulkurr-bungal Saturdaymunbu, yundu ngananga law buyun-damal?” ");
INSERT INTO gvn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesusangka yalaman, “Nguba yunu sheep nyubunku. Nyulu sheep nguba bulkajimunbu daray Saturdaymunbu. Yundu wanjarrmalda? Yundu sheep karrbal, bulkajimun jarra-kulbal. ");
INSERT INTO gvn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","God bamanka wawu jirray jarra sheepmunku. Yinyaynka nganandamundu lawmundu bama kari kiril ngulkurr balkanka Saturdaymunbu.” ");
INSERT INTO gvn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nyulu yalamanda dingkaranda mara-wulanyamunbu, “Yundu mara yunga.” Nyulu dingkarangka mara yunganda, mara ngulkurrmanda, yala nyungu yindu mara. ");
INSERT INTO gvn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yinyamun jana Pharisee-warra dungarinda, ready-bunganka Jesus kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesusangka kuku nyajin jana nyungun kuninka, nyulu yinyamun bubumun dungan. Bama wubulku nyungunin wukurrin. Nyulu bama wubulku bambaymun ngulkurr-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nyulu jananda balkan, “Yurra nganya kari balka bamanda kanbalba.” ");
INSERT INTO gvn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nyulu kuku ngulkurr balkan, Godumu kuku manubajamanka, prophetangka Isaiahangka ngadiku Godundumunbu kabanba balkanya. Yinya kuku yalaku: ");
INSERT INTO gvn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yurra, nyaka. Yanyu ngayku workingman. Ngayu nyungun wangkanin. Ngayu nyungunku wawu jirray, wawurr-wawurrmal nyungunku. Ngayu ngayku wawu nyungundu yungal, nyulu kuku yirrkay bamanda Gentile-warranda bubungu yiringkurrku. Nyulu balkal, ‘Kaki bama Godunku junkayku bunday, Godungku nyungun juran-bungal bayamun.’ ");
INSERT INTO gvn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nyulu kari murru-kangaway, nyulu kari yaykarrku yirrkay, nyulu kari kuku yaykarrdaku balkal baraldarr. ");
INSERT INTO gvn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nyulu ngulkurrmal bamanka, jananga wawu kima Godunku, nyulu manun-manunmal yalaynka bamanka. Nyulu kari kunbay baja. Juma nyulu buyun-buyun kunbay-manil. Nyulu bama buyun-buyun wubulku courtcasemunbu wundil. ");
INSERT INTO gvn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jana bamangka Gentile-warrangka nyungun kuku nyajil, nyungun wawubu kujil.” ");
INSERT INTO gvn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wawu yinyamun kanbalda bamangka dingkar nyubun Jesusanda wundin. Nyulu miyil-burra, kuku kari. Nyulu dubunji; yinyaynka nyulu miyil-burra, kuku kari. Jesusangka nyungun ngulkurr-bungan. Yinyamun nyulu kukujimanda, miyilda nyajinda. ");
INSERT INTO gvn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bama wubulku kungkurr-kadarin, Jesusangka nyungunin dingkar ngulkurr-bunganya. Jana yalaman, “Yanyu nguba bamala Davidandamun, nguba kari.” ");
INSERT INTO gvn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jana Pharisee-warrangka yinya kuku nyajin, jana yalaman, “Nyulu dubu-dubu kangal, yamba nyulu junkurr manil dubu-dubundumun majandamun.” ");
INSERT INTO gvn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus binal jana wanyu milkabu kujil-kujin, nyulu jananda yalaman, “Kaki bama bubu muruku jana-karrajiku ngami-ngamimal, jana junkurr karimal. Bama yindu-yindu kaday, jananji kuniwanka, jananin kunbay-manil. Kaki bama nyubunyimba townmunbu or nyubunyimba familymunbu kuniway, jana kari ngadingka bunday baja. ");
INSERT INTO gvn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kaki dubu-dubu jana-karrajiku kangaway, jana ngami-ngamimalkuda. Jana kunbayda, kari ngadingka bunday baja, junkurr karimal. ");
INSERT INTO gvn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yurra jurrilman, balkan majangka dubu-dubundumundu ngayku junkurr dajin, dubu-dubu kanganka. Yamba yurrandamundu jawun-karrangka yalarrku dubu-dubu kangal. Wanjungku jananda junkurr dajin? Godungkuku. Majangka dubu-dubundumundu kari. Yurra jananin nyajil dubu-dubu kanganya, yurra binalda, jana junkurr Godundumun manin. Yurra nganya nyajil dubu-dubu kanganya, yurra yalarrku binalmanyaku ngayu junkurr manin Godundumun. ");
INSERT INTO gvn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Godundumunduku Wawubuku nganya junkurrji-bungan dubu-dubu kanganka. Yinyaynka yurra binalmanyaku ngayu Godundumun kadan, ngayku bama ngulkurrduku kujinka. ");
INSERT INTO gvn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bama nguba dingkarandamunbu junkurrjimunbu bayanba walanka, yamba-yamba ngakinka. Wurrmay-bakangka dingkarangarr karrabu kajal. Yinyamun nyulu yamba-yamba ngakilkuda bayanmun. ");
INSERT INTO gvn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kaki bama ngaykunku wawu kari, nyulu nganya buyun-damal. Kaki bamangka bama yindu-yindu kari mujal ngaykundu wundinka, nyulu jananin ngami-ngami-bungalkuda ngaykundumun. ");
INSERT INTO gvn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yinyaynka ngayu balkal yurranda. Kaki bama buyun-buyunmun jurrkiji, God bamandamunku buyun-buyunku wubulkuku milka-wulay. Nyulu yalarrku milka-wulay janandamunku kukuku buyun-buyunku. Kari. Kaki bamangka buyun balkal Godundumunku Wawuku, God yinyaynka kari milka-wulay. Jana bamangka wuljaljiku yinya buyun-buyun kujil. Godungku kari bajaku kidal. ");
INSERT INTO gvn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ngayu yaba bamanga wubulbuku. Kaki bamangka kukubu nganya buyun-damal, Godungku yinya buyun kidal. Kaki bamangka kukubu Godumu Wawu dayirr buyun-damal, Godungku yinya buyun kari kidal. God wuljaljiku kari milka-wulay.” ");
INSERT INTO gvn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesusangka yalaman baja, “Kaki bamanga juku ngulkurr, nyulu mayi ngulkurr mujal. Kaki nyungu juku buyun, nyulu mayi buyun mujal. Yundu jukungu mayi nyajil, yundu binalmalda jukuku, nguba ngulkurr, nguba buyun. ");
INSERT INTO gvn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yurra yala jarba kuliji. Yurra kari kuku ngulkurr balkal, yurra buyun-buyunku bundandanya. Yurranga wawu buyun, yurra kukuku buyun-buyunku balkaway. ");
INSERT INTO gvn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaki bamanga wawu dayirr, nyulu kukuku ngulkurrku balkaway. Kaki bamanga wawu buyun-buyunjiku, nyulu kukuku buyunku balkaway. ");
INSERT INTO gvn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ngayu yurranda balkal, bama wubulku juma jakalba Godundu janay, courtcasemunku. Jana wubulduku Godundu mala-yirrkay, yalamal, ‘Ngayu wumba balkan, ngayu kiru-kari.’ ");
INSERT INTO gvn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Godungku kanbal bama bada-bada bayanga yungal, bama kukuku buyunku balkawanya. Godungku kanbal wangkar-wangkar heavenba yungal, bama kukuku ngulkurrku balkawanya.” ");
INSERT INTO gvn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wawu yinyamun kanbalda teacher-teacherangka, kanbalda Pharisee-warrangka, jana Jesusanda yalaman, “Teacher, nganjin nyajinka, yundu junjuy miracle milbi Godundumundu junkurrdu. Yundu milbi, nganjin binalda, yundu Godundumun.” ");
INSERT INTO gvn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesusangka jananda balkan, “Yurra bama buyun bajaku, Godundumun jurrkijin. Yurra miracle nyajinka, yamba ngayu kari milbil yurranda. Ngadiku prophetangka Jonahngka balkan ngaykunku. Yurra yinya nyajin Godundumunbu kabanba. ");
INSERT INTO gvn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngadiku kuyungku yalbaynja Jonah yurmbin, waralba kujin. Warngku kulurman kuyungku Jonah kalji-manin bubungu. Ngayu yala Jonah. Ngayu wulay, warngku kulurmal ngayu juranmal baja. Ngayu yaba bamanga wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nyulu Jonah, nyulu townbu Nineveh dunganda, bamanda balkan Godundumunku kukuku. Jana wubulduku Godumu kuku nyajin, buyun-buyunmun jurrkijinda Godundu. Ngayu jarra jirray Jonahnka. Yamba yurra, bama wubulduku nyiku bundandari, yurra nganya warmbil, kari believeim-bungal. Juma bama wubulku jakalba Godundu janay, courtcasemunbu. Yurra ngaykundu kari milka-jananya, bamangka Ninevehmunku yurranin nyuyal.” ");
INSERT INTO gvn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jesusangka jananda balkan baja, “Nyubun jalbu, Queen of Sheba, nyulu yurranin yalarrku nyuyal. Nyulu nyunguwunmun bubumun kala-kalbaymun kadan, milka-jananka King Solomonanda. King Solomon binal bajaku. Queen of Sheba binalmanka King Solomonandamun. Ngayu jarra jirray King Solomonanka, yamba yurra ngaykundu kari milka-janan.” ");
INSERT INTO gvn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesusangka yalaman baja, “Dubu nyubun nguba bamandamun wandil, bububurr marraldarr dungay, bamanda yinduymbu walanka. Yamba nyulu bama yindu kari warrmba-bungal walanka. ");
INSERT INTO gvn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nyulu Dubu nyuluku balkaway, ‘Ngayu dungay baja yinyayandaku ngaykuwunbuku bamandaku.’ Nyulu dungay, nyajilda Godumu Wawu kari walanya. ");
INSERT INTO gvn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nyulu yinyangka dubungku dubu yindu-yindu 7-bala kunjalda, jana jarra buyun nyungunku. Jana nyungundu bamanda walalda. Yinyamun nyulu bama buyunmalarrku. Bama buyun nyiku bundanday, jana yala nyulu, buyunmalarrku.” ");
INSERT INTO gvn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus, nyulu balkan-balkawan bamanji, ngamu nyungu kadan, yabaju-karra kadarin. Jana ngalkalba janarin, babajin nyungunji balkawanka. ");
INSERT INTO gvn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nyubunyinja bamangka nyungundu yalaman, “Nyaka, yunu ngamu, yunu yabaju-karra, jana ngalkalba janjanari. Jana yununji balkawanka.” ");
INSERT INTO gvn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesusangka babajin, “Wanju ngayku ngamu? Wanju ngayku yabaju-karra?” ");
INSERT INTO gvn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nyulu marabu milbin nyunguwunbu jawun-karranda, yalaman, “Nyaka. Jana jalbu-jalbu yala ngayku ngamu. Jana dingkar-dingkar yala ngayku yabaju-karra. ");
INSERT INTO gvn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kaki bama ngaykuwunbu nganjananda heavenba milka-janay, nyulu ngayku jawunkuda. Nyulu yala ngayku yabaju, ngayku jinkurr, ngayku ngamu.” ");
INSERT INTO gvn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nyulu Jesusangka same day bayan bawan, jalunbu dungan, bundan, bama binal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bama wubulku murumarin nyungundu. Yinyaynka nyulu boatbu walan, bundan. Jana bama wubulku jukaranga janjanarin. ");
INSERT INTO gvn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nyulu janangan binal-bungan junjuy-junjuynku storymundu. Nyulu yalaman, “Ngadiku nyubun bama dungan, mayi diburr corn ngami-ngamiku yilbanka bubungu, gardenba. ");
INSERT INTO gvn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nyulu diburr yilbal-yilban, kanbal diburr baraldarr daran. Jana dikal kadarin, nukal-nukajinda. ");
INSERT INTO gvn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Diburr kanbal daran bubungu kulji-kuljingaku, yinyaymba bubu wawu-darra kuljiburr. Jurrbu jinbalku wandirin, yinya bubu wawu-darra. ");
INSERT INTO gvn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wungar jalaman, jurrbu nganjaymanijin, ngara buban. Jurrbu wulaynda. ");
INSERT INTO gvn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kanbal diburr daran buljunbu bukul-bukuljirrba. Buljun jirraymaynda. Buljundu jurrbu kanbin, jurrbu kari jirraymanda. ");
INSERT INTO gvn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Diburr kanbal bubungu ngulkurrbu daran, mayi corn balkajin. Kanbalba jurrbungu mayi jirray balkajin, mayi 100-bala. Kanbalba mayi jarra buban balkajin, 60-bala. Kanbalba mayi buban balkajin, 30-bala.” ");
INSERT INTO gvn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jesusangka yalaman, “Kaki yurra binalmanka, yurra milka-janay mumbarku.” ");
INSERT INTO gvn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yinyamun nyungu jawun-karra 12-bala Jesusanda kadarin, nyungundu babajin, “Yundu wanyurrinku jananin binal-bungal storybu?” ");
INSERT INTO gvn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nyulu jananda yalaman, “Ngayu yurranin binal-bungan-bungal Godundumunku kukuku, Godungku nyungu jawun-karra ngulkurrduku kujinka. Godungku kuku nyungu kari kanbin yurrandamun, yamba janandamun yinya kuku kanbinkuda. ");
INSERT INTO gvn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kaki bama ngaykundu mumbarku milka-janay, ngayu nyungunin binal-bungal baja. Nyulu binalmalarrkuda. Kaki bama ngaykundu kari mumbarku milka-jananka, nyulu milka-wulay yinyaynka kukuku. ");
INSERT INTO gvn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yinyaynka ngayu jananin storybu binal-bungal-bungal. Kaki jana miyilda nyajinka, jana kari nyajil. Kaki jana milkabu nyajinka, jana kari nyajil. Jana kari binalmalda. ");
INSERT INTO gvn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nyulu prophetangka Isaiahngka ngadiku jananka mumbarabuku balkan. Nyungu kuku manubajamaynda. Nyulu balkan, ‘Yurra nyajin-nyajil, yamba yurra binal kari. ");
INSERT INTO gvn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yurra dukul-dandiman, Godumu kuku milkanga kari kujil. Yurra milka nandajin, Godumu kuku kari nyajinka. Yurra miyil nandajin, wawu kari binalmanka Godundumunku kukuku. Godungku yalaman, “Ngayu jananin ngulkurr-bunganka, yamba jana ngaykundu kari jurrkiji.” ’ Isaiahngka yalaku kuku balkan.” ");
INSERT INTO gvn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jesusangka nyunguwunbu jawun-karranda yalaman, “Yurra kari yala jana. Yurra mumbarku milka-janay, mumbarabuku nyajil, binalmanka mumbarku. Yinyaynka yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngayu yurranda manubajabuku balkal. Prophetangka wubuldu, and Godundumundu bamangka nyajinka yala yurra nyajilda, yamba jana murruji nyajil.” ");
INSERT INTO gvn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesusangka yalaman baja, “Nyakada, binalmaka yinyaynka storyka diburrku. ");
INSERT INTO gvn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kaki bamangka kuku nyajil Godundumunku kukuku yamba jana kari milkabu kujil, jana yala diburr baraldarr daran. Nyulu Dubu kaday, Godumu kuku bangkal janandamun. ");
INSERT INTO gvn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kanbal diburr daran kulji-kuljinga. Yinya yala wanyu? Yinya yala bamangka Godumu kuku nyajil, wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yamba yinya kuku buban milkanga kadan jananda, jana bubanku believeim-bungal. Kaki jana troubleji Godundumunku kukuku, jana jinbalku jurrkiji Godundumun. ");
INSERT INTO gvn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kanbal diburr daran buljunbu bukul-bukuljirrba. Kanbal bama yalaku. Jana Godumu kuku nyajil, yamba jana jumbun yamba-yambaka. Jana money jirray maninka, junjuy-junjuy wubulku maninka. Yamba-yambaka jumbunmanyamundu Godumu kuku kanbil yala buljundu jurrbu kanbil, mayi kari balkajinka. ");
INSERT INTO gvn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kanbal diburr daran bubungu ngulkurrbu. Kanbal bama yalaku. Jana Godumu kuku nyajil, milkanga kujilda, wukurrilda. Jana Godunku workmalda. Ngulkurr Godunku workmanijinka. Kanbal bubanku workmal Godunku, kanbal jarra yalbayku workmal, kanbal yaykarrku workmal Godunku. Jana wubulku ngulkurrku workmal, Godunku.” ");
INSERT INTO gvn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesusangka story yindu balkan. Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujil. Yinya yala yanyu story. Nyubun dingkar, nyulu mayi wheat diburr ngulkurr ngami-ngamiku yilban nyunguwunbu gardenba. ");
INSERT INTO gvn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wujurrman, bama wubulku warngku wunanan. Kari, bama kuli-baka kadan, diburr buljun ngami-ngamiku yilban diburrdurr wheatmundurr, kunban, dungan baja. ");
INSERT INTO gvn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yinyamun jurrbu dakarin, mayi wheat balkajin. Yala-yalabi buljun yalarrku dakarin. ");
INSERT INTO gvn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nyungu dingkaramu workingman kadan, nyungundu yalaman, ‘Maja, yundu diburr ngulkurr ngami-ngamiku yilban yunuwunbu gardenba. Buljun wanjamun kadan?’ ");
INSERT INTO gvn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Majangka yalaman, ‘Yinya bama kuli-baka kadan, diburr buljun yilban.’ Jana workingmanangka babajin, ‘Yundu wawu nganjin buljun kulbanka?’ ");
INSERT INTO gvn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nyulu yalaman, ‘Kari. Buljun kulbal, wheat yalarrku kulbanji. ");
INSERT INTO gvn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bawa. Balu mayi wheat, buljun muruku jaba-jabamaka. Mayi kulbulmal, ngayu workingmananda balkal buljunngurr kulbanka, kajanka, bayanga yilbanka. Yinyamun jana mayi wheat mujal, yijarril ngaykuwunbu bayanba.’” ");
INSERT INTO gvn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesusangka yindu story balkan. Nyulu balkan, “Godungku nyungu bama ngulkurrduku kujil. Yinya yala yanyu story. Dingkarangka diburr mustard manin, nyunguwunbu bubungu nandan. ");
INSERT INTO gvn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yinya diburr karrkay bajaku. Nyulu yinya jurrbu dakal, yalbay bajaku duduynku kanbalka. Nyulu jukumalda, dikal kadari, bulka balkal dakil-dakilba.” ");
INSERT INTO gvn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesusangka story yindu balkan baja. Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujil. Yinya yala yanyu story. Jalbungku flour manin, yeast manin, dingkanda. Juma yinya flour wubajinda. Yalbaymankuda yeastmun bubanmun.” ");
INSERT INTO gvn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesusangka bamanda wubulbuku balkan story yindu-yindu, storybuku binal-bungal-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nyulu storybuku binal-bungan, Godumu kuku manubajamanka. Prophetangka ngadiku balkan, “Ngayu jananin binal-bungal storybuku. Ngayu kuku balkan-balkal, kuku Godungku kari balkan jakalbaku. Nyulu bubu balkanjiku, yinya kuku wunanan, yamba nyulu bamanda kari balkan. Kari, ngayuku balkal-balkalda.” ");
INSERT INTO gvn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesusangka bama wubulku bawan, bayanba walan. Nyungu jawun-karra 12-bala kadarin, nyungundu yalaman, “Nganjinanda balka yinyaynka kukuku buljunku. Wanyu yinya?” ");
INSERT INTO gvn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesusangka yalaman, “Nyulu dingkarangka yinya diburr ngulkurr ngami-ngamiku yilban, nyulu yala ngayu. Ngayu yaba bamanga wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nyungu garden yala yanyu bubu yiringkurrku. Diburr ngulkurr yala jana jawun-karra Godumu. Buljun yala jana jawun-karra Dubumu. ");
INSERT INTO gvn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nyulu kuli-bakangka buljun diburr gardenba yilban, nyulu yala Dubu. Jana workingmen yala angel-angel, jiri-warra. Juma bubu kunbay. Angel-angelangka Godumu bama mujalda. Mayi kulbul yala Godumu bama angel-angelangka mujal. ");
INSERT INTO gvn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Ngayu yaba bamanga wubulbuku. Bubu kunbay, ngayu ngayku angel-angel yungal. Jana bama buyun wubulku mujal, ngami-ngami-bungal bamandamun ngulkurrmun. Yinya yala story, jana workingmenangka buljun mujan, wayjun. ");
INSERT INTO gvn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jana bama buyun bayanga yilbalda. Yinyaymba jana badi, warrngkay-warrngkay, dirra majajikuda. ");
INSERT INTO gvn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yinyamun Godumu bama wubulku dayirrmal, Godundumunbu bubungu. Jana balbal yala wungarabu. Kaki yurra binalmanka, mumbarku milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesusangka jananda story yindu balkan. Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujinka. Yinya yala yanyu story. Dingkarangka nyubunyinja kulji money jirray warrmba-bungan bubungu, yamba yinya bubu nyungu kari, nyulu money murruji manil. Nyulu nandan baja, wawurr-wawurrmanijin moneyka. Yinyamun nyulu yamba-yamba wubulku sellim-bungan, yinya bubu buy-im-bunganka, yinya money maninka.” ");
INSERT INTO gvn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesusangka story yindu balkan. Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujinka. Yinya yala yanyu story. Nyubunyinja dingkarangka kulji pearls ngulkurrijin nubil-nubil, buy-im-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nyulu nyubun warrmba-bungal. Nyulu dungay, yamba-yamba wubulku sellim-bungal, yinya kulji pearl ngulkurrijin buy-im-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesusangka yindu story balkan. Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujil. Yinya yala yanyu story. Kanbalda dingkar-dingkarangka makarr yilban kuyu-kuyunku, kuyu walu-yindu walu-yindu manin, makarrda. ");
INSERT INTO gvn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Makarr kulngkulman. Jana jukaranga kulban, bundan, minya kuyu ngami-ngami-bungan. Minya kuyu ngulkurr jana bucketba yijarrin, minya kuyu buyun jana yilban baja. ");
INSERT INTO gvn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yinyarrin dingkar-dingkar yala angel-angel. Jana angel-angelangka bama buyun ngami-ngami-bungal bamandamun ngulkurrmun. Wawu yinyamun bubu kunbay. ");
INSERT INTO gvn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jananin bayanga yilbalda. Yinyaymba jana badi, warrngkaykuda, dirra majajikuda.” ");
INSERT INTO gvn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesusangka jawun-karranda babajin, “Yurra yinyaynka kukuku binal?” Jana yalaman, “Yuwu, binalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesusangka jananda yalamanda, “Jana teacher-teacher lawmunku, jana kanbal ngaykundu mambarrijin. Jana binal bajaku lawmunku ngadimunku, yalarrku binalmalmal Godundumunku waymunku jirakalmunku. Jana yala bama bayanji. Nyulu ngadiku yamba-yamba mujan, yinya yamba-yamba mukulmaynda. Nyulu yamba-yamba jirakal maninda. Nyulu jambulinjida, mukul, jirakal. Jambulurr ngulkurr, mukul, jirakal.” ");
INSERT INTO gvn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesusangka story kunbay-manin, nyulu yinya bubu bawan. ");
INSERT INTO gvn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nyulu nyunguwunbuku bubunguku dungan baja. Nyulu Jew-warrandamunbu churchmunbu walan, bama binal-bungan. Jana bamangka nyungun nyajin, kungkurr-kadanda, yamba warmbin. Jana-karrajiku yalaman, “Nyulu binal bajaku. Wanyandamun nyulu manin? Nyulu junjuy-junjuy miracle junkurr-murubuku balkal. Wanyandamun nyulu junkurr manin? ");
INSERT INTO gvn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nyulu kangkal carpentermu. Mary nyungu ngamu. Jana James, Joseph, Simon, Judas, jana nyungu yabaju-karra. ");
INSERT INTO gvn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nyungu jinkurr-karra yalaymba bundanday. Wanyandamun baja nyulu binalman?” ");
INSERT INTO gvn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yinyaynka jana nyungunku wawu kari. Jesusangka jananda yalaman, “Kaki prophetangka Godumu kuku balkal yiringkurrku, bama mumbarku milka-janay. Yamba nyulu nyunguwunbuku bubunguku dungay, jawun-karrandaku, jana jawun-karra nyungundu kari milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nyulu miracles Godundumundu junkurrdu kari balkan yinyaymba, jana nyungun warmbinya, kari kuku nyajinya. ");
INSERT INTO gvn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yala-yalabi Herod, nyulu maja jirray bubuku Galileemunku. Nyulu kuku nyajin Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nyulu balu Jesus nyajin John the Baptist. Nyulu nyunguwunbu workingmenanda yalaman, “John The Baptist juranman baja yarkinmun; nyulukuda Jesus. Yinyaynka nyulu junkurrji, miracle balkanka.” ");
INSERT INTO gvn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Philip, nyulu yabaju Herodamu. Herodangka ngadiku Philipamu manyarr ngakin, kujin, manyarr-bungan. Manyarr burri Herodias. Johnungku Herodanda yalaman, “Yundu yabajumu manyarr kari wunanyaku. Nyungun bawa.” Herod bula Herodias kuli-kadaynda, soldier-soldier yungan John karrbanka, jailba mumbanka. ");
INSERT INTO gvn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodangka John yarkinkaku kuninka, yamba nyulu yinyilman bamanka Jew-warranka. Jana bama Jew-warra jana-karrajiku balkawan, “Nyulu Johnungku Godumu kuku manubajakuda balkal-balkal.” ");
INSERT INTO gvn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodamu birthdayman, nyulu party haveim-bungan. Bama wubul partynga kadan. Herodiasamu kangkal maral wurin jakalba jananda. Herod wawurr-wawurrman nyungunku. ");
INSERT INTO gvn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herodangka maralanda yalaman, “Ngayu wanyu yunu dajil? Yundu wanyurrinku wawu? Ngayu yunu dajilkuda. Jana yindu-yinduynju nganya nyajin yunun wawurr-wawurr-bunganya. Ngayu dajilkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Maralangka nyunguwunbu ngamundu babajin, “Ngayu wanyurrinku babaji?” Ngamungku yalaman, “Yundu babajika Johnundumunku dukulku.” Yinyamun maralangka Herodanda babajin, “Yundu Johnumu dukul ngaykundu daya platemunbu.” ");
INSERT INTO gvn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nyulu King Herod milka-bujarmanda. Yamba nyulu murruji kuku jurrkinka, jawun-karrangka nyungun nyajinya maral wawurr-wawurr-bunganya anything dajinka. Yinyaynka nyulu dajinka. ");
INSERT INTO gvn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nyulu kuku yungan jailmunbu, jana Johnumu dukul nyandanka. ");
INSERT INTO gvn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jana dukul plateba yijarrin, maralanda dajin. Nyulu maralangka ngamundu dajin. ");
INSERT INTO gvn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Johnundumundu jawun-karrangka nyungun yarkin manin, nandan. Yinyamun jana dungarin, Jesusanda balkan. ");
INSERT INTO gvn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesusangka yinya kuku Johnunku nyajin, nyulu yinyamun bubumun boatji dungan, bubungu jirrbu-jirrbungu. Jana bamangka nyajin nyungun dunganya, jana town-townmun dungarin, nyungun jinabu wukurrin. ");
INSERT INTO gvn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nyulu Jesus boatmun jalaman bubungu, nyulu bama wubul nyajin yinyaymba. Nyulu jiba-badin jananka, jananin ngulkurr-bungan bambaymun. ");
INSERT INTO gvn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yilaylayman, nyungu jawun-karra 12-bala nyungundu kadarin, yalaman, “Yanyu bubu jirrbu-jirrbu, mayi yamba-kari, yilaylaymanda. Jananin bama yungada, townbu dunganka, mayi maninka janangaku.” ");
INSERT INTO gvn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yamba Jesusangka yalaman, “Jana wawubu kari dungay. Yurraku jananda mayi daya.” ");
INSERT INTO gvn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jana yalaman, “Nganjinanga mayi bread 5-balaku, minya kuyu jambulku.” ");
INSERT INTO gvn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusangka yalaman, “Ngaykundu wundi.” ");
INSERT INTO gvn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nyulu bamanda wubulbuku balkan jikanba bundarinka. Yinyamun nyulu bread 5-bala, minya kuyu jambul manin, jiri nyajin, God thankim-bungan mayika, minyaka. Jesusangka mayi and minya dumbarrin, jawun-karranda dajin. Jawun-karrangka bamanga wubulbuku wamban. ");
INSERT INTO gvn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bamangka wubulduku nukan, yanjimankuda. Jana basket 12-bala jakal-bungan mayibu yandaynja. ");
INSERT INTO gvn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dingkar-dingkarangka 5000-balangka mayi nukan. Janawundu jalbu-jalbungku, kangkal-kangkalangka yalarrku nukan. ");
INSERT INTO gvn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesusangka jawun-karra 12-bala jakalba yungan, naka-naka jalunbu boatji. Nyulu bama wubulku bayanbaku yunganda. ");
INSERT INTO gvn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yinyamun nyulu wuburrbu nyulurrku dakan, balkawanka Godunji. Wujurrmanda, nyulu nyulurrku yinyaymba bundan. ");
INSERT INTO gvn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jana jawun-karra boatji dungan-dungarin jalunbu dindarra, kala-kalbay bubumun. Jarramali yaykarrku kadan. Jana birungubaynja murruji manin, muyarabu boat yimbal-yimban. ");
INSERT INTO gvn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mudu-wayjunjiku, Jesus jananda kadan. Nyulu jalunbu wuyar-wuyar jinabuku kankadan. ");
INSERT INTO gvn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jana jawun-karrangka nyungun banaburr nyajin wuyar-wuyar kankadanya, jana yinyilmarinya, yararrin. Jana yalaman, “Nyulu yinya Dububi!” Jana yirrkan, yinyilmarinya. ");
INSERT INTO gvn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nyulu jananda yalamanda, “Bangkarr dandimaka, ngayu Jesus. Kari yinyilmaka.” ");
INSERT INTO gvn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peterangka nyungundu yalaman, “Maja, kaki yundukuda, nganya kunja, ngayu yunundu kadanka.” ");
INSERT INTO gvn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesusangka yalaman, “Kadayda.” Peter jalaman, banaburr wuyar-wuyar dungan Jesusanda. ");
INSERT INTO gvn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yamba nyulu nyajinda, muyar, mulngku. Nyulu yinyilmanda, bada dungan-dungaynda. Balu bujil-janjilkuda. Nyulu yirrkan, “Maja, karrbada!” ");
INSERT INTO gvn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesusangka jinbaldaku Peter karrban, nyungundu yalaman, “Yundu nganya kari warmbinyaku. Nganya believeim-bunganyaku.” ");
INSERT INTO gvn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bula boatbu dakan, muyar kunbaynda, jalun marrkamanda. ");
INSERT INTO gvn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jana boatbuku nyungun buyay-manin, yalaman, “Yundu Godumukuda kangkalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jana naka-naka dungarin, bubungu Gennesaretba kadarin. ");
INSERT INTO gvn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jana bamangka yinyaymba Jesus nyungun-bungan, kuku yungan bamanda wubulbuku yiringkurrku yinyaymba bubungu. Jana bambay-bambay wubulku nyungundu wundin. ");
INSERT INTO gvn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jana Jesusanda babajin, bambay-bambaynja nyungu kambi karrbanka. Jana bambay-bambaynja Jesusamu kambi karrban, ngulkurrmaynda. ");
INSERT INTO gvn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wawu yinyamun jana Pharisee-warra and jana teacher-warra, jana Jesusanda kadarin townmun Jerusalemmun. Jana Jesusanda babajin, ");
INSERT INTO gvn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Wanyurrinku yunuwundu jawun-karrangka 12-balangka law ngujakura kari wukurril? Jana kari mara julurriji, mayi nukanka. Jana law ngujakura darrbil-darrbil.” ");
INSERT INTO gvn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesusangka yalaman, “Yurra yurrangaku kuku wukurril-wukurril. Yamba yurra God kari kuku nyajil. ");
INSERT INTO gvn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Godungku ngadiku yalaman, ‘Yurra bulanin ngamu, nganjan kuku nyakaku, milka-janay. Kaki bamangka ngamu, nganjan yukil, yurra nyungun kuniyarrku.’” ");
INSERT INTO gvn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jesusangka jananda yalaman baja, “Kari. Yurra yinya Godumu kuku walu-yindu-bungan. Yurra wadu-waduku balkalda, ‘Bama nyubun nguba junjuynji, ngamundu, nganjananda dajinka, bulanin helpim-bunganka. Yamba nyulu nguba wawu kari bulanda dajinka. Yinyaynka nyulu Godundumunbu bayanba wundi, kanbal priest-warranda dajinka, kanbal wundinka baja bayanbaku.’ ");
INSERT INTO gvn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yinyamun nyulu kari bulanda dajil baja, bulanin kari ngulkurrduku kujil baja. Yurra Godumu kuku bawan, yurrangaku kuku wukurril-wukurrilda. ");
INSERT INTO gvn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yurra bulu-duraykuda. Nyulu prophetangka Isaiahangka ngadiku Godumu kuku manubajabuku balkan yurranka. Nyulu balkan, ");
INSERT INTO gvn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Godungku yalaman, “Jana bamangka nganya buyay-manil ngandalda, yamba jana ngaykundumun jurrkijin. Bulu-duray bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jana nganya wumbabuku buyay-manil. Jana bamandamunku kukuku binal-bungal, balu Godumu kuku. Jana kari binal-bungal kukuku manubajaka.” ’” ");
INSERT INTO gvn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesusangka bama nyungundu kunjan, jananda yalaman, “Yurra milka-janay; binalmaka; kuku nyakaku. ");
INSERT INTO gvn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kaki yundu mayi nukal, yundu yinya mayi ngandalba walay-manil. Yinyangka mayibu yunun kari buyun-damal. Kaki yundu kuku buyun-buyun balkal, yinya kuku ngandalmun dakal. Yinyangka kukubu yunun buyun-damalda, yunundumun ngandalmun dakanya.” ");
INSERT INTO gvn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yinyamun nyungu jawun-karra 12-bala nyungundu kadarin, yalaman, “Yundu binal jana Pharisee-warra yinyaynka kukuku wawu kari? Jana kuli-kadarin yununku.” ");
INSERT INTO gvn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Jesusangka yalaman, “Jananin Pharisee-warra bawa, kari kuku nyaka. Jana Godundumunbu baralba bama wayanka, yamba jana binal kari. Jana yala miyil-kari. Jana bama miyil-kari yindu-yindu wayanka. Kaki miyil-karingka yindu bama miyil-kari wayal, bula jambulurr jankungu daray.” Jesusangka yalaman baja, “Kaki ngaykuwundu nganjanangka diburr nandal, yinya jurrbu junkayku janay. Kaki Nganjanangka kari nandal, yinya jurrbu kulbaji baja.” ");
INSERT INTO gvn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peterangka yalaman, “Yinya kuku balka, milkanga-bunga.” ");
INSERT INTO gvn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesusangka babajin, “Yurra yinyaynka kukuku kariku binal? ");
INSERT INTO gvn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kaki yundu junjuy-junjuy nukal, yinyamundu mayibu yununin kari buyun-damal. Mayi waralba walal, kari bunday, juma wandil baja. Yinyamundu mayibu yunun kari buyun-damal. ");
INSERT INTO gvn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yundu kuku buyun balkal ngandalda, yinya yunuwunmun wawumun. Yinyamundu yununin buyun-damal. ");
INSERT INTO gvn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bamangka buyun-buyun milkabu baykal, yinya buyun-buyun bamandamun wawumun. Bamandamun wawumun wubulku buyun-buyun kadari. Kalngar-bakamanka, wawu kari marrymanka, yarkinkaku kuninka, wurrmaymanka, jurrilmanka. ");
INSERT INTO gvn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yinyamundu buyun-buyundu bama buyun-damal. Yamba bama mara kari julurriji mayi nukanka, yinyamundu bama kari buyun-damal.” ");
INSERT INTO gvn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wawu yinyamun Jesus yinyamun bubumun dungan. Nyulu dungan, bubungu yubaku townbu Tyre and Sidon. ");
INSERT INTO gvn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nyubun jalbu, nyulu bama Jew kari, bubuku Canaanmunku. Nyulu Jesusanda kadan, yalaman, “Maja, yundu Davidandamun. Manun-manunmaka ngaykunku. Ngayku kangkal dubunji, dubungku nyungun buyun-daman.” ");
INSERT INTO gvn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yamba Jesusangka nyungun bayjan, nyungundu kari balkan. Jesusamu jawun-karra 12-bala nyungundu kadarin, yalaman, “Yinya jalbu yunga. Nyulu ngananin juruku wukurril-wukurrilda, nyurra-bangkal-bangkalda.” ");
INSERT INTO gvn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesusangka yalaman, “Godungku nganya yungan bamandaku Jew-warrandaku. Jana yala sheep-sheep nubijinya, nganya yungan jananda.” Nyulu jalbu bama Jew kari. ");
INSERT INTO gvn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jalbu Jesusanda kadanda, jakalba bungkubu janan, yalaman, “Maja, nganya helpim-bunga.” ");
INSERT INTO gvn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesusangka nyungundu yalaman, “Ngayu bamandaku Jew-warrandaku kadan. Jana yala kaykay-kaykay. Nganjin kaykay-kaykayamu mayi kari kayanda yilbal.” ");
INSERT INTO gvn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nyulu jalbungku yalaman, “Yaladabi, Maja, yamba kanbal dumbul bubungu daray tablemun. Kayangka yinya dumbul nukalkuda. Ngayu yala yinya kaya. Ngayu wawu yundu ngulkurrmanka ngaykunku.” ");
INSERT INTO gvn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesusangka yinya kuku nyajin, nyulu yalaman, “Jalbu, yundu God junkurr-murubuku kuku nyajil. Yinyaynka ngayu kangkal yunu ngulkurr-bungal.” Jalbumu kangkal jinbalku ngulkurrman. ");
INSERT INTO gvn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus dungan baja, jalundurr Galileemundurr karangkaldarr dungan. Nyulu wuburrbu dakan, yinyaymba bundan. ");
INSERT INTO gvn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bama wubulku nyungundu kadarin, bambay-bambay nyungundu wundin. Kanbal barrka-buyun, kanbal miyil-burra, kanbal milka-buyun, kanbal dakil wulan, kanbal kuku kari, bambay walu-yindu walu-yindu jana wundin nyungundu. Nyulu wubulku ngulkurr-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bamangka Jesus nyajin bambay-bambay ngulkurr-bunganya. Jana kuku-kari nyajin kukujimanya; barrka-buyun nyajin jinabu warrinya; miyil-burra nyajin miyilda nyajinya; bama dakil wulanya nyajin dakil bulngal-bulngajinya. Yalaku nyajinya, God buyay-manin, God maja jirray bamamu Jew-warramu. ");
INSERT INTO gvn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yinyamun Jesusangka nyungu jawun-karra 12-bala kunjan, yalaman, “Ngayu jiba-badida jananka bamanka wubulkuku. Jana warngku kulur ngaykunji bundarinda, jananga mayi yamba-karikuda. Ngayu wawu kari yunganka jananin dakwuy-dakwuyku. Jana kunka daranji baraldarr dungan-dunganyamunburr.” ");
INSERT INTO gvn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jawun-karrangka yalaman, “Yanyu bubu marral bajaku, mayi kari. Nganjin wanjamun mayi bread manil wambanka? Bama wubul bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesusangka jananda babajin, “Yurranga mayi bread wanjarr?” Jana yalaman, “Bread 7-bala, kanbal minya kuyu kaykay-kaykay.” ");
INSERT INTO gvn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesusangka bamanda wubulbuku yalaman, “Yurra bubungu bundarika.” ");
INSERT INTO gvn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yinyamun nyulu mayi bread 7-bala, minya kuyu manin. Nyulu God thankim-bungan mayika, mayi dumbarrin, jawun-karranda dajin. Jawun-karrangka bamanda wubulbuku wamban. ");
INSERT INTO gvn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jana wubulduku nukan, yanjimankuda. Jana kurmun 7-bala jakal-bungan mayibu yandaynja. ");
INSERT INTO gvn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dingkar-dingkarangka 4000-balangka mayi nukan; janawundu jalbu-jalbungku, kangkal-kangkalangka yalarrku nukan, yanjimankuda, mayimun bubanmun. ");
INSERT INTO gvn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yinyamun Jesusangka bama wubulku bayanbaku yungan, boatbu walan, bubungu Magadan dungan. ");
INSERT INTO gvn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jana Pharisee-warra, Sadducee-warra, jana Jesusanda kadarin, nyungun catchim-bunganka kukuku. Jana nyungundu yalaman, “Yundu miracle balka Godundumundu junkurrdu. Yundu balkal, nganjin binalmalda, yundu Godundumunkuda.” Yamba jana nyungun kukuku catchim-bunganka, nyajinka buyunmanya. ");
INSERT INTO gvn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesusangka yalaman, “Wungar daray, jiri nguba ngala-ngalamal. Yurra binalda, wunkun jirimalimal. ");
INSERT INTO gvn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kaki jiri ngumbumal, yurra binalda, jarramali kaday. Yurra binal signmunku jirimun, yamba yurra binal kari yinyaynka signmunku Godundumunku. Yurra binal kari wanyurrinku nyulu balkal-balkaway. ");
INSERT INTO gvn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yurra bama buyun bajakuda. Godunku wawu kari, nyungunin bawankuda. Yurra yala jalbungku dunyu bawan, yindu-yindu dunyu-bungal-bungal. Yurra nganya mambarrinka miracle jirray balkanka Godundumundu junkurrdu, signmunku. Yurra nyajinka, ngaykunku binalmanka. Yamba ngayu miracle kari balkal. Yanyuku yurra nyajilda, ngayu juma juranmal baja yala Jonah.” Yinyamun nyulu jananin bawan, dunganda. ");
INSERT INTO gvn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jana jawun-karra 12-bala ngubar-ngubar jalunbu kadarin, milkanga kadan, mayika breadmunku milka-wularin. ");
INSERT INTO gvn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesusangka jananda yalaman, “Jana Pharisee-warra, Sadducee-warra, jana yala yeast. Yeastmundu mayi bread wubay-manil. Yurra mumbarmaka jananka bamanka, yurra buyun maninji janandamun.” ");
INSERT INTO gvn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jana jana-karrajiku balkawan, yalaman, “Ngana mayi bread kari wundinya, nyulu yinyaynka yalaku balkan.” ");
INSERT INTO gvn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesusangka jibabu nyajin jananin yinyaynka balkan-balkawanya. Nyulu jananda yalaman, “Yurra God warmbin-warmbil. Yurra wanyurrinku balkan-balkaway breadmunku yamba-karika? ");
INSERT INTO gvn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yurra kariku binalman. Yurra nguba milka-wulan mayika breadmunku 5-balaka. Ngayu yinya bread jirray-bungan, bamanka 5000-balanka. Yala-yalaku yurra kurmun wanjarr jakal-bungan mayibu yandaynja? ");
INSERT INTO gvn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yurra milka-wulan mayika breadmunku 7-balaka. Ngayu jirray-bungan bamanka 4000-balanka. Yala-yalaku yurra kurmun wanjarr jakal-bungan mayibu yandaynja? ");
INSERT INTO gvn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yurra wanyurrinku kari binalmanda? Ngayu breadka kari balkan-balkaway. Yurra mumbarmaka bamanka Pharisee-warranka, Sadducee-warranka. Jana bama wadu-waduku binal-bungal yirmbalka wubulkuku. Yinya yala yeast breadmunku.” ");
INSERT INTO gvn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yinyamun jawun-karra binalmanda. Jana binalmaynda nyulu breadka kari balkan. Nyulu yeastmunku balkan jananin binal-bunganka mumbarmanka bamanka wadu-waduku binal-bungal. Mumbarmanka bamanka Pharisee-warranka, Sadducee-warranka. ");
INSERT INTO gvn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yinyamun jana Jesus bubungu Caesarea Philippi kadarin. Nyulu jawun-karranda 12-balanda babajin, “Ngayu bamanga wubulbuku yaba. Bamangka wanyu balkal ngaykunku? Ngayu wanju?” ");
INSERT INTO gvn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jawun-karrangka yalaman, “Kanbalda balkal yundu John the Baptist. Kanbalda balkal yundu Elijah, or Jeremiah, or nguba prophet ngadimunku.” ");
INSERT INTO gvn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesusangka jananda yalaman, “Yala yurra? Yurra wanyu balkal, ngayu wanju?” ");
INSERT INTO gvn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peterangka yalaman, “Yundukuda Christ, Godungku yunun bamban. Yundukuda kangkal Godumu, nyulu God wuljaljiku juranku bunday.” ");
INSERT INTO gvn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesusangka nyungundu yalaman, “Simon, kangkal Jonahmu, yundu kuku ngulkurrduku balkan manubajabuku. Yinya kuku yundu kari manin bamandamun. Kari. Godungku heavenmun yinya kuku dukulbu-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nyaka. Ngayu yunu burri yindu dalkil, Peter. Yinya burri Peter, yinya mean kulji. Yinya kuku yundu balkan yala kulji dandi bajaku. Bamangka nganya manubajabuku believeim-bungal, ngayu Godumukuda kangkal, yinya yala nyulu dandiku janjanay kuljinga dandinga, kari bulngajinya. Ngayku jawun-karra ngayu dandi-bungal, jana nganya kari warmbinya. Jana yindu-yinduymbu balkal ngaykunku, kanbal ngaykundu mambarrijida. Yinyamundu ngayku jawun-karra wubulmalda. Jawun-karra Dubumu, and dubu-dubu, jana ngayku jawun-karra kari buyun-damal. Kari. Kaki ngayku jawun-karra wulay, ngayu wundilkuda, ngaykuwunbu bubungu. Jana juma juranmal baja.” ");
INSERT INTO gvn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jesusangka Peteranda yalaman, “Godungku nyungu jawun-karra ngulkurrduku kujil. Kaki bama ngayku jawunmanka, balu jana ngayku jawunmaka. Yinya yala ngayu yunundu key dajil, key ngaykuwunku bayanka, kanbal bama walay-maninka, kanbal kari. Yundu walay-manil, Godungku yalarrku walay-manilkuda. Yundu kanbil, Godungku yalarrku kanbilkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nyulu jawun-karranda 12-balanda yalamanda, “Yurra kuku kari wamba ngayu Christ, and Godungku nganya bamban.” ");
INSERT INTO gvn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wawu yinyamun Jesusangka jawun-karranda mumbarabuku binal-bungan nyungunkuku. Nyulu yalaman, “Ngayu must townbu Jerusalem dungay, yinyaymba warrngkanka, milka-bujarmankarrku. Jana binga-binga, maja-maja Godundumunku bayanka, teacher-teacher lawmunku, jana wubulku ngaykunku wawu kari bajaku, nganya warrngkay-manil, yarkinkaku kunil. Warngku kulurmal ngayu juranmal baja yarkinmun.” ");
INSERT INTO gvn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yamba Peter Jesusanda yuba kadan, nyungun murru-kangan, yalaman, “Maja, yundu yinyaynka kari yalaku balkanyaku. Godungku yunun ngulkurrduku kujin-kujil. Jana yunun kari yarkinkaku kunil.” ");
INSERT INTO gvn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus nyungundu jurrkijin, yalaman, “Ngaykundumun dungay. Yundu yala maja Dubu. Yinya kuku yunuwunbu milkanga kadan Dubundumun. Yundu kirinka nganya God kuku nyajinka. Yundu milkabu baykal yala bamangka, yala kari Godungku.” ");
INSERT INTO gvn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesusangka jawun-karranda 12-balanda yalamanda, “Kaki bamangka nganya wukurrinka, nyulu must milka-wulayda nyungunkuku, ngaykundu mambarrijikarrkukuda. Nyulu kari jumbunmaka moneyka, yamba-yambaka. Kaki bamangka nganya wukurril, bama yindu-yindu nyungunku wawu-karimanji. Jana kuli dajinji, yarkinkaku kuninji, jukungu walngkan-damanji. Yamba nyulu must nganya wukurrikarrku. ");
INSERT INTO gvn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kaki bama juranku bundanka, and nyunguku way wukurrinka, nyulu juma wulay. Kaki bama nyunguwunmun waymun jurrkiji, and Godumu way wukurril, Godungku nyungun juran-bungal wuljaljiku. ");
INSERT INTO gvn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bamangka nyubunyinja nguba junjuy-junjuy wubulku manin, jumbunmanya. Yinyamundu junjuy-junjuynju nyungun kari juran-bungal. Karibi! Bamangka dukuldu Godku manada, junjuy-junjuy kari. Bamangka wanjarrmal juranmanka baja? Yala kari. Godungkuku bama juran-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngayu bamanga wubulbuku yaba. Nganjin, ngayu, jiri-warra, nganjin juma kaday baja wangkar-wangkarmun. Ngayu junkurrjiku kaday, dayirrku, yala ngayku nganjan. Yala-yala ngayu bamanda wubulbuku dajil baja. Bamangka buyun balkan, ngayu jananin bada-bada yungal bayanga. Bamangka ngulkurr balkan, ngayu jananin Godundumunbu bubungu walay-manil. Ngayu yalaku dajil baja. ");
INSERT INTO gvn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngayu manubajabuku balkal yurranda yalaymba janjananya. Godungku nyungu bama ngulkurrduku kujil. Kanbalda yurra nganya nyajil majamanya, yurra wulanjiku.” ");
INSERT INTO gvn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Warngku 6-balaman, Jesusangka Peter, James, John wundin manjalba. James bula John yaba-yabaju. Jana janarrku manjalba jarra-jarranga dakarin. ");
INSERT INTO gvn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yinyaymba Jesus nyulu walu-yindumanijin. Nyulu walu dayirrman, balbal-balban yala wungarabu. Nyungu kambi bingajimanijin, dayirr bajaku yala light. ");
INSERT INTO gvn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bula Moses, Elijah, bula ngadimunku. Bula nguymal milbijin, Jesusanji balkawan. Jana disciplesangka jananin nyajin. ");
INSERT INTO gvn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peterangka Jesusanda yalaman, “Maja, yinya ngulkurr ngana muruman yalaymba. Yundu wawu ngayu bayan kulur ngaranka? Nyubun bayan yunuku, nyubun Mosesamu, nyubun Elijahmu.” ");
INSERT INTO gvn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nyulu Peter balkan-balkawanku, ngurrban dayirr wuyar kadan jananda. Jana kuku nyajin ngurrbanmun yalamanya, “Yanyu ngayku kangkal, ngayu nyungunku wawu jirray, wawurr-wawurrmanijin nyungunku. Yurra nyungundu milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jana jawun-karrangka yinya kuku nyajin, kungkurr-kadarin, bubungu dararin, yinyilmarinya. ");
INSERT INTO gvn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yamba Jesus jananda kadan, marabu karrban, yalaman, “Janarikada, kari yinyilmarikada.” ");
INSERT INTO gvn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jana miyil walnganda, Jesusku nyajin. Bula Moses, Elijah nguymal kariman. ");
INSERT INTO gvn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yinyamun jana bada manjalmundurr kankadan, Jesusangka jananda yalaman, “Yurra bamanda kari balka yurra yinya nyajin. Ngayu bamanga wubulbuku yaba. Juma ngayu yarkinmun juranmal baja. Wawu yinyamun yurra balkada.” ");
INSERT INTO gvn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jana Jesusanda babajin, “Jana teacher-teacher ngadimunku, jana wanyurrinku balkal Elijahngarr jakalba kadanka, Christ kudamundu?” ");
INSERT INTO gvn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nyulu yalaman, “Yuwu, nyulu Elijahngarr kadanda. Nyulu kadan, bama yanday-bunganka junkayku bundanka. ");
INSERT INTO gvn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngayu yurranda manubajabuku balkal, nyulu bama yala Elijah kadanda. Yamba bamangka nyungun kari nyungun-bungan. Jana nyungunin buyun-daman, yarkinkaku kunin. Ngayu bamanga wubulbuku yaba. Jana nganya yalarrku buyun-damalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jawun-karrangka yinya kuku nyajin, binalmanda, nyulu balkal-balkan John the Baptistanka. John kadan yala Elijahnguy. ");
INSERT INTO gvn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yinyamun jana Jesus manjalmun kadarin, bamanda wubulbuku. Nyubun dingkar Jesusanda kadan, bungkubu janan, ");
INSERT INTO gvn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","yalaman, “Maja, manun-manunmaka ngaykuwunku kangkalka dingkaranka. Dubu dukurrbu walan. Nyulu dubungku ngayku kangkal buyun-damal-damal, kangkal yaran-yararri, darayda, bayanga, bananga. ");
INSERT INTO gvn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngayu nyungunin wundin yunuwunbu jawun-karranda, yamba jana dubu can't kangan.” ");
INSERT INTO gvn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesusangka jananda bamanda yalaman, “Yurra wubulku bundandayda, yurra nganya warmbil-warmbil, kari junkayku bundanday. Ngayu ngadingka bundandan yurranji. Yurra wanja-wanja nganya kuku nyajil? Karrkay ngaykundu wundi.” ");
INSERT INTO gvn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesusangka dubu murru-kangan, karrkayandamun kangan. Nyulu Dubu wandin karrkayandamun. Nyulu karrkay jinbalku ngulkurrmanda. ");
INSERT INTO gvn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yinyamun jana jawun-karra 12-bala janarrku Jesusanda kadarin. Jana babajin, “Nganjin can't dubu kangan. Wanyurrinku nyulu kari dungan?” ");
INSERT INTO gvn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesusangka yalaman, “Yurra nganya warmbil-warmbin, kuku buban nyajin. Yinyaynka yurra nyungun kari kangan. Ngayu yurranda balkal, kaki yurra nganya bubanku kuku nyajil, and kari warmbil, yurra balkal yinya manjal jurrkijinka yalamun yinyaymba. Yinya manjal jurrkijikuda. Yurra babaji, Godungku dajilkuda. Yurra nganya kuku nyajil, yurra junkurr manilda, junjuy-junjuy wubulku balkanka. ");
INSERT INTO gvn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kaki yurra dubu yalanguy kanganka, yurra mayi kariku nuka, Godunji balkawanka. Yinyamun dubu kangakuda.” ");
INSERT INTO gvn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jana jawun-karra murumarin bubungu Galilee, Jesusangka jananda yalaman, “Ngayu wubulbuku yaba. Jana nganya mambarril dingkar-dingkaranda, kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jana nganya yarkinkaku kunil. Warngku kulurmal, ngayu juranmal baja.” Jana jawun-karra milka-bujarmanyarrkuda yinyaynka kukuku. ");
INSERT INTO gvn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wawu yinyamun jana Jesus townbu Capernaum kadarin. Yinyaymba kanbal dingkar-dingkar Peteranda kadarin. Jana dingkar-dingkarangka tax money mujan Jew-warrandamunku churchmunku. Jana Peteranda babajin, “Yunuwundu majangka tax money payim-bungal Jew-warrandamunku churchmunku?” ");
INSERT INTO gvn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peterangka yalaman, “Yuwu, payim-bungalkuda.” Nyulu Peter bayanbaku kadan baja, Jesusangka nyungundu yalaman, “Simon, yundu wanyu milkabu baykal? Jana maja-maja king, jana wanjundumun tax money bangkal? Jawun-karrandamun or bamandamun yindu-yindundumun?” ");
INSERT INTO gvn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peterangka yalaman, “Bamandamun yindu-yindundumun.” Jesusangka yalamanda, “Yuwu, kingandamundu jawun-karrangka tax money kari payim-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yamba ngali jananin wawu kari kuli-kanganka. Yundu bada beachmunbu dungayda, badur yilbada. Kuyungku baykal, yundu kulbada. Yundu ngandalba money warrmba-bungal. Mana, jananda dayada ngalinga tax money churchmunku.” ");
INSERT INTO gvn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yala-yalaku jana jawun-karra 12-bala Jesusanda kadarin, yalaman, “Godungku nyungu jawun-karra ngulkurrduku kujil. Bama wanju majamal Godundumunku bamanka kanbalanka?” ");
INSERT INTO gvn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nyulu Jesusangka nyubun karrkay nyungundu kunjan, nyungun dindarra jajirrin jananda. ");
INSERT INTO gvn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nyulu yalaman, “Ngayu yurranda manubajabuku balkal. Yurra must buyun-buyunmun jurrkijika, walu-yindumaka, bubanmaka, yala kaykay-kaykaymaka, ngulkurrku bunday. Kaki yurra kari yalaku bunday, yurra kari bunday Godundumunji jawun-karranji yinyaymba Godungku jananin ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaki bama nyuluku buban-bungaji yala yanyu karrkay, nyulu majamal Godundumunku jawun-karranka yindu-yinduynku. ");
INSERT INTO gvn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kaki bamangka karrkay yala yanyu yulmbarril ngaykunku, yinya yala nyulu nganya yulmbarril. ");
INSERT INTO gvn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Bamangka nyubuninja ngayku bama buyun-buyunku juru-kulbal, ngaykundumun jurrkijinka, Godungku nyungun yaykarrdaku punishim-bungalkuda. Jarra ngulkurr nyungunku jana kulji yalbay nyunguwunbu manungu kajanyaku, nyungun bujil-janji-maninyaku jalunbu dajalimunbu. Yinya jarra ngulkurr Godundumunku punishmentmunku. ");
INSERT INTO gvn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bama buyunmanya, jana bubu buyun-damal, bama yindu-yindu warrngkay-manil. Bama kari wawurr-wawurrku bundanday, buyunmanya. Bamangka yindu-yindu buyunku juru-kulbal baja, juru-kulbal baja, buyunmanka. Ngayu jiba-badi jananka bamanka yindu-yindu buyunku juru-kulbal-kulbal buyunmanka. Godungku jananin yaykarrdaku punishim-bungalkuda. ");
INSERT INTO gvn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kaki bamangka marabu buyun-damanka, nyulu mara nyandajika, yilba, kari buyun-damanka. Ngulkurr nyungunku nyulu mara-kariku heavenba dungay. Marabu buyunmanya nyungun bada-bada bayanga yungal. Kaki bamangka jinabu buyun-damanka, nyulu jina nyandajika, yilba, kari buyunmanka. Ngulkurr nyungunku nyulu jina-kariku heavenba dungay. Jinabu buyunmanya nyungun bada-bada bayanga yungal. ");
INSERT INTO gvn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bamangka nguba buyun-damanka, junjuy miyilda nyajinya. Nyulu yalakubi miyil nyandajika, yilba, kari buyun-damanka. Miyilda jambuldu buyunmanya nyungun nguba bada-bada bayanga yungal. Ngulkurr nyungunku nyulu heavenba dungay miyilji nyubunji.” ");
INSERT INTO gvn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesusangka yalaman baja, “Yanyu karrkay nyaka. Yurra nguba balu kaykay-kaykay yala yanyu jirray kari. Yurra nguba jananka wawu kari. Kari yalamaka. Angel-angelangka jananin ngulkurrduku kujil-kujil. Kaki bamangka kuli dajil karrkayanda, yinyandamundu karrkayandamundu angelangka Godundu balkal yinya. ");
INSERT INTO gvn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ngayu bamanga wubulbuku yaba. Ngayu kadan nubinka bama nubijinya buyun-buyunku.” ");
INSERT INTO gvn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesusangka jananda yalaman, “Ngayu yurranda story balkanka. Yurra story milkabu bayka. Nyubun bama sheepmunji 100-balanji. Yamba nyubun sheep nubijinda. Nyulu bama wanjarrmalda? Nyulu kanbal bawal wuburrbu, jikanba nukal-nukajinya. Nyulu dungayda, nubinka yinya sheep nyubun nubijinya. ");
INSERT INTO gvn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nyulu warrmba-bungal, wawurr-wawurrmalkuda. Nyulu wawurr-wawurrmal kanbalka sheep-sheepmunku, yamba nyulu wawurr-wawurrmalarrkuda yinyaynka sheepmunku nyubunyinka warrmba-bunganya. ");
INSERT INTO gvn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","God yala nyulu bama sheep-sheepmunji. Nyulu wawu kari kaykay-kaykay yala yanyu nubijinka. Nyulu wawu kari nyungu bama-bama nubijinka. Jana wulanji kala-kalbay Godundumun.” ");
INSERT INTO gvn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesusangka yalaman baja, “Nguba bamangka yunun buyunku buyun-damal. Nguba kuku buyun balkal yununku. Yundu nyungundu dungayda, balka, ‘Yundu nganya buyun-daman.’ Yubal yubalarrku kirayku balkawaka. Kaki nyulu yunu kuku nyajil, yubal murumal baja, jawun-jawunmal baja, kari kuli-kaday baja. ");
INSERT INTO gvn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kaki nyulu yunuwunbu kukungu kari milka-janay, yundu bama yindu, nguba jambul yununji wundi, bula yubalan nyajinka balkawanya. Bula nyungun milka-bakanka jawunmanka baja yununji. ");
INSERT INTO gvn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kaki yinya bama kari milka-janay bulanda dingkar-bulalanda, yundu bamanda churchmunbu balka yinyaynka buyun-buyunku. Jana nyungundu dungayda, milka-bakanka yununji jawunmanka baja. Kaki nyulu jananda kari milka-janay, yundu bawada. Nyulu Godumu kuku wawu kari wukurrinka. Nyungun bawa, yala yurra ngarrbal bawal.” ");
INSERT INTO gvn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jesusangka yalaman baja, “Ngayu yurranda balkal, kaki yurra junjuy kiril bamanda bada bubungu, Godungku yalarrku kiril heavenba. Kaki yurra junjuy kari kiril bamanda bada bubungu, Godungku yalarrku kari kiril heavenba. ");
INSERT INTO gvn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ngayu yurranda balkal baja, kaki bama bula jambul junjuynku wawumal and bula jambulku Godundu babaji, Nganjanangka Godungku dajilkuda. ");
INSERT INTO gvn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kaki bama jambul, or kulur, murumal ngaykunku, ngayu jananji bundaykuda.” ");
INSERT INTO gvn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wawu yinyamun Peter Jesusanda kadan, babajin, “Kaki bamangka nganya buyun-damal, ngayu wanjarrku jawunmal baja? Ngayu jawunmal baja 7 times?” ");
INSERT INTO gvn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesusangka yalaman, “Kari. 7 timesku kari. Yundu jawunmaka baja, jawunmaka baja, 77 times jawunmalmakaku. ");
INSERT INTO gvn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yinya yala yanyu story. Yanyu story Godunku, nyulu jawun-karra nyungu ngulkurrduku kujil. Nyubunyinja majangka kingangka nyungu kaban nyajin workingmananka, jana nyungundu money oweim-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nyulu kaban nyajil-nyajin, jana nyubun bama workingman nyungundu wundin, jakalba jajirrin. Nyulu yinyangka bamangka kinganda money jirray bajaku oweim-bungan, majanda nyikukunya wundinyaku money jirray, millions of dollars. ");
INSERT INTO gvn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bamanga money yamba-kari, kinganda dajinka baja. Majangka kingangka yalaman, ‘Nyungun sellim-bunga, slavemunku. Nyungu manyarr, kangkal-kangkal, yamba-yamba yalarrku sellim-bunga, ngaykundu dajinka baja.’ ");
INSERT INTO gvn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nyulu bama bungkubu janan jakalba kinganda, yalaman, ‘Yundu jankaku bundayngarr ngaykunku; ngayu juma wubulku dajil baja.’ ");
INSERT INTO gvn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nyulu king jiba-badin nyungunku. Yinyaynka nyulu bamanda yalaman, ‘Kari. Ngayu milka-wulaykuda moneyka. Kari daya baja. Ngayu yununin yungalkuda.’ ");
INSERT INTO gvn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nyulu bama dungaynda. Yinyamun nyulu nyungu jawun maku-nyajin. Nyunguwundu jawunyungku nyungundu money buban oweim-bungan. Nyulu bamangka nyungu jawun manu karrban, yalaman, ‘Ngaykundu dayada yinya money yundu nganya oweim-bungal.’ ");
INSERT INTO gvn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nyungu jawun bubungu daran, yalaman, ‘Yundu jankaku bunday ngaykunku. Ngayu yunundu juma dajil baja.’ ");
INSERT INTO gvn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yamba nyulu bama kari jankaman nyunguwunku jawunyunku. Nyulu jawun jailba mumban, till nyulu money payim-bankarrku. ");
INSERT INTO gvn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Jana yindu-yinduyngku workingmanangka yinya nyajin, kuli-kadarin. Jana majanda kinganda dungarin, nyungundu wubulku balkan yinyanka bamanka buyunku. ");
INSERT INTO gvn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nyulu kingangka bama kunjan baja. Nyulu yalaman, ‘Yundu buyun bajaku. Yundu ngaykundu babajin jankaku bundanka yununku. Yinyaynka ngayu dumbarrin kaban yinyaynka moneyka yundu nganya oweim-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngayu jiba-badiman yununku. Yundu yalarrku jiba-badimanyaku yunuwunku jawunyunku.’ ");
INSERT INTO gvn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nyulu king yaykarr bajaku kuli-kadan. Nyulu yinya bama jailba mumban, punishim-bunganka, till nyulu money payim-banka baja.” ");
INSERT INTO gvn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesusangka jawun-karranda yalamanda, “Nganjanangka Godungku yalarrku yalamal yurranda. Kaki bama kari milka-wulayarrku buyun-buyunku bamandamunku, Godungku nyungundu kuli dajil baja. Kaki bamangka buyun balkal yunundu, yundu must milka-wulay, jawun-jawunmaka baja nyungunji.” ");
INSERT INTO gvn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wawu yinyamun kukumun, jana Jesus bubumun Galileemun dungarin. Jana ngubar-ngubar wawubajanga Jordan dungarin bubungu Judea. ");
INSERT INTO gvn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bamangka wubuldu nyungun wukurrin. Nyulu bambay-bambay ngulkurr-bungan yinyaymba. ");
INSERT INTO gvn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kanbal Pharisee-warra Jesusanda kadarin, nyungun kukubu walu ngangkal-ngangkal-bunganka, catchim-bunganka. Jana babajin, “Wanyu nganandamundu ngujakuramundu balkal manyarrinyunku? Yalada dunyungku manyarr bawalarrkukuda, nyuyanya?” ");
INSERT INTO gvn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesusangka yalaman, “Yurra nguba kariku Godundumunbu kabanba yanyu kuku nyajin, ‘Jakalbaku Godungku bama balkan, nyulu dingkar and jalbu balkan.’ ");
INSERT INTO gvn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Godungku yalaman, ‘Yinyaynka nyulu dingkarangka nyungu nganjan and ngamu bawa, nyunguwunji manyarranji bundayarrku. Bula manyarrinyumalda, yala nyubunkuda.’” ");
INSERT INTO gvn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jesusangka yalaman baja, “Bula karida jambul, nyubunkuda, manyarrinyukuda. Kaki Godungku dingkar and jalbu kuna-bungal, bamangka kari ngami-ngami-bunga baja. Manyarrinyu kari bawawaka baja.” ");
INSERT INTO gvn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jana Pharisee-warrangka Jesusanda yalaman, “Mosesangka yanyu kuku balkan, ‘Kaki dunyungku nyungu manyarr bawanka, nyulu nyungundu kaban daya divorcemunku, nyungun bawada.’ Mosesangka wanyurrinku yinya kuku balkan?” ");
INSERT INTO gvn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesusangka jananda yalaman, “Mosesangka yinya kuku balkan yurranka. Yurra dukul-dandi bajaku, wawu kari binalmanka. Nganjin wumbabuku yurranin binal-bungan-bungal. Mosesangka yinya kuku divorcemunku balkan, yurra dukul-dandimanya. Yinya kuku Godundumun kari, jakalbamun kari. ");
INSERT INTO gvn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngayu yurranda balkal, manyarr nyubun nguba ngulkurrku bunday, yindu kari dunyu-bungal. Nyunguwundu dunyungku nyungun kari bawa. Yamba dunyungku nguba bawal, yindu manyarr-bunganka. Nyulu dingkar kalngarmalda.” ");
INSERT INTO gvn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jawun-karrangka yalamanda, “Kaki bamangka yinya kuku wukurrinka, nguba ngulkurr kari marrymanka.” ");
INSERT INTO gvn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesusangka yalaman, “Kari. Ngulkurr bama manyarrinyumanka. Yamba kanbal bama kari marrymanka. Godungku jananin junkurr dajil junkayku bundanka. ");
INSERT INTO gvn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kanbal dingkar-dingkar kari marrymal, jana can't nganjanmanya. Jana yalaku balkajin. Kanbal can't nganjanmal, bamangka jananin yalaku buyun-damanya. Kanbal kari marrymanka, jana Godunku workmanka, nyungu kuku mumbarku yirrkanka. Kaki jana wawubu, yinya ngulkurr, jana ngulkurrku bundari.” ");
INSERT INTO gvn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yinyamun bamangka kaykay-kaykay Jesusanda wundin. Jana wawu nyulu Jesusangka kaykay-kaykay marabu karrbanka, Godunji balkawanka, praymanijinka yinyarrinyanka kaykay-kaykayanka. Yamba jana jawun-karrangka 12-balangka yinyarrin bama murru-kangan. ");
INSERT INTO gvn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesusangka yalaman, “Kaykay-kaykay kari kiri ngaykundu kadarinka. Balu kadarika ngaykundu. Kaki bamangka nganya kuku nyajil yala yinyarrinyangka kaykay-kaykayangka, Godungku jananin ngulkurrduku kujil.” ");
INSERT INTO gvn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nyulu Jesusangka jananin kaykay-kaykay marabu karrban, yinyamun nyulu dunganda. ");
INSERT INTO gvn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nyubun warru Jesusanda kadan, babajin, “Maja, ngayu wanjarrmanka, junkayku bundanka, wuljaljiku juranku bundanka heavenba?” ");
INSERT INTO gvn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesusangka yalaman, “Yundu wanyurrinku ngaykundu babaji ngulkurrku bundanka? Nyubunku ngulkurrkuda, Godku. Kaki yundu wuljaljiku juranku bundanka, yundu Godumu kuku wukurrika.” ");
INSERT INTO gvn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Warrungku babajin, “Wanjarrku kuku Godumu?” Jesusangka yalaman, “Kari yarkinkaku kuni, kari kalngarmaka, kari wurrmaymaka, kari jurrilmaka. ");
INSERT INTO gvn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kuku nyakaku, ngamu, nganjan; bamanka wubulkuku wawu jirray yala yundu yununkuku wawu jirray.” ");
INSERT INTO gvn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nyulu warrungku yalaman, “Ngayu karrkaymunku yinya kuku wukurrin. Ngayu wanjarrmal baja?” ");
INSERT INTO gvn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesusangka nyungundu yalaman, “Kaki yundu wuljaljiku juranku bundanka heavenba, dungayda, yamba-yamba wubulku sellim-bunga. Kulji money mana, jawun-karinda poor-balanda daya. Yinyamundu yundu jirray manil heavenba. Kadayda, nganya wukurrikada.” ");
INSERT INTO gvn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nyulu warrungku yinya kuku nyajin, nyulu milka-bujarku dungan, money jirray bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesusangka jawun-karranda yalamanda, “Ngayu yurranda balkal, Godungku nyungu bama ngulkurrduku kujil. Money-jirrayanka hard-bala God maja-bunganka. Nyulu milkanga moneyjiku bundanday. ");
INSERT INTO gvn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngayu balkal baja, hard-bala bulki needledarr kankaburr dungay. Kaki bama money jirray, hard-bala bajaku God maja-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jana jawun-karrangka yinya kuku nyajin, kungkurr-kadarin. Balu Godungku bama money jirray juran-bunganka. Jana yalaman, “Kaki yinya kuku manubaja, wanju baja Godungku juran-bungal?” ");
INSERT INTO gvn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesusangka junkaynjaku nyajin jananin, yalaman, “Bamangka can't yalaku balkal. Godungkuku bama juran-bungalarrku.” ");
INSERT INTO gvn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peterangka yalamanda, “Yala nganjin? Nganjin wubulku bawan, jawun-karra, bayan, yamba-yamba, yunun wukurrinka. Nganjin wanyu manil yinyaynka?” ");
INSERT INTO gvn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesusangka jananda yalaman, “Ngayu manubajabuku balkal, ngayu yurranin juma maja-bungal yala-yalala ngayu kingmal. Ngayu bamanga wubulbuku yaba. Juma ngayu majamal, ngayku bama wubulku ngulkurrduku kujil. Yurra 12-bala majamari, bama Jew-warra ngulkurrduku kujil. Jana Jew-warra kadarin yaba-yabajundumun 12-balandamun ngadimunku. ");
INSERT INTO gvn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kaki yurra junjuy-junjuy bawalarrku ngaykunku, ngayu yurranda jarra jirray dajil baja. Yurra nguba bayan, yaba-yabaju, babarr-jinkurr, ngamu, nganjan, kangkal-kangkal, bubu, wubulku bawanyarrku ngaykunku. Ngayu juma yurranin wubul bajaku dajil baja. Ngayu yalarrku yurranga wawu juran-bungal, yurra wuljaljiku ngaykunji bundanka heavenba. ");
INSERT INTO gvn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bama nguba majamanka, jakalba yindu-yinduymbu majaku dunganka ngaykuwunbu bubungu. Godungku nyungun kari maja-bungal. Bama yindu nguba wawu kari majamanka, nyulu yindu-yindu helpim-bunganka. Godungku nyungun maja-bungalkuda, nyunguwunbu bubungu.” ");
INSERT INTO gvn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesusangka yalaman, “Godungku bama nyungu ngulkurrduku kujil. Yinya yala yanyu story. Ngadiku nyubun dingkar gardenji. Nyulu diburr grape nandan yinyaymba gardenba. Juma nyulu bama maninka, workmanka nyunguwunbu gardenba. Yalibalaku nyulu wandin, bama maninka, nyungundu workmanijinka. ");
INSERT INTO gvn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nyulu bamanda yalaman, ‘Yurra nyikuku ngaykundu workmaniji, ngayu yurranda workingmanamu pay dajil, 30 dollars.’ Jana wawuman, nyulu jananin yunganda, gardenba. ");
INSERT INTO gvn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","9 o'clockmanijin, nyulu maja storengu dungan. Nyulu bama kanbal nyajin janjananya, work kari. ");
INSERT INTO gvn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nyulu jananda yalaman, ‘Yurra ngaykuwunbu gardenba dungarika, workmaka. Ngayu money jirray dajil.’ ");
INSERT INTO gvn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jana dungarinda. Wungar jarra-jarra, nyulu majangka kanbal bama yungan baja. Yilaylayman, nyulu yalarrku kanbal yungan baja workmanka. ");
INSERT INTO gvn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wungar kuwaman, nyulu storengu dungan baja. Nyulu bama-bama yindu nyajin, yinyaymba janjanarinya. Nyulu jananda babajin, ‘Yurra wanyurrinku yalaymba janjanari work-kariku?’ ");
INSERT INTO gvn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jana yalaman, ‘Bamangka nganjinanda work kari dajin.’ Majangka jananda yalaman, ‘Yalada, yurra yalarrku ngaykuwunbu gardenba dungarika, workmanka.’ Jana dungarinda. ");
INSERT INTO gvn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wujurrman nyulu majangka foremananda yalaman, ‘Jananin workingmen kunja, payim-bunga. Jana kudamundu kadarin, jananganngarr payim-bunga. Yalarrku wubulku payim-bunga. Yamba yinyarrin kanbal kudamunduda payim-bunga yinyarrin jana jakalbaku kadarin.’ ");
INSERT INTO gvn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nyulu foremanangka 30 dollars dajin jananda wungar kuwa startmanijin. ");
INSERT INTO gvn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jana bama yalibalaku startmanijin workman, jana balu money jirray maninka. Kari. Nyulu majangka jananda yalarrku 30 dollars dajin. ");
INSERT INTO gvn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jana money manin, kuli-kadarin, maja murru-kangan. ");
INSERT INTO gvn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jana majanda yalaman, ‘Jana bama wungar kuwakuda kadarin, jana buban workmanijin. Yamba nganjin all day wungara wumbulbuku workmanijin, yamba yundu nganjinanga same pay dajin yala jananda.’ ");
INSERT INTO gvn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Majangka yalaman, ‘Yurra ngayku jawun-jawun; milka-janay. Ngayu yurranin kari jurril-bungan. Kari. Yurra wawuman ngaykunku workmanijinka 30 dollarsmunku. Ngayu yurranda 30 dollarskuda dajinkuda. ");
INSERT INTO gvn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yurranga pay mana, bayanbaku dungayda. Ngayu 30 dollars yalarrku dajinka jananga wungar kuwakuda kadarin. Yinya ngayuku baja. ");
INSERT INTO gvn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kaki ngayu money jirray dajinka jananda wungar kuwa kadarin, ngayu dajilkuda. Ngayuku baja. Yurra nguba kuli-kadarin, ngayu jawaymanya.’” ");
INSERT INTO gvn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesusangka yalamanda, “Yanyu kuku yala ngayu jakalbaku balkan. Bama nguba majamanka, jakalba yindu-yinduymbu majaku dunganka ngaykuwunbu bubungu. Godungku nyungun kari maja-bungal. Bama yindu nguba wawu kari majamanka, nyulu yindu-yindu helpim-bunganka. Godungku nyungun maja-bungalkuda, nyunguwunbu bubungu.” ");
INSERT INTO gvn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jana Jesus baraldarr townbu Jerusalemmunbu dungan-dungarin, Jesusangka jawun-karra 12-bala muru-bungan, janarrku kirayku balkawan. ");
INSERT INTO gvn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nyulu jananda yalaman, “Yurra milka-janay. Ngayu yaba bamanga wubulbuku. Ngana wangkar Jerusalemmunbu dungari. Jana, maja-maja Godundumunku churchmunku, teacher-teacher ngadimunku, jana yinyaymba bundandari. Bamangka nganya mambarril jananda. Jana nganya nyuyal, yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jana nganya mambarrilda ngarrbal-ngarrbalanda, Gentile-warranda. Jana bamangka ngarrbal-ngarrbalangka nganya yajarril-yajarril, wuybubu kulbal, jukungu walngkan-damal, nganya yarkinkaku kunilarrkukuda. Warngku kulurmal, ngayu juranmal baja.” ");
INSERT INTO gvn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wawu yinyamun nyulu Zebedeemu manyarr Jesusanda kadan. Nyulu kangkal dingkar jambul nyungundu wundin. Nyulu muku badaman, yalaman, “Ngayu yunundu babajinka.” ");
INSERT INTO gvn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesusangka yalaman, “Yundu wanyurrinku?” Nyulu yalaman, “Yundu nganya wawurr-wawurr-bunga. Yundu kingmal, ngayu wawu ngayku warru bulal yununji bundanka majamanka. Yundu wawurr-wawurr-bunga bula yununji bundanka, majamanka.” ");
INSERT INTO gvn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesusangka bulanda warru-bulalanda yalaman, “Yubal binal kari wanyurrinku yubal baban-babaji. Jana bamangka nganya kaka-bungal, kuli balkaji ngaykunku. Yinya yala bana kaka nukal. Yubal yinya bana kaka yalarrku nukal?” Bula yalaman, “Ngalin nukalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesusangka bulanda yalaman, “Yuwu, bamangka juma yubalin warrngkay-manilkuda, kuli dajilkuda yala ngayku. Yamba ngaykuku kari, bama wangkaninka ngaykunji majamanka. Ngaykuwunduku nganjanangkaku wangkanil.” ");
INSERT INTO gvn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kanbal-kanbalda 10-balangka jawun-karrangka bulanka kukuku nyajin, jana bulanka kuli-kadarinda. ");
INSERT INTO gvn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesusangka jananin muruku kunjan, yalaman, “Yurra binal maja-majanka yalbaynka bubuku yindu-yinduynku. Jana bama mambarril jananin kuku nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yurra kari yalamaka. Kaki yurra majamanka, yurra yurraku bubanmanijikada. Bama yindu-yindu nyakada, helpim-bungada. Yinyamun Godungku yurranin yalbay-bungalkuda. ");
INSERT INTO gvn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yuwu, kaki nyubun bama majamanka, nyulu nyuluku bubanmanijika, yala bamanga slavemaka. ");
INSERT INTO gvn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yurra yala ngayumaka. Ngayu wubulbuku yaba. Ngayu bubungu kadan, bama ngulkurrduku kujinka, ngayu yala slavemanka. Ngayu kari kadan bamangka nganya kujinka. Ngayu kadan, wulanka bamanka wubulkuku, jananin wangkar-wangkar jiringa wundinka. Yinyaymba jana wuljaljiku juranku bunday.” ");
INSERT INTO gvn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jana Jesus townmun Jerichomun dungan-dungarin, bamangka wubulduku jananin wukurrin. ");
INSERT INTO gvn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bula jambul miyil-burra karangkalba baralba bundandan. Bula kuku nyajin Jesus kankadanya, kawal yirrkay-yirrkan, “Yundu Davidandamun. Manun-manunmaka, jiba-badi ngalinyanka!” ");
INSERT INTO gvn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bamangka wubulduku bulangan murru-kangan, yalaman, “Jankamaka.” Yamba bula yaykarrku yirrkan baja, “Yundu Davidandamun. Ngalinyanka manun-manunmaka, jiba-badi.” ");
INSERT INTO gvn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus janan, bulanin kunjan. Nyulu bulanda babajin, “Ngayu wanjarrmal yubalanga?” ");
INSERT INTO gvn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bula yalaman, “Maja, ngalinyanga miyil ngulkurr-bunga.” ");
INSERT INTO gvn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus bulanka jiba-badin, bulanga miyil marabu karrban. Bula miyilda nyajinda, miyil ngulkurrmankuda. Bula Jesus wukurrinda. ");
INSERT INTO gvn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jana Jesus dungarin baja. Jana yubaku townbu Jerusalem kankadarin, manjalba kadarin, burri Mount of Olives. Yinyaymba town karrkay, burri Bethphage. Nyulu Jesusangka jawun jambul jakalba yungan, bulanda yalaman, ");
INSERT INTO gvn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Yubal yinyaymba townbu dungay. Yubal townbu kaday, donkey nyajil karrabu kajanya. Nyungu kangkal karrkay karangkalba janjanay. Yubal donkey walnga, bulanin ngaykundu wundi. ");
INSERT INTO gvn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kaki bamangka yubalanda babaji, ‘Yubal yinya donkey wanjabu wundil?’, yubal balka, ‘Ngalinanga maja nyungundu dakanka.’ Yinyamun jana donkey yungal yubalanji.” ");
INSERT INTO gvn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jesusangka yinya balkan, Godumu kuku manubajamanka. Prophetangka ngadiku Godumu kuku kabanba balkan yalaku; ");
INSERT INTO gvn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yurra bamanda balka townbu Zion, ‘Nyaka, yurranga king yurranda kankaday, wuyara donkeynda bundanday. Nyulu kari kankaday yala maja jirray. Kari, nyulu nyuluku buban-bungajin. Nyulu kankaday, wuyara donkeynda karrkaymba bundanday.’” ");
INSERT INTO gvn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Yalada, jawun-bulal dungan, donkey jambul-bulal wundin yala Jesusangka bulanda balkan. Bula kambi bulanga mukungu ngaran donkeynda. Jesus mukungu dakan. ");
INSERT INTO gvn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bamangka wubuldu jananga kambi baralba ngaran. Kanbalda dakil jukumun dumbarrin, baralba ngaran. Jana yalaku. Kaki maja king kadanka, jana kambi, dakil ngaranka baraldarr. ");
INSERT INTO gvn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jesus wuyara donkeynda dungan-dungan, bama wubulku nyungunji dungarin, kanbal jakalba, kanbal kudamundu. Jana nyungun yulmbarrin, yirrkan-yirrkanya, “Yuy! Yuy! Ngana bama Davidandamunku yulmbarril. Godungku yanyu dingkar yungan, nyulu nyungunin maja-bungal. Ngana God buyay-mana.” ");
INSERT INTO gvn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jana yalaku dungan-dungarin, Jesus townbu Jerusalemmunbu walan. Jana townbuku nyajin nyurra bangkanya, jana babajin, “Ya, nyulu wanju?” ");
INSERT INTO gvn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bamangka Jesusanjiku jananda yalaman, “Nyulu prophet, Jesus, nyulu kuku Godundumun balkal. Nyulu townmun Nazarethmun, bubumun Galileemun.” ");
INSERT INTO gvn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yinyamun Jesus Godundumunbu bayanba yalbaymba dungan. Kanbalda dingkar-dingkarangka yinyaymba junjuy-junjuy sellim-bungal-bungan, kanbalda buy-im-bungal-bungan. Jesusangka jananin bama wubulku kanganda Godundumun bayanmun. Kanbalda money jurrkil-jurrkin, changeim-bungal-bungan. Jesusangka jananga table jurrngan. Kanbalda dikal yala wabul sellim-bungal-bungan. Nyulu jananga chair jurrngan. ");
INSERT INTO gvn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesusangka jananda yalaman, “Godumu kuku yalaku: ‘Bama wubul ngaykuwunbu bayanba kaday. Jana praymanka, balkawanka ngaykunji.’ Yamba yurra yala kari; yurra ngaykuwunbu bayanba bunday wurrmaymanka.” Nyulu yala balkan, jana bama jurril-bunganya, money jirray maninka. ");
INSERT INTO gvn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bama bambay-bambay Jesusanda Godundumunbu bayanba kadarin, kanbal miyil-burra, kanbal barrka-buyun. Nyulu jananin ngulkurr-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nyulu yinyaymba junjuy-junjuy miracle wubul balkan, Godundumundu junkurrdu. Jana kaykay-kaykay yirrkan-yirrkajin, “Nyulu dingkar Davidandamun, nyulu ngulkurr bajaku. Ngana nyungunin buyay-mana.” Jana maja-maja Godundumunku churchmunku, jana teacher-teacher ngadimunku, jana yinyaymba bundandan. Jana Jesus nyajin bama ngulkurr-bunganya, kaykay-kaykay nyajin Jesus buyay-manil-maninya. Yinyaynka jana kuli-kadarinda. ");
INSERT INTO gvn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jana Jesusanda yalaman, “Milka-janay. Yundu kuku nyajin jananga kaykay-kaykayamu?” Jesusangka yalaman, “Yuwu, ngayu nyajinkuda. Yurra kariku Godumu kuku kabanba nyajin? Godumu kuku yalaku: ‘Yundu kaykay-kaykay, ngawa-ngawa binal-bungan yununin buyay-maninka.’” ");
INSERT INTO gvn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yinyamun nyulu jananin bawanda, townbu Bethany dungan. Yinyaymba nyulu warngku nyubun wunan. ");
INSERT INTO gvn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Warngku yindu, yalibalaku, jana Jesus townmun Bethanymun kankadarin, townbu Jerusalem dungarinka. Jesus, nyulu dakwuymankuda. ");
INSERT INTO gvn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nyulu juku nyajin yala juku mujarr, karangkalba baralba janjananya. Nyulu jukungu dungan mayika. Kari, mayi yamba-kari jukungu, manu birraku. Yinyaynka nyulu yalaman, “Mayi kari balkaji baja yinyaymba jukungu.” Birra yinyaymba jukungu jinbalku nganjaymaynda. ");
INSERT INTO gvn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jana jawun-karrangka yinya nyajin, kungkurr-kadarin. Jana Jesusanda babajin, “Yinya birra wanjarrku jinbalku nganjaymayn?” ");
INSERT INTO gvn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesusangka jananda yalaman, “Milkabu kuji. Kaki yurra nganya mumbarabuku kuku nyajil, and kari warmbil, yurra yalarrku junjuy-junjuy yalbay balkal. Yinya manjal nyaka. Kaki yurra nganya kuku nyajil, yurra yinyayanda manjalba balkal, ‘Jalunbu yilbajika,’ yinya manjal yilbajikuda. ");
INSERT INTO gvn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kaki yurra nganya kuku nyajil, yurra Godundu babaji, nyulu dajilkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus jananda Godundumunbu bayanba dungan baja, jananin binal-bungan Godundumunku kukuku. Nyulu binal-bungal-bungan, jana maja-maja Godundumunku bayanka, teacher-teacher ngadimunku, jana nyungundu kadarin, babajin, “Wanjungku yunundu balkan jananin binal-bunganka, ngulkurr-bunganka? Wanyangka yunun yungan?” ");
INSERT INTO gvn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Jesusangka jananda yalaman, “Kari. Ngayu yurranda junjuynku babajinka. Wanjungku John the Baptist yungan, bama banabu dukul-damanka? Godungku nyungun yungan or bamangka? Kaki yurra yinya ngaykundu balkal, ngayu yurranda balkal wanjungku nganya yungan.” Jana jana-karrajiku balkawan, yalaman, “Ngana wanyu baja balkal nyungundu? Kaki ngana balkal, ‘Godungkuku John yungan,’ nyulu ngananda babaji, ‘Yala yurra wanyurrinku nyungundu kari milka-janan?’ ");
INSERT INTO gvn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kaki ngana balkal, ‘Bamangka,’ jana bama kuli-kadarinji ngananka. Jana wubulduku milkabu baykal John, nyulu prophet.” ");
INSERT INTO gvn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jana Jesusanda yalamanda, “Nganjin binal kari. Wanjungku baja John yungan?” Jesusangka jananda yalamanda, “Yala, ngayu yalarrku yurranda kari balkalda wanjungku nganya yungan.” ");
INSERT INTO gvn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yinyamun Jesusangka jananda yalaman, “Yurra yanyu story nyaka. Nyubunyimba dingkaramu kangkal-bulal jambul, dingkar-bulal. Nganjan, nyulu yabamalanda dungan, yalaman, ‘Kangkal, yundu ngaykuwunbu gardenba dungay, jurrbu nyaka, workmanijika.’ ");
INSERT INTO gvn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yabamalangka yalaman, ‘Kari, ngayu wawu kari workmanijinka.’ Yamba juma nyunguwunbu dukulbu kadan, nyulu jurrkijin baja. Nyulu nganjanandamunbu gardenba dunganda, workmanijinka. ");
INSERT INTO gvn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nganjan yabajundu dunganda, yalaman, ‘Kangkal, yundu dungayda ngaykuwunbu gardenba, workmanijika.’ Nyulu yabajungku yalaman, ‘Yalada, nganjan, ngayu dungayda.’ Yamba nyulu kari dungan.” ");
INSERT INTO gvn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesusangka jananda babajin, “Wanjingka kangkalda nganjan kuku nyajin?” Jana yalaman, “Nyulu yabamalangka.” Jesusangka yalamanda, “Ngayu yurranda balkal, jakalbaku kanbalda bamangka buyun-buyun-daman. Kanbalda tax money mujan bamandamun, buban kujin janangaku. Kanbal kalngar-baka. Yamba jana juma Godumu kuku nyajin, yinyamun jana jurrkijin, Godumu jawun-jawunman. Jana God kuku nyajinda, nyungunin wukurrinda. Yamba yurra yala kari. Yurra Godumu baral kari wukurril. ");
INSERT INTO gvn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nyulu John the Baptist yurranda kadan, yurranda Godumu kuku balkan, Godumu baral milbin. Yamba yurra nyungunin warmbin, nyungu kuku kari nyajin, nyungunku wawu kari. Jana bama taxmunku, bama kalngar-baka, jana ngadiku buyun-buyun, yamba jana Godundu jurrkijinkuda, kukumun Johnundumun. Yurra jananin nyajin walu-yindumanya, yamba yurra kari jurrkijin, nyungundu kari milka-janan.” ");
INSERT INTO gvn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesusangka yalaman baja, “Milka-janay, ngayu story yindu balkal. Nyubun dingkar bubuji jirraynji. Nyulu fence wukurrin, diburr grape nandan. Nyulu janku bakan, mayika grapemunku. Mayi grape juma kulbulmal, nyulu mayi grape jankungu-bunganka dumbarrinka, yira yunganka. Nyulu bayan jarra-jarra ngaran dindarra gardenba. Bama wuyara bundanka, miyilji bundanka, bamangka mayi grape ngakinji. Wawu yinyamun dingkarangka kanbalba bamanda yalaman, “Yurra ngayku garden ngulkurrduku kuji. Mayi grape kulbulmal, yurra kanbal kuji yurrangaku. Kanbal ngayku kuji.” Yinyamun nyulu dungan bubungu yinduymbu. ");
INSERT INTO gvn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mayi grape kulbulman, nyulu majangka bama workingmen yungan nyunguwunbu gardenba, mayi maninka. ");
INSERT INTO gvn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jana bamangka nyungu workingmen karrban, nyubun jukubu kunin, nyubun yarkinkaku kunin, yinduymbu kulji yilban. ");
INSERT INTO gvn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nyulu majangka yindu workingmen yungan baja, jarra wubul. Jana bamangka majandamunbu gardenba jananin workingmen yalarrku buyun-daman, kuninkuda. ");
INSERT INTO gvn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nyulu majangka yinya nyajin, nyulu nyungu kangkal yungan, mayi grape maninka. Nyulu nyuluku yalaman, ‘Jana bamangka ngayku kangkal nyajil, jana nyungun yulmbarril, milka-janay, kari buyun-damal.’ ");
INSERT INTO gvn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kari. Jana nyungu kangkal nyajin kankadanya, jana jana-karrajiku yalaman, ‘Ya, yanyu kangkal majamu nyubunku. Ngana nyungun yarkinkaku kunil, yanyu garden nganangada.’ ");
INSERT INTO gvn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jana nyungun karrbanda, gardenmun yilban, yarkinkaku kuninkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesusangka babajinda, “Nyulu maja nyunguwunbuku gardenba dungay baja, nyulu wanjarrmal jananka bamanka buyunku?” ");
INSERT INTO gvn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jana bamangka yalaman, “Nyulu jananin yarkinkaku kunilkuda. Yinyamun nyulu yindu bama ngulkurr manil, gardenba workmanijinka. Yinyanguyngku nyungundu kanbal mayi grape dajil baja.” ");
INSERT INTO gvn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesusangka yalamanda jananda, “Yurra kariku Godumu kuku nyajin. Godumu kuku yalaku: ‘Bamangka bayan ngaranka, jana nguba juku bakarr nyajil, yilbal. Wawu kari yaluynku jukuku. Yamba Godungku bayan ngaranka, nyulu yinya juku manil bakarrka, dandi bajaku. Godungkuku ngaral. Yinyaynka ngana wawurr-wawurrmal, ngulkurr bajaku.’” ");
INSERT INTO gvn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Jesusangka yalamanda, “Ngayu yurranda balkal, yurra balu Godumukuda jawun-karra. Kari, Godungku yurranin bawal. Nyulu yindu-yindu bama bambal nyungu jawun-karramanka, yala nyulu majangka bama ngulkurr bamban nyunguwunku gardenka, nyungu mayi dajinka. Godumu jawun-karra buyun-buyunmun jurrkijikuda, junkayku dungaykuda.” ");
INSERT INTO gvn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jana maja-majangka, Pharisee-warrangka Jesus nyajin story balkanya. Jana jana-karrajiku yalaman, “Nyulu balkan-balkaway ngananka.” ");
INSERT INTO gvn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yinyaynka jana balkawan baja, yalaman, “Ngana nyungun karrbanka, jailba mumbanka.” Kari. Jana yinyilji bamanka. Bamangka wubulduku yalaman, “Nyulu Jesusangka Godumu kuku balkal, nyulu prophetkuda.” ");
INSERT INTO gvn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesusangka jananin binal-bungan baja storybu. Nyulu jananin kari junkaynjaku binal-bungan, yamba nyulu story balkan, binal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujil. Yinya yala yanyu story. Nyubun maja jirray, king. Nyulu mayi jirray-bunganka, kangkal nyungu marrymanka. ");
INSERT INTO gvn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nyulu majangka nyungu workingman yungan bama kunjanka mayika yalbaynka. Yamba jana kari kadarin, wawu kari. ");
INSERT INTO gvn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nyulu workingman yindu-yindu yungan. Nyulu jananda yalaman, ‘Yurra bamanda yalamaka, “Ngayu mayi yalbay ready-bungan. Wubul minya bulki wandul kuninda, minya, mayi ready-bunganda, nukanka. Yurra wubulku jinbalku kadarikada.” ’ ");
INSERT INTO gvn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yamba jana bamangka jananin workingmen bayjan, kari mayinga weddingmunbu kadarin. Nyubun bama nyunguwunbu stationba dungan, yindu nyunguwunbu shopmunbu dungan. ");
INSERT INTO gvn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kanbalda bamangka jananin workingmen karrban, jukubu kunin, yarkinkaku kunin. ");
INSERT INTO gvn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yinyaynka nyulu maja king kuli-kadan. Nyulu soldier-soldier yungan, jananin bama yarkinkaku kuninka, jananga town wayjunku. ");
INSERT INTO gvn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yinyamun nyulu majangka nyunguwunbu workingmenanda yalaman, ‘Ngayu weddingmunku ready-bunganda, jana yinyarrin bama ngayu kunjan, jana ngulkurr kari, buyun. ");
INSERT INTO gvn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yurra baral-baraldarr dungayda, bama wubulku kunja. Yurra bama nyajil, kunjada, mayinga kadanka.’ ");
INSERT INTO gvn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jana workingmen dunganda, bama wubul muru-bungan weddingmunku, kanbal ngulkurr, kanbal buyun. Yinya bayanba bama wubul, kanbinkuda. ");
INSERT INTO gvn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Juma nyulu maja king kananga kadan, bama nyajinka. Nyulu nyubun dingkar nyajin, nyulu dingkarangka kambi ngulkurr kari didan. Jana yinyaymba yalaku, jana bama weddingmunku kunjal, kambi ngulkurr dajil bamanga wubulbuku, didanka. Bama wubulku kambiji ngulkurrji kadayda weddingmunbu. ");
INSERT INTO gvn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Majangka dingkaranda yalaman, ‘Jawun, yundu wanjarrku kananga kadan, kambi ngulkurr kari?’ Yamba nyulu dingkarangka nyungun kuku kari manin. ");
INSERT INTO gvn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yinyamun nyulu majangka nyunguwunbu workingmenanda yalaman, ‘Nyungun mara, and jina karrabu kaja. Ngalkalba nguwul-nguwulbu yilba. Yinyaymba nyulu badi, warrngkaykuda, dirra majajikuda.’” ");
INSERT INTO gvn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesusangka yalamanda, “Yinya story yala yanyu: Godungku bama wubulku kunjal, yamba kanbal kari milka-janay, nyungu bamamanka. Kulurku milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wawu yinyamun jana Pharisee-warra jana-karrajiku balkawan, yanday-bunganka Jesus kukubu walu ngangkal-ngangkal-bunganka, catchim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jana dingkar-dingkar wangkanin, kanbal jananga, kanbal Herodamu, jananin yungan Jesusanda. Jana Jesusanda yalaman, “Maja, nganjin binal yundu kuku manubajaku balkal. Nganjin binal yundu bama manubajabuku binal-bungal Godundumunku baralka. Nganjin binal yundu yinyil kari bamanka majanka, yundu still junkayku balkal. Kanbal yununku wawu kari, yamba yundu jananin bayjal. Yundu kuku kari jurrkil bamanka. ");
INSERT INTO gvn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yala, wanjarrmal taxmunku? Yinya yalada ngana money tax payim-bunganka majanda jirrayanda townbu Rome? Nganandamundu lawmundu kiril or kari?” ");
INSERT INTO gvn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yamba Jesus binal jana nyungun walu ngangkal-ngangkal-bunganka, catchim-bunganka. Nyulu jananda yalaman, “Yurra bulu-duray, nganya jurril-bunganka. Yurra nganya mambarrinka kuku buyun balkanka. ");
INSERT INTO gvn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kulji money ngaykundu milbi, tax payim-bunganka.” Jana kulji money dajin nyungundu. ");
INSERT INTO gvn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nyulu jananda babajin, “Walu ngurma wanjuyimbu kuljinga? Burri wanju moneynga?” ");
INSERT INTO gvn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jana yalaman, “Maja yalbay townbu Rome.” Jesusangka jananda yalamanda, “Yalada, yurra majanda yalbaymba money nyungunduku daya. Yamba Godunduku daya yinya Godumuku, money, work. Nyungundu yurraku yalarrku dajijika.” ");
INSERT INTO gvn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jana Jesusamu kuku nyajin, kungkurr-kadarinda, nyulu binal bajaku. Yinyamun jana nyungun bawan, dungarinda. ");
INSERT INTO gvn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yala-yalaku kanbal Sadducee-warra Jesusanda kadarin. Jana balu nyajil bama kari juranmal baja yarkinmun. ");
INSERT INTO gvn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Jana Jesusanda yalaman, “Maja, Mosesangka ngadiku balkan, ‘Kaki dingkar kangkal-kariku wulay, nyunguwundu yabajungku yinya jalbu bunjil wunay. Bulanga kangkal-kangkal yala yabanga kangkal-kangkal.’ ");
INSERT INTO gvn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yala, yundu yanyu story nyaka. Ngadiku yaba-yabaju 7-bala yalaymba bundandan. Nyulu yaba jakalbamunku marrymanijin, yamba nyulu kangkal-kariku wulan, manyarr bawan yabajundu. ");
INSERT INTO gvn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yabajungku jurungu bunjil manyarr wunan. Nyulu yalarrku kangkal-kariku wulaynda. Yabajungku jurungu bunjil manyarr wunanda. Nyulu kangkal-kariku wulanda. Kanbal-kanbalda yalarrku jalbu bunjil wunan yabandamun, kangkal-kariku wulan. ");
INSERT INTO gvn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yinyamun jalbuda wulan. ");
INSERT INTO gvn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kaki jumalu wubulku bama juranmal baja, manyarr wanyambaku? Jananga yaba-yabajumuku wubulbuku manyarr.” ");
INSERT INTO gvn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesusangka jananda yalaman, “Yurra wadu-wadumankuda. Yurra binal kari Godundumunku kukuku, nyunguwunku junkurrku. ");
INSERT INTO gvn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bama juranmal baja yarkinmun, jana kari marrymal baja. Jana yala jiri-warra, jana kari marrymal baja. ");
INSERT INTO gvn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yamba yurra balkal-balkawan yarkinanka, nyulu kari juranmal baja. Yurra nguba Godumu kaban kariku nyajin. ");
INSERT INTO gvn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Godungku yalaman, ‘Ngayu Abrahamamu God, ngayu Isaacamu God, ngayu Jacobamu God.’ Jana ngadiku wularin, yamba nyulu God janangaku God, jana juranku bundandanya nyungunji. Nyulu God yarkin-warramu kari. Nyulu God juran-warramuku, jana yarkinmun juranmal baja.” ");
INSERT INTO gvn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jana bamangka wubulduku yinya kuku nyajin, jana kungkurr-kadarin nyunguwunku kukuku. ");
INSERT INTO gvn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jana Pharisee-warrangka kuku nyajin Jesusangka Sadducee-warra kuku-kari-bunganya, jana wubulku murumarinda. ");
INSERT INTO gvn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nyubun janandamun, nyulu teacher lawmunku. Nyulu Jesus babanka kukubu, catchim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Nyulu Jesusanda babajin, “Maja, wanjinyaku kuku yalbayku Godungku balkan?” ");
INSERT INTO gvn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesusangka balkan, “‘Yundu wawu jirraymaka yunuwunku Godunku. Nyungun wawungu, and dukurrbu kuji, junkaynjaku junkurr-murubuku wukurrika. Milkanga Godunjiku bunday.’ ");
INSERT INTO gvn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yinya kuku yalbayku Godungku balkan. ");
INSERT INTO gvn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yanyu jarra buban kuku; ‘Yundu wawu jirraymaka bamanka yindu-yinduynku. Jananka wawu jirraymaka yala yununkuku, yala yundu yunuwunku jawun-karranka wawu.’ ");
INSERT INTO gvn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jana, Mosesangka, prophet-prophetangka, jana wubulduku bama binal-bungan yinyaynka kukuku.” ");
INSERT INTO gvn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jana Pharisee-warra murumarin Jesusanda. Jesusangka jananda babajin, ");
INSERT INTO gvn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yala nyungunku Christanka? Nyulu bamandamun wanjundumun?” Jana yalaman, “Nyulu Christ Davidandamun.” ");
INSERT INTO gvn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesusangka jananda yalaman, “Godundumundu Wawubu dayirrda Davidanda balkan Christ maja bambanka. Nyulu Davidangka Godundumunbu kabanba balkan, ");
INSERT INTO gvn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nyulu Majangka Godungku yalaman ngaykuwundu majanda, “Ngali majaku bunday, muruku. Kanbal yununku wawu kari bajaku, ngayu jananin buyun-damal. Yundu maja jirraymal jananka.” ’ ");
INSERT INTO gvn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidangka Christ maja bamban, nyulu Christ wanjarrku Davidandamun kadan?” ");
INSERT INTO gvn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jana Pharisee-warrangka nyungundu kuku kari manin baja, jana binal kari. Yinyamun jana bama wubulku yinyilmarin Jesusanda kuku babajinka baja, catchim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wawu yinyamun Jesusangka jananda balkan, jawun-karranda, yindu-yinduymbu. ");
INSERT INTO gvn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Nyulu yalaman, “Jana, teacher-teacher lawumunku, jana Pharisee-warra, jananga work bama binal-bunganka Mosesandamunku kukuku. ");
INSERT INTO gvn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yurra jananga kuku mumbarabuku wukurrika, jana kukuku Mosesandamunku binal-bunganya. Yamba jana janangaku kuku kari wukurril. Yinyaynka yurra kari balka yala jana balkal. ");
INSERT INTO gvn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jana janangaku law jururr-jururr balkal, bama buyun-damanka. Yinya yala jana junjuy-junjuy wubulku bamanda mukungu-bungal, bamangka junjuy-junjuy kulngkul jarra-kulbanka. Yamba jana Pharisee-warrangka bama kari helpim-bungal jarra-kulbanka. ");
INSERT INTO gvn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jana wawu bamangka jananin nyajinka, buyay-maninka, ngulkurrku balkawanka jananka. Jana Godumu kuku kabanba balkal, kaban mumbal boxmunbu karrkaymba, box kajal munjungu, dakilba, bamangka nyajinka. Jana junjuy yala karra kajal kambinga bijinga, bamangka nyajinka, balu bamanda milbinka jana ngulkurr bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jana mayinga jirraymba dungay, jana placemunbu ngulkurrbu bundanka. Jana Jew-warrandamunbu churchmunbu dungay, chairnga jakalba bunday, bamangka nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kaki bamangka jananin maku-nyajil, jana wawu bamangka jananin teacher bambanka. Jana majaku dungay, bamangka nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bamanda kari balka yurranin teacher bambanka. Yurra yala-karrajiku, dajalkira. Yurranga nyubunku teacher. ");
INSERT INTO gvn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yurra bama yindu-yindu kari nganjan-bunga yalaymba bubungu. Yurranga nganjan nyubunku, nyulu heavenba. ");
INSERT INTO gvn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bamangka yindu-yinduynju yurranin kari maja bamba. Nyubunku yurranga maja, ngayuku, Christ. ");
INSERT INTO gvn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nyulu bama majamanka, nyulu must nyuluku bubanmaka, yindu-yindu helpim-bunga, yala workingman ngulkurrmaka yindu-yinduynku. ");
INSERT INTO gvn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kaki bama nyuluku jirray-bungaji, Godungku nyungun buban-bungal. Kaki bama nyuluku buban-bungaji, Godungku nyungun jirray-bungal.” ");
INSERT INTO gvn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Jesusangka jananda yalaman Pharisee-warranda, teacher-teacheranda lawmunku, “Kuli jirray yurranda kaday. Yurra milka-bujarmal, bulu-duraymanya. Godungku nyungu jawun-karra ngulkurrduku kujinka. Yamba yurra bama kanbinka Godumu jawun-karramanka. Yurra yalarrku kari Godumu jawun-karramal. Yinya yala yurra door nandan Godundumunbu bayanba, bama kari walanka. Yurra ngalkalba janjanay, kari walal, yalarrku bama kanbil, walanka. ");
INSERT INTO gvn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Yurra teacher-teacher lawmunku, yurra Pharisee-warra, buyun-buyun yurranda kaday. Yurra milka-bujarmal. Yurra bulu-duray. Yurra yiringkurrku dungay, bubungu yindu-yinduymbu, bama nubinka, nyulu yurrangan wukurrinka. Kaki yurra nyungun warrmba-bungal, nyungun wadu-waduku binal-bungal. Juma nyulu jarra buyunmal yurranka, bada-bada bayanga dungay yala yurra. ");
INSERT INTO gvn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kuli jirray yurranda kaday. Yurra yala miyil-burraku dungay, bama wayanka. Yurra bama wadu-waduku binal-bungal, yurra balkal bamangka nguba wawurr-wawurr-bungal, manubaja-bunganka Godundumunku bayanka. Kaki jana yalaku wawurr-wawurr-bungal, jana kuku kari kuji. Yurra yalaku wadu-waduku binal-bungal. Yamba jana nguba wawurr-wawurr-bungal baja, and manubaja-bunganka goldku wunanay Godundumunbu bayanba, yinya kuku jana must kujikuda. Yurra yalaku wadu-waduku binal-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yurra dukul buyun. Yurra yala miyil-burra, binal kari, kiru-kari. Wanjaku jarra ngulkurr, gold or Godumu bayan? Godumu bayankuda. Yamba yinya gold yalarrku ngulkurr, Godundumunbu bayanba wunananya. Yamba Godumu bayan jarra ngulkurr goldku. ");
INSERT INTO gvn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yurra wadu-waduku bama binal-bungal. Yurra balkal, ‘Bamangka nguba wawurr-wawurr-bungal, manubaja-bunganka tableku Godundumunbu bayanba. Kaki nyulu yalaku balkal, nyulu yinya kuku kari kujinka.’ Yamba bamangka nguba wawurr-wawurr-bungal, manubaja-bunganka, presentmunku tablebu wunananya. Yurra wadu-waduku binal-bungal nyulu yinya kuku must kuji. ");
INSERT INTO gvn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yurra yala miyil-burra bajaku. Wanjaku jarra ngulkurr? Present tablebu or table? Tablekuda. Yinya present tablebu, yinya yalarrku ngulkurrman, tablebu wunananya. Yamba table jarra ngulkurr presentmunku. ");
INSERT INTO gvn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yurra nyaka. Kaki bamangka wawurr-wawurr-bungal, manubaja-bunganka tableku, nyulu yalarrku wawurr-wawurr-bungal, manubaja-bunganka presentmunku tablemunbu. ");
INSERT INTO gvn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kaki bamangka wawurr-wawurr-bungal, manubaja-bunganka Godundumunku bayanka, nyulu yalarrku wawurr-wawurr-bungal manubaja-bunganka Godunku, nyulu God bayanba bundandanya. ");
INSERT INTO gvn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kaki bamangka wawurr-wawurr-bungal, manubaja-bunganka jirika heavenmunku, nyulu yalarrku wawurr-wawurr-bungal, manubaja-bunganka Godunku, nyulu God yinyaymba bundandanya. ");
INSERT INTO gvn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Yurra teacher-teacher lawmunku, yurra Pharisee-warra, yurra bulu-durayku bunday. Kuli jirray yurranda kaday. Yurra mayi manil gardenmun, sellim-bungal, buban money Godundu dajinka. Yinya ngulkurr, yurra Mosesamu kuku yalaku wukurril. Yamba yurra Godumu kuku yalbay bayjal. Bama wanjarrmal, Godumu kuku yalbay wukurrinka? Nyulu must manun-manunmaka bamanka, ngulkurrmaka bamanka, bama junkayku juru-kulba, must Godundu milka-janay. Nyulu bama kari jurril-bunga; kari, manubajaku dungay. Godundu money dayakuda; yalarrku junkayku bunday bamanka, and Godunku. ");
INSERT INTO gvn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yurra bama juru-kulbanka, yamba yurra miyil-burra. Yurra burul-burul cup of teamun walngal, kari nukanka; yamba yurra camel yurmbilda. Yurra mumbarmal kukuku bubanka, yamba Godumu kuku yalbay bayjal. ");
INSERT INTO gvn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kuli jirray yurranda teacher-teacheranda, Pharisee-warranda kaday. Yurra bulu-duray! Yurra yalaku lawmunku: yurra plate, cup mumbarabuku julurril, yarbarrka dayirr-bungan-bungal. Yamba yurra yurranga wawu kari dayirr-bungaji. Yurra jurril-bungal, junjuy-junjuy ngakil, jumbunmanya, yurrankaku wawu. Yurra bangkarr julurrijinka, dayirrmanka, yamba yurra kari milkabu baykal yurrawunkuku wawuku buyunku. ");
INSERT INTO gvn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yurra Pharisee-warra miyil-burra bajaku. Kaki yurra bangkarrku julurriji, yurranga wawu still buyun-buyunku. Godundu jurrkijika, nyulu buyun-buyun kidanka wawumun. Yurra ngulkurrku bundayda, wawu dayirrmanya. ");
INSERT INTO gvn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kuli jirray yurranda teacher-teacheranda, Pharisee-warranda kaday. Yurra bulu-duray. Yurra yala juljal. Juljal ngulkurrijin ngalkalba, ngankaji, kulji bingaji wunanay. Yamba kananga yarkin kabumalmal. ");
INSERT INTO gvn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yurra yala juljal. Bamangka yurranin nyajil, balu ngulkurr, yamba kananga wawungu yurra buyun-buyun, bulu-duray, jurril-baka.” ");
INSERT INTO gvn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jesusangka yalaman baja, “Kuli jirray yurranda kaday, teacher-teacheranda, Pharisee-warranda. Yurra bulu-duray! Ngadi bajaku yurrawundu nganjan-karrangka jananin prophet-prophet yarkinkaku kunin. Nganjan-karrangka wawu kari prophet-prophet nyajinka Godumu kuku balkanya, wawu kari jananin nyajinka junkayku bundanya. Yurra juljal prophet-prophetamu ngulkurrduku kujin-kujil, kulji bingaji ngaral, nganka bawal. ");
INSERT INTO gvn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yurra wadu-waduku yalaku balkal: ‘Nganjin yala-yalaku prophet-prophetanji bundanyaku, nganjin jananin kari yarkinkaku kuninyaku.’ ");
INSERT INTO gvn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nyakada, yurra yurraku mala-yirrkay yurrawundu nganjan-karrangka jananin prophet-prophet yarkinkaku kunin. Yurra janandamun kadan. Jana prophet-prophet kuninkuda. Yurra yala jana; yurra janandamun kadanya. ");
INSERT INTO gvn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yalada. Yurra buyun balkan-balkal yala jana. Yurra wawu jananga work kunbay-maninka. ");
INSERT INTO gvn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yurra buyun bajaku, yala jarba. Godungku yurranin bayanga yungalkuda. ");
INSERT INTO gvn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngayu yurranda bama wubul yungal, bama ngalu-ngalu, teacher-teacher, prophet-prophet, jana bama binal-bunganka Godundumunku kukuku. Yurra jananin kunil, yala yurrawundu nganjan-karrangka jananin prophet-prophet ngadi bajaku kunin. Yurra kanbal kunil, kanbal jukungu walngkan-damal. Yindu yurra wuybubu kulbal yurrawunbu churchmunbu. Kanbal yurra kangal yiringkurrku, townmun-townmun. ");
INSERT INTO gvn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yinyaynka Godungku yurranin warrngkay-manil, yurra bama ngulkurr kuninya. Ngadi bajaku yurrawundu nganjan-karrangka bama ngulkurr-ngulkurr yarkinkaku kunin. Nyubunyinja dingkar ngulkurr, Abel yarkinkaku kunin. Yinyamun nyikurrku jana bama ngulkurr wubul yarkinkaku kunin. Jarra nyiku jana Berachiahmu kangkal, Zachariah kunin Godundumunbu bayanba yubaku kuljinga yinyaymba jana minya wayjul Godunku. ");
INSERT INTO gvn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Ngayu yurranda manubajabuku balkal: Godungku nyiku bama juranku buyun-damal, yurra, yurrawundu nganjan-karrangka bama prophet-prophet kuninya.” ");
INSERT INTO gvn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesus milka-bujarman jananka. Nyulu yalaman, “Yurra bama townmun Jerusalemmun, ngaykundu milka-janay. Yurra Godumu prophet-prophet yarkinkaku kunin, kuljibu kunin bama yinyanguy Godungku yurranda yungan. Ngayu milka-bujarmalda yurranka. Ngayu yurranin wubulku wawu ngulkurrduku kujinka, yala ngamungku jukijukingka nyungu kaykay-kaykay nangkinga muru-bungal, kujil. Yamba yurra nganya kari mambarrin. ");
INSERT INTO gvn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yinyaynka Godungku yurranga bubu bawal, yurranin kari ngulkurrduku kujil baja. ");
INSERT INTO gvn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yurra nganya kari nyajil baja, juma ngayu kadanyamunku baja. Ngayu juma kaday baja, yurra nganya nyajil baja. Ngayu kaday baja, yurra nganya nyajilda, yalamalda, ‘Nyakada, nyulu kankadayda yaluy Godundumunji junkurrji. Nyulu kankaday baja, ngana nyungun yulmbarril.’” ");
INSERT INTO gvn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus Godundumun bayanmun yalbaymun dungan-dungan. Kari, jawun-karrangka 12-balangka nyungundu kadarin, bayan Godumu milbinka, ngulkurr bajaku. Jana yalaman, “Yundu nyaka yinya bayan church yalbay.” ");
INSERT INTO gvn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yamba Jesusangka jananda yalaman, “Yurra bayan yalbay nyajin-nyajilda. Yinya bayan juma dumbarrijikuda. Yinya manubaja, bamangka kulji daray-manil, wubulku yilbal bubungu. Kulji wubulku bayanmun ngami-ngamiku bubungu wunay.” ");
INSERT INTO gvn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wawu yinyamun jana wuburrbu Olivemunbu dungarin. Nyulu Jesus bubungu bundandan, jawun-karra 12-bala nyungundu kadarin, babajin, “Bayan wanja-wanja dumbarriji? Yundu kadanjiku, yanyu bubu wanjarrmal? Wanjarrmal, bubu and jiri kunbanjiku?” ");
INSERT INTO gvn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesusangka jananda yalaman, “Yurra mumbarmaka. Bamangka kanbalda yurranin wadu-waduku binal-bunganka bubuku kunbanyamunku. Jana yurranin jurril-bunganka. Kari milka-janay. ");
INSERT INTO gvn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yala-yala bama wubul kaday, janankaku yalamal, ‘Ngayu Christ.’ Jana jurrilmal, jana Christ kari. Yamba jana bama wubul jurril-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yala-yala bama wubul mabarrba kuniway. Kanbal mabarr yubaku, kanbal kala-kalbay. Yurra nyajil, kari yinyilmaka. Jana kuniwaykuda, yamba bubu kariku kunbay. ");
INSERT INTO gvn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bama nyubunmun bubumun kuniway bamanji yindu-yinduynji bubuku yinduynku. Bubu yiringkurrku bulngaji. Bubu bulngaji baja, bulngaji baja. Mayi yamba-karimal. Bama mayi kari, dakwuyku bunday. ");
INSERT INTO gvn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yinya trouble karrkayku. Juma trouble jirray kaday. Yinya yala jalbu kulngkul. Nyulu yirrngaji bubanngarr. Nyulu juma yirrnga-yirrngangajikuda. ");
INSERT INTO gvn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Wawu yinyamun bamangka yurranin mambarril maja-majanda jirrayanda. Jana maja-majangka yurranin warrngkay-manil, yarkinkaku kunil. Bama wubul yurranka wawu kari bajaku, yurra nganya wukurrinya. ");
INSERT INTO gvn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bamangka wubulduku nganya bawal, nganya kari wukurril baja kulika. Jana yinyarrinyangka nganya bawal, jana ngaykuwunku bamanka wawu-karimal, jananin ngayku bama mambarril maja-majanda kulijinda. ");
INSERT INTO gvn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bama wubul jurrilku kaday, yala jana Godumu kuku yirrkanka. Yamba jana bama jurril-bunganka, juru-kulbanka ngaykundumun. Bama wubul jananda milka-janay. ");
INSERT INTO gvn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yala-yalala bamangka wubuldu buyun-damal baja, buyun-damal baja, buyun-buyunku bundari. Yinyaynka bama wubul yindu-yinduynku kari wawumal baja, kari ngulkurr-ngulkurr dajiway baja. ");
INSERT INTO gvn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kaki bamangka nganya kari bawal, Godungku jananin juranku kujil wuljaljiku. Bubu kunbay, Godungku nyungu bama ngulkurrduku juranku kujil, jana nyungun kari bawanya. ");
INSERT INTO gvn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Godungku nyungu bama ngulkurrduku kujil. Jana yinya Godumu kuku ngulkurr balkal bamanda wubulbuku, bubungu yindu-yinduymbu, yiringkurrku. Bamangka wubulduku kuku milkabu nyajil, yinyamun bubu and jiri kunbayda.” ");
INSERT INTO gvn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesusangka yalaman baja, “Yala-yala yurra nyubun bama buyun bajaku nyajil Godundumunbu bayanba janjananya. Nyulu kuli-baka bajaku, Godunku wawu kari bajaku. Nyulu bamanga wubulbuku kuli dajil. Nyulu prophetangka Danielangka ngadiku Godumu kuku kabanba balkan yinyaynka bamanka. Yurra yinya kuku nyaka, mumbarabuku milkabu wukurrika, binalmanka. ");
INSERT INTO gvn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bama bubungu Judea bundanday, jana nyungun yinya kuli-baka nyajil, jana wuburrbu warrida. ");
INSERT INTO gvn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bama nguba ngalkalba bayanba. Nyulu kari kananga warri, yamba-yamba maninka. Nyulu yamba-yamba bawa, jinbalku warri wuburrbu. ");
INSERT INTO gvn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bama nguba paddockmunbu workmalmal. Nyulu kari warri, kambi maninka. Nyulu kambi bawa, jinbalku warri wuburrbu. ");
INSERT INTO gvn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yala-yala jana jalbu-jalbu kulngkul, jana wanjarrmal, wuburrbu dakanka? Jana murruji warri. Buyunji. Jana jalbu-jalbu ngawanji, jana yalarrku wuburrbu kari dakal. Jananka kuli jirray. ");
INSERT INTO gvn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yurra praymaka, Godundu babajika, kari kambaranga kuli-kulimun warri, kari Saturdaymunbu warri.” Saturdaymunbu jana Jew-warra wawu-balangajin, kari workmanijin. ");
INSERT INTO gvn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jesusangka yalamanda, “Yala-yalala trouble jirray bajaku. Ngujakuramun nyikurrmankarrku, bama kariku yalaku warrngkan. Jana yinyamun yalarrku kari warrngkay baja yalaku. ");
INSERT INTO gvn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Godungku yinya trouble bubungu ngadingka kari mambarril. Nyulu ngadingka mambarrinyaku, bama wubulku wulanyaku. Nyulu yinya trouble kulka-bungal, nyunguwunku jawun-karranka nyulu wangkanin.” ");
INSERT INTO gvn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jesusangka yalaman baja jawun-karranda, “Bamangka nguba yurranda balkal, ‘Nyulu Christ yinyaymba,’ or ‘Nyulu Christ yaluy.’ Yurra yinya kuku kari nyaka, kari believeim-bunga. Bayja, warmbi. ");
INSERT INTO gvn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kanbal bama kaday, jurrilmal, yalamal, ‘Ngayu Christ.’ Yindu bama kaday, yalamal, ‘Ngayu Godumu kuku balkal-balkal.’ Jana yalarrku jurrilmal. Jana Dubundumundu junkurrdu junjuy-junjuy miracle balkal, Godumu bama jurril-bunganka. Yamba Godungku nyungu bama wangkanin nyungunku wukurrinka. Jana jurril-bakangka Godumu bama buyunku juru-kulbanka; kari, Godumu bama jurril-bakanda kari milka-janay. ");
INSERT INTO gvn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngayu yurranda yinya kuku balkan, milka-bakanka. Yurra miyil-janay jananka. ");
INSERT INTO gvn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Bamangka nguba wadu-waduku yalamal, ‘Nyulu Christ bubungu jirrbu-jirrbungu.’ Kari yinyaymba dungay. Jana nguba wadu-waduku yalamal, ‘Nyaka, nyulu yalaymba.’ Yurra yinya kuku kari nyaka; bayja. ");
INSERT INTO gvn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngayu bamanga wubulbuku yaba. Ngayu kaday baja, bamangka wubulduku nganya nyajil. Jana nganya nyajil yala bamangka yiringkurrku balbay nyajil jiringa. ");
INSERT INTO gvn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Yarkin-yarkin bubungu wunay, jana dikal-dikal waja yinyaymba murumarida, kadarida.” ");
INSERT INTO gvn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesusangka yalaman baja, “Wawu yinyamun troublemun, wungarabu jirimun karikuda balbal baja. Kijangka yalarrku karikuda balbal baja. Dawar jirimun dararida. Jana wungar, kija, dawar wubulku bulngajirida. ");
INSERT INTO gvn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yinyamun yurra nganya nyajilda kankadanya ngurrbanji jirimun. Ngayu bamanga wubulbuku yaba. Bamangka wubulduku bubungu yiringkurrku nganya nyajil kankadanya, jana milka-bujarmalda, nyirray badirida. Ngayu junkurrjiku kaday, maja jirrayku. Dayirr-dayirr bajaku kaday. ");
INSERT INTO gvn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ngayu jirimun angel wubul yungal ngaykuwunbu bamanda ngayu wangkanin. Jana angelangka trumpet wulmbarril yaykarrdaku, ngayku bama mujalda bubumun yindu-yindumun, wundil jiringa, heavenba.” ");
INSERT INTO gvn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesusangka yalaman baja, “Yinya yala juku wawuburra. Wawuburra ngankakuda, wungarajida, minyada jarrukada. Yurra nganka nyajil, yurra binalda, minyada. ");
INSERT INTO gvn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yalarrku, yurra kuli trouble nyajil, yurra binalda, ngayu nyiku baja kaday. ");
INSERT INTO gvn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ngayu manubajabuku balkal, bama jurankuda, jana wubulku wulanjiku, junjuy-junjuy warrmbamalmal yala ngayu yurranda balkanda. ");
INSERT INTO gvn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jiri and bubu kunbay, yamba ngayku kuku kari bajaku kunbay. Ngayku kuku junkurrji, kari kunbay.” ");
INSERT INTO gvn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesusangka yalaman baja, “Bama binal kari ngayu wanja-wanja baja kaday baja? Jana angel-angel binal kari wanja-wanja ngayu kaday baja. Ngayu Godumu kangkal, ngayu yalarrku binal kari. Ngaykuku nganjanku binal. ");
INSERT INTO gvn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngadiku, nyubun bama, burri Noah, nyulu junkayku bundan Godunku. Yamba bama yindu-yindu ngangkal-ngangkalku bundarin Godunku, Noah bayjan. Ngayu wubulbuku bamanga yaba. Ngayu kaday baja bubungu, bama yalaku ngangkal-ngangkalku Godunku bundari, Godunku wawu kari. Jana yala bama bundandanya yala-yalaku Noah. ");
INSERT INTO gvn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yala-yalaku jalungkarr jirray warrinjiku, bama mayinga, bananga nukajin, marrymanijin, yalaku bundandarin. Jana kuku bayjan jalungkarrmunku. Yamba jana Noah, nyungu jawun-karra 7-bala, jana boatbu walanda, jalungkarrmunku. ");
INSERT INTO gvn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yinyamundu jalungkarrda bama yindu-yindu wubulku bujil-janji-manin, jana kuku bayjanya jalungkarrmunku. Ngayu bamanga wubulbuku yaba. Yala-yalala ngayu kaday baja, bama yalaku ngangkal-ngangkalmal. ");
INSERT INTO gvn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yala-yalala dingkar jambul paddockmunbu. Jiri-warrangka nyubun manil, nyulu nguwimal karimal. Yindu bawaji. ");
INSERT INTO gvn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jalbungku jambuliynja mayi dirka-bungal-bungal. Jiri-warrangka nyubun manil, nyulu nguymal karimal. Yindu bawaji. ");
INSERT INTO gvn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nyakada. Yurra binal kari wanja-wanja ngayu yurranga maja kaday baja. Nyaka, ngayu kadanyamunku baja. ");
INSERT INTO gvn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yanyu story nyaka. Nyubun bama bayanba bundanday. Kaki nyulu binal wurrmay-baka wanja-wanja kadanka, nyulu miyilji bunday wurrmay-bakanka, nyungun karrbanka. ");
INSERT INTO gvn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yinyaynka yurra yalarrku wuljaljiku miyil-kuji nganya. Ngayu bamanga wubulbuku yaba. Yurra binal kari ngayu wanja-wanja kadanka baja.” ");
INSERT INTO gvn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesusangka yalaman baja, “Yindu story nyakada. Yurra dukul ngalu-ngalumaka, yala yanyu bama yaluy storynga. Nyubunyinja majangka nyubun workingman ngulkurr wangkanin, foreman-bunganka yindu-yinduynku workingmananka. Nyulu bama foremanman, nyulu junkayku bundan, binal bajaku. Nyulu workingmananda yindu-yinduymbu work dajin, mayi dajin, jananin ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nyulu maja kala-kalbay dungan, kadan baja. Nyulu kadan baja, nyajin yinyangka foremanangka wubulku ngulkurrduku kujinya, nyungu workingmen. Nyulu foreman wawurr-wawurrmanijinda, majangka nyungun nyajinya ngulkurrmanya. ");
INSERT INTO gvn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nyulu majangka foreman buyay-manin, yalaman, ‘Ngayu yunun maja-bungalkuda ngaykuwunku bayanka, yamba-yambaka, bubuku, wubulkuku.’” Jesusangka yalamanda, “Yurra junkayku bunday, yalala nyulu foreman. ");
INSERT INTO gvn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yamba nyulu foreman nguba kari ngulkurrku bunday. Nyulu nguba buyunmal, nguba nyuluku balkal, ‘Ngayku maja kariku kadan. Nyulu nguba kari kaday baja.’ ");
INSERT INTO gvn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yinyamun nyulu kulijimal; nyulu workingmen kunil, mayi jirray nukal, kamu-kamu nukal. ");
INSERT INTO gvn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nyulu maja kadayda, yamba nyulu foreman binal kari nyulu kadanka. Nyulu kari miyilji bundanday, kari ngulkurrduku kujin-kujil. ");
INSERT INTO gvn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Majangka nyungunin foreman murru-kangalda, nyungun warrngkay-manil, ngalkalba yilbal jurril-bakanji, bulu-duraynji. Yinyaymba nyulu nyirray-badi, warrngkay, dirra baykajikuda.” ");
INSERT INTO gvn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesusangka jananda yalaman, “Godungku nyungu bama ngulkurrduku kujil. Yinya yala yanyu story. Dingkar, jalbu marrymanijinka, wunanka. Maral-maral 10-bala jawun-karra bulanga. Jana light manin, dungarinda mayinga jirraymba, yinyarrinyangka jalbu-jalbungku yinya dunyu kujil-kujin ngalkalba. Jana bama Jew-warra yalaku. ");
INSERT INTO gvn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Maral-maral 5-bala dukul ngulkurr kari, silly-bala. Yindu 5-bala dukul ngulkurr, ngalu-ngalu. ");
INSERT INTO gvn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jana maral-maralangka silly-balangka light wundin, yamba kerosine kari wundin. ");
INSERT INTO gvn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yamba jana maral-maralangka ngalu-ngalungku kerosine wundin lightmunku. ");
INSERT INTO gvn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nyulu dingkar marrymanka, nyulu kari jinbalku kadan, maral-maral warngku kadarinda, wunarinkuda. ");
INSERT INTO gvn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Juma kunarangkalba nyurra jirray bajaku. Bama wubulku yirrkan, ‘Nyulu yanyuda! Nyulu dingkar kadanda! Ngana nyungun maku-nyajilda!’ ");
INSERT INTO gvn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jana maral-maral warngkumun wandirin, light trimim-bungan, wayjunku. ");
INSERT INTO gvn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jana maral-maralangka silly-balangka yalaman maral-maralanda ngalu-ngalundu, ‘Nganjinanda kerosine daya, nganjinanga light kerosine buban.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yamba jana maral-maralangka ngalu-ngalungku yalaman, ‘Kari. Nganjin buban kerosine wundin nganjinangaku. Kaki nganjin yurranda dajil, nganjinanga light jinbalku marralmal. Yurra storengu dungarika, buy-im-bunga yurrangaku.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jana silly-bala maral-maral kerosinemunbu warririnda. Jana dungarinda, nyulu dingkar kadan. Jana 5-bala maral-maral ngalu-ngalu, jana nyungunji kananga dungarin mayinga jirraymba. Yinyamun jana door nandankuda. ");
INSERT INTO gvn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Juma jana silly-bala kadarin baja, yirrkan dingkaranda, ‘Maja, Maja, door walnga, nganjin walarinka!’ ");
INSERT INTO gvn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Yamba nyulu dingkarangka yalaman, ‘Kari. Ngayu door kari walngal. Ngayu yurranka binal kari.’” ");
INSERT INTO gvn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesusangka jananda yalamanda, “Yurra miyil-janayda ngaykunku. Yurra binal kari ngayu wanja-wanja baja kaday baja.” ");
INSERT INTO gvn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesusangka yindu story balkan jananda. Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujil. Yinya yala yanyu story. Nyubun dingkar kala-kalbay dunganka. Nyulu dunganjiku, nyulu nyungu workingmen kunjan, yalaman, ‘Yurra ngayku bayan, yamba-yamba, bubu ngulkurrduku kuji.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nyulu jananda money dajin, junjuy-junjuy buy-im-bunganka, sellim-bunganka baja, money jirray-bunganka nyungunku. Nyubun bama, nyulu ngalu-ngalu bajaku. Majangka money jirray dajin nyungundu, 5000 dollars. Yindu bama, nyulu jarra yala. Majangka nyungundu jarra buban money dajin, 2000 dollars. Yindu bama majarr bajaku. Majangka nyungundu money buban dajin, 1000 dollars. Yinyamun nyulu maja dunganda. ");
INSERT INTO gvn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nyulu workingman 5000 dollarsmunji, nyulu jinbalku dungan, junjuy-junjuy, yamba-yamba buy-im-bunganka bamandamun. Nyulu sellim-bungan baja yinduymbu bamanda moneyka jirraynka. Nyulu juma money jirray-bungan, 10000 dollars. ");
INSERT INTO gvn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nyulu workingman 2000 dollarsmunji, nyulu yalarrku dungan, buy-im-bungan, sellim-bungan baja. Nyulu juma money jirray-bungan, 4000 dollars. ");
INSERT INTO gvn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yamba nyulu bama 1000 dollarsmunji, nyulu yinya money bubungu nandan. ");
INSERT INTO gvn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nyulu maja ngadingka kala-kalbay bundan. Nyulu kadan baja, jananin workingmen kunjan, babajin, ‘Yurra wanjarr money jirray-bungan?’ ");
INSERT INTO gvn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nyulu yinyayangka bamangka 5000 dollars manin, nyulu kadan, majanda 10000 dollars dajin. Nyulu yalaman, ‘Maja, yundu ngaykundu 5000 dollars dajin. Nyaka, ngayu jirray-bungan, 10000 dollars.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Majangka yalaman, ‘Yinya ngulkurrkuda. Yundu ngulkurrku workmalman. Ngayu yunundu money buban dajin, yundu yinya money jirray-bungan. Yinyaynka ngayu yununin maja-bungal jirraynka. Kaday, ngali wawurr-wawurrku bunday, jawun-jawunku.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nyulu yinyayangka bamangka 2000 dollars manin, nyulu kadan, majanda 4000 dollars dajin. Nyulu yalaman, ‘Maja, yundu ngaykundu 2000 dollars dajin. Nyaka, ngayu jirray-bungan, 4000 dollars.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Majangka yalaman, ‘Yinya ngulkurr. Yundu ngulkurrku workmalman. Ngayu yunundu money buban dajin, yundu yinya money jirray-bungan. Yinyaynka ngayu yununin maja-bungal jirraynka. Kaday, ngali wawurr-wawurrku bunday, jawun-jawunku.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nyulu yinyayangka bamangka 1000 dollars manin, nyulu yalarrku kadanda, yalaman, ‘Maja, ngayu binal yundu maja manun-manun kari. Yundu yunu workingmen mambarril yaykarr bajaku workmanka, yundu money jirray maninka. ");
INSERT INTO gvn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngayu yinyilji. Yinyaynka ngayu yunu money bubungu nandan. Nyaka, yunu money yanyuda.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nyulu maja kuli-kadan nyungunku. Nyulu yalaman, ‘Yundu majarr bajaku! Yundu balu ngayu money manin-manil bamandamun ngaykundu workmanya. Yinya yunundu milkanga kadan! ");
INSERT INTO gvn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yinyaynka yinya money bankmunbu yijarrinyaku. Yinya money bankmunbu wunananyaku, juma-juma money interest jirraymanyaku.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Majangka yalaman, ‘Nyungundumun yinya 1000 dollars mana, bamanda yinyayanda daya 10000 dollarsmunjirrba. ");
INSERT INTO gvn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kaki bama ngulkurrku workmal, ngayu nyungundu work jirray dajil. Kaki bama buyunku workmal, ngayu nyungundu work kari dajil baja. Ngayu nyungu work yinduymbu dajil. ");
INSERT INTO gvn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yurra yinya bama buyun ngalkalba wundi, nguwul-nguwulbu yilba. Yinyaymba nyulu nyirray badi, warrngkay, dirra baykaji.’” ");
INSERT INTO gvn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wawu yinyamun Jesusangka yalaman, “Ngayu yaba bamanga wubulbuku. Juma ngayu dayirrku kaday baja, jananin jiri-warra, angel-angel ngaykunji wundil. Ngayu kaday baja, ngayu maja jirray, kingkuda. ");
INSERT INTO gvn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ngayu bama wubulku jajirril jakalba ngaykundu. Jana murumari bubumun yindu-yindumun jakalba ngaykundu. Yinyamun ngayu jananin wangkanil, ngami-ngami-bungal. Ngayu jananin ngami-ngami-bungal yala shepherdangka dingkarangka sheep-sheep ngami-ngami-bungal goatundumun. ");
INSERT INTO gvn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nyulu dingkarangka sheep-sheep right sidemunbu yijarril; goat-goat left sidemunbu yijarril. Yinya yala ngayu bama ngulkurr ngami-ngami-bungal bamandamun buyunyundumun. ");
INSERT INTO gvn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yala-yalala ngayu maja king yalbay. Ngayu yalamalda yinyarrinyanda bamanda ngulkurrundu right sidemunbu, ‘Kadayda, ngayku nganjan wawurr-wawurrmalda yurranka. Yurra ngaykuwunbu bubungu kaday. Ngayu yinya bubu yanday-bungan yurranka, ngayu bubu yiringkurrku balkanjiku. ");
INSERT INTO gvn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngayu dakwuyman, yurra ngaykundu mayi dajin. Ngayu wawu-wulan, yurra ngaykundu bana dajin. Ngayu ngarrbalku, yurra nganya bayanba walay-manin. ");
INSERT INTO gvn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngayu kambi kari, yurra ngaykundu kambi dajin. Ngayu bambay, yurra nganya ngulkurrduku kujin. Ngayu jailba, yurra ngaykundu kadarin. Yinyaynka ngayu yurranin kunjanda, ngaykuwunbu bubungu walanka.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Yinyamun jana yinyarrinyangka bamangka ngulkurrdu yalamal, ‘Maja, nganjin wanja-wanja yunun nyajin dakwuynji, yunu mayi dajin? Nganjin wanja-wanja yunun nyajin banaka wawu-wulanya, yunu bana dajin? ");
INSERT INTO gvn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nganjin yunun wanja-wanja ngarrbal nyajin, yununin bayanba walay-manin? Yunun wanja-wanja nyajin kambi kari, yunundu kambi dajin? ");
INSERT INTO gvn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nganjin yununin wanja-wanja jailba nyajin, wanja-wanja bambayku nyajin, yunundu kadarin?’ ");
INSERT INTO gvn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ngayu maja jirray, king. Ngayu jananda yalamalda, ‘Ngayu yurranda manubajabuku balkal, kanbal ngayku bama bubankuda. Jana maja kari; buban. Yurra yinyarrinyanda ngaykuwunbu bamanda bubananda mayi, bana dajin, jananin ngulkurrduku kujin. Yinya yala yurra ngaykundu dajin, yala yurra nganya ngulkurrduku kujin. Yurra ngayku bama ngulkurrduku kujin, yinya yala yurra nganya ngulkurrduku kujin.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Yinyamun ngayu bamanda buyunyundu left sidemunbu yalamal, ‘Dungayda, ngaykuwundu nganjanangka yurranin bubungu buyunbu yungalda. Yinyaymba baya wayjun-wayjuji wuljaljiku. Nyulu yinya baya yanday-bungan Dubumu, nyunguwunbu jawun-karramu. ");
INSERT INTO gvn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngayu dakwuyman, yamba yurra ngaykundu mayi kari dajin. Ngayu wawu-wulan, yamba yurra ngaykundu bana kari dajin. ");
INSERT INTO gvn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngayu ngarrbal, yamba yurra nganya kari bayanba walay-manin. Ngayu kambi kari, yamba yurra ngaykundu kambi kari dajin. Ngayu bambayman, yamba yurra nganya kari ngulkurrduku kujin. Ngayu jailba, yamba yurra ngaykundu kari kadarin.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Jana balkalda, ‘Maja, nganjin yunun wanja-wanja nyajin, mayi kari, bana kari? Yundu wanja-wanja ngarrbalku kadan? Yundu wanja-wanja kambi kari? Yundu wanja-wanja bambay? Wanja-wanja jailba? Nganjin wanja-wanja yunun kari ngulkurrduku kujin?’ ");
INSERT INTO gvn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngayu jananda yalamalda, ‘Ngayu yurranda manubajabuku balkal, yurra ngayku bama buban kari ngulkurrduku kujin. Jananda mayi, bana kari dajin. Yinya yala yurra ngaykundu kari dajin, yala yurra nganya kari ngulkurrduku kujin.’ ");
INSERT INTO gvn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Godungku jananin bubungu bayanga yilbalkuda, jana wuljaljiku yinyaymba bundanka. Yamba Godungku jananin bama ngulkurr nyungundu kunjal. Jana nyungunji wuljaljiku bundarikuda.” ");
INSERT INTO gvn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus kuku kunban, nyulu nyunguwunbu jawun-karranda 12-balanda yalaman, ");
INSERT INTO gvn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yurra binal warngku jambulmal, bamanga Jew-warramu holiday Passover kaday. Ngana Passover mayi nukankada. Ngayu yaba bamamu wubulbuku. Jana nganya mambarrilkuda, jukungu damanka, crossmunbu.” ");
INSERT INTO gvn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jana, maja-maja Godundumunbu bayanba yalbaymba, council-council bamanka Jew-warranka, jana murumarin bayanba Caiaphasandamunbu. Nyulu Caiaphas maja jirray Godundumunku bayanka. ");
INSERT INTO gvn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jana yanday-bungal-bungan, Jesus kiraynjaku karrbanka, yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jana jana-karrajiku balkawan, “Ngana nyungun kari karrbanka Passover daymunbu. Bama kuli-kadanji, kuniwanji.” ");
INSERT INTO gvn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus townbu Bethany dungan, bayanba Simonandamunbu. Nyulu Simon jakalbaku bajiji, leprosymunji. ");
INSERT INTO gvn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nyulu Jesus mayinga nukal-nukajin, jalbu nyungundu kadan, junjuynji jila mini-miniji bottleba. Yinya junjuyumu jila mini-mini bajaku, dear-bala bajaku. Jalbungku yinya jila mini-mini nyangarrin Jesusanda dukulbu. ");
INSERT INTO gvn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jana Jesusandamundu jawun-karrangka 12-balangka yinya nyajin, jana kuli-kadarin. Jana babajin, “Wanyurrinku wumbabuku nyangarrin, wasteim-bungan? ");
INSERT INTO gvn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yinya jila mini-mini sellim-bunganyaku moneyka jirraynkaku. Moneylu dajinyaku bamanga money-karingakuda.” ");
INSERT INTO gvn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus, nyulu binal wanyu jana balkal-balkan. Nyulu jananda yalaman, “Yurra wanyurrinku yaluymu jalbumu kuli dajin-dajil? Nyulu ngulkurr balkan ngaykunku. ");
INSERT INTO gvn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bama money-kariku wuljaljiku yalaymba bunday yurranji. Yamba ngayu kari bunday baja yurranji wuljaljiku. ");
INSERT INTO gvn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nyulu ngaykundu nyangarrin bangkarrba, yanday-bunganka, jana nganya nandanka juljalba.” Bama Jew-warra yalaku, yarkin julngkan, jila mini-minibu. ");
INSERT INTO gvn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jesusangka yalaman baja, “Yinya milkanga kuji. Bamangka wubuldu juma kuku ngaykunku balkal, bubungu yindu-yinduymbu, yiringkurrku. Jana yanyunku jalbunku balkal, bama binalmanka yanyungku jalbungku ngulkurr balkan.” ");
INSERT INTO gvn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nyubun jawun, nyulu burri Judas Iscariot. Nyulu dungan maja-majanda Godundumunbu bayanba yalbaymba. ");
INSERT INTO gvn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nyulu yalaman, “Kaki ngayu Jesus mambarril yurranda, yurra wanyu ngayku dajil?” Yinyamun jana silver money 30-bala countim-bungan, nyungundu dajin. ");
INSERT INTO gvn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wawu yinyamun Judasangka good chance kujil-kujin, Jesus mambarrinka. ");
INSERT INTO gvn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","First day kadan, Passover holidaymunku. Yala-yalaku jana bread balan-balan nukan. Jawun-karra nyungu Jesusanda kadarin, babajin, “Yundu wanjabu nganjinin yunganka, mayi Passover supper yanday-bunganka yununku?” ");
INSERT INTO gvn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesusangka yalaman, “Townbu dungay, dingkarandala. Kuku wundi ngaykundumun. Nyungundu balka, ‘Nganjin kukujida kadarin Teacherandamun. Time kadaynda nyulu wulanka. Nganjin, nyunguwundu jawun-karrangka disciplesangka, and nyulu, nganjin mayi Passover nukanka yunuwunbu bayanba.’” ");
INSERT INTO gvn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jana nyunguwundu jawun-karrangka balkan yala Jesusangka jananda yalaman. Jana mayi Passover supper yanday-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wujurrman, Jesus, and nyungu jawun-karra 12-bala, jana bundarin, mayikuda nukanka. ");
INSERT INTO gvn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yala-yala jana mayinga nukal-nukajin, Jesusangka yalaman, “Ngayu yurranda balkal. Yurra ngayku jawun-karra, yamba nyubunyinja nganya mambarrinka.” ");
INSERT INTO gvn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jana milka-bujarmaynda, nyubun-nyubunku nyungundu babajin, “Wanjungku? Ngayu?” ");
INSERT INTO gvn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesusangka yalaman, “Nyulu yinyangkakubi ngaykunji bread ngabal milkulbu. ");
INSERT INTO gvn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngayu yaba bamanga wubulbuku. Ngayu wulay yala Godundumundu kabanda balkal. Yamba kuli jirray kaday bamanda nganya mambarril. Yinya dingkar kari balkajinyaku jakalbaku.” ");
INSERT INTO gvn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasangka, nyulu mambarrinka. Nyulu yalaman Jesusanda, “Teacher, wanjungku mambarril? Ngayu?” Yamba nyulu jananin jurril-bunganka. Jesusangka yalaman, “Yuwu. Yundukudabinya nganya mambarrinka, yala yundu yalaman.” ");
INSERT INTO gvn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jana mayinga nukan-nukajin, Jesusangka bread manin, God thankim-bungan breadmunku, bread dumbarrin, dajin nyunguwunbu jawun-karranda. Nyulu yalaman, “Mana, nukada. Yanyu ngayku bangkarr.” ");
INSERT INTO gvn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nyulu cup winemunji maninda, God thankim-bungan, jananda dajin, yalaman, “Yurra wubulduku nuka. ");
INSERT INTO gvn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yanyu ngayku mula. Ngayu mula warri, wulayda, buyun-buyun kidanka bamandamun wubulmunku. Godungku ngadiku bama promiseim-bungan, buyun-buyunku milka-wulanka. Godungku nyungu kuku kujilkuda, ngaykuwunku mulaka. ");
INSERT INTO gvn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngayu wine yalanguy kari nukal baja. Ngayu juma bubunguku kaday baja. God majakuda wubulkuku. Ngayu yurranjida nukal baja, wine walu-yindu.” ");
INSERT INTO gvn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jana wulngku badirinkuda, dungarinda wuburrbu burri Olives. ");
INSERT INTO gvn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesusangka jananda yalaman, “Wujurrmalkuda, yurra wubulku warri, nganya bawalda. Godundumundu kabanda balkal, ‘Ngayu yinya dingkar kunil sheep ngulkurrduku kujil. Jana sheep ngami-ngamiku warririkuda.’ Yurra warri, yanyu kuku manubajamalkuda. ");
INSERT INTO gvn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Godungku nganya yarkinmun juran-bungal baja, ngayu jakalba yurranka dungay bubungu Galilee.” ");
INSERT INTO gvn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peterangka yaykarrdaku yalaman Jesusanda, “Ngayu yunun kari bawal. Yala kanbalda yunun nguba bawal, yamba ngayu kari.” ");
INSERT INTO gvn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesusangka Peteranda yalaman, “Milkabu kuji yanyu kuku ngayku. Jukijuki yirrkanjiku, yundu kuku kulur balkal, yundu ngaykunku binal kari.” ");
INSERT INTO gvn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peterangka Jesusanda yalaman, “Ngayu kari balkal ngayu yununku binal kari. Kaki jana nganya yarkinkaku kunil, ngayu kari yalaku balkal.” Jana jawun-karrangka kanbalda yalarrku yalaman. ");
INSERT INTO gvn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yinyamun Jesus dungan nyunguwunji jawun-karranji gardenba Gethsemane. Nyulu jananda yalaman, “Yalaymba bundarika, ngayu balu dungay yinyaymba, praymanka.” ");
INSERT INTO gvn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nyulu nyungunji wundin, Peter, Zebedeemu kangkal dingkar-bulal. Nyulu milka-bujar bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nyulu jananda yalaman, “Ngayu milka-bujarmalarrku, yala junjuynju kulngkuldu nganya nyarril-nyarril. Yalaymba bundarika, ngaykunji miyil-janarika.” ");
INSERT INTO gvn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nyulu buban dungan, bubungu daran, jiba bada-bada wunan, prayman. Nyulu Nganjananda yalaman, “Nganjan, ngayu wawu kari wulanka. Yamba yunduku nganya kunjan, wulanka bamanka wubulkuku. Ngayuku wulayda jananka, yala yunduku ngaykundu balkan.” ");
INSERT INTO gvn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nyulu kadan baja jawun-karrandaku kuluruku, jananin nyajin, wunanarinya warngku. Nyulu Peteranda yalaman, “Wanyurrinku yurra kari miyil-janan ngaykunji, one hourmunku? ");
INSERT INTO gvn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Miyil-janay, praymaka, yurra kari buyun-damajinka Dubundulu. Yurra wawu ngulkurrmanka, yamba yurra nguba Dubunduku milka-janjananka.” ");
INSERT INTO gvn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus dungan baja, prayman, Godunji balkawan. Nyulu yalaman. “Nganjan, kaki yundu nganya wantim-bal wulanka, ngayu wulayda. Ngayu yunun kuku nyajil.” ");
INSERT INTO gvn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nyulu kadan baja, jananin nyajin baja, wunanarinya warngku. Jananga miyil kari bajaku walngajin, warngku jirray bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesusangka jananin bawan baja, prayman baja. Nyulu kuku yinyaku balkan baja Nganjananda, same oneku kuku. ");
INSERT INTO gvn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nyulu jawun-karrandaku kuluruku kadan baja, yalaman, “Yurra wunanariku? Nyaka. Time kadaynda nganya mambarrinka bamanda buyunbu. Ngayu yaba bamamu wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Daka, ngana dungayda. Nyaka, yinyayangka dingkarangka nganya mambarrinkada.” ");
INSERT INTO gvn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nyulu balkan-balkawan, Judas kadan. Judas nyulu Jesusamu jawun, yamba nyulu kadan Jesus mambarrinka. Jana, maja-maja Jew-warrandamunbu churchmunbu yalbaymba, and council-council, jana Judasanji bama wubul yungan, naybuji yalbaynji, jukuji. Jana bama wubulku Judasanji kadarin. ");
INSERT INTO gvn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasangka jananda jakalbaku balkan, “Ngayu dingkar kissim-bungal, milbinka wanjuku Jesus. Nyungun karrbada.” ");
INSERT INTO gvn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas kadan, junkayku dungan Jesusanda, yalaman, “Good day, Teacher.” Nyulu Jesus kissim-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesusangka yalaman, “Jawun, yundu wanyurrimbu kadan?” Jana wubulku kadarinda, Jesus karrban, yaykarrdaku kujin. ");
INSERT INTO gvn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nyubun dingkar Jesusanji, nyulu naybu kulban, nyubun dingkar yakan, milka. Yinya dingkar milka yakan, nyulu workingman majamu jirrayamu Godundumunbu bayanba yalbaymba. ");
INSERT INTO gvn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesusangka yalaman, “Yunu naybu yijarrika baja. Kaki bamangka bama naybubu yarkinkaku nyandal, yinduynju nyungun yalarrku naybubu yarkinkaku nyandal baja. ");
INSERT INTO gvn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yundu binalmaka. Kaki ngayu Nganjananda babaji helpmunku, nyulu jinbalku ngaykundu yungal angel-angel wubul bajaku, nganya helpim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yamba ngayu kari babaji. Ngayu babajinyaku, Godumu kuku kari manubajamanyaku. Nyunguwundu kabanda balkal ngayu must yalaku wulay.” ");
INSERT INTO gvn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesusangka bamanda wubulbuku yalaman, “Yurra wanyurrinku naybuji, jukuji ngaykundu kadarin, karrbanka? Ngayu wurrmay-baka kari. Yurra nganya warngku yindu-yindu nyajil-nyajinda Godundumunbu bayanba binal-bunganya, yamba yurra nganya kari karrban. ");
INSERT INTO gvn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yamba yurra yalaku balkan, Godumu kuku manubajamanka. Ngadiku jana prophet-prophetangka kuku manin Godundumun, kabanba balkan. Yinya kuku manubajamaynda.” Yinyamun jana jawun-karrangka nyungun bawan, warririnkuda. ");
INSERT INTO gvn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jana Jesus karrban, jana nyungun wundin bayanba Caiaphasandamunbu. Nyulu Caiaphas maja jirray Godundumunbu bayanba yalbaymba. Jana, teacher-teacher lawmunku, and council-council, jana wubulku murumarin yinyaymba bayanba. ");
INSERT INTO gvn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peterangka Jesus wukurrin kala-kalbaymundu. Nyulu fencemunbu walan majandamunbu bayanba, bundan yinyayanji bamanji bayan miyil-kujil-kujin. Nyulu binalmanka yinya juma wanjarrmal Jesusanda. ");
INSERT INTO gvn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jana, maja-maja, and council-council wubulku, jana bama nubin, jurril balkanka Jesusanka, Jesus yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bama wubul kadarin, jurril balkan nyungunku, yamba kariyirrku buyun. Yinyamun jambul dingkar bulal jakalba council-councilanda janan. ");
INSERT INTO gvn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Bula yalaman, “Yanyungku dingkarangka balkan, ‘Ngayu Godumu bayan dumbarril. Warngku kulurmal, ngayu bayan ngaral baja.’” ");
INSERT INTO gvn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Maja jirray dakan, Jesusanda yalaman, “Yundu bulanin nyajin yunun nyuyanya. Yundu wanyu kuku dajil baja?” ");
INSERT INTO gvn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yamba Jesus kuku-kariman. Majangka nyungundu balkan baja, “God juran, nyulu yunun nyajil-nyajilda. Yundu must manubajabuku balka, Godunku. Nganjinanda balka, yundu Godumu kangkal or kari? Yundu bama Godundumun or kari?” ");
INSERT INTO gvn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesusangka yalaman, “Ngayukuda. Ngayu yurranda balkal, yurra nganya nyajil bundandanya Godunji, ngalin junkurr-muruku bunday. Yurra nganya nyajil ngurrbanji kankadanya heavenmun. Ngayu yaba bamamu wubulbuku.” ");
INSERT INTO gvn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yinyamun majangka kambi nyungu dumbarrinda, kuku Jesusamu nyajinya. Nyulu yalaman, “Nyulu Jesusangka yalaman, ‘Ngayu Godkuda.’ Ngana bama kanbal kari mana baja, Jesusanka balkanka. Yurra nyungu kuku nyajin, buyun bajaku.” Bama Jew-warra yalaku; kaki jana kuku wadu-wadu Godunku nyajil, jana jananga kambi dumbarril. ");
INSERT INTO gvn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Majangka yalaman, “Ngana wanjarrmal?” Jana yalaman, “Nyulu Jesus malaji, nyulu must wulay.” ");
INSERT INTO gvn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jana nyumba yilban Jesusandamunbu walungu, nyungun yarbarrka kunin. Jana yalarrku nyungun marabu kunin. ");
INSERT INTO gvn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Jana nyungun kuya-bungan, yajarril-yajarrin, yalaman, “Kaki yundu bama Godundumun, yundu must binal wanyangka yunun kunin.” ");
INSERT INTO gvn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter, nyulu ngalkalba bundandan, yardmunbu. Nyubun jalbu kadan nyungundu. Nyulu jalbu workmanijin majanka jirrayanka. Nyulu Peteranda yalaman, “Yundu yalarrku Jesusamu jawun bubumun Galileemun.” ");
INSERT INTO gvn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nyulu Peterangka Jesus darrbinda. Jana wubulduku nyungun nyajin darrbinya. Nyulu yalaman, “Ngayu nyungunku binal kari. Wanyu yundu balkal-balkal?” ");
INSERT INTO gvn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Peter dungan baja gatemunbu. Yinduynju jalbungku nyungun nyajin, yalaman yinyarrinyanda dingkar-dingkaranda, “Nyulu yinyakuda Jesusanji dungan-dungan. Jesus townku Nazarethmunku.” ");
INSERT INTO gvn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peterangka Jesus darrbin baja. Nyulu yalaman, “God ngaykundu milka-janjanay. Ngayu manubajabuku balkal, ngayu binal kari yinyayanka dingkaranka.” ");
INSERT INTO gvn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kanbal dingkar yarra janjanan. Jana nyiku baja Peteranda kadan, yalaman, “Yundukuda Jesusamu jawun. Nganjin yunu kuku nyajin. Yundu balkaway yala Jesus.” ");
INSERT INTO gvn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peterangka yaykarrdaku yalaman, “Kaki ngayu kuku kari balkal manubajabuku, balu Godungku nganya punishim-bunga. Ngayu binal kari yinyayanka dingkaranka.” Jukijuki yirrkaynda. ");
INSERT INTO gvn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peteranda milkanga kadanda kuku Jesusangka balkan nyungundu. Jesusangka jakalbaku Peteranda yalaman, “Jukijuki yirrkanjiku, yundu nganya kuku kulur darrbil.” Peter ngalkalba dunganda, milka-bujarku badinda. ");
INSERT INTO gvn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yalibalaku, jana, maja-maja Jew-warrandamunbu churchmunbu, and council-council, jana balkawan, Jesus yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jana Jesus chainda kajan, wundin, Pilateanda mambarrin. Pilate, nyulu bama townmun Romemun. Nyulu maja Jew-warrandamunku bubuku. ");
INSERT INTO gvn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judasangka, nyulu jakalbaku Jesus milbin, bamangka wubulduku nyungun karrbanka. Judasangka Jesus nyajin chainji, nyulu binalmaynda jana Jesus yarkinkaku kuninka. Nyulu jiba-badinda, milka-bujarmaynda nyulu milbinya. Nyulu kari milbinyaku. Nyulu silver money 30-bala wundin baja maja-majandaku, and council-councilandaku. ");
INSERT INTO gvn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judasangka maja-majanda yalaman, “Ngayu buyunman. Jesus ngulkurr, malaji kari. Ngayu buyunman, bama ngulkurr mambarrinya, jana nyungun yarkinkaku kuninka.” Jana maja-majangka yalaman, “Nganjinanga kari business. Yunuku.” ");
INSERT INTO gvn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judasangka money yilban kananga churchmunbu, jananin bawanda. Nyulu dungan, manu kajajin, wulankuda. ");
INSERT INTO gvn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jana maja-majangka money mujan, yalaman, “Yinya money dajin, bama kuninka. Nganandamundu lawmundu ngananin kiril yinya money churchmunbu dajinka.” ");
INSERT INTO gvn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jana balkawan, wawuman, yalaman, “Yinyamundu moneybu ngana bubu maninka. Bama ngarrbal kaday, jana wulay, yinyaymba bubungu nandanka. Ngana bubu Potter's Field buy-im-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yanyu bubu jana burri dalkin “Mulaka,” jana yinya money Judasamu dajinya, nyulu Jesus mambarrinka wulanka. Jana nyiku yinyaku burri dalkil baja. ");
INSERT INTO gvn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ngadiku Jeremiah, nyulu prophet. Nyulu kabanba balkan, “Jana silver money 30-bala manin. Jana bama Jew-warra wawuman silver money 30-bala payim-bunganka nyungunku. Jana money manin, buy-im-bungan, Potter's Field. Majangka Godungku ngaykundu yinya balkan.” Jana maja-majangka yinya bubu buy-im-bungan, yinya kuku Jeremiahandamun manubajamaynda. ");
INSERT INTO gvn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus, nyulu jakalba janan majanda Pilateanda. Pilateangka Jesusanda babajin, “Yundukuda maja king Jew-warranka?” Jesusangka yalaman, “Ngayukuda.” ");
INSERT INTO gvn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jana maja-majangka, and council-councilangka, jana Jesus nyuyan, yamba Jesusangka kuku kari manin. ");
INSERT INTO gvn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilateangka nyungundu babajin, “Yundu kuku kari nyajil, jana yalamalmal junjuy-junjuynku?” ");
INSERT INTO gvn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yamba Jesusangka kuku kari bajaku manin. Pilate kungkurr-kadan, Jesusangka kari balkanya. ");
INSERT INTO gvn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Maja nyulu yalaku, nyulu Passover holidaymundurr nyubun bama yunganya jailmun. Bamangka yindu-yinduynju nyubunyinka babajin, majangka yinya nyubunyulu dingkar yungankakuda. ");
INSERT INTO gvn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yala-yalaku nyubun bama, burri Barabbas, nyulu jailba bundandan. Bama wubulku nyungunku binal. ");
INSERT INTO gvn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yinyamun jana bama murumarin. Nyulu Pilateangka jananda babajin, “Wanjaku bama yurra wawu ngayu yunganka? Barabbas or Jesus Christ?” ");
INSERT INTO gvn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nyulu binal bajaku maja-majangka Jew-warrandamundu Jesus mambarrin, jana nyungunku wawu kari bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jana bayanba courtcasemunbu. Pilate yalarrku yinyaymba bundandan. Nyunguwundu manyarrangka nyungundu kuku yungan, “Nyungun kari mambarrika, kuninka. Nyulu ngulkurr, malaji kari. Ngaykundu bijarr nyulu kadan wujurrbuku, nganya yinyil-bungan. Nyungun kari mambarrika.” ");
INSERT INTO gvn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jana, maja-maja, and council-council, jana bamanda wubulbuku balkan Pilateanda babajinka Barabbas yunganka jailmun, Jesus yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilateangka jananda babajin, “Wanjaku bama ngayu yunganka?” Jana yalaman, “Barabbas yunga.” ");
INSERT INTO gvn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilateangka jananda babajin, “Ngayu wanjarrmal Jesus Christanda?” Jana wubulduku yalaman, “Nyungun nailda dama, jukungu crossmunbu.” ");
INSERT INTO gvn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yamba Pilateangka babajin, “Wanyu nyulu buyun balkan?” Yamba jana junkurr-murubuku balkan, “Nyungun walngkan-dama, jukungu.” ");
INSERT INTO gvn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilate binal jana yirrkan-yirrkajin, marra-warrinji. Nyulu bana manin, mara julurrijin bamanda wubulbuku miyilbaku. Nyulu milbinka yinya nyungu kari fault, Jesusanka. Nyulu jananda yalaman, “Jesus wulay, ngayku kari fault. Yurranga fault.” ");
INSERT INTO gvn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bamangka wubulduku balkan, “Nganjinangaku fault, yunu kari. Kaki God yinyaynka kuli-kaday, nyulu nganjininku punishim-bungal, nganjinangaku kangkal-kangkal, yunun kari.” ");
INSERT INTO gvn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilateangka Barabbas jailmun yungaynda, nyulu soldier-soldieranda balkanda Jesus wuybubu kulbanka. Nyulu Jesus mambarrinda, jukungu walngkan-damanka. ");
INSERT INTO gvn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilateandamundu soldier-soldierangka Jesus wundin Governorandamunbu bayanba yalbaymba. Soldier-soldier wubulku nyungundu murumarin. ");
INSERT INTO gvn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jana kambi nyungu walngan, kambi ngala-ngala nyungundu didan. ");
INSERT INTO gvn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jana juku manin yala yibuy, bukul-bukulji. Jana ring balkan jukumun, Jesusanda dukulbu yijarrin. Jana juku yijarrin maranga. Jana bungkubu janankuda nyungunduku, nyungun kuya-bunganda, yajarrinda, yalaman, “Yundu maja king bamanga Jew-warranga, ngadingka bubungu bunday.” ");
INSERT INTO gvn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jana nyungundu nyumba yilban, juku manin, jukubu nyungun dukul bajaku kunin. ");
INSERT INTO gvn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jana kunban Jesus yajarril-yajarrinya. Jana kambi ngala-ngala walngaynda, nyunguku kambi didan baja. Jana nyungun wundinda, jukungu walngkan-damanka. ");
INSERT INTO gvn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jana dungan-dungarin, jana dingkar maku-nyajin, nyulu bubumun Cyrenemun kadan, burri Simon. Jana nyungun mambarrin Jesusamu cross jarra-kulbanka. ");
INSERT INTO gvn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jana bubungu Golgotha kadan. Golgotha mean Dukul Bajibay. ");
INSERT INTO gvn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yinyaymba jana nyungu wine dajinka, nukanka, wine medicineji kakaji gallmunji. Nyulu baban, yamba kari nukan baja. ");
INSERT INTO gvn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jana nyungun walngkan-daman jukungu, nyungu kambi ngami-ngami-bunganda, dice yilban wanyangka nyungu kambi manil. ");
INSERT INTO gvn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yinyamun jana bundarin, nyungunkuda kunkun-bungan-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jana kuku signmunbu balkan wanyurrinku jana nyungun nyuyan. Jana signmunbu balkan, “Yanyu dingkar Jesus, nyulu maja king bamanga Jew-warramu.” ");
INSERT INTO gvn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jana wurrmay-baka bulal jambul yinduymbu jukungu walngkan-daman. Jesus, nyulu dindarra. Bula jambul karangkalba nyungundu. ");
INSERT INTO gvn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bama walkuku dungan-dungan, Jesus yajarrin. ");
INSERT INTO gvn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Jana yalaman, “Yundu Godumu bayan yalbay dumbarrinyaku, daray-maninyaku. Warngku kulurmalda yundu ngulkurr-bunganyaku baja. Kaki yundu Godumu kangkal, juranmaka baja. Kaday, wala yinyamun jukumun.” ");
INSERT INTO gvn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jana, maja-maja Godundumunbu bayanba, teacher-teacher lawmunku, and council-council, jana nyungun yalarrku yajarrin. ");
INSERT INTO gvn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Jana jana-karrajiku yalaman Jesus yajarrinka, “Jesusangka kanbal juran-bungan, yamba nyuluku kari juranmal. Balu nyulu yinya kingkuda Jew-warramu. Kaki nyulu yinyamun jukumun walalda, ngana nyungun believeim-bungal. ");
INSERT INTO gvn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nyulu God trustim-bungan-bungal. Nyulu yalaman, ‘Ngayu Godumu kangkal.’ Yala, ngana nyajinkarr kaki Godungku nyungun juran-bungalda.” ");
INSERT INTO gvn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bula yinya-bulalangka wurrmay-baka-bulalangka nyungun yalarrku yajarrin. ");
INSERT INTO gvn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wungar jarra-jarra, bubu yiringkurrku nguwul-nguwulmaynda, 3 hoursmunku. ");
INSERT INTO gvn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","3 o'clockmaynda, nyulu Jesus kawal yaykarrku yirrkan. Nyulu nyunguwundu kukubu yalaman, “Eli, Eli, lema sabachthani?” Yinya kuku mean, “Ngayku God, ngayku God, yundu wanyurrinku nganya bawanyarrkukuda?” ");
INSERT INTO gvn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kanbal bama yinyaymba janjanan, jana nyungun nyajin yalamanya. Jana yalaman, “Nyulu yirrkajin Elijahnka.” ");
INSERT INTO gvn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nyubun bama, nyulu nyajin yirrkan-yirrkanya, nyulu nyungundu warrin, wuju manin, ngaban winemunbu, jukungu bijinga yijarrin, nyungundu dajin nukanka. ");
INSERT INTO gvn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yamba kanbalda yalaman, “Kariku, nyajinka, nguba Elijah kaday nyungun juran-bunganka, nguba kari.” ");
INSERT INTO gvn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus, nyulu kawal yirrkan baja, wulaynkuda. ");
INSERT INTO gvn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Curtain yalbay walngkal-walngkan Godundumunbu bayanba yalbaymba. Yinya curtain jambulku kadabanda, wangkar-wangkarmun bada-badarrku. Bubu bulngajin, kulji buru-warrin. ");
INSERT INTO gvn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Juljal yalarrku buru-warrin. Bama wubul Godumu juranman baja. ");
INSERT INTO gvn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jana juljalmun dakarinda. Juma Jesus juranman baja, jana townbu Jerusalemmunbu dungaynda. Bamangka wubuldu jananin yinyaymba nyajinda. ");
INSERT INTO gvn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kariku. Jana, soldier-soldier, jananga maja, jana Jesus kunkun-bungan-bungan, jana bubu nyajin bulngajinya, junjuy-junjuy wubulku buyunmanya. Jana nyajin, yinyilmarinyarrkuda. Jana yalaman, “Nyulu yinya kangkalkuda Godumukuda.” ");
INSERT INTO gvn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kanbalda jalbu-jalbungku buban kala-kalbaymundu kunkun-bungal-bungan. Jana Jesus wukurrin bubumun Galileemun, nyungun helpim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jananji bundandan jana, Mary Magdalene, and Mary, nyulu ngamu bulanga Jamesamu, Josephamu, and yindu jalbu, ngamu kangkal-kangkalba Zebedeeandamunbu. ");
INSERT INTO gvn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wujurrmalmaynda, bama nyubun kadan, bubuku Arimatheamunku. Nyulu burri Joseph, nyulu bama money jirray bajaku. Nyulu yinya dingkar yalarrku Jesusamu jawun. ");
INSERT INTO gvn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nyulu Pilateanda kadan, Jesusandamunku yarkinka babajin. Pilateangka kuku dajin, Josephanda yarkin dajinka. ");
INSERT INTO gvn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josephangka yarkin manin, kajan sheetmundu linenda jirakalda, mulun-bungan. ");
INSERT INTO gvn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nyulu yarkin yijarrin juljalba nyunguwunbuku nyiku-nyiku bakajin. Jana Jew-warra yalaku, wulanjiku, juljal bakal. Nyulu Jesus yarkin mumban yinyaymba kuljinga bulkajimunbu. Nyulu kulji yalbay yiringkan jakalba bulkajimunbu, dungaynda. ");
INSERT INTO gvn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bula, Mary Magdalene, and yindu Mary, bula bundandan jakalba bulkajimunbukulu. ");
INSERT INTO gvn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Warngku yindu, Saturday, jana, maja-maja Godundumunbu bayanba, and Pharisee-warra, jana murumarin Pilateanji. ");
INSERT INTO gvn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jana yalaman, “Maja, nyungunkuna. Nganjin milkabu kujin, nyulu jurandaku yalaman, ‘Warngku kulurmalda, ngayu juranmal baja.’ ");
INSERT INTO gvn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yinyaynka kuku daya, juljalba bundanka, miyilji. Miyilji bunday warngku kulur, nyungu jawun-karra kadanji, yarkin ngakinji, bamanda balkanji, ‘Nyulu juranman baja yarkinmun.’ Jakalbaku bama balu nyulu Godumu kangkal. Kari. Kaki nyunguwundu jawun-karrangka nyungun yarkin ngakil, bamangka balu nyulu juranman baja, yarkin kari nyajinya. Yinya buyunkuda.” Yamba jana wadu-wadu milkabu wukurrin, balu Jesus kari Godumu kangkal. ");
INSERT INTO gvn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilateangka jananda yalaman, “Soldier-soldier yungada, miyilji bundanka, juljal nyajinka.” ");
INSERT INTO gvn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jana juljalba dungarinda, karra wundin, karra junumundan kuljinga yarkinku wunanan, karra biji junumundan baja yinduymbu kuljinga jakalba wunanan. Jana yala balkan, majangka yalbaynja bama kirinya yinya karra dumbarrinka. Jana soldier-soldier juljalba bawan, miyilji bundanka, juljal nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sundaynga mudu-wayjul-wayjulda, bula Mary Magdalene, and Mary yindu, bula dungan, juljal nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jinbalku bubu yaykarrku bulngajin. Angel Majandamun bada kadan, heavenmun, kulji yiringkan bulkajimun, wuyar bundan kuljinga. ");
INSERT INTO gvn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nyulu dayirr bajaku yala balbay, nyungu kambi bingaji bajaku. ");
INSERT INTO gvn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jana soldier-soldier miyilji bundandan, jana yinyilmarinyarrkukuda, yararrin-yararrin yinyilji, dararin, yala yarkin wunanarin. ");
INSERT INTO gvn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nyulu angelangka jalbu-bulalanda yalaman, “Yubal kari yinyilmaka. Ngayu binal yubal Jesusanka nubin-nubiji. Jana nyungun jukungu walngkan-daman. ");
INSERT INTO gvn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nyulu yaluy kari. Nyulu dakaynda yala nyuluku ngadiku balkankuda. Kaday yaluy, yanyu bubu nyajinka nyulu wunanan. ");
INSERT INTO gvn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jinbal dungayda, nyunguwunbu jawun-karranda balka, ‘Nyulu dakaynda yarkinmun. Nyulu jakalba bubungu Galilee dungay, yurranka. Yinyaymba yurra nyungun nyajilkuda. Yinyada kuku ngayuda wundin.” ");
INSERT INTO gvn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jalbu-bulalangka jinbaldaku juljal bawan. Bula yinyilman, yamba bula same time wawurr-wawurrmaynda. Bula warrin, jawun-karranda balkanka. ");
INSERT INTO gvn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jesus, nyulu nguwimal milbijinda jalbu-bulalanda. Nyulu yalaman, “Yubal wawurr-wawurrmaka.” Bula nyungundu kadan, bungkubu janan, nyungu jina karrban, nyungun buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesusangka bulanda yalaman, “Kari yinyilmaka. Dungay ngaykuwunbu jawun-karranda, jananda balka bubungu Galilee dungarinka. Jana nganya yinyabi nyajil.” ");
INSERT INTO gvn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jalbu-bulal dungan-dunganda, kanbalda soldier-soldierangka miyil-kujin-kujin juljal, jana dungarin baja townbuku. Jana junjuy-junjuy wubulku balkan maja-majanda Godundumunbu bayanba. ");
INSERT INTO gvn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jana, maja-maja Godundumunbu bayanba, and council-council, jana murumarin, yanday-bungan. Jana money jirray dajin soldier-soldieranda. ");
INSERT INTO gvn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jana soldier-soldieranda balkan jurril-bunganka. Jana soldier-soldieranda yalaman, “Yurra bamanda jurril balka, yurra warngku wunanan, Jesusamu jawun-karra kadarin, yarkin ngakinda.” ");
INSERT INTO gvn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jana yalaman baja, “Kaki Majangka Pilateangka yinya kuku nyajil yurra warngku wunananya, nganjin nyungundu balkalda yurrangan kari punishim-bunganka. Yurra yinyaynka kari milka-bujarmaka baja.” ");
INSERT INTO gvn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jana soldier-soldierangka yinya money manin, bama jurril-bungan yala maja-majangka jananda balkan. Bamangka Jew-warrangka still yinya kuku jurril believeim-bungalku, jana still yinyaynka balkal-balkawayku. ");
INSERT INTO gvn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jawun-karra 11-bala wuburrbu dungarin bubungu Galilee. Jesusangka jananda jakalbaku balkan yinyaymba wuburrbu dungarinka. ");
INSERT INTO gvn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jana nyungun nyajin, nyungun buyay-maninda, worshipim-bungan. Yamba kanbalda warmbin, balu nyulu bama yindu, yamba nyulu Jesuskuda. ");
INSERT INTO gvn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus, nyulu yuba kadan, jananda yalaman, “Godungku nganya maja-bungan, wubulbuku heavenba, bamanga wubulbuku bubungu. ");
INSERT INTO gvn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dungayda, bamanda wubulbuku yiringkurrku, bubungu yindu-yinduymbu. Jananin binal-bunga ngayku bamamanka. Jananin banabu dukul-dama. Jananda balkada, ‘Yurranga majakuda Nganjanda, Kangkalda, Wawu dayirrda.’ ");
INSERT INTO gvn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jananin binal-bunga yinya kuku nyajinka ngayu yurranda balkan. Milka-janay! Ngayu wuljaljiku yurranji bundaykuda, ngulkurrduku kujinka. Bubu kunbayda wayjuji, ngayu still yurranin ngulkurrduku kujil-kujilkuda.” Yalakubada. ");
INSERT INTO gvn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yanyu kuku ngulkurr Jesusanka, nyulu Godumu kangkal. ");
INSERT INTO gvn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngadi-ngadiku Isaiahangka yanyu Godumu kuku kabanba balkan, “Milka-janay. Ngayu dingkar kukuji yungal jakalba yununku. Nyulu dingkarangka bama ready-bungal yununku. ");
INSERT INTO gvn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nyulu yirrkay-yirrkay bubungu jirrbu-jirrbungu, ‘Readymakada, Maja God kadanyamunku. Junkayku bunday, ngulkurrku bunday. Readymaka nyungunku.’” ");
INSERT INTO gvn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John nguwimal milbijinda bubungu jirrbu-jirrbungu, Godumu kuku yirrkan. Nyulu yalaman, “Yurra buyun-buyunmun jurrkijika! Ngayu yurrangan banabu dukul-damal, Godungku yurrandamun buyun-buyun kidanya, milka-wulanya yinyaynka buyun-buyunku.” ");
INSERT INTO gvn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bama wubulku Johnundu kadarin bubumun Judeamun, townmun Jerusalemmun. Jana mala-yirrkan buyun-buyunku, Johnungku jananin banabu dukul-damanda wawubajanga Jordan. ");
INSERT INTO gvn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johnumu kambi camelandamun mungkamun balkan. Wayarrimundu yulbanda nyulu kajan-kajajin. Mayi nyungu wunba, minya nyungu yinja-yinja. ");
INSERT INTO gvn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Johnungku Godumu kuku balkan. Nyulu yalaman, “Dingkar nyubunku ngaykunku kudamundu kaday. Ngayu yala nyululu kari. Nyulu maja ngulkurr bajaku, ngayu buyun. Nyulu junkurrji, ngayu burdal. ");
INSERT INTO gvn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngayu yurrangan banabu dukul-daman. Nyulu yurrangan dukul-damal nyunguwundu Wawubu dayirrda.” ");
INSERT INTO gvn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yala-yalaku Jesus townmun Nazarethmun, bubumun Galileemun Johnundu kadan. Johnungku nyungun banabu dukul-daman wawubajanga Jordan. ");
INSERT INTO gvn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus banamun wandin, nyulu wangkar-wangkarda nyajin, jiri walngajinya. Nyulu Godumu Wawu nyajin kankadanya wangkar-wangkarmun nyungundu. Godumu Wawu yala dikal bakamu. ");
INSERT INTO gvn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Godungku jirimun yalaman, “Ngayu wawurr-wawurrman yununku. Yundu ngayku kangkal. Ngayu yununku wawu jirray.” ");
INSERT INTO gvn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wawubu Godundumundu Jesus jinbalku yungan bubungu jirrbu-jirrbungu. ");
INSERT INTO gvn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nyulu bubungu jirrbu-jirrbungu bundan 40 days, kayandamunbu wild-balandamunbu bubungu. Yinyaymba Dubungku Satanangka Jesus milka-bakan buyun-damanka, yamba Jesus kari milka-janan. Jiri-warrangka nyungunin ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kanbalda bamangka John the Baptist karrban, jailba nandan. Wawu yinyamun, Jesus bubungu Galilee dungan, Godumu kuku balkanka. ");
INSERT INTO gvn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nyulu yalaman, “Timeda God maja jirraymanka. Yurra buyun-buyunmun jurrkijikakuda. God kuku nyakakuda, nyungu kuku ngulkurr believeim-bungakuda.” ");
INSERT INTO gvn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus yikindarrda jalundurr Galileeburr dungan-dungan, nyulu bulanin yaba-yabaju Simon, Andrew nyajin, makarr yilbanya, minya kuyu maninka, sellim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesusangka bulanda yalaman, “Yubal minya kuyu manin-manil. Ngaykunji kaday, yubal bamada maninka, jana Godundu jurrkijinka.” ");
INSERT INTO gvn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bula makarr bawanyarrkuda, nyungunji dungan. ");
INSERT INTO gvn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jana yubaku jarra dungarin, bulayan yaba-yabaju James and John nyajin, makarr ngulkurr-bunganya bulawunbu boatbu. Bulanga nganjan Zebedee. ");
INSERT INTO gvn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kanbal bama jananji workmanmanijin boatbu. Jesusangka bulanin yaba-yabaju kunjan, bula nganjan boatbuku bawan kanbalanji, Jesusanji dunganda. ");
INSERT INTO gvn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jana Jesus townbu Capernaum dungarin. Janawunbu bubungu bama wubulku Saturdaymundurr wawu-kujijin lawmunku. Saturdaynga jana Jesus Jew-warrandamunbu churchmunbu walan, Jesusangka bama wubulku binal-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jana kungkurr-kadarin nyunguwunku kukuku, nyulu junkurr-murubuku binal-bunganya, kari yala teacher-teacherangka ngadimunku. ");
INSERT INTO gvn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nyubun dingkar dubunji, nyulu churchmunbu walan. ");
INSERT INTO gvn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nyulu dingkar yirrkan, “Ya, yundu Jesus, yundu townmunku Nazarethmunku. Yundu ngalinyanda wanjarrmal? Ngalinin buyun-damanka? Ngayu yununku binal. Yundu Godumu kangkal, yundu junkay bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusangka dubu murru-kangan, yalaman, “Jankamaka! Wandi nyunguwunmun dukurrmun!” ");
INSERT INTO gvn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dubungku dingkar burra-warri-maninda, yaykarrku yirrkan, dingkarandamun dukurrmun wandinda. ");
INSERT INTO gvn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jana bama wubulku kungkurr-kadarin, jana-karrajiku balkawan, yalaman, “Ya, wanyu yinya? Yanyu kuku jirakal. Jesus junkurrjikuda. Nyulu dubu-dubundu junkurr-murubuku balkan, dubu-dubungku nyungun kuku nyajinda.” ");
INSERT INTO gvn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bama wubulku yiringkurr bubungu Galilee balkan-balkawan Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jana Jesus, James, John, jana Jew-warrandamun churchmun wandirin, dungarinda bayanba Simonandamunbu bulalandamunbu Andrewndumunbu. ");
INSERT INTO gvn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonamu biwul bambay wunanan, feverji. Jana Jesus balkan nyungunku. ");
INSERT INTO gvn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus nyungundu kadan, nyungu mara karrban, janay-manin. Jalbu ngulkurrkuda, karida bambay, karida wumbul. Nyulu jananga mayi wambajinda. ");
INSERT INTO gvn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bama kanbal bambay, bama kanbal dubu-dubunji. Wungar daran, bamangka yinyarrin bama wubulku wundin Jesusanda. ");
INSERT INTO gvn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bama wubul bajaku murumarin jakalba bayanba. ");
INSERT INTO gvn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesusangka bama bambaymun walu-yindu walu-yindumun ngulkurr-bungan, dubu-dubu kangan dukurrmun. Nyulu dubu-dubundu balkan, “Jankamaka,” dubu-dubu Jesusanka binalmanya. ");
INSERT INTO gvn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yalibalaku nguwul-nguwulbuku Jesus dungan bubungu jirrbu-jirrbungu, Godunji balkawanka. ");
INSERT INTO gvn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yamba jana Simonangka nyungun nubin. ");
INSERT INTO gvn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jana nyungun warrmba-bungan, nyungundu yalaman, “Bamangka wubulduku yunun nubil-nubil.” ");
INSERT INTO gvn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesusangka jananda yalaman, “Ngana townbu yindu-yinduymbu dungari. Ngayu kadan, bamanda wubulbuku balkanka Godundumunku kukuku.” ");
INSERT INTO gvn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nyulu yiringkurrku dungan bubungu Galilee, Godumu kuku Jew-warrandamunbu churchmunbu kanbalba balkan-balkan, dubu-dubu kangan-kangan bamandamun dukurrmun. ");
INSERT INTO gvn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bama yindu nyungundu kadan, yinya bama bambay, bajiji, leprosymunji. Nyulu bungkubu janan, Jesusanda babajin, “Yundu nganya ngulkurr-bungangarr. Yindu binal ngulkurr-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus jiba-badin nyungunku. Jesusangka marabu karrban nyungun, yalaman, “Yundu ngulkurrkuda.” ");
INSERT INTO gvn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bambay leprosy kunbaynda, dingkar ngulkurrkuda. ");
INSERT INTO gvn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesusangka yinyayanda bamanda junkurr-murubuku balkan, “Yundu bama yindu-yindu kari balka yinyaynka. Yundu milbijika dingkaranda priestanda churchmunbu. Law wukurrika, law Mosesangka ngadiku kabanba balkan. Minya wayju bayanga, yala lawmundu balkan. Yinyamundu balka, bamanda wubulbuku milbinka yundu ngulkurrda bambaymun.” Yinyamun Jesusangka nyungun yunganda. ");
INSERT INTO gvn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yamba yinya bama Jesusanda kari milka-janan. Nyulu dungan, bamanda wubulbuku balkan Jesusangka nyungun ngulkurr-bungan. Wawu yinyamun Jesus kari townbu dungan baja, bama wubulku murumarinya nyungundu. Yinyaynka nyulu bubungu bama-karinga bundanda. Yinyamun bama wubulku nyungundu kadarinda bubumun yindu-yindumun. ");
INSERT INTO gvn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Warngku kulurman, Jesus townbuku Capernaumku kadan baja. Bama wubulku balkawan, “Nyulu bayanbaku kadan baja.” ");
INSERT INTO gvn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bama wubulku murumarinda, bayanba walarin, bayan kanbinyarrkuda. Door yalarrku kanbin. Jesusangka kuku ngulkurr balkan jananda. ");
INSERT INTO gvn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dingkar-dingkarangka 4-balangka barrka-buyun Jesusanda jarra-kulban. ");
INSERT INTO gvn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jana kari bayanba walarin, bamanka wubulku bajaku. Jana jijinga wangkar-wangkar dakan, jijinga bulkaji bakan. Jana barrka-buyun bulkajimundurr walay-manin, bada-bada bilangkurrmunji. ");
INSERT INTO gvn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesusangka nyajin jana nyungun kuku nyajinya, binalmanya nyungunku, nyulu barrka-buyun ngulkurr-bunganka. Nyulu barrka-buyunyundu yalaman, “Ngayu yunundumun buyun-buyun kidal, yunu wawu dayirrda.” ");
INSERT INTO gvn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Teacher-teacher ngadimunku yinyay bundandarin. Jana Jesusamu kuku milkabu wukurrin. ");
INSERT INTO gvn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Jana janaku balkan, “Nyulu wanyurrinku yanyu kuku balkan? Nyulu Jesus yala Godmanka! Godungkuku bamandamun buyun-buyun kidal, bamangka kari.” ");
INSERT INTO gvn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus binal jana wanyu dukulbu kujin. Yinyaynka nyulu jananda babajin, “Yurra wanyurrinku yanyu milkabu kujil? ");
INSERT INTO gvn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngayu nyungundu balkan ngayu nyungu wawu dayirr-bunganka. Yamba yurra yurraku yalaman, ‘Nguba, nguba kari. Nyulu still wunanay, bambaynji.’ Kari. Ngayu nyungundu balkalda, ‘Dakada, jinabu dungayda.’ ");
INSERT INTO gvn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngayu milbilda ngayu Godundumun, ngayu junkurrji, bamandamun buyun-buyun kidanka.” ");
INSERT INTO gvn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nyulu barrka-buyunyundu yalaman, “Dakada, bilangkurr mana, bayanbaku dungayda.” ");
INSERT INTO gvn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nyulu barrka-buyun dakan, bilangkurr manin, dungan kanamun bamandarrku. Bama wubulku kungkurr-kadarin, God buyay-manin. Jana yalaman, “Ngana ngadiku yala kari nyajin.” ");
INSERT INTO gvn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus jalunbuku dungan baja. Bama wubulku nyungundu kadarin, Jesusangka jananin binal-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jesus dungan-dungan, nyulu bama yindu nyajin bundandanya officemunbu, burri Levi, nyungu nganjan Alphaeus. Levingka bamandamun tax money mujal-mujan Governmentamu. Jesusangka Levinda balkan, “Nganya wukurrika.” Levi dakan, Jesuskuda wukurrin. ");
INSERT INTO gvn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesus, nyungu jawun-karra, jana juma mayinga nukal-nukajin Levindamunbu bayanba. Jananji bama wubul yinyarrin Jesusanji dungan-dungarinya. Kanbalda bamangka yinyarrinyangka tax money mujal-mujan Governmentamu. Kanbal bama yinyarrin buyun bajaku. ");
INSERT INTO gvn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kanbal bama yinyarrin teacher-teacher ngadimunku, kanbal yinyarrin Pharisee-warra. Teacher-teacherangka ngadimunduku Jesus nyajin nukan-nukajinya bamanji buyunyunji, bamanji tax money mujal-mujan Governmentamu. Jana teacher-teacherangka Jesusandamunbu jawun-karranda babajin, “Nyulu wanyurrinku nukaji jananji tax collectoranji? Jana buyun bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesusangka yinya kuku nyajin, yalaman, “Bama yinyarrin ngulkurr, doctor jananda kari kaday. Yinyarrinku bama bambay, janandaku yinyarrinyandaku doctor kaday. Ngayu kari kadan, bama ngulkurr kunjanka. Kari. Ngayu kadan, bama buyun kunjanka, jana buyun-buyunmun jurrkijinka.” ");
INSERT INTO gvn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jana, Johnundumundu jawun-karrangka, Pharisee-warrangka, jana mayi kari nukan-nukan, Godunji balkawanka baja. Kanbal bama Jesusanda kadarin, babajinda, “Yunuwundu jawun-karrangka wanyurrinku mayi kari bawan, Godunji balkawanka baja? Jana, Johnundumundu jawun-karrangka, Pharisee-warrangka, jana yinyaynka mayi kari nukal-nukalda.” ");
INSERT INTO gvn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesusangka jananda yalaman, “Kari. Ngayu yala bridegroom. Bamangka weddingba mayi kari bawal, bridegroom jananji bundandanya yinyay. ");
INSERT INTO gvn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yamba juma kuli-bakangka nganya karrbal. Ngaykuwundu jawun-karrangka mayida bawal. ");
INSERT INTO gvn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nguba yundu mararr jirakal damal kambinga mukulbu. Kaki yundu kambi julurril, mararr jirakal mulun-mulunmanijida. Kambi dumbarriji, yika-warri. Kanka yalbaymalda. ");
INSERT INTO gvn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yundu yira kari nyangarrika kurmunbu yulbanba mukulbu. Kaki yira jila kaday, kurmun mukul kadabalda, yira nyangarrijida, kurmun buyunmalda. Yundu yira kurmunbu yulbanba jirakalba nyangarrika.” ");
INSERT INTO gvn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Saturdaynga, jana, Jesus, nyungu jawun-karra, jana dungan-dungarin wheat paddockmundurr, jana mayi murrngan, nukan. ");
INSERT INTO gvn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pharisee-warrangka Jesusanda yalaman, “Ngadimunku lawmundu nganangan kiril mayi murrnganka Saturdaynga.” ");
INSERT INTO gvn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesusangka jananda yalaman, “Yurra Godumu kaban nyajin Davidanka. Jana David ngadiku dakwuynji bundandarin, jana wanjarrman? ");
INSERT INTO gvn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David Godundumunbu bayanba walan, mayi bread nukan. Nyulu bread wanyamba nukan? Yinya bread bamangka Godundu dajin. Davidangka yinya bread nukan, dajinkuda jawun-karranda. Lawmundu yinya yalarrku kirin, yinya bread nukanka. Jana priest-warrangkaku yinya bread nukanyaku.” ");
INSERT INTO gvn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesusangka jananda yalaman, “Ngadiku Godungku bamanda yalaman, ‘Yurra workmanijika warngku 6-bala, wawu-kujijika warngku nyubun.’ Godungku yinya yalaman, bama kari bambaymanka baja workmun. Godungku bama helpim-bunganka lawmundu. ");
INSERT INTO gvn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngayu wubulbuku yaba. Ngayu maja Saturdaymunku.” ");
INSERT INTO gvn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus Jew-warrandamunbu churchmunbu walan baja, dingkar yindu yinyaymba, nyulu mara wulan. ");
INSERT INTO gvn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kanbalda bamangka Jesus kunkun-bungal-bungan, nyulu nguba yinya dingkar ngulkurr-bungal, nguba kari. Jana Jesus nyuyanka, buyun-damanka. Jana bama balkawan, “Nyiku Saturday. Nyiku kari workmanijika, lawmunku ngadimunku.” ");
INSERT INTO gvn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesusangka dingkaranda mara-wulanyamunbu yalaman, “Kaday jakalba.” ");
INSERT INTO gvn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesusangka jananda bamanda yalaman, “Nganawundu lawmundu nganangan kiril Saturdaymunbu workmanijinka. Ngayu wanjarrmalda? Ngayu yinya dingkar nguba ngulkurr-bungal, nguba buyun-damal. Wanjinyaku ngulkurr, nguba juran-bunganka, nguba kuninka.” Yamba jana jankamaynda. ");
INSERT INTO gvn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesusangka walu-wukurrin janangan, kuli-kadaynda. Yamba nyulu yalarrku jiba-badinda jananka, jana dukul-dandi bajaku, wadu-wadu. Nyulu dingkaranda mara-wulanyamunbu yalaman, “Yunu mara junkay-bunga.” Nyulu mara junkay-bungaynda, mara yalada, buyun karida. ");
INSERT INTO gvn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jana Pharisee-warra dungarinda, murumarin Herodandamunji jawun-karranji, balkawanka Jesus yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesus, nyungu jawun-karra jalunbu Galilee dungarin, bamangka wubuliynja bajaku nyungun wukurrin. Yinyarrin bama bubumun Galileemun kadarin, bubumun Judeamun, townmun Jerusalemmun, bubumun Idumeamun, naka-nakamun wawubajamun Jordanmun, jambulmun townmun Tyremun, Sidonmun kadarin. Bama wubul bajaku Jesusanda kadarin, jana kuku nyajinya nyungunku, wanyu nyulu balkan-balkanya. ");
INSERT INTO gvn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Bama bambay yalarrku nyungundu murumarin, nyulu bama wubul ngulkurr-bunganya bambaymun. Jana jurrngan-jurrngan, nyungun karrbanka, yamba bama wubul bajaku. Jesusangka nyunguwunbu jawun-karranda yalamanda, “Yurra boat yuba-bunga. Nganya bamangka jurrngan-jurrngal.” ");
INSERT INTO gvn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kaki bamangka dubunjida Jesus nyajin, jana nyungunduku daran, yirrkan, “Yundu Godumu kangkal.” ");
INSERT INTO gvn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesusangka dubu-dubundu junkurr-murubuku balkan, “Yurra bamanda kari balka ngaykunku.” ");
INSERT INTO gvn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus wangkar-wangkar wuburrbu dungan, bama kunjan nyulu bambanya. Jana nyungundu kadarinda. ");
INSERT INTO gvn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nyulu dingkar-dingkar 12-bala bamban, nyungunji dungan-dungarinka. Nyulu jananin juma yunganka, kuku ngulkurr balkanka. ");
INSERT INTO gvn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nyulu jananda junkurr dajinka, dubu-dubu bamandamun kanganka. ");
INSERT INTO gvn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yanyurrin burri yinyarrin dingkar-dingkar 12-bala. Simon. Jesusangka burri yindu dajin, Peter, nyungu. ");
INSERT INTO gvn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Dingkar jambul Zebedeemu kangkal bulal. Bulanga burri James and John. Bula yarbarrka jinbalku kuli-kadanya, Jesusangka bulanda burri yindu dalkin, Jarramali Bajaku. ");
INSERT INTO gvn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yindu dingkar-dingkar burri Andrew, Philip, Bartholomew, Matthew, Thomas, James, nyulu kangkal Alphaeusamu. Thaddaeus, Simon, nyulu muna bajaku. ");
INSERT INTO gvn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yindu dingkar burri Judas Iscariot. Juma nyulu Jesus mambarrin bamanda buyunyundu. ");
INSERT INTO gvn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wawu yinyamun jana Jesus bayanbaku dungarin baja. Bama wubulku murumarin baja. Jana Jesusangka mayi kari nukan baja, bamanka wubulkuku. ");
INSERT INTO gvn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nyunguwundu familyngka yinya kuku nyajin, jana nyungundu dungarin, maninka, wundinka baja. Kanbalda yalaman, “Nyulu kiru-kari.” ");
INSERT INTO gvn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Teacher-teacher ngadimunku townmun Jerusalemmun kadarin. Jana Jesusanka yalaman, “Nyulu dubu-dubu kangalkuda, yamba nyulu junkurr manil dubu-dubundumun majandamun, yinyayangka majangka nyunguwunbu dukurrbu walanya.” Yamba jana jurrilman. ");
INSERT INTO gvn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesusangka bama kunjan, nyungundu kadanka, nyulu janangan binal-bunganka kukubu. Nyulu yalaman, “Dubu-dubumu maja nyuluku kari kangaji, nyulu nyungu yindu-yindu dubu-dubu kari kangal. ");
INSERT INTO gvn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kaki bama bubu muruku jana-karrajiku ngami-ngamimal, jana junkurr karimal. Bama yindu-yindu kadari, jananji kuniwanka, jananin kunbay-manil. Bama yinyaynka bubuku yamba-karikuda. ");
INSERT INTO gvn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bama nyubunkuku bayanka nguba kari jawun-jawunku bundari, nguba kuniway. Juma yinyarrin bama yamba-karimalkuda. ");
INSERT INTO gvn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kaki dubu-dubu jana-karrajiku kangaway, jana ngami-ngamimalkuda. Jana kunbayda, yamba-karikuda. ");
INSERT INTO gvn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Bama nguba dingkarandamunbu junkurrjimunbu bayanba walanka, yamba-yamba ngakinka. Wurrmay-bakangka jakalba dingkar karrabu kajal, yinyamun ngakilkuda. ");
INSERT INTO gvn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ngayu manubajabuku balkal. Kaki bama buyun-buyunmun jurrkiji, God yinyarrinyandamunku bamandamunku buyun-buyunku milka-wulay. Nyulu yalarrku milka-wulay janandamunku kukuku buyunku. ");
INSERT INTO gvn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kari. Kaki bamangka buyun balkal Godundumunku Wawuku, God yinyaynka buyunku kari milka-wulay. Jananga buyun-buyun wuljaljiku bunday. God kari milka-wulay kukuku jurrilka nyunguwunku Wawuku.” ");
INSERT INTO gvn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesusangka yinya kuku balkan, kanbalda yalamanya, “Dubu Jesusandamunbu dukurrbu walan.” ");
INSERT INTO gvn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yinyamun Jesusamu ngamu, yabaju-karra kadarin. Jana ngalkalba bayanba janjanarin, kuku yungan nyungundu, jananda kadanka. ");
INSERT INTO gvn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bama wubulku nyungunduku kananga bundandarin. Jana nyungundu yalaman, “Yunu ngamu, yabaju-karra ngalkalba janjanari. Jana wawu yundu kadanka jananda.” ");
INSERT INTO gvn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesusangka yalaman, “Wanju ngayku ngamu? Wanju ngayku yabaju-karra?” ");
INSERT INTO gvn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesusangka bamanda wubulbuku walu-wukurrin, yalaman, “Bama yaluy bundandari yala ngayku ngamu, yala ngayku yabaju-karra. ");
INSERT INTO gvn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kaki yurra God kuku nyajil, yurra ngayku jawun-karrakuda. Yurra yala ngayku yabaju, yala ngayku jinkurr, yala ngayku ngamu.” ");
INSERT INTO gvn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesusangka binal-bungan baja yikinba jalunbu, bama wubulku murumarinda, yuba kadarin. Boat yikinba baja bananga. Jesus boatbu walan, bama wubulku yikinba bubungu bundarin. ");
INSERT INTO gvn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nyulu jananin junjuy-junjuynku binal-bungan storybu. ");
INSERT INTO gvn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nyulu jananda yalaman, “Milka-janay! Dingkar nyubun dungan, mayi diburr corn ngami-ngamiku yilbanka bubungu gardenba. ");
INSERT INTO gvn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nyulu diburr yilbal-yilban, kanbal diburr daran baraldarr. Jana dikal kadarin, nukal-nukajinda. ");
INSERT INTO gvn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Diburr kanbal daran bubungu kulji-kuljingaku, yinyaymba bubu wawu-darra kuljiburr. Jurrbu jinbalku wandirin, ngara buban, yinya bubu wawu-darra. ");
INSERT INTO gvn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wungar jalaman, jurrbu nganjaymanijin, ngara kari. ");
INSERT INTO gvn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kanbal diburr daran buljunbu bukul-bukuljirrba. Buljun jirraymaynda, buljundu jurrbu kanbinda, jurrbu kari jirrayman, mayi kari balkajin. ");
INSERT INTO gvn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yamba diburr kanbal bubungu ngulkurrbuku daran. Jurrbu jirraymaynda, mayi balkajin. Mayi diburr bubanku kanbalba balkajin, diburr 30-bala. Yinduymbu mayi diburr jarra yalbayku balkajin, diburr 60-bala. Yinduymbu mayi diburr yalbay bajaku balkajin, diburr 100-bala.” ");
INSERT INTO gvn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesusangka yalaman, “Kaki yurra binalmanka, yurra milka-janay mumbarku.” ");
INSERT INTO gvn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bama wubul yinyamun dungarin. Yamba kanbal bawajin, Jesusanda murumarinda. Nyunguwundu jawun-karrangka 12-balangka, and bamangka kanbalda Jesusanda babajin, “Nganjin binal kari storyka. Balka.” ");
INSERT INTO gvn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesusangka jananda yalaman, “Ngayu yurrangan binal-bungal-bungal Godungku nyungu bama ngulkurrduku kujinka. Yamba jana kanbalda nganya kari wukurril. Yinyaynka ngayu janangan storybu binal-bungal. ");
INSERT INTO gvn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Godumu kuku yalaku, ‘Jana nyajin-nyajil, yamba jana binal kari. Jana binalmanyaku, jana Godundu jurrkijinyaku, nyulu janandamun buyun-buyun kidanyaku.’” ");
INSERT INTO gvn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesusangka jawun-karranda, and bamanda yindu-yinduymbu babajin, “Yurra binal kukuku storyka yinyaynka? Kaki yurra binal kari yinyaynka kukuku, yurra yalarrku binal kari yindu-yinduynku kukuku. ");
INSERT INTO gvn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ngayu yurranda milkanga-bungal story diburrku. Diburr yala Godumu kuku. ");
INSERT INTO gvn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kanbal diburr baraldarr dararin. Kanbalda bamangka Godumu kuku nyajil, yamba jana dukul-dandi yala baral. Dubu-dubu kaday, kuku manilda bamandamun, yala dikalangka diburr manin baralmun. ");
INSERT INTO gvn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yindu bama yala bubu kulji-kuljiji. Jana Godumu kuku nyajil, wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yamba jana ngara kari, yala jurrbu bubungu kulji-kuljiji, Godumu kuku buban milkanga kadan. Bamangka yinduynju kuli dajil jananda, jana God kuku nyajinya. Yinyamun jana Godundumunku kukuku wawu karida, God bawalda. ");
INSERT INTO gvn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Kanbal diburr daran buljunbu bukul-bukuljirrba. Kanbal bama yala yinya bubu. Jana Godumu kuku nyajin, yamba jana jumbun yamba-yambaka. Jana money jirray maninka, junjuy-junjuy wubulku maninka. Yamba-yambaka jumbunmanyamundu Godumu kuku kanbil yala buljundu jurrbu kanbin, mayi kari balkajinka. ");
INSERT INTO gvn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Diburr yindu daran bubungu ngulkurrbu. Kanbal bama yala yinya bubu. Jana God kuku nyajil, milkanga kujilda, wukurrilda, junkayku dungankada, Godunku workmalda, ngulkurrku. Kanbal yinyarrin bubanku workmal Godunku, kanbal jarra yalbayku workmal, kanbal yaykarrku workmal Godunku. Jana wubulku ngulkurrku workmal Godunku.” ");
INSERT INTO gvn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesusangka jananda yalaman, “Kaki bamangka light wayjul, nyulu kari nandal bucketmundu, kari yijarril bada-bada bedba. Kari. Nyulu light tablebu yijarril, lightmundu balbanka. ");
INSERT INTO gvn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kanbalda bamangka nguba junjuy-junjuy kiraynjaku kujil, yamba juma bama wubulku binalmal baja. Kaki bamangka kiraynjaku balkal, juma wubulku binalmal baja. ");
INSERT INTO gvn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kaki yurra binalmanka, yurra milka-janay mumbarku.” ");
INSERT INTO gvn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesusangka jananda yalaman, “Yanyu kuku milkabu kuji. Kaki yundu God kuku nyajil and wukurril, nyulu yunu yalbayku dajil, yunun wawurr-wawurr-bungalkuda. ");
INSERT INTO gvn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kaki yurra ngaykundu mumbarku milka-janay, ngayu yurranin yalbayku binal-bungal, ngayku kuku milkanga-bungal. Kaki yurra ngaykundu kari mumbarku milka-janay, ngayu kari binal-bungal baja, yurra ngaykuwunku kukuku milka-wulaykuda.” ");
INSERT INTO gvn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesusangka yalaman baja, “Godungku nyungu bama ngulkurrduku kujil, yinya yala wanyu? Yinya yala diburr dingkarangka bubungu yilban. ");
INSERT INTO gvn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Warngku yindu-yindu yinya dingkar workmanijinya, warngku wunanya. Juma jurrbu wandiri, jirraymalda. Yamba yinya dingkar binal kari, jurrbu wanjarr baja wandirin? Wanjarr baja jirraymarin? ");
INSERT INTO gvn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bububu jurrbu dakay-manil. Jakalba birrangarr wandil, juma nganka dakal, yalbaymal, mayi kayalku, kulbulmalda. ");
INSERT INTO gvn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mayi kulbulmalda, dingkarangka murrngalda.” ");
INSERT INTO gvn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesusangka yalaman, “Godungku nyungu bama ngulkurrduku kujil, yinya yala wanyu? Ngayu yurranda story balkal, milkanga-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Godumu kuku yala mustard diburr. Diburr bubungu yilbaji, diburr karrkay bajaku. ");
INSERT INTO gvn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Diburrmun jurrbu wandil, yalbaymal, juku yalbay bajakuda. Dikal-dikalangka bulkakuda balkal jukungu dakilba wabarrba.” ");
INSERT INTO gvn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesusangka story yindu-yindu balkan jananda. Kaki jana readyman binalmanka, nyulu balkan. ");
INSERT INTO gvn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nyulu bama wubulku kuku balkan storybu. Yamba nyulu nyungu jawun-karra mumbarabuku binal-bungan, jananda mumbarabuku milkanga-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wungar daraynda, Jesusangka jawun-karranda yalaman, “Ngana ngundu-ngundumun ngubar-ngubar jalunbu dungarikuda.” ");
INSERT INTO gvn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jana bama wubulku bawan, jawun-karra dakarinda boatbu Jesus bundandanya, jana dungarinda. Bama kanbal jananji dungarin yinduynju boatdu. ");
INSERT INTO gvn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Muku muyariji jarramali kadan, mulngku jirray bajaku kadan. Bana jirraykuda boatbu mulngkumun. ");
INSERT INTO gvn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus warngku wunanan kurmunbu bada bijikanba. Jawun-karrangka nyungun walngan, babajin, “Maja, yundu wawu ngana wubulku bujil-janjinka?” ");
INSERT INTO gvn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus dakan, muyar murru-kangan. Nyulu jalunbu yalaman, “Marrkamakada! Jankamakada!” Muyar kunbaynda, jalun marrkamaynda. ");
INSERT INTO gvn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nyulu jananda babajin, “Yurra wanyurrinku yinyilmarin? Wanyurrinku nganya kari kuku nyajil?” ");
INSERT INTO gvn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jana kungkurr-kadarinda, yinyilmarin, balkawaynda, “Nyulu wanju? Muyarabu, and jalundu nyungun kuku nyajil. Nyulu muyar, jalun marrka-bungal.” ");
INSERT INTO gvn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jana, Jesus, nyungu jawun-karra, jana jalunbu ngubar-ngubar kadarin, bubungu Gerasa. ");
INSERT INTO gvn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus bubungu jalaman, nyubun dingkar nyungundu kadan. Nyulu dingkar dubu-dubunji, bundandan juljalba. ");
INSERT INTO gvn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Bamangka yindu-yinduynju jurungu-jurungu yinya dingkar kajan. Jana ngarri, dakil chainda kajan baja, kajan baja, yamba nyulu chain dumbarrin baja, dumbarrin baja, nyulu junkurrji bajaku. Bamangka karida kajan baja, jana nyungun kari minday-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nyulu dingkar wujurrdurr, wungaraburr dungan baja, dungan baja, wuburrdurr, juljaldarr dungan baja, dungan baja, yirrkan-yirrkanya, nyuluku kuljibu yakan-yakajinya. ");
INSERT INTO gvn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yinyangka dingkarangka Jesus kala-kalbaymun nyajin, Jesusanda warrin, bungkubu janan. ");
INSERT INTO gvn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesusangka nyungundu yalaman, “Yundu dukurrmun wandi dingkarandamun.” Nyulu dingkar yaykarrku yirrkan, yalaman, “Yundu Jesus, yundu Godumu kangkal, nyulu God junkurrji bajaku. Yundu wanjarrmanka ngaykundu? Nganya kari punishim-bunga, kari warrngkay-mana.” ");
INSERT INTO gvn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesusangka nyungundu babajin, “Yundu burri wanju?” Nyulu yalaman, “Ngayku burri Big Mob, nganjin wubul yalurrin.” ");
INSERT INTO gvn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dingkar Jesusanda babajin, “Yalurrin dubu-dubu yalamun bubumun kari yungajika.” ");
INSERT INTO gvn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yinyaymba wuburrbu bikibiki wubul bajaku nukal-nukajin, jana mindaykuda. ");
INSERT INTO gvn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jana dubu-dubungku Jesusanda babajin, “Yundu nganjinin bikibikinda yunga, nganjin bikibikinda dukurrbu walanka.” ");
INSERT INTO gvn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesusangka jananin yunganda bikibikinda. Dubu-dubu dingkarandamun dukurrmun wandirin, bikibikinda dukurrbu walarin. Bikibiki wubul bajaku, 2000-bala. Wubulku warrarin, ngamarmun dararin, bada-bada jalunbu, bujil-janjirinda. ");
INSERT INTO gvn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jana dingkar-dingkarangka bikibiki kujil-kujin, yinyarrinyangka bikibiki nyajin bujil-janjirinya. Jana warrinda, bamanda wubulbuku balkan, kuku yiringkurrkuda. Bama wubulku kadarinda, nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jana bama Jesusanda kadarin, yinya dingkar nyajin, dubu-dubu wandinya dukurrmun. Nyulu Jesusanji bundandan, kambijida, nyungu dukul ngulkurrmaynda. Yinyaynka jana bama yinyilmarinda. ");
INSERT INTO gvn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yinyarrinyangka bamangka nyajin, jana bamanda wubulbuku balkan Jesus dubu-dubu kangan, bikibiki bujil-janjirin. ");
INSERT INTO gvn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wawu yinyamun bamangka wubulduku Jesusanda balkan, “Yundu yalamun dungayarr.” ");
INSERT INTO gvn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus boatbuda walal-walan, yinya dingkar nyungundu kadan. Nyulu Jesusanda babajin, “Ngayu yununji kadanka.” ");
INSERT INTO gvn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yamba Jesusangka nyungundu yalaman, “Yundu kari kaday ngaykunji. Dungay jawun-karrandaku, balka Maja God yununku ngulkurr bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nyulu dingkar bubungu 10-townbu dungan, wubulbuku yalaman, “Jesusangka nganya ngulkurr-bungan, dubu-dubu kangan ngaykuwunmun dukurrmun.” Bama wubulku kungkurr-kadarin dingkaranka. ");
INSERT INTO gvn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus boatdu jalundurr ngubar-ngubarku dungan baja. Nyulu yikinbada, bama wubul kadarinda, murumarinda nyungundu. ");
INSERT INTO gvn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dingkar nyubun Jesusanda kadan, nyulu burri Jairus, nyulu maja yalbay Jew-warrandamunku churchmunku. Nyulu Jesusanda kadan, bungkubu janan. ");
INSERT INTO gvn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nyulu Jesusanda yalaman, “Ngayku kangkal wulan-wulayda. Yundu kadayarr, marabu karrba, juran-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesus dingkaranji dunganda. Bamangka wubulduku wukurrin, yubaku dungan-dungarin, room kari bajaku. ");
INSERT INTO gvn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jana wubulku dungan-dungarin, jalbu yindu yinyaymbarrku kadan. Nyulu mula wanarrin 12-yearsmunku. ");
INSERT INTO gvn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nyulu yindu-yinduymbu doctoranda dungan, yamba nyulu kari ngulkurrman baja, buyunmanyarrkuda. Nyulu kulji karida, dajinyarrkukuda doctoramu yindu-yinduymbu. ");
INSERT INTO gvn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Jalbungku kuku nyajin Jesusanka. Nyulu nyuluku balkan, “Kaki ngayu nyungu kambi karrbal, ngayu ngulkurrmalda.” Nyulu Jesusanda kudamundu kadan bamandarr wubulburrku, nyungu kambi marabu karrbanda. ");
INSERT INTO gvn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nyulu jinbalku bambaymun ngulkurrmaynda, mula kari warrin baja. Nyulu binal nyulu ngulkurrkuda. ");
INSERT INTO gvn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus binalda junkurr nyungundumun dunganda. Nyulu jurrkijin, bamanda wubulbuku babajin, “Wanjungku ngayku kambi karrban?” ");
INSERT INTO gvn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nyunguwundu jawun-karrangka nyungundu yalaman, “Bama wubulku yuba kadarin. Wanjungku baja yunun karrban?” ");
INSERT INTO gvn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yamba nyulu walu-wukurrin baja, bama nyajinka nyungun karrbanya. ");
INSERT INTO gvn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nyulu jalbu binal nyulu ngulkurrman, nyulu Jesusamu kambi karrbanya. Nyulu Jesusanda kadanda, yinyilji. Nyulu bungkubu janan, Jesusanda bambay-bambaynka manubajabuku balkan. ");
INSERT INTO gvn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesusangka jalbundu yalaman, “Yundu ngulkurrman, yundu nganya kuku nyajinya. Kari yinyilmaka. Dungay, yundu bambaymun ngulkurrmankuda.” ");
INSERT INTO gvn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus jalbunji balkan-balkawan, bama kanbal kukuji kadarin majandamun bayanmun. Kukujingka majanda yalaman, “Yunu kangkal wulaynda. Jesus kari wundi baja.” ");
INSERT INTO gvn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yamba Jesusangka yinya kuku bayjan. Nyulu majanda yalaman, “Kari milka-bujarmaka, kari yinyilmaka. Nganya kuku nyaka.” ");
INSERT INTO gvn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bama wubulku Jesusanji dungarinka baja, yamba Jesusangka jananin kirinda. Nyulu kulurku wundin. Peter, James, Jamesamu yabaju John, janaku Jesusanji dungarin baja. ");
INSERT INTO gvn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jana majandamunbu bayanba kadarin, Jesusangka bama wubulku nyurra nyajin yaykarrku banbadinya. ");
INSERT INTO gvn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesus bayanba walan, bamanda babajin, “Yurra wanyurrinku nyurra-nyurramanmaniji? Wanyurrinku banbadi? Yinya maral karibi wulan, nyulu warngku wunanay.” ");
INSERT INTO gvn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yamba jana nyungun yajarrin. Jesusangka janangan ngalkalba yunganda. Jana, Jesus, jawun kulur, maralamu ngamu, nganjan, jana kananga walarin, maralanda dungarin. ");
INSERT INTO gvn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesusangka maral marabu karrban. Nyulu nyunguwunduku kukubu yalaman, “Talitha, kumi.” Yinya kuku mean, “Maral, ngayu yunun balkal, dakada.” ");
INSERT INTO gvn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yinya maral dakanda, jinabu dungaynda. Nyulu yalbay, 12 years old. Jana kungkurr-kadarinda yinyaynka. ");
INSERT INTO gvn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesusangka jananda kuku dajin, yalaman, “Yurra bamanda yindu-yinduymbu kari bajaku yinyaynka balka.” Yinyamun nyulu jananda yalaman, “Maralamu mayi dayada.” ");
INSERT INTO gvn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jana, Jesus, nyungu jawun-karra yinyamun dungarin, bubunguku nyunguwunbuku. ");
INSERT INTO gvn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jesusangka Saturdaynga bama binal-bungan Jew-warrandamunbu churchmunbu. Bama wubulku nyunguwunku kukuku kungkurr-kadarin, balkawan, “Wanyu yinya? Nyulu jirakal kuku dajil-dajil. Wanjundumun nyulu manin? Wanjarrku nyulu junjuy-junjuy miracles balkal? Nyulu binal bajaku! ");
INSERT INTO gvn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ngana nyungunku binalbi, nyulu Marymu kangkal. Nyungu yabaju-karra James, Joses, Judas, Simon. Nyungu jinkurr-karra yalurrinkubi. Nyulu carpenter yalamunku.” Jana nyungunku kuliman, nyungunku wawu karida. ");
INSERT INTO gvn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesusangka jananda yalaman, “Kaki prophetangka Godumu kuku balkal yiringkurrku, bama mumbarku milka-janay. Yamba nyulu nyunguwunbuku bubunguku dungay jawun-karrandaku, jana jawun-karra nyungundu kari milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesusangka kulur bama marabu karrban, bambaymun ngulkurr-bungan. Nyulu kari wubulku ngulkurr-bungan, because jana nyungunku wawu kari. ");
INSERT INTO gvn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nyulu milka-bujarman, jana nyungun kari kuku nyajinya. Jesus yindu-yinduymbu town-townbu dungan, binal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nyulu jawun-karra 12-bala kunjan, jambul-jambulku yunganka. Nyulu jananga junkurr dajin, dubu-dubu kanganka. ");
INSERT INTO gvn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Nyulu jananda kuku dajin, yalaman, “Ngayu yurrangan yungalkuda. Yamba-yamba kari wundi. Kambi, mayi, kurmun, money kari wundi. Dambal dida, and jaba wundi.” ");
INSERT INTO gvn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nyulu jananda yalaman, “Yurra townbu kadari, nyubunyimbaku bayanba wunay until yurra yinyamun townmun dungarinyamunku. ");
INSERT INTO gvn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yurra townbu kadari, jana nguba yurranin kari yulmbarril, jana nguba wawu kari yurranda milka-jananka. Yurra dungarika baja yinyamun townmun. Bulbur jinamun dudajika, milbinka jana buyun. Bulburubu yinyangka milbil jana bama buyun, jana Godundumunbu kukungu kari milka-jananya.” ");
INSERT INTO gvn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jawun-karra dungarinda, Godumu kuku yirrkan. Jana yalaman, “Yurra buyun-buyunmun jurrkijika, God kuku nyaka.” ");
INSERT INTO gvn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jana dubu-dubu bamandamun dukurrmun kangan, oil dukulbu bamanda yindu-yinduymbu julngkan, ngulkurr-bunganka bambaymun. ");
INSERT INTO gvn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herod, nyulu maja jirray, king, bubuku Galileemunku. Nyulu kuku nyajin Jesusanka, bama wubulku balkan-balkawanya Jesusanka. Kanbalda balu Jesus nyajin John the Baptist. Jana yalaman, “Nyulu John the Baptistkuda. Nyulu John ngadiku wulan, yamba nyulu kadan baja, juranman baja. Yinyaynka nyulu miracles balkal-balkal junkurr-murubuku.” ");
INSERT INTO gvn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bamangka yinduynju yalaman, “Nyulu Elijah ngadimunku. Nyulu juranman baja.” Bamangka yinduynju yalaman, “Nyulu yala prophet-prophet ngadimunku. Jana prophet-prophetangka yalarrku Godunku binal-bungan.” ");
INSERT INTO gvn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodangka nyajin bama balkan-balkawanya Jesusanka, nyulu yalaman, “Nyulu Johnkudabi. Ngayu nyungu manu nyandankuda, yamba nyulu juranman baja.” ");
INSERT INTO gvn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Ngadiku Herodangka nyunguku yabajumuku manyarr wunan. Nyungu manyarr burri Herodias, nyungu yabaju burri Philip. Johnungku Herodanda yalaman, “Yunu yabajumu manyarr kari wunanyaku. Nyungun bawa.” Yinyaynka Herodias Johnunku kuli-kadan. Herodangka soldier-soldier yungan, John karrbanka, jailba nandanka. Herodiasangka John yarkinkaku kuninka, yamba Herodangka Herodias kirin John kuninka. Herod yinyilji Johnunku, because Herod binal John junkayku dungan-dungan Godundumundurr baraldarr. Herodangka John nyajinya Godumu kuku balkanya, yinyamun nyulu yinyilman. Nyulu yinyilji Johnundumunku kukuku, yamba nyulu still John nyajinka. ");
INSERT INTO gvn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kari. Herodiasangka chance maninda John kuninka. Herodangka birthday party haveim-bungan, mayi jirray ready-bungan, maja-maja wubul kunjan partynga. Kanbal dingkar-dingkar yinyarrin maja-maja Herodandamunku governmentmunku, kanbal maja-maja soldier-soldieranka, kanbal moneyji jirraynji. ");
INSERT INTO gvn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Herodiasamu kangkal jalbu bayanba walan, jakalba maja-majanda wurin. Jana wawurr-wawurrman nyungunku. Herodangka maralanda babajin, “Yundu wanyurrinku wawu? Ngayu yunu junjuy dajinka. Yundu yalunku wawu, ngayu yunu dajilda. Ngayu maja yalbay bubuku yalbaynka. Kaki yundu wawu bubuku, ngayu yunu kankur dajil. Jana yindu-yinduynju nganya nyajin yunun promiseim-bunganya.” ");
INSERT INTO gvn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Maral ngalkalba dungan, ngamundu babajin, “Ngayu wanyurrinku babaji?” Ngamungku yalaman, “Yundu babajika Johnundumunku dukulku.” ");
INSERT INTO gvn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maral jinbalku bayanba walan baja, Herodanda yalaman, “Yundu John manu nyanda, nyungu dukul plateba yijarrika, ngayku daya.” ");
INSERT INTO gvn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nyulu Herod milka-bujarmanda, nyulu maral promiseim-bunganya. Yamba nyulu kuku kari jurrkinka, jawun-karrangka nyungun nyajinya maral promiseim-bunganya anything dajinka. ");
INSERT INTO gvn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yinyaynka Herodangka soldier jinbaldaku kunjan, nyungundu yalaman, “Yundu John manu nyanda.” Soldierangka jailba dungan, John manu nyandanda. ");
INSERT INTO gvn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nyulu dukul plateda wundin, maralanda dajin. Maralangka ngamundu dajin. ");
INSERT INTO gvn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Johnundumundu jawun-karrangka yinya kuku nyajin, jana John yarkin manin, juljalba nandan. ");
INSERT INTO gvn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesusamu jawun-karra 12-bala kadarin baja bubumun yindu-yindumun Jesusangka jakalbaku janangan yungan. Jana nyungundu yalaman, “Nganjin Godundumunku kukuku binal-bungan, dubu-dubu bamandamun dukurrmun kangan, bama wubul ngulkurr-bungan bambaymun.” ");
INSERT INTO gvn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bama wubulku kankadarin Jesusanda. Jana kadan baja, kadan baja. Jesusangka, jawun-karrangka mayi kari nukan baja bamanka wubulkuku. Yinyaynka Jesusangka jawun-karranda yalaman, “Nganarrku dungarinka bubungu bama-karinga, wawu-kujijinka.” ");
INSERT INTO gvn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jana janarrku boatji dungan-dungarinda bama-karinga. ");
INSERT INTO gvn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yamba bamangka wubuldu janangan nyajin dungan-dungarinya, binal wanjabu jana dungarinka. Jana bama wubulku jinabu warririn townmun yindu-yinduymun yinyaymba Jesus dungan-dungan. Jana janangarr jakalba warrin Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus boatmun jalaman, jananin bama wubulku nyajin. Nyulu jiba-badin jananka, bama yamba-kari janangan helpim-bunganka, Godunku binalmanka. Yinyaynka Jesusangka janangan binal-bungan baja, binal-bungan baja. ");
INSERT INTO gvn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yilay-yilaymanda nyungu jawun-karra nyungundu kadarin, yalaman, “Mayi yaluy yamba-kari, wungar kuwakuda. ");
INSERT INTO gvn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Janangan bama yunga bayanba, townbu, mayi janangaku maninka.” ");
INSERT INTO gvn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesusangka yalaman, “Yurraku mayi daya jananga.” Jana nyungundu babajin, “Yundu wawu nganjin mayi maninka moneybu 200 dollarsmundu, jana nukanka?” ");
INSERT INTO gvn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nyulu jawun-karranda babajin, “Yurranga wanjarrkuda bread? Dungarika, nyakada.” Jana nyajin, yalaman, “Bread 5-bala, kuyu jambul.” ");
INSERT INTO gvn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesusangka jananda wubulbuku yalaman, “Yurra bundarikada jikanba, kanbal yinyaymba, kanbal yalaymba, kanbal yinyaymba.” ");
INSERT INTO gvn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jana bundarin. Kanbal 100-bala muruku bundarin, kanbal 50-bala muruku bundarin, yalaku. ");
INSERT INTO gvn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesusangka mayi, minya jambul manin. Nyulu jiringa nyajin, God thankim-bungan, mayi dumbarrin, jawun-karranda dajin, bamanga wubulbuku wambanka. Jesusangka kuyu jambul yalarrku wamban bamanga wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bamangka wubulduku nukan, yanjimankuda. ");
INSERT INTO gvn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yinyamun jawun-karrangka kurmun 12-bala jakal-bungan mayibu yandaynja, minyabu yandaynja. ");
INSERT INTO gvn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bamangka dingkar-dingkarangka wubuldu bajaku mayi nukan, 5000-balangka. ");
INSERT INTO gvn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesusangka jawun-karranda yalaman, “Yurra boatbu walarika, naka-naka jalunbu dungarika, townbu Bethsaida jakalba ngaykunku. Ngayu bama wubulku yungal bayanbaku.” ");
INSERT INTO gvn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nyulu bama wubulku goodby-bungan, yalaman, “Ngayu dungayda.” Nyulu wuburrbu dungan, Godunji balkawanka. ");
INSERT INTO gvn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wujurrmanda, Jesusamu jawun-karra jalundurr dungan-dungarin boatji, Jesus nyulurrku bubungu. ");
INSERT INTO gvn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Muyar jirray kadan. Jana birungubaynja yaykarrdaku manil-manin, baja-burranda. Jesusangka nyajin janangan muyarabu yimbal-yimbanya. Yubakuda mudu-wayjul-wayjun nyulu jananda kadan, bananga wuyar jinabu kadan, janandarrku dunganka. ");
INSERT INTO gvn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jana nyungun nyajin wuyara banaburr kankadanya, jana balu nyajin dubu, yirrkajinda, yinyilmaynda. ");
INSERT INTO gvn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jana wubulduku nyajin, yinyilji bajaku. Jesusangka jananda yalaman, “Bangkarr dandimaka, ngayu Jesus. Kari yinyilmaka.” ");
INSERT INTO gvn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nyulu boatbu dakan, muyar kunbayn. Jana kungkurr-kadarinda. ");
INSERT INTO gvn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jana kari mumbarku binalman Jesusangka bread jirray-bungan. Yinyaynka jana kungkurr-kadarin, nyulu wuyara banaburr dunganya, muyar janka-bunganya. ");
INSERT INTO gvn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Jana naka-naka kadarin, bubungu Gennesaret, boatmun jalaman, boat kajan yikinba. Bamangka kanbalda nyungun jinbaldaku nyungun-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jana bama wubulku warrarin bamanda bambay-bambayanda, jananin Jesusanda bilangkurrmundu wundinka. Jana bama bambay-bambay wubulku wundin yinyaymba Jesus bundandan. ");
INSERT INTO gvn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus townbu yindu-yinduymbu kadanya, bamangka kanbalda bambay-bambay maninya, bawanya dindarra townbu. Jana bambayangka baban-babajinya Jesusanda, “Nganjin yunu kambi karrbanka.” Bambay-bambayangka wubulduku karrbanya, ngulkurrmaynda. ");
INSERT INTO gvn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Jew-warra wubulku mara julurrijinya mayi nukanjiku, jana yalaku. Jana julurrijin yalaku binga-bingangka ngadimunku balkan. Binga-bingangka ngadimunku yalaman, “Kaki mara kari julurriji mumbarku, bamangka law ngujakuramunku buyun-damal.” Kaki bama Jew townmun kaday, nyulu mara julurrijika, nukanjiku. Binga-bingangka jananda yalarrku law yindu-yindu dajin ngujakuraku. Jana must pannikan, billycan mumbarabuku julurrika, buyun kidanka. Jana Pharisee-warrangka law ngujakura mumbarabuku wukurrin. Jana, teacher-teacher lawku ngadimunku townmun Jerusalemmun kadarin, murumarinda Jesusanda. Jana Jesusamu jawun-karra nyajin mayi nukal-nukanya. Yamba Jesusamu jawun-karra kari mara julurrijin, mayi nukanjiku. ");
INSERT INTO gvn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jana, Pharisee-warrangka, teacher-teacherangka lawku ngadimunku, jana Jesusanda yalaman, “Yunu jawun-karra mara kari julurrijin, mayi nukanka. Jana law kari wukurrin.” ");
INSERT INTO gvn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusangka jananda yalaman, “Ngadi-ngadiku Isaiahangka Godumu kuku kabanba balkan. Nyulu yurranka balkan, yurra jurril. Godundumundu kabanda balkal, ‘Godungku yalaman, “Jana ngaykunku ngulkurrku balkan-balkaway. Yamba jana bulu-duray, ngaykunku wawu kari. ");
INSERT INTO gvn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jana wumbaku ngaykundu praymal, jurrilmal-jurrilmal, jana nganya kari kuku nyajinya. Jana kari binal-bungal kukuku ngayuku balkan. Jana binal-bungal kukuku bamangkaku balkan.” ’ ");
INSERT INTO gvn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yurra God kari kuku nyajil, yurra bamaku kuku nyajil.” ");
INSERT INTO gvn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesusangka jananda yalaman baja, “Yurra jurrilda Godumu way wukurrinka, yamba yurra wawubu yurrangaku way wukurrinka. Yurra Godumu law bawankuda. ");
INSERT INTO gvn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ngadi-ngadiku Mosesangka Godumu law kabanba balkan. Nyulu balkan, ‘Yurra nganjan, and ngamu kuku nyaka, ngulkurrduku kuji. Kaki yundu nganjan, and ngamu yukil, bamangka yunun yarkinkaku kuni.’ ");
INSERT INTO gvn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Yamba yurra yinya Godumu kuku walu-yindu-bungan. Yurra wadu-waduku balkalda, ‘Bama nyubun nguba junjuynji, ngamundu, nganjananda dajinyaku, bulanin helpim-bunganka. Yamba nyulu nguba wawu kari bulanda dajinka. Yinyaynka nyulu Godundumunbu bayanba wundi, kanbal priest-warranda dajinka, kanbal wundinka baja bayanbaku.’ Yinyamun nyulu kari bulanda dajil baja, bulangan kari ngulkurrduku kujil baja. ");
INSERT INTO gvn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yurrawundu lawmundu Godumu kuku kanbinda. Yurra yalaku jurrilmalmal.” ");
INSERT INTO gvn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesusangka bama wubulku kunjan, nyungundu kadarinka. Nyulu jananda yalaman, “Yurra milka-janay, binalmaka, kuku nyaka. ");
INSERT INTO gvn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kaki yundu mayi nukal, yundu yinya mayi ngandalba walay-manil. Yinyangka mayibu yunun kari buyun-damal. Kaki yundu kuku buyun-buyun balkal, yinya kuku ngandalmun dakal. Yinyangka kukubu yunun buyun-damalda, buyun-buyun dukurrmun dakanya. ");
INSERT INTO gvn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kaki yurra binalmanka, yurra milka-janay mumbarku.” ");
INSERT INTO gvn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jana, Jesus, jawun-karra bayanba walarin, bama wubulku bawan. Jawun-karrangka Jesusanda babajin, “Yinya kuku balka, milkanga-bunga.” ");
INSERT INTO gvn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nyulu jananda babajin, “Yurra binal kari yinyaynka kukuku? Kaki yundu junjuy-junjuy nukal, yinyamundu mayibu yunun kari buyun-damal. ");
INSERT INTO gvn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mayi waralba walal, yinyamun dungay baja. Mayi dukurrbu kari walal. Yinyamundu mayibu yunun kari buyun-damal.” Yinyamundu Jesusangka balkan yalada mayi wubulku nukanka. ");
INSERT INTO gvn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nyulu yalaman, “Yundu dukurrmun junjuy-junjuynku buyunku balkal, yinyamundu yunun buyun-damal. ");
INSERT INTO gvn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bamangka milkabu wukurril buyun, yinya dukurrmun. Yinyaynka nyulu kalngarmanka, wurrmaymanka, yarkinkaku kuninka, ");
INSERT INTO gvn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jumbunmanka, buyunmanka, jurrilmanka, money-bakamanka, ngura-nyajinka, binda-damanka, bulmbuymanka, kiru-kari bajaku. ");
INSERT INTO gvn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yinyarrinyangka buyun-buyundu bama buyun-bungal, dukurrmun dakanya.” ");
INSERT INTO gvn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wawu yinyamun Jesus dungan, bubungu yubaku townbu jambulbu Tyre, and Sidon, bayanba bundandan. Nyulu wawu kari bama binalmanka nyulu yinyaymba. Yamba bama binalman nyulu yinyaymba. ");
INSERT INTO gvn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nyubun jalbu bundandan yinyaymba. Ngadiku dubu nyunguwunbu kangkalanda jalbundu dukurrbu walan. Yinyayangka ngamungku kuku nyajin Jesusanka, nyulu jinbalku Jesusanda kadan, bungkubu janan. ");
INSERT INTO gvn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jew-warra wawu kari bamanka walu-yinduynku. Jana yalamal, “Jana bama yala kaya.” Yinya jalbu Jew kari, nyulu Gentile, nyungu bubu yubaku townbu jambulbu Tyre, and Sidon, nyungu kuku Greek. Jalbungku Jesusanda babajin, “Yundu ngaykundumun kangkalandamun dukurrmun dubu kangangarr?” ");
INSERT INTO gvn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesusangka nyungundu yalaman, “Nganjin mayi dajil kaykay-kaykayandangarr. Bamangka mayi kaykay-kaykayamu kari kayanga yilbal.” ");
INSERT INTO gvn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jalbungku Jesusanda yalaman, “Yaladabi, Maja. Kaykay-kaykayangka mayida nukal, mayi yanday bubungu daray. Kayangka yinya mayi yanday nukalda.” ");
INSERT INTO gvn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesusangka nyungundu yalaman, “Yundu yinya kuku ngaykundu yalamanya, ngayu yunu kangkal ngulkurr-bungan. Yundu dungayda. Dubu dungaynda yunuwunmun kangkalandamun dukurrmun.” ");
INSERT INTO gvn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jalbu bayanbaku dunganda. Nyulu bayanba kadan, kangkal warrmba-bungan wunananya bedba. Dubu dungaynda. ");
INSERT INTO gvn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wawu yinyamun Jesus bubumun yubamun townmun Tyremun dungan, towndurr Sidondurr dungan, bububurr Ten Townsmundurr dungan, jalunbu Galilee kadan. ");
INSERT INTO gvn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kanbalda bamangka dingkar wundin Jesusanda, milka-kari, kuku-kari. Jana wawu Jesusangka dingkar marabu karrbanka, ngulkurr-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesusangka yinya dingkar bamandamun wubulmunku wundin, mara milkanga yijarrin, nyumba yilban, nyabil karrban. ");
INSERT INTO gvn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nyulu jiri nyajin, wawu yilban, nyunguwundu kukubu yalaman, “Abada.” Yinya mean, “Milka walngajika!” ");
INSERT INTO gvn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dingkaramu milka walngajinda, ngulkurrkuda, nyulu kuku yirrkanda. Nyulu kuku ngulkurrku balkan-balkawanda. ");
INSERT INTO gvn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesusangka bamanda yalaman, “Yurra kari balka yinyaynka.” Yamba jana dungarin, wubulku balkan. Jesusangka balkan baja, “Kari balka.” Yamba jana dungarin baja, balkan baja. ");
INSERT INTO gvn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jana bama kungkurr-kadarin, yalaman, “Nyulu junjuy-junjuy ngulkurrduku balkal. Nyulu bama milka-buyun ngulkurr-bungal, bama kuku-kari kukuji-bungal.” ");
INSERT INTO gvn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yinyamun bama wubulku murumarin baja Jesusanda. Jananga mayi yamba-kariman, wanyu baja nukal? Jesusangka jawun-karra kunjan, nyungundu kadarinka, jananda yalaman, ");
INSERT INTO gvn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngayu jiba-badi jananka, jana mayi-karida. Jana ngaykunji warngku kulurkuda bundarin, mayi-karikuda. ");
INSERT INTO gvn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kanbal kala-kalbaymun kadarin. Kaki ngayu janangan mayi-kariku yungal bayanbaku, jana dakwuynji buyunmanji, miyil-dunganji, daranji, mayi-karimunku.” ");
INSERT INTO gvn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nyunguwundu jawun-karrangka babajin, “Yanyu bubu marral bajaku, mayi kari. Nganjin wanjamun baja mayi bread manil, wambanka? Bama wubul bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesusangka jananda babajin, “Yurranga mayi bread wanjarr?” Jana yalaman, “7-bala.” ");
INSERT INTO gvn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesusangka bamanda wubulbuku yalaman, “Yurra, bubungu bundarikada.” Nyulu mayi bread 7-bala manin, God thankim-bungan breadka, mayi dumbarrin, dajinda jawun-karranda, jana mayi wambanka bamanga wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jananga minya kuyu kulur. Jesusangka God thankim-bungan minyaka kuyuku, jawun-karranda yalaman, “Minya kuyu yalarrku wamba.” ");
INSERT INTO gvn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bamangka wubulduku nukan, yajinmaynda. Jana kurmun 7-bala jakal-bunganda, mayibu yandaynja, minyabu yandaynja. ");
INSERT INTO gvn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bama wubul bajaku, 4000-bala. ");
INSERT INTO gvn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesusangka bamanda wubulbuku yalaman, “Yurra bayanbaku dungarikada.” Nyungu jawun-karra, Jesus boatbu walarinda, bubungu Dalmanutha dungarin. ");
INSERT INTO gvn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jana Pharisee-warra Jesusanda kadarin, nyungunji murru-kangawan. Jana yalaman, “Yundu junjuy miracle balka Godundumundu junkurrdu. Nganjinanda milbi yundu junkurr manin Godundumun.” Yamba jana nyungun walu ngangkal-ngangkal-bunganka kukubu. ");
INSERT INTO gvn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesusangka wawu yalbayku yilban, babajin, “Bamangka wanyurrinku ngaykundu babaji junjuy miracle balkanka Godundumundu junkurrdu? Ngayu yurranda manubajabuku balkal. Bamangka yalu-warrangka kari nyajil junkurr wangkar-wangkarmun.” ");
INSERT INTO gvn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nyulu janangan bawan, boatbu walan baja. Nyulu, nyungu jawun-karra naka-naka jalunbu dungarinda. ");
INSERT INTO gvn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesusandamundu jawun-karrangka boatbu mayi bread nyubunku wundin, milka-wulan mayi jirray wundinka. ");
INSERT INTO gvn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesusangka jananda yalaman, “Jananga Pharisee-warramu and Herodamu kuku yala yeast. Yeastmundu mayi bread wubay-manil. Yurra mumbarmaka kukuku Pharisee-warranka and Herodunku.” ");
INSERT INTO gvn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jawun-karra jana-karrajiku balkan-balkawan yinyaynka, yalaman, “Nyulu yinya balkan because ngananga mayi bread yamba-kari.” ");
INSERT INTO gvn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus binal jana yinyaynka balkan-balkawan. Yinyaynka nyulu jananda yalaman, “Yurra wanyurrinku balkan-balkaway, bread yamba-kari? Yala yurra kariku binalman? Yala yurra dukul-dandi? ");
INSERT INTO gvn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yurra miyiljida, nyajinyakuda. Yurra milkajida, nyajinyakuda.” Nyulu jananda babajin, “Yurra breadka milka-wulan? ");
INSERT INTO gvn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngananga mayi bread 5-bala, yamba ngayu jirray-bungan, yurra wambanda bamanga wubulbuku, 5000-balanda. Mayi yanday wanjarr bawajin?” Jana nyungundu yalaman, “Kurmun 12-bala jakal-bungan yandaynja.” ");
INSERT INTO gvn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesusangka yalaman, “Juma-juma ngayu mayi bread 7-bala jirray-bungan, yurra wambanda bamanga wubulbuku, 4000-balanda. Mayi yanday wanjarr bawajin?” Jana yalaman, “Kurmun 7-bala.” ");
INSERT INTO gvn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesusangka jananda babajin, “Yurra still ngaykunku binal kari?” ");
INSERT INTO gvn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jana townbu Bethsaida kadarin, bamangka kanbalda nyungundu dingkar miyil-burra wundin. Jana Jesusanda babajin, “Yundu nyungun karrbangarr, nyulu miyil-burra.” ");
INSERT INTO gvn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesusangka miyil-burra marabu karrban, wayankuda townmun. Nyulu miyil nyumbabu daman, marabu karrban, miyil-burranda babajin, “Yundu nyajilku junjuy?” ");
INSERT INTO gvn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Miyil-burrangka nyajin, yalaman, “Ngayu bama nyajil, yamba jana ngaykundu yala juku nyajiji jilba dungan-dunganya.” ");
INSERT INTO gvn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesusangka marabu miyil karrban baja. Dingkarangka mumbarabuku kunkun-bungan, nyungu miyil ngulkurrda, nyulu ngulkurrduku nyajin. ");
INSERT INTO gvn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesusangka dingkaranda yalaman, “Yundu junkayku dungay bayanbaku. Towndurr kari dungay.” Jesusangka nyungun yunganda. ");
INSERT INTO gvn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jana, Jesus, nyungu jawun-karra, jana townbu yindu-yinduymbu bubungu Caesarea Philippi dungan-dungarin. Jilbanga-jilbanga Jesusangka jawun-karranda babajin, “Bamangka wanjarrmal ngaykunku? Jana nganya wanju bambal?” ");
INSERT INTO gvn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jawun-karrangka nyungundu yalaman, “Kanbalda balkan yundu John the Baptist, kanbalda balkan yundu Elijah ngadimunku, kanbalda balkan yundu Prophet ngadimunku, balkan-balkawan Godunku.” ");
INSERT INTO gvn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesusangka jananda babajin, “Yala yurra? Yurra nganya wanju bambal?” Peterangka nyungundu yalaman, “Yundu bama Godundumun. Godungku yunun bamban Christkuda.” ");
INSERT INTO gvn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesusangka jawun-karranda yalaman, “Bamanda kari balka ngaykunku.” ");
INSERT INTO gvn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesusangka jananin binal-bungan nyungunkuku. Nyulu yalaman, “Ngayu bamanga wubulbuku yaba. Ngayu juma must warrngkaykuda. Jana, binga-binga, maja-maja Godundumunku bayanka, teacher-teacher ngadimunku, jana ngaykunku wawu kari, nganya wulay-manil. Yamba warngku kulurmal ngayu juranmal baja yarkinmun.” ");
INSERT INTO gvn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus kuku junkayku balkawan. Yinyaynka Peterangka nyungun murru-kangan. Nyulu yalaman, “Kari yalaku balkawaka.” ");
INSERT INTO gvn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus jurrkijin, jawun-karra nyajin, Peter murru-kangan, yalaman, “Dungayda! Yinya kuku yunuwunbu milkanga kadan Dubundumun Satanandamun. Yundu milkabu baykal-baykal yala bamangka, yala Godungku kari.” ");
INSERT INTO gvn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yinyamun Jesusangka jawun-karra, and bama wubulku kunjan. Nyulu jananda yalaman, “Kaki bamangka nganya wukurrinka, nyulu nyuluku kari nyajijika. Nyulu ngaykundu must dajijikarrkukuda. Nyulu kari jumbunmaka moneyka, and yamba-yambaka. Kaki bamangka nganya wukurril, bama kanbal nyungunku wawu-karimanji. Jana kuli dajinji, yarkinkaku kuninji, jukungu walngkan-damanji. Nyulu must bangkarr-dandimaka, nganya wukurrikarrku. ");
INSERT INTO gvn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kaki bama juranku bundanka and nyunguku way wukurrinka, nyulu juma wulaykuda. Kaki bamangka ngayku work balkanka and Godumu way wukurrinka, nyulu nguba wulay ngaykunku. Yamba nyulu juranku bundayarrkukuda, wuljaljiku heavenba. ");
INSERT INTO gvn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bamangka nyubunyinja nguba junjuy-junjuy wubulku manil, jumbunmanya. Junjuy-junjuynju yinyangka nyungu wawu kari juran-bungal wawu wulanyamun. Karibi! Bamangka dukulbu Godku mana, junjuy-junjuy kari. ");
INSERT INTO gvn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bamangka wanyu dajil, juranmanka baja? Yamba-karikuda. Godungkuku bama juran-bungal. ");
INSERT INTO gvn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bama wubulku buyunman, jana Godunku wawu kari. Ngayu bamanga wubulbuku yaba, ngayu juma kaday baja jiri-warranji wangkar-wangkarmun. Ngayu junkurr-muruku kaday, dayirrku, yala ngayku nganjan. Kaki yundu ngaykunku, ngaykuwunku kukuku nyiku murru-kaday, ngayuda yalarrku murru-kadayda yununku, ngayu kaday baja.” ");
INSERT INTO gvn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesusangka jananda yalaman, “Ngayu manubajabuku balkal yurranda. Yurra wulanjiku, kanbalda nyajil God nyungu jawun-karra junkurr-murubuku ngulkurrduku kujinya.” ");
INSERT INTO gvn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","6-daysmanda, jana, Jesus, Peter, James, John, jana janarrku manjalba jarra-jarranga dakarin. Jawun-karrangka Jesus nyajil-nyajin, nyulu walu-yinduman. ");
INSERT INTO gvn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nyungu kambi bingajiman bajaku, dayirr-dayirrman. ");
INSERT INTO gvn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bula Elijah, Moses, bula ngadimunku. Bula nguwimal milbijin, Jesusanda balkan-balkawan. Jana Peterangka bulanin nyajin balkawanya Jesusanji. ");
INSERT INTO gvn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peterangka Jesusanda yalaman, “Maja, ngulkurr nganjin yunun nyajin. Nganjin bayan buban ngaranka. Nyubun yunu, nyubun Mosesamu, nyubun Elijahmu.” Jana yinyilmarinya, ");
INSERT INTO gvn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","nyulu nyunbarraman baja, binal kari wanyu balkanka. ");
INSERT INTO gvn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ngurrban wangkar-wangkarmun yubaku jananda kadan, wungar nandan. God ngurrbanmun kuku yirrkan, yalaman, “Yinya ngayku kangkal, Jesus. Ngayu nyungunku wawu jirray bajaku. Yurra nyungundu milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jawun-karrangka jinbaldaku walu-wukurrin, bulanin karida nyajin, nguwimal karida. Jana Jesusku nyajin. ");
INSERT INTO gvn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jana kankadan manjalmun, Jesusangka jananda yalaman, “Bama kari balka, yurra nyajin. Ngayu wubulbuku yaba. Ngayu yarkinmun wandilkuda. Wawu yinyamun yurra balkada.” ");
INSERT INTO gvn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jana nyungun kuku nyajin, bamanda kari balkan. Janarrku balkawan, wanyurrinku juranmal baja yarkinmun. ");
INSERT INTO gvn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jana Jesusanda babajin, “Jana teacher-teacherangka ngadimunku wanyurrinku balkal Elijahngarr kaday?” ");
INSERT INTO gvn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nyulu jananda yalaman, “Elijahngarr kaday, junjuy-junjuy ngulkurr-bunganka. Yamba ngayu wubulbuku yaba. Ngaykunku Godundumundu kabanda balkan ngayu juma bangkarr kakamal, juma ngaykunku kuli balkaji. ");
INSERT INTO gvn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngayu yurrangan balkal, Elijah kadaynda. Yamba jana nyungunku wawu kari, kuli balkajin, nyungun yarkinkaku kuninda yala kabanda Godundumundu balkaynda.” ");
INSERT INTO gvn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jana kunaman baja kanbalba jawun-karrandaku, jana nyajin bama wubulku yuba kadanya. Teacher-teacher ngadimunku jawun-karranji murru-kangal-kangawan. ");
INSERT INTO gvn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bamangka wubulduku Jesus nyajin, kungkurr-kadarinda, nyungundu warririnda. ");
INSERT INTO gvn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesusangka jawun-karranda babajin, “Yurra jananji wanyurrinku murru-kangan-kangaway?” ");
INSERT INTO gvn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bamangka nyubunyinja yalaman, “Maja, ngayu ngayku kangkal yunundu wundinka, dubu nyunguwunbu dukurrbu walanya. Dubungku nyungun kuku-kari-bungan, nyabil buyun-daman. ");
INSERT INTO gvn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Dubungku kangkal buyun-damal, bubungu yilbal. Nyumba wanarrida, dirra majan-majaji, bangkarr dandimal. Ngayu yunuwunbu jawun-karranda babajin dubu kanganka. Yamba jana binal kari dubu kanganka.” ");
INSERT INTO gvn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesusangka jananda yalaman, “Yurra nganya kari kuku nyajil-nyajil. Ngayu wuljayjiku bundandan yurranji. Yurra wanja-wanja nganya kuku nyajil? Warru wundi ngaykundu.” ");
INSERT INTO gvn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jana warru nyungundu wundin. Dubungku Jesus nyajin, warru burra-warri-manin. Warru bubungu daran, burrkinda, nyumba warrinda. ");
INSERT INTO gvn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesusangka nganjananda babajin, “Nyulu wanja-wanja buyunman?” Nganjanangka yalaman,“Karrkaynjaku manin. ");
INSERT INTO gvn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dubungku yalaku kunil-kunil, bayanga yilbal, bananga yilbal warrulu, nyungun yarkinkaku kuninka. Yundu binal dubu kanganka warrundumun dukurrmun? Jiba-badi ngalinyanka, ngalinyan nyaka.” ");
INSERT INTO gvn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesusangka nyungundu yalaman, “Yundu wanyurrinku babajin ngaykundu, ngayu binal yinyaynka? Yundu nganya kuku nyajinyaku. Kaki yundu nganya kuku nyajil, yundu junjuy-junjuy wubul balkalarrku.” ");
INSERT INTO gvn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Warrundumundu nganjanangka jinbalku yirrkan, yalaman, “Ngayu yunun kuku nyajilkuda. Yundu nganya helpim-bungada, ngayu yunun kuku nyajinka mumbarabuku.” ");
INSERT INTO gvn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesusangka bama wubulku nyajin yubaku wanarrinya. Nyulu dubu murru-kanganda, yalaman, “Wandida nyungundumun, kari wala baja.” ");
INSERT INTO gvn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dubu yirrkan, warru burra-warri-manin, wandinda. Warru wunanan yala yarkin. Bamangka wubulduku yalaman, “Nyulu wulanda.” ");
INSERT INTO gvn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yamba Jesusangka nyungu mara karrban, janay-manin baja marabu. ");
INSERT INTO gvn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesus, jawun-karra janarrku bayanba walan. Nyunguwundu jawun-karrangka nyungundu yalaman, “Yala nganjin wanyurrinku dubu kari kangan?” ");
INSERT INTO gvn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesusangka jananda yalaman, “Yurra dubu kanganka, yurra Godunjingarr must balkawaka. Wawu yinyamun dubu kangada. Nyulu wandilda.” ");
INSERT INTO gvn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jana yinyamun dungarin bububurr Galileemundurr. Jesus wawu kari bama binalmanka nyulu dunganka, because nyulu jawun-karra binal-bunganka. Nyulu yalaman, “Ngayu wubulbuku yaba. Jana nganya mambarril dingkar-dingkaranda, nganya yarkinkaku kuninka. Ngayu wulay, warngku kulurmal ngayu juranmal baja.” ");
INSERT INTO gvn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yamba jana binal kari yinyaynka kukuku, yinyilji, wawu kari babajinka. ");
INSERT INTO gvn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Jana, Jesus, jawun-karra, jana baraldarr dungan-dungarin, jawun-karra murru-kangawan, wanju majamanka. Jana townbu Capernaum kadarin, bayanba walarin, Jesusangka babajinda, “Yurra wanyurrinku balkan-balkawan baraldarr?” Yamba jana nyungun kari answerim-bungan, jankakuda bundandarinda. ");
INSERT INTO gvn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus bundan, jawun-karra 12-bala kunjan, jananda yalaman, “Kaki bama majamanka, nyulu nyuluku bubanmaka, kanbal-kanbal nyaka, helpim-bunga. Wawu yinyamun ngayu nyungun maja-bungalda.” ");
INSERT INTO gvn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nyulu karrkay manin, jakalba janay-manin, dakil yijarrin nyungundu, yalamanda, ");
INSERT INTO gvn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yurra ngaykunku wawu jirray. Kaki yurra karrkay nyajil, helpim-bungal, yurra yala nganya helpim-bungal. Kaki bama ngulkurr karrkayanka, nyulu yala ngaykunku ngulkurr. Kaki bama ngaykunku ngulkurr, nyulu Godunku ngulkurr, Godungku nganya yunganya.” ");
INSERT INTO gvn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johnungku Jesusanda yalaman, “Maja, nganjin dingkar nyajin dubu-dubu kangan-kanganya yunuwundu junkurrdu. Nganjin nyungundu balkan, ‘Yundu dubu kari kanga baja.’ Nganjin nyungundu yalaku balkan, nyulu ngananji kari.” ");
INSERT INTO gvn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesusangka yalaman, “Yundu kari kirinyaku. Kaki bamangka junjuy-junjuy miracle ngaykuwundu junkurrdu balkal, jana bama ngayku jawun. Jana ngaykunku kari jurrilmal, kari kuli balkaji ngaykunku. ");
INSERT INTO gvn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kaki bamangka ngananga kuli kari dajil, jana bama ngananga jawun. ");
INSERT INTO gvn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngayu yurranda manubajabuku balkal. Kaki bama yununku ngulkurrmal because yundu ngayku bama, ngayu nyungu yalbayku dajil baja. Kaki bamangka bana dajil because yundu ngayku bama, ngayu nyungu yalbayku dajil baja.” ");
INSERT INTO gvn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesusangka yalaman baja, “Yinyayangka karrkayangka nganya kuku nyajil. Kaki bamangka nyungun binal-bungal buyunmanka, jarra ngulkurr yinyaynka bamanka kulji yalbay manungu kajanka, jalunbu yilbanka. ");
INSERT INTO gvn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yundu nguba yunuwundu marabu buyun-damal. Yundu yalakubi mara nyandajika. Yundu nguba wawu kari mara nyandajinka, yamba yinya jarra ngulkurr yununku. Marabu buyunmanya yunun bayanga yunganji. Yinya baya kari kunbay baja. ");
INSERT INTO gvn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Yundu nguba yunuwundu jinabu dungay buyun-damanka. Yundu yalakubi jina nyandajika. Yundu nguba wawu kari jina nyandajinka yamba yinya jarra ngulkurr yununku. Jinabu buyunmanya yunun bayanga yunganji. ");
INSERT INTO gvn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nguba yundu buyun-damanka, yundu junjuy miyilda nyajinya. Yundu yalakubi miyil walngajika. Yundu nguba wawu kari miyil walngajinka, yamba yinya jarra ngulkurr yununku. Miyilda buyunmanya yunun bayanga yunganji. ");
INSERT INTO gvn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yinyaymba bayanga kandalda bangkarr nukan-nukal, kari wulay. Baya kari kunbay baja. ");
INSERT INTO gvn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kaki yundu nganya kuku nyajil, bamangka yunu kuli dajil. Yinyamundu kulibu yunun ngulkurr-bungal, yala saltdu mayi ngulkurr-bungal, yala bayabu mayi ngulkurr-bungal. ");
INSERT INTO gvn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Salt ngulkurr. Kaki salt bujarmal, yinya buyunda. Saltdu minya ngulkurr-bungal. Ngulkurrmaka bamanka, jawunmaka bamanji. Yinyamun yundu ngulkurrda yala salt.” ");
INSERT INTO gvn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus yinyamun dungan bubungu Judea, naka-nakamun ngundu-ngundu wawubajanga Jordan kadan. Bama wubulku kadarin baja nyungundu, nyulu jananin binal-bungal-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kanbal dingkar-dingkar Jesusanda kadarin. Jana warrumunku lawmunku binal, jana Pharisee-warra. Jana Jesusanda kadarin, lawmunku balkawanka, Jesus kukubu walu ngangkal-ngangkal-bunganka. Jana Jesusanda babajin, “Yalada lawmunku dingkarangka manyarr bawankarrkukuda?” ");
INSERT INTO gvn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesusangka babajin, “Mosesangka ngadiku wanyu balkan?” ");
INSERT INTO gvn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jana yalaman, “Mosesangka balkan, ‘Kaki dingkarangka manyarr bawanka, nyulu kabanba manyarranka balka, nyungundu daya, manyarr bawada. Wawu yinyamun bula kunbayarrkukuda.” ");
INSERT INTO gvn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesusangka yalaman, “Mosesangka yinya balkan because nyulu binal yurra dukul-dandi, yurrangaku way wukurrinka. ");
INSERT INTO gvn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yurra nguba kariku Godundumunbu kabanba yanyu kuku nyajin, ‘Jakalbaku Godungku bama balkan, nyulu dingkar, jalbu balkan.’ ");
INSERT INTO gvn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Godungku yalaman baja, ‘Yinyaynka nyulu dingkarangka nganjan, ngamu bawa, manyarranjiku bundayarrku. ");
INSERT INTO gvn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bula manyarrinyumal, yala nyubunkuda.’” Jesusangka yalaman baja, “Bula karida jambul, nyubunkuda, manyarrinyukuda. ");
INSERT INTO gvn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kaki Godungku dingkar, jalbu kuna-bungal, bula kari bawawaka baja. Bamangka bulanin kari ngami-ngami-bunga baja.” ");
INSERT INTO gvn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wawu yinyamun Jesus, jawun-karra bayanbaku walarin. Jawun-karrangka Jesusanda babajin, “Nganjinanda balka yinyaynka manyarrinyunku.” ");
INSERT INTO gvn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nyulu jananda yalaman, “Kaki dingkarangka manyarr bawal, kunbayarrku and yindu wunay, nyulu dingkar kalngar. ");
INSERT INTO gvn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kaki jalbungku dunyu bawal, kunbayarrku and yindu wunay, nyulu jalbu kalngar.” ");
INSERT INTO gvn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wawu yinyamun bamangka kaykay-kaykay wubul wundin Jesusanda, nyulu jananda mara yijarrinka. Yamba jawun-karrangka yinyarrin bama murru-kangan. ");
INSERT INTO gvn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesusangka nyajin, kuli-kadanda. Nyulu jananda yalaman, “Kaykay-kaykay ngaykundu yunga, jananin kari kiri. Kaki bamangka nganya kuku nyajil yala yinyarrinyangka kaykay-kaykayangka, Godungku janangan ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngayu yurranda manubajabuku balkal. Karrkayangka God mumbarabuku kuku nyajil, kari warmbil. Kaki bamangka God kuku nyajil yala karrkayangka nyajil, and kari warmbil, Godungku nyungun ngulkurrduku kujil.” ");
INSERT INTO gvn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesusangka kaykay-kaykay jarra-kulban, jananda mara yijarrin, Godunji balkawan jananka. ");
INSERT INTO gvn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus dungan-dungan, dingkar yindu nyungundu warrin. Nyulu dingkar bungkubu janan, yalaman, “Maja, yundu ngulkurr. Ngayu wanjarrmal, junkayku bundanka, wuljaljiku juranku bundanka jiringa?” ");
INSERT INTO gvn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesusangka nyungundu yalaman, “Yundu nganya wanyurrinku bamban ngulkurr? Nyubunku Godku ngulkurr. Kanbal-kanbal ngulkurr kari. ");
INSERT INTO gvn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yundu binal kukuku Godungku balkan. ‘Kari yarkinkaku kuni, kari kalngarmaka, kari wurrmaymaka, kari jurril-bunga, kuku nyakaku ngamu, nganjan, bulanin ngulkurrduku kuji.’” ");
INSERT INTO gvn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nyulu dingkarangka Jesusanda yalaman, “Maja, ngayu warrumunku binal, ngayu yinya kuku nyajinyarrku warrumunku.” ");
INSERT INTO gvn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesusangka nyungun nyajin, nyungunku wawu jirrayman. Jesusangka nyungundu yalaman, “Ngayu kuku nyubunku yunundu balkal baja. Dungay, yamba-yamba wubulku sellim-bunga, money mana, bamanda money-karinda daya. Kadayda, ngaykunji dungayda. Ngayu junjuy-junjuy jirrayku dajilda yunundu wangkar-wangkar jiringa, heavenba.” ");
INSERT INTO gvn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nyulu dingkarangka yinya kuku nyajin, nyulu milka-bujarman, yamba-yambaka. Nyulu milka-bujarku dungan, nyulu wawu kari dajinka because nyungu yamba-yamba jirray. ");
INSERT INTO gvn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesusangka walu-wukurrin, jawun-karranda yalaman, “Godungku nyungu bama ngulkurrduku kujil. Money-jirrayangka hard-bala God maja-bunganka. Nyulu milkanga moneyjiku bundanday.” ");
INSERT INTO gvn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jawun-karra kungkurr-kadarin yinyaynka kukuku. Jesusangka jananda yalaman baja, “Hard-bala money-jirrayangka God maja-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hard-bala bajaku bulkinka needledarr kankaburr dungay. Kaki bama money jirray, hard-bala bajaku God maja-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jawun-karra kungkurr-kadarin, nyungundu babajin, “Yala wanju bama Godungku juran-bungalkuda?” ");
INSERT INTO gvn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesusangka janangan nyajin, yalaman, “Bama kari janaku juranmal. Godungkuku. Godungkuku junjuy-junjuy baja balkal, junjuy-junjuynku binal.” ");
INSERT INTO gvn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peterangka yalaman nyungundu, “Ya, nganjin yamba-yamba wubulku bawan, yununji dungarin.” ");
INSERT INTO gvn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesusangka yalaman, “Ngayu yurranda junkaynjaku balkal. Ngayu yurrangan yungan, binal-bunganka Godundumunku kukuku. Bamangka junjuy-junjuy bawalarrku ngaykunku, nyungu bayan, yaba-yabaju, babarr-jinkurr, ngamu, nganjan, kangkal-kangkal, bubu bawalarrku ngaykunku. Kaki nyulu janangan bawalarrku ngaykunku, nyulu yindu-yindu manil baja, bayan wubul, yaba-yabaju wubul, babarr-jinkurr wubul, ngamu-karra wubul, kangkal-kangkal wubul, bubu yalbayku. Ngayu janangan, and yamba-yamba dajilarrku nyungu. Bama yindu-yindu kuli balkaji nyungunku, yamba yinya bama juranku jiringa wangkar-wangkar wuljaljiku bunday, kari wulay baja. ");
INSERT INTO gvn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bama kanbal janaku majamanka, yamba Godungku janangan buban-bungal. Bama kanbal janaku bubanmal, Godungku janangan maja-bungal.” ");
INSERT INTO gvn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jana Jesus baraldarr jinabu wangkar dungan-dungarin townbu Jerusalem, Jesus jakalba dungan-dungan. Jawun-karra yinyilman, bama kudamundu yalarrku yinyilji. Jesusangka jawun-karra muru-bungan, jananda balkanda juma wanjarrmal. ");
INSERT INTO gvn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nyulu yalaman, “Ngana wangkar townbu Jerusalem dungan-dungari yinyaymba bundandari maja-maja Godundumunku bayanka, teacher-teacher lawmunku. Ngayu wubulbuku yaba. Dingkarangka nganya mambarril jananda. Jana ngaykundu yalamal, ‘Yundu wulayda.’ Jana nganya mambarrilda ngarrbal-ngarrbalanda, yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jana nganya yajarril, nyumba yilbal ngaykundu, nganya wuybubu kulbal, kunilarrkukuda, yarkin-bungalarrkukuda. Warngku kulurmal ngayu juranmal baja.” ");
INSERT INTO gvn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bula James, John, bula Zebedeemu kangkal-bulal, bula Jesusanda yuba kadan, yalaman, “Maja, ngalin babajinka junjuynku yunundu. Ngalin yunundu babaji, yundu balka.” ");
INSERT INTO gvn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nyulu bulanda babajin, “Ngayu wanjarrmal yubalanka?” ");
INSERT INTO gvn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bula nyungundu yalaman, “Yalada ngalin yununji bundanka? Yundu majamal, ngalin yununji bundanka, yinyamundu majamanka yununji.” ");
INSERT INTO gvn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesusangka bulanda yalaman, “Jana bamangka nganya juma warrngkay-manil, kuli dajil ngayku. Yamba ngayu kari janangan kiril. Yalada yubalin bamangka balkal-balkal yala nganya?” ");
INSERT INTO gvn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bula nyungundu yalaman, “Baluda balka.” Jesusangka bulanda yalaman, “Bamangka yubalin warrngkay-manilkuda, kuli dajilkuda, bambay-bungalkuda yala nganya. Jana kuli yubalanga dajilkuda yala ngayku. ");
INSERT INTO gvn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yamba Godku binal wanju ngaykunji bunday. Nguba yubal ngaykunji bunday, majamanka, nguba bama yindu. Godku baja.” ");
INSERT INTO gvn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kanbal-kanbalda jawun-karrangka kuku bulanka nyajin, jana bulanka kulimaynda. ");
INSERT INTO gvn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesusangka janangan wubulku kunjan, jananda yalaman, “Yurra binal maja-majanka ngarrbal-ngarrbalanka. Jana bamanda balkal anything doim-bunganka. Bamangka janangan kuku nyaka, jana majabi. ");
INSERT INTO gvn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Yamba yurra yala kari balkanyaku. Kaki yurra majamanka, yurra bubanmakada, bama yindu-yindu nyakada, helpim-bungada. Wawu yinyamun Godungku yurrangan maja-bungal. ");
INSERT INTO gvn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngayu wubulbuku yaba. Ngayu kadan, ngayu wawu kari bamangka nganya nyajinka, helpim-bunganka. Ngayu kadan bama helpim-bunganka. Ngayu kadan, wulanka bamanka wubulkuku, janangan wangkar-wangkar jiringa wundinka. Jana wuljaljiku yinyaymba bundarida.” ");
INSERT INTO gvn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jana townbu Jericho kadarin. Jana, Jesus, jawun-karra, bama wubul, jana Jerichomun kankadarin, bama yindu burri Bartimaeus, nyulu karangkalba baralba bundandan. Nyulu miyil-burra, kangkal Timaeusamu. Bartimaeus moneyka jurungu-jurungu ngukal banbadin, mayika. ");
INSERT INTO gvn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nyulu binalman nyulu yinya Jesus townmun Nazarethmun. Bartimaeus yirrkaynda, yalaman, “Jesus, yundu Davidandamun. Manun-manunmakada, jiba-badida ngaykunku.” ");
INSERT INTO gvn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yamba bamangka wubulduku nyungun murru-kangan, yalaman, “Jankamaka.” Yamba nyulu yirrkan baja, “Jesus, yundu Davidandamun. Ngaykunku manun-manunmaka, jiba-badi.” ");
INSERT INTO gvn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesusangka jananda yalaman, “Nyungunin kunja.” Jana miyil-burra kunjan, yalaman, “Kari yinyilmaka, dakada, nyulu yunun kunjal-kunjal.” ");
INSERT INTO gvn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nyulu blanket yilban, dakan, kadaynda Jesusanda. ");
INSERT INTO gvn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesusangka nyungundu babajin, “Ngayu yununku wanjarrmanka?” Nyulu miyil-burrangka nyungundu yalaman, “Maja, ngayku miyil ngulkurr-bunga.” ");
INSERT INTO gvn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusangka nyungundu yalaman, “Dungayda, yunu miyil ngulkurrmalda, yundu nganya kuku nyajinya. Yundu yalada.” Jesusangka jinbaldaku miyil ngulkurr-bungan. Bartimaeus Jesusanji dunganda baraldarr. ");
INSERT INTO gvn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jana Jesus townbu Bethphagemunbu, townbu Bethanymunbu kadarin, yubaku townbu Jerusalemmunbuku, jana wuburrbu kadarin. Wuburr burri Olive. ");
INSERT INTO gvn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesusangka jawun-bulalanda jambulimba yalaman, “Yubal yinyaymba townbu dungay, yubal donkey karrkay nyajilda. Bama kariku dakan yinyayanda donkeynda. Karra walnga, wundida. ");
INSERT INTO gvn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nguba bamangka yubalanda babaji, ‘Yubal wanjarrmalmal?’ Kaki nyulu babaji, yubal yalamaka, ‘Majangka donkey kunjan, nyulu wawu. Nyulu kunbay, yungal baja.’” ");
INSERT INTO gvn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bula dungan, karrkay donkey warrmba-bungan, bayanba janjananya, kajanya. Bula karrada walngan. ");
INSERT INTO gvn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kanbal bama yinyaymba janjanan, jana bulanda babajin, “Yubal wanyurrinku karra walngal-walngal?” ");
INSERT INTO gvn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bula bamanda balkan Jesusangkaku balkan. Jana donkey yunganda. ");
INSERT INTO gvn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bula donkey karrkay Jesusanda wundin, kambi ngaran donkeynda. Jesus donkeynda dakaynda. ");
INSERT INTO gvn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bamangka kanbalda kambi ngaran baraldarr, kanbalda dakil birrajiku dumbarrin jukumun, ngaran baraldarr, Jesus wuyaraku donkeynji dunganka. ");
INSERT INTO gvn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kanbal jakalba Jesusanka dungarin, kanbal kudamundu. Jana kawalda daman, Jesus buyay-manin. Jana yalaman, “Yuy, yuy! God buyay-mana! Godungku nyungun yungan, nyungun maja-bungalda. ");
INSERT INTO gvn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yanyu bama ngananga kingkuda. Nyulu kingmal yala David ngadimunku. Godungku ngananin ngulkurrduku kujilkuda. God buyay-mana.” ");
INSERT INTO gvn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nyulu Jesus townbu Jerusalem dungan, Godundumunbu bayanba walan. Nyulu kananga bayanba junjuy-junjuy walu-wukurrin, jawun-karranji townbu Bethany dunganda, wungar kuwakuda. ");
INSERT INTO gvn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Warngku yindu, jana Jesus townmun Bethanymun kankadarin baja. Jesus dakwuynji. ");
INSERT INTO gvn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nyulu juku kala-kalbaymun nyajin. Juku mujarr, birra wubul. Nyulu jukungu dungan, mayi nyajinka. Yamba jukungu manu birraku, mayi yamba-kari, kambarajinga. ");
INSERT INTO gvn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesusangka jukungu yalaman, “Bamangka karida mayi nukal baja yunundumun.” Jawun-karrangka nyajin. ");
INSERT INTO gvn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jana townbu Jerusalem kadarin, Godundumunbu bayanba walarin. Kanbal dingkar-dingkar yinyaymba bayanba bundandarin. Kanbalda yinyarrinyangka junjuy-junjuy sellim-bungal-bungan, kanbalda buy-im-bungal-bungan. Kanbalda money jurrkil-jurrkin. Jesusangka yinyarrin bama wubulku Godundumun bayanmun kangan, jananga table jurrngan. Kanbalda dingkarangka minya wabul sellim-bungan. Jesusangka jananga chair jurrngan. ");
INSERT INTO gvn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kanbalda dingkarangka yamba-yamba junjuy-junjuy wundin kanaburr Godundumundurr bayandarr. Jesusangka jananin kirin, yalaman, “Yamba-yamba yarra kari wundi baja. Yarra ngalkaldarrku dungarika.” ");
INSERT INTO gvn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesusangka bama binal-bungan, jananda yalaman, “Godumu kuku yalaku: ‘Bama wubulku bubumun yindu-yindumun ngaykuwunbu bayanba kadari, balkawanka ngaykunji.’ Yamba yurra jananin kari kirin walarinka, wurrmaymanka, Godumu bayan buyun-damanka.” ");
INSERT INTO gvn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jana, maja-majangka Godundumunku bayanka, teacher-teacher ngadimunku, jana kuku nyajin Jesusangkaku balkanya. Jana nyungunku balkawanda, nyungun yarkinkaku kuninka. Yamba jana yinyilmayn, nyungun karrbanka, bama wubulku nyungunku wawumanya. Bama wubulku nyunguwunku kukuku kungkurr-kadarin, wawuman. ");
INSERT INTO gvn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wungar walaynda, jana Jesus townmun dungarinda. ");
INSERT INTO gvn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Warngku yindu, yalibalaku jana, Jesus, jawun-karra, jana baraldarr dungan-dungarin, jana yinya juku mujarr nyajin. Juku wulaynda ngara-muruku. ");
INSERT INTO gvn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter binalku jukuku. Nyulu Jesusanda yalaman, “Maja, nyaka! Yalunyu juku wulaynda, yundu yilayku buyun-daman.” ");
INSERT INTO gvn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesusangka jananda yalaman, “God kuku nyaka. ");
INSERT INTO gvn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngayu yurranda manubajabuku balkal. Nguba bama balkaway Godunji manjalka. Nyulu nguba Godundu yalamal, ‘Manjal mana, jalunbu yilba.’ Kaki nyulu God kuku nyajil and kari warmbil and binal Godungku nyungun nyajil, Godungku manjal manilda, jalunbu yilbalda. ");
INSERT INTO gvn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","God kuku nyaka. Kaki yurra Godundu babajinka, yurra must binalmaka nyulu dajilkuda. Kaki yurra yalaku binalmal, nyulu dajilkuda. ");
INSERT INTO gvn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kaki yurra Godunji balkawanka, yurra nguba milkabu kujil-kujil buyun kanbalda yurranin balkan. Kaki yurra yinyayanka buyunku milka-wulay, yurranga nganjan wangkar-wangkar yurrawunku buyun-buyunku milka-wulayda. ");
INSERT INTO gvn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kaki yurra kari milka-wulay buyunku kanbalangka yurranin balkan, yurranga nganjan wangkar-wangkar kari milka-wulay buyunku yurra balkan.” ");
INSERT INTO gvn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jana Jesus townbuku Jerusalemmunbuku kadarin baja. Nyulu Jesus dungan-dungan Godundumundurr bayandarr, jana, maja-maja Godundumunku bayanka, teacher-teacher ngadimunku, and binga-binga, jana Jesusanda kadarin. ");
INSERT INTO gvn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jana nyungundu babajin, “Yundu wanjundumundu junkurrdu junjuy-junjuy balkal? Wanjungku yunu junkurr dajin?” ");
INSERT INTO gvn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesusangka jananda yalaman, “Ngayu yurranda question babajinka. Kaki yurra ngaykundu balkal, ngayu yurranda balkal wanjungku nganya yungan. ");
INSERT INTO gvn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yurra balka, wanjungku John yungan, banabu dukul-damanka? Nguba Godungku, nguba bamangka. Balkada.” ");
INSERT INTO gvn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jana jana-karrajiku murru-kangawan, yalaman, “Ngana wanjarrmal Jesusanda? Ngana kari yalamaka, ‘Godungku yungan.’ Jesusangka nganandada yalamal, ‘Yala yurra wanyurrinku John kari kuku nyajin?’ ");
INSERT INTO gvn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngana kari yalamaka, ‘Bamangka John yungan.’ Bama wubulku ngananka kuli-kadarikuda.” Jana bamanka wubulkuku yinyilji, bamangka wubulduku believeim-bunganya Godungkuku John yungan. ");
INSERT INTO gvn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jana Jesusanda yalaman, “Nganjin binal kari. Wanjungku baja John yungan?” Jesusangka jananda yalamanda, “Yalada, ngayu yurranda yalarrku kari balkalda wanjungku nganya yungan.” ");
INSERT INTO gvn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesusangka kuku balkan, storybu binal-bungan. Nyulu yalaman, “Nyubunyimba dingkaramu bubu jirray. Nyulu fence wukurrin, diburr grape nandan. Nyulu janku bakan, mayika grapemunku. Mayi grape juma kulbulmal, nyulu mayi grape jankungu nyangarrinka, dumbarrinka, yira yunganka. Nyulu bayan jarra-jarra ngaran dindarra gardenba. Bama wuyara bundanka, miyilji bundanka, bamangka mayi ngakinji. Wawu yinyamun dingkarangka kanbalba bamanda yalaman, ‘Yurra ngayku garden ngulkurrduku kuji. Mayi grape kulbulmal, yurra kanbal kuji yurrangaku. Kanbal ngayku kuji.’ Yinyamun nyulu dungan bubungu yinduymbu. ");
INSERT INTO gvn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mayi kulbulmanda, majangka workingman bamanda yungan, nyunguwunbuku gardenbaku, mayi maninka. ");
INSERT INTO gvn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yamba jana bamangka nyungun karrban, wuybubu kulban, yungan baja mayi-kariku. ");
INSERT INTO gvn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Majangka yindu workingman yungan jananda. Yamba jana nyungu dukul kunin, nyungun buyun-damankuda. ");
INSERT INTO gvn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Majangka jananda bama yindu yungan, yamba jana nyungun yarkinkaku kunin. Majangka jananda bama wubul yungan, yamba jana kanbal yarkinkaku kunin, kanbal wuybubu kulban. ");
INSERT INTO gvn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nyubun dingkar majanjiku. Yinya dingkar majamu kangkal. Nyulu nyungunku wawu jirray bajaku. Majangka kangkal yunganda jananda. Nyulu yalaman, ‘Jana ngaykuwunbu kangkalanda milka-janay.’ ");
INSERT INTO gvn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nyungu kangkal bamanda dungan gardenba. Yamba jana nyungun nyajin, jana yalaman, ‘Yinya nyungu kangkal. Kadarika, ngana nyungun yarkinkaku kuninka, yanyu bubu, mayi nganangada.’ ");
INSERT INTO gvn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jana nyungun karrban, yarkinkaku kunin, yarkin yilbanda duduymbu. ");
INSERT INTO gvn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nyulu maja wanjarrmalda? Nyulu jananda kaday, jananin yarkinkaku kunilda. Nyulu bama yindu manil, workmanijinka nyungunku. ");
INSERT INTO gvn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Yurra Godumu kuku kabanba nyajinkuda. Godungku yalaman, ‘Bamangka bayan ngaranka, jana juku post nyajil, nguba yilbal, jana wawu kari yaluynku jukuku. Yamba Godungku bayan ngaranka. Juku yinyadabi dandi bajaku bayanka ngaranka, nyulu manilda. Ngana nyajin, wawurr-wawurrmanijin, yinya ngulkurr bajaku.’” ");
INSERT INTO gvn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jana, maja-majangka Godundumunku bayanka, teacher-teacherangka ngadimunduku, binga-bingangka, jana Jesus nyajin kuku balkan-balkanya. Jesusangka yinyamundu storybu balkan jananka, jana buyun. Jana Jesus karrbanka, yamba jana yinyilmarin bamanka wubulkuku. Jana dungarinda, Jesus bawan. ");
INSERT INTO gvn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jana kanbal Jesusanda yungan, kanbal bama Pharisee-warra, kanbal Herodamu jawun-karra. Jana Jesus kukubu walu-ngangkal-ngangkal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jana Jesusanda kadarin, nyungundu yalaman, “Teacher, nganjin binal yundu kuku manubajaku balkal, bama kukuku manubajaka binal-bungal. Yundu kari yinyilmal bamanka, kari bulmbuymal. Yundu kuku balkal bamanda maja-majanda yala kanbalanda. Yundu bamanda wubulbuku yala-karrajiku balkal. Yundu manubajabuku balkal Godunku, nyunguwunku waymunku. Yundu nganjinanda balka, wanjarrmanka. Caesar, nyulu maja yalbay bajaku, king bajaku. Nyulu bama yungal ngananda, tax money maninka. Nganjin babajinka, ngananka yalada money tax dajinka? Nganandamundu lawmundu kiril or kari?” ");
INSERT INTO gvn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yamba Jesus binal jana nyungun kukubu ngangkal-ngangkal-bunganka, nyungun kukubu karrbanka. Nyulu jananda yalaman, “Yurra wanyurrinku nganya kukubu ngangkal-ngangkal-bunganka? Ngaykundu money wundi, ngayu nyajinka.” ");
INSERT INTO gvn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jana money wundin nyungundu. Nyulu jananda yalaman, “Yalunyu wanyamba ngurma, and burri moneynga?” Jana nyungundu yalaman, “Kingamu.” ");
INSERT INTO gvn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesusangka jananda yalaman, “Yurra money kingamu daya baja nyungunduku. Godumu daya baja nyungunduku, money, and work. Godundu yurraku yalarrku dajijika.” Jana kungkurr-kadarin yinyaynka kukuku. ");
INSERT INTO gvn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kanbalda bamangka kari believeim-bungal bama yarkinmun juranmal baja, jana yinyarrin Sadducee-warra. Jana yalamal, “Bama wulay, kari juranmal baja.” Kanbal Sadducee-warra Jesusanda kadarin, nyungundu yalaman, ");
INSERT INTO gvn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Teacher, Mosesangka ngadiku law kabanba balkan yalaku: ‘Kaki dingkar kangkal-kariku wulay, nyunguwundu yabajungku yinya jalbu bunjil wunay. Bulanga kangkal-kangkal yala yabanga.’ ");
INSERT INTO gvn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yala, yundu yanyu story nyaka. Yaba-yabaju wubul, 7-bala. Yabangka manyarr wunan, kangkal-kariku wulan. ");
INSERT INTO gvn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yabajungku kudamundumundu bunjil manyarr wunan. Nyulu wulan, kangkal yamba-kariku. Dindarrmundu bunjil manyarr wunanda. Dindarrmundu bunjil wunan, wulan, kangkal yamba-kariku. ");
INSERT INTO gvn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kanbal-kanbalda yalaku bunjil wunan yabandamun, kangkal-kangkal yamba-kariku. Yinyamun jalbuda wulan. ");
INSERT INTO gvn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kaki bama juma wubulku juranmal baja, manyarr wanyambaku? Jananga yaba-yabajumu wubulbuku manyarr.” ");
INSERT INTO gvn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesusangka jananda yalaman, “Yurra wadu-waduman. Yurra binal kari Godundumunku kukuku, nyunguwunku junkurrku. ");
INSERT INTO gvn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bama juranmal baja yarkinmun, jana kari marrymal baja. Jana yala jiri-warra, kari marrymal baja. ");
INSERT INTO gvn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yamba yurra balkal-balkawan yarkinanka, jana yarkin juranmal baja. Yurra Godundumunbu kabanba nyajin duduy wayjujinya. God duduymbu, nyulu balkawan Mosesanji. Nyulu yalaman, ‘Ngayu Abrahamamu God, ngayu Isaacamu God, ngayu Jacobamu God.’ Jana ngadiku wularin, yamba God janangakuda God, jana juranku bundandarida nyungunji. ");
INSERT INTO gvn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God bamanga yarkin-warranga kari. Nyulu God juran-warranga, jana nyungunji bundandarida. Yurra wadu-waduman.” ");
INSERT INTO gvn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nyubun teacher ngadimunku kadan, janangan nyajin balkan-balkawanya. Nyulu Jesus nyajin mumbarku balkawanya. Nyulu Jesusanda babajin, “Wanjinyaku kuku yalbay bajaku Godungkuku balkan?” ");
INSERT INTO gvn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusangka yalaman, “Yanyu kuku yalbay bajaku. ‘Yurra bamangka Jew-warrangka nyaka. God, nyulu yurranga maja. Nyulu nyubunku. ");
INSERT INTO gvn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yurra Godunku wawu-jirraymaka, milkanga nyungunjiku bundarika. Nyungun wawungu, and dukurrbu kuji, junkaynjaku junkurr-murubuku wukurrika.’ ");
INSERT INTO gvn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yanyu kuku jarra buban. ‘Yurra bamanka yindu-yinduynku wawu-jirraymaka. Jananka wawu-jirraymaka yala yurrankaku, and yala yurra yurrawunkuku jawun-karranka wawu.’ Yinya bulal kuku yalbay kanbalka.” ");
INSERT INTO gvn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nyulu teacherangka nyungundu yalaman, “Yundu junkayku. Yundu manubajabuku yalaman, ‘God nyubunku, kanbal yamba-kari, nyuluku nyubunku.’ ");
INSERT INTO gvn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ngana nyungunku wawu-jirraymaka, milkanga nyungunjiku bundarika. Ngana nyungun wawungu, and dukurrbu kuji, junkaynjaku junkurr-murubuku wukurrika. Ngana kanbalanka wawumaka yala nganankaku. Ngana yinya kuku jambul must wukurrika. Kaki ngana minya Godundu wundil, yamba yinya kuku jambul kari wukurril, yinya buyun.” ");
INSERT INTO gvn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus binal dingkarangka balkan ngulkurrduku. Jesusangka nyungundu yalaman, “Yundu nguba readyda, yunduku Godundu dajijinka, nyungun maja-bunganka.” Yinyamun jana wubulku murru-kadarin, Jesusanda babajinka baja. ");
INSERT INTO gvn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesusangka Godundumunbu bayanba binal-bungal-bungan, nyulu yalaman, “Teacher-teacher ngadimunku balkal Christanka. Jana yalamal, ‘Christ, nyulu Davidandamun.’ ");
INSERT INTO gvn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Godundumundu Wawubu Davidanda balkan yanyu kuku kabanba balkanka, ‘Majangka Godungku ngaykuwunbu majanda yalaman, “Ngaykunji bunday. Ngali muruku majamal. Jana bama yununku wawu kari, ngayu yinyarrinyanji kuniwanka, yundu jananka majamalkuda.” ’ ");
INSERT INTO gvn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidangka Christ bamban maja. Yala teacher-teacherangka ngadimunku wanyurrinku balkan, ‘Christ Davidandamun’?” ");
INSERT INTO gvn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jana bama wubulku wawurr-wawurrku milka-janan Jesusanda. Jesusangka binal-bungal-bungan, nyulu yalaman, “Yurra mumbarmaka teacher-teacheranka ngadimunkuku. Jana bulmbuyku dungari, yala majaku dungari. Jana wawu kambi kalbaliku didanka, wawu bama ngulkurrku balkawanka jananji townbu. ");
INSERT INTO gvn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jana jakalba bundarinka churchmunbu, kanbalda janangan nyajinka. Jana partynga dungari, jana ngulkurrbuku chairnga bundarinka, bamangka nyajinka jana maja yalbay. ");
INSERT INTO gvn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yinyarrinyangka bamangka bunjil-bunjil kari helpim-bungal, kari ngulkurrduku kujil. Jana yamba-yamba manil bunjilandamun. Jana ngadingka miyil nandan-nandaji, jurrilmalmal, praymalmal, bulmbuymalmal. Wawu wulanyamun jana kari dungari Godundumunbu bubungu. Jana dungari bayanga yalbaymba, buyun-damanya.” ");
INSERT INTO gvn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus bundandan yulalba money bamangka yijarril-yijarril Godumu. Nyulu nyajil-nyajin bama money yijarril-yijarrinya. Kanbalamu bamanga money jirray. Jana money jirray yijarrin yulalba. ");
INSERT INTO gvn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nyubun bunjil kadan, nyulu money kari bajaku. Nyulu 2 cents yijarrin. ");
INSERT INTO gvn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesusangka jawun-karra kunjan, yalaman, “Ngayu yurranda manubajabuku balkal. Yinyayangka bunjilangka yalbay bajaku yijarrin. Jana kanbalda buban yijarrin. ");
INSERT INTO gvn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Jana money jirray bajaku wunay, yamba jana buban Godundu dajin baja. Nyulu bunjil money kari, nyulu 2 centsmunjiku, yamba nyulu wubulku dajin. Nyulu money-karida, mayi maninka. Yinyaynka nyulu jirray dajinyarrkukuda.” ");
INSERT INTO gvn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jana Jesus Godundumun bayanmun dungan-dungarin, nyubunyinja jawunyungku Jesusanda yalaman, “Maja, nyaka. Jana bayan ngaran kuljibu ngulkurrduku. Bayan ngulkurrijin bajaku, ngaran kuljibu yalbaynja bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesusangka nyungundu yalaman, “Yurra yanyu bayan yalbay nyajil-nyajilda. Yamba bama juma kadari, bayan wubulku yalunyu dumbarrilarrkukuda. Kulji kari bawaji baja, yilbajiyarrkukuda.” ");
INSERT INTO gvn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jana Jesus wuburrbuda dungarin, Olivemunbu. Jana, Peter, James, John, Andrew, Jesus, jana yubaku wuburrbu bundandarin, junkayku bayanka Godundumunku. ");
INSERT INTO gvn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Jana Jesusanda babajin, “Yundu nganjinanda balka, bamangka wanja-wanja bayan dumbarril? Godungku juma wanjarrmal, nganjin binalmanka, timeda dingkar-dingkarda kadari bayanda dumbarrinka?” ");
INSERT INTO gvn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesusangka jananda yalaman, “Yurra mumbarmaka. Bama kadari, yurrangan manubu-wundinka. Janangan kari kuku nyaka. ");
INSERT INTO gvn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bama wubul nyubun-nyubunku kadari. Jana jurrilmalmal, yalamal, ‘Ngayu Christkuda. Ngayuku Godundumun.’ Jana bama wubul bajaku manubu-wundil. ");
INSERT INTO gvn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yala-yala yurra kuku nyajil mabarrka. Kanbal mabarr yubaku, kanbal kala-kalbay. Kaki yurra kuku nyajil mabarrka, kari yinyilmaka. Bama mabarrba kuniwaykuda, yamba God kariku kaday, bubu kunbay-maninka. ");
INSERT INTO gvn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yuwu, bama mabarrba kuniwaykuda. Bama nyubunmun bubumun kuniway bamanji bubuku yinduynku. Bubu yiringkurrku bulngaji baja, bulngaji baja. Bubungu yindu-yinduymbu mayi-karimalda. Bama mayi-kariku bundarida. Yinya kuli jirray, trouble jirray. Wawu yinyamun kuli jirraymal baja, trouble jirraymal baja. Yinya yala jalbu kulngkul. Nyulu yirrngaji bubanngarr. Nyulu juma yirrnga-yirrngajikuda. Trouble juma jirraymalkuda. ");
INSERT INTO gvn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Yurra mumbarmaka. Bamangka yurrangan mambarril, courtcasemunbu wundinka. Jana yurrangan wundil Jew-warrandamunbu churchmunbu, wuybubu kulbanka. Jana yurrangan mambarril maja-majanda, yurra nganya kuku nyajinya. Yurra jananda balka ngaykunku. ");
INSERT INTO gvn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bubu kunbanjiku, bamangka kuku ngulkurr ngaykunku balka bamanda yiringkurrku bubungu yindu-yinduymbu. ");
INSERT INTO gvn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kaki jana yurrangan courtcasemunbu wundil, kari milka-bujarmaka, yurra wanyu balkanka jananda. Godundumundu Wawubu yurranda balkal, yurra wanyu balkanka jananda. Yurra balka yalaku Godundumundu Wawubu yurrangan balkal. Yinyamundu kukubu yurraku kari balkal. Kari. Godundumundu Wawubuku balkal, yurra kuku balkanya nyulu dajin. ");
INSERT INTO gvn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bamangka wubulduku kuli dajil yindu-yinduymbu. Yabangka yabaju maja-majanda mambarril, yarkinkaku kuninka. Yabajungku yaba mambarril, kuninka. Nganjanangka kangkal mambarril, kangkal-kangkalda ngamu, nganjan mambarril. ");
INSERT INTO gvn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bama wubulku yurranka wawu kari, yurra nganya kuku nyajinya. Jana yurranka kuli balkajikuda. Kaki yurra nganya kuku nyajil, and kari bawal, ngayu yurrangan juran-bungalda yarkinmun, yurra ngaykunji wuljaljiku bundarinka.” ");
INSERT INTO gvn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jesusangka yalaman baja, “Yurra juma bama buyun bajaku nyajilda, Godundumunbu bayanba janjananya. Nyulu kuli-baka bajaku, Godunku wawu kari bajaku. Nyulu bamanga wubulbuku kuli dajil, kanbal yarkinkaku kunil. Yurra yanyu kuku nyajin, binalmakada. Kaki bamangka nyungun kuli-baka nyajil, jana bama bubumun Judeamun warririka wuburrbu. ");
INSERT INTO gvn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bama nguba ngalkalba bayanba bubungu bundanday. Nyulu kari bayanba wala baja, yamba-yamba kari mana baja. Nyulu yamba-yamba bawa, kulimun wuburrbu jinbalku warri. ");
INSERT INTO gvn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bama nguba jilba dungan-dungay. Nyulu kari bayanbaku dungay baja, kambika. Nyulu kambi bawa, kulimun jinbalku warri, wuburrbu. ");
INSERT INTO gvn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yinya time buyun bajaku jalbu-jalbunku kulngkulunku, jalbu-jalbu ngawanji. Buyunji jana! ");
INSERT INTO gvn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Godundu babajika, ‘Nganjin wawu kari yinyamun kulimun kambaranga warririnka, murruji warririnka kambaranga.’ ");
INSERT INTO gvn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yala-yalala trouble jirray bajaku. Ngadi bajaku Godungku bubu balkan. Yinyamun nyikumankarrku bama yalaku kariku warrngkan. Wawu yinyamun kulimun bama yalaku kari warrngkal baja. ");
INSERT INTO gvn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yamba Godungku yinya kuli kari kujil ngadingka. Nyulu yalamanyakuna ngadikuna, bama wubulku wularinyaku. Nyulu yinya kuli kari kujilda, nyunguwunku bamanka nyulu wangkanin. ");
INSERT INTO gvn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Bamangka nguba yurranda yalamal, ‘Nyaka, nyulu yinya Christ.’ Bamangka yinduynju nguba yalamal, ‘Nyaka, nyulu yanyu Christ.’ Yamba jana jurrilmalmal. Yurra kari kuku nyaka. ");
INSERT INTO gvn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bamangka kanbalda yalamal, ‘Ngayu Christ.’ Yinduynju yalamal, ‘Ngayu Godumu kuku balkal-balkal.’ Yamba jana yalarrku jurrilmalmal. Jana Dubundumundu junkurrdu miracle balkal, Godumu bama jurril-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yurra mumbarmaka. Ngayu yurranda yinya kuku balkan, milka-bakanka. Jananka jurril-bakanka miyil-janay.” ");
INSERT INTO gvn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesusangka yalaman baja, “Wawu kulimun wungarabu karida balbal baja, kijangka karida balbal baja. ");
INSERT INTO gvn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dawar jirimun dararida. Wungar, kija, dawar wubulku bulngajirikuda. ");
INSERT INTO gvn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yinyamun bamangka nganya nyajilda junkurr-muruku kankadanya ngurrbanji. Ngayu bamanga wubulbuku yaba. Ngayu dayirrku kaday, majakuda kaday. ");
INSERT INTO gvn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ngayu jiri-warra yiringkurrku yungalda Godundumunbu bamanda nyulu wangkanin. Jana jiri-warrangka Godumu bama bubumun yindu-yindumun mujal, wundinka jiringa, heavenba.” ");
INSERT INTO gvn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jesusangka yalaman baja, “Yinya yala juku wawuburra. Wawuburra ngankamalkuda, yurra binal diburr jarrukandamunbu bulkanga. ");
INSERT INTO gvn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yurra nganka nyajil, yurra binalda, minyada diburrda. Yurra kuli nyajil, yurra binalda, ngayuda kaday. ");
INSERT INTO gvn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yanyu kuku milkanga kuji. Bama nyiku juranku bundanday, jana wubulku wulanjiku, jana junjuy-junjuy warrmba-bal-bal yala ngayu yurranda balkan. ");
INSERT INTO gvn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jiri, bubu kunbay, yamba ngayku kuku kari kunbay. Ngayku kuku junkurrji, kari kunbay.” ");
INSERT INTO gvn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jesusangka yalaman baja, “Bama binal kari bajaku, ngayu wanja-wanja baja kaday baja? Jiri-warra yalarrku binal kari. Ngayu Godumu kangkal, yamba ngayu yalarrku binal kari. Ngaykuku nganjanku binal. ");
INSERT INTO gvn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mumbarmaka, miyil-janay. Yurra binal kari, wanja-wanja baja? ");
INSERT INTO gvn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yinyarrin yala bama bubungu yinduymbu dunganka. Nyulu wanja-wanja baja kaday baja? Bama wubul nyungunku workmanmaniji. Nyulu dunganjiku, kuku dajil jananda. Nyulu nyubunyimba dingkaranda balkal, ‘Yundu bayan nyaka, kuji, wujurrdurr. Miyil-janay, ngayu kadanyamunku baja.’” ");
INSERT INTO gvn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jesusangka yalaman baja, “Miyil-janaykuda. Ngayu yala yinya bama dunganyamunku. Ngayu wanja-wanja baja kaday baja? Nguba wungar daranyamunbu kaday, nguba wujurrbu kaday, nguba mudu-wayjul-wayjunyumunbu kaday. ");
INSERT INTO gvn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ngayu kaday, yurrangan nguba warrmba-bungal wunananyakuda. ");
INSERT INTO gvn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngayu yurranda, bamanda wubulbuku balkal, ‘Ngaykunku miyil-janay.’” ");
INSERT INTO gvn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Warngku jambulmal, bama wubulku murumarinka, big day holiday Passover haveim-bunganka, one week holiday Unleavened Bread haveim-bunganka. Maja-majangka Godundumunku bayanka, teacher-teacherangka ngadimunku, jana Jesus kiraynjaku karrbanka, yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jana jana-karrajiku balkawan, “Kari karrba bamanda miyilba. Jana nganangan nyajinji, kuninji.” ");
INSERT INTO gvn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nyulu Jesus townbu Bethany dungan, mayi nukanka Simonanji. Ngadiku Simon baji-bajiman, leprosymunji, yamba nyulu nyiku yalada. Jesus mayinga nukal-nukajin, jalbu nyungundu kadan bottleji jilaji mini-miniji. Yinya jila mini-mini burri nard, dear-bala bajaku, moneybu yalbaynja bajabuku manin. Nyulu jalbungku bottle dumbarrin, jila mini-mini Jesusanda dukulbu nyangarrin. ");
INSERT INTO gvn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bama kanbal jalbunku kuli-kadarin, jana-karrajiku balkawan, “Nyulu wanyurrinku jila mini-mini wumbabuku nyangarrinyarrkuda? Wanyurrinku wasteim-bungan? ");
INSERT INTO gvn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngana yinya jila mini-mini sellim-bunganyaku moneyka yalbaynka, 300 dollarsmunku, money bamanga money-karingakuda dajinyaku.” Jana jalbu murru-kanganda. ");
INSERT INTO gvn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yamba Jesusangka yalaman, “Nyungun bawa, yurra wanyurrinku nyungu kuli dajil-dajil? Nyulu ngaykundu ngulkurr balkan. ");
INSERT INTO gvn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yurranji bama money-kari wuljaljiku bundandari. Yurra wawubu, yurra janangan ngulkurrduku kuji. Yamba ngayu kari wuljaljiku yurranji bunday. ");
INSERT INTO gvn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nyulu ngaykundu nyangarrin bangkarrba, nganya yanday-bunganka, jana nganya juljalba nandanka.” Bama Jew-warra yalaku, yarkin jilabu mini-minibu julngkan, nandanjiku. ");
INSERT INTO gvn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jesusangka yalaman baja, “Ngayu yurranda manubajabuku balkal. Bamangka juma kuku ngaykunku balkal bubungu yindu-yinduymbu, yiringkurrku. Jana yinyaynka jalbunku balkal, bama binalmanka nyulu ngulkurr balkan ngaykundu.” ");
INSERT INTO gvn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wawu yinyamun nyubun bama jawun-karrandamun, burri Judas Iscariot, nyulu maja-majanda Godundumunbu bayanba dungan, jananda Jesus mambarrinka. ");
INSERT INTO gvn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jana maja-majangka Judas nyajin, jana wawurr-wawurrmaynda. Jana nyungunin moneyka wawurr-wawurr-bungan, nyulu jananda Jesus mambarrinka. Judasangka good chance kujil-kujin, Jesus mambarrinka. ");
INSERT INTO gvn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","First day holidaymunku Passovermunku kadan. Jana Jew-warra yalaku, jana first daymunbu minya sheep karrkay kuninya, minyaka Passovermunku. Jesusandamundu jawun-karrangka nyungundu yalaman, “Nganjin wanjabu dungari, minya wayjunku, Passover nukanka?” ");
INSERT INTO gvn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nyulu jawunyundu jambulimba yalaman, “Yubal townbu Jerusalem dungay, dingkar maku-nyajil, bucketji bana jarra-kulbal-kulbanya. Nyungun wukurrika. ");
INSERT INTO gvn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bayanba wukurrika, maja bayanka babajika, ‘Nyulu Teacherangka Jesusangka babajin, “Room wanjaku, ngayu, and ngaykuwundu jawun-karrangka mayi Passover nukanka?” ’ ");
INSERT INTO gvn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nyulu yubalin wangkar-wangkar wundil, roommunbu yalbaymba, tableji, chairji. Yubal minya yinyaymba wayju.” ");
INSERT INTO gvn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bula townbu dungan, junjuy-junjuy warrmba-bungan yala Jesusangkaku balkan. Bula minya wayjunda. ");
INSERT INTO gvn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wungar daran, Jesus jawun-karranji kanbalanji kadan. ");
INSERT INTO gvn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jana mayinga nukal-nukajin, Jesusangka yalaman, “Ngayu yurrangan manubajabuku balkal, yurra ngaykunji nukan-nukaji, nyubunyinja nganya mambarril maja-majanda.” ");
INSERT INTO gvn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jana milka-bujarmanda, nyubun-nyubunyinjaku Jesusanda babajin, “Wanjungku? Ngayu?” ");
INSERT INTO gvn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nyulu jananda yalaman, “Yurrandamun 12-balandamun nyubunyinja nganya mambarrilkuda. Nyulu yinyangkakudabi bread ngabal milkulbu ngaykunji. ");
INSERT INTO gvn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngayu bamanga wubulbuku yaba. Godundumunbu kabanda ngaykunku balkal, ngayu wulaykuda. Yamba kuli jirray kaday bamanda nganya mambarril. Nyulu jakalbaku kari balkajinyaku.” ");
INSERT INTO gvn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jana mayingada nukan-nukajin, Jesusangka bread manin, breadka God thankim-bungan, bread dumbarrin, jawun-karranda dajin, yalaman, “Mana, nukada. Yanyu bread ngayku bangkarr.” ");
INSERT INTO gvn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nyulu cup winemunji manin, God thankim-bungan, jananda dajin. Jana wubulinjaku nukaynda, yinyamun cupmun. ");
INSERT INTO gvn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nyulu jananda yalaman, “Yanyu ngayku mula. Godungku promise dajin bamanda. Ngayku mula warri, yinya kuku manubajamalkuda. Ngayu mula dajil bamanka wubulkuku. ");
INSERT INTO gvn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngayu yurranda manubajabuku balkal, ngayu wine yalanguy kari nukal baja. Ngayu juma bubunguku kaday baja, God majakuda wubulkuku. Ngayu yurranjida nukal baja, wine walu-yindu.” ");
INSERT INTO gvn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yinyamun jana wulngku badin, God buyay-maninka. Jana dungarinda wuburrbu burri Olive. ");
INSERT INTO gvn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesusangka jananda yalaman, “Dingkar-dingkar kadari, nganya karrbanka. Yurra yinyiljiku warrida, ngakiji jananka. Godundumundu kabanda balkan, ‘Nyubunyinja dingkarangka sheep kujil-kujil. Ngayu nyungun yarkinkaku kunil, sheep ngami-ngamiku warrarida.’ ");
INSERT INTO gvn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yamba Godungku nganya juran-bungal, ngayungurr dungay yurranka jakalba bubungu Galilee.” ");
INSERT INTO gvn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peterangka Jesusanda yalaman, “Jana wubulku warrarida, yamba ngayu kari.” ");
INSERT INTO gvn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesusangka nyungundu yalaman, “Ngayu manubajabuku yunundu balkal. Jukijuki wujurrbu kawal jambul yirrkanjiku, yundu nganya three times darrbil.” ");
INSERT INTO gvn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peterangka junkurr-murubuku yalaman, “Ngayu nguba yununji wulay, nguba kari, yamba ngayu yununku kari darrbiji.” Jana wubulduku yalarrku balkan. ");
INSERT INTO gvn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jana Jesus, nyungu jawun-karra, jana dungarin gardenba burri Gethsemane. Jesusangka jawun-karranda yalaman, “Yurra bundarika. Ngayu balu dungay, Godunji balkawanka.” ");
INSERT INTO gvn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nyulu Peter, James, John wundin nyungunji. Nyulu milka-bujarmanda, warrngkan-warrngkanda. ");
INSERT INTO gvn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nyulu jananda yalaman, “Ngayu milka-bujarmalarrku, yala junjuynju kulngkuldu nganya nyarril-nyarril. Yurra yaluy bundarika, miyil-janjanarikada.” ");
INSERT INTO gvn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nyulu buban dungan baja, bubungu jiba bada-bada wunan, Godundu babajinka nyulu wawu kari warrngkanka. ");
INSERT INTO gvn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nyulu Godundu yalaman, “Yundu ngayku nganjan. Yundu junjuy-junjuy balkalarrku. Ngayu wawu kari warrngkanka. Yamba yunduku nganya yungan, wulanka bamanka wubulkuku. Ngayu jananka wulayda, yala yunduku ngaykundu balkan.” ");
INSERT INTO gvn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nyulu kadan baja janandaku, nyajin warngku wunananya. Nyulu Peteranda yalaman, “Simon, yundu wanyurrinku kari buban miyil-janan? ");
INSERT INTO gvn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Miyil-janay, Godundu babajika, yurra milka-jananji Dubundu. Yurra wawu ngulkurrmanka, yamba yurra kari ngulkurrmal yurrandamunduku junkurrdu.” ");
INSERT INTO gvn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesus dungan baja, Godunji balkawanka baja, kuku yinyanguy balkan yala nyuluku jakalbaku balkan. ");
INSERT INTO gvn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nyulu janandaku kadan baja, nyajin baja warngku wunanarinku. Jana miyil kari bajaku walngajin, warngku jirray bajaku. Jana binal kari bajaku, jana wanjarrmanka baja nyungundu. Nyulu dungan baja, Godunji balkawanka baja. ");
INSERT INTO gvn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nyulu janandaku kadan baja, jananda babajin, “Yurra wunanariku? Yalada, jana yalaymbu kadarida, nganya mambarrinka bamanda buyun-buyunyundu. ");
INSERT INTO gvn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dakada, dungankada. Nyaka, nyulu kadayda, nganya mambarrinkada.” ");
INSERT INTO gvn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus balkan-balkawanku, Judas kadan. Nyulu jakalbaku Jesusamu jawun. Bama wubul nyungunji kadarin, naybujiku yalbaynjiku, and jukujiku kadarin. Jana, maja-maja Godundumunku bayanka, teacher-teacher ngadimunku, binga-binga, yinyarrinyangka jananin bama yungan, Jesus karrbanka. ");
INSERT INTO gvn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasangka jananda naybujirrba balkan, jana kadanjiku Jesusanda. Nyulu yalaman, “Ngayu nyubun kissim-bungal, yinyakudabi Jesus. Nyungun karrba, wundi, nyaka-nyakaku, nyulu warrinji.” ");
INSERT INTO gvn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas kadan, Jesusanda jinbalku dungan, yalaman, “Teacher.” Yinyamun nyulu Jesus kissim-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jana Jesus karrban, yaykarrdaku kujin. ");
INSERT INTO gvn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yinyarrin janjanarin nyubuninja naybu yalbay sword kulban, bama milka yakan. Yinya dingkar milka yakajin, nyulu workingman majamu yalbaymu Godundumunku bayanka. ");
INSERT INTO gvn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesusangka jananda babajin, “Yurra wanyurrinku ngaykundu jukujiku, and naybujiku kadarin? Ngayu wurrmay-baka kari. ");
INSERT INTO gvn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yurra nganya warngku yindu-yindu nyajin Godundumunbu bayanba binal-bungan-bunganya, yamba yurra yala-yalaku nganya kari karrban. Kari. Godumu kuku yinyaynka manubajamalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jana Jesusamu jawun-karra warrarinda, Jesus bawan. ");
INSERT INTO gvn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nyubun jawun warru, nyulu Jesus wukurril-wukurrin. Nyungundu mararr nyubunku bangkarrba. Dingkar-dingkarangka nyungun karrbanka, yamba kambiku karrban. ");
INSERT INTO gvn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nyulu warru kambi-kariku warrinda. ");
INSERT INTO gvn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jana Jesus wundin majanda yalbaymba Godundumunku bayanka courtcasemunku. Jana, maja-maja wubulku Godundumunku bayanka, teacher-teacher wubulku ngadimunku, binga-binga wubulku, jana murumarin yinyaymba bayanba. ");
INSERT INTO gvn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peterangka Jesus wukurrin kala-kalbaymun, kananga fencemunbu walan, majandamunbu yalbayandamunbu bayanba. Nyulu bayanga bura-kajin soldier-soldieranji. ");
INSERT INTO gvn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Maja-majangka, and binga-bingangka, jana Jesus yarkinkaku kuninka. Yinyaynka jana wawu bamangka yindu-yinduynju kuku jurril dajinka Jesusanka. Yamba jananga kuku kariyirrku buyun Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bama wubuldu kuku jurril dajin nyungunku, yamba jana kari agreemanijin. ");
INSERT INTO gvn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bama kanbal dakanda, kuku jurril Jesusanka dajin. ");
INSERT INTO gvn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Jana yalaman, “Nganjin nyungun milkabu nyajin yalamanya, ‘Dingkar-dingkarangka ngadiku Godumu bayan ngaran, yamba ngayu yinya bayan dumbarril. Warngku kulurmal, ngayu yindu ngaral. Bamangka kari yinya bayan ngaral, ngayuku ngaral.’” ");
INSERT INTO gvn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yamba yinyarrin dingkar-dingkar kari agreemanijin. ");
INSERT INTO gvn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Maja yalbay jakalba jananda dakan, Jesusanda yalaman, “Yundu jananin nyajin yunun nyuyanya. Yundu wanyu kuku dajil baja?” ");
INSERT INTO gvn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yamba Jesus jankaku bundan, kuku kariman. Majangka yalbaynja nyungundu babajin, “Yundu Godumu kangkal or kari? Yundu bama Godundumun or kari?” ");
INSERT INTO gvn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesusangka yalaman, “Ngayukuda. Ngayu bama Godundumun. Yurra nganya nyajil bundandanya Godunji, ngalin majaku bunday. Yurra nganya jirimun nyajil kankadanya ngurrbanji.” ");
INSERT INTO gvn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Majangka yalbaynja kulibu nyunguku kambi dumbarrin, yalaman, “Ngana wawu karida nyungunku balkanka baja. ");
INSERT INTO gvn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nyulu balkan nyulu Godkuda. Yurra nyungun nyajin, buyun bajaku. Yurra nyungundu wanjarrmanka?” Jana wubulduku kuku dajin, nyungun yarkinkaku kuninka, nyulu malajikuda. ");
INSERT INTO gvn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kanbalda nyungun nyumbabu daman, kanbalda nyungu miyil nandan, kunin, yalaman, “Wanjungku yunun kunin? Balka!” Soldierangka kanbalda nyungun karrban, walu kulban, bangkarr kunin marabu. ");
INSERT INTO gvn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nyulu Peter bada yardmunbu bundandan, jalbu nyubun kadan, nyulu jalbu majanka yalbaynka workmanman. ");
INSERT INTO gvn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nyulu Peter nyajin bura-kajin-kajinya, nyulu nyungun kunkun-bungan, yalaman, “Yundu yinyaynji dingkaranji townmun Nazarethmun. Yundu Jesusanji bundandan.” ");
INSERT INTO gvn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yamba Peterangka yalaman, “Kari. Ngayu nyungunkuku binal kari. Yundu wanyu kuku balkal-balkal?” Nyulu gateba dungan, jukijuki yirrkanda. ");
INSERT INTO gvn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jalbungku nyungun nyajin baja, yalaman bamanda janjanarinya, “Nyulu yinyakuda Jesusanji dungan-dungan.” ");
INSERT INTO gvn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yamba Peterangka yalaman baja, “Ngayu nyungunkuku binal kari.” Bamangka janjanarinya Peteranda yalaman, “Yundukuda Jesusamu jawun because yundu yalarrku bubumun Galileemun.” ");
INSERT INTO gvn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peterangka kuli-murubuku yalaman, “Godungku nganya nyajil. Kaki ngayu kari manubajabuku balkal, nyulu nganya punishim-bungal. Ngayu yinyaynka dingkaranka binal kari bajaku.” ");
INSERT INTO gvn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jukijukikuda yirrkan baja. Peteranda milkanga kadan Jesusangkaku nyungundu yalaman, “Jukijuki kawal jambul yirrkanjiku, yundu nganya three times darrbil.” Peter milka-bujarmanda, banbadinda. ");
INSERT INTO gvn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wungar dakanjiku jana, maja-maja Godundumunku bayanka, teacher-teacher ngadimunku, binga-binga wubulku, jana murumarin, Jesusanka balkawanka. Jana Jesus chainda kajan, wundinda yinduymbu dingkaranda, Pilateanda. Pilate, nyulu bama townmun Romemun, nyulu maja Jew-warrandamunku bubuku. ");
INSERT INTO gvn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilateangka Jesusanda babajin, “Yundu king Jew-warramu?” Jesusangka yalaman, “Ngayukuda.” ");
INSERT INTO gvn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Maja-majangka Jesus nyuyan junjuy-junjuynku. ");
INSERT INTO gvn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilateangka nyungundu babajin, “Yundu wanyurrinku kari kuku dajil baja? Milka-janay, jana yunun nyuyan-nyuyal.” ");
INSERT INTO gvn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yamba Jesusangka kari kuku manin. Pilate kungkurr-kadan. ");
INSERT INTO gvn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilate nyulu yalaku, nyulu every Passover holidaymundurr nyubun bama walngan jailmun. Bamangka Jew-warrangka nyubunyinka bamanka babajinya, Pilateangka yinya dingkar yunganya. ");
INSERT INTO gvn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yala-yala kanbal bama jailba bundandan, kuniwanya soldier-soldieranji, kanbal soldier yarkinkaku kunin. Nyubun yinyarrinmun burri Barabbas. ");
INSERT INTO gvn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bama wubulku Pilateanda murumarin, babajin nyubun bama walnganka jailmun yala nyulu every year walngan. ");
INSERT INTO gvn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilate binal maja-majangka Jesus nyungundu mambarrin, ngura-nyajinya, bama wubulku Jesusanka wawumanya. Yinyaynka nyulu maja-majanda babajin, “Yurra wawu ngayu Jew-warramu king walnganka?” ");
INSERT INTO gvn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yamba maja-majangka bamanda wubulbuku balkan baja, balkan baja, “Yirrkajika Barabbasanka.” ");
INSERT INTO gvn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilateangka bamanda wubulbuku babajin, “Ngayu wanjarrmal dingkaranda kinganda Jew-warranka?” ");
INSERT INTO gvn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jana yirrkajin, “Nyungun jukungu walngkan-dama.” ");
INSERT INTO gvn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilateangka jananda babajin, “Wanyurrinku nyungun walngkan-damanka, nyulu wanyu buyun balkan?” Yamba jana yirrkajin baja, “Nyungun jukungu walngkan-dama.” ");
INSERT INTO gvn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilateangka bama wubulku wawurr-wawurr-bunganka. Yinyaynka nyulu Barabbas walngan jailmun. Pilateangka bamanda yinduymbu balkan Jesus wuybubu kulbanka. Wawu wuybubu kulbanyamun Pilateangka Jesus mambarrin soldier-soldieranda, jukungu walngkan-damanka. ");
INSERT INTO gvn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldier-soldierangka Jesus Pilateandamun wundin kananga Pilateandamunbu bayanba yalbaymba. Jana soldier-soldier kanbal kunjan, murumarinka. ");
INSERT INTO gvn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jana kambi ngala-ngala didan Jesusanda. Jana dakil manin yala yibuy, bukul-bukulji, mulun-bungan, Jesusanda dukulbu didan. ");
INSERT INTO gvn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jana Jesus yajarrin, nyungundu yalaman, “Ya, yundu Jew-warramu king.” ");
INSERT INTO gvn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jana dukul jukubu kunin, nyungundu nyumba yilban, bungkubu janan, nyungun yajarrinka. ");
INSERT INTO gvn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wawu yinyamun jana ngala-ngala kambi nyungundumun walngan, nyunguku kambi nyungunduku didan baja. Jana nyungun ngalkalba wundinda, walngkan-damanka jukungu. ");
INSERT INTO gvn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jana dungan-dungarin, dingkar yindu maku-nyajin townbu kankadanya. Nyulu burri Simon, bubumun Cyrenemun kadan, nyulu nganjan Alexanderamu, and Rufusamu. Soldier-soldierangka Simon mambarrin juku cross jarra-kulbanka Jesusamu. ");
INSERT INTO gvn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jana Jesus wundin bubungu Golgotha. Golgotha mean Dukul Bajibay. ");
INSERT INTO gvn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jana wine, and medicine myrrh kuna-bungan, Jesusanda dajinka. Yamba nyulu kari nukan. ");
INSERT INTO gvn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jana nyungun jukungu walngkan-damanda. Jana soldier-soldierangka dice yilbal-yilban, nyajinka wanyangka kambi maninka. Jana yinyamundu kambi nyubun-nyubunku manin. ");
INSERT INTO gvn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","9 o'clockda, jana Jesus walngkan-daman jukungu. ");
INSERT INTO gvn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jana sign kabanba Jesusanka balkan, kaban jukungu daman, bama binalmanka jana wanyurrinku Jesus walngkan-daman. Yanyu kuku kabanba: “Jew-warramu king.” ");
INSERT INTO gvn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yala-yalaku jana dingkar jambul yalarrku walngkan-daman jukungu yinduymbu. Bula Jesusanda yubaku, Jesus dindarra. Bula wurrmay-baka. ");
INSERT INTO gvn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Godundumundu kabanda balkan, “Jana nyungun nyajil dingkaranji buyunyunji. Wubulduku yalamal, ‘Nyulu yalarrku buyun.’” Jana wurrmay-baka-bulal Jesusanji walngkan-daman, yinya kuku manubajamankuda. ");
INSERT INTO gvn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bama dungan-dungarin, jana Jesus yajarrin, yalaman, “Ya, yundu balkan yundu Godumu bayan dumbarrinka, warngku kulurmal ngaranka baja. ");
INSERT INTO gvn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yundu juranmaka baja yunduku. Wala jukumun.” ");
INSERT INTO gvn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Maja-maja Godundumunku bayanka, teacher-teacher ngadimunku, jana Jesus yalarrku yajarrin, yalaman, “Nyulu kanbal juran-bungan, yamba nyulu nyuluku kari juranmal. ");
INSERT INTO gvn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nyulu balu nyulu bama Godundumunkuda, balu Jew-warramu kingkuda. Nyulu jukumun walada. Kaki ngana nyungun nyajil walanya jukumun, ngana nyungun kuku nyajilda.” Bula yinya-bulal nyungunji walngkan, bula Jesus yalarrku yajarrin. ");
INSERT INTO gvn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wungar jarra-jarra, wujurrmaynda. Bubu yiringkurrku wujurrmaynda, 3 hours. ");
INSERT INTO gvn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 o'clockda, Jesus kawal yirrkajin, nyunguwundu kukubu yalaman, “Eli, Eli, lema sabachthani.” Yinya kuku mean “Ngayku God, ngayku God, yundu wanyurrinku nganya bawan?” ");
INSERT INTO gvn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kanbal bama yinyay janjanarinya, jana kawal nyajin, yalamanda, “Ya, nyulu Elijah kunjal-kunjal.” ");
INSERT INTO gvn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dingkar nyubun warrin, wuju manin, winemunbu cheap-balamunbu ngaban, jukungu bijinga kuna-bungan, Jesusanda dajin, nukanka. Dingkarangka bamanda wubulbuku yalaman, “Kariku, ngana nyajinka, nguba Elijah kaday, nyungun juran-bunganka jukumun.” ");
INSERT INTO gvn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus kawal yirrkajin, wulaynkuda. ");
INSERT INTO gvn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Curtain Godundumunbu bayanba walngkal-walngkan. Yinya curtain jambulku kadabanda wangkarmunduku badarrku. ");
INSERT INTO gvn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Maja soldier-soldieranka janjanan, nyulu Jesus kunkun-bungal-bungan. Nyulu nyajin wulanya, yalaman, “Yalunyu dingkar Godumu kangkalkuda.” ");
INSERT INTO gvn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jalbu-jalbungku kunkun-bungal-bungan buban kala-kalbaymundu. Jana kulur, Mary townmun Magdalamun, Salome, and Mary yindu, nyulu ngamu Josephamu, and Jamesamu. ");
INSERT INTO gvn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jakalbaku yinyarrinyangka jalbu-jalbungku Jesus wukurrin yiringkurrku bubungu Galilee, nyungun ngulkurrduku kujin, mayi dajin. Jalbu-jalbu wubul nyungunji townbu Jerusalem kadarin. Jana yinyarrinyangka nyungun kunkun-bungal-bungan, Jesus wulanya. ");
INSERT INTO gvn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yinya day bamangka wubulduku wunkunyunku mayi wayjun because warngku yindu jana wawu-balangajika, lawmunku. ");
INSERT INTO gvn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yilaylayman, dingkar yindu Pilateanda dungan. Nyulu burri Joseph, nyulu townmun Arimatheamun. Nyulu council, bama wubulku binal nyulu ngulkurr, junkayku. Nyulu waitmalman God majamanyamunku bamanka wubuliynkaku. Nyulu Pilateanda munaku dungan, Jesusanka yarkinka babajin. ");
INSERT INTO gvn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilateangka milkabu baykan, babajin, “Nyulu wulaynda?” Nyulu kuku yungan majanda soldier-soldieranka kadanka nyungundu. Pilateangka yinyayanda majanda babajin, “Nyulu wulaynda?” ");
INSERT INTO gvn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Majangka Pilateanda yalaman, “Nyulu wulaynkuda.” Pilateangka Josephanda kuku dajin, “Yundu yarkin mana, wundida.” ");
INSERT INTO gvn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josephangka linen sheet buy-im-bungan, Jesus yarkin jukumun walngan, sheetmundu kajan, mulun-bungan, yijarrin bulkajimunbu kuljinga. Jana jakalbaku yinya bulkaji bakan kuljimun. Nyulu yindu kulji yalbay yiringkan jakuwaymba, yarkin nandanka. ");
INSERT INTO gvn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Bula, Mary townmun Magdalamun, and Mary yindu, nyulu ngamu Josesamu, bula nyajin yinyaymba yarkin Jesus yijarrinya. ");
INSERT INTO gvn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sundayngada jana, Mary townmun Magdalamun, Mary yindu, nyulu ngamu Jamesamu, and Salome, jana jila mini-mini buy-im-bungan, Jesus yarkin julngkanka, jila mini-mini-bunganka. ");
INSERT INTO gvn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yalibalaku, wungar dakanda, jana bulkajimunbu kuljinga dungarin, yarkin julngkanka. ");
INSERT INTO gvn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jana kankadarin, balkawan, “Wanjungku ngananka kulji yiringkal jakuwaymun?” Kulji yalbay bajaku. ");
INSERT INTO gvn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yamba jana kadarin, kulji nyajin, jakuwaymun wunananya. ");
INSERT INTO gvn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jana bulkajimunbu walarin, warru nyajin kananga bundandanya. Nyungu kambi bingaji bajaku. Jana kungkurr-kadarinda, yinyilmarin. ");
INSERT INTO gvn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Warrungku jananda yalaman, “Kari yinyilmaka. Yurra Jesusanka nubin-nubiji. Jana nyungun walngkan-daman jukungu. Nyaka, nyungun jana yinyay yijarrin. Yamba nyulu juranman baja, nyulu yaluy bulkajimunbu yamba-karida. ");
INSERT INTO gvn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dungayda, nyunguwunbu jawun-karranda kuku daya Peteranda, ‘Nyulu dungayda, nyulungurr jakalba yurranka bubungu Galilee. Yurra yinyay nyungun nyajil yala nyuluku yurranda balkan.’” ");
INSERT INTO gvn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jana jalbu-jalbu warrarin bulkajimun, yinyilmarin, yararrin. Jana kuku kari balkan bamanda, yinyiljida. ");
INSERT INTO gvn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yala, Jesus Sundaynga juranmayn baja yarkinmun. Yinyamun nyulu nguwimal milbijin Maryndangarr, nyulu townmun Magdalamun. Ngadiku Jesusangka dubu 7-bala kangan Maryndamun dukurrmun. ");
INSERT INTO gvn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jana bama ngadiku Jesusanji dungan-dungarin, jana yinyarrin banbadarin, milka-bujarmanya Jesusanka. Mary jananda dungan, balkan, “Ngayu Jesus nyajin, nyulu jurankuda.” ");
INSERT INTO gvn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yamba jana nyungun kari believeim-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wawu yinyamun jawun-bulal jambul jinabu dungan-dungan baraldarr, Jesus nguwimal milbijin bulanda, yamba bula nyungun kari nyungun-bungan, nyulu yala yindu. ");
INSERT INTO gvn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jana dungan-dungarin, bula nyungun nyungun-bungan. Yinyamun bula jawun-karranda kanbalanda balkan nyulu jurankuda. Yamba jana jawun-karrangka bulangan kari believeim-bungan. ");
INSERT INTO gvn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wawu yinyamun jawun-karra mayingada nukan-nukajin, Jesus jananda nguwimal milbijin. Nyulu jananin murru-kangan, because jana dukul-dandi, kari believeim-bungan kuku kanbalda balkan Jesus jurankuda. ");
INSERT INTO gvn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesusangka jananda yalaman, “Yurra yiringkurrku bubungu yindu-yinduymbu dungarika, bamanda wubulbuku balka kuku ngulkurr ngaykunku. ");
INSERT INTO gvn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bamangka kanbalda nganya kuku nyajil, yinyarrin banabu baptiseim-bunga. Godungku janangan juran-bungal. Yamba bamangka kanbalda nganya kari kuku nyajil. Godungku jananda yalamal, ‘Yurra buyunku, ngaykundumun dungay.’ ");
INSERT INTO gvn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Bamangka nganya kuku nyajil, yinyarrinyangka miracle balkal Godundumundu junkurrdu. Kanbalda ngaykuwundu junkurrdu dubu-dubu kangal, kanbal walu-yindu kuku balkaway. Kaki jarbangka janangan baykal, jana kari bambaymal. Kaki jana buyun nukal, poison, jana kari bambaymal. Kaki jana bama bambay marabu karrbal, nyulu ngulkurrmal bambaymun. Godungku yinyamundu bamanda wubulbuku milbil jana bama nyungukuda.” ");
INSERT INTO gvn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Maja Jesus jananji balkawan, Godungku nyungun dakay-manin heavenbada, jiringa. Jesus Godunji bundanda, maja bajakuda. ");
INSERT INTO gvn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jana Jesusamu jawun-karra yiringkurrku bubungu yindu-yinduymbu dungarin, kuku ngulkurr balkal-balkan. Jesusangka janangan helpim-bungan. Nyulu yinyamundu milbin yinya kuku manubajakuda, nyulu junkurr nyunguwunbu bamanda dajinya, miracle balkanka. Yalakubada. ");
INSERT INTO gvn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bamangka wubuldu kabanba balkan Jesusanka, nyulu wanjarrmalman bubunguku bundandan. ");
INSERT INTO gvn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kanbalda Jesus wukurril-wukurrin, nyajil-nyajin, yinyarrinyangka nganjinanda kuku balkan nyungunku. Nganjin yinya kuku kabanba balkan. ");
INSERT INTO gvn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ngayu kuku kabanba balkanka Jesusanka, ngayu jananga kuku mumbarabuku nyajinya, binalmanya. Ngayu yinya kuku kabanba balkanka, yunundu yunganka. ");
INSERT INTO gvn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yinyamundu kabanda yununin mumbarabuku binal-bungalda kukuku jana yunundu balkan. Ngayu wawu yundu kukuku manubajakaku binalmanka Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ngadiku Herod nyulu king bubuku Judeamunku. Nyubun priest yinyaymba burri Zechariah, nyungu jawun-karra dingkarandamun Abijahandamun. Jana dingkar-dingkar jawun-karra Abijahandamun, jana wubulku priestman. Nyungu manyarr burri Elizabeth. Nyungu jawun-karra dingkarandamun Aaronandamun. Aaronamu kangkal-kangkal dingkar-dingkar, jana yalarrku priestman. ");
INSERT INTO gvn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bula Zechariah junkayku bundandan Godunku. Bula Godumu kuku wukurrin, nyungu law kari buyun-daman. ");
INSERT INTO gvn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bula kangkal-kangkal wantim-bungan, yamba Elizabeth kari kulngkulman. Bula wulman, and wulbumanda. ");
INSERT INTO gvn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Juma Zechariahmu turn kadan Godundumunbu bayanba workmanijinka. ");
INSERT INTO gvn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jana priest yalaku; jana junjuy yala dice yilban, nyajinka wanju roommunbu walanka, junjuy jila ngulkurr wayjunku Godunku. Jana dicemundu Zechariah bamban. ");
INSERT INTO gvn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yinyamun Zechariahngka jila ngulkurr wayjul-wayjun, jana bama wubulku ngalkalba miyil nandajin, praymanijin. ");
INSERT INTO gvn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yala, nyubun angel nguwimal milbijin Zechariahnda, janjanan right sidemunbu tablebu Zechariahangka yinya junjuy jila ngulkurr wayjun. ");
INSERT INTO gvn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariahangka angel nyajin, nyulu wawu-dudajin, yinyilmankuda. ");
INSERT INTO gvn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yamba nyulu angelangka yalaman, “Kari yinyilmaka, Zechariah. Godungku yunu kuku prayer nyajin. Yunu manyarr, Elizabeth juma kulngkulmal, yubalanga kangkal dingkar balkaji. Yubal burri dalki John, nyungun. ");
INSERT INTO gvn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wawu balkajinyamun yubal wawurr-wawurrmal. Yalarrku bama wubul wawurr-wawurrmal nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Godungku nyungunin nyajil, jarra jirray bamanka kanbalanka. Nyulu kamu-kamulu kari bajaku nuka. Nyulu balkajinjiku, Godumu Wawu nyunguwunbu dukurrbu walal, bunday nyungunji. ");
INSERT INTO gvn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nyulu yalbaymal, nyulu bama wubul Jew-warra jurrki-manil. Jana jurrkiji buyun-buyunmun, jananga Maja Godku wukurrilda. ");
INSERT INTO gvn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nyulu Godumu kuku yirrkay bamanda yala prophetangka Elijahngka ngadiku yirrkan. Godundumundu Wawubu nyungun junkurrji-bungal yala nyulu Elijah junkurrji-bungan. Johnungku kuku balkal nganjan-karranda, jana kari kuli-kaday baja janawunku kangkal-kangkalanka. Bama yinyarrin kanbal dukul-dandilu Godunku, jana nyungun kari kuku nyajil. Johnungku jananin jurrki-manil, jana ngulkurrku dungarinka. John jakalba kaday, yinyamun nyulu Maja kudamundu kaday. Johnungku bama ready-bungal Majanka.” Angelangka yinya kuku balkan Zechariahnda. ");
INSERT INTO gvn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariahngka yalaman, “Ngayu wanjarrku binalmal if yinya kuku manubajakuda? Ngayu wulman bajaku, yalarrku ngayku manyarr wulbumankuda.” ");
INSERT INTO gvn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angelangka nyungundu yalaman, “Ngayu angel burri Gabriel. Ngayu jakalba Godundu janay, nyungun kuku wukurrinka. Nyulu nganya yungan yinya kuku ngulkurr balkanka yunundu. ");
INSERT INTO gvn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yamba yundu ngaykuwunbu kukungu kari milka-janan. Yinyaynka yundu kuku-karimalda. Juma time kaday, Godungku ngayku kuku manubaja-bunganka. Yala-yalabi yinya kangkal balkaji. Wawu yinyamun yundu kukujimal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jana bama ngalkalba waitmalman Zechariahnka. Jana jana-karrajiku balkawan, “Nyulu wanyurrinku kariku wandin?” ");
INSERT INTO gvn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nyulu kadan, nyulu kuku-kariku wandin. Yinyaynka bama wubulku binal angel Godundumun nyungundu kadan. Nyulu marabu balkan jananda, kuku-karimanya. ");
INSERT INTO gvn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zechariahngka nyungu work kunbay-manin Godundumunbu bayanba, yinyamun nyulu bayanbaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wawu yinyamun nyungu manyarr Elizabeth kulngkulman. Kija 5-bala nyulu kari wandin bayanmun. ");
INSERT INTO gvn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nyulu nyuluku balkan, “Ngayku Maja God ngaykunku ngulkurrman. Wawu nyikumun ngayu kari murru-kaday baja, kangkal kari maninya.” ");
INSERT INTO gvn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yala, Elizabeth kulngkulman. Kija 6-balaman, Godungku angel Gabriel bubungu yungan baja. Nyulu nyungun bubungu Galilee, townbu Nazareth yungan. ");
INSERT INTO gvn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Angelangka Gabrielangka kuku wundin maralanda Marynda. Maryngka dingkar kariku dunyu-bungan, dingkaranji kariku wunan. Jana Mary Josephanda promiseim-ban, wunanka. Joseph, nyulu King Davidandamun. ");
INSERT INTO gvn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angelangka Marynda yalaman, “Ya, nyulu Maja God yununji, yununku wawu jirray. Nyulu yunun ngulkurrduku kujin-kujil.” ");
INSERT INTO gvn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yamba Mary wawu-dudajin yinyaynka kukuku. Nyulu nyuluku yalaman, “Ya, wanyurrinku nyulu ngaykundu yala balkan?” ");
INSERT INTO gvn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nyulu angelangka Marynda yalamanda, “Kari yinyilmaka, Mary. God yununku wawu jirray, yunun ngulkurrduku kujin-kujil. ");
INSERT INTO gvn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yundu juma kulngkulmalkuda. Yinyamun yunu kangkal dingkar balkaji, yundu nyungun burri dalki, Jesus. ");
INSERT INTO gvn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nyulu Majamu Godumu jirraymu kangkal. Nyulu junkurrjikuda. Majangka Godungku nyungun king-bungal, yala David ngadiku, nyulu Davidandamunku kaday. ");
INSERT INTO gvn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nyulu Jew-warramu kingmal wuljaljiku. Nyulu jananin wuljaljiku ngulkurrduku kujil.” ");
INSERT INTO gvn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryngka angelanda yalamanda, “Wanjarrku ngayu kulngkulmal? Ngayu dingkar kariku dunyu-bungan.” ");
INSERT INTO gvn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelangka nyungundu yalaman, “Godumu Wawu ngulkurr yunundu kaday. Nyulu yunundu walal, Godundumundu junkurrdu yalbaynja yunun nandal. Yinyamun yundu kulngkulmalkuda. Nyulu kangkal Godumu, buyun kari bajaku. Bamangka nyungun bambal Godumu kangkal.” ");
INSERT INTO gvn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nyulu angelangka yalaman baja, “Yunu kambanmu Elizabeth yalarrku kulngkul. Nyulu wulbuman, yamba nyulu kulngkulman. Godungku Elizabethanda and nyunguwunbu dunyundu kangkal dingkar yungan. Jakalbaku Elizabeth kari kulngkulman, yamba nyulu kulngkulmankuda 6 months. ");
INSERT INTO gvn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God, nyulu yalbay bajaku, junkurrji bajaku. Junjuy-junjuy wubulku nyuluku balkal. Kanbal binal kari. Nyuluku. Godku.” ");
INSERT INTO gvn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryngka angelanda yalamanda, “Godungku nganya juru-kulbal, ngayu nyungun juru-wukurril. Yundu Godumu kuku balkan ngaykundu. Ngayu kaji Godumu, ngayu yinya kuku maninka, wukurrinka.” Wawu yinyamun nyulu angel nyungundumun dunganda. ");
INSERT INTO gvn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yinyamun Mary jinbalku Elizabethanda dungan. Nyulu naka dungan bubungu Judea, wuburr-wuburrbu. Nyulu townbu kadan, ");
INSERT INTO gvn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","nyulu Zechariahndamunbu bayanba walan, Elizabethanda yalaman, “Wanjarr yundu, yalada yundu?” ");
INSERT INTO gvn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nyulu Elizabethangka Marymu kuku milkabu nyajin, nyungu kangkal waralba burrkin. Yinyamun Godumu Wawu Elizabethandamunbu dukurrbu walan. ");
INSERT INTO gvn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nyulu yaykarrdaku yalaman Marynda, “Godungku yunun wawurr-wawurr-bungal, kanbalanka jalbu-jalbunku. Yalarrku yunu kangkal wawurr-wawurrmanijikuda. ");
INSERT INTO gvn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yundu ngaykuwunbu Majamu ngamukuda. Karibi. Godungku yununin ngaykundu yungan. ");
INSERT INTO gvn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yala-yala ngayu yunu kuku nyajin, ngayku kangkal wawurr-wawurrman, burrkin waralba. ");
INSERT INTO gvn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yundu Godumu kuku yununku believeim-bungal manubajamanya. Yinyaynka yundu yalarrku wawurr-wawurrmalkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Maryngka yalaman, “Ngayku wawu wawurr-wawurrmalarrkuda. Ngayu yinyaynka ngayku Maja God buyay-manil. Ngayku wawu wawurr-wawurrmal Godunku. Nyulu nganya wawu juran-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngayu jarra bangkarr buyun, yamba nyulu ngaykunku kari milka-wulan. Wawu nyikumun bamangka wubulduku nyajil ngayu wawurr-wawurrku bundandanya. ");
INSERT INTO gvn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngayu wawurr-wawurrku bunday, Godungku junjuy-junjuy yalbay balkanya ngaykunku. Nyulu God ngulkurr bajaku, dayirr bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kaki bama Godundu milka-janay and nyungunku wawu jirray, nyulu jananka manun-manunmal. Nyulu manun-manunmal jananka bundandari nyiku, janawunku kangkal-kangkalanka, bamanka wuljaljiku. ");
INSERT INTO gvn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yamba kanbal bama bulmbuymanka, majamanka. Nyulu jarra junkurrji jananka. Nyulu jananin ngami-ngami-bungal, yayin-yayin-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nyulu Government maja jirray buban-bungal. Yalarrku, nyulu bama buban yalbay-bungal, jananda work jirray dajil. ");
INSERT INTO gvn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nyulu mayi dajil bamanda dakwuyku bundanday. Yamba nyulu bama rich-bala nyungundumun yungal, yamba-karijiku. ");
INSERT INTO gvn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nyulu Godungku nyungu kuku kujin jananka bamanka Jew-warranka ngadimunku. Nyulu kuku kujin, jananin ngulkurrduku kujinkuda. ");
INSERT INTO gvn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nyulu wuljaljiku manun-manunmal Abrahamanka, bamanka nyungundumun. Nyulu jananka kari milka-wulay.” Maryngka yalurrin kuku wubulku balkan Godunku. ");
INSERT INTO gvn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nyulu kija kulur bundan Elizabethanji, yinyamun nyulu bayanbaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabethamu time kadanda, nyungu kangkal balkajinka. Kangkal balkajinda, kangkal dingkar. ");
INSERT INTO gvn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bamangka wubulduku kuku nyajin Elizabethandamunku kangkalanka. Bamangka wubuliynjaku, jawun-karrangka yinya kuku nyajin, jana wawurr-wawurrmankuda Elizabethanka, God manun-manunmanya nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nyulu ngawa warngku 8-balaman, jana nyungun yulban yakan. Yala-yala jana nyungun burri dalkinka, Zechariah, burri yala nyungu nganjanku. ");
INSERT INTO gvn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yamba nyunguwundu ngamungku yalaman, “Kari, ngana nyungun John burri dalkil.” ");
INSERT INTO gvn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jana nyungundu yalaman, “Wanyurrinku yundu nyungun John burri dalkinka? Yubal nyungun Zechariah burri dalki yala nyungu nganjan. Yubalanga jawun-karra yamba-kari burri John.” ");
INSERT INTO gvn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zechariah, nyulu jakalbaku kuku-kariman. Jana marabu balkan nyungundu, nyungundu babajinka wanju burri kangkalamu. ");
INSERT INTO gvn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariahangka kabanka babajin. Nyulu kabanba balkan, “Ngayku kangkal burri John.” Jana wubulku kungkurr-kadarin. ");
INSERT INTO gvn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yala-yala nyulu Zechariah kukujiman baja. Nyulu God buyay-maninda. ");
INSERT INTO gvn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jana bamangka yinya nyajin, jana yinyilmarinkuda. Kuku yinya yiringkurrku dungan bubungu wuburrdurr Judeanga. ");
INSERT INTO gvn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bamangka wubuliynjaku yinya kuku nyajin, jana janaku babajin, “Yanya ngawa ngananka balkajinda, nyulu wanjarrmalkuda? Nyulu yalbaymal, nyulu nguba majamalkuda.” Jana binal Godundumundu junkurrdu nyungun junkurrji-bungankuda. ");
INSERT INTO gvn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wawu yinyamun Godumu Wawu Zechariahanda dukurrbu walan. Nyulu Godumu kuku yanyu balkan, ");
INSERT INTO gvn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ngana Maja God Jew-warramu buyay-mana. Nyulu kadan nyungu bama helpim-bunganka, jananin yunganka buyun-buyunmun. ");
INSERT INTO gvn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nyulu Christ junkurrji yungan, bamanga wawu juran-bunganka. Nyulu Christ Davidandamun. Davidangka ngadiku Godumu kuku wukurrinkuda. ");
INSERT INTO gvn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Godungku ngadiku prophet-prophet kukuji nyunguwunji yungan. Godumu kuku yalaku: ");
INSERT INTO gvn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Godungku yurranin kujil kuli-bakandamun. Bama yinyanguy yurranka wawu karilu, jana yurranin kari buyun-damal.’ ");
INSERT INTO gvn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ngadiku nyulu nganandamunbu nganjan-karranda yalaman, ‘Ngayu manun-manunmal yurranka, ngaykuwunku kukuku kari milka-wulay yurranka.’ ");
INSERT INTO gvn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nyulu Abraham wawurr-wawurr-bungan ngananka. ");
INSERT INTO gvn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nyulu yalaman, ‘Ngayu yurrangan kuli-bakandamun manil, yurranin ngulkurrduku kujil. Yinyamun yurra kari yinyilmal baja, ngayku work balkanka. ");
INSERT INTO gvn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yurra nganya wukurrilda, junkayku dungari, dayirr-dayirrku bundari, wuljaljiku.’” ");
INSERT INTO gvn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yinyamun Zechariahangka kangkalanda Johnundu yalaman, “Ngayku kangkal, Majangka jirrayngka yunun yungal nyungu kuku balkanka bamanda. Jana yunun Godumu prophet bambal. Yundu jakalba Majanka Christanka dungay, bama ready-bunganka nyulu kadanyamunku. ");
INSERT INTO gvn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yundu jakalba nyungunku dungay, nyunguwunbu bamanda balkal nyulu bama juran-bunganka, buyun-buyun kidanya wawumun janandamun. ");
INSERT INTO gvn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ngananga God, nyulu manun-manun ngananka. Nyulu ngananga wawu juran-bunganka. Nyulu dingkar yala light dayirr ngananda yungal. ");
INSERT INTO gvn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yinyamundu lightmundu heavenmun balbal bama nguwul-nguwulbu bundandari, balbal bama wulan-wulari. Lightmundu jananga baral balbal, jana wawu-ngulkurrku dungarinka.” Zechariahangka yinya kuku balkan. ");
INSERT INTO gvn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nyulu karrkay yalbayman, nyulu God ngulkurrduku wukurrin. Jakalbaku nyulu bubungu jirrbu-jirrbungu bundandan, yinyamun nyulu bamanda Jew-warranda dungan, Godumu kuku yirrkanka. ");
INSERT INTO gvn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yala-yala majangka jirrayngka bama wubulku countim-bunganka. Nyulu maja Governmentanka, burri Augustus. Nyulu maja-majanda bubananda balkan, “Yurra bamanga wubulbuku burri kabanba balka.” ");
INSERT INTO gvn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yala-yalaku jana bama countim-bungan, nyulu Cyrenius maja bubuku Syriaka. ");
INSERT INTO gvn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bama wubulku janangaku townbuku dungan, janangaku burri kabanba balkanka. ");
INSERT INTO gvn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nyulu Joseph King Davidandamun. King Davidamu bubu Judea, nyungu town Bethlehem. Yinyaynka Joseph townmun Nazarethmun, bubumun Galileemun dungan, townbu Bethlehem dungan, jana nyungun countim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mary dunyunji dungan, Josephanji. Jana Mary countim-bunganka Josephanji. Nyulu Mary kulngkul. ");
INSERT INTO gvn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Bula Bethlehem kadan, yamba room yamba-kari hotelba. Yinyaynka bula bundan bayanba bulkindamunbu, donkeyndamunbu. Time kadanda Marymu kangkal balkajinka. Nyulu balkajinda yinyaymba bayanba bulkindamunbu. Ngawa dingkar, nyulu jakalbamun. Box yalbay yinyaymba wunan, box mayika jikanka donkeymu. Maryngka ngawa kambibu kajan, boxmunbu yijarrin. ");
INSERT INTO gvn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yala-yala kanbalda dingkar-dingkarangka sheep wubul kujil-kujin yinyaymba bubungu. Jana wujurrdurr sheep nyajil-nyajinya. ");
INSERT INTO gvn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kari. Nyulu angel kadan Godundumun, nguwimal milbijin jananda dingkar-dingkaranda. Lightmundu Godundumundu jananin balban. Jana yinyilmanda. ");
INSERT INTO gvn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kari, angelangka jananda yalaman, “Kari yinyilmaka. Ngayu kuku ngulkurr yurranda wundil. Bama wubulku wawurr-wawurrmaniji yinyaynka kukuku. ");
INSERT INTO gvn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngawa nyiku balkajinda townbu Davidandamunbu. Nyulu balkajin yurranka. Nyulu bamanga wawu juran-bungalkuda, nyulu Maja Christ. ");
INSERT INTO gvn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yurra ngawa warrmba-bungal kambibu kajanya, wunananya boxmunbu. Yurra nyungun nyajil yinyaymba wunananya, yurra binalda, ngayu yurranda manubajabuku balkan.” ");
INSERT INTO gvn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yinyamun angel-angel wubul nguwimalmanda dingkar-dingkaranda. Jana angel-angel wulngku badin, singmanijin Godunku, nyungun buyay-maninka. Jana yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God buyay-mana. Nyulu junkurrji bajaku. Kaki God wawurr-wawurrmaniji bamanka bubungu, yinyarrin bama wawu-ngulkurrku bundayda, milka-marrimalda.” ");
INSERT INTO gvn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yinyamun angel-angelangka jananin dingkar-dingkar bawanda, dungan baja wangkar-wangkar heavenbaku. Jana dingkar-dingkarangka jana-karrajiku yalaman, “Ngana townbu Bethlehem dungayda, yinya nyajinka Godungku ngananda balkanya.” ");
INSERT INTO gvn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jana jinbalku dungarin, bulanin Mary, Joseph warrmba-bungan, ngawa nyajin boxmunbu wunananya. ");
INSERT INTO gvn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dingkar-dingkarangka ngawa nyajin, jana bamanda balkan yinyarrinyangka angel-angelangka jananda balkan ngawanka. ");
INSERT INTO gvn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jana bamangka yinya kuku nyajin, jana kungkurr-kadan, milkabu wukurrin kuku dingkar-dingkarangka balkan. ");
INSERT INTO gvn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary yinyayanka kari milka-wulan. Nyulu milkabu kujin, mumbarabuku milkabu wukurrin. ");
INSERT INTO gvn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dingkar-dingkar dungarin baja, God buyay-manil-manin yinyaynka jana nyajinya. Angel-angelangka jananda balkan, jana yala nyajin. ");
INSERT INTO gvn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nyulu ngawa warngku 8-balaman, jana nyungun yulban yakan, burri dalkin, Jesus. Mary kulngkulmanjiku, angelangka Marynda yalaman, “Ngawa burri Jesus.” ");
INSERT INTO gvn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jesus 40-days oldman, bula Josephangka, Maryngka ngawa Godundumunbu bayanba yalbaymba wundin townbu Jerusalem Jew-warrandamunku lawmunku. ");
INSERT INTO gvn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jew-warrandamundu lawbu yalaku balkal, “Yurra ngawa dingkar-dingkar jakalbamun wubulku Godundumunbu bayanba wundi, Godundu dajinka.” ");
INSERT INTO gvn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kaki ngawa balkaji, jana minya wayjul Godunku, lawmunku. Jana yalaku. Bula minya bakamu jambul wundin, bayanga wayjunku, Godundu dajinka, Godundumunku kukuku. ");
INSERT INTO gvn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yala-yalaku nyubun wulman, burri Simeon, nyulu townbu Jerusalem bundandan. Nyulu junkayku bundan, Godunku wawu jirray. Nyulu waitmalman Godungku bama Jew-warra ngulkurr-bunganyamunku buyun-buyunmun. Godumu Wawu wulmanandamunbu dukurrbu bundan. ");
INSERT INTO gvn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Godundumundu Wawubu wulmananda balkan, “Yundu kariku wulay. Ngadiku Godungku promise dajin nyulu Christ yunganka. Jakalba yundu Maja Christ nyajil, yinyamun yundu wulaykuda. ");
INSERT INTO gvn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Godundumundu Wawubu wulman Simeon Godundumunbu bayanba wundin. Yala-yalaku bula Josephangka, Maryngka ngawa Jesus bayanba wundin, nyungun Godundu dajinka, lawmunku. ");
INSERT INTO gvn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonangka yinya ngawa barungu manin, God buyay-manin, yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Maja, yundu nganya promiseim-ban ngayu nyungun nyajinka. Ngayu nyungun nyajinkuda, ngayu wawurr-wawurrku wulayda. ");
INSERT INTO gvn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yundu nyungun yunganda, bamanga wawu juran-bunganka. Ngayu nyungun miyilda nyajinkuda. ");
INSERT INTO gvn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Yundu nyungun yungan, bamangka wubulduku nyajinka, binalmanka. ");
INSERT INTO gvn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nyulu yala light. Jana bamangka Gentile-warrangka nyungun nyajil, jana binalmalda Godunku. Jana yinya light nyajil, jana Jew-warra buyay-manil.” ");
INSERT INTO gvn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bula Josephangka Maryngka Simeonamu kuku nyajin, bula kungkurr-kadan. ");
INSERT INTO gvn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeonangka Godundu balkan bulanka, nyungundu babajin bulanin ngulkurrduku kujinka. Nyulu Marynda yalaman, “Godungku yanyu ngawa bamban bamanga Jew-warramu wawu ngulkurr-bunganka. Yamba kanbal nyungunku wawu kari, jana wulaykuda. Kanbalda nyungun nyajil, jana kuku buyun balkal nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yinyamundu jana milbil wanyu jana milkabu baykal. Mary, yundu milka bujarmal yanyunku kangkalanka. Milka-bujar yala naybubu yunu wawu bakal.” ");
INSERT INTO gvn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nyubun wulbuman bunjil Godundumunbu bayanba, nyulu prophet. Nyulu Godumu kuku balkan. Burri nyungu Anna. Nganjan nyungu Phanuel. Nyulu Asherandamun. Nyulu marryman 7-yearsmunku, yinyamun nyulu bunjilmaynda, 77-yearsmunku. ");
INSERT INTO gvn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nyulu Godundumunbu bayanba bundandan, kari bawan. Nyulu yarbarrkaku God buyay-manin wungara, wujurrbu. Nyulu sometimes mayi kari nukan, God buyay-maninka, praymanijinka. ");
INSERT INTO gvn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yala-yalaku nyulu Marymu kangkal nyajin, nyulu God thankim-bungan. Kanbalda bamangka townbu Jerusalem Christ kujil-kujin, Christangka bama ngulkurr-bunganka buyun-buyunmun. Nyulu wulbumanangka Annangka jananda wubulbuku balkan ngawanka. ");
INSERT INTO gvn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bula Josephangka and Maryngka lawmunku work kunbay-manin, Godundumunbu bayanba. Yinyamun jana bayanbaku dungarin baja townbu Nazareth, bubungu Galilee. ");
INSERT INTO gvn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nyulu kangkal yalbayman, junkurrjiman. Nyulu binalman, dukul-ngulkurrman. God wawurr-wawurrman nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Every year Jesusamu ngamu and nganjan townbu Jerusalem dungan holidaymunku Passovermunku. Bula yinyaymba Passover nukanka. ");
INSERT INTO gvn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus 12 years oldman, jana dungarin baja, Passover nukanka. ");
INSERT INTO gvn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Passover kunbaynda, bula ngamungku, nganjanangka Jerusalem bawan, bayanbaku dunganka baja. Yamba nyulu Jesus bulanji kari dungan, nyulu townbu Jerusalem bawajin. Bula ngamu, nganjan binal kari nyulu kudamundu bawajin. ");
INSERT INTO gvn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Balu nyulu jawun-karranji kankadan. Jana bama all day dungan-dungarin. Yilay-yilayman, bula jawun-karranda babajin nyungunku, nyungun nubinka. ");
INSERT INTO gvn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yamba bula nyungun kari warrmba-bungan jawun-karranji. Yinyaynka bula jurrkijin, townbuku Jerusalemku dungan baja, Jesus warrmba-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Warngku kulurman bula nyungun warrmba-bungan Godundumunbu bayanba. Nyulu Jew-warrandamunji teacher-teacheranji bundandan, jananga kuku nyajil-nyajin, jananda baban-babajin. ");
INSERT INTO gvn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bamangka wubulduku Jesusamu kuku nyajin, jana kungkurr-kadarin. Nyulu dukul-ngulkurr, binal bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bula ngamu-nganjanangka nyungun nyajin Godundumunbu bayanba, bula yalarrku kungkurr-kadan. Ngamungku nyungundu yalaman, “Kangkal, yundu wanyurrinku ngalinin bawan? Ngalin wawu-buyunman yununku, yunun nubil-nubin.” ");
INSERT INTO gvn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesusangka bulanda babajin, “Yubal nganya wanyurrinku nubil-nubin? Yubal binalmanyaku ngayu ngaykuwunbu nganjanandamunbu bayanba must bunday.” ");
INSERT INTO gvn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yamba bula nyunguwunku kukuku binal kari. ");
INSERT INTO gvn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yinyamun Jesus bulanji bayanbaku dungan baja, townbuku Nazarethku. Nyulu bulanda milka-janan. Nyulu Maryngka milkabu wukurril-wukurrin Jesus, milkabu wukurrin nyulu Godundumunbu bayanba bundandanya. ");
INSERT INTO gvn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus yalbayman. Nyulu binalman, dukul-ngulkurrman. Nyulu God, jana bama, jana wawurr-wawurrman nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius Caesar, nyulu maja jirray bubuku Romemunku. Nyulu maja jirray 15-yearsmunku. Pontius Pilate, nyulu maja bubuku Judeamunku. Herod, nyulu maja bubuku Galileemunku. Nyungu yabaju Philip, nyulu maja bubuku Itureamunku and Trachonitismunku. Lysanias, nyulu maja bubuku Abilenemunku. ");
INSERT INTO gvn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas bula Caiaphas, bula maja-bulal Godundumunku bayanka. Yala-yalaku Godumu kuku kadan Johnundu. Nyulu kangkal Zechariahamu. John bundandan bubungu jirrbu-jirrbungu. ");
INSERT INTO gvn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","John yiringkurrku dungan bubungu yubaku wawubajanga Jordan, Godumu kuku yirrkan-yirrkan bamanda. Nyulu yalaman, “Yurra buyun-buyunmun jurrkijika, banabu dukul-damajika. Yinyamun Godungku buyun-buyun kidal yurrandamun.” ");
INSERT INTO gvn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngadiku nyulu prophetangka Isaiahangka Godumu kuku kabanba balkan. Nyulu balkan, “Nyubun bama yirrkan-yirrkay bubungu jirrbu-jirrbungu. Nyulu yirrkay, ‘Readymaka, Maja Christ kadanyamunku. Junkayku dungarika. Readymaka nyungunku. Yinya yala bamangka baral junkay-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jana kanka wubulku jakal-bungal, manjal-manjal, wuburr-wuburr balay-bungal. Baral kurru-kurru junkay-bungal, baral dunju-dunju julbarr-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bamangka wubuliynjaku nyajilda Godungku bama juran-bunganya buyun-buyunmun.’” ");
INSERT INTO gvn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bama wubul Johnundu kadarin. Jana wawu nyulu jananin banabu dukul-damanka. Nyulu jananda yalaman, “Yurra yala jarba kuliji. Wanjungku yurrangan milka-bakan Godundumun kulimun ngakijinka? Nyulu Godungku juma kuli jirray yungal bubungu. ");
INSERT INTO gvn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Junkaymakada. Ngulkurrmakada. Yurra yinyamundu milbi ngulkurrmanda, bamangka nyajinka yurra buyun-buyunmun jurrkijinda. Yurra kari yalamaka, ‘Ngana bama Jew-warra, Abrahamandamun. Ngana yalada.’ Kari, yinya manubaja kari. Yurra jurrkijika. Yuwu, yurra Abrahamandamunkuda, yamba yinyamundu yurranin kari Godundu wundil. Yurra must buyun-buyunmun jurrkijika, Godundu dunganka. Ngayu yurranda balkal, kaki God wawubu, nyulu bama Abrahamandamun balkal yalurrinyandamun kuljimun. ");
INSERT INTO gvn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bama yala juku mayiji. Kaki mayi kari balkaji, bamangka yinya juku nyandal, yilbal bayanga. Nyulu waymbil jalngkun-bungan, juku nyandanka, bada-bada bajaku, ngara. Yinya yala God. Nyulu readyda, kuli yunganka bamanda, jana kari ngulkurrku bundanya, kari junkayku dunganya.” ");
INSERT INTO gvn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bamangka Johnundu babajinda, “Nganjin wanjarrmalda?” ");
INSERT INTO gvn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Johnungku yalaman, “Kaki yundu kambiji jambulji, yundu nyubun daya bamanda yinduymbulu kambi-karingalu. Kaki yurra mayiji, yurra dajiwaka bamanji.” ");
INSERT INTO gvn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kanbal bama Johnundu kadan banabu dukul-damajinka. Yinyanguy bama tax money mujal-mujan bamandamun Governmentamu. Jana Johnundu babajin, “Teacher, nganjin wanjarrmalkuda?” ");
INSERT INTO gvn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Johnungku yalaman jananda, “Yurra kari money jirray muja bamandamun. Buban muja, yala Governmentanda daya. Kanbal kari ngaki.” ");
INSERT INTO gvn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kanbalda soldier-soldierangka Johnundu babajin, “Yala nganjin? Nganjin wanjarrmalda?” Johnungku yalaman, “Yurra bama kari wumbabuku nyuya, janandamun money maninka. Jananin kari yinyil-bunga, money maninka. Yurranga pay mana, wawurr-wawurrmakada.” ");
INSERT INTO gvn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bamangka John nyajin kuku yirrkanya, jana jana-karrajiku balkawan, yalaman, “Nyulu John nguba yinya bama Godundumun, Christ, nguba kari.” ");
INSERT INTO gvn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yala-yalaku Johnungku jananda yalamanda, “Ngayu yurranin banabu dukul-damal, yamba nyubun dingkar kudamundu kaday, nyulu jarra jirray ngaykunku. Ngayu jarra yala nyungunku. Yinyaynka ngayu murru-kaday nyungu dambal walnganka. Nyulu yurranin dukul-damal Godundumundu Wawubu. Yinyamun yurranga buyun-buyun kunbayda yala bayabu wayjujin. ");
INSERT INTO gvn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nyulu Christ yala bamangka mayi marra ready-bungal. Bamangka mayi marra mujal, wayjul, yinyamun dudal, dirka-bungal, baljingada yijarril, bananga ngabal. Yinyamun kaka yilbaji wuyarmun. Yinyamun kaka kunbay, nukalda. Christ yala yinya bama. Nyulu bama wubulku mujal, nyulu bama buyun yilbal bayanga, bama ngulkurr kujil nyungunji.” ");
INSERT INTO gvn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Johnungku bama milka-bakan buyun-buyun bawanka, nyulu Godumu kuku yirrkan walu-yindu walu-yindu. ");
INSERT INTO gvn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Johnungku yalarrku King Herod milka-bakan nyunguwunku buyun-buyunku. Herodangka jalbu Herodias wunan nyunguwumun yabajundumun. Nyulu King Herod buyun bajaku, nyulu yarbarrka buyun-daman baja, buyun-daman baja. ");
INSERT INTO gvn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nyulu jarra buyun-daman baja, John jailbakuda mumban. ");
INSERT INTO gvn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jana John jailba mumbanjiku, Johnungku bama wubulku banabu dukul-daman. Nyulu Jesus yalarrku banabu dukul-daman. Yala-yalaku Jesus praymalman, jiri heaven walngajin, yala door. ");
INSERT INTO gvn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Godumu Wawu dayirr bada-bada kadan Jesusanda yala bakamu. Heavenmun kuku yirrkan, yalaman, “Yundu ngayku kangkal ngulkurr. Ngayu yununku wawu jirray bajaku. Ngayu wawurr-wawurrmal yununku.” ");
INSERT INTO gvn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nyulu Jesusangka nyungu kuku jakalba dajil-dajin, nyulu yala-yala 30 years oldkuda. Jana bama balkawan, balu nyulu Jesus Josephamu kangkal, yamba nyulu Godumu kangkalkuda. Joseph, nyulu kangkal Helimu. ");
INSERT INTO gvn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helimu nganjan burri Matthat, Matthatamu nganjan burri Levi. Levimu nganjan burri Melchi, Melchimu nganjan burri Jannai, Jannaiyamu nganjan burri Joseph. ");
INSERT INTO gvn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josephamu nganjan burri Mattathias, Mattathiasamu nganjan burri Amos, Amosamu nganjan burri Nahum, Nahumamu nganjan burri Esli, Eslimu nganjan burri Naggai. ");
INSERT INTO gvn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggaimu nganjan burri Maath, Maathamu nganjan burri Mattathias, Mattathiasamu nganjan burri Semein, Semeinamu nganjan burri Josech, Josechamu nganjan burri Joda. ");
INSERT INTO gvn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodamu nganjan burri Joanan, Joananamu nganjan burri Rhesa, Rhesamu nganjan burri Zerubbabel, Zerubbabelamu nganjan burri Shealtiel, Shealtielamu nganjan burri Neri. ");
INSERT INTO gvn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerimu nganjan burri Melchi, Melchimu nganjan burri Addi, Addimu nganjan burri Cosam, Cosamamu nganjan burri Elmadam, Elmadamamu nganjan burri Er. ");
INSERT INTO gvn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eramu nganjan burri Joshua, Joshuamu nganjan burri Eliezer, Eliezeramu nganjan burri Jorim, Jorimamu nganjan burri Matthat, Matthatamu nganjan burri Levi, ");
INSERT INTO gvn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levimu nganjan burri Simeon, Simeonamu nganjan burri Judah, Judahmu nganjan burri Joseph, Josephamu nganjan burri Jonam, Jonamamu nganjan burri Eliakim. ");
INSERT INTO gvn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimamu nganjan burri Melea, Meleamu nganjan burri Menna, Mennamu nganjan burri Mattatha, Mattathamu nganjan burri Nathan, Nathanamu nganjan burri David. ");
INSERT INTO gvn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidamu nganjan burri Jesse, Jessemu nganjan burri Obed, Obedamu nganjan burri Boaz, Boazamu nganjan burri Salmon, Salmonamu nganjan burri Nahshon, ");
INSERT INTO gvn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshonamu nganjan burri Amminadab, Amminadabamu nganjan burri Admin, Adminamu nganjan burri Arni, Arnimu nganjan burri Hezron, Hezronamu nganjan burri Perez, Perezamu nganjan burri Judah. ");
INSERT INTO gvn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judahmu nganjan burri Jacob, Jacobamu nganjan burri Isaac, Isaacamu nganjan burri Abraham, Abrahamamu nganjan burri Terah, Terahmu nganjan burri Nahor, Nahoramu nganjan burri Serug. ");
INSERT INTO gvn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serugamu nganjan burri Reu, Reumu nganjan burri Peleg, Pelegamu nganjan burri Eber, Eberamu nganjan burri Shelah. ");
INSERT INTO gvn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelahamu nganjan burri Cainan, Cainanamu nganjan burri Arphaxad, Arphaxadamu nganjan burri Shem, Shemamu nganjan burri Noah, Noahmu nganjan burri Lamech. ");
INSERT INTO gvn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamechamu nganjan burri Methuselah, Methuselahmu nganjan burri Enoch, Enochamu nganjan burri Jared, Jaredamu nganjan burri Mahalaleel, Mahalaleelamu nganjan burri Cainan. ");
INSERT INTO gvn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanamu nganjan burri Enos, Enosamu nganjan burri Seth, Sethamu nganjan burri Adam, Adamamu nganjan, nyulu God. ");
INSERT INTO gvn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus nyulu wawubajamun Jordanmun kadan baja. Godumu Wawu dayirr nyunguwunbu dukurrbu bundan, nyungun bubungu jirrbu-jirrbungu juru-kulban. ");
INSERT INTO gvn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yinyaymba Dubungku Jesus milka-bakan buyun-damanka 40-daysmunku. Yamba Jesus Dubundu kari milka-janan. Jesusangka 40-daysmunku mayi kari nukan, nyulu dakwuymankuda. ");
INSERT INTO gvn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dubungku Jesusanda yalaman, “Kaki yundu Godumu kangkal, yundu mayi bread balka yalurrinmun kuljimun.” ");
INSERT INTO gvn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesusangka yalaman, “Godundumundu kabanda balkal, ‘Bama kari juranku bunday mayi nukanya, yamba Godungkuku jananin juranku kujil.’” ");
INSERT INTO gvn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wawu yinyamun Dubungku Jesus wangkar-wangkar bajaku wundin, nyungundu milbin yindu-yindu bubu yiringkurrku. ");
INSERT INTO gvn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Dubungku Jesusanda yalaman, “Kaki yundu nganya buyay-manil, ngayu yunun maja-bungal, junkurrji-bungal yinyaynka bubuku. Ngayu majaman yinyaynka bubuku. Kaki ngayu wawubu yinduymbu dajinka, ngayu dajilkuda. ");
INSERT INTO gvn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kaki yundu bungkubu janay jakalba ngaykundu, and nganya buyay-manil, ngayu yunundu dajilkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesusangka yalaman baja, “Godundumundu kabanda balkal, ‘Nganga Majaku Godku buyay-mana, nyungunkuku workmaka.’” ");
INSERT INTO gvn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wawu yinyamun Dubungku Jesus townbu Jerusalem wundin. Nyulu nyungun wangkar-wangkar jijinga Godundumunbu bayanba wundin. Yinyaymba nyulu Jesusanda yalaman, “Kaki yundu Godumu kangkal, yundu bada-bada bubungu jalamaka. ");
INSERT INTO gvn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Godundumundu kabanda balkal, ‘Godungku angel-angelanda balkal yunun ngulkurrduku kujil.’” ");
INSERT INTO gvn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dubungku yalaman baja, “Godundumundu kabanda balkal baja, ‘Jana yunun marabu jarra-kulbal, yunu jina kari yakajinka kuljinga.’” ");
INSERT INTO gvn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesusangka yalaman, “Godundumundu kabanda balkal, ‘Yurra kari bajaku Maja God milka-baka, buyun-damanka.’” ");
INSERT INTO gvn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nyulu Dubu kunbaynda Jesus milka-bakal-bakanya, nyulu nyungun bawanda. Yamba nyulu kadanka baja juma, milka-bakanka baja. ");
INSERT INTO gvn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wawu yinyamun Jesus bubunguku Galileeku dungan baja. Godundumundu Wawubu dayirrda nyungun junkurrji-bungan. Bamangka wubulduku nyungunku kuku nyajin yinyaymba bubungu. ");
INSERT INTO gvn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nyulu bama binal-bungan janawunbu churchmunbu wubulbuku. Jana wubulku nyungun buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yinyamun Jesus townbu Nazareth dungan. Yinya nyungu town, yinyay nyuluku yalbayman. Jana Jew-warra Saturdaymunbu janawunbu churchmunbu dungarin. Nyulu Jesus yalarrku dungan, yala nyulu Saturdaymundurr dungan. Yinyaymba nyulu dakan, Godumu kuku readim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jana nyungundu Godumu kaban dajin, kuku prophetangka Isaiahangka ngadiku balkan. Nyulu kaban walngan, kuku yalurrin warrmba-bungan, ");
INSERT INTO gvn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","yalaman, “Godumu Wawu ngaykundu bundayda. Nyulu nganya bamban Godumu kuku yirrkanka jananda yamba-yamba-karinda. Nyulu nganya yungan bamanda jailba bundandanya. Godungku janangan juma yungal. Nyulu nganya yungan jananda miyil-burranda, miyil walnganka. Nyulu nganya yungan bama yunganka majandamun buyunmun. ");
INSERT INTO gvn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nyulu nganya yungan bamanda balkanka, wanja-wanja Majangka Godungku bamanga wawu juran-bunganka, ngulkurr-bunganka buyun-buyunmun.” Jesusangka yinya kuku readim-bungan, Godundumun kabanmun. ");
INSERT INTO gvn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yinyamun nyulu kaban mulun-bungan baja, yinduymbu dajin, bundan baja. Jana bamangka wubulduku churchmunbu nyungun kunkun-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nyulu jananda balkanda, yalaman, “Isaiahngka yinya kuku ngadiku balkan, yamba nyiku yinya kuku manubajaman.” ");
INSERT INTO gvn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jana kungkurr-kadarin nyunguwunku kukuku, yalaman, “Yinya kuku ngulkurr bajaku.” Jana jana-karrajiku balkawan, babajin, “Nyulu kangkal yinyada Josephamu?” ");
INSERT INTO gvn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nyulu jananda balkan, “Yurra nguba ngaykundu balkal yala kanbalda balkal, ‘Doctor, yundu binalbi. Yundu yunduku ngulkurrmaka.’ Yurra nguba ngaykundu balkal baja, ‘Nganjin kuku nyajin yundu junjuy-junjuy miracle yalbay balkanya townbu Capernaum. Yundu yalarrku miracle balka yalaymba, nganjin nyajinka.’ ");
INSERT INTO gvn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngayu yurranda balkal, kaki bamangka prophetangka Godumu kuku yirrkay nyunguwunbuku townbuku, nyunguwunbu jawun-karranda, jana nyunguwunku kukuku wawu-karimal, kari milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jesusangka yalaman baja, “Yurra ngaykundu milka-janay. Ngadiku, Elijah jurankuna, jalbu-jalbu bunjil-bunjil wubul bajaku bubungu Israel. Yala-yalaku kaba kari kadan, 3½-yearsmunku. Bamanga mayi bubanman. ");
INSERT INTO gvn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yamba Godungku Elijah kari yungan jananda mayi dajinka. Kari, jana Godunku wawu-karimanya. Godungku Elijah bunjilanda nyubunyimba yinduymbu yungan bubungu Sidon, townbu Zerephath, yamba Jew-warranda kari.” ");
INSERT INTO gvn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jesusangka jananda balkan baja. Nyulu yalaman, “Nyubun prophet burri Elisha ngadiku bubungu Israel bundandan. Yala-yalaku bama Jew-warra wubul bajaku bajiji leprosymunji. Yamba nyulu prophetangka Elishangka jananin kari ngulkurr-bungan, jana Godunku wawu-karimanya. Nyubun bama bubumun yindumun Syriamun, burri Naaman. Elishangka nyungunku ngulkurr-bungan bajimun leprosymun, kanbal kari.” ");
INSERT INTO gvn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jana bamangka churchmunbu yinya kuku nyajin, jana kuli-kadarinkuda. ");
INSERT INTO gvn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jana Jesus karrban, townmun yiringkan. Jana nyungun wangkar-wangkar wuburrbu wundin, jananga town yinyaymba wuburrbu. Jana nyungun wangkar-wangkarmun ngamarmun yilbanka, yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kari. Nyulu jurrkijin, bamandarr dindarrdarrku dungan, jananin bawanda. ");
INSERT INTO gvn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wawu yinyamun Jesus townbu Capernaum, bubungu Galilee dungan. Yinyaymba nyulu bama binal-bungan Saturdaymunbu. ");
INSERT INTO gvn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jana wubulku kungkurr-kadarin, nyulu junkurr-murubuku binal-bunganya, yala majangka. ");
INSERT INTO gvn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nyubun bama yinyaymba churchmunbu, nyulu dubunji. Nyulu yaykarrku yirrkan, yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yundu Jesus, townmun Nazarethmun. Yundu wanjarrmal nganjinanda? Yundu nganjinan kuninka? Ngayu yununku binal. Yundu kukuji kadan Godundumun, dayirr, ngulkurr.” ");
INSERT INTO gvn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesusangka dubu murru-kangan. Nyulu yalaman dubundu, “Jankamakada. Wandi nyungundumun dukurrmun.” Dubungku dingkar bubungu yilban, yinyamun nyulu dingkarandamun dukurrmun wandinda. Nyulu dingkar kari bambay-bungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jana bama wubulku kungkurr-kadarin, jana-karrajiku balkawan, yalaman, “Ya, wanyu yinya kuku? Yanyungku dingkarangka dubu-dubundu balkal junkurr-murubuku, jana bamandamun wandarikuda.” ");
INSERT INTO gvn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bamangka wubulduku yinyaymba bubungu nyajin Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wawu yinyamun Jesusangka church bawan, Simonandamunbu bayanba dungan. Simonamu biwul bambay wunanan, wumbulman. Jana Jesusanda balkan nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nyulu nyungundu bedmunbu dungan, jakalba janan, yinyamun nyulu jalbu ngulkurr-bungan bambaymun fevermun. Nyulu jalbu jinbalku wandin, jananga mayi dajinda. ");
INSERT INTO gvn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yilay-yilayman, wungar daranda. Yala-yala jana bamangka jawun-karra bambay-bambay Jesusanda wundin ngulkurr-bunganka. Nyulu janangan marabu karrban, janangan wubulku ngulkurr-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dubu-dubu yalarrku bamandamun wandirin. Jana yaykarrku yirrkan, “Yundu Godumu kangkalkuda.” Jesusangka dubu-dubundu yalaman, “Jankamaka!” Jana binal Jesus nyulu Christ Godundumun. Yinyaynka nyulu dubu-dubu kirin balkanka baja. ");
INSERT INTO gvn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yalibalaku Jesus townmun wandin, bubungu jirrbu-jirrbungu dungan. Jana bamangka nyungun nubil-nubinkuda. Jana nyungun warrmba-bungan, jana nyungun bayanbaku wundinka baja. ");
INSERT INTO gvn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yamba nyulu yalaman, “Godungku nganya yungan, bamanda balkanka nyunguwunku kukuku ngulkurrku. Godungku nganya yungan, bama binal-bunganka Godungku nyungu bama ngulkurrduku kujinka bubungu. Ngayu dunganka townbu yindu-yinduymbu, bamanda yinya kuku yalarrku balkanka.” ");
INSERT INTO gvn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wawu yinyamun nyulu janangan bawan. Nyulu yiringkurrku dungan bubungu Judea. Yinyaymba nyulu Jew-warrandamunbu churchmunbu wubulbuku Godumu kuku yirrkan. ");
INSERT INTO gvn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesus yikinba jalunbu janjanan. Jalun burri Gennesaret. Yindu burri Galilee. Bama wubul murumarin nyungundu jukara, Godumu kuku nyajinka. ");
INSERT INTO gvn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesusangka boat jambul nyajin jukara. Bama yinyaynji boatji dunganya, kuyu maninya, sellim-bunganya. Jana kadarin baja, boat kulban jukara, bawaynda, makarr julurrinka. Yinya boat jambul Jesusangka nyajin. ");
INSERT INTO gvn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nyubun boat Simon Peteramu. Bama wubul murumarinya, room kari. Yinyaynka Jesus Simon Peterandamunbu boatbu dakan, Simon Peteranda babajin, “Yundu boat ngalkalba baja jukaramun yunga.” Yinyamun Jesus boatmunbu bundan, bamanda kuku yirrkan boatmunkuda. ");
INSERT INTO gvn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jesusangka kunbay-manin kuku yirrkanya, nyulu Simon Peteranda yalaman, “Yurra makarr bananga dajalimunbuku yilba, kuyu maninka.” ");
INSERT INTO gvn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yamba Simon Peterangka nyungundu yalaman, “Maja, nganjin all night makarrji kuyungu dungarin. Kuyu yamba-kari bajaku. Yamba ngayu yunu kuku wukurril, nganjin makarr yilbal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jana makarr yilban, kuyu wubul bajaku manin, balu makarr dumbarrijinkuda. ");
INSERT INTO gvn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jana jinbal marabu kunjan bama yinduymbu boatbu, jana kadarinka, mara dajinka. Jana kadarin, boat jambulku kuyubu jakal-bungan, balu boat janji-maninkuda. ");
INSERT INTO gvn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nyulu Simon Peterangka kuyu wubul nyajin boatbu, nyulu bungkubu janan jakalba Jesusanda. Nyulu yalaman, “Nganya bawa, Maja. Ngayu murru-kaday ngaykuwunku buyun-buyunku.” ");
INSERT INTO gvn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jana Peter kungkurr-kadarin yinyaynka kuyuku jirraynka jana manin. ");
INSERT INTO gvn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","James bula John yalarrku kungkurr-kadan yinyaynka kuyuku jirraynka. Bula Petermu jawun-bulal, kangkal-bulal Zebedeemu. Yamba Jesusangka Peteranda yalaman, “Kari yinyilmaka. Wawu nyikumun yurra bama mujal Godunku yala yurra kuyu mujan.” ");
INSERT INTO gvn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yinyamun jana boat jambul kulban jukaranga, wubulku yinyaymba bawan, Jesus wukurrin. ");
INSERT INTO gvn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus nyubunyimba townbu bundandan, nyubun dingkar kadan, bajiji, leprosymunji. Nyulu Jesus nyajin, nyulu bungkubu janan jakalba Jesusandaku, yalaman, “Maja, yundu junkurrji. Kaki yundu wawubu, yundu ngayku baji kida.” ");
INSERT INTO gvn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesusangka nyungun karrban, yalaman, “Ngayu wawubu yunun ngulkurr-bunganka. Dayirrmakada.” Bajibu leprosymundu dingkar jinbalku bawankuda. ");
INSERT INTO gvn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesusangka dingkaranda yalaman, “Milka-janay! Yundu yinya kari balka bamanda. Yundu junkayku dungay yinyayanda priestanda Godundumunbu bayanba. Nyungundu babajika nyulu yunun biku-nyajinka. Junjuy Godundu daya, yala Mosesangka ngadiku balkan, bamanda milbinka yundu dayirrmanda.” ");
INSERT INTO gvn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yamba bamangka yinya kuku ngulkurr Jesusanka yiringkurrku balkan. Yinyaynka bama wubulku nyungundu kadarin, nyungu kuku nyajinka, bambaymun ngulkurrmanka. ");
INSERT INTO gvn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yamba Jesus bubungu jirrbu-jirrbungu dungan baja, Godunji balkawanka, praymanka. ");
INSERT INTO gvn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wawu yinyamun Jesusangka bama binal-bungal-bungan bayanba, kanbal Pharisee-warra and teacher-teacher lawmunku yalarrku yinyaymba bundandarin. Kanbal bubumun Galileemun, kanbal bubumun Judeamun, kanbal townmun Jerusalemmun. Godumu junkurr Jesusanjiku bundandan, bambay-bambay ngulkurr-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kanbalda dingkar-dingkarangka nyubun dingkar waba-buyun jarra-kulban, wunananya bilangkurrbu. Jana nyungun jakalba Jesusanda wunay-maninyaku, bayanba. ");
INSERT INTO gvn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yamba jana murruji walan, bama wubul bajaku. Yinyaynka jana nyungun wangkar-wangkar jijinga jarra-kulban, jijinga bulkaji balkan, yinya waba-buyun bulkajimundurr bada walay-manin. Bama wubul kananga Jesusanji. Dingkar-dingkarangka nyungun waba-buyun bada-bada walay-manin wunananya bilangkurrbu, jakalba Jesusanda bada-bada-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesusangka nyajin jana nyungun trustim-bunganya, nyulu waba-buyunyundu yalaman, “Ngayku jawun, yunu buyun-buyun kidajinda. Ngayu yunu wawu dayirr-bungalda.” ");
INSERT INTO gvn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yinyaynka jana Pharisee-warra and teacher-teacher lawmunku, jana jana-karrajiku balkawan, jana babajin, “Wanju yanyu dingkar? Wanyurrinku nyulu yanyu kuku balkal-balkal? Nyulu yala Godmanka. Godungkuku bamanga wawu dayirr-bungalkuda, ngana bamangka kari!” ");
INSERT INTO gvn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesusangka jibabu nyajin wanyu jana dukulbu kujil-kujin. Nyulu jananda babajin, “Yurra wanyurrinku yanyu milkabu manil-manil? ");
INSERT INTO gvn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngayu nyungundu balkan, ‘Ngayu yunu wawu dayirr-bungal.’ Yamba yurra yurra-karrajiku yalaman, ‘Nguba, nguba kari. Nyulu still wunanay, bambaynji.’ Yala, ngayu nyungundu balkalda, ‘Dakada, jinabu dungayda.’ ");
INSERT INTO gvn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yinyamundu ngayu yurranda milbil ngayu yinya bama Godundumun, bubungu kadan. Yinyamundu milbil ngayu junkurrji, wawu dayirr-bunganka.” Yinyamun nyulu waba-buyunyundu yalamanda, “Dakada, bilangkurr mana, bayanbaku dungayda.” ");
INSERT INTO gvn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nyulu waba-buyun jinbalku dakan, bilangkurr manin, bayanbaku dungan, Godkuda buyay-manil-manin. ");
INSERT INTO gvn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jana wubulku kungkurr-kadarin, yinyilmarinda. Jana God buyay-manin, yalaman, “Ngana junjuy-junjuy ngulkurr bajaku nyajinkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wawu yinyamun Jesus ngalkalba dungan. Nyulu dungan-dungan, nyulu nyubun dingkar burri Levi nyajin bundandanya nyunguwunbu officemunbu. Nyulu Levingka tax money mujal-mujan governmentamu. Jesusangka Levinda yalaman, “Nganya wukurrika.” ");
INSERT INTO gvn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi dakan, wubulku bawan yinyaymba, Jesuskuda wukurrinda. ");
INSERT INTO gvn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yinyamun jana Levindamunbu bayanba dungarin. Nyulu Levingka mayi jirray-bungan nyunguwunbu bayanba Jesusanka. Bama wubul kadarin mayinga. Kanbalda yinyarrinyangka tax money mujal-mujan governmentamu. ");
INSERT INTO gvn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kanbalda Pharisee-warrangka and teacher-teacherangka Jesusandamunbu jawun-karranda babajin, “Wanyurrinku yurra nukaji jananji, bamanji buyun-buyunyunji, bamanji yinyaywunji money mujal-mujal governmentamu?” ");
INSERT INTO gvn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesusangka yinya kuku nyajin. Nyulu yalaman, “Bama yinyarrin ngulkurr, doctor jananda kari kaday. Yinyarrinku bama bambay, janandaku yinyarrinyandaku doctor kaday. ");
INSERT INTO gvn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngayu kari kadan bama ngulkurr kunjanka. Kari, ngayu kadan bama buyun kunjanka, jana buyun-buyunmun jurrkijinka.” ");
INSERT INTO gvn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kanbalda bamangka Jesusanda yalaman, “Jana Pharisee-warrangka, Johnundumundu jawun-karrangka, jana mayi jururr-jururr kari nukal Godunku, nyungundu praymanka baja. Wanyurrinku yunuwundu jawun-karrangka mayi kari bawal Godunku?” ");
INSERT INTO gvn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesusangka yalaman, “Kari, ngayu yala bridegroom. Bama weddingba mayi kari bawal, bridegroom jananji bundandanya yinyay. ");
INSERT INTO gvn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yamba juma jana bridegroom karrbal, bamandamun manil, ngaykuwundu jawun-karrangka mayida bawal.” ");
INSERT INTO gvn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesusangka jananda yanyu kuku balkan, “Kambi mukul nguba kankaji. Bamangka kambi jirakal kari yakal, kambi mukul ngulkurr-bunganka. Jana kambi mukul yindu yakal. Kaki jana kambi jirakal yakal, jana kambi jirakal buyun-damalkuda. Kambi jambul walu-yindu, nyubun mukul, nyubun jirakal. ");
INSERT INTO gvn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ngana kurmun yulbanmun balkal, yira wine nyangarrinka. Bamangka yira wine jirakal kari nyangarril kurmunbu mukulbu. Kaki nyulu kurmunbu mukulbu nyangarril, yira jila kaday, kurmun mukul dalkay. Yira wine nyangarrijida bubungu. ");
INSERT INTO gvn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kari. Bamangka yira wine jirakal nyangarril kurmunbu jirakalba. Bula jambulku ngulkurr. ");
INSERT INTO gvn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wawu wine mukul nukanyamun, bamangka wawu kari wine jirakal nukanka. Yira wine mukul jarra ngulkurr jirakalka.” ");
INSERT INTO gvn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Saturdaymunbu jana Jesus jinabu paddockmundurr dungan-dungarin, mayiburr wheatmundurr. Nyungu jawun-karra 12-bala dakwuymarin. Jana mayi wheat mujan, marabu nyurrban, yulban walngajinka, mayi nukan. ");
INSERT INTO gvn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jana Pharisee-warrangka yinya nyajin, yalaman, “Nyiku Saturday. Nganandamundu lawmundu ngananin kiril workmanijinka Saturdaymundurr. Yurra yinya mayi kari mujanyaku Saturdaymunbu.” ");
INSERT INTO gvn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesusangka yalaman, “Yurra nguba Godumu kaban kariku nyajin. Jana David ngadiku dakwuynji bundandarin, jana wanjarrman? ");
INSERT INTO gvn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David Godundumunbu bayanba walan, mayi bread nukan. Nyulu mayi bread wanyamba nukan? Yinya bread bamangka Godundu dajin. Nyulu yinya bread nukan, jawun-karranda dajinkuda. Lawmundu yinya yalarrku kirin, yinya bread nukanka. Jana priest-warrangkaku yinya bread nukanyaku.” ");
INSERT INTO gvn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesusangka yalamanda, “Ngayu yaba wubulbuku. Ngayu maja Saturdaymunku.” ");
INSERT INTO gvn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yinduymbu Saturdaymunbu Jesus Jew-warrandamunbu churchmunbu dungan, bama binal-bungan. Nyubun bama yinyaymba, nyungu mara wulan. ");
INSERT INTO gvn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kanbal teacher-teacher lawmunku and Pharisee-warra, jana Jesus nyuyanka buyun-damanka. Yinyaynka jana nyungun mumbarabuku nyajin, nyulu nguba dingkar ngulkurr-bungal Saturdaynga, nguba kari. ");
INSERT INTO gvn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus binal wanyu jana milkabu kujil-kujin. Nyulu dingkaranda mara-wulanyamunbu yalaman, “Kaday, jakalba janay.” Dingkar jakalba kadan, janan. ");
INSERT INTO gvn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesusangka jananda balkanda, “Wanjanguy work ngana doim-bungal Saturdaymunbu? Nganandamundu lawbu wanjarr kiril? Ngana bama ngulkurr-bungal or buyun-damal Saturdaymunbu? Jananin juran-bungal or wulay-manil?” ");
INSERT INTO gvn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nyulu jananin walu-wukurrin, yinyamun nyulu dingkaranda mara-wulanyamunbu yalaman, “Yunu mara yunga.” Nyulu dingkarangka mara yungan, mara nyungu ngulkurrmanda. ");
INSERT INTO gvn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jana Pharisee-warra, teacher-teacher lawmunku, jana kuli-kadarin. Jana jana-karrajiku balkawan, nyajinka wanjarrmanka Jesus buyun-damanka. ");
INSERT INTO gvn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yala-yalaku Jesus wuburrbu dakan, Nganjananji balkawanka, miyil nandajinka. Nyulu wujurrdurr Godunji balkawan. ");
INSERT INTO gvn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mudu-wayjun, nyulu nyungu jawun-karra nyungundu kunjan, 12-bala wangkanin, apostle-bungan, yunganka workmanijinka. ");
INSERT INTO gvn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jana 12-bala burri yalaku: Simon, nyungun Jesusangka yindu burri dalkin, Peter. Nyungu yabaju Andrew, James bula John, Philip bula Bartholomew. ");
INSERT INTO gvn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew bula Thomas, James, nyungu nganjan burri Alphaeus, yindu dingkar burri Simon, jana nyungun yindu burri dalkin Patriot. ");
INSERT INTO gvn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, nyungu nganjan James, yindu Judas, nyulu bubumun Iscariotmun. Nyulu juma Jesus mambarrin buliman-bulimananda. ");
INSERT INTO gvn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus wuburrmun kadan apostle-karranji. Nyulu balaymba janan jawun-karranji wubuliynji. Bama wubul bajaku yinyaymba, bubumun Judeamun, townmun Jerusalemmun, townmun Tyremun, townmun Sidonmun. Bula town Tyre and Sidon yubaku jalunbu. ");
INSERT INTO gvn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jana kadarin nyungu kuku nyajinka, ngulkurrmanka bambaymun. Kanbal kadarin dubunji. Jesusangka yinyarrin dubu-dubu kangan janandamun. ");
INSERT INTO gvn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bamangka wubulduku nyungun karrbanka, jana ngulkurrmanka bambaymun. Nyulu junkurrdu jananin wubulku ngulkurr-bungan bambaymun. ");
INSERT INTO gvn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesusangka nyungu bama nyajin, yalaman, “Kaki yurra wawu Godungku yurranga wawu dayirr-bunganka, Godungku yurranin ngulkurrduku kujilkuda. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kaki yurra dakwuyku bundanday, Godungku yurranin yanji-bungal. Yurra wawurr-wawurrmanijida. Kaki yurra milka-bujarmal, juma yurra yajarrijida. Yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ngayu bamanga wubulbuku yaba. Kaki yurra ngaykunku wawu jirray, bama yurranka wawu kari bajaku. Jana yurranga kuli dajil ngaykunku, yurranin bawalkuda. Jana balkal, ‘Yurra buyun bajaku,’ ngaykunku. Yurra kari milka-bujarmakada. Yinyamun yurra wawurr-wawurrmanijida. ");
INSERT INTO gvn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yinyaynka yurra wawurr-wawurrmaka, wawurr-wawurrku wuri. Godungku yinyaynka bayan ngulkurr kujil yurranga heavenba. Ngadiku jananga jawun-karra yalarrku bamanka prophet-prophetanka wawu kari. ");
INSERT INTO gvn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Yurra kanbal moneyka jumbunku bundanday, yamba yurranda juma kuli jirray kaday. Yurra easy-balaku bundandan bubungu, money manin-manin. ");
INSERT INTO gvn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kaki yurra yanji-yanjiku bundandari and mayika jumbun-jumbunku bundandari, kuli jirray yurranda kaday. Yurra juma dakwuy-dakwuyku bundarida. Kaki yurra bunjay-muruku bundari, kuli jirray yurranda kadayda. Yurra juma milka-bujarmal. ");
INSERT INTO gvn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kaki bama wubulku kuku ngulkurr balkaway yurranka, kuli jirray kaday yurranda. Ngadiku jananga jawun-karra yalarrku kuku ngulkurr balkawan prophet-prophetanka buyunyunku. Kuli jirray yalarrku jananda kadan.” ");
INSERT INTO gvn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesusangka yalaman baja, “Yurra nganya kuku nyaka. Bamanka buyunyunku wawumaka. Kaki kanbal yurranka wawu kari, yurra jananga kari kuli daya baja, jananga kuku ngulkurrku daya baja. ");
INSERT INTO gvn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kaki bamangka yurranin yukil, yurra jananin kari yuki baja. Kuku ngulkurr balka jananda. Kaki bamangka yurranga kuli dajil, Godundu balka jananka, praymaka jananka. ");
INSERT INTO gvn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kaki bamangka yunun kunilkuda, kari kuni baja nyungun. Kari nyungunku wawu-karimaka. Kaki bamangka yunu kambi ngakil, yundu nyungundu yunu coat daya baja. ");
INSERT INTO gvn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kaki bamangka yunundu babaji junjuynku, kari jumbunmaka. Jawaymakarrku. Dayada. Kaki bamangka junjuy manil yunundumun, kari babaji baja yinyaynka junjuynku. ");
INSERT INTO gvn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kaki yundu wawu bama yununku wawu jirray, yundu jananka yalarrku wawumaka. Kaki yundu wawu jana yunundu kuku ngulkurr dajinka, yundu yalarrku jananda kuku ngulkurr daya. Kaki yundu wawu bama ngulkurrmanka yununku, jananka ngulkurrmaka. ");
INSERT INTO gvn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Yunu jawun-karra yununku wawu jirray. Kaki yundu janankaku wawu jirray, God yununku kari wawurr-wawurrmal. Bama buyun yalarrku janawunkuku jawun-karrankaku wawu jirray. Yamba yundu kari yalamaka. Yundu bamanka wubulkuku wawumaka, kari jawun-karrankaku. ");
INSERT INTO gvn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kanbalda bamangka ngulkurrduku dajil yunundu. Kaki yundu janandaku dajil baja, God kari wawurr-wawurrmal yununku. Bamangka buyunyungku yalaku dajil baja, yamba yurra bamanda wubulimbaku ngulkurrduku daya. ");
INSERT INTO gvn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kanbalda bamangka yunundu nguba junjuy dajil. Kaki yundu janandaku yinya junjuy dajil baja, God kari wawurr-wawurrmal yununku. Bamangka buyundu yalaku dajil. Yamba yundu bamanda wubuliymbaku daya, kari janandaku yinyanguymbuku yunundu dajin. ");
INSERT INTO gvn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kari. Kanbalda bamangka kuli dajil yurranda, yamba yurra jananka wawumaka. Kaki jana yurranda kaday, junjuy-junjuy maninka, dayada. Kaki jana kari dajil baja, yinya yalada, yurra jananka still wawumaka. Bamanka buyunyunku ngulkurrmaka. Yinyamun yundu kangkalkuda Godumu junkurrjimu. God yunu nganjankuda. Nyulu ngulkurrmal bamanka buyunyunku, bamanka nyungunku wawu kari. ");
INSERT INTO gvn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yurra manun-manunmaka bamanka yala yurranga God manun-manunmal yurranka.” ");
INSERT INTO gvn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesusangka yalaman baja, “Yundu nguba kuku buyun nyajil nyubunyinka bamanka. Kari jinbalku warri, nyungun nyuyanka yinyaynka kukuku. Kaki yundu yindu bama kari nyuyal, Godungku yunun yalarrku kari nyuyal. Kaki bamangka yunun buyun-damal, yundu jananin kari buyun-dama baja. Bawada. Kaki yundu janawunku buyun-buyunku milka-wulay, God yunuwunku buyun-buyunku milka-wulay. ");
INSERT INTO gvn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yundu bamanda wubulimbaku daya, yinyamun Godungku yunundu dajil. Nyulu yunundu jawaynjaku dajil, yalbayku. Kaki yundu bubanka, nyulu yunundu yalbayku dajil. Kaki yundu bubanku jarra dajil, Godungku yalarrku buban dajil yunundu. Kaki yundu jawaynjaku dajil, Godungku yalarrku jawaynjaku dajil yunundu.” ");
INSERT INTO gvn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesusangka jananda yanyu kuku balkan, “Kaki miyil-burrangka yindu miyil-burra juru-kulbanka, bula jambulku jankungu daray. ");
INSERT INTO gvn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Karrkay schoolbu binal kari, nyulu yala kari nyungu teacher. Yamba yinya karrkay binalmal teacherandamun. Juma nyulu school kunbay, nyulu yala nyungu teacher, binal bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Buyun-buyun yala juku yulal. Yundu bamandamunbu yinduymbu miyilba juku karrkay wanyurrinku nyajil, yamba yundu yunuwunbukulu miyilba juku yalbay kari nyajil? ");
INSERT INTO gvn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kaki juku jirray yunuwunbu miyilba, yundu juku karrkay murruji nyajil bamanda yinduymbu miyilba. Kaki yundu yalaku bunday, yundu bulu-duray bajaku. Yundu wawu yindu-yindu helpim-bunganka buyunmun jurrkijinka, yamba yundu yalarrku buyun. Jakalba yundu juku jirray walnga miyilmun yunundumun. Yinyamun yundu ngulkurrduku nyajil, juku karrkay walnganka bamandamun yinduyndumun miyilmun.” ");
INSERT INTO gvn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesusangka yanyuynku kukuku yalarrku binal-bungan. Nyulu yalaman, “Nguba juku mayiji. Mayi buyun kari balkaji jukungu ngulkurrbu. Yalarrku mayi ngulkurr kari balkaji jukungu buyunbu. ");
INSERT INTO gvn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yundu jukuku wanjarrku binal? Yundu jukuku binalmal nyunguwunku mayika. Yundu mayi kurruy jukumun milimun kari manil. ");
INSERT INTO gvn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yundu yalarrku bamanka yalaku binalmal. Kaki bamanga wawu ngulkurr, nyulu ngulkurrku bunday. Kaki nyungu wawu buyun, nyulu buyunku bunday. Nyulu kuku balkal yalaku nyunguwunduku wawubu. Kaki wawu ngulkurr, nyungu kuku ngulkurr. Kaki wawu buyun, nyungu kuku buyunkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesusangka yalaman baja, “Wanyurrinku yurra nganya maja bambal, yamba yurra ngayku kuku kari wukurril? ");
INSERT INTO gvn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kaki bama ngaykundu kaday, and nganya kuku nyajil, and wukurril, nyulu yala yanyu. ");
INSERT INTO gvn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nyulu yala nyubunyinja dingkarangka bayan ngaran. Nyulu bubu bakan bada kulji-kuljinga. Yinyamun nyulu bayan kulji-kuljinga ngaran, dandi bajaku. Jalungkarr warrin wawubajanga, bayan kari bulngan. Bayan yinya kari dumbarrin, dandi bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yinduynju bamangka ngayku kuku nyajil, yamba nyulu kari bajaku wukurril. Nyulu yala bamangka bayan ngaran jukara. Jalungkarr warrin, jalungkarrangka bubu bada-baja bayanba bakan, yinyamundu bayan daray-manin. Bayan darankuda, numburr yalbay bajaku.” ");
INSERT INTO gvn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesusangka kunbay-manin yinya kuku balkanya bamanda, nyulu townbu Capernaum dungan. ");
INSERT INTO gvn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yinyaymba maja soldiernka bundandan. Nyungu workingman bambay jirray bajaku, wulan-wulaynda. Nyulu maja nyunguwunku workingmananka wawu jirray. ");
INSERT INTO gvn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nyulu majangka kuku nyajin Jesusanka, nyulu binga-binga bama Jew-warra Jesusanda yungan, babajinka nyungu workingman ngulkurr-bunganka bambaymun. ");
INSERT INTO gvn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jana binga-binga Jesusanda kadarin, nyungundu yalaman, “Yinya maja soldiernka, nyulu ngulkurr bajaku. Nyungun helpim-bunga. ");
INSERT INTO gvn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nyulu ngananka bamanka Jew-warranka wawu jirray. Nyulu nganjinanga church ngaran.” ");
INSERT INTO gvn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yala, Jesus jananji dungan. Jana yubaku majandamunbu bayanba kadarin, nyulu majangka jawun-karra kukuji Jesusanda yungan. Majangka kuku yungan yalaku: “Maja, yundu kari ngaykuwunbu bayanba wala. Ngayu murru-kaday, ngayu buyun bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ngayu jarra yala yununku, yinyaynka ngayu murru-kaday yunundu kadanka. Yundu kukubuku balkal, ngayku bama ngulkurrmalda. ");
INSERT INTO gvn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngayu yala yundu, majanji. Ngayu maja soldier-soldiernka. Ngayu nyubunyundu yinyaymba balkal dunganka, nyulu dungaykuda. Ngayu nyungundu yinyayanda yinduymbu balkal kadanka, nyulu kadaykuda. Ngayu ngaykuwunbu workingmananda balkal, jana yinya doim-bungalkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus kungkurr-kadan yinyaynka kukuku. Nyulu wawurr-wawurrman. Nyulu bamanda balkan nyungun juru-wukurril-wukurrin, “Ngayu yurranda balkal, nyulu yinya bama Jew kari. Nyulu Gentile, yamba nyulu nganya trustim-bungalarrku. Jana Jew-warrangka nganya yala kari trustim-bungal.” ");
INSERT INTO gvn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yinyamun jana kukuji majandamunbu bayanbaku dungarin baja. Yinyaymba jana majamu workingman nyajin, nyulu ngulkurrmankuda. ");
INSERT INTO gvn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wawu yinyamun Jesus townbu Nain dungan. Nyungu jawun-karra, bama wubul nyungunji dungarin. ");
INSERT INTO gvn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nyulu gateba townbu kadan, nyulu bama nyajin, yarkin jarra-kulbal-kulbanya yulalba. Bamangka wubuldu janangan wukurrin. Nyulu yarkin warruku. Nyulu jalbumu bunjilamu nyubunku kangkal. ");
INSERT INTO gvn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nyulu ngamu banbadin. Jesusangka nyungun nyajin, jiba-badin nyungunku. Nyulu nyungundu yalaman, “Kari badi.” ");
INSERT INTO gvn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yinyamun nyulu yulalba dungan, marabu karrban. Jana dingkarangka yulal jarra-kulbal-kulban, jana janan. Jesusangka yarkinanda yalaman, “Warru, ngayu yunundu balkal, wandida.” ");
INSERT INTO gvn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nyulu yarkin juranmaynda, bundankuda, balkawankuda. Jesusangka warrundumunbu ngamundu yalaman, “Yanyada yunu kangkal.” ");
INSERT INTO gvn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bamangka yinya nyajin, jana kungkurr-kadarin, yinyilmarin. Jana God buyay-manin, yalaman, “Prophet jirray ngananda kadan. Nyulu God kadan, nyungu bama juran-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jana yinya kuku Jesusanka yiringkurrku balkan bubungu Judea. ");
INSERT INTO gvn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John the Baptistandamundu jawun-karrangka yinya kuku Jesusanka balkan Johnundu. ");
INSERT INTO gvn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Johnungku jambul kunjan, bulanin yunganka Majanda Jesusanda, babajinka, “Yunduda dingkar Johnungku balkan kadanka or yindu? Nganjin nguba yindu kujil baja?” ");
INSERT INTO gvn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bula Jesusanda kadan, nyungundu yalaman, “John the Baptistangka ngalinin yungan. Nyulu ngalinin yungan babajinka, ‘Yunduda yinya dingkar Johnungku balkan kadanka or yindu? Nganjin nguba yindu kujil baja?’” ");
INSERT INTO gvn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yala-yala Jesusangka bama wubul ngulkurr-bungan bambaymun. Nyulu dubu-dubu kangan bamandamun dukurrmun, nyulu miyil-burra wubul ngulkurr-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesusangka bulanda Johnundumunbu jawun-karranda yalaman, “Yubal Johnunduku dungay baja, nyungundu balka wanyu yubal nyajinkuda. Nyungundu balka, yinyarrin miyil-burra, jana miyilda nyajilkuda. Yalkay-yalkayalu ngulkurrku dungan-dungarikuda. Jana bajiji leprosymunji, jananga yulban dayirrda. Jana yinyanguy bama milka-karilu, milkajimalda. Jana yarkin-yarkin, ngayu jananin juran-bungan baja. Ngayu kuku ngulkurr Godundumun yirrkan-yirrkay bamanda money-karinda, poor-balanda. ");
INSERT INTO gvn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bamangka nguba nganya believeim-bungal Godundumun kadanya. Nyulu nguba nganya kari warmbil. Nyulu wawurr-wawurrmanijida. Yubal Johnundu yinya kuku balka.” ");
INSERT INTO gvn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Johnumu jawun-karra dungan baja. Jesusangka Johnunku balkanda bamanda wubulbuku nyungundu murumarin. Nyulu yalaman, “Yurra ngadiku wanyurrimbu bubungu jirrbu-jirrbungu dungarin, John nyajinka? Kuda binalmanka nyungunku? Nyulu wawu-kima kari, yala kari jikan bulngan-bulngaji muyara. ");
INSERT INTO gvn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yurra wanyurrimbu dungan? Nguba bama nyajinka kambiji flash-balaji. Kari. Bama kambiji flash-balaji, jana bayanba yalbaymba ngulkurrbu bundanday. John yala kari. ");
INSERT INTO gvn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yurra wanyurrimbu dungarin? Bama prophet nyajinka, balkal-balkanya kuku ngulkurr Godundumun. Yamba John jarra jirray prophet-prophetanka yindu-yinduynku. ");
INSERT INTO gvn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngadiku bamangka nyubunyinja kuku manin Godundumun. Yinya kuku Johnunku. Nyulu bamangka Godumu kuku kabanba balkan. Nyulu balkan, ‘Godungku yalaman, “Nyaka. Ngayu bama kukuji yungal, bamanda balkanka yundu kadanyamunkuda. Nyulu kukujingka bama ready-bungal yununku.” ’” ");
INSERT INTO gvn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesusangka yalaman, “Ngayu yurranda balkal, John, nyulu jarra jirray bamanka wubulkuku yindu-yinduynku jakalbaku ngaykunku. Kaki bamangka nganya wukurril, nyulu jarra jirray Johnunku, nyulu Godumu jawunmanya. Godungku nyungu jawun-karra ngulkurrduku kujil. Godumu jawun nyubun nguba jarra buban kanbalka, yamba nyulu jarra jirray Johnunku.” Bamangka wubulduku Jesus nyajin yinya kuku balkanya. ");
INSERT INTO gvn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jakalbaku jana bamangka wubulduku Johnumu kuku nyajin, jana God yulmbarrin. God dayirr bajaku. Jana nyungundu milka-janan, jurrkijin buyun-buyunmun. Jana bamangka money mujan Governmentamu, jana yalarrku jurrkijin, God yulmbarrin. Yinyaynka jana ngadiku Johnundu dungarin, nyulu jananin banabu dukul-daman, baptiseim-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yamba jana Pharisee-warra, jana teacher-teacher lawmunku, jana wawu kari jurrkijinka Godundu. Jana wawu-kariman Johnundumunku kukuku Godunku. Yinyaynka jana kari Johnundu dungarin, nyulu jananin banabu dukul-damanka, baptiseim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesusangka yalaman baja, “Yurra bama wubulku, yurra yala wanju? ");
INSERT INTO gvn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yurra yala kaykay-kaykay ngalkalba kinkan-kinkay. Jana kaykay-kaykayanda yindu-yinduymbu yalaman, ‘Nganjin ngujungu wedding wurin-wurin. Wumbaku singmanijin, yurra kari kadarin wurinka. Nganjin ngujungu funeral wurin-wurin. Wumbaku badin, yurra kari kadarin, badirinka nganjinanji.’ Yurra yala jana kaykay-kaykay. Jana kari muruku wuririnka. ");
INSERT INTO gvn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Johnungku mayi kari nukan, Godunji balkawanka baja. Nyulu wine kari nukan. Yinyaynka yurra yalaman, ‘Dubu nyungundu dukurrbu walan.’ ");
INSERT INTO gvn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngayu yaba bamanga wubulbuku, kadanda. Ngayu yala yindu-yindu, mayinga, bananga nukal-nukaji. Yamba yurra ngaykunku yalamal, ‘Yinya dingkar nyaka. Nyulu jumbun mayika, nyulu kamu-kamu-baka. Nyulu jawun bamanga buyun-buyunbu, jananga yinyarrinyaymba bamanga money mujal-mujal Governmentamu.’ ");
INSERT INTO gvn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yamba Godumu bama binalkuda. Godungku kuku manubajaku milkabu wukurril. Kaki bama yinyanda kukungu milka-janay, jana ngulkurrmal.” Jesusangka yinya kuku balkan bamanda wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nyubunyinja bamangka Phariseengka Jesusanda babajin, “Yundu ngaykuwunbu bayanba kaday mayika?” Jesus nyungunji dungan, bayanba walan, bundan, nukanka. ");
INSERT INTO gvn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yinyaymba townbu nyubun jalbu buyun bundandan. Nyulu jalbungku kuku nyajin Jesusangka mayi nukal-nukanya bayanba Phariseendamunbu. Yinyaynka nyulu jila mini-mini, scent manin, bottleji wundin. ");
INSERT INTO gvn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesus wali-wunanan. Jalbu kudamundu Jesusanda janan Jesusandamunbu jinanga. Nyulu banbadin, nyungundumun milbal daran Jesusanda jinanga. Nyulu Jesusamu jina marral-bungan nyunguwundu mungkabu. Yinyamun nyulu Jesusamu jina kissim-bungan, jila mini-mini jinanga nyangarrin. ");
INSERT INTO gvn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nyulu Phariseengka Simonangka yinya nyajin, nyulu nyuluku yalaman, “Jesus manubajaku prophetmanyaku, nyulu binalmanyaku yanyunku jalbunku nyungun karrbanya. Nyulu binalmanyaku, nyulu jalbu buyunku bundanday.” ");
INSERT INTO gvn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesusangka Simonanda yalaman, “Ngayu junjuy balkanka yunundu, Simon.” Simonangka yalaman, “Yundu wanyu balkanka ngaykundu?” ");
INSERT INTO gvn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesusangka yanyu story balkan nyungundu. “Nyubunyinja dingkarangka bamanda jambulimba money dajin, lendim-bungan. Nyulu nyubunyundu 500 dollars lendim-bungan. Yinduymbu nyulu 50 dollars lendim-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yinya dingkar juma bulanda dungan, babajin, ‘Yubal ngayku money daya baja?’ Yamba bula murruji payim-bungan baja. Money yamba-karikuda. Nyulu dingkar jiba-badiman bulanka, yalamanda, ‘Yalada, yubal kari payim-bunga baja.’ Nyulu bulanga kaban dumbarrin moneyka payim-bunganka.” Jesusangka Simonanda babajinda, “Simon, wanjaku yinyarrin wawu jirray nyungunku? Nyulu 500 dollars manin nyungundumun or nyulu 50 dollars manin nyungundumun?” ");
INSERT INTO gvn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simonangka yalaman, “Nguba yinyangkakula 500 dollarsku manin, dingkarangka nyungundu jarra jirray dajinya.” Jesusangka yalaman, “Yuwu, nyulukudabi.” ");
INSERT INTO gvn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yinyamun Jesus jalbundu jurrkijin baja, Simonanda balkan, “Yundu yanyu jalbu nyaka. Ngayu yunuwunbu bayanba walan, yamba yundu ngaykundu bana kari dajin jina julurrijinka. Ngana Jew-warrangka yalaku, bana dajinya jina julurrijinka. Kari, yinyangka jalbungku nganya jina julurrin milbalda, marral-bungan baja nyunguwundu mungkabu. ");
INSERT INTO gvn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yundu nganya kari yulmbarrin kissmundu. Ngana Jew-warrangka yalaku bama yindu-yindu yulmbarrinya. Yamba yinyangka jalbungku nganya jina jururr-jururr kissim-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yundu olive oil kari dajin ngaykuwunku dukulku, yamba yinyangka jalbungku jila scent mini-mini jirray ngaykuwunbu jinanga nyangarrin. ");
INSERT INTO gvn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nyulu ngadiku buyun bajaku, yamba ngayu nyungu buyun-buyun kidanda. Nyulu ngaykunku wawu-jirraymanya, ngayu nyungu buyun-buyun jirray kidankuda. Kaki bamandamun buyun-buyun buban kidajin, nyulu ngaykunku bubanku wawu.” ");
INSERT INTO gvn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesusangka jalbundu yalamanda, “Ngayu yunu buyun-buyun kidankuda, milka-wulankuda.” ");
INSERT INTO gvn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jana yindu-yindu tablebu bundandarin, jana janaku balkan, “Nganga Godungkuku bamanga buyun-buyun kidal, yanyungku dingkarangka kari.” ");
INSERT INTO gvn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yamba Jesusangka jalbundu yalaman, “Yundu ngaykundu mambarrijinya, believeim-bunganya, yinyaynka ngayu yunu buyun-buyun kidanda. Yundu wawurr-wawurrku dungayda.” ");
INSERT INTO gvn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wawu yinyamun Jesus townbu yindu-yinduymbu dungan, Godumu kuku yirrkay-yirrkan. Nyulu bamanda balkan Godungku jananin ngulkurrduku kujinka. Nyungu jawun-karra 12-bala nyungunji dungarin. ");
INSERT INTO gvn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Jalbu-jalbu kanbal yalarrku nyungunji dungarin. Ngadiku Jesusangka kanbal yinyarrin ngulkurr-bungan bambaymun, kanbalandamun dukurrmun dubu-dubu kangan. Nyubun yinyarrin Mary Magdalene. Jesusangka dubu-dubu 7-bala nyungundumun kangan. ");
INSERT INTO gvn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yindu burri Joanna, manyarr Chuzamu. Chuza, nyulu maja, majanka Herodanka workmanijin. Yindu jalbu burri Susanna. Jana jalbu-jalbungku Jesus, and nyungu jawun-karra ngulkurrduku kujin. Jana mayi buy-im-bungan janawundu moneybu. ");
INSERT INTO gvn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bama wubul Jesusanda kankadarin. Jana townmun yindu-yindumun kadarin, wubul bajaku murumarin, Jesusangka jananda yanyu story balkan. ");
INSERT INTO gvn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ngadiku nyubun dingkar dungan, diburr mayi corn yayin-yayin-bungan bubungu. Nyulu diburr yayin-yayin-bungal-bungan paddockmunbu, kanbal diburr baraldarr daran. Yinyaymba bamangka diburr nyarrin, dikalangka kanbal nukan. ");
INSERT INTO gvn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Diburr kanbal daran bubungu kulji-kuljinga. Yinyaymba bubu wawu-darra kuljiburr, duna kari. Yinyaynka diburr marralman, wularin. ");
INSERT INTO gvn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kanbal diburr daran buljunbu bukul-bukuljirrba. Buljun jirraymaynda. Buljundu jurrbu kanbin, jurrbu kari jirrayman. ");
INSERT INTO gvn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Diburr kanbal bubungu ngulkurrbu daran, jurrbu corn balkajin, wandirin, dakarin, yalbayman. Mayi jirray balkajin, mayi 100-bala.” Jesusangka yalaman, “Kaki yurra milkaji, yurra milka-janay mumbarku.” ");
INSERT INTO gvn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesusandamundu jawun-karrangka nyungundu yalaman, “Yinya kuku mayika cornku nganjinanda milkanga-bunga.” ");
INSERT INTO gvn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nyulu yalaman, “Ngayu yurranin binal-bunganda Godundumunku kukuku. Godungku nyungu jawun-karra ngulkurrduku kujinka. God wawu yurraku nyungunku binalmanka. Godungku kuku nyunguku kari kujin yurrandamun, yamba nyulu kujin janandamun, jana nyungu-karimanya. Ngayu jananin binal-bungal storybu. Jana nyajin-nyajil, yamba jana binal kari. Jana kari mumbarabuku milkabu kujilda, bubankukuda.” ");
INSERT INTO gvn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jesusangka yalaman baja, “Ngayu story diburrku milkanga-bungal yurranda. Yinyarrin diburr yala Godumu kuku. ");
INSERT INTO gvn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kanbal diburr baraldarr daran. Yinya yala bamangka Godumu kuku milkabu nyajil. Yamba Dubu kaday, Godumu kuku bangkal janandamun. Yinyaynka jana kari kuku nyajil, kari believeim-bungal, jananga wawu kari juranmal. ");
INSERT INTO gvn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kanbal diburr daran kulji-kuljinga. Yinya yala wanyu? Yinya yala bamangka Godumu kuku nyajil, wawurr-wawurrmanijida. Yamba jana yinya kuku buban milkanga kujil, jana bubanku believeim-bungal. Dubungku jananin milka-bakal, jana jinbalku jurrkiji Godundumun. ");
INSERT INTO gvn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kanbal diburr daran buljunbu bukul-bukuljirrba. Kanbal bama yalaku. Jana Godumu kuku nyajil, yamba jana jumbunku yamba-yambaka. Jana money jirray maninka, junjuy-junjuy wubulku maninka. Yamba-yambaka jumbunmanya Godumu kuku kanbil, yala buljundu jurrbu kanbil. Yinyaynka jananga mayi kari kulbulmalkuda. ");
INSERT INTO gvn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kanbal diburr daran bubungu ngulkurrbu. Kanbal bama yalaku. Jana kuku nyajil, milkanga kujilda, wukurrilda. Jana kari kulbajikuda. Juma jana mayi jirray balkal, yala jurrbu bubungu ngulkurrbu. Jana yalaku Godunku ngulkurrku workmaniji.” ");
INSERT INTO gvn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesusangka yalaman, “Kaki bamangka light wayjul, nyulu kari nandal bucketmundu. Nyulu kari bada-bada bedba yijarril. Kari, nyulu light tablebu yijarril, bamangka light nyajilda, jana bayanba kadari. ");
INSERT INTO gvn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kanbalda bamangka nguba junjuy-junjuy kiraynjaku kujil, yamba juma bama wubulku binalmal. Yalarrku jana kuku kiraynjaku balkal, yamba juma bama mumbarku binalmal. ");
INSERT INTO gvn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Yurra mumbarku milka-janay ngaykuwunbu kukungu. Kaki bama mumbarku milka-janay, ngayu kuku milkanga-bungal nyungundu. Yamba yindu nguba kari mumbarku milka-janay. Yinyarrinyanda bamanda ngayu kuku kari milkanga-bungal, yinyaynka nyulu jinbalku milka-wulay.” ");
INSERT INTO gvn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesusamu ngamu, nyungu yabaju-karra kadarinka nyungundu, yamba jana kari yuba kadarin bamanka wubulkuku. ");
INSERT INTO gvn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nyubunyinja bamangka Jesusanda yalaman, “Yunu ngamu and yabaju-karra ngalkalba janjanari, jana yunun nyajinka.” ");
INSERT INTO gvn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesusangka bamanda wubulbuku yalaman, “Kaki bamangka Godumu kuku nyajil, and wukurril, jana ngayku ngamu and yabajuda.” ");
INSERT INTO gvn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wawu yinyamun Jesus boatbu walan nyunguwunji jawun-karranji, yalaman, “Ngana naka-naka jalunbu dungarinka.” Jana dungarinda. ");
INSERT INTO gvn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jana dungan-dungarin, Jesus warngku wunanan. Kari. Jarramali jinbalku kadan, mulngku jirray bajaku. Bana jirraykuda boatbu mulngkumun. Jana balu bujil-janjirinkuda. ");
INSERT INTO gvn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesusamu jawun-karra nyungundu dungarin, nyungun walngan warngkumun, yalaman, “Maja, Maja, ngana bujil-janjirinji.” Jesus dakan, jarramalinda and muyaranda balkan kunbanka. Muyar kunbaynda, bana marrkamaynda. ");
INSERT INTO gvn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yinyamun nyulu jananda yalaman, “Wanyurrinku yurra nganya kari trustim-bungan?” Yamba jana kungkurr-kadarin, yinyilmarin. Jana yalaman, “Yanyu dingkar wanju? Muyarabu, banabu nyungunin kuku nyajil. Nyulu muyar, bana marrka-bungan.” ");
INSERT INTO gvn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wawu yinyamun jana Jesus naka-naka dungarin bubungu Gerasa. Jana ngubar-ngubarmun Galileemun kadarin. ");
INSERT INTO gvn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus bubungu jalaman, dingkar nyungundu kadan. Nyulu dingkar dubu-dubunji. Nyulu ngadi bajaku kambi kari didan, bayanba kari bundan. Nyulu juljalba bundandan. ");
INSERT INTO gvn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Dubungku dingkar yarbarrka karrban baja, karrban baja. Yinyaynka nyunguwundu jawun-karrangka nyungun ngarri and dakil chainda kajan baja, kajan baja. Yamba nyulu chain dumbarrin baja, dumbarrin baja. Yinyamun dubungku nyungun kangan baja, kangan baja bubungu jirrbu-jirrbungu. Jesusangka yinya dingkar dubunji nyajin, nyulu dubu kanganka. Yinyaynka dingkar yaykarrku kawal yirrkan, nyulu bungkubu janan jakalba Jesusanda, yalamanda, “Yundu Jesus, yundu Godumu junkurrjimu kangkal. Yundu wanjarrmanka ngaykundu? Kari nganya wurrkay-mana, kari warrngkay-mana.” ");
INSERT INTO gvn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesusangka nyungundu babajin, “Yundu burri wanju?” Nyulu yalaman, “Ngayu burri Big Mob.” Nyulu burri Big Mob, dubu-dubu wubul nyungundu walanya. ");
INSERT INTO gvn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jana dubu-dubungku Jesusanda yalaman, “Nganjinin bada-bada bubungu kari yunga nguwul-nguwulbu, jananda yindu-yinduyndu dubu-dubundu.” ");
INSERT INTO gvn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yinyaymba wuburrbu bikibiki wubul nukal-nukajin. Jana dubu-dubungku Jesusanda babajin, “Yundu nganjinin bikibikinda yunga. Nganjin bikibikinda dukurrbu walarinka.” Jesusangka jananin yunganda bikibikinda. ");
INSERT INTO gvn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dubu-dubu dingkarandamun dukurrmun wandirin, bikibikinda dukurrbu walarin. Jana bikibiki wubulku warririnda, ngamarmun dararinda bada-bada jalunbu. Jana wubulku bujil-janjirinda. ");
INSERT INTO gvn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kanbalda dingkar-dingkarangka bikibiki kujil-kujin. Jana bikibiki nyajin bujil-janjirinya, jana warririnda, townbu, bubungu yindu-yinduymbu bamanda balkanka. Bamangka wubulduku kuku nyajinda, yiringkurrku. ");
INSERT INTO gvn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bama wubulku kadarin, nyajinka. Jana Jesusanda kadarin, yinya dingkar nyajin, dubu-dubu wandirinya dukurrmun. Nyulu Jesusanji bundandan, kambijida, dukurr ngulkurrmaynda. Bamangka yinya nyajin, jana yinyilmarinda. Jana nyajin Godungku junjuy miracle yalbay balkanya. ");
INSERT INTO gvn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yinyarrinyangka dingkar-dingkarangka bikibiki nyajin, jana bamanda balkan Jesusanka, nyulu dubu-dubu kanganya dingkarandamun dukurrmun bikibikindarrku. ");
INSERT INTO gvn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yinyamun bamangka wubulduku Jesusanda babajin yinyamun bubumun dunganka, jana yinyilmarinya. Yinyaynka Jesus boatbu walan, jananin bawan. ");
INSERT INTO gvn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jesus dunganjiku, dingkarala nyungundu kadan, babajin, “Ngayu yununji dunganka.” Yamba Jesusangka nyungundu yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kari, yundu bayanbaku dungay baja, jawun-karranda balka God yununku ngulkurr bajaku.” Nyulu dingkar townbuku dungan baja, wubulbuku balkan, “Jesusangka nganya ngulkurr-bungan, dubu-dubu kangan ngaykuwunmun dukurrmun.” ");
INSERT INTO gvn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus jalundurr ngubar-ngubar dungan. Yinyaymba bamangka nyungun yulmbarrin, jana nyungun kujil-kujinya. ");
INSERT INTO gvn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nyubun dingkar, burri Jairus kadanda. Nyulu maja Jew-warrandamunbu churchmunbu. Nyulu Jesus nyajin, nyulu Jesusanda bungkubu janan, yalamanda, “Yundu ngaykuwunbu bayanba kadayarr. ");
INSERT INTO gvn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngayku kangkal nyubunku jalbu 12 years old, bambay bajaku. Nyulu wulan-wulay.” Jesus nyungunji dungan-dungan, bamangka wubulduku wukurrin, murumarin nyungundurr. ");
INSERT INTO gvn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nyubun jalbu yinyay, nyulu mula wanarrin ngadingka, 12-yearsmunku. Nyulu yindu-yinduymbu doctoranda dungan, money karida, doctor-doctorandakuda dajin. Yamba jana nyungun kari ngulkurr-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nyulu bamandarr wubulburrku kadan kudamundu Jesusanda, nyungu kambi biji karrban. Nyulu mula kari warrin baja, bambaymun jinbalku ngulkurrman. ");
INSERT INTO gvn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus jananda babajin, “Wanjungku nganya karrban?” Jana wubulduku yalaman, “Nganjin kari.” Peterangka yalaman Jesusanda, “Maja, bama wubulku murumarin yunundurr. Wanyangka baja yunun karrban?” ");
INSERT INTO gvn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yamba Jesusangka yalaman, “Bamangka nganya karrbankuda. Ngayu binal junkurr ngaykundumun dungan.” ");
INSERT INTO gvn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nyulu jalbungku nyajin Jesus binalmanya nyungunku. Yinyaynka nyulu bangkarr yararri-yararrin, Jesusanda kadan, bungkubu janan nyungundu. Yinyaymba jakalba bamanda wubulbuku, nyulu Jesusanda balkan nyunguwundu junkurrdu nyungunin jinbalku ngulkurr-bungan bambaymun. ");
INSERT INTO gvn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesusangka jalbundu yalaman, “Yundu ngulkurrman, yundu nganya kuku nyajinya. Yundu wawurr-wawurrku dungayda.” ");
INSERT INTO gvn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus jalbunji yinyaynji mula-wanarrinya balkan-balkawan, bama kukuji kadan majandamun bayanmun. Nyulu majanda Jairusanda yalaman, “Yunu kangkal wulaynda. Jesus kari wundi baja.” ");
INSERT INTO gvn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yamba Jesusangka kuku nyajin, nyulu Jairusanda yalaman, “Kari yinyilmaka, nganya kuku nyaka, yunu kangkal ngulkurrmal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jana bayanba kadarin, Jesusangka bama kirin kananga dungarinka. Nyulu kulurku wundin, Peter, James, John, and kangkalamu nganjan, ngamu. ");
INSERT INTO gvn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jesusangka bama wubul nyurra-nyurra nyajin yaykarrku banbadarinya. Nyulu jananda yalaman, “Kari badi, yinya maral kari wulan, nyulu warngku wunanay.” ");
INSERT INTO gvn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jana wubulduku nyungun yaykarrdaku yajarrinda, jana binal maral wulankuda. ");
INSERT INTO gvn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yamba Jesusangka maralamu mara karrban, nyungundu yalaman, “Maral, wandida!” ");
INSERT INTO gvn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nyulu juranmaynda, wandinkuda. Jesusangka yalaman, “Maralamu mayi daya.” ");
INSERT INTO gvn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bula nganjan and ngamu kungkurr-kadan, yamba Jesusangka bulanda yalaman, “Yubal bamanda yindu-yinduymbu kari balka yanyunku.” ");
INSERT INTO gvn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesusangka jawun-karra 12-bala kunjan, murumarinka, nyulu jananda kuku dajinka. Nyulu jananda junkurr dajin, dubu-dubu kanganka bamandamun, junkurr dajin bambay-bambay ngulkurr-bunganka, bambaymun walu-yindu walu-yindumun. ");
INSERT INTO gvn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nyulu jananin yungankuda Godumu kuku yirrkanka. Nyulu yalaman, “Bamanda balka, ‘Time kadanda, bama Godundu jurrkijinka, nyungu jawun-karramanka. Godungku nyungu jawun-karra ngulkurrduku kujinka.’ Yurra yalarrku bama ngulkurr-bunga bambaymun.” ");
INSERT INTO gvn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nyulu yalaman, “Yurra yamba-yamba kari wundi. Jaba, kurmun, mayi, money, kambi yindu kari wundi. ");
INSERT INTO gvn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yurra yinyaymba townbu kadari, yinyangka bamangka yurranin bayanba walay-manil. Yurra yinyaymbaku bundarika bayanba, until yurra yinyamun townmun dungarinyamunku. ");
INSERT INTO gvn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kaki bamangka townbu yurrangan kari wawurr-wawurrduku walay-manil, yurra yinya town bawada. Yurra dungarika, jina bulngajika, bulbur jinamun kidajika. Bamangka yinyaymba townbu yurrangan nyajil bulngajinya, jana binalda yurra janandamun jurrkijinkuda, jananin bawankuda.” ");
INSERT INTO gvn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jana jawun-karrangka nyungun bawanda, townbu yindu-yinduymbu dungan, Godumu kuku ngulkurr yirrkan, bama ngulkurr-bungan bambaymun. ");
INSERT INTO gvn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod, nyulu maja jirray bubuku Galileemunku. Nyulu kuku nyajin Jesusanka, nyulu nyunbarraman, kanbalda bamangka yalamanya, “John the Baptist juranman baja yarkinmun.” ");
INSERT INTO gvn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yindu-yinduyngku yalaman, “Elijah ngadimunku nguwimal milbijin.” Yindu-yinduyngku yalaman, “Nyubun prophet ngadimunku juranman baja.” ");
INSERT INTO gvn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodangka yalaman, “Ngaykuwundu soldier-soldierangka Johnumu dukul yakankuda, yamba wanju yanyu dingkar? Ngayu junjuy-junjuy wubulku milkabu nyajil nyungunku.” Nyulu Jesus nyajinka, nyungunji balkawanka. ");
INSERT INTO gvn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jana jawun-karra kadarin baja kuku yirrkanyamun. Jana Jesusanda wubulku balkan jana townmundurr dungarin. Nyulu jananin nyungunji wundin, jana wubulku janarrku dungarin townbu Bethsaida. ");
INSERT INTO gvn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kanbalda bamangka kuku nyajin jana dungarinda, jana Jesus wukurrinda. Nyulu jananin yulmbarrin, jananin bambay-bambay ngulkurr-bungan, jananda yalaman, “Godundu jurrkijika, Godungku nyungu jawun-karra ngulkurrduku kujil-kujilda.” ");
INSERT INTO gvn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wungar daran-daran, jana jawun-karra 12-bala Jesusanda kadarin, yalaman, “Yanyu bubu jirrbu-jirrbu, mayi yamba-kari. Yundu bama wubulku yungada, townbuku dunganka, mayi maninka janangaku, bayanba wunanka.” ");
INSERT INTO gvn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yamba Jesusangka jawun-karranda yalaman, “Yurraku jananga mayi daya.” Jana yalaman, “Nganjinanga mayi bread 5-bala, minya kuyu jambul. Yundu wawu nganjin dungarinka, mayi buy-im-bunganka bamanka wubulkuku?” ");
INSERT INTO gvn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bama wubul bajaku yinyaymba, dingkar-dingkar 5000-bala. Jesusangka jawun-karranda yalaman, “Yurra bama wubulku bunday-mana. Muruku bunday-mana 50-bala yalaymba, 50-bala yinyaymba, yalaku.” ");
INSERT INTO gvn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jana jawun-karrangka jananin yalaku bunday-manin, ");
INSERT INTO gvn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesusangka bread 5-bala, minya kuyu jambul manin, jiri nyajin, God thankim-bungan, mayika, minyaka. Yinyamun nyulu mayi, minya dumbarrin, jawun-karranda dajin. Jawun-karrangka bamanga wubulbuku wamban. ");
INSERT INTO gvn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bamangka wubulduku nukan, yanjimankuda. Jawun-karrangka basket 12-bala jakal-bungan mayibu yandaynja. ");
INSERT INTO gvn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yala, Jesus juma nyulurrku bundandan, Godunji balkal-balkawan. Nyungu jawun-karra nyungundu kadarin, nyulu jananda babajin, “Bama ngaykunku balkan-balkaway, jana wanyu balkal ngaykunku? Ngayu wanju?” ");
INSERT INTO gvn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jawun-karrangka yalaman, “Kanbalda balkal-balkal yundu John the Baptist. Kanbalda balkal-balkal yundu Elijah, or nguba prophet ngadimunku juranman baja.” ");
INSERT INTO gvn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesusangka jananda babajin, “Yala yurra? Yurra wanyu balkal, ngayu wanju?” Peterangka yalaman, “Yundu bama Godundumun. Yundu Godumu Christkuda. Godungku yunun bamban.” ");
INSERT INTO gvn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesusangka jawun-karranda 12-balanda yalamanda, “Yurra yinya kuku ngaykunku kari balka, ngayu Christ.” ");
INSERT INTO gvn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nyulu jananda yalarrku yalamanda, “Ngayu bamanga wubulbuku yaba. Ngayu warrngkay, milka-bujarmal. Jana binga-binga, maja-maja Godundumunku bayanka, teacher-teacher lawmunku, jana wubulku ngaykunku wawu kari bajaku. Jana nganya kunil, warrngkay-manil, wulay-manil. Yamba warngku kulurmal ngayu juranmal baja yarkinmun.” ");
INSERT INTO gvn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nyulu yalamanda, “Kaki bamangka nganya wukurrinka, nyulu must milka-wulayda nyungunkuku, ngaykundu mambarrijikarrkuda. Nyulu kari jumbunmaka yamba-yambaka, junjuy-junjuynku. Kaki bamangka nganya wukurril, bama yindu-yindu nyungunku wawu-karimanji. Jana kuli dajinji, yarkinkaku kuninji, jukungu walngkan-damanji, yamba nyulu must nganya wukurrikarrku. ");
INSERT INTO gvn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kaki bama juranku bundanka and nyunguku way wukurrinka, nyulu juma wulaykuda. Kaki bamangka ngayku work balkanka and Godumu way wukurrinka, nyulu nguba wulay ngaykunku. Yamba nyulu juranku bundayarrkukuda wuljaljiku heavenba. ");
INSERT INTO gvn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bamangka nyubunyinja nguba junjuy-junjuy wubul manil, jumbunmanya. Yinyamundu junjuy-junjuynju nyungun kari juran-bungal. Karibi! Bamangka wanjarrmal juranmanka baja? Yala kari. Bamangka dukuldu Godku manada, junjuy-junjuy kari. Godungkuku bama juran-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ngayu bamanga wubulbuku yaba. Bama nguba murru-kaday ngaykunku, ngaykuwunku kukuku. Kaki ngayu jiri-warranji dayirranji kaday baja, ngayu yalarrku nyungunku murru-kaday, nyulu ngaykunku murru-kadanya. Ngayu junkurrjiku kaday, dayirrku, yala ngayku nganjan. ");
INSERT INTO gvn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngayu yurranda manubajabuku balkal, Godungku nyungu jawun-karra ngulkurrduku kujil. Yurra kanbal wulanjiku, yurra God nyajil nyungu jawun-karra ngulkurrduku kujinya.” ");
INSERT INTO gvn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wawu yinyamun kukumun, warngku 6-balaman, Jesusangka jananin Peter, John, James nyungunji wundin. Jana wangkar-wangkar wuburrbu dakarin, miyil nandajinka, praymanka. ");
INSERT INTO gvn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nyulu Jesus Godunji balkal-balkawan, nyungu walu walu-yinduman. Nyungu kambi bingajiman, dayirr bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jinbalku bula dingkar-bulal nguwimal milbijin, Jesusanji balkan-balkawan. Bula Moses bula Elijah ngadimunku. ");
INSERT INTO gvn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bula yalarrku dayirrkuda yala dayirrda heavenba. Bula Jesusanji balkawan nyungunkuku. Bula Jesusanda yalaman, “Jana yunun juma warrngkay-manil townbu Jerusalem, yinyaymba jana yunun yarkinkaku kunil. Godungku yunun yungan yalaku wulanka.” ");
INSERT INTO gvn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jana Peter warngku-kadarin, yamba jana kari warngku wunarin. Yinyaynka jana Jesus, dingkar-bulal jambul nyajin dayirr bajaku bundandanya. ");
INSERT INTO gvn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yinyamun dingkar-bulalangka Jesus bawanda. Peterangka yalaman Jesusanda, “Maja, ngulkurr yala, nganjin yaluyda. Nganjin bayan kulur ngaral yurranka. Nyubun yununku, nyubun Mosesanka, nyubun Elijahnka.” Nyulu kiru-kariku balkan, kari milkabu wukurrin. ");
INSERT INTO gvn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peter balkan-balkawan, ngurrban wuyar kadan jananda, jananin wubulku nandan. Jana jawun-karra yinyilmarin. ");
INSERT INTO gvn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jana kuku nyajin ngurrbanmun, yalamanya, “Yanyu ngayku kangkal. Ngayu nyungun bamban. Yurra nyungundu milka-janay.” ");
INSERT INTO gvn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kuku kariman, jawun-karrangka Jesusku nyajin. Jana Moses bulal Elijah kari nyajin baja. Yala-yalaku yinyarrinyangka kulurungku bamanda kari balkan wanyu jana nyajin. Jana muwulduku kujin. ");
INSERT INTO gvn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Warngku yindu jana Jesus wuburrmun kadarin. Bamangka wubuldu Jesus maku-nyajin. ");
INSERT INTO gvn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nyubunyinja dingkarangka bamandamun yirrkan, “Teacher, yundu ngaykuku nyubunku kangkal nyaka. ");
INSERT INTO gvn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dubungku kawal yirrkay, nyungun buyun-damal, bubungu yilbal. Nyulu yararrida. Dubungku nyumba warri-manil ngandalmun, nyungun warrngkay-manil, kari bajaku bawal. ");
INSERT INTO gvn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngayu yunuwunbu jawun-karranda babajin dubu kanganka, yamba jana murruji kangan.” ");
INSERT INTO gvn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesusangka jananda bamanda yalaman, “Yurra wubulduku nganya warmbin-warmbil, kari junkayku bundandari. Ngayu ngadingka bundandan yurranji. Yurra wanja-wanja nganya kuku nyajil?” Nyulu dingkaranda yalaman, “Karrkay ngaykundu wundi.” ");
INSERT INTO gvn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nyulu karrkay kankadan, dubungku nyungun bubungu yilban. Nyulu karrkay yararrin-yararrin. Jesusangka dubu murru-kangan, karrkayandamun kangan. Karrkay ngulkurrmanda. Jesusangka karrkay nganjanandaku dajinda. ");
INSERT INTO gvn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bama wubulku kungkurr-kadarin Godundumunku junkurrku. Jana kungkurr-kadarin Jesusanka, nyulu nyunguwunbu jawun-karranda yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kari milka-wulay kukuku ngayu yurranda balkal. Ngayu bamanga wubulbuku yaba. Jana nganya mambarril dingkar-dingkaranda.” ");
INSERT INTO gvn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yamba jana jawun-karra binal kari nyunguwunku kukuku. Nyulu yinya kuku kari milkanga-bungan, yamba jana yinyilji nyungundu babajinka yinyaynka. ");
INSERT INTO gvn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wawu yinyamun jana jawun-karra murru-kangawan, wanya jarra yalbay bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesusangka jibabu nyajin jana milkanga kujil-kujinya. Yinyaynka nyulu nyubun karrkay kunjan, jajirrin nyungundu. ");
INSERT INTO gvn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nyulu jawun-karranda yalaman, “Kaki yurra yanyu karrkay yulmbarril, yurra nganya yulmbarril. Kaki yurra nganya yulmbarril, yurra yalarrku nyungun yulmbarril nganya yunganya. Kaki bama nyuluku buban-bungaji, nyulu majamal Godundumunku jawun-karranka yindu-yinduynku.” ");
INSERT INTO gvn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nyulu Johnungku yalaman, “Maja, nganjin nyubun dingkar nyajin dubu-dubu kangal-kanganya yunuwundu junkurrdu. Nganjin nyungun balkan, ‘Yundu dubu kari kanga baja.’ Nganjin nyungun kirin dubu kanganka, nyulu ngananga kari jawun, nyulu yunun kari wukurrinya.” ");
INSERT INTO gvn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesusangka Johnundu, and jawun-karranda yalaman, “Yurra nyungun kari kirinyaku. Kaki bamangka ngananga kuli kari dajil, jana bama ngananga jawunkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Time yuba kadan Godungku Jesus wangkar heavenba wundinka. Jesusanda milkanga kadan nyulu townbu Jerusalem dunganka. ");
INSERT INTO gvn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nyulu bama kukuji jakalba yungan. Jana townbu bubungu Samaria dungarin, yanday-bunganka Jesusanka. ");
INSERT INTO gvn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yamba jana Samaria-warrangka nyungun kari yulmbarrin, nyulu townbu Jerusalem dunganya. Jana Samaria-warra bamanka Jerusalem-warranka wawu kari. ");
INSERT INTO gvn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jamesangka bula Johnungku yinya nyajin, bula Jesusanda babajin, “Maja, yundu wawu ngalin baya heavenmun kunjanka, jananin Samaria-warra wayjunku?” ");
INSERT INTO gvn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yinyaynka Jesus jurrkijin, bulanin murru-kangan. ");
INSERT INTO gvn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yinyamun Jesus, nyungu jawun-karra townbu yinduymbu dungarin. ");
INSERT INTO gvn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jana dungan-dungarin, nyubunyinja dingkarangka Jesusanda yalaman, “Ngayu yununin yiringkurrku wukurril.” ");
INSERT INTO gvn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesusangka nyungundu yalaman, “Kayamu dingkumu bayan bulkaji, dikalamu bayan bulka. Yamba ngayku bayan yamba-kari, wunanka warngku. Ngayu bamanga wubulbuku yaba.” ");
INSERT INTO gvn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesusangka yinduymbu dingkaranda yalaman, “Nganya wukurrika.” Yamba yinyayangka dingkarangka yalaman, “Maja, nganya yungada. Ngayu ngayku nganjanarr juljalba nandanka. Yinyamun ngayu yunun wukurril.” ");
INSERT INTO gvn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesusangka yalaman, “Kaki bama milkanga ngaykunjiku kari bunday, jananga wawu wularida. Balu jana janangaku yarkin-yarkin nanda. Yamba yundu dungay, Godumu kuku yirrkanka. Yundu bamanda balka Godundu jurrkijinka, Godungku nyungu jawun-karra ngulkurrduku kujinka.” ");
INSERT INTO gvn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yinduynju dingkarangka yalaman, “Ngayu yunun wukurril, yamba ngayu jakalba dunganka, ngayku jawun-karra goodby-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesusangka nyungundu yalaman, “Kari. Kaki yundu nganya wukurrinka, yundu kari kudamundu nyaka jawun-karra. Godungku yalanguy bama kari ngulkurrduku kujil.” ");
INSERT INTO gvn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wawu yinyamun Majangka Jesusangka yindu dingkar-dingkar bamban, 72-bala. Nyulu jananin jambul-jambulku yungan jakalba nyungunku townbu yindu-yinduymbu nyuluku dunganka. ");
INSERT INTO gvn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nyulu jananda dingkar-dingkaranda 72-balanda yalaman, “Jana bama yala mayi jirray gardenba. Yamba workingman kulur, mayi mujanka. Godundu babajika bama wubul yunganka, jana bama wubulku mujanka, Godundu wundinka. ");
INSERT INTO gvn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yurra dungayda. Yurra yala sheep. Ngayu yurranin yungal bamanda kuli-bakanda yala kayanda dingkundu. ");
INSERT INTO gvn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yurra kari money ngunyinda wundi, kari kurmun wundi, kari dambal yindu wundi. Yurra baraldarr dungan-dungari, bama maku-nyajil, kari janay, kari balkawaka nyungunji. Jinbalku dungarika. ");
INSERT INTO gvn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yurra townbu kadari, bayanba walal, yurra jananda balka, ‘Ngalin wawu Godungku yurranin ngulkurrduku kujinka.’ ");
INSERT INTO gvn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kaki jana yurranin wawurr-wawurrduku walay-manil, Godungku jananin ngulkurrduku kujilda yala yurra balkan. Kaki jana yurranin kari wawurr-wawurrduku walay-manil, Godungku jananin kari ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kaki walay-manil, yurra yinyaymba bayanba bundari, mayi, bana nuka wanyu jana yurranda dajil. Jana should yurranda mayi daya, yala majangka nyungu workingman payim-bungal. Yurra nyubunyimba bayanba bundarika, kari bayanba yindu-yinduymbu jurrkijika. ");
INSERT INTO gvn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kaki jana yurranin yulmbarril townbu, yurra nuka wanyu mayi jana yurranda dajil. ");
INSERT INTO gvn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yurra bama ngulkurr-bunga bambaymun yinyaymba townbu, jananda balka, ‘Time yuba kadanda Godungku nyungu jawun-karra ngulkurrduku kujinka.’ ");
INSERT INTO gvn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kaki yurra townbu kadari, jana nguba yurranin kari yulmbarril. Yinyamun yurra baraldarr dungarika, yalamaka, ");
INSERT INTO gvn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yurra ngalinyanka wawu-kariman, yinyaynka ngalin bulbur yurrawunmun townmun ngalinyandamun jinamun kidal. Yurra binalmalda, Godungku yurranin ngulkurrduku kujinka yala nyulu nyungu jawun-karra ngulkurrduku kujil, yamba yurra nyungun bayjan.’ ");
INSERT INTO gvn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jana Godunku wawu kari. Yinyaynka nyulu juma jananin nyuyal buyun-buyunku courtcasemunbu. Jana bama ngadiku bundandarin townbu Sodom, jana buyun bajaku. Yamba Godungku jananin jarra buban nyuyal janawunku buyun-buyunku, jana ngaykuwunku kukuku kari binalmanya.” ");
INSERT INTO gvn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesusangka yalaman baja, “Yurra bama townku Chorazinka, townku Bethsaidaka, yurra Godumu kuku bayjal-bayjan. Kuli jirray yurranda kaday. Jana bama ngadiku bundandarin townbu Tyre, townbu Sidon, jana buyun bajaku. Yamba jana nganya nyajinyaku ngulkurr-ngulkurr miracle balkanya, jana Godundu jurrkijinyaku buyun-buyunmun. Jana milka-bujarmanyaku buyun-buyunku. Yamba yurra yala kari. Ngayu Godundumundu junkurrdu ngulkurr-ngulkurr miracle balkan yurranga, yamba yurra kari buyun-buyunmun jurrkijin. Yurra kari milka-bujarman buyun-buyunku yurrawunku. Yinyaynka yurra milka-bujarmal, kuli jirray yurranda kaday. ");
INSERT INTO gvn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Juma bama wubulku jakalba Godundu janay, courtcasemunku. Yala-yala Godungku bamanda townku Tyreanka, townku Sidonanka yalamal, ‘Yurra bama buyun.’ Nyulu jananin yilbalda, bada-bada bayanga. Yamba nyulu yurranda yalamal, ‘Yurra bama buyun bajaku, yurra ngayku kangkal bayjanya ngulkurr balkanya.’ Nyulu yurranin yilbalda, bada-bada bayanga wumbulbu bajangaku. Godungku jananin punishim-bungalkuda, yamba nyulu yurranin yaykarrdaku punishim-bungal, yurra nganya bayjanya. ");
INSERT INTO gvn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yurra bama townbu Capernaummunbu, nyaka. Yurra balu Godungku yurrangan wangkar-wangkar heavenba wundil. Kari bajaku. Ngayu yurrangan bada-bada bayanga yilbal.” ");
INSERT INTO gvn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesusangka nyunguwunbu jawun-karranda yalaman, “Kaki bama yurranda milka-janay, jana ngaykundu milka-janay. Kaki bama yurranka wawu kari, jana ngaykunku wawu kari. Kaki jana ngaykunku wawu kari, jana yalarrku wawu kari nyungunku nganya yungan.” ");
INSERT INTO gvn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jana dingkar-dingkar 72-bala wawurr-wawurrku kadarin baja. Jana yalaman, “Maja, kaki nganjin dubu-dubundu balkan yunuwundu junkurrdu, jana nganjinan kuku nyajin, bamandamun wandin.” ");
INSERT INTO gvn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesusangka jananda yalaman, “Godungku Dubu Satan kangan heavenmun. Ngayu nyungun nyajin daranya yala balbay jirimun. Nyulu maja karida. ");
INSERT INTO gvn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yurra nyakada, ngayu yurranda junkurr jirray dajin dubu-dubunku. Kaki yurra ngaykuwundu junkurrdu dungay, yurra jarba, munu-dumbun nyarril, yamba yurra kari bambaymal. Dubungku yurranin milka-bakal buyunmanka, yamba yurra nyungundu kari milka-janay ngaykuwundu junkurrdu. Dubungku yurranin kari wurrkay-manil. ");
INSERT INTO gvn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yurra kari wawurr-wawurrmaka, dubu-dubungku yurranin kuku nyajinya. Kari. Yurra wawurr-wawurrmaka, yurra Godumu jawun-karramanya. Nyulu yurranga burri kabanba balkan heavenba. Yinyaynka yurra wawurr-wawurrmaka.” ");
INSERT INTO gvn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yala-yalaku Godundumundu Wawubu ngulkurrdu Jesus wawurr-wawurr-bungan. Yinyaynka Jesusangka God buyay-manin. Nyulu yalaman, “Nganjan, yundu maja jirray bamanga jiringa, bamanga bubungu. Ngayu yunun thankim-bungal yundu mumbarabuku binal-bunganya bama yinyarrin yununku binal kari. Yamba kanbal bama balu jana binal bajaku yununku. Yundu yinyarrin bama kari binal-bungan. Yuwu, Nganjan, yinya yala yunduku wawubu.” ");
INSERT INTO gvn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yinyamun Jesusangka jawun-karranda yalaman, “Ngaykuwundu nganjanangka jakalbaku ngaykundu junjuy-junjuy wubulku dajin. Bama Godundumunku kangkalanka kari mumbarku binal. Nganga Nganjanku nyungunku binalkuda. Bama yalarrku Nganjananka kari mumbarku binal. Nganga Kangkalku nyungunku binal. Yamba ngayu kanbal bama wangkanil binal-bunganka Godunku, jana nyungu bamamanka.” ");
INSERT INTO gvn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wawu yinyamun Jesus jurrkijin nyunguwunbu jawun-karranda. Nyulu jananda kiraynjaku balkan, “Ngulkurr yurranka yurra nganya nyajin junjuy-junjuy miracle yalbay balkanya. Yinyaynka yurra wubulduku God buyay-mana. ");
INSERT INTO gvn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngayu yurranda balkal, jana prophet-prophet, jana maja-maja ngadimunku, jana nganya Christ Godundumun nyajinka, yamba jana kari nyajin. Jana nyajinka wanyu yurra nyajilda, yamba jana kari nyajin.” ");
INSERT INTO gvn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nyubun teacher lawmunku Jesusanda kadan. Nyulu Jesus jurril-bunganka, nyungun catchim-bunganka. Nyulu babajin Jesusanda, “Maja, ngayu wanjarrmal wuljaljiku juranku bundanka?” ");
INSERT INTO gvn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesusangka babajin, “Godundumundu kabanda wanyu balkal, wuljaljiku juranku bundanka?” ");
INSERT INTO gvn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nyulu teacherangka yalaman, “Godundumundu kabanda balkal, ‘Bama Godunku wawu-jirraymaka. God wawungu, dukurrbu kuji, junkaynjaku junkurr-murubuku wukurrika. Milkanga Godunjiku bunday. Yalarrku bama must yindu-yinduynku bamanka wawu-jirraymaka. Nyulu must jananka wawu-jirraymaka yala nyulu nyungunkuku wawu jirray.’” ");
INSERT INTO gvn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesusangka teacheranda yalaman, “Yinya kuku junkay. Kaki yundu yinya kuku wukurril, yundu wuljaljiku juranku bunday.” ");
INSERT INTO gvn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yinya teacher wawu Jesusanda milkanga kadanka nyulu ngulkurr. Yinyaynka nyulu Jesusanda babajin, “Yala ngayu bamanka wubulkuku wawu-jirraymaka? Kanbal bama ngayku jawun-karra kari. Yala ngayu jananka yalarrku wawumaka?” ");
INSERT INTO gvn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesusangka story balkan nyungun binal-bunganka. Nyulu yalaman, “Ngadiku nyubun dingkar baraldarr dungan-dungan townmun Jerusalemmun bada townbu Jericho. Kanbalda wurrmay-bakangka nyungun karrban, kambi walngan, jururr-jururr kunin, bawan baralba. Jana balu nyajin nyulu wulanya, yamba nyulu juranku. ");
INSERT INTO gvn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Juma maja priest Godundumunku bayanka baraldarr yinyayngkarrku dungan. Nyulu yinya dingkar nyajin wunananya, yamba nyulu walkuku dungan, nyungun kari helpim-bungan. Nyulu baraldarr dungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Juma workingman Godundumunku bayanka baraldarr yinyangkarrku dungan. Nyulu dingkaranda yubaku kadan, nyajin, yamba nyulu dungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Juma yindu bama bubumun Samariamun baraldarr kadan. Jana bama bubumun Samariamun, jana Jew-warra kari. Jana Jew-warra Samaria-warranka wawu kari. Nyulu yinya dingkar nyajin wunananya, nyulu jiba-badin nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nyulu dingkaranda dungan, nyungu baji julurrin, medicine nyangarrin, kambibu kajan. Yinyamun nyulu dingkar nyunguwunbu donkeynga dakay-manin, nyungun hotelba wundin. Yinyaymba nyulu dingkar ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Warngku yindu nyulu dunganjiku, nyulu money dajin majanda hotelmunbu. Nyulu majanda yalaman, ‘Yundu yinya dingkar ngulkurrduku kuji. Kaki yinya money kari enoughkuda, ngayu kaday baja, ngayu yunundu dajil baja.’” ");
INSERT INTO gvn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesusangka teacheranda yalamanda, “Bama kulur baraldarr dungan. Wanjaku bama yala jawun dingkaramu bambayamu?” ");
INSERT INTO gvn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nyulu teacherangka yalaman, “Yinya bama dingkaranka manun-manunman.” Jesusangka yalaman, “Yuwu, yundu dungay, yalaku yalamaka.” ");
INSERT INTO gvn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jana, Jesus, nyungu jawun-karra dungarin baja. Jana townbu kadarin. Yinyaymba townbu jalbu-bulal jambul babarr-jinkurr bundandan, burri Martha and Mary. Jesus bulawunbu bayanba bundan. Bula Jesus yulmbarrin. ");
INSERT INTO gvn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marthangka mayi wayjul-wayjun, Mary bundandan, Jesusanda kukungu milka-janjanan. ");
INSERT INTO gvn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marthangka wawu kari work wubulku balkanka. Yinyaynka nyulu Jesusanda yalaman, “Maja, yundu ngayku jinkurr yunganyaku ngayku hand dajinka mayika.” ");
INSERT INTO gvn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yamba Jesusangka nyungundu yalaman, “Martha, yundu kari worrymaka mayika, yamba-yambaka, kari milka-bujarmaka. ");
INSERT INTO gvn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jarra ngulkurr bamangka ngayku kuku nyajinka. Mary yaluy bundanday ngaykuwunbu kukungu milka-janjanay. Godungku yinya kuku nyungu dajin, kari manil baja nyungundumun.” ");
INSERT INTO gvn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jumanya Jesus yinduymbu bubungu dungan Godunji balkawanka, praymanka. Nyulu kunban, nyubunyinja jawunyungku nyungundu yalaman, “Maja, yundu nganjinin binal-bunga praymanka yala Johnungku nyungu jawun-karra binal-bungan.” ");
INSERT INTO gvn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesusangka yalaman, “Yundu praymanka, yundu yalaku kuku balka: ‘Nganjan, yundu ngulkurr bajaku, dayirr bajaku. Yunduku majamaka bubungu, bamanka yindu-yinduynku, jananin ngulkurrduku kujinka. ");
INSERT INTO gvn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yundu nyiku nganjinanga mayi daya. ");
INSERT INTO gvn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yundu nganjinandamunku buyun-buyunku milka-wulay. Bamangka nganjinin buyun-damal, nganjin yalarrku yinyarrinyanka buyun-buyunku milka-wulay. Yundu nganjinin nyakaku, dubungku nganjinin kari milka-bakanka buyun-damanka.’” ");
INSERT INTO gvn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesusangka jawun-karra binal-bungan storybu. Nyulu yalaman, “Yundu nguba yunuwunbu jawunyundumunbu bayanba dungay kunarangkalba. Nyulu kananga warngku wunanay. Yamba yundu nyungundu balkal, ‘Jawun, yundu ngayku bread kulur daya. ");
INSERT INTO gvn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ngayku jawun kala-kalbaymun kadan ngaykuwunbu bayanba. Ngayu mayi yamba-kari, nyungu dajinka.’ ");
INSERT INTO gvn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nguba yunuwundu jawunyungku kanamundu yalamalda, ‘Dungayda, nganya kari wawu-dama. Ngayku door nandankuda, ngayu, ngayku kangkal-kangkal bedbakuda. Ngayu kari wandil baja, mayi dajinka yunu.’ ");
INSERT INTO gvn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yinyanguynku nyulu yunundu mayi kari dajil. Yundu nyungu jawun, yamba nyulu kari wandil. Yamba yundu nguba walngkurril baja, walngkurril baja mayika. Yinyaynka nyulu juma wandil, mayi manil, yunundu dajil, yundu kari murru-kadanya babajinka baja. ");
INSERT INTO gvn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Yanyu kuku yala yinya story. Kaki yundu yarbarrkaku babaji Godundu, nyulu yunundu dajilkuda. ");
INSERT INTO gvn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaki yundu Godundu babaji, yinya yala yundu nyunguwunbu doorngu dudan-dudaji. Nyulu door walngal, yunundu dajilkuda. ");
INSERT INTO gvn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kaki yunuwundu kangkalangka yunundu babaji minyaka kuyuku, yundu nyungu minya kuyukuda dajil, jarba kuliji kari dajil. ");
INSERT INTO gvn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kaki nyulu yunundu babaji minyaka diburrku, yundu nyungu minya diburrkuda dajil, munu-dumbun kari dajil. ");
INSERT INTO gvn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bama buyun bajaku, yamba jana mayi ngulkurr dajinka kangkal-kangkalanda. Bamangka janawunbu kangkal-kangkalanda mayi ngulkurr dajinka. Nyulu Nganjan jiringa jarra ngulkurr bajaku bamanka. Nyulu wawu jirray bamanda dajinka. Kaki bamangka nyungundu babaji nyunguwunku Wawuku, nyulu dajilkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yala, Jesusangka dubu kangan dingkarandamun dukurrmun. Dubungku dingkar kirinya kuku balkanka, nyulu dingkar kuku kari. Dubu dingkarandamun wandin, dingkarangka kuku balkan baja. Bamangka wubulinja yinya nyajin, kungkurr-kadarin. ");
INSERT INTO gvn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yamba kanbalda bamangka yalaman, “Nyulu dubu-dubu kangalkuda, yamba nyulu junkurr manil dubu-dubundumun majandamun.” Yamba jana jurrilman. ");
INSERT INTO gvn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yindu-yinduyngku nyungun nyuyanka. Yinyaynka jana yalaman, “Yundu junjuy miracle yalbay balka, milbinka Godungku yunu junkurr dajin.” ");
INSERT INTO gvn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yamba Jesus binal jana wanyu milkabu kujil-kujin. Yinyaynka nyulu jananda yalaman, “Kaki bama bubu-muruku jana-karrajiku ngami-ngamimal, jana junkurr karimal. Bama yindu-yindu kadari, jananji kuniwanka, jananin kunbay-manil. Kaki jawun-karra ngami-ngamimal, jana juma yamba-karimalkuda. ");
INSERT INTO gvn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kaki dubu-dubu jana-karrajiku kangaway, jana ngami-ngamimalkuda. Jana kunbayda, juma yamba-karimalkuda. Yurra balkal majangka dubundumundu ngayku junkurr dajil, dubu-dubu kanganka. ");
INSERT INTO gvn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yala, wanjungku yurrandamunbu jawun-karranda junkurr dajil, dubu-dubu kanganka? Majangka dubu-dubundumundu kari. Yamba yurrawundu jawun-karrangka dubu-dubu yalarrku kangal. Jana milbilda yurra wadu-waduku. ");
INSERT INTO gvn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kari, Godundumunduku Wawubuku nganya junkurrji-bungan, dubu-dubu kanganka. Yinyaynka yurra binalmanyaku ngayu Godundumun yurranda kadan. Yurra binalmanyaku Godungku nyungu bama ngulkurrduku kujinka. ");
INSERT INTO gvn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Kaki dingkarangka junkurrjimundu nyungu bayan, and yamba-yamba naybujiku miyil-kujil, wurrmay-bakangka kari ngakil. ");
INSERT INTO gvn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yamba yindu wurrmay-baka jarra junkurrji bajaku. Nyulu nguba kaday, nyungun kunil. Yinyayangka wurrmay-bakangka dingkaramu naybu nyungundumun manil, yamba-yamba ngakil, dajil nyunguwunbu jawun-karranda. ");
INSERT INTO gvn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kaki bama ngaykunku wawu kari, nyulu nganya buyun-damal. Kaki bamangka bama yindu-yindu kari mujal ngaykundu wundinka, nyulu jananin ngami-ngami-bungalkuda ngaykundumun.” ");
INSERT INTO gvn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesusangka yalaman baja, “Dubu nyubun nguba bamandamun wandil, bububurr marraldarr dungay, bama yindu warrmba-bunganka, walanka. Yamba nyulu nguba bama kari warrmba-bungal walanka. Nyulu dubu nyuluku balkawayda, ‘Ngayu dungay baja yinyayandaku ngaykuwunbuku bamandaku.’ ");
INSERT INTO gvn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nyulu dungay, nyajilda Godumu Wawu bamanda kari walanya. ");
INSERT INTO gvn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yinyamun nyulu dubungku dubu yindu-yindu 7-bala kunjalda, jana jarra buyun nyungunku. Jana wubulku nyungundu bamanda walalda. Yinyamun nyulu bama buyunmalarrku, jarra buyun jakalbaku.” ");
INSERT INTO gvn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesusangka yinya kuku balkan, nyubunyinja jalbungku yalaman, “Yunu ngamu wawurr-wawurrmaniji, yundu nyunguku kangkal.” ");
INSERT INTO gvn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yamba Jesusangka yalaman, “Nyulu wawurr-wawurrmanijikuda, yamba bama wawurr-wawurrku bundari, jana Godumu kuku nyajinya, yinya kuku wukurrinya.” ");
INSERT INTO gvn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jana bama wubul murumarin Jesusanda, nyulu yalaman, “Yurra wawu ngayu junjuy miracle milbinka Godundumundu junkurrdu. Yurra bama buyun bajaku, Godundumun jurrkijin. Yurra miracle nyajinka. Yamba ngayu kari milbil yurranda. Ngadiku Godungku junjuy miracle yalbay balkan prophetanka Jonahnka. Yurra yinya nyajin Godundumunbu kabanba. ");
INSERT INTO gvn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngadiku kuyungku yalbaynja Jonah yurmbin, waralba kujin. Warngku kulurman kuyungku kalji-manin Jonah bubungu. Jonah juranku. Yinyaynka jana bama Ninevehmun binalman Godungku Jonah yungan. Ngayu yala Jonah. Ngayu wulay, warngku kulurmal ngayu juranmal baja. Yinyaynka yurra binalmal ngayu Godundumun. Ngayu yaba bamanga wubulbuku. ");
INSERT INTO gvn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nyubun jalbu Queen of Sheba. Nyulu yurranin nyuyal Godundumunbu courtcasemunbu. Nyulu ngadiku nyunguwunmun bubumun kala-kalbaymun kadan, milka-jananka King Solomonanda. King Solomon binal bajaku. Queen of Sheba binalmanka kukumun King Solomonandamun. Ngayu jarra jirray King Solomonanka, yamba yurra ngaykundu kari milka-janan. ");
INSERT INTO gvn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yalarrku Jonah, nyulu townbu Nineveh dungan, bamanda balkan Godundumunku kukuku. Jana wubulduku Godumu kuku nyajin, buyun-buyunmun jurrkijinda Godundu. Ngayu jarra jirray Jonahnka. Yamba yurra bama wubulku nyiku bundandari, yurra nganya warmbil, kari believeim-bungal. Juma bama wubulku jakalba Godundu janay, courtcasemunbu. Yurra ngaykundu kari milka-jananya, bamangka Ninevehmunku yurranin nyuyal.” ");
INSERT INTO gvn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesusangka yalaman baja, “Kaki bamangka light wayjul, jana wuyar tablebu yijarril, bama bayanba walal, jana nyajinka. Jana light kari kanbil bucketmundu. ");
INSERT INTO gvn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kaki yunu miyil ngulkurr, yundu ngulkurrduku nyajil, junkayku dunganka, kari daranka. Yunu miyil yala yunu wawu. Kaki yunu wawu lightmunji, yundu binal junkayku dunganka, buyun-buyunmun jurrkijinka. Kaki yunu miyil buyun, yunu wawu lightmunji kari. Yundu yala nguwul-nguwulbu bundandayda. Yundu kurru-kurruku dunganji, daranji. Kaki yunu wawu buyun, yinya yala miyil buyun, yundu kari junkayku dungay. ");
INSERT INTO gvn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yinyaynka yundu mumbarmaka, miyil ngulkurrmaka, kari buyun-buyun wukurrika miyilda. ");
INSERT INTO gvn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kaki yunu wawu lightmunjirr, nguwul-nguwul kari, yundu Godunku wawu jirray, and yundu yunduku nyungundu mambarriji. Yinya yala lightmundu dayirrda bajaku yunun balbal-balbal.” ");
INSERT INTO gvn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesusangka yinya kuku kunbay-manin, nyubunyinja bamangka Phariseengka nyungundu babajin, “Yundu ngaykuwunbu bayanba kaday mayi nukanka?” Jesus nyungunji dungan, bundan, nukajinka. ");
INSERT INTO gvn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jana Pharisee-warra mara julurriji, mayi nukanjiku. Jana yalaku, janawunku lawmunku. Yinyayangka Phariseengka nyajin Jesus mara kari julurrijin, nyulu kungkurr-kadan. ");
INSERT INTO gvn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yinyaynka Majangka Jesusangka nyungundu yalaman, “Yurra Pharisee-warrangka plate and cup mumbarabuku julurril, yarbarrka dayirr-bungal-bungal. Yamba kananga dukurrbu and wawungu yurra buyun bajaku. Yurra kuli-baka, junjuy-junjuy ngakil, buyun bajaku. Yurra yulban julurrijinka, dayirrmanka, yamba yurra kari milkabu baykal yurranga wawu buyun. ");
INSERT INTO gvn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yurra kiru-kari, Godungku bangkarr ngalkalba balkan, yamba nyulu yalarrku wawu kananga balkan. ");
INSERT INTO gvn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kaki yurra mayi and yamba-yamba dajil bamanda money-karinda, yurranga wawu ngulkurrmalkuda. ");
INSERT INTO gvn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yurra Pharisee-warra, kuli jirray yurranda kaday. Yurra mayi manil gardenmun, sellim-bungal, money buban Godundu dajinka. Yinya ngulkurr, yurra Jew-warramu law yalaku wukurril. Yamba yurra Godumu kuku yalbay bayjal. Bama wanjarrmal, Godumu kuku wukurrinka? Nyulu must manun-manunmaka bamanka, yalarrku nyulu must Godunku wawumaka. Yurra Jew-warramu law wukurrikakuda, yamba yurra yalarrku Godumu kuku wukurrika. ");
INSERT INTO gvn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yurra Pharisee-warra, kuli jirray yurranda kaday. Yurra Jew-warrandamunbu churchmunbu dungari, yurra chairnga jakalba bundarinka, bamangka yurranin nyajinka. Kaki bamangka yurranin maku-nyajil baralba, yurra wawu jana yurranin bambanka maja. ");
INSERT INTO gvn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kuli jirray yurranda kaday. Yurra buyun bajaku, yamba yurra wawu bama milkanga kadanka yurra ngulkurr. Jana yurranka binal karikuda, balu yurra ngulkurrkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nyubun teacher lawmunku yinyaymba, nyulu yalaman, “Maja, yinyamundu kukubu nganjinan teacher-teacher yalarrku binda-damal-damal.” ");
INSERT INTO gvn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesusangka yalaman, “Yurra teacher-teacher lawmunku, kuli jirray yurranda kaday. Yurra Godumu law bawal, yindu-yindu law balkal yala yurrawunbu milkanga kaday. Yinya kari Godumu law, yamba yurra bama binal-bungal jana yinya law wukurrika. Yinya law yala junjuy kulngkul, bamangka murruji jarra-kulbanka, jananin nyarril. Yamba yurra teacher-teacherangka jananin kari helpim-bungal jarra-kulbanka. ");
INSERT INTO gvn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kuli jirray yurranda kaday. Yurra juljal prophet-prophetamu ngulkurrduku kujin-kujil, yamba yurrawundu nganjan-karrangka jananin prophet-prophet yarkinkaku kunin. ");
INSERT INTO gvn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yurra yurraku mala-yirrkay yurrawunku nganjan-karranka. Jana prophet-prophet yarkinkaku kunin, yamba yurra yinya bayjal. Jana prophet-prophet yarkinkaku kunin, yamba yurra jananga juljal nubil, kulji jirray yijarrinka. ");
INSERT INTO gvn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yinyaynka Godungku yalaku balkan ngadiku, ‘Ngayu Jew-warranda prophet-prophet and bama kukuji yungal. Jana Jew-warrangka kanbal yarkinkaku kunil, yindu-yindu jana wurrkay-manil, kuli dajil kanbalba.’ ");
INSERT INTO gvn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yinyaynka bama nyiku juranku warrngkal-warrngkal. Godungku yurranin warrngkay-manil, yurrawundu nganjan-karrangka ngadi bajaku prophet-prophet yarkinkaku kuninya. ");
INSERT INTO gvn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ngadimunku nyikurrku jana bama prophet-prophet yarkinkaku kunin. Nyubun jakalbamun, burri Abel jana kunin. Jarra nyiku jana Zechariah kunin Godundumunbu bayanba yubaku kuljingaku janaku minya wayjun Godunku. Yuwu, Godungku nyiku bama Jew-warra buyun-damal, jana bama prophet-prophet kuninya. ");
INSERT INTO gvn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Yurra teacher-teacher lawmunku, kuli jirray yurranda kaday. Yurra Godumu kuku kari junkaynjaku balkan bamanda, yurra kiraynjaku kujin. Yinyaynka jana kari binalman wuljaljiku heavenba juranku bundanka. Godungku nyungu jawun-karra ngulkurrduku kujinka, yamba yurra bama kanbin nyungu jawun-karramanka. Yinya yala yurra door nandan Godundumunbu bayanba, bama kari walanka. Yurra ngalkalba janjanay, yalarrku kari walal.” ");
INSERT INTO gvn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jana Jesusangka yinya bayan bawan. Wawu yinyamun jana teacher-teacher lawmunku and Pharisee-warra, jana Jesus murru-kangan, nyungundu kuku babajin nyungun catchim-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jana nyungun nyuyanka, kukubu walu ngangkal-ngangkal-bunganka. Nyulu junjuy wadu-waduku balkanyaku, jana nyungun karrbanyaku. ");
INSERT INTO gvn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bama wubul bajaku murumarin. Kanbalda jina nyarril-nyarrin. Jesusangka nyunguwunbu jawun-karranda yalaman, “Mumbarmaka Pharisee-warranka. Jana yala yeast. Bama yala yeast, jana bulu-durayku bundandari. Yurra kari bulu-durayku bundari yala Pharisee-warra. ");
INSERT INTO gvn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bama nguba jurrilmalmal nyulu junkayku bundanday, yamba juma bamangka wubulduku nyajil, nyulu buyunku bundanday. ");
INSERT INTO gvn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kaki yundu kuku kiraynjaku balkal nguwul-nguwulbu, bama wubulku juma binalmalkuda. Kaki yundu yayngkarabu balkal kananga bayanba, juma bama binalmal, yiringkurrku yirrkay.” ");
INSERT INTO gvn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesusangka yalaman baja, “Milka-janay. Ngayu yurranda balkalda, kari yinyilmaka bamanka yurranin yarkinkaku kuninka. Jana yurranga bangkarr kunil, yamba jana yurranga wawu can't kunil. ");
INSERT INTO gvn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yamba yurra Godunku yinyilmaka. Nyulu wawubu, nyulu bama yarkinkaku kunil, yungal bada-bada bayanga. Nyungunkuku yinyilmaka. ");
INSERT INTO gvn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Bamangka nguba dikal sparrow 5-bala buy-im-bunganka. Nyulu buy-im-bungal, moneybu bubanda. Dikal sparrow karrkay bajaku, yamba God jananka kari milka-wulay. ");
INSERT INTO gvn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Godungku yurranin yalarrku nyajin-nyajil, ngulkurrduku kujinka. Nyulu yurranka binal bajaku, nyulu yurranga mungka dukulbu countim-bungan. Yinyaynka kari yinyilmaka. Kaki nyulu dikal sparrow ngulkurrduku kujil, nyulu bama jarra mumbarabuku ngulkurrduku kujil. Nyulu bamanka wawu jirray.” ");
INSERT INTO gvn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesusangka yalaman baja, “Kaki bamangka nyubunyinja balkal bamanda wubulbuku, ‘Jesus ngayku maja, ngayu nyungun wukurril-wukurril,’ ngayu yinya kuku yalarrku balkalda Godundumunbu angel-angelanda. Nyulu nganya kari darrbil; ngayu nyungun kari darrbilkuda. Ngayu bamanga wubulbuku yaba. ");
INSERT INTO gvn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kaki bamangka bamanda balkal, ‘Jesus ngayku kari maja, ngayu nyungun kari wukurril,’ ngayu yalarrku Godundumunbu angel-angelanda balkal, ‘Nyulu bama ngayku kari.’ Ngayu bamanga wubulbuku yaba. ");
INSERT INTO gvn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ngayu yaba bamanga wubulbuku. Kaki bamangka kukubu nganya buyun-damal, Godungku yinya buyun-buyun kidal. Kaki bamangka kukubu Godumu Wawu dayirr buyun-damal, Godungku yinya buyun kari kidal. God kari bajaku milka-wulay. ");
INSERT INTO gvn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kaki yurra Godundumunji Wawuji, yurra ngayku jawun-karra. Jana yurranin nguba juma courtcasemunbu wundil jakalba maja-majanda jirrayanda, jakalba Jew-warranda janawunbu churchmunbu. Kari wawu-buyunmaka wanyu kuku jananda balkanka. ");
INSERT INTO gvn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kari. Godundumundu Wawubu yurranin binal-bungal wanyu kuku yurra jananda balkanka.” ");
INSERT INTO gvn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bama wubul yinyaymba. Nyubunyinja bamangka Jesusanda yalaman, “Teacher, ngalinyandamundu nganjanangka bubu and yamba-yamba bawan ngaykundu, and ngaykuwunbu yabanda. Yamba ngaykuwundu yabangka wubulku kujin. Yundu nyungundu balka, kanbal ngaykundu daya.” ");
INSERT INTO gvn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yamba Jesusangka nyungundu yalaman, “Yinya ngayku kari. Majangka yinduynjuku yinya kuku balka nyungundu. Ngayu yamba-yamba kari wamba bamanga.” ");
INSERT INTO gvn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesusangka bamanda wubulimbaku balkan baja, “Mumbarmaka. Kari jumbunmaka yamba-yambaka. Bama nguba money jirray, and yamba-yamba jirray wunay. Yinyamundu moneybu and yamba-yambabu nyungun kari wawurr-wawurr-bungal.” ");
INSERT INTO gvn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yinyamun Jesusangka jananda yanya story balkan, “Nyubun bama rich-bala bajaku, moneyji, yamba-yambaji, bayanji yalbaynji, bubuji. ");
INSERT INTO gvn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nyulu yalaku milkabu baykan, ‘Ngayu mayi jirray manin ngaykuwunmun bubumun. Ngayku bayan karrkay bajaku mayika jirraynka. Ngayu wanjarrmalda?’ ");
INSERT INTO gvn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yinyamun nyulu nyuluku yalaman, ‘Ngayu binalda. Ngayu bayan kulbal baja, jarra yalbayku ngaral. Yinyamun ngayu ngayku mayi jirray and yamba-yamba wubulku bayanba yijarril. ");
INSERT INTO gvn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yinyamun ngayu ngayuku yalaku balkal, “Ngayu walay bajaku. Ngayu mayiji, yamba-yambaji ngadingka bundanka. Ngayu bunday, mayi jirray nukal, kari workmaniji baja. Yalaku ngayu wawurr-wawurrku bundanka.” ’ ");
INSERT INTO gvn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yamba Godungku yalaman nyungundu, ‘Yundu kiru-kari bajaku. Nyiku wujurrbu yundu wulaykuda. Wawu wulanyamun, wanjungku yunu money, yunu mayi and yunu yamba-yamba manil? Yundu junjuy-junjuy yununji kari wundil.’” ");
INSERT INTO gvn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesusangka jananda yalaman, “Yurra kari jumbunmaka moneyka, yamba-yambaka, mayika. Kaki yurra yalaku bundanday, Godungku nyajil yurra kari milkanga Godunjiku bunday. Nyulu nyajil yurra kari milkanga yurrawunjiku wawujiku bunday.” ");
INSERT INTO gvn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yinyamun Jesusangka jawun-karranda yalaman, “Ngayu yurranda balkalda, kari wawu-buyunmaka mayika, banaka, kambika. ");
INSERT INTO gvn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kaki yundu juranku bunday, yinya enoughkuda, yalada. Kari wawu-buyunmaka mayika, kambika. ");
INSERT INTO gvn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dikalanda wajanda miyil-janay. Jana kari diburr nandal gardenba, mayi maninka. Yamba Godungku jananda mayi dajil. God yurranka wawu jirray jarra dikalanka. ");
INSERT INTO gvn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kaki bama wawu-buyunmal mayika yala kambika, nyulu kari bajaku ngadingka juranku bunday, wawu-buyunmanya. ");
INSERT INTO gvn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kaki Godungkuku ngananin ngulkurrduku kujil juranku bundanka, ngana junjuy-junjuy wubulku nyungundu bawa, junjuy-junjuy yalbay, junjuy-junjuy buban. Kari wawu-buyunmaka. ");
INSERT INTO gvn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ngadiku nyubun bama rich-bala, burri Solomon. Nyulu kambi jirray, kambiji mini-miniji, ngulkurr bajaku nyajiji. Yamba yanyu nganka jarra ngulkurrijin Solomonandamunku kambika. ");
INSERT INTO gvn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jikan jinbalku kabumal, bamangka wayjulda. Kaki Godungku jikan ngulkurrduku kujil, nyulu yalarrku ngananin ngulkurrduku kujil. Yurra God bubanku kuku nyajil-nyajil, yamba yurra must mumbarku Godundu milka-janayarrku. ");
INSERT INTO gvn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kari wawu-buyunmaka junjuynku. Kari yalamaka, ‘Ngananga mayi wanjamun? Bana wanjabu?’ Godungkuku yurranin ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bama Gentile-warra Godunku binal kari, jana milkanga junjuy-junjuynjiku bundanday. Yamba yurra kari yalaku bundarika. Nganjan yurranka binal yurra mayika, banaka, kambika. ");
INSERT INTO gvn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yinyaynka yurra Godngarr jakalba-bunga. Yinyamun nyulu yurranda dajilkuda, mayi, bana, juranku bundanka.” ");
INSERT INTO gvn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesusangka yalaman baja, “Kari yinyilmaka. Yurrawundu nganjanangka yurranin ngulkurrduku kujil. Yurra yala sheep. Nyulu Nganjan yala dingkar sheep ngulkurrduku kujil-kujil. ");
INSERT INTO gvn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dajiwaka bamanji yindu-yinduynji. Yamba-yamba sellim-bunga, money maninka. Yinyamun yurra money daya jananda bamanda money-karinda. Ngulkurrmaka, junkayku bunday. Yinya yala yundu junjuy-junjuy jakalba yungal wangkar-wangkar heavenba, yinyaymba kujinka. Yinyaymba kari buyun-damaji, wurrmay-baka kari walal, ngakinka. ");
INSERT INTO gvn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kaki yundu jumbundu bangkal, yundu milkanga moneyjiku bunday, milkanga junjuy-junjuynjiku. Kaki yundu junjuy-junjuynku kari jumbunku bunday, yundu milkanga Godunjiku bunday.” ");
INSERT INTO gvn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jesusangka jananda yanyu story balkan, “Majangka mayinga jirraymba weddingba dungan. Nyulu workingmananda yalaman, ‘Yurra kudamundu bundarika, bayan miyil-kuji. Ngayu late-bala kaday, nguba kunarangkalba. Yurra lightmunjiku bundarika, nganya kuji.’ Yala, nyulu maja nguwul-nguwuldurr kadan, nyunguwunbu jakuwaymba dudajin. Jana workingman kari warngku wunarin. Jana door jinbalku walngan majanka. Yurra yalaku yandaymaka, miyil-kuji yala jana workingmanangka. ");
INSERT INTO gvn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jana workingman wawurr-wawurrman, jana yandaymanya majanka. Nyulu maja yalarrku wawurr-wawurrman, jana kari warngku wunarinya. Nyulu jananin tablebu bunday-manil, mayi jirray dajil jananda. ");
INSERT INTO gvn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maja nguba kunarangkalba kaday, nguba mudu-wayjul-wayjul, yamba jana workingman wubulku wawurr-wawurrmal, jana maja miyil-kujinya. Yurra yalarrku miyil-janay yurrawunku majanka jiringa.” ");
INSERT INTO gvn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jesusangka yalaman baja, “Yurra binal kari wanja-wanja nyulu wurrmay-baka kaday bayanba walanka. Yurra binalmanyaku, yurra bayan mumbarabuku nandanyaku. ");
INSERT INTO gvn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yurra yalarrku ngaykunku yandaymaka. Yurra binal kari wanja-wanja ngayu kaday baja. Ngayu bamanga wubulbuku yaba.” ");
INSERT INTO gvn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peterangka babajin, “Maja, yinya story nganjinankaku jawun-karrankaku or wubulinkaku?” ");
INSERT INTO gvn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Majangka Jesusangka yalaman, “Yindu story nyakada. Yurra dukul ngalu-ngalumaka, yala yanyu bama yaluy storynga. Majangka nyubun workingman ngulkurr bamban foreman-bunganka yindu-yinduynku workingmananka. Nyulu bama foremanman, nyulu junkayku bundan, binal bajaku. Nyulu workingmananda yindu-yinduymbu work dajin, mayi dajin, jananin ngulkurrduku kujin. ");
INSERT INTO gvn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nyulu maja kala-kalbay dungan, kadan baja. Nyulu kadan baja, nyajin yinyayangka foremanangka wubulku ngulkurrduku kujinya, nyungu workingman. Nyulu foreman wawurr-wawurrmanijinda, majangka nyungun nyajinya ngulkurrduku kujinya. ");
INSERT INTO gvn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nyulu majangka foreman buyay-manin, yalaman, ‘Ngayu yunun maja-bungalda ngaykuwunku bayanka, yamba-yambaka, bubuku, wubulkuku.’” Jesusangka yalamanda, “Yurra junkayku bundarika, yalala nyulu foreman. ");
INSERT INTO gvn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yamba nyulu foreman nguba kari ngulkurrku bunday. Nyulu nguba nyuluku balkal, ‘Ngayku maja kariku kadan. Nyulu ngadiku kadanyaku. Nyulu nguba kari kaday baja. Ngayu ngaykuku maja.’ Yinyamun nyulu kulijimal; nyulu workingman, jalbu-jalbu kunil, mayi jirray nukal, kamu-kamu nukal. ");
INSERT INTO gvn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nyulu maja kadayda, yamba nyulu foreman binal kari nyulu kadanda. Nyulu kari miyilji bundanya, kari ngulkurrduku kujin-kujinya. Majangka nyungun foreman murru-kangalda, kunilda, nyungun yilbalda buyun-buyunyundu. Nyulu warrngkayda.” Jesusangka yinya story balkan, jananin binal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jesusangka yalaman baja, “Yala yinyay storynga, majangka kuku dajil workingmananda, yamba nyulu workingmanangka yinya kuku kari wukurril. Majangka yinya workingman yaykarrdaku wuybubu kulbal. ");
INSERT INTO gvn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yindu workingman nguba binal kari wanyu majangka balkan. Yinyaynka nyulu majamu kuku murruji wukurril, yamba nyulu still junjuy buyun-buyun-damal. Majangka nyungun jarra waymbulduku wuybubu kulbal, binal-karimanya. Kaki bama binal buban Godundumunku kukuku, Godungku wawu yinya bama nyajinka nyungu work buban balkanya. Kaki bama binal bajaku Godundumunku kukuku, Godungku yinya bama nyajinka nyungu work jirray balkanya. Yalarrku, kaki Godungku bamanda yamba-yamba jirray dajil, nyulu bamangka must yamba-yamba jirray yindu-yinduymbu bamanda daya.” ");
INSERT INTO gvn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Jesusangka jananda yalaman baja, “Ngayu yalaymba kadan wangkar-wangkarmun. Ngayu kadan yurranin ngulkurr-bunganka buyun-buyunmun. Yala bayabu rubbish wayjul-wayjul, ngayu yurranga buyun-buyun wayjul. Ngayu yinya baya wayjunku, yamba jakalba ngayu must warrngkay. Wawu nyikumun ngayu milka-bujarku dungan-dungay, warrngkanya. ");
INSERT INTO gvn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bamangka nguba milkabu wukurril ngayu bubungu kadan bama wubulku jawun-jawun-bunganka, jananin muru-bunganka. Kari. Yala kari. Ngayu kadan jananin ngami-ngami-bunganka. Kanbal ngaykunku wawu, kanbal kari. ");
INSERT INTO gvn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bayanba nyubunyimba nguba bama 5-bala bundandari. Kulur nguba wawu kari jambulinka. Wanyurrinku jana wawu kari? Kanbal ngaykundu mambarrijinya, kanbal kari. Yinyaynka jana kari wawumal. ");
INSERT INTO gvn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nganjan nguba kangkalanka warrunku kari wawumal. Kangkal warru nguba nganjananka wawu kari. Ngamu nguba kangkalanka maralanka kari wawumal. Kangkal maral nguba ngamunku wawu kari. Nguba kujiway biwulunku kari wawumal. Biwul nguba kujiwaynka wawu kari. Kanbalda nganya wukurrinka, kanbalda kari. Yinyaynka jana kari wawumal.” ");
INSERT INTO gvn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesusangka yalaman baja, “Kaki yurra ngurrban naka nyajil, yurra binalda juma kaba kadayda. ");
INSERT INTO gvn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yurra muyar nyajil kuwamun kadanya, yurra binalda, wumbulmalmalda. ");
INSERT INTO gvn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yurra bulu-durayku bundanday. Yurra binal ngurrbanka jiringa, and muyaraka, yamba yurra binal kari Godundumunku kukuku. Yurra binal kari wanyu nyulu yurranda nyiku balkanka.” ");
INSERT INTO gvn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesusangka yalaman baja, “Yurra kari junkaynjaku milkabu wukurril, wadu-wadubuku. Yurra junkaynjaku milkabu wukurrika. ");
INSERT INTO gvn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bamangka nguba yunun courtcasemunbu wundinka. Nyulu yunun wundinjiku, yundu nyungunji balkawaka, jawun-jawunmanka. Nyulu nguba milka-wulay yunuwunku buyun-buyunku, yunun kari courtcasemunbu wundil baja. Kaki yundu nyungunji kari balkaway, nyulu yunun courtcasemunbu wundilkuda. Maja courtcasemunbu, nyulu yunu fine dajil. Kaki yundu kari payim-bungal, jana yunun jailba mumbalkuda. ");
INSERT INTO gvn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kaki yundu yunu fine kari payim-bungal, jana yunun kari walngal jailmun.” ");
INSERT INTO gvn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yala-yala kanbal bama Jesusanda kadarin. Jana yalaman, “Bama bubumun Galileemun kadarin townbu Jerusalem. Jana kadarin minya wayjunku Godunku Godundumunbu bayanba. Jana wayjul-wayjun, Pilateangka soldier-soldier yungan, jananin yarkinkaku kunin.” ");
INSERT INTO gvn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesusangka jananda babajin, “Yurra milkabu wukurrika, yala jana Galilee-warra yarkinkaku kunijin janawunku buyun-buyunku? Yurra milkabu wukurrika. Yala jana jarra buyun bajaku yindu-yinduynku Galilee-warranka? ");
INSERT INTO gvn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kari bajaku. Ngayu yurranda balkalda, kaki yurra yurrawunmun buyun-buyunmun kari jurrkiji, yurra wubulku wulari yala jana.” ");
INSERT INTO gvn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jesusangka yalaman baja, “Milkabu wukurrika jananin bama bayanba townbu Siloam. Bayan daran, bama 18-bala nyarrinkuda. Yurra milkabu bayka, yala jana yarkinkaku kunijin janawunku buyun-buyunku? Yala jana jarra buyun bamanka yindu-yinduynku Jerusalem-warranka? ");
INSERT INTO gvn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kari bajaku. Ngayu yurranda balkalda, kaki yurra yurrawunmun buyun-buyunmun kari jurrkiji, yurra yalarrku wulari, yala jana wularin.” ");
INSERT INTO gvn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wawu yinyamun Jesusangka jananda yanyu story balkan. “Nyubunyinja bamangka diburr mangku gardenba nandan. Jurrbu wandin, dakan. Nyulu bama juma dungan mayi maninka, yamba mayi kari balkajin. ");
INSERT INTO gvn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nyulu nyunguwunbu workingmananda yalaman, ‘Ngayu 3 years kujil-kujin mayi maninka yinyamun jukumun, yamba mayi yamba-kari. Yundu juku nyanda, room dajinka jukungu yinduymbu.’ ");
INSERT INTO gvn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yamba yinyayangka workingmanangka yalaman, ‘Kariku nyanda, maja. Bawa baja nyubunyinka yearka. Ngayu bubu bakal, bubu birrajiku nyangarril ngaranga. ");
INSERT INTO gvn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nguba mayi balkaji next year. Kaki mayi kari balkajida, yundu ngaykundu balka baja juku nyandanka.’ Yala yinya juku, Godungku bamanga chance dajinka baja, junkayku dunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Saturday kadan, Jesus Jew-warrandamunbu churchmunbu walan. Yinyaymba nyulu bama binal-bungan-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nyubun jalbu yinyaymba bundandan, nyulu dubunji. Jalbu muku badaman, can't junkaymanya. Nyulu 18 years yalaku dungan-dungan dubunji. ");
INSERT INTO gvn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesusangka nyungun nyajin, nyulu nyungundu yalaman, “Jalbu, yundu junkayku janay, kari badamaka baja.” ");
INSERT INTO gvn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nyulu nyungun marabu karrbanda, nyulu jalbu jinbalku junkayku janan, kari badaman baja. Nyulu God buyay-maninda. ");
INSERT INTO gvn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Maja churchmunku kuli-kadan, Jesusangka jalbu ngulkurr-bunganya Saturdaymunbu. Yinyaynka nyulu bamanda wubulimbaku yalaman, “Week day 6-bala ngana workmaka. Yurra yala-yalabi kaday, nyulu yurranin ngulkurr-bunganka. Kari Saturdaynga.” ");
INSERT INTO gvn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Majangka Jesusangka yalaman, “Yurra bulu-duray bajaku. Kaki yurra yarraman or bulki karrabu kajal Saturdaynga, yurra nyungun walngal, wundinka bananga. ");
INSERT INTO gvn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yanyu jalbu kajajin dubundu 18 years. Nyulu jawun-karrandamun Abrahamandamun. Dubungku nyungun kajan, buyun-daman. Yinya ngulkurr ngayu nyungun walngan, ngulkurr-bungan, Saturdaynga.” ");
INSERT INTO gvn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jana maja-maja Jew-warrandamunku churchmunku murru-kadarin yinyaynka kukuku. Yamba bama yindu-yindu wawurr-wawurrman, Jesusangka jalbu ngulkurr-bunganya. ");
INSERT INTO gvn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesusangka jananin binal-bungan baja. Nyulu babajin, “Godungku nyungu jawun-karra ngulkurrduku kujil, yinya yala wanyu? ");
INSERT INTO gvn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yinya yala yanyu story. Nyubunyinja dingkarangka diburr karrkay bajaku nandan nyunguwunbu gardenba. Jurrbu wandin, yalbaymalman. Juma yinya jurrbu karrkay juku yalbaymankuda. Jana dikalangka bulka ngaran nyunguwunbu dakilba.” ");
INSERT INTO gvn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus babajin baja, “Godungku nyungu jawun-karra ngulkurrduku kujil, yinya yala wanyu? ");
INSERT INTO gvn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yinya yala jalbungku mayi bread dingkal-dingkal. Nyulu buban yeast dingkal bulawumunji. Yeastmundu bubanda bulawu wubay-manilkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Wawu yinyamun Jesus townbu Jerusalem dungan. Nyulu dungan-dungan, nyulu bama binal-bungan townbu yindu-yinduymbu. ");
INSERT INTO gvn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nyubun bama Jesusanda babajin, “Maja, Godungku nguba bamamu kulurumu wawu juran-bungal?” Jesusangka yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yurra doormundurr darraburr dungarika Godundumunbu bubungu. Bama wubul yinyamundurr doormundurr dungarinka, yamba jana murruji dungari, darrakuda. ");
INSERT INTO gvn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nyulu majangka bayanka yinya door nandal. Yurra ngalkalba janay, door dudal, yalamal, ‘Maja, door walnga nganjinanka.’ Nyulu kanamundu bayanmundu yalamal yurranda, ‘Kari. Ngayu yurranka binal kari.’ ");
INSERT INTO gvn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yurra nyungundu majanda balkalda, ‘Nganjin yununji mayi nukan, yununji bana nukan. Yundu bama binal-bungan nganjinandamunbu townbu.’ ");
INSERT INTO gvn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yamba nyulu majangka yalamal baja, ‘Ngayu yurranka binal kari. Dungarikada. Yurra wubulku bama buyun.’ ");
INSERT INTO gvn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yurra jananin Abraham, Isaac, Jacob, prophet-prophet ngadimunku nyajil Godundumunbu bubungu bundandanya. Yamba yurra murruji walal. Majangka yurranin ngalkalba yilbal. Yinyaynka yurra badi, yurra yurraku dirra majaji. ");
INSERT INTO gvn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Godumu bama wubulku yiringkurrmun kadari, jibarrmun, kuwamun, nakamun. Jana mayinga jirraymba bundari Godundumunbu bubungu. Yamba yurra murruji walal. ");
INSERT INTO gvn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bama nguba majamanka Godundumunbu bubungu. Godungku nyungun kari maja-bungal. Bama yindu nguba wawu kari majamanka, nyulu yindu-yindu helpim-bunganka. Godungku nyungunkuda maja-bungal nyunguwunbu bubungu.” ");
INSERT INTO gvn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yala-yalaku kanbal Pharisee-warra Jesusanda kadarin, nyungundu yalaman, “King Herodangka yunun yarkinkaku kuninka. Yundu yanyu bubu bawa, bubungu yinduymbu dungay.” ");
INSERT INTO gvn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesusangka jananda yalaman, “Nyulu Herod yala kaya dingku. Yurra dungarika, yinyayanda kulijinda balka, ‘Nyulu Jesusangka dubu-dubu kangan-kangal, and nyulu bama ngulkurr-bungan-bungal bambaymun. Wunkun nyulu yalarrku yinya workmalmal. Wunkun-yindu nyulu nyungu work yalaymba kunbay-manil.’ ");
INSERT INTO gvn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ngayu kari warri majandamun Herodandamun. Yamba ngayu townbu Jerusalem dungan-dungayda. Ngayu dungan-dungay, ngayu bama binal-bungal, jananin ngulkurr-bungal bambaymun. Wunkun, wunkun-yindu ngayu yinya work balkal bubungu Galilee. Jana nganya kari yarkinkaku kunil yaluy bubungu Galilee. Nganga townbuku Jerusalemku jana Godumu prophet-prophet yarkinkaku kunil.” ");
INSERT INTO gvn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wawu yinyamun Jesus milkabu wukurrin bama townbu Jerusalemmunbu. Nyulu yalaman, “Yurra Jerusalem-warra, yurra prophet-prophet yarkinkaku kunin. Yurra kuljibu kunil bama kukuji Godungku yurranda yungan. Ngayu milka-bujarmal yurranka. Ngayu yurranin wubulku wawu ngulkurrduku kujinka, yala ngamungku jukijukingka nyungu kangkal-kangkal nangkinga muru-bungal, kujilkuda. Yamba yurra nganya kari mambarrin. ");
INSERT INTO gvn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yinyaynka Godungku yurranga bubu bawal, yurranin kari ngulkurrduku kujil baja. Yurra nganya kari nyajil baja, until ngayu kadanyamunku baja. Ngayu kaday baja, yurra nganya nyajilda, yalamalda, ‘Nyakada, nyulu kankadayda yaluy Godundumunji junkurrji. Nyulu kankadayda, ngana nyungun yulmbarrinka, buyay-maninka.’” ");
INSERT INTO gvn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Saturdayman Jesus majandamunbu Phariseendamunbu bayanba dungan, mayi nukanka. Bama yindu-yindu yinyaymba. Jana nyungun kunkun-bungan, nyajinka nyulu nguba buyun-damanya. ");
INSERT INTO gvn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yinyaymba bayanba nyubun bama bambay bundan. Nyungu mara, jina wubajin. Nyulu Jesusanda kadan, ngulkurrmanka. ");
INSERT INTO gvn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jana Jew-warra kari workmanijin Saturdaymunbu janawunku lawmunku. Yinyaynka Jesus jananda teacher-teacheranda lawmunku and Pharisee-warranda babajin, “Yalada ngana bama ngulkurr-bungal bambaymun Saturdaynga? Nganawundu lawbu kiril or kari?” ");
INSERT INTO gvn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yamba jana wubulku jankaku bundarin, nyungundu kari kuku balkan. Jesusangka dingkar marabu karrban, nyungun ngulkurr-bungan bambaymun, yinyamun bayanmun yungan. ");
INSERT INTO gvn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yinyamun nyulu jananda yalamanda, “Kaki yurranga kangkal or bulki bulkajimunbu yalbaymba daray Saturdaynga, yurra wanjarrmal? Yurra jinbalku nyungun wangkar kulbal, walngal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jana yinya kuku nyajin, jana jankaku bundarin, kuku-karimarin. ");
INSERT INTO gvn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jana mayinga kadarin, Jesusangka nyajin jananin wubulku maja-majandamunbu chairnga bundanka. Yinyaynka nyulu jananin storybu binal-bungan. Nyulu yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kaki bamangka yununin kunjal mayika jirraynka weddingmunku kadanka, yundu kari majandamunbu chairnga bunday. Nguba juma maja jarra jirray kaday. ");
INSERT INTO gvn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Majangka bayanka nyungun wundil, yunundu balkal, ‘Ya, yundu yinduymbu chairnga bunday. Ngayu wawu yanyu maja jirray yinyaymba chairnga bundanka.’ Yundu murru-kadayda, chairnga bubanba bunday. ");
INSERT INTO gvn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kari, yala kari. Jana yunun mayinga kunjal, yundu jakalba chairnga bubanbaku bunday. Nguba juma maja bayanka yunundu kaday, yalamalda, ‘Yundu ngayku jawun, yundu kari yinyaymba bundanyaku. Ngayu wawu yundu yaluy majandamunbu chairnga bundanka.’ Jana bamangka yinya nyajil, jana binalda yundu majakuda. ");
INSERT INTO gvn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kaki bama nyuluku jirray-bungaji, Godungku nyungun buban-bungal. Kaki bama nyuluku buban-bungaji, Godungku nyungun jirray-bungal.” ");
INSERT INTO gvn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yinyamun Jesusangka yinyarrinyanda Pharisee-warranda balkan, “Kaki yundu mayi yalbay-bunganka, kari kunja yunuku jawun-karraku. Kari kunja bama rich-balaku. Kari. Jana yunun kunjal baja, jananji nukanka baja. Yinya yala yunu pay. ");
INSERT INTO gvn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kaki yundu mayi yalbay-bunganka, yundu jananin bama kunja money kari. Yundu jananin barrka-buyun, miyil-burra, jananin bambay-bambay kunja. ");
INSERT INTO gvn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kaki yundu yalanguy bama kunjal yununji nukanka, yundu wawurr-wawurrmal, jana yunu murruji mayi dajinya baja. Godungkuku yunundu dajil baja. Nyulu wanja-wanja dajil baja? Juma bama ngulkurr juranmal baja yarkin-yarkinmun. Yala-yala nyulu yurranin dajil baja.” ");
INSERT INTO gvn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nyubun dingkar tablebu bundandan, nyulu yinya kuku nyajin, yalaman, “Juma kanbalda bamangka mayi yalbay nukal Godunji heavenba. Jana wawurr-wawurrmalkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesusangka yanyu story balkanda jananda. Nyulu yalaman, “Ngadiku nyubunyinja bamangka mayi jirray bajaku wayjun. Nyulu bama wubul kunjan nyungunji nukajinka. ");
INSERT INTO gvn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mayi wayjujin, nyulu nyungu workingman yungan bama kunjanka. Nyulu workingmanangka yalaman bamanda wubulbu, ‘Kadayda, mayi wayjujinda.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yamba jana wubulku wawu kari kadarinka. Yinyaynka jana jurrilman. Nyubunyinja yalaman, ‘Ngayu kari kaday, ngayu bubu buy-im-bunganya. Ngayu dunganka, nyajinka.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yinduynju yalaman, ‘Ngayu bulki wubul buy-im-bungan. Ngayu kari mayinga kaday, dunganka bulki nyajinka.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yinduynju yalaman, ‘Ngayu jarra nyiku marrymanijin. Yinyaynka ngayu kari kaday.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Nyulu workingman bayanbaku dungan, majanda balkan jana mayinga kari kadanka. Nyulu maja kuli-kadanda. Nyulu workingmananda yalaman, ‘Jinbalku townbu dungay, jananin kunja money kari. Yalarrku jananin barrka-buyun, and miyil-burra kunja mayika.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nyulu workingman jinbalku dungan, bama wubul mayinga wundin. Nyulu majanda yalaman, ‘Ngayu bama wubul wundin, yamba bayan jirray bajaku, roommunjiku yindu-yinduynku.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yinyaynka majangka workingmananda yalaman, ‘Yundu dungay baja, bama ngalkalmun townku kunja mayika. Kaki jana wawu kari kadanka, jananda balka baja, balka baja. Ngayu bayan jakal-bunganka.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yinyaynka majangka yalamanda, ‘Jananin bama ngayu mayinga kunjan jakalbaku, jana yinyarrinyangka ngayku mayi kari nukal baja.’” ");
INSERT INTO gvn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nyulu Jesus dungan-dungan, bama wubul bajaku nyungunji dungan-dungarin. Jesus jurrkijin, bamanda yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bama nyubun nguba nganjananka, ngamunku, manyarranka, kangkal-kangkalanka, yabaju-karranka, babarr-karranka, nyunguwunkuku wubulkuku wawu jirray, yamba nyulu ngaykunkulu jarra yala. Yinyaynka nyulu nganya kari maja-bunganya, nyulu ngayku kari bama. ");
INSERT INTO gvn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kaki bama ngayku bamamal, nyulu yanyu kuku milkabu wukurrika. Kanbalda bamangka ngaykuwunbu bamanda kuli dajil, kanbal kunil, warrngkay-manil, ngayku bamamanya. Kaki bama wawu kari ngaykunku warrngkanka, wawu kari ngaykunku wulanka, nyulu ngayku kari bama.” ");
INSERT INTO gvn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jesusangka yanyu story balkan. Nyulu yalaman, “Kaki bamangka bayan yalbay ngaranka, nyulu milkabu wukurrika moneyka. Nyulu money countim-bungal, nyajinka enoughkuda bayan kunbay-maninka. ");
INSERT INTO gvn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kaki money buban, nyulu nguba floorku ngaral, yamba nyulu money-karimal bayan kunbay-maninka. Bamangka yinya floor nyajil, jana nyungun yajarril, yalamalda, ");
INSERT INTO gvn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Yinyangka bamangka bayan ngaranka, yamba nyulu kari kunbay-manin.’” ");
INSERT INTO gvn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jesusangka yindu story balkan baja, “Nyubun king soldier-soldier buban, 10000-bala. Juma nyulu kuku nyajin, king yindu kankadan nyungunji kuniwanka. Yindu king soldier-soldier jirray, 20000-bala. Yinya king soldier-soldier buban, nyulu kari jinbalku nyunguwunbu soldier-soldieranda balkan dunganka, jananji kuniwanka. Kari, nyulu jakalba yalaku milkabu wukurrin, ‘Ngayku soldier-soldier buban, nyungu soldier-soldier jirray. Jana ngananin yarkinkaku kuninji.’ ");
INSERT INTO gvn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yinyamun nyulu kanbal soldier-soldier kukuji yungan yinduymbu kinganda, nyulu kala-kalbayku. Nyulu yalaman, ‘Ngana kari kuniwaka. Ngayu yunu money jirray, yamba-yamba jirray dajil. Yinyamun ngana jawun-jawunku bundari.’” ");
INSERT INTO gvn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesusangka yalamanda, “Kaki yurra ngayku bamamanka, yurra yalarrku mumbarabuku milkabu wukurrika. Yurra nguba junjuy-junjuy-baka. Nguba wawu kari bawanka jawun-karra, yamba-yamba, money, kamu-kamu. Kaki yurra yinyanguynku junjuy-junjuynku wawu jirray, yurra kari ngayku bamamalkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesusangka yalaman baja, “Bamangka mayi and minya ngulkurr-bungal saltmundu. Kaki salt buyunmal, yundu kari ngulkurr-bungal baja. ");
INSERT INTO gvn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kaki salt buyunmal, yinya yala rubbish, buyun bajaku. Yundu buyun salt yilbal rubbish tipmunbu. Yurra yanyu kuku nyajilda, yurra binalmakada. Kari bunday yala yinya salt buyun.” ");
INSERT INTO gvn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Juma bama wubul kadarin, Jesusamu kuku nyajinka. Kanbalda tax money mujan Governmentamu, kanbal bama buyun. ");
INSERT INTO gvn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jana Pharisee-warra, teacher-teacher lawmunku, jana kuli-kadarin. Jana yalaman, “Nyulu bama buyun kunjal, jananji mayi nukal-nukal.” ");
INSERT INTO gvn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yinyaynka Jesusangka jananda yinya story balkan. ");
INSERT INTO gvn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nyulu yalaman, “Nguba bama nyubun sheepmunji wubuljiku, 100-balanji. Yamba nyubun sheep nubijin. Nyulu bama wanjarrmalda? Nyulu kanbal bawal, jikanba nukal-nukajinya. Nyulu dungayda, nubinka yinya sheep nyubun nubijinya, juma warrmba-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nyulu warrmba-bungal, nyulu wawurr-wawurrmal. Nyulu bindanga-bungal, ");
INSERT INTO gvn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bayanbaku jarra-kulbalda. Yinyamun nyulu jawun-karra kunjal, jananda balkal, ‘Ngayku sheep nubijin, yamba ngayu warrmba-bungan baja. Ngana wubulduku mayi nukankada, wawurr-wawurrmanijida.’ ");
INSERT INTO gvn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yala yinya story sheepmunku, kaki nyubun bama buyun nyuluku Godundu jurrkiji, jana angel-angel heavenba wawurr-wawurrmal. Jana nyungunku wawurr-wawurrmalarrku. Jana angel-angel bamanka 99-balanka ngulkurrku wawurr-wawurrmanijikuda, yamba nyungunku buyunyunku jana wawurr-wawurrmalarrkukuda, nyulu buyunmun Godundu jurrkijinya.” ");
INSERT INTO gvn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesusangka yindu story balkan baja. “Jalbu nyubun nguba moneyji silverji 10-balaji, yamba nyubun nubijin. Nyulu jalbu wanjarrmalda? Nyulu light wayjul, bubu kidal, yiringkurrku nubil-nubil, juma nyulu warrmba-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nyulu warrmba-bungal, nyulu jawun-karra wubulku kunjal, balkalda, ‘Ngayu wawurr-wawurrmalda, ngayku money nyubunku warrmba-bunganya. Ngana wubulku wawurr-wawurrmalda.’ ");
INSERT INTO gvn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yala yinya story moneyka, Godumu angel-angel wawurr-wawurrmal bama buyun Godundu jurrkijinya.” ");
INSERT INTO gvn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesusangka yalaman baja, “Dingkar nyubun kangkalji jambulji. Bula yaba-yabaju. ");
INSERT INTO gvn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yabajungku nganjananda yalaman, ‘Nganjan, yundu ngalinyanga bubu, and yamba-yamba dayada, ngayku share ngaykundu dayada.’ Yinyaynka nyulu nganjanangka wubulku dajin, bulanda kangkalba dajin. ");
INSERT INTO gvn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Warngku kulurman, nyulu yabajungku nyungu bubu sellim-bungan, money manin, bulanin nganjan, and yaba bawan. Nyulu bubungu kala-kalbaymba dungan. Yinyaymba nyulu moneybu buyun way wukurrin, kamu-kamu nukan, money buyun-daman, wasteim-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Juma nyulu money-kariman. Wawu yinyamun kaba kari kadan baja yinyaymba bubungu. Yinyaynka mayi bubanman. Nyulu yabaju money kari, dakwuymankuda. Nyulu workmunbu nubil-nubijinda. ");
INSERT INTO gvn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dingkar nyubun yinyaymba bikibiki wubul. Nyulu dingkarangka yabajundu work dajin, bikibiki miyil-kujinka. ");
INSERT INTO gvn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yabajungku bikibiki nyajin, mayi nukal-nukanya. Nyulu dakwuyku bundandan, mayi bikibikimu nukanka, yamba bamangka nyungundu mayi kari dajin. ");
INSERT INTO gvn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Juma nyungundu dukulbu kadan, ‘Ngaykuwunbu nganjanandamunbu workingmanamu mayi jirray, yamba ngayu yaluy dakwuyku bunday, mayi kari bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngayu nganjanandaku dungay, nyungundu balkal, “Nganjan, ngayu yunun buyun-daman. Ngayu yalarrku God buyun-daman. ");
INSERT INTO gvn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngayu murru-kaday ngaykuwunku buyun-buyunku. Yundu nganya karida kangkal bamba, nganya workingman bamba.” ’ ");
INSERT INTO gvn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nyulu yalaku milkabu wukurrin, yinyamun nyulu wandin, nganjanandaku dunganka baja. “Nyulu bayanbaku kankadan, nganjanangka nyungun nyajin kala-kalbaymun kankadanya. Nyulu jiba-badin, manun-manunman kangkalanka. Nyulu nyungundu warrin, baru karrban, wawurr-wawurrmanda. ");
INSERT INTO gvn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yabajungku yalaman, ‘Nganjan, ngayu yunun buyun-daman, yalarrku ngayu God buyun-daman. Nganya karida kangkal bamba.’ ");
INSERT INTO gvn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yamba nganjanangka workingman kunjan, yalaman, ‘Jinbal, kambi ngulkurrku wundi, nyungundu dida. Ring wundi, maranga dida. Dambal nyunguwunbu jinanga dida. ");
INSERT INTO gvn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yinyamun yurra bulki wandul kuni, mayi jirray wayjunku. Ngana mayi jirray nukanka, wurinka. ");
INSERT INTO gvn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yanyu kangkal yala wulan, yamba nyulu yala juranman baja. Nyulu yala nubijin, yamba nyulu warrmbaman baja.’ Yinyamun jana mayi yalbay nukan. ");
INSERT INTO gvn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Yala-yala nyulu yaba ngalkalba paddockmunbu workmalman. Nyulu bayanbaku kankadan, nyulu jananin nyajin wulngku banbadinya, wurinya. ");
INSERT INTO gvn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yinyaynka nyulu nyubun workingman kunjan, nyungundu babajin, ‘Jana bama wanjarrmalmal?’ ");
INSERT INTO gvn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nyulu workingmanangka yalaman, ‘Yunu yabaju bayanbaku kadan baja. Yunuwundu nganjanangka bulki wandul kunin, yabaju ngulkurrku bayanbaku kadanya.’ ");
INSERT INTO gvn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nyulu yaba kuli-kadan, kari bayanba walan. Yinyaynka nganjan ngalkalba kadan, yaba walay-maninka. Yamba yaba kari walan. ");
INSERT INTO gvn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yabangka nganjananda yalaman, ‘Yundu nyaka. Ngayu ngadi bajaku yunundu workmanijin, yala slave. Ngayu yunu kuku mumbarabuku wukurrin. Yundu ngaykundu wanyu dajin workmunku? Yamba-karibi! Yundu minya kari dajin, ngayu jawun-karranji nukanka. Minya karrkay yala nanny goat yundu kari dajin. ");
INSERT INTO gvn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yamba yunu kangkal, ngayku yabaju, nyulu maral-maral buyun wunanan, yunu money wasteim-bungan, buyun-daman. Yinya kangkal bayanbaku kadan baja, yundu minya bulki wandul kunin, mayi jirray wayjun, nyungun wawurr-wawurr-bunganka.’ ");
INSERT INTO gvn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nganjanangka yabanda yalaman, ‘Yundu ngayku kangkalkuda, yundu wuljaljiku ngaykunji. Yanyu bubu, yamba-yamba, money, wubulku yunuda. ");
INSERT INTO gvn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yamba yunu yabaju, nyulu yala nyulu juranman baja juljalmun. Nyulu nubijin, ngana nyungun warrmba-bungan baja. Yinyaynka ngana mayi yalbay wayjunku nyungunku.’” ");
INSERT INTO gvn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesusangka jawun-karranda yanyu story balkan, “Nyubun bama money jirray. Nyulu yindu bama foreman-bungan nyunguwunku bubuku, nyunguwunku yamba-yambaka. Yamba bamangka money-jirrayanda balkan yinyaynka foremananka. Jana nyungundu yalaman, ‘Yinyangka foremanangka yunu money wasteim-bungal-bungan.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Money-jirrayangka foreman kunjan, nyungundu yalaman, ‘Ngayu kuku nyajin yundu ngayku money wasteim-bungan. Yundu kaban yunuwunku workmunku ngaykundu wundi. Ngayu nyajinka yundu wanjarrman ngaykuwunku moneyka, ngaykuwunku yamba-yambaka. Yinyamun yunu work kunbayda. Yundu kari ngaykunku workmaniji baja.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yinyangka foremanangka nyuluku yalamanda, ‘Ngayu wanjarrmal? Ngaykuwundu majangka nganya kangal. Ngayu junkurrji kari, bubu bakanka. Ngayu murru-kaday mayika babajinka. ");
INSERT INTO gvn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kari. Ngayu binalda wanjarrmanka ngayku work kunbay. Ngayu jawunmanka bamanji wubulinji. Juma ngayu work kari, jana nganya ngulkurrduku kujinka.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Yinyaynka nyulu bama wubulku kunjan, richmanamu money oweim-bungan. Nyulu jananji nyubun-nyubunyinjiku balkawan. Nyulu nyubunyimba yalaman, ‘Yundu wanjarr money oweim-bungal rich-balanda?’ ");
INSERT INTO gvn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nyulu yalaman, ‘Ngayu nyungundu olive oil jirray oweim-bungal, 100 drums.’ Nyulu foremanangka nyungundu yalaman, ‘Yundu tablebu bunday, jarra buban kabanba balka, 50 drums.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yinyamun nyulu foremanangka bamanda yinduymbu babajin, ‘Yundu rich-balanda wanjarr money oweim-bungal?’ Nyulu yalaman, ‘Ngayu nyungundu mayi wheat jirray oweim-bungal, kurmun 100-bala.’ Foremanangka nyungundu yalaman, ‘Yanyu yunu kaban, yundu jarra buban kabanba balka, kurmun 80-bala.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Yala, nyulu rich-balangka yinya kuku nyajin foremananka, nyulu yinya foreman ngalu-ngalu nyungundu kunjan. Nyulu yalaman, ‘Yundu dukul-ngulkurr. Yundu jawunman bamanji, jana yunun juma ngulkurrduku kujinka.’” Jesusangka jananda wubulbuku balkan baja, “Jana bama Godumu kari, jana yamba-yambaka jarra dukul-ngulkurr Godundumunku bamanka. Jana janawundu yamba-yambabu jawun-bungal, jawunyungku jananin juma ngulkurrduku kujinka. Jana milkabu wukurril, janaku yalamal, ‘Wanjungku ngananin juma ngulkurrduku kujinka?’ Godundumundu bamangka yalarrku milkabu wukurrika heavenba dunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesusangka yalaman baja, “Ngayu yurranda balkal, yurra yurranga yamba-yamba bamanda daya, jana yurranga jawunmanka. Juma yurranga yamba-yamba kunbay, Godungku yurranin yulmbarril heavenba. Yurra wulay, yurra junjuy-junjuy yala money and yamba-yamba kari wangkar heavenba wundil. ");
INSERT INTO gvn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kaki bamangka bamanga yinduymbu money buban mumbarabuku kujil, nyulu yalarrku nyungu money jirray mumbarabuku kujil. Kaki nyulu bamanga yinduymbu money buban kari mumbarabuku kujil, nyulu yalarrku nyungu money jirray kari mumbarabuku kujil. ");
INSERT INTO gvn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kaki yurra bamanga yinduymbu money, and yamba-yamba kari ngulkurrduku kujil, Godungku wanjarr yunun trustim-bungal? Yamba-karikuda. ");
INSERT INTO gvn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yamba-yamba and money yurrawunbu bayanba wunay, yurranga kari. Kari. Godungku yurranda dajin, yurra mumbarabuku ngulkurrduku useim-bunganka. Kaki yurra yinya yamba-yamba and money kari ngulkurrduku useim-bungal bubungu, Godungku yurranda junjuy kari yungal nyunguwunmun bubumun. ");
INSERT INTO gvn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yurra majanda jambuliymba kari milka-janay. Kaki yurra maja nyubun wukurril, yurra maja yindu can't wukurril. Yurra majanka nyubunyinka wawu jirray, yinduynku wawu kari. Kaki yurra money and yamba-yamba maja-bungal, yurra God kari maja-bungal. Yurra can't jambulinka wawu jirray, Godunku, and moneyka.” ");
INSERT INTO gvn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jana Pharisee-warrangka yinya kuku nyajin, jana Jesus yajarrin. Jana money-baka, yinyaynka jana nyungun yajarrin. ");
INSERT INTO gvn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesusangka jananda yalaman, “Yurra bamanda balkal, ‘Nganjin ngulkurrku bundari, buyun kari.’ Yamba Godungku yurranga wawu nyajil. Nyulu binal yurra money-baka. Bamangka yurranin buyay-manil, yamba God binal bajaku yurranka. Yurra kari junkayku bundari Godunku. ");
INSERT INTO gvn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ngadiku Mosesangka and prophet-prophetangka Godumu kuku kabanba balkan. Bamangka yinya kuku wukurrin, John the Baptist kadanjiku. Wawu Johnundumun ngayu yurranda kuku ngulkurr yirrkan. Yinya kuku yalaku: ‘Godungku nyungu jawun-karra ngulkurrduku kujil.’ Bama wubul Godumu jawun-karramanka. Jana wawu jirray nyungu jawun-karramanka. ");
INSERT INTO gvn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jew-warramu law kari kunbay. Yinya law wuljaljiku ngulkurrku bunday. Bubu and jiri juma kunbay, yamba yinya law kari bajaku kunbay. ");
INSERT INTO gvn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kaki dingkarangka nyungu manyarr bawal, and yindu marryim-bungal, nyulu kalngarmal. Kaki yinduynju yinya jalbu marryim-bungal, yinya yindu dingkar yalarrku kalngarmal.” ");
INSERT INTO gvn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesusangka yalaman baja, “Ngadiku bama nyubun money jirray bayanba bundandan. Nyulu kambi flash-bala didan, yamba-yambaji, mayiji jirraynji bundandan. ");
INSERT INTO gvn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yindu bama, burri Lazarus, yalarrku yinyaymba bubungu bundandan. Nyulu money kari, baji jirray. Nyunguwundu jawun-karrangka nyungun yarbarrka wundin gateba rich-balandamunbu, mayinga babajinka. ");
INSERT INTO gvn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nyulu rich-bala mayi jirray. Yamba nyulu Lazarusanda kari dajin. Lazarus dakwuy bajaku. Kanbal mayi bada-bada bubungu tablemun daran. Lazarusangka yinya mayi nukanka. Jana kaya-kaya kadarin, Lazarusamu baji bijan. ");
INSERT INTO gvn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nyulu Lazarus wulanda. Angel-angelangka nyungun jiringa jarra-kulbanda. Yinyaymba nyulu Abrahamanji bundandan. Nyulu dingkar money jirray yalarrku juma wulan, jana nyungun juljalba nandan. ");
INSERT INTO gvn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nyulu bama rich-bala bayanga bundandan, warrngkan-warrngkaynda. Nyulu miyilda yala wangkar nyajin, nyulu Abraham bula Lazarus nyajin kala-kalbay bundandanya. ");
INSERT INTO gvn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nyulu Abrahamanda yirrkan, ‘Abraham, yundu ngayku nganjan. Yundu jiba-badi ngaykunku. Lazarus yunga ngaykundu, nyulu nyungu mara bananga ngaba, ngaykuwunbu nyabilba yijarrinka, bujar-bunganka. Ngayu warrngkal-warrngkal kakaji yalaymba bayanga.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Yamba Abrahamangka yalaman, ‘Yundu binal, milka nyajijika. Jakalbaku, yundu bada bubunguku, yundu money, and yamba-yamba jirray, yamba Lazarus bubungu bundan, yamba-yamba and money yamba-kari. Nyiku nyulu wawurr-wawurrku bundandayda, yamba yundu kakaji warrngkan-warrngkayda.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Abrahamangka yalaman baja rich-balanda, ‘Ngalinyanda jambuliymba janku jirray. Bama yalaymun bubumun kari yurranda dungari, yurra yalarrku yalaymba kari kadari, bama kari kala-jalamal.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nyulu rich-balangka Abrahamanda yalamanda, ‘Yundu Lazarus yunga ngaykuwunbu nganjanandamunbu bubungu. ");
INSERT INTO gvn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yinyaymba nyulu ngayku yabaju-karra 5-bala milka-baka, jana kari kurru-kurruku dungarika, buyun-buyun kari wukurrika yala ngayu buyun-buyun wukurrin. Kaki nyulu kari milka-bakal, jana yalarrku yaluy bubungu buyunbu kadari, kakaji warrngkay.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahamangka yalaman, ‘Yunuwundu yabaju-karrangka kuku nyajin Mosesandamun and prophet-prophetandamun. Jana kuku yinyaku nyaka.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nyulu rich-balangka yalaman, ‘Kari, Abraham, jana yinyayanda kukungu kari milka-janay. Kaki bama juranmal baja yarkinmun and jananin milka-bakal, jana buyun-buyunmun jurrkiji.’ ");
INSERT INTO gvn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yamba Abrahamangka yalaman, ‘Kaki jana Mosesamu kuku and prophet-prophetamu kuku kari nyajil, jana yalarrku kari nyajil bama juljalmun.’” ");
INSERT INTO gvn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusangka jawun-karranda yalaman, “Bamangka yindu-yindu buyunku juru-jurungu juru-kulbal, jana buyunmanka. Ngayu jiba-badi jananka bamanka juru-kulbanya buyunmanka. Godungku jananin yaykarrdaku punishim-bungalkuda. ");
INSERT INTO gvn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bamangka nyubunyinja ngayku bama buyun-buyunku juru-kulbal, ngaykundumun jurrkijinka. Godungku nyungun punishim-bungalda. Nyulu bama juru-kulbanjiku, jana kulji yalbay nyunguwunbu manungu kajanyaku, nyungun bujil-janji-maninyaku jalunbu dajalimunbu. Yinya jarra ngulkurr Godundumunku punishmentmunku. ");
INSERT INTO gvn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yinyaynka yurra mumbarmaka yurra wanjarrmanka. “Kaki bamangka yunun buyunku buyun-damal, yundu nyungundu kari kuli daya baja. Nyungunji kuku yaralku balkawaka yinyaynka buyunku. Kaki nyulu balkal, ‘Ngayu murru-kaday buyunku,’ yundu nyunguwunku buyun-buyunku milka-wulayda. ");
INSERT INTO gvn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bamangka nguba 1-daymunbu yunun buyun-damal 7 times. Nyulu nguba yunundu kaday baja, kaday baja, balkal, ‘Ngayu murru-kaday yinyaynka buyunku.’ Kaki nyulu 7 times kaday, yundu nyunguwunku buyun-buyunku 7 times milka-wulay, kari kuli daya baja.” ");
INSERT INTO gvn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jana jawun-karrangka Majanda Jesusanda yalaman, “Maja, yundu nganjinanda junkurr daya, yunuwunbu kukungu milka-jananka, kari warmbinka.” ");
INSERT INTO gvn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Majangka yalaman, “Kaki yurra nganya bubanku kuku nyajil, and kari warmbil, yurra balkal yinyayanda jukungu, ‘Kulbajika ngaramun, nandajika baja jalunbu.’ Yinyayngka jukubu yunu kuku wukurrilkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesusangka jawun-karra binal-bunganka storybu. Nyulu yalaman, “Yundu nguba yunu workingman gardenba yungal bubu bakanka, or nguba yundu nyungun manjalba yungal sheep miyil-kujinka. Nguba yilay-yilaymal, yinya workingman gardenmun kaday, bayanba walal, workmanijinka bayanba. Yundu nyungundu kari balkalda, ‘Bunday, ngayu yunu mayi manil, yundu nuka.’ ");
INSERT INTO gvn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kari, yala kari. Yundu maja, yundu workingmananda balkal, ‘Yundu ngayku mayi wayju, ngaykundu wundi, ngayu nukanka. Wawu yinyamun yundu yunuku mayi nuka.’ ");
INSERT INTO gvn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yundu workingman kari buyay-mana workmunku. Workingmanangka majamu kuku wukurrika. Yinyaynka majangka nyungun kari thankim-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yinya yala yurra Majanda Godundu workmanmal. Yurra nyungu kuku mumbarabuku wukurrika, nyungu work ngulkurrduku balka. Yurra Majamu work kunbay-manil, yurra balkada, ‘Ngana workingmanku, ngana maja kari. Kaki Godungku work dajil ngananda, ngana yinya work must mumbarabuku balka.’” ");
INSERT INTO gvn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jana Jesus townbu Jerusalem dungan-dungarin, jana bububurr Samariamundurr, bububurr Galileemundurr dungarin. ");
INSERT INTO gvn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jana townbu kadarin, bamangka 10-balangka jananin maku-nyajin. Jana 10-bala bajiji, leprosymunji. Jana kari yuba kadarin. ");
INSERT INTO gvn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jana Jesusanda yirrkan, yalaman, “Maja Jesus, yundu jiba-badi nganjinanka! Nganjinan ngulkurr-bunga.” ");
INSERT INTO gvn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesusangka jananin nyajin, yalaman, “Yurra dungarikada maja-majanda Godundumunku bayanka. Jana yurranin biku-nyajil, nyajinka, yurranga yulban nguba dayirrda, nguba kari, yala lawmundu balkan.” Jana 10-bala dungan-dungarin, jananga yulban ngulkurrmarin, baji kunbaynda. ");
INSERT INTO gvn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nyubun dingkar yinyarrinmun binalman Jesusangka nyungun ngulkurr-bungan. Yinyaynka nyulu jurrkijin, Jesusandaku kadan baja, God yaykarrdaku buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nyulu dingkar bungkubu janan jakalba Jesusanda, nyungun thankim-bungan. Yinya dingkar bama Jew kari, nyulu bubumun Samariamun. ");
INSERT INTO gvn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesusangka yalaman, “Yala kanbal? Ngayu 10-bala ngulkurr-bungan. Wanjabu jana yindu 9-bala? ");
INSERT INTO gvn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wanyurrinku nyubunku kadan, God buyay-maninka? Nyulu nganandamun kari, nyulu bubumun Samariamun. Jana kanbal kari kadarin baja, God buyay-maninka.” ");
INSERT INTO gvn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesusangka dingkaranda yalaman, “Dakada, dungayda. Yundu ngulkurrman bambaymun, yundu ngaykuwunbu kukungu milka-jananya.” ");
INSERT INTO gvn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kanbalda Pharisee-warrangka Jesusanda babajin, “Godungku wanja-wanja nyungu bama ngulkurrduku kujil?” Jesusangka yalaman, “Yala kari. Yurra kari God nyajil nyungu bama ngulkurrduku kujinya. Yurra nyungun kari nyajil jananin junkurr-murubuku kujinya. ");
INSERT INTO gvn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bamangka kari balkalda, ‘Nyakada, Christ yinyadabi, or nyulu yanyuda.’ Kari. Yala kari. Nyulu kadanda, yamba yundu kari miyilda nyajil. Yundu kari nyajil, nyulu bamandamunbu wawungu walanya. Wawu walanyamun, Godungku nyungu jawun-karra ngulkurrduku kujil-kujilda.” ");
INSERT INTO gvn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yinyamun Jesusangka jawun-karranda yalaman, “Yurra juma nganya nyajinka kadanya baja, yamba yurra nganya kari nyajil. ");
INSERT INTO gvn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kanbalda bamangka nguba balkal, ‘Nyakada, nyulu bamanga wubulbuku yaba yanyuda,’ or jana nguba yalamal, ‘Nyulu yinyada, ngana dungayda nyungun nyajinka.’ Yamba jana wadu-wadu, yurra yinya kuku kari nyaka, kari dungarika. ");
INSERT INTO gvn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngayu bamanga wubulbuku yaba, juma kaday baja. Bamangka nganya nyajil kadanya yala bamangka balbay yiringkurrku nyajil jiringa. ");
INSERT INTO gvn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yamba ngayu dunganjiku, jana Jew-warrangka nganya warrngkay-manil, ngaykunku wawu kari. ");
INSERT INTO gvn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ngadiku nyubun bama, burri Noah, nyulu junkayku bundandan Godunji. Noahangka jananin balkan Godunku, yamba jana yinya kuku bayjan. Ngayu wubulbuku bamanga yaba. Ngayu kaday baja bubungu, bama yalaku bundari, God bayjanya, ngaykunku wawu kari. Jana yala bama bundandanya yala-yalaku Noahanda. ");
INSERT INTO gvn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yala-yalaku jalungkarr jirray warrinjiku, bama mayinga, bananga nukajinya, marrymanijinya, yalaku bundandarinya. Yamba Noah, nyungu jawun-karra boatbu walarinda, jalungkarrmunku. Yinyamundu jalungkarrda bama yindu-yindu wubulku bujil-janji-manin, jana kuku bayjanya. ");
INSERT INTO gvn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yinya yala ngadiku, bama burri Lot juranku. Nyulu townbu Sodom bundan. Bamangka mayi nukanya, bana nukanya, yamba-yamba buy-im-bunganya, sellim-bunganya, diburr gardenba nandanya, bayan ngaranya, yalaku. ");
INSERT INTO gvn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nyulu Lotungku yinya town Sodom bawan, Godungku baya jirray yungan jirimun. Jana bama townbu Sodom wubulku wayjujin, jana God bayjanya. ");
INSERT INTO gvn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bama yalaku bundandari, ngayu juma kaday baja. Ngayu bamanga wubulbuku yaba. ");
INSERT INTO gvn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Yala-yalalu bama nguba ngalkalba bayanba. Nyulu kari kananga warri, yamba-yamba maninka. Nyulu jinbalku warrida kulimun. Bama nguba paddockmunbu workmalmal, nyulu kari bayanbaku dungay, jinbalku warrida kulimun. ");
INSERT INTO gvn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yurra milkabu wukurrika Lotumu manyarr. Nyulu jurrkijin, nyajinka. Yinyaynka nyulu wulanda. ");
INSERT INTO gvn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bama nguba juranku bundanka. Kaki nyulu junjuy-junjuy bubunguku milkabu wukurril, nyulu juma wulay. Bamangka yinduynju nguba kari milkabu wukurril junjuy-junjuy bubungu, yamba nyulu Godumu work balkal. Yinya bama wuljaljiku juranku Godunji bunday. ");
INSERT INTO gvn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yala-yala ngayu kaday baja, bama jambul warngku wunanay. Jiri-warrangka nyubun manil, yindu jana kudamundu bawal. ");
INSERT INTO gvn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jalbu-bulalangka jambulinja mayi dirka-bungal-bungal. Jiri-warrangka nyubun manil, yindu bawaji. ");
INSERT INTO gvn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yala-yalalu dingkar jambul paddockmunbu. Jiri-warrangka nyubun manil, yindu bawaji.” ");
INSERT INTO gvn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jana jawun-karrangka Jesusanda babajin, “Wanjabu nyulu jananin bawal, Maja?” Jesusangka yalaman, “Yarkin-yarkin bubungu wunay, jana dikal waja yinyaymba kadarikuda, murumarikuda.” ");
INSERT INTO gvn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yala-yalaku Jesusangka nyunguwunbu jawun-karranda story balkan, jananin binal-bunganka. Nyulu binal-bunganka jana kajaka praymaka, kari milka-bujarmaka. ");
INSERT INTO gvn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nyulu yalaman, “Nyubun bama townbu bundandan. Nyulu maja judge courthousemunku. Nyulu kari yinyilman Godunku. Nyulu bama bayjan, jananin kuku kari nyajin. ");
INSERT INTO gvn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nyubun jalbu bunjil, nyulu yalarrku yinyaymba townbu bundandan. Nyulu judgeanda kajaka dungan, yalaman, ‘Yundu nganya helpim-bunga, bamangka nganya buyun-damal-damal.’ ");
INSERT INTO gvn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nyulu bamangka judgeangka nyungun bunjil ngadingka bayjan, kari take a notice-bungan. Yamba yinya jalbu kadan baja, kadan baja. Juma nyulu judgeangka yalaman, ‘Ngayu kari yinyilji Godunku, ngayu bamanga kuku bayjal. ");
INSERT INTO gvn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yamba yanyungku jalbungku nganya walu-nukay-manil. Ngayu nyungun help dajil, yinyamun nyulu nganya kari wawu-damal baja. Ngayu kari baja-burraymal baja nyungunku.” ");
INSERT INTO gvn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesusangka jananda yalaman baja, “Yurra milkabu wukurrika judge buyun storynga. ");
INSERT INTO gvn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Judgeangka buyunyundu bamanga kuku buban nyajil, yamba Godungku nyunguwunbu bamanga kuku yalbayku nyajil, jananin ngulkurrduku kujilkuda. Kaki jana nyungundu jururr-jururr yirrkay, wungara, wujurrbu, nyulu jananin jinbaldaku help dajil. ");
INSERT INTO gvn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kaki jana Godundu milka-janay, Godungku kuku junkayku jinbaldaku balkal jananka, jananda jinbalku help dajil. Ngayu bamanga wubulbuku yaba. Ngayu juma kaday baja bubungu. Ngayu nguba bama wubul warrmba-bungal ngaykundu milka-jananya, nguba bama buban.” ");
INSERT INTO gvn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesusangka kanbalanda yalaman baja, “Kanbal bama balu janaku ngulkurrku bundandari, bama yindu-yindu buyun.” ");
INSERT INTO gvn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nyulu jananda yanyu story balkan jananin binal-bunganka. Nyulu yalaman, “Nyubun bama Pharisee, nyulu Godundumunbu bayanba yalbaymba dungan, Godunji balkawanka, praymanka. Yindu bama, nyulu Governmentamu tax money mujal-mujan, nyulu yalarrku yinyaymba dungan. ");
INSERT INTO gvn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Nyulu dingkar Pharisee balu nyulu jarra jirray kanbalanka. Nyulu Godundumunbu bayanba nyulurrku janan, yalaku praymanijin, ‘God, ngayu yunun buyay-manil, thankim-bungal. Ngayu jumbun kari. Ngayu junjuy-junjuy kari ngakil. Ngayu dingkaramu yinduymbu manyarr kari wunay. Ngayu kari buyun yala yinya dingkar Governmentamu money mujal. ");
INSERT INTO gvn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Two times every week ngayu mayi kari nukal, yunun buyay-maninka baja. Ngayu ngayku money dajiway yununji.’ Nyulu dingkar Pharisee yalaku praymanijin Godundu. ");
INSERT INTO gvn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Yamba nyulu dingkar Governmentamu tax money mujan bamandamun, nyulu kari yubaku janan. Nyulu bubu nyajin, murru-kadan buyun-buyunku, milka-bujarmankuda. Nyulu Godundu babajin, ‘God, yundu manun-manunmaka ngaykunku. Ngayu buyun bajaku.’” ");
INSERT INTO gvn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesusangka yalaman, “Godungku yinya dingkar kuku nyajin, nyungun ngulkurr-bungan buyun-buyunmun. Yinya dingkar bayanbaku dungan, junkayku bundan Godundumunbu miyilba. Yamba nyulu Pharisee kari junkayku bundan Godundumunbu miyilba, nyulu bulmbuymanya. Kaki bama bulmbuy majamanka, Godungku nyungun buban-bungal. Kaki bama nyuluku buban-bungaji, Godungku nyungun maja-bungal.” ");
INSERT INTO gvn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yinyamun bamangka kaykay-kaykay Jesusanda wundin. Jana wawu Jesusangka yinyarrin kaykay-kaykay marabu karrbanka, jananka praymanka. Jana jawun-karrangka 12-balangka jananin nyajin wundinya, jana jananin murru-kanganda. ");
INSERT INTO gvn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesusangka kaykay-kaykay nyungundu kunjan, yalaman, “Kaykay-kaykay kari kiri ngaykundu kadarinka. Balu kadarika ngaykundu. Kaki bamangka nganya believeim-bungal yala yinyarrinyangka kaykay-kaykayangka, Godungku jananin ngulkurrduku kujil. ");
INSERT INTO gvn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yurra yanyu kuku milkanga kuji. Kaykay-kaykayangka God mumbarabuku kuku nyajil, kari warmbil. Kaki bamangka God kuku kari warmbil yala kaykay-kaykayangka kari warmbil, Godungku jananin ngulkurrduku kujil.” ");
INSERT INTO gvn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nyubunyinja majangka Jew-warrandamundu Jesusanda yalaman, “Yundu teacher ngulkurr. Ngayu wanjarrmal, junkayku dunganka, wuljaljiku juranku bundanka heavenba?” ");
INSERT INTO gvn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesusangka yalaman, “Yundu nganya wanyurrinku ngulkurr bamban? Nyubunku Godku ngulkurr bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yundu Godundumunku kukuku binal. Yinya kuku yalaku: ‘Kari kalngarmaka, yarkinkaku kari kuni, kari wurrmaymaka, kari jurrilmaka, kuku nyakaku ngamu, nganjan.’” ");
INSERT INTO gvn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nyulu dingkarangka yalaman, “Ngayu karrkaymunduku yinya kuku wukurrin.” ");
INSERT INTO gvn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesusangka yinya kuku nyajin, nyulu nyungundu yalaman, “Nyubunku kuku yundu wukurrikada. Yundu dungayda, yamba-yamba wubulku sellim-bunga. Money mana, poor-balanda daya. Yinyamundu yundu jirray manil heavenba. Yinyamun yundu kaday, nganya wukurrikada.” ");
INSERT INTO gvn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nyulu dingkarangka yinya kuku nyajin, nyulu milka-bujarku dungan, moneyka jirraynka. ");
INSERT INTO gvn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesusangka nyajin nyulu milka-bujarmanya. Nyulu yalaman, “Godungku nyungu bama ngulkurrduku kujil. Money-jirrayanka hard-bala God maja-bunganka. Nyulu milkanga moneyjiku bundanday. ");
INSERT INTO gvn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hard-bala bajaku bulkinka needledarr kankaburr dunganka. Yamba jarra hard-bala bamangka money-jirrayangka God maja-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jana bamangka yinya kuku nyajin, jana babajin, “Kaki yinya kuku manubaja, wanju bama Godungku juran-bungal?” ");
INSERT INTO gvn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesusangka yalaman, “Bamangka murruji yalaku balkal. Godungkuku bama juran-bungalarrku.” ");
INSERT INTO gvn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peterangka yalamanda, “Yala nganjin? Nganjin wubulku bawan, jawun-karra, yamba-yamba, bayan, yunun wukurrinka.” ");
INSERT INTO gvn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesusangka yalaman, “Yuwu, yurra nguba bayan, manyarr, yabaju-karra, ngamu-nganjan, kangkal-kangkal, wubulku bawanyarrku, God maja-bunganka. Kaki yurra yalaku wubulku bawalarrku, ");
INSERT INTO gvn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ngayu juma yurranda wubul bajaku dajil baja. Ngayu yalarrku yurranga wawu juran-bungal, yurra wuljaljiku ngaykunji bundarinka heavenba.” ");
INSERT INTO gvn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesusangka jawun-karra 12-bala muru-bungan, jananda yalaman, “Milka-janay! Ngana townbu Jerusalem dungarida. Ngayu bamanga wubulbuku yaba. Jana prophet-prophetangka ngadiku kuku kabanba balkan ngaykunku. Townbu Jerusalem yinya kuku manubajamalkuda. ");
INSERT INTO gvn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jana Jew-warrangka nganya mambarril bamanda Gentile-warranda. Jana nganya buyun-damal, nganya yajarril, nyumba yilbal ngaykundu. ");
INSERT INTO gvn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Juma nganya wuybubu kulbal, yarkinkaku kunilarrkukuda. Yamba warngku kulurmal ngayu juranmal baja juljalmun.” ");
INSERT INTO gvn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yamba jana jawun-karra 12-bala nyunguwunku kukuku binal kari. Jana balu nyulu kiraynjaku kuku balkan, yinyaynka jana nyunguwunku kukuku kari binalman. ");
INSERT INTO gvn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jana Jesus yubamalmankuda townbu Jericho, nyubun bama miyil-burra karangkalba baralba bundandan. Nyulu yinya bama miyil-burra jananda ngukal banbadin moneyka, mayi buy-im-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nyulu bama wubul milkabu nyajin dungan-dungarinya, nyulu babajin, “Wanyu yanyu?” ");
INSERT INTO gvn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jana nyungundu yalaman, “Jana Jesus, townmun Nazarethmun dungan-dungarida.” ");
INSERT INTO gvn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yinyamun nyulu miyil-burra yirrkan, “Jesus, yundu Davidandamun, manun-manunmaka ngaykunku.” ");
INSERT INTO gvn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jana bamangka jakalbamundu nyungun murru-kangan, yalaman, “Jankamakada!” Yamba nyulu yaykarrku yirrkan baja, “Yundu Davidandamun, ngaykunku manun-manunmaka, jiba-badi.” ");
INSERT INTO gvn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus janan, yalaman, “Yurra miyil-burra ngaykundu wundi.” Nyulu yuba kadan, Jesus nyungundu babajin, ");
INSERT INTO gvn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngayu wanjarrmal yunundu?” Miyil-burrangka yalaman, “Maja, ngayu miyilda nyajinka baja.” ");
INSERT INTO gvn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesusangka nyungundu yalaman, “Nyakada. Yundu nganya believeim-bungan, kari warmbin. Yinyaynka yunu miyil ngulkurrmalkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nyulu miyil-burra miyil walngajin, nyajinkuda. Nyulu Jesus wukurrin, God buyay-maninda. Jana bamangka wubulinjaku yinya nyajin, jana wubulduku God buyay-manin. ");
INSERT INTO gvn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jana Jesus towndurr Jerichomundurr dungan-dungarin. ");
INSERT INTO gvn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nyubun dingkar yinyaymba bundandan, nyulu maja bamanka Governmentamu tax money mujal-mujan. Nyulu burri Zacchaeus, money jirray bajaku, rich-bala. ");
INSERT INTO gvn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nyulu dingkar kulka bajaku, kari kalbali. Yinyaynka nyulu Jesus kari nyajin, bama wubul bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jana bama dungan-dungarin, nyulu Zacchaeus jakalba warrin, jukungu yalbaymba dakan, jukumun Jesus nyajinka bada-bada dungan-dunganya. ");
INSERT INTO gvn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nyulu Jesus bada-bada jukungu kadan, nyulu yala wangkar nyajin, Zacchaeusanda yalaman, “Yundu jukumun jinbalku wala, ngayu yunuwunbu bayanba bundanka.” ");
INSERT INTO gvn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nyulu Zacchaeus jinbalku jukumun jalaman, Jesus wawurr-wawurrduku bayanba walay-manin. ");
INSERT INTO gvn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jana bamangka bulanin nyajin dunganya, jana kuli-kadarin Jesusanka. Jana yalaman, “Wanyurrinku nyulu Jesus yinyarrinyanji bamanji buyunji bundanka?” ");
INSERT INTO gvn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bula bayanba kadan, balkawan. Zacchaeus dakan, yalaman, “Yundu milka-janay, Maja. Ngayu ngayku money, yamba-yamba dajiwanka bamanji money-karinji. Ngayu half dajilda jananda. Ngayu nguba money ngakin bamandamun, ngayu jananda jarra jirrayku dajil baja, 4-timesmunku.” ");
INSERT INTO gvn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesusangka nyungundu yalaman, “Yurra jawun-karra yaluy bayanba bundandari, Godungku yurranga buyun-buyun kidankuda. Yurra Abrahamandamun. Nyulu yalarrku nyuluku mambarrijin Godundu, kari bayjan. ");
INSERT INTO gvn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngayu bamanga wubulbuku yaba. Ngayu kadan bama buyun ngulkurr-bunganka. Jana nubijin, ngayu jananin warrmba-bunganka baja.” ");
INSERT INTO gvn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jana Jesus yubaku townbu Jerusalem dungan-dungarin, bama wubul balu Jesus jananka majamal. Jana yalaku wadu-wadu milkabu wukurrin, “Ngana townbu Jerusalem kadari, Jesus ngananga majamal, Godungku nyungu bama ngulkurrduku kujinka.” Yinyaynka Jesusangka jananda yindu story balkan, jananin binal-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nyulu yalaman, “Ngadiku nyubun maja jirray bubungu yinduymbu kala-kalbaymba dunganka. Yinyaymba bubungu kala-kalbaymba jana nyungun maja jirray king-bunganka. Yinyamun nyulu nyunguwunbuku bubunguku kadanka baja, maja-kingmanka nyunguwunkuku bamanka. ");
INSERT INTO gvn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yala, nyulu dunganjiku, nyulu nyungu workingman 10-bala kunjan, jananda wubulbuku 100 dollars dajin. Nyulu jananda yalaman, ‘Ngayu yurranda 10-balanda wubulbuku 100 dollars dajin. Kaki ngayu yaluy kari, yurra ngaykuwundu moneybu yamba-yamba buy-im-bunga, sellim-bunga baja. Yalaku yurra money jirray-bunga ngayku.’ Yinyamun nyulu dunganda. ");
INSERT INTO gvn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jana bama nyunguwunmun bubumun, jana nyungunku wawu-kariman majamanka. Jana bama nyubun kukuji yungan nyungundu jurungu bubungu yinduymbu, maja-bajandaku yalamanka, ‘Nganjin wawu kari yinyaynka majanka. Nganjin wawu kari nyulu nganjinanga kingmanka.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Yamba jana maja-bajangkaku nyungun king-bungan, nyunguwunbuku bubunguku yungan baja. Nyulu nyunguwunbuku bubunguku kadan baja, jananin workingman 10-bala kunjan, babajin, ‘Yurra wanjarr money jirray-bungan?’ ");
INSERT INTO gvn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nyubunyinja bamangka yalaman, ‘Maja, ngayu yunu 100 dollars jarra yalbay-bungan, 10 times. Yanyu 1000 dollars yunu.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kingangka yalaman, ‘Yinya ngulkurrkuda. Yundu ngulkurrku workmalman. Ngayu yunundu money buban dajin, yundu yinya money yalbay-bungan. Yinyaynka ngayu yununin maja-bungal townku 10-balaka.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yinduynju workingmanangka yalaman, ‘Maja, ngayu yunu 100 dollars yalbay-bungan, 5 times. Yanyu 500 dollars yunu.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nyulu kingangka yalaman, ‘Ngayu yununin maja-bungal townku 5-balaka.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Yinduynju workingmanangka kinganda yalaman, ‘Maja, yanyu yunu 100 dollars. Ngayu yinya money yangkijanga kajan, ngakin. ");
INSERT INTO gvn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngayu binal yundu maja manun-manun kari. Yundu yunu workingman mambarril yaykarr bajaku workmanka, yundu money jirray maninka. Yinyaynka ngayu yinyil yununku.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nyulu king kuli-kadan nyungunku. Nyulu yalaman, ‘Yundu majarr bajaku! Yundu binal ngayu bamandamun money manil-manin yinya ngayku kari. Yinya kuku yunundu milkanga kadan! ");
INSERT INTO gvn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yinyaynka yundu yinya money bankmunbu yijarrinyaku. Yinya money bankmunbu wunananyaku, juma-juma money interest jirraymanyaku.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nyulu kingangka bamanda yalaman, ‘Nyungundumun yinya 100 dollars mana, bamanda yinyayanda daya 1000 dollarsmunjirrba.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yamba jana bama yinyaymba janjanan kinganda yalaman, ‘Maja, nyulu 1000 dollarsmunjida. Yundu yinduymbu dajinyaku.’ ");
INSERT INTO gvn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nyulu kingangka yalaman, ‘Kaki bama ngulkurrku workmal, ngayu nyungundu work jirray dajil. Kaki bama buyunku workmal, ngayu nyungundu work kari dajil baja. Ngayu nyungu work yinduymbu dajil. ");
INSERT INTO gvn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jakalbaku kanbal ngaykunku wawu kari. Jana wawu kari ngayu jananga kingmanka. Jananin yalaymba wundida, yarkinkaku kunida.’” ");
INSERT INTO gvn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wawu yinyamun kukumun Jesus jakalba dungan, yuba townbu Jerusalem kadan. Yinyaymba jana jawun-karrangka nyungun juru-manin baja. ");
INSERT INTO gvn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jana townbu jambulbu kadarin, burri Bethphage and Bethany. Bula town yinya-bulal yubaku wuburrbu Olivesmunbu. Yinyaymba manjalba Jesusangka jawun jambul jakalba yungan townbu. ");
INSERT INTO gvn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nyulu bulanda yalaman, “Yubal yinyaymba townbu dungarika. Yubal townbu kadari, donkey karrkay nyajil karrabu kajanya. Bama kariku nyunguwunbu mukungu dakan. Yubal donkey walnga, ngaykundu wundi. ");
INSERT INTO gvn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bama nguba yubalanda babaji, ‘Wanyurrinku yubal yinya donkey walngal-walngal?’ Kaki jana babaji, yubal balka, ‘Ngalinya Maja nyungundu dakanka.’” ");
INSERT INTO gvn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bula dungan, donkey karrkay warrmba-bungan, yala Jesusangka bulanda balkan. ");
INSERT INTO gvn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bula donkey walngal-walngan, majangka donkeyndamundu bulanda babajin, “Yubal wanyurrinku nyungun walngal-walngal?” ");
INSERT INTO gvn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bula yalaman nyungundu, “Ngalinyandamundu majangka nyungun wantim-bungal.” ");
INSERT INTO gvn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yinyamun bula donkey Jesusanda wundin. Bula kambi bulanga mukungu ngaran donkeynda. Bula Jesusanda mara dajin, mukungu dakanka. ");
INSERT INTO gvn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nyulu donkeynji dungan-dunganda, bamangka wubulduku jananga kambi baralba jakalba Jesusanda ngaran-ngaran. Jew-warrangka yalaku jananga king yulmbarrin. ");
INSERT INTO gvn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jana yubaku townbu Jerusalem kadarin, baral badamun manjalmun Olivemun jurrkijin. Yinyaymba jana dungan-dungarin, bamangka wubulduku God buyay-maninkuda, thankim-bungan, Jesusangka miracle yalbay balkanya Godundumundu junkurrdu. ");
INSERT INTO gvn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jana yirrkan, “God buyay-mana! Majangka Godungku yunun yungan! Yundu nganjinangakuda king! Wubulduku yununin buyay-mana bubungu, and jiringa!” ");
INSERT INTO gvn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kanbal Pharisee-warra baraldarr janjanan. Jana Jesusanda yalaman, “Maja, yundu bamanda yunuwunbu balka, yunun kari buyay-maninka.” ");
INSERT INTO gvn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesusangka yalaman jananda, “Ngayu yurranda balkal, kaki jana bama jankamari, yinyarrin kuljikuda kawal yirrkay ngaykunku.” ");
INSERT INTO gvn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nyulu Jesus yubaku townbu Jerusalem kadan, nyulu bamanka townku badin, milka-bujarman jananka. ");
INSERT INTO gvn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nyulu yalaman, “Ngayu milka-bujarmalkuda, yurra binal-kariku bundanya ngaykunku. Yurra binal kari Godungku nganya yungan yurranga wawu ngulkurr-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kanbal yurranka wawu kari. Juma jana soldier-soldier kadari, gate yinyarrin townbu wubulku kanbil, yurra nandajikuda kananga. ");
INSERT INTO gvn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jana bama wubulku yarkinkaku kunil, bayan yinyarrin townbu wubulku wayjul. Kulji-kulji bayanka jana wubulku bubungu yilbal. Jana yurranin buyun-damal, yurra God bayjanya. Nyulu yurranga wawu ngulkurr-bunganka, yamba yurra nyungundu kari milka-janan.” ");
INSERT INTO gvn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yinyamun Jesus Godundumunbu bayanba yalbaymba walan. Yinyaymba kanbalda bamangka junjuy-junjuy dikal-dikal sellim-bungal-bungan. Jesusangka jananin murru-kangan, ngalkalba kangan. ");
INSERT INTO gvn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nyulu jananda yalaman, “Godungku nyunguwunbu kabanba balkan, ‘Ngayku bayan yalbay ngaran, ngaykunji balkawanka, praymanijinka.’ Yamba yurra walarinka wurrmay-bakamanka, bayan buyun-damanka.” Nyulu yinya kuku balkan, jana bama jurril-bunganya, money jirray maninka. ");
INSERT INTO gvn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wawu kanganyamun, Jesusangka bama binal-bungan Godundumunbu bayanba yalbaymba. Jana maja-maja Godundumunku bayanka, jana teacher-teacher ngadimunku, maja-maja yindu, jana wubulduku Jesus yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yamba jana yinyilmarin nyungun karrbanka, bama wubulku nyungunku wawumanya. Nyulu bama junkaynjaku binal-bungan. Yinyaynka jana maja-maja yinyilmarin nyungun karrbanka. ");
INSERT INTO gvn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yinyamun Jesusangka bama binal-bungan-bungan, Godumu kuku ngulkurr yirrkan-yirrkan Godundumunbu bayanba yalbaymba. Jana maja-maja Godundumunku bayanka, jana teacher-teacher ngadimunku, jana elder-elder, jana wubulku Jesusanda kadarin. ");
INSERT INTO gvn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jana nyungundu babajin, “Wanjungku yunundu balkan jananin binal-bunganka, ngulkurr-bunganka? Wanyangka yunun yungan?” ");
INSERT INTO gvn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesusangka jananda yalaman, “Kari. Ngayu yurranda junjuynku babajinka. Ngaykundu balka. ");
INSERT INTO gvn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wanjungku John yungan, bama banabu dukul-damanka? Godungku nyungun yungan or bamangka?” ");
INSERT INTO gvn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jana jana-karrajiku balkawan, yalaman, “Ngana wanyu baja balkal nyungundu? Kaki ngana balkal, ‘Godungku John yungan,’ nyulu Jesusangka ngananda babaji, ‘Yala yurra wanyurrinku nyungundu kari milka-janan?’ ");
INSERT INTO gvn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kaki ngana balkal, ‘Bamangka John yungan,’ jana bamangka wubulduku nganangan kuljibu kunil. Jana balu John nyajin prophetkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yinyaynka jana Jesusanda yalaman, “Nganjin binal kari. Wanjungku baja John yungan?” ");
INSERT INTO gvn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesusangka jananda yalaman, “Yala, ngayu yalarrku yurranda kari balkal wanjungku nganya yungan.” ");
INSERT INTO gvn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yinyamun Jesusangka jananda yanyu story balkan, jananin binal-bunganka. Nyulu yalaman, “Nyubun dingkar bubuji yalbaynji. Nyulu diburr grape nandan bubungu. Nyulu workingman manin, bubu ngulkurrduku kujinka. Nyulu jananda yalaman, ‘Mayi kulbulmalda, yurra kanbal mayi maninka, yurranga pay.’ Yinyamun nyulu maja bubungu yinduymbu dungan, ngadingka bundan. ");
INSERT INTO gvn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yala, mayi grape kulbulman, nyulu majangka bama slave nyunguwunbu bubungu yungan, mayi grape maninka. Yamba jana workingmanangka yinya slave karrban, jukubu kunin, yungan baja, mayi yamba-karikuda. ");
INSERT INTO gvn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yinyamun nyulu majangka bama slave yindu yungan mayi maninka. Yamba jana workingmanangka nyungun yalarrku jukubu kunin, yungan baja, mayi yamba-karikuda. ");
INSERT INTO gvn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yindu slave yalarrku yungan majangka. Workingmanangka nyungun yalarrku buyun-daman, ngalkalba yilban. ");
INSERT INTO gvn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yinyamun nyulu majangka yalaman, ‘Ngayu wanjarrmalda? Ngayu ngayku kangkal yungal. Jana workingmanangka nyungun kari kangal, nyulu ngayku kangkalkuda.’ ");
INSERT INTO gvn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jana workingmanangka majamu kangkal nyajin kankadanya, jana jana-karrajiku balkawan, ‘Yanyu majamu kangkal. Ngana nyungun yarkinkaku kuninka, yinyamun yanyu bubu nganangakuda.’ ");
INSERT INTO gvn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jana majamu kangkal karrbanda, yarkinkaku kunin, ngalkalba yilban.” Jesusangka babajin, “Nyulu maja nyunguwunbu bubungu dungay baja, nyulu wanjarrmal jananka workingmananka buyunku? ");
INSERT INTO gvn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nyulu jananin yarkinkaku kunilkuda. Yinyamun nyulu yindu bama ngulkurr manil, nyunguwunbu bubungu workmanijinka.” Jana bamangka yinya kuku nyajin, jana Jesusanda yalaman, “Yuy, nguba yala kari!” ");
INSERT INTO gvn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesusangka jananin nyajin, yalaman, “Yuwu, yalakudabi! Godungku ngadiku nyunguwunbuku kabanba balkan, ‘Bamangka bayan ngaranka, jana nguba juku bakarrka nyajil, yilbal, wawu kari yaluynku jukuku. Yamba Godungku bayan ngaranka, nyulu yinya juku manil bakarrka, dandi bajaku.’” ");
INSERT INTO gvn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jesusangka yalaman baja, “Bakarr dandi bajakulu, junkurrji yala ngayu. Ngayu Godundumunji junkurrji. Ngayu yala kulji yalbay. Kaki bamangka nganya kuku kari nyajil, yinya yala jana kuljinga daray. Kaki bamangka nganya kuku kari nyajil, Godungku jananin yarkinkaku kunil yala-yala ngayu kaday baja. Ngayu yala kulji yalbay bajaku. Godungku jananin yarkinkaku kunil. Yinya yala ngayu jananda daray, jananin nyarrilkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jana teacher-teacher ngadimunku, maja-maja Godundumunku bayanka, jana binal Jesusangka yinya story balkan jananka. Yinyaynka jana nyungun karrbanka, jailba mumbanka. Yamba jana yinyilji bamanka wubulkuku. ");
INSERT INTO gvn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yinyaynka jana kujin, nyungun juma karrbanka. Jana kanbal bama buyun yungan Jesusanda, Jesus jurril-bunganka, catchim-bunganka, nyulu nguba buyun balkal Governmentanka. Yinyamun jana nyungun Governmentanda mambarrinka. ");
INSERT INTO gvn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jana bamangka buyunyungku yalaman, “Maja, nganjin binal yundu kuku manubajabuku balkal. Nganjin binal yundu bama manubajabuku binal-bungal Godunku. Nganjin binal yundu yinyil kari bamanka majanka, yundu kuku kari jurrkil bamanka. ");
INSERT INTO gvn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ngana bama Jew-warra wanjarrmal taxmunku? Yalada ngana tax payim-bunganka majanda jirrayanda townbu Rome? Nganandamundu lawmundu kiril or kari?” ");
INSERT INTO gvn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yamba Jesus binal jana nyungun jurril-bunganka, catchim-bunganka. Nyulu jananda yalamanda, ");
INSERT INTO gvn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Money ngaykundu milbi tax payim-bunganka.” Jana money dajin nyungundu. Yinyamun nyulu jananda babajin, “Walu ngurma wanjuymbu moneynga? Burri wanju?” Jana yalaman, “Maja townbu Rome.” ");
INSERT INTO gvn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesusangka jananda yalamanda, “Yalada, yurra majamu yalbaymba money nyungunduku daya. Yamba yurra yalarrku Godumuku money daya nyunguwunku workmunku yala lawmundu balkal.” ");
INSERT INTO gvn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jana kungkurr-kadarin nyunguwunku kukuku. Jana nyungun can't jurril-bungan, catchim-bunganka jakalba bamanda wubulbu. Yinyaynka jana jankamarinkuda. ");
INSERT INTO gvn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yala-yalaku kanbal Sadducee-warra Jesusanda kadarin. Jana balu nyajin bama kari juranmal baja yarkinmun. ");
INSERT INTO gvn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jana Jesusanda yalaman, “Maja, Mosesangka ngadiku yanyu law balkan, ‘Kaki dingkar kangkal-kariku wulay, nyunguwundu yabajungku nyungu manyarr wunay. Bulanga kangkal-kangkal yala yabamu kangkal-kangkal.’ ");
INSERT INTO gvn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yala, yundu yanya story nyaka. Ngadiku yaba-yabaju 7-bala bundandarin. Nyulu yaba jakalbamunku marrymanijin. Nyulu kangkal-kariku wulan, manyarr bawan yabajundu. ");
INSERT INTO gvn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yabajungku jurungu bunjil manyarr wunan. Nyulu kangkal-kariku wulan. ");
INSERT INTO gvn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yabajungku jurungu bunjil manyarr wunan, kangkal-kariku wulanda. Kanbal-kanbalda yalarrku jalbu bunjil wunan yabandamun, kangkal-kariku wulan. ");
INSERT INTO gvn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kudamundu jalbuda wulan. ");
INSERT INTO gvn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kaki jumalu wubulku bama juranmal baja, manyarr wanyambaku? Jananga yaba-yabajumuku wubuliymbaku yinya manyarr.” ");
INSERT INTO gvn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesusangka yalaman jananda, “Bama nyiku bubungu bundandari, jana yalaku, marrymalmaniji. ");
INSERT INTO gvn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yamba Godungku bama ngulkurr juma juran-bungal baja yarkinmun, yinyarrin kari marrymaniji baja. ");
INSERT INTO gvn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bama juranmal baja yarkinmun, jana kari wulay baja. Jana yala jiri-warra, kari wulay, kari marrymaniji. Jana Godumu kangkal-kangkal, jana yarkinmun juranmanya. ");
INSERT INTO gvn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosesangka yalarrku balkan bama juranmal baja yarkinmun. Mosesangka story kabanba balkan juku wayjun-wayjujinya. Nyulu yinyayngka storybu balkan Godunku, ‘God Abrahamamu God, nyulu Isaacamu God, nyulu Jacobamu God.’ ");
INSERT INTO gvn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nyulu God yarkin-warramu kari. Nyulu juran-warramuku God, jana yarkinmun juranmal baja. Godungku nyunguwunbu bamanga wawu nyajil. Jananga wawu kari wulay, wuljaljiku juranku bunday.” ");
INSERT INTO gvn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kanbal teacher-teacher lawmunku yinyaymba janjanarin. Jana Jesusamu kuku nyajin, jana yalaman, “Yinya kuku ngulkurr, Maja. Yundu jananda Sadducee-warranda kuku ngulkurr balkan.” ");
INSERT INTO gvn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yinyamun jana bama yinyilji, Jesusanda kuku babajinka baja. ");
INSERT INTO gvn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wawu yinyamun Jesusangka jananda babajin, “Wanyurrinku bamangka balkal nyulu Christ Davidandamun? Wanyurrinku jana balkal nyulu maja king yala David? ");
INSERT INTO gvn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ngadiku Davidangka Godumu kuku kabanba balkan. Nyulu balkan, ‘Nyulu Majangka Godungku yalaman ngaykuwunbu majanda, “Ngali maja-karrajiku muruku bunday. ");
INSERT INTO gvn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kanbal yununku wawu kari bajaku, ngayu jananin buyun-damal. Juma yundu maja jirraymal jananka.” ’ ");
INSERT INTO gvn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidangka Christ Maja bamban. Nyulu Christ wanjarrku Davidandamun kadan?” ");
INSERT INTO gvn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jana bamangka wubulduku nyungu kuku nyajin-nyajin. Jesusangka yalaman, ");
INSERT INTO gvn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mumbarmaka jananka teacher-teacheranka lawmunjirrka. Jana wawu jirray bamangka jananga kambi kalbali nyajinka. Kaki bamangka jananin maku-nyajil, jana wawu bamangka janangan bambanka, teacher. Jana Jew-warrandamunbu churchmunbu dungari, jana chairnga jakalba bundari, bamangka jananin nyajinka. Jana mayinga jirraymba dungari, jana placemunbu ngulkurrbu bundarinka. Jana bulmbuy bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jana teacher-teacherangka jalbu-jalbu bunjil buyun-damal, bunjilamu bayan bunjilandamun manil. Yinyamun jana ngadingka praymanijinka, janaku milbijinka yalbaymanka. Godungku juma jananin yaykarrdaku punishim-bungal, jurrilmalmanya God wukurrinya. Nyulu kanbal bama buyun jarra yala punishim-bungal teacher-teacheranka.” ");
INSERT INTO gvn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Godundumunbu bayanba yalbaymba yulal box wunanan, bamangka Godumu money yijarril-yijarrinka. Jesusangka dingkar-dingkar rich-bala nyajin money jirray yijarrinya. ");
INSERT INTO gvn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nyulu yalarrku bunjil jalbu nyajin kadanya. Nyulu money kari bajaku, poor-bala bajaku. Nyulu bunjilangka 2 cents yijarrin. ");
INSERT INTO gvn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesusangka jawun-karranda yalaman, “Ngayu yurranda balkal, yinyangka bunjilangka jarra yalbay yijarrin kanbalanka. ");
INSERT INTO gvn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Jana money jirray bajaku, yamba jana kari wubulku dajin baja Godumu, kanbalku. Nyulu bunjilangka money wubulku dajinyarrku. Nyulu money kari kujin baja, mayi maninka.” ");
INSERT INTO gvn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jana jawun-karrangka 12-balangka jana-karrajiku balkal-balkawan. Jana yalaman, “Godumu bayan yalbay nyaka. Kulji ngulkurrijin nyaka. Junjuy-junjuy ngulkurrijin nyaka bamangka Godundu dajinya.” ");
INSERT INTO gvn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jesusangka jananda yalaman, “Yurra bayan yalbay nyajin-nyajilda. Yinya bayan juma dumbarrijikuda. Yinya manubaja, bamangka kulji daray-manil, wubulku yilbal bubungu. Kulji-kulji wubulku bayanmun ngami-ngamiku bubungu wunay.” ");
INSERT INTO gvn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jawun-karrangka 12-balangka nyungundu babajin, “Bayan wanja-wanja dumbarriji? Yundu kadanjiku, yanyu bubu wanjarrmal? Wanjarrmal, before bubu, jiri kunbanjiku?” ");
INSERT INTO gvn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesusangka jananda yalaman, “Yurra mumbarmaka. Kari milka-janay jurrilanda. Bamangka kanbalda yurranin wadu-waduku binal-bunganka bubu kunbanyamunku. Bama wubulku kaday, janankaku yalamal, ‘Ngayu Christ, time kadanda.’ Yurra jananin kari wukurrika, jana jurrilmanya. ");
INSERT INTO gvn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yala-yala bama wubulku mabarrba kuniway. Yurra nyajil, kari yinyilmaka. Jana kuniwaykuda, yamba bubu kariku kunbay. ");
INSERT INTO gvn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Bama nyubunmun bubumun kuniway bamanji yindu-yinduynji bubumun yinduymun. ");
INSERT INTO gvn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bubu yiringkurrku bulngaji. Bubu bulngaji baja, bulngaji baja. Mayi yamba-karimal, bama dakwuyku bundari. Bama bambaymari. Junjuy-junjuy walu-yindu walu-yindu kaday jirimun. Bama yararri, yinyilmarikuda. ");
INSERT INTO gvn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yinya time kadanjiku, jana yurranin mambarril maja-majanda jirrayanda. Jana maja-majangka yurranin warrngkay-manil. Bamangka yurranin courtcasemunbu yungal Jew-warrandamunbu churchmunbu, yurranin jailba mumbal. Jana yurranin buyun-damal, yurra nganya wukurrinya. ");
INSERT INTO gvn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jana yurranin jakalba maja-majanda courtcasemunbu wundil, yinya good chance yurra jananda Godumu kuku ngulkurr balkanka. ");
INSERT INTO gvn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jana yurranin mambarrinjiku, yurra kuku dukulbu mana, kari milka-bujarmanka. Kari milkabu mana wanyu yurra jananda balkanka. ");
INSERT INTO gvn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ngayu yurranda kuku junkurrji dajilda. Yurra kuku ngaykundumun balkal jananda, jana yurranin kari bajaku nyuyal baja. ");
INSERT INTO gvn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bama wubulku kuli balkaji yindu-yinduynku. Nganjanangka, ngamungku yurranin maja-majanda kulijinda mambarril. Yabangka, yabajungku, jawun-karrangka wubulduku yurranin mambarril maja-majanda. Jana yurranin kanbal yarkinkaku kunil. ");
INSERT INTO gvn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bama wubulku yurranka wawu-karimal, yurra nganya wukurrinya. ");
INSERT INTO gvn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yamba yurra kari yinyilmaka, Godungku yurranin ngulkurrduku kujil, yurra kari wulay. ");
INSERT INTO gvn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yurra junkurr-janay. Yinyamun Godungku yurranin wuljaljiku juranku kujilkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesusangka yalaman baja, “Yurra juma soldier-soldier wubul nyajil ngalkalba yinyangkarrku towndurr Jerusalemmundurr. Army jirray yiringkurr mabarrba kuniwanka bamanji townbu Jerusalemmunbu. Yurra yinya nyajil, yurra binalda jana juma Jerusalem-warra wubulku yarkinkaku kunil, bayan wubulku dumbarril, kunbay-manil. ");
INSERT INTO gvn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bama bubungu Judea bundandari, jana jinbalku wuburrbu warririkakuda. Jana townbu Jerusalem, jana town bawada. Jana ngalkalba yuba townbu bundandari, jana kari wala townbu. ");
INSERT INTO gvn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yala-yala Godungku bama Jew-warra yaykarrdaku punishim-bungal. Yinyamundu nyungu kuku wubulku manubaja-bungal. Jana prophet-prophetangka ngadiku Godumu kuku kabanba balkan bamanka Jew-warranka. Yinya kuku manubajamalkuda punishmentmunku. ");
INSERT INTO gvn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yala-yala jana jalbu-jalbu kulngkul wanjarrmal, wuburrbu dakanka? Jana murruji warriri. Jalbu-jalbu ngawanji yalarrku wuburrbu kari dakal. Kuli jirray bubungu yiringkurrku. Godungku bama yaykarrdaku punishim-bungalkuda. ");
INSERT INTO gvn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Soldier-soldierangka kanbal naybubu bakal, kanbal townmun manil, bubungu yinduymbu wundil, jailba mumbal. Bama Gentile-warra majamal townmunku Jerusalemmunku. Jana ngadingka yinyaymba bundari. Yamba right-timemalda, Godungku jananin kangal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","Jesusangka yalaman baja, “Ngayu juma kaday baja. Ngayu bamanga wubulbuku yaba. Yala-yala wungar, kija, dawar jiringa kari junkayku dungari, kurru-kurruku dungari, wubulku bulngajirida. Bamangka numburr jirray nyajil yala mulngku jukara jalunbu. Yinyaynka jana yaykarrku wawu-dudajiri, bubungu darari, yinyilmarinya. ");
INSERT INTO gvn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yala-yala bamangka nganya nyajilda kankadanya ngurrbanji jirimun. Ngayu bamanga wubulbuku yaba. Ngayu junkurrjiku kaday, maja jirrayku. Dayirr-dayirr bajaku kaday. ");
INSERT INTO gvn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yurra yinya trouble nyajil kankadanya, yurra kari yinyilmarika, junkurr-janarika. Godungku nyiku baja yurranga wawu juran-bungal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yinyamun Jesusangka jananda story balkan. Nyulu yalaman, “Kuli trouble jirray kadanjiku yala yanyu story jukuku wawuburraka. ");
INSERT INTO gvn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wawuburra ngankakuda, wungarajida, minyaka jarrukamunkuda. Yurra nganka nyajil, yurra binalda, minyada. ");
INSERT INTO gvn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yalarrku yurra kuli trouble nyajil, yurra binalda ngayu nyiku baja kaday baja, ngayku bama ngulkurrduku kujinka. ");
INSERT INTO gvn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yurra milkanga kuji. Bama jurankulu, jana wubulku wulanjiku, junjuy-junjuy manubajamal yala ngayu yurranda balkanda. ");
INSERT INTO gvn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jiri, bubu kunbay, yamba ngayku kuku kari bajaku kunbay. Ngayku kuku junkurrji, kari kunbay.” ");
INSERT INTO gvn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jesusangka yalaman baja, “Yurra mumbarmaka! Bubu, jiri juma kunbay, yala-yala ngayu kaday baja. Yurra miyil-janay yinyaynka timemunku. Kari milkabu wukurrikada mayika, yamba-yambaka, yamba milkabu wukurrikada yinyaynka timeka buyunku. Kari ngambaku bundarika. ");
INSERT INTO gvn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bubu, jiri jinbalku kunbay. Bamangka yiringkurrku nyajil kuli jinbalku kadanyamunku. ");
INSERT INTO gvn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yurra mumbarmaka. Wuljaljiku praymaka. Godundu babajika junkurrku, yurra junkurr-jananka yinyaynka troubleku kulika. Yurra nganya kari darrbi. Ngayu kaday baja, yurra ngaykunji bundayda. Ngayu bamanga wubulbuku yaba.” ");
INSERT INTO gvn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesusangka wungara bama binal-bunganya Godundumunbu bayanba yalbaymba. Yilay-yilaymanya nyulu wuburrbu Olivesmunbu dakanya. Yinyaymba nyulu warngku wunanya. ");
INSERT INTO gvn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bama yalibalaku Godundumunbu bayanba yalbaymba dungarinya, nyunguwunbu kukungu milka-janarinya. ");
INSERT INTO gvn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Holiday Passover yuba kankadanda. Holiday Passover bama Jew-warra murumarin, mayi bread balan-balan nukanka, God buyay-maninka. ");
INSERT INTO gvn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jana maja-maja Godundumunku bayanka yalbaynka, jana teacher-teacher lawmunku, jana Jesus yarkinkaku kuninka. Yamba jana yinyilji bamanka, bama Jesusanka wawu-jirraymanya. Yinyaynka jana Jesus kiraynjaku yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yala-yala nyulu Dubu Satan Judasandamunbu dukurrbu walan. Judas burri yindu Iscariot. Nyulu jakalbaku Jesusandamunbu jawun-karranda kunaman. ");
INSERT INTO gvn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yinyamun nyulu Judas maja-majanda priestanda, maja-majanda soldier-soldieranda dungan. Jana soldier-soldierangka Godumu bayan miyil-kujin. Judas jananda dungan, balkawan Jesus mambarrinka jananda. ");
INSERT INTO gvn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jana maja-maja wawurr-wawurrmanijin, yalaman, “Nganjin yunundu money dajilkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yinyamun Judasangka good chance kujin, Jesus kiraynjaku mambarrinyamunku jananda maja-majanda. ");
INSERT INTO gvn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yala-yala time kadanda holiday Passovermunbu. Jana minya sheep karrkay kuninka, nukanka. ");
INSERT INTO gvn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesusangka bulanda Peteranda, Johnundu yalaman, “Yubal dungay, minya sheep, mayi ready-bunga, ngana wubulduku nukanka.” ");
INSERT INTO gvn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bula nyungundu babajin, “Wanjabu ngalin ready-bungal?” ");
INSERT INTO gvn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nyulu yalaman, “Yubal dungay townbu, yubal dingkar maku-nyajil, jungkalu banaji jarra-kulbal-kulbanya. Yubal nyungun wukurrika bayanba. ");
INSERT INTO gvn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yubal dingkaranda majanda bayanka balka, ‘Majangka Jesusangka babajin, “Room wanjabu ngayu, ngaykuwundu jawun-karrangka mayi Passover nukanka?” ’ ");
INSERT INTO gvn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nyulu dingkarangka yubalan wangkar-wangkar roommunbu yalbaymba wundil tablebu, chairanga. Yinyaymba yubal minya, mayi ready-bunga.” ");
INSERT INTO gvn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bula dungan, wubulku warrmba-bungan yalaku Jesusangkaku yalaman. Yinyaymba bula mayi Passover ready-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Time kadanda mayi Passover nukanka, Jesus tablebu bundan jawun-karranji 12-balanji apostlesanji. ");
INSERT INTO gvn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nyulu jananda yalamanda, “Ngayu wawu jirray yanyu mayi Passover nukanka yurranji, ngayu warrngkanjiku. ");
INSERT INTO gvn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngayu yurranda balkal, wawu nukanyamun ngayu mayi Passover kari nukal baja. Juma Godungku nyungu bama ngulkurrduku kujil. Yinyamun jana mumbarku binalmal yanyunku mayika. Yinyamun ngayu nukal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yinyamun Jesusangka cup winemunji manin, God thankim-bungan, jananda yalaman, “Yanyu mana, dajiwaka. ");
INSERT INTO gvn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngayu yurranda balkal, wawu nyikumun ngayu yalaku wine kari nukal baja. Juma Godungku nyungu bama ngulkurrduku kujil. Yinyamun ngayu nukal baja.” ");
INSERT INTO gvn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yinyamun Jesusangka bread manin, God thankim-bungan, mayi bread dumbarrin, jawun-karranda dajin. Nyulu yalaman, “Yanyu ngayku bangkarr, ngayu yurranka dajijin. Kaki yurra nukal, yurra milkabu wukurrika ngayu ngayku bangkarr yurranka dajijin.” ");
INSERT INTO gvn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wawu mayimun, nyulu jananda yalarrku cup winemunji dajin, yalaman, “Yanyu yira wine ngayku mula. Godungku promise dajin bamanda. Ngayku mula warri, yinya kuku manubajamalkuda. Ngayu mula dajiji yurranka.” ");
INSERT INTO gvn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yinyamun Jesusangka yalaman baja, “Yurra nyaka, nyubun yalaymba tablebu bundanday, nyulu nganya mambarril bamanda, jana nganya karrbanka. ");
INSERT INTO gvn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ngayu bamanga wubulbuku yaba. Ngayu juma wulaykuda yala Godungku balkan. Yamba nyulu bamangka nganya mambarril, kuli jirray nyungundu kaday.” ");
INSERT INTO gvn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yinyamun jana jawun-karra jana-karrajiku balkawan, babajin, “Wanyangka nyungun mambarril?” ");
INSERT INTO gvn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jana jawun-karrajiku murru-kangawan, babajin, “Wanju majamal?” ");
INSERT INTO gvn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesusangka yinya kuku nyajin, nyulu yalaman, “Bama kanbal Jew-warra kari, jana Godunku binal kari. Jananga maja-maja junkurrji bamanka. Jana maja-majangka bama mambarril, jananin jawun bambanka. Yamba jana jawun kari, majakuda. ");
INSERT INTO gvn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yamba yurra yala kari. Kaki yurra majamanka bamanka, yurra yurraku bubanmaka. Maja nyuluku bubanmaka yala workingman, jarra warru bajakulu. ");
INSERT INTO gvn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wanju jarra yalbay, bama tablebu bundanday or bamangka nyungu mayi wundil? Yuwu, bama tablebu bunday, nyulu maja, yindu workingman. Ngayu kari kadan majamanka. Ngayu kadan workingmanmanka, bama helpim-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jesusangka 12-balanda yalaman, “Yurra ngaykunji kadarin yiringkurrku. Kanbal ngaykunku wawu kari, nganya buyun-daman, yamba yurra nganya kari bawan. ");
INSERT INTO gvn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngaykuwundu nganjanangka nganya maja-bungan. Ngayu yalarrku yurrangan maja-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yala-yala ngayu ngayku bama ngulkurrduku kujil, yurra ngaykunji bundari, ngaykunji mayi nukal. Yala-yala yurra majamari Jew-warranka.” ");
INSERT INTO gvn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesusangka Simon Peteranda yalaman, “Simon, yundu nyakada. Dubungku Satanangka Godundu babajin yurranka jawun-karranka. Nyulu yurranin milka-bakanka buyunmanka. Nyulu yurrangan ngami-ngami-bunganka ngaykundumun, yala muyarabu diburr ngami-ngami-bungal rubbishmun. ");
INSERT INTO gvn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yamba ngayu Godunji balkawan, babajin yununin junkurrji-bunganka buyun-buyunku. Ngayu nyungundu babajin yundu ngaykuwunbu kukungu milka-jananka. Yundu juma nganya bawal, nganya darrbil. Yamba yundu jurrkiji baja, ngaykunku wawu-jirraymal baja. Yinyamun yundu junkurrjimal, yundu ngayku bama yindu-yindu junkurrji-bunga buyun-buyunku.” ");
INSERT INTO gvn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peterangka yalaman, “Maja, jana nganya nguba jailba mumbal, nganya nguba yarkinkaku kunil, yamba ngayu yunun kari bawal, kari bajaku darrbil.” ");
INSERT INTO gvn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesusangka Peteranda yalaman, “Milkanga kuji yanyu kuku ngayku. Jukijuki yirrkanjiku, yundu 3 times balkal, yundu ngaykunku binal kari.” ");
INSERT INTO gvn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesusangka jawun-karranda yalaman, “Ngadiku ngayu yurrangan yungan bamanji bundanka. Yurra money ngunyinda kari wundin, kurmun kari wundin, dambal yindu kari wundin.” Nyulu jananda babajin, “Yala-yala yurra dungarin, yurra dakwuyku dungarin? Bamangka yurranji dajiwan? Yurranin yulmbarrin or kari?” Jawun-karrangka yalaman, “Jana nganjinan yulmbarrin, nganjinanji dajiwankuda, nganjin kari dakwuyku dungarin.” ");
INSERT INTO gvn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesusangka yalaman, “Nyiku walu-yinduda. Bamangka juma yurranga kari dajil baja. Yurra money ngunyinda wundida. Yalarrku yurra naybu sword wundi. Kaki yurra naybu kari, yurra kambi sellim-bunga, naybu buy-im-bunganka. ");
INSERT INTO gvn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngadiku prophetangka Godumu kuku kabanba balkan ngaykunku. Nyulu balkan, ‘Bamangka nyungun jailba mumbanka, balu nyulu buyun bajaku.’ Yinya kuku ngaykunku must manubajamaka.” ");
INSERT INTO gvn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jawun-karrangka yalamanda, “Nyaka, Maja, naybu sword jambul yaluy.” Jesusangka jananda yalaman, “Kari, bawa. Ngayu storybuku balkan, yurranin binal-bunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jana Jesusangka town bawan, wuburrbu Olivesmunbu dungarin. Jana yarbarrka yinyaymba dungarin. ");
INSERT INTO gvn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jana kadarin, Jesusangka jananda yalaman, “Miyil-janay, praymaka, yurra kari milka-jananka Dubundu.” ");
INSERT INTO gvn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yinyamun nyulu jananin bawan, buban dungan, bungkubu janan, praymanijin. ");
INSERT INTO gvn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nyulu yalaman, “Nganjan, ngayu wawu kari wulanka. Yamba yunduku nganya balkan wulanka bamanka wubulkuku. Ngayu wulayda jananka, yala yunduku wawubu.” ");
INSERT INTO gvn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nyubun angel jirimun nguwimal milbijin, nyungun junkurrji-bunganda. ");
INSERT INTO gvn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nyulu milka-bujarku prayman, yaykarrku prayman. Jila warrin nyungundumun yala mula, bubungu daran. ");
INSERT INTO gvn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wawu praymun, nyulu jawun-karrandaku dungan baja. Jana milka-bujar, baja-burray, yinyaynka jana warngku wunanarin. ");
INSERT INTO gvn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesusangka jananda yalaman, “Yurra wanyurrinku warngku wunanay? Wandi, praymaka, yurra kari milka-jananka Dubundu.” ");
INSERT INTO gvn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus balkan-balkawaynku, bama wubul kadarin. Judasangka jananin juru-kulban. Nyulu jakalbaku Jesusamu jawun. Nyulu Jesusanda kadan, nyungun kissim-bunganka. Judasangka jananda jakalbaku balkan, “Ngayu dingkar kissim-bungal, milbinka yinyakudabi Jesus. Nyungun karrbada.” ");
INSERT INTO gvn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesusangka Judasanda yalaman, “Judas, ngayu bamanga wubulbuku yaba. Yala yundu kissmundu nganya mambarril jananda?” ");
INSERT INTO gvn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jana jawun-karrangka Jesusandamundu yinya nyajin, jana nyungundu babajin, “Maja, yundu wawu nganjin jananji naybubu kuniwanka?” ");
INSERT INTO gvn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yinyamun nyubunyinja jawunyungku bamanga slaveamu milka yakan naybubu swordmundu. Nyulu slave majamu yalbaymu Godundumunku bayanka. ");
INSERT INTO gvn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yamba Jesusangka yalaman, “Kari bajaku. Yala kari!” Yinyamun nyulu slaveamu milka karrban, ngulkurr-bungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bama wubul bajaku yinyay. Kanbal maja-maja jirray Godundumunku bayanka, kanbal soldier-soldier Godundumunku bayanka, kanbal elder-elder Godundumunku bayanka. Jana wubulku kadarin, Jesus karrbanka. Jesusangka jananda yalaman, “Yurra wanyurrinku naybujiku, jukujiku ngaykundu kadarin, nganya karrbanka? ");
INSERT INTO gvn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngayu wurrmay-baka kari. Yurra nganya every day nyajin Godundumunbu bayanba, bama binal-bungal-bunganya, yamba yurra nganya kari karrban. Yurra nganya nguwul-nguwulbu karrbankada, Dubungku yurrangan milka-bakanya. Nyulu Dubu maja jirray nguwul-nguwulku.” ");
INSERT INTO gvn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jana Jesus karrban, nyungun bayanba wundin. Bayan majamu yalbayamu Godundumunku bayanka. Peterangka jananin wukurrin kala-kalbaymundu. ");
INSERT INTO gvn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nyulu fencemunbu walan majandamunbu bayanba, baya nyajin wayjun-wayjujinya dindarra yardba. Kanbal bama bayanga bundandarin. Nyulu dungan, jananda kunaman. ");
INSERT INTO gvn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nyubunyinja jalbungku Peter nyajin bundandanya. Yinya jalbu workmanijin majanka jirraynka. Nyulu jalbungku Peter biku-nyajin, yalaman, “Yanyu dingkar yalarrku Jesusanji bundandan.” ");
INSERT INTO gvn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yamba Peterangka darrbin, jalbundu yalaman, “Jalbu, ngayu nyungunku binal kari.” ");
INSERT INTO gvn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Juma nyubunyinja dingkarangka yalarrku Peter nyajin, yalaman, “Yundu Jesusamu jawun.” Yamba Peterangka yalaman baja, “Kari, ngayu janandamun kari.” ");
INSERT INTO gvn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Juma yinduynju bamangka Peteranda yalaman, “Yundu Jesusanjikuda dungan-dungan. Yundu Galilee-warramu kuku balkan-balkaway.” ");
INSERT INTO gvn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peterangka yalaman, “Kari bajaku. Yundu wadu-wadukuda.” Peter balkan-balkawaynku, jukijuki yirrkaynda. ");
INSERT INTO gvn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nyulu Maja Jesus jurrkijin, Peter junkayku nyajin. Jinbalku Peteranda milkanga kadan kuku Jesusangka balkan nyungundu. Jesusangka jakalbaku Peteranda yalaman, “Jukijuki yirrkanjiku, yundu nganya 3 times darrbil.” ");
INSERT INTO gvn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peter ngalkalba dungan, milka-bujarku badinda. ");
INSERT INTO gvn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kanbalda soldier-soldierngka Jesus miyil-kujin. Jana nyungun yajarrin, jukubu kunin. ");
INSERT INTO gvn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jana nyungun miyil nandan, babajin, “Wanjungku yunun kunin, nganjinanda balka.” ");
INSERT INTO gvn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yinyamundu jana nyungundu kuku buyun balkan baja, balkan baja. ");
INSERT INTO gvn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wungar dakan, jana bama elder-elder, maja-maja jirray Godundumunku bayanka, teacher-teacher lawmunku, jana wubulku murumarin council meetingmunku. Soldier-soldierangka Jesus jakalba Councilanda wundin. ");
INSERT INTO gvn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Jana Jesusanda babajin, “Yundu bama Godundumun? Yundu Godumu Christ? Nganjinanda balka.” Nyulu jananda yalaman, “Kaki ngayu yurranda balkal, yurra ngaykuwunbu kukungu kari milka-janay. ");
INSERT INTO gvn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kaki ngayu yurranda kuku babaji, yurra nganya kari answerim-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kari. Wawu nyikumun yurra nganya nyajil bundandanya Godunji. Ngalin junkurr-muruku bunday. Ngayu bamanga wubulbuku yaba.” ");
INSERT INTO gvn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jana nyungundu babajin baja, “Yundu Godumu kangkal or kari?” Jesusangka yalaman, “Ngayukuda.” ");
INSERT INTO gvn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jana jana-karrajiku balkawan, “Bama yindu kari wundi baja, nyungun nyuyanka. Ngana nyungun nyajin yalamanya, ‘Ngayu Godkuda.’” ");
INSERT INTO gvn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wawu yinyamun jana wubulku dakarin, Jesus Pilateanda wundin. Nyulu townmun Romemun. Pilate nyulu maja jirray Jew-warrandamunku bubuku. ");
INSERT INTO gvn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jana Jesus nyuyan Pilateanda. Jana yalaman, “Nganjin yanyu dingkar nyajin bama buyunku juru-kulbanya, buyun-buyun wukurrinka. Nyulu bamanda balkan tax money kari Governmentanda payim-bunganka. Nyulu yalarrku yalaman nyulu bama Godundumun, Godumu Christ, bamanga king.” ");
INSERT INTO gvn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilateangka Jesusanda babajin, “Kuda yundu Jew-warramu king?” Jesusangka yalaman, “Ngayukuda.” ");
INSERT INTO gvn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yinyamun Pilateangka maja-majanda Godundumunku bayanka, and bamanda wubulbuku yalaman, “Yanyu dingkar kari malaji buyun-buyunku.” ");
INSERT INTO gvn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yamba jana yaykarrku yirrkan, “Nyulu bama wadu-waduku binal-bungal. Yinyamundu nyulu bama kiru-kari-bungal, jana kuniwanka yiringkurrku bubungu Judea. Nyulu jakalbaku bama yalaku binal-bungan bubungu Galilee, yinyamun nyulu yalaymba kadan.” ");
INSERT INTO gvn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilateangka yinya kuku nyajin, nyulu babajin, “Yanyu dingkar bubumun Galileemun?” ");
INSERT INTO gvn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jana nyungundu yalaman, “Nyulu bubumun Galileemunkuda.” Pilate binal nyulu Herod maja jirray bubuku Galileemunku. Yinyaynka nyulu Jesus Herodanda yungan. Yala-yalaku Herod townbu Jerusalem bundandan. ");
INSERT INTO gvn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodangka Jesus nyajin, nyulu wawurr-wawurrmanijin, nyulu kuku nyajinya nyungunku. Nyulu wawu nyajinka Jesusangka junjuy-junjuy miracle yalbay balkanya Godundumundu junkurrdu. ");
INSERT INTO gvn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yinyaynka Herodangka Jesusanda kuku wubul babajin, yamba Jesusangka nyungun kuku kari manin. ");
INSERT INTO gvn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jana maja-maja Godundumunku bayanka, teacher-teacher lawmunku, jana Jesus junkurr-murubuku nyuyan buyun-buyunku. ");
INSERT INTO gvn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodangka, nyunguwundu soldier-soldierangka Jesus yajarrin, nyungun buyun-daman. Yinyamun jana kambi flash-bala nyungundu didan, Pilateanda yungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jakalbaku Pilate bula Herod bula-karrajiku kuli-kuliman. Wawu yinyamun bula jawun-jawunmanda. ");
INSERT INTO gvn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilateangka jananin maja-maja Godundumunku bayanka, yindu maja-maja, bama wubul muruku kunjan. ");
INSERT INTO gvn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nyulu jananda yalaman, “Yurra yanyu dingkar ngaykundu wundin, balkan nyulu bama wadu-waduku binal-bungal-bungan. Ngayu nyungun wawu-yimban yurranda jakalba, yamba nyulu malaji kari. ");
INSERT INTO gvn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nyulu Herod yalarrku binal nyulu malaji kari, nyulu nyungun yaluy yunganya baja. Yanyu dingkar kari bajaku malaji. Ngana nyungun kari yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yinyaynka ngayu ngaykuwunbu soldier-soldieranda balkan nyungun wuybubu kulbanka, yinyamun nyungun yunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mayi Passover time Pilateangka nyubun bama jailmun yunganya, jana yalaku. ");
INSERT INTO gvn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bamangka wubulduku yirrkan, “Nyungun Jesus yarkinkaku kuni, yarkinkaku kuni. Barabbas yunga jailmun.” ");
INSERT INTO gvn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nyulu Barabbasangka bama juru-kulban, governmentanji kuniwanka. Nyulu bama yarkinkaku kunin. Yinyaynka Governmentangka nyungun jailba mumban. ");
INSERT INTO gvn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilateangka Jesus jailmun yunganka. Yinyaynka bamanda yalaman baja, “Ngayu nyungun yungalkuda.” ");
INSERT INTO gvn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yamba jana bama yaykarrku yirrkan baja, “Nyungun jukungu nailda dama, jukungu walngkan-dama!” ");
INSERT INTO gvn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilateangka jananda babajin baja, “Nyulu wanyu buyun balkan? Ngayu nyungun kari nyajin malaji. Ngayu jananda balkal nyungun wuybubu kulbanka, yunganka.” ");
INSERT INTO gvn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yamba jana yirrkan baja, yirrkan baja nyungun jukungu walngkan-damanka. Jana Pilate mambarrinda nyungun yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yinyaynka nyulu jananga kuku manin, nyungun yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nyulu Barabbas jailmun yungan yala janaku wawubu. Nyulu Barabbas buyun bajaku, bama wubul juru-kulban, bama yarkinkaku kuninka. Yamba Pilateangka Jesus jananda mambarrin, nyungun yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jana soldier-soldierangka Jesus juru-kulban. Jana dungan-dungarin, jana nyubun dingkar maku-nyajin, burri Simon. Nyulu townbu kadan nyunguwunmun bubumun Cyrenemun. Jana soldier-soldierangka Simon karrban, juku Jesusamu cross nyunguwunbu bindanga yijarrin, nyungun mambarrin jarra-kulbanka. ");
INSERT INTO gvn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bamangka wubulduku jananin Jesus wukurrin. Kanbal jalbu-jalbu banbadirin nyungunku. ");
INSERT INTO gvn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus jananda jurrkijin, yalaman, “Yurra jalbu-jalbu townmun Jerusalemmun, kari badirika ngaykunku. Yurra badirika yurrankaku, yurrawunku kangkal-kangkalankaku. ");
INSERT INTO gvn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Juma bamangka yalaku balkal jalbu-jalbundu, ‘Yurra kangkal-kangkal kari, yurra wawurr-wawurrmal, because yurra kangkal kari, bamangka yarkinkaku kuninka. Yurra kaykay-kaykayanji, yurra milka-bujarmal, bamangka jananin yarkinkaku kuninya.’ ");
INSERT INTO gvn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yala-yala bama wubulku kuli-kulimun warrari manjalba. Jana janaku balkalda, ‘Ngulkurr kulji-kulji jirray ngananda daray, ngananin nyarril, yarkinkaku kunil. Yinya jarra ngulkurr kulika ngananin warrngkay-maninka.’ ");
INSERT INTO gvn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bamangka nganya jukungu walngkan-damal, yarkinkaku kunil. Godungku nganya kari nyuyal buyun-buyunku. Yamba Godungku jananin junkurr-murubuku nyuyal buyun-buyunku, jana nganya yarkinkaku kuninya. Kaki jana nganya yalaku buyun-damal, jana yurranin jarra jirray bajaku buyun-damal.” ");
INSERT INTO gvn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jana wurrmay-baka jambul Jesusanji juru-kulban, bulanin yalarrku yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jana bubungu kadarinda, bubu burri Dukul Bajibay. Yinyaymba jana Jesus jukungu walngkan-daman. Bulanin wurrmay-baka jana yinduymbu jukungu walngkan-daman. Jesus, nyulu dindarra. Bula jambul karangkalba nyungundu. ");
INSERT INTO gvn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesusangka Godundu yalaman, “Nganjan, yundu yinyayanka buyun-buyunku milka-wulay. Jana binal kari, kari understandmaniji.” Yinyamun jana soldier-soldierangka dice yilban, nyajinka wanyangka Jesusamu kambi manil. ");
INSERT INTO gvn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jana maja-majangka Jew-warrangka Jesus yajarrin, yalaman, “Nyulu kanbal juran-bungan, yamba nyuluku kari juranmal. Godungku Christ bambal. Kaki nyulu yinya Christ, nyulu yinyamun jukumun walada.” Bamangka wubulduku jananin nyajin yajarrinya. ");
INSERT INTO gvn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jana soldier-soldierangka nyungun yalarrku yajarrin. Jana nyungu wine dajinka, ");
INSERT INTO gvn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nyungundu yalaman, “Kaki yundu Jew-warramu king, yundu jukumun wala.” ");
INSERT INTO gvn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jana yanyu kuku signmunbu balkan wangkar-wangkar Jesusanda, “Yanyu Jew-warramu king.” ");
INSERT INTO gvn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nyubun wurrmay-baka yinyaymba walngkan-walngkan, nyungun yukin, yalaman, “Kaki yundu Christ, bama Godundumun, yundu yunduku walngajika, yalarrku ngalinyan walnga.” ");
INSERT INTO gvn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yinduynju wurrmay-bakangka yalaman, “Yundu yala kari balka. Yundu yinyilmaka Godunku. Jana ngananin kulur jukungu walngkan-daman. ");
INSERT INTO gvn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ngali wurrmay-baka, malaji buyun-buyunku. Yinyaynka jana ngaliyan walngkan-daman. Jana nyungun Jesus yalarrku jukungu walngkan-daman, yamba nyulu malaji kari buyun-buyunku.” ");
INSERT INTO gvn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nyulu wurrmay-bakangka yalaman Jesusanda, “Yundu nganya milkanga kuji, yala-yala yundu kaday baja kingmanka.” ");
INSERT INTO gvn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesusangka nyungundu yalaman, “Ngayu yunundu manubajabuku balkal, ngali nyiku Godundumunbu bubungu ngulkurrbu muruku bunday.” ");
INSERT INTO gvn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wungar jarra-jarra, nguwul-nguwul kadan bubungu yiringkurrku 3-hoursmunku. Wungarabu kari bubu balban baja yilay-yilaymankarrku. ");
INSERT INTO gvn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yala-yalaku curtain yalbay yika-warrin dindarra Godundumunbu bayanba yalbaymba. ");
INSERT INTO gvn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus yaykarrku yirrkan, “Nganjan, ngayu ngayku wawu yunundu dajilda.” Yinyamun nyulu wulanyarrkukuda. ");
INSERT INTO gvn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nyulu majangka soldier-soldierandamundu nyungun nyajin wulanya. Yinyamun nyulu majangka God buyay-manin, yalaman, “Yanyu dingkar junkaykuda, nyulu buyun kari bajaku.” ");
INSERT INTO gvn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bama wubul bajaku murumarin, jananin nyajinka wulanya. Wawu Jesus wulanyamun, jana wubulku milka-bujarku bayanbaku dungarin baja. ");
INSERT INTO gvn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesusamu jawun-karra kanbal kala-kalbay janjanarin, nyungun nyajinka. Jana jalbu-jalbungku bubumun Galileemun Jesus wukurrin, jana yinyarrin yalarrku yinyaymba janjanarin, nyungun nyajinka. ");
INSERT INTO gvn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nyubun bama burri Joseph. Nyulu bubumun Judeamun, townmun Arimatheamun. Nyulu Joseph ngulkurr. Nyulu waitmalman Godungku nyungu bama ngulkurrduku kujinyamunku. Nyulu Joseph maja councilmunbu Godundumunku bayanka yalbaynka. Jana council-council kanbal Jesusanka wawu kari, yamba Joseph nyungunku wawu jirray. Yinyaynka nyulu nyungu vote kari dajin, Jesus yarkinkaku kuninka. ");
INSERT INTO gvn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nyulu Pilateanda kadan, Jesusanka yarkinka babajin. Pilateangka kuku dajin, Josephanda yarkin dajinka. ");
INSERT INTO gvn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Josephangka yarkin jukumun manin, sheetmundu kajan, mulun-bungan. Nyulu yarkin yijarrin juljalba kuljinga bulkajimunbu. Juljal jirakalku bakan. Jana yinya juljal kariku useim-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Fridaynga nyulu yarkin juljalba yijarrin. Saturdaynga jana Jew-warra kari workmanijin, lawmunku. ");
INSERT INTO gvn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jana jalbu-jalbungku bubumun Galileemun Jesus wukurrinya, jana Josephanji dungarin juljalba. Jana nyungun nyajin yarkin juljalba yijarrinya. ");
INSERT INTO gvn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yinyamun jana bayanbaku dungarin baja, jila mini-mini yanday-bungan, yarkin julngkanka. Saturdaynga jana wawu-balangajin, janawunku lawmunku. ");
INSERT INTO gvn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sundaynga yalibalaku jana jalbu-jalbu juljalba dungarin, jilabu mini-minibu yarkin julngkanka. ");
INSERT INTO gvn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jana yinyaymba kadarin, nyajin yinya kulji door yiringkajinya, juljal walngajinya. Yinya kulji jirray jakalbaku juljalmun yiringkajin. ");
INSERT INTO gvn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jana kananga walarin, yamba Maja Jesus yarkin yamba-kari. ");
INSERT INTO gvn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jana binal kari yinyaynka. Jana yinyaymba janjanarin, dingkar-bulal jambul nguwimal milbijin. Bulanga kambi bingaji bajaku, dayirr bajaku. ");
INSERT INTO gvn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jalbu-jalbu yinyilmarin, dukul badamarin bubungu. Bula dingkarangka yalaman, “Wanyurrinku yurra juljalba nubil-nubil bama juranku? ");
INSERT INTO gvn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Nyulu Jesus yaluy karida, nyulu juranman baja. Yurra kari milka-wulanyaku kukuku nyulu yurranda balkan bubungu Galilee. Yinyaymba nyulu yalaman, ‘Ngayu bamanga wubulbuku yaba. Jana nganya mambarril bamanda kuli-bakanda. Jana bamangka nganya jukungu walngkan-damal, yarkinkaku kunil. Warngku kulurmal ngayu juranmal baja.’” ");
INSERT INTO gvn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yinyamun Jesusamu kuku janawunbuku dukulbuku kadan baja. ");
INSERT INTO gvn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jana juljal bawan, bayanba dungarin yinyaymba jawun-karra 11-bala bundandarin. Jana jawun-karranda kuku wubulku balkan juljalka. ");
INSERT INTO gvn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jana jalbu-jalbu juljalba dungarin, jana burri Mary Magdalene, Joanna, Jamesamu ngamu burri Mary. Jana jalbu-jalbungku Jesusandamunbu jawun-karranda kuku wubulku balkan juljalka. ");
INSERT INTO gvn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yamba jana jawun-karrangka apostlesangka balu nyajin jana jalbu-jalbungku jurril-bungal-bunganya, jananda kari milka-janan. ");
INSERT INTO gvn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yamba Peter juljalba warrin, nyajinka. Nyulu badaman, kananga nyajin. Nyulu sheet nyajin wunananya, yamba yarkin yamba-kari. Nyulu kungkurr-kadan, milkabu wukurrin yinyaynka, bayanbaku dungan baja. ");
INSERT INTO gvn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yala-yala, same dayku, Jesusamu jawun-bulal jambul townbu Emmaus dungan-dungan. Yinya town yubaku townbu Jerusalem, 11 kilometres. ");
INSERT INTO gvn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bula bula-karrajiku balkal-balkawan Jesusanka, juljalka, nyunguwunku yarkinka. ");
INSERT INTO gvn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bula balkal-balkawan, Jesus yuba kadan, bulanji kunaman. ");
INSERT INTO gvn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bula nyungun nyajin, yamba bula nyungunku binal kari. ");
INSERT INTO gvn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesusangka bulanda babajin, “Yubal dungan-dungay, wanyurrinku balkan-balkaway?” Bula janan, milka-bujarku. ");
INSERT INTO gvn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nyubun burri Cleopas. Nyulu Jesusanda babajin, “Yundu ngarrbal townbu Jerusalem? Yundu binal kari jana wanjarrmalman jarra nyiku-nyiku?” ");
INSERT INTO gvn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesusangka babajin, “Kuku wanyu?” Bula yalaman, “Kuku Jesusanka townmun Nazarethmun. Nyulu prophet. Godungku nyungun junkurrji-bungan, junjuy-junjuy ngulkurr balkanka. Bamangka nyajin nyulu junkurr-murubuku junjuy-junjuy miracle ngulkurr balkanya. ");
INSERT INTO gvn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nganawundu maja-majangka Godundumunku bayanka yalbaynka nyungun mambarrin, yarkinkaku kuninka. Jana nyungun jukungu walngkan-daman. ");
INSERT INTO gvn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nganjin wawubu kujin nyulu majamanka, ngananin Jew-warra freeim-bunganka janandamun Rome-warrandamun. Yamba warngku kulurku jana nyungun yarkinkaku kunin. ");
INSERT INTO gvn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kanbal jalbu-jalbu nganjinandamun jawun-karrandamun juljalba dungarin yalibalaku, ");
INSERT INTO gvn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yamba jana nyungun yarkin kari warrmba-bungan. Jana kadarin baja, balkan jana angel-bulal nyajin juljalba. Bula angel-bulalangka jananda jalbu-jalbundu yalaman, ‘Nyulu Jesus juranman baja yarkinmun.’ ");
INSERT INTO gvn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kanbal jawun-karra juljalba dungarin, nyajin yala jalbu-jalbungku yalaman. Jana yalarrku nyungun yarkin kari nyajin.” ");
INSERT INTO gvn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yinyamun Jesusangka bulanda yalaman, “Yubal ngambabuku Godumu kaban nyajil prophet-prophetangka balkan. Yubal jananga kuku kari mumbarabuku believeim-bungal. ");
INSERT INTO gvn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Jana prophet-prophetangka yalaman, ‘Bama Godundumun, Christ, nyulu must warrngkay, must wulay. Yinyamun nyulu juranmal baja, wangkar dakal baja heavenba.’” ");
INSERT INTO gvn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesusangka bulanda Godumu kuku milkanga-bungan. Nyulu bulanin binal-bungan Mosesandamunku kukuku, yalarrku prophet-prophetandamunku kukuku. Nyulu bulanda balkan yinyangka kukubu wubulduku balkal Godundumunku Christanka. ");
INSERT INTO gvn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jana yubaku bulawunbu townbu kadarin, Jesus kari janan, towndurr dunganka. ");
INSERT INTO gvn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yamba bula nyungundu yalaman, “Yundu kari dungay baja, bubu nguwul-nguwulmalmalda. Yundu ngalinyanji bunday.” Nyulu bulawunbu bayanba walanda. ");
INSERT INTO gvn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nyulu mayika bundan, bread manin, God thankim-bungan. Yinyamun nyulu bread dumbarrin, bulanda dajin. ");
INSERT INTO gvn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yala-yala bula Jesusanka binalmankuda. Baraldarr bula balu nyulu yindu bama bulanji dungan-dungan. Yamba Godungku bulanga miyil walngan, bula nyungunku mumbarku binalmanka. Yinyamun nyulu walu-kariman. Bula yinyaymba nyungun kari nyajin baja. ");
INSERT INTO gvn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bula bula-karrajiku balkawan, yalaman, “Nyulu Godumu kuku milkanga-bungan baraldarr. Nyungu kuku yala baya wayjul-wayjuji ngaliwunbu dukurrbu.” ");
INSERT INTO gvn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bula jinbalku wandin, townbuku Jerusalemku dungan baja, jawun-karrandaku. Bula jawun-karra 11-bala warrmba-bungan yindu-yinduynji jawun-karranji. ");
INSERT INTO gvn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jawun-karrangka yalaman, “Nyulu Maja juranmankuda yarkinmun. Nyulu Simon Peteranda nguwimal milbijin.” ");
INSERT INTO gvn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bula jawun-karranda kuku balkan wanjarrman Jesusanka, jana baraldarr dungan-dungan. Bula jananda balkan breadka, yinyaynka bula nyungun-bungan. ");
INSERT INTO gvn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yala-yala bula balkal-balkawan, nyuluku Maja nguwimal milbijin, jananji janan. Nyulu yalaman, “Kari yinyilmarika, jankaku bundarika.” ");
INSERT INTO gvn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yamba jana wubulku yinyilmarinda, balu jana dubu nyajil-nyajin. ");
INSERT INTO gvn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nyulu jananda yalaman, “Yurra wanyurrinku yinyilmalmal? Yurra wanyurrinku nganya warmbil? ");
INSERT INTO gvn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yurra ngayku mara, jina nyakada. Yurra binalda yanyu ngayukuda. Yurra ngayku bangkarr karrba. Yinyamundu yurra binalda ngayukuda. Dubu bangkarr, bajibay kari yala ngayu.” ");
INSERT INTO gvn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yinyamun nyulu jananda nyungu mara, jina milbin. ");
INSERT INTO gvn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jana wubulku wawurr-wawurrmarin, kungkurr-kadarin, yalaman, “Yuy, can't be!” Nyulu jananda babajin, “Yurra mayiji, nukanka?” ");
INSERT INTO gvn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jana nyungundu minya kuyu dajin nukanka. ");
INSERT INTO gvn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nyulu minya nukankuda janawunbu miyilba. ");
INSERT INTO gvn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yinyamun nyulu jananda yalaman, “Yurra nganya nyajinda wawu yarkinmun. Ngayu juranman baja. Mosesangka, jana prophet-prophetangka ngadiku kuku kabanba balkan ngaykunku. Godundumundu kukubu Psalmsmundu yalarrku ngaykunku balkan. Yinya kuku manubajamankuda.” ");
INSERT INTO gvn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yinyamun nyulu jananin mumbarabuku binal-bungan Godundumunku kukuku. Jana junkayku binalmanda. ");
INSERT INTO gvn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nyulu yalaman, “Ngayu bama Godundumun.