﻿USE sofia;
DROP TABLE IF EXISTS sofia.gvf_vpl;
CREATE TABLE gvf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gvf_vpl WRITE;
INSERT INTO gvf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kirisito sanamoi gilekume u maribe ongwa iru bilungwa. Debiti te Ebarakam milungwa yal su gawliman, Yesu milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebarakam wan Aisaka milemua. Aisaka wan Yakobo milemua. Yakobo wan Yuda milemua. Yuda kebin abin kobe milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda wan su Peres te Sara milemua. Yal su man Tema milemua. Peres wan Keseron milemua. Keseron wan Aram milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram wan Aminada milemua. Aminada wan Nason milemua. Nason wan Salamon milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamon ebinbi Ereka ingure wan Boas milemua. Boas ebinbi Urutu ingure wan Obete milemua. Obete wan Yesi milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi wan Debiti Isirel ibal yal singaba bil wen milemua. Debiti milere abal ta ingure wan Solomon kule yomua. Goma Solomon man Yuraya ebinbi milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon wan Iriaboam milemua. Iriaboam wan Abaisa milemua. Abaisa wan Esa milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa wan Yekosapa milemua. Yekosapa wan Yoram milemua. Yoram wan Asaya milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaya wan Yotam milemua. Yotam wan Ekas milemua. Ekas wan Kesekaya milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kesekaya wan Manasa milemua. Manasa wan Emos milemua. Emos wan Yosaya milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya wan Yekonaya milemua. Yekonaya kebin abin kobe para milemua. Yalin kobi milungwa kaun ire, kanin pai Yuda ibal tere, awli pi Bebilon gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ongure pare Yekonaya Bebilon gariba gul milungure, wan Sialtiel milemua. Sialtiel wan Serababel milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel wan Abaya milemua. Abaya wan Elayakim milemua. Elayakim wan Eso milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso wan Sedo milemua. Sedo wan Ekim milemua. Ekim wan Elaya milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaya wan Eliesa milemua. Eliesa wan Matan milemua. Matan wan Yakobo milemua. ");
INSERT INTO gvf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo wan Yosepe milemua. Yosepe ebinbi Maria milungure Maria Yesu kule nongure, ena malia ibal kobe kaan Kirisito ye tomua. ");
INSERT INTO gvf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ibal iru si aine mile ongwa ongwa Ebarakam milungure, sanamoi anan kole kole muru kawnan sui sui milungure Debiti u maribe ongwa. Debiti milungure, sanamoi anan kole kole muru kawnan milin sui sui milungure, kanin pai Yuda ibal tere awli pi Bebilon gariba gul ongwa kaun u bawa dungwa. Dungure sanamoi anan kole kole muru kawnan milin sui sui milungure, ena God konagi erungwa yal Kirisito kawn kule u maribe ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kirisito u maribe ongwa main iru paangwa. Yosepe, Yesu man Maria tobe kaya tomba ta i pikungwa. Pikungure God Kegemama Iban kal guman kwi dungwa eremia, Maria digan sungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Winimbi Yosepe main paangwa mere morin erimba iru pirungwa, “Abalini kal erungwa gay bil gulekinama dire, aal kule piserabinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iru nomanin si pirungwa ul kiibi iru kanungure, God Singaba angel ta u maribe pire iru di tongwa, “Yosepe, i Debiti ibalin milinga ena i Maria ikirala di pire pisere, yobilaan bile iyo. God Kegemama Iban konagi erungwa abalini gaan paamua. ");
INSERT INTO gvf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Abalini wan ta kule nenangwa kaan Yesu yenanwa. (Kaan Golin ka iru paangwa, aa ki di tongwa yal.) Yalini gawliman ibal gariba gariba i kal digan ere taalime erungwa kire di ere aa ki dinangwa kaan iru yenanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ena God Singaba ka dungwa mere, ka kebe yal ta kamin kaya wen dungure u maribe nama dire, kal i u maribe ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ka iru dungwa, “Gi yal ikungwa, inin digan sire wan kule nenangure, kaan Emanuel yenamua.” (Kaan Golin ka iru paangwa, God inin ibal bole milebinga.) ");
INSERT INTO gvf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ul kiibi kane Yosepe alere God Singaba angel ta ka dungwa mere, wiina erere kirara imba, ");
INSERT INTO gvf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","win ebin main paangwa mere ta milekungwa, wan Yesu kule yere win ebin main paangwa mere milungwa. Ena gaan i Yosepe kaan Yesu ye tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kerodi yal bil milungwa kaun, Betelekem ai Yudia gariba gul suna dungwa Yesu kule nongwa. Kaun tawle mile pare, nomanin paangwa yal singaba kobe, kobil kamin ai milungwa u Yerusalem ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","U bawa dire iru sirin bile tongwa, “Gaan ta Yuda ibal singaba bil milangwa, malia alde kule nome? Na yal kobe kobil kamin milebinga kulmama ta, yal bil iray u maribe ongwa kanere, ana dire deminin si terabinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yal bil Kerodi pirungure yalini te Yerusalem ibal para nigi de pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ka main kenin erungwa yal bil kobe, te nil si tongwa yal para Kerodi “U ku bilo,” dungure u ku bilungure sirin bile tongwa, “God konagi erungwa yal Kirisito gariba alde kule yename?” ");
INSERT INTO gvf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Di tongure maan di kole ere iru dungwa, “Betelekem ai Yudia gariba gul suna ire u maribe namua,” dire dungwa. “Ka kebe yal ta God ka dungwa mere dire iru bilungwa, ");
INSERT INTO gvf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betelekem ai Yudia gariba gul suna dungwa, Yudia ogu ai mege ta dimua, tamama. I ibalin kobe milungwa suna yal singaba ta u maribe pire, na ibalan kobe Isirel kenin wai ere tenamua.’” ");
INSERT INTO gvf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dungure pirere Kerodi kobil kamin ai yal kobe, “Ere wo,” di gala dire aal kule dire iru sirin bile tongwa, “Kulmama ta u maribe ongwa genawna ome?” ");
INSERT INTO gvf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Di maribe erungure pirere, Kerodi yalin kobe nusi Betelekem ai erere di tongwa, “Pi gaan kanana i nega di waa duyo. Kanangire na para ana di deminin si terabinga, i ure di maribe ere na to.” ");
INSERT INTO gvf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dungure pisere ere ongwa, kobil kamin mile kulmama ta kanungwa mere kwi kanungure, yalin kobe kulmama omilin mina kanere guman mine ongwa ongwa, gaan milungwa gul de paangwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kulmama kanungwa ena wai pire miriin paangwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pi ogu ala pire gaan, te man Maria bole kanungwa. Kanere yaa gobin bile mile ana di deminin si tongure pare, kul gal bona tenama dire gal yawlere, kobile moni gol te paula ta minanin wai sungwa, te wel ta tobe bil bilungwa, gaan tongwa. Terere ul kiibi kanungure God mile, ");
INSERT INTO gvf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","“Kerodi milungwal pikio,” di tongure goma ungwa kol ta pikire, kol ta kwi dungwa ere ogin ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ere ongure pare, Yosepe kiibi kanungwa angel u maribe pire, iru di tongwa, “Kerodi gaan i waa duure si gulama di pirungwa, Alo, gaan te man para i awli ire Isipi gariba gul si kaya ere po. Gariba ire mile paire sinaa dire kwi ukio. Gariba ire, ‘Pisere ere po,’ na di i terabinga, ena kaun ire, ena i po.” ");
INSERT INTO gvf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dungure Yosepe alere gaan te man bole, gilaa ire awli i pi Isipi gariba gul nala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pi bawa dire, pai milungwa milungwa Kerodi gulungure, sinaa dire kwi ungwa. Goma God Singaba iru di ka kebe yal tongwa, “Na Wanan Isipi gariba gul milungwa, ‘Ere wo,’ di gala diwa.” Malia ibalin kobe iru erungwa, ka kebe yal ka dungwa mere paamua. ");
INSERT INTO gvf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gariba baan ta nomanin paangwa yal singaba kobe Kerodi bawle tongwa, Kerodi pirere den gule milungwa. Milere Betelekem ai te gariba maala para, gomege para me erin sutakobe u bawa dikungwa, “Si gulo,” dire, yal kobe nusi erungwa. Gariba baan ta nomanin paangwa yal singaba kobe, kaun di maribe erungure pirungwa mere, Kerodi “Si gulo,” di yal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iru erungwa ka kebe yal Yeremaya dungwa mere malia paamua. Yalini ka dungwa iru, ");
INSERT INTO gvf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Arama ai ka ta dungwa ibal pirungwa, kay bil miire werai si paangwa ibal piremua. Eresel wan abin kobe para gulungwa, abalini kerebara kay miire ibal ure miriin pire gaul mile kay mi tomba, abalini pirekire kay mi milemua.” ");
INSERT INTO gvf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kerodi gulungure pare, Yosepe Isipi gariba gul mile kiibi kanungwa God Singaba angel u maribe pire iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Gaan i, si gulala di pirungwa ibal kaya gulungure, i alere sinaa dire gaan i, te man bole awli pi Isirel gariba gul po.” ");
INSERT INTO gvf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dungure Yosepe alere gaan te man bole awli pi Isirel gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yudia gariba gul yal bil Kerodi, yalini wan Akeleas pi nen ain ongwa. Yosepe pirere gariba iray pai milangwa kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kiibi ta kanungure, kile kaman ta di tongure pi Galili gariba gul pirere, ogu ai ta kaan Nasarete ki pai milungwa. Iru ere milungwa, ka kebe yal kobe goma ka dungwa mere malia u maribe ongwa. Ka dungwa iru, “Nasarete ai nen milemua, ibal iru dinamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ena kaun iray nil bile tongwa yal Yon u maribe pire, Yudia gariba simi yongwa gul ka main kere di tere, ka iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“God kenin ere ke milungwa kaun u maala umia, ena kal digan ere taalime eringa nomanin suna si kiruul so.” ");
INSERT INTO gvf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yon milungwa mere ka kebe yal Aisaya goma iru dungwa, “Gariba simi yongwa gul yal ta iru gala dimua. ‘God Singaba kol bala di tere unangwa, aa tekun ero.’” ");
INSERT INTO gvf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yon bolima kamel sigin gal ware sigi dire, bolima gain kin dire gomare te deboma niriin komina iru nongwa. ");
INSERT INTO gvf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalem ogu ai, te Yudia gariba gul ai ta ta para, te Yodan nuule kolia kolibe para, ibalin kobe Yon milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ibalin kobe kal digan ere taalime erungwa di maribe erungure, awli Yodan nuule ali pirere nil bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Parasi kobe te Sadusi kobe bole, yalin kobe taw binanbile nil bilama di pire ungwa, Yon kanere di tongwa, “I oniba gawlin milinga mere ibal digan milingi. I kal digan ere taalime eringa pirin paimia, God i sirala di erungwa ibal ena ‘Si po,’ di i tome? Si pekenanga kirara i sinangirawa. ");
INSERT INTO gvf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kal digan ere taalime eringa nomanin suna si kiruul singire, ibal kawo pirama dire i kal wai kwi ero. ");
INSERT INTO gvf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","I nomanin suna si kiruul sinanba, i iru dingi, ‘Na Ebarakam gawlima kobe milebingi na para wai milebingirawa.’ Dingire na di i terala piro. God kal guman kwi dungwa erama di pirangwa, kobile i, Ebarakam gawlima kobe u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Di aa tere eri main wirala di eremua. Eri milin ta kulekungwa ibal, para muru wiire enderin galamua. ");
INSERT INTO gvf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“I nomanin suna si kiruul sinangwa, ibal kobe kawo pirama dire nil bile I tobinba, yal ta eme na munan kol u milangwa yalini God Kegemama Iban nusi ere i tenangure, i nomanin sigi dinangwa te nomanin naabilama dire gaynin enderin denangwa mere, God gain giil pire i tenamua. Yalini yobilaan bil pai tongure, na yobilanan kuunin ta pai na tekemua. Na gal kine yalini teralba na yal digan mile kuunin paikimua. ");
INSERT INTO gvf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yalini dodal milin inama dire olanin pisere milin komina ogu ala yenamua. Yenamba, olanin enderin galangwa de painangwal painamua. Iru erungwa mere, yal ta iray unangwa, ibal kobe iru obin si erala eramua.” ");
INSERT INTO gvf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Di tongwa kaun i Yesu Galili gariba gul pisere, pi Yodan nuule pire nil bile tenama dire Yon milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Omba Yon mana taan dire dungwa “I nil bile na tenanga paamba, na tameran nil bile i terale?” ");
INSERT INTO gvf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dimba Yesu maan dungwa, “Para dinba, erala di pirebinga, erala erebinwa. God ‘Ero,’ dungwa mere iru kuunin erabinwa.” Dungure Yon “Para dinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ena nil bile Yesu tongure pare, nil ali milere mena ungwa. Ungure kamin aw dire ala di kole kole ongure God Iban, imil giran guman kulungwa mere si paale ire, Yesu milungwa gul ime ungwa. ");
INSERT INTO gvf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ungure kamin mina ibe ka ta iru ere ime ungwa, “Yalini na Wanan teran milinwa. Kanere na gun ye wai pire teiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ena Satan Yesu kiraan sire kela kule tenama dire, God Iban milere Yesu awli gariba simi yongwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pirere, Yesu are kaun yal su aan kawn muru girungwa taangwa para, komina ta nekire kenan gulungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kiraan sire kela kule tongwa yal Satan, Yesu milungwa gul urere iru dungwa, “I God Wan kawo milanga, kobile i, u komina birete nama dire i ka di kobile i to.” ");
INSERT INTO gvf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dungure Yesu maan iru dungwa, “Ka main minin ganin ali iru dungwa, ‘Ibal kobe komina kaan kaan nere milamba, milekun erekinamua. Erekinamba ibal God ka giran mina dungwa mere pirangwa milekun eramua.” ");
INSERT INTO gvf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dungure pare, Satan yalini awli Yerusalem pirere, Yuda ka main ogu bil biriin bolin mina pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ena Satan iru di yalini tongwa, “I God Wan kawo milanga, i ole si yaa main so. Iru diga ka main minin ganin iru dungwa, ‘I wai wen milana dire God di angel kobe tenangure, i kenin ere milamua. Angel yalin kobi i ai yebe dinangwa kobile ta kawnin ta bilekenanwa.’” ");
INSERT INTO gvf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu maan iru di tongwa, “Ka main minin ganin ka ta ama dimua, ‘I Singaba God sua i kanala dire di tekio.’” ");
INSERT INTO gvf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan Yesu kwi awli ire pi kamin kuul ta minin wen mina ongwa. Pirere Satan gariba bilin ta ta para, kalkan para muru wen i maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Satan mile pare, “I kawnin bege di gobin bile mile ana di deminin si na tenanga, na kalkan para wen i kaninga teralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu maan dungwa, “Satan i para ere po. Ka main minin ganin iru dungwa, ‘I God taran tawle ana dire deminin si tere te yalini ka dungwa wiina ero.’” ");
INSERT INTO gvf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iru dungure, Satan Yesu milungwa gul piserungure angel kobe urere Yesu ai yebe dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yon kanin pai milungwa Yesu ka pore iray pirere, pi Galili gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasarete ai yalini dulanin ta ikimba, yalini pi Kapanaum ogu ai pai milungwa. Ogu ai iray, Sebulan ibal, te Napalai ibal gariba suna dire te Galili nil benge binan dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yalini baan i ki pai milungwa, ka kebe yal Aisaya goma dungwa mere u maribe iru ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulan te Napalai ibal kobe, garabanin nil benge binan kole dungwa, te Yodan nuule kole ibe dimua. Galili gariba gul, Yuda milekungwa ibal kobe pai milemua. ");
INSERT INTO gvf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ibalin kobe si bilungwa gul milungwa, aw bil ta dinangwa kanamua. Ibal kobe ibal gulungwa milimba, are si ibalin kobe milungwa gul eramua.” ");
INSERT INTO gvf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ena kaun iray Yesu ka main nil si tere dungwa, “God kenin ere ke milangwa kaun kaya u maala omia, ena kal digan eringa pisere nomanin suna si kiruul so.” ");
INSERT INTO gvf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Galili nil benge binan pirere, kebin abin yal sui kanungwa. Yal ta kaan Saimon, kaan kiibi Pita, te yalini kebinbi Endiru bole nil kabe si sire erungwa yal milungwa, nil kabe sungwa gal pusi nil ali erere sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu yal sui kanere di tongwa, “I na munan kol duulin bilo. Bilanga konagi main nil si teralgire nil kabe singa mere, ibal iru di ku bilanwa.” ");
INSERT INTO gvf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dungure yal sui gin taran nil kabe sungwa gal pisere paale, yalini mun kol yalsui duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Baan ta ongure, Sebedi te yalini wan sui Yemis te Yon, sipe ala milere, nil kabe sungwa gal bali sungwa kwi si bilungure, Yesu yal sui kanungwa. Kanere “Nabina wo,” di gala dungure ");
INSERT INTO gvf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yal sui sipe milungwa gul pisere, te nen Sebedi milungwa para pisere, Yesu mun kol duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ena Yesu Galili gariba gul kola koli para wen warere, ibal kobe ka main ogu ala God ke mile kenin erungwa mere, kere di tere ibal kobe nibil ta ta para, aa te pilaan pai tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iru erungwa Siria gariba gul para yalini guun kan warungure, nibil main main erungwa para, te sia den miriin suna milungwa ibal, te du dungwa ibal, te aan kawn ki sungwa ibal para, awli Yesu milungwa gul ungure aa te pilaan pai tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galili ibal kobe, te Dekapolis ibal kobe, te Yerusalem ibal kobe, te Yudia ibal kobe, te Yodan nuule koli ibal kobe, ibalin kobe binanwenbile Yesu duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ena Yesu ibal taminin bil wen kanere, maa pi kuul ta pirere amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Milungure gawlima kobe u Yesu yobile i suna erungure, ena kawn kule ka nil si tere iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ibal kobe mile, ‘Na inan kuunin erekiwa,’ dire ibalin kobe miriin paimua. Paire God kenin ere ke milungwa gul pi suna milemua. ");
INSERT INTO gvf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ibal kobe kay miire miriin giil sire, ena ibalin kobe miriin paamua. Paangure God den miriin a ura di tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ibal kobe maan ta sikire kabin sire wai wen milere, miriin paamua. Paangure God gariba para muru tenangwa inamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ibal kobe God ka main konagi erala di pirungure maa yebe ongure, ibalin kobe miriin paamua. Paangure God kwi aine dinangure inangwa kuunin biinamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ibal kobe miriin wen pire ibal taw kobe terere, miriin paamua. Paangure God ibalin kobe miriin wen pire tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ibal kobe den miriin wai yere milere, miriin paamua. Paangure ibalin kobe God i maribe erangure kanamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ibal kobe den miriin suna yaa ime sire mone di milama dire konagi erere, miriin paamua. Paangure God mile ‘Wanane,’ di yalini tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ibal kobe God ka main konagi erungwa ibal taw kobe, gain giil pire tongure, miriin paamua. Paire God kenin ere ke milungwa gul pi suna milamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","I ibal kobe na mun kol duulin bile waringa, ibal taw kobe gain ka si i tere, te gain giil pire i tere, ka geray di i tere, iru ere i tongure ");
INSERT INTO gvf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","God kamin mina tobe bil ta eme tenamia, i wai wen pire miinin mayo. Gain giil pire i tongwa mere, goma ka kebe yal kobe pire tomua. ");
INSERT INTO gvf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ibal kobe suna milinga komina pirin erungwa mere, i ibal kobe iru milinwa. Pirin kal para wai dimba, daan kiikinangwa kwi u wai ta pekenamua. Ta pikire pusi mena erungure ibal egilamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ena are dere gariba gul para aw dungwa mere, i ibal kobe si bilungwa ai iru milinwa. Te ogu ai bil kamin kul mina ki paangwa, aal kule dikinangwa mere, i kalkan eringa para aal kule ta dekinamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Enderin derin gale i ogu ala pirere, bale bilkaw main ali ta yekire, bol bolimina yongwa ibal kobe ala milere kal para kanemua. ");
INSERT INTO gvf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Enderin derin dongwa mere i ibal kobe ama iru milere kal wai ero. Eranga ibal kobe kanere deminin si Kamin Abe tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Na ure Mose kile kaman ka, te ka kebe yal nil si tongwa manaa di terala digire, i iru nomanin si pirekio. Ka dungwa i, manaa di terala dire ukire, ka dungwa i milin u maribe nama dire wiwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ka ta dirala nomanin si suna yeyo. Mose kile kaman ka dungwa para muru imo di painangwal painangwa, ena minin ganin taran wen ta yaa ime ta sekenangwa. Kalkan para wen wei sinamia ka i para wei sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ena iru paamia. Yal ta kile kaman ka i minin ganin taran wen wiina erekire, te ama iru nil si ibal kobe tenangwa, ena yal ta i God gawlima kobe suna muna kol namua. Dibinba Mose kile kaman ka yal ta wiina erere, te ama iru nil si ibal kobe tenangwa, ena yal ta i God gawlima kobe suna u guman kol namua. ");
INSERT INTO gvf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yuda ka main ka nil si tongwa yal kobe, te Parasi kobe God ka dungwa wiina erungwa mere i iru eranga, tamama. I wiina wen ere tenanga ena God kenin ere ke milungwa ai suna nanwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Sanamoi si aine aine ka iru di tongwa, ‘Ibal si gulekio, te ibal ta si gulangwa ena ka kol ere tenamua,’ di kile kaman iru dungwa pirinwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pirinba na di i terala piro. Yal ta den miriin ki ye enin taw kobe ta tenangwa, awli pi ka kol ere tenamua. Te yal ta gain ka si enin taw kobe ta tenangwa, awli pi yal singaba milungwa gul pire, ka kol ere tenamua. Te yal ta mile, ‘I yal du milinwa,’ di enin taw kobe ta tenangwa, kol gaul ai enderin de paangwa gul nangwa kuunin eramua. ");
INSERT INTO gvf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ena i ibal kobe God ka main ogu bol mina kalkan terala di eridena, iru nomanin si piranga, ‘Aya, na enan ta den ki yere milebilgayawa.’ ");
INSERT INTO gvf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Direre kalkan tenanga ka main ogu bol main ye paale, enan ta bole ka di wiige sire po. Ka di wiige si piseranga i ure, kalkan God to. ");
INSERT INTO gvf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ena yal ta ka kol ere i tenangwa, awli pire ka kol pirungwa gul u bawa dikinangwa, ka wai di tere pena galo. Iru ta erekinangure kaya u bawa dinangwa, yalini i awli ka kol pirungwa yal tenangure, te yal ta i awli simil nen tenangure, te simil nen i kanin sinangure painanwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","I pirin paangwa tobe te i nanga nanga, tawle ta imo dungwa kirara te wei sinanga, kanin paangwa ogu i ere mena unanwa. Na kawen di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Si aine aine ka iru di tongwa, ‘Win ta pi abal ta kunibe nekio, te ebin ta pi yal ta kunibe nekio.’ ");
INSERT INTO gvf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Di i tomba na malia di terala i piro. Yal ta abal kane irala di miriin kabin paangwa, ena yalini kaya nomanin suna kunibe nere ebinbi piserungwa mere eremua. ");
INSERT INTO gvf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“I omilin wen kol kanina kal digan ere taalime eringa ena i omilin wole eranga mere, kal digan i pisero. I gain kal para wai imo dungwa enderin gaul ai nanga ta paikinamba, i gaynin kal ta u nangwa kal digan ere taalime erekinanga, ena wai painamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","I anin wen kol erina kal digan ere taalime eringa, ena anin de keli sire piseranga mere, i kal digan i pisero. I gain kal para wai imo dungwa enderin gaul ai nanga ta paikinamba, i gaynin kal ta u ongwa kal digan ere taalime erekinanga, ena wai painamua. ");
INSERT INTO gvf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Si aine aine para iru dungwa, ‘Yal ta abal de erangwa yalini piapa bile abalini tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dimba na di i terala i piro. Abal pi yal ta kunibe nekimba winbi abalini de erangwa, abalini kwi yal ta pire yal kunibe ingwa mere eramua. Te abalini inangwa yal i para abalini kunibe ingwa mere inamua. Winbi goma ingwa de erungwa kalkan i u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Sanamoi si aine aine ka pore iru di tongwa, ‘Iru eralwa,’ dingi ka susu dikio. God Singaba milungwa gul i maabinin mina aa taw sire kawo kirara niminin mile dingi, ena iru ero. ");
INSERT INTO gvf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dimba malia di terala i piro. I kawo kirara niminin mile dinanga, maabinin mina aa taw sikio. ");
INSERT INTO gvf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gariba gul God kawn egile gi dimia gariba gul kanere maabinin mina aa taw sinanga, pisero. Yerusalem yal bil wen ain dimia ai i kanere maabinin mina aa taw sinangi, pisero. ");
INSERT INTO gvf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gibiliigin kama sinam mo, tobe bilam mo, i yal kobe ta kanekinana, i gibilin mina aa tere maabin mina aa taw sikio. ");
INSERT INTO gvf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","I ka dinanga ena imore ‘Paimua,’ dire, te ‘Paikimua,’ dire iru tawle do. Ka ta para dinanba ka ta i kal ki erungwa yal dinangwa mere dinanwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Si aine aine ka iru di tongwa, ‘Yal ta i omilin ta sigi dinangwi i omilin ta maan sigi do. Te yal ta i sigin ta si pi dinangwi, i sigin ta maan si pi do.’ ");
INSERT INTO gvf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dimba na di i terala piro. Yal ta kal ki ere i tenangwa i maan ta sikio. Yal ta i pawnin wen kol sinangwa, ena i pawnin kora kol maa di to. ");
INSERT INTO gvf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te yal ta i awli ka kol ere tere, ‘Galsuna iralwa,’ dinangwa ena i gwi gal para yalini to. ");
INSERT INTO gvf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te simil nen ta mile, ‘Na bona gana baan ta imore kawi ire po,’ dinangwa ena baan ta i ama kawi ire po. ");
INSERT INTO gvf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yal ta, ‘Kalkan na to,’ dinangwa ena i wiina ere to. Te yal ta mile ‘Kalkan na tere eme maan teralwa,’ dinangwa ena i wiina ere to. ");
INSERT INTO gvf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Si aine aine ka iru di tongwa i piringi, ‘I ye nenga ibal kobe den miriin to. Te kayminin ibal kobe nigi de pire to.’ ");
INSERT INTO gvf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dimba, na malia di terala piro. I kayminin den miriin tere, te ibal kobe i gaynin giil pire i tongwa, ibalin kobe kaan gale pile dire ana di God to. ");
INSERT INTO gvf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Iru eranga Kamin Abe wan abilin wen milanwa. Are si ime erungwa ibal wai milungwa te digan milungwa para si tomua, te nimin sungwa ibal kobe kal wai erungwa te ibal kal ki erungwa para, gogo si tomua. God iru erungwa mere i kayminin ibal den miriin tenanga, ena yalini wan abilin i milanwa. ");
INSERT INTO gvf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","I ye nenga tawle den miriin tenanga, God i wai pire tenamo? Tamama. Aya, kobile moni takis ingwa yal kobe para iru erungwiwe. ");
INSERT INTO gvf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te i ye nenga tawle ‘Aya maya,’ dire kaalanga, wai painamo? Ta paikinamia. Aya, Yuda milekungwa ibal kobe para iru erungwiwe. ");
INSERT INTO gvf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","I Kamin Abe wai wen milungwa mere, i iru milanga paamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ibal kobe na kanama dire i ibal kobe ka main konagi erala di eringa, ibal iru nomanin si pirekio. Kalkan i, i maribe eranga i Kamin Abe wai pire i tekenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kal ta aa te nekungwa ibal kobe, i aa te wai ere tenanga, ibal kobe na kanama dire, erekio. Ka main ogu ala te kombil binan, miriin kaale tongwa ibal kobe iru erungure, ibal kobe kaan gale yebe eremua. Erimba, ibalin kobe tobe kaya imua. I nomanin si piro. ");
INSERT INTO gvf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ibalin kobe iru erimba kal aa te nekungwa ibal, i aa te wai ere tenanga, ena i ye nenga kanekinama dire aal kule ere to. ");
INSERT INTO gvf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aal kule ere tenanga, ena i Kamin Abe aal kule eringa para kanere, kal i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“I ana di God tenanga miriin kaalungwa yal kobe erungwa mere erekio. Yalin kobe ibal na kanama dire, ka main ogu ala te kol bine bane ale mile, ana konagi ere milemua. Ibal kobe yalin kobe kaan aa te yebe erama dire, iru erungwi. Yalin kobe tobe kaya imia, i nomanin si pire milo. ");
INSERT INTO gvf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yalin kobe iru erimba, i ana konagi erala di pire, i ogu ala pire kol yaale i Kamin Abe ibal ta kanekungwa, ana di yalini to. Tenangire i Kamin Abe aal kule paangwa para main kanere, tobe i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“I ibal kobe ana di God terala di pirere, Yuda milekungwa ibal baan araway imore ana dungwa mere dikio. Ibalin kobe iru pirungwa, ‘Baan araway di milabinga piramua,’ dimba iru ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ibal iru erungwa mere erekio. I ana kaya dikingire, i kalkan irala di piringa God kaya piremua. ");
INSERT INTO gvf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ana di God tenanga iru do. ‘Na Abe kamin mina milinga, i kaanin wi yebe namua. ");
INSERT INTO gvf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","I kenin ere ke milangwa kaun unama di pirebinwa. Kamin mina giranin wiina pay tongwa mere gariba gul iru erama di pirebinwa. ");
INSERT INTO gvf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kemina komina kuunin biinangwa mere na to. ");
INSERT INTO gvf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ibal kobe kal digan ere na tongure pirin paangwa gule ere tobinga mere, kal digan ere taalime erebingire pirin paangwa, i pirin gule ere na to. ");
INSERT INTO gvf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kunibe kura taalime terabina di erebinga, i na awli suna pekio. Kal ki erungwa yal na sirala di erungwa kuman kine na to.’” ");
INSERT INTO gvf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Dire Yesu ainere iru dungwa, “Ibal taw kobe kal digan ere taalime ere i tongwa pirin i gule ere tenanga, ena i kal digan ere taalime eringa, Nenin kamin mina milungwa pirin i gule ere i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Dimba ibal taw kobe kal digan ere taalime erungwa pirin i gule ere tekenanga, i kal digan ere taalime eringa i Nenin God pirin i gule ere i tekenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ena kaun ta i God nomanin si pire komina mawal ere milanga miriin kaalungwa yal kobe komina mawal ere guman yaangwa mere, i iru erekio. Ibal kobe na kanama dire, kenan gulungwa mere guman iru kule suna kobi wari omua. Ongure ibal kobe wai pire yalin kobe tongwa, ena tobe kaya imia nomanin si pire milo. ");
INSERT INTO gvf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","I komina mawal ere milanga ena gaynin bigin sire te gibilin balo. ");
INSERT INTO gvf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","I iru eranga i komina mawal eringa ibal ta kanekinamba Kamin Abe ibal ta kanekungwa kanamua. Kanere aal kule paangwa para main kanere tobe i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“I ibal kobe gariba gul bona gana dungwa gul i diibe diibe dinama dire erekio. Eranga gunagaan nere maimbol sire, te ibal ala pire kunibe inangwa paamia. ");
INSERT INTO gvf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","I pisera, ta iwe, i ibal kobe kamin gul bona gana dungwa gul daibe daibe do. Dinanga gunagaan ta nekire, te maimbol ta sikire, te ibal ala pire kunibe nekenangwa paamia. ");
INSERT INTO gvf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bona gana i nomanin si gumanin erin yenanga i ibanin nomanin para te minai eranwa. ");
INSERT INTO gvf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Enderin derin dere kol i maribe erungwa mere i omilin minai kol i maribe ere i tomua. I omilin kanere wai eranga i nomanin naabilamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dinamba i omilin kanere ki eranga i nomanin kama sinamua. Kal ta aw dire kol i maribe ere na toma di pirinba, kal i si bilangwa iwe, kirara si bilemua. ");
INSERT INTO gvf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nil erari yal ta, konagi ere yal singaba sutan ta tekenamua. Tenamba nigi de pire yal singaba ta tere, te wai pire yal singaba ta tenamua. Te bole pena gale yal singaba ta tere, te kane gogo ere yal singaba ta tenamua. God te bona gana kal sui para, nomanin tegi dinangwa ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Paikimia ka di i terala piro. Mile pairalga ta komina te nil nerale? Te gwi gulekiralga, ta gal sigi dirale? I iru piranga nomanin binanbile si pirekio. Ena iwe, komina nenangi wai painamba, mile painangwa wai wen painamua. Te gal sigi dinanga wai dinamba, gaynin wiige sire wai wen dinamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kauba mininmina warungwa kane nomanin si piro. Kauba komina ta yaale nekire, te bule ala ta ye nekinamba, Kamin Abe kauba kenin ere komina tomua. Kauba milungwa kenin erimba, ibal milungwa kenin wai wen ere i tomua. ");
INSERT INTO gvf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Garamil mile gulal mo, bia yere gulal mo? I iru nomanin binanbile si piranga bolima ogu ta ama milano? Tamama. Ena nomanin binanbile si pirekio. ");
INSERT INTO gvf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ta gal sigi dirale? Tameran i iru nomanin binanbile si pirine? Eri maare kuun sungwa main i nomanin si piro. Konagi ta erekire, gal para ta warekimua. ");
INSERT INTO gvf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kuun sungwa main iru paamia, ka ta di i terala piro. Yal singaba Solomon egin galungwa wai paamba, eri kuun sungwa mere iru wai wen paimua. ");
INSERT INTO gvf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God eri kuun sungwa kenin ere milemua. Milimba kuun sungwa iwe, kemina kuun wai si dinamba, erima are dere kuun ulu dinamua. God eri kuun sungwa kenin erungwa, i ibal kobe kenin ere milekenamo? Kenin ere milangiray. Pire gi tawlita dinga yal iwe, God galsuna para kau i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tenangwa i iru nomanin binanbile si pirekio. Komina alde dinangwa nerale? Nil alde dinangwa nerale? Gal alde dinangwa sigi dirale? ");
INSERT INTO gvf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kalkan kobi Yuda milekungwa ibal kobe morin morin irala di piremua. I kalkan kobi ta nekire para ta milekenana, i Kamin Abe iru piremua. ");
INSERT INTO gvf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","God giran wiina erere, te kenin ere ke milungwa mere i yal kobe nomanin tegi do. Dinanga kalin dungwa i, para i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","I ibal kobe mile, ‘Erima kal ta erabin mo, ta erabin mo,’ i nomanin binanbile si pirekio. Erima kalkan u bawa dinangwa nomanin si pirekio. Kamin kaun kaun taalime erungwa mere, para gain giil piremua. Gaynin giil taw ama piranga, pisero. ");
INSERT INTO gvf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“God birun bale manin bale i tekenama dire, i ama birun bale manin bale ibal kobe tekio. ");
INSERT INTO gvf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","I ibal kobe bale nusi tenanga mere God i iru bale nusi i tenamua. Te i ibal kobe ere tenanga mere God maan iru ere i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bili mege ta i enin kobe omilin ali dungwa, i kaninba bili bilkaw ta, i omilin ali dungwa i tameran inin kanekine? ");
INSERT INTO gvf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ka ta iru sirin bile enin kobe tenga, bili mege ta, i omilin ali pi dungwa i mena ere i teralo? Dinba bili bilkaw i omilin ali pi dungwa iwe. ");
INSERT INTO gvf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","I miriin kaale tongwa yal milingiwe. Bili bilkaw i inin omilin ali dungwa goma i mena ero. Eranga ena kanere, bili mege i enin kobe omilin ali dungwa i mena eranga painamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“God ka main di ibal awi milungwa mere tenanga sinaa dire i sinamua. God ka milin paangwa di ibal bolima milungwa mere tenanga, ka i yaa ime sinangure pirekun ta erekinamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kaan dinanga inana ena i kaan do. Te kal ta waa duunanga kanana, ena i waa duyo. Te kana giran mile si gule dinanga kol yawle i tenamia ena si gule do. ");
INSERT INTO gvf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaan dinangwa inamua, te waa duunangwa kanamua, te kana giran mile si gule dinangwa kol yawle tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ena i yalin kobe milinga gul suna iwe. I wanin ta, keba komina kaan dinangwa, kobile tenano? ");
INSERT INTO gvf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mo komina bilebale kaan dinangwa, degilime ta si tenano? Ta iru ta si tekenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","I yal kobe digan milinba i kalkan wai dungwa i wanin abilin kobe terala di piringiwe. Ere tenga mere God ere mine ere i tongwa iwe. Ibal kobe mile ana di God tenangure kalkan wai kaan di Kamin Abe tenangwa ena tenangirawa. ");
INSERT INTO gvf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ibal kobe kal wai ere na tenama di piringa mere i iru ere ibal kobe to. Ka diga main iwe, Mose kile kaman ka, te ka kebe yal ka nil si tongwa, ka diga main i, milin paimua. ");
INSERT INTO gvf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kana giran megemaaga dungwa gul, i yal kobe kol i po. Pekenanga kol ta enderin gaul ai ongwa kana giran i bilkaw dire, te kombil i duu dire, ibal miriki wen duulin bile omua. ");
INSERT INTO gvf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mile painangwal painangwa kol iwe. Kana giran megemaaga dire kol sirin bile paangure, ena ibal taran taran tawle kol i duulin bile omua. ");
INSERT INTO gvf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ka main ka kebe yal kasu kobaan, yalin kobe unangwa kane milo. Yalin kobe gain mina bolima siipe siipe mua kulungwa mere, milema di kaninba, nomanin suna ali awi ele paangwa mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yalin kobe kalkan erungwa mere kanere, yalin kobe main paangwa i kananwa. Eri kerewane milin wai painangure ulan mo, suul si ta kobabol kul painangure ule nenan mo, tamama. ");
INSERT INTO gvf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eri ta wai dungwa milin wai kulungure, te eri ta piril sungwa milin kulungwa ki eremua. ");
INSERT INTO gvf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Eri ta wai dungwa i, milin kulungwa ki erekungwa eri dimua. Te eri ta piril sungwa i, milin kulungwa ki erungwa eri dimua. ");
INSERT INTO gvf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ena eri para muru milin wai ta kulekenangwa wiire enderin galamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iru paangure ka main ka kebe yal kasu kobaan kalkan erungwa mere kanere, yalin kobe main paangwa i kananwa. ");
INSERT INTO gvf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘God Singabo, Singabo,’ iru di na tongwa yalin kobe para God kenin ere ke milungwa ai suna ta pekenamua. Pekenamba, na Kamin Abe ka dungwa wiina pai tenangwa, ibalin kobi tawle nangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","God ka kol pirangwa kaun u bawa dinangwa ibal binanbile iru di na tenangwa, ‘God Singabo, Singabo, i kaanin gale yebe erebinga, ka main kere di tere, sia ibal den miriin suna milungwa maa si mena erere, kal guman kwi dungwa i maribe erebingiwe.’ ");
INSERT INTO gvf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dinamba na iru di yalin kobe terabinga, ‘I gumanin na ta kanekibingiraya. I kal ki eringa yal kobe, ere baan ta pa.’ ");
INSERT INTO gvf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ena kile kaman ka di tobinga, i ibal taw kobe wiina pai tenangwa nomanin paangwa yal milamua. Milere, yal ta ogu dimin wai gul ogu kiingwa mere, yalini iru milamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nimin bilkaw sire nil sire gwi bilkaw maare ogu i si guru dirala di erimba, ogu i, ogu dimin wai mina kiingwa mama dimua. ");
INSERT INTO gvf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kile kaman ka di tobinga, ibal taw kobe wiina pai tekenangwa nomanin paikungwa yal iru milamua. Milere, yal ta ogu dimin digan mina ogu kiingwa mere, yalini iru milamua. ");
INSERT INTO gvf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nimin bilkaw sire nil sire gwi bilkaw maare ogu i si dal dungure, ogu kiingwa i yaa si sulu di dimua. Si sulu dungwa, aya, ibal kane buul kunemua.” ");
INSERT INTO gvf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu ka i di piserungure, nil si tongwa main i, ibal kobe pire buul kune milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yuda ka main nil si tongwa yal kobe nil si tongwa mere iray, Yesu iru ta dikungwa. Yalini inin yobilaan bilere nil si tomba, ka main nil si tongwa yalin kobi, si aine aine tawle dire nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu kamin kuul milere pisere kwi ere ime ungure ibal binanbile duulin bile ungwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ungure seki egilungwa yal ta yalini milungwa gul urere, yaa gobin bile mile iru di tongwa, “Yal Singabo, i na nimbona aa te wai ere na terala di piranga, ena i aa te wai ere na tenanga kuunin painamua.” ");
INSERT INTO gvf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dungure aan dire dire aa tere iru dungwa, “I aa te wai erabina di pirebina i u wai pi milanwa,” dungwa. Dungure gin taran gain wiige sire u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ongure Yesu iru di yalini tongwa, “Kal erebingi i ibal kobe di tekio. Di tekenanba pi Yuda ka main kenin erungwa yal, gaynin wiige sungwa i maribe eringire kanamua. I gaynin wiige singi ibal kanama dire kabe si gale to. Seki egilungwa yal u wai ongwa Mose ‘Kal ta to,’ dire, kile kaman ka dungwa mere wiina ero.” ");
INSERT INTO gvf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu ere Kapanaum ai ala ongure yal ta Orom simil nen kenin erungwa yal, Yesu milungwa gul urere kawan dire ");
INSERT INTO gvf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","di tongwa, “Yal Singabo, na nil konagi ibal ta, nibil dan erungwa ala pai milere giil bilkaw piremua.” ");
INSERT INTO gvf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dungure Yesu yalini di tongwa, “Na pire yalini ere wai ere teralwa.” ");
INSERT INTO gvf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dimba, simil nen kenin erungwa yal ka maan di tere iru dungwa, “Singabo, na yal digan milia, i na ogu unanga kuunin ta erekimua. I imore kaman tenanga na nil konagi ibal u wai namua. ");
INSERT INTO gvf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na ama para, yal singaba na kenin ere milungure, te na simil nen taw kenin ere miliga ena na yal ta ‘Ere po,’ di tega mere, yalini ere omua. Te na yal ta ‘Wo,’ di tega mere yalini umua. Te na nil konagi ibal, ‘I konagi ta paangwa i ero,’ di teya ena yalini eremua.” ");
INSERT INTO gvf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ka i dungwa Yesu pire buul kunere ka iru di duulin bile warungwa ibal tongwa, “Na kawo kirara di i yal kobe teya. Yalini Yuda ibal ta milekungwa, na Isirel ibal suna kobi pire gi ta iru dungwa ta kanekiwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Are ungwa koli te are yaa biingwa kol para, Yuda milekungwa ibal binanbile unangwa, God kenin ere ke milungwa ai Ebarakam te Aisaka te Yakobo para, amin dire komina nenamua. ");
INSERT INTO gvf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","I pire nomanin suna yeyo. Yalin kobe iru nenamba Yuda ibal kobe God kenin erungwa ai mile painamba, yalin kobe nusi mena wen si bilungwa gul i erangure, koliba kol i yalin kobi kay mun bile yaare miirere, sigin gibin nuunamua.” ");
INSERT INTO gvf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Te Yesu di simil nen kenin erungwa yal tongwa, “I ere ogin po. I pire gi dinga mere u maribe omua.” Te kaun wen iray nil konagi ibal u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ena Yesu Pita ogin ala pirere Pita wounbi nibil ere paire gain nega dungure kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kanere, abalini aan aa tere gain nega dungwa gwi sungure gin taran alere, komina ki yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ena kamin kaya gire kama sungure, ibal kobe binanbile sia den miriin suna milungwa awli Yesu milungwa gul ungwa. Ungure Yesu ka taranta di tere sia maa si mena erere, nibil erungwa para aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Goma God ka kebe yal Aisaya mile, “Yal ta iwe, na nibil erebinga te nimbona erebinga para, pilaan pai na tenamua,” dungure malia Yesu kalkan erungwa ka dungwa i, pi nima ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ena ibal binanwenbile u ku bilere, Yesu yobile suna erungure kanere, “Nil benge binan kole iray nabina wo,” dire Yesu di gawlima kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Di tomba, Yuda ka main ka nil si tongwa yal ta, Yesu milungwa gul ure iru di tongwa, “Nil si tongwa yalo, i baan baan nala dinanga gul i, na i duulin bile nabilgirawa.” ");
INSERT INTO gvf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dungure Yesu iru dungwa, “Awi ele paangwa ain dimin dungure, te kauba aan ye paangwa aan dimba, Na U Ibal Obinga Yal, baan ta pairabina ai ta dekemua.” ");
INSERT INTO gvf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ena gawlima kobe ta iru di Yesu tongwa, “Yal Singabo, na abe gurala dungwa goma maul si yerabina po, di na to.” ");
INSERT INTO gvf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dimba Yesu maan iru dungwa, “Pisero, gurala di milungwa ibal kobe, ibal taw gulangwa maul si yenamua. I na duulin bile wo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu sipe ala ongure yalini gawlima kobe bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pi ongure gwi bilkaw wen gin taran maare, nil si pebil dire nil yugu di ime pirere, sipe saalibe erungwa. Erimba Yesu ul pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yalin kobe Yesu ul pai milungwa gul pire ulin yuure iru di tongwa, “Singabo, na yal kobe gulabinga paamia, u wai nama di piringire i na aa ki do.” ");
INSERT INTO gvf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu maan dire dungwa, “Pire gi tawle dinga yal kobe, tameran kuril pire miline?” Dungure alere gwi koban sire, nil benge kiraan ka di tongure gwi si oli dire, nil sua si dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ibal para buul kune iru dungwa, “Nil te gwi yalini ka dungwa para wiina erungwa yal i, yal i takal erungwa yal mileme?” ");
INSERT INTO gvf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ena Gerasene ibal ki pai milungwa gul nil benge kole iray, Yesu u bawa dungure yal su yene yobilaan kobile giran ali milere u mena ongure, yalin sutakobe pi kol baan guman yongwa. Yal sutan i, sia den miriin suna milere naanin wen paingure, ibal kobe suna kobi wen ta warekimia. ");
INSERT INTO gvf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yal su gala dire iru dungwa, “God Wan iwe, na inan kanan paamia, i kanin ta paamo? Na gaynan giil pirabilga kaun i u maala ukumba, malia gain giil pire na tenano?” ");
INSERT INTO gvf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ena bolima binanbile baan ta maala komina ne milemia. ");
INSERT INTO gvf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Milungure yal su sia den miriin suna milungwa kanere, kawan dire iru di Yesu tongwa, “Na maa si mena eranga, i na nusi bolima den miriin suna ali ere na tenan mo?” ");
INSERT INTO gvf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dungure Yesu “Para ere po,” dungure sia i yal su piserere, kwi bolima den miriin ali ongwa. Ongure bolima muru daan ali wi ime pirere, nil benge sagu dire gulungwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gulemia ena bolima kenin erungwa yal kobe si ere ogin ain pire, sia maa si mena erungwa, te yal su kalkan ere tongwa ka pore di gawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Erungwa ena ogu malge ibal para, Yesu kanabina dire ongwa. Pire kanere kawan dire iru dungwa, “I na garibanan milinga ki eremia ena ere baan ta po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu pi sipe ala mile nil benge kole kwi pire, inin ogin ain ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ibal kobe aan kawn ki sungwa yal ta, borebil si yuungwa. Yuure Yesu aa te wai ere yalini tenama di pirungwa Yesu kanere, iru di aan kawn ki sungwa yal tongwa, “Na wanane, yobilaan bilo. I kal digan ere taalime eringa kire di eremua.” ");
INSERT INTO gvf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dungwa ena Yuda ibal ka main nil si tongwa yal kobe, iru nomanin suna ali si pirungwa, “Yal ta i kal nigi dongwa ere God gain ka si tomua.” ");
INSERT INTO gvf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Inin nomanin suna ali si pirungwa Yesu kanere, “I ibal kobe tameran kal gogo nomanin suna ali si pirine? ");
INSERT INTO gvf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Kal digan ere taalime eringa kire di eremua,’ diralga ka pilaan painamba, ‘Gawalin ire kol warana po,’ diralga u wai nam mo, pekenam mo, ibal i kanamua. ");
INSERT INTO gvf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na U Ibal Obinga Yal ibal kobe kal digan ere taalime erungwa kire di erabinga yobilaan na tongwa main pire bawa dinanwa.” Iru dire di aan kawn ki sungwa yal tongwa, “Ale, gawalin aa te ire i ere oginin po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dungure alere ere ogin ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kal iru erungwa, ibal taminin kuril di kane, God yobilaan ibal iru tongwa wai pire maki ye God tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ena Yesu baan i pisere ere pire, yal ta kaan Matyu kobile moni takis ingwa ogu amin di milungwa kanere, “Na munan kol duulin bile wo,” di tongure, Matyu alere mun kol duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ena kaun ta Yesu Matyu ogin ala komina ne milungure, kobile moni takis ingwa yal digan, te taalime erungwa yal kobe yal binanbile u bawa dire, Yesu te gawlima kobe para, komina nongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nongure Parasi kobe taw kanere iru di Yesu gawlima kobe tongwa, “Tameran ka nil si i tongwa yal kobile moni takis ingwa yal digan, te taalime erungwa yal bole para komina ne mileme?” ");
INSERT INTO gvf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dungwa i, Yesu pirere dungwa, “Ibal imore milungwa dokita milungwa gul pekenamba nibil erungwa ibal omua. ");
INSERT INTO gvf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Komina si gale na tenanga tamama. Aa te wai konagi ere ibal kobe tenanga wai pirabinwa. Ka main minin ganin bile dungwa i main pire bawa dinana po. Ibal maribe milungwa di ku bilala dire, gariba gul ukiwa. Ibal piril sungwa te nigi nagi dongwa di ku bilala dire, ime wiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ena kaun iray Yon gawlima kobe Yesu milungwa gul ure, iru sirin bile tongwa, “Na ibal kobe, te Parasi kobe komina mawal morin ere milebinba, tameran i gawlimanin kobe komina mawal ere milekeme?” ");
INSERT INTO gvf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Dungure Yesu iru di yalin kobe tongwa, “Yal ta abal inangwa kaun, yalini gawlima kobe guman yaare komina mawal ere milekungwa mere, na gawlimanan kobe ama iru ere milimba, kaun ta na awli nangure ena kaun iray, na gawlimanan kobe komina mawal ere milamua. ");
INSERT INTO gvf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ibal gal kwi bigin sekungwa iray, gal golin bali sungwa bolimina si bilekenamua. Si bilangwa, gal kwi ai i dire kunangure, gal golin iray kwi ama bali bilkaw sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te ibal wain nil kwi meme gain mugu golin ali garu dekenamua. Ali garu dinangwa miin ure u niminin mile, meme gain mugu si gala dinangure wain nil u mena pire, mugu para pawa dinamua. I iru pisere, wain nil kwi, meme gain mugu kwi dungwa ali garu dinangwa nil wain te mugu para mama dinamua.” ");
INSERT INTO gvf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ena Yesu ka dungwa i di te milungure, Yuda kenin erungwa yal ta ure, yaa gobin bile iru di tongwa, “Na abilan maliagira gulimba i ure gain mina aa taw sinanga, u kwi pire milamua.” ");
INSERT INTO gvf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dungure Yesu alere gawlima kobe bole yal ta ereko ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ongure, abal ta me erin anan kole kole muru kawnan milin sutan mayan gain mina pai waa di milungwal milungwa, Yesu mun kol pirere yalini gal ulin aa tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Abalini inin iru nomanin si pirungwa, “Yalini galsuna ulin tawle aa teralga, na suna pilaan paire milalwa.” ");
INSERT INTO gvf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iru pirungure Yesu kwi sinaa dire abal kanere iru dungwa, “Na abilane, yobilaan bilo. I pire gi dingi malia pilaan pai milinwa.” Dungwa kaun i, abalini u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ena Yesu Yuda kenin erungwa yal ogin ala pire, ibal pumugu sungwa kanere, ibal para kaane kay bil miiungwa para kanere, ");
INSERT INTO gvf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesu iru dungwa, “Ibal para ere mena po. Gimege gulekimia imore ul paimua.” Dungure pirere ibal ebi mi tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ibal waa kire di mena erere pare, Yesu gimege pai milungwa gul pire, aan aa tongure ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Milemia ka pore iray gariba ulin kole kole para ware biingwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ai iray pisere ere ongure, omilin gi dungwa yal su duulin bile pire, “Debiti gawline, i miriin pire na to,” dire gala bil di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ogu ala pire pare, omilin gi dungwa yal su Yesu milungwa gul ungure, iru sirin bile tongwa, “Na i yalsu omilin aa pilaa di i terabinga kuunin painama di pire dino?” Dungure yal sui mile, “Owa, i eranga painamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dungure omilin aa tere dungwa, “I pire gi dinga mere iru ere i teiwa.” ");
INSERT INTO gvf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dungure omilin pilaa dungwa Yesu kiraan aa tere iru dungwa, “Kal ere i tobinga, i bolin kule di maribe ere ibal tekio.” ");
INSERT INTO gvf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dimba yalsui pirere bolin kule ibal tongure, Yesu guun kan gariba gul i kole kole para ware biingwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ena omilin gi dungwa yalsui ere malge ongure, yal ta sia den miriin suna milungwa, ka minin paikire, ibal taw yalini awli Yesu milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu sia maa si mena erungure pare, yalini gin taran ka dungwa. Dungure ibal para pire buul kunere iru dungwa, “Ayo, kal iru erungwa i goma Isirel gariba gul ta kanekibingirawa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dimba Parasi kobe iru dungwa, “Sia bil wen Satan nomanin suna milere aa ki di tongure, sia maa si mena eremua.” ");
INSERT INTO gvf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ena Yesu ogu ai bil mege para wen warungwa. Warere Yuda ibal ka main ogu ala ka nil si tere, “God i kenin ere ke milamua,” dire ka pore wai i kere di tere, te ibal nibil te nimbona erungwa main main para, aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Terere Yesu ibal miriki wen milungwa kanere, miriin pire tongwa. Ibal kobe suna ali nomanin binanbile sire buul yaangwa, bolima siipe siipe yal ta kenin erekungwa mere, ibal kobe iru milungwa Yesu kanere, miriin pire tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Terere iru di gawlima kobe tongwa, “Komina milin binanbile bol yomba ibal bulangwa tawlita milemua. ");
INSERT INTO gvf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Milemia ena i iru ana di komina kobaan yal God to, ‘Ibal taw ama i konagi ere komina bulama di nusi komina gul ero.’” ");
INSERT INTO gvf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ena Yesu gawlima kobe anan kole kole muru kawnan milin sutan, “Wo,” di gala dire u ku bilere, sia ibal den miriin suna milungwa maa si mena erama dire, te nibil te nimbona erungwa main main para, aa te wai ere tenama dire yobilaan bile gawlima kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tongure Yesu nusi erungwa ongwa yal kobe Aposel, kaan iru paangwa. Ta goma Saimon kaan ta Pita, ta Pita kebin Endiru, te Sebedi wan su Yemis te yalini kebin Yon, ");
INSERT INTO gvf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ta Pilipi, ta Batolomiu, ta Tomas, ta kobile moni takis ingwa yal Matyu, ta Alpias wan Yemis, ta Tadias. ");
INSERT INTO gvf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ta yobilaan bilungwa yal kaan Saimon, ta Yesu bale taal sungwa yal kaan Yudas Isikerio, kaan iru paangwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ena yal anan kole kole muru kawnan milin sutan i Yesu nusi erere, kile kaman ka iru di tongwa, “Yuda ibal milekungwa gariba gul, te Sameria ibal ogu ai, pikio. ");
INSERT INTO gvf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pikinanba bolima siipe siipe baan ta ongure, kobaan kanekungwa mere Isirel ibal kobe iru milungwa, ena yalin kobe milungwa gul po. ");
INSERT INTO gvf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pire iru kere di to, ‘God kenin ere ke milangwa kaun u maala omua,’ da. ");
INSERT INTO gvf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nibil erungwa ibal kobe aa te wai ere to. Gulungwa ibal kobe u kwi nama dire ulin yuyo. Seki egilungwa ibal kobe gain wiige sinama dire, aa te wai ere to. Sia maa si mena ero. Na kalkan i yal kobe imore i tobinga mere konagi imore ere tenana po. ");
INSERT INTO gvf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kobile moni bil te mege para, gal gule ire warekio. ");
INSERT INTO gvf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Komina baan nenanga, te galsuna sutan te kawn tobilin te goliba kal i, para ire pikio. Ibal konagi erungwa kalkan i nenanga tenangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ena ogu ai bil mo mege pi bawa dingire, ena yal ta i bole ka diduwaire milanga waa duu kananga ena i mile payo. Ogu taw kebe yekio. ");
INSERT INTO gvf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pi ogu ala nanga, ‘Yalkuno, mile dinio,’ iru di to. ");
INSERT INTO gvf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ogu kobaan kobe i aa tekun ere i tenangwa ena, ‘Yalkuna,’ ka dinga i painamua. Painamba ogu kobaan kobe i aa tekun ere i tekinangwa ena ‘Yalkuna,’ ka dinga i paikinamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ena ogu kobaan ibal kobe, te ogu ai ta i aa tekun erekire, te ka dinanga pirekire, ibal iru erangwa ena ai i pisere guman yaa tere kal iru eringire, nomanin sire main piramua. ");
INSERT INTO gvf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kawen dirala nomanin si piro. God ibal para ka kol ere tenangwa kaun, Sodom te Gomora ibal digan wen mile gain giil piramba, i aa tekun ere tekungwa ibal kobe, gain giil bil wen piramua.” ");
INSERT INTO gvf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ena piro. I bolima siipe siipe milungwa mere i iru milinwa. Milinba na i awi ele paangwa suna nusi eriwa. Eriga oniba monaan dire warungwa mere, i iru waro. Te kauba ta omilin kabin gule amane yere mone di milungwa mere milo. ");
INSERT INTO gvf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","I yal kobe kanekun ere milo. Ibal kobe i awli ka kol pire i tere, Yuda ka main ogu ala kuba aa tere i sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","I yal kobe pire gi di na tenga ena yal bil, te yal singaba milungwa gul gure pala dire ka kol ere i tenamba, na ka main wo di yalin kobe te Yuda milekungwa ibal tenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ibal kobe ka kol pirama dire awli pi singaba tenangure, ‘Tawa dirale?’ di pire, i nomanin si gogo erekio. Kamin kaun i u bawa dinangure i dirala dinanga ka i God di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ena kaun i ka dinanga i inin ka imore giran mina dinanba, i Abe God, yalini Iban nusi i nomanin suna erangure, ka giranin wiina eranwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kebinbi si gulama dire abinbi bale taal sinamua. Nen para iru gawlin kobe ere tenamua. Nen man kobe si gulama dire, gawlin kobe den gule tere, bale taal sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","I pire gi di na tenga ibal para den gule i tenamua. Tenamba, i ka main aa gi di milangal milanga, ena God aa ki di i tenangure sigare kule u wai pi milanwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ogu ai ta giil pire i tenangwa ena si ere ai baan ta po. Isirel ogu ai para muru, ka main kere di piserekinangire, Na U Ibal Obinga Yal na kaya uralwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ka nil sungwa gaan kobe, ka nil si tongwa yal yaa ime ta sinangwa, tamama. Te nil konagi yal, singaba yal yaa ime ta sinangwa, tamama. ");
INSERT INTO gvf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iru paimia ena nil sungwa gaan kobe mile, nil si tongwa yal milungwa mere milala di pirangwa milamia, te nil konagi yal mile, na singaba yal milungwa mere milala di pirangwa milamia. Ena ibal kobe mile, ‘Sia yal bil kaan Bielsebul milinwa,’ iru di yal singaba ta tomia, ena gain ka bil si yalini gawliman kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Tenamba i kuril ta pirekio. Kalkan si alibe erungwa, eme aw di u maribe nangwa paamua. Te aal kule paangwa muru eme u maribe nangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ka dibinga i aal kule di i tega, i bolin kule di maribe eranwa. Te i ogu ala di i tega, malge pire gala di maribe eranwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yal ta i sirala dire unangure kuril pirekio. Yal ta iwe, i ibanin para ta si gulekinangwa paamua, gaynin taran si gulamua. Dibinba God iwe, i ibanin te gaynin para, enderin gaul ai si gulangwa paamia, ena yalini kuril pire to. ");
INSERT INTO gvf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kauba dauna sutan i gibilin sirala erungwa kobile baa, toea taranta tenba, Abe mile kauba dauna taran i milama di pirangwa i milamua, te gulama di pirangwa i gulamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Iru dungwa iwe, i gibiliniigin para wen God kere pire pol simua. ");
INSERT INTO gvf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Simia ena i kuril ta pirekio. God kauba kenin ere milimba, i kenin wai wen ere i te milemua. ");
INSERT INTO gvf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yal ta ibal milungwa mabin mina mile, ‘Na Yesu gawliman miliwa,’ dinangwa ena na Abe kamin mina milungwa yalini mabin mina yal ta i, kaan di maribe eralga paimua. ");
INSERT INTO gvf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yal ta ibal milungwa mabin mina mile, na ka di kile di mena ere na tenangwa, ena na Abe kamin mina milungwa yalini mabin mina yal ta i, ka di kile di mena ere yalini teralga paimua. ");
INSERT INTO gvf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Na uga main iwe, ibal kobe bole pena gale milama di iru nomanin si pirekio. Ibal kobe bole pena gala milama dire ukiwa. Ibal kobe guman inin inin dinama dire wiwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nen wan guman inin inin dinama dire te man abin guman inin inin dinama dire, kolin ain guman inin inin dinama dire wiwa. ");
INSERT INTO gvf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iru painamia ena yal ta kaymin wen ibal yalini gawliman suna milamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ibal kobe wai pire na tenangwa wai dinamba, ibalin kobe wai wen pire nen man tere, na pire gibilan mui kol yenangwa ena na gawlimanan kobe milangwa ta paikinamua. Ibal kobe wai pire na tenangwa wai dinamba, ibalin kobe wai wen pire wan abilin kobe tere, na pire gibilan mui kol yenangwa, ena na gawlimanan kobe milangwa ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ibal kobe na giil pire gulabinga mere yalini giil pire gulekire na duulin bilekenangwa, ena na gawlimanan kobe milangwa ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yal ta inin gain pire tere mile painangwal painangwa nomanin tegi dire aa gi di pirangwa, ena u main namua. Na inan miliga pire yal ta yaa ime si milangwa, ena yalini mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yal ta aa te wai ere i tenangwa mere, ena yalini para aa te wai ere na tenamua. Te yal ta aa te wai ere na tenangwa, ena yalini aa te wai ere yal ta na nusi erungwa yal i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","God ka kebe yal tobe inamua. Te yal ta mile, ‘Yalini God ka kebe yal milemua,’ di pire aa te wai ere tenangwa, ena ka kebe yal tobe inangwa mere yal ta i para iru inamua. Kabin sire wai wen milungwa yal tobe inamua, te yal ta mile, ‘Yalini kabin sire wai wen milemua,’ di pire aa te wai ere tenangwa, ena kabin sire wai wen milungwa yal tobe inangwa mere yal ta i para iru inamua. ");
INSERT INTO gvf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na kawen dirala piro. Yal ta mile, ‘Yalini Yesu gawlima kobe milemua,’ di pire nil kule Yesu gawliman u maribe pekungwa yal ta i tenangwa, ena tobe irala eremua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ena Yesu kile kaman di gawlima kobe anan kole kole muru kawnan milin sutan te pisere, ere ogu ai taw maala pire, ka main nil si tere kere di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ena God konagi erungwa yal Kirisito, konagi erungwa i, nil bile tongwa yal Yon, kanin pai milungwa pirere, gawlima kobe taw nusi Yesu milungwa gul ere, ka kebe ere i ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","I ongure pirere, u bawa dire iru di tongwa, “‘Yon yal ta unamua,’ dungwa iray, i kawen un mo, yal ta eme unangwa suul milabine?” ");
INSERT INTO gvf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Dungure Yesu maan iru di tongwa, “Omilin gi dungwa ibal pilaa dire kanungure, te kawn kebil sungwa u wai pire kol warungure, te seki egilungwa ibal gain wiige sungure, te kiraan gi dungwa ibal kwi pilaa dire ka pirungure, te gulungwa ibal alere u kwi pire mile paingure, te kal aa te nekungwa ibal na guunan kanan pirungure, kal iru erungwa main i kane pire, pi Yon di tenana po. ");
INSERT INTO gvf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yal ta na inan kanere nomanin su su sekenangwa ena miriin painamua.” ");
INSERT INTO gvf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ena Yon gawlima kobe ere ongure, Yon konagi erungwa mere Yesu iru di ibal taminin bil tongwa, “Yon gariba simi yongwa milungure i kanala di engiwe. Yal ena kanala di pirine? Yobilaan bilekungwa yal ta kanala di pirin mo, ");
INSERT INTO gvf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","yal ta gal suna wai wen sigi dungwa kanala di pirine? Tamama. Ibal kobe galsuna wai sigi dungwa singaba ogun ki pai milemua. ");
INSERT INTO gvf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ena ka ta sirin bile i teralga di na to. God ka kebe yal i kanala di eno? Owa, para dina, yalini ka kebe yal imore ta milekimia, Yon ka kebe yal bil wen milemua. ");
INSERT INTO gvf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ka main minin ganin bilungwa mere Yon di maribe erungwa iru bilungwa, ‘God iru di na tongwa, Na ka kebe yal ta nusi erabingire yalini goma ye tere, kol bala di i tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na kawen di terala i pire nomanin suna yeyo. Ibal u singaba omba, Yon u singaba bil wen omua. Omba yal digan ta, God kenin ere ke milungwa ai suna ongwa, Yon yaa ime simua. ");
INSERT INTO gvf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yon ka main kere di te milungwa kaun, ena ibal taw God kenin ere ke milungwa suna nala dire, nega dire yobilaan bilere u ala omua. Iru mile ongwa ongwa ena malia para iru ere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ka main ka kebe yal para, te Mose kile kaman ka kalin sui, God kenin ere ke milungwa kaun di maribe erungure, ena Yon u bawa dimua. ");
INSERT INTO gvf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ena ka dungwaray kirara kawo iru di piranga, ena Yon Ilaya milemua. Kamin kaya ka kebe yal mile, ‘Ilaya goma unamua,’ dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ibal kiranin gi dikimia kiranin gule piro. ");
INSERT INTO gvf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ibal kobe malia maalungwa ibal ena di bilabine? Komina aibe tobe erungwa ai, gamege taminin sutan mile, taminin ta iru gala di taminin ta tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Na abal kule nobinga te ime erebinga kaun iray tawa sibinba, i yal kobe egin erekinwa. Te ibal gulungwa kaun weray si paabinba, i yal kobe kay ta mi na tekinwa.’ Gamege sigil iru tere nomanin paikungwa ka dungwa mere, ibal malia maalungwa nomanin susu sire, ka di na Yon bole na tomua. ");
INSERT INTO gvf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yon urere komina mawal ere nil wain para nekungure ibal para kane, ‘Yal du milemua,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na U Ibal Obinga Yal ure, komina te nil nobingire ibal para kane iru dungwa, ‘Aya, yal ta i kano. Komina depil nere nil wain binanbile nere, kobile moni takis ingwa yal te yal digan para, ye nega milemua.’ Dimba God kule yongwa milemia kal wai eremia ena yalini kirara kawen dima di kanebinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ena Yesu kaun ta ogu ai taw kal guman kwi dungwa binanbile ere tomba, kal digan ere taalime erungwa nomanin suna si kiruul sikungwa. Sikimia, ena kura ka iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ayo, Korasin ibal te Besaida ibal, i ibalin kobe ereko gain giil piranwa. Kal guman kwi dungwa, i milinga gul ere i tobinga mere, Taya te Saidon gariba gul ere i terabinga iwe. Ena yalin kobe kaya nomanin suna si siruul sinamua. Sungwa ibal kanama dire weray si painamua. ");
INSERT INTO gvf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","God ibal para muru ka kol ere tenangwa kaun iwe. Ena Taya te Saidon, Yuda milekungwa ibal kobe ka kol ere tenamba, ka kol bil ere i tenangure gain giil bil piranwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapanaum ibal kobe ena iwe. I kamin ibal milia di pirinba, God i pusi enderin gaul ai eramua. Kal guman kwi dungwa, i milinga gul ere i tobinga mere Sodom ibal iru ere terabinga, ena Sodom ibal gariba God si gule wei sungwa malia imo milamua. ");
INSERT INTO gvf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","God ibal para muru ka kol ere tenangwa kaun iwe. Ena ka kol ere Sodom ibal kobe tenamba, ka kol bil ere i tenangure, gain giil bil piranwa.” ");
INSERT INTO gvf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ena kamin kaun i, Yesu dire iru dungwa, “Na Abe kamin te gariba para kobaan taran i milinwa. Ka main dungwa iray, nomanin paangwa ibal di maribe ere tekinba, gamege mere pire pol sekungwa ibal di maribe ere yalin kobi tenwa. Tenga i, na i maki ye teiwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iru eringa ena para paamiawa. Na Abe, i inin iru nomanin si piringa mere eringa paamiawa.” ");
INSERT INTO gvf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dire iru dungwa, “Na Abe konagi kalkan kobi para muru na tomua. Na Abe God Wan, na taran milia, yalini taran tawle na pire pol simua. Yalini Wan na iwe, na inan taran tawle, na Abe pire pol siwa. Sire na Abe guun kan di maribe ere ibal taw terala di pirebina, ena yalin kobe para wen pire pol sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ibal konagi nega dire kal obin dongwa kine i warungwa, na miliga gul ere wo. Unanga nomanin a pilaan pai ere i teralwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na pire gogo ere milekerala na kabin si miliga, ena na nil konagi yal i milere, te na ka nil si i tenama dinanga nomanin a pilaan pai milanwa. ");
INSERT INTO gvf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Konagi ere i terabinga nega dikinamua, te kalkan kine i teralga pilaan painamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ena Sare kaun ta Yesu dodal yaalungwa gul suna kol ware ongwa. Ongure, gawliman kobe kenan gulere milin taw ulere nongwa. Iru nongwa mere Yuda kile kaman ka main, “Para paimua,” dungwa paangwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iru nongure Parasi kobe kanere iru di Yesu tongwa, “Ena kano, Sare kaun kal ta manaa dibingare, i gawlimanin kobe tameran Sare kaun kwi ereme?” ");
INSERT INTO gvf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dimba Yesu iru di tongwa, “Debiti te ibalin kobe kenan gulere kal erungwi, i ka pore kere pirekeno? Piringirawe. ");
INSERT INTO gvf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yalini God ka main ogu bil ala pirere komina birete tongure God kanungwa, ‘No,’ dungure nomua. Nerere Yuda ibal kile kaman ka dungwa i sutaw eremua. Komina birete i ka main kenin erungwa yal kobe, inin nenangwa main iru paimua. ");
INSERT INTO gvf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te Sare kaun kaun ka main ogu bil ala kenin erungwa yal kobe, Sare kaun kile kaman ka pire i sutaw erimba, pirin ta paikimiawa. Ka dungwa i Mose kile kaman ka bilungwa kere pirekeno? Piringirawe. ");
INSERT INTO gvf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ena iru erungwa i main ta u pilau dire ka main ogu bil yaa ime simua. Simia ena na gawliman kobe para pirin ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Komina si gale na tenanga, tamama, aa te wai konagi ere ibal kobe tenanga wai pirabinwa. Ka main minin ganin dungwa, i main wen piranga ena, ‘Pirin ta paikungwa ibal kobe, pirin i tobinwa,’ di tekenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na U Ibal Obinga Yal Sare kaun na kobaan miliga paamua.” ");
INSERT INTO gvf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ena Yesu ai i pisere pi ka main ogu ta ala ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pirere milungure, yal ta aan kebil sungwa yal milungwa. Milungure ibal taw milere ka di mere si Yesu terala di pirere, iru sirin bile tongwa, “Yal ta nibil erungwa Sare kaun aa te wai ere tenangwa, na kile kaman ka i sutaw eram mo, erekiname?” ");
INSERT INTO gvf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu maan iru di tongwa, “I yal kobe bolima siipe siipe ta Sare kaun yaa maul ali nangwa, i aa te mena erekinan mo? Eranga paimua. ");
INSERT INTO gvf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bolima siipe siipe tobe bil paamba, ibal tobe bil wen paamua. Paamia ena Sare kaun aa te wai ere terabinga, na kile kaman ka i sutaw erekirabinga paamua.” ");
INSERT INTO gvf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dire iru di nibil erungwa yal tongwa, “Anin dire do.” Dire dungure, u wai pire aan kole wai dungwa mere kuunin iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Parasi kobe u malge pire Yesu si gulala dire iru di paalungwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Di paalungwa Yesu pirere baan iray pisere ere ongure, ibal binanbile duulin bile ongwa. Ibal para nibil erungwa Yesu aa te wai ere tere, ");
INSERT INTO gvf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kiraan aa tere di tongwa, “Na guunan kanan warekinama dire i ibal ka di tekio,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dimia ena ka kebe yal Aisaya goma dungwa pi nima ongure iru bilungwa, ");
INSERT INTO gvf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“God iru di tongwa, ‘Ena i kano. Na nil konagi yal iwe, na inan paale i suna ere iga unamua. Na denan miranan tere gun yere yalini teiwa. Na ibanan ere yalini teralgire, na ka kol eralga main di maribe ere ibal para tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ka bolebilin ta dikire, gala bil ta dikire, malge ka ta dikinamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bo gwige erungwa bile dire u mena pikimia, waira kule dungwa mere yalini ta sikire, aa yebe dinamua. Enderin derin gwaanangwa mere, yal ta iru milangwa ta sikire, aa ki di tenamua. Kalkan para muru aa tekun erama dire, dagi dire pai milamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pai milangwa ibal para muru yalini pi tegi yere mili namua.’” ");
INSERT INTO gvf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ena yal ta sia den miriin suna milungwa, omilin gi dire ka minin paikire, girabilin aw tongwa milungwa. Ibal taw yal i awli Yesu milungwa gul ungure, aa te wai erungure omilin pilaa dire ka minin paangwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ibal taminin kane buul kune iru dungwa, “Ayo, yalini Debiti Gawlin Kirisito milim mo?” ");
INSERT INTO gvf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dungure Parasi kobe pirere iru di tongwa, “Sia bil wen kaan Bielsebul, Yesu nomanin suna milere aa ki di tongure, sia maa si mena eremua.” ");
INSERT INTO gvf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yalin kobe iru nomanin si pirungwa Yesu pirere, ena iru di tongwa, “Dinba ka diralga iwe. Gariba baan ta yal kobe suna sibine dire, kura bilangwa u sutaw namua, te malge ta mo, nen abin kobe guman inin inin dinangwa u sutaw namua. ");
INSERT INTO gvf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan inin gain di keli sinangwa, eme eme ime naanin ta pai milekire, eme wei sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sia maa si mena erebinga, ‘Bielsebul aa ki di na tomua,’ iru dinba, i inin gawlimanin kobe sia maa si mena erungwa, ibal ena aa ki di tome? Iru erungwiwe. Ena i ka gogo dinwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Iru dinba God Iban aa ki di na tongure, sia maa si mena eriwa. Eriga God kenin ere ke milungwa mere, i milinga gul kaya u maribe pi i tomua. ");
INSERT INTO gvf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Yal ta pi yal naanin paangwa ogu kol di guru di erere, bona kunibe irala di nangwa ala pekenamba, goma naanin paangwa yal aan kawn kole si paale, ala pire bona kalkan inamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ena yal ta na bole yekirabilga, ena yal i kaymin paale na tomua. Te yal ta na bole di ku bilekenangwa, ena di sutaw erangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Erimba ibal kobe kal digan ere taalime erangwa, te gain ka sinangwa, para muru kire di erangwa paamua. Paamba ibal God Iban gain ka si tenangwa, kire di erekinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yal ta Na U Ibal Obinga Yal gain ka si na tenangwa, ena pirin paangwa i kire di erangwa paamua. Paamba yal ta gain ka si God Kegemama Iban tenangwa, kire di erekinangure pirin pai dinangwal dinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Eri ta dungwa i kananga, wai dim mo piril sim mo, ena milin kananga piranwa. Eri ta wai dungwa milin wai kulemua, te eri ta piril sungwa milin kulungwa ki erungwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Iru paamba oniba milungwa mere, i yal kobe kal ki eringa, ‘Nomanin kama sungwa ka wai dibinwa,’ dino? Ta paikima. Nomanin suna paangwa mere ka iru dinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yal dorimil milungwa ena nomanin suna ali wai pai dungure kal wai ere ka wai dinamua. Te yal digan milangwa ena nomanin suna ali ki ere dungure kal digan ere ka digan dinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","God ka kol ere ibal tenangwa kaun ibal para ka gogo dungwa di maribe ere tenamua. Ka gogo dinga iwe, painam mo paikinam mo, ka kol mina sinaa dinangwa eme inanga paamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","I milinga ka dingi iwe, i ka dinga mere God pirere, yalini pirin paim mo paikim mo, di maribe ere i tenamua.” ");
INSERT INTO gvf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ena Yuda ka main ka nil si tongwa yal kobe, te Parasi taw bole mile iru di tongwa, “Nil si tongwa yalo, na yal kobe i main pirabina dire, kamin mina kal guman kwi dungwa, ta i maribe ere na tenanga kanabinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dimba Yesu ka di bile dire iru di tongwa, “Ibal malia maalungwa kobaan pisere, u yal pire kal digan ere taalime erungwa milemua. Milere kamin mina kal guman kwi dungwa i maribe erangwa, ‘Kanabina,’ di pirimba, ta i maribe ere tekenamua. Tekenamba God ka kebe yal Yona milungwa kaun, kal guman kwi dungwa erungwa mere, ere i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona girungwa taangwa kamin kaun sutakobe pisi bil den ali pai milungwa mere, Na U Ibal Obinga Yal kamin kaun sutakobe ibal yobilaan gul maul si yenamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yona ka main kere di tongwa, ena Niniba ibal pirere kal digan ere taalime erungwa pisere, nomanin suna si kiruul si piremua. Pirimba malia iwe, Yona milungwa mere ungwa tamama. Yal bil wen umba, i yal kobe ta pirekinwa. Pirekinga God ibal para ka kol ere tenangwa kaun u bawa dinangure, Niniba ibal mile ‘Pirin paimua,’ iru di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Solomon nomanin paire ka main dungwa, ena Siiba gariba gul abal singaba bil, gariba gul pisere tayan wen pire Solomon ka dungwa pirala di omua. Omba malia iwe, Solomon milungwa mere ungwa taman, yal bil wen umba i yal kobe ta pirekinwa. Pirekinga, God ibal para ka kol ere tenangwa kaun u bawa dinangure, Siiba gariba gul abal singaba bil mile, ‘Pirin painamua,’ iru di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sia ta yal den miriin suna milungwa, pisere ere baan ta pire, gariba simi yongwa gul ogu ta painangwa ai waa duunamua. Ogu ta dikinangwa kanere ");
INSERT INTO gvf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","iru nomanin si pirangwa, ‘Ogu ta piseriga ogu iray kwi pi pairalwa,’ dire kwi ere nangure, ogu bine dire bigin sire aa tekun erungwa, ogu ala i iru erungwa pi kanamua. ");
INSERT INTO gvf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iru kanere pare, kwi ere pire, sia anan kole muru kole sutan awli milungwa gul urere, sia para yal den miriin suna pai milamua. Sia ta goma milangwa kal ki ere milamba, sia eme unangwa ki wen ere milangwa, ena yal iwe, goma yal i tawlita wai ere milimba, eme wai ta milekire, nigi wen de pire milamua. Iru erangwa mere, ibal malia maalere ki ere milungwa para, iru ere tenamua.” ");
INSERT INTO gvf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ena Yesu ka di ibal te milungwa, Yesu man te kebin kobe u bawa dire malge mile, “Yesu ka di terabina wo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dungure ibal taw ka iru di Yesu tongwa, “I piro, i manin te kebinbi mena mile, ka di i terala di milemua.” ");
INSERT INTO gvf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dungure Yesu iru di yalini tongwa, “Na mina te kebinanbi ibena di bilabine?” ");
INSERT INTO gvf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dire guman gel bilere iru dungwa, “Na gawlimanan kobe milemia kano. Yalin kobi na mina te kebinanbi mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Na Abe kamin mina milungwa, giraan wiina pai tongwa ibal kobe iwe, ena ibalin kobi na kebinanbi te alanbi te na mina mere milemua.” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ena kamin kaun iray Yesu ogu pisere ere pi nil benge binan amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ibal binanwenbile u ku bile Yesu yobile i suna erungure, sipe ta ala pire amin di milungure, ibal taminin makalua binan kole milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu ka di bile dire main ta ta para iru di tongwa, “Yal ta milin sigilala dire omua. ");
INSERT INTO gvf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sigile milungure, ena taw yaa kombil bolimina sungure kauba ure nomua. ");
INSERT INTO gvf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kobile bilkaw dungwa minai gariba wanin tawliga bolimina dungwa gul, milin taw yaa sire gariba binanbile ta dekungwa, gin taran maamua. ");
INSERT INTO gvf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Maamba are bil dongure, te dulaanin warekimia minin kengi sire gulemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Milin taw, kul galan yongwa suna ali yaa sirere bole para maangure, kul galan yongwa naan yobilungure gulemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Milin taw kobe, gariba wai dungwa gul yaa sirere, milin kule sulu dimua. Ena erin ta milin binanwenbile, wan kandret paingure, ta milin binanbile, siksti paingure, ta milin taran taran, teti paimua. ");
INSERT INTO gvf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ibal kiranin gi dikimia kiranin gule piro.” ");
INSERT INTO gvf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dungure pare gawlima kobe pi Yesu milungwa gul pire, iru di tongwa, “I ibal kobe ka di tenga, tameran ka di bile dine?” ");
INSERT INTO gvf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dungure Yesu maan iru di tongwa, “God kenin ere ke milungwa mere main aa kule paangwa di maribe ere i yal kobe tenangure kananba, ibal taw kobe di maribe ere tekenamua. ");
INSERT INTO gvf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yal ta kalkan binanbile kenin ere milungure taw ama tenangure irere, pora kal wen aa te nenamua, te yal ta kalkan tawle kenin erekungwa ta tekenangure, kal tawle dungwa yal ta tawal di inamua. ");
INSERT INTO gvf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ibal kobe imore kanimba, wai wen ta kanekire te kiraan pirimba, pire bawa dikimua. Ibal iru milemia ena ka di bile di tobinwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ibalin kobi iru milungwa, ena goma Aisaya ka iru dungwa pi nima ongwa. ‘I kiranin piranba, pire bawa dikinanwa. I imore kane milanba, wai wen ta kanekinanwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nomanin paikungwa milungwa, kiraan te omilin para gi di milemua. Iru erekinangwa, omilin kanere kiraan pirere nomanin painamba, yalin kobe nomanin si kiruul sire God nomanin tegi dinangwa, yalini yalin kobe pilaan pai tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Iru dimba, i yal kobe we, i omilin wai wen kanere kiranin pire bawa dinga, ena God kal wai ere i tomua. ");
INSERT INTO gvf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kawen di terala piro. I kalkan kanere te piringa mere God ka kebe yal te kabin sire wai wen milungwa yalin kobe para, kanala di pirimba, ta kanekimua. ");
INSERT INTO gvf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yal milin sigilungwa mere di bile diga main di terala piro. ");
INSERT INTO gvf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ibal kobe God ka main pirimba, nomanin suna pirekun erekungure ena kal ki erungwa kobaan urere, ka main milin nomanin suna sigilungwa i omua. Milin yaa kombil bolimina sungwa mere, ibal iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Milungure, ka main milin kobile bolimina sigilungwa mere, ibal iru mere milemua. Ka main pirere gin taran wai pire miriin paamba, ");
INSERT INTO gvf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","dulaanin ikire ka main baan tawleta aa gi di milemua. Ibalin kobe ka main aa gi di pirungwa ibal kura pai tere, te taalime u maribe pi tomia, ena ka main i, i mun kol eremua. ");
INSERT INTO gvf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Erungure, ka main milin kul galan yongwa ali sigilungwa mere, ibal iru mere milemua. Ka main pirimba, gariba kal i guman mina yerere, kobile moni te kulgal bona nomanin pirungwa maangure, ka main nomanin suna paangwa gule bile yaamua. ");
INSERT INTO gvf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yaangure, ka main milin gariba wai dungwa gul sigilungwa mere, ibal iru mere milemua. Ka main pirere nomanin suna pirekun eremua. Erere milin paire, ibal taw milin binanwenbile, wan kandret paingure, ibal taw binanbile, siksti paingure, ibal taw taran taran teti paimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kwi di bile dire iru dungwa, “Yal ta milin wai komina gul yaalungwa mere, God kenin ere ke milungwa iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Milin wai yaalimba, gilaa ta ibal para ul pai milungure, kaymin ibal ta ure sulsi milin taw, dodal komina gul suna si sulu di ere si omua. ");
INSERT INTO gvf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Iru yaalere dodal kwanin sungure pare, ena sulsi para maangwa kanemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Komina kobaan nil konagi yal urere, iru di komina kobaan tongwa, ‘Yalkuno, i milin wai yaalinba, sulsi binanbile tameran sime?’ ");
INSERT INTO gvf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dungure iru di tongwa, ‘Kayminan ibal ta ure iru ere na tomua.’ Dungure nil konagi yal iru sirin bile yalini tongwa, ‘Sulsi derabina nabina di dino?’ ");
INSERT INTO gvf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dungure yalini manaa dire iru dungwa, ‘Sulsi denanga dodal taw para denanwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dodal te sulsi bole maanangure, te awan denangwa kaun u maala nangure, iru di komina konagi erungwa ibal kobe terabinga, Goma sulsi dire kibil galo. Gale piseranga ena dodal di sire ule ogu ala yeyo,’ dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kwi di bile dire iru dungwa, “Eri koruul milin yal ta komina gul yaalungwa mere, God kenin ere ke milungwa iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Milin i megemaawenga paamba, milin kulungure bilkaw wen bere pi simua. Sire yaan bilkaw warungwa, kauba ure aan yomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kwi di bile dire iru dungwa, “Komina birete u bil ongwa kal kaan yis iwe. Yis erungwa mere, God kenin ere ke milungwa iru mere milemua. Abal ta yis irere, komina palua bole nuure, komina birete para muru u bil omua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ka di u ku bilungwa ibal tongwa i, di bile dire morin dungwa, te di bawa ta dikire di ibal tongwa di bile dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yesu iru di tongwa, “Ka kebe yal goma dungwa mere pire nima ongwa. ‘Ka di ibal teralga di bile diralwa. Goma gariba ere yongwa kaun, kalkan aal kule imo di paingwal paingwa, malia di maribe eralwa.’” ");
INSERT INTO gvf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ena ibal binanbile u ku bilungwa, pisere ere ogu ala ongwa. Ongure, yalini gawlima kobe ure, iru di yalini tongwa, “Sulsi di bile dinga mere main di maribe ere na to.” ");
INSERT INTO gvf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dungure iru di tongwa, “Yal ta milin wai yaalungwa iwe, Na U Ibal Obinga Yal, na yal iray milebinwa. ");
INSERT INTO gvf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Komina yaalungwa gul iwe, gariba ibal para muru milemua. Milin wai iwe, God kule yongwa kobe milemua. Te sulsi we, kal ki erungwa kobaan, ibalin kobe milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Te kaymin ibal sulsi si sulu di erungwa iwe, yalini Satan inin milemua. Awan dongwa kaun iwe, gariba gul wei sinangwa kaun dimua. Te komina konagi erungwa ibal milungwa we, ena angel kobe milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sulsi kibil galungwa mere, gariba wei sinangwa kaun para iru eramua. ");
INSERT INTO gvf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na U Ibal Obinga Yal, angel kobe nusi erabingire, kiraan sire kela kule tongwa ibal, te kal ki erungwa ibal para, nusi mena erere ");
INSERT INTO gvf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","enderin bilkaw dongwa, ai suna erangure, ibalin kobe kay mun bile yaare miire sigin gibin nuunamua. ");
INSERT INTO gvf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kabin sire wai wen milungwa ibal kobe milere, God kenin erungwa ain suna are aw dungwa mere, aw dinamua. Ibal kiranin gi dikimia kiranin gule piro.” ");
INSERT INTO gvf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Dire iru dungwa, “Bona gana wai ta, komina konagi gul aal kule yongwa mere, God kenin ere ke milungwa main iru mere milemua. Bona gana i, yal ta yawle kanere kwi a kube si ain eremua. Kanungwa wai wen pire miinin maare, aa te nongwa kal para muru ibal aibe tobe erere, moni ire kwi pi komina konagi gul gibilin sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Te ta ama iru. Yal ta kobile moni aa tere, kauba siine wai wen waa duure gibilin sirala di pirungwa mere, God kenin ere ke milungwa main iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta i wai wen dungwa kanere, aa te nongwa kal para muru aibe tobe erere, kobile moni irere gibilin sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Te ta ama iru. Ibal kobe nil kabe sungwa gal pusi pirin nil main ali erere, nil kabe main main sungwa mere God kenin ere ke milungwa main iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nil kabe sungwa gal muulungure, gure pala di makalua gul binan kole erere, amin dire nil kabe obin sire, nil kabe wai, gal ali gulere, te nil kabe digan pusi daan eremua. ");
INSERT INTO gvf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iru erungwa mere, gariba gul wei sinangwa kaun ama iru eramua. Angel kobe urere piril sungwa ibal kobe, ibal wai milungwa gul suna milungwa, ena ibal piril sungwa gana di kole eramua. ");
INSERT INTO gvf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Erere enderin bilkaw dongwa ai suna erangure, ibalin kobe kay mun bile yaare miire sigin gibin nuunamua.” ");
INSERT INTO gvf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dire Yesu iru sirin bile tongwa, “Ka dibinga i main pire pol sino?” Dire ibal, “Pirebinwa,” dungure ");
INSERT INTO gvf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","iru dungwa, “Pirebinwa dinga, ena Yuda ka main nil si tongwa yal, God kenin ere ke milungwa main nil sinangwa, yalini iru mere milamua. Ogu kobaan goma te malia, kalkan wai ala yongwa, i malge ere nenangwa mere iru mere milamua.” ");
INSERT INTO gvf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ena Yesu di bile dungwa i di pisere, baan i para pisere ");
INSERT INTO gvf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ere ogin malge pire Yuda ka main ogu ala ka nil si tongure, ibal pire buul kunere iru dungwa, “Nomanin si pirekun ere dungwa tamintan nomanin si pire dime? Te kal guman kwi dungwa erungwa yawe? ");
INSERT INTO gvf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ogu miremil kiingwa yal wan tawle milin mo? Milemua. Maria wan milere, Yemis te Yose te Saimon te Yudas abinbi ta milekemo? Milemua. ");
INSERT INTO gvf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yalini alenbi bole para milekemo? Milemua. Iru milungwa ena yalini ka dungwa mere main paangwa alde pire pol sire ure dime?” ");
INSERT INTO gvf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iru dire mun kal waa Yesu tongwa. Tongure Yesu iru di tongwa, “Ka kebe yal ibal kobe pire yebe ere tomba, inin garibanin ibal, te nen man kobe pire yebe ere tekungwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ibalin kobe Yesu guun kan pire gi di tekungwa, Yesu kal guman kwi dungwa, taran taran tawle erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ena Yesu guun kan ware biingwa, kenin erungwa yal bil kaan Kerodi pirere, ");
INSERT INTO gvf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","iru di yalini konagi ere tongwa yal kobe tongwa, “Nil bile tongwa yal Yon, gulere ale u kwi omua. Omia ena yobilaan bilere kal guman kwi dungwa eremua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ka iru dungwa main iwe. Kama kaya Yon kanin kulala dire, Kerodi ibal nusi erere, pi kanin si yuungure, kanin paangwa. Kanin kulere kanin paangwa main iwe. Kerodi kebinbi Pilipi, ena yalini ebinbi kaan Kerodias, “Yon kanin pai to,” dungwa ena kanin pai tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yon morin morin iru di Kerodi tongwa, “Abal ta i inga, ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Dimia, ena Kerodi Yon si gulala di pirimba, Yuda ibal mile, “Yon ka kebe yal milemua,” dungwa Kerodi kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kerodi kule nongwa kaun pire ibal kobe u ku bilungure, Kerodias abilin suna ali urere, egin gale erungwa. Erungure Kerodi kane wai wen pire tere, ");
INSERT INTO gvf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","maabin mina aa taw sire, “I kal ta irala dinanga kal i, i teralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Man nusi tere, “Iru do,” dungure, ure iru dungwa, “Nil bile tongwa yal Yon, gibilin gole pele bala bolimina ye na to.” ");
INSERT INTO gvf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dungure kenin erungwa yal bil miriin wen pirimba, mabin mina di tere, te ibayaal milungwa, gi, “Kal iray na to,” dungwa painama di piria, “Ena to,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Simil nen ta, Yon naan de keli sinama dire nusi kanin paangwa ogu erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ongure, naan de keli sire gibilin gole pele bala ye yuure gi tongure, gi yuure manbi tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tongure Yon gawlima kobe urere, Yon pi yene yobilaan gul maul sungwa. Maul sirere kal iru erungwa, i pi Yesu di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Di tongwa Yesu pirere baan ta iray pisere, sipe ala pire gariba simi yongwa gul pire, yalin kobe inin milama dire ongwa. Yesu ere ongwa ibal kobe pirere, ogin pisere pi main kol duulin bile ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu sipe pisere pi gariba gul ongwa kaun, ibal kobe miriki wen milungwa kanere, miriin giil pire tongwa. Tere nibil erungwa ibal aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kamin girungwa i, gawlima kobe ure iru di Yesu tongwa, “Abila pene yongwa dungure kamin giremua. Ibal kobe komina gibilin si nenama dire, ogu ai kobe nusi ero.” ");
INSERT INTO gvf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dungure Yesu dungwa, “Tameran ibalin kobe ere name? Komina nenangwa i, i inin to.” ");
INSERT INTO gvf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dungure gawlima kobe mile, “Komina birete anan kole muru te nil kabe sutan tawle dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dungure Yesu mile, “Komina iray i wo,” di gawlima kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ibal kobe kul ta paangwa gul amin di milama dire di tere, birete anan kole muru te nil kabe sutan aa tere, kamin mina ibe kane yebe ere God maki ye tere, komina birete bege di gawlima kobe tongure, gawlima kobe obin si ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ibal para muru nere kubin maangwa. Komina imo dungwa gal gulungure, gal anan kole kole muru kawnan milin sutan muulungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yalgo komina nongwa binanwenbile, paib tausen milimba, abal te gaan ta kerekungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gawlima kobe nil benge kole ide, goma sipe ala nama dire Yesu nusi erungure ongwa. Ongure ibal miriki wen Yesu, “U sutaw po,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Di tere pare, ana di God tenama dire kamin kuul inin maangwa. Kamin kaya girungure yalini inin milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Milungwa kaun i, sipe nil benge suna ali ongure, gwi bilkaw u sipe guman sungure nil yugu di ime pire, sipe si alibe erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mine main kamin taangure, Yesu nil bolimina kol wari ungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nil bolimina wari ungwa gawlima kobe kalgane irere, kuril pire iru gala dungwa, “Sia ta umua.” ");
INSERT INTO gvf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dungure Yesu mile, “Yobilaan bile milo, na inan miliga kuril ta pirekio,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dungure Pita iru di tongwa, “Singabo, i inin milina di kawo piriga, i kawen milinga ena i milinga gul nil bolimina wari urala di na to.” ");
INSERT INTO gvf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dungure Yesu “Wo,” dungwa Pita sipe mena pirere, Yesu milungwa gul nil minimina nala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Omba gwi bilkaw maangwa kanere kuril pirere, sagu dala di erungwa. Erere, “Singabo, na aa ki dire a pile di na to,” di gala dungure ");
INSERT INTO gvf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu gin taran aan aa tere, aa ki dire iru di tongwa, “I pire gi tawliga dingirawa, tameran i nomanin susu si pirine?” ");
INSERT INTO gvf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dungure yal su sipe ala pi milungure, gwi gurala eremia. ");
INSERT INTO gvf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yal kobe sipe ala milere deminin si Yesu tere iru dungwa, “I God Wan kawen milinwa.” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nil benge kole ide sipe mina pirere, gariba kaan Genesarete u bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dungure Yesu milungwa guman kanere pirungwa. Pirere nibil erungwa awli unama dire, ibal nusi gariba iray kole kole erungure, nibil erungwa awli Yesu milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ibal ana dire iru dungwa, “I gal binan tawle aa terabina, ‘Para paimua,’ da.” Ena ibal kobe aa tongwa nibil erungwa piraan dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ena Parasi kobe taw te Yuda ka main nil si tongwa yal kobe, Yerusalem ai pisere Yesu milungwa gul ure, iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“I gawliman kobe aan bigin sikire, komina nongwiwe. Sanamoi main paangwa mere tameran duulin bile erekime?” ");
INSERT INTO gvf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dungure Yesu maan iru dungwa, “I yal kobe God kile kaman ka wiina erekire, te i sanamoi main paangwa mere aa gi di waringa, tameran iru ere miline? ");
INSERT INTO gvf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God mile, ‘I nenin manin aa tekun ere to, te yal ta nen man kaalibain di tongwa, yalini si gulo,’ iru dimua. ");
INSERT INTO gvf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dimba i iru dingi, ‘Yal ta mile i bona gana terabinba, kaya God tobina, iru di nen man tenangwa ena yal ta i, nen man aa tekun ere tekenangwa paamua,’ dingiwe. ");
INSERT INTO gvf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","I iru dire i inin sanamoi main paangwa aa gi di warabina dire, God ka dungwa i sutaw erinwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","I yal kobe ere miriin kaale tongwa yal milinga mere, Aisaya goma, ‘Ka iru dire u maribe namua,’ dire iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘God iru dungwa, Ibal kobe giran mina na di yebe erimba, pire nomanin suna yekimua. ");
INSERT INTO gvf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","God ka main paangwa mere ka iru dimua. Dimba ibalin kobe inin gain mina paangwa ka main iru nil si tongwa, ena ana dire deminin si na tongwa ta paikimua.’” Dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ena Yesu mile, “Na miliga gul u ku bilo,” di gala dungure u ku bilungure, iru di tongwa, “Na ka dirala pire nomanin suna yeyo. ");
INSERT INTO gvf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yal ta komina main main nongwa, nomanin gule daalin sikinamba, yal ta ka dungwa mere nomanin gule daalin sungwa paimua.” ");
INSERT INTO gvf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dungure gawlima kobe ure iru di tongwa, “Maliagira i ka dingi, Parasi kobe nigi de pire milungwa, i pirino?” ");
INSERT INTO gvf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dungure maan iru di tongwa, “Eri para muru na Kamin Abe yaalekungwa, ena dire eramua. ");
INSERT INTO gvf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I kalin ta dekema, pisera. Yalin kobe goma nangwa ibal milimba, omilin gi dungwa mere milemua. Omilin gi dungwa yal sutan aan aa tere awli nangwa, ena yal sutan ereko maul ali sagu dinamua.” ");
INSERT INTO gvf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dungure Pita iru dungwa, “I ka di bile dinga main paangwa mere, di maribe ere na to.” ");
INSERT INTO gvf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dungure Yesu mile, “Ayo, ibal nomanin paikungwa mere, i para iru milino? ");
INSERT INTO gvf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yal ta komina main main nongwa den kol u mena ongwa, ta kanekino? ");
INSERT INTO gvf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Iru omba, yal ta ka dire erungwa mere, nomanin gule daalin sungwa paimua. ");
INSERT INTO gvf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ibal nomanin suna kal iru paire u maribe omua. Nomanin digan si pire, ibal si gulere, gi abal kunibe ire, kalkan kunibe nere, kakiibi dire, digwane waare, te gain ka sire, ");
INSERT INTO gvf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","kal digan main main i nomanin gule daalin si tomua. Tomba aan bigin sikire komina nongwa, nomanin gule daalin sikinangwa paamua,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ena Yesu gariba iray pisere pi Taya te Saidon gariba gul milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Milungure, Kenan gariba i, abal ta baan iray ki pai milungwa, Yesu milungwa gul ure iru gala di tongwa, “Singabo, Debiti Gawlin Kirisito milinga, i miriin pire na to. Na abilan sia den miriin suna wen milemua.” ");
INSERT INTO gvf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dimba Yesu ka ta di tekire, pire unin si milungwa. Milungure gawlima kobe ure kawan dire iru dungwa, “Abalini na yal kobe duulin bile ware ka yuul di milungwa, i nusi baan ta ero.” ");
INSERT INTO gvf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dungure Yesu maan iru dungwa, “Bolima siipe siipe baan ta ongure kobaan kanekungwa mere, Isirel ibal kobe iru milungwa iray, God ibal iru tawle na nusi eremua.” ");
INSERT INTO gvf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iru dungwa i, abalini ure Yesu kawn mina yaa gobin bile mile iru dungwa, “Singabo, i aa ki di na to.” ");
INSERT INTO gvf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dungure Yesu iru di bile dungwa, “Gaan kobe komina awi tongwa ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dungure abalini iru dungwa, “Singabo, i kawen dinba, awi kobaan komina nongwa sire manin yaa bol main ale sungure, awi ure nomua. Nongwa mere i aa ki di na tenanba?” ");
INSERT INTO gvf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dimia ena Yesu maan iru di tongwa, “Abalkuno, i pire gi wen di milinwa. Na i kal ta ere tenama di piringire iru wen ere i terabinwa.” Iru dungwa kaun i, abalini abilin u pilaan pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ena Yesu baan i pisere, nil benge ta kaan Galili binan kole ongwa. Pire kamin kuul maa yebe pire, pi kuul bawa dire amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ibal binanwenbile Yesu milungwa gul ure, aan kawn ki sungwa, te omilin gi dungwa, te aan kawn kebil sungwa, te ka minin paikire girabilin aw tongwa, te ibal nibil erungwa taw para iru, awli ure Yesu kawn mina taminin sungure, Yesu aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Girabilin aw tongwa ka minin ungure, te aan kawn kebil sungwa u wai ongure, te kawn ki sungwa kol warungure, te omilin gi dungwa pilaa dire kanungure, iru ere milungwa ibal kobe buul kune kanere iru dungwa, “Na Isirel ibal kobe God gawliman kobe milebinga pire deminin si i tobinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu “Ere wo,” di gala di gawlima kobe tere iru di tongwa, “U ku bilungwa ibal are kaun sutokobe na bole milere, komina nenangwa ta dekungwa miriin pire teiwa. Ibal kobe kenan gulungwa nusi ogin eralga, kol baan ta omilin maalama di pire, nusi erala pirekiwa.” ");
INSERT INTO gvf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dungure gawlima kobe iru di yalini tongwa, “Abila ai pene yomia komina birete nere kuunin biinangwa, alde i terabine?” ");
INSERT INTO gvf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dungure iru sirin bile tongwa, “I komina birete tamintan dime?” Dungure waa dire iru dungwa, “Anan kole muru kole sutan dimua, te nil kabe taw para dimua.” ");
INSERT INTO gvf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dimia ena Yesu mile, “Amin do,” dire di u ku bilungwa ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Terere komina birete anan kole muru kole sutan, te nil kabe taw aa terere maki ye God tere, bege dire gawliman tongure, yalin kobi obin si ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ibal kobe nongure kubin maangure, komina bege dungwa taw imo dungure, gal anan kole muru kole sutan gule muulungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yalgo komina nongwa binanwenbile, po tausen milimba, abal te gaan ta kerekungwa. ");
INSERT INTO gvf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","U ku bilungwa ibal kobe Yesu ka di sutaw ere tere, sipe ta ala pire nil mininmina pi Magadan gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ena Parasi te Sadusi kobe taw, Yesu milungwa gul ungwa. Urere, “Na yal kobe i main pirabina dire, kamin mina kal guman kwi dungwa ta i maribe ere na tenanga kanabinwa,” dire yalini sua i kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kanimba Yesu iru dungwa, “Are yaa biingwa kaun kamin more yongwa, ‘Nimin ta sikenamua,’ dingi, ");
INSERT INTO gvf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","te taanima wen kamin kama milungwa, ‘Nimin sinamua,’ dinwa. I yal kobe kamin kama milungwa kaninga main pirinba, kamin kaun malia kal ta u maribe ongwa main pirekun erekinwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ibal malia maalungwa kobaan pisere, pi yal ta pire kal digan ere taalime ere milemua. Milere kal guman kwi dungwa i maribe erangwa kanabina di pirimba, i maribe ere tekenamua. Tekenamba Yona milungwa kaun kal guman kwi dungwa erungwa mere, iru kuunin ere i tenamua.” Dire Yesu yalin kobe milungwa gul pisere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ena gawlima kobe nil benge kole u bawa dire, komina birete yuungwa nomanin si pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu iru di gawlima kobe tongwa, “Parasi te Sadusi kobe bole komina birete u bil ongwa mere, yalin kobe ka dinangwa sidinadi u bil nangwa, i nai kane milo.” ");
INSERT INTO gvf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dungwa i, yal kobe diria ere iru dungwa, “Komina birete ta yuukibinga mere, yalini iru di bile dimua.” ");
INSERT INTO gvf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Dungwa Yesu pirere iru dungwa, “Pire gi tawliga dinga yal kobe milinga we. Komina ta dekungwa mere ka iru, tameran diria ere miline? ");
INSERT INTO gvf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","I pire bawa dikino? Komina birete anan kole muru bege dire, ibal binanwenbile, paib tausen tobinga, nomanin si ala erino? Komina imo dungwa gal tamintan gule muuline? ");
INSERT INTO gvf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te komina birete anan kole muru kole sutan ibal binanwenbile, po tausen tobinga irawe. Komina imo dungwa gal tamintan gule muuline? ");
INSERT INTO gvf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Komina birete mere ka ta iru dekebinga, tameran i pirekun erekine? Parasi te Sadusi kobe bole komina birete u bil ongwa mere, i nai kane milo.” ");
INSERT INTO gvf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dungure ena “Komina birete u bil ongwa mere ka ta dikire, Parasi te Sadusi bole ka main nil si tongwa mere, ka iru dimua. Te, ‘Kalin dungwa nai kane milo,’ dimua.” Dire gawlima kobe iru pire bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ena Yesu Sisaria Pilipai gariba gul u bawa dire, iru sirin bile gawlima kobe tongwa, “Na U Ibal Obinga Yal milebingi pirere, takal waa dire na kaanan galeme?” ");
INSERT INTO gvf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dungure maan dire iru dungwa, “‘Nil bile tongwa yal Yon, i milinwa,’ dungure, ibal taw kobe mile, ‘Ilaya milinwa,’ dungure, te ibal taw kobe mile, ‘Yeremaya mo God ka kebe yal ta milinwa,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dungure Yesu iru sirin bile tongwa, “Ibal kobe iru dimba, na milebingi pirere, takal waa dire na kaanan galine?” ");
INSERT INTO gvf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sirin bile tongure, Saimon Pita maan dire iru dungwa, “I God konagi erungwa yal Kirisito milere, te mile painangwal painangwa Kobaan God, yalini Wan, i milinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dungure Yesu maan iru di tongwa, “Yona wan Saimon, miriin pai i tenamua. Malia i kawen dinga i, ibal di maribe ere i tekungure, na Abe kamin mina milungwa di maribe ere i tomia, ena miriin pai i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tomia ena ka iru di terala, i kaanin Pita dimua. (Yalini kaan Golin ka paangwa, Kobile.) I kobile mere milinga na ka main ibal maale sulu dinamua. Dinangure na iru erabinwa. Erabingire enderin gaul ai ibal, ka main ibal ta si main erekinamua. ");
INSERT INTO gvf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","God kenin ere ke milungwa ai ki milin i terabinwa. Gariba gul mile kal ta manaa dinanga, kamin ai para ka dinga i milin u maribe namua. Te gariba gul mile, ‘Kal ta para painamua,’ dinanga kamin ai para ka dinga i milin u maribe namua.” ");
INSERT INTO gvf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dire Yesu gawlima kobe kiraan aa tere iru dungwa, “Na God konagi erungwa yal Kirisito miliga, i di maribe erekio.” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ena kal ta u maribe pi Yesu tenangwa kaun iray kawn kule di gawa dire, Yesu iru di gawlima kobe tongwa, “Na Yerusalem ai nalga kaun, Yuda ibal ka main ogu singaba kobe, te kenin erungwa yal bil kobe, te ka main nil si tongwa yal kobe, ena yalin kobe giil pire na terere na si gulamba, girungwa taangwa are kaun sutakobe wei sinangwa, na si kwi yere alalwa.” ");
INSERT INTO gvf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dungure ena Pita mile, Yesu inin awli pire kan tere iru dungwa, “Singabo, ‘Kal iru eramua,’ dinga God manaa dinamua.” ");
INSERT INTO gvf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dimba Yesu kiruul sire iru di Pita tongwa, “Satan i ere tayan po. Na kal eralga i kol si pere di na tenwa. I ka dinga God nomanin si pirungwa mere nomanin si pirekingi, ibal nomanin si pirungwa mere i iru si pirinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu kwi ainere iru di gawlima kobe tongwa, “Yal ta na munan kol duulan bilala di pirangwa, ena yalini gain kal pirungwa maangure manaa di tere, te na giil pire gulabinga mere yalini giil pire gulere na duulan bilamua. ");
INSERT INTO gvf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yal ta inin gain pire tere mile painangwal painangwa nomanin tegi dinangwa, ena yal i u main namua. Na inan miligire pire unin sinangwa ena yal i mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yal ta gariba kal para wen aa te nenamba, iban u mena nangwa takal iname? Iban u mena nangwa yal ta kwi mile pairalgal pairala dire takal tobe tename? Ta tekenangurawa. ");
INSERT INTO gvf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na U Ibal Obinga Yal mile, na Abe naabilungwa, te angel bole urala erebinwa. Urabinga ibal kobe kalkan erungwa mere maan ere terabinwa. ");
INSERT INTO gvf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na kawen di terala i piro. Ibal kobe taw malia abila milungwa ta gulekire, goma Na U Ibal Obinga Yal ibal kobe kenin ere ke milabina dire kwi urabinga, ibalin kobi goma kanere ena gulamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ena are kaun anan kole muru kole taran wei sungure, Pita te kebin abin sui Yemis te Yon, Yesu yal kobi awli i kamin kuul bil maangwa ongwa. Pi inin mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yesu igin gain kwi kulungure yal sutakobe kanungwa. Yalini are dongwa mere guman iru kulungwa, te gal pirungwa naabile aw dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mose te Ilaya bole Yesu ka diria ere milungwa yal sutakobe para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kanemia ena Pita iru di Yesu tongwa, “Singabo, na yal kobe abila milebinga wai pirebinwa. ‘Are dine ogu bil sutakobe kiyo,’ dinanga kiirabinwa. Ta i ki tere, ta Mose ki tere, ta Ilaya ki terabinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ka i di milungure kawa ta naabilungwa yobile suna erungure kawa ye suna erungwa ali ka ta iru dungwa, “Yalini na Wanan taran milemia nomanin wai tere, gun ye teiwa. Yalini ka dungwa piro.” ");
INSERT INTO gvf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dungwa i, gawlima sutakobe pirere kalgane ire kuril pire ole si main pire yaa i kwi bilungwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","I kwi bilimba Yesu ure gain mina aa tere iru di tongwa, “Ena i kuril pirekio, alo.” ");
INSERT INTO gvf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dimia ena yal sutakobe kane yebe ere ibal kobe ta milekungure, Yesu inin milungwa kanemia. ");
INSERT INTO gvf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kamin kuul wi ime ongwa Yesu yal sutakobe kiraan aa tere iru di tongwa, “I kal guman kwi dungwa kaninga, ibal kobe malia di maribe ere tekio. Na U Ibal Obinga Yal gulere kwi alalga kaun, ka iru di maribe ere ibal tenanwa.” ");
INSERT INTO gvf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dungure gawlima sutakobe sirin bile Yesu tongwa, “‘Ilaya goma u maribe namua,’ dire Yuda ka main nil si tongwa yalin kobe tameran iru dime?” ");
INSERT INTO gvf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sirin bile tongure Yesu waa dire iru dungwa, “Ilaya kawo goma urere kalkan para muru aa tekun eramua. ");
INSERT INTO gvf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Iru dimba na iru di teralwa. Ilaya kaya umiiba, ibal kobe yalini guman ta kanekire, inin nomanin si pirungwa mere iru ere yalini tomua. Ere yalini tongwa mere, yalin kobe para Na U Ibal Obinga Yal giil pire na tenamua.” ");
INSERT INTO gvf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dimia ena gawlima sutakobe iru nomanin si pirungwa, “Ayo, malia nil bile tongwa yal Yon milungwa mere pire dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ena yalin kobe pi ibal binanbile milungwa gul ongure, yal ta Yesu milungwa gul yaa gobin bile mile ");
INSERT INTO gvf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","iru di tongwa, “Singabo, i miriin wen pire na wanan to. Yalini kamina egilungwa yal milemia nuure omilin maalangwa, ena gaul si enderin te nil ali ere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","I gawlimanin kobe aa te wai ere tenama dire awli ubinba, aa te wai erala di erimba, kuunin paikimua.” ");
INSERT INTO gvf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dungure Yesu maan dire iru di yalini tongwa, “Ayo, i yal kobe malia maalinga pire gi dikire, taalime eringa ibal milinwa. Kaun tamintan inin bole imo mile pairale? Kaun tamintan i taalime eringa na obin ere kine ire warabine? Gaan iray awli na na to.” ");
INSERT INTO gvf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dire, sia kan tongure sia u mena ongure dungwa kaun wen i, gaan gin taran pilaan pai milemia. ");
INSERT INTO gvf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ena gawlima kobe pi Yesu milungwa gul pire, yalin kobe inin ku bile milere iru sirin bile tongwa, “Tameran na yal kobe sia maa si mena erabina di erebinga paikime?” ");
INSERT INTO gvf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dungure Yesu maan iru di tongwa, “I pire gi tawliga dingiray paikimua. Na kawen di terala i piro. Koruul milin dungwa mere iru pire gi dinanga, ena ‘Kamin kuul ta i pi baan ta po,’ dinanga namua. Kal para wen erala di piranga ena eranga painamua. ");
INSERT INTO gvf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","I komina mawal ere ana di God tere, ‘Aa ki di na to,’ dinanga ena sia iru maa si mena eranba, ana iru di tekenanga kuunin ta erekinanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ena gawlima kobe para Galili gariba gul u ku bilungure, Yesu iru di tongwa, “Na U Ibal Obinga Yal, yal kobe na kanin sire awli ibal tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tenangure na si gulamba, are kaun sutakobe wei sinangure kwi alalwa.” Dungure gawlima kobe miriin pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ena yalin kobe Kapanaum ai u bawa dungure ka main ogu kobile takis ingwa yal kobe, Pita milungwa gul ure iru sirin bile tongwa, “I nil si tongwa yal, ka main ogu kobile takis tom mo, tekeme?” ");
INSERT INTO gvf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Dungure Pita, “Tomua,” dungwa. Dire ogu ala pire ka dirala dimba, Yesu kaya dire iru di Pita tongwa, “Gariba gul yal bil kobe kobile takis ingwa we. Enin taw kobe tom mo, gariba baan ta ibal tome? I inin nomanin si piranga mere di na to.” ");
INSERT INTO gvf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sirin bilungure Pita, “Baan ta ibal tomua,” dungure ena Yesu iru di tongwa, “I iru dingi, ena enin kobe tekenangwa paikinamua. ");
INSERT INTO gvf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Paikinamba, nigi de pire na yasu ta tekinangwa, ena i nil benge pire nil kabe sungwa kan pusi nil ali ere, nil kabe goma sinangure giran ali aa paule kananga, kobile moni dinamua. Ka main ogu kobile takis pi kobile i tenanga, na te i takis terabinga mere kuunin painamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ena kaun i gawlima kobe Yesu milungwa gul ure iru sirin bile tongwa, “God kenin ere ke milungwa ai, ibena singaba mile goma name?” ");
INSERT INTO gvf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dungure gamege ala dire, “Wo,” dungure ungure, gawlima kobe milungwa suna alungure ");
INSERT INTO gvf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yesu iru di yalin kobe tongwa, “Na kawen dirala piro. I nomanin suna si kiruul sikire u gamege mere pekenanga, ena God kenin ere ke milungwa ai suna ta pekenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yal ta nomanin yaa ime sire gamege mere mile u main nangwa, ena yalini God kenin ere ke milungwa ai suna singaba mile goma yenamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yal ta na guunan kanan pire aa te wai ere gamege tenangwa mere yalini para aa te wai ere na tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Gamege iru pire gi di na tongwa iwe. Yal ta ure kakiibi di kela kula tenangure gaan i kal digan ere taalime erangwa, ena gain giil bilkaw piramua. Kela kula tongwa yal i, kobile bilkaw naan mina kan sire pusi pirin nil ali erangure, sagu dire gulangwa paimua. ");
INSERT INTO gvf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gariba gul ibal kakiibi di kela kule tongwa, ena ibal taw kobe kal digan ere taalime erungwawe. Ayo, gariba gul ibal gain giil piramua. Kakiibi di kela kule te milamba, kela kule tongwa yal iwe. Ayo, yalini gain giil piramua. ");
INSERT INTO gvf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“I kawnin mo anin erina kal digan ere taalime eringa i, di keli sire piseranga mere i kal digan i pisero. I anin kawnin sui para wai imo dungwa, enderin gaul ai nanga ta paikinamba, i anin kawnin ta diman dinangure kamin ai mile painanga ena iru painamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","I omilin kanina kal digan ere taalime eringa i, i omilin woule eranga mere kal digan i pisero. I omilin su para wai imo dungwa enderin gaul ai nanga ta paikinamba, i omilin ta woule eranga kamin ai mile painanga ena iru painamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ena gamege goma dibinga iray, i nigi de pire tekio. Yalin kobi pire ka dirala i piro. Na Abe kamin mina milungwa, yalin kobe angel yalini guman mina morin morin milemua. ");
INSERT INTO gvf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ibal kobe God main ta pirekire wou bilungwa aa ki di tegire, sigare kule u wai nama dire, Na U Ibal Obinga Yal ere ime wiwa. ");
INSERT INTO gvf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ka pore di i terala main paangwa mere i nomanin si piro. Yal ta bolima siipe siipe wan kandiret kenin ere milungwa, ta u baan ta nangwa yalini takal erame? Bolima siipe siipe nainti nain wai imo mile, kowan ali milungwa pisere, ta u baan ta ongwa waa duunamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na kawen dirala piro. Inanin si waa duure kanangwa iwe, bolima siipe siipe nainti nain wai imo milungwa wai pirimba, ta waa duure kanungwa wai wen pire miinin maamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yal ta iru erungwa mere gamege i u baan ta nama dire i Kamin Abe iru ta pirekemua. ");
INSERT INTO gvf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“I enin taw kobe kal digan ere i tenangwa, i pi yalini milungwa gul pire i yasu inin milebilgiray, pirin paangwa i di maribe ero. I ka dinanga pirangure i yasu u taran nanwa. ");
INSERT INTO gvf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dimba i ka dinanga ta pirekenangwa, ena yal ta mo sutan para awli nangire i kalkan di maribe eranga, yal sutan mo sutakobe kane piramua. Pirangwa eme ka kol erangure kanungwa yal milamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Dinamba yalin kobe ka dungwa para pirekenamia, ena ka main ibal taminin para di gawa di to. Di tenangire para pirekenamia, ena Yuda milekungwa ibal mo takis ingwa yal milungwa mere, nomanin si pire yalini to. ");
INSERT INTO gvf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na kawen di terala i piro. Gariba gul mile, kal ta manaa dinanga kamin ai ka dinga i milin u maribe namua. Te gariba gul mile, ka ta ‘Para painamua,’ dinanga kamin ai para, ka dinga i milin u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kwi di terala i piro. Ena ibal sutan ka ta painangwa, ka dibia ere nomanin u taran nangure ana di God terabilga, ena na Abe kamin mina milungwa kal iray i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yal sutan mo sutakobe na pire u taminin milangwa, na para suna milabinwa. Milabinga, na Abe kamin mina milungwa kal iray i tenamua.” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ena Pita Yesu milungwa gul ure iru sirin bile di tongwa, “Singabo, na enan taw kobe kal digan ere taalime ere na te milangwa, ginin tamintan pirin gule ere terabine? Ginin anan kole muru kole sutan gule ere terabino?” ");
INSERT INTO gvf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dungure Yesu iru maan dire di tongwa, “Anan kole muru kole sutan, tamama. Kaun kaun pirin gule ere te milangal milanwa. ");
INSERT INTO gvf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iru dibinga piregire God kenin ere ke milungwa, iru mere milemua. Yal bil ta milere yalini konagi aa ki dungwa yal kobe, konagi ere kobile moni irere kwi maan yal bil tenama dire, aa tekun erala di piremua. ");
INSERT INTO gvf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kobile maan tenangwa aa tekun erala di erungwa, ena yal ta kobile moni binanwenbile, miliyon taw kobe, pirin pai dungwa kwi maan te ain erala di eremua. ");
INSERT INTO gvf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pirin pai dungwa gule erama dire, kobile moni kuunin erekimia, ena yal bil kobile moni inama dire yal i, te ebinbi te wan abilin kobe, te yalini kal para wen, yal ta terala di piremua. ");
INSERT INTO gvf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iru piremia ena konagi aa ki dungwa yal kobaan milungwa gul yaa gobin bile mile kawan dire iru di tongwa, ‘Kaun taw imore mile eme kobile moni muru i kwi maan te ain erabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dungure kobaan miriin wen pire tere, pirin bilkaw paangwa gule ere tere, ‘Para ere po,’ di tomua. ");
INSERT INTO gvf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ena yalini malge pire enin ta bole konagi aa ki di kobaan tongwa yal ta, kobile moni ten kina tawle goma tongure pirin paingure, ena naan aa gi dire iru dungwa, ‘Kobile moni tega malia i maan na to.’ ");
INSERT INTO gvf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dimia ena konagi aa ki dungwa yal ta, yaa gobin bile kawan dire iru dungwa, ‘Kaun taw imore mile eme kobile moni kwi maan te ain erabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dimba manaa dire kanin sire kobile moni tenama dire, kanin paangwa ogu ala eremua. ");
INSERT INTO gvf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Konagi aa ki dungwa yal taw kobe, yal ta iru erungwa kanere, nigi de wen pirere, pi kobaan milungwa gul pire di gawa dimua. ");
INSERT INTO gvf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dimia ena kobaan ‘Ere wo,’ di gala di konagi aa ki dungwa yal tongure, ungure iru di tongwa, ‘Nil erari yale, i yal digan milinwa. I kaan di na tengire, kobile moni para muru pirin pai imo dungure malia gule ere i tegirawa. ");
INSERT INTO gvf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tega, na miranan wen pire i tega mere, konagi aa ki dungwa yal ta, miriin wen pire tenaniba.’ ");
INSERT INTO gvf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dire kobaan den gulere aa ki di tongwa yal gain giil pirama dire, nusi kanin paangwa ogu eremua. Gain giil pire tenangure kobile muru maan te piserangwa, ena kanin gule eramua. ");
INSERT INTO gvf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ena, i enin kobe kal digan ere taalime ere i tongwa, pirin gule ere tekenana kobaan ere yal ta tongwa mere, na Kamin Abe iru ere i tenamua.” Dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ena Yesu ka dungwa i di pisere Galili gariba gul pisere, pi Yudia gariba suna ongwa. Yodan nuule binan kole ime ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nibil erungwa ibal binanwenbile duulin bile ongure, yalini kol iray aa pilaan pay tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parasi kobe taw urere Yesu sua i kanala dire, iru sirin bile tongwa, “Yal ta ebinbi imore de erungwa, na kile kaman ka main paangwa si keli sim mo, sekime?” ");
INSERT INTO gvf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Dungure Yesu iru maan dire di tongwa, “‘Kamin kaya wen God gariba ere yongwa, yal te abal ere yomua,’ dire ka main minin ganin iru bilungwa kere pirekeno? Piringirawa. ");
INSERT INTO gvf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Te ta para iru bilungwa, ‘Yal nen man ogin pisere, ebinbi bole ki paire yalsui su waire u taran namua.’ ");
INSERT INTO gvf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iru pirere yal sui nomanin te gain u taran pi milamua. God yal abal su waire si dawle tenangwa, ibal ta a piraa sekenamua.” ");
INSERT INTO gvf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dungure Parasi kobe iru di tongwa, “Yal ta ebinbi de erala dire, ka minin ganin bile tere, ‘Ere po’ dinamua dire, tameran Mose ka iru dime?” ");
INSERT INTO gvf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dungure Yesu iru di tongwa, “I girin dire nomanin paikungwa, ena ebinbi de erala dire ka minin ganin bile tere, ‘Ere po,’ Mose dire iru dimua. Ebinbi de erangwa Mose ‘Para paimua,’ dungwa. Dimba kamin kaya wen iru ta erekimua. ");
INSERT INTO gvf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Te ka ta iru dirala piro. Abal pi yal ta kunibe ikimba winbi abalini de erangwa, ena abal ta kwi inangwa, yalini abal i kunibe ingwa mere inamua.” ");
INSERT INTO gvf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dungure gawlima kobe iru di tongwa, “Win ebin main iru painamia, ena yal imore milangwa wai painamua.” ");
INSERT INTO gvf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Dungure Yesu iru dungwa, “Ena ka dungwa i, ibal para pirangwa ta paikinamba, God mile ibal taw pirama dungure, ena ibalin kobe piramua. ");
INSERT INTO gvf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yal taw kobe abal ikinangwa main iru paimua. Yal taw kobe man kule yomba yal wen ta milekire, abal ta inangwa ta paikinamua. Te yal taw kobe ibal kal ta ere tongure abal ta inangwa ta paikinamua. Te yal taw kobe God kenin ere ke milungwa mere pirere, abal ta ikinamua. Ka nil si tobinga i yal kobe pirama dire kuunin painangwa, ena yalin kobe piramua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yesu gamege gibilin aa taw sire ana di God tenama dire, ibal kobe gamege awli Yesu milungwa gul ongwa. Ongure gawlima kobe kan tomba ");
INSERT INTO gvf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu iru dungwa, “Gamege kobe na miliga gul urala di unangwa, i iru kobaan si tekio. Gaan iru milungwa God kenin ere ke milungwa ai ali painamua.” ");
INSERT INTO gvf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dire gibilin aa taw sire ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ena yal ta Yesu milungwa gul ure iru di tongwa, “Nil si tongwa yalo, ta konagi wai erabinga mile pairabingal pairabine?” ");
INSERT INTO gvf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dungure Yesu iru di tongwa, “‘Konagi wai erabinwa,’ dingiray, tameran sirin bile na tene? God inin tawle wai milemua. Wai wen mile pairalgal pairala dire, kile kaman ka wiina ero.” ");
INSERT INTO gvf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dungure yal ta i sirin bile Yesu tongwa, “Ta kile kaman ka wiina ere terabine?” Dungure Yesu iru waa dire dungwa, “Ibal si gulekio, abal te gi kunibe nekio, kal kunibe nekio, kakiibi digwane waa tekio, ");
INSERT INTO gvf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nenin manin ai yebe di to, i inin nomanin tenga mere, i ye nenga ibal kobe nomanin ama iru to.” ");
INSERT INTO gvf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dungure yal garamil i maan iru di tongwa, “Malia kile kaman ka dingi iray, na wiina ere miliiba, takal para eralga painame? ");
INSERT INTO gvf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dungure Yesu maan iru di tongwa, “I ibal dimi di milala di piranga, ena i pi bona aa te nenga ibal tere kobile moni ire aa te nekungwa ibal obin si to. Tenanga kamin gul bona gana aa te nere ure, na munan kol duulin bilo.” ");
INSERT INTO gvf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dungwa pirere, bona binanbile aa te nongwa, guman wai kane miriin wen pirere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ongure Yesu iru di gawlima kobe tongwa, “Na kawen dirala i piro. Bona binanbile aa te nongwa ibal, God kenin ere ke milungwa ai suna nangwa, nega wen dinamua. ");
INSERT INTO gvf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ta dirala piro. Bolima kamel kay kiibanin kuun yongwa suna ali nangwa konagi nega dimba, aa te nongwa yal God kenin ere ke milungwa ai suna ali nangwa, kal nega wen dimua.” ");
INSERT INTO gvf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dungwa gawlima kobe pirere pire buul wen kunere iru sirin bile Yesu tongwa, “Ibena God aa ki di tenangure sigare kule u wai name?” ");
INSERT INTO gvf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Di tongure, Yesu yal kobe tena kanere iru dungwa, “Ibal iru ta erekinamba, God konagi para wen erangwa kuunin paamua.” ");
INSERT INTO gvf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dungure Pita iru maan dire dungwa, “Dinba, na yal kobe kalkan para wen pisere i duulin bilebinwa. Na yal kobe takal irabine?” ");
INSERT INTO gvf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dungure Yesu di tongwa, “Na kawen dirala i piro. Gariba gul kamin ta kwi wen u maribe nangwa kaun, Na U Ibal Obinga Yal gariba kenin erungwa ain pire yal bil milabinga, ena kaun i, i gawliman anan kole kole muru kawnan milin su para, gariba kenin erungwa yal bil ain pire, Isirel ibal yal gawlin gawlin anan kole kole muru kawnan milin su nil tere, ka kol pire tenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ibal kobe na wai pire, ogin gul te abinbi te kebinbi te alenbi te nen te man te gawlin te gariban kalkan kobi mere piserangwa, ena kalkan kobe binanbile, wan kandiret mere, inangure, te mile painangwal painama dire God iru ere tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dibinba ibal taw kobe, guman kol milungwa kwi u mun kol milamua, te ibal taw kobe, mun kol milungwa kwi u guman kol milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Dire Yesu iru dungwa, “Girepe kan gul kobaan kwimile taanima malge pire, nil konagi ibal konagi gul aa ki di tenama dire ongwa mere, God kenin ere ke milungwa iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ibal taw kane, ‘Are kaun ta tobe bilungwa mere, kina taranta teralwa,’ dungure, ibal ‘Para kuunin eremua,’ dungure konagi erama dire, nusi girepe kan gul suna eremua. ");
INSERT INTO gvf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Are taw suna ongwa, nain kilok, yalini kwi malge pire yal taw imore milungwa kanere, iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘I pi girepe kan gul suna konagi eranga ena aibe tobe kuunin teralwa.’ Dungure ere omua. ");
INSERT INTO gvf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ena omale kaun te pu dungwa kaun para, kwi kwi pire iru eremua. ");
INSERT INTO gvf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Are pi pera waangure, paib kilok, kwi malge pire yal taw para imore milungwa kanere dungwa, ‘Tameran are kaun kemina i imore miline?’ ");
INSERT INTO gvf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sirin bile tongure ibalin kobe, ‘Ibal konagi ta na tekemua,’ dungure yalini di tongwa, ‘I para girepe kan gul suna konagi ero.’ ");
INSERT INTO gvf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ena kamin girungure pare komina gul kobaan iru di nil konagi kenin erungwa yal tongwa, ‘Nil konagi ibal, ere wo, di gala dire tobe to. Nil konagi ibal eme ungwa i goma tobe tere, te goma u konagi erungwa ibal, i eme tobe to,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nil konagi ibal are pi pera waangure, paib kilok, kawn kule konagi erungwa, yal taran taran kina taranta tongure imua. ");
INSERT INTO gvf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Iru tongwa, goma u konagi erungwa ibal, kobile bil na tenama di pirimba, para kina taranta tomua. ");
INSERT INTO gvf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kobile moni irere, nigi de pire konagi kobaan tomua. ");
INSERT INTO gvf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tere iru dungwa, ‘Yalin kobe baan tawlita, wan awa, konagi erimba, na yal kobe konagi nega dire ere are dongwa gul erebinga, tobe yalin kobe tenga mere iru na yal kobe tawle tenwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dimba komina gul kobaan maan iru di yal ta tongwa, ‘Ye nega, ena i piro, i konagi are kaun ta eringa, kina taranta para kuunin eremua, dinga na kobile kunibe ikibinwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ena i kobile ire ere ogun po. Yal ta eme u konagi erungwa, i tobe tega mere yalini para terala di piriwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na inan kobile moni kal ta erala di piriga para paangwiwe, mo na inan yal miliga sanan bale na teno?’” ");
INSERT INTO gvf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu ainere iru dungwa, “Ena iru paamia ena ibal mun kol milungwa kwi u guman kol milangwa, te ibal guman kol milungwa kwi u mun kol milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ena Yesu pi Yerusalem ibe ongwa kaun, gawlima kobe anan kole kole muru kawnan milin sutan, awli inin baan pire iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ena i piro. Na yal kobe Yerusalem ai pi u bawa dirabingire, yal taw kobe Na U Ibal Obinga Yal awli pi Yuda kenin erungwa yal bil kobe, te ka main nil si tongwa yal kobe para tenangure, na aa gi di milere, ‘Si gulo,’ dire ");
INSERT INTO gvf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","na awli Yuda milekungwa ibal tenamua. Tenangure yalin kobe ka di sutaw ere tere, bolima gain galan yongwa kuba aa te sire, eri pera mina na si gulamua. Ena kaun sutakobe wei sinangure, God si kwi ye na tenangure, alalwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi wan sutan milere yalin kobe man bole, Yesu milungwa gul ungure, ena abalini yaa gobin bile mile, Yesu kal ta ibal ta tenama dire kaan dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dungure Yesu iru di abalini tongwa, “Takal i terale?” Di tongure abalini iru dungwa, “I kenin ere ke milanga kaun u bawa dinangure, na wanan sutan i daanin kole kole mile, singaba milabila di i kirara kawen di na to.” ");
INSERT INTO gvf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dimba Yesu maan iru di tongwa, “I yasu kanekun ere dikinwa. Ibal kal ki ere na tenangwa piralga mere, i para pire kuunin painamo?” Di tongure yal su, “Para pairabilwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dungure Yesu iru di tongwa, “Owa, ibal ki ere na tenangwa piralga mere i yasu para piranba, na daanan kole kole milo, di teralga na konagi ta paikimua. Na Abe, ‘Milo,’ dima di pirungwa mere milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iru dungwa mere gawlima kobe anan kole kole muru imo milungwa pirere, nigi de pire kebin abin su tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tomba Yesu pirere, “Ena yal kobe ere wo,” di gala dire iru di tongwa, “Gariba baan ta kenin erungwa yal kobe enin gawliman awli ure nil konagi yongure, te yal singaba ibal kobe ke milungwa mere i kaninwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kaninba i suna ali iru ta erekinanwa. I milinga gul suna, yal ta singaba milala di pirangwa, yalini nil konagi ere gawlima kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","I milinga gul suna yal ta ogu bire kaana mile singaba bil milala di pirangwa, yalini ibalin kobe muru nil erari yal milamua. ");
INSERT INTO gvf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na U Obinga Yal para nil konagi ere na tenama dire ime ukiiba, na nil konagi ere ibal terala dire wiwa. Gariba ibal miriki kal digan ere taalime erungwa, pirin i gule ere tegire imore baan pire sigare kule u wai pi milama dire, na tobe tere gulalwa,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu te gawlima kobe Yeriko ai pisere ere nala di ongure, ibal binanwenbile duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Omilin gi dungwa yal sui kombil binan milere, “Yesu kola umua,” dungure pirere, gala dire iru dungwa, “I Debiti Gawlin milinga miriin pire na to.” ");
INSERT INTO gvf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","U ku bilungwa ibal kan tere, “Sime milo,” di tomba, gala bil dire iru dungwa, “Singaba, i Debiti Gawlin Kirisito milinga miriin pire na to.” ");
INSERT INTO gvf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dungure Yesu abili milere, “Ere wo,” di gala dire ungure, iru sirin bile tongwa, “Kal ta ere i terabinga takal nomanin si pirine?” ");
INSERT INTO gvf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dungure yal sui iru dungwa, “Singabo, omilan pilaa dinama dire, iru nomanin si pirebilgayawa.” ");
INSERT INTO gvf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ena Yesu miriin pire tere, yal sui omilin aa tongure gin taran omilin pilaa dungure, yal sui Yesu duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ena ibal yalin kobe Yerusalem u maala ure ogu ai ta kaan Betepage u bawa dungure, ai iray kamin kuul kaan Olibe binan kole dungwa. Baan iray u bawa dungure Yesu mile, gawlima kobe sutan nusi ere ");
INSERT INTO gvf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ka iru di tongwa, “I ogu gul kola kaninga po. Ogu gul i pirere ena nanga kaun wen i, bolima donki kan kule milere, te gawlin kumil kwi para milungwa kananwa. Kan gule ere bolima donki sui awli wo. ");
INSERT INTO gvf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yal ta manaa dinangwa ena iru di ta, ‘Singaba irala di pire, konagi ta eramua.’ Dinanga, ‘Ena para ire ere po,’ dinamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Goma wen ka kebe yal dungwa mere pi nima nama dire, kal iru u maribe ongwa. Ka kebe yal iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“God iru dimia, ‘Sayon ogu ai gawlin kobe iru di to. I kenin erungwa yal bil i milinga gul unamua. Yalini kabin si milere bolima donki aw si ire unamua. Bolima donki gawlin kumil kwi aw si ire unamua.’” ");
INSERT INTO gvf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesu ka di tongwa wiina erere pi erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bolima donki te gawlin para awli urere, mun bolimina inin gal kaw tongure Yesu bolima donki aw sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","U ku bilungwa ibal taw binanbile gal kombil bolimina pilaa di yongure, ibal taw kobe eri minin arin bile wi yuure, kombil para pire yongwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ibal kobe taw goma, te taw eme ongwa para, “Aya maya,” dire iru gala dungwa, “Debiti Gawlin Kirisito deminin si terabinwa. Yal ta God ka dungwa kebe ere yuungwa God miriin pai tenamua. Kamin mina ibe kobe God deminin si tenamua.” ");
INSERT INTO gvf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ena Yesu Yerusalem ai u bawa dungure, wi yau dire sina di u kowa dungure, ena ibal kobe iru sirin bilungwa, “Yal i ibena mileme?” ");
INSERT INTO gvf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Nasarete ai Galili gariba gul suna dungwa nen, God ka kebe yal Yesu milemua,” dire u ku bilungwa ibal iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ena Yesu mile Yuda ka main ogu bil ala pire, kalkan yongwa ibal te gibilin sungwa ibal waa kire di malge erere kobile tobe erungwa yal kobe, bol a garu direre, kauba si gale God tenangwa kauba imil yongwa, ibal amin di milungwa bol para, a garu dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Direre iru di tongwa, “God dungwa mere ka main minin ganin iru bilungwa, ‘Na ogu ibal ana dungwa ogu dinamua.’ Dinamba i kalkan yere te gibilin singa, ena kunibe ibal kobile giran ale paangwa mere, na ogu ama iru paangwa erinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu ka main ogu bil ala milungwa, omilin gi dungwa ibal te kawn ki sungwa ibal para ungure, Yesu aa te pilaan pai tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yesu kal iru erungwa ibal kane buul kune pirungure, te gamege ka main ogu bil ala mile, “Debiti Gawlin Kirisito deminin si terabinwa,” dungwa ena Yuda ka main kenin erungwa yal bil kobe, te nil si tongwa yal kobe bole, nigi de wen pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Milemia ena iru di Yesu tongwa, “Gamege ka dungwa iray i main pirekeno?” Dungure Yesu, “Na piriwa,” dire iru dungwa, “Gamege te gaan amin nongwa para deminin si tenama dire, nil si tenwa,” dire, “Ka main minin ganin iru bilungwa ta kere pirekeno?” ");
INSERT INTO gvf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu yalin kobe Yerusalem milungwa pisere, ere pire Betani ogu ai gilaa iray pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ul paire alere kwi mile ere Yerusalem ai nala di ongwa, kol baan kenan gule milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Milere eri akola ta kombil binan dungwa kanere, pi maala omba, milin ta kulekire arin tawle sungwa. Simia ena iru di akola tongwa, “Milin kwi ta kulekio.” Dungure, akola gin taran kengi sire gulungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gulungure, gawlima kobe buul kune kanere iru sirin bile tongwa, “Akola gin taran keni sungwa, tameran iru ereme?” ");
INSERT INTO gvf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Dungure Yesu maan dire iru di tongwa, “Na kawen di terala i piro. I pire gi dire nomanin sutan sikinanga, ena na eri akola ere tega mere, para iru eranga painamua. Te iru tawle tamama. I iru di kamin kuul ta tenanga, ‘I pi pirin nil suna yaa so,’ dinanga ena pi yaa sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","I pire gi dinanga ena kal ta ana di God tenanga inanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ena Yesu kwi pi Yuda ka main ogu bil ala pire, nil si te milungwa kaun, Yuda ka main kenin erungwa yal bil kobe, te singaba kobe bole ure iru sirin bile Yesu tongwa, “I kal main eringa, ibena yobilaan bile i tome? Te ibena ‘Ero,’ di i tome?” ");
INSERT INTO gvf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Dungure Yesu maan iru di tongwa, “Na ka ta sirin bile i tegire, i maan di na tenanga, yal ta ‘Ero,’ di na tongwa, yal i di maribe eralwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yon nil bile tongwa main u maribe ongure, ibena yalini nusi erime? God nusi erim mo, ibal nusi ereme?” Dungure yalin kobe inin ka diria ere iru dungwa, “‘God nusi eremua,’ dirabinga yalini iru dinangwa, ‘Tameran yalini i pire gi di tekine?’ ");
INSERT INTO gvf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Paamba, ‘Ibal nusi eremua,’ dirabinba ibal para muru mile, ‘Yon ka kebe yal milemua,’ di iru aa gi di pirungure, na yal kobe kuril pirebinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dimia ena yalin kobe iru maan dire di Yesu tongwa, “Na yal kobe pirekun erekibinwa.” Dungure Yesu di yalin kobe tongwa, “I iru dinga, ena yal ta ‘Ero,’ di na tongwa, para di maribe ere tekeralwa.” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ena ka pore di i terala main painangwa mere nomanin si piro. Yal ta milungure wan sutan milemua. Yalini iru di wan kominin tongwa, ‘Wanane, kemina na komina gul konagi erana po.’ Dungure yalini ");
INSERT INTO gvf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Na nala pirekiwa,’ di tomba, eme nomanin si kiruul si pire omua. ");
INSERT INTO gvf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ena nen ama iru di wan emin tongure, yalini mile, ‘Abe ere nalwa,’ di nen tomba, pekemua. ");
INSERT INTO gvf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wan ena nen ka dungwa wiina ereme?” Dungure yalin kobe iru maan dire di tongwa, “Wan kominin eremua,” dungure Yesu iru di tongwa, “Na kawen di terala i piro. Kobile moni takis ingwa yal kobe, te yal maale ingwa abal kobe bole, God kenin ere ke milungwa ai suna goma namua. Nangure i eme nanba. ");
INSERT INTO gvf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nil bile tongwa yal Yon, ure i kol wai ta bala di i tomba, yalini ka dungwa aa gi di pirekingi. Dimba takis ingwa yal kobe, te yal maale ingwa abal kobe bole, aa gi di piremua. Pirungwa i kaninba, i nomanin suna si kiruul sikire, pire gi di tekinwa. Iru paangwa ena ibalin kobe goma namua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ka ta di bile dirala ena i piro. Gariba kobaan ta, girepe kan milin yaalere, gul sirere girepe milin niriin duu yerala dire, mawl ta woomua. Yalini komina gul i kenin ere milama dire ogu ta kiire, yal taw kobe tere, ‘I kenin ere mile milin taw i nenangire, na taw nerabinwa,’ di tongwa. Di tere pi gariba baan ta tayan ki pai milemua. ");
INSERT INTO gvf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Milin bol yongwa kaun, gariba kobaan milin taw irala dire, nil erari yal kobe nusi erungure omua. ");
INSERT INTO gvf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kenin erungwa ibal kobe, nil erari yal kobe aa gi di milere, ta kuba sire, ta si gulere, ta kobile kuba simua. ");
INSERT INTO gvf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ena gariba kobaan nil erari yal taw binanbile kwi nusi erungure, goma erungwa mere kwi eremua. ");
INSERT INTO gvf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Eme wan nusi erere iru pirungwa, ‘Yalin kobe na wanan aa te wai ere tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nusi erimba wan ungwa kanere, diria ere iru dungwa, ‘Gariba kobaan wan kominin milungwa, nen kulgal bona muru inamua. Na yal kobe yalini si gulabinga, ena kal para irabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dire yalini aa gi dire pusi girepe kan gul mena ere, si gulemua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dire Yesu sirin bile tongwa, “Eno, girepe kan gul kobaan unangwa, takal ere kenin erungwa yal kobe tename?” ");
INSERT INTO gvf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dungure yalin kobe iru maan di tongwa, “Gariba kobaan ki erungwa yal kobe kirara si gulere, girepe kan gul yal taw tenangure, ena milin bol yongwa kaun milin taw kobaan tobe tenamua.” ");
INSERT INTO gvf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dire iru di tongwa, “Ka main ka minin ganin baan ta iru bilungwa i kere pirekeno? Piringi ena i piro. ‘Ibal ogu kiingwa, eri ta piserungwa eri ire i pi biriin wen mina yomua. God Singaba kal iru erungure, na ibal kobe kane buul wen kunebinwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ena iru paangwa ka di terala i piro. God kenin ere ke milungwa mere ta nekenangure, ibal taw kobe nere God konagi eramua. ");
INSERT INTO gvf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te yal ta eri iray kaun si wabe sungure kol gaul sinangwa, ena suna si darual dinangure gulamua. Te eri iray yuu di ime ure yal ta si diri dinangwa, ena suna kinin kale gulamua.” ");
INSERT INTO gvf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yuda ka main kenin erungwa yal bil kobe te Parasi kobe, “Yesu di bile dungwa mere kanin di na tomua,” di pirere, kanin sirala di eramba, ibal binanbile u ku bilungwa mile, “Yesu ka kebe yal milemua,” dungure yalin kobe kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","(-) ");
INSERT INTO gvf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ena Yesu kwi di bile dire iru di ibal kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yal bil ta abal gibilin si wan tere komina bil tongwa mere, God kenin ere ke milungwa iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yal bil nil erari yal kobe nusi erere iru di tongwa, ‘Goma wo, di tobinga ibal iray, ena malia wo, di to.’ Pi di tomba ibalin kobe urala pirekemua. ");
INSERT INTO gvf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pirekemia ena nil erari yal taw, ka kebe yere iru di tongwa, ‘Goma wo, di tobinga iray ibal i iru di to. Komina bil ki terabinga aa tekun erere, bulimakaw te bulimakaw kumil kwi kuulin bilungwa kaya sirere, kalkan para aa tekun ere yobinga ena komina bil nenama di tobinga ibal iray, kaya ere wo dana po.’ ");
INSERT INTO gvf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Di tongure ere pire di tomba, ‘Wo’ di tongwa ibal kobe pire unin sirere, pi den konagi ere milemua. Yal ta pi komina gul konagi erungure, te yal ta pi sitoa balungure, ");
INSERT INTO gvf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","te yal taw kobe nil erari yal kobe aa gi direre, kuba sire si gulemua. ");
INSERT INTO gvf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yal bil pirere den gulere simil nen nusi erungure, sungwa yal kobi si gulemua. Si gulere ogin si gale de taa eremua. ");
INSERT INTO gvf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yal bil iru erere, nil erari yal kobe ‘Ere wo,’ di gala dungure ungure, iru di tongwa, ‘Komina bil kaya aa tekun erebinba, ibal kobe ere wo, di tobinga nenangwa mere paikimua. ");
INSERT INTO gvf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ena i pi kombil pire, ibal kananga komina bil nenana wo, di to.’ ");
INSERT INTO gvf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Di tongure pi kombil pire ibal wai, te ibal digan milungwa para kanere, gure i ala erungure, ogu di dimua. ");
INSERT INTO gvf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Yal bil ibal milungwa kanala dire ogu ala pire, yal ta gal tongwa sigi dikire milungwa, kanemua. ");
INSERT INTO gvf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kanere iru sirin bile tongwa, ‘Ye nego, gal tobinga sigi dekere, ere ala unga iwe.’ Dimba yalini ka ta dekemua. ");
INSERT INTO gvf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dekungure, yal bil iru di nil erari yal kobe tongwa, ‘Aan kawn kan kole sire, nusi mena si bilungwa gul i erangire, koliba kol i yal kobi kay mun bile yaare miirere sigin gibi nuunamua.’” ");
INSERT INTO gvf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dire di wei sire iru dungwa, “Ibal binanbile ‘Ere wo,’ di gala dimba ibal tawliga paale suna ere imua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ena Parasi kobe pirere, Yesu ka dungwa paikungwa pire, kela kule bawle terala dire di paalungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Di paalere yalin kobe gawlima taw, te Kerodi gawlima kobe para, nusi Yesu milungwa gul erungwa. Erungure pi bawa dire iru di Yesu tongwa, “Ka nil si tongwa yalo, i morin kirara kawen dinga pirebinwa. God main paangwa mere nil si ibal tenga para pirebinwa. Ibal singaba taran i aa ki di tekire, ibal maangwa te yaangwa i nomanin taran si pirinwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ena i iru ere milingi pirere, ka sirin bile terabina main paangwa mere, nomanin si pire di na to. Kobile takis Orom yal bil Sisa terabinga, na yal kobe kile kaman ka main paangwa mere se keli sirabin mo, sekerabine?” ");
INSERT INTO gvf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dimba kela kule tongwa pirere iru di tongwa, “I ka di den miriin kaale tongwa yal iwe, tameran i na sua i kanine? ");
INSERT INTO gvf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kobile moni takis terabinga, ta ire yuungire na kanalwa.” Dungure ta yuungure kanere ");
INSERT INTO gvf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu iru di tongwa, “Kobile moni bolimina ibal milungwa, ibena guman mere kaan paame?” ");
INSERT INTO gvf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Di tongure yalin kobe, “Yal bil Sisa milemua,” dungure ena Yesu iru di tongwa, “Ena i para dina, Sisa kal dinangwa te inin baan ero. Te God kal dinangwa te inin baan ero.” ");
INSERT INTO gvf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iru dungure ibal pire buul kunere, Yesu milungwa gul pisere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ena kaun iray Sadusi kobe taw, Yesu milungwa gul ungwa. Yalin kobe, “Ibal gulere kwi alekinamua,” dire nil si te milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ure ka sirin bile iru di Yesu tongwa, “Ka nil si tongwa yalo, Mose nil si tere iru dungwa, ‘Yal ta abinbi yal temine mile gulangwa, gaan ta kwi yalini ain milama dire kebin abinbi ebinbi inamua,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dimba, ena kebin abin anan kole muru kole sutan goma na bole milebinwa. Abin, abal ta ire yal temine mile gulungure, kebin suna ta abal iray kwi imua. ");
INSERT INTO gvf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Irere yal temine mile gulungure, te kebin suna ta iray kwi ama abalini imua. Kebin imo milungwa kwi ama iru imua. ");
INSERT INTO gvf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kebin abin gulungure pare, ena abal iray para gulemua. ");
INSERT INTO gvf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kebin abin para abal iray ingwa, eme ibal gulungwa kwi alangwa, ibena ‘ebinbi miliwa,’ dire milame?” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dungure Yesu iru maan dire di tongwa, “Ka main minin ganin bilungwa, te God yobilaan pai tongwa para pirekingi, ena i ka pirekun ere dikinwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ibal gulere alangwa kaun, yal abal ta ikinangwa paamua. Angel kobe imore milungwa mere, ibal iru milamua. ");
INSERT INTO gvf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ibal gulere alangwa iru sirin bilinga, God ka di i tongwa i kere pirekeno? Piringi, ka iru paamia, ");
INSERT INTO gvf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ebarakam te Aisaka te Yakobo yalin kobe God, na miliwa.’ Dimia ena ibal gulungwa ibalin kobi God ta milekemba, ibal kwi milungwa ibalin kobi God milemua.” ");
INSERT INTO gvf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dungure ibal kobe ka dungwa i pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesu ka paangwa mere gi dire dimia, ena Sadusi kobe sime milungwa. Milungure Parasi kobe pirere u ku bilungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bilungure Yuda kile kaman ka nil si tongwa yal, yalin kobi suna milere, Yesu ka dungwa paikungwa pire, kela kule bawle tenama dire iru sirin bile tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ka nil si tongwa yalo, Mose kile kaman ka dungwa, ta ka wi yebe ome?” ");
INSERT INTO gvf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dungure Yesu iru di tongwa, “God i Singaba den miriin tere ibanin tere nomanin tere milangirawa. ");
INSERT INTO gvf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kile kaman ka wi yebe ongwa ka iru paamua. ");
INSERT INTO gvf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ka ta kwi u maribe ongwa iru. I inin nomanin tere gaynin kenin eringa mere, enin taw kobe nomanin para iru tenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ka sutan iwe, Mose kile kaman ka, te ka kebe yal nil si tongwa para ka dungwa i, ka sutan di i tobinga main paamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ena Parasi kobe u ku bilungwa Yesu sirin bile tere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“God konagi erungwa yal Kirisito milungwi pirere, takal waa dire kaan galine? Ibena gaan milema di pirine?” Dungure, “Debiti gawlin milemua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dungure Yesu iru di tongwa, “I iru dinba God Iban di Debiti tongure, Debiti mile, ‘Na Singaba milinwa,’ di Kirisito tere iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God Singaba iru di na Singaba tongwa, I ure na daanan wen kol amin di milo. Milingire i kaymin ibal yaa ime si tegire i egilana dire, iru ere teralwa.’ Dire tameran iru dime? ");
INSERT INTO gvf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Debiti inin, ‘Na Singaba milinwa,’ di tongwa, ‘Debiti gawlin iru tawle milemua,’ dinga tameran i ka iru dine? I dinga ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu sirin bile tongwa yal ta maan di tenamba, pire unin si milungwa. Ka ta kwi sirin bile Yesu tenamba, “Ka ta kwi diralga paikinamua,” di pire imore mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ena Yesu kwi ainere iru di ibal taminin te gawlima kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yuda ka main nil si tongwa yal kobe, te Parasi kobe bole, pi Mose kile kaman ka konagi erungwa ain omua. ");
INSERT INTO gvf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Omia ena Mose kile kaman ka di i tongwa mere, kuunin ere wiina ero. Iru eranba kal erungwa mere i iru ta erekio. Kile kaman ka di i tomba, inin wiina erekimua. ");
INSERT INTO gvf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yalin kobe kal obin dongwa kine ibal tomba, sinege ere aa ki di ibal kobe ta tekemua. ");
INSERT INTO gvf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kalkan erungwa iwe, ibal kobe para na wai milama di pire ere milemua. Yalin kobe ka main minin ganin piapa binanbile bilungwa dain bile maabinin mina, te aan kiibaan ale kan si ere warungwa, i kanina. Te galsuna araway sigi di warungwa, para kanina. ");
INSERT INTO gvf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Komina bil nongure, yalin kobe duul kaal kule aa te wai ere tongure milere, te ka main ogu ala pirere, singaba bol kaana amin di milemua. ");
INSERT INTO gvf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","U ku bilungwa gul ongure, ‘Singabo,’ di gala dire te ‘Nil si tongwa yalo,’ di tongure wai pire miinin maamua. ");
INSERT INTO gvf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Maamba i yal kobe ke kuunin milungure, te nil si i tongwa yal na taran wen milebinga, ena ‘Nil si tongwa yalo,’ di i tenangwa ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","‘Na Abe taran kamin mina milemua,’ dingi ena gariba gul yal ta, ‘Na abe,’ di tekio. ");
INSERT INTO gvf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","I yal kobe singaba taran wen, na God konagi erungwa yal Kirisito milebinga, ena ‘Singabo,’ di i tenangwa ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Milinga gul yal ta singaba milama di pirangwa, ena yalini nil konagi yal mile konagi ere gawlima kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yal ta mile, ‘Na yal singaba mile goma yerabina,’ di pirangwa u main nangwa paamba, yal ta mile, ‘Na yal digan mile u main nala,’ di pirangwa, singaba mile goma yenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Yuda ka main nil si tongwa yal kobe te Parasio, i miriin kaale tongwa yal milingiwe. God kenin ere ke milungwa ai sipere dire i ala pekire, te ibal ala nala di omba, i manaa di tenga ena gain giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yuda ka main nil si tongwa yal kobe te Parasio, i miriin kaale tongwa yal milingiwe. Abal weray kal yongwa i bawle tere girin di aa te nerere, ana baan araway dire ere miriin kaale tenwa. Iru tenga iwe, goma kal ki ere milinga giil pire tenamba, malia kal ki ere milinga i, giil bil pire i tenangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Yuda ka main nil si tongwa yal kobe te Parasio, i miriin kaale tongwa yal milingiwe. Ibal ta ibalin kobe ka main pisere, i inin ka main duulin bile warama di piringi, pire nega di warinwa. Ibal ta i, i duulin bile warangwa, ena i enderin gaul ai nanga mere ibal ta i kirara namua. Nangwa ena gain giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ibal awli enga yal kobo, omilin gi dungwa milingiwe. Ayo, i gain giil piranwa. Ka nil si tengi, i iru dinga, ‘Yal ta Yuda ka main ogu bil pire maabin mina sire, kal ta iru eralwa dinangwa, ka milin ta paikimua,’ dingiray. Dinba, ‘Ka main ogu bil ain yobilagi gol egin galungwa pire maabin mina sire, kal ta eralwa dinangwa, ena milin paamua,’ dingiray. ");
INSERT INTO gvf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Iru pirina, nomanin paikungwa ibal du milinwa. Ka main ogu bil kegemama yomba, ain yobilagi gol iwe, kalkan imore dimua. Dimba ain yobilagi gol ka main ogu egin gale tomia, ena ain yobilagi gol para kegemama yomua. Iru paangwa ena takal maa yebe ome? Ain yobilagi gol maa yebe om mo, ka main ogu bil maa yebe ome? ");
INSERT INTO gvf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ena i yal kobe para iru nil si tenga, ‘Ka main ogu bil ala kalkan God tongwa bol pire maabin mina sire, kal ta iru eralwa dinangwa, ka milin ta paikimua,’ dingiray. Dinba, ‘Bol iray kalkan i bolimina yongwa pire maabin mina sire, kal ta iru eralwa dinangwa, milin paamua,’ dingi. ");
INSERT INTO gvf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Iru pirina nomanin paikungwa yal milinwa. Ka main ogu bil bol iray kegemama yomba, kalkan tongwa iwe, kalkan imore dimua. Dimba kalkan God tere bol iray bolimina yomia, ena kalkan i para kegemama yomua. Iru paangwa ena takal maa yebe ome? Kalkan bol iray bolimina yongwa maa yebe om mo, bol iray maa yebe ome? ");
INSERT INTO gvf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ena yal ta bol iray pire maabin mina sire, ‘Iru eralwa,’ dinangwa, ena kalkan bolimina dungwa para pire maabin mina aa taw simua. ");
INSERT INTO gvf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te yal ta ka main ogu bil pire maabin mina sire, ‘Iru eralwa,’ dinangwa, ena God ogu alia pai milungwa para pire maabin mina aa taw simua. ");
INSERT INTO gvf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te yal ta kamin mina pire maabin mina aa taw sire, ‘Iru eralwa,’ dinangwa, ena God pai milungwa gul God inin milungwa bole para pire maabin mina aa taw simua. ");
INSERT INTO gvf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Yuda ka main nil si tongwa yal kobe te Parasio, miriin kaale tongwa yal milingiwe. Komina kaa kawi sinangwa kal i taw anan kole kole muru yere, taranta God tenwa. Kal i megemaaga mere tenba, kile kaman ka u maribe ongwa nomanin si ala ere wiina ere tekinwa. Kile kaman ka u maribe ongwa iru paamia. Ibal kenin ere tere, te miriin wen pire tere, te aa te wai ere tere, kal iru paangwa mere kuunin ere wiina ere tenanba, ka megemaaga iray para wiina ere tenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ibal awli enga yal kobo, omilin gi dungwa milingiwe. Kile kaman ka megemaaga wiina ere tenba, kile kaman ka bil iwe, pisere, wiina ere tekingi. Komina nenana dire ulgu komina si dangwa piserinba, bile yaangwa muru ne yugu dinga mere, kile kaman ka iru wen pire erinwa. Eringa gain giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Yuda ka main nil si tongwa yal kobo te Parasio, i miriin kaale tongwa yal milingiwe. I sin kabe te pele bala mena kol bigin singa mere, i gaynin bigin sinwa. Sinba kakiibi dire kunibe nere, nomanin gule daalin simua. Simia ena gain giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parasio, omilin gi dungwa yal milingiwe. Goma i nomanin suna bigin sinanga, ena gaynin para wai dirala eremua. ");
INSERT INTO gvf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Yuda ka main nil si tongwa yal kobo te Parasio, i miriin kaale tongwa yal milingiwe. Gal pege mere sigi di waringire, ibal mile wai wen milema di i kanimba, i nomanin suna gule daalin simua. ");
INSERT INTO gvf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ibal i kanere i kabin si wai wen milema di kanimba, i nomanin suna kakiibi dire, kal nigi dongwa taalime ere milinwa. Milinga ena gain giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Yuda ka main nil si tongwa yal kobo, te Parasio, i miriin kaale tongwa yal milingiwe. God ka kebe yal kobe gulungwa, kobile giraan ai wai dungwa ere yere, te kabin sire wai wen milungwa ibal kobe gulungwa, maul wo yere ogu wai ki tere ");
INSERT INTO gvf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ena iru dingi, ‘Na yal kobe kama kaya sanamoi gilekume milungwa kaun i milebinga, yalin kobe God ka kebe yal si gulungwa mere, ta si gulekirabinwa,’ iru di piringi. ");
INSERT INTO gvf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iru di pirina, ena God ka kebe yal sungwa ibal kobe, i yalin kobe gawlin milinga di maribe erinwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eringa, ena i sanamoi gilekume kal digan ere taalime erere pirin bil paangwa mere, malia i para iru erana po mo. ");
INSERT INTO gvf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","I oniba gawlin milinga mere ibal digan milinwa. God ibal para ka kol ere tenangwa kaun iwe. Na pirin ta paikire, enderin de paangwa ai pekerala di pirino? Pisere, ere nanwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","I iru erana ka di terala i piro. Ka kebe yal, te nomanin paangwa yal, te ka main nil si tongwa yal para iru nusi ere i terabinwa. Terabingire, taw ire si gulere, taw eri pera mina bili sirere, taw i ka main ogin ala kuba sirere, taw baan si kiranin bile sirere, ");
INSERT INTO gvf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","i iru ere yalin kobe tenanga ena kama kaya kabin sire wai wen milungwa ibal si gulungwa, God pirin pai i tenamua. Goma yal ta kaan Ebel si gulemia. Si gule ongwa ongwa eme Berekaya wan Sekaraya si gulungwa iwe. Ka main ogu bil malge pire ka main ogu bil iray, te kalkan God tongwa bol kalin sui i kole kole ere baan suna si gulemua. ");
INSERT INTO gvf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kama kaya si gulimba, ibal malia maalungwa pirin para wen pai i tenamua. Tenangure gain giil bil piramua. Na kawen di i teiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ayo, Yerusalem ibal we, Yerusalem ibal we, God ka kebe yal si gulere, ka main ibal nusi ere i tongwa para, kobile milin aa tere si gulinwa. Abal korale kain kel bile gawlin i ala erungwa mere, na Yerusalem ibal kobe para iru di u ku bilere irabinba, i girin dire manaa dinwa. ");
INSERT INTO gvf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dina ena u sutaw nangure ogin po dinamua. ");
INSERT INTO gvf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Maliaga i ibal kobe na kaninba, eme kwi na ta kanekinanwa. Kanekinanba i ibal kobe mile, ‘God ka dungwa kebe ere yuungwa, God miriin pai yal i tenamua,’ dinanga kaun i, na kwi kananwa. Di i teya ere gule piro,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ena Yesu Yuda ka main ogu bil u malge pire nala di ongure, gawlima kobe ure ogu mama wen kiingwa iray Yesu kanama dire guman bilungwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bilungure Yesu iru di tongwa, “Owa, ogu mama wen kiingwa kaninba, eme kobile si suule u inin inin pirere taminin sire taran ta dekenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu Olibe kamin kuul mabin amin di milungure, gawlima kobe inin u ku bile milere iru di tongwa, “I ka dingi iray genawna u maribe name? I gariba gul kwi ime unangire, te gariba gul wei sinangwa kaun takal goma u maribe nangwa kanabine?” ");
INSERT INTO gvf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dungure Yesu maan iru di tongwa, “Yal kobe ure kela kule dire bawle i tenamia, i nai kane milo. ");
INSERT INTO gvf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ibal binanbile ure na kaanan gale, ‘God konagi erungwa yal Kirisito miliwa,’ dire ibal miriki bawle i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ibal maala milungwa kura bilungwa kanere, te tayan para, ‘Kura bilemua,’ dinangure i pirere, te kal i piranga nomanin si gogo erekio. Kal iru pilau dinamba, kamin te gariba wei sinangwa kaun kaya u bawa dikinamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gariba baan ta ibal kobe pirere baan ta bole kura bilangure, te kenin ere ke milungwa yal bil te gawlima kobe bole pirere, yal bil ta bole kura bilamua. Gariba baan baan kenan bil gulungwa kaun u maribe nangure, te ememe pilau dinamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iru painamba gain giil pirangwa kaun, kawn kule u maala omua. ");
INSERT INTO gvf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ena i sinama dire, ibal kobe i awli pirere i si gulamua. I pire gi di na tenga, ibal para den gule i tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tenangure ena ibal kobe binanbile ka main piserere, ka main yal taw bale taal sire den gule tere, guman inin inin dinamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te kakiibi kobaan miriki u maribe pire, ‘Na God ka kebe yal miliwa,’ dire ibal kobe binanbile bawle tenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ibal kobe kal ki erungwa sidina di u bil namia, ena ibal miriki God nomanin tongwa i sutaw eramua. ");
INSERT INTO gvf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Eramba ibal kobe ka main aa gi di milangwal milangwa, ena God aa ki di ibalin kobi tenangure sigare kule u wai pi milamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","God kenin ere ke milungwa ka pore iray, gariba ulin kole kole pi kuunin biinangure ibal para kanangure, ena gariba gul para muru wei sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ena ka kebe yal ta Daniel goma ka dungwa mere iru dimia, ‘Kalkan main nigi wen dongwa, God ka main ogu bil si kunaal sire nigi denamua.’ Ka dungwa i ibal kerungwa ere gule piro. Kaun ta iru u maribe nangware, i kananga ");
INSERT INTO gvf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ena ibal Yudia milangwa si ere dimin gul nala eremua.’ ");
INSERT INTO gvf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ibal ogu malge mile kanangwa, kal ta irala dire, ogu ala ta pekenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ibal komina gul mile kanangwa, kwi sinaa di pi gal ogu ala yongwa, irala di pekenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Abal gaan paangwa te gaan amin ne milungwa iwe, eke, miriin pirie. ");
INSERT INTO gvf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","I si ere nanga, ‘Nimin sinangwa kaun mo Sare kaun, u maribe pi na tekio,’ i iru ana di God to. ");
INSERT INTO gvf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iru tenanga main iwe, goma God gariba ere yongure pare, eme ibal kobe gain giil pire mili ongwa ongwa omba, kamin kaun i giil bilkaw wen piramua. Giil pirangwa kaun iray, eme giil pirangwa kwi u maribe pekenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","‘Kamin kaun i baan araway ta dekere, are kawn taw se keli siralwa,’ dire God iru piremua. Se keli ta sekenangwa ena ibal para kwi ta milekenamua. Paale suna ere ingwa yalin kobe, God yalin kobi miriin pire tongwa ena pirangwa kaun i, kaun taw se keli sirala di piremua. ");
INSERT INTO gvf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ena yal ta iru dinangwa, ‘Kirisito maala milemia, kano,’ mo ta iru dinangwa, ‘Kirisito baan ta milemia kano,’ iru dinangware i pire tekio. ");
INSERT INTO gvf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaun iray kakiibi kobaan taw ure, ‘Na Kirisito miliwa,’ dinangure te kakiibi kobaan taw mile, ‘Na God ka kebe yal miliwa,’ dire u maribe namua. Pirere kal guman kwi dungwa erere, te kal main main ama erangwa, ibal kane buul kunamua. Kunangure God paale suna ere ingwa yalin kobe para kakiibi di tere kela kule terala dire, eramba. ");
INSERT INTO gvf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kal i u maribe namba ole pikungure, kaya di i tobinga, i yal kobe pire milo. ");
INSERT INTO gvf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ena ibal kobe mile, ‘Kirisito gariba simi yongwa milemia kano,’ dinangwa i kanana pikio. Mo ibal taw kobe mile, ‘Kirisito kiile ala aal kule milemia kano,’ dinangwa i ka dungwa i pirekio. ");
INSERT INTO gvf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kamin nege erungwa, gin taran kobil kuman ongure ibal para kanungwa mere, Na U Ibal Obinga Yal iru mere uralwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kabe ta gule dungwa, sibayaa binanbile u mo gere mile mile yaa main si i pi nerala dire urala eremua. Erungwa mere na para iru urabinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ena kaun iray kura taalime giil pirungwa wei sinangure pare, are si bilangure te ba aw dungwa para, wei sinamua. Kulmama kobi ule di yaanangure te kamin mina kal kobe niminin milungwa, si suule u sutaw namua. ");
INSERT INTO gvf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nangure ena Na U Ibal Obinga Yal unama dire, kamin mina kalkan u maribe namua. Nangure, ibal gariba baan ta baan ta gariba kobe muru, kuril di kane pire unin si mile, Na U Ibal Obinga Yal God yobilaan bil pai na tenangure niminin wen mile, te naabilungwa bole kawa bolimina urabinga, ibalin kobe na kanamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kamin mina bu bil wen dinangwa kaun, paale suna ere ingwa yalin kobe geril bomai kobil kuman gariba ulin kole kole milungwa, awli i ku bilama dire, angel kobe nusi eralwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Eri akola maangwa mere nomanin si pire main piro. Akola kaalangure, arin sinangwa kaun u maala ongwa i pirinwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Piringa mere iru, kalkan kobe goma u maribe nangwa di i tobingire i kananga ena na urabinga kaun u maala wen umia di kananwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na kawen dirala i piro. Kamin kaun malia ibal maalungwa kaya ta gulekinangure, kalkan kobi di tobingire u maribe nangure pare kanere, eme gulamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kamin te gariba wei sinamba, na ka dibinga wei ta sikire di painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kal iru u maribe nangwa kaun iwe, ibal kobe ta pire pol sekimia. Angel kobe kamin ai milungwa para, ta pire pol sekimia. God Wan na para, ta pire pol sikiwa. Pire pol sekimba, na Abe taran wen pire pol simua. ");
INSERT INTO gvf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yal Noa goma milungwa kaun, ibal kobe kalkan erungwa mere, Na U Ibal Obinga Yal uralga kaun, ibal kobe para iru eramua. ");
INSERT INTO gvf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ena kaun iray, nimin bilkaw wen sirala di erungure ibal komina nere, nil nere, abal irere, mile i pirere Noa sipe pi ala milemua. ");
INSERT INTO gvf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Milimba kal ta u maribe nama di ibal kobe pirekungure, ena nimin sire, nil sire, ibal para si gule wei simua. Iru erungwa mere iwe, Na U Ibal Obinga Yal uralga kaun para iru eramua. ");
INSERT INTO gvf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ena kaun iray, yal sutan komina gul konagi ere milangure, God yal ta awli nangure yal ta imo milamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Abal sutan bole komina kiirala di aa tekun ere milangure, God abal ta awli nangure abal ta imo milamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iru erangwa paamia pirere, te i Kobaan unangwa kaun pire pol sekina pirere, kanekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kunibe inangwa yal unangwa kaun, ogu kobaan pire pol sinamia, ena yalini el kwi nu milangure kunibe inangwa yal ogu ala pekenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iru eramia pire i yal kobe aa tekun ere kanekun ere milo. Na U Ibal Obinga Yal na ta wekenama di piringa kaun i, urala eria, i ibal kobe aa tekun ere, kanekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yal singaba nil konagi yal pi tegi yongure nil konagi yal i nomanin paangwa iwe. Nil konagi ibal kobe kenin ere mile kamin kaun kaun komina obin si tenama dire, singaba nil konagi yal ta paale suna ere irere, ere omua. ");
INSERT INTO gvf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yalini sinaa dire kwi unangwa iwe, nil konagi kenin erungwa yal, singaba wiina pai tenangwa singaba ure kanamia, ena nil konagi kenin erungwa yal miriin painamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ena singaba wai wen pire kulgal bona muru, nil konagi yal iray kenin erama dire, konagi iru tenama di, di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Iru painamba nil konagi yal kal ki ere mile, ‘Na singaba baan araway mile kwi wekenamua,’ ");
INSERT INTO gvf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dire iru di piramia ena nil konagi enin kobe kuba sire, nil bia nere nere omilin maalungwa, yalin kobe bole komina te nil nenamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ena nil konagi yal mile singaba kaun ta wekenama di pirere, te singaba unangwa kaun pire pol sikinamba, kaun ta iray kobaan unamua. ");
INSERT INTO gvf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Urere nil konagi yal iray si wei sirere, pusi miriin kaale tongwa yal kobe milungwa gul erangure, kay mun bile yaare miirere sigin gibin nuunamua,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ena Yesu ainere iru dungwa, “Kamin kaun iray gi anan kole kole muru enderin derin gale, abal ingwa yal unangwa pi, ‘Aya maya,’ dire guman yenangwa mere, God kenin ere ke milungwa iru mere milamua. ");
INSERT INTO gvf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gi anan kole muru du dungwa milungure, te gi anan kole muru nomanin paangwa gi milemua. ");
INSERT INTO gvf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Du dungwa gi kobe enderin derin aa te ire omba, nil taw imo milangwa ire pekimua. ");
INSERT INTO gvf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Te nomanin paangwa gi kobe, mugu ta para nil suule ire omua. ");
INSERT INTO gvf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Gi kobe para pirere, abal irala di ongwa yal baan araway mile wekenama di pire, ul maure ena ul paamua. ");
INSERT INTO gvf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Paangure, gilaa taanima wen gala dire iru dungwa, ‘Abal ingwa yal kaya umia, kanana wo.’ Dungure ");
INSERT INTO gvf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","gi kobe sigagu di alere, enderin derin galala dire aa tekun eremia. ");
INSERT INTO gvf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Erimba, du dungwa gi kobe ka iru di nomanin paangwa gi kobe tongwa, ‘Na enderin derin gaarala eremia, nil taw na to.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dimba nomanin paangwa gi kobe maan iru di tongwa, ‘I terabinba na enderin derin para u di gaanamia, ena i inin pi sitoa pire gibilin sinana po.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Iru di tongure ena gibilin sirala di omua. Pi milungure, abal ingwa yal kaya u bawa dimua. Aa tekun erungwa gi kobe, abal ingwa yal bole ala pire kol yaalere, komina bil nere milemua. ");
INSERT INTO gvf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Milungure eme gi taw kobe ure gala dire iru dungwa, ‘Singabo, singabo, i kol yawle na tom mo.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dimba yalini iru di tongwa, ‘I gi kobi gumanin na ta kanekibingirawa,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Di bile diga main paangwa iwe, na kwi urabinga kaun pire pol sikinga i kanekun ere milo.” ");
INSERT INTO gvf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ka pore ta di i terabinga mere, na kwi urabinga kaun main iru painangwa iwe. Yal ta gariba ta pisere baan ta nala di pirere, nil konagi yal kobe ‘Wo,’ di gala dire, ‘Na garibanan i kenin ero,’ di tomua. ");
INSERT INTO gvf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Di tere kalkan wai kenin erungwa mere obin si tomua. Yal ta, kina tausen anan kole muru tere, yal ta kina tausen sutan tere, te yal ta kina tausen taranta tere, ena ain pisere ere baan ta omua. ");
INSERT INTO gvf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nil konagi yal kina tausen anan kole muru irere pi kobile moni konagi erere, ena kina tausen anan kole muru ama, taw kora kule imua. ");
INSERT INTO gvf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ena nil konagi yal kina tausen sutan irere ama iru erere, ena kina tausen sutan ama, taw kora kule imua. ");
INSERT INTO gvf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yal sui iru erimba, nil konagi yal kina tausen taranta irere, maul ta woore, yalini kobaan kobile moni pusi maul ali ere kobe simua. ");
INSERT INTO gvf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ena nil konagi yal kobe kobaan baan araway mile kwi ere ain urere, kobile moni kwi na tenama dire aa tekun erala di umua. ");
INSERT INTO gvf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ungure nil konagi yal kina tausen anan kole muru ingwa urere, kobile moni ama kora kule ingwa tere iru dungwa, ‘Singabo, kina tausen anan kole muru na tenba, kobile moni konagi erere kina anan kole muru ama kora kule iga para i teiwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dungure yalini kobaan yal iru di tongwa, ‘Kal para erinwa. Nil konagi yal wai mile wiina pai tere milinwa. Kalkan tawliga kenin eringa paimia, ena kalkan binanbile kenin erana dire, konagi i terabinwa. I ure na bole pena gale miriin paire gun yerabilwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Dungure nil konagi yal kina tausen sutan ingwa yal ure iru dungwa, ‘Singabo, kina tausen sutan na tenba, kobile moni konagi erere kina tausen sutan ama kora kule iga, para i teiwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dungure yalini kobaan yal iru di tongwa, ‘Kal para erinwa. Nil konagi yal wai mile wiina pai tere milinwa. Kalkan tawliga kenin eringa paimia, ena kalkan binanbile kenin erana dire konagi i terabinwa. I ure na bole pena gale miriin paire gun yerabilwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Dungure, ena nil konagi yal kina tausen taranta ingwa yal ure iru dungwa, ‘I yal naanin painga pirebinwa, te pirin pai i tekungwa ibal kalkan i tongure inga, kanebinwa. ");
INSERT INTO gvf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kanebinga kuril pire, kobile moni pusi maul ali ere kobe sibinwa. Kano, i na tenga mere kuunin maan i teiwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dimba kobaan maan iru di tongwa, ‘Nil konagi yal kal ki ere, sinege eringa milinwa. Pirin pai na tongwa ibal kalkan na tongure ibinga, i kaninba. ");
INSERT INTO gvf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kaninga, tameran na kobile moni ben ala yekine? Eranga ena na kobile moni te ben tawlita maa yebe nangwa, para biinamia irabinba. Malia ubinga irabinba. ");
INSERT INTO gvf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yalini iru ere na tomia ena kina tausen taranta aa tongwa ire, kina tausen anan kole muru aa tongwa yal to. ");
INSERT INTO gvf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yal ta kalkan binanbile kenin ere milungure taw ama tenangure irere, binanbile aa te nenamua. Te yal ta kalkan tawle kenin erekungwa ta tekenangure, kal tawle dungwa yal ta tawal di inamua. ");
INSERT INTO gvf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ena nil konagi yal digan iwe, nusi mena wen si bilungwa gul i ero. Erangure koliba kol i yal kobi kay mun bile yaare miirere, sigin gibin nuunamua.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ena Na U Ibal Obinga Yal naabilungwa, te angel kobe para muru bole urabinga, ena gariba kenin erungwa ai pi milabinwa. ");
INSERT INTO gvf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gariba ibal muru na miliga gul u ku bilangure, ibal bolima siipe siipe te bolima meme obin sungwa mere, ibal iru obin sirabinwa. ");
INSERT INTO gvf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na anan wen kol ibal bolima siipe siipe milungwa mere kola milamia, te anan kora kol ibal bolima meme milungwa mere kole milamua. ");
INSERT INTO gvf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ena kenin erungwa yal bil iru di ibal anan wen kol milungwa teralga, ‘I ibalin kobe, na Abe miriin pai i tongwa, na miliga gul ere wo. God kenin ere ke milungwa ain i ala unanga, kama kaya wen gariba main ere yongwa aa te wai ere i tongwa i nenana dire, ere ala wo. ");
INSERT INTO gvf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na kenan gule miliga, i komina na tengiray. Na nil guliga, i nil kule na tengiray. Na baan ta ibal miliga i na bole ka diduwaire ire milebilgiray. ");
INSERT INTO gvf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na yorawan bole miliga i gal pire na tengiray. Na nibil ere miliga i na kenin ere milingiray. Na kanin pai miliga i ure ka wai di na tengiray.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dirabinga, ena kabin sire wai wen milungwa ibal kobe maan iru di tenangwa, ‘Singabo, i kenan gule milinga komina tere, mo nil gulinga nil kule i tobinga, genawna kal iru ere i tobine? ");
INSERT INTO gvf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Te i baan ta ibal milinga na i bole ka diduwaire milebinga, mo i yorawan bole milinga gal pire i tobinga, genawna kal iru ere i tobine? ");
INSERT INTO gvf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Te i nibil ere te kanin pai milinga kenin ere i tobinga, genawna kal iru ere i tobine?’ ");
INSERT INTO gvf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dinangure yal bil maan iru di terabinga, ‘Na kawen di terala i piro. Kalkan kan dibinga i na ibalan kobe digan milungwa ere tenga mere, i iru ere na tenwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ena ibal na anan kora kol milangwa iru di teralga, ‘God kal digan ere i tenga i ere baan ta po. Satan te yalini ka kebe ibal kobe, enderin de painangwal painangwa ai nangwa, i para po. ");
INSERT INTO gvf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na kenan gule miliiba, i komina na tekingirawa. Te na nil guliiba, nil kule na tekingirawa. ");
INSERT INTO gvf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na baan ta yal miliiba, i bole ka diduwaire milekebilgirawa. Te yorawan bole miliiba, i gal pire na tekingirawa. Te na nibil erere te kanin pai miliiba, i kenin ere na tekingirawa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dirabingire ena yalin kobe iru maan di na tenangwa, ‘Singabo, i kenan gulere, nil gulere, baan ta ibal milere, yorawan bole milere, nibil ere milere, kanin pai milere, i kal iru ere milinga iray, genawna na ibal kobe i aa te wai ere tekebine?’ ");
INSERT INTO gvf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na yal bil milia maan iru di i teralga, ‘Na kawen di terala i piro. Na ibalan kobe digan milungwa, i aa te wai ere tekinga mere, i iru aa te wai ere na tekinwa.’ ");
INSERT INTO gvf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iru dirabingire ena yalin kobe giil bilkaw wen pire milangwal milamba, kabin sire wai wen milungwa ibal kobe, mile painangwal painamua,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ena Yesu ka nil si tongwa i, para wen di wei sire, iru di gawlima kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Are kaun sutan wei sinangwa ena Yuda nen bolima siipe siipe sungure, God yalin kobe ta sekungwa kaun erin bil mile, komina bil nerabinwa. Nerabingire ibal kobe Na U Ibal Obinga Yal na kanin sire, eri pera mina na si gulama dire, awli ibal tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ena ka main kenin erungwa yal bil kobe te Yuda ka main yal singaba kobe bole, u ku bile kenin erungwa yal bil kaan Kayapas, ogin milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Milere Yesu aal kule kanin sire si gulabina dire, diria ere pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pirimba iru dungwa, “Komina bil kiire erin kaun milungure Yesu kanin sirabinba ibal kobe kura bil bile wi yau dinamua,” dire kane unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu Betani ai pire Saimon goma seki egile milungwa, malia gain wiige sungure milungwa, Yesu yalini ogin ala milungure, ");
INSERT INTO gvf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","abal ta ure wel niriin minanin wai wen sungwa tobe bil bilungwa, mugu dil ali yuure Yesu komina ne milungwa, garu di Yesu gibilin mina bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tongure gawlima kobe kanere nigi de wen pirere, iru di tongwa, “Tameran imore garu di bile tome? ");
INSERT INTO gvf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wel niriin i tobe bilkaw bilungwa, irabinga kul gal bona aa te nekungwa ibal obin si terabinba.” ");
INSERT INTO gvf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dungwa i, Yesu pirere iru di tongwa, “Tameran nigi de pire tene? Abalini kal wai wen ere na tomua. ");
INSERT INTO gvf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kul gal bona aa te nekungwa ibal, i bole para morin milamba, na i ibal kobe bole baan araway ta milekerabilwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na gulabinga wel i bile na tenangwa mere, malia kwi imo miliga wel niriin iray bile na tomua. ");
INSERT INTO gvf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na kawen di i terala i piro. Na guunan kanan gariba ulin kole kole kere di tenangwa gul, abalini kalkan erungwa di maribe erangure, ibal kobe abalini wai pire tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ena Yesu gawlima kobe anan kole kole muru kawnan milin sutan yal ta kaan Yudas Isikerio, pi Yuda ka main kenin erungwa yal bil kobe milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Pirere iru dungwa, “Yesu i anin mina u maribe nalga takal na tenane?” Dungure kobile moni milin aan kawn muru te anan kole kole muru yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ena kaun iray, Yesu bale taal sirala dire kawn kule, kaun ta suul mile kane milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Komina bil ta, komina birete u bil pekungwa nere milungwa kaun, kamin kaun ta kawn kule erungure, gawlima kobe ure iru sirin bile Yesu tongwa, “God Yuda nen kobe ta sekungwa kaun nomanin si pirabina dire, komina nerabinga alde aa tekun ere nerabine?” ");
INSERT INTO gvf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Di tongure iru dungwa, “I ogu ai bil pirere yal ta iray kananga iru di to, ‘Ka nil si tongwa yal iru dimua,’ da. ‘Na gulabinga kaun u bawa dungure, na te gawlimanan kobe para God Yuda nen kobe ta sekungwa kaun nomanin si pirabina dire, komina i, i ogin ala nerabinwa,’ iru di ta.” ");
INSERT INTO gvf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dungwa mere erere, komina bil iray nenangwa aa tekun erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ena kamin girungure pare, Yesu te gawlima kobe anan kole kole muru kawnan milin sutan bole, komina nerabina dire amin di milunga. ");
INSERT INTO gvf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yal kobe komina ne milungure Yesu iru dungwa, “Yal ta u alia milere na bale taal sinamua.” ");
INSERT INTO gvf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dungure yalin kobe nigi de pire, inin inin iru sirin bile Yesu tongwa, “Singabo, na i sirabin mo, sekerala di piria.” ");
INSERT INTO gvf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Dungure Yesu di tongwa, “Yal ta i suna milungwa, yalini na bole pele bala taran komina nil bile nobinga, ena yalini na bale taal sinamua. ");
INSERT INTO gvf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka main minin ganin bilungwa mere Na U Ibal Obinga Yal u baan ta nalwa. Nabinba yal ta Na U Ibal Obinga Yal bale taal sinangwa yal iwe, aye, giil bil piramua. Man yal iray ta kule yekenangwa, wai wen milamba.” ");
INSERT INTO gvf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dungure bale taal sinangwa yal Yudas iru di tongwa, “Nil si tongwa yalo, na i sirabin mo, sekerala di piria.” Dungure Yesu mile, “I iru dinwa,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ena yal kobe komina nere milungwa, Yesu komina birete aa tere maki ye God tere, bege dire obin si yal kobe tere, iru dungwa, “Komina i, na miin te gaynan dimia, ire no.” ");
INSERT INTO gvf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dire pare nil wain sin kabe ta ire, maki ye God tere, suule obin si yal kobe tere iru dungwa, “I yal kobe para, nil i no. ");
INSERT INTO gvf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ibal kobe binanbile God bole guman kane ire u taran nama dire, na inan mayan garu diralwa. Te ibal kal digan ere taalime erungwa kire di erama dire, na inan mayan garu diralwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na kawen dirala i piro. Malia na nil wain nega mere, iru ta ama nekeralba, God kenin ere ke milungwa ai pi milalga eme kwi neralwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dire geril ta di pisere ere malge pire, kamin kuul Olibe ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ena Yesu iru di gawlima kobe tongwa, “Gilaa kaun i, i yal kobe nigi de pire na tere us sutaw nanwa. God mile, ‘Na bolima siipe siipe kenin erungwa yal sirabingire, bolima siipe siipe u sutaw namua,’ dungure ka main minin ganin iru bilungwa mere, u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Iru dinamba, na gulere alalga God iru erangure pare, na Galili gariba gul goma egire i eme unanwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dungure Pita ka dagi dire iru dungwa, “Yalin kobe nigi de pire i tere u sutaw namba, na iru ta pire i tekeralwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dungure Yesu iru di tongwa, “Na kawen i inin di terala piro. Kemina gilaa sia korale be dala di erangwa, i ginin sutakobe na kaanan di aal kule ka di kile di mena ere na tenanwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dungure Pita maan iru di tongwa, “I kaanin di aal kule i teralga, main iru ta paikimua. Iru tekiralga ibal kobe na i bole na si gulangwa, ena para wai we. I ka di kile di mena ere i tekeralwa.” Dungure gawlima kobe para iru di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ena Yesu te gawlima kobe bole pi eri main ta kaan Gesemani ongure, Yesu iru di tongwa, “Na ana di God terala erebina, i alia amin di milo.” ");
INSERT INTO gvf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Direre Pita te Sebedi wan sutan awli pirere, suna ku ku maa ungure miriin pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Milere iru di yal sutakobe tongwa, “Na inan miriin bilkaw pire milere, gulalga mere piriwa. I abila mile el kwi nu milo.” ");
INSERT INTO gvf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Direre baan ta pi bawa dire, yaa i kwi bile ana dire iru dungwa, “Na Abe, giil malia na piralga, pirekerala di pire iru ere na tenanba, painama di pirangire, ena giil piralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dire pare urere, yal sutakobe ul paingwa kanere ulin yuure iru di Pita tongwa, “I yal kobe kaun tawliga kwi milekeno? ");
INSERT INTO gvf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Satan i kiranin sire kela kule tenangure i manaa dirala dire, i ul paikire si kwi ye mile ana morin di God te milo. I nomanin iru si piringa, ‘Na yobilaan biliga eralwa,’ di pirinba gain obin domua.” ");
INSERT INTO gvf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Direre ginin ta kwi pire ana dire iru dungwa, “Na Abe, ena giil malia piralga i painama di piranga, giil piralwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Dire pare sinaa dire kwi ure, yal sutakobe omilin meru dimia ul paingwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kanere goma ginin sutan ongwa, malia kwi pire, ana goma dungwa mere kwi dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dire pare gawlima kobe sutakobe milungwa gul ure, iru di tongwa, “I yal kobe ul painga iray kwi paino? Ena i iru piro. Na U Ibal Obinga Yal, yal ta bale taal sinangure kal digan ere taalime erungwa, yalin kobe na sinangwa kaun u maala omua. ");
INSERT INTO gvf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ale, ere nabina wo. Bale taal na sinangwa yal kaya maala umia, kano,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ena ka iru di milungure, ena gawlima kobe anan kole kole muru kawnan milin sutan, yal ta kaan Yudas te ibal binanbile para, kuba te di kuba pera aa te ire u milungwa. Yuda ka main kenin erungwa yal bil kobe te singaba kobe, nusi erungwa u milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bale taal sungwa yal goma iru di ibal kobe tongwa, “Yal ta guman mu diralga, yalini yal iray milamua. Iru kane aa gi di mile kanin so.” ");
INSERT INTO gvf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dire u bawa dire gin taran Yesu milungwa gul pire, “Singabo, mile dino,” dire guman mu dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dungure Yesu iru di tongwa, “Ye nego, kal ta erala di eranga kal iray ero.” Dungure ure aan aa gi dire kanin sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yal ta Yesu bole milungwa di kuba pera i maribe ere, Yuda kenin erungwa yal bil yalini nil konagi yal ta, kiraan dual kule erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Erungure Yesu iru di yal ta iray tongwa, “I di kuba pera kwi gal gule ain yeyo. Yal ta di kuba pera aa te ibal sungure, ena ibal kobe yal iray, di kuba pera si gulangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na Abe gala di teralga ena yalini gin taran angel taminin anan kole kole muru kawnan milin sutan, aa ki di na tenangwa nusi eramua. ");
INSERT INTO gvf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Eramba, ‘Iru wen painamua,’ di ka main minin ganin bilungwa mere, tamintan milin u maribe name? Angel kobi nusi erangwa ta pekenamia, ena milin kawen u maribe namua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dire pare Yesu iru di u ku bilungwa ibal tongwa, “I di kuba pera te kuba ire unga, komina kunibe nongwa mere iru kuunin ta milebinga, kanin na kulala dire uno? Yuda ibal ka main ogu bil, kaun kaun ka nil si te milebinga, na kanin ta sikingirawa. ");
INSERT INTO gvf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ka kebe yal kobe ka main minin ganin bilungwa mere, kalkan iru ere milin u maribe omua.” Dungure gawlima kobe para yalini pisere si ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yal kobe Yesu kanin si milere, Yesu awli pi Yuda ka main kenin erungwa yal bil kaan Kayapas milungwa gul ongwa. Ongure Yuda ka main nil si tongwa yal kobe, te singaba kobe para, u ku bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Milungure, Pita tawliga tayan mile duulin bile pire, kenin erungwa yal bil ogin malge pi bawa dire, ere suna ongwa. Pirere kalkan u maribe nangwa kanala dire, el kwi nu milungwa yal i bole amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ka main kenin erungwa yal bil kobe te u ku bilungwa ibal para muru, Yesu si gulala dire ka digwane waa Yesu tenangwa, ka i waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Waa duumba ka ta i maribe erekungwa. Dimba ka kol kanungwa ibal binanbile ure, “Kakiibi dirabina,” di pirungwa. Ena ka kol kanungwa ibal su ure ");
INSERT INTO gvf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","iru dungwa, “‘God ka main ogu bil ibal kiingwa sulalwa. Sulere pare kaun sutakobe na inan kwi kiiralwa,’ dire Yesu iru dungwa na yalsu pirebilwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dungure Yuda ka main kenin erungwa yal bil alere iru di Yesu tongwa, “I maan ka ta piranga ta dekino? Ka kol kanungwa yal kobe di maribe erungwa tamintan mere dime?” ");
INSERT INTO gvf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iru sirin bilimba, Yesu pire unin si milungwa. Ka main kenin erungwa yal bil, kwi dire iru di tongwa, “God kwi mile paangwal paangwa, i pire maabinin mina aa taw sire i kirara kawen di na to. I God konagi erungwa yal Kirisito milino? Te i God Wan milin mo, milekene?” ");
INSERT INTO gvf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dungure Yesu maan iru di tongwa, “I iru dingiwe. Dinba ka di i ibal kobe terala i piro. Malia miliga i kaninba, eme Na U Ibal Obinga Yal, God Yobilaan wen Kobaan aan wen kol amin di miliga kanere, te kawa bolimina urabinga para kananwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dungure ena kenin erungwa yal bil iray, galsuna aa te ole dire iru dungwa, “Yalini God gain ka simua. Ka kol kanungwa yalin kobe tameran ka kwi diname? Yalini gain ka sungwa pirere, ");
INSERT INTO gvf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","i takal waa di nomanin si pirine?” Dungure yalin kobe maan dire iru dungwa, “Yalini kal ki ere pirin paamia, ena si gulo.” ");
INSERT INTO gvf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ena yal taw kobe ebil sipadi, Yesu guman mina tere sire, te ibal taw de dagi sire ");
INSERT INTO gvf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","iru dungwa, “God konagi erungwa yal Kirisito, ka kebe yal dungwa mere bolin kule di maribe ero. Ibena i sime?” ");
INSERT INTO gvf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ena Pita malge yene i milungure, kenin erungwa yal bil nil konagi gi ta urere iru di tongwa, “Yesu Nasarete nen milungware i bole para milingirawa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dimba ibal para milungwa mina, Pita ka di kile di mena ere iru dungwa, “I ka dingi na ta pirekun erekiwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dire ogu malge yene kana giran ta ongure, nil konagi gi ta mile, iru di yal kobe tongwa, “Yalini Nasarete nen Yesu bole milungwa yal milemua.” ");
INSERT INTO gvf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dungure Pita kwi ama ka di kile di mena ere, maabin mina aa taw sire iru dungwa, “Yalini guman na kawen kirara ta kanekiwa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dungure kawn tawliga mile pare, yal kobe maala milere iru di Pita tongwa, “Yesu gawlima kobe kowa kowa dungwa mere i para iru dingi, ena i yal ta milingirawa.” ");
INSERT INTO gvf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dungure Pita ka nigi dongwa dire iru dungwa, “God mabin mina kawen di tekerala God na sinangwa paamua. Yalini i kane dinga, na guman ta kanekigirawa.” Dungure sia korale gin taran be dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","“Sia korale be dala di pirangwa, i ginin sutakobe na kaanan di aal kule ka di kile di mena ere na tenanwa,” dire Yesu goma iru di Pita tongwa, nomanin si pirere, Pita mena pire kay mun bile yaare simil kay miingwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ena kwimile taanima u bawa dungure, Yuda kenin erungwa yal bil kobe te singaba kobe bole, Yesu si gulala dire ka diria ere iru di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Di pirere, Yesu aan kan kule yerere awli pi Orom yal bil kaan Pailete milungwa gul tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bale taal sungwa yal Yudas, Yesu si gulama di pirere yalini nomanin suna si kiruul sire, kobile moni milin yal ta aan kawn muru anan kole kole muru aa te ire, kenin erungwa yal bil kobe te singaba kobe kwi terala di pire ");
INSERT INTO gvf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","iru di tongwa, “Kal ki erekungwa yal iray bale taal sibingiray, ibal kobe yalini si gulangwa paamia, ena na kal digan ere taalime erebinwa.” Dungure yalin kobe iru dungwa, “Na kanan ta paikimia, i inin kanin paimia.” ");
INSERT INTO gvf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dungure Yudas kobile moni pusi ka main ogu ala erere, ere mena pire inin kan kule gi di sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yalini iru erimba Yuda ka main kenin erungwa yal bil kobe, kobile moni sulu de erungwa gana di irere iru dungwa, “Ibal kanin galungwa kobile moni dungwa, ka main ogu bil kobile moni bole imu di teran ere yerabinba, Yuda kile kaman ka main se keli sirabinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dire diria ere mile nomanin taran yere, miine balungwa yal ta garibanin gibilin sire, baan ta ibal gulungwa yere, “Yobilagi gariba i yerabinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iru eremia ena gariba iray kaan Mayan Gariba yere, ena malia kaan para iru gale milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ena iru eremia, Yeremaya goma ka dungwa milin u maribe ongwa. Ka dungwa i iru dungwa, “Isirel nen kobe yal ta i tobe bilungwa mere, kobile moni milin aan kawn muru anan kole kole muru irere, ");
INSERT INTO gvf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","miine balungwa yal ta garibanin gibilin simua. God Singaba kile kaman dungwa mere iray erebinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ena Orom yal bil milungwa gul Yesu ale milungure, yalini iru sirin bile Yesu tongwa, “I Yuda ibal yal singaba bil milino?” Dungure Yesu mile, “I iru dinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dimba ka main kenin erungwa yal bil kobe te singaba kobe bole, ka digwane waa tongwa pire unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Milemia ena Pailete iru di tongwa, “Ka binanbile di mere si i tongwa pirekeno?” ");
INSERT INTO gvf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dimba pire unin si mile, Yesu ka ta maan kwi di tekungwa. Tekemia ena Pailete, “Aya,” dire buul wen kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Komina bil si gale nere milungwa kaun, Orom yal bil kanin paangwa yal ta morin morin kanin gule erungwa. U ku bilungwa ibal kobe, yal ta kaan gale, “Kanin gule ero,” dungwa gule erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ena kaun iray, kanin paangwa yal ta kaan Barabas mile, yalini guun kan warungwa kanin pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ibal binanbile u ku bilungwa, Pailete iru sirin bile tongwa, “Ibena kan gule ere terabine? Barabas kanin gule erabin mo, Yesu kaan ta Kirisito kanin gule erabine?” ");
INSERT INTO gvf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ibal kobe san bale Yesu tere awli pi gabman tongwa ena Pailete iru nomanin si pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ena Pailete ka kol pirungwa ogu ala amin di milungwa, ebinbi yal ta nusi ere, “Iru di to,” dungwa, “‘Kemina gilaa na ul kiibe kaniga, nomanin binanbile sungwa yalini kal ki erekungwa yal milemia ena kalkan ere tekere i imore milo,’ dire di to,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ka main kenin erungwa yal bil kobe te singaba kobe bole, u ku bilungwa ibal den ali baale woore iru di tongwa, “Barabas kanin gule ere, Yesu si gulo, di Pailete to,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Di tomba, Orom yal bil kwi iru di ibal kobe tongwa, “Yal sutan milungwa iray, ibena kan gule ere terabine?” Dungure, “Barabas kanin gule ero,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailete iru sirin bile tongwa, “Yal ta Yesu kaan ta Kirisito iwe, takal ere terabine?” Dungure, “Eri pera mina si gulo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dimba Pailete iru dungwa, “Tameran ka iru dine? Takal erungwa ki ereme?” Dungure pare ibal gala bil dire kwi iru dungwa, “Eri pera mina si gulo.” ");
INSERT INTO gvf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dimia ena Pailete ka dungwa kuunin paikima di pirere, te ibal kobe wi yau dire kura bilama di pirere, yalini nil kulere ibal binanbile u ku bilungwa guman mina aan bigin sire iru dungwa, “Yal ta iray si gulangwa na pirin ta paikimua. I ibal kobe inin konagi paimua.” ");
INSERT INTO gvf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dungure u ku bilungwa ibal para maan dire iru dungwa, “Yalini mayan garu dire gulangwa, na te gawlin kobe bole pirin painama dire iru erebinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dungure Barabas kanin gule ere tere, “Kuba galan yongwa Yesu gain mina so,” dungure, sire eri pera mina si gulala dire, simil nen awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ena Orom yal bil simil nen kobe Yesu awli yal bil ogin kaan Piretorium suna pirere, ena simil nen muru Yesu milungwa gul u ku bile i yobile suna erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yesu galsuna gule erere, yal bil gal sigi dungwa mere galsuna nobe mayan kuunin dungwa sigi di tere, ");
INSERT INTO gvf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kan galan yongwa galin ware gibilin mina kaw tere, koma kuba ta aan wen kol waa yere, yaa gobin bile mile ka di sutaw ere iru di tongwa, “Ayo, Yuda ibal kobe yal singaba bil wen iwe.” ");
INSERT INTO gvf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dire ebil si pa di tere, koma kuba ire gibilin mina sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ka di sutaw ere pisere, galsuna nobe mayan kuunin dungwa gule ere inin gal kwi sigi di tere, eri pera mina si gulala dire awli mena ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Awli pirere Sairini yal ta kaan Saimon kanere, “Eri pera kawi ire po,” di yalini tere sire anu sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yalin kobe gariba ta kaan Golgota u bawa dungwa. Gariba iray kaan iru main paangwa, ibal gibilin yobilaan ai mere dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ibal kobe wain nil irere, madasin ta gi kiingwa bole para nuure yalini tomba, yalini taw ne pirimba, gi erungure mawal ere nekungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ena yalin kobe Yesu aan kawn eri pera bolimina bili nil sirere, yalini gal obin si irala dire, sandu sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bili nil si piserere, amin di milere, el kwi nu milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka digwane waa tongwa piapa gibilin mina kol bile paalungure, ka minin ganin iru dilungwa, “Yal iray, Yesu milere Yuda ibal yal singaba bil wen milemua.” ");
INSERT INTO gvf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kunibe nongwa yal sutan Yesu daan kole kole para eri pera bolimina sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ibal kobe wiria di kanere, gain ka si tere gibilin gima dire ");
INSERT INTO gvf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","iru dungwa, “Aye, i ‘Yuda ka main ogu bil si sulere are kaun sutakobe kwi kiiralwa,’ dingiray. I God Wan milanga, ena i inin ai yebe do. Eri pera mina pisere ereya main som mo.” ");
INSERT INTO gvf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yuda ka main kenin erungwa yal bil kobe, te nil si tongwa yal kobe, te singaba kobe bole para, iru da di sutaw ere tere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yalini ibal kobe aa ki dungure u wai omba, yalini inin aa ki dikinangwa paamua. Isirel ibal singaba bil wen milinga, eri pera mina pisere ereya main som mo. Sinanga kanere, i kal eringa main pire gi dirabinwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yalini God aa gi di warere, ‘God Wan miliwa,’ dungiray, ena malia God aa ki di tenangure u wai nangwa kanabina.” ");
INSERT INTO gvf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dungure kunibe yal sutan bole eri pera mina pai milere, para gain ka si Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ena are kamin suna wen ongure kamin si bilungwa. Si bile dungwa dungwa, pu dungwa are pera ongure kamin kwi aw dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pu dungwa are pera ongure, Yesu gala bilkaw dire iru dungwa, “Eloi, Eloi, alama sabakatani?” Ka dungwa main iru paangwa, “Na God, na God, tameran na piserine?” ");
INSERT INTO gvf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dungure ibal taw maala milungwa pirere iru dungwa, “Piro milo, yalini Ilaya di gala dimua.” ");
INSERT INTO gvf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dungure yal ta mugu di pire, nil kule nongwa gal niriin gi kiingwa kulere, bili waa ki dire Yesu nenama dire tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tomba, ibal taw iru dungwa, “Kane milo, Ilaya ure aa ki di tenangure, Yesu u wai nam mo, pekenam mo kanabina.” ");
INSERT INTO gvf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dungure ena Yesu gala bil bil dire, gulungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Gulungure, gal bilkaw Yuda ibal ka main ogu bil kegemama yongwa ai si pere dungwa, mine aa dinadi yene piraa sungwa. Ememe ungure kobile si guru dungure, ");
INSERT INTO gvf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ibal yene yobilaan gul kobile giraan yawlungure, God gawlin kobe binanbile goma gulungwa alungure, God kal iru erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Alere, ena Yesu gulere ale piserungwa kaun, pi God ain Yerusalem ongure ibal binanbile kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ena Orom simil nen kenin erungwa yal te simil nen bole, Yesu el kwi nu milere, ememe ungwa te kalkan u maribe ongwa kanere, kuril wen pirere iru dungwa, “Yalini God Wan milungwa kirara wen kanebinwa.” ");
INSERT INTO gvf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Goma Yesu Galili milungure abal kobe duulin bile urere aa ki di tongwa. Malia abalin kobe binanbile taw tayan mile kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kanungure Madala ai abal ta Maria milungure, te Yemis te Yosepe man Maria milungure, te Sebedi wan kobe man para milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ena kamin kaya girungure, Arimatia ai nen ta kaan Yosepe, bona gana binanbile aa te nongwa yal milere, Yesu gawlima ta para milere u bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Direre pi Pailete milungwa gul pirere Yesu yobilagi irala dire, sirin bile tongwa. Bile tongure Yesu yobilagi Yosepe inama dire Pailete “To,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tongure irere, gal pege kwi wai wen dungwa werere, ");
INSERT INTO gvf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","inin kobile giran, ibal malia woule tongwa ali yongwa. Yerere pare, kobile milin bilkaw kana giran bile pere di yere, ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Madala ai abal ta Maria te Maria ta bole alia mile, kobile giran kaana amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ena kaun ta Pirainde kaya wei sungure, kwimile kaun iray, Yuda ka main kenin erungwa yal bil kobe te Parasi kobe bole, pi Pailete milungwa gul u ku bilere ");
INSERT INTO gvf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","iru dungwa, “Singabo, ena kasu kobaan kwi imo mile, ‘Are kaun sutakobe wei sinangure kwi alalwa,’ dungwa maliaga pirebinwa. ");
INSERT INTO gvf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iru dimia, ena yalini gawlima kobe pi kobile giran yobilaan kunibe ikinama dire, simil nen are kaun sutakobe el kwi nu milama dire di to. I iru ta erekinana, eme yalini gawlima kobe pi yobilagi kunibe ire, ‘Gulere alemua,’ dinamua. Goma, ‘God Wan milemua,’ kakiibi dungwa paikimba, malia kakiibi ta dinangwa i, wen ta paikinamia.” ");
INSERT INTO gvf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dungure Pailete iru di tongwa, “El kwi nu milama dire simil nen taw ire awli po. I yal kobe el kwi nu milala di piringa mere, el kwi nu milo.” ");
INSERT INTO gvf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dimia ena yalin kobe pirere, kobile milin bilkaw kobile giran bile pere di yongwa, gariba ta si daangwa. Ibal ure aa ku tenangwa kanala dire, gariba ta si daangwa. Gariba si daare simil nen kobe, “El kwi nu milo,” di tere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ena Sareba kaun wei sungure Sarebil kaun taanima wen are nol erungure, Madala ai abal ta Maria te Maria ta, pi yene yobilaan gul nala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ememe bilkaw gin taran pilau dungure, God Singaba angel ta kamin pisere ere gariba gul ure, kobile ta yene yobilaan gul si pere dungwa yawlere, bolimina amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Milere kamin nege erungwa aw dungwa mere, yalini guman iru kulere, te gal sigi dungwa pege wen dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","El kwi nu milungwa yal kobe kanere, kuril wen pire kalgane irere gulungwa mere milungwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ena angel iru di abalin kobe tongwa, “I kuril ta pirekio. Yesu eri pera mina si gulungwa, i kanala dire unga piriwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yalini abila ta milekimia kaya ale ere omua. Yalini dungwa mere u maribe omua. Yalini yongwa gul kanana wo. ");
INSERT INTO gvf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kananga i mugu di pi gawlima kobe iru di to, ‘Yesu gulere kaya alemua. Te goma dungwa mere Galili gariba gul goma ongure i eme unanwa. Gariba iray i yalini kananwa.’ Ka di tega, nomanin si pire di tenana po.” ");
INSERT INTO gvf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dimia ena yene yobilaan gul gin taran pisere kuril pire milimba, miriin paire mugu di pi gawlima kobe di terala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ena Yesu gin taran pire, abal kobe kol baan guman yere iru di tongwa, “Abalkuno, ere uno?” Dungure, abal kobe ure pi maala pire, kawn mina awi dire aa tere, deminin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tongure Yesu iru di tongwa, “I kuril ta pirekio. I pi na enan kobe iray iru di to, ‘Galili pire Yesu i ain iray kananwa,’ iru dimia di to.” ");
INSERT INTO gvf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Abal kobe ere ongwa, ena el kwi nu milungwa yal taw pi ogu ai ala pire, Yuda ka main kenin erungwa yal bil kobe kalkan u maribe ongwa di gawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yuda ka main kenin erungwa yal bil kobe, te singaba kobe u ku bile ka iru diria ere pirungwa. Pirere kobile moni bil simil nen tere, iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“‘Na gilaa ul paibinga gawlima kobe ure yobilagi kunibe imua,’ dire sirin bile i tenangwa, i iru di tenanwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kal iru erebinga Orom yal bil pirangwa, ena ka di yalini terabingire, i ka kol ta paikinamua.” ");
INSERT INTO gvf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iru dimia, ena el kwi nu milungwa yal kobe kobile moni tongwa irere, ka di tongwa mere wiina erungwa. Ena ka pore dungwa i, Yuda ibal si dinaa dungure te kemina para iru erungwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ena “Kamin kuul ta Galili gariba gul suna dungwa baan i po,” Yesu dungure, gawlima anan kole kole muru kawnan milin taran ongwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pirere Yesu kanere deminin si tomba, gawlima taw kobe nomanin sutan sungwa. ");
INSERT INTO gvf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu u maala ure iru di yalin kobe tongwa, “Kamin gul te gariba gul para kenin eregi, God yobilaan bile na tomua. ");
INSERT INTO gvf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tomia ena gariba ibal kole kole para u na gawlimanan kobe muru nama dire i pi konagi erana po. Abe te yalini Wan te yalini Kegemama Iban, yalin kobe kaan gale nil bile to. ");
INSERT INTO gvf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na kile kaman ka para di i tega ibal kobe wiina erama dire, ka nil si to. Ta dirala piro. Kamin kaun kaun i bole morin morin mile pairalwa. Mili nalga, kamin te gariba para wei sinangwa kaun, na i bole mile pairalwa,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","God Wan Yesu Kirisito, yalini guun kan kawn kule u maribe ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","U maribe ongwa main iru paangwa. God ka kebe yal Aisaya ka minin ganin iru dire bilungwa paangwa, “God ka iru di na tongwa, ‘Na ka kebe yal ta nusi erebingire, yalini goma ye tere kol bala di i tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Gariba simi yongwa gul yal ta mile, ‘Singaba unangwa kol bala di tere aa tekun ero,’ dire gala iru dimua.” ");
INSERT INTO gvf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dungwa main iwe, nil bile tongwa yal Yon, gariba simi yongwa gul u maribe pi mile, main iru kere di maribe ere ibal tongwa, “Kal digan ere taalime eringa pisere, nomanin suna si kiruul sire, nil bile iyo. Iru ere milanga God pirin gule i tenamua.” ");
INSERT INTO gvf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudia gariba gul ai ta ta para, te Yerusalem ogu ai bil ibal pi yalini ka dungwa pirala di pirere, kal digan ere taalime erungwa di maribe erungure, Yon Yodan nuule mile nil bile ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ena Yon bolima kamel igin gal ware sigi dire, bolima gain kin mere dere, gomare nere te deboma niriin nongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yalini kere di maribe ere iru dungwa, “Yal ta eme na munan kol u milamua. Yalini yobilaan bil pai tongure na yobilanan kuunin ta pai na tekemua. Na yalini gal kine teralba, na yal digan mile kuunin ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na i nil wo bile teiba, yalini God Kegemama Iban i tenangure i nomanin sigi dinamua.” ");
INSERT INTO gvf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Di tongwa kaun i, Galili gariba gul ai ta kaan Nasarete Yesu piserere, pi Yodan nuule ongure, Yon nil bile Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu nil ali milere ere mena ungure, kamin aw di ala di kole kole ongure, God Iban imil giran guman kulungwa mere, si paale ire Yesu milungwa gul ime ungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ungure kamin mina ka ta iru ere ime ungwa, “I na Wanan taran milinwa. Kanere na gun ye wai wen pire i teiwa.” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iru dungure, God Iban milere Yesu gariba simi yongwa sa nusi erungure, ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pirere, yalini gariba simi yongwa gul are kaun yal sutan aan kawn muru milere, Satan kiraan sire kela kule te milungwa. Te milungure kabe biin eli paangwa bole para milungure, angel aa ki di te milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ena Yon kanin pai milungure pare, Yesu Galili gariba gul pi bawa dire, God guun kan kere di maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Erere ka iru dungwa, “God kenin ere ke milangwa kaun kaya u maala ongure, kaun i u maribe pi na tomia. Kal digan ere taalime eringa pisere, nomanin suna si kiruul sire, God guun kan pire gi do.” ");
INSERT INTO gvf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Direre Galili nil benge binan warungure, Saimon te yalini kebinbi Endiru, nil kabe sungwa gal pusi nil ali erere yal sui nil kabe si sire erungwa yal milungure, Yesu kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kanere Yesu iru di tongwa, “I na munan kol duulin bilo. Bilanga konagi main nil si i teralgire, nil kabe singa mere, ibal iru di ku bilanwa.” ");
INSERT INTO gvf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dungure yal sui gin taran nil kabe sungwa gal pisere paale, yalini mun kol duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ena Yesu tawlita tayan ongure pare, Sebedi wan sui Yemis te Yon, sipe ala milere, nil kabe sungwa gal bali sungwa kwi si bile milungure, Yesu yal sui kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kanere “Nabina wo,” dire gin taran gala dungure yal sui nen Sebedi, te nil konagi yal sipe ala milungwa piserere, Yesu mun kol duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ena yalin kobe Kapanaum ai pi milere, Sare kaun u bawa dungure Yuda ibal ka main ogu ala pirere, Yesu ka nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nil si tongwa main i ibal pire buul kunungwa. Yuda ka main nil si tongwa yal kobe, nil si tongwa mere, yalini iru ta dikimia. Ka yobilaan bilungwa dungure maa yebe omia, ibal pire buul kune milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kaun iray yal ta sia den suna milungwa, Yuda ka main ogu kaya u maribe pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Milere gala dire iru dungwa, “Yesu Nasarete nen na kanan paamia, i kanin ta painan dino? Na yal kobe na si sutaw ere na terala dire uno? God kabin sire wai wen milungwa yal, i yalini milinga, na i gumanin kaniwa.” ");
INSERT INTO gvf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iru dimba Yesu kan tere, “Ka ta dikire, yalini pisere ere mena po,” ");
INSERT INTO gvf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","dungure sia yal i nibil maalame tere, gala bil dire ere mena ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iru erungure ibal kobe para kane buul wen kunere, diria ere iru dungwa, “Ayo, takal ereme? Ka main ta kwi u maribe pire maa yebe omua. Ka yobilaan bilungwa di sia tongure, sia iray wiina eremua.” ");
INSERT INTO gvf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ena Yesu guun kan gin taran Galili gariba gul, te gariba binan kole kole para, ware biingwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu te Yemis te Yon, ka main ogu iray piserere pi Saimon te Endiru ogin ala milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ena Saimon wounbi nibil ere paire gain nega dungure, yalin kobe Yesu gin taran di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tongure Yesu abalini milungwa gul urere, aan aa tere aa ki di alungure, gain nega dungwa gwi sungure, komina gin taran ki yalin kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kaun iray kamin kaya gire kama sungure, ibal kobe nibil erungwa ibal, te sia den miriin suna milungwa ibal para, awli Yesu milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ibal taminin ta para muru ogu ai penin u ku bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nibil main main ere milungwa aw di pilaan pai tere, te sia para maa si mena erungwa. Erungure sia Yesu guman kanere ka dala di erungure manaa di tongure, ka ta dikungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kwimile taanima wen kamin kama si dungure, Yesu alere ai simi yongwa gul pirere, ana di God tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon te ibalin kobe para, Yesu kanala dire waa duu i ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Waa duu i pi kanere, “Ibal para i waa duumua,” ");
INSERT INTO gvf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","dungure, yalini ainere ka iru di yalin kobe tongwa, “Ogu ain kole kole maala dungwa, ka main kere di maribe ere terabina, nabina wo. Konagi iru erala dire, na wiwa.” ");
INSERT INTO gvf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dire, Galili gariba gul suna para warere, Yuda ka main ogu ala ka main kere di maribe ere ibal tere, sia maa si mena erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Seki egilungwa yal ta, yalini milungwa gul urere, yaa gobin bile mile kawan dire iru dungwa, “I na nimbona aa te wai ere na terala di piranga, aa te wai ere na tenanga, kuunin painamua.” ");
INSERT INTO gvf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dungure Yesu miriin wen pirere, aan dire dire aa tere iru dungwa, “I aa te wai erabinga di pirebina i u wai pi milanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dungure seki egilungwa yal, gin taran gain wiige sire u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ongure Yesu yalini kiraan aa tere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kal ere i tega, i ibal kobe di tekio. Tekenanba, pi Yuda ka main kenin erungwa yal, gaynin wiige sungwa i maribe eringire, kanamua. I gaynin wiige singi, Mose goma, ‘Kal ta to,’ ka dungwa mere wiina erangire, gaynin wiige singa ibal kanamua.” Di tere gin taran nusi ere, “Ere po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesu “Di tekio,” dire manaa di tomba yalini pirere ibal para bolin kule tere, ka i di warungwa. Ka i di warungwa, Yesu ogu ai bil ala nala di omba, ala pekenangwa paangwa. Gariba simi yongwa gul pi milimba, ibal gariba binan kole kole para, yalini milungwa gul kire di u taminin sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kaun tawliga wei sungure Yesu kwi ere Kapanaum gariba gul ongwa, “Yalini ogin milemua,” dungure ibal kobe pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pirere ibal binanbile u ku bile milungwa ogu di dungure, ibal taw ai penin maala nala di pirimba, ai ta dikungwa. Yesu God ka main kere di maribe ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ere milungure ibal kobe ure, aan kawn ki sungwa yal ta bole para awli urere, yal sui sui yalini borebil si yuungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yuumba, ibal binanbile u ku bile milungwa, ena Yesu milungwa gul maala ta pekenangwa paangwa. Pekungwa, maa pi Yesu milungwa gul gibilin mina pirere, erewan suule ere gawalin ulin kole kole kan kulere aa te milere, aan kawn ki sungwa yal gawalin ali pai milungwa mone mone di pusi ime erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iru erere Yesu aa te wai ere yalini tenama di pirungwa Yesu kanere, “Wanane, kal digan ere taalime eringa pirin paangwa i, kire di eremua,” dire iru di aan kawn ki sungwa yal tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Ena Yuda ibal ka main nil si tongwa yal kobe, taw ali amin di milere iru nomanin si pirungwa, “Yal i, tameran ka iru dime? God gain ka si tomua. Ibal kal digan ere taalime erungwa, ibena kire di erame? God inin tawle mile, ibal kal digan ere taalime erungwa kire di eramua.” ");
INSERT INTO gvf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dire, yalin kobe iru nomanin si pirungwa Yesu pirere, iru di tongwa, “Tameran iru nomanin suna ali si pirine? ");
INSERT INTO gvf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","‘Kal digan ere taalime eringa pirin paangwa i, kire di eremua,’ diralga ka pilaan painamba, ‘Gawalin ire kol warana po,’ diralga u wai nam mo, pekenam mo, ibal kanamua. ");
INSERT INTO gvf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na U Ibal Obinga Yal, ibal kobe kal digan ere taalime erungwa pirin paangwa i, kire di erabinga, yobilaan na tongwa main pire bawa dinanwa.” Iru dire, di aan kawn ki sungwa yal tongwa, ");
INSERT INTO gvf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“I di i teiwa, alo, gawalin aa te ire ere oginin po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dungure motabe alere, gawalin aa te ire ere malge ongwa, ibal para kanungwa. Iru kanere ibal kane buul kunere God maki ye tere, “Iru erungwa mere goma ta kanekibinwa. Malia taran kanebinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kwi nil benge binan ongure, ibal binanbile Yesu milungwa gul u ku bilungure, yalini ka nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ena pi baan ta ongure, Alpias wan Ilibai kobile moni takis ingwa ogu amin di milungure kanere, “Na munan kol duulin bilo,” di tongure, yalini alere mun kol duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu pi Ilibai ogin amin dire komina ne milungure, kobile moni takis ingwa yal digan, te taalime erungwa yal kobe, yal binanbile Yesu, te yalini gawlima kobe bole para amin di milungwa. Ibal iru binanbile duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parasi kobe taw, Yuda ka main nil si tongwa yal kobe milere, taalime erungwa yal kobe te kobile moni takis ingwa yalin kobe, Yesu bole para komina ne milungwa kanere ka iru di yalini gawlima kobe tongwa, “Tameran yalini kobile moni takis ingwa yal digan te taalime erungwa yal kobe bole para komina ne mileme?” ");
INSERT INTO gvf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ka iru dungwa Yesu pirere, iru di yalin kobe tongwa, “Ibal imore milungwa dokita milungwa gul pekenamba, nibil erungwa omua. Ibal maribe milungwa di ku bilala dire na gariba gul ukiwa. Taalime erungwa ibal di ku bilala dire ime wiwa,” dire iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ena kaun ta Yon gawlima kobe te Parasi kobe komina mawal ere milungure, ibal urere iru sirin bile Yesu tongwa, “Yon gawlima kobe te Parasi gawlima kobe komina mawal ere milungwa, tameran i gawlimanin kobe komina mawal ere milekeme?” ");
INSERT INTO gvf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dungure Yesu ka iru di yalin kobe tongwa, “Yal ta abal inangwa kaun, yalini ye nongwa ibal komina mawal ere milamo? Tamama. Bole para milere komina nenamua. ");
INSERT INTO gvf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Iru eramba, kaun ta na awli nangure kaun iray na gawlimanan kobe komina mawal ere milamua. ");
INSERT INTO gvf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ibal gal kwi ire gal golin bali sungwa bolimina si bilekinamua. Si bilangwa, gal kwi ai i dire kunangure, gal golin iray kwi ama bali bilkaw sinamua. ");
INSERT INTO gvf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ibal wain nil kwi kule meme gain mugu golin ali garu dekenamua. Ali garu dinangwa, miin ure u niminin mile meme gain mugu si gala dinangure, wain nil u mena pire mugu para pawa dinamua. Wain nil kwi kule, meme gain mugu kwi dungwa garu dinanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ena Sare kaun ta, Yesu dodal yaalungwa gul suna kol ware ongwa. Ongure yalini gawliman kobe para pire milin taw ulungwa. Iru ulungwa mere Yuda kile kaman ka main, “Para paimua,” dungwa paangwa. ");
INSERT INTO gvf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ulungure Parasi kobe ka iru di Yesu tongwa, “Ena kano, na ibal kobe kile kaman ka, ‘Sare kaun kal ta iru erekio,’ dire manaa dibingare, i gawlimanin kobe tameran Sare kaun kwi ereme?” ");
INSERT INTO gvf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dungure Yesu ka iru di tongwa, “Debiti te ibalin kobe kenan gule kal erungwi, i ka pore kere pirekino? Piringirawe. ");
INSERT INTO gvf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abayata God kenin erungwa yal bil milungwa kaun, Debiti Yuda ibal ka main ogu bil ala pirere, komina birete God tongure kanungwa, ‘No,’ dungure nomua. Komina birete iray ibal imore nekungwa, ka main kenin erungwa yal inin nomua. Debiti nere, ibal para milungwa tongure nomua.” ");
INSERT INTO gvf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ena Yesu ka iru di yalin kobe tongwa, “Goma God ibal ere yongwa, eme Sare kaun erin kaun bale ibal tomua. Sare kaun goma yekire, ibal goma ere yomua. ");
INSERT INTO gvf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iru erungwa Na U Ibal Obinga Yal, Sare kaun na kobaan miliga paamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu Yuda ibal ka main ogu kwi ala ongure yal ta aan kebil sungwa milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Milungure ibal kobe nai kanere iru nomanin si pirungwa, “Sare kaun dungwa Yesu aa te wai ere yal ta tenam mo, tenangwa yalini ka di mere si terabinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dungure yalini ka iru di aan kebil sungwa yal tongwa, “I alere u gumanan kol milo.” ");
INSERT INTO gvf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Di tere ka iru sirin bile ibalin kobe tongwa, “Na ibal kile kaman ka takal waa dungwa pirine? Sare kaun kal wai erabin mo, kal piril sungwa erabine? Ibal aa ki di terabin mo, si gule terabine?” Iru di tomba, ibalin kobe imore mile pire unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ibalin kobe pire unin si mile girin dungwa, Yesu miriin pirere kole kole den gule kanere, iru di aan kebil sungwa yal tongwa, “Anin dire do.” Dire dungure kwi u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parasi kobe u malge pirere Kerodi gawlima kobe bole Yesu si gulala dire, di paalungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu gawlima kobe bole pi nil benge ai ongure Galili ibal kobe binanwenbile duulin bile ongwa. Ena Yudia ibal te Yerusalem ibal te Idumia ibal, te Yodan nuule binan kole iray ibal, te Taya te Saidon binan kole ibal, ibalin kobe iru Yesu yalini kal erungwi pirere, ibal binanwenbile yalini milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ibal binanwenbile u ku bilungure, na yobile suna erama di pirere, Yesu ka iru di gawlima kobe tongwa, “Sipe ta pi ala milabina di erabinga, i ere maala wo.” ");
INSERT INTO gvf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iru dungwa main iwe. Ibal miriki aa te wai erungure, nibil erungwa ibal Yesu aa terala dire diibe daibe erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sia Yesu kanere i kwi bilere iru gala dungwa, “I God Wan milinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dire Yesu guun kan warekinama dire Yesu manaa di yobilaan bilungwa. Yesu kal iru erungwa, ena sipe ta i, “Ere maala wo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ena Yesu kamin kuul maa pirere yal kobe yalini bole konagi erala di pirere, gala dungure yalini milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yesu gawlima kobe anan kole kole muru kawnan milin sutan bole para milala dire kaan ye tongwa. Tongwa ka main di tenama dire nusi erere ");
INSERT INTO gvf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sia maa si mena erama dire yobilaan bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gawlima kobe anan kole kole muru kawnan milin sutan paale suna ere ingwa, kaan iru paangwa, Saimon kaan ta kwi Pita yerere, ");
INSERT INTO gvf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ta Sebedi wan Yemis, ta Yemis kebinbi Yon, kebin abin sutan i, kaan ta Boanesi (Golin ka, kamin guru dungwa yal milungwa) yerere, ");
INSERT INTO gvf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ta Endiru, ta Pilipi, ta Batolomiu, ta Matyu, ta Tomas, ta Alpias wan Yemis, ta Tadias, ta yobilaan bilungwa yal kaan Saimon, ");
INSERT INTO gvf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ta bale taal sungwa yal kaan Yudas Isikerio. ");
INSERT INTO gvf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yal kobe iru paale suna ere ire pare, Yesu ere ogin ongwa. Yesu te gawlima kobe komina nerala dimba, ibal binanbile kwi ama u ku bilere ogu si di dungwa, komina ole nekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iru erungwa Yesu ibalin kobe pirere, “Yalini kiraan gi dimua,” dungwa. Direre aan aa tere awli urala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yuda ka main nil si tongwa yal kobe Yerusalem pisere ere ime urere, “Sia bil wen kaan Bielsebul Yesu nomanin suna milere, yobilaan bile tongure sia maa si mena eremua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dungure Yesu, “Na milebinga gul ere wo,” direre ka di bile dire iru dungwa, “Satan inin milungwa, tameran kwi inin maa si mena erame? ");
INSERT INTO gvf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gariba baan ta yal kobe suna si bine dire kura bilangwa u sutaw namua. ");
INSERT INTO gvf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nen abin kobe guman inin inin dinangwa u sutaw namua. ");
INSERT INTO gvf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan inin gain di keli sinangwa, eme ime naanin ta pai milekire, eme wei sinamua. ");
INSERT INTO gvf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Yal ta pi yal naanin paangwa ogu kol di guru di erere, bona kunibe irala di nangwa ala pekenamba, goma naanin paangwa yal aan kawn kole si paale, ala pire bona inamua. ");
INSERT INTO gvf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Na ka wo di i teralga piro. Yal kobe kal digan ere taalime erangwa, te gain ka sinangwa pirin paangwa para muru iray, God gule ere tenangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Paamba, ibal God Kegemama Iban gain ka si tenangwa, pirin paangwa i gule ere tekenangwa paamua. Pirin i, pai dinangwal dinamua.” ");
INSERT INTO gvf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ibal taw mile, “Yesu den suna sia milemua,” dimia, yalini ka iru di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesu man te kebin kobe urere malge milere, yal ta nusi erere, “‘Yesu wo’ do,” dire iru di tongwa tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ibal binanbile Yesu milungwa gul amin di milere iru di yalini tongwa, “Ena i manin te kebinbi bole malge milere i ‘Ere wo,’ dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu waa dire, “Na mina te kebinanbi ibena kuunin mileme?” dire sirin bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ibal Yesu milungwa gul amin di milungwa, Yesu u kane kole kole erere iru dungwa, “Na mina te kebinanbi ali milemiawa. ");
INSERT INTO gvf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ibal kobe God ka dungwa pire wiina erangwa, ena ibalin kobi, na kebinanbi te alanbi, te na mina mere milemua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ena ginin ta Yesu Galili nil benge makalua binan kole milere, kwi kawn kule ka nil si tongwa. Ibal kobe binanwenbile u ku bilungure, sipe ta nil minimina warungwa Yesu ala pirere, amin di milungwa. Ibal kobe para wen nil benge binan kole milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu ka di bile dire, main ta ta para nil si tere iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ka di i teralga piro. Yal ta milin sigilala dire omua. ");
INSERT INTO gvf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sigile milungure, taw yaa kombil bolimina sungure kauba urere nomua. ");
INSERT INTO gvf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kobile bilkaw dungwa minai gariba wanin tawliga bolimina dungwa gul milin taw yaa sire, gariba binanbile ta dekungwa gin taran maamua. ");
INSERT INTO gvf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Maamba, are bil dongure dulaanin warekimia, minin kengi sire gulemua. ");
INSERT INTO gvf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Milin taw kul galan yongwa suna ali yaa sirere bole para maangure, kul galan yongwa naan yobilungure gulemua. ");
INSERT INTO gvf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Milin taw gariba wai dungwa gul yaa sirere, gune di maare arin sire milin kule sulu dimua. Ena erin ta milin taran taran, teti paingure, ta milin binanbile, siksti paingure, ta milin binanwenbile, wan kandret paimua.” ");
INSERT INTO gvf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dire ainere iru dungwa, “Ibal kiranin gi dekemia kiranin gule piro.” ");
INSERT INTO gvf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ibal kobe u ku bile ongure pare, gawlima kobe anan kole kole muru kawnan milin sutan te ibal taw para milere, di bile dungwa mere sirin bile Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tongure yalini ka iru di tongwa, “God kenin ere ke milungwa mere main aal kule paangwa, God di maribe ere i tongure pirinwa. Pirinba, ibal mena milungwa main para pirekenamba, God di maribe ere i tomua. Ka di bile di tega, pire pol ta sekemua. ");
INSERT INTO gvf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Ibal mena milungwa ka di bile dungwa imore pire kanimba wai wen ta kanekinamua, te kiraan pirimba pire bawa dikinamua. Wai wen kane pire bawa dinangwa, ena nomanin si kiruul sinangure, te kal digan ere taalime erungwa pirin paangwa, i gule ere tenamba.’” ");
INSERT INTO gvf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ena Yesu ka iru di gawlima kobe tongwa, “Ka di bile di i tega i pirekina, ena ka di bile di i teralga, muru tamintan pirane? ");
INSERT INTO gvf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sigilungwa yal i God ka main milin mere sigilemua. ");
INSERT INTO gvf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ka main milin kombil bolimina sigilungwa mere, ibal iru mere milemua. Ka main pirungure, Satan gin taran urere ka main milin nomanin suna sigilungwa, i omua. ");
INSERT INTO gvf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Main ta ama iru kuunin dungwa. Ka main milin kobile bolimina sigilungwa mere, ibal iru mere milemua. Ka main pirere, wai pire miriin paamba, ");
INSERT INTO gvf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","dulaanin ikire ka main baan tawle aa gi di milemua. Yalini ka main aa gi di pirungwa ibal kura pai tere, te taalime u maribe pi tomia, ena ka main i, i mun kol eremua. ");
INSERT INTO gvf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Erungure, ka main milin kul galan yongwa ali sigilungwa mere, ibal iru mere milemua. ");
INSERT INTO gvf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ka main pirimba, gariba kal i guman mina yerere, kobile moni te kulgal bona nomanin pirungwa maangure milere, te gain kal pirungwa maangure milemua. Iru milungure, ka main nomanin suna paangwa gule bile yaamua. ");
INSERT INTO gvf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Goma ka main milin sigilungwa mere iru milimba, ka main milin gariba wai wen dungwa gul sigilungwa mere, ibal iru mere milemua. Ka main pirere pire gi dungure, milin paamua. Yal taw milin taran taran, teti paingure, yal taw binanbile siksti paingure, yal taw milin binanwenbile wan kandret paimua.” ");
INSERT INTO gvf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ainere ka iru di tongwa, “Enderin derin gale i ogu ala pirere, bale bilkaw main ali yenam mo, bol main ali yenam mo, bol bolimina yename? Bol bolimina yenangiray. ");
INSERT INTO gvf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kal aal kule paangwa muru eme main u maribe namua, te sa alibe erungwa eme aw di u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ibal kiranin gi dikimia, kiranin gule piro.” ");
INSERT INTO gvf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Dire ka iru di tongwa, “Ka piranga nomanin si ere gule piro. I ibal ere tenanga mere, God maan i ere kora kule tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yal ta kalkan binanbile kenin ere milungure, taw ama tenangure inamua. Te yal ta kalkan tawle kenin erekungwa ta tekinangure, kal tawle dungwa yal ta tawal di inamua.” ");
INSERT INTO gvf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ainere iru dungwa, “God ibal kenin ere ke milungwa mere iru paimua. Yal ta milin sigilungwa ");
INSERT INTO gvf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","girungwa taangwa dungure, milin gune di maare arin simba, main pirekimua. ");
INSERT INTO gvf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gariba ali inin bugu di maare goma arin sirere, eme maanin sire milin paamua. ");
INSERT INTO gvf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Awan dongwa kaun u maribe ongure, milin bol yongwa di sire ulemua.” ");
INSERT INTO gvf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dire Yesu ainere iru dungwa, “God ibal kenin ere ke milungwa kal ta di bi kanabin mo, ka di bile dungwa tamintan i maribe ere kanabine? ");
INSERT INTO gvf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eri koruul milin mere di bile diralwa. Milin ta ta para mege dimba, eri koruul milin megemaawenga paamua. ");
INSERT INTO gvf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Paamba, milin kulungure pare bilkaw wen bere gune dire maare, yaan bilkaw waremua. Warungure, kauba ure yaan guule yongwa aan yomua.” ");
INSERT INTO gvf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ka di bile dungwa iru main main, ka main iru di ibal kobe tongwa. Ibal main iru tawle pirama di pirungwa mere, di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ka di bile dungwa morin morin di ibal tomba, gawlima kobe inin bole milungwa kaun, main di maribe ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iru di tongwa kaun iray, kamin girungure Yesu ka iru di gawlima kobe tongwa, “Nil benge binan koli iray nabina wo.” ");
INSERT INTO gvf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Direre sipe ali milungure, gawlima kobe ibal u ku bile milungwa pisere, Yesu awli sipe bolimina erere ere ongwa. Sipe taw ama bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ongure gwi bilkaw wen maangwa, nil yugu di ime pirere, sipe si ali ibe erere, nil maa muulungwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iru erimba, Yesu sipe den yuin kol eri pera yere ul pay milungwa. Milungure yalini ulin yuure iru di tongwa, “Ka nil si tongwa yalo, na gulabinga paamua. I miriin pire na yal kobe tekeno?” ");
INSERT INTO gvf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu alere gwi koban si tere, “Ena para, mone di milo,” dire di nil benge tongwa. Tongure, gwi si oli dire kal para sua si dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yalini ka iru di gawlima kobe tongwa, “Tameran i kuril pirine? I u tegi ye na tekino?” ");
INSERT INTO gvf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yal kobe kane buul kune, giran saa dire ka iru diria ere dungwa, “Nil te gwi yalini ka dungwa pire wiina erungwa, yalini ibena mileme?” ");
INSERT INTO gvf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ena nil benge koli iray, Gerasene ibal ki pai milungwa gul u bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Direre, sipe pisere u mena ongure, yal ta sia den miriin suna milungwa, yene yobilaan kobile giran ali milere, u mena ungure yalsu pi kol baan guman yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yalini yobilaan gul kobile giran pai milungure, yal ta yalini aan kawn kwi ama kan kulala di erangwa ta milekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ginan ta ta ibal aan kawn ain yobilagi kan kulimba, yalini suna giinin maa mile kan si ole direre, ain yobilagi kan si gaw di woongwa. Ain yobilagi kan kwi kulangwa ibal ta milekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Girungwa taangwa yalini yobilaan gul kobile giran ali, te kamin kuul mina, morin morin kay miire gala bil dire, kobile aa tere inin gain mina sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yalini Yesu tayan milungwa kanere, mugu di maala urere yaa i kwi bilungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesu mile, “Sia milinga yalini pisere, ere mena wo,” dungwa sia iru gala bil dire dungwa, “God Yal Bil Wen Wan Yesu, na inan kanan paamia i kanin ta paimo? God mabin mina ka di teiwa. Giil na tekio.” ");
INSERT INTO gvf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dungure Yesu ka sirin bile tongwa, “I kaanin galo.” Yalini waa dire iru dungwa, “Na ibal binanbile milebinga na kaanan Miriki Wen paamua.” ");
INSERT INTO gvf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dire kawan dire, “Na gariba ali dungwi, na yal kobe na nusi baan ta erekio,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ena bolima binanbile kuul daan alibe ali ware ne milungwa, ");
INSERT INTO gvf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kawan dire iru sirin bile tongwa, “Na nusi bolima den miriin suna ali ere na tenano?” ");
INSERT INTO gvf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dungure Yesu, “Para ere po,” dungure sia yalini pisere kwi ere bolima den miriin suna ongwa. Bolima binanwenbile, tausen sutan milere, daan ali wi ime pirere, nil benge suna sagu dire gulungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yal kobe bolima kenin ere milungwa si ere pirere, ibal mena te malge milungwa di tongwa. Di tongure ibal kobe kanala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pirere Yesu milungwa gul u bawa direre, goma sia den miriin suna milungwa yal, sia baan ta ongwa imore milungwa, yal i amin di milungwa kanungwa. Kanere yalini gal sigi dire nomanin suna wai paangwa kanere, kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sia maa si mena erungwa, te bolima gulungwa, kanungwa yal ka dire bolin kule ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ibal kobe kawan dire ka iru di Yesu tongwa, “Na gariba i milinga ki eremia, ena ere po.” ");
INSERT INTO gvf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yalini sipe ala ongure, goma sia den miriin suna milungwa yal, kawan dire iru sirin bile Yesu tongwa, “‘Inin yasu para nabila wo,’ di na to.” ");
INSERT INTO gvf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iru sirin bilimba, Yesu manaa dire iru di yalini tongwa, “I ere oginin pire God Singaba miriin pire i tere, kal ere i tongwa main di tenana po.” ");
INSERT INTO gvf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dungure, yalini ere pire Yesu kal ere yalini tongwa mere, ibal Dekapolis gariba gul milungwa bolin kule di tongwa. Di tongure ibal pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu sipe ali pi nil benge koli kwi u bawa dungure, ibal binanwenbile Yesu milungwa gul u ku bilungure, yalini nil benge makalua binan milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Milungure Yuda ibal ka main ogu yal singaba ta kaan Yairus, Yesu kanere yalini kawn mina yaa i kwi bilere, ");
INSERT INTO gvf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kawan dire iru dungwa, “Na abilan gimege malia gulangwa paimua. Gimege gain mina aa taw sinanga, piraan dire u kwi pire milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yalini Yesu bole para ongure, ibal binanwenbile Yesu duulin bile pirere, erebil ere a pu malge bilungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Abal ta me erin anan kole kole muru kawnan milin sutan, mayan gain mina pai di milungwal milungwa, para ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokita binanbile abalini konagi ere tomia, giil wen pirungwa. Abalini bona gana muru dokita yal kobe te piserimba, aa te wai ere tekungure nibil u bil ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yesu kal erungwa mere ibal dungwa, abalini pirere ");
INSERT INTO gvf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","iru nomanin si pirungwa, “Yalini galsuna tawle aa teralga na suna pilaan paire milalwa.” Pirere ibal binanbile Yesu milungwa gul u ku bilungwa, abalini yalini mun kol urere gal aa tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aa tongure, mayan si milungwa kaya keneba yongwa. Gain wiige sungwa kanere, “Yesu pilaan pay na tomua,” dire iru pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu yobilaan ta ura dungwa pirere, gin taran kiruul sire iru sirin bile ibal tongwa, “Ibena na gal aa tome?” ");
INSERT INTO gvf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dungure gawlima kobe iru di tongwa, “Ibal binanbile i milinga gul erebil ere kaale dungwa, tameran ‘Ibena na gal aa tome,’ dine?” ");
INSERT INTO gvf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dimba Yesu ibal ta gal aa tongwa ibal i, kanala dire waa duu kane kole kole erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Abalini pilaan pay milungwa pirere, kuril pire si gagu direre, Yesu milungwa gul yaa bile minay ire kawen di gawa dire inin di maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yalini ka iru di abalini tongwa, “Abilane, i pire gi dingi malia pilaan pay milinwa. I ere pire den miriin suna yaa ime si milo. I pilaan paire wai milangal milanwa.” ");
INSERT INTO gvf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu abal ka di tongwa kaun i, Yuda ibal ka main ogu yal singaba, yalini nil konagi yal kobe ogin piserere u bawa dire, ka iru di yal singaba tongwa, “I abilin kaya gulemua. Ka nil si tongwa yal tameran imore uname?” ");
INSERT INTO gvf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ka dimba, Yesu pire unin si milere ka iru di singaba i tongwa, “Kuril pirekio. I pire gi di God to.” ");
INSERT INTO gvf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dire yalini, “Ibal milo,” dire koban si tere, Pita te Yemis te Yemis kebinbi Yon, iru tawle “Wo,” dire awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yuda ibal ka main ogu yal singaba ogin u bawa dungure, ibal binanbile poraal kaane kay bil miingwa, Yesu kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kanere pi ogu ala pirere pare, iru di yal kobe tongwa, “Tameran poraal kaane kay bil miine? Gimege gulekimia imore ul paimua.” ");
INSERT INTO gvf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dungure pirere ibal ebi mi tongwa. Ibal kobe, “Ere mena pa,” di terere gimege nen man, te gawliman sutakobe bole para ungwa, awli gimege milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yalini gimege aan aa tere, “Gimege, i kan dibina alo,” iru di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Di tongure gimege gin taran alere kol warungwa. Gimege me erin anan kole kole muru kawnan milin sutan milungure, ibal kobe kane buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu ka naanin paangwa iru dungwa, “Na kal eriga i, ibal kobe pirangwa paikimia, di tekio.” Dire “Gimege komina nenama dire to,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ena Yesu Kapanaum gariba pisere inin ogin Nasarete ongure, gawlima kobe bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pi milungure, Sare kaun u bawa dungure yalini Yuda ibal ka main ogu ala pirere, ka main nil si tongure ibal binanbile pire buul kune iru dungwa, “Yalini ka dungwa mere main paangwa, alde pire yuure dime? Nomanin si pirekun ere dungwa, tamintan nomanin si pire dime? Kal guman kwi dungwa i maribe ere erungwiwe? ");
INSERT INTO gvf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yalini ogu miremil ki kanungwa yal tawle milemua. Maria wan milere, Yemis te Yose te Yuda te Saimon abinbi milemua. Yalini alenbi abila bole para ta milekemo? Milemua.” Iru dire nigi de pire Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tongure Yesu ka iru di tongwa, “Ka kebe yal ibal pire yebe ere tomba, inin garibanin ibal, te enin taw kobe, te nen man kobe, pire yebe ere tekungwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dire gariba gul i kal guman kwi dungwa erala dimba, ta erekire ibal nibil erungwa taran taran aan aa tere a pilaan pai tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ibal kobe God pire gi dekungwa Yesu kane buul kunungwa. Yesu ogu ai ta ta ka main nil si te yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Gawlima kobe anan kole kole muru kawnan milin sutan “Miliga gul ere wo,” di gala dire, yal sutan sutan nu morin si erungwa. Sia ibal den miriin suna milungwa maa si mena erama dire, Yesu yobilaan bile gawlima kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yesu kaman tere iru dungwa, “Baan suna kobi nanga kalkan ire pikio. Komina baan nenanga, te gal kaban te kobile moni gal gulangwa, te gal sutan para ire pikio. Goliba tawle ire po. ");
INSERT INTO gvf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kawn tobilin sigi dire te gal taran sigi dire po.” ");
INSERT INTO gvf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dire ka iru di tongwa, “I pi milanga ogu i mile payo. Ogu taw kebe yekio. ");
INSERT INTO gvf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ai baan ta pi bawa dinangire, aa te wai ere i tekire, te ka dinanga pirekire, ibal iru ere i tenangwa, guman yaa tere kal iru eringire, nomanin sire main piramua.” ");
INSERT INTO gvf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dungure yal kobe u sutaw pire ka iru kere di ibal kobe tongwa, “I kal digan ere taalime eringa pisere, nomanin suna kwi si kiruul so.” ");
INSERT INTO gvf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dire, yalin kobe sia inin inin milungwa para maa si mena erere, ibal binanbile nibil erungwa kakulin bile tongure, aa te pilaan pai tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu guun kan kole kole ware biingwa, kenin erungwa yal bil kaan Kerodi pirungwa. Ibal taw mile, “Nil bile tongwa yal Yon, gulere ale u kwi omua. Omia, ena yobilaan bile kal guman kwi dungwa eremua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dimba, ibal taw kobe mile “Elaya milemua,” dungure, te ibal taw kobe mile, “Goma ka kebe yal milungwa mere yalini ka kebe yal iru milemua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ibal kobe iru dimba, Kerodi pirere, “Yon naan di keli sibinga ale u kwi omua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ka iru dungwa main iwe. Kama kaya Kerodi Yon kan kulala dire, ibal kobe nusi erere pi kanin si yuungure, kanin paangwa. Iru erungwa main iwe. Kerodi yalini kebinbi Pilipi ebinbi kaan Kerodias, Kerodi abalini ingwa ");
INSERT INTO gvf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yon iru di yalini tongwa, “I kebininbi ebinbi i inin inga paikimua.” Iru dungure Kerodias nigi de pirungwa; Kerodi Yon si kanin sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kerodias Yon nigi de pire tere si gulala di pirimba, Kerodi Yon milungwa kuril pirungure, abalini erala di pirungwa kuunin erekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yon yalini kabin sire dorimil milungwa, Kerodi kuman kine tongwa. Yon ka dungwa Kerodi pire nomanin su simba, ka dungwa wai pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Abal Kerodias Yon sala di ongwa kaun u maribe ongwa. Kaun i, Kerodi kule nongwa kaun pire komina bil gabman yal, te simil nen bil, te Galili yal singaba ki tere nongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nere milungwa kaun, Kerodias abilin suna ali urere egin gale erungwa, Kerodi te komina bole ne milungwa yalin kobe wai kanungwa. Kerodi ka iru di gi iray tongwa, “I kalkan irala di piranga kal i, ‘Na to,’ dinanga i teralwa.” ");
INSERT INTO gvf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kerodi inin mabin mina aa taw sire iru dungwa, “Kalkan na kenin ere ke milebinga suna pol sirere, ‘I kole na to,’ dinanga mere, na wiina ere i teralwa.” ");
INSERT INTO gvf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dungure abalini mena pirere ka iru sirin bile man tongwa, “Takal waa di yalini terale?” Dungure iru dungwa, “‘Yon nil bile tongwa yal, naan di keli sire gibilin gole na to,’ di ta.” ");
INSERT INTO gvf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dungure, gi i gin taran mugu di pi ka iru di yal bil kaan Kerodi tongwa, “Yon nil bile tongwa yal gibilin gole pele bala bolimina ye, malia na to.” ");
INSERT INTO gvf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dungure yal bil Kerodi miriin wen pirimba, mabin mina ka di tere te ibayaal milungwa, ena ka yaa ime sirala di pirekungwa, inin ka dungwa ka di kile di mena erala di pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yalini gin taran simil nen ta nusi ere, “Yon yalini gibilin gole ire yuwo,” di tongwa. Di tongure kanin paangwa ogu pirere naan di keli sire ");
INSERT INTO gvf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","gibilin gole pele bala ye yuure gi tongure, gi yuure manbi tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Iru erungwa Yon gawlima kobe pirere, yobilaan irere yobilaan gul maul si yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu nusi erungwa yal kobe kwi Yesu milungwa gul urere, konagi ere te ka nil si tongwa mere, bolin kule tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ibal ure ka di tere ere ongure, ibal kwi ure di tere ere ongwa. Ibal kobe morin iru erungwa, Yesu te gawlima kobe komina nerabina di pirimba, kaun ta dekungwa ole nekungwa. Ta nekungwa, ena Yesu ka iru di gawlima kobe tongwa, “Gariba simi yongwa gul erin milana nabina wo.” ");
INSERT INTO gvf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dire, sipe ala pirere gariba simi yongwa gul inin nil bolimina ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ongure ibal miriki Yesu u ongwa guman kanere ogin pisere mugu di pire, kaya u kol baan suul milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu sipe pisere, pi gariba i ongwa kaun, ibal kobe miriki wen milungwa kanere miriin pire tongwa. Bolima siipe siipe milungwa mere ibal kobe iru milema di pirungwa. Bolima siipe siipe yal ta kenin erekungwa mere, ibal kobe iru milema di pire, Yesu miriin pire tere ka binanbile nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kamin girungure gawlima kobe Yesu milungwa gul urere, ka iru di tongwa, “Abila pene yongwa dungure te kamin giremia, ");
INSERT INTO gvf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ena ibal kobe komina gibilin si nenama dire komina dungwa gul, te ogu pene yongwa gul binan nusi ero.” ");
INSERT INTO gvf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dimba Yesu mile, “Ibal kobe komina nenama dire i inin to,” dungure yal kobe ka iru dungwa, “Komina birete kobile moni kandret sutan bilungwa, pi gibilin si terabino? Tamama.” ");
INSERT INTO gvf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dungure yalini ka iru di tongwa, “I komina birete tamintan dime? Dinangwa mere pi kere kanana po.” Dungure yal kobe kere kane pisere iru dungwa, “Komina birete anan kole muru te nil kabe sutan dimua.” ");
INSERT INTO gvf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dungure Yesu mile, “Ibal kobe kul kwi yongwa bolimina taminin inin inin sire amin di milo,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ibal kobe pirere ibal taminin taw wan kandret baan ta milungure, taminin taw pipti baan ta milungure, ibal para muru iru amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu birete anan kole muru te nil kabe sutan, aa tere kamin gul kane yebe ere God maki ye tere, komina birete bege di gawlima kobe tongure, gawlima kobe obin si ibal kobe tongwa. Tongure, yalini nil kabe sutan obin si ibal para muru tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ibal para muru nere kubin maangwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Komina birete te nil kabe imo dungwa gal gulungure, gal anan kole kole muru kawnan milin sutan muulungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yalgo binanwenbile, tausen anan kole muru, komina birete nongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ena Yesu kaya ka iru di gawlima kobe tongwa, “I sipe ala pire nil benge binan kole iray Besaida ogu ai goma po.” Dire ibal miriki wen, “U sutaw po,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ibal “Ere po,” di te pisere, Yesu ana di God terala dire kamin kuul pi maangwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kamin sibilungure, gawlima kobe sipe ala nil benge suna bolimina warungure, Yesu mena inin milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Gawlima kobe bili awlan bale nil mina waa kire dire omba, gwi u sipe guman sungwa sungwa yal kobe buul yaangwa, Yesu kanungwa. Mine main kamin taangure Yesu nil bolimina ware ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pirere goma nala di omba, nil bolimina warungwa yal kobe kanere, “Sia ta umua,” di pire gala bil dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yal kobe yalini kanere kalgane ingwa. Imba, Yesu ka iru di yal kobe tongwa, “Yobilaan bile milo. Na inan miliga i kuril ta pirekio.” ");
INSERT INTO gvf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dire sipe pi ala pire gwi gurala erungwa. Erungure yal kobe nomanin pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yalini komina birete tongwa mere, main ta pirekun erekire pire bawa dikungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ena nil benge binan koli iray, gariba kaan Genesarete u bawa dire, sipe si gule yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yal kobe sipe pisere u mena ongure, ibal kobe Yesu milungwa guman kane bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ibal mugu di kole kole pire, ibal nibil erungwa eri bale kawi yuungwa. “Yesu ai baan ta omua,” dungwa gul ibal nibil erungwa awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu ogu ai mege, te ogu ai bil, te gariba binan ogu i mege mege ki paangwa ai, iru para muru ongure, nibil erungwa ibal awli malge pirere i main erungwa. Ibal ana dire iru dungwa, “I gal binan aa terabina, ‘Para paimua,’ da.” Ibal kobe aa tongwa, nibil erungwa piraan dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ena Yuda ibal ka main nil si tongwa yal kobe Yerusalem ai pisere ungure, te Parasi kobe para Yesu milungwa gul u ku bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Milere Yesu gawlima kobe, Parasi bigin sungwa mere aan bigin sikire, debegi yongwa mere komina nongwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parasi te Yuda ibal para wen, aan bigin sekungwa ibal komina nekire, bigin sungwa nongwa paamua. Iru erungwa sanamoi main paangwa mere duulin bile erungwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iru erere komina gibilin si serungwa ai pirere, urere gain bigin sekungwa, ibal komina ta nekungwa paamua. Sanamoi main paangwa taw ama wiina erungwa iru, sin kabe te mugu te muine sin, bigin si milungwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parasi kobe te Yuda ka main nil si tongwa yal kobe, ka iru sirin bile Yesu tongwa, “I gawliman kobe aan bigin sikire komina nongwa mere, sanamoi main paangwa tameran duulin bile erekime?” ");
INSERT INTO gvf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dungure yalini iru dungwa, “I yal kobe ere miriin kaale tongwa yal milinga mere, Aisaya goma ka iru dire, ‘U maribe namua,’ dire minin iru bile paalungwa, ‘God iru dungwa, Ibal kobe giran mina na di yebe erimba, pire nomanin suna yekimua. ");
INSERT INTO gvf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","God ka main paangwa mere ka iru dimua. Dimba, ibalin kobe inin gain mina paangwa ka main iru nil si tongwa, ena ana dire deminin si na tongwa ta paikimua.’ ");
INSERT INTO gvf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","I yal kobe God kile kaman ka piserere, te sanamoi main paangwa mere aa gi di warinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Dire Yesu ainere iru di tongwa, “I inin goma main paangwa mere, i aa gi di warala dire, God kile kaman ka piseringa kol ta i balere wai wen pirala di pirinba, ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iru diga main iwe. Mose goma wen ka iru dungwa, ‘I nenin manin aa tekun ere to. Te yal ta nen man kaalibain di tongwa, yalini si gulo.’ ");
INSERT INTO gvf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Dimba i iru dinwa. ‘Yal ta nen mo man iru di tenamua. I bona gana teralba, kalkan i kaya God te pisere miliwa.’ ");
INSERT INTO gvf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yal ta iru erungwa, ena kal ta kwi nen mo man, ‘Ere teralwa,’ dimba i manaa di tenwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","I iru dire, te sanamoi main paangwa mere si aine aine di tenga, ena God ka dungwa i sutaw erinwa. Iru eringa taw binanbile ama iru ere milinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ena Yesu ibal taminin kobe kwi gala di u ku bile ka iru di tongwa, “Ibal para wen na ka digi, pire nomanin suna yeyo. ");
INSERT INTO gvf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yal ta komina main main nongwa nomanin gule daalin sikinamba, yal ta ka dire erungwa mere, nomanin gule daalin simua. ");
INSERT INTO gvf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ibal kiranin gi dikimia kiranin gule piro.” ");
INSERT INTO gvf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu ibal kobe pisere ere ogin ala ongure, ka di bile dungwa mere gawlima kobe sirin bile Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tongure Yesu mile, “Ayo, ibal kobe nomanin pire paikungwa mere, i para iru milino? Yal ta komina main main nongwa, nomanin gule daalin sikungwa ta kanekino? ");
INSERT INTO gvf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Komina nongwa nomanin suna ali pekire, den ali pirere u mena omua,” dire Yesu iru dungwa, “Komina para muru, nongwa komina dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Dire Yesu ainere iru dungwa, “Yal ta ka dire kal erungwa mere nomanin gule daalin simua. ");
INSERT INTO gvf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ibal nomanin suna kal main iru paire u maribe omua. Nomanin digan si pire, gi kunibe irere, kalkan kunibe nere, ibal si gulere, abal kunibe ire, ");
INSERT INTO gvf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kalkan ka dagi dire, kal ki erere, kakiibi dire bawle tere, kule dire, kane daan gule irala di pire, gain ka sire, inin gain deminin sire miinin maarere, sinege ere nomanin paikire, ");
INSERT INTO gvf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","kal digan i para muru nomanin suna paire u maribe ongure, nomanin gule daalin simua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ena Yesu gariba iray pisere, pi Taya te Saidon gariba gul milungwa. Milere ibal kobe na gumanan kanekinama dire, ogu ta ala aal kule omba, ibal kobe pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Abal ta abilin mege sia den miriin suna ali milungwa, Yesu milungwa gul abal i pirere gin taran ure Yesu kawn mina yaa i kwi bilungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Abal i Sairopinisia ibal kule nongwa milere, Giriki ka kowa pirungwa. Abalini kawan dire iru dungwa, “Na abilan sia den miriin suna milungwa maa si mena ere na to.” ");
INSERT INTO gvf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dungure, Yesu ka iru di tongwa, “Goma gaan kobe komina nere kubin maamua. Gaan kobe komina iray awi tongwa, i ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dimba abalini ka di kole ere iru dungwa, “Singabo, i kawen dinba gaan kobe komina nongwa sine manin yaa bol main ale sungure, awi ure nomua. Nongwa mere i aa ki di na tenanba.” ");
INSERT INTO gvf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dungure Yesu ka iru di abalini tongwa, “I ka iru dingi, abilin sia u mena omua. I ere oginin po.” ");
INSERT INTO gvf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dungure abal ogin pirere, gimege bol mina ul pai milungwa kanere, te sia u mena ongwa para kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ena Yesu Taya gariba gul pisere u Saidon gariba gul suna pirere, te pi Dekapolis gariba gul para suna pirere, Galili nil benge milungwa gul u bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yal ta kiraan gi dire te guman ni ka di milungwa, ibal kobe awli Yesu milungwa gul urere, kawan dire ka iru di Yesu tongwa, “Yalini u wai nama dire, gain aa te piro.” ");
INSERT INTO gvf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Di tongure Yesu yal ta i awli baan ta pire, yalsui inin baan milungwa. Milere Yesu aan milin yal ta kiraan kuun ali aan sin bilere, ebil sire yal ta girabilin mina aa tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aa terere, kane kamin mina erere miriin sire, ka iru di yal ta i tongwa, “Kiraan pilaa do.” ");
INSERT INTO gvf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dungure yalini kiraan pilaa dungure, guman ni dungwa kwi u wai ongure, ka dungwa wai paangwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu mile, “Kal eriga i bolin kule tekio,” dungwa. Dire manaa di ibal tere milimba, ibal kobe inin bolin kule tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tongure ibal kobe pire buul wen kunere ka iru dungwa, “Yalini kal ta ta erere, para muru u wai wen omua. Kiraan gi dungwa pilaa di tongure, te girabilin aw tongwa u wai omua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ena kamin kaun iray, ibal kobe binanwenbile kwi u ku bile milimba, komina nenangwa ta dikungwa. Ta dikungure Yesu, “Ere wo,” dire gala di gawlima kobe tere ka iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“U ku bile milungwa ibal, are kaun sutakobe na bole para milere, komina nenangwa ta dekungwa na miriin pai pire teiwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ibal kobe kenan gulungwa nusi ogin eralba, kol baan omilin maalamua. Ibal taw kobe tayan ware umua.” ");
INSERT INTO gvf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dungure gawlima kobe ka iru di tongwa, “Abila ai pene yomia, komina birete nere kuunin biinangwa, alde i terabine?” ");
INSERT INTO gvf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dungure iru sirin bile tongwa, “I komina birete tamintan dime?” Dungure waa dire, “Anan kole muru kole sutan dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dungure Yesu mile, “Amin do,” di ibal taminin tongwa. Di tere komina birete anan kole muru kole sutan i aa terere, maki ye God tere, bege dire gawlima kobe ibal kobe obin sinama dire, gawlima kobe tongure, obin si ibal taminin kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nil kabe megemaa taw para dungwa, Yesu irere maki ye God tere, “I para obin si to,” dire di gawlima kobe tongure, obin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ibal kobe nere kubin maangure, komina bege dungwa imo dungure, gal anan kole muru kole sutan gule muulungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ibal binanwenbile, tausen sui sui mile nongwa. Nongure, Yesu nusi kole kole erere ");
INSERT INTO gvf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","yalini te gawlima kobe para sipe ala pirere, pi Dalmanuta gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ena Parasi kobe urere ka bolebilin dire iru di yalini tongwa, “Kamin mina kal guman kwi dungwa, ta i maribe ere na tenanga kanabinba?” Dire suan kanala dire ka iru di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Di tongure, yalini nigi de pire miriin sire iru dungwa, “Ibal malia maalungwa, tameran kal guman kwi dungwa u maribe naangwa kanala di pireme? Na kawen di terala piro. Ibal malia maalungwa kal guman kwi dungwa, taw i maribe ere tekeralwa.” ");
INSERT INTO gvf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Direre Parasi kobe milungwa gul piserere, sipe ala pire nil benge binan kole ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ena komina yuungwa gawlima kobe nomanin si pirekungure, komina birete taran tawle sipe ala imo dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yalini kan tere iru di yalin kobe tongwa, “Parasi te Kerodi, yalin kobe komina birete u bil ongwa mere, yalin kobe ka dinangwa sidina di u bil nangwa, i nai kane milo.” ");
INSERT INTO gvf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ka dungwa i pirere yalin kobe diria ere iru dungwa, “Na yal kobe komina birete ta dekungwa mere, yalin ka iru di bile dimua.” ");
INSERT INTO gvf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dungwa Yesu pirere ka iru di tongwa, “Komina ta dekungwa mere, ka iru tameran diria ere miline? I ta kane pol sikino? I ta pire pol sikino? I nomanin paikimo? ");
INSERT INTO gvf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","I omilin kulinba ta kanekino? I kiranin kulinba ta pirekeno? I nomanin paimba, nomanin si pirekeno? ");
INSERT INTO gvf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na komina birete anan kole muru bege dire ibal kobe binanwenbile, tausen anan kole muru tobingire, komina imo dungwa gal tamintan gule muuline?” Dungure yalin kobe maan dire iru di tongwa, “Anan kole kole muru kawnan milin sutan gule muulebinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dungure ka iru di tongwa, “Na komina birete anan kole muru kole sutan ibal kobe binanwenbile, tausen sui sui tobingire, komina imo dungwa gal tamintan gule muuline?” Dungure yal kobe maan dire iru di tongwa, “Anan kole muru kole sutan gule muulebinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dungure yalini ka iru di yalin kobe tongwa, “Na ka morin morin di i teiba, i pire pol sikino?” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ena Yesu te gawlima kobe para, Besaida ogu ai pi bawa dungwa. Bawa dungure yal ta omilin gi dungwa, ibal kobe awli Yesu milungwa gul urere, kawan dire iru dungwa, “Yalini u wai nama di gain aa te piro.” ");
INSERT INTO gvf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dungure, Yesu omilin gi dungwa yal i, aan aa terere awli ogu gul mena ongwa. Pirere ebil si omilin mina bilere aan aa daw sire iru sirin bile tongwa, “I kal ta kanino?” ");
INSERT INTO gvf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tongure yalini kane yebe erere iru dungwa, “Ibal kaniiba eri kalkan ku tongwa mere, iru kaniwa.” ");
INSERT INTO gvf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dungure Yesu kwi ama yalini omilin aa daw sungure, tena yulin bile kanere kalkan para muru u maribe ongwa wai kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kanungure, nusi inin ogin ere iru di tongwa, “Ogu ai malge iray, malia pikio, inin oginin po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ena Yesu te gawlima kobe ain i pisere, pi Sisaria Pilipai ogu ai ongwa. Pirere kol baan Yesu iru sirin bile gawlima kobe tongwa, “Ibal kobe na milebingi pirere, takal waa dire na kaanan galeme?” ");
INSERT INTO gvf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sirin bile tongure, yal kobe ka iru di tongwa, “‘Yon nil bile tongwa yal milinwa,’ dungure te yal taw kobe mile, ‘Elaya milinwa,’ dungure te yal taw kobe mile, ‘God ka kebe yal ta milinwa,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dungure Yesu sirin bile tongwa, “Ibal kobe iru dimba, na milebingi pirere, takal waa dire na kaanan galine?” Dungure Pita sinaa dire, “I God konagi erungwa yal Kirisito milinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dungure Yesu kiraan aa tere, “Ibal ka iru di maribe erekio,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ena Yesu ka nil si gawlima kobe tere iru dungwa, “Na U Ibal Obinga Yal miliga, ibal gain giil pire na tenamua. Yuda ibal ka main ogu singaba kobe, te ka main kenin erungwa yal bil kobe, te ka main nil si tongwa yal kobe yalin kobi, na ka diga ka di kile di mena eramua. Na si gulamba, girungwa taangwa are kaun sutakobe wei sinangure, alalwa.” ");
INSERT INTO gvf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Dire ka iru di gawa dungure, Pita awli baan ta pire kan tere, “I kan dingai kwi dikio,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dimba, Yesu kiruul sire gawliman kanere, Pita kan tere iru dungwa, “Satan, i ere tayan po. God nomanin si pirungwa mere, i iru nomanin si pirekinwa. Ibal nomanin si pirungwa meri, i iru nomanin si pirinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ena Yesu mile, ibal kobe para wen milungwa, te gawlima kobe para, “Ere maala wo,” di gala dire iru di tongwa, “Yal ta na munan kol duulin bilala di pirangwa, ena yalini gain kal pirungwa maangure manaa di tere, te na giil pire gulabinga mere, yalini giil pire gulere, na duulin bilamua. ");
INSERT INTO gvf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yal ta inin gain pire tere mile painangwal painangwa, nomanin tegi dinangwa u main nangwa paamua. Na inan miligire, te na guunan kanan para dungwa pire unin sinangwa, ena yal i mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yal ta gariba kal para wen aa te nenamba, iban u mena ongwa, takal iname? ");
INSERT INTO gvf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iban u mena nangwa, yal ta mile pairalgal pairala dire, takal tobe tename? Tobe ta tekenangurawa. ");
INSERT INTO gvf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ibal malia maalungwa kobaan pisere u yal pire, te kal digan ere taalime erungwa milemua. Ibalin kobi milungwa gul yal ta i na inan mile, te na guunan kanan diga pire ki erangwa, Na U Ibal Obinga Yal eme na para pire ki ere yal i teralwa. Na Abe naabilungwa bole uralga, te yalini angel para urabilgire, yal ta i pire ki ere teralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ena Yesu ka iru di ibal kobe tongwa, “Na kawen di terala ere gule piro. Ibal kobe taw malia abila milungwa ta gulekire, God yobilaan bile ibal kenin ere ke milangwa main goma kanere, ena gulamua.” ");
INSERT INTO gvf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Are kaun anan kole muru kole taran wei sungure, Pita te Yon te Yemis, Yesu yal kobi awli i kamin kuul bil maangwa ongwa. Yalin kobe inin milungure, Yesu igin gain kwi kulungure yal sutakobe kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yalini gal pirungwa para naabile aw dire pege wen dire u maribe ongwa. Ongwa mere iru ongwa. Gariba ibal kal ta i pege erala di erangwa, u kuunin ta pekenangwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elaya te Mose para u maribe ongwa kanungure, yal sui te Yesu bole ka diria ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ka iru di Yesu tongwa, “Singabo, na yal kobe abila milebinga, wai pirebinwa. Are dine ogu bil sutakobe, ‘Kiyo,’ dinanga kiirabinwa. Ta i ki tere, ta Mose ki tere, ta Elaya ki terabinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dire yal sutakobe kuril wen pirere kalgane ingwa, Pita giran olibe alibe erungure go go dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kawa yobile suna ere yal kobe gule yongwa ali milungure, kawa ye suna erungwa ali ka ta iru dungwa, “Yalini na Wanan taran milemia, den miriin para teiwa. Yalini ka dungwa pire wiina ero.” ");
INSERT INTO gvf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dungure gawlima kobe gin taran kane kole kole erere, ibal kobe ta milekungure Yesu inin milungwa kanemia. ");
INSERT INTO gvf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kamin kuul ere ime ongwa, Yesu yal sutakobe kiraan aa tere iru di tongwa, “I kalkan kaninga ibal kobe di maribe ere tekire, Na U Ibal Obinga Yal gulere kwi alalga kaun, ibal ka iru di maribe ere tenanwa.” ");
INSERT INTO gvf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Di tongwa i pire wiina ere di ibal tekimba inin diria ere mile iru dungwa, “Gulere alalwa dungwa, i main we?” ");
INSERT INTO gvf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dire ka iru sirin bile Yesu tongwa, “‘Elaya goma u maribe namua,’ dire Yuda ka main nil si tongwa yal kobe, tameran ka iru dime?” ");
INSERT INTO gvf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sirin bile tongure, yalini di tongwa, “Elaya kawo goma urere, kalkan para muru aa tekun eramua. Na U Ibal Obinga Yal miliga, takal ka main buku ali minin bileme? Ka iru dire bilungwa paangwa, ‘U Ibal Ongwa Yal giil pirangure, ibal kobe kilimabili paale yalini tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Iru dire bilungwa paamba, na iru di i teiwa. Elaya kaya ungure ibal kobe inin nomanin si pirungwa mere, iru ere yalini tomia, ena minin ganin goma bilungwa mere milin u maribe omua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ena yalin kobe gawlima kobe imo mile paangwa gul u bawa dire, ibal kobe binanwenbile u ku bile milungure, gawlima kobe imo mile paangwa te Yuda ibal ka main nil si tongwa yal kobe para, ka bolebilin di milungwa kanemia. ");
INSERT INTO gvf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","U ku bilungwa ibal Yesu kane buul kunere gin taran Yesu milungwa gul mugu di pirere kaale dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kaale dungure yalini ka iru sirin bile gawlima kobe tongwa, “I ka bolebilin di milingi, tawa dine?” ");
INSERT INTO gvf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dungure, u ku bilungwa ibal suna yal ta maan dire iru dungwa, “Nil si tongwa yalo, na wanan sia ta den miriin suna ali milungwa girabilin aw tongure, i milinga gul awli ubinwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sia aa te oli di pusi daan erungure, giran ebilin sire sigin gibin nuure, aan kawn sitol si dimua. I gawlima kobe, ‘Maa si mena ero,’ di tegire, maa si mena erala di erimba, kuunin paikimua.” ");
INSERT INTO gvf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu iru di ibal kobe tongwa, “Aya, i yal kobe malia maalinga pire gi dekinga ibal milinwa. Kaun tamintan inin bole imo mile pairale? Kaun tamintan i taalime eringa na obin ere kine ire warabine? Gaan i awli na miliga gul wo.” ");
INSERT INTO gvf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dungure gamege awli Yesu milungwa gul ungure, sia Yesu guman kanere gamege aa te ole di pusi daan erungure, diibe daibe ere pera kara sire giran ebilin sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu iru sirin bile gamege nen tongwa, “Goma erungwa, genawna kawn kule iru ereme?” Dungure iru dungwa, “Gamege wen milungwa eremua. ");
INSERT INTO gvf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sia aa ole di nil ali, te enderin ali ere si gulala di eremua. Erimba aa ki di yalini terala di pire kuunin painanga, miriin pire aa ki di na to.” ");
INSERT INTO gvf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dungure, Yesu di yalini tongwa, “Tameran, ‘Na kuunin painamua,’ dine? Yal ta pi tegi ye tenangwa, kalkan para wen u maribe namua.” ");
INSERT INTO gvf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gaan i nen gin taran gala bil dungwa, “Na pi tegi ye teiwa. Pi tegi ye tega niminin ta milekungwa, i yobilaan bile na to.” ");
INSERT INTO gvf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ibal u ku bilungwa Yesu yobilungure kanere, Yesu sia kan tere iru di tongwa, “Girabilin aw tongwa te kiraan gi dungwa, sia na di teralga mere pire wiina ero. Yalini pisere ere mena ure, kwi yalini den miriin suna pekio.” ");
INSERT INTO gvf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dungure sia gala dire gamege nibil maalame sia tere u mena ungure, gamege gulungwa mere pai milungwa, ena ibal kobe taw binanbile gaan gulema di kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kanimba, Yesu gamege aan aa tere aa ki dungure, yalini ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ena Yesu ogu ala ongure pare, gawlima kobe para inin milere iru sirin bile Yesu tongwa, “Tameran na yal kobe sia maa si erabina di erebinga kuunin paikime?” ");
INSERT INTO gvf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dungure yalini di tongwa, “I komina mawal ere ana di God tere, ‘Aa ki di na to,’ dinanga, ena sia iru maa si mena eranba, ana di tekenanga kuunin ta erekinanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ena ai ta iray pisere, pi Galili gariba suna ongwa. Yesu ka nil si gawlima kobe terala di piremia, ena nala dungwa ain ibal kobe ta pirekenama di iru pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ka nil si tere iru dungwa, “Na U Ibal Obinga Yal, yal taw kobe na kanin sire na si gulangure, are kaun sutakobe wei sinangure kwi alalwa.” ");
INSERT INTO gvf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka iru dimba, yalin kobe pirekun erekungwa. Sirin bile piramba, yalin kobe kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ena yal kobe Kapanaum gariba gul u bawa dungure, ogu ala pi milere Yesu iru sirin bile gawlima kobe tongwa, “Kol baan ware i ka bolebilin dinga, tawa dine?” ");
INSERT INTO gvf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dimba, pire unin si milungwa. Kol baan ure, “Na yal kobe singaba milebinba yal ta ibena singaba bil mileme?” dire ka bolebilin iru dungwa, pire unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu amin di milere, “Ere maala wo,” dire gawlima kobe anan kole kole muru kawnan milin sutan di tongwa ungure, ka iru di tongwa, “Yal ta goma pire singaba milala di piranga ena yaa ime sire konagi ere ibal tenanga, paamua.” ");
INSERT INTO gvf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu iru dire gamege ta gawlima kobe milungwa awli suna pire kaalere, iru di yal kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yal ta na guunan kanan pire aa te wai ere gamege tenangwa mere, yalini para aa te wai ere na tenamua. Na taran tawle tenangwa, tamama. Yalini para aa te wai ere, na nusi erungwa yal tenamua.” ");
INSERT INTO gvf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ena Yon ka iru di Yesu tongwa, “Nil si tongwa yalo, yal ta i kaanin gale sia maa si mena erungwa kanebinba, yalini na yal kobe bole teran duulin bile na yekebinga yal milungwa, ena manaa di tobinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dimba Yesu iru dungwa, “I manaa di tekio. Yal ta na kaanan gale kal guman kwi dungwa i maribe erungwa, gin taran gaynan ka si na tekenamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yal ta kayminan paale na tekenangwa ye nega milemua. ");
INSERT INTO gvf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na kawen di terala, yal ta mile i kane, ‘Kirisito i kobaan milungwa nil kule i teralwa,’ dinangwa, ena yalini imore ta milekire tobe inamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ena Yesu ainere ka iru di gawlima kobe tongwa, “Gamege iru ta pire gi di na tongwa iwe. Yal ta ure kakiibi dire kela kule tenangure, gaan i kal digan ere taalime erangwa, ena gain giil bilkaw piramua. Kela kule tongwa yal i, kobile bilkaw naan mina kan sire, pusi pirin nil ali erangwa paimua. ");
INSERT INTO gvf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","I anin erina kal digan ere taalime eringa ena anin di keli sire piseranga mere, i kal digan i pisero. I anin taran kule milere kamin ai mile painanga para wai dimba, i anin sutan kule milere gawl ai te enderin de paangwal paangwa nanga, ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gawl ai simin nele kabe inauna di milere, i miin bale ne milangwal milamua. Enderin garala di eramba, gakire de painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","I kawnin erina kal digan ere taalime eringa, ena kawnin di keli sire piseranga mere, i kal digan i pisero. I kawnin kebil sire kol ta warekire, kamin ai mile painanga para wai dimba, i kawnin kole kole wai imo dungure pusi daan gawl ai erangwa ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Gawl ai simin nele kabe inauna di milere, i miin bale ne milangwal milamua. Enderin garala di eramba, gakire de painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","I omilin kanina kal digan ere taalime eringa, ena i omilin woole eranga mere, kal digan i pisero. I omilin taran kule milere God kenin ere ke milungwa ai suna nanga para wai dimba, omilin sutan imo dungure pusi daan gawl ai erangwa, ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Gawl ai simin nele kabe inauna di milere, i miin bale ne milangwal milamua. Enderin garala di eramba, gakire de painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Komina pirin erungwa biingwa mere, yalini enderin gilginin ere ibal para tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Pirin kal para wai dimba, daan kiikinangwa kwi tamintan u wai name? Pirin dungwa mere i iru milanwa. Milere den miriin suna yaa ime sinangire, ibal bole den taran yere mone di milanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ena Yesu gariba iray pisere pi Yudia gariba suna pire Yodan nuule binan koli ime ongure, ibal binanwenbile Yesu milungwa gul kwi u ku bilungwa. Konagi morin erungwa mere kwi ka nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parasi kobe urere Yesu bawle terabina dire iru sirin bile tongwa, “Yal ta ebinbi imore de erangwa na kile kaman ka main paangwa, si keli sim mo, sikime?” ");
INSERT INTO gvf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dungure yalini mile, “Main paangwa i, Mose tawa di i tome?” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dungure yalin kobe iru dungwa, “Yal ta ebinbi de erala dire ka minin ganin bile tere, ‘Ere po,’ dinangwa paamua, Mose ‘Para paimua,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dimba, Yesu ka di tongwa, “I girin dire nomanin paikima di pire, Mose kile kaman ka i minin ganin bile i tomua. ");
INSERT INTO gvf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Goma wen God gariba ere yongwa, yal te abal para ere yomua. ");
INSERT INTO gvf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iru ere yongwa, yal nen man ogin pisere ");
INSERT INTO gvf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ebinbi bole ki paire yalsui si waire u taran namua. Iru pirere yal sui nomanin te gain u taran pi milamua. ");
INSERT INTO gvf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God yal abal si waire si dawle tenangwa ibal a piraa ta sekenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dire pare, Yesu te gawlima kobe pi ogu ala milere, Yesu ka dungwa mere iru sirin bile tongure, ");
INSERT INTO gvf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ka iru di gawlima kobe tongwa, “Yal ta ebinbi de erere abal ta kwi inangwa, yalini abal i kunibe ingwa mere inamua. ");
INSERT INTO gvf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ena abal ta winbi pisere yal ta kwi nangwa, ena abalini yal i kunibe ingwa mere inamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ena Yesu gamege gibilin aa taw sinama dire ibal kobe gamege awli Yesu milungwa gul ungwa. Awli ungwa gawlima kobe kan tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tomba Yesu kanere nigi de pire iru di gawlima kobe tongwa, “Gamege kobe na miliga gul urala di unangwa i iru koban si tekio. Gaan iru milungwa, God kenin ere ke milamua. ");
INSERT INTO gvf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na kawen di terala. Gamege mile, ‘I na kenin ere milo,’ di God tongwa mere, i ibal kobe ama iru ta di tekenanga, ena God kenin ere ke milungwa ai suna ta pekenanwa.” ");
INSERT INTO gvf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesu gaan kaalere, te gibilin aa taw sire, kaman tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ena Yesu baan ta ere nala di ongure, yal ta Yesu guman mina bonin gwalin yaa gobin bile milere, iru sirin bile tongwa, “Nil si tongwa yal waiye, ta konagi wai erabinga mile pairabingal pairabine?” ");
INSERT INTO gvf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Dungure Yesu iru di yalini tongwa, “Na yal wai miliga, i tameran iru di na tene? Ibal ta wai ta milekungwi, God inin tawle wai milemua. ");
INSERT INTO gvf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","I kile kaman ka piringirawa. Ibal si gulekio, abal te gi kunibe ikio, kalkan kunibe nekio, kakiibi digwane waa tekio, ka dagi dire kal imore irala di erekio, nenin manin ai yebe di to.” ");
INSERT INTO gvf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dungure yalini maan di Yesu tongwa, “Nil si tongwa yalo, malia ka dinga i, kumil mile wiina erere, te malia yal mile wiina ere miligal miliwa.” ");
INSERT INTO gvf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dungure Yesu kanere den miriin wai ye tere, iru di tongwa, “Kal ta i erekinga, kal i eranga painamua. Pi i bona aa te nenga, ibal tere kobile moni ire kal aa te nekungwa ibal obin si to. Tenanga, kamin gul bona aa te nenanwa. Nere ure na munan kol duulan bilo.” ");
INSERT INTO gvf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dungure yalini guman yaare, kalkan binanbile aa te nongwa guman wai kane miriin pire ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ena Yesu kiruul si gawlima kobe kane, ka iru di tongwa, “Bona binanbile aa te nongwa ibal, God kenin ere ke milungwa ai suna nangwa nega wen dinangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iru dungwa, gawlima kobe pire buul kunimba Yesu kwi ainere iru di tongwa, “Na kule yega kobe, ibal God kenin ere ke milungwa ai suna nangwa, nega wen dimua. ");
INSERT INTO gvf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bolima kamel kay kiibanin kuun yongwa suna ali nangwa konagi nega dimba, aa te nongwa yal God kenin ere ke milungwa ai suna ali nangwa, kal nega wen dimua.” ");
INSERT INTO gvf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dungure ena gawlima kobe pire buul wen kunere, “Ibena God aa ki di tenangure, sigare kule u wai name?” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Di tongure Yesu yalin kobe tena kanere iru dungwa, “Ibal iru ta erekinamba, God konagi para wen erangwa kuunin paimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ena Pita ka maan dire iru di yalini tongwa, “Ena i piro, na yal kobe kalkan para wen pisere i duulin bilebinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Dungure Yesu iru dungwa, “Na kawen di terala piro. Yal ta na pire gi di tere, te na guunan kanan di ibal kobe terala dire, ogin gul, abininbi, kebininbi, alenbi, nenin manin, gawlin, gariban kalkan kobi piserangwa, ");
INSERT INTO gvf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ena ibal malia maalungwa kaun, ogin, abininbi, kebininbi, alenbi, nenin manin, gawlin, gariban God maan tenangure, binanbile wan kandret mere, inamua. Inamba, ibal giil pire yalin kobi tenangure, para inamua. Kamin kaun ta u maribe nangwa, mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ibal taw kobe guman kol milungwa, kwi u mun kol milamua, te ibal taw kobe mun kol milungwa, kwi u guman kol milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ena yalin kobe Yerusalem ai nala di ongwa, Yesu goma ongure gawlima kobe pirere nomanin binanbile sungwa. Ibal kobe duulin bile ongwa kuril pire milungwa. Yesu mile, gawlima kobe anan kole kole muru kawnan milin sutan, “Ere maala wo,” di gala dire, ibal kobe kal ere yalini tenangwa di maribe ere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“I piro, na yal kobe Yerusalem ai pi u bawa dirabingire, Yuda ka main kenin erungwa yal bil kobe, te ka main nil si tongwa yal kobe para, Na U Ibal Obinga Yal, yalin kobe na aa gi di milamua. Mile ka kol ere tere, ‘Si gulo,’ direre, na awli Yuda ta milekungwa ibal tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tenangure, yalin kobe ka di sutaw ere na tere, ebil is na tere, bolima gain galan yongwa kuba aa te sire, na si gulamua. Kaun sutakobe wei sinangure na kwi alalwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ena Sebedi wan sutan Yemis te Yon yal sui, Yesu milungwa gul pirere iru dungwa, “Nil si tongwa yalo, na yalsui kal ta ere na tenana dire dibilwa.” ");
INSERT INTO gvf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dungure yalini sirin bile tongwa, “Takal ere i teralga pire dine?” ");
INSERT INTO gvf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yalin sui iru di yalini tongwa, “I kamin naabilungwa ai mile kenin ere ke milanga kaun, na yalsui i daanin kole kole singaba milabila di na tenano?” ");
INSERT INTO gvf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dimba, Yesu iru di tongwa, “I yasu pirekun ere dikinwa. Ibal kal ki ere na tenangwa piralga mere, i para pire kuunin painamo? Te na giil piralga mere, i yasu para giil pirano?” ");
INSERT INTO gvf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dungure yal sui, “Para pirabilwa,” dungure, Yesu iru di tongwa, “Ibal kal ki ere na tenangwa piralga mere, i para piranwa. Te na giil piralga mere, i yasu para giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piranba, ‘Na daanan kole kole milo,’ di teralga na konagi ta paikimua. God, ‘Ibal iru milo,’ dima di pirungwa mere, milamua.” ");
INSERT INTO gvf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iru dungwa mere gawlima kobe anan kole kole muru imo milungwa pirere, nigi de pire Yemis te Yon tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu yalin kobe, “Ere wo,” di gala dire iru di tongwa, “Gariba baan ta kenin erungwa yal kobe enin gawliman awli ure, nil konagi ye tomua. Te yal singaba ibal kobe ke milungwa mere, i kaninwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kaninba, i suna ali iru ta erekinanwa. I milinga gul suna yal ta singaba milala di pirangwa, yalini nil konagi ere gawlima kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","I milinga gul suna yal ta ogu bire kaana mile singaba bil milala di pirangwa, yalini ibal muru nil erari yal milamua. ");
INSERT INTO gvf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na U Ibal Obinga Yal para nil konagi ere na tenama dire ime ukiiba, na nil konagi ere ibal terala dire wiwa. Gariba ibal binanbile kal digan ere taalime erungwa pirin i gule ere tegire, imore baan pire sigare kule u wai pi milama dire na tobe tere gulalwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ena Yesu te gawlima kobe Yeriko ai u bawa dungwa. Yalin kobi Yeriko ai pisere ongure, ibal binanwenbile bole para ongwa. Timias wan Batimias yalini omilin gi dungwa yal mile, komina kaan di milere kombil binan amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Nasarete nen Yesu umua,” dungure yalini pirere, gala dire iru dungwa, “Yesu i Debiti gawlin milinga, miriin pire na to.” ");
INSERT INTO gvf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dungure ibal kobe kan tere, “Sime milo,” di tomba, yalini bilkaw ama iru dungwa, “Debiti gawlin miriin pire na to.” ");
INSERT INTO gvf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dungure Yesu pirere pol de kane, “‘Ere wo,’ di to,” di tongure ibal kobe, “Ere wo,” dire gala di omilin gi dungwa yal tere iru dungwa, “Yobilaan bile alo. Yalini ‘I ere wo,’ di gala dimua.” ");
INSERT INTO gvf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dungure yalini gin taran alere duul kula di ere, Yesu milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Urere Yesu di yalini tongwa, “Kal ta i ere terabinga, takal nomanin si pirine?” Dungure omilin gi dungwa yal mile, “Singabo, omilan pilaa dinama di na nomanin si piriwa.” ");
INSERT INTO gvf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dungure Yesu iru di yalini tongwa, “Ena ere po. I pire gi dinga mere u wai enwa,” dungwa. Yalini gin taran omilin pilaa dungure, Yesu duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ena ibal yalin kobe Yerusalem ai u maala ure, ogu ai sutan Betepage te Betani suna u bawa dungwa. Ogu ai iray kamin kul kaan Olibe binan kol dungwa. Baan iray u bawa dungure, Yesu gawlima sutan nusi ere ");
INSERT INTO gvf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ka iru di tongwa, “I ogu gul kola kaninga po. Pirere ala nala di erangire bolima donki gawlin kumil kwi, naan kan kule paalungwa kananwa. Ibal aw ta sikungwa milungure, i kan gule ere awli wo. ");
INSERT INTO gvf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yal ta mile, ‘Tameran kan gule erine?’ di i tenangwa, iru di ta, ‘Singaba aw si warangwa wei sinangure gin taran nusi ain eramua.’” ");
INSERT INTO gvf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesu di tongure pirere, bolima donki gawlin kumil kwi naan kan kule, ogu kana giran kombil malge yongwa kanere kan gule erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ibal kobe baanin kole milungwa iru di yalsui tongwa, “Bolima donki, tameran kan gule erine?” ");
INSERT INTO gvf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dungure, Yesu goma ka di yalsui tongwa mere bolin kule tongure, ibal pire “Ena ere po,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Di tongure, yalsui bolima donki Yesu milungwa gul awli pirere, mun bolimina inin gal kaw tongure Yesu bolima donki aw sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sungure ibal binanbile gal kombil bolimina pilaa di yongure, ibal taw kobe eri minin arin bole wi yuure kombil para pire yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ibal kobe taw goma ongwa, te eme ongwa para, “Aya maya,” dire iru gala dungwa “Yal ta God ka dungwa kebe ere yuungwa, God miriin pai tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Na sanamoi Debiti kwi kenin ere ke milangwa wai wen u maribe namua. Kamin ibal kobe para God maki ye tomua.” ");
INSERT INTO gvf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu Yerusalem ai u bawa dire Yuda ka main ogu bil ala pirere kalkan kane kole kole erungure, kamin kaya girungwa yalini te gawlima kobe bole ere Betani ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ena Yesu te gawlima kobe ul paangwa alere, Betani ai pisere ere pire yalini kol baan kenan gule milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Milere Yesu eri akola tayan dungwa arin sungwa kanere, milin kulangwa kanala dire ongwa. U bawa dungure akola milin kulekungwa kaun dungwa, arin tawle sire milin kulekungwa kanere ");
INSERT INTO gvf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","iru di eri tongwa, “Ibal kobe i milin ta ule nekinamua.” Ka dungwa i gawlima kobe pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ena Yerusalem ai u bawa direre Yesu Yuda ibal ka main ogu bil ala pirere, kal yongwa ibal te gibilin sungwa ibal sire waa kile di malge erere, kobile tobe sungwa yal kobe bol a sinaa direre, kauba yongwa ibal bol sea para a garu dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ibal bona kawi ire Yuda ka main ogu bil suna ongure manaa di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Di tere ka nil si tere iru dungwa, “Ka main minin ganin iru bilemo? Bilemia ena i piro. God ka iru dungwa, ‘Ibal gariba gul muru milungwa, na ogu ala ana di na tenamua.’ Tenamba, i kalkan yere te gibilin singa ena kunibe ibal kobile giran ale paangwa mere, na ogu ama iru eringa paamua.” ");
INSERT INTO gvf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dire Yesu ka iru dungwa ibal kobe pire buul kunungure, Yuda ka main kenin erungwa yal kobe, te ka main nil si tongwa yal kobe kuril pirere Yesu si gulabina dire, kol ta waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kamin girungwa kaun u bawa dungure ogu ai bil iray pisere ere mena ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ena kwimile taanima erima ongwa mere pirere, akola kwi kanungure, akola minin kengi sire dulaanin para gulungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yesu ka di eri tongwa Pita nomanin si pire iru di Yesu tongwa, “Singabo, eri akola i manaa di tenga kengi sire gulemia kano.” ");
INSERT INTO gvf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dungure Yesu maan dire dungwa, “I God pire gi do. ");
INSERT INTO gvf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na kawen di terala piro. Yal ta mile nomanin sutan sikire, ka diga mere u maribe nama di pirere, ‘Kamin kuul i pi pirin nil suna ali yaa so,’ dinangwa, ena kamin kuul i ka dinangwa mere pire wiina ere yaa sinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kal erungwi i pire iru di teya. I yal kobe, ‘Kal ta na to,’ dire ana dire, ‘Kaya iwa,’ dire pi tegi yenanga ena inanwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","I alere ana di God tenanga kaun, yal ta kal digan ere taalime ere i tongwa, ena pirin i gule ere to. I Nenin kamin mina milungwa, i kal digan ere taalime eringa pirin i gule ere i tenama dire, i para gule ere to. ");
INSERT INTO gvf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Dimba, ibal taw kobe kal digan ere taalime erungwa pirin i gule ere tekenanga, i kal digan eringa i Nenin kamin mina milungwa, pirin i gule ere i tekenamua,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ena Yerusalem ai kwi u bawa dungwa Yesu Yuda ka main ogu bil ala nala di ongure, ogu iray kenin erungwa yal bil kobe, te nil si tongwa yal kobe, te singaba kobe urere ");
INSERT INTO gvf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ka iru sirin bile di yalini tongwa, “I kal main eringa, ibena yobilaan bile i tome? Ibena ‘Ero,’ di i tome?” ");
INSERT INTO gvf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Dungure Yesu ka iru di tongwa, “Na ka ta sirin bile i tegire, i maan di na tenanga ena yal ta ‘Ero,’ di na tongwa di maribe eralwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yon nil bile tongwa main u maribe ongure God nusi erim mo, ibal nusi ereme? Maan dinangire piralwa.” ");
INSERT INTO gvf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dungure yal kobe inin ka diria ere iru dungwa, “‘God nusi eremua,’ dirabinga yalini iru dinangwa, ‘Tameran yalini i pire gi di tekine?’ ");
INSERT INTO gvf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Paamba, ‘Ibal nusi eremua,’ dirabinba?” Ibal muru Yon ka kebe yal wen milema di pirungure, yalin kobe kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Diria ere iru dire, yalin kobe iru maan dire di Yesu tongwa, “Na yal kobe pirekun erekibinwa.” Dungure Yesu di yalin kobe tongwa, “I iru dinga ena yal ta ‘Ero,’ di na tongwa, para di maribe ere i tekeralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ena Yesu ka di bile dire iru di yalin kobe tongwa, “Yal ta girepe kan milin yaalere gul sirere, girepe milin niriin duu yerala dire mawl ta woomua. Yalini komina gul i kenin ere milama dire, ogu ta kiire yal taw kobe tere, ‘I kenin ere mile milin taw i nenangire na taw nerabinwa,’ di tongwa. Di tere ere pi gariba baan ta tayan ki pai milemua. ");
INSERT INTO gvf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Milin bol yongwa kaun, gariba kobaan milin taw irala dire nil erari yal ta nusi erungure omua. ");
INSERT INTO gvf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Omba kenin erungwa yal kobe, nil erari yal aa gi di milere kuba sire, imore nusi erungure ere omua. ");
INSERT INTO gvf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ungure pare gariba kobaan nil erari yal ta kwi nusi erungure, kenin erungwa yal kobe yalini gibilin mina sirere, gain ka si tomua. ");
INSERT INTO gvf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tongure ungure, ta ama nusi erungure si gulemua. Gariba kobaan taw binanbile iru nusi erungure, taw kuba sire taw si gulemua. ");
INSERT INTO gvf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Gariba kobaan wan taran tawle bole milungwa, den miriin kirara tomua. Eme yalini wan taran nusi ere tere iru pirungwa, ‘Yalin kobe na wanan aa te wai ere tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wan nusi erimba, kenin erungwa yal kobe ka diria ere iru dungwa, ‘Gariba kobaan wan kominin milungwa nen gariba te kul gal bona muru inamua. Na yal kobe yalini si gulabinga kal para wen irabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dire yalini aa gi dire si gulere, pusi girepe kan gul mena eremua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dire Yesu sirin bile tongwa, “Girepe kan gul kobaan, takal erame? Yalini urere kenin erungwa yal kobe si gulere, girepe kan gul yal taw kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ka main minin ganin baan ta iru dire bilungwa paangwa i kere pirekeno? Piringi ena i piro. ‘Ibal ogu kiingwa eri ta piserungwa, eri iray i pi biriin wen mina yomua. ");
INSERT INTO gvf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","God Singaba kal iru erungure na ibal kobe kane buul wen kunebinwa,’” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu kaymin ibal Yesu di bile dungwa mere, kanin di na toma di pirere Yesu kanin sirala di erimba, ibal binanbile u ku bile milungwa kuril pirere, Yesu milungwa gul pisere ere baan ta ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ena Parasi taw kobe te Kerodi gawlima kobe para, Yesu bawle tenama dire Yesu kaymin ibal nusi erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nusi erungure, Yesu milungwa gul urere iru di tongwa, “Nil si tongwa yalo, i morin kawen dinga pirebinwa. Ibal singaba taran i aa ki di tekinwa. Ibal maangwa te yaangwa i nomanin taran si pirinwa. Te God ka para wen main paangwa mere ka nil si tenwa. I iru ere milinga pirere kobile takis Orom yal bil kaan Sisa terabinga, na yal kobe kile kaman ka main paangwa mere si keli sirabin mo sekerabine?” ");
INSERT INTO gvf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dimba, bawle terala dungwa Yesu pirere iru di tongwa, “Tameran i na suan i kanine? I kobile moni ta ire yuunangire na kanalwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta yuungure yalini di tongwa, “Kobile moni bolimina ibal milungwa, ibena guman mere kaan paame?” Dungure yalin kobe, “Sisa milemua,” di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu iru di yalin kobe tongwa, “Sisa kal dinangwa te inin baan ero. Te God kal dinangwa te inin baan ero.” Dungure ibal pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ena Sadusi kobe mile, “Ibal gulere kwi alekinamua,” dire nil si tongwa yalin kobe, kaan Sadusi Yesu milungwa gul urere ka sirin bile iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Nil si tongwa yalo, Mose ka minin ganin iru bile na ibal kobe na tongwa, ‘Yal ta abinbi temine mile gulangwa, kebin abin ebinbi inamua. Abinbi gawlin milama dire kebinbi abalini inamua.’ ");
INSERT INTO gvf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ena kebin abin anan kole muru kole sutan milemua. Abin abal ta iray temine mile gulungure, ");
INSERT INTO gvf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","kebin suna ta abal iray irere temine mile gulemua. Kebin suna ta ama iru imua. ");
INSERT INTO gvf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kebin para wen abal iray imba, para temine mile gule wei simua. Gulungure pare abal iray para gulemua. ");
INSERT INTO gvf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kebin abin anan kole muru kole sutan abal iray ingwa, eme kwi alangwa ibena ‘Ebinbi miliwa,’ dire milame?” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dungure Yesu iru di yalin kobe tongwa, “Ka main minin ganin bilungwa, te God yobilaan pai tongwa para pirekinga, ena i ka pirekun ere dikinwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ibal gulere kwi alangwa kaun yal abal ta ikinangwa paamua. Angel kobe imore milungwa mere, ibal iru milamua. ");
INSERT INTO gvf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","‘Ibal gulere kwi alamua,’ dungwa we. Mose ka minin ganin bilungwa mere i kanekino? Para kaninwa. Eri enderin bawl sungwa mere baan ta suna ali God ka iru di yalini tongwa, ‘Ebarakam te Aisaka te Yakobo, yalin kobe God na miliwa.’ ");
INSERT INTO gvf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Iru dimia ena ibal gulungwa ibalin kobi God ta milekimba, ibal kwi milungwa ibalin kobi God milemua. I yal kobe pirekun ere dikinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ena Yuda ka main nil si tongwa yal ta urere, ka diria ere ka dungwa pirere iru nomanin si pirungwa, “Yesu ka wai di ibal tomua.” Pirere iru sirin bile Yesu tongwa, “Mose kile kaman ka dungwa, ta ka wi yebe ome?” ");
INSERT INTO gvf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Di tongure Yesu maan dire iru dungwa, “Kile kaman ka wi yebe ongwa iru paamua. ‘Isirel nen kobe piro. God yalini singaba taran wen milemua. ");
INSERT INTO gvf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","I God Singaba den miriin tere, te ibanin tere, te nomanin tere, te oisa i tere milangirawa.’ ");
INSERT INTO gvf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ka ta kwi u maribe ongwa iru ongwa. ‘I inin nomanin tere gaynin kenin eringa mere, enin taw kobe nomanin para iru tenanwa.’ Kile kaman ka sutan i, ta yaa ime ta sikimua.” ");
INSERT INTO gvf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dungure ka main nil si tongwa yal iru dungwa, “Nil si tongwa yalo, i ka para dino. God Singaba taran milungure, taw ta milekungwa i kawen dinwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Den miriin para God tere, te nomanin para tere, te oisa wen tere, te inin nomanin tongwa mere enin taw kobe nomanin para iru tere, iru erangwa paamua. Kabe si gale God tere kalkan tongwa wai paamba, kile kaman ka sutan i pire wiina erangwa, wai wen paamua.” ");
INSERT INTO gvf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yalini nomanin paire maan dire dungwa Yesu kanere, iru di yalini tongwa, “God kenin ere ke milungwa ai i tayan ta milekenwa.” Di tongwa ibal kwi sirin bile tenamba, kuril pire tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ena Yesu Yuda ibal ka main ogu bil ala milere nil si tere iru dungwa, “‘God konagi erungwa yal Kirisito, yalini Debiti gawlin iru tawle milemua,’ dire ka main nil si tongwa yal, tameran iru dime? ");
INSERT INTO gvf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","God Kegemama Iban Debiti aa bawle tongure yalini inin iru dungwa, ‘God Singaba iru di na Singaba tongwa, I ure na daanan wen kol amin di milo. Milingire i kaymin ibal yaa ime si tegire, i egilana dire iru ere teralwa.’ ");
INSERT INTO gvf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Debiti yalini inin mile, ‘Na Singaba milinwa,’ di tongwa, ‘Debiti gawlin iru tawle milemua,’ dinga tameran i ka iru dine? I dinga ta paikimua.” Ibal binanbile u ku bilere, Yesu ka dungwa wai wen pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ena Yesu ka main nil si tere iru dungwa, “I ibal kobe ka main nil si tongwa yal kobe mile pai erungwa main, i nai kane kane milo. Yalin kobe gal araway sigi di ware, ‘Na Singaba miliwa,’ di piremua. Di pirere u ku bilungwa gul ongure, ‘Yal singabo, i ere uno?’ di gala di tongure, miinin maare ");
INSERT INTO gvf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ka main ogu pirere singaba bol kaana amin dire, te ibal binanbile u ku bile milungure yalini duul kaal kule aa te wai ere tongure, milemua. ");
INSERT INTO gvf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Milere abal weray kal yongwa bawle tere i aa te nerere, ana baan araway di God tere ibal ere miriin kaale tomua. Goma kal iru ere milungwa giil pire tenamba, malia kal ki taw ama ere milungwa i giil bil pire tenangwa paamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ena Yesu ka main ogu iray milungwa kobile moni nomanin pire tongwa ai maala koli amin di milere, ibal binanbile kobile moni ali yongwa kanemia. Kobile moni binanbile aa te nongwa nen taw, kobile moni bil ali yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yongure abal weray ta, kul gal bona aa te nekungwa urere, kobile moni baa sutan ali yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yongure Yesu kanere iru di gawlima kobe tongwa, “Na kawen dirala piro, ibal taw kobe kobile moni tomba abal weray kul gal bona aa te nekungwa abal i, kobile moni te kora kule tomua. ");
INSERT INTO gvf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ibal kobe kobile moni aa te nomba, taw pisere tawlita tomua. Abal weray kal ta aa te nekimba, ta aa te nongwa mere muru tomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ena Yesu Yuda ka main ogu bil ere malge ongure, gawlima kobe ta iru di yalini tongwa, “Nil si tongwa yalo, kobile bilkaw mama wen dungwa te ogu para bilkaw wai wen kiingwa i kaniga.” ");
INSERT INTO gvf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dungure Yesu di yalini tongwa, “I ogu bilkaw mama wen kiingwa kaninba, eme kobile si suule u inin inin pirere taminin sire taran ta dekenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ena Yesu Olibe kamin kuul mabin amin di milungure, Yuda ka main ogu bil kole ibe dungwa. Milungure, Pita te Yemis te Yon te Endiru inin iru sirin bile Yesu tongwa, ");
INSERT INTO gvf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ka dinga genawna u maribe name? Erala di erangwa kaun, takal goma u maribe nangwa kanabine? I di na to.” ");
INSERT INTO gvf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dungure, Yesu ka kawn kule iru dungwa, “Yal ta kakiibi dire bawle ta tekenama dire nomanin si pire kane milo. ");
INSERT INTO gvf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ibal binanbile ure na kaanan gale, ‘Kirisito miliwa,’ dire ibal miriki bawle tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ibal maala milungwa kura bilungwa kanere, te tayan para, ‘Kura bilemua,’ dinangure i pirere, te kal i piranga i nomanin si gogo erekio. Kal iru pilau dinamba, kamin te gariba wei sinangwa kaun kaya u bawa dikinamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gariba baan ta ibal kobe pirere baan ta bole inin kura bilangure, te kenin ere ke milungwa yal bil, te gawlima kobe bole pirere yal bil ta bole kura bilamua. Gariba gariba ememe pilaw dinamua. Komina ta dekungure kenan gulungwa kaun u maribe namua. Iru painamba, abal gaan kulala dire gain giil pirungwa mere, kaun i iru kawn kule u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“I yal kobe kanekun ere milo. Ibal kobe i awli ka kol pirungwa nen kobe tenamua. Yuda ka main ogu ala kuba ire i sinamua. I yal kobe na pire gi dinga yal bil, te yal singaba milungwa gul i ale milere, ka main wen di tenanwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yesu guun kan gariba gariba di nama dire goma ibal kobe kere di tenangure, kamin gariba wei sinamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ibal kobe i kanin sire ka kol ere i terala dire awli singaba tenangure, ‘Ka tawa dirabine?’ di piranga, i nomanin si gogo erekinanwa. Kamin kaun i God i ka di tenangwa mere do. I ka imore giran mina dinanba God Kegemama Iban aa bawle tenangure dinanwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Si gulama dire abinbi ta kebin bale taal sinamua. Nen para iru gawlin kobe ere tenamua, te nen man kobe si gulama dire gawlin kobe den gule tere bale taal sinamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","I pire gi di na tenga ibal para den gule i tenamua. Tenamba, i ka main aa gi di milangal milanga, ena God aa ki di i tenangure sigare kule u wai pi milanwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ena kalkan main nigi wen dongwa ai ta si kunaal sire, nigi denangwa u maribe nangure kananwa. (Ibal ka di tega iray kerangwa nomanin si suna yeyo.) Kananga kaun iwe, ibal kobe Yudia milangwa si ere dimin gul nala eremua. ");
INSERT INTO gvf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ibal ogu malge mile kanangwa, kal ta irala dire ogu ala ta pekenamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ibal komina gul mile kanangwa, kwi sinaa di pi gal ogu ala yongwa irala di pekenamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Abal gaan paangwa te gaan amin ne milungwa iwe, eke, miriin pirie. ");
INSERT INTO gvf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Giil pirangwa kaun i nimin sinangwa kaun ta u maribe ta pekenama dire ana iru di God to. ");
INSERT INTO gvf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Iru tenanga main iwe, goma God gariba ere yongure pare, eme ibal kobe giil pire mili ongwa ongwa omba, kamin kaun i giil bilkaw wen piramua. Giil pirangwa kaun iray, eme giil pirangwa kwi u maribe pekenamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","God Singaba mile, ‘Kamin kaun i baan araway ta dekere are kaun taw si keli siralwa,’ dimua. Si keli ta sekenangwa ibal kwi ta milekinamua. Paale suna ere ingwa yalin kobe, God yalin kobi miriin pire tongwa, ena kaun taw si keli sirala di piremua. ");
INSERT INTO gvf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ena yal ta iru dinangwa, ‘Kirisito maala milemia kano,’ mo ta iru dinangwa, ‘Yalini baan ta milemia kano,’ ka iru dinangware, i pire tekio. ");
INSERT INTO gvf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kaun iray kakiibi kobaan taw ure, ‘Na Kirisito miliwa,’ dinangure, kakiibi kobaan taw mile, ‘Na God ka kebe yal miliwa,’ dire u maribe namua. Pirere kal guman kwi dungwa erere, te kal main main ama erangwa, ibal kane buul kunamua. Kunangure God paale suna ere ingwa yalin kobe kakiibi di tere, kela kule terala dire eramba. ");
INSERT INTO gvf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kal i u maribe namba, ole pekungure kaya di tobinga, i yal kobe kanekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ena kaun iray kura taalime giil pirungwa kaun wei sinangure pare, are si bilangure, te ba aw dungwa para wei sinamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kulmama kobi ule di yaanangure, te kamin mina kal kobe niminin milungwa si suule u sutaw namua. ");
INSERT INTO gvf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kal iru erangure pare, Na U Ibal Obinga Yal God yobilaan bil pai na tenangure, niminin wen mile, te naabilungwa bole kawa bolimina urabinga, ibal kobe na kanamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iru urere God paale suna ere ingwa yalin kobe geril bomai, kobil kuman gariba ulin kole kole milungwa, awli u ku bilama dire angel kobe nusi eralwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ena eri akola maangwa mere nomanin si pire main piro. Akola kaalangure arin sinangwa kaun u maala ongwa, i pirinwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Piringa mere iru, kalkan kobe goma u maribe nangwa di i tobingire i kananga, ena na urabinga kaun u maala wen umia di kananwa. ");
INSERT INTO gvf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na kawen di terala piro. Kamin kaun malia ibal maalungwa kaya ta gulekinangure, kalkan kobi di tobingire u maribe nangure pare kanere, eme gulamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kamin te gariba wei sinamba, na ka dibinga wei ta sikire di painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ena main iru u maribe nangwa kaun ibal kobe ta pirekimua. Angel kobe kamin ai milungwa, para ta pirekimua. God Wan na para pirekiwa. Pirekiba na Abe yalini inin taran wen piremua. ");
INSERT INTO gvf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaun i kalkan kobe u maribe nangure kaun pirekinba, el kwi nuu mile kanekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ka dibinga mere ka baan dirala piro. Yal ta taw tayan kol ware omua. Yalini ogin pisere nala di pirere nil konagi yal kobe, ‘Kenin ere milo,’ di tere, te konagi obin si inin inin tere, te ‘Kanekun ere milo,’ di ogu kenin erungwa yal ta tomua. ");
INSERT INTO gvf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ogu kobaan pu dinangwa unam mo, kamin taangwa unam mo, mine main kamin tanangwa unam mo, kwimile taanima unam mo, kaun ta pirekungwa mere na uralga kaun i ta pirekinwa. Pirekinga, ena kanekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na gin taran uralga i ul paikire kanekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","I yal kobe ka di tega mere ibal kobe para wen di teiwa. Kanekun ere milo,” dire Yesu iru di gawlima kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ena kaun iray are kaun sutan wei sinangure, Yuda nen bolima siipe siipe sungure God yalin kobe ta sekungwa kaun kaan Pasoba, te komina birete u bil pekungwa nere milungwa kaun u bawa dire, erin bil mile komina bil nenangwa. Yuda ka main kenin erungwa yal bil kobe, te nil si tongwa yal kobe, Yesu aal kule kanin sire si gulala dire nomanin sire saala erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Erere iru dungwa, “Ibal kobe komina bil kiire erin kaun milungure, Yesu kanin sirabinba ibal kobe kura bil bile wi yau dinamua,” dire kane unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ena Yesu Betani ai Saimon seki egile ki sungwa yal ogu ala milere, komina nere milungure, abal ta ure wel niriin minanin wai wen sungwa, tobe bil bilungwa, mugu dil ali yuure giran si pawa dire garu di Yesu gibilin mina bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tomba, ibal taw kobe nigi de pire diria ere iru dungwa, “Wel niriin i, tameran imore garu di bile tome? ");
INSERT INTO gvf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tobe bil teti kina bilangwa, irabinga kul gal bona aa te nekungwa ibal obin si terabinba.” Iru dire yal kobe abal i kan tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dimba Yesu iru dungwa, “Abal i kan tekio. Tameran nigi de pire tene? Abalini kal wai wen ere na tomua. ");
INSERT INTO gvf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kul gal bona aa te nekungwa ibal, i bole para morin milamua. Milangwa i kal wai ere yalin kobe terala di piranga ere tenanwa. Tenanba, na i ibal kobe bole baan araway ta milekerabilwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Abalini kal inin erala di pirungwa eremua. Na gulabinga wel i bile na tenangwa mere, malia kwi imo miliga wel niriin iray bile na tomua. ");
INSERT INTO gvf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na kawen di terala i piro. Na guunan kanan gariba ulin kole kole kere di tenangwa gul, abalini kalkan erungwa di maribe erangure, ibal kobe abalini wai pire tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ena gawlima kobe anan kole kole muru kawnan milin sutan, yal ta kaan Yudas Isikerio, Yesu bale taal sirala dire pi Yuda ka main kenin erungwa yal bil kobe milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ongure, yal kobe yalini ka di tongwa wai pirere, “Tobe teralwa,” dungwa. Ena Yesu bale taal sirala dire kaun ta suul mile kane milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Komina bil ta, komina birete u bil pekungwa nere milungwa kaun, kamin kaun ta kawn kule erungure, goma God Yuda nen kobe ta sekungwa kaun, kaan Pasoba, nomanin si pirere bolima siipe siipe si kiingure, gawlima kobe ure iru sirin bile Yesu tongwa, “God Yuda nen kobe ta sekungwa kaun nomanin si pirabina dire, komina nerabinga alde aa tekun ere nerabine?” ");
INSERT INTO gvf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dungure yalini gawlima kobe sutan nusi ere iru di tongwa, “I ogu ai bil pirere yal ta nil mugu kawi ire unangwa kananga i bole para po. ");
INSERT INTO gvf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pirere yalini ogu ta ala nangure, i iru di ogu kobaan to. ‘Ka nil si tongwa yal iru di i tomua. Na te gawlima kobe para, God Yuda nen kobe ta sekungwa kaun kaan Pasoba nomanin si pirere, komina nerabina dire i ogin ala kulan ta alde dime?’ ");
INSERT INTO gvf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I iru dinangire yalini kulan ta mine bilkaw dungwa aa tekun erungure i maribe eramia, ena i ali iray komina aa tekun ero.” ");
INSERT INTO gvf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yesu dungure gawlima kobe sutan pirere pi ogu bil ai ali pirere Yesu dungwa mere, u maribe ongwa kanere komina nenama dire aa tekun erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ena kamin girungure yalini te gawlima kobe anan kole kole muru kawnan milin sutan ogu iray pi bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yal kobe amin dire komina nere milungure Yesu dungwa, “Kawen dirala piro, yal ta u alia milere komina na bole para nobinga, yalini na bale taal sinamua.” ");
INSERT INTO gvf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dungure yalin kobe nigi de pire inin inin iru sirin bile Yesu tongwa, “Na i sirabin mo sekirala di piria.” ");
INSERT INTO gvf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dungure, Yesu di yalin kobe tongwa, “I yal kobe anan kole kole muru kawnan milin sutan milinga, yal ta i suna milungwa yalini na bole pele bala taran komina nil bile nobilwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ka main minin ganin bilungwa mere, Na U Ibal Obinga Yal u baan ta nalwa. Nabinba, yal ta Na U Ibal Obinga Yal bale taal sinangwa yal iwe, aye, giil bil piramua. Man yal iray ta kule yekenangwa, wai wen milamba,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ena yal kobe komina nere milungwa, Yesu komina birete aa tere maki ye God tere, bege dire obin si yal kobe tere iru dungwa, “Na inan miin te gaynan dimia, ire no.” ");
INSERT INTO gvf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dire pare nil wain sin kabe ta ire, maki ye God tere suule obin si yal kobe tongure yal kobe para wen nongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nongure yalini iru di tongwa, “Ibal kobe binanbile God bole guman kane ire u taran nama dire na inan mayan garu diralwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na kawen dirala i piro. Malia na nil wain nega mere iru ta ama nekeralba, God kenin ere ke milungwa ai pi milalga eme kwi neralwa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dire yal kobe geril ta di pisere ere malge pire kamin kuul Olibe ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ena Yesu iru di gawlima kobe tongwa, “I yal kobe para nigi de pire na tere u sutaw nanwa. God mile, ‘Na bolima siipe siipe kenin erungwa yal sirabingire, bolima siipe siipe u sutaw namua,’ dungure ka main minin ganin iru bilungwa mere u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Iru dinamba na gulere alalga God iru erangure pare, na Galili gariba gul goma egire i eme unanwa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dungure Pita maan iru dungwa, “Yalin kobe nigi de pire i tere u sutaw namba, na iru ta pire i tekeralwa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dungure Yesu iru di yalini tongwa, “Na kawen i inin di terala piro. Kemina gilaa sia korale ginin sutan be dirala di erangwa, i ginin sutakobe na kaanan di aal kule, ka di kile di mena ere na tenanwa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yesu iru dimba Pita ka dagi dire maan iru di tongwa, “I kaanin di aal kule i teralga, main iru ta paikimua. Iru tekiralga ibal kobe na i bole para na si gulangwa ena para waiwe. I ka di kile di mena ere i tekeralwa.” Dungure ena gawlima kobe Pita dungwa mere para iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ena yal kobe pi eri main ta kaan Gesemani ongure, Yesu iru di gawlima kobe tongwa, “Na ana di God terala erebina i maina amin di milo.” ");
INSERT INTO gvf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Direre Pita te Yemis te Yon awli baan ta pirere, suna ku ku maa ungure miriin pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Milere iru di yal sutakobe tongwa, “Na inan miriin bilkaw pire milere, gulalga mere piriwa. I abila mile el kwi nu milo.” ");
INSERT INTO gvf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Direre baan ta pi bawa dire yaa i kwi bile ana di God tere iru dungwa, “Giil ta pirekerala di pirigire, i aa ki di na terala di piringa aa ki di na to.” ");
INSERT INTO gvf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Di tere iru dungwa, “Abe, na Abe, kalkan para muru eranga i kuunin biimua. Giil malia na piralga pirekerala di pire iru ere na tenanba, painama di pirangire ena giil piralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dire pare urere, yal sutakobe ul pai milungwa kanere ulin yuure iru di Pita tongwa, “Saimon, i ul pai milino? Kaun tawlita kwi mile paikino? ");
INSERT INTO gvf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Satan i kiranin sire kela kule tenangure i manaa dirala dire, i ul paikire si kwi ye mile ana morin di God te milo. I nomanin iru si piringa, na yobilaan biliga eralwa di pirinba gain obin domua.” ");
INSERT INTO gvf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Direre kwi pire ana goma dungwa mere kwi dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dire pare sinaa dire kwi ure yal sutakobe omilin meru dimia, ul pai milungwa kanungwa. Kanungure yalini ka di tenamba, gay gulere pire unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Goma ginin sutan ongwa malia kwi urere iru di yal sutakobe tongwa, “I yal kobe ul painga iray kwi paino? Ena parawe. Na U Ibal Obinga Yal, yal ta bale taal sinangure kal digan ere taalime erungwa yalin kobe na sinangwa kaun u maala omua. Ale ere nabina wo. ");
INSERT INTO gvf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bale taal na sinangwa yal kaya maala umia, kano,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ena ka iru di milungure gawlima kobe anan kole kole muru kawnan milin sutan yal ta kaan Yudas, te ibal binanbile para, kuba te di kuba pera aa te ire u milungwa. Yuda ka main kenin erungwa yal bil kobe, te nil si tongwa yalin kobe, te singaba kobe nusi erungwa u milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ena bale taal sungwa yal goma iru di ibal kobe tongwa, “Yal ta guman mu diralga, yalini yal iray milamua. Iru kane aa gi di mile kanin si awli po.” ");
INSERT INTO gvf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dire u bawa dire gin taran Yesu milungwa gul pire, “Singabo,” dire guman mu dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dungure Yesu aan aa gi dire kanin sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Simba yal ta main i milungwa di kuba pera i maribe ere Yuda kenin erungwa yal bil, yalini nil konagi yal ta, kiraan dual kule erungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Erungure Yesu iru di ibal kobe tongwa, “I di kuba pera te kuba ire unga, komina kunibe nongwa mere iru kuunin ta milebinga kanin na kulala dire uno? ");
INSERT INTO gvf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yuda ibal ka main ogu bil kaun kaun ka nil si te milebinga, na kanin ta sikingirawa. Ibal kal main ere na terala dungwa, ka main minin bilungwa mere u maribe nangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dungure gawlima kobe para, yalini pisere si ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yal garamil ta Yesu duulin bile ongwa, gal abilabe tawle pirere ongure, yalin kobe yal i aa gi di kanin sinamba ");
INSERT INTO gvf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","gal abilabe kurige si ingure yorawan bole si ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ena yal kobe Yesu awli pi Yuda ka main kenin erungwa yal bil milungwa gul ongwa. Ongure Yuda ka main kenin erungwa yal bil kobe, te singaba kobe, te nil si tongwa yal kobe para u ku bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Milungure Pita tayan mile duulin bile pire, kenin erungwa yal bil ogin malge pi bawa dire ere suna ongwa. Pirere el kwi nu milungwa yal kobe bole para enderin maala amin di milere, enderin pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kaun iray kenin erungwa yal bil kobe te u ku bilungwa ibal para muru, Yesu si gulala dire ka digwane waa Yesu tenangwa, ka iray yalin kobe waa duungwa. Waa duumba, kol ta i maribe erekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ka kole kanungwa ibal binanbile ure kakiibi dimba, ka di inin inin erere ka dungwa u taran pekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ka kol kanungwa ibal taw kakiibi dire iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yesu iru dungwa na piriwa. ‘God ka main ogu bil ibal kiingwa na sulalwa. Sulere pare, kaun sutakobe tawle na inan kwi kiiralwa. Ibal kobe ta kiinangwa kuunin paikimua,’ Yesu iru dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Iru dimba ka dungwa main i u taran pekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yuda ka main kenin erungwa yal bil ibal kobe suna ali alere sirin bile Yesu tongwa, “Maan dinanga ka ta dekino? Ka kol kanungwa yal kobe di maribe erungwa tamintan mere dime?” ");
INSERT INTO gvf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Iru sirin bilimba, yalini pire unin si milere waa dire ka ta dikimia. Kenin erungwa yal bil kwi sirin bile tere iru dungwa, “Deminin si tobinga yal, God Wan kaan Kirisito, yalini i milino?” ");
INSERT INTO gvf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dungure Yesu en dire iru dungwa, “Yalini na miliwa. Na U Ibal Obinga Yal, God Yobilaan Wen Kobaan aan wen kol amin di miliga kanere, te kawa bolimina urabinga para kananwa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dungure kenin erungwa yal bil gal suna aa te ole dire iru dungwa, “Ka kol kanungwa yalin kobe tameran ka kwi diname? ");
INSERT INTO gvf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yalini inin God gain ka simua. I takal waa di nomanin si pirine?” Dungure ibal para u taran pire iru dungwa, “Yal ki ere milungwa, si gulo.” ");
INSERT INTO gvf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ena yal taw kobe ebil sipa di Yesu tere, yalini omilin guman mina a daw si mile de dagi sire iru di tongwa, “Sungwa i, ibena i sime? Ka kebe yal dungwa mere bolin kule di maribe ero.” El kwi nu milungwa yal kobe para ure yalini de dagi sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ena Pita malge yene i milungure kenin erungwa yal bil, nil konagi gi ta urere, ");
INSERT INTO gvf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita enderin pirungwa kanere, tena yulin bile kane iru dungwa, “Nasarete nen Yesu milungware i bole para milinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dimba yalini ka di kile di mena ere iru dungwa, “Na kanigiraba i ka dinga i pirekun erekiwa.” Dire pare pi kana giran maala ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ongure nil konagi gi ama kanere kwi ama di ibal maala milungwa iru di tongwa, “Yalini Yesu enin taw kobe milemua.” ");
INSERT INTO gvf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dimba, yalini kwi ama ka di kile di mena erungwa. Kaun tawliga mile pire yal kobe maala milungwa iru di Pita tongwa, “I Galili nen milinga, yalini i enin taw kobe milinwa. Ka di i tobinga i kawen di tobinwa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dimba yalini ka nigi dongwa dire iru dungwa, “God mabin mina kawen di tekerala God na sinangwa paamua. Yalini i kane dinga na guman ta kanekigirawa.” ");
INSERT INTO gvf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dungure sia korale gin taran kwi be dungwa. Dungure Yesu goma ka iru di Pita tongwa, “Sia korale ginin sutan be dirala pirangwa i ginin sutakobe na kaanan di aal kule, ka di kile di mena ere na tenanwa,” dire Yesu goma iru di Pita tongwa nomanin si pirere kay mun bile yaare simil kay miingwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ena kwimile taanima u bawa dungure Yuda ka main kenin erungwa yal bil kobe, te singaba kobe, te nil si tongwa yal kobe, te u ku bilungwa ibal kobe imo milungwa para, u ku bile diria ere milungwa. Milere Yesu aan kan kule yerere awli Pailete milungwa gul pi tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tongure Pailete sirin bile yalini tongwa, “I Yuda ibal yal bil wen milino?” Dungure Yesu maan dire, “I iru dinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ka main kenin erungwa yal bil kobe ka digwane waa tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailete kwi iru sirin bile Yesu tongwa, “I ka maan ta dikino? Ka binanbile digwane waa i tongwa kanekino?” ");
INSERT INTO gvf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dimba, Yesu ka maan kwi di tekungwa Pailete aya dire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ena ibal para komina bil si gale nere milungwa kaun kanin paangwa yal ta ibal para gala dire, “Na to,” dungure, dungwa kaun i Pailete morin kanin gule ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yal ta kaan Barabas, gabman bole kura bile yal ta si gulere, kanin pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ibal binanbile u ku bilungwa Pailete milungwa gul urere iru di yalini tongwa, “I goma kanin gule ere na tenga mere, malia kwi kanin gule ere na to.” ");
INSERT INTO gvf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Dungure ka main kenin erungwa yal bil kobe san bale Yesu tongwa Pailete kanere, yalini sinaa dire iru sirin bilungwa, “Yuda ibal yal bil wen kanin gule erabino?” ");
INSERT INTO gvf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dimba ka main kenin erungwa yal bil kobe ibal binanbile u ku bile milungwa, den ali baale woongure iru dungwa, “Barabas gule ero.” ");
INSERT INTO gvf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailete ka kwi di ibal kobe tongwa, “Yal ta i Yuda yal bil wen kaan galinga, takal ere yalini terabine?” ");
INSERT INTO gvf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ibal kobe kwi iru gala dungwa, “Eri pera mina si gulo.” ");
INSERT INTO gvf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Dungure Pailete iru dungwa, “Tameran ka iru dine? Takal erungwa ki ereme?” Dimba ibal kobe kwi ama bilkaw iru gala dungwa, “Eri pera mina si gulo.” ");
INSERT INTO gvf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ibal binanbile u ku bile milungwa wai wen pirama dire, Pailete Barabas kanin gule ere tongwa. Terere, “Kuba galan yongwa Yesu gain mina so,” dungure sire eri pera mina si gulama dire simil nen awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ena simil nen Yesu awli ire, singaba bil ogu kaan Piretorium suna pirere, simil nen taw imo milungwa, “Ere wo,” dire gala dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Direre galsuna nobe kuunin dungwa sigi di tere, kan galan yongwa galin ware gibilin mina kaw tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Terere kakiibi dire deminin si tere iru dungwa, “Ayo, Yuda ibal kobe yal bil wen irawe.” ");
INSERT INTO gvf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Direre yalin kobe Yesu gibilin kuba si mile ebil sipa di tere, yaa gobin bile milere kakiibi kol deminin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iru erungwa ka di sutaw ere terere pare, galsuna nobe kuunin dungwa gule erere, inin gal sigi di tongwa. Terere eri pera mina si gulama dire awli mena ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ena awli ongwa kaun Sairini yal ta kaan Saimon konagi erungwa pisere ungure, simil nen “Eri pera kawi ire po,” di yalini tere sire anu si erungwa. Yalini wan sutan Alekandiria te Urupas kule yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Simil nen kobe gariba kaan ta Golgota Yesu awli ongwa. (Gariba iray Golin ka iru main paangwa, ibal gibilin yobilaan ai mere dungwa.) ");
INSERT INTO gvf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ibal kobe wain nil irere madasin ta kaan mira bole para nuure, yalini tomba Yesu ire nekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ena yalin kobe Yesu aan kawn eri pera bolimina bili nil sirere, yalini gal ta ta obin si irala dire sandu sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kwimile are suna ungure eri pera bolimina sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ka digwane waa tongwa ka minin ganin iru bilungwa, “Yuda Ibal Yal Bil Wen Yalini Milemua.” ");
INSERT INTO gvf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kunibe nongwa yal sutan Yesu daan kole kole, para eri pera bolimina sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO gvf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ibal kobe wiria di kanere gain ka si tere gibilin gima dire iru dungwa, “Aye, i ‘Yuda ka main ogu bil si sulere are kaun sutakobe kwi kiiralwa,’ dingiray. ");
INSERT INTO gvf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mile pairala di piranga eri pera pisere yaa main som mo.” ");
INSERT INTO gvf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yuda ka main kenin erungwa yal bil kobe, te nil si tongwa yal kobe bole para ka di sutaw ere tere iru dungwa, “Yalini ibal kobe aa ki dungure u wai omba, yalini inin aa ki dekenangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yal i Kirisito Isirel ibal yal bil wen milanga inin eri pera pisere yaa main som mo. Sinanga kanere pire gi di i terabinwa.” Dungure yal sui bole para eri pera mina pai milere para, gain ka si tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ena are kamin suna wen ungure kamin si bilungwa. Si bile dungwa dungwa pu dungwa are pera ongure, kamin kwi aw dungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pu dungwa are pera ongure Yesu gala bilkaw dire iru dungwa, “Eloi Eloi alama sabakatani?” Ka dungwa main iru paangwa, “Na God, na God, tameran na piserine?” ");
INSERT INTO gvf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dungure ibal taw maala milungwa pirere iru dungwa, “Ilaya di gala dimia piro.” ");
INSERT INTO gvf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dungure yal ta mugu di pire nil kule nongwa gal niriin gi kiingwa kulere, bili waa ki dire Yesu nenama dire tere iru dungwa, “Kane milo. Ilaya ure yalini i main eram mo, erekinam mo, kanabine?” ");
INSERT INTO gvf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dungure Yesu gala bil dire gulungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gulungure gal bilkaw Yuda ibal ka main ogu bil, God kegemama yongwa ai si pere dungwa, mine aa dina di yene piraa sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gulungure simil nen kenin erungwa yal kanere iru dungwa, “Yalini God Wan kirara kawen milemua.” ");
INSERT INTO gvf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Abal kobe taw tayan kane milungwa. Milungwa suna i Madala ai abal Maria milungure, te Yose te kebin Yemis yal sui man Maria milungure te Salome bole para milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abalin kobi Yesu Galili milungwa, duulin bile pirere aa ki di tongwa. Yerusalem ai abal miriki wen Yesu ereko ungwa, para milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ena Arimatia ai nen Yosepe, yalini ibal taminin bile milere guun kan warungwa. God kenin ere ke milungwa kaun unangwa yalini suul milungwa. Sare kaun u maala ongure ibal kobe kalkan aa tekun erungure, kamin pu dungwa wei sungure si bilala di erungwa. Yalini yobilaan bile Pailete milungwa gul pirere, Yesu yobilagi irala dire sirin bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bile tongure kaya gulem mo gulekim mo, Pailete nomanin si milere simil nen kenin erungwa yal, “Ere wo,” dire yal ta nusi erungure ungure, Pailete sirin bile pirungwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pirungure simil nen kenin erungwa yal “Gulemua,” dungure Pailete Yesu yobilagi Yosepe tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tongure yalini gal pege wai gibilin sire yalini Yesu mone di i main erere, gal pege wai werere inin kobile giran ibal woole tongwa, ali yongwa. Yerere pare kobile milin bilkaw kana giran bile pera di yongwa. ");
INSERT INTO gvf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Madala ai abal Maria, te Yose man Maria bole Yesu yongwa ai kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ena are yaa biingwa Sareba kaun kaya wei sungure, Madala ai abal Maria, te Yemis man Maria, te Salome pi Yesu gain mina kabe si terabina dire, eri niriin minanin wai sungwa gibilin sungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sungure Sarebil kaun taanima wen are nol erungure, abalin kobe ere yobilaan gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pire inin diria ere iru dungwa, “Kobile ta yobilaan gul kobile giran si pere dungwa, ibena yawle na tename?” ");
INSERT INTO gvf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Direre kobile bilkaw dungwa tena yulin bile kanimba, kaya yawlungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yobilaan gul kobile giran ala pirere yal garamil ta abal kobe aan wen kol amin di milungwa, te gal pege sigi dungwa kane buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yalini iru di abal kobe tongwa, “I kane buul kunekio. I Nasarete nen Yesu, eri pera mina si gulungwa yal iray, kanala dire unwa. Yalini abila ta milekemia, kaya ale ere omua. Yalini yongwa gul kano. ");
INSERT INTO gvf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","I pi gawlima kobe te Pita iru di to, ‘Yesu goma dungwa mere, Galili gariba gul goma egire i eme unanwa,’ dire iru dungwa mere i pi main iray kananwa.” ");
INSERT INTO gvf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dungure abal kobe kuril pirere kalgane irere, yobilaan gul kobile giran malge pire si ongwa. Kuril pire milungwa ka ta dikire, pire unin si mile ere ongwa. Ena para. ");
INSERT INTO gvf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ena Yesu gulere si kwi yere alere pare, Sarebil kaun i, kwimile taanima wen Madala ai abal Maria, yalini kanama dire i maribe erungure, abalini goma kanungwa. Goma sia anan kole muru kole sutan abalini den miriin suna milungure, Yesu sia iray maa si mena ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Yesu goma kanere pi yalini duulin bile warungwa ibal di tongwa. Di tongwa kaun i, yalin kobi kay mun bile yaare kay miingwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kay miingure Maria ure, “Yesu gulere kaya alungwa na kanere wiwa,” dimba, yalin kobi abalini kawen dima di ta pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ena Maria di tongure pare, Yesu gawlima sui Yerusalem pisere ere baan ta nala di ongure, Yesu goma i maribe ere Maria tongwa mere, iru ta erekire, yal sui milungwa gul u bawa dungure kanungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kanere kwi sinaa di pire gawlima kobe imo milungwa di tomba, yalin kobe yal sui kawen dima di ta pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ena ginin sutan di tongure eme Yesu gawlima anan kole kole muru kawnan milin taran komina ne milungwa kaun, Yesu u bawa dire iru di tongwa, “Ibal taw kobe na aliga i maribe ere kanere, ‘na alemua,’ dungwa kawen dima di ta pirekino? I pi tegi ye na tekino?” dire kan tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesu ainere iru dungwa, “I yal kobe gariba ulin kole kole para pire na guunan kanan kere di tenana po. ");
INSERT INTO gvf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ibal ta pi tegi ye na tere nil bile inamia, ena God aa ki di ibalini tenangure sigare kule u wai namua. Namba ibal ta pi tegi ye na tekenamia, ena kal digan erungwa pirin pai imo dinangure, God ka kol ere tere giil pire tenamua. ");
INSERT INTO gvf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ibal kobe pi tegi ye na tenangwa ena ibalin kobe yobilaan bile kal main iru i maribe eramua. Na kaanan gale sia maa si mena erangure, te kaun ta ta inin ka pisere ka kowa ta pirekire gogo yuure dinangure, ");
INSERT INTO gvf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","te oniba aan aa tere, ibal si gulangwa nil ta nenamia, ena ta gulekinangure, te ibal nibil erungwa gain mina aa tenangwa ena nibil erungwa ibal i u wai namua,” dire Yesu iru di tongwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ena Yesu Singaba ka di pisere God aa ki di yalini tongure, ere kamin mina ongwa. Pirere God aan wen kol amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Milemia Yesu gawlima kobe gariba para u kole kole pire, ka main kere di ibal tongwa. Kere di tongure, ibal kawen pirama dire Yesu Singaba aa ki di tere, yobilaan bile tongure, kal guman kwi dungwa erungwa kanungwa. Ena para. ");
INSERT INTO gvf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiopilas yal singabo, ena na ibal kobe milebinga gul suna i God kalkan erungwa u maribe ongure, ibal binanbile ka pore minin ganin bile paalala di erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","U maribe ongwa kalkan i kawn kule erungwa kanere, kani ongwa ongwa ka main kere di na ibal kobe tere, ena yalin kobe di maribe erungwa mere minin ganin bile paalala di erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ena na baan araway kal iru para kirara kaniga, ena na ama kalkan i u maribe ongwa kaniga mere, ka pore bile i terala di piriga. ");
INSERT INTO gvf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nil si i tongwa mere kirara kawen pirana dire bile i tega. ");
INSERT INTO gvf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ena Yudia ai yal bil kaan Kerodi milungwa kaun iray, Yuda ka main kenin erungwa yal ta kaan Sekaraya milungwa. Milere Abaisa gawliman milungure, te ebinbi para Eron gawliman kobe kule nongwa milungwa. Abalini kaan Ilisabete milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Milere yal abal sui kabin sire wai wen ere milungwa God iru kanungwa. Kanungure ibal sui God Singaba kile kaman ka main paangwa mere duulin bile piremia, ena pirin ta pai tekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pai tekimba, Ilisabete abal temine milere, te winbi bole bia yongwa gaan ta kule yekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekaraya gawliman kobe konagi kawn kule erere, ena Sekaraya inin ka main konagi ere God te milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Milungwa kaun iray ka main kenin erungwa yal kobe main erungwa mere, yal ta kaan u maribe nangwa pirabina dire sandu sungure, Sekaraya kaan u maribe ongwa. Ongure ena yalini God ka main ogu bil ala pire, enderin enigi minanin wai wen sungwa gale paalala di galungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Enderin galungwa minanin wai sungwa kaun i, ibal binanwenbile malge mile ana di God tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Milungure ena enderin galungwa minanin wai sungwa bol mina kol i, God Singaba angel ta u maribe pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Milungure Sekaraya kanere, sipile dire kuril wen pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pirimba, angel iru di tongwa, “Sekaraya, i kuril ta pirekio. I ana dinga God kaya piremua. I ebininbi wan ta kule yenangure, ena kaan Yon yeyo. ");
INSERT INTO gvf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ena i wai pire miinin maanangire, te gaan kulanga kaun ibal para wai wen piramua. ");
INSERT INTO gvf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wai wen pirangwa main iwe. God wai pire gun ye yalini tenangure, te nil wain te nil gi kiingwa para ta nekenamua. God Kegemama Iban yalini den miriin suna u painangure, sipapa sire yobilaan bile tenamua. Yalini man den miriin suna milungwa para iru milamua. ");
INSERT INTO gvf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yalini ka di Isirel ibal tenangwa ena ibalin kobe binanbile den miriin suna si kiruul sire pire gi di God tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yalini goma yere God ka kebe yal milere, Ilaya yobilaan bile niminin milungwa mere milamua. Nen wan u taran nama dire, te kule sungwa ibal nomanin si kiruul sire, kwi u wai nama dire konagi iru eramua. Eramia ena God konagi erungwa yal, Kirisito unangwa kaun ibalin kobe nomanin naabile aw dinamua. Kal iru ere milangwa, ibal para wai wen piramua.” ");
INSERT INTO gvf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dungure pare, Sekaraya iru di angel tongwa, “Na yal dimanin miliawa, te ebinanbi bia yomia, i ka dinga, takal u maribe pi na tenangwa kanale?” ");
INSERT INTO gvf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dimba angel maan dire iru di tongwa, “Na kaanan Gabiriel miliwa. Te God guman mina na morin morin ale miliga yal miliwa. Ka wai wen di i tenama dire na nusi erungure wiwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ena i iru piro. Ka di i tega i, kaun ta u maribe namba i nomanin si pire gi dikinga, ena i du mile ka ta dekenanwa. Ka ta di i tega u maribe nangwa kaun i kwi ka dinanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dungwa kaun i, ibal kobe Sekaraya wekungwa suul mile iru di pirungwa, “Sekaraya ka main ogu bil baan araway milungwa, tameran baan araway mileme?” ");
INSERT INTO gvf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ena yalini ere mena ure ka dala di erimba dekungwa. Iru milungwa ibal mile, “Kamin kal kanemua,” di iru pirungwa. Yalini aan paale kole kole erere, du dungwa mere milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Milere konagi i ere wei simia ere ogin ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pirere kaun taw milungure, ebinbi Ilisabete digan sire gun yere ba anan kole muru aal kule milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Milere iru dungwa, “Na iru miliga God Singaba kal wai ere na tomua. Ibal nigi de pire na tongwa wei simua.” ");
INSERT INTO gvf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ena Ilisabete digan sungwa ba anan kole muru kole taran wei sungure, God angel ta kaan Gabiriel nusi Galili gariba gul ogu ai ta kaan Nasarete erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nusi erungure Yosepe gi ta tobe kaya tongwa, gi iray milungwa gul ongwa. Yosepe Debiti gawliman milungure, te gi ta i kaan Maria milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel ure iru di abalini tongwa, “I mile dinio. God Singaba i bole mile pai ere wai pire i tomua.” ");
INSERT INTO gvf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dimba, abalini nomanin si ala ere iru pirungwa, “Yalini di na tongwa main paangwa we.” ");
INSERT INTO gvf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angel iru di abalini tongwa, “Maria i kuril ta pirekio. God aa te wai ere i tomua. ");
INSERT INTO gvf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","I digan sire wanin ta kule yere kaan Yesu yenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yalini yal singaba milangure, te ibal kobe mile, ‘God Yal Bil Wan milemua,’ iru di yalini tenamua. Yalini sanamoi Debiti yal bil milungwa ain yalini pi milangwa, God Singaba iru ere tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tenangure yalini Yakobo gawliman kobe kenin ere ke mile milangwal milamua. Ke mile milangwa kaun wei ta sekenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dungure Maria iru di angel tongwa, “Na gi imore miliwa. Yal ta na ikigirawa. Tameran kalin kan dinga i u maribe name?” ");
INSERT INTO gvf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dungure angel maan dire iru dungwa, “God Kegemama Iban ere ime ure i den miriin suna nangure, te God yobilaan bile kuman kinin si i tenamua. Tenamia ena gaan i kule yenanga ibal mile iru dinangwa, ‘Kabin sire wai wen milungwa yal mile, God Wan milemua.’ ");
INSERT INTO gvf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","I iru piro. I yaalin Ilisabete abal dimanin milimba, digan sire wan ta kule yenamua. Te ibal mile, ‘Abal temine milemua,’ dimba digan sungwa ba anan kole muru kole ta milemua. ");
INSERT INTO gvf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God kalkan para wen erala di pirangwa, ena erangwa painamua.” ");
INSERT INTO gvf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dungure Maria iru dungwa, “God Singaba nil konagi abal na miliwa. I ka dinga mere u maribe nangwa, ena painamua.” Dungure angel ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ena kaun iray Maria gin taran pi kamin kuul dungwa gul pire, ere Yudia ibal ogu ai ta ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pirere Sekaraya ogin ala pire, “Abalkuno,” di Ilisabete tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria, “Abalkuno,” di tongure Ilisabete pirungure, ena gaan den miriin suna milungwa sibe sungure, God Kegemama Iban pi Ilisabete den miriin suna u paingure, yobilaan bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ilisabete gala dire iru dungwa, “God kal wai ere abal kobe tomba, yalini kal para wai wen ere i tomua. I gaan ta kule yenanga, God kal para wai wen ere yalini tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na Singaba man na miliga gul i unga we. Ayo, na abal digan miliga i kal para ere na tomio. ");
INSERT INTO gvf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ena i, ‘Abalkuno’ dinga kiranan piriga kaun, na gaan denan miranan suna milungwa wai pire ole sire sibe binanbile simua. ");
INSERT INTO gvf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","God Singaba kal iru ere i terala dire aan kere ye i tongwa pi nima nangwa pire gi dina, ena i miriin paamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ena Maria ka iru dungwa, “Na denan minan wai ye God Singaba teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","God na aa ki di na tomia, sigare kule u wai ega na wai pire God teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na yalini nil konagi abal na miliiba, piranan pai na tomua. Malia te eme para ibal kobe para mile, ‘Abal miriin paamua,’ iru di na tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","God niminin wen milere kal para wai ere na tongwa, iru di na tenamua. Yalini kaan pi nima pire, kabin sire wai wen milangwal milamua. ");
INSERT INTO gvf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gaan kule aine aine mili nangwa, ibal kobe kamin kaun para yalini kuril di kanamia, ena yalini miriin pire ibalin kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","God yal naanin paire konagi niminin mile ere milemua. Ibal kobe gain deminin sire inin miinin maangwa milungure, ena yalini nusi sutaw eremua. ");
INSERT INTO gvf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ibal maangwa pi yal digan omba, ibal yaangwa pi yal singaba ongwa yalini iru eremua. ");
INSERT INTO gvf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kenan gule milungwa ibal keba komina tongwa nomua. Nomba kal aa te nongwa ibal kal ta tekire, imore nusi erungwa ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Isirel ibal kobe miriin pire tongwa nomanin si pire ibalin kobe aa ki di tomua. ");
INSERT INTO gvf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ka di na sanamoi Ebarakam te yalini gawlin kobe tongwa mere, aa ki di tomua.” ");
INSERT INTO gvf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Dire Maria Ilisabete ogin mile paangure, ba sutakobe wei sungure ena kwi inin ogin ain ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ena kulangwa kaun u maala ongure, Ilisabete mile wan ta kule yongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","God Singaba miriin wen pire abalini tongwa, ibal maala ki paangwa, te enan kobe bole pirere Ilisabete para wai pire miinin maangwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ena gaan i are kaun anan kole muru kole sutakobe wei sungure, gain bile ere tenama di ure nen kaan Sekaraya yerala di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pirimba, man manaa dire iru dungwa, “Yalini kaan Yon yerabinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dungure ibal kobe iru di tongwa, “I enin kobe goma milungwa kaan aine iru ta yekimua.” ");
INSERT INTO gvf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dire gaan nen kaan ta yenama dire, ibal kobe aan paale kole kole ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Gaan nen kaan bile terala dire aan paale tere iru bilungwa, “Yalini kaan Yon yomua.” Iru bilungwa ibal kobe pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ena kaun wen iray Sekaraya girabilin aw tongwa u wai ongure, kwi ka dire deminin si God tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tomia ena maala ki paangwa ibal para muru kuril pirungwa. Kalkan erungwa i guun kan Yudia ibal kamin kuul kole kole para pire kuunin erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kal erungwa i, pirungwa ibal pire nomanin suna yere iru dungwa, “Gaan i ta konagi mere ere milame?” God Singaba niminin mile gaan i aa ki di tongwa ibal kanere, iru pire dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ena God Kegemama Iban gaan nen Sekaraya nomanin suna sigi dungure, ka main kere di maribe ere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Na Isirel ibal kobe Abe, God Singaba deminin si yalini terabinwa. Yalini na ibal kobe aa ki di na tere tobe tongure, ere ain obinwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yalini nil erari yal Debiti gawliman kobe ta aa ki di na ibal tongure, sigare kule u wai pi milama dire, malia i maribe ere na ibal kobe tomua. ");
INSERT INTO gvf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kamin kaya wen ka kebe yal kobe kabin sire wai wen milere, goma ka di paalungwa kamin kaun maliaga u maribe omua. ");
INSERT INTO gvf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yalini na kayminan ibal si i sutaw ere tongure, na ere ainan ubinga, te den ki ye na tongwa ibal yalini ai yebe di na tongwa, ‘Iru ere i teralwa,’ dire aan kere ye na ibal kobe tomua. ");
INSERT INTO gvf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Miriin pire na sanamoi gilekume teralwa dire, te ka wai di bole pena gale i terala dungwa, yalini aan kere ye na ibal kobe tomua. ");
INSERT INTO gvf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tongwa mabin mina aa taw sire, ‘Iru eralwa,’ dire aan kere ye na sanamoi Ebarakam tere iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘I kayminin ibal i aa gi di milangwa, ena kayminin si i sutaw ere terabingire i ere ainin unanwa. Unanga kuril pirekire konagi ere na tenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Terere kabin sire wai wen mile, mile ere nil konagi na te milangal milanwa,’ dire God iru dimua. ");
INSERT INTO gvf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Gaan ta milingi ka di i terala piro. ‘God niminin milungwa ka kebe yal i milinwa,’ dire ibal iru dinamua. I goma yere aa tekun ere kol bala di Singaba tenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","‘Ibal kobe kal digan ere taalime erungwa, God kire di ere aa ki di tenangure, sigare kule u wai pi milanwa,’ dire iru di God ibalin kobe tenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kamin taarala di aw dungwa mere, God miriin pire na ibal kobe tere aa ki di tenangure, sigare kule u wai pi milabinwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Te ibal si bilungwa gul milere gulala di kuril pirungwa, yalini aw bil di na ibal kobe tenamua. Tenangwa kol wai ta i maribe ere na ibal tenangure, duulin bilabinwa.” Dire Sekaraya ka iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ena gaan i bil galere nomanin paangwa yal milungwa. Milere gariba simi yongwa mili ongwa ongwa, eme yalini Isirel ibal milungwa suna u maribe ongwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ena kamin kaun iray Orom yal bil Sisa Ogastas ibal kobe baan baan para kenin ere ke mile milere, kaan bile paalala dire gala di kole kole erere kaman tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kaan bilungwa kaun i, gabman yal singaba ta kaan Sairinias milere, Siria gariba gul kenin ere milungwa. Goma ibal kaan ta bilekire, malia kawn kule ere bilungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iru eremia ibal kobe para kaan gale terala dire, ere inin ogin malge ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ena Yosepe Nasarete ogu ai Galili gariba gul suna dungwa pisere, pi Betelekem ogu ai Yudia gariba gul suna dungwa ongwa. Yalini sanamoi gilekume Debiti garibanin dimia, ere Betelekem ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yalini gi ta tobe kaya tongwa abalini kaan Maria, bole para kaan gale terala dire ongwa. Abalini digan sire ");
INSERT INTO gvf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ere Betelekem ogu ai ongwa kaun gaan kulala dire, gain giil pire ");
INSERT INTO gvf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","wan kominin kule yere gal yobilungwa. Kombil baan ogu kaya di dimia, ena bolimakau ki paangwa ala pire gaan i kule yere gal yobilere, bolimakau komina nongwa bol mina yongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ena gariba gul iray, bolima siipe siipe kenin erungwa yal kobe miina kol mile, gilaa konagi ere ke mile milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Milungure God Singaba angel ta ungure, te God Singaba naabilungwa aw di yalin kobe milungwa gul tongwa, ena kuril wen pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pirimba, angel iru di tongwa, “I kuril ta pirekio. Na ka pore wai ere i terala di wiwa. Ibal para muru pirangwa, miriin paire para gun yenamua. ");
INSERT INTO gvf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","I sanamoi Debiti ogin ain gilaa iray, gaan ta kule nomia. Gaan i God konagi erungwa yal, Kirisito Singaba milere aa ki di i tenangure, sigare kule u wai nanwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Gaan ta gal yobile bolimakau komina nongwa bol mina yongwa, i pi waa duu kanana, ena na kawen dima di piranwa.” ");
INSERT INTO gvf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dire angel dungure pare, ena kamin ai angel kobe miriki wen gin taran u bawa dire, deminin si God tere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kamin gul mine wen ibe God deminin si tobingire taran milemua. Milere ibal wai pire tongure, ibalin kobe den miriin suna ura dinangure, yaa ime si milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ena angel kobe yalin kobe milungwa gul i pisere kwi ere kamin ai ongure, bolima siipe siipe kenin erungwa yal kobi ka diria ere iru dungwa, “‘Kal ta u maribe omua,’ dire God Singaba iru dungwa pirebinga iray, inin pi Betelekem ain pi kanabina nabina wo.” ");
INSERT INTO gvf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dire mugu di pire waa duure kane kole kole erere, Maria te Yosepe kanere, te gaan i bolimakau komina nongwa bol mina pai milungwa para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kanere gaan i milungwa, angel di yalin kobe tongwa mere, di maribe ere ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tongure pirere, ena ibal para nomanin si gogo erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ka dungwa i Maria pirere, nomanin si suna yere pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ena bolima siipe siipe kenin erungwa yal kobi sinaa dire kwi ere ain pire, di tongwa kanungwa mere God kaan ai yebe dire deminin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Are kaun anan kole muru kole sutakobe wei sungure, gomege gain bile erangwa kaun u bawa dungure, nen man kaan Yesu yongwa. Kaan iwe, man digan ta sekungwa kaun, angel goma “Kaan i Yesu yeyo,” di tongwa kaan iray yongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mose kile kaman ka dungwa mere, Yosepe te Maria bole nomanin suna eme wai painama dire, kamin kaun taw imore mile paangwa. Mile paire pare ena gaan awli pi Yerusalem pire, God Singaba gun ye gaan i tenama dire awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","God Singaba kile kaman ka iru bilungwa, “Wanin kominin kule yenanga ena gaan i God Singaba tenanwa.” Iru bilungwa mere ere terala dire awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","“Imil sui mo te mulu sui si gale to,” dire God Singaba kile kaman ka bilungwa mere, yal sui kabe si gale God terala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ena Yerusalem yal ta kaan Simion milere, kabin sire ka main wiina pay tongwa yal milere, God aa ki di Isirel nen kobe tenangwa suul milungwa. God Kegemama Iban yalini bole pena gale milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Milere ka iru di yalini tongwa, “I ole gulekingire God Singaba konagi erungwa yal Kirisito, goma u maribe nangire kananwa.” ");
INSERT INTO gvf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","God Kegemama Iban ka di maribe ere Simion tongure, yalini pi Yuda ka main ogu bil ala ongwa. Nen man gaan Yesu awli pi ogu i ala pire, Mose kile kaman ka dungwa mere erala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ongure Simion pire gaan kaale tawal di ire maki ye God tere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“God Singabo, i ka di na tenga mere milin paimia, ena denan miranan yaa ime sire, na baan ta pire gulalga para wai piriwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yal ta i nusi eringa, aa ki di ibal tenangure sigare kule u wai nangwa, maliaga yal iray omilan kaniwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kanigire te gariba ibal kanama dire, i aa tekun erinwa. I iru erina, ena na gulalga para wai piriwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I kol bala di tenga Yuda milekungwa ibal kanama dire, kewa galungwa mere yalini iru milemua. Milemia ena i ibalin kobe, Isirel guun kan waramua.” ");
INSERT INTO gvf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion ka iru dungwa i, Yesu nen man pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kunungure Simion ka wai di nen man te gaan tere, iru di Maria tongwa, “God gaan i paale suna ere ingure, ena Isirel nen kobe taw binanbile maanangure te taw binanbile yaanamua. Ibal pirama dire God gaan i nusi erimba, ibal kobe yalini ka di omilin maale tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tenangwa, ena nomanin suna si pirungwa mere i maribe eramua. Ena iwe, kalkan i u maribe nangwa i kanere miriin giil sinamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ka kebe abal kaan Ana milungure, abalini nen kaan Paniel milere te yalini ibal gawliman kaan bil Asa paangwa. Abal i bia yere me erin anan kole muru kole sutan abalini winbi bole milimba, winbi gulungure, abal weray mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Abalini gariba gul imo mile paangwa me erin iru mere milungwa. Yal sui sui aan kawn muru te yal ta aan milin sui sui, me erin iru milungwa. Abalini Yuda ka main ogu bil milungwal milungwa u miina pikire, girungwa taangwa ana di deminin si God tere, kaun taw komina mawal ere mile ana di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yesu nen man u milungwa kaun i, abal dimanin i u bawa dire maki ye God tere, te God Yerusalem ibal aa ki di tere tobe tongure ere ain nama di pirungwa ibal kobe, abalini Yesu mile pai erungwa main di maribe ere ibalin kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yesu nen man God Singaba kile kaman ka dungwa mere ere pisere, kwi ere Galili gariba gul pire ere ogin Nasarete ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ongure gaan i bil galere, yobilagi niminin milere nomanin paangure, God yalini kenin ere wai wen ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesu nen man me erin kaun kaun Yerusalem pire, Yuda ibal bolima siipe siipe sungure God yalin kobe ta sekungwa kaun, komina bil morin morin nongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu me erin anan kole kole muru kawnan milin sutan u bawa dungure, goma ongwa mere kwi Yerusalem ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Komina bil nongwa i, wei sungure kwi ogin nala di omba, golgan Yesu Yerusalem ai mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yalini nen man pirekun erekire taminin ta bole para oma di pirere, are kaun ta imore warimba, enin kobe te ye nongwa suna kawn kule waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Waa duumba kanekire, sinaa dire kwi Yerusalem ai pire waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Are kaun sutakobe waa duungure pare, yalini Yuda ka main ogu bil amin di mile nil si tongwa yal kobe ka dungwa pirere sirin bile tongwa, nen man urere kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yalini maan di tere ka dungwa milin paingure, ibal para pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nen man bole pire gibilan niman ongure, man iru di yalini tongwa, “Wanane, na i waa duubina, tameran i iru ere na yasu tene? Na i nomanin binanbile sire i waa duubinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu maan dire iru dungwa, “Na Abe ogin milebinawa. Tameran i yasu na waa duune?” ");
INSERT INTO gvf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dimba, yalini ka dungwa yasui pirekun erekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ena Yesu yal sui bole kwi Nasarete ai pire, yasu ka dungwa yalini wiina ere milungwa. Yalini ka dire kal erungwa man nomanin si suna yongwa. ");
INSERT INTO gvf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu baan yere nomanin binanbile paangure, God te ibal kobe para wai pire yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ena yal bil Sisa Taibirias milere Orom gariba gul muru kenin ere milungure, ena bolima ogu anan kole kole muru kawnan milin kole muru wei sungwa kaun iwe. Pontias Pailete singaba mile gariba bilin mege ta, Yudia gariba gul kenin ere milemia, te Kerodi mile gariba bilin mege ta, Galili gariba gul kenin ere milemia, te Kerodi kebinbi Pilipi mile gariba bilin mege ta, Ituria gariba gul te Tirekonaitis gariba gul imu dire kenin ere milemia, te Elaisenias mile gariba bilin mege ta, Abilini gariba gul kenin ere milemia. ");
INSERT INTO gvf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yal singaba iru gariba bilin dungwa dungwa i kenin ere milungure, ena Anas te Kayapas bole Yuda ka main kenin erungwa yal bil milebilga. Yalin kobe milungwa kaun i, ena Sekaraya wan Yon gariba simi yongwa gul milungure, God ka main milin nil si te milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Milemia Yon Yodan nuule kolia kolibe para pire, ka kere di tere iru dungwa, “I nomanin si kiruul singire nil bile tenangure, kal digan ere taalime eringa kire di ere tenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dungwa mere Aisaya minin ganin bilungwa i milin paimia piro. “Gariba simi yongwa gul yal ta iru gala dimua, ‘God Singaba kol bala di tere unangwa aa tekun ero. ");
INSERT INTO gvf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kamin kuul maangwa te kowan yaangwa, si yugu dire si pare kulamua. Kol giingwa si diru dire, te kol maa si yaa si erungwa si pare kulamua. ");
INSERT INTO gvf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","God ibal aa ki di tongure sigare kule u wai ongwa, ibal para wen kanamua.’” ");
INSERT INTO gvf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yon nil bile na tenama di pire ibal binanbile yalini milungwa gul ongwa. Ongure yalini iru di tongwa, “I oniba gawlin milungwa mere ibal digan milingi. I kal digan ere taalime eringa pirin paimia, God i sirala di erungwa ibal ena, ‘Si po,’ di i tome? Si pekenanga kirara i sinangurawa. ");
INSERT INTO gvf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kal digan ere taalime erere nomanin suna si kiruul singire, ibal kawo pirama dire kal wai kwi ero. ‘Na Ebarakam gawliman kobe milebinga, para wai milebinwa,’ dire i yal kobe ka kawn kule iru dikio. Dinanga mere iru na di i terala piro. God kal guman kwi dungwa erama di pirangwa, ena kobile i Ebarakam gawliman kobe u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Di aa tere eri main wiirala di eremua. Eri milin kulekungwa ibal, para muru wiire enderin galangwa paimua.” ");
INSERT INTO gvf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dungure ibal kobe sirin bile iru di tongwa, “Ka dingai na ibal kobe takal erabina pire dine?” ");
INSERT INTO gvf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dungure Yon iru di tongwa, “Yal ta galsuna sutan aa te nenangwa, ena yal ta galsuna ta aa te nekenangwa, yalini ta to. Te yal ta komina taw dinangwa ama iru obin si to. ");
INSERT INTO gvf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kobile takis ingwa yal kobe nil bilala di pire ure iru dungwa, “Ka nil si tongwa yalo, na yal kobe takal erabinga pire dine?” ");
INSERT INTO gvf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sirin bile tongure iru di tongwa, “Kobile takis tobe paalungwa mere iru tawle iyo. I taw kela kule ikio.” ");
INSERT INTO gvf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dungure simil nen taw ure di tongwa, “Na yal kobe we, takal erabinga pire dine?” Di tongure Yon iru dungwa, “Kobile moni kunibe irala dire imore sire te kela kule tere bawle tekio. Aibe tobe paalungwa mere, ‘Para paamua,’ dire ena iyo.” ");
INSERT INTO gvf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ena iru dungure ibal kobe mile kamin ta u maribe nama di pire nomanin si pire iru dungwa, “God konagi erungwa yal, Kirisito Yon i milim mo?” ");
INSERT INTO gvf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dimba Yon iru di tongwa, “Yal ta eme unangwa i yobilaan bil pai tongure, na yobilanan kuunin ta pai na tekemua. Na gal yalini kine teralba, na yal digan mile kuunin ta paikimua. Na nil wo bile tobinba, yalini God Kegemama Iban nusi ere i tenangure, i nomanin sigi dinangwa te nomanin naabilama dire, gaynin enderin denangwa mere God gain giil pire i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yalini dodal milin inama dire olanin pisere, milin komina ogu ala yenamua. Yenamba olanin enderin galangwa de painangwal painamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ibal kobe ka main aa gi di pire milama dire, Yon ka ta ta iru God guun kan kere di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ena gariba gul kenin erungwa yal singaba Kerodi, kebinbi ebin kaan Kerodias ingwa te yalini kal nigi dongwa para erungwa, ena Yon kan tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iru dimia ena Kerodi Yon kanin sire kanin paangwa ogu ala erungwa. Iru erungwa kal main i piril sungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ena ibal binanbile nil bile tere Yon para nil bile Yesu tongwa. Tongure Yesu ana di God te milungwa, kamin aw di ala di kole kole ongure, ");
INSERT INTO gvf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","God Kegemama Iban kauba imil giran guman kulungwa mere, si paale ire Yesu milungwa gul ime ungwa. Ungure kamin mina ka ta iru ere ime ungwa, “I na Wanan taran milinwa. I kanere gun ye wai wen pire teiwa.” ");
INSERT INTO gvf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ena Yesu ka main konagi kawn kule erungwa, yalini bolima ogu yal ta aan kawn muru na anan kole kole milungwa. Milungure ibal kobe Yosepe wan kawo milama di pirungwa. Yosepe nen, Kelai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Kelai nen, Mata milungwa. Mata nen, Ilibai milungwa. Ilibai nen, Melkai milungwa. Melkai nen, Yanai milungwa. Yanai nen, Yosepe milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepe nen, Matatayas milungwa. Matatayas nen, Emos milungwa. Emos nen, Neyam milungwa. Neyam nen, Eselai milungwa. Eselai nen, Nagai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nen, Maata milungwa. Maata nen, Matatayas milungwa. Matatayas nen, Semen milungwa. Semen nen, Yosepe milungwa. Yosepe nen, Yoda milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda nen, Yoanan milungwa. Yoanan nen, Eresa milungwa. Eresa nen, Serababel milungwa. Serababel nen, Sialtiel milungwa. Sialtiel nen, Nerai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai nen, Melkai milungwa. Melkai nen, Edai milungwa. Edai nen, Kosam milungwa. Kosam nen, Elmedam milungwa. Elmedam nen, Era milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Era nen, Yosua milungwa. Yosua nen, Eliesa milungwa. Eliesa nen, Yorim milungwa. Yorim nen, Mata milungwa. Mata nen, Ilibai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ilibai nen, Simion milungwa. Simion nen, Yuda milungwa. Yuda nen, Yosepe milungwa. Yosepe nen, Yonam milungwa. Yonam nen, Elayakim milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elayakim nen, Melia milungwa. Melia nen, Mena milungwa. Mena nen, Matata milungwa. Matata nen, Netan milungwa. Netan nen, Debiti milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debiti nen, Yesi milungwa. Yesi nen, Obete milungwa. Obete nen, Boas milungwa. Boas nen, Salamon milungwa. Salamon nen, Nason milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nen, Aminada milungwa. Aminada nen, Adin milungwa. Adin nen, Anai milungwa. Anai nen, Keseron milungwa. Keseron nen, Peres milungwa. Peres nen, Yuda milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda nen, Yakobo milungwa. Yakobo nen, Aisaka milungwa. Aisaka nen, Ebarakam milungwa. Ebarakam nen, Tera milungwa. Tera nen, Neko milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neko nen, Seraka milungwa. Seraka nen, Iriyu milungwa. Iriyu nen, Peleke milungwa. Peleke nen, Iba milungwa. Iba nen, Sila milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila nen, Kenan milungwa. Kenan nen, Apakasa milungwa. Apakasa nen, Sem milungwa. Sem nen, Noa milungwa. Noa nen, Elemeke milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Elemeke nen, Metusala milungwa. Metusala nen, Inoke milungwa. Inoke nen, Yerete milungwa. Yerete nen Makalali milungwa. Makalali nen, Kenan milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nen, Inos milungwa. Inos nen, Sete milungwa. Sete nen, Adam milungwa. Adam God wan milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ena God Kegemama Iban milere Yesu den miriin suna sipapa sungure Yesu Yodan nuule piserungure, God Iban Yesu awli pi gariba simi yongwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pi milungwa are kaun yal su aan kawn muru Satan kiraan sire kela kule tongwa. Te milungure Yesu komina nekungure, kamin kaun iru wei sungure kenan gulungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan iru di Yesu tongwa, “I God Wan kawen milanga, kobile i u komina birete nama dire i ka di kobile i to.” ");
INSERT INTO gvf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dungure Yesu maan iru dungwa, “Ka main minin ganin iru dungwa, ‘Ibal kobe komina kaan kaan nere milamba milekun ta erekinamua.’” ");
INSERT INTO gvf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ena Satan Yesu awli baan ta pire, gariba gul gariba bilin ta ta para muru gin taran i maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Erere iru di tongwa, “Kalkan muru kaninga i, na gibilin aa tere kenin ere ke miliga yal na miliwa. Miliiba yal ta terala di piralga kawen kirara teralga paamia, ena ibal te kal wai dungwa i para muru i teralwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","I yaa gobin bile mile deminin si na tenanga, na kalkan para wen i kaninga i teralwa.” ");
INSERT INTO gvf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dungure Yesu iru di tongwa, “Ka main minin ganin iru dungwa, ‘I God taran tawle ana dire deminin si tere, te yalini ka dungwa wiina ero.’” ");
INSERT INTO gvf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ena dungure pare Satan yalini awli Yerusalem pirere, Yuda ka main ogu bil biriin bolin mina pi milere iru di Yesu tongwa, “I God Wan kawen milanga, i ole si yaa main so. ");
INSERT INTO gvf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Iru diga i, ka main minin ganin iru dungwa, ‘I wai wen milana dire God di angel kobe tenangure, i kenin ere milamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ta i ama iru dungwa i piro, ‘Angel yalin kobi i ai yebe dinangwa kobile ta kawnin ta bilekenanwa.’” ");
INSERT INTO gvf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dungure Yesu maan dire iru dungwa, “Ka main minin ganin iru dungwa i piro, ‘I Singaba God sua i kanala dire di tekio.’” ");
INSERT INTO gvf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan ka binanbile di Yesu tere kiraan sire kela kule te piserere, ena baan ta pire kaun ta unangwa kwi kiraan sirala di kwi paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ena God Kegemama Iban yobilaan bile niminin milere, Yesu awli ire ere Galili gariba gul ongwa. Ongure Yesu guun kan gariba i ware kuunin biingwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Biingure ena Yesu Yuda ka main ogu ala ka main kere di tomia, ena ibal para deminin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ena Yesu ere inin goma ki pai milungwa ain kaan Nasarete pire, Sare kaun Yuda ka main ogu ala ongwa. Sare kaun kaun erungwa mere kwi ere ka main ogu ongwa. Pirere ka main minin ganin kerala di ale milungure, ");
INSERT INTO gvf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ka main buku kaan Aisaya, yal ta yalini tongwa. Tongure piapa arin aa pilaa dire kani pire ka milin ta i maribe ere kerungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“God Singaba Iban na bole pena galemua. Kalkan aa te nekungwa ibal God guun kan pirama dire, yalini na konagi tere na paale suna ere imua. Kaymin ibal kal ta tegire ere ain nangwa di terala dire, te omilin gi dungwa ibal omilin pilaa dire kanama dire, te kanin sungwa kobe gule ere terala dire, na nusi ime eremua. ");
INSERT INTO gvf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","God Singaba ibalin kobe aa ki di tongure u wai nangwa kaun, di maribe erala dire na nusi eremua.” ");
INSERT INTO gvf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dire piapa aa te kube sire ka main ogu nil konagi yal tere amin di milungwa. Milungure ka main ogu milungwa ibal para, tena gure di kane yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tongure yalini kawn kule ka di ibalin kobe tongwa, “Ka main minin ganin keriga piringa i, kemina milin paamia.” ");
INSERT INTO gvf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yesu ka dungwa, “Kawen dire wai paimua,” dire ibal kobe pire buul kunungwa. Kunere iru dungwa, “Yalini Yosepe wan irawa.” ");
INSERT INTO gvf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dungure Yesu iru di tongwa, “Ka di bile dungwa ka i, i di na tenana di piriga iru. ‘I dokita milanga nibil eringa inin aa te wai erano.’ Te i ama iru di na tenangiray, ‘Aa te wai eranga yobilaan kuunin painangwa kanabina dire, Kapanaum mile pare kalkan eringa mere iray, inin ogin ain malge si paale ire ero.’ ");
INSERT INTO gvf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dinanba na di i terala piro. ‘Ka kebe yal kobe iwe, inin garibanin ibalin kobe, pire yebe ere tekungwa paamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Iru dimba kawen di i terala piro. Goma wen Ilaya milungwa kaun bolima ogu sutakobe te ta kole nimin sikungure, gariba gul i para muru kenan bil gulemua. Gulungure Isirel abal weray binanbile milimba, ");
INSERT INTO gvf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","God abalin kobe milungwa gul Ilaya nusi erekimua. Erekimba Saidon abal ta kaan Sarapa milungwa gul i nusi eremua. ");
INSERT INTO gvf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te ka kebe yal Ilaisa milungwa kaun Isirel seki egilungwa ibal binanbile milimba, God ibalin kobe aa te wai ere tekemua. Tekimba Siria yal ta kaan Neaman taran i aa te wai ere tomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dimia ena ibal ka main ogu ala milere pirere para den gule milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Milere Yesu a nusi mena ere awli ogin ain kamin kuul ibe pire, kol gaul ai ta kaale punaa si daan erala di erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Erimba Yesu sinaa dire u ku bilungwa ibal suna pire ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ena Yesu pi Galili gariba gul bawa dire ere Kapanaum ogu ai ongwa. Pirere Sare kaun ka nil si ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tere ka yobilaan bilungwa dungure, ena ibal kobe pire buul kune milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Milungure yal ta ka main ogu ala milere, sia digan ta yalini den miriin suna milungwa, yalini gala bil iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesu Nasarete nen milinga, na inan kanan paamia i kanin ta painan dino? Na ibal kobe na si sutaw ere na terala dire uno? God kabin sire wai wen milungwa yal, i yalini milinga na i gumanin kaniwa.” ");
INSERT INTO gvf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dimba Yesu kawre di tere, “I ka ta dikire yalini pisere ere mena po,” dungure sia yal i pusi ibal milungwa gul erere, ere mena pire yal i gain giil pire tekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iru eremia ibal para kane buul kunere diria ere iru dungwa, “Ayo, ka dungwa i, takal erame? Yobilaan bile niminin mile kawre di sia tomia ena ere mena omua.” ");
INSERT INTO gvf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dungure Yesu guun kan gariba gul i ware kuunin biingwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ena Yesu ka main ogu pisere ere Saimon ogin ala ongwa. Saimon wounbi nibil ere gain nega wen dungure, ena di maribe ere Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Di tongure Yesu pi abalini milungwa gul pire, “Nibil eringai wei sire u baan ta po,” dire kaman tere di tongwa. Di tongure abalini gain nega dungwa gwi sungure, alere komina ki tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ena kamin girungure pare nibil kaan kaan erungwa, ibal para muru ibalin kobe awli Yesu milungwa gul ongwa. Ongure Yesu nibil erungwa ibal i, para muru aan aa taw si tongure pilaan paingwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sia kobe ibal den miriin suna milungwa ere mena pire gala iru dungwa, “I God Wan milinwa.” Dungure Yesu God konagi erungwa yal Kirisito, milema di sia kanemia, ena Yesu “Manaa dire dikio,” dire kawre di tere dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kwimile taanima Yesu milungwa ain ogu i pisere, pi simi yongwa gul ongwa. Ongure ibal kobe waa duure kanere, yalini baan ta pekenama di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pirimba Yesu iru di ibal kobe tongwa, “God guun kan te yalini kenin ere ke milungwa mere, baan baan para kere di terabinga paamua. Konagi iru erebinga mere ime wiwa.” ");
INSERT INTO gvf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dungwa ena Yudia gariba gul ka main ogu dungwa dungwa ala ka main milin kere di ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ena kaun ta Yesu nil benge ta kaan Genesarete binan koli ale milungure, ibal kobe God ka dungwa milin pirala dire a daa dire suna ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ongure sipe sutan makalua yaa paangwa kanungure, nil kabe sungwa yal kobe kaya pisere nil kabe sungwa gal bigin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sipe ta Saimon Pita aa te nongwa, dungwa ali milungure Yesu ere ala pire di Saimon tongwa, “I sipe anu si nil benge binan ere na to.” Dire sipe ala amin di mile ka nil si u ku bile milungwa ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ka di ibal kobe te pisere iru di Saimon tongwa, “Nil muru wai yongwa gul sipe i gure pala dire nil kabe sinana dire, nil kabe sungwa gal i pusi nil main ali ero.” ");
INSERT INTO gvf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Dungure Saimon maan dire iru di Yesu tongwa, “Singabo, gilaa kaun iray na yal kobe konagi poraa paangwa erere nil kabe ta sekebinba, i ka dinga i, ena nil kabe sungwa gal pusi nil ali erabinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dire erungure nil kabe binanbile sire nil kabe sungwa gal muru di ime pire, kan si ole dinangwa paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Paamia ena gawliman kobe sipe ta milungwa aan kwi sire, “Aa ki di na tenana wo,” dungwa. Ungure nil kabe i miina ere, sipe ta ali yere ta ali yere erungure muulungwa. Muule sipe obin dere maru di i alibe erala di erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kal iru erungwa Saimon kanere, Yesu milungwa gul yaa gobin bile iru di tongwa, “Singabo, na kal digan ere taalime eriga yal na miliawa, ena i na pisere ere baan ta po.” ");
INSERT INTO gvf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yalin kobe nil kabe binanbile sungwa kanere, Saimon te yalin kobe bole pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedi wan sui Yemis te Yon milere, yalsui Saimon gawliman milungwa para pire buul kunungwa. Yesu iru di Saimon tongwa, “I kuril ta pirekio. Malia i nil kabe singa mere iru ibal iru inanwa.” ");
INSERT INTO gvf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dungure yal kobe sipe gure i makalua gul ongwa. Pirere kalkan para pisere Yesu duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ena kaun ta Yesu ogu ai ta milungure, seki egilungwa yal ta milere Yesu kanere, yaa gariba mina piruul sire kawan dire iru di tongwa, “Singabo, i na nimbona aa te wai ere na terala di piranga, ena i aa te wai ere na tenanga kuunin painamua.” ");
INSERT INTO gvf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dungure aan dire dire aa tere iru dungwa, “I aa te wai erabina di pirebinga, i u wai pi milanwa,” dungwa. Dungure seki egilungwa yal gin taran wiige sire u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu kaman tere iru di tongwa, “Kal erebingi, i ibal kobe di tekio. Di tekenanba pi Yuda ka main kenin erungwa yal, gain wiige sungwa i maribe eringire kanamua. I gaynin wiige singi, ibal kanama dire kabe si gale to. Mose ‘Kal ta to,’ kile kaman ka dungwa mere, wiina ere si gale to.” ");
INSERT INTO gvf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dimba, Yesu guun kan kwi ware gariba taw ama kuunin biingwa. Biingwa ka dungwa ibal pirabina dire, te nibil erungwa u wai nala dire ibal binanbile u Yesu milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ongure ena yalini pi simi yongwa gul pire ana di God tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ena kaun ta Yesu ka main nil si te milungwa, Parasi kobe te Mose kile kaman ka nil si tongwa yal kobe, yalin kobe Galili gariba gul te Yudia gariba gul te Yerusalem ain, ai iray binanbile pisere u ku bile amin di milungwa. God Singaba yobilaan bile Yesu tongure, nibil erungwa ibal aa te wai erungwa paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Paangure ibal kobe aan kawn ki sungwa yal ta, borebilin si yuungwa ogu ala pire Yesu milungwa gul i main ere yerala di pirimba, ");
INSERT INTO gvf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ibal binanbile u ku bilungwa kol ta wen ta dikungwa. Ta dikungure maa pi ogu biriin mine pire erewan suule erere, gawalin ulin kole koli kan kulere, aa te mile aan kawn ki sungwa yal gawalin ali pai milungwa mone mone di pusi ime erungure, Yesu milungwa gul yaa u guman mina pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yalin kobe iru erere, Yesu aa te wai ere yalini tenama di pirungwa Yesu kanere iru di aan kawn ki sungwa yal tongwa, “Yakuno, i kal digan ere taalime eringa kire di ere i tomua.” ");
INSERT INTO gvf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dungure ka main nil si tongwa yal kobe te Parasi kobe bole, ka diria ere iru dungwa, “Yal i God gain ka si tongwa, yalini ibena mile ka iru di tome? Ibal kal digan ere taalime erungwa, ibena kire di erame? Yal ta kire di erekinangwa paangwa, God inin kire di eramua.” ");
INSERT INTO gvf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nomanin si pirungwa i, Yesu kane pirere iru di yalin kobe tongwa, “Tameran nomanin binanbile si suna yene? ");
INSERT INTO gvf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Kal digan ere taalime eringa kire di eremua,’ diralga ka pilaan painamba, ‘Gawalin ire kol warana po,’ diralga u wai nam mo, pekenam mo, ibal kanamua. ");
INSERT INTO gvf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na U Ibal Obinga Yal ibal kobe kal digan ere taalime erungwa kire di erabinga, yobilaan na tongwa main pire bawa dinanwa.” Iru dire di aan kawn ki sungwa yal tongwa, “I ale gawalin aa te ire, i ere oginin po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dungure ibal kobe milungwa suna ali yalini alere paingwa gawalin i, aa tere pi ogin pire, God kaan gale yebe ere deminin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ibal para kane buul wen kunere God kaan gale yebe ere deminin si tere, aya maya dire iru dungwa, “Kal main ta guman kwi dungwa malia u maribe ongwa kanebinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesu iru erere pare, ere pire kobile takis ingwa yal ta kaan Ilibai, takis ingwa ogu ala milungwa kanere, ka iru di tongwa, “Na muna kol duulin bilo.” ");
INSERT INTO gvf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dungure alere kalkan para pisere mun kol duulin bilungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ena Ilibai komina bil ki Yesu tongure, kobile takis ingwa yal digan binanbile te ibal taw ama para amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Milungure Parasi kobe te Parasi kobe main nil si tongwa yal kobe bole, Yesu gawliman kan tere iru dungwa, “Kobile moni takis ingwa yal digan kobe, te taalime erungwa yal milungwa bole, tameran i komina bole para ne miline?” ");
INSERT INTO gvf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dungure Yesu maan dire iru dungwa, “Ibal imore milungwa dokita milungwa gul ta pekenamba, nibil erungwa omua. ");
INSERT INTO gvf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ibal maribe milungwa di ku bilala dire, gariba gul ukiwa. Ibal piril sungwa te nigi nagi dongwa, nomanin suna si kiruul sinama dire ime wiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dungure ibal kobe iru di Yesu tongwa, “Yon gawlima kobe te Parasi gawlima kobe para, morin morin komina mawal ere te ana di God te milimba, i gawlimanin kobe komina te nil para ne milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Dungure Yesu di tongwa, “Yal ta abal inangwa kaun yalini gawlima kobe komina mawal ere milamo? Tamama. ");
INSERT INTO gvf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Iru paamba kaun ta na awli nangure, ena kaun iray na gawliman kobe komina mawal ere milamua.” ");
INSERT INTO gvf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dire ka di bile dire iru di tongwa, “Gal kwi aa dinaa dire tawliga ire, gal golin bali sungwa bolimina si bilekenamua. Si bilangwa gal kwi kaya aa dinaa dire, te gal kwi, te gal golin para kuunin ta dekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te ibal wain nil kwi i meme gain mugu golin ali garu dekenamua. Ali garu dinangwa, nil wai kwi miin ure u niminin mile meme gain mugu si gala dinangure, wain nil u mena pire mugu para pawa dinamua. ");
INSERT INTO gvf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","I iru pisera. Nil wain kwi kule, meme gain mugu kwi dungwa ali garu dinanwa. ");
INSERT INTO gvf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Te ibal kobe nil wain golin nenangwa, ena nil wain kwi nerala pirekire iru dinangwa, ‘Nil wain golin nobinga wai pirebinwa,’” dire Yesu dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ena Sare kaun ta Yesu dodal yaalungwa gul suna kol ware ongwa. Ongure gawliman kobe milin taw ule olanin pawlere nongwa. Iru nongwa mere Yuda kile kaman ka, “Main para paimua,” dungwa paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iru nongure Parasi kobe taw mile iru dungwa, “Na ibal kobe kile kaman ka, ‘Sare kaun kal ta iru erekio,’ manaa dibingare, tameran Sare kaun kal iru kwi ereme?” ");
INSERT INTO gvf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dungure Yesu ka iru di tongwa, “Debiti te ibalin kobe kenan gule kal erungwi, i ka pore kere pirekeno? Piringirawe. ");
INSERT INTO gvf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yalini God ka main ogu ala pire komina birete God tongure kanungwa, ‘No,’ dungwa ire nere ibalin kobe tongure para nomua. Nomba komina birete i ka main kenin erungwa yal kobe nongwa paamba, ibal imore nomia ena na ibal kobe kile kaman ka si keli simua.” ");
INSERT INTO gvf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dire ka ta iru dungwa, “Na U Ibal Obinga Yal, Sare kaun na kobaan miliga paamua.” ");
INSERT INTO gvf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ena Sare kaun ta i, Yesu ka main ogu ala pire ka main nil si tongure, yal ta aan wen kol kebil sungure milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yuda ka main nil si tongwa yal kobe te Parasi kobe taw bole mile, ka di mere si Yesu terala di pirere, Sare kaun Yesu yal ta aa te wai ere tenam mo, tekenam mo, nai kane milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yalin kobe iru nomanin si pirungwa Yesu pirere, iru di aan kebil sungwa yal tongwa, “I ale suna abili u ale milo.” Dungure alere u suna abila milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Milungure Yesu iru di nai kane milungwa yal kobe tongwa, “Na ka sirin bile i terala i maan di na to. Na ibal kobe kile kaman ka, takal waa dungwa pirine? Sare kaun kal wai erabin mo, kal piril sungwa erabine? Ibal aa ki di terabin mo, si gule terabine?” ");
INSERT INTO gvf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dire kane kole kole ere tena kanere, iru di aan kebil sungwa yal tongwa, “I anin dire do.” Dungure erungure, aan kwi u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","U wai omba, yalin kobe den gulere diria ere iru dungwa, “Yesu takal ere terabine?” ");
INSERT INTO gvf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ena kaun iray Yesu ana di God terala dire pi kamin kuul ongwa. Pi milere ana di milungwa di milungwa, ena kamin taangwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Taangure are nol erungure, gawlima kobe di u ku bilere gawlima kobe anan kole kole muru kawnan milin sutan paale suna ere ire, “Nusi erungwa ongwa yal kobe, Aposel milinwa,” dire kaan ye tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yalin kobe kaan iru paangwa, ta Saimon kaan kwi Pita ye tongwa, ta Pita kebin Endiru, sui Yemis te Yon bole, ta Pilipi, ta Batolomiu, ");
INSERT INTO gvf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ta Matyu, ta Tomas, ta Alpias wan Yemis, ta yobilaan bilungwa yal Saimon, ");
INSERT INTO gvf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ta Yemis wan Yudas, ta bale taal sungwa yal kaan Yudas Isikerio. ");
INSERT INTO gvf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ena Yesu te gawlima kobe bole kamin kuul pisere wi ime pire banin ta wai dungwa ale milungure, gawlima kobe taw binanbile bole para milungwa. Milungure Yudia gariba gul ibal ire, te Yerusalem gariba gul ibal ire, te pirin nil ai sutan Tayan te Saidon ibal ire, ");
INSERT INTO gvf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","te ibal binanwenbile iru Yesu ka dungwa pirala dire, te nibil erungwa u wai nama dire, u ku bile milungwa. Sia digan ibal den miriin suna milungure taalime ere ibalin kobe tongure, ena ibalin kobe Yesu milungwa gul ungure, aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","God yobilaan bile tongure Yesu nibil erungwa ibal aa te wai ere tomia, ena ibal para Yesu galsuna aa terala dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ena Yesu gawliman kobe tena kane mile iru di tongwa, “I ibal kobe kalkan aa te nekinga miriin paimua. Paire God kenin ere ke milungwa gul pi suna milinwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","I ibal kobe malia kenan gulungwa miriin paimua. Paire God kwi aine dinangure, inanga kuunin biinamua. I ibal kobe malia kay miinga miriin paimua. Paire waa gulanwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Na U Ibal Obinga Yal, i ibal kobe nomanin pire na tenanga, ena ibal den ki ye i tere, te nigi nagi de i tere, te ka su gale i tere, te i kaanin di ime ere ibal iru ere i tenangwa, i miriin painamua. ");
INSERT INTO gvf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","God kamin mina tobe bil ta eme i tenamia, wai wen pire miinin mayo. Gain giil pire i tenangwa mere, goma wen ibalin kobe sanamoi iru ere God ka kebe yal tomua. ");
INSERT INTO gvf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Dimba i ibal kobe malia kul gal bona aa te nenga, eke, miriin pirie. I kalkan para kaya nengiwe. ");
INSERT INTO gvf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","I ibal kobe malia nere kuubinin maanga, eke, miriin pirie. I kenan bil gule milanwa. I ibal kobe malia waa gulungwa, eke, miriin pirie. I muun bile kay miinanwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ibal kobe ka wai di tere deminin si i tomba, eke, miriin pirie. Goma wen ibalin kobe sanamoi ka iru di ka kebe yal kiibe tomua. ");
INSERT INTO gvf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ena na ka ta di terala piro. I kayminin ibal den miriin tere te den ki ye i tongwa ibal, i kal wai ere ibalin kobi to. ");
INSERT INTO gvf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ibal kobe gain ka si i tenamba, i ka wai dire maki ye to. Ibal kobe gaynin giil pire i tenangwa, ibalin kobe kaan gale pile dire ana di God to. ");
INSERT INTO gvf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yal ta i pawnin mina i sinangwa, i pawnin kole maa di to. Yal ta i gwi gal inangwa, ena galsuna para irala dungure, ‘Iyo,’ di to. ");
INSERT INTO gvf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yal ta ‘Kalkan na to,’ kaan dinangwa, ena i wiina ere to, te yal ta i kalkan inangwa, ‘Kwi maan na to,’ dikio. ");
INSERT INTO gvf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ibal kobe kal wai ere na tenama di piranga mere, ena i iru ere ibal kobe to. ");
INSERT INTO gvf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ye nenga ibal tawle den miriin tenanga, ena God wai pire maki ye na tenama di pirino? Tamama. Kal digan ere taalime erungwa ibal den miriin tere maan tomua. ");
INSERT INTO gvf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ibal kobe kal wai ere i tongwa mere, maan iru tawle kal wai ere tenanga, ena God wai pire maki ye na tenama di pirino? Tamama. Kal digan ere taalime erungwa ibal, kal main iru pire ere waremua. ");
INSERT INTO gvf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","I ibal kobe mile, ‘Yal ta kalkan teralga ena yalini maan kirara na tenamua,’ dire i yalin kobe iru tawle kalkan tenanga, ena God wai pire maki ye na tenama di pirino? Tamama. Kal digan ere taalime erungwa ibal kal ta tongwa mere, maan iru na tenama di pire ena tomua. ");
INSERT INTO gvf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","I kal iru eranga pisero. I kayminin ibal den miriin tere kal wai ere to. Kal ta tenanga ena pirin pai na tenama dire, ka dagi dikio. Kal iru eranga aibe tobe bil i tenangure, Kamin Singaba God wan abilin i milanwa. Ibal kobe kalkan ire wai pire maki ye tekere, te kalkan inin aa te nongwa, God aa ki di ibalin kobi tomia, ena tobe bil i tenangure, yalini wan abilin i milanwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Abe kamin mina milungwa piranin pai ibal tongwa mere, i para iru ere to. ");
INSERT INTO gvf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“I ibal kobe kane birun bale manin bale tekinanga mere, God birun bale manin bale i tekenamua. Te i ibal kobe kane pirin pai tekenanga mere, God pirin pai i tekenamua. Te i ibal kobe kane pirin gule tenanga mere, God pirin gule i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","I kalkan obin si ibal tenanga, ena God obin si i tenamua. Tenangwa kalkan binanbile i tenangure, gal maa muulungwa mere i tenamua. I ibal kobe kalkan ere tenangwa mere, God para iru maan i tenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ena Yesu ka di bile dire iru di tongwa, “Omilin sigi dungwa yal sutan aan aa tere awli nangwa ena yal sui ereko maul ali sagu dinamua. ");
INSERT INTO gvf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ka nil sungwa gaan kobe ka nil si tongwa yal yaa ime ta sinangwa, tamama. Dimba ka nil sungwa gaan kobe sikul kaya di piseramia, ena ka nil si tongwa yal kuunin painamua. ");
INSERT INTO gvf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bili mege ta i enin kobe omilin ali dungwa i kaninba, bili bilkaw ta i omilin ali dungwa, tameran inin kanekine? ");
INSERT INTO gvf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ka ta iru sirin bile enin kobe tenga, ‘Yalkuno, bili mege ta i omilin ali pi dungwa, i mena ere i teralo?’ Dinba, bili bilkaw i omilin ali pi dungwa we. I miriin kaale tongwa yal milingiwe. Bili bilkaw i inin omilin ali dungwa goma i mena ero. Eranga ena kanere bili mege i enin kobe omilin ali dungwa, i mena eranga painamua. ");
INSERT INTO gvf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Eri ta wai dungwa i milin kulungwa ki erekungwa eri dimua. Te eri ta piril sungwa i milin kulungwa ki erungwa eri dimua. ");
INSERT INTO gvf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Eri dungwa i kananga wai dim mo, piril sim mo, ena milin kananga piranwa. Eri digan galan yongwa akola painangure yu nekire, te suul ta girepe milin painangure ule nekinanwa. ");
INSERT INTO gvf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yal dorimil milungwa nomanin suna ali wai pai dungure, kal wai ere ka wai dinamua, te yal digan milungwa nomanin suna ali ki ere dungure, kal digan ere ka digan dinangwa paimua. Nomanin suna paangwa mere ka iru dinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“I ibal kobe mile, ‘Yesu Singabo,’ iru di na tenba, tameran ka di i tega mere wiina erekine? ");
INSERT INTO gvf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ibal kobe na miliga gul ure na giranan wiina pai tenangwa, ena yalini milungwa mere main di maribe ere terala piro. ");
INSERT INTO gvf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yal ta ogu iru kiingwa mere yalini iru milemua. Yal i ogu main balere ogu dimin wai gul ogu kiimua. Kiimia ena nimin sire nil simba, ogu mama wen kiingwa si suule erekimua. ");
INSERT INTO gvf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dimba yal ta na giranan wiina pai tekenangwa, ogu main wai balekire ogu dimin digan gul ogu kiingwa mere, yalini iru milemua. Nimin sire nil simia, ena ogu gin taran si suule eremua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ena Yesu ka dungwa i di pisere pare, ere Kapanaum ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ongure Orom simil nen kenin erungwa yal ta milere, te yalini nil konagi yal wai pire tongwa. Tomba nil konagi yal i, nibil ere gulala di ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yesu kalkan erungwa mere kenin erungwa yal i pirere, Yuda ka main singaba kobe taw nusi ere iru di tongwa, “Na nil konagi yal aa te wai ere tenamia, ‘Yesu wo,’ di to.” ");
INSERT INTO gvf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Di tongure pire Yesu milungwa gul pi bawa dire, kawan dire iru di tongwa, “Yal ta i yal wai wen milemia, i aa ki di tenan mo? ");
INSERT INTO gvf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yalini na Yuda ibalan kobe wai pire tere, te Yuda ka main ogu inin ki obin golin si na tomia, ena i aa ki di tenanwa.” ");
INSERT INTO gvf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dungure ena Yesu bole para pirere, Orom simil nen kenin erungwa yal ogin taw maala ongure, yal i ye nongwa yal kobe i nusi ere, “I kaya pire iru do,” di tongwa, “Na milere iru dimia da. Singabo, baan araway dimia i pisero. Na yal digan milia, i na ogu unanga kuunin erekimua. ");
INSERT INTO gvf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iru paamia, ena na inan i milinga gul ta ukiwa. Dibinba i imore kaman tenanga, ena na nil konagi yal u wai namua. ");
INSERT INTO gvf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na ama para yal singaba na kenin ere milungure, te na simil nen taw kenin ere miliga ena na yal ta ‘Ere po,’ di tega mere, yalini ere omua. Te yal ta ‘Wo,’ di tega mere yalini umua. Te na nil konagi ibal ‘I konagi ta paangwa i, ero,’ di teya ena yalini eremua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ka i dungwa Yesu pire buul kunere, ka iru di duulin bile warungwa ibal tongwa, “Na kawen di i yal kobe teya. Na Isirel ibal suna kobi, pire gi ta iru dungwa ta kanekiwa.” ");
INSERT INTO gvf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ka kebe yongwa yal kobe kwi ere ogin pire, nil konagi yal nibil erungure kaya u wai ongwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ena Yesu kaun tawlita milere ere ogu ai ta kaan Nen ongure, gawlima kobe te ibal binanbile bole ereko ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pirere malgia gul egilin minai u maala ongure, ena yal ta gulungwa maul si yenama dire, ibal gawalin ere eri yere kawi yuungure kanungwa. Gulungwa yal iwe, nen kaya gulungure man abal weray milere wan taranta tawle milungure, ibal binanwenbile malge pisere bole para ungwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Abalini ungwa Yesu Singaba kanere miriin wen pire tere, “Kay miikio,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Di tere pirere gawalin ere eri yere kawi yuungwa aan duru dire aa tongure, ena gawalin ere eri yere kawi yuungwa yalin kobe mile paangwa. Mile paangure Yesu iru dungwa, “Goya, ena i alo.” ");
INSERT INTO gvf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dungure yal garamil i kaya gulimba, kwi ale ka kawn kule dungwa. Dungure Yesu yalini awli pi man tere, iru di tongwa, “I wanin imore milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ibal para kanere sipile dire kuril wen pirere, God kaan gale yebe ere deminin si tere iru dungwa, “Ka kebe yal singaba ta na milebinga suna maliaga u maribe omua.” Dire ka ta iru dungwa, “God ungwa inan ibalin kobe aa ki di tenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu iru erungwa paamia, ena yalini guun kan Yudia gariba gul te gariba kole koli para kuunin biingwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ena Yesu kal erungwa i, Yon gawlima kobe pirere ka di gawa di Yon tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Di tongure Yon gawliman kobe sutan, “Ere wo,” dungure ungure, nusi Yesu milungwa gul ere, “Iru do,” di tongwa. “I iru sirin bile Yesu to. God, ‘Yal ta nusi ime ere na teralwa,’ dungwa iray, i yalini milin mo, yal ta kwi eme unangwa suul milabine?” ");
INSERT INTO gvf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Di tere nusi erungure, Yesu milungwa gul u bawa dire iru di tongwa, “Nil bile tongwa yal, Yon milere na yasu nusi i milinga ere, ‘Iru do,’ dimua. God ‘Yal ta nusi ime ere na teralwa,’ dungwa iray, i yalini milin mo, yal ta eme unangwa suul milabine?” ");
INSERT INTO gvf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ena iru dungwa kaun iray ibal binanbile nibil kaan kaan erungwa Yesu aa te wai ere tere, te sia den miriin suna milungwa maa si mena ere, te omilin gi dungwa kwi aa pilaa di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu kal iru erere ka maan di Yon ka kebe yal sui tongwa, “Omilin gi dungwa ibal pilaa dire kanungure, te kaun kebil sungwa u wai pire kol warungure, te seki egilungwa ibal wiige sungure, te kiraan gi dungwa ibal pilaa dire ka pirungure, te gulungwa ibal alere u kwi pire mile paingure, te kal aa te nekungwa ibal na guunan kanan pirungure, kal iru erungwa main i kane pire pi Yon di tenana po. ");
INSERT INTO gvf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yal ta na inan kanere nomanin su su sekenangwa, ena miriin painamua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ena Yon ka kebe yongwa yal sui ere ongure pare, Yon konagi erungwa mere Yesu iru di ibal taminin bil tongwa, “Yon gariba simi yongwa milungure, i kanala di engi we, yal ena kanala di pirine? Yobilaan bilekungwa yal ta kanala di pirin mo, ");
INSERT INTO gvf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","yal ta galsuna wai wen sigi dungwa kanala di pirine? Tamama. Ibal kobe galsuna wai sigi dungwa singaba mere mile ogun wai wen ki pai milungure kananwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ena ka ta sirin bile i teralga, i maan di kole ere na to. God ka kebe yal i kanala di eno? Owa para dina. Yalini ka kebe yal imore ta milekemia, Yon ka kebe yal bil wen milemua. ");
INSERT INTO gvf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ka main minin ganin bilungwa mere, Yon di maribe erungwa iru bilungwa. ‘God iru di na tongwa, Na ka kebe yal ta nusi erabingire, yalini goma ye tere kol bala di i tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ka di i terala i piro. Ibal maalungwa muru ibal taw u singaba omba, Yon u singaba bil wen omua. Omba yal digan ta God kenin ere ke milungwa ai suna ongwa, yalini Yon yaa ime simua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dungure ibal imore para te kobile moni takis ingwa yal kobe, “Nil bile na to,” di Yon tongure nil bile tomia, ena Yesu ka dungwa i pirere, wai pire maki ye God tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tomba Parasi kobe te kile kaman ka nil si tongwa yal kobe bole, “Nil bile na to,” di Yon tekemia, ena Yesu ka dungwa i pirere God kol ta i maribe ere tongwa i gibilin mui kol yongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu kwi ainere iru dungwa, “Ena ibal kobe malia maalungwa, ibena di bilabine? Ibena milungwa mere mileme? ");
INSERT INTO gvf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Komina aibe tobe erungwa ai, gamege taminin sutan mile taminin ta iru gala di taminin ta tongwa, ‘Na abal kule nobinga te ime erebinga kaun iray, tawa sibinba, i ibal kobe egin erekinwa. Te ibal gulungwa kaun weray si paabinba, i ibal kobe kay ta mi na tekinwa.’ Gamege sigil iru tere nomanin paikungwa ka dungwa mere, ibal malia maalungwa nomanin su su sire ka di na Yon bole na tomua. ");
INSERT INTO gvf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nil bile tongwa yal, Yon urere, komina mawal ere nil wain para nekungure, ibal para kane, ‘Yal du milemua,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na U Ibal Obinga Yal ure, komina te nil nobingire, i ibal kobe kane iru dinga, ‘Aya, yal ta i kano, komina depil nere nil wain binanbile nere, kobile moni takis ingwa yal te yal digan para ye nega milemua.’ ");
INSERT INTO gvf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dinba God kule yongwa milemia kal wai eremia, ena yalini kirara kawen dima di kanebinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ena Parasi ta mile, “Na bole komina nerabila wo,” di Yesu tongure, pi Parasi ogin ala pire komina nerala di amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ogu ai i kal digan ere yal warungwa abal ta milere, “Yesu ure Parasi ogin pi komina nomua,” dungwa pirere, eri niriin minanin wai sungwa kule mugu ere yongwa ire ungwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Urere Yesu kawn minai yaa gobin bile milere kay miingure, omilin niriin boide yaare, Yesu kawn mina yaa sire kul tongure, gibiliigin aa gi di pire kul tongwa kire di erungwa. Erere Yesu kawn bi di nere, eri niriin i garu dire Yesu kawn mina bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Abal iru ere milungure, Parasi Yesu, “Wo,” di tongwa yal i kanere iru nomanin si pirungwa, “Yal i God ka kebe yal ta milekemua. Milangwa ena abalini yalini gain aa tere milungwa mere kanere, te kal digan erungwa para kanamba, kal digan ere yal warungwa abal, yalini main ta kanekimua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dire nomanin si pirungwa i, Yesu pirere iru di tongwa, “Saimon inan yasu ka ta dirabilo.” Dungure yalini di Yesu tongwa, “Nil si tongwa yalo, para dina di na to.” ");
INSERT INTO gvf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dire Yesu dungwa, “Yal ta yal sui kobile moni tongwa, pirin pai imo dimua. Yal ta kina yal anan kole muru aan kawn muru tere, te yal ta kina anan kole kole muru tongure, pirin iru pai imo dimua. ");
INSERT INTO gvf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yal sui pirin paangwa maan te kole eramba, kobile moni ta dekungure ena kobile tongwa yal i, yal sui pirin gule ere tomua. Yal sutan i milimba, yal ta ena wai wen pire kobile tongwa yal tename?” ");
INSERT INTO gvf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Dungure Saimon maan dire iru dungwa, “Pirin bilkaw paingwa yal iray wai wen pire tenamua.” Dungure Yesu iru dungwa, “I para dinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dire abal milungwa gul kiruul sire kane iru di Saimon tongwa, “Abal ta i, i kano mo. Na i ogin ala ubinba, na kawnan bigin sirabinga nil kule na tekinwa. Na tekinba, abalini kay miingwa omilin niriin boide yaare na kawnan mina sungure, aw unin sire gibiliigin aa gi di pire kul tongwa kire di eremua. ");
INSERT INTO gvf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na i ogin ala ubinga kaun i na kaalekinba abalini na kawnan minai bi di ne milemua. ");
INSERT INTO gvf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na gibilan mina wel bile na tekinba, abalini eri niriin minanin wai sungwa, na kawnan mina garu dire bile na tomua. ");
INSERT INTO gvf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kal iru eremia, na ka di i terala piro. Abalini den miriin kirara tomia, ena kal digan ere taalime binanbile erungure, God kire di erungwa i ibal kobe kaninwa. Kaninba yal ta kal digan ere taalime tawliga erungure God kire di eremia, ena yal i den miriin tawliga God tomua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dire Yesu iru di abalini tongwa, “I kal digan ere taalime eringa God kire di ere i tomua.” ");
INSERT INTO gvf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dungure komina bole taran amin dire ne milungwa ibal kobe, diria ere iru dungwa, “Kal digan ere taalime erungwa yalini kire di erungwa, ta paikimia, yalini ibena mileme?” ");
INSERT INTO gvf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dimba Yesu iru di abalini tongwa, “I pire gi dina, ena God i aa ki dungure sigare kule u wai enwa. I ere pire den miriin suna yaa ime si milo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ena kaun tawliga wei sungure, Yesu pi ogu ai bil mege para baan baan pire God kenin ere ke milungwa guun kan kere di ibal kobe tongwa. Tongure gawlima kobe anan kole kole muru kawnan milin sutan bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Abal taw kobe nibil erungwa aa te wai ere tere, te taw sia den miriin suna milungwa maa si mena erungure, abalin kobe Yesu bole para ongwa. Abal ta kaan Maria, abalini kaan kiibi Madala milungure, sia anan kole muru kole sutan abalini den miriin suna milungwa maa si mena erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Abal ta kaan Yoana milungure, winbi Susa mile Kerodi ogu kenin erungwa yal milungwa. Abal ta kaan Susana milungure, te abal taw binanbile bole para pire, Yesu te gawlima kobe aa ki di tere kalkan te milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ibal kobe ogu ai ta, te ta ta binanbile ibal kobe morin iru ure binanwenbile u ku bile milungwa Yesu ka di bile dire iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yal ta milin sigilala dire omua. Sigile milungure taw yaa kombil bolimina sungure, ibal egilungure kauba ure nomua. ");
INSERT INTO gvf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Milin taw yaa kobile bolimina sungure, gariba iray kolin paingwa gune di maare minin kengi simua. ");
INSERT INTO gvf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Milin taw kul galan yongwa suna ali yaa sungure, bole para maangure naan yobilungure gulemua. ");
INSERT INTO gvf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Milin taw gariba wai dungwa gul yaa sirere, gune di maare arin sire milin kule sulu dimua. Dire erin ta milin binanwenbile wan kandret, paimua.” Yesu ainere dungwa, “Ibal kiranin gi dekemia, kiranin gule piro.” ");
INSERT INTO gvf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yalini gawlima kobe di bile dungwa main mere sirin bile Yesu tongure, ");
INSERT INTO gvf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","maan iru dungwa, “God kenin ere ke milungwa mere, main aal kule paangwa God i maribe ere i tongure pirinwa. Pirinba ibal mena milungwa imore kanimba, wai wen ta kanekire kiraan pirimba, pire bawa dikinama dire God di bile dungwa di tomua. ");
INSERT INTO gvf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ena di bile dungwa i main paangwa iru paangwa. God ka dungwa mere, milin iru paamiwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Milin taw yaa kombil sungwa mere, ibal iru milemua. Ka dungwa pirimba, Satan urere, ka main pire gi dikire u wai pekenama dire, ka main milin nomanin suna sigilungwa i omua. ");
INSERT INTO gvf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Milin taw yaa kobile bolimina sungwa mere, ibal iru milemua. Ka main pirere wai pire miinin maamba, dulaanin ikire baan tawlita pire gi dire, kiraan sire bawle tenangwa kaun u bawa dungwa, ka main mun kol eremua. ");
INSERT INTO gvf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Milin taw galan yongwa ali yaa sungwa mere, iru milemua. Ka dungwa pirimba, taalime u maribe ongure, kobile moni te kulgal bona pirungwa maangure, te gariba kal pirungwa maangure, kal iru u maribe ongwa ka main nomanin suna paangwa gule bile yaamua. ");
INSERT INTO gvf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Milin taw gariba wai dungwa gul ali yaa sungwa mere, ibal iru milemua. Ka main pirere nomanin wai suna yere wiina ere milungwa milungwa, ena milin paamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Dire ena Yesu ka iru dungwa, “Ibal kobe enderin derin gale i ogu ala pirere, bale bilkaw main ali mo, bol main ali ta yekemua. Dimba aw dinangwa kanere, ibal ere ala unama dire ena bol bolimina gale yomua. ");
INSERT INTO gvf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kalkan aal kule paangwa muru eme u maribe nangure, te si alibe erungwa eme aw di u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ka dungwa pire i pirekun ero. Yal ta kalkan binanbile kenin ere milungure, taw ama tenangure inamua. Dimba, yal ta kalkan tawle kenin erekungwa ta tekinangure, ‘Kal tawle aa te neiwa,’ di pirimba yal ta kalkan i aa tekenama dire, tawal di inamua.” ");
INSERT INTO gvf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ena Yesu man te kebin kobe Yesu milungwa gul ure ogu ala namba, ibal binanwenbile u ku bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Milungure yal ta iru di Yesu tongwa, “I manin te kebininbi malge mile i kanala dimua.” ");
INSERT INTO gvf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dungure Yesu iru di ibal kobe tongwa, “Ibal kobe God ka dungwa wiina pai terere, ena ibalin kobe na mina te na kebinanbi mere milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ena kaun ta Yesu te gawlima kobe bole sipe ala pire iru di yalin kobe tongwa, “Nil benge binan kole iray nil minin mina nabina wo.” Dungure nala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ongure ena Yesu ul maure ul paangwa. Paingure gwi bilkaw maangure, nil yugu di ime pirere, ena sipe ala nil maa muulungure, nil na si nenama di kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanere Yesu ulin yuure iru di tongwa, “Singabo, na yal kobe kaya gulabinga pamiawa.” Dungure Yesu alere gwi koban si tere, nil benge kiraan aa tongure, ena gwi si ole dungure, te nil sua si dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu kal iru erere pare, iru di gawlima kobe tongwa, “Tameran pire gi di na tekene?” Di tomba yalin kobe pire sigagu dire kuril pire diria ere iru dungwa, “Nil te gwi yalini ka dungwa pire wiina erungwa, ibena mileme?” ");
INSERT INTO gvf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ena yalin kobe pi Galili gariba gul koliba kole iray nil minin mina pire, Gerasene ibal ki paangwa gul u bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sipe pi pai dungure Yesu ere main ongure, yal ta sia den miriin suna milungwa yal sui pi kol baan guman yongwa. Yal iwe, baan araway yorawan bole milere ogu ala ta ki paikimba, yene yobilaan kobile giran ali pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yal ta i Yesu kanere gala bil dire, Yesu kawn mina yaa yobin bile milere ka iru di tongwa, “God Yal Bil Wen, Wan Yesu, na inan kanan paamia, i kanin ta paimo? Na kawan dire di teiwa. I gain giil pire na tekio.” ");
INSERT INTO gvf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu mile, “Sia yalini den miriin suna pisere mena wo,” dimia ena yal i, ka dungwa i, di Yesu tongwa. Ginin taw binanbile ibal kobe yalini aan kawn ain yobilagi kan kulere kanin simba, sia den miriin suna milungure taynan sungure kan si ole dungure, sia anu si pi ai simi yongwa gul erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu sirin bile tere iru di yal i tongwa, “I kaanin galo.” Dungure ena sia binanbile den miriin suna milungwa yalini iru dungwa, “Na kaanan Miriki Wen paamua.” ");
INSERT INTO gvf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yesu sia kobe nusi gawl ai ta erekinama dire, kawan dire di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ena bolima binanbile kuul daan alibe ali ware ne milungure, sia kobe mile, “Na nusi bolima den miriin suna ali ere na to,” dire kawan dire di Yesu tongwa. Tongure Yesu, “Para ere po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dungure sia kobe yalini piserere kwi bolima den miriin ali ongure, ena bolima para muru daan ali wi ime pire nil benge sagu dungure, bolima kobi muru nil si nongure gulungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yal kobe bolima kenin ere milungwa kanere si ere pirere, ibal mena te malge milungwa di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Di tongure ibal kobe kanala dire ongwa. Pirere Yesu milungwa gul u bawa dire, goma sia den miriin suna milungwa, sia baan ta ongwa imore milungwa yal, kanungwa. Kanere yalini Yesu kawn mina amin di mile gal sigi dire nomanin suna wai paangwa, ibal kobe kanere kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yesu sia maa si mena erungure, kanungwa yal kobe kal erungwa i, bolin kule ibal kobe di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Di tomia ena Gerasene u ku bilungwa ibal para, sigagu dire kuril pire kawan dire, “Ere po,” di Yesu tongwa. Di tongure Yesu sipe ala pire ere nala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Goma den miriin suna milimba, kaya u mena ongwa yal kawan dire iru di Yesu tongwa, “Inin yasu para, ‘Nabila wo,’ di na to.” Dimba Yesu manaa dire iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“I inin ogin pire God kalkan ere i tongwa mere, bolin kule di maribe ero.” Dungure ere ogu ai kole kole pire Yesu kal ere yalini tongwa mere, bolin kule di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ena Yesu kwi nil benge kole ongure, ibal binanbile yalini suul milere u ku bile milungwa. Milere Yesu u bawa dungure, wai pire tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yuda ka main ogu yal singaba ta, kaan Yairus u bawa dire Yesu kawn mina yaa i kwi bilere kawan dire iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","“Na abilan taran ta milere bolima ogu anan kole kole muru kawnan milin sutan tawle milimba, malia gulangwa paamia na ogunan wo.” Dungure Yesu ongure, ibal kobe Yesu erebil ere apu malge bilungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Abal ta me erin anan kole kole muru kawnan milin sutan, mayan gain mina pai di milungwal milungwa, abal i bole para ongwa. Bona gana muru dokita te piserimba, aa te wai ere tekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Abalini Yesu mun kol pirere yalini gal ulin aa unin sungure, mayan si milungwa abal i, kaya keneba yongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu iru dungwa, “Ibena na gal aa unin sime?” Dimba ibal para mile, “Aa tekebinwa,” dungure Pita iru di tongwa, “Singabo, ibal binanbile i yobile suna erungwa iwe.” ");
INSERT INTO gvf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dimba Yesu iru dungwa, “Na yobilanan ta ura dungwa piria, ena ibal ta na aa unin simua.” ");
INSERT INTO gvf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dungure kal eriga Yesu pirama di abalini kanere, sigagu dire Yesu milungwa gul yaa bile minay ire, Yesu gal ulin aa unin sungure, gin taran u wai ongwa, main di maribe ere ibal para tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Di tongure Yesu iru di abalini tongwa, “Abilane, i pire gi dingi, malia pilaan pai milinwa. I ere pire den miriin suna yaa ime si milo.” ");
INSERT INTO gvf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu ka di abalini tongwa kaun, ena Yuda ibal ka main ogu yal singaba yalini nil konagi yal ta ogin pisere, u bawa dire ka iru di Yairus tongwa, “I abilin kaya gulemia, nil si tongwa yal tameran imore uname?” ");
INSERT INTO gvf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dimba Yesu pirere iru di Yairus tongwa, “I kuril pirekire pire gi dinanga, ena abilin u wai namua.” ");
INSERT INTO gvf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dire ogu pi bawa dire Pita te Yon te Yemis te gaan nen man, ibal iru tawle, “Na bole ala nabilwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dungure ibal para poraal kane kay bil miimba, Yesu iru dungwa, “I kay miikio. Gaan i gulekimia, imore ul paimua.” ");
INSERT INTO gvf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dungure gimege kaya gulema di piremia, ena ibal ebi mi Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tomba Yesu gimege aan aa tere gala dire iru di tongwa, “Gimege ena i alo.” ");
INSERT INTO gvf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dungure gimege si kwi yere gin taran alungure, komina nenama dire kaman tere di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gi nen man gain nuulin dimba, yal sui kal erungwa di maribe erekinama dire Yesu kiraan aa tere di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Gawlima kobe anan kole kole muru kawnan milin sutan di ku bilere, sia ibal den miriin suna milungwa maa si mena erama dire, te nibil kaan kaan erungwa pilaan pai tenama dire, Yesu yobilaan bile gawlima kobe tomia. ");
INSERT INTO gvf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Terere God kenin ere ke milungwa main kere di ibal tenama dire, te nibil erungwa aa te wai ere tenama dire, nusi erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nusi ere iru di tongwa, “Baan kobi nanga kalkan ire pikia. Goliba te galbale te komina te kobile moni te gal sutan, kal iru ire pikio. ");
INSERT INTO gvf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yal ta ka diduwaide milangwa, ena yalini ogin mile paya. Ogu taw kebe yekio. ");
INSERT INTO gvf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ibal taw ka diduwaide milekire, i aa tekun ere i tekenangwa, ena ogu ai i, i pisere guman yaa tere kal iru erangire, nomanin sire main piramua.” ");
INSERT INTO gvf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Di tongure gawlima kobe ere kaana kaana pire God guun kan kere di tere, te nibil erungwa baan baan aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ena Yesu kalkan erungwa i, Galili gariba gul kenin erungwa yal Kerodi pirungwa. Ibal taw mile, “Nil bile tongwa yal, Yon gulere ale u kwi omua,” dungure te ibal taw mile, “Ilaya u bawa dimua,” dungure te ibal taw mile, “Goma God ka kebe yal ta gulere ale u kwi omua,” dungwa. Ibal kobe iru dimia, ena Kerodi pire gogo ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Milere iru dungwa, “Na Yon naan di keli sibinba, yal i kalkan erungwa pirebinga, ibena mileme?” Iru dimia ena Yesu kanala di pire kol ta waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu nusi erungwa ongwa yal kobe, Aposel kwi sinaa di ere ain ure, konagi erungwa main i, di Yesu tongwa. Di tongure Yesu yalin kobe awli pi Besaida ogu ai pire, na yal kobe inan milala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","“Ere omua,” dungure ibal binanbile pirere duulin bile ongwa. Pirere u bawa dungure Yesu ka wai di tere, God kenin ere ke milungwa mere kere di tere, te nibil erungwa aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ena kamin girala di di erungure, gawlima kobe anan kole kole muru kawnan milin sutan, Yesu milungwa gul ure iru dungwa, “Baan i simi yongwa gul milebina, ena ibal kobe komina gibilin si nere ul painama dire, i nusi malge te komina dungwa gul ero.” ");
INSERT INTO gvf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dimba Yesu iru di tongwa, “Ibal komina nenangwa inin to.” Di tongure yalin kobe dungwa, “Birete anan kole muru te nil kabe sutan tawle dimia, ena ibal binanwenbile komina nenama dire, komina pi gibilin si terabinba?” ");
INSERT INTO gvf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yal binanwenbile, paib tausen, milungwa ka iru sirin bile Yesu tongwa. Tongure Yesu iru di gawlima kobe tongwa, “Ibal pipti mere baan ta milo, te pipti ta mere baan ta milo. Iru muru obin si suna kobi taminin si inin milo, di to.” ");
INSERT INTO gvf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Di tongwa mere erungure, ena ibal para amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Milungure Yesu birete anan kole muru te nil kabe sutan aa tere, kamin gul mine ibe kane yebe ere, God maki ye tere bege dire, gawlima kobe ibal para obin si tenama dire tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ibal para muru nere kubin maamia, komina imo dungwa gal gulungure, gal anan kole kole muru kawnan milin sutan muulungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ena kaun ta Yesu inin mile ana di God te milungure, gawliman kobe ungure, yalini iru sirin bile yalin kobe tongwa, “Ibal kobe na milebingi pirere, takal waa dire na kaanan galeme?” ");
INSERT INTO gvf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dungure yalin kobe maan dire iru di tongwa, “Ibal taw mile, ‘Yon nil bile tongwa yal milinwa,’ dungure te ibal taw mile, ‘Ilaya milinwa,’ dungure te ibal taw mile, ‘God ka kebe yal ta gulere ale u kwi pire milinwa,’ dire ka iru bolebilin di i tomua. ");
INSERT INTO gvf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dungure Yesu ka iru di tongwa, “Ibal iru dimba, na milebingi pirere, takal waa dire na kaanan galine?” Dungure Pita maan dire iru dungwa, “God konagi erungwa yal, Kirisito, i milinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dungure Yesu kiraan aa tere iru di tongwa, “I ka dinga i, di maribe ere ibal tekio.” ");
INSERT INTO gvf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Dire ainere iru dungwa, “Na U Ibal Obinga Yal miliga, ibal kobe gain giil pire na tenamua. Yuda ka main ogu yal singaba kobe, te ka main kenin erungwa yal bil kobe te ka main nil si tongwa yal kobe, yalin kobi na ka diga kile di mena eramua. Na si gulamba, girungwa taangwa are kaun sutakobe wei sinangure, na u kwi pire alalwa.” ");
INSERT INTO gvf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dire ainere iru di ibal kobe tongwa, “Yal ta na munan kol duulin bilala di pirangwa, ena yalini gain kal pirungwa maangure manaa di tere, te giil pire gulabinga mere, yalini kaun kaun giil pire gulere na duulin bilamua. ");
INSERT INTO gvf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yal ta inin gain pire tere mile painangwal painangwa, nomanin tegi dinangwa, ena yal i u main namua. Na inan milegire pire unin sinangwa, ena yal i mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yal ta gariba kal para wen aa te nenamba, gain giil pire iban u mena nangwa, takal iname? Kal ta ikire u main namua. ");
INSERT INTO gvf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yal ta na inan mile, te na guunan kanan diga pire ki erangwa, Na U Ibal Obinga Yal eme na para pire ki ere yal i teralwa. Na te na Abe te yalini angel, naabilungwa bole uralga, yal ta i, pire ki ere teralwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na kawen di i terala ere gule piro. Ibal kobe taw malia abila milungwa ta gulekire, God kenin ere ke milungwa main goma kanere ena gulamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ena ka iru di piserungure are kaun anan kole muru kole sutakobe wei sungure, Pita te Yon te Yemis, Yesu yalin kobe awli kamin kuul pire ana di God terala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pirere ana di milungwa kaun i, yalini guman ta kwi kulungure, te yalini gal pirungwa naabile aw dire, pege wen dire u maribe ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ena yal sutan Mose te Ilaya u maribe pire, Yesu bole ka diria ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yal sui i kamin naabilungwa bole ure, “God kol bala di Yesu tongwa mere, yalini pi Yerusalem pire gulamua,” di tere iru diria ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita te yal su bole milere ul maure ul paamba, alere Yesu naabilungwa kanere, te yal sui Yesu bole milungwa para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yal sui Yesu milungwa gul pisere ere nala di ongwa, ena Pita iru di Yesu tongwa, “Singabo, na ibal kobe milebinga wai pirebinwa. Are dine ogu bil sutakobe kiirala erebina. Ta i ki tere, te ta Mose ki tere, te ta Ilaya ki tere, iru ki terabinwa.” Dire iru dimba, pirekun ere dikimia. ");
INSERT INTO gvf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ka i di milungure kawa ta yobile suna erungure, yal sutakobe kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kawa ye suna erungwa ali ka ta iru dungwa, “Na Wanan taran paale suna ere iga, yalini ka dungwa piro.” ");
INSERT INTO gvf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ka i di piserungure, Yesu inin milungwa yal sutakobi kanungwa. Kalkan i kanungwa yal sutakobi pire unin si mile ibal wen ta, kaun i, di tekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gilaa paire taanima ere ime ungure, ibal binanwenbile Yesu kol baan guman yere kirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ena ibal binanwenbile milungure, yal ta suna ali mile gala dire iru dungwa, “Nil si tongwa yalo, na kawan dire di i teiya. Na wanan taran kule yega milemia, yalini i miriin pire to. ");
INSERT INTO gvf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ena sia aa te ole di pusi daan erungure diibe daibe erungure, te sia gin taran gala bil dungure, yalini giran ebilin simua. Te sia gain giil pire yalini te milungwa milungwa, ena yalini piserungure gulangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","I gawlima kobe, ‘Maa si mena ero,’ kawan dire di tegire, maa si mena erala di erimba, kuunin paikimua.” ");
INSERT INTO gvf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dungure Yesu maan dire iru dungwa, “Ayo, i yal kobe malia maalinga pire gi ta dikire, taalime eringa ibal milinwa. Kaun tamintan inin bole imo mile pairale? Kaun tamintan i taalime eringa na obin kine ire warabine?” Dire iru di gaan nen tongwa, “I wanin awli ya wo.” ");
INSERT INTO gvf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dungure awli ungwa, sia gomege aa te ole dire pusi daan erungure, diibe daibe erungwa. Erimba Yesu mile, “Ere tayan po,” dire kawre di sia tomia, ena gomege u wai ongwa. Ongure Yesu iru di yalini nen tongwa, “I wanin imore milungwa nusi i teiwa.” ");
INSERT INTO gvf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","God yobilaan wen bilungure Yesu kalkan iray eremia, ena ibal para kane buul kunungwa. Ena Yesu kalkan erungwa i, ibal buul kune milungure, Yesu iru di gawlima kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ka ta malia di i teralgi, pire nomanin suna yeyo. Na U Ibal Obinga Yal, yal kobe na kanin sire awli ibal tenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dimba ka dungwa i, pirekun erekungwa. Ka dungwa i gawlima kobe main ta pirekenama dire, Yesu di maribe erekimia. Di maribe erekungwa, ena main sirin bile tenamba, taw kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gawlima kobe mile, “Na inan yal kobe ibena u singaba name?” dire ka bolebilin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ka dire nomanin si pirungwa i, Yesu pirere gamege ta awli ungure, Yesu binan ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Milungure Yesu iru di yalin kobe tongwa, “Yal ta na guunan kanan pire aa te wai ere gaan i tenangwa mere, yalini aa te wai ere na tenamua. Te yal ta aa te wai ere na terere, ena yalini para aa te wai ere na nusi erungwa yal tenamua. I yal kobe milinga suna i, ‘Yal ta digan milemua,’ dinba yalini singaba milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dungure Yon iru di Yesu tongwa, “Singabo, yal ta i kaanin gale sia maa si mena erungwa kanebinba, yalini na yal kobe bole taran yekibinga yal milemia, manaa di tobinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dungure Yesu iru di tongwa, “Yal ta kayminan paale na tekenangwa, yal i na ye nega milemua. Iru milemia i manaa di tekio.” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God Yesu kamin ai awli nangwa kaun u maala ungure, Yerusalem nala dire nomanin tegi dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dire gawlima kobe taw ka kebe yongure, yalin kobe goma pire Sameria ibal malge ta kalkan aa tekun erala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Omba malge iray ibal kobe mile, “Yalini Yerusalem nala dimua,” direre, te Sameria ibal san bale Yerusalem ibal tongwa, aa te wai ere tekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iru erungwa gawliman sui Yemis te Yon pirere iru dungwa, “Yesu Singabo, kamin mina kamin nege erungwa mere, iru enderin derin pusi ime eramia, ibalin kobe de taa nama dire, God ka iru di terabilo?” ");
INSERT INTO gvf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dungure Yesu yal sui inaadi kanere kan tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Terere gawlima kobe bole pi ogu ai ta ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ere ongure yal ta ure iru di Yesu tongwa, “I baan baan nala dinanga gul, i na i duulin bile nabilgirawa.” ");
INSERT INTO gvf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dungure Yesu di yalini tongwa, “Awi ele paangwa ain dimin gul dungure, te kauba aan ye paangwa aan dimba, Na U Ibal Obinga Yal baan ta pairabina ai ta dekemua.” ");
INSERT INTO gvf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dire iru di yal ta tongwa, “Na munan kol duulin bilo.” Di tomba yal i iru dungwa, “Yal Singabo, na abe gulala dungwa goma maul si yerabina po, di na to.” ");
INSERT INTO gvf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dimba Yesu ka iru di tongwa, “Gulala di milungwa ibal kobe, ibal taw goma gulungwa i, maul si yenamua. I God kenin ere ke milungwa mere main i di maribe erana po.” ");
INSERT INTO gvf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yal ta ure ka iru dungwa, “Singabo, na i mun kol duulin bilabinba, goma nen man kobe kaalere kalkan kobe aa tekun erabina, po, di na to.” ");
INSERT INTO gvf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dungure Yesu ka iru di yal i tongwa, “Yal ta komina gul konagi erala di erimba, sin nege ere milungwa milungwa iwe, yalini God kenin ere ke milungwa ai suna nangwa paikimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ena Yesu ka i, di wei sire yal sutakobe aan kawn muru te anan kole kole muru, yal kobe iru paale suna ere irere, yal sutan sutan si dawle nusi erungwa. Yesu ai baan baan i pi bawa dirala dire, ena ibal kobi goma yere, “Kol bala dinana po,” di nusi erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nusi ere iru di tongwa, “Komina milin binanbile bol yomba, ibal bulangwa tawlita milemua. Milemia ena i iru ana di komina kobaan yal, God to. ‘Ibal taw ama i konagi ere komina bulama di nusi komina gul ero.’ ");
INSERT INTO gvf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bolima siipe siipe gawlin kwi mile, awi eli paangwa ain ware milungwa mere, i iru milanga ena i po. ");
INSERT INTO gvf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gal kaban te galbale te kawn tobilin ire pikio. Yal ta kombil baan guman yenanga, ‘Yalkuno,’ di tere aya maya dire, ka di te milekio. ");
INSERT INTO gvf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","I ogu ta ala nanga ogu i kobaan milangwa, ‘Yalkuno, i mile dinio,’ dire goma iru di to. ");
INSERT INTO gvf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te den miriin suna yaa ime si milangwa yal, ogu iray ki pai milangwa, ena i ka di tenga painamua. Painamba yal ta iru ta milekenangwa, ‘Yalkuno,’ ka dinga i paikinamua. ");
INSERT INTO gvf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","I milanga ogu i mile paire, te konagi erungwa ibal aibe tobe imia, ena komina i tenangwa no. Ogu taw kebe yekio. ");
INSERT INTO gvf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","I ogu ai ta nanga ibal kobe i aa tekun erangure, komina obin si i tenangwa, no. ");
INSERT INTO gvf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ogu ai i, ibal nibil erungwa aa te wai ere tere, te iru di ibalin kobe to, ‘God i kenin ere ke milamia.’ ");
INSERT INTO gvf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Iru ere i tenamba ogu ai ta aa tekun ere i tekenangwa, ena i pi malge pire iru di ibalin kobe to, ");
INSERT INTO gvf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘I ogu ain gariba ulgu na kawnan daangwa kire di ain erebinwa. Erebingire na piseremua, pire nomanin sire main i pirinwa. Pirinba ka dirabina main i piro. God i ibal kobe kenin ere ke milamba.’” ");
INSERT INTO gvf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dire ka iru di gawlima kobe tongwa, “God ibal para muru ka kol ere tenangwa kaun iwe. Ka kol ere Sodom ibal tenamba, ka kol bil ere ogu ai iray ibal tenangure, gain giil bil piramua. ");
INSERT INTO gvf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ayo, Korasin ibal te Besaida ibal, i ibalin kobe para gain giil piranwa. Kal guman kwi dungwa i milinga gul ere i tobinga mere, Taya te Saidon gariba gul ere terabinga iwe, ena yalin kobe kaya nomanin suna si kiruul sinamua. Sungure ibal kanama dire weray si painamua. ");
INSERT INTO gvf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","God ibal para muru ka kol ere tenangwa kaun iwe, ena Taya te Saidon Yuda milekungwa ibal ka kol ere tenamba, i ibalin kobe ka kol niminin milungwa ere tenangure, gain giil bil piranwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapanaum ibal kobe iwe, kamin ibal milia di pirinba, God i pusi enderin gaul ai eramua.” ");
INSERT INTO gvf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dire ainere iru di gawlima kobe tongwa, “Yal ta i ka dinga wiina ere tenangwa, ena yal i giran wiina ere na tenamua. Te yal ta mun kal waa i tenangwa, ena yalini mun kal waa na terere, te na nusi erungwa yal para mun kal waa yalini tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yal sutakobe aan kawn muru anan kole kole muru yal kobe iru nusi erungure, sinaa dire kwi ure wai wen pire iru di Yesu tongwa, “Singabo, i kaanin gale kaman tere di sia tobinga, ena sia kobe na giranan wiina ere na tomiawa.” ");
INSERT INTO gvf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dungure Yesu maan dire ka iru di tongwa, “Kamin nege erungwa mere, Satan kamin ain piserere yaa ime sungure, na kane miliwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ena i piro. Oniba te daula kabin i egile kunuul galana dire, te i kayminin ta niminin milungwa i sinana dire, na i yobilaan bile tegire, kal ta i sekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sia i giranin wiina ere tomia, wai pire miinin maakio. Maakinanba God ibalin kobe milana di pire i kaanin kaya bile paalemia, wai pire miinin maayo.” ");
INSERT INTO gvf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ena kaun i, God Kegemama Iban pi Yesu den miriin suna milungwa, ena Yesu miriin paire ka iru dungwa, “Na Abe kamin te gariba para kobaan taran i milinwa. Ka main dungwa iray, nomanin paangwa ibal di maribe ere tekinba, gamege mere pire pol sekungwa ibal i di maribe ere yalin kobi tenwa. Tenga i, na i maki ye i teiwa. Kal iru eringa ena para paamiawa. Na Abe i inin iru nomanin si piringa mere, eringa paamiawa.” ");
INSERT INTO gvf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dire iru dungwa, “Na Abe konagi kalkan kobi para muru na tomua. Na Abe God Wan na taran milia, yalini taran tawle na kane pol simua. Yalini Wan na iwe, na inan taran tawle na Abe kane pol siwa. Sire na Abe guun kan di maribe ere ibal taw terala di pirebina, ena yalin kobe para wen yalini kane pol sinamua.” ");
INSERT INTO gvf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dire ena Yesu te gawlima kobe bole inin milungwa ka iru di tongwa, “I kalkan kaninga mere, ibal kobe para iru kanangwa miriin painamua. ");
INSERT INTO gvf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ka ta di terala i piro. God ka kebe yal kobe te gariba baan baan yal bil kobe kamin kaya milungwa yal kobi iru binanbile i kanere, te piringa mere kanala di pirimba, ta kanekimua.” ");
INSERT INTO gvf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ena Yuda kile kaman ka nil si tongwa yal ta ure, Yesu kela kule bawle terala dire, ka iru sirin bile di tongwa, “Na mile pairabingal pairabina dire, ta konagi erabine?” ");
INSERT INTO gvf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Dungure Yesu ka iru di tongwa, “Mose kile kaman ka takal waa dire bileme? Te ka dungwa i main tamintan pirine?” ");
INSERT INTO gvf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dungure yal i maan dire ka iru di Yesu tongwa, “‘God i Singaba den miriin tere, ibanin tere, nomanin tere oisa yalini tenanwa.’ Te ka ta iru dungwa, ‘I inin nomanin tere gaynin kenin eringa mere, enin taw kobe nomanin para iru tenanwa.’” ");
INSERT INTO gvf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dungure Yesu ka iru di yalini tongwa, “I ka dinga paimua. I iru eranga mile painangal painanwa.” ");
INSERT INTO gvf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dimba Yuda kile kaman ka nil si tongwa yal ibal na painama di pirere, iru di Yesu tongwa, “Dimba na enan taw kobe ibena mileme?” ");
INSERT INTO gvf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dungure Yesu ka iru di tongwa, “Yal ta Yerusalem ai pisere pi Yeriko ai ime ongure, kalkan kunibe nongwa yal kobe nu pai mile ure sirere, yalini kal aa te nongwa i kunibe i ongure, ena yal i gulala di eremua. ");
INSERT INTO gvf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Erungwa ena Yuda ka main kenin erungwa yal ta, kombil i ware urere kanimba, kombil binan kole pale sire ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ilibai yal ta para iru urere pi yalini kanimba, kombil binan kole pale sire ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yal sui kal iru erimba, gariba baan ta Sameria yal ta ware urere, yalini milungwa gul u bawa dire kanere, miriin wen pire tomua. ");
INSERT INTO gvf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Terere pi nimbona kabe si tere kan daa tere yalini inin bolima donki mun bolimina aw si tere, awli pi kombil baan ogu ta ala pire kenin ere milemua. ");
INSERT INTO gvf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Paire kamin taangure, kwimile Sameria yal i, pi ogu kobaan kina sutan tere iru di tongwa, ‘I yalini kenin ere gule ere milo. Komina gibilin sinanga malia kobile moni i tega i kuunin erekinamia, ena na kwi abila uralga kobile maan i te ain eralwa.’” ");
INSERT INTO gvf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu ka pore iru dire ka iru sirin bile yal i tongwa, “Kunibe nongwa yal kobe ure yal ta simba, yal sutakobe kombil wiria di kanungwa iwe. Enin taw ibena milama di pirine?” ");
INSERT INTO gvf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dungure Yuda kile kaman ka nil si tongwa yal iru di tongwa, “Aa ki di tongwa yal enin taw milemua.” Dungure Yesu ka iru di tongwa, “Para dina, ena i kal iru erana po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Di pisere Yesu te gawlima kobe bole ere pire, pi ogu ai ta u bawa dungure, abal ta kaan Mata milere, Yesu awli pi ogu ala pire aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tongure abalini kebin kaan Maria milere, u Yesu milungwa gul kawn mina amin di mile Yesu ka nil si tongwa pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Milimba Mata konagi nega di ere, kalkan binanbile aa te wai eremia, ena kiraan yongure urere ka iru di Yesu tongwa, “Singabo, na kebinanbi na pisere ere ungwa, na inan mile komina kalkan aa te wai ere miliiba, i miriin pire na tekino? I na kebinanbi di tengire, abalini u aa ki di na tenamba?” ");
INSERT INTO gvf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dungure Singaba Yesu iru di abalini tongwa, “Ayo, Mato, kalkan kobi nomanin binanbile singire u sintan erimba, ");
INSERT INTO gvf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kal taranta wi yebe ongwa pirekun erekinwa. Maria konagi wai eremia, na ka ta di tekerabinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ena kaun ta Yesu ai baan ta ana di God tongwa. Te piserungure gawliman ta ure ka iru di tongwa, “Singabo, ana di God tenga iwe. Yon ka nil si gawlima kobe tongwa mere, i para iru nil si na to.” ");
INSERT INTO gvf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dungure Yesu iru di gawlima kobe tongwa, “Ana dinanga ena iru do, ‘Na Abe i kaanin wi yebe namua. I kenin ere ke milanga kaun unama di pirebinwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kemina komina kuunin biinangwa mere na to. ");
INSERT INTO gvf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ibal kobe kal digan ere na tongware, pirin paangwa gule ere tobinga mere, kal digan ere taalime erebingire, pirin paangwa i gule ere na to. Kunibe kura taalime terabina di erebinga, i na awli suna pikio.’” ");
INSERT INTO gvf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Dire ainere iru di tongwa, “Yal ta i suna milungwa gilaa wen ye nenga ogu i ta pi gala di ala ere iru di tenanga, ‘Yalkuno, na enan ta kol baan ta nala dire u na milebinga gul u bawa dimiawa. Dimba na komina ta wen ta, ta dikimia, i komina birete sutakobe na tengire, eme maan i terabina.’ ");
INSERT INTO gvf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iru di ala eranba yalini ala mile ka iru dinangwa, ‘Na kaya ul paya, i ere po. Na kol kaya yaalere, na wanan abilan kobe bole bol taran mina paibina, na kwi milabinga komina kan dinga i terabinba.’ ");
INSERT INTO gvf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yalini ale mile iru dinamba, i kal eranga mere ka pore ere i terala piro. Yalini i ye nenga milimba, kal ta tekerala di piramua. Piramba i gala dire, ka dagi di milanga milanga gay ta gulekenanga, ena kal ta i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Iru eramia ka di i terala piro. Kaan dinanga inana, ena i kaan do. Te kal ta waa duunanga kanana, ena i waa duyo. Te kana giran mile si gule dinanga kol yawle i tenamia, ena si gule do. ");
INSERT INTO gvf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaan dinangwa inamua, te waa duunangwa kanamua, te kana giran mile si gule dinangwa yawle tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ena i yalin kobe milungwa gul suna iwe, I wanin ta komina bilebale kaan dinangwa, degilime ta tenan, ");
INSERT INTO gvf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","mo korale milin kaan dinangwa, daula kabin tenano? Ta iru ta tekenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","I yal kobe kal digan ere milinba, i kalkan wai dungwa i wanin abilin terala di piringiwe. Ere tenga mere ibal kobe mile, ‘God Kegemama Iban na to,’ kaan di Abe kamin mina milungwa tenangwa, terala eremua.” ");
INSERT INTO gvf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sia ta du dungwa Yesu maa si mena erungwa, ena kaya ere mena ongure pare, yal ta i kwi kawn kule ka dungwa. Dungure u ku bilungwa ibal binanbile buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kunimba ibal taw iru dungwa, “Sia bil wen kaan Bielsebul, Yesu aa ki dungure, yalini sia maa si mena eremua.” ");
INSERT INTO gvf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ibal taw Yesu kela kule bawle terala dire, iru sirin bile Yesu tongwa, “Kamin mina ibe kal guman kwi dungwa i maribe ere na yal kobe to.” ");
INSERT INTO gvf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dimba yalin kobe nomanin si pirungwa main i Yesu kanere iru di tongwa, “Gariba baan ta ibal kobe inin inin kura bilangwa, ena kaun taran wei sinamua. Nen abin kobe guman inin inin dinangwa, u more more namua. ");
INSERT INTO gvf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan ibalin kobe inin inin kura bilangwa mile painamo? Ta mile paikinamua. Bielsebul yalini man bile tongure, na ‘Sia maa si mena eremua,’ di na tenba, ");
INSERT INTO gvf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","na iru eralga i inin gawlimanin kobe maa si mena erungwawe. I gawlimanin kobe iru ere milebina di pirungwa, ena i ka dinga, ‘Ta paikimua,’ dire di maribe eremua. ");
INSERT INTO gvf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","God aa ki di na tongure, na sia maa si mena eriwa. Eriga God kenin ere ke milungwa mere, i milinga gul kaya u maribe ongwa kaninwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Naanin paangwa yal simil el para aa te ire ogin el kwi nuu mile kenin ere milangure, kul gal bona aa te nongwa dorimil dinamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dinamba naanin wen paingwa yal ta urere, el kwi nuu milungwa yal iray simil el aa gi di mile, ‘Yal ta na bona gana ta ikinamua,’ iru piramba, si kiranin bilere simil el para irere, gal bona obin si ibal kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yal ta na bole yekibilga, yal i kaymin paale na tomua, te yal ta na bole di ku bilekenangwa, ena di sutaw erangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sia ta yal den miriin suna milungwa pisere ere baan ta pire, gariba simi yongwa gul ogu ta painangwa ai waa duunamua. Ogu ta dikinangwa kanere iru nomanin si pirangwa, ‘Ogu ta piseriga, ogu iray kwi pi pairalwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dire kwi ere nangure, ogu kaya bine dire bigin sire aa tekun erungwa, ogu ala i iru erungwa, pi kanamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iru kanere pare, kwi ere pire sia anan kole muru kole sutan awli milungwa gul urere, sia para yal den miriin suna pai milamua. Sia ta goma milungwa kal ki ere milimba, sia eme unangwa ki wen ere milangwa, ena yal iwe. Goma yal i tawlita wai ere milimba, eme wai ta milekire nigi wen dongwa milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu ka dungwa i di piserungure, abal ta ibal binanbile suna milere ka iru di tongwa, “Abal ta i kule yere te amin i tongwa iwe, abalini miriin paimua.” ");
INSERT INTO gvf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dimba Yesu maan dire iru dungwa, “I iru dinba, ibal kobe God ka dungwa pire wiina ere tenangwa, miriin go painamua.” ");
INSERT INTO gvf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ena ibal binanbile u ku bile Yesu yobile suna erungure, Yesu ka ta kwi kawn kule iru dungwa, “Ibal malia maalungwa kal ki ere taalime erungwa milemua. Kamin mina kal guman kwi dungwa ta kanabina di pirimba, ta i maribe ere tekenamua. Tekenamba God ka kebe yal Yona milungwa kaun, kal guman kwi dungwa erungwa mere, ere ibalin kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Goma Niniba ibal main pirama dire Yona kal erungwa mere, malia ibal malia maalungwa main ta pirama dire, Na U Ibal Obinga Yal kal ta erabinwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Solomon nomanin paire ka main dungwa, Siiba gariba gul abal singaba bil gariba gul pisere, tayan wen pire Solomon ka dungwa pirala di omua. Omba malia iwe, Solomon milungwa mere ungwa tamama. Yal bil wen umba, i yal kobe ta pirekinwa. Pirekinga God ibal para ka kol ere tenangwa kaun u bawa dinangure, abal bil iray mile, ‘Pirin paimua,’ di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yona ka main kere di tongwa, ena Niniba ibal pirere kal digan ere taalime erungwa pisere nomanin suna si kiruul si piremua. Pirimba malia iwe, Yona milungwa mere ungwa tamama. Yal bil wen umba, i yal kobe ta pirekinwa. Pirekinga, God ibal para ka kol ere tenangwa kaun u bawa dinangure, Niniba ibal mile, ‘Pirin paimua,’ di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Enderin derin gale i ogu ala pirere aal kule ta yekire, te bale bilkaw main ali para ta yekire, ibal ere ala ure kanama dire bol bolimina yomua. ");
INSERT INTO gvf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Enderin derin dere kol i maribe erungwa mere, i omilin minai kol i maribe ere i tomua. I omilin kanere wai eranga, i nomanin naabilamua. Dinamba i omilin kanere ki eranga, i nomanin kama sinamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iru eremia ena na nomanin naabilema di kananba, naabilim mo, kama sim mo, i pirekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","I nomanin naabilangure, kama ta sikinamia ena i nomanin para naabilamua. Enderin derin dere aw dire kol i maribe erungwa mere, iru wen naabilamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ena Yesu ka i di piserungure, Parasi yal ta mile, “I na bole komina nerabila wo,” dungure, pi ogu ala pire komina nerala dire amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yuda main paangwa mere Yesu duulin bile erekungwa, yalini kaya aan bigin sikire komina ne milungure, Parasi yal i kane buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kunemia ena Yesu Singaba iru di yalini tongwa, “I Parasi kobe pele te sin kabe miina kol bigin singa mere, iru i yal kobe gaynin bigin sinwa. Sinba i kakiibi dire, kunibe nere, nomanin suna i gule daalin simua. ");
INSERT INTO gvf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nomanin paikungwa ibal kobe milingiwe. God gain ere yomba, nomanin suna ibe den miriin para ere yomiawa. ");
INSERT INTO gvf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","I kalkan obin si imore tenanga mere, i nomanin te den miriin tenana ena nomanin naabilamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Eke, i Parasi yal kobe milingiwe. Komina kaa kawi sinangwa, kal sup te kawi te kungu para anan kole kole irere taranta kora kulungwa God tenwa. Tenba ibal kobe wai kenin ere tere, te den miriin God tere, kal iru paangwa piserinwa. Piseringa ena i giil piranwa. Piseringa kal i kuunin ere wiina ere tenanba, ka megemaaga iray para wiina ere tenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Eke, i Parasi yal kobe milingiwe. Ka main ogu ala pire singaba bol kaana amin di milabina di pire, te u ku bilungwa gul engire, ‘Singabo,’ di gala di tongure, i wai pire miinin maananwa. Iru eringa ena giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ibal yene yobilaan gul aal kule dungwa mere, i iru milinwa. Aal kule dungwa ena ibal kobe kanekire egilemua.” ");
INSERT INTO gvf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dungure Yuda kile kaman ka nil si tongwa yal ta iru di Yesu tongwa, “Nil si tongwa yalo, i iru dinga i na yal kobe para gain ka si na tenwa.” ");
INSERT INTO gvf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dungure Yesu maan dire iru dungwa, “Eke, Yuda kile kaman ka nil si tongwa yal kobe milingiwe. I yal kobe kal obin go dongwa kine ibal tenba, i si nege ere aa ki di ibal tekinwa. Tekinga ena giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","God ka kebe yal kobe gulungwa kobile giran ai wai dungwa yenba, i sanamoi gilekume ka kebe yal kobe si gulemua. Iru eringa ena giil piranwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","I sanamoi gilekume mile, God ka kebe yal kobe si gulungure, ena i yalin kobe yene yobilaan giran ai wai dungwa yengiray, ena sanamoi gilekume kal iru erungwa i, ‘Para wai paamua,’ dinwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iru dinga i, ena buku ta kaan God Nomanin paangwa iru bile paalungwa, ‘Na ka kebe yal kobe te nusi erungwa ongwa yal kobe para, nusi ere ibal kobe terabinba, ibalin kobe yalin kobe taw si gulere, te ibalin kobe giil pire yalin kobe taw tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Iru eremia ena kama kaya wen God ka kebe yal si gule ungwa ungwa, ibal malia maalungwa pirin paingure, ena God ibal kobe malia maan sinamua. ");
INSERT INTO gvf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Goma yal ta kaan Ebel si gulemia. Si gule ongwa ongwa eme Sekaraya awli pi ka main ogu bile malge pire, ka main ogu bil iray te kalkan God tongwa bol kalin sui, i kole kole ere baan suna si gulemua. Kama kaya si gulimba, ibal malia maalungwa pirin para muru pai yalin kobe tenangure, giil piramua. Na kawen di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Eke, Yuda kile kaman ka nil si tongwa yal kobe milingiwe. Ka main i inin pirala di pire ki milin aa girin di mile kol yawle ibal kobe ta tekinwa. Tekinba i ala ta pikire, te ibal ka main pirala di omba, i manaa di tenga ena gain giil piranwa.” ");
INSERT INTO gvf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu baan i pisere ere nala di ongure, Yuda kile kaman ka nil si tongwa yal kobe, te Parasi kobe bole bale guane ware di Yesu tere, te main ta ta para pirala dire sirin bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tere Yesu ka ta dinangwa paikinama di pire kane milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ka di milungwa kaun i, ibal binanwenbile u ku bilere kawn egile gi dungure, diibe daire erungure, Yesu goma iru di gawlima kobe tongwa, “Komina birete u bil ongwa mere, Parasi kobe ka di miriin kaale tongwa yal mile ka dungwa sidina di u bil ongwa, i nai kane milo. ");
INSERT INTO gvf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kalkan si alibe erungwa eme aw di u maribe nangwa paamua. Te aal kule paangwa muru eme u maribe nangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iru paamia ena i aal kule dinga, bolin kule di maribe erangure pirangure, te i ogu ala ka mone di di tenga, eme malge pire gala di maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ye nega ka ta di terala piro. Yal ta, i sirala dire unangure, kuril pirekio. I gaynin taran si gulamba, kal ta para kal piril sungwa ere i ta tekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dimba, yal ta i kuril pire tenanga yal iwe, di maribe ere i terala piro. God ibal si gulangwa, ena nusi enderin gaul ai erangwa paamua. Paamia i yalini kuril pire to. ");
INSERT INTO gvf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kauba dauna anan kole muru i gibilin sirala dire kobile baa, toea sutan tenba, God kauba kobi nomanin si pire kane pol simua. ");
INSERT INTO gvf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ena iwe, i gibiliigin para wen God kere pol simia, i kuril ta pirekio. God kauba dauna muru kenin ere milimba, i kenin wai wen ere i te milemua. ");
INSERT INTO gvf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ena ka ta di i terala piro. Yal ta ibal milungwa mina mile, ‘Na Yesu gawliman miliwa,’ dinangwa ena Na U Ibal Obinga Yal, God angel kobe milungwa mina mile yal ta i kaan di maribe ere teralga paamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Paamba yal ta ibal milungwa mabin mina mile, na ka di kile di mena ere na tenangwa, ena Na U Ibal Obinga Yal, God angel kobe milungwa mina mile, yal ta i ka di kile di mena ere yalini teralga paamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yal ta Na U Ibal Obinga Yal gain ka si na tenangwa, ena pirin paangwa i kire di erangwa paamua. Paamba, yal ta gain ka si God Kegemama Iban tenangwa, kire di erekinangure, pirin pai dinangwal dinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ibal kobe i awli pi Yuda ka main ogu ala pire, mo awli pi gariba gul yal bil kobe ogu ala pire, mo gariba gul kenin erungwa yal bil kobe ogu ala pire ka kol pirama dungure maan dire, ‘Tawa dirabine?’ i nomanin si gogo erekio. ");
INSERT INTO gvf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ena kaun i ka dinanga mere, God Kegemama Iban ka nil si i tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ibal binanbile u ku bilungure, yal ta suna milere iru dungwa, “Nil si tongwa yalo, na abe gulungure, kalkan aa te nongwa i na abinambi muru girin di imia, ena yalini na taw na tenama di piria, di to.” ");
INSERT INTO gvf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dimba Yesu ka iru di yalini tongwa, “I nenin kalkan kobi na obin si i yasu terala dire, ibena konagi iru ere na tome? Ta na tekemua.” ");
INSERT INTO gvf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dire ainere iru di ibal kobe tongwa, “Ibal kobe kalkan para ka dagi di sanin bilangwa kal i, i nomanin tegi dikio. Yal ta bona gana binanbile aa te nenamba, mile painangwal painangwa yalini kalkan aa te nongwa kal i inin aa ki di tekenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dire pare ka di bile dire iru dungwa, “Kalkan binanbile aa te nongwa yal ta komina yaalere buule yuungwa milin paamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Milin paangure yalini iru nomanin si pirungwa, ‘Na komina binanbile buule yuubinga, yerabinga ai ta dikimia, takal erabine?’ ");
INSERT INTO gvf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dire iru pirungwa, ‘Komina ogu golin si suulere bilkaw kwi kiirabinwa. Na konagi iru erabinwa. Te ogu ki pisere komina te bona gana muru ala yerabinwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ye pisere ena ka iru diralwa, Singabo, komina te bona gana binanbile ala yobingire, nerabinga me erin binanbile wei ta sekenamua. Konagi erekire mone di milere, komina ne milere miinin maaralwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dire iru nomanin si pirimba God iru di yalini tongwa, ‘I yal du milinwa. Kemina gilaa i ibanin baan ta pire gulanga, God iru ere i tenamua. Aa te nerala di piringa kal i, ibena nename?’ ");
INSERT INTO gvf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ibal kobe bona gana inin aa te nenangwa, binanbile kire di yuungwa para iru milamba, aa te nekungwa mere milema di God iru piremua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dire pare Yesu iru di gawlima kobe tongwa, “Maliaga iru diga paamia, ka ta dirala piro. Mile pairalga ta komina nerale? Te gwi gulekiralga ta gal ire sigi dirale? I iru piranga, nomanin binanbile si pirekio. ");
INSERT INTO gvf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ena we, komina nenangai wai painamba, mile painangwa wai wen painamua. Te gal sigi dinanga wai painamba, gaynin wiige sire wai wen dinamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","I sibayaa main kanere nomanin si piro. Kauba komina ta yaalekire, te buule i ala ere ye nekimua. Main iru paamba, God kauba kobi kenin ere komina tomua. Kauba milungwa kenin erimba, ibal milingai God kenin wai wen ere i tomua. ");
INSERT INTO gvf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Garamil mile gulal mo, te bia yere gulal mo, i iru nomanin binanbile si piranga, bolima ogu ta ama milano? Tamama. Ena nomanin binanbile si pirekio. ");
INSERT INTO gvf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","I kal iru tawle erangure paikinamia, tameran kal ta ta para i suna ali kuku maame? ");
INSERT INTO gvf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Eri maare kuun sungwa maini, i nomanin si piro. Konagi ta erekire gal para ta warekimua. Kuun sungwa main iru paamia, ka ta di i terala piro. Yal singaba Solomon egin galungwa wai paamba, eri kuun sungwa mere iru wai wen paimua. ");
INSERT INTO gvf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God eri kuun sungwa kenin wai ere milemua. Milimba kuun sungwa iwe, kemina kuun wai si dinamba, erima are dere kuun ulu dinamua. God eri kuun sungwa kenin erungwa, i ibal kobe kenin ere milekenamo? Kenin ere milangiray. Pire gi tawlita dinga yal, God galsuna i kaw tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tenamia komina te nil alde dinangwa nerale? I iru nomanin binanbile si pire, ka iru dikio. ");
INSERT INTO gvf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kalkan iray God kanin pirekungwa ibal kobe morin morin irala di piremua. I kalkan iray ta nekire, para ta milekenanga i Nenin God iru piremua. ");
INSERT INTO gvf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","God kenin ere ke milungwa mere, i yal kobe nomanin tegi dinanga kalin kan dinga i, i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Bolima siipe siipe tawle taminin si milungwa mere, i yal kobe iru milinba kuril pire tekio. God kenin ere ke milungwa i ibal kobe bole milana dire, God iru pire dimua. ");
INSERT INTO gvf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","I kul gal bona para ibal tere kobile moni inanga, aa te nekungwa ibal kobi obin si to. Kalkan imo di painangwal painangwa aa gi do. Kamin gul bona gana dungwa gul i daibe daibe do. Dinanga u mege ta pikinangure, ibal ala pire kunibe nekenangure, te gunagaan para ta nekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bona gana i nomanin si gumanin erin yenanga, i ibanin nomanin para te minai eranwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kal ta u maribe nangwa i ta pirekina, ena kin kaya dere koray marua kiire, el kwi i nu milo. ");
INSERT INTO gvf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yal abal ingwa kaun komina bil nerala di yal singaba ta ongure, yalini nil konagi yal kobe we. Singaba komina ne pisere sinaa dire unangure, yalin kobe kalkan aa tekun ere suul milere singaba kol si gule dinangwa gin taran yawle tenamua. Iru eramia i kanekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nil konagi yal kobe kanekun ere milungure, singaba ure kanamia, ena yalin kobe miriin wen painamua. Singaba kal iru eramua. Singaba ure, ‘Nil konagi yal kobe amin di milo,’ di tere kin dere, koray pire i sire pi komina ki yalin kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Singaba gilaa taanima unam mo, gilaa taanima wen ure nil konagi yal kanekun ere milangwa kanamia, yalin kobi miriin wen painamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ka ta dirala nomanin si piro. Kunibe inangwa yal unangwa kaun ogu kobaan piramia, ena kunibe nerala di namba, ogu kobaan kenin ere milemua. ");
INSERT INTO gvf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na U Ibal Obinga Yal na ta wekinama di piringa kaun i, urala eria i ibal kobe kanekun ere milo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dungure Pita iru dungwa, “Singabo, ka di bile dingai, ka di na yal kobe tawle ten mo, ibal para ka di tene?” ");
INSERT INTO gvf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dungure Yesu Singaba maan dire iru dungwa, “Yal singaba nil konagi yal pi tegi yongure, nil konagi yal i nomanin paangwa iwe. Nil konagi ibal kobe kenin ere mile kamin kaun kaun komina obin si ibal tenama dire, yal singaba yal ta paale suna ere irere ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yalini sinaa dire kwi unangwa iwe. Nil konagi kenin erungwa yal, singaba wiina pai tenangwa singaba ure kanamia, ena nil konagi kenin erungwa yal miriin wen painamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ena singaba wai wen pire kul gal bona muru nil konagi yal iray kenin erama dire, konagi iru tenama di, di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Iru painamba, nil konagi yal iray mile, ‘Na singaba baan araway mile kwi wekenamua,’ dire iru di piramia, ena nil konagi enin kobe yal abal para kuba sire, te komina nere nil nere omilin maalamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Maalangure singaba kaun ta wekenama di pire, te singaba unangwa kaun pire pol sikinamba, kaun ta i kobaan unamua. Urere nil konagi yal iray si wei sirere, pusi pire gi dikungwa ibal kobe milungwa gul eramua. ");
INSERT INTO gvf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nil konagi yal mile konagi kobaan kile kaman ka di tongwa pirinba, giran mina wiina ere tekire, te konagi erangwa kalkan aa tekun erekinamia, ena konagi kobaan kuba aa tere binanbile sinamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sinamba nil konagi yal ta mile singaba kile kaman ka pirekire, kal piril sungwa erangure, kuba aa tere sinangwa para wai painamba, tawlita sinamua. Yal ta kal ta miremil erama dire God nomanin pai yalini tomia, ena yalini konagi nega di erangwa painamua. Yal ta kal aa te nere taw ama tongure imu dire aa te nenamia, ena ibal kobe yalini pirin pai tongure, eme maan te kora kule tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Na uga gariba gul enderin dere, enegi maanama di pire wiwa. Te kaya denama di piriwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na gaynan giil piralga paamba, ole pirekire suna ali ku ku maa yebe umua. Umia ena gaynan giil malia pirala di piriwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Na uga main iwe. Ibal kobe bole pena gale milama di iru nomanin si pirekio. Ibal kobe bole pena gale milama dire na ta ukiwa. Ibal kobe guman inin inin dinama dire na ere ime wiwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Malia te eme para iru pilau di u maribe namua. Yal gawlin ta anan kole muru milamba, obin sire yal sutakobe kaymin paale yal sutan tenangure, te yal sutan i kaymin paale yal sutakobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nen kobe kaymin paale wan kobe tenangure, te wan kobe kaymin paale nen kobi tenamua. Man kobe kaymin paale abin kobe tenangure, te abin kobe kaymin paale man kobi tenamua. Ain kobe kaymin paale kolin kobe tenangure, te kolin kobe kaymin paale ainbi kobi tenamua. Ibal kobe para iru milama dire, na ere ime wiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dire ena Yesu iru di ibal kobe tongwa, “Kuman kamin iray kawa kama sungwa kanere, ‘Nimin sinamua,’ dingire ena nimin sungwa kaninwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te bomai kamin gwi bilkaw maare kamin more erungwa kanere, ‘Are go denamua,’ dingire ena are dongwa kaninwa. ");
INSERT INTO gvf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka dire miriin kaale tongwa yal i milingiwe. Gariba te kamin kama milungwa kaninga main pirinba, tameran kamin kaun malia kalkan u maribe ongwa main pire pol ta sekine? ");
INSERT INTO gvf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Te main ta iru paimua dire, tameran i inin nomanin iru si pire dikine? ");
INSERT INTO gvf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yal ka kol ere i tere awli pi ka kol pirungwa gul nangwi iwe. I awli ka kol pirungwa yal tenangure, te yal ta i awli simil nen tenangure, te simil nen i kanin sinamua. Kal iru ere na tekenama dire, i kol baan ka wai dire ka di wei so. ");
INSERT INTO gvf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","I pirin paangwa tobe te inanga nanga, tawle ta imo dungwa kirara te wei sinanga, ena kanin paangwa ogu i ere mena unanwa. Na kawen di i teiwa,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Galili ibal kobe kabe si gale God te milungure Pailete simil nen nusi erungure pire, ibalin kobe si gulungwa. Si gulungure kaun i, ibal taw mile ka pore i bolin kule di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Di tongure Yesu iru dungwa, “Pailete Galili ibal kobe si gulungwa, i ibal kobe mile ka iru dinga, ‘Galili ibal kobe kal digan ere taalime erimba, Galili ibal kobe Pailete si gulungwa, ibalin kobe kal digan ere taalime wen eremua.’ Dire i iru nomanin si pirino? ");
INSERT INTO gvf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","I ka iru dinga paikimba, ka ta di terabina piro. I kal digan ere taalime eringa nomanin suna si kiruul sekenana, ena ibalin kobe gulungwa mere i ama iru gulanwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloam gariba gul ogu ki minin mina ongwa si guru dire yaa main sungure, ibal anan kole kole muru kawnan kole muru kole sutakobe bile gulungwa iwe. I ibal kobe mile ka iru dinga, ‘Yerusalem ibal kal digan erimba, ibalin kobe iru gulungwa kal digan wen eremua,’ dire i iru nomanin si pirino? ");
INSERT INTO gvf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","I ka iru dingai paikimba, ka ta di terabina piro. I kal digan ere taalime eringa nomanin suna si kiruul sekenana, ena ibalin kobe gulungwa mere i iru gulanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dire pare Yesu ka di bile dire iru dungwa, “Yal ta komina gul suna eri akola ta kulungwa maamua. Maangure pi milin ule nerala di pire pi kanimba, milin ta kulekemua. ");
INSERT INTO gvf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kulekemia iru di komina gul konagi erungwa yal tongwa, ‘Eri iray milin kulama dire na bolima ogu sutakobe ure waa duu kanebinba, ta kulekungwa ta kanekibinwa. Tameran gariba niriin ne wei siname? Kaya wi ero.’ ");
INSERT INTO gvf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Dimba komina gul konagi erungwa yal iru di tongwa, ‘Singabo, me erin imo dinangure wiikio. Na eri main ali gula dire mole ere kanabinwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Iru erabingire, me erin ta mile milin kulangwa, ena para wai painamua. Painamba milin ta kulekenangwa, ena wi erabinwa.’” ");
INSERT INTO gvf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ena Sare kaun ta Yesu Yuda ka main ogu ala milere, ka nil si ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Abal ta ogu ala alia milungwa, sia den miriin suna milere, nibil pai tongure ale niminin mile warekire, bolima ogu anan kole kole muru kawnan kole muru kole sutakobe, iru nibil ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu abalini kanere, “Ere wo,” dire iru di tongwa, “I nibil eringa kaya wei simiawa.” ");
INSERT INTO gvf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dire aan aa taw si abalini tongure, abalini gin taran ale niminin milere deminin si God tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesu Sare kaun abalini aa te wai ere tomia, ena Yuda ka main ogu kenin erungwa yal nigi de pire Yesu tere alere, iru di ibal kobe tongwa, “Are kaun anan kole muru kole teranta konagi erabinga paimia, ena i aa te wai erala dinanga konagi kaun i wo. Sare kaun kwi ukio.” ");
INSERT INTO gvf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dungure Singaba Yesu maan dire iru dungwa, “Ka dire miriin kaale tongwa yal kobe milingiwe. Sare kaun i bolimakau mo bolima donki kan gule ere nil nenama dire awli engiwe. ");
INSERT INTO gvf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","I iru eringa mere iwe, abalini Ebarakam gawlin milungure Satan nibil ere tongure, bolima ogu anan kole kole muru kawnan kole muru kole sutakobe, kanin sungwa mere milemua. Nibil erungwa Sare kaun aa te wai ere tekenama dire, i ibal kobe iru di pirino?” ");
INSERT INTO gvf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu iru dimia ena kaymin ibal gay gulungure, te Yesu kal wai wen erungwa ibal kobe wai pire gun ye tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ena Yesu iru dungwa, “God kenin ere ke milungwa ‘Takal mere dimua,’ dirabine? Te takal waa dire di bilabine? ");
INSERT INTO gvf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yal ta eri koruul kulungwa mere, di bilabinwa. Yal ta eri koruul milin kulungure, maare yaan bilkaw warungure kauba ure aan yomua.” ");
INSERT INTO gvf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ena Yesu kwi sirin bile tere iru dungwa, “God kenin ere ke milungwa, takal mere di bilabine? ");
INSERT INTO gvf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Komina birete u bil ongwa kal, kaan yis, di bilabinwa. Abal ta yis irere komina palua taw binanbile bole nuure, komina birete para muru u bil omua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ere Yerusalem nala di pire, ogu ai bil te ogu malge baan baan suna pire, ka main nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ongure yal ta mile iru sirin bile tongwa, “Singabo, God ibal aa ki di tenangure, ibal tawliga u wai namo?” Di tongure Yesu maan di tere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kana giran megemaaga dungwa kol i, i yal kobe nala dinanga, konagi nega di ero. Ibal binanbile kol mege dungwa kol i, nala di eramba, ta paikinamua.” ");
INSERT INTO gvf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dire iru dungwa, “Ena ogu kobaan yal ure kana giran kol yaalangure, ena i ibal kobe u mena kol mile si gule dire iru dinanga, ‘Singabo, i kol yawle ere na to.’ Dinangire yalini iru maan di malge ere i tenangwa, ‘I alde milinga ibal ure dine? Na i gumanin ta kanekibingirawa.’ ");
INSERT INTO gvf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dire sirin bile tenangure, i iru dinanga, ‘Na i komina bole nobingire, te i na ogunan ka nil si na ibal kobe tenwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dinanba ogu kobaan kwi iru dinangwa, ‘I alde milinga ibal ure dine? Na i gumanin ta kanekibingirawa. I ibal kobe kal digan ere milina, ere baan ta po.’ ");
INSERT INTO gvf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ebarakam te Aisaka te Yakobo te God ka kebe yal kobe bole, God kenin ere ke milungwa ai suna milamba, i anu si mena kol erangure milere kanana, ena i ibal kobi kay mun bile yaare miirere sigin gibi nuunamua. ");
INSERT INTO gvf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ibal kobe kobil kuman te geril bomai milere, God kenin ere ke milungwa suna u nenama dire milamua. ");
INSERT INTO gvf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kaun i ibal taw mun kol milungwa kwi u guman kol milamua, te ibal taw guman kol milungwa kwi u mun kol milamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ena kaun iray Parasi kobe taw Yesu milungwa gul urere ka iru di tongwa, “Kerodi, ‘I si gulalwa,’ dungwa pirebina, ena i abila pisere kaya ere baan ta po.” ");
INSERT INTO gvf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dungure Yesu iru di yalin kobe tongwa, “Yalini awi biin ele milungwa mere, iru mile ibal kobe bawle tomia, ena i iru di tenana po, ‘Kemina te erima sia maa si mena erere, te nibil erungwa aa te wai ere terabinba, taale na konagi ere wei siralwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iru do dibinba, kemina ere pire, erima taale para pire, Yerusalem kaya uralwa. God ka kebe yal Yerusalem miina kol si gulangwa kuunin ta paikinamia, malia na baan i nalwa.” ");
INSERT INTO gvf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Dire ka ta ainere iru dungwa, “Ayo, Yerusalem ibal we, Yerusalem ibal we, God ka kebe yal si gulere, te ka main ibal nusi ere i tongwa para kobile milin aa tere si gulinwa. Abal korale kain kel bile gawlin i ala erungwa mere, na Yerusalem ibal kobe para iru di u ku bilere irabinba, i girin dire manaa dinwa. ");
INSERT INTO gvf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dina ena u sutaw nangure, ogin po dinamua. Malia i ibal kobe na kaninba, eme kwi ta na kanekinanwa. Kanekinanba i ibal kobe mile, ‘God ka dungwa kebe ere yuungwa, God miriin pai yal i tenamua,’ dinanga kaun i, na kwi kananwa. Ka iru di i teya ere gule piro,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ena Sare kaun ta Yesu komina nenangwa, pi Parasi yal singaba ogu ongwa. Pi milungure ibal kobe Yesu nai kane milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yal ta aan kawn yaungwa, u Yesu milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","U milungure Yesu ka iru sirin bile Yuda kile kaman ka nil si tongwa yal kobe te Parasi kobe tongwa, “Sare kaun nibil erungwa aa te wai erangwa, na ibal kobe kile kaman ka, ‘Para wai paimua,’ dim mo dikime?” ");
INSERT INTO gvf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dimba yalin kobe pire unin si milungwa. Milungure Yesu nibil erungwa yal aa te wai ere tere, “Ena ere po,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Di tere iru di ibalin kobe tongwa, “I ibal kobe milinga gul yal ta bolima donki, mo yalini bolimakau maul ali sagu dinangwa, i ibal kobe Sare kaun gin taran i mena eran mo erekinane?” ");
INSERT INTO gvf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dimba yalin kobe ka maan dinamba, pire unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ibal kobe u komina nerala dire ure bol guman kol kanere amin di milungure, Yesu kanere ka di bile dire iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Yal ta abal ingwa, ‘I komina bil nenana wo,’ di i tenangure, nanga i, i pi singaba bol amin di milekio. Milangire yal singaba bil ta unangwiwe. ");
INSERT INTO gvf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","‘Ere wo,’ di i yalsu tongwa yal urere i iru di tenangwa, ‘Yal ta ungwa i, i milinga ai i milamia, i ale ai si tere baan ta po.’ Ka iru dinangure i gay gulere mun kol milanwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kal iru eramba, yal ta ‘Ere wo,’ di i tenangure, i nanga i pi muna kol amin di milo. Milanga ena ‘Ere wo,’ di i tongwa yal urere iru di i tenangwa, ‘Ye nego, i ibal milungwa guman kola milana wo.’ Iru dinangure ena ibal para milungwa gul i, i kaanin u mine namua. ");
INSERT INTO gvf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ibal para mile na yal singaba mile goma yerabina di pirangwa, u main nangwa paimba, yal ta mile na yal digan mile u main nala di pirangwa, ena singaba mile goma yenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ena Yesu iru di komina ki tongwa yal tongwa, “I komina bil ki terala dinanga, ena i ye nenga ibal te i kebinin abinin kobe, te i enin kobe, te i enin taw kobe singaba milungwa, ibalin kobe iru ‘I wo,’ di tekio. I ibalin kobi ‘Wo,’ dinana, ena ibalin kobi kwi komina maan ki i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","I komina bil kiinanga, ena kal aa te nekungwa ibal kobe, te aan kawn kwima erungwa ibal kobe, te aan kawn ki sungwa ibal kobe, te omilin gi dungwa ibal kobe, ibalin kobe iru, ‘Nenana wo,’ di to. ");
INSERT INTO gvf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ibalin kobe maan ki i tekenamia, ena God miriin pai i tenamua. Kabin sire wai wen milungwa ibal kaya gulungure, ena ibalin kobe alangwa kaun God aibe tobe i tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yal ta ibal kobe bole para komina nerere, Yesu ka dungwa i pirere iru di Yesu tongwa, “Ibal kobe God kenin ere ke milungwa ai komina ne milangwa, wai wen piramua.” ");
INSERT INTO gvf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dungure Yesu ka pore iru di yalini tongwa, “Goma yal ta komina bil ki nerala di eremua. Erere ibal binanbile para ‘Ere suna wo,’ di gala dimua. ");
INSERT INTO gvf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Komina nenangwa kaun u bawa dungure, nilerari yal nusi ere ‘Iru do,’ dungwa, ‘Ibal na goma ka di tobinga mere kal para aa tekun erungwa wo, di to.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Di tomba ibal para wen teran teran ere pikinama dire di tomua. Yal ta goma dire iru di nilerari yal tongwa, ‘Na komina gul kaya gibilin siga, pi kanalwa. Iru eralga ena para ere po, di na to.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Te yal ta iru dungwa, ‘Na bolimakau anan kole kole muru gibilin sire konagi wai eram mo, erekinam mo, pi kanalwa. Iru eralga ena para ere po, di na to.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Te yal ta iru dungwa, ‘Na nabinba maliagira abal ta ibinwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ena iru dungure nilerari yal kwi sinaa dire ere ain pire, yal singaba di tomua. Di tongure ogu kobaan nigi de wen pirere, ka iru di nilerari yal tongwa, ‘I mugu di pi ogu ai pire kol bil te mege para pire, yal digan awli irere, aan kawn kwima erungwa ibal kobe awli irere, omilin gi dungwa ibal kobe awli irere, aan kawn ki sungwa ibal kobe awli irere, iru para kire di yuu wo.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Dungure erere nilerari yal iru dungwa, ‘Yal Singabo, i ka dinga mere wiina ere warebinba, ai taw imo dimua.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dungure ena yal singaba ka iru di nilerari yal tongwa, ‘I komina gul pire kol bil te mege para, yal abal gure pala di ala wo. Na ogu di dinangwa iru ero. ");
INSERT INTO gvf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na i di terala ere gule piro. Ibal kobe goma di tobinga ibalin kobe na komina bil ta nekenamua.’” ");
INSERT INTO gvf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ena ibal binanwenbile Yesu bole ongure, Yesu kiruul sire iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ibal kobe na miliga gul ure na gawlimanan milala di pirangwa, ena ibal iwe. Ibalin kobe mile nenin manin te ebinin te wanin abilin te kebinin abinin te ibalin kobi inin pire, gibilin mui kol yekenangwa, ena na gawlimanan kobe ta milekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na giil pire gulabinga mere, ibal kobe giil iru pirala pirekire na duulin bilekenangwa, ena na gawlimanan milangwa ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","I ibal kobe milinga suna yal ta ogu bil kiirala di piranga, ena eri i yongwa kuunin biinam mo, biikinam mo kanamua. ");
INSERT INTO gvf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eri kuunin biikinamia, ena ogu ki wei sekenamua. Ki wei sekenangwa, ena ibal kanere ebi mi yalini tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tere iru dinangwa, ‘Yal ta i ogu ki pairala di kiimba, ki wei sikimua.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ena gariba bilin ta, yal bil ta pi yal bil ta bole kura bilala di pirere, ena yalini simil nen binanbile, tausen anan kole kole muru i suna erangwa milamba, yal bil ta simil nen binanwenbile, tausen anan kole kole muru kawnan kole kole muru i suna erangwa iwe. Yal bil simil nen tawle i suna erungwa, goma iru nomanin si pirangwa, ‘Yal bil ta sirabinga na ibal niminin milabin mo milekerabine?’ ");
INSERT INTO gvf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Niminin milekerala di pirangwa iwe. Yal bil ta tayan milungure, yalini yal kobe taw ka kebe yere iru di tenangwa, ‘I pi yal bil ta ka wai di tere, na ibal kobe imo milabina dire kol paangwa di gwi so.’ ");
INSERT INTO gvf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iru paimia ena i ibal kobe kal para aa te nenga mun kal waa tekenanga, ena na gawlimanan kobe ta milekenanwa. Mun kal waa tenanga, ena na gawlimanan milanwa. ");
INSERT INTO gvf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Pirin komina wai dimba, daan kiikinangwa kwi u wai ta pekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pirin iru dimia, ena pusi komina gul mo mole erebinga ain erabinba, ta paikinamua. Pusi daan erabinga painamua. Ibal kiraan gi dikimia ere gule piro,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kobile moni takis ingwa yal kobe, te yal digan kobe para, ibal binanbile Yesu ka dungwa pirala dire Yesu milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parasi kobe te Yuda ka main nil si tongwa yal kobe para, kura ka dire iru dungwa, “Yal digan kobe Yesu ye nongwa milungure, te yalini yalin kobi bole komina nomua.” ");
INSERT INTO gvf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dungure Yesu ka di bile dire iru di yalini kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yal ta i suna milungwa bolima siipe siipe, yal anan kole muru aan kawn muru, wan kandret, kobaan milangwa, ena ta wou bilangure, kobaan yal i takal erame? Bolima siipe siipe nainti nain wai milungwa kane pisere, ta u baan ta ongwa waa duu milangwa milangwa kanamua. ");
INSERT INTO gvf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kanangwa aan tawan mina si paru di yere, wai wen pirere awli unamua. ");
INSERT INTO gvf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yalini bolima siipe siipe awli malge pirere, ye nongwa ibal kobe te enin kobe, ‘Ere wo,’ di gala dire iru di tenangwa, ‘Na bolima siipe siipe ta u baan ta ongwa waa duure kanegire, i na bole maki ye terabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iru erungwa mere ka ta di terala piro. Ibal binanbile, nainti nain wai mile nomanin suna si kiruul sekungwa, kamin ibal maki ye tenamba, kal digan ere taalime erungwa yal taranta, nomanin suna si kiruul sinangwa, kamin ibal maki wen ye tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mo te abal ta kobile moni anan kole kole muru yongwa ta yaanangure, abalini takal erame? Abalini kewa galere, ogu ala bomine kire di mena ere irala di pire, dobil wen waa duunamua. ");
INSERT INTO gvf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kanangwa ye nongwa ibal kobe te enin kobe, ‘Ere wo,’ di gala dire iru di tenangwa, ‘Na kobile moni ta yaangwa waa duure kanegire, i na bole maki ye terabinwa.’ Iru erungwa mere ka ta di i terala piro. ");
INSERT INTO gvf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kal digan ere taalime erungwa yal taranta, nomanin suna si kiruul sinangwa, God angel kobe maki ye tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ka ta ainere iru dungwa, “Yal ta mile wan sutan kule yomua. ");
INSERT INTO gvf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wan emin ure ka iru di nen tongwa, ‘Abe, i kobile te kulgal bona aa te nenga obin sire kalkan na iralga mere, malia i na tenanba.’ Iru dimia ena nen obin si wan sutan tomua. ");
INSERT INTO gvf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Are kaun taw wei sungure, wan emin i kalkan tongwa irere, te kobile moni irere, ogin pisere ere gariba ta tayan pi paire, kalkan pile wele ere i sutaw ere ne wei simua. ");
INSERT INTO gvf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kalkan para ne piserungure pare, kenan bil gulungwa kaun gariba iray u maribe ongure, yalini imore wen milemua. ");
INSERT INTO gvf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Milemia ena yalini pi gariba i nen ta konagi ere ta milemua. Bolima kenin ere milama dire nusi mena eremua. ");
INSERT INTO gvf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yalini kenan gulungwa bolima komina nerala di pirimba, ibal kobe komina iray yalini tekemua. ");
INSERT INTO gvf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ena yalini nomanin si kiruul sire iru nomanin si pirungwa, ‘Na abe nil konagi yal komina binanbile dungwa ne milimba, na iwe, kenan gulere gulabinga paamiawa. ");
INSERT INTO gvf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na alere pi na abe milungwa gul pire iru di yalini terabinga, Abe, i te God bole kal digan ere taalime ere i yasu teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na wanan milemua, dire malia iru dinanga ta paikinamia, ena i nil konagi yal milala di piriwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iru nomanin si pirere alere, nen milungwa gul nala di omua. “Omba taw tayan milungwa nen kanere, miriin wen pire tere mugu di pire wan kaale tawa dire kay miimua. ");
INSERT INTO gvf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Miingure wan iru dungwa, ‘Na abe, i te God bole kal digan ere taalime ere i yasu teiwa. I mile na wanan milemua, dinanga ta paikinamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dimba yalini nen iru di nil konagi yal kobe tongwa, ‘Na koray wai wen dungwa wei di pi yuure yalini pire tenanwa. Na inan siine bamin ire egin gale to. ");
INSERT INTO gvf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iru ere pisere ena bolimakau gawlin milin wai wen ongwa iray, si kiinana po. Si kiinangire komina bil nere miinin maarabinwa. ");
INSERT INTO gvf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Na wanan iray kaya gulema di pirebinba, malia u milemua. Te yalini u baan ta ongwa kanekibinba, malia kanebinwa.’ Dire pare komina bil kawn kule ki nere miinin maamua. ");
INSERT INTO gvf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ibal kobe iru ere milungwa kaun, wan kominin komina gul ware milemua. Milere kwi ere malge urere, ogin maala pire tawa sire egin ere dungwa piremua. ");
INSERT INTO gvf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pirere nil konagi yal ta ‘Wo,’ dire ungure, ka iru sirin bile tongwa, ‘Kal ere dungwa i, takal ereme?’ ");
INSERT INTO gvf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dire nil konagi yal ka iru dungwa, ‘I kebininbi ure ta gulekimia, ena i nenin bolimakau gawlin milin wai wen ongure, iray si kiimua.’ ");
INSERT INTO gvf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dungure wan kominin den gule milere, pi ogu ala ta pekemua. Pekemia ena nen ere mena ure yalini ala nama dire kawan dire di tomua. ");
INSERT INTO gvf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Di tomba yalini ka iru di nen tongwa, ‘I iru dinba i piro. Me erin binanbile i nil konagi ere i tere, te i kile kaman ka di na tenga wiina ere teiwa. Tegire na ye nega bole komina bil nerabinga, i bolima meme gawlin iru si ki na tekingiwe. ");
INSERT INTO gvf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na tekinba wanin ta iray i kalkan tenga i pire, abal eri arin sungwa bile ire, kalkan para i sutaw eremua. Erungure pare i bolimakau gawlin milin wai wen ongwa iray si ki yalini tenwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dungure nen iru di tongwa, ‘Wanane, i na bole milingal milinga, ena na kalkan para aa te nega i, i kalkan dimua. ");
INSERT INTO gvf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dimba i kebininbi kaya gulema di pirebinba, malia u milere, te u baan ta ongwa kanekibinba, maliaga kanebinwa. Kanebinga ena komina bil ki nere para wai pirebinga, para paamua.’” ");
INSERT INTO gvf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ena Yesu ka iru di gawlima kobe tongwa, “Yal singaba ta milungure, kalkan yongwa kenin ere ke milungwa yal ta milemua. Milungure ibal taw ure, ‘Yalini i kobile moni i sutaw eremua,’ dire ka di singaba tomua. ");
INSERT INTO gvf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Di tongure yal singaba kenin erungwa yal i ‘Ere wo,’ dire ungure ka iru di tongwa, ‘Tameran i kal iru eringire u na di na tome? I na kalkan yobinga kenin ere ke milinga iray, na piriga i wei sinana di piria, ena i kalkan irere terere kenin eringa main paipa minin ganin bile aa tekun ero.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dungure yalini iru nomanin si pirungwa, ‘Na yal singaba na se erangwa takal erale? Na komina gul konagi erabinba, na yobilagi suna niminin milekemiyawa. Te komina kaan dirabinba, gay gulalga paamua. ");
INSERT INTO gvf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yal singaba na se erangure, ibal kobe aa te wai ere na tenama dire, kal ta erabinga nomanin si pirebinwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pirere ena yal singaba pirin pai dungwa ibal kobe inin taran taran ‘Wo,’ di gala dungure, inin inin umua. Yal ta goma ungure, yalini iru sirin bile tongwa, ‘Yal singaba kal i tongwa pirin tamintan pai imo dime?’ ");
INSERT INTO gvf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dungure yal ta i iru dungwa, ‘Eri niriin wai paangwa mugu yal anan kole muru, aan kawn muru, yalin kobe terabinga imo dimua.’ Dungure kenin ere ke milungwa yal mile ka iru di tongwa, ‘Pirin paangwa piapa dungwa i, ena mugu yal sui aan kawn muru na anan kole kole muru, iru tawle maan tenanga bilo.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Di piserungure yal ta ungure, iru di tongwa, ‘Ena i we, yal singaba kal i tongwa pirin tamintan pai imo dime?’ Dungure yal ta i iru dungwa, ‘Komina palua gal bege bilkaw, yal anan kole muru, aan kawn muru terabinga imo dimua.’ Dungure kenin ere ke milungwa yal mile ka iru di yal ta i tongwa, ‘Pirin paangwa piapa dungwa i, ena gal bege bilkaw yal sui sui, aan kawn muru iru tawle maan tenanga bilo.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kenin ere ke milungwa yal kal digan ere bawle terala di pirimba, yal singaba pirere, ‘Yalini nomanin paangwa mere eremua,’ dimua. Dire iru dungwa, ‘Gariba kal pirungwa maa kora kulungwa ibal kobe, gariba gul konagi nomanin paangwa erimba, ka main pirungwa maa yebe ongwa ibal kobe, gariba gul kalkan nomanin paikire konagi ere milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dire Yesu ka ta ainere iru dungwa, “Ka ta di i terala piro. I ye nenga ibal kobe milama dire i kobile moni kire di yenga, obin si ibalin kobe to. Te piseranga ena kamin ai mile painangal painanga aa tekun ere i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kalkan tawliga kenin wai erungwa paimia, ena kalkan binanbile kenin wai erangwa painamua. Te kalkan tawliga kenin erimba, kakiibi dire bawle tomia, ena kalkan binanbile kenin ta erekire, kakiibi dire bawle tenangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ena i kobile moni kire di yenga kenin wai erekina, ka main wai paangwa, ‘Kenin ero,’ di terabinba? ");
INSERT INTO gvf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te yal ta kalin dungwa i kenin wai erekina, i inin kalkan aa te nenanga ibena i tename? Ta i tekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nil erari yal ta konagi ere yal singaba sutan ta tekenamua. Tenamba nigi de pire yal singaba ta tere, te wai pire yal singaba ta tenamua. Te bole pena gale yal singaba ta tere, te kane gogo ere yal singaba ta tenamua. God te bona gana kal sui nomanin tegi dinangwa, ta paikimua,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ka dungwa i Parasi kobe pirere, kobile moni aa te nongwa wai piremia, ena ebi mi Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tongure Yesu ka iru di yalin kobe tongwa, “Ibal kobe milungwa gul na nomanin wai paangwa milebina di pire konagi iru erinba, God i nomanin te den miriin suna kane pol simua. Ibal kobe mile, kal ta wai wen dima di pirimba, God kane, ‘Kal imore dimua,’ dimiawa. ");
INSERT INTO gvf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mose kile kaman ka te ka kebe yal para minin ganin bilungwa pai dimua. Pai di ongwa ongwa, ena nil bile tongwa yal Yon ungwa iwe. Ungure pare God kenin ere ke milungwa ka main gariba kole kole ware omua. Ongure ibal main i pirala dire, konagi nega di eremua. ");
INSERT INTO gvf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dibinba kamin te gariba wei sinangwa konagi megemaa painamba, Mose kile kaman ka minin ganin taranta wei sinangwa, konagi bil painamua. Painamia imo di painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Yal ta ebinbi de erere abal ta inamia, abal i kunibe ingwa mere inamua. Te yal ta abal de erangure, yal ta abal i inamia, ena yalini abal i kunibe ingwa mere inamua.” ");
INSERT INTO gvf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu ka ta ainere iru dungwa, “Goma bona gana aa te nongwa yal ta milere, galsuna wai dungwa morin sigi direre, te kaun kaun komina wai morin nomua. ");
INSERT INTO gvf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ena yal digan ta kaan Alasaras para milere nimbona binanbile erungure, ibal taw yalini awli ungure, bona gana aa te nongwa yal kana giran pai milere, yalini iru pirungwa, ");
INSERT INTO gvf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","‘Bona gana aa te nongwa yal komina nenangwa sire manin taw yaa bol main ale sinangure, nere kubin maanamua.’ Dungure te awi ure yalini nimbona erungwa, pene ere nongirawa. ");
INSERT INTO gvf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yal digan iray gulungure, angel kobe awli pi Ebarakam milungwa gul ongwa, yal sui bole pena galemua. Bona gana aa te nongwa yal gulungure, maul si yomua. ");
INSERT INTO gvf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Enderin de paangwa ai milere giil bil pirere, kane yebe erere Ebarakam te Alasaras bole para tayan milungwa kanere ");
INSERT INTO gvf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","iru gala dungwa, ‘Abe Ebarakam, miriin pire na to. Enderin ai mile giil bilkaw piriga, ena i Alasaras nusi erangure, yalini aan milin taran nil si bawre kule tenangure, na girabilanan mina aa tenangure gwi kiinamua. I iru ere na to.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dimba Ebarakam mile iru dungwa, ‘Na wanane, ka ta dirala i nomanin si piro. I gariba gul milinga kaun kal para wai dungwa aa te nengire, te Alasaras kal digan aa te nomua. Dimba malia yalini main abila wai pire milungure, i gain giil bil pire milinwa. ");
INSERT INTO gvf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iru paamba kal ta ama iru paamia piro. I te na milebinga gul suna, gariba daan bilkaw wen ta dungwa kola mile pi kolibe namba, kuunin erekinamua. Te i milinga koli para ere abila ta ukinamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dungure bona gana aa te nongwa yal mile ka iru dungwa, ‘Na abe i ka iru dinga paimia, ena na kawan di i terala piro. I Alasaras nusi na abe ogu ero. ");
INSERT INTO gvf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na kebinanbi anan kole muru gain giil pirungwa ai, abila ta ukinama dire, i yalini nusi erangire, bigan ka di yalin kobe tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dungure Ebarakam iru dungwa, ‘Mose te ka kebe yal, i kebininbi bigan ka di tenangwa kebininbi piramua.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dungure bona gana aa te nongwa yal maan iru dungwa, ‘Abe Ebarakam, yalin kobe ka di tenamba, kuunin erekinamua. Dimba yal ta gulungwa yongwa gul alere yalin kobi milungwa gul pi di tenangure, kal digan ere taalime erungwa pisere nomanin suna si kiruul si piramua.’ ");
INSERT INTO gvf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dimba Ebarakam iru dungwa, ‘Mose te ka kebe yal kobe ka dungwa, ibal kobe ta pirekungwa mere, yal ta gulungwa yongwa gul alangwa, para iru ta pirekenamua.’” ");
INSERT INTO gvf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ena Yesu ka iru di gawlima kobe tongwa, “Ibal kobe kal digan ere taalime ere milama dire kalkan u maribe namba, kela kule tongwa yal iwe, ayo, yalini gain giil piramua. ");
INSERT INTO gvf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ka main ibal imore milungure, yal ta ure kakiibi di kela kule tenangure, ibalin kobi kal digan ere taalime erangwa, ena kela kule tongwa yal i kobile naan mina kan sire pusi pirin nil erangwa paimua. ");
INSERT INTO gvf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","I ibal kobe kanekun ere milo. “I enin kobe kal digan ere taalime erangwa, i yalini manaa di tere yalini kan to. Tenanga nomanin suna si kiruul si piramia, ena pirin i, gule ere to. ");
INSERT INTO gvf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Are kaun ta ginin anan kole muru kole sutan kal digan ere i tere pare, te i milinga ure, ‘Miriin pirie, nomanan suna si kiruul siwa,’ dinangwa ena i yalini pirin gule ere to,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nusi erungwa ongwa yalin kobe, Aposel ka iru di Singaba Yesu tongwa, “Pire gi dibinga niminin mile pi nima nama dire, aa ki di na yal kobe to.” ");
INSERT INTO gvf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dungure Singaba Yesu maan dire iru di tongwa, “Eri koruul milin dungwa mere iru pire gi dinanga, ena eri bil ta, ‘I komin dulaanin main si paine pi pirin nil suna ali yaa so,’ dinanga, giranin wiina ere i tere para pi yaa sinamua. ");
INSERT INTO gvf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“I ibal kobe milinga suna yal ta milangure, yalini nil konagi yal ta komina gul konagi eram mo, bolima kenin ere milam mo, konagi iru ere pisere ere malge unangure i mile, ‘I komina kaya wei di nenana po,’ di nu sinano? ");
INSERT INTO gvf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kawen ta dikire i iru di tenanga, ‘Na komina aa tekun ere komina pele sire yeya. Na komina goma ne wei sirabingire, eme i komina nenanwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nil konagi yal kobaan ka dungwa mere wiina ere tongwa maki ye tenamo? Ta di tekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iru erangwa mere i ibal kobe para iru ere milanwa. Kile kaman ka di i tongwa para wiina ere tenanga, ena iru do. ‘Konagi ero, dungwa mere iru tawle erebinga ena nil konagi ibal imore milebinwa.’” ");
INSERT INTO gvf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ena Yesu Yerusalem nala di pire, Sameria gariba gul te Galili gariba gul baan suna i ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Malge ta ala nala di ongure, seki egilungwa yal anan kole kole muru kombil baan guman yongwa. Yomba taw tayan milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Milere gala bil dire iru dungwa, “Yesu Singabo, i miriin pire na ibal kobe to.” ");
INSERT INTO gvf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dungure Yesu kanere iru di yalin kobe tongwa, “Yuda ka main kenin erungwa yal kobe i gain wiige sungwa kanamia, i maribe erana po. I maribe eranga, ‘Malge ki payo,’ di i tenamua.” Dungure ere ongure gain wiige sire u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yal ta gain wiige sire u wai ongwa kanere, sinaa di urere deminin si God tere, ka bil di kole kole erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dire Yesu milungwa gul kawn mina yaa gobin bile mile maki ye tongwa. Ena yal i Sameria nen milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Milungure ena Yesu iru dungwa, “Gain wiige sire u wai ongwa ibal kobe anan kole kole muru milimba, anan kole muru kole sui sui u alde ome? ");
INSERT INTO gvf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Baan ta ki paangwa yal yalini taran tawle u deminin si God tomba, ibal taw kobe u alde ome?” ");
INSERT INTO gvf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dire iru di yal ta i tongwa, “Alo, i pire gi dinga u wai enga paamia, ena i ere po.” ");
INSERT INTO gvf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ena Parasi kobe taw urere, “God kenin ere ke milangwa kaun genawna u maribe name?” sirin bile Yesu tongure, yalini maan dire iru di tongwa, “God kenin ere ke milangwa kaun u maribe namba aal kule unamua. ");
INSERT INTO gvf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ibal kobe mile ‘Umia kano,’ ta dikinangure te ibal taw kobe mile, ‘Ungwa iwe,’ ta dekenamua. God kenin ere ke milungwa i nomanin te den miriin suna ali pai dimia, ena ka iru ta dekenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dire yalini iru di gawlima kobe tongwa, “Na U Ibal Obinga Yal kenin ere na ke milalga, are kaun taran tawle na kanala di piranba, ta kanekinanwa. ");
INSERT INTO gvf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ena ibal taw ka iru di i tenangwa, ‘Kola kano,’ mo ‘Koli kano,’ dinamba i pire kane kole kole erekio. ");
INSERT INTO gvf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kamin nege erungwa gin taran kamin kola pi koli ongwa mere, Na U Ibal Obinga Yal uralga kaun iru eramua. ");
INSERT INTO gvf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dimba, goma giil binanbile pirabingire, ibal kobe malia maalungwa nigi de pire na tere na piseramua. ");
INSERT INTO gvf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yal Noa goma milungwa kaun, ibal kobe kalkan erungwa mere, Na U Ibal Obinga Yal uralga kaun, ibal kobe para iru eramua. ");
INSERT INTO gvf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ena kaun iray ibal komina nere nil nere abal irere mili pirere, Noa sipe ala ongure nimin bilkaw sire ibal para si gulemua. ");
INSERT INTO gvf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yal Eloto goma milungwa kaun para iru milamua. Ibal para komina nere, nil nere kalkan tere gibilin sire, komina yaalere, ogu kiirere, konagi iru ere milemua. ");
INSERT INTO gvf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Milungure Eloto Sodon ai pisere ere mena ongure, kamin mina nimin sungwa mere, kobile enderin yaa main sungure, ibal para si gulemua. ");
INSERT INTO gvf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iru erungwa mere Na U Ibal Obinga Yal u maribe nalga kaun, para iru eramua. ");
INSERT INTO gvf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ena taalime u maribe nangwa kaun i yal ta ogu malge milangwa, kal ta irala di erangwa ogu ala ta pekenangure, te yal ta komina gul milangwa, kwi ere ogu ala ta pekenamua. ");
INSERT INTO gvf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Eloto ebinbi kal erungwa mere, main nomanin si piro mo. ");
INSERT INTO gvf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yal ta inin gain pire tere, mile painangwal painangwa konagi nega dire erangwa, u main namua, te yal ta yaa ime si milangwa, yal i mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ena gilaa kaun iray yal sutan bol ta painangure, God yal ta awli nangure, yal ta ul imo pai milamua. ");
INSERT INTO gvf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Abal sutan bole komina kiirala di aa tekun ere milangure, God abal ta awli nangure, abal ta imo milamua. ");
INSERT INTO gvf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yal sutan bole komina gul konagi ere milangure, God yal ta awli nangure, yal ta imo milamua.” ");
INSERT INTO gvf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dungure gawlima kobe ka iru sirin bile tongwa, “Kal kan dinga i, alde u maribe name?” Dungure Yesu ka iru di tongwa, “Kabe ta gule dungwa sibayaa binanbile u mo gere mile mile ere yaa main si i pi nerala dire urala eremua. Erungwa mere na para iru urabinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gawlima kobe nomanin suna sinege erekire ana di God te milama dire, Yesu ka di bile dire iru di yalin kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ena ogu ai ta ka kol pirungwa yal ta milere, God guman kuril de kanekire, te ibal para nomanin pire yalin kobe tekemua. ");
INSERT INTO gvf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ogu ai i abal weray ta milere, yalini milungwa gul morin morin ure kawan dire iru di te milungwa, ‘Na kayminan ibal ka kol erebinga, i ka kol pire aa ki di na to.’ ");
INSERT INTO gvf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Dire morin morin ungure, ka kol pirungwa yal i, manaa baan araway di tomba, yalini iru pirungwa, ‘God guman kuril de kanekire, te ibal para nomanin pire tekebinba, ");
INSERT INTO gvf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","abalini ure taalime ere na tomia, ena ka kol pire aa ki di teralwa. Tekerabinga ena inanin si milangure, buul kunabinwa.’” ");
INSERT INTO gvf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dire Singaba Yesu iru dungwa, “Ka kol pirungwa yal digan, ka dungwa i main piro. ");
INSERT INTO gvf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yalini iru ere milemia, ena God paale suna ere ingwa ibal kobe girungwa taangwa gala dire ana di milangwa, God ka kol pire aa ki di ibalin kobe tenamua. Sinege ere mile aa ki di tenamo? ");
INSERT INTO gvf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ka dirala piro. Yalini gin taran ka kol pire aa ki di tenamua. Di tenamba, Na U Ibal Obinga Yal gariba gul kwi urabinga, pire gi dungwa ibal milamo?” ");
INSERT INTO gvf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ena ibal taw kobe, “Ibal wai milebinwa,” dire, te ibal para nigi de kanungure, Yesu ka di bile dire iru di ibalin kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Yal sutan ana di God terala dire Yuda ka main ogu bil ere ala omua. Yal ta Parasi milungure, te yal ta kobile moni takis ingwa yal milemua. ");
INSERT INTO gvf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parasi inin baan ta milere, ana dire iru dungwa, ‘O God, ibal kobe para kunibe nerere, te ki erere, te abal kunibe irere, te kal main iru erungwa i, na ta erekiwa. Te kobile moni takis ingwa yal milungwi ime, kal ki erungwa mere, na ta erekiga, ena i maki ye teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sare kaun kaun are kaun sutan, morin morin na komina manaa dire mawal ere miliwa. Na kalkan para iga, anan kole kole muru obin si ye paale taminin taranta i teiwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dimba kobile moni takis ingwa yal taw tayan mile, kane yebe erekire mabin a birere, i kwi bile iru dungwa, ‘O God, na kal digan ere taalime eriga yal milia, i miriin pire na to.’ ");
INSERT INTO gvf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu iru eremia, ena ka dirala piro. Kobile moni takis ingwa yal ere ogin ongure, kal digan ere taalime erungwa God kire di erimba, yal ta iwe, kal digan ere taalime erungwa kire di ere tekungure, imore ere omua. Ibal para mile na yal singaba mile goma yerabina di pirangwa, u main nangwa paimba, yal ta mile na yal digan mile u main nala di pirangwa, ena singaba mile goma yenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ena Yesu gamege kaale kal wai ere tenama dire, ibal kobe gamege awli Yesu milungwa gul ongwa. Omba gawlima kobe kanere, kan tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tomba Yesu mile, “Gamege ere wo,” dire gala dire iru dungwa, “Gamege kobi na miliga gul urala di unangwa, i iru koban si tekio. Gaan iru milungwa God kenin ere ke milungwa ai ali painamua. ");
INSERT INTO gvf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ka ta di i terala piro. Gamege mile, ‘I na kenin ere milo,’ di God tongwa mere, i ibal kobe ama iru di tekenanga, ena God kenin ere ke milungwa ai suna ta pekenanwa.” ");
INSERT INTO gvf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ena Yuda ibal yal singaba ta ure iru sirin bile Yesu tongwa, “Nil si tongwa yal waiye, ta konagi wai erabinga, mile pairabingal pairabine?” ");
INSERT INTO gvf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dungure Yesu iru di yalini tongwa, “Na yal wai miliga i tameran iru di na tene? Ibal ta wai ta milekungwi, God inin tawle wai milemua. ");
INSERT INTO gvf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","I Mose kile kaman ka piringi. Abal te gi kunibe ikio, ibal si gulekio, kalkan kunibe nekio, kakiibi digwane waa tekio, nenin manin ai yebe di to.” ");
INSERT INTO gvf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dungure yalini ka iru dungwa, “Malia ka dinga i, kumil mile wiina eriga, te malia yal mile wiina ere miligal miliwa.” ");
INSERT INTO gvf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dungwa i, Yesu pirere ka iru di tongwa, “Kal ta i erekinga, kal i eranga painamua. Pi i bona aa te nenga ibal tere, kobile moni ire aa te nekungwa ibal obin si to. Tenanga kamin gul bona aa te nenanwa. Nere ure na munan kol duulan bilo.” ");
INSERT INTO gvf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dungure pirere bona binanbile aa te nongwa, guman wai kane miriin wen pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Miriin wen pirungwa Yesu kanere ka iru dungwa, “Bona binanbile aa te nongwa ibal, God kenin ere ke milungwa ai suna nangwa, nega wen dinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bolima kamel kay kiibanin kuun yongwa suna ali nangwa, konagi nega dimba, aa te nongwa yal God kenin ere ke milungwa ai suna ali nangwa, konagi nega wen dimua.” ");
INSERT INTO gvf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dungure ibal kobe pirere iru dungwa, “Ibena God aa ki di tenangure, sigare kule u wai name?” ");
INSERT INTO gvf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dungure Yesu ka iru dungwa, “Kal ta ibal kobe ta erekinangwa, God erangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dungure Pita iru dungwa, “Na yal kobe garibanan pisere i duulin bilebingirawa.” ");
INSERT INTO gvf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dungure Yesu iru di yalin kobe tongwa, “Na kawen dirala i piro. God kenin ere ke milungwa ai ibal kobe suna nama di pire, ogin gul te ebininbi te kebin abin kobe, te nen man kobe, te wan abin kobe kalkan kobi iru piserangwa, ");
INSERT INTO gvf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ena ibal malia maalungwa kaun kalkan binanbile ire, te kamin kaun ta u maribe nangwa, mile painangwal painamua.” ");
INSERT INTO gvf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu gawlima kobe anan kole kole muru kawnan milin sutan baan ta awli pire, ka iru di tongwa, “Ena piro, na yal kobe Yerusalem ai pire, Na U Ibal Obinga Yal kal para erabinga, goma ka kebe yal kobe dungwa mere u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Na awli gariba baan ta nen kobe tenangure, yalin kobe ka di sutaw ere na tere, gain ka si na tere, ebil para si na tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yalin kobe bolima gain galan yongwa kuba aa te na sinangure gulalba, kaun sutakobe wei sinangure, na kwi alalga God iru ere na tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ka iru dimba gawlima kobe pirekungure, ka iray main aal kule di maribe erekungwa. Yesu ka dungwa yalin kobe main pirekun erekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Yeriko ai u maala ongure, omilin gi dungwa yal ta kombil binan amin di mile komina kaan di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ibal binanbile u ongwa kiraan pirere, iru sirin bile ibal tongwa, “Takal ere wiria di mileme?” ");
INSERT INTO gvf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ibal kobe, “Nasarete ai nen Yesu ware u omua,” di yalini tongure, ");
INSERT INTO gvf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","gala dire iru dungwa, “Yesu, i yal bil Debiti gawlin milinga, miriin pire na to.” ");
INSERT INTO gvf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ibal taw yalini guman kol milungwa kan tere, “Sime milo,” di tomba, yalini ama gala bil dungwa, “Debiti wan milinga miriin pire na to.” ");
INSERT INTO gvf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dungure Yesu u mile yal ta i Yesu milungwa gul awli unangwa, kiraan di tongwa. U maala ungure Yesu iru sirin bile yalini tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kal ta i ere terabinga, takal nomanin si pirine?” Dungure yalini maan iru di tongwa, “Singabo, omilan pilaa dinama dire, nomanin si piriwa.” ");
INSERT INTO gvf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dungure Yesu dungwa, “Kano, i pire gi dinga mere, u wai enwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yalini gin taran omilin pilaa dungure, Yesu duulin bile pire maki ye God tongwa. Ibal kobe binanbile u ku bilungwa kanere, deminin si ana di God tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ena Yesu Yeriko ai suna pire baan ta nala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ongure aa te nongwa yal ta kaan Sakias milere, kobile takis ingwa yal singaba milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Milere Yesu guman kanala di pirimba, ibal binanbile u ku bile milungure, te yalini yal bansu milemia, ena Yesu ta kanekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kanekire ena yalini mugu di goma pire, Yesu unangwa kol nalin i kane milala dire pi eri akola ta maangwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Maangure Yesu kol i pi bawa dire, kane yebe ere ka iru di Sakias tongwa, “Kemina i na bole pai milabina di piria, i gin taran ere main wo.” ");
INSERT INTO gvf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dungure yalini gin taran yaa main sire, awli ogin pire miinin maare, aa te wai ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iru erungwa ibal kobe kanere, nigi de wen pire Yesu tere iru dungwa, “Kal digan ere taalime erungwa yal ogin, yal iray bole pairala di omua.” ");
INSERT INTO gvf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ena Sakias alere, iru di Singaba Yesu tongwa, “Singabo, ena i piro. Na kalkan aa te nobinga, aa te nekungwa ibal kole obin si teralwa. Kakiibi dire kalkan kunibe nobinga, maan te kora kule teralwa. Taran kunibe nobinga sui sui maan teralwa.” ");
INSERT INTO gvf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dungure Yesu iru di yalini tongwa, “God ibal aa ki dungure, sigare kule u wai ongwa kemina ogu abili iray u maribe omua. Yal i Ebarakam gawlin para milemua. ");
INSERT INTO gvf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ibal kobe God main ta pirekire, wou bilungwa waa duure kanere aa ki di tegire, sigare kule u wai nama dire, Na U Ibal Obinga Yal ere ime wiwa.” ");
INSERT INTO gvf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ena Yesu ka dungwa i, ibal kobe pirungure, ka di bile di ibalin kobe tongwa. Yesu kaya Yerusalem maala ongure, te God kenin ere ke milangwa kaun malia u maribe nama di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Piremia ena Yesu di bile dire ka iru di tongwa, “Yal singaba bil ta gariba ta nala dire, garibanin kenin ere milangwa yal bil, di yalini tenama dungure omua. ");
INSERT INTO gvf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nala di erungwa kaun i, nil konagi yal anan kole kole muru ‘Ere wo,’ di gala dungure ungure, yal ta kina yal ta aan kawn muru tere, yal ta kina para iru muru tere, yalin kobe kina iru iru tomua. Tere ka iru di tongwa, ‘Na baan ta milabinga kaun i kobile moni i tobinga, i kobile guun inana, konagi ero.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dimba yalini enin gawliman kobe nigi de pire yalini tere, yal taw ka kebe yere ‘Iru do,’ di tongwa, ‘Yal i na kenin ere milama di pirekebinwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ena yal singaba bil i garibanin kenin ere milama dire yal bil ka di tongure, kwi ere ain ure kobile moni tongwa, nil konagi yal kobe ka iru di tongwa, ‘Kobile moni konagi eringa, i maan i kora kule inanga na tenana wo.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dungure yal ta ure iru di tongwa, ‘Singabo, i kina yal ta aan kawn muru na tere kobile moni konagi erere, kina yal anan kole kole muru aan kawn muru, maan i teiwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dungure yalini iru dungwa, ‘Kal para erinwa. Nil konagi yal wai mile wiina pai tere milinwa. Kalkan tawliga kenin eringa paimia, ena i ogu ai anan kole kole muru kenin ero di i teralwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yal ta i ongure, nil konagi yal ta ure iru di yalini tongwa, ‘Singabo, i kina yal ta aan kawn muru na tenga, kobile moni konagi erere kina yal anan kole muru aan kawn muru, maan i teiwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Dungure ka iru di yalini tongwa, ‘I ogu ai anan kole muru kenin ero, di i teralwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dungure nil konagi yal ta ure iru dungwa, ‘Singabo, i kina yal ta aan kawn muru na tenga, na kan daa yega imore di paangwa inin i teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pirin pai i tekungwa ibal kalkan i tongure inga, ena i yal naanin paangwa milina di pire, kuril pire i teiwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dungure iru di yalini tongwa, ‘Nil konagi yal nigi dinga milinwa. I ka dinga meri, ka kol ere i terabina piro. Pirin pai na tekungwa ibal kalkan na girin di nobinga, ena na yal naanin paiga, i na kaninwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","I iru kaninga, tameran na kobile moni ben ala erekine? Eranga ena na kobile moni te ben tawlita maa yebe nangwa para biimia dire, malia ubinga i irabinba.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dire iru di ibal maala milungwa tongwa, ‘Yalini kina yal ta aan kawn muru aa tongwa irere, nil konagi yal ta kina yal anan kole kole muru aan kawn muru aa tongwa yal to.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dungure ibal kobe ka iru di yal singaba tongwa, ‘Dinba yalini kina yal anan kole kole muru aan kawn muru aa tongurawa.’ ");
INSERT INTO gvf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Dungure maan dire ka iru di tongwa, ‘Yal ta kalkan binanbile kenin ere milungure, taw ama tenangure irere binanbile aa te nenamua. Te yal ta kalkan tawle kenin erekungwa ta tekenangure, kal tawle dungwa yal ta tawal di inamua. ");
INSERT INTO gvf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ena ibal kobe na kenin ere milama di pirekire, kaymin paale na tongure, ibalin kobi awli ya ure na milebinga gul si gulo,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ena Yesu ka di piserere, Yerusalem nala di pire goma ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pirere ogu ai sutan Betepage te Betani kamin kuul kaan Olibe binan kol dungwa u bawa dungure, gawlima sutan goma nusi ere ");
INSERT INTO gvf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ka iru di tongwa, “I ogu gul kola kaninga po. Pirere ala nala di erangire bolima donki gawlin kumil kwi naan kan kule milungwa kananwa. Ibal aw ta sikungwa milungure, i kan gule ere awliya wo. ");
INSERT INTO gvf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ibal ta mile, ‘Tameran kan gule erine?’ di i tenangwa i ka iru di to, ‘Yal singaba irala di pire konagi ta eramua.’” ");
INSERT INTO gvf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Di tongure yal sutan ere pire, Yesu ka di tongwa mere, u maribe ongwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bolima donki kan gule ere milungure, ena kobaan ure iru di tongwa, “Tameran kan gule erine?” ");
INSERT INTO gvf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dungure yal sutan maan dire ka iru dungwa, “Yal singaba irala di pire konagi ta eramua.” ");
INSERT INTO gvf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dire bolima donki awli pi Yesu milungwa gul pirere, donki mun bolimina inin galsuna kaw tongure, Yesu bolima donki aw sinama dire, aa ki di yebe erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aw si wari ongwa ibal kobe gal kombil bolimina pilaa di yongwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kamin kuul Olibe daan ime pire Yerusalem pi maala ongure, gawlima kobe binanbile u ku bilere Yesu kal guman kwi dungwa eremia, ena deminin si God tere maki ye tere gala dire iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Yal Bil ta, God ka dungwa kebe ere yuungwa God yal i miriin pai tenamua. Kamin gul mina ibal den miriin suna ura dungure, yaa ime si milamua. Te God deminin si tongure, taran milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parasi kobe taw u ku bilungwa suna milere, ka iru di Yesu tongwa, “Nil si tongwa yalo, i gawlimanin kobe ka yuul dungwa kan to.” ");
INSERT INTO gvf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dungure Yesu iru dungwa, “Ibalin kobe giran si muure sime milangwa, ena kobile iray ka dungwa i gala dinamua.” ");
INSERT INTO gvf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Dire pi Yerusalem maala pire kanere, miriin pire tere kay miingwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Miire iru dungwa, “Yerusalem ibal kobe, i denin miriin suna yaa ime sire mone di milala dire kemina main piranba, maliaga ta pirekinwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ena kaun ta eme i kayminin ibal ure i gul si suna ere kol para si pere dire i yobile i suna eramua. ");
INSERT INTO gvf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kayminin ibal ure i ibalin kobe para si wei si pisere, te ibal kobe i yobile i suna erungwa para si gulamua. God ure i aa ki dirala di ungwa kaun iray ta pire pol sikina, ena kobile si suule u inin inin pirere, taminin si taran ta dekenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ena Yesu mile Yuda ka main ogu bil ala pire kalkan yongwa ibal kobe waa kire di malge ere milere, ");
INSERT INTO gvf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iru di tongwa, “God dungwa mere ka main minin ganin iru bilungwa, ‘Na ogu ibal ana dungwa ogu dimua,’ iru dimba, i kalkan yere te gibilin singa, ena kunibe ibal kobile giran ale paangwa mere, na ogu iru paangwa erinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Are kaun kaun Yesu ka main ogu bil ala pire ka main nil si te milimba, Yuda ka main kenin erungwa yal bil kobe, te ka main nil si tongwa yal kobe, te yal singaba kobe, yalin kobe iru Yesu si gulabina dire kol ta waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Waa duumba yalini ka dungwa ibal kobe ere gule pire milemia, ena yalin kobe si gulabina di pirimba, kol ta kanekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ena kaun ta Yesu ka main ogu bil ala milere ibal kobe ka main nil si tere, te God guun kan kere di maribe ere tongwa. Di tongure Yuda ka main kenin erungwa yal bil kobe, te ka nil si tongwa yal kobe, te Yuda ka main singaba kobe urere, ");
INSERT INTO gvf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ka iru sirin bile Yesu tongwa, “I kal main eringa, ibena yobilaan bile i tome? Ibena ‘Ero,’ di i tome?” ");
INSERT INTO gvf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dungure Yesu ka iru di tongwa, “Ena ka ta sirin bile i terala, i maan di kole ere na to. ");
INSERT INTO gvf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yon nil bile tongwa main u maribe ongure, God nusi erim mo ibal nusi erime?” ");
INSERT INTO gvf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dungure yalin kobe ka diria ere iru dungwa, “‘God nusi eremua,’ dirabinga yalini iru dinangwa. ‘Tameran yalini i pire gi di tekine?’ ");
INSERT INTO gvf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Paamba, ‘Ibal nusi eremua,’ dirabinga ibal binanbile Yon God ka kebe yal milema di piremia, ena kobile aa tere na si gulamua.” ");
INSERT INTO gvf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iru dimia ena ka iru di Yesu tongwa, “Nil bile tongwa yal Yon, nusi erungwa ongwa i na yal kobe pire pol sekibinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dungure Yesu ka iru di tongwa, “I iru dinga, ena yal ta ‘Ero,’ di na tongwa, para di maribe ere i tekeralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ena Yesu ka di bile dire iru di ibal kobe tongwa, “Yal ta girepe kan milin yaalere ibal taw, ‘Kenin ero,’ di tere gariba baan ta baan araway milala dire ogin pisere ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Milin bol yongwa kaun gariba kobaan milin taw irala dire, nil konagi yal ta nusi erungure, omua. Omba kenin erungwa yal kobe yalini kuba sire imore nusi erungure, ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Iru erungure, ena nil konagi yal ta ama nusi erungure omba, yalini kuba sire imore nusi erungure yalini gay gule ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yal sutan kaya nusi erere pare ta nusi erungure, kenin erungwa yal kobe yal i binanbile sire, pusi mena kol eremua. ");
INSERT INTO gvf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","I eremia ena komina gul kobaan iru dungwa, ‘Ena kal ta iru erabina. Na wanan taran nusi erabina nangwa, yalin kobe yalini aa te wai ere tenama di piriwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dimba wan ungwa kanere diria ere iru dungwa, ‘Gariba kobaan wan kominin milungwa, nen kulgal bona muru inamua. Na yal kobe yalini si gulabinga, ena gariba te kulgal bona muru inan irabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dire ena wan anu si komina gul miina kol erere si gulemua. “Ena yalin kobe iru eremia, girepe kan gul kobaan takal ere kenin erungwa yal kobi tename? ");
INSERT INTO gvf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yalini urere yalin kobe si gulere, ‘Komina gul kenin ero,’ di yal taw kobe tenamua.” Dire Yesu iru dungure, ibal kobe pirere iru dungwa, “Kal iru u maribe pekenama di pirebinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dungure Yesu ibalin kobe kanere ka iru di tongwa, “I iru dinba, ka main minin ganin kere di i teralga, takal main paame? ‘Ibal ogu kiingwa eri ta piserungwa, ire i pi biriin wen mina yomua.’ ");
INSERT INTO gvf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ena ibal kobe eri iray kawn si wabe sungure gaul sinangwa, ena suna si darual dinangure gulamua. Te eri iray yuu di ime ure ibal kobe si diri dinangwa, ena suna kinin kale gulamua.” ");
INSERT INTO gvf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dungure Yuda ka main ka nil si tongwa yal kobe, te kenin erungwa yal bil kobe bole milere, Yesu ka di bile dungwa di na toma dire, ena Yesu kanin sirala di pirimba, ibal binanbile milungwa kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Piremia ena kaun ta kanin sinangwa suul milungwa. Yesu ka kol ere tere awli pi gariba gul i yal bil terala dire, yalin kobe yal taw kiraan sire kobile moni tere iru di tongwa, “I pi Yesu kela kule bawle tenana dire ka sirin bile tere, Yesu i kawen dima di pirangwa, di miriin kaale to.” ");
INSERT INTO gvf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Di tongure ure iru di Yesu tongwa, “Ka nil si tongwa yalo, i ka dinga, te nil si tenga, kirara kawen dima di pirebinwa. Ibal singaba taran i aa ki di tekire, ibal maangwa te yaangwa i nomanin taran si pirere, te God main paangwa mere, nil si ibal kobe tenga pirebinwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pirebina ena ka sirin bile i teralga, ka maan di kole ere na to. Kobile takis Orom yal bil Sisa terabinga, na yal kobe kile kaman ka main paangwa mere, si keli sirabin mo sekerabine?” ");
INSERT INTO gvf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dimba bawle terabina di pirungwa Yesu pirere ka iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kobile moni milin ta ire yuunangire kanalwa. Kobile moni bolimina ibal milungwa, ibena guman mere kaan paame?” ");
INSERT INTO gvf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dungure, “Sisa milemua,” dimia, ena Yesu ka iru di tongwa, “Ena Sisa kal dinangwa, te inin baan ero, te God kal dinangwa, te inin baan ero.” ");
INSERT INTO gvf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dungure ena ibal kobe milungwa mina yalin kobe bawle terala di pirimba, bawle ta tekire, te maan di tongwa pire buul kunere pire unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ena Sadusi kobe taw Yesu milungwa gul ungwa. Yalin kobe mile, “Ibal gulungwa i kwi ta alekinamua,” dire ka iru nil si te milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yalin kobe ure ka iru sirin bile Yesu tongwa, “Ka nil si tongwa yalo, Mose kile kaman ka iru bile na tongwa, ‘Yal ta abinbi temine mile gulangwa, gaan milama dire abin ebinbi weray kebin inamua,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dire iru dungwa, “Ena kaun ta kebin abin anan kole muru kole sutan milemua. Abin abal ta ire temine mile gulemua. ");
INSERT INTO gvf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Gulungure kebin suna ta abal iray irere gulemua. ");
INSERT INTO gvf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Gulungure kebin suna ta abal iray irere gulungure, kebin imo milungwa abal iray imba, kebin anan kole muru kole sutan temine mile, gule wei simua. ");
INSERT INTO gvf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gulungure pare, abal iray para gulemua. ");
INSERT INTO gvf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kebin abin anan kole muru kole sutan abal iray ingwa, eme ibal gulungwa kwi alangwa ibena ‘Ebinbi miliwa,’ dire milame?” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dungure Yesu ka iru di yalin kobe tongwa, “Ibal malia maalungwa abal irere terere milimba, ");
INSERT INTO gvf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","God mile, ‘Ibal kobe gulere alere kaun ta eme mile painangwal painamua,’ dire, ‘Eringa paimua,’ di ibalin kobe tenangure, ena ibalin kobi abal ta ikinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Angel kobe ta gulekungwa mere, ibalin kobi para iru milamua. Ibalin kobe gulere alamia, ena God wan abilin muru milamua. ");
INSERT INTO gvf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ibal gulere alangwa Mose kaya main paangwa di maribe eremua. Eri ta enderin dere bawl sungwa mere iru minin ganin bilungwa baan suna ali ka ta iru dungwa di maribe eremua. Mose ka di God Singaba tere iru dungwa, ‘Ebarakam te Aisaka te Yakobo, yalin kobe God milinwa,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iru dimia ena ibal gulungwa ibalin kobi God ta milekimba, ibal kwi milungwa ibalin kobi God milemua. God milungwa gul ibal para kwi milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dungure ka main nil si tongwa yal kobe ka iru di Yesu tongwa, “Ka nil si tongwa yalo, ka maan di na tenga i para dino.” ");
INSERT INTO gvf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yesu ka iru di tomia, kwi sirin bile tenamba, kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ena Yesu ka iru di yalin kobe tongwa, “‘God konagi erungwa yal, Kirisito, yalini Debiti wan tawle milemua,’ dire tameran ibal kobe ka iru dime? ");
INSERT INTO gvf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Geril dungwa buku suna Debiti iru bile paalungwa, ‘God Singaba iru di na Singaba tongwa, I u na daanan wen kol amin di milo. ");
INSERT INTO gvf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Milingire i kayminin ibal yaa ime si tegire, i egilana dire iru ere i teralwa.’ ");
INSERT INTO gvf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ena Debiti mile, ‘Na Singaba milinwa,’ di yalini tongwa, ‘Debiti gawlin iru tawle milemua,’ dinga, tameran main iru paangwa pire dine? I ka dinga ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ibal binanbile u ku bile milungwa Yesu ka dungwa pirungure, yalini ka iru di gawlima kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“I yal kobe Yuda ka main nil si tongwa yalin kobe mile pai erungwa main, i nai kane milo. Yalin kobe gal araway sigi di ware, ‘Na singaba miliwa,’ di piremua. Di pirere u ku bilungwa gul ongure, ‘Yal singabo, i ere uno?’ di gala di tongure, miinin maare ka main ogu pirere singaba bol kaana amin di milere, te ibal binanbile u ku bile milungure, yalini duul kaal kule aa te wai ere tongure milemua. ");
INSERT INTO gvf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Milere abal weray kal yongwa bawle tere girin di aa te nerere, ana baan araway dire ibal ere miriin kaale tomua. Goma kal ki ere milungwa giil pire tenamba, malia kal ki taw ama ere milungwa i, giil bil pire tenangwa paamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ena Yesu ka main ogu milere, aa te nongwa yal kobe kobile moni bokisi ali yongwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kanungure abal weray ta urere aa te nekungwa abal milere kobile moni baa sutan ali yongure, Yesu kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kanere ka iru dungwa, “Na ka dirala piro. Yalin kobe kobile moni tomba, aa te nekungwa abal weray, kobile moni te kora kule tomua. ");
INSERT INTO gvf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ibal kobe kobile moni bil aa te nomba, taw aa bire ime ere tawlita tomua. Tomba, abalini kalkan aa te nekere, ta aa te nongwa mere muru tomua.” ");
INSERT INTO gvf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ena ibal taw kobe milere Yuda ka main ogu bil dungwa mere, diria ere iru dungwa, “Kobile bilkaw mama wen dungure, te ibal kobe kalkan ogu iray egin gale tongwa wai wen dimua,” dungwa. Dungure Yesu ka iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kalkan para wen i kaninga, kaun ta u maribe nangure, kobile i si suule u inin inin pirere taminin sire, taran ta dekenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dungure gawlima kobe ka iru sirin bile tongwa, “Ka nil si tongwa yalo, i ka dinga i, genawna u maribe name? Erala di erangwa kaun, takal goma u maribe nangwa kanabine?” ");
INSERT INTO gvf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Dungure Yesu ka iru dungwa, “Ibal ure kela kule dire bawle i terala di erangure, i nai kane milo. Ibal binanbile ure na kaanan gale, ‘Kirisito miliwa,’ dire te na uralga kaun, ‘U bawa dimua,’ dinamba, i yalin kobe duulin bile warekio. ");
INSERT INTO gvf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","‘Kura kamil bilemua,’ dinangwa pirere, te ‘Kura malge bilemua,’ dinangure, i nomanin si gogo ere kuril pirekio. Kalkan main iru pilau dinamba, kamin te gariba wei sinangwa kaun gin taran u bawa dikinamua.” ");
INSERT INTO gvf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dire Yesu ainere iru dungwa, “Gariba baan ta ibal kobe pirere baan ta bole kura bilangure, te kenin ere ke milungwa yal bil te gawlima kobe bole pirere, yal bil ta bole kura bilamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ememe bilkaw pilau dinangure, te kenan bil gulungwa kaun u maribe nangure, te nibil si aine aine erangwa pilau dinangure, te kal main iru gariba baan baan u maribe namua. Main pirama dire kamin mina kalkan u maribe nangwa, ibal kobe kuril bil piramua. ");
INSERT INTO gvf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Kalkan iray ole u maribe pekenangure, ena i kanin sire gain giil pire i tenamua. Ka kol ere i terala dire ka main ogu awli nangure, i kanin pai milanwa. I ibal kobe pire na tenga, ena ibal kobe ka kol ere terala dire awli yal bil te yal singaba milungwa gul namua. ");
INSERT INTO gvf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nangwa kaun i pire gi dinga main, di maribe eranwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ka tawa dire maan di kole erabine? I iru nomanin si gogo erekio. ");
INSERT INTO gvf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","I nomanin paangwa mere, ka dinana ena i kayminin ibal mile, ‘Ka dinga paikimua,’ di i tekenama dire, ka iru di maribe ere i teralwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","I nen man kobe te kebin abin kobe, te enin kobe, te ye nenga kobe ibalin kobi ka kol ere i terala dire awli nangure, i ibal kobe taw si gulamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","I pire gi di na tenga, ibal para den gule i tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","I ibal wen ta baan ta pekenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","I ka main aa gi di milangal milanga, aa ki dire a pilaan pai tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ena ami simil nen binanbile Yerusalem ai yobile suna erangwa kaun u maribe nangure, ena ogu ai i si suule u sutaw namua. ");
INSERT INTO gvf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kamin kaun i, u maribe nangwa ibal kobe Yudia milangwa, si ere dimin gul nala eremua. Te ibal kobe ogu malge milangwa, pisere si erala eremua. Te ibal kobe mena milangwa kwi pi ogin malge ta pekerala eremua. ");
INSERT INTO gvf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iru erangwa ena ibal kobe pirin paingure, God maan sinangwa main paimua. Ka main minin ganin bilungwa mere, kawen u maribe nama dire, main iru u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Abal gaan paangwa te gaan amin ne milungwa iwe, eke, miriin pirie. Ibal para gain giil bil pirangure, te God den gule ibal kirara sinamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Di kuba pera aa tere ibal kobe taw si gulangure, te ibal kobe taw kanin sire awli gariba baan ta nangure, te Yuda milekungwa ibal kobe Yerusalem ai komina wou nenamba, ibalin kobi nenangwa kaun wei sinamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ibal main pirama dire, are te ba te kulmama kamin mina kalkan u maribe nangwa ibal kobe kanamua. Nil sungure teli bilkaw dungwa mere, pirin nil iru nil sinangure, teli bilkaw dinamia, ena ibal para nomanin si gogo ere kuril piramua. ");
INSERT INTO gvf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kamin mina kal kobe niminin milungwa si suule u sutaw namia, ena gariba gul kal ta u maribe nangwa suul milere kuril pire omilin maalamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kal iru erangure pare, Na U Ibal Obinga Yal, God yobilaan bil pai na tenangure, niminin wen mile te naabilungwa bole, kawa bolimina urabinga ibal kobe na kanamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kal main i kawn kule u maribe nangure God i aa ki dinangure sigare kule u wai nanga kaun u maala namia, ena i kane yebe ero.” ");
INSERT INTO gvf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ena Yesu ka di bile dire iru di yalin kobe tongwa, “Eri akola te eri kaan kaan i main piro. ");
INSERT INTO gvf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Eri para minin kwi erungwa kaun i kamin wai erala di erema di kaninwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Piringa mere main iru paamua. Ena kalkan kobe goma u maribe nangwa di tobingire i kananga, God kenin ere ke milungwa kaun u maala wen ungwa paamia di kananwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na kawen dirala i piro. Kamin kaun malia ibal maalungwa ole gulekinangure, kalkan kobi di tobingire u maribe nangure pare, kanere eme gulamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kamin te gariba wei sinamba, na ka dibingai, wei ta sikire di painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“I ibal kobe pirekun ere milo. Komina depil nongure, te nil bia nere omilin maalungure, te gariba kal pirungwa maangure, te kal iru ere milanga, ena kauba eraal sungwa mere, na kwi ere ime uralga kaun i, gin taran u maribe namua. Gariba ulin kole kole para kamin kaun iray, para muru u maribe namua. ");
INSERT INTO gvf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kal main i, u maribe nangwa i yobilaan bile milere, te Na U Ibal Obinga Yal gumanan mina ale milala dire i kanekun ere mile, ana di God te milangal milo.” ");
INSERT INTO gvf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iru dungwa kaun iray, Yesu Yuda ka main ogu bil ka nil si te milere, te kamin girungure, pi Olibe kamin kuul pire pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ibal para kwimile taanima ka main ogu i pirere Yesu ka dungwa pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Komina birete u bil pekungwa nere milungwa kaun, kaan Pasoba, u maala ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ibal kobe binanbile u ku bile milungwa Yuda ka main kenin erungwa yal bil kobe, te nil si tongwa yal kobe bole kuril piremia, ena Yesu aal kule si gulala dire kol waa duure ka diria ere pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ena kaun i gawlima kobe anan kole kole muru kawnan milin sutan, yal ta kaan Yudas Isikerio milungure, ena Satan pi yalini den miriin suna ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Omia ena yalini pi Yuda ka main kenin erungwa yal bil kobe, te Yuda ka main simil nen singaba kobe milungwa gul pirere, Yesu bale taal sirala dire, yalin kobe bole ka diria ere pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pirungure yalin kobe wai pire, ‘Tobe teralwa,’ dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dungure Yudas owa dire, ibal kobe ta pirekenangwa Yesu bale taal sirala dire kaun ta suul mile kane milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Komina birete u bil pekungwa nere milungwa kaun, kamin kaun ta kawn kule erungure, goma God Yuda nen kobe ta sekungwa kaun nomanin si pirere, malia bolima siipe siipe gawlin bil si kiinangwa kaun u bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dimia ena Yesu yal sui Pita te Yon nusi ere ka iru di yalsui tongwa, “God Yuda nen kobe ole sekungwa kaun, nomanin si pire komina nerabina dire, i pi aa tekun erana po.” ");
INSERT INTO gvf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dungure yalin kobe dungwa, “Alde aa tekun erabile?” ");
INSERT INTO gvf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Dungure Yesu ka iru di tongwa, “I iru piro, i ogu ai bil ala nangire pare, yal ta nil mugu kawi ire ure i kol baan guman yenanga, ena yalini pi ogu ala nangure ogu i, i ama po. ");
INSERT INTO gvf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pirere yalini ogu ta ala nangure, ka iru di ogu kobaan to, ‘Ka nil si tongwa yal iru di i tomua. God Yuda nen kobe ta sekungwa kaun kaan Pasoba, na te gawlimanan kobe nomanin si pirere, komina nerabina dire i ogin ala kulan ta alde dime?’ ");
INSERT INTO gvf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I iru dinangire, yalini kulan ta mine bilkaw dungwa aa tekun erungure i maribe eramia, ena i ali iray komina aa tekun ero.” ");
INSERT INTO gvf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dungure gawlima sutan pirere, Yesu ka dungwa mere u maribe ongwa kanere, te komina nenama dire aa tekun erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Komina nenangwa kaun u bawa dungure, Yesu te yalini nusi erungwa ongwa yal kobe, Aposel, para amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Milungure Yesu ka iru di yalin kobe tongwa, “Komina bil iray i bole para nerabina dire kirara kawen piriwa. Nere pare eme giil piralwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na ka dirala i piro, komina bil i kwi ta nekeralba, komina nobinga i main paangwa mere God kenin ere ke milungwa kaun u maribe nangwa, ena kwi ama neralwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dire pare Yesu sin kabe ta ire maki ye God tere iru dungwa, “I ire obin si no. ");
INSERT INTO gvf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na ka dirala i piro, na nil wain ta ama nekeralba, God kenin ere ke milungwa kaun u maribe nangwa kwi neralwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yalini para komina birete ire maki ye God tere, bege dire tere, iru dungwa, “I ibal kobe nenana dire na miin te gaynan dimua. Nenanga kaun na kalkan ere i tega nomanin si pire ere milo.” ");
INSERT INTO gvf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kal iru erungwa mere, komina ne pisere sin kabe irere, ka kwi ainere iru dungwa, “Sin kabe nil iwe, ibal binanbile God bole kwi guman kane ire u taran pi milama dire, na inan mayan garu dalwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ka iru dibinba i piro. Na bale taal sinangwa yal, na bole komina malia ne milebinawa. ");
INSERT INTO gvf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","God ka di paalungwa mere, Na U Ibal Obinga Yal gulalba, na bale taal sinangwa yal iwe, aye, giil bil piramua.” ");
INSERT INTO gvf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dungure yalin kobe ka diria ere iru dungwa, “Na yal kobe milebinga suna, ibena kal iru erame?” ");
INSERT INTO gvf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ena gawlima kobe ka bolebilin dire ka iru dungwa, “Inin milebinga abili, ‘Yal singaba milemua,’ dire ibal kobe ibena kaan galeme?” ");
INSERT INTO gvf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dungure Yesu ka iru di yalin kobe tongwa, “Gariba baan ta kenin erungwa yal bil kobe enin gawliman awli ure nil konagi yongure, te kenin erungwa yal singaba kobe milungure, ‘Kenin wai erungwa yal milemua,’ dire ibal kobe ka iru dimua. ");
INSERT INTO gvf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dimba i milinga suna ali iru ta erekinanwa. I milinga gul i yal ta singaba milungwa, kebin yuin ta milungwa mere iray, iru yalini milamua. Te kenin ere ke milungwa yal wiina ere ibal kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yal sutan milungwa ena yal ta amin di mile komina ne milungure, te yal ta komina kiire pele bala si yuure tomua. Yal sutan milungwa, ibena yal singaba mileme? Yal ta amin di mile komina nongwa yalini yal singaba milemiawa. Milimba, yal wiina ere ibal kobe tongwa mere, na i milinga suna iru miliwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Na giil pire milebinga milebinga, ena i na bole pena galinwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na kenin ere ke milala dire na Abe God yobilaan bile na tongwa mere, na i yobilaan bile teiwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na kenin ere ke milalga ain, i na bole komina nerere, te kenin erungwa yal bil ain pire, Isirel ibal yal gawlin gawlin anan kole kole muru kawnan milin sutan, nil tere ka kol pire tenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimone, ena i iru piro, Satan i suan kanala dire God para owa dimua. ");
INSERT INTO gvf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kal iru eramba, i pire gi dinga pisere erekinana dire, ana di God teiwa. I nomanin kwi si kiruul sire na kwi kulanga, ena i enin taw kobe yobilaan bile to.” ");
INSERT INTO gvf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dungure Pita maan dire ka iru dungwa, “Singabo, i na bole kanin na sinangure gulabinga, ena kal iru erabilga para paimua.” ");
INSERT INTO gvf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Dungure Yesu ka iru di tongwa, “Pita na ka di i terala piro. Kemina gilaa sia korale be dala di erangwa, i ginin sutakobe, ‘Na yalini guman kanekiwa,’ dire ka di kile di mena ere na tenanwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ena Yesu ka iru di gawlima kobe tongwa, “Na goma nusi erebingire, i galbale te gal te kawn tobilin ire pekinga, i kal ta irala din mo dikine?” Dungure, “Kal ta irala dikibinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dungure Yesu ka iru dungwa, “Goma iru paamba, malia yal ta galbale mo gal aa tenangwa ire nangure, te yal ta di kuba pera aa tekenamia, ena yalini pi yal ta galsuna tere kobile ire, di kuba pera gibilin si aa tenana po. ");
INSERT INTO gvf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ka ta dirala ena i piro, ‘Yalini kal ki erungwa yal kobe bole milamua,’ dire ka main minin ganin na kanan dungwa i, milin u maribe namua. Na kanan dungwa minin ganin bilungwa mere u maribe nangure, ena na baan ta nalwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dungure gawlima kobe ka iru dungwa, “Singabo, i kano. Di kuba pera sutan i dungwiwe.” Dungure yalini maan dire ka iru dungwa, “Ena ka para dinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ena Yesu kol i pisere Olibe kamin kul goma morin ongwa mere kwi ongure, te gawlima kobe bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ai iray u bawa dire Yesu ka iru di gawlima kobe tongwa, “Satan i kiranin sire kela kule tenangure, i manaa dinana dire i ana di God te milo.” ");
INSERT INTO gvf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dire kobile baan tawle pu sungwa mere iru pire, yaa kawn gobin bile mile ana dire iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Abe, na giil malia piralga pirekerala di pire iru ere na tenanba, painama di pirangire, ena giil piralwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dungure kamin ibe angel ta ure yobilaan bile yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nomanin suna kirara ku ku maamia, ena ana dire dire milungwa. Mayan ole si yaa sungwa mere, yalini pire payan bilungwa, iru yaa main sungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ana di pisere alere gawlima milungwa gul pire, yalin kobe ul pai milungwa kanungwa. Yalin kobe miriin wen pire milemia, ena ul pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Milungure Yesu yalin kobe ulin yuure, ka iru di yalin kobe tongwa, “Tameran ul pai miline? Satan i kiranin sire kela kule tenangure, i manaa dirala dire i ale ana di God te milo.” ");
INSERT INTO gvf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ena Yesu ka iru di milungwa ibal binanbile u bawa dungure, ena gawlima kobe anan kole kole muru kawnan milin sutan, yal ta Yudas, ibalin kobe awli ure Yesu milungwa gul ure, giran si nerala di umba, ");
INSERT INTO gvf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu ka iru di yalini tongwa, “Yudas, Na U Ibal Obinga Yal giranan si nenanga, bale taal si na tenano?” ");
INSERT INTO gvf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gawlima kobe Yesu bole milungwa kal ta erangwa kanere, ka iru di yalini tongwa, “Singabo, di kuba pera aa tere yalin kobe sirabino?” ");
INSERT INTO gvf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dire yal ta di kuba pera i maribe ere Yuda kenin erungwa yal bil, yalini nil konagi yal ta, kiraan dual kule erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Erimba Yesu ka iru dungwa, “Eringai pisero.” Dire yal ta i kiraan aa te ain ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ena Yuda ka main kenin erungwa yal bil kobe, te Yuda ka main simil nen singaba kobe, te Yuda ka main singaba kobe, yalin kobe Yesu kanin sirala dire ungure, ena Yesu ka iru di yalin kobi tongwa, “I di kuba pera te kuba ire unga, komina kunibe nongwa yal milungwa mere, iru kuunin na milama di pire uno? ");
INSERT INTO gvf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yuda ka main ogu bil kaun kaun bole milebilba, i na kanin ta sikinwa. Dimba malia i ibal kobe kal eranga kaun dimua, te sibilungwa yal, Satan kal erangwa kaun para dimua.” ");
INSERT INTO gvf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ena yalin kobe Yesu kanin sire awli pi Yuda ka main kenin erungwa yal bil ogin ongure, te Pita tawlita tayan mile muun kol duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ogu malge ibal kobe enderin gale paalungure, Pita pirere bole para amin dire enderin pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Milungure nil konagi gi ta kanere tena yuulin bile kane ka iru dungwa, “Yal i Yesu bole para milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dimba Pita ka di kile di mena ere ka iru dungwa, “Abalkuno, na yalini guman ta kanekiwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dungure kaun tawliga wei sungure, yal ta kwi ure Pita guman kanere ka iru di tongwa, “I Yesu enin taw kobe milinwa.” Dimba Pita maan dire ka iru dungwa, “Yalkuna, na iru ta milekiwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dungure kaun taw, wan awa wei sungure, yal ta yobilaan bile ka iru dungwa, “Yal i Galili nen milemia, ena yalini Yesu bole para milemiawa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dimba Pita maan dire ka iru dungwa, “Yalkuna, yalini i kane dinga na guman ta kanekiwa.” Di milungwa kaun i korale gin taran be dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dungure Yesu pol dire Pita tena yuulin bile kanungure, ena Singaba Yesu ka di tongwa Pita pirungwa. Goma Yesu ka iru di yalini tongwa, “Kemina i ginin sutakobe, ‘Na yalini guman ta kanekiwa,’ dire ka di kile di mena eranwa.” Ka dungwa i pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pirere Pita mena pire kay mun bile yaare simil kay miingwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ena yal kobe Yesu el kwi nu milere, ebi mi yalini tere sungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sire yalin kobe Yesu omilin gal were si pere di tere, ka iru sirin bile Yesu tongwa, “God ka kebe yal dungwa mere, bolin kule di maribe ero. Ibena i sime?” ");
INSERT INTO gvf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dire ka taw ama di tere, gain ka si tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ena kamin taangure, Yuda ka main singaba kobe, te ka main kenin erungwa yal bil kobe, te ka main nil si tongwa yal kobe u ku bilungure, ibal kobe Yesu awli u ku bilungwa mina ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ongure u ku bilungwa yal kobe ka iru sirin bile Yesu tongwa, “God konagi erungwa yal, Kirisito, yal iray i milino?” Dungure yalini ka iru di tongwa, “Di maribe eralba, i kakiibi dima di piranwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Te ka ta sirin bile i teralba, i maan di kole erekinanwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dimba malia te eme para Na U Ibal Obinga Yal God yobilaan bilungwa aan wen kol amin di milalwa.” ");
INSERT INTO gvf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dungure yalin kobe para ka iru di tongwa, “I God Wan milino?” Dungure yalini maan dire, “I ka iru dinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dungure yalin kobe ka iru dungwa, “Ka kol kanungwa yalin kobe tameran ka diname? Yalini inin ka dungwa gain ka si God tongwa pirebinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ena u ku bilungwa para alere, Yesu awli pi yal singaba bil Pailete milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pirere ka digwane waa tere iru dungwa, “Yalini mile, ‘Kobile takis yal bil Sisa tekio,’ dire te ‘Na yal bil Kirisito miliwa,’ dire bawle ibal kobe tongwa kanebinwa.” ");
INSERT INTO gvf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dungure Pailete ka iru sirin bile Yesu tongwa, “Yuda ibal yal bil i milino?” Dungure, “I iru dinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dungure ena Pailete ka iru di Yuda ka main kenin erungwa yal bil kobe, te u ku bilungwa ibal kobe tongwa, “Kal ki erangwa yalini kal ta erekima di kania, ena ka kol main ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dimba yalin kobe girin di niminin mile ka iru dungwa, “Galili gariba gul ka nil si ibal tere, Yudia gariba gul ka nil si tere ongwa ongwa, abili para ka nil si ibal tomia, ena ibal kobe para muru pire den tawre dere kura bilangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ka dungwa i, Pailete pirere, “Yalini Galili nen milim mo, gariba baan ta nen milime?” dire iru di sirin bile pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pirere, “Kerodi kenin erungwa ain nen milemua,” dungwa pirere, ena Kerodi malia Yerusalem ai milungwa para pirere, yalini Yesu nusi Kerodi milungwa gul erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yesu guun kan warungwa Kerodi pirere yalini baan araway kanala di piremia, ena malia Yesu u milungwa kanere, Kerodi wai wen pirungwa. Yesu kal guman kwi dungwa erama di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pirere ka binanbile sirin bile Yesu tomba, yalini ka ta wen ta dekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yuda ka main kenin erungwa yal bil kobe, te ka nil si tongwa yal kobe para maala milere, ka niminin mile dire, ka digwane waa Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kerodi te yalini simil nen bawle tere, te gain ka si tongwa. Tere gal wai wen dungwa kaw tere nusi Pailete milungwa gul erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Goma Kerodi te Pailete kayminin milimba, malia i yal sui ka wai dirala dire, kawn kule ka dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ena Yuda ka main kenin erungwa yal bil kobe te Yuda ibal yal singaba kobe, te ibal kobe para Pailete ibalin kobe di ku bilere ");
INSERT INTO gvf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ka iru di tongwa, “I yalini na miliga gul awli ure, ‘Yalini kakiibi dire ibal bawle tomua,’ di na tenwa. Malia na yalini ka sirin bile tega i pirinba, i ‘Yalini kal ki eremua,’ dire ka digwane waa tenga, pirin paikima di piriwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Te Kerodi na miliga gul kwi nusi eremia, ena yalini para mile, ‘Pirin paikimua,’ dimua. Yalini si gulabinba, kal ki ta erekimua. ");
INSERT INTO gvf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","‘Yalini kuba galan yongwa aa tere so,’ di simil nen tere, kanin paangwa gule ere teralwa.” ");
INSERT INTO gvf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Komina bil erin kaun i, Pailete kaun kaun kanin paangwa yal ta morin kanin gule ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ibal binanbile u ku bilere gala dire iru dungwa, “Yalini si gulo. Barabas kanin paangwa gule miina ero.” ");
INSERT INTO gvf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ogu ai bil Barabas gabman bole kura bilere ibal si gulemia, ena kanin pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailete Yesu kanin gule ere terala di pire ka kwi di ibal kobe tomba, ");
INSERT INTO gvf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ibal kobe kwi gala dire iru dungwa, “Eri pera mina si gulo. Yalini eri pera mina si gulo.” ");
INSERT INTO gvf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailete ginin sutan dire ka ta kwi dire iru dungwa, “Tameran ka iru dine? Takal erungwa ki ereme? Yalini si gulabinga kal ki ta erekungwa kanebina, ena ‘Kuba galan yongwa aa tere yalini so,’ di simil nen tere kanin paangwa gule ere teralwa.” ");
INSERT INTO gvf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yalini iru dimba, “Yesu eri pera mina si gulo,” gala di milungwa di milungwa, ena ka dungwa wi yebe ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Omia ena ibal kobe kal ta erala di pirungwa mere, Pailete owa di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yal ta gabman bole kura bilere, te ibal si gulungwa kanin paangwa, “Gule ero,” dungwa Pailete kanin paangwa gule erere, te ibal kobe kal ta ere Yesu tenama dire, “Awli po,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ena Yesu awli ongure, Sairini yal ta kaan Saimon, konagi ere mile pisere ungure, simil nen kanungwa. Kanere yalini aa gi dire eri pera kaw tere, “Yesu ongwa mun kol kawi ire po,” di yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ibal binanbile Yesu duulin bile ongure, abal taw kobe bole para pire kay mun bile yaare kay mi Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tongure Yesu si kiruul sire ka iru di abal kobe tongwa, “Yerusalem abal kobo, i kay mi na tekio. I inin, te wanin abilin kobe kay mi to. ");
INSERT INTO gvf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kamin kaun ta taalime u maribe nangure, ibal kobe ka iru dinangwa, ‘Abal temine gaan kule yekire, te gaan amin tekungwa abal iru milungwa kobi, miriin painamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dire te ka ta para iru di kamin kuul maangwa tenangwa, ‘Kiray yaa na so.’ Te ka iru di kamin kuul mege tenangwa, ‘Kiray yaa na si biro.’ ");
INSERT INTO gvf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ibal kobe malia kal iru ere na tenangi, ena kal ki wen ere Yuda ibal kobe tenamua.” ");
INSERT INTO gvf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ena yalin kobe yal sutan kal ki erungwa, Yesu bole para si gulabina dire awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pirere gariba ta kaan Gibilin Yobilaan u bawa dire, Yesu eri pera mina nil bili si paalere, te kal ki erungwa yal ta Yesu aan wen kol nil bili si paalere, te yal ta Yesu aan kora kol nil bili si paalungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Si paalungure Yesu ka iru dungwa, “Na Abe, ibal kobe main pirekire erungwa, ena kal digan ere taalime erungwa i, i kire di ere to.” Dungure yalini gal ta ta irala dire sandu sungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ibal kobe kane milungure, Yuda ibal singaba kobe ka di sutaw ere tere iru dungwa, “Yalini ibal kobe aa ki dungure u wai ongwa, yalini God paale suna ere ingwa yal Kirisito milamia, ena yalini inin aa ki dinamba.” ");
INSERT INTO gvf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Dungure simil nen para ka di sutaw ere tere kal iru erungwa. Yalin kobe u Yesu milungwa gul ure, “Nil wain gi kiingwa no,” dire ");
INSERT INTO gvf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ka iru dungwa, “I Yuda ibal yal bil milamia, ena i inin aa ki do.” ");
INSERT INTO gvf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yalini gibilin mine kol piapa bile paalungure, minin ganin iru bilungwa, “Yuda ibal yal singaba bil wen milemua.” ");
INSERT INTO gvf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kal ki erungwa yal ta eri pera mina si paalungure, Yesu gain ka si tere iru dungwa, “I Kirisito ta milekeno? Milanga i inin aa ki dire, te na yal sutan para aa ki di na to.” ");
INSERT INTO gvf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dimba kal ki erungwa yal ta kan tere iru dungwa, “I God kuril pire tekeno? Na yal kobe para eri pera mina malia si gulamua. ");
INSERT INTO gvf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Si gulangwa na yal sutan kal erebinga pirin paangwa para wai paamba, yalini kal ki ta erekimua.” ");
INSERT INTO gvf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dire ka iru di Yesu tongwa, “Yesu i kenin ere ke milanga kaun u bawa dinangwa, nomanin si pire na to.” ");
INSERT INTO gvf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dungure Yesu ka iru di tongwa, “Na ka ta di i terala piro, kemina na i bole ai wai ta kaan Paradais milabilwa.” ");
INSERT INTO gvf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ena are kamin suna wen ongure, are te sekungure kamin si bilungwa si bile dungwa dungwa, ena pu dungwa are pera ongure, kamin kwi aw dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Gal bilkaw Yuda ibal ka main ogu bil kegemama yongwa ai si pere dungwa gal God mine aa dinaa di yene pira sungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu gala bil ka iru dungwa, “Abe, na ibanan i kenin ere ke milana dire i teiwa.” Dire pare gulungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kal iru erungwa, simil nen kenin erungwa yal kanere, deminin si God tere iru dungwa, “Yalini yal wai wen milemiawa.” ");
INSERT INTO gvf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kalkan u maribe nangwa kanabina dire ibal kobe ure kalkan i kanere, miriin wen pire milere ere ogin ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu ye nongwa ibal, te yalini Galili gariba gul milungure abal kobe mun kol duulin bile ungwa para, taw tayan mile yalini eri pera mina si gulungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ena yal ta kaan Yosepe milere, Yuda ibal ogu ai ta kaan Arimatia ki pai milungwa. Yuda ka main u ku bilungwa ibal yalini yal ta milimba, u ku bilungwa ibal Yesu si gulabina di pirimba, yalini owa ta dekungwa. Yalini kabin sire yal wai milere, te God kenin ere ke milangwa kaun u maribe nangwa suul mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yalini pi Pailete milungwa gul pirere Yesu yobilagi irala dire sirin bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yosepe pirere Yesu yobilagi mone di i main erere, gal pege wai werere, kobile giran ta ibal woolungwa ali yongwa. Kobile giran i goma ibal alia ta yekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kaun i Sare kaun u maala ongure, ibal kobe kalkan aa tekun erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yesu Galili gariba gul milungure abal kobe duulin bile ungwa, abalin kobi Yosepe bole pirere, kobile giran kanere, te Yesu yobilagi yongwa mere para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kanere kwi ogun pire eri niriin minanin wai sungwa Yesu yobilagi bile tere yerala dire, kalkan aa tekun erungwa. Erere Mose kile kaman ka dungwa mere, Sare kaun erin milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ena Sarebil kaun are nol erungure, abal kobe eri niriin minanin wai sungwa aa te wai erungwa irere, kobile giran nala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","U bawa dire kobile milin bilkaw kobile giran si pere dungwa yawlungwa kanere, ena ");
INSERT INTO gvf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","pi ala omba, Yesu yobilagi ta dekungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kanere pire gogo ere milungwa, ena gin taran yal sutan u maribe pire gal sigi dungwa naabilungure, abal kobe binan ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Milungure abal kobe kuril wen pire milere i kwi bilungure, yal sutan i, ka iru di tongwa, “Tameran ibal gule yongwa ain yal ta kwi milungwa waa duune? Yalini abila ta milekimia, kaya ale ere omua. ");
INSERT INTO gvf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yalini Galili gariba gul goma milere, ka di i tongwa nomanin si piro. ");
INSERT INTO gvf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ka iru di i tongwa, ‘Na U Ibal Obinga Yal, yal kobe na kanin sire awli ibal tere, na eri pera mina si gulangure, are kaun sutakobe wei sinangure, kwi alalwa.’” ");
INSERT INTO gvf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yal sutan i mile ka iru di abal kobe tongwa, ena Yesu goma ka dungwa nomanin si pirungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pirere kobile giran pisere pi gawlima kobe anan kole kole muru kawnan milin taran kalkan kanungwa i, di tere te gawlima kobe imo milungwa para, di maribe ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Madala ai abal ta Maria milungure, te Yoana milungure, te Yemis man Maria milungure, te abalin kobe te abal taw para kalkan kanungwa i, pi nusi erungwa ongwa yal kobe, Aposel, di maribe ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Di tomba yalin kobi abal kobe ka dungwa ka way erima di pirere, pire nomanin suna ta yekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ta yekimba, Pita mugu di pi kobile giran ongwa. Pi milere maa dire kanere, gal gain were tongwa tawle dungwa kanungwa. Kanere pire buul kunere ere ogin ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ena kal iru erungwa kaun i, Yesu gawlima sutan ere ogu ai ta kaan Emeas ongwa. Ogu ai i Yerusalem taw tayan, eleben kilomita, dungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pirere malia kal main u maribe ongwa ka diria ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Diria ere milungure ena Yesu inin u bawa dire yal sui bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ongure yal sui yalini kanere bole omba, Yesu bole ubina di ta pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu ka iru di yal sui tongwa, “I yasu ware ure ka diria ere milinga, i ka tawa dine?” Dungure yal sui kol baan milere, inin miriin pire guman yaangwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yal ta kaan Kiliopas, ka iru sirin bile Yesu tongwa, “Ibal baan baan para pi Yerusalem mile, kalkan malia u maribe ongwa kanimba, i yal taran tawle ta kanekino?” ");
INSERT INTO gvf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dungure, “Takal u maribe ome?” dungure ena yalini maan dire iru dungwa, “Nasarete ai nen Yesu kan dibingi. Yalini God ka kebe yal milungwa, ibal kobe te God guman mina ka dire, te kal guman kwi dungwa eremua. ");
INSERT INTO gvf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na ibal kobe ka main kenin erungwa yal bil kobe, te yal singaba kobe bole Yesu si gulama dire, kanin sire awli pi ibal tongure, ena ibalin kobe eri pera mina si gulemua. ");
INSERT INTO gvf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yalini Isirel ibal kobe aa ki di tere, tobe tenangure ere ain nama di pirebinwa. Kal iru pilau dimba, are kaun sutan wei sungure, ");
INSERT INTO gvf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ena na gawlimanan abal taw ka dungwa na ibal kobe buul kunebinwa. Kemina are nol erungure abalin kobe kobile giran omba, ");
INSERT INTO gvf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yobilagi dekungwa kanemua. Kanere kwi ure ka iru dimua, ‘Angel kobe u maribe pire Yesu ale kwi milemua,’ dungure abalin kobe dimiawa. ");
INSERT INTO gvf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dungure na gawlimanan kobe taw kobile giran pire, abal kobe ka dungwa mere kanimba, Yesu ta kanekimua.” ");
INSERT INTO gvf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dungure Yesu ka iru di yal sutan tongwa, “I yasu nomanin paikungwa milinwa. Ka kebe yal goma dungwa mere, gin taran pire nomanin suna ta yekingirawa. ");
INSERT INTO gvf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","God konagi erungwa yal, Kirisito, giil pire kamin mina naabilungwa bole milama dire i iru di piringiraba.” ");
INSERT INTO gvf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dire ena Yesu kanin dungwa mere, Mose minin ganin bilungwa goma di maribe erere, te ka kebe yal kobe ama minin ganin bilungwa para, di maribe erere di ongwa ongwa, ena ka main minin ganin para yalini kanin dungwa mere, para di maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ena yal sutan i ogu malge nala dungwa u maala ongure, Yesu baan ta nala di erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Erimba yal sutan manaa dire iru di Yesu tongwa, “Kamin kaya giremia, ena i na yasu bole pairabina wo.” Dungure yalsu bole pairala dire, ere ala ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pirere komina nerala di erere, komina birete aa tere maki ye God tere, bege dire yal sutan tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tomia ena Yesu milema di malia kanimba, Yesu kaya ere ongure, yal sutan i yalini kanekungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kanekire ka diria ere iru dungwa, “Yalini ka main minin ganin di maribe ere na yasu tongwa, nomanin suna wai pire miriin paimua.” ");
INSERT INTO gvf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ena yalsu gin taran alere, ere Yerusalem pire gawlima kobe anan kole kole muru kawnan milin taran, te ibal kobe para u ku bile milungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kanungure ena yalin kobi ka iru di milungwa, “Singaba Yesu kaya alere i maribe erungure, Saimon yalini kanemua.” ");
INSERT INTO gvf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dungure yal sutan kol baan ongwa kalkan u maribe ongure, te Singaba Yesu komina birete bege dungure Yesu milema di kanungure, kalkan iru erungwa kanungwa i, bolin kule di maribe ere ibalin kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ena yalsu iray ka di milungwa kaun i, Yesu gin taran yalin kobe milungwa gul suna u bawa dire, ka iru di tongwa, “Yalkuna kobe, mile dinio.” ");
INSERT INTO gvf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dimba yal kobi sia ta ungwa kanebina di pire, kuril wen pire kalgane ingwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iru pirungure yalini ka iru di yalin kobe tongwa, “Tameran i nomanin si ala erine? Tameran i nomanin susu sine? ");
INSERT INTO gvf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Na taran milema di piranga, na anan te kawnan kano. Sia aan gain ta dekemia, ena na anan gaynan dungwa aa to. Aa tenanga ibal milema di piranwa.” ");
INSERT INTO gvf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dire ibalin kobe na kanama dire yalini aan kawn diru dire i maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dimba yalin kobe Yesu milema di pirekire, miinin maare buul kune kane milungwa, ena Yesu ka iru di yalin kobe tongwa, “Komina nerabinga ta ali dimo?” ");
INSERT INTO gvf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dungure nil kabe ta kaya dongwa tawle tongure, ");
INSERT INTO gvf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","irere nongure, yalin kobe kane milungwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ena Yesu ka iru di yalin kobe tongwa, “Kalkan u maribe ongwa i, na i bole milebinga kaya di i teiwa. Mose kile kaman ka te ka kebe yal ka minin ganin bilungwa, te geril minin ganin bile paalungwa ka main minin ganin iru para na kanin dungwa, milin paire kaya u maribe omua.” ");
INSERT INTO gvf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dire ka main minin ganin ere gule pirama dire, ka nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tere ka iru di tongwa, “Minin ganin iru bile paalungwa, ‘God konagi erungwa yal Kirisito, giil pire gulere are kaun sutan wei sinangure, kwi alamua. ");
INSERT INTO gvf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Te i ibal kobe yalini pire tere, ibal kal digan ere taalime erungwa nomanin suna si kiruul sungure, God kire di eramua, dire goma kere di Yerusalem ibal kobe tere di ongwa ongwa, ena gariba gul ibal para muru ware u bawa dinamua.’ ");
INSERT INTO gvf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","I kalkan kaninga bolin kule di maribe ere ibal kobe tenanwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na Abe inin iban ta, ‘Nusi ere i teralwa,’ dungwa na inan nusi ere i teralwa. Teralba God Iban ta nusi ere i tenangure, yobilaan bile i tenangwa i ogu ai bil suna suul milo.” ");
INSERT INTO gvf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dire pare awli mena pire ere Betani maala ongwa, ena aan dire dire, “God miriin pai i tenamua,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ka di te milungwa kaun i, God yalini awli pi ere kamin mina ongwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ongure yalin kobe deminin si yalini tere ana dire kwi Yerusalem pire wai wen pire miriin paangwa. ");
INSERT INTO gvf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Paire Yuda ka main ogu bil morin morin ala milere, maki ye tere deminin si God te milungwal milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ena kamin kaya wen kamin te gariba ta ere yekungwa kaun, God ka main di maribe erungwa yal milere, yalini kaan Ka Dungwa milungwa. Milere God bole si dawle milere, te yalini God bole taran milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kamin kaya wen i, yalini God bole para milere, mili ongwa ongwa malia i ama mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kalkan para muru dungwa te para muru milungwa, yalini te God bole kirara muru ere yongwa. Ibal ta kal ta ere yekungwi, yalini taran wen para muru ere yongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yalini ta milekenangwa, ibal para muru ta milekerabinga. Milekerabinba yalini milungwa ibal para milebinga. Milere nomanin naabile aw di na tongure milebinga. ");
INSERT INTO gvf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nomanin naabile tongwa yal si bilungwa ali milere, aw dungwa, si bilungwa kobaan Satan kirara si bile dinama di eramba, aw dungwa di painangwal painangwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yal ta kaan Yon, God nusi erungure, ena yalini u maribe pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Milere nomanin naabile tongwa yal guun kan di maribe erala dire ungwa. Ibal para yalini guun kan pire gi di tenama dire ungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yalini nomanin naabile tongwa yal ta milekimba, nomanin naabile tongwa yal guun kan di maribe erala dire ungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ungure nomanin naabile tongwa yal kirara wen milere, ibal para nomanin naabilama dire gariba gul yalini u maribe pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gariba gul milere, gariba gul para ere yomba, yalini guun kan gariba ibal pire pol sekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yalini ogun ain omba, yalini ibalin kobe aa te wai ere tekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tekimba ibal taw kobe aa te wai ere tere pire gi di yalini tomia, ena ibalin kobe God kule yongwa kobe milama di pirere, yobilaan bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ibalin kobi u God kule yongwa kobe ongwa iwe. Ibal nomanin pire gaan kule yongwa mere, ta kule yekungwi, God inin ibalin kobi nomanin si pire kule yongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ibal ta kaan Ka Dungwa, u ibal wo ongure, na ibal kobe yalini bole mile paibingire, yalini kenin wai ere ibal tere kirara kawen di milungwa. Abe God Wan taran yobilaan bil niminin wen milungwa, na ibal kobe kanebinga. ");
INSERT INTO gvf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yon mile yal iray guun kan di maribe ere iru gala dungwa, “Na yalini i miire goma na ka iru diga, ‘Yalini eme na munan kol unamba God yobilaan bil pai yalini tongure, na yobilanan kuunin ta pai na tekemua. Na mina na kule yomba, yalini goma milemia, ena na yobilaan kuunin ta pai na tekemua’” ");
INSERT INTO gvf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dungure yalini kenin wai wen ere ibal tomia, ena kal wai wen ere na ibal kobe tongwa. Yalini iru na tere tere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God ka di Mose tongure, Mose mile kile kaman ka tawle di na tomba, Yesu Kirisito ure kenin wai ere na ibal kobe na tere, te kawen kirara di na tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ibal para wen God ta kanekungwa. God Wan taran nen bole pena gale u taran pi milungwa, ena yalini God milungwa main i maribe ere ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ena Yuda ka main yal singaba kobe Yerusalem milere, Yuda ka main kenin erungwa yal kobe, te yalin kobi nil konagi yal kaan Ilibai nen kobe para, nusi Yon milungwa gul ere, “Iru do,” di tongwa, “I ibena miline? I God konagi erungwa yal Kirisito milino?” Dungure Yon inin main di maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yalini pire unin si milekire, ka di gawa dire iru dungwa, “Na Kirisito ta milekiwa.” ");
INSERT INTO gvf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dungure yalin kobe ka iru sirin bile tongwa, “Dinba, i ibena miline? Ilaya milino?” Dungure yalini mile, “Na ta milekiwa,” dungure, yalin kobe kwi sirin bile tongwa, “Goma wen Mose mile, ‘Ka kebe yal ta u maribe namua,’ dungwa iray, ka kebe yal iray i milino?” Dungure yalini, “Ta milekiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dungure yalin kobe ka iru di tongwa, “Ibal kobe na yal kobe nusi erungwa, ka maan di ibalin kobe terabina dire, i milinga pirere, takal waa dine?” ");
INSERT INTO gvf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dungure Yon ka iru dungwa, “Goma wen ka kebe yal Aisaya, na kanan dire ka iru dungwa, ‘Gariba simi yongwa gul yal ta iru gala dimua. God Singaba unangwa kol aa tekun ero.’” ");
INSERT INTO gvf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dungure ena Parasi kobe taw nusi erungwa ungwa yalin kobe suna milere, ");
INSERT INTO gvf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ka iru sirin bile Yon tongwa, “Kirisito te Ilaya te ka kebe yal iray, yalin kobi para kaan galebinga i, ‘Na ta milekiwa,’ dina, tameran i nil bile ibal tene?” ");
INSERT INTO gvf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dungure Yon maan dire ka iru dungwa, “Na nil bile ibal tobinba, i milinga suna yal ta milungwa, i yalini main ta kane pol sekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yalini na munan kol unamba, na gal kine yalini teralga paamba, na yal digan milia, kuunin ta erekimua.” ");
INSERT INTO gvf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ena ka dungwa i Betani ai milungure, u maribe ongwa. Ai iray Yodan nuule kol ime dungure, Yon nil bile ibal kobe te milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ena kal iru ere paire kwimile Yesu Yon milungwa gul urala dungwa kanere, Yon ka iru dungwa, “God yal ta nusi erungwa ungwa kano. Bolima siipe siipe gawlin si gale God tongwa mere, yalini iru milemia, ena gariba gul ibal kobe kal digan ere taalime erungwa kire di erala eremua. ");
INSERT INTO gvf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na yalini i miire goma na ka iru digirawa. Yalini eme na munan kol unamba, God yobilaan bil pai tongure, na yobilanan kuunin ta pai na tekemua. Na mina na kule yomba, yalini goma milemia ena na yobilanan kuunin ta pai na tekemua. ");
INSERT INTO gvf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yal ta i kan dibinga i, yalini God konagi erungwa yal, Kirisito milema di para ta pirekebinwa. Pirekebinba, Isirel ibal kobe yalini guun kan pirama dire, na ure nil wo bile ibal teiwa.” ");
INSERT INTO gvf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yon ka di gawa dire iru dungwa, “Kamin mina God Iban imil giran guman kulungwa mere si paale ire kule, Yesu milungwa gul ere ime ungwa, kaniwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kanere yalini Kirisito milema di pirekebinba, ‘Nil bile tenana po,’ di na nusi erungwa yal, God ka iru di na tongurawa. ‘Na Ibanan ere ime ure yal ta si paale ire kule milungwa gul u milangwa kananwa. Yal iray na inan Kegemama Iban nusi ere ibal tenangure, ibal nomanin sigi dinamua.’ ");
INSERT INTO gvf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dungwa mere kaniga, ena yalini God Wan milema di kaniwa,” dire Yon ka iru di ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ena kal iru ere paire kamin taangure, Yon te yalini gawlima sutan bole kol baan iray ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Milere Yesu kol peraa di ungwa kanere, Yon ka iru dungwa, “Yal ta umia kano, God bolima siipe siipe gawlin milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ka dungwa i Yon gawliman sutan pirere, Yesu mun kol duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu pol dire yal sui mun kol duulin bile ungwa kanere, ka iru sirin bile tongwa, “I yasu tameran une?” Dungure yal sui ka iru dungwa, “Arabai, (ka i Golin ka iru dungwa, Nil si tongwa yalo) i alde ki paine?” ");
INSERT INTO gvf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Dungure, “Kanana wo,” di tongure ena yal sui yalini bole para pirere, pai milungwa ain kanere, are pera ongure gilaa iray, Yesu bole pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yal sui Yon ka dungwa pirere Yesu mun kol duulin bile ongure, yal ta i kaan Endiru milungwa. Milungure yalini abinbi Saimon Pita milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ena Endiru gin taran abinbi Saimon waa duure kanere, ka iru di tongwa, “God konagi erungwa yal Mesaya, milungwa i kanebinwa.” (Mesaya kan dungwa i Kirisito mere dungwa.) ");
INSERT INTO gvf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Direre yalini Saimon awli pi Yesu milungwa ungure, Yesu Saimon kanere ka iru di tongwa, “I Yon wan Saimon milinwa. Malia i kaanin Sipas yerabinwa.” (Kaan Sipas dungwa Pita kaan mere dungwi, te kaan sui Golin ka paangwa, Kobile) ");
INSERT INTO gvf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ena kal iru ere paire kamin taangure, Yesu Galili gariba gul nala di pirungwa. Pirere Pilipi kol baan ungwa kanere, “I na munan kol duulin bilo,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi Besaida ogu ai ki pai milungure, te Endiru te Pita ogu ai i para ki pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ena Pilipi pire Nataniel waa duure kanere ka iru di tongwa, “Mose kile kaman ka buku ali bilungwa, te ka kebe yal para bilungwa mere, yal ta yalin kobi kanin dungwa u maribe ongwa kanebinwa. Yalini Yosepe wan Yesu milere Nasarete ogu ai ki paimua.” ");
INSERT INTO gvf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dimba, Nataniel ka iru dungwa, “Nasarete ogu ai digan yal wai ta u maribe namba.” Dungure Pilipi mile, “Kanana wo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ena Nataniel Yesu milungwa gul ungure, Yesu kanere Nataniel milungwa mere ka iru dungwa, “Yalini Isirel yal mabil milungwa kaniwa. Kakiibi dungwa ta paikungwa yal milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dungure Nataniel ka iru sirin bile Yesu tongwa, “Na mile pai eriga mere i ka dinga i, genawna i na kane pol sine?” Dungure Yesu ka iru di tongwa, “Pilipi i kaya gala dikungwa kaun, akola main ali milinga kaniwa.” ");
INSERT INTO gvf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dungure Nataniel waa dire ka iru dungwa, “Nil si tongwa yalo, i God Wan milinwa, te na Isirel ibal kobe kenin erungwa yal bil para milinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dungure Yesu dungwa, “‘I akola main ali milinga i kaniwa,’ di maribe erebina, ena pire gi di na tenwa. Tenba malia i ulin tawle kaningi, kal guman kwi dungwa bilkaw eme u maribe nangwa, i kananwa.” ");
INSERT INTO gvf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dire ainere ka iru dungwa, “Na kawen dirala piro. Eme kamin ai kawa ala di kole kole nangure, aw dinangure God angel kobe Na U Ibal Obinga Yal miliga gul ere ime ure, kwi wi yebe nangwa kananwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ena are kaun sutan wei sungure pare, Kena ai Galili gariba gul suna dungwa gul, Yesu man, abal ingwa komina bil nerala dire, pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Abal ingwa yal kobi Yesu te gawliman kobe bole abal ingwa, “Komina bil nenan wo,” di gala dungure, u milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Eme nil wain i para ne wei sungure, Yesu man iru di yalini tongwa, “Yal kobi nil wain wei simua.” ");
INSERT INTO gvf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dungure Yesu maan dire dungwa, “Abalkuno, i kanin ta paikimia, na inan kanan paimua. Na konagi kawn kule eralga kaun ole u bawa dikimua.” ");
INSERT INTO gvf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dungure yalini man ka iru di nil konagi ibal tongwa, “Ena yalini ka ta di i ibal kobe tenangwa, i wiina ero.” ");
INSERT INTO gvf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuda ibal ka main ta paangwa gain morin bigin sungwa, ena kobile muine anan kole muru kole taranta dungwa. Muine iray taranta, yal kobe nil kule muulangwa, nil binanbile eti lita, kuunin erangwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu di nil konagi ibal tongwa, “Nil kule muine sin ali garu di muulo.” Yal kobi nil kule muine sin ali garu dungure, muulungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesu kwi ainere di ibal kobe tongwa, “Malia nil taw sin ali garu direre, i pi komina bil kiingwa kamil kaa kobaan to.” Ena yal kobi i ongure, ");
INSERT INTO gvf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","yalini nil wo u nil wain ongwa ne pirungwa, nil wain i kule yuungwa nil konagi yal kobe kanimba, yalini ta kanekungwa ena komina bil kiingwa kamil kaa kobaan abal ingwa yal gala dire ");
INSERT INTO gvf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","iru di tongwa, “Ibal para wen wain nil wai obin goma sungure, ibal kobi nil binanbile ne wei sire kubin maangure, ena nil wain digan obin simba, i nil wain wai aa gi di milere, malia wen suule yuungwa.” ");
INSERT INTO gvf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kal guman kwi dungwa ta i maribe erungure, ibal kobe buul kunungwa, Kena ai Galili gariba gul suna dungwa malia kawn kule erungwa. Ena Yesu inin naabile yobilaan bilungwa i maribe ere ibal kobi tongure, yalini gawlima kobe pire gi di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ena kal iru erungure pare, Yesu te man te kebin kobe te gawliman kobe, ibalin kobe ere Kapanaum pire kaun tawliga milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ena Yuda ibal bolima siipe siipe sungure God yalin kobe ta sekungwa kaun pire, komina bil nenama dire kaun i u maala omia, ena Yesu ere Yerusalem ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pire Yuda ka main ogu bil ala pire, yal kobe bolimakau te bolima siipe siipe te kauba, kobile moni irala dire yongwa kanere, te aibe tobe erungwa yal kobe kobile moni senis ere milungwa, para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kanere kan kuba sirala dire kan a kubagi mere erere, bolima siipe siipe te bolimakau ibal para, si kiranin bile ka main ogu i waa kire di mena erungwa. Kobile moni aibe tobe erungwa yal kobe bol aa sinaa dire, te kobile moni aa sulu di main erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ibal kobe kauba imil si gale God tenangwa, ibal taw kobile moni irala dire, kauba imil i yongwa ibal kobe milungure, Yesu ka iru di tongwa, “Kalkan i, i mena kol ibe erana po. Kal iru eringa i, na Abe ogin kwi u maket kol omia, iru erekio.” ");
INSERT INTO gvf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dungure ka main minin ganin iru bilungwa, “Na God i oginin wai wen dinama di pire, na nomanin tegi dibina, ena yobilaan bile girin di miliwa.” Yesu kal iru eremia, ena ka iru bilungwa mere, malia Yesu gawlima kobe nomanin si pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ena Yuda ibal mile ka iru di Yesu tongwa, “I kal iru eringai, God yobilaan bile i toma di pirabinga, takal kal guman kwi dungwa erangire kanabine?” ");
INSERT INTO gvf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dungure en dire dungwa, “God ogin iray si suule eranga, ena are kaun sutakobe wei sinangure, na gin taran kaya kwi ki piseralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dungure yalin kobe mile, “Ka main ogu iray kiingwa me erin, yal sui aan kawn muru na anan kole muru kole taran iru mere ki mile ki wei simia, ena i, ‘Are kaun sutakobe kwi gin taran kiiralwa,’ dino?” ");
INSERT INTO gvf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dimba Yesu ka main ogu iray kan dungwa i, yalini inin gain mina di bile dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ena eme Yesu gule alemia, ena gawlima kobe Yesu goma ka dungwa i pirere, te ka main minin ganin bilungwa, te Yesu ka dungwa pire gi dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ena komina bil nongwa erin kaun iray, Yesu Yerusalem milere kal guman kwi dungwa erungure, ibal kobe buul kunere ibal binanbile pire gi di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Ibal kobe mile pai erungwa mere Yesu pire pol simia, ena ibalin kobi, “Pire gi dibinwa,” dimba, Yesu ibalin kobi bole pena galala di pirekungwa. Ibal kobe nomanin suna pirungwa mere, yal ta Yesu main taw ama di maribe ere yalini tenamba. ");
INSERT INTO gvf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parasi ta kaan Nikodimas, Yuda yal singaba milere, ");
INSERT INTO gvf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","gilaa kaun ta Yesu milungwa gul urere iru di tongwa, “Arabayo, i nil si tongwa yal God nusi erungwa, na yal kobe kanebinwa. God yal ta aa ki dekenangwa, i kal eringa mere yal ta erekinamua. God i kawen aa ki di tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu maan dire dungwa, “Kawen di terala piro. Yal ta gamege mere nangure, God kwi kule nenangwa, ena God kenin ere ke milungwa ai kanamua.” ");
INSERT INTO gvf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dungure Nikodimas ka iru sirin bilungwa, “Yal dimanin milungwa, tamintan kwi u gamege mere nangure, gaan kule yename? Yalini kwi pi man den miriin suna nangure, man kwi kule yenamba.” ");
INSERT INTO gvf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu maan dire dungwa, “Kawen dirala piro. Yal ta God kenin ere ke milungwa ai nangwa, man kule yerere, te God Iban para kule yenangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ibal kule yongwa ibal kuunin milemua. Te God Iban kule yongwa, God Iban bole si dawle milemua. ");
INSERT INTO gvf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ibal kobe kwi u gamege nangure, ‘God gaan kule yenangwa paamua,’ iru di tobingai, i pire buul kunekio. ");
INSERT INTO gvf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Gwi maare u gogo ongure, i kiranin pirinba, kole maare u kole om mo, pirekun erekinwa. Iru erungwa mere yal ta God Iban yal ta kule yenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Dungure Nikodimas iru di yalini tongwa, “Kal iru erangwa main, tamintan u maribe name?” ");
INSERT INTO gvf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu maan dire dungwa, “I Isirel nil si tongwa yal milimba, ka ta di tobinga, i pirekeno? ");
INSERT INTO gvf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na kawen dirala piro, kalkan kobe pirebinga ka iru dibinwa, te kalkan kanebinga di tobinwa. Di tobinba ka dibinga, i yal kobe pire gi dikinwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Gariba kal main di tobinga pire gi dikina, ena kamin kal main di terabinga, genawna pire gi dinane? ");
INSERT INTO gvf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na U Ibal Obinga Yal kamin mine milere ere gariba gul urere, na inan kamin mine ibe obinba, ibal taw ama pekemua. ");
INSERT INTO gvf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Mose gariba simi yongwa milere, oniba giran guman kulungwa mere, ain yobilaan iru ere yere bile waaki dungwa mere, Na U Ibal Obinga Yal iru bile waaki dinamua. ");
INSERT INTO gvf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Iru erala ibal kobe aa gi dire pire gi di na tenangwa, ena mile painangwal painamua,” dire Yesu ka iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God gariba ibal para den miriin tomia, ena yalini Wan taran nusi ime ere na ibal kobe tongwa. Tomia ena ibal kobe aa gi dire pire gi di yalini tenangwa, ena ibalin kobi iban u enderin gaul ai ta pekire, mile painangwal painangwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God Wan ka kol pai gariba ibal tenama dire, God yalini nusi ime ere na ibal kobe ta tekungwa. Gariba ibal aa ki di tenangure, sigare kule u wai nama dire nusi ime ere na tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ibal kobe pire gi di God Wan tenamia, ena God ibalin kobi ka kol ere tere, “Pirin paimua,” di tekenangure, te pire gi di God Wan taran ta tekenamia, ena kaya ka kol ere tere, “Pirin paimua,” di tenangwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nomanin naabile tongwa yal ere gariba gul umba, ibal kobe nomanin naabilama di pirekire kalkan ki eremia, ena nomanin kama sinama di pirere ere milungwa. Ere milemia, ena ka kol pai ibalin kobi tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ibal kobe kal ki erere, nigi de pire, nomanin naabile tongwa yal, tongwa. Kal ki erungwa i maribe erekinama dire, nomanin naabile tongwa yal milungwa gul ta ukungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dimba ibal kobe kal wai erere, nomanin naabile tongwa yal milungwa gul ongwa. God aa ki dungure ibalin kobi kal wai erungwa, nomanin naabile tongwa yal iru i maribe ere tenama dire, ibalin kobi yalini milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ena Yesu ka iru di yal iray tongure pare, yalini te gawliman kobe bole ere Yudia gariba gul pire, taw milere nil bile ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tongure Yon para nil bile ibal kobe tongwa. Yalini Selim ai maala, gariba ta kaan Inon milere nil binanbile milungwa, ena ibal ungure Yon nil bile te milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kerodi Yon ole kanin sekungwa kaun, ena Yon iru ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yon gawlima kobe mile nomanin suna wai painama dire, gain bigin sungwa mere ka bolebilin di Yuda yal ta tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Di tongwa, ena Yon milungwa gul pire ka iru di yalini tongwa, “Arabayo, yal ta i bole Yodan nuule koliba kolibe milinga iray pirino? Yal ta milungwa mere iray, i pire dingiwe. Ena malia yalini nil bile ibal kobe tongure, ibal para yalini milungwa gul omua.” ");
INSERT INTO gvf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dungure yalini en dire iru dungwa, “God kalkan ere ibal ta tenamia, ena ibal i kal iru tawle aa te nenamua. ");
INSERT INTO gvf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na goma mile ka iru digire, ‘Na Kirisito ta milekiwa,’ diiba God na goma nusi eremua. ");
INSERT INTO gvf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yal ta abal inangwa we. Abal pi yal milungwa gul ongure, te yal i ye nongwa pire unin si mile wai pire, abal ingwa yal i, tomua. Tongwa mere na ama wai wen pire Yesu teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yalini kaan wi yebe pire para kuunin biinamba, na kaanan yaa ime sinangurawa,” dire Yon ka iru di wei sungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ena yal ta kamin ai mile ungwa iwe, yalini singaba mile ibal para yaa ime si tongwa. Ibal kule yongwa gariba ibal milemia, ena gariba kal main dungwa mere, kane ka di milungwa. Yal ta kamin ai mile ungwa, yalini yal singaba mile ibal para yaa ime si tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yal ta i kalkan kanere, te ka dungwa pirungwa mere di maribe erimba, yalini ka dungwa i, ibal kobe aa gi di pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yalini ka di maribe erungwa ibal kobe aa gi di piramia, ena God kawen dima di pire, pi tegi yenangwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God yalini nusi ime erere inin Iban kirara muru tomia, ena yalini God ka dungwa mere aine di milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Na Abe kamin mina milungwa, den miriin Wan tere kalkan para muru yalini ke milama dire, yobilaan bil pai tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ibal kobe pire gi di God Wan tenangwa, ena ibalin kobi mile painangwal painangwa. Te ibal kobe God Wan pire wiina ere tekenangwa, ena ibalin kobi mile paikinangure, God den gule te milangwal milangwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ena kamin kaun i Parasi kobe mile ka iru dungwa, “Yesu gawlima kobe maale sulu dungure, Yesu ibal binanbile nil bile tongure, Yon ibal tawle nil bile tomua,” dungwa. Dimba Yesu ibal wen ta nil bile tekungure, yalini gawliman kobe nil bile ibal kobe tongwa. Ena Parasi ka dungwa i Yesu pirere, Yudia gariba gul pisere ere Galili gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pirere ere Galili gariba gul nala dire, Sameria gariba gul suna ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pirere Sameria ogu ai ta kaan Saika, u bawa dungwa. Goma wen Yakobo gariba ta, wan Yosepe tongwa gariba i maala dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yesu kol tayan ongwa buul kune, goma Yakobo maul nil gere nongwa gul binan amin di milungwa. Milungure are kaya suna ongure, omale kaun dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ena Sameria abal ta nil kulala dire ungure, Yesu ka iru di abalini tongwa, “Nil taw nerala kule na to,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Dungwa kaun i Yesu gawlima kobe komina gibilin sirala dire, kaya ere ogu ai bil ta ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yesu ka iru dungure, ena Sameria abal mile ka iru di Yesu tongwa, “Na Sameria abal miliawa. I Yuda nen milinga, tameran i, ‘Nil kule na to’ dine?” Yuda ibal te Sameria ibal komina muine kiingwa taran ta nekungwa, ena abalini ka iru sirin bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tongure Yesu ka iru dungwa, “God kal wai ere i terala di pirimba, i main ta pirekire, te na mile, ‘Nil kule na to,’ dibingi na miliga mere i main ta ama pirekinwa. Diiba main sui iray piranga, te ‘I nil kule na to,’ di na tenanga, ena ibal mile painama dire nil ta i, kule i teralba.” ");
INSERT INTO gvf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dungure abalini ka iru dungwa, “Yalkuno, i nil kulanga mugu ta dikungure, te nil pi main wen ali ime milemia, ibal mile painama dire nil tai i kan dingiray, tamintan kule na tenane? ");
INSERT INTO gvf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Na sanamoi Yakobo nil i nongure, te yalini wan kobe nongure, te yalini awi bolima para nil i nomua. Goma wen Yakobo nongure, te malia na si aine ne milebinwa. ‘I nil kule na teralwa,’ dinga na sanamoi Yakobo i si ime erino?” ");
INSERT INTO gvf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dungure Yesu maan dire iru dungwa, “Ibal kobe maul nil i nenangwa, nil kwi gule kwi nenamua. ");
INSERT INTO gvf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dimba na nil kule teralga, nere kwi gulekenamua. Nil kule teralga, nere den miriin suna nil gibilin bilungwa mere dinangure, ena mile painangwal painamua.” ");
INSERT INTO gvf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dungure abalini ka iru dungwa, “Yalkuno, i nil kan dingiray kule na to. Neralga nil kwi ta gulekire, te abila nil kwi ta u kule nekeralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dungure ena Yesu ka iru di abalini tongwa, “I pi wininbi gala dire awli ya unana po.” ");
INSERT INTO gvf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dungure abalini mile, “Na winanbi ta milekemua,” dungure Yesu en, dire iru dungwa, “‘I wininbi ta milekemua,’ dinga, i kawen dinwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","I yal ta ire pisere, te yal ta ire pisere, ena i wininbi anan kole muru ire piserere, te malia i yal ta bole ki pai milinga, i wininbi ta milekemua. Ka di na tenga i, i kawen dinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dungure abalini ka iru di tongwa, “Yalkuno, i God ka kebe yal milinga, malia na i kaniwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na sanamoi gilekume kamin kuul ibe, ana dire deminin si God te milungwal milemua. Milimba, ‘Eringa paikimua,’ dire i Yuda nen mile, ‘Ibal kobe Yerusalem ana dire deminin si God tenanga paimua,’ dinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dungure Yesu ka iru di abalini tongwa, “Abalkuno, ka di i teralga, ‘Kawen dimua,’ dire pire gi do. Kamin kaun ta u maribe nangure, ibal kobe kamin kuul i, te Yerusalem para ana dire deminin si Abe God ta tekenamua. ");
INSERT INTO gvf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","I Sameria ibal kobe ana dire deminin si tenba, main ta pire pol sekinwa. Sekingire na Yuda ibal suna, ibal kobe aa ki di tenangwa yal, u maribe namia, ena main pire pol sire ana dire deminin si God tobinwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dimba, kamin kaun ta malia kawn kule erungure, ibal kobe kirara kawen ana dire deminin si Abe tenama dire, nomanin suna pire kirara kawen ana dire deminin si tenamua. Ibal kobe iru ana dire deminin si God tenangwa, Abe wai pire gun ye ibalin kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God mile aan gain yobilagi kulekire, iban kamin gwi mere milungwa, ena ibal kobe ana dire deminin si yalini terala dire, nomanin suna pire kirara kawen ana dire deminin si tenangwa paimua.” ");
INSERT INTO gvf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dungure abal i ka iru di Yesu tongwa, “God konagi erungwa yal Mesaya mile, yalini kaan ta Kirisito, unangwa pirebinwa. Unangwa kal para main di maribe ere na tenamua.” ");
INSERT INTO gvf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dungure Yesu ka iru dungwa, “I na bole ka di milebilgire, i yal ta kan dinga i, na yal iray miliwa.” ");
INSERT INTO gvf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Di milungwa kaun i, Yesu gawlima kobe ere urere Yesu abalini bole ka di milungwa kane buul kunungwa. Buul kunimba, “Takal irala di pirine?” ka iru di abal terala di pirimba, ka ta di tekungwa. Te “Tameran ka di abalini tene?” Ka iru di Yesu terala di pirimba, gawlima kobe para ka iru ta di tekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ena abal i nil kulungwa mugu i pisere kwi ere ogin ain pire ka iru di ibal kobe tongwa, ");
INSERT INTO gvf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Na kalkan para erebinga main iray, yal ta di maribe ere na tomia, ena yal i kanana wo. Yalini Kirisito milim mo?” ");
INSERT INTO gvf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dungure ena ibal kobe ogin ain milungwa pisere pi Yesu milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ena abal i ogin ain milungwa kaun gawl ima kobe kawan dire iru di Yesu tongwa, “Ka nil si tongwa yalo, i komina no mo.” ");
INSERT INTO gvf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dimba Yesu en, dire di bile dire iru dungwa, “Na neralga komina main ta dimba, i ta kane pol sikinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dimia ena gawlima kobe inin mile ka diria ere iru dungwa, “Yalini nenangwa komina ibal ta yuu tom mo?” ");
INSERT INTO gvf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dungure Yesu ka iru di gawlima kobe tongwa, “Na inan komina main iwe, na nusi ime erungwa yal ka dungwa mere wiina ere terere, te ‘Konagi ero,’ di na tongwa mere, ere wei siralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Dire Yesu ainere iru dungwa, “‘Komina yaalebingire, ba sui sui wei sinangure bulabinwa,’ dire i yal kobe kamin kaun iru di paale dinba, na ka iru di i teiwa. Ibal kobe umia, i kane koli ero. Baan araway suul milekenangure, ibalin kobe malia pire gi di na tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ibal kobe pire gi di na tenama dire, ka main konagi erungwa ibal tobe tobingire, inamua. Te pire gi di na tongwa ibalin kobi, mile painangwal painamua. Ka main milin sigilungwa ibal, te ka main konagi erungwa ibal para wai pire mile miriin painamua. ");
INSERT INTO gvf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iru ere paimia, ena i ibal kobe mile, ‘Yal ta komina yaalungure te yal ta bulemua,’ di tenga, malia kawen di tenwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ka main milin ta yaalekinga ai, na i nusi eriwa. Nusi eregire, ibal kobe pire gi di na tenama dire, i ka main konagi erina, ena ka main milin yaalungwa ibal kobe aa ki di i tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ena Sameria abal iray mile, “Na kalkan para eriga main iray, yalini di maribe eremua,” dungwa ena ogu ai iray Sameria ibal binanbile pire gi di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tomia ena Sameria ibalin kobi u Yesu milungwa gul u bawa dire, “Na bole para milo,” kawan dire di Yesu tongure, ena yalini are kaun sutan ibalin kobi bole para milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesu ka di ibal kobe tomia, ena ibal kobe binanbile ama pire gi di yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tere ka iru di abal iray tongwa, “Goma ka di na tenga pire gi di yalini tobinba, malia yalini inin ka di na ibal kobe na tongwa pire gi dire, te yalini gariba ibal aa ki di tongure, sigare kule u wai ongwa yal milungwa, na para kanebinwa,” dire iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ena are kaun sutan i wei sungure, Yesu ai i piserere pi Galili gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“Ka kebe yal inin garibanin pire yebe tekimba, gariba baan ta ibal pire yebe ere tongwa paamua,” dire Yesu inin ka iru dimia, ena ere Galili gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pirere u bawa dungure, Galili ibal kobe aa te wai ere yalini tongwa. Ibalin kobe komina bil nongwa, erin kaun kaan Pasoba, Yerusalem para pirere Yesu ain iray kalkan i maribe erungwa kanemia, ena aa te wai ere yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ena Yesu pi Galili gariba gul gariba ta kaan Kena kwi ongwa. Goma Yesu gariba i mile, nil wo kwi erungwa u wain nil kol ongwa, iru erungwa. Orom gabman yal singaba ta Kapanaum ain milungure, yalini wan nibil ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","“Yesu Yudia gariba gul pisere kwi ere Galili gariba gul umua,” dungure yal singaba iray pirere, yalini Yesu milungwa gul pire kawan dire iru dungwa, “Na wanan nibil bil ere gulala di pai milemia, ena i Kapanaum ure yalini aa te wai ere tenana wo.” ");
INSERT INTO gvf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Dungure Yesu ka iru di yalini tongwa, “Kal guman kwi dungwa erabingire, i ibal kobe buul kune kanana, ena pire gi dinanba, iru ta kanekinanga, ena pire gi ta dikinanwa.” ");
INSERT INTO gvf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dungure yal singaba en, dire iru dungwa, “Yalkuno, na wanan kaya gulala eremia, i kaya wei di ere ime wo.” ");
INSERT INTO gvf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dungure Yesu en dire iru di tongwa, “Ena i ere po. I wanin u wai namua.” Dire Yesu ka iru di tongwa, yalini nomanin si aa gi di pirere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pirere yalini kol baan pi paingure, yalini nil konagi ibal kol baan kanere, “I wanin kaya u wai omua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dungure yal singaba mile, “Genawna yalini kwi u wai ome?” sirin bile ibalin kobe tongure, ena ibalin kobe ka iru dungwa, “Erima omale kaun yalini gain gwi simua.” ");
INSERT INTO gvf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dungwa ena nen iru pirungwa, “Aya, Yesu mile, ‘I wanin u wai namua,’ dungwa kaun wen iray yalini kaya pilaan dimua.” Iru pire dimia ena yalini te enin kobe para pire gi di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu Yudia gariba gul pisere ere Galili gariba gul ongwa, kal guman kwi dungwa ta goma erere, te malia ta kwi ama erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ena kal iru ere wei sungure, Yuda ibal ka main erin kaun ta u maribe ongure, Yesu ere Yerusalem ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem ai suna kol nil benge digan ta milungwa. Nil benge iray bolima siipe siipe kana giran bere yongwa maala milungure, te nil benge binan ogu tabil anan kole muru dungwa. Yuda ibal inin ka dungwa, nil i kaan Beteseda yere galungwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Omilin gi dungwa ibal, te kawn ki sungwa ibal, te aan kawn kebil sungwa ibal, te ibal iru mile nibil erungwa binanbile milere, ogu tabil iray ala pai milungwa. Milere angel ta nil benge iray nil si ku tenama dire, suul mile kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Suul mile kanungwa iwe, God Singaba angel ta nil si ku tenangwa kaun, ena nibil erungwa yal ta goma gin taran nil ali namia, ena yal i nibil kaya wei sinangure, u wai nangwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Milungure yal ta alia mile, me erin yal ta aan kawn muru na anan kole kole muru kawnan kole muru kole sutakobe, nibil ere pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yalini baan araway nibil ere pai milungwa Yesu iru kanere, ena ka iru di tongwa, “I u wai nala di pirino?” ");
INSERT INTO gvf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dungure nibil erungwa yal iray en, dire iru dungwa, “Yalkuno, nil benge suna ali si du erungwa na kaniiba, na ibalan ta ure, na awli nil ali nangwa ibal ta milekemua. Na inan nil ali nala di obinba, yal ta goma nil ali ongwa kaya u wai omua.” ");
INSERT INTO gvf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dungure Yesu ka iru di yalini tongwa, “Ena i ale, bol kawi ire kol warana po.” ");
INSERT INTO gvf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dimia ena yal i gin taran u wai ongure, bol kawi ire kol ware ongwa. Aa te wai ere tongwa kaun i, Sare kaun dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Dimia ena Yuda ka main yal singaba kobe mile, u wai ongwa yal ka iru di tongwa, “Sare kaun i bol kawi ire enga, na ibal kobe kile kaman ka si keli sinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dungure yalini en dire iru dungwa, “Aa te wai ere na tongwa yal ‘Na bol kawi ire kol warana po,’ di na tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dungure yalin kobi ka iru sirin bile yalini tongwa, “‘I bol kawi ire kol warana po,’ di i tongwa, ibena di i tome?” ");
INSERT INTO gvf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dimba ibal binanbile milungure, Yesu kaya ere omia, ena u wai ongwa yal Yesu guman kanekun ta erekire, kaan di maribe erekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kaun tawle wei sungure, Yesu ka main ogu bil ala pire yalini kanere ka iru di tongwa, “I nibil eringa malia u wai enwa. I nibil bil erekirala dire, i kal digan ere taalime eringa pisero.” ");
INSERT INTO gvf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dungure yalini ere pire, “Yesu aa te wai ere na tomua,” di maribe ere Yuda ka main yal singaba tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ena ibal kobe nibil erungwa Yesu Sare kaun kaun aa te wai ere te milemia, ena Yuda yalin kobi kal nigi dongwa ere Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tomba Yesu en dire iru dungwa, “Na Abe konagi ere milemia, ena na para ere miliwa.” ");
INSERT INTO gvf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dungure ena Yuda yalin kobi iru di pirungwa, “Yalini Sare kaun kile kaman ka si keli sire, te yalini mile, ‘God na Abe milemua,’ dungwa God ke kuunin milia, di piremua.” Iru di piremia, ena Yuda yalin kobi Yesu si gulala di kawen pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ena Yesu ka iru di yalin kobe tongwa, “Na kawen dirala ena i piro. God Wan inin kalkan ta erekire, Nen kal erungwa mere kanere, iru tawle eremua. Nen kal erungwa mere, Wan para iru eremua. ");
INSERT INTO gvf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nen den miriin Wan tomia, ena Nen kal para erungwa mere di maribe ere Wan tomua. Malia na kal guman kwi dungwa erebinga mere iwe, tamama. Konagi bil painangwa erabina dire, di maribe ere Wan tenangure, i kane buul kunanwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Konagi bil iwe, ibal gulungwa Nen si kwi yomia, ale kwi milungwa mere Wan para iru ere, inin paale suna ere ingwa ibal kobe, tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te Nen inin mile ibal kobe ka kol ta pirekemua. Dimba, ‘Na Wanan ka kol para pirangwa paamua,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ibal kobe Nen kaan gale yebe erungwa mere, ibalin kobe Wan kaan gale yebe erama dire, Nen konagi iru ere Wan tomua. Ibal kobe Wan kaan gale yebe erekungwa, ena ibalin kobi Nen para kaan gale yebe erekimua. Nen Wan nusi eremia, ena ibalin kobe Nen para kaan gale yebe erekimua. ");
INSERT INTO gvf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na kawen di i terala piro. Ibal kobe na ka diga pirere, te na nusi ime erungwa yal pire gi di tenamia, ibalin kobi mile painangwal painamua. Eme God ka kol pai ibalin kobi ta tekenangure, ibalin kobi gulala di milimba, kaya u kwi pire mile paingwal paimua. ");
INSERT INTO gvf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na kawen di i terala piro. Kamin kaun ta malia kawn kule erungure, ena God ibal kobe si kwi ta yekungure, gulungwa mere milere God Wan ka dungwa aa gi di pirangwa, u kwi pire mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na Abe ta milekenangwa, inan ibal milebinga i, ama ta milekerabinwa. Yalini Wan na mile, yalini iru milungwa mere na para iru milama dire, yobilaan bile na tomua. ");
INSERT INTO gvf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na Abe Wan, Na U Ibal Obinga Yal na milia, ena ‘Na Wanan ka kol pirangwa paamua,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na ka diga i, i pire buul kunekio. Kamin kaun ta eme u maribe nangure, ena ibal kaya gulungwa yobilaan gul pai milungwa, na ka dibinga pirere, ");
INSERT INTO gvf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","te yobilaan gul pisere alamua. Ibal kobe kal wai erungwa alere mile painangwal painamua. Te ibal kobe kal ki erungwa alangure, God ‘Pirin paimua,’ di ibalin kobi tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na inan nomanin paangwa mere kalkan ta erekiga, God ka di na tongwa mere, ena na ka kol iru pire terabinwa. Na inan nomanin paangwa mere ka kol iru ta pire tekeralgire, te na nusi ime erungwa yal nomanin paangwa mere erala di erebina, ena ka kol pire tega kuunin paimua. ");
INSERT INTO gvf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na inan guunan kanan kere di maribe eralga, ena ka diralga i, ta paikinama di ibal iru piramua. ");
INSERT INTO gvf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Dimba yal ta mile na guunan kanan di maribe erungure, te yalini ka dungwa i kawen dima di kaniwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Goma i yal kobe taw nusi erere, ka kebe yongure, yalin kobi Yon milungwa gul ongure, Yon ka main kawen dungwa di maribe erungwa mere, i piringiwe. ");
INSERT INTO gvf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ibal taw na guunan kanan di maribe erungwa para paamba, ta na di maribe ere na tekenangwa ama para paimua. God u i aa ki dinangure sigare kule u wai nana dire, Yon ka dungwa mere na di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Kewa gale aw dungwa mere Yon iru milungure, ena yalini aw dungwa gul mile baan tawle wai pirinwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yon na guunan kanan di maribe erimba, na konagi eriga na Abe konagi ere na tongwa, na guunan kanan kirara di maribe erungure, te na Abe na nusi ime erungwa ibal para kanemua. ");
INSERT INTO gvf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Abe na nusi ime erungwa, yalini na guunan kanan di maribe eremua. Yalini ka dungwa i wen ta pirekire, te yalini guman i para wen ta kanekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","I ibal kobe iru milinga te God yal ta nusi ime erungwa i pire gi di yalini tekinga, ena God ka dungwa pire nomanin suna ta yekingiwe. ");
INSERT INTO gvf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Na mile pairabingal pairabina dire, God ka main minin ganin bilungwa, i morin morin kere pirinba. Ka main minin ganin iray na guunan kanan kere di maribe erungwa paamua. ");
INSERT INTO gvf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Paamba i mile painangal painanga, te na i kenin erabina di erebinba, i manaa di na tenwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ibal kobe deminin sire guun ye na tenama dire, konagi ta erekiwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Dimba i God den miriin tekinga na i kaniwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Abe unangwa mere yobilaan sirin bile na tongwa na ere ime ubinba, i aa te wai ere na tekenwa. Na tekinba yal ta inin yobilaan bile unangwa, ena i aa te wai ere yalini tenanwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","I ibal kobe deminin inin inin si ibeya erinba, God deminin si na tenama di pirekinwa. Di pirekinga, tamintan pire gi di God tenane? Ta tekenanwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na Abe milungwa gul na ka kol ere mile, na tenama di pirekio. Mose ka dungwa aa gi di pire wai milabina di pirinba, yalini ka kol ere i tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mose mile ka main minin ganin bilere, na guunan kanan di maribe erungwa, ena i pire gi di yalini tenanga meri, na ama pire gi di na tenanwa. ");
INSERT INTO gvf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dimba Mose ka minin ganin bilungwa pire gi ta dikinga, ena na ka diga tamintan pire gi di na tenane? Pire gi di na tekenanwa,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu iru dungure pare kwi sinaa dire nil benge bil kaan Galili, kaan ta Taibirias, sipe mina nala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yalini kal guman kwi dungwa erere, te ibal nibil erungwa pilaan pai tongwa, ena ibal binanbile u ku bile yalini duulin bile warungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu maa pi kamin kuul mege ta pirere, gawlima kobe bole amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","God goma Yuda ibal ta sekungure, ibal kobe nomanin si pirungwa erin kaun i, kaan Pasoba, u maala ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu kane yebe ere ibal binanbile yalini milungwa gul ungwa kanere iru di Pilipi tongwa, “Ibal kobe komina tobingire nenangwa, alde gibilin si terabine?” ");
INSERT INTO gvf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pilipi kal ta erangwa kanala dire, iru sirin bile tongwa. Tomba Yesu inin eme kal ta erangwa, inin kaya pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipi en dire iru dungwa, “Ibal para tawle tawle nenama dire, komina birete kobile moni kandret sutan gibilin sirabinba.” ");
INSERT INTO gvf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dungure yalini gawlima kobe ta Saimon Pita kebinbi kaan Endiru mile, ka iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gomege ta milungwaya komina birete anan kole muru te nil kabe sutan ye milemua. Milimba ibal para iru tawle nenamo? Tamama.” ");
INSERT INTO gvf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu mile, “‘Ibal kobe amin di milo,’ di to,” di gawlima kobe tongwa. Kul kwi yongwa koliba koli dungure, ibal para amin di milungure, yal kobe binanwenbile, tausen anan kole muru mere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu komina birete irere maki ye God tere, obin si ibal amin di milungwa tongwa. Nil kabe ama para iru erungure, ibal kobe inin nerala di pirungwa mere nongwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ibal para ne kubin maangure pare, Yesu ka iru di gawlima kobe tongwa, “Komina taw imo dungwa gana dire taw piserekerabinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dungure komina birete anan kole muru ibal nekungure, imo dungwa gana direre, gal anan kole kole muru kawnan milin sutan gule muulungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesu kal guman kwi dungwa kalkan naanin paangwa iray, i maribe erungwa ibal kobe kanere iru dungwa, “‘Ka kebe yal ta nusi gariba gul eralwa,’ dungwa kawen kirara umua.” ");
INSERT INTO gvf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yal bil ain pi milama dire ibal kobe Yesu aa gi dire, konagi iray terala di pirungure, ena Yesu inin pirere inin kamin kuul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena kamin girungure Yesu gawlima kobe pi nil benge binan pire ");
INSERT INTO gvf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","sipe ala pire, kwi Kapanaum ai nala di ongwa. Kamin kaya girungure pare, Yesu yalin kobe milungwa gul kaya ta ole ukungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ena kamin gwi bilkaw maangure, nil si pebil dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Gawlima kobe bili awlan bale nil mina waa kire dire taw tayan ongure, nil benge suna ongwa. Pirere Yesu nil bolimina ware sipe maala ungwa kanere, kalgane ire kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pirungure Yesu mile ka iru di tongwa, “Na inan miliga i kuril ta pirekio.” ");
INSERT INTO gvf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Direre sipe ala ongure, gawlima kobe wai wen pirungwa. Yesu sipe ali omia, ena yal kobi nala di ongwa gul kaya gin taran pi bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ena paangure kamin taangure, ibal binanbile nil benge binan koli imo mile paingwa. Mile paire sipe taranta u ongwa kanere, te Yesu gawlima kobe bole sipe ali pekungwa, para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Taibirias ibal kobe sipe taw imo pai dungwa. Yesu Singaba maki ye tongure, komina birete nongwa ain maala sipe imo pai dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ibal binanbile mile, “Yesu te gawlima kobe abila ta milekemua,” di piremia, ena sipe ala pire Yesu waa duurala dire ere Kapanaum ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pirere Yesu nil benge koli milungwa kanere ka iru di tongwa, “Nil si tongwa yalo, i genawna ereya une?” ");
INSERT INTO gvf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Di tongure Yesu en dire iru dungwa, “Na kawen dirala piro, i ibal kobe na waa duunga iwe. Na kal guman kwi dungwa erebingire, ibal kobe buul kune kanemia, na waa duukire i komina nere kubin maamia, ena na waa duunwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Komina ta bile yaanangwa nerala dire, konagi ta erekio. Dimba i mile painangal painanga komina nerala dire, konagi ero. God yobilaan sirin bile Na U Ibal Obinga Yal na tomia, ena komina iray i teralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dungure ibalin kobe ka iru sirin bile Yesu tongwa, “God konagi erabinga, ta konagi erabine?” ");
INSERT INTO gvf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Dungure Yesu en dire iru dungwa, “God yal ta nusi ime erungwa i pire gi di yalini tenanga, ena God konagi wen eranwa.” ");
INSERT INTO gvf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dimia ena ibalin kobe ka iru dungwa, “Kal guman kwi dungwa eringire, na ibal kobe kane buul kunabina, ena pire gi di i terabinga iwe, takal guman kwi dungwa erane? te ta konagi erane? ");
INSERT INTO gvf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘Yalini kamin mina mile komina tomua,’ dire ka main minin ganin bilungwa mere u maribe ongure, ena na ibal kobe sanamoi gariba simi yongwa mile komina ta kaan mana nomua.” ");
INSERT INTO gvf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dungure Yesu ka iru dungwa, “Na kawen dirala piro. Mose kamin ibe komina i ta tekungwi, na Abe mile kamin ai ibe komina kawo malia i te milemua. ");
INSERT INTO gvf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yal ta kamin mina mile, ure gariba ibal mile painangwal painama dire, si kwi ye tomua. God komina tongwa mere yal i iru mere milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dungure ibalin kobe ka iru dungwa, “Singabo, komina kan dinga i, i morin morin na ibal kobe na to.” ");
INSERT INTO gvf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Dungure Yesu ka iru di tongwa, “Ibal kobe mile painangwal painangwa na komina mere miliwa. Ibal kobe na aa gi di pire milamia, ena na ka main i para paima di piramua. Te ibal kobe pire gi di na te milamia, ena main ta paikungwa ama para pirala pirekenamua. ");
INSERT INTO gvf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ka iru dibinba, na kal eriga mere i kaninba, ‘Pire gi di na tekenanwa,’ goma di i tobingirawa. ");
INSERT INTO gvf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Na Abe ibal kobe na tenangwa, ibalin kobe para na aa gi di piramua. Ibal kobe na aa gi di pirangwa, ena na ibal wen ta pisere erekiralwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na inan nomanin paangwa mere ta erekire, na nusi ime erungwa yal nomanin paangwa mere erabina dire, na kamin mina pisere ere ime wiwa. Uga i ibal wen ta pisere erekiralwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","God ibal kobe na tongwa mere ibalin kobi iban u mena ta pekire, kamin gariba wei sinangwa kaun alama dire, na nusi ime erungwa yal na konagi niminin mile iru erama di piremua. ");
INSERT INTO gvf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ibal kobe God Wan pire pol sire, te pire gi di yalini tenangwa, ena ibalin kobi para mile painangwal painama dire, na Abe iru pire dimua. Pire dungure ena kamin te gariba wei sinangwa kaun ibalin kobi alama dire, na kal iru ere teralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu goma mile, “God kamin ibe mile komina te ime erungwa mere, na iru mere miliwa,” dire ka iru dimia, ena Yuda ibal kobe nigi de pire ka diria ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Milemia ena ibalin kobe ka iru dungwa, “Yal iray Yosepe wan Yesu milungure, yalini nen man para kanebina, yalini mile, ‘Kamin mina miliga pisere ere ime wiwa,’ dungwa, tameran ka iru dime? Ka dungwa ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dungure Yesu ka iru dungwa, “Nigi de pire na tere ka diria ere iru dikio. ");
INSERT INTO gvf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Na nusi ime erungwa yal, na Abe yalini mile ibal kobe nusi na milega gul erangure, ibalin kobi tawle na aa gi di piramua. Pirangure ena kamin te gariba wei sinangwa kaun, ibalin kobi alama dire, na kal iru ere teralwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ena goma ka kebe yal kobe mile, ‘God ibal para ka nil si tenamua,’ dire ka iru bile paalemua. Ibal kobe na Abe ka dungwa pirere, nil sire pire nomanin suna yenangwa, ena ibalin kobi para na aa gi di piramua. ");
INSERT INTO gvf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ka iru dibinba, ibal ta Abe God kanama di pirekio. Yal ta God milungwa gul mile ungwa, yalini taran tawle God kanemua. ");
INSERT INTO gvf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Na kawen dirala piro. Pire gi di na tongwa ibal, ibalin kobi mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ibal kobe mile painangwal painangwa main i, na komina mere miliwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I sanamoi gilekume simi yongwa ai mile, komina wai ta kaan mana dungwa ne mile mile ere gulemua. ");
INSERT INTO gvf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dimba kamin ibe komina te ime erungwa ibal kobe nenangwa, ta gulekinamua. ");
INSERT INTO gvf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","God kamin ibe mile ibal kobe mile painangwal painama dire, komina te ime erungwa mere na iru mere miliwa. Ibal kobe komina i nenangwa, ena mile painangwal painamua. Na komina ibalin kobi teralga, na inan miin teralwa. Gariba ibal kobe mile painangwal painama dire, teralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ena Yuda ibal kobe ka bolebilin dire diria ere iru dungwa, “Yalini inin miin na tenangure nerabinba, tamintan iru na ibal kobe tename?” ");
INSERT INTO gvf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dimia ena Yesu ka iru di ibalin kobi tongwa, “Na kawen dirala piro. Na U Ibal Obinga Yal miin te mayan ibal kobe ta nekenamia, ena mile painangwal painangwa main u maribe ta pekenamua. ");
INSERT INTO gvf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ibal kobe na miin te mayan nenamia, ena mile painangwal painamua. Mile paire kamin te gariba wei sinangwa kaun alama dire, na kal iru ere teralwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na miin i, komina kawen kirara dimua, te na mayan i, nil kawen kirara dimua. ");
INSERT INTO gvf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yal ta na miin te mayan nenamia, ena yalini bole pena gale si dawle na tenangure, te na bole pena gale si dawle yalini teralwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na Abe mile painangwal painangwa kobaan mile na nusi ime erungure, yalini milemia, ena na para miliwa. Iru milebilga mere ibal kobe na nenangure, ena na milia yalini para milamua. ");
INSERT INTO gvf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kamin ai ibe komina kan diga iwe, i sanamoi gilekume komina ne mile mile ere gulungwa, komina iray iru mere ta dikimua. Komina kan diga iray ibal kobe nenamia, ena mile painangwal painamua.” ");
INSERT INTO gvf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Dire Yesu Kapanaum ka main ogu ala mile ka iru nil si ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ka dungwa i gawlima kobe binanbile pirere ka iru dungwa, “Ka dungwa i pirebingire, ka nega di dungwa ibena pirame?” ");
INSERT INTO gvf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Dimba gawlima kobe nigi de pirungwa, Yesu inin nomanin si pirere ka iru di tongwa, “Ka diga i pirere ka main i munin kol erano? ");
INSERT INTO gvf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na U Ibal Obinga Yal kwi ere ainan kamin ai ibe nabingire, i kananga takal paama di pirane? I pire gogo eranwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ibal kobe mile painangwal painangwa, God Iban konagi paimua. Ibal inin nomanin si pire erangwa ta paikimua. Na ka diga i, God Iban ka dungwa mere dimia, ena pire gi dinanga, mile painangal painanwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dibinba i ibal taw pire gi di na tekenwa.” Ena ibal kobe pire gi di yalini tekenangure, te yal ta yalini bale taal sinangwa, Yesu ibalin kobi kaya piremia, ena ka iru di tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ena Yesu ainere iru dungwa, “Na i ibal kobe pire goma ka iru di i tegirawa. Ibal kobe na aa gi di pirala di piranga, na Abe ‘Para wai paimua,’ di tenangwa, ibal iru tawle na aa gi di piramua.” ");
INSERT INTO gvf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ena Yesu ka i di tomia, gawlima kobe binanbile mun kal waa tere duulin bile te pekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pekemia ena gawlima kobe anan kole kole muru kawnan milin sutan milungure, Yesu ka iru di tongwa, “I yal kobe para na pisere mun kal waa na terala di dino?” ");
INSERT INTO gvf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Dungure Saimon Pita ka iru dungwa, “Singabo, i piserabinga, ibena milungwa gul nabine? Ibal kobe mile painangwal painangwa main i ka dinga kawen di maribe erinwa. ");
INSERT INTO gvf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","God kabin sire wai wen milungwa yal, i yalini milinga malia na ibal kobe kane bawa dire pire gi di i tobinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dungure Yesu en dire ka iru dungwa, “I yal kobe anan kole kole muru kawnan milin sutan paale suna ere ibinba, yal ta i milinga i, suna milungwa Satan nil konagi yal milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Dire ka iru dungwa i, Saimon Isikerio wan Yudas kanin dungwa. Yudas mile Yesu gawlima kobe anan kole kole muru kawnan milin sutan milungure, te Yudas yalin kobi suna milimba, yalini eme Yesu bale taal sirala di pirangwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ena ka iru di pisere Yesu Galili gariba gul suna kobi wari ongwa. Yuda ibal singaba kobe Yesu si gulala di eremia, ena Yesu Yudia gariba gul kamin kaun i ta nala di pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yuda ibal erin kaun ta, komina bil nere are dine ogu ki pai milungwa kaun, i u maala omia, ");
INSERT INTO gvf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ena Yesu kebin kobe iru di yalini tongwa, “I kal guman kwi dungwa eringa gawlima kobe kanama dire, i baan iray pisere ere Yudia gariba gul po. ");
INSERT INTO gvf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yal ta guun kan warama di pirangwa, ena kalkan erungwa aal kule ta erekinamua. I kalkan eringa kirara kawen paamia, ena ibal para guman mina ero.” ");
INSERT INTO gvf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kebin kobi pire gi di yalini tekungwa, ena bawle tere ka iru di tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Di tongure Yesu ka iru di yalin kobi tongwa, “Na Yudia pire komina bil nerala di nabinga kaun u maala pekemua. I nala di piranga, para nanga paamua. ");
INSERT INTO gvf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gariba ibal kobe den gule i ta tekimua. Dimba ibalin kobi, ‘Kal ere main paangwa kal ki erinwa,’ di tere tere ere milebina, den gule na na tomua. ");
INSERT INTO gvf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","I Yudia pire komina bil i nenana po. Na nalga kaun u maala pekemia, ena na malia ta pekeralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Di tere Yesu Galili gariba gul mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu kebin kobe Yudia komina bil i nerala dire ongure pare, Yesu omba, aal kule ongwa mere yalini ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Komina bil nongwa ain Yuda ibal singaba kobe Yesu waa duure, “Yalini u milim mo, milekeme?” dire iru sirin bile kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ibal binanbile u ku bilere ka binanbile diria ere ibal taw mile, “Yalini yal wai milemua,” dungure te ibal taw mile, “O, o yalini ibal bawle tongwa yal milemua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dimba Yuda ibal singaba milungwa ibal kobe kuril pirere, ka mone mone di diria ere pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ena komina bil erin kaun i taw mili suna mugu sungure, ena Yesu Yuda ka main ogu bil ala pire ka nil si ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tongure Yuda ibal singaba pire buul kunere ka iru dungwa, “Yal iray sikul wen ta dikungwarawa, yalini tamintan main paangwa pire dime?” ");
INSERT INTO gvf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Dungure Yesu en dire iru dungwa, “Na inan nomanin paangwa mere nil si tekegi, na nusi ime erungwa yal di na tongwa mere pire nil si teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Na ka nil si tega, God ka dungwa mere na aine dibin mo, te na inan nomanin paangwa mere dibin mo? God mile yal ta kal iru erama di pirungwa mere, yal iray kal iru eramia, ena yalini piramua. ");
INSERT INTO gvf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yal ta inin nomanin paangwa mere erangwa, inin guun kan warama di piremua. Dimba nusi ime erungwa yal guun kan warama dire, nusi ime erungwa ungwa yal iru di pirangwa, ena yal i kawen dire kakiibi kobaan milekenama di ibal iru piramua. ");
INSERT INTO gvf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kile kaman ka Mose di i tomba, i wiina ere tekinwa. Tameran i ibal kobe na si gulala di erine?” ");
INSERT INTO gvf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dungure ibal kobe en dire iru dungwa, “Sia ta i den miriin suna milungurawa. Ibena i si gulama di pirine? Si gulangwa ibal ta milekemua.” ");
INSERT INTO gvf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Dungure Yesu en dire ka iru dungwa, “Na kal guman kwi dungwa ta eriga, ena i ibal kobe kane buul kuninwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose goma mile, ‘I wanin kobe gain puul bile ero,’ dire kile kaman ka iru dimba, yalini kal iru kawn kule ta erekungure, yalini sanamoi gilekume kawn kule kal iru eremua. Mose ka iru dungwa ena i yal kobe Sare kaun gomege gain puul bile erinwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mose kile kaman ka dungwa mere, si keli sekerala dire, ena i Sare kaun gomege gain puul bile eringiwe. Iru erina ena na Sare kaun, nibil erungwa yal kirara muru aa te wai eriga, tameran i yal kobe den gule na tene? ");
INSERT INTO gvf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kalkan erungwa i yal kobe imore kaninga, birun bale tekio. Tekinanba kalkan erungwa main pire pol sinanga, ena birun bale to.” ");
INSERT INTO gvf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ka iru dungure ena Yerusalem ibal taw mile ka iru dungwa, “Yal ta si gulala di ibal iru pirungwa, yalini yal iray milemiawa. ");
INSERT INTO gvf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Milimba yalini malge mile ka di ibal tongure, ibal wen ta ka di sutaw ere yalini ta tekemua. Yal singaba kobe yalini God konagi erungwa yal, Kirisito milema di, yal singaba kobe malia iru nomanin si piremo? ");
INSERT INTO gvf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dimba God konagi erungwa yal, Kirisito ere ime unangwa ain ibal ta pirekenamba, yalini pisere ungwa ain na ibal kobe kanebinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ena ibal kobe iru dungwa Yesu ka nil si te milere gala dire iru dungwa, “Na inan miliga mere, te na inan mile ere ime uga ain, i pire pol sino? Na inan nomanin paangwa mere ta ukiwa. Na nusi ime erungwa yal i, yalini kirara kawen milemua. I yal kobe yal i kane pol sekinba, ");
INSERT INTO gvf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","na yalini kane pol siwa. Na yalini milungwa gul piseregire, te yalini na nusi ime erungwa, ena yalini na kane pol siwa,” dire Yesu ka iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iru dimia ena ibal kobe Yesu kanin sirala di erimba, yalini gulangwa kaun ole u bawa dikungwa, ena ibal kobe yalini aan aa gi ta dekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Iru erala di pirimba, ibal binanbile pire gi di Yesu tere ka iru dungwa, “Yal i kal guman kwi dungwa erungwa mere, God konagi erungwa yal Kirisito unangwa, para iru eram mo, kal taw ama eram mo? Ta erekinamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ena Yesu milungwa mere u ku bilungwa ibal kobe ka diria iru ere milungwa Parasi kobe pirere, yalin kobe te Yuda ka main kenin erungwa yal bil kobe bole, Yesu si kanin sirala dire, simil nen taw nusi erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu ka iru dungwa, “Na kaun tawliga i ibal kobe bole milere, ena na nusi ime erungwa yal, yalini milungwa gul na ere nalwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","I na waa duunanba, na ta kanekinanwa. Na pi milalga ain i nala di piranba, i ta ukunana, ena na ta kanekinanwa.” ");
INSERT INTO gvf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dungure Yuda ibal yal singaba mile inin diria ere iru dungwa, “Yalini alde nangwa na ibal kobe ta kanekirabine? Yuda ibal kobe Giriki gariba gul suna ki paingwa gul iray, yalini pire Giriki ibal kobe ka nil si tenam mo? ");
INSERT INTO gvf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yalini mile, ‘I na waa duunanba, na ta kanekinanwa te na pi milalga ain i nala di piranba, ta ukunanwa,’ dire ka sutan i, di na ibal kobe tongwa i main tamintan paingwa pire dime?” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ena Yuda ibal erin kaun iray wei sinangwa kaun, kamin kaun i erin bilkaw milungure, Yesu ale milere gala dire iru dungwa, “Yal ta nil gulangwa, yal i na miliga gul ure nenana wo. ");
INSERT INTO gvf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ibal kobe pire gi di na tenamia, ena den miriin suna ali nil gibilin bilungwa mere, yalini kal wai ere ibal tere, u wai pire mile painangwal painamua. Ka main minin ganin iru bilungwa paimua.” ");
INSERT INTO gvf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ka iru dungwa ibal kobe pire gi di yalini tenamia, God Iban den miriin suna painama di tongwa. Kaun i Yesu ta gulekire, te ale kamin mina ain ole pekungwa ena God kaya inin Iban nusi ere tekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ena Yesu ka iru dungwa ibal kobe pirungure, ibal taw kobe ka iru dungwa, “‘Ka kebe yal ta unamua,’ dungwa i yalini yal iray kawen milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dungure ibal taw kobe mile, “God konagi erungwa yal, Kirisito milemua,” dimba, ibal taw kobe manaa dire iru dungwa, “Kirisito Galili gariba gul u maribe ta pekenamua. ");
INSERT INTO gvf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ta pekenangwa main iwe, ka main minin ganin bilungwa main iru paimua. Kirisito sanamoi gilekume Debiti milangure, te Debiti ki paingwa ai Betelekem kule nenamua.” ");
INSERT INTO gvf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dimia ena u ku bilungwa ibal suna pol sire u taminin sutan pire, guman inin inin dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ibal taw kobe Yesu kanin sirala di pirimba, ibal wen ta yalini aan aa gi dekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ena simil nen kobe kwi pi Yuda ibal kenin erungwa yal bil kobe, te Parasi kobe milungwa gul ongure, yalin kobe ka iru sirin bile simil nen kobe tongwa, “Tameran i yalini awli ukine?” ");
INSERT INTO gvf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dungure simil nen kobe en dire iru dungwa, “Yalini ka dungwa mere, goma ibal iru ta dikemua.” ");
INSERT INTO gvf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dungure Parasi kobe ka iru dungwa, “Aya, yalini ama para bawle i tomo? ");
INSERT INTO gvf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yal singaba ta mo na ibal Parasi ta, pire di gi yalini tongwa kanin mo, kanekine? Ta kanekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ibal binanbile u ku bilungwa i Yuda ibal kile kaman ka ta pirekemia, ena God den gule ibalin kobi tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dungure goma yal ta kaan Nikodimas pi Yesu milungwa gul pire bole ka di milungwa, yalini Parasi kobe suna milere ka iru di yalin kobi tongwa, ");
INSERT INTO gvf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Na yal kobe kile kaman ka main paangwa mere iwe, ‘Imore ka kol ere to,’ ta dikimua. ‘Yalini ka dinangwa pire, te kalkan erungwa main goma di maribe erangwa pire pol sire pare, ena ka kol ere to,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Dungure Parasi kobe imo mile ka iru di tongwa, “I ama Galili ibal para milino? I ka main minin ganin kere pire pol sinanga, ena ka kebe yal Galili gariba gul u maribe ta pekenama di piranwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ena ibal para u sutaw pire ere inin ogin omba, Yesu pi kamin kuul ta kaan Olibe kuul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Paire kwimile taanima wen Yesu kwi ere Yuda ka main ogu bil ala ongwa. Pire ibal binanbile Yesu milungwa gul ungwa, yalini amin di milere ka nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yuda ka main nil si tongwa yal kobe te Parasi kobe bole, abal ta awli suna erungwa. Abal i, yal ta kunibe i milungwa, ibal kobe kane i maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Abalini awli suna ere ka iru di Yesu tongwa, “Ka nil si tongwa yalo, abalini yal ta kunibe i milungwa ibal kobe kane i maribe eremua. ");
INSERT INTO gvf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na ibal kobe kile kaman ka suna Mose iru bilungwa, ‘Kobile kuba aa tere kal iru erangwa abal, i si gulo,’ dungwa paamua. Paamia ena i piringa, takal ere abalini tenama di pirine?” ");
INSERT INTO gvf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yesu kela kule bawle terala dire ka iru di tongwa, Yesu ka ta maan di tenangwa paikinamia, ka digwane waa terala di pirungwa. Di pirimba, Yesu kane main ere, aan nulaan pai gariba bolimina ka minin ganin bilungwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ibalin kobi ka sirin bile milungwa, Yesu alere ka iru di tongwa, “I ibal kobe suna ali yal ta kal digan ere taalime ta erekungwa, ena yal i, kobile kuba goma aa tere abalini so.” ");
INSERT INTO gvf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dire pare kwi kane main ere aan nulaan pai gariba bolimina ka minin ganin bilungwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yesu ka dungwa pirere, ena ibal taran taran di u mena kol pire, yal dimanin kobe goma ongure, te yal garamil eme ongwa. Ibal para muru ere ongure pare, Yesu inin milungure, te abalini ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu kane yebe ere ka iru di tongwa, “Abalkuno, ibal kobe u alde ome? I kal digan eringa, ‘Pirin paimua,’ di ibal ka ta iru di i tom mo, di i tekeme?” ");
INSERT INTO gvf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Dungure abalini mile, “Ka ta di na tekemua,” dungure ena Yesu ka iru di tongwa, “Na para pirin pai i tekiwa. I ere pire, eme kal digan ere taalime ta erekio.” ");
INSERT INTO gvf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ena Yesu ka kwi iru di ibal kobe tongwa, “Gariba ibal para nomanin naabilama dire, aw di ibalin kobe te miliwa. Ibal kobe na munan kol duulin bilangwa, ena ibalin kobi nomanin kama ta sekenangure, nomanin naabile aw dinamua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dungure Parasi kobe ka iru di tongwa, “Maliaga i inin guunin kanin di maribe erina, ena i ka dingai paikimua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dungure Yesu en dire ka iru dungwa, “Na inan guunan kanan di maribe eriiba, pisere ere ime uga ain te kwi ere yebe nalga ain para piria, ena na ka diga paimua. Ai sui iray, i yal kobe inin ta pirekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ibal nomanin paangwa mere i singaba mile ka kol paangwa obin si tenba, na singaba mile ka kol paangwa obin si ibal kobe tekiwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tekiiba singaba mile ka kol paangwa obin si terabinga paimua. Paangwa main iwe, na inan ta erekire, na nusi ime erungwa yal, na Abe, bole para mile ka kol paangwa obin si terabilga, ena paimua. ");
INSERT INTO gvf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","I ibal kobe kile kaman ka minin ganin iru bilungwa paangwa, ‘Kanungwa yal sutan ka dungwa u taran nangwa, ka dungwa i kawen dimua.’ ");
INSERT INTO gvf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na inan guunan kanan di maribe erigire, te na nusi ime erungwa yal, na Abe, na guunan kanan para di maribe eremua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dungure yalin kobe mile, “I nenin alde mileme?” dire ka sirin bile Yesu tongwa. Tongure Yesu en dire ka iru dungwa, “I na miliga mere pire pol sinanga, ena na Abe para pire pol sinanba, na te na Abe milebilga mere, i pire pol ta sekinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yuda ibal ka main ogu bil kobile moni tongwa ain, Yesu ali milere ka nil si tongwa. Yalini gulangwa kaun ole u bawa dikungwa, ena ibal kobe Yesu kanin ta sekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ena Yesu ka iru di yalin kobe tongwa, “Na ere baan ta nalga i na waa duunanba, i kal digan eringa pirin pai imo dinangwa, gulanwa. Iru mile gulingire, na nalga ain ta wekenanwa.” ");
INSERT INTO gvf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dimia ena Yuda ibal yal singaba kobe ka iru dungwa, “Yalini mile, ‘Na nalga ain i ta wekenanwa,’ di na tongwa yalini inin si gulama di dimo?” ");
INSERT INTO gvf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dungure yalini maan dire ka iru di tongwa, “I gariba maina ibal milinba, na kamin ibe ibal miliwa. Te gariba ibal kal ki ere milungwa i yal kobe kule yomba, na ta kule yekemua. ");
INSERT INTO gvf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iru paimia ena ‘I kal digan eringa pirin pai imo dinangwa, gulanwa,’ di i teiwa. Na iru iru milia diga mere pire gi di na tekenanga, ena i kal digan eringa pirin pai imo dinangwa gulanwa.” ");
INSERT INTO gvf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dungure yalin kobe mile, “I ibena miline?” dire sirin bile Yesu tongwa. Di tongure yalini en dire iru dungwa, “Na ka diga mere iru, na milegirawa. ");
INSERT INTO gvf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I yal kobe milinga ka binanbile di gawa dire, kawre di i teralba, na nusi ime erungwa yal kawen dungure, te yalini ka di na tongwa mere, iru tawle aine di gariba ibal kobe teralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dungure Yesu Abe God kan dungwa yalin kobe ta pire pol sekemia, ");
INSERT INTO gvf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ena Yesu ka iru di tongwa, “Na U Ibal Obinga Yal bili waa ki dinanga, ena na iru iru milia diga, i piranwa. Na inan nomanin paangwa mere ta erekia, na Abe ka nil si na tongwa mere, iru tawle di tega i para iru piranwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na nusi ime erungwa yal na bole milebilwa. Yalini gun ye na tenama di piriga mere eriga, ena yalini na pisere erekimua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu ka dungwa i, ibal kobe pirungure, ibal taw binanbile ibalin kobi suna milungwa pire gi di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yuda ibalin kobe pire gi di Yesu tomia, ena yalini ka iru di tongwa, “Na ka nil si tega i wiina ere tenanga, ena na gawlimanan kobe kawen kirara milanwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Milere na kirara kawen diga main piranga, ena Satan i kanin sungure, yalini nil konagi yal milinba, God kanin gule ere i tenangwa mere iru ere i tenamua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dungure ibal kobe ka iru maan di tongwa, “Ebarakam na ibal kobe sanamoi milemua. Goma te malia para, na nil konagi ibal kobe ta milekebinwa. ‘Kanin gule ere na teralwa,’ dinga, tameran ka iru dine?” ");
INSERT INTO gvf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dungure ena Yesu ka iru di ibalin kobe tongwa, “Na kawen dirala piro. Ibal kobe kal digan ere taalime ere milungwa, ibalin kobe Satan nil konagi ibal milemua. ");
INSERT INTO gvf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nil konagi ibal kobe iwe, ibalin kobi yal ta gawliman kobe morin morin ta milekemba, wan kobe morin morin gawliman milemua. ");
INSERT INTO gvf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ibal kobe kanin paangwa God Wan ibalin kobe gule ere tenamia, ena kirara gule ere ibalin kobe tenangure, wai wen mile wiige sire milamua. ");
INSERT INTO gvf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","I ibal kobe Ebarakam gawliman kobe milinga na piriiba, na si gulala di pirinwa. Na ka nil si i tega i pire nomanin suna ta yekinga, ena na si gulala di pirinwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na Abe di maribe ere na tongwa mere, na aine ka diiba, i nenin ka dungwa mere pire erinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Dungure ibalin kobe mile, “Na sanamoi gilekume Ebarakam milemua,” dimba Yesu ka iru di tongwa, “I Ebarakam gawliman kirara kawen milanga, ena yalini kal wai erungwa mere eranwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eranba God kawen di na tongwa mere di i tere iru tawle eriiba, i na si gulala di erinwa. I na si gulala dinga mere, Ebarakam iru ta erekimua. ");
INSERT INTO gvf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","I nenin kal erungwa mere erinwa,” dungwa. Dungure ibalin kobe en dire ka iru dungwa, “Yal ta pi abal ta kunibe ingure, gaan kule yongwa mere, na mina iru ta ire na kule yekemua. Na ibal kobe para na Abe taran God milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dungure ena Yesu ka iru di tongwa, “Na God bole milegire, yalini na nusi ime erungure, malia na miliwa. Na inan nomanin paangwa mere ta ukigi, yalini na nusi ime eremua. Iru paingwa God i ibal kobe nenin kirara kawen milamia, ena i den miriin na tenanba. ");
INSERT INTO gvf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Na ka dibinga, tameran main pire pol sekine? Na ka di i tega pirala pirekinga, main pire pol sikinwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","I ibal kobe i nenin Satan milemua. Yalini kal ki erala di pirungwa mere, i para erala di pirinwa. Kamin kaya wen yalini ibal si gulungwa yal mile, mili ongwa ongwa malia para iru milemua. Yalini kawen ta dekungwa, ena kalkan para kawen dungwa yalini i gibilin mui kol yomua. Yalini kakiibi dungwa kobaan milungwa, ena inin main paangwa mere kakiibi morin morin dimua. ");
INSERT INTO gvf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Iru paimia, ena na kawen di i teiba, i pire gi di na tekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na kal digan ere taalime ta eralga, ‘I pirin paimua,’ di na tenanba, na iru ta erekiga, i iru ta di na tekenanwa. Na kirara kawen di maribe ere i tega, tameran pire gi di na tekene? ");
INSERT INTO gvf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","God gaan kule yongwa, God ka dungwa yalin kobe pirekun eremua. Iru milimba, i yal kobe God kule yekungwa, yalini ka dungwa pirekun ta erekinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dungure Yuda ibal yal singaba kobe ka maan dire iru di Yesu tongwa, “‘I Sameria ibal mile sia ta denin miriin suna milemua,’ di i tobinga paimua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Dungure Yesu maan dire iru dungwa, “Sia ta na denan miranan suna ta milekemua. Na Abe aa te yebe erebinba, i na aa te yebe erekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na guunan kanan warama di pire ta di tekiwa. Tekiiba yal ta na guunan kanan di maribe ere i terere, kawen dim mo, kakiibi dim mo, yalini di maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na kawen di terala piro. Na ka main diga ibal wiina erangwa, ena wen ta gulekire mile painangwal painamua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dungure Yuda ibal yal singaba kobe ka iru di yalini tongwa, “Ebarakam gulungure, ka kebe yal kobe para gulimba, i ‘Na ka diga wiina erangwa, wen ta gulekinamua,’ dinga i sia ta denin miriin suna milungwa, malia kawen kanebinwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na sanamoi gilekume Ebarakam gulungwa i yalini si ime erino? Te ka kebe yal kobe para gulungwa we, tameran i gain mina aa tene? I yal singaba bil wen milino?” ");
INSERT INTO gvf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dungure Yesu di tongwa, “Na inan kaanan gale yebe eralga, kuunin ta paikinamua. ‘Na Abe, God milemua,’ dinga yalini na Abe milemia, na kaanan gale yebe ere na tomua. ");
INSERT INTO gvf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","God milungwa main i yal kobe ta pirekun erekinba, na yalini pirekun eriwa. ‘Na yalini ta pirekun erekiwa,’ diralga i kakiibi dinga mere diralwa. Diralba yalini na pirekun ere yalini ka dungwa mere wiina eriwa. ");
INSERT INTO gvf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I yal kobe sanamoi gilekume Ebarakam, na gariba gul uralga kaun na kanala di pirere, ena na kane pisere wai wen pire milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dungure Yuda ibal yal singaba kobe ka iru di yalini tongwa, “I me erin yal su aan kawn muru na anan kole kole muru, pipti, ta ole milekinga, Ebarakam kaya kanino? Tamama.” ");
INSERT INTO gvf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dungure Yesu ka iru dungwa, “Na kawen di terala piro. Ebarakam ta ole kule yekungwa kaun na miliwa.” ");
INSERT INTO gvf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iru dungwa ibal kobe kobile kuba aa tere irere, yalini sirala di pirimba, Yesu aal kule pire Yuda ka main ogu bil malge ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ena yal ta man den miriin suna omilin gi dungure, kule nongure malia ama gi di imo dungwa. Yesu pi kol baan ta pire yal iray kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kanungure Yesu gawlima kobe ka iru sirin bilungwa, “Ka nil si tongwa yalo, yalini nen man kal digan ere taalime erungwa man paam mo, yalini inin kal digan ere taalime erungwa man paam mo, i ibena erima di pirine?” ");
INSERT INTO gvf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Dungure Yesu ka iru dungwa, “Yalini mo te nen man kal digan ere taalime erungwa, omilin gi ta dikimua. God yobilaan bile niminin mile yalini tenangure, ibal kanama dire, yalini omilin gi di dimua. ");
INSERT INTO gvf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na nusi ime erungwa yal konagi ere na ibal kobe tongwa, kamin kaun malia u bawa dungure, na ibal kobe ere milabinwa. Kamin kaun ta u maribe nangwa ibal kobe konagi ta erala di piramba, ta erekinamua. ");
INSERT INTO gvf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na gariba gul mile paiga ibal para nomanin naabilama dire, aw di ibalin kobe te miliwa.” ");
INSERT INTO gvf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Dire pare Yesu gariba mina ebil si bile aa kiraa erere, gariba ire omilin gi dungwa yal omilin mina aa dagi si tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Si tere ka iru di tongwa, “I nil benge ta kaan Siloam pire, nil painana po.” (Nil benge iray kaan Golin ka iru paangwa, Nusi Erungwa Nil) Yesu ka di tongure yalini ere pire nil paingure, ena omilin pilaa dungwa. Dungure kwi ere ungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Omilin gi dungwa yal goma komina kaan di milungure, ibal kobe kanere, kanungwa ibalin kobi te yalini enin kobe para ka iru inin inin diria ere iru dungwa, “Yal ta amin di mile komina kaan di milungwa yal iray, yalini milim mo?” ");
INSERT INTO gvf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ena ibal taw mile, “Yalini yal iray milemua,” dimba ibal taw ka iru dungwa, “O, o yalini yal iray guman mere kulimba, ta milekemua.” Ka iru dimia, ena yalini mile, “Na yal iray miliwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dungure ibal kobe ka iru sirin bile tongwa, “Goma i omilin gi dimba, malia pilaa dungwa kaninga, tamintan u wai ome?” ");
INSERT INTO gvf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dungure yalini ka iru dungwa, “Yal ta kaan Yesu gariba mina ebil si bile aa kiraa erere, gariba ire na omilan mina aa dagi si na tere, ‘I nil benge ta kaan Siloam pire, nil painana po,’ di na tongure, na pire nil paigire, ena omilan pilaa dungwa kaniwa.” ");
INSERT INTO gvf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dungure ibal kobe mile, “Yalini alde mileme?” sirin bile tongure, yalini mile, “Na ta kanekiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dungure pare goma omilin gi dungwa yal, ibal kobe yalini awli pi Parasi kobe milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu gariba mina ebil si bile aa kiraa erungwa, te omilin gi dungwa yal aa pilaa di tongwa kaun iray, Sare kaun dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ena Parasi kobe mile, “I omilin pilaa dungwa kaninga, tamintan u wai ome?” sirin bile tongure, yalini ka iru di tongwa, “Gariba kul tongwa na omilan mina aa dagi si tongure, na nil paigire, ena na omilan pilaa dungwa malia kaniwa.” ");
INSERT INTO gvf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dungure Parasi taw ka iru dungwa, “Yal iray kal iru erimba, Sare kaun kile kaman ka dungwa wiina ere tekemia, ena God yalini ta nusi ime erekimua.” Dimba Parasi taw mile ka iru dungwa, “Kal guman kwi dungwa erungwa mere iwe. Kal digan ere taalime erungwa yal kal iru ta erangwa painamo? Ta paikinamua.” Dungure yalin kobe suna pol sire u taminin sutan pire guman inin inin dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dimia ena Parasi kobe ka kwi sirin bile yalini tongwa, “Yalini i omilin aa te wai erungwa pilaa di kaninga, yalini ibena milema di pirine?” Dungure yalini mile, “Ka kebe yal milemua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dimba yalini goma omilin gi dungure, omilin pilaa di kanungwa Yuda ibal yal singaba kobe pirala pirekemia, ena omilin gi dungwa yal iray nen man ‘Wo,’ di gala dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ungure ka iru sirin bile tongwa, “Yalini i wanin milimo? I kule yenga, ‘Omilin gi dimua,’ dino? Te omilin pilaa di kanungwa, tamintan main paama di pirine?” ");
INSERT INTO gvf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dungure yalini nen man ka iru dungwa, “Na yasu yalini kule yobilga omilin gi dungwa milimba, ");
INSERT INTO gvf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","malia yalini omilin pilaa di kanungwa, te yal ta aa te wai ere yalini tongwa, na yasu main i ta pire pol sekebinwa. Yalini kaya ibal milemia, inin ka di maribe ere i tenamia, ena i yalini sirin bile piro.” ");
INSERT INTO gvf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yalini nen man Yuda ibal yal singaba kobe kuril pire tomia, ena ka iru di tongwa. Yuda ibal yal singaba kobe ka iru di paalungwa, “Yal ta Yesu milema di pire, ‘God konagi erungwa yal Kirisito milemua,’ dinangwa, ‘Yuda ka main ogu para pi mena milamua,’ di terabinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Dimia ena yalini nen man mile, “Yalini kaya ibal milemia, i yalini sirin bile piro,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dungure ena Parasi kobe goma omilin gi dungwa yal, “Kwi ere wo,” di gala dungure, ungure ka iru di tongwa, “God milemia, i maabinin mina sire kirara kawen dinanga di na to. Yal iray kal digan ere taalime erungwa yal milungwa kanebinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dungure ka maan dire iru di tongwa, “Yalini kal digan ere taalime erungwa yal milim mo, na ta pirekebinba, na goma omilan gi dungure malia na omilan pilaa dungwa kanega piriwa.” ");
INSERT INTO gvf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dungure yalin kobe ka iru sirin bile tongwa, “Yalini takal ere i tome? I omilin gi dungwa, tamintan kwi aa te pilaa di i tome?” ");
INSERT INTO gvf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dungure yalini en dire ka iru dungwa, “Na kaya di i tobinba, i pirala pirekinwa. Tameran i yalin kobe, ‘Kwi piralwa,’ dine? I yal kobe u yalini gawliman milala di pire dino?” ");
INSERT INTO gvf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dungure ena yalini kobe gain ka si tere iru dungwa, “I yalini gawliman milinba, na yal kobe Mose gawliman milebinwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God ka di Mose tongwa pirebinba, yal ta yalini nusi ime erungwa, na ibal kobe ta pirekebinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dungure yalini ka di kole ere iru dungwa, “Ayo, yal ta yalini nusi ime erungwa yal i ta pirekinba, na omilan gi dungwa yalini aa te pilaa di na tomua. I ka dinga i, na pire buul kuniwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ibal kobe kal digan ere taalime ere milungwa, yalin kobi ana di God tomba ta pirekemua. Pirekimba ibal kobe deminin sire God gun ye tere, te yalini ka dungwa pire wiina ere tenangwa, ena yalin kobi ana di God tenangwa piramua. ");
INSERT INTO gvf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yal ta man kule nongwa omilin gi dungwa, kwi aa te pilaa di tongwa iwe, kamin kaya wen te malia para, iru ta erekungwa pirebinwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God yalini nusi ta erekenangwa, yalini kal iru erungwa ta erekinangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dungure yalin kobe ka di kole ere iru dungwa, “I nenin manin kal digan ere taalime erungwa i kule yongure, i omilin gi dungwa milinga iwe, i iru mile ka nil si na yal kobe terala di pirino?” Dire pare Yuda ka main ogu kirara pi mena mile painama dire, yalini aa nusi mena erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ena aa nusi mena erungwa Yesu pirere, waa duure kanere ka iru di tongwa, “U Ibal Ongwa Yal pire gi di teno?” ");
INSERT INTO gvf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dungure yalini ka di kole ere tere iru dungwa, “Yalkuno, yalini pire gi di teralba, yalini main painangwa mere i di na to.” ");
INSERT INTO gvf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Dungure Yesu ka iru di tongwa, “I kaya kaninwa. Te maliaga i bole ka di milinga, yalini milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dungure yalini mile, “Singabo, na pire gi di i teiwa,” di tere, ana di deminin si Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Si tongure Yesu mile iru dungwa, “Ibal kobe kal erungwa pirin painam mo, paikinam mo, kal iru i maribe erala dire, gariba gul ime wiwa. Ibal kobe omilin gi dungwa kanama dire, te ibal kobe omilin wai dungwa kwi gi dinama dire, para ime wiwa.” ");
INSERT INTO gvf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parasi kobe taw Yesu bole milere Yesu ka iru dungwai pirere, ka iru sirin bile tongwa, “Na yal kobe para omilan gi dungwa milebingire, i ka iru dino?” ");
INSERT INTO gvf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dungure Yesu ka iru di yalin kobe tongwa, “Omilin gi dungwa mere main ta pirekire ere milanga, ena i pirin ta paikinamba, i yal kobe mile, ‘Na pirebinwa,’ dinga, ena i kal digan eringa pirin pai imo dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ena Yesu ka iru dungwa, “Na kawen dirala piro. Yal ta bolima siipe siipe gul suna nala di omba, kana giran kol suna ta pekire gul baan maare pi suna nangwa, ena yal iray komina kunibe nongwa yal milemua. ");
INSERT INTO gvf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yal ta kana giran suna kol nangwa, yalini bolima siipe siipe kenin erungwa yal milamua. ");
INSERT INTO gvf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kana giran kol yawle kenin erungwa yal kol yawle, bolima siipe siipe kenin erungwa yal tenangure, yalini bolima siipe siipe inin inin kaan galangwa ge dinangure, awli mena namua. ");
INSERT INTO gvf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Awli mena pire pare yalini goma nangure, ena yalini ka dinangwa naan pire, bolima siipe siipe mun kol duulin bile namua. ");
INSERT INTO gvf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ibal ta ama bolima siipe siipe ta duulin bile pekenangwi, ka dinangwa naan ta pirekire si ere namua.” ");
INSERT INTO gvf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Dire Yesu ka di bile dungwa i, di ibal kobe tomba, ibalin kobi main ta pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ta pirekemia ena Yesu ka kwi ainere iru dungwa, “Na kawen dirala piro. Bolima siipe siipe ere ala nama dire, kana giran mere na miliwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ibal kobe goma u mile kakiibi dungwa, komina kunibe nongwa ibal kobe milemua. Milimba ibal kobe bolima siipe siipe mere milungwa, komina kunibe nongwa ibal kobe ka dungwa ta pirekemua. ");
INSERT INTO gvf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na inan kana giran miliwa. Yal ta na miliga gul ure ere ala kol nangwa, ena God yalini aa ki dinangure sigare kule u wai namua. U wai pire, mena te ala kol para komina ne mile dime di milamua. ");
INSERT INTO gvf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kalkan kunibe nere si gule si kiranin bilama dire, komina kunibe nongwa yal umua. Ibal kobe wai dorimil mile painama dire, na wiwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Na bolima siipe siipe kenin wai eriga yal, na miliwa. Bolima siipe siipe kwi wai milama dire, bolima siipe siipe kenin wai erungwa yal gulala di piremua. ");
INSERT INTO gvf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yal kobe tobe konagi erere kenin erungwa yal ta milekire, te bolima siipe siipe kobaan ama ta milekenangwa, ena awi biin eli paangwa unangwa, tobe konagi erungwa ibal bolima siipe siipe pisere si namua. Nangure awi biin eli paangwa bolima siipe siipe si kiranin bilangure, si u sutaw namua. ");
INSERT INTO gvf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tobe konagi erungwa yal kobe bolima siipe siipe kenin wai ta erekimia, si namua. ");
INSERT INTO gvf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Na bolima siipe siipe kenin wai eriga yal, na miliwa. Na miliga mere na Abe pirekun erungure, te na Abe milungwa mere na para pirekun eriwa. Iru pirekun erega mere, na bolima siipe siipe pirekun eregire, te yalin kobe na para pirekun ere na tomua. Yalin kobe wai wen milama dire, na gulala di piriwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na bolima siipe siipe kobe taminin taw milungwa gul taran suna ta milekemua. Na yalin kobe para awli uralgire, na ka diga wiina eramua. Erangure bolima siipe siipe taminin taran wen milangure, te bolima siipe siipe kenin erangwa yal taran wen mile kenin eramua. ");
INSERT INTO gvf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ibal na si gulala dungure, ‘Na para paimua,’ diga ena na Abe den miriin na tomua. Na kwi alala digire, na si gulamua. ");
INSERT INTO gvf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ibal na si gulala di pirimba, na gulalga kaun u maala pekungwa gulala pirekia, ena ibal na si gulekenangwa paamua. Na si gulekenangwa paamba, na gulala di piriwa. Na gulere kwi alalga, na inan yobilaan bile kwi alalwa. Iru eralga na Abe yobilaan bile na tere, kiranan aa tere di na tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu ka iru dimia, ena Yuda ibal yal singaba kobe suna pol sire, u taminin sutan pire guman inin inin dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dungure ibal taw binanbile ka iru dungwa, “Yalini sia den miriin suna milungure, yal du dungwa milemua. Milemia, tameran ka dungwa pirine?” ");
INSERT INTO gvf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dimba ibal taw ka iru dungwa, “Yal ta sia den miriin suna milemia, ka dungwa mere ta dekinamua. Sia ta milungwa omilin gi dungwa kwi aa te pilaa di tenamo? Ta di tekenamua.” ");
INSERT INTO gvf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ena Yuda ibal ka main ogu bil goma kwi aa te wai erungwa, malia nomanin si pire erin kaun u bawa dungure, komina bil nerala di erungwa. Kamin kaun i kamin gwi bil maangwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Maangure Yesu ka main ogu bil milere, kuul ale kaan Solomon Ai pi suna kol ware ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ongure Yuda ibal yal singaba kobe ure Yesu yobile suna ere ka iru di tongwa, “I genawna ka di maribe ere na yal kobe tenane? Malia kawen kirara di maribe ere na yal kobe to. I God konagi erungwa yal, Kirisito, milin mo milekine?” ");
INSERT INTO gvf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dungure Yesu ka di kole ere tere iru dungwa, “Na ka di i tobinba, i na ka diga pire gi dikinwa. Na Abe yobilaan bile na tongure, kalkan konagi erebinga na guunan kanan di maribe erimba, ");
INSERT INTO gvf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","i na ibalan kobe ta milekinga, ena pire gi di na tekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bolima siipe siipe kobaan ka dungwa naan pirungwa mere, na ibalan kobe ka diga naanan pirungure, na ibalan kobe pirekun eria na munan kol duulin bile umua. ");
INSERT INTO gvf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na ibalan kobe mile painangwal painama dire, kal iru ere teralwa. Teralga wen ta gulekinangure, te na ibalan kobe kenin ere miliga, ibal taw kobe ure sire i sutaw ta erekinamua. ");
INSERT INTO gvf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na kenin ere milala dire, na Abe na ibalan kobe na tomua. Tere yalini yobilaan wen bile milungure, yalini ke kuunin ibal ta milekemua. Na Abe ibalin kobe kenin ere milungwa ibal kobe sire i sutaw erala di piramba, i sutaw erekinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na Abe te na bole yal taran milebilwa.” ");
INSERT INTO gvf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dungure ena Yuda ibal yal singaba kobe, kobile kuba aa tere Yesu sirala dire pi kobile aa tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu ka iru di yalin kobe tongwa, “Na Abe yobilaan bile na tongwa kal wai dungwa binanbile erega iwe. Takal konagi eriga nomanin si pire, kobile kuba aa tere na sirala di erine?” ");
INSERT INTO gvf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dungure Yuda ibal yal singaba kobe ka di kole ere iru dungwa, “I konagi wai eringa kobile kuba aa tere ta i sekerabinba, i ibal tawle mile, ‘Na God mere miliwa,’ dire gain ka si God tenga, ena kobile kuba aa tere i sirabina di erebinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dungure Yesu ka iru di yalin kobe tongwa, “Kile kaman ka bile paalungwa suna God iru dungwa paangwa, ‘I ibal kobe god mere milinwa.’ ");
INSERT INTO gvf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ka main minin ganin bilungwa mere yaa main ta sekenamua. God ka kebe yal nusi erungwa yalini, ‘Yalin kobe god mere milinwa,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dungwa ena na iwe, na Abe na paale suna ere irere na nusi gariba gul ime erungure, na mile, ‘God Wan miliwa,’ dibina ena tameran, ‘God gain ka si tenwa,’ di na tene? ");
INSERT INTO gvf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na Abe konagi ta erekiga, ena i ibal kobe na ka diga kawen dima di pirekio. ");
INSERT INTO gvf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Di pirekenanba na Abe konagi eriga, ena konagi eriga i, kawen dima di piro. Ka diga kawen dima di pirekenanba, na Abe te na bole yal taran milema di pire milana dire na konagi eriga kawen dima di piro.” ");
INSERT INTO gvf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ena ibal kobe Yesu kwi kanin sirala di erimba, yalini kaya aal kule ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ena Yesu Yodan nuule baure ere kole pire, goma Yon nil bile ibal tongwa ain pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Milungure ibal binanbile yalini milungwa gul ure ka dungwa pirere iru dungwa, “Yon kal guman kwi dungwa ta erekimba, Yesu milungwa mere, Yon ka dungwa kirara kawen dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ibal binanbile kolia milere pire gi di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ena yal ta kaan Alasaras nibil ere paangwa. Yalini Betani ai ki pai milungure, abal sui Mata te kebin Maria ogu ain i para ki pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Abal Maria iray eri niriin minanin wai sungwa garu di Singaba Yesu kawn mina bilere, gibiliigin aa gi dire kawn mina kul tongwa kire di erungwa. Abalini alenbi Alasaras nibil ere paangwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Abal kebin abin sui ibal ta nusi Yesu milungwa ere, “Iru di to,” di tongwa, “Singabo, i ye nenga yal iray, nibil ere paimua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ka dungwa i Yesu pirere ka iru dungwa, “Yalini nibil ere milimba, Alasaras u kwi namua. Ibal kobe God kaan gale deminin si tenama dire, te God Wan para kaan gale deminin si tenama dire, nibil ta i u maribe pi tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ena Mata te kebin te alenbi Alasaras milungure, Yesu ibalin sutakobe i den miriin tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","“Alasaras nibil ere milemua,” dungwa Yesu pirimba, milungwa ain are kaun sutan pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Milere pare ka iru di gawlima kobe tongwa, “Na yal kobe kwi ere Yudia gariba gul nabina wo.” ");
INSERT INTO gvf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dungure gawlima kobe ka di kole ere iru dungwa, “Ka nil si tongwa yalo, malia Yuda ibal yal singaba kobe kobile kuba aa tere i sirala di erungwa, ain iray i kwi, ‘Nabina wo,’ dino?” ");
INSERT INTO gvf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Dungure Yesu ka iru dungwa, “Are kaun ta muru are de dimia, ena omale kol warangwa gawl ta sekenamua. Gariba gul aw dinangwa, kanere gawl ta sekenamua. ");
INSERT INTO gvf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ta sekenamba gilaa kaun kol warangwa, ena gilaa bongi siribe yaare aw ta dikungure, ena gawl sinamua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Dire ka kwi ainere iru dungwa, “Na ye nobinga Alasaras imore ul pai milimba, na pi ulin yuuralga, ena yalini kwi alamua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dungure gawlima kobe ka di kole ere iru dungwa, “Singabo, yalini imore ul pai milangwa, ena yalini para wai milamua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Dimba Alasaras kawen gulungwa Yesu ka iru di bile dungwi, “Alasaras imore ul paimua,” Yesu ka iru dima di gawlima kobe iru pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iru piremia ena Yesu ka di maribe ere iru dungwa, “Alasaras kaya gulimba, ");
INSERT INTO gvf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","i yal kobe pire gi di na tenana dire, na kaya pi yalini milungwa gul ta ole pekiwa. Iru painangwa na wai pire miranan paiwa. Ena yalini yongwa gul nabina wo.” ");
INSERT INTO gvf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dungure yal ta Tomas, gawliman yal ta milere kaan kiibe, Pual Gaan, milere ka iru di gawlima imo milungwa tongwa, “Na yal kobe yalini bole para gulabina dire, nabina wo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ena Alasaras kaya maul si yongwa, are kaun sui sui wei sungure, Yesu pi bawa dire kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ai Yerusalem taw maala, kilomita sutakobe, dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Dimia ena Yuda ibal singaba kobe binanbile pi Mata te Maria milungwa gul ungwa, alenbi gulungwa kay mi terala dire ungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","“Yesu umua,” ibal dungwa Mata pirere, pi kol baan kanala dire omba, Maria ogu ala mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata pi Yesu kanere ka iru di tongwa, “Singabo, i abila milanga, na alanbi gulungwa ta gulekinamba. ");
INSERT INTO gvf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kalkan iru u maribe omba, i ‘Kalkan na to,’ di ana di God tenanga, ena malia para ere i tenamua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dungure Yesu mile, “I alenbi gulungwa kwi alamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Dungure abalini ka di kole ere iru dungwa, “Eme kamin te gariba wei sinangwa kaun ibal para alangwa, yalini para alama di piriwa.” ");
INSERT INTO gvf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dungure Yesu ka iru di abalini tongwa, “Ibal gulungwa alama dire, kal iru eralga yal, na miliwa. Te ibal mile painangwal painama dire, na miliwa. Ibal kobe pire gi di na tenamia, ena ibalin kobi gulamba, ale kwi milamua. ");
INSERT INTO gvf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Te ibal kobe kwi milere pire gi di na tenamia, ena ibalin kobi ta gulekire mile painangwal painamua. Ka diga i, i pire gi dino?” ");
INSERT INTO gvf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dungure abalini owa dire ka iru di tongwa, “Singabo, God Wan Kirisito nusi gariba gul ime erungwa, i yal iray milina di pire na pire gi di i teiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Dire pare Mata kwi pi ogin pire mone di aal kule di Maria tere iru dungwa, “Ka nil si tongwa yal ure i, ‘Wo,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Dungwa Maria pirere alere, Yesu kol baan kanala dire, mugu dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu kaya ole malge pikimia, Mata kol baan kanungwa yalini imo mile paingwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yuda ibal singaba kobe kay mi Maria te milungwa, ibal kobe Maria ale ongure duulin bile ongwa. Yobilaan gul pi kay mi nama di pire, duulin bile ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ena Maria pi Yesu milungwa gul u bawa dire Yesu kawn mina yaa gobin bile milere, ka iru di tongwa, “Singabo, i abila milanga, na alanbi gulungwa ta gulekinamba.” ");
INSERT INTO gvf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Abalini kay miingure, te Yuda ibal singaba kobe bole ungwa kay para miingwa, Yesu kanere miriin wen pire tere pire gogo ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Milere, “Yalini yenga, i alde yene?” sirin bile tongure, ibal kobe mile, “Singabo, i kanana wo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dungure ena Yesu simel kay miingwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Simel kay miimia, ena Yuda ibal singaba taw ka iru dungwa, “Yalini kirara den miriin tongwa kano.” ");
INSERT INTO gvf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dimba yalin kobe taw mile ka iru dungwa, “Omilin gi dungwa aa pilaa di tere erungwa iwe, tameran Alasaras ta gulekenama dire, aa te wai ere tekeme?” ");
INSERT INTO gvf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ena Yesu kwi miriin wen pire tere pi yene yobilaan gul ongwa. Yene yobilaan gul i kobile giran dimba, kobile milin ta kobile giran si pere dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ka iru dungwa, “Kobile milin kana giran si pere dinga, i mena ero.” Dungure gulungwa yal alenbi Mata, ka di kole ere iru dungwa, “Singabo, i ka dinba, kamin kaya kine yalini kobile giran ali yobinga, ena daalin simua.” ");
INSERT INTO gvf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dungure Yesu ka iru di abalini tongwa, “‘I pire gi di na tenanga, ena God kamin mina naabile aw dungwa mere kananwa,’ na di i tekebino? Di i tobingirawa.” ");
INSERT INTO gvf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dungure kobile i mena erungure, Yesu kane yebe ere ka iru dungwa, “Na Abe na ka diga i piringa, na wai pire maki ye i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na ka di i tega i morin morin piringa kaniiba, i na nusi ime eringa ibalin kobe pire gi dinama dire, ka iru di i teiwa.” ");
INSERT INTO gvf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ka iru direre pare, gala bil dire iru dungwa, “Alasaras, i ale ere mena wo.” ");
INSERT INTO gvf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ena gulungwa yal alere ere mena ungure, aan kawn para kan daangwa, te gal ta guman para yobilungwa, Yesu ka iru di ibal kobe tongwa, “Yalini imore kol warama dire, i kan daanga pu ero.” ");
INSERT INTO gvf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ena Yuda ibal singaba kobe Maria bole urere, Yesu kal iru erungwa kanere, pire gi di yalini tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tomba ibal taw kobe kwi pi Parasi kobe milungwa gul pire, Yesu kal erungwa bolin kule di maribe ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Di tomia ena Parasi kobe te Yuda ka main kenin erungwa yal bil kobe bole, “U ku bilo,” di yal singaba kobe di tere, u ku bilere iru dungwa, “Yal iray kal guman kwi dungwa binanbile eremia, ena na yal kobe takal ere yalini terabine? ");
INSERT INTO gvf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yalini kal iru erungwa na yal kobe manaa di tekerabinga, ena ibal para pire di gi yalini tenamua. Tenangure Orom gabman ibal simil nen nusi erangure, ure na ibal kobe ka main ogu bil si suule erangure, na Yuda ibal para u sutaw nabinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dimba yal ta kaan Kayapas milere, kamin kaun i Yuda ibal kenin erungwa yal singaba milere ka iru dungwa, “I yal kobe nomanin paikungwa milinwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yuda ibal para sinangure u sutaw nangwa paikinamba, ibal wai milama dire, yal taran si gulangwa painamua. Iru erabinga i yal kobe main ta pirekeno?” ");
INSERT INTO gvf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yalini ka iru dimba, ka dungwa main yalini inin nomanin si pire ta dekungwa. Ta dekimba Yuda ibal kenin erungwa yal singaba milungwa, ena Yuda ibal wai imo milama dire, Yesu gulangwa ka goma di maribe ere dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Dimba Yuda ibal tawle wai imo milama dire, tamama. God baan baan para ibal kule yongwa u ku bile taminin taran milama dire, Yesu gulungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kayapas ka iru dimia, ena u ku bilungwa ibalin kobi Yesu si gulabina dire, kol ta waa duure ka di paalungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kal iru eremia, ena Yuda ibal yal singaba kobe milungwa gul Yesu suna ali ta warekimba, yalini pi ogu ai ta kaan Eperaim gariba simi yongwa maala dungwa ongwa. Pirere baan iray gawlima kobe bole pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ena Yuda ibal bolima siipe siipe sungure God yalin kobe ta sekungwa kaun nomanin si pire, komina bil nerabinga kaun, kaan Pasoba, u maala ongure, ibal kobe mena kole kole ki paingwa para pi Yerusalem wi yebe ongwa. Komina bil ole nekire ibal kobe nomanin suna wai dinama dire, gain bigin sirala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pirere Yesu waa duu milere, Yuda ka main ogu bil mile ka iru dungwa, “Yesu komina bil nerabinga gul yalini unam mo, wekenam mo, i takal waa di pirine?” ");
INSERT INTO gvf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yuda ka main kenin erungwa yal bil kobe, te Parasi kobe bole kaman tere ka iru di ibal kobe tongwa, “Na yal kobe Yesu kanin sirala dire, yalini baan ta ki pai milangwa gul kananga, i di maribe ere na to.” ");
INSERT INTO gvf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ena komina bil nenangwa kaun i u bawa dinangwa, are kaun anan kole muru kole taran imo dungure, Yesu pi Alasaras gulere alungwa yal ain Betani ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ibalin kobi komina ki Yesu tongure, Mata komina gwiire aa tekun erungure, Alasaras te Yesu bole komina nerala dire, bol mina amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Milungure Maria milere, wel niriin minanin wai wen sungwa tobe bil bilungwa, mugu ta ali yuure, Yesu kawn mina garu dire gibiliigin aa gi di pire, kul tongwa kire di erungwa. Wel niriin minanin wai sungwa, ena ogu ala kuunin bi bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesu gawlima kobe yal ta kaan Yudas Isikerio, yalini Yesu bale taal sirala dungwa yal milere ka iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Wel niriin i tobe bilkaw bilungwa, kina kandret sutakobe irabinga, kul gal bona aa te nekungwa ibal terabinba.” ");
INSERT INTO gvf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dire bona gana aa te nekungwa ibal miriin pire tekire, kunibe nongwa yal milemia ena ka iru dungwa. Gawlima kobe kobile moni gal taran gule yongure, yalini kenin erimba, kamin kaun kaun kunibe ne nere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dimba Yesu ka iru dungwa, “Abalini kal erungwa, i ibal kobe kane gogo ero. Na gulabinga maul si yere wel niriin bile na terala dire, abalini wel niriin iray goma ye milungwa, malia bile na tomua. ");
INSERT INTO gvf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kul gal bona aa te nekungwa ibal i bole para morin mile painamba, na i ibal kobe bole baan araway ta milekerabilwa.” ");
INSERT INTO gvf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ena, “Yesu Betani ai milemua,” dungwa Yuda ibal singaba kobe binanbile pirere, ena Yesu milungwa gul ungwa. Umba Yesu tawle kanala di ukire, Alasaras gule alungwa para kanabina dire ungwa. Alasaras gulungwa Yesu kwi aa te ale iru ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Iru eremia ena Yuda ibal binanbile milere Yuda ka main kenin erungwa yal bil kobe ka dungwa pirala pirekire, pire gi di Yesu tongwa. Tomia ena Alasaras para si gulabina dire, kol ta waa duure ka di paalungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","God goma Yuda ibal ta sekungure, ibal kobe nomanin si pirungwa erin kaun, ibal binanbile komina bil nerala dire u milungwa. Wel niriin bile tongure pare, paire kamin taangure, “Yesu Yerusalem ai umua,” dungwa ibalin kobe pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Piremia ena ibalin kobe simil nima arin bale aa te irere, Yesu guman kol baan kanala di pire, aya maya, dire deminin si God tere iru gala dungwa, “Yal ta God ka dungwa kebe ere yuungwa yal i, God miriin pai yalini tomua. Isirel ibal yal bil God miriin pai yalini tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu bolima donki ta waa duure kane mun bolin mina amin di milungwa mere, ka main minin ganin iru dire bilungwa paangwa, ");
INSERT INTO gvf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ai ta kaan Sayon ibal kobe i kuril pirekio. Kano, i yal bil ure bolima donki mun bolimina amin di milere umua.” ");
INSERT INTO gvf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ka bile dungwa i, yalini gawlima kobe kaun iray ta pirekemba, eme Yesu ale kamin mina ongure pare, ka main minin ganin ka i dungwa mere pirere, te ibal kobe kal iru ere tongwa para pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Goma yal ta kaan Alasaras gulungwa maul si yongure, Yesu pire, “Ere mena wo,” di gala dire Alasaras alungwa, Yesu iru ere yalini tongwa. Iru erungwa ibal binanbile kanere malia pire bolin kule ibal para tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yesu kalkan naanin paangwa i maribe erungwai, ibal kobe bolin kule tongware ibal binanwenbile pi Yesu kol baan guman kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iru erungure Parasi kobe ka diria ere iru dungwa, “Na yal kobe kalkan ta erabinga wi yebe pekungwa kaninwa. Te kano, ibal gariba gariba para yalini duulin bile waremua.” ");
INSERT INTO gvf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ena komina bil i nerala dire, Yuda ibal Yerusalem pire deminin si ana di God terala di ongure, Giriki ibal taw bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Galili gariba gul ai ta kaan Besaida, Pilipi baan i nen milungwa, ena Giriki yalin kobe pi yalini milungwa gul pire iru di tongwa, “Yalkuno, na yal kobe Yesu kanabina dire ubinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dungure Pilipi pi Endiru di tongure, yal sui pi Yesu di tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Di tongure Yesu ka di kole ere iru dungwa, “Na U Ibal Obinga Yal gulalgire, God yobilaan bil pai na tenangwa kaun, kamin kaun i u maala omua. ");
INSERT INTO gvf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na kawen dirala piro. Dodal milin yaalangwa pi sire maanamba, yaalangwa milin i bile yaanamua. Ta bile yaakinangwa, ena milin i pi sikire ta maakire, milin binanbile ta kulekenamua. Main iru paimia, ena na gulabinga na ibalan kobe maale sulu dinamua. ");
INSERT INTO gvf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yal ta gariba gul mile pairalgal pairala di pire, kalkan aa te nongwa nomanin tegi dire aa gi di pirangwa, ena yalini u main namua. Te yal ta gariba gul mile painangwal painama di pirekire, kalkan aa te nongwa gibilin mui kol yenangwa, ena yalini mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yal ta nil konagi ere na terala di pirangwa, ena na munan kol duulan bilangwa paamua. Bilamia ena na milalga gul yalini para pi milamua. Yal ta nil konagi ere na tenangwa, ena na Abe yalini ai yebe di tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Dire Yesu ainere dungwa, “Na miriin bilkaw pire milia, ena malia ka tawa dirale? Ka ta iru diralo? ‘Na Abe malia na gaynan giil pirekeralga, i kal iru ere na to.’ Diralba na gaynan giil pirala dire, na ere ime wiwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na Abe ibal kobe i kaanin gale yebe erama dire, i kal iru ero.” Dungure kamin mina ka ta iru ime ungwa, “I ka dinga kaya iru eriiba, kwi ama iru eralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ibal binanbile maala milungwa ka dungwa i pirere iru dungwa, “Kamin guru dima di pirebinwa.” Dimba ibal taw mile, “Angel ta ka di yalini tomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dungure Yesu ka di kole ere iru dungwa, “Na piralga ka ta ime ukumba, i ibal kobe pirana dire, ka iru ime umua. ");
INSERT INTO gvf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gariba ibal para muru kal erungwa pirin paim mo, paikim mo, malia God di maribe eramua. Gariba gul yal singaba Satan milungure, malia God yalini si kiranin bile i sutaw eramua. ");
INSERT INTO gvf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ibal kobe eri pera mina na bile waaki dinangwa, ena ibal para na aa gi di pirama dire, di ku bile na miliga gul eralga paamua.” ");
INSERT INTO gvf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu ka iru dungwa ibal kobe yalini si gulangwa mere, di maribe ere ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ibal kobe ka di kole ere iru di Yesu tongwa, “‘Kirisito mile painangwal paanamua,’ dire na ibal kobe kile kaman ka iru bilungwa pirebinwa. Iru bilemia, ena ‘U Ibal Ongwa Yal eri pera mina bile waaki dinamua,’ dingi, tameran ka iru dine? U Ibal Ongwa Yal yalini ibena mileme?” ");
INSERT INTO gvf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu ka di kole ere iru di tongwa, “Aw dungure i nomanin suna naabilama dire, na kaun tawle i bole milabinwa. I ibal kobe iru mile paina, ena kanekun ere kalkan konagi ere ere milo. I nomanin suna kama ta sekenama dire, kanekun ere kalkan konagi ere milo. Ibal kobe si bilungwa gul kol namba, nala dinangwa ain ta kanekinamua. ");
INSERT INTO gvf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aw dire i nomanin suna naabile tongwa yal bole para milebilga, i pire gi di yalini to. Tenanga ena yalini wan abilin muru milanwa.” Ena Yesu ka iru di pisere ibal kwi ta na kanekinama dire, ere aal kule ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yalini kal guman kwi dungwa binanbile erungure, ibal kobe kanimba, pire gi di yalini tekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ta tekemia ena goma God ka kebe yal Aisaya ka iru dungwa pi nima ongwa. “God Singaba ka bolin kule di maribe erebinga, ibena kawen dima di pireme? Di maribe erebinba God Singaba yobilaan bile kal guman kwi dungwa erinba, ibal kobe ta kane pirekemua.” ");
INSERT INTO gvf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iru dungwa paamia, ena pire gi di Yesu tekungwa paangwa. Aisaya ka kwi ta iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nomanin paikungwa milama dire, te kiraan te omilin gi dungwa imo dinama dire, God kal iru ere tomua. Kiraan gi dungwa pirekenama dire, te nomanin paikungwa pirekenama dire, nomanin si kiruul sire na aa te wai ere tekerala dire, God kal iru ere tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kirisito yobilaan bile niminin milungwa Aisaya kanere, Yesu milungwa mere ka iru di maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iru dimba, Yuda ibal yal singaba kobe binanbile pire gi di Yesu tongwa. Tomba Yuda ka main ogu kaan paangwa, Parasi kobe i mena erekinama dire, pire gi di Yesu tongwa di maribe erekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ibal kobe kaan gale yebe ere deminin si na tenama dire, yalin kobe iru di pirimba, God deminin si yalin kobe tenama di ta pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ena Yesu ka bil dire iru dungwa, “Ibal kobe pire gi di na tenangwa, ena ibalin kobe na inan tawle pire gi di na tenangwa, tamama. Na nusi ime erungwa yal, ibalin kobe para pire gi di yalini tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ibal kobe na kanungwa mere, na nusi ime erungwa yal para kanemua. ");
INSERT INTO gvf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Gariba ibal para nomanin naabilama dire, aw di ibalin kobe terala di ere ime wiwa. Ibal kobe pire gi di na tenamia, ena ibalin kobe nomanin suna kama ta sekenamua. ");
INSERT INTO gvf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na ka nil si tega ibal kobe pirere wiina ere na tekenamba, na ibalin kobe ka kol ta ere tekeralwa. Gariba ibal ka kol ere terala dire, na ime ta ukiwa. Gariba ibal aa ki di tegire, sigare kule u wai nama dire, na ime wiwa. ");
INSERT INTO gvf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ibal kobe mun kal waa na tere, te na ka nil si tega wiina ere na tekenangwa, ena yal ta ka kol ere ibalin kobe tenamua. Kamin te gariba wei sinangwa kaun na ka diga mere, ka kol ere ibalin kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na inan nomanin si pirega mere, ta di ibal kobe tekiwa. Na Abe na nusi ime erungwa yal, ‘Iru do,’ dire kaman na tongwa mere, di maribe ere teiwa. Iru di tega, ena na ka diga mere iray, ka kol ere ibalin kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ibal kobe mile painangwal painama dire, na Abe kile kaman ka di tongwa piriwa. Iru paimia ena na Abe, ‘Iru do,’ dungure diwa,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ena Yuda ibal bolima siipe siipe sungure God yalin kobe ta sekungwa kaun, kaan Pasoba, nomanin si pire komina bil nerabinga kaun, kamin kaun taran tawle imo dungwa. Yesu gariba gul pisere kwi ere Nen milungwa gul nangwa kaun iray u maala oma dire, Yesu iru pirungwa. Pirere gawliman kobe gariba gul milungwa den miriin ibalin kobe tongwa, den miriin kirara ibalin kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kamin girungure Yesu te gawlima kobe bole komina ne milungwa. Satan kaya iru pire dungwa, “Saimon Isikerio wan Yudas Yesu bale taal sinamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kalkan para muru ke milama dire, Abe yobilaan bil pai Yesu tere God yalini nusi ime erungure, yalini kwi pi God milungwa gul nangwa, kalkan iru paangwa Yesu pirungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Piremia ena Yesu alere gwi gal gule erere, gal taul suna werain bile paalungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bile paalere nil garu di pele bala ali erere pare, gawliman kawn bigin sire gal taul suna werain bile paalungwa kire di erala dire, kawn kule erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bigin si ongwa ongwa Saimon Pita bigin si terala di erungure, Pita ka iru di tongwa, “Ayo, Singabo, i na kawnan para bigin si na tenano?” ");
INSERT INTO gvf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Dungure Yesu ka di kole ere iru dungwa, “Na kal ere i teralga i malia main ta pirekenanba, eme main piranwa.” ");
INSERT INTO gvf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dungure Pita mile, “I na kawnan bigin sinanga, tamama.” Dungure ena Yesu ka di kole ere iru dungwa, “I kawnin bigin si i tekerabinga, i na bole para pena ta galekirabilwa.” ");
INSERT INTO gvf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dungure Saimon Pita ka di kole ere iru dungwa, “Singabo, iru painamia, ena na kawnan tawle bigin si na tenanga, tamama. Na anan kawnan te gibilan para bigin si na to mo.” ");
INSERT INTO gvf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dungure Yesu ka iru di yalini tongwa, “Yal ta kaya nil paingwa ena yalini gain debegi ta dekemba, kawn kaana sungwa tawle bigin sinangwa para wai dimua. I yal kobe para nomanin suna wai dungwa milinba, yal ta i milinga suna milungwa yal i nomanin suna ki eremua.” ");
INSERT INTO gvf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Dungure yal ta Yesu bale taal sinangwa, Yesu yalini kaya kanemia ena, “I yal kobe para muru nomanin suna wai dungwa ta milekinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ena Yesu yalin kobe kawn bigin si pisere pare, gwi gal kwi sigi dire kwi pi milungwa ain amin di milungwa. Milere ka iru dungwa, “Na kal ere i yal kobe tega, main pirino? ");
INSERT INTO gvf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","‘Nil si tongwa yalo, te Singabo,’ dire ka iru di na tenga, ena na kirara iru miliga ka di na tenga i kuunin paimua. ");
INSERT INTO gvf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na Singaba te nil si i tega yal na milere, i kawnin bigin sibina, ena i yal ta kawn bigin si tengire, te yal ta i kawnin bigin si tenangure, iru inin inin bigin so. ");
INSERT INTO gvf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kalkan ere i tega mere, i yal kobe iru erana dire, i maribe ere i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na kawen di terala piro. Nil konagi yal, singaba yal yaa ime ta sinangwa, tamama. Te ka kebe ere yuungwa yal, nusi erungwa yal yaa ime sinangwa, tamama. ");
INSERT INTO gvf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ka di i tega main piringa, ena wiina eranga miriin painamua. ");
INSERT INTO gvf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“‘I miriin painamua,’ diga i yal kobe para muru kanin ta dikiwa. Na ibal kobe paale suna ere iga na kaniiba, ka main minin ganin bile, ‘Yal ta na bole komina nobinga kaymin paale na tenamua,’ dungwa mere pi nima namua. ");
INSERT INTO gvf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kalkan iray ole u bawa dikungure, kaya di i teiwa. U bawa dinangure, ‘Na yal iray iru miliwa,’ diga i pire gi dinana dire, kaya di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na kawen dirala piro. Yal ta na nusi erabinga ibal kobe aa te wai ere yalini tenangwa mere, ibalin kobe aa te wai ere na tenangwa paamua. Te ibal kobe aa te wai ere na tenangwa mere, aa te wai ere na nusi ime erungwa yal tenamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu ka iru dire pare yalini inin miriin bilkaw pire ire ka di gawa dire iru dungwa, “Na kawen dirala piro, yal ta u alia milere na bale taal sinamua.” ");
INSERT INTO gvf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dungure gawlima kobe inin inin tena kane iria ere, “Ibena kan dime?” dire pire gogo ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Gawlima ta Yesu binan kole na miligire, Yesu den miriin na te milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na iru milia, ena Saimon Pita guman gel bile na tere iru di tongwa, “Yesu kan dungwa mere sirin bile piro.” ");
INSERT INTO gvf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dungwa ena na pera waa pai mile si dugu dire, ka iru di Yesu tega, “I ibena kan dine?” ");
INSERT INTO gvf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Digire Yesu ka di kole ere iru dungwa, “Na pele bala ali komina bile yal ta teralga, yalini yal iray milemua.” Dire komina birete ta ire komina nil ali bilere Saimon Isikerio wan Yudas tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tongure pare ena Satan pi Yudas nomanin suna ongure, Yesu ka iru di Yudas tongwa, “Kal erangai, wei di ero.” ");
INSERT INTO gvf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gawlima kobe bole amin di milungwa Yesu ka di Yudas tongwa, main i ta pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gawlima kobe kobile moni gal taran gule yongure, yalini kenin ere milemia, ena gawlima kobe iru pirungwa, “‘Komina bil nerabinga komina taw gibilin sinana po,’ di tom mo, ‘Aa te nekungwa ibal kobile moni taw obin si tenana po,’ di tom mo, na ibal kobe iru pirebinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yesu komina birete tongwa Yudas irere gin taran ale ere mena ongwa. Ongwa kaun i kamin kaya si bilungwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ena Yudas ere mena ongure pare, Yesu ka iru dungwa, “Maliaga Na U Ibal Obinga Yal, na yobilanan bil bilega i maribe eramua. Iru painamia, ena God yobilaan bil bilungwa para i maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Eramia ena God inin mile, Na U Ibal Obinga Yal yobilaan bil bilega, yalini gin taran i maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na gaan kobe, kaun baan tawle i bole milalwa. I yal kobe na waa duunanba, Yuda ibal yal singaba kobe ka di ibalin kobe tega mere, i yal kobe di terala piro. Na pi milalga ain i nala di piranba, maliaga ta ukunanwa. ");
INSERT INTO gvf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na kile kaman ka kwi ta di i terala piro. I yal kobe milinga suna den miriin inin inin te milo. Na denan miranan i yal kobe tega mere, i para iru ere to. ");
INSERT INTO gvf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","I yal kobe den miriin tere tere milanga, ena ibal kobe kane, ‘Yesu gawliman kobe milemua,’ dinamua.” ");
INSERT INTO gvf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dungure Saimon Pita ka iru sirin bile Yesu tongwa, “Singabo, i nanga kol alde nane?” Dungure Yesu en dire iru dungwa, “Na pi milalga ain malia i na duulin bile ta wekenanba, eme na duulin bile unanwa.” ");
INSERT INTO gvf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Dungure ka sirin bile tere iru di tongwa, “Singabo, tameran na miliaga i munin kol duulin bilekerale? I milinga pire na miliwa. I gulanga na para gulalwa.” ");
INSERT INTO gvf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dungure Yesu ka di kole ere iru di tongwa, “Na miliga pire i milinba, na pire kawen gulala di pirino? Na kawen i inin di terala piro. Yal korale be dala di erangwa, i ginin sutakobe na kaanan di aal kule, di kile di mena ere na tenanwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ena Yesu ka iru di yal kobe tongwa, “I sigagu dire nomanin si ala erekio. I pire gi di God tere na ama pire gi di na to. ");
INSERT INTO gvf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na Abe ogu ali maan kulan bilungwa binanbile dimua. Iru ta paikinamia di i teralba, binanbile dimia, ena ai ta aa te wai ere i terala di nalwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nalgire pare kwi ere ime ure na miliga gul i awli nalgire, na pi milalga gul i para milabilwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na pi milalga ain kol dungwa, i yal kobe kaninwa.” ");
INSERT INTO gvf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dungure Tomas ka iru di tongwa, “Singabo, i pi milanga ain na yal kobe ta kanekibinga, tameran ‘Kol dungwa kaninwa,’ di na tene?” ");
INSERT INTO gvf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dungure Yesu ka di kole ere iru dungwa, “Ibal kobe na Abe milungwa gul nangwa kol iray na miliwa. Kal para wen kirara kawen dungwa di maribe erungwa yal, na miliwa. Ibal kobe mile painangwal painama dire, na miliwa. Ibal kobe pire gi di na tenangwa, ibalin kobe tawle na Abe milungwa gul pi milamua. ");
INSERT INTO gvf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","I yal kobe na pirekun eranga, na. Abe para pirekun eranwa. Iru paimba yalini kanere, maliaga i yalini pirekun erala erinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ena Pilipi ka iru di tongwa, “Singabo, na Abe kamin mina milungwa i maribe ere na yal kobe tenanga, ena para kuunin painama di pirabinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dungure Yesu ka iru di yalini tongwa, “Pilipi na i yal kobe bole baan araway milebinba, i na pirekun erekino? Ibal kobe na kanungwa mere, na Abe para kanemua. Kanemia ena tameran, ‘Na Abe i maribe ere na yal kobe to,’ di na tene? ");
INSERT INTO gvf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Na Abe na bole si waire si dawle taran milebinga, i pire gi ta dikino? Na ka di i tega, na inan nomanin pire ta dikiwa. Na Abe bole pena galebilga, yalini konagi kal guman kwi dungwa ere milemua. ");
INSERT INTO gvf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na Abe na bole si waire si dawle taran milebinga, i pire gi di na to. Pire iru ta di na tekenanga, ena na konagi ere kal guman kwi dungwa erebinga kanere, i pire gi di na to. ");
INSERT INTO gvf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na kawen dirala piro. Ibal kobe pire gi di na tenangwa, ena na konagi eriga mere yalini para erangwa paamua. Te na Abe milungwa gul nalga, ena ibalin kobe konagi erangwa na konagi eriga yaa ime sinamua. ");
INSERT INTO gvf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","I ana di God tere, ‘Kal ta na to,’ dire na kaanan wiina eranga, ena kal iru ere i teralwa. Na Abe yobilaan bil bilungwa, yalini Wan na i maribe erala dire kal iru ere i teralwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","‘Kal ta na to,’ dire ana dire na kaanan wiina eranga, ena kan dinanga kal i ere i teralwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ena i yal kobe den miriin na tenanga, ena na kile kaman ka di i tega wiina eranwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na Abe ka sirin bile teralgire, ena aa ki di ibal tongwa yal, i yal kobe bole morin morin mile painama dire, nusi ere i tenamua. Aa ki di ibal tongwa yal i, yalini kawen kobaan milemua. ");
INSERT INTO gvf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Gariba ibal kawen kobaan bole pena galala di pirekemua. Ibalin kobe yalini pirekun ta erekungwa, ena bole pena ta galekinamua. Dimba yalini i yal kobe bole pena galere bole taran milungwa, ena i yalini pirekun erinwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“I yal kobe gaan mua ta milekenana dire, kawen piserekiralwa. I milinga gul kwi uralwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Na kamin kaun tawliga imo dinangure pare, gariba ibal na ta kanekinamba, i yal kobe na kananwa. Na milia, ena i yal kobe para milanwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kamin kaun i u bawa dinangure, i yal kobe iru piranga, na Abe bole taran miligire, te na i bole taran miliga mere, i na bole taran milia di piranwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ena yal ta na kile kaman ka diga pire wiina ere na tenangwa, ena yalini den miriin na tenamua. Tenangure na Abe para den miriin yalini tenamua. Tenangure na para denan miranan yal iray tere, na miliga main para di maribe ere teralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dungure Yudas Isikerio duun, kaan Yudas mile, ka iru di Yesu tongwa, “Singabo, gariba ibal i milinga main di maribe ere tekere, ‘Na yal kobe di maribe ere na teralwa,’ dinga i, tamintan main paangwa pire dine?” ");
INSERT INTO gvf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu ka di kole ere iru di yalini tongwa, “Ibal kobe den miriin na tenangwa, ena ka diga wiina eramua. Na Abe den miriin ibalin kobe tenangure, te yalini te na bole ibalin kobe bole pena galabinwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ibal kobe den miriin na tekungwa, na ka diga wiina erekenamua. Malia ka digire piringa, na inan pire ka ta dekiiba, na Abe na nusi erere yalini ka di na tongwa, diwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Na i yal kobe bole miliga, ka di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aa ki di ibal tongwa yal, God Kegemama Iban na Abe nusi ere i tenangure, yalini kal muru nil si i yal kobe tenamua. Na ainan pi milama dire, na Abe nusi ere i tenamua. Ka di i tega i nomanin si pirana dire, yalini di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“I kabin si milanwa. Na kabin si miliga mere, iru wen milanwa. Ka main pirekungwa ibal kabin si milungwa mere, iru ta milekenanwa. I sigagu dikire nomanin si ala erekire, te kuril para pirekio. ");
INSERT INTO gvf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Na i yal kobe pisere pire kwi i milinga gul uralwa,’ diga i pirinwa. Na yobilaan bilebinba, na Abe yobilaan wen bilungwa, Abe milungwa gul nala di miliga i wai pire miriin painamba. I den miriin na tenanga, ena wai pire miriin painamua. ");
INSERT INTO gvf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kalkan iray ole u bawa dikungure, i kaya di teiwa. Iru di i tega, kal i u bawa dinangwa kaun i pire gi dinanwa. ");
INSERT INTO gvf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gariba gul yal singaba ki urala di milungwa, ka binanbile ta di tekeralwa. Dimba yalini na ta si ime erekinamua. ");
INSERT INTO gvf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Abe denan miranan tega gariba ibal para pirama dire, Abe ka di na tongwa para wiina eriwa. “Ale, ere nabina wo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ena Yesu ka di bile dire iru dungwa, “Girepe milin komin kanin wo dungwa i, na miliwa. Te girepe kanin kenin erungwa yal, na Abe milemua. ");
INSERT INTO gvf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kanin mege mege warungwa milin ta kulekungwa, ena yalini ure abaa de eramua. Te kanin mege mege taw milin kulungwa milin kwi ama kulama dire, kanin mege mege bigin maure kenin eremua. ");
INSERT INTO gvf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na ka di i tega, ena i kal ki eringa na Abe kaya kire di eremua. ");
INSERT INTO gvf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","I bole pena gale na tengire, na i bole pena gale i teralwa. Kanin mege ta komin kanin si dawle ta milekire, milin ta kulekenangwa mere, i na bole pena gale na tekire, i kal wai erana di piriga ta erekinanwa. ");
INSERT INTO gvf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Girepe milin komin kanin dungwa mere na miliwa. Te i kanin mege mege dungwa mere, i yal kobe milinwa. Ibal kobe bole pena gale na tongure, na bole pena gale ibalin kobe teralga, ena ibalin kobe kalkan erama di piriga eramua. I yal kobe na pisere inin milanga, kal wen ta erekinanwa. ");
INSERT INTO gvf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ibal kobe bole pena gale na tekenangwa, ena kanin mege abaa de erangure gulangure pare enderin galungwa mere, kal iru ere ibalin kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","I na bole pena gale milabilga, te na ka diga pire nomanin suna ye milanga, ena kalkan i irala di pire, ana di God tenanga inanwa. ");
INSERT INTO gvf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","I kalkan erana di piriga eranga, ena na gawlimanan kobe milema di ibal iru piramua. I iru eranga, ena na Abe yobilaan bil bile milema di ibal iru i maribe ere piramua. ");
INSERT INTO gvf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na Abe den miriin na tongwa mere, na denan miranan i yal kobe teiwa. Tega i yal kobe na ta piserekire, na denan miranan i yal kobe te milala digire, i iru mile payo. ");
INSERT INTO gvf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na kile kaman ka di tega wiina eranga, ena na denan miranan i yal kobe te milalwa. Te milalga mere iwe. Na Abe kile kaman ka di na tongwa wiina eriga, ena yalini den miriin na te milemua. ");
INSERT INTO gvf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Na wai pire miranan paiga mere, i yal kobe para iru milana dire, ka diga iray kaya di i yal kobe teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na kile kaman ka di terala piro. Na denan miranan i tega mere, i yal kobe milinga suna den miriin inin inin te ibeya ere milo. ");
INSERT INTO gvf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ye nongwa yal ta wai milama dire, yal ta gulangwa, ena gulangwa yal i den miriin ye nongwa yal i tere maa kora kule tenangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na kile kaman ka di i tega wiina eranga, ena na ye nega kawen milanwa. ");
INSERT INTO gvf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yal singaba kalkan erungwa nil konagi yal ta pirekemia, ena ‘I yal kobe nil konagi yalo,’ kwi ta di tekeralba, ‘Na ye nego,’ dire ka iru di i yal kobe teralwa. Na Abe ka di na tongwa mere pirere di i tega, ena ‘Na ye nego,’ di teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","I yal kobe na paale suna ta erekinba, na i yal kobe paale suna eriwa. I kal wai erana di piriga i pi iru erana dire, na i yal kobe nusi eriwa. I kal wai eranga i, di painangwal painamua. I ana di God tere, ‘Kal ta na to,’ dire na kaanan wiina eranga, ena na Abe kalkan i, i tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ena na kile kaman ka iru di i terala piro. I yal kobe milinga suna, den miriin inin inin te ibeya ere milo. ");
INSERT INTO gvf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ena gariba ibal den gule i yal kobe tenangwa ena i iru piro. Ibalin kobe goma den ki ye na toma di piro. ");
INSERT INTO gvf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","I yal kobe gariba ibal bole pena galanga, ena ibalin kobe mile, ‘Na gawlimanan milemua,’ di i tere, den miriin i yal kobe tenamua. Dimba, gariba ibal milinga suna na i yal kobe paale suna ere iga, i yal kobe ibalin kobe bole pena gale tekina, ena ibalin kobe den ki ye i tomua. ");
INSERT INTO gvf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nil konagi yal, yal singaba yaa ime ta sinangwa tamama, kaya ka iru di tega iray piro. Ibalin kobe gain giil pire na tongwa mere, iru ere i tenamua. Te na ka di tega ibalin kobe pire wiina erungwa mere, i ka dinanga pire wiina eramua. ");
INSERT INTO gvf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","I yal kobe pire gi di na tenga, ena ibalin kobe gain giil pire i tenamua. Na nusi ime erungwa yal, ibalin kobe ta pire pol sekimia, ena kal iru ere i yal kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na ure ka di ibalin kobe tekerabinga, ena kal digan ere taalime erangure pirin ta pai tekenamba, malia ibalin kobe mile, ‘Na kal digan ere taalime erebinba, pirin ta paikimua,’ dire ka iru ta dikinamua. ");
INSERT INTO gvf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ibal kobe den ki ye na tomia, ena ibalin kobe para den ki ye na Abe tomua. ");
INSERT INTO gvf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kal guman kwi dungwa goma ibal ta erekungwa mere na ta erekirabinga, ena ibalin kobe kal digan ere taalime erangure pirin ta pai tekinamba, kal erigai ibalin kobe kanere na te Abe bole den ki ye na tomua. ");
INSERT INTO gvf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ibalin kobe kile kaman ka paangwa mere pi nima nama dire, ibalin kobe den ki ye na te Abe tomua. Kile kaman ka iru bile paalungwa paangwa, ‘Na imore miliiba, den ki ye na tomua.’ ");
INSERT INTO gvf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aa ki di ibal tongwa yal mile, yalini kawen kobaan, God Iban milere, na Abe milungwa gul pisere unamua. Na Abe milungwa gul piserangure, nusi eralga na guunan kanan bolin kule di maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na goma konagi kawn kule erebingire, i yal kobe na bole milinga i para na guunan kanan bolin kule di maribe eranwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“I yal kobe pire gi dinga mun kal waa tekenana dire, na ka iru di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yuda ibal ka main ogu i mena erangure, te kaun ta u bawa dinangure iru painamua. Ibal kobe i si gulangwa, God konagi erebina di piramua. ");
INSERT INTO gvf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Na Abe te na para milebinga mere, ibalin kobe ta pire pol sekungwa iru ere i tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dimba ibalin kobe kal iru ere milangwa kaun u maribe nangure, na ka diga i nomanin si pirana dire, kaya di i teiwa. “Goma na i yal kobe bole miliga ka iru di i tekiwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ena malia we, na nusi ime erungwa yal yalini milungwa gul nala di erebinba, i yal kobe mile, ‘I alde nane?’ dire sirin bile na tekenwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Malia ka iru di i tega i inin miriin wen pire milinwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pire milinba kawen dirala i yal kobe piro. Na pekeralga aa ki di ibal tongwa yal ime ta ukinamba, nabinga, na yalini nusi eralwa. Na ta pekeralga tawle wai painamba, nabinga wai wen painamua. ");
INSERT INTO gvf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Unangwa yalini mile, ibal kal digan ere taalime erungwa pirin painama dire, te kabin sire wai wen milama dire, te God ka kol ere tenama dire, iru di maribe ere gariba ibal tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ibal kobe pire gi di na tekungwa, ibalin kobe kal digan ere taalime erungwa, ‘Pirin pai dimua,’ dire di maribe ere tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na Abe kamin mina milungwa gul na nala di milegire, i ama na ta kanekinanga, ena kabin sire wai wen milama dire, di maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","God mile gariba gul singaba bil wen Satan ka kol kaya ere tongwa, ena God ka kol ere tongwa mere aa ki di ibal tongwa yal di maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ka taw binanbile ama di i teralba, malia i piranga kuunin ta erekinwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dibinba kawen kobaan, God Iban unangwa kaun, kalkan para kirara kawen dungwa i maribe ere i yal kobe tenamua. Yalini inin nomanin pire ka di i tekire, God di maribe ere yalini tongwa mere di i tenamua. Eme kalkan u maribe nangwa bolin kule i yal kobe tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na guunan kanan di maribe ere i tenangwa, na kaanan aa te yebe eramua. ");
INSERT INTO gvf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na Abe kal para wen dungwa na kobaan miliwa. Iru milebinga, ena ‘Na God Kegemama Iban di tega mere, yalini bolin kule i tenamua,’ dire kaya ka iru di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ena kaun baan tawle milalgire, i na ta kanekinanba, kaun taw para milalgire, na kananwa,” dire Yesu iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Gawlima kobe taw diria ere iru dungwa, “‘Kaun baan tawle milalgire, na ta kanekinanba, kaun taw para milalgire, na kananwa,’ dire te, ‘Na Abe milungwa gul nalga ena iru painamua,’ dungwa i main tamintan paangwa pire dime? ");
INSERT INTO gvf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Baan tawle milalwa,’ dungwa, tameran ka iru dime? Yalini ka dungwa mere main pirekun erekibinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gawlima kobe sirin bile Yesu terala di pirungwa, Yesu kaya pire bawa dire iru di tongwa, “Na mile, ‘Kaun baan tawle milalgire, na ta kanekinanba, kaun taw para milalgire, na kananwa,’ iru di i tega, ka iray diria ere milino? ");
INSERT INTO gvf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na kawen di terala piro. I yal kobe kere bare kay mi milanba, na ka main pirekungwa ibal kobe miinin maanamua. I yal kobe miriin pire milanba, miriin piringa pisere i yal kobe kwi miriin painanwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Abal ta gaan kule yerala di ere milungwa i, giil pire miriin pire milemua. Gaan kule ye piserere, gaan ta gariba gul u maribe ongwa kanere, miinin maare gain giil pirungwa u mun kol ongure, nomanin si pirekemua. ");
INSERT INTO gvf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","I yal kobe para iru wen milinwa. Malia i yal kobe miriin pire na tere nigi de pire milinba, na i kwi kanalga wai pire gun ye milanwa. Gun iru ye milanga, ibal kobe i sutaw ere i tekenamua. ");
INSERT INTO gvf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Kaun i u maribe nangwa ka ta ama sirin bile na tekenanwa. Na kawen di terala piro. I yal kobe, ‘Kal ta na to,’ dire na kaanan wiina ere sirin bile na Abe tenanga, kan dinanga kal i, yalini i tenamua. ");
INSERT INTO gvf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Goma i, ‘Kal ta na to,’ dire na kaanan wiina ere sirin bile tekinga, malia sirin bile tenanga, kan dinanga kal i inanwa. I yal kobe miinin wen maanana dire, inanwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ka di i tega di bile diwa. Kaun ta u bawa dinangwa ka di bile dungwa kwi ta dikiralba, na Abe milungwa mere, di gawa diralwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kaun ta i u bawa dinangure, i na kaanan wiina ere sirin bile tenangure, i ka dinanga na kebe yekiralgire, ");
INSERT INTO gvf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","na Abe inin den miriin i tomua. I den miriin na terere, te God milungwa gul pisere na uga i iru pire gi dingire, na Abe den miriin i tomua. ");
INSERT INTO gvf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na Abe milungwa gul pisere ere ime urere, te malia gariba gul pisere na Abe milungwa gul kwi ere yebe nalwa.” ");
INSERT INTO gvf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dungure gawlima kobe iru di tongwa, “Ayo, ka dinga ka di bile dikinga, malia i kirara di gawa di na tenwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","I kal main para piringa ibal kobe ka di i tenangwa, ta paikinangwa paangwa, malia main i kanebinwa. I yal iru milinga, God milungwa gul pisere ere ime unga pire gi dibinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu ka di kole ere iru di gawlima kobe tongwa, “Malia i yal kobe pire gi di na tenba, ");
INSERT INTO gvf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","kamin kaun ta u maala namia, ena kamin kaun iray ibal i si kiranin bilangure, i yal kobe u sutaw nanwa. I yal kobe inin inin ere ogin ain nangire, na taran tawle milalba, na Abe bole milebilga na inan tawle ta milekiralwa. ");
INSERT INTO gvf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","I yal kobe bole pena gale na tere den miriin suna ura dinangure kamin wai taanama dire, ka iru di i yal kobe teiwa. Gariba gul ibal gain giil pire i yal kobe tenamba, gariba gul yal singaba, Satan, na yalini si ime ere i sutaw ere tobinga, ena i yobilaan bile milo.” ");
INSERT INTO gvf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ena Yesu ka i di pisere kamin mina kane yebe ere ka iru dungwa, “Na Abe, ‘Na baan ta nanwa,’ dinga kamin kaun i kaya u bawa dungure, i yobilaan bil i maribe ere i kaanin gale yebe erala dire, i Wanin, na yobilanan bil i maribe ere na kaanan gale yebe ere na to. ");
INSERT INTO gvf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","‘Ibal kobe kenin ero,’ di na tenga mere, ibalin kobe mile painangwal painama dire, i yobilaan bile na tenwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","I God taran kirara kawen milinga ibal kobe iru pire pol sire, te i yal ta Yesu Kirisito nusi ime eringa, ibal kobe yalini para pire pol sinangwa, ena mile painangwal painamua. ");
INSERT INTO gvf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","I yobilaan bil bilinga, na gariba gul ure i maribe eriwa. ‘Na konagi ero,’ di na tenga mere, na kaya ere wei siwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na Abe kamin kaya wen gariba gul ere yekebinga kaun, na i naabilungwa bole milere, yobilaan bil biliga malia i milinga gul na para iru milama dire, i iru ere na to. ");
INSERT INTO gvf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“‘Gariba gul ibal kobe milungwa i ibalin kobe taw paale suna ere irere i kenin ero,’ di na tengire, i guun kan na di maribe ere ibalin kobe teiwa. I ibalin kobe kobaan milinba, ‘I kenin ero,’ di na tengire, ibalin kobe i ka dinga wiina eremua. ");
INSERT INTO gvf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na ka dire kal para eriga, i yobilaan bile na toma di ibalin kobe iru piremua. ");
INSERT INTO gvf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","I kal para nil si na tenga mere, na nil si ibalin kobe tegire, pire nomanin suna yomua. Na i milinga gul pisere uga, ibalin kobe kawen dima di piremua. I na nusi ime eringa, ibalin kobe pire gi dimua. ");
INSERT INTO gvf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ibalin kobe i aa ki di tenana dire, na ana di i teiwa. Gariba ibal para muru nomanin pire na ana di i tekebinba, ‘Ibalin taw kobe kenin ero,’ di na tere kobaan i milinga, ibalin kobi nomanin si pire ana di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na ibalan kobe para kobaan na miliga, i ibalin kobe para milemua. Te i ibalin kobe para kobaan i milinga, na ibalan kobe para milemua. Na yobilaan bil biliga, ibalin kobe i maribe ere ibal tomua. ");
INSERT INTO gvf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ena malia na i milinga gul ure gariba gul baan tawle mile pairalba, ibalin kobe gariba gul imo mile painamua. Na Abe kabin sire wai wen milinga, ibalin kobe iru imo mile painangwa, i kenin ere kane milo. Na i bole taran milebilga mere, ibalin kobe iru milama dire, i yobilaan bil pai na tenga mere, yobilaan bil bile kenin ere kane milo. ");
INSERT INTO gvf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na ibalin kobe bole milebinga i yobilaan bile na tengire, na ibalin kobe kenin ere miliwa. Na ibalin kobe kuman kine kinin si tegire, ibalin kobe para mun kal waa na tekimba, ka main minin ganin pi nima nama dire u main nala dungwa yal, yalini taran tawle u main namua. ");
INSERT INTO gvf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Dimba malia i milinga gul kwi urabinga, ena na miriin paire gun ye milebinga mere, ibalin kobe iru milama dire, gariba gul mile ka iru diwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","I ka kebe ere na tenga, di ibalin kobe teiwa. Tegire gariba ibal ka main ta pirekungwa, na bole pena gale tekiga mere, ibalin kobe iru milungwa, ena gariba ibal ka main ta pirekungwa, den gule ibalin kobe tomua. ");
INSERT INTO gvf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","‘Ibalin kobe awli i milinga gul po,’ dire ana di i tekeralba, ‘I ibalin kobe kal digan ere taalime erekinama dire, i kenin ere kane milo,’ di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na gariba ibal ka main ta pirekungwa, bole pena gale tekega mere, ibalin kobe para iru milemua. ");
INSERT INTO gvf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","I ka dinga kawen kirara dimia, ena ibalin kobe i konagi taran ere milama dire, i kal iru ere to. ");
INSERT INTO gvf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","I na nusi gariba gul eringa mere, na ibalin kobe nusi gariba baan baan eriwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","I kirara kawen dinga pirere, te ibalin kobe para i konagi taran ere milama dire, i kal ta ere na terala di piranga, ‘Kal i ere na to,’ diwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ibalin kobe i aa ki di tenana dire ana di i tobinba, ibalin kobe ka main dinangure ibal kobe taw pire gi di na tenangwa, ena pire gi dinangwa ibalin kobe i aa ki di tenana dire, para iru ana di i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na Abe, ibalin kobe bole pena gale u taran pi milama dire, ana di i teiwa. I na bole pena gale u taran pi milebilga mere, ibalin kobe na yasu iru bole milabina dire, i iru ere to. I na nusi ime eringa, gariba ibal iru kawen pirama dire, ibalin kobe bole pena gale u taran pi milama di piriwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na yasu u taran pi milebilga mere, ibalin kobe para iru milama dire, i yobilaan bil bile na tenga mere, na yobilaan bil bile ibalin kobe teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ibalin kobe kirara u taran pi milama dire, na pena gale ibalin kobe tegire, i pena gale na tenwa. I na nusi ime eringa, te den miriin na tenga mere, i ibalin kobe para iru tenga gariba ibal iru pirama dire, ibalin kobe kirara u taran pi milama di piriwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Na Abe, ibalin kobe kobaan i milinba, ‘Kenin ero,’ di na tengire, na pi milalga ain ibalin kobe para pi milama di piriwa. Kamin kaya wen gariba ta ere yekebinga kaun, i den miriin na tenga, ena yobilaan bil bile na tenga ibalin kobe kanama dire, para pi milama di piriwa. ");
INSERT INTO gvf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Na Abe, i kabin sire wai wen milinwa. I milinga main gariba ibal pire pol sekimba, na i pire pol sigire, te i na nusi ime eringa ibalin kobe pire pol simua. ");
INSERT INTO gvf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","I den miriin na tenga mere, ibalin kobe para iru den miriin tenama dire, te na bole pena gale ibalin kobe terala dire, i guun kan kaya di maribe ere tere pare ere milalwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ena Yesu ka dungwa i ana di pisere, yalini te gawlima kobe bole pire nil nuule ta kaan Kidiron baure, ere kole ongwa. Kole pirere baan ta eri obin kulere gul balungwa suna pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Eri main dungwa i, Yesu te gawlima kobe morin u ku bilungwa, ena bale taal sungwa yal Yudas ain iray para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kanemia ena Yudas eri main iray ongwa. Yuda ka main kenin erungwa yal bil kobe te Parasi kobe mile, “Simil nen te ka main ogu el kwi nu milungwa yal kobe awli po,” di Yudas tongure, yalini awli ongwa. Yalin kobe simil te kuba aa te ire pirere enderin derin aa te ire, te kewa gale ire ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ibal kobe kalkan para ere Yesu terala di pirungwa Yesu inin piremia, ena ibal kobe ungwa Yesu maala pire ka iru di tongwa, “I ibal kobe ibena waa duune?” ");
INSERT INTO gvf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Dungure ibal kobe mile, “Nasarete ai nen Yesu, waa duubinwa,” dungwa. Dungure yalini mile, “Yal iray na miliwa,” dungwa. Bale taal sungwa yal Yudas ibalin kobe bole ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu mile, “Yal iray na miliwa,” dungwa kaun i, ibal kobe para si pile dire mun kol pi paangwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu kwi sirin bile pire iru di tongwa, “I ibal kobe ibena waa duune?” Dungure ibal kobe mile, “Nasarete ai nen Yesu waa duubinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dungure Yesu ka iru dungwa, “‘Yal iray na miliwa,’ kaya di i teiwa. I ibal kobe na waa duunga, ena na ibalan taw bole milebilga ibalin kobi ‘Ere po,’ di to.” ");
INSERT INTO gvf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu kaun ta gome mile, “Na Abe, i ibalin kobe kobaan milinba, ‘I kenin ero,’ di na tenga, ibalin kobi muru mun kal waa na tekenamua,” dungwa i pi nima nama dire, ka iray dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita di kuba pera aa tere i maribe ere Yuda ka main kenin erungwa yal bil, yalini nil konagi yal, kiraan wen kol sirere dual kule erungwa. Nil konagi yal i, kaan Malkas dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu ka iru di Pita tongwa, “I di kuba pera kwi gal gule ain yeyo. Na Abe mile, ‘Na giil piranwa,’ dungwa i ibal kobe na giil pirekenama di pirino? Pisero, na giil piralwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dungure simil nen kobe te simil nen yal singaba te Yuda ka main el kwi nu milungwa yal kobe, yalin kobi Yesu kaale gi dire kanin sungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kanin sire goma awli pi Anas milungwa gul ongwa. Kamin kaun i Kayapas mile, Yuda ka main kenin erungwa yal singaba milungure, Anas yalini imaunbi milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapas gome mile ka iru di Yuda ibal yal singaba di tongwa, “Ibal kobe wai milama dire, yal taran si gulangwa para wai painamua.” ");
INSERT INTO gvf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ena simil nen kobe Yesu awli ongure, Saimon Pita te Yesu gawlima yal ta para, mun kol duulin bile ongwa. Yuda ka main kenin erungwa yal bil Yesu gawliman yal ta iray guman kanemia, ena yalini Yesu duulin bile pi ala omba, ");
INSERT INTO gvf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita kana giran suul milungwa. Yal ta iray ala pire Pita ala unama dire ka di nil konagi gi ta kana giran kenin ere milungwa tongwa. Yuda ka main kenin erungwa yal bil gawlima ta iray guman kanungure di tongwa, abalini ‘Owa,’ dungure yalini Pita awli ala ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ongure kana giran milungwa gi iray ka iru di Pita tongwa, “I yalini gawlima kobe ta milin mo, milekene?” Dungure Pita ka di kole ere iru dungwa, “Na ta milekiwa.” ");
INSERT INTO gvf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ena kamin gwi erungure nil konagi ibal te el kwi nu milungwa ibal kobe para, enderin gale paalungwa. Galere ale milere gwi gulungwa enderin pirungure miin sungwa. Pita ibalin kobe bole milere enderin pirungure miin sungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ena Yesu gawliman kobe milungwa te yalini ka main nil si tongwa, Yuda ka main kenin erungwa yal bil sirin bile Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu ka di kole ere iru dungwa, “Ibal kobe para pirama dire, ai penin mile ka di maribe eriwa. Yuda ibal u ku bilungwa ain, ka main ogu mege te bil para ka nil si te milegal miliwa. Na ka diga aal kule ka ta nil si tekiwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tameran ka sirin bile na tene? Na ka diga pirungwa ibalin kobe, i sirin bile piro. Na ka diga ibalin kobe piremua.” ");
INSERT INTO gvf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ka dungwa i, el kwi nu milungwa yal ta pirere Yesu guman mina sire, ka iru dungwa, “I Yuda ka main kenin erungwa yal bil ka di kole ere tenga, tameran ka digan iru di tene?” ");
INSERT INTO gvf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dungure Yesu ka iru di yalini tongwa, “Malia ka digai ka digan ta painangwa, ena ibal kobe abila milungwa di maribe ero. Eranba na ka diga i kuunin painangwa, ena tameran na sine?” ");
INSERT INTO gvf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kal iru eremia, ena Yesu kan kule paalungwa Anas anu si Kayapas milungwa gul erungwa. Kayapas Yuda ka main kenin erungwa yal bil milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ena Pita gwi gule enderin pire milungwa, ena ibal kobe ka iru di Pita tongwa, “I yalini gawlima ta milin mo milekene?” Di tongure Pita mile, “O, o na ta milekiwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dungure Yuda ka main kenin erungwa yal bil yalini nil konagi yal ta milere, Pita yal ta kiraan dual kule erungwa yal iray, enin kobe yal ta milere, ka iru di Pita tongwa, “I yalini bole eri main milinga, na i kanebina di pirebinba?” ");
INSERT INTO gvf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dungure ena Pita mile, “Na ta milekiwa,” dungure korale gin taran be dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ena kwimile taanima ibal kobe Kayapas ogin pisere, Yesu awli pi Orom gabman yal bil ogin ongwa. Yuda ibal yal singaba kobe ogu iray ala ta pekungwa. Kile kaman ka manaa dungwa ta duulin bile ta erekire, te Yuda ka main komina bil nenama dire, ogu iray ala ta pekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ala ta pekemia ena Pailete ere mena ure ka iru di tongwa, “I ibal kobe tameran yalini ka kol ere terala dire awli une?” ");
INSERT INTO gvf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dungure ibal kobe ka di kole ere iru dungwa, “Yalini kal nigi dongwa ta erekinangwa, awli abila ta ukurabinba.” ");
INSERT INTO gvf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dungure Pailete ka iru di tongwa, “I ibal kobe inin yalini awli pire, i inin ka main paangwa mere pire ka kol ere to.” Dungure Yuda ibal yal singaba ka iru di tongwa, “Na yal kobe ibal ta si gulabinga, Orom ibal kile kaman ka paangwa manaa dimua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yesu goma mile, “Ibal kobe na si gulangwa main mere di maribe eriwa,” dungwa iray, pi nima nama dire kal iru u pilau dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailete kwi pi inin ogin ala pire, “Yesu awli wo,” di gala dungure, awli ungure iru di tongwa, “I Yuda ibal yal bil kawen i milino?” ");
INSERT INTO gvf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Dungure Yesu ka di kole ere iru di tongwa, “I inin nomanin si pire ka iru din mo, ibal taw ka nil si i tongure, ena i ka iru sirin bile na tene?” ");
INSERT INTO gvf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dungure Pailete ka iru di tongwa, “Ayo, na Yuda ibal milebina di pirino? Pisera. I inin enin taw kobe, te Yuda ibal ka main kenin erungwa yal bil kobe i awli na miliga gul umia, ena i takal erine?” ");
INSERT INTO gvf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dungure Yesu ka iru dungwa, “Na kenin ere ke milebinga ainan, gariba maina ta dekemua. Maina dinangwa, ena na gawlimanan kobe kura bilamua. Na kanin sire awli Yuda ibal ta tekenama dire, na gawlimanan kobe kura bilamua. Bilamba na kenin ere ke milebinga ainan gariba maina ta dekemua.” ");
INSERT INTO gvf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dimia ena Pailete mile, “I ka iru dina, ena i gariba ta yal bil milino?” dungure Yesu ka di kole ere iru dungwa, “I ka iru dingi, na iru ta dikiwa. Kirara kawen dungwa na dinama dire, na mina na kule yongure, gariba gul u maribe pi miliwa. Kirara kawen dungwa mere, ibal main i pirungwa, ibalin kobi na ka diga piremua.” ");
INSERT INTO gvf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dungure Pailete ka iru sirin bile Yesu tongwa, “Kirara kawen dungwa main tamintan paame?” dungwa. Dire kwi ere mena pire ka iru di Yuda ibal kobe tongwa, “Kal ki erangwa yalini kal ta erekima di kania, ena ka kol main ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dimba komina bil nenga kaun iray, na morin morin kanin paangwa yal ta gule eriwa. Yuda ibal yal bil i, na kanin gule ere tenama di pirino?” ");
INSERT INTO gvf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dungure ibalin kobe gala bil dire iru dungwa, “Yalini pisera, yal ta Barabas kan gule ere na to.” Ena Barabas kunibe nongwa yal milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ena Pailete Yesu awli pire, “Kuba galan yongwa Yesu gain mina so,” dungure sungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sire simil nen kobe kan galan yongwa galin ware, gibilin mina kaw tere galsuna nobe mayan gi kulungwa sigi di tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tere ka iru di yalini tongwa, “Ayo, Yuda ibal kobe yal bil wen milungwa paamio.” Di tere pi maala pire yalini pawnin mina de dage sungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailete kwi ere mena pire ka iru di ibalin kobe tongwa, “Ena i ibal kobe kane milo. Kal ki erangwa yalini kal ta erekima dire, na kanebinba, i para iru kanana dire, kwi awli abila urala erebinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dungure ena Yesu kan galan yongwa galin ware gibilin mina kaurere, galsuna nobe mayan gi kulungwa sigi dire ungwa. Ungure Pailete ka iru di ibalin kobe tongwa, “Kan diga yal iray milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dungure Yuda ibal ka main kenin erungwa yal bil kobe, te yalin kobe el kwi nu milungwa yal kobe para, Yesu ungwa kanere gala bil dire iru dungwa, “Eri pera mina si gulo, eri pera mina si gulo.” Dungure Pailete ka iru di yalin kobe tongwa, “Kal ki erangwa yalini kal ta erekima di kania, ena i yal kobe yalini awli pire eri pera mina si gulo.” ");
INSERT INTO gvf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dungure Yuda ibal yal singaba kobe ka di kole ere iru dungwa, “Yalini mile, ‘Na God Wan miliwa,’ dungwa ena na ibal kobe kile kaman ka iru di paalungwa, ‘Ka iru dungwa yal iray si gulo,’ dungwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ka dungwa i, Pailete pirere kuril taw ama pire kole yere ");
INSERT INTO gvf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kwi pi gabman ogin ala pire ka iru di Yesu tongwa, “I milinga, alde mile une?” Di tomba, Yesu pire unin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailete ka iru di Yesu tongwa, “Tameran i pire unin si miline? I kan gule ere i tere, ‘Ere po,’ dirabinga mo, yal kobe i eri pera mina, ‘Si gulo,’ dirabinga, Orom yal bil Sisa yobilaan bile na tomua. Kal iru erabinga main i, i ta pirekeno?” ");
INSERT INTO gvf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dungure Yesu ka di kole ere iru dungwa, “Kamin ibe God yobilaan bile i ta tekenangwa, i kal iru ta ere na tekenanba. Main iru paimia, ena yal ta na awli pi i tongwa yalini kal digan ere taalime erungwa pirin bilkaw paimua. Paingure i pirin tawlita pai i tomua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ka dungwa i, Pailete pirere nomanin binanbile sire Yesu kan gule erala di pirimba, Yuda ibal kobe gala bil dire iru dungwa, “Yal iray kan gule ere tenanga, ena i Orom yal bil Sisa ye nongwa yal, i ta milekenanwa. Yal ta mile, ‘Na gariba gul ta yal bil miliwa,’ dinangwa Orom yal bil Sisa kaymin yal milamua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ka dungwa i, Pailete pirere, ena Yesu awli mena pire yal bil ka kol pirungwa bol mina amin di milungwa. Bol iray kaan Kobile Wiige Sungwa dimba, Kibiru ka paangwa Gabata yongwa paangwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kamin kaun i omale kaun milimba, kamin gire taanangwa ena komina bil iray ki nenangwa kaun dinangwa. Pailete ka iru di Yuda ibal kobe tongwa, “I ibal kobe yal bil milemia kano.” ");
INSERT INTO gvf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dungure ibal kobe gala bil dire iru dungwa, “Awli baan ta pire si gulo. Awli baan ta pire si gulo. Eri pera mina si gulo.” Dungure Pailete ka iru di ibal kobe tongwa, “I ibal kobe yal bil eri pera mina na si gulama di pirino?” Dungure Yuda ibal ka main kenin erungwa yal bil kobe ka di kole ere iru dungwa, “Orom yal bil Sisa, na ibal kobe yal bil yalini taran milema di pirebinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ena Yesu eri pera mina si gulama dire, Pailete awli pi simil nen kobe tongwa. Tongure yalin kobe Yesu ke mile milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu ere mena pire eri pera yalini inin kawi ire, ai ta kaan Ibal Gibilin Yobilaan Ai, u bawa dungwa. Ai iray Kibiru ka paangwa, kaan Golgota yongwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kol iray yal kobe Yesu eri pera mina bili nil sirere te yal sutan para kole kole eri pera mina bili nil sungure, Yesu baan suna si yongwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailete ka minin ganin bile eri pera bolimina si paalere ka iru dire bilungwa, “Nasarete ai nen Yesu, Yuda ibal yal bil wen milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu eri pera mina si gulungwa ai, ogu ai bil maala dungwa, ena Yuda ibal binanbile ka minin ganin bile paalungwa iray kere pirungwa. Ka minin ganin Kibiru ka, te Orom ka, te Giriki ka para bilungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yuda ka main kenin erungwa yal bil kobe iru di Pailete tongwa, “‘Yuda ibal yal bil wen milemua,’ iru dire bilekenanba, ‘Yalini na Yuda ibal yal bil wen miliwa dimua,’ dire bilo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dungure Pailete ka di kole ere iru dungwa, “Na biliga mere, imo di painamua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Simil nen kobe Yesu eri pera mina bili nil si paalere pare, yalini gal irabina dire, kawlaa sirere taminin sui sui yere inin inin ingwa. Imba Yesu galsuna araway ta ulin ta dekungwa, ");
INSERT INTO gvf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ena simil nen irere ka diria ere iru dungwa, “Gal aa dinaa dikirabinwa. Yal ta inama dire, sandu sirabinwa.” Ka main minin ganin pi nima nama dire, kal iru erungwa. Ka main minin ganin goma bilungwa paangwa, iru bilungwa paangwa, “Na gal yalin kobe inin obin si irere, te na galsuna yal ta inama dire, sandu simua.” Iru bilungwa ena simil nen kobe iru erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu eri pera si gulungwa main i, abal kobe iru pi ale milungwa. Yesu man te yalini man kebin te Kilopas ebinbi kaan Maria, te Madala ki paangwa abal Maria, abal iru pi ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu gawlima ta den miriin tongwa yal iray, Yesu man bole milungwa kanere, Yesu ka iru di man tongwa, “Abala, i malia wanin yalini milemua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Direre di gawlima kobe yal ta tongwa, “I manin u milemia kano.” Dungwa kaun iray, gawlima kobe yal ta abalini kawn kule kenin ere tere, aa te wai ere te milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ena kalkan erala di pirungwa, “Kaya wei simua,” dire Yesu iru pirere, te ka main minin ganin ta goma bilungwa u maribe nama dire, Yesu mile, “Na nil guliwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Muine gawlin ta main i dungwa nil wain digan kule muulungure, nil kule nongwa gal nil wain digan kulere bili waaki dire, Yesu nenama dire aa te mina ere giran mina si daangwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu nil wain digan tongure iru dungwa, “Malia na gariba gul mile konagi eriga para wei simua.” Dungure naan gorawal giire gulungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ena Sare kaun komina bil iray ki nenangwa kaun u maala omia, ena yal sutakobe eri pera mina Sare kaun imo ta dekenama dire, Yuda ibal yal singaba kobe ka iru sirin bile Pailete tongwa, “Yal sutakobe gin taran gulangwa i main erama dire, yalin kobe kawn si bege do.” ");
INSERT INTO gvf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dimia ena simil nen kobe ure yal ta Yesu binan kole milungwa, yalini kawn si bege dire te yal ta para Yesu bole si gulungwa yalini kawn para si bege dimba, ");
INSERT INTO gvf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","simil nen kobe Yesu milungwa gul ure Yesu kaya gulema di kanemia, ena yalini kawn si bege ta dekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ta dekimba simil nen ta kolaa si Yesu daan mina bilungure, ena gin taran mayan te nil para garu dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kal i u maribe ongwa na kanere, di maribe ere kawen diga. Ka pore iray keranga i ibal kobe pire gi dinana dire, di maribe ere i teiwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ka main minin ganin pi nima nama dire, kal iru u maribe ongwa. Ka main minin ganin goma bilungwa, iru bilungwa paangwa, “Yalini yobilaan si bege ta dikinamua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Te ka main minin ganin ta goma iru bilungwa paangwa, “Ibal kobe yal ta sinangwa, ibalin kobe pi bilungwa yal kane milamua.” ");
INSERT INTO gvf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ena kal iru erungure pare, Arimatia ai nen ta kaan Yosepe yalini Yesu gawliman milimba, Yuda ibal yal singaba kuril pire tere di maribe erekungwa. Yalini pi Pailete milungwa gul pirere, Yesu yobilagi irala dire, sirin bile pirungwa. Sirin bile pirungure Pailete, “Owa,” dungure pirere Yesu yobilagi i ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yal ta kaan Nikodimas goma wen gilaa kaun ta pi Yesu milungwa gul ongwa, malia yalini Yosepe bole pirere, eri sutan kaan mea te alos, niriin minanin wai sungwa kule yuungwa. Eri niriin iray obin wen dongwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yal sutan i Yesu yobilagi irere, eri niriin iray gal pege wai dungwa minai bilere, Yesu gain mina yobilungwa. Yuda ibal yobilagi maul si yerabina dire, iru erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu si gulungwa ai eri kulungwa gul suna ali si gulungwa. Yene yobilaan kobile giran ta goma ibal ta yekungwa, eri kulungwa gul suna ali dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yuda ibal Sare kaun u maala ongure, te yene yobilaan kobile giran maala dimia, ena Yesu kobile giran ali yongwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ena Sarebil kaun kwimile taanima wen kamin kama si dungure, Madala ai abal ta Maria pi yene yobilaan gul pirere, kobile milin kobile giran si pere dungwa kaya yawle erungure kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kanere mugu di pire Saimon Pita te Yesu gawlima ta den miriin tongwa yal iray, yal sui milungwa gul pirere ka iru di yal sui tongwa, “Ibal kobe ure Yesu Singaba yobilagi kaya i ongure, ibalin kobe yongwa ai ta kanekibinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dungure ena Pita te gawlima ta bole pi yene yobilaan gul kanala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yal sui iray mugu di omba, gawlima ta mugu goma di pire kobile giran yene yobilaan gul kaya u bawa dungure, Pita eme ungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Gawlima ta iray yaa gobin bile mile gal pege wai dungwa kanimba, pi ala ta pekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita eme ure gin taran pi yene yobilaan kobile giran ala pire gal pege wai dungwa kanere, ");
INSERT INTO gvf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","te gal ta Yesu gibilin mina yobile yongwa para imo dungwa kanungwa. Gal iray te gal pege wai dungwa ai taran ta dekimba, dain bile baan ta dungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pita iru kanungure, ena gawlima ta yene yobilaan gul kaya u bawa dungwa, yalini para pi ala pire kanere, Yesu alungwa kawen dima di pire, pire gi dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iru pirimba ka main minin ganin ta, “Yalini alamua,” dire goma bilungwa malia main wen pire pol sekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gawlima sui kal iru erere pare, ere ogin ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ena Maria yene yobilaan gul mena ale mile kay miingwa. Kay mi mile yaa gobin bile yene yobilaan kobile giran ali nore ere ");
INSERT INTO gvf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","angel sutan gal pege sigi dungwa kanungwa. Angel sutan i Yesu yobilaan goma dungwa gul milungure, te angel ta gibilin kol milungure, te ta kawn kol milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Angel sui mile ka iru sirin bile abalini tongwa, “Abalkuno, i tameran kay miine?” Dungure abalini ka maan dire iru dungwa, “Ibal kobe na Singaba yobilaan i baan ta ongure, na ta kanekiwa.” ");
INSERT INTO gvf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ka iru dire pare sinaa dire Yesu ale milungwa kanimba, Yesu milema di pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu mile ka iru sirin bile abalini tongwa, “Abalkuno, i tameran kay miine? Ibena waa duune?” Dungure yalini eri kulungwa gul kenin erungwa yal milema di, abalini iru pirere ka iru di tongwa, “Yalkuno, i yalini baan ta i nanga, ena yenga kol di na tenanga pi iralwa.” ");
INSERT INTO gvf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dungure Yesu mile, “Maria,” dire kaan galungure, abalini si kiruul sire ka iru di Yesu tongwa, “Ka nil si tongwa yalo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dungure Yesu ka iru di abalini tongwa, “Na Abe milungwa gul kwi ole kaya pekega, ena i na aa tekio. Diiba i pi na enan kobe iru di to, ‘I Nenin na Abe, te i na God ena yalini milungwa gul ibe kwi ere nalwa.’” ");
INSERT INTO gvf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dungure ena Madala ai abal Maria, pi Yesu gawlima kobe milungwa gul pire, “Yesu Singaba kaniwa,” di yalin kobe tere te, “Ka iru di to,” dungwa mere di maribe erungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sare bil kaun iray gilaa taanima, gawlima kobe Yuda ibal milungwa kuril pirere ogu ala mile kol mama yaalungwa. Iru milungure Yesu u maribe pi mile, “Mile dinio. Denin miriin ura dire milo,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Direre pare aan te daan i maribe erungwa. Gawlima kobe inin Yesu Singaba kanere, wai pire gun yongwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu kwi ka iru di tongwa, “I milinga gul wai wen milanwa. Na Abe na nusi erungwa mere, na i nusi eriwa.” ");
INSERT INTO gvf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iru dire pare giran miin pu di yalin kobe tere iru di tongwa, “God Kegemama Iban i teya, ire den miriin suna yeyo. ");
INSERT INTO gvf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ibal kobe kal digan ere taalime erungwa kire di erangire, u namua, te kire di erekinangire, ta u pekenamua.” ");
INSERT INTO gvf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ena Yesu u maribe ungwa kaun iray gawlima kobe yal ta kaan Tomas, kaan ta Pual Gaan, yalini gawlima kobe bole ta milekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ta milekungwa gawlima kobe taw mile, “Yesu Singaba kanebinwa,” di yalini tongwa. Tomas ka iru di yalin kobe tongwa, “Yesu aan bili nil sungwa nimbona bilin kane anan milin sin bile, te yalini daan bilin paangwa anan sin bilalga, ena pire gi diralwa. Imore pire gi diralga pisero.” ");
INSERT INTO gvf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sare ta i para wei sungure, gawlima kobe te Tomas bole ogu ala iray kwi milungwa. Kol mama yaalimba, Yesu ala ure yalin kobe milungwa suna ale mile, “Mile dinio. Denin miriin ura dire milo,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Direre ka iru di Tomas tongwa, “I anin milin dire dire na anan sin bile kano. Te i anin kwi dire dire na daanan ali sin bile piro. Pire gi di na tekinga pisere, pire gi di milo.” ");
INSERT INTO gvf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dungure Tomas maan dire ka iru di tongwa, “I na Singaba mile te na God para milinwa.” ");
INSERT INTO gvf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dungure Yesu di yalini tongwa, “Na kaninga pire gi dino? Ibal kobe na kanekire pire gi di na tenangwa, yalin kobe wai pire gun yenamua.” ");
INSERT INTO gvf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Dungure Yesu gawlima kobe bole milungwa kal guman kwi dungwa taw ama binanbile erimba, buku iray minin ganin ta bilekigi. ");
INSERT INTO gvf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yesu mile God konagi erungwa yal Kirisito milere, te God Wan para milungwa, i ibal kobe iru pire gi dinana dire, na ka pore minin ganin biligi. Pire gi dinanga, ena Kirisito yobilaan bile i tenangure, dorimil wai wen mile painangal painanga. ");
INSERT INTO gvf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ena kal iru ere wei sungure pare, Yesu nil benge ta kaan Taibirias ure yalini inin kwi u maribe pi gawlima kobe tongwa. U maribe pi tongwa main iru paangwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita milungure, te Tomas yalini kaan ta Pual Gaan milungure, te Galili gariba gul suna ai mege ta kaan Kena, gariba iray nen ta kaan Nataniel milungure, te Sebedi wan sui milungure, te gawlima sui ama milungure, te gawlima kobe iru bole para milungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Milungure Saimon Pita mile, “Na pi nil kabe sirala nalwa,” di yalin kobe tongure, yalin kobe, “I bole para nabinwa,” dungwa. Dire pare pi sipe ala pire sirala di omba, gilaa kaun iray nil kabe wen ta sekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Are nol erungure, ena Yesu nil benge binan ale milimba, gawlima kobe Yesu milema di pirekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pirekungure Yesu ka iru di yalin kobe tongwa, “Yal kobe, nil kabe ta sikino?” Dungure yalin kobe mile, “Na ta sekebinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dungure yalini ka iru di yalin kobe tongwa, “Nil kabe sungwa gal pusi anin wen kol nil ali eranga, ena nil kabe sinanwa.” Dimia ena nil kabe sungwa gal pusi nil ali erungure, nil kabe binanbile simia, ena nil kabe sungwa gal i sipe ala erala di erungwa obin domia, ena kuunin ta erekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesu gawliman ta, den miriin tongwa yal iray ka iru di Pita tongwa, “Yal i na Singaba Yesu milemua.” Dungwa i Saimon Pita pirere koray tawle pire galsuna sigi dire ole si yaa nil ali sire, Yesu milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Omba gawlima taw kobe sipe bolin mina mile, nil kabe sungwa gal gure pala di mena erala dungwa. Nil benge makalua tayan ta milekungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yalin kobe pi makalua gul milere enderin de dungure, nil kabe te komina birete minai galungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kanungure Yesu ka iru di tongwa, “Malia i nil kabe singa i taw i yuwo.” ");
INSERT INTO gvf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dungwa ena Saimon Pita pi sipe ala pire nil kabe sungwa gal gure pala di makalua gul binan pire, i mena erungwa. Nil kabe bil binanbile, wan kandret na pipti tiri, sungwa gal ali mile paamba, gal kan si ole ta dikungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu mile, “Komina nenana wo,” di yalin kobe tongwa. Gawlima kobe mile, “Yalini na Singaba Yesu milemua,” di kanemia, ena “I ibena miline?” sirin bile Yesu tenamba, gay gulungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Milemia ena Yesu pirere komina birete irere yalin kobe tere, te nil kabe galungwa ama tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu gulere alungure pare, goma ginin sutan u maribe pi gawlima kobe tere malia kwi u maribe ongure, u ginin sutakobe ongwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ena komina nongure pare, Yesu ka iru di Saimon Pita tongwa, “Yon wan Saimone, yalin kobi den miriin na tongwa mere, i denin miriin na te kora kulin mo?” Di tongure Pita, “Owa,” dire ka iru di yalini tongwa, “Singabo, na nomanin wai pire i tega i kaninwa.” Dungure Yesu mile, “Na gaan kobe bolima siipe siipe milungwa mere i kenin ere milo,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ka iru dire kwi sirin bile iru di tongwa, “Yon wan Saimone, i denin miriin na ten mo?” Di tongure yalini, “Owa,” dire ka iru di Yesu tongwa, “Singabo, na nomanin wai pire i tega i kaninwa.” Dungure Yesu mile, “Na ibalan kobe bolima siipe siipe milungwa mere, i kenin ere milo.” ");
INSERT INTO gvf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu ginin sutan goma ka di Pita tere, malia kwi sirin bile ka iru di tongwa, “Yon wan Saimone, i nomanin wai pire na ten mo?” Yesu ginin sutakobe, “I nomanin wai pire na ten mo?” di sirin bile Pita tomia, ena Pita nigi de pire guman yaare ka iru di Yesu tongwa, “Singabo, i kalkan para piringa, ena na nomanin wai pire i tega kaningirawa.” Dungure Yesu mile, “Na ibalan kobe bolima siipe siipe milungwa mere, i kenin ere milo. ");
INSERT INTO gvf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na kawen di i terala piro. I yal garamil milinga kaun i inin kin dere, te kol ta nala di piringa enba, yal dimanin milanga kaun i anin suala galangire, ibal ta i kanin sire kol ta nala pirekinga, ain i awli namua.” ");
INSERT INTO gvf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu ka iru dungwa, ena Pita gulangwa main mere di maribe ere tongwa. Iru gulangwa ena ibal kobe deminin karawal ere God tenangwa. Ena Yesu ka iru di yalini tongwa, “Na munan kol duulan bilana wo.” ");
INSERT INTO gvf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Gawlima ta Yesu den miriin tongwa yal na mile, goma Yesu binan kole komina ne mile, “Singabo, ibena bale taal si i tename?” dire sirin bile Yesu tega. Na Pita muna kol ugire, Pita si kiruul sire na kanere ");
INSERT INTO gvf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ka iru di Yesu tongwa, “Singabo, yal i we, takal ere yalini tename?” ");
INSERT INTO gvf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Dungure Yesu ka di kole ere iru dungwa, “Na kwi ime uralga kaun yalini mile painama di piral mo? Piralga i kanin paama di pirino? Pisero, i na munan kol duulan bilana wo.” ");
INSERT INTO gvf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ka iru dimia ena Yesu enin kobe mile, “Yal iray ta gulekenamua,” dire ka di kole kole erungwa. Erimba Yesu mile, “Yalini ta gulekinamua,” dire ka iru ta dikire ka iru dungwa, “Na kwi ime uralga kaun yalini mile painama di piral mo? Piralga i kanin paama di pirino? Pisero.” Dire ka iru tawle dungwa. ");
INSERT INTO gvf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Gawlima ta i Yesu kan dungwa, na yal iray milebingi. Milere ka minin ganin biliga i kawen kirara dungwa na ibal kobe para kanebinga. ");
INSERT INTO gvf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ena Yesu kalkan binanbile para i maribe erimba, ka pore iray para minin ganin bilalga buku binanwenbile dinangure, baan ta yerabinga gariba gul ai kuunin dekenama di pirega. ");
INSERT INTO gvf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Ena Tiopilaso, Yesu kawn kule konagi ere ka main nil si te milungwal milungwa. Mile paingure God awli kamin mina ongwa, Yesu iru erungwa mere goma ka pore minin ganin iru bile i tega. Nusi erungwa ongwa yal kobe, Aposel, Yesu kaya paale suna ere irere, God Kegemama Iban di Yesu tongwa mere kile kaman tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu eri pera mina gulere ale pare, nusi erungwa ongwa yal kobe, Aposel, milungwa gul u bawa dire u kwi ongwa ibal kobe pirama dire, kal naanin paangwa erungwa. Erere are kaun yal sui aan kawn muru milere, are kaun ta ta binanbile u bawa direre, God kenin ere ke milungwa mere di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Terere nusi erungwa ongwa yal kobe, Aposel, bole para milere ka naanin paangwa dire iru di tongwa, “Na Abe, ‘Ibal ta nusi i teralwa,’ dire aan kere yere di tongwa mere, na para goma di i teiwa. Di tobinga mere malia u maribe namia, ena i Yerusalem piserekire suul milo. ");
INSERT INTO gvf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yon nil wo bile i tomba, are kaun tawliga wei sinangure Yon nil bile tongwa mere, na Abe Kegemama Iban nusi ere i tenangure inanwa.” ");
INSERT INTO gvf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nusi erungwa ongwa yal kobe, Aposel, u ku bile milere iru sirin bile Yesu tongwa, “Singabo, gariba baan ta ibal Isirel nen kobe kenin ere ke milungwa, nusi baan ta erano?” ");
INSERT INTO gvf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dungure Yesu dungwa, “Are kaun ta te ba kaun ta kalkan iru erangwa, na Abe inin nomanin si pire yongwa i ta pirekenanwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pirekenanba God Kegemama Iban ere ime ure i den miriin suna nangwa, i yobilaan pai tenamua. Yerusalem ai te Yudia gariba gul, te Sameria gariba gul, te gariba kole kole para muru, i na ka main bolin kule ibal kobe tenanwa.” ");
INSERT INTO gvf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ena Yesu ka iru dungure pare, yalin kobe yalini kane milungwa ere kamin mina pire, kawa ta suna ali ongure yalin kobe Yesu ta kanekungwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesu ere yebe ongwa yalin kobe tena yuulin bile kane milungure, yal sutan gal pege sigi dire ale milere ");
INSERT INTO gvf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","iru dungwa, “Galili nen kobe, i tameran kamin mine imore tena yuulin bile kane miline? Yesu iray i milinga gul piserungure God awli kamin mina omua. Yalini kamin mina ongwa mere kwi ere ime unamua.” ");
INSERT INTO gvf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iru kanere pare yalin kobe kamin kuul ta kaan Olibe pisere, pi Yerusalem ogu ai maala dungwa kwi ongwa. Pirere Yuda ibal, “Sare kaun kol tayan warekio,” dungwa mere yalin kobe iru warungwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Warere kaya Yerusalem ai ala pirere pi ogin kulan ta mine ala ongwa. Yalin kobe kaan iru paangwa. Pita te Yon te Yemis te Endiru te Pilipi te Tomas te Batolomiu te Matyu, te Alpias wan Yemis, te yobilaan bilungwa yal kaan Saimon, te Yemis wan Yudas ");
INSERT INTO gvf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","yalin kobi iru, te abal taw kobe, te Yesu man Maria, te Yesu kebin kobe, ibalin kobe nomanin u taran pire ana di God te milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ena kaun iray Yesu gawlima kobe yal sui sui sui aan kawn muru u ku bilungure, Pita suna ali alere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Na enan kobe, goma God Kegemama Iban Yudas kal erangwa ka dungwa mere, Debiti giran mina dungure ka main minin ganin bilungwa iray u maribe omua. Ibal Yesu kanin sinama dire Yudas yalin kobe awli Yesu milungwa gul omua. ");
INSERT INTO gvf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yalini na ibal kobe bole pena gale ka main konagi para erebinwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Erere kal ki erungwa tobe ire, gariba gibilin sire gawl sire guman kol pire, kubin bile bugu dire de siribil simua. ");
INSERT INTO gvf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yalini kal erungwa mere Yerusalem ibal para pirere gariba iray kaan Akeldama yomua.” (Kaan iray Golin ka iru paangwa, Mayan Gariba Dimua.) ");
INSERT INTO gvf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Dire Pita ama iru dungwa, “Geril deminin si God tongwa buku, Sam, ta ali ka minin ganin iru bilungwa, ‘Yalini ogin po dinangure, ibal ali painangwa ta milekenamua.’ te ta ama iru bilungwa, ‘Yalini konagi erungwa, yal ta yalini ain pi milamua.’ ");
INSERT INTO gvf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ka iru bilemia ena yal ta Yudas ain pi milamua. Yal ta ain iray pi milangwa iwe, yal ta i, na yal kobe Yesu Singaba bole para mile mile milere, te Yon nil bile tongwa kanere, te God Yesu kamin mina awli ongwa kanere, yal ta iru milangwa pi Yudas ain milamua. Yalini te na yal kobe bole para, Yesu gulere alungwa bolin kule ibal kobe terabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita ka di piserungure ibal kobe yal sutan awli ungwa. Yal ta kaan Yosepe Yasitas yalini kaan kiibi Basabas dungwa, te yal ta kaan Mataya paangwa. ");
INSERT INTO gvf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ibalin kobe ana di God tere iru dungwa, “Singabo, ibal para wen nomanin te den miriin suna i kaninwa. Yudas ka main konagi pisere, te nusi erungwa ongwa yal, Aposel konagi para pisere pi enderin gaul ai omua. Ongure yal ta yalini ain nangwa, i maribe ere na to.” ");
INSERT INTO gvf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yal ta kaan i maribe erabina dire, Yosepe te Mataya kaan kobile mina bile gal gulungwa, kobile taran i maribe erungwa, ena Mataya kaan u maribe ongure yalini, te nusi erungwa ongwa yal kobe, Aposel, anan kole kole muru kawnan milin taran, konagi bole para erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ena Yuda ibal erin kaun ta kaan Pendikos u bawa dungure Yesu duulin bilungwa kobe para, baan ta u ku bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Milere teli dungwa ta, gwi bilkaw maare muubilin mu dungwa mere pirungwa. Pirungure goma kamin mina teli dire, gin taran ure ogu ala maa muulungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kal ta enderin baul sungwa mere u maribe pire u sutaw pire, ibal inin inin gibilin mina baul si paangwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ena God Kegemama Iban ibalin kobe den miriin suna pirere, sipapa sire yobilaan bile tongure inin ka pisere ibayal ka kowa kowa more more yuungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ena kamin kaun iray Yuda nen kobe God ka dungwa morin wiina erere, gariba kole kole pisere pi Yerusalem ai ki pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Milere ka derua poraal dungwa pirere, ibal binanbile u ku bilere yal kobe inin ka dungwa pirere ");
INSERT INTO gvf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","buul kunere iru dungwa, “Yalin kobe Galili nen kobe milimba, ");
INSERT INTO gvf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tameran na yal kobe inin inin ka dungwa pire milebine? ");
INSERT INTO gvf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Na yal kobe ibal iru milebinwa. Patia ibal, te Midia ibal, te Ilam ibal, te Mesopotemia ibal, te Yudia ibal, te Kapadosia ibal, te Pontas ibal, te Esia ibal, ");
INSERT INTO gvf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","te Pirisia ibal, te Pambilia ibal, te Isipi ibal, te Sairini ibal Ilibia gariba ki paingwa, te Yuda ibal, te ibal taw kobe Yuda ka main duulin bile warungwa Orom pisere u milungwa, ");
INSERT INTO gvf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","te Kiri ibal te Arebia ibal, na yal kobe abal bili bili ibal u milebinwa. Milebinba yalin kobe God kal naanin paingwa bolin kule tongure, na inan ka ta ta pirebinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ibal para buul kunere nomanin su su sire iru dungwa, “Kal erungwa ta main paime?” ");
INSERT INTO gvf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ibal taw iru dimba ibal taw kobe ka di sutaw ere tere, “Yal kobe wain nil nere, omilin maalemua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dimba Pita te nusi erungwa ongwa yal, Aposel, anan kole kole muru kawnan milin taran bole alere gala bil dire iru di ibal kobe tongwa, “Yudia nen kobe, te i ibal kobe Yerusalem ai ki pai milinga. kalkan u maribe ongwa i, ka dirala ere gule piro. ");
INSERT INTO gvf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na yal kobe, ‘Nil wain nere omilin maalemua,’ dire i iru di pirinba, kwimile taanima milebinga omilin maalekemua. ");
INSERT INTO gvf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kal iru erebinga mere God ka kebe yal, Yoel, goma iru dire bilungwa paangwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God iru dungwa, kaun ta eme na Ibanan nusi eregire, nil kuun sungwa mere ibal para milungwa gul unamua. Unangure wanin abilin kobe ka main bolin kule di maribe erangure, te yal garamil kobe kiibi kanungwa mere omilin mina u maribe nangwa kanangure, te yal dimanin kobe kiibi wen kanamua. ");
INSERT INTO gvf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ena kaun iray na Ibanan nusi eregire nil kuun sungwa mere unangure, nil erari yal abal kobe ire ka main bolin kule di maribe eramua. ");
INSERT INTO gvf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kalkan ibal kane buul kunangwa, kamin mina i maribe eralwa. Te gariba gul ibal main pirama dire, mayan te enderin te enegi i maribe eralwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kamin gariba bawa dire u taran nala di erangure, are si bilangwa te ba mayan baa dungwa mere dinamua. Dinangure pare God Singaba yobilaan bilungwa u maribe nangwa kaun u maala namua. ");
INSERT INTO gvf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yal ta na aa ki do, di God Singaba tenangwa, ena yalini yal ta i aa ki dinangure sigare kule u wai namua.’ God iru dungwa pire Yoel ka minin ganin bilungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isirel nen kobe, ka dirala piro. Yesu Nasarete ai ki paingwa yal i bole para milungure, God yalini nusi erungwa i kanana dire, God Yesu yobilaan bilungure yalini kal guman kwi dungwa erere, kalkan ibal kane buul kunungwa erere ibal main pirama dire kalkan para i maribe erungure, i yal kobe kaninwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesu kanin sungwa, goma wen God iru erala di nomanin si pirungure u maribe omua. I yal kobe yalini awli pi God ka dungwa wiina erekungwa yal kobe tere, ‘Eri pera mina si gulo,’ dingire si gulemua. ");
INSERT INTO gvf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","I iru ere yalini tenba, Yesu gulere alungwa God iru ere yalini tongwa. Gulungwa yongwa gul ta milekenangwa, God yalini awli baan ta omua. Ongwa iwe, yongwa gul kanin paangwa mere iru pai milamba, yobilaan bile alemua. ");
INSERT INTO gvf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yesu milungwa mere Debiti goma iru dungwa, ‘Na Singaba gumanan mina milinga morin i kaniwa. Na kuril pirekeralga i u maala milinwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Iru milinga, na nomanin suna gun yere ka diga wai pire diwa. Na gariba ibal miliiba i unangire na yobilanan te gaynan u kwi nangwa, na wai pire miliwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","I mile pai eringa mere na iru milala di pire miliga, na ibanan gulungwa yongwa gul ta milekenangure, simin nele kabe na ta nekenamua. ");
INSERT INTO gvf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kol wai bala di na tengire, mile pairabingal pairabinga i maribe ere na tenwa. Na i bole pena galebilga gun yere miriin pairalwa.’ Iru dimua. ");
INSERT INTO gvf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Na enan kobe, na yal kobe sanamoi Debiti milungwa mere, main di gawa dirabinwa. Yalini gulungwa maul ali yongure, na yal kobe yalini yongwa gul kane milebinga ibal milebinwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Debiti ka kebe yal milungwa, ‘I gawlin ta kenin erangwa yal bil milamua,’ dire God mabin mina aa taw sire iru di yalini tomua. Di tongure yalini Kirisito alama di pire, goma dimua. ‘God Kirisito gulungwa yongwa gul piserekire simin nele kabe yobilaan te gain ta nekenamua,’ dire, para iru pire dimua. ");
INSERT INTO gvf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu gulere alungwa, God kal main iru ere yalini tongwa, na ibal kobe para kanebinwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God Yesu kaan aa te yebe erungure, yalini inin aan wen kol milemua. Milungure God goma mile aan kere ye tongwa mere, yalini inin Kegemama Iban Yesu tongure, yalini nusi ere na yal kobe na tomua. Kuun sungwa mere na tongure ire mile kal main main erebinga i, i yal kobe kaninwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Debiti yobilaan te gain kamin ai mine ibe pekungwa yalini inin iru dungwa, ‘God Singaba iru di na Singaba tongwa, i ure na daanan wen kol amin di milo. ");
INSERT INTO gvf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Milingire i kaymin ibal yaa ime sinama di pire, iru ere i teralwa.’” ");
INSERT INTO gvf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pita dire ainere iru dungwa, “Kalkan iru u maribe ongwa ka ta dirala, Isirel nen kobe kawen piro. Yesu eri pera mina si gulinga, yalini Singaba te God konagi erungwa yal, Kirisito, u milama dire God iru ere tomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ena Pita ka dungwa i pire, ibal kobe miriin bil pirere iru di Pita te nusi erungwa ongwa yal kobe, Aposel, tongwa, “Na enan kobe, takal erabine?” ");
INSERT INTO gvf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dungure Pita maan dire iru dungwa, “I kal digan ere taalime eringa God kire di erama dire, i nomanin suna si kiruul sire te Yesu Kirisito kaan gale yebe ere, nil bile iyo. Iru eranga ena God yalini inin Kegemama Iban i tenangure inanwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","‘I te gawlin kobe, te gariba tayan ibal kobe na miliga gul ere wo,’ dire Yesu Singaba di ibalin kobe tenangwa, ena God aan kere yere, ‘Na inan Iban teralwa,’ dungwa mere inamua.” ");
INSERT INTO gvf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yesu main paangwa Pita kanungwa ka binanbile ama dire, Pita ibal kobe kiraan aa tere iru di tongwa, “Ibal malia maalere kal ki wen erungwa i piserangire, God i aa ki dinangure sigare kule u wai nanwa.” ");
INSERT INTO gvf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yalini ka main dungwa ibal binanbile pire gi dungure, nil bile tongwa. Tongure ibal binanwenbile, tiri tausen, kwi kwi maalungure Yesu ka main ibal taminin u bil ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nusi erungwa ongwa yal kobe, Aposel, ka main nil si tongwa pirere, te bole pena galere, te komina birete bege dire bole para nere, ana di God te milungwa. Iru erungwa oisa tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposel kalkan erungure ibal kobe buul kunungure, te kal guman kwi dungwa i maribe erungwa, ena ibal para wen God kuril de kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pire gi dungwa ibal para bole pena gale bona gana inin aa te nomba, imu dire ibal para maale gol aa te nongwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bona gana te gariba aa te nongwa, ibal tere kobile moni ire obin si, kal aa te nekungwa ibal tongure kuunin kuunin milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Are kaun kaun ibal kobe bole para pi Yuda ibal ka main ogu bil ala pire, ana di God tere te ogu dungwa dungwa mere komina birete bege dire nerere, te komina bole para obin si nere, gun yere wai wen pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ibalin kobe God deminin si tongure, ibal kobe para kanere wai pire gun ye tongwa. God ibal aa ki dungure sigare kule u wai pire, are kaun kaun Yesu ka main ibal taminin u bil ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ena ana dinangwa kaun ta, pu dungure, Pita te Yon bole Yuda ibal ka main ogu bil ana di God terala di ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yal ta man den suna mile kawn pema kiingure, kule nongwa kol ta warekire, kana giran ta kaan Wai Wen dungwa i amin dire, “Kobile moni na to,” dire kaan di ka main ogu bil ala nala di ongwa ibal tongwa. Are kaun kaun ibal kobe yalini ain iray awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pita te Yon ka main ogu bil ala nala di ongure, yalini kanere, “Kobile moni na to,” dire kaan di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Di tongure Pita yalini tena yuulin bile kane iru di tongwa, “Na yasu kano.” ");
INSERT INTO gvf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dungure yalin sui na kal ta na tenama di pirere, yalsui tena yuulin bile kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yalini iru pirimba Pita ka di yalini tongwa, “Na kobile moni ta aa te nekebinba, i aa ki di terabinwa. Yesu Kirisito Nasarete ki paingwa yal, yobilaan bile na tongwa na iru di i teiwa. I ale, kol warana po.” ");
INSERT INTO gvf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Iru dire aan wen kol aa ki dire aa te alere, kawn ki sungwa yal kawn te kawn gwaalin, gin taran u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yalini gin taran alere ole sire, kol ware pi yalsui bole ka main ogu bil ala para ongwa. Pirere ole si ware deminin si God tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yalini iru erungwa ibal para kanere iru pirungwa, ");
INSERT INTO gvf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“Yal ta kana giran, kaan Wai Wen dungwa, binan amin dire komina kaan dungwa yal i milemua.” Iru pirere yalini u wai ongwa, aya maya, dire kane buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yalini Pita te Yon duulin bile pire, kuul ale kaan Solomon Ai milungure ibal para buul kune u taminin si milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ibal iru erungwa Pita kanere iru di tongwa, “Isirel nen kobe, yalini u wai pi milungwa, tameran kane buul kunine? Yalini u wai pire kol warungwa, na yasu yobilaan bilebilga, te kabin sire wai wen milebilga aa te wai ere tekebilgire, i na yasu tena yuulin bile kanekio. ");
INSERT INTO gvf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebarakam te Aisaka te Yakobo te na sanamoi, yalin kobe God nilerari yal Yesu kaan aa te yebe eremua. Erimba i ibal kobe Yesu awli pi Pailete tengire Pailete, ‘Kan gule eralwa,’ dungure, i ibal kobe manaa dinwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kabin Sire Wai Wen Milungwa Yal, kal dime di erungwa i ibal kobe yalini ka di kile di mena ere, iru dinga, ‘Yal ta ibal si gulungwa kan gule ero.’ ");
INSERT INTO gvf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kwi milungwa kal ere yongwa yal, i ibal kobe yalini si gulinba, yalini alungwa God iru eremua. Iru erungwa mere kanebinga yal kobe milebinwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na yasu Yesu pire gi dibinga, yal ta, i yal kobe guman kaninga, u wai omua. Yalini para pire gi di Yesu tongware, u wai ongwa i yal kobe para kaninwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Na enan kobe, malia we. I kenin erungwa yal kobe kal ki ere Yesu tere pirekun erekungwa mere, i ibal kobe para eringa, na kanebinwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","‘Kirisito giil pire gulamua,’ dire God iru di ka kebe yal tongwa mere u maribe omua. ");
INSERT INTO gvf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","I ibal kobe kal digan ere taalime eringa God kire di erama dire, nomanin suna si kiruul sire God bole pena galo. Iru eranga wai wen milangire God pilaan pai i tere, te yalini Wan Yesu paale suna ere i tongure, Kirisito milungwa eme kwi nusi ere i tenamua. ");
INSERT INTO gvf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tenamba, ‘Malia Yesu kamin ai milungure na kalkan para wen kwi ere yeralwa,’ dire God goma wen iru di ka kebe yal kobe kabin sire wai wen milungwa tongure, ka kebe yalin kobe bolin kule tongwa mere u maribe nangure pare, Yesu kwi gariba gul unamua. ");
INSERT INTO gvf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Unangwa mere iwe, Mose iru dungwa, ‘I God Singaba, na nusi erungwa mere ka kebe yal ta i enin kobe milangwa nusi ere i tenamua. Yalini ka dinangwa i yal kobe ere gule piranwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ibal kobe ka kebe yal iray ka ta pirekenangwa, ena God ibalin kobi para sinangwa paamua.’ ");
INSERT INTO gvf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ka kebe yal Samuel, goma ka dire pare ka kebe yal para eme eme ainere, kemina kaun kalkan i maribe erungwa mere bolin kule tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","God ka kebe yal kobe gawlin, i ibal kobe milinwa. God i sanamoi ka wai di pena gale iru di Ebarakam tongwa, ‘I gawlin kobe milangware, kal wai ere gariba ibal para teralwa.’ Dimia ena i ibal kobe para aa te wai ere i tomua. ");
INSERT INTO gvf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","God kal wai ere i terala dire, yalini nil erari yal Yesu inin paale suna ere ire, goma nusi ere i tomua. Kal ki eringa piserana dire kal wai ere i tomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita te Yon ka di ibal kobe te milungwa, Yuda ka main kenin erungwa yal kobe, te ka main ogu bil el kwi nu milungwa yal bil, te Sadusi kobe, yal sui milungwa gul ungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","“Yesu gulere alungwa mere ibal iru milamua,” dire yal sui iru nil si tere bolin kule tongwa, ibalin kobe ure nigi de pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pirere yal sui kanin sire, “Kamin kaya girungwa gilaa ta kanin painangure, kwimile ka kol pirabinwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iru erimba ibal binanbile Yesu ka main di tongwa pirere, pire gi dungwa. Dungure malia yal kobe binanwenbile, paib tausen, pire gi di Yesu tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kwimile u bawa dungure Yuda ibal yal bil kobe, te singaba kobe, te ka main nil si tongwa yal kobe Yerusalem ai u ku bilungure ");
INSERT INTO gvf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","kenin erungwa yal bil kaan Anas milungwa, te yalini enin taw kobe Kayapas te Yon te Alekanda, te enin taw kobe imo milungwa para u ku bilungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bilere yal sui awli baan suna ta pire, iru sirin bile tongwa, “Ibena yobilaan bile i tome? Ibena ero, di i tome?” ");
INSERT INTO gvf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dungure God Kegemama Iban Pita den suna pirere, sipapa sire yobilaan bile tongure, Pita ka iru di yal kobe tongwa, “Yuda ibal yal bil te yal singabo, ");
INSERT INTO gvf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","‘Kawn ki sungwa yal, tamintan yal sui iray aa te wai ere tongure, u wai ome?’ i iru dire ka kol ere na tenanga, ");
INSERT INTO gvf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","i te Isirel ibal kobe para ka di terabina piro. Nasarete ai nen Yesu Kirisito i ibal kobe eri pera bolimina si gulinga, gulungure yongwa gul alungwa, God kal iru ere yalini tomua. Yesu yobilaan bile na tongure yalini kaan gale yebe eriga, ena kawn ki sungwa yal u wai ongwa kaninwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","I yal kobe ogu kiinga eri ta piseringa, eri iray pi biriin wen mina yongwa mere, Yesu ama iru u singaba bil wen omua. ");
INSERT INTO gvf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","God Yesu inin nusi ere gariba ibal tongwa, yalini inin tawle ibal aa ki di tongure sigare kule u wai ongure, te eme para u wai namua. Ibal ta ama iru ta erekinamua,” dire Pita iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ena Pita te Yon kuril pirekire dungwa, te sikul ta dikire ibal imore milungwa, ibal kobe kane buul kunere, yal sui Yesu bole para warungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kawn ki sungwa yal u wai ongwa, yal su bole para milungwa ibal kobe kanere, kura ka ta di tekungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Di tekemba, “U ku bilebinga ai pisere ere mena po,” di yasu tongure ongure pare, diria ere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Takal ere yasu terabine? Yerusalem ki pai milungwa ibal para, yal su kal guman kwi dungwa erungwa kanemua. Kanungwa ka di kile di mena erabinga ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ka iray di warekinama dire kan tere iru di yal su terabinga, ‘Yesu milungwa mere ibal kobe para di tekio.’” ");
INSERT INTO gvf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Direre yalsu, “Ere wo,” di gala dire iru di tongwa, “Yesu kaan gale yebe ere milungwa mere, ibal kobe para di tekire, te ka nil si tekio.” ");
INSERT INTO gvf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dimba Pita te Yon ka maan iru dire di tongwa, “I nomanin sire pire kuunin ero. I ka dinga wiina erabin, mo God ka dungwa wiina erabine? ");
INSERT INTO gvf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kalkan kanere te ka dungwa pirebinga, pire unin ta si milekire bolin kule te milabingal milabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dungure kuril pire tenama dire, u ku bilungwa yal kobe kwi yasu kan tere “Ere po,” dungwa. Yalsu kal erungwa ibal kobe para deminin si God tongware u ku bilungwa yal kobe yalsu sinangwa kuunin ta erekungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yalsu kal guman kwi dungwa ere aa te wai ere tongure kawn ki sungwa yal, me erin yal sutan aan kawn muru milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ena kan gule ere tongure pare, Pita te Yon gawlima kobe milungwa gul pirere, Yuda ka main kenin erungwa yal bil kobe te singaba kobe ka di yasu tongwa mere bolin kule tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tongure ibal kobe pirere, guru di dire iru ana di God tongwa, “Singaba Yal Bil, i kamin te gariba te pirin nil te kalkan para suna kobe paingwa, i ere yenwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","I ka di na ibal kobe tenga iru erinwa. God Kegemama Iban di i nilerari yal Debiti tongure na sanamoi Debiti giran mina iru dungwa, ‘Yuda milekungwa ibal den gule milere ibal kobe nomanin sire saala erimba, tamama. ");
INSERT INTO gvf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Gariba ibal bil erungwa kobe, te kenin erungwa yal bil kobe u ku bile iru dungwa, ibal kobe kura bile God Singaba te yalini konagi erungwa yal, Kirisito terabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kerodi te Pontias Pailete te Yuda milekungwa ibal te Isirel nen kobe, ibalin kobe ogu ai bil iray bole para u ku bilere kura bile nilerari yal Yesu tomua. Yesu kabin sire wai wen milungure, kenin erungwa yal konagi ere milama dire, kabe ki tongwa mere Yesu i suna erinwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","‘I yobilaan bile nomanin pire kal iru eralwa,’ kaya dinga ibal kobe malia iru wen eremua. ");
INSERT INTO gvf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Singabo, ‘Ibal kobe na siralwa,’ dungwa i kane nomanin si pire na i nilerari yal kobe kuril pirekire, i ka main di terabinga i aa ki na to. ");
INSERT INTO gvf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ibal nibil erungwa i yobilaan bile pilaan pai to. Nilerari yal Yesu, kabin sire wai wen milungwa yal, ibal kaan galere kalkan i maribe erangure, te kal ta erangure ibal buul kunangure, i aa ki di to.” ");
INSERT INTO gvf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ibal kobe ana di piserungure, u ku bilungwa ogu bol erere du erungure, God Kegemama Iban ibal para den suna pirere, sipapa sire aa bawle tongure, ibal kobe milungwa kuril pirekire God ka main di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ena pire gi di milungwa ibal nomanin u taran pire bole pena galungwa. Galere, “Na kal dimua,” ibalin kobe ta dikire, kalkan aa te nongwa obin si ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nusi erungwa ongwa yal kobe, Aposel, yobilaan wen bile milere, “Yesu gulungwa yongwa gul alemua,” dire bolin kule tongure, God kal wai wen ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Gariba kobaan te ogu kobaan, gariba te ogu ibal tere, kobile moni ire Aposel tongure, yalin kobe bona gana aa te nekungwa ibal tongwa. Tongure kuunin kuunin milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iru erungure yal ta kaan Yosepe milungure, nusi erungwa ongwa yal kobe, Aposel, kaan ta kwi Banabas ye tongwa. (Kaan i Golin ka main paingwa iru, yobilaan bile di tongwa yal milungwa.) Yalini Ilibai gawlin milungure Saipiras gariba gul kule nongwa. ");
INSERT INTO gvf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Banabas inin gariba ibal tere, kobile moni ire Aposel kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tomba yal ta kaan Ananayas milere ebinbi kaan Sapaira milungwa. Yalini gariba taw ibal tere kobile moni ingwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tobe taw yalini aal kule nongure ebinbi para kanungure, tobe imo dungwa nusi erungwa ongwa yal kobe, Aposel, tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tongure Pita di yalini tongwa, “Ananayas, gariba tobe taw i inin aal kule nenga, God Kegemama Iban kakiibi di tenwa. Satan i kiranin sire ka dungwa, tameran i pire wiina erine? ");
INSERT INTO gvf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Gariba goma tobe ikinga kaun i gariba dungwi. Tobe inga, i kobile moni kobaan milingi. Iru eringa, tameran nomanin suna ali si pire erine? I kakiibi di ibal kobe tenba, kakiibi di God para tenwa.” ");
INSERT INTO gvf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ka dungwa i Ananayas pirere gin taran yaa paire gulungwa. Gulungure ibal kobe pirere para kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yal garamil urere yobilagi daw sire ire malge pire maul si yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kaun tawliga wei sungure winbi gulungwa pirekire ebinbi ala ungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ungure Pita sirin bile abalini tongwa, “Gariba tobe iru ino?” Dungure abalini maan dire iru dungwa, “Owa, tobe iru ibinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dungure Pita di abalini tongwa, “I te wininbi bole God Singaba Iban bawle terala dire, tameran iru erine? Yal kobe i wininbi maul si yongwa, kaya u kana giran milere i para ire malge namua.” ");
INSERT INTO gvf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dungure abalini gin taran Pita kawn mina yaa paire gulungwa. Yal garamil kobe urere gulungwa kanere ire malge pire, winbi yongwa binan kole ebinbi maul si yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ka main ibal taminin para te ibal para, kal iru erungwa i, ka di ungwa pirere kuril wen pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nusi erungwa ongwa yal kobe, Aposel, kal guman kwi dungwa binanbile erere, kalkan erungure ibal buul kunungwa para binanbile erungwa. Pire gi dungwa ibal para, kuul ale kaan Solomon Ai u ku bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Milungure ibal taw mena milungwa bole pena galekenamba, ibal para wai pire yalin kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ibal binanbile yal te abal para Yesu Singaba pire gi di tongure, Yesu ka main ibal taminin u bil ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nusi erungwa ongwa yal kobe, Aposel, konagi iru ere milungwa ena ibal kobe nibil erungwa ibal awli kombil pire, duul kaal pire ye tere iru nomanin si pirungwa, “Nibil ere milungwa ibal taw, Pita guun si muulangwa, u pilaan painamua.” ");
INSERT INTO gvf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ibal Yerusalem ogu ai bil maala ki paingwa, ogin pisere nibil erungwa ibal te sia den miriin suna milungwa ibal, awli Yerusalem ungire para u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ena Yuda ka main kenin erungwa yal bil te yalini gawlima kobe Sadusi ibal milungwa, para san bale nusi erungwa ongwa yal kobe, Aposel tere ");
INSERT INTO gvf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","kanin sungure kanin paingwa ogu ali awli ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Omba gilaa iray angel ta urere kanin paingwa ogu kana giran yawlere, nusi erungwa ongwa yal kobe, Aposel awli mena pirere iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“I pi Yuda ka main ogu bil ala mile, ibal kol kwi pire mile painangwal painangwa main di gawa dire bolin kule to.” ");
INSERT INTO gvf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dungure are nol erungware pi Yuda ka main ogu bil ala pire ka nil si tongwa. Yuda ka main kenin erungwa yal bil te gawlima kobe, “U ku bilo,” di Isirel singaba para tongure, urere yal kobe kanin paingwa ogu nusi ere iru di tongwa, “Yal kobe awli wo.” ");
INSERT INTO gvf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dungure simil nen kobe kanin paingwa ogu u bawa dire, yal kobe milekungwa kanere kwi urere bolin kule tere dungwa, ");
INSERT INTO gvf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kanin paingwa kana giran yaale gi dire, el kwi nu milungwa yal kobe binan kole milungwa kanebinba, yawlebinga ibal ala ta milekemua.” ");
INSERT INTO gvf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ka main ogu simil nen bil ta, te kenin erungwa yal bil kobe ka dungwa i pirere, nomanin si gogo erere iru pirungwa, “Iru erungwa we, takal erame?” ");
INSERT INTO gvf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ena yal ta ure iru di tongwa, “Yal kobe i kanin paingwa yal iray, ka main ogu bil ala mile ka nil si ibal kobe tomua.” ");
INSERT INTO gvf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dungure ka main ogu simil nen bil te simil nen taw bole pire, “Ibal kobe kobile aa tere na sinamua,” dire iru pirungwa, ena nusi erungwa ongwa yal kobe, Aposel, mone mone di awli ungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Awli ala ongure nusi erungwa ongwa yal kobe, Aposel, u ku bilungwa ibal guman mina ale milungwa. Milungure Yuda ka main kenin erungwa yal bil sirin bile tere iru dungwa, ");
INSERT INTO gvf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“‘Yesu ka main nil si tekio,’ iru di i tobinba kano. Yerusalem ibal kobe para muru di tengire kaya piremua. Yesu gulungwa na pirin painama dire iru erinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita te Aposel kobe imo mile iru maan di tongwa, “God ka dungwa te ibal ka dungwa u kuunin ta pekenangwa, ena God ka dungwa kaya wiina erabinawa. ");
INSERT INTO gvf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","I Yesu eri pera bolimina bili nil sire si gulingire, gulungwa gul alungure, na ibal kobe sanamoi gilekume ibalin kobe, God Yesu ulin yuure iru ere yalini tomua. ");
INSERT INTO gvf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Isirel ibal kobe kal digan ere taalime erungwa pisere nomanin suna si kiruul sire, pirin paangwa God kire di erama dire, God Yesu aa te yebe erungure inin aan wen kol mile, Singaba mile inin para aa ki di na tongwa yal milemua. ");
INSERT INTO gvf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kalin dungwa na yal kobe te God Kegemama Iban para kane bolin kule tobinwa. God ka dungwa mere ibal kobe pire wiina erungure, God yalini inin Kegemama Iban ibalin kobi tomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ka dungwa i u ku bilungwa yal kobe pirere den gule, “Nusi erungwa ongwa yal kobe, Aposel, si gulabinwa,” dire iru di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pirimba Parasi yal ta i suna milungwa kaan Gameliel, ka main nil si tongwa ibal kobe nomanin wai pire tongure, yalini alere, “Aposel kobe awli mena po,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Di tere iru di u ku bilungwa yal kobe tongwa, “Isirel nen kobe, kal ta ere yalin kobe tenanga, nomanin si pirekun ero. ");
INSERT INTO gvf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Goma yal ta kaan Teudas u bawa dire, ‘Singaba bil miliwa,’ dungure yal kobe binanbile, po kandret, pi gawlima kobe kule milimba, ibal kobe yalini si gulungure gawlima kobe u sutaw ongure, yalini konagi erungwa wei simua. ");
INSERT INTO gvf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iru erungure pare Galili nen ta kaan Yudas, gabman kaan galungwa kaun u bawa dungure, ibal kobe binanbile duulin bile warimba para iru si gulungure pare, gawlima kobe para u sutaw omua. ");
INSERT INTO gvf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Iru erungwa mere malia iru di teralga, kal ta yal kobe ere terala di piringa pisero. Imore milamua, Konagi erungwa yal kobe inin nomanin si pire erangwa yaa ime sinamba, ");
INSERT INTO gvf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","God konagi painangwa i yaa ime ta sekenanwa. Iru eranga ena i God kura bile tenga mere painamua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yalini ka dungwa yal kobe pire wiina erere, “Nusi erungwa ongwa yal kobe, Aposel, ere wo,” di gala dungure, ungure kuba aa tere sire di yobilaan bile iru di tongwa, “Yesu guun kan kwi ama ibal kobe di tekio.” Dire kan gule erungure yal kobe ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel kobe u ku bilungwa ai pisere wai pire iru dungwa, “Yesu pire gi dibinga giil pirebingire, goma God, ‘Para wai paimua,’ dungure u maribe omia wai pirebinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yalin kobe kaun kaun ka main ogu bil ala te inin ogu ala, “Yesu God konagi erungwa yal, Kirisito milemua,” dire nil si tere kere di te milungwal milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ena kaun iray Yesu gawlima kobe maalungwa, Isirel nen kobe Giriki ka dungwa ibal milere, Isirel nen kobe Kibiru ka dungwa, kan tongwa. “Abal weray are kaun kaun komina obin si na tongwa kuunin paikimua,” dire kan tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nusi erungwa ongwa yal, Aposel, anan kole kole muru kawnan milin sutan, “U ku bilo,” di gawlima kobe taminin muru tere, iru dungwa, “Na yal kobe ka main kere di tobinga pisere, komina bol ta ta obin si terabinga kuunin ta paikinamua. ");
INSERT INTO gvf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Paikungwa iray yal anan kole muru kole sutan God Kegemama Iban den miriin suna mile nomanin paingure, ibal kobe kane, ‘Yal wai milemua,’ dungure yalin kobe, ‘Konagi iray ero,’ di terabinwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iru erangure na yal kobe ana di God tere, ka main kere di te milabingal milabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Aposel kobe iru dungwa ibal para wen wai pire, yal kobe kaan iru paale suna ere ingwa. Yal ta kaan Sitiben, pire gi wen dungwa yal milungure God Kegemama Iban yalini den miriin suna pire sipapa sungwa, yal ta kaan Pilipi, ta Pirokoras ta Naikena ta Taimon ta Pamenas ta Antioko ai yal Nikolas, goma yalini inin ibal ka main pisere Yuda ka main duulin bile warungwa, ");
INSERT INTO gvf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ibal para yalin kobe awli Aposel kobe milungwa gul ungure, ana di God tere gibilin mina aan aa taw sire, konagi erama di iru ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tomia ena God ka main waa dire gariba gariba ongwa. Yesu gawlima kobe Yerusalem milungwa maale sulu dungure, Yuda ka main kenin erungwa yal binanbile Yesu ka main pire gi dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God kal wai wen ere Sitiben tongure yalini yobilaan bile milungwa. Milere kal guman kwi dungwa i maribe erere, kalkan erungure ibal kobe kane buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ibal taw kobe goma nil konagi yal Sairini gariba te Alekandiria gariba te Silisia gariba te Esia gariba milimba, malia imore mile Yuda ka main ogu ta u ku bilungwa. Ku bilere yalin kobe te Sitiben bole ka bolebilin dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Dimba God Kegemama Iban ka main di maribe ere Sitiben tongure, Sitiben ka dungwa wi yebe ongure yal kobe ka dungwa yaa ime sungwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yalin kobe yal taw baale woongure kakiibi dire iru dungwa, “Yalini gain ka si Mose te God tongwa, na yal kobe pirebinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iru dungwa ibal imore milungwa te Yuda ibal singaba te Yuda ka main nil si tongwa yal, den gule Sitiben tere aa gi dire awli Yuda ka main u ku bilungwa yal milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pire kakiibi dungwa yal kobe para awli ongure, kakiibi dungwa yal kobe iru dungwa, “Yalini morin morin na ibal kobe ka main ogu bil te Mose kile kaman ka, gain ka si tomua. ");
INSERT INTO gvf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Si tere te, ‘Nasarete nen kaan Yesu ogu bil iray suulangure, Mose main si aine aine di na tongwa piserangure main ta kwi ere ain namua,’ dire yalini iru dungwa na ibal kobe pirebinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","U ku bilungwa yal para Sitiben guman mina tena yulin bile kanere, angel guman kulungwa mere guman iru kulungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ena Yuda ka main kenin erungwa yal bil sirin bile Sitiben tere iru dungwa, “Yal kobe ka dungwa kawen dimo?” ");
INSERT INTO gvf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Dungure Sitiben dungwa, “Enan kobe te na abe kobe, ka diralga piro. Na ibal kobe sanamoi Ebarakam, Keran gariba gul ole pekere Mesopotemia gariba mile paingure, God kamin mina Yal Singaba wen u maribe pire ");
INSERT INTO gvf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","iru di Ebarakam tongwa, ‘I ibalin kobe pisere te garibanin pisere, gariba ta i maribe ere i teralga po.’ ");
INSERT INTO gvf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dungure yalini Kaldia gariba gul pisere pi Keran gariba ki pai milemua. Ebarakam nen gulungure pare God gariba gul i, na ibal kobe ki pai milebinga gul Ebarakam awli umua. ");
INSERT INTO gvf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Awli umba gariba tekemua. Tawle wen ta tekemua. Gaan ta kule yekungwa milimba, ‘Gariba i te gawlin kobe teralwa,’ dire God iru di Ebarakam tomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God ka iru di yalini tongwa, ‘I gawlin kobe gariba baan ta milangwa, nilerari yal me erin binanwenbile, po kandret mile gain giil piramua. ");
INSERT INTO gvf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","I gawlin kobe gariba baan ta ibal nil konagi ye tenangure, na ka kol ere ibalin kobe tere sirabinwa. Sirabingire pare i gawlin kobe gariba i pisere ere abila ure, ana dire deminin si na tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","God iru dire pare, ‘Gamege gain bile ero,’ dire kaman tongure, Ebarakam wan Aisaka kule nere are kaun anan kole muru kole sutakobe wei sungure, gain bile eremua. Aisaka wan Yakobo kule nongure, Yakobo na sanamoi gilekume anan kole kole muru kawnan milin sutan kule nomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na ibal kobe sanamoi gilekume san baale Yosepe tere Yosepe nil konagi ere milama dire, Isipi ibal tere kobile moni imua. Iru erimba God yalini bole milere ");
INSERT INTO gvf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","yalini taalime paingwa aa ki dimua. Yalini Isipi yal bil kaan Pero milungwa gul nomanin paire naanin paingwa, Pero kanere wai pire tomua. Isipi gariba muru te inin ogu kenin erama dire, Pero konagi iru ere Yosepe tomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Iru ere milungwa Isipi gariba te Kenan gariba para, kenan bil gulungwa kaun u bawa dungure, ibal kobe kenan gule giil piremua. Na ibal kobe sanamoi gilekume komina waa duumba, ta kanekimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Isipi gariba suna komina dungwa Yakobo pirere wan kobe kawn kule nusi erungure, Isipi omua. ");
INSERT INTO gvf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kaun ta kwi ongure Yosepe, ‘I kebininbi na miliwa,’ di maribe ere kebin abin kobe tomua. Yosepe nen te kebin abin milungwa, Pero para kane pol simua. ");
INSERT INTO gvf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosepe ‘Ere wo,’ di nen te ibalin kobe tongure, nen te ibal binanbile, sewenti paib, para Isipi gariba omua. ");
INSERT INTO gvf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo Isipi gariba pire gulungure yalini wan kobe, na sanamoi gilekume milungwa para gulemua. ");
INSERT INTO gvf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gulungure yobilagi i pi gariba ta kaan Sikem i ongure, goma Ebarakam mile Kemo wan gariba kobile moni tere gibilin sungwa, gariba iray maul si yomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Goma God aan kere yere ka di Ebarakam tongwa mere, u maribe nangwa kaun u maala ongure na ibalan kobe Isipi milungwa maale sulu dimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kaun iray Isipi yal bil ta Yosepe kal erungwa pirekire, Isipi ibal kenin ere ke milemua. ");
INSERT INTO gvf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Milere na sanamoi gilekume kobe kal digan ere bawle tere, na sanamoi gawlin kobe gulama dire pusi mena erungwa mere ‘Iru ero,’ di tomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Iru ere milungwa kaun iray, Mose man kule nongure guman wai wen kulemua. Ba sutakobe nen man inin ogin kenin ere milemua. ");
INSERT INTO gvf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","I mena erungure Pero abilin kanere inin wan milungwa mere, kenin ere mua kulemua. ");
INSERT INTO gvf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Isipi main paingwa mere yal kobe kile kaman ka di Mose tongure, yalini kal dime di ere te ka dire naanin paimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ena Mose me erin yal sutan aan kawn muru milungwa, na ibalan kobe Isirel nen, ‘Kanalwa,’ dire nomanin si pire ere omua. ");
INSERT INTO gvf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pire Isipi yal ta Isirel yal ta sungwa kanere, ibalin kobe aa ki dire Isipi yal si gulemua. ");
INSERT INTO gvf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Si gulungwa iru nomanin si pirungwa, ‘Na ibalan kobe aa ki di tegire, u wai nama di piriwa.’ Iru nomanin si pirimba ibalin kobe pirekun erekimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mose ul paire alere, kwimile kwi omua. Pirere Isirel yal sutan bole kura bilungwa kanere, yal su u taran nama dire iru di tongwa, ‘Yalkane, i enin kobe milinga kura bilekio.’ ");
INSERT INTO gvf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dimba kura goma erungwa yal, Mose anu si tayan ere iru di tongwa, ‘Kenin erangwa yal mile ka kol pire na terala di piringa, ibena iru ero di i tome? ");
INSERT INTO gvf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Erima Isipi yal ta si gulinga mere, na si gulano?’ ");
INSERT INTO gvf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ka iru dungwa Mose pirere, si ere Midian gariba gul omua. Pi milere wan sutan kule nomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ena me erin yal sutan aan kawn muru wei sungure, Mose gariba simi yongwa kamin kuul Sainai binan milungure, eri ta enderin bawl sungwa angel ta suna ali u bawa dimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose kane buul kune kanala dire ere maala ongure, God ka iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘I sanamoi gilekume yalin kobi God na miliwa. Ebarakam te Aisaka te Yakobo, yalin kobi God na miliwa.’ Dungure Mose sigagu dire kuril pire ta kanekimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","God Singaba iru di tongwa, ‘Gariba i bolimina ale milinga kegemama yobina, i kawn tobilin gule ero. ");
INSERT INTO gvf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na ibalan kobe Isipi milere giil bilkaw wen pirungwa kanebingiwe. Giboi di milungwa pirere aa ki dibingire u wai nama dire ime wiwa. Uga i ungire nusi Isipi gariba eralwa,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ena Mose iwe, Isirel ibal yalini muun kal waa tere, ‘Kenin erangwa yal mile ka kol pire na terala di piringa, ibena iru ero di i tome?’ dire ibal kobe ka iru dungwa, manaa di Mose tomua. Ibal manaa di tongwa yal i, Mose iwe, God angel eri suna i maribe erere, te Mose ibal kobe kenin ere mile aa ki dinangwa ibalin kobi sigare kule u wai pi milama dire, God yalini nusi eremua. ");
INSERT INTO gvf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose te ibal kobe Isipi gariba pisere awli omua. Isipi gariba suna te pirin nil kaan Nilbaa dungwa binan, te gariba simi yongwa suna me erin yal sutan aan kawn muru, Mose kal guman kwi dungwa erungure, ibal kane buul kunemua. ");
INSERT INTO gvf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose yalini, iru di Isirel ibal kobe tongwa, ‘God na nusi erungwa mere yal ta i suna milungwa, God ka kebe yere nusi ere i tenamua.’ ");
INSERT INTO gvf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Isirel ibal kobe gariba simi yongwa gul u ku bile milungwa Mose bole para milere, na sanamoi gilekume bole para milere, te angel ta kamin kuul kaan Sainai bole milere, God ka main naanin paangwa si aine aine di na tenama dire, God ka di yalini tomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Na ibal kobe sanamoi gilekume Mose ka dungwa piserere, yalini baan ta anu si erere, kwi Isipi gariba gul nala di piremua. ");
INSERT INTO gvf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ibal kobe iru di Eron tongwa, ‘Galbale kobile ere na tenanga kobile i na gumanan mina yegire, na awli namua. Mose iwe, Isipi gariba pisere yalini na ibal kobe awli ungure, yalini baan ta om mo, gulim mo, pirekun erekibinwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Dire kaun iray ibal kobe galbale kobile bolimakau gawlin mere ere yerere, kabe si gale tere inin kalkan erungwa komina bil ki tomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iru ere milungwa God ibal kobe pisere ibal are ba, te kulmama ana dire deminin si tenama dire, God iru ere tomua. Kal iru erungwa mere ka kebe yal ka minin iru bile paalungwa paamua, ‘Isirel nen kobe i gariba simi yongwa me erin yal sutan aan kawn muru milere, kabe si galinga ta gale si na tekenwa. ");
INSERT INTO gvf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","I galbale kobile ta kaan Moloko, sel ogu ala yere ogu iray aa te ire warinwa, te galbale kobile ta kaan Erepan aa gi di warinwa. Galbale sui iray ana dire deminin si te milinwa. Iru ere milingi Bebilon gariba gul kol ime na nusi ere tayan eralwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Na ibal kobe sanamoi gilekume gariba simi yongwa gul milungure, God ‘Na sel ogu kio,’ di Mose tongwa mere kiimua. Kiingwa God ibal bole si dawle mile ka di tomua. ");
INSERT INTO gvf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eme inan sanamoi gilekume sel ogu i, wan kule yongwa si aine aine tongure ibal kobe sel ogu pema kiire aa te ire warungure, God gariba kobaan si kiranin bilungure u baan ta ongure, inin sanamoi te Yosua bole gariba imua. Debiti u maribe ongure sel ogu imo di paimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Debiti wai wen milungwa God gun ye tongure iru sirin bile God tongwa, ‘Ka main ogu ta ki Yakobo yalini God terabino?’ ");
INSERT INTO gvf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sirin bilimba Solomon ogu iray kiimua. ");
INSERT INTO gvf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“God Yal Bil yal kobe ogu kiingwa ki pai milekemua. God ka kebe yal dungwa mere iru bile paalungwa paamua, ");
INSERT INTO gvf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘God Singaba iru dimua. Na kamin mina amin di miliga kawnan gariba gul egiliwa. Iru miliga ta ogu ki na tenane? Alde pairale? ");
INSERT INTO gvf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kamin te gariba para wen ere yekiyo? Ere yegirawa. ");
INSERT INTO gvf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Kal digan ere girin di milingi. Ibal pire gi dekungwa i nomanin iru paire, te God ka dungwa i pire nomanin suna yekingi. I sanamoi gilekume kura bile God Kegemama Iban tongwa mere, i para iru ere tengi. ");
INSERT INTO gvf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I sanamoi gilekume ka kebe yal taran tawle ta sekemo? Para muru simua. ‘Kal dime di erungwa yal unamua,’ dire iru gala dungwa yal kobe, i sanamoi gilekume para yalin kobi si gulemua. Malia kal dime di erungwa yal i para bale taal sire si gulinwa. ");
INSERT INTO gvf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Angel kobe God kile kaman ka di maribe ere i tomba, i kenin ere wiina erekingi,” dire Sitiben iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ena yalini ka dungwa ibal kobe nigi de pirere den gule yalini tere sigin gibin nuungwa. ");
INSERT INTO gvf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nuumba God Kegemama Iban yalini den miriin suna pire sipapa sungure, Sitiben kane kamin mina erere God naabilungwa kanere, te Yesu God aan wen kol milungwa para kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kanere iru dungwa, “Kamin kol yawlungwa kanere, te U Ibal Ongwa Yal God aan wen kol milungwa para kania, i kano.” ");
INSERT INTO gvf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dungure kiraan aa gi di milere ibal kobe gala dire mugu di pi yalini milungwa gul pirere ");
INSERT INTO gvf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aa gi dire awli ogu mena pire kobile kuba aa tere sungwa. Sire galsuna gule ere yal garamil kaan Sol kawn mina ye paalungure, kenin ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ibal kobe kobile kuba aa tere sungwa, Sitiben ana iru di God tongwa, “Yesu Singaba, na ibanan iyo.” ");
INSERT INTO gvf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dire yalini gobin bile mile iru gala bil dungwa, “Singabo, ibal kobe kal digan ere taalime erungwa i pirin pai tekio.” Dire pare gulungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ibal kobe Sitiben si gulungwa Sol, “Para paimua,” dungwa. Are kaun ta iray ibal kobe kal main nigi dongwa ere Yerusalem ai ka main ibal taminin tere, binanbile sirere ere milungwa. Ere milungure pire gi dungwa ibal para Yudia gariba te Sameria gariba u sutaw ongwa. Nusi erungwa ongwa yal kobe, Aposel, tawle Yerusalem ai mile paingwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ka main pire wiina pai tongwa yalin kobe taw, kerebare kay miire Sitiben maul si yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol ka main ibal taminin si wei sirala di pirungwa. Ogu kaana kaana pire, pire gi dungwa yal abal bole gure pala dire kanin paingwa ogu anu si ala erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pire gi dungwa ibal kobe u sutaw pire, ka main kere di ibal kole kole tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipi pi Sameria ogu gul pire, Kirisito ka main kere di ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tongure u ku bilungwa ibal kobe ere gule pire yalini kal guman kwi dungwa erungure, kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilipi sia binanbile maa si mena erungure, sia gala bil dungwa. Ibal kawn kebil sungwa, te kawn ki sungwa, kol ta warekungwa ibal kobe yalini aa ki dungure u wai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Iru erungure Sameria ogu ai bil i, ibal kobe wai pire gun yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ogu ai bil iray yal ta kaan Saimon ki pai mile kankiray ere milungwa, Sameria ibal buul kunungwa. “Yal singaba bil miliwa,” dire yalini iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ibal maangwa te yaangwa ibal para wen, ogu ai iray suna ki pai milere yalini ka dungwa nomanin si suna ere iru dungwa, “God yalini yobilaan bile tongwa kalkan erungwa kamin yal bil milemua.” ");
INSERT INTO gvf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Dire kankiray ere milungwa ibal kobe baan araway buul kunere, yalini ka dungwa nomanin si suna erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Erimba God kenin ere ke milungwa mere, te Yesu ka pore Pilipi ka di tongwa mere, ibal kobe pire gi dungure, yal abal para nil bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon para pire gi dungure, nil bile tongure, yalini Pilipi duulin bile ongwa. Ongure Pilipi kal guman kwi dungwa erungwa, Saimon kane buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Sameria ibal kobe God ka main nomanin wai pire ingwa, nusi erungwa ongwa yal kobe, Aposel Yerusalem mile pirere, Pita te Yon nusi erungure Sameria ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Yal sui u bawa dire pire gi dungwa ibal God Kegemama Iban den miriin suna painama dire, ana di God tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Yesu kaan gale yebe erere nil goma bile tomba, God Kegemama Iban pire gi dungwa ibal milungwa gul i wi ime pekungwa, ana di God tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yal sui ibal kobe gibilin mina aa taw sungure, God Kegemama Iban ibal den miriin suna ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Nusi erungwa ongwa yal, Aposel sui iru erungwa, Saimon kanere iru dungwa, “Ibal kobe gibilin mina aa taw sirabinga God Kegemama Iban den miriin suna nama dire, i yobilaan bile na tenanga i, kobile moni teralwa.” ");
INSERT INTO gvf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Dimba Pita maan iru dungwa, “God kal imore ibal tongwa main, ‘Kobile moni gibilin siralwa,’ i iru nomanin si piringa, i te kobile moni para enderin gaul ai nanwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","I nomanin paikungwa God iru kanungure, na ka main konagi erebinga i para eranga ta paikimua. ");
INSERT INTO gvf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","I kal digan erala dire nomanin si piringa, nomanin suna si kiruul so. I iru nomanin si pire kal digan ere taalime eringa, ‘God kire di ero,’ iru dire ana di God Singaba to. ");
INSERT INTO gvf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","I ibal main gi kiingwa milere, kal digan ere taalime eringa, nomanin gule daalin simua.” ");
INSERT INTO gvf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dungure Saimon maan iru dungwa, “Na miliga i ka dinga u maribe pekenama dire, ana di God to.” ");
INSERT INTO gvf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","God kal ere yal sui tongwa mere, di maribe erere, Yesu Singaba ka main di tere pare Pita te Yon kwi Yerusalem ai ongwa. Pirere Sameria gariba gul ai ta ta binanbile Yesu guun kan kere di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ena God Singaba angel ta nu sungure, iru di Pilipi tongwa, “Ale, i bomai kamin ime kombil ta, Yerusalem pi Gasa ongwa, kol i po. Kol i gariba simi yongwa kol suna omua.” ");
INSERT INTO gvf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dungure alere ere ongwa. Itiopia yal singaba ta, Itiopia abal bil kaan Kandesi kobile moni te kulgal bona kenin ere milungwa, yalini Yerusalem ai mile God ana dire deminin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tere pare kwi ogun nala di pirere, kare ta bolima awsi gure pala dungwa, bolimina amin di milere, ka kebe yal Aisaya ka minin ganin bile paalungwa kerungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kerungure God Kegemama Iban di Pilipi tongwa, “Kare ta i, i pi binan kole mile po.” ");
INSERT INTO gvf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dungure Pilipi mugu di pi yal i milungwa gul milere, ka kebe yal Aisaya ka minin ganin bilungwa, yalini kerungwa Pilipi pirere iru sirin bile tongwa, “I keringa mere main pirino?” ");
INSERT INTO gvf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dungure yalini dungwa, “Tamintan main pirabine? Yal ta nil si na tenangwa main piralwa.” Dire “Ere wo,” di tongure, Pilipi pi kare bolimina para amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ena yalini ka main baan ta kerungwa iru bilungwa paangwa, “Ibal bolima siipe siipe awli sirala di ongure ge ta dikungwa mere yalini iru ka ta dekemua. Ibal bolima siipe siipe kumil kwi igin balungure, ge ta dikungwa mere, yalini iru ka ta dekemua. ");
INSERT INTO gvf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gain ka si tere kan tere ka kol ere tomba, yalini kal digan ere taalime erekimua. Gariba gul mile pai erungwa wei sinangwa yalini kal erangwa mere, wan abilin wen kobe milekenangwa ibal kobe bolin kule tekenamua.” ");
INSERT INTO gvf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yal singaba iru di Pilipi tongwa, “Ka kebe yal ka dungwa kerebingi, yalini inin kan dim mo, yal ta kan dim mo, ibena kan dime?” ");
INSERT INTO gvf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ka main ta i yalini kerungwa Pilipi kawn kule dire, Yesu guun kan ama di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ena yalsu kombil ware pire nil ai ta u bawa dungure, yal singaba dungwa, “Nil milemia kano. Nil bile na tenanga para painamba kal ta na si pere dim mo?” ");
INSERT INTO gvf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Dungure Pilipi iru di tongwa, “I pire gi wen di God tenanga nil bile i terabinga paamua.” Dungure yalini mile, “Yesu God Wan milema di pire, pire gi diwa,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dire “Bolima awsi kan kule paalo,” dungure Pilipi te yal singaba, nil milungwa gul ere ime pire, bau suna pire nil bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nil pisere ere yebe ungure, God Singaba Iban Pilipi awli baan ta ongure, yal singaba Pilipi kwi ta kanekire, gun yere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipi Asodo gariba gul u bawa dungwa ibal kobe kanungure, yalini pi gariba kole kole Yesu guun kan kere di tere, eme Sisaria ai u bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ena Sol mile Yesu Singaba gawlima kobe si gulala dire, yobilaan bile ere milungwa. Milere pi Yuda kenin erungwa yal bil milungwa gul pirere, iru di tongwa, ");
INSERT INTO gvf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Na Damaskas pire, Yesu kol ta bala dungwa duulin bile warungwa yal abal kobe, kanin pai tere awli Yerusalem urala dire, i ka minin ganin bile Damaskas Yuda ka main ogu nen to.” ");
INSERT INTO gvf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dungwa mere bile tongure, pi Damaskas maala ongure, kamin mina naabilungwa sine di yalini milungwa gul erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Erungure yalini gawl sire ka ta yalini di tongwa pirungure iru dungwa, “Sol, aya, tameran i giil pire na tene?” ");
INSERT INTO gvf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Dungure yalini dungwa, “Singabo, i ibena miline?” Dungure ka iru dungwa, “Na Yesu miliwa, i giil pire na tenwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tenba i ale pi ogu ai bil suna pire i konagi ta eranga, yal ta di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yal kobe bole para ongwa ka dungwa pirimba, ibal ta kanekungwa ira maangwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol alere omilin pilaa dimba, kal ta kanekungwa. Kanekungure aan aa tere awli Damaskas ogu ai bil suna ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Are kaun sutakobe omilin gi dungure, komina te nil para nekungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ena Yesu gawlima kobe ta kaan Ananayas, Damaskas ogu ai bil ki pai milungwa. Milere kiibi ta kanungure, Yesu Singaba yalini kaan gala dungure, Ananayas iru dungwa, “Singabo, na abila miliwa.” ");
INSERT INTO gvf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dungure Singaba di yalini tongwa, “I ale, pi kombil ta kaan Du Dungwa, po. Yal ta kaan Yudas, yalin ogu u bawa dinangire, Tasas nen ta kaan Sol milim mo, di piro. Yalini ana di God te milemua. ");
INSERT INTO gvf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yalini para kiibi iru kanungwa, yal ta kaan Ananayas yalini ogin ala ongure omilin pilaa dinama dire, aan gibilin mina aa taw simua.” ");
INSERT INTO gvf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dungure Ananayas maan dungwa, “Yalini kal ki ere i gawlin kobe Yerusalem milungwa tongure, ibal binanbile di maribe erungwa piriwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ibal kobe para i kaanin aa te yebe erungwa yalini kanin pai tenama dire, Yuda ka main kenin erungwa yal bil kobe kaman tere ka minin ganin bile tongure, Damaskas kaya u milemua.” ");
INSERT INTO gvf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dungure Singaba iru di tongwa, “Yalini milungwa gul po. Yalini Yuda milekungwa ibal te gariba yal bil kobe, te Isirel nen kobe, na guunan kanan di maribe erama dire, na yalini paale suna ere ibinwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na kaanan di maribe erere giil pirangwa, pire di maribe ere yalini teralwa.” ");
INSERT INTO gvf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dungure Ananayas pi Sol ogu ala pire gibilin mina aan aa taw sire dungwa, “Na enan ta Sol, i kombil milinga Yesu Singaba inin i maribe ere i tongwa, yalini na nusi eremua. I omilin pilaa dinama dire, te God Kegemama Iban den miriin suna painangure, sipapa sinama dire, na nusi eremua.” ");
INSERT INTO gvf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Dungure gain kirebinin mere, omilin mina dungwa u ongure, kwi wai wen kanungwa. Yalini alungure nil bile Sol tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yalini komina nere niminin milungwa. Ena are kaun taw, yalini Damaskas gariba Yesu gawlima kobe bole para milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yalini gin taran Yuda ka main ogu ala iru bolin kule tongwa, “Yesu God Wan milemua.” ");
INSERT INTO gvf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Dungwa ibal kobe pire buul wen kunere dungwa, “Yerusalem ibal Yesu kaan aa te yebe erungwa yal tai ibalin kobe si gulere, kal iru erungwa yal milemua. Si kanin si yalin kobe tere, awli Yuda kenin erungwa yal bil kobe milungwa gul nama dire, yalini abila umua.” ");
INSERT INTO gvf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol ka main kere di tongwa yobilaan bilere, “Yesu yalini Kirisito milemua,” di maribe erungure Yuda ibal Damaskas ki pai milungwa ka dungwa yaa ime sungure, Sol ka dungwa wi yebe ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Are kaun taw binanbile wei sungure pare, Yuda ibal kobe u ku bilere, “Sol si gulabinwa,” dire nomanin sire saala erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Erimba ibal kobe kal ta erala di pirungwa, ibal taw kobe Sol di tongwa. Si gulala dire, girungwa taangwa ogu ai kana giran el kwi nu pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Milimba gilaa ta Sol gawlima kobe komaden gal bilkaw yuure, Sol si gal gule ogu baan mina kan kulere, i malge ogu main i erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ena Sol Yerusalem pirere Yesu gawlima kobe bole pena gale para milabina di nomanin si pirimba, Sol u Yesu gawliman ongwa, gawlima kobe iru pire Sol tekungwa. Tekire yalini milungwa para kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ena Banabas yalini awli nusi erungwa ongwa yal kobe, Aposel, milungwa gul ongwa. Sol kombil mile Yesu Singaba kanungwa mere, ka di yalin kobe terere, te Sol Damaskas mile Yesu kaan gale yobilaan bile ka main kere di ibal kobe tongwa mere, Banabas ka pore para iru di yalin kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Di tongure Sol yalin kobe bole para milere, Yerusalem baan baan yobilaan bile Yesu Singaba milungwa mere, ka main kere di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yalini te Yuda ibal Giriki ka dungwa bole ka bolebilin dire yalin kobi yalini si gulabina di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Iru pirungwa enin kobe kiraan pirere, awli Sisaria ai pirere, nusi ere “Tasas ai po,” di Sol tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ka main ibal taminin Yudia gariba milungure, Galili gariba milungure, Sameria gariba milungure, para wai wen milungure, ere ki ere ibalin kobi tekungwa. God Kegemama Iban ka main ibal taminin yobilaan bile tongure, ibalin kobi Yesu Singaba kaan aa te yebe ere u bil pire maale sulu dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ena Pita kole kole Yesu gawlin kobe kanala di ongwa. Pirere yalini pi Ilida gariba gul milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Milungure yal ta kaan Inias mile, aan kawn gulungwa kol ta warekire, me erin anan kole muru kole sutakobe bol bolimina ul pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita di yalini tongwa, “Inias Yesu Kirisito i aa ki dungure u wai enwa. Alo, i duul bege di yeyo.” Dungure yalini gin taran alungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ilida te Seron ibal para muru, yalini u wai ongwa kanere nomanin si kiruul sire, Yesu Singaba pire gi di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ena Yesu gawlima kobe ta kaan Tabita, Yopa gariba ki pai milungwa. Abalini kaan Giriki ka dungwa mere Dokas. Abalini morin morin konagi wai ere, kal aa te nekungwa ibal aa ki di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kaun iray abalini nibil ere gulungwa. Gulungure ibal kobe abalini gain bigin si tere, ogu ta bol kan kule ki paingwa mine kiile ali yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa, Ilida gariba maala dungure, “Pita Ilida ai milemua,” dungwa Yopa ibal, Yesu gawlima kobe pirere yal sutan ka kebe yenama dire, nusi ere Pita milungwa gul ere, “Iru do,” dungwa, “Suul mile paikio, maliaga wo.” ");
INSERT INTO gvf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yal sui pi di tongure, Pita alere yal sui bole ongwa. U bawa dungure ibal kobe Pita awli pi ogu ta, bol kan kule ki paingwa mine kiile ali ongwa. Abal weray para Dokas galsuna te gal warungwa i maribe ere Pita tere, kay mi milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Milimba Pita abal kobi nusi mena erere, yaa gobin bile mile ana di God tere, iru di gain gariba erungwa abal tongwa, “Tabita, i alo.” Dungure omilin pilaa dire Pita kanere alungwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita abalini aan aa tere aa ki dungure alungwa. Yalini Yesu gawlin kobe te abal weray, “Ere wo,” di gala dire, “Abal iray ungwa ime,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pita abal aa te wai erungwa, ka Yopa gariba gul kole kole para ware biingwa, ena ibal binanbile pire gi di Yesu Singaba tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Yal ta kaan Saimon bolima gain kal mirimil erungwa, yalini Yopa ai ki pai milungure, Pita yalini bole are kaun taw binanbile pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Yal ta kaan Konilias, simil nen singaba mile Sisaria gariba gul ki pai milungwa. Milere simil nen Itali gariba nen ibal anan kole muru aan kawn muru, kenin ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yalini God ka main aa gi di pirere yaa ime sire deminin si tongure, yalini enin kobe para iru ere milungwa. Yuda kal aa te nekungwa ibal, yalini binanbile aa ki di tere ana di God te milungwal milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pu dungwa kaun ta yalini kiibi iru kanungwa, God angel ta nu sungure ure, Konilias yalini kaan galungure, ");
INSERT INTO gvf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","yalini kuril pire gain nuure iru dungwa, “Singabo, takal ereme?” Dungure yalini dungwa, “I ana di God tere, te kal aa te nekungwa ibal aa ki di tenga God kane wai pire i tomua. ");
INSERT INTO gvf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","I yal taw nusi Yopa ai ero. Nangure yal ta kaan Saimon, kaan kwi yongwa Pita, awli abila unamua. ");
INSERT INTO gvf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Saimon bolima gain kal mirimil erungwa yal ogu pirin nil binan ki pai milungure, Pita bole para pai milemua.” ");
INSERT INTO gvf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angel di tere ere ongure pare, yalini inin simil nen ta, God ka main aa gi di pirungwa, te nilerari yal sutan, “Ere wo,” di gala dungwa ungure, ");
INSERT INTO gvf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","kiibi kanungwa mere, bolin kule tere nusi erungure, ere Yopa ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pirere kol baan ul paire kwimile kwi pire Yopa gariba maala milungure, omale kaun Pita ana di God terala dire, ogu mine bolimina ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yalini kenan gule komina nerala di pirimba, ibal kobe komina ki milungure, yalini ul paire kiibi ta iru kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kamin kol yawlungwa kanungure, gal bilkaw mere ulin sui sui dungwa kan kule, mone mone di pusi main erungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Awi bolima te oniba te kauba kabe kaan kaan, gal ali gulungwa kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kanungure ka ta iru dungwa, “Pita i alere kabe si no.” ");
INSERT INTO gvf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Dimba Pita manaa dire dungwa, “Singabo, Yuda ibal komina manaa dungure, mawal ere goma ta nekiwa.” ");
INSERT INTO gvf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dungure ka ta kwi di yalini tongwa, “Komina ta ta i nenana dire, ‘God para dimua,’ dungwa, i manaa di tekio.” ");
INSERT INTO gvf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ginin sutakobe ul kiibi iru kanungure, kalkan i kwi ere kamin mina ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita kiibi kanungwa nomanin si gogo erere, main ta pirekire milungwa. Milungwa kaun i Konilias yal kobe nusi erungwa pire, “Saimon ogu alde dime?” sirin bile pirere, kaya kana giran ale milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Milere iru gala dungwa, “Saimon Pita ogu ala pai milemo?” ");
INSERT INTO gvf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita kiibi kanere main nomanin si pire milungure, God Iban di yalini tongwa, “Yal sutakobe i waa duumua. ");
INSERT INTO gvf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Na yalin kobe nusi erebinga i wi ime pire, yalin kobe miliaga bole para po. Nanga nomanin su su sikio.” ");
INSERT INTO gvf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dungure Pita yal sutakobe milungwa gul wi ime pire di tongwa, “I yal ta waa duunga, yalini na miliwa. Tameran une?” ");
INSERT INTO gvf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yalin kobe dungwa, “Simil nen kenin erungwa yal kaan Konilias, yalini wai wen mile yaa ime sire, God deminin si tongure Yuda ibal para wai pire tomua. I ka pore dinanga yalini pirama dire, God angel iru di yalini tomua, ‘Pita i ogin wo, di to.’” ");
INSERT INTO gvf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dungure Pita, “Ere ala wo,” di yalin kobe tongure, komina nere ul pai milungwa. Ul paire alungure, Pita kalkan aa tekun ere, yalini Yopa ka main aa gi di pirungwa enin kobe taw u kule, yal sutakobe bole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ongure kamin girungure, paire alere kwimile kwi kawn kule pire pi Sisaria ogu gul suna ongwa. Konilias enin kobe te ye nongwa, “U ku bilo,” dungure u ku bile Pita unangwa, suul milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ogu ala nala di ongure, Konilias Pita kawn mina gobin bile i kwi bile deminin si tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tomba Pita aan aa tere dungwa, “Alo, na gariba ibal para miliwa.” ");
INSERT INTO gvf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Dire yalsui ka dire dire ere ala ongure, ibal binanbile u ku bile milungwa kanere, ");
INSERT INTO gvf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita iru di ibalin kobe tongwa, “Yuda ibal te Yuda milekungwa ibal bole ka wai dire suna ta milekenangwa, Yuda main iru paangwa i kaninwa. Kaninba, God main iru di maribe ere na tongwa, ‘Yuda milekungwa ibal nomanin gule daalin ta sikemua,’ dire di na tongwa piriwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","I ‘Ere wo,’ di na tenga na wiina ere wiwa. Tameran, ‘Ere wo,’ di na tene?” ");
INSERT INTO gvf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dungure Konilias iru dungwa, “Ei pu dungwa kaun kamin kaun malia iru, na ogu ala ana di God teiwa. Tegire yal ta gal naabilungwa sigi dire, na gumanan kol ale mile ");
INSERT INTO gvf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","iru di na tongwa, ‘Konilias i ana dinga God pirere, te i aa te nekungwa ibal aa ki dinga, God para nomanin si piremua. ");
INSERT INTO gvf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yal ta nusi Yopa gariba ere, yal ta kaan Saimon Pita awli wo, di to. Bolima gain kal mirimil erungwa yal kaan Saimon, pirin nil binan ki paingure, Saimon Pita yalini bole ki paimua.’ ");
INSERT INTO gvf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iru dungure yal kobe nusi ere, ‘I ere wo,’ di kebe yobingire, i unga na wai pirebinwa. God u milungwa gul malia na ibal para milere, God ‘Ka do,’ di i tongwa mere pirala erebinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dungure Pita iru dungwa, “Ibal ke kuunin milama di, God iru nomanin si pirungwa malia na kaniwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Gariba gariba ibal para yaa ime sire deminin si God tere kal wai erungwa, ena God yalin kobe mun kal waa tekire, wai pire gun ye tomua. ");
INSERT INTO gvf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","God ka di Isirel ibal kobe tongwa, i piringa iru paangwa, ‘Yesu Kirisito kal para muru kobaan milungwa pire ka main iru kere di tongwa, na ibal nomanin taran yere wai wen milabinwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yon goma, ‘Nil bile to,’ kere di tongure pare, ka pore iray Yudia gariba kole kole para di ongure, Galili gariba gul kawn kule dimua. ");
INSERT INTO gvf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","God Nasarete ai nen Yesu konagi tere, God Kegemama Iban tere yobilaan para bile tongure, yalini pi konagi wai wen erere Satan ibal kanin kule paalungwa, yalini ibalin kobe aa ki dungure u wai omua. God yalini bole para milungwa kal main iru eremua. ");
INSERT INTO gvf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yalini Yuda ibal gariba suna te Yerusalem ogu gul suna, kal para erungwa na kanebinwa. Ibal kobe yalini eri pera mina nil bili si paalimba, ");
INSERT INTO gvf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kaun sutakobe wei sungure pare, God yalini aa ki dungure alungure, i maribe eremua. ");
INSERT INTO gvf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Erimba ibal para ta kanekimua. Na yal kobe kanama dire, God na paale suna ere ingwa, ena na yal kobe tawle kanebinwa. Yesu gulere alungure pare, na yal kobe yalini bole komina te nil para nobinwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","‘Na guunan kanan kere di ibal tere, te ibal kwi milungwa te gulungwa ka kol pire to,’ dire, ‘God iru di na tongwa mere, i bolin kule di maribe ere ibal to,’ Yesu iru di na yal kobe tomua. ");
INSERT INTO gvf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yalini milungwa mere ka kebe yal para iru dungwa, ‘Pire gi di yalini tenangwa ibal para, kal digan ere taalime erungwa God yal ta i kal wai ere ibal tongwa pire pirin paangwa i, kire di eremua.’” ");
INSERT INTO gvf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ka iru di milungure, God Kegemama Iban ere ime ure ka dungwa pirungwa, ibal den miriin suna ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","God yalini inin Kegemama Iban Yuda milekungwa ibal tongwa, Yuda ibal Yesu pire gi dungwa ibal, Pita bole para ungwa pire buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ibayal ka kowa kowa yuure God kaan aa te yebe erungwa, pire buul kunungure Pita dungwa, ");
INSERT INTO gvf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Na ibal kobe God Kegemama Iban ibinga mere, yalin kobe para imua. Ingwa nil bile terabinga ibal ta manaa dinangwa, ta paikimua.” ");
INSERT INTO gvf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dire pare kaman iru tongwa, “Yesu Kirisito kaan gale yebe ere nil bile i teralwa.” Dire nil bile tongwa. Tongure, “Are kaun taw na bole para milo,” di Pita tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ena nusi erungwa ongwa yal kobe, Aposel, te ka main aa gi di pirungwa enin kobe, Yudia gariba suna milere Yuda milekungwa ibal ka main aa gi di pirungwa yalin kobe pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pirere Pita Yerusalem ai u bawa dungure, Yuda ibal Yesu pire gi dungwa ibal mile, “Yuda milekungwa ibal gain bile ero,” iru dire kan tere ");
INSERT INTO gvf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","iru di Pita tongwa, “Yuda milekungwa ibal gain bile erekungwa, tameran i ogu ala ene? Tameran bole para komina nene?” ");
INSERT INTO gvf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dimba kalkan erungwa mere Pita di gawa dire dungwa, ");
INSERT INTO gvf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Na Yopa ogu ai ana di God te miliga omilan maalungure, na kiibi iru kaniwa. Gal bilkaw mere, ulin sui sui dungwa kan kule, mone mone di pusi main erungure, na miliga gul yaa main simua. ");
INSERT INTO gvf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na suna ali tena yuulin bile kanere awi bolima te kabe biin, te oniba te kauba kaniwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kanigire pare ka iru di na tongwa, ‘Pita, i ale kabe si no.’ ");
INSERT INTO gvf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dimba na manaa dire iru diga, ‘Singabo, Yuda ibal komina manaa dungure mawal ere, goma ta nekiwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Diiba kamin mina ka ta kwi iru dungwa, ‘Komina ta ta i nenana dire, God para paamua, dungwa i manaa di tekio.’ ");
INSERT INTO gvf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ginin sutakobe ul kiibi iru kanigire, kalkan i kwi ere kamin mina omua. ");
INSERT INTO gvf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kal iru erungwa kaun iray, na ogu ki pai milebinga gul, yal sutakobe u bawa dimua. Yal ta Sisaria gariba gul milere nusi erungure, na miliga gul umua. ");
INSERT INTO gvf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ungure God Iban di na tongwa, ‘Yalin kobe maliaga i bole para nanga, nomanin su su sikio.’ Ka main aa gi di pirungwa enin kobe anan kole muru kole taran ire, na bole para pire Konilias ogu ala obinwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Obingire yalini iru dungwa, ‘Angel ta na ogu u milungwa kanigire, iru di na tomua. I yal taw kobe nusi ere Yopa ai po. Nangure yal ta kaan Saimon, kaan kwi yongwa Pita, awli abila unamua. ");
INSERT INTO gvf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ka main ta bolin kule i tenangwa, i te enin kobe para aa ki di tenangure, sigare kule u wai nanwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na kawn kule ka di miliga, God Kegemama Iban goma na ibal kobe denan miranan suna ongwa mere, yalin kobe para den miriin suna omua. ");
INSERT INTO gvf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ongwa kaun i, ‘Yon nil wo bile tomba, God Kegemama Iban i tenangure inanwa,’ dire, Yesu Singaba goma ka iru dungwa piriwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na ibal kobe Singaba Yesu Kirisito pire gi dibinga, God yalini Iban na tongwa mere, yalin kobe tongwa na manaa di God teralo? Na yal digan miliga ta di tekerala.” ");
INSERT INTO gvf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Dungure ibal kobe pire unin si milere deminin si God tere iru dungwa, “Yuda milekungwa ibal nomanin suna si kiruul sire kwi mile painangwal painama dire, God iru ere tomua.” ");
INSERT INTO gvf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ena goma Sitiben si gulungwa kaun giil pire Yesu pire gi dungwa ibal tongure, pire gi dungwa ibal i, u sutaw ongwa. Pirere ibal taw kobe Pinisia gariba ongure, taw Saipiras gariba ongure, taw Antioko ai ongwa. U sutaw iru pirere ka main di Yuda ibal tawle tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tomba Saipiras ibal te Sairini ibal taw Antioko ai pirere, Singaba Yesu guun kan kere di Yuda milekungwa ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yesu Singaba yobilaan bile yalin kobe tongure, ibal binanwenbile pire gi dire, Yesu Singaba bole pena galungwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Iru ere milungwa ka main ibal taminin Yerusalem milungwa pirere, Banabas nusi Antioko ai erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","U bawa dire God kal wai ere ibal tongwa kane wai pirere, te ibalin kobe Yesu Singaba ka main aa girin di milama dire, yobilaan bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas yal wai milungure God Kegemama Iban yalini den miriin suna pirere sipapa sungure, yalini pire gi wen di milungwa. Ibal binanbile u Yesu Singaba gawliman ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ena Banabas Tasas ai pire Sol kanala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kanere pare awli Antioko ai ongwa, me erin ta yalin sui ka main ibal taminin di ku bilere, ibal binanbile ka nil si tongwa. Antioko ai ibal kobe Yesu gawlima kobe kawn kule kaan Kirisito Gawliman yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ena kaun iray ka kebe yal kobe Yerusalem ai pisere Antioko gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pi milere yal ta kaan Agabas alungure, God Iban aa bawle tongure iru di maribe erungwa, “Kenan bil gulungwa kaun gariba kole kole u maribe namua.” Dungwa kaun iray, Orom yal bil kaan Kilodias kenin erungwa kaun u maribe ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yesu gawlima kobe Antioko gariba gul milere u ku bile diria ere iru dungwa, “Na ibal kobe kulgal bona inan inan aa tobinga mere, kalkan nusi ere Yudia, Yesu ka main aa gi di pirungwa enan kobe, terabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Dungwa erere kalkan Banabas te Sol tongure, yal sui ire pire Yerusalem ka main goma yongwa yal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ena kaun malai yal bil Kerodi ka main ibal taminin taw giil tongure, kawn kule erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yon abinbia Yemis milungwa, “Di kuba pera aa tere si gulo,” Kerodi iru dungure si gulungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Iru erungure Yuda ibal kobe kane wai pirungwa Kerodi kanere, Pita para si kanin sungwa. Komina birete u bil pekungure Yuda ibal nere milungwa kaun, yalini iru ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kanin sire pare kanin paingwa ogu ala erungure, simil nen anan kole kole kawnan kole muru kole taranta, “Kenin ero,” di tongure, taminin sui sui kenin ere milungwa. God Yuda ibal sekungwa nomanin si pirungwa erin i, kaan Pasoba wei sinangure, awli Yuda ibal milungwa suna pire ka kol ere tere, “Si gulabinwa,” dire Kerodi iru nomanin si pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pirungwa ena Pita kanin paingwa ogu pai milungure, ka main ibal taminin ana wen di God te milungwal milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ena kamin taangure Kerodi Pita awli Yuda ibal milungwa suna nala di pirungwa, gilaa malai Pita ul pai milungure, simil nen sutan kole kole milungwa. Ain yobilagi kan sutan kan si tongwa milungure, el kwi nu milungwa yal kobe kana giran para kenin ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Milungure God Singaba angel ta gin taran u maribe ongure, ogu ala aw dire naabilungwa. Angel Pita aan kiban mina aa tere ulin yuure dungwa, “Wei di alo.” Dungure ain yobilagi kan aan mina kan kulungwa, gule erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Erungure angel di tongwa, “Kin dire kawn tobilin sigi do.” Dungwa erungure, kwi iru di tongwa, “Galsuna sigi dire na duulin bile wo.” ");
INSERT INTO gvf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Duulin bile pire angel erungwa i pirekire, kiibi kanungwa mere iru nomanin si pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","El kwi nu milungwa yal ta pisere ere pire, te el kwi nu milungwa yal ta ama si kire ere, ain yobilagi kana giran ere malge ongwa kol u bawa dungure, kana giran i, inin yawlungure ere malge pire, pi kombil bawa dungure, angel gin taran yalini pisere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Angel iru ere yalini tongwa, Pita nomanin si pire dungwa, “Malia na main pire bawa diwa. God Singaba angel ta nusi erungure, Kerodi te Yuda ibal kobe kal ki ere na terala di pirimba, na gule eremua.” ");
INSERT INTO gvf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita nomanin si pire mile pare, yalini Maria ogin ongure, Maria Yon Maka man milungwa. Ogu iray ibal binanbile u ku bile, ana di God te milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Milungure yalini kana giran si gule dire gala dungure, nilerari gi ta kaan Oroda kol yawle terala dire ungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Umba Pita ka dungwa naan pirere, miinin maare kol yawlekire kwi ere ala pire, “Pita u milemua,” di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Di tongure ibal kobe, “I gi du milinwa,” dimba gi iray “Yalini kirara kawen milemua,” dungure ibal kobe dungwa, “Yalini iban milemua.” ");
INSERT INTO gvf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pita kana giran si gule di milungure, ibal kobe kol yawlere kane buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ka dikire milama dire, aan kule manaa taan dire, God Singaba kanin paingwa ogu awli mena ongwa, bolin kule tere pare iru dungwa, “Ka pore iray Yemis te enin kobe di to.” Di tere ere baan ta ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kamin taangure el kwi nu milungwa yal kobe Pita milekungwa kanere, sigagu dire kane kole kole ere waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kerodi, “Waa duyo,” dungure waa duumba, kanekungwa. Kanekungure Kerodi ka kol ere el kwi nu milungwa yal kobe tere, “Si gulo,” dungwa. Kerodi iru dire pare, Yudia gariba pisere pi Sisaria ai pi milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ena Kerodi kaymin paale Taya te Saidon ibal kobe tongwa. Tongure Kerodi kanala dire, yalin kobe para wen u bawa dungwa. Yal ta Kerodi ogu kenin ere milungwa yal i kaan Bilasas, yalin kobe goma ka di yalini tongure, nomanin u taran ongwa. Dire pare pi Kerodi milungwa gul pire, “Yalin kobe komina yaalungwa gibilin si nobinwa,” iru nomanin si pire, ka iru di tongwa, “Inin ibal kobe bole pena gale milabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Maan di tenangwa kaun u bawa dungure, Kerodi gal wai wen sigi dire, yal bil bol mina amin di milere ka di ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Di tongure ibal kobe ka bil dire dungwa, “Ka dungwa i, ibal ta ka dikimia, kamin ibal ka dimua.” ");
INSERT INTO gvf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kerodi God kaan ai yebe dikungwa, God Singaba angel ta gin taran ure sungure, simin nele kabe nongure, gulungwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","God ka main nima ongure, guun kan gariba gariba ware biingwa. ");
INSERT INTO gvf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas te Sol Yerusalem ai mile konagi ere wei sire, Antioko ai kwi ure Yon Maka para awli ire ungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ena Antioko ai ka main ibal taminin milungwa, ka kebe yal kobe te nil si tongwa yal kobe para, iru mile kaan iru paingwa. Banabas, te Simion yalini kaan ta Naisa, te Sairini gariba nen milungwa kaan Ulusias, te yal ta yal singaba Kerodi ke kuunin mile ogu taran milungwa yalini kaan Maneyen, te Sol, yal iru milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yalin kobe deminin si ana di Yesu Singaba tere, komina mawal ere komina nekere ere milungwa, God Kegemama Iban di yalin kobe tongwa, “Banabas te Sol na konagi erama dire, di teiwa. Eramia ena paale suna ere iyo.” ");
INSERT INTO gvf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Dungure komina mawal ere nekere ana di God tere, aan yal sui gibilin mina yere, nusi erungure ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","God Kegemama Iban iru nusi erungwa pirere, yal sui Selusia ai pi bawa dire pare, sipe nil minin mina pi Saipiras gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pi Salamis ai u bawa dire Yuda ibal ka main ogu ala pirere, God ka main kere di tongwa. Yon Maka milere konagi aa ki di yal sui tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ena gariba iray para suna pire pare. Pepos ai pi bawa dungwa. Alia Yuda yal ta gia erere, ka kebe yal kakiibi di milungwa yalin kaan Baa Yesu milungure, yal kobe yalini guman kanungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Gariba iray kenin erungwa yal bil kaan Sesias Polas nomanin paangwa milungure, yal ta kaan Baa Yesu bole para milungwa. Yal bil iray God ka main pirala dire, Banabas te Sol, ‘Ere wo,’ di gala dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Gia erungwa yal kaan Giriki ka paingwa Elimas, kenin erungwa yal bil pire gi dekenama dire, yalini yal sui bolebilin di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Di tomba, Sol yalini kaan ta Pol milungure, God Kegemama Iban den miriin suna ongure, sipapa sungure, Pol tena yulin bile kanere ");
INSERT INTO gvf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","iru di tongwa, “Satan wan i milinwa. Kalkan para wai wen erungwa i kaymin paale tenwa. Kakiibi dire bawle tere, nomanin suna maa muulungure, Yesu Singaba kol wai bala di ibal tongwa, i su su ere milinwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Maliaga pire milo. Yesu Singaba i sinangure, kaun taw omilin gi dinangure are ta kanekinanwa.” Dungure si bilungwa ta omilin gi dungure, ibal aan aa tere awli nama dire, waa duungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Iru erungwa kenin erungwa yal bil kanere pire gi dungwa. Dungure Pol Yesu Singaba ka main nil si tongure yal bil i pire buul kune milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ena Pol te gawlima kobe, Pepos ai pisere sipe mina pi Pega ai pi bawa dungwa. Pega ai Pambilia gariba suna dungwa, Yon Maka yalin kobe pisere kwi sinaa dire Yerusalem ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yalin kobe Pega ai pisere, Antioko ai Pisidia gariba suna dungwa pi bawa dungwa. Sare kaun Yuda ibal ka main ogu ala pire amin di milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Milungure Mose ka minin ganin bilungwa, te ka kebe yal kobe ka minin ganin para bilungwa kerungure pare, Yuda ka main ogu yal singaba kobe nusi erungure, iru di tongwa, “Enan kobe, na ibal kobe wai milabina dire, ka dinanga mere, di na to.” ");
INSERT INTO gvf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dungure Pol alere ka dikire milama dire, aan kule manaa taan dire dungwa, “Isirel nen kobe, te Yuda ta milekinga ibal kobe yaa ime sire God deminin si tenga para, ka di terala piro. ");
INSERT INTO gvf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Na Isirel ibal kobe God na sanamoi gilekume paale suna ere ingure, Isipi gariba gul milungwa, maale sulu dimua. God inin yobilaan bilere awli umua. ");
INSERT INTO gvf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ibal kobe gariba simi yongwa gul me erin yal su aan kawn muru milere, kal gogo erungwa. God kane unin si mile bole ware milemua. ");
INSERT INTO gvf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","God Kenan gariba ibal bilin anan kole muru kole sutan sire pare, gariba obin si Isirel ibal tongure, kobaan milemua. ");
INSERT INTO gvf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Milungure me erin binanwenbile, po kandret pipti wei sungure, ka kol pirungwa yal kobe i maribe erungure, mili ongwa ongwa, ena ka kebe yal Samuel u maribe omua. ");
INSERT INTO gvf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yuda ibal kobe, ‘Yal singaba bil na to,’ dungure God, Kis wan Sol i maribe ere tomua. Sol yalini Bensamin gawlin kobe milere, me erin yal su aan kawn muru kenin ere milemua. ");
INSERT INTO gvf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","God yalini piserere, yal singaba bil ta kaan Debiti, konagi kwi yalini tomua. Debiti milungwa God iru dungwa, ‘Yesi wan Debiti na nomanin si piriga mere, yalini kuunin piremia, na ka di yalini terabinga wiina ere milamua. Na iru wen kaniwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Debiti gawlin kobe ta kaan Yesu, aa ki dinangure Isirel ibal kobe sigare kule u wai pi milama dire, God nusi ere tomua. God aan kere yere, ‘Iru eralwa,’ dungwa, milin bole u maribe omua. ");
INSERT INTO gvf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu gariba gul konagi kawn kule erangwa kaun u maala ongure, Yon goma ka main kere di Isirel ibal tongwa, ‘Kal digan ere taalime eringa nomanin suna si kiruul sire, nil bile tenangure iyo.’ ");
INSERT INTO gvf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yon konagi erungwa wei sirala di pirere dungwa, ‘Na milebingi piringa, takal nomanin si pirine? Kirisito ta milekiwa. Diiba piro. Yalini inin eme u maribe namua. Na yalini gal kine teralba, na yal digan miliwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Na enan kobe, Ebarakam gawlin milinga, te Yuda milekungwa ibal deminin si ana di God tenga para, God na ibal kobe aa ki dinangure, sigare kule u wai nabinga ka main iray na tomua. ");
INSERT INTO gvf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalem ki paangwa ibal kobe, te yalin kobi singaba kobe yalini guman kawen ta kanekire, te ka kebe yal kobe ka minin ganin bilungwa Sare kaun kaun kerungwa, para ta kanekimua. Kanekimba Yesu gulangwa owa dungwa, ka kebe yal ka di paalungwa u maribe omua. ");
INSERT INTO gvf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yesu si gulangwa main ta waa duumba, ta kanekimua. Kanekimba, ‘Yalini si gulo,’ di sirin bile yal Pailete tomua. ");
INSERT INTO gvf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yesu milungwa ka main minin ganin bile paalungwa mere, muru u maribe ongure, eri pera mina i main erere yobilagi kobile giran ali yomua. ");
INSERT INTO gvf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Yomba God ulin yuungure, Yesu alemua. ");
INSERT INTO gvf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Alere yalini bole Galili gariba gul pi Yerusalem ai ongwa, ibal are kaun kaun miriki u maribe pi yalin kobe tomua. Malia yalin kobe, kanungwa yal kobe milere, bolin kule Isirel ibal tomua. ");
INSERT INTO gvf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Na ibal kobe Yesu guun kan di i terabina di milebinwa. ‘Iru ere teralwa,’ dire God aan kere yere iru milin bole di na ibal kobe sanamoi gilekume tongwa mere, malia Yesu gulere alungwa God iru erungwa, i maribe ere sanamoi gilekume gawlin kobe na ibal kobe na tomua. Ka main geril Sam, arin sutan minin iru bilungwa, ‘Na Wanane kemina i Nenin na miliwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yesu gulere alungwa God iru erungure, eme kwi gain bile yaakinamua. God iru dungwa minin ganin bile paalungwa, ‘Na Debiti kal wai ere i teralwa, dire aan kere yere di tega mere, i para wen teralgire, pi tegi yenanga painamua.’ ");
INSERT INTO gvf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ka main geril Sam, minin ganin para iru bilungwa, ‘God, i kabin sire wai wen milungwa yal i aa ki dinangire, gain bile yaakinamua. I iru dinwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","God konagi ere Debiti tongure, erere pare gulungure, sanamoi gilekume yongwa ai binan maul si yongure, gain bile yaamua. ");
INSERT INTO gvf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yaamba yal ta gulere alungwa, God ulin yuungure alungwa, yalini gain bile yaakimua. ");
INSERT INTO gvf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ena na enan kobe, ka di teralga pire nomanin suna yeyo. Kal digan ere taalime erebinga, God Yesu aa te wai ere na tongwa pire, pirin i kire di erangwa, ka pore bolin kule di i teiwa. Pire gi di Yesu tongwa ibal para, kal digan ere taalime erungwa God kire di ere, ‘Kabin sire wai wen milinwa,’ di tomua. Mose kile kaman ka bile paalungwa, kal digan i kire di erekinangwa paamua. ");
INSERT INTO gvf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ka kebe yal kobe ka dungwa mere i yal kobe pire ikirala dinanga, nomanin si pirekun ere milo. ");
INSERT INTO gvf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Aya, God ka main kaymin paale tenga, yal kobe pire milo. I gariba gul milinga kaun na konagi ta erabinga, yal ta di i tenamba, i ta pire tekenanwa. Buul kuningi, wei sinanwa.’” ");
INSERT INTO gvf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ena Pol te Banabas yal sui ere mena ongure, ibal kobe iru di tongwa, “Sare kaun ta ka i dinga kwi di na to.” ");
INSERT INTO gvf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ka main u ku bilungwa u sutaw ongure, Yuda ibal te Yuda milekungwa ibal Yuda ka main aa gi di pirungwa para, binanbile Pol te Banabas duulin bile ongwa. Ongure God kal wai ere tongwa aa gi di milama dire, yal sui kiraan sire ka di nima pi tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ena Sare kaun kwi ungure, gariba iray ibal para muru u ku bile God ka main pirala di ungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ibal binanbile u ku bilungwa Yuda ibal kanere, san balere, Pol ka dungwa di gogo ere yaa ime si tere gain ka si tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol te Banabas yal sui, ka di bawa dire iru dungwa, “God ka main goma di i tongwa para paamba, i ka main i mun kal waa tere, te ‘Mile pairalgal pairala dire, na kuunin erekibinwa,’ dire i iru nomanin si piringa, na yasu i yal kobe pisere pi Yuda milekungwa ibal di terabinwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","God Singaba kaman iru na yal kobe na tongwa, ‘Kewa galinga mere kol i maribe ere Yuda milekungwa ibal tenanga, God aa ki dinangure ibal sigare kule u wai nangwa, ka iray ibal gariba gul muru i di ibalin kobi tenanwa.’” ");
INSERT INTO gvf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ka dungwa i Yuda milekungwa ibal pirere wai wen pirere, God Singaba ka main di yebe erungwa. Mile painangwal painama dire God paale suna ere ingwa ibalin kobe, pire gi dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gariba gul iray God Singaba ka main ware kuunin biingwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Warimba Yuda ibal kobe ka way ere, Yuda milekungwa abal singaba deminin si ana di God tongwa, te ogu ai bil yal singaba tere, kaymin paale Pol te Banabas tere, “Ere po,” dire aa nusi gariba baan ta erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Erimba yalsui guman yaa tere kal iru erungure, nomanin sire main pirungwa. Pirungure ere Aikoniam ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Gawlima kobe wai pire gun yongure, God Kegemama Iban yalin kobe den miriin suna ongure sipapa sungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ena goma Antioko ai kal erungwa mere, Aikoniam ai para erungwa. Pol te Banabas Yuda ibal ka main ogu ala pirere ka dungwa milin paangure, Yuda ibal te Giriki ibal binanbile pire gi dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yuda ibal Yesu ka main pire gi dekungwa yalin kobe milere, Yuda milekungwa ibal kobe deminin ki yere ka main enin kobe tenama dire, yalin kobe ibal kobe kiraan sungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Yal sui iray gariba iray baan araway mile, Yesu Singaba milungwa mere niminin mile ka di tongwa. God kal wai ere tongwa ibal kawen pirama dire, Yesu Singaba yobilaan bile yal sui tongure, kal guman kwi dungwa erere, te kal ta erungure ibal buul kunungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ogu gul iray u ku bilungwa ibal obin sirere, taw Yuda ibal bole yongure, taw nusi erungwa ongwa yal kobe, Aposel bole yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yuda milekungwa ibal te Yuda ibal te singaba bole kobile kuba irere, yal sui si gulala di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pirimba yal sui kiraan pirere, si ere Ilikionia gariba gul ongwa. Pi Ilista ai pire, Debi ai pire, te gariba binan kole kole para ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Gariba gul iray Yesu guun kan kere di ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ena Ilista ai yal ta kawn pema kiingwa, amin di milungwa. Man kule nongwa kaun kol ta warekire, iru pai milungwal milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pol ka dungwa yalini pirere, “U wai nalwa,” dire pire gi dungwa, Pol pirere tena yuulin bile kanere ");
INSERT INTO gvf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ka bil dire iru dungwa, “Kawnin egile du dire milo.” Dungure gin taran alere kol warungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pol kal erungwa ibal taminin bil kanere, gala dire Ilikionia ka kowa yuure iru dungwa, “Na inan kamin ibal u ibal pire gariba gul ime ungure, na ibal bole milebinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ibal kobe Banabas, kaan ta Sus yongure, te Pol kamil kaa kobaan milungwa kanere, kaan ta Kemis yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sus kobile galbale ogu, ogu ai binan dungwa, kamin ibal ta kaan Sus kenin erungwa yal, egin galala dire kalkan yuure, bolimakau awli ungwa. Urere yalini te ibal kobe bole kabe si ki nuse erungwa ongwa yal kobe, Aposel, terala di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pirimba Banabas te Pol kanere gal aa dinaa dire, ibal u ku bilungwa suna mugu di pire gala dungwa, ");
INSERT INTO gvf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yalkane, tameran iru erine? I ibal milinga mere, na yalsu ama iru milebilwa. Yesu guun kan di i terala dire ubilwa. Kal piril sungwa main main i mun kal waa tere, God naanin pai milungwa i guman mina yenana dire di tobilwa. God kamin te gariba te pirin nil te kal para wen suna milungwa, ere yomua. ");
INSERT INTO gvf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ibal goma maalungwa para kalkan inin nomanin si pirungwa mere erama dire, God kane unin si milemua. ");
INSERT INTO gvf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Dimba God mile ibal kobe na kirara milama di pire, kal wai i maribe eremua. Kal wai ere i tongwa main iru paangwa, nimin sungure komina sinin sungure nere kubin maangure, miinin maare gun yere milinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aposel yal sui manaa dire ka iru dungwa mere, ibal kobe nomanin si pire kabe ki terala di pirere, piserungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Gariba iray yal sui milungure, Antioko ai te Aikoniam ai Yuda ibal u bawa dire, ibal kiraan sungure, ibal i kawen paalere, Pol kobile kuba sire gulema di pire gure i ogu mena kol erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Erimba gawlima kobe ure mile wenabe sire kanala di erungure, Pol alere ogu ai malge ongwa. Ul paire kamin taangure, yalini te Banabas para ere Debi ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pi milere Yesu guun kan kere di tongwa ibal binanbile, pire gi dire u gawlima kobe ongwa. Ongure yal sui sinaa dire kwi Ilista ai omia, Aikoniam ai omia, Antioko ai Pisidia gariba gul binan dungwa para omia. ");
INSERT INTO gvf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pire gawlima kobe pire gi di nima pire milama dire, ka iru di tongwa, “Pire gi di milangal milo.” Dire iru nil si tongwa, “God kenin ere ke milungwa ai suna nabinga, goma giil binanbile pire eme suna nabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ka main taminin ta ta para ka main goma yongwa yal kobe milama dire, yal sui yal taw paale suna ere ingwa. Ire komina mawal ere ana di God tere, yalin kobi Yesu Singaba pi tegi yongwa yal sui kanere, yalin kobi Yesu Singaba aan mina yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ena Pisidia gariba pi suna pire, Pambilia gariba gul pi bawa dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pega ai ka main di tere pare, Atelia ai wi ime ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pi mile pisere sipe ala pire pi nil mina ere Antioko ai ongwa. Goma ai iray pisere ka main konagi ere piserungwa, goma erala di ongwa kaun, ka main ibal taminin God aa ki di yal sui tenama dire, ana dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioko ai iray u bawa dire ka main ibal taminin, “U ku bilo,” dungure u ku bilungure, God yal sui aa ki dungure konagi erungwa, te Yuda milekungwa ibal pire gi dinangwa kol bala di tongwa, ka pore ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Yal sui, pire gi dungwa ibal kobe bole baan araway pai milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ibal taw kobe Yudia ai pisere pi Antioko ai u bawa dire, iru nil si ka main ibal kobe tongwa, “Mose main paingwa mere yalgo gain bile erekinanga, ena God aa ki di i tekenangure sigare kule u wai ta pekenanwa.” ");
INSERT INTO gvf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ka iru dungwa Pol te Banabas pirere ka bolebilin dungure, kura paingwa. Paingure Pol te Banabas te ibal taw pi Yerusalem nusi erungwa ongwa yal kobe, Aposel, te ka main goma yongwa ibal singaba kobe, bolebilin dungwa main di tenama dire, nusi erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ka main ibal taminin kobe nusi erungure, yalin kobe pirere Pinisia gariba omia, Sameria gariba omia, “Yuda milekungwa ibal nomanin suna si kiruul sire God pire gi dimua,” dungure ka main enin kobe wai wen pire gun yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yalin kobe Yerusalem ai pi bawa dungure, ka main ibal taminin, te Aposel kobe, te ka main goma yongwa ibal, aya maya dire kaalungwa, God aa ki dungure ka main konagi erungwa mere, bolin kule tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tomba Parasi taw kobe pire gi dungwa yal milungwa, alere dungwa, “Yuda milekungwa ibal gain bile erangwa kuunin paimua. Ena ‘Mose kile kaman ka dungwa mere, para wiina ero,’ di tenangwa paamua.” ");
INSERT INTO gvf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nusi erungwa ongwa yal kobe, Aposel, te ka main goma yongwa ibal, ka iray diria ere di kuunin erabina dire, u ku bilungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ibal binanbile diria ere milungure pare, Pita alere di tongwa, “Enan kobe, goma na ibal kobe milebinga, Yuda milekungwa ibal Yesu guun kan kere di tegire pire gi dinama dire, God na paale suna ere imua. ");
INSERT INTO gvf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God Kegemama Iban na ibal kobe tongwa mere, Yuda milekungwa ibal tongwa God nomanin kanungwa kobaan milere, ‘Para paimua,’ dimua. ");
INSERT INTO gvf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","‘Ibal ke kuunin milemua,’ dungure ibal kobe pire gi dungure, God nomanin kule parin ere tomua. ");
INSERT INTO gvf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tongwa, tameran God ka dungwa sua i kanine? I iru dinga kal obin dongwa pire gi dungwa ibal kine tenga, na sanamoi gilekume te na ibal kobe para kine warebinga, i kuunin erekimua. ");
INSERT INTO gvf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Na ibal kobe iru pirebinga, Yesu Singaba aa te wai ere ibal tongwa pire God aa ki dungure yalin kobe sigare kule u wai nangwa mere, na ibal para iru u wai nabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","U ku bilungwa ibal sime mile pire milungure, God yal sui man mile tongwa, Pol te Banabas kal guman kwi dungwa erungwa, te kal erungwa ibal buul kunungure erungwa mere ka pore di tongure, ibal kobe pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dungure pare Yemis maan iru di tongwa, “Enan kobe, ka dirala piro. ");
INSERT INTO gvf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","God kol bala di Yuda milekungwa ibal tongwa, yalin kobe taw pi yalini gawlima kobe omua. Goma God kawn kule iru erungwa mere, Saimon di na tomua. ");
INSERT INTO gvf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Iru erungwa mere, ka kebe yal ka dungwa iru kuunin paimua. Ka main minin ganin iru bilungwa paamua. ");
INSERT INTO gvf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘God Singaba iru dungwa, Na kwi sinaa dire ure Debiti ogu guru di yaangwa kwi kiiralwa. Ogu suule u sutaw ongwa mere, Debiti gawlin kobe iru omba, na kwi aa tekun eralwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Aa tekun erabinga, yal imo milungwa te Yuda milekungwa ibal na paale suna ere igire, na kaanan gale yebe erala dire, na gala dire waa duunamua. ");
INSERT INTO gvf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","God Singaba goma ka iray di maribe erere malia kwi dimua.’” ");
INSERT INTO gvf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yemis kwi ainere di tongwa, “Ka kebe yal iru dungwa mere, na nomanin pire kwi iru diralwa. Yuda milekungwa ibal nomanin suna si kiruul sire God pire gi dungwa, konagi nega wen di ta tekerabinwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tekerabinba gi abal kunibe nekenama dire, te kobile galbale kabe si ki tongwa, te kabe naan aa di dire si gulungwa te mayan para nekenama dire, ka minin ganin iru bile terabinwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ka i manaa di tobinga iwe. Mose kile kaman ka goma bilungwa, kere sanamoi gilekume tere, kere yuungwa malia Sare kaun kaun Yuda ka main ogu ala kere tongwa pirebinwa. Ogu i dungwa mere mere Mose ka dungwa kere di ibal kobe tomua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Dungure nusi erungwa ongwa yal kobe, Aposel, te ka main goma yongwa yal kobe, te ka main ibal taminin muru, “Yal taw na suna milungwa Pol te Banabas bole Antioko ai nangwa nusi erabinwa,” dire nomanin taran si pirungwa. Ka main yal singaba sutan paale ire, yal ta kaan Yudas Basabas te yal ta kaan Sailas paale suna ere ingwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ka minin ganin iru bile tongure, yal sui i ongwa. “Aposel kobe te ka main goma yongwa yal kobe, na yal kobe i enin kobe milebinwa. Yuda milekungwa ibal enin kobe Antioko ai te Siria gariba te Silisia gariba milinga, aya maya, di tere ka minin ganin bile tobinwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Na ibalan kobe taw i milinga gul ongure, ka dungwa i nigi de pire nomanin sutan sinwa. Na ibalin kobi kaman tekere, nusi erekibinwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ibalin kobi ka dungwa pirebinga ena na yal kobe u ku bilere yal taw kobe paale suna ere irere, nusi ere i milinga gul erala dire, nomanin taran sibinwa. Yal taw kobi na ye nega yal sui Banabas te Pol bole namua. ");
INSERT INTO gvf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yal sui konagi ere Yesu Kirisito Singaba tongwa, ibal si gulala dimba, kuril pirekire konagi ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yal taw kobe nangwa iwe, Yudas te Sailas yal sui nusi erebingire, na ka minin ganin bile tobinga mere, yal sui ka i di i tenamua. ");
INSERT INTO gvf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","God Kegemama Iban te na ibal kobe bole nomanin taran iru sibinwa. Konagi nega wen di ta ere tekerabinba, kaman iru di i tobinga, ");
INSERT INTO gvf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","‘Kobile galbale kabe si ki tongwa, nekio. Kabe mayan ta nekio. Kabe naan aa di dire si gulungwa para nekio. Gi te abal kunibe ikio.’ I kal iru mun kal waa tere ta erekinanga, wai wen milanwa. Para we.” ");
INSERT INTO gvf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bilere pare nusi erungure, pirere Antioko ai u bawa dire ka main ibal taminin di ku bilere ka minin ganin bilungwa tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tongure kere wai pire ka iru bilungwa wai pire gun yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ena Yudas te Sailas God ka kebe yal milungwa, ka binanbile kaman tongure, ibal kobe pire gi dungwa pi nima ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yal sui kaun taw mile kwi sinaa di ere nama dire, ibal para “Ere po,” dungure ibal kobe nusi erungure kwi ere ain ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Omba Sailas Antioko ai milala di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol te Banabas te ibal binanbile bole Antioko milere, Yesu Singaba ka main kere di tere nil si tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ena kaun taw mile pare, Pol iru di Banabas tongwa, “Goma na yasu Yesu Singaba ka main bolin kule ibal kobe tere ogu ai para muru, ka main ibal taminin milungwa mere kanabina, nabina wo.” ");
INSERT INTO gvf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Dungure Banabas yal ta kaan Yon Maka awli nala di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pirimba goma ka main konagi erere yalini Pambilia ai sinaa dire ere ain pire bole para pekungwa, Pol iru nomanin si pire dungwa, “Yalini na bole nangwa, kuunin paikimua.” ");
INSERT INTO gvf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dungure yal sui bolebilin dire girin di milungwa, guman inin inin dungwa. Banabas Maka awli ire ere sipe ali pire, nil minimina Saipiras gariba gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol Sailas paale suna ere irere, Yesu Singaba aa te wai ere yalsu tenama dire, ka main enin kobe ana di God tongure ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pirere Siria gariba suna pire, Silisia gariba suna pire, ka main ibal taminin yobilaan bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ena Pol Debi ai pire, te pi Ilista ai bawa dungure, Yesu gawlima kobe yal ta kaan Timoti milungure, yalini man Yuda abal mile pire gi di Yesu tongure, yalini nen Giriki yal milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Enin kobe Ilista ai te Aikoniam ai milere, Timoti kaan di yebe erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol Timoti awli nala di pire, gain bile ere tongwa. Yuda ibal ali ki paingwa, “Timoti nen Giriki yal milemua,” dimia gain bile ere tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ogu ai bil ta ta ongwa, “Nusi erungwa ongwa yal kobe, Aposel, te Yerusalem ka main goma yongwa yal kobe kaman tongwa mere, wiina ero,” di ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Di tongure ka main ibal taminin pire gi dungwa, pi nima ongure, are kaun kaun ibal binanbile pire gi di Yesu tongure, u taminin bil ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ena yalin kobi pi Pirisia gariba te Galesia gariba suna ongwa. Esia gariba gul pire ka main kere di terala dimba, God Kegemama Iban manaa dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia gariba gumilin pi bawa dire Bitinia gariba gul nala di omba, Yesu Iban “Po,” di tekungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Di tekungure Misia gariba suna pire wi ime pi Toroas ai milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Milere gilaa iray Pol kiibi iru kanungwa, Masedonia yal ta alere iru ana di gala dungwa, “I Masedonia gariba gul ure na ibal kobe aa ki di tenana wo.” ");
INSERT INTO gvf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol kiibi kanere pare, “Yesu guun kan di Masedonia ibal tenanwa,” God iru di na ibal tongwa iru nomanin si pirere, Masedonia gariba gul nabina dire, kalkan gin taran aa tekun erebinga. ");
INSERT INTO gvf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ena Toroas ai pisere sipe ala pire, nil mina pi Samotires ai pire kamin taangure, pi Niapolis ai milebinga. ");
INSERT INTO gvf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ai iray pisere pi Pilipai ai milebinga. Ogu ai i main dimin bil i maribe erungure, Orom ibal gariba iray ki pai milungwa. Are kaun taw ogu ai iray pai milebinga. ");
INSERT INTO gvf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sare kaun u bawa dungure, ogu ai mena pire nuule binan obinga. Ibal ana di God tongwa gul ana di milim mo, kanabina dire obinga. Pirere abal kobe u ku bilungwa kanere, amin di mile ka main di tobinga. ");
INSERT INTO gvf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Abal ta kaan Ilidia deminin si ana di God tere, te nobe mayan gal aibe tobe erangwa yongure, ibal gibilin sungwa. Abalini, Tayataira ibal kule nongwa. Pol ka dungwa abalini nomanin suna si pirama dire, God Singaba abalini den miriin awra di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Abalini te enin kobe para nil bile tongwa. Tongure abalini kawan iru di na yal kobe tongwa, “Na Yesu Singaba pire gi wen di tobinga i iru kananga, ena na ogu pai milana wo.” Di milungwa milungwa, ena na yal kobe obinga. ");
INSERT INTO gvf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ena ana di God tongwa ai obinga, nil erari gi ta sia den miriin suna paingure, eme kal ta painangwa goma di maribe erungwa. Abalini ibal kobe kal iru erangwa di maribe erere, kobile moni binanbile ire ke milere duulin bile warungwa yal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Abalini Pol te na yal kobe duulin bile ware iru gala dungwa, “Yalin kobe God bil wen nilerari yal milungwa, u wai nanga kol i maribe eremua.” ");
INSERT INTO gvf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Gala dungwai, are kaun kaun di milungure, Pol nigi de pire sinaa dire iru di sia tongwa, “Na Yesu giran mina di i teiwa. Abalini den miriin suna pisere ere mena po.” Dungure gin taran u mena ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Abalini ke milere duulin bile warungwa yal kobe, moni kwi ta aa te nekerabina di kanere, Pol te Sailas galsuna aa gi dire, yal kobe gure pala di ka kol pirungwa yal kobe milungwa gul ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Awli pi ka kol pirungwa yal kobe milungwa gul pire iru dungwa, “Yal sui Yuda ibal mile taalime ere na ibal kobe na tongwi, ki eremua. ");
INSERT INTO gvf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Yal sui main paingwa nil si na ibal kobe tomba, Orom ibal milere duulin bile warabinga paikimua.” ");
INSERT INTO gvf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ibal binanbile u ku bile milungwa para kaymin paale tongure, ka kol pirungwa yal kobe yal sui galsuna gule ingure, “Kuba so,” di tongure, kuba aa tere sungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Binanbile sire pare kanin paingwa ogu ala erere, kanin paingwa ogu kenin erungwa yal kol mama yaale kenin dobil erama dire, di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Di tongure kanin paingwa ogu kenin erungwa yal, yal sui i pi suna wen i ere, eri buule temine alibe yere kawn kole sungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Gilaa taanima Pol te Sailas para geril dire ana di God te milungwa, kanin paingwa ibal pire milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ememe bilkaw gin taran ungure, ogu main te kawligi ku tere bole erungure, gin taran kol para yawlungure, kanin paingwa ibal para aan kawn mina ain yobilagi kan sungwa, gule erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kanin paingwa ogu kenin erungwa yal alere, kol para yawlungwa kanere, “Kanin paingwa ibal para ere mena omua,” iru di nomanin si pirere, di kuba pera kin sungwa gure pala di ire, inin si gulala di erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Erimba Pol gala bil dire dungwa, “Na ibal para mama wen milebinga, i inin si gulekio.” ");
INSERT INTO gvf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kenin erungwa yal, “Kewa galo,” dungure galungure, yalini mugu di pi ala pire Pol te Sailas kawn mina i kwi bile milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Yalini yal sui awli mena pirere sirin bile tere dungwa, “Yalkuno, God aa ki dinangure na sigare kule u wai nala dire, takal konagi erale?” ");
INSERT INTO gvf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Dungure yal sui dungwa, “I Yesu Singaba pire gi dinanga, ena God i, te enin kobe bole aa ki dinangure sigare kule u wai nanwa.” ");
INSERT INTO gvf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Dire Yesu Singaba ka main di yalini te ibal para ki pai milungwa tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Gilaa taanima kaun iray awli pirere, kuba sungwa bilungwa i, nil kule bigin si tongwa. Tongure yalini te enin kobe para nil bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tongure yalini Pol te Sailas awli ogin ala pirere, komina ki tongwa. Yalini te enin kobe pire gi di God tongwa, wai pire gun yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kamin taangure ka kol pirungwa yal kobe simil nen nusi ere iru di tongwa, “Yal sui kan gule ere awli mena po.” ");
INSERT INTO gvf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Di tongure ongure, kanin paangwa ogu kenin erungwa yal ka iray di Pol tere dungwa, “Ka kol pirungwa yal kobe nusi erere, ‘Yal sui kan gule ero,’ dungwa, i mena pire wai wen milo.” ");
INSERT INTO gvf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Dimba Pol iru di simil nen tongwa, “Na Orom ibal milebilgire, na kal digan erabilga ka kol pire na tenamba. Na tekungwa kuba ibal kobe guman mina na sire kanin paangwa ogu ala erungwa iwe. Malia yalin kobe aal kule nusi mena erala di piremua. Pirimba ta paikimua. Yalin kobe inin ure na yal sui awli mena namua.” ");
INSERT INTO gvf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pol dungwa simil nen pirere ka iru di ka kol pirungwa yal kobe tongwa, “Yal sui Orom ibal milemua.” Dungure pirere sigagu dire kuril pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pirere ka ura paangwa dire, “Miriin pirebinwa,” dire awli mena pire ai i pisere yal sui ere nama dire, di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Di tongure kanin paangwa ogu ere mena pire Ilidia ki paingwa gul pire, ka main enin kobe guman kanere ka di yobilaan bile tere, ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ena yal sui pi Ampipolis ai suna pire, pi Apolonia ai para suna pire, Tesalonaika ai pi bawa dungwa. Ai iray Yuda ka main ogu ta dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol goma erungwa mere yalini Sare kaun sutakobe Yuda ka main ogu ala pire, ka main minin ganin kerungure, ka diria ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","God konagi erungwa yal, Kirisito, giil pire gulere alungwa, ka main minin ganin di paalungwa, kere i maribe ere iru dungwa, “Yesu kan di i tega, yalini Kirisito milemua.” ");
INSERT INTO gvf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ibal taw kobe, “Yalini kawen dimua,” dire Pol te Sailas bole pena gale milungure, Giriki ibal deminin si ana di God tongwa yalin kobe te abal singaba binanbile para, bole pena gale milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Erimba Yuda ibal yal sui den miriin ki ye tere yal digan taw irere, ibal kobe binanbile u ku bilere wi yau dungwa, yalin kobe Yeson ogu kol di guru dire, yal sui awli ibal milungwa gul urala di pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Yal sui waa duungwa kanekire, Yeson te ka main enin kobe taw gure pala di ogu ai ka kol pirungwa yal kobe milungwa gul ongwa. Pirere iru gala dungwa, “Gariba gariba taalime ere tongwa, yalin kobe abila u bawa dire milemua. ");
INSERT INTO gvf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","U milungure Yeson komina aa te wai ere tere bole para paimua. Yal bil Sisa ka dungwa pire yaa ime sire, yal bil ta kaan Yesu guun kan taran tawle, ‘Wiina ere to,’ dimua.” ");
INSERT INTO gvf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ka iru dungwa, ibal kobe te ogu ai ka kol pirungwa yal kobe sigagu dire wi yau dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ka kol pirungwa yal kobe, “Kan gule ere terala dire, kobile moni na to,” di Yeson te ibalin kobe tongure, kobile moni tongure, kan gule erungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ena kamin girungure Tesalonaika ka main enin kobe mile, Pol te Sailas nusi Beria ai erungure, pirere pi bawa dire Yuda ibal ka main ogu ala ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ai malai Yuda ibal kobe nomanin paire ka dungwa ere gule pirala di milere, Tesalonaika ibal milungwa mere, ta milekungwa. Ka main dungwa dobil wen pirere, are kaun kaun muru Pol ka dungwa kawen dim mo, kakiibi dim mo, ka main minin ganin kere nomanin si pirungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pirere ibal binanbile pire gi dungure, Giriki abal singaba te yal kobe para pire gi dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","“Pol Beria ai mile ka main kere di ibal kobe tomua,” dungure Tesalonaika ai Yuda ibal pirere, Beria ai ure gariba kobaan den miriin ki ye tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ye tongure enin kobe Pol nusi pirin nil binan erimba, Sailas te Timoti bole Beria ai mile paangwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ibal kobe Pol awli pi Atens ai erungure, Pol iru kaman tongwa, “Sailas te Timoti kananga, ‘Na miliga gul gin taran po,’ di nusi ero.” Dungure ibal kobe kwi ere Beria ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ena Sailas te Timoti Atens ai unangwa, Pol suul milere, ogu ai iray galbale kobile bilkaw binanbile dungwa kanere, nigi de pire den miriin ki yongwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yerere Yuda ibal ka main ogu ala pirere, Yuda ibal te Yuda milekungwa ibal God deminin si tongwa, Pol te yalin kobe bole ka bolebilin dungwa. Are kaun kaun ogu ai malge ibal ungwa para, ka bolebilin dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikurian ibal ka main te Sitoiki ibal ka main nil si tongwa, yalin kobe Pol bole ka bolebilin dire taw iru dungwa, “Ka milin paikungwa yal, takal waa di na tename?” Dungure taw ama iru dungwa, “Gariba baan ta kamin ibal di maribe eremua.” Pol Yesu guun kan te Yesu gulere alungwa ka dungware, yalin kobe iru dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ena yalin kobe Pol awli u ku bilungwa ibal kaan Ariopagas milungwa gul pirere dungwa, “I ka kwi nil si na tenga pirala erebina. ");
INSERT INTO gvf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","I ka di ta eringa na ibal kobe pirekun erekibina, main wen di maribe ere na tenanga pirabinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Iru dungwa Atens ibal te baan ta ibal Atens ki paangwa, morin morin ka kwi dire, te main kwi pire ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Iru milungure Pol u ku bilungwa ibal kaan Ariopagas suna alere dungwa, “Atens nen kobe, i inin ka main aa gi wen di piringa kaniwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na suna kobi wariga i kalkan deminin si ana di tenga kanere, kobile bol ta kanigire, minin ganin bolimina iru bile paalungwa, ‘God ta pirekebinga, ere yalini tobinwa.’ God ta pirekire deminin si ana di tenga i, yalini ka main bolin kule teralga piro. ");
INSERT INTO gvf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God gariba ere yere, te gariba bolimina kal main main para ere yomua. Kamin te gariba God Singaba milungwa, yal kobe ka main ogu kiingwa yalini ala ki pai milekemua. ");
INSERT INTO gvf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ibal kobe giran miin pu dungure milungwa, yalini ibal iru ere yongwa, ena ibal kobe konagi ere yalini tenamba, yalini kal ta waa duukimua. ");
INSERT INTO gvf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Gariba ibal muru sanamoi gilekume yal taran ta milungwa, ena ibal para maale sulu dungwa. Main paangwa i God iru erungwa, God gariba bilin ta ibal kamin kaun u maribe nama dire, te gariba bilin para muru dinangwa u maribe nama dire, God kaya nomanin si pire eremua. ");
INSERT INTO gvf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ibal kobe God waa duunama dire, yalini inin iru erimba, aa maa yere kanam mo, kanekinam mo, yalini tayan ta milekungwa na ibal kobe milebinga gul maala milemua. ");
INSERT INTO gvf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Yalini milungwa, ena na ibal kobe kol ware kwi milebinwa.’ I inin ka minin ganin bilungwa yal taw kobe iru bilungwa, ‘Yalini gawlin kobe milebinwa.’ ");
INSERT INTO gvf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","God gawlin kobe milebinga, ‘Kobile gol te ain yobilagi te kobile kal miremil erungwa yal balungwa mere, God iru milemua,’ nomanin si pirekerabinwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Goma ibal kobe pirekun erekungwa kaun God kane unin si milimba, malia ibal gariba gariba para muru kal digan ere taalime erungwa pisere, nomanin suna si kiruul sinama dire, kaman tomua. ");
INSERT INTO gvf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","God yal ta paale suna ere ingure, yal ta i ibal gariba gariba para muru mile pai erungwa mere pire kirara kawen ka kol pire tenangwa, God kaun ta balungwa paamua. Ibal kobe kawen dima di pirala dire, paale suna ere ingwa yal i gulere alungwa, God iru eremua,” dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","“Yalini gulere alemua,” Pol iru dungure, ibal taw di gogo erimba, ibal taw iru dungwa, “Ka i dinga, kaun ta kwi pirala erebinwa.” ");
INSERT INTO gvf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dungure Pol ibal milungwa gul pisere ere ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ibal tawlita Pol bole pena galere ka main pire gi dungwa. U ku bilungwa ibal kaan Ariopagas, yalin kobi milungwa suna yal singaba ta kaan Dayonisias, te abal ta kaan Damaris, te ibal taw kobe pire gi dungwa ibal suna milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ena Pol Atens ai pisere ere Korin ai ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pi milere Yuda yal ta kaan Akwila kanala di pirungwa. Yal Akwila we, goma Pol yalini guman kanungure, yalini Pontas ai nen milimba, yalini te ebinbi kaan Pirisila, Itali gariba gul ki pai milungwa. Milungure, “Yuda ibal Orom ai pisere baan ta nanwa,” dire yal bil Kilodias iru dungwa, yalini iray kaun ta i ere Korin ai pi milungwa. Milungure Pol yal abal sui kanala dire ongwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pirere yal abal sui sel ogu kiire konagi erungwa mere, Pol para konagi iru erere, bole paire konagi ere milungwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sare kaun kaun para muru yalini Yuda ibal ka main ogu pirere, ka main kere bolebilin dire Yuda ibal te Giriki ibal yalini bole nomanin u taran nabina dire, di tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas te Timoti bole Masedonia ai pisere u bawa dungwa kaun, Pol ka main kere di ibal tere konagi taran erere, “Yesu mile God konagi erungwa yal, Kirisito, milemua,” di maribe ere Yuda ibal tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Di tongure kaymin paale tere gain ka sungure, Pol galsuna gariba ulgu tariba kiingwa, bigan kule tongwa mere ere iru dungwa, “I enderin gaul ai nanga i inin kanin painamia, na kanan ta paikinamua. Maliaga na Yuda milekungwa ibal milungwa gul di terala dire nalwa.” ");
INSERT INTO gvf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dire pare yalin kobe pisere Yuda milekungwa yal ta kaan Tisias Yasitas ogin ki pairala di ongwa. Yal ta i ana di deminin si God tongure, yalini ogin Yuda ka main ogu binan dungwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yuda ka main ogu yal singaba kaan Kirisipas, pire gi di Yesu Singaba tongure, ebin gawlin kobe para pire gi dungure, Korin ibal binanbile Pol ka dungwa pirere pire gi dungure, nil bile tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Gilaa ta Pol ul kiibi kanungure, Yesu Singaba ka iru di tongwa, “Na i bole miliga kuril pirikio. Ka main dinga morin di dire milo. Ogu ai iray na ibalan kobe binanbile milungwa, ibal taw kobe kal gogo ta ere i tekenamua.” ");
INSERT INTO gvf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iru dungure Pol ai iray me erin ta te ta kole milere, God ka main nil si ibal kobe tongwa. ");
INSERT INTO gvf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Orom yal singaba kobe Akaya gariba gul, yal bil Galio, konagi tongure, ere milungwa. Yuda ibal nomanin u taran pire Pol kaym