﻿USE sofia;
DROP TABLE IF EXISTS sofia.gvc_vpl;
CREATE TABLE gvc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gvc_vpl WRITE;
INSERT INTO gvc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo coyeare panopʉ macainare õ sehe ni yahuihtja yʉhʉ. Jesucristo ñʉchʉno cjiro panopʉ macariro Davi wama tiriro jia tiha. To jihto pano ti ñʉchʉno cjiro Abrahã wama tiriro jia tiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahã Isaa pʉcʉro jiha. Isaa Jacobo pʉcʉro jiha. Jacobo Juda cʉ̃hʉ pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda pohna pʉaro jiha. Fares, Zara jiha. Ti pocoro Tamar wama tiricoro jiha. Fares Esrom pʉcʉro jiha. Esrom Aram pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab pʉcʉro jiha. Aminadab Naasón pʉcʉro jiha. Naasón Salmón pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz pʉcʉro jiha. Booz pocoro Rahab jiha. Booz Obed pʉcʉro jiha. To pocoro Rut jiha. Obed Jesé pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesé Davi pʉcʉro jiha. Davi sehe Israe masa bui pʉhtoro jiha. Tiro Uria wama tiriro cjiro namonore to nʉoari baharo Salomo wama tirirore pohna tiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo Roboã pʉcʉro jiha. Roboã Abías pʉcʉro jiha. Abías Asa pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafat pʉcʉro jiha. Josafat Joram pʉcʉro jiha. Joram Uzías pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotam pʉcʉro jiha. Jotam Acaz pʉcʉro jiha. Acaz Ezequia pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequia Manase pʉcʉro jiha. Manase Amón pʉcʉro jiha. Amón Josia pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia Jeconia cʉ̃hʉ pʉcʉro jiha. Tina ti jiri pjare Israe yahpa macainare Babilonia macaina sehe ñaha wahcãha ti ya yahpapʉ. ");
INSERT INTO gvc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ã yoa Babilonia yahpai ti sʉri baharo, Jeconia Salatiere pohna tiha. Salatie Zorobabe pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabe Abiud pʉcʉro jiha. Abiud Eliaquim pʉcʉro jiha. Eliaquim Azor pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Zadoc pʉcʉro jiha. Zadoc Aquim pʉcʉro jiha. Aquim Eliud pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar pʉcʉro jiha. Eleazar Matán pʉcʉro jiha. Matán Jacobo pʉcʉro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobo José pʉcʉro jiha. José María manʉno jiha. María sehe Jesu pocoro jire. Jesu sehe masare yʉhdohtiro jiro Cristo ti ni pisuriro jire. ");
INSERT INTO gvc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tó sehe jiro Abrahãre mari quihõ mʉhtachʉ, pʉ Davipʉre mari quihõ batoachʉ ahrina jipihtina ti panamana ji turiaina mehne jia, catorce curuari waro jiha. Pari turi Davire mari quihõ mʉhtachʉ, pʉ Babiloniapʉ Israe masare ti naahto pano mari quihõ batoachʉ jipihtina ti panamana ji turiana mehne jia, catorce curuari waro pari turi jiha. Ã yoa tuhsʉ Babiloniapʉ ti sʉri baharo mari quihõ mʉhtachʉ, pʉ Cristo to masa bajuachʉpʉ mari quihõ batoachʉ jipihtina ti panamana ji turiaina mehne jia, catorce curuari waro jiha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ã yoa õ sehe Jesucristo masa bajuari jire. To pocoro María sehe José namono cjihto jiri jire. Wiho mejeta ti pʉaro ji dʉcahto pano Espíritu Santo to tuaa mehne wahma nijinocãre bocaro masiha ticoro to basi. ");
INSERT INTO gvc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ã yoa José to manʉno cjihto quihõno yoariro jiro, tíre masino, ticorore cohãno taro nimaha. Masa ti ñʉrocaroi ticorore buhiri tichʉ yoa duaeraro, masa ti tʉhoerasinichʉta yaroca ticorore cohãno taro nimaha. ");
INSERT INTO gvc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tíre to tʉhoturo watoi Cohamacʉ anjo sehe cahãnopʉ Josére bajuaro, õ sehe niha: —José, Davi cjiro panamino, Maríare bʉo tiro marieno namo tiga. Ticoro Espíritu Santo to yoadohoro mehne wahma nijinocãre bocaricoro jira. Ã jicʉ bʉo tiro marieno namo tiga ticorore. ");
INSERT INTO gvc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ticoro pohna tirohca. Tirota to macʉnota to masare, pichacapʉ wahaborinare yʉhdohtiro jirohca. To ã yʉhdohtiro jichʉ ñʉcʉ, Jesu ni wama pisuihca mʉhʉ —niha anjo Josére. ");
INSERT INTO gvc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Panopʉ macariro Cohamacʉ yare yahu mʉhtariro cjiro “Ã waharohca”, to ni joariro seheta ahri jipihtia ã wahaa tiha. Ahri ã wahahtore õ sehe ni joa dutia tiha Cohamacʉ tirore: ");
INSERT INTO gvc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Cʉ̃coro nuhmino, ne mʉno mehne jieraricoro, nijinocãre bocaro pohna tirohca to macʉnocãre. Tirocã Emanuel wama tirohca”, ni joaa tiha Cohamacʉ yare. (Emanuel nino: “Cohamacʉ mari mehneta jira”, nino nica.) ");
INSERT INTO gvc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cohamacʉ anjo Josére to ã ni yahuri baharo José sehe wahcã, anjo to dutiriro seheta tiro María mehne wamomaca dʉhteha. ");
INSERT INTO gvc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","To macʉnocãre to pohna tihto pano José sehe ticoro mehne jiera tiha. Baharo ticoro sehe pohna tia wahaha. Tiro sehe wihãrirocãre Jesu wamoaha. ");
INSERT INTO gvc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herode Judea yahpa macaina ti bui pʉhtoro to jiri pja tí yahpai jiri macai Belẽi Jesu masa bajuaha. To ã masa bajuari baharo ñahpichohare buheina ñahpichohare noano masiina sʉ̃ mʉja taro macaina ta, Jerusalẽpʉ wihiha. ");
INSERT INTO gvc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ã wihia, masare tó macainare sinituha: —¿Judio masa ti bui pʉhtoro jihtiro cjihto mipʉre nohopʉ masa bajuacari tiro? Sʉ̃ mʉja taropʉ jina, ñahpichohaca to wahma bajua wahã sʉchʉ ñʉna, “Pʉhtoro masa bajuaro nica”, ni masihi sã. Ã to bajuachʉ ñʉna, sã cʉ̃no mehne tirore ño payona tana tahi õpʉ —ni yahuha buheina masare. ");
INSERT INTO gvc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ã yoa paina Herodere tíre yahua tiha. Ti ã yahuchʉ tʉhoro Herode sehe soro tʉhotuha. Ã jia jipihtina Jerusalẽ macaina cʉ̃hʉ to yoaro seheta soro tʉhotuha tina cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ã jiro Herode sehe jipihtina sacerdotea pʉhtoare, mari judio masare buheina cʉ̃hʉre to pjirocari baharo ti cahmachu pihtichʉ ñʉno, tinare sinituha tiro: —¿Nohopʉ masa bajuarohcari Cristo sehe mʉsa tʉhotuchʉ? —ni sinitu ñʉha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Õ sehe ni yahuha tirore: —Belẽi, Judea yahpai jiri macai Cristo masa bajuarohca. Õ sehe ni joaa tiha Cohamacʉ yare yahu mʉhtariro cjiro: ");
INSERT INTO gvc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belẽi yʉ yainare Israe masare dutihtiro tarohca. Ã jiro paye macari Judea yahpai jia macari yʉhdoro jira Belẽ”, ni joaa tiha Cohamacʉ yare —ni yahuha tina Herodere. ");
INSERT INTO gvc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ti ã ni yahuri baharo Herode masa ti marieno watoi sʉ̃ mʉja taropʉ tarinare pjirocaha. To cahapʉ tina ti sʉchʉ ñʉno, tinare sinitu ñʉha. To ã sinitu ñʉchʉ tʉhoa, ñahpichohacare ti ñʉri dachore yahuha tina. ");
INSERT INTO gvc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ti ã yahuri baharo Herode sehe tinare Belẽpʉ warocaro õ sehe niha tinare: —Tirocãre noano macaga. Tirocãre bocana tjuahna yʉhʉre yahu tjuahga. Yʉhʉ cʉ̃hʉ tirocãre ño payoi wahai tai nija —nimaha tinare Herode. ");
INSERT INTO gvc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","To ã niri baharo, tina wahaa wahaha. Ti ã wahachʉ sʉ̃ mʉja taroi ti ñʉria ñahpichohaca sehe mʉ tãrucuha. Ã yoa wihãrirocã to jiro bui waroi tjua wahã sʉha tia sehe. ");
INSERT INTO gvc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ã jia ñahpichohacare ñʉa, tuaro wahcheha tina. ");
INSERT INTO gvc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wihãrirocã to jiri wʉhʉpʉ sʉ, sãa wahaha tina. Ã sãa sʉa, wihãrirocãre to pocoro mehne jirirocãre ñʉha tina. Ã ñʉa tina na tuhcua caha sʉ, tirocãre ño payoha. Ño payo tuhsʉ ti caa pocare naroca pjõoroca, urure, inciensore, mirra wama tia me sitia cʉ̃hʉre na wio, tíre tirocãre wapa marieno waa tiha. ");
INSERT INTO gvc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tíre wa tuhsʉ carĩa wahaha tina. Ti ã carĩchʉ cahãnopʉ Cohamacʉ yahuha tinare: “Herode cahai tjuaena tjiga”, ni yahuha Cohamacʉ tinare cahãnopʉre. To ã ni yahuri baharo, tina sehe wahcãha. Ti ã wahcãri baharo pa mahapʉ ti ya dihtapʉ tjuaa wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ti ã wahari baharo Cohamacʉ anjo cahãnopʉ Josére bajuaro, õ sehe niha: —Wahcãga. Herode sehe maharirocãre wajãno taro, macano nina mipʉre. Ã yoa maharirocãre, to pocoro cʉ̃hʉre Egiptopʉ cjero na duhti wahcãa wahaga. Tópʉre yʉ niriro purota jiga —ni yahuha anjo Josére. ");
INSERT INTO gvc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","To ã nichʉ tʉhoro, José sehe ñamiihta wahcã, maharirocãre to pocoro cʉ̃hʉre Egiptopʉ na duhti wahcãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egiptopʉ sʉa, Herode to catiro puro tópʉre jiha tina. Ã yoaha panopʉ macariro Cohamacʉ yare yahu mʉhtariro cjiro to ni joariro seheta. Tíre tirore Cohamacʉ joa dutia tiha. Õ sehe ni joaa tiha Cohamacʉ yare: “Egiptopʉ jirirore yʉ macʉre pjirocahi”, ni joaa tiha Cohamacʉ yare. ");
INSERT INTO gvc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ã yoa ñahpichohare buheina ti duhti yʉhdʉachʉ tʉhoro Herode sehe sua yʉhdʉaha. Ã suaro, Belẽ macainare, tí maca dʉhtʉ caha macaina cʉ̃hʉre ti pohnare mʉa pohnare pʉa cʉhma cjʉainacãre wajã batoa dutiha tiro. Wahmanore ñahpichoha buheina ñahpichohacare ti ñʉri dachore yahuha Herodere. Ti ã nichʉ tʉhoro tiro to wajã duarirocã to masa bajuari dachore masino, “Õpe cʉhmari cjʉara” nino, pʉa cʉhma cjʉainare wajã batoa dutiha. ");
INSERT INTO gvc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Panopʉ macariro Jeremía Cohamacʉ yare yahu mʉhtariro cjiro to ni joariro seheta ã wahaha. Õ sehe ni joaa tiha tiro: ");
INSERT INTO gvc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá wama tiropʉ bisiro coa tarohca. Tuaro cahyaa mehne tiiro coa tarohca. Raquel panamana numia ji turia numiapʉ Israe masa namosãnumia ti pohnare tuaro tiiahca. Ti pohnare ti wajãchʉ ñʉa, ne cahya duhusi”, ni joaa tiha panopʉ. ");
INSERT INTO gvc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ã yoa Herode to yariari baharo Egiptoi jirirore Josére Cohamacʉ yairo anjo cahãnopʉ bajuaha. Ã bajuaro õ sehe niha Josére: ");
INSERT INTO gvc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Maharirocãre wajã duaina cjiri yariaa wahahre. Ã jicʉ tirocãre to pocoro mehne Israe yahpapʉ na tjuaa wahaga mʉhʉ —ni yahuha anjo Josére. ");
INSERT INTO gvc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","To ã niri baharo tiro wahcã, maharirocãre to pocoro mehneta Israe yahpapʉ na tjuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wiho mejeta Arquelao Herode macʉno sehe to pʉcʉro cohtotariro to jichʉ tʉhoro José sehe Judea yahpai cuiro, tjuaeraha. Ã jiro pari turita cahãnopʉ tirore yahu namoha tjoa. Tirore pari turi Judea yahpare ji dutieraha. To ã ni yahuri baharo, tina Galilea yahpapʉ wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tí yahpapʉre Nazare wama tiri macai jiha tina. Ã yoaha tina Cohamacʉ yare yahu mʉhtaina cjiri ti joariro seheta. Õ sehe ni joaa tiha: “ ‘Cristo Nazare macariro tjira’, niahca masa”, ni joaa tiha Cohamacʉ yare yahu mʉhtaina panopʉ macaina. ");
INSERT INTO gvc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ã yoa baharopʉ João masare bautisariro jiha. Judea yahpai masa marienopʉ tiro Cohamacʉ yare yahu dʉcaha masare. ");
INSERT INTO gvc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Õ sehe ni yahuha tinare: —Mʉano macariro Cohamacʉ mʉsa pʉhtoro to sʉho jihto mahanocã dʉhsara. Ã jina “Ñano yoaeraja”, mʉsa ni tʉhotumari cjirire duhuga. Mʉsa ñaa buhirire cahya, Cohamacʉ sehere cahmaga mʉsa —ni yahuha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Panopʉ macariro Isaia Cohamacʉ yare yahu mʉhtariro cjiro João to buhehtore õ sehe ni joaa tiha: “Masa marienopʉ cʉ̃iro sañurucu, õ sehe ni buherohca: ‘Mari pʉhtoro to tahto pano tirore cahmaeraina cjiri mʉsa tʉhotuare cohtota, tirore cahmaina jiga mʉsa’, ni sañurucu buherohca”, ni joaa tiha Isaia cjiro João cjihtore. ");
INSERT INTO gvc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tiro João camello pjoari suhtirore sãariro, wahiquiro cahsaroreta tʉã dihoriro jiha. Poreroare, macaroca macaina miquina mi cʉ̃hʉre chʉa tiha. ");
INSERT INTO gvc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalẽ macaina, jipihtiro Judea yahpai jiina, Jordão wama tiri ma cahai jiina cʉ̃hʉ tirore tʉhoa taha. ");
INSERT INTO gvc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wihi, tirore tʉho, ti ñaa yoarire Cohamacʉre yahuha tina. Ti ã ni yahuchʉ tʉhoro Jordão wama tiri mai João tinare bautisaha. ");
INSERT INTO gvc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ã jiro payʉ fariseo curua macaina, saduceo curua macaina cʉ̃hʉ Joãore ti bautisa dutia tachʉ ñʉno tiro tinare õ sehe ni yahuha: —¿Mʉsa cʉ̃hʉ agãa ñima tiina yoaro sehe mʉsa mahñoa buhea mehne masare dojomehneina jina, Cohamacʉ mʉsare to buhiri dahrehto pano tirore cui, duhti masierara mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ã jina potocãta mʉsa ñaa buhirire bʉjʉa witi, Cohamacʉre cahmana jiihna, noaa yoa ñoga. ");
INSERT INTO gvc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","’Õ sehe ni tʉhotuena tjiga: “Panopʉ macariro Abrahã mari ñʉchʉ cjiro jia tiha. Ã jina to panamana jina mari Cohamacʉ yaina jija”, ni tʉhotuena tjiga mʉsa. Mʉsare niita nija. Abrahã panamana jiina jimana mʉsa. Mʉsa ã jipachʉta tí mʉsa ã jia yaba cjihti jierara. Cohamacʉ sehe ahri tãa mehne Abrahã coyeare dahre masina. Ã jiro Abrahã coyea mʉsa jia wiho waro jira tãa ti wiho waro jiro seheta. ");
INSERT INTO gvc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Õ sehe jira: Masa yucʉri yoaro seheta jira. Cohamacʉ sehe coma mehne yucʉrire cjã cohãriro yoaro sehe jira. Ã jiro noaa dicha maria yucʉre nʉhcõri mehnepʉta cjã cohãnohca tiro. Tíre to cjã cohãri baharo, pichacapʉ jʉ̃ cohãnohca tiro. Ãta yoaro taro nina masa cʉ̃hʉre tirore cahmaerainare. ");
INSERT INTO gvc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yʉ baharo yʉ bui tuariro tarohca. Noa yʉhdʉariro jira tiro. Tiro yoaro sehe jieraja yʉhʉ sehe. Ã jicʉ tirore tʉhotucʉ, “Wiho jiriro jija yʉhʉ”, ni tʉhotuja yʉhʉ. Yʉhʉ sehe mʉsa ñaare tʉhotumari cjirire tʉhotu cohtotainare diapʉ bautisacʉ, co mehne yoamahi. Tiro sehe yʉ yʉhdoro yoarohca. Espíritu Santore masa mehne ã jirucuchʉ yoarohca tiro. Wiho mejeta paina sehere ñaare ti tʉhotumari cjirire duhu duaeraina sehere tiro pichaca mehne buhiri dahrerohca. ");
INSERT INTO gvc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yʉ baharo tariro cahsari cohãriro yoaro sehe jira. Cahsari cohãriro to batiro mehne jipihtia to trigo yapari cahsarire putiwera. To ã putiweri baharo trigo sehere to wihbori wʉhʉi wihborohca. Tó seheta yoarohca tirore cahmainare yʉ baharo tariro. To putiwea cahsari sehere tiro jʉ̃nohca. Tí pichaca ne yatisi. Ãta yoarohca tiro yʉ baharo tariro tirore cahmaerainare —ni yahuha João. ");
INSERT INTO gvc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Baharo Jesu Galileapʉ jiriro cjiro waha, Jordão wama tiri mapʉ buhu sʉha Joãore bautisa dutiro. ");
INSERT INTO gvc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wahmanore João tirore bautisa duaeramaha. —Neho, mʉhʉ sehe yʉ yʉhdoro tuariro yʉhʉ sehere mʉ bautisachʉ noaboa. Mʉhʉre bautisaboriro jieraja yʉhʉ —ni yʉhtimaha João Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu sehe õ sehe ni yʉhtiha tirore: —Yʉhʉre bautisasiniga. Õ sehe yoana, Cohamacʉ to dutiriro seheta sohtori tina nija mari —niha Jesu. To ã nichʉ tʉhoro: —Jai —ni yʉhtiha João. ");
INSERT INTO gvc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ã ni tuhsʉ, Jesure bautisaha. To bautisa tuhsʉchʉ Jesu diapʉ ducuriro maja sʉrʉcʉ sʉha. To maja sʉrʉcʉ sʉchʉta, mʉano parĩ mʉaha. Cohamacʉ to Espíritu buja yoaro sehe tiro bui to duji tachʉ ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","To ã duji tachʉ mʉanopʉ durucuro coa taha: —Ahriro yʉ macʉ yʉ cahĩriro jira. Tiro mehne tuaro wahcheja —nino coa taha mʉanopʉ. ");
INSERT INTO gvc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ã yoa Espíritu Santo sehe Jesure masa marienopʉ naaha, tópʉ watĩno tirore ñaare to yoa duti ñʉhto sehe. ");
INSERT INTO gvc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tópʉ sʉro cuarenta dachori waro chʉro marieno jiha Jesu. Ã jiro jʉca baaha. ");
INSERT INTO gvc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jʉca to baachʉ ñʉno watĩno sehe tiro cahapʉ sʉro, õ sehe niha: —Mʉhʉ Cohamacʉ macʉno jicʉ, ahri tãa pocare chʉa dojomehnega —nimaha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesu õ sehe ni yʉhtiha: —Yoaeraja. Cohamacʉ yare ti joari pũi õ sehe nina: “Masare chʉa mehne dihta catieraro cahmana. Jipihtia Cohamacʉ to ya yahua mehne jiro cahmana”, nina Cohamacʉ —ni yʉhtiha Jesu watĩnore. ");
INSERT INTO gvc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","To ã ni yʉhtiri baharo watĩno sehe Jerusalẽpʉ “Cohamacʉ ya maca”, ti niri macapʉ Jesure naaha. Tópʉ na sʉro, Cohamacʉ ya wʉhʉ bui Jesure na sʉha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na sʉ tuhsʉ, tirore õ sehe nimaha: —Cohamacʉ yare ti joari pũ õ sehe nina: “Cohamacʉ to anjoare mʉhʉre ñʉ wihbo dutirohca. Ã jia tina sehe mʉhʉre ñʉ wihboahca, ‘Tãcapʉ pʉha tu mʉari’ nia”, nina ti joari pũ. To ã niri potocã jichʉ mʉhʉ Cohamacʉ macʉno jicʉ yahpapʉ pju bora ñoñʉjʉta yʉhʉre. Mʉhʉre tina ti yoadohochʉ ñoñʉjʉta yʉhʉre —nimaha watĩno. ");
INSERT INTO gvc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu pju bora ño duaeraro õ sehe ni yʉhtiha: —Cohamacʉ yare ti joari pũ õ sehe nina: “Mʉsa pʉhtoro Cohamacʉ to niri cjirire ‘¿Potocã tjijari?’ ni masi duana Cohamacʉre yoa ño duti macaena tjiga”, nina Cohamacʉ yare ti joari pũi —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","To ã ni yʉhtiri baharo mʉa yʉhdʉdʉ tʉ̃cʉpʉ Jesure na mʉjaha watĩno tjoa. Tʉ buipʉ mʉja pja sʉ, jipihtia macarine ñoroca boroha Jesure. Ti cjʉaa cʉ̃hʉre ñoha. ");
INSERT INTO gvc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ã ñono Jesure õ sehe nimaha: —Yʉhʉre na tuhcua caha sʉ, ño payoga mʉhʉ. Mʉ ã yoachʉ jipihtia ahri macarine mʉhʉre waihtja —ni yahumaha watĩno. ");
INSERT INTO gvc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","To ã nichʉ Jesu õ sehe ni yʉhtiha: —Satana, wahaga mʉhʉ. Õ sehe nina Cohamacʉ yare ti joari pũi: “Mʉ pʉhtoro Cohamacʉ dihtare ño payoga. To ya dutia dihtare yoaga”, nina Cohamacʉ yare ti joari pũi —niha Jesu watĩnore. ");
INSERT INTO gvc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","To ã nichʉ tʉhoro watĩno wahaa wahaha. To wahari baharo anjoa sehe wihi, Jesure yoadohoa tirore chʉa waha. ");
INSERT INTO gvc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ã yoa Joãore peresu ti yoachʉ tʉhoro, wahaa wahaha Jesu. Waha, Galilea yahpapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tói jiri macapʉ Nazarepʉ waha, yʉhdʉ wahcã, Capernau wama tiri macapʉ sʉha. Galilea wama tiri bʉcʉpariro dʉhtʉ cahai jira Capernau. Tí maca Zebulõ yahpa cahai, Neftalí yahpa cahai jire Capernau. Tópʉ sʉ, jiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ãta yoaha Jesu panopʉ macariro Cohamacʉ yare yahu mʉhtariro Isaia cjiro to ni joariro seheta. Õ sehe ni joaa tiha: ");
INSERT INTO gvc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulõ yahpa cahai, Neftalí yahpa cahai, bʉcʉpariropʉ waharoi, Jordão pa bʉhʉsehe coapʉ Galilea yahpa jira. Tí yahpa judio masa jieraina ya yahpa jira. ");
INSERT INTO gvc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tó macaina Cohamacʉ yare noaare masierara. Ã masierapahta noarirore ñʉapʉ masiahca. Tina sehe Cohamacʉre ne masierara. Ã jia pichacapʉ wahaborina jimaha. Ã jiro cʉ̃iro tinare Cohamacʉ yare masichʉ yoarohca”, ni joaha Isaia cjiro. ");
INSERT INTO gvc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tópʉ jiro, Cohamacʉ yare yahu dʉcaha Jesu: —Mʉsa ñaare tʉhotumari cjirire duhu, noaa sehere tʉhotu cohtota, Cohamacʉreta macaga mʉsa. Mʉano macariro Cohamacʉ jipihtina bui pʉhtoro to sʉho jihto mahanocã dʉhsara —ni yahu dʉcaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ã yoa Galilea wama tiri bʉcʉpariro dʉhtʉ cahapʉ Jesu sito wahcãmahno ñʉha Simore, to bahʉro Andre mehne. Simota Pedro ti ni pisuriro jiha. Tina sehe wahi wajãina jia, ti wañʉyucʉrire doca ño mʉjaa niha bʉcʉpariropʉ. ");
INSERT INTO gvc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Yʉhʉ mehne macaina cjihti taga mʉsa. Yʉhʉ mehne mʉsa tachʉ, mʉsa wahire ñaha cahmachuina mʉsa jiro seheta, Cohamacʉ yaina cjihtire masare pji cahmachuina cjihtire yoaihtja mʉsare. Yʉhʉ mehne mʉsa tachʉ ã yoahtina cjihtire cũihtja mʉsare —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","To ã nichʉ tʉhoata ti wañʉyucʉrire cũnoca, tiro mehne wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ã yoa Jesu tina mehne yʉhdʉ wahcã, Santiagore to bahʉro João mehne boca sʉha tjoa. Tina Zebedeo pohna jiha. Ti yaria dohoriai ti pʉcʉro mehne tina cʉ̃hʉ ti wañʉyucʉrire cahnoa niha. Tina pʉarore tiro pjirocaha. ");
INSERT INTO gvc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","To ã pjirocachʉ tʉhoa, tina sehe dóihta ti pʉcʉrore, dohoria cʉ̃hʉre cũ, Jesu mehne wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ã yoa jipihtiro Galilea yahpare Jesu buhe tiniha. Judio masa mari buhea wʉhʉsepʉ noaa buheare, mʉano macariro pʉhtoro to sʉho jia tiare buheha. Tinare buhe, dohatiinare noaina wahachʉ yoaro jipihtia dohatiare cohãha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","To ã yoaare tʉhoa Siria yahpa macaina jipihtiropʉ tí yahpai jiina tirore masi dʉcaha. Ã masia, soro jia dohatia cjʉainare, tuaro purĩare cjʉainare, watĩa ti sãanohrinare, ñama yaria mʉnare dohatiinare, tini masieraina cʉ̃hʉre na sʉha. Ti ã na sʉchʉ ñʉno jipihtina tinare noaina wahachʉ yoaha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","To ã yoachʉ ñʉa, Galilea yahpa macaina, Decapoli wama tiropʉ jia macari macaina, Jerusalẽ macaina, Judea yahpa macaina, Jordão pa bʉhʉsehe coa macaina payʉ masa tiro mehne wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Masa payʉ to cahai ti sʉchʉ ñʉno Jesu tʉ̃cʉpʉ mʉjaha. Mʉja sʉ, tói dujiha. Tói to dujichʉ to buheina sehe tiro cahapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ti sʉchʉ ñʉno õ sehe ni buhe dʉcaha: ");
INSERT INTO gvc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ti ñaa tʉhotumari cjirire duhu, noaa sehere tʉhotu cohtotaina Cohamacʉre cahmaina wahcheina jira. Mʉano macariro pʉhtoro to sʉho jiropʉre wahaahca tina. Mʉano macaa ti ya jira. ");
INSERT INTO gvc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Yahco tiina cʉ̃hʉ wahcheina jira. Tinare wahchechʉ yoarohca mari Pʉcʉ. ");
INSERT INTO gvc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Painare yʉhdʉrʉca duaeraina ã jica nieraina wahcheina jira. Cohamacʉ “Waihtja”, tinare to nirire cjʉaahca tina. ");
INSERT INTO gvc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Cohamacʉ to dutiro sehe yoa duaina, noaare yoa duaina wahcheina jira. Cohamacʉ to yoadohochʉ tina noaare yoa sohtori tiahca. ");
INSERT INTO gvc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Painare pja ñʉina wahcheina jira. Ti ã pja ñʉchʉ Cohamacʉ tina cʉ̃hʉre pja ñʉnohca. ");
INSERT INTO gvc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ti ñaa buhirire cosanohrina wahcheina jira. Cohamacʉre ñʉahca tina. ");
INSERT INTO gvc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Masare bosaina wahcheina jira. Tinare “Yʉ pohna jira”, ninohca Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Cohamacʉ dutiare ti yoari buhiri ti ñano yoanohrina sehe wahcheina jira. Mʉano macariro pʉhtoro to sʉho jiropʉ to yare cjʉaahca tina. ");
INSERT INTO gvc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yʉ yare mʉsa yoari buhiri paina mʉsare ti tuhtipachʉta wahcheina jira mʉsa. Mʉsare ti ñano yoapachʉta wahcheina jira mʉsa. Yʉ yaina mʉsa jiri buhiri mʉsare jipihtia ñaa ti quiti dojomehnepachʉta ti mahñopachʉta wahcheina jira mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cohamacʉ yare yahu mʉhtainare mʉsa pano jiinare tinapʉreta ñano yoa mʉhtaha. Mʉsa cʉ̃hʉre ti yoariro sehe ti yoachʉ wahchega. Noano yajeripohna tiga. Ã jiro mʉanopʉ mʉsa sʉchʉ pjíro noano yoarohca mʉsare Cohamacʉ —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ã yoa Jesu õ sehe ni buhe namoha: —Moa wahiquiro dihire to ñano wahaerachʉ yoaro seheta mʉsa sehe yʉ yaina sehe jipihtina painare ñaare ti yoa duaerachʉ yoara. Wiho mejeta moa sehe ti ñaa wahachʉ pari turi noaa yoahto basioerara. Tí moa ne noaerara. Ti ã wahachʉ tí moare cohãno cahmana. Ti ã cohãri baharo tí bui masa tʉ cũna. Ne yaba cjihti jierara tí moa ti cohõa. (Ti yaba cjihti jieraro seheta jiena tjiga mʉsa. Cohamacʉ ya sehere cohãena tjiga) —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ã yoa tiro õ sehe ni buhe namoha: —Buhriaro marine to ñʉchʉ yoaro seheta mʉsa sehe yʉ yaina sehe ahri yahpa macainare Cohamacʉre masichʉ yoara. Tʉ̃cʉ bui jiri macare nʉohto basioerara. ");
INSERT INTO gvc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ã yoa sihãriare masa sihãa, biato docapʉ nʉoerara. Tiare sihãriare mʉanoi duhu payora tí wʉhʉ macaina jipihtina ti ñʉhtiare. ");
INSERT INTO gvc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Õ seheta mʉsa cʉ̃hʉ buhriaro yoaro sehe jiina jina, noaare yoaga. Mʉsa ã yoachʉ ñʉa masa mari Pʉcʉ mʉano macarirore ño payo, “Tuariro, noariro jira”, niahca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ã ni tuhsʉ, tinare õ sehe ni yahu namoha: —Ahrire mʉsa masichʉ cahmaja yʉhʉ. Cohamacʉ to dutiare Moise cjirore to cũrire, to yare yahu mʉhtaina cjiri ti joari cjiri cʉ̃hʉre cohãi tai nierahi. Tí dutiare mʉsare noano yahu potoi tai nii. Tí dutiare ti quihõno jichʉ ñoi tai. Ti niriro seheta yoa sohtori tii tai nii. ");
INSERT INTO gvc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Potocã mʉsare nii nija. Pihtiri dacho pano jisinichʉ Cohamacʉ dutia Moise cjirore to cũrire ne mahanocã baro cohãsi mari. Ahri yahpa, mʉano cʉ̃hʉ ti jisinino puro to dutia cʉ̃hʉ jirucuahca. Ã jirucua ti niriro seheta sohtori tirohca. ");
INSERT INTO gvc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ã jia tí dutiare cãina yʉhdʉrʉcaa, painare tó sehe yʉhdʉrʉca dutia, mʉano macariro pʉhtoro to sʉho jiropʉ cahamaca yoaro sehe jiahca. Cʉ̃no dutiacã to jipachʉta tina yʉhdʉrʉcaa, cahamaca yoaro sehe jiahca tina. Paina tí dutiare noano yoaa, painare tí yoaro sehe yoa dutia, mʉano macariro pʉhtoro to sʉho jiropʉ pʉhtoa yoaro sehe jiahca tina sehe. ");
INSERT INTO gvc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʉsare niita nija yʉhʉ. Judio masare buheina, fariseo curua macaina cʉ̃hʉ Cohamacʉ cahmaare quihõno yoaerara. Tina ti yoariro yʉhdoro Cohamacʉ cahmaare yoaga mʉsa sehe. Mʉsa ã yoaerana, pʉhtoro Cohamacʉ to sʉho jiropʉre ne sʉsi mʉsa —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ã ni tuhsʉ, tinare õ sehe ni yahu namoha: —Panopʉ macaina õ sehe ni ti yahuri cjirire tʉhori jimare mʉsa: “Masare wajãena tjiga. Masare wajãriro ti buhiri dahrehtiro jira”, ti niri cjirire tʉhori jimare mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ahri ti yahuri yʉhdo curero mʉsare ahri sehere yahu namoihtja. To coyeiro mehne susiniriro sehe ti buhiri dahrehtiro jira masʉnore wajãriro yoaro seheta. To coyeirore tuhtiriro, “Ne tʉho masia maerariro jira mʉhʉ”, niriro buhiri dahre dutiina cahai ti naahtiro jira. “Tʉho masierariro jira mʉhʉ”, to coyeirore nirirore pichacapʉ wahahto cua yʉhdʉara tirore. ");
INSERT INTO gvc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Mʉsa coyeiro mʉsare to ñʉ tuhtichʉ õ sehe yoaga. Cohamacʉ wʉhʉpʉ Cohamacʉre mʉsa ño payohto pano, wahiquirore jʉ̃ mʉo, mʉsa wahto pano õ sehe yoaga. ");
INSERT INTO gvc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Mʉsa wahtire duhu cũ, mʉsa coyeiro cahapʉ waha, “Pari turi cahmachena tjijihna. Tó purota duhujihna tíre”, niga tirore. Mʉsa ã niri baharo Cohamacʉre wa, ño payona wahaga to wʉhʉpʉ. ");
INSERT INTO gvc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Pairo mʉhʉre to yahusã duachʉ, pʉhtoro masare beseriro cahapʉ mʉhʉre to naa duachʉ, tiro mehne suaro marieno wahaga. Masare beseriro cahapʉ to na sʉhto pano tiro mehne noano jiga. Mʉ ã yoachʉ ñʉno tiro mʉhʉre yahusãeraboca. Mʉ ã yoaerachʉ tópʉre mʉsa sʉchʉ tiro sehe mʉhʉre masare beserirore yahusãnohca. To ã yahusãchʉ, beseriro sehe peresu yoainapʉre mʉhʉre warohca. Ã jia tina mʉhʉre peresu yoaahca. ");
INSERT INTO gvc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Potocã nii nija mʉhʉre. Tópʉ jisiniihca mʉhʉ. Pʉ ti wapa dutirire mʉhʉ wapa pahñoipʉ wijaaihca mʉhʉ —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Õ sehe ni yahu namoha Jesu: —Panopʉ macainare õ sehe ti ni yahuri cjirire tʉhori jimare mʉsa: “Pairo namono mehne ñano yoaena tjiga”, ti niri cjirire tʉhori jimare mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ahri ti yahuri yʉhdo curero mʉsare ahri sehere yahu namoihtja. Numinore ñahaeraparota, cʉ̃iro ticorore ñano goa pjaro, ñano wacũ tʉhoturo ñano yoa tuhsʉha ticoro mehne. ");
INSERT INTO gvc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ã jicʉ mʉ capariaca poto bʉhʉsehei jiriacã mehne ñano yoacʉ, tiare orewe na mʉ cohãboriro seheta ti ñaa yoaare duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Mʉ capariacare mʉ cohãchʉ tia capariaca dihta butira. Mʉhʉ sehere pichacapʉ mʉ wahachʉ ña yʉhdʉara. Ã jicʉ tí ñaa yoaare duhuga. ");
INSERT INTO gvc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ã jicʉ mʉ wamomaca poto bʉhʉsehei jiri wamomaca mehne ñano yoacʉ, tí wamomacare mʉ dʉte cohãboriro seheta tí ñaa yoaare duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Mʉ wamomacare mʉ cohãchʉ tí wamomaca dihta butira. Mʉhʉ sehere pichacapʉ mʉ wahachʉ ña yʉhdʉara. Ã jicʉ tí ñaa yoaare duhuga —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Õ sehe ni yahu namoha Jesu: —Panopʉ ahri cʉ̃hʉre niha: “To namonore cohã duariro to cohãhtore yahuri pũ mehne ticorore cohã masina”, nimaha panopʉ. ");
INSERT INTO gvc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ahri ti yahuri yʉhdo curero mʉsare ahri sehere yahu namoihtja. To namono pairo mehne ñano yoaeraricoro to jipachʉta to manʉno ticorore cohãboca. To ã cohã daporicoro pairore manʉ tiro ñano yoaro nica ticoro pairo mehne jiro. To manʉno ticorore ã cohãno ticorore pairo mehne ñano yoachʉ yoara. To baharo namo tiriro cʉ̃hʉ ticoro mehne ñano yoaro nina —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Õ sehe ni yahu namoha Jesu: —Panopʉ macaina õ sehe ti ni yahuri cjirire tʉhori jimare mʉsa: “Mʉsa niriro seheta yoaga. ‘Cohamacʉ mehne potocã ã yoaihtja’, mʉsa niriro seheta yoaga”, ti ni yahuri cjirire tʉhori jimare mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ahri ti yahuri yʉhdo curero mʉsare ahri sehere yahu namoihtja. “Mʉano mehne potocã nii nija”, ni mʉano mehne wama payo niena tjiga. Mʉano sehe Cohamacʉ mari pʉhtoro to sʉho jiro jira. Wiho jiro jierara. To ã jichʉ ñʉna mʉano mehne ã niena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ahri yahpa mehne ne wama payo “Potocã nii nija”, niena tjiga. Ahri yahpa Cohamacʉ ya yahpa jira. To ã jichʉ ñʉna ã niena tjiga. “Jerusalẽ mehne potocã nii nija”, ne wama payo niena tjiga. Tuariro mari pʉhtoro ya maca jira Jerusalẽ. Wiho jiri maca jierara. To ã jichʉ ñʉna ã niena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Yʉ dapu mehne potocã nii nija”, ni wama payo niena tjiga. Mʉsa pjoari ti yehsea wahachʉ yoa masierara mʉsa. Ti ñia wahachʉ cʉ̃hʉre yoa masierara mʉsa. Ã yoa masieraina jina “Yʉ dapu mehne potocã nii nija”, ni wama payo niena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Yoanahtja”, nina wama payoro marieno õ sehe dihta tíre nirucuga. “Yoasi”, nina cʉ̃hʉ wama payoro marieno nirucuga. Mʉsa wama payo nina, watĩno ñariro to dutiriro seheta yoana nica mʉsa —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Õ sehe ni yahu namoha Jesu: —Panopʉ õ sehe ti ni yahuri cjirire tʉhori jimare mʉsa. “Mʉhʉre pairo mʉ capariacare to cjã tihãriro seheta mʉhʉ cʉ̃hʉ tirore cjã tihã cahmaga. Mʉ piriacare to cjã nuhariro seheta mʉhʉ cʉ̃hʉ cjã nuha cahmaga”, ti niri cjirire tʉhori jimare mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ti yahuri yʉhdo curero ahri sehere yahu namoihtja mʉsare. Mʉhʉre ñano yoarirore ã ñʉnocahga. Cʉ̃ bʉhʉsehe mʉ wahsupure to cjãchʉ, pa bʉhʉsehe cʉ̃hʉre cjã dutiga tirore. ");
INSERT INTO gvc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pairo buhiri dahre dutirirore mʉhʉre to yahusãchʉ, dutiriro sehe mʉ camisare mʉhʉre yahusãrirore wa dutiboca. To ã wa dutichʉ, tirore waga. Mʉ bui macari suhtiro cʉ̃hʉre wa namoga tirore. ");
INSERT INTO gvc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pairo surara paye barore cʉ̃ kilómetro mʉhʉre to naabasa dutichʉ, pa kilómetrore waha namoga tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mʉhʉre sinirirore waga. Tuhsʉ, pairo mʉhʉre to waso dutichʉ wasoga tirore —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Õ sehe ni yahu namoha Jesu: —Masa õ sehe nina: “Mʉsa mehne macainare cahĩga. Ã yoa mʉsare ñʉ tuhtiinare ñʉ tuhti cahmaga tjoa”, ti niri cjirire tʉho mʉhtari jimare mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ti yahuri cjiri yʉhdo curero ahri sehere yahu namoihtja mʉsare: Mʉsare ñʉ tuhtiinare cahĩga. Ã cahĩna tinare noano yoaga. Mʉsare ñano yoainare ti ya cjihtire Cohamacʉre sini payoga. ");
INSERT INTO gvc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mʉsa ã yoana mari Pʉcʉ mʉano macariro pohna jira mʉsa. Cohamacʉ sehe cʉ̃no potori yoara masare. Ñaina cʉ̃hʉre, noaina cʉ̃hʉre sʉ̃ sichʉ yoara tiro. Tuhsʉ, Cohamacʉ dutiare yoaina cʉ̃hʉre, yoaeraina cʉ̃hʉre coro tachʉ yoara tiro. Masare cʉ̃no potori to yoariro seheta mʉsa cʉ̃hʉ yoaga. ");
INSERT INTO gvc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉsare cahĩina dihtare mʉsa cahĩchʉ tí ne yaba cjihti jierara paina sehere mʉsa cahĩerachʉ. Pʉhtoa ya cjihtire wapa na cohtaina cʉ̃hʉ tó seheta yoara. Ã jina jipihtinare cahĩga. ");
INSERT INTO gvc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉsa coyea dihtare mʉsa noano piti bocachʉ tí cʉ̃hʉ ne yaba cjihti jierara paina sehere mʉsa noano piti bocaerachʉ. Cohamacʉre masieraina cʉ̃hʉ tó seheta yoara. Ã jina jipihtinare noano piti bocaga. ");
INSERT INTO gvc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ñaa marieina jiga mʉsa. Mʉsa Pʉcʉ mʉano macariro to ñaa marieriro to jiriro seheta mʉsa cʉ̃hʉ ñaa marieina jiga —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Pari turi tiro õ sehe ni yahu namoha: —Cohamacʉ ya cjihtire noaare yoana, “Cohamacʉ yare yoa pahñoina jija sã”, ni yahuena tjiga painare. Mʉsa ã ni yahuri buhiri noaare mʉsa yoari cjiri ne yaba cjihti jierara. Ã jiro Cohamacʉ mʉano macariro noaare mʉsa yoari wapa mʉsare ne wasi. ");
INSERT INTO gvc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ã jina pjacʉoinare yoadohona, tíre masare yoa ñoena tjiga. Masa ti ñʉenoi yoadohoga tinare. Cãina noaa ti yoaare yoa ñohna mahapʉ jiinare, judio masa mari buhea wʉhʉsepʉ jiina cʉ̃hʉre. Tina mari baharo bʉhʉsehei ñano yoa cohtaina jira. Ã yoa ñohna tina, “Noaina jira”, masare ni ñʉ dutia. Ti ã ni ñʉchʉ ã yoa ñoina sehe wahche tuhsʉre. “Noaina jira” ni, masa ti ño payochʉ wahche tuhsʉre tina. Ã jiro Cohamacʉ sehe ne wahche namochʉ yoasi tinare. ");
INSERT INTO gvc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ã jina pjacʉoinare yoadohona, masa ti ñʉenoi yoadohoga tinare. Mʉsa mehne macaina mehne jina ti ñʉenoi pjacʉoinare yoadohoga. ");
INSERT INTO gvc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Masa ti ñʉeraropʉ mʉsa yoadohopachʉta Cohamacʉ sehe ñʉna. Ã ñʉno mʉsa ã yoari wapa warohca mʉsare —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pari turi tiro õ sehe ni yahu namoha: —Cohamacʉre sinina, mari baharo bʉhʉsehei ñano yoa cohtaina yoaro sehe yoaena tjiga mʉsa. Judio masa mari buhea wʉhʉsepʉ ducu, mahapʉ cʉ̃hʉre ducu, Cohamacʉre sini ñohna tina masare. Ã sini ñoa potocã masa tinare ti ño payochʉ tí mehne tina wahche tuhsʉre. ");
INSERT INTO gvc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cohamacʉre sinicʉ tacʉ, mʉ ya tahtiapʉ biha sãaga. Biha sãa, mʉsa Pʉcʉ ñʉmahnoerarirore siniga. Mʉsa ã yoachʉ masa marienoi mʉsa sinipachʉta mʉsa Pʉcʉ mʉsare tʉhorohca. Ã tʉhoro mʉsare noano yoarohca tiro. ");
INSERT INTO gvc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ã jina Cohamacʉre sinina, tʉhoturo marieno mʉsa sinirireta pari turi sini majare tjua mʉjaena tjiga. Õ seheta yoara Cohamacʉre masieraina. “Payʉ durucua mehne Cohamacʉre sã sinichʉ tiro sãre tʉhorohca”, ni tʉhotumana tina. ");
INSERT INTO gvc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tina yoaro sehe yoaena tjiga. Mʉsa sinihto pano mʉsa Pʉcʉ mʉsa cahmaare masi tuhsʉra. ");
INSERT INTO gvc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ã jina õ sehe ni sininahca Cohamacʉre: “Sã Pʉcʉ, mʉano macariro mʉhʉ ñaa marieriro ã jirucura. ");
INSERT INTO gvc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mipʉre jipihtina bui pʉhtoro jiga. Mʉanopʉ mʉ dutiro seheta ti yoariro seheta ahri yahpa macaina cʉ̃hʉ yoajaro. ");
INSERT INTO gvc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ã jicʉ dachoripe sã chʉhtire warucuga sãre. ");
INSERT INTO gvc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Paina sãre ti ñano yoarire sã boja. Ã jicʉ mʉhʉ cʉ̃hʉ sã ñano yoarire boga. ");
INSERT INTO gvc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ã jicʉ sã ñaare yoa duana sã goa pjachʉ ñʉcʉ tíre yoa dutii tjiga. Ã jicʉ sãre ñaare yoaerachʉ yoaga. Mʉhʉ sã pʉhtoro tuariro ã jirucuihca. Jipihtina mʉhʉre ã ño payorucuahca”, ni siniga Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Paina mʉsare ti ñaa yoarire mʉsa bochʉ ñʉno, mʉsa Pʉcʉ mʉano macariro cʉ̃hʉ mʉsa ñaa yoarire borohca. ");
INSERT INTO gvc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wiho mejeta paina mʉsare ti ñaa yoarire mʉsa boaerachʉ mʉsa Pʉcʉ cʉ̃hʉ mʉsa ñaa yoarire ne bosi —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ã jiro tiro tinare õ sehe ni yahu namoha: —Cohamacʉre ño payona tana chʉ duhuna bʉjʉa witiina yoaro sehe yoa ñoena tjiga. Tó sehe yoara mari baharo bʉhʉsehei ñano yoa cohtaina. Tina ti wʉhdʉa poca cahyaina yoaro sehe jira. Ti ã jiina jichʉ ti chʉ duhuchʉ ñʉ masina masa. Potocãta mʉsare nii nija. Tinare masa ño payochʉ cahmana tina. Ã jia tinare ti ño payochʉ ñʉa tina wahche tuhsʉre. (Cohamacʉ sehe tirore ti ño payori wapa tinare wahchechʉ yoasi. Ã jina tina yoaro sehe yoa ñoena tjiga mʉsa.) ");
INSERT INTO gvc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mʉsa chʉ duhuna, mʉsa pjoarire co mehne wa payo wʉha majare payoga. Ã jina mʉsa wʉhdʉa pocare cosaga. ");
INSERT INTO gvc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mʉsa ã yoachʉ mʉsa chʉ duhuchʉ ñʉ masisi masa. Mari ñʉ mahnoerariro Cohamacʉ dihta mʉsa chʉ duhuare ñʉ masinohca. Mʉsa sahsero mʉsa jichʉ tiro mʉsa mehne ã jirucura. Ã ñʉno tiro mʉsare noano yoarohca tirore mʉsa ño payori wapa —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ã jiro tiro õ sehe ni yahu namoha: —Ahri yahpa macaare na cahmachuena tjiga. Õ macaa baa wahaboca. Ti baaerachʉ yacariro naboca tíre. To yacaerachʉ machʉ tʉaboca. Ã jia ahri yahpa macaa nu butihto cuara. Ã jina ahri yahpa macaare tuaro cahmaena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mʉano macaa sehere cahmaga mʉsa. Mʉano macaare machʉ tʉa masierara. Tópʉ mʉsa cjʉaa ne baaerara. Tópʉre yacariro na masierara. Ã jina mʉano macaare cahmaga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tópʉ mʉsa cjʉaa ti jichʉ, mʉano macaare Cohamacʉ yare tuaro wacũna mʉsa —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ã jiro õ sehe ni yahu namoha tinare: —Sihãria to noano buhriachʉ mari ñʉ masino seheta Cohamacʉ yare tʉhotuna to yare noano yoa masinahca mʉsa. Mʉsa tʉhoturo seheta yoara mʉsa. Cohamacʉ yare tʉhotuna noaare yoara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","To yare tʉhotuerana ñaare yoara mʉsa. Mʉsa ñaa dihtare mʉsa tʉhoturucuchʉ tí ñaa sehe ñabiaa jira —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ã jiro tiro õ sehe ni yahu namoha tinare: —Cʉ̃iro Cohamacʉ sehere wacũno, tuabiaro niñeru sehere wacũerara. Niñeru sehere tuabiaro wacũno Cohamacʉ sehere wacũerara. Niñeru dihtare cahmariro jiro Cohamacʉre wahchechʉ yoaerara. Cohamacʉ cʉ̃hʉre, niñeru cʉ̃hʉre pʉarore cahma yʉhdʉrʉcahto basioerara mʉsare —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ã jiro tinare õ sehe ni yahu namoha: —Ã jicʉ mʉsare nii nija: Mʉsa chʉare, sihniare, suhti cʉ̃hʉre pjíro cahya tʉhotuena tjiga. Mʉsare bajuamehneno chʉare chʉhtina cjihti dihtare suhti sãahtina cjihti dihtare Cohamacʉ yoaeraha mʉsare. ");
INSERT INTO gvc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Minichahca perire Cohamacʉ to ñʉ wihboare masiga mʉsa. Tina weseri maeraina jira. Ã yoa chʉare ti wihboa wʉhʉse tinare mariahna. Mʉsa Pʉcʉ mʉano macariro sehe tinare ti chʉhtire wara. Minichahca yʉhdoro mʉsa sehere cahĩna Cohamacʉ. Ã jiro mʉsa cʉ̃hʉre ñʉ wihborohca tiro. ");
INSERT INTO gvc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pjíro mʉsa tʉhotua mehne cʉ̃ hora mʉsare cati namochʉ yoa masierara mʉsa. Ã jiro mʉsa pjíro tʉhotua yaba cjihti jierara. ");
INSERT INTO gvc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ã jina mʉsa suhti sãahtire pjíro cahya tʉhotuena tjiga. Macaroca macaa cohori ti cohoare tʉhotuga. Tí cohori ti basi suhtire yoaerara. Wiho mejeta tí cohori noaa suhti yoaro sehe noaa cohori bajura. ");
INSERT INTO gvc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salomo cjiro noaa suhtire sãariro to jipachʉta tí cohori sehe tiro yʉhdoro noabia cohori waro jira. ");
INSERT INTO gvc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cohorire noaa cohori yoara Cohamacʉ sehe. Tí cohori sehe mahaa dachoricã jirucuma ñai boraa wahara. Mahanocã ji, pa dachoi pichacapʉ jʉ̃a wahara. Ti ã jipachʉta cohorire noaa cohori jichʉ yoara Cohamacʉ. Ã jiro Cohamacʉ cohorire to noaa cohori to yoariro yʉhdoro mʉsa cʉ̃hʉre noano yoarohca. Suhtire warohca. Cohamacʉre mahanocã wacũ tuara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ã jina mʉsa chʉhtire, mʉsa sihnihtire, mʉsa suhti sãahtire pjíro cahya tʉhotuena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Cohamacʉre cahmaeraina sehe tíre ã macarucua nina. Mʉsa Pʉcʉ mʉano macariro jipihtia mʉsa cahmaare masina. To ã masichʉ pjíro cahya tʉhotuena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Cohamacʉ mʉsa pʉhtoro to jihto cjihtore cahma mʉhtaga mʉsa. Jipihtia paye baro yʉhdoro tirore cahmaga mʉsa. Noaare to yoa dutia cʉ̃hʉre cahmaga. Mʉsa ã yoari baharo Cohamacʉ sehe mʉsa cahmaa dʉhsachʉ warohca. ");
INSERT INTO gvc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ã jina ñamichacapʉre mʉsa dohse wahahtore pjíro cahya tʉhotuena tjiga. Mʉsa ã pjíro cahya tʉhotuna payʉbiaa jiahca mʉsa tʉhotuhto sehe. Micha macaa dihtare mʉsa tʉhotuchʉ tó purota mʉ sʉrohca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ã jiro tiro tinare õ sehe ni yahu namoha: —Painare “Ñaina jira”, niena tjiga mʉsa. Mʉsa ã nierachʉ Cohamacʉ mʉsare “Ñaina jira”, nisi. ");
INSERT INTO gvc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Painare “Noano yoaerara”, mʉsa ni ñʉriro seheta Cohamacʉ sehe mʉsa cʉ̃hʉre ãta ni ñʉnohca. ");
INSERT INTO gvc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mari piti dahre buhechʉ õ sehe yoaina jira mʉsa. Mʉsa coyeiro to capariacapʉ mahari pohcarocã to sãachʉ tí pohcarocãre noano ñʉna mʉsa. Mʉsa ya capariaca sehere pjiri pjĩ to jipachʉta tí pjĩne ne ñʉerara mʉsa. Mahari pohcarocãre mʉsa ñʉno seheta mʉsa coyeiro to ñano yoaa sehere noano ñʉna mʉsa. Mʉsa basi mʉsa ñaare tuaro yoapanahta tíre masierara mʉsa, pjiri pjĩne mʉsa ñʉeraro seheta. ¿Dohse jiro baro ã jijari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Õ sehe niina jira mʉsa: “Coyeiro, ñaare yoai nica mʉhʉ. Ã jicʉ tíre duhuga”, niina jira mʉsa. Ã niina jipanahta pjíro ñaare yoara mʉsa sehe. ¿Dohseana mʉsa ñaare yoapanahta tíre masierajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Masa ti baharo bʉhʉsehei ñano yoa cohtaina jira mʉsa ã yoaina. Pjiri pjĩne mʉsa capariacai jiri pjĩne mʉsa na mʉhtaboriro seheta mʉsa ñano yoaa sehere duhu mʉhtaga. Mʉsa ã yoari baharo mʉsa coyeiro to ñano yoaare duhuchʉ yoa masiboca, mahari pohcarocãre mʉsa naboro seheta. ");
INSERT INTO gvc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Dieya yoaro sehe jiina, yesea yoaro sehe jiina cʉ̃hʉ ñabiainare Cohamacʉ ya noa yʉhdʉare ti ño payoeraare yahuena tjiga tinare. “Tinapʉ bʉjʉpe, ñano ni, mʉsare ñabiaro yoari”, nina yahuena tjiga tinare —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ã jiro tiro tinare õ sehe ni yahu namoha: —Cohamacʉre siniga mʉsa. Mʉsa sinina mʉsa sinirire ñahanahca. Mʉsa sinirire bocanahca. Tirore ã sinirucuga mʉsa. Mʉsa ã yoachʉ tiro mʉsare warohca. ");
INSERT INTO gvc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jipihtina Cohamacʉre siniina naahca. Ã yoa ti sinirire bocaahca. Jipihtina Cohamacʉre ã sinirucuinare tiro tinare warohca. ");
INSERT INTO gvc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Mʉsa pohna pão curire mʉsare ti sinichʉ tãca sehere wabocari mʉsa tinare? Ne wasi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Mʉsa pohna wahire mʉsare ti sinichʉ agã sehere wabocari mʉsa tinare? Ne wasi. ");
INSERT INTO gvc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉsa ñaina jipanahta mʉsa pohnare noaare waa tíre mʉsa. Ã jiro Cohamacʉ sehe mʉsa yʉhdoro noaare wara mʉsare to pohnare tirore siniinare. Mʉsa pohnare mʉsa wariro yʉhdoro Cohamacʉ sehe to pohnare wara. ");
INSERT INTO gvc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Paina mʉsare ti noano yoachʉ cahmana mʉsa. Tinare mʉsa noano yoachʉ cahmano seheta mʉsa cʉ̃hʉ noano yoaga tinare. Ti noano yoaerapachʉta mʉsa sehe tinare noano yoaga. Ãta yoa dutira Cohamacʉ dutia Moise cjirore to cũripʉ Cohamacʉ yare yahu mʉhtaina cjiri ti joari cjiri cʉ̃hʉ —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ã jiro tiro õ sehe ni yahu namoha tinare: —Mʉanopʉ Cohamacʉ cahapʉ waha duana to yare yoaro cahmana mʉsare. Ã jina to yare ã yoamacanocaeraro cahmana. Mahari sopacacãpʉ mʉsa sãa duachʉ mijo curera. Tó seheta mijo nina Cohamacʉ cahapʉ mʉsa waha duachʉ. Pichacapʉ masa ti wahachʉ mijoerara. Pjiri sopacapʉ mari sãachʉ mijoerara. Tí sopacapʉ masa ti sãaboro seheta pichacapʉ masa ti wahachʉ mijoerara. Ã jia payʉ masa tópʉ wahaa nina. ");
INSERT INTO gvc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Cohamacʉ cahapʉ mʉsa waha duachʉ mijo nina. Mahainacã masa tópʉ wahaahca. Tópʉ wahaina jipihtia dachoripe Cohamacʉ mehne jirucuahca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ã jiro tiro õ sehe ni yahu namoha tinare: —Noano yoaga. “Cohamacʉ yare yahu mʉhtaina jija”, ni mahñoinare tʉhoena tjiga mʉsa. Tina oveja yoaro sehe suaeraina sehe bajumana. Ti tʉhotuapʉ ñaina jira tina. ");
INSERT INTO gvc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ti ñano yoachʉ ñʉna, ñaina ti jichʉ masinahca mʉsa. Ti noano yoachʉ ñʉna noaina ti jichʉ masinahca mʉsa. Agã potacʉ se tõhorine dicha tierara. Pota tidʉ cʉ̃hʉ higuera pocare dicha tierara. ");
INSERT INTO gvc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Noadʉ yucʉcʉ noaare dicha tira. Ñadʉ sehe ñaare dicha tira. ");
INSERT INTO gvc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Noadʉ yucʉcʉ ñaare ne dicha tierara. Ã yoa ñadʉ noaare dicha tierara. ");
INSERT INTO gvc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Noaare dicha tiera yucʉre dʉte cohãnoca, pichacapʉ jʉ̃nohca. Ãta yoarohca Cohamacʉ to cahmaare yoaerainare. ");
INSERT INTO gvc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ã jina “Cohamacʉ yare yahu mʉhtaina jija”, ni mahñoinare õ sehe masinahca. Ti yoarire ñʉna, mahñoina ti jiare masinahca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ã jiro tiro õ sehe ni yahu namoha tinare: —Payʉ yʉhʉre “Pʉhtoro”, niina jipahta mʉano macariro pʉhtoro Cohamacʉ to sʉho jiropʉre wahasi tina. Yʉ Pʉcʉ mʉano macariro to cahmaare yoaina dihta pʉhtoro to sʉho jiropʉre wahaahca. ");
INSERT INTO gvc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pihtiri dacho jichʉ payʉ masa õ sehe niahca yʉhʉre: “Pʉhtoro, mʉ yare sã buhehi. Mʉ wama mehne watĩare cohã wiohi. Ã yoa mʉ tuaa mehne payʉ yoa ñohi sã”, yʉhʉre niina jiahca. ");
INSERT INTO gvc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Õ sehe ni yʉhtiihca tinare: “Mʉsare ne masieraja. Ñaa buhiri tiina jira mʉsa. Ã jina yʉ cahai taena tjiga”, ni yʉhtiihca tinare. ");
INSERT INTO gvc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ã yoa jipihtina ahri yʉ buherire tʉhorina yʉ dutiare yoaina, noano tʉho masiriro wʉhʉ dahreriro yoaro sehe jira tina. Tiro sehe cʉãa copari tãa wapapʉ saha, wʉhʉre noano dapo dʉcaha. ");
INSERT INTO gvc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tí wʉhʉre to tuhsʉri baharo coro tuaro ta, dia mini yʉhdʉa waha, tuaro wihnono wãha. Ã to tuaro wãpachʉta tí wʉhʉ cʉãno tãa wapa bui to dapori wʉhʉ jiro ne waha sʉ cahaerara. ");
INSERT INTO gvc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ã jia jipihtina yʉ buherire tʉhopahta yʉ dutiare yoaeraina, tʉho masierariro wʉhʉ dahreriro yoaro sehe jira. Tiro sehe to wʉhʉre padʉro buicã dapo, noano yoa dʉcaeraha. ");
INSERT INTO gvc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tí wʉhʉre to tuhsʉri baharo, coro tuaro ta, dia mini yʉhdʉa waha, wihnono tuaro wãha. Ã tuaro wãno tí wʉhʉ sehere wãroca cũnocaha. Ã jiro tí wʉhʉ tuaro bora sʉ cahaa wahaha —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","To ã ni buhechʉ tʉhoa, cʉaa wahaha masa. ");
INSERT INTO gvc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“Tiro potocãta pʉhtoro jira. Ã jiro noano masi pahñoriro marine buhera tiro. Mari judio masare buheina yoaro sehe buherara”, ni tʉhotuha tina. ");
INSERT INTO gvc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu tʉ̃cʉpʉ buhe dujiriro cjiro dujia wahaha. To ã dujiachʉ ñʉa masa payʉ tiro baharo wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","To ã wahachʉ cʉ̃iro cami bʉcʉ baariro tirore piti boca, na tuhcua caha sʉ, tirore siniha: —Pʉhtoro, mʉhʉ yʉhʉre noariro yoa duacʉ yoaga —niha. ");
INSERT INTO gvc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","To ã nichʉ tʉhoro to wamomaca mehne Jesu tirore ña payoha. —Jai, mʉhʉre noariro wahachʉ yoaja —niha Jesu tirore. To ã nichʉta tí to cami baari cjiri yati mʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ã ni tuhsʉ Jesu tirore õ sehe niha tjoa: —Yʉ mʉhʉre õ sehe yoarire ne painare yahui tjia. Mʉ pjacʉre noari pjacʉ to waharire sacerdotere ñoi wahaga. Moisere Cohamacʉ to cũriro seheta sacerdotere minichahcare waga mʉ yʉhdʉrire ti noano masihto sehe —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tó baharo Jesu Capernau wama tiri macapʉ to sʉchʉ cien surara pʉhtoro to cahai sʉ, tirore tuaro õ sehe ni siniha: ");
INSERT INTO gvc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Pʉhtoro, yʉhʉre dahra cohtariro pjacʉ bʉhariro jiro waha masieratjiãhno tirore tuaro purĩchʉ yʉ wʉhʉpʉ coãhre tiro —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","To ã nichʉ, Jesu “Jai”, ni yʉhtiha: —Tirore to dohatiare yʉhdʉchʉ yoai wahaihtja —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","To ã nichʉ õ sehe niha surara pʉhtoro: —Pʉhtoro, noanohca. Tai tjia. Yʉ yʉhdoro noa yʉhdʉariro jira mʉhʉ. Ya wʉhʉi mʉhʉre sãa ta dutiboriro jieraja yʉhʉ. Mʉ masia mehne noariro wahachʉ yoaga tirore. Mʉ ã yoachʉ yʉ yʉhʉre dahra cohtariro noariro waharohca. Yʉhʉre yʉ bui jiina paina pʉhtoa dutira. Yʉhʉ cʉ̃hʉ surarare dutija. Cʉ̃irore “Wahaga”, yʉ nichʉ tiro wahara. Pairore “Taga”, yʉ nichʉ tiro tara. Yʉhʉre dahra cohtarirore “Ahrire yoaga”, yʉ nichʉ tíre yoara. (Mʉhʉ cʉ̃hʉ dutirirota jira. Ã jiro mʉ dutiro seheta tiro dohatiriro yʉhdʉrohca) —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","To ã nichʉ tʉho cʉaa waharo payʉ masa tiro mehne jiinare õ sehe niha Jesu: —Potocãta mʉsare niita nija. Ahriro surara pʉhtoro Israe masʉno jierariro Cohamacʉre tuaro wacũ tuara. Tirore dahra cohtarirore yʉ noariro wahachʉ yoahtire masi tuhsʉha. Ne Israe masare ahriro yoaro sehe jiinare ñʉerasinija. ");
INSERT INTO gvc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mʉsare niita nija. Payʉ ahriro yoaro sehe Cohamacʉre wacũ tuaina jipihtiro macaina mʉano macariro pʉhtoro to sʉho jiropʉ sʉa, tópʉ jiina mehne chʉahca. Abrahã, Isaa, Jacobo mehne chʉahca tina. ");
INSERT INTO gvc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Masa paina sehe pʉhtoro Cohamacʉ to sʉho jiropʉ wahaborina ti jipachʉta ñanopʉ nahitianopʉ cohãnocanohca tinare. Tópʉ to cohãrina tuaro tii, cahyaa mehne bahca dihoahca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tíre ã ni tuhsʉ, surara pʉhtorore õ sehe niha: —Tjuahga mʉ ya wʉhʉpʉ. Mʉhʉre dahra cohtariro yʉhdʉrohca. “Potocãta yʉhdʉrohca”, ni mʉ tʉhoturiro seheta yʉhdʉrohca —niha Jesu. To ã nino watoihta tirore dahra cohtariro sehe noa tuhsʉha. ");
INSERT INTO gvc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Baharo Jesu Pedro ya wʉhʉpʉ sʉ, Pedro marechono dohatichʉ ñʉha tiro. Juaro tichʉ cama bui coãha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","To ã jichʉ ñʉtjiãhno to wamomacare ña payoha. To ã ña payochʉta juaro surua wahaha. Suruchʉ tʉhoturo ticoro sehe wahcãrʉca, tinare chʉare payoha. ");
INSERT INTO gvc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ã yoa ñamichahapʉ payʉ watĩa ti sãanohrinare masa na wihiha Jesu cahapʉ. Ti ã na wihichʉ ñʉno cʉ̃ tahata to waha dutichʉ watĩa wahaa wahaha. Tuhsʉ, jipihtina dohatiina ti na sʉrinare ti dohatiare cohã pahñoha Jesu. Ã jia noaa wahaha tina. ");
INSERT INTO gvc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ãta yoaha tiro panopʉ macariro Cohamacʉ yare yahu mʉhtariro Isaia cjiro to niriro seheta. Õ sehe ni joaa tiha: “Mari dohatiare yʉhdonocanohca tiro. Mari duti tiare cohãnocanohca”, ni joaa tiha Isaia cjiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesu payʉ masa to cahai ti jichʉ ñʉno: —Sie coapʉ basa pahãjihna —niha. ");
INSERT INTO gvc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ti pahãhto pano judio masare buheriro Jesu cahapʉ sʉ, õ sehe niha: —Buheriro, mʉhʉ mehne waha duaja nohoi mʉ waharoi —niha. ");
INSERT INTO gvc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu õ sehe ni yʉhtiha: —Cãina macaroca macaina wahiquina ti copari cjʉara. Minichahca cʉ̃hʉ ti suhti cjʉara. Yʉhʉ masʉno Cohamacʉ warocariro sehe yʉ carĩri wʉhʉ maeraja. (Ã jina yʉhʉ mehne tana ñano yʉhdʉnahca mʉsa) —ni yʉhtiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ã yoa pairo Jesu buheriro õ sehe niha: —Pʉhtoro, yʉ pʉcʉ to yariachʉ yasinii wahaihtja. Ã ya tuhsʉi pinihta mʉhʉ mehne wahaihtja —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesu õ sehe ni yʉhtiha: —Yʉhʉre cahmaeraina yariaina yoaro seheta jira. Tina sehe yariainare yajaro. Ã jicʉ mʉhʉ sehe yʉhʉ mehne macariro cjihto taga —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ã ni tuhsʉ Jesu to jiriapʉ dohoriapʉ samuha. Ã jia to buheina cʉ̃hʉ tiro mehne waha, samuha. ");
INSERT INTO gvc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tí bʉcʉpariropʉ ti pahãchʉ waro wihnono tuaro taha. Ã jia pahcõri dohoriare mionocamaha. Ã wihnono wãpachʉta Jesu sehe carĩno niha. ");
INSERT INTO gvc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","To ã wahachʉ ñʉa tina tirore wahcõha. Wahcõ õ sehe niha: —Pʉhtoro, yʉhdoga. Mari mini yariana tana nija —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —¿Dohse jiro baro cuimacanocana nijari mʉsa? Yʉhʉre wacũ tuaeraina jira mʉsa —niha Jesu tinare. Ã ninota wahcãrʉcʉ sʉ, wihnonore pahcõri cʉ̃hʉre “Yʉsʉa wahaga”, niha. To ã nichʉ wihnono yʉhdʉa wahaha. Ã jia pahcõri cʉ̃hʉ yʉsʉ boraa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","To ã yoachʉ ñʉ cʉaa, õ sehe niha tina: —¿Cue, dohse jiriro baro masʉno jijari ahriro? Ahri wihnono, pahcõri cʉ̃hʉ to dutichʉ yʉhdʉrʉcaerara tirore —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tinare ã wahari baharo pahã sʉ, Gadara macaina ya yahpapʉ sʉha. Tópʉ ti sʉchʉ pʉaro mʉa masa copari watopʉ jiina Jesure piti bocaha. Tina watĩa ti sãanohorina cuaina jiha. Ã jiro tópʉ masa ti wahamahnoeno jiha. ");
INSERT INTO gvc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tirore piti boca, õ sehe ni sañurucuha: —¿Mʉhʉ Cohamacʉ macʉno dohse yoai tai tajari mʉhʉ sã cahapʉre? ¿Sãre Cohamacʉ to buhiri dahrehti pja to jierapachʉta sãre buhiri dahrei tai nijari mʉhʉ? —ni sañurucuha tina. ");
INSERT INTO gvc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tó cahai payʉ yesea maca chʉa niha. ");
INSERT INTO gvc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tinare ñʉa, watĩa õ sehe niha Jesure: —Sãre cohã wiocʉ sina yesea cahapʉ yeseare sãa dutiga sãre —ni siniha watĩa Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Jai, wahaga —niha Jesu. To ã nichʉ watĩa pʉaro masa mehne jirina cjiri waha, yesea ti pjacʉripʉ sãaha. Ã yoa tinare ti sãari baharo, yesea pari cʉnʉpʉ mʉroca buha, bʉcʉpariropʉ bora ñoja, mini yaria pihtia wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ti ã wahachʉ ñʉa yeseare ñʉ wihboina sehe cui, mʉrocaa wahaha. Macapʉ sʉ, yesea ti minirire yahu site pahñoha. Watĩa ti sãanohrinare Jesu to cohã wiori cʉ̃hʉre yahu pahñoha tina. ");
INSERT INTO gvc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ã ti yahu siteri baharo tí maca macaina jipihtina Jesure ñʉa taha. Ã jia tirore ñʉa, tuaro mehne waha dutiha tirore. ");
INSERT INTO gvc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ã ti waha dutiri baharo Jesu dohoriapʉ samu, bʉcʉpariropʉ pahã, to bʉcʉari macapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tópʉ paina pjacʉ bʉharirore to coãri cahsaro mehne yo wʉa wihiha Jesu cahai: “Jesu ahrirore to dohatiare yʉhdʉchʉ yoarohca”, ni tʉhotuha tina. Ti ã ni tʉhotuchʉ masino dohatirirore õ sehe ni yahuha Jesu: —Macʉ, wahchega mʉhʉ. Ñano mʉ buhiri tiare cohã tuhsʉja yʉhʉ —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","To ã nichʉ tʉhoa cãina mari judio masare buheina õ sehe ni tʉhotumaha: “Ahriro wiho jiriro ã nino, ‘Cohamacʉ jija’, nino nina. Ã nino Cohamacʉre ñano nino nina”, ni tʉhotumaha tina. ");
INSERT INTO gvc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ti ã ni tʉhotuchʉ masino, õ sehe niha Jesu: —¿Dohseana ã ñano tʉhotujari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Ñano mʉ buhiri tiare cohã tuhsʉja”, yʉ nichʉ, “Mahñoriro jira”, nina mʉsa noano masierapanahta. “Wahcãrʉca, wahaga”, yʉ nichʉ yʉ niri potocã jia jichʉ dóihta mʉsa masinahca. ");
INSERT INTO gvc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yʉhʉ masʉno Cohamacʉ warocariro ahri yahpai masa ti ñano buhiri tiare cohã masija yʉhʉ. Masa ti ñano buhiri tiare cohãhtiro cjihtore cũre Cohamacʉ yʉhʉre. Yʉ ã cohãrire mʉsa masihto sehe õ seheta yoa ñoihtja mʉsa ñʉhti cjihtire —niha Jesu. Tinare ã ninota, pjacʉ bʉharirore õ sehe niha: —Wahcãrʉcaga. Mʉ coãri cahsarore na wahcãga mʉ ya wʉhʉpʉ —niha tirore. ");
INSERT INTO gvc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","To ã nichʉ tʉhoro pjacʉ bʉhariro wahcãrʉcʉ sʉ, to ya wʉhʉpʉ tjuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Masa to ã wahachʉ ñʉa cuiha. Ã yoa Jesure Cohamacʉ to tuare to wachʉ ñʉa masa Cohamacʉre ño payo, noano durucuha. ");
INSERT INTO gvc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ti ã yoari baharo Jesu tópʉ jiriro ta, yʉhʉre Mateore boca wihire. Pʉhtoa ya cjihtire masare wapa na cohtariro jimai. Ã jicʉ tí pjare yʉ dahrari tahtiapʉ dujii. Tói yʉ dujichʉ ñʉno õ sehe nire yʉhʉre: —Yʉhʉ mehne macariro cjihto taga mʉhʉ —nire Jesu yʉhʉre. To ã nichʉ tʉhocʉ wahcãrʉca tiro mehne wahai. ");
INSERT INTO gvc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Baharo ya wʉhʉpʉ Jesu cʉ̃hʉ chʉa tare. Payʉ pʉhtoa ya cjihtire wapa na cohtaina, “Ñano yoaina”, ti niina cʉ̃hʉ sã mehneta chʉre. ");
INSERT INTO gvc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tina mehne sã chʉchʉ ñʉa, fariseo curua macaina sãre Jesu buheinare õ sehe nire: —¿Dohsearo mʉsare buheriro wapa na cohtaina mehne, ñano yoaina mehne chʉjari? —nire tina sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Ti ã nichʉ tʉhoro Jesu sehe piti dahre buhea mehne yʉhtire: —Dohatieraina duhturure macaerara. Dohatiina dihta duhturure macana. Ñaare yoaina dohatiina yoaro sehe jira. Ã jicʉ ñaare yoaina dihtare ti ñaare ti tʉhotumari cjirire duhu, noaa sehere ti tʉhotu cohtotachʉ yoai tai nii yʉhʉ. Ti basi “Noaina jija sã”, ni tʉhotuina barore yahui tai nierahi. Cohamacʉ to nirire ti joarire masiga mʉsa. “Wahiquinare mʉsa wajã, jʉ̃ mʉoa mehne yʉhʉre mʉsa ño payochʉ cahmaeraja. Painare mʉsa pja ñʉchʉ sehere cahmaja”, ni joaha. Ahri to joari to dohse niare masiga mʉsa. Tíre noano buhe namona wahaga —nire Jesu fariseo curua macainare. ");
INSERT INTO gvc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baharo João masare bautisariro to buheina Jesu cahapʉ sʉ, õ sehe ni siniture: —Sã João buheina sehe Cohamacʉre ño payona tana, chʉ duhuja. Fariseo curua macaina cʉ̃hʉ ãta chʉ duhura. ¿Dohse yoaa mʉ buheina sehe chʉ duhuerajari? —nire tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu to tʉhotua mehne piti dahre buhero taro tinare õ sehe ni yʉhtire: —Õ sehe jira tí: Wamomaca dʉhteropʉ ti pjirocaina wamomaca dʉhteriro mehne jia, chʉ duhu masierara. Tó seheta yʉ buheina cʉ̃hʉ yʉhʉ mehne jia, chʉ duhu masierara. Yʉhʉ wamomaca dʉhteriro yoaro sehe jija. Wamomaca dʉhteriro bose nʉmʉ to yoachʉ tiro mehne macaina cahyaa mehne jierara. Ã jia chʉ duhuina jierara. Yʉ Pʉcʉ Cohamacʉ yʉhʉre to naari baharo pinihtare yʉ buheina mehne jisi yʉhʉ. Ã jia tí pjapʉta yʉ buheina cʉ̃hʉ chʉ duhuahca —ni yʉhtire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Panopʉ macaa buhea wahma buhea mehne ti buhe more duachʉ ñʉno õ sehe ni namore Jesu tinare piti dahre buhero: —Ne wahma cahsaro suhtiro cahsaro mehne mʉnano suhtirore sere õno cahmaerara. Ã yoachʉ wahma cahsaro mari cosari baharo mʉnano suhtirore waja cahmachu, pjibiaro tʉhnʉchʉ yoara. (Ahri yoaro sehe ni, mʉna buhea wahma buhea mehne piti dahre buheraro cahmana.) ");
INSERT INTO gvc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ã jina ne se co bisia core wahiquiro cahsaro wajuru mehne mʉna wajuru mehne posaeraro cahmana. Ã yoachʉ se co bisia pahmoapʉ mʉna wajurure tʉhrẽnocahna. To tʉhnʉchʉ se co cʉ̃hʉ, wajuru cʉ̃hʉ cohõa wahara. Ã jina se co wahma core wahma wajurupʉ posaro cahmana. Ã yoachʉ se co cohõeraa, wajuru cʉ̃hʉ cohõerara. (Tó seheta wahma buhea mʉna buhea mehne buhe moreraro cahmana) —ni yahure Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","To ã ni yahuro watoi judio masa mari buheri wʉhʉ pʉhtoro Jesu cahapʉ wihire. Wihi, na tuhcua caha sʉ, õ sehe nire: —Yʉ maco yoatapʉ yariaa wahahre. Ticorore mʉ wamomacare duhu payoi taga. Mʉ ã yoachʉ masanohca —nire tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","To ã nichʉ tʉhoro Jesu wahcãrʉca tiro mehne wahare. Sã to buheina cʉ̃hʉ wahai. ");
INSERT INTO gvc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sã mahai waharucuchʉ tói numino ã cahã ñʉrucuricoro Jesu baharo bʉhʉsehei ta, to suhtiro sohtoare ñaha ñʉha. Doce cʉhmari waro dachoripe cahã ñʉrucuricoro jiha. ");
INSERT INTO gvc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Õ sehe ni tʉhotuha ticoro ã yoaro: “To suhtirore ñaha ñʉco, noaricoro wahacohca”, ni tʉhotuha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","To ã yoachʉ masino Jesu majarerʉcʉ sʉ, ticorore õ sehe nire: —Maco, wahchega mʉhʉ. Mʉ yʉhʉre wacũ tuaa mehne noaricoro tjuara mʉhʉ mipʉre —nire tiro. To ã nichʉta noaa wahare ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ã yoa tuhsʉ Jesu pʉhtoro ya wʉhʉpʉ sʉre. Sãa sʉro, ñahacaha tiinare teneniaca yoaro sehe jiriare putiinare ñʉre. Payʉ masa ti ñano bisichʉ cʉ̃hʉre tʉhore tiro. ");
INSERT INTO gvc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ti ã nichʉ tʉhoro masare õ sehe nire: —Wijaahga mʉsa. Yariaerari jira ticoro. Carĩno nina —nire tinare. To ã nichʉ tʉhoa, “Ã nimacanocano nina ahriro”, nia masa bʉjʉre tirore. ");
INSERT INTO gvc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ã jiro wʉhʉ puhichapʉre masare to wio pahñori baharo yariaricoro cahapʉ sʉ, to wamomacare ñahaha. To ã ñahachʉ masa caha sʉ, wahcãrʉcʉ sʉha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","To ã yoarire tʉhoa, tó macaina masa jipihtina yahu sitere. ");
INSERT INTO gvc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ã yoaro Jesu tói jiriro to wahachʉ, pʉaro capari bajueraina tirore pisu nʉnʉ tire: —Davi panamino masare yʉhdohtiro, sãre pja ñʉga mʉhʉ —ni sañurucure tina. ");
INSERT INTO gvc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ti ã nichʉta Jesu pa wʉhʉpʉ sãare. To ã sãachʉ masia capari bajueraina to cahapʉ sãa wahare. Ti ã sãa sʉchʉ ñʉno tiro sehe siniture tinare: —“Marine ñʉchʉ yoarohca tiro”, ¿ni tʉhotujari mʉsa yʉhʉre? —nire tiro. —Pʉhtoro, ãta ni tʉhotuja sã —ni yʉhtire tina. ");
INSERT INTO gvc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ti ã nichʉta ti caparire ña payore. Ã ña payorota õ sehe nire: —Yʉhʉre “Ã yoarohca”, mʉsa ni tʉhoturiro seheta ã yoaja —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","To ã nichʉta ti capari sehe noaa wahare. Ã yoa Jesu õ sehe nire tinare: —Ahri yʉ õ sehe yoarire painare ne yahuena tjiga —nire. ");
INSERT INTO gvc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","To ã nipachʉta waha, tói jiinare yahu sitere tina to ã yoarire. ");
INSERT INTO gvc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tí wʉhʉre ti wijaachʉ waro cʉ̃iro durucuerarirore na tare masa. Watĩno tiro mehne jiriro tirore durucuerachʉ yoaha. ");
INSERT INTO gvc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ti na sʉchʉ ñʉno watĩnore Jesu cohã wiore. To ã cohã wiochʉ watĩno to sãanohriro cjiro sehe durucua wahare. To ã yoachʉ ñʉa jipihtina cʉa pihtiare. —Ne, ahri yahpa Israe yahpapʉre õ sehe yoaare ñʉera tihi mari —ni durucure tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo curua macaina sehe soro ni durucure: —Watĩa pʉhtoro to tuaa mehne watĩare cohãna ahriro —ni durucure tina. ");
INSERT INTO gvc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ã yoa jipihtia macari tói jia macaricãre, bʉjʉa macari cʉ̃hʉre buhe tinino wahare Jesu. Noaa buheare judio masa mari buhea wʉhʉsepʉ buhero wahare tiro. Ã jiro pʉhtoro Cohamacʉ to sʉho jihtore yahure. Jipihtia dohatia cʉ̃hʉre tó macainare yʉhdore tiro. ");
INSERT INTO gvc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Masa payʉ ñano yʉhdʉina, pjacʉoro wahaina ti jichʉ ñʉno Jesu tinare pja ñʉre. Tina oveja pʉa marieina yoaro sehe ti jichʉ ñʉno Jesu tuaro pja ñʉre tinare. ");
INSERT INTO gvc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ã jiro õ sehe nire tiro sãre to buheinare, piti dahre buhero: —Yo payʉ ti bʉcʉa tuhsʉchʉ payʉ jichʉ dahraa pjíro jira. Wiho mejeta dahraina sehe mahainacã jira. (Tó seheta noaa buheare tʉhohtina payʉ jichʉ pjíro jira mari dahraa. To ã jipachʉta mahainacã dahrari masa yoaro seheta noaa buheare buhehtina cʉ̃hʉ mahainacã jira.) ");
INSERT INTO gvc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ã jina noaa buheare buhehtinare painare to warocahtore siniga Cohamacʉre —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Baharo doce sãre to buheinare Jesu pjiroca, tuaare cũre sãre. Watĩare sã cohã masihti cjihtire jipihtia dohatiare sã cohã masihti cjihtire cũre sãre. ");
INSERT INTO gvc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Õ sehe wama tii sã Jesu to bese cũrina: Simo jire. Tiroreta Pedro ni pisure Jesu. Simo bahʉro Andre cʉ̃hʉ jire. Santiago cʉ̃hʉ to bahʉro João mehne jire. Tina Santiago cʉ̃hʉ pʉcʉro Zebedeo wama tire. ");
INSERT INTO gvc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Toma, yʉhʉ Mateo jii sã. Yʉhʉ sehe pʉhtoa ya cjihtire masare wapa na cohtariro jimai. Sã mehne pairo Santiago jire. Tiro sehe Alfeo macʉno jire. Ã jiro Tadeo cʉ̃hʉ jire. ");
INSERT INTO gvc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo cananeo ya curua macariro cjiro, Juda Iscariote cʉ̃hʉ jire. Juda sehe Jesure ñʉ tuhtiinare ñohtiro jire. ");
INSERT INTO gvc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ã yoa sãre doce to buheinare warocaro, “Õ sehe mʉsa yoanahca”, ni yahu quihõre sãre Jesu: —Judio masa jieraina cahapʉre wahaena tjiga. Ne Samaria yahpai jia macaripʉ cʉ̃hʉre wahaena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israe yahpa macaina cahapʉ sehere wahaga. Tina oveja peri wisia wahaina yoaro sehe Cohamacʉre masieraina jira. ");
INSERT INTO gvc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Mʉano macariro to sʉho jihto mahanocã dʉhsara”, ni buhega tinare. ");
INSERT INTO gvc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ã jina cami bʉcʉ baainare, paye payʉ soro jia dohatiare cjʉaina cʉ̃hʉre noaina yoaga. Yariainare masoga. Watĩa masare ti sãanohorinare cohã wioga tinare. Mʉsare ã wanocai nija ahri tuaare. Ã jina mʉsa cʉ̃hʉ yʉ ã wanocariro seheta masare noaina ã yoanocahga. ");
INSERT INTO gvc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mʉsa wahana niñerure ne naaena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ne mʉsa wajure, pʉaro camisare, pʉa wahpa dahpo suhtire, mʉsa tjua yucʉ cʉ̃hʉre naaena tjiga. Mʉsa sãano dihtare sãa wahcãga. Paye suhtire naaena tjiga. Mʉsa buhena waharopʉ jiina tina sehe mʉsare mʉsa puhi cjihtire waahca. Ãta waro cahmana tinare. ");
INSERT INTO gvc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Tí macaripʉ sʉna, ji coaro mehne carĩnore warirore macaga. Ã jina tí wʉhʉihta tjuasiniga. Pʉ, coã wahanapʉ wijaahga tí wʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ã jina wʉhʉpʉ sãahna, “¿Jimajari mʉsa?” niga tí wʉhʉ macainare. ");
INSERT INTO gvc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mʉsare noano ti cahmachʉ “Cohamacʉ mehne noano jiga mʉsa”, niga tinare. Mʉsare ti cahmaerachʉ, mʉsa ã niborire niena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ã jina mʉsare ti cahmaerachʉ, ti tʉho duaerachʉ tí wʉhʉre wijaahga. Wijaana, dahpo suhti macaa dihta pohcarire wajã site cũga mʉsa tinare ti ya buhirire masichʉ yoana. Tí maca macaina mʉsare ti cahmaerachʉ ãta yoaga tina cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Potocã mʉsare niita nija. Ahri dacho pihtichʉpʉre Sodoma macaina, Gomorra macaina cʉ̃hʉ tuaro buhiri tihtinata jira. Ti ã jipachʉta tina yʉhdoro mʉsare cahmaeraina buhiri tihtina jiahca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ã ni tuhsʉ õ sehe ni namore: —Yʉhʉre tʉhoga mʉsa. Oveja yoaro sehe jiinare mʉsare ñaina watoi warocai nija. Tina ñaina macaroca macaina yaya suaina yoaro sehe jira. Ã jina mʉsa sehe paina wahiquina wacũ masiina yoaro sehe jiga. Ã jiina jipanahta buja yoaro sehe ne suaeraina jiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Noano yoaga mʉsa. Masa mʉsare pʉhtoare waahca. Tuhsʉ Judio masa mari buhea wʉhʉsepʉ cjãpeahca mʉsare. ");
INSERT INTO gvc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ã jia yʉ yaina mʉsa jiri buhiri macari macaina pʉhtoa cahapʉ ti bui jiina pʉhtoa cahapʉ cʉ̃hʉre naahca mʉsare. Ã jina mʉsare tópʉ ti naachʉ tinare judio masa jieraina pʉhtoa cʉ̃hʉre noaa buheare buhenahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mʉsare pʉhtoare ti wachʉ tinare mʉsa nihtire “Cue, masieraboca”, ni tʉhotuena tjiga. Mʉsare ti sinituchʉta mʉsa nihtire masinahca. Ã masina tinare yahuna mʉsa tíre mʉsa mʉ sʉro durucuna nisi. Cohamacʉ sehe mʉsa Pʉcʉ to Espíritu mehne mʉsare durucuchʉ yoarohca. ");
INSERT INTO gvc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Tí pjare ti wahmisʉma ti bahanare wajã dutia waahca pʉhtoare yʉ yaina ti jiri buhiri. Ti pʉcʉsʉma ti pohnare wajã dutia waahca pʉhtoare. Ti pohna sehe ti pʉcʉsʉmare wajã dutia waahca pʉhtoare. ");
INSERT INTO gvc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jipihtina masa sehe yʉ yaina mʉsa jiri buhiri mʉsare ñʉ tuhtiahca. Ti ã yoapachʉta ahri yahpai mʉsa catisinino puro mʉsare ti ñano yoarire cʉ̃no pjana yʉhʉre, yʉ buhea cʉ̃hʉre duhuerana, yʉhdʉnahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cʉ̃macai mʉsare ti ñano yoachʉ pa macapʉ duhti wahcãga. Potocã mʉsare niita nija. Israe yahpai jia macarine jipihtia tí macaripʉ mʉsa duhti wahcãhto pano, yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉ tjua taihtja. ");
INSERT INTO gvc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ne cʉ̃iro buheriro tirore yahuriro buipʉ jierara. Cahamacʉno cʉ̃hʉ to pʉhtoro bui cure jierara. ");
INSERT INTO gvc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ã jiro õ sehe tʉhoturo cahmana buherirore: “Yʉhʉre buheriro yoaro seheta jiihtja”, ni tʉhoturo cahmana. Cahamacʉno cʉ̃hʉre ãta ni tʉhoturo cahmana. “Yʉ pʉhtoro yoaro seheta jiihtja”, ni tʉhoturo cahmana. (“To bui jiihtja. Ã jicʉ yʉ pʉhtoro to ñano yʉhdʉriro seheta ñano yʉhdʉsi yʉhʉ sehe”, ni tʉhotueraro cahmana.) Yʉhʉ sehe wʉhʉ pʉro yoaro sehe jija. Mʉsa sehe tí wʉhʉi dahraina yoaro sehe jira. Ã jia masa yʉhʉre “Beelzebú jira”, ni yahusã, mʉsa cʉ̃hʉre yʉ yainare ñano ni durucuahca tina —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ã ni tuhsʉ õ sehe ni namore: —Ã jina mʉsare ñano yoainare cuiena tjiga. Masa ti ya sãari cjirire baharo paina masiahca. Ã jia ti nʉori cjiri cʉ̃hʉre paina masiahca. ");
INSERT INTO gvc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mʉsare yaroca yʉ yahuri cjirire payʉ masa watoi buhe turiaga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Masʉnore wajãina to pjacʉ dihtare wajãna. To yajeripohna yariaerara. Ã jina mʉsare wajã duainare cuiena tjiga. Cohamacʉ sehere cuiga. Tiro mʉsa pjacʉrire, mʉsa yajeripohnari cʉ̃hʉre pichacapʉ cohã masina. Ã jina tiro sehere cui, yʉhtiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Pʉaro siripia wapa mariahna. Ti ã wapa mariapachʉta cʉ̃irocãre Cohamacʉ ne boerara. Cohamacʉ to dutierachʉ ne yarierara tirocã. ");
INSERT INTO gvc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ã jiro mʉsa pjoarire ne cʉ̃ pjoada dʉhsaro marieno masi pahñona Cohamacʉ. Tó seheta mʉsa jia tia cʉ̃hʉre masi pahñona Cohamacʉ. Ã masino mʉsare ñʉ wihborucura. ");
INSERT INTO gvc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Siripiare to cahĩno yʉhdoro, mʉsa sehere cahĩna Cohamacʉ. Ã jina pjíro tʉhotuena tjiga mʉsa —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ã jiro tinare õ sehe ni yahu namore: —Cʉ̃iro “Jesu yairo jija”, masare to ni yahuchʉ yʉhʉ cʉ̃hʉ tirore “Yʉ yairo jira”, ni yahuihtja yʉ Pʉcʉre mʉano macarirore. ");
INSERT INTO gvc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wiho mejeta cʉ̃iro “Jesu yairo jieraja”, masare to nichʉ yʉhʉ cʉ̃hʉ “Yʉ yairo jierara tiro”, ni yahuihtja yʉ Pʉcʉre —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ã ni tuhsʉ õ sehe ni yahu namore: —¿Dohse ni tʉhotujari mʉsa yʉhʉre? “Tiro masare to buheri baharo paina tinare ñʉ tuhtisi”, ¿ni tʉhotujari mʉsa? Ã jierara. Masare yʉ buheri baharo cãina yʉ yare tʉhoahca. Paina sehe tinare ñʉ tuhtiahca. Cʉ̃no potori waro jisi masa. ");
INSERT INTO gvc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bʉcʉna yʉ buheare ti tʉhori buhiri ti pohna yʉ buheare cahmaeraa, tinare ñʉ tuhtiahca. Bʉcʉ numia yʉ buheare ti tʉhori buhiri ti pohna numia yʉ buheare cahmaeraa, tinare ñʉ tuhtiahca. Ti marechosanumia yʉ buheare ti tʉhori buhiri ti macʉ namosãnumia yʉ buheare cahmaeraa, tinare ñʉ tuhtiahca. ");
INSERT INTO gvc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ã jia masa ti coyeare ñʉ tuhtiina jiahca. ");
INSERT INTO gvc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Yʉhʉre ti cahĩboriro yʉhdoro ti pʉcʉsʉma sehere cahĩ yʉhdʉrʉcaa yʉ yaina jisi tina. Yʉhʉre ti cahĩboriro yʉhdoro ti pohna sehere cahĩ yʉhdʉrʉcaa yʉ yaina jisi tina. ");
INSERT INTO gvc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ã jia paina crusapʉ yʉ yariahto seheta yʉ yaina ti jiri buhiri ñano yʉhdʉahca tina cʉ̃hʉ. Tó sehe ñano yʉhdʉ duaeraina yʉ yaina jisi tina. ");
INSERT INTO gvc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Masa yʉhʉre wacũno marieno ti mʉ sʉro yoaa, pichacapʉ wahaahca tina. Ã jia yʉ yare ã yoarucua jipihtia dachoripe yʉhʉ mehne jirucuahca tina —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ã ni tuhsʉ õ sehe ni yahu namore: —Mʉsare yʉ yainare cʉ̃iro noano cahmano, yʉhʉ cʉ̃hʉre cahmano nina tiro. Ã yoa tiro yʉhʉre noano cahmariro yʉhʉre warocariro cʉ̃hʉre cahmano nina. ");
INSERT INTO gvc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ã jiro Cohamacʉ yare yahuriro wapatarohca. Tirore noano yoarohca Cohamacʉ. Ã jiro to yare yahuriro to jichʉ ñʉno pairo tirore noano cahmano, yahuriro yoaro seheta wapatarohca tiro cʉ̃hʉ. Ã yoa pairo noano yoariro wapatarohca. Tuhsʉ, noano yoariro to jichʉ ñʉno pairo sehe tirore noano cahmano noano yoariro yoaro sehe wapatarohca tiro cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yʉ yairo cʉ̃iro to jichʉ ñʉa, wiho jiriro to jipachʉta dohse jiina tirore core ti sihõchʉ mahanocã ti wapachʉta potocãta tinare noano yoarohca Cohamacʉ —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sãre to buheinare to ã ni yahuri baharo tó cahai jia macaripʉ buhero wahare Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ã yoa to yoarire João peresui jiriro tʉhorocaha. Ã tʉhoro João to buheinare Jesure sinitu ñʉ dutiro warocaha. ");
INSERT INTO gvc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ã jia Jesu cahapʉ sʉ, sinitu ñʉre tina João buheina. —¿João “Yʉ baharo pairo tarohca”, to niriro tjijari mʉhʉ? ¿To niriro mʉ jierachʉ pairore cohtanahcari sã? —ni sinitu ñʉre tina sehe Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ti ã nichʉ tʉhoro Jesu õ sehe ni yʉhtire: —Mipʉre mʉsa tʉhorire, mʉsa ñʉrire Joãore yahuna wahaga: ");
INSERT INTO gvc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Capari bajueraina ñʉna. Tini masieraina tinina. Cami bʉcʉ baina noaina wahara. Tʉho bocaeraina tʉhoa wahara. Yariaina masaa wahara. Tina jipihtinare noaina wahachʉ yoahi yʉhʉ. Tuhsʉ, pjacʉoinare noaa buheare yahuja. ");
INSERT INTO gvc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yʉhʉre tʉhoriro ‘Potocã tjira’, niriro tiro wahcheriro jira” ni, Joãore yahuna wahaga —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","João buheina ti wahari baharo, Jesu sehe João to jia tiare yahu dʉcare payʉ masare: —Masa marienopʉ João cahapʉ sʉna, tjare wihnono to wãroca cohtotachʉ yoariro seheta to buheare cohtota mʉjarirore ñʉna sʉerare mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","“Noaa suhti tirirore ñʉna wahajihna”, nierare mʉsa João cahapʉ masa marienopʉ wahana. Noaa suhti tiina wapa bʉjʉare cjʉaina pʉhtoa ya wʉhʉsepʉ jira. ");
INSERT INTO gvc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Masa marienopʉ sʉna Cohamacʉ yare yahu mʉhtarirore ñʉna sʉre mʉsa. Potocã tjira. João Cohamacʉ yare yahu mʉhtariro jira. Paina Cohamacʉ yare yahu mʉhtaina yʉhdoro jiriro jira tiro. ");
INSERT INTO gvc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Panopʉ Cohamacʉ yare ti joari pũi Joãore õ sehe ni yahu joaa tiha: “Cohamacʉ to macʉnore õ sehe niha: ‘Mʉ pano mʉhʉre yahuyuhtirore warocai nija’, niha”, ni joaa tiha panopʉre Joãore. ");
INSERT INTO gvc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mʉsare potocã niita nija. Paina jipihtina bui jira João bautisariro. Ahri turupʉre to ã jipachʉta mʉano macariro pʉhtoro to sʉho jiropʉre jipihtina docapʉ jiriro pinihta João bui jira. ");
INSERT INTO gvc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’João masare bautisariro to buhe, bautisa dʉcachʉ payʉ masa mʉano macariro pʉhtoro to sʉho jirore pihtichʉ yoa duaa, ti mʉ sʉro cahmache, tíre yoa duamana. ");
INSERT INTO gvc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Cohamacʉ yare yahu mʉhtaina ti joari cjirire, Cohamacʉ Moise cjirore to cũri cjiripʉ cʉ̃hʉre buhena pʉhtoro Cohamacʉ to sʉho jihtore masija mari. João cʉ̃hʉ tíreta yahure. ");
INSERT INTO gvc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Elia tarohca”, panopʉ ti niriro cjirota jira João sehe. Panopʉ macaina ti nirire “Potocã tjira”, ni duana João ti ã niriro cjiro to jichʉ masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Noano tʉhoga mʉsa ahrire. ");
INSERT INTO gvc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Mipʉ macaina masa yabaina yoaro sehe jijari tina, mʉsa tʉhotuchʉ? Tina macanacã yoaro sehe jira. Paina ti cahmano sehe ti yoaerachʉ tó wahaerara tinacãre. Pache duaropʉ pape dujia, õ sehe ni pisurucura tinacã ti basi: ");
INSERT INTO gvc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mʉsa basahti cjihtire sã putipemahi. ¿Dohseana mʉsa basaerari sã tíre putipechʉ? Sã tuaro ñahacaha tiipe, sañurucumahi. ¿Mʉsa sehe dohseana sã mehne tiiperari?” nirucuina yoaro seheta jira mipʉ macaina cʉ̃hʉ. Mipʉ macaina ti cahmano seheta sã yoaerachʉ ñʉa tó wahaerara tinare. ");
INSERT INTO gvc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tina yoaro sehe yoana õ sehe yoara mʉsa mipʉ macaina. João bautisariro Cohamacʉre ño payoro taro chʉ duhuro vinore sihnierare. To ã sihnierachʉ ñʉna “Watĩno to sãanohriro, tʉho masierariro jira”, nimare mʉsa tiro sehere. ");
INSERT INTO gvc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yʉhʉ masʉno Cohamacʉ warocariro jicʉ yʉhʉ chʉ, sihnija. Yʉ ã yoachʉ ñʉna õ sehe nina mʉsa yʉhʉ sehere: “Ñʉga. Ahriro pjíro chʉriro, cahariro jira. Wapa na cohtaina, ñano yoaina cʉ̃hʉ ti piti tiriro jira ahriro”, nina mʉsa yʉhʉre. (Ã nina macanacã yoaro sehe durucuina jira mʉsa. Mʉsa cahmano sehe sã yoaerachʉ tó wahaerara mʉsare. Ne sahsaerara mʉsa.) Ã masierapanahta sã yoarire ñʉna, Cohamacʉ masiare sã cjʉachʉ masinahca mʉsa —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Baharo macari macainare tuhtire Jesu. Tí macarine paye macari yʉhdoro Cohamacʉ tuaa mehne yoa ñomare tiro. To ã yoa ñopachʉta ti ñaare tʉhotumarire duhuerasinire tina. Ã jiro õ sehe ni tuhtire tinare tiro: ");
INSERT INTO gvc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Corazĩ macaina, mʉsa ñano yʉhdʉnahca. Betsaida macaina, mʉsa cʉ̃hʉ ñano yʉhdʉnahca. Mʉsa ya macaripʉre Cohamacʉ tuaa mehne yoa ñomahi. Tiro wama tiri macare, Sidõ wama tiri maca cʉ̃hʉre to tuaa mehne yʉ yoa ñochʉ ñʉa panopʉ tó macaina sehe ti ñaare cahyaboa. Ã yoaa ti ñaare tʉhotumari cjirire tʉhotu cohtotaboa. Cahyaa suhtire sãa, niti pohcare tina bui dahra site payoboa ti ñaa cahyaare ñoa. ");
INSERT INTO gvc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mʉsare niita nija. Buhiri dahrehti dacho jichʉ Cohamacʉ Tiro macaina, Sidõ macaina yʉhdoro ñaina mʉsa jiri buhiri mʉsare ñano waro buhiri dahrerohca tiro. ");
INSERT INTO gvc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernau macaina, mʉsa mʉ sʉro mʉanopʉ waha duamana. Mʉsare Cohamacʉ pichacapʉ cohãnohca. Mʉsa ya macapʉ Cohamacʉ tuaa mehne yoa ñomahi. Mʉsa yʉhʉre tʉhoerare. Sodoma wama tiri macare Cohamacʉ tuaa mehne yʉ yoa ñochʉ tí maca sehe mipʉ jisiniboa. ");
INSERT INTO gvc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mʉsare niita nija. Buhiri dahrehti dacho jichʉ Cohamacʉ Sodoma macainare to yoariro yʉhdoro, mʉsa sehere mʉsa ñaa buhiri ñabiaro buhiri dahrerohca —nire Jesu tí macari macainare. ");
INSERT INTO gvc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tí pjare õ sehe nire Jesu to Pʉcʉro mehne durucuro: —Yʉ Pʉcʉ, mʉhʉ mʉano macaina bui pʉhtoro, ahri yahpa macaina bui pʉhtoro jira. Ahri mʉ buheare “Noano masiina jija sã”, niinare masichʉ yoaerare mʉhʉ. Buhe pahñoeraina sehere mʉ yare masichʉ yoare mʉhʉ. Mʉ ã yoachʉ, “Noana”, nija yʉhʉ mʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ã tjira. Tina sehere ti masichʉ cahmare mʉhʉ —nire Jesu to Pʉcʉrore. ");
INSERT INTO gvc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ã ni tuhsʉ, masare õ sehe ni yahu namore: —Yʉ Pʉcʉ jipihtiare yʉhʉre ware. Tiro dihta yʉhʉre noano masina. Ã jina sã dihta yʉhʉ yʉ masi dutiina mehne yʉ Pʉcʉre masija sã. ");
INSERT INTO gvc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mʉsa ñano buhiri tia nʉcʉa yoaro sehe jira. Nʉcʉare mʉna mʉsa tahrĩno seheta ñano buhiri tiare pumea wahara mʉsa. Ã pumeina jina yʉhʉre cahmaga mʉsa. Mʉsare sochʉ yoaihtja. Mʉsa ñaa yoaare duhuchʉ yoaihtja. ");
INSERT INTO gvc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yʉ dutiare yoaga. Yʉ yare noano masiga. Yʉhʉ niji siaro yoariro jija. Yʉ ã jiriro jichʉ yʉ yare noano masiga mʉsa. Ã yoa yʉhʉ mehne soga mʉsa. Ã sona noano yajeripohna tinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yʉ yare mʉsa yoachʉ mijoerara. Ã yoa mʉsa mʉri cjiri ti nʉcʉeraro seheta yʉhʉ sehe mʉsa bihoro purota yoa dutija mʉsare —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mahanocã to ã ni buheri baharo Sabado jichʉ sã Jesu mehne trigo wesepʉ sʉi. Sã to buheina jʉca baana, trigo parorire paha, chʉ tuhsʉ yʉhdʉ wahcãi sã. ");
INSERT INTO gvc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sã ã yoachʉ ñʉa, fariseo curua macaina Jesure õ sehe nire: —Tʉhosiniga sãre. ¿Dohse yoa tina Sabado mari sori nʉmʉ to jipachʉta dahrajari, trigo parorire ã pahaa? Mari dutiare yʉhdʉrʉcaa nina —nire tina. ");
INSERT INTO gvc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Jesu yʉhtire. “Yʉ buheina yʉhdʉrʉcaa nierare”, ni yahuro taro õ sehe ni yʉhtire: —Davi cjiro tiro mehne macaina mehne jʉca baaro Cohamacʉ wʉhʉpʉ sãa, Cohamacʉ ya pãore chʉha. Tí pãore sacerdotea dihtare chʉ dutira. Cohamacʉ dutiare ti joari pũ painare tí pãore chʉ dutierara. ¿Davi cʉ̃hʉ tíre ti yoari cjirire Cohamacʉ joari pũpʉ buherari mʉsa? (Tí pãore chʉro Cohamacʉre yʉhdʉrʉcaro nieraha. Michare ahri yaparire chʉa yʉ buheina cʉ̃hʉ Cohamacʉre yʉhdʉrʉcaa nierara.) ");
INSERT INTO gvc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ã yoa Cohamacʉ wʉhʉi dahraina sacerdotea ne soerara mari soa nʉmʉrine. Ã soerapahta Cohamacʉ dutiare yʉhdʉrʉcaina jierara. ¿Tíre buherari mʉsa Cohamacʉ Moise cjirore to cũri pũi? ");
INSERT INTO gvc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mʉsare niita nija. Cohamacʉ wʉhʉre ño payona tí wʉhʉi dahraina ti soerachʉ ñʉpanahta “Noanohca”, nina mʉsa. Tí wʉhʉ yʉhdoro yʉhʉ sehere ño payoro cahmana. ");
INSERT INTO gvc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Cohamacʉ yare ti joari pũ õ sehe nina: “Wahiquinare wajã, jʉ̃ mʉoa mehne yʉhʉre mʉsa ño payochʉ cahmaeraja. Painare mʉsa pja ñʉchʉ sehere cahmaja yʉhʉ”, nina to yare ti joari pũ. To ã nirire mʉsa noano tʉhona yʉ buheinare tuhtieraboa mʉsa. Tina tíre chʉa yʉhdʉrʉcaa nierare. Ã jina tinare tuhtieraboa mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉhʉ masʉno Cohamacʉ warocariro ahri dacho Sabado dachore masa ti yoahtire yahurirota jicʉ pʉhtoro tjija —nire Jesu fariseo curua macainare. ");
INSERT INTO gvc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","To ã niri baharo waha, judio masa mari buheri wʉhʉpʉ sʉi sã Jesu mehne. ");
INSERT INTO gvc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tói wamomaca bʉhariro jire. Ã jia fariseo curua macaina sehe Jesure yahusãa taa, tirore õ sehe ni siniture: —Sabado dachoi mari sori dachoi masʉnore noariro yoa dutierara Cohamacʉ. ¿Ã tjijari mʉ tʉhotuchʉ? —ni siniture tina. ");
INSERT INTO gvc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu õ sehe ni yʉhtire tinare: —¿Mʉsa yairo oveja Sabado jichʉ copapʉ to bora sãachʉ tirore na wioerabocari mʉsa? Na wionahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oveja yʉhdoro jira masʉno sehe, Cohamacʉ to ñʉchʉ. Ã jiro Sabado jichʉ masʉnore yʉhdochʉ noa nina —ni yʉhtire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ã ni tuhsʉ, wamomaca bʉharirore õ sehe nire: —Mʉ wamomacare siõrocaga —nire tiro. To ã nichʉ bʉhariro sehe siõroca, noari wamomaca wahare. ");
INSERT INTO gvc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ti sori nʉmʉi to ã yoachʉ ñʉa, fariseo curua macaina waha, ti basi õ sehe niha: —¿Dohse yoa Jesure wajãnahcari mari? —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu ti ã nirire masino, wahaa wahare. To ã wahachʉ payʉ masa tirore nʉnʉ tire. Ti ã nʉnʉ tichʉ ñʉno tiro sehe jipihtina tina mehne macainare dohatiinare noaina wahachʉ yoare. ");
INSERT INTO gvc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ã yoaro dohatiina cjirire tinare to yʉhdorire painare yahu dutierare tiro. ");
INSERT INTO gvc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ã dohatiinare noaina wahachʉ yoaro Cohamacʉ yare yahu mʉhtariro Isaia cjiro panopʉ to ni joariro seheta yoaro nire Jesu. Õ sehe ni joaa tiha Isaia: ");
INSERT INTO gvc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Õ sehe nina Cohamacʉ: ‘Ahriro yʉ cahamacʉno jira. Tiro yʉ beseriro jira. Tirore cahĩja. Ã jicʉ tiro mehne wahcheja. Yʉ Espíriture tirore waihtja. Ã jiro yʉ tuaa mehne jipihtina masare yʉ buheare yahurohca tiro. ");
INSERT INTO gvc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ã yahuro tiro ne purĩno mehne yahusi. Ã yoa niji siaroca yahuriro jiro sañurucusi. Tuhsʉ, maca macari mahai payʉ masa watoi tiro tuaro sañurucu yahusi. ");
INSERT INTO gvc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wʉjʉcʉ o muquearʉcʉ sʉchʉ to nuhnuerachʉ yoaro seheta masa cʉ̃hʉre niji siaro dero yoarohca tiro. Pjiroca jʉ̃ri pichacare to yaeraro seheta masa cʉ̃hʉre noano yoarohca tiro. Ãta yoarucurohca tiro watĩnore to yʉhdʉrʉcahto pano. ");
INSERT INTO gvc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ã jia payʉ masa tirore wacũ tuaahca’, nina Cohamacʉ”, ni joaa tiha Isaia. ");
INSERT INTO gvc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Cʉ̃ dachoi watĩno to cohtotarirore masa na tare Jesu cahapʉ. Tiro sehe watĩno cjʉaro durucu masierare. Tuhsʉ, capari ne ñʉerare. Ti ã na wihichʉ ñʉ, noariro wahachʉ yoare Jesu tirore. To ã yoachʉ watĩno to cohtotariro cjiro ñʉ, durucure. ");
INSERT INTO gvc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","To ã wahachʉ ñʉa, masa ñʉ cʉaa wahare. —¿Ahriro Davi cjiro panamino masare yʉhdohtiro jijari? —nire tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jesu watĩare to cohãrire tʉhoa fariseo curua macaina õ sehe ni tʉhoture: —Beelzebú watĩa pʉhtoro to tuaa mehne watĩare cohãna Jesu —ni tʉhoture tina. ");
INSERT INTO gvc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ti ã ni tʉhotuchʉ masino, Jesu quiti mehne piti dahre yahure tinare: —Watĩno ya tuaa mehne watĩare cohãi nieraja. Cʉ̃ yahpa macaina ti basi cahma wajãa, tí yahpa macaina yaria pihtia wahaboa. Cʉ̃ maca macaina ti basi cahmachea tí maca macaina waha pihtia wahaboa. Cʉ̃ wʉhʉ macaina cʉ̃hʉ ãta wahaboa. ");
INSERT INTO gvc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ã jia Beelzebú watĩa pʉhtoro sehe watĩare cohãno, tina watĩa ti basi cahmachea niboa. Ã jia tina cʉ̃hʉ waha pihtia wahaboa. ");
INSERT INTO gvc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Õ sehe ni yahusãna mʉsa yʉhʉre: “Tiro Beelzebú yoadohoa mehne watĩare cohãna”, ni yahusãna mʉsa. Mʉsa mehne macaina cʉ̃hʉ watĩare cohãna. ¿Watĩno to tuaa mehne watĩare cohãjari tina cʉ̃hʉ, mʉsa ñʉchʉ? Ã cohãerara. Tíre masina mʉsa. Yʉhʉ cʉ̃hʉ watĩno tuaa mehne watĩare cohãeraja. ");
INSERT INTO gvc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ã jicʉ yʉhʉ sehe watĩare cohãcʉ Cohamacʉ to Espíritu tuaa mehne tinare cohãja. Yʉ ã cohãchʉ ñʉna õ sehe masiga mʉsa: Cohamacʉ masa bui pʉhtoro ahri yahpapʉre ji tuhsʉra mipʉre. ");
INSERT INTO gvc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Õ seheta jira mari piti dahre buhechʉ: Tuariro ya wʉhʉpʉ pairo sãa sʉ yaca masierara. Tuarirore dʉhteraro to ya wʉhʉpʉ sãa sʉ yaca masierara. Tirore to dʉhteri baharo sãa sʉ yaca masina —ni yahure Jesu. (Ã ni yahure watĩnore to yʉhdʉrʉcarire yahuro. Watĩno tuariro to jipachʉta Jesu tirore yʉhdʉrʉcara watĩare cohãno.) Ã ni tuhsʉ õ sehe ni yahu namore Jesu: ");
INSERT INTO gvc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Cʉ̃iro yʉhʉre cahmaeraro, yʉhʉre ñʉ tuhtiriro jira. Cʉ̃iro yʉhʉre yoadohoeraro, yʉhʉre wapʉ tichʉ yoaro nina. ");
INSERT INTO gvc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ã jicʉ mʉsare potocã niita nija yʉhʉ. Jipihtia ñaare masa ti yoachʉ ti durucuchʉ cʉ̃hʉre Cohamacʉ bo masina. Ã boparota Espíritu Santore ti ñano ni durucuchʉ tí pinine ne bosi. ");
INSERT INTO gvc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yʉhʉre masʉno Cohamacʉ warocarirore yʉhʉre ti ñano ni durucurire bo masina Cohamacʉ. Espíritu Santo sehere ti ñano ni durucurire ne bosi Cohamacʉ. Mipʉre, pihtiri dacho baharopʉ cʉ̃hʉre ti ã niri cjirire bosi tiro —ni buhere Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ã ni buhe tuhsʉ, piti dahre buhero õ sehe ni yahu namore tinare: —Noadʉ yucʉcʉ noaare dicha tira. Ñaadʉ yucʉcʉ ñaare dicha tira. Yucʉcʉ dichare masina “Tʉ dichata jira”, ni masija mari. (Mari ã masino seheta masa ti durucuare tʉhona ti jia tiare masija mari.) ");
INSERT INTO gvc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Agãa ñima tiina yoaro sehe ñaina jira mʉsa. Mʉsa ñaina jina, noaare ni masierara mʉsa. Mari wacũapʉ mari tʉhoturiro seheta mari dʉseroi wijara. ");
INSERT INTO gvc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Noariro noaare tʉhotura. Ã jiro noaare durucura. Ñariro ñaare tʉhotura. Ã jiro ñaare durucura. ");
INSERT INTO gvc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mʉsare niita nija. Noano tʉhotu durucuina jiga mʉsa. Noano durucuerana, buhiri dahrehti dacho jichʉ mʉsa ã nimacanocarire Cohamacʉre yahu yʉhdʉnahca. ");
INSERT INTO gvc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Quihõno mʉsa durucurire masino “Noaina jira”, ninohca Cohamacʉ. Tuhsʉ, ñano mʉsa durucurire masino “Ñaina jira”, ninohca tiro —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","To ã niri baharo mari judio masare buheina, fariseo curua macaina cʉ̃hʉ tirore õ sehe nire: —Buheriro, Cohamacʉ warocariro jicʉ Cohamacʉ tuaa mehne yoa ñoga sãre —nimare tina. ");
INSERT INTO gvc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu õ sehe ni yʉhtire: —Mipʉ macaina ñaina, Cohamacʉre cahmaeraina Cohamacʉ tuaa mehne yʉ yoa ñochʉ ñʉ duamana. Ti ã ñʉ duapachʉta Cohamacʉ yare yahu mʉhtarirore Jona cjiro panopʉ macarirore Cohamacʉ to tuaa mehne to yoari dihtare yoa ñonohca masare. ");
INSERT INTO gvc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona tia dacho waro pjiriro wahi pjaro puhichapʉ jiha. To ã wahariro seheta yʉhʉ cʉ̃hʉ masʉno Cohamacʉ warocariro tia dacho waro masa copapʉ jiihca. ");
INSERT INTO gvc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive macaina sehe Jona Cohamacʉ yare to yahurire tʉhoa ti ñaa yoarire cahya, Cohamacʉ mehne macaina tjuaha. Ã tjuaina jia buhiri dahrehti dacho jichʉ tina mipʉ macainare ti ñaare tʉhotumari cjirire duhuerainare “Ñaina jira”, ni yahusãahca. Jona cjiro tinare Cohamacʉ yare to yahuchʉ tʉhoa noaare cahmaha tina sehe. Ã cahmaa noano yoaa niha mipʉ macaina yʉhdoro. Ã jia tina mipʉ macainare “Ñaina jira”, ni yahusãahca. Mʉsare niita nija. Mipʉ mʉsare yʉ buhea Jona cjiro to buheri yʉhdoro jira. ");
INSERT INTO gvc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ã yoa buhiri dahrehti dacho jichʉ pʉhtorocoro sur macaricoro panopʉ macaricoro ducu, mipʉ macainare “Ñaina jira”, ni yahusãnohca ticoro cʉ̃hʉ. Ticoro Salomo panopʉ macariro to masiare tʉho duaro yoaropʉ ahri yahpa pa bʉhʉsehepʉ jiricoro Salomore tʉhoro taha. Ã yoaro noano yoaro niha mipʉ macaina yʉhdoro. Ã jiro ticoro “Ñaina jira”, ni yahusãanohca mipʉ macainare. Mʉsare niita nija. Mipʉ mʉsare yʉ buhea to buheri yʉhdoro jira —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ã ni tuhsʉ, pari turi Jesu to tʉhotua mehne õ sehe ni piti dahre buhere tinare: —Watĩno masʉnore cohtotariro cjiro waha, tiro co marieni yahpai tini, to jihto cjihtore macamaha. ");
INSERT INTO gvc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ã bocaeraro, õ sehe ni tʉhotuha tiro. “Masʉno yʉ cohãriro cjiro mehneta pari turi jii wahaihtja”, ni tʉhotuha tiro. Ã ni tʉhoturo tiro tjuaa waha, to cohãriro cjiroreta bocaha. Ã to bocachʉ masʉno sehe noariro jimaha. ");
INSERT INTO gvc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ã jiro watĩno paina siete watĩare to yʉhdoro ñainare pjiro wahaha. To ã pjichʉ tina jipihtina tiro mehne jiha. Masʉno sehe tó pano cʉ̃iro watĩno to cohtotariro jiro, ñariro jimaha. Mipʉ sehere payʉ watĩa ti cohtotariro jiro, tó pano to jiriro yʉhdoro ña yʉhdʉariro jiha. Mipʉ macaina Cohamacʉre masimarina tirore cohãa, tina cʉ̃hʉ ñaa yʉhdʉina warota wahaahca —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Masare to ã ni durucuro watoi to pocoro to bahana mehne sopacai ducu, tiro mehne sʉhʉdu duare. ");
INSERT INTO gvc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ã jiro cʉ̃iro Jesure õ sehe ni yahure: —Mʉ poco mʉ bahana mehne sopacai ducura, mʉhʉre sʉhʉdu duaa —nire. ");
INSERT INTO gvc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","To ã nichʉ tʉhoro tirore yahurirore õ sehe nire Jesu tinare buhero taro: —¿Noa jijari yʉ poco, yʉ bahana cʉ̃hʉ, mʉsa ñʉchʉ? —nire. ");
INSERT INTO gvc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ã nino, sãre to buheinare ñuipuro, õ sehe nire: —Ahrina jira yʉ poco yʉ bahana yoaro sehe jiina. ");
INSERT INTO gvc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tina yʉ Pʉcʉ mʉano macariro to cahmaare yoara. Tó sehe yoaina yʉ bahʉ, yʉ baho, yʉ poco yoaro seheta jira —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tí dachoihta Jesu wʉhʉi jiriro wijaare. Wijaa, bʉcʉpariropʉ waha, bʉcʉpariro dʉhtʉ cahai dujire. ");
INSERT INTO gvc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","To ã dujichʉ ñʉa payʉ masa tiro cahapʉ cahmachu wahpata yʉhdʉa, bihsaro yoare Jesure. Ã bihsachʉ ñʉno dohoriai samu, tiapʉ dujire tiro. Masa sehe padʉroi ducure. ");
INSERT INTO gvc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ã jiro payʉ to tʉhotua mehne piti dahre yahure tinare buhero taro. Õ sehe nire tiro: —Toari masʉno toaro, to toaa yaparire doca site cũno wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","To ã doca site cũ wahcãchʉ paye yapari maha dʉhtʉ cahai bora caha sʉha. Ã bora caha sʉare tí yaparire minichahca duji ta, chʉnocaha. ");
INSERT INTO gvc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","’Ã yoa paye yapari sehe tãa wapa buicã bora caha sʉha. Tãa wapa buicã dihta mariea cureroi dóihta dumaha. ");
INSERT INTO gvc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ã duri jipahta, sʉ̃ to tuaro sichʉ, nʉhcori mariaa, ñaia wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Paye yapari sehe tja watoi bora caha sʉha. Tja sehe dia yʉhdʉa waha, toaa sehere wajãnocaha. ");
INSERT INTO gvc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Paye yapari sehe noari yahpai bora caha sʉha. Noano dua jia noano dicha tiha. Paye yucʉ cien yapari, paye yucʉ sesenta yapari, paye yucʉ treinta yapari dicha tiha. ");
INSERT INTO gvc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ahrire tʉho duaina noano tʉhoga mʉsa —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","To ã niri baharo sã to buheina tiro cahai sʉ, sinitui sã tirore: —¿Ne, dohseacʉ masare quiti mehne piti dahre buhejari mʉhʉ? —ni sinitui sã. ");
INSERT INTO gvc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu õ sehe ni yʉhtire: —Mʉano macariro masa bui pʉhtoro masare to noano sʉho jiare panopʉ macaina ti masierari cjirire mʉsare yʉ buheinare masichʉ yoara Cohamacʉ. Paina sehere ã yoaerara tiro. ");
INSERT INTO gvc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ã jiro masiinare masi namochʉ yoarohca tiro. Ã jia tina sehe noano masiahca. Masieraina sehe mahanocã ti masipachʉta tina sehere masierachʉ yoarohca tiro. ");
INSERT INTO gvc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ã jicʉ quiti mehne buheja. Õ sehe jira. Mipʉ macaina ñʉpahta, ñʉeraina cjiri yoaro sehe tjuara. Ã jia tʉhopahta masierara. Tíre tʉhoeraina yoaro sehe jira tina. ");
INSERT INTO gvc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ã jiina jia Isaia cjiro panopʉ macariro to ni joariro seheta yoara tina. Õ sehe ni joaa tiha: “Õ sehe nina Cohamacʉ: ‘Yʉ yare tʉhonahca mʉsa. Ã tʉhopanahta, ne masisi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mʉsa dapu bʉtiina tjuara. Tuhsʉ, mʉsa cahmo coparire bihara mʉsa, “Tʉhori”, nina. Mʉsa caparire wihmitjiahna mʉsa, “Ñʉri”, nina. Ã yoaerana noano ñʉna masiboa mʉsa. Ã yoa tʉhona, masiboa mʉsa. Mʉsa wacũapʉ noano masiboa. Ã masiina baro jina, mʉsa tʉhotumari cjirire tʉhotu cohtota, yʉhʉre macaboa. Mʉsa ã macachʉ ñʉno, yʉhʉ sehe mʉsa buhiri tiare cohãboa’, nina Cohamacʉ”, ni joaha Isaia cjiro. ");
INSERT INTO gvc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Mʉsa sehe mʉsa capari mehne ñʉna, masina. Mʉsa cahmo mehne tʉhona, masina. Ã jina wahcheina jira mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mʉsare niita nija. Mipʉ mʉsa ñʉare mʉsa tʉhoare panopʉ macaina Cohamacʉ yaina cjiri tuaro ñʉ duamaha. Cohamacʉ yare yahu mʉhtaina cjiri cʉ̃hʉ tíre tuaro ñʉ duamaha. Wiho mejeta ne ñʉeraha. Mipʉ mʉsa tʉhoa cʉ̃hʉre tuaro tʉho duamaha tina. Ã masi duapahta tíre masieraha —ni yahure Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Baharo Jesu sãre õ sehe ni yahu namore: —Tʉhoga mʉsa. Wesere toari masʉno quitire mʉsare yahuihtja. Yʉhʉre tʉhona, noano masiga. ");
INSERT INTO gvc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Doca site cũa yapari noaa buhea yoaro sehe jira. Ã jia maha dʉhtʉ cahai boraa yapari noaa buhea yoaro sehe jira. Masa noaa buheare tʉhopahta ne masierara. Noaa buheare masa ti tʉhochʉ ñʉno watĩno sehe ta, tí buheare noaa buheare masi dutierara masare. Minichahca tí yaparire ti dota nariro seheta yoara watĩno. ");
INSERT INTO gvc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ã yoa tãa wapa buicã boraa yapari noaa buhea yoaro sehe jira. Ã jia masa noaa buheare tʉho, wahchea mehne dóihta tíre tʉho nana. ");
INSERT INTO gvc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ã tʉho napahta tãa wapa buicã jia yucʉ nʉhcori mariea yucʉ yoaro seheta ahrina masa cʉ̃hʉ tuaerara. Ã tuaeraa ñano yʉhdʉa, yʉ yaina ti jiri buhiri paina tinare ti ñano yoachʉ ñʉa yʉ ya sehere duhunocahna. Paina tinare ti ñano yoachʉ tíre cʉ̃no pjaeraa, yʉ yare duhunocahna. ");
INSERT INTO gvc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ã yoa tja watoi boraa yapari noaa buhea yoaro sehe jira. Ã jia masa noaa buheare tʉho, ahri yahpa macaare pjíro cahya tʉhotua, niñerure cahĩna. Ti ã yoachʉ tí sehe noaa buheare dʉcatara. Ti ã dʉcatachʉ masa noaa sehere yoaerara. ");
INSERT INTO gvc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ã yoa noari yahpai boraa yapari noaa buhea yoaro sehe jira. Masa noaa buheare tʉhoa, tíre noano masina. Ã masiina jia, Cohamacʉ to cahmano seheta noaare yoara tina. Cãina pjíro noaare yoara cien yapari dicha tiro seheta. Paina doca curero noaare yoara sesenta yapari dicha tiro seheta. Paina mahanocã noaare yoara treinta yapari dicha tiro seheta —ni yahure Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ã yoa pari turi to tʉhotua mehne piti dahre buhere Jesu: —Mʉano macariro masa bui pʉhtoro to sʉho jiro õ sehe jira. Wese pʉro to wesepʉ noaa yaparire to toariro seheta jira mʉano macariro masa bui pʉhtoro to sʉho jiro. ");
INSERT INTO gvc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wese pʉro jipihtina tiro mehne macaina cʉ̃hʉ ti carĩno watoi tirore ñʉ tuhtiriro tara. Ã taro trigore ti toariroi tjare toaha. Toa tuhsʉ wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Baharo trigo duha. Ã jiro ti dicha tia cahachʉ waro diaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ã jia wese pʉrore dahra cohtaina tiro cahapʉ sʉ, yahua: “¿Pʉhtoro, noaa yapari dihtare mʉ wesere mʉ toapachʉta, dohse yoa tja cʉ̃hʉ diajari tí wesere?”, niha tina. ");
INSERT INTO gvc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Yʉhʉre ñʉ tuhtiriro jia tí tjare toaro”, niha wese pʉro. “¿Tjare sã curechʉ cahmajari mʉhʉ?” nimaha tirore dahra cohtaina. ");
INSERT INTO gvc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Tjare curena tjiga, tjare curemahna ‘Trigo sehere cureri’, nina. ");
INSERT INTO gvc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Trigo tja mehneta bʉcʉawahnosinijaro. Dicha ñaini pja jichʉ, trigo dicha nainare õ sehe niihtja: ‘Tjare cure mʉhtaga. Tuhsʉ mʉsa curerire jʉ̃ga. Baharo trigore pahaga. Paha pahño, tíre yʉ wihbori wʉhʉpʉ cũga’, niihtja tinare”, niha wese pʉro —nire Jesu, quiti mehne yahuro. ");
INSERT INTO gvc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ã yoa paye quiti mehne sãre õ sehe ni buhere tjoa: —Mʉano macariro masa bui pʉhtoro to sʉho jiro mostaza yapacã yoaro sehe jira. Tí yapacã mahabiari yapacã jira. ");
INSERT INTO gvc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tí yapacãre wesepʉ to toari baharo, noano dura. Ã jiro pji curedʉ wahara. Ã wahachʉ minichahca peri tʉ dʉpʉripʉ suhti suhara. (Tó seheta mʉano macarirore mari pʉhtorore masiina mahainacã ti ji mʉhtapachʉta baharopʉ tina payʉ wahaahca) —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ã yoa paye quiti mehne sãre õ sehe ni buhere tjoa: —Mʉano macariro masa bui pʉhtoro to sʉho jiro pão bʉcʉaro yoaro sehe jira. Tíre numino cʉ̃ wajuru trigo pohcare co mehne noano tíre dahra morena pão bʉcʉahtore. To ã yoachʉ pão bʉcʉaro sehe trigore noano sahserʉcʉ sʉra. (Tó seheta pão bʉcʉaro to sahserʉcʉ sʉro seheta mʉano macarirore mari pʉhtorore payʉ masa jipihtiro macaina masiahca) —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ahri jipihtiare buhero, quiti mehne yahure Jesu. Quiti marieno yahuerare tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ãta yoare tiro Cohamacʉ yare yahu mʉhtariro cjiro to ni joariro seheta. Õ sehe ni joaa tiha panopʉ: “Quiti mehne yahuihtja. Cohamacʉ ahri yahpare to bajuamehneri baharo ne masare to yahuerari cjirire yahuihtja”, ni joaa tiha Cohamacʉ yare yahu mʉhtariro cjiro. ");
INSERT INTO gvc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ã yoa masare coha siti, wʉhʉpʉ sãa wahare Jesu. Ã jina sã to buheina tiro cahapʉ sʉ, sinitui sã: —Trigo watoi tja diari quitire yahu pahñoga sãre —nii sã tirore. ");
INSERT INTO gvc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu õ sehe ni yʉhtire sãre: —Wese pʉro noaa yaparire toariro yoaro sehe jija yʉhʉ. Yʉhʉ masʉno Cohamacʉ warocariro jija. ");
INSERT INTO gvc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wese sehe ahri yahpa yoaro sehe jira. Noaa yapari dua mʉano macariro pʉhtoro to sʉho jiropʉ jihtina cjihti yoaro sehe jira. Tja sehe watĩno yaina yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Wese pʉrore ñʉ tuhtiriro tjare toariro watĩno yoaro sehe jira. Tí ñaini pja sehe pihtiri dacho yoaro sehe jira. Ã jia trigore naina anjoa yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tjare ti cure jʉ̃riro seheta pihtiri dacho jichʉ watĩno yainare, pichacapʉ jʉ̃ cohãahca tinare. ");
INSERT INTO gvc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉhʉ masʉno Cohamacʉ warocariro yʉ anjoare warocaihtja. Yʉ ã warocachʉ anjoa sehe ñaare yoa dutiinare, ñaare yoainare pʉhtoro yʉ sʉho jiropʉre jimarinare na wioahca. ");
INSERT INTO gvc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na wio tuhsʉ pichacapʉ cohãahca tinare. Tópʉ tina tuaro tii, cahyaa mehne bahca dihoahca. ");
INSERT INTO gvc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ã jia Cohamacʉ yaina ti Pʉcʉro pʉhtoro to sʉho jiropʉ jiahca. Tói jia, sʉ̃ dacho macariro yoaro sehe noano buhriaahca tina. Ahrire noano tʉhoga mʉsa —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ã yoa paye quiti mehne õ sehe ni yahure tjoa: —Mʉano macariro masa bui pʉhtoro to sʉho jiro niñeru to nʉori yoaro sehe jira. Masʉno tíre wesepʉ wacũeno boca, pari turi tíre nʉo namona. Ã yoaro tuaro wahcheha tiro. Ã jiro to bocari cjirire nano taro, tí wesere nuchʉ duaha. Ã nuchʉ duaro to yare dua pahño, tí wesere nuchʉha. Mʉano macariro pʉhtoro to sʉho jiro to bocari cjiri yoaro sehe jiha. (To bocarire to cahma yʉhdʉariro seheta mʉano macarirore masa bui pʉhtorore noano ti masini baharo masa tuaro cahmana tirore) —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ã yoa paye quiti mehne õ sehe ni yahure tjoa: —Mʉano macariro masa bui pʉhtoro to sʉho jiro wapa bʉjʉa yaparire perla wama tia yaparire nuchʉriro yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tí yaparire macano noa yʉhdʉri yapare bocaha. Ã bocaro, tí yapare nuchʉ duaro, jipihtia to yare dua pahñono wahaha. Ã dua tuhsʉ tí yapare wapa bʉjʉri yapare nuchʉra. (Tí yapare tuaro to cahmariro seheta mʉano macarirore masa bui pʉhtorore noano ti masini baharo masa tuaro cahmana tirore) —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ã yoa paye quiti mehne Jesu õ sehe ni yahure tjoa: —Mʉano macariro masa bui pʉhtoro to sʉho jiro wañʉno ti docañodʉ yoaro sehe jira. Tʉ wañʉno mehne payʉ wahi soro jiinare ñahana. ");
INSERT INTO gvc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tʉ to wahpaa wahachʉ wahi wajãina sehe tʉre padʉropʉ waja maja, noaina wahire besera. Noainare ti pʉhʉsepʉ bese sãana. Ñaina wahire cohãnocahna. ");
INSERT INTO gvc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pihtiri dacho jichʉ õ sehe jirohca. Anjoa sehe masare beseahca. Ñainare na wioahca noaina cahapʉ jimarinare. ");
INSERT INTO gvc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na wio, tinare pichacapʉ cohãahca. Tói tina tii, tuaro cahyaa mehne bahca dihoahca ñaina sehe —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","To ã ni yahuri baharo tiro õ sehe ni siniture sãre: —¿Ahri jipihtiare tʉhojari mʉsa? —ni siniture tiro. —Tʉhoja sã —ni yʉhtii sã. ");
INSERT INTO gvc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sã ã nichʉ tiro yahure sãre: —Judio masare buheina mʉano macariro masa bui pʉhtoro to sʉho jirore buhea, pʉaro buheare yahura. (Panopʉ ti buhea cʉ̃hʉre mipʉ ti buhea cʉ̃hʉre yahura.) Tina, Judio masare buheina wʉhʉ pʉro yoaro sehe jira. Tiro to wʉhʉi jiare noare na wioro, wahmaare, mʉnaa cʉ̃hʉre na wiora tiro —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tí quitire to buheri baharo, wahai sã tiro mehne. ");
INSERT INTO gvc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Waha, to bʉcʉari macapʉ sʉhi. Tópʉ sʉ, judio masa mari buhea wʉhʉsepʉ buhere tiro. To ã buhechʉ tʉhoa, tʉho cʉaa wahare tina. —Cuenah, ¿ahriro nohopʉ tʉhoari ahri buheare? ¿Dohsearo noano masi pahñojari ahriro? Cohamacʉ tuaa mehne yoa ñona tiro to basi. ");
INSERT INTO gvc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ahriro taboa dahrari masʉno macʉno jimanaro. Ã yoa to pocoro María jimanaro. Ã yoa Santiago, José, Simo, Juda, to bahana jimanabʉ. ");
INSERT INTO gvc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mipʉre to bahana numia ahri macai jira. Ã jiro tiro mari yoaro sehe jiriro tjira. ¿Ã jiparota nohopʉ tʉhoari tiro ahri buheare? —ni durucure tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ã jia tina tirore cahmaerare. Ti ã cahmaerachʉ ñʉno õ sehe nire Jesu tinare: —Cohamacʉ yare yahu mʉhtarirore paina ño payora. Ti ã ño payopachʉta to ya maca macaina, to coyea tirore ño payoerara. Ã jina yʉhʉre ño payoerara mʉsa õi yʉ bʉcʉariro jichʉ —nire tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ã jiro tirore ti wacũ tuaerachʉ ñʉno “Cohamacʉ macʉno jira”, ti ni duaerachʉ ñʉno, tí macai Cohamacʉ tuaa mehne payʉ tahari yoa ñoerare Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tí pjare Herode Galilea macariro pʉhtoro Jesu to yoarire tʉhorocaha. ");
INSERT INTO gvc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ã tʉhoro õ sehe nimaha: —João masare bautisariro yariariro cjiro pari turi bajuaro nica. Ã jiro mipʉre to bajuari baharo ahri tuaare cjʉara tiro bajuamehneare yoaro —nimaha Herode to cahamacare. (Jesure “Joãota jira”, ni tʉhotumaha tiro Joãore ti wajãri baharo.) ");
INSERT INTO gvc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Joãore to wajã dutihto pano Herode to bahʉro Felipe namonore namo tiha. To ã yoachʉ ñʉno João bautisariro Herode sehere õ sehe nia timaha: —Mʉ bahʉ namonore namo ticʉ Cohamacʉ dutiare yʉhdʉrʉcai nina mʉhʉ —nia timaha João. To ã niri buhiri Herode tirore wajã duamaha. “ ‘João Cohamacʉ yare yahu mʉhtariro jira’, ni tʉhotura judio masa” nino, tina sehere cuiha Herode. “Joãore yʉ wajãchʉ tina suaboca” nino, tinare cuiha. Ã cuiro Joãore wajã duaeramaha. Ã wajã duaeraparota Herode tirore ñaha dʉhte duti, peresu yoaha. To namono Herodia to dutiro mehne ã yoaha. ");
INSERT INTO gvc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ã yoa Herode to masa bajuari dacho jichʉ bose nʉmʉ yoaha tiro. Tói Herodia macono bose nʉmʉ wihiina ti ñʉrocaroi basa ñoha. To ã basa ñochʉ ñʉno Herode wahcheha. Ã wahchero ticorore õ sehe niha: ");
INSERT INTO gvc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","—Cohamacʉ mehne potocã niita nija. Yʉhʉre mʉ sinino purota waihtja yʉhʉ mʉhʉre —niha jʉna Herode sehe Herodia maconore. ");
INSERT INTO gvc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","To ã nichʉ tʉhoro Herodia to maconore to sinihtore yahuha ticorore. To ã yahuchʉ to macono sehe õ sehe ni siniha Herodere: —João masare bautisariro dapure cjã ta dutiga. Ã yoacʉ waparo mehne tí dapure waga yʉhʉre —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","To ã nichʉ tʉhoro Herode tuaro cahyaha. Masa ti ñʉrocaroi “Waihtja mʉhʉre”, niha tiro. Ã jiro tiro bʉo tiro “Mʉhʉre to dapure waeraja”, ni masieraha ticorore. Ã jiro ticoro to dutiriro seheta Herode sehe to cahamacare Joãore wajã dutiha. ");
INSERT INTO gvc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","João dapure cjã taroca dutiha jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ã cjã ta tuhsʉ, waparo mehne to dapure na taha tina. Herodia maconore to dapure ti wachʉ, ticoro sehe to pocorore yʉhdoha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ti ã yoari baharo João buheina ta, to pjacʉre masa copapʉ na cũha. Ã cũ tuhsʉ, tina tíre Jesure yahua tare. ");
INSERT INTO gvc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ti ã ni yahuchʉ tʉhoro, Jesu sã mehne dohoriai samu, masa marienopʉ sʉho wahare. Jesu tópʉ to wahachʉ tʉhoa, masa ti ya macaripʉ jirina ta, mahapʉ tirore nʉnʉ ti wahcãre. ");
INSERT INTO gvc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tuhsʉ, sã wahã sʉri baharo tiro payʉ masare ñʉno, pja ñʉre tinare. Ã pja ñʉno tina mehne macaina dohatiinare noaina wahachʉ yoare. ");
INSERT INTO gvc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ñamichahapʉ sã to buheina tirore õ sehe nii: —Ñamichahapʉ jira. Õ masa marienopʉ jira. Ã jicʉ macaripʉ masare ti chʉhtire nuchʉ dutiga ti puhi tihti cjihtire —nimai sã tirore. ");
INSERT INTO gvc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu yʉhtire sãre: —Wahaea tjijaro tina. Mʉsa basita chʉare waga tinare —nire sãre. ");
INSERT INTO gvc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Cʉ̃ wamomaca pihtia pão curi, pʉaro wahi mehne jira sãre. Tí dihtare cjʉaja sã —ni yʉhtii sã. ");
INSERT INTO gvc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Tíre yʉhʉre na tahga mʉsa —nire sãre. ");
INSERT INTO gvc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","To ã nichʉ tʉhona na wahcãhi sã to cahai. Sã na sʉri baharo tja bui masare tiro duji dutire jʉna. Ti dujichʉ cinco pão curire, pʉaro wahire na, mʉanopʉ ñʉ mʉo, Cohamacʉre “Noana”, nire. Ã ninota pão curire nuha, sãre to buheinare ware. To ã wachʉ sã sehe tíre masare witii. ");
INSERT INTO gvc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ã jia jipihtina noano chʉ, yapi yʉhdʉa wahare. Ti yapi wahyorire doce pʉhʉse waro na cahmachu, wahpo dapoi sã to buheina. ");
INSERT INTO gvc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tói tíre chʉrina mʉa dihtare mari quihõchʉ cinco mil mʉa jire. Numia, macanacã cʉ̃hʉ jire. ");
INSERT INTO gvc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Baharo sãre to buheinare Jesu bʉcʉpariro pa bʉhʉsehe coapʉ pahãyu dutire masare to coha sitiro watoi. ");
INSERT INTO gvc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Coha siti tuhsʉ, tʉ̃cʉpʉ mʉja, Cohamacʉre sinino wahaha. Ñamine tói tiro cʉ̃irota jiha. ");
INSERT INTO gvc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tí pjaihta bʉcʉpariro dacho macai dohoria mehne pahãrucuna nimai sã. Wihnono tuaro ta, pahcõri bʉjʉa wahcã, dohoriare cjã sãare. ");
INSERT INTO gvc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wihnono tuaro to wãchʉ bohrea mʉja tahto pano Jesu co bui ducu tare sã cahapʉ jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sã cahapʉ to tachʉ ñʉna cui nii sã. Ã cuina sañurucumai sã: —Yariariro cjiro pjacʉ jira —ni sañurucumai sã. ");
INSERT INTO gvc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sã ã cuichʉ ñʉno Jesu õ sehe nire: —Ne yʉhʉre ñʉ cʉaena tjiga. Yʉhʉta jija —nire sãre. ");
INSERT INTO gvc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","To ã nichʉ tʉhoro Pedro õ sehe nire tirore: —Pʉhtoro, potocãta mʉhʉta jicʉ, co bui yʉhʉre mʉ cahapʉ ducu wahcã dutiga —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Taga —ni yʉhtire tiro sehe. To ã nichʉ Pedro dohoriapʉ jiriro co bui dʉcʉ sʉ Jesu cahapʉ ducu wahcãmare. ");
INSERT INTO gvc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wihnono tuaro to tachʉ ñʉno cuire tiro. Ã cuiro diha boraa wahamare. —Yʉhʉre yoadohoga pʉhtoro —ni sañurucure tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","To ã nichʉta to wamomacare ñaha: —Mahanocã wacũ tuara mʉhʉ yʉhʉre. ¿Dohseacʉ yʉhʉre wacũ tuaerajari mʉhʉ? —nire tiro Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","To ã niri baharo dohoriapʉ samu tare tina. Ti ã samu tari baharo wihnono yʉsʉ borare. ");
INSERT INTO gvc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ã jina sã to buheina dohoriapʉ jiina na tuhucua caha sʉ, Jesure ño payoi: —Potocãta mʉhʉ Cohamacʉ macʉnota jira —nii sã tirore. ");
INSERT INTO gvc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ã yoarina cjiri pahã, Genesare wama tiri yahpapʉ sʉi. ");
INSERT INTO gvc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tó macaina Jesure ñʉ masire. Ã masia tó cahai jiinare Jesu to wihirire yahu site pahñore. Ã ti yahu sitechʉ tʉhoina payʉ dohatiinare tiro cahapʉ na tare. ");
INSERT INTO gvc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Mʉ suhtiro dʉhtʉ caha dihtare sãre ñaha ñʉ dutiga —ni sinire tina Jesure. Ã jia to suhtirore ñaha ñʉinape tópeinata noaina wahare. ");
INSERT INTO gvc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ã yoa Jerusalẽ macaina, fariseo curua macaina, marine judio masare buheina mehne Jesu cahapʉ wihia, õ sehe ni siniture tirore: ");
INSERT INTO gvc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Dohse yoa mari ñʉchʉsʉma cjiripʉ ti yoa dutiriro seheta yoaerajari mʉ buheina sehe? Tina ti chʉhto pano ti dutiriro seheta wamo cosaerara —nire tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu õ sehe ni yʉhtire tinare: —¿Mʉsa sehe dohse yoana Cohamacʉ dutia sehere yoaerajari mʉsa? ¿Dohse yoana mari ñʉchʉsʉma cjiri panopʉ macaina ya dutia dihtare yoajari mʉsa sehe? ");
INSERT INTO gvc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Õ sehe nina Cohamacʉ: “Mʉsa pʉcʉsʉmare ño payoga”, nina. “Cʉ̃iro to pʉcʉsʉmare ñaare quiti dahreriro jiro tí buhiri paina ti wajãhtiro cjihto jirohca”, nina Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","To ã nipachʉta õ sehe ni dutira mʉsa sehe ti pʉcʉsʉmare yoadoho dutierana: Ti pʉcʉsʉmare ti waborire Cohamacʉ sehere wa dutira mʉsa. Ã ni buhemana mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ã buhena ti pʉcʉsʉmare ño payochʉ yoaerara mʉsa. Mʉsa ã yoana Cohamacʉ dutiare yʉhdʉrʉcana nina mʉsa, mari ñʉchʉsʉma cjiri panopʉ macaina ya dutia dihtare yoana. ");
INSERT INTO gvc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Masa ti baharo bʉhʉsehei ñano yoa cohtaina jira mʉsa. Cohamacʉ yare yahu mʉhtariro Isaia cjiro mʉsare potocãta yahu joaa tiha panopʉre: ");
INSERT INTO gvc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ahrina masa yʉhʉre noano durucupahta ti tʉhotuare yʉhʉre ne ño payoerara. ");
INSERT INTO gvc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ã jia yʉhʉre ti ño payoa ne yaba cjihti jierara. ‘Cohamacʉ ya dutia jira ahri’, ni mahño buhera ti ya buhea sehere”, ni joaa tiha Isaia cjiro —nire Jesu fariseo curua macainare, mari coyea judio masare buheina cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ã ni tuhsʉ to cahapʉ paina cʉ̃hʉre pjiroca, õ sehe nire: ");
INSERT INTO gvc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","—Yʉhʉre tʉhona taga. Tuhsʉ, yʉ niare noano tʉho ñahaga mʉsa. Mʉsa dʉserihi sãa sehe mʉsa chʉa sehe mʉsare buhiri tichʉ yoaerara. Mʉsa ñaa durucua sehe mʉsa dʉseri wijaa sehe mʉsare buhiri tichʉ yoara —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","To ã ni buheri baharo sã to buheina sehe tirore yahui: —Mʉ ã nichʉ tʉhoa fariseo curua macaina suaa nire —ni yahui sã tirore. ");
INSERT INTO gvc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tíre tʉhoro, õ sehe ni yʉhtire sãre: —Tina fariseo curua macaina toaa yucʉ yoaro sehe jira. Yʉ Pʉcʉ mʉano macariro jipihtia toaa yucʉre to toaerari cjirire nʉhcori mehneta cure, cohãnohca. Ãta yoarohca tinare. ");
INSERT INTO gvc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tinare ã ñʉnocahga mʉsa. Tina capari ñʉeraina ti ñʉ masieraro seheta ne Cohamacʉ yare masierara. Ã jia pichacapʉ wahaahca. Ã masierapahta paina masierainare buhe duamana. Ã jia tina, ti buheina cʉ̃hʉ soro jia buheare cahmaahca, capari ñʉeraina painare tʉã wahcã, jipihtina copapʉ ti borariro seheta —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","To ã nichʉ tʉhoro Pedro õ sehe nire: —Ahri quitire masa ti dʉseri wijaa quitire yahu namoga sãre tjoa —nire tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu õ sehe ni yʉhtire: —¿Ne, tʉhoerasinijari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Masa ti chʉare chʉchʉ tí ti dʉseroi sãahna. Ã jia ti pjaropʉ sãa sʉ, yʉhdʉ wijaa wahara. Wiho waro jira. Mari chʉa marine buhiri tichʉ yoaerara, Cohamacʉ to ñʉchʉ. ¿Ahrire masierajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Masa ti dʉseroi wijaa, ti durucua sehe ti tʉhotuapʉ tara. Ti durucua sehe ñaa jia masare buhiri tichʉ yoara. ");
INSERT INTO gvc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ñaa tʉhotua, masare wajãa, pairo namono mehne ñano yoaa, ñano yoaa numia mehne ñano yoaa, yacaa, mahñoa, masare ñano quiti dahrea masa ti tʉhotuapʉ tara. ");
INSERT INTO gvc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tí ñaa sehe masare buhiri tichʉ yoara. Wiho mejeta mari ñʉchʉsʉma cjiri ti yoaa tiriro cjiro seheta masa wamo cosaerapahta ti chʉchʉ tí masare buhiri tichʉ yoaerara —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ã ni buhe tuhsʉ, sãre sʉho wahare tjoa. Tiro wama tiri maca cahapʉ Sidõ wama tiri maca cahapʉ sʉi sã. ");
INSERT INTO gvc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sã tópʉ sʉchʉ Canaa yahpa macaricoro tói jiricoro Jesu cahapʉ wihiro, sañurucure: —Pʉhtoro, Davi panamino masare yʉhdʉchʉ yoahtiro, yʉhʉre pja ñʉga mʉhʉ. Yʉ macore yʉhdʉchʉ yoabasaga mʉhʉ. Yʉ maco watĩno to cohtotaricoro, ñabiaro yʉhdʉra ticoro —ni sañurucure to pocoro. ");
INSERT INTO gvc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","To ã nipachʉta Jesu ticorore yʉhtierare. To ã yoachʉ ñʉna sã to buheina sehe tirore õ sehe nimai: —Waha dutiga ticorore. Nu cariboro bisica —nimai sã. ");
INSERT INTO gvc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sã ã nichʉ tʉhoro Jesu õ sehe ni yʉhtire ticorore: —Israe masare Cohamacʉre masieraina dihtare yoadoho dutiro warocare yʉ Pʉcʉ yʉhʉre —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","To ã nipachʉta Jesu dahpori cahai na tuhcua caha sʉre ticoro tirore ño payoro. —Pʉhtoro, yoadohoga yʉhʉre —nire ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu õ sehe ni yʉhtire ticorore: —Õ sehe jira ahri: Wahmanore wʉhʉ pʉro pohna ya chʉare dieyacãre yʉ wa mʉhtachʉ tó wahaerara. (Israe masa yare pa yahpa macainare yʉ wa mʉhtachʉ tó wahaerara) —nire Jesu ticorore piti dahre yahuro. ");
INSERT INTO gvc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Ã tjira pʉhtoro. Ã jipachʉta dieyacã cʉ̃hʉ wʉhʉ pʉro mesa docai ti chʉ site boroare chʉ cohtara tinacã cʉ̃hʉ. (Pa yahpa macaricoro yʉ jipachʉta yʉhʉ cʉ̃hʉre yoadoho masina mʉhʉ) —ni yʉhtire ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","To ã nichʉ tiro õ sehe ni yʉhtire: —Ne numino, mʉhʉ yʉhʉre tuaro wacũ tuara. Mʉ cahmano seheta ã waharohca —nire Jesu ticorore. To ã nichʉta dóihta noaricoro wahare to macono. ");
INSERT INTO gvc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ã ni tuhsʉ sãre sʉho waha, Galilea wama tiri bʉcʉpariro dʉhtʉ cahapʉ sʉho sʉre tjoa. Sʉ, mahadʉcã tʉ̃cʉre mʉja, tʉ buipʉ dujire. ");
INSERT INTO gvc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tói to jichʉ payʉ masa tini masierainare, capari ñʉerainare, cʉ̃ bʉhʉsehe ñano dahporo tiinare, durucu masierainare, payʉ paina dohatiinare tiro cahapʉ na wihire masa. Na wihi tuhsʉ Jesu dahpori cahai duhu cũre tina. Ti ã duhu cũri baharo noaina wahachʉ yoare Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","To ã yoachʉ ñʉa masa ñʉ cʉaa wahare. Durucu masieraina ti durucuchʉ ñʉa, cʉ̃ bʉhʉsehe ñano dahporo tiina noaina ti wahachʉ ñʉa, tini masieraina ti tinichʉ ñʉa, capari ñʉeraina ti ñʉchʉ ñʉa, cʉaa wahare tina. Ã jia õ sehe nire: —Israe masa mari pʉhtoro, Cohamacʉ tuariro, noariro jira —ni ño payore tina Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","To ã yoari baharo Jesu sãre to buheinare to cahapʉ pjiroca, õ sehe nire: —Ahrina masa yʉhʉ mehne tia dacho waro ji tuhsʉra. Ã yoa tinare ti puhi mariahna. Ti puhi mariachʉ ñʉcʉ tinare pja ñʉja. “Tinapʉ jʉca baaina, mahai borari”, nicʉ tinare chʉa marieno ti wʉhʉsepʉ waha duti duaeraja. Ã jicʉ tinare puhi wa duaja —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","To ã nichʉ sã to buheina tirore sinitu ñʉi: —¿Dohse yoa mari õre masa marienopʉre pãore boca wabocari mari? —nii sã tirore. ");
INSERT INTO gvc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Nohope curi pão curire cjʉajari mʉsa? —nire Jesu. —Siete curi, wahi cʉ̃hʉre mahainacã cjʉaja —ni yʉhtii sã. ");
INSERT INTO gvc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sã ã nichʉ tiro masare yahpai duji dutire. ");
INSERT INTO gvc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tuhsʉ siete pão curire, wahicã cʉ̃hʉre na, Cohamacʉre “Noana”, nire. Ã ninota pão curire nuha, sãre to buheinare ware. Ã jina sã sehe tí chʉare masare witii. ");
INSERT INTO gvc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ã jia masa tíre chʉ, yapi yʉhdʉa wahare. Ti yapi wahyorire siete pʉhʉse waro wahpo dapoi sã. ");
INSERT INTO gvc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tói chʉrinare mʉa dihtare mari quihõchʉ cuatro mil waro mʉa jire. Numia, macanacã cʉ̃hʉ jire. ");
INSERT INTO gvc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ti ã chʉ tuhsʉchʉ Jesu masare waha dutire. Ã ni tuhsʉ dohoriapʉ samu, Magadán wama tiri yahpapʉ sãre sʉho sʉre. ");
INSERT INTO gvc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ã yoa fariseo curua macaina, saduceo curua macaina mehne Jesu cahapʉ wihire. To ñano yoachʉ ñʉ duamare tirore yahusã duaa. Ã jia tina tirore Cohamacʉ tuaa mehne yoa ño dutimare to masierachʉ ñʉ duaa, “Cohamacʉ warocariro jierara”, nia taa. ");
INSERT INTO gvc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ti ã yoa dutichʉ Jesu õ sehe ni yʉhtire tinare: —Ñamichahapʉ sʉ̃ sãachʉ to noano sohãchʉ ñʉna “Noari ñami jirohca”, nina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tuhsʉ, bohrearo ñichuri dacho to jichʉ ñʉna “Coro tarohca”, nina mʉsa. Ã noano masiina jipanahta Cohamacʉ tuaa mehne mʉsare yʉ yoa ñochʉ ñʉpanahta ne tíre noano masierara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mipʉ macaina ña yʉhdʉina Cohamacʉre cahmaeraina Cohamacʉ tuaa mehne yʉ yoa ñochʉ ñʉ duamana. Yoa ñosi yʉhʉ. Cohamacʉ yare yahu mʉhtariro cjiro Jona cjiro to dohse waharirore masi tuhsʉre mʉsa. Tí dihtare ñoihtja mʉsare —ni yʉhtire Jesu. Ã ni yahu tuhsʉ sʉho wahaa wahare tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bʉcʉparirore sã pahãna, pãore bo pahã tari jihti sã. ");
INSERT INTO gvc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ã jiro Jesu sãre õ sehe ni yahure: —Noano yoanohbʉ. Fariseo curua macaina, saduceo curua macaina ti pão bʉcʉarore ñʉna noano yoaga. Cua nina tí —ni yahure. ");
INSERT INTO gvc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","To ã nichʉ tʉhona tʉho wisia wahana, sã basi tíre õ sehe ni durucui: —Mari pãore mari na taerachʉ ñʉno ã nipʉcʉ tiro —nimai sã, sã basi. ");
INSERT INTO gvc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sã ã nirire masino, sãre õ sehe ni siniture: —¿Dohse yoana pão sehere wacũjari mʉsa? Mahanocã waro yʉhʉre wacũ tuara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Masierasinijari mʉsa? ¿Cinco mil mʉare cinco pão curire yʉ nuha warire numia cʉ̃hʉre yʉ warire wacũerajari mʉsa? ¿Ti yapi wahyorire doce pʉhʉse waro mʉsa wahpo daporire wacũerajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ã jicʉ siete pão curire nuha, cuatro mil mʉare yʉ warire numia cʉ̃hʉre yʉ warire wacũerajari mʉsa? ¿Nohope pʉhʉse waro mʉsa wahpo daporire wacũerajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ã jina pão bʉcʉarore yʉ yahuchʉ dohse yoana noano tʉhoerari mʉsa? Ã nicʉ pão warore nicʉ nieraja. Fariseo curua macaina, saduceo curua macaina ti pão bʉcʉarore ñʉna noano yoaga. Cua nina tí —ni yahure sãre tiro. ");
INSERT INTO gvc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","To ã ni yahuchʉpʉ sã masii. “Pão bʉcʉaro” nino, pão warore nino nierare. Ã nino fariseo curua macaina, saduceo curua macaina ti buheare nino niri jimare sãre. “Ti ya buheare tʉhoena tjiga”, nino nire. ");
INSERT INTO gvc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ã yoa Jesu mehne wahana, Cesarea Filipo wama tiri maca cahai jia macaripʉ sʉi sã. Tuhsʉ, macapʉ sã sʉri baharo Jesu sãre to buheinare siniture: —¿Diro baro jicari yʉhʉ masa yʉhʉre ti tʉhotuchʉ? —ni siniture tiro. ");
INSERT INTO gvc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—“João masare bautisariro jira”, nina mʉhʉre. Paina “Elia jira”, nina. Ã yoa paina sehe tjoa, “Jeremía jiboca o pairo Cohamacʉ yare yahu mʉhtariro cjiro jiboca”, nina —ni yʉhtii sã tirore. ");
INSERT INTO gvc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Mʉsa sehe mʉsa tʉhotuchʉ diro baro jicari yʉhʉ? —ni sinitu ñʉre tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Pedro õ sehe ni yʉhtire: —Mʉhʉ Cristo Cohamacʉ warocariro jira. Cohamacʉ catiriro waro macʉnota jira mʉhʉ —ni yʉhtire Simo Pedro. ");
INSERT INTO gvc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","To ã nichʉ tʉhoro Jesu tirore õ sehe nire: —Simo Jona macʉno mʉhʉ wahcheriro jira. Õ sehe ni yʉhʉre mʉ yʉhtichʉ masa ti ni yahuri jierara. Yʉ Pʉcʉ mʉano macariro sehe tíre mʉhʉre masichʉ yoare. ");
INSERT INTO gvc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mʉhʉre niita nija. Mʉhʉ Pedro wama tiriro jira. (Pedro nino, “tãca”, nino nina.) Ahri tãa wapa bui pjiri wʉhʉre yʉ yoaboriro seheta yʉ yaina sehere pjiri curua jichʉ yoaihca yʉhʉ. Ã jia watĩno to yaina mehne ne yʉ yainare yʉhdʉrʉcasi. Ã jia yʉ yaina ne pichacapʉ wahasi. ");
INSERT INTO gvc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mʉano macariro mari pʉhtoro to sʉho jiro macari sawire mʉhʉre waihtja. Ã jicʉ ahri yahpare ñaare mʉ yoa dutierachʉ mʉanopʉ cʉ̃hʉre yoa dutisi. Ahri yahpare noaare mʉ yoa dutichʉ mʉanopʉ cʉ̃hʉre yoa dutia jiahca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","To ã niri baharo sãre to buheinare õ sehe nire: —Yʉhʉre “Cristo jira tiro”, ni yahu sitesiniena tjiga painare —ni dutire sãre. ");
INSERT INTO gvc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tí pjata Jesu sãre to buheinare noano yahu pahño dʉcare: —Jerusalẽpʉ yʉhʉre waharo cahmana mipʉre. Tópʉ mari coyea judio masa bʉcʉna, sacerdotea pʉhtoa, marine judio masare buheina cʉ̃hʉ yʉhʉre ñano yoaahca. Yʉhʉre wajãahca. Ãta ñano yʉhdʉro cahmana yʉhʉre. Ã jicʉ tia dacho wahaboroi masa wijaaihca —ni yahure sãre tiro. ");
INSERT INTO gvc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","To ã nichʉ tʉhoro Pedro sehe pa sehe curerocã Jesure narʉcʉ sʉ, tirore õ sehe nire: —Pʉhtoro, mʉ nino sehe ã wahaero tjijaro. Mʉhʉre tina wajãea tjijaro —nimare tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","To ã nichʉ tʉhoro Jesu majarerʉca, tirore õ sehe nire: —Satana yoaro sehe durucui nina mʉhʉ. Ã nii tjiga. Mʉ tʉhotua masa ya jira. Cohamacʉ ya jierara. Ã jicʉ yʉ yoahtore dʉcata duara mʉhʉ —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","To ã niri baharo sãre yahure: —Cʉ̃iro yʉ yairo ji duaro, to cahmano yoa duamarine duhunocanohca. Crusapʉ yʉ ñano yʉhdʉhtiro seheta yʉ yairo to jiri buhiri ñano yʉhdʉparota yʉhʉre duhusi. Ã jiro yʉ yare yoarucuriro jirohca. ");
INSERT INTO gvc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Masʉno yʉhʉre wacũno marieno to mʉ sʉro to cahmano seheta yoariro pichacapʉ waharohca. Tuhsʉ, masʉno yʉ yare ã yoarucuriro jipihtia dachoripe yʉhʉ mehne mʉanopʉ jirucurohca tiro. ");
INSERT INTO gvc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Cʉ̃iro masʉno ahri yahpa macaare jipihtiare cjʉariro Cohamacʉre cahmaeraro pichacapʉ waharo, yabare wapatajari tiro? Ã jiriro ne wapataerara. Pichacapʉ to wahachʉ ne dohse wapa wiohto basioerara. ");
INSERT INTO gvc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉhʉ masʉno Cohamacʉ warocariro yʉ yaina anjoa mehne ahri yahpapʉ tjua tacʉ yʉ Pʉcʉ to si sitea mehne tjua tacʉ jipihtina masare ti ñaa yoari buhiri buhiri dahreihtja. Noaa sehere ti yoachʉ noano yoaihtja tinare. ");
INSERT INTO gvc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Potocã mʉsare yahuihtja. Cãina mʉsa õpʉre jiina mʉsa yariahto pano yʉhʉre yʉ tachʉ yʉ pʉhto sãachʉ cʉ̃hʉre ñʉnahca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ã yoa seis dachori baharo Jesu Pedrore, Santiagore to bahʉro João cʉ̃hʉre mʉadʉ tʉ̃cʉpʉ tina dihtare pji mʉjare. ");
INSERT INTO gvc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mʉanopʉ ti sʉri baharo ti ñʉrocaroi to pjacʉre cohtotaha. To wʉhdʉa sʉ̃ dacho macariro yoaro sehe si siteha. Tuhsʉ, to suhtiro buhriaro yoaro seheta yehsea tiha. ");
INSERT INTO gvc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","To ã cohtotachʉ Jesu Moise cjiro, Elia cjiro mehne ti sʉhʉduchʉ ñʉha tina tiaro Jesu buheina. ");
INSERT INTO gvc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ã jiro Pedro Jesure õ sehe nimaha: —Pʉhtoro, mari õi jichʉ noa duara. Mʉ cahmachʉ tia wʉhʉcã yoaihtja. Mʉ ya wʉhʉcã, Moise ya wʉhʉcã, Elia ya wʉhʉcã yoaihtja —nimaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","To ã nino watoi me curua noano si sitea me ti bui duji pja wihiha. To ã duji pja wihichʉta, me curua watoi õ sehe nino coa taha: —Ahriro yʉ macʉ yʉ cahĩriro jira. Tiro mehne wahcheja. Tirore tʉhoga —nino coa taha. ");
INSERT INTO gvc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ã nino coa tachʉ tʉhoa to buheina cʉaa waha, yahpai doca caha sʉha. ");
INSERT INTO gvc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ti ã wahari baharo Jesu tina cahapʉ sʉ, tinare bʉa carerota, õ sehe niha: —Wahcãrʉcaga mʉsa. Mipʉre mʉsa ñʉrire, mʉsa tʉhori cʉ̃hʉre cuiena tjiga —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","To ã nichʉ tina ñʉroca, Jesu dihtare ñʉha. Ti ñʉrina cjiri sehe marieraha jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ã jia tʉ̃cʉpʉ ti duji tachʉ Jesu tinare tuaro mehne õ sehe niha: —Michapucacã yʉ ã waharire painare yahuena tjiga. Yʉhʉ masʉno Cohamacʉ warocariro yʉ yaria masa wijaari baharo tíre painare yahuga mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","To ã niri baharo Pedro cʉ̃hʉ tirore õ sehe ni sinituha: —“Cristo masare yʉhdohtiro to tahto pano Eliare ta mʉhtano cahmana”, nina marine judio masa buheina. ¿Dohse jiro baro ã nijari tina? —ni sinituha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu õ sehe ni yʉhtiha: —Potocã tjira. Eliare ta mʉhta dutire Cohamacʉ, jipihtiare cahno mʉhtahtirore. ");
INSERT INTO gvc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Õ sehe nicʉ mʉsare nii nija. Elia wihi tuhsʉre. To ã wihipachʉta tina tirore ne ñʉ masierare. Ã jia ti dohse yoa duaro ñano yoari jire tirore. Ãta yoaahca yʉhʉ cʉ̃hʉre. Yʉhʉ masʉno Cohamacʉ warocariro jija. Ti ã yoachʉ ñano yʉhdʉihca yʉhʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","To ã ni yahuchʉ tina noano tʉhoha. “Elia” nino, João bautisarirore nino niha. Tíre masiha tina. ");
INSERT INTO gvc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ã yoa payʉ masa cahapʉ ti duji tachʉ ñʉno cʉ̃iro mʉno Jesu cahapʉ sʉ, na tuhcua caha sʉre. ");
INSERT INTO gvc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pʉhtoro, yʉ macʉcãre pja ñʉga. Tiro ñama yaria mʉnare dohatiriro jira. Ã jiro tiro ñabiaro yʉhdʉra. Payʉ tahari pichacapʉ bora sʉ caha mʉjana tiro. Cãa tahari diapʉ bora ñoja mʉjana. ");
INSERT INTO gvc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ã jicʉ mʉ buheina cahapʉ tirore na sʉmahi. Tina tirore noariro wahachʉ yoa masierare —nire tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu õ sehe ni yʉhtire: —Mipʉ macaina, mʉsa ñaa buhiri tiina jira. Yʉhʉre ne wacũ tuaerara. Yoabiari pja mʉsare buhemaja yʉhʉ. ¿Noho puro yoari pja yʉhʉre mʉsa caribobocari? Tirore na tahga yʉhʉre —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ã jiro watĩnore to tuhtichʉta watĩno sehe masʉnocãre sãariro cjiro wahaa wahare. To ã wahari baharocãta noariro wahare tiro. ");
INSERT INTO gvc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Baharo sã to buheina sã sahsero jina Jesure õ sehe ni sinitui: —¿Dohse yoana sã sehe ahriro sehere watĩnore cohã masierari, mʉ tʉhotuchʉ? —ni sinitui sã. ");
INSERT INTO gvc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu õ sehe ni yʉhtire: —Yʉhʉre mahanocã wacũ tuara mʉsa. Potocã mʉsare yahuita nija. Mostaza yapacã mahari yapacã jiparota duropʉ pjidʉ wahara. To ã wahariro seheta Cohamacʉre wacũ tuana õ sehe wahachʉ yoa masinahca mʉsa. Ahdʉ tʉ̃cʉre “Sohõpʉ wahaga”, mʉsa nichʉ, waharohca. Cohamacʉre tó seheta wacũ tuana, jipihtiare yoa masina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wiho mejeta ahriro baro watĩnore mʉsa cohã duana Cohamacʉre tuaro sinino cahmana mʉsare. Ã yoa duana chʉ duhuro cahmana mʉsare Cohamacʉre sinina tana —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ã yoa Galilea yahpapʉ sã tinichʉ, Jesu sãre õ sehe ni yahure: —Yʉhʉ masʉno Cohamacʉ warocariro jija. Masa yʉhʉre ñaha, painapʉre yʉhʉre waahca. ");
INSERT INTO gvc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ã ti wari baharo yʉhʉre wajãahca tina. Ã ti wajãricʉ tia dacho wahaboroi masa wijaaihca —ni yahure tiro sãre. To ã ni yahuchʉ tʉhona tuaro cahyai sã. ");
INSERT INTO gvc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ã jina Capernaupʉ sã sʉchʉ, Cohamacʉ wʉhʉ macaa cjihtire wapa na cohtaina Pedro cahapʉ sʉ, tirore õ sehe ni sinitu ñʉre: —¿Mʉsare buheriro Cohamacʉ wʉhʉ macaa wapa cjihtire wapajari tiro? —ni siniture tina. ");
INSERT INTO gvc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Wapara tiro —ni yʉhtire Pedro. To ã niri baharo wʉhʉpʉ to sãachʉ Jesu õ sehe ni sinitu mʉhtare Pedrore: —¿Simo, dohse ni tʉhotujari mʉhʉ? ¿Ahri yahpa macaina pʉhtoa yabaina sehere wapa cahmajari, mʉ tʉhotuchʉ? ¿Tina mehne macainare wapa cahmajari? ¿O pa yahpa macaina sehere wapa cahmajari, mʉ tʉhotuchʉ? —ni siniture tiro Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Pa yahpa macaina sehere wapa cahmana —ni yʉhtire Pedro. To ã nichʉ Jesu õ sehe ni yahure: —Ã jiro pʉhtoro to ya yahpa macainare wapa cahmaerara. ");
INSERT INTO gvc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ã jipachʉta wapa na cohtainare suachʉ yoa duaeraja mari. Ã jina wapanahca tinare. Bʉcʉpariropʉ wahaga. Tópʉ sʉ, yohgari canore doca ñoga. Ã yoacʉ wahi mʉhʉre chʉrirore tʉãga. To dʉseropʉ niñeru tʉre bocaihca mʉhʉ. Tí tʉ quihõno wapa tiri tʉ jirohca. Yʉhʉre, mʉhʉ cʉ̃hʉre Cohamacʉ wʉhʉ macaina ti wapa cahmachʉ noano quihõno mʉ sʉrohca tí tʉ. Tí tʉre bocacʉ mari wapamonore wapai wahaga —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tí pjare sã to buheina Jesu cahapʉ sʉ, õ sehe ni sinitui tirore: —¿Mʉano macariro pʉhtoro to sʉho jiropʉre sã mehne macariro diro baro sehe wahabocari pʉhtoro? —ni sinitui sã. ");
INSERT INTO gvc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sã ã nichʉ Jesu nijinocãre pjiroca, tirocãre sã panoi duhu dapore. Duhu dapo tuhsʉ, sãre õ sehe nire: ");
INSERT INTO gvc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Potocã mʉsare yahu bahrañoihtja. Ahrina macanacã Cohamacʉre ti pʉhtoro waro tʉhotura. Ã jina mʉsa cʉ̃hʉ pano mʉsa tʉhotumari cjirire cohtotaerana, tinacã yoaro sehe tʉhotuerana mʉano macariro pʉhtoro to sʉho jiropʉre wahasi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ã jiro mʉano macariro pʉhtoro to sʉho jiropʉre niji siaroca yoariro painare yʉhdʉrʉca duaerariro ahriro nijinocã yoaro sehe tʉhoturirota paina bui pʉhtoro wahara. ");
INSERT INTO gvc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ã jina yʉ yare yoana tana õ sehe jiinacãre cahmana, yʉhʉ cʉ̃hʉre cahmana mʉsa —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ã ni yahu tuhsʉ, tinare õ sehe ni yahu namore: —Ahrirocã sehe jiriro yʉhʉre wacũ tuarirocãre yahuihtja mʉsare. Pairo ahrirocã sehe jirirore ñaare yoa dutiro tiro ñabiaro yʉhdʉrohca. Cʉ̃irore to wamʉare pjiria tãcare dʉhte yo, pjiri mapʉ tirore ti cohãchʉ ñano wahaboa tiro. Ã jiro ahrirocã sehe jirirore ñaare yoa dutiriro tiro sehe pjiri mapʉ ti cohãriro yʉhdoro ñano yʉhdʉrohca. ");
INSERT INTO gvc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Masare ñaare yoachʉ yoaa jira. Tíre yoaa ahri yahpa macaina ñano yʉhdʉra. Ñaare yoarucura masa. Ti ã yoachʉ tinare ñaare yoachʉ yoaina sehe ñabiaro yʉhdʉahca. ");
INSERT INTO gvc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Mʉ wamomaca mehne ñano yoacʉ tí wamomacare mʉ dʉte cohãboro seheta tí mʉ ñaa yoaa sehere duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Tópʉre ne pichaca yatierara. Mʉ wamomacare mʉ cohãchʉ tí si dihta butiboa. Tuhsʉ, mʉhʉ sehe ã si jipaihta baharo Cohamacʉ mehne jiihca. Pʉa wamomaca mehne pichacapʉ wahacʉ mʉ ã wahachʉ ñaa yʉhdʉaboa mʉhʉre. Ã jicʉ tí mʉ ñaa yoaa sehere duhuga. ’Mʉ dahporo mehne ñano yoacʉ tí dahporo cʉ̃hʉre mʉ dʉte cohãboro seheta tí mʉ ñaa yoaa sehere duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Tópʉre ne pichaca yatierara. Mʉ dahporore mʉ cohãchʉ tí si dihta butiboa. Tuhsʉ, ã si jipaihta baharo Cohamacʉ mehne jiihca. Pʉa dahporo mehne pichacapʉ wahacʉ mʉ ã wahachʉ ñaa yʉhdʉaboa mʉhʉre. Ã jicʉ tí mʉ ñaa yoaa sehere duhuga. ");
INSERT INTO gvc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","’Mʉ capariaca mehne ñano yoacʉ tiare orewe mʉ cohãboro seheta tí mʉ ñaa yoaa sehere duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Tópʉre ne pichaca yatierara. Tiare mʉ cohãchʉ tia dihta butiboa. Cʉ̃ bʉhʉsehe capariaca mariapaihta baharo Cohamacʉ mehne jiihca. Pʉa capariaca mehne pichacapʉ wahacʉ mʉ ã wahachʉ ñaa yʉhdʉaboa mʉhʉre. Ã jicʉ tí mʉ ñaa yoaa sehere duhuga —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ã ni tuhsʉ, tinare õ sehe ni yahu namore: —Ne, ahrinacãre macanacãre ñʉ yabiena tjiga. Mʉsare niita nija yʉhʉ. Tinacãre ñʉ wihboina anjoa mʉanopʉ jiina sehe yʉ Pʉcʉ cahapʉ ã jirucura. ");
INSERT INTO gvc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉ pichacapʉ wahaborinare yʉhdʉchʉ yoai tai nii yʉhʉ —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ã ni tuhsʉ to tʉhotua mehne õ sehe ni quiti dahre buhere sãre: —Ovejare ñʉ wihboriro cien ovejare cjʉariro cʉ̃iro oveja butia wahachʉ õ sehe yoarohca tinare ñʉ wihboriro sehe. Paina ovejare noventa y nueve ovejare ti chʉri campopʉ duhu dapo, butirirore macano waharohca. ");
INSERT INTO gvc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Potocã niita nija mʉsare. Tirore bocaro wahcherohca tiro. Paina noventa y nueve dʉhsaina mehne wahchera tiro. Tinare to wahcheriro yʉhdoro butiriro sehere bocaro tuaro wahcherohca. ");
INSERT INTO gvc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tó seheta ñʉ wihboriro oveja to butichʉ cahmaeraro seheta mʉsa Pʉcʉ mʉano macariro ahrina wiho jiina cʉ̃hʉre pichacapʉ ti wahachʉ cahmaerara —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ã ni tuhsʉ õ sehe ni yahu namore: —Mʉ coyeiro mʉhʉre ñano to yoachʉ tiro mehne sʉhʉdui wahaga. Mʉsa sahsero tíre sʉhʉduga. Mʉ ã yoachʉ tiro mʉhʉre tʉhoboca. To tʉhochʉ “Mʉhʉre ne pari turi õ sehe yoasi yʉhʉ”, to nichʉ mʉ coyeirore pari turi piti tii nica mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mʉhʉre to tʉho duaerachʉ pinihta cʉ̃iro mehne waha duacʉ o pʉaro mehne waha duacʉ tinare piti ti wahcã, pari turi tirore sʉhʉduna wahaga. Mʉsa ã yoachʉ mʉsare pʉaro o tiarore to tʉhoeraputiachʉ ñʉna paina Jesu yainare tirore yahusãga, Cohamacʉ yare ti joari pũ to niriro seheta. ");
INSERT INTO gvc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ã jina mʉsa mehne macaina cʉ̃hʉre to tʉho duaerachʉ jipihtina Jesu yaina cahmachuinare yahusãna wahaga. Ã jina Jesu yaina cahmachuinare to tʉho duaerasinichʉ ñʉna Cohamacʉre cahmaerarirore mʉsa yoaboriro sehe yoaga tirore. Wapa na cohtarirore mʉsa yoaboriro sehe yoaga tirore. ");
INSERT INTO gvc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Potocã mʉsare niita nija. Ahri yahpai mʉsa Jesu yaina ñaare mʉsa yoa dutierachʉ mʉanopʉ cʉ̃hʉre yoa dutisi. Ahri yahpai mʉsa noaare yoa dutichʉ mʉanopʉ cʉ̃hʉre yoa dutia jiahca. ");
INSERT INTO gvc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Pari turi mʉsare yahuihtja ahrire: Mʉsa pʉaro Cohamacʉre sinichʉ, mʉsa pʉaro mʉsa sinirire cʉ̃no potori mʉsa tʉhotuchʉ yʉ Pʉcʉ mʉano macariro tíre yoarohca. ");
INSERT INTO gvc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pʉaro o tiaro yʉ yaina yʉ yare yoahtina cjihti ti cahmachuchʉ yʉhʉ tina mehne jija —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Baharo Pedro Jesu cahapʉ sʉ, õ sehe ni siniture: —¿Pʉhtoro, yʉ coyeiro mʉ yairo payʉ tahari yʉhʉre ñano to yoachʉ ñʉcʉ nohope tahari tíre boihcari yʉhʉ? ¿Siete tahari boihcari yʉhʉ? —ni siniture Pedro. ");
INSERT INTO gvc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu õ sehe ni yʉhtire: —Siete tahari dihta mʉhʉre pairo to ñano yoarire mʉ bochʉ tó wahaerara. Payʉ tahari mʉhʉre ñano to yoachʉ cʉ̃hʉre boga. ");
INSERT INTO gvc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Mʉano macariro masa bui pʉhtoro to sʉho jiro ahri quiti yoaro sehe jira. Jipihtina masa bui pʉhtoro jiriro tirore dahra cohtainare tirore wapamoinare wapa pahño duti dutimaha. ");
INSERT INTO gvc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ti wapamori cjirire to quihõ dʉcachʉ, tirore dahra cohtaina sehe pjíro wapamorirore tiro cahapʉ na taha. Wapamoriro pjibiaro wapamoha to pʉhtorore. ");
INSERT INTO gvc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ã jiro tiro to wapa masierachʉ ñʉno to pʉhtoro tirore, to namonore, to pohnare cahamaca sõ, tinare painare dua dutimaha. Ã yoa jipihtia to cjʉaa cʉ̃hʉre dua duamaha, to wapamonore wapa dutiro. ");
INSERT INTO gvc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","To ã dua dutichʉ pjíro wapamoriro sehe na tuhcua caha sʉ, to pʉhtorore tuaro siniha: “Pʉhtoro, yʉhʉre pja ñʉcʉ cohtasiniga. Mʉhʉre wapa pahñoihca”, niha tiro to pʉhtorore. ");
INSERT INTO gvc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","To ã nichʉ tʉhoro, tirore pja ñʉno to wapamorirore ãta bonocaha. ");
INSERT INTO gvc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","To ã yoari baharo pjíro wapamoriro cjiro sehe waha, pairo dahra cohtarirore tirore mahanocã wapamorirore boca sʉha. Ã boca sʉro wamʉa ñahaha tirore. “Yʉhʉre mʉ wapamonore wapa bahrañoga”, niha tiro tó mehne macarirore to yoaro sehe dahra cohtarirore. ");
INSERT INTO gvc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","To ã nichʉ pairo dahra cohtariro sehe na tuhcua caha sʉ, tirore tuaro sinimaha. “Yʉhʉre pja ñʉcʉ mahanocã cohtasiniga. Mʉhʉre wapa pahñoihca”, nimaha pairo dahra cohtariro tirore. ");
INSERT INTO gvc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","To ã ni sinipachʉta tó mehne macariro tirore yʉhtieraha. Tuhsʉ, tiro pairo dahra cohtarirore peresu yoa dutiha. Pʉ to wapa pahñochʉpʉ wiorohca tirore. ");
INSERT INTO gvc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pjíro wapamoriro cjiro mahanocã wapamorirore to ñano yoachʉ ñʉ, susini, paina dahra cohtaina sehe ti pʉhtorore yahusãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ti ã ni yahusãchʉ tʉhoro ti pʉhtoro ti yahusãrirore pjiroca, õ sehe niha: “Mʉhʉ ñabiariro jira. Mʉ yʉhʉre tuaro sinichʉ mʉ wapamorirore bo pahñomahi yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mʉhʉre yʉ ã yoapachʉta mʉhʉ sehe mʉhʉre wapamorirore boerayuhti. Mʉ wapamoriro sehere yʉ boriro seheta tiro mʉhʉre to wapamoriro cʉ̃hʉre mʉ bochʉ noabiaboa. ¿Dohseacʉ tirore pja ñʉerari mʉhʉ ã yoacʉ?” niha to pʉhtoro tirore. ");
INSERT INTO gvc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ã nino tuaro sua, peresu yoaha tirore dahra cohtarirore. Pʉ to wapa pahñochʉpʉ wiorohca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ã ni tuhsʉ, õ sehe ni ahri quitire yahu batoare: —Tó seheta yoarohca yʉ Pʉcʉ mʉano macariro mʉsare. Mʉsa jipihtina mʉsa coyea mʉsare ti ñano yoarire noano mʉsa bo pahñoerachʉ tiro mʉsare buhiri dahrerohca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tíre to ã ni yahuri baharo tiro Galileai jiriro Judea yahpapʉ sãre sʉho wahare. Jordão pa bʉhʉsehe coapʉ sʉi sã. ");
INSERT INTO gvc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tópʉ sã wahachʉ payʉ masa sãre nʉnʉ ti wahcãre. Tina mehne macainare dohatiinare noaina wahachʉ yoare tiro. ");
INSERT INTO gvc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ã yoa cãina fariseo curua macaina Jesure yahusã duaa, ñano to durucuchʉ tʉho duaa, tirore õ sehe ni sinitu ñʉre: —¿Mari cahmano seheta mari namore cohãchʉ noabocari? ¿Mari dutia sehe tó seheta yoa dutijari, mʉ tʉhotuchʉ? —ni sinitu ñʉre tina. ");
INSERT INTO gvc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu õ sehe ni yʉhtire: —¿Cohamacʉ yare ti joari pũi ne ahrire buherasiniri mʉsa? Õ sehe ni joaa tiha: “Wahmanopʉre ahri yahpare bajuamehneriro mʉno, numino cʉ̃hʉre yoaha”, ni joaha. ");
INSERT INTO gvc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tuhsʉ õ sehe ni joa namoha: “Mʉno to pʉcʉsʉmare cohã wija, to namono mehne jirohca. Ã jia tina pʉaro jipahta cʉ̃ pjacʉ yoaro seheta jira”, ni joa namoa tiha. ");
INSERT INTO gvc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ã jia tina pʉaro yoaro sehe jierara. Cʉ̃ pjacʉ yoaro sehe jia nina. Cohamacʉ to wamomaca dʉhte dutiina jira. Ã jia tinare duhueraro cahmana —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","To ã nichʉ fariseo curua macaina õ sehe ni siniture tjoa: —Mʉ ã ni yahupachʉta õ sehe ni joaa tiha Moise cjiro sehe: “Mʉ namore cohã duacʉ papera pũi tíre joaga. Ã joacʉ tí pũre mʉ namore mʉ wari baharo ticorore cohã masina mʉhʉ”, ni joaa tiha Moise cjiro. ¿Mʉ nino sehe jipachʉta Moise cjiro sehe dohsearo õ sehe ni joari? —ni sinitu namore tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu õ sehe ni yʉhtire tinare: —Cohamacʉre mʉsa ñʉchʉsʉma ti tʉho duaerachʉ ñʉno ti namosãnumiare ti cohãchʉ, “Ãta yoawahnojaro”, ninocaa tiha Moise. To ã nipachʉta wahmanopʉre ahri yahpare ã jierare. ");
INSERT INTO gvc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mʉsare niita nija. Masʉno to namono to ñano yoaerapachʉta ticorore cohãno, pacorore namo tiro, tiro pacoro mehne ñano yoaro nina. Tuhsʉ, ahriro to cohãricorore namo tiriro cʉ̃hʉ ticoro mehne ñano yoariro jira —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","To ã nichʉ tʉhona, sã to buheina sehe tirore õ sehe nii: —Tó sehe mʉno to namono mehne ti cahma cohãerachʉ mari sehere mari namo tierachʉ noaboca —nii sã. ");
INSERT INTO gvc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu õ sehe ni yʉhtire: —Mʉsa nino seheta jira. Ã jiro cãinare namo ti dutierara Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mʉare namo ti dutieraa cãa jira. Cãina mʉa numiare cahmaeraina masa bajuara. Paina mʉa masa ti wapãri tõhoca ti warina sehe namo ti masierara. Paina mʉa mʉano macariro ti pʉhtoro yare yoadoho duaa, namo tierara. Ã jia ahrina namo ti duaeraina ãta tʉhotunocaina, tó seheta ti ji sohtori tichʉ noana —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ã yoa masa macanacãre Jesu cahapʉ na wihire. Ã na wihia, tina Jesure to wamomacare tinacã bui ña payo duti duamare. Ã yoa tinacãre Cohamacʉre sini payo duti duamare Jesure. Ti ã yoachʉ ñʉna sã to buheina tinare tuhtimahi. ");
INSERT INTO gvc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sã ã tuhtichʉ ñʉno, sãre Jesu õ sehe nire: —Macanacã yʉ cahapʉ tajaro. “To cahai wahaena tjiga”, niena tjiga tinacãre. Tinacã Cohamacʉre ti pʉhtoro tʉhotura. pʉhtoro Cohamacʉ to sʉho jiina ahrinacã yoaro sehe tʉhotuina baro dihta jira —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ã ninota to wamomacare tinacã bui ña payo tuhsʉ, wahaa wahare. ");
INSERT INTO gvc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","To ã yoari baharo cʉ̃iro masʉno Jesu cahapʉ wihi, siniture tirore: —¿Ne, buheriro, jipihtia dachoripe Cohamacʉ mehne ã jirucu duacʉ, noaare yoa duacʉ di baro sehere yoabocari yʉhʉ? —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Dohse jiro baro yʉhʉre noaa barore ni sinitujari mʉhʉ? Cohamacʉ dihta noariro jira. Jipihtia dachoripe Cohamacʉ mehne ã jirucu duacʉ to dutiare yoaga —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Di baro dutia sehere nii nijari? —ni sinitu namore tiro. Jesu õ sehe ni yʉhtire: —Masare wajãecʉ tjiga. Namo tiriropʉ paye numia manʉ tia numia mehne jiecʉ tjiga. Yacaecʉ tjiga. Mahñoa mehne painare yahusãecʉ tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉ pʉcʉsʉmare ño payoga. Mʉ basi mʉ cahĩno seheta mʉ cahai jiriro cʉ̃hʉre cahĩga. Ahri dutiare yoaihca mʉhʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Ahri dutiare ne yʉhdʉrʉcaera tihi yʉhʉ. ¿Dohse yoa namoihcari yʉhʉ jipihtia dachoripe Cohamacʉ mehne jirucu duacʉ? —nire tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","To ã nichʉ tʉhoro Jesu õ sehe ni yahu namore: —Mʉhʉ ñaa buhiri marieriro ji duacʉ mʉ ya jipihtiare duai wahaga. Ã duacʉ jipihtia mʉ wapatari niñerure pjacʉoinare waga. Mʉ ã yoachʉ payʉ mʉ wapataa mʉanopʉ, Cohamacʉ cahapʉ jiyuahca. Mʉ ã yoari baharo yʉhʉ mehne macariro cjihto taga —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","To ã nichʉ tʉhoro tuaro cahyare. Tiro payʉ pache cjʉariro jiro, tíre pjacʉoinare wa duaeraro, cahya, wahaa wahare. ");
INSERT INTO gvc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","To ã wahari baharo Jesu sãre to buheinare õ sehe ni yahu namore: —Potocã mʉsare niita nija. Pache pʉro pʉhtoro Cohamacʉ to sʉho jiropʉre to waha duachʉ mijobiara. ");
INSERT INTO gvc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mʉsare yahu namoihtja: Camello sehe awicã copapʉ to sãa nuhri wijaa duachʉ basioerara tirore. To ã jiro yʉhdoro pache pʉro pʉhtoro Cohamacʉ to sʉho jihtopʉ to waha duachʉ mijobiara —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","To ã nichʉ tʉhona sã cʉaa waha, sã basi õ sehe nii: —Cue, to nino seheta jichʉ, ne cʉ̃iro masʉno Cohamacʉ cahapʉ waha masieraboca —nii sã basi. ");
INSERT INTO gvc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sã ã nichʉ Jesu sãre ñʉroca õ, õ sehe ni yahure: —Masa ti basi ti mʉ sʉro yʉhdʉ masierara. Wiho mejeta Cohamacʉ sehe masare pichacapʉ wahaborinare yʉhdo masina. Tiro jipihtiare noano yoa masi pahñoriro jira —nire tiro sãre. ");
INSERT INTO gvc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","To ã nichʉ Pedro tirore õ sehe nire: —Tʉhosiniga. Sã sehe sã ya jipihtiare cũnocaa tii mʉhʉ mehne wahana tana. ¿Sã õ sehe yoana, dohse jiare wapatanahcari sã? —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","To ã nichʉ tʉhoro õ sehe nire Jesu: —Mʉsare niita nija: Pihtiri dacho jichʉ jipihtia wahma dihta cohtotaahca. Tí pjapʉre yʉhʉ masʉno Cohamacʉ warocariro yʉhʉ pʉhtoro yʉ dujiroi si siteroi dujiihca yʉhʉ. Tói yʉ dujichʉ mʉsa cʉ̃hʉ doce dujia pahtarihi pʉhtoa ti dujia pahtarihi dujinahca. Ã jina Israe masare doce curuari macainare besenahca mʉsa noaina, ñainare. ");
INSERT INTO gvc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ã yoa yʉ yare yoana tana mʉsa wʉhʉsere, mʉsa bahanare, mʉsa pʉcʉsʉmare, mʉsa pohnare, mʉsa weserire cũnocarina jina, pjíro wapatanahca. Tuhsʉ, jipihtia dachoripe Cohamacʉ mehne jirucunahca. ");
INSERT INTO gvc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wiho mejeta mipʉre payʉ pʉhtoa jirina cjiri tí pjapʉre wiho jiina tjuanocaahca. Tuhsʉ, mipʉre payʉ wiho jiina jirina cjiri tí pjapʉre pʉhtoa cohtotaahca tjoa —ni yahure Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ã yoa Jesu pari turi to tʉhotua mehne piti dahre õ sehe ni yahu namore tjoa: —Mʉano macariro masa bui pʉhtoro jira. Wese pʉro quiti mehne pʉhtoro Cohamacʉ to sʉho jirore yahuihtja mʉsare. Tiro wese pʉro bohrea parĩcaroi to wesere dahrahtinare pjiro wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Cʉ̃ tʉ niñeru tʉ wapaihtja cʉ̃ dachore”, niha tinare. “Jai”, niha dahrahtina. Ti ã nichʉ wesepʉ dahra dutiro warocaha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ã yoa dachopʉ nueve hora jichʉ pache duaropʉ wahaha tiro. Tópʉ sʉro, paina dahraerainare ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ã ñʉno tinare õ sehe niha: “Mʉsa cʉ̃hʉ yʉ wesere dahrana wahaga. Noano wapaihtja”, niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","To ã nichʉ tʉhoa, tina cʉ̃hʉ wesepʉ dahraa wahaha. Ã yoa wese pʉro cohari pja jichʉ, ñamichahapʉ tres hora jichʉ cʉ̃hʉre painare dahra dutiha. ");
INSERT INTO gvc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ã yoa ñamichahapʉ cinco hora jichʉ pache duaropʉ tiro wahaha tjoa. Tópʉ sʉ, paina dahraerainare ñʉno, tinare õ sehe niha: “¿Ne yaba barore yoaerapanahta cʉ̃ dacho ñʉrucu nahñoajari mʉsa?” ni sinitu ñʉha tinare. ");
INSERT INTO gvc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ne, sãre dahraa mariahna”, ni yʉhtiha tina. “Mʉsa cʉ̃hʉ yʉ wesere dahrana wahaga”, niha tinare. Ã jia to niriro seheta to wesere dahraa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ã yoa ñamichahapʉ dahra duhuri pja jichʉ wese pʉro to yaina dahrainare cohtarirore õ sehe niha: “Dahrainare pjiga. Ti wihichʉ tinare wapaga. Ti baharopʉ yʉ dahra dutirinare wapa mʉhtaga. Tinare wapa tuhsʉ, paina cʉ̃hʉre wapa tuhsʉ, yʉ dahra duti mʉhtainare wapa batoaga jʉna”, niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ã yoa cinco hora jichʉ dahra dʉcainare cʉ̃ tʉ niñeru tʉ wapaha. ");
INSERT INTO gvc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","To ã wapachʉ ñʉa, “Sãre bui curero waparohca”, ni tʉhotumaha to duti mʉhtaina cjiri sehe. Tina cʉ̃hʉre cʉ̃no potori wapanocaha. ");
INSERT INTO gvc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ã jia niñerure to wapachʉ ti pʉhtoro mehne susinia ti basi õ sehe cahma niha: ");
INSERT INTO gvc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ahrina sã baharopʉ to dahra dutirina sehe cʉ̃ horata dahrahre. Sã sehe cʉ̃ dacho noano dahra nahñoamahi. Ñano sʉ̃ sihre sãre. Sã ã yoari pja dahrapachʉta sã baharopʉ dahra dʉcaina cʉ̃hʉre cʉ̃no potorita wapanocahre tiro”, ni suaha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Cʉ̃iro tina mehne macariro to ã nichʉ tʉhoro, wese pʉro yʉhtiha tirore: “Ne coyeiro, ‘Cʉ̃ tʉ niñeru tʉre wapaihtja’, nimahicʉ mʉsare. Yʉ ã nichʉ yʉhtihre mʉsa. Ã jicʉ yʉ niriro seheta mʉsare wapahi yʉhʉ. Quihõno wapahi mʉsare. Ne yacaerahi mʉsare. ");
INSERT INTO gvc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ã jicʉ yʉ waparire na, mʉ wʉhʉpʉ tjuahga. Ahrirore baharo yʉ dahra dutiriro cʉ̃hʉre mʉsare yʉ wapariro purota wapaihtja. ");
INSERT INTO gvc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yʉ ya niñeru jira ahri. Ã jicʉ yʉ cahmano seheta ahri mehne wapaihtja. ¿Painare yʉ noano wapachʉ ñʉ tuhtijari mʉhʉ?” niha tiro wese pʉro —ni yahure tí quitire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ã nino, õ sehe ni yahu namore tiro: —Ahri quiti ti nino seheta baharo macari curua wiho jiina yoaro sehe ya curua ji mʉhtari curua pʉhtoa ya curua jirohca mʉanopʉ. Ã yoa ji mʉhtari curua pʉhtoa ya curua cjiro sehe ti baharopʉ macari curua wiho jiina ya curua tjuarohca mʉanopʉ —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ã yoa Jerusalẽpʉ wahana cʉ̃noihta waharucuma, sãre doce to buheinare pjiroca tuhsʉ, pa sehepʉ sã dihtare naahre Jesu. Sã sahsero sã jichʉ sãre õ sehe ni yahure: ");
INSERT INTO gvc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Tʉhoga yʉhʉre. Mipʉre Jerusalẽpʉ wahana nija mari. Tópʉ yʉhʉre masʉnore Cohamacʉ warocarirore ñaha, painapʉre yʉhʉre waahca. Sacerdotea pʉhtoare, mari coyea judio masare buheina cʉ̃hʉre yʉhʉre waahca. Ã jia yʉhʉre wajã dutiahca tina. ");
INSERT INTO gvc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ã wajã dutia, judio masa jieraina sehere yʉhʉre waahca. Ti ã wari baharo tina sehe yʉhʉre bʉjʉpe, tjana, crusapʉ cjã puhaahca yʉhʉre. Ã jii yʉ yariari baharo tia nʉmʉ wahaboroi masa wijaaihca —ni yahure Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ã yoa Zebedeo namono pʉaro to pohna mehne Jesu cahapʉ sʉ, na tuhcua caha sʉha tirore sinino taro: ");
INSERT INTO gvc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Dohse yʉ yoachʉ cahmajari mʉhʉ? —niha Jesu ticorore. —Mʉhʉ pʉhtoro sãacʉ yʉ pohnare dutiina sõga. Ã yoacʉ mʉ pjʉ bʉhʉseheri batoi dapoga tinare —ni siniha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu õ sehe ni yʉhtiha: —Mʉsa ñano yʉhdʉhtore masierapanahta ã sinina mʉsa. ¿Mipʉre yʉ ñano yʉhdʉhto seheta mʉsa cʉ̃hʉ ñano yʉhdʉna cʉ̃no pjabocari mʉsa? —niha Jesu ticoro pohnare. —Cʉ̃no pjanahca —ni yʉhtiha Santiago, João mehne. ");
INSERT INTO gvc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Potocã tjira. Yʉ ñano yʉhdʉhto seheta ñano yʉhdʉnahca mʉsa cʉ̃hʉ. Wiho mejeta yʉhʉ mehne dutihtinare, yʉhʉ mehne dujihtinare bese masieraja yʉhʉ. Yʉ Pʉcʉ sehe cahno tuhsʉre tíre. Ã jia to besehtina dihta yʉ poto bʉhʉsehei yʉ cõ bʉhʉsehei dujiahca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ã jina sã paina diez to buheina sehe Santiago, João ahrina pʉaro mehne susinii sã. Jesure ti pocoro to sinibasarire tʉhona susinii tina mehne. ");
INSERT INTO gvc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sã ã susinichʉ ñʉno, Jesu sãre jipihtina to buheinare pji cahmachu, õ sehe ni yahure sãre: —Cohamacʉre masieraina pʉhtoa sehe ti masare dutia, purĩno mehne dutira. ");
INSERT INTO gvc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉsa sehe ne ã yoasi mʉsa basi. Mʉsa mehne macariro pʉhtoro ji duaro, jipihtina tiro mehne macaina cahamacʉno jiro cahmana tirore. ");
INSERT INTO gvc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ã yoa jipihtinare dutiriro ji duariro paina cahamacʉno jiro cahmana tirore. ");
INSERT INTO gvc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tó seheta jiriro jija yʉhʉ cʉ̃hʉ. Yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉre masare yoadohocʉ tacʉ tai. Tuhsʉ, payʉ masa ya buhirire yariai tai nii. Ã yoa masare pichacapʉ wahaborinare yʉhdʉchʉ yoai tai nii —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ã yoa Jericópʉ jirina sã wahachʉ payʉ masa Jesure nʉnʉ tire. ");
INSERT INTO gvc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ti ã nʉnʉ tichʉ Jesu to yʉhdʉachʉ pʉaro capari ñʉeraina maha dʉhtʉ cahai dujiina tʉhore. Ã tʉhoa, õ sehe ni sañurucure: —Sã pʉhtoro, Davi cjiro panamino masare yʉhdohtiro, sãre pja ñʉga —ni sañurucure. ");
INSERT INTO gvc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ti ã ni sañurucuchʉ masa sehe tinare tuhtire: —Dihta mariahga —nire masa tinare. Ti ã tuhtichʉ tʉhoa, ti pano sañurucuriro yʉhdo curero sañurucu namore tjoa: —Sã pʉhtoro, Davi cjiro panamino, sãre pja ñʉga —ni sañurucure. ");
INSERT INTO gvc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ti ã nichʉ tʉhoro Jesu sʉrʉca, tinare pjiroca, õ sehe ni sinitu ñʉre: —¿Dohse mʉsare yʉ yoachʉ cahmajari mʉsa? —ni sinitu ñʉre. ");
INSERT INTO gvc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Sã pʉhtoro, sãre ñʉchʉ yoaga —ni yʉhtire tina. ");
INSERT INTO gvc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ti ã nichʉ Jesu tinare pja ñʉre. Ã pja ñʉno ti caparire ña payore. To ã ña payochʉta tina sehe ñʉa wahare. Ã ñʉa, tirore nʉnʉ ti wahcãre. ");
INSERT INTO gvc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ã yoa Jerusalẽpʉ sã sʉhto pano Betfagé wama tiri macapʉ sʉ mʉhtasinii sã Jesu mehne. Betfagé tʉ̃cʉ Olivo wama tidʉ cahai jire. Tópʉ sʉro, sã mehne macainare pʉaro to buheinare Jesu to pano waroca mʉhtare. ");
INSERT INTO gvc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Õ sehe ni yahure tinare: —Sí macapʉ burroare nana wahaga. Tópʉ sʉna, dóihta burrore to macʉnocã mehne ti dʉhte daporicorore boca sʉnahca. Tinare boca, yuta dare pjã, na tabasaga yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mʉsa pjãchʉ ñʉno, cʉ̃iro dohse jiriro, “¿Dohseana tana burroare pjãjari mʉsa?” to nichʉ tʉhona õ sehe ni yʉhtiga: “Mari pʉhtoro burroare cahmarocasinire. Michapucacã tinare wiarohca tiro”, ni yʉhtiga tirore —ni duti warocare Jesu to buheina pʉarore. ");
INSERT INTO gvc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ã yoare Cohamacʉ yare yahu mʉhtariro cjiro to ni joariro seheta. Õ seheta ni joaa tiha panopʉ: ");
INSERT INTO gvc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalẽ macainare õ sehe ni yahuga: ‘Ñʉga mʉsa. Mʉsa pʉhtoro mʉsa cahapʉ tara. Tiro masa noariro jira. Burro macʉnocã bui pisariro tarohca’, ni yahuga Jerusalẽ macainare”, ni joaa tiha panopʉ. ");
INSERT INTO gvc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesu to dutirocaina pʉaro tí macapʉ sʉ, to dutiriro seheta yoaha tina. ");
INSERT INTO gvc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrore, to macʉnocã cʉ̃hʉre na ta, ti bui sãa suhtire tjuwe na, burrocã bui pjũpaha payore tina. Ti ã yoari baharo Jesu tirocã bui mʉja pjare waharo taro. ");
INSERT INTO gvc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mʉja pja tuhsʉ, tirocã bui Jerusalẽpʉ wahare. To tachʉ ñʉa masa payʉ ti bui macaa suhtire tjuwe na, saño cũ mʉhtare to wahahti mahai, Jesure ño payoa. Paina sehe pũri tia dʉpʉrire mahai duhu cũ mʉhta wahcãre tirore ño payoa. ");
INSERT INTO gvc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ã yoa to pano wahaina, to baharo nʉnʉ tiina mehne õ sehe ni sañurucure: —Davi cjiro panaminore marine yʉhdohtirore wahche payojihna. Ahriro Cohamacʉ to warocariro noano jijaro. Mʉano macarirore “Tuariro jira”, ni wahche payojihna —ni sañurucure masa. ");
INSERT INTO gvc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ã jia Jerusalẽpʉ ti sʉchʉ tó macaina sehe ñʉ cʉaa wahare. —¿Cue, diro baro jijari ahriro? —ni cahma siniture tina. ");
INSERT INTO gvc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Paina masa õ sehe ni yʉhtire: —Ahriro Cohamacʉ yare yahu mʉhtariro Nazare Galilea yahpai jiri maca macariro Jesu wama tiriro jira —ni yahure tina masare. ");
INSERT INTO gvc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Baharo Cohamacʉ wʉhʉpʉ sʉre Jesu. Tí wʉhʉpʉ sʉ, sãa wahare. Tí wʉhʉpʉ duainare, nuchʉina cʉ̃hʉre cohã wiore tiro. Ã yoaro niñeru cohtotaa mesarire na majareroca doca cũ mʉjare. Bujaare duaina ti dujia pahtari cʉ̃hʉre ãta yoare. ");
INSERT INTO gvc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ã yoaro tinare õ sehe nire: —Cohamacʉ yare ti joari pũi õ sehe nina: “Yʉ wʉhʉ Cohamacʉ mehne durucuri wʉhʉ wama tirohca”, nimare to joari pũi. Mʉsa sehe ahri wʉhʉi duana mʉsa basi cahma yacara mʉsa —nire tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","To ã yoari baharo capari ñʉeraina, tini masieraina cʉ̃hʉ Cohamacʉ wʉhʉpʉ tiro cahapʉ wihire. Ti ã wihichʉ tinare noaina wahachʉ yoare tiro. ");
INSERT INTO gvc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ã noaare to yoachʉ ñʉa, sacerdotea pʉhtoa, marine judio masare buheina cʉ̃hʉ suare tiro mehne. Ã yoa macanacã Jesure “Davi cjiro panamino masare yʉhdohtiro, tuariro jira mʉhʉ”, ti ni ño payochʉ tʉhoa tó cʉ̃hʉre tina suare. ");
INSERT INTO gvc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ã suaa õ sehe nire Jesure: —¿Ti ã nichʉ tʉhoerajari mʉhʉ? Ã niea tjijaro —ni tuhtire tina Jesure. Ti ã tuhtichʉ tʉhoro Jesu tinare õ sehe ni yʉhtire: —Tina ti ã nichʉ tʉhoja. ¿Cohamacʉ yare ti joari pũi ahrire ne buherari mʉsa? “Macanacãre, wihãinacãre Cohamacʉre noano ño payochʉ yoare mʉhʉ”, nina Cohamacʉ yare ti joari pũi —nire Jesu (“Macanacã yʉhʉre ti ño payochʉ noana”, nino). ");
INSERT INTO gvc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ã ni tuhsʉ tinare cohã wahcã, Betania wama tiri macapʉ sʉ, tí ñamine tói jire. ");
INSERT INTO gvc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pa dachoi bohrearopʉ Jerusalẽpʉ tjuaaro, jʉca baare Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ã jʉca baaro, maha dʉhtʉ cahai jidʉ higueracʉ wama tidʉre ñʉno, tʉ dichare macano wahamare. Dicha mariahre tʉ sehe. Pũri dihta jire. Tʉ ã jichʉ ñʉno Jesu tʉre õ sehe nire: —Ahdʉ ne pari turi dicha tisi —nire tiro. To ã nichʉta dóihta tʉ sehe ñaia wahare. ");
INSERT INTO gvc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tʉ ã wahachʉ ñʉna sã to buheina ñʉ cʉa wahai. —Cue, ¿dohsearo ahdʉ dóihta ñaia wahajari? —ni sinitui sã. ");
INSERT INTO gvc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu õ sehe ni yʉhtire: —Potocã nii nija mʉsare. Cohamacʉre noano wacũ tuaga. “Potocã ã yoarohca tiro”, nina ahdʉre yʉ yoariro seheta yoa masinahca mʉsa cʉ̃hʉ. Tuhsʉ, ahdʉre yʉ yaria dutiriro yʉhdoro yoa masinahca mʉsa. Ahdʉ tʉ̃cʉre “Duha na, pjiri mapʉ cohãdʉ jijaro”, mʉsa nichʉ duha cohãdʉ jirohca. ");
INSERT INTO gvc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Cohamacʉre mʉsa wacũ tuachʉ, “Yʉ siniriro seheta ã waharohca”, mʉsa ni wacũchʉ mʉsa siniriro seheta ã waharohca —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ã yoa Cohamacʉ wʉhʉpʉ tju sʉ, buhere tiro. To ã buhechʉ sacerdotea pʉhtoa, mari coyea judio masa bʉcʉna mehne tiro cahapʉ wihi, õ sehe ni siniture: —¿Dohseacʉ canʉre ã yoari mʉhʉ? ¿Noa mʉhʉre tíre ã yoa dutiri? —ni siniture tina. ");
INSERT INTO gvc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ti ã nichʉ Jesu õ sehe ni yʉhtire: —Mʉsa sehere sinitu mʉhtaihtja. Noano yʉhʉre mʉsa quihõno yʉhtichʉ mʉsare yahuihtja yʉhʉ cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿João masare to bautisachʉ diro baro sehe tirore bautisa dutia tiari, mʉsa tʉhotuchʉ? ¿O Cohamacʉ dutiera tiari? ¿O masa sehe dutia tiari, mʉsa tʉhotuchʉ? —ni siniture Jesu tinare. To ã nichʉ tina sehe ti basi õ sehe nire: —¿Dohse ni yʉhtinahcari mari? “Cohamacʉ Joãore dutia tiri jire”, mari nichʉ, “¿Dohseana Cohamacʉ Joãore to dutipachʉta tirore tʉho duaerari mʉsa?” niboca Jesu marine. Ã jina “Cohamacʉ Joãore dutia tiri jire”, ni yʉhti masieraja mari. ");
INSERT INTO gvc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ahrina masa sehe “Potocãta João Cohamacʉ yare yahu mʉhtariro jire”, ni tʉhotura tina. Ã ni tʉhotua “João to bautisachʉ Cohamacʉ sehe tirore dutierari jire”, mari nichʉ tʉhoa masa suaboca mari mehne. Ã jina tí cʉ̃hʉre yahu masieraja mari —nire tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ti ã niri baharo Jesure õ sehe ni yʉhtire tina: —Joãore bautisa dutirirore sã masieraja —nire tina. Ti ã nichʉ tʉhoro õ sehe nire Jesu: —Tí pja pinihta yʉhʉ cʉ̃hʉ mʉsa sinitu mʉhtarire yahueraja mʉsare. Yʉ yoarire dutirirore yahueraja mʉsare —nire tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","To ã niri baharo Jesu to tʉhotua mehne paye quiti mehne piti dahre buhe namore tinare: —¿Ne, dohse ni tʉhotujari mʉsa ahri quitire? Pʉaro pʉcʉro jiha. Wahmino sehere õ sehe niha to pʉcʉro: “Macʉ, wesepʉ dahrai wahaga”, niha. ");
INSERT INTO gvc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Wahaeraja”, ni yʉhtimaha to macʉno wahmanore. Ã niparota baharopʉre wesepʉ waha duaro jiha tirore. Ã jiro wahaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tuhsʉ, ti pʉcʉro to macʉno dʉhsariro cahapʉ sʉ, to wahminore to dutiriro seheta wesepʉ waha dutimaha. “Jai”, nimaha dʉhsariro sehe. Ã niparota wahaeraha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Diro sehe to pʉcʉro to dutiriro seheta yoari? —ni siniture Jesu. —To wahmino sehe yoaha —ni yʉhtire tina. Ti ã nichʉ Jesu õ sehe ni yahure: —Mʉsare niita nija. Wapa na cohtaina, mʉa mehne ñano yoarucua numia ti buipʉ waro mʉsa sehe ñabiaina jira. Ã jia pʉhtoro Cohamacʉ to sʉho jiropʉre mʉsa sʉborirore tina sehe mʉsare mʉ cõ sʉ mʉhtaahca. ");
INSERT INTO gvc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","João bautisariro buhero mʉsare “Noano yoaga”, ni yahumare. Ã to yahuchʉ dʉhsariro to pʉcʉrore to yʉhtierariro seheta tirore tʉhoerare mʉsa. Ã yoa tirore yʉhtierare. Wapa na cohtaina sehe, mʉa mehne ñano yoarucua numia cʉ̃hʉ tirore tʉhore. Ti ã tʉhochʉ ñʉre mʉsa. Mʉsa ã ñʉpanahta tirore ne tʉho duaerare mʉsa. Tuhsʉ, tʉhoerare mʉsa —nire Jesu sacerdotea pʉhtoare, mari coyea judio masa bʉcʉna cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ã yoa Jesu pari turi to tʉhotua mehne õ sehe ni piti dahre tinare buhe namore: —Ahri quitire tʉhoga mʉsa. Yahpa pʉro jiha. Tiro to ya yahpai se dari cjihtire toaha. Toa tuhsʉ, sahrĩnore dapo, sere ti tʉ mʉtohti copare saha, mʉari wʉhʉcã dahreha. ’Ã jiro tí wesere painare cʉ̃ bʉhʉsehe coa pahma cũha. Ã pahma cũno tí wesere tinare ñʉ wihbo duti, pa yahpapʉ wahaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ã yoa se ñiri pja jichʉ wese pʉro tirore dahra cohtainare wesere ñʉ wihboina cahapʉ warocaha. Wese macaa to toaa dichare to ya coa macaa dichare na dutiro warocamaha. ");
INSERT INTO gvc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","To ã warocachʉ wesere ñʉ wihboina sehe tirore dahra cohtainare ñano yoaha. Cʉ̃irore tuaro cjã, pairore wajã, pairore tãa mehne docaha. ");
INSERT INTO gvc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Baharo wese pʉro pari turi tirore dahra cohtainare to waroca mʉhtarina bui curero pʉhtoa jiri curuare warocaha tjoa. To ã warocachʉ wesere ñʉ wihboina tina cʉ̃hʉre mʉnanota yoaha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ã yoa to waroca batoariro to macʉno jiha. “Yʉ macʉ sehere ño payoahca”, nino tirore warocamaha. ");
INSERT INTO gvc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","To ã ni tʉhotupachʉta wesere ñʉ wihboina to macʉno to tachʉ ñʉa, õ sehe niha: “Wese pʉro macʉno jira ahriro. Tirore wajãjihna mari. Mari ã wajãchʉ ahri wese mari ya wese tjuarohca”, nimaha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ã niata tirore ñaha, wese dʉhtʉ cahai na wahcã, wajãha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’¿Ne, wese pʉro taro dohse yoarohcari tiro wesere ñʉ wihboinare, mʉsa tʉhotuchʉ? —ni siniture Jesu sacerdote pʉhtoare, bʉcʉna cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","To ã nichʉ tina õ sehe ni yʉhtire: —Tiro painare wesere ñʉ wihbohtinare cohtotarohca ji mʉhtainare ñabiainare wajãno taro. Tirore quihõno dichare tju wahtina sehere ñʉ wihbo dutirohca —ni yʉhtire tina. ");
INSERT INTO gvc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ti ã nichʉta Jesu yahu namore tinare: —¿Cohamacʉ yare ti joari pũi ahrire yʉhʉre to ni joari cjirire ne buherari mʉsa? “Ahriro Cristo tãca yoaro seheta jira. Tãcare wʉhʉ dahreina ti cohãno seheta masa tirore cohãahca. Ti ã yoapachʉta mipʉre wʉhʉ dahreina wʉhʉre yoaa ti cũ mʉhtari tãcare ti cũno seheta Cohamacʉ tirore pʉhto sõre. Cohamacʉ sehe ahrire yoare. To ã yoachʉ ñʉna, ‘Noa yʉhdʉara’, ni tʉhotuja mari”, ni joaa tiha panopʉ. ¿Tíre ne buherari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mʉsare niita nija yʉhʉ. pʉhtoro Cohamacʉ to sʉho jiro mʉsa jihto cjihto jiboa. To pʉhtoro jirore paina sehere mʉsa jiborirore warohca Cohamacʉ. Paina masa sehe to dutiro seheta yoaahca. ");
INSERT INTO gvc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jipihtina tia tãca bui bora pjainare payʉ dihicã peri yihsorohca tia tãca. Tuhsʉ, tia tãca sehe masʉno bui bora pjaro tahãnocanohca tirore. To pjacʉ cjirore daa manaricã wahachʉ yoarohca. (Tó seheta yʉhʉre cahmaeraina yʉ buhiri dahrehtina ñano yʉhdʉahca) —nire Jesu sacerdotea pʉhtoare, mari coyea judio masa bʉcʉna cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tí quitire to ã nichʉ tʉhoa, “Sohõ to yahu mʉhtari quiti wesere ñʉ wihboina quiti mehne marine nino nica tiro”, ni tʉhoture tina. ");
INSERT INTO gvc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ã ni tʉhotua, tirore ñaha duamare. Masa sehe Jesure ño payo “Cohamacʉ yare yahu mʉhtariro jira tiro”, niina jia tiha tina. Tíre masia, sacerdotea pʉhtoa, bʉcʉna mehne masare cuia, Jesure ñahaerare. ");
INSERT INTO gvc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ã yoa pari turi to tʉhotua mehne paye quiti mehne tinare buhe dʉcare Jesu: ");
INSERT INTO gvc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Mʉano macariro pʉhtoro to sʉho jiro ahri quiti yoaro sehe jira. Cʉ̃ yahpa macaina bui pʉhtoro jiha. Ã yoa to macʉno ya nʉmʉ bose nʉmʉ yoaha. To wamomaca dʉhteri bose nʉmʉ jiha. ");
INSERT INTO gvc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ã yoa pʉhtoro tirore dahra cohtainare bose nʉmʉre ñʉa tahtinare pji dutiro warocamaha. Tina sehe ta duaeraha. ");
INSERT INTO gvc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ã jiro painare pji dutiro warocamaha tjoa tirore dahra cohtainare. “Yʉ pjirocainare õ sehe ni yahuga. ‘Mari chʉhtire dahre tuhsʉhre. Wachʉare, wachʉacã dihi tiinacã cʉ̃hʉre wajã tuhsʉhre. Ã yoa jipihtiro bose nʉmʉ macaa cjihtire cahno tuhsʉhre. Ã jina bose nʉmʉ macaare chʉna taga’, ni yahuga tinare”, ni warocamaha pʉhtoro tirore dahra cohtainare. ");
INSERT INTO gvc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dahra cohtaina ti ã yahuri baharo to pjirocarina cjiri ã tʉhotunocaha. Bose nʉmʉre ñʉa wahaeraha. Cʉ̃iro to wesepʉ wahaa wahaha. Pairo to dahraare ñʉno wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Paina sehe tirore dahra cohtainare ñaha, tinare ñano yoa, wajãnocaha jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ti ã yoachʉ tʉhoro, pʉhtoro sehe suaha. Sua, ti ã wajãri buhiri buhiri dahre dutiro to surarare warocaha. Ã jia surara tinare wajã pahño, ti ya macare jʉ̃nocaha. ");
INSERT INTO gvc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ti ã yoari baharo, pʉhtoro tirore dahra cohtainare õ sehe niha: “Bose nʉmʉ macaa cjihtire cahno tuhsʉmahre. Wiho mejeta yʉ pjiroca mʉhtarina cjiri yʉ bose nʉmʉre ñʉborina jierara. Ñaina jira tina. ");
INSERT INTO gvc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ã jina macare jia maharipʉ dohse jiina mʉsa boca sʉinare bose nʉmʉre ñʉhtinare pjiga”, niha tirore dahra cohtainare. ");
INSERT INTO gvc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","To ã nichʉ tirore dahra cohtaina maharipʉ waha, jipihtinare ti boca sʉinare, ñaina, noaina cʉ̃hʉre yahuha. Ti ã pjiri baharo to cahapʉ sʉha tina peri. Noano tí bose nʉmʉ ti yoari tahtiare masa wahpata yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tói ti dujichʉ pʉhtoro sehe cʉ̃irore wamomaca dʉhteri nʉmʉ macari suhtirore sãaerarirore ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“¿Ne coyeiro, dohse yoacʉ wamomaca dʉhteri nʉmʉ macari suhtirore sãaerapaihta sã tari mʉhʉ?” ni sinituha pʉhtoro. To ã sinituchʉ masʉno sehe yʉhtieraha. ");
INSERT INTO gvc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","To ã yʉhtierachʉ ñʉno tirore dahra cohtainare õ sehe niha: “Ahrirore to wamomacarine dʉhtega. To dahpori cʉ̃hʉre dʉhtega. Dʉhte tuhsʉ na wijaa, sopacapʉ cohãga tirore nahitianopʉ. Tópʉ tiro tuaro tii, cahyaro mehne bahca dihorohca”, niha pʉhtoro —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","To ã niri baharo õ sehe ni batoare tiro: —Ahri quiti jiro seheta Cohamacʉ payʉ masa to pjirocarina ti jipachʉta mahainacã tiro mehne tjuaahca —ni yahu batoare Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","To ã niri baharo fariseo curua macaina waha, Jesure ti yahusãhtore ti basi durucuha tina. To ñano yʉhtichʉ tʉho duaa nimaha tirore yahusãa taa. ");
INSERT INTO gvc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ã durucua tina mehne macainare, Herode ya curua macaina cʉ̃hʉre Jesure sinitu dutia warocaha. Tina sehe Jesu cahapʉ wihi, tirore mahño cũ sinitu ñʉmare: —Buheriro, potocã durucuriro mahñoa marieriro mʉ jichʉ masija sã. Cohamacʉ yare quihõno mʉ yahuchʉ cʉ̃hʉre sã masija. Ã jicʉ cʉ̃iro pʉhtoro waro to jipachʉta tiro cʉ̃hʉre dórero marieno potota yahura mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ã jicʉ sãre yahuga. ¿Roma macariro jipihtina bui pʉhtoro jirirore gobierno macaare marine waparo cahmajari, mʉ tʉhotuchʉ? ¿Mari dutia tirore wapa dutijari? —ni siniture tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ti ã nichʉ tʉhoro tirore ti yahusã duaare masino õ sehe nire: —Mahñopeina jira mʉsa. ¿Dohseana yʉ ñano durucuchʉ tʉho duajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mipʉre niñeru tʉre pʉhtoare wapahti tʉre na tahga. Tí tʉre ñʉjihna —nire tiro. To ã nichʉ tʉhoa niñeru tʉre na tare tina. ");
INSERT INTO gvc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ti ã na tachʉ õ sehe ni siniture tiro tinare: —¿Diro baro masʉ wahãjari ahri tʉre? ¿Diro baro wama wahãjari? —ni siniture. ");
INSERT INTO gvc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—César, masa bui pʉhtoro masʉ, to wama cʉ̃hʉ wahãna —ni yʉhtire tina. Ti ã nichʉ tʉhoro Jesu õ sehe ni yahure: —Tí pja pini masa bui pʉhtoro yare tiro sehere waga. Cohamacʉ yare Cohamacʉ sehere waga —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","To ã nichʉ tʉhoa, tʉho cʉaa waha, wahaa wahare Herode ya curua macaina. ");
INSERT INTO gvc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ã yoa tí dachoihta cãina saduceo curua macaina Jesu cahapʉ wihire. Saduceo curua macaina sehe “Cohamacʉ yariainare masosi”, ni tʉhotuina jire. Ã jia õ sehe nire tirore tina: ");
INSERT INTO gvc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Buheriro, õ sehe ni buhea tiha Moise cjiro: “Cʉ̃iro to wahmino namo tiriro pohna mariaparota to yariachʉ to bahʉrore to wahmino namono cjirore nʉoano cahmana. Ã yoaro to wahmino mʉnano to pohna tiboro seheta pohna tiro cahmana to bahʉrore. Ã jia to pohna to wahmino mʉnano pohna yoaro sehe jiahca”, ni joaa tiha Moise cjiro —nire tina saduceo curua macaina. ");
INSERT INTO gvc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tíre ã ni yahu tuhsʉ ahri quitire yahu namore tina Jesure: —Cʉ̃iro masʉno jiha. Seis to bahana jiha. Ti wahmino sehe namo ti, pohna marieriro yariaa wahaha. Tuhsʉ, pairo to bahʉro cʉ̃hʉ to wahmino namono cjirore nʉoaha. ");
INSERT INTO gvc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","To ã nʉoari baharo to wahmino yoaro seheta pohna mariaparota yariaa wahaha tjoa. Ã yoa ahriro bahʉro to wahmino mʉnano yoaro seheta pohna mariaparota yariaa wahaha. Ã dihta wahaha cʉ̃iro pohna waro. Ne pohna mariapahta yaria pihtia wahaha tina. ");
INSERT INTO gvc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ti namono cjiro cʉ̃hʉ ti baharota yariaa wahaha jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Ne, Cohamacʉ jipihtinare yariaina cjirire to masochʉ diro baro namono jibocari ticoro? Tina jipihtina ticorore namo tirina cjiri jiha. ¿Ã yoa diro namono sehe jibocari ticoro pototi? —ni siniture tina. ");
INSERT INTO gvc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu õ sehe ni yʉhtire tinare: —Cohamacʉ yare ti joari pũre, to masia cʉ̃hʉre ne masierara mʉsa. Ã yoa mʉsa tʉhotua sehe ne potocã jierara. ");
INSERT INTO gvc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yariarina cjiri ti masa mʉjari baharo tina anjoa yoaro sehe jira. Tina namo marieina, manʉ mariea numia jira tópʉre. ");
INSERT INTO gvc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yariarina cjiri ti masa wijaahto sehere mʉsare yahuihtja. ¿Cohamacʉ mʉsare to niri cjirire ne buherari mʉsa? Õ sehe niha tiro: ");
INSERT INTO gvc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“ ‘Yʉhʉ Abrahã, Isaa, Jacobo ti pʉhtoro tjija’, nina Cohamacʉ”, ni joaa tiha panopʉre. Ti yariari baharo “Ti pʉhtoro tjija”, ni yahuha Cohamacʉ. Ã niparota yariarina cjiri pʉhtoro jierara Cohamacʉ. “Ti pʉhtoro tjija”, to nia mehne catiina ti jichʉ masija mari. Tiro catiina pʉhtoro jira —ni yahure Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","To ã ni buhechʉ tʉhoa payʉ masa tʉho cʉaa wahare. ");
INSERT INTO gvc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ã yoa saduceo curua macaina Jesure ti yʉhti masierachʉ tʉhoa, fariseo curua macaina sehe tiro cahapʉ cahmachure. ");
INSERT INTO gvc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Cahmachu, tina mehne macariro marine judio masare buheriro sehe Jesu to ñano nichʉ tʉho duaro mahño cũ sinitu ñʉmare tirore. ");
INSERT INTO gvc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—¿Buheriro Cohamacʉ ya dutia noa yʉhdʉaro di baro sehe jijari, mʉ tʉhotuchʉ? —ni siniture tiro. ");
INSERT INTO gvc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu tirore õ sehe ni yʉhtire: —“Tuaro mʉsa yajeripohna mehne, mʉsa tuaa mehne, noano mʉsa wacũa mehne Cohamacʉre cahĩga”, nina Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ahri dutiata paye dutia yʉhdoro noa yʉhdʉara. ");
INSERT INTO gvc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ahri dutia baharo paye dutia noa yʉhdʉara: “Mʉ basi mʉ cahĩno seheta mʉ cahai jiina cʉ̃hʉre cahĩga”, nina Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ahri pʉaro dutiare yoana, jipihtia paye dutiare yoa pahñona nija mari. Cohamacʉ yare yahu mʉhtaina cjiri panopʉ ti joari cʉ̃hʉre yoa pahñona nija mari —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ã yoa fariseo curua macaina tói cahmachuina ti jichʉ ");
INSERT INTO gvc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesu tinare õ sehe ni siniture: —“Cristo, Mesia mari ni pisuriro Cohamacʉ to warocahtiro jira”, nina mʉsa. ¿Diro baro jijari Cristo ñʉchʉno cjiro panopʉ macariro, mʉsa tʉhotuchʉ? —nire tiro. —Cristo Davi cjiro panamino jirohca —ni yʉhtire tina. ");
INSERT INTO gvc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu õ sehe ni yahure tinare: —¿Cristo Davi cjiro panamino to jichʉ dohsearo Davi sehe pʉhtoro tiari Cristore? ¿Dohsearo ã pʉhtoro ti dutiri Espíritu Santo tirore? Õ sehe niha Davi cjiro: ");
INSERT INTO gvc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Cohamacʉ yʉ pʉhtorore õ sehe nire: ‘Õi yʉ poto bʉhʉsehei dujiga. Ã jicʉ mʉhʉre ñʉ tuhtiinare mʉhʉre yʉhdʉrʉcabasaihca yʉhʉ’, nire Cohamacʉ yʉ pʉhtorore”, ni joaha Davi cjiro. ");
INSERT INTO gvc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ã ni joarota Davi cjiro pʉhtoro tiha Cristore. ¿Davi cjiro Cristo ñʉchʉno cjiro jiro dohsearo tiro pʉhtoro tiari Cristore? (Cristo Davi cjiro pʉhtoro tjira) —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","To ã ni yahuchʉ tina tirore ne yʉhti masierare. Ã jia tó purota sinitu duhunocare tina tirore. Tuhsʉ tirore cuia pari turi sinitu ñʉerare tirore jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ã yoa payʉ masare sã cʉ̃hʉre Jesu õ sehe ni yahure tjoa: ");
INSERT INTO gvc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Marine judio masare buheina fariseo curua macaina cʉ̃hʉ Cohamacʉ dutia Moise cjirore to cũri cjirire yahuina jira tina. ");
INSERT INTO gvc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ti ã yahuina jichʉ mʉsare ti yahuriro seheta tíre yoa pahñoga mʉsa. Ã yoapanahta tinare ñʉ cũena tjiga mʉsa. Ti buheriro seheta yoaerara tina. ");
INSERT INTO gvc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Masare payʉ dutira tina. Ã dutipahta ti dutiro sehe masa ti yoaerachʉ ñʉa tinare yoadohoerara. ");
INSERT INTO gvc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Masa ti ñʉrocaro dihta noano yoa ñomana tina. Cohamacʉ yare ti joari pũre ti duhu sãa caa pocacãre, bʉjʉ curea caa pocacãre ti wʉhdʉa poca bui dʉhte yohre tina masare ñʉ dutia. Ti yachʉri cʉ̃hʉre dʉhte yohre. Ã yoa ti suhtipʉ ti duhu yoaa bocari bʉjʉbia bocari jira. Cohamacʉre ti ño payorire masa sehere yoa ñoa nimana tina. ");
INSERT INTO gvc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tuhsʉ, bose nʉmʉri jichʉ pʉhtoa ti dujiapʉ duji duara. Judio masa mari buhea wʉhʉsepʉ cʉ̃hʉre noaa dujia pahtari dihtare jicoara tina. ");
INSERT INTO gvc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ã yoa mahapʉ ño payoa mehne paina tinare ti noano piti bocasinichʉ cahmana tina. Tinare “Buheriro”, masa ti ni pisuchʉ cahmana. ");
INSERT INTO gvc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Paina mʉsare pisua “Buheriro”, niea tjijaro. Mʉsa jipihtina cʉ̃no potori jina nina. Ã yoa mʉsare buheriro cʉ̃irota jija yʉhʉ Cristo. ");
INSERT INTO gvc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ahri yahpa macainare “Mari pʉcʉ”, nina tinare ño payona nica. Ne ã niena tjiga. Mʉano macariro dihta mari Pʉcʉ jira. Tiro dihtare ño payoro cahmana marine. ");
INSERT INTO gvc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ã yoa masʉnore “Pʉhtoro”, niena tjiga. Mʉsa pʉhtoro yʉhʉ Cristo sehe cʉ̃irota jija. ");
INSERT INTO gvc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Cahamacʉno yoaro sehe mʉsare yoadohoriro tiro tjica mʉsa pʉhtoro jihtiro. ");
INSERT INTO gvc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cʉ̃iro pʉhtoro ji duaro tirore wiho jiriro yoaro sehe jiro cahmana. “Wiho jiriro jija yʉhʉ”, ni tʉhoturiro painare yʉhdʉrʉca duaerariro tiro sehe pʉhtoro jirohca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","To ã niri baharo tinare õ sehe ni yahu namore: —Mʉsa judio masare buheina, fariseo curua macaina cʉ̃hʉ ñano yʉhdʉnahca. Mahñopeina jira mʉsa. Soro mʉsa buhechʉ tʉhoa mʉsare tʉhorina sehe pʉhtoro Cohamacʉ to sʉho jiropʉre wahasi. Mʉsa cʉ̃hʉ tópʉre wahasi. Ã buhena tópʉre waha duainare dʉcatana nina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Mʉsa judio masare buheina, fariseo curua macaina cʉ̃hʉ ñano yʉhdʉnahca. Mahñopeina jira mʉsa. Wapewahya numia ya wʉhʉsere manocahna mʉsa tí numiare. Tuhsʉ, yoari pja masa ti ñʉrocaroi Cohamacʉre sini ñomana mʉsa masare. Mʉsa ã yoari buhiri paina bui curero Cohamacʉ pjíro buhiri dahrerohca mʉsare. ");
INSERT INTO gvc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Mʉsa judio masare buheina, fariseo curua macaina cʉ̃hʉ ñano yʉhdʉnahca. Mahñopeina jira mʉsa. Pjiri mapʉ pahã, yoaro macaa yahparipʉ wahara mʉsa, mʉsa dutiare yoahtirore macana tana. Mʉsa dutiare yoahtirore boca, tirore buhera. Mʉsa ã yoachʉ tiro sehe mʉsa yʉhdoro pichacapʉ wahahtiro jirohca. ");
INSERT INTO gvc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Mʉsa ñano yʉhdʉnahca. Capari ñʉeraina ti ñʉ masieraro seheta masieraina jira mʉsa. Ã jipanahta painare buhemana mʉsa. Õ sehe ni buhemana mʉsa: “ ‘Cohamacʉ wʉhʉ mehne yʉ nino seheta yoaihtja’, niriro to niriro sehe to yoaerapachʉta noanohca”, ni buhemana mʉsa. “ ‘Cohamacʉ ya wʉhʉ macaa uru mehne yʉ nino seheta yoaihtja’, niriro tiro sehere to niriro seheta yoa sohtori tiro cahmana” ni, tí cʉ̃hʉre buhemana mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Capari ñʉeraina ti ñʉ masieraro seheta masieraina jira mʉsa. Tʉho masieraina jira. ¿Di baro sehere ño payoro cahmajari? Urure ño payoeraro cahmana. Cohamacʉ sehe tí uru to wʉhʉi jichʉ noaa jichʉ yoara tíre. Ã jina to wʉhʉ sehere ño payoro cahmana mʉsare. Ã jia mʉsa buhea sehe tó wahaerara. ");
INSERT INTO gvc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ahri cʉ̃hʉre buhemana mʉsa: “ ‘Cohamacʉ wʉhʉ macari mesa mehne yʉ nino seheta yoaihtja’, niriro to niriro seheta to yoaerachʉ noanohca”, ni buhemana mʉsa. “ ‘Tí mesa bui jia mehne Cohamacʉre ño payoa ti wari mehne yʉ nino seheta yoaihtja’, niriro tiro sehere to niriro seheta yoa sohtori tiro cahmana”, ni buhemana mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Capari ñʉeraina ti ñʉ masieraro seheta masieraina jira mʉsa. ¿Di sehe tí waro jijari, mʉsa tʉhotuchʉ? Cohamacʉre masʉno to ño payoro to wari cjiri tí waro jiera curera. Tí mesa bui Cohamacʉre to wachʉ, noaa wahara tí mesa bui jia. Ã jiro tí mesa sehe wiho jiri mesa jierara. Cohamacʉre ño payoa ti wari bui curero noari mesa jira. ");
INSERT INTO gvc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ã jiro “Cohamacʉ wʉhʉ macari mesa mehne yʉ nino seheta yoaihtja”, cʉ̃iro nino, tí mesa bui macaa to wari mehne tiro ã nino nica. Ã jia mʉsa buhea sehe tó wahaerara. ");
INSERT INTO gvc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Cohamacʉ wʉhʉ mehne yʉ nino seheta yoaihtja”, cʉ̃iro nino, potocãta Cohamacʉ mehneta ã ninota nica. Cohamacʉ tí wʉhʉ macariro jira. ");
INSERT INTO gvc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ã jiro “Mʉano mehne yʉ nino seheta yoaihtja”, cʉ̃iro nino, Cohamacʉ to jiropʉ mehneta ã nino nica. Ã jiro Cohamacʉ mehneta ã nino nica. Tiro sehe tó macariro jira. Ã jia mʉsa buhea sehe tó wahaerara. ");
INSERT INTO gvc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Mʉsa judio masare buheina, fariseo curua macaina cʉ̃hʉ ñano yʉhdʉnahca. Mahñopeina jira mʉsa. Moa yoaro sehe jiare chʉare coachʉ yoaare cjʉana mahanocã wamana mʉsa. Cohamacʉre ño payona tana sacerdoteare wamana mʉsa. Mahanocã wamana mʉsa. Menta, anis, comina wama tia coachʉ yoaare wamana mʉsa. Ã wapanahtja noaare yoaerara mʉsa. Tuhsʉ, masare pja ñʉerara mʉsa. Ã yoa Cohamacʉre wacũ tuaerara mʉsa. Toaa dichare mʉsa narire mahanocã sacerdoteare mʉsa wachʉ noa nina. Ã wana õ sehe yoa namoga: Noaare yoaga. Ã yoa pja ñʉga masare. Tuhsʉ, Cohamacʉre wacũ tuaga. ");
INSERT INTO gvc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Capari ñʉeraina ti capari ñʉeraro seheta masieraina jira mʉsa. Õ sehe yoara mʉsa: Mʉsa ya dutiare yoa dutina, wiho jia waro dutiare yoara mʉsa. Ã yoapanahta Cohamacʉ to pototi to dutia warore yoaerara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Mʉsa judio masare buheina, fariseo curua macaina cʉ̃hʉ ñano yʉhdʉnahca mʉsa. Mahñopeina jira mʉsa. Mʉsa waparire, mʉsa sihnia wahwarire bui mʉsa cosaro seheta noaare yoa ñomana mʉsa buicã warohna. Ã yoapanahta Cohamacʉ yare quihõno yoaerara mʉsa. Paina yare maina, mʉsa basi dihta bʉjʉare na duaina jina, ã dihta tʉhotura mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Capari ñʉeraina ti ñʉ masieraro seheta masieraina jira mʉsa fariseo curua macaina. Ñaare mʉsa tʉhotuare cohtotaga. Mʉsa ã yoana masa ti ñʉrocaroi noaina jinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Mʉsa judio masare buheina, fariseo curua macaina cʉ̃hʉ ñano yʉhdʉnahca. Mahñopeina jira mʉsa. Masa copa, yehsea mehne ti wisõri copa yoaro sehe jira mʉsa. Masa tí copare ti ñʉchʉ noari copa bajura. To ã bajupachʉta, puhicha macariro baarirore, to cohãrine, ñaare ñʉerara tina. ");
INSERT INTO gvc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tó seheta mʉsa cʉ̃hʉ masa ti ñʉrocaroi noaina sehe bajumana mʉsa. Ã noaina sehe bajuina mʉsa jipachʉta mʉsa tʉhotuapʉ ñaa, mahñoa ji yʉhdʉara yariaina yoaro seheta —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ã ni tuhsʉ õ sehe ni namore tinare: —Mʉsa judio masare buheina, fariseo curua macaina cʉ̃hʉ ñano yʉhdʉnahca. Mahñopeina jira mʉsa. Cohamacʉ yare yahu mʉhtaina cjiri panopʉ macaina ti masa coparire noano cahnomana mʉsa. Tuhsʉ, noano yoaina cjiri ti masa coparire noano cahnomana mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ã yoana õ sehe nirucumana mʉsa: “Panopʉre sã ñʉchʉsʉma cjiri ti yoariro sehe sã sehe yoaeraboa. Tí pjapʉ jiinare Cohamacʉ yare yahu mʉhtaina cjirire sã wajãeraboa”, nirucumana mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ã nina mʉsa ñʉchʉsʉma cjiri Cohamacʉ yare yahu mʉhtainare wajãrina cjiri ti jiri cjirire bajuro wana nica. Tinare wajãrina cjiri panamana ji turiaina mʉsa jia cʉ̃hʉre bajuro wana nica mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mʉsa ñʉchʉsʉma cjiri ti yoariro seheta yoa sohtori tiwahnoga. ");
INSERT INTO gvc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Agãa ñima tiina yoaro sehe ñabiaina jira mʉsa. Mʉsa ñaa tʉhotumari cjirire cohtota duaerana Cohamacʉ mʉsa ñaa buhirire pichacapʉ mʉsare to cohãhto pano duhti masierara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ã jii mʉsare niita nija. Cohamacʉ yare yahu mʉhtainare, paina noano masiinare, paina mʉsare buhehtinare mʉsa cahai warocaihtja. Yʉ ã warocachʉ mʉsa sehe cãina tinare wajãnahca. Painare crusapʉ cjã puhanahca. Painare mʉsa buhea wʉhʉsepʉ tjananahca. Ã yoana macaripepʉ tinare ñano yoa, mʉroca nʉnʉ tinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mʉsa ã yoana jipihtina ñaa marieinare mʉsa wajãri buhiri buhiri tinahca. Noariro Abe cjirore Caĩ to wajãri buhiri jipihtina mʉsa cʉ̃hʉ buhiri tinahca. Jipihtina to baharo jiinare noainare ti wajãri buhiri cʉ̃hʉre buhiri tinahca mʉsa cʉ̃hʉ. Ã yoa Cohamacʉ wʉhʉ cahai wahiquinare ti wari mesa cahai Zacariare wajãre tina. Tiro sehe Berequias macʉno jire. Ã jina Zacaria cʉ̃hʉre ti wajãri buhiri buhiri tinahca mʉsa cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Potocã mʉsare yahuita nija. Tina jipihtinare ti wajãri buhiri mipʉ macaina cʉ̃hʉ mʉsa buhiri tinahca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ã ni tuhsʉ õ sehe ni namore: —Cue, Jerusalẽ macaina, Cohamacʉ yare yahu mʉhtaina cjirire wajãrina jira mʉsa. Mʉsa coyea panopʉ macaina cjiri cʉ̃hʉ ãta yoarina cjiri jiha. Ã yoa mʉsa cahai to warocaina cjirire tãa mehne doca wajãrina jira mʉsa. Caracacoro to pohnare to cjã mʉa dʉpʉri mehne to moha coãno seheta payʉ tahari cahĩrucumahi mʉsare. Mʉsare cahmamahi. Mʉsa sehe yʉhʉre ne cahmaerare. ");
INSERT INTO gvc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mipʉre mʉsa ya maca cohãri maca cjiro jirohca. ");
INSERT INTO gvc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Potocã mʉsare niita nija. Baharopʉ taihtja yʉhʉ. Ã yʉ tachʉ ñʉna mʉsa yʉhʉre “Cohamacʉ tuaa mehne tariro noano tajaro”, ninahca. Yʉhʉre mʉsa tíre nihto pano yʉ tjua tahto pano pari turi yʉhʉre ñʉsi mʉsa —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ã yoa Cohamacʉ wʉhʉi jiriro Jesu to wijaa wihichʉ sã to buheina tí wʉhʉre tí wʉhʉ cahai jia wʉhʉse cʉ̃hʉre ñʉna: —Ahri wʉhʉse jira. Ñʉga mʉhʉ cʉ̃hʉ —nii sã tirore. ");
INSERT INTO gvc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesu õ sehe ni yʉhtire: —Ahri wʉhʉsere mipʉre ñʉmana mʉsa. Mʉsare yahuita nija. Ahri wʉhʉsere jipihtia mʉsa ñʉri cjiri ahri wʉhʉse macaa tãa cʉ̃hʉ cohõ pihtia wahaahca. Ne cʉ̃ria tãca tjuasi —nire tiro sãre. ");
INSERT INTO gvc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Baharo Olivo wama tidʉ tʉ̃cʉpʉ sʉ, tópʉ dujire Jesu. Tói to dujichʉ sã to buheina sã sahsero tiro cahapʉ sʉ, õ sehe ni sinitu ñʉhi: —Yahuga sãre. ¿Dohse jichʉ ã waharohcari mʉ niriro sehe waharo? ¿Pihtiri dacho panocãre to jichʉ cʉ̃hʉre, mʉ tjua tahto cʉ̃hʉre dohse to waha dʉcachʉ ñʉnahcari sã? —ni sinitu ñʉi sã. ");
INSERT INTO gvc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu õ sehe ni yʉhtire: —Noano yoaga mʉsa. Mʉsare paina ti mahñoare tʉhoena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Payʉ masa “Cristo jija yʉhʉ”, ni mahñoina taahca. Ti ã mahñochʉ tʉhoa payʉ masa Cohamacʉ yare duhuahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mʉsa cahacãi masa paina ti cahma wajãchʉ tʉhonahca mʉsa. Tuhsʉ, yoaropʉ cʉ̃hʉre ti cahma wajãchʉ tʉhorocanahca mʉsa. Ã tʉhopanahta ne tíre pjíro tʉhotuena tjiga. Ã waharohca. Ti ã yoachʉ pihtiri dacho cjihto dʉhsasininohca mini. ");
INSERT INTO gvc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tí pjare cʉ̃ yahpa macaina pa yahpa macaina mehne cahma wajãahca. Ã yoa cʉ̃iro pʉhtoro yaina pairo pʉhtoro yaina mehne cahma wajãahca. Tuhsʉ, payʉ masa jʉca mehne yariaahca. Ã yoa dohatia payʉ jiahca. Tuhsʉ, pjaró yahpa ñuhminohca. ");
INSERT INTO gvc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","To ã wahachʉ ahri yahpa macainare ti ñano yʉhdʉ namohto dʉhsasinina mini. Ñano yʉhdʉsiniahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Tí pjare paina mʉsare ñaha, ñano yoa dutia waahcʉ mʉsare paina pʉhtoapʉre. Ti ã wachʉ mʉsare wajãahca. Yʉ yaina mʉsa jiri buhiri jipihtina mʉsare ñʉ tuhtiahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tí pjare payʉ yʉ yaina jimarina cjiri yʉhʉre cohãahca. Ã jia tina mehne macainare tina ñʉ tuhtiahca. Ã yoaa tina mehne macaina ti jipachʉta tinare ñano yoahtinare waahca tina. ");
INSERT INTO gvc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tí pjare payʉ “Cohamacʉ yare yahu mʉhtaina jija”, ni mahñoina jiahca. Ã jia payʉ masa ti mahñoare tʉhoahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tí pjare ñabiaro yoaahca masa. Ã yoaa tina mehne macainare cahĩ namosi. ");
INSERT INTO gvc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ã jina mʉsa tuaina jina, ahri yahpai mʉsa catisinino puro cʉ̃no pjarucuna, yʉhdʉnahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tuhsʉ, ahri noaa buhea jipihtiropʉ ahri yahpapʉre ti yahua buhea jiahca. Pʉhtoro Cohamacʉ to sʉho jiare yahuri buheare ti yahu siteri jiahca, jipihtina tí buheare ti masihto sehe. Ti ã yahuri baharo pihtiri dacho dʉcarohca. ");
INSERT INTO gvc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Cohamacʉ yare yahu mʉhtariro Daniel cjiro panopʉ macariro ñabiarirore Cohamacʉ yare ñano yoarirore yahua tiha panopʉre. Tí pjare tiro ñariro sehe Cohamacʉ wʉhʉpʉ to ducuchʉ ñʉnahca mʉsa. Ahri yʉ nirire noano masiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tói to ducuchʉ ñʉa, Judea yahpapʉ jiina sehe tʉ̃yucʉ cahapʉ mʉroca duhtijaro. ");
INSERT INTO gvc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Soaro mehne mʉroca duhtijaro. Tí pjare ti wʉhʉseri bui macaa waparipʉ jiina wʉhʉ puhichapʉ jiare ti yare na wahaea tjijaro ti waha bahrañohto sehe. ");
INSERT INTO gvc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tuhsʉ, tí pjare paina ti weseripʉ jiina ti bui macaa suhti wʉhʉpʉ jia suhtire na wahaea tjijaro ti waha bahrañohto sehe. ");
INSERT INTO gvc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tí pjare nijipocosanumia, ti pohnare pũa numia cʉ̃hʉ pjacʉoro wahaahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ã jina Cohamacʉre õ sehe ni siniga: “Puhiro jichʉ judio masa sã soa nʉmʉri jichʉ cʉ̃hʉre sã mʉroca duhtihti dacho jiero tjijaro”, ni siniga mʉsa Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tí dachorire masa nu ñano wahaahca. Ahri yahpare to bajuamehneri baharo masa ñano ti yʉhdʉa jisinia tiha. Ti ã jipachʉta jipihtia tí purĩa yʉhdoro pihtiri dacho panocã ñabiaro yʉhdʉahca masa. Ã ñano ti yʉhdʉri baharo pari turi tó sehe ñabiaro yʉhdʉsi ahri yahpai jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cohamacʉ tí dachorire mahaa dachoricã jisinichʉ yoarohca. To ã yoaerachʉ ne cʉ̃iro masʉno yʉhdʉeraboca. Ã jiro to beserina ti yʉhdʉhti cjihtire mahaa dachoricã ã cũsininohca Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Tí pjare paina mʉsare “Ñʉga. Õi jira Cristo”, ti nichʉ tinare tʉhoena tjiga. “Tói jira Cristo”, ti nichʉ tinare tʉhoena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“Cristo jija”, ni mahñoina, “Cohamacʉ yare yahu mʉhtaina jija”, ni mahñoina jiahca tí pjare. Ã jia Cohamacʉ to beserinare mahñoa, tina bajuamehneare yoa ñoahca. Ti ã yoa ñochʉ ñʉa, Cohamacʉ yaina cãina tinare tʉhoa “Potocã tjira” nia, Cohamacʉ yare pa tehe nia duhuboca. ");
INSERT INTO gvc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ahri jipihtiare mʉsare yahuyuja mʉsare to ã wahahto pano. Ã jina tʉhoga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Paina masa mʉsare “Ñʉga. Masa marienopʉ jira Cristo”, ti nichʉ tópʉre ñʉna wahaena tjiga. Ã yoa tina “Õi ahri tahti pocai jira tiro”, ti nichʉ tinare tʉhoena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yʉhʉ masʉno Cohamacʉ warocariro wacũenoca tjua taihtja. Oroca sitero mʉanore sʉ̃ mʉja taropʉ, sʉ̃ sãnopʉ wacũenoca to oroca siterocaro seheta wacũenoca tjua taihtja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yucaare mari ñʉna, yariariro to pjacʉ cjiro jichʉ mari noano masinahca. (Tó seheta ahri mʉsare yʉ yahuyurire mʉsa ñʉna noano masinahca ahri yahpapʉ yʉ tjua tahto mahanocã to dʉhsachʉ cʉ̃hʉre) —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ã yahu tuhsʉro tinare õ sehe ni yahu namore: —Tí dachori masa ti ñano yʉhdʉa dachori baharo sʉ̃ dacho macariro, ñami macariro cʉ̃hʉ buhria duhua wahaahca. Ti ã wahachʉ ñahpichoha poca mʉanopʉ jia poca boraa wahaahca. Tuhsʉ, mʉano macaa yahpari tuaro ñuhmiahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tí pjata yʉhʉ masʉno Cohamacʉ warocariro mʉanopʉ yʉ bajuamehnenore yʉ ñochʉ ñʉahca masa. Ã ñʉa jipihtia curuari macaina tiiahca. Tuhsʉ, yʉ tuaa mehne, yʉ si sitea mehne mʉano macaa me bui ahri yahpapʉre yʉ tjua tachʉ ñʉahca tina. ");
INSERT INTO gvc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Corneta bisiro coa tarohca. To ã coa tachʉ yʉ yaina anjoare jipihtiropʉ ahri yahpapʉ warocaihtja. Tuhsʉ, jipihtiropʉ yʉ yaina yʉ beserinare tina naahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Mipʉre higueracʉre tʉhotuga mʉsa. Tʉ quiti mehne mʉsare piti dahre buheihtja. Tʉ yucʉcʉ pũri tichʉ ñʉna, cʉhma mahanocã to dʉhsachʉ masina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tó seheta ahri jipihtia yʉ niri cjirire ti ã wahachʉ ñʉna, yʉ tjua tahto mahanocã to dʉhsachʉ masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Potocã niita nija mʉsare. Tí pja macaina ti yariahto pano jipihtia yʉ niriro seheta ã waharohca. Mʉano, ahri yahpa cʉ̃hʉ pihtia wahaahca. ");
INSERT INTO gvc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mʉano cʉ̃hʉ ahri yahpa cʉ̃hʉ pihtia wahaahca. Yʉ durucua sehe ne cohtotasi. Jipihtia yʉ niriro seheta ã waha sohtori tiarohca. ");
INSERT INTO gvc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Tí dachore yʉ tjua tahti dachore, tí ora cʉ̃hʉre masieraja yʉhʉ. Anjoa cʉ̃hʉ tíre masierara. Masa cʉ̃hʉ masierara. Yʉ Pʉcʉ dihta tíre masina. ");
INSERT INTO gvc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Noé to jiri pja macaina ti jiriro seheta ahri yahpapʉ yʉ tjua tahto panocãre tó seheta jiahca masa. ");
INSERT INTO gvc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yahpa to minihto pano masa chʉ, sihni, yoaha. Tuhsʉ, mʉa, numiare namo tiha. Noé cʉ̃hʉ ti dohoriapʉ ti samuhto pano ã yoaa timaha masa. ");
INSERT INTO gvc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dóihta tuaro coro ta, wacũenoca yahpa minia wahaha. Masa cʉ̃hʉ mini pihtia wahaha. Wacũenoca to miniriro seheta yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉre wacũenoca tjua taihtja. ");
INSERT INTO gvc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tí pjare wesepʉ pʉaro dahraina ti jichʉ cʉ̃iro yʉhʉre cahmarirore naaihca. Ã yoa yʉhʉre cahmaerariro tói tjuarohca. ");
INSERT INTO gvc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tí pjare pʉaro numia cʉ̃noi ti yore arẽa numia jichʉ cʉ̃coro yʉhʉre cahmaricorore naaihca. Ã yoa yʉhʉre cahmaeraricoro tóihta tjuarohca. ");
INSERT INTO gvc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Noano wacũ masi cohtaga. Yʉhʉ mʉsa pʉhtoro, yʉ tjua tahti dachore ne masierara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ahrire wacũga mʉsa. Yacariro to wʉhʉpʉ to sãa yacahto panore wʉhʉ pʉro masino, tí ñamine tiro carĩeraboa, yacarirore cohtaro taro. Ã yoa yacarirore to wʉhʉpʉ sãa dutieraboa. Yʉhʉ yacariro to wacũenoca to tariro seheta wacũenoca taihtja. ");
INSERT INTO gvc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ã jina yʉ yare ã yoarucuna yʉhʉre cohtaga. Yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉ tjua tai wacũenoca taihtja —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ã yoa Jesu to tʉhotua mehne õ sehe ni piti dahre buhe namore tjoa: —Dahra cohtariro to pʉhtorore ño payoriro tʉho masiriro jira. To ã jichʉ ñʉno paina dahra cohtaina bui cũna tirore to pʉhtoro sehe waharo taro. Ã tirore cũ tuhsʉ wahaa wahara pʉhtoro. To ã wahachʉ ñʉno, chʉri pja jichʉ dahra cohtariro painare chʉare witira. ");
INSERT INTO gvc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Baharo pʉhtoro to ya wʉhʉi tju wihira. To tju wihichʉ ñʉno dahra cohtariro sehe to pʉhtoro to dutiriro seheta yoa pahñoriro jiro, wahcheriro jirohca. ");
INSERT INTO gvc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Potocã mʉsare niita nija. To ã noano dahrachʉ ñʉno to pʉhtoro jipihtia to yare ñʉ wihbohtiro cũnohca tirore. ");
INSERT INTO gvc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Wiho mejeta ñariro dahra cohtariro sehe “Yʉ pʉhtoro so bajuerara” nino, paina dahra cohtainare cjãpe, pjíro chʉ, sihni, cahaina mehne caharohca. ");
INSERT INTO gvc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Baharo to pʉhtoro wacũenoca tjua tarohca. Tí dachore ne masierara dahra cohtariro. ");
INSERT INTO gvc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pʉhtoro sehe tjua taro ñariro to yoarire tʉhoro, tirore tuaro buhiri dahrerohca. Ã buhiri dahrero, masa ti baharo bʉhʉsehei ñano yoa cohtaina ti waharopʉ cohãnohca tirore. Tópʉre tiro tuaro tii, cahyaro mehne bahca dihorohca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ã yoa Jesu pari turi to tʉhotua mehne õ sehe ni piti dahre buhe namore tjoa: —Mʉano macariro masa bui pʉhtoro to sʉho jia ahri quiti yoaro sehe jira: Diez nuhmia jiha. Cʉ̃ ñami tina ti sihãa poca mehne wamomaca dʉhtehtirore piti bocaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tina mehne macaa numia cinco numia tʉho masiera numia jiha. Paye numia sehe cinco numia tʉho masia numia jiha. ");
INSERT INTO gvc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tʉho masiera numia sehe ti sihãa pocare, posa tia pocare naamaha. Paye pocare se posa tia pocare ti pihtichʉ ti pioborire naaeraha. ");
INSERT INTO gvc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tʉho masia numia sehe ti sihãa poca se posa tia pocare naaha. Paye se poca cʉ̃hʉre naaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ã jia wamomaca dʉhtehtiro to bajuerachʉ tí numiare wʉjo purĩchʉ carĩa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ã ti carĩni baharo ñami dacho macai sañurucuro coa taha: “Tʉhoga. Wamomaca dʉhtehtiro taro coa tara. Tirore piti bocana taga”, ni sañurucuro coa taha. ");
INSERT INTO gvc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","To ã nino coa tachʉ tʉhoa tí numia wahcã, ti sihãa pocare cahnoha. ");
INSERT INTO gvc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ã yoaa tʉho masiera numia sehe paye numia tʉho masia numiare õ sehe niha: “Sã sihãa poca yatia nina. Ã jina mahanocã mʉsa ya sere waga sãre”, ni sinimaha tí numia. ");
INSERT INTO gvc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ti ã sinipachʉta tʉho masia numia õ sehe ni yʉhtiha: “Sã ya se mari jipihtinare mʉ sʉeraboca. Ã jina se cjʉainare mʉsa basi nuchʉna wahaga”, ni yʉhtiha tʉho masia numia sehe. ");
INSERT INTO gvc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ti ã nichʉ tʉhoa, tʉho masiera numia sere nuchʉa wahaha. Ti ã wahari baharo wamomaca dʉhtehtiro wihiha. Ã to wihichʉ ñʉa ti yare cahno tuhsʉri numia tʉho masia numia tirore piti bocaha. Piti boca, to wamomaca dʉhteri bose nʉmʉpʉ tiro mehne ñʉa wahaha. Tuhsʉ, bose nʉmʉre ti yoari wʉhʉpʉ paina mehne tí numia ti sãari baharo, sopacare bihanocaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Baharopʉ tʉho masiera numia sehe wihimaha. “Pʉhtoro, sãre pjõohga”, nimaha tí numia. ");
INSERT INTO gvc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Potocã mʉsare niita nija. Mʉsare masieraja yʉhʉ”, niha tiro tí numiare. ");
INSERT INTO gvc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Ã jina tʉho masia numia ti yare ti noano cahno tuhsʉ ti cohtariro seheta yʉ tahtore noano cohtaga mʉsa cʉ̃hʉ. Yʉ tjua tahti dachore tí hora cʉ̃hʉre ne masierara mʉsa —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ã ni yahu tuhsʉ to tʉhotua mehne õ sehe ni piti dahre buhe namore tjoa: —Tí pja yʉ tjua tahti pja ahri quiti yoaro sehe jirohca. Wʉhʉ pʉro jiha. Tiro pa sehepʉ tinino waharo taro, tirore dahra cohtainare pjirocaha. Ã yoaro tinare to yare cohta dutiha. ");
INSERT INTO gvc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ã cohta dutiro ti wihbo masino puro tinare niñeru tʉrire waha. Cʉ̃irore cinco tʉri wapa bʉjʉa tʉri uru tʉrire waha. Pairore pʉa tʉ waha. Pairore cʉ̃ tʉ waha. Tinare wa tuhsʉ, wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ã yoa cinco tʉri to wariro dóihta to wahari baharota tí tʉri mehne paye barore nuchʉha. To nuchʉrire painare duaha. To duari wapa diez tʉri waro wapataha tiro. Ã jiro diez tʉri cjʉaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ã yoa pʉa tʉ to wariro dóihta to wahari baharota tí tʉri mehne paye barore nuchʉha. To nuchʉrire painare duaha. To duari wapa pititia tʉri waro wapataha tiro. Ã jiro pititia tʉri cjʉaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Cʉ̃ tʉre to wariro sehe copa saha, tí tʉre yaha, tí copapʉ nʉono. ");
INSERT INTO gvc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Yoari pja baharo ti pʉhtoro wihiha. Ã wihiro to niñeru tʉri mehne ti ñaha namorire quihõno taro tirore dahra cohtainare pjirocaha. ");
INSERT INTO gvc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ã to pirocachʉ cinco tʉri to wariro cjiro to pʉhtoro cahapʉ sʉ, diez tʉri wiaha tirore. “Cinco tʉri yʉhʉre ware mʉhʉ. Ñʉjʉta. Tí tʉri mehne paye cinco tʉrire ñaha namohi”, niha tirore. ");
INSERT INTO gvc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Noano yoari jire mʉhʉ. Mʉhʉ noariro, yʉ dutiriro seheta yoariro jira. Mahanocã mehne noano yoare mʉhʉ. Ã jicʉ mipʉre mʉhʉre pjíro mʉ dahrahtore cũihtja. Ã jicʉ yʉhʉ mehne wahchega mʉhʉ”, niha to pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ã yoa pʉa tʉre nariro cjiro to pʉhtoro cahapʉ sʉ, yahuha tirore: “Pʉa tʉ yʉhʉre ware mʉhʉ. Ñʉjʉta. Tí tʉri mehne paye tʉri pʉa tʉ ñaha namohi”, niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Noano yoari jire mʉhʉ. Mʉhʉ noariro, yʉ dutiriro sehe yoariro jira. Mahanocãre noano yoare mʉhʉ. Ã jicʉ mipʉre pjíro mʉ dahrahtore cũihtja. Ã jicʉ yʉhʉ mehne wahchega mʉhʉ”, niha to pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ã yoa cʉ̃ tʉre nariro cjiro to pʉhtoro cahapʉ sʉ, yahuha tirore: “Pʉhtoro, mʉhʉ paina sehere tuaro dahra dutiriro jira. Ã tuaro dahra dutiriro jicʉ toaa maerariro jipaihta tí dichare mʉhʉ nana. ");
INSERT INTO gvc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mʉ ã jiriro jichʉ mʉhʉre cuihi. Ã cuicʉ copa saha, tí copapʉ mʉ niñeru tʉre nʉohi. Ñʉjʉta. Õi jira mʉ niñeru tʉ”, niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","To pʉhtoro to ã nichʉ tʉhoro tirore õ sehe niha: “Mʉhʉ ñariro, capa bʉjʉriro jira. Yʉ toaa maerariro jipaihta tí dichare yʉ nariro jichʉ masina mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yʉ ã jiriro jichʉ ñʉcʉ ya tʉre niñeru wihbori wʉhʉpʉ wihboboa mʉhʉ. Mʉ ã wihbochʉ tina tí tʉre wiaapʉ paye niñeru wa namoboa tina”, niha pʉhtoro tirore. ");
INSERT INTO gvc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ã nino paina tirore dahra cohtainare dutiha tiro: “Niñeru tʉre maga tirore. Diez tʉrire cjʉariro sehere waga. ");
INSERT INTO gvc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Cjʉainare wa namoihtja. Ã jia pjíro cjʉaahca. Cjʉaeraina sehere mahanocã ti cjʉapachʉta tíre maihtja. ");
INSERT INTO gvc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ahriro dahra cohtariro yaba cjihti jierara. Nahitianopʉ ñanopʉ cohãnocahga tirore. Tópʉ tiro tuaro tii, cahyaro mehne bahca dihorohca”, niha pʉhtoro —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ã yoa Jesu õ sehe ni yahu namore: —Yʉhʉ masʉno Cohamacʉ warocariro jipihtina anjoa mehne pʉhtoro jicʉ tacʉ, yʉ pʉhtoro dujiropʉ yʉ si sitea mehne dujiihca. ");
INSERT INTO gvc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ã yʉ dujichʉ, ahri yahpa macaina jipihtina yʉ cahai cahmachuahca. Ti ã cahmachuri baharo pʉa curua tinare tju waihtja. Ovejare ñʉ wihboriro to ovejare, to cabra cʉ̃hʉre to tju wariro seheta masare tju wa dapoihtja. ");
INSERT INTO gvc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ã tju wacʉ oveja yoaro sehe jiina noainare yʉ poto bʉhʉsehei bese dapoihtja. Ã yoa cabra yoaro sehe jiinare ñainare yʉ cõ bʉhʉsehei bese dapoihtja. ");
INSERT INTO gvc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yʉ ã yoari baharo yʉhʉ jipihtina bui pʉhtoro sehe yʉ poto bʉhʉsehei yʉ bese dapoinare õ sehe ni yahuihtja: “Yʉ Pʉcʉ mʉsare noano yoare. Ahri yahpare bajuamehnenopʉ mʉsa ya cjihtire pʉhtoro to sʉho jirore cahno basayu tuhsʉre Cohamacʉ. Ã jina mipʉre to cahnoriropʉre jina taga. ");
INSERT INTO gvc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ jʉca baachʉ mʉsa sehe yʉhʉre chʉare ware. Yʉ ñahma yapiochʉ yʉhʉre mʉsa sihõre. Mʉsa cahai yʉ tinichʉ yʉhʉre ñʉ masierapanahta yʉhʉre noano piti bocare mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Suhti maerariro yʉ jichʉ ñʉna mʉsa sehe yʉhʉre suhti sãare. Dohatiriro yʉ jichʉ mʉsa yʉhʉre ñʉna tare. Peresui yʉ jichʉ cʉ̃hʉre yʉhʉre ñʉna tare mʉsa”, niihtja noainare. ");
INSERT INTO gvc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yʉ ã nichʉ tʉhoa tina yʉhʉre sinituahca: “¿Pʉhtoro dohse jichʉ mʉ jʉca baachʉ mʉhʉre chʉare wari sã? ¿Dohse jichʉ mʉ ñahma yapiochʉ mʉhʉre sihõri sã? ");
INSERT INTO gvc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Dohse jichʉ mʉhʉre ñʉ masierapanahta mʉhʉre noano piti bocari sã? ¿Dohse jichʉ suhti maerariro mʉ jichʉ mʉhʉre suhti sãari sã? ");
INSERT INTO gvc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Dohse jichʉ mʉ dohatichʉ o peresui mʉ jichʉ cʉ̃hʉre mʉhʉre ñʉna sʉri sã?” niahca yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ti ã ni sinituchʉ tʉhocʉ yʉhʉ pʉhtoro tinare yahuihtja. “Potocã mʉsare niita nija. Ahrina yʉ yaina mehne macariro wiho jiriro to jipachʉta, tirore mʉsa tó seheta yoare. Ã jirirore ã yoana, yʉhʉre yoaro seheta yoana nire mʉsa tinare”, ni yahuihtja. ");
INSERT INTO gvc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Noainare yʉ ã ni yahuri baharo yʉ cõ bʉhʉsehei ducuinare yʉhʉ jipihtina bui pʉhtoro õ sehe ni yahuihtja: “Cohamacʉ to buhiri dahrehtina jira mʉsa. Yʉhʉ mehne tjuaena tjiga. Pichacapʉ wahaga mʉsa. Tí pichaca ne yatierara. Watĩno, to yaina anjoa cʉ̃hʉ ti jihtore tí pichacare yoare Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ jʉca baachʉ mʉsa sehe yʉhʉre chʉare waerare. Yʉ ñahma yapiochʉ mʉsa yʉhʉre sihõerare. ");
INSERT INTO gvc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yʉhʉre masierana mʉsa yʉhʉre piti bocaerare. Ã ñʉnocaboare. Suhti maerariro yʉ jipachʉta, yʉhʉre suhti sãaerare mʉsa. Dohatiriro yʉ jichʉ peresui yʉ jichʉ cʉ̃hʉre ã ñʉnocare mʉsa yʉhʉre”, ni yahuihtja tinare ñainare. ");
INSERT INTO gvc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yʉ ã nichʉ tʉhoa tina yʉhʉre sinituahca: “¿Pʉhtoro, mʉ jʉca baachʉ, mʉ ñahma yapiochʉ, sã masierariro mʉ jichʉ, suhti maerariro mʉ jichʉ, dohatiriro mʉ jichʉ, peresupʉ mʉ jichʉ dohse jichʉ sã sehe mʉhʉre yoadohoerari?” ni sinituahca yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ti ã ni sinituchʉ yʉhʉ tinare õ sehe ni yahuihtja: “Potocã mʉsare niita nija. Ahrina yʉ yaina mehne macariro wiho jirirore mʉsa ne yoadohoerare. Ã jirirore mʉsa yoadohoerana, yʉhʉreta ã yoana nire mʉsa”, ni yahuihtja tinare. ");
INSERT INTO gvc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ã jiro tinare ã buhiri dahrerucurohca Cohamacʉ. Tí buhiri dahrea ne pihtisi. Ã yoa, noaina sehe jipihtia dachoripe noano jirucuahca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tí jipihtiare to buheri baharo Jesu sãre to buheinare õ sehe ni yahure: ");
INSERT INTO gvc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pʉa dacho baharo pascua jirohca. Tíre mʉsa masina. Tí pjare yʉhʉ masʉnore Cohamacʉ warocarirore ñahaahca. Ñaha tuhsʉ, yʉhʉre crusapʉ wajãahca —nire tiro sãre. ");
INSERT INTO gvc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ã yoa sacerdotea pʉhtoa, judio masa bʉcʉna cʉ̃hʉ cahmachuha. Caifa sacerdotea bui pʉhtoro ya wʉhʉi cahmachuha tina. ");
INSERT INTO gvc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tói cahmachu, ti mahñoa mehne Jesure ñaha ti wajãhtore cahma sʉhʉdua niha: ");
INSERT INTO gvc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Bose nʉmʉ jichʉ tirore ñahaena tjijihna, “Masa suari”, nina —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tí pjare Simo cami bʉcʉ baariro cjiro ya wʉhʉi jire Jesu. To jiri maca Betania wama tiri maca jire. ");
INSERT INTO gvc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tí wʉhʉi to chʉro watoi cʉ̃coro numino me sitia na ta, Jesu dapu bui pio payore. Tí me sitia alabastro wama tiriai posa tire. Wapa bʉjʉa co jire. ");
INSERT INTO gvc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","To ã pio payochʉ ñʉna sã Jesu buheina suahi. —¿Dohsearo ahricoro ahri me sitia co wapa bʉjʉare ã yoa sitejari? ");
INSERT INTO gvc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tí me sitiare duaboa. Ã duaro pjíro wapa naboa. Ã nano tí niñerure pjacʉoinare waboa ahricoro —nii sã to buheina. ");
INSERT INTO gvc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sã ã ni suachʉ ñʉno, Jesu õ sehe ni yahure sãre: —Ã niena tjiga ticorore. Yʉhʉre noano yoaro nina. ");
INSERT INTO gvc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pjacʉoina sehe mʉsa mehne ã jirucuahca. Ã jina tina sehere mʉsa wa masina. Yʉhʉ sehe ahri yahpare mʉsa mehne ã jirucusi. ");
INSERT INTO gvc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yʉhʉre ti yahto pano yʉ pjacʉre cahnoyuro, ticoro yʉhʉre pio payore. ");
INSERT INTO gvc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Potocã mʉsare niita nija. Jipihtiro ahri yahpapʉ noaa buheare ti yahuropʉ ahricoro mipʉre to yoarire yahuahca. Ti ã yahuchʉ tʉhoa ticorore masa payʉ wacũahca —ni yahure Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tí pjare cʉ̃iro sã mehne macariro Juda Iscariote sacerdotea pʉhtoa cahapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Sʉ, tinare õ sehe ni sinituha: —¿Jesure mʉsare yʉ ñochʉ noho puro wapanahcari mʉsa? —ni sinituha tinare. To ã nichʉ tina tirore treinta tʉri plata tʉrire waha. ");
INSERT INTO gvc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti ã wari baharo Juda sehe Jesure to ñohti ñamine cohtasiniha. ");
INSERT INTO gvc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bʉcʉaerari pãore ti chʉa nʉmʉri dʉcari nʉmʉi sã to buheina sehe õ sehe ni sinitu ñʉhi Jesure: —¿Mari pascua macaa chʉhtire noho baroi cahnoyu dutirocaijari mʉhʉ sãre? —ni sinitu ñʉhi tirore. ");
INSERT INTO gvc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sã ã nichʉ tiro õ sehe ni yahure sãre: —Jerusalẽpʉ wahaga. Tói jirirore õ sehe ni yahuga: “Marine buheriro to ñano yʉhdʉhti pja mahanocã dʉhsatjiãyuhti. Pascua jichʉ mʉ ya wʉhʉi Jesu sãre to buheinare sʉho chʉhto jiyuhti”, ni yahuga tí wʉhʉ pʉrore —ni warocare Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","To ã ni warocachʉ sãre to dutiriro seheta yoana, pascua jichʉ sã chʉhtore cahnoyui sã. ");
INSERT INTO gvc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ã yoa tí ñamine sã mehne doce to buheina mehne chʉro nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sã chʉro watoi tiro sãre õ sehe ni yahure: —Potocã mʉsare niita nija. Cʉ̃iro mʉsa mehne macariro yʉhʉre ñʉ tuhtiinare ñonohca yʉhʉre —ni yahure tiro sãre. ");
INSERT INTO gvc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","To ã nichʉ tʉhona tuaro cahyana, tirore sinitu ñʉ dʉcai sã cãina jipihtina: —¿Pʉhtoro, yʉhʉta jijari mʉhʉre ñohtiro? —ni sinitui. ");
INSERT INTO gvc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sã ã ni sinituchʉ tiro õ sehe ni yʉhtire: —Yʉ chʉri wapai yʉhʉ mehne soha chʉrirota jira yʉhʉre ñʉ tuhtiinare ñohtiro. ");
INSERT INTO gvc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Panopʉ yʉhʉre ti joariro seheta yʉhʉ masʉno Cohamacʉ warocariro yariaihca. Ã jiro yʉhʉre ñʉ tuhtiinare ñoriro ñano yʉhdʉrohca. Tiro sehe to masa bajuerachʉ noa yʉhdʉaboa. Ñano yʉhdʉeraboa —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","To ã nichʉta tirore ñohtiro Juda õ sehe ni siniture: —Buheriro, ¿mʉhʉre ñohtiro tjijari yʉhʉ? —ni siniture tiro. Jesu õ sehe ni yʉhtire: —Ʉ̃jʉ. Mʉhʉta jira —nire. ");
INSERT INTO gvc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ã ni yahu tuhsʉ sã to buheina mehne chʉro taro nire. Ã yoa Jesu pãore na, Cohamacʉre “Noana”, nire. Ã ni tuhsʉ tíre nuha, sãre to buheinare witire. —Ahrire na, chʉga. Ahri yʉ pjacʉ jira —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ã ni tuhsʉ tiro sihniri wahware na, Cohamacʉre “Noana” ni, sãre ware. —Mʉsa jipihtina ahrire sihniga. ");
INSERT INTO gvc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ahri yʉ di jira. Payʉ masa ti ñaa yoari buhirire cohãcʉ tacʉ yariaihca. Ã yariacʉ yʉ dire cohãihca. Cohamacʉ “Mʉsare yʉhdoihtja”, to ni cũriro mʉ sʉchʉ yʉ ã yʉ yariaro mehne to niriro sohtori tiihca. ");
INSERT INTO gvc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mʉsare niita nija. Yʉ Pʉcʉ pʉhtoro to sʉho jiropʉ mʉanopʉ mʉsa mehne wahma co vinore sihniihtja. Mari ã sihnihto pano ahri co vinore sihni namosi yʉhʉ —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ã jina Cohamacʉre ño payo basana cʉ̃nore basa tuhsʉna tʉ̃cʉ Olivo wama tidʉpʉ sʉi sã. ");
INSERT INTO gvc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tópʉ sã sʉchʉ Jesu sehe sãre õ sehe ni yahure: —Micha ñami yʉhʉre cohã wahcãnahca mʉsa. Õ seheta nina Cohamacʉ to yare ti joari pũi yʉhʉre yahuro: “Ovejare ñʉ wihboriro yoaro sehe jirirore yʉhʉ Cohamacʉ cohãihtja. Yʉ ã cohãchʉ to yaina oveja yoaro sehe jiina duhti site wahcãa wahaahca”, nina Cohamacʉ to yare ti joari pũi. ");
INSERT INTO gvc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ã yoa Cohamacʉ yʉhʉre to masori baharo mʉsa pano Galileapʉ wahayuihca yʉhʉ —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","To ã nichʉ tʉhoro õ sehe nimare Pedro: —Yʉhʉ mehne macaina jipihtina mʉhʉre ti cohã wahcãpachʉta yʉhʉ sehe mʉhʉre ne cohãsi —nimare Pedro tirore. ");
INSERT INTO gvc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu õ sehe ni yʉhtire: —Potocã niita nija mʉhʉre. Micha ñami caraca to duhto pano “Yʉhʉ Jesure masieraja”, niihca mʉhʉ. Tia taha ã niihca mʉhʉ —nire tiro Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","To ã nipachʉta Pedro õ sehe ni yʉhtire: —Mʉhʉ mehne yʉhʉre ti wajã duapachʉta “Jesure masieraja”, ne nisi yʉhʉ —ni yʉhtimare Pedro. Ã jina sã cʉ̃hʉ paina to buheina Pedro to niriro seheta nimai sã Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ã yoa Getsemaní wama tiropʉ Jesu sã to buheina mehne waha, tópʉ sʉ, sãre õ sehe nire: —Õi dujiyusiniga. Mʉsa õi dujiro wato sohõ cureropʉ Cohamacʉre sinii wahai nija —nire tiro sãre. ");
INSERT INTO gvc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ã ni tuhsʉ, Pedrore, pʉaro Zebedeo pohnare tina tiarore pji wahcãre. Pji wahcã tuhsʉ, tiro tuaro cahya, ñano yajeripohna tiha. ");
INSERT INTO gvc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ã cahyaro tó mehne macainare to pji wahcãrinare õ sehe niha: —Tuaro ñano yajeripohna tija yʉhʉ. Yʉhʉre tuaro purĩno seheta tʉhotui nija michapucacã yʉ yariaboro seheta. Sohõ curero wahasinii nija. Õi tjuasiniga. Ã yoa yʉ cʉ̃no potori catiga mʉsa cʉ̃hʉ —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ã ni tuhsʉ mahanocã waha namo, yahpai na tuhcua caha sʉ, Cohamacʉre õ sehe niha: —Mai, yʉ ñano yʉhdʉhtire yoa duaeracʉ yoai tjia. Yʉ ã nipachʉta yʉ cahmano sehe yoai tjia. Mʉhʉ sehe masina. Mʉ cahmano seheta yoaga yʉhʉre —ni siniha tiro Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ã ni tuhsʉ, tiaro to buheina cahapʉ wihimahno, carĩinare boca wihiha tiro. Ã boca wihiro Pedrore õ sehe niha: —¿Cʉ̃ hora waro yʉ cʉ̃no potori cati masierari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Noano yoaga mʉsa. Mʉsa mʉ sʉro quihõno yoa duamana mʉsa. Wiho mejeta mʉsa basi tíre bihoerara. Ã jina Cohamacʉre siniga ñano mʉsa yoaerahto sehe —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ã ni yahu tuhsʉ, pari turi waha, Cohamacʉre õ sehe ni siniha: —Mai, yʉ ñano yʉhdʉhtire yoa duacʉ yoaga yʉhʉre. Mʉ cahmano seheta yoaga —ni siniha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ã ni tuhsʉ, to buheina tiaro buheina cahapʉ pari turi wihiha tjoa. Ã wihiro carĩinareta boca wihiha tjoa. Wʉjo caha yʉhdʉaha tina. ");
INSERT INTO gvc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ã jiro tinare cũnoca, pari turi waha, Cohamacʉre siniha. Tó pano to niriro seheta niha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ã ni tuhsʉ to buheina cahapʉ wihi, tinare õ sehe niha: —¿Carĩ, sosinina nijari mʉsa? Tó purota carĩga mʉsa —niha tiro. Ã ni tuhsʉ, õ sehe ni namoha Jesu: —Tʉhosiniga. Michapucacã yʉhʉ masʉnore Cohamacʉ warocarirore ñainare waahca yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wahcãga. Basa wahana. Ñʉga. Yʉhʉre ñʉ tuhtiinare ñohtiro õi tara —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","To ã nino watoi sã mehne macariro cjiro Juda sehe wihire. Tiro mehne masa payʉ wihire. Tina sacerdotea pʉhtoa, judio masa bʉcʉna cʉ̃hʉ ti warocarina jire. Ñosaa pjĩnine, yucʉ siri cʉ̃hʉre cjʉare. ");
INSERT INTO gvc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wahmanore Jesure ñʉ tuhtiinare ñohtiro masare õ sehe ni yahu quihõ tuhsʉha: —Yʉ wahsupu wihmirirota jirohca mʉsa ñahahtiro. Tirore yʉ wihmiri baharo ñahaga tirore —niha Juda tinare. ");
INSERT INTO gvc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","To ã ni tuhsʉri baharo wihiro, Jesu cahapʉ dói waha bahrañore. —Buheriro, ¿jimajari mʉhʉ? —ni tirore wahsupu wihmire. ");
INSERT INTO gvc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","To ã wihmichʉ Jesu õ sehe nire: —Coyeiro, ¿michapucacã mʉ yoa duarire yoaga? —nire tiro. To ã ni tuhsʉchʉ tina Jesure ñahare. ");
INSERT INTO gvc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ti ã yoachʉ ñʉno Jesu mehne macariro to ñosari pjĩne tʉãwe na, sacerdotea bui pʉhtoro cahamacʉnore to cahmonore dʉte pahrẽnocare. ");
INSERT INTO gvc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","To ã yoachʉ ñʉno Jesu tirore õ sehe ni yahure: —Mʉ ñosari pjĩne wihboga. Painare mʉ ñosachʉ ti ñosa cahmachʉ yariaihca mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yʉ Pʉcʉre yʉhʉre yʉ yoadoho dutichʉ tiro sehe payʉ anjoare doce curuarire yʉ cahai warocaboa tiro. ¿Tíre masierajari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ã yoadohoboriro to jipachʉta tirore yʉhʉre yoadoho dutisi yʉhʉ. Yʉ ã dutierachʉ Cohamacʉ yare ti joari pũ to niriro seheta ã waharohca —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ã ni tuhsʉ masare õ sehe ni yahure tiro: —¿Dohse jiro baro mʉsa ñosaa pjĩni mehne, yucʉ tiri mehne yacarirore ti yoariro seheta mʉsa yʉhʉre ñahana tajari? Dachoripe Cohamacʉ wʉhʉpʉ mʉsare yʉ buhe dujichʉ, mʉsa yʉhʉre ne ñahaerare. ");
INSERT INTO gvc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ã jipachʉta ahri jipihtia ã waharo cahmana Cohamacʉ yare yahu mʉhtaina cjiri ti ni joariro seheta —nire Jesu. Tirore ti ã ñahachʉ ñʉna sã to buheina tirore cohã mʉroca wahcãa wahai sã. ");
INSERT INTO gvc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ã yoa tirore ñaharina cjiri sacerdotea bui pʉhtoro Caifa wama tiriro ya wʉhʉpʉ na sʉha tirore. Tí wʉhʉihta marine judio masare buheina, bʉcʉna cʉ̃hʉ cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tópʉ Jesure ti naachʉ Pedro yoaropʉ tinare ñʉ nʉnʉ tiha. Ã nʉnʉ tiro Caifa ya wʉhʉre dʉcatari sahrĩnore sʉ, tí sahrĩno puhichapʉ sãa wahaha. Sãa sʉ, tí wʉhʉre cohtaina surara mehne dujiha. Jesure ti dohse yoachʉ ñʉno taro niha. ");
INSERT INTO gvc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ã jia sacerdotea pʉhtoa, mari coyea judio masa bʉcʉna, paina pʉhtoa mehne Jesure wajã duti duaa, tiro to quihõno yoaerarire ti yahusãhtire wacũ macamaha. ");
INSERT INTO gvc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wiho mejeta tíre bocaeraha. To quihõno yoaerari mariapachʉta, payʉ masa tirore ti cahmano yahusãmacanocaha. Ã jia pʉaro ti baharo macaina tirore ");
INSERT INTO gvc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","õ sehe ni yahusãha tjoa: —Ahriro õ sehe nire: “Cohamacʉ wʉhʉre cohã masija. Ã cohãcʉ tia nʉmʉ wahaboroi tí wʉhʉre pari turi yoaihtja”, to nichʉ tʉhohi sã —ni yahusãmacanocaha Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ti ã niri baharo sacerdotea bui pʉhtoro wahcãrʉcʉ sʉ, Jesure õ sehe ni sinituha: —¿Ahrina mʉhʉre ti yahusãpachʉta tinare yʉhti cahmaerajari mʉhʉ? ¿Mʉhʉre ti yahusãrire dohse ni yʉhti cahmajari mʉhʉ? —niha pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","To ã nichʉ tʉhoparota Jesu ãta tʉhotunocaha. To ã yʉhtierachʉ ñʉno sacerdotea bui pʉhtoro pari turi sinituha tjoa: —Cohamacʉ catiriro wama mehne potocã niga mʉhʉ. Mʉ ã nierachʉ tiro mʉhʉre buhiri dahrerohca. Yahuga sãre. ¿Cristo Cohamacʉ macʉnota jijari mʉhʉ? —ni sinituha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","To ã nichʉpʉta Jesu õ sehe ni yʉhtiha: —Tirota jija. Mʉsare potocã yahuita nija. Baharo yʉhʉ masʉno Cohamacʉ warocariro yʉ Pʉcʉ jipihtina bui tuariro cahapʉ to poto bʉhʉsehepʉ yʉ dujichʉ ñʉnahca mʉsa. Ã yoa mʉano macaa me bui yʉ tachʉ cʉ̃hʉre ñʉnahca mʉsa —ni yʉhtiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","To ã nichʉ tʉhoro sacerdotea bui pʉhtoro, to basi to sãari suhtirore tʉhrẽnocaha painare “Sua yʉhdʉara”, ni ñʉ masi dutiro. Ã tʉhrẽnocahno õ sehe niha: —Cohamacʉre pjíro ñano durucuro nina ahriro. Ã jina to ñano durucuare tʉho tuhsʉja mari. Ã jia tó peinata yahusãjaro ahrirore. Õihta to ñano durucuchʉ tʉhoja mari. ");
INSERT INTO gvc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Dohse yoanahcari mari mipʉre ahrirore? —ni sinituha tiro paina pʉhtoare. —To ñari buhiri wajãnocano cahmana tirore —ni yʉhtiha tina. ");
INSERT INTO gvc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ti ã niri baharo to wʉhdʉare chahcho puti sihõ mʉja, tirore cjãpe, dota mʉjaha tina. ");
INSERT INTO gvc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tirore cjãpe tuhsʉ, õ sehe nipeha tirore: —¿Diro sehe mʉhʉre cjãjari? Cristo jicʉ ñʉerapaihta yahuga sãre —ni cjãpe dota mʉjaha tina. ");
INSERT INTO gvc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ã yoa tí wʉhʉ cahai jiri wapai noari wapai Pedro sehe dujiha. To ã dujichʉ ñʉno sacerdotea bui pʉhtoro cahamacono tiro cahapʉ sʉro, õ sehe niha: —Mʉhʉ cʉ̃hʉ Jesu Galilea macariro mehne jire —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","To ã nichʉ tʉhoro, Pedro õ sehe niha: —¿Dohse nimacanocaco nijari mʉhʉ? Mʉ nirirore ne masieraja yʉhʉ —niha Pedro ticorore jipihtina ti tʉhorocaroi. ");
INSERT INTO gvc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","To ã niri baharo tí wapa macari sahrĩno sopaca cahapʉ wahaha Pedro. Tói to jichʉ pacoro cahamacono tirore ñʉno, tói jiinare õ sehe niha: —Jesu Nazare macariro mehne jire ahriro cʉ̃hʉ —niha ticoro Pedrore tjoa. ");
INSERT INTO gvc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","To ã nichʉ tʉhoro Pedro õ sehe ni yʉhtiha: —Cohamacʉ mehne potocã nii nija. Tiro mʉ nirirore ne masieraja yʉhʉ —ni yʉhtiha Pedro. ");
INSERT INTO gvc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ã yoa mahanocã baharota tói ducuina Pedro cahapʉ waha, tirore õ sehe niha tjoa: —Potocã tjira. Jesu yaina mehne macariro jira mʉhʉ cʉ̃hʉ. Tina yoaro seheta durucura mʉhʉ —niha tina Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ti ã nichʉ Pedro õ sehe ni yʉhtiha: —Potocã Cohamacʉ mehne nii nija mʉsare. Yʉhʉ potocã yʉ nierachʉ Cohamacʉ yʉhʉre buhiri dahrejaro. Tirore mʉsa nirirore ne masieraja yʉhʉ —ni yʉhtiha tiro tinare. To ã nichʉta caraca duha. ");
INSERT INTO gvc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","To duchʉ tʉhoro Jesu tirore to nirire wacũha. “Caraca to duhto pano ‘Jesure masieraja’, niihca mʉhʉ. Tia taha ã niihca mʉhʉ”, Jesu to niri cjirire wacũha Pedro. Ã wacũno, tí sahrĩno sopacare wijaa, tuaro tiiha. ");
INSERT INTO gvc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ã yoa bohrearopʉ sacerdotea pʉhtoa, mari judio masa bʉcʉna cʉ̃hʉ Jesure ti wajã dutihtore cahma sʉhʉduha. ");
INSERT INTO gvc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ti ã yoari baharo tirore dʉhte, Pilato cahapʉ naa, tirore waha Pilatore. Pilato sehe tí yahpa macaina pʉhtoro jire. ");
INSERT INTO gvc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ã yoa Jesure ti wajã dutichʉ ñʉno Juda sehe Jesure ñoriro tirore to ñori cjirire tuaro wacũ cahyaha. Ã cahyaro treinta tʉri to ñahari niñeru tʉrire wiaro waharo, sacerdotea pʉhtoa cahapʉ, bʉcʉna cahapʉ sʉ, õ sehe niha: ");
INSERT INTO gvc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Jesu mʉsare yʉ ñoriro ñaa marieriro to jipachʉta tina wajã dutire tirore. Ã jicʉ mʉsare tirore ñocʉ ñano yoai nihti yʉhʉ —ni yahuha Juda tinare. To ã ni yahuri baharo tina õ sehe ni yʉhtiha: —Ãta yoawahnojaro. Sãre yaba cjihti jierara tí mʉ ã nia. Mʉhʉ dihta ã ni tʉhotura tíre —ni yʉhtiha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ti ã ni yʉhtiri baharo Cohamacʉ ya wʉhʉi Juda to niñeru tʉrire doca site cũnocaha. Doca site cũnoca, wahaa wahaha. Waha, yuta dare dʉhte yo, to basi wamʉai tju suha, puroca yoja sʉ, yariaa wahaha jʉna. ");
INSERT INTO gvc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ã jia sacerdotea pʉhtoa niñeru tʉrire naa, õ sehe niha: —Ahri niñerure Cohamacʉ wʉhʉ macari caropʉ niñeru wihbori caropʉ mari cũ masieraja. Ahri niñeru mehneta masʉnore wajã dutire. Ã jia mari dutia marine tó sehe jia niñerure wihbo dutierara —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ti ã niri baharo “Õ sehe yoajihna”, ti ni sʉhʉduri baharo dihi biatorire yoariro ya yahpare nuchʉha. Tí tʉri mehne nuchʉha. Pa sehe macaina ti wihi ti yariachʉ ti yahti yahpa cjihtore tí yahpare nuchʉha. ");
INSERT INTO gvc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ã jia tí yahpare “Di yahpa” wamoare masa. Mipʉ cʉ̃hʉre ãta wama tira. ");
INSERT INTO gvc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ahri jipihtia ã wahari jire Jeremía cjiro panopʉ “Ã waharohca”, to ni joariro seheta. Tiro Cohamacʉ yare yahu mʉhtariro cjiro jiha. Õ sehe ni joaa tiha tiro: “Treinta niñeru tʉrire plata tʉrire ‘Tó purota wapanahca tirore sã ñahahtore’, niahca Israe masa. ");
INSERT INTO gvc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ã jia tí tʉri mehne dihi biatorire yoariro ya yahpare nuchʉahca tina. Õ seheta yʉhʉre yoa dutire Cohamacʉ”, ni joaa tiha Jeremía panopʉ. ");
INSERT INTO gvc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ã yoa Pilatore ti wari baharo tiro sehe Jesure õ sehe ni sinituha: —¿Potocãta judio masa ti pʉhtorota jijari mʉhʉ? —ni sinituha Jesure. —Mʉ nino seheta tiro tjija —ni yʉhtiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ã ni yʉhtiparota, sacerdotea pʉhtoa, bʉcʉna cʉ̃hʉ ti yahusãchʉ yʉhtieraha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","To ã yʉhtierachʉ ñʉno Pilato õ sehe ni sinituha: —¿Ahri jipihtia mʉhʉre ti yahusãrire tʉhoerajari mʉhʉ? —ni sinituha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","To ã ni sinitupachʉta Jesu ne cʉ̃ dʉsero yʉhtieraha. To ã yʉhtierachʉ ñʉno Pilato cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cʉhmaripe pascuaripe masa yairo cjihtore cʉ̃iro peresupʉ jirirore Pilato ã wiobasa mʉjaa tiha. Masa ti wio dutirirore wiobasa mʉjaa tiha. ");
INSERT INTO gvc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tí pjare Barrabá wama tiriro peresupʉ jiha. Tirore masia tiha payʉ masa. ");
INSERT INTO gvc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ã yoa ti ã cahmachuchʉ Pilato sehe õ sehe ni sinituha tinare: —¿Diro sehere mʉsare wiobasabocari yʉhʉ? ¿O Barrabá sehere o Jesure Cristo ti nirirore wiobasabocari yʉhʉ? —ni sinituha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesure masa ti cahĩchʉ ñʉa judio masa mari pʉhtoa tirore ñʉ tuhtiha. Ã ñʉ tuhtia tirore waha Pilatore. Ã jiro masa ti cahĩri buhiri judio masa mari pʉhtoa ti ñʉ tuhtirire masino Pilato Jesure wio duamaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ã yoa Pilato masare soro sehe yoainare to beseri pahtai to dujichʉ to namono tirore quiti warocaha: “Micha ñamine Jesure cahãco, tuaro ñano yʉhdʉhi. Ã jicʉ tirore ñaa marierirore ne jiape yoai tjiga mʉhʉ”, ni yahurocaha to namono Pilatore. ");
INSERT INTO gvc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ã jia wahmanopʉre sacerdotea pʉhtoa, bʉcʉna cʉ̃hʉ masare õ sehe ni duti tuhsʉha. “Barrabá sehere wio duti, Jesu sehere wajã dutiga”, ni dutiha masare. ");
INSERT INTO gvc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ã yoa Pilato masare õ sehe ni sinituha: —¿Ahrina pʉarore diro sehere mʉsare wiobasabocari yʉhʉ? —ni sinituha. —Barrabá sehere wiobasaga sãre —ni yʉhtiha. ");
INSERT INTO gvc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Ahriro Jesu Cristo ti niriro sehere dohse yoaihcari yʉhʉ mʉsa ã ni sañurucuchʉ? —ni sinituha tiro. —Crusapʉ cjã puha wajãga tirore —ni yʉhtiha masa jipihtina. ");
INSERT INTO gvc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Yaba barore ñaare yoari ahriro mʉsa ã nichʉ? —ni sinitu namoha tiro. To ã nichʉ tʉhoa tina tuaro mehne sañurucuha: —Crusapʉ cjã puha wajãga tirore —ni sañurucuha masa tirore. ");
INSERT INTO gvc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ti ã ni sañurucuchʉ tʉhoro, tirore ti tʉho duaerachʉ ñʉno “Masa sua, cahmacheboca” nino, yʉhtirota õ sehe yoaha Pilato. Masa ti ñʉrocaroi tiro wamo cosaha. Ã wamo cosaro õ sehe niha: —Ahrirore ñaa marierirore wajãri buhiri ya buhiri jierara. Mʉsa ya buhiri jira —nino wamo cosaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","To ã nichʉ tʉhoa jipihtina masa õ sehe niha: —Ahrirore wajãri buhiri sã, sã pohna cʉ̃hʉ sã ya buhiri jijaro —niha masa. ");
INSERT INTO gvc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ti ã nichʉ tʉhoro Pilato Barrabáre peresupʉ jirirore wio dutiha masa ti cahmarirore. Ã yoa tuhsʉ Jesu sehere yuta dari mehne tjana duti, tirore crusapʉ wajã dutiro wiaha surarare. ");
INSERT INTO gvc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","To ã wiachʉ Pilato ya wʉhʉpʉ to surara Jesure na sʉha. Ã yoaa tina surara jipihtina Jesu cahapʉ cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ã cahmachua to suhtire tjuwe na, pʉhtoro ya suhtiro sehe bajuri suhtirore tirore sãaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ã sãa tuhsʉ, pota sorore yoa tuhsʉ, to dapu bui duhu payoha. Ã duhu payo tuhsʉ, wʉjʉcʉre poto bʉhʉsehe sehe dahra suhaha. Dahra suha tuhsʉ, na tuhcua caha sʉ, bʉjʉpeha tirore: —Noano tagã. Judio masa pʉhtoro noano tagã —ni bʉjʉpeha tirore. ");
INSERT INTO gvc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ã niata tirore chahcho puti sihõ mʉja, ti dahra suhadʉ cjirore tirore tʉãwe na, to dapure cjãha tʉ mehneta. ");
INSERT INTO gvc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ti ã bʉjʉperi baharo ti sãari suhtirore tjuwe na, to ya suhti sehere sãaha tjoa. Sãa tuhsʉ, crusapʉ wajãa taa tirore na wijaaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tirore na wahcã, Simo wama tirirore Cirene macarirore piti boca, tirore Jesu to wʉari crusare wʉa wahcã dutire. ");
INSERT INTO gvc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wʉa wahcã, Gólgota wama tiropʉ sʉre. Gólgota nino, “Dapu cohã”, nino nina. ");
INSERT INTO gvc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tuhsʉ, vinore sʉẽa co ñimaca macaa co mehne ti morea core Jesure wamare tina. Tí core sihni ñʉ, sihnierare tiro. ");
INSERT INTO gvc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ã yoa to suhtire ti tjuwe nari baharo tirore crusapʉ cjã puhare tina. Ã cjã puha tuhsʉa, to sãa suhti cjirire ti basi cahma witia taa, “¿Noa yaro jirohcari õ?” ni masia taa, docapea poca mehne docape mʉjaha tina. Ã yoaa Cohamacʉ yare yahu mʉhtariro cjiro to ni joariro seheta yoaa nire tina. Õ sehe ni joaa tiha tiro: “Yʉ suhtire ti basi naa taa, ‘¿Noa yaro jirohcari õ?’ ni, docapea poca mehne docape mʉjaha tina”, ni joaa tiha panopʉ. ");
INSERT INTO gvc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Docape tuhsʉ tirore ñʉ dujirucure tina. ");
INSERT INTO gvc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ã yoa Jesure “¿Yaba buhiri mehne yariabocari tiro?” ti ni masihto sehe, õ sehe ni ti joa õri pjĩne crusapʉ duhu õha tina. “Ahriro Jesu judio masa bui pʉhtoro jiriro jira”, ni joa õre tina tí pjĩpʉ. ");
INSERT INTO gvc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Baharo pʉaro yaca bʉcʉna cʉ̃hʉre Jesu cahai paye crusari pjĩnipʉ cjã puha dapore tina. Cʉ̃iro to poto bʉhʉsehei, pairo to cõ bʉhʉsehei cjã puha dapore tina. ");
INSERT INTO gvc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Crusari cahai yʉhdʉ wahcãina Jesure ñʉ, ti dapu pocare yureroca, tirore ñano durucure: ");
INSERT INTO gvc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—¿Cohamacʉ wʉhʉre cohã, tia dacho wahaboroi pari turi tí wʉhʉre dahrehtiro jijari mʉhʉ? Cohamacʉ macʉno jicʉ mʉ basi dujia taga. Ã yoa mʉ basi yoadohoga. Ã jii yʉhdʉ witiihca mʉhʉ —nire masa. ");
INSERT INTO gvc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ãta ni bʉjʉpere tirore. Sacerdotea pʉhtoa cʉ̃hʉ, marine judio masare buheina cʉ̃hʉ bʉcʉna cʉ̃hʉ tirore ã ni bʉjʉpere: ");
INSERT INTO gvc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Tiro painare yʉhdoriro jiparota to basi yʉhdo masierara. “Israe masa pʉhtoro jija”, nimana tiro. Ã jina to basi to duji tachʉ ñʉna tirore wacũ tuanahca. ");
INSERT INTO gvc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tiro sehe Cohamacʉre wacũ tuamana. Tuhsʉ, “Cohamacʉ macʉno jija”, nimana tiro. To ã jiriro jichʉ Cohamacʉ sehe tirore yoadohojaro —ni bʉjʉpere tina. ");
INSERT INTO gvc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yaca bʉcʉna tiro cahai ti cjã puharina cjiri cʉ̃hʉ tó seheta tirore bʉjʉpe, ñano ni durucure tina cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ã yoa cohari pja jichʉ tia hora waro jipihtiropʉ nahitiano jire. ");
INSERT INTO gvc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","To nahitia duhuchʉ waro Jesu tuaro sañurucure: —Elí, Elí ¿lama sabactani? —nire tiro. Ã nino õ sehe nino nire: “Yʉ Cohamacʉ, yʉ Cohamacʉ, ¿dohseacʉ yʉhʉre cohãri mʉhʉ?” nino nire. ");
INSERT INTO gvc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","To ã nichʉ tʉhoa cãina tói ducuina õ sehe nimare: —Cohamacʉ yare yahu mʉhtariro Elia cjirore pjirocaro niboca —nimare tina. ");
INSERT INTO gvc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ti ã ni tuhsʉchʉ cʉ̃iro tina mehne macariro wihmi nari sʉhtepʉ vino sʉẽa core soha tuhsʉ, na mʉroca, yucʉcʉ sohtoai dʉhte õ, Jesure wihmi dutimare. ");
INSERT INTO gvc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","To ã yoachʉ ñʉa paina wihmi dutirirore õ sehe nimare: —Depʉsinia. Elia wihi, ahrirore to na borochʉ ñʉsinijihna mari —nimare paina. ");
INSERT INTO gvc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ti ã niri baharo pari turi sañurucu, Jesu sehe yariaa wahare. ");
INSERT INTO gvc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","To ã yariachʉta Cohamacʉ wʉhʉ macari suhtiro, ti dʉcatari suhtiro dacho macai bui sehe tʉhnʉ bora ta, tʉhnʉroca yoja sʉa wahaha. Tuhsʉ, yahpa cʉ̃hʉ ñuhmire. To ã ñuhmichʉ tãa bʉjʉa poca wahtia wahare. ");
INSERT INTO gvc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ã yoa masa coparire pjõochʉ, payʉ Cohamacʉ yaina cjiri panopʉ yariarina cjiri masa wijaaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Masa wijaa, Jesu sehe to masa wijaari baharo tí coparire cohãnoca, noari macapʉ Jerusalẽpʉ wahare tina. Tópʉ ti wahachʉ payʉ masa ñʉa tiha tinare. ");
INSERT INTO gvc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ã jia yahpa to ñuhmichʉ ñʉa, payʉ paye ti ã wahachʉ ñʉa surara pʉhtoro to surara mehne cʉaa wahare. Tina Jesure crusapʉ jirirore cohtaina jire. Cʉaa waha, õ sehe nire: —Potocã tjiri jimana. Ahriro Cohamacʉ macʉnota jiri jimana —nire tina. ");
INSERT INTO gvc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ã yoa Galileapʉ Jesu mehne tari numia cjiri tirore yoadohori numia cjiri yoaropʉ tirore crusapʉ jirirore ñʉrocarucua nire. ");
INSERT INTO gvc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tí numia mehne María Magdalena jire. Pacoro María wama tiricoro cʉ̃hʉ jire. Ticoro sehe Santiago, José cʉ̃hʉ pocoro jire. Pacoro Zebedeo namono jire. ");
INSERT INTO gvc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ã yoa ñamichahapʉ José Arimatea macariro pache pʉro tói sʉa tiha. Tiro Jesu buheriro jire. ");
INSERT INTO gvc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ã yoa Pilato cahapʉ sʉ, Jesu pjacʉre siniha. To ã sinichʉ tʉhoro Jesu pjacʉre tirore wa dutiha Pilato. ");
INSERT INTO gvc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","To ã dutiri baharo José sehe Jesu pjacʉre na boro, noari suhtiro wete marieni suhtiro mehne to pjacʉre wahmaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wahma tuhsʉ, José to ya masa copapʉ siõ payoha to pjacʉre. Tí copa ti tãcai sahari copa wahma copa jire. Tí copapʉ yo sãa duhu payo tuhsʉ, pjiria tãcare tju turẽ wahcãha tia mehne biharo taro. Biha tuhsʉ, wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ã jia María Magdalena, pacoro María mehne tí copare ñʉ dujirucuha. ");
INSERT INTO gvc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ã yoa pa dachoi, Pascua cjihtore ti cahnori dacho baharo, sabado jichʉ sacerdotea pʉhtoa fariseo curua macaina cʉ̃hʉ Pilato cahai cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cahmachu tuhsʉ õ sehe niha tina Pilatore: —Pʉhtoro, tiro mahñoriro Jesu catisinino õ sehe niha tiro: “Tia dacho wahaboroi masa wijaaihca yʉhʉ”, niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","To ã niriro jichʉ to buheina sehe to pjacʉre yacaboca. Ã yacaa masare õ sehe niboca: “Jesu masa wijaare”, niboca tina. Tiro Jesu sehe masare mahñono nire. Wiho mejeta to buheina sehe “Tiro masa wijaare” nia, mahñoina jiahca tina. Ã jiro Jesu to mahñoriro yʉhdoro ti ya mahñoa sehe ñaa yʉhdʉarohca. “Ã yacari” nicʉ, tia dacho waro to masa copare mʉ surarare cohta dutiga —niha tina Pilatore. ");
INSERT INTO gvc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato õ sehe ni yʉhtiha: —Jai. Yʉ yaina surara cohtajaro. Ã yoa mʉsa cʉ̃hʉ mʉsa bihoro puro tí copare noano cohtaga —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","To ã nichʉ tina waha, tí copapʉ bihari tãca mehnepʉta ñahachʉpʉta wihtã ñahaha masa ti sãachʉ ñʉ masia taa. Ã yoa tuhsʉ, surarare tí copare cohta dutiha. ");
INSERT INTO gvc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ã yoa judio masa mari sori dacho sabado dacho sehe to yʉhdʉri baharo domingo jichʉ ñami curero jichʉ María Magdalena, pacoro María mehne Jesu masa copare ñʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tí pjare dóihta yahpa tuaro ñuhmi bahrañoha. To ã ñuhmichʉ mari pʉhtoro to yairo anjo mʉanopʉ jiriro duji ta, masa copare bihari tãcare tju turẽroca, tia bui dujiha. ");
INSERT INTO gvc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tiro anjo orocasitero yoaro sehe noano si siteriro, to suhti yaja pjoa yoaro sehe noano yehsea suhti jiha. ");
INSERT INTO gvc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","To ã bajuachʉ tí copare cohtaina surara cui yʉhdʉa, tetere, bui warohna yaria yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ã yoa tuhsʉ anjo sehe tí numiare õ sehe niha: —Yʉhʉre cuiena tjiga. Crusapʉ ti cjã puhariro, Jesure mʉsa macachʉ masija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wiho mejeta tiro sehe mipʉre õre mariahna. To niriro seheta tiro masa wijaa wahare. To pjacʉre ti duhu payoriro cjirore ñʉna taga. ");
INSERT INTO gvc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ã ñʉ tuhsʉna to buheina cahapʉ ño duaro waha, õ sehe ni yahuna wahaga: “Jesu masa wijaare. Ã jiro mʉsa pano Galileapʉ tiro wahayurohca. Tópʉ tirore ñʉnahca mʉsa”, ni yahuna wahaga mʉsa. Ahri yʉ nirire wacũga mʉsa —niha anjo tí numiare. ");
INSERT INTO gvc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","To ã niri baharo tí numia masa copapʉ jia numia soaro mehne wijaa, tirore cuipahta wahche yʉhdʉa mehne Jesu buheinare yahua wahaa, mʉrocaha. ");
INSERT INTO gvc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ã wahaa numiare Jesu piti boca, õ sehe niha: —¿Noano jimajari mʉsa? —niha tiro. To ã niri baharo, tina sehe tiro cahapʉ sʉ, to dahporire ñaha, tirore ño payoha. ");
INSERT INTO gvc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Cuiena tjiga mʉsa. Yʉ buheinare “Galileapʉ wahaga”, ni yahuna wahaga. Tópʉ yʉhʉre ñʉahca tina —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","To ã niri baharo tí numia ti waharo watoi cãina masa copare cohtaina mehne macaina surara, Jerusalẽpʉ sacerdotea pʉhtoare yahu pahñoa wahaha. Jesu to masa copapʉ wijaarire yahu pahñonocaha. ");
INSERT INTO gvc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti ã ni yahuchʉ sacerdotea pʉhtoa, judio masa mari bʉcʉna mehne cahmachuha. Cahmachu, sʉhʉduha. Ã jia surarare mahño dutia payʉ niñerure wapaha. ");
INSERT INTO gvc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Õ sehe niga mʉsa masare: “Ñami sã carĩno watoi to buheina sehe masa copapʉ wihi, to pjacʉre nanocari jire”, ni yahuga masare. ");
INSERT INTO gvc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mʉsa ã ni yahuchʉ Pilato sehe mʉsa carĩ yʉhdʉarire tʉhorocaboca. To ã tʉhochʉ, “Mʉsare tuhtiri”, nina mʉsare yahubasanahca sã tirore —niha tina surarare. ");
INSERT INTO gvc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ti ã niri baharo surara sehe niñerure ñaha, tinare ti mahño dutiriro seheta masare yahua wahaha tina. Ã jia tó sehe Jesu to masa copare wijaarire yahurucura judio masa. Mipʉ cʉ̃hʉre ãta ni yahura tina. ");
INSERT INTO gvc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ã yoa sã Jesu buheina once buheina tʉ̃cʉpʉ Galileai jidʉpʉ Jesu to waha dutidʉpʉ wahai sã. ");
INSERT INTO gvc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tópʉ sʉ, Jesure ñʉna, ño payoi tirore. Ã ño payoina jipanahta, sã cãina “Ahriro Cohamacʉ macʉno jieraboca”, ni tʉhotumai. ");
INSERT INTO gvc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sã ã ño payochʉ tiro sehe sã cahapʉ wihi, õ sehe nire: —Ahri yahpapʉre, mʉano cʉ̃hʉre Cohamacʉ jipihtinare dutiriro waro jichʉ yoare yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","To ã yoachʉ õ sehe dutija mʉsare: Jipihtiro macainare yʉ yare buhena wahaga. Yʉ yaina ti wahahto sehe buhena wahaga. Ã yoana yʉ Pʉcʉ to wama mehne, yʉ wama mehne, Espíritu Santo to wama mehne tinare bautisaga. ");
INSERT INTO gvc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ã jina mʉsare yʉ dutirire ti yoa pahñohti cjihtire buhega tinare mʉsa. Ã yoana ahrire yʉ nihtire wacũga: Jipihtia dachoripe ahri yahpa to jiro puro mʉsa mehne ã jirucuihca. Mʉsa mehne yʉ ã jirucuhtore wacũga mʉsa —ni yahure sãre Jesu.");
INSERT INTO gvc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ahri tjui Jesucristo Cohamacʉ macʉno to yoaare noaa buheare yahu dʉcaja. ");
INSERT INTO gvc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Cohamacʉ yare yahu mʉhtariro cjiro Isaia to joariro seheta ahri yahua jira. Õ sehe ni joaha tiro: “Cohamacʉ to macʉnore õ sehe niha: ‘Mʉ pano mʉhʉre yahuyuhtirore warocai nija. ");
INSERT INTO gvc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ã jiro tiro masa marienopʉ waharohca. Tirore tʉhoinare yahuro sañurucurohca: “Mari pʉhtoro to tahto pano mʉsa ñaa tʉhotuare cohtota, cahno mʉhtaga mʉsa”, ni sañurucurohca’, niha Cohamacʉ”, ni joaa tiha Isaia cjiro João cjihtore. ");
INSERT INTO gvc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","João masare bautisariro masa marienopʉ masare buhea tiha: —“Sã noaina jija”, ni mʉsa tʉhotumari cjirire duhu, mʉsa ñaa buhirire cahya, Cohamacʉ sehere cahmaga mʉsa. Ã jina bautisarina jiga. Mʉsa ã yoachʉ ñʉno Cohamacʉ mʉsa ñaa buhirire borohca —ni buhea tiha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ã yoa jipihtina Judea yahpa macari macaina, Jerusalẽ macaina mehne tiro cahapʉ ti sʉchʉ ñʉno João sehe Jordão wama tiri mapʉ bautisaha tinare. Tinare to bautisahto pano tina sehe ti ñaa yoarire yahu yʉhdʉha Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tiro João sehe camello pjoari suhtirore sãariro wahiquiro cahsaroreta tʉã dihoriro jiha. Poreroare, macaroca macaina miquina mi cʉ̃hʉre chʉa tiha. ");
INSERT INTO gvc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ã yoa õ sehe ni buhea tiha: —Yʉ baharo yʉ yʉhdoro tuariro tarohca. Noa yʉhdʉariro jira tiro. Tiro yoaro sehe jieraja yʉhʉ sehe. Ã jicʉ tirore tʉhotucʉ, “Wiho jiriro jija yʉhʉ”, ni tʉhotuja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mʉsare bautisacʉ co mehne yoamahi. Tiro sehe yʉ yʉhdoro yoarohca. Espíritu Santore mʉsa mehne jirucuchʉ yoarohca —ni buhea tiha João. ");
INSERT INTO gvc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ã yoa tí pjare Jesu Nazarepʉ Galilea yahpai jiri macapʉ jiriro Jordão wama tiri mapʉ sʉha. Tópʉ to sʉchʉ João bautisaha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","To ã bautisa tuhsʉchʉ Jesu diapʉ ducuriro sʉrʉcʉ sʉro mʉano to parĩ mʉaa wahachʉ ñʉha tiro. To parĩ mʉachʉta Espíritu Santo buja yoaro sehe Jesu bui duji pja sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","To ã duji pja sʉchʉ mʉanopʉ durucuro coa taha: —Mʉhʉ yʉ macʉ yʉ cahĩriro jira. Mʉhʉ mehne tuaro wahcheja —nino coa taha mʉanopʉ. ");
INSERT INTO gvc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tí pjare Jesure masa marienopʉ Espíritu Santo naaha. ");
INSERT INTO gvc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tópʉre sʉro cuarenta dachori waro jiha. Watĩno sehe Jesu to ñaare yoachʉ ñʉ duaro, ñaare yoa dutimaha tirore. Tuhsʉ, Jesu wahiquina nʉcʉ macaina mehne jiha. Tói to jichʉ ñʉa anjoa sehe tirore yoadohoa, chʉare waha. ");
INSERT INTO gvc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ã yoa Joãore peresupʉ ti biha dapori baharo Jesu sehe Galilea yahpapʉ noaa buheare pʉhtoro Cohamacʉ to sʉho jiare yahuro wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Õ sehe ni yahuha: —Mipʉre õ sehe jira. Pʉhtoro Cohamacʉ mʉsare to noano sʉho jihto mahanocã dʉhsara. Ã jina “Sã noaina jija”, mʉsa ni tʉhotumari cjirire duhuga. Mʉsa ñaa buhirire cahya, Cohamacʉ sehere cahmaga. Ahri noa buheare “Quihõnota jira”, ni tʉhoga mʉsa —ni buhea tiha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tíre yahu tuhsʉ, Galilea wama tiri bʉcʉpariro dʉhtʉ cahapʉ sito wahcãmahno ñʉha Simore, to bahʉro Andre mehne. Tina wahi wajãina jiha. Ã jia ti wañʉyucʉrire bʉcʉpariropʉ doca ñoa niha. ");
INSERT INTO gvc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ã yoa Jesu tinare õ sehe niha: —Yʉhʉ mehne macaina cjihti taga mʉsa. Yʉhʉ mehne mʉsa tachʉ mʉsa wahire ñaha cahmachuina mʉsa jiro seheta, Cohamacʉ yaina cjihtire masare pji cahmachuina cjihtire mʉsare wahachʉ yoaihtja. Yʉhʉ mehne mʉsa tachʉ ã yoahtina cjihtire cũihtja mʉsare —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","To ã nichʉ tʉhoa ti wañʉyucʉrire cũnocaa, tiro mehne wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ã yoa tina mahanocã yʉhdʉ wahcã, Santiagore, to bahʉro João mehne boca sʉha tjoa. Tina sehe Zebedeo pohna jiha. Ti yaria dohoriapʉ wañʉyucʉrire cahnoa niha. ");
INSERT INTO gvc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ã yoa tiro to pjirocachʉ tina sehe ti pʉcʉrore, tiro mehne dahra cohtaina mehne dohoriapʉ cũnocaa, Jesu mehne wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ã yoa tina Capernau wama tiri macapʉ sʉha. Tópʉ sʉro Sabado jichʉ judio masa sã buheri wʉhʉpʉ buhero sãaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sã judio masare buheina yoaro sehe jieraha tiro. Noano masi pahñoriro ji, noano waro buheha. To ã buhechʉ tí maca macaina tʉho cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tí pjare cʉ̃iro tí wʉhʉi jiriro watĩa ti cohtotariro jiha. Tói jiro õ sehe niha Jesure: ");
INSERT INTO gvc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Mʉhʉ Jesu Nazare macariro cariboi tjiga sãre. ¿Dohse yoai tai nijari sãre? ¿Mʉhʉ sãre butichʉ yoai tai nijari? Cohamacʉ macʉno buhiri tia marieriro mʉ jichʉ masija yʉhʉ —ni sañurucuha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","To ã nichʉ tʉhoro Jesu tuhtiha watĩare: —Dihta mariahga. Wijaahga tirore —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ã jia watĩa tirore yahpapʉ doca caha sʉ tunuchʉ yoa, to tuaro sañurucuro watoihta wijaaha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ã jia jipihtina tí wʉhʉi dujiina ñʉ cʉaa yʉhdʉa wahaha. —Cue, ¿wahma buhea jijari ahri? Tiro pʉhtoro yoaro seheta dutira watĩare. To dutichʉ tina watĩa sehe yʉhdʉrʉcaerara tirore —ni durucuha tí wʉhʉi dujiina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ã jia mahaa dachoricã baharoihta dóihta jipihtina Galilea yahpa macaina tíre to yoarire tʉho sahsea wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ã yoa Jesu cʉ̃hʉ judio masa mari buheri wʉhʉpʉ jiina wijaaha. Ti ã wijaari baharo Jesu, Santiago, João, paina tina mehne macaina cʉ̃hʉre Simo to bahʉro Andre mehne ti ya wʉhʉpʉ sʉho sãa sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tí pjare Simo marechono juaro mehne to dohatichʉ cama bui to coãchʉ yahuha Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ti ã yahuchʉ tʉhoro tiro sehe ticoro cahapʉ sʉro, to wamomacare ñaha, ticorore waja wahcõ dapoha. To ã waja wahcõ dapochʉta ticorore juaro surua wahaha. To ã sururi baharo ticorota tinare chʉare payoha. ");
INSERT INTO gvc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ã yoa sʉ̃ sãari baharo nahi borachʉpʉ masa payʉ dohatiinare, watĩa ti cohtotarinare Jesu cahapʉ na sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ã jia jipihtina tí maca macaina cahmachurʉcʉ sʉha tí wʉhʉ sopacai. ");
INSERT INTO gvc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ã jiro Jesu payʉ dohatiinare, payʉ soro jia dohatia cjʉainare noaina wahachʉ yoaha. Watĩa cʉ̃hʉre, masare sãamarinare payʉ cohã wioha. Ã jiro watĩa Jesure ti masichʉ ñʉno Jesu sehe tinare durucu dutieraha. ");
INSERT INTO gvc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ã yoa ñami curerocã wahcã, nahitia curechʉta masa marienopʉ Cohamacʉre sinino wahaha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","To ã wahari baharo Simo cʉ̃hʉ tirore macaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tina tirore boca sʉ, õ sehe niha: —Masa jipihtina mʉhʉre macaa nihre —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ti ã nichʉ tʉhoro õ sehe niha Jesu tinare: —Tinare buhe tuhsʉhi. Pa sehepʉ õ cahacã macaa macaripʉ wahajihna mari. Ahri yahpa macainare yahu site pahñoi tahi. Ã jicʉ yʉhʉ paye macari macaina cʉ̃hʉre buheihtja —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ã ni tuhsʉ, jipihtia Galileai jia macaripʉ judio masa mari buhea wʉhʉsepʉ buhero, watĩare masare sãamarinare cohã wioha. ");
INSERT INTO gvc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ã yoa pairo dohatiriro cami bariro Jesure piti bocaro, na tuhcua caha sʉ õ sehe ni siniha: —Mʉhʉ yʉhʉre noariro wahachʉ yoa duacʉ yoaga —niha cami bariro. ");
INSERT INTO gvc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","To ã nichʉ tʉhoro Jesu tirore pja ñʉha. Ã jiro to wamomacare siõroca, tirore ña payoha. Ã ña payoro õ sehe niha: —Tíre yoa duaja. Noariro jiga mʉhʉ —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","To ã nichʉta dohatiriro to cami bari cjiri yati mʉaa wahaha. Noariro wahaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","To ã wahachʉ ñʉno Jesu tirore tuaro mehne õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Painare ahrire yahuecʉ tjiga. Ã yahuerapaihta mʉ pjacʉre sacerdotere ñoga. Cohamacʉ dutia Moise cjirore to cũriro seheta yoaga. Ã yoacʉ minichahcare waga sacerdotere noariro mʉ waharire mʉ ñohti cjihtire —niha Jesu. Ã ni tuhsʉ “Wahaga”, niha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","To ã yahu dutierapachʉta tiro waha, jipihtia macari macainare Jesu to yoarire yahuha. To ã yahuri baharo Jesu masa payʉ ti jiropʉre waha masieraha. Ã jiro tiro mahainacã ti jiropʉ jiha. Tópʉ to jichʉ payʉ macari macaina tiro cahapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mahaa dachori baharo Jesu Capernaupʉ tjuaa wahaha. Wʉhʉi to jichʉ masa tʉhoha. ");
INSERT INTO gvc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ã jia tói masa payʉ cahmachu tí wʉhʉre wahpata wijaa sʉrʉcaha. Ã jiro Jesu tinare noaa buheare yahuha. ");
INSERT INTO gvc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","To ã yahuro wato, pititiaro mʉa jipihtiri pjacʉ bʉharirore na wihiha. ");
INSERT INTO gvc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ti masa payʉ jichʉ ñʉa Jesu cahapʉ sãa masieraha. Ã jia tina wʉhʉ buipʉ Jesu bui waroi mahanocã muji pahmare nawe, pjacʉ bʉharirore to coãri cahsaro mehne duhu boroha Jesu cahai. “Jesu ahrirore to dohatiare yʉhdʉchʉ yoarohca”, ni tʉhotuha tina. ");
INSERT INTO gvc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ti ã ni tʉhotuchʉ masino Jesu sehe dohatirirore õ sehe ni yahuha: —Macʉ, mʉ ñaa yoari buhiri tiare cohã tuhsʉja —niha Jesu pjacʉ bʉharirore. ");
INSERT INTO gvc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","To ã nichʉ tʉhoa sã coyea judio masare buheina tópʉre dujiina ti basi õ sehe ni tʉhotumaha: ");
INSERT INTO gvc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ahriro ã ni durucuero tjijaro. Cohamacʉre ñano durucuro nina tiro. Tiro masʉno mari yoaro seheta jiriro jira tiro cʉ̃hʉ. Ã jiro to ñaa yoari buhiri tiare cohã masierara. Cohamacʉ dihta masa ti ñaa yoari buhiri tiare cohã masina”, ni tʉhotumaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ti ã ni tʉhotuchʉ ñʉno Jesu ti tʉhotuare masino õ sehe niha: —¿Dohse yoana mʉsa ã ni tʉhotujari? ");
INSERT INTO gvc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Mʉ ñaa yoari buhiri tiare cohã tuhsʉja”, yʉ nichʉ “Mahñoriro jira”, yʉhʉre nina mʉsa masierapanahta. “Wahcãrʉca, wahaga”, yʉ nichʉ to tinichʉ ñʉna yʉ niri potocã jia jichʉ dóihta masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉre masa ti ñaa yoari buhiri tiare cohã masija yʉhʉ. Ahrire mʉsa masihto sehe õ seheta to wahachʉ yoaihtja —niha Jesu judio masare buheinare. Tinare ã ninota pjacʉ bʉharirore õ sehe niha: ");
INSERT INTO gvc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mʉhʉre niita nija. Wahcãrʉcaga. Mʉ coãri cahsarore na wahcãga mʉ ya wʉhʉpʉ —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","To ã nichʉta pjacʉ bʉhariro cjiro wahcãrʉcʉ sʉ to coãri cahsarore na, jipihtina ti ñʉrocaroi wijaa wahaha. To ã yoachʉ ñʉa tina jipihtina ñʉ cʉa wahaha. “Cohamacʉ tuariro jira” ni, “Ne, mari õ sehe yoaare ñʉera tihi”, niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ã yoa pari turi Jesu bʉcʉpariro dʉhtʉ cahapʉ wahaha tjoa. Tópʉ sʉro masa payʉ tiro cahai ti cahmachuchʉ ñʉno tiro buheha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ã yoa tuhsʉ tópʉ jiriro wahamahno Levíre Alfeo macʉnore to dahrari tahtiapʉ boca sʉha. Paina mehne pʉhtoa ya cjihtire wapa na cohtaina jiha Leví cʉ̃hʉ. Tirore boca sʉro õ sehe niha: —Yʉhʉ mehne macariro cjihto taga mʉhʉ —niha Jesu Levíre. To ã nichʉta Leví sehe wahcã sʉrʉca, Jesu mehne wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ã yoa baharo Jesu sehe to buheina mehne Leví ya wʉhʉpʉ chʉro niha. Jesu mehne wahaina sehe payʉ jiha. Cãina pʉhtoa ya cjihtire wapa na cohtaina, ã jichʉ paina masa “Ñaa dihtare yoara”, ti niina mehne payʉ mesa cahai duji, tina cʉ̃hʉ tiro mehne cʉ̃noi sʉho chʉa niha. ");
INSERT INTO gvc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tópʉ ti dujiri baharo paina sã coyea judio masare buheina, fariseo masa ya curua macaina mehne Jesu to chʉ dujichʉ ñʉha tina. Ã ñʉa õ sehe ni sinituha: —¿Dohsearo ñano yoaina, pʉhtoa ya cjihtire wapa na cohtaina mehne chʉjari Jesu? —ni sinituha judio masare buheina Jesu buheinare. ");
INSERT INTO gvc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ti ã nichʉ tʉhoro piti dahre buhea mehne õ sehe ni yʉhtiha Jesu: —Dohatieraina duhturure macaerara. Dohatiina dihta duhturure macana. Ñano yoaina dohatiina yoaro sehe jira. Ã jicʉ ñano yoainare yahui tai nihi yʉhʉ. Ti basi “Noaina jija sã”, ni tʉhotuinare yahui tai nierahi yʉhʉ —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tí pjare João buheina, fariseo curua macaina cʉ̃hʉ Cohamacʉre ño payoa taa, chʉera tiha. Ã jia masa Jesure õ sehe ni sinituha: —João buheina, fariseo buheina cʉ̃hʉ Cohamacʉre ño payoa taa chʉerara. ¿Dohse yoa mʉ buheina sehe chʉ duhuerajari? —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu to tʉhotua mehne quiti dahre buhero tinare õ sehe ni yʉhtiha: —Õ sehe jira tí: Wamomaca dʉhteriro bose nʉmʉi to jichʉ tiro mehne macaina cahyaro mehne jierara. Tuhsʉ, chʉeraina jierara. Tó seheta yʉ buheina cʉ̃hʉ yʉhʉ mehne jia, chʉ duhu masierara. ");
INSERT INTO gvc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yʉ Pʉcʉ Cohamacʉ yʉhʉre to naari baharo pinihtare yʉ buheina mehne jisi yʉhʉ. Ã jia tí pjapʉta yʉ buheina cʉ̃hʉ chʉ duhuahca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Panopʉ macaa buhea wahma buhea mehne ti buhe more duachʉ ñʉno õ sehe ni namoha Jesu tinare piti dahre buhero: —Ne, wahma cahsaro suhtiro cahsaro mehne mʉnano suhtirore sere õno cahmaerara. Mari ã yoachʉ wahma cahsaro mari cosari baharo mʉnano suhtirore waja cahmachu, pjibiaro tʉhnʉchʉ yoara. ");
INSERT INTO gvc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ã yoa ne se co bisia core wahiquiro cahsaro wajuru mehne mʉna wajuru mehne posaeraro cahmana. Mari ã yoachʉ se co bisia pahmoapʉ mʉna wajurure tʉhrẽnocahna. To tʉhnʉchʉ se co cʉ̃hʉ, wajuru cʉ̃hʉ cohõa wahara. Ã yoa se co wahma core wahma wajurupʉ posaro cahmana. Mari ã yoachʉ se co cohõera, wajuru cʉ̃hʉ cohõerara. (Tó seheta wahma buhea mʉna buhea mehne buhe moreraro cahmana) —ni buheha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa dacho Sabado jichʉ Jesu cʉ̃hʉ trigo wesepʉ wahaha. To buheina sehe trigo parorire paha yʉhdʉ wahcãha. ");
INSERT INTO gvc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ti ã yoachʉ ñʉa õ sehe ni tuhtiha fariseo curua macaina Jesure: —Tʉhosiniga sãre. ¿Dohse yoa tina Sabado mari sori nʉmʉ to jipachʉta dahrajari? Marine dutiare yʉhdʉrʉcaa nina —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ti ã nichʉ tʉhoro Jesu tinare yʉhtiha. “Yʉ buheina yʉhdʉrʉcaa nierara”, nino taro õ sehe niha: —Davi cjiro tiro mehne macaina mehne jʉca baaro, Cohamacʉ wʉhʉpʉ sãa, Cohamacʉ ya pãore chʉha. Ã chʉro tiro mehne macaina cʉ̃hʉre tí pãore waha. Tí pãore sacerdotea dihtare chʉ dutira. Cohamacʉ dutia ti joari tjui painare tí pãore chʉ dutierara. Tí pjare Abiata wama tiriro sacerdotea pʉhtoro jiha. ¿Davi cʉ̃hʉ tíre ti yoari cjirire Cohamacʉ yare ti joari tjui buherari mʉsa? (Tí pãore chʉro Cohamacʉre yʉhdʉrʉcaro nieraha. Michare ahri yaparire chʉa yʉ buheina cʉ̃hʉ Cohamacʉre yʉhdʉrʉcaa nierara) —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ã ni tuhsʉ õ sehe ni namoha: —Ã yoa Cohamacʉ Sabado dachore ti sori nʉmʉ cũno masa ya dacho cjihto cũno nire dahra wahyarinare so dutiro. Tí dachore ño payohtina cjihtire cũno nierare masare Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ã jicʉ yʉhʉ masʉno Cohamacʉ warocariro ahri dacho Sabado dachore masa ti yoahtire yahurirota jicʉ pʉhtorota jija —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ã yoa Jesu sã judio masa buheri wʉhʉpʉ sʉro sãaha tjoa. Tí wʉhʉi cʉ̃iro wamomaca bʉhariro dujiha. ");
INSERT INTO gvc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sabado jichʉ Jesu wamomaca bʉharirore to noariro yoachʉ ñʉ duaha cãina tí wʉhʉi dujiina. To ã yoachʉ ñʉa tirore yahusã duamaha. “Mari sori nʉmʉi Jesu dahraro nina”, ni yahusã duamaha tina. Ã jia Jesu to sãa tachʉ ñʉa, tirore yahusã duaina sehe tiro dihtare ñʉroca õha. ");
INSERT INTO gvc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tirore ti ã ñʉroca õpachʉta Jesu sehe wamomaca bʉharirore õ sehe niha: —Wahcã sʉrʉcaga jipihtina ti ñʉrocaroi —niha. ");
INSERT INTO gvc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ã ni tuhsʉ tí wʉhʉi dujiinare õ sehe ni yahuha: —¿Sabado jichʉ noaare yoachʉ noaerajari? ¿O ñaare yoachʉ sehere noajari, mʉsa tʉhotuchʉ? Sabado jichʉ masʉnore masochʉ noa nina. Masʉnore wajãchʉ sehere noaerara —ni yahuha Jesu tinare. To ã nipachʉta tina yʉhtieraha. ");
INSERT INTO gvc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ti ã yʉhtierachʉ ñʉno Jesu tina mehne suaha. Ti tʉho duaerachʉ ñʉno Jesu cahyaha. —Mʉ wamomacare siõrocaga —niha tiro wamomaca bʉharirore. To ã nichʉ tʉhoro tiro to wamomacare siõrocaha. To ã yoachʉta noari wamomaca wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","To ã noari wamomaca wahachʉ ñʉa, fariseo curua macaina wijaa wahaha. Wijaa, Herode mehne macaina mehne cahmachu, “¿Dohse yoa Jesure wajãnahcari mari?” niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ã yoa pari turi Jesu to buheina mehne bʉcʉpariro cahapʉ wahaha tjoa. Ti ã wahachʉ ñʉa Galilea macaina masa payʉ to baharo sʉha. Ã jia Judea yahpa macaina, Jerusalẽ macaina, Idumea yahpa macaina, Jordão wama tiri ma sie coa macaina, Tiro wama tiri maca macaina, tó cahai jiina, Sidõ wama tiri maca macaina, tó cahai jiina mehne masa payʉ jipihtina to yoarire tʉhoa, tiro cahapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Tópʉ sʉa, payʉ masa jiha. Payʉ dohatiinare noaina to yoachʉ tʉhoa, paina dohatiina cʉ̃hʉ Jesure piha dua, tju bihsarʉcʉ sʉha. Ti ã tju bihsarʉcʉ sʉchʉ ñʉno, Jesu bʉsocare cahnopohobasa dutiha to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ã yoa paina watĩa ti cohtotarina sehe Jesure ñʉa tiro cahai na tuhcua caha sʉha. —Mʉhʉ Cohamacʉ macʉno jira —ni sañurucuha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ti ã sañurucuchʉ tʉhoro tinare Cohamacʉ macʉno to jiare tuaro mehne ni dutieraha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ã yoa Jesu tʉ̃cʉpʉ mʉja, to cahmainare pjirocaha. To pjirocachʉ tʉhoa, tiro cahapʉ mʉja sʉha tina. ");
INSERT INTO gvc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ti mʉja sʉri baharo doce mʉare tiro mehne macaina cjihtire, paye macaripʉre to yare buhe duti to warocahtinare, bese dapoha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ã yoaro dohatiinare ti yʉhdohti cjihtire, watĩare ti cohã wiohti cjihti cʉ̃hʉre cũha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ahrinare doce mʉare Jesu bese dapoha: Simo, Santiago Zebedeo macʉno, João to bahʉro, Andre, Felipe, Bartolomé, Mateo, Toma, Santiago Alfeo macʉno, Tadeo, Simo cananista ya curua macariro cjiro, Juda Iscariote, tina jiha to bese daporina. Jesu Simore Pedro ni wama pisuha. Santiagore, João mehne Boanerges ni wama pisuha. Boanerges “Wʉpo yoaro sehe jiina tuaro bisiina jira”, nino nina. Juda Iscariote Jesure ñʉ tuhtiinare ñohtiro jiha. Tinare bese dapo tuhsʉ, dujiaa, Jesu to buheina mehne wʉhʉpʉ sãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ã yoa tói pari turi masa payʉ cahmachua bihsa niha. Ti ã bihsachʉ ñʉno Jesu chʉ masieraha. Tuhsʉ, to buheina cʉ̃hʉ chʉ masieraha. ");
INSERT INTO gvc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ã jia paina Jesu coyea tíre tʉhoa, tiro cahapʉ sʉa, tirore ñahamaha. —Tiro tʉho masierariro waharo nina —nimaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Paina õ sehe niha: —Beelzebú tirore ã wahachʉ yoaro nica. Tiro watĩare cohãno Beelzebú watĩa pʉhtoro to tuaa mehne tinare cohãna —niha Jerusalẽpʉ tarina sã judio masare buheina. ");
INSERT INTO gvc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ti ã nichʉ tʉhoro Jesu sehe tinare pjiroca, to tʉhotua quiti mehne piti dahre yahuha tinare: ");
INSERT INTO gvc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—Watĩno ya tuaa mehne watĩare cohãi nieraja. Watĩa ti basi cohã masierara. Cʉ̃ yahpa macaina ti basi cahma wajãa, tí yahpa macaina yaria pihtia wahaboa. ");
INSERT INTO gvc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cʉ̃ wʉhʉ macaina ti basi cahmachea tí wʉhʉ macaina waha pihtia wahaboa. ");
INSERT INTO gvc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tuhsʉ, Satana watĩa pʉhtoro sehe watĩare cohãno ti basita cahmachea niboa. Ã jia tina waha pihtia wahaboa. ");
INSERT INTO gvc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Õ seheta jira mari piti dahre buhechʉ. Tuariro ya wʉhʉpʉ pairo sãa sʉ yaca masierara. Tuarirore dʉhteraro to ya wʉhʉpʉ sãa sʉ yaca masierara. Tuarirore to dʉhteri baharo sãa sʉ yaca masina —ni yahuha Jesu. (Õ sehe ni yahuha watĩnore to yʉhdʉrʉcarire yahuro. Watĩno tuariro to jipachʉta Jesu tirore yʉhdʉrʉcara watĩare cohãno.) ");
INSERT INTO gvc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ã ni tuhsʉ õ sehe ni yahu namoha Jesu: —Potocã niita nija mʉsare. Jipihtia ñaare masa ti yoachʉ ti durucuchʉ cʉ̃hʉre Cohamacʉ bo masina. ");
INSERT INTO gvc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ã boparota Espíritu Santore ti ñano durucuchʉ tí pinine ne bosi. Ti ã niri buhiri ã buhiri tirucuina jiahca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu Espíritu Santo to tuaa mehne watĩare to cohãpachʉta “Tiro watĩno to tuaa mehne watĩare cohãno nina”, nimaha masa. Ti ã nichʉ tʉhoro tí quitire Espíritu Santo quitire yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ã yoa Jesu bahana to pocoro mehne wihiha. Ã wihia sopacapʉ jia, painare pji dutiha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ã jia masa tiro cahapʉ dujiina yahuha tirore: —Mʉ poco, mʉ bahana mehne sopacapʉ pjia nina mʉhʉre —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ti ã nichʉ tʉhoro õ sehe niha Jesu tinare buhero taro: —¿Noa jijari yʉ poco, yʉ bahana cʉ̃hʉ, mʉsa ñʉchʉ? —niha tiro tinare buhero taro. ");
INSERT INTO gvc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ã nino to cahai dujiinare ñʉno õ sehe niha: —Ahrina jira yʉ poco yʉ bahana yoaro sehe jiina. Cohamacʉ cahmaare yoara ahrina. ");
INSERT INTO gvc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tó seheta yoaina yʉ bahʉ, yʉ baho, yʉ poco yoaro seheta jira —ni buheha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ã yoa pari turi bʉcʉpariro dʉhtʉ cahapʉ Jesu masare buhe dʉcaha tjoa. Ã tópʉre buhe dʉcaro masa payʉ tiro cahapʉ ti cahmachuchʉ ñʉno Jesu sehe dohoriapʉ samu wijaa, pahsaha. Ã jia masa sehe bʉcʉpariro dʉhtʉ cahai ducuha. ");
INSERT INTO gvc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ã jiro Jesu payʉ to tʉhotua mehne quiti dahre yahuha tinare buhero taro: ");
INSERT INTO gvc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Ahri quitire tʉhoga mʉsa —niha tiro tinare. —Toari masʉno toaro, to toaa yaparire doca site cũno wahara. ");
INSERT INTO gvc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","To ã doca site cũ wahcãchʉ paye yapari mahai bora caha sʉha. Ã bora caha sʉare tí yaparire minichahca duji ta, chʉnocaha. ");
INSERT INTO gvc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ã yoa paye yapari sehe tãa wapa bui dihta se mininocã bui bora caha sʉha. Tãa wapa buicã dihta mariea cureroi bora caha sʉ, dói dumaha. ");
INSERT INTO gvc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ã dói duri jipahta, nʉhcori mariaa, sʉ̃ to tuaro sichʉ, ñaia wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Paye yapari sehe tja watoi bora caha sʉha. Tja sehe dia yʉhdʉa waha, toaa sehere wajãnocaha. Ã jia tja watoi jiare dicha mariachʉ yoaha. ");
INSERT INTO gvc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Paye yapari sehe noari yahpai bora caha sʉha. Noano du, noano dicha tiha. Paye yucʉ treinta yapari, paye yucʉ sesenta yapari, paye yucʉ cien yapari dicha tiha. ");
INSERT INTO gvc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ahrire tʉho duaina noano tʉhoga mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ã yoa ti sahsero jia doce to buheina, paina Jesu mehne jiina cʉ̃hʉ tí quitire masi duaa, Jesure sinitu ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ti ã sinitu ñʉri baharo Jesu õ sehe ni yahuha: —Cohamacʉ masa bui pʉhtoro masare to noano sʉho jiare, panopʉ paina ti masierari cjirire mʉsare masichʉ yoara Cohamacʉ. Paina sehere ã yoaerara tiro. Ã jicʉ tinare quiti mehne dihta buheihtja. ");
INSERT INTO gvc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ã jia tina ñʉpahta ñʉeraina cjiri yoaro sehe tjuara. Ã jia tʉhopahta tʉho ñaha masisi. Tina tʉho ñahaina jia, ti ñaa yoarire cahya, Cohamacʉre macaboa. Ti ã macachʉ ñʉno, tiro sehe ti ñaa yoari buhirire bonocaboa. Ã jipachʉta tina sehe ne tʉho duaerara —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","To ã niri baharo õ sehe ni yahu namoha tinare: —¿Ahri quitire tʉhoerasinijari mʉsa? ¿Mʉsa ahri quitire tʉhoerana, dohse paye quitire tʉhonahcari mʉsa? —niha Jesu tinare. Ã ni tuhsʉ tiro õ sehe ni yahuha tinare: ");
INSERT INTO gvc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Toari masʉno toaro, to doca site cũa yapari noaa buhea yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ã yoa mahai boraa yapari noaa buhea yoaro sehe jira. Cãina noaa buheare ti tʉhochʉ ñʉno Satana sehe ta, tí buhea noaa buheare ti tʉho ñahamarire bochʉ yoara tinare, minichahca tí yaparire ti chʉro seheta yoaro. ");
INSERT INTO gvc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ã yoa tãa wapa bui dihta se mininocã bui boraa yapari noaa buhea yoaro sehe jira. Ã jia paina noaa buheare tʉho, wahchea mehne dóihta tíre tʉho nʉnʉ wahcãna. ");
INSERT INTO gvc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ã tʉho nʉnʉ wahcãpahta tãa wapa buicã jia yucʉ nʉhcori mariea yucʉ yoaro sehe ahrina masa cʉ̃hʉ yoari pja cʉ̃no pjaerara. Ã cʉ̃no pjaeraa, yʉ yare ti cahmari buhiri paina tinare ti ñano yoachʉ, ñano yʉhdʉa, yʉ yare duhunocahna. Paina tinare ti ñano yoachʉ tíre cʉ̃no pjaeraa, yʉ yare duhunocahna. ");
INSERT INTO gvc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ã yoa tja watoi boraa yapari noaa buhea yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ã jia paina sehe noaa buheare tʉhoa, ahri yahpa macaare wacũ nʉnʉ yʉhdʉara. Niñerure bʉjʉa cahma, paye baro cʉ̃hʉre payʉ cahma, tíre goa pja yʉhdʉara tina. Ti ã tʉhtotuchʉ tí sehe noaa buheare dʉcatara. Ti ã dʉcatachʉ masa noaa sehere yoaerara. Dicha maria yucʉ yoaro seheta jira. ");
INSERT INTO gvc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ã yoa noari yahpai boraa yapari noaa buhea yoaro sehe jira. Ã jia paina sehe noaa buheare tʉhoa tíre cahmana. Tíre masiina jia, Cohamacʉ to cahmano seheta noaare yoara tina. Cãina mahanocã noaare yoara treinta yapari dicha tiro seheta. Paina bui curero noaare yoara sesenta yapari dicha tiro seheta. Paina pjíro noaare yoara cien yapari dicha tiro seheta —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ã ni tuhsʉ õ sehe ni yahu namoha Jesu: —Ne, sihãriare ti sihãri baharo tiare dihi biato docapʉ cũerara. Ã jia tiare coãri casario docapʉ cũerara. Mʉanopʉ duhu payora noano buhria dutia. ");
INSERT INTO gvc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jipihti ti masierari cjirire baharo masa masiahca. Sihãria to buhriachʉ mari ñʉ masino seheta panopʉre ti masierari cjirire masiahca masa. ");
INSERT INTO gvc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ahrire noano tʉhoga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mahanocã masi duana mahanocã masinahca. Pjíro masi duana pjíro masinahca. Ã jina mʉsa tʉhona noano tʉho nʉnʉga. ");
INSERT INTO gvc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Noano tʉho nʉnʉriro noano masinohca. Tʉho nʉnʉerariro “Mahanocã tʉhoja”, to nipachʉta tí sehe butia waharohca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ã ni tuhsʉ õ sehe ni yahu namoha: —Cohamacʉ masa bui pʉhtoro to sʉho jia trigore toariro yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Toa tuhsʉ bohrearo to toari duare ñʉna tiro. “¿Dohse du wijaa ta bʉcʉajari tí?” ni ñʉ masierara toariro to basi. ");
INSERT INTO gvc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tí toari ti basi dicha tira. Pari pũca ji mʉhtana. Baharo pari paro wijaa bʉcʉara. ");
INSERT INTO gvc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tí parori bʉcʉa tuhsʉchʉ ñʉno pahara. Pahari pja jira. (To toaa ti bʉcʉarire to masieraro seheta Cohamacʉ yaina masa ti wahachʉ cʉ̃hʉre yahu pahño masierara masa) —ni buheha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ã ni tuhsʉ õ sehe ni buhe namoha Jesu piti dahre buhero: —¿Ne Cohamacʉ masa bui pʉhtoro to sʉho jia yaba baro yoaro sehe jijari, mʉsa tʉhotuchʉ? ¿Di quiti mehne tíre yahunahcari? ");
INSERT INTO gvc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza yapacã yoaro sehe jira pʉhtoro Cohamacʉ to sʉho jia. Tí yapacã to toachʉ mahabiari yapacã jira. ");
INSERT INTO gvc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ã jiparota tí yapacã noano dura. Ã jiro pjibiadʉ wahara. Ã jia tʉ dʉpʉri bʉjʉa dʉpʉri bʉcʉachʉ ñʉa minichahca peri tʉ dʉpʉripʉ suhti suhara. (Pjibiadʉ to wahariro seheta mʉano macarirore mari pʉhtorore masiina mahainacã ti ji mʉhtapachʉta baharopʉ tina payʉ wahaahca) —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ã ni tuhsʉ, tí quiti ti niriro seheta payʉ quitire tʉho ti cʉ̃no pjaro puro noaa buheare buheha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Quiti marieno yahueraha tinare. Tuhsʉ, ti sahsero jiinare Jesu noano yahu pahñoha to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ã yoa tí dachoreta nahi borachʉpʉ Jesu to buheinare õ sehe niha: —Basa, sie coapʉ pahãjihna —niha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","To ã nichʉ tʉhoa Jesu to jiriapʉ dohoriapʉ samu, masare yahpapʉ ducuinare tóihta cũ, to buheina dihta Jesure na pahãa wahaha. Ã yoa paye bʉso mehne paina cʉ̃hʉ tinare piti ti pahãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ti ã pahãchʉ wihnono tuaro taha. Ã taro dohoriare pahcõri tuaro cjã sãaha. Mahanocã dʉhsamaha ti miniboro. ");
INSERT INTO gvc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","To ã waharo watoi Jesu sehe dohoria oturopʉ suhti puti mehne to dapu ño tu tjiãhno carĩno niha. Ã jia tina tirore wahcõha. —Buheriro, mari mini yariana tana nija. ¿Ã jica niera putiajari mʉhʉ? —niha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ti ã nichʉta Jesu sehe wahcã, wihnonore: —Tó purota wã duhuga —niha. Ã ninota pahcõri cʉ̃hʉre: —Yʉsʉa wahaga —niha bʉcʉparirore. To ã nichʉta wihnono yʉhdʉa wahaha. Ã jia pahcõri cʉ̃hʉ yʉsʉ boraa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—¿Dohse ni cuimacanocana nijari mʉsa? ¿Mʉsa yʉhʉre wacũ tuaerasinijari? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","To ã yoachʉ ñʉa tina cʉa yʉhdʉa wahaha. —Cue, ¿dohse jiriro baro masʉno jijari ahriro? Ahri wihnono, pahcõri cʉ̃hʉ to dutichʉ yʉhdʉrʉcaerara tirore —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Ã yoa tina sie coapʉ Gerasa macaina ya yahpapʉ pahã sʉha. Pahã sʉ, Jesu sehe dohoriapʉ sãariro maja sʉrʉcaha. To ã maja sʉrʉcari baharocãta, watĩa ti cohtotariro tãa copari, masa copari watoi jiriro wija ta, tiro cahapʉ taha. ");
INSERT INTO gvc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tiro watĩa ti cohtotariro masa copari watoi jiriro jia tiha. Tirore ne cʉ̃iro coma da pjiri da mehne ñaha dʉhte cũno bihoeraha. ");
INSERT INTO gvc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Payʉ tahari masa tirore dahpori wʉpõa sorori mehne comaa dari mehne dʉhtea timaha. To wamomacari cʉ̃hʉre dʉhtea timaha. Wiho mejeta tiro sehe comaa darire nuha, dahpori wʉpõa sorori cʉ̃hʉre nuha site mʉjaha. Ã jia tiro tuariro to jichʉ ñʉa masa sehe tirore cjʉaa bihoeraa tiha. ");
INSERT INTO gvc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ñamine, dachore tʉ̃ yucʉripʉ jia copari tãa copari watoi ã sañurucua tiha tiro. Ã yoa tãa mehne to basi to pjacʉre cjãye mʉjaa tiha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ã yoa Jesu to maja sʉrʉcachʉ yoaropʉ Jesure ñʉroca, tiro cahapʉ mʉroca ta, na tuhcua caha sʉha, tirore ño payoro taro. ");
INSERT INTO gvc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","—Watĩa wijaahga tirore —niha Jesu. To ã nichʉ tʉhoro watĩa ti cohtotariro õ sehe ni sañurucuha: —Jesu, Cohamacʉ Jipihtina Bui Jiriro macʉno, ¿yabare yoai tai nijari mʉhʉ yʉhʉre? Cohamacʉ to ñʉrocaroi sinija yʉhʉ mʉhʉre. Yʉhʉre ñano yoai tjiga —ni sañurucuha watĩa ti cohtotariro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Yabariro wama tijari mʉhʉ? —niha Jesu tirore. —Sã payʉ jija. Ã jina “Payʉ watĩa”, wama tija. ");
INSERT INTO gvc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ahri dihtapʉ jiinare sãre pa yahpapʉ waha dutiecʉ tjiga —ni payʉ tahari siniha watĩa ti cohtotariro. ");
INSERT INTO gvc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tí pjare ti cahacãi tʉ̃cʉ dahpotoi yesea nuina payʉ chʉa niha. ");
INSERT INTO gvc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tói ti chʉrucuchʉ ñʉa õ sehe ni siniha watĩa: —Sina yesea cahapʉ warocaga sãre ti pjacʉripʉ sã sãahto sehe —ni siniha watĩa tirore. ");
INSERT INTO gvc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ti ã nichʉ tʉhoro “Jai. Wahaga”, niha Jesu. To ã dutichʉ, watĩa masʉnopʉ jirina cjiri sehe wijaa, yesea pjacʉripʉ sãaha. Tina yesea sehe payʉ waro jiha, dos mil. Ã yoa tinare ti sãari baharo, yesea jipihtina bʉcʉpariro dʉhtʉ cahapʉ pari cʉnʉpʉ mʉroca buha, tí taropʉ bora ñoja, mini yaria pihtia wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ti ã mini yariachʉ ñʉa yeseare ñʉ wihboina sehe mʉroca wahcã, pjiri macapʉ cʉ̃hʉre, daa macaricãpʉ cʉ̃hʉre tíre yahu sitea wahaha. Ti ã yahuchʉ tʉhoa, masa sehe payʉ ti ã waharire ñʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ã jia Jesu cahapʉ wihia, payʉ watĩa ti cohtotariro cjiro to suhti tiriro, tʉho masiriro to dujichʉ ñʉa, cui niha. ");
INSERT INTO gvc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Watĩa ti cohtotariro cjirore, yesea cʉ̃hʉre ti ã waharire ñʉina sehe paina masa ti cahai wihiinare noano yahu pahñoha. ");
INSERT INTO gvc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ti ã yahu pahñochʉ tʉhoa, Jesure tuaro mehne pa sehepʉ waha dutiha. ");
INSERT INTO gvc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ã yoa dohoriapʉ Jesu to samuchʉ ñʉno, “Mʉhʉ mehne waha duaja” ni, tuaro sinimaha watĩa ti cohtotariro cjiro sehe Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","To ã nichʉta Jesu tirore õ sehe ni yahuha: —Yʉhʉ mehne taecʉ tjiga. Mʉ ya wʉhʉpʉ mʉ coyea cahapʉ yʉhʉ mʉ pʉhtoro mʉhʉre yʉ yoarire yahui wahaga. Mʉhʉre yʉ pja ñʉrire yahuga tinare —niha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","To ã nichʉ watĩa ti sãanoriro cjiro sehe Decapoli wama tiropʉ jia macaripʉ Jesu tirore to yoari cjirire yahu dʉcaha. To ã ni yahuchʉ tʉhoa jipihtina masa cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ã yoa pari turi Jesu to majare pahã sʉchʉ masa payʉ tiro cahapʉ bʉcʉpariro dʉhtʉ cahapʉ cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ti ã cahmachuchʉ sã judio masa buheri wʉhʉre ñʉ wihboriro Jairo wama tiriro wihi, Jesure ñʉ, to dahpori cahapʉ na tuhcua caha sʉro, ");
INSERT INTO gvc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","õ sehe niha: —Yʉ macocã yariaro nihre. Ã jicʉ ticorore mʉ wamomaca mehne ña payo, noaricoro yoai taga. Mʉ ã yoachʉ ticoro masanohca —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","To ã nichʉ Jesu cʉ̃hʉ sehe tiro mehne wahaha. Mahai to wahachʉ payʉ masa tirore nʉnʉ ti wahcã bihsaro sʉrʉcʉ sʉha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","To ã bihsaro wahachʉ numino doce cʉhmari waro dachoripe cahã ñʉrucuricoro tói jiha. Tó pano payʉ duhturua ticorore ñano yʉhdʉchʉ yoaha. ");
INSERT INTO gvc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ã yoa duhturuare jipihtia to niñeru mehne wapamaha ticoro co tiro. Ti ã yoapachʉta ticoro mʉnanota jirucuha. Ã jiro ticoro tó pano to jiriro yʉhdoro ñano wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","To ã ñano yʉhdʉricoro to jichʉ masia Jesu to yoarire tʉhoa paina tíre yahuha ticorore. Ã ti yahuchʉ tʉhoro ticoro Jesu baharo masa payʉ watoi wihi, Jesu suhtirore ñaha ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Yʉhʉ to suhtiro dihtare ñaha ñʉco noaricoro wahacohca”, ni tʉhotuha. ");
INSERT INTO gvc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ã jiro ticoro to ñaha ñʉri baharo to cahã ñʉare duhuro to pjacʉre noari pjacʉ tʉhotuha. ");
INSERT INTO gvc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ã jiro Jesu to tuaa mehne dohatiare to cohãrire masino, masa watoi majare ñʉha. —¿Noa yʉ suhtirore ñaha ñʉri? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","To ã nichʉ tʉhoa to buheina õ sehe niha: —Bihsa nina. Ã jia masa payʉ mʉhʉre pihanocahna. “¿Noa yʉhʉre ñaha ñʉri?” nicʉ, ¿dohseacʉ ã nijari mʉhʉ? —niha tina sehe tirore. ");
INSERT INTO gvc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ã jiro Jesu tirore ñaha ñʉricorore macaha. ");
INSERT INTO gvc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","To ã macano watoi ticoro sehe to pjacʉ noano wahachʉ tʉhoturo cui, tetere na tuhcua caha sʉha to panoi tirore ño payoro. ");
INSERT INTO gvc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ã jiro ticoro poto yahu pahñoha tirore. To ã ni yahuri baharo Jesu ticorore õ sehe ni yahuha: —Maco, yʉhʉre mʉ wacũ tuaa mehne noaricoro tjuara mipʉre. Wahchea mehne wahaga. Dohatia marienicoro jiga —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","To ã ni durucuro watoi judio masare buheri wʉhʉre ñʉ wihboriro ya wʉhʉ macaina yahua wihiha: —Mʉ maco yariaa wahahre. Ã jicʉ buherirore pji tai tjiga —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ti ã nipachʉta ã tʉhotunocahno, Jesu ñʉ wihborirore õ sehe ni yahuha: —Cahya tʉhotui tjiga. Yʉhʉre wacũ tuaga. Tí dihtare yoaga —niha ñʉ wihborirore. ");
INSERT INTO gvc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ã ni tuhsʉ Santiago, to bahʉro João, Pedro tina dihtare “Yʉhʉ mehne taga”, niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ã pji wahcãno sã judio masa buheri wʉhʉre ñʉ wihboriro ya wʉhʉpʉ sʉha tina. Tí wʉhʉpʉ masa payʉ ñano bisi, ñahacaha tiia ti sañurucuchʉ ñʉha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","—Ñano ni, ñahacaha tiiena tjiga mʉsa. Maharicorocã mʉsa ã ni tiichʉ yariaerara. Carĩno nina —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","To ã nichʉ tʉhoa “Ã nimacanocano nina ahriro”, ni bʉjʉha tina sehe tirore. Ti ã yoachʉ tiro tinare sopacapʉ wio pahñonocaha. Ã wio tuhsʉro maharicorocã pʉcʉsʉmare, tiro mehne macaina cʉ̃hʉre ticorocã cahapʉ naaha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ã naa tuhsʉro Jesu ticorocãre to wamomacare ñaha: —Talita cumi —niha tiro. (“Talita cumi” nino, “ ‘Maharicorocã wahcãga’, nija yʉhʉ”, nino nina.) ");
INSERT INTO gvc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","To ã nichʉta ticorocã wahcãrʉcʉ sʉ, tiniha. Doce cʉhmari cjʉaricoro jiha ticoro. Ticorore to ã yoachʉ ñʉa tina cʉa yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ti ã yoachʉ ñʉno, Jesu tuaro mehne tíre to yoarire yahu site dutieraha. Ã yoa tuhsʉ ticorore chʉa wa dutiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ã yoa tópʉ jiriro waha, Jesu to buheina mehne to ya dihtapʉ tju sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ã tju sʉro Sabado jichʉ sã judio masa buheri wʉhʉi buhe dʉcaha Jesu. To ã buhechʉ masa payʉ tirore tʉhoa, cʉaa wahaha. —Cue, ¿ahriro nohopʉ tʉhoari ahri buheare? ¿Dohsearo noano masi pahñonocajari ahriro? Cohamacʉ tuaa mehne yoa ñona tiro to basi. ");
INSERT INTO gvc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ahriro taboa dahrari masʉno María macʉno, Santiago, José, Juda, Simo ti wahmino jimanaro. Ã yoa to bahana numia mari ya macai jisinimanabʉ. Ã jiro tiro mari yoaro sehe jiriro tjira —niha tina Jesure tʉhomarina. Ã jia Jesure ñʉ tuhtia, tirore cahmaeraha. ");
INSERT INTO gvc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ti ã cahmaerachʉ ñʉno õ sehe niha Jesu: —Cohamacʉ yare yahu mʉhtarirore paina ño payora. Ti ã ño payopachʉta to ya maca macaina, to coyea, to ya wʉhʉi jiina ño payoerara tirore. Ã jina yʉhʉre ño payoerara mʉsa õi yʉ bʉcʉariro jichʉ —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ã jiro tí macai jiro Jesu Cohamacʉ tuaa mehne yoa ño masieraha. Ã yoaeraparota cãina dohatiina bui to wamomacare duhu payo, noaina wahachʉ yoaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ã jiro tó macaina Jesure ti quihõno tʉhoerachʉ ñʉno cʉaa wahaha tiro. Ã jiro Jesu tó cahai jia macaripʉ buhero wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ã yoa Jesu doce to buheinare pjiroca, pʉaro dihta warocaha tinare macaripʉre buhe dutiro. Ã jiro to tuaare waha tinare watĩare ti cohã wiohto sehe. ");
INSERT INTO gvc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ã warocaro pãore, wajure, niñerure tiro naa dutieraha tinare. Ti tjuayucʉ dihtare naa dutiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ã ni tuhsʉ, dahpori tʉ cũa cahsarire sãa dutiha tinare. Cʉ̃nota suhtirore sãa dutiha tinare. Pʉaro sãa dutieraha. ");
INSERT INTO gvc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ã jiro õ sehe ni yahuha tinare: —Jipihtia macaripʉ mʉsare ti carĩno wachʉ tí wʉhʉihta tjuasiniga. Coã wahanapʉ wijaahga tí wʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ã jina pa maca macaina mʉsare ti cahmaerachʉ, ti tʉho duaerachʉ tí macare yʉhdʉana dahpori macaa dihta pohcari mene wajã site cũga mʉsa tinare ti ya buhirire masichʉ yoana —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ã jia tina doce buheina masare ti ñaa tʉhotumari cjirire tʉhotu cohtota duti, Cohamacʉre maca duti, buhea wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ã wahaa payʉ watĩare cohã wio, dohatiinare se mehne wisõa, noaina wahachʉ yoaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ã yoa Jesure masa payʉ masiha. Ã jiro to yoarire pʉhtoro Herode tʉhorocaha. Ã tʉhorocaro õ sehe ni tʉhotumaha tiro paina mehne: —João masare bautisariro yariariro cjiro pari turi bajuaro nica. Ã bajuariro jiro to tuaa mehne tíre yoaro nica —ni durucumaha Herode paina mehne. (“Jesu Joãota jira”, ni tʉhotumaha.) ");
INSERT INTO gvc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Paina sehe õ sehe ni tʉhotumaha: —Elia jira —ni tʉhotumaha. Paina sehe: —Cohamacʉ yare yahu mʉhtariro panopʉ macaina cjiri yoaro sehe jira tiro —ni tʉhotumaha Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ti ã ni tʉhotupachʉta Herode sehe Jesu to yoarire tʉhoro õ sehe ni tʉhotumaha: —João dapure yʉ cjã ta dutiriro cjiro bajuaro nica —ni tʉhotumaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Joãore ti wajãhto pano Herode tirore ñaha duti, peresu yoa dutiha. Tó pano Herode to bahʉro Felipe namonore Herodiare namo tiha. —Mʉ bahʉ namonore namo ticʉ Cohamacʉ dutiare yʉhdʉrʉcai nica mʉhʉ —ni yahumaha João Herodere. To ã niri buhiri to namono Herodia Joãore peresu ti yoachʉ cahmaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ã jiro ticoro sehe Joãore ñʉ tuhtiro, tirore wajã duti duamaha. Ã yoa duaparota ticoro tirore wajã duti masieraha. ");
INSERT INTO gvc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herode Joãore cuiro, “João noaare yoariro, ñaa buhiri marieriro jira”, ni tʉhotuha. Ã jiro Herodere cariboro yoaha João sehe tirore yahuro. Ã to caribopachʉta tiro wahchea mehne tʉhomaha Joãore. ");
INSERT INTO gvc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","To ã wahchea mehne tʉhopachʉta Herodia tirore to wajã dutihti dacho mʉ sʉha. Tí pjare Herode to masa bajuari dacho jichʉ tiro bose nʉmʉ dahreha. Ã jia to gobierno macaina, to surara pʉhtoa, Galilea macaina pʉhtoa cʉ̃hʉ to ya bose nʉmʉre ñʉa wihiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti ã wihiri baharo Herodia macono bose nʉmʉ ñʉno wihiro ti ñʉrocaroi basa ñoha. To ã basa ñochʉ ñʉa Herode to pjirocaina mehne wahcheha. Ã jiro õ sehe niha Herode ticorore: —Mʉ cahmaare siniga yʉhʉre. Ã jicʉ waihtja mʉhʉre mʉ cahmaare. ");
INSERT INTO gvc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cohamacʉ mehne potocã nii nija mʉhʉre. Mʉ sinino puro yʉ yare dacho macai waihtja mʉhʉre —niha tiro ticorore. ");
INSERT INTO gvc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","To ã nichʉ tʉhoro ticoro Herodia macono sehe to pocoro cahapʉ waha, õ sehe ni sinituha: —¿Yabare sinicohcari yʉhʉ? —ni sinituha ticoro to pocorore. —João masare bautisariro dapure siniga —niha to pocoro. ");
INSERT INTO gvc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","To ã nichʉta ticoro Herodia macono ño duaro mehne pʉhtoro Herode cahapʉ waha, siniha: —João masare bautisariro dapure waparo mehne waga yʉhʉre —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","To ã nichʉ tʉhoro pʉhtoro Herode sehe tuaro cahyaha. Masa ti ñʉrocaroi “Waihtja mʉhʉre”, ni tuhsʉha tiro. Ã jiro bʉo tiro “Mʉhʉre waeraja”, ni masieraha ticorore. ");
INSERT INTO gvc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ã jiro dóihta surarare peresupʉ jiinare cohtarirore João dapure cjã ta, na ta dutiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","To ã dutichʉ tʉhoro surara sehe waha, to dapure cjã ta, waparo mehne na taha. Na ta tuhsʉ, nuhminore Herodia maconore waha. To ã wachʉ ticoro to dapure ñaha, to pocorore yʉhdoha. ");
INSERT INTO gvc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ã jia João buheina sehe tíre tʉhoa tópʉre waha, to pjacʉ cjirore na wahcã, tãcapʉ ti sahari copapʉ na sãa duhu payoha. ");
INSERT INTO gvc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ã yoa Jesu to warocarina to cahapʉ tju sʉa, ti yoarire ti buherire yahuha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tí pjare masa payʉ ã majarerucua, tinare chʉro waeraha. Ã jiro õ sehe niha Jesu tinare: —Masa marienopʉ mari sahsero sosinina wahajihna —niha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ã jia tina ti sahsero dohoria mehne masa marienopʉ wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ti ã wahachʉ ñʉa masa payʉ tinare masiha. Ã masia payʉ macari macaina mahapʉ waha, Jesu to sʉhtopʉ tina masa sehe mʉroca wahcã sʉ mʉhtaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ti ã sʉchʉ Jesu wahã sʉ, bʉsocapʉ sãariro majano, tiro masa payʉ jiinare ñʉha. Oveja pʉa marieina yoaro sehe jiha tina masa, to ñʉchʉ. Ã jiro Jesu tinare pja ñʉno, payʉ noaare buhea tiha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ñamichahapʉ doce buheina Jesu cahapʉ sʉ õ sehe niha: —Õ masa marienopʉ jira. Ñamichahapʉ jira. ");
INSERT INTO gvc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Õ cahacãi jia macaripʉ daa macaricãpʉ, bʉjʉa macaripʉ ti chʉhtire nuchʉ dutiga masare ti puhi tihti cjihtire —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Chʉare waga tinare —nimaha Jesu to buheinare. To ã nichʉ õ sehe ni yʉhtiha: —¿Dos cientos dachori dahrari wapa niñeru mehne ti chʉhti pãore nuchʉbocari sã? —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Nohope curiri pão curiri jijari? Ñʉna wahaga —niha tiro. To ã nichʉ tina sehe chʉare boca õ sehe niha: —Cʉ̃ wamomaca pihtia curiri pão curiri, pʉaro wahi jira —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ti ã nichʉ tʉhoro Jesu sehe pja curuari tja bui duji dutiha masare. ");
INSERT INTO gvc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","To ã duji dutiri baharo tina pja curuari dujiha. Cãa curuari cincuenta masa jiha. Paye curuari sehe cien masa jiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ti ã duji tuhsʉchʉ ñʉno Jesu sehe cʉ̃ wamomaca pihtia curiri pão curirire, pʉaro wahi mehne na, mʉanopʉ ñʉha. Ã ñʉno Cohamacʉre “Noana”, niha. To ã niri baharo pão curirire nuha, to buheinare masare witi dutiro waha. Ã yoa tuhsʉ, pʉaro wahire witi dutiha jipihtinare. ");
INSERT INTO gvc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ã jia jipihtina chʉ, yapi yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ti yapi wahyorire doce pʉhʉse waro pãore, wahi cʉ̃hʉre na cahmachu wahpo dapoha tina. ");
INSERT INTO gvc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ã yoa pãore chʉina mʉa dihtare ti quihõchʉ cinco mil mʉa jiha. (Numia cʉ̃hʉ, macanacã cʉ̃hʉ tói chʉina jiha.) ");
INSERT INTO gvc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tí pjata Jesu to buheinare dohoriapʉ samu duti, sie coapʉ Betsaidapʉ to pano pahãyu dutiha. Ã jiro ti pahãri baharo Jesu sehe masare coha sitiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Coha siti tuhsʉ tʉ̃cʉpʉ Cohamacʉre sinino wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Baharo ñamipʉ dohoriai bʉcʉpariro dacho macai ti pahãrucuchʉ Jesu cʉ̃irota ti pahã tariropʉ jiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tópʉ jiro, tina ñano yʉhdʉ ti wajachʉ ti panoi wihnono tachʉ ñʉrocaha tiro. Ã jiro bohrea mʉja tahto pano tina cahapʉ waharo co bui ducu wahcãha. Tinare tiro yʉhdʉ wahcã duamaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","To yʉhdʉ wahcã duapachʉta tirore co bui to tachʉ ñʉa, “Yariariro cjiro jiboca”, ni tʉhotumaha tina. Ã ni tʉhotua tina sañurucuha. ");
INSERT INTO gvc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jipihtina tirore ñʉa, ñʉ cʉa waha, sañurucuha. Ti ã ñʉ cʉachʉ ñʉno Jesu tinare õ sehe ni yahuha: —Ne, yʉhʉre cuiena tjiga. Yʉhʉta jija —niha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ã ni tuhsʉ tiro tina mehne dohoriapʉ samua wahaha. To samuri baharocãta wihnono yʉhdʉa wahaha. To ã wahachʉ tina sehe cʉa yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","To pão payʉ yoarire wacũeraha tina. Tua yʉhdʉariro to jiare noano tʉho ñahaeraha. ");
INSERT INTO gvc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ã yoa tina pahã sʉ, Genesare dihtapʉ wahã sʉ, tia dohoriare dʉhte poho, dʉhtʉ cahapʉ pahsaha. ");
INSERT INTO gvc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ã yoa tina dohoriapʉ jiina ti majachʉta masa sehe Jesure ñʉ masiha. ");
INSERT INTO gvc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ã ñʉ masia jipihtiro ti ya yahpapʉ mʉroca maja, dohatiinare ti coãa cahsari mehne yo wahcã, sʉha Jesu cahapʉ. “Jesu tópʉ jihre”, masa ti nichʉ tʉhoa to cahapʉ sʉha tina. ");
INSERT INTO gvc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ã jia jipihtia macari to sʉa macaripʉ, bʉjʉa macaripʉ, daa macaricãpʉ, pache duaina cahapʉ, masa dohatiinare ti cũnopʉ Jesure to suhtiro dʉhtʉ cahare ñaha ñʉ dua tuaro siniha tina: —Mʉ suhtiro dʉhtʉ caha dihtare sãre ñaha ñʉ dutiga —ni siniha. Ã jia to suhtirore ñaha ñʉinape tópeinata noaina wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ã yoa Jerusalẽpʉ tarina sã coyea judio masare buheina, fariseo curua macaina cʉ̃hʉ Jesu cahapʉ cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Fariseo curua macaina jipihtina paina judio masa cʉ̃hʉ ti ñʉchʉsʉma cjiripʉ ti yoa dutiriro seheta wamo cosaro marieno chʉera tiha. Ã jia pache duaina cahapʉ waha, sʉ, majare tju wihiina cʉ̃hʉ ti yoa dutiriro seheta wamo cosaro marieno chʉera tiha. Payʉ paye dutia cʉ̃hʉre ti ñʉchʉsʉma cjiripʉ ti yoa dutiare yoaa tiha. Tasa waparire cosaa, dihi biatorire cosaa, comaa biatorire cosaa, yoaa tiha tina judio masa, “Cohamacʉ ã cahmana”, nia. Ã jia sã coyea judio masare buheina, fariseo curua macaina cʉ̃hʉ Jesu cahapʉ cahmachua, Jesu buheina wamo cosaro marieno ti chʉchʉ ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ã ñʉ tuhsʉa Jesure õ sehe ni sinituha: —Mʉ buheina chʉa, mari ñʉchʉsʉma cjiri ti yoa dutiriro cjiro seheta ti wamomacarine wamo cosaerara. ¿Dohse yoa mari dutiare yoaerajari? —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ti ã nichʉ tʉhoro Jesu õ sehe ni yahuha tinare: —Masa ti baharo bʉhʉsehei ñano yoa cohtaina jira mʉsa. Panopʉre Cohamacʉ yare yahu mʉhtariro cjiro Isaia potocãta yahuro niri jira mʉsa yoaro sehe tʉhoerainare. Õ sehe ni yahu, joaa tiha tiro: “Ahrina masa yʉhʉre noano durucupahta ti tʉhotuapʉ yʉhʉre ne ño payoerara. ");
INSERT INTO gvc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ã jia yʉhʉre ti ño payoa yaba cjihti jierara. ‘Cohamacʉ ya dutia jira ahri’, ni mahño buhera ti ya buhea sehere”, ni joaha Isaia cjiro. ");
INSERT INTO gvc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tí potocã tjira. Cohamacʉ ya dutia sehere duhu, masa ti yoa dutia sehere cohtota yoa yʉhdʉrʉcʉ sʉa tira mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cohamacʉ ya dutiare cohãna, mʉsa coyea ya dutia sehere yoara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Õ sehe yoana Cohamacʉ ya sehere yʉhdʉrʉcana nina mʉsa: Panopʉre õ sehe niha Cohamacʉ Moise cjiro to joariro seheta: “Mʉsa pʉcʉsʉmare ño payoga. Cʉ̃iro to pʉcʉsʉmare ñano quiti dahreriro jiro tí buhiri ti wajãhtiro cjihto jirohca”, niha Cohamacʉ Moise cjirore to cũri dutiai. ");
INSERT INTO gvc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","To ã nipachʉta õ sehe yoa dutira mʉsa ti pʉcʉsʉmare yoadoho dutierana: Ti pʉcʉsʉmare ti waborire Cohamacʉ sehere wa dutira mʉsa. Ã ni buhemana mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ã buhena ti pʉcʉsʉmare ño payochʉ yoaerara mʉsa tinare. ");
INSERT INTO gvc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ã yoana Cohamacʉ dutiare yʉhdʉrʉcana nina mʉsa mari ñʉchʉsʉma cjiri ya dutia sehere yoana. Painare mʉsa buhea dihtare tʉho dutira mʉsa. Payʉ tó sehe jiare yoara mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ã ni tuhsʉro paina cʉ̃hʉre pjirocaha tiro. Õ sehe niha tinare: —Mʉsa jipihtina yʉhʉre tʉhona taga. Tuhsʉ yʉ niare noano tʉho ñahaga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mʉsa dʉserire sãa sehe mʉsa chʉa sehe mʉsare buhiri tichʉ yoaerara. Ñaare mʉsa tʉhotua sehe mʉsare ñaina jichʉ yoara. ");
INSERT INTO gvc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yʉhʉre noano tʉhoga mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tinare ã ni yahu tuhsʉ Jesu masa cahapʉ jiriro cjiro waha, wʉhʉpʉ sãa wahaha. Ã to sãa sʉchʉ ñʉa to buheina sehe to buherire sinitu ñʉha. Ti ã sinitu ñʉchʉ tʉhoro õ sehe niha tiro: ");
INSERT INTO gvc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—¿Mʉsa cʉ̃hʉ ne tʉho ñahaerasinijari tíre? Mʉsa dʉserire sãa sehe mʉsa chʉa sehe mʉsare ñaina jichʉ yoaerara, Cohamacʉ to ñʉchʉ. ");
INSERT INTO gvc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tí mʉsa tʉhotuapʉre sãaerara. Mʉsa pjaropʉ sãa sʉ, yʉhdʉ wijaa wahara —niha Jesu. Ã nino “Jipihtia chʉa noaa jira”, nino niha. ");
INSERT INTO gvc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ã yoa õ sehe ni namoha tjoa: —Mʉsa ñaa durucua sehe mʉsa dʉseri wijaa sehe mʉsare ñaina jichʉ yoara, Cohamacʉ to ñʉchʉ. ");
INSERT INTO gvc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ñano tʉhotua, numia mehne ñano yoarucua, yacaa, masare wajãa, namo tiriropʉ jiparota pacorore manʉ tiricorore wʉana tia, pairo yare tuaro cjoa, ñano yoaa, mahñoa, bʉo tiro marieno ñaa yoaa, paina ti cjʉaare ñʉ yabia, ñano quiti dahrea, “Painare yʉhdʉrʉcaja”, ni tʉhotua, tʉho masieraina jia, tí jipihtia mʉsare mʉsa tʉhotuapʉ tara. ");
INSERT INTO gvc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jipihtia ahri ñaa mʉsa tʉhotuapʉ taa, mʉsare ñaina jichʉ yoara, Cohamacʉ to ñʉchʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ã ni tuhsʉro Tiro wama tiri maca cahapʉ, Sidõ wama tiri maca cahapʉ sʉro tó macari wʉhʉpʉ sãa wahaha. Ã sãahno painare to jiri wʉhʉre yahu dutieraha. Ã yahu dutieraparota tinare tiro duhti masieraha. ");
INSERT INTO gvc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tí pjareta numino to macono watĩno to cohtotaricoro to cahai jiha. Ã jia Jesu yoarire ñʉa paina to pocorore yahuha. Ti ã yahuri baharo to pocoro sehe waha, Jesu dahpori cahapʉ na tuhcua caha sʉha tirore ño payoro. ");
INSERT INTO gvc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ticoro Sirofenicia wama tiri yahpa macaricoro jiha. —Watĩnore cohã wiosiniga yʉ macore —ni siniha ticoro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","To ã sinichʉ tʉhoro õ sehe niha Jesu: —Wahmanore wʉhʉ pʉro pohna ya chʉare dieyacãre yʉ wa mʉhtachʉ tó wahaerara. Israe masa yare pa yahpa macainare yʉ wa mʉhtachʉ tó wahaerara —niha Jesu ticorore piti dahre yahuro. ");
INSERT INTO gvc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Ã tjira pʉhtoro. Ã jipachʉta dieyacã cʉ̃hʉ mesa docai ti pohna ti chʉ site boroare chʉ cohtara tinacã cʉ̃hʉ. (Pa yahpa macaricoro yʉ jipachʉta yʉhʉ cʉ̃hʉre yoadoho masina mʉhʉ) —ni yʉhtiha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Mʉ ã ni yʉhtichʉ mʉ macore watĩno wijaa tuhsʉhre. Ñʉco wahaga —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","To ã nichʉ tʉhoro majare tjuaa, to wʉhʉpʉ tju sʉro, to maconore watĩno marienicorore camapʉ jiricorore ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tí pjare Jesu Tiro wama tiri maca cahapʉ jiriro waha, Sidõ wama tiri macare sʉ yʉhdʉ wahcã, Decapoli wama tiropʉ jia macarine sʉ yʉhdʉ wahcã, Galilea wama tiri bʉcʉpariropʉ sʉha jʉna. ");
INSERT INTO gvc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ã jia cahmono tʉhoerarirore, noano durucu masierarirore Jesu cahapʉ na wihiha paina. —Mʉ wamomaca mehne ña payoga tirore —ni siniha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ti ã nichʉta Jesu sehe tʉhoerarirore na wahcã, masa marienopʉ sʉho sʉha. Ti sahsero jiha. Tuhsʉ, Jesu to wamo picari mehne tʉhoerariro cahmo coparire be sõha. Ã yoa tuhsʉ, chahcho puti, to ñahmanore ña payoha. ");
INSERT INTO gvc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ã yoa tuhsʉ mʉanopʉ ñʉ mʉo, yajeri na, õ sehe niha: —Efata —niha Jesu. (“Efata” nino, “Pjõohga”, nino nina. Ã nino tirore tʉho dutiro niha. Ã nino noano durucu dutiro niha.) ");
INSERT INTO gvc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","To ã nichʉta tiro sehe tʉho boca, to ñahmano bidaro wahachʉ tʉhoturo noano durucuha. ");
INSERT INTO gvc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ã jiro Jesu tinare tíre painare yahu site dutieraha. To ã yahu site dutierachʉ tʉhopahta tina sehe painare yahu site namoha. ");
INSERT INTO gvc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ã jia masa tʉho cʉa yʉhdʉa waha, õ sehe niha: —Jipihtiare tiro noano yoara. Tʉhoerainare noano tʉhochʉ yoara. Durucu masieraina cʉ̃hʉre noano durucuchʉ yoara Jesu —niha masa. ");
INSERT INTO gvc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tí pjare pari turi masa payʉ ti cahmachuri baharo chʉa maeraina ti jichʉ ñʉno Jesu to buheinare pjirocaha: ");
INSERT INTO gvc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ahrina masa tia dacho waro yʉhʉ mehne ji tuhsʉra. Ã yoa tinare puhi mariahna. Ti puhi maerachʉ ñʉcʉ tinare pja ñʉja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Paina tina mehne macaina yoaropʉ tahre. “Tinapʉ jʉca baaina mahai borari”, nicʉ tinare chʉa marieno ti wʉhʉsepʉ waha duti duaeraja. Ã jicʉ tinare puhi wa duaja —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—¿Dohse yoa mari õre masa marienopʉre pãore boca wabocari mari? —niha to buheina sehe Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Nohope curiri pão curirire cjʉajari mʉsa? —ni sinituha Jesu. —Siete curiri jira —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ti ã ni yʉhtichʉ tʉhoro, tiro masare yahpai duji duti, siete curirire pão curirire na, Cohamacʉre “Noana”, niha. Ã ni tuhsʉ, tí curirire nuha, to buheinare wa, masare witi dutiha. To ã dutiri baharo to buheina sehe pãore masare witiha. ");
INSERT INTO gvc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ã jia wahi cʉ̃hʉre mahainacã cjʉaha tina. Ã jiro tinare Cohamacʉre “Noana” ni, wahi cʉ̃hʉre witi dutiha. ");
INSERT INTO gvc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ti witi tuhsʉchʉ tina chʉa, yapi yʉhdʉa wahaha. Ti yapi wahyorire siete pʉhʉse waro wahpo dapoha tina. Tina cuatro mil bui masa jiha. ");
INSERT INTO gvc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Ã yoa tuhsʉ Jesu masare coha sitiha. Coha siti tuhsʉ to buheina mehne dohoriapʉ samuha. Samu tuhsʉ Dalmanuta wama tiro cahapʉ wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ã yoa fariseo curua macaina wihi, Jesu mehne cahma sayoha. Tina Jesure Cohamacʉ tuaa mehne yoa ño dutia, to yoa ño masierachʉ ñʉ duamaha. ");
INSERT INTO gvc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ti ã dutichʉ tʉhoro Jesu cahyaro mehne yajeri sãano, õ sehe niha: —¿Mʉsa mipʉ macaina dohse yoana mʉsa Cohamacʉ tuaa mehne yoa ñoare ñʉ duajari? Potocã niita nija mʉsare. Mipʉ macainare mʉsare Cohamacʉ tuaa mehne ne yoa ñosi yʉhʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ã ni tuhsʉ waha, pari turi dohoriapʉ samu, sie coapʉ pahãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ã wahaa, pãore boa waha, dohoriai cʉ̃ curita pãore cjʉaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ã yoa Jesu cuaro mehne yahuha tinare: —Noano yoanohbʉ. Fariseo curua macaina, Herode mehne macaina cʉ̃hʉ ti pão bʉcʉarore ñʉna noano yoaga. Cua nina tí —ni yahuha. ");
INSERT INTO gvc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To ã nichʉ tʉhoa tina to buheina sehe tíre ti basi õ sehe ni durucuha: —Mari pãore mari na taerachʉ ñʉno ã nino nica ahriro —nimaha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ti ã nirire masino tinare õ sehe ni sinituha Jesu: —¿Dohse yoana mʉsa pão borire wacũjari mʉsa? ¿Mʉsa masierasinijari? ¿Tʉho ñahaerasinijari? ¿Tʉho duaerajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Capari tiina jipanahta ñʉerajari mʉsa? ¿Ã jina cahmori tiina jipanahta tʉhoerajari mʉsa? ¿Mʉsa ahrire wacũerajari? ");
INSERT INTO gvc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Yʉhʉ cʉ̃ wamomaca pihtia pão curirire nuha, cinco mil bui masare yʉ warire wacũerajari mʉsa? ¿Ti yapi wahyorire nohope pʉhʉsere pão curirire wahpo dapori mʉsa? —niha Jesu tinare. —Doce pʉhʉse —ni yʉhtiha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—¿Ã yoa yʉhʉ siete curirire pão curirire cuatro mil bui masare yʉ wari baharo nohope pʉhʉsere pão curiri wahpo dapori mʉsa? —niha Jesu. —Siete pʉhʉse —ni yʉhtiha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Ã ñʉpanahta noano tʉho ñahaerasinijari mʉsa? —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ã yoa tina Betsaidapʉ ti sʉchʉ ñʉa, masa sehe capari ñʉerarirore na wihiha. —Tirore ña payoga —ni, tuaro siniha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ti ã sinichʉ tʉhoro, Jesu capari ñʉerariro wamomacare ñaha, tí maca dʉhtʉ cahapʉ tirore tʉã wahcãha. Tópʉ na sʉ, to caparire chahcho puti, to wamomacari mehne tirore ña payoha. —¿Mʉ ñʉchʉ bajujari? —ni sinituha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","To ã nichʉ tiro sehe ñʉno, õ sehe niha: —Mʉare ñʉja. Yʉ ã ñʉpachʉta tina yucʉri tinia yucʉ yoaro sehe bajura —niha capari ñʉerariro cjiro. ");
INSERT INTO gvc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","To ã nichʉ tʉhoro Jesu sehe to wamomacari mehne to caparire ña payoha tjoa. To ã ña payori baharo capari ñʉerariro cjiro tuaro to ñʉchʉ to capari noano bajuha. Ã yoaro jipihtiare noano ñʉha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","To ã ñʉ masichʉ ñʉno, Jesu tirore to wʉhʉpʉ warocaha. —Macapʉ pinihtare wahai tjiga —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ã yoa Jesu to buheina mehne Cesarea Filipo wama tiri maca cahai jia macaripʉ waha namoha. Tópʉ ti waharo wato, Jesu õ sehe ni sinitu ñʉha to buheinare: —¿Diro baro jicari yʉhʉ masa yʉhʉre ti tʉhotuchʉ? —ni sinitu ñʉha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","To ã sinitu ñʉchʉ tʉhoa õ sehe ni yʉhtiha tina: —“João masare bautisariro cjiro jira”, nina paina. Paina “Elia jira”, nina. Paina “Cohamacʉ yare yahu mʉhtaina cjiri mehne macariro jira”, nina mʉhʉre —ni yʉhtiha to buheina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ti ã ni yʉhtiri baharo Jesu õ sehe ni sinitu namoha tinare: —¿Mʉsa sehe mʉsa tʉhotuchʉ diro baro jicari yʉhʉ? —ni sinitu ñʉha tjoa. —Mʉhʉ Cristo Cohamacʉ masare yʉhdo duti to warocariro jira —ni yʉhtiha Pedro. ");
INSERT INTO gvc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","To ã nichʉ tʉhoro Jesu õ sehe niha: —Yʉhʉre “Cristo jira tiro”, ni yahu sitesiniena tjiga painare —niha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tinare to ã ni sinitu ñʉri baharo, õ sehe ni buhe dʉcaha tiro: —Yʉhʉ masʉno Cohamacʉ warocariro jija. Ã jicʉ tuaro ñano yʉhdʉcʉhca. Ãta waharo cahmana yʉhʉre. Mari coyea judio masa, bʉcʉna, sacerdotea pʉhtoa, mari judio masare buheina yʉhʉre cahmaeraa, yʉhʉre wajã dutiahca. Ti ã wajãchʉ tia dacho wahaboroi masa wijaaihca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ã nino ne tʉho wisiachʉ yoaro marieno yahuro niha tinare. To ã nichʉ tʉhoro Pedro sehe pa sehe curerocã Jesure narʉcʉ sʉ, tirore ã ni dutieraha. ");
INSERT INTO gvc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","To ã ni dutierachʉ tʉhoro Jesu to buheinare majare ñʉ, tuhtiha Pedrore: —Satana yoaro sehe durucui nina mʉhʉ. Ã nii tjiga. Mʉ tʉhotua masa ya jira. Cohamacʉ ya jierara —niha tiro Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ã ni tuhsʉ masare to buheina mehne tiro cahapʉ pjiroca, õ sehe niha: —Cʉ̃iro yʉ yairo ji duaro, to cahmano yoa duamarire duhunocanohca. Ã jiro crusapʉ yʉ ñano yʉhdʉhtiro seheta tiro yʉ yairo to jiri buhiri ñano yʉhdʉparota yʉhʉre duhusi. Ã jiro yʉ yare yoarucuriro jirohca. ");
INSERT INTO gvc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Masʉno to mʉ sʉro to cahmano seheta yoariro pichacapʉ tiro waharohca. Ã yoa masʉno yʉ yare ã yoarucuro, noaa buheare ã yoarucuro, jipihtia dachoripe yʉhʉ mehne mʉanopʉ jirucurohca. ");
INSERT INTO gvc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Cʉ̃iro masʉno ahri yahpa macaare jipihtiare cjʉariro pichacapʉ waharo yabare wapatajari tiro? Ã jiriro ne wapataerara. ");
INSERT INTO gvc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pichacapʉ to wahachʉ ne dohse wapa wiohto basioerara. Masʉno to jia tia wiho waro jierara. ");
INSERT INTO gvc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mipʉre ñaina, Cohamacʉre cahmaeraina ti mʉ sʉro ti yoari dacho jiro nina. Cãina yʉ wamare, yʉ buheare ni dua bʉo tiboca. Ti ã yoachʉ ñʉcʉ yʉhʉ masʉno Cohamacʉ warocariro noaina anjoa mehne yʉ Pʉcʉ to si sitero mehne tjua tacʉ yʉ wamare ni duapahta bʉo tiinare bʉo tisãaihca yʉhʉ cʉ̃hʉ —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ã ni tuhsʉ õ sehe ni namoha Jesu: —Potocãta niita nija mʉsare. Cãina mʉsa õpʉre jiina mʉsa yariahto pano pʉhtoro Cohamacʉ to sʉho jiropʉre yʉ sãachʉ yʉhʉre ñʉnahca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ã yoa seis dachori baharo Jesu Pedrore, Santiagore, ã yoa Santiago bahʉro João cʉ̃hʉre mʉadʉ tʉ̃cʉpʉ tina dihtare pji mʉjaha. Mʉanopʉ ti mʉja sʉri baharo ti ñʉrocaroi to pjacʉre cohtotaha. ");
INSERT INTO gvc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","To suhtiro noano si sitero, noano yehseri suhtiro wahaha. Ahri yahpa macaa numia suhti cosaa numia ã yehsechʉ yoa masierara. ");
INSERT INTO gvc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ã jia Elia cjiro, ã jichʉ Moise cjiro mehne Jesu mehne ti sʉhʉduchʉ ñʉha tina tiaro Jesu buheina. ");
INSERT INTO gvc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ã jia tina tuaro cuiha. Ã cuiro dohse ni masieramahno õ sehe nimaha Pedro: —Pʉhtoro, mari õi jichʉ noa duara. Tia wʉhʉcã yoanahtja sã. Mʉ ya wʉhʉcã, Moise ya wʉhʉcã, Elia ya wʉhʉcã yoanahtja —nimaha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","To ã niri baharocãta, me curua ti bui duji pja sʉha. To ã duji pja sʉchʉta, me curua watoi õ sehe nino coa taha: —Ahriro yʉ macʉ yʉ cahĩriro jira. Tʉhoga tirore —nino coa taha. ");
INSERT INTO gvc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ã nino coa tachʉta Pedro cʉ̃hʉ ñʉrocamaha. Jesu dihtare ñʉha. Ti ñʉrina cjiri sehe mariaha jʉna. ");
INSERT INTO gvc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ã jiro tʉ̃cʉpʉ ti duji tachʉ Jesu tinare õ sehe ni yahuha: —Michapucacã yʉhʉre ã waharire painare yahuena tjiga. Yʉhʉ masʉno Cohamacʉ warocariro yʉ yaria masa wijaari baharo tíre painare yahuga mʉsa —ni yahuha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ã jia to dutiriro seheta tina ti ñʉrire yahueraha painare. Ã jia tina ti basi õ sehe ni sinitu durucuha: —“Yʉ yaria masa wijaari baharo” nino, ¿dohsearo ã niri tiro? —ni durucuha tina. Ã jia Jesure õ sehe ni sinituha: ");
INSERT INTO gvc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","—“Cristo to tahto pano Eliare ta mʉhtano cahmana”, nina mari coyea judio masare buheina. ¿Dohse jiro baro ã nijari tina? —ni sinituha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesu õ sehe ni yʉhtiha: —Potocã tjira. Eliare ta mʉhta dutire Cohamacʉ, jipihtiare cahno mʉhtahtiro cjihtore. Yʉhʉ masʉno Cohamacʉ warocariro payʉ tahari ñano yʉhdʉihca. Paina yʉhʉre cahmaeraa, ñano yoaahca. ¿Tí cʉ̃hʉre masijari mʉsa? Ã jicʉ ahrire niihtja mʉsare: Elia wihi tuhsʉre. To ã wihipachʉta tina ti cahmariro seheta tirore ñano yoaha. Ãta ni joaha tirore —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ã yoa duji ta, paina buheina cahapʉ sʉ, payʉ masare ñʉha Jesu. To buheina sehe judio masare buheina mehne cahma sayoa niha. ");
INSERT INTO gvc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ã jia Jesu cʉ̃hʉ ti duji tachʉ ñʉa, jipihtina masa cʉaa waha, tiro cahapʉ mʉrocaa wahaha. Tiro cahapʉ sʉa: —¿Tamajari? —niha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—Tamaja —ni tuhsʉ—, ¿dohse ni cahma sayona niri mʉsa tina mehne? —ni sinituha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To ã ni sinituchʉ tʉhoro, masa watoi ducuriro õ sehe ni yahuha tirore: —Buheriro, yʉ macʉre watĩno to cohtotarirore mʉhʉre na tamahi. Watĩno sehe tirore durucu dutierara. ");
INSERT INTO gvc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yʉ macʉre to ñahachʉ yahpapʉ bora, bahca diho, bʉhaa wahaa tire tiro. Ã waharo sahpo tua tire. Ã jicʉ mʉ buheinare watĩnore cohã wio dutimahi. Yʉ ã dutipachʉta tina sehe cohã wio masierare watĩnore —ni yahuha Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","To ã nichʉ tʉhoro Jesu õ sehe niha tinare: —Ne, yʉhʉre wacũ tuaerara mʉsa. Yoabiari pja mʉsare buhemaja yʉhʉ. ¿Noho puro yoari pja yʉhʉre mʉsa caribobocari? Tirore na tahga yʉhʉre —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","To ã nichʉ tʉhoa watĩno to cohtotarirore Jesu cahai na taha. Ti na wihichʉ ñʉno watĩno sehe wahma wahmʉa tarirore yahpapʉ doca caha sʉ, tunu teterechʉ yoaha. Ã yoa sahpo tua wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—¿Noho puro yoari pja watĩno to cohtotariro jijari ahriro? —ni sinituha Jesu sehe to pʉcʉrore. —Wihãrirocã jiropʉta tiro watĩno to cohtotariro jira. ");
INSERT INTO gvc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ã cohtotaro payʉ tahari watĩno sehe tirore pichacapʉ, copʉ cʉ̃hʉre cohã wajãmaha. Ã jicʉ mʉhʉ yoa masicʉ sãre pja ñʉ, yoadohoga —niha to pʉcʉro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","To ã nichʉ tʉhoro õ sehe niha Jesu: —¿Dohsea jiro baro “Mʉhʉ yoa masicʉ”, nijari mʉhʉ yʉhʉre? Yʉhʉre mʉ wacũ tuachʉ ñʉno, Cohamacʉ jipihtiare yoa pahño masina mʉhʉre yoadohobasaro —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To ã nichʉta wahma wahmʉa tariro pʉcʉro õ sehe ni sañurucuha: —Mʉhʉre wacũ tuaja. Yʉ wacũ tuaerachʉ ñʉcʉ yʉhʉre yoadohoga mʉhʉre yʉ noano wacũ tuahto sehe —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ã jiro masa payʉ tina cahapʉ mʉroca ta, ti cahmachuchʉ ñʉno, Jesu watĩnore õ sehe ni tuhtiha: —Mʉhʉ durucu dutierariro, tʉho dutierariro ahrirore cohtotariro wijaahga. Ã wijaacʉ tirore pari turi cariboi tjiga —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","To ã nichʉ tʉhoro watĩno sañurucu, wahma wahmʉa tarirore yahpapʉ doca caha sʉ tunu teterechʉ yoa, wijaaha. To ã wijaachʉ wahma wahmʉa tariro yariariro yoaro sehe wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","—Tiro yariaa wahara —nimaha masa payʉ. Ti ã nipachʉta Jesu sehe to wamomacare ñaha, tirore wahcõha. To ã wahcõchʉ wahcãha tiro sehe. ");
INSERT INTO gvc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Baharo Jesu cʉ̃hʉ wʉhʉpʉ ti sãa sʉchʉ to buheina tirore õ sehe ni sinitu ñʉha: —¿Dohseana sã sehe watĩnore cohã wio masierari, mʉ tʉhotuchʉ? —ni sinitu ñʉha tina. ");
INSERT INTO gvc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Ahriro baro watĩnore cohã wio duana Cohamacʉre tuaro sinino cahmana mʉsare. Ã yoa duana chʉ duhuro cahmana mʉsare Cohamacʉre sinina tana —ni yʉhtiha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ã yoa tópʉ jiina waha, Galilea yahpapʉ sʉ, yʉhdʉaha. Tópʉ ti waharire paina ti masichʉ cahmaeraha Jesu to buheinare buhe duaro. ");
INSERT INTO gvc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tópʉ sʉro to buheinare buhea tiha. Õ sehe ni buheha: —Yʉhʉ masʉno Cohamacʉ warocariro jija. Masa yʉhʉre ñaha, painapʉre yʉhʉre waahca. Ti ã wari baharo yʉhʉre wajãahca tina. Ti ã wajãricʉ tia dacho wahaboroi masa wijaaihca —niha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","To ã nichʉ tʉhoa tina noano tʉhoeraha. Ã jia cuia tirore tíre sinitu ñʉ namoeraha. ");
INSERT INTO gvc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ã yoa tina Capernaupʉ ti sʉri baharo wʉhʉpʉ ti jichʉ Jesu sehe õ sehe ni sinituha tinare: —¿Mahapʉre tana, dohse ni durucu tana niri mʉsa? —ni sinituha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","To ã nichʉ tina yʉhtieraha. Mahapʉre taa, cahma õ sehe ni durucu taa niha: —¿Mari mehne macarirore diro sehere mari pʉhtoro sõnahcari mari? —ni durucua niha mahai tarucua. ");
INSERT INTO gvc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ã jia ti ã nirire bʉo tia Jesure yʉhtieraha. Ti ã yʉhtierachʉ ñʉno Jesu nuju sʉ, to buheinare doce buheinare pjiroca õ sehe niha: —Mʉsa pʉhtoa ji duana jipihtina masa ti cahamaca jiro cahmana mʉsare. Tuhsʉ, wiho jiina jipihtina docai jinahca mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ã nino nijinocãre tina watoi duhu dapoha. Duhu dapo tuhsʉ tirocãre na wʉa, õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Yʉ yare yoa duana ahrirocãre mʉsa cahmana, yʉhʉ cʉ̃hʉre cahmana mʉsa. Ã yoa yʉhʉre cahmana, yʉhʉre warocariro mari Pʉcʉ cʉ̃hʉre cahmana mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Baharo João õ sehe niha Jesure: —Buheriro, mʉ wama mehne mʉ tuaa mehne watĩare cohã wiorirore sã ñʉhi. Tiro mari mehne macariro to jierachʉ ñʉna tíre tirore yoa dutiera tihi sã —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ti ã nichʉ tʉhoro Jesu tinare õ sehe ni yahuha: —Ã niena tjiga mʉsa tirore. Cʉ̃iro yʉ wama mehne Cohamacʉ tuaa mehne yoaro, baharo yʉhʉre ñano ni durucu masierara. ");
INSERT INTO gvc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Marine ñʉ tuhtiriro jieraro, tiro mari mehne macariro jira. ");
INSERT INTO gvc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mʉsare potocãta nii nija. Yʉ yaina mʉsa jichʉ ñʉa paina mʉsare ti yoadohochʉ ñʉno Cohamacʉ tinare noano yoarohca. Core mʉsare ti sihõchʉ mahanocã ti wapachʉta tinare noano yoarohca Cohamacʉ ti ã yoari wapa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ã yoa Jesu õ sehe ni yahu namoha: —Ahrirocã sehe jirirore yʉhʉre wacũ tua dʉcarirore yahuihtja mʉsare. Pairo ahrirocã sehe jirirore ñaare yoa dutiro tiro ñabiaro yʉhdʉrohca. Cʉ̃irore to wamʉapʉ pjiria tãcare dʉhte yo, pjiri mapʉ tirore ti cohãchʉ ñano wahaboa tiro. Ã jiro ahrirocã sehe jirirore ñaare yoa dutiriro tiro sehe pjiri mapʉ ti cohãriro yʉhdoro ñano yʉhdʉrohca. ");
INSERT INTO gvc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","’Mʉ wamomaca mehne ñano yoacʉ tí wamomacare mʉ dʉte cohãboro seheta tí mʉ ñaa yoaa sehere duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Tópʉre ne pichaca yatierara. Ã yoa dachoa ne yarierara. Mʉ wamomacare mʉ cohãchʉ tí si dihta butiboa. Tuhsʉ, mʉhʉ sehe ã si jipaihta baharo Cohamacʉ mehne jiihca. Pʉa wamomaca mehne pichacapʉ wahacʉ mʉ ã wahachʉ ñaa yʉhdʉaboa mʉhʉre. Ã jicʉ tí mʉ ñaa yoaa sehere duhuga. ");
INSERT INTO gvc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","’Mʉ dahporo mehne ñano yoacʉ tí dahporo cʉ̃hʉre mʉ dʉte cohãboro seheta tí mʉ ñaa yoaa sehere duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Tópʉre ne pichaca yatierara. Ã yoa dachoa ne yarierara. Mʉ dahporore mʉ cohãchʉ tí si dihta butiboa. Tuhsʉ, ã si jipaihta baharo Cohamacʉ mehne jiihca. Pʉa dahporo mehne pichacapʉ wahacʉ mʉ ã wahachʉ ñaa yʉhdʉaboa mʉhʉre. Ã jicʉ tí mʉ ñaa yoaa sehere duhuga. ");
INSERT INTO gvc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","’Mʉ capariaca mehne ñano yoacʉ tiare orewe mʉ cohãboro seheta tí mʉ ñaa yoaa sehere duhuga. Tíre duhueracʉ pichacapʉ wahaihca. Tópʉre ne pichaca yatierara. Ã yoa dachoa ne yarierara. Tiare mʉ cohãchʉ tia dihta butiboa. Cʉ̃ bʉhʉsehe capariaca mariapaihta baharo Cohamacʉ mehne jiihca. Pʉa capariaca mehne pichacapʉ wahacʉ mʉ ã wahachʉ ñaa yʉhdʉaboa mʉhʉre. Ã jicʉ tí mʉ ñaa yoaa sehere duhuga. ");
INSERT INTO gvc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ahri yahpai jina ñano yʉhdʉnahca mʉsa. Pichacapʉ mari jʉ̃chʉ marine purĩno seheta ñano yʉhdʉnahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moa noano coara. Moa coaerachʉ, coa yoahto basioerara. Moa coaeraro tí moa ne noaerara. Tí moare dohseahto basioerara. Moa noano to coaro seheta mʉsa cʉ̃hʉ ji coaina jiga. Tuhsʉ, paina mehne noano mehne jiga —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ã yoa tiro tópʉ jiriro waha, Judea yahpa cahapʉ sʉ, Jordão wama tiri ma pa bʉhʉsehe coapʉ sʉha. Tópʉ to sʉchʉ ñʉa masa payʉ tiro cahapʉ cahmachuha tjoa. Ti ã cahmachuchʉ ñʉno tó pano to buheriro seheta pari turi buheha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","To ã buhero watoi fariseo curua macaina wihiha. Jesure ñano to durucuchʉ tʉho duamaha tina tirore yahusã duaa. Ã tʉho duaa tina Jesure õ sehe ni sinitu ñʉha: —¿Mari namore cohãchʉ noabocari? ¿Mari dutia sehe tó seheta yoa dutijari, mʉ tʉhotuchʉ? —ni sinitu ñʉha tina. ");
INSERT INTO gvc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Dohse yoa dutiri Moise cjiro mʉsare? —ni yʉhtiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—“Mʉ namore cohã duacʉ papera pũi tíre joaga. Ã joacʉ tí pũre mʉ namore mʉ wari baharo ticorore cohã masina mʉhʉ”, ni joaa tiha Moise cjiro —ni yʉhtiha fariseo curua macaina sehe. ");
INSERT INTO gvc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ti ã nichʉ tʉhoro õ sehe ni yahuha Jesu: —Cohamacʉ dutiare mʉsa yoa duaerachʉ ñʉno ã ni joaa tiha Moise cjiro. ");
INSERT INTO gvc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","To ã ni joariro jipachʉta ahri yahpare bajuamehneriro mʉno, numino cʉ̃hʉre yoaha. ");
INSERT INTO gvc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ã jiro mʉno to pʉcʉsʉmare cohã wijaa, to namono mehne jirohca. ");
INSERT INTO gvc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ã jia tina pʉaro jipahta cʉ̃ pjacʉ yoaro sehe jira. Tina pʉaro yoaro seheta jierara. Cʉ̃ pjacʉ yoaro sehe jia nina. ");
INSERT INTO gvc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cohamacʉ to wamomaca dʉhte dutiina jira. Ã jia tinare duhueraro cahmana —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ã ni tuhsʉ tiro to buheina mehne wʉhʉpʉ sãa wahaha. Wʉhʉpʉ sãa sʉa, ti namosãnumiare cohãare to buheina sinitu ñʉha tjoa tirore. ");
INSERT INTO gvc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ti ã sinitu ñʉchʉ tiro õ sehe ni yʉhtiha: —To namonore cohãriro pacorore namo tiro, pacoro mehne ñano yoariro jira. Ã jiro to cohãricorore ñano wahachʉ yoaro nina. ");
INSERT INTO gvc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ã yoa numino sehe to manʉnore cohãno, pairore manʉ tiro, tiro mehne ñano yoaricoro jira —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ã yoa macanacãre Jesure ña payo dutia taa tinacãre Jesu cahapʉ na taa tiha. Ti ã na tachʉ ñʉa to buheina sehe tinacãre na tainare tuhtiha. ");
INSERT INTO gvc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ti ã tuhtichʉ ñʉno Jesu suaha tina mehne. Ã suaro õ sehe niha tinare: —Macanacã yʉ cahapʉ tajaro. “To cahai wahaena tjiga”, niena tjiga tinacãre. Tinacã Cohamacʉre ti pʉhtoro tʉhotura. Pʉhtoro Cohamacʉ to sʉho jiina ahrinacã yoaro sehe tʉhotuina baro dihta jira. ");
INSERT INTO gvc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Potocã niita nija mʉsare. Ahrinacã Cohamacʉ ti pʉhtoro cjihtore cahmana. Ti yoaro seheta mʉsa cʉ̃hʉ Cohamacʉ mʉsa pʉhtoro cjihtore cahmaerana, pʉhtoro Cohamacʉ to sʉho jihtina ne jisi mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ã ni tuhsʉ Jesu macanacãre na wʉa tjiãhno, tinacãre ña payoro, õ sehe niha: —Ahrinacã noainacã wahajaro —ni sini payoha Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ã yoa Jesu mahai to waharucuchʉ pairo sehe mʉroca wihi, to dahpori cahapʉ na tuhcua caha sʉha tirore ño payoro. —¿Ne, noariro buheriro, yʉhʉ jipihtia dachoripe Cohamacʉ mehne ã jirucu duacʉ dohse yoacʉhcari yʉhʉ? —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","To ã nichʉ Jesu õ sehe ni yʉhtiha: —¿‘Noariro’ ni pisujari mʉhʉ yʉhʉre? Noariro sehe Cohamacʉ dihta jira. ");
INSERT INTO gvc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ahri Cohamacʉ dutiare masina mʉhʉ: Masare wajãena tjiga. Namo tiriropʉ paye numia mehne jiena tjiga. Yacaena tjiga. Mahñoa mehne pairore yahusãena tjiga. Paina yare mahño naena tjiga. Mʉsa pʉcʉsʉmare ño payoga. Ahri dutiare yoaihca mʉhʉ —ni yahuha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Buheriro, yʉhʉ tí jipihtiare wahma wahmʉa tariro jiipʉta yʉhdʉrʉcaera tihi yʉhʉ —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","To ã nichʉ tʉhoro Jesu sehe tirore cahĩa mehne ñʉroca õre. Ã ñʉroca õno, õ sehe niha: —Mahanocã dʉhsara mʉhʉre mʉ yoa pahñohto. Jipihtiare mʉ yare duai wahaga. Ã yoacʉ jipihtia mʉ wapatari niñerure pjacʉoinare waga. Mʉ ã yoachʉ payʉ mʉ ya noaa mʉanopʉ, Cohamacʉ cahapʉ jiyuahca. Mʉ ã yoari baharo yʉhʉ mehne macariro cjihto taga —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","To ã nichʉ tʉhoro tiro sehe payʉ pache cjʉariro jiro tíre pjacʉoinare wa duaeraro, cahya, jicoaeraa, wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","To ã cahyachʉ ñʉno Jesu majarerʉcʉ sʉro, to buheinare ñʉroca õ, õ sehe niha: —Pache pʉa pʉhtoro Cohamacʉ to sʉho jiropʉre ti waha duachʉ mijobiara —niha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","To ã nichʉ tʉhoa tina sehe tíre tʉho cʉaa wahaha. Ã ni tuhsʉ Jesu pari turi õ sehe ni yahu namoha tinare: —Coyea, jipihtina Cohamacʉre wacũno marieno “Mari mʉ sʉro mari cjʉaa mehneta noano yʉhdʉnahca”, ni tʉhotuina pache pʉa pʉhtoro Cohamacʉ to sʉho jiropʉre ti waha duachʉ mijobiara. ");
INSERT INTO gvc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camello sehe awicã copacãre to sãa nuhri wijaa duachʉ basioerara. To ã jiro yʉhdoro pache pʉro pʉhtoro Cohamacʉ to sʉho jiropʉre to waha duachʉ nu mijobiara —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","To ã nichʉ tʉhoa tina sehe tʉho cʉa yʉhdʉa waha, ti basi õ sehe niha: —Cue, to nino seheta potocã jichʉ ne cʉ̃iro masʉnore yʉhdoeraboca Cohamacʉ —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ti ã nichʉ tʉhoro Jesu tinare ñʉroca õ, õ sehe niha: —Masa ti basi ti mʉ sʉro yʉhdʉ masierara. Wiho mejeta Cohamacʉ sehe masare pichacapʉ wahaborinare yʉhdo masina. Tiro jipihtiare noano yoa masi pahñoriro jira —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","To ã nichʉ Pedro tirore õ sehe niha: —Tʉhosiniga. Sã sehe jipihtia sã yare cũnocaa tii mʉhʉ mehne tana —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","To ã nichʉta Jesu õ sehe niha: —Potocã niita nija mʉsare. Noaa buheare, yʉ yare yoana tana yʉhʉre ño payona tana mʉsa wʉhʉsere, mʉsa bahanare, mʉsa pocosãnumiare, mʉsa pohnare, mʉsa weserire cũnocarina jina, pjíro wapatanahca mʉsa mipʉre. ");
INSERT INTO gvc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ã yoana mʉsa wʉhʉserire, mʉsa bahanare, mʉsa pocosanumiare, mʉsa pohnare, mʉsa weserire, tó pano mʉsa cjʉariro yʉhdoro mipʉre payʉ cjʉanahca mʉsa. Ã yoa paina mʉsare ñano yoaahca. Ã jina baharopʉre pa turupʉ jipihtia dachoripe Cohamacʉ mehne jinahca. ");
INSERT INTO gvc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mipʉre payʉ pʉhtoa jirina cjiri tí pjapʉre wiho jiina tjuanocaahca. Ã yoa mipʉre payʉ wiho jiina jirina cjiri tí pjapʉre pʉhtoa cohtotaahca tjoa —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ã yoa tina mahapʉ maja, Jerusalẽpʉ mʉjaa niha. Jesu ti panocã mʉ tãha. Ã to mʉ tãchʉ ñʉa to buheina ñʉ cʉaa wahaha. Ã yoa ti baharo nʉnʉ tiina sehe cuiro mehne nʉnʉ tiha. Ã yoa Jesu doce to buheinare ti sahsero naaha tjoa. Ã naa tuhsʉ, masa tirore ti dohse yoahtire Jesu yahu dʉcaha tinare: ");
INSERT INTO gvc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Tʉhoga yʉhʉre. Mipʉre Jerusalẽpʉ wahana nija mari. Tópʉ masa yʉhʉre masʉnore Cohamacʉ warocarirore ñaha, painapʉre yʉhʉre waahca. Sacerdotea pʉhtoare, mari coyea judio masare buheina cʉ̃hʉre yʉhʉre waahca. Ã jia yʉhʉre wajã dutiahca tina. Ã wajã dutia judio masa jieraina sehere yʉhʉre waahca. ");
INSERT INTO gvc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ti ã wari baharo tina sehe yʉhʉre bʉjʉpe, chahcho puti sihõ, tjana, wajãahca. Ã yoa yʉ yariari baharo tia nʉmʉ wahaboroi masa wijaaihca —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ã yoa Santiago, João mehne Jesu cahapʉ sʉa, siniha tirore. Tina Zebedeo pohna jiha. Ã jia õ sehe ni siniha: —Buheriro, sã sinino seheta sãre yoaga mʉhʉ —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Dohse yʉ yoachʉ cahmajari mʉsa? —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Jipihtina bui pʉhtoro jicʉ sãre mʉhʉ mehne duji dutiga. Cʉ̃iro mʉ poto bʉhʉsehei pairo mʉ cõ bʉhʉsehei duji dutiga sãre, mʉhʉ mehne pʉhtoa sã jihto sehe —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ti ã nichʉ tʉhoro õ sehe ni yahuha Jesu tinare: —Mʉsa ñano yʉhdʉhtore masierapanahta ã sinina yʉhʉre. ¿Mipʉre yʉ ñano yʉhdʉhto seheta ñano yʉhdʉna cʉ̃no pjabocari mʉsa cʉ̃hʉ? —ni sinituha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","To ã sinituchʉ tʉhoa tina õ sehe ni yʉhtiha: —Cʉ̃no pjanahca —ni yʉhtiha tina. Ti ã nichʉ Jesu õ sehe ni yahuha: —Yʉ ñano yʉhdʉhto seheta ñano yʉhdʉnahca mʉsa cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mʉsa ã yʉhdʉhtina mʉsa jipachʉta, yʉhʉ mehne dutihtinare, yʉhʉ mehne dujihtinare bese masieraja yʉhʉ. Ahrire yʉ Pʉcʉ sehe cahno tuhsʉre. Ã jia to besehtina dihta yʉ poto bʉhʉsehei yʉ cõ bʉhʉsehei dujiahca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ã jia paina diez buheina Santiago, João ahrina pʉaro mehne susiniha ti ã sinirire tʉhoa. ");
INSERT INTO gvc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ti ã susinichʉ ñʉno Jesu to buheinare pjiroca, õ sehe niha: —Cohamacʉre masieraina pʉhtoa sehe ti masare dutia, purĩno mehne dutira. ");
INSERT INTO gvc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉsa sehe ne ã yoasi mʉsa basi. Diro mʉsa mehne macariro mʉsa bui pʉhtoro ji duaro, jipihtina tiro mehne macaina cahamacʉno yoaro sehe jia tiro cahmana tirore. ");
INSERT INTO gvc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ã yoa diro mʉsa mehne macariro mʉsare dutiriro ji duariro mʉsa cahamacʉno yoaro sehe jia tiro cahmana tirore. ");
INSERT INTO gvc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tó seheta jiriro jija yʉhʉ cʉ̃hʉ. Yʉhʉ masʉno Cohamacʉ warocariro jipacʉta ahri yahpapʉre yʉhʉre mʉsa yoadohohtire mʉsare sinii tai nierahi. Mʉsa sehere yoadohoi tai nii. Ã yoacʉ payʉ masa ya buhirire yaria, wapabasai tai nii. Yʉ ã yariaro mehne payʉ masare pichacapʉ wahaborinare yʉhdʉchʉ yoai tai nii —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ã yoa baharo tina Jericópʉ sʉha. Jesu to buheina mehne, ã jichʉ paina masa payʉ mehne tí macai jiina ti wahachʉ tí macare ti yʉhdʉ wahcãchʉ waro, Bartimeo sehe ti wahari maha dʉhtʉ cahai dujiha. Tiro Timeo macʉno capari ñʉerariro jiro, masare niñerucãre ã sinirucuriro jiha. ");
INSERT INTO gvc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ti wahari maha dʉhtʉ cahai dujiro, “Jesu Nazare macariro tara”, ti nichʉ tʉhoro, Bartimeo sehe õ sehe ni sañurucuha: —Jesu, Davi cjiro panamino masare yʉhdohtiro, pja ñʉga yʉhʉre —ni sañurucuha Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","To ã nichʉ tʉhoa masa payʉ Bartimeore “Dihta mariahga”, ni tuhtiha tina tirore. Ti ã ni tuhtichʉ tʉhoro Bartimeo tó pano to sañurucuriro yʉhdo curero sañurucu namoha tjoa: —Jesu, Davi cjiro panamino masare yʉhdohtiro, pja ñʉga yʉhʉre —ni sañurucuha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","To ã ni sañurucuchʉ tʉhoro Jesu sehe tjuarʉcʉ sʉ, “Pjirocaga tirore”, niha. To ã nichʉ tʉhoa tina sehe capari ñʉerarirore õ sehe ni yahuha: —Wahchega. Wahcãrʉcaga. Tiro mʉhʉre pjira —niha tina Bartimeore. ");
INSERT INTO gvc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ti ã nichʉ tʉhoro to bui macari suhtirore tjuwe cũ, pu wahcãrʉcʉ sʉ, Jesu cahapʉ sʉrʉcʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ã jiro, Jesu sehe õ sehe ni sinituha tirore: —¿Dohse yʉ yoachʉ cahmajari mʉhʉ? —niha Jesu tirore. —Yʉ pʉhtoro, yʉhʉre ñʉchʉ yoaga —niha capari ñʉerariro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Wahaga mʉhʉ. Mʉhʉ yʉhʉre wacũ tuacʉ noariro wahara —niha Jesu tirore. To ã nichʉta capari ñʉerariro ñʉa wahaha. Ã noariro waharo Jesu mehne mahapʉ wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ã yoa tina Jerusalẽpʉ ti sʉhto panocã tʉ̃cʉ Olivo wama tidʉ dʉhtʉ cahai jiri maca Betfagé wama tiri maca cahai, ã jichʉ Betania wama tiri maca cahai sʉ mʉhtaha. Tí macari pʉa maca cahai Jesu sʉro, to buheina pʉarore warocaro taro, õ sehe ni yahu quihõha: ");
INSERT INTO gvc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Sí macapʉ wahaga. Tópʉ sʉna dóihta burrocãre ti dʉhte daporirocãre boca sʉnahca. Tiro ne cʉ̃iro ti pisamahnoerarirocã jica. Tirocãre bocana, yuta dare pjã, na tabasaga yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mʉsa tirocãre pjãchʉ ñʉno cʉ̃iro dohse jiriro, “¿Dohse yoana tana burrocãre dʉhte dapori dare pjãjari mʉsa?”, to nichʉ tʉhona, õ sehe ni yʉhtiga tirore: “Mari pʉhtoro burrocãre cahmarocasinire. Michapucacãta wiarohca tiro”, ni yahuga tirore —ni yahu duti warocaha to buheina pʉarore. ");
INSERT INTO gvc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","To ã nichʉ waha, tí wʉhʉ sopaca cahai burrocãre ti dʉhte daporirocãre bocaha. Boca, tirocãre pjãha. ");
INSERT INTO gvc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tirocãre yuta dare ti pjãchʉ ñʉa tói ducuina õ sehe ni sinituha tinare: —¿Dohse yoana tana burrocãre dʉhte dapori dare pjãjari mʉsa? —ni sinituha tina. ");
INSERT INTO gvc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ti ã nichʉ tʉhoa, tina sehe Jesu to niriro seheta yahuha tói ducuinare. Ti ã ni yahuchʉ tʉhoa tói ducuina sehe “Naahga”, niha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ã jia tina burrocãre Jesu cahapʉ na sʉha. Ti na sʉri baharo tirocã bui ti bui sãa suhtire ti pjũpaha payo tuhsʉchʉ ñʉno, Jesu sehe tirocã bui mʉja pja, wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tirocã bui to wahachʉ ñʉa, masa payʉ ti bui sãa suhtire tjuwe na, to wahahti mahai saño cũ mʉhtaha, Jesure ño payoa. Paina sehe campopʉ pũri tia dʉpʉrire yucʉ dʉpʉrire dʉte na ta, to wahahti mahai duhu cũha. ");
INSERT INTO gvc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ã jia to pano wahaina, to baharo nʉnʉ tiina mehne õ sehe ni sañurucuha: —Ahrirore wahche payojihna. Ahriro Cohamacʉ to warocariro noano jijaro. ");
INSERT INTO gvc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mari ñʉchʉ Davi cjiro pʉhtoro to noano sʉho jiriro seheta, ahriro marine to sʉho jihto cʉ̃hʉ noano jijaro. Mʉano macariro Cohamacʉ, mʉhʉ tuariro waro jira —ni sañurucuha tina. ");
INSERT INTO gvc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ti ã yoari baharo Jesu sehe Jerusalẽpʉ sʉha. Sʉ, Cohamacʉ ya wʉhʉpʉ sãa sʉro, tí wʉhʉi jiare jipihtiare ñʉ pahñonocaha. Ñʉ tuhsʉ “Ñamichahapʉ waro jira marine” nia, Jesu to buheina doce buheina mehne Betaniapʉ wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ã yoa pa dachoi tina Betaniapʉ jiina wahaa wahaha. Ã jiro Jesu sehe jʉca baa, yoaropʉ higuera wama tidʉre noano pũri tidʉre ñʉno tʉ dichare macano wahamaha. ");
INSERT INTO gvc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dicha mariaha. Dicha tiri pja jieraro pũri dihta jiha. ");
INSERT INTO gvc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ã jiro dicha mariachʉ ñʉno õ sehe niha: —Ahdʉ dichare masa ne pari turi chʉea tjijaro. Ne dicha tiero tjijaro —niha Jesu. To ã nichʉ to buheina sehe tʉhoha. ");
INSERT INTO gvc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","To ã yoari baharo tina Jerusalẽpʉ sʉha. Tópʉ sʉro, Jesu Cohamacʉ ya wʉhʉpʉ sãa sʉro pache duainare, nuchʉina cʉ̃hʉre cohã wioha. Ã yoaro niñeru cohtotaa mesarire yo wahcõ na majare cũ mʉjaa tiha. Bujaare duaina ti dujia pahtari cʉ̃hʉre ãta yoaha. ");
INSERT INTO gvc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ã yoaro paye barore na sãa dutieraha masare. ");
INSERT INTO gvc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tó sehe yoa tuhsʉ, Jesu õ sehe ni buheha tinare: —Õ sehe nina Cohamacʉ yare ti joari pũi: “Yʉ wʉhʉ Cohamacʉ mehne durucuri wʉhʉ wama tirohca. Ã jiro jipihtiro macaina ya wʉhʉ cjihto jirohca”, ni joaa tiha Cohamacʉ yare ti joari pũi. To ã nipachʉta mʉsa sehe ahri wʉhʉi duana, mʉsa basi cahma yacara mʉsa —ni buheha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","To ã ni buhechʉ jipihtina masa sehe tʉho cʉaa wahaha. Ã jia sacerdotea pʉhtoa, sã judio masare buheina mehne tirore cui niha. Ã jia tina tirore ti wajãhti cjihtire wacũ macamaha. ");
INSERT INTO gvc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ti ã yoachʉ ñamichahapʉ Jesu to buheina mehne tí macapʉ jirina cjiri wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ã jia bohrearo mahapʉ maja taa, higueracʉre ñʉha. Tʉ nʉhcoripʉ ñai dʉca, ñaia wahaha tʉ. ");
INSERT INTO gvc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tʉre ñʉno Pedro sehe wacũno õ sehe niha: —Buheriro, ñʉga. Higueracʉ mʉ yaria dutidʉ yaria wahari jira —niha Pedro. ");
INSERT INTO gvc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","To ã nichʉta Jesu õ sehe ni yahuha tinare: —Cohamacʉre wacũ tuaga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Potocã niita nija mʉsare. Ahdʉ tʉ̃cʉre pjiri mapʉ mʉsa cohã dutichʉ mʉsa niriro seheta ã waharohca. Cohamacʉre noano mʉsa wacũ tuachʉ “Yʉ siniriro seheta ã waharohca”, mʉsa ni tʉhotuchʉ mʉsa niriro seheta ã waharohca. ");
INSERT INTO gvc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ã jicʉ ahrire yahuihtja mʉsare. Cohamacʉ mehne durucuna, tirore sinina, “Yʉ siniriro seheta warohca yʉhʉre”, ni tʉhotuga. Mʉsa ã ni tʉhotuchʉ ñʉno Cohamacʉ mʉsa siniare warohca. ");
INSERT INTO gvc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ã yoana Cohamacʉ mehne mʉsa durucuhto pano mʉsare paina ti ñano yoachʉ mʉsa suari cjirire duhuga. Mʉsa ã yoachʉ ñʉno Cohamacʉ mʉano macariro mʉsa ñaa buhirire tiro cʉ̃hʉ sua duhurohca. ");
INSERT INTO gvc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mʉsare ñano yoainare mʉsa sua duhuerachʉ mari Pʉcʉ cʉ̃hʉ mʉano macariro mʉsa ñaa buhiri sehere bosi tiro cʉ̃hʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","To ã niri baharo tina Jerusalẽpʉ wahaha tjoa. Ã jia Jesu Cohamacʉ wʉhʉi to tinichʉ ñʉa sacerdotea pʉhtoa, sã judio masare buheina, bʉcʉna mehne tiro cahapʉ sʉa tirore õ sehe ni sinitu ñʉha: ");
INSERT INTO gvc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Dohseacʉ canʉre ã yoari mʉhʉ? ¿Noa mʉhʉre tíre ã yoa dutiri? —ni sinitu ñʉha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Mʉsa sehere sinitu mʉhtaihtja. Noano yʉhʉre mʉsa yʉhtichʉ mʉsare yahuihtja yʉhʉ cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿João masare to bautisachʉ diro baro sehe tirore bautisa dutia tiari, mʉsa tʉhotuchʉ? ¿O Cohamacʉ dutiera tiari? ¿O masa sehe tirore dutia tiari, mʉsa tʉhotuchʉ? —ni sinituha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","To ã nichʉ tina sehe ti basi õ sehe niha: “¿Dohse ni yʉhtinahcari mari? ‘Cohamacʉ Joãore dutia tiri jire’, mari nichʉ, ‘¿Dohseana Cohamacʉ Joãore to dutipachʉta tirore tʉhoerari mʉsa?’ niboca Jesu marine. ");
INSERT INTO gvc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ã yoa, ‘João to bautisachʉ Cohamacʉ sehe tirore dutierari jire’, mari nichʉ masa sehe suaahca mari mehne”, niha tina ti basi. “Potocãta João Cohamacʉ yare yahu mʉhtariro jira”, ni tʉhotua tiha masa sehe. Ti ã ni tʉhotuchʉ masia, Joãore doca dahre duaeraha sacerdotea pʉhtoa cʉ̃hʉ, “Masa suari”, nia. ");
INSERT INTO gvc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ã jia tina Jesure õ sehe ni yʉhtiha: —Joãore bautisa dutirirore sã masieraja —niha tina Jesure. —Tí pja pinihta yʉhʉ cʉ̃hʉ ahrire yʉ yoaare dutirirore yahueraja mʉsare —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ã yoa Jesu to tʉhotua mehne õ sehe ni piti dahre buhe dʉcaha tinare: —Wese pʉro se dari cjihtire toaha. Toa tuhsʉ, sahrĩnore dapo, sere ti tʉ mʉtohti copare saha, mʉari wʉhʉcã dahreha tiro. Tuhsʉ, tí wesere painare cʉ̃ bʉhʉsehe coa pahma cũno, tí wesere ñʉ wihbo dutiha. Ñʉ wihbo duti tuhsʉ, pa yahpapʉ wahaha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Baharo se ñiri pja jichʉ wese pʉro tirore dahra cohtarirore wese macaa to ya coa macaa dichare na dutiro warocamaha. ");
INSERT INTO gvc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ã jia tí wesere ñʉ wihboina sehe tirore dahra cohtarirore ñaha, cjãha. Ã yoa tuhsʉ tirore dahra cohtarirore se tõhorine waerapahta tjuaa dutiha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ã jiro wese pʉro pairo tirore dahra cohtarirore warocamaha tjoa. Ã jia wesere ñʉ wihboina sehe tirore dahra cohtariro dapure cami dahre, ñano yoaha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tuhsʉ, pairo sehere to warocachʉ ñʉ wihboina tirore wajãha. Payʉ paina cʉ̃hʉre ã dihta yoa mʉjaha. Paina sehere cjã, paina sehere wajãha tina. ");
INSERT INTO gvc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ã jiro wese pʉro macʉno dihta dʉhsaha. Tiro to cahĩriro jiha. Ã jiro to macʉnore warocaha jʉna, “Yʉ macʉ sehere ño payoahca”, nino. ");
INSERT INTO gvc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","To ã ni tʉhotupachʉta tina ñʉ wihboina ti basi õ sehe ni durucuha: “Wese pʉro macʉno baharo ahri wesere cjʉahtiro jira ahriro. Tirore wajãjihna mari. Ã jiro ahri wese mari ya wese tjuarohca”, nimaha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ã nia tirore ñaha, wajã, wese dʉhtʉ cahapʉ na wahcã, cohãnocahna tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Ne wese pʉro taro dohse yoarohcari tiro wesere ñʉ wihboinare? Õ sehe yoarohca tinare: Tiro tinare wajãno, paina sehere wesere ñʉ wihbo dutirohca. ");
INSERT INTO gvc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","¿Cohamacʉ yare ti joari pũre ahrire buherari mʉsa? Õ sehe ni joaa tiha: “Ahriro Cristo tãca yoaro seheta jira. Tãcare wʉhʉ dahreina ti cohãno seheta masa tirore cohãahca. Ti ã yoapachʉta mipʉre wʉhʉ dahreina wʉhʉre yoaa ti cũ mʉhtari tãcare ti cũno seheta Cohamacʉ tirore pʉhto sõre. Cohamacʉ sehe ahrire yoare. To ã yoachʉ ñʉna, ‘Noa yʉhdʉara’, ni tʉhotuja mari”, ni joaa tiha panopʉ. ¿Tíre ne buherari mʉsa? —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","To ã nichʉ tʉhoa sacerdotea pʉhtoa, sã coyea judio masare buheina, bʉcʉna mehne õ sehe ni tʉhotuha: “Jesu wesere ñʉ wihboina quiti mehne marine tuhtiro nina”, ni tʉhotuha. Ã ni tʉhotua Jesure ñaha duamaha. Ã ñaha duapahta masare cui niha. Ã cuia tirore cohã wahcãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Waha, tina fariseo curua macainare, Herode ya curua macaina cʉ̃hʉre Jesure sinitu dutia warocaha tjoa. Jesu ñano to yʉhtichʉ yoa duamaha tina, tirore yahusãa taa. ");
INSERT INTO gvc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ã jia Jesu cahapʉ sʉa, tirore mahño cũ sinitu ñʉmaha: —Buheriro, potocã durucuriro, mahñoa marieriro mʉ jichʉ masija sã. Cohamacʉ yare quihõno mʉ yahuchʉ cʉ̃hʉre masija sã. Ã yoa cʉ̃iro pʉhtoro waro to jipachʉta tiro cʉ̃hʉre dórero marieno potota yahura mʉhʉ. Ã jicʉ sãre yahuga. ¿Roma macariro jipihtina bui pʉhtoro jirirore gobierno macaare marine waparo cahmajari, mʉ tʉhotuchʉ? ¿Mari dutia tirore wapa dutijari, mʉ tʉhotuchʉ? —ni sinitumaha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ti ã sinituchʉ tʉhoro ti yahusã duaare masino õ sehe ni sinituha tinare: —¿Dohseana yʉ ñano durucuchʉ tʉho duajari mʉsa? Mipʉre niñeru tʉre na tahga. Tí tʉre ñʉjihna —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","To ã nichʉ tʉhoa tina sehe cʉ̃ tʉre na taha. Ti na wihichʉ Jesu õ sehe ni sinituha tinare: —¿Diro baro masʉ wahãjari ahri tʉre? ¿Diro baro wama wahãjari? —ni sinituha tiro. —César, masa bui pʉhtoro masʉ, to wama cʉ̃hʉ wahãna —ni yʉhtiha tina. ");
INSERT INTO gvc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ti ã nichʉ Jesu õ sehe ni yahuha tinare: —Tí pja pinihta masa bui pʉhtoro yare tiro sehere waga. Cohamacʉ yare Cohamacʉ sehere waga —ni yahuha Jesu. To ã nichʉ tʉhoa, tʉho cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ã yoa cãina Saduceo curua macaina Jesu cahapʉ wihiha. Saduceo curua macaina sehe “Cohamacʉ yariainare masosi”, ni tʉhotuina jimaha. ");
INSERT INTO gvc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ã jia tina õ sehe niha tirore: —Buheriro, õ sehe ni buhea tiha Moise cjiro: “Cʉ̃iro to wahmino namo tiriro pohna mariaparota to yariachʉ ñʉno to bahʉrore to wahmino namono cjirore nʉoano cahmana. Ã yoaro to wahmino mʉnano to pohna tiboro seheta pohna tiro cahmana to bahʉrore. Ã jia to pohna to wahmino mʉnano pohna yoaro sehe jiahca”, ni joaa tiha Moise cjiro —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tíre ni tuhsʉ, ahri quitireta yahu namoha Jesure: —Cʉ̃iro masʉno jiha. Seis to bahana jiha. Ti wahmino sehe namo ti, pohna mariaparota yariaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tuhsʉ, pairo to bahʉro cʉ̃hʉ to wahmino namono cjirore cjʉamaha. To ã nʉoari baharo to wahmino yoaro seheta pohna mariaparota yariaa wahaha tjoa. Ã jiro ahriro bahʉro to wahmino mʉnano yoaro seheta pohna mariaparota yariaa wahaha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ã dihta wahaha cʉ̃iro pohna waro. Ne pohna mariapahta yaria pihtia wahaha tina. Ti namono cjiro cʉ̃hʉ ti baharota yariaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Ne, Cohamacʉ jipihtinare yariaina cjirire to masochʉ diro namono sehe jirohcari ticoro? Tina jipihtina ticorore namo tirina cjiri jiha. ¿Ã jiro diro namono sehe jibocari ticoro pototi? —ni sinituha tina. ");
INSERT INTO gvc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu õ sehe ni yʉhtiha tinare: —Cohamacʉ yare ti joari pũre, to masia cʉ̃hʉre ne masierara mʉsa. Ã jia mʉsa tʉhotua sehe ne quihõno jierara. ");
INSERT INTO gvc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yariarina cjiri ti masa mʉjari baharo tina anjoa yoaro sehe jira. Tina mʉa namo tierara tópʉre. ");
INSERT INTO gvc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yariarina cjiri ti masa wijaahto sehere mʉsare yahuihtja: Tíre Moise cjiro noano yahu pahñoha. To mahadʉcã jʉ̃ri quitire õ sehe ni yahuha tiro: “ ‘Yʉhʉ Abrahã, Isaa, Jacobo ti pʉhtoro tjija’, ni yahure Cohamacʉ yʉhʉre”, ni joaa tiha Moise cjiro to joari tjui. ");
INSERT INTO gvc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ti yariari baharo “Ti pʉhtoro tjija”, ni yahuha Cohamacʉ. Ã niparota yariarina cjiri pʉhtoro jierara Cohamacʉ. “Ti pʉhtoro tjija”, to nia mehne catiina ti jichʉ masija mari. Tiro catiina pʉhtoro jira. Ã jina “Yariaina masasi”, ni tʉhotuna quihõno tʉhotuerara mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ã yoa cʉ̃iro sã coyea judio masare buheina mehne macariro tina cahapʉ wihi, ti cahma durucuchʉ tʉhoha. Jesu to noano yʉhtiare tʉhoro õ sehe ni sinituha tirore: —¿Cohamacʉ ya dutia noa yʉhdʉaro di baro sehe jijari, mʉ tʉhotuchʉ? —ni sinituha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu tirore õ sehe ni yahuha: —Ahri dutiata paye dutia yʉhdoro noa yʉhdʉara: “Israe masa tʉhoga. Cohamacʉ mʉsa pʉhtoro yʉhʉ cʉ̃irota jija. ");
INSERT INTO gvc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tuaro mʉsa yajeripohnari mehne, noano mʉsa wacũa mehne, mʉsa tuaa mehne yʉhʉre cahĩga”, nina Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ahri dutia baharo paye dutia noa yʉhdʉara: “Mʉ basi mʉ cahĩno seheta mʉ cahai jiina cʉ̃hʉre cahĩga”, nina Cohamacʉ. Ahri pʉaro dutia jipihtia paye dutia yʉhdoro jira —ni yahuha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","To ã nichʉ tʉhoro judio masare buheriro õ sehe niha: —Ã tjira. Buheriro, potocã nina mʉhʉ. Cohamacʉ cʉ̃irota jira. Pairo tiro yoaro sehe jiriro mariahna. Mʉ nia potocã tjira. ");
INSERT INTO gvc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cohamacʉre tuaro mari yajeripohnari mehne, mari wacũa mehne, mari tuaa mehne tirore cahĩno cahmana marine. Yʉ cahai jiinare yʉ basi yʉ cahĩno seheta tina cʉ̃hʉre cahĩno cahmana yʉhʉre. Wahiquinare wajã jʉ̃ mʉo mari wari mehne mari ño payochʉ noa nimana. Ahri yʉhdoro Cohamacʉre masa cʉ̃hʉre mari cahĩa noa yʉhdʉara. Mʉ ã nia potocã tjira —niha judio masare buheriro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","To ã noano yʉhtichʉ tʉhoro Jesu õ sehe ni yahuha tirore: —Mahanocã dʉhsara mʉhʉre Cohamacʉre mʉ noano masihto —niha tirore. To ã nichʉ tʉhoa paina cuia, ne sinitu ñʉeraha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ã yoa Cohamacʉ wʉhʉi buhero õ sehe niha Jesu: —“Cristo Davi cjiro panamino jira”, ni buhera mari coyea judio masare buheina. ¿Dohse yoa ã ni buhejari tina? ");
INSERT INTO gvc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davi cjiro to basi Espíritu Santo to dutiriro seheta õ sehe ni yahua tiha: “Cohamacʉ yʉ pʉhtorore õ sehe nire: ‘Õi yʉ poto bʉhʉsehei dujiga. Ã jicʉ mʉhʉre ñʉ tuhtiinare mʉhʉre yʉhdʉrʉcabasaihca yʉhʉ’, nire Cohamacʉ yʉ pʉhtorore”, ni joaa tiha Davi cjiro. ");
INSERT INTO gvc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ã ni joaro Davi cjiro pʉhtoro tia tiha Cristore. ¿Davi cjiro Cristo ñʉchʉno cjiro jiparota dohsearo Davi sehe pʉhtoro tiari Cristore? Cristo Davi cjiro pʉhtoro jira —ni yahuha Jesu. To ã ni buhechʉ payʉ masa wahchea mehne tʉhoha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ã yoa tiro buhe namono õ sehe niha: —Mari coyea judio masare buheina ti ñaa yoaare noano ñʉga. Ã jina ti yoaro sehe yoaena tjiga. Tina yoaa suhti sãa, masa ti ñʉrocaroi majarea, pache duaropʉ paina pʉhtoare noano ño payo ti sinino sehe ti piti bocasinichʉ cahmana tina. ");
INSERT INTO gvc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ã cahmaina jia, mari judio masa buhea wʉhʉsei noaa dujia dihtare duji duara. Tuhsʉ, bose nʉmʉ jichʉ tó cʉ̃hʉre noaa dujia dihtare cahmana tina. ");
INSERT INTO gvc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tina wapewahya numia ya wʉhʉsere ti ya cʉ̃hʉre mana tí numiare. Ã yoaina jia, tina masa ti ñʉrocaroi yoari pja Cohamacʉ mehne durucumana masare ñʉ dutia. Ti ã yoari buhiri paina bui curero tinare Cohamacʉ pjíro buhiri dahrerohca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ã yoa Jesu niñeru wihbori caro cahapʉ dujiha. Tí caropʉ masa ti niñeru duhu sãachʉ ñʉ dujiro niha. (Tí niñeru Cohamacʉ wʉhʉre ti cahnochʉ ti wapahti jiha.) Ã jia pache pʉa tí caropʉ pjíro duhu sãaha. ");
INSERT INTO gvc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ã yoa wapewahyoro pjacʉoricoro tí caropʉ ta, pʉa tʉcãre duhu sãaha. Pʉa tʉ cʉ̃ centavo posa jira. ");
INSERT INTO gvc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tí tʉrire to duhu sãachʉ ñʉno to buheinare pjirocaha: —Potocã niita nija mʉsare. Ahricoro wapewahyoro pjacʉoricoro sehe niñeru wihbori caropʉ duhu sãano paina jipihtina ti wari yʉhdoro wahre ticoro sehe. ");
INSERT INTO gvc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Paina pache pʉa pjíro ti wapachʉta ti ya pjíro dʉhsara. Ahricoro sehe pjacʉoricoro jiparota jipihtia to chʉhtire to nuchʉboacãre wa pahñohre —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ã yoa Cohamacʉ wʉhʉpʉre ti wijaachʉ cʉ̃iro buheina mehne macariro õ sehe niha: —Buheriro, ñʉga. Ahri wʉhʉse noaa tãa mehne ti yoaa wʉhʉse noacaa wʉhʉse jijari —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","To ã nichʉ Jesu õ sehe ni yahuha tinare: —Ahri jipihtia mari ñʉri wʉhʉse cjiri, ahri tãa cʉ̃hʉ cohõ pihtia wahaahca. Ne cʉ̃ria tãca tjuasi —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ã yoa Jesu Olivo wama tidʉ tʉ̃cʉpʉ Cohamacʉ wʉhʉ potoi jidʉpʉ sʉha. Tʉ bui dujiha. Tói Pedro, Santiago, João, Andre mehne ti sahsero jia, tina tirore õ sehe ni sinituha: ");
INSERT INTO gvc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Yahuga sãre. ¿Dohse jichʉ ã waharohcari mʉ niriro sehe waharo? ¿Pihtiri dacho panocã to jichʉ dohse to waha dʉcachʉ ñʉnahcari sã? —ni sinituha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu õ sehe ni yʉhtiha: —Noano yoaga mʉsa. Tuhsʉ, paina ti mahñoare tʉhoena tjiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Payʉ masa “Cristo jija yʉhʉ”, ni mahñoina taahca. Ti ã mahñochʉ tʉhoa payʉ masa Cohamacʉ yare duhuahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Mʉsa cahacãi masa paina ti cahma wajãchʉ tʉhonahca mʉsa. Tuhsʉ, yoaropʉ cʉ̃hʉre ti cahma wajãchʉ tʉhorocanahca mʉsa. Ã tʉhorocapanahta ne tíre pjíro tʉhotuena tjiga. Ã waharohca. Ti ã yoachʉ pihtiri dacho cjihto dʉhsasininohca mini. ");
INSERT INTO gvc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tí pjare cʉ̃ yahpa macaina pa yahpa macaina mehne cahma wajãahca. Ã yoa cʉ̃iro pʉhtoro yaina pairo pʉhtoro yaina mehne cahma wajãahca. Tuhsʉ, pjaró yahpa ñuhminohca. Ã yoa payʉ masa jʉca mehne yariaahca. To ã wahachʉ ahri yahpa macainare ti ñano yʉhdʉ namohto dʉhsasinina mini. Ñano yʉhdʉsiniahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’To ã wahachʉ ñʉna mʉsa basi noano yoaga. Paina mʉsare ñaha, ñano yoa dutia waahca paina pʉhtoapʉre. Ã yoa judio masa mari buhea wʉhʉsei mʉsare cjãahca. Ti ã yoachʉ bʉjʉa macari macaina pʉhtoa, ti bui pʉhtoa cʉ̃hʉ mʉsare buhiri dahrea taa sinituahca mʉsare. Yʉ yaina mʉsa jiri buhirire paina mʉsare yahusãhca. Ã jina yare yahunahca mʉsa tinare. ");
INSERT INTO gvc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ã jia pihtiri dacho pano noaa buheare jipihtiro yahpari macainare yahua buhea jiahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ã jina mʉsare buhiri dahre dutia, buhiri dahre dutiriro cahapʉ ti naachʉ tirore mʉsa nihtire “Yahu masieraboca”, ni tʉhotuena tjiga mʉsa. Tí pjare mʉsa nihtire mʉsare Espíritu Santo yahurohca. To ã yahurire yahuga mʉsa. Mʉsa mʉ sʉro durucusi mʉsa. Espíritu Santo sehe mʉsare durucubasarohca. ");
INSERT INTO gvc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tí pjare cʉ̃iro to bahʉrore wajã dutiro warohca. Pairo sehe to wahminore wajã dutiro warohca. Ti pʉcʉro to pohnare wajã dutiro warohca. Ã yoa ti pohna sehe ti pʉcʉsʉmare wajã dutia waahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yʉ yaina mʉsa jiri buhiri mʉsare masa jipihtina ñʉ tuhtiahca. Ã ñano yʉhdʉpanahta yʉ yare mʉsa ne cohãerachʉ pihtiri dacho jichʉ mʉsare yʉhdoihca. ");
INSERT INTO gvc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ã yoa ñabiarirore Cohamacʉ yare ñano yoarirore ñʉnahca mʉsa. Cohamacʉ ya wʉhʉi to ducuchʉ ñʉnahca. Tói tirore jieraro cahmana. Panopʉ Cohamacʉ yare yahu mʉhtariro Daniel cjiro tirore yahuro joaa tiha. Tói to ducuchʉ ñʉa Judea yahpapʉ jiina tʉ̃yucʉpʉ duhti mʉroca mʉjaa wahajaro. Ahri yʉ nirire noano masiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Soaro mehne mʉroca duhtijaro. Tí pjare ti wʉhʉseri bui macaa waparipʉ jiina wʉhʉ puhichapʉ jiare ti yare na wahaea tjijaro ti waha bahrañohto sehe. ");
INSERT INTO gvc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ã jia tí pjare paina ti weseripʉ jiina ti bui macaa suhtire wʉhʉpʉ jia suhtire na wahaea tjijaro ti waha bahrañohto sehe. ");
INSERT INTO gvc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tí pjare niji pocosanumia, ti pohnare pũa numia cʉ̃hʉ pjacʉoro wahaahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ã jina õ sehe ni siniga Cohamacʉre: “Puhiro jichʉ ã wahaero tjijaro”, ni siniga tirore. ");
INSERT INTO gvc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tí dachorire masa nu ñano wahaahca. Ahri yahpare to bajuamehneri baharo masa ñano ti yʉhdʉa jia tiha. Ti ã jipachʉta jipihtia tí purĩa yʉhdoro pihtiri dacho jichʉ masa ñabiaro yʉhdʉahca. Ã ñano ti yʉhdʉri baharo pari turi tó sehe ñabiaro yʉhdʉsi ahri yahpai jʉna. ");
INSERT INTO gvc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ã jiro Cohamacʉ tí dachorire mahaa dachoricã ti jichʉ yoarohca. To ã yoaerachʉ ne cʉ̃iro masʉno yʉhdʉeraboa. Ã jiro to beserina ti yʉhdʉhti cjihtire mahaa dachoricã ã cũsininohca Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Tí pjare paina mʉsare “Ñʉga. Õi jira Cristo”, ti nichʉ tinare tʉhoena tjiga. “Tói jira Cristo”, ti nichʉ cʉ̃hʉre tʉhoena tjiga. ");
INSERT INTO gvc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Cristo jija”, ni mahñoina, “Cohamacʉ yare yahu mʉhtaina jija”, ni mahñoina jiahca tí pjareta. Ã jia Cohamacʉ to beserinare mahñoa, tina bajuamehneare yoa ñoahca. Ti ã yoa ñochʉ ñʉa, Cohamacʉ yaina cãina tinare tʉhoa “Potocã tjira” nia, Cohamacʉ yare pa tehe nia duhuboca. ");
INSERT INTO gvc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ahrire yahuyuja mʉsare to ã wahahto pano. Ã jina noano yoaga mʉsa —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ã ni tuhsʉ õ sehe ni yahu namoha Jesu: —Tí dachori ti ñano yʉhdʉri baharo sʉ̃ dacho macariro, ñami macariro cʉ̃hʉ buhria duhua wahaahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ti ã wahachʉta ñahpichoha poca mʉanopʉ jia poca boraa wahaahca. Ã jia mʉano macaa yahpari tuaro ñuhmiahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tí pjata yʉhʉ masʉno Cohamacʉ warocariro taihtja. Yʉ ã tachʉ mʉanopʉ yʉ tuaa mehne yʉ si sitea mehne mʉano macaa me bui ahri yahpapʉre yʉ tjua tachʉ ñʉahca masa. ");
INSERT INTO gvc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ã jicʉ yʉ yaina anjoare jipihtiropʉ ahri yahpapʉ warocaihtja. Ã jia jipihtiropʉ yʉ yaina yʉ beserinare tina naahca. ");
INSERT INTO gvc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Mipʉre higueracʉre tʉhotuga mʉsa. Tʉ quiti mehne mʉsare piti dahre buheihtja. Tʉ yucʉcʉ pũri tichʉ ñʉna, cʉhma mahanocã dʉhsachʉ masina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tó seheta ahri jipihtia yʉ niri cjirire ti ã wahachʉ ñʉna, yʉ tjua tahto mahanocã dʉhsachʉ masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Potocã niita nija mʉsare. Tí pja macaina ti yariahto panore jipihtia yʉ niriro seheta ã waharohca. ");
INSERT INTO gvc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mʉano, ahri yahpa cʉ̃hʉ pihtia wahaahca. Yʉ durucua sehe ne cohtotasi. Jipihtia yʉ niriro seheta ã waha sohtori tiarohca. ");
INSERT INTO gvc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Tí dachore yʉ tjua tahti dachore, tí hora cʉ̃hʉre masieraja yʉhʉ. Anjoa cʉ̃hʉ tíre masierara. Masa cʉ̃hʉ ne masierara. Yʉ Pʉcʉ dihta tíre masina. ");
INSERT INTO gvc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Mʉsa cʉ̃hʉ tí dachore masierara. Ã jina noano yoaga. Noano cohtaga. (Cohamacʉre siniga mʉsa.) ");
INSERT INTO gvc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Õ sehe cohtaga mʉsa. Ahri quiti mehne mʉsare piti dahre buheihtja. Wʉhʉ pʉro yoaropʉ to tinino seheta jira ahri. Tiro to wahahto pano to cahamacare wʉhʉre cohta dutiha. Cãinare ti dahrahtire cũha. Ã jiro wʉhʉre ñʉ wihborirore tirore to tjua tahtore cohta dutiha. ");
INSERT INTO gvc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ã jina mʉsa cʉ̃hʉ noano wacũ masi cohtaga. Wʉhʉ pʉro to tjua tahtore tina ti masieraro seheta yʉhʉ mʉsa pʉhtoro yʉ tjua tahti dachore masierara mʉsa cʉ̃hʉ. Ñamichahapʉ, ñami dacho macapʉ, caraca to duri pja jichʉ, bohrearopʉ taboca. ");
INSERT INTO gvc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yʉ ã wacũenoca yʉ wihihtore masina, yʉ yare ã yoarucuina jiga mʉsa. Ã yoa yʉhʉre noano cohtaga. ");
INSERT INTO gvc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ã jicʉ mʉsare yʉ nino seheta jipihtinare ã nija mʉsare: Noano wacũ masi cohtaga —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ã yoa tí pjare pascua wama tiri bose nʉmʉ cjihto bʉcʉaerari pãore ti chʉhti nʉmʉri cjihto pʉa dacho dʉhsasiniha. Tí pjare sacerdotea pʉhtoa, ã jichʉ sã coyea judio masare buheina mehne dohse yoa ti mahñoa mehne Jesure ñaha ti wajãhtore cahma sʉhʉdua niha: ");
INSERT INTO gvc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Mari bose nʉmʉri yʉhdoro puro tirore ñahasiniena tjijihna, “Masa sua sañurucuri”, nina —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ã yoa Jesu cʉ̃hʉ Betaniapʉ, Simo cami bʉcʉ baariro cjiro ya wʉhʉpʉ jiha. Tópʉ ti chʉro watoi numino sehe alabastro mehne ti yoariare me sitia nardo wama tia sere posa tiriare na wihiha. Tí se sehe wapa bʉjʉ niha. Ã na wihiro, ticoro tiare poharoca, Jesu dapu bui pio payoha. ");
INSERT INTO gvc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","To ã yoachʉ ñʉa paina suaa waha, ti basi õ sehe niha: —¿Dohse yoaro ahricoro ahri me sitia co wapa bʉjʉare ã yoa sitejari? ");
INSERT INTO gvc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tíre ticoro duaboa. Tíre duaro tres cientos niñeru pũrine wapataboa. Ã wapataro, tí niñerure pjacʉoinare waboa ticoro —ni cohtaha paina sehe ticoro to ã yoachʉ ñʉa. Ã jia tina ticorore tuhtiha. ");
INSERT INTO gvc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ti ã nichʉ tʉhoro Jesu tinare õ sehe ni yahuha: —Ã niena tjiga ticorore. Yʉhʉre ticoro noano yoaro nina. ");
INSERT INTO gvc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pjacʉoina sehe mʉsa mehne ã jirucuahca. Ã jina mʉsa cahmari pja tinare wa masina. Yʉhʉ sehe ahri yahpare mʉsa mehne ã jirucusi. ");
INSERT INTO gvc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","To cjʉaro puro mehne ticoro yʉhʉre ã yoahre. Yʉhʉre ti yahto pano yʉ pjacʉre cahnoyuro, me sitiare pio payohre ticoro. ");
INSERT INTO gvc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ã jicʉ potocã niita nija mʉsare. Jipihtiro ahri yahpapʉ noaa buheare ti yahuropʉ ahricoro mipʉre to yoarire yahuahca. Ti ã yahuchʉ tʉhoa ticorore masa payʉ wacũahca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tí pjareta Juda Iscariote wama tiriro doce to buheina mehne macariro Jesure to ñohtire yahuro wahaha tirore ñʉ tuhtiinare, sacerdotea pʉhtoare. ");
INSERT INTO gvc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","To ã ni yahuchʉ tʉhoa, sacerdotea pʉhtoa tíre tʉhoa wahcheha. —Mʉhʉre niñerure wanahtja —niha tina Judare. Ti ã nichʉ tʉhoro, tiro Jesure ñʉ tuhtiinare to dohse yoa ñohto cjihtore wacũ macaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bʉcʉaerari pãore ti chʉa nʉmʉri dʉcari nʉmʉ sehe oveja pascua macaina cjihtire ti wajãhti nʉmʉ jiha. Tí nʉmʉi to buheina sehe õ sehe ni sinitu ñʉha Jesure: —¿Mari pascua macaa chʉhtire noho baroi cahnoyu dutirocaijari mʉhʉ sãre? —niha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ti ã nichʉta Jesu sehe pʉaro to buheinare õ sehe ni yahu warocaha: —Jerusalẽpʉ wahaga. Tópʉ mʉsa sʉchʉ co situ wʉariro mʉsare piti bocarohca. To piti bocachʉ tiro mehne wahaga. ");
INSERT INTO gvc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ã wahana tiro to sʉho sãari wʉhʉpʉ sʉna, tí wʉhʉ pʉrore õ sehe niga: “ ‘¿Dí tahtiai yʉhʉ yʉ buheina mehne pascua macaa chʉare chʉnahcari?’ ni sinitu dutirocahre buheriro”, niga tí wʉhʉ pʉrore. ");
INSERT INTO gvc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mʉsa ã nichʉ tʉhoro, tópʉ mʉano macari tahtiare pjiri tahtiare, noano ti cahnoyuri tahtiapʉre mʉsare ñonohca wʉhʉ pʉro. Tói mari chʉhti cjihtire dahrega mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","To ã nichʉ tʉhoa tina to buheina tí macapʉ wahaha. Tópʉ ti sʉchʉ tinare to niriro seheta ã wahaha. Ã jia tina pascua macaa chʉare dahreha. ");
INSERT INTO gvc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ã yoa nahitia bora tachʉ Jesu doce to buheina mehne tí wʉhʉpʉre sʉha. ");
INSERT INTO gvc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tí wʉhʉpʉ ti sʉri baharo, tina mehne mesapʉ chʉro Jesu tinare õ sehe ni yahuha: —Potocã niita nija mʉsare. Cʉ̃iro mʉsa mehne macariro yʉhʉ mehne chʉrirota yʉhʉre ñʉ tuhtiinare ñonohca yʉhʉre —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","To ã nichʉ tʉhoa tina sehe cahyaha. —¿Yʉhʉta jijari mʉhʉre ñohtiro? —ni sinitu pihtiaha tina cãina jipihtina Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Mʉsa mehne macarirota jira tiro. Yʉ chʉri wapai yʉhʉ mehne soha chʉriro tjira yʉhʉre ñʉ tuhtiinare ñohtiro. ");
INSERT INTO gvc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Panopʉ yʉhʉre ti yahu joariro seheta yʉhʉ masʉno Cohamacʉ warocariro yariaihca. Yʉhʉre ñʉ tuhtiinare ñoriro pjacʉoro yʉhdʉrohca. Tiro to masa bajuerachʉ noaboa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ã ni yahu tuhsʉ, to buheinare sʉho chʉro, Jesu pãore na, Cohamacʉre “Noana”, niha. Ã ninota, tí curire nuha, witiha tinare. —Ahrire na chʉga. Ahri yʉ pjacʉ jira —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ã ni tuhsʉ tiro sihnia posa tiri wahware na, Cohamacʉre “Noana” ni tuhsʉ, waha tinare. To wachʉ tina jipihtina tíre sihni pihtiaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Ahri yʉ di jira. Payʉ masa ti ñaa yoari buhirire cohãcʉ tacʉ yariaihca. Ã yariacʉ yʉ dire cohãihca. Cohamacʉ “Mʉsare yʉhdoihtja”, to ni cũriro mʉ sʉchʉ yʉ ã yariaro mehne to niriro sohtori tirohca. ");
INSERT INTO gvc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Potocã niita nija mʉsare. Mipʉre ahri co, se core ne sihni namosi yʉhʉ. Pʉ pʉhtoro Cohamacʉ mʉsare to sʉho jichʉpʉ ahrire coã pari turi sihniihca tjoa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","To ã ni tuhsʉchʉ tina Cohamacʉre ño payoa cʉ̃no basaare basaha. Ti basa pahñori baharo, tʉ̃cʉ Olivo wama tidʉpʉ tina wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tópʉ sʉho sʉro Jesu tinare õ sehe ni yahuha: —Mipʉre mʉsa jipihtina yʉhʉre cohãnahca. Õ seheta nina Cohamacʉ yare ti joari pũi yʉhʉre yahuro: “Ovejare ñʉ wihboriro yoaro sehe jirirore Cohamacʉ cohãnohca. Ã to cohãchʉ to yaina oveja yoaro sehe jiina duhti site wahcãa wahaahca”, nina Cohamacʉ yare ti joari pũi. ");
INSERT INTO gvc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ã yoa Cohamacʉ yʉhʉre to masori baharo mʉsa pano Galileapʉ wahayuihca yʉhʉ —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","To ã nichʉ Pedro sehe õ sehe niha: —Yʉhʉ mehne macaina jipihtina ti cohã wahcãpachʉta yʉhʉ sehe mʉhʉre ne cohãsi —nimaha Pedro tirore. ");
INSERT INTO gvc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu õ sehe ni yʉhtiha: —Potocã niita nija mʉhʉre. Micha ñami pinihtare caraca pʉa taha to duhto pano “Yʉhʉ Jesure masieraja”, niihca mʉhʉ. Tia taha ã niihca mʉhʉ —niha Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","To ã nipachʉta Pedro õ sehe ni tuaro bisiro yʉhtiha: —Mʉhʉ mehne yʉhʉre ti wajã duapachʉta “Jesure masieraja”, ne nisi yʉhʉ —ni yʉhtimaha tiro Jesure. Pedro to ã nichʉ tʉhoa tiro mehne macaina cʉ̃hʉ ã dihta ni yʉhtiha. ");
INSERT INTO gvc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ã yoa tina Getsemaní wama tiropʉ wahaha. Tópʉ sʉro, õ sehe niha Jesu: —Cohamacʉre yʉ sinino watoi õi dujiyusiniga mʉsa —niha to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ã ni tuhsʉ Pedrore, Santiagore, Joãore tina tiarore pji wahcãha. Tinare ã pji wahcãno, pjíro tʉhotu dʉcaha tiro. Ã yoa ñano yajeripohna tiha. ");
INSERT INTO gvc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ã cahyaro tó mehne macainare to pji wahcãinare õ sehe niha: —Yʉhʉ ñano yajeripohna tii nija. Ñano purĩnore tʉhotui nija. Tí mehne yariahto cua yʉhdʉaro coa taca yʉhʉre. Õi tjuaga. Yʉ cʉ̃no potorita catiga mʉsa cʉ̃hʉ —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ã ni tuhsʉ tiro tópʉ mahanocã waha namo, yahpai caha sʉro, Cohamacʉre õ sehe niha: —Mai, mʉhʉ jipihtiare yoa masina. Ã jicʉ yʉ ñano yʉhdʉhtire yoa duaeracʉ yoai tjia. Yʉ ã nipachʉta yʉ cahmano sehe yoai tjia. Mʉhʉ sehe masina. Mʉ cahmano seheta yoaga yʉhʉre —ni siniha tiro Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ã ni tuhsʉ, tiaro to buheina cahapʉ wihiro, carĩinare boca wihiha tiro. Tinare ñʉno Pedrore õ sehe niha: —Simo, ¿carĩi nijari mʉhʉ? ¿Cʉ̃ hora waro yʉ cʉ̃no potori cati masierari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Noano yoaga mʉsa. Mʉsa mʉ sʉro quihõno yoa duamana mʉsa. Wiho mejeta mʉsa basi tíre bihoerara. Ã jina Cohamacʉre siniga ñano mʉsa yoaerahto sehe —niha Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ã ni yahu tuhsʉ pari turi waha, Cohamacʉre siniha. Tó pano to siniriro seheta siniha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ã sini tuhsʉro pari turi tina cahapʉ wihiha tjoa. Ã wihiro carĩinare boca wihiha tjoa. Wʉjo caha yʉhdʉaha tina. Ã jia tina Jesure dohse ni masieraha. ");
INSERT INTO gvc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ã yoa pari turi Cohamacʉ mehne to durucuro sʉri baharo tina cahapʉ wihi, tinare õ sehe niha: —¿Carĩ, sosinina nijari mʉsa? Tó puro carĩga mʉsa. Michapucacã yʉhʉre Cohamacʉ warocarirore ñano yoainare ti wahti pja mʉ sʉ tuhsʉra. ");
INSERT INTO gvc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wahcãga. Basa wahana. Ñʉga. Yʉhʉre ñʉ tuhtiinare ñohtiro õi tara —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","To ã nino watoihta Juda, doce buheina mehne macariro cjiro wihiha. Tiro mehne masa payʉ ñosaa pjĩni, yucʉ siri cjʉaina cʉ̃hʉ wihiha. Sacerdotea pʉhtoa, sã judio masare buheina, ã jichʉ bʉcʉna, ti warocarina jiha masa sehe. ");
INSERT INTO gvc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wahmanore Jesure ñʉ tuhtiinare ñohtiro sehe tiro mehne tahtinare õ sehe ni yahu quihõ tuhsʉha: —Yʉ wahsupu wihmiriro tirota jirohca mʉsa ñahahtiro. Tirore yʉ wihmiri baharo ñahaga tirore. Ã yoana tirore noano ñahaga to duhtierahto sehe —ni yahu quihõ tuhsʉha Juda sehe. ");
INSERT INTO gvc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ã yahu quihõ tuhsʉro wihirota Jesu cahapʉ dóihta waha bahrañoha. —Yʉ pʉhtoro —ninota wahsupu wihmiha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","To ã yoachʉ ñʉa tina Jesure ñahaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ti ã yoachʉ ñʉno cʉ̃iro Jesu cahapʉ ducuina mehne macariro to ñosari pjĩne tʉãwe naroca, sacerdotea bui pʉhtoro cahamacʉnore to cahmonore dʉte pahrẽnocaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","To ã yoachʉ Jesu õ sehe niha: —¿Dohse jiro baro mʉsa ñosaa pjini mehne, yucʉ tiri mehne tajari? ¿Yaca bʉcʉrore mʉsa ñahano seheta yʉhʉ cʉ̃hʉre ñahana tana nijari? ");
INSERT INTO gvc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dachoripe Cohamacʉ wʉhʉpʉ mʉsare yʉ buhe dujichʉ, mʉsa yʉhʉre ne ñahaerare. Mʉsa ã ñahachʉ ahri jipihtia ã waharo nina Cohamacʉ yare ti ni joariro seheta —niha Jesu masare. ");
INSERT INTO gvc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","To ã ni tuhsʉchʉ, Jesu buheina tirore cohã wahcã, jipihtina mʉroca site wahcãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ã yoa cʉ̃iro wahmʉno suhti marieriro cʉ̃no coma yosaro dihta comariro Jesu baharo ñʉ nʉnʉ timaha. To ã ñʉ nʉnʉ tichʉ ñʉa tirore ñahamaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tirore ti ñahachʉ ñʉno to coma yosarore cohãnoca, suhti marieriro mʉrocaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ã yoa sacerdotea bui pʉhtoro cahapʉ Jesure na wahcãha. Ti na sʉri baharo sacerdotea pʉhtoa, bʉcʉna, sã coyea judio masare buheina cʉ̃hʉ jipihtina cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tiro Pedro sehe Jesu baharo yoaropʉ nʉnʉ tiha. Ã nʉnʉ tiro sacerdotea bui pʉhtoa ya wʉhʉ cahapʉ sʉha. Ã sʉro tiro tí wʉhʉre cohtaina surara mehne pichaca dʉhtʉ cahai sohma dujiha. ");
INSERT INTO gvc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sacerdotea pʉhtoa, jipihtina paina pʉhtoa cʉ̃hʉ Jesure wajã dutia taa, Jesu to quihõno yoaerarire ti yahusãhtire wacũ macamaha. Wiho mejeta tíre bocaeraha. ");
INSERT INTO gvc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ã wacũ bocaerapahta payʉ masa tirore ã yahusãmacanocaha. Ti ã yahusãa potocã jieraha. Pairo soro ni, pairo soro niha. ");
INSERT INTO gvc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ã yoa paina wahcãrʉcʉ sʉ, Jesure õ sehe ni yahusãha tjoa: ");
INSERT INTO gvc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ahriro õ sehe nire: “Yʉhʉ ahri wʉhʉre Cohamacʉ wʉhʉre masa ti dahreri wʉhʉre cohãihtja. Ã cohãcʉ tia nʉmʉ wahaboroi tí wʉhʉre pari turi yoaihtja. Tí wʉhʉ masa ti dahreri wʉhʉ jisi”, to nichʉ sã tʉhohi —niha tirore yahusãina. ");
INSERT INTO gvc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ti ã ni yahusãpachʉta ti yahusãa cʉ̃hʉ potocã jieraha. Pairo soro ni, pairo soro niha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ti ã nichʉ tʉhoro sacerdotea pʉhtoro ti watoi ducuriro wahcãrʉcʉ sʉ, Jesure õ sehe ni sinituha: —¿Ahrina mʉhʉre ti yahusãpachʉta tinare yʉhti cahmaerajari mʉhʉ? ¿Mʉhʉre ti yahusãrire dohse ni yʉhti cahmajari mʉhʉ? —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","To ã nichʉ tʉhoparota Jesu ãta tʉhotunocaha. To ã yʉhtierachʉ ñʉno sacerdotea bui pʉhtoro tirore sinituha tjoa: —Cristo, ¿Cohamacʉ warocarirota jijari mʉhʉ? ¿Noariro Cohamacʉ macʉno warota jijari mʉhʉ? —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Tiro tjija. Ã jina yʉhʉre masʉnore Cohamacʉ warocarirore yʉ Pʉcʉ jipihtina bui Jiriro to poto bʉhʉsehei yʉ dujichʉ ñʉnahca mʉsa. Ã yoa mʉano macaa me watoi yʉ tachʉ cʉ̃hʉre ñʉnahca mʉsa —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","To ã nichʉta sacerdotea bui pʉhtoro sehe to sãari suhtirore to basi tʉhrẽnocaha painare “Sua yʉhdʉara”, ni ñʉ masi dutiro. —Cohamacʉre ñano durucuro nina ahriro. To ñano durucuare tʉho tuhsʉja mari. Ã jia tópeinata yahusãjaro ahrirore. ¿Ã jina dohse yoanahcari mari mipʉre ahrirore? —niha sacerdotea bui pʉhtoro paina pʉhtoare. —Cohamacʉre to ñano durucuri buhiri wajãnocano cahmana tirore —ni yʉhtiha paina pʉhtoa. ");
INSERT INTO gvc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ã ni yʉhti tuhsʉ, cãaina tina mehne macaina Jesure chahcho puti sihõ mʉja, to caparire dʉhte dʉcata, tirore cjã, dota mʉjaha. Cjã tuhsʉ õ sehe ni bʉjʉpeha: —¿Noa jijari mʉhʉre dotaro? Ñʉerapaihta yahuga sãre —ni bʉjʉpeha tina. Ti ã cjã dotari baharo pʉhtoro yaina surara sehe tirore na wahcã, tina cʉ̃hʉ tirore ti wamomacari mehne ñano cjã namoha. ");
INSERT INTO gvc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ã yoa wʉhʉ cahai jiri wapai noari wapai Pedro to jichʉ sacerdotea bui pʉhtoro cahamacono wihiha. ");
INSERT INTO gvc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ticoro Pedro to sohmachʉ ñʉno tiro dihtare ñʉrucuha. —Nazare macariro mehne, Jesu mehne mʉhʉ cʉ̃hʉ jihre —niha ticoro Pedrore. ");
INSERT INTO gvc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","To ã nichʉ tʉhoro tiro õ sehe niha: —¿Dohse nimacanocaco nijari mʉhʉ? Mʉ nirirore ne masieraja yʉhʉ —niha Pedro ticorore. To ã niri baharo Pedro sahrĩno sopaca macari mahapʉ wahaha. Tói to ducuchʉ caraca duha. ");
INSERT INTO gvc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tói to jichʉ ñʉno cahamacono sehe ticoro cahapʉ ducuinare yahurocaha tjoa. —Ahriro cʉ̃hʉ Jesu buheina mehne macariro jira —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","To ã nichʉ tʉhoro Pedro pari turi õ sehe niha tjoa: —Tirore masieraja yʉhʉ —niha tjoa. Baharo curero tói ducuina Pedrore õ sehe niha: —Potocã tjira. Mʉhʉ Galilea macariro jira. Ã jicʉ tina mehne macarirota jira mʉhʉ —niha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ti ã nichʉ tʉhoro tiro õ sehe ni yʉhtiha: —Potocãta Cohamacʉ mehne nii nija mʉsare. Potocãta yʉ nierachʉ Cohamacʉ yʉhʉre buhiri dahrejaro. Tirore mʉsa nirirore ne masieraja yʉhʉ —ni yʉhtiha Pedro tinare. ");
INSERT INTO gvc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","To ã nichʉta caraca duha tjoa. To ã duchʉ tʉhoro Jesu tirore to nirire wacũha: “Caraca pʉa taha to duhto pano mʉhʉ yʉhʉre ‘Jesure masieraja’, niihca mʉhʉ. Tia taha ã niihca mʉhʉ”, Jesu to nirire wacũha Pedro sehe. To ã nirire wacũno, tuaro tiirucuha Pedro. ");
INSERT INTO gvc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ã yoa bohrearopʉ sacerdotea pʉhtoa, bʉcʉna, sã judio masare buheina, jipihtina paina pʉhtoa mehne cahmachu, durucuha Jesure ti yoahtire masia taa. Tirore ti wajãhtore durucu cahno tuhsʉ, Jesure dʉhte, na wahcã, Pilatore waha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tirore ti na sʉ wachʉ ñʉno Pilato tirore õ sehe ni sinituha Jesure: —¿Potocãta judio masa ti pʉhtoro tjijari mʉhʉ? —ni sinitu ñʉha tiro Jesure. —Ãja. Mʉ nino seheta tirota jija —ni yʉhtiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ã yoa sacerdotea pʉhtoa payʉ ni yahusãha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ti ã ni yahusãchʉ tʉhoro Pilato tirore õ sehe ni sinituha tjoa: —Ahrina mʉhʉre payʉ yahusãa nina. ¿Ti ã yahusãpachʉta dohse yoacʉ ne yʉhtierajari mʉhʉ tinare? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","To ã nipachʉta Jesu ne pari turi yʉhti namoeraha. Ã jiro Pilato cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cʉhmaripe pascuaripe masa yairo cjihtore cʉ̃iro peresupʉ jirirore, masa ti wio dutirirore Pilato ã wiobasa mʉjaa tiha. ");
INSERT INTO gvc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tí pjare Barrabá wama tiriro peresupʉ jiha. Tiro pʉhtoare cohã duaina, masare wajãina mehne macariro jiha. ");
INSERT INTO gvc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ã jia masa payʉ Pilato cahapʉ sʉa, tirore õ sehe ni siniha: —Cʉhmaripe sãre mʉ yoarucuriro seheta yoaga sãre. Cʉ̃iro peresupʉ jirirore sãre wiobasaga —niha tina. ");
INSERT INTO gvc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ti ã nichʉta Pilato tinare õ sehe ni sinitu ñʉha: —¿Ahriro Jesure mʉsa judio masa pʉhtorore yʉ wiobasachʉ cahmajari mʉsa? —ni sinitu ñʉha masare Jesure wio duaro. ");
INSERT INTO gvc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jesure masa ti cahĩchʉ ñʉa sacerdotea pʉhtoa cʉ̃hʉ tirore ñʉ tuhtiha. Ã ñʉ tuhtia tirore waha Pilatopʉre. Ã jiro masa ti cahĩri buhiri sacerdotea pʉhtoa ti ñʉ tuhtirire ti peresu yoa dutichʉ masino Jesure wio duamaha Pilato. ");
INSERT INTO gvc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","To ã wio duapachʉta sacerdotea pʉhtoa masare Jesu mehne suachʉ yoaha. Õ sehe ni dutiha tinare: “Jesu wijaachʉ cahmaeraja. Barrabá sehere wioga”, ni dutiha masare. ");
INSERT INTO gvc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ã jiro Pilatore Barrabáre ti wio dutiri baharo Pilato sehe tinare õ sehe ni sinituha tjoa: —¿Ahriro judio masa ti pʉhtoro mʉsa niriro sehere dohse yoaihcari yʉhʉ mʉsa ã nichʉ? —ni sinituha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Crusapʉ cjã puha wajãga tirore —ni sañurucuha masa. ");
INSERT INTO gvc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Yaba barore ñaare yoari ahriro mʉsa ã ni sañurucuchʉ? —ni sinitu namoha tinare. To ã nichʉ tʉhoa tina sañurucu namoha tjoa: —Crusapʉ cjã puha wajãga tirore —ni sañurucuha tina. ");
INSERT INTO gvc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ti ã ni sañurucuchʉ tʉhoro Pilato sehe masare wahchechʉ yoa duaro Barrabáre peresupʉ jirirore wio dutiha masa ti wio dutirirore. Tirore to wio dutiri baharo, Jesu sehere ñano tjanaye dutiha. Tirore ti tjanayeri baharo, tirore surarare wiaha, crusapʉ cjã puha wajã dutiro. ");
INSERT INTO gvc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ã yoa surara Pilato ya wʉhʉ puhichapʉ pretorio wama tiri wʉhʉ puhichapʉ tirore na sãa sʉha. Na sãa sʉ tuhsʉ, tina mehne macaina surarare pjiroca, cʉ̃noi cahmachu dutiha. ");
INSERT INTO gvc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cahmachu tuhsʉ, tina pʉhtoro ya suhtiro yoaro sehe bajuri suhtirore Jesure sãa, pota sorore yoa, tí sorore to dapu bui duhu payoha. ");
INSERT INTO gvc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ã yoa tuhsʉ õ sehe ni bʉjʉpeha tina tirore: —Noano tagã. Judio masa pʉhtoro noano tagã —ni bʉjʉpeha. ");
INSERT INTO gvc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ã niata yucʉcʉ mehne to dapure cjã mʉja, tirore chahcho puti sihõ mʉjaha tina. Tuhsʉ, cua pisaro yoaina yoaro seheta tirore na tuhcua caha sʉ, ño payoro sehe yoaa, bʉjʉpeha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ã yoa bʉjʉpe tuhsʉ ti sãari suhtirore tjuwe naroca, to ya suhti sehere tirore sãa, tirore crusapʉ cjã puha wajãa waha, naa wahaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesure ti ã naano watoi, tói wahariro Simo Cirene macariro campopʉ sʉriro, tina cahapʉ to wihichʉ ñʉa surara sehe tirore Jesu to wʉari crusare wʉa wahcã dutiha. Alejandro, Rufo pʉaro pʉcʉro jiha Simo sehe. ");
INSERT INTO gvc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Baharo, Gólgota wama tiropʉ Jesure na sʉha. Gólgota nino, “Dapu cohã”, nino nina. ");
INSERT INTO gvc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tópʉ tirore ti na sʉri baharo, se core, mirra wama tidʉ co mehne ti morea core Jesure wamaha. Wiho mejeta tiro sehe tí core sihni duaeraha. ");
INSERT INTO gvc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Baharo tina Jesure crusapʉ cjã puha dapoha. Cjã puha dapo tuhsʉ, to sãa suhti cjirire ti basi cahma witia taa, “¿Noa yaro jirohcari õ?” ni masia taa, docapea poca mehne docape mʉjaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesure crusapʉ ti cjã puhachʉ tia hora waro dʉhsasiniha cohari pja to sʉhto. ");
INSERT INTO gvc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ã yoa crusapʉ õ sehe ni joari pjĩne duhu õha tina tirore ti yahusãrire yahu duaa. “Ahriro judio masa bui pʉhtoro jiriro jira”, ni joaha tina tí pjĩne. ");
INSERT INTO gvc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ã yoa pʉaro yaca bʉcʉna Jesu cahai paye pjĩnipʉ crusaripʉ ti cjã puha daporina jiha tina. Cʉ̃iro to poto bʉhʉsehei, pairo to cõ bʉhʉsehei cjã puha dapoha tina cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ti ã yoachʉ panopʉ Cohamacʉ yare ti yahu joariro seheta ã waharo niha. Õ sehe ni joaa tiha: “ ‘Dutiare yʉhdʉrʉcaina mehne macariro jira’, ni tʉhoture masa tirore”, ni joaa tiha panopʉ. ");
INSERT INTO gvc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ã yoa crusari cahai yʉhdʉ wahcãina Jesure ñʉ, ti dapu pocare yurerʉca, tirore ñano ni durucuha: —Noana. Noana. ¿Cohamacʉ wʉhʉre cohã, tia dacho wahaboroi pari turi tí wʉhʉre dahrehtiro jijari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ã jiriro jicʉ, mʉ basi dujiaga. Ã jicʉ mʉ basi yoadohoga. Ã jii yʉhdʉ witiihca mʉhʉ —ni bʉjʉpeha tina. ");
INSERT INTO gvc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ti yoaro seheta sacerdotea pʉhtoa cʉ̃hʉ sã judio masare buheina cʉ̃hʉ tirore ã ni bʉjʉpeha. Ã ni bʉjʉpea õ sehe niha ti basi: —Tiro painare yʉhdoriro jiparota to basi yʉhdo masierara: ");
INSERT INTO gvc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Cristo, Cohamacʉ warocariro Israe masa pʉhtoro jija”, nimana tiro. Ã jina to basi to duji tachʉ ñʉna tirore wacũ tuanahca —ni bʉjʉpeha tina. Ã yoa yaca bʉcʉna tiro cahai ti cjã puha õrina cjiri cʉ̃hʉ tó seheta tirore ñano ni bʉjʉpeha tina cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ã yoa cohari pja jichʉ tia hora waro jipihtiropʉ nahitiano wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","To nahitia duhuchʉ waro Jesu tuaro sañurucuha: —Eloi, Eloi, ¿lama sabactani? —niha tiro. Ã nino õ sehe nino niha. “Yʉ Cohamacʉ, yʉ Cohamacʉ, ¿dohseacʉ yʉhʉre cohãri mʉhʉ?”, nino niha. ");
INSERT INTO gvc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","To ã nichʉ tʉhoa cãina tói ducuina õ sehe nimaha: —Tʉhoga mʉsa. Cohamacʉ yare yahu mʉhtarirore Elia cjirore pjirocaro nina —nimaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ã jiro cʉ̃iro tina mehne macariro wihmi nari sʉhtere vino sʉẽa core to sohari sʉhtere na mʉroca, yucʉcʉ sohtoapʉ dʉhte õ, Jesure wihmi dutiha. Ã wihmi dutiro, õ sehe nimaha: —Depʉsinia. Elia cjiro wihi ahrirore to na bororo tachʉ ñʉsinijihna mari —nimaha tiro painare. ");
INSERT INTO gvc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","To ã niri baharo Jesu sehe tuaro sañurucu, yariaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","To yariachʉta Cohamacʉ wʉhʉ macari suhtiro tóre to jiri tahtia waropʉ ti dʉcatari suhtiro dacho macai bui sehe tʉhnʉ bora ta, pʉa cahsaro tʉhnʉroca yoja sʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","To ã yariachʉ ñʉno surara pʉhtoro Jesu to wahãno potoi ducuriro õ sehe niha: —Potocã tjiri jimana. Ahriro Cohamacʉ macʉnota jiri jira —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ã yoa yoaropʉ ducua numia cʉ̃hʉ Jesure ñʉrocarucua niha. Tí numia mehne María Magdalena jiha. Pacoro María wama tiricoro cʉ̃hʉ jiha. Ticoro sehe José, to bahʉro Santiago ti pocoro jiha. Pacoro Salomé jiha. ");
INSERT INTO gvc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tí numia Jesu yahuare quihõno tʉhoa numia jia, Galilea yahpai to jisinichʉ tirore piti ti, yoadohoa tiha. Tí numia mehne payʉ paye numia cʉ̃hʉ Jerusalẽpʉ Jesu to sʉho tarina numia jiha. ");
INSERT INTO gvc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ã yoa tí dacho to yariari dacho Sabado pano judio masa sã sori nʉmʉ pano jiri dacho jiha. Ã yoa Pascua macaa cjihtire ti cahnori dacho jiha. Tí ñamiihta José Arimatea macariro cuiro marieno Pilato cahapʉ sʉha Jesu pjacʉre sinino sʉro. José judio masa sã pʉhtoa mehne macariro, pʉhtoa ti cua pisaro ñʉriro waro jiha. Tiro pʉhtoro Cohamacʉ masare to sʉho jihtore cohtaro niha. ");
INSERT INTO gvc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ã yoa José Pilatore to ã sinichʉ tʉhoro, tʉho cʉaa wahaha Pilato sehe. “¿Jesu yaria tuhsʉari?” ni tʉhoturo, cʉaa wahaha. Ã jiro surara pʉhtorore pjiroca õ sehe niha tirore: —¿Potocãta Jesu yariaa wahari? —ni sinituha tirore. ");
INSERT INTO gvc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","To ã nichʉ surara pʉhtoro õ sehe ni yʉhtiha: —Ãja. Yariaa wahahre —niha. To ã nichʉ tʉhoro, Pilato Jesu pjacʉre wa dutiha Josére. ");
INSERT INTO gvc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","To ã wa dutiri baharo José noari suhtirore nuchʉbasaha. Nuchʉbasa tuhsʉ, Jesu pjacʉ cjirore na boro, suhtiro mehne wahma, masa copapʉ tãcai ti sahari copapʉ to pjacʉre siõ sãa payoha. Siõ sãa payo tuhsʉ, tí copa cahai jiria tãcare pjiria tãcare tju turẽ wahcã, tí copare biha dapoha. ");
INSERT INTO gvc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, ã jichʉ María José pocoro Jesure ti na sãa duhu payorirore ñʉha. ");
INSERT INTO gvc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ã yoa Sabado dacho yʉhdʉri baharo, sʉ̃ sãari baharo, María Magdalena, Salomé, ã jichʉ María Santiago pocoro, tina tiaro numia wisõa me sitia core nuchʉha Jesu pjacʉre wisõa taa. ");
INSERT INTO gvc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ã jia domingo bohrea mʉja tachʉ Jesure ti duhu payori copapʉ ñʉa wahaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tí copa cahapʉ waharucua, õ sehe niha tina ti basi: —¿Tí copare bihari tãcare noa marine pjõobasarohcari na? —niha tí numia ti basi. ");
INSERT INTO gvc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Baharo tí copa cahapʉ sʉa, tí copare bihari tãcare, pjiria tãcare ti nawe cũriare ñʉha tina. ");
INSERT INTO gvc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ã ñʉa tí copapʉ sãa wahaha. Tópʉ sʉa, cʉ̃iro wahmʉnore ti poto bʉhʉsehei dujirirore, yehseri suhtiro sãarirore ñʉa, cʉaa wahaha tina. ");
INSERT INTO gvc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ti ã cʉachʉ ñʉno, tiro sehe õ sehe niha tí numiare: —Yʉhʉre ñʉ cʉaena tjiga. Jesu Nazare macariro, crusapʉ ti cjã puha wajãriro cjirore mʉsa macana nimana. Wiho mejeta tiro sehe masa wijaa tuhsʉhre. Õre mariahna. Tirore ti duhu payoro cjirore ñʉga. ");
INSERT INTO gvc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Tiro mʉsa pano Galileapʉ wahayuhto jiyuhti. Tói to niriro seheta mʉsa tirore ñʉhtina jiyuhti”, ni yahuna wahaga to buheinare, Pedro cʉ̃hʉre —ni yahu dutiha wahmʉno tí numiare. ");
INSERT INTO gvc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","To ã nichʉ tʉhoa tina cui, tetere, masa copa cahai jirina mʉrocaa wahaha. Ã cuia painare yahueraha. ");
INSERT INTO gvc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ã yoa Jesu sehe domingo ñamicunucã to masa wijaari baharo, María Magdalenare to siete watĩa to cohãnohricorore tiro bajua mʉhtaha. ");
INSERT INTO gvc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesu mehne macaina cjiri sehe to yariachʉ ñʉa, tuaro cahya, tiia niha. Ã ti tiiro watoi, María Magdalena sehe Jesure to ñʉrire tinare yahuro sʉmaha. ");
INSERT INTO gvc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Jesu catihre. Ñʉhi yʉhʉ”, ni yahumaha ticoro. To ã ni yahupachʉta, tina sehe ticorore ne tʉho duaeraha. ");
INSERT INTO gvc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Baharo pʉaro tina mehne macaina masa marienopʉ ti tinichʉ Jesu soro bajuriro tina cʉ̃hʉre bajuaha tjoa. ");
INSERT INTO gvc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","To ã bajuachʉ ñʉa tina tjua waha, paina Jesu yainare tíre yahuha. Ti ã ni yahupachʉta tina cʉ̃hʉre tʉho duaeraha. ");
INSERT INTO gvc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Baharo to buheina oncere mesa cahapʉ ti chʉ dujiro wato, tinare bajuaha tjoa Jesu. Tirore ñʉrinare ti yahuchʉ ti tʉho duaerari buhiri, tirore ti noano wacũ tuaerari buhirire masino, tiro tuhtiha tinare. ");
INSERT INTO gvc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ã tuhti tuhsʉ, tinare õ sehe niha: —Ahri yahpa jipihtiropʉre ahri yʉ ya quiti noaa buheare jipihtina ahri dacho macainare noano yahu site pahñona wahaga. ");
INSERT INTO gvc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yʉhʉre wacũ tuainare ti bautisarinare pichacapʉ wahaborinare yʉhdorohca Cohamacʉ. Tuhsʉ, yʉhʉre wacũ tuaeraina Cohamacʉ to buhiri dahrehtina pichacapʉ wahahtina jiahca. ");
INSERT INTO gvc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ã jia yʉhʉre wacũ tuaina yʉ tuaa mehne õ sehe yoaahca: Yʉ tuaa mehne, yʉ wama mehne watĩare cohã wioahca. Tuhsʉ, wahmaa dʉserire durucuahca. ");
INSERT INTO gvc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ã yoa agãare ti ñahachʉ, jipihtia ñima dohse jia ñimare ti sihnichʉ, tinare ne purĩsi. Ã yoa dohatiina bui ti wamomacarine ti ña payochʉ tina noaina wahaahca —ni yahuha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ã ni yahu tuhsʉ mari pʉhtoro Jesu mʉanopʉ mʉjaa wahaha. Tópʉ sʉro Cohamacʉ poto bʉhʉsehei dujiha tiro mehne pʉhtoro jiro. ");
INSERT INTO gvc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ã jia tina jipihtiropʉ noaa buheare Cohamacʉ masare to yʉhdʉchʉ yoahti buheare buhea wahaha. Ti ã buhechʉ mari pʉhtoro tinare yoadohoha. To tuaa mehne yoa ño masichʉ yoaha tinare, masare to ya buheare tʉho dutiro. Tó puro tjira.");
INSERT INTO gvc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Pʉhtoro Teófilo, ahrire mʉ buhehti cjihtire mʉhʉre joarocai nija. Jesu sã mehne jisinino to yoari cjirire payʉ paina joa dʉca tuhsʉre. Wahmanopʉre Jesure ñʉina cjiri, to yare buheina cjiri ti ni yahuriro seheta paina tíre joa dʉca tuhsʉre. Ã jicʉ ahri jipihtiare noano masi pahño duacʉ buhei. Ã jicʉ yʉhʉ cʉ̃hʉ tíre noano joa duaja mʉ buhehti cjihtire yoacʉ tacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jesu yare yahuina mʉhʉre buhe tuhsʉre. Tíre noano mʉ masi namohto sehe ahri tjure mʉhʉre joarocai nija. ");
INSERT INTO gvc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herode Judea yahpa macaina pʉhtoro to jichʉ cʉ̃iro sacerdote Zacaria wama tiriro jia tiha. Ã jiro Zacaria to ya curua macaina sehe sacerdotea curua Abías cjiro ya curua jiha. Zacaria namono cʉ̃hʉ sacerdote Aarõ cjiro panamañono ji turiaricoropʉ jiha. Ticoro Elisabe wama tiricoro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tina pʉaro Cohamacʉ dutiare noano yoa pahñoina ti jichʉ ñʉno, “Ahrina yʉ cahmano seheta ã jia tirucura”, ni ñʉha Cohamacʉ tinare. ");
INSERT INTO gvc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ticoro Elisabe ne pohna marienicoro jiha. Ã jia tina pʉaro ne pohna marieina ji, bʉcʉna waro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ã yoa sacerdotea ti dahraare dahraa taa, õ sehe yoaa tiha: Dahra mʉhtari curua cjiro pa curua mehne cahma cohtota mʉjaa tiha. Ã jia Zacaria ya curua macaina dahrahti dachori jichʉ, tina dachoripe sacerdotea ti dahraa tirucuriro seheta Cohamacʉ ya wʉhʉpʉ dahraa taa niha. ");
INSERT INTO gvc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sacerdotea Cohamacʉre ti ño payori mesapʉ inciensore me sitia pohcare jʉ̃htiro cjihtore besea taa, docapea mehne besea tiha. Ã yoa ti quihõri dacho jichʉ Zacaria ya curua macaina me sitiare jʉ̃htirore besea taa docapeha. Ã docapea Zacariare beseha. Ã jiro tiro pʉhtoro Cohamacʉ ya wʉhʉpʉ sãa wahaha me sitiare jʉ̃no waharo. ");
INSERT INTO gvc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tí wʉhʉpʉ tíre to jʉ̃no watoi jipihtina masa sehe sopacapʉ Cohamacʉre sinia tiha. ");
INSERT INTO gvc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tí pjare Cohamacʉ yairo anjo Cohamacʉre ño payori mesa poto bʉhʉsehei bajuarʉcʉ sʉha Zacariare. ");
INSERT INTO gvc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","To ã bajuachʉ ñʉno Zacaria tirore ñʉ cʉa yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","To ã cʉachʉ ñʉno anjo tirore õ sehe ni yahuha: —Zacaria, cuii tjiga. Cohamacʉ mʉ sinirire tʉhore. Ã jina mipʉre mʉsa pohna tinahca. Mʉsa macʉ cjihto masa bajuarohca. To bajuachʉ “João” ni wama pisuga tirocãre. ");
INSERT INTO gvc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","17","“Tiro yʉ tuaa mehne payʉ noaare yoarucuriro jira”, ni ñʉnohca Cohamacʉ mʉ macʉre. Tiro to masa bajuari baharo vinore, sihbiori cʉ̃hʉre sihnisi. Ã jiro tiro to masa bajuahto pano Espíritu Santo to niriro sehe yoariro jirohca tiro. Espíritu Santo tiropʉre sãarʉcʉ sʉ tuhsʉ ã baju yoarucurohca tiro mehne. Ã yoa payʉ Israe masare Cohamacʉ mari pʉhtorore cahmaeraina cjirire noano cahmachʉ yoarohca mʉ macʉ. Mari pʉhtoro to tahto pano Elia cjiro Cohamacʉ yare yahu mʉhtariro to buheriro seheta Espíritu Santo to yoadohoro mehne Cohamacʉ to tuaa mehne mʉ macʉ cʉ̃hʉ buherohca. Ã buhero ti pʉcʉsʉma ti pohna mehne ñano jimarinare ti noano cahma cahĩ jichʉ yoarohca. Ã yoa Cohamacʉre yʉhdʉrʉcaina cjiri cʉ̃hʉre noano ño payoa mehne yʉhtichʉ yoarohca. Ã buhero mari pʉhtoro Cohamacʉ yaina cjihtire yoarohca tiro. Ã jicʉ to masa bajuari baharo mʉhʉ wahcheihca. Payʉ paina cʉ̃hʉ wahcheahca —niha anjo Zacariare. ");
INSERT INTO gvc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","To ã nichʉ tʉhoro Zacaria sehe õ sehe ni sinituha anjore: —Sã bʉcʉna jija. ¿Ã jicʉ mʉ niri potocã jichʉ dohse masicʉhcari yʉhʉ? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","To ã nichʉ anjo sehe tirore õ sehe ni yahuha: —Yʉhʉ Gabrie wama tiriro jija. Cohamacʉ cahamacʉno to cahai ducuriro jija yʉhʉ. Cohamacʉ ahri noaa quitire yahu dutiro, mʉ cahai yʉhʉre warocare. ");
INSERT INTO gvc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yʉ yahuriro seheta potocãta waharohca. Yʉ ã nipachʉta yʉhʉre mʉhʉ potocã tʉhoerare. Ã jicʉ mipʉre mʉhʉ durucu masierariro wahaihca. Mʉ macʉ to bajuari baharo durucuihca tjoa —niha anjo Zacariare. ");
INSERT INTO gvc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sopacapʉ jiina masa Zacariare cohtaa niha. “¿Dohse jiro baro tiro Cohamacʉ wʉhʉpʉ jiro, so wijaa taerajari?” ni, cohtaa niha masa tirore. ");
INSERT INTO gvc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tuhsʉ, tiro wʉhʉpʉ jiriro wijaa wihi, tina mehne durucu masieraha. “Tiro Cohamacʉ wʉhʉi bajuare ñʉno niboca”, ni tʉhotu masiha tina. Ã jiro tiro durucu masierariro jiro to wamomacari mehne yoa cayoha masa ti masihto sehe. ");
INSERT INTO gvc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cohamacʉ wʉhʉi to dahraa pihtichʉ, tiro to namono mehne tjuaa wahaha ti wʉhʉpʉ. ");
INSERT INTO gvc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ti ã tju sʉri baharo to namono Elisabe niji pocoro jiha. Ã jiro ticoro cinco sʉ̃ri waro masa cahai wahaeraha. ");
INSERT INTO gvc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Õ sehe ni tʉhotuha ticoro: “Mipʉre yʉhʉre Cohamacʉ yoadohore jʉna. Pohna marienicoro jico bʉobiaro yʉhdʉhi yʉhʉ. Cohamacʉ to yoadohoro mehne mipʉre nijinocãre bocaja yʉhʉ”, ni tʉhotuha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabe cinco sʉ̃ri niji pocoro to ji wahcãchʉ waro Cohamacʉ sehe anjore Gabrie wama tirirore nuhmino, ne mʉa mehne jieraricoro cahapʉ warocaha. Ticoro María wama tiricoro Nazarei Galilea yahpai jiri macai jia tiha. José wama tiriro jiha to manʉno cjihto. Tiro panopʉ macariro Davi cjiro panamino ji turiariropʉ jiha. ");
INSERT INTO gvc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ã to warocachʉ María cahapʉ sʉro, anjo õ sehe ni yahuha: —María, ¿jimajari mʉhʉ? Cohamacʉ mʉhʉre yoadohoro nina. Mʉhʉre noano yoaro nina —niha anjo ticorore. ");
INSERT INTO gvc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","To ã nichʉ tʉhoro, ticoro tuaro wacũ tʉhotuha. Anjo to yahurire tʉhoturo “¿Dohse nino baro yʉhʉre ã nicari?” ni wacũha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","To ã ni tʉhotuchʉ masino anjo õ sehe ni yahu namoha ticorore: —María, Cohamacʉ mʉhʉre tuaro cahĩna. Ã jico mʉhʉre yʉ yahuhtire tʉho cʉaeco tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Noano tʉhoga. Cʉ̃iro nijinocãre pohna ticohca mʉhʉ. Tirocã to masa bajuari baharo, “Jesu” ni wama pisucohca mʉhʉ tirocãre. ");
INSERT INTO gvc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Tiro tua yʉhdʉariro jirohca. Ã jia tirore “Cohamacʉ Jipihtina Bui Jiriro macʉnota jira”, ni masiahca masa. Mʉ macʉ ñʉchʉno mʉnanopʉ Davi cjiro Israe masa ti pʉhtoro to jia tiriro cjiro seheta mʉ macʉ cjihto cʉ̃hʉre cũnohca Cohamacʉ. Ã jiro jipihtia dachoripe tiro Israe masare dutirohca. Pʉhtoro to jihto ne pihtisi —niha anjo. ");
INSERT INTO gvc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","To ã nichʉ tʉhoro María sehe õ sehe ni sinituha: —¿Dohse yʉhʉ manʉ mariapacohta pohna tibocari yʉhʉ? —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","To ã nichʉ tʉhoro anjo õ sehe ni yʉhtiha: —Espíritu Santo to tuaa mehne mʉhʉre nijinocãre bocachʉ yoarohca. Ã jiro Cohamacʉ Jipihtina Bui Jiriro to tuaa mʉhʉre to masʉrʉca caharo seheta bajuaeraparota tarohca mʉhʉre. Ã jia “Cohamacʉ macʉno, ñaa buhiri tia marieriro jira”, niahca masa mʉ macʉre. ");
INSERT INTO gvc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Cohamacʉ jipihtiare yoa masina. Ã jiro mʉ coyeacoro Elisabe cʉ̃hʉ bʉcoro waro jiparota mipʉre niji pocoro jira ticoro. Ticoro pohna tirohca mʉnocãre. Masa ticorore “Nijinocã boca masienicoro jira”, ti niricoro cjiro mipʉre nijinocãre to bocari baharo seis sʉ̃ri waro wahara —niha anjo Maríare. ");
INSERT INTO gvc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","To ã nichʉ María õ sehe ni yʉhtiha: —Yʉhʉre tʉhoga. Mari pʉhtoro to cahamacono jija yʉhʉ. Mʉ niriro seheta yʉhʉre ã wahajaro —niha ticoro. To ã niri baharo anjo wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","To ã niri baharo María tʉ̃yucʉri jiri yahpapʉ Judea yahpai jiri macapʉ ño duaro wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tópʉ sʉro, Zacaria ya wʉhʉpʉ sãano, “¿Jimajari?”, niha ticoro Elisabere. ");
INSERT INTO gvc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","To ã nichʉ Elisabe to tʉhochʉta, to macʉno sehe niji suhtiropʉ jirirocã ñuhmiha. Elisabe Espíritu Santo to dutiriro seheta yoa pahñoricoro jiro, to tuaare cjʉaricoro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ã jiro tuaro wahchea mehne ticoro bisiro durucuha: —Jipihtia numia yʉhdoro mʉhʉre noano yoahre Cohamacʉ. Mʉ macʉ cʉ̃hʉre noano yoahre Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cue, yʉ pʉhtoro pocoro yʉ cahai mʉ tachʉ noano yoara yʉhʉre Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mʉ yʉhʉre “¿Jimajari?” mʉ nichʉ yʉ macʉ sehe niji suhtiropʉ jirirocã wahchea mehne ñuhmihti yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cohamacʉ to niriro seheta yoarohca. Ã jico to yahurire tʉhoricoro jico wahchericoro jira mʉhʉ —niha Elisabe Maríare. ");
INSERT INTO gvc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","To ã nichʉ María õ sehe ni yʉhtiha: “ ‘Cohamacʉ noariro, tuariro jira’, nija. Yʉhʉ noano yajeripohna tija. ");
INSERT INTO gvc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cohamacʉ yʉhʉre pichacapʉ wahaboricorore yoadohoriro jira. Ã jiro mipʉre yʉhʉre noano wahchea mehne jichʉ yoara. ");
INSERT INTO gvc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Tiro yʉhʉre to cahamaconore wacũri jira. Cohamacʉ tua yʉhdʉariro noaa dihtare yʉhʉre yoadohohre. Ã jia mipʉre ‘Ticorore Cohamacʉ noano yoahre’, jipihtina masa ã ni, durucuahca yʉhʉre. Cohamacʉ ñaa marieriro jira. ");
INSERT INTO gvc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jipihtia dachoripe jipihtina tirore ño payoinare tiro pja ñʉriro jira. ");
INSERT INTO gvc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cohamacʉ to tuaa mehne yoaha. ‘Painare yʉhdʉrʉcaja’, niinare yʉhdʉrʉcaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pʉhtoare cohãha tiro. Ã jiro cahamaca sehere tiro pʉhtoa yoaro seheta cũha tinare. ");
INSERT INTO gvc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jʉca baaina cjirire tiro noaa chʉare waha. Tuhsʉ, payʉ cjʉaina cjirire paye baro cjʉaeraina yoaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Mari ñʉchʉsʉma cjirire to yahu cũriro seheta yoa pahñoha Cohamacʉ. To cahamaca Israe masare tiro yoadohoha. Abrahã cjirore mari ñʉchʉsʉma cjirire jipihtina to coyea to baharo jiina cʉ̃hʉre Cohamacʉ jipihtia dachoripe ã pja ñʉrucuriro jia tiha. Tinare to yahu cũrire boeraha Cohamacʉ”, niha María. ");
INSERT INTO gvc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tia sʉ̃ waro Elisabe mehne jiha ticoro. Tó puro to jiri baharo to ya macapʉ tjuaa wahaha María. ");
INSERT INTO gvc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabe to niji wahcõri baharo to macʉno masa bajuaha. ");
INSERT INTO gvc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ã jia Cohamacʉ ticorore to ã noano yoachʉ to ya maca macaina to coyea cʉ̃hʉ ticoro mehne wahcheha. ");
INSERT INTO gvc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho dachori to masa bajuari baharo, to pʉcʉsʉma tirocãre mahanocã to pjacʉ cahsarocãre yihso dutia taa niha. Ã jia tina mehne macaina ti cahapʉ sʉha ti yihsochʉ ñʉa taa. Tina mehne macaina Zacaria to pʉcʉro wamare tirocãre wamoa duamaha. ");
INSERT INTO gvc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ti ã wamoa duapachʉta to pocoro õ sehe niha: —To pʉcʉro wamare wamoeraja. João wamoanahca tirocãre —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Mʉ coyea ne cʉ̃iro João wama tiriro mariahna —niha tina ticorore. ");
INSERT INTO gvc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ã jia ti wamomacari mehne yoa ño, Zacariare õ sehe ni sinitu ñʉha tina: —¿Mʉhʉ waro dohse wamoa duajari mʉ macʉre? —ni sinitu ñʉha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ti ã nichʉ tiro sehe joahti pjĩne siniroca, ñaha, joaha: “Yʉ macʉ João wama tirohca”, ni joaha Zacaria. To ã ni joachʉ tina sehe cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","To ã ni joari baharo tirore durucuchʉ yoaha Cohamacʉ. Ã jiro tiro durucua wahaha jʉna: —Cohamacʉ tuariro, noariro jira —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","To ã ni durucuchʉ tʉhoa tó macaina cʉaa wahaha. Ã jia ahri jipihtiare Judea yahpa macainare tʉ̃yucʉ watoi jiinare masa yahu siteha. Ã jia masa tó macaina noano masi pihtia wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jipihtina tíre tʉhoa wacũha. “Cohamacʉ tuaare ahrirocã cjʉara. Ã jiro wiho jiriro jierara ahrirocã”, ni tʉhotuha masa. ");
INSERT INTO gvc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ã yoa to pʉcʉro Zacaria sehe Espíritu Santo to dutiriro seheta yoa pahñoriro jiro to tuaare cjʉariro jiro Cohamacʉ yare õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mari Israe masa Cohamacʉre, mari pʉhtorore wahche payojihna mari. To yaina jija mari. Ã jiro tiro mari cahapʉ wihiro, marine yoadoho, noano yʉhdʉchʉ yoaro taro nina. ");
INSERT INTO gvc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Cohamacʉ marine, pichacapʉ wahaborinare yʉhdʉchʉ yoahtirore, tua yʉhdʉarirore warocara. Ahriro marine yʉhdʉchʉ yoahtiro cjihto sehe Cohamacʉre dahra cohtariro Davi cjiro panamino ji turiariro jira. ");
INSERT INTO gvc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Panopʉre to yaina waro, to yare yahu mʉhtaina cjirire ahri õ sehe wahahto cjihtore yahu cũ mʉhta tuhsʉa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Mʉsare ñʉ tuhtiinare, jipihtina mʉsare ñano yoainare dʉcataihtja’, ni cũha Cohamacʉ marine. ");
INSERT INTO gvc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mari ñʉchʉsʉma cjiripʉre ‘Mʉsare pja ñʉi, yoadohoihtja. Mʉsare yʉ yahu cũrire wacũihtja’, niha Cohamacʉ. Tí pjapʉre to ni cũriro seheta mipʉre marine sohtori tiro taro nina. ");
INSERT INTO gvc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Panopʉre õ sehe ni cũa tiha Cohamacʉ Abrahãre: ‘Potocã niita nija mʉhʉre. Mʉ coyea baharopʉ ji nʉnʉhtinare paina tinare ti ñʉ tuhtichʉ, yʉhʉ sehe tinare dʉcataihtja. Ã jia mʉ coyea sehe ne cuiro marieno yʉ dutiare yoa, yʉhʉre ño payoahca. Tina ti catiro puro yʉ ñʉrocaroi buhiri marieno, quihõno jia tiina jirucuahca’, ni yahu cũa tiha Cohamacʉ mari coyeiro Abrahã cjirore”, niha Zacaria. Ã ni tuhsʉ tiro to macʉno cʉ̃hʉre õ sehe niha tjoa: ");
INSERT INTO gvc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","“Macʉ, mʉhʉre õ sehe niahca masa: ‘Cohamacʉ Jipihtina Bui Jiriro yare yahu mʉhtarirota jira’, ni masiahca mʉhʉre. Mʉhʉ mari pʉhtoro Cristo to tahto panore masare yahuyui wahaihca. Ã yahuyui wahacʉ, õ sehe ni yahuyuihca tinare: ‘Mari pʉhtoro tarohca. Tiro mʉsa ñaa yoari buhiri tiare cohã, pichacapʉ wahaborinare yʉhdorohca mʉsare’, ni yahuihca mʉhʉ. Ã ni yahucʉ, mari pʉhtoro to tahtore cahnoyu dutii niihca mʉhʉ tinare. ");
INSERT INTO gvc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Cohamacʉ sehe marine tuaro pja ñʉriro ji, marine noano yoariro jitjiãno, tiro marine pichacapʉ wahaborinare yʉhdʉchʉ yoa duara. Ã jiro tiro Cristore buhriaro yoaro sehe jirirore mari cahapʉ warocara. ");
INSERT INTO gvc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tiro mari cahai wihiro marine pichacapʉ wahaborinare nahitiano waropʉ jimarinare buhriaro marine to noano ñʉ bocachʉ yoaro seheta Cohamacʉ ya potocã ni yahuare masichʉ yoarohca tiro. Ã yoa mari tiro mehne cʉ̃no mehne mari noano ji masihto cjihto cʉ̃hʉre yahurohca marine”, niha Zacaria. ");
INSERT INTO gvc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ã yoa Zacaria macʉno noano pjacʉ tiriro bʉcʉaha. Ã bʉcʉaro, Cohamacʉre tuaro ño payoriro jiha. Tuhsʉ, yoari pja masa marienopʉ jia tiha. Israe masare buhe dʉcaro tópʉta to jiriro cjiroi jia tiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tí pjare jipihtia yahpari macaina bui pʉhtoro Augusto jia tiha. Ã jiro jipihtinare quihõ dutiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ahrina masare ti coã quihõ dʉcachʉ Siria yahpa macaina pʉhtoro Cirenio wama tiriro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ã jia jipihtina ti ñʉchʉsʉma panopʉ macaina ya macaripʉ ti wamare joa õa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José cʉ̃hʉ Nazarepʉ Galilea yahpai jiri macapʉ jiina waha, Judea yahpapʉ Belẽ wama tiri macapʉ sʉha. Pʉhtoro Davi cjiro panopʉ macariro to masa bajuariro jiha Belẽ. José Davi cjiro panamino ji turiariro jiro pʉhtoa masare to quihõ dutichʉ tʉhoro Belẽpʉ to wamare joa õ dutiro wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ã jiro tiro María to namono cjihto mehne tópʉ to wamare joa õ dutiro sʉha. Ticoro sehe wihãrirocãre cjʉaro caharicoro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ã jiro Belẽpʉ sʉro ticoro niji wahcõha. ");
INSERT INTO gvc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tópʉre masa ti carĩri wʉhʉ ne mʉ sʉeraha tinare. Ã jiro ticoro pohna ti tuhsʉ, tirocãre suhtiro mehne coma, wachʉa ti chʉri wahwai, tja bui tirocãre duhu payoha. Tirocã wahma to pohna ti mʉhtarirocã jiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tí ñamine campopʉ ovejare ñʉ wihboina ti yaina ovejare ñʉ wihboa niha. ");
INSERT INTO gvc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tópʉ ti jichʉ Cohamacʉ warocariro anjo tinare bajuaha. To ã bajuachʉ Cohamacʉ to si sitea tinare buhriaha. To ã si sitechʉ ñʉa, ovejare ñʉ wihboina cuia wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ti ã wahachʉ anjo tinare õ sehe ni yahuha: —Noaa quitire mʉsare yahui taja. Jipihtinare masare wahchechʉ yoarohca ahri quiti. Ã jina yʉhʉre cuiena tjiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Micha ñamine pʉhtoro cjiro Davi ya macapʉ mʉsare pichacapʉ wahaborinare yʉhdohtiro, Cristo Cohamacʉ warocariro mari pʉhtoro masa bajua tuhsʉhre. ");
INSERT INTO gvc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Suhtiro mehne comariro wachʉa chʉri wahwa bui ti duhu payoriro mʉsa ñʉhtiro tiro tjirohca —ni yahuha anjo tinare. ");
INSERT INTO gvc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","To ã nichʉta payʉ mʉano macaina ji mʉhtariro anjo mehne Cohamacʉre wahche payoha. Õ sehe ni wahche payoha tina: ");
INSERT INTO gvc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Cohamacʉre mʉano macarirore ño payojihna. Ã jia Cohamacʉ to cahĩina cuiro marieno cahmacheno marieno noano jijaro”, ni wahche payoha anjoa peri. ");
INSERT INTO gvc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ã ni wahche payo tuhsʉ mʉanopʉ ti mʉjari baharo ovejare ñʉ wihboina sehe ti basi cahma durucuha: —Ahrire Cohamacʉ marine to yahurire Belẽpʉ basa ñʉjihna —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ã nia ño duaro wahaa wahaha tina. Maríare, Josére boca sʉ, wihãrirocãre wachʉa chʉri wahwai ti duhu payorirocãre ñʉha tina. ");
INSERT INTO gvc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ovejare ñʉ wihboina tirocãre ñʉ tuhsʉ anjo wihãrirocãre to yahurire yahu turiaha painare. ");
INSERT INTO gvc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ti ã ni yahu turiachʉ jipihtina tinare tʉho cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ahri jipihtiare María wacũ tʉhoturucuha. ");
INSERT INTO gvc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ã yoa ovejare ñʉ wihboina sehe anjo to yahuriro seheta jichʉ ñʉa, “Cohamacʉ tuariro jira”, ni wahcheha. Ã ni wahche, majare tjuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cʉ̃ somana baharo wihãrirocã to pjacʉre mahanocã cahsarocãre yihso na tuhsʉ tirocãre tina Jesu wamoaha. Jesure wahma to bocahto pano anjo sehe “ ‘Jesu’ ni wama pisuga tirocãre”, ni yahu tuhsʉha. Ã jia tirocãre “Jesu” ni wama pisuha. ");
INSERT INTO gvc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cohamacʉ dutia Moise to yahuriro seheta yoaa taa José, María mehne Jerusalẽpʉ wahaha. Tópʉ wahaha María to pohna tiri baharo to noaricoro to wahari baharo to ã waharire ñono taro. Ã wahaa, tina Jesucãre naa wahaha. Tirocãre Cohamacʉre “Ahrirocã mʉ yairo cjihto jira”, ni ñoa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Õ sehe yoaha Cohamacʉ yare ti joari pũi to yoa dutiriro seheta. “Jipihtina mʉsa pohna wahma bajua mʉhtainacãre Cohamacʉre ñoga. ‘Ahrirocã mʉ yairo cjihto jira’, ni ñoga”, ni dutia tiha Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ã ño tuhsʉ Cohamacʉ to yoa dutiriro seheta tina minichahcare waa wahaha Cohamacʉre ño payoa. Õ sehe dutia tiha Cohamacʉ: “Bujaa pʉaro waga yʉhʉre. O tina mariachʉ urítua wihãinacã pʉaro waga yʉhʉre ño payona”, ni dutia tiha Cohamacʉ. To yoa dutiriro seheta yoaha tina ticoro pjacʉ noari pjacʉ to waharire ñoa taa. ");
INSERT INTO gvc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalẽi Simeo wama tiriro jiha. Tiro quihõno yoariro, Cohamacʉre ño payoriro jiro, Cohamacʉ Israe masare to yoadohohtire cohtariro jiha. Tiro Espíritu Santo to nino sehe yoariro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ã jiro tiro to yariahto pano Cohamacʉ to warocahtirore Cristore to ñʉhti cjihtire tó pano yahu tuhsʉha Espíritu Santo tirore Simeore. ");
INSERT INTO gvc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ã jiro Espíritu Santo tirore to dutichʉ Cohamacʉ wʉhʉpʉ sãa wahaha. To sãa sʉri baharo Jesu pʉcʉsʉma ti macʉnocãre na sãaha. Cohamacʉ to dutiriro seheta yoaa niha. ");
INSERT INTO gvc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeo sehe tirocãre wʉa na, Cohamacʉre ño payo, “Noana” ni, tiro mehne durucuha. Õ sehe niha tiro Cohamacʉre: ");
INSERT INTO gvc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“Mipʉ pinihtare pʉhtoro, mʉ niriro seheta jipihtina masare pichacapʉ wahaborinare yʉhdʉchʉ yoahtiro cjihtore warocahre mʉhʉ. Tiro judio masa jierainare buhero mʉhʉre noano masichʉ yoarohca tinare. Masare yʉhdohtiro Israe masʉnore mʉhʉ cũha. Sã coyeirore Israe masʉnore mʉ cũchʉ jipihtina masia, ‘Israe masare noano yoara Cohamacʉ’, niahca masa. Ahrirocã sãre yʉhdʉchʉ yoahtiro jira. Ã jicʉ ahrirocãre ñʉ tuhsʉcʉ, mipʉre noano wahcheriro yariaihca”, niha Simeo. ");
INSERT INTO gvc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeo tirocãre to ã nichʉ Jesu pʉcʉsʉma sehe tʉho cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ã jiro Simeo tinare “Noano jiga mʉsa” nino, tiro María Jesu pocorore õ sehe ni yahuha: —Cohamacʉ ahrirocãre beseha. To ã beseriro to jipachʉta judio masa payʉ tirore yʉhdʉrʉcaahca. Ã yoaa tina pichacapʉ wahaahca. Judio masare payʉ yʉhdohtirore Cohamacʉ beseha tirocãre. Tiro Cohamacʉ yare yahuriro to jipachʉta masa payʉ tirore ñano ni yahu wajaahca. ");
INSERT INTO gvc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ti ã yoachʉ paina ti ñano wacũare masiahca. Ã jico mʉhʉ tuaro cahyacohca —niha Simeo Maríare. ");
INSERT INTO gvc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tói Cohamacʉ yare yahu mʉhtaricoro Ana wama tiricoro jiha. Ticoro Fanuel macono jiro, Aser cjiro ya curua macaricoro jiha. Bʉcoro waro jiha. Ticoro nuhmino jiro manʉ tiha. Ã yoa siete cʉhmari to manʉno mehne jiha. Tó puro to jiri baharo to manʉno yariaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ã jiro ochenta y cuatro cʉhmari waro wapewahyoro jia tiha ticoro. Ã jiro ticoro dachopʉ cʉ̃hʉre ñamipʉ cʉ̃hʉre Cohamacʉ yare yoaro taro chʉaeraro, Cohamacʉ mehne durucu, Cohamacʉ wʉhʉre ne wijaaera tiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeo to durucuro watoi ticoro tina cahai wihiro, wahchero Cohamacʉre “Noana”, niha. Ã jiro Jerusalẽ macainare pichacapʉ wahaborinare yʉhdohtirore cohtainare ticoro Jesucãre yahuha tina jipihtinare. ");
INSERT INTO gvc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cohamacʉ to dutiriro seheta yoa tuhsʉa, tina ti ya macapʉ Nazarepʉ tjuaa wahaha. Galilea yahpai jiha tí maca Nazare. ");
INSERT INTO gvc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesu sehe noano bʉcʉa, tuariro wahaha. Ã jiro tiro noano tʉho masiriro bʉcʉaha. Cohamacʉ tirore noano yoaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cʉhmaripe Jesu pʉcʉsʉma Jerusalẽpʉ pascua nʉmʉrine bose nʉmʉrine yʉhdoa wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ã jia Jesu doce cʉhmari to cjʉachʉ waro ti yoarucuriro seheta tina jipihtina Jerusalẽpʉ bose nʉmʉrine yʉhdoa wahaha tjoa. ");
INSERT INTO gvc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tí macapʉ sʉ, tí bose nʉmʉrine yʉhdo tuhsʉ tina ti ya macapʉ majare tjuaa wahaha tjoa. Wiho mejeta Jesu sehe ti ã majare tjuaapachʉta, Jerusalẽpʉ tjuanocaha. To pʉcʉsʉma sehe tíre to tjuarire masieraha. ");
INSERT INTO gvc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Paina mari mehne macaina mehne taca mari macʉ”, ni tʉhotumaha tina. Ã jia tina cʉ̃ dacho waro noano Jesu marieno waharucumaha. Tí dacho pihtichʉ waro tina Jesure ti coyea watoi ã jichʉ ti ñʉ masiina watoi cʉ̃hʉre macamaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wiho mejeta ne bocaeraha. Ã jia tina pari turi Jerusalẽpʉ majare tjuaa wahaha tjoa, tirore macaa wahaa. ");
INSERT INTO gvc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tia dacho baharo Cohamacʉ wʉhʉ wijaroi tirore boca sʉha. Tói Jesu judio masare buheina watopʉ duji, tinare tʉho, tinare sinituro niha. ");
INSERT INTO gvc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tina jipihtina Jesure to quihõno yʉhtichʉ tʉhoa noano masirirocã to jichʉ ñʉa, tina cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesu pʉcʉsʉma cʉ̃hʉ tirore ñʉa, tina cʉ̃hʉ cʉaa wahaha. Ã jiro to pocoro tirore õ sehe niha: —Macʉ, ¿dohseacʉ ã yoari mʉhʉ sãre? Sã mʉ pʉcʉsʉma pjíro tʉhotu, cahya, macana nihi mʉhʉre —niha ticoro to macʉnore. ");
INSERT INTO gvc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","To ã nichʉ tʉhoro tiro to pʉcʉsʉmare õ sehe ni yʉhtiha: —¿Dohseana yʉhʉre macari mʉsa? Yʉ Pʉcʉ waro ya wʉhʉi ji to dutiriro seheta yoai nija. ¿Tíre masierajari mʉsa? —niha tiro tinare to pʉcʉsʉmare. ");
INSERT INTO gvc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","To ã ni yahupachʉta tina to yahuare tʉho ñahaeraha. ");
INSERT INTO gvc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ã yoari baharo, Jesu to pʉcʉsʉma mehne Nazarepʉ tjuaa wahaha. Tju sʉ, to pʉcʉsʉmare ne yʉhdʉrʉcaerariro jia tiha tiro. Ahri jipihtia to yoarire ñʉno María noano tʉhotu, wacũrucua tiha. ");
INSERT INTO gvc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ã yoa Jesu bʉcʉa, noano tʉho masiriro wahaha. Tó sehe jiriro to ji bʉcʉachʉ ñʉno, Cohamacʉ sehe tirore noano ñʉ ji coa, tuaro cahĩa tiha. Masa cʉ̃hʉ tirore tó seheta noano ñʉ ji coa, tuaro cahĩa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tí pjare ti bui pʉhtoro jiriro Tiberio wama tiriro to pʉhtoro jiri baharo quince cʉhmari wahaha. Tuhsʉ, Poncio Pilato wama tiriro sehe Judea yahpa macaina pʉhtoro jiha. Ã yoa Herode wama tiriro sehe Galilea yahpa macaina pʉhtoro jiha. To bahʉro Felipe sehe Iturea yahpa macaina, Traconite yahpa macaina cʉ̃hʉ ti pʉhtoro jiha. Tuhsʉ, Lisanias wama tiriro Abilinia yahpa macaina pʉhtoro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tí pjare Ana, Caifa mehne jipihtina sacerdotea bui pʉhtoa jiha. Ahrina jipihtina ti jiri pjare João Zacaria macʉno masa marienopʉ jirirore Cohamacʉ sehe tirore to yare buhe dutiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ã jiro Jordão wama tiri ma dʉhtʉ cahai jiri yahpai jipihtiropʉ João buhero wahaha: —“Noaina jija sã”, ni mʉsa tʉhotumari cjirire tʉhotu cohtota, Cohamacʉre cahmaga mʉsa. Ã yoana tíre mʉsa yoarire ñona tana, bautisaina jiga. Mʉsa ã cohtotachʉ ñʉno Cohamacʉ mʉsa ñaa buhirire borohca —ni buhea tiha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaia cjiro panopʉ macariro Cohamacʉ yare yahu mʉhtariro to joariro seheta ahriro Joaõ yoaro niha. Õ sehe ni joaa tiha Isaia cjiro João to buhehtore: “Masa marienopʉ durucu sañurucuriro õ sehe ni buherohca: ‘Mari pʉhtoro to tahto pano “Noaina jija sã”, ni mʉsa tʉhotumari cjirire tʉhotu cohtota, Cohamacʉre cahmaga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pja wʉhtʉri, pja buri cʉ̃hʉre noari wapa mari yoariro seheta, tuhcua maharine potoa mahari mari yoariro seheta, ñaa maharine noaa maharine mari yoariro seheta, wetere mʉsa cosariro seheta mʉsa ñaa tʉhotuare cohtota, cahno mʉhtaga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mʉsa ã yoachʉ Cohamacʉ mʉsare pichacapʉ wahaborinare to yʉhdʉchʉ yoachʉ ñʉahca jipihti ahri yahpa macaina’, ninohca tiro sañurucu yahuriro sehe”, ni joaa tiha Isaia cjiro panopʉre. ");
INSERT INTO gvc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Masa payʉ João cahai wihia tiro tinare bautisachʉ cahmaha tina. Ã jiro tiro tinare õ sehe ni yahuha: —Agãa ñima tiina yoaro seheta masare dojomehneina, cui duhti duaina jira mʉsa. Mʉsa ñaa yoarire mʉsa cahya, duhu duaerari buhiri Cohamacʉ to buhiri dahrehto pano duhti masierara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Potocãta mʉsa ñaa tʉhotumarine cohtotaina jina, Cohamacʉre cahmaina jina, tíre mʉsa yoaa mehne ñoga. Õ sehe ni tʉhotu wisiena tjiga. “Panopʉ macariro Abrahã mari ñʉchʉ cjiro jia tiha. Ã jina to panamana jina mari Cohamacʉ yaina jija”, ni tʉhotu wisiena tjiga mʉsa. Mʉsare niita nija. Abrahã panamana mʉsa jiina jimana mʉsa. Mʉsa ã jipachʉta tí mʉsa ã jia yaba cjihti jierara. Cohamacʉ sehe ahri tãa mehne Abrahã coyeare dahre masina. Ã jiro Abrahã coyea mʉsa jia wiho waro jira tãa ti wiho waro jiro seheta. ");
INSERT INTO gvc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Õ sehe jira: Masa yucʉri yoaro seheta jira. Cohamacʉ sehe coma mehne yucʉrire cjã cohãriro yoaro sehe jira. Ã jiro noaa dicha maria yucʉre nʉhcõri mehnepʉta cjã cohãnohca tiro. Tíre to cjã cohãri baharo, pichacapʉ jʉ̃ cohãnohca tiro. (Ãta yoaro taro nina masa cʉ̃hʉre tirore cahmaerainare) —ni yahuha João masare. ");
INSERT INTO gvc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","To ã nichʉ tʉhoa masa sehe tirore õ sehe ni sinitu ñʉha: —¿Dohse yoanahcari sã? —niha tina Joãore. ");
INSERT INTO gvc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Pʉa suhtiro cjʉariro suhti marierirore cʉ̃no waga. Ã yoa mʉsa chʉa cjʉana paina cʉ̃hʉre waga —niha João. ");
INSERT INTO gvc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mahainacã pʉhtoa ya cjihtire wapa na cohtaina cʉ̃hʉ tinare to bautisachʉ cahmaha. Ã jia João cahai wihia, tirore õ sehe ni sinituha: —¿Buheriro, sã sehe dohse yoanahcari sã? —niha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Mʉsa pʉhtoa ti wapa na dutiro purota masare wapa naga. Mahño na namoena tjiga —ni yahuha João tinare. ");
INSERT INTO gvc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Paina surara tirore õ sehe ni sinituha tjoa: —¿Sã sehe dohse yoanahcari? —niha tina tirore tjoa. —Masa ti niñerure maena tjiga. Ã yoana mahñoa mehne ti niñerure naena tjiga. Mʉsare ti waparo purota wahchega —ni yahuha João. ");
INSERT INTO gvc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Masa Cristore Cohamacʉ to warocahtirore cohtaa niha. Ã jia õ sehe ni tʉhotu dʉcaha tina Joãore. “Ahriro João sehe Cristo jiboca”, ni tʉhotumaha tina. ");
INSERT INTO gvc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ti ã nichʉ tʉhoro João jipihtinare õ sehe ni yahuha: —Yʉ baharo yʉ yʉhdoro tuariro tarohca. Noa yʉhdʉariro jira tiro. Tiro yoaro sehe jieraja yʉhʉ sehe. Ã jicʉ tirore tʉhotucʉ, “Wiho jiriro jija yʉhʉ”, ni tʉhotuja yʉhʉ. Yʉhʉ sehe mʉsare bautisacʉ co mehne yoamahi. Tiro sehe yʉ yʉhdoro yoarohca. Espíritu Santore masa mehne ã jirucuchʉ yoarohca. Wiho mejeta paina sehere ti ñaare tʉhotumari cjirire tʉhotu cohtota duaeraina sehere tiro pichaca mehne buhiri dahrerohca. ");
INSERT INTO gvc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yʉ baharo tariro cahsarire cohãriro yoaro sehe jira. Cahsarire cohãriro to batiro mehne jipihtia to trigo yapari cahsarire putiwera. Ã yoa tuhsʉ trigo sehere to wihbori wʉhʉi cũnohca. Tó seheta yoarohca ti tirore cahmainare yʉ baharo tariro. To putiwea cahsari sehere tiro jʉ̃nohca. Tí cahsarire to jʉ̃ri pichaca ne yatisi. (Ãta yoarohca tiro yʉ baharo tariro tirore cahmaerainare) —ni yahuha João. ");
INSERT INTO gvc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Payʉ to ã ni yahua mehne masare noaa buheare yahuha João. ");
INSERT INTO gvc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tuhsʉ, pʉhtoro Herode sehe to bahʉro Felipe namonore to namo tiri buhiri, pjíro ñaare to yoari buhiri cʉ̃hʉre João tirore yahumaha. ");
INSERT INTO gvc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","To ã ni yahuri buhiri Herode sehe ñaare yoa namoha, Joãore peresu yoaro. ");
INSERT INTO gvc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Joãore ti peresu yoahto pano paina masare João sehe bautisaro niha. Tinare bautisaro Jesu cʉ̃hʉre bautisaha. To ã bautisachʉ, Jesu diapʉ ducuriro Cohamacʉre to sinino watoi mʉano parĩ mʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","To parĩ mʉari baharo Espíritu Santo buja yoaro sehe Jesu buipʉ duji taha. To ã duji tachʉ mʉanopʉ durucuro coa taha: —Mʉhʉ yʉ macʉ yʉ cahĩriro jira. Mʉhʉ mehne wahcheja —nino coa taha mʉanopʉ. ");
INSERT INTO gvc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu to buhe dʉcari cʉhmare treinta cʉhmari cjʉaha tiro. “Tiro José macʉno jira”, ni tʉhotumaha masa. José sehe Elí macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat macʉno jiha. Matat Leví macʉno jiha. Leví Melqui macʉno jiha. Melqui Jana macʉno jiha. Jana José macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías macʉno jiha. Matatías Amós macʉno jiha. Amós Nahum macʉno jiha. Nahum Esli macʉno jiha. Esli Nagai macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat macʉno jiha. Maat Matatías macʉno jiha. Matatías Semei macʉno jiha. Semei Josec macʉno jiha. Josec Joiadá macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joiadá Johanán macʉno jiha. Johanán Resa macʉno jiha. Resa Zorobabe macʉno jiha. Zorobabe Salatie macʉno jiha. Salatie Neri macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui macʉno jiha. Melqui Adi macʉno jiha. Adi Cosam macʉno jiha. Cosam Elmodam macʉno jiha. Elmodam Er macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josué macʉno jiha. Josué Eliezer macʉno jiha. Eliezer Jorim macʉno jiha. Jorim Matat macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví macʉno jiha. Leví Simeo macʉno jiha. Simeo Juda macʉno jiha. Juda José macʉno jiha. José Jonan macʉno jiha. Jonan Eliaquim macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea macʉno jiha. Melea Mená macʉno jiha. Mená Matatá macʉno jiha. Matatá Natán macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán Davi macʉno jiha. Davi Jesé macʉno jiha. Jesé Obed macʉno jiha. Obed Booz macʉno jiha. Booz Sélah macʉno jiha. Sélah Nahasón macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasón Aminadab macʉno jiha. Aminadab Admín macʉno jiha. Admín Arní macʉno jiha. Arní Esrom macʉno jiha. Esrom Fares macʉno jiha. Fares Juda macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda Jacobo macʉno jiha. Jacobo Isaa macʉno jiha. Isaa Abrahã macʉno jiha. Abrahã Taré macʉno jiha. Taré Nahor macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Serug macʉno jiha. Serug Ragau macʉno jiha. Ragau Péleg macʉno jiha. Péleg Éber macʉno jiha. Éber Sélah macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sélah Cainán macʉno jiha. Cainán Arfaxad macʉno jiha. Arfaxad Sẽ macʉno jiha. Sẽ Noé macʉno jiha. Noé Lame macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lame Matusalẽ macʉno jiha. Matusalẽ Enoco macʉno jiha. Enoco Jared macʉno jiha. Jared Mahalaleel macʉno jiha. Mahalaleel Caina macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Caina Eno macʉno jiha. Eno Sete macʉno jiha. Sete Adão macʉno jiha. Adão Cohamacʉ to yoariro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu Espíritu Santo to dutiriro seheta yoa pahñoriro jiro, tiro Jordão wama tiri mapʉ jiriro tjuaa wahaha. To ã tjuaa wahachʉ Espíritu Santo sehe tirore masa marienopʉ naaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tópʉ sʉro cuarenta dachori waro jiha. Tópʉ to jiro wato watĩno sehe Jesure ñaare yoachʉ cahmamaha. Ã jiro ñaare yoa dutimaha tirore. Tí dachorire Jesu chʉeraha. Ã jiro tí dachori pihtichʉ waro tiro jʉca baaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","To ã jʉca baachʉ ñʉno watĩno õ sehe nimaha Jesure: —Mʉhʉ Cohamacʉ macʉno jicʉ, ahria tãcare chʉa dojomehnega —nimaha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu õ sehe ni yʉhtiha: —Yoaeraja. Cohamacʉ yare ti joari pũi õ sehe nina: “Masare chʉa mehne dihta catieraro cahmana. Jipihtia Cohamacʉ ya yahua mehne jiro cahmana”, nina Cohamacʉ —ni yʉhtiha Jesu watĩnore. ");
INSERT INTO gvc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","To ã niri baharo watĩno sehe tirore tʉ̃cʉ mʉadʉ buipʉ na mʉja sʉrota jipihtia macari perire ño bahrañoha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ã ñono Jesure õ sehe ni yahuha: —Jipihtia ahri macari yʉhʉre to wari cjiri jira. Ã jicʉ yʉ cahmarirore wa masija. Ã jicʉ ahri macarine, ti cjʉaa mehne mʉhʉre waihtja. (Yʉ ã wachʉ ahri macari macainare mʉhʉ dutiihca.) ");
INSERT INTO gvc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yʉhʉre mʉ ño payochʉ ahri macari jipihtia macarine mʉhʉre waihtja —niha watĩno Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu õ sehe ni yʉhtiha tirore: —Mʉhʉre ño payoeraja. Õ sehe nina Cohamacʉ yare ti joari pũi: “Mʉ pʉhtoro Cohamacʉ dihtare ño payoga. To ya dutia dihtare yoaga”, ni joaa tiha Cohamacʉ yare —niha Jesu watĩnore. ");
INSERT INTO gvc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","To ã niri baharo Jerusalẽpʉ watĩno sehe tirore na wahcã, Cohamacʉ wʉhʉ bui na sʉha tirore. Na sʉ tuhsʉ tirore õ sehe nimaha: —Cohamacʉ yare ti joari pũ õ sehe nina: “Cohamacʉ yaina anjoare mʉhʉre ñʉ wihbo dutirohca. Ã jia tina sehe mʉhʉre ñʉ wihboahca, ‘Mʉhʉpʉ tãcapʉ pʉha tu mʉari’ nia”, ni joaa tiha Cohamacʉ yare ti joari pũi. To ã niri quihõno jichʉ mʉhʉ Cohamacʉ macʉno jicʉ, yahpapʉ pju bora ño ñʉjʉta yʉhʉre. Mʉhʉre yoadohochʉ ño ñʉjʉta yʉhʉre —niha watĩno Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu pju bora ño duaeraro õ sehe ni yʉhtiha tirore: —Cohamacʉ yare ti joari pũi õ sehe nina: “Mʉsa pʉhtoro Cohamacʉ to niri cjirire ‘¿Potocã tjijari?’ ni masi duana, Cohamacʉre yoa ño duti macaena tjiga”, nina Cohamacʉ yare ti joari pũi —niha Jesu watĩnore. ");
INSERT INTO gvc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ã jiro watĩno jipihtia ñaare Jesure yoa dutimaha. Ã duti tuhsʉro mahanocã duhu wahcãsiniha. ");
INSERT INTO gvc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Baharo Jesu Galileapʉ tjuaa wahaha. Ã jiro, tiro Espíritu Santo tuaa mehne yoaha. Tói jipihtiropʉ masa tirore quiti tiha. ");
INSERT INTO gvc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judio masa buhea wʉhʉsei tiro buhea tiha. Ã jia jipihtina masa tirore noano durucuha. ");
INSERT INTO gvc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Baharo Nazarepʉ Jesu to bʉcʉariropʉta tju sʉha. Tópʉ tju sʉro, Sabado jichʉ to ã yoarucuriro seheta tiro judio masa ti buheri wʉhʉpʉ sãa sʉha. Tói tiro Cohamacʉ yare ti joari pũre buhero taro ducuha. To ã ducuchʉ ñʉa tó macaina sehe Cohamacʉ yare yahu mʉhtariro Isaia cjiro to joari pũre tirore waha. Tí pũi Jesu ahri yahuare bocaro buheha: ");
INSERT INTO gvc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Cohamacʉ to Espíritu yʉhʉ mehne jiro, yʉhʉre dutira. Tiro pjacʉoinare noaa buheare yahu dutiro warocare yʉhʉre. Ã yoa peresupʉ jiina cʉ̃hʉre tinare to yʉhdohtore yahu dutiro warocare yʉhʉre. Capari ñʉeraina ti noano ñʉhto cjihtore, painare ti ñano ti yoapeinare wiohtiro cjihtore yʉhʉre warocare. ");
INSERT INTO gvc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mari pʉhtoro Cohamacʉ to yainare pichacapʉ wahaborinare to yʉhdohtore yʉhʉre yahu dutiro warocare”, ni buheha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ã ni buhe tuhsʉ Jesu ti pũre noari tia turẽnoca, wʉhʉ macarirore wia tuhsʉ, dujiha. To dujichʉ ñʉa tói jiina jipihtina tiro dihtare ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ti ã yoachʉ tiro tinare õ sehe ni yahu dʉcaha: —Ahri michapucacã yʉ buheriro seheta Cohamacʉ to niriro mʉ sʉro nina —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","To ã nichʉ tʉhoa “Ahriro noariro jira”, ni tʉhotuha tina. Ã jia tina to noano buhechʉ tʉhoa, cʉaa wahaha. Ã cʉaa waha, õ sehe niha tina ti basi: —Cuenah, ¿José macʉno jierajari ahriro? —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ti ã nichʉ masino Jesu õ sehe ni yahuha tinare: —Yʉ buheare tʉho duaerana, õ sehe ni tʉhotura mʉsa yʉhʉre: “Duhturu dohatiro to basi co ti masina duhturu waro to jiare ñono. Mʉhʉ cʉ̃hʉ duhturu to yoa ñono seheta mʉ niriro sehe jiriro jicʉ Cohamacʉ tuaa mehne yoa ñoga sãre. Capernaupʉre Cohamacʉ tuaa mehne yoa ñoyuhti mʉhʉ. Sã cʉ̃hʉre ã yoa ñoga, mʉ buheare ‘Potocã tjira’, sã ni masihto sehe”, ni duara mʉsa yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","’Ahrire yahuihtja mʉsare. Cohamacʉ yare yahu mʉhtarirore to ya maca macaina cahmaerara. Ã jina yʉhʉre cahmaerara mʉsa õi yʉ bʉcʉariro jichʉ. ");
INSERT INTO gvc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yʉhʉre tʉhoga mipʉre. Panopʉ Elia to jiri pjapʉre tia cʉhma noano pa cʉhma dacho maca waroi ne coro taeraha. Ã jiro jipihtiropʉta ne chʉa mariaha. Tí pjare payʉ wapewahya Israe yahpapʉ ti jipachʉta Cohamacʉ Elia cjirore tinare yoadoho dutiro warocaeraha. (Eliare, Cohamacʉ ya cʉ̃hʉre ti cahmaerachʉ ñʉno tinare yoadoho dutiro warocaeraha.) ");
INSERT INTO gvc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","To ya macare ã yoa dutieraparota pa yahpai Sidõ cahai jiri macai Sarepta wama tiri maca macaricoro wapewahyorore yoadoho dutiro Elia cjirore warocaha Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Baharo Cohamacʉ yare yahu mʉhtariro Eliseo cjiro to jiri pjapʉre Israe yahpapʉ payʉ cami baina ti jipachʉta cʉ̃iro Israe masʉnore ne noariro wahachʉ yoaeraha Eliseo cjiro. To ya yahpa macainare yoaeraparota Naaman wama tirirore Siria yahpa macariro dihtare noariro wahachʉ yoaha tiro. Ã yoaro Israe masare yoadohoeraro, Israe masʉno jierariro sehere yoadohoha Cohamacʉ —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","To ã nichʉ tʉhoa jipihtina tí wʉhʉi jiina sua yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ã jia tina wahcãrʉca, Jesure na wijaa, tí maca dʉhtʉ cahai jiri cʉnʉpʉ tirore tjuroca boro duamaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ti ã yoa duapachʉta Jesu ti watoihta wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Baharo Jesu Galilea yahpai jiri macapʉ Capernau wama tiri macapʉ sʉ, Sabado jichʉ masare buheha. ");
INSERT INTO gvc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tiro noano masi pahñoriro to buhechʉ tʉhoa masa tʉho cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tí wʉhʉi watĩno to cohtotariro jiro, õ sehe ni tuaro sañurucuha: ");
INSERT INTO gvc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Mʉhʉ Jesu Nazare macariro sãre cariboi tjia mʉhʉ. ¿Dohse yoai tai nijari sãre? ¿Mʉhʉ sãre butichʉ yoai tai nijari? Yʉhʉ masija Cohamacʉ macʉno, ñaa marieriro mʉ jiare —ni sañurucuha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","To ã nichʉ tʉhoro Jesu tuhtiha watĩnore: —Dihta mariahga. Wijaahga tirore —niha Jesu. To ã niri baharo masʉnore watĩno sehe yahpapʉ doca caha sʉ tunuchʉ yoaro, tirore wijaaha. To ã yoari baharo tiro sehe noariro tjuaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tói jiina jipihtina to ã wahachʉ ñʉ cʉaa wahaha. Ã jia ti basi õ sehe ni durucuha: —¿Yaba baro buhea jijari ahri ã wahachʉ yoaa? Cuenah. Tuaro mehne pʉhtoro yoaro seheta ahriro watĩare dutira. Ã jia to dutiro seheta tina masare wijaara —ni durucuha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","To ã yoachʉ ñʉa tí yahpapʉ jipihtiropʉ masa Jesu yoarire yahu siteha. ");
INSERT INTO gvc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Judio masa ti buheri wʉhʉre wijaa, Simo ya wʉhʉpʉ sãa sʉha Jesu. Tói Simo marechono dohati, tuaro juaro tiha. Ã jia tina ticoro to dohatichʉ yahuha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ti ã yahuri baharo tiro ticoro cahai sʉ, juarore suru dutiha. To ã suru dutiri baharo ticorore juaro surua waha, dóihta noaricoro wahaha. Ticoro ã waharo wahcã nuju sʉ, tinare chʉare payoha. ");
INSERT INTO gvc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sʉ̃ sãari baharo jipihtina masa tó cahai jiina dohatiinare Jesu cahapʉ na sʉha. Dohatiina payʉ soro jia dohatiare cjʉaha. Ã jiro Jesu to wamomacari mehne tina bui ña payo, jipihtinare ti dohatiare noano yʉhdʉchʉ yoaha. ");
INSERT INTO gvc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Watĩa cʉ̃hʉre Jesu to wijaa dutichʉ tina wijaa wahaa, õ sehe ni sañurucuha: —Mʉhʉ potocãta Cohamacʉ macʉno jira —niha tina Jesure. Jesu Cohamacʉ warocariro to Cristo to jichʉ watĩa masiha. Ã jiro Jesu tinare durucu dutieraha, “ ‘Cristo jira’, ni yahu siteri”, nino. ");
INSERT INTO gvc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bohrea mʉja tachʉ Jesu tí macai jiriro waha, masa marienopʉ sʉha. To ã sʉri baharo masa tirore maca, boca sʉa õ sehe niha: —Sã ya macai tjuaga. Wahai tjiga —nimaha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ti ã nipachʉta tiro sehe õ sehe ni yʉhtiha: —Cohamacʉ masare pʉhtoro to noano sʉho jiare noaa buheare paye macaripʉ cʉ̃hʉre buhero cahmana yʉhʉre. Cohamacʉ yʉhʉre warocare tíre yahuhtirore —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ã ni tuhsʉro judio masa ya yahpa macaa wʉhʉsei, judio masa ti buhea wʉhʉsei tiro buhe tiniha. ");
INSERT INTO gvc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pa nʉmʉ Jesu Genesare wama tiri bʉcʉpariro dʉhtʉ cahapʉ sʉha. Tói to jichʉ ñʉa payʉ masa Cohamacʉ yare tʉho duaa tirore nʉnʉ ti sʉha. Noano wahpa tarʉcʉ sʉha masa peri. ");
INSERT INTO gvc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pʉaria bʉso padʉroi pahsaa bʉsore Jesu ñʉha. Tí bʉso macaina wahi wajãina maja sʉrʉca, ti wañʉyucʉrire cosaa niha. ");
INSERT INTO gvc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ã jiro Jesu Simo yariapʉ samua wahaha. Samu tuhsʉ tia dohoriare dia dʉhtʉ cahai coãriare siõ buhu dutiha. Tuhsʉ, dohoriapʉ duji, masare buheha. ");
INSERT INTO gvc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Buhe tuhsʉ, Jesu Simore õ sehe niha: —Dacho maca cureroi siõ wioga. Ã jina mʉhʉ mehne macaina mehne mʉsa wañʉyucʉre doca ñoga wahi ñahana —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","To ã nichʉ tʉhoro Simo Jesure õ sehe ni yʉhtiha: —Pʉhtoro, wahi maca bohreamahi sã micha ñamine. Bohreapanahta ne cʉ̃irocã wajãerahti sã. Ã wajãerapanahta mʉ dutiro seheta doca ño ñʉnahtja —ni yʉhtiha Simo. ");
INSERT INTO gvc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ã ni tuhsʉ tina doca ñoha. Ã ti doca ñochʉ ti wañʉyucʉre payʉ wahi sãaha. Payʉ ti sãachʉ wañʉyucʉ tʉhnʉa wahamaha. ");
INSERT INTO gvc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ã wahachʉ ñʉa tina paria macainare tina mehne macainare pjirocaha: —Mʉsa cʉ̃hʉ yoadohona tagã sãre —ni pjirocaha Simo cʉ̃hʉ. Tina ti ã yoadohori baharo pʉria bʉso noano minipahro bocaha wahire. ");
INSERT INTO gvc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simo Pedro ã wahi payʉ ti sãachʉ ñʉno, Jesu panoi na tuhcua caha sʉ, tirore õ sehe ni yahuha: —Yʉ pʉhtoro, mʉhʉ mehne jiboriro jieraja yʉhʉ. Ñariro jija yʉhʉ. Ã jicʉ mʉ cahai ji masieraja —niha Simo Pedro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tiro, jipihtina tiro mehne macaina cʉ̃hʉ payʉ wahi sãachʉ ñʉa, cʉaa wahaha tina cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pʉaro Simo Pedro mehne macaina Zebedeo pohna Santiago to bahʉro João mehne, tina cʉ̃hʉ ñʉ cʉaa wahaha. Ti ã cʉachʉ ñʉno Jesu Pedrore õ sehe ni yahuha: —Cʉaecʉ tjiga. Mipʉre mʉhʉ wahire ñaha cahmachuriro mʉ jiro seheta Cohamacʉ yaina cjihtire pji cahmachuriro jiihca mʉhʉ —niha Jesu Simo Pedrore. ");
INSERT INTO gvc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","To ã niri baharo tina ti bʉsore bʉcʉpariro dʉhtʉ cahapʉ waja mo cũnoca, ti ya jipihtiare tóihta cũnoca, Jesu mehne wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ã yoa Jesu pa macai to jichʉ cami bariro tirore piti bocaha. Ã piti bocaro tiro Jesure ñʉ, na tuhcua caha sʉ, õ sehe ni tuaro siniha: —Pʉhtoro, mʉhʉ yoa duacʉ yʉhʉre noariro yoa masina mʉhʉ —ni siniha. ");
INSERT INTO gvc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","To ã niri baharo Jesu tirore ña payoro õ sehe niha: —Tíre yoa duaja. Mipʉre noariro jiga mʉhʉ —niha. To ã nichʉta to cami bari cjiri yati mʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ã jiro Jesu tirore õ sehe ni dutiha: —Ahri yʉ õ sehe yoarire painare yahui tjiga. Sacerdote cahai wahaga mipʉre. Ã jicʉ mʉ pjacʉre noari pjacʉ to waharire ñoga tirore. Cohamacʉ dutia Moisere to cũri to niriro seheta yoaga. Ã yoacʉ sacerdotere pʉaro minichahcare waga noariro mʉ waharire sacerdoteare ñoi tai —niha cami bariro cjirore. ");
INSERT INTO gvc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","“Yahui tjia”, to nipachʉta jipihtiropʉ masa tirore yahu site namoha. Ti ã yahu sitechʉ tʉhoa masa payʉ tiro cahapʉ sʉha. Dohatiina noaina waha duaa, tina cʉ̃hʉ tiro cahapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ti ã sʉpachʉta Jesu masa marienopʉ Cohamacʉre sinino wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pa dachoi Jesu to buhechʉ fariseo curua macaina, judio masare buheina cʉ̃hʉ tói dujiha. Tina jipihtina Galilea yahpai jia macari macaina, Judea yahpai jia macari macaina, Jerusalẽ macaina jiha. Ti ã jichʉ ñʉno Jesu Cohamacʉ tuaa mehne dohatiinare noaina wahachʉ yoaha. ");
INSERT INTO gvc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mahainacã mʉa pjacʉ bʉharirore to coãri cahsaro mehne yo wʉa wihiha. Ã jia tirore Jesu cahai cũ duaa, wʉhʉpʉ yo sãa duamaha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ã sãa duapahta masa payʉ jichʉ tina tirore yo sãa masieraha. Ã jia tirore wʉhʉ buipʉ yo mʉjaha. Yo mʉja sʉ, mahanocã muji pahmare nawe, tí copai pjacʉ bʉharirore to coãri cahsaro mehneta duhu boroha Jesu cahai jiina watoi. ");
INSERT INTO gvc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","“Jesu ahrirore to dohatiare yʉhdʉchʉ yoarohca”, ni tʉhotuha tina. Ti ã ni tʉhotuchʉ masino Jesu pjacʉ bʉharirore õ sehe ni yahuha: —Coyeiro, mʉ ñaare yoari buhiri tiare yʉhʉ cohã tuhsʉja —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","To ã nichʉ tʉhoa fariseo curua macaina, judio masare buheina cʉ̃hʉ ti basi õ sehe ni tʉhotumaha: “Ahriro ã ni durucuero tjijaro. Tiro masʉno mari yoaro sehe jiro, ñaare to yoari buhiri tiare cohã masierara. Cohamacʉ dihta masa ti ñaare yoari buhiri tiare cohã masina”, ni tʉhotumaha tina. ");
INSERT INTO gvc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu ti ã ni tʉhotuare masino, õ sehe niha: —¿Dohse yoana ã ni tʉhotujari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Mʉ ñaa yoari buhiri tiare yʉhʉ cohã tuhsʉja”, yʉ nichʉ, “Mahñoriro jira”, yʉhʉre nina mʉsa noano masierapanahta. “Wahcãrʉca wahaga”, yʉ nichʉ yʉ niri potocã jia jichʉ dóihta masinahca. ");
INSERT INTO gvc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yʉhʉ masʉno Cohamacʉ warocariro ahri yahpai ti ñaare yoari buhiri tiare cohã masija yʉhʉ. Masa ti ñaare yoari buhiri tiare cohãhtiro cjihtore cũre Cohamacʉ yʉhʉre. Yʉ ã cohãrine mʉsa masihto sehe õ seheta yoa ñoihtja mʉsa ñʉhti cjihtire —niha Jesu. Ã ni tuhsʉ pjacʉ bʉharirore õ sehe niha: —Mʉhʉre niita nija. Wahcãrʉcaga. Mʉ coãri cahsarore na wahcãga mʉ ya wʉhʉpʉ —niha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","To ã nichʉ tʉhorota jipihtina ti ñʉrocaroi wahcãrʉca, to coãri cahsarore na, to ya wʉhʉpʉ tjuaa wahaha. Ã waharo tiro Cohamacʉre ño payoro, wahchea mehne noano durucuha. ");
INSERT INTO gvc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","To ã yoachʉ ñʉa masa sehe jipihtina cʉaa wahaha. Tina cʉaa waha, Cohamacʉre ño payoa, wahchea mehne noano durucuha: —Michare soro jiare ñʉhi sã —niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ã yoa tuhsʉ waha, Leví wama tirirore to dahrari tahtiapʉ jirirore boca sʉha Jesu. Leví sehe pʉhtoa ya cjihtire masare wapa na cohtariro jiha. Ã boca sʉro tirore õ sehe niha: —Yʉhʉ mehne macariro cjihto taga mʉhʉ —niha tiro Levíre. ");
INSERT INTO gvc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","To ã nichʉ Leví sehe jipihtia to dahraare duhunoca, Jesu mehne wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Baharo Leví ya wʉhʉi bose nʉmʉ Jesure yoa payoro niha. Tói payʉ wapa na cohtaina, paina cʉ̃hʉ Leví mehne dujiha. ");
INSERT INTO gvc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tina mehne Jesu cʉ̃hʉ ti dujichʉ ñʉa mahainacã fariseo curua macaina, judio masare buheina mehne sua, Jesu buheinare õ sehe ni sinitu ñʉha: —¿Dohseana ñano yoaina, wapa na cohtaina mehne chʉjari mʉsa? —ni tuhtiha tina. ");
INSERT INTO gvc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ti ã nichʉ tʉhoro Jesu yʉhtiha tinare. Õ sehe ni piti dahre buheha: —Dohatieraina duhturure macaerara. Dohatiina dihta duhturure macana. Ñaare yoaina dohatiina yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ã jicʉ ñaare yoainare yahui tai nihi yʉhʉ Cohamacʉre cahma duticʉ. Ti basi “Noaina jija sã”, ni tʉhotuinare yahui tai nierahi yʉhʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ã yoa mahainacã masa Jesure õ sehe ni sinitu ñʉha: —João buheina payʉ tahari Cohamacʉre ño payoa taa chʉ duhura. Ã yoaa, tina payʉ tahari Cohamacʉre sinina. Fariseo buheina cʉ̃hʉ ti yoaro seheta yoara. Ti ã yoapachʉta mʉ buheina sehe Cohamacʉre ño payoa taa chʉ duhuerara. ¿Dohse yoa ã yoaerajari tina? —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ti ã nichʉ Jesu to tʉhotua mehne quiti dahre buhero taro tinare õ sehe ni yʉhtiha: —Õ sehe jira ti: Wamomaca dʉhteropʉ ti pjirocaina wamomaca dʉhteriro mehne jia, chʉ duhu masierara. Tó seheta yʉ buheina cʉ̃hʉ yʉhʉ mehne jia, chʉ duhu masierara. Yʉhʉ wamomaca dʉhteriro yoaro sehe jija. Wamomaca dʉhteriro bose nʉmʉ to yoachʉ tiro mehne macaina chʉeraina jierara. ");
INSERT INTO gvc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yʉ Pʉcʉ Cohamacʉ yʉhʉre to naari baharo pinihtare yʉ buheina mehne jisi yʉhʉ. Ã jia tí pjapʉta yʉ buheina cʉ̃hʉ chʉ duhuahca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Panopʉ macaa buhea wahma buhea mehne ti buhe more duachʉ ñʉno õ sehe ni namoha Jesu tinare piti dahre buhero: —Ne wahma suhtirore mahari cahsarocã tʉhrẽ na, mʉnano suhtirore sere õno cahmaerara. Mari ã sere õna wahma cahsarore tʉhrẽ cohãna nija. Ã yoa wahma cahsaro mʉnano suhtiro mehne cʉ̃no potori bajuerara. (Tó seheta mʉna buhea wahma buhea mehne piti dahre buheraro cahmana.) ");
INSERT INTO gvc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","’Ã yoa ne se co bisia core wahiquiro cahsaro wajuru mehne mʉna wajuru mehne posaeraro cahmana. Mari ã yoachʉ se co bisia pahmoapʉ mʉna wajurure tʉhrẽnocahna. To tʉhnʉchʉ se co cʉ̃hʉ, wajuru cʉ̃hʉ cohõa wahara. ");
INSERT INTO gvc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ã yoa se co wahma core wahma wajurupʉ posaro cahmana. Mari ã yoachʉ se co cohõera, wajuru cʉ̃hʉ cohõerara. (Tó seheta wahma buhea mʉna buhea mehne buhe moreraro cahmana.) ");
INSERT INTO gvc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mʉna core masa ti sihniri baharo, wahma core cahmaerara tina. Õ sehe nia tire masa: “Mʉna co wahma co bui curero noaa jira”, nia tire masa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa dacho Sabado jichʉ Jesu cʉ̃hʉ trigo wesepʉ sʉha. Tópʉ sʉ, to buheina sehe trigo parorire paha, tí pohcarire sahcã site boro, tí yaparire chʉ wahcãa niha. ");
INSERT INTO gvc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ti ã yoachʉ ñʉa mahainacã fariseo curua macaina tinare õ sehe ni sinituha: —¿Dohse yoana mʉsa Sabado mari sori nʉmʉ to jipachʉta dahrajari? Marine dutiare yʉhdʉrʉcana nina mʉsa —niha fariseo curua macaina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Ti ã nichʉ tʉhoro Jesu tinare yʉhtiha, (“Yʉ buheina yʉhdʉrʉcaa nierara”), nino taro: —Davi cjiro tiro mehne macaina mehne jʉca baaro, Cohamacʉ wʉhʉpʉ sãa, Cohamacʉ ya pãore chʉha. Ã chʉro tó mehne macaina cʉ̃hʉre tí pãore chʉ dutiro waha. Tí pãore sacerdotea dihtare chʉ dutira. Cohamacʉ dutia tí pãore painare chʉ dutierara. ¿Davi cjiro tíre to yoari cjirire buherari mʉsa? (Tí pãore chʉro Cohamacʉre yʉhdʉrʉcaro nieraha. Michare ahri yaparire chʉa yʉ buheina cʉ̃hʉ Cohamacʉre yʉhdʉrʉcaa nierara.) ");
INSERT INTO gvc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yʉhʉ masʉno Cohamacʉ warocariro ahri dacho Sabado dachore masa ti yoahtire yahurirota jicʉ pʉhtorota jija —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa dacho Sabado jichʉ Jesu judio masa ti buheri wʉhʉpʉ sãa sʉro, buheha masare. Tói wamomaca poto bʉhʉsehe bʉhariro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mahainacã judio masare buheina, fariseo curua macaina cʉ̃hʉ Jesure yahusã duamaha. “Sabado dachoi masʉnore noariro wahachʉ yoaboca Jesu” ni, ñʉ nʉnʉ yahusã duamaha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesu ti tʉhotuare masino, bʉharirore õ sehe niha: —Wahcã sʉrʉcaga jipihtina ti ñʉrocaroi —niha tirore. To ã niri baharo bʉhariro sehe wahcãrʉcʉ sʉ, tói ducuha. ");
INSERT INTO gvc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ã jiro Jesu tinare õ sehe ni sinituha: —Mʉsare sinituihtja: ¿Sabado jichʉ yabare yoa dutijari Cohamacʉ dutia? ¿Noaare yoachʉ noaerajari? ¿O ñaare yoachʉ sehere noajari, mʉsa tʉhotuchʉ? Sabado jichʉ masʉnore masochʉ noa nina. Sabado jichʉ masʉnore wajãchʉ sehere noaerara —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ã nino Jesu tinare ñʉroca õ pahño, bʉharirore õ sehe niha tjoa: —Mʉ wamomacare siõrocahga —niha tiro. To ã nichʉta bʉhariro sehe siõroca, noari wamomaca wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","To ã yoachʉ ñʉa tina Jesu mehne tuaro suaha. Ã suaa õ sehe niha: —¿Dohse yoanahcari mari ahrirore? —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tí dachorire Jesu tʉ̃cʉpʉ Cohamacʉre sinino mʉjaa wahaha. Tópʉ jiro, ñamine Cohamacʉ mehne durucu bohreaha. ");
INSERT INTO gvc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bohrearopʉ to buheinare to cahapʉ pjirocaha. Pjiroca tuhsʉ, tina mehne macainare doce waro to warocahtinare bese dapoha. ");
INSERT INTO gvc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Ahrina jiha Jesu to bese daporina: Simo jiha. Simore Pedro ni pisuha Jesu sehe. Simo bahʉro Andre, Santiago, João, Felipe, Bartolomé, Mateo, Toma, Santiago jiha. Santiago sehe Alfeo macʉno jiha. Ã jia Simo cananista ya curua macariro cjiro, ");
INSERT INTO gvc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda Santiago macʉno, Juda Iscariote tina jiha to bese daporina. Juda Iscariote sehe Jesure ñʉ tuhtiinare ñohtiro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ã yoa Jesu to buheina mehne tʉ̃cʉ buipʉ jirina duji taa, payʉ paina to buheina mehne duji wihirʉca, noari wapai ducuha tina. Jipihtiro Judea yahpa macari macaina, Jerusalẽ macaina, Tiro wama tiri maca macaina, Sidõ wama tiri maca macaina, pjiri ma dʉhtʉ cahai jia macari macaina masa payʉ tiro cahapʉ wihiha. ");
INSERT INTO gvc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tina Jesu buheare tʉhoa taa, ti dohatiare cohãchʉ cahmaha tina. Watĩa ti cohtotarina cʉ̃hʉ tiro cahapʉ wihi, noaina wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesu to tuaa mehne noaina wahachʉ yoaha tinare. Ã jia tina jipihtina tirore dahra ñʉa taha. ");
INSERT INTO gvc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Baharo Jesu to buheinare ñʉ, õ sehe ni yahuha: —Mʉsa pjacʉoina, pʉhtoro Cohamacʉ to sʉho jiropʉ wahanahca mʉsa. Ã jina mʉsa wahchenahca. ");
INSERT INTO gvc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Mipʉre mʉsa jʉca baaina yapiina jinahca. Ã jina wahchenahca. ’Mipʉ tiina jina, baharo mʉsa bʉjʉnahca. Ã yoa mʉsa wahchenahca. ");
INSERT INTO gvc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Yʉhʉ masʉno Cohamacʉ to warocariro jija. Ã jina yʉ yare yoaina mʉsa jiri buhiri paina mʉsare ti ñʉ tuhtipachʉta wahcheina jira mʉsa. Mʉsare ti cohãpachʉta wahchenahca. Mʉsare ti ñano durucupachʉta “Ñaina jira”, mʉsare ti nipachʉta mʉsa sehe wahchenahca. ");
INSERT INTO gvc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mʉsare ti ã yoachʉ ñʉno mʉanopʉ mʉsa sʉchʉ pjíro noano yoarohca Cohamacʉ mʉsare. Ã jina tuaro wahcheina jiga. Noano yajeripohna tiina jiga. Mʉsare ñʉ tuhtiina ti coyea panopʉ macaina tó seheta ñano yoaha Cohamacʉ yare yahu mʉhtaina cjiri cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ã yoa mʉsa mipʉ payʉ cjʉaina ahri yahpapʉ mʉsa noano jinoca tuhsʉre. Ã jina ñano yʉhdʉina jinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Mipʉ yapiina mʉsa jʉca banahca. Mʉsa ã jina ñano yʉhdʉnahca. ’Mipʉre mʉsa bʉjʉina jina baharopʉ mʉsa cahya, tiinahca. Ã jina mʉsa ñano yʉhdʉnahca. ");
INSERT INTO gvc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’“Cohamacʉ yare yahu mʉhtaina jija”, ni mahñoinare “Noaina jira”, nimaha payʉ panopʉ macaina. Ã nimarina ti coyea mipʉ macaina cʉ̃hʉ ãta “Noaina jira”, niboca cãina mʉsa mehne macainare. Ti ã nimarina mʉsa jina ñano yʉhdʉnahca mʉsa cʉ̃hʉ —ni buheha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ã yoa õ sehe ni buhe namoha Jesu: —Yʉhʉre tʉho duainare, mʉsareta nii nija. Mʉsare ñʉ tuhtiina ti jipachʉta tina cʉ̃hʉre cahĩga. Mʉsare ñʉ tuhtiinare noano yoaga. ");
INSERT INTO gvc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mʉsare “Ñano yʉhdʉjaro”, niina ti jipachʉta noa dutiga tinare. Mʉsare ñano yoaina ti jipachʉta “Tina cʉ̃hʉ noano jijaro”, ni sini payoga Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Cʉ̃iro mʉsa wahsupure to cjãchʉ, pa bʉhʉsehe cʉ̃hʉre cjã dutiga tirore. Mʉsa bui macari suhtirore to machʉ mʉsa camisa cʉ̃hʉre ã wanocahga tirore. ");
INSERT INTO gvc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mʉsare sinirirore to sinino purota waga tirore. Mʉsa yare to nachʉ tirore sinituena tjia pari turi tíre. ");
INSERT INTO gvc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Paina mʉsare ti noano yoachʉ cahmana mʉsa. Tinare mʉsa noano yoachʉ cahmano seheta mʉsa cʉ̃hʉ noano yoaga tinare. Mʉsare ti noano yoaerapachʉta mʉsa sehe tinare noano yoaga. ");
INSERT INTO gvc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mʉsare cahĩina dihtare mʉsa cahĩchʉ tí ne yaba cjihti jierara paina sehere mʉsa cahĩerachʉ. Ñaina cʉ̃hʉ tinare cahĩina dihtare cahĩna. ");
INSERT INTO gvc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ã jina mʉsare noano yoaina dihtare mʉsa noano yoachʉ tí cʉ̃hʉ ne yaba cjihti jierara paina sehere mʉsa noano yoaerachʉ. Tíre ñaina cʉ̃hʉ yoaa tire. ");
INSERT INTO gvc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ã yoa “Yʉhʉre wiaa tire”, mʉsa niina dihtare mʉsa wasochʉ ne tí yaba cjihti jierara. Ñaina cʉ̃hʉ painare “Yʉhʉre wiaa tire”, ti niinare wasoa tire. ");
INSERT INTO gvc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ã jina mʉsa sehe mʉsare ñʉ tuhtiina cʉ̃hʉre cahĩga. Ã yoa, tinare noano yoaga. Pairore wasona “Yʉhʉre ne wiasi ahriro”, ni tʉhotuenata tirore wasoga. Cohamacʉ sehe tirore ji coaeraina cʉ̃hʉre, ñaina cʉ̃hʉre noano yoara. To yoaro seheta yoaga mʉsa cʉ̃hʉ. Mʉsa ã yoachʉ Cohamacʉ pjíro noano yoarohca mʉsare. Mʉsa ã yoana Cohamacʉ tua yʉhdʉariro mʉano macariro pohna jinahca. ");
INSERT INTO gvc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mari Pʉcʉ mʉano macariro to pja ñʉriro seheta mʉsa cʉ̃hʉ masare pja ñʉga —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ã yoa tinare õ sehe ni yahu namoha: —Painare “Ñaina jira”, niena tjiga mʉsa. Mʉsa ã nierachʉ Cohamacʉ mʉsa cʉ̃hʉre “Ñaina jira”, nisi. Paina mʉsare ti ñano yoarire ti ñano niri cʉ̃hʉre boga mʉsa. Mʉsa ã bochʉ ñʉno Cohamacʉ mʉsa cʉ̃hʉre mʉsa ñaa yoari buhirire borohca. ");
INSERT INTO gvc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Paye barore cjʉana painare waga. Mʉsa ã wachʉ Cohamacʉ mʉsare warohca. Ã waro noano quihõno mʉsare pjíro warohca. Wahpa yʉhdʉaro warohca. Painare mʉsa wariro purota Cohamacʉ mʉsa cʉ̃hʉre warohca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ã ni tuhsʉ Jesu quiti mehne piti dahre buhero õ sehe ni yahu namoha: —Capari ñʉeraina sahsero ti basi noano tʉã wahcã masierara. Ã tʉã wahcãa, tina pʉaro doca wahã sʉ bora sãa wahaahca copapʉ. (Tó seheta Cohamacʉ yare masieraina painare buhe masierara. Ã jia tina jipihtina pichacapʉ wahaahca.) ");
INSERT INTO gvc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Buheina tinare buherirore masi yʉhdʉrʉcaerara. Ã jipahta jipihtina buheina ti noano buhe pahñori baharo tinare buheriro yoaro seheta jiahca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ã ni tuhsʉ paye quiti mehne yahu namoha: —Mari piti dahre buhechʉ õ sehe yoaina jira mʉsa: Mʉsa coyeiro to capariacapʉ mahari pohcarocã to sãachʉ tí pohcarocãre noano ñʉna mʉsa. Mʉsa ya capariacare pjiri pjĩ to jipachʉta tí pjĩne ne ñʉerara mʉsa. (Mahari pohcarocãre mʉsa ñʉno seheta mʉsa coyeiro to ñano yoaa sehere noano ñʉna mʉsa. Mʉsa basi mʉsa ñaare tuaro yoapanahta tíre masierara mʉsa pjiri pjĩne mʉsa ñʉeraro seheta.) ¿Dohse jiro baro ã jijari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Õ sehe niina yoaro sehe jira mʉsa: “Coyeiro, mʉhʉ ñaare yoai nica mʉhʉ. Ã jicʉ tíre duhuga”, niina yoaro sehe jira mʉsa. Ã niina jipanahta pjíro ñaare yoara mʉsa sehe. ¿Dohseana mʉsa ñaare yoapanahta tíre masierajari mʉsa? Masa ti baharo bʉhʉsehei ñano yoa cohtaina jira mʉsa ã yoaina. Pjiri pjĩne mʉsa capariacai jiri pjĩne mʉsa na mʉhtaboriro seheta mʉsa ñaa yoaa sehere duhu mʉhtaga. Mʉsa ã yoari baharo mʉsa coyeiro to ñano yoaare duhuchʉ yoa masiboca mahari pohcarocãre mʉsa naboro seheta —ni buheha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ã yoa piti dahre buhero õ sehe ni yahu namoha tinare: —Noadʉ yucʉcʉ ñaare dicha tierara. Ã yoa ñadʉ noaare dicha tierara. ");
INSERT INTO gvc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yucʉcʉ dichare masina tʉre masina. Pota tidʉ higuera pocare dicha tierara. Ã yoa agã potacʉ se tõhorine dicha tierara. ");
INSERT INTO gvc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tó seheta jira masa cʉ̃hʉ. Noariro to tʉhotuapʉ noaa jira. Ã jiro tiro noaare yoara noadʉ to noano dicha tiro seheta. Ñariro to tʉhotuapʉ ñaa jira. Ã jiro tiro ñaare yoara ñadʉ ñaare to dicha tiro seheta. Mari tʉhotuapʉ marine ti jiro seheta durucuja mari —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ã yoa tinare õ sehe ni yahu namoha: —Mʉsa yʉhʉre “Pʉhtoro”, nina. Ã nipanahta yʉ dutia sehere yoaerara mʉsa. ¿Dohse jiro baro ã yoajari? ");
INSERT INTO gvc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Jipihtina yʉhʉre cahmaina yʉ yahuare tʉhora. Ã jia yʉ dutiare yʉhdʉrʉcaerara. Õ seheta jira yʉhʉre yʉhdʉrʉcaeraina: ");
INSERT INTO gvc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wʉhʉ dahreriro yoaro sehe jira tina. Tiro cʉãa coparire tãa wapai to sʉchʉpʉ saha, wʉhʉre noano dapo dʉcaha. Tí wʉhʉ noano to yoari wʉhʉ jiro dia to minichʉ tuaro to cotiãpachʉta tí wʉhʉ noano tjuaha. ");
INSERT INTO gvc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ã jia yʉ dutiare tʉhopahta yʉhdʉrʉcaina sehe wʉhʉre noano yoaerariro yoaro sehe jira. Tí wʉhʉre buicã dapo, noano dahre dʉcaeraha. To ã cũri wʉhʉ jiro dia minino to cotiãchʉ dóihta tí wʉhʉ bʉrʉa wahaha. Ã jiro tí wʉhʉ tuaro bora sʉ cahaa wahaha —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tí quitire masare yahu tuhsʉ Jesu cʉ̃hʉ Capernaupʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tói jiriro cien surara pʉhtoro to cahamacʉnore tuaro cahĩha. To cahamacʉno sehe dohatiriro jiro, yariaro cahariro jimaha. ");
INSERT INTO gvc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ã jiro Jesu to yoaare tʉhoro, judio masa bʉcʉnare Jesu cahapʉ warocaha pʉhtoro sehe. —Dohatirirore noariro wahachʉ yoai taga —ni yahu dutiro warocaha pʉhtoro bʉcʉnare. ");
INSERT INTO gvc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tina Jesu cahapʉ sʉa, õ sehe ni tuaro mehne yahuha tirore: —Surara pʉhtoro sãre warocahre. To cahamacʉnore dohatirirore to yʉhdʉchʉ cahmahre tiro. Tiro pʉhtoro sehe noariro jira. To ã jichʉ yoadohoga tirore. ");
INSERT INTO gvc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mari ya maca macainare tiro cahĩna. Ã jiro tiro sã buheri wʉhʉre ti yoari wapa wapare —niha bʉcʉna Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ti ã ni yahuchʉ tʉhoro Jesu sehe tina mehne wahaha. Surara pʉhtoro ya wʉhʉ cahacãi to sʉro cahachʉ pʉhtoro sehe tiro mehne macainare Jesure õ sehe ni yahu dutiro warocaha: —Pʉhtoro, noanohca. Tai tjiga. Noariro jieraja yʉhʉ. Ya wʉhʉi mʉhʉre sãa ta dutiboriro jieraja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ã jicʉ mʉ cahai wahaeraja. Yʉ ã jipachʉta mʉ masia mehne noariro wahachʉ yoaga mʉhʉ tirore. Mʉ ã yoachʉ yʉ cahamacʉno noariro waharohca. ");
INSERT INTO gvc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yʉhʉre yʉ bui jiina paina pʉhtoa dutira. Ã jicʉ yʉhʉ cʉ̃hʉ surarare dutija. Cʉ̃irore “Wahaga”, yʉ nichʉ tiro wahara. Pairore “Taga”, yʉ nichʉ tiro tara. Yʉ cahamacʉnore “Ahrire yoaga”, yʉ nichʉ tíre tiro yoara. (Mʉhʉ cʉ̃hʉ dutirirota jira. Ã jiro mʉ dutiriro seheta tiro dohatiriro yʉhdʉrohca) —ni yahu dutiha surara pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","To ã nichʉ tʉho cʉaa waharo, payʉ masa tiro mehne jiinare majarerʉcʉ sʉ, õ sehe ni yahuha: —Mʉsare niita nija. Tiro surara pʉhtoro Israe masʉno jierariro Cohamacʉre tuaro wacũ tuara. To cahamacʉnore yʉ noariro wahachʉ yoahtire masi tuhsʉra. Israe masare ne ahriro yoaro sehe jiinare ñʉerasinija —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","To ã niri baharo surara pʉhtoro Jesu cahai to warocarina sehe ti pʉhtoro ya wʉhʉpʉ tjuaa wahaha. Tju sʉ dohatiriro to noariro jichʉ ñʉha tina. ");
INSERT INTO gvc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","To ã yoari baharocã Nai wama tiri macapʉ Jesu to buheina mehne payʉ masa mehne wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tí macare sãari sopaca cahai to sʉchʉ yariarirore masa na wijaa taa niha. Yariariro pocoro wapewahyoro jiha. Cʉ̃irota jiriro yariaha. Ã jia tó macaina masa payʉ ticoro mehne wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","To ã wahachʉ ñʉno Jesu ticorore pja ñʉha. —Tiieco tjiga —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ã nino yariariro to masa putihi ña payoha. To ã ña payochʉ ñʉa tí putire wʉaina sehe sʉrʉcaha. —Macʉ, yʉhʉ mʉhʉre õ sehe nija. Wahcã nuju sʉga —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","To ã niri baharo yariariro cjiro wahcã nuju sʉ, durucuha. Ã jiro Jesu tirore to pocorore waha. ");
INSERT INTO gvc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","To ã yoachʉ ñʉa tina jipihtina cuia wahaha. Ã jia tina Cohamacʉre ño payoa, õ sehe niha: —Cohamacʉ yare yahu mʉhtariro masi yʉhdʉariro mipʉ pinihtare mari watoi jira —niha tina. —Cohamacʉ marine to yainare yoadohoro wihi tuhsʉhre —niha paina. ");
INSERT INTO gvc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ã jia jipihtina Judea yahpa macainare tó dʉhtʉ cahai jia macari macainare Jesu to yoarire masa yahu site pahñoha. ");
INSERT INTO gvc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Ã yoa Jesu to yoarire ñʉa Joãore yahuha to buheina. Ã ti yahuchʉ tʉhoro pʉarore tiro cahai pjiroca, Jesure sinitu dutiro warocaha João. Õ sehe ni sinitu dutiha: —¿João “Yʉ baharo pairo tarohca”, to niriro tjijari mʉhʉ? ¿To niriro mʉ jierachʉ pairore cohtanahcari sã? —ni sinitu dutiha João pʉaro to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ã yoa tina Jesu cahai sʉ, sinituha tirore: —João masare bautisariro mʉhʉre sinitu dutiro warocahre sãre. ¿João “Yʉ baharo pairo tarohca”, to niriro tjijari mʉhʉ? ¿To niriro mʉ jierachʉ pairore cohtanahcari sã? —ni sinituha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tí pjata payʉ dohatiinare, watĩa ti cohtotainare, capari ñʉerainare noaina wahachʉ yoaha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ã jiro João warocainare Jesu õ sehe ni yʉhtiha: —Mipʉre mʉsa ñʉrire mʉsa tʉhorire Joãore yahuna wahaga: Õ sehe niga: “Capari ñʉeraina ñʉna. Tini masieraina tinina. Cami bʉcʉ baaina noaina wahara. Tʉho bocaeraina tʉhoa wahara. Yariaina masaa wahara. Tina jipihtinare noaina wahachʉ yoahi yʉhʉ. Ã yoa pjacʉoinare noaa buheare yahuja. ");
INSERT INTO gvc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yʉhʉre tʉhoriro ‘Potocã tjira’, niriro tiro wahcheriro jira”, Joãore ni yahuna wahaga —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","João buheina ti wahari baharo Jesu sehe João to jia tiare yahu dʉcaha payʉ masare: —Masa marienopʉ sʉna tjare wihnono to wãroca cohtotachʉ yoariro seheta to buheare cohtota mʉjarirore ñʉna sʉerare mʉsa. Ã yoariro jierare João. ");
INSERT INTO gvc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Noa suhti tirirore ñʉna wahajihna”, nierare mʉsa masa marienopʉ wahana. Noaa suhti tiina wapa bʉjʉare cjʉaina pʉhtoa ya wʉhʉsepʉ jira. Masa marienopʉ jierara. ");
INSERT INTO gvc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Masa marienopʉ sʉna Cohamacʉ yare yahu mʉhtarirore ñʉna sʉhre mʉsa. Potocã tjira. João Cohamacʉ yare yahu mʉhtariro jira. Paina Cohamacʉ yare yahu mʉhtaina yʉhdoro jiriro jira tiro. ");
INSERT INTO gvc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Panopʉ Cohamacʉ yare ti joari pũi Joãore õ sehe ni yahu joaa tiha: “Mari Pʉcʉ to macʉnore õ sehe niha: ‘Mʉ pano mʉhʉre yahuyuhtirore warocai nija’, niha Cohamacʉ”, ni yahu joaa tiha panopʉre Joãore. ");
INSERT INTO gvc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mʉsare potocã niita nija. Paina jipihtina bui jira João. Ahri turupʉre to ã jipachʉta mʉanopʉre Cohamacʉ masare pʉhtoro to noano sʉho jiropʉre jipihtina docapʉ jiriro pinihta João bui jira —niha Jesu masare. ");
INSERT INTO gvc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","To ã nichʉ tʉhoa jipihtina masa, pʉhtoa ya cjihtire wapa na cohtaina mehne João to bautisarina jia õ sehe ni tʉhotuha Cohamacʉre. “Cohamacʉ quihõno yoariro jira”, ni tʉhotuha tina. ");
INSERT INTO gvc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo curua macaina sehe judio masare buheina cʉ̃hʉ João to bautisanohrina ji duaeraha. Ã jia tinare Cohamacʉ to yaina to yoa duachʉ cahmaeraha. ");
INSERT INTO gvc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ã yoa Jesu pari turi õ sehe ni yahuha: —¿Mipʉ macaina masa yabaina yoaro sehe jijari tina, mʉsa tʉhotuchʉ? ");
INSERT INTO gvc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tina macanacã yoaro sehe jira. Paina ti cahmano sehe ti yoaerachʉ tó wahaerara tinacãre. Pache duaropʉ pape dujia, õ sehe ni pisurucura tinacã ti basi: “Mʉsa basahti cjihtire sã putipemahi. ¿Dohseana mʉsa basaerari sã tíre putipechʉ? Sã tuaro ñahacaha tiipe, sañurucumahi. ¿Mʉsa sehe dohseana sã mehne tiiperari?” nirucuina yoaro seheta jira mipʉ macaina cʉ̃hʉ. (Mipʉ macaina ti cahmano seheta sã yoaerachʉ ñʉa tó wahaerara tina cʉ̃hʉre.) ");
INSERT INTO gvc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","João bautisariro Cohamacʉre ño payoro taro ne chʉeraro, vinore sihnierare. To ã sihnierachʉ ñʉna “Watĩno to cohtotariro jira”, nimahre mʉsa tirore. ");
INSERT INTO gvc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yʉhʉ masʉno Cohamacʉ warocariro jicʉ, yʉhʉ chʉ sihnija. Yʉ ã yoachʉ ñʉna õ sehe nina mʉsa yʉhʉ sehere. “Ñʉga. Ahriro pjíro chʉriro, cahariro jira. Pʉhtoa ya cjihtire wapa na cohtaina, ñano yoaina cʉ̃hʉ ti piti tiriro jira ahriro”, nina mʉsa yʉhʉre. Ã nina macanacã yoaro sehe durucuina jira mʉsa. (Mʉsa cahmano sehe sã yoaerachʉ tó wahaerara mʉsare. Ne wahcherara mʉsa.) ");
INSERT INTO gvc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ã masierapanahta sã yoa ñorire ñʉna, Cohamacʉ yare sã masichʉ masinahca mʉsa —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo curua macariro to wʉhʉpʉ chʉ dutiro pjiha Jesure. To ã pjichʉ Jesu to ya wʉhʉpʉ sʉ, ti chʉri mesa cahai nuju sʉha. ");
INSERT INTO gvc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Tí macapʉre ñaare ñaare yoarucuricoro cjiro jiha. Jesu fariseo curua macariro ya wʉhʉpʉ to dujichʉ ticoro tʉhoha. Ã tʉho tuhsʉ alabastro mehne yoariare me sitia posa tiriare na ta, Jesu baharo bʉhʉsehei wihi tarʉca, tiiha. Ã tiiro Jesu dahporire to yahco co mehne wayo, to pjoari mehne pahã cohãha. To dahpori wʉachʉ ñʉ ticoro to dahporire wihmi, me sitia mehne pio payoha. ");
INSERT INTO gvc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","To ã yoachʉ ñʉno fariseo curua macariro Jesure pjiriro to basi õ sehe ni tʉhotumaha: “Ahricoro tirore ñaha ñʉricoro ñaare yoarucuricoro jira. Ahriro Jesu Cohamacʉ yare yahu mʉhtariro jiro tíre masiboa”, ni tʉhotumaha. ");
INSERT INTO gvc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","To ã ni tʉhotuare masino Jesu õ sehe ni yahuha tirore: —Simo mipʉ pinihtare mʉhʉre yahu duaja —niha Jesu. —Buheriro, ¿yʉhʉre dohse ni yahu duajari mʉhʉ? —ni yʉhtiha Simo. ");
INSERT INTO gvc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","To ã nichʉ Jesu õ sehe ni piti dahre buhe yʉhtiha: —Pʉhtorore pʉaro wapamoina jiha. Cʉ̃iro wapamoriro quinientos niñeru tʉrire wapamoha. Pairo sehe cincuenta niñeru tʉrire wapamoha. ");
INSERT INTO gvc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ã jia tina ti wapamoare ti wapa bihoerachʉ ñʉno pʉhtoro ti wapamoare wapa dutieraha. ¿Mipʉ pinihtare diro sehe wapamoriro sehe to pʉhtorore cahĩ yʉhdʉrohcari? —ni sinituha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo õ sehe ni yʉhtiha: —Bʉah, pjíro wapamoriro mahanocã wapamoriro yʉhdoro to pʉhtorore cahĩ yʉhdʉboca —niha Simo. —Potocã ni yʉhtihre mʉhʉ yʉhʉre —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ã ni tuhsʉ tirore pio payoricorore majare ñʉ, Jesu Simore õ sehe ni yahu namoha: —Ahricorore ñʉga mʉhʉ. Mʉ ya wʉhʉpʉ yʉ sãa wihiri baharo yʉ dahporire cosahti core yʉhʉre waerare mʉhʉ. Ahricoro sehe to yahco co mehne yʉ dahporire wayo, to pjoari mehne pahã cohãhre yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mʉhʉ sehe yʉhʉre piti boca wihmierare. Ahricoro sehe õi yʉ dujiro puro yʉ dahporire wihmihre. ");
INSERT INTO gvc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mʉhʉ sehe yʉ dapure se mehne pio payoerare. Ticoro sehe yʉ dahporire me sitia mehne pio payohre. ");
INSERT INTO gvc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ã nicʉ mʉhʉreta yahui nija. Ahricoro to ñaa yoari cjiri payʉbia jira. Ã jiricoro jiparota ticoro tuaro cahĩhre yʉhʉre. Ã jicʉ ñaare to yoari buhirire cohãhi. Ã jia ñaare ti yoari buhirire mahanocã yʉ cohãnohrina mahanocã cahĩna yʉhʉre —niha Jesu Simore. ");
INSERT INTO gvc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ã ni tuhsʉ tiro ticorore õ sehe ni yahuha: —Mipʉ pinihtare ñaare mʉ yoari buhirire boja —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","To ã nichʉ tʉhoa Jesu mehne dujiina ti basi õ sehe ni durucuha: —¿Dohse jiriro baro jijari ahriro ñaa buhirire boriro? —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ã ni tuhsʉ, Jesu numinore õ sehe ni yahuha: —Yʉhʉre mʉ wacũ tuachʉ mʉhʉre pichacapʉ wahaboricorore yʉhdoja. Cuiro marieno mʉ wʉhʉpʉ tjuaa wahaga —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Baharo bʉjʉa macaripʉ daa macaricãpʉ cʉ̃hʉre sʉ, Cohamacʉ masare pʉhtoro to noano sʉho jiare noaa buheare yahuha Jesu. Doce to buheina sehe tiro mehne jiha. ");
INSERT INTO gvc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ã yoa numia cʉ̃hʉ watĩa ti cohtotari numia cjiri, dohatia numia cjiri Jesu noaa numia to yoari numia tiro mehne tiniha. “María”, ti nimaricorore “Magdalena”, ni pisua tiha ticorore. Ticorore siete watĩare Jesu cohã wioha tó pano. Ã jiro ticoro cʉ̃hʉ Jesu mehne tiniha. ");
INSERT INTO gvc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Cuza wama tiriro Herodere dahra cohtaina pʉhtoro cjiro namono Juana cʉ̃hʉ Jesu mehne tiniha. Susana wama tiricoro cʉ̃hʉ paye numia mehne payʉ ti cjʉaa mehne tirore yoadohoha. ");
INSERT INTO gvc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ã yoa payʉ macari macaina Jesu cahapʉ cahmachuha. Ti ã cahmachuri baharo Jesu to tʉhotua mehne quiti dahre tinare õ sehe ni yahuha buhero taro: ");
INSERT INTO gvc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Toari masʉno toaro, to toaa yaparire doca site cũno wahaha. To ã doca site cũ wahcãchʉ paye yapari mahai bora caha sʉha. Ti ã bora caha sʉchʉ paye yaparire masa tʉ diho cũha. Ã jia paye yaparire minichahca duji ta, chʉnocaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ã yoa paye yapari sehe tãa wapa bui dihta se mininocã bui bora caha sʉha. Tí yahpapʉ co mariaha. Ã jia tí yapari du wija tarucuma ñaia wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Paye yapari sehe tja watoi bora caha sʉha. Tja sehe tí toaa mehne duha. Tja sehe dia yʉhdʉa waha, toaare wajãnocaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Paye yapari noari yahpai bora caha sʉha. Noano dua jia noano dicha tiha. Ã jia payʉ dicha tiha —niha Jesu. Ã ni tuhsʉ õ sehe tuaro ni namoha: —Ahrire tʉho duaina noano tʉhoga mʉsa —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Baharo to buheina tí quitire masi duaa, Jesure õ sehe ni sinituha: —¿Ahri quiti mehne dohse ni yahui nijari mʉhʉ? —ni sinituha tina. ");
INSERT INTO gvc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Cohamacʉ masa bui pʉhtoro to noano sʉho jiare panopʉ paina ti masierari cjirire mʉsare masichʉ yoarohca Cohamacʉ. Paina sehere ã yoaerara tiro. Tinare quiti mehneta buheihtja. Yʉ ã yoachʉ tina yʉ buheare tʉhopahta masisi —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ã ni tuhsʉ tinare õ sehe ni yahu namoha: —Õ sehe ni yahura ahri quiti: Toaa yapari noaa buhea yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ã yoa maha dʉhtʉ cahai boraa yapari sehe noaa buhea yoaro sehe jira. Cãina masa noaa buheare ti tʉhochʉ ñʉno watĩno sehe ta, tí buheare masi dutierara masare, minichahca tí yaparire ti chʉ cohãno seheta yoaro. To ã yoaerachʉ tina Cohamacʉre wacũ tuaboa. Ti ã wacũ tuachʉ ñʉno Cohamacʉ sehe tinare pichacapʉ wahaborinare yʉhdoboa. ");
INSERT INTO gvc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ã yoa tãa wapa bui dihta se mininocã bui boraa yapari noaa buhea yoaro sehe jira. Ã jia masa noaa buheare tʉho, wahchea mehne tíre tʉho nʉnʉ wahcãna. Ã tʉho nʉnʉpahta tãa wapa buicã jia yucʉ nʉhcori mariea yucʉ yoaro seheta ahrina masa cʉ̃hʉ yoari pja cʉ̃no pjaerara. Ã cʉ̃no pjaeraa yʉ yare ti cahmari buhiri paina tinare ti ñano yoachʉ ñʉa yʉ yare duhunocahna. ");
INSERT INTO gvc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ã yoa tja watoi boraa yapari noaa buhea yoaro sehe jira. Ã jia masa noaa buheare tʉhopahta, ahri yahpa macaare wacũ nʉnʉ yʉhdʉara. Niñerure bʉjʉa cahma, paye baro cʉ̃hʉre payʉ cahma, tíre goa pja yʉhdʉara tina. Ti ã yoachʉ tí sehe noaa buheare dʉcatara. Ti ã dʉcatachʉ masa noaa sehere yoaerara. Dicha maria yucʉ yoaro seheta jira. ");
INSERT INTO gvc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ã yoa noari yahpai boraa yapari noaa buhea yoaro sehe jira. Ã jia masa noaa buheare tʉhoa, noano mehne tí buheare yʉhdʉrʉcaerara. Ã jia yucʉcʉ dicha tiro seheta noaa buheare tʉhoina sehe Cohamacʉ to cahmano seheta noaare yoara —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ã ni tuhsʉ paye quiti mehne piti dahre buheha tiro: —Ne sihãriare ti sihãri baharo tiare dihi biato docai cũerara masa. Ã yoa tiare coãri casario docai cũerara. Mʉanopʉ tiare duhu payora wʉhʉpʉ sãa taina ti noano ñʉ sãahto sehe. ");
INSERT INTO gvc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jipihti ti masierari cjirire baharo masa masiahca. Sihãria to buhriachʉ mari ñʉ masino seheta panopʉ ti masierari cjirire masiahca masa. ");
INSERT INTO gvc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ã jina mʉsa tʉhona noano tʉho nʉnʉga. Noano tʉho nʉnʉriro, noano masinohca. Tʉho nʉnʉerariro “Mahanocã tʉhoja”, to nipachʉta tí sehere boa waharohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Baharo Jesu bahana ti pocoro mehne tiro cahapʉ wahaa nimaha. Masa payʉ jichʉ to cahapʉ sʉeraha. ");
INSERT INTO gvc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ã jiro cʉ̃iro Jesure õ sehe ni yahuha: —Mʉ poco mʉ bahana mehne sopacapʉ ducuhre. Mʉhʉre ñʉa taa niyuhti —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","To ã nichʉ Jesu õ sehe ni yahuha jipihtinare: —Cohamacʉ ya buheare tʉhoina, tíre yʉhdʉrʉcaeraina tinata yʉ poco yʉ bahana yoaro sehe jira —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pa dachoi Jesu to buheina mehne dohoriapʉ samu: —Basa, pahãjihna —ni, tina jipihtina tia mehne bʉcʉpariropʉ pahãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ã pahãno carĩa wahaha Jesu. Ti ã pahãrucuchʉ waro tuaro wihnono taha. Wihnono to tachʉ bʉjʉa pahcõri wahcã, tinare mionocamaha. Ã to wahachʉ minihto cua yʉhdʉaha tinare. ");
INSERT INTO gvc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ã wahachʉ ñʉa Jesu cahai waha, tirore wahcõha. —Buheriro, mari mini yariana tana nijã —niha tina. Ti ã nichʉ Jesu sehe wahcã, wihnonore “Tó purota wã duhuga”, niha. Ã ninota pahcõri cʉ̃hʉre “Yʉsʉa wahaga”, niha. To ã nichʉta wihnono yʉhdʉa wahaha. Ã yoa pahcõri cʉ̃hʉ yʉsʉ boraa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ã wahari baharo Jesu tinare õ sehe niha: —¿Mʉsa yʉhʉre wacũ tuaerasinijari? —niha tiro. To ã nichʉ tina sehe cui, cʉaa waha, ti basi õ sehe ni durucuha: —Cue, ¿dohse jiriro baro masʉno jijari ahriro? Ahri wihnono, pahcõri cʉ̃hʉ to dutichʉ yʉhdʉrʉcaerara tirore —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ã yoa tina sie coapʉ Gerasa macaina ya yahpapʉ pahã sʉha. Tí yahpa Galilea yahpa potoihta jiha. ");
INSERT INTO gvc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tói Jesu to maja sʉrʉcʉ sʉchʉ waro tó macariro watĩa ti cohtotariro tiro cahapʉ taha. Tiro yoari pja suhti marieriro jiro, to wʉhʉpʉre ne jieraha. Ã yoa masa copari tãa copari watoi jia tiha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ã jia payʉ tahari watĩa tirore ñahaha. Ã jiro tiro peresui to jichʉ to wamomacarine dahporire comaa dari mehne dʉhteriro jiparota, tiro tí darire nuha mʉjaha. Ã yoa watĩa sehe tirore masa marienopʉ na wahcãa tiha. Ã yoa tiro Jesure ñʉroca õ tuaro sañurucu, Jesu panoi na tuhcua caha sʉha. To ã yoachʉ ñʉno Jesu sehe tirore õ sehe ni dutiha: —Watĩa, duhuga ahrirore —niha Jesu. To ã nichʉ tʉhoro watĩa ti cohtotariro tuaro sañurucu, õ sehe ni sinituha Jesure: —Jesu, ¿Cohamacʉ Jipihtina Bui Jiriro macʉno yabare yoai tai nijari mʉhʉ yʉhʉre? Yʉhʉre, ñano yoai tjiga —niha watĩa ti cohtotariro. ");
INSERT INTO gvc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","To ã nichʉ Jesu sehe õ sehe ni sinituha tirore: —¿Yabariro wama tijari mʉhʉ? —niha. Payʉ watĩa tiro mehne jiha. Ã jiro õ sehe niha watĩa ti cohtotariro: —Watĩa payʉ wama tija sã —ni yʉhtiha watĩa ti cohtotariro tiro. ");
INSERT INTO gvc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—Cʉãri copapʉ sãre waha dutiecʉ tjiga —ni, tuaro siniha watĩa sehe. ");
INSERT INTO gvc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tí pjare tói tʉ̃cʉ dahpotoi yesea payʉ chʉa niha. Ti tói chʉchʉ ñʉa watĩa õ sehe ni siniha Jesure: —Sina yesea cahapʉ warocaga sãre ti pjacʉripʉ sã sãahto sehe —ni siniha watĩa. Ti ã sinichʉ tʉhoro “Jai. Wahaga”, niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","To ã dutichʉ, watĩa masʉno mehne jirina cjiri sehe wahaa, yesea pjacʉripʉ sãa wahaha. Ã yoa tinare ti sãari baharo, yesea jipihtina bʉcʉpariro dʉhtʉ cahapʉ pari cʉnʉpʉ mʉroca buha, tí taropʉ bora ñoja, mini yaria pihtia wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yeseare ñʉ wihboina yesea ti ã minichʉ ñʉa, cui, mʉrocaa wahaha. Ã mʉroca wahcã pjiri macapʉ cʉ̃hʉre, daa macaricãpʉ cʉ̃hʉre tíre ti ñʉrire yahu sitea wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ti ã yahuchʉ tʉhoa, masa sehe payʉ ti ã waharire ñʉa wahaha. Ã jia Jesu cahai sʉ, watĩa ti cohtotariro cjirore to suhti tiriro, tʉho masiriro to dujichʉ ñʉha tina. Tí jipihtiare ñʉa, tina cui niha. ");
INSERT INTO gvc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Watĩa ti cohtotariro cjiro noariro to waharire ñʉina, ti ñʉrire painare noano yahu pahñoha. ");
INSERT INTO gvc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tí pjata Gerasa yahpa macaina payʉ Jesure tuaro cuia, tirore pa sehepʉ waha dutiha. Ti ã waha dutichʉ Jesu dohoriapʉ samu, waharo taro niha. ");
INSERT INTO gvc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Watĩa ti cohtotariro cjiro Jesu to wahahto pano tuaro siniha tirore: —Mʉhʉ mehne waha duaja —ni sinimaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","To ã nichʉta Jesu tirore õ sehe ni yʉhtiha: —Mʉ ya macapʉ wahaga. Ã wahacʉ Cohamacʉ mʉhʉre to yoarire yahuga painare —niha Jesu. To ã niri baharo waha to ya macapʉ sʉro watĩa ti cohtotariro cjiro sehe Jesu tirore to yoarire jipihtina to ya maca macainare yahuha. ");
INSERT INTO gvc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pari turi Jesu tí bʉcʉpariropʉ pahãa wahaha tjoa. To pahã tariropʉta masa payʉ tirore cohtaa niha. Ã cohtaa, tirore piti bocasiniha wahchea mehne. ");
INSERT INTO gvc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Tói judio masa buheri wʉhʉ pʉhtoro Jairo wama tiriro Jesu cahai sʉ, to dahpori cahai na tuhcua caha sʉha tirore ño payoro. To macono yariaro niha. Ticoro cʉ̃corota jiricoro doce cʉhmari cjʉaricoro jiha. Ã jiro tiro to ya wʉhʉpʉ Jesure pji wahcãha. “Jai” ni, tiro mehne wahaha Jesu cʉ̃hʉ. Mahai ti ã wahachʉ payʉbia masa tirore nʉnʉ ti wahcã, bihsaro sʉrʉcʉ sʉha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","To ã bihsaro wahachʉ numino doce cʉhmari waro ã cahã ñʉrucuricoro tói jiha. Tó pano duhturuare jipihtia to niñeru mehne wapamaha ticoro co wa dutiro. Ti ã co wapachʉta mʉnanota jirucunocaha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ã jiro ticoro Jesu baharo masa payʉ watoi wihi, Jesu suhtirore to ñaha ñʉchʉta to cahã ñʉa pihtia wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","To ã ñaha ñʉchʉ tʉhoturo Jesu õ sehe ni sinituha: —¿Noa yʉ suhtirore ñaha ñʉri? —niha tiro. Jipihtina “Yoaerahi”, niha. Ã jia Pedro cʉ̃hʉ õ sehe niha: —Buheriro, bihsa nina. Ã jia masa payʉ mʉhʉre pihanocahna. ¿Dohseacʉ ã ni sinitujari mʉhʉ? —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Michapucacã yʉhʉ noaricoro wahachʉ yoahi cʉ̃corore. Ã jicʉ yʉhʉre to ñaha ñʉchʉ masija —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","To ã nichʉ tʉhoro ticoro duhti masieraro, teterericoro Jesu cahai na tuhcua caha sʉha tirore ño payoro. Ã jiro jipihtina masa ti tʉhoroi to dohatiare, Jesure to ñaha ñʉrire to noaricoro to waharire yahuha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","To ã ni yahu tuhsʉchʉ Jesu ticorore õ sehe ni yahuha: —Maco, yʉhʉre mʉ wacũ tuaa mehne noaricoro tjuara mipʉre. Wahchea mehne wahaga —niha ticorore. ");
INSERT INTO gvc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","To ã nino watoi Jairo ya wʉhʉi jiriro yahuro wihiha: —Mʉ macocã yariaa wahahre. Ã jicʉ buherirore pji tai tjiga —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","To ã nichʉ tʉhoro, Jairore õ sehe ni yahuha Jesu: —Cahya tʉhotui tjiga. Yʉhʉre wacũ tuaga. Tí dihtare yoaga. Mʉ ã yoachʉ ticorocã masaa waharohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ã ni tuhsʉ to wʉhʉpʉ sʉ, Pedro, João, Santiago, dohatiricoro pʉcʉsʉma tópeinata na sãaha. Paina sehere Jesu sãa dutieraha. ");
INSERT INTO gvc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tói jipihtina masa ti ñahacaha tiiro watoi sãa sʉha Jesu. —Tiiena tjiga. Ticorocã yariaerare. Carĩno nica —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","To ã nichʉ tʉhoa tina sehe ticoro yariaricoro to jichʉ masia, Jesure bʉjʉha. “Ã nimacanocano nina”, ni bʉjʉha. ");
INSERT INTO gvc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ã yoa Jesu ticorocã wamomacare ñaha, õ sehe ni pisuha: —Maharicorocã wahcãga —niha. ");
INSERT INTO gvc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","To ã nichʉta yariaricoro masaa waha, tí pjata wahcãrʉcʉ sʉha ticorocã. To wahcãri baharo Jesu ticorore chʉare wa dutiha. ");
INSERT INTO gvc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","To ã masachʉ ñʉa to pʉcʉsʉma ñʉ cʉaa wahaha. Ã jiro Jesu tíre painare yahu dutieraha. ");
INSERT INTO gvc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ã yoa Jesu doce to buheinare pjiroca, to tuaare waha tinare. Watĩare ti cohãhti cjihtire, dohatiinare noaina ti yoahti cjihtire to tuaare waha tinare. ");
INSERT INTO gvc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ã yoa tuhsʉ tinare Cohamacʉ masare pʉhtoro to noano sʉho jiare buhe dutiro, dohatiinare noaina wahachʉ yoa dutiro warocaha tinare. ");
INSERT INTO gvc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Õ sehe ni dutiha Jesu tinare: —Mʉsa wahana paye barore naaena tjiga. Tjuadʉre, wajure, chʉare, niñerure naaena tjiga. Mʉsa sãano dihtare sãa wahcãga. Paye suhtire naaena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jipihtia macaripʉ mʉsare ti carĩno wachʉ tí wʉhʉihta jinocasiniga. Coã wahanapʉ wijaahga tí wʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Paye macari macaina mʉsare ti cahmaerachʉ ñʉna tí macarine yʉhdʉ wahcãa wahaga. Ã wahana mʉsa dahpori macaa dihta pohcari mene wajã site cũga mʉsa tinare ti ya buhirire masichʉ yoana —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","To ã niri baharo to buheina sehe waha, jipihtia macaripepʉ noaa buheare yahu tinia tiha. Ã yoa dohatiinare noaina wahachʉ yoaa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ã yoa Herode Galilea yahpa macaina pʉhtoro Jesu yoarire tʉhorocaha. “¿Diro baro jijari tiro Jesu?” niparota ne masieraha. Cãina õ sehe nimaha Jesure: “João masare bautisariro cjiro pari turi bajuaro nica. Ã jiro ‘Jesu’, ti niriro tiro tjira”, nimaha cãina. Ti ã nichʉ tʉhoro Herode Jesure dohse ni masieraha. ");
INSERT INTO gvc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Paina “Tiro Elia cjiro mipʉ bajuaro nina”, nimaha. Paina sehe “Cohamacʉ yare yahu mʉhtaina panopʉ macaina mehne macariro cjiro mipʉ bajuaro nica”, nimaha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ti ã ni durucupachʉta õ sehe ni tʉhotuha Herode sehe: “João dapure dʉte ta duti tuhsʉhi yʉhʉ. ¿Mipʉre jiriro masa ti yahuriro diro baro jibocari tiro sehe?” ni tʉhoturo tiro Jesure ñʉ duamaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ã yoa Jesu to warocarina tiro cahapʉ tju sʉa, ti yoarire yahuha Jesure. Ti yahu tuhsʉchʉ Jesu tina dihtare Betsaida wama tiri macapʉ sʉho wahamaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ti waharire masia, masa payʉ tinare nʉnʉ ti wahcãha. Jesure ti mʉ sʉchʉ ñʉno piti bocasiniha Jesu tinare. Ã jiro tiro Cohamacʉ masare pʉhtoro to noano sʉho jiare tinare yahu, dohatiinare noaina wahachʉ yoaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ñamichahapʉ doce to buheina tiro cahapʉ sʉ, Jesure õ sehe ni yahuha: —Õ masa marienopʉ jira. Õ majano macaa macaripʉ, daa macaricãpʉ cʉ̃hʉre ahrina masare warocaga. Carĩa ti chʉhti cjihtire maca dutiga tinare —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Ti ã nichʉ Jesu õ sehe ni yʉhtiha tinare: —Ã nienata chʉare waga tinare —niha. To ã nichʉ tʉhoa tina õ sehe ni yʉhtiha: —Cʉ̃ wamomaca pihtia pão curiri, pʉaro wahi tó purocãta cjʉaja mari. ¿Ahrina payʉ masa ti chʉhti cjihtire nuchʉbocari sã? —niha to buheina. Payʉ masa ti jichʉ ñʉa ã niha to buheina. Tópʉre cinco mil mʉa jiha. (Numia, macanacã cʉ̃hʉ jiha.) Ã jiro Jesu õ sehe ni yahuha to buheinare: —Cincuenta masare cʉ̃ curuai duji dutiga. Paye curuari cʉ̃hʉre tópeinata duji dutiga —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","To ã nichʉ to buheina to dutiriro seheta yoa, jipihtina masare duji dutiha. ");
INSERT INTO gvc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Duji duti tuhsʉ Jesu cʉ̃ wamomaca pihtia pão curirire pʉaro wahi mehne na, mʉanopʉ ñʉha. Ã ñʉno Cohamacʉre “Noana”, niha. To ã niri baharo pão curirire nuha, to buheinare masare witi dutiro waha. ");
INSERT INTO gvc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ti ã witi tuhsʉchʉ, tina jipihtina masa chʉ, yapi yʉhdʉa wahaha. Ti yapi wahyorire doce pʉhʉse waro wahpo dapoha to buheina. ");
INSERT INTO gvc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cʉ̃ dacho Jesu cʉ̃irota jiro, Cohamacʉre sinino niha. To ã sinino watoi to buheina tiro cahapʉ sʉha. Ã jiro Jesu õ sehe ni sinitu ñʉha tinare: —¿Diro baro jicari yʉhʉ masa yʉhʉre ti tʉhotuchʉ? —ni sinitu ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","To ã sinituchʉ tʉhoa to buheina õ sehe ni yʉhtiha: —“João masare bautisariro jira”, nina mʉhʉre. Paina “Elia cjiro jira”, nina. Paina “Panopʉ macariro Cohamacʉ yare yahu mʉhtariro cjiro masa wijariro cjiro jira”, nina mʉhʉre —ni yʉhtiha to buheina sehe tirore. ");
INSERT INTO gvc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ti ã niri baharo Jesu tinare õ sehe ni sinitu ñʉha tjoa: —¿Mʉsa sehe mʉsa tʉhotuchʉ diro baro jicari yʉhʉ? —ni sinitu ñʉha tjoa. —Mʉhʉ Cristo Cohamacʉ warocariro jira —ni yʉhtiha Pedro. ");
INSERT INTO gvc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ã yoa Pedro “Cristo jira mʉhʉ”, to nirire painare Jesu yahu site dutieraha to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ã ni yahu site dutiera tuhsʉ õ sehe ni namoha: —Yʉhʉ masʉno Cohamacʉ warocariro tuaro ñano yʉhdʉihca. Ãta yʉhdʉro cahmana yʉhʉre. Ã jia mari coyea judio masare buheina, bʉcʉna, sacerdotea pʉhtoa mehne yʉhʉre cahmaeraa, yʉhʉre wajãahca. Ti ã wajãri baharo tia dacho wahaboroi masa mʉjaihca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Baharo jipihtinare õ sehe ni yahuha Jesu: —Cʉ̃iro yʉ yairo ji duaro, to cahmano yoa duamarine duhunocanohca. Ã yoa crusapʉ yʉ ñano yʉhdʉhtiro seheta yʉ yairo to jiri buhiri ñano yʉhdʉparota yʉhʉre duhusi. Ã jiro yʉ yare yoarucuriro jirohca. ");
INSERT INTO gvc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Masʉno yʉhʉre wacũno marieno to mʉ sʉro to cahmano seheta yoariro pichacapʉ tiro waharohca. Ã jiro yʉ yare ã yoarucuriro jipihtia dachoripe yʉhʉ mehne mʉanopʉ jirucurohca. ");
INSERT INTO gvc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Cʉ̃iro masʉno ahri yahpa macaare jipihtiare cjʉariro Cohamacʉre cahmaeraro pichacapʉ waharo yabare wapatajari tiro? Ã jiriro ne wapataerara. ");
INSERT INTO gvc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cãina yʉhʉre, yʉ buheare bʉo tiboca. Ti ã yoachʉ ñʉcʉ yʉhʉ cʉ̃hʉ yʉhʉre ã yoainare bʉo tisãaihca. Yʉhʉ masʉno Cohamacʉ warocariro noaina anjoa ti si sitea mehne, yʉ si sitea mehne, yʉ Pʉcʉ to si sitea mehne tjua tacʉ tinare bʉo tisãaihca. ");
INSERT INTO gvc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Potocã niita nija mʉsare. Mipʉre cãina mʉsa õpʉre jiina mʉsa yariahto pano Cohamacʉ jipihtina bui pʉhtoro noano to sʉho ji dʉcachʉ ñʉnahca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ã yoa ocho dachori tíre to yahuri baharo Jesu Pedrore, Joãore, Santiagore tina dihtare pjiha. Ã yoa waha, Cohamacʉre sinia waha, tʉ̃cʉpʉ mʉjaa wahaha tina. ");
INSERT INTO gvc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cohamacʉre to sinino watoi Jesu wʉhdʉa cohtotaha. To ã cohtotachʉ to suhtiro minoari suhtiro noano yehseri suhtiro wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","To ã waharo watoi pʉaro mʉa tiro mehne durucua niha. Durucuina sehe Elia cjiro, Moise cjiro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tina mʉano macaa si sitea mehne bajuaha. Jesu baharocãta Jerusalẽpʉ to yariahtore tina Jesu mehne durucua niha. ");
INSERT INTO gvc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro cʉ̃hʉ wʉjo caha yʉhdʉaha. Ã carĩpahta cʉa wahcã wihi Jesu to si siteare ñʉa, pʉaro tiro mehne ducuina cʉ̃hʉre ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moise cjiro cʉ̃hʉ ti wahahto panocã Pedro Jesure õ sehe nimaha: —Pʉhtoro, mari õre jichʉ noa duara. Tia wʉhʉcã yoanahtja. Mʉ ya wʉhʉcã, Moise ya wʉhʉcã, Elia ya wʉhʉcã yoanahtja —nimaha Pedro. Ã niparota to nirire ne masieraha. ");
INSERT INTO gvc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","To ã ni durucuro watoi tinare me curua duji boro pja sʉha. To ã duji boro pja sʉchʉ ñʉa tina cuia wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tuhsʉ, me curua puhichapʉ õ sehe ni durucuro coa taha: —Ahriro yʉ macʉ, yʉ beseriro jira. Noano tʉhoga tirore —nino coa taha me curua puhichapʉ. ");
INSERT INTO gvc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","To ã nino coa tari baharo Jesu dihtare ñʉha tina. Baharo ti ñʉrire painare yahueraha. Ne cʉ̃irore yahueraha. ");
INSERT INTO gvc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pa dachoi tina tʉ̃cʉpʉ ti duji tachʉ payʉ masa Jesure piti bocaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ã jiro tina mehne macariro Jesure õ sehe ni pisuha: —Buheriro, mʉhʉre tuaro ahrire sini duaja yʉhʉ. Yʉ macʉ cʉ̃irota jira. Ã jicʉ tirore ñʉbasaga mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Watĩno tirore ñaha, sañurucuchʉ yoa, tunu teterechʉ yoa, sahpo tua wahachʉ yoaa tihre. Ã yoaro watĩno yʉ macʉre ñano yʉhdʉchʉ yoa, ne duhu duaerara. ");
INSERT INTO gvc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉ buheinare watĩnore cohã wio duticʉ tuaro sinimahi. Yʉ ã sinipachʉta tina sehe tirore cohã wio masierare —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","To ã nichʉ Jesu sehe õ sehe niha: —Mipʉ macaina mʉsa ñaina jira. ¿Yʉhʉre ne wacũ tuaeraputiajari? Yoabiari pja mʉsare buhemaja yʉhʉ. ¿Noho puro yoari pja yʉhʉre mʉsa caribobocari? —ni tuhtiha Jesu. Ã ni tuhsʉ watĩno ti cohtotariro pʉcʉrore õ sehe niha: —Mʉ macʉre na tahga —niha. ");
INSERT INTO gvc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","To ã niri baharo to macʉno Jesu cahapʉ to taro watoi watĩno sehe tirore yahpapʉ doca caha sʉ, tunu teterechʉ yoaha. To ã yoachʉ Jesu watĩnore wijaa dutiha. To ã wijaa dutichʉ watĩno sãarirocã noariro wahaha. Ã jiro Jesu sehe tirocãre wiaha to pʉcʉrore. ");
INSERT INTO gvc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Cohamacʉ tuaa mehne noariro to wahachʉ ñʉa, jipihtina masa cʉaa wahaha. Masa Jesu to yoarire ti ñʉ, cʉaa wahachʉ Jesu sehe to buheinare õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Michapucacã yʉ yahuhtire boena tjiga mʉsa. Yʉhʉre Cohamacʉ to warocarirore pairo yʉhʉre ñaha dutiro warohca masare —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","To ã nipachʉta tina sehe to yahuare noano tʉho ñahaeraha. To yahurire tinare masihto basioeraha. Tí pjata Cohamacʉ tinare tíre tʉho ñaha dutierasiniha. Ã jia tina cuia, tíre tirore sinitu ñʉeraha. ");
INSERT INTO gvc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Baharo Jesu buheina durucu sayoa niha: —¿Mari mehne macariro diro sehe pʉhtoro ti cohtotacari? —ni sayoa niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ti ã nichʉ Jesu sehe ti tʉhotuare masino, nijinocãre to cahai duhu dapo, to buheinare õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Yʉ yare yoana tana ahrirocãre cahmana yʉhʉ cʉ̃hʉre cahmana mʉsa. Ã yoa yʉhʉre cahmana, yʉhʉre warocariro cʉ̃hʉre cahmana mʉsa. Mʉsa mehne macariro mʉsa cahamacʉno jiro tiro cʉ̃hʉ pʉhtoro tjirohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Baharo João Jesure õ sehe ni yahuha: —Buheriro, mʉ wama mehne watĩare cohãrirore sã ñʉhi. Tiro mari mehne macariro to jierachʉ ñʉna tíre tirore yoa dutiera tihi sã —niha João Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","To ã nichʉ Jesu Joãore paina buheina cʉ̃hʉre õ sehe ni yahuha: —Ã niena tjiga mʉsa tirore. Marine ñʉ tuhtiriro jieraro, tiro mari mehne macariro jira —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tí pjare Jesu mʉanopʉ to wahahto panocã, “Jerusalẽpʉ wahaihtja”, niha tiro. Ã nino tópʉ waharo niha. ");
INSERT INTO gvc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ã jia Jesu to panoi warocaina waha, Samaria yahpa macari macapʉ sʉ, tói Jesu to jihtore cahno duamaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jesu Jerusalẽpʉ waharo taro niha. Tópʉ wahahtiro to jichʉ tʉhoa, tó macaina tirore cahmaeraha. ");
INSERT INTO gvc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tíre tʉhoa Santiago, João mehne õ sehe ni yahuha Jesure: —Pʉhtoro, mʉ cahmachʉ mʉano macari pichaca mehne tinare wajã dutinahca —niha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ti ã nichʉ Jesu majare ñʉ, tuhtiha tina pʉarore. —Espíritu Santo yaina jira mʉsa. Mipʉ mʉsa tʉhoturo seheta tiro sehe tʉhotuerara. Yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉ tacʉ pichacapʉ wahaborinare yoadohohtiro tai. Masare butichʉ yoacʉ tacʉ nierahi —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ã tuhti tuhsʉ, pa macapʉ Jesu cʉ̃hʉ wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tina mahai ti wahachʉ, masʉno Jesure õ sehe ni yahuha: —Mʉhʉ mehne waha duaja nohoi mʉ waharoi —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","To ã ni tʉhsʉchʉ Jesu õ sehe ni yʉhtiha: —Cãina macaroca macaina wahiquina ti copari cjʉara. Minichahca cʉ̃hʉ ti suhti cjʉara. Yʉhʉ masʉno Cohamacʉ warocariro sehe yʉ carĩri wʉhʉ maeraja —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Baharo pairore Jesu pjiha: —Yʉhʉ mehne macariro cjihto taga —niha. To ã nichʉ tiro õ sehe ni yʉhtiha Jesure: —Pʉhtoro, yʉ pʉcʉ to yariachʉ yasinii wahaihtja. Ã ya tuhsʉcʉ pinihta mʉhʉ mehne wahaihtja —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","To ã nichʉ Jesu õ sehe ni yahuha: —Yʉhʉre cahmaeraina yariaina yoaro seheta jira. Tina sehe yariainare yajaro. Ã jicʉ mʉhʉ sehe Cohamacʉ masare pʉhtoro to noano sʉho jiare noaa buheare buhei taga —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ã yoa pairo Jesure õ sehe niha: —Pʉhtoro, mʉhʉ mehne wahaihtja. Wahmanore yʉ coyeare coha sitisinii wahaihtja —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","To ã nichʉ Jesu õ sehe ni yahuha tirore: —Wachʉ sahari pjĩne tʉã puriro mehne dahrariro noari dare saha duara. Ã dahrariro to baharo bʉhʉsehere majare ñʉno, noano potori da saha masierara. (Tó seheta Cohamacʉ yare yoaro taro, dahrariro tó pano to jia tiare tuaro wacũboca tíre duhu duaeraro, dahrariro to majare ñʉno seheta.) Ã wacũriro Cohamacʉ mari pʉhtoro yare dahraboriro jierara —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Baharo Jesu paina buheinare setenta y dos buheinare bese, macaripepʉ to wahahto pano warocayuha. Cãa macaripʉre pʉaro dihta warocaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ã warocaro õ sehe ni yahuha tinare piti dahre buhero: —Trigo payʉ ti bʉcʉa tuhsʉchʉ payʉ jichʉ dahraa pjíro jira. Wiho mejeta dahraina sehe mahainacã jira. Tó seheta noaa buheare tʉhohtina payʉ jichʉ pjíro jira mari dahraa. To ã jipachʉta mahainacã dahrari masa yoaro seheta noaa buheare buhehtina cʉ̃hʉ mahainacã jira. Ã jina noaa buheare buhehtinare painare to warocahtore siniga Cohamacʉre mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wahaga mʉsa. Mʉsare yʉ warocachʉ mʉsa oveja pohna yaya watoi ti jiro seheta mʉsa cʉ̃hʉ ñaina suaina watoi jinahca. ");
INSERT INTO gvc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niñeru wajure, bʉjʉawacũa waju cʉ̃hʉre, dahpo suhtire naaena tjiga. Mʉsa mahai tinina painare boca sʉ durucuena tjiga. Poto wahaga. ");
INSERT INTO gvc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jipihtia mʉsa sãa wʉhʉsepʉ sãahna “Ahri wʉhʉ macaina noano jijaro”, ni mʉhtaga. ");
INSERT INTO gvc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tí wʉhʉ macaina noano mehne jiina cahmachea marieina ti jichʉ, tíre niga tinare. Noano mehne ti jierachʉ ñʉna tí wʉhʉ macainare ã niena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cʉ̃ wʉhʉi sãa sʉrʉcana ti noaina jichʉ tí wʉhʉihta tjuaga. Tói ti duhu payorire chʉ, sihnituga. Dahrainare ti wapataare nano cahmana. Ã jina ti wapataare ti nano seheta ti duhu payorire naga mʉsa cʉ̃hʉ. Ã jina cʉ̃ wʉhʉihta mʉsa sʉri wʉhʉihta jina, tí maca macaa wʉhʉsepʉ ji tiniena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Macapʉre mʉsa sʉna tó macaina sehe mʉsare ti cahmaina jichʉ ti chʉa ti duhu payorire chʉga. ");
INSERT INTO gvc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tó macaina dohatiinare noaina wahachʉ yoaga. Ã jina õ sehe niga tinare: “Cohamacʉ mipʉre mari pʉhtoro noano to sʉho jihtore yahuna nija mʉsare”, niga tinare. ");
INSERT INTO gvc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pa macapʉ mʉsa sʉchʉ tina sehe mʉsare cahmaeraboca. Ti ã cahmaerachʉ ñʉna tí maca dacho macapʉ waha, õ sehe niga tinare. ");
INSERT INTO gvc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ahri maca macaa dihta pohcari mene wajã site cũna nija sãre mʉsa cahmaerari buhiri ñona. Ã jina ahrire wacũga. Cohamacʉ mari pʉhtoro mipʉre to noano sʉho jihtore yahuna nija mʉsare”, niga tinare. ");
INSERT INTO gvc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʉsare potocã niita nija. Sodoma macaina ñabiaina jiha. Ti ã jipachʉta pihtiri dacho jichʉ Cohamacʉ to buhiri dahreri dacho jichʉ Sodoma macaina yʉhdoro mʉsare cahmaeraina sehere buhiri dahrerohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Baharo Jesu õ sehe niha macari macainare: —Corazĩ macaina, mʉsa ñano yʉhdʉnahca. Betsaida macaina, mʉsa cʉ̃hʉ ñano yʉhdʉnahca. Mʉsa ya macaripʉre Cohamacʉ tuaa mehne yoa ñomahi. Tiro wama tiri macare, Sidõ wama tiri maca cʉ̃hʉre to tuaa mehne yʉ yoa ñochʉ ñʉa tó macaina sehe ti ñaare cahyaboa. Ã yoaa “Noaina jija”, ni ti tʉhotumari cjirire tʉhotu cohtotaboa. Dóihta tina duji, cahyaa suhtire sãa, ti basi niti pohcare ti bui dahra site payoboa ti ñaare cahyaare ñoa. ");
INSERT INTO gvc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cohamacʉ to buhiri dahreri dacho jichʉ Tiro macaina, Sidõ macaina yʉhdoro ñaa buhiri tiina mʉsa jiri buhiri mʉsare ñano waro buhiri dahrerohca tiro. ");
INSERT INTO gvc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernau macaina, mʉsa mʉ sʉro mʉanopʉ waha duamana. Mʉsa ã waha duapachʉta mʉsa ñaa buhiri tiina mʉsa jiri buhiri mʉsare Cohamacʉ pichacapʉ cohãnohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ã ni tuhsʉ Jesu to buheinare õ sehe ni yahuha: —Mʉsare tʉhoina yʉhʉ cʉ̃hʉre tʉhora. Mʉsare cahmaeraina, yʉhʉ cʉ̃hʉre cahmaerara. Ã jia yʉhʉre cahmaeraina, tina yʉhʉre warocariro cʉ̃hʉre cahmaerara —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Baharo setenta y dos buheina wahchea mehne tju wihiha: —Pʉhtoro, mʉ wama mehne mʉ tuaa mehne watĩare sã dutichʉ tina sehe sãre yʉhdʉrʉcaerare —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ti ã nichʉ Jesu õ sehe ni yʉhtiha tinare: —Mʉanopʉ to oroca site bora taro seheta, watĩno to bora tachʉ ñʉhi. ");
INSERT INTO gvc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Noano tʉhoga. Mʉsare yʉ tuaare wahi yʉhʉ. Ã jina agãare, pichõno soroare, watĩnore marine ñʉ tuhtirirore mʉsa yʉhdʉrʉcahtire wahi yʉhʉ. Ã jia tina mʉsare ñano yoa masierara. ");
INSERT INTO gvc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yʉ ã wapachʉta watĩa mʉsare ti yʉhdʉrʉcaerachʉ ñʉna tí dihtare wahchena tjiga. Ahri sehere wahchega. Mʉanopʉ Cohamacʉ yaina ti wamare to joa õri tjui mʉsa wamare to joa õchʉ ñʉna, tí sehere wahchega mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tí pjare Espíritu Santo Jesure tuaro wahchechʉ yoaha. Ã jiro Jesu õ sehe niha: —Mai, mʉhʉ mʉanopʉ cʉ̃hʉre yahpapʉ cʉ̃hʉre pʉhtoro jira. Masi yʉhdʉrʉcʉ sʉinare mʉ yahuerari cjirire wiho jiina sehere yahure mʉhʉ. Mʉ ã yoachʉ ñʉcʉ “Noa yʉhdʉara”, nija. Ã tjira, Mai. Mʉ yoa duariro seheta, mʉ cahmariro seheta tinare mʉ yare yahure —niha Jesu. Ã ni tuhsʉ painare õ sehe niha: ");
INSERT INTO gvc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—Yʉ Pʉcʉ jipihtiare yʉhʉre ware. Yʉ Pʉcʉ dihta yʉhʉre masina. Yʉhʉ cʉ̃hʉ tirore masija. Yʉ beserina cʉ̃hʉ tirore masina, yʉ masi dutiina jia. Tópeinata yʉ Pʉcʉre masija sã —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","To ã niri baharo ti sahsero ti jichʉ Jesu to buheinare õ sehe niha: —Ahri jipihtiare mʉsa ñʉna wahcheina jira. ");
INSERT INTO gvc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Potocã tjira. Payʉ Cohamacʉ yare yahu mʉhtaina cjiri, yahpari macaina pʉhtoa cʉ̃hʉ mipʉ mʉsa ñʉrire ñʉ duamaha tina cʉ̃hʉ. Ã jia mʉsa tʉhori cʉ̃hʉre tʉho duamaha —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tí pjata judio masare buheriro Jesu cahai wihi, Jesure ñano to durucuchʉ yoa duamaha tirore yahusã duaro: —¿Buheriro, yʉhʉ jipihtia dachoripe Cohamacʉ mehne ji duacʉ dohse yoaihcari yʉhʉ? —ni sinituha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","To ã nichʉ Jesu õ sehe ni yʉhtiha tirore: —¿Dohse ni yahujari Cohamacʉ yare ti joari pũi? ¿Cohamacʉ to ni joari cjirire dohse ni tʉhotujarita mʉhʉ? —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","To ã nichʉ tiro õ sehe ni yʉhtiha: —Õ sehe niha Cohamacʉ: “Tuaro mʉsa yajeripohnari mehne, noano mʉsa tuaa mehne, mʉsa wacũa mehne Cohamacʉre cahĩga. Ã yoa mʉ basi mʉ cahĩno seheta mʉ cahai jiina cʉ̃hʉre cahĩga” —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","To ã nichʉ Jesu õ sehe ni yahuha: —Quihõno nire mʉhʉ. Tíre yoaga. Ã yoacʉ jipihtia dachoripe Cohamacʉ mehne jiihca mʉhʉ —niha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","“Ahriro Cohamacʉ dutiare yoa pahñoriro jira”, masa tirore ti ni tʉhotuchʉ cahmaha judio masare buheriro. Ã cahmano tiro Jesure õ sehe ni sinituha: —¿Yabariro baro jicari yʉhʉre mʉ cahĩ dutiriro? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","To ã nichʉ Jesu õ sehe ni piti dahre quiti mehne yʉhtiha: —Cʉ̃ dacho Jerusalẽpʉ tariro Jericópʉ wahariro mahai to tinichʉ yacaina tirore ñahaha. Ã ñahaa, to suhtirore tjuwe na, tirore tuaro cjãha. Ã tuaro cjãa, mahano to yariaro cahachʉ waro duhuha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tí pjata sacerdote tí mahapʉ taha. Ã taro ti cjãriro cjirore ñʉparota maha pa bʉhʉsehe dʉhtʉ cahai do yʉhdʉ wahcã, yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ã yoa Cohamacʉ wʉhʉi dahrariro cʉ̃hʉ pjacʉoriro cahai sʉ, tirore ñʉ, maha pa bʉhʉsehe coai do yʉhdʉ wahcãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ã yoa Samaria macariro sehe tói waha, yoa cureropʉ pjacʉorirore ñʉ, tirore pja ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ã pja ñʉno, tiro pjacʉoriro cahai sʉ, se, vino mehne morea core to camine pio sihõha. Pio sihõ tuhsʉ suhtiro cahsaro mehne dʉhteha to camine. Tuhsʉ, pjacʉorirore to burro bui duhu payo, carĩni wʉhʉpʉ na sʉha tirore. Tói jiro, Samaria macariro noano ñʉ wihboha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pa dachoi tiro carĩni wʉhʉ pʉrore pʉa tʉ niñeru tʉrire wa, õ sehe niha: “Ahrirore ñʉ wihboga. Ahri mʉ sʉerachʉ pari turi tjua tacʉ wapa pahñoihtja”, niha Samaria macariro wʉhʉ pʉrore —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ã ni tuhsʉ judio masare buherirore õ sehe ni sinituha Jesu: —¿Ahrina tiaro mʉa diro sehe jijari pjacʉorirore cahĩriro? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","To ã nichʉ tʉhoro buheriro sehe Jesure õ sehe ni yʉhtiha: —Pjacʉorirore yoadohoriro jica tirore cahĩriro —niha tiro Jesure. —Wahaga. Mʉhʉ cʉ̃hʉ masare tó seheta yoai wahaga —niha Jesu buherirore. ");
INSERT INTO gvc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ã yoa Jesu to buheina mehne ti wahachʉ, pa macapʉ ti tinichʉ, Marta wama tiricoro tinare to wʉhʉi sãa ta dutiha. ");
INSERT INTO gvc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","To bahoro María to dahpori cahai duji, to buheare tʉhoha. ");
INSERT INTO gvc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","To ã yoachʉ ñʉno Marta to dahraa pjíro jichʉ suaha. Ã jiro ticoro Jesure õ sehe ni sinituha: —Pʉhtoro, ¿yʉhʉ cʉ̃coro yʉ dahrachʉ yʉhʉre yʉ baho to yoadohoerachʉ mʉhʉre noajari, mʉ ñʉchʉ? Ticorore yʉhʉre yoadoho dutiga —niha Marta Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","To ã nichʉ Jesu õ sehe ni yʉhtiha: —Marta, dahraa pjíro cjʉaco pjíro tʉhotura mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Cohamacʉ to yare tʉho dutira. María noaare yoaro taro tíre cahmahre. Ã jicʉ yʉhʉre to tʉhochʉ “Dahradohoco wahaga”, nieraja ticorore —niha Jesu Martare. ");
INSERT INTO gvc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cʉ̃ dacho Jesu Cohamacʉre sinino niha. To sini tuhsʉchʉ, cʉ̃iro to buheina mehne macariro tirore õ sehe niha: —Pʉhtoro, João to buheinare to buheriro seheta Cohamacʉre siniare sã cʉ̃hʉre buhega mʉhʉ —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","To ã nichʉ tʉhoro Jesu tinare õ sehe ni yahuha: —Õ sehe ni Cohamacʉre siniga: “Sã Pʉcʉ, mʉhʉ ñaa marieriro ã jirucura. Mipʉre jipihtina bui pʉhtoro jiga. ");
INSERT INTO gvc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ã yoa dachoripe sã chʉhtire warucuga sãre. ");
INSERT INTO gvc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Paina sãre ti ñano yoarire sã boja. Ã jicʉ mʉhʉ cʉ̃hʉ sã ñaa yoarire boga. Tuhsʉ, sã ñaare yoa duana sã goa pjachʉ ñʉcʉ tíre sãre yoa duaerachʉ yoaga”, ni siniga Cohamacʉre —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Baharo Jesu quiti mehne to buheinare õ sehe ni buheha: —Cʉ̃iro ñami dacho macai to coyeiro ya wʉhʉpʉ waha, tirore õ sehe ni siniha: “Coyeiro tia curi pão curi waga yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Pairo yʉ coyeiro tinino tariro michapucacãta ya wʉhʉi wihihre. Ã yoa tirore yʉ chʉa waboa mariahna”, niha tiro to coyeirore. ");
INSERT INTO gvc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","To ã nichʉ to coyeiro wʉhʉ puhichapʉ jiriro yʉhtiha: “Yʉhʉre cariboi tjiga. Sopa pahma bihariro jira. Yʉhʉ yʉ pohna mehne carĩna nija. Wahcãno pjaeraca yʉhʉre. Mʉhʉre chʉare waboricʉ jieraja”, niha to coyeiro. ");
INSERT INTO gvc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","¿Dohse waharohcari sinirirore? Potocã niita nija mʉsare. To coyeiro jiparota, chʉa waboriro wahcã duaeraha. Wahcã duaeraparota chʉa siniriro sehe bʉo tiro marieno to yoari pja sinirucuchʉ tʉhoro jipihtia to siniriro seheta warohca. ");
INSERT INTO gvc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ã jicʉ ahrire mʉsare ni yahui nija: Cohamacʉre siniga. Ã sinina mʉsa sinirire ñahanahca. Mʉsa sinirire bocanahca. Tirore ã sinirucuga. Mʉsa ã yoachʉ tiro mʉsare warohca. ");
INSERT INTO gvc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jipihtina Cohamacʉre siniina ti sinirire naahca. Ã yoa ti sinirire bocaahca. Ã jiro jipihtina Cohamacʉre ã sinirucuinare tiro tinare warohca. ");
INSERT INTO gvc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Mʉsa pohna mʉsare wahire ti sinichʉ agã sehere wabocari mʉsa tinare? ");
INSERT INTO gvc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Mʉsa pohna caraca diecare ti sinichʉ pichõno soro sehere wabocari mʉsa tinare? Ne wasi. ");
INSERT INTO gvc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mʉsa ñaina jipanahta mʉsa pohnare noaare wa masina mʉsa. Ã yoa Cohamacʉ sehe mʉsa wari yʉhdoro noaare wara mʉsare. Tiro mari Pʉcʉ mʉano macariro to Espíritu Santore warohca tirore siniinare —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tí pjare Jesu watĩnore cohã wioro niha. Watĩno sehe durucu masierariro jichʉ yoaha masʉnore. Ã jiro watĩno masʉnore to duhuri baharo masʉno sehe durucu dʉcaha. To durucuchʉ tʉhoa masa payʉ cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ti ã cʉapachʉta paina sehe õ sehe niha: —Ahriro Jesu watĩare to cohã wiochʉ Beelzebú wama tiriro watĩa pʉhtoro sehe tirore yoadohora —niha paina. ");
INSERT INTO gvc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Paina “¿Jesu Cohamacʉ to warocariro jijari?” ni masi duaa tirore Cohamacʉ tuaa mehne yoa ño dutimaha. ");
INSERT INTO gvc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ti ã dutichʉ tʉhoro “Watĩno tuaa mehne watĩare cohã wiora”, ni ti tʉhotuare masino, tinare õ sehe ni yahuha Jesu: —Watĩno ya tuaa mehne watĩare cohã wioi nieraja. Cʉ̃ maca macaina ti basi cahma wajãa, tí maca macaina yaria pihtia wahara. Ã jia cʉ̃ wʉhʉ macaina ti basi cahmachea, tí wʉhʉ macaina waha pihtia wahara. ");
INSERT INTO gvc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ã yoa watĩno yaina watĩa ti basi cahmachea, tina watĩa cʉ̃hʉ waha pihtia wahaboa. Cʉ̃ curua ji masieraboa. Mʉsa yʉhʉre õ sehe nina. “Tiro watĩno tuaa mehne watĩare cohã wiora”, mʉsa yʉhʉre nina nica. ");
INSERT INTO gvc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Yʉhʉre mʉsa niri potocã jichʉ mʉsa mehne macaina watĩare cohã wioa, watĩno tuaa mehneta cohã wiojari tina cʉ̃hʉ, mʉsa ñʉchʉ? Mʉsa mehne macaina watĩare cohã wioa, watĩno tuaa mehne cohã wioa nierara. Ahrire masina watĩno to tuaa mehne watĩare yʉ cohã wioerachʉ masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ã jicʉ yʉhʉ sehe watĩare cohã wiocʉ Cohamacʉ tuaa mehne cohã wioja. Ahrire masina, Cohamacʉ mʉsa pʉhtoro to noano sʉho ji dʉcaare masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tuariro to wamoa mehne to wʉhʉre to ñʉ wihbochʉ to yare paina na masierara. ");
INSERT INTO gvc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","To ã ñʉ wihbopachʉta pairo tua yʉhdʉriro tiro mehne cahmache, tirore yʉhdʉrʉca, to wamoare manoca, to yare manocahna. (Õ seheta yoa yʉhdʉrʉcaro cahmana watĩare.) ");
INSERT INTO gvc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Cʉ̃iro yʉhʉre cahmaeraro, yʉhʉre ñʉ tuhtiriro jira. Cʉ̃iro yʉhʉre yoadohoeraro yʉhʉre ñano yoaro nina —ni buheha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ã yoa to tʉhotua mehne õ sehe ni piti dahre buheha tinare: —Watĩno masʉnore duhuro tiro co marieni yahpai tinino, to sohto cjihtore macamaha. Bocaeraro, õ sehe ni tʉhotuha: “Masʉno yʉ duhuriro mehne pari turi jii wahaihtja”, ni tʉhotuha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ã nino tiro tjua waha, masʉnore bocaha. Ã to bocachʉ masʉno sehe noariro jimaha. ");
INSERT INTO gvc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tuhsʉ, watĩno paina siete watĩare tiro bui ñaa yʉhdʉinare nano wahaha. Na wihi, tina jipihtina watĩa masʉno mehne jiha. Ã jiro masʉno sehe tó pano cʉ̃iro watĩnore cjʉaro, ñariro jimaha. Mipʉ sehere payʉ watĩa ti cohtotariro jiro, tó pano to jiriro yʉhdoro ña yʉhdʉariro jiha —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tíre to ã nichʉ masa watoi jiricoro numino Jesure õ sehe ni yahuha: —Mʉhʉre pohna tiricoro, mʉhʉre pũricoro wahchericoro jira —niha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","To ã ni tuhsʉchʉ tʉhoro Jesu ticorore õ sehe ni yʉhtiha: —Cohamacʉ durucuare tʉhoina to dutiare yoaina tina tjica wahcheina —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ã yoa payʉ masa Jesu cahai ti wihichʉ, tiro tinare õ sehe ni yahu namoha: —Mipʉ macaina nu ñaina jira. Cohamacʉ tuaa mehne yʉ yoa ñochʉ ñʉ duamana. Ti ã ñʉ duapachʉta Jona panopʉ macariro Cohamacʉ tuaa mehne to yoari dihtare ñonohca Cohamacʉ tinare. ");
INSERT INTO gvc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona Cohamacʉ yare yahu mʉhtariro jiro, tiro Nínive macainare Cohamacʉ yare to masichʉ yoariro seheta yʉhʉ masʉno Cohamacʉ warocariro masichʉ yoaja mipʉ macainare. ");
INSERT INTO gvc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Buhiri dahrehti dacho jichʉ pʉhtorocoro sur macaricoro panopʉ macaricoro ducu, mipʉ macainare “Ñaina jira”, ni yahusãnohca ticoro. Ticoro Salomo panopʉ macariro to masiare tʉho duaro yoaropʉ ahri yahpa pa sehepʉ jiricoro Salomore tʉhoro taha. Ã yoaro noano yoaro niha mipʉ macaina yʉhdoro. Ã jiro ticoro yahusãnohca mipʉ macainare. Ã nicʉ mʉsare potocã niita nija. Mipʉ mʉsare yʉ buhea Salomo to buheri yʉhdoro jira. ");
INSERT INTO gvc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Buhiri dahrehti dacho jichʉ Nínive macaina cʉ̃hʉ ducu, mipʉ macainare “Ñaina jira”, ni yahusãahca tina. Jona tinare Cohamacʉ yare to yahuchʉ tʉhoa, ti ñaare tʉhotumarire tʉhotu cohtota Cohamacʉre cahmaha tina sehe. Ã cahmaa noano yoaa niha mipʉ macaina yʉhdoro. Ã jia tina cʉ̃hʉ mipʉ macainare “Ñaina jira”, ni yahusãahca. Mʉsare potocã niita nija. Mipʉ mʉsare yʉ buhea Jona to buheri yʉhdoro jira —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ã ni yahu tuhsʉ, piti dahre buhero õ sehe ni yahu namoha tinare: —Masa sihãriare sihãa nʉoerara. Tiare sihãa dihi biato docapʉ duhu dapoerara. Tiare mʉanoi duhu payora wʉhʉpʉ sãa taina ti noano ñʉ sãahto sehe. ");
INSERT INTO gvc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sihãria to noano buhriachʉ mari noano ñʉ masino seheta noaare tʉhotua mehne noaare yoa masinahca mʉsa. Mʉsa tʉhoturo seheta yoara mʉsa. Noaare tʉhotuna noaare yoara mʉsa. Noaare tʉhotuerana ñaare yoara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ã jina noano yoaga. Mʉsa tʉhotuapʉ ñaa jiero tjijaro. Ñaare goa pjaena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tuhsʉ mʉsa tʉhotuapʉ noaa jichʉ, ñaa ne mariachʉ noaa dihtare tʉhotunahca —ni buheha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu to buhe tuhsʉchʉ ñʉ fariseo curua macariro tirore to ya wʉhʉpʉ chʉ dutiro pjiha. Ã jiro Jesu tiro ya wʉhʉpʉ sãa sʉ, ti chʉroi tina mehne nuju sʉha. ");
INSERT INTO gvc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","To ã nuju sʉchʉ fariseo curua macariro sehe Jesure ñʉ nʉnʉno judio masa ti wamo cosarucuro seheta to wamo cosaerachʉ ñʉno õ sehe ni tʉhotuha: “Cuenah. ¿Ahriro dohsearo wamo cosaerajari mari yoaro sehe?” ni tʉhotuha. ");
INSERT INTO gvc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","To ã ni tʉhotuchʉ masino Jesu tirore õ sehe ni yahuha: —Mʉsa fariseo curua macaina sihnia wahwarire, wapari cʉ̃hʉre bui sehe dihtare mʉsa cosaro seheta noaare yoa ñona mʉsa buicã warohna. Ã yoapanahta Cohamacʉ yare quihõno yoaerara. Paina yare maina jina, ñaa dihtare tʉhotura mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tʉho masieraina jira mʉsa. Cohamacʉ mʉsa pjacʉrire yoariro mʉsa tʉhotuhti cʉ̃hʉre yoaha. ¿Tíre masierajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ã jina mʉsa yare pjacʉoinare waga mʉsa. Mʉsa ã yoana noaare tʉhotuina jinahca. ");
INSERT INTO gvc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Mʉsa fariseo curua macaina ñano yʉhdʉnahca. Moa yoaro sehe jiare chʉare coachʉ yoaare cjʉana mahanocã wamana mʉsa. Cohamacʉre ño payona tana sacerdoteare wamana mʉsa. Ã wapanahta noaare yoaerara mʉsa. Ã jina masare pja ñʉerara mʉsa. Ã yoa Cohamacʉre ño payoerara mʉsa. Toaa dichacãre mʉsa narire mahanocã Cohamacʉre mʉsa wachʉ noa nina. Ã wana õ sehe yoa namoga: Noaare yoaga. Ã yoa pja ñʉga mʉsa masare. Tuhsʉ, Cohamacʉre ño payoga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Mʉsa fariseo curua macaina ñano yʉhdʉnahca. Buheri wʉhʉpʉ jina, noaa dujia dihtare duji duara mʉsa. Pache duaropʉ masa mʉsare pʉhtoare noano ño payo ti sinino sehe ti piti bocasinichʉ cahmana mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Ñano yʉhdʉnahca mʉsa. Masa copa nʉori copa yoaro seheta jira mʉsa. Tí copa cahai masa jia, puhicha macariro baarirore ñʉerara tina. Tó seheta masa mʉsa cahai jia, mʉsa tʉhotuapʉ ñaa jiare masierara tina —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","To ã nichʉ tʉhoro judio masare buheina mehne macariro Jesure õ sehe ni yahuha: —Buheriro, tíre nicʉ sã cʉ̃hʉre ñano nii nica mʉhʉ —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","To ã nichʉ Jesu õ sehe ni yʉhtiha: —Potocã tjira. Judio masare buheina mʉsa cʉ̃hʉ ñano yʉhdʉnahca. Mʉsa painare ti bihoeraare yoa dutira tinare. Ã dutipanahta mʉsa sehe tinare ne mahanocã yoadohoerara tí dutiare ti yoahto sehe. ");
INSERT INTO gvc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Ã jina mʉsa ñano yʉhdʉnahca. Cohamacʉ yare yahu mʉhtaina panopʉ macaina ti masa coparire noano cahnomana mʉsa tinare ño payoro sehe yoana. Mʉsa ã yoapachʉta panopʉ macaina mʉsa coyea sehe tinare wajãha. ");
INSERT INTO gvc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tina sehe Cohamacʉ yare yahu mʉhtaina cjirire ti wajãriro seheta mʉsa cʉ̃hʉ yoaboa. Ã jina mipʉre ti masa coparire cahnomana mʉsa. Ã cahnona mʉsa coyea tinare ti wajãri cjirire wacũ bajuro wana nica mʉsa. Ã ti wajãrire wacũna “Noa nina”, nina nica mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Cohamacʉ to masia mehne õ sehe ni yahuha: “Yʉ yare yahu mʉhtaina cʉ̃hʉre yʉ buhe duti cũrina cʉ̃hʉre warocaihtja tinare. Ã jia tina yʉ warocainare painare wajã, painare ñano yoaahca”, niha Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ahri yahpare Cohamacʉ to bajuamehneri baharo Caĩ sehe Abere wajãha. Tuhsʉ, Cohamacʉ yare yahu mʉhtaina cjirire Abe baharo jiina cʉ̃hʉre ñaina wajãha. Baharo Zacariare Cohamacʉ wʉhʉi Cohamacʉre ño payori mesa cahai mʉsa coyeata wajãha. Jipihtina tinare ti wajãri buhiri mipʉ macainare Cohamacʉ buhiri dahrerohca. Ã tjira. Mʉsareta nii nija. Jipihtina tinare ti wajãri buhirire mipʉ macainare Cohamacʉ buhiri dahrerohca. ");
INSERT INTO gvc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Mʉsa judio masare buheina, ñano yʉhdʉnahca. Cohamacʉ masiare ti joaa pũrine cjʉapanahta painare yahuerara mʉsa. Mʉsa basi Cohamacʉ yare tʉhoerara. Tuhsʉ, paina to yare ti tʉho duapachʉta tíre mʉsa tinare tʉho dutierara —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","To ã nichʉ tʉhoa judio masare buheina fariseo curua macaina cʉ̃hʉ tiro mehne sua tirore ñano ni durucuha. Ã jia Jesu to ñano ni yʉhtichʉ tʉho duaa, tina payʉ mahño cũ sinitu ñʉmaha tirore, tirore yahusã duaa. ");
INSERT INTO gvc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ã yoa Jesu cahai masa payʉ cahmachua, bihsa yʉhdʉaha. Tói Jesu to buheinare õ sehe ni yahu dʉcaha: —Noano wacũ masiga mʉsa. Fariseo curua macaina ti pão bʉcʉarore ñʉna noano wacũ masiga. Ti mahñorucurire nii nija “Pão bʉcʉaro”, nicʉ. ");
INSERT INTO gvc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jipihtia ñaare paina ti masierari cjirire baharo masiahca. ");
INSERT INTO gvc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ã yoa ñamipʉre ti pjiroca durucuri cjirire buhriaroi to bajuro waro seheta masiahca jipihtina. Bihari tahtiapʉ pairore yaroca ti nimari cjirire masa payʉ masiahca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ã ni tuhsʉ Jesu õ sehe ni yahu namoha tinare: —Potocã niita nija mʉsare. Masa wajãina wajã tuhsʉ pari turi ti wajãrina cjirire ñano yoa namo masierara. Ã jina mʉsare wajã duainare cuiena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mipʉre mʉsa cuihtirore mʉsa ño payohtirore yahuihtja. Cohamacʉ sehere cui, ño payoga. Tiro mʉsa yariari baharo pichacapʉ cohã masina mʉsare. Ã tjira. Potocã nii nija. Cohamacʉ sehere cui, ño payoga. ");
INSERT INTO gvc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Cinco siripia wapa mariahna. Ti ã wapa mariapachʉta cʉ̃irocãre Cohamacʉ ne boerara. ");
INSERT INTO gvc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ã yoa mʉsa pjoarire ne cʉ̃ pjoa da dʉhsaro marieno masi pahñona Cohamacʉ. Tó seheta mʉsa jia tia cʉ̃hʉre masi pahñona Cohamacʉ. Ã masino mʉsare ñʉ wihborucura. Siripiare to cahĩno yʉhdoro mʉsa sehere cahĩna Cohamacʉ. Ã jina tirore ño payona cuiena tjiga mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ã yoa Jesu õ sehe ni yahu namoha: —Mʉsare niita nija. Cʉ̃iro “Jesu yairo jija”, masare to nichʉ ñʉcʉ, yʉhʉ masʉno Cohamacʉ warocariro “Tiro yʉ yairo jira”, ni yahuihtja Cohamacʉ yaina anjoare. ");
INSERT INTO gvc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Cʉ̃iro “Jesu yairo jija”, masare nierariro sehere yʉhʉ “Tiro yʉ yairo jierara”, ni yahuihtja Cohamacʉ yaina anjoare. ");
INSERT INTO gvc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Cʉ̃iro yʉhʉre ñano to ni durucuchʉ tí ñaa buhirire Cohamacʉ bo masina. Ã boparota cʉ̃iro Espíritu Santo sehere to ñano ni durucuchʉ tí ñaa buhirire ne Cohamacʉ bosi. ");
INSERT INTO gvc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Mari judio masa buheri wʉhʉpʉ pʉhtoa cahai paina mʉsare na sãa yahusãahca. Ti ã yahusãchʉ mʉsa ni dʉcatahti cjihtire “Cue, masieraboca”, ni tʉhotuena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tí pjaihta Espíritu Santo mʉsa yahuhti cjihtire yahurohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ã yoa masa mehne macariro Jesure õ sehe ni yahuha: —Buheriro, sã pʉcʉ to yariari baharo to ya cjiri sãre tjuara. Ã jicʉ yʉ wahmine tíre yʉhʉ cʉ̃hʉre quihõno tju wa dutiga —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","To ã nichʉ Jesu õ sehe ni yʉhtiha: —Ne tí barore tju waboricʉ jieraja yʉhʉ —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ã ni tuhsʉ Jesu jipihtinare õ sehe ni yahuha: —Noano yoaga mʉsa. Pachere, paye baro cʉ̃hʉre cahĩena tjiga. Payʉ cjʉapanahta tí mehneta wahche tuhsʉeraja mari —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ã ni tuhsʉ Jesu quiti mehne õ sehe ni yahuha tinare: —Pache pʉro noari yahpare cjʉaha. Ã jia tí yahpapʉ to toaa noano dicha tiha. ");
INSERT INTO gvc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ã jiro tiro to basi õ sehe ni tʉhotumaha: “Dicha wihboa wʉhʉse ne mʉ sʉerara. ");
INSERT INTO gvc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mipʉre õ sehe yoaihtja: Mipʉ yʉ wihboa wʉhʉsere cohãnoca, mʉna wʉhʉse cjiri yʉhdoro wahma wʉhʉse yoaihtja. Tí wʉhʉsei yʉ toaa dichare, jipihtiare yʉ yare wihboihtja. ");
INSERT INTO gvc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yʉ ã yoari baharo, õ sehe ni tʉhotuihtja yʉ basi: ‘Yʉhʉ jiape cjʉariro jija. Noano soihtja. Ã jicʉ chʉ, sihni, wahcheihtja’, ni tʉhotuihtja yʉ basi”, ni tʉhotumaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","To ã ni tʉhotuchʉ Cohamacʉ tirore õ sehe ni yahuha: “Mʉhʉ ne tʉho masierariro jira. Micha ñamiihta mʉhʉ yariaihca. Mʉ ã wahachʉ mʉ ya mʉ cahĩri butia wahaahca”, niha Cohamacʉ tirore —niha Jesu masare. ");
INSERT INTO gvc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tíre nino, masare õ sehe ni yahuha Jesu: —Ãta wahaahca pache pʉa Cohamacʉre wacũeraina. Payʉ pachere, niñerure to ya cjihti dihtare wihboriro, Cohamacʉre wacũeraro tiro pjacʉoriro jirohca, Cohamacʉ to ñʉchʉ. Ã jiro Cohamacʉ tirore ñʉ jicoaerara —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ã yoa Jesu to buheinare õ sehe ni yahuha: —Ahrire mʉsare nii nija: Mʉsa chʉhti cjihtire, mʉsa suhti sãahtire pjíro cahya tʉhotuena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cohamacʉ mʉsare bajuamehneno, chʉhtina cjihti dihtare yoaeraha mʉsare. Tuhsʉ, suhti sãahtina cjihti dihtare yoaeraha tiro mʉsare. ");
INSERT INTO gvc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Minichahca perire Cohamacʉ to ñʉ wihboare masiga. Tina weseri maeraina jira. Ã jia chʉare ti wihboa wʉhʉse tinare mariahna. Ti ã jiina jichʉ ñʉno tinare Cohamacʉ ti chʉhtire wara. Minichahca yʉhdoro mʉsa sehere cahĩna Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pjíro mʉsa tʉhotua mehne cʉ̃ hora waro mʉsare cati namochʉ yoa masierara mʉsa. Ã jiro mʉsa pjíro tʉhotua yaba cjihti jierara. ");
INSERT INTO gvc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¿Ã yoa pjíro mʉsa tʉhotua ti yaba cjihti jierapachʉta dohse yoana mʉsa chʉhtire, mʉsa sihnihtire, mʉsa sãahtire pjíro cahya tʉhotujari? ");
INSERT INTO gvc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Macaroca macaa cohorire tʉhotuga. Tí cohori ti basi suhtire yoaerara. Ã yoaerapahta noaa suhti tiina yoaro sehe noaa bajura tí cohori. Salomo cjiro noaa suhtire sãariro to jipachʉta tí cohori sehe tiro yʉhdoro noabiaa cohori waro jira. ");
INSERT INTO gvc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cohorire noaa cohori yoara Cohamacʉ sehe. To ã yoapachʉta cohori sehe mahaa dachoricã jirucuma ñai boraa wahara. Mahanocã ji, pa dachoi pichacapʉ jʉ̃a wahara. Ti ã jipachʉta cohorire noaa cohori jichʉ yoara Cohamacʉ. Ã jiro Cohamacʉ cohorire to noaa cohori to yoariro yʉhdoro mʉsa cʉ̃hʉre noano yoarohca. Suhtire warohca. Mahanocã Cohamacʉre wacũ tuara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ã jina mʉsa chʉhtire, mʉsa sihnihtire pjíro cahya tʉhotuena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Cohamacʉre cahmaeraina sehe ahri yahpa macaina sehe tíre ã macarucua nina. Mari Pʉcʉ mʉano macariro jipihtia mʉsa cahmaare masina. To ã masichʉ pjíro cahya tʉhotuena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Cohamacʉ mʉsa pʉhtoro to jihto cjihtore cahma mʉhtaga. Jipihtia paye baro yʉhdoro tirore cahmaga mʉsa. Mʉsa ã yoari baharo Cohamacʉ sehe mʉsa cahmaa dʉhsachʉ warohca —ni yahu namoha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ã ni tuhsʉ, tinare õ sehe ni yahu namoha: —Yʉ cahĩina, mahainacã jipanahta, cuiena tjiga mʉsa. Cohamacʉ mʉsa pʉhtoro to noano sʉho jiropʉre tiro mehne mʉsa jichʉ cahmana tiro. ");
INSERT INTO gvc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ã jina mʉsa yare dua pahñoga. Tíre duanoca tí niñerure na, pjacʉoinare waga. Tó sehe mʉsa yoachʉ mʉano macaa mʉsa wapataa ne pihtisi. Mʉanopʉ mʉsa ya jia ne pihtierara. Tópʉre mʉsa yare na masierara yacariro. Ã yoa machʉ cʉ̃hʉ tíre tʉa masierara. ");
INSERT INTO gvc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mʉanopʉ mʉsa ya jichʉ mʉano macaa dihtare tʉhotunahca mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ã ni tuhsʉ tinare õ sehe ni yahu namoha: —Mʉsa yare cahnoyu tuhsʉina yoaro sehe yʉ yare ã yoarucuina jina cohtaga yʉhʉre. Dahra cohtaina ti pʉhtoro wamomaca dʉhteri bose nʉmʉpʉ to wahachʉ to tjua tahtore tina cohtara. Tina ti ã cohtariro seheta yʉ tjua tahtore cohtaga mʉsa cʉ̃hʉ. Pʉhtoro to wʉhʉpʉ wihi, sopacare to dotachʉ tʉhoa tina dóihta pjõo sõhna tirore. ");
INSERT INTO gvc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dahra cohtaina ti pʉhtoro to wihichʉ to cahmano seheta yoarucuina jia, wahcheina jiahca. Ti ã yoachʉ ñʉno pʉhtoro sehe dahra cohtariro yoaro sehe cohtotarohca. Ã yoaro dahra cohtainare duji dutiro, tiro ti chʉare duhu payorohca. ");
INSERT INTO gvc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tiro to wihihti pja ñami dacho macapʉ, o bohrearopʉ to jipachʉta dahra cohtaina sehe to wihihti pjare tirore noano cohtaina jia, wahcheina jiahca tina. ");
INSERT INTO gvc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ahrire wacũga mʉsa. Yacariro wʉhʉpʉ to wihihto pano tí wʉhʉ pʉro masierara. Wʉhʉ pʉro yacariro to wihihtore masino, tiro yacarirore sãa dutieraboa. Ã jiro wacũenoca tara yacariro. ");
INSERT INTO gvc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ã jina mʉsa cʉ̃hʉ cohtaga. Yʉhʉ masʉno Cohamacʉ warocariro wacũenoca taihca. Ã jina yʉ yare ã yoarucuina jina cohtaga mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","To ã nichʉ Pedro sehe õ sehe ni sinituha Jesure: —¿Ahri quitire yahucʉ sãre nii nijari? ¿O jipihtinare ã nii nijari? —niha Pedro. ");
INSERT INTO gvc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","To ã nichʉ Jesu to tʉhotua mehne õ sehe ni piti dahre buheha tinare: —Dahra cohtariro to pʉhtorore ño payoriro tʉho masiriro õ seheta jira. Pʉhtoro tinino waharo, dahra cohtarirore to wʉhʉre cũna. To cũriro sehe dutiriro jirohca. Ã jiro tiro chʉri pja jichʉ paina dahra cohtainare chʉare witira. ");
INSERT INTO gvc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Baharo pʉhtoro to wihichʉ dahra cohtariro sehe to pʉhtoro to dutiriro seheta yoa pahñoriro jiro, tiro wahcheriro jirohca. ");
INSERT INTO gvc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Potocã niita nija mʉsare. To ã yoachʉ to pʉhtoro jipihtia to yare ñʉ wihboriro cũnohca tirore. ");
INSERT INTO gvc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","To ã cũpachʉta dahra cohtariro “Yʉ pʉhtoro yoari pja bajuerara”, niboca. Ã nino paina dahra cohtainare mʉare, numia cʉ̃hʉre cjãpe, payʉ chʉ, sihni, cahaboca. ");
INSERT INTO gvc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","To ã yoari baharo wacũenoca to pʉhtoro wihirohca. Ã wihiro tirore ñano buhiri dahrerohca. Ã jiro Cohamacʉre yʉhdʉrʉcainare to cohãriropʉ tirore cohãnohca. ");
INSERT INTO gvc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ã yoa dahra cohtariro to pʉhtoro cahmaare masiriro jiparota tíre to yoaerachʉ, tiro to noano dahraerachʉ to pʉhtoro sehe tirore yuta da mehne tuaro tjananohca. ");
INSERT INTO gvc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pairo sehe dahra cohtariro to pʉhtoro cahmaare masierariro jiro to noano yoaerachʉ ñʉno to pʉhtoro sehe pjiroca dero tirore tjananohca. Cohamacʉ to cahmaare masichʉ yoara masare. Ã jiro masirirore yʉhtiro cahmana. Tuhsʉ, noano masirirore noano yʉhtiro cahmana —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ã ni tuhsʉ Jesu tinare õ sehe ni yahuha tjoa: —Pichaca to jʉ̃wero seheta yʉhʉ ahri yahpapʉre Cohamacʉ tirore cahmaerainare to buhiri dahrehtore tinare masichʉ yoai tai nii. Mipʉ pinihta tíre ti masichʉ tuaro cahmaja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yʉhʉ ñano yʉhdʉihca. Yʉ ã ñano yʉhdʉhtire cohtacʉ, ñano yajeripohna tija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Dohse ni tʉhotujari mʉsa yʉhʉre? “Tiro masare to buheri baharo paina tinare ñʉ tuhtisi”, ¿ni tʉhotujari mʉsa yʉhʉre? Ã jierara. Masare yʉ buheri baharo cãina yʉ yare tʉhoahca. Paina sehe tinare ñʉ tuhtiahca. Cʉ̃no potori waro jisi masa. Mʉsare nii nija. Masa yʉ buheare tʉhoa, pʉa curua cahma tju waahca. ");
INSERT INTO gvc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mipʉre cʉ̃ wʉhʉ macaina cinco masa yʉ buheare tʉhoa, pʉa curua ti basi cahma tju waahca. Cʉ̃ curua tiaro, pa curua pʉaro jiahca. ");
INSERT INTO gvc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","To pʉcʉro to macʉnore ñʉ tuhtirohca yʉ yairo to jiri buhiri. Tuhsʉ, pairo macʉno cʉ̃hʉ to pʉcʉrore ñʉ tuhtirohca to pʉcʉro yʉ yairo to jiri buhiri. Ã yoa to pocoro to maconore ñʉ tuhtirohca yʉ yacoro to jiri buhiri. Tuhsʉ, pacoro macono cʉ̃hʉ to pocorore ñʉ tuhtirohca to pocoro yʉ yacoro to jiri buhiri. Ã yoa to marechono to macʉ namonore ñʉ tuhtirohca yʉ yacoro to jiri buhiri. Tuhsʉ, pacoro macʉ namono cʉ̃hʉ to marechonore ñʉ tuhtirohca yʉ yacoro to jiri buhiri. Ãta waharohca, yʉ buheare ti tʉhochʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ã yoa Jesu masare õ sehe ni yahuha tjoa: —Ahrie sehepʉ coro siterire ñʉna, dóihta “Coro tarohca”, nina mʉsa. Mʉsa ã niri baharo coro tara. ");
INSERT INTO gvc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ã yoa surpʉ wihnono tachʉ “Siri dacho jirohca”, nina mʉsa ahri yahpai jiina. Mʉsa ã niri baharo dacho sira. ");
INSERT INTO gvc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mʉsa mahñoperucuina jira. Mʉsa ahri yahpare mʉano cʉ̃hʉre ñʉna, noari dacho cjihtore, ñari dacho cjihto cʉ̃hʉre masina mʉsa. ¿Ã jina mipʉ macaa dachorire masipanahta dohseana ahri yahpa macaina mipʉre mʉsa dohse wahahtore masierajari mʉsa? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ã ni tuhsʉ õ sehe ni yahu namoha: —¿Mʉhʉ quihõno mʉ yoahtire masierajari mʉhʉ mipʉ? ");
INSERT INTO gvc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pairo mʉhʉre yahusãno waharo buhiri dahre dutiri wʉhʉpʉ waha dutiboca. Tópʉ wahana “Pari turi mʉhʉre ã yoasi”, nicʉ cahma pjãga. Mʉ ã cahma pjãerachʉ tiro buhiri dahre dutiriro cahapʉ naaboca mʉhʉre. Tuhsʉ, buhiri dahre dutiriro sehe mʉhʉre surarare to wachʉ, mʉhʉre surara peresu yoaahca. ");
INSERT INTO gvc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mʉhʉre nii nija. Tópʉ jisiniihca mʉhʉ. Pʉ ti wapa dutirire mʉ wapa pahñoipʉ wijaaihca mʉhʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tí pjare mahainacã masa Jesure õ sehe ni yahua tiha: —Galilea macaina wahiquirore wajã jʉ̃ mʉo Cohamacʉre ti ño payoro watoi Pilato sehe tinare wajãha. To ã wajãchʉ wahiquiro di mehne masa di moreha —ni yahuha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ti ã ni yahu tuhsʉchʉ Jesu õ sehe ni yahuha: —¿Galilea macaina Pilato to wajãrina cjirire dohse ni tʉhotujari mʉsa? ¿Ti ã yariachʉ paina Galilea macaina yʉhdoro ñaina ti jiri buhiri ã yoa dutiri Cohamacʉ tinare, mʉsa tʉhotuchʉ? ");
INSERT INTO gvc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jierara. Mʉsare niita nija. Mʉsa sehe “Noaina jija” ni, mʉsa tʉhotumari cjirire tʉhotu cohtotaerana, Cohamacʉre cahmaerana, mʉsa cʉ̃hʉ yariana pichacapʉ wahanahca. ");
INSERT INTO gvc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ã yoa sohõ jirina diez y ocho masa Siloé wama tiri wʉhʉ mʉari wʉhʉ ti bui bora pja wajã pahñoha. ¿Ã waha yariaa, paina Jerusalẽ macaina yʉhdoro ñaina jiri tina, mʉsa tʉhotuchʉ? ");
INSERT INTO gvc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jierara. Mʉsare niita nija. Mʉsa ñaa tʉhotumari cjirire tʉhotu cohtotaerana, Cohamacʉre macaerana, mʉsa cʉ̃hʉ yarianahca. Ã jina pichacapʉ wahanahca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ã ni tuhsʉ quiti mehne piti dahre yahuha tinare: —Wese pʉro to wesepʉ higueracʉre cjʉaha. Ã jiro tiro tʉ dichare macano wahamaha. Bocaeraha. ");
INSERT INTO gvc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bocaeraro tiro wese dahrarirore yahuha. “Tʉhoga yʉhʉre. Tia cʉhma waro higueracʉ dichare macamaja. Dicha mariahna. Tʉ dicha mariachʉ tʉre cjã cohãnocahga. Tʉ yʉ wesei jichʉ padʉre yʉhʉ toa masieraja. Yʉ wesei jiri yahpa macaare wiho waro nana tʉ”, niha wese pʉro tirore dahra cohtarirore. ");
INSERT INTO gvc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","To ã nichʉ tʉhoro dahra cohtariro õ sehe niha: “Pʉhtoro, ahdʉ cʉ̃ cʉhma waro ducusinijaro. Tʉ dahpotoi yʉhʉ sahaihtja. Tuhsʉ, wahiquiro tʉ mehne tí copare yaihtja. ");
INSERT INTO gvc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yʉ ã yoari baharo tʉ pa cʉhmai dicha tiboca. Tʉ dicha tierachʉ mʉhʉ cjã cohã dutiihca”, niha dahra cohtariro wese pʉrore —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tí pjare Sabado dachoi Jesu judio masa buheri wʉhʉi buhero niha. ");
INSERT INTO gvc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tói watĩno to cohtotaricoro jiha. Watĩno sehe diez y ocho cʉhmari waro dohatichʉ yoaha ticorore. Ã jiro pari muti ducuricoro jiro, poto ducu masieraha. ");
INSERT INTO gvc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","To ã jichʉ ñʉno Jesu ticorore ñʉ, õ sehe ni pisuha: —Numino, mʉ dohatia pihtia wahahre —ni pisuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","To ã pisuri baharo ticorore to ña payochʉ dóihta ticoro noano poto ducuricoro wahaha. Ã waharo “Cohamacʉ tuariro, noariro jira”, ni ño payoha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesu ticorore Sabado dachoi to noaricoro yoachʉ ñʉno judio masa buheri wʉhʉ pʉhtoro sehe tiro mehne suaha. Ã suaro tiro masare õ sehe niha: —Seis dachori jira mari dahraa dachori. Ã jina mʉsa dohatiinare noaina wahachʉ yoa duana, tí dachorire tíre yoaga. Sabado dachore mari sori dachore tíre yoaena tjiga —niha wʉhʉ pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","To ã nichʉ Jesu õ sehe ni yʉhtiha: —Mʉsa ã mahñorucuina jira. Mʉsa wachʉre, burro cʉ̃hʉre cjʉana Sabado dachoi ti dʉhteri dare pjã, tinare na buha, sihni dutiboa. ");
INSERT INTO gvc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mipʉ ahricorore Abrahã cjiro coyeacorore watĩno diez y ocho cʉhmari waro ticorore dohatichʉ yoahre. ¿Sabado dachoi ticorore noaricoro wahachʉ yoa dutierajari mʉsa? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","To ã nichʉ tʉhoa, tina bʉoro wahaha. Ã jia paina sehe jipihtina Jesu yoarire ñʉa, wahcheha. ");
INSERT INTO gvc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ã yoa Jesu quiti mehne piti dahre buheha masare: —¿Ne Cohamacʉ masa bui pʉhtoro to noano sʉho jia yaba baro yoaro sehe jijari, mʉsa tʉhotuchʉ? Ahri quiti mehne tíre pʉhtoro to sʉho jiare yahuihtja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza yapacã yoaro sehe jira. Tí yapacãre toari masʉno to wesei toaha. To toari baharo tí yapacã duha. Ã jia tʉ bʉcʉachʉ minichahca peri tʉ dʉpʉripʉ suhti suhaha. (Tó seheta mʉano macarirore mari pʉhtorore masiina mahainacã ti ji mʉhtapachʉta baharopʉ tina payʉ wahaahca) —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ã ni tuhsʉ, pari turi Jesu õ sehe ni piti dahre buheha: —¿Ne Cohamacʉ masa bui pʉhtoro to noano sʉho jia yaba baro yoaro sehe jijari, mʉsa tʉhotuchʉ? ");
INSERT INTO gvc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pão bʉcʉaro yoaro sehe jira. Tíre numino cʉ̃ wajuru trigore co mehne noano tíre dahra morena pão bʉcʉahtore. To ã yoachʉ pão bʉcʉaro sehe trigore noano sahserʉcʉ sʉra. (To sahserʉcʉ sʉro seheta mʉano macarirore mari pʉhtorore payʉ masa masiahca) —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ã yoa Jesu bʉjʉa macaripʉ, daa macaricãpʉ cʉ̃hʉre buhe wahcã, Jerusalẽpʉ sʉro taro niha. ");
INSERT INTO gvc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","To ã waharo watoi cʉ̃iro Jesure õ sehe ni sinituha: —Pʉhtoro, ¿mahainacã masare pichacapʉ wahaborinare yʉhdorohcari Cohamacʉ? —ni sinituha tiro Jesure. To ã nichʉ Jesu piti dahre buhero õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Payʉ masa Cohamacʉ cahapʉ waha duaa, sãa duamana. Mahari sopacacãre mʉsa sãa duachʉ mijo curera. Tó seheta Cohamacʉ cahapʉ mʉsa waha duachʉ mijo nina. Masa ã sãa duapahta sãa masierara. Ã jina mʉsa sehe mahari sopacacãre mʉsa tuaro sãa duaboro seheta Cohamacʉ sehere tuaro masiga. ");
INSERT INTO gvc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Õ sehe yoarohca Cohamacʉ payʉ masare. Tiro wʉhʉ pʉro yoaro sehe jira. Wʉhʉ pʉro wahcã, sopacacãre biharohca. To ã yoachʉ sopacacãpʉ ducuna, sopa pahmare dotanahca. Ã dotana õ sehe ninahca: “Pʉhtoro, sopa pahmare pjõohga”, mʉsa nichʉ wʉhʉ pʉro sehe õ sehe ni yʉhtirohca. “Mʉsare ne masieraja yʉhʉ. Nohoi mʉsa tariro cʉ̃hʉre masieraja”, ni yʉhtirohca. ");
INSERT INTO gvc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","To ã nichʉ mʉsa õ sehe ni yʉhtinahca: “Mʉhʉ mehne sã chʉ, sihnihi. Sã ya macai buhere mʉhʉ”, ninahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mʉsa ã nichʉ tiro sehe õ sehe ni yʉhtirohca: “Mʉsare ne masieraja. Nohoi mʉsa tariro cʉ̃hʉre masieraja. Jipihtina mʉsa ñaa buhiri tiina yʉ cahai taena tjiga”, ninohca wʉhʉ pʉro. ");
INSERT INTO gvc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ã yoa Abrahã cjirore, Isaa cjirore, Jacobo cjirore, jipihtina Cohamacʉ yare yahu mʉhtaina cjirire Cohamacʉ masare pʉhtoro to noano sʉho jirore ti jichʉ ñʉna, mʉsa sehe sopacapʉ cohãrina jina tuaro tiinahca. Ã tiina jina, mʉsa tuaro cahyaro mehne piri bahca dihonahca. ");
INSERT INTO gvc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tí pjare jipihtiro macaina pʉhtoro Cohamacʉ to noano sʉho jiropʉre sʉ, tiro mehne chʉ dujiahca. ");
INSERT INTO gvc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mipʉre wiho jiina jirina cjiri tí pjare pʉhtoa jiahca. Ã jia mipʉre pʉhtoa jirina cjiri tí pjare wiho jiina jiahca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tí pjare mahainacã fariseo curua macaina Jesu cahapʉ sʉa, tirore õ sehe ni yahuha: —Herode mʉhʉre wajã duara. Ã jicʉ pa sehepʉ wahaga mʉhʉ —niha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ti ã nichʉ Jesu sehe õ sehe ni yʉhtiha: —Herode mahñoa payʉriro jira tiro. Õ sehe ni yahuga tirore: “Jesu watĩare cohã wioro nina. Tuhsʉ, dohatiinare noaina wahachʉ yoaro nina. Tíre michare, ñamichaca cʉ̃hʉre yoarohca. Ñamichaca bohrearo dahra batoarohca”, ni yahuga Herodere. ");
INSERT INTO gvc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ã jicʉ michare waha, ñamichaca cʉ̃hʉre waha, ñamichaca bohrearo cʉ̃hʉre waha, Jerusalẽpʉ sʉihca. Cohamacʉ yare yahu mʉhtarirore yʉhʉre wajãahca masa. Cohamacʉ yare yahu mʉhtainare ti wajãchʉ Jerusalẽpʉ jiro cahmana tinare. Ã jicʉ yʉhʉ cʉ̃hʉre Jerusalẽpʉ jiro cahmana. ");
INSERT INTO gvc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Cue Jerusalẽ macaina. Mʉsa Cohamacʉ yare yahu mʉhtaina cjirire wajã, mʉsa cahai to warocainare tãa mehne doca wajãre mʉsa. Mʉsa coyea panopʉ macaina cʉ̃hʉ ãta yoarina cjiri jiha. Caracacoro to pohnare to cjãpʉ dʉpʉri mehne to moha coãno seheta payʉ tahari mʉsare cahĩrucumahi. Mʉsare cahmamahi. Mʉsa sehe yʉhʉre ne cahmaerare. ");
INSERT INTO gvc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mipʉre mʉsa jiro cohãri maca jirohca. Potocã niita nija mʉsare. Cohamacʉ mari pʉhtoro to tuaa mehne taihca yʉhʉ. Yʉ ã tachʉ ñʉna mʉsa yʉhʉre “Cohamacʉ tuaa mehne tariro noajaro”, ninahca. Yʉhʉre mʉsa tíre nihto pano pari turi yʉhʉre ñʉsi mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pa dacho Sabado dacho jichʉ fariseo curua macaina pʉhtoa mehne macariro ya wʉhʉpʉ Jesu chʉro wahaha. Tí wʉhʉi jiina tiro dihtare ñʉroca õha. ");
INSERT INTO gvc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ti ã ñʉroca õno watoi yachʉri wipiriro, ñʉchʉa wipiriro tiro cahapʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ã jiro Jesu judio masare buheinare, fariseo curua macaina cʉ̃hʉre õ sehe ni sinituha: —¿Sabado dachore dohatirirore noariro wahachʉ yoa dutijari Cohamacʉ yare ti joari pũi? —ni sinituha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","To ã ni sinitupachʉta tina yʉhtieraha. Ti yʉhtierachʉ ñʉno Jesu dohatirirore noariro wahachʉ yoa, “Wahaga”, niha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ã yoa tuhsʉro, tinare õ sehe ni sinituha tjoa: —“¿Cʉ̃iro mʉsa mehne macariro to macʉno Sabado dachoi mari sori dachoi copapʉ to bora sãachʉ na wioerabocari?” mʉsa ã nina. “¿To wachʉ cʉ̃hʉre na wioerabocari?” mʉsa ã nina —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","To ã nipachʉta tina to sinituare yʉhti masieraha tjoa. ");
INSERT INTO gvc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseo curua macariro ya wʉhʉi jiro tí wʉhʉ macariro to pjirocaina noaa dujiare ti besechʉ ñʉha Jesu. Ã ñʉ tuhsʉ õ sehe ni yahuha jipihtinare: ");
INSERT INTO gvc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Wamomaca dʉhteri bose nʉmʉi mʉsare to pjirocachʉ, noaa dujiare bese dujiena tjiga. Mʉsa yʉhdoro cua pisainare pjirocaboca ahri wʉhʉ pʉro. ");
INSERT INTO gvc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","To ã yoachʉ mʉsa noaa dujiai dujichʉ, “Ahrina cua pisainare mʉsa dujiare waga”, niboca wʉhʉ pʉro mʉsare. To ã nichʉ mʉsa sehe bʉo tina, ñaa dujiai dujiboca. ");
INSERT INTO gvc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ã jina wʉhʉ pʉro mʉsare to pjirocachʉ, ñaa dujiai duji mʉhtaga. Mʉsa ã yoachʉ wʉhʉ pʉro mʉsare “Noaa dujia sehere dujina taga”, ninohca mʉsare tiro. Mʉsa ã wahachʉ paina to pjirocaina sehe mʉsare ño payoa mehne ñʉahca. ");
INSERT INTO gvc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cʉ̃iro to basi “Pʉhtoro tjija”, ni tʉhoturiro cahamacʉno jirohca. Pairo “Cahamacʉno jija”, ni tʉhoturiro painare yʉhdʉrʉca duaerariro tiro sehe pʉhtoro jirohca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ã ni tuhsʉ Jesu wʉhʉ pʉrore õ sehe ni yahuha: —Mʉhʉ bose nʉmʉ dahrecʉ mʉ cahai jiinare, mʉ bahanare, mʉ coyeare, pache pʉare pjiecʉ tjiga. Mʉ tinare pjichʉ mʉhʉ cʉ̃hʉre tina cʉ̃hʉ pji cahmaahca tjoa. Ã pji cahmaa mʉhʉre ti wapamoare wapaahca. ");
INSERT INTO gvc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mʉhʉ bose nʉmʉ dahrecʉ pjacʉoinare, tini masierainare, cʉ̃ bʉhʉsehe dahporo dojori tiinare, capari ñʉerainare pjirocaga. ");
INSERT INTO gvc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mʉ ã yoachʉ ñʉno Cohamacʉ mʉhʉre noano yoarohca. Tina sehe mʉhʉre ti wapamoare wapa masierara. Ã jiro noaina yariaina ti masa mʉjari pja jichʉ Cohamacʉ sehe noaare mʉ yoari wapa mʉhʉre noano yoarohca —niha Jesu wʉhʉ pʉrore. ");
INSERT INTO gvc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","To ã nichʉ tʉhoro pairo chʉri mesa cahai dujiriro, Jesure õ sehe ni yahuha: —Cohamacʉ masare pʉhtoro to noano sʉho jiroi to chʉri mesa cahai dujiina tuaro wahcheina jiahca —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","To ã nichʉ Jesu ahri quitire yahuha tirore: —Pjiri bose nʉmʉ dahreriro payʉ masare pjirocaha. ");
INSERT INTO gvc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","To pjirocari baharo bose nʉmʉ dachoi to cahamacʉnore to pjirocainare yahu dutiro warocaha. “Ma, jipihtiare bose nʉmʉ macaa cjihtire cahno tuhsʉhre. Ã jiro mʉsare pjirocahre”, ni yahu dutiha to cahamacʉnore. ");
INSERT INTO gvc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","To cahamacʉno to ã ni yahupachʉta, to pjirocaina sehe “Waha masieraja”, niha tina. To pjiroca mʉhtariro õ sehe ni yahuha to cahamacʉnore: “Michapucacã yahpare nuchʉhi. Ã jicʉ tí yahpare ñʉi wahai tai nija. Ã yoacʉ waha masieraja. Ño payo curea yʉhʉre. Yʉhʉre basioerahca”, niha to pjiroca mʉhtariro sehe to cahamacʉnore. ");
INSERT INTO gvc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pairo sehe õ sehe niha: “Wachʉare pʉa wamomaca pihtiinare michapucacãta nuchʉhi. Ã jicʉ wachʉare buhe cayo ñʉi wahai tai nija ti waja wahcãhtore. Ã yoai wahaeraja. Yʉhʉre basioerahca”, niha tiro cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pairo sehe õ sehe niha: “Yʉhʉ michapucacã wamomaca dʉhtehi. Ã jicʉ bose nʉmʉpʉ waha masieraja”, niha tiro to cahamacʉnore. ");
INSERT INTO gvc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","To ã nichʉ to cahamacʉno sehe tjua waha, to pʉhtoropʉre ti niri cjirire yahu pahñoha. To ã ni yahuchʉ to pʉhtoro tuaro susini, õ sehe niha to cahamacʉnore. “Macari macaa maharipʉ pjacʉoina ti ducua maharipʉ wahaga. Ã jicʉ pjacʉoinare, tini masierainare, capari ñʉerainare, cʉ̃ bʉhʉsehe dahporo dojori tiinare cjero na tahga tinare”, niha pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Baharo curero to cahamacʉno yahuha to pʉhtorore: “Pʉhtoro, mʉ dutiriro seheta yoahi. Yʉ ã yoapachʉta paina cʉ̃hʉ mʉ sʉahca”, niha to cahamacʉno. ");
INSERT INTO gvc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","To ã nichʉ pʉhtoro tirore õ sehe ni dutiha: “Campopʉ wahaga. Tói bʉjʉa maharipʉ jiinare, daa maharicãpʉ jiina cʉ̃hʉre masare yʉ wʉhʉpʉ ta dutiga, ya wʉhʉ to noano wahpahto cjihto sehe. ");
INSERT INTO gvc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Potocã nii nija mʉhʉre. Ahrina yʉ pjiroca mʉhtarina yʉ chʉare ne mahanocã chʉsi”, niha pʉhtoro —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tí pjare payʉ masa Jesu mehne wahaha. Ã jiro Jesu tinare majare ñʉ, õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Cʉ̃iro yʉ buheriro ji duaro painare to cahĩriro yʉhdoro yʉhʉ sehere cahĩno cahmana. To pʉcʉrore, to pocorore, to namonore, to pohnare, to bahanare, to pjacʉ cʉ̃hʉre to cahĩriro yʉhdoro yʉhʉ sehere cahĩno cahmana. Ã yoaeraro yʉ buheriro ji masierara. ");
INSERT INTO gvc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Cʉ̃iro yʉ buheriro ji duaro yʉ yare ã yoarucuriro jirohca. Ã yoa crusapʉ yʉ ñano yʉhdʉhtiro seheta yʉ yairo to jiri buhiri ñano yʉhdʉ duaeraro yʉ buheriro ji masierara. ");
INSERT INTO gvc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ahrire masiyuro cahmana mʉsare. Õ sehe jira tí: Wʉhʉ dahreriro to mʉari wʉhʉre yoahto pano wʉhʉ wapa tihtire quihõ cũ mʉhtana. Ã yoaro to wʉhʉre to pahñohtore masina tiro. ");
INSERT INTO gvc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wapa tihtire quihõeraro to wʉhʉre yoaro pahñoeraboa. Ã jia tirore ñʉina bʉjʉpeboa. ");
INSERT INTO gvc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ahriro to wʉhʉre yoaro bihoerare”, ni bʉjʉpeboa. ");
INSERT INTO gvc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pʉhtoro pairo pʉhtoro yaina mehne ti cahma wajãhto pano, to yaina surarare to cahma wajã dutihto pano, to surarare quihõnohca. “¿Yʉhʉ diez mil surara mehne pairo veinte mil surara cjʉariro mehne cahma wajãcʉ bihobocari yʉhʉ?” ni tʉhoturo quihõnohca tiro. ");
INSERT INTO gvc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ã quihõno, to bihoerahtore masinohca. Ã masino pairo pʉhtoro to surara mehne cahma wajãno tariro yoaropʉ to jichʉta, bihoerariro sehe “Cahma wajãena tjijihna”, ni dutiro warocaboa dahra cohtarirore. ");
INSERT INTO gvc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ã jina yʉ buheina ji duana, mʉsa yoahtire mʉsare masino cahmana. Mʉsa yoa duari sehere cohã duaerana, yʉ buheina ji masierara —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ã ni tuhsʉ tinare õ sehe ni yahu namoha: —Moa noano coara. To coaerachʉ coa yoahto basioerara. ");
INSERT INTO gvc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Moa coaerachʉ tí moa ne noaerara. Tí moare dohseahto basioerara. Tí ã jichʉ tí moare cohãno cahmana. Ne yaba cjihti jierara ti cohõa. (Ti yaba cjihti jieraro seheta jiena tjiga mʉsa. Moa noano to coaro seheta mʉsa cʉ̃hʉ ji coaina jiga. Tuhsʉ, paina mehne noano mehne jiga.) Ahrire noano tʉhoga mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ã yoa pa dachoi payʉ pʉhtoa yare wapa na cohtaina paina “Ñaare yoaina”, ti niina mehne Jesure tʉhoa taha. ");
INSERT INTO gvc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ti ã yoachʉ ñʉa fariseo curua macaina, judio masare buheina cʉ̃hʉ Jesure ñʉ tuhtia, õ sehe niha ti basi: —Ahriro ñainare piti tira. Ã jiriro jirota tina mehne chʉra —ni durucuha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ti ã ni durucuchʉ Jesu to tʉhotua mehne õ sehe ni piti dahre buheha tinare: ");
INSERT INTO gvc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Cien oveja pʉro cʉ̃iro oveja butichʉ ñʉno dohse yoarohcari tiro? Õ sehe yoarohca. Tiro noventa y nueve ovejare ti chʉri campopʉ cũ, butirirore macano waharohca. Ovejare bocaropʉ duhurohca. ");
INSERT INTO gvc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tirore bocaro wahcherohca. Ã jiro to comapariaca buipʉ tirore cjã payo, to wʉhʉpʉ na tjuaa waharohca. ");
INSERT INTO gvc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na tju sʉ, to cahai jiinare, to coyeare pji cahmachunohca. “Yʉ oveja butirirore boca tuhsʉhi. Ã jina yʉhʉ mehne wahchega”, ninohca tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Potocã niita nija mʉsare. Noventa y nueve oveja payʉ ti jiriro seheta, payʉ masa õ sehe ni tʉhotura: “Ñano yoaeraja. Ã jicʉ yʉ ñaare cahya, yʉ tʉhotumari cjirire tʉhotu cohtotasi yʉhʉ”, ni tʉhotura payʉ masa. Ti ã ni tʉhotuchʉ ñʉa mʉano macaina Cohamacʉ cahai jiina wahcherara. Pairo sehere wahchera. Butiriro oveja cʉ̃irota to butiriro seheta to pʉro tirore to bocariro seheta cʉ̃iro ñariro to ñaare cahyachʉ, “Ñano yoaeraja”, ni to tʉhotumari cjirire tʉhotu to cohtotachʉ, Cohamacʉre to cahmachʉ ñʉa, Cohamacʉ cahai jiina tuaro wahchera —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ã ni yahu tuhsʉ, paye quiti mehne piti dahre yahu namoha tjoa: —¿Diez niñeru tʉri cjʉaricoro cʉ̃ tʉ butichʉ ñʉno dohse yoarohcari ticoro? Õ sehe yoarohca ticoro. Sihãriare sihã, wʉhʉre coha, noano maca pahñonohca. Tí tʉre bocaropʉ duhurohca. ");
INSERT INTO gvc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tí tʉre boca tuhsʉ, to cahai jiinare, to coyeare pji cahmachunohca. “Niñeru tʉ ya tʉ yʉhʉre butiri tʉre bocahi. Ã jina yʉhʉ mehne wahchega”, ninohca ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Potocã niita nija mʉsare. Tó seheta cʉ̃iro ñariro to ñaare cahyachʉ, “Ñano yoaeraja”, ni to tʉhotumari cjirire tʉhotu to cohtotachʉ Cohamacʉre to cahmachʉ Cohamacʉ yaina anjoa sehe tuaro wahcheahca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ã ni yahu tuhsʉ Jesu paye quiti mehne piti dahre yahu namoha tjoa: —Bʉcʉro pohna pʉaro mʉa jiha. ");
INSERT INTO gvc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dʉhsariro sehe õ sehe niha to pʉcʉrore: “Mai, mʉ yariari baharo yʉhʉre mʉ wahtire yʉhʉre wa bahrañoga”, niha tiro to pʉcʉrore. To ã nichʉ ti pʉcʉro pʉaropʉreta to pohnare witira to cjʉari cjirire. ");
INSERT INTO gvc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mahaa dachoricã baharo dʉhsariro to yare jipihtiare na, yoaropʉ pa yahpapʉ wahaa wahaha. Tópʉ sʉro tʉho masierariro seheta yoa, to niñerure to yare yoa site pahñonocaha. ");
INSERT INTO gvc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","To yoa site pahñori baharo tí yahpapʉre ne chʉa marieni pja ji dʉcaha. Ã jiro tiro jʉca baaha. ");
INSERT INTO gvc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ã jiro tí yahpa macaa dahraare macaha. To bocachʉ to pʉhtoro yesea cohtariro sõha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ã jiro tiro yeseare nu, ti chʉare chʉ duamaha. To ã chʉ duapachʉta tí chʉare tó macaina waeraha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ã yoa tirore tói wacũa taha jʉna. “Yʉ pʉcʉre dahra cohtaina sehe bʉjʉa chʉare chʉca. Ti chʉ dʉhaa cʉ̃hʉ bʉjʉa dʉhsaca. Ti ã noano yʉhdʉro watoi yʉhʉ sehe õi jicʉ, jʉca yariai nija. ");
INSERT INTO gvc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mipʉre yʉ pʉcʉ cahapʉ tjuaihtja. Yʉ pʉcʉ cahapʉ sʉcʉ õ sehe niihtja tirore: ‘Mai, Cohamacʉre ñano yoahi. Mʉhʉ cʉ̃hʉre ñano yoahti. ");
INSERT INTO gvc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ñariro jija. Mʉ macʉ jiboriro jieraja yʉhʉ. Mʉhʉre dahra cohtaina seheta yoaga yʉhʉre’, niihtja yʉ pʉcʉre”, ni tʉhotuha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ã ni tʉhoturota wahcãrʉca, to pʉcʉro cahapʉ tjuaa wahaha. Tópʉ to sʉriro tjua tachʉ to pʉcʉro sehe yoaropʉta to macʉnore ñʉha. ’To ã wihichʉ ñʉno to macʉnore pja ñʉha. Ã pja ñʉno to cahai mʉroca wahcã tirore cjã suhsu mʉa, to wahsupui wihmiha to pʉcʉro to macʉnore. ");
INSERT INTO gvc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mai, Cohamacʉre ñano yoahi. Mʉhʉ cʉ̃hʉre ñano yoahti. Ñariro jija yʉhʉ. Mʉ macʉ jiboriro jieraja yʉhʉ”, niha tiro to pʉcʉrore. ");
INSERT INTO gvc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","To ã nichʉ tʉhoro to pʉcʉro sehe dahra cohtainare pjiha: “Cjero, noa yʉhdʉri suhtirore na tahga. Ã jina yʉ macʉre sãaga. Sãa tuhsʉ, to wamomaca sãari sorore sãa, to dahporire dahpo suhti cʉ̃hʉre sãaga. ");
INSERT INTO gvc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sãa tuhsʉ, dihi tirirocã wachʉcãre wajãga. Bose nʉmʉ yoajihna. ");
INSERT INTO gvc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ahriro yʉ macʉ yariariro seheta wahare. Ã wahaparota mipʉre catira tiro. To butiboriro seheta jirirore mipʉre bocahi. Ã jina bose nʉmʉ yoajihna”, niha to pʉcʉro. To ã niri baharo bose nʉmʉ dahre dʉcaha tina. ");
INSERT INTO gvc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Tí pjare to wahmino sehe wesepʉ jiha. Wesepʉ jiriro coha tjua taro wʉhʉ cahai sʉro, ti basaare tʉhorocaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ã tʉhorocaro, cʉ̃iro dahra cohtarirore pjiroca, tirore sinitu ñʉha tiro: “¿Dohse yoa basaa niri?” ni sinitu ñʉha tiro dahra cohtarirore. ");
INSERT INTO gvc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Mʉ bahʉ tju wihihre. Tiro noariro, catiriro to tju wihichʉ mʉ pʉcʉ dihi tiriro wachʉcãre wajã dutihre”, ni yʉhtiha dahra cohtariro. ");
INSERT INTO gvc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","To ã ni yahuchʉ to wahmino sehe tuaro suaro, wʉhʉpʉ sãa taeraha. To sãa taerachʉ ñʉno to pʉcʉro sopacapʉ wijaa ta, “Sãa taga” ni, tuaro pjimaha to macʉnore. ");
INSERT INTO gvc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Tʉhoga, Mai. Yoari pja mʉhʉre dahra cohtariro seheta mʉhʉre yoadohomahi. Ã jicʉ mʉ dutiare ne cʉ̃ taha yʉhdʉrʉcaera tihi. Yʉ mʉhʉre dahra cohtapachʉta yʉhʉre ne waerare mʉhʉ. Ne cʉ̃iro wahiquirocãre ne waera tire mʉhʉ yʉhʉre yʉ piti tiina mehne yʉ bose nʉmʉ dahrehti cjihtire. ");
INSERT INTO gvc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wiho mejeta ahriro mʉ macʉ sehe ñaina numia mehne mʉ yare yoa site pahñoyuhti. Tíre yoa site pahño tuhsʉ, tiro wʉhʉpʉ to tju wihichʉ dihi tirirocãre wachʉcãre wajã dutiyuhti mʉhʉ to chʉhtiro cjihtore”, niha to wahmino to pʉcʉrore. ");
INSERT INTO gvc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Macʉ, yʉhʉ mehne jipihtia dachoripe mʉ jichʉ jipihtia ya mʉ ya cʉ̃hʉ jira. ");
INSERT INTO gvc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mʉ bahʉ sehe yariariro seheta wahare marine. Ã yoa mipʉre tiro catiriro jira. Tiro butiboriro seheta jire. To ã wahari baharo mipʉre tirore bocahi. Ã jina to tju wihichʉ mari bose nʉmʉ yoa wahchechʉ noana”, niha tiro to macʉnore —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ã yoa ahri quitire to buheinare õ sehe ni yahuha Jesu: —Pache pʉro ya niñerure ñʉ wihbo cohtariro niñerure noano to ñʉ wihboerachʉ ñʉno pairo sehe yahusãha pache pʉrore: “Tiro mʉ niñerure yoa sitero nina”, ni yahusãha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","To yahusã tuhsʉri baharo niñeru ñʉ wihbo cohtarirore pjirocaha. Ã pji tuhsʉ, to wihichʉ ñʉno, tirore pʉhtoro õ sehe niha: “Pairo yʉ niñerure mʉ yoa siterire yʉhʉre yahure. Ã jicʉ mipʉre yʉ yare ñʉ wihboriro jisi mʉhʉ. Ã jicʉ yʉ yare mʉ yoari cjirire yahu pahño joaga. Mʉhʉre cohãi nija”, niha to pʉhtoro tirore. ");
INSERT INTO gvc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","To ã niri baharo õ sehe ni tʉhotuha ñʉ wihboriro to basi: “Yʉ pʉhtoro yʉhʉre cohãno taro nica. Yʉhʉ tuaeraja. Ã jicʉ tuaro dahraare bihoeraja. Tuhsʉ, painare yʉhʉ niñerure sinicʉ bʉobiaro yʉhdʉboca yʉhʉ. ¿Dohse yoaihcari yʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mipʉ pinihtare yʉ yoahtire masija yʉhʉ jʉna. Õ sehe yʉ yoachʉ yʉ dahraa maerachʉ yʉ pʉhtorore wapamoina yʉhʉre cahĩahca. Ã jia ti wʉhʉsepʉ sãa dutiahca yʉhʉre”, ni tʉhotuha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ã ni tʉhoturo tiro jipihtina to pʉhtorore wapamoinare pjirocaha. Pjiroca tuhsʉ, cohtaha. Ã cohtaro wihi mʉhtarirore õ sehe ni sinituha tiro: “¿Yʉ pʉhtorore noho puro wapamojari mʉhʉ?” niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","To ã nichʉ wapamoriro sehe õ sehe ni yʉhtiha: “Cien tambores sere olivo dicha mehne ti yoari sere wapamoja tirore”, ni yʉhtiha tiro. To ã ni yahuchʉ niñeru ñʉ wihboriro sehe õ sehe ni yahuha: “Õi jira mʉ wapamonore joa õri pũ. Dujiga. Ã jicʉ mʉ wapamonore dacho macai na, dacho macai joa cahnoga”, niha ñʉ wihboriro wapamorirore. ");
INSERT INTO gvc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ã ni tuhsʉ pairo wapamorirore sinituha tiro: “¿Mʉhʉ waro, noho puro wapamojari?” niha tjoa. “Cien waju trigo yapari wajure wapamoja yʉhʉ”, niha wapamoriro niñerure ñʉ wihborirore. “Õi jira mʉ wapamonore joa õri pũ. Mʉ wapamonore ochenta joa cahnoga”, niha ñʉ wihboriro. ");
INSERT INTO gvc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","To ã noano mahño mihnichʉ ñʉno “Ahriro mahñoriro noano masiriro jica”, ni tʉhotuha to pʉhtoro niñerure ñʉ wihborirore. Ahri dacho macaina, Cohamacʉre cahmaeraina ti yare cahnorire ti niñeru ti ñʉ wihborire Cohamacʉ yaina yʉhdoro masica tina —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ã ni tuhsʉ Jesu õ sehe ni yahu namoha: —Ahri quitire ã ni yahucʉ, mʉsare õ sehe niita nija. Mʉsa cjʉaare, pjacʉoinare mʉsa wachʉ, tina sehe mʉsare cahĩahca. Mʉsa ã yoachʉ mʉsa cjʉaa pihtiari baharo mʉsa mʉanopʉ sʉchʉ mʉsare cahĩahca tópʉre. ");
INSERT INTO gvc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Wiho jiina ya dahraare quihõno yoana, pʉhtoa ya dahraa cʉ̃hʉre quihõno yoanahca. Wiho jiina ya dahraare quihõno yoaerana, pʉhtoa ya dahraa cʉ̃hʉre quihõno yoasi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ã jina ahri yahpai mʉsa cjʉaa mehne mʉsa noano yoaerana Cohamacʉ mʉsare to yoa dutia cʉ̃hʉre noano yoasi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ã jiro pairo yare mʉsa noano yoabasaerachʉ ñʉno mʉsa ya cjihtire wasi mʉsare. ");
INSERT INTO gvc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Cʉ̃iro Cohamacʉ sehere wacũno, tuabiaro niñeru sehere wacũerara. Niñeru sehere tuabiaro wacũno Cohamacʉ sehere wacũerara. Niñeru dihtare cahmariro jiro Cohamacʉre wahchechʉ yoaerara. Cohamacʉ cʉ̃hʉre, niñeru cʉ̃hʉre pʉarore cahma yʉhdʉrʉcahto basioerara mʉsare. Niñerure cahma yʉhdʉariro Cohamacʉre noano ño payo masierara —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","To ã nichʉ tʉhoa fariseo curua macaina sehe tirore bʉjʉpeha. Tina sehe niñerure cahĩha. Ã jia bʉjʉpeha. ");
INSERT INTO gvc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ti bʉjʉpechʉ tʉhoro Jesu tinare õ sehe ni yahuha: —Masa ti ñʉrocaroi mʉsa noano yoamana. Mʉsa ã yoachʉ “Noaina, quihõno yoaina jira”, nimana masa mʉsare. Cohamacʉ sehe mʉsa tʉhotuare masina. Masa “Noa yʉhdʉara”, ti nirire Cohamacʉ sehe soro ni tʉhotu, tíre ñʉ yabira —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ã ni tuhsʉ õ sehe ni namoha Jesu: —João masare bautisariro to jihto pano Moisere to cũri dutia mehne Cohamacʉ marine dutire. Cohamacʉ yare yahu mʉhtaina cjiri ti joari cjiri mehne cʉ̃hʉre marine dutire. Mipʉ sehere João to buhe dʉcari baharo noaa buheare, Cohamacʉ masare pʉhtoro to noano sʉho jia cʉ̃hʉre masi dʉcara masa. Ã masia masa ti mʉ sʉro ti tuaa mehne Cohamacʉ masare pʉhtoro to noano sʉho jirore sãa duamana. ");
INSERT INTO gvc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Moisere to cũri dutiai Cohamacʉ to niriro seheta yoa pahñonohca tiro. Cohamacʉ yare yahu mʉhtaina cjiri ti joari cjiripʉ cʉ̃hʉre to niriro seheta yoa pahñonohca tiro. Mʉano cʉ̃hʉ ahri yahpa cʉ̃hʉ ti pihtia wahapachʉta Cohamacʉ to niriro seheta yoa pahñonohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ã ni tuhsʉ õ sehe ni namoha Jesu: —Masʉno to namonore cohãno, pacorore namo tiro, tiro ticoro mehne ñano yoaro nina. Tuhsʉ, masʉno pairo to cohãricorore namo tiro, tiro cʉ̃hʉ ticoro mehne ñano yoaro nina —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ã yoa paye quiti mehne piti dahre yahuha Jesu: —Tí pjapʉre pache pʉro jiha. To suhti sehe wapa bʉjʉbiaha. Tuhsʉ, dachoripe tiro noaa dihtare chʉro, payʉ cjʉaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ã yoa tí pjare pairo pjacʉoriro, Lázaro wama tiriro jia tiha. Tiro to pjacʉ payʉ cami tiriro jiha. To ã jiriro jichʉ paina sehe tirore pache pʉro ya wʉhʉpʉ na sʉha. ");
INSERT INTO gvc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ã jiro pjacʉoriro sehe pache pʉro to chʉri mesa docai yahpai dujiro to chʉ site boroare chʉmaha. “To chʉ site boroare chʉcʉ yapicʉhca yʉhʉ”, ni tʉhotumaha tiro. Ã jia dieya to camine nehnea taa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Baharo pjacʉoriro to yariaa wahachʉ, Abrahã cahapʉ paraíso wama tiropʉ anjoa tirore naa mʉjaha. Pache pʉro cʉ̃hʉ to baharocãta yariaa wahaha. To yariachʉ tirore yaha. ");
INSERT INTO gvc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ã yoa pache pʉrore tuaro pichaca jʉ̃ha. To ã tuaro jʉ̃chʉ, pichacapʉ jiro mʉanopʉ jirirore Abrahãre ñʉha. Lázaro cʉ̃hʉre ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ñʉ tuhsʉ, tiro Abrahãre pisurocaha: “Coyeiro Abrahã, pja ñʉga yʉhʉre. Pichacapʉ yʉhʉ ñano yʉhdʉi nica. Yʉ ã wahachʉ Lázarore yʉhʉre warocaga. Tiro core to wamo picapʉ soha, yʉ ñahmanore co mehne nehojaro. Tóre yʉsʉojaro tiro”, niha pache pʉro. ");
INSERT INTO gvc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","To ã nichʉ Abrahã tirore õ sehe ni yahuha: “Coyeiro, catiriro jicʉ jipihtiare mʉhʉ noaare cjʉahre. Lázaro sehe dachoripe ñano yʉhdʉhre. Mipʉ sehere mʉhʉ ñano yʉhdʉchʉ tiro sehe õpʉre wahchea mehne jinocahno nina. ");
INSERT INTO gvc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ã yoa mari watoi cʉãri copa jira. Ã jia õre jiina tópʉre waha masierara. Tuhsʉ tóre jiina õpʉ ta duaina ta masierara”, niha Abrahã pache pʉrore. ");
INSERT INTO gvc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","To ã nichʉ pache pʉro õ sehe ni namoha: “Coyeiro, tuaro sinija mʉhʉre. Lázarore yʉ pʉcʉ ya wʉhʉpʉ warocaga. ");
INSERT INTO gvc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yʉhʉ cʉ̃ wamomaca pihtiina bahana tija. Lázaro tinare yahujaro. Tina õre ñano yʉhdʉropʉre taea tjijaro”, niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","To ã nichʉ Abrahã sehe õ sehe ni yʉhtiha: “Cohamacʉ dutiare Moise marine to cũri cjirire, Cohamacʉ yare yahu mʉhtaina ti joari cjirire cjʉara mʉ bahana. Ã jia mʉ bahana tíreta tʉhojaro”, niha Abrahã. ");
INSERT INTO gvc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","To ã nichʉ pache pʉro sehe yʉhtiha: “Coyeiro Abrahã, tíre cjʉapahta noano tʉhosi. Lázaro yariariro masariro tina cahapʉ to sʉchʉ ñʉa tina sehe ti ñaare cahya, noaare cohtotaahca. Ã jia noaare yoaahca yʉ bahana sehe”, niha pache pʉro cjiro. ");
INSERT INTO gvc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","To ã nichʉ Abrahã sehe õ sehe ni yahuha: “Mʉ bahana Moise to cũri pũ to yahuare, Cohamacʉ yare yahu mʉhtaina cjiri ti yahuare tʉhoeraina jira. Ã jia Lázaro yariariro cjiro masariro to jipachʉta tina Cohamacʉre tʉho duasi”, niha Abrahã —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ã yoa Jesu õ sehe ni yahuha to buheinare: —Masare ñano yoachʉ yoaa payʉ jira. Ã jia masa ñaare yoara. Ti ã jipachʉta masʉnore ñaare yoachʉ yoariro sehe ñabiaro yʉhdʉrohca. ");
INSERT INTO gvc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Masʉnore to wamʉai pjiria tãca dʉhte yo, pjiri mapʉ tirore ti cohãchʉ ñano wahaboa tiro. Pairo sehe ahrinacã mehne macarirocãre ñaare yoachʉ yoaro pjiri mapʉ ti cohãriro yʉhdoro ñano yʉhdʉrohca. Tirore tuaro buhiri dahrero cahmana. ");
INSERT INTO gvc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Noano yoaga mʉsa. Mʉsa coyeiro ñano to yoachʉ ñʉna “Yoai tjiga”, niga tirore. Ã jina tiro to ñaare cahyachʉ, noaare to cohtotachʉ mʉsa sehe to ñaa yoaare boga. ");
INSERT INTO gvc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ã yoa mʉsa coyeiro cʉ̃ dachoihta siete tahari mʉsare ñano to yoachʉ tópe tahari mʉsare, “Yʉ ñaare cahyaja. Pari turi ã yoasi”, to nichʉ tópe taharita to ñaa yoaare boga —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ã yoa Jesu buhe duti to cũina tirore õ sehe niha: —Cohamacʉre sãre noano wacũ tua namochʉ yoaga —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Mostaza yapacã mahari yapacã jiparota duropʉ pjidʉ wahara. To ã wahariro seheta Cohamacʉre pjíro wacũ tuana, õ sehe wahachʉ yoa masinahca mʉsa. Ahdʉ sicómoro wama tidʉre õ sehe ni masina: “Mʉhʉ yucʉcʉ mʉ basi duhtu wahcã, pjiri mapʉ bora ñojaga”, ni masina mʉsa. Mʉsa ã nichʉ tʉ yucʉcʉ sehe mʉsa dutiro seheta waharohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Baharo õ sehe ni buheha Jesu: —Mʉsare dahra cohtariro jiro wesepʉ tjana, ovejare ñʉ wihbora. ¿Dahra cohtariro to tju wihichʉ dohse nibocari mʉsa tirore? “Cjero taga. Mʉ chʉa õi jira”, ¿nibocari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ã nierara mʉsa. Tirore õ sehe nina mʉsa: “Yʉ chʉare doha cahnoga. Ã jicʉ yʉ chʉ sihnichʉ yʉhʉre cohtaga. Yʉ baharo mʉhʉ cʉ̃hʉ chʉ sihniga”, nina mʉsa dahra cohtarirore. ");
INSERT INTO gvc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dahra cohtariro mʉsa dutiare to yoachʉ tirore “Noana”, nierara mʉsa. To dahraa dihtare yoaro nica tiro. ");
INSERT INTO gvc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mʉsa cʉ̃hʉ tiro yoaro sehe tjira. Cohamacʉ to dutiriro seheta yoa pahñona õ sehe ni tʉhotuga mʉsa: “Sã cʉ̃hʉ dahra cohtaina dihta jija. Wiho jiina jija sã. Sã dahraa dihtare yoaja sã”, ni tʉhotuga mʉsa —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pa dacho Jerusalẽpʉ Jesu waharo niha. Tópʉ waharo Samaria yahpa, Galilea yahpa dacho macai yʉhdʉ wahcãha. ");
INSERT INTO gvc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Pa macapʉ wahari mahapʉ to tinichʉ diez cami baaina sehe tirore piti bocaha. Ã jia tina yoa cureropʉ ducuata pisuha: —Jesu, pʉhtoro, sãre pja ñʉga —niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ti ã nichʉ tinare ñʉ, õ sehe ni yahuha Jesu: —Sacerdotere mʉsa pjacʉrire noaa pjacʉri ti waharire ñona wahaga —niha tinare. To ã niri baharo ti waharo watoi tina ti pjacʉri noaina wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ã jiro cʉ̃iro tina mehne macariro noano to pjacʉ wahachʉ ñʉno, Jesu cahapʉ majare tjuaha. Ã tjuaro tuaro mehne Cohamacʉre ño payoha. “Cohamacʉ tuariro, noariro jira”, tuaro ni, ño payoha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ã nino tiro Jesu dahpori cahai na tuhcua caha sʉ, “Noana”, niha tiro. Tiro sehe Samaria macariro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","To ã yoari baharo Jesu õ sehe ni yahuha: —Diez jihre masa noaina wahaina. ¿Paina nueve dʉhsaina sehe nohopʉ jicari tina? ");
INSERT INTO gvc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ahriro pa yahpa macariro dihta Cohamacʉre “Noana”, nino taro tjua tahre. ¿Dohse yoa paina taerari? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ã ni tuhsʉ Jesu õ sehe ni yahuha na tuhcua caha sʉrirore: —Wahcãrʉcaga. Wahaga. Mʉhʉ Cohamacʉre wacũ tuacʉ, noariro wahahre mʉhʉ —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tí pjare mahainacã fariseo curua macaina Jesure õ sehe ni sinituha: —¿Dohse jichʉ pʉhtoro Cohamacʉ masare sʉho ji dʉcarohcari? —niha tina. Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Cohamacʉ masare pʉhtoro to noano sʉho ji dʉcachʉ masa ñʉ masierara. ");
INSERT INTO gvc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Cohamacʉ masare pʉhtoro to noano sʉho jia õi jira”, ni masierara. “Sohõpʉ jira”, ni masierara. Cohamacʉ masare pʉhtoro to noano sʉho jia masa ti tʉhotuapʉ jira —niha Jesu fariseo curua macainare. ");
INSERT INTO gvc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ã ni tuhsʉ Jesu to buheinare õ sehe ni yahuha: —Baharo yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉ yʉ tjua tahtore tuaro cahmanahca mʉsa. Cʉ̃ dachoihta yʉhʉre ñʉ duapanahta yʉhʉre ñʉsi mʉsa. Mʉsa yʉhʉre ã ñʉ duapachʉta tí pjare tasi yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Paina mʉsare õ sehe niahca: “Tirore ñʉga. Tiro Cristo jira. Ahrirore ñʉga. Ahriro Cristo jira”, niahca mʉsare. Ti ã nipachʉta tinare tʉhoena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Oroca sitero wacũenoca to oroca sitero seheta yʉhʉ cʉ̃hʉ masʉno Cohamacʉ warocariro wacũenoca tjua taihca. ");
INSERT INTO gvc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ã yʉ tjua tahto pano yʉhʉ tuaro ñano yʉhdʉihca. Ã jia yʉhʉre mipʉ macaina cahmasi. ");
INSERT INTO gvc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé to jiri pja macaina ti jiriro seheta yʉhʉ masʉno Cohamacʉ warocariro yʉ tjua tachʉ tó seheta jiahca masa. ");
INSERT INTO gvc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé to jiri pjare jipihtina masa ã chʉrucua tiha. Ã yoa sihnirucua tiha. Ã jia mʉa numiare namo tia tiha. Noé pjiria dohoriapʉ to samuhto pano Cohamacʉ tinare to miohto pano tí jipihtiare masa yoarucua tiha. Tó seheta jirohca pari turi yʉ tjua tachʉ cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lote to jia tiri pja macaina ti jiriro seheta yʉ tjua tachʉ jiahca masa. Lote to jia tiri pjare masa chʉ, sihni, nuchʉ, dua, weserire toaa, wʉhʉse yoaha. ");
INSERT INTO gvc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ti ã yoaro watoi Sodoma wama tiri macai jiriro Lote to wahari dachoi mʉano macaa pichaca, picha sohãa poca tãa peri cʉ̃hʉ coro taro seheta tina bui bora ta, tinare wajã pahñonocaa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yʉhʉ masʉno Cohamacʉ warocariro wacũenoca yʉ tjua tachʉ tina yoaro seheta yoaina jiahca masa tí pjare. ");
INSERT INTO gvc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Tí pjare cʉ̃iro to wʉhʉ bui macari wapapʉ jiriro wʉhʉ puhichapʉ to ya jichʉ tíre nano sãaeno tjijaro to waha bahrañohto sehe. Tuhsʉ, wesepʉ jiriro cʉ̃hʉ tí pjare to wʉhʉpʉ piha taero tjijaro to waha bahrañohto sehe. ");
INSERT INTO gvc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lote namono to waharire wacũga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Masʉno yʉhʉre wacũno marieno to mʉ sʉro to cahmano seheta yoaro pichacapʉ waharohca. Yʉ yare ã yoarucuriro sehe jipihtia dachoripe yʉhʉ mehne mʉanopʉ jirucurohca. ");
INSERT INTO gvc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Tí ñamine pʉaro cʉ̃ casario bui carĩinare cʉ̃iro yʉhʉre cahmarirore naaihca. Tuhsʉ, yʉhʉre cahmaerariro tói tjuarohca. ");
INSERT INTO gvc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tí pjare pʉaro numia cʉ̃noi ti trigore arẽa numiare cʉ̃coro yʉhʉre cahmaricorore naaihca. Tuhsʉ, yʉhʉre cahmaeraricoro tóihta tjuarohca. ");
INSERT INTO gvc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ã yoa wesepʉ pʉaro dahraina ti jichʉ cʉ̃irota naihca. Cʉ̃iro tói tjuarohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","To ã nichʉ to buheina sehe õ sehe ni sinituha tirore: —¿Nohopʉ ã waharohcari? —ni sinituha tina. Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Yucaare mari ñʉna, yariariro to pjacʉ cjiro jichʉ mari noano masinahca. (Tó seheta ahri mʉsare yʉ yahuyurire mʉsa ñʉna noano masinahca ahri yahpapʉ yʉ tjua tahto mahanocã to dʉhsachʉ cʉhʉ̃re) —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ã yoa Jesu tinare Cohamacʉre siniare yahuro õ sehe niha: —Mʉsa Cohamacʉre sinina, cohtaga to yʉhtihtore. Yoari pja cohtapanahta cahyaena tjiga. Tirore sinina duhuena tjiga —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","To ã nirire buhero taro ahri quiti mehne piti dahre yahuha tinare: —Pa macapʉ ti buhiri dahre dutiriro jiha. Tiro Cohamacʉre ño payoeraha. Ã yoa masa cʉ̃hʉre ño payoeraha. ");
INSERT INTO gvc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wapewahyoro cʉ̃hʉ tópʉ jiha. Ticoro tiro cahapʉ sʉroca majareno õ sehe niha: “Yʉhʉre ñʉ tuhtirirore buhiri dahre dutiga mʉhʉ. Yʉhʉre ni dʉcataga”, ni sinirucuha ticoro tirore. ");
INSERT INTO gvc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","To ã nichʉ payʉ tahari tiro “Yoasi yʉhʉ”, nimaha ticorore. To ã nipachʉta ticoro payʉ tahari ã sinirucuro tirore caribobiaro yoaha. To ã caribochʉ, tiro õ sehe niha to basi: “Yʉhʉ Cohamacʉre, masa cʉ̃hʉre ño payoeraja. ");
INSERT INTO gvc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yʉ ã ño payoerariro yʉ jipachʉta ahricoro sehe yʉhʉre caribobiara. Yʉhʉre ã cariboro yʉhʉre pomea wahachʉ yoarohca ticoro. To ã ni yahusãrucuchʉ ticorore ñʉ tuhtirirore buhiri dahre dutiihtja”, niha buhiri dahre dutiriro —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ã nino Jesu tinare õ sehe ni yahu namoha: —Ã niha tiro ñariro buhiri dahre dutiriro. To niri cjirire wacũga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tiro yʉhdoro Cohamacʉ sehe to yainare to beseinare ñamipʉ cʉ̃hʉre, dachopʉ cʉ̃hʉre tirore sinirucuinare yʉhtiro, yoadohorohca. ");
INSERT INTO gvc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mʉsare niita nija. Cohamacʉre ti siniriro seheta dóicãta tinare yoadohorohca. ¿To ã yʉhtiriro to jipachʉta yʉhʉ masʉno Cohamacʉ warocariro ahri yahpapʉ tjua tacʉ Cohamacʉre wacũ tuainare bocabocari yʉhʉ? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ã yoa pari turi piti dahre buhero õ sehe ni yahuha Jesu: “Sã sehe noaina jija. Paina sehe ñano yoaina jira”, ni tʉhotuina barore Jesu õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Cohamacʉ ya wʉhʉpʉ pʉaro mʉa Cohamacʉre sinia wahaha. Cʉ̃iro fariseo curua macariro jiha. Pairo pʉhtoa yare wapa na cohtariro jiha. ");
INSERT INTO gvc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ã yoa fariseo curua macariro sehe wahcãrʉcʉ sʉ, õ sehe ni yahuha Cohamacʉre: “Cohamacʉ, yʉhʉ paina yare mahñopea mehne nariro, ñano yoariro, paina namosãnumia mehne wʉana tiriro ne jieraja. Paina yoaro sehe ñariro jieraja. Ahriro wapa na cohtariro yoaro sehe ñariro ne jieraja yʉhʉ. Ã jicʉ mʉhʉre ‘Noana’, nija Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yʉhʉ somanaripe pʉa dachore ne chʉeraja, mʉ yare yoacʉ tacʉ. Tuhsʉ jipihtia dohse jiape yʉ wapataa cʉ̃hʉre mahano (diezmo) wa mʉjaja yʉhʉ mʉhʉre ño payocʉ”, niha fariseo curua macariro Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ã yoa wapa na cohtariro sehe yoa cureropʉ muhri yo dʉcʉ sʉ, mʉanopʉre ñʉ mʉoeraha. Ã ñʉ mʉoeraro, to pẽbuhui cjãroca õ, õ sehe ni siniha Cohamacʉre: “Cohamacʉ, yʉhʉ ñaare yoariro jija. Ã jicʉ mʉhʉ pja ñʉga yʉhʉre”, niha tiro Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mʉsare niita nija. Ahriro wapa na cohtariro sehe Cohamacʉ to ñʉchʉ buhiri marieriro to ya wʉhʉpʉ tjuaa wahaha. Wiho mejeta pairo fariseo curua macarirore “Mʉ ñaa buhirire cohãhi”, nieraha Cohamacʉ. “Yʉhʉ noariro waro jija”, ni tʉhoturirore Cohamacʉ bʉoro dahrerohca. Wiho mejeta “Yʉhʉ ñaare yoariro jija. Ã jicʉ tíre tuaro cahyaja” nirirore Cohamacʉ wahchechʉ yoarohca tiro sehere —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ã yoa masa ti pohnare wihãinacãre Jesure ña payo dutia ta, to cahapʉ na wihimaha. Ti ã yoachʉ ñʉa Jesu buheina tinacãre na wihiinare tuhtiha. ");
INSERT INTO gvc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ti ã tuhtichʉ ñʉno Jesu wihãinacãre pjirocaha to cahapʉ. Pjiroca tuhsʉ õ sehe niha tiro to buheinare: —Macanacã yʉ cahapʉ tajaro. “To cahai wahaena tjiga”, niena tjiga tinacãre. Tinacã Cohamacʉre ti pʉhtoro tʉhotura. Pʉhtoro Cohamacʉ to sʉho jiina ahrinacã yoaro sehe tʉhotuina baro dihta jira. ");
INSERT INTO gvc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Potocã niita nija mʉsare. Ahrinacã Cohamacʉ ti pʉhtoro cjihtore cahmana. Ti yoaro seheta mʉsa cʉ̃hʉ Cohamacʉ mʉsa pʉhtoro cjihtore cahmaerana, pʉhtoro Cohamacʉ to noano sʉho jihtina ne jisi mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","To ã niri baharo judio masa pʉhtoa mehne macariro Jesure õ sehe ni sinitu ñʉha: —¿Ne noariro, buheriro, jipihtia dachoripe Cohamacʉ mehne ji duacʉ, dohse yoaihcari yʉhʉ? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","To ã nichʉ Jesu õ sehe ni yʉhtiha: —¿“Noariro”, ni pisujari mʉhʉ yʉhʉre? Noariro sehe Cohamacʉ dihta jira. ");
INSERT INTO gvc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ahri Cohamacʉ dutiare masina mʉhʉ. “Numia mehne ñano yoaecʉ tjiga. Masare wajãecʉ tjiga. Yacaecʉ tjiga. Mahñoa mehne pairore yahusãecʉ tjiga. Mʉ pʉcʉsʉmare ño payoga”, ni dutira Cohamacʉ —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","To ã nichʉ tiro Jesure õ sehe ni yʉhtiha: —Tíre jipihtiare yʉ wahma wahmʉa tariro jiipʉta yʉhdʉrʉcaera tihi yʉhʉ —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","To ã nichʉ tʉhoro, Jesu tirore õ sehe ni yahuha: —Mahanocã dʉhsara mʉhʉre mʉ yoa pahñohto. Jipihtiare mʉ yare duai wahaga. Ã yoacʉ jipihtia mʉ wapatari niñerure pjacʉoinare waga. Mʉ ã yoachʉ pjíro mʉ wapataa mʉanopʉ, Cohamacʉ cahapʉ jiyuahca. Mʉ ã yoari baharo yʉhʉ mehne macariro cjihto taga —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","To ã nichʉ tʉhoro tiro sehe payʉ pache cjʉariro jiro tíre pjacʉoinare wa duaeraro, tuaro cahya, wahaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","To ã cahyachʉ ñʉno Jesu õ sehe ni yahuha painare: —Pache pʉa Cohamacʉ masare pʉhtoro to noano sʉho jiropʉre ti wahachʉ basioera curera. ");
INSERT INTO gvc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camello sehe awicã copacãre to sãa nuhri wijaa duachʉ basioerara. To ã jiro yʉhdoro pache pʉro pʉhtoro Cohamacʉ noano to sʉho jiropʉre to waha duachʉ nu mijobiara —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","To ã nichʉ tirore tʉhoina õ sehe niha: —Cue, mʉ nino seheta potocã jichʉ, ne cʉ̃iro masʉno Cohamacʉ cahapʉ waha masieraboca —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Masa ti basi ti mʉ sʉro yʉhdʉ masierara. Wiho mejeta Cohamacʉ sehe masare pichacapʉ wahaborinare yʉhdo masina. Tiro jipihtiare noano yoa masi pahñoriro jira —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","To ã nichʉ Pedro tirore õ sehe niha: —Tʉhosiniga. Sã sehe jipihtia sã yare cũnocaa tii mʉhʉ mehne wahana —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","To ã nichʉ Jesu õ sehe niha: —Potocã mʉsare niita nija. Mʉsa Cohamacʉ yare yoana tana mʉsa wʉhʉsere, mʉsa namosãnumiare, mʉsa bahanare, mʉsa pʉcʉsʉmare, mʉsa pohnare cũnocarina jina, pjíro wapatanahca mʉsa mipʉre. ");
INSERT INTO gvc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mʉsa cũriro yʉhdoro wapatanahca. Ã jina mʉsa yariari baharo jipihtia dachoripe Cohamacʉ mehne jirucunahca mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ã yoa Jesu doce to buheinare ti sahsero naaha. Ã naano tinare õ sehe ni yahuha: —Tʉhoga yʉhʉre. Mipʉre mari Jerusalẽpʉ wahana nija. Tópʉ yʉhʉre masʉnore Cohamacʉ warocarirore Cohamacʉ yare yahu mʉhtaina cjiri panopʉ ti yahuriro cjiro seheta paina ã yoaahca yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tópʉ masa yʉhʉre ñahaa, judio masa jieraina sehere waahca yʉhʉre. Yʉhʉre ti wari baharo tina yʉhʉre bʉjʉpe, ñano ni, yʉhʉre chahcho puti sihõahca. ");
INSERT INTO gvc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tuhsʉ, yuta dari mehne tjana tuhsʉ wajãahca yʉhʉre. Ti ã wajãri baharo tia dacho wahaboroi masa wijaaihca yʉhʉ —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","To ã nichʉ to buheina to yahuare noano tʉho ñahaeraha. Cohamacʉ tíre tinare noano tʉho ñahachʉ yoaerasiniha. ");
INSERT INTO gvc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ã yoa Jesu cʉ̃hʉ Jericó wama tiri maca cahacãpʉ sʉha. Tói capari ñʉerariro maha dʉhtʉ cahai duji, niñerure sinino niha. ");
INSERT INTO gvc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ã jiro masa payʉ to cahai ti yʉhdʉachʉ tʉhoro tiro sinituha tinare: —¿Dohse yoaa payʉ masa yʉhdʉjari? —ni sinituha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Jesu Nazare macariro waharo nina —ni yahuha paina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ti ã ni yahuchʉ tʉhoro tiro õ sehe ni sañurucuha: —Jesu, Davi cjiro panamino masare yʉhdohtiro, yʉhʉre pja ñʉga —ni sañurucuha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","To ã nichʉ to pano waha mʉhtaina sehe, “Dihta mariahga”, ni tuhtiha tirore. Ti ã ni tuhtipachʉta tó pano to sañurucuriro yʉhdo curero sañurucu namoha tjoa: —Davi cjiro panamino masare yʉhdohtiro, yʉhʉre pja ñʉga —ni sañurucuha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","To ã ni sañurucuchʉ tʉhoro, Jesu sehe tjuarʉcʉ sʉ, “Pjirocaga tirore”, niha. To ã nichʉ tina sehe capari ñʉerarirore pji wahcãha. Ti ã pji wahcãchʉ tiro Jesu cahapʉ to sʉchʉ Jesu sehe tirore õ sehe ni sinituha: ");
INSERT INTO gvc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Dohse yʉ yoachʉ cahmajari mʉhʉ? —niha Jesu tirore. —Yʉ pʉhtoro, yʉhʉre ñʉchʉ yoaga —ni yʉhtiha capari ñʉerariro. ");
INSERT INTO gvc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Ñʉga. Yʉhʉre wacũ tuacʉ, noariro wahara mʉhʉ —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","To ã nichʉta capari ñʉerariro ñʉa wahaha. Ã noariro waharo, tiro Jesu mehne waha, “Cohamacʉ tuariro jira”, niha tiro. Ã jia masa payʉ capari ñʉerariro to ñʉchʉ ñʉa “Cohamacʉ noariro, tuariro jira”, niha tina cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ã yoa Jesu Jericópʉ sʉ, tí macapʉ yʉhdʉ wahcãno taro niha. ");
INSERT INTO gvc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pache pʉro Zaqueo wama tiriro pʉhtoa ya cjihtire wapa na cohtaina pʉhtoro tói jiha. ");
INSERT INTO gvc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ã jiro tiro Jesure “¿Diro baro jicari?” ni ñʉ masino taro Jesure ñʉ duamaha. Ã to ñʉ duapachʉta yahparirocã to jichʉ masa payʉ tirocãre dʉcataha. ");
INSERT INTO gvc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ã jiro tiro masare mʉroca yʉhdʉa waha, sicómoro wama tidʉ yucʉcʉpʉ mʉjaha Jesure ñʉno taro. Baharo curero tʉ cahai Jesu yʉhdʉaro taro niha. Ã jiro Zaqueo tʉi cohtaro niha. ");
INSERT INTO gvc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","To ã cohta pisaro watoi Jesu sehe tʉ dahpotoi sʉrʉca, Zaqueore ñʉroca mʉo, tirore õ sehe niha: —Zaqueo mipʉre mʉ wʉhʉi tjuasiniihtja yʉhʉ. Ã jicʉ cjero duji taga —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","To ã nichʉ Zaqueo sehe soaro mehne duji ta, tuaro wahchea mehne to wʉhʉpʉ pji wahcãha Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","To ã ni piti bocachʉ ñʉa, jipihtina masa ti basi õ sehe ni durucuha: —Ahriro Jesu ñaare yoariro ya wʉhʉpʉ tinino waha duara —ni durucuha jipihtina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo sehe piti boca tuhsʉ tói ducu, Jesure õ sehe ni yahuha: —Pʉhtoro tʉhoga yʉhʉre. Jipihtia yʉ yare dacho macai pjacʉoinare waihtja. Ã jicʉ yʉhʉ pairore cien niñeru tʉrire mahño mariro jicʉ, cuatro cientos niñeru tʉrire wapa bui payoihtja tirore —niha Zaqueo Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","To ã nichʉ Jesu sehe õ sehe ni yahuha tirore: —Michare mʉhʉre mʉ wʉhʉi jiina cʉ̃hʉre pichacapʉ wahaborinare Cohamacʉ yʉhdo tuhsʉra. Mʉhʉ cʉ̃hʉ Abrahã cjiro coyeiro jira. ");
INSERT INTO gvc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yʉhʉ masʉno Cohamacʉ warocariro pichacapʉ wahaborinare macai tai nii. Tópʉ wahaborinare noano yʉhdoi tai nii —niha Jesu Zaqueore. ");
INSERT INTO gvc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ã yoa tirore tʉhoinare Jesu paye quiti mehne piti dahre yahuha. Mahanocã dʉhsaha Jerusalẽpʉ to sʉhto. Ã jia tirore tʉhoina õ sehe ni tʉhotuha: “Pʉhtoro Cohamacʉ mipʉre sʉho ji dʉcaro taro nina”, ni tʉhotuha tina. ");
INSERT INTO gvc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ti ã ni tʉhotuchʉ Jesu õ sehe ni yahuha tinare: —Cʉ̃iro pʉhtoro sãahtiro to ya yahpa macaina bui pʉhtoro jihtiro yoaropʉ waharo taro niha. Tópʉre to sʉchʉ ñʉno ti bui pʉhtoro tirore pʉhtoro sõno taro niha. Pʉhtoro sãahtiro ya maca macaina bui pʉhtoro sõno taro niha tirore. Baharo to ya wʉhʉpʉ tju wihiro taro niha. ");
INSERT INTO gvc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wahmanore to wahahto pano pʉhtoro diez dahra cohtainare pjirocaha. Ã pjirocaro, tiro tinare cãinare típe tʉri niñeru tʉri wapa bʉjʉa tʉri uru tʉrire waha. Wa tuhsʉ, õ sehe ni yahuha tinare: “Yʉhʉ yʉ mariachʉ ahri niñeru mehne mʉsa wapata namohtire macaga”, niha tiro dahra cohtainare. ");
INSERT INTO gvc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pʉhtoro sãahtiro to jipachʉta to ya maca macainata tirore cahmaeraha. Ã cahmaeraa, ti warocahtinare tirore pʉhtoro sõhtirore yahu dutia warocaha. “Ahriro sã pʉhtoro jichʉ cahmaeraja sã”, niha tina ti yahu duti warocaina sehe. ");
INSERT INTO gvc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ã ti cahmaerapachʉta baharo ti pʉhtoro sãaha tiro. Ã pʉhtoro sãa tuhsʉro tiro to wʉhʉpʉ tjua taha. Ã tju wihiro tiro dahra cohtainare to niñeru mehne ti wapata namoare masino taro, tinare pjirocaha. ");
INSERT INTO gvc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","To pjirocari baharo, wihi mʉhtariro tirore yahuha: “Pʉhtoro mʉ niñeru tʉ, yʉhʉre mʉ wari tʉ mehne diez tʉri wapata namohi yʉhʉ”, niha dahra cohtariro to pʉhtorore. ");
INSERT INTO gvc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Noano yoari jire mʉhʉ. Mʉhʉ noariro dahra cohtariro jira. Mʉhʉ mahanocã mehne yʉ dutiriro seheta yoa pahñoriro jicʉ mipʉ diez macari macaina ti pʉhtoro cjihto wahaihca mʉhʉ”, niha pʉhtoro dahra cohtarirore. ");
INSERT INTO gvc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","To baharo wihiriro tiro mehne macariro õ sehe niha: “Pʉhtoro, mʉ niñeru tʉ, yʉhʉre mʉ wari tʉ mehne cinco tʉri wapata namohi yʉhʉ cʉ̃hʉ”, ni yahuha to pʉhtorore. ");
INSERT INTO gvc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Cinco macari macaina pʉhtoro cjihto wahaihca mʉhʉ”, niha pʉhtoro tirore. ");
INSERT INTO gvc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","To ã niri baharo pairo dahra cohtariro wihi, õ sehe ni yahuha: “Pʉhtoro, mʉ niñeru tʉ õi jira. Suhtiro cahsaro mehne coma, tí tʉre wihbohi. ");
INSERT INTO gvc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉhʉ tuaro dahra dutiriro jira. Paina yare mana mʉhʉ. Tuhsʉ, tuaro dahra dutiriro jicʉ dahraerariro jipacʉta mʉhʉ paina ya dahrari wapare nana. Ã yoa toaerariro jipaihta dichare nariro jira mʉhʉ. Ã jicʉ mʉhʉre cui nihi”, niha to pʉhtorore “Wapataerahi yʉhʉ”, ni yahuro. ");
INSERT INTO gvc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mʉhʉ ã nicʉ ñano yoariro jira mʉhʉ. Yʉhʉre mʉ ã niri buhiri mʉhʉre buhiri dahreihtja yʉhʉ. Yʉhʉ mʉhʉre tuaro dahra dutiriro yʉ jichʉ masina mʉhʉ. Paina yare yʉ nachʉ toaerariro jipai dichare nariro yʉ jichʉ masina mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yʉ ã jiriro jichʉ ñʉpacʉta ya tʉre niñeru wihbori wʉhʉpʉ cũerare mʉhʉ. Tíre ti wasori wapa wapata namoboa mʉhʉ. ¿Dohseacʉ ã yoaerari mʉhʉ? Tíre mʉ yoachʉ tju wihicʉ wapata namoboa yʉhʉ”, niha ti pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ã ni tuhsʉ tiro cahai ducuinare dutiha: “Niñeru tʉre maga tirore. Diez tʉrire cjʉarirore waga”, niha pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","To ã nichʉ tina sehe õ sehe ni yahuha tirore: “Pʉhtoro, diez tʉri cjʉariro payʉ cjʉa tuhsʉra”, niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ti ã nichʉ pʉhtoro õ sehe ni yʉhtiha: “Mʉsare niita nija. Jipihtina cjʉainare wa namoihtja. Cjʉaerariro sehere mahanocã to cjʉapachʉta tíre maihtja. ");
INSERT INTO gvc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mipʉ pinihta yʉhʉre ñʉ tuhtiinare yʉhʉre ti pʉhtoro ji dutierainare yʉ cahai na tahga. Ã yoana yʉ ñʉrocaroi wajãga tinare”, niha pʉhtoro dahra cohtainare —ni buheha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ã ni tuhsʉ Jesu paina pano Jerusalẽpʉ wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ã yoa tina Jerusalẽpʉ ti sʉhto panocã tʉ̃cʉ Olivo wama tidʉ dʉhtʉ cahai jiri maca Betfagé wama tiri maca cahai, ã jichʉ Betania wama tiri maca cahai sʉ mʉhtaha. Tí macari pʉa maca cahai Jesu sʉro, to buheina pʉarore warocaro taro, õ sehe ni yahu quihõha: ");
INSERT INTO gvc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Sí macapʉ burrocãre nana wahaga. Tópʉ sʉna, burrocãre ti dʉhte daporirocãre boca sʉnahca. Tiro ne cʉ̃iro ti pisamahnoerarirocã jica. Tirocãre bocana, yuta dare pjã, na tabasaga yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tirocãre mʉsa pjãchʉ ñʉno, cʉ̃iro dohse jiriro “¿Dohse yoana tana burrocãre dʉhte dapori dare pjãjari mʉsa?” to nichʉ tʉhona õ sehe ni yʉhtiga tirore: “Mari pʉhtoro burrocãre cahmarocasinire”, ni yahuga tirore —ni yahu duti warocaha to buheina pʉarore. ");
INSERT INTO gvc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","To ã nichʉ tina pʉaro sehe to niriropʉ sʉha. Ti ã sʉchʉ jipihtia Jesu to niriro seheta wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ã jia tina tirocãre ti pjãchʉ ñʉa tirocã pʉa tinare õ sehe ni sinituha: —¿Dohse yoana tana burrocãre dʉhte dapori dare pjãjari mʉsa? —ni sinituha tina. ");
INSERT INTO gvc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Mari pʉhtoro burrocãre cahmarocasinire —ni yʉhtiha tina. ");
INSERT INTO gvc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ã ni yahu tuhsʉ tirocãre Jesu cahapʉ na sʉha. Na sʉ tuhsʉ ti bui sãa suhtire tirocã bui pjũpaha payo tuhsʉchʉ ñʉ, Jesu sehe tirocã bui to mʉja pjachʉ yoadohoha tina. ");
INSERT INTO gvc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesu tirocã bui to pisachʉ to wahahto pano masa ti bui sãa suhtire tjuwe na, to wahahti mahai saño cũ mʉhtaha, Jesure ño payoa. ");
INSERT INTO gvc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tina Jerusalẽ cahacãpʉ sʉ, Olivo wama tidʉi dujiari mahapʉ sʉha. Tópʉ Jesu to buhechʉ tʉhoina payʉ jipihtia Cohamacʉ tuaa mehne to yoa ñorire, noaa to yoarire ti ñʉri cjirire wacũa, Cohamacʉre “Noariro, tuariro jira”, ni sañurucuha. Ã yoa Cohamacʉre ño payoa, õ sehe ni sañurucuha: ");
INSERT INTO gvc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Ahriro Cohamacʉ to warocariro, mari pʉhtoro noano jijaro. Mʉano macaina noano jijaro. Mʉano macariro Cohamacʉ, mʉhʉ tuariro waro jira —ni ño payoha tina. ");
INSERT INTO gvc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ti ã nichʉ tʉhoa fariseo curua macaina mahainacã ti watoi jiina Jesure õ sehe ni yahuha: —Buheriro, mʉ buheinare dihta mariea dutiga —niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Mʉsare niita nija. Tina ti sañurucuerachʉ tãa peri sehe sañurucuboa —niha Jesu fariseo curua macainare. ");
INSERT INTO gvc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ã ni tuhsʉ Jesu Jerusalẽ cahacãpʉ sʉ, tí macare ñʉrocaro, tiiha. ");
INSERT INTO gvc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Õ sehe niha tiro: —Jerusalẽ macaina mipʉ pinihtare mʉsare pichacapʉ wahaborinare Cohamacʉ to yʉhdohtore mʉsa masichʉ noa yʉhdʉaboa. Ã jipachʉta mipʉre mʉsa tíre ne tʉho duaerare. Ã jiro Cohamacʉ tíre mʉsare masi dutierare. ");
INSERT INTO gvc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mʉsare ñʉ tuhtiina mʉsa jiri macare soroahca. Ã yoaa mʉsare tina wijaaro wasi. ");
INSERT INTO gvc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tí pjata tina mʉsa ya macare cohã pahñoahca. Mʉsa cʉ̃hʉre wajãahca. Mʉsare ñʉ tuhtiina noano cohã pahñoahca mʉsa ya macare. Cohamacʉ pichacapʉ wahaborinare mʉsare to yʉhdohtore mʉsa masi duaerare. Mʉsa masi duaerari buhiri mʉsare ñʉ tuhtiinare Cohamacʉ mʉsare cohã dutirohca —niha Jesu Jerusalẽ macainare. ");
INSERT INTO gvc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ã yoa Jerusalẽpʉ sʉro, Jesu Cohamacʉ wʉhʉpʉ sãa wahaha. Ã yoaro pache duainare tí wʉhʉpʉ jiinare boca sʉro, tinare cohã wionocaha. ");
INSERT INTO gvc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Õ sehe niha tiro tinare: —Õ sehe nina Cohamacʉ yare ti joari pũi: “Yʉ wʉhʉ Cohamacʉ mehne durucuri wʉhʉ wama tirohca”, niha to yare ti joari pũi. To ã nipachʉta mʉsa sehe ahri wʉhʉi duana, mʉsa basi cahma yacara mʉsa —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ã yoa dachoripe Cohamacʉ wʉhʉpʉ Jesu buheha. Ã jia sacerdotea pʉhtoa, judio masare buheina, masa pʉhtoa cʉ̃hʉ tirore ti wajãhti cjihtire wacũ macaha. ");
INSERT INTO gvc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Masa jipihtina tirore ã tʉhorucua, to buheare noano tʉho nʉnʉina jiha. Ti ã noano tʉho nʉnʉchʉ ñʉa, Jesure wajã duaina sehe tirore ti wajãhtire bocaerasiniha. ");
INSERT INTO gvc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pa dachoi Cohamacʉ wʉhʉi Jesu masare noaa buheare buhero niha. To ã buhechʉ sacerdotea pʉhtoa, judio masare buheina, bʉcʉna mehne tiro cahapʉ wihia, tirore õ sehe ni sinitu ñʉha: ");
INSERT INTO gvc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Yahuga sãre. ¿Dohseacʉ canʉre ã yoari mʉhʉ? ¿Noa mʉhʉre tíre ã yoa dutiri? —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ti ã nichʉ Jesu õ sehe ni yʉhtiha tinare: —Mʉsa sehere sinitu mʉhtaihtja. Yahuga yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿João masare to bautisachʉ diro baro sehe tirore bautisa dutia tiari, mʉsa tʉhotuchʉ? ¿O Cohamacʉ dutiera tiari? ¿O masa sehe dutia tiari, mʉsa tʉhotuchʉ? —ni sinituha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","To ã nichʉ tina sehe ti basi õ sehe niha: —¿Dohse ni yʉhtinahcari mari? “Cohamacʉ Joãore dutia tiri jire”, mari nichʉ, “¿Dohseana Cohamacʉ Joãore to dutipachʉta tirore tʉho duaerari mʉsa?” niboca Jesu marine. Ã jina “Cohamacʉ Joãore dutia tiri jire”, ni yʉhti masieraja mari. ");
INSERT INTO gvc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ahrina masa sehe “Potocãta João Cohamacʉ yare yahu mʉhtariro jira”, ni tʉhotura tina. Ã ni tʉhotua “João to bautisachʉ Cohamacʉ tirore dutierari jire”, mari nichʉ tʉhoa marine tãa mehne docaboca masa. Ã jina tí cʉ̃hʉre yahu masieraja mari —ni durucuha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ã ni durucu tuhsʉa tina Jesure õ sehe ni yʉhtiha: —Joãore bautisa dutirirore sã masieraja —niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Tí pja pinihta yʉhʉ cʉ̃hʉ mʉsa sinitu mʉhtarire yahueraja mʉsare. Ahrire yʉ yoarire dutirirore yahueraja mʉsare —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ã yoa Jesu to tʉhotua mehne piti dahre õ sehe ni buhe dʉcaha masare: —Wese pʉro se dari cjihtire toaha. Toa tuhsʉ, tí wesere painare cʉ̃ bʉhʉsehe coa pahma cũha. Pahma cũno tí wesere tinare ñʉ wihbo dutiha. Ã duti tuhsʉ pa yahpapʉ waha, yoari pja bajueraha. ");
INSERT INTO gvc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tuhsʉ, se ñiri pja jichʉ wese pʉro to cahamacʉnore wesere ñʉ wihboina cahapʉ warocaha. Wese macaa to toaa dichare to ya coa macaare na dutiro warocamaha. Ã jia ñʉ wihboina sehe to cahamacʉnore wiho piti boca cjãnocaha tirore. Ã cjãnocaa, tina tirore dichare waerapahta tjuaa dutiha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ã jiro wese pʉro pairo to cahamacʉnore tí wese macaa toaa dichare na dutiro warocamaha tjoa. Ã jia wesere ñʉ wihboina tiro cʉ̃hʉre cjã, ñano yoaha. Ã yoa tuhsʉ tirore tí dichare waerapahta tjuaa dutiha tjoa. ");
INSERT INTO gvc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tirore ti ã yoari baharo wese pʉro pairo cahamacʉnore warocamaha tjoa. To ã warocachʉ ñʉa, wesere ñʉ wihboina sehe tiro cʉ̃hʉre cami dahre, tí wese dʉhtʉ cahai cohãnocaha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ti ã yoari baharo wese pʉro õ sehe ni tʉhotumaha: “¿Dohse yoaihcari yʉhʉ? Õ sehe yoaihtja. Yʉhʉ yʉ macʉre yʉ cahĩrirore warocaihtja. Tina tirore ño payoboca”, ni tʉhotumaha wese pʉro sehe. ");
INSERT INTO gvc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ã jia to macʉnore to warocarirore to sʉchʉ ñʉa ñʉ wihboina sehe ti basi õ sehe ni durucuha: “Ahriro wese pʉro macʉno jira. Baharo ahri wesere cjʉahtiro jira. Tirore wajãjihna. Mari ã yoachʉ ahri wese mari ya wese tjuarohca”, nimaha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ã ni tuhsʉa wese pʉro macʉnore wese dʉhtʉ cahai cohã, wajãnocaha tirore. ¿Ti ã yoachʉ ñʉno dohse yoarohcari wese pʉro wesere ñʉ wihboinare? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","—Tiro wesere ñʉ wihboinare wajãno taro, paina sehere wesere ñʉ wihbo dutirohca —ni yʉhtiha Jesu to basi. To ã nichʉ tʉhoa masa sehe õ sehe niha: —Marine ã wahaero tjijaro —niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ti ã nichʉ Jesu sehe tinare õ sehe ni sinituha: —¿Cohamacʉ yare ti joari pũre õ sehe ni durucua, dohse nino nijari, mʉsa tʉhotuchʉ?: “Ahriro Cristo tãca yoaro seheta jira. Tãcare wʉhʉ dahreina ti cohãno seheta masa tirore cohãahca. Ti ã yoapachʉta mipʉre wʉhʉ dahreina wʉhʉre yoaa ti cũ mʉhtari tãcare ti cũno seheta Cohamacʉ tirore pʉhto sõhre”, ni joaha. ");
INSERT INTO gvc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jipihtina tia tãca bui bora pjainare payʉ dihicã peri yihsorohca tia tãca. Tuhsʉ, tia tãca masʉno bui bora pjaro, tahãnocanohca tirore. Ã tahãno to pjacʉ cjirore daa manaricã wahachʉ yoarohca. (Tó seheta yʉhʉre cahmaeraina, yʉ buhiri dahrehtina ñano yʉhdʉahca) —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","To ã nichʉ tʉhoa judio masare buheina sacerdotea pʉhtoa cʉ̃hʉ, “Jesu wesere ñʉ wihboina quiti mehne marine tuhtiro nina”, ni tʉhotuha tina. Ã ni tʉhotua tina Jesure ñaha duamaha. Ã ñaha duapahta tina masare cui niha. ");
INSERT INTO gvc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ã cuia, Jesure ti ñahahtí pjare cohtasiniha tina. Ã jia tina quihõno yoaina yoaro sehe ji mahño dutiha painare. To ñano ni yʉhtichʉ yoa duaa nimaha tirore yahusã duaa. Ã jia Jesure sinitu dutia warocaha mahñoinare. Jesu ñano to ni durucuchʉ tʉhoa tí yahpa macaina bui pʉhtorore peresu yoa dutia taa nimaha. ");
INSERT INTO gvc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ã jia tina Jesure mahño cũ õ sehe ni sinitu ñʉmaha: —Buheriro, potocã durucuriro, mahñoa marieriro mʉ jichʉ sã masija. Ã jicʉ wiho jiinare, pʉhtoa cʉ̃hʉre cʉ̃no potori yoara mʉhʉ. Mʉhʉ Cohamacʉ yare potocã mʉ buhechʉ cʉ̃hʉre sã masija. ");
INSERT INTO gvc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yahuga sãre. ¿Ne, Roma macarirore jipihtina bui pʉhtorore gobierno macaare marine waparo cahmajari, mʉ tʉhotuchʉ? ¿Mari dutia wapa dutijari, mʉ tʉhotuchʉ? —ni sinituha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ti ã nichʉ tʉhoro Jesu ti ñano yoa duaare masino, tinare õ sehe ni yʉhtiha: ");
INSERT INTO gvc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Mipʉre niñeru tʉre na tahga. Tí tʉre ñʉjihna —niha. Tí tʉre ti na wihichʉ ñʉno õ sehe niha Jesu: —¿Diro baro masʉ wahãjari ahri tʉre? ¿Diro baro wama wahãjari? —niha Jesu tinare. —César, masa bui pʉhtoro jiriro ya masʉ, to wama cʉ̃hʉ wahãna —ni yʉhtiha tina. ");
INSERT INTO gvc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ti ã nichʉ Jesu õ sehe ni yahuha: —Tí pja pinihta masa bui pʉhtoro yare tiro sehere waga. Cohamacʉ yare Cohamacʉ sehere waga —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ã to noano yʉhtichʉ, masa ti ñʉrocaroi Jesure ñano ni durucuchʉ yoa masieraha tina. Ã jia Jesu yʉhtiare tʉhoa, tina cʉaa waha, dihta mariea wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ã yoa mahainacã saduceo curua macaina Jesu cahapʉ wihiha. “Cohamacʉ yariainare masosi”, ni tʉhotuina jiha saduceo curua macaina. Ã jia tina õ sehe niha tirore: ");
INSERT INTO gvc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Buheriro, õ sehe ni buhea tiha Moise cjiro: “Cʉ̃iro to wahmino namo tiriro pohna mariaparota to yariachʉ ñʉno to bahʉrore to wahmino namono cjirore nʉoano cahmana. Ã yoaro to wahmino mʉnano to pohna tiboro seheta pohna tiro cahmana to bahʉrore. Ã jia to pohna to wahmino mʉnano pohna yoaro sehe jiahca”, ni joaa tiha Moise cjiro —niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tíre ni tuhsʉ ahri quitire yahu namoha tjoa Jesure: —Cʉ̃iro masʉno jiha. Seis to bahana jiha. Ti wahmino sehe namo ti, pohna marieriro yariaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ã jiro pairo to bahʉro cʉ̃hʉ to wahmino namono cjirore nʉoaha. To ã nʉoari baharo to wahmino yoaro seheta pohna mariaparota tiro cʉ̃hʉ yariaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ã jiro ahriro bahʉro cʉ̃hʉ to wahmino mʉnano yoaro seheta pohna mariaparota yariaa wahaa. Ã dihta wahaha cʉ̃iro pohna waro. Ne pohna mariapahta yaria pihtia wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ti namono cjiro cʉ̃hʉ ti baharota yariaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Ne Cohamacʉ jipihtinare yariaina cjirire to masochʉ diro namono sehe jibocari ticoro pototi? Tina jipihtina ticorore namo tirina cjiri jiha. ¿Ã jiro diro baro namono jirohcari? —ni sinituha tina. ");
INSERT INTO gvc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Mipʉ macaina wamomaca dʉhtera. ");
INSERT INTO gvc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ti ã dʉhtepachʉta paina sehe pa turu macaina sehe ã jierara. Paina mʉare, numia cʉ̃hʉre to yainare Cohamacʉ ñaa marieina jichʉ yoarohca. Tina ti yariari baharo masa mʉjaahca. Ã yoa tina tópʉ wamomaca dʉhterara. ");
INSERT INTO gvc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ã jia tina anjoa yoaro seheta ne yariasi. Tina Cohamacʉ to masorina jia, Cohamacʉ pohna jira. ");
INSERT INTO gvc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mipʉre yariarina cjiri ti masa wijaahto sehere mʉsare yahuihtja. Tíre Moise cjiro noano yahu pahñoa tiha. To mahadʉcã jʉ̃ri quitire õ sehe ni yahua tiha tiro: “ ‘Yʉhʉ Abrahã, Isaa, Jacobo ti pʉhtoro tjija’, ni yahure Cohamacʉ yʉhʉre”, ni joaa tiha Moise cjiro. ");
INSERT INTO gvc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti yariari baharo “Ti pʉhtoro tjija”, ni yahua tiha Cohamacʉ. Ã niparota yariarina cjiri pʉhtoro jierara Cohamacʉ. “Ti pʉhtoro tjija”, to nia mehne catiina ti jichʉ masija mari. Tiro catiina pʉhtoro jira. Jipihtina masa catira Cohamacʉ to ñʉchʉ —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","To ã nichʉ tina sehe pari turi Jesure sinitu duaeraha. Ã jia mahainacã judio masare buheina õ sehe niha: —Buheriro, mʉhʉ noano yʉhtihre —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Baharo Jesu õ sehe ni yahuha tinare: —“Cristo Davi cjiro panamino jirohca”, ni buhera paina. ¿Dohse yoa tina ã ni buhejari? ");
INSERT INTO gvc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davi cjiro to basi Salmopʉ to joari tjupʉ õ sehe ni joaa tiha: “Cohamacʉ yʉ pʉhtorore õ sehe nire: ‘Õi yʉ poto bʉhʉsehei dujiga. ");
INSERT INTO gvc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ã jicʉ mʉhʉre ñʉ tuhtiinare mʉhʉre yʉhdʉrʉcabasaihca yʉhʉ’, nire Cohamacʉ yʉ pʉhtorore”, ni joaa tiha Davi cjiro. ");
INSERT INTO gvc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ã ni joaro Davi cjiro pʉhtoro tiha Cristore. Davi cjiro Cristo ñʉchʉno cjiro jiparota Cristore pʉhtoro tiha. ¿Davi cjiro Cristo ñʉchʉno cjiro jiparota dohse jiro baro tiro pʉhtoro tiari Cristore? —ni yahuha Jesu. (Cristo sehe Davi cjiro pʉhtoro jira.) ");
INSERT INTO gvc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Masa payʉ Jesure ti tʉhoro watoi Jesu sehe to buheinare õ sehe ni yahuha: ");
INSERT INTO gvc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Mari judio masare buheina ti ñaa yoaare ñʉna noano wacũ masiga. Ã jina ti yoaro sehe yoaena tjiga. Tina yoaa suhti sãa, masa ti ñʉrocaroi majarea, pache duaropʉ paina pʉhtoare noano ño payo ti sinino sehe ti piti bocasinichʉ cahmana tina. Ã cahmaina jia, tina mari judio masa buhea wʉhʉsei noaa dujia dihtare bese duji duara. Tuhsʉ, bose nʉmʉ jichʉ tó cʉ̃hʉre noaa dujia dihtare cahmana. ");
INSERT INTO gvc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tina wapewahya numia ya wʉhʉsere ti ya cʉ̃hʉre mana tí numiare. Ã yoaina jia, tina masa ti ñʉrocaroi yoari pja Cohamacʉre sinimana masare ñʉ dutia. Ti ã yoachʉ tinare Cohamacʉ pjíro buhiri dahrerohca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ã ni yahu tuhsʉ niñeru wihbori caroi pache pʉa ti niñerure ti duhu sãachʉ ñʉ dujiro niha Jesu. Tí niñeru Cohamacʉ wʉhʉre ti cahnochʉ ti wapahti jiha. ");
INSERT INTO gvc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ã ñʉno wapewahyoro pjacʉoricoro to pʉa tʉcãre to duhu sãachʉ cʉ̃hʉre ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tíre ñʉ tuhsʉ õ sehe ni yahuha: —Potocã niita nija mʉsare. Ahricoro wapewahyoro pjacʉoricoro sehe niñeru wihbori caropʉ duhu sãano paina jipihtina ti wari yʉhdoro wahre ticoro sehe. ");
INSERT INTO gvc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Paina pache pʉa pjíro ti wapachʉta ti ya pjíro dʉhsara. Ahricoro sehe pjacʉoricoro jiparota jipihtia to chʉhtire to nuchʉboacãre wa pahñohre —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ã yoa paina Cohamacʉ wʉhʉre õ sehe ni ñʉa niha: —Noaa tãa mehne yoari wʉhʉ, noacari wʉhʉ jijari. Masa Cohamacʉ ya wʉhʉ cjihtire ti wari cjiri cʉ̃hʉ tí wʉhʉpʉre noaca cũri jira —ni durucua niha. Ti ã nichʉ Jesu õ sehe ni yahuha tinare: ");
INSERT INTO gvc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ahri jipihtia mari ñʉri cjiri wʉhʉse, ahri tãa cʉ̃hʉ cohõ pihtia wahaahca. Ne cʉ̃ria tãca tjuasi —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","To ã nichʉ tʉhoa tina sehe õ sehe ni sinituha tirore: —Buheriro, ¿dohse jichʉ mʉ niriro sehe waharo ã waharohcari? ¿Pihtiri dacho panocã jichʉ dohse to waha dʉcachʉ ñʉnahcari sã? —ni sinituha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu õ sehe ni yʉhtiha tinare: —Noano yoaga mʉsa. Ã jina mʉsare paina ti mahñoare tʉhoena tjiga. Payʉ masa “Cristo jija yʉhʉ”, niina taahca. Ã nia, “Mipʉre pihtiri dacho cjihto mahanocã dʉhsara”, niahca. Ti ã nichʉ tinare tʉhoena tjiga. ");
INSERT INTO gvc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ã yoa paina “Cahma wajãa nina”, mʉsare niahca. “Mipʉre pʉhtoare masa cohãa nina”, niahca. Mʉsa tíre tʉhona cuiena tjiga. Pihtiri dacho pano õ sehe waha mʉhtanohca. To ã wahachʉ pihtiri dacho cjihto dʉhsasininohca mini —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ã ni tuhsʉ õ sehe ni yahu namoha: —Cʉ̃ yahpa macaina pa yahpa macaina mehne cahma wajãahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tuhsʉ, tuaro yahpa ñuhmi, masa payʉ jʉca mehne yaria, jipihtiro macaina dohatiahca. Ã yoa mʉano macaa bajuamehneare masa ñʉa, ñʉ cʉaa wahaahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ahri jipihtia ti ã wahahto pano, paina mʉsare ñaha, ñano yoaahca. Tuhsʉ, mari judio masa buhea wʉhʉsei tina mʉsare yahusã, peresu yoaahca mʉsare. Ti ã yoachʉ yahpari macaina pʉhtoa panoi, macari macaina pʉhtoa panoi ducunahca mʉsa ti yahusãhtina. Yʉ yaina mʉsa jiri buhiri ã yoaahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ti ã yahusãchʉ mʉsa sehe noaa buheare tinare yahunahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tí pjare mʉsare ti yahusãchʉ pʉhtorore mʉsa yʉhtihtore “Yahu masieraboca”, ni tʉhotuena tjiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yʉhʉ mʉsare yahubasaihtja. Mʉsare ã yoadohocʉ tʉho masiare, noaa durucua cʉ̃hʉre mʉsare yahuchʉ yoaihtja. Mʉsa ã yoachʉ mʉsare ñʉ tuhtiina sehe mʉsa durucuare tʉho, “Tí potocã jierara”, ni yʉhti masisi. ");
INSERT INTO gvc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tí pjare mʉsa pʉcʉsʉma, mʉsa bahana, mʉsa coyea, mʉsa mehne macaina cʉ̃hʉ mʉsare ñʉ tuhtiinare waahca mʉsare yʉ yaina mʉsa jiri buhiri. Ti ã yoachʉ mʉsare ñʉ tuhtiina mʉsa mehne macainare painare wajãahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ã yoa yʉ yaina mʉsa jichʉ ñʉa, jipihtina mʉsare ñʉ tuhtiahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mʉsare ã ñʉ tuhtipahta ne mahanocã mʉsare ñano yoasi. ");
INSERT INTO gvc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ã jina Cohamacʉre wacũ tuaina jiga mʉsa. Mʉsa ã yoana, Cohamacʉ mehne ã jirucunahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ã yoa payʉ surara Jerusalẽpʉ ti soroachʉ ñʉna, Jerusalẽne ti cohãhto to mahanocã dʉhsachʉ masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ti ã yoachʉ ñʉa Judea yahpai jiina tʉ̃yucʉ cahapʉ mʉroca duhtijaro. Ã yoa Jerusalẽi jiina wahajaro. Ã yoa campoi jiina Jerusalẽpʉ wahaea tjijaro ti waha bahrañohto sehe. ");
INSERT INTO gvc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tí dachorihi buhiri dahrea dachorihi jipihtia Cohamacʉ yare ti joari pũ to niriro cjiro seheta ã waharohca. ");
INSERT INTO gvc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jipihtiropʉ ahri yahpai ñano yʉhdʉahca. To ã wahachʉ, niji wahcõa numia, ti pohnare pũina numia cʉ̃hʉ pjacʉoro wahaahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Paina ahri maca Jerusalẽ macaina mehne cahma wajãahca. Ã cahma wajãa, paina ahri maca macainare jipihtia yahparipʉ na wahcã, peresu yoaahca. Ã jia judio masa jieraina Jerusalẽne ñano yoa, tinare yʉhdʉrʉcaahca. Judio masa jieraina ya dacho to pihtichʉpʉ Jerusalẽ macainare ñano yoa duhuahca —ni yahuha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ã ni yahu tʉhsʉ, tinare õ sehe ni yahu namoha: —Tí pjare sʉ̃ dacho macariro, ñami macariro, ñahpichoha cʉ̃hʉ cohtotaahca. Jipihtina ahri yahpa macaina “Cue, yarianahca”, ni tʉhotuina pjiri ma macaa pahcõri cuaro choro ti bisiro coa tachʉ tʉhoa tuaro cuiahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tí pjare mʉano macaa yahpari, ñahpichoha cʉ̃hʉ tuaro ñuhmiahca. Ti ã wahachʉ ñʉa, masa sehe ahri yahpa to pihtihtore cohtaa, tuaro cuiahca. ");
INSERT INTO gvc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tí pjata yʉhʉ masʉno Cohamacʉ warocariro Cohamacʉ tuaa mehne to si sitea mehne yʉ tachʉ ñʉahca masa. ");
INSERT INTO gvc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ahri ti ã waha dʉcachʉ ñʉna, wacũ tuaina jiga. Ã jina mʉanopʉ ñʉga. Tí pjare Cohamacʉ mʉsare pichacapʉ wahaborinare to yʉhdohto mahanocã dʉhsarohca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ã ni tuhsʉ ahri quiti mehne piti dahre buheha Jesu: —Higueracʉre, paye yucʉ cʉ̃hʉre tʉhotuga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tí yucʉri pũri tichʉ ñʉna, cʉhma cjihto to mahanocã dʉhsachʉ masina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tó seheta ahri jipihtia yʉ niri cjirire ti ã wahachʉ ñʉna, Cohamacʉ masare pʉhtoro to noano sʉho jihti pja mahanocã dʉhsachʉ masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Mʉsare potocã niita nija. Tí pja macaina ti yariahto pano jipihtia yʉ niriro seheta ã waharohca. ");
INSERT INTO gvc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mʉano, ahri yahpa cʉ̃hʉ pihtia wahaahca. Yʉ durucua sehe ne cohtotasi. Jipihtia yʉ niriro seheta ã waha sohtori tiarohca. ");
INSERT INTO gvc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Yʉ tjua tahti dachore ne masierara mʉsa. Ã jina noano yoaga. Bose nʉmʉrine bʉjʉa yoarucuena tjiga. Ã jina cahaena tjiga. Ahri yahpa macaare pjíro tʉhotuena tjiga. Mʉsa yʉ niriro seheta yoana, wacũenoca ahri yahpapʉ yʉ tachʉ mʉsa ne cʉasi. ");
INSERT INTO gvc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wahiquirore yurida wahiquirore wacũenoca to tʉã suharo seheta wacũenoca taihca yʉhʉ. Jipihtina ahri yahpa macaina ti masieraro watoi tí dachoi wacũenoca ã waharohca. ");
INSERT INTO gvc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Noano wacũ masi cohtaga. Ã jina Cohamacʉre ahrire ã sinirucuga: “Ahri pihtiri dachore ã wahachʉ yʉhʉre yoadohoga. Tuaare waga yʉhʉre ahrire noano yʉ yʉhdʉhti cjihtire. Tuhsʉ, Cristore mʉ warocarirore cuiro marieno yʉhʉre piti bocachʉ yoaga”, ni siniga Cohamacʉre —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ã yoa tí dachorire Cohamacʉ wʉhʉi Jesu buhea tiha. Ñaminipe buhe tuhsʉro Olivo wama tidʉ tʉ̃cʉpʉ waha, tópʉ ji bohrea tiha. ");
INSERT INTO gvc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bohrea taharipe jipihtina masa Cohamacʉ wʉhʉpʉ tirore tʉhoa wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ã yoa tí pjare bʉcaerari pãore ti chʉhti bose nʉmʉri mahanocã dʉhsaha. Tí bose nʉmʉri pascua wama tiha. ");
INSERT INTO gvc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ã jia sacerdotea pʉhtoa, judio masare buheina mehne Jesure wajã duaa, ti wajãhtore wacũ macaha. Jesure wajã duapahta, masa sehere cuiha, “Suari”, nia. ");
INSERT INTO gvc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ã yoa watĩno Juda Iscariotere ñano to yoa dutichʉ Juda sehe yʉhtiha tirore. Juda doce buheina mehne macariro jimaha. ");
INSERT INTO gvc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ã yoa tiro sacerdotea pʉhtoare, Cohamacʉ wʉhʉ macaina surara pʉhtoa mehne cʉ̃hʉre sʉhʉduro wahaha. Ti cahapʉ sʉ, tinare Jesure to ñohtore sʉhʉduha tina mehne. ");
INSERT INTO gvc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","To ã nichʉ tʉhoa, tina wahche, “Mʉhʉre niñerure wapanahtja”, niha tina Judare. ");
INSERT INTO gvc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ti ã nichʉ Juda “Jai, tirore mʉsare ñoihtja”, ni masa ti ñʉeraro watoi Jesure ñʉ tuhtiinare to ñohti ñamine cohtasiniha. ");
INSERT INTO gvc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bʉcaerari pão bose nʉmʉri ti ji dʉcari dacho jiha. Ã jiro pascua macaina cjihtire ovejare ti chʉhtinare ti wajãhti nʉmʉ jiha. ");
INSERT INTO gvc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tí pjata Pedrore, João cʉ̃hʉre Jesu õ sehe ni yahuha: —Bose nʉmʉi mari chʉhtire cahnoyuna wahaga —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Mari pascua macaa chʉhtire noho baroi cahnoyu dutirocaijari mʉhʉ sãre? —ni sinituha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Jerusalẽpʉ mʉsa sʉchʉ co situ wʉariro mʉsare piti bocarohca. To piti bocachʉ tiro mehne wahaga. ");
INSERT INTO gvc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ã wahana tiro to sʉho sãari wʉhʉpʉ sʉna tí wʉhʉ pʉrore õ sehe ni yahuga. “ ‘¿Dí tahtiai yʉhʉ yʉ buheina mehne pascua macaa chʉare chʉnahcari?’ ni sinitu dutirocahre buheriro”, niga tí wʉhʉ pʉrore. ");
INSERT INTO gvc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mʉsa ã nichʉ tʉhoro, tópʉ mʉano macari tahtiare pjiri tahtiare, noano ti cahnoyuri tahtiapʉre mʉsare ñonohca wʉhʉ pʉro. Tói mari chʉhti cjihtire dahrega mʉsa —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","To ã nichʉ tina tí macapʉ wahaha. Tópʉ ti sʉchʉ tinare to niriro seheta wahaha. Ã jia tina pascua macaa chʉare dahreha. ");
INSERT INTO gvc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ti chʉri pja jichʉ Jesu doce to buheina mehne chʉ dujiha. ");
INSERT INTO gvc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Tópʉ ti chʉropʉ dujiro Jesu tinare õ sehe ni yahuha: —Mʉsare niita nija. Ahri pascua bose nʉmʉrine mari dahreja Cohamacʉ to yainare to yʉhdohtore wacũna. Baharo Cohamacʉ masare pʉhtoro to noano sʉho jiropʉ to yainare yʉhdo tuhsʉrohca. To ã yʉhdohto pano ahri nʉmʉri baro macaare pari turi chʉeraja yʉhʉ. Ã jicʉ mipʉre ñano yʉhdʉ, yʉ yariahto pano ahri pascua macaa chʉare mʉsa mehne tuaro chʉ duaa tihi —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Ã ninota Jesu sihniri wahware na, Cohamacʉre “Noana”, ni sini, tinare õ sehe ni yahuha: —Mʉsare niita nija. Cohamacʉ jipihtina bui pʉhtoro to noano sʉho jihto pano ahri vinore ne pari turi sihnisi yʉhʉ. Ã jina ahri vinore na, mʉsa basi witi, sihniga —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ã ni tuhsʉ pão curire na, Cohamacʉre “Noana”, niha. Ã ninota, tí curire nuha, witiha tinare. Tí curire witirota, tinare õ sehe ni yahuha: —Ahri yʉ pjacʉ jira. Yʉ pjacʉ yʉhʉre ñʉ tuhtiinare ti wari pjacʉ jirohca. Mʉsa ñaa yoari buhirire cohãcʉ tacʉ yariaihca yʉhʉ. Ã jina yʉhʉre mʉsa wacũhti cjihtire ahrire chʉga —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ã chʉ tuhsʉ tó seheta tiro tinare sihniri wahwa cʉ̃hʉre waha. Ã waro, tinare õ sehe ni yahuha: —Mʉsa ñaa buhirire cohãcʉ tacʉ yariaihca. Ã yoacʉ yʉ dire cohãihca. Cohamacʉ “Mʉsare yʉhdoihtja”, to niriro mʉ sʉchʉ ã yʉ yariaro mehne to niriro sohtori tirohca. ");
INSERT INTO gvc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Mipʉre tʉhoga mʉsa. Yʉhʉre ñʉ tuhtiinare yʉhʉre ñohtiro mipʉre yʉhʉ mehne õi dujira. ");
INSERT INTO gvc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cohamacʉ to dutiriro seheta yʉhʉ masʉno Cohamacʉ warocariro yariaihca. To ã yaria dutipachʉta yʉhʉre ñʉ tuhtiinare ñoriro pinihta ñabiaro yʉhdʉrohca —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","To ã nichʉ tina sehe ti basi õ sehe ni sinituha: —¿Jesure ñʉ tuhtiinare ñohtiro mari mehne macariro diro baro jicari na? —ni durucuha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Baharo Jesu buheina õ sehe ni durucuha: —¿Mari mehne macariro diro sehe jicari na pʉhtoro? —ni durucuha ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ti ã ni durucuchʉ tʉhoro Jesu tinare õ sehe ni yahuha: —Cohamacʉre cahmaeraina pʉhtoa sehe ti masare dutia, purĩno mehne dutira. Ã jia pʉhtoare “Tina masare yoadohoina jira”, nimana paina masa tinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉsa sehe tó sehe yoasi mʉsa basi. Mʉsa mehne macariro mʉsa wahmi sehere to bahʉro yoaro sehe jiro cahmana. Mʉsa mehne macariro pʉhtoro ji duaro cahamacʉno yoaro sehe jiro cahmana tirore. ");
INSERT INTO gvc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Diro jijari pʉhtoro? ¿Chʉ dujiriro sehe pʉhtoro jijari? ¿O chʉare duhu payoriro sehe pʉhtoro jijari? Chʉ dujirirota jica pʉhtoro. To ã jipachʉta yʉhʉ sehe cahamacʉno yoaro seheta mʉsare yoadohoi tai. ");
INSERT INTO gvc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Masa yʉhʉre ti ñano yoapachʉta mʉsa sehe yʉhʉre duhuerare. ");
INSERT INTO gvc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ã jicʉ yʉ Pʉcʉ yʉhʉre to pʉhtoro sõriro seheta mʉsa cʉ̃hʉre pʉhtoa sõihtja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yʉhʉ pʉhtoro yʉ jichʉ yʉ chʉri mesai mʉsa cʉ̃hʉ chʉ, sihninahca. Ã yoana mʉsa pʉhtoa dujiare dujinahca. Mʉsa tói dujina Israe masare doce curuari macainare besenahca mʉsa ñaina, noainare —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ã ni tuhsʉ Pedrore Jesu õ sehe ni yahuha: —Simo Pedro yʉhʉre tʉhoga. Mʉsare jipihtinare yʉhʉre cohãchʉ yoa duara watĩno. Trigo wese pʉro to trigore to wã site cohãriro seheta mʉsare jipihtinare watĩno ñano yoa duara “Ñaare yoajaro”, nino. Ã yoa duaro, Cohamacʉre sinihre. ");
INSERT INTO gvc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","To ã sinichʉ ñʉcʉ yʉhʉ sehe Cohamacʉre sini payohi mʉhʉre. Yʉhʉre mʉ wacũ tua duhuerahti cjihtire sini payohi mʉhʉre. Ã jicʉ mʉhʉ yʉhʉ mehne macariro pari turi jicʉ mʉ coyeare yʉ yainare yoadohoga mʉhʉ —niha Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","To ã nichʉ Pedro õ sehe ni yʉhtiha: —Pʉhtoro, yʉhʉre ti peresu yoapachʉta, yʉhʉre ti wajã duapachʉta mʉhʉ mehne macariro jiihtja —nimaha Pedro. ");
INSERT INTO gvc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu õ sehe ni yʉhtiha: —Pedro mʉhʉre niita nija. Micha ñami caraca to duhto pano “Jesure masieraja”, niihca mʉhʉ painare. Tia taha ã niihca mʉhʉ —niha Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ã ni tuhsʉ Jesu to buheinare õ sehe ni yahuha: —¿Sohõ jiri pja mʉsa niñeru wajuru marieina, pjiri wajuru marieina, dahpo suhti marieina mʉsare yʉ warocachʉ paye baro dʉhsari mʉsare? —ni sinitu ñʉha Jesu. —Ne sãre yaba dʉhsaerare —ni yʉhtiha tina. ");
INSERT INTO gvc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Tí pjare mʉsare dʉhsaerapachʉta mipʉ sehere niñeru wajurure cjʉana tíre naga. Pjiri wajurure cjʉana cʉ̃hʉ naga. Ã jina mʉsare ñosari pjĩ mariachʉ mʉsa suhtire duana tí pjĩne nuchʉga. ");
INSERT INTO gvc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ahrire mʉsare nii nija. Cohamacʉ yare ti joari pũi ti niriro seheta yʉhʉre ã waharo cahmana. Õ sehe niha tí pũi: “ ‘Tiro dutiare yʉhdʉrʉcaina mehne macariro jira’, niahca masa”, ni joaa tiha —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Ñʉga pʉhtoro. Pʉa pjĩ ñosaa pjĩnine cjʉaja sã —niha to buheina. —Tó puro tjica —ni yʉhtiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ã yoa Jesu to ã yoarucuriro seheta Olivo wama tidʉ tʉ̃cʉpʉ wahaha. To ã wahachʉ to buheina tiro mehne wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tópʉ sʉro tiro tinare õ sehe ni yahuha: —Cohamacʉre siniga ñano mʉsa yoaerahto sehe —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ã ni tuhsʉ tiro to sahsero mahanocã waha namo, na tuhcua caha sʉ, ");
INSERT INTO gvc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Cohamacʉre õ sehe ni siniha: —Mai, yʉ ñano yʉhdʉhtire yoa duaeracʉ yoai tjia. Yʉ ã nipachʉta yʉ cahmaa sehere yoai tjia. Mʉhʉ sehe masina. Mʉ cahmano seheta yoaga yʉhʉre —ni siniha Jesu Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","To ã sinichʉ mʉanopʉ duji tariro anjo Jesure bajua, yoadohoha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tuhsʉ, Jesu ñano yajeripohna ti, tuaro mehne Cohamacʉre siniha. Ã jia to so witia di yahpari yoaro sehe jia tirore wijaa, yahpapʉ bora caha sʉha. ");
INSERT INTO gvc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cohamacʉre sini batoa wahcãrʉcʉ sʉ, tiro to buheina cahapʉ wihiha. Ã to wihichʉ to buheina tuaro cahyaina jia, carĩa niha. ");
INSERT INTO gvc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ã jiro Jesu tinare õ sehe ni yahuha: —¿Dohseana carĩna nijari mʉsa? Wahcãga. Cohamacʉre siniga ñano mʉsa yoaerahto sehe —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","To ã ni durucuro watoi masa payʉ wihiha. Juda doce buheina mehne macariro cjiro masare mʉ tã tariro jiha. Ã jiro tiro Jesu cahai wihi, wahsupu wihmiha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","To ã wihmichʉ Jesu tirore õ sehe ni sinituha: —Judá, ¿yʉhʉ masʉnore Cohamacʉ warocarirore yʉhʉre ñʉ tuhtiinare ñocʉ yʉhʉre wahsupu wihmijari mʉhʉ? —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","To ã niri baharo Jesu buheina masa Jesure ti ñahahtire masia, tirore sinituha: —Pʉhtoro, ¿sã ñosaa pjĩni mehne tina mehne cahmachema? —niha tina. ");
INSERT INTO gvc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ti ã niri baharo cʉ̃iro Jesu buheina mehne macariro sehe sacerdotea bui pʉhtoro cahamacʉnore to ñosari pjĩ mehne to cahmonore poto bʉhʉsehei jiri cahmonore cjã pahrẽnocaha. ");
INSERT INTO gvc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","To ã yoachʉ ñʉno Jesu tirore õ sehe niha: —Ã yoai tjiga —niha. Ni, cahamacʉno cahmono jiriro cjiroi ña payoha. To ã ña payochʉta cahmono mʉnano seheta jiha tjoa. ");
INSERT INTO gvc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ã yoa tuhsʉ sacerdotea pʉhtoare, Cohamacʉ wʉhʉ macaina surara pʉhtoare, bʉcʉna cʉ̃hʉre tirore ñaha tainare Jesu õ sehe ni sinituha: —¿Dohse jiro baro mʉsa ñosaa pjĩni, yucʉ tiri mehne yacarirore ti yoariro seheta mʉsa yʉhʉre ñahana tajari? ");
INSERT INTO gvc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dachoripe Cohamacʉ wʉhʉpʉ mʉsa mehne yʉ jichʉ, mʉsa yʉhʉre ne ñahaerare. Ã jipachʉta mipʉre mʉsa ya dacho yʉhʉre mʉsa ñano yoahti dacho jira. Mipʉ watĩno to ñano yoahti dacho cʉ̃hʉ jira —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tina Jesure ñaha tuhsʉ sacerdotea bui pʉhtoro ya wʉhʉpʉ naaha tina tirore. Ti tópʉ naachʉ Pedro yoaropʉ tinare ñʉ nʉnʉ tiha. ");
INSERT INTO gvc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pʉhtoro wʉhʉpʉ sʉ, tói wʉhʉ cahai jiri wapai, noari wapa dacho macai pichaca wijãha paina. Ti ã wijãchʉ ñʉno Pedro pichaca cahai dujiina mehne dujiha. ");
INSERT INTO gvc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","To ã dujiri baharo cʉ̃coro cahamacono tirore noano ñʉ, painare õ sehe ni yahuha: —Ahriro cʉ̃hʉ tiro mehne jihre —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","To ã nichʉ tʉhoro Pedro õ sehe ni yʉhtiha: —Numino, tirore ne masieraja yʉhʉ —nimaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ticoro to ã niri baharocãta pairo Pedrore ñʉ, õ sehe niha tjoa: —Mʉhʉ cʉ̃hʉ tina mehne macariro tjira —niha tiro. —Ne jieraja —nimaha Pedro. ");
INSERT INTO gvc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cʉ̃ hora baharo pairo painare õ sehe ni yahuha: —Potocã tjira. Ahriro Galilea macariro jira. Ã jiro potocãta Jesu mehne jihre ahriro cʉ̃hʉ —ni yahuha tiro painare. ");
INSERT INTO gvc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","To ã nichʉ Pedro õ sehe ni yʉhtiha: —Ne, mʉ nirirore masieraja yʉhʉ —ni yʉhtiha Pedro. To ã ni durucuro watoi caraca duha. ");
INSERT INTO gvc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","To ã duchʉta Jesu wʉhʉ cahai jiriro Pedrore majare ñʉrocaha. To ã yoachʉ Pedro sehe Jesu to yahurire wacũha. “Micha ñami caraca to duhto pano, ‘Yʉhʉ Jesure masieraja’, niihca mʉhʉ. Tia taha ã niihca mʉhʉ”, Jesu to niri cjirire wacũha Pedro. ");
INSERT INTO gvc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ã wacũno Pedro tópʉ jiriro wijaa ta, tuaro tiirucuha. ");
INSERT INTO gvc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ã jia Jesure cohtaina surara tirore bʉjʉpe, cjã mʉjaha. ");
INSERT INTO gvc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ã cjã mʉja, to caparire dʉhte dʉcata, tirore õ sehe ni sinituha: —¿Diro mʉhʉre cjãjari? Ñʉerapaihta yahuga sãre —ni sinitu, bʉjʉpeha tina. ");
INSERT INTO gvc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ã jia payʉ ñano ni durucuha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bohrearoi judio masa bʉcʉna, sacerdotea pʉhtoa, judio masare buheina cʉ̃hʉ cahmachuha. Ti ã cahmachunoi paina tina cahapʉ Jesure na taha. ");
INSERT INTO gvc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Yahuga sãre. ¿Cristota jijari mʉhʉ? —ni sinituha tina Jesure. Ti ã nichʉ Jesu õ sehe ni yʉhtiha: —Mʉsare yʉ yahuchʉ, yʉhʉre tʉhosi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mʉsare yʉ sinituchʉ yʉhʉre yʉhtisi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mʉsa yʉhtierapachʉta baharo curero jipihtia dachoripe yʉhʉ masʉno Cohamacʉ warocariro Cohamacʉ tua yʉhdʉariro to poto bʉhʉsehei dujiihtja —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","To ã nichʉ tina jipihtina sinituha tjoa pari turi: —¿Ã nicʉ Cohamacʉ macʉnota jijari mʉhʉ? —niha tina. —Tirota jija mʉsa nino seheta —ni yʉhtiha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","To ã nichʉ tʉhoa, tina õ sehe ni durucuha ti basi: —Ahriro Cohamacʉre pjíro to ñano durucuchʉ mari basi tʉhohi. Ã yoa ahrirore yahusãina tópeina tjijaro. (Tópeina mehne tirore mari wajã duti masija) —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ã ni tuhsʉ tina jipihtina wahcãrʉca, Jesure Pilato cahapʉ naaha. ");
INSERT INTO gvc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","To cahapʉ na sʉa, Jesure yahusã dʉcaha: —Ahriro mari ya yahpa macainare to ñano yoa dutichʉ sã tʉhohi. Mari bui pʉhtorore ahriro wapa dutierara. Tuhsʉ, tiro “Pʉhtoro jija. Cristo masare yʉhdohtiro jija yʉhʉ”, ni durucure to basi —ni yahusãha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ti ã ni yahusãri baharo Pilato Jesure õ sehe ni sinituha: —¿Judio masa pʉhtorota jijari mʉhʉ? —niha tiro Jesure. —Mʉ nino seheta tiro tjija —ni yʉhtiha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","To ã nichʉ Pilato sacerdotea pʉhtoare, masa cʉ̃hʉre õ sehe ni yahuha: —Ahriro yaba buhiri mariahna —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","To ã nipachʉta tina tuaro yahusã namoha: —Tiro to buhea mehne masare cahmachechʉ yoara. Galilea yahpai tiro tíre yoa dʉcare. Ã yoa dʉca tuhsʉ jipihtiro Judea yahpapʉ tíre tiro yoare. Mipʉ õpʉ cʉ̃hʉre tíre yoaro taro nina —ni yahusãha tina. ");
INSERT INTO gvc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ti ã ni yahusãchʉ tʉhoro Pilato sehe õ sehe ni sinituha: —¿Ahriro Galilea macariro jijari? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Tó macariro tjira —ni yʉhtiha paina. Ti ã ni yʉhtichʉ tʉhoro Pilato sehe Jesu to jiri yahpare masino pʉhtoro Herode ya yahpa macariro Jesu to jichʉ masiha. Tíre masino Jesure Herode cahai warocaha. Tí pjare Herode Jerusalẽi jia tiha. ");
INSERT INTO gvc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tó panopʉ Herode Jesure tʉhoa tiha. To ã tʉhori baharo yoari pja baharo tirore ñʉ duaha. Jesu Cohamacʉ tuaa mehne to yoa ñochʉ ñʉ duamaha tiro. Ã jiro tiro Jesure ñʉno, wahcheha. ");
INSERT INTO gvc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ã jiro payʉ tahari sinituha Jesure. To ã sinitupachʉta Jesu ne yʉhtieraha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sacerdotea pʉhtoa, judio masare buheina cʉ̃hʉ Herode cahai wahcãrʉca, tuaro Jesure yahusãha. ");
INSERT INTO gvc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ti yahusãri baharo, Herode to surara mehne bʉjʉpe, Jesure ñano yoaha. Ã bʉjʉpea, noari suhtirore pʉhtoro to sãari suhtiro yoaro sehe bajuri suhtirore sãaha tina Jesure. Ã bʉjʉpe tuhsʉ, tirore Pilato cahapʉ warocaha tjoa. ");
INSERT INTO gvc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tí dachore Herode, Pilato mehne noano ti basi cahma yoaina ji dʉcaha. Tó panore ti basi cahma ñʉ tuhtiina jisinimaha. ");
INSERT INTO gvc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ã yoa Pilato sacerdotea pʉhtoare, paina pʉhtoare, masa cʉ̃hʉre to pjirocachʉ, cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ti cahmachu pihtichʉ ñʉno õ sehe niha Pilato tinare: —Ahrirore yʉhʉre na tana, “Tiro masare ñano yoa dutira”, nimahre mʉsa yʉhʉre. Mipʉ mʉsa ñʉrocaroi ahrirore noano sinitu pahñohi tjoa. Yʉ ã sinituri baharo mʉsa tirore ã yahusãrucuchʉ tirore ñaa buhiri ne mariahna, yʉ ñʉchʉ. ");
INSERT INTO gvc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode cʉ̃hʉ tirore “Ne, ñaa buhiri mariahna”, nihre. Ã nino ahrirore pari turi sãre wa majare tjuhre tjoa. Ã jina ahrirore to ñaa buhiri mariachʉ tirore mʉsa wajã duti masierara. ");
INSERT INTO gvc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ã jicʉ tirore yuta dari mehne tjana dutiihca yʉhʉ. Ã ti tjanari baharo tirore wioihtja —nimaha Pilato masare. ");
INSERT INTO gvc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cʉhmaripe pascua bose nʉmʉrine masa yairo cjihtore cʉ̃iro peresupʉ jirirore Pilato wiobasa mʉjaa tiha. ");
INSERT INTO gvc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ã jia Pilato “Jesure wioihtja”, to nichʉ tʉhoa jipihtina masa õ sehe ni sañurucuha: —Tirore Jesure wajãga. Sã yairo cjihtore Barrabá sehere sãre wiobasaga —ni sañurucuha masa. ");
INSERT INTO gvc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tí pjare Barrabá wama tiriro Jerusalẽpʉ pʉhtoare cohã duaina mehne macariro, masʉnore wajãriro peresupʉ jiha. Ã jia tirore masa wio dutia niha. ");
INSERT INTO gvc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesu sehere wio duamaha. Ã jiro tiro masare sinitu ñʉha tjoa. ");
INSERT INTO gvc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","To ã wio duapachʉta tina tirore õ sehe ni sañurucuha tjoa: —Crusapʉ cjã puha wajãga tirore. Wajãga tirore —ni sañurucuha tina. ");
INSERT INTO gvc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ti ã nichʉ Pilato tia taha waharoi õ sehe nimaha tinare: —¿Yabare ñano yoari tiro mʉsa ã ni sañurucuchʉ? Ne tirore ñaa buhiri mariahna. Ã jicʉ tirore wajã duti masieraja. Tirore yuta da mehne tjana dutiihca. Tó purota yoa dutiihca. Ã yoacʉ wioihca tirore —niha Pilato. ");
INSERT INTO gvc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","To ã nipachʉta tina tuaro mehne sañurucu namo, Jesure crusapʉ wajã dutiha. Ti ã ni sañurucuchʉ tʉhoro ti cahmariro seheta Pilato yoaha. ");
INSERT INTO gvc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tirore ti siniriro seheta Pilato Jesure wajã dutiha. ");
INSERT INTO gvc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ã dutiro tiro peresupʉ jirirore masare cahmachechʉ yoarirore, masare wajãrirore masa ti siniriro seheta Pilato Barrabá sehere wioha. Tuhsʉ, Pilato Jesure crusapʉ wajã dutiha. ");
INSERT INTO gvc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","To ã wajã dutichʉ tina Jesure wajãa wahaa, naaha. Tí pja ti ã yoaro watoi Simo wama tiriro Cirene macariro campopʉ sʉriro wihiha. Jerusalẽpʉ to wihichʉ ñʉa Jesure naaina tirore piti boca, ñaha, Jesu to wʉari crusare tirore wʉa wahcã dutiha Jesu baharo. ");
INSERT INTO gvc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ã yoa masa payʉ Jesure ñʉ nʉnʉ tiha. Ã jia masa watoi jia numia tirore ti ã yoachʉ ñʉa tuaro tiiha. ");
INSERT INTO gvc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ti ã tiichʉ tʉhoro, tí numiare Jesu majare ñʉ, õ sehe niha: —Jerusalẽ macaa numia, yʉhʉre tiiena tjiga. Mʉsa basi, mʉsa pohna mʉsa ñano yʉhdʉhtire masina, tiibasaga. ");
INSERT INTO gvc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Paye dachori jichʉ ñabiaro yʉhdʉnahca mʉsa. Tí pjare masa õ sehe niahca: “Pohna mariea numia, pohna tierari numia, pũera numia mipʉ mari jichʉ noabiaboa”, niahca masa. ");
INSERT INTO gvc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tí pjare tʉ̃cʉre õ sehe ni durucuahca masa. “Mʉhʉ tʉ̃cʉ sã buipʉ bora pjaga. Sãre dʉcatahga”, niahca masa cuia. ");
INSERT INTO gvc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Masa buhiri marierirore yʉhʉre õ sehe ti yoachʉ, ñaa buhiri cjʉaina sehe ñabiaro wahaahca —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Paina pʉaro, dutiare yʉhdʉrʉcaina ti jichʉ tina cʉ̃hʉre Jesu mehne ti wajãhtinare naaha tina. ");
INSERT INTO gvc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tinare naa, “Dapu cohã”, wama tiropʉ sʉ, crusapʉ Jesure cjã puha õha. Pʉaro yʉhdʉrʉcaina cʉ̃hʉre pairore to poto bʉhʉsehei, pairore to cõ bʉhʉsehei cjã puha õha. ");
INSERT INTO gvc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ti ã yoachʉ Jesu õ sehe niha: —Mai, ahrina mipʉ ti ñaa yoarire boga tinare. Tina ti dohse yoarire masierara. Ã jicʉ ti ñaa yoari buhirire boga —niha Jesu. Ã yoa Jesu suhtire cahma witia tina docapeha. To suhti cjirire “Noa yaro jirohcari õ”, ni cahma docapeha tina. ");
INSERT INTO gvc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tuhsʉ, masa tói ducuina ti ñʉrucuro watoi judio masa pʉhtoa Jesure õ sehe ni bʉjʉpeha: —Tiro paina masare yariaborinare yoadohoyumahtiro. Ã jiro tiro Cristo Cohamacʉ to beseriro jiro, mipʉ yariaboriro jiro, to basi yoadohojaro —ni bʉjʉpeha tina. ");
INSERT INTO gvc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Surara cʉ̃hʉ tirore bʉjʉpeha. Jesu cahai sʉa, tina tirore ñaa co vinore wamaha. ");
INSERT INTO gvc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tíre waa, õ sehe niha tina: —Mʉhʉ judio masa ti pʉhtoro jicʉ mʉ basi yoadohoga. Ã jii yʉhdʉ witiihca mʉhʉ —ni bʉjʉpeha tina. ");
INSERT INTO gvc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ã yoa tiro bui ti cjã puha õri pjĩne õ sehe ni joaha: “Ahriro judio masa bui pʉhtoro jiriro jira”, ni joaha. (Griego ya mehne, Roma macaina ya mehne, judio masa ya mehne ã ni joaha.) ");
INSERT INTO gvc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pairo tiro mehne ti cjã puha daporiro yʉhdʉrʉcariro sehe õ sehe ni, ñano durucuha Jesure: —¿Mʉhʉ Cristo masare yʉhdoriro jierajari? Mʉ basi, sã cʉ̃hʉre yoadohoga —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","To ã nichʉ tʉhoro pairo yʉhdʉrʉcariro Jesu poto bʉhʉsehei ti cjã puha daporiro sehe tirore õ sehe niha: —Mari cʉ̃hʉre cʉ̃no potori buhiri dahrera tina. ¿Dohseacʉ Cohamacʉre ne ño payoerajari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Marine ñaa buhirire yoaa, quihõno yoaa nina tina. Ñaare mari yoari buhiri marine buhiri dahrera tina. Ahriro sehe ñaare yoaerare —niha tiro pairo yʉhdʉrʉcarirore. ");
INSERT INTO gvc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ã nino, tiro Jesure õ sehe niha: —Jesu, mʉhʉ pʉhtoro jicʉ, tjua tacʉ, yʉhʉre wacũga —niha tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","To ã nichʉ tʉhoro, õ sehe niha Jesu: —Mʉhʉre ahrire nii nija. Michare paraíso wama tiropʉ mʉhʉ yʉhʉ mehne jiihca —niha Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ã yoa cohari pja jichʉ sʉ̃ si duhua wahaha. Ã jiro jipihtiro tí dihtapʉre tia hora waro noano nahitiano jiha. ");
INSERT INTO gvc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nahitiano to jiro watoi, Cohamacʉ wʉhʉ macari suhtiro, dʉcatari suhtiro dacho maca waroi bui sehe tʉhnʉ bora ta, pʉa cahsaro tʉhnʉroca yoja sʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ã jiro Jesu õ sehe ni tuaro sañurucuha: —Mai, yʉ catiare mʉhʉre wiaja mʉ ñʉ wihbohto cjihtore —ni sañurucuha Jesu. Ã ni tuhsʉ yariaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","To ã yariachʉ ñʉno, surara pʉhtoro sehe “Cohamacʉ tuariro jira”, nino: “Ahriro Jesu cjiro potocãta noariro jiri jimana”, niha surara pʉhtoro. ");
INSERT INTO gvc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ã jia ti wajãchʉ ñʉa tarina Jesu to yariachʉ ñʉa, ti wʉhʉsepʉ tjuaa wahaha. Tjuaa waha, ti ñaa yoarire cahyaa mehne ti pẽbuhui cjã õ wahcãha. ");
INSERT INTO gvc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jipihtina Jesu yaina tiro mehne macaina, Galileapʉ tiro mehne tari numia cʉ̃hʉ Jesure yoaropʉ ñʉrocarucua niha. ");
INSERT INTO gvc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tí pjare José wama tiriro tói jiha. Judea yahpai jiri maca Arimatea wama tiri maca macariro jiha. Tiro noariro, quihõno yoariro jiro, Cohamacʉ to pʉhtoro ji dʉcahtore cohtariro jiha. Ã jiro tiro judio masa pʉhtoa mehne macariro jiparota Jesure ti wajã dutichʉ cahmaeramaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ã jiro Pilato cahapʉ sʉ, Jesu pjacʉre siniha. ");
INSERT INTO gvc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sini tuhsʉ, Jesu pjacʉre na boro, noari suhtiro mehne to pjacʉre wahmaha. Ã wahma tuhsʉ, masa copapʉ tãcai ti sahari copapʉ na sãa duhu payoha to pjacʉre. Tí copare ne paina yariainare duhu payoerasiniha mini. ");
INSERT INTO gvc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tí dacho Sabado dacho macaa cjihtire ti cahnoyuri dacho jiha. Sabado judio masa ti sori nʉmʉ cjihto mahanocã dʉhsaha. ");
INSERT INTO gvc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ã jia Galileapʉ Jesu mehne tari numia masa copapʉ José mehne wahaha. Masa copapʉ sʉ, tí copare ñʉ, Jesu pjacʉre ti duhu payorire ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Baharo ti wʉhʉsepʉ tjuaa waha, me sitia mehne wisõa co mehne cahnoha tina. Tuhsʉ, Sabado jichʉ Cohamacʉ to dutiare Moise cjirore to cũri to dutiriro seheta tina soha. ");
INSERT INTO gvc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo jichʉ bohrearopʉ tí numia ti me sitia ti cahnoyumarire Jesu masa copapʉ na wahcãmaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tí copapʉ sʉa, tí copare bihari tãca pjõo ti duhu cũri tãcare ñʉha. ");
INSERT INTO gvc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ã ñʉa tina tí copapʉ sãa wahaha. Jesu pjacʉre bocaeraha tina. ");
INSERT INTO gvc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","To pjacʉre bocaeraa, “¿Dohse wahapjʉ?” ni tʉhotuha tina. Ti ã ni tʉhotu durucu coãno watoi pʉaro mʉa si sitea suhti tiina tina cahai ducuha. ");
INSERT INTO gvc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tói ti ducuchʉ ñʉ, numia cuia na tuhcua caha sʉha. Tuhsʉ, mʉa sehe tí numiare õ sehe ni yahuha: —¿Dohseana yariariro to jiriro cjirore tirore macajari mʉsa? Mipʉre tiro catiriro jira. ");
INSERT INTO gvc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tiro õre mariahna. Masa wijaa tuhsʉhre. ¿Sohõ jiri pjare Galileapʉ mʉsa mehne jiro mʉsare to niri cjirire wacũjari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Yʉhʉre Cohamacʉ warocarirore pairo warohca ñainare. To ã wari baharo yʉhʉre crusapʉ cjã puha wajãahca tina. Ã jicʉ yʉ yariari baharo tia dacho wahaboroi masa wijaaihca yʉhʉ”, ¿mʉsare to nirire wacũjari mʉsa? —niha mʉa sehe. ");
INSERT INTO gvc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ti ã nichʉ tʉhoa, numia sehe Jesu to nirire wacũha. ");
INSERT INTO gvc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ti ã niri baharo tina tjuaa waha, once buheinare paina cʉ̃hʉre tíre yahu pahñoha. ");
INSERT INTO gvc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tí numia sehe María Magdalena, Juana, María Santiago pocoro jiha. Tí numia mehne paye numia cʉ̃hʉ jiha Jesu buheinare yahua numia. ");
INSERT INTO gvc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ti ã ni yahupachʉta Jesu buheina sehe “Potocã nia nieraca. Mahñopea nica ahri numia”, ni tʉhotumaha. Ã jia tí numiare tʉho duaeraha. ");
INSERT INTO gvc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ti ã nichʉ tʉhoro, Pedro sehe masa copapʉ mʉroca wahcã, ñʉno wahaha. Tí copapʉ sʉ, tiro muhri caha, ñʉroca sõha. Jesure ti wahmari suhtiro dihtare ñʉha. “¿Dohse wahari na?” ni tʉhotu, tiro wʉhʉpʉ tjuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tí dachoihta pʉaro Jesu buheina mehne macaina Emau wama tiri macapʉ wahaa niha. Jerusalẽ once kilómetro yoaro jira Emaupʉ sʉhto. ");
INSERT INTO gvc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Emaupʉ wahaa, jipihtia Jerusalẽi tí pjare to ã waharire Jesure ti ñano yoarire durucu wahcãa niha. ");
INSERT INTO gvc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ti ã ni durucuro watoi Jesu sehe ti cahapʉ sʉ, tina mehne wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tirore ñʉpahta tina tirore “Jesu jira”, ni ñʉ masieraha. ");
INSERT INTO gvc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—¿Dohse ni cahya durucu wahcãna nijari mʉsa? —ni sinituha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","To ã nichʉ tʉhoa tina cahyaro mehne sʉrʉca, Cleofa wama tiriro sehe Jesure õ sehe ni yʉhtiha: —¿Mipʉre Jerusalẽi tiniriro jipaihta mʉhʉ dihta ti yoari cjirire masierajari? —ni sinituha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Dohse wahari Jerusalẽi? —niha Jesu. To ã nichʉ tina õ sehe ni yʉhtiha: —Jesure Nazare macarirore ti yoarire nina nija. Tiro Cohamacʉ yare yahu mʉhtariro jimahre. Ã jia to durucurire tʉhoa to yoari cʉ̃hʉre ñʉa, “Tuariro jira”, ni tʉhotuhre masa. Cohamacʉ cʉ̃hʉ ãta ni tʉhotuca. ");
INSERT INTO gvc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mari sacerdotea pʉhtoa, paina pʉhtoa mehne tirore wajã dutia, painare wahre. Ti ã wachʉ paina sehe tirore crusapʉ cjã puha wajãhre. ");
INSERT INTO gvc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Roma macainare cohãhtiro Israe masa pʉhtoro cjihto jira”, ni tʉhotumahi sã tirore. Micha mehne tia dacho wahara tiro to yariari baharo. ");
INSERT INTO gvc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Mahainacã numia sã mehne macaa numia sãre cʉachʉ yoahre. Bohrearopʉ Jesu to masa copapʉ tí numia sʉ, to pjacʉre bocaerayuhti. To pjacʉre bocaeraa, tina tju wihi yahuhre. “Sãre anjoa bajuahre. Jesu catiyuhti”, ni yahuhre numia sehe. ");
INSERT INTO gvc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ti ã nichʉ paina sã mehne macaina tí copapʉ sʉ, numia ti niriro seheta ñʉyuhti. Tina cʉ̃hʉ Jesure ñʉerayuhti —niha tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ti ã niri baharo Jesu õ sehe ni yahuha tinare: —Mʉsa ne tʉho masiera cureina jira. ¿Cohamacʉ yare yahu mʉhtaina cjiri ti nirire noano tʉhoerari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristore to pʉhtoro jihto pano mʉanopʉ to mʉjahto pano tirore ñano yʉhdʉro cahmare. ¿Tíre masierasinijari mʉsa? —niha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ã nino Cohamacʉ Cristore to ni yahu ti joari cjirire Jesu yahu pahñonocaha tinare. Moise cjiro to joari cjirire Jesu yahu dʉcaha. Tuhsʉ, jipihtina Cohamacʉ yare yahu mʉhtaina cjiri Cristore ti joari cʉ̃hʉre yahu pahñonocaha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tina ti wahari macapʉ ti sʉa cahachʉ, Jesu sehe tinare yʉhdʉ wahcãno sehe yoaro nimaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","To ã yoapachʉta tina tirore waha dutieraha: —Sã mehne tjuaga. Ñamichahapʉ jira. Nahinopʉ nina —niha tina tirore. Ã jiro Jesu tina mehne wʉhʉpʉ sãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wʉhʉpʉ sãa sʉ, tiro tina mehne ti chʉri mesapʉ nuju sʉ, pãore na, Cohamacʉre “Noana”, niha. Ã nino tí pãore nuha na, tinare waha. ");
INSERT INTO gvc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","To ã yoachʉ ñʉa tina Jesure ñʉ masiha. Ti ñʉ masi mʉari baharo tiro buti mʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","To ã buti mʉa wahachʉ ñʉa tina ti basi õ sehe ni durucuha: —Mahai tiro marine to durucuro watoi Cohamacʉ to joari cjirire to yahuro watoi tuaro mari wacũ tʉhotua mehne noano wahchea mehne tʉhotuhi mari —niha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ã ni tuhsʉ tina dóicãta Jerusalẽpʉ majare tjuaa wahaha tjoa. Tópʉ sʉa, once buheinare paina mehne cahmachuinare bocaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ã ti sʉchʉ, once buheina õ sehe niha: —Potocãta mari pʉhtoro masa wijaayuhti. Simo Pedro tirore ñʉyuhti —niha once buheina. ");
INSERT INTO gvc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ti ã nichʉ pʉaro Emau macaina mahai Jesure ti ñʉrire yahuha: —Jesu to pãore to nuhachʉ sã ñʉ masihi tirore —ni yahu pahñoha tina painare. ");
INSERT INTO gvc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ti ã ni yahuro watoi ti cahai ji tuhsʉha Jesu sehe. —¿Jimajari mʉsa? Noano jiga mʉsa —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","To ã nichʉ tʉhoa tina “Mari yariariro cjirore ñʉna nija”, ni tʉhotua, tuaro cuiha. ");
INSERT INTO gvc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ti ã cuichʉ ñʉno tiro tinare õ sehe ni yahuha: —¿Dohseana cuijari mʉsa? ¿Dohseana “Ahri potocã jierara”, nijari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yʉ wamomacarine, yʉ dahpori cʉ̃hʉre ñʉga. Mʉsa yʉhʉre ñʉna, ñʉ masinahca. Yʉhʉre ñaha ñʉga. Ñaha ñʉna, masinahca mʉsa. Yariariro cjiropʉ pjacʉ mariahna. Yʉhʉ sehe pjacʉ tija —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ã nino to wamomacari cʉ̃hʉre, to dahpori cʉ̃hʉre ñoha tinare. ");
INSERT INTO gvc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","To ã ñopachʉta tina tuaro wahche, cʉaa waha, “Ahri potocã jieraca”, ni tʉhotusinimaha. Ti ã tʉhotuchʉ masino Jesu tinare sinitu ñʉha: —¿Õi chʉa jijari? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","To ã nichʉ tʉhoa wahi doharirore mi cʉ̃hʉre waha tirore. ");
INSERT INTO gvc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tíre na, ti ñʉrocaroi Jesu chʉha. ");
INSERT INTO gvc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chʉ tuhsʉ, Jesu yahuha tinare: —Sohõ jiri pja mʉsa mehne jicʉ mʉsare yʉ yahuriro seheta mipʉ yʉhʉ ã wahahi. Cohamacʉ dutia Moise cjiro marine to cũri cjiri to ã ni joariro seheta yʉhʉre ã wahahre. Cohamacʉ yare yahu mʉhtaina cjiri, Salmo joari tjure joaina cʉ̃hʉ panopʉ yʉhʉre ti ni yahuriro seheta mipʉre yʉhʉre ã wahahre. Ãta waharo cahmahre —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ã ni tuhsʉ Cohamacʉ yare ti yahu joari cjirire to buheinare masichʉ yoaha Jesu: ");
INSERT INTO gvc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Cohamacʉ yare ti joari cjiri õ sehe niha: “Cristore ñano yʉhdʉro cahmana. Ã jiro tia dacho wahaboroi to yariari baharo tiro masa wijaarohca. ");
INSERT INTO gvc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","To masa wijaari baharo jipihtia yahparipʉ to yaina Cristo yare yahuahca. Masa ti ñaa yoarire ti cahyahti cjihtire, “Ñano yoaeraja” ni, ti tʉhotumarire ti cohtotahti cjihtire, Cohamacʉre ti cahmahti cjihtire, ti ñaa buhiri tiare to cohãhti cjihtire yahuahca to yaina. Ã yahua taa, Jerusalẽpʉ yahu dʉcaahca”, niha Cohamacʉ yare ti joari pũi —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ã ni tuhsʉ õ sehe ni yahu namoha: —Mʉsa sehe ahri jipihtiare ñʉrina jira. Ã jina painare yahunahca. ");
INSERT INTO gvc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cohamacʉ “Tirore mʉsare warocaihtja”, to nirirore yʉhʉ sehe mʉsare warocaihtja. Ã jina Jerusalẽpʉ ahri mʉano macaa tuaa mʉsare to wihihtore cohtaga mʉsa —niha Jesu to buheinare. ");
INSERT INTO gvc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ã ni tuhsʉ Jesu tinare Jerusalẽi jiinare Betania cahapʉ naaha. Tópʉ sʉ, Jesu to wamomacari mehne ñui mʉo, “Noano jiga”, niha tinare. ");
INSERT INTO gvc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ã ni tuhsʉ, tinare cũ, mʉanopʉ mʉjaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","To mʉjari baharo tina tirore ño payo, Jerusalẽpʉ tuaro wahchea mehne tjuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tói jia, dachoripe tina Cohamacʉ wʉhʉi Cohamacʉ mehne durucu, “Noana”, ni ño payoha tina tirore.");
INSERT INTO gvc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dóipʉta ahri yahpa to jihto panopʉta Cohamacʉ ya dʉserore yahuriro Cristo masare yʉhdʉchʉ yoahtiro dóihta ji tuhsʉa tiha. Tiro Cohamacʉ mehne jiha. Ã yoa tirota Cohamacʉta jinocahno niha. ");
INSERT INTO gvc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dóipʉta wahmanopʉta Cristo Cohamacʉ mehne jiha. ");
INSERT INTO gvc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ã yoa wahmanopʉre ne mariahri cjirire bajuamehneha. Ahri yahpare, mʉanore, jipihtiare, jipihtina cʉ̃hʉre bajuamehne dutiha Cohamacʉ tirore. Ã jiro ahrire bajuamehne pahñoha tiro. Ahrire mipʉre mari ñʉare, mari ñʉera cʉ̃hʉre to bajuamehnerachʉ ne mariaboa. ");
INSERT INTO gvc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo catiare wariro jiro nina. Buhriaro marine to noano ñʉ masichʉ yoaro seheta tiro to Pʉcʉro mʉano macarirore noano masichʉ yoara. Ã yoaro to Pʉcʉro mʉano macarirore masichʉ yoara masare. ");
INSERT INTO gvc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ahri yahpa macaina ñaare ti wacũ ti goa pjaa nahitiano yoaro sehe jia nina. Cohamacʉ ya dʉserore yahuriro buhriaro noano marine to ñʉ masichʉ yoaro seheta masare masichʉ yoara. Ã yoa nahitiano buhriarore to yʉhdʉrʉcaeraro seheta Cristore ñaa ne yʉhdʉrʉcaerara. ");
INSERT INTO gvc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Cohamacʉ João wama tiriro sehere warocaha, Cristore buhriaro yoaro sehe jirirore masare yahu mʉhta dutiro. To ã warocachʉ João sehe masare yahuro tare to yahurirore Cristore jipihtina ti wacũ tuahti cjihtire. ");
INSERT INTO gvc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","João sehe Cristo jierare. Ã jieraro tiro Cristo sehere masare yahu mʉhtano tare. ");
INSERT INTO gvc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo buhriaro yoaro sehe jiriro jipihtina masare Cohamacʉre masichʉ yoahtiro sehe ahri yahpapʉ tari jire. Potocã tjira ahri. Tiro buhriaro yoaro sehe jiriro waro tjira. ");
INSERT INTO gvc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo ahri yahpai jia timare. Ahri yahpare bajuamehneriro jiri jimare. To ã jipachʉta ahri yahpa macaina sehe tirore ne masierare. ");
INSERT INTO gvc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","To ya yahpai tiro masa bajuari jimare. To ya yahpai masa bajuariro to jipachʉta to ya yahpa macaina sehe ne tirore cahmaerare. ");
INSERT INTO gvc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ti ã cahmaerapachʉta, tirore cahmaina sehere, tirore wacũ tuaina sehere Cohamacʉ to pohna jichʉ yoari jire. ");
INSERT INTO gvc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tina Cohamacʉ pohnata jia nina. Ã jia masa ti masa bajuariro seheta jierara, Cohamacʉ pohna ti wahachʉ. Tuhsʉ, masa ti cahmariro seheta jierara, Cohamacʉ pohna ti wahachʉ. ");
INSERT INTO gvc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ã jiro Cristo masʉno to ji dʉcari baharo mari mehneta jire tiro. To ã jichʉ ñʉna masare cahĩriro, potocã jiare yahuriro to jichʉ sã masii. Tiro dihta Cohamacʉ macʉno jiro tuariro noariro jire. To ã jiriro jichʉ sã masii. ");
INSERT INTO gvc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João Cristore yahu mʉhtano õ sehe ni sañurucure masare yahuro: —Siro tara yʉ õ sehe ni yahuriro: “Tiro yʉ baharo tariro jira. Ã jiparota tiro yʉ yʉhdoro tuariro jira. Tiro yʉ masa bajuahto panopʉta ji tuhsʉha. Ã jiro tiro yʉ yʉhdoro tuariro jira”, mʉsare yʉ ni yahuriro ahriro tjira —nire João Cristore masare yahuro. ");
INSERT INTO gvc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tiro Cristo sehe noariro tuaro masare cahĩriro jiro marine jipihtinare noano yoarucure. ");
INSERT INTO gvc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Cohamacʉ dutiare Moise cjiro sehe cũbasa mʉhtaa tiha marine. Jesucristo sehe Cohamacʉ masare to cahĩare buhero tare. Cohamacʉ to potocã durucua cʉ̃hʉre buhero tare tiro. ");
INSERT INTO gvc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Masa ne Cohamacʉre ñʉerara. Tirore mari ñʉerapachʉta to macʉno to tuaro cahĩriro cʉ̃irota jiriro sehe to Pʉcʉrore marine masichʉ yoare. ");
INSERT INTO gvc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sã coyea judio masa pʉhtoa Jerusalẽi jiinare sacerdoteare, Cohamacʉ wʉhʉi dahraina cʉ̃hʉre João cahapʉ warocari jire. “¿Diro baro jijari mʉhʉ?” ni sinitu dutia warocari jire tinare. Ti ã ni sinituchʉ õ sehe ni yahure João sehe. ");
INSERT INTO gvc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne yaro marieno yahure. Potota yahure: —Yʉhʉ Cristo Cohamacʉ masare yʉhdʉchʉ yoa dutiro to warocariro jieraja —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","To ã nichʉ tina sehe tirore pari turi siniture tjoa: —¿Mʉhʉ Cristo jieracʉ, Elia sehe jijari mʉhʉ? —nire tina. —Jieraja yʉhʉ —nire tiro. —¿Sã cohtariro Cohamacʉ yare yahu mʉhtariro sehe jijari mʉhʉ? —nire tina. —Tiro jieraja yʉhʉ —nire João sehe. ");
INSERT INTO gvc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","To ã nichʉ tina tirore pari turi õ sehe ni siniture tjoa: —Sãre sinitu dutiinare sã noano yahuhto sehe poto sãre yahu bahrañoga. ¿Diro baro sehe jijari mʉhʉ? ¿Mʉ basi mʉhʉ sehe dohse jiriro baro “Jija yʉhʉ”, nijari mʉhʉ? —nire tina Joãore. ");
INSERT INTO gvc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ti ã nichʉ õ sehe ni yʉhtire tiro: —Masa marienopʉ õ sehe ni sañurucuriro jija yʉhʉ Cohamacʉ yare yahu mʉhtariro Isaia cjiro to ni yahuriro seheta: “Mari pʉhtoro to tahto pano mʉsa ñaa tʉhotuare cohtota, cahno mʉhtaga mʉsa”, ni masare yahu sañurucuriro jija yʉhʉ —nire João tinare. ");
INSERT INTO gvc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Joãore sinituina fariseo curua macaina ti warocarina jire. ");
INSERT INTO gvc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ã jia tina Joãore õ sehe ni siniture tjoa: —¿Mʉhʉ Cristo, Elia, Cohamacʉ yare yahu mʉhtariro sã cohtariro jierapacʉta dohseacʉ masare bautisajari mʉhʉ? —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ti ã nichʉ tʉhoro õ sehe ni yʉhtire tiro: —Yʉhʉ co mehne masare bautisaja. Pairo sehe mʉsa masierariro mʉsa watoi ji tuhsʉra. ");
INSERT INTO gvc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tiro sehe yʉ baharo tariro yʉ yʉhdoro tuariro jira. Noa yʉhdʉariro jira. Tiro yoaro sehe jieraja yʉhʉ sehe. Ã jicʉ tirore tʉhotucʉ, “Wiho jiriro jija yʉhʉ”, ni tʉhotuja yʉhʉ —nire João tinare. ");
INSERT INTO gvc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ã ni durucure tina, Betaniapʉ Jordão wama tiri ma pa bʉhʉsehe coapʉ, João masare to bautisariropʉ. ");
INSERT INTO gvc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pa dachoi Jesu João cahai cahacã curero to tachʉ João tirore ñʉno õ sehe nire: —Ñʉga. Ahriro Cohamacʉ to warocariro to oveja yoaro sehe jiriro jira. Ovejare mari wajãriro seheta masa ahriro cʉ̃hʉre wajãahca. Ã yariaro ahri yahpa macainare ti buhiri tiare cohãnohca tiro. ");
INSERT INTO gvc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ahrirota jira yʉ õ sehe niriro: “Yʉ baharo tariro yʉ yʉhdoro tuariro jira. Yʉ masa bajuahto pano tiro ji tuhsʉha. Ã jiro tiro yʉ yʉhdoro tuara”, yʉ niriro ahrirota jira. ");
INSERT INTO gvc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉhʉ sehe ahrirore noano waro masiera tihi. Ã masierapaihta co mehne bautisai tai nii yʉ coyea Israe masa ahrirore ti masihto sehe —nire João. ");
INSERT INTO gvc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ã ni tuhsʉ João to ñʉri cjirire õ sehe ni yahu namore tjoa: —Espíritu Santo mʉanopʉ buja yoaro sehe duji ta, Cristo mehne to tjuachʉ ñʉhi. ");
INSERT INTO gvc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Cohamacʉ yʉhʉre to yahuerachʉ tirore ne masieraboa yʉhʉ. Wiho mejeta tiro yʉhʉre masare co mehne diapʉ bautisa duti warocariro Cohamacʉ sehe õ sehe ni yahu mʉhta tuhsʉre yʉhʉre: “Espíritu Santo duji ta to bui to tjuarʉcʉ sʉriro tirota jirohca. Tiro sehe Espíritu Santore to yaina mehne ã jirucuchʉ yoarohca”, nire Cohamacʉ yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mipʉ pinihtare to ã ni yahurirore ñʉ tuhsʉhi yʉhʉ. Ã ñʉcʉ “Ahriro potocãta Cohamacʉ macʉno jira”, ni yahuja yʉhʉ mʉsare —ni yahure João sãre. ");
INSERT INTO gvc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Pa dachoi João mehne sã pʉaro to buheina sã ducuchʉ, Jesu sã cahai yʉhdʉ wahcãno nire. To ã yʉhdʉ wahcãchʉ João tirore ñʉno, pari turi õ sehe nire sãre: —Ñʉga. Ahriro Cohamacʉ to oveja yoaro sehe jiriro jira —nire João. ");
INSERT INTO gvc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","To ã nichʉ sã pʉaro to buheina sehe tíre tʉhona Jesu baharo wahahi. ");
INSERT INTO gvc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sã ã wahachʉ ñʉno Jesu sãre majare ñʉ, õsehe ni siniture: —¿Nohopʉ wahajari mʉsa? —nire tiro. To ã nichʉ sã cʉ̃hʉ õ sehe ni sinitu ñʉi tirore: —Rabi, ¿nohopʉ jijari mʉhʉ? —nihi sã tirore. (Rabi sã ya mehne nina “buheriro”, nina nija.) ");
INSERT INTO gvc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Yʉhʉ mehne tatjiãhna ñʉna taga —nire Jesu sãre. To ã nichʉ sã sehe to jiropʉ ñʉna wahai. Tí pjare ñamichahapʉ cuatro hora jire. Ã jina tí dachore tiro mehne tjuai sã. ");
INSERT INTO gvc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sã pʉaro Joãore tʉhoina, Jesure nʉnʉ ti wahcãina yʉ piti Andre mehne jii. Andre sehe Simo bahʉro jire. ");
INSERT INTO gvc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ã jiro tiro dóihta to wahminore Simore maca, boca, tirore õ sehe ni yahuha: —Mesiare Cohamacʉ marine yʉhdʉchʉ yoa dutiro to warocarirore sã bocahi —niha Andre Simore. (Mesia sã ya mehne nina “Cristo”, nina nija.) ");
INSERT INTO gvc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ã ni tuhsʉ tiro Simore Jesu cahai naahre. To cahai ti sʉchʉ ñʉno Jesu sehe Simore õ sehe nire: —Mʉhʉ Simo wama tiriro, Jona macʉno jira. Mipʉre mʉhʉre Cefa ni wama pisuihtja —nire Jesu Simore. (Cefa sã judio masa ya mehne nina “Pedro”, nina nija.) ");
INSERT INTO gvc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pa dachoi Jesu Galilea yahpapʉ waha duare. Ã jiro to wahahto pano tiro Felipere piti boca, õ sehe nire: —Yʉhʉ mehne macariro cjihto taga —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe sehe Betsaida macariro jire. Tiro, Andre, Pedro mehne cʉ̃ maca macaina jire tina. ");
INSERT INTO gvc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ã yoa Felipe Natanaene maca, tirore bocaro õ sehe ni yahure: —Cohamacʉ dutiare Moise cjiro to joari pũpʉ to yahurirore paina Cohamacʉ yare yahu mʉhtaina cjiri cʉ̃hʉ ti yahurirore sã bocahi. Jesu Nazare macariro, José macʉno tjira —nire tiro Natanaene. ");
INSERT INTO gvc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Nazarepʉre ne cʉ̃iro noariro mariahna —nire Natanae. —Ñʉi taga mʉhʉ —nire Felipe. ");
INSERT INTO gvc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ã yoa Jesu cahai to sʉchʉ ñʉno Jesu sehe õ sehe nire Natanaene: —Ahriro mipʉ tariro potocãta noariro judio masʉno waro jira. Tirore mahñoa ne mariahna —nire Jesu Natanae sehere. ");
INSERT INTO gvc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","To ã nichʉ tʉhoro Natanae sehe tirore õ sehe ni siniture: —¿Dohseacʉ yʉhʉre noano masijari mʉhʉ? —nire. —Felipe mʉhʉre to pjihto pano, higueracʉ docai mʉ jichʉ ñʉhi yʉhʉ mʉhʉre —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","To ã nichʉ Natanae sehe tirore õ sehe nire tjoa: —Buheriro, potocãta mʉhʉ Cohamacʉ macʉno jira. Mʉhʉ Israe masa sã Pʉhtoro cjihto jira —nire Natanae. ");
INSERT INTO gvc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","To ã nichʉ tʉhoro õ sehe ni yʉhtire Jesu: —Higueracʉ docai mʉhʉre yʉ ñʉrire masicʉ yʉhʉre “Cohamacʉ macʉno jira”, ni wacũ tuara mʉhʉ. ¿Títa mʉhʉre ã masichʉ yoajari? Ahri mʉhʉre yʉ ñʉri yʉhdoro Cohamacʉ tuaa mehne yoa ñoihca yʉhʉ. Yʉ ã yoa ñochʉ ñʉihca mʉhʉ —nire Jesu Natanaene. ");
INSERT INTO gvc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ã ninota õ sehe ni yahu namore: —Potocãta mʉhʉre niita nija. Yʉhʉ masʉno Cohamacʉ warocariro tjija. Mʉanopʉ parĩ mʉachʉ Cohamacʉ to yaina anjoa yʉ bui ti duji tachʉ, ti mʉjachʉ cʉ̃hʉre ñʉihca mʉhʉ —nire Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tia dacho baharo Canái Galilea yahpai jiri macai wamomaca dʉhteri bose nʉmʉ jire. Ã jiro Jesu pocoro tí wʉhʉpʉ jire. ");
INSERT INTO gvc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu mehne sãre to buheina cʉ̃hʉre wamomaca dʉhteropʉ pjirocare tina. ");
INSERT INTO gvc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti bose nʉmʉ macaa vino pihtichʉ Jesu pocoro tirore õ sehe ni yahure: —Mipʉre vino pihtia wahare —nire ticoro Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","To ã nichʉ tʉhoro Jesu õ sehe nire: —Iñõ, ¿dohseaco taco tíre yʉhʉre yahujari mʉhʉ? Masa yʉhʉre ti masihto dʉhsasinina mini —nire Jesu to pocorore. ");
INSERT INTO gvc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","To ã niri baharo to pocoro sehe ti cahamacare õ sehe ni dutire: —Yʉ macʉ to dutiriro seheta yoaga —nire ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tí pjapʉre sã coyea judio masa Cohamacʉ yare yoaa taa masare ti pjacʉrire ã cosarucunoca dutia tire. Ã yoa tí wʉhʉi seis situ pari tãa mehne ti yoaa situ pari co posa tia situ pari jire. Tí situ pari Cohamacʉ yare yoaa taa ti cosaa co posa tia pari cjiri jire. Tí situ parire cincuenta a setenta litro posa mʉ sʉre. ");
INSERT INTO gvc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tói ti jichʉ ñʉno tí wʉhʉ macaina cahamacare õ sehe ni dutire Jesu: —Ahri situ parire co mehne pio sãa namoga wahpaa pari ti wahahto sehe —nire Jesu. To ã nichʉ tina sehe noano wahpo dapo pahñonocare ti parire. ");
INSERT INTO gvc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ti ã yoari baharo Jesu tinare õ sehe ni dutire tjoa: —Mipʉre tí core wa na, wʉhʉ macarirore waga —nire. To ã nichʉ tʉhoa tí core wa na, wʉhʉ macarirore ware. ");
INSERT INTO gvc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ti ã wachʉ tiro sehe tí core vino to wahachʉ yoaa core sihni ñʉre. Tí core nohoi to tarirore masierare tiro. To ã masierapachʉta to cahamaca tí core waina sehe masire. Wʉhʉ macariro ã masieraro wamomaca dʉhterirore pjiroca, ");
INSERT INTO gvc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","õ sehe ni yahure: —Paina masa noaa core vinore wa mʉhtana. Masa ti noano sihniri baharo ña curea core wara tina. Mʉhʉ sehe noaa core wihbo, baharo curero tí core ware sãre —nire wʉhʉ macariro wamomaca dʉhterirore. ");
INSERT INTO gvc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Canái Galileai jiri macai Jesu core vino to wahachʉ yoari cjiri coã to bajuamehne dʉcari jire. Ã yoaro painare to tuaare ñore Jesu. To ã ñori baharo sã to buheina tirore wacũ tuai. ");
INSERT INTO gvc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baharo Jesu to pocorore, to bahanare, sãre to buheina cʉ̃hʉre Capernaupʉ sʉho sʉre. Tópʉ sʉna, mahaa dachoricã tjuasinii sã. ");
INSERT INTO gvc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua jichʉ judio masa sã bose nʉmʉri cjihti mahanocã dʉhsatjiãhre. Ã jiro Jesu Jerusalẽpʉ sʉre. ");
INSERT INTO gvc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tópʉ sʉro tiro Cohamacʉ wʉhʉpʉ sãa sʉro, wachʉare, ovejare, bujaare duainare boca sʉre. Tuhsʉ, niñerure cohtotaina ti mesaripʉ ti dujichʉ tina cʉ̃hʉre boca sʉre. ");
INSERT INTO gvc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ã boca sʉro yuta dari mehne tjanari da yoa, tinare jipihtinare sopacapʉ tjana nʉnʉ wionocare. Oveja, wachʉa cʉ̃hʉre tjana nʉnʉ wionocare tiro. Ã yoa niñeru cohtotaina ti mesarire na majareroca doca cũnocare. Ti niñeru tʉri cʉ̃hʉre doca sitenocare. ");
INSERT INTO gvc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ã yoa tuhsʉ bujaare duainare õ sehe nire: —Mʉsa bujaare na wijaahga. Yʉ Pʉcʉ ya wʉhʉre pache duari wʉhʉ yoaena tjiga —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","To ã yoachʉ ñʉna sã to buheina sehe Cohamacʉ yare ti joari pũi to niri cjirire wacũi: “ ‘Cohamacʉ, mʉ wʉhʉre tuaro cahĩja. Ã cahĩcʉ mʉ wʉhʉre ñano ti yoachʉ ñʉcʉ tuaro cahyaja yʉhʉ’, ni joaa tiha Cohamacʉ yare ti joari pũi”, ni wacũi sã Jesu buheina. ");
INSERT INTO gvc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesu to ã yoari baharo sã coyea judio masa pʉhtoa tirore õ sehe ni siniture: —¿Dohseacʉ mʉhʉ ahrinare Cohamacʉ wʉhʉpʉre jiinare cohã wiori? Cohamacʉ mʉhʉre tíre yoa dutiriro to jichʉ Cohamacʉ tuaa mehne yoa ñoga mʉhʉ sã ñʉhti cjihtire —nire tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ti ã nichʉ Jesu õ sehe ni yʉhtire: —Ahri wʉhʉre mʉsa cohãchʉ tia dacho wahaboroi tuhsʉihtja yʉhʉ —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Tia dacho mehne ahri wʉhʉre tuhsʉsi mʉhʉ. Cuarenta y seis cʉhmari waro ti yoari wʉhʉ jira ahri wʉhʉ —nire tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","To ã nichʉ tina tirore noano tʉhoerare. Jesu “Ahri wʉhʉre” nino, to pjacʉre nino niri jimare. ");
INSERT INTO gvc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ã yoa to yariari baharo, to masa wijaari baharo sã to buheina sehe to niri cjirire wacũna, Cohamacʉ yare ti joari pũre Jesu to yahuri cʉ̃hʉre “Tí potocã tjira”, ni wacũi sã. ");
INSERT INTO gvc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua bose nʉmʉri jichʉ Jesu Jerusalẽpʉ jire. Tói to jichʉ masa payʉ Cohamacʉ tuaa mehne to yoa ñochʉ ñʉa tirore wacũ tuare. ");
INSERT INTO gvc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ti ã wacũ tuapachʉta Jesu masa ti wacũare noano masino, “Yʉhʉre ã wacũ tuarucuahca”, ni tʉhotueraha. ");
INSERT INTO gvc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tiro masa ti tʉhotuare noano masire. Ã masino masa ti tʉhotuare painare ne sinitu ñʉerare. ");
INSERT INTO gvc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tí macai Nicodemo wama tiriro, judio masa pʉhtoa mehne macariro jire. Tiro fariseo curua macariro jire. ");
INSERT INTO gvc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cʉ̃ ñami tiro Jesu cahai ta, tiro mehne õ sehe ni sʉhʉduri jire: —Buheriro, mʉhʉ Cohamacʉ to buhe dutiro to warocariro mʉ jichʉ sã masija. Mʉhʉ payʉ tahari Cohamacʉ tuaa mehne yoa ñona. Cohamacʉ mʉhʉre to yoadohoerachʉ, mʉhʉ sehe to tuaa mehne ne ã yoa ñoaeraboa —niri jire Nicodemo Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","To ã nichʉ tʉhoro Jesu sehe õ sehe ni yahuri jire: —Potocã mʉhʉre niita nija. Pari turi masa bajuariro yoaro sehe wahariro dihta mari pʉhtoro Cohamacʉ mehne ji masina —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—Cuenah. ¿Bʉcʉro sehe dohse yoa pari turi masa bajuabocari tiro? To pocoro niji suhtiropʉ majare sãa, pari turi bajua masieraboca tiro —niri jire Nicodemo. To ã nichʉ tʉhoro Jesu õ sehe ni yʉhtiri jire tjoa: ");
INSERT INTO gvc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—Potocã niita nija mʉhʉre. Co mehne, Espíritu Santo to tuaa mehne pari turi masa bajuariro dihta mari pʉhtoro Cohamacʉ mehne ji masina. ");
INSERT INTO gvc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Numia nijipocosanumia jia, macanacãre masa bajuachʉ yoara. Espíritu Santo sehe masare Cohamacʉ pohna jichʉ yoara. ");
INSERT INTO gvc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Pari turi masa bajuariro yoaro sehe wahariro dihta mari pʉhtoro Cohamacʉ mehne ji masina”, yʉ nichʉ, tʉho wisiecʉ tjiga. ");
INSERT INTO gvc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Espíritu Santo masare Cohamacʉ pohna to yoachʉ wihnono yoaro sehe jira. Wihnono to tariropʉ tara. To taro coa tachʉ mari tʉhoja. Ã tʉhopanahta to tarirore, to waharirore ne masieraja. Tó seheta yoara Espíritu Santo masare Cohamacʉ pohna jichʉ yoaro —niri jire Jesu Nicodemore. ");
INSERT INTO gvc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Mʉ niare noano masieraja —niri jire Nicodemo. ");
INSERT INTO gvc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","To ã nichʉ tʉhoro õ sehe niri jire Jesu: —Mʉhʉ judio masare buheriro jipaihta, ¿dohseacʉ yʉ niare tʉhoerajari? ");
INSERT INTO gvc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Potocã mʉhʉre niita nija. Sã masirire, sã ñʉrire sã yahuja. Sã ã yahupachʉta ne mʉsa sã coyea judio masa ne tʉho duaerare. ");
INSERT INTO gvc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ahri yahpa macaa mehne masa ti masa bajuari mehne mʉhʉre piti dahre yʉ buhe mʉhtarire “Potocã tjira”, nierara mʉsa. Ã nierana piti dahre buhero marieno Cohamacʉ yare yʉ yahuchʉ cʉ̃hʉre “Potocã tjira”, nisi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ne cʉ̃iro mʉanopʉ Cohamacʉ cahapʉ wahariro ne pari turi tjua tasi. Yʉhʉ masʉno Cohamacʉ warocariro yʉhʉ dihta mʉanopʉ jiriro ahri yahpapʉ tahi. (Ã jicʉ yʉhʉ dihta Cohamacʉ yare mʉsare yahu masija.) ");
INSERT INTO gvc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Panopʉre masa marienopʉ Moise cjiro bronce wama tiri comaa mehne ti yoarirore agãre yucʉcʉ ti dapodʉ sohtoapʉ duhu õ dapoha. Yʉhʉ cʉ̃hʉre masʉno Cohamacʉ warocarirore tiro agãre to duhu õ daporiro seheta yʉhʉ cʉ̃hʉre duhu õ dapoahca. ");
INSERT INTO gvc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yʉhʉre ti ã yoari baharo jipihtina yʉhʉre wacũ tuaina jipihtia dachoripe Cohamacʉ mehne ã jirucuahca —niri jire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ã ni tuhsʉ õ sehe ni namori jire Jesu: —Cohamacʉ jipihtina ahri yahpa macainare tuaro cahĩna. Ã jiro yʉhʉre to macʉnore cʉ̃irota jirirore Cohamacʉ warocare jipihtina yʉhʉre wacũ tuaina pichacapʉ ti wahaerahto cjihtore. Ã jia Cohamacʉ ya catia mehne ã catirucuahca tina. ");
INSERT INTO gvc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Cohamacʉ yʉhʉre to macʉnore masare buhiri dahre dutiro warocaerare ahri yahpapʉre. Masare pichacapʉ wahaborinare yʉhdʉchʉ yoahtiro cjihto sehere yʉhʉre warocare. ");
INSERT INTO gvc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Yʉhʉre Cohamacʉ macʉnore wacũ tuainare ne buhiri dahresi Cohamacʉ. Yʉhʉre wacũ tuaeraina pinihtare Cohamacʉ buhiri dahre duti tuhsʉre. Masa yʉhʉre Cohamacʉ macʉnore cʉ̃irota jirirore ti wacũ tuaerari buhiri buhiri dahrerohca tinare. ");
INSERT INTO gvc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yʉhʉ Cohamacʉ macʉno ahri yahpapʉ tacʉ buhriaro to noano marine to ñʉ masichʉ yoaro seheta Cohamacʉ yare noano masichʉ yoaja. Yʉ ã masichʉ yoapachʉta, yʉhʉre wacũ tuaeraina sehe yʉhʉre cahmaerara. Ti ñaa yoaa sehere noano cahmana. Ti ã cahmari buhiri tinare buhiri dahre duti tuhsʉre. ");
INSERT INTO gvc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jipihtina ñaare ã yoarucuina baro ti ñaa yoaare duhu duaerara. Ã jia buhriaro to bajuro dahrero seheta ti ñaa yoarire “Bajuro dahreri” nia, yʉhʉre cahmaerara tina. ");
INSERT INTO gvc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Quihõno yoaina sehe yʉhʉre, yʉ buhea cʉ̃hʉre cahmana. Cohamacʉ yoadohoro mehne to yare ti yoaare yʉ noano bajuro dahrechʉ bʉo tierara tina. Ã jia yʉhʉre buhriaro yoaro sehe jirirore cahmana —ni yahuri jire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Baharo Jesu sãre to buheinare Judea yahpapʉ sʉho wahare. Tópʉ sʉro tó macaina mehne mahaa dachoricã tjua, tinare bautisare. ");
INSERT INTO gvc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João cʉ̃hʉ masare bautisaro niha Enón wama tiri macai. Enón Salim wama tiri maca cahai jire. Tói dia jire. Tói dia jichʉ João bautisaro niha masare. ");
INSERT INTO gvc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tirore ti peresu yoahto pano Enóni masare bautisaro niha João. ");
INSERT INTO gvc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tí pjare João buheina mehne macaina mahainacã judio masʉno mehne bautisaa macaare durucua niha. ");
INSERT INTO gvc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ã jia tina João cahapʉ sʉa, tirore õ sehe ni yahuha: —Buheriro, Jordão sie coapʉ mʉhʉ mehne jiriro “Tiro tjica”, mʉ niriro sehe mipʉre masare bautisaro nina. To ã yoachʉ jipihtina tiro cahapʉ dihta wahara —niha tina Joãore. ");
INSERT INTO gvc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ti ã nichʉ tʉhoro João õ sehe ni yʉhtiha: —Tiro tuariro to jichʉ Cohamacʉ sehe tirore ã jichʉ yoariro jira. ");
INSERT INTO gvc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Cristo jieraja”, yʉ nichʉ tʉhore mʉsa. Ã jierapaihta to pano to waroca mʉhtariro jija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cristo mehne masa ti wahachʉ ñʉcʉ tuaro wahcheja. Õ sehe jira tí: Wamomaca dʉhtericoro to manʉno mehne jiro wahara. Wamomaca dʉhtehtirore cohtariro sehe dʉhtehtiro to namo tichʉ ñʉno to durucuchʉ tʉhoro tuaro wahchera. Ã jicʉ yʉhʉ wamomaca dʉhtehtirore cohtariro to wahcheriro seheta Cristo mehne masa ti wahachʉ ñʉcʉ tuaro wahcheja. ");
INSERT INTO gvc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cristo sehere wacũ tuaro cahmana masare. Yʉhʉ sehere wacũ tuaeraro cahmana masare —ni yʉhtiha João. ");
INSERT INTO gvc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ã ni tuhsʉro õ sehe ni namoha João: —Mʉanopʉ tariro jipihtina yʉhdoro tuariro jira. Ahri yahpapʉ jiina jina ahri yahpa macaina jija mari. Ã jina ahri yahpa macaare durucuja mari. Mʉanopʉ tariro sehe jipihtina yʉhdoro tuariro jira. ");
INSERT INTO gvc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","To ñʉri cjirire, to tʉhori cjirire tiro yahura. To ã yahupachʉta to yahuare masa sehe ne tʉho duaerara. ");
INSERT INTO gvc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mʉanopʉ tariro to yahuare masa tʉhoa, tíre cahmaa, “Cohamacʉ potocã niriro jira”, nia nina tina. ");
INSERT INTO gvc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ahriro Cristore Cohamacʉ warocarirore Espíritu Santo ya tuaare cũ pahñona Cohamacʉ. Ã jiro tiro Cohamacʉ ya durucuare yahura. ");
INSERT INTO gvc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cohamacʉ to macʉnore tuaro cahĩna. Ã jiro jipihtina bui ti pʉhtoro ji dutire to macʉnore. Jipihtia pʉro ji dutire tirore. ");
INSERT INTO gvc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cohamacʉ macʉnore wacũ tuaina sehe Cohamacʉ catia mehne ã catirucuahca. To macʉnore cahmaeraina sehe Cohamacʉ catia mehne jisi. Ã jiro Cohamacʉ tinare tuaro buhiri dahrerohca —niha João. ");
INSERT INTO gvc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesu João yʉhdoro payʉ buheinare to cjʉachʉ João yʉhdoro masare to bautisachʉ fariseo curua macaina tʉhorocaha. ");
INSERT INTO gvc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ti ã tʉhorocapachʉta Jesu sehe to basi masare bautisaerare. Sã to buheina sehe masare bautisahi. ");
INSERT INTO gvc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo curua macaina ti ã masichʉ tʉhoro Jesu sehe Judea yahpai jiriro Galilea yahpapʉ sãre sʉho tjuaa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tópʉ wahana Samaria yahpare sʉ yʉhdʉ wahcãna tana nihi sã. ");
INSERT INTO gvc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ã yʉhdʉ wahcãna Samaria yahpai jiri macapʉ Sica wama tiri macapʉ sʉhi. Tí maca cahai panopʉ macariro Jacobo cjiro to macʉno José cjirore to wari yahpa jire. ");
INSERT INTO gvc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tói Jacobo cjiro co to naari copa jire. Ã yoa Jesu sehe yoaropʉ tariro cjiro jiro, tiro wahya yʉhdʉaro tí copa dʉhtʉ cahai nuju sʉre. Tí pja tói to so nuju sʉri pja cohari pja waro jire. ");
INSERT INTO gvc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sã to buheina sehe macapʉ chʉare sã nuchʉna wahari baharo cʉ̃irota tiro tói tjua nuju sʉre. Ã so nuju sʉro Samaria macaricoro tí copapʉ co waro to wihichʉ Jesu ticorore core siniha: —Core waga yʉhʉre —niha. ");
INSERT INTO gvc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—Mʉhʉ judio masʉno jira. Yʉhʉ sehe Samaria macaricoro jija. ¿Dohseacʉ yʉhʉre core sinijari mʉhʉ? —niha ticoro Jesure. Judio masa Samaria macainare ñʉ tuhtiina jira. Ã jiro ticoro ã niha. ");
INSERT INTO gvc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","To ã niri baharo Jesu ticorore õ sehe ni yahuha: —Mʉhʉre Cohamacʉ to yoadoho duarire masico, mʉhʉre core sinirirore masico, mʉhʉ yʉhʉ sehere siniboa. Mʉ ã sinichʉ paye co sehere waboa yʉhʉ. Tí co sehe catichʉ yoara —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","To ã nichʉ tʉhoro ticoro õ sehe ni yʉhtiha tirore: —Ne mʉhʉre situ mariahna. Wiho mejeta ahri copa cʉãri copa jira. ¿Ã jicʉ ahri catichʉ yoaa core nohopʉ wabocari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mari ñʉchʉ cjiro Jacobo panopʉ macariro ahri copare marine cũa tiha. Tiro, to pohna, to nuina cʉ̃hʉ ahri core sihnia tiha. “Paye core waboa yʉhʉ” nicʉ, ¿Jacobo yʉhdoro masiriro jijari mʉhʉ, ã ni tʉhotucʉ? —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","To ã nichʉ Jesu õ sehe ni yʉhtiha: —Jipihtina ahri core sihniina, pari turi ñahma yapioahca. ");
INSERT INTO gvc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ya co sehere sihniina ne pari turi ñahma yapiosi. Ã jia ya core sihniina Cohamacʉ mehne ã jirucuahca. Ma pohtapʉ co to ã wijaarucuro seheta ya co ne pihtisi —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","To ã nichʉ tʉhoro numino sehe õ sehe niha: —Ne pari turi yʉ ñahma yapioerahto sehe tí core waga yʉhʉre. Ã jico pari turi ne õpʉre co wasi —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","To ã nichʉ Jesu ticorore õ sehe ni yahuha: —Tí pja pinihta mʉ manʉre pjico wahaga. Pji tuhsʉ õpʉ taga tiro mehne —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","—Manʉ marienicoro jija yʉhʉ —niha ticoro. —Potocãta nimana mʉhʉ. Mʉhʉ cinco tahari manʉ ti tuhsʉmare. Tuhsʉ, mipʉre mʉhʉ mehne jiriro mʉ manʉ jierara. Ã yoa “Manʉ marienicoro jija” nico, potocãta nimana mʉhʉ —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","To ã nichʉ tʉhoro õ sehe niha ticoro: —Ne, Cohamacʉ yare yahu mʉhtariro jira mʉhʉ, yʉ tʉhotuchʉ. ");
INSERT INTO gvc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sã ñʉchʉsʉma cjiri ahdʉ tʉ̃cʉpʉ Cohamacʉre ño payoa tiha. Ã jina mʉsa sehe judio masa “Jerusalẽi Cohamacʉre ño payoro cahmana masare”, nia tire mʉsa judio masa —niha ticoro. To ã nichʉ Jesu õ sehe ni yʉhtiha: ");
INSERT INTO gvc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Numino yʉhʉre tʉhosiniga. Baharopʉ ahdʉ tʉ̃cʉi, Jerusalẽpʉ cʉ̃hʉre mari Pʉcʉre ño payosi mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉsa sehe mʉsa ño payorirore masierara. Masare yʉhdʉchʉ yoahtiro judio masʉnota jira. Ã jina sã judio masa sehe sã ño payorirore masija. ");
INSERT INTO gvc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mipʉre baharopʉ cʉ̃hʉre Cohamacʉre potocã ño payoina ti noano tʉhotua mehne tirore ño payoahca. Tó sehe mari ño payochʉ cahmana Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Cohamacʉ pjacʉ marieriro to jichʉ masa tirore ñʉerara. Ã jia tirore ño payoa, ti noano tʉhotua mehne tirore noano potocã ño payoro cahmana masare —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","To ã nichʉta ticoro õ sehe ni yʉhtiha: —Mesia, “Cristo” ti niriro sehe masare yʉhdʉchʉ yoahtiro, to tahti cjihtire masija yʉhʉ. Tiro taro, marine jipihtiare buhe pahñonohca —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Yʉhʉta jija Cristo —niha Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","To ã ni yahuchʉ waro wihina sã to buheina sehe Jesu numino mehne to durucuchʉ ñʉna, cʉaa wahai. Ã cʉapanahta “¿Dohse cahmajari mʉhʉ? ¿Dohse nii nijari mʉhʉ ticorore?” ni sinitu ñʉerahi. ");
INSERT INTO gvc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ã jiro numino to siture tói duhu daponoca, macapʉ waha, masare yahuro, õ sehe niha: ");
INSERT INTO gvc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Yʉ yoari cjirire yahu pahñorirore ñʉna taga mʉsa. Tiro potocãta Cristo jiboca pa tehe nino —niha ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","To ã nichʉ tʉhoa tí maca macaina sehe Jesure ñʉa taa nire. ");
INSERT INTO gvc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tí pjare sã Jesu buheina sehe tirore tuaro chʉ dutimai: —Buheriro, chʉga —nimai sã. ");
INSERT INTO gvc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Soro jia chʉare cjʉaja yʉhʉ. Tíre mʉsa masierara —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","To ã nichʉ tʉhona sã basi õ sehe ni durucui: —¿Paina tirore chʉare wa tuhsʉari? —nii sã basi. Sã ã nichʉ Jesu õ sehe ni yahure: ");
INSERT INTO gvc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—Masa sehe chʉ ji coara. Yʉhʉre warocariro to cahmaare yoacʉ ji coaja yʉhʉ sehe to yoa dutiriro seheta yoa pahñocʉ tacʉ. ");
INSERT INTO gvc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Cuatro sʉ̃ri dʉhsara dicha naahto”, wese pʉro to niriro seheta mʉsa sehe ni tʉhotuena tjiga. “Cohamacʉ yare sã yahuhto dʉhsasinina”, ni tʉhotuena tjiga. Potocã niita nija mʉsare. Mipʉ pinihtare masare ñʉga. Dicha tichʉ mʉsa naari pja to jiriro seheta, mipʉ pinihta masa yʉ buheare ti tʉhohti pja jiro nina. ");
INSERT INTO gvc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Toaa dichare naainare ti wapariro seheta yʉ yaina cjihti naainare yʉ yare buheinare ti ã yoari wapa tinare noano yoaihtja yʉhʉ. Ti ã buhechʉ tʉhoa yʉ buheare tʉhoina yʉ yaina sehe Cohamacʉ mehne jipihtia dachoripe jirucuahca. Ã jia tinare buhe mʉhtaina, baharo yʉ yaina jichʉ yoaina cʉ̃hʉ cʉ̃no potori wahcherucuahca. ");
INSERT INTO gvc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Cʉ̃iro toa mʉhtariro jira. Pairo sehe toaa dichare nariro jira”, nia tiha panopʉ. Tí potocã tjira. Ti ã niriro seheta cãina yʉ yare yahu mʉhtaina jira. Paina sehe yʉ yare buhea yʉ yaina jichʉ yoaina jira. ");
INSERT INTO gvc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wese pʉro to yaina dahraina toaeraina ti jipachʉta to toaa dichare tinare naa dutiro warocara. Tó seheta masare buhe mʉhtaeraina mʉsa jipachʉta yʉ yaina cjihti yoa duticʉ warocaja mʉsare. Paina sehe tinare buhe mʉhta tuhsʉre. Ti buherinapʉre pari turi buhe namona, yʉ yaina jichʉ yoanahca mʉsa sehe. Ã jina buhe mʉhtaina sehe ti yoadohoro mehne painare yʉ yaina jichʉ yoanahca mʉsa —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tí pjare Samaria macaricoro “Yʉ yoari cjirire tiro yahu pahñore”, to ã nichʉ tʉhoa Samaria macaina payʉ Jesure wacũ tua, tirore cahmaha. ");
INSERT INTO gvc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ã jia Samaria macaina Jesu cahai sʉa, “Sã mehne tjuasiniga”, nire tirore. Ti ã nichʉ sã cʉ̃hʉ tiro mehne pʉa dacho tói tjuasinii. ");
INSERT INTO gvc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Paina cʉ̃hʉ payʉ Jesure tʉhoa cahmare tirore. ");
INSERT INTO gvc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Õ sehe nire masa numinore: —Wahmanopʉre mʉ yahurire tʉhona, Jesure cahmahi. Mipʉ pinihtare Jesu to durucuare tʉhona tirore wacũ tuana, tirore cahmaja. Ã jina tiro sehere tʉhona ahri yahpa macainare pichacapʉ wahaborinare yʉhdʉchʉ yoariro potocã to jichʉ mipʉ sã masija —nire masa Samaria macaricorore. ");
INSERT INTO gvc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pʉa dacho baharo Jesu sãre Galilea yahpapʉ sʉho wahare. ");
INSERT INTO gvc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wahmanopʉre õ sehe nia tire tiro: “Cohamacʉ yare yahu mʉhtarirore to ya yahpa macaina tirore ño payoerara. Ã jia yʉhʉre ño payoerara õ macaina õi yʉ bʉcʉariro jichʉ”, nia tire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ã jia Galileapʉ to sʉchʉ tó macaina tirore noano piti bocare. Tó pano Jerusalẽi bose nʉmʉi Jesu Cohamacʉ tuaa mehne to yoachʉ ñʉrina jire tina. ");
INSERT INTO gvc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ã yoa Canápʉ Galileai jiri macapʉ core vino to wahachʉ yoari macapʉ wahaa wahai sã tiro mehne. Caná cahai jiri macai Capernau wama tiri macai jipihtina bui pʉhtoro docai jiriro pʉhtoro macʉno dohatiro niha. ");
INSERT INTO gvc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tuhsʉ, Jesu Judeapʉ jiriro Galileapʉ to sʉchʉ pʉhtoro tʉhoha. Tíre tʉhoro Jesu cahapʉ wihire: —Yʉ macʉ yariaro nihre. Ã yoa tirore noariro wahachʉ yoai taga —ni tuaro mehne pjire tirore. ");
INSERT INTO gvc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","To ã nichʉ tʉhoro Jesu õ sehe ni yʉhtire: —Cohamacʉ tuaa mehne yʉ yoachʉ ñʉerana, ne yʉhʉre wacũ tuaerara mʉsa —nire Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","To ã nichʉ pʉhtoro sehe õ sehe nire: —Pʉhtoro, yʉ macʉ to yariahto pano taga —nire tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Tjuaahga. Mʉ macʉ catica —nire Jesu. To ã nichʉ tʉhoro, “To niriro seheta catirohca yʉ macʉ” nino, pʉhtoro tjuaa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ã tjuaarucurirore to cahamaca tirore piti boca, õ sehe ni yahuha: —Mʉ macʉ catihre —ni yahuha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Noho waroi sʉ̃ jichʉ noariro wahari tiro? —ni sinituha tiro to cahamacare. —Canʉre cohari pja baharocã juaro suruhre tirore —niha tina. ");
INSERT INTO gvc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ti ã nichʉ tʉhoro õ sehe ni tʉhotuha tiro: “Jesu yʉhʉre to ã ni yahuri pjaihta juaro surua wahari jire”, ni tʉhotuha pʉhtoro sehe. “Potocãta nino niri jira yʉhʉre” nino, tiro jipihtina to coyea mehne Jesure wacũ tuaha. ");
INSERT INTO gvc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesu Judea yahpapʉ jiriro Galilea yahpapʉ to sʉri baharo pʉhtoro macʉnore noariro to waharire mari quihõchʉ pʉa taha Cohamacʉ to tuaa mehne yoa ño tuhsʉre Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baharo judio masa Cohamacʉre sã ño payori bose nʉmʉri jichʉ Jesu Jerusalẽpʉ sʉre tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tói oveja wama tiri sopaca cahai cuhsʉri copa jihre. Sã judio masa ya mehne nia Betesda wama tiri copa jihre. Tí copa cahai cinco tihamahnoera tahti poca jihre. ");
INSERT INTO gvc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tí tahti pocai payʉ dohatiina coãre. Capari ñʉeraina, cʉ̃ bʉhʉsehe dahporo ñaina, pjacʉ bʉhaina tina tí copa cahai jia, co ñuhmi mʉa mʉjanore cohtaa nire. ");
INSERT INTO gvc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tópʉ buharo tí copa macaa core cãa tahari ñuhmichʉ yoa mʉjare anjo. Tí copa macaa co ñuhmiri baharo ña mio mʉhtariro sehe dohse jiare dohatiare cjʉariro noariro wahare. ");
INSERT INTO gvc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ã yoa tói treinta y ocho cʉhmari waro dohatiriro jire. ");
INSERT INTO gvc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tói to coãchʉ ñʉno to ã yoari pja dohatiriro jichʉ masire Jesu tirore. Ã masino tirore õ sehe ni siniture: —¿Pjacʉ dohatia marieriro ji duajari mʉhʉ? —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","To ã nichʉta dohatiriro õ sehe ni yʉhtire: —Tí co to ñuhmichʉ yʉhʉre co jiri copapʉ naboriro mariahna. Tí copapʉ yʉ ña mio duapachʉta paina sehe yʉ pano ã ña mio mʉhtarucura —nire tiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Wahcãrʉcaga. Mʉ coãri cahsarore naa, wahaga —nire Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","To ã nichʉta dohatiriro sehe to coãri cahsarore naa, ducu dʉcare. Tí dacho Sabado judio masa sã sori nʉmʉ jire. ");
INSERT INTO gvc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tí dachoi Jesu to ã yoachʉ ñʉa judio masa sã pʉhtoa sehe dohatiriro cjirore õ sehe ni yahuha: —Michare Sabado dacho mari sori nʉmʉ jipachʉta mʉ coãri cahsarore naahna mʉhʉ. Ã yoacʉ mari dutiare yʉhdʉrʉcai nina mʉhʉ —niha tina tirore. ");
INSERT INTO gvc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Yʉhʉre yʉ dohatiare cohãriro sehe õ sehe nire yʉhʉre: “Mʉ coãri cahsarore na, wahaga”, nire tiro yʉhʉre —ni yʉhtiha dohatiriro cjiro. ");
INSERT INTO gvc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Tíre mʉhʉre ã niriro sehe diro baro jijari tiro? —ni sinituha tina. ");
INSERT INTO gvc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tói masa payʉ ti jichʉ ñʉno Jesu sehe waha tuhsʉha. Ã jiro dohatiriro cjiro sehe tirore noariro wahachʉ yoarirore to wamare masieraha. ");
INSERT INTO gvc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Baharo Cohamacʉ wʉhʉi Jesu tirore piti boca, õ sehe ni yahure: —Tʉhosiniga mʉhʉ yʉhʉre. Mipʉre noano pjacʉ tira mʉhʉ. Ñaare yoa namoi tjiga. Pari turi ñaare yoa namocʉ mʉ dohatiriro yʉhdoro wahaihca mʉhʉ —nire Jesu tirore. ");
INSERT INTO gvc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","To ã niri baharo dohatiriro cjiro sehe sã judio masa pʉhtoa tirore sinituina cjiri cahapʉ sʉro, õ sehe ni yahuha tinare: —Jesu wama tiriro yʉhʉre noariro wahachʉ yoahre —ni yahuha tiro. ");
INSERT INTO gvc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ã yoa Sabado jichʉ Jesu dohatirirore to dohatiare to cohãchʉ masia judio masa sã pʉhtoa sehe tirore ñʉ tuhtia, yahusãa dua dʉcare. ");
INSERT INTO gvc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ã tirore ti yahusãa duachʉ masino Jesu sehe õ sehe ni yahure tinare: —Yʉ Pʉcʉ mipʉre dahrasinina. Yʉhʉ cʉ̃hʉ dahrasinii nija —ni yahure tirore yahusãa duainare. ");
INSERT INTO gvc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","To ã nichʉ judio masa sã pʉhtoa sehe tiro mehne tuaro suaa, tó pano ti niriro yʉhdoro tirore wajã duare. Sabado dachore sã sori nʉmʉre cʉ̃irore to noariro yoachʉ ñʉa tina suare. Ã suaa tiro Cohamacʉre “Yʉ Pʉcʉ” to nichʉ tʉhoa, tina sehe tó pano ti niriro yʉhdoro sua namoha tjoa. “ ‘Yʉhʉ Pʉcʉ’ nino, Jesu to basi ‘Cohamacʉ mehne cʉ̃no potori jija’, ni wacũca tiro”, ni tʉhoture judio masa sã pʉhtoa. ");
INSERT INTO gvc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ã yoa Jesu tinare õ sehe ni yahure: —Potocã mʉsare niita nija. Yʉhʉ, Cohamacʉ macʉno, yʉ mʉ sʉro yoaeraja. Yʉ Pʉcʉ to yoarire ñʉcʉ, tíre yoaja. ");
INSERT INTO gvc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉ Pʉcʉ yʉhʉre, to macʉnore, cahĩna. Ã jiro to yoarire yʉhʉre ño pahñona. Ahri mipʉ to tuaa mehne yʉ yoari yʉhdoro tiro payere yoa dutirohca yʉhʉre. To ã yoa dutichʉ to tuaa mehne yoa ñoihca yʉhʉ. Ã jina ñʉ cʉanahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yʉ Pʉcʉ yariarinare to masoriro seheta yʉhʉ cʉ̃hʉ yʉ cahmainare masoihtja. ");
INSERT INTO gvc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ne yʉ Pʉcʉ sehe masa ti ñaa buhirire buhiri dahreriro jierara. Yʉhʉ sehere tíre ti ñaa buhirire buhiri dahrehtirore cũre yʉ Pʉcʉ. Jipihtina masa tirore ti ño payoriro seheta yʉhʉ cʉ̃hʉre ti ño payohti cjihtire buhiri dahrehtirore cũre yʉhʉre. Yʉhʉre to macʉnore ño payoerana yʉ Pʉcʉ cʉ̃hʉre ño payoerara mʉsa. Tiro jira yʉhʉre warocariro —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ã ni tuhsʉ õ sehe ni yahu namore: —Potocãta mʉsare nii nija. Yʉ durucuare tʉhoina yʉhʉre warocarirore wacũ tuaina jipihtia dachoripe mʉanopʉ ã jirucuahca. Ã jicʉ tinare buhiri dahresi yʉhʉ. Ã jia tina pichacapʉ wahaborina yʉhdʉahca. ");
INSERT INTO gvc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Potocã mʉsare niita nija. Pichacapʉ wahahtina yʉhʉre Cohamacʉ macʉnore ti tʉhohti pja mipʉ jira. Baharopʉ cʉ̃hʉre yʉhʉre tina tʉhoahca tjoa. Ã tʉhoa tʉho nʉnʉina sehe Cohamacʉ mehne ã jirucuahca. ");
INSERT INTO gvc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cohamacʉ yʉ Pʉcʉ sehe ã jirucuchʉ yoariro jira. Ã jiro yʉhʉre to macʉnore ã jirucuchʉ yoahtiro ji dutire tiro yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ã jicʉ yʉhʉ masʉno Cohamacʉ to warocariro yʉ jichʉ tiro masare buhiri dahrehtirore cũre yʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ahrire tʉhona, tʉho cʉaena tjiga mʉsa. Pa dachopʉre jipihtina yariaina masa coparipʉ jiina yʉ durucuchʉ tʉhoahca. ");
INSERT INTO gvc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ã tʉhoa, noaare yoaina cjiri jipihtia dachoripe Cohamacʉ mehne jihtina cjihti masa mʉjaahca. Ñaare yoaina cjiri sehe ñaare ti yoari buhiri pichacapʉ wahaahca —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ã ni tuhsʉ õ sehe ni yahu namore: —Yʉhʉ yʉ mʉ sʉro ne yoaeraja. Ne yʉ basi yʉ cahmano yoa duaeraja. Yʉhʉre warocariro to dutiriro seheta yoa duaja. Ã jicʉ to niriro seheta buhiri dahreja. Tuhsʉ yʉhʉ masare buhiri dahrecʉ quihõnota yoaja. ");
INSERT INTO gvc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Yʉhʉ tuariro jija”, yʉ ni yahuchʉ “Mʉ yahua ne quihõno jierara”, ni masiboca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pairo jira yʉhʉre yahuriro. Tiro João sehe masare yahure yʉhʉre. Masare yʉhʉre to yahuri cjiri quihõno tjira. Tíre yʉhʉ noano masija. ");
INSERT INTO gvc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mʉsa paina sehere Joãopʉre yʉhʉre sinitu dutina warocare. Ã jiro potocãta yahure tiro mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Cohamacʉ macʉno jira ahriro”, yʉhʉre ni yahuhtinare macaeraja. Ã macaerapacʉta João masʉno to jipachʉta yʉhʉre “Cohamacʉ macʉno jira”, to ni yahurire yahui nija. Mʉsa yʉhʉre wacũ tuahti cjihtire, mʉsa pichacapʉ wahaborina mʉsa yʉhdʉhti cjihtire yʉhʉre João to yahurire yahui nija. ");
INSERT INTO gvc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Sihãria mahaa dachoricã to ñʉ masichʉ yoaro seheta João mʉsare buhe mʉhtano mahanocã to catiro puro mʉsare masichʉ yoare. To ã buhechʉ tʉhona mahaa dachoricã wahchere mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yʉ jia tiare to ã buhepachʉta Cohamacʉ sehe yʉ jiare noano yahura. To ã yahuchʉ João yʉ jiare to yahua yʉhdoro jira Cohamacʉ ya yahua. Ã jicʉ Cohamacʉ to tuaa mehne yʉhʉre to yoa dutiri cjirire mipʉ yoai nija. Ahrire yʉ yoachʉ ñʉna potocãta Cohamacʉ to warocariro yʉ jiare masina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ã yoa yʉ Pʉcʉ yʉhʉre warocariro to basi “Tiro yʉ warocariro jira”, ni yahura mʉsare. To ã ni yahupachʉta to durucuare ne tʉhoerare mʉsa. Ã jina mʉsa tirore ne masierare. ");
INSERT INTO gvc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yʉhʉre Cohamacʉ warocarirore mʉsa ne tʉho duaerare. Ã jina mʉsa Cohamacʉ yare ne cahmaerare. ");
INSERT INTO gvc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Cohamacʉ yare ti joari pũre mʉsa buhena, “Mari ahri pũre buhena jipihtia dachoripe Cohamacʉ mehne ã jirucunahca”, nina mʉsa. Tí pũita yʉhʉre yahura. ");
INSERT INTO gvc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tí pũ yʉhʉre to yahupachʉta mʉsa sehe yʉhʉre cahmaerara. Jipihtia dachoripe Cohamacʉ mehne mʉsa ã jirucuhti cjihtire yʉhʉre sini duaerara mʉsa —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ã ni tuhsʉ õ sehe ni namore: —Yʉhʉre mʉsa ño payoerachʉ ñʉcʉ suaeraja yʉhʉ sehe. ");
INSERT INTO gvc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉsa sehe Cohamacʉre mʉsa cahĩerachʉ masija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cohamacʉ yʉ Pʉcʉ yʉhʉre to dutiriro seheta yʉ tapachʉta mʉsa yʉhʉre cahmaerare. Pairo sehere Cohamacʉ tirore warocaerariro to jipachʉta to mʉ sʉro to tapachʉta tiro sehere cahmanahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Paina masa mʉsare ti ño payochʉ cahmana mʉsa. Cohamacʉ mʉsa mehne to ji coachʉ cahmaerara mʉsa. Tiro dihta Cohamacʉ waro jira. Ã cahmaerana yʉhʉre tʉhoerara mʉsa. Yʉhʉre wacũ tuaerara. ");
INSERT INTO gvc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʉsare yʉ Pʉcʉpʉre ne yahusãsi yʉhʉ. Tíre masiga mʉsa. Moise cjiro to joari pũ sehe mʉsare yahusãnohca. “Tí pũ macaa dutiare mari yoa pahñona, Cohamacʉ cahai wahanahca”, mʉsa niri pũ sehe mʉsare yahusãnohca. ");
INSERT INTO gvc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moise cjiro to joari pũi yʉhʉ sehere yahuha. Ã jina tí pũre “Potocã tjira” nina, yʉ yahua cʉ̃hʉre “Potocã tjira”, niboa mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moise cjiro to joari pũre “Potocã tjira” nierana, yʉ ya durucua cʉ̃hʉre “Potocã tjira”, nisi mʉsa —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ã to buheri baharo yoa cureri pja baharo Galilea wama tiri bʉcʉpariro pa bʉhʉsehe coapʉ sã to buheinare Jesu sʉho pahãa wahare. Tí taro pjiri taro pa wama Tiberia wama tire. ");
INSERT INTO gvc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tó pano Galilea yahpai Jesu Cohamacʉ tuaa mehne yoa ño, dohatiinare ti dohatiare to cohãchʉ masa ñʉa tire. Ã jia Jesu to pahãchʉ ñʉa, masa payʉ tirore nʉnʉ ti pahãre. ");
INSERT INTO gvc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ã yoa baharo tí taro dʉhtʉ cahapʉ Jesu sãre sʉho pahã sʉ, tʉ̃cʉpʉ mʉja, tʉ buipʉ sãre sʉho dujire. ");
INSERT INTO gvc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tí dachore Pascua wama tiri bose nʉmʉ cjihto, sã judio masa ya bose nʉmʉ sʉhti dacho cjihto mahaa dachoricã dʉhsare. ");
INSERT INTO gvc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Tópʉ dujiro, Jesu payʉ masa to cahapʉ ti tarucuchʉ ñʉre. Ã ñʉno Felipere õ sehe ni sinitu ñʉre: —¿Ahrina masa ti chʉhti cjihtire nohopʉ nuchʉnahcari mari? —nire Felipere. Jesu to basi to yoahtire masiparota Felipere ã sinitu ñʉre “¿Dohse ni yʉhtirohcari?” nino. ");
INSERT INTO gvc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","To ã sinitu ñʉchʉ tʉhoro Felipe sehe õ sehe ni yʉhtire: —Ocho sʉ̃ri posa dahra wapataa niñeru mehne chʉare mari nuchʉpachʉta masare cãinare daacã chʉare mari witipachʉta ne mʉ sʉsi —nire Felipe Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ã yoa pairo, sã mehne macariro Andre, Simo Pedro bahʉro sehe Jesure õ sehe ni yahure: ");
INSERT INTO gvc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ahriro wahma wahmʉa tariro cinco pão curirire, ã jichʉ wahi pʉarocã cʉ̃hʉre cjʉara. Wiho mejeta masa sehe payʉbia jira. Ã jiro ahri mahanocã chʉa ne mʉ sʉsi —nire Andre. ");
INSERT INTO gvc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","To ã niri baharo: —Masare duji dutiga mʉsa —nire Jesu sã to buheinare. Tói daacã tja jiro jire. Sã duji dutichʉ masa nuju sʉ pihtiare tja bui. Tina mʉa dihtare sã quihõchʉ cinco mil wahtaroi jire. ");
INSERT INTO gvc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ti ã nuju sʉchʉ ñʉno Jesu sehe pãore na, Cohamacʉre “Noana”, nire. Ã ni tuhsʉrota sãre to buheinare witi dutire. To ã dutichʉ sã sehe tói dujiinare witi wahcãi. Tuhsʉ, pʉaro wahi cʉ̃hʉre witihi tinare. Jipihtinare noano ti chʉ duaro puro chʉare tinare witihi. ");
INSERT INTO gvc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Baharo masa sehe yapi yʉhdʉa wahare. Ti ã yapi yʉhdʉachʉ ñʉno Jesu sãre õ sehe ni yahure: —Ti chʉ dʉharire noano saa cahmachu pahñoga. Ã yoana ti chʉ dʉhaare ne bosi —nire. ");
INSERT INTO gvc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","To ã nichʉ tʉhona sã sehe cinco pão curiri dʉhsarire sã saa cahmachuchʉ doce pʉhʉse waro wijare. ");
INSERT INTO gvc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ã jia Jesu tíre to tuaa mehne to yoa ñochʉ ñʉa, masa sehe õ sehe nire: —Potocãta jira. Ahriro Cohamacʉ yare yahu mʉhtariro ahri yahpapʉ “Tarohca”, ti niriro mari cohtariro tjira —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ã jia tina Jesure ti pʉhtoro jihtiro cjihtore ñaha sõ duamare. Jesu ti ã ni tʉhotuare masino pari turi cʉ̃irota tʉ̃cʉpʉ wahaa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ñamichahapʉ sã to buheina bʉcʉpariropʉ buhai. ");
INSERT INTO gvc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tópʉre buhu sʉ, dohoriapʉ samu, Capernau wama tiri macapʉ majare pahãi. Tí pjare sã majare pahãri pjare ñamipʉ jire. Jesu sehe sã cahapʉ tju wihierasinire mini. ");
INSERT INTO gvc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sã ã majare pahãno watoi wihnono tuaro sãre tachʉ, pahcõri bʉjʉa pahcõri wahcãre. ");
INSERT INTO gvc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sã cinco kilómetro sʉboro waroi sã sʉchʉ waro Jesu sãre mʉ sʉre. Co buipʉ to tachʉ ñʉi sã. Ã sã cahai to tachʉ ñʉna, sã sehe cʉa yʉhdʉa wahacʉrʉ. ");
INSERT INTO gvc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sã ã cʉa yʉhdʉachʉ ñʉno tiro sãre õ sehe ni yahure: —Cuiena tjiga. Yʉhʉta jija —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","To ã nichʉ tʉhona sã wahchea mehne tirore piti boca samu dutihi. To samuri baharocãta wacũenoca sã wahari yahpapʉre pahã sʉ tuhsʉhi. ");
INSERT INTO gvc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ã yoa tí ñamine masa bʉcʉpariro pa bʉhʉsehe coapʉ tjuaina sehe sã yaria bʉsoca, sã pahãhtia cʉ̃ria to jichʉ ñʉre. Tia mehne sã sahsero sã pahã wahachʉ cʉ̃hʉre ñʉre tina. Tuhsʉ Jesu sã mehne to pahãerachʉ ñʉre tina. Ã jia pa dachoi tirore tói cohtaa niri jimare tina. ");
INSERT INTO gvc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ti ã cohtaro watoi, paye bʉso, Tiberia wama tiri macapʉ taa bʉso Jesu Cohamacʉre “Noana”, to niriro cahacã cureropʉ, masare to chʉa witiriro cahacã cureropʉ wahã sʉri jire tí bʉso. ");
INSERT INTO gvc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ã yoa sãre Jesu to sʉho jimarirore to mariachʉ ñʉa, masa tí bʉsopʉ samu, Capernaupʉ sãre nʉnʉ ti pahã tari jire, Jesure maca taa. ");
INSERT INTO gvc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ti pahã wihiri baharo, Jesure boca wihi, tina masa õ sehe ni sinitu ñʉre tirore: —Buheriro, ¿dohse jichʉ tari mʉhʉ õpʉre? —ni sinitu ñʉre tina. ");
INSERT INTO gvc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ti ã ni sinitu ñʉchʉ, Jesu tinare õ sehe ni yahure: —Potocã niita nija mʉsare. Yʉhʉ mʉsare Cohamacʉ tuaa mehne yʉ yoa ñopachʉta yʉhʉre sehere wacũ tuaerara mʉsa. Yʉhʉre wacũ tuaerapanahta yʉhʉre macana mʉsa. Yʉhʉ mehne bʉjʉa chʉ, mʉsa yapirina cjiri jina yʉhʉre maca tari jira mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Wiho mejeta chʉa ne ã jirucuerara. Baharopʉ pihtia wahara. Ã jina tíre ã macarucuena tjiga mʉsa. Paye baro chʉa soro jia chʉare macaga mʉsa. Tí soro jia chʉare bocana jipihtia dachoripe Cohamacʉ mehne jirucunahca. Ã jia tí chʉa pinihta ne pihtisi. Tí chʉare yʉhʉ masʉno Cohamacʉ warocariro mʉsare waihtja. Cohamacʉ yʉ Pʉcʉ yʉhʉre tí baro chʉare wa dutiriro jira. Tirota to warocariro yʉ jiare ño tuhsʉre mʉsare —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","To ã nichʉ tʉhoa tina õ sehe ni sinitu ñʉre tirore: —¿Cohamacʉ to yoa dutiare yoana tana dohse yoanahcari sã? —ni sinitu ñʉre tina. Jesu sehe ti ã nichʉ tʉhoro, õ sehe ni yʉhtire tinare: ");
INSERT INTO gvc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Cohamacʉ mʉsare õ sehe dutira. To warocarirore mʉsa noano tʉho, wacũ tuachʉ cahmana tiro —ni yʉhtire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","To ã nichʉ tʉhoa tina õ sehe nire tjoa: —Cohamacʉ warocariro jicʉ tiro to tuaa mehne yoa ñoga sãre mʉhʉre sã noano wacũ tuahto cjihtore. ¿Yaba barore yoa ñobocari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mari ñʉchʉsʉma cjiripʉ panopʉ macaina masa marienopʉ maná wama wama tiare chʉa tiha. Cohamacʉ yare ti joari pũpʉ õ sehe ni yahura: “Tiro tinare mʉano macaa chʉare waa tiha ti chʉhti cjihtire”, ni joaa tiha Cohamacʉ yare ti joari pũpʉ. ¿To ã yoariro seheta yoaihcari mʉhʉ cʉ̃hʉ? —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti ã nichʉ tʉhoro õ sehe ni yahure Jesu tinare: —Potocã mʉsare niita nija: Moise cjiro mʉano macaa chʉare waera tire mʉsare. Yʉ Pʉcʉ sehe mʉano macaa chʉare potocã jia chʉare mʉsare wariro jira. ");
INSERT INTO gvc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cohamacʉ to chʉa mʉanopʉ duji ta, jipihtiro yahpa macainare catichʉ yoa masina —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Pʉhtoro, dachoripe tí baro chʉare ã warucuga sãre —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ti ã nichʉ tʉhoro, Jesu sehe õ sehe ni yahure tinare tjoa: —Yʉhʉ sehe catichʉ yoaa chʉa yoaro sehe jiriro jija. Mari ya chʉare mari chʉri baharocãta dóicãta jʉca baa wahaja mari tjoa. Sihnia cʉ̃hʉre mari sihniri baharocãta ñahma yapioa wahaja tjoa. Wiho mejeta diro yʉhʉre cahmariro, yʉhʉre wacũ tuariro, ne jʉca baaerariro yoaro seheta to wahchea sehe tirore ne pihtisi. ");
INSERT INTO gvc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mʉsa sehe yʉhʉre ñʉpanahta yʉhʉre wacũ tuaerasinina mini. Tíreta mʉsare yahumahi yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jipihtina yʉ Pʉcʉ yʉ yaina cjihtire yʉhʉre to cũrina sehe yʉhʉre cahmaahca. Ã jii yʉhʉre cahmainare ne cohãsi yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mʉanopʉ tacʉ yʉ cahmano yoai tai nierahi. Yʉhʉre warocariro to cahmariro seheta yoai tai nii yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ahrita jira yʉhʉre warocariro to cahmaa waro: Jipihtina yʉ yaina cjihti yʉhʉre to warina cjirire yʉ boerachʉ cahmana yʉhʉre warocariro pihtiri dachoi ti masa mʉjahto cjihtore. ");
INSERT INTO gvc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jipihtina yʉhʉre Cohamacʉ macʉnore ñʉina, yʉhʉre wacũ tuaina jipihtia dachoripe tiro mehne ti jirucuchʉ cahmana yʉ Pʉcʉ. Ã jicʉ pihtiri dachoi tinare masoihtja —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Yʉhʉ mʉanopʉ taa chʉa yoaro sehe jiriro jija”, to nichʉ tʉhoa judio masa sã pʉhtoa sehe tiro mehne sua, ");
INSERT INTO gvc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ti basi Jesure ñano ni durucure: —¿Ahriro Jesu José macʉno jierajari? To pʉcʉro, to pocoro cʉ̃hʉre mari masija. Tuhsʉ mari yoaro sehe pjacʉ tirirota jira. ¿Ã jiparota dohsearo “Mʉanopʉ tahi”, nijari tiro? —ni suare tina. ");
INSERT INTO gvc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ti ã nichʉ tʉhoro Jesu õ sehe ni yahure tinare: —Mʉsa yʉhʉre ñano ni durucuena tjiga. ");
INSERT INTO gvc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yʉ Pʉcʉ yʉhʉre warocariro sehe masare yʉhʉ sehere cahmachʉ yoara. To ã yoaerachʉ masa sehe yʉ yaina ji masieraboa. Pihtiri dachoi yʉ yainare masoihca yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Cohamacʉ yare yahu mʉhtaina cjiri sehe õ sehe ni joaa tiha: “Cohamacʉ tinare buherohca”, ni joaa tiha Cohamacʉ yare yahu mʉhtaina cjiripʉ. Jipihtina yʉ Pʉcʉ to buheare tʉhoina, tirore yʉhtiina yʉhʉre cahmana. Ã jia yʉ yaina jira. ");
INSERT INTO gvc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Yʉ Pʉcʉre ne cʉ̃iro masʉno ñʉerare. Yʉhʉ Cohamacʉ warocariro dihta yʉ Pʉcʉre ñʉhi. ");
INSERT INTO gvc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Potocã niita nija mʉsare. Yʉhʉre wacũ tuariro jipihtia dachoripe yʉ Pʉcʉ mehne ã jirucurohca. ");
INSERT INTO gvc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉhʉ catichʉ yoaa chʉa yoaro sehe jiriro jija. ");
INSERT INTO gvc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉsa ñʉchʉsʉma cjiri masa marienopʉ manáre chʉa tiha. Ã tíre chʉpahta yariaa wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mʉanopʉ taa chʉare yʉ nia chʉare masʉno chʉro, ne pichacapʉ wahasi. ");
INSERT INTO gvc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉhʉ mʉanopʉ taa chʉa catichʉ yoaa chʉa yoaro sehe jiriro jija. Ahri chʉare chʉriro jipihtia dachoripe yʉ Pʉcʉ mehne ã jirucurohca. Ahri chʉa catichʉ yoaa chʉa yoaro sehe jia yʉ pjacʉta jira. Jipihtiri yahpa macaina Cohamacʉ mehne ti ã jirucuhti cjihtire yʉ pjacʉre waihtja. Ã wacʉ yariaihca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","To ã nichʉ tʉhoa sã coyea judio masa sehe tíre õ sehe ni durucure ti basi: —¿Ahriro dohse yoa to pjacʉre chʉhti cjihtire warohcari? —nire tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ti ã nichʉ tʉhoro Jesu õ sehe ni yahure: —Potocã niita nija mʉsare. Yʉhʉ masʉno Cohamacʉ warocariro jija. Yʉ pjacʉre chʉerariro, yʉ dire sihnierariro Cohamacʉ ya catia mehne ã jirucusi. ");
INSERT INTO gvc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yʉ pjacʉre chʉriro, yʉ dire sihniriro yʉ ya catia mehne ã jirucurohca. Ã jicʉ pihtiri dachoi tirore masoihtja. ");
INSERT INTO gvc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉ pjacʉ potocãta chʉa waro yoaro sehe jira. Yʉ di potocãta sihnia waro yoaro sehe jira. ");
INSERT INTO gvc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yʉ pjacʉre chʉriro yʉ dire sihniriro yʉhʉ mehne wahchea mehne jirucura. Yʉhʉ cʉ̃hʉ tiro mehne wahchea mehne jirucuja. ");
INSERT INTO gvc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉ Pʉcʉ yʉhʉre warocariro ã jirucura. Ã jirucuro, yʉhʉ cʉ̃hʉre ã jirucuchʉ yoara. Ã jia yʉhʉre ã jirucurirore masa chʉa, Cohamacʉ mehne mʉanopʉ ã jirucuahca tina cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ahrita jira mʉanopʉ taa chʉa. Mari ñʉchʉsʉma cjiri maná wama tia ti chʉri cjiri yoaro sehe jierara ahri chʉa. Tina sehe tí chʉare chʉpahta yariaa wahaa tiha. Ahri chʉa sehere chʉriro mʉanopʉ ã jirucurohca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaupʉ judio masa sã buheri wʉhʉi Jesu buhero, ãta ni yahure. ");
INSERT INTO gvc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Payʉ Jesure cahmaina to ã ni buheare tʉhoa, õ sehe ni durucure: —Ahri buhea nucu mijona. Ã jina mari tʉho duaera cureja —ni durucure tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ti ã nichʉ Jesu sehe ti durucuare masire. Ã masino tiro õ sehe ni siniture tinare: —¿Ahri buheare tʉhona suajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Yʉhʉ masʉno Cohamacʉ warocariro mʉanopʉ yʉ tjuaa wahachʉ ñʉna dohse ni tʉhotubocari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu Santo masʉnore catichʉ yoara. Masa sehe ti basi catichʉ yoaerara. Espíritu Santo masare to catichʉ yoariro seheta yʉ buhea sehe mʉsare Cohamacʉ mehne ã jirucuchʉ yoara. ");
INSERT INTO gvc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Cãina mʉsa mehne macaina ne yʉhʉre wacũ tuaerara —nire Jesu. Wahmanopʉre Jesu tirore wacũ tuaerainare masire. Tirore ñʉ tuhtiinare ñohtiro cʉ̃hʉre masi tuhsʉre. Ã tirore wacũ tuaerainare masino “Cãina mʉsa mehne macaina yʉhʉre wacũ tuaerara”, nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ã ni tuhsʉ õ sehe ni namore: —Õ sehe ni yahumahi mʉsare: “Yʉ Pʉcʉ sehe masare yʉhʉ sehere cahmachʉ yoara. To ã yoaerachʉ masa sehe yʉ yaina ji masieraboa”, mʉsare nii nimahi —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","To ã ni buhechʉ tʉhoa payʉ Jesure cahmamarina cjiri tirore cohã, tiro mehne pari turi wahaerare. ");
INSERT INTO gvc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ti ã yoachʉ ñʉno Jesu sãre doce to buheinare õ sehe ni siniture: —¿Mʉsa cʉ̃hʉ yʉhʉre cohãnahcari? —ni siniture sãre. ");
INSERT INTO gvc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","To ã nichʉ Simo Pedro õ sehe ni yʉhtire tirore: —Pʉhtoro, sãre pairo buheriro mariahna. Mʉ ya buheare tʉhona Cohamacʉ mehne ã jirucunahca sã. Mʉ ya buhea dihta tíre yahura sãre. ");
INSERT INTO gvc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ã jina sã mʉhʉre wacũ tuaja. Ã yoa mʉhʉ noariro, Cohamacʉ macʉno to warocariro mʉ jichʉ sã masija. Ã jina mʉhʉre cohãsi sã —nire Simo Pedro Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","To ã nichʉ tʉhoro Jesu õ sehe ni yahure sãre: —Yʉhʉ sehe mʉsare doce besehi. Wiho mejeta cʉ̃iro mʉsa mehne macariro watĩno yairo cjihto jira —nire sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ã nino Judare Simo Iscariote macʉnore nino niri jire. Juda sehe doce buheina sã mehne macariro Jesure ñʉ tuhtiinare ñohtiro jire. ");
INSERT INTO gvc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Baharo Jesu Galilea yahpai tinino wahare. Judea yahpai judio masa tirore wajã duare. Ti ã wajã duachʉ masino tiro tí yahpapʉ wahaerare. ");
INSERT INTO gvc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judio masa daa wʉhʉsecã sã yoahti nʉmʉri bose nʉmʉri mahanocã dʉhsatjiãhre. ");
INSERT INTO gvc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ã jia Jesu bahana tirore õ sehe ni yahure: —Judeapʉ wahaga. Tói mʉ yainare Cohamacʉ tuaa mehne mʉ ñohtiro cjihto wahaga mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Masare yoa ño duacʉ yaeraro cahmana mʉhʉre. Yoa ñono cahmana. Potocãta Cohamacʉ tuaa mehne yoariro jicʉ tíre masare ñoga —nimare tina. ");
INSERT INTO gvc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","To bahana jipahta Jesure “Cohamacʉ macʉno jira”, nierare. Ã jia, ã nire tina tirore. ");
INSERT INTO gvc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ti ã niri baharo Jesu õ sehe ni yahure tinare: —Masa yʉhʉre ti noano masihti pja dʉhsasinina mini. Mʉsa sehe ñʉ duana bose nʉmʉri jichʉ waha masina. ");
INSERT INTO gvc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ahri yahpa macaina mʉsare ñʉ tuhtierara. Yʉhʉ ti ñaa buhirire yʉ yahuchʉ tina yʉhʉ sehere ñʉ tuhtira. ");
INSERT INTO gvc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bose nʉmʉ jichʉ wahaga mʉsa sahsero. Yʉhʉre yʉ wahahto dʉhsasinina mini. Ã jicʉ yʉhʉ sehe bose nʉmʉrine ñʉi wahaerasinija —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ã nino tiro Galileai tjuare. ");
INSERT INTO gvc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bose nʉmʉripʉ Jesu bahana ti ñʉa wahari baharo Jesu cʉ̃hʉ ti baharo wahare. Ã waharo masa ti ñʉeraro watoi wahare. ");
INSERT INTO gvc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bose nʉmʉrihi jiina judio masa sã pʉhtoa tirore macare: —¿Nohopʉ jicari tiro? —ni sinituha tina. ");
INSERT INTO gvc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ã jia masa cʉ̃hʉ Jesure payʉ yahuwajaha. Paina “Tiro noariro jira”, niha. Paina sehe “Tiro ñariro jira. Masare mahñoriro jira”, ni yahuwajaha tina. ");
INSERT INTO gvc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ã nipahta judio masa sã pʉhtoare cuia, masa ti ñʉeraropʉ Jesure yahuwajaha. ");
INSERT INTO gvc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bose nʉmʉri dacho macai Cohamacʉ wʉhʉpʉ Jesu sãa sʉro, buhere. ");
INSERT INTO gvc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","To ã buhechʉ sã coyea judio masa tʉho cʉaa waha, õ sehe nire: —¿Ahriro buheropʉ buhemahnoerariro jiparota dohsearo noano masi pahñonocajari? —nire tina tirore. ");
INSERT INTO gvc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ti ã nichʉ Jesu õ sehe ni yahure tinare: —Yʉ buheri cjiri yʉ ya durucua jierara. Yʉhʉre warocariro ya durucua sehe jira ahri buhea. ");
INSERT INTO gvc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cohamacʉ cahmaare yoa duaina yʉ buhea sehere Cohamacʉ ya durucua ti jichʉ masiahca. Yʉ mʉ sʉro yʉ buherachʉ cʉ̃hʉre masiahca tina. ");
INSERT INTO gvc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cʉ̃iro to mʉ sʉro to masia mehne buheriro jiro “Yʉhʉ dihtare ño payoga”, niriro jira tiro. Wiho mejeta yʉhʉre warocariro sehere mʉsa ño payochʉ cahmaja yʉhʉ sehe. Yʉ ã nichʉ tʉhona “Potocã durucuriro jira tiro. Ne mahñoerara”, ni masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Cohamacʉ dutiare Moise cjiro sehe cũa tiha mʉsare. To ã cũpachʉta mʉsa jipihtina tí dutia sehere ne yʉhtierare. ¿Dohseana yʉhʉre wajã duajari mʉsa? —nire Jesu sã coyea judio masare. ");
INSERT INTO gvc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Mʉhʉ tʉho masierariro, watĩno to cohtotariro jira. Mʉhʉre wajã duaina mariahna —ni yʉhtire tina Jesure. Ti ã nichʉ Jesu õ sehe ni yʉhtire: ");
INSERT INTO gvc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—Sori nʉmʉ Sabado jichʉ cʉ̃ tahata Cohamacʉ tuaa mehne dohatiriro to dohatiare yʉ cohãchʉ mʉsa ñʉ cʉaa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mari ñʉchʉsʉma cjiri panopʉ macaina sehe ti pjacʉre mahanocã cahsarocãre yihsoina ti yoariro seheta Moise cjiro yihso dutiha. To ã dutichʉ Sabado mari sori nʉmʉ jipachʉta masʉnore to pjacʉre mahanocã cahsarocãre yihsora mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sabado jichʉ masʉnore to pjacʉre mahanocã cahsarocãre yihsora mʉsa, Moise cjiro dutiri cjirire yoana tana. ¿Mʉsa cʉ̃hʉ Sabado dachoi tíre yoapanahta tí dachoi dohatirirore jipihtia to pjacʉre noariro yʉ yoachʉ ñʉna dohseana yʉhʉ mehne suari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yʉ yoarire mʉsa noano masierapanahta, yʉhʉre ñano tʉhotuena tjiga. Mʉsa noano masiri baharo yʉhʉre mʉsa tʉhotua potocã tjiahca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","To ã ni yahuri baharo mahainacã Jerusalẽ macaina tirore õ sehe ni yahuwajare: —¿Ahriro judio masa pʉhtoa ti wajã duariro jierajari? ");
INSERT INTO gvc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ã tirore ti wajã duapachʉta jipihtina panoi masare buhero nina tiro. Wiho mejeta tirore wajã duaina jipahta ã ñʉnocahna. “Tiro potocãta Cristo jira”, ¿ni tʉhotubocari pʉhtoa sehe? ");
INSERT INTO gvc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wiho mejeta ahriro Jesu to tarirore sã masija. Cristo sehe masare yʉhdʉchʉ yoahtiro to tachʉ to tariro sehere masimahnoerara. Ã jiro masare yʉhdʉchʉ yoahtiro Cristo waro jierara Jesu —ni yahuwajare tina Jerusalẽ macaina. ");
INSERT INTO gvc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ti ã niare masino, Jesu õ sehe ni tuaro sañurucu buhere Cohamacʉ wʉhʉi: —Yʉhʉre õ sehe ni tʉhotura mʉsa: “Tirore masija. Ã jina to tariro cʉ̃hʉre masija”, ni tʉhotumana mʉsa. Mʉsa ã ni tʉhotupanahta yʉhʉre warocarirore ne masierara mʉsa. Yʉhʉre warocariro potocã niriro, potocã yoariro jira. Tirore ne masierara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tirota yʉhʉre warocare. Ã jicʉ tiro cahapʉta tahi. Ã jicʉ yʉhʉ sehe tirore masija —nire Jesu judio masare. ");
INSERT INTO gvc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","To ã nichʉ tʉhoa tirore ñaha duamare. Ti ã ñaha duapachʉta Jesu to ñano yʉhdʉhti pja dʉhsasinire. Ã jia tina tirore ñaha masierare. ");
INSERT INTO gvc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Paina masa sehe payʉ tirore wacũ tua, õ sehe nire: —Ahriro Jesu sehe payʉ tahari Cohamacʉ to tuaa mehne yoa ño tuhsʉre. Jipihtina paina yʉhdoro Cohamacʉ tuaa mehne yoa ñohna tiro. Ã yoarota Cristo Cohamacʉ to warocariro tjira ahriro Jesu —nire Jesure wahma wacũ tua dʉcaina. ");
INSERT INTO gvc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Masa Jesure ti ã ni durucuchʉ tʉhoa sacerdotea pʉhtoa, fariseo curua macaina mehne Jesure ñaha dutia warocaha surarare. ");
INSERT INTO gvc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ã jiro Jesu judio masare õ sehe nire: —Mahaa dachoricã mʉsa mehne jisiniihca. Ã jicʉ baharocãta yʉhʉre warocariro cahapʉ wahaihca. ");
INSERT INTO gvc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉ jihtopʉ mʉsa waha masierara. Ã jina yʉhʉre macapanahta ne bocasi mʉsa —nire Jesu judio masare. ");
INSERT INTO gvc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","To ã nichʉ tʉhoa tina ti basi õ sehe ni durucure: —¿Ahriro ã nino nohopʉ wahabocari, mʉsa tʉhotuchʉ? ¿Griego masa cahai judio masa waha siteina ti jia macari cjiripʉ griego masapʉre buhero wahabocari ahriro? ");
INSERT INTO gvc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Yʉ jihtopʉ mʉsa waha masierara. Ã jina mʉsa yʉhʉre macapanahta ne bocasi”, to nichʉ ¿dohse nino baro ahriro ã nijari? —ni durucure judio masa ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bose nʉmʉri pihtiri dacho tí dacho waro jiro nire. Tí dachoi Jesu tói ducuro, tuaro mehne sañurucu õ sehe ni yahure: —Ñahma yapioina core ti tuaro cahmano seheta jipihtia dachoripe Cohamacʉ mehne mʉsa jihtire tuaro cahmaina yʉhʉre siniga. Mʉsa ã sinichʉ Cohamacʉ yaina mʉsare ji dutiihtja. ");
INSERT INTO gvc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yʉhʉre wacũ tuainare õ sehe ni joaa tiha Cohamacʉ yare ti joari tjui: “Mári pohtaripʉ catichʉ yoaa co to ã wijaarucuro seheta Cohamacʉ yaina mehne catichʉ yoariro ã jirucurohca”, ni joaa tiha Cohamacʉ yare ti joari tjui —ni yahure Jesu judio masare. ");
INSERT INTO gvc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ã catichʉ yoarirore wama payo yahuro “Yʉhʉre wacũ tuainare Espíritu Santo sãarʉcʉ sʉ mʉa waharohca”, nino nire Jesu. Tiro mʉanopʉ to mʉjaerasinichʉ Espíritu Santo sehe wihierasiniha. ");
INSERT INTO gvc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesu to ã nichʉ tʉhoa, masa payʉ õ sehe ni durucure: —Ahriro potocãta Cohamacʉ yare yahu mʉhtariro mari cohtariro jira —nire masa. ");
INSERT INTO gvc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Õ sehe nire paina sehe: —Ahriro Cristo marine yʉhdʉchʉ yoahtiro jira —nire. Paina sehe õ sehe nire tjoa: —Cristo taro, Galilea yahpa macariro jisi tiro. Ahriro Jesu sehe tó macariro tjira. ");
INSERT INTO gvc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cristo Davi cjiro panamino ji turiariro jirohca. Ã jiro Davi ya maca cjiroi Belẽi Cristo masa bajuarohca. Õ seheta ni yahura Cohamacʉ yare ti joari pũi. Ahriro Jesu sehe Belẽi masa bajueraha. Ã jiro tiro Cohamacʉ to warocariro Cristo waro jierara —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ã jia Jesure tʉhomarina cjiri tju ware ti basi pʉa curua. ");
INSERT INTO gvc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mahainacã masa sehe Jesure ñaha duamare. Ã ñaha duapahta tirore ñahaerare. ");
INSERT INTO gvc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ã yoa surara sacerdotea pʉhtoa cahapʉ fariseo curua macaina cahapʉ tjuaa wahaha. Ti tju sʉchʉ ñʉa tina surarare sinituha: —¿Dohseana Jesure ñahaerari mʉsa? —ni sinituha tina sehe. ");
INSERT INTO gvc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Tiro noaputiaro durucuriro jihre. Paina tiro yoaro sehe durucuina ne mariahna —ni yʉhtiha surara tinare. ");
INSERT INTO gvc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ti ã nichʉ fariseo curua macaina sehe õ sehe ni yahuha: —¿Mʉsare to mahñochʉ “Potocã nino nica”, niri mʉsa cʉ̃hʉ? ");
INSERT INTO gvc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mari pʉhtoa Jesure wacũ tuaeraina jia ne tirore cahmaerare. Sã cʉ̃hʉ ã jina tirore cahmaeraja. ");
INSERT INTO gvc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ahrina masa sehe Cohamacʉ dutiare Moise cjirore to cũrire masierara. Ã masieraina jia Jesure wacũ tuaina jia tirore cahmana. Ti ã cahmari buhiri tinare Cohamacʉ buhiri dahrerohca —niha fariseo curua macaina. ");
INSERT INTO gvc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fariseo curua macariro Nicodemo Jesure sʉhʉduro sʉriro cjiro tói jiha tina mehne. Ti ã nichʉ tʉhoro õ sehe niha tiro cʉ̃hʉ tinare: ");
INSERT INTO gvc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Jesu to ñano yoarire masieraja mari. Ã masierana tiro marine to yahuhto pano tirore buhiri dahre masieraja mari. Ã masierapanahta tirore buhiri dahrena, mari ya dutiare yʉhdʉrʉcana nija mari —niha Nicodemo tinare. ");
INSERT INTO gvc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","To ã nichʉ tʉhoa õ sehe ni yʉhtiha tina: —¿Mʉhʉ cʉ̃hʉ tiro yoaro seheta Galilea macariro tjijari? Cohamacʉ yare ti joari tjure buhe pahñoga. Ã buhecʉ, “Cohamacʉ yare yahu mʉhtaina ne cʉ̃iro mariahna Galileare”, ni buhe masiihca mʉhʉ. Ã jiro ã nimacanocano nina Jesu —ni yʉhtiha tina Nicodemore. ");
INSERT INTO gvc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ti ã niri baharo ti ya wʉhʉsepʉ tjuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu tʉ̃cʉpʉ Olivo wama tidʉpʉ wahare. ");
INSERT INTO gvc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ã yoa pa dachoi bohrearo jichʉ Cohamacʉ wʉhʉpʉ tiro sʉre tjoa. To ã sʉchʉ ñʉa masa payʉ tiro cahai cahmachure. Ti ã cahmachuchʉ ñʉno tiro sehe dujitjiãhno tinare buhe dʉcare. ");
INSERT INTO gvc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","To ã buhero watoi sã coyea judio masa buheina, fariseo curua macaina mehne tí wʉhʉpʉ numinore na tare. Ticoro mʉno mehne to ñano yoachʉ waro wacũenoca sʉ pja sʉha tina ticorore. Ã sʉ pja sʉa ticorore Cohamacʉ wʉhʉpʉ na sãare tina. Na sãa sʉ tuhsʉ jipihtina panoi ticorore duhu dapo, ");
INSERT INTO gvc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","õ sehe nire: —Buheriro, ahricoro mʉno mehne ñano to yoachʉ waro wacũenoca ticorore sʉ pja sʉhi. ");
INSERT INTO gvc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Cohamacʉ dutiare Moise cjiropʉ marine to cũri õ sehe nina: “Mʉno mehne ñano yoaricorore tãa mehne doca, wajãga”, nia tiha Cohamacʉ dutia. Mʉhʉ waro, ¿dohse ni tʉhotujari ahrire? —ni siniture tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jesu to ñano nichʉ tʉho duaa nimare tina tirore yahusã duaa. Ti ã sinitupachʉta Jesu sehe puhsa nuju sʉ, yahpapʉ to wamo pica mehne joare. ");
INSERT INTO gvc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ã jiro ã ti ni siniturucuchʉ Jesu sehe wahcãrʉca, tinare õ sehe ni yahure: —Mʉsa mehne macariro ñano yoaerariro sehe ticorore tãa mehne doca mʉhtajaro —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ã ni tuhsʉ pari turi tiro puhsa nuju, yahpapʉ joare tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tíre tʉhoa ti ñaa yoarire wacũa, ti wahmisʉma sehe wijaa mʉhtare. Ti baharo tina mehne macaina cʉ̃hʉ wijaa pihtia wahare. Ã ti wijaa pihtiari baharo numino tói ducuricoro Jesu mehne tjuare. ");
INSERT INTO gvc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ã jiro Jesu wahcã nuju sʉ, ticorore õ sehe ni sinitu ñʉre: —¿Nohopʉ wahari tina? ¿Mʉhʉre buhiri dahre duamarina mariajari mipʉre? —nire ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Mariahna, pʉhtoro —ni yʉhtire ticoro. —Yʉhʉ cʉ̃hʉ buhiri dahreraja mʉhʉre. Wahaga. Ã jico ñaare yoa namoeco tjiga —nire Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pari turi Jesu tí wʉhʉpʉ jiinare õ sehe ni yahure: —Buhriaro marine to ñʉ masichʉ yoaro seheta yʉhʉ ahri yahpa macainare Cohamacʉre masichʉ yoaja. Yʉhʉre wacũ tuariro jipihtia dachoripe Cohamacʉ mehne ã jirucurohca. Ã jiro tiro noaare wacũnohca. Ã yoa tiro ñaare wacũ duasi —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","To ã nichʉ tirore fariseo curua macaina õ sehe nire: —Mʉhʉ mʉ basi mʉ jia tiare ã ni durucui nina. Ã jia mʉ õ sehe ni, mʉ mʉ sʉro mʉ nimacanocachʉ tí yaba cjihti jierara —nire tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ti ã nichʉ Jesu õ sehe ni yʉhtire: —Yʉ tarirore masija yʉhʉ. Yʉ wahahto cʉ̃hʉre masija yʉhʉ. Mʉsa sehe ne tíre masierara. Mʉsa õ sehe nipachʉta yʉ jia tiare mʉsare yʉ yahuri potocã tjira. ");
INSERT INTO gvc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉsa mʉ sʉro mʉsa ñʉri dihtare masina mʉsa. Ã jina noano masierara mʉsa. Ã masierapanahta yʉhʉre ñano ni durucura mʉsa. Yʉhʉ sehe yʉ mʉ sʉro masare ne ã nieraja. ");
INSERT INTO gvc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ã jicʉ masa ti jia tiare ñʉ masicʉ yʉ mʉ sʉro ñʉ masieraja. Yʉhʉ pini yʉ Pʉcʉ yʉhʉre warocariro mehne ñʉ masija. Ã jicʉ masa ti jia tiare yʉ ñʉ masia tí potocã tjira. ");
INSERT INTO gvc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉsare dutia ti joari pũi õ sehe ni yahura: “Pʉaro masa cʉ̃no potori ti yahuchʉ ti yahua potocã tjira”, ni yahu joari jira. ");
INSERT INTO gvc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉhʉre yahuriro mehne sã pʉaro tjija. Yʉhʉ yʉ jia tiare yahuja. Tuhsʉ, yʉ Pʉcʉ cʉ̃hʉ yahura yʉhʉ sehere. Tirota jira yʉhʉre warocariro —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Nohopʉ jicari mʉ Pʉcʉ? —ni siniture tina. —Yʉhʉre mʉsa masierara. Yʉ Pʉcʉ cʉ̃hʉre masierara mʉsa. Yʉhʉre masina, yʉ Pʉcʉ cʉ̃hʉre masiboa mʉsa —ni yʉhtire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu tinare buhero ã ni durucure Cohamacʉ wʉhʉi ti niñeru duhu sãa caa poca cahai. To ñano yʉhdʉhti pja dʉhsasinire. Ã jia tina mehne to jipachʉta tina tirore ñahaerare. ");
INSERT INTO gvc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pari turi Jesu tinare õ sehe ni yahure tjoa: —Yʉ tariropʉ wahaihca. Yʉ wahari baharo yʉhʉre macanahca mʉsa. Ã jina mʉsa ñaa buhiri tiina yarianahca. Yʉ wahahtopʉre mʉsa sehe waha masisi —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","—“Yʉ wahahtopʉre mʉsa sehe waha masisi”, ¿to nichʉ tʉhoa ahriro to basi wajã yariarohcari ã nino? —nire sã coyea judio masa ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ti basi ti ã nichʉ masino õ sehe ni yahure Jesu tinare: —Mʉsa sehe ahri yahpa macaina jira. Yʉhʉ sehe mʉano macariro jija. Ahri yahpai bajuarina jira mʉsa sehe. Mʉanopʉ tariro jija yʉhʉ sehe. ");
INSERT INTO gvc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mʉsa yʉ jia tiare yʉ nirire “Potocã jierara” nina, mʉsa ñaa buhiri tiina yarianahca mʉsa. Ã jicʉ “Mʉsa ñaa buhiri tiina yarianahca mʉsa”, nimahi mʉsare —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Noa baro jijari mʉhʉ? —ni siniture tina. —Wahmanopʉre yʉ nirucuriro seheta jija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mʉsare yʉ yahuhti pjíro dʉhsasinina. Tuhsʉ, mʉsa ñano yoari buhirire mʉsare yʉ yahuhto cjihto pjíro dʉhsasinina mini. Ã jicʉ yʉhʉre warocariro to yahuri cjirire ahri yahpa macainare yahuja. To yahuri potocã tjira —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","“Yʉhʉre warocariro”, to nichʉ tʉhoa “Mari Pʉcʉ jica”, ni tʉhotuerare tina. ");
INSERT INTO gvc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ti ã ni tʉhotuerachʉ ñʉno Jesu õ sehe ni yahure tinare: —Yʉhʉre masʉnore Cohamacʉ warocarirore mʉsa yucʉcʉ taño mehne wahcõ daponahca. Mʉsa ã yoana, “Tiro Cohamacʉ warocariro tjira”, ni masinahca. Ã jina yʉ mʉ sʉro yʉ yoaerariro yʉ jia tiare masinahca mʉsa. Ã jina yʉ Pʉcʉ yʉhʉre to buheri dihtare yahuriro yʉ jia cʉ̃hʉre masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉhʉre warocariro sehe yʉhʉ mehne jira. To cahmaare jipihtia dachoripe yoarucuja. Ã jiro yʉhʉre tiro ne cohãerara —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","To ã nichʉ tʉhoa, tirore masa payʉ wacũ tuare. ");
INSERT INTO gvc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ã jia paina judio masa Jesure wacũ tuare. Ã jiro Jesu tinare õ sehe ni yahure: —Yʉ dutiare yoa pahñoina jina, potocãta yʉ buheina jira mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ã jina potocã masinahca mʉsa. Potocã jiare masina, ñaa yoaare duhu masinahca. Ã jina cahamaca yoaro sehe ji namosi mʉsa —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","To ã nichʉ tʉhoa tina õ sehe ni yʉhtire: —Sã sehe panopʉ macariro Abrahã cjiro panamana ji turiaina jija. Ã jina ne paina ti cahamaca jieraja sã. Ã jicʉ “Cahamaca yoaro sehe ji namosi” nicʉ, ¿dohse jiro baro sãre ã nijari mʉhʉ? —ni siniture tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ti ã nichʉ tʉhoro õ sehe nire tiro: —Potocã mʉsare niita nija. Jipihtina ñaare yoaina sehe ti ñaa yoaare duhu masierara. Ã jia tí ñaa sehe ti pʉhtoro yoaro sehe jira. Ã jiina jia cahamaca yoaro sehe jira tina. ");
INSERT INTO gvc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cahamacʉno sehe to pʉhtoro ya curua macariro jipihtia dachoripe jirucuerara. Ã jiro painare dutiriro jierara. Tí wʉhʉ macariro sehe to macʉno sehe jipihtia dachoripe potocãta tí curua macariro jira tiro. (Yʉhʉ sehe Cohamacʉ macʉno jija. Ã jicʉ dutiriro jija. Mʉsa ñaa yoaare duhu dutiihtja.) ");
INSERT INTO gvc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ã jina yʉhʉ Cohamacʉ macʉno ñaare yʉ duhuchʉ yoarina jina potocãta ñaare duhurina jira mʉsa. (Ã jina tí ñaa cahamaca yoaro sehe ji namoerara mʉsa.) ");
INSERT INTO gvc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahã cjiro panamana ji turiaina mʉsa jichʉ masija. Ã jipanahta yʉ yahua sehere tʉho duaerara mʉsa. Ã jina yʉhʉre wajã duara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉ Pʉcʉ yʉhʉre to masichʉ yoari cjirire yahuja mʉsare. Yʉ ã yahupachʉta mʉsa pʉcʉ watĩno mʉsare to dutiare yoara mʉsa cʉ̃hʉ —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Abrahã cjiro panopʉ macariro sã ñʉchʉ cjiro jia tiha. Ã jiro watĩno sã pʉcʉ jierara —ni yʉhtire tina. Ti ã nichʉ Jesu õ sehe ni yʉhtire: —Abrahã panamana jina, to yoariro seheta yoaboa mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Cohamacʉ yʉhʉre potocã to yahuare mʉsare yʉ yahupachʉta yʉhʉre wajã duara mʉsa. Abrahã cjiro sehe ne ã yoaera tiha. ");
INSERT INTO gvc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉsa pʉcʉ to yoariro seheta yoara mʉsa —nire Jesu tinare. To ã nichʉ tina õ sehe ni yʉhtire: —Wamomaca dʉhtemahnoeraina pohna jieraja sã. Cʉ̃irota jira sã Pʉcʉ. Tirota jira Cohamacʉ —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ti ã nichʉ Jesu õ sehe ni yʉhtire: —Cohamacʉ mehne macariro jicʉ, õpʉre tahi. Ã jina Cohamacʉ mʉsa Pʉcʉ to jichʉ yʉhʉre cahĩboa mʉsa. Yʉ mʉ sʉro taerahi yʉhʉ pinihta. Cohamacʉ to warocachʉ tahi õpʉre. ");
INSERT INTO gvc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Dohseana yʉ durucuare tʉhoerajari mʉsa? Yʉ yahuare tʉhona bihoerara mʉsa. Ã jina tʉho duaerara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉsa pʉcʉ sehe watĩno jira. Ã jina watĩno cahmaa sehere yoa duara mʉsa. Ahri yahpa wahmanopʉ to ji dʉcachʉpʉ, mipʉ cʉ̃hʉre tiro masare wajãrucuriro jira. Tirore potocã durucua mariahna. Ã jiro tiro potocã ne durucuerara. Tiro wahmanopʉre mahño mʉhta dʉcariro jia tiha. Ã jiro tiro ã mahñorucuriro jiro, mahñoare yahura. ");
INSERT INTO gvc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yʉhʉ sehe mʉsare potocã yahuja. Ã yʉ yahuchʉ yʉhʉre tʉhoerara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Mʉhʉ ñano yoariro jira”, yʉhʉre ni masierara mʉsa. ¿Potocã mʉsare yʉ yahupachʉta dohseana tʉhoerajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cohamacʉ pohna sehe to durucuare tʉhora. To pohna jierana, to durucuare tʉho duaerara mʉsa —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","To ã nichʉ tʉhoa judio masa tirore õ sehe nire: —“Mʉhʉ Samaria macariro jira. Ã jicʉ tʉho masierariro watĩno to cohtotariro jira mʉhʉ”, sã niri potocã tjira —nire tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ti ã nichʉ tʉhoro õ sehe ni yʉhtire Jesu: —Tʉho masierariro, watĩno to cohtotariro jieraja yʉhʉ. Yʉ Pʉcʉre ño payoja. Mʉsa sehe yʉhʉre ño payoerara. ");
INSERT INTO gvc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yʉhʉre masa ti ño payohtire macaeraja yʉhʉ. Yʉ Pʉcʉ sehe masare yʉhʉre ño payo dutira. Tiro pinihta yʉ jia tiare noano ñʉ masino, ãta ño payo dutira. Tuhsʉ, yʉhʉre ti cahmaerari buhiri buhiri dahreriro jirohca tiro. ");
INSERT INTO gvc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Potocãta mʉsare nii nija. Yʉ dutiare yoariro jipihtia dachoripe Cohamacʉ mehne ã jirucurohca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","To ã nichʉ tʉhoa õ sehe nire tina: —Mipʉ pinihtare tʉho masierariro, watĩno to cohtotariro mʉ jichʉ sã noano masija. Abrahã cjiro yariaa wahaha. Cohamacʉ yare yahu mʉhtaina cjiri cʉ̃hʉ yaria pihtia wahaha. Ã jicʉ “Yʉ dutiare yoariro jipihtia dachoripe Cohamacʉ mehne ã jirucurohca” nicʉ, ¿dohse nicʉ ã nijari mʉhʉ? ");
INSERT INTO gvc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Sã ñʉchʉ cjiro Abrahã yʉhdoro tuajari mʉhʉ? Tiro cjiro, Cohamacʉ yare yahu mʉhtaina cjiri cʉ̃hʉ yariaa wahaha. ¿Mʉhʉ sehe diro baro jijari mʉhʉ ã ni durucucʉ? Mʉhʉ ã niboriro jierara —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ti ã nichʉ tʉhoro Jesu õ sehe ni yahu namore: —Yʉhʉ yʉ basi “Tuariro jija yʉhʉ” nicʉ, tuariro jieraboca yʉhʉ. Yʉ Pʉcʉ sehe “Tiro tuariro jira”, nina yʉhʉre. “Sã yairo Cohamacʉ”, mʉsa niriro sehe yʉ Pʉcʉ tjira. ");
INSERT INTO gvc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉsa sehe yʉ Pʉcʉre ne masierara. Yʉhʉ sehe tirore masija. “Tirore masieraja” nicʉ, mʉsa yoaro seheta mahñoa payʉriro jiboa yʉhʉ. Potocãta tirore masija. Ã jicʉ to dutiare yoaja. ");
INSERT INTO gvc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ahri yahpapʉ yʉ tahtore mari ñʉchʉ cjiro Abrahã cjiro masia tiha. Ã masino tiro wahchea tiha —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","To ã nichʉ tina õ sehe ni yʉhtire: —Mʉhʉ cincuenta cʉhmari cjʉaerasinica. Abrahã cjiro panopʉ macariro jira. ¿Mipʉre tiro cjirore mʉhʉ dohsea masiboari? —nire judio masa Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Potocã mʉsare niita nija. Abrahã to jihto pano yʉhʉ sehe ji mʉhta tuhsʉa tii —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","To ã nichʉ tʉhoa tina sehe tãare na, tirore doca duamare. Ti ã doca duapachʉta Jesu sehe Cohamacʉ wʉhʉi jiriro duhti wijaa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ã yoa Jesu sã to buheina mehne mahai wahana pairore capari ñʉerarirore boca sʉi. Tiro wahma masa bajuaropʉta capari ñʉerariro jia tiha. ");
INSERT INTO gvc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sã cʉ̃hʉ tirore ñʉna, õ sehe ni sinitu ñʉhi Jesure: —¿Buheriro, ahriro dohsearo capari ñʉerariro masa bajua tiari? ¿Ñaare yoaa tiari ã waharo? ¿O to pʉcʉsʉma sehe ñaare yoaa tiari to ã wahachʉ? —ni sinitu ñʉhi sã sehe Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sã ã nichʉ tʉhoro õ sehe ni yʉhtire tiro: —Ahriro to ñaare yoari buhiri capari ñʉerariro wahaerare. To pʉcʉsʉma cʉ̃hʉ ñaare ti yoari buhiri capari ñʉerariro wahaerare. Cohamacʉ sehe tirore capari ñʉerachʉ yoare tirore ñʉchʉ yoaro taro masare to ñohtire. ");
INSERT INTO gvc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yʉhʉre warocariro to cũrire mipʉre yoaro cahmana yʉhʉre. Ñamipʉ mari dahra masieraro seheta baharopʉ yʉhʉre warocariro to cũrire yoa masieraja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ahri yahpapʉ buhriaro marine to ñʉ masichʉ yoariro seheta jiriro jicʉ ahri yahpa macainare Cohamacʉ yare masichʉ yoaja yʉhʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ã ni tuhsʉrota yahpapʉ chahcho puti cũre. To ã chahcho puti cũrire dahra more, capari ñʉerarirore to caparire wisõre. ");
INSERT INTO gvc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ã wisõno õ sehe nire Jesu: —Siloé wama tiri copai cuhsʉri copai mʉ caparire cosai wahaga —nire Jesu. (Siloé sã ya dʉsero mehne nia “Warocari copa”, nia nire.) Jesu to caparire cosa dutiriro sehe waha, cosa, capari ñʉriropʉ tju wihire. ");
INSERT INTO gvc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","To tju wihichʉ tiro cahai jiina tirore ñʉre. Tó pano niñeru siniriro cjiro to jichʉ ñʉrina tirore õ sehe nire ti basi: —¿Ahriro sohõ jiriro niñeru siniriro cjiro jierajari? —nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Tirota jira wiho —nire paina sehe. —Tiro jierara. Ã jieraparota tiro yoaro sehe bajuriro jira —nire paina. Ti ã nichʉ tʉhoro capari ñʉerariro cjiro sehe õ sehe nire: —Tiro tjija yʉhʉ —nire tinare. ");
INSERT INTO gvc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","To ã nichʉ masa tirore õ sehe ni siniture: —¿Capari ñʉerariro cjiro jicʉ dohse waha ñʉri mʉhʉ? —ni siniture tina tirore. ");
INSERT INTO gvc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jesu wama tiriro dihta sohãare dahra more, yʉ caparire wisõre. Yʉhʉre wisõ tuhsʉ “Siloé wama tiri copapʉ mʉ caparire cosai wahaga”, to nichʉ cosai sʉhi yʉhʉ. Yʉ ã cosari baharo yʉ capari noano bajure yʉhʉre —ni yahure tiro masare. ");
INSERT INTO gvc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Mʉhʉre ã yoariro nohopʉ jicari tiro? —nire tina. —Bʉah. Nohoi jiro jica —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ã ni durucu tuhsʉ tina capari ñʉerariro cjirore fariseo curua macaina cahapʉ naahre. ");
INSERT INTO gvc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tí dacho Jesu dihta sohãare dahra more capari ñʉerarirore noariro to yoari dacho Sabado dacho jire. Tí dacho sã sori nʉmʉ jire. ");
INSERT INTO gvc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ã jia fariseo curua macaina sehe tirore õ sehe ni sinituha tjoa: —¿Dohse yoa mʉhʉ ñʉri? —ni sinituha tina. —Dihta sohãa mehne yʉ caparire wisõhre. Ã jicʉ yʉ caparire yʉ cosari baharo ñʉ dʉcahi yʉhʉ —ni yahuha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—Tiro Sabado dacho mari sori nʉmʉi mari dahra dutierari nʉmʉi dahrahre. Ã jiro tiro Cohamacʉ yairo jierara —niha paina fariseo curua macaina sehe. Paina sehe õ sehe niha: —Ñaare yoariro õ sehe noariro wahachʉ yoa masierara. Ã jiro tiro noariro jiboca —niha paina. Ã jia tina pʉa curua ti basi tju waha. ");
INSERT INTO gvc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ã jia pari turi tina capari ñʉerariro cjirore õ sehe ni sinituha tjoa: —¿Mʉhʉre mʉ caparire noano yoarirore mʉhʉ waro dohse ni tʉhotujari Jesure? —niha tina tirore. —Tiro potocãta Cohamacʉ yare yahu mʉhtariro jira —niha capari ñʉerariro cjiro. ");
INSERT INTO gvc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wahmanopʉre judio masa õ sehe ni tʉhotumaha: “Ahriro capari ñʉerariro cjiro jierara”, ni tʉhotumaha tina. Ã ni tʉhotua capari ñʉerariro cjiro pʉcʉsʉmare pjirocaha tina. ");
INSERT INTO gvc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pjiroca tuhsʉ, to pʉcʉsʉmare õ sehe ni sinituha fariseo curua macaina pʉhtoa: —¿Ahriro potocãta mʉsa macʉ jijari? ¿Dóihta tiro capari ñʉerariro masa bajuari? ¿Potocãta capari ñʉerariro cjiro jiparota dohsearo ñʉjari mipʉre? —ni sinituha tina to pʉcʉsʉmare. ");
INSERT INTO gvc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ahriro sã macʉta jira. Ã yoa dóihta capari ñʉerariro masa bajua tire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tíre masipanahta to ñʉrire, tirore ñʉchʉ yoariro cʉ̃hʉre masieraja sã. Sã macʉre sinituga. Bʉcʉro jira tiro. Tiro to basi yahu masina —niha to pʉcʉsʉma. ");
INSERT INTO gvc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judio masa sã pʉhtoa wahmanopʉre õ sehe nia tiha: —“Jesuta Cristo Cohamacʉ warocariro jira”, niinare mari buhea wʉhʉsepʉ sãa dutisi sã —nia tiha judio masa pʉhtoa. Ti ã nichʉ tʉhoa capari ñʉerariro cjiro pʉcʉsʉma sehe judio masa pʉhtoare cui niha. ");
INSERT INTO gvc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ã cuia, “Bʉcʉro jira tiro. Tiroreta sinituga”, niha tina judio masa pʉhtoare. ");
INSERT INTO gvc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Baharo judio masa sã pʉhtoa pari turi capari ñʉerariro cjirore pjirocaha tjoa. Pjiroca tuhsʉ, õ sehe niha tirore: —Cohamacʉ mehne poto yahuga mʉhʉ. Jesure mahñoriro to ñaa yoariro jichʉ sã masija. Ã jicʉ poto yahuga sãre —niha judio masa capari ñʉerariro cjirore. ");
INSERT INTO gvc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ti ã nichʉ tʉhoro õ sehe ni yʉhtiha tiro: —Jesure to ñaa yoariro to jichʉ masieraja yʉhʉ. Cʉ̃nota masija yʉhʉ. Panopʉre capari ñʉerariro jia ticʉrʉ yʉhʉ. Mipʉ sehere ñʉja yʉhʉ. Tí dihtare masija yʉhʉ —ni yʉhtiha capari ñʉerariro cjiro tinare. ");
INSERT INTO gvc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿Dohse yoari mʉhʉre tiro? ¿Mʉ capari ñʉhto cjihtore dohse yoari tiro mʉhʉre? —ni sinituha tina tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Tíreta mʉsare yahu tuhsʉmahicʉ yʉhʉ. Yʉ ã ni yahupachʉta mʉsa ne tʉho duaerare yʉhʉre. ¿Dohse yoa duana pari turi yʉ yahuchʉ tʉho duajari mʉsa? ¿Mʉsa cʉ̃hʉ to buheina ji duajari? —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","To ã nichʉ tʉhoa tina tuhtiha tirore: —Mʉhʉ Jesu buheriro jira. Sã sehe Moise cjiro buheina jija. ");
INSERT INTO gvc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Potocãta Cohamacʉ Moise cjirore durucua tiha. Jesu to tarirore sã masieraja —niha tina capari ñʉerariro cjirore. ");
INSERT INTO gvc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ti ã nichʉ õ sehe ni yʉhtiha tiro: —¿Tiro to tarirore mʉsa masierachʉ yʉhʉre ñʉchʉ yoariro jiro Cohamacʉ warocariro jierabocari tiro? ");
INSERT INTO gvc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cohamacʉ ñaa yoainare ti siniare tʉhoerara. Tí pinihtare mari masija. Tinare tʉhoeraparota Cohamacʉre ño payorirore, to dutiare yoarirore to siniare tʉhora Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wahmanopʉre ahri yahpa to ji dʉcachʉpʉre ne coã masa bajuaropʉ capari ñʉerarirore ne cʉ̃iro baro ñʉchʉ yoariro mariea tiha. ");
INSERT INTO gvc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ã jiro Jesu Cohamacʉ warocariro jieraro yʉhʉre ñʉchʉ yoaeraboa tiro —niha tiro tinare. ");
INSERT INTO gvc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—Mʉhʉ dóihta ñariro jia tiha. ¿Ã jipacʉta sãre buhe duajari mʉhʉ? —niha judio masa sã pʉhtoa tirore. Ã ni tuhsʉata tina tirore cohã wionocaha. ");
INSERT INTO gvc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ã yoa capari ñʉerariro cjirore ti cohã wiorire Jesu tʉhore. Ã tʉhoro capari ñʉerariro cjirore boca sʉro, tirore õ sehe ni siniture: —¿Masʉnore Cohamacʉ warocarirore wacũ tuajari mʉhʉ? —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Pʉhtoro, noa jijari tiro? Tirore masicʉ wacũ tuaihtja tirore —nire capari ñʉerariro cjiro Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Tirore ñʉ tuhsʉre mʉhʉ. Mipʉre mʉhʉ mehne durucuriro tiro tjija yʉhʉ —nire Jesu capari ñʉerariro cjirore. ");
INSERT INTO gvc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Pʉhtoro, mʉhʉre wacũ tuaja —nire capari ñʉerariro cjiro. Ã ninota tiro Jesu panoi na tuhcua caha sʉ, tirore ño payore. ");
INSERT INTO gvc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","To ã ño payochʉ ñʉno õ sehe nire Jesu: —Noaina, ñaina cʉ̃hʉ ti yoarire masichʉ yoai tai ahri yahpapʉre tahi. Capari ñʉeraina ti ñʉ masieraro seheta tina yoaro sehe jiina yʉ Pʉcʉre masierara. Ã masierainare yʉ Pʉcʉre masichʉ yoai tai tahi yʉhʉ. “Sã noano masija”, ni tʉhotumarina noano ti masierarire masichʉ yoai tai tahi yʉhʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","To ã nichʉ tʉhoa mahainacã fariseo curua macaina tirore õ sehe nire: —“Capari ñʉeraina ti ñʉ masieraro seheta noano masierara mʉsa cʉ̃hʉ”, ¿nii nijari mʉhʉ sãre? —nire fariseo curua macaina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ti ã nichʉ Jesu õ sehe nire: —Capari ñʉeraina ti ñʉ masieraro seheta potocã mʉsa noano masierachʉ, mʉsare buhiri mariaboa. “Sã noano masiina jija”, mʉsa niri buhiri buhiri tiina jisinina mʉsa mipʉre —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Baharo quiti mehne piti dahre buhero taro õ sehe nire Jesu: —Potocãta nii nija mʉsare. Ovejare wihbori sahrĩno sopacai sãaerariro, sopaca marienopʉ sãariro sehe yaca bʉcʉro jira. ");
INSERT INTO gvc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sopacai sãariro sehe ovejare ñʉ wihboriro jira. ");
INSERT INTO gvc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sopacare cohtariro sopacare pjõohna ovejare ñʉ wihboriro to sãahto sehe. Ovejare ñʉ wihboriro to durucuchʉ tʉho tara to nuina oveja peri. Tinare pjirocaro, ti wama mehne pisurocarucura tiro. Ã yoaro tinare sahrĩnopʉ jiinare pji wiorucura sopacapʉ. ");
INSERT INTO gvc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","To yainare jipihtinare pji wio tinare mʉ tãrucura. Oveja sehe to durucuare masia, to baharo nʉnʉ tirucura. ");
INSERT INTO gvc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pairore ti masierarirore nʉnʉ tierara tina. Ã jia paina ti durucuare tʉhoa, cui mʉrocaa wahara —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ahri quitire to ã yahupachʉta to yahuare tʉho ñahaerare tina. ");
INSERT INTO gvc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pari turi Jesu tinare õ sehe ni yahure tjoa: —Potocãta mʉsare nii nija. Ovejare wihbori sahrĩno sãari sopaca yoaro sehe jija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jipihtina yʉ pano tarina quihõno yʉ durucuare buheraina, ovejare ñʉ wihbo mahñoina yacaina yoaro sehe jira. Ti ã jipachʉta yʉ yaina sehe oveja yoaro sehe jiina painare ne tʉho wahcãerara. ");
INSERT INTO gvc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉhʉ ovejare wihbori sahrĩno sãari sopaca yoaro sehe jija. Tí sopacai sãaina yoaro sehe tjira yʉhʉre wacũ tuaina. Ã jicʉ yʉhʉ tinare pichacapʉ wahaborinare yʉhdʉchʉ yoaihtja. Oveja sehe tinare ñʉ wihboriro mehne ti cahmaare bocaro yoaro seheta yʉ yʉhdʉchʉ yoaina cʉ̃hʉ yʉhʉ mehne ti cahmaare bocaahca. Yʉhʉ tinare noano dʉcata, noano ñʉ wihboihca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ã ni tuhsʉ õ sehe ni namore: —Mʉsare mahñoare buheina, ovejare ñʉ wihbo mahñoina sehe ovejare yacaina yoaro sehe jira. Yacaa taa, wajãa taa, dojomehnea taa tara tina. Wiho mejeta yʉhʉ sehe yʉ yainare, oveja yoaro sehe jiinare, tuaro waro ti wahchea mehne ã catirucuchʉ yoai tahi. ");
INSERT INTO gvc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ovejare noano ñʉ wihboriro yoaro sehe jija yʉhʉ. Ovejare noano ñʉ wihboriro tinare noano dʉcata, to yariahtore ne cuierara. Tó yoaro seheta yʉhʉ cʉ̃hʉ yainare noano dʉcata, yariahca, tinare ne soro wahaerahto sehe. ");
INSERT INTO gvc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oveja pʉro cahamacʉno sehe potocã ovejare ñʉ wihboriro jierara. Ã jia oveja to yaina jierara. Ã jiro yairo ovejare to chʉro tachʉ ñʉno to cahamacʉno sehe ovejare cohã cũnoca, mʉrocaa wahara. To ã cohã cũri baharo, yairo ovejare to ñahachʉ ñʉa oveja peri mʉroca site wahcãa wahara. ");
INSERT INTO gvc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","To cahamacʉno sehe to wapataa dihtare cahmana. Ã jiro tiro ovejare noano ñʉ wihbo ji coaerara —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ã ni tuhsʉ õ sehe ni namore: —Ovejare noano ñʉ wihboriro yoaro sehe jija yʉhʉ. Ã jicʉ yʉ yainare masija yʉhʉ. Ã jia yʉ yaina sehe yʉhʉre masina. ");
INSERT INTO gvc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tó seheta yʉ Pʉcʉ cʉ̃hʉ yʉhʉre masina. Ã jicʉ yʉhʉ cʉ̃hʉ yʉ Pʉcʉre masija. Oveja yoaro sehe jiina yʉ yaina Cohamacʉ mehne ti ã jirucuhti cjihtire yariaihca yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Paina oveja pa sahrĩno macaina yoaro sehe jiina paina masa cʉ̃hʉ yʉ yaina jiahca. Tina cʉ̃hʉre naaihca. Ã jia yʉ durucuchʉ tʉho wahcãahca tina cʉ̃hʉ. Ã jia yʉ yaina jipihtina cʉ̃ curuata jiahca. Ã jicʉ yʉhʉ dihta yʉ yainare ñʉ wihboihca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ã ni tuhsʉ õ sehe ni namore: —Yʉ yaina Cohamacʉ mehne ti ã jirucuhti cjihtire yariaihca. Yʉ yariari baharo masa mʉjaihca. Yʉ ã yoahtiro jichʉ yʉ Pʉcʉ yʉhʉre cahĩna. ");
INSERT INTO gvc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yʉ wajã dutierachʉ yʉhʉre wajã masieraboa tina. Yʉ cahmano seheta yʉhʉre wajãahca. Ã jicʉ yʉ yaina Cohamacʉ mehne ti ã jirucuhti cjihtire yariaihca. Yaria masija yʉhʉ. Ã yoa masa mʉja masija. Yʉ Pʉcʉ yʉhʉre tíreta yoa dutire —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","To ã nichʉ tʉhoa judio masa pʉa curua tju ware. Paina soro tʉhotu, paina cʉ̃hʉ soro tʉhoture: ");
INSERT INTO gvc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Tiro watĩno to cohtotariro jira. Ã jiro tʉho masierariro jira. ¿Dohseana tirore pari turi tʉhojari mʉsa? —nire paina payʉ judio masa. ");
INSERT INTO gvc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Paina sehe õ sehe nire: —Watĩno to cohtotariro jiro ã ni durucueraboa. Capari ñʉerarirore ñʉchʉ yoa masierara watĩno to cohtotariro. Ã jiriro jiro tiro watĩno to cohtotariro jierara —nire paina judio masa. ");
INSERT INTO gvc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pa dachoi sã coyea judio masa Jerusalẽi bose nʉmʉri yoaa nire pari turi. Cohamacʉ wʉhʉre panopʉ tirore ti wari cjirire ti wacũhti dachori jire. Tí pjare puhiro jire. ");
INSERT INTO gvc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tí dachoi Salomo wama tiri tahtiapʉ Cohamacʉ wʉhʉi jiri tahtiapʉ Jesu ñʉ tinino nire. ");
INSERT INTO gvc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tí tahtiapʉ to jichʉ ñʉa sã coyea judio masa tiro cahapʉ cahmachu, tirore õ sehe ni siniture: —Yoaputiari pja sãre noano yahueraca mʉhʉ. Poto sãre noano yahu bahrañoga mʉhʉ. ¿Cristo Cohamacʉ to warocariro tjijari mʉhʉ? —nire tina Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ti ã nichʉ tʉhoro õ sehe ni yʉhtire Jesu: —Mʉsare yahu tuhsʉmajacʉ yʉhʉ. Yʉ ã yahupachʉta yʉhʉre tʉho duaerare mʉsa. Yʉ Pʉcʉ yʉhʉre to dutiriro seheta to tuaa mehne yoa ñoja. Ã yoacʉ yʉ Cristo jiareta mʉsare ñoi nija. ");
INSERT INTO gvc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yʉ ã ñopachʉta yʉhʉre tʉho duaerara mʉsa. Mʉsa sehe yʉ yaina jierara. Ã jina pairo yaina oveja yoaro sehe jiina jina, yʉhʉ sehere tʉhoerara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ovejare ñʉ wihborirore to yaina ti tʉhoriro seheta yʉhʉ cʉ̃hʉre yʉ yaina tʉhora. Ã jicʉ yʉ yainare masija yʉhʉ. Ã jia tina yʉhʉ mehne wahara. ");
INSERT INTO gvc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ã jicʉ jipihtia dachoripe Cohamacʉ mehne ã catirucuchʉ yoaja tinare. Ã jia tina sehe pichacapʉ ne wahasi. Ã jia yʉ yainare yʉ ñʉ wihbochʉ paina sehe ne cʉ̃irore yʉhʉre ma masierara tinare. ");
INSERT INTO gvc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ã yoa yʉ Pʉcʉ yʉ yainare yʉhʉre wariro jipihtina yʉhdoro tuariro jira. Ã jiro yʉ Pʉcʉ sehe yʉ yainare to ñʉ wihbochʉ, ne cʉ̃iro tiro cʉ̃hʉre ma masierara tinare. ");
INSERT INTO gvc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉhʉ yʉ Pʉcʉ mehne cʉ̃irota jija —nire Jesu judio masare. ");
INSERT INTO gvc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","To ã nichʉ tʉhoa judio masa sehe tirore ti doca wajãhti tãare pari turi namare tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ti ã yoachʉ ñʉno Jesu õ sehe ni siniture tinare: —Yʉ Pʉcʉ ya tuaa mehne payʉ tahari yoa ñomahi mʉsare. ¿Di baro sehere yʉ yoari buhiri yʉhʉre tãa mehne doca wajã duajari mʉsa? —ni siniture Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","To ã nichʉ tʉhoa õ sehe nire tina: —Cohamacʉ tuaa mehne mʉ yoa ñori buhiri mʉhʉre tãa mehne doca wajã duaeraja sã. Cohamacʉre mʉ ñano durucuri buhiri mʉhʉre tãa mehne doca wajã duaja sã. Masʉno jipaihta “Cohamacʉ jija yʉhʉ”, mʉ nia buhiri mehne mʉhʉre tãa mehne doca wajã duaja sã —ni yʉhtire tina. ");
INSERT INTO gvc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ti ã ni yʉhtichʉ tʉhoro Jesu tinare õ sehe ni yahure: —Mʉsa cʉ̃hʉre “Cohamana”, ni pisure Cohamacʉ. Ãta ni joaa tiha to dutiare ti joari pũi. ");
INSERT INTO gvc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cohamacʉ yare ti joari pũ quihõno to jichʉ mari masija. “Mahñoa jira”, tí pũre ni masieraja mari. Ã jiro to yare masiinare potocãta tiro “Cohamana”, ni pisura. ");
INSERT INTO gvc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Cohamacʉ yʉhʉre besetjiãhno, ahri yahpapʉre warocare. Ã jicʉ yʉhʉ “Cohamacʉ macʉno jija”, yʉ niri buhiri “Cohamacʉre ñano durucuro nina Jesu”, nina mʉsa yʉhʉre. ¿Dohseana yʉhʉre ã nijari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉ Pʉcʉ to cahmariro seheta to tuaa mehne yʉ yoa ñoerachʉ pinihtare yʉ buherire “Potocã tjira”, nieraboca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yʉ Pʉcʉ to tuaa mehne yʉ yoa ñopachʉta yʉhʉ sehere tʉho duaeraboca mʉsa. Ã tʉho duaerapanahta to tuaa mehne yʉ yoa ñochʉ ñʉna yʉ yoarire “Potocã tjira”, niga mʉsa. Mʉsa ã nina, yʉ Pʉcʉ mehne sã cʉ̃no potori sã jichʉ masinahca mʉsa. Ã jina yʉhʉ yʉ Pʉcʉ mehne cʉ̃no potori yʉ jichʉ masinahca mʉsa. Ã jina tʉho ñahanahca mʉsa —nire Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","To ã nichʉ tina pari turi tirore ñaha duamare. Ti ã ñaha duachʉ ñʉno tiro duhti wijaa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ã wijaariropʉta João masare to bautisa mʉhtariropʉ Jordão sie sehepʉ pari turi wahare tjoa. Tópʉ sʉro tjuanocare tiro. ");
INSERT INTO gvc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ã jia masa payʉ tirore ñʉa sʉre. Õ sehe nire tina ti basi: —João sehe Cohamacʉ tuaa mehne yoa ñoerare. Ã to yoa ñoerapachʉta jipihtia Jesure to yahuri cjiri sehe potocãta jira —nire masa ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ã jia tópʉre masa payʉ wacũ tua dʉcare Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ã yoa cʉ̃iro Lázaro wama tiriro to wahmiosãnumia María, Marta cʉ̃hʉ mehne Betania wama tiri macai jia tire. Tiro cʉ̃ nʉmʉ dohatia wahari jire. ");
INSERT INTO gvc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tiro wahmiono María sehe baharo Jesu to dahporire me sitia wisõ, to pjoari mehne tirore pahã cohãhticoro jiri jire. ");
INSERT INTO gvc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ã yoa to dohatia wahachʉ ñʉa, to wahmiosãnumia sehe painare Jesure yahu dutirocari jire: —Pʉhtoro, mʉ cahĩriro dohatiro nina —ni yahu dutirocari jire Lázaro wahmiosãnumia. ");
INSERT INTO gvc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tí quitire tʉhoro õ sehe nire Jesu: —Mipʉre Lázaro to dohatia to yariahti cjihti jierara. Cohamacʉ tuaare masare ñohti cjihtire mipʉre tiro dohatira. Ã jia yʉhʉ to macʉno tuariro yʉ jia cʉ̃hʉre ñʉahca masa —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu Martare, to bahoro cʉ̃hʉre, Lázaro cʉ̃hʉre tuaro cahĩa tire. ");
INSERT INTO gvc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ã nino Lázaro dohatiriro to jichʉ tʉhoparota tói Jesu sehe pʉa dacho tjuasinire. ");
INSERT INTO gvc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pʉa dacho baharo Jesu õ sehe nire sãre to buheinare: —Pari turi Judea yahpapʉ tjuaa wahajihna tjoa —nire sãre. ");
INSERT INTO gvc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Buheriro, canʉpʉcãta judio masa tó macaina mʉhʉre tãa mehne doca wajã duamare. ¿Dohseacʉ tópʉ pari turi tjuaa waha duajari mʉhʉ? —nihi sã to buheina. ");
INSERT INTO gvc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sã ã nichʉ tʉhoro, tirore ti wajã masierasininore yahuro, piti dahre buhero sãre õ sehe nire: —Pjíro tʉhotuena tjiga. Cʉ̃ dachore doce horari waro jira. Sʉ̃ dacho macariro to jisinichʉ, noano ñʉja mari. Ã jina dachore tinina ne pʉha tu mʉa boraeraja mari. ");
INSERT INTO gvc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wiho mejeta nahitianoi tiniina sehe pʉha tu mʉa boraa wahara. Sʉ̃ dacho macariro mariachʉ noano ñʉerara tina —nire Jesu. (Ã nino õ sehe nino niri jimare: “Mipʉre yʉ Pʉcʉ yare yʉ yahu pahñohto dʉhsasinina. Ã jia yʉhʉre wajã masierasinina”, nino niri jimare.) ");
INSERT INTO gvc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ã nino sãre õ sehe ni yahu namore tjoa: —Mari mehne macariro Lázaro, carĩno nica. To ã carĩpachʉta yʉhʉ tirore wahcõi wahaihtja —nire sãre. ");
INSERT INTO gvc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Pʉhtoro, Lázaro carĩriro jiro, yʉhdʉrohca —nimahi sã. ");
INSERT INTO gvc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sã ã nipachʉta Jesu “Carĩno nica” nino, “Yariaa wahaca”, nino niri jimare. To ã nichʉ tʉhona “Lázaro soro nica”, ni tʉhotumai sã sehe. ");
INSERT INTO gvc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sã ã ni tʉhotuchʉ masino Jesu poto yahure sãre: —Lázaro yariaa wahaca. ");
INSERT INTO gvc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yʉ marieno to yariachʉ, noa nina. Ã jina mʉsa yʉhʉre wacũ tua namonahca. Mʉsa yʉ jia tiare masi namo, mʉsa yʉhʉre wacũ tua namohti cjihti jiahca ahri. Ã yoana basata. Mari ñʉna wahajihna to cahapʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma sʉhʉdʉariro wama tiriro õ sehe nire sãre: —Mari cʉ̃hʉ Jesu mehne wahajihna. Tirore wajãa, mari cʉ̃hʉre wajãjaro —nire Toma. ");
INSERT INTO gvc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ã yoa sã tópʉre sã sʉna cahachʉ waro tó macaina õ sehe ni yahure Jesure: —Pititia dachori wahara Lázaro cjirore masa copapʉ ti siõ sãari baharo —ni yahuha tirore. ");
INSERT INTO gvc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania wama tiri maca sehe Jerusalẽ cahacãi tia kilómetro yoaro jire. ");
INSERT INTO gvc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ã jia Lázaro to yariari baharo, payʉ Jerualẽ macaina sã coyea judio masa Martare, María cʉ̃hʉre ñahacaha tiia taa tari jire. ");
INSERT INTO gvc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tópʉre sã sʉna cahachʉ tʉhoro, Marta sehe sãre piti bocaro wihire. Wiho mejeta to bahoro María sehe to ya wʉhʉpʉ tjuari jire. ");
INSERT INTO gvc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta sehe Jesure piti boca wihi, õ sehe nire tirore: —Pʉhtoro, yʉ bahʉ to yariahto pano mʉ õi jichʉ, tiro yariaeraboa. ");
INSERT INTO gvc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mipʉ cʉ̃hʉre Cohamacʉre mʉ sini payochʉ, tiro mʉ sinino seheta yoarohca —nire Marta Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Mʉ bahʉ masa wijaarohca —nire Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Ãja. Ahri yahpa to pihtiri dachoi yariarina cjiri ti masa wijaahti dachoi to masa wijaahtore masija yʉhʉ —nire ticoro sehe. ");
INSERT INTO gvc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","To ã nichʉ Jesu õ sehe ni yahure tjoa: —Yʉhʉ masa wijaachʉ yoariro jija. Yʉhʉ ã jirucuchʉ yoariro jija. Yʉhʉre wacũ tuariro yariaparota ã catirucurohca. ");
INSERT INTO gvc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ã jia jipihtina Cohamacʉ mehne ã catirucuina, yʉhʉre wacũ tuaina pichacapʉ ne wahasi. ¿Ahrire masijari mʉhʉ? —nire Jesu ticorore. ");
INSERT INTO gvc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Pʉhtoro, masija yʉhʉ. Cristo Cohamacʉ macʉno, masare yʉhdʉchʉ yoariro “Ahri yahpapʉ tarohca”, ti niriro mʉ jichʉ masija yʉhʉ —nire Marta Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta ã ni tuhsʉ to bahoro Maríare pjiro wahare: —Marine buheriro mari ya macai taro nina. Mʉhʉre pjihre —ni yaroca yahuri jire Maríare. ");
INSERT INTO gvc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","To ã nichʉ tʉhoro María ño duaro wahcãrʉca, sã cahapʉ tari jire Jesure ñʉno taro. ");
INSERT INTO gvc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ti ya macapʉ sʉerasinihi sã. Marta sãre to piti bocaroihta jisinihi sã. ");
INSERT INTO gvc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judio masa tí wʉhʉi Maríare ñahacaha tiia niha. Ã jia ticoro to wahachʉ ñʉa, tina ticorore nʉnʉ ti tari jire. “To wahmino cjirore ti siõ sãari copapʉ tiiro waharo nina ticoro”, ni tʉhoturi jimare tina. Ã ni tʉhotua ticorore nʉnʉ ti tari jire. ");
INSERT INTO gvc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ã yoa María sã cahapʉ wihiro, Jesure ñʉ, to dahpori cahai na tuhcua caha sʉre. —Pʉhtoro, yʉ bahʉ to yariahto pano mʉ õi jichʉ tiro yariaeraboa —nire ticoro Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ã jiro ticoro judio masa ticoro mehne tarina cʉ̃hʉ ti tiichʉ ñʉno Jesu sehe tuaro cahya ñano yajeripohna tire. ");
INSERT INTO gvc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Lázaro cjirore nohopʉ siõ sãari mʉsa? —ni siniture Jesu. —Ñʉi taga —ni pji wahcãre tina. ");
INSERT INTO gvc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ti ã nichʉ tʉhoro Jesu tiia wahare. ");
INSERT INTO gvc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","—Lázaro cjirore Jesu tuaro cahĩri jira —nire judio masa ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wiho mejeta paina tina mehne macaina sehe õ sehe nire: —Capari ñʉerarirore ñʉchʉ yoariro jira ahriro Jesu. ¿Ã jiro Lázaro cʉ̃hʉre to yariaborore yʉhdʉchʉ yoaeraboari ahriro? —nire tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ã jiro pari turi Jesu tuaro cahya namore. Ã jina sã jipihtina to masa copapʉ sʉhi. Tí copa tãcapʉ ti sahari copa jire. Tí copapʉ to pjacʉ cjirore siõ sãa, tãca pjiria mehne tju biha cũri jire tina. ");
INSERT INTO gvc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Tãcare na pjõohga —nire Jesu. To ã nichʉ tʉhoro Marta yariariro cjiro wahmiono õ sehe nire: —Pʉhtoro mipʉ pititia dachori waha tuhsʉra to yariari baharo. Ã jiro to pjacʉ cjiro ʉrĩbiahca —nire Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—“Yʉhʉre wacũ tuaco Cohamacʉ tuaare ñʉcohca”, mʉhʉre nimahi —nire Jesu Martare. ");
INSERT INTO gvc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","To ã niri baharo tina tãcare na pjõohre. Ã ti na pjõori baharo Jesu sehe mʉanopʉ ñʉ, Cohamacʉre õ sehe nire: —Mai, yʉhʉre mʉhʉ tʉho tuhsʉhre. Tíre mʉ yoachʉ masicʉ wahcheja mʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ã yoa yʉhʉre mʉhʉ dachoripe ã tʉhorucura. Tíre masija. Ã masipaihta yʉhʉ mʉ warocariro yʉ jiare õre ducuina ti masihti cjihtire mʉhʉre ã nii nija. Tíre “Potocã tjira”, ti nihti cjihti cʉ̃hʉre ã nii nija —nire Jesu to Pʉcʉrore. ");
INSERT INTO gvc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ã ni tuhsʉ Jesu tuaro sañurucure: —Lázaro, wijaa tagá —ni sañurucure tiro. ");
INSERT INTO gvc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","To ã nichʉ yariariro cjiro to wamomacarine to dahpori cʉ̃hʉre suhti cahsari mehne ti wahmariro cjiro, to dapure suhtiro mehne ti wahmariro cjiro, masa copapʉ wijaa tare jʉna. —Ti wahmari cjirire pjãga —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","To ã masochʉ ñʉa, payʉ judio masa Maríare ñʉa tarina mehne macaina Jesure wacũ tuare. ");
INSERT INTO gvc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wiho mejeta paina sehe, tina mehne macaina sehe fariseo curua macaina cahapʉ waha, sʉ, Jesu to yoarire yahuri jire tinare. ");
INSERT INTO gvc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Ã jia sacerdotea pʉhtoa, fariseo curua macaina pʉhtoa cʉ̃hʉ cahmachu, ti basi õ sehe ni durucuha: —Jesu payʉ tahari Cohamacʉ tuaa mehne yoa ño mʉjana. To ã yoa ñoare mari tirore ã ñʉnoca mari dʉcataerachʉ, jipihtina masa tirore wacũ tua, tiro mehne waha pihtiaboca. Ã yoa tiro Jesure ti pʉhtoro cjihto ti sõchʉ ñʉa, Roma macaina pʉhtoa sehe “Marine cohãa nina”, ni sua, ñano yoaahca marine. Tuhsʉ, Cohamacʉ wʉhʉre cohã duti warocaahca ti yaina surarare. Mari ya dihta cʉ̃hʉre maahca tina. ¿Ã jina dohse yoanahcari mipʉre? —ni durucuha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ti ã nipachʉta pairo Caifa wama tiriro, tí cʉhmare sacerdotea bui pʉhtoro jiriro tinare õ sehe ni yahuha: —Mʉsa sehe ne masierara. ");
INSERT INTO gvc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Judio masa jipihtina mari ya cjihtire cʉ̃iro masʉno to yariachʉ noana. To yariaerachʉ mari jipihtina judio masare cohã pahñonocaboa. Tíre mʉsa masierara —niha Caifa tinare. ");
INSERT INTO gvc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ã nino to mʉ sʉro ã nino nieraha. Sacerdotea bui pʉhtoro to jichʉ judio masa ya cjihtire Jesu to yariahtore Cohamacʉ sehe Caifare ã ni yahu dutiha. ");
INSERT INTO gvc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesu yariaro judio masa dihtare yʉhdʉchʉ yoaro taro nierare. Ã yariaro jipihtina Cohamacʉ pohna ahri yahpapʉ ji siteina cʉ̃hʉ cʉ̃ curuata ti jihti cjihtire yariahtiro jire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ã jia tí dachoihta tina “¿Jesure dohse yoa wajãnahcari mari?” ni durucua, tirore wajã taa nimaha. ");
INSERT INTO gvc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tirore ti ã wajã duachʉ masino Jesu payʉ judio masa watoi pari turi tinino wahaerare. Ã jiro masa marieno cahacãi Efraĩ wama tiri macapʉ sãre sʉho wahare. Sãre tí macai sʉho tjuasinire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tí pjare pascua bose nʉmʉri sã judio masa sã bose nʉmʉri cjihto mahanocã dʉhsatjiãhre. Ã jia bose nʉmʉri panocã masa payʉ paye macari macaina Jerusalẽpʉ cahmachure. Pascua macaare ti chʉhto pano Cohamacʉ yare yoaa taa ti ñaa buhiri cosaa taa nire. ");
INSERT INTO gvc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tí pjare tina Jesure macaa niri jire. Ã jia Cohamacʉ wʉhʉpʉ jiina õ sehe ni durucuha: —¿Bose nʉmʉrine ñʉno taerabocari Jesu, mʉsa tʉhotuchʉ? —ni durucuha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ã jia sacerdotea pʉhtoa, fariseo curua macaina cʉ̃hʉ õ sehe ni yahu dutiha masare: —Jesu to jirore mʉsa masina, yahuga sãre. Tirore ñahana tana nija —niha pʉhtoa masare. ");
INSERT INTO gvc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesu sã to buheina mehne Betaniapʉ sã sʉri baharo pascua dachori seis dachori waro dʉhsasinire. Lázaro Jesu to masoriro cjiro tí maca macariro jire. ");
INSERT INTO gvc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sã sʉri baharo Jesu cʉ̃hʉ ya chʉa cjihtire yoare paina. Ã yoa Lázaro, Jesu, sã mehne mesai nuju sʉhi. Sã ã nuju sʉri baharo Marta chʉare payore sãre. ");
INSERT INTO gvc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tuhsʉ, María me sitia sere nardo wama tidʉ macaa sere cʉ̃ kilo dacho macai na ta, Jesu dahporire pio payore. Pio payo tuhsʉ to pjoari mehne tju cosare. To ã pio payori baharo tí wʉhʉ noano me siti sahsea wahare. ");
INSERT INTO gvc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sã mehne macariro, Jesure ñʉ tuhtiinare ñohtiro Juda Iscariote sehe õ sehe nire: ");
INSERT INTO gvc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Dohse yoaro ahricoro ã yoa sitejari? Tíre ticoro duaboa. Ã duaro tres cientos dachori posa dahrari wapa wapataboa. Ã jiro ticoro tí niñerure pjacʉoinare waboa —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Juda sehe pjacʉoinare yoadoho duaerare. Tiro sã niñerure wihbobasariro jiparota yacariro jire. Tuhsʉ, tiro sã niñerure cãa tahari na mʉjare. Ã jiro “Tí niñerure naihtja” nino, ã nire Maríare tiro. ");
INSERT INTO gvc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","To ã nichʉ tʉhoro õ sehe nire Jesu: —Ã niecʉ tjiga ticorore. To me sitiare yʉhʉre to dʉharire yʉhʉre pio payore, yʉhʉre masa copapʉ ti siõ sãahto pano yʉ pjacʉre cahnoyuro. Pjacʉoina sehe mʉsa mehne ã jirucuahca. Ã jina tinare wa masina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yʉhʉ sehe ahri yahpapʉre mʉsa mehne ã jirucusi —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ã yoa Jesu Betaniapʉ to jichʉ tʉhoa sã coyea judio masa payʉ tirore ñʉa tare. Tiro dihtare ñʉa taa nierare. Lázaro yariariro cjirore Jesu to masorirore tiro cʉ̃hʉre ñʉa taa nire. ");
INSERT INTO gvc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ti ñʉa sʉrire masia sacerdotea pʉhtoa Lázaro cʉ̃hʉre wajã duare. ");
INSERT INTO gvc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro yariariro cjiro Jesu to masoriro jichʉ ñʉa payʉ masa Jesure wacũ tuare. To ã masochʉ ñʉa payʉ judio masa ti sacerdotea ya buhea sehere duhunocari jire. Ã ti duhuchʉ ñʉa sacerdotea pʉhtoa sehe sua yʉhdʉa Lázarore wajã duare. ");
INSERT INTO gvc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pascua bose nʉmʉrine ti yoachʉ payʉ masa Jerusalẽpʉ ñʉa wahari jire. Pa dachoi Jerusalẽpʉ Jesu to tahto cjihtore masa tʉhori jire. ");
INSERT INTO gvc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ã jia pja pũ sahnarine na wahcã, tirore piti bocaa wahare. Ã piti bocaa õ sehe ni sañurucure tina: —Ahrirore wahche payojihna. Ahriro Cohamacʉ to warocariro noano yʉhdʉjaro. Ahriro Israe yahpa macaina mari pʉhtoro tjira —ni sañurucure tina. ");
INSERT INTO gvc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu burrocã to bocariro bui pisare. “Õ seheta yoarohca”, ni joaa tiha Cohamacʉ yare ti joari tjui: ");
INSERT INTO gvc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalẽ wama tiri maca macaina, cuiena tjiga mʉsa. Ñʉga. Mʉsa pʉhtoro burrocã bui pisa tara”, ni yahuha Cohamacʉ yare ti joari tjui. ");
INSERT INTO gvc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","“To ã ni joari Jesure nino nica” ni, sã to buheina noano masierasinihi. Ã masierasinipanahta mʉanopʉ Jesu to mʉjari baharo sã ti joari cjirire wacũ boca tʉho ñaha masihi. Õ sehe ni tʉhotuhi: “Cohamacʉ yare ti joari tju sehe Jesure yahuro nimaha. Ã jia Cohamacʉ yare ti joari tju to niriro seheta yoare masa Jesure”, ni tʉhotu, sã masihi. ");
INSERT INTO gvc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lázarore ti siõ sãari copapʉ jirirore Jesu to pisuchʉ tirore to masochʉ ñʉrina cjiri yahure masare. ");
INSERT INTO gvc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ã jia Lázarore Jesu masorire ti tʉhori baharo masa payʉ Jesure ñʉa tare. ");
INSERT INTO gvc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ti ã tachʉ ñʉa fariseo curua macaina ti basi õ sehe niri jire: —Jipihtina Jesu yaina dihta wahaa nina mipʉre. Ã jina mari dohse yoa masieraja tinare —niri jire fariseo curua macaina ti basi. ");
INSERT INTO gvc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ã yoa bose nʉmʉri Cohamacʉre ño payoa taina mehne macaina mahainacã griego masa jire. ");
INSERT INTO gvc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ã jia tina Felipe cahapʉ wihiri jire. Felipe sehe Betsaida wama tiri maca Galilea yahpai jiri maca macariro jire. Ã jia tiro cahapʉ wihirina õ sehe niri jire tirore: —Jesure ñʉ duaja sã —niri jire tina. ");
INSERT INTO gvc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ti ã nichʉ tʉhoro Felipe Andrepʉre tíre yahuro wahari jire. Ã jia tina pʉaro Jesure yahure. ");
INSERT INTO gvc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ti ã yahuri baharo Jesu tinare õ sehe ni yahure: —Yʉhʉ masʉno Cohamacʉ warocariro jija. Yʉhʉre jipihtina ti ño payohti pja mipʉre jirota nina. Mipʉre yʉ yariahti pja jirota nina. ");
INSERT INTO gvc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Potocãta mʉsare yahui nija. Toari yapare yahpapʉ mari yaerachʉ, tí yapare mari toaerachʉ cʉ̃ yapata tjuarohca. Ã jiro tí yapare mari yari baharo dicha tirohca. (Tó seheta yʉ yariari baharo yʉhʉre masa copapʉ ti siõ sãari baharo payʉ masare Cohamacʉ mehne ã jirucuhtina jichʉ yoaihca yʉhʉ.) ");
INSERT INTO gvc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ahri yahpai mʉsa jiare pjíro tʉhotuboca mʉsa. Ã tʉhotuna Cohamacʉre wacũerana, pichacapʉ wahanahca mʉsa. Ahri yahpai mʉsa jiare ã tʉhotunocahna, Cohamacʉ mehne ã jirucunahca. ");
INSERT INTO gvc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yʉ yare yoa duana, yʉ buheare noano tʉhoga mʉsa. Mʉsa ã yoana mʉsa cʉ̃hʉ yʉ jihtopʉre jinahca. Yʉ yare yoarirore yʉ Pʉcʉ sehe wahchea mehne ñʉnohca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ã ni tuhsʉ õ sehe ni namore: —Mipʉre yʉhʉ ñano yajeripohna tija. ¿Yʉ Pʉcʉre dohse niihcari yʉhʉ? “Mai, yʉ ñano yʉhdʉhtore yoai tjia yʉhʉre”, ¿nibocari yʉhʉ? Tíre nieraja yʉhʉ. Ñano yʉhdʉhtiro cjihtota ahri yahpapʉre tahi. Ã yoa yʉ ñano yʉhdʉhti pja mipʉre jiro nina —ni yahure Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ã yoa õ sehe nire to Pʉcʉrore: —Mai, mʉ tuariro jiare mipʉre ñoga masare —nire Jesu to Pʉcʉrore. To ã nichʉ mʉanopʉ durucuro coa tare: —Tuariro yʉ jiare masare ño tuhsʉhi. Mipʉre ã jicʉ pari turi ñoihca masare —nino coa tare. ");
INSERT INTO gvc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","To ã nino coa tachʉ tʉhoa tói ducuina masa payʉ õ sehe nire: —Wʉpo jica ã coa taro —nire masa. —Anjo Jesure yahuro nire —nire paina masa. ");
INSERT INTO gvc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Õ sehe nire Jesu sehe: —Mʉanopʉ yʉhʉre tʉho dutiro ã nino coa taerare. Mʉsa sehere tʉho dutiro ã nino coa tare. ");
INSERT INTO gvc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mipʉre ahri yahpa macaina ti ñano yoari buhirire buhiri dahrerohca tinare. Ahri yahpa macaina ti pʉhtorore watĩnore cohãnohca Cohamacʉ. ");
INSERT INTO gvc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ã jicʉ yʉhʉre crusapʉ ti wahcõ dapochʉ payʉ masare yʉhʉ mehne macaina ti wahachʉ yoaihca yʉhʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ã nino “Crusapʉ to yariahtore”, yahuro nire Jesu masare. ");
INSERT INTO gvc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","To ã nichʉ tʉhoa masa sehe tirore õ sehe nire: —Cohamacʉ yare ti joari tjui õ sehe nina: “Cristo jipihtia dachoripe jirohca”, ni joaa tiha. ¿To ã ni joachʉ mʉhʉre masʉnore Cohamacʉ warocarirore dohse jiro baro mʉhʉre crusapʉ wahcõ dapoahcari masa? ¿Masʉno Cohamacʉ warocariro noa jijari tiro? —ni siniture tina. ");
INSERT INTO gvc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ti ã nichʉ õ sehe ni yʉhtire Jesu: —Buhriaro to ñʉ masichʉ yoaro seheta jicʉ masare Cohamacʉ yare noano masichʉ yoaja yʉhʉ. Baharo curerocã mʉsa mehne jisi yʉhʉ. Mʉsare yʉ buhechʉ mipʉre tʉhoga ñaare mʉsa yoaerahti cjihtire Cohamacʉ mehne mʉsa ã jirucuhti cjihtire. Yʉ buheare tʉhoeraina nahitianoi tiniina yoaro seheta ti wahahtore masierara. ");
INSERT INTO gvc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yʉhʉ buhriaro yoaro sehe jiriro tjija. Ã jicʉ mʉsare buhecʉ Cohamacʉ yare noano masichʉ yoaja mʉsare. Mipʉre yʉ wahahto pano yʉhʉre wacũ tuaga. Ã wacũ tuana yʉ yaina jinahca mʉsa —nire Jesu. Ã ni yahu tuhsʉ duhti wahcãa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Payʉ tahari Cohamacʉ tuaa mehne tinare Jesu to yoa ñopachʉta judio masa payʉ tirore ne tʉho duaerare. ");
INSERT INTO gvc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Cohamacʉ yare ti joari tjui Isaia cjiro to joariro seheta ã yoaa nire tina. Õ sehe ni joaa tiha Isaia cjiro: “Cohamacʉ, mʉ buheare sã yahuchʉ masa tʉho duaerare. Mʉ tuaare tinare mʉ yoa ñopachʉta, tíre ‘Potocã jierara’, nire tina”, ni joaa tiha Isaia cjiro. ");
INSERT INTO gvc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ti ã tʉho duaerachʉ ñʉno Cohamacʉ tinare masierachʉ yoare. Tí cʉ̃hʉre Isaia cjiro õ sehe ni joaa tiha tjoa: ");
INSERT INTO gvc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Capari ñʉeraina yoaro sehe jiina jichʉ yoaa tiha Cohamacʉ tinare. Ã yoa to yare masierachʉ yoaa tiha tinare. Ã jia to tuaare ñʉpahta tina ti ñʉrire tʉho ñahaerara. Ã jia to buheare tʉhopahta tíre tʉho ñahaerara tina. Cohamacʉ ya buheare masia, ti ñaa yoari buhirire cohã dutiboa. Ã jiro tinare yʉhdʉchʉ yoaboa tiro”, ni joaa tiha Isaia cjiro Cohamacʉ yare ti joari tjui. ");
INSERT INTO gvc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ã ni joaro Isaia cjiro Cristo tuaare masino to niriro seheta Cristore yahu joaa tiha tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Paina Jesure ti cahmaerapachʉta judio masa, sã pʉhtoa mehne macaina cʉ̃hʉ payʉ Jesure wacũ tuaa, tirore cahmare. Ã cahmapahta tina fariseo curua macainare cuia painare “Jesu mehne sãahi”, ni yahu duaerare. Tíre ti yahuchʉ tʉhoa Jesure ti cahmari buhiri judio masa sã buheri wʉhʉpʉ tinare sãa dutieraboa fariseo curua macaina sehe. ");
INSERT INTO gvc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Cohamacʉre wahchechʉ yoa duapahta tí yʉhdoro fariseo curua macaina sehere wahchechʉ yoa duare Jesure cahma dʉcaina. Ã jia tina “Jesu yaina wahahi”, ni painare yahu duaerare. ");
INSERT INTO gvc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ã yoa Jesu tuaro sañurucu, õ sehe ni yahure: —Yʉhʉre wacũ tuariro, yʉhʉ dihtare wacũ tuaerara. Yʉhʉre warocariro cʉ̃hʉre wacũ tuara tiro. ");
INSERT INTO gvc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tuhsʉ, yʉhʉre masiina yʉhʉre warocariro cʉ̃hʉre masina. ");
INSERT INTO gvc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Buhriaro to ñʉ masichʉ yoaro seheta ahri yahpapʉ Cohamacʉ yare masichʉ yoai tai nihi yʉhʉ. Ã jicʉ Cohamacʉ yare masare masichʉ yoaja. Nahitianoi wahariro yoaro sehe jiriro ñaare yoarucura. Yʉhʉre wacũ tuariro tiro yoaro sehe yoasi. Yʉhʉre wacũ tuariro quihõno tʉhorohca. ");
INSERT INTO gvc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Paina yʉ yahuare tʉhopahta yʉ niriro seheta yoaerara. Ti ã yoaerapachʉta yʉ yahuare ti yoaerari buhirire buhiri dahresi yʉhʉ sehe tinare. Ahri yahpapʉre buhiri dahrei tai nierahi yʉhʉ. Ahri yahpa macainare pichacapʉ wahaborinare yʉhdʉchʉ yoahtiro cjihto tai nihi yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉhʉre cahmaerainare, yʉ yahua cʉ̃hʉre cahmaerainare buhiri dahrea jiahca. Tina yʉ yahuare ti tʉhoerari buhiri ahri yahpa pihtiri dachoi buhiri tiahca. ");
INSERT INTO gvc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉhʉ yʉ mʉ sʉro yahueraja. Yʉ Pʉcʉ yʉhʉre warocariro sehe yʉhʉre yahu dutire. Ã jia yʉ yahua sehe to ya durucua jira. ");
INSERT INTO gvc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","To ya durucuare “Quihõno jira” nina, Cohamacʉ mehne ã jirucunahca mʉsa. Ã jicʉ yʉ Pʉcʉ to yahu dutiriro seheta yahuja mʉsare —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ã yoa pascua bose nʉmʉri panocã ahri yahpare to cohã wahcãhto cjihtore to Pʉcʉro cahapʉ to wahahto cjihtore masire Jesu. Tuhsʉ, ahri yahpa macainare to yainare tiro tuaro cahĩre tina mehne to jiro puro. Ã cahĩrucura to yainare. ");
INSERT INTO gvc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tí ñamine Jesu sã to buheina mehne sã chʉchʉ Juda Iscariotere Simo macʉnore Jesure ñʉ tuhtiinare ño duti tuhsʉri jire watĩno sehe. ");
INSERT INTO gvc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tuhsʉ, to Pʉcʉro Cohamacʉ Jesure jipihtina bui to pʉhtoro sõrire masire Jesu. Ã yoa Cohamacʉ cahapʉ to tari cjirire, baharo mʉanopʉ to mʉjahti cʉ̃hʉre masire. ");
INSERT INTO gvc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ã masino wahcãrʉca, to suhtiro bui macanore tjuwe na, tóre cũ tuhsʉ, suhtiro cahsaro mehne to pjaro yʉjʉi dʉhtere. ");
INSERT INTO gvc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dʉhte tuhsʉ, waparoi core pio sãa, sã to buheinare sã dahporire cosa dʉcare. Sãre cosa tuhsʉ to dʉhteri cahsaro mehne pahã cohãre sã dahporire. ");
INSERT INTO gvc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Paina buheinare cosa wahcã, Simo Pedropʉre sʉre. To dahporire to cosahto pano Pedro sehe tirore õ sehe nire: —Pʉhtoro, ¿yʉ dahporire cosai tai nijari mʉhʉ? —nire Jesure Pedro. ");
INSERT INTO gvc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Michapucacã mʉhʉre yʉ yoahtire masierara mʉhʉ. Ã masierapacʉta baharo masiihca mʉhʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Yʉ dahporire ne cosasi mʉhʉ —nire Pedro. —Mʉhʉre yʉ cosaerachʉ yʉ yairo jisi mʉhʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Pʉhtoro, yʉ dahpori dihtare cosai tjiga. Yʉ dahporire, yʉ wamomacarine, yʉ dapu cʉ̃hʉre cosaga —nire Pedro. ");
INSERT INTO gvc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","To ã nichʉ Jesu piti dahre buhero õ sehe nire: —Cʉ̃iro masʉno cuhsʉro to pjacʉre noano tju cosa pahñona. Ã jiro pari turi tirore tju cosaro cahmaerara. To dahpori dihtare cosaro cahmana. Jipihtina mʉsa ñaa yoari buhirire cosarina cjiri mʉsa jipachʉta cʉ̃iro mʉsa mehne macariro to ñaa yoari buhirire cosamahnoerariro jira —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu tirore ñʉ tuhtiinare ñohtirore masire. Ã masino “Cʉ̃iro mʉsa mehne macariro to ñaa yoari buhirire cosamahnoerariro jira”, nire. ");
INSERT INTO gvc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sã dahporire cosa tuhsʉ, to suhtirore sãa tuhsʉ, nuju sʉre to dujiriroihta. —¿Michapucacã mʉsare yʉ yoarire tʉho ñahajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mʉsa yʉhʉre “Buheriro”, ni pisuna, “Pʉhtoro”, ni pisuna potocãta nina nica yʉhʉre. Mʉsare buheriro, mʉsa pʉhtoro potocãta jija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ã jina yʉhʉ mʉsare buheriro, mʉsa pʉhtoro jipaihta mʉsa dahporire cosariro yʉ jichʉ ñʉna mʉsa cʉ̃hʉ mʉsa mehne macaina dahporire cosaga. ");
INSERT INTO gvc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Michapucacã mʉsare cosacʉ, baharo mʉsa yoahti cjihtire mʉsare ñoi nija. Mʉsa mehne macainare mʉsa yoadohohtire ñoi nija. Mʉsare yʉ yoariro seheta mʉsa cʉ̃hʉ yoaga. ");
INSERT INTO gvc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Potocã mʉsare niita nija. Mʉsa yʉ cahamaca yoaro sehe jiina yʉ bui jierara. Mʉsare buhe duti yʉ warocarina jira mʉsa. Ã jina yʉ bui jierara mʉsa. Ã jicʉta “Yʉ yoariro seheta yoaga”, nihi mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ahrire masina, yʉ dutiare yoana, wahcheina jinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mʉsare jipihtinare ã nieraja. Yʉ beserinare masija yʉhʉ. Cohamacʉ to yare ti joari tjui to ni joariro seheta ã waharohca. “Yʉhʉ mehne chʉrirota yʉhʉre wajã duare”, ni joaa tiha Cohamacʉ yare ti joari tjui. ");
INSERT INTO gvc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","To ã yoahto pano ahrire yahuyui nija mʉsare. Yʉhʉre to ã yoari baharo “Jesuta Cristo Cohamacʉ warocarirota jira”, mʉsa nihti cjihtire ahrire mʉsare yahuyui nija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Potocã mʉsare niita nija. Yʉ warocainare cahmariro yʉhʉ cʉ̃hʉre cahmana tiro. Tuhsʉ, yʉhʉre cahmariro yʉhʉre warocariro cʉ̃hʉre cahmana tiro —nire Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ã ni yahu tuhsʉ Jesu tuaro cahyare. Ã cahyaro õ sehe ni yahure tiro sãre: —Potocãta mʉsare nii nija. Cʉ̃iro mʉsa mehne macariro yʉhʉre ñʉ tuhtiinare yʉhʉre ñonohca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","To ã nichʉ tʉhona Jesure ñohtirore masierana, sã basi cahma ñʉroca õi. ");
INSERT INTO gvc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cʉ̃iro Jesu to buheina mehne macariro yʉhʉ, Jesu to cahĩriro sehe to pari wahpa dujihi. ");
INSERT INTO gvc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yʉ ã dujichʉ ñʉno Simo Pedro yʉhʉre to wamomaca mehne yoa ño, siniture: —¿Jesure ñohtirore diro sehere nino nibocari Jesu? Yahuga sãre —ni to wamomaca mehne yoa ño, sinitu ñʉre Pedro. ");
INSERT INTO gvc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","To ã nichʉ yʉhʉ sehe Jesu cahacãi dujiriro jicʉ sinitu ñʉhi tirore: —Pʉhtoro, ¿dirore nii nijari mʉhʉ? —ni sinitu ñʉhi yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Ahri pãore dahra waha na, soha yʉ wahtiro sehe tirota jira yʉhʉre ñohtiro —nire Jesu. Ã ni tuhsʉ ti pão to dahra waha narirore soha tuhsʉ tíre Judare Simo Iscariote macʉnore ware. ");
INSERT INTO gvc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ã yoa pãore to ñahari baharo watĩno sehe Judare ñano yoa dutiri jire. Ã jiro Jesu tirore õ sehe nire: —Mʉ yoahto cjihtore cjero yoa bahrañoga mʉhʉ —nire Jesu Judare. ");
INSERT INTO gvc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","To ã nichʉ tʉhona sã mesapʉ dujiina, Jesu Judare to nirire noano tʉho ñahaerahi. ");
INSERT INTO gvc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Cãina õ sehe ni tʉhotumahi: “Judá sã niñerure wihboriro jira. Ã jiro bose nʉmʉi sã chʉhti cjihtire nuchʉ dutiro warocare Jesu Judare. O pjacʉoinare niñerure wa dutiro niboca Jesu”, ni tʉhotumahi sã cãina. ");
INSERT INTO gvc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ã yoa Juda tí pãore ñaha tuhsʉ, wijaa wahare. To wijaari pja ñami jire. ");
INSERT INTO gvc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","To ã wijaari baharo õ sehe nire Jesu: —Mipʉ pinihtare yʉhʉ masʉno Cohamacʉ warocariro yʉ tuariro yʉ jia tiare ñonohca Cohamacʉ masare. Ã jicʉ Cohamacʉ to tuariro to jiare ñoihca yʉhʉ sehe. ");
INSERT INTO gvc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ã jiro Cohamacʉ to tuaare yʉ ñochʉ tiro sehe yʉ ya tuaa cʉ̃hʉre mipʉ pinihtare ñono taro nina. ");
INSERT INTO gvc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉ pohna yʉ cahĩina, yʉhʉre tʉhoga. Mahaa dachoricã mʉsa mehne jisiniihca. Yʉ wahari baharo yʉhʉre macanahca mʉsa. Ã jicʉ mari coyea judio masare yʉ niriro seheta mʉsa cʉ̃hʉre nija. “Yʉ wahahtore mʉsa sehe waha masierara”, tinare yʉ niriro seheta mʉsa cʉ̃hʉre ã ni yahuja. ");
INSERT INTO gvc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Wahma dutiare mʉsare yahuihtja. Mʉsa mehne macainare cahĩga mʉsa. Mʉsare yʉ cahĩriro seheta, mʉsa mehne macainare cahĩga. ");
INSERT INTO gvc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ã jina mʉsa mehne macainare mʉsa cahĩchʉ ñʉa yʉ yaina mʉsa jiare masiahca paina —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","To ã nichʉ Simo Pedro Jesure õ sehe ni sinitu ñʉre: —Pʉhtoro, ¿nohopʉ wahaihcari mʉhʉ? —nire Pedro. —Yʉ wahahtopʉre mipʉre yʉhʉ mehne waha masierara mʉhʉ. Mipʉre waha masierapaihta baharo yʉ cahai wahacʉhca —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Pʉhtoro, ¿dohseacʉ mipʉre mʉhʉ mehne waha masierabocari yʉhʉ? Yʉhʉre ti wajã duapachʉta mʉhʉre ne duhusi yʉhʉ —nire Pedro Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Ã tjijari? ¿Mʉhʉre ti wajã duapachʉta, mʉhʉ yʉhʉre duhueraihcari? Potocãta mʉhʉre nii nija. Caraca to duhto pano “Jesure masieraja”, niihca mʉhʉ painare. Tia taha ã niihca mʉhʉ —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Baharo Jesu sãre õ sehe ni yahure: —Ne cahya pjíro tʉhotuena tjiga. Cohamacʉre wacũ tuaga. Ã jina yʉhʉ cʉ̃hʉre wacũ tuaga. “Cohamacʉ mehne yʉhdʉnahca”, ni tʉhotuga tirore. Yʉhʉ cʉ̃hʉre ãta ni tʉhotuga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉ Pʉcʉ to jiropʉre payʉ wʉhʉse jira. Mʉsa jihto cjihtore cahnoyui wahai nija. Tí potocã tjira. Ã jicʉ mʉsare tíre yahuja. ");
INSERT INTO gvc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ã jicʉ mʉsa jihto cjihtore cahno tuhsʉ, õpʉta pari turi majare tjua taihtja yʉhʉ. Ã jina tói yʉ jiroita mʉsa cʉ̃hʉ jinahca tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mipʉre yʉ sʉhtopʉre wahari mahare masi tuhsʉra mʉsa —nire Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—Pʉhtoro, mʉ sʉhtore masieraja sã. ¿Ã jina dohse yoa mʉ wahari mahare masinahcari sã? —ni sinitu ñʉre Toma Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","To ã ni sinituchʉ tʉhoro Jesu sehe õ sehe ni yʉhtire: —Yʉhʉ Cohamacʉ cahapʉ wahari maha yoaro sehe jiriro jija. Cohamacʉ cahapʉ wahachʉ yoariro, potocã yahuriro, ã catirucuchʉ yoariro jinocaita nija yʉhʉ. Ã jia yʉ yaina dihta yʉ Pʉcʉ cahapʉ wahaahca. ");
INSERT INTO gvc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Panopʉ yʉhʉre masina, yʉ Pʉcʉ cʉ̃hʉre masiboa mʉsa. Mipʉre tirore ñʉre mʉsa. Ã jina tirore masi tuhsʉra mʉsa —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","To ã nichʉ Felipe sehe õ sehe nire: —Pʉhtoro, mari Pʉcʉre ñoga sãre. Tó purota ñʉ duaja sã —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","To ã nichʉ Jesu õ sehe ni yahure: —Felipe, ¿yoari pja yʉhʉ mehne jipaihta, mʉhʉ masierasinijari yʉhʉre? Yʉhʉre ñʉriro yʉ Pʉcʉ cʉ̃hʉre ñʉ tuhsʉre. Ã jicʉ “Mari Pʉcʉre ñoga sãre” nicʉ, ¿dohseacʉ ã nijari mʉhʉ yʉhʉre? ");
INSERT INTO gvc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yʉhʉ yʉ Pʉcʉ mehne pʉaro jipanahta cʉ̃irota jija. ¿Tíre “Potocã jierara”, niimeje nijari mʉhʉ? Mʉsare yahucʉ yʉ mʉ sʉro yahui nieraja. Yʉ Pʉcʉre yahubasai nija. Ã jiro tiro yʉhʉ mehne jiriro to tuaa mehne yoa ñona. ");
INSERT INTO gvc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yʉhʉ yʉ Pʉcʉ mehne pʉaro jipanahta cʉ̃irota jija. Tíre “Potocã tjira”, ni wacũga mʉsa. Tíre “Potocã tjira” nierana, Cohamacʉ tuaa mehne yʉ yoa ñoare wacũna, yʉ Pʉcʉ mehne yʉ cʉ̃irota jiare “Potocã tjira”, ni wacũga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Potocãta mʉsare nii nija. Yʉhʉre wacũ tuariro yʉ yoariro seheta yoarohca. Ã yoa tiro yʉ yʉhdoro yoarohca. Yʉ Pʉcʉ cahapʉ tjuaai tai nija mipʉre. Ã jiro yʉhʉre wacũ tuariro yʉ yʉhdoro Cohamacʉ tuaa mehne yoa ñonohca. ");
INSERT INTO gvc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ã jicʉ yʉhʉre wacũ tuaina ti sinino purota yoaihca. Ã yoacʉ yʉ Pʉcʉ to tuariro jiare ñoihca. ");
INSERT INTO gvc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yʉhʉre wacũ tuaina mʉsa jichʉ mʉsa sinino purota yoaihtja —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ã ni tuhsʉ õ sehe ni namore: —Yʉhʉre mʉsa cahĩna, yʉ dutiare noano yoanahca. ");
INSERT INTO gvc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yʉ Pʉcʉre sinibasaihtja. Yʉ ã sinibasachʉ yʉ Pʉcʉ sehe pairore mʉsare yoadohohtirore mʉsare warocarohca. Ã jiro tiro mʉsare yoadohohtiro sehe jipihtia dachoripe mʉsa mehne ã jirucurohca. ");
INSERT INTO gvc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tiro potocãta yahuriro Espíritu Santo tjira. Ahri yahpa macaina yʉhʉre cahmaeraina sehe tirore masierara. Ã jia tirore cjʉa masierara. Tirota mʉsa mehne ã jirucurohca. Ã jina tirore masina mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Mʉsare cohãsi yʉhʉ. Mʉsa mehne jihtiro cjihto tjua taihca yʉhʉ tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wiho mejeta mahanocã dʉhsara yʉ wahahto cjihto. Yʉ wahari baharo ahri yahpa macaina yʉhʉre wacũ tuaeraina yʉhʉre pari turi ñʉsi. Mʉsa sehe yʉhʉre ñʉnahca. Yʉ catiriro jichʉ mʉsa cʉ̃hʉ jipihtia dachoripe Cohamacʉ mehne catirucunahca. ");
INSERT INTO gvc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tí dachoi yʉ tjua tahti dachoi yʉhʉ yʉ Pʉcʉ mehne cʉ̃irota sã jichʉ masinahca mʉsa. Ã jina yʉhʉ mehne macaina mʉsa jichʉ mʉsa mehne macariro yʉ jichʉ cʉ̃hʉre masinahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉ dutiare yoariro yʉhʉre cahĩrirota jira. Ã jiro yʉhʉre cahĩrirore yʉ Pʉcʉ sehe cahĩnohca. Ã jicʉ yʉhʉ cʉ̃hʉ yʉ dutiare yoarirore cahĩihca. Ã yoa yʉ jia tiare noano masichʉ yoaihca tirore —nire Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sã mehne macariro pairo Juda wama tiriro jire. Juda Iscariote Jesure ñʉ tuhtiinare ñohtiro jierare tiro. Pairo Juda jire. Ã jiro tiro Jesure õ sehe ni siniture: —Pʉhtoro, ¿dohse yoaijari mʉhʉ tinare ã nicʉ? ¿Ahri yahpa macainare mʉhʉre masichʉ yoaeracʉ, dohse yoacʉ sã dihtare mʉhʉre masichʉ yoaihcari mʉhʉ? —ni siniture Juda. ");
INSERT INTO gvc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","To ã nichʉ tʉhoro Jesu tirore õ sehe ni yahure: —Yʉhʉre cahĩina, yʉ dutiare noano yoaa nina. Ti ã yoachʉ yʉ Pʉcʉ sehe tinare cahĩnohca. Ã jina tina mehne jina tanahca sã. ");
INSERT INTO gvc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉhʉre cahĩerariro yʉ dutiare yoaerara. Tuhsʉ, yʉ yahua mʉsa tʉhori cjiri sehe yʉ ya yahua jierara. Yʉhʉre warocariro ya yahua sehe jira. Tiro yʉ Pʉcʉ tjira. ");
INSERT INTO gvc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Mʉsa mehne jisinicʉ ahrire mʉsare yahusinii nija. ");
INSERT INTO gvc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Baharo yʉ sinibasachʉ yʉ Pʉcʉ Espíritu Santore warocarohca mʉsare. Tiro Espíritu Santo sehe mʉsare yoadohohtiro jiro, mʉsare buhe pahñonohca tiro. Ã yoa mʉsare yʉ yahuri cjirire mʉsare wacũchʉ yoarohca tiro. ");
INSERT INTO gvc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Mʉsare noano jichʉ yoaihca yʉhʉ. Yʉhʉ yʉ noano jiriro seheta noano jichʉ yoaihca mʉsare. Ahri yahpa macaina ti mahñoperiro seheta yoasi yʉhʉ mʉsare. Yʉhʉ pinihta potocãta noano jichʉ yoaihca mʉsare. Cahya pjíro wacũena tjiga mʉsa. Ã jina cuiena tjiga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yʉhʉ wahaihca. Ã jicʉ mʉsa mehne jihtiro cjihto tjua taihtja tjoa”, mʉsare yʉ ã ni yahuchʉ tʉho tuhsʉre mʉsa. Tíre tʉhona, wahcheboa mʉsa. Yʉhʉre mʉsa potocã cahĩrina jina, wahcheboa mʉsa. Yʉ Pʉcʉ sehe yʉ yʉhdoro tuara. Ã jina tiro cahapʉ yʉ wahahto cjihtore mʉsa masiri baharo yʉhʉre cahĩna, wahcheboa mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yʉhʉre mʉsa wacũ tuahti cjihtire yʉ wahahtore yahuyui nija mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ahri yahpa macaina pʉhtoro watĩno sehe tara mipʉre. To ã tachʉ yʉhʉ mʉsa mehne yʉ durucu batoahti pja mahanocã dʉhsara. Tiro sehe yʉhʉre yʉhdʉrʉca masierara. ");
INSERT INTO gvc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wiho mejeta yʉhʉre yʉ Pʉcʉ to dutiriro seheta yoaja yʉhʉ. Ãta yoaja yʉhʉ yʉ Pʉcʉre yʉ cahĩare ahri yahpa macaina ti masihti cjihtire. Wahcãrʉcaga. Basa wahana —nire Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Baharo piti dahre buhero sãre õ sehe nire Jesu: —Yʉhʉ potocãta secʉ yoaro sehe jiriro jija. Yʉ Pʉcʉ sehe secʉre ñʉ wihboriro yoaro sehe jiriro jira. ");
INSERT INTO gvc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yʉ yaina secʉ dʉpʉri yoaro sehe jiina yʉhʉ mehne macainata jira. Dicha mariea dʉpʉrire secʉre ñʉ wihboriro to paha cohãriro seheta yʉ Pʉcʉ to cahmaare yoaerainare cohãna. Dicha tia dʉpʉrire secʉre ñʉ wihboriro to cahnoriro seheta yʉ Pʉcʉ to cahmaare yoainare yoadohorohca tiro “Yʉ cahmaare yoa namojaro”, nino. ");
INSERT INTO gvc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yʉ yahuare tʉhona, “Potocã tjira”, nire mʉsa. Ã jiro yʉ Pʉcʉ mʉsa ñaa yoari buhirire cohã tuhsʉre. ");
INSERT INTO gvc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉhʉ mehne macaina jiga mʉsa. Ã jii mʉsa mehne jiihca. Secʉ dʉpʉri secʉ mehne wahã sʉera dʉpʉri jia, tí dʉpʉri sehe dicha mariahna. Tó seheta yʉhʉ mehne macaina jierana yʉ Pʉcʉ cahmaare yoa masierara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yʉhʉ secʉ yoaro sehe jiriro jija. Mʉsa sehe tʉ dʉpʉri yoaro sehe jiina jira. Yʉhʉ mehne macariro mehne yʉ jichʉ dicha tia dʉpʉri yoaro sehe tiro yʉ Pʉcʉ cahmaare yoara. Yʉhʉ mehne macaina jierana yʉ Pʉcʉ cahmaare yoa masierara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ñaa dʉpʉrire to cohãboriro seheta yʉhʉ mehne macaina jierainare yʉ Pʉcʉ cohãnohca. Tí dʉpʉri ñaia wahachʉ secʉre ñʉ wihboriro tí dʉpʉrire na cahmachu pichacapʉ jʉ̃ cohãnohca. Ãta yoarohca Cohamacʉ yʉhʉ mehne macaina jierainare. ");
INSERT INTO gvc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Yʉhʉ mehne macaina jina, yʉ buheare boeraboca mʉsa. Ã boerana, mʉsa cahmano purota siniga. Ã jicʉ mʉsa sinino purota yoabasaihtja. ");
INSERT INTO gvc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yʉ Pʉcʉ cahmaare yoaina mʉsa jichʉ ñʉa “Jesu yaina jira ahrina”, ni masiahca masa. Ã jia mʉsare ñʉa yʉ Pʉcʉre ño payoahca. ");
INSERT INTO gvc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉ Pʉcʉ yʉhʉre to cahĩriro seheta mʉsare yʉhʉ cʉ̃hʉ cahĩa tihi. Yʉ cahĩina jirucuga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉ cahĩina jirucuina yʉ dutiare yoara. Yʉ Pʉcʉ to dutiare yoaja yʉhʉ. Ã yoacʉ to cahĩriro jirucuja yʉhʉ. Tó seheta mʉsa cʉ̃hʉ yʉ dutiare yoana yʉ cahĩina jirucunahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ahrire mʉsare yahuhi yʉhʉ mehne mʉsa noano wahchehto cjihtore. Ã jina tuaro wahchenahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Õ sehe dutija mʉsare: Mʉsare yʉ cahĩriro seheta mʉsa mehne macaina cʉ̃hʉre cahĩga. ");
INSERT INTO gvc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cʉ̃iro masʉno tiro mehne macariro yaro jiborirore yariaro tiro mehne macarirore tuaro cahĩna, paina ti cahĩriro yʉhdoro. ");
INSERT INTO gvc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ã jina yʉ dutiare yoana yʉhʉ mehne macaina jira mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Potocãta yʉhʉ mehne macaina waro jira mʉsa. Mʉsa ã jiina jichʉ jipihtia yʉ yoarire yahuja mʉsare. Cahamacʉno to pʉhtoro yoarire masierara tiro. Ã jicʉ “Yʉ cahamaca wiho jiina jira mʉsa”, mʉsare nieraja. Yʉ Pʉcʉ yʉhʉre to yahurire mʉsare yahu pahñohi. Ã yahucʉ “Yʉhʉ mehne macaina jira mʉsa”, mʉsare nija mipʉre. ");
INSERT INTO gvc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉsa sehe yʉhʉre ne beserare. Yʉhʉ sehe mʉsare besei yʉ Pʉcʉ cahmaare mʉsa yoahtina cjihtire. Mʉsa ã yoachʉ mʉsa yoaa ne wiho waro jisi. Ã jia mʉsa yoaa ã jirucuahca. Mʉsa ã yoachʉ yʉhʉre mʉsa wacũ tuachʉ yʉ Pʉcʉre mʉsa sinino purota tiro mʉsare warohca. ");
INSERT INTO gvc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ahrire mʉsare dutija yʉhʉ: Mʉsa mehne macainare cahĩga mʉsa —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ã yoa tiro õ sehe ni yahu namore: —Ahri yahpa macaina mʉsare ti ñʉ tuhtichʉ ñʉna ahrire wacũga mʉsa: Mʉsare ti ñʉ tuhtihto pano yʉhʉ sehere ñʉ tuhti dʉcare tina. ");
INSERT INTO gvc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Cohamacʉre cahmaeraina mʉsa jisinichʉ, tina mehne macainare ti cahĩriro seheta mʉsa cʉ̃hʉre cahĩboa tina. Ahri yahpa macaina mʉsa jisinichʉ mʉsare besei. Ã jina mipʉre ahri yahpa macaina waro jierara mʉsa. Mʉsa ã jierachʉ ñʉa ahri yahpa macaina mʉsare ñʉ tuhtira. ");
INSERT INTO gvc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Yʉ yaina jina mʉsa yʉ bui jierara”, mʉsare yʉ niri cjirire wacũga mʉsa. Ã yʉ docai jiina jina yʉ ñano yʉhdʉriro seheta ñano yʉhdʉnahca mʉsa cʉ̃hʉ. Yʉhʉre ñano yoarinata mʉsa cʉ̃hʉre ñano yoaahca. Yʉ buhechʉ yʉhtirinata mʉsa buhechʉ cʉ̃hʉre yʉhtiahca tina. ");
INSERT INTO gvc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ahri yahpa macaina yʉhʉre warocarirore masierara. Ã jia yʉhʉre wacũ tuaina mʉsa jichʉ ñʉa tina ñano yoaahca mʉsa cʉ̃hʉre. ");
INSERT INTO gvc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tinare yʉ buhei taerachʉ yʉhʉre ti cahmaerari buhiri buhiri mariaboa. Mipʉre tinare yʉ buheri baharo “Ñaa buhiri mariahna sãre”, ni masierara tina. ");
INSERT INTO gvc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yʉhʉre ñʉ tuhtiriro yʉ Pʉcʉ cʉ̃hʉre ñʉ tuhtira. ");
INSERT INTO gvc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cohamacʉ to tuaa mehne paina ti ne yoaerarire yoa ñohi. Ã yoa tinare tíre yʉ yoa ñoerachʉ tinare ñaa buhiri mariaboa. Cohamacʉ tuaa mehne yʉ yoa ñoare ti ñʉri baharo yʉhʉre yʉ Pʉcʉ cʉ̃hʉre ñʉ tuhtira tina. ");
INSERT INTO gvc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ã ñʉ tuhtia Cohamacʉ yare ti joari tjui dóipʉta to ni joariro seheta yoaa nire tina. Õ sehe ni joaa tiha: “Tinare yʉ ñano yoaerapachʉta yʉhʉre ñʉ tuhtire tina”, ni joaa tiha dóipʉta Cohamacʉ yare ti joari tjui. ");
INSERT INTO gvc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Yʉ baharopʉ mʉsare yoadohohtiro, yʉ Pʉcʉ mehne jiriro mʉsare yʉ warocahtiro Espíritu Santo tjira. Tiro potocãta yahuriro jira. Ã jiro tiro taro yʉ jia tiare yahurohca mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Masare yʉ buhe dʉcachʉpʉta mʉsa cʉ̃hʉ dachoripe yʉhʉ mehne ã jirucure. Ã jina mʉsa cʉ̃hʉ yʉ jia tiare yahunahca painare —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ã ni tuhsʉ sãre õ sehe ni yahu namore: —Baharo yʉ buheare yʉhʉ cʉ̃hʉre mʉsa cohãerahti cjihtire ahrire jipihtiare yahuhi mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judio masa mari buhea wʉhʉsepʉ mʉsa sãa duachʉ sãa dutisi mʉsare yʉ yaina mʉsa jiri buhiri. Ã jia pa tehepʉ mʉsare wajãa, “Cohamacʉ cahmaare yoana nija”, ni tʉhotuahca paina. ");
INSERT INTO gvc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yʉ Pʉcʉre, yʉhʉ cʉ̃hʉre tina masierara. Ã masieraa mʉsare ñano yoaahca tina. ");
INSERT INTO gvc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ã jina mʉsare ñano ti yoachʉ ñʉna, “Ti õ sehe yoahto panota Jesu yahu tuhsʉre sãre”, ni wacũnahca mʉsa. Mʉsa ã ni wacũhti cjihtire mipʉre ahrire yahu mʉhtai nija mʉsare —ni yahure Jesu. Ã ni tuhsʉ õ sehe ni yahu namore Jesu: —Wahmanopʉre mʉsa mehne jicʉ ahrire mʉsare yahuerahi. ");
INSERT INTO gvc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mipʉ sehere yʉhʉre warocariro cahapʉ wahaihca wahai tai nija. “¿Nohopʉ wahaihcari mʉhʉ?” yʉhʉre ni, ne cʉ̃iro barota sinitu ñʉerara mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ã sinitu ñʉerapanahta yʉ wahahtore mʉsare yʉ yahu mʉjachʉ mʉsa ñano yajeripohna tira. ");
INSERT INTO gvc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mʉsare potocãta yahui nija. Yʉ wahari baharo mʉsare noanocanohca. Yʉ mʉanopʉ wahaerachʉ mʉsare yoadohohtiro sehe taeraboa. Wahacʉ mʉsare tirore warocaihtja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yʉ ã warocachʉ tiro tarohca. Ã wihiro ahri yahpa macaina ñaa yoaina ti ñaa buhiri tiare tinare masichʉ yoarohca tiro. Noano jia tia cʉ̃hʉre buherohca tiro masare. Tuhsʉ, Cohamacʉ masare to buhiri dahrehto cʉ̃hʉre masichʉ yoarohca masare yoadohohtiro sehe. ");
INSERT INTO gvc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yʉhʉre wacũ tuaeraina jira ahri yahpa macaina. Ã jiro yoadohohtiro sehe masa ñaa yoaina ti ñaa buhiri tiare tinare masichʉ yoarohca. ");
INSERT INTO gvc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yʉ Pʉcʉ cahapʉ wahaihca. Yʉ ã wahari baharo mʉsa yʉhʉre ne ñʉsinisi. Ã jiro noano jia tia cʉ̃hʉre masichʉ yoarohca yoadohohtiro sehe. ");
INSERT INTO gvc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ahri yahpa macaina pʉhtoro watĩnore Cohamacʉ buhiri dahre duti tuhsʉre. Ã jiro Cohamacʉ masare, watĩno mehne macainare to buhiri dahrehti cʉ̃hʉre masichʉ yoarohca yoadohohtiro sehe. ");
INSERT INTO gvc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Pjíro jira mʉsare yʉ yahuhti cjihti. Wiho mejeta mʉsa sehe yʉ yahu pahñochʉ, tʉho ñaha pahñoeraboa. ");
INSERT INTO gvc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ã jiro potocã jiare yahuriro Espíritu Santo sehe mʉsare quihõno jiare yahu pahñono tarohca. Tiro to mʉ sʉro mʉsare yahusi. Yʉ Pʉcʉ tirore to yahu dutirire tiro yahurohca mʉsare. Ã yoa “Baharopʉ õ sehe waharohca”, ni yahuyurohca tiro sehe mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ã yoa yʉ yare mʉsare tiro yahurohca. Ã yahuro yʉhʉre ño payochʉ yoarohca mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jipihtia yʉ Pʉcʉ ya yʉ ya cʉ̃hʉ jira. Ã jicʉ “Espíritu Santo sehe yʉ yare yahurohca mʉsare”, nihi mʉsare —ni yahure Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ã ni tuhsʉ õ sehe ni yahu namore: —Mahanocã baharo yʉhʉre ñʉsi mʉsa. Ã jina baharocãta mʉsa yʉhʉre ñʉnahca tjoa —nire Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","To ã nichʉ tʉhona, sã sehe mahainacã õ sehe ni durucui sã basi: —“Mahanocã baharo yʉhʉre ñʉsi mʉsa. Ã jina baharocãta mʉsa yʉhʉre ñʉnahca tjoa” nino, ¿dohse nino ã niri marine? Ã yoa “Yʉ Pʉcʉ cahapʉ wahaihca” nino, ¿dohse jiro baro marine ã niri tiro? ");
INSERT INTO gvc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Mahanocã” nino, ¿dohse nino ã niri tiro? To yahurire noano tʉho ñahaeraja mari —ni durucui sã basi. ");
INSERT INTO gvc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sã ã ni durucuchʉ Jesu tirore sã sinitu duarire masino, sãre õ sehe ni yahure: —“Mahanocã baharo yʉhʉre ñʉsi mʉsa. Ã jina baharocãta yʉhʉre ñʉnahca tjoa”, ¿yʉ niri cjirire sinitu duajari mʉsa? ¿Tíre yʉ nirire tʉho ñahaerajari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Potocãta mʉsare nii nija. Yʉ yariachʉ ñʉna mʉsa tiinahca. Tuhsʉ, tuaro cahyanahca. Ã jia yʉhʉre ño payoeraina sehe wahcheahca. Mʉsa sehe cahyaina cjiri jipanahta, baharo wahchenahca mʉsa. ");
INSERT INTO gvc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Õ sehe jira tí: Numino niji wahcõno, to ñano yʉhdʉhto pano jira. Ã jiro ticoro tuaro cahyara. Ã cahyaparota to pohna tiri baharo ticorore purĩrire wacũerara ticoro. Wihãrirocã ahri yahpapʉ to masa bajuachʉ ticoro wahchera. Ã jiro ticorore purĩrire wacũerara ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tó seheta mʉsa mipʉre cahyanahca. Baharo mʉsare ñʉihca tjoa. Yʉhʉre ã ñʉna mʉsa tuaro wahchenahca. Mʉsa ã wahchechʉ paina mʉsare cahyachʉ yoa masisi. ");
INSERT INTO gvc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Tí dachoi yʉhʉre mʉsa ñʉri dachoi yʉhʉre sinitu ñʉsi mʉsa. Masi tuhsʉrinapʉ jinahca. Potocãta mʉsare nii nija. Yʉhʉre mʉsa wacũ tuachʉ ñʉno yʉ Pʉcʉre mʉsa siniare tiro mʉsare warohca. ");
INSERT INTO gvc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yʉhʉre wacũ tuaina jina, Cohamacʉre sini masina mʉsa. Ahri dacho panoi tirore ã sinierasinire mʉsa. Yʉhʉre wacũ tuatjiãhna Cohamacʉre siniga. Mʉsa ã sinichʉ mʉsa sinirire mʉsare warohca, mʉsa wahche pahñohti cjihtire —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ã ni tuhsʉ õ sehe ni namore: —Quiti mehne mʉsare yahua tihi. Ã yahupaihta baharo mʉsare quiti mehne yahusi yʉhʉ. Ã yahueracʉ yʉ Pʉcʉ sehere noano poto yahuihtja mʉsare. ");
INSERT INTO gvc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tí dachore mʉsa ya cjihtire yʉ Pʉcʉre sini payosi yʉhʉ. Yʉhʉre wacũ tuana, mʉsa basi tirore sininahca. ");
INSERT INTO gvc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mʉsa yʉhʉre cahĩna. Ã jina yʉ Pʉcʉ cahapʉ yʉ tariro jichʉ “Potocã tjira”, nina mʉsa. Ã niina mʉsa jichʉ ñʉno, yʉhʉre cahĩina mʉsa jichʉ ñʉno yʉ Pʉcʉ sehe mʉsare cahĩna. To ã cahĩchʉ tirore mʉsa sininahca. ");
INSERT INTO gvc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉ Pʉcʉ cahai jiriro jicʉ ahri yahpapʉre tai yʉhʉ. Ã jicʉ mipʉre ahri yahpapʉ jiriro jisinicʉ yʉ Pʉcʉ cahapʉ wahaihca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","To ã nichʉ sã to buheina õ sehe nii: —Mipʉ pinihta quiti marieno durucui noano poto yahui nina mʉhʉ sãre. ");
INSERT INTO gvc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mʉhʉ noano masi pahñoriro mʉ jichʉ mipʉ pinihtare sã masija. Ã jia paina mʉhʉre buhe masierara. Tíre mipʉre sã noano masija. Sã noano masiina jina, Cohamacʉ cahapʉ tariro mʉ jichʉ “Potocã tjira”, nija sã —nii sã Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Sã ã nichʉ Jesu õ sehe ni yʉhtire sãre: —¿Mipʉre “Potocã tjira”, nijari mʉsa jʉna? ");
INSERT INTO gvc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Baharo curero jipihtina mʉsa wʉhʉsepʉ waha siteina jina, yʉhʉre cohãnahca mʉsa. Mʉsa ã cohãpachʉta yʉ Pʉcʉ sehe yʉhʉ mehne jira. Ã jicʉ yʉhʉ cʉ̃irota jieraja. ");
INSERT INTO gvc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ahrire mʉsare yahu mʉhtahi, yʉhʉre mʉsa wacũ tuaa mehne mʉsa noano jihto sehe. Cohamacʉre cahmaeraina cahapʉ mʉsa jichʉ ñano yoaahca mʉsare tina. Ti ã yoapachʉta wahchega mʉsa. Ahri yahpa macaina ñaa buhiri tiinare, ti pʉhtoro watĩno cʉ̃hʉre yʉhdʉrʉcariro jija yʉhʉ. Ã jina yʉhʉre wacũ tuana wahchega mʉsa —nire Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ã ni yahu tuhsʉ Jesu mʉanopʉ ñʉroca mʉo, Cohamacʉre õ sehe ni durucure: —Mai, mipʉre mʉ yahu quihõriro seheta yʉhʉre ñano ti yoahti pja mʉ sʉrota nina. Yʉhʉre mʉ macʉre masare ño payochʉ yoaga. Mʉ ã yoachʉ mʉhʉre masare ño payochʉ yoaihca yʉhʉ cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jipihtina bui pʉhtoro yʉhʉre cũre mʉhʉ. Ã jicʉ yʉhʉre mʉ warinare mʉhʉ mehne ã jirucuchʉ yoaihca yʉhʉ. Tuhsʉ, mʉhʉre masare ño payochʉ yoaihca yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mʉhʉ dihta Cohamacʉ waro jira. Yʉhʉ Jesucristo mʉ warocariro jija. Ã jia jipihtina mʉhʉre masiina, yʉhʉ cʉ̃hʉre masiina mʉanopʉ mari mehne ã jirucuahca —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ã ninota õ sehe ni namore Cohamacʉre: —Ahri yahpapʉre mʉ yoa dutiri cjirire yoa pahñoja yʉhʉ. Ã yoacʉ mʉhʉre masare ño payochʉ yoaja yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ahri yahpa to jihto pano mʉhʉ mehne yʉ jichʉ jipihtina yʉhʉre ti ño payo mʉhtariro seheta mipʉre yʉhʉre ti ño payochʉ yoaga tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ahri yahpai jiinare yʉhʉre mʉ warinare mʉhʉre masichʉ yoahi. Mʉ warina mʉ yaina jira. Ã jicʉ tinare ware mʉhʉ yʉhʉre. Ã jia mʉ dutiare yoare tina. ");
INSERT INTO gvc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Yʉhʉre mʉ yahurire tinare buhehi. Yʉ ã buhechʉ tʉhoa yʉ buheare cahmare tina. Ã jia potocãta mʉ cahai tariro yʉ jichʉ masina tina. Tuhsʉ, mʉ warocariro yʉ jichʉ “Potocã tjira”, ni tʉhotura tina. Ã yoa jipihtia yʉ ya mʉ ya ti jichʉ masina tina. ");
INSERT INTO gvc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ti ya cjihtire mʉhʉre sini payoi nija. Paina ya cjihti sehere sini payoi nieraja yʉhʉ. Yʉhʉre mʉ warina mʉ yaina jira. Ã jicʉ ti ya cjihtire sini payoi nija mʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tina jipihtina mʉ yaina jira. Ã jia mʉ yaina sehe yʉ yaina jira. Yʉhʉre wacũ tuaa yʉ tuariro jiare masichʉ yoara tina masare. ");
INSERT INTO gvc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Mipʉre ahri yahpapʉre tjuasi yʉhʉ. Mʉ cahapʉ wahai tai nija. Yʉ ã wahapachʉta mipʉre yʉhʉre mʉ warina ahri yahpare tjuaahca. Mai, mʉhʉ noariro jira. Yʉhʉre mʉ warinare mʉ tuaa mehne ñʉ wihbobasaga. Mʉ ã ñʉ wihbochʉ mari cʉ̃irota mari jiro seheta tina cʉ̃hʉ cʉ̃ curuata jiahca. ");
INSERT INTO gvc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tina mehne jicʉ mʉ tuaa mehne tinare noano ñʉ wihbohi. Cʉ̃iro pinihta pichacapʉ waharohca mʉ yare ti joari tjui to yahuriro seheta. ");
INSERT INTO gvc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Mipʉre mʉ cahai wahai tai nija. Ã jicʉ ahri yahpai ahri jipihtiare yʉ yainare yahuja yʉhʉ mehne ti noano wahchehto cjihtore. ");
INSERT INTO gvc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉ yare yahuhi tinare. Tina yʉ yoaro seheta ahri yahpai ji dojahtina jierara. Ã jia ahri yahpa macaina sehe tinare ñʉ tuhtira. ");
INSERT INTO gvc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Ahri yahpai jiinare, yʉ yainare naaga”, nieraja. Ã nierapaihta tinare noano ñʉ wihboga “Watĩno ñaare yoa dutiri”, tinare nicʉ. ");
INSERT INTO gvc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ahri yahpa macariro jieraja. Tina cʉ̃hʉ yʉ yoaro seheta ahri yahpai ji dojahtina jierara. ");
INSERT INTO gvc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yʉ yainare mʉ buhea mehne noaina wahachʉ yoaga tinare. Mʉ yahua sehe potocã tjira. ");
INSERT INTO gvc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ahri yahpapʉre yʉhʉre mʉ warocariro seheta yʉhʉ sehe yʉ yaina cʉ̃hʉre mʉ yare buhe duticʉ warocahi. ");
INSERT INTO gvc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mʉ cahmaare yoahtiro cjihtore yariahtiro jicʉ yʉ pjacʉre waja. Ã waja yʉhʉ yʉ yaina cʉ̃hʉ mʉ cahmaare potocã ti noano yoahti cjihtire. ");
INSERT INTO gvc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","’“Yʉ yaina mipʉre jiina dihtare yoadohoga”, ni sini payoeraja yʉhʉ. Yʉ yaina painare yʉ yare ti buheri baharo paina cʉ̃hʉ yʉhʉre wacũ tuaahca. Tina cʉ̃hʉre yoadohoga, yʉ yaina jipihtina cʉ̃ curuai ti jihto cjihto sehe. Yʉhʉ mʉhʉ mehne mari pʉaro jipanahta cʉ̃iro tjija. Mari cʉ̃irota mari jiro seheta tina cʉ̃hʉ mari mehne cʉ̃ curuaihta jijaro. Cʉ̃ curuaita jijaro mʉ warocariro yʉ jiare jipihtina masa “Potocã tjira” ti nihto sehe. ");
INSERT INTO gvc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yʉhʉre mʉ masichʉ yoariro seheta yʉ yainare yʉ jia tiare masichʉ yoai. Tinare yʉ ã masichʉ yoachʉ cʉ̃irota mari jiriro seheta tina cʉ̃hʉ cʉ̃ curuaita jiahca. ");
INSERT INTO gvc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yʉhʉ tina mehne jija. Tuhsʉ, mʉhʉ yʉhʉ mehne jira. Mari ã jiina jichʉ yʉ yaina potocãta cʉ̃ curuaita noano jiahca. Cʉ̃ curuaita ti jichʉ ñʉa mʉ warocariro yʉ jiare ahri yahpa macaina masiahca. Tuhsʉ, yʉhʉre mʉ cahĩriro seheta yʉ yaina cʉ̃hʉre mʉ cahĩare masiahca masa. ");
INSERT INTO gvc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Mai, ahri yahpa to ji dʉcahto pano yʉhʉre cahĩa tire mʉhʉ. Ã cahĩcʉ yʉ masi pahñoriro, si siteriro yʉ jichʉ ñore mʉhʉ. Ã jicʉ yʉhʉre mʉ warina yʉhʉ mehne ti jichʉ cahmaja masi pahñoriro, si siteriro yʉ jichʉ ti masihti cjihtire. ");
INSERT INTO gvc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mai, mʉhʉ noariro jira. Ahri yahpa macaina ñaina mʉhʉre masierara. Yʉhʉ sehe mʉhʉre masija. Ã jia mʉ warocariro yʉ jichʉ masina yʉ yaina. ");
INSERT INTO gvc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉhʉre tinare masichʉ yoai. Baharopʉ cʉ̃hʉre mʉhʉre tinare masichʉ yoaihtja yʉhʉre mʉ cahĩriro seheta painare ti cahĩhti cjihtire. Ã jicʉ yʉ yaina mehne jiihca —nire Jesu Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","To ã niri baharo Jesu sã cʉ̃hʉ to buheina Cedrõ wama tiri mare pahã, olivo wama tia yucʉri ti toari wesepʉ sʉi. ");
INSERT INTO gvc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Payʉ tahari tí wesei, tí yucʉ docai sã Jesu mehne cahmachua tii. Ã jiro Juda Jesure ñʉ tuhtiinare ñohtiro tí wesere masire. ");
INSERT INTO gvc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ã masino pʉa curua surarare mʉ tã tare tí wesepʉ Jesure ñono taro. Cʉ̃ curua surara waro jire. Pa curua surara Cohamacʉ wʉhʉre cohtaina jire. Tina sacerdotea pʉhtoa, fariseo curua macaina ti warocaina jire surara, Cohamacʉ wʉhʉre cohtaina mehne. Ã taa sihãa pocare, sihãa yucʉri cʉ̃hʉre sihã tare. Ti wamoa cʉ̃hʉre cjʉare tina. ");
INSERT INTO gvc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tí wesepʉ ti wihiri baharo Jesu to ñano wahahtore masino, tinare piti boca, õ sehe ni siniture: —¿Noare macana nijari mʉsa? —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesu Nazare macarirore macaja sã —ni yʉhtire tina. —Tiro tjija yʉhʉ —nire Jesu. Juda sehe, Jesure ñaha dutiro ñoriro tina mehne jire. ");
INSERT INTO gvc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ã jia “Tiro tjija yʉhʉ”, Jesu to nichʉta tina sehe cʉaa waha, yahpapʉ du siti mʉa bora caha sʉre. ");
INSERT INTO gvc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ti ã wahachʉ ñʉno tinare pari turi õ sehe ni siniture Jesu: —¿Noare macana nijari mʉsa? —nire. —Jesu Nazare macarirore macana nija sã —ni yʉhtire tina tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—“Tiro tjija”, ni tuhsʉmahicʉ yʉhʉ mʉsare. Ã jina yʉhʉre ñahana, ahrinare yʉhʉ mehne macainare peresu yoaena tjiga mʉsa —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ã sãre cahĩno ne cʉ̃irore butichʉ yoaerare. Ã yoaro tó pano Cohamacʉre to niriro seheta yoaro nire tiro. “Yʉhʉre mʉ warinare ne cʉ̃irore boerahi”, to niriro seheta yoaro nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ã yoa Simo Pedro ñosari pjĩne cjʉaro, tí pjĩne tʉã we naroca, sacerdotea bui pʉhtoro cahamacʉno Malco wama tiriro cahmonore cjã pahrẽnocare. To poto bʉhʉsehe macari cahmonore cjã pahrẽnocare. ");
INSERT INTO gvc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ã to cjã pahrẽchʉ ñʉno Jesu tirore õ sehe nire: —Mʉ ñosari pjĩne wihboga. Yʉ Pʉcʉ yʉhʉre to ñano yʉhdʉ dutiriro seheta ñano yʉhdʉihtja yʉhʉ —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","To ã ni tuhsʉchʉta surara, ti pʉhtoro mehne, Cohamacʉ wʉhʉre cohtaina surara cʉ̃hʉ Jesure ñaha, tirore dʉhtere. ");
INSERT INTO gvc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dʉhte tuhsʉ Ana cahapʉ naa mʉhtare tina. Ana sehe Caifa marechʉno jire. Caifa sehe tí cʉhmare sacerdotea bui pʉhtoro jire. ");
INSERT INTO gvc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“Judio masa ya cjihtire cʉ̃iro masʉno yariachʉ noana”, niriro cjiro jire Caifa sehe. ");
INSERT INTO gvc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ã jina yʉhʉ Simo Pedro mehne Jesure yoa cureropʉ ñʉ nʉnʉ tii. Yʉhʉ sehe sacerdotea bui pʉhtoro to ñʉ masiriro jicʉ Jesu baharo pʉhtoro wʉhʉi jiri sahrĩnopʉ sãa wahai. ");
INSERT INTO gvc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yʉ ã sãachʉ Pedro sehe sahrĩno sopacai tjuarʉcʉ sʉre. Ã jicʉ majare wijaa ta, sopacare cohtaricorore sinitu ñʉi “Ahriro Pedro sãa ta masijari”, nicʉ. Yʉ ã sinitu tuhsʉchʉ ticoro Pedrore sãa ta dutire. To sãa ta dutiri baharo yʉhʉ Pedrore na sãa wahai. ");
INSERT INTO gvc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yʉ ã na sãachʉ ñʉno sopacare cohtaricoro sehe Pedrore õ sehe ni siniture: —¿Jesu buheina mehne macariro jierajari mʉhʉ? —nire ticoro Pedrore. —Jieraja yʉhʉ —ni yʉhtire Pedro sehe. ");
INSERT INTO gvc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sã sʉhto pano tó macaina cahamaca, surara mehne ti sohmahti pichacare wijã tuhsʉri jire. Yʉsʉa nire. Ã jia tina tí pichaca dʉhtʉ cahai ducua, sohmaa nire. Ti ã sohmachʉ ñʉno, Pedro cʉ̃hʉ waha, sohmare. ");
INSERT INTO gvc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ã yoa sacerdotea bui pʉhtoro Jesu buherire, sãre to buheina cʉ̃hʉre sinitu ñʉri jire Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","To ã sinituchʉ Jesu sehe õ sehe ni yʉhtiri jire tirore: —Jipihtinare buhecʉ ti panoi ducuhi. Ã buhecʉ judio masa mari buhea wʉhʉsei Cohamacʉ wʉhʉ cʉ̃hʉre ã buherucuhi. Mʉsa ñʉenoi buherahi yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Dohseacʉ yʉhʉre sinitujari mʉhʉ? Sinitu duacʉ yʉ buheinare sinitu ñʉga. Yʉ buherire tina masina —ni yʉhtiri jire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","To ã nichʉ tʉhoro tói ducuriro surara sehe to wamomaca mehne Jesure cjãri jire. —Ã nii tjiga sacerdotea bui pʉhtorore —niri jire surara sehe Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","To ã nichʉta Jesu õ sehe niri jire: —Ñano yʉ ni durucurire yahuga yʉhʉre. ¿Potocãta mʉsare yʉ yahupachʉta, dohseacʉ yʉhʉre cjãjari mʉhʉ? —niri jire Jesu surarare. ");
INSERT INTO gvc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Baharo Ana Jesure paina ti dʉhterirore Caifa sacerdotea bui pʉhtoro cahapʉ warocari jire. ");
INSERT INTO gvc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ã yoa Simo Pedro pichaca dʉhtʉ cahai ducuro, sohmano nire. Ã to sohmarucuchʉ ñʉa, tó macaina tirore õ sehe ni siniture: —¿Mʉhʉ cʉ̃hʉ Jesu buheina mehne macariro jierajari mʉhʉ? —nire tina Pedrore. —Jieraja yʉhʉ —ni yʉhtire Pedro. ");
INSERT INTO gvc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tuhsʉ, sacerdotea bui pʉhtoro cahamaca mehne macariro, Pedro to cahmono cjã pahrẽriro coyeiro sehe Pedrore õ sehe ni siniture: —¿Jesure ti ñahari wesei yʉ jichʉ mʉhʉ cʉ̃hʉ tiro mehne jierapahte? —ni siniture tiro Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Yʉhʉ tiro mehne jierahi —nire Pedro. To ã nichʉta caraca dure. ");
INSERT INTO gvc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ñamiwacũnu jichʉ Caifa ya wʉhʉpʉ jirina Jesure naa wijaa, tí maca macaina pʉhtoro Pilato ya wʉhʉpʉ naa wahare tina. Ã wahapahta to ya wʉhʉpʉ sãaerare. Pascua dachori jichʉ tina tí bose nʉmʉri macaare chʉhtina jia õ sehe nire: “Judio masʉno jierara Pilato. To ã jiriro jichʉ to ya wʉhʉre sãana, mari dutiare yʉhdʉrʉcana niboca. Ã jina mari sãachʉ marine bose nʉmʉri macaa chʉare chʉ dutierahca”, nire tina. Ã nia pʉhtoro Pilato ya wʉhʉre sãaerare Jesure naahrina sehe. ");
INSERT INTO gvc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ti ã sãa taerachʉ ñʉno Pilato tina cahapʉ, wʉhʉ sopacapʉ sʉrʉcʉ sʉro, tinare õ sehe ni siniture: —¿Yaba buhirire ahrirore yahusã duajari mʉsa? —nire Pilato tinare. ");
INSERT INTO gvc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Ahriro to noariro jichʉ mʉhʉre sã waeraboa. Ñariro jira tiro —ni yʉhtire tina. ");
INSERT INTO gvc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ti ã nichʉ Pilato õ sehe nire: —Mʉsa sehe tirore naahga. Ã jina mʉsa ya dutia ti niriro seheta tirore buhiri dahrega —nire Pilato tinare. —Mʉsa Roma macaina ya dutia sehe sãre masʉnore wajã dutierara —nire tina Pilatore. ");
INSERT INTO gvc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ã nia Jesure judio masa ti wajã duarire masichʉ yoaa nire. Jesu sehe crusapʉ to yariahtore tó pano to yahuriro seheta ã waharo nire. ");
INSERT INTO gvc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ti ã ni durucuri baharo Pilato sehe wʉhʉpʉ majare sãa, Jesure pjirocari jire. Pjiroca tuhsʉ, tirore õ sehe ni sinituri jire: —¿Judio masa ti pʉhtoro tjijari mʉhʉ? —ni sinituri jire Pilato. ");
INSERT INTO gvc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—¿Mʉ mʉ sʉrota ã sinitui nijari mʉhʉ yʉhʉre? ¿O paina sehe yʉhʉre ti yahusãri baharo tíre sinitu ñʉjari mʉhʉ? —niri jire Jesu Pilatore. ");
INSERT INTO gvc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Judio masʉno jieraja yʉhʉ. Mʉ ya yahpa macaina, sacerdotea pʉhtoa cʉ̃hʉ mʉhʉre ware sãre. ¿Yabare ñano yoari mʉhʉ ti ã buhiri dahre duachʉ? —niri jire Pilato. ");
INSERT INTO gvc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Ahri yahpa macariro pʉhtoro jieraja yʉhʉ. Ahri yahpa macariro pʉhtoro yʉ jichʉ yʉ buheina yʉhʉre yoadohoboa. Judio masare yʉhʉre ñaha dutieraboa. Yʉ pʉhtoro jia ahri yahpa macaa jierara —niri jire Jesu Pilatore. ");
INSERT INTO gvc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿Ã jicʉ pʉhtoro jijari mʉhʉ ã nicʉ? —niri jire Pilato. —Mʉ nino seheta pʉhtoro tjija. Masa ti pʉhtoro jihtiro cjihto masa bajuai yʉhʉ. Ã jicʉ ahri yahpapʉ tai ti pʉhtoro jicʉ tacʉ, potocã jiare yahucʉ tacʉ. Jipihtina potocã jiare tʉho duaina, yʉ yahuare tʉhora —niri jire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Yaba baro jijari potocã jia? Potocã jiare masihto basioerara —niri jire Pilato. Ã ni tuhsʉ Pilato judio masa cahai majare tjua waha, tinare õ sehe ni yahure: —Ahriro Jesure yaba buhiri mariahna. ");
INSERT INTO gvc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Cʉhmaripe pascua jichʉ cʉ̃iro peresui jirirore mʉsa wio dutirucura. ¿Ã jicʉ ahriro Jesureta mʉsa pʉhtoro cjihto mʉsare wiobasabocari yʉhʉ? —nire Pilato judio masare. ");
INSERT INTO gvc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","To ã nichʉ tʉhoa judio masa õ sehe ni sañurucure: —Tirore wioi tjiga. Barrabá sehere sãre wiobasaga —ni sañurucure judio masa Pilatore. Barraba sehe yaca bʉcʉro jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ti ã ni sañurucuri baharo Pilato Jesure tjana dutiri jire. To ã dutichʉ to mʉa sehe tirore tjanari jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tjana tuhsʉ tina pota soro dahre tuhsʉ, Jesu dapu bui duhu payori jire. Duhu payo tuhsʉ, pʉhtoa ya suhti barore tirore sãa, payʉ tahari tiro cahacãi sʉrʉca, õ sehe ni bʉjʉperi jire tina: ");
INSERT INTO gvc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—Noano tagã. Judio masa pʉhtoro noano tagã —ni bʉjʉpe, Jesu wʉhdʉahi cjã mʉjari jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ã yoa pari turi Pilato judio masa cahapʉ waha, tinare õ sehe ni yahure: —Tʉhoga mʉsa. Ahrirore ñaa buhiri mariahna. Ã jicʉ tíre mʉsa masihti cjihtire mʉsa cahai tirore na tai tai nihi —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","To ã ni tuhsʉchʉta Jesu pota soro pisariro, pʉhtoa ya suhti barore sãariro, wʉhʉi jiriro wijaa tare. To ã wijaa tachʉ Pilato tinare õ sehe nire: —Ñʉga. Ahriro tjira tiro —nire Pilato. ");
INSERT INTO gvc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","To ã ni tuhsʉchʉ tʉhoa, sacerdotea pʉhtoa, Cohamacʉ wʉhʉ cohtaina surara cʉ̃hʉ Jesure ñʉa, sañurucure: —Crusapʉ cjã puha wajãga tirore. Crusapʉ cjã puha wajãga tirore —ni sañurucure tina. —Tirore ne ñaa buhiri mariahna. Ã jina mʉsa basita tirore naaga. Ã jina mʉsata tirore crusapʉ cjã puha wajãga —nire Pilato tinare. ");
INSERT INTO gvc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—Tiro to basi “Cohamacʉ macʉno jija”, nia tire. Tíre to ã nichʉ sã dutia sehe tirore wajã dutira —nire tina Pilatore. ");
INSERT INTO gvc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ti ã nichʉ tʉhoro tó pano to cuiriro yʉhdoro cuia wahare Pilato sehe. ");
INSERT INTO gvc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ã jiro pari turi to wʉhʉpʉre majare sãa, Jesure õ sehe ni sinituri jire tjoa: —¿Noho macariro jijari mʉhʉ? —niri jire Pilato Jesure. To ã ni sinitupachʉta Jesu tirore yʉhtierari jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","To ã yʉhtierachʉ ñʉno Pilato tirore õ sehe ni sinitu namori jire: —¿Yʉhʉre yʉhtierajari mʉhʉ? Yʉhʉ mʉhʉre peresui jirirore wio masija. Ã yoa mʉhʉre crusapʉ cjã puha wajã duti masija yʉhʉ. ¿Tíre masierajari mʉhʉ? —niri jire Pilato Jesure. ");
INSERT INTO gvc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Cohamacʉ mʉhʉre to dutierachʉ yʉhʉre ñano yoape dutieraboa mʉhʉ. Yʉhʉre ñʉ tuhtiinare ñoriro sehe mʉ yʉhdoro ñano buhiri tira —niri jire Jesu Pilatore. ");
INSERT INTO gvc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","To ã nichʉ tʉhoro Pilato sehe tirore wio duari jimare. To ã wio duapachʉta pari turi judio masa õ sehe ni sañurucure: —Jesu “Pʉhtoro jija” nino, mari jipihtina bui pʉhtoro jirirore Roma macarirore ñʉ tuhtiriro jira tiro. Ã jicʉ tirore wiocʉ mʉhʉ cʉ̃hʉ mari bui pʉhtoro jirirore ñʉ tuhtiriro jiihca —ni sañurucure judio masa Pilatore. ");
INSERT INTO gvc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ti ã nichʉ tʉhoro Jesure wʉhʉi jirirore na wijaa ta, buhiri dahre dutiro taro to dujiri pahtai nuju sʉre Pilato sehe. Tói to buhiri dahre dutiri wapa, tãa mehne ti yoari wapa judio masa sã ya mehne Gabatá wama tire. ");
INSERT INTO gvc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tí dacho pascua dacho bose nʉmʉ sã chʉhti cjihtire sã cahnori dacho jire. Tí pjare cohari pja waro jire. Nuju sʉ tuhsʉ Pilato masare õ sehe ni yahure: —Ahriro tjira mʉsa pʉhtoro —nire tiro. ");
INSERT INTO gvc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","To ã nichʉ tʉhoa judio masa õ sehe ni sañurucure: —Yariajaro tiro. Yariajaro tiro. Crusapʉ cjã puha wajãga tirore —ni sañurucure tina. —¿Mʉsa pʉhtoro to jipachʉta tirore crusapʉ cjã puha wajã dutijari mʉsa? —nire Pilato. To ã nichʉ tʉhoa õ sehe ni yʉhtire sacerdotea pʉhtoa: —Mari jipihtina bui pʉhtoro Roma macarirota sã pʉhtoro jira. Pairo pʉhtoro sãre mariahna —ni yʉhtire sacerdotea pʉhtoa. ");
INSERT INTO gvc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ti ã ni durucuri baharo Pilato Jesure crusapʉ cjã puha wajã dutiro, tirore ware tinare, tirore wajãhtinare. ");
INSERT INTO gvc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ã jia tina Jesure naa wijaare. Ti naa wijaachʉ Jesu sehe to crusare to basi wʉa naa, dapu cohã wama tiropʉ sʉre. Sã judio masa ya mehne dapu cohã Gólgota wama tire. ");
INSERT INTO gvc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tópʉ sʉa tina Jesure cjã puha õre. Tuhsʉ, paina pʉarore cʉ̃iro to poto bʉhʉsehei, pairo to cõ bʉhʉsehei cjã puha dapore tina. Ã jiro Jesu ti dacho macai jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ti cjã puha tuhsʉchʉ, Pilato taboa pjĩne joa, Jesure ti cjã puha õri crusai cjã puha õ dutire tí pjĩne. Õ sehe ni joare tiro: “Ahriro Jesu Nazare macariro, judio masa bui pʉhtoro jira”, ni joare Pilato tí pjĩne. ");
INSERT INTO gvc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tí pjĩne joaro judio masa ya dʉsero mehne, Roma macaina ya dʉsero mehne, griego masa ya dʉsero mehne joare tiro. Ã yoa Jesure crusapʉ ti cjã puha daporiro maca cahacãi jire. Tó cahacãi jiina payʉ judio masa Pilato joarire ñʉ, buhere. ");
INSERT INTO gvc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ã buhe tuhsʉ judio masa sã sacerdotea pʉhtoa õ sehe nire Pilatore: —“Ahriro judio masa pʉhtoro jira”, ni joai tjiga. Sã pʉhtoro jierara ahriro. Ã jicʉ õ sehe ni joa cahnoga mʉhʉ. “Ahriro ‘Judio masa pʉhtoro jija’, ni cʉ̃irota to basita ã ni tʉhoturiro jira”, ni joa cahnoga —nire sacerdotea pʉhtoa. ");
INSERT INTO gvc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Yʉ joa mʉhtariro seheta jirohca —nire Pilato tinare. ");
INSERT INTO gvc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesure ti cjã puhari baharo pititiaro surara sehe Jesu suhtire ti basi witire. Ti ã witi duapachʉta cʉ̃ suhtirota yoari suhtiro dohori marieni suhtiro jire. Tí suhtiro suhari suhtiro jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tí suhtiro to ã jichʉ õ sehe nire tina ti basi: —Ahri suhtirore tʉhrẽna tjijihna. Ahri suhtirore nahtiro cjihtore masi duana, docapejihna mari —nire tina ti basi. Ã docapea, Cohamacʉ yare ti joari tjui ti ni joariro seheta yoaa nire tina. “Yʉ suhtire tina ti basi witire. Ã jia yʉ suhtire nahtiro cjihtore masi duaa, docapere tina”, ni joaa tiha Cohamacʉ yare ti joari tjui. To ã ni joariro seheta ã yoaa nire tina. ");
INSERT INTO gvc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Surara ti ã yoachʉ Jesu pocoro, Jesu mʉono, María Cleofa namono, María Magdalena mehne Jesu crusa cahacãi ñʉrucure tina. ");
INSERT INTO gvc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ã jiro to pocoro yʉhʉ to cahĩriro cʉ̃hʉ to cahacãi sã ducuchʉ ñʉno to pocorore õ sehe ni yahure Jesu: —Mipʉre ahriro mʉ macʉ cjihto jira —nire Jesu to pocorore. ");
INSERT INTO gvc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ã ni tuhsʉ, yʉhʉre õ sehe ni yahure tiro: —Mipʉre ahricoro mʉ poco cjihto jira —nire Jesu yʉhʉre. To ã niri baharo Jesu pocorore yʉ ya wʉhʉpʉ ji dutii. ");
INSERT INTO gvc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","To ã ni yahuri baharo õ sehe ni tʉhotu masiri jire Jesu: “Jipihtia Cohamacʉ yʉhʉre dahra dutiro to cũrire yoa pahñohi”, ni tʉhotu masiri jire Jesu. Ã masino Cohamacʉ yare ti joari tjui to ni yahuriro seheta õ sehe nire Jesu: —Ñahma yapioca yʉhʉre —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ã yoa tói vino sʉẽa core posa tiri situ dujire. Ã jiro tói jiriro wihmi nari sʉhtere sʉẽa co mehne ti sohari sʉhtere yucʉcʉ hisopo wama tidʉ sohtoai dʉhte õre. Dʉhte õ tuhsʉ, Jesu dʉseroi siõ mʉo, siõ õre. ");
INSERT INTO gvc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tí core Jesu wihmi tuhsʉ õ sehe nire: —Tó puro tjica —ninota to dapure muhrirʉca, yoja sʉ, yariaa wahare. ");
INSERT INTO gvc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tí dacho pascua bose nʉmʉ pano jire. Tí bose nʉmʉ macaare sã chʉhti cjihtire sã cahnori nʉmʉ jire. Ã jia pa dacho Sabado jichʉ tí bose nʉmʉ jichʉ crusaripʉ ti wajãrinare cũ duaerare judio masa. Tí dacho Cohamacʉre ti ño payori dacho bose nʉmʉ jire. Ã jia tí dachoi ti cjã puharina cjirire crusapʉ ti jichʉ cahmaerare tina. Ã jia ti cjã puharina cjirire ti ñʉchʉa cohãrine cjã nuha dutia taa judio masa siniha Pilatore, ti yaria mʉrocahto cjihto sehe. Ti ã yoari baharo ti pjacʉri cjirire na boro bahrañoa taa nire. ");
INSERT INTO gvc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ti ã dutichʉ surara sehe crusari cahapʉ sʉ, cʉ̃iro yacariro cjiro ñʉchʉa cohãrine cjã nuhare. Pairo cʉ̃hʉre ãta yoare tina. ");
INSERT INTO gvc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ã jia Jesu ñʉchʉa cohãrine cjã nuha tamaa, to yariariro jichʉ ñʉa, cjã nuhaerare. ");
INSERT INTO gvc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ã cjã nuhaeraa cʉ̃iro surara to patipahma batoi ñosadʉ mehne ñosare. To ã ñosachʉ dóihta to di, co mehne wijaare. ");
INSERT INTO gvc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","To ã wahachʉ ñʉi yʉhʉ. Yʉhʉ ahri tjure joariro mʉsare potocã yahuja. Potocã yʉ yahua jichʉ masija yʉhʉ. Mʉsare yahuja mʉsa cʉ̃hʉ Jesure mʉsa wacũ tuahto sehe. ");
INSERT INTO gvc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cohamacʉ yare ti joari tju to niriro seheta ã wahare: “To cohãrine ne cʉ̃ cohãre cjã nuhaerare”, to ni joariro seheta Jesu ñʉchʉa cohãrine ne cʉ̃ cohãre cjã nuhaerare. ");
INSERT INTO gvc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ã yoa pa tju Cohamacʉ yare ti joari tjui õ sehe nina: “Tirore ti ñosariro cjirore ñʉahca tina”, ni joaa tiha Cohamacʉ yare ti joari tjui. ");
INSERT INTO gvc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","To yariari baharo José Arimatea macariro Jesu pjacʉ cjirore na bororo taro, Pilatore siniri jire. José sehe paina judio masare cuiro, Jesure wacũ tuariro to jiare yahu duaerari jire. To pjacʉ cjirore to siniri baharo Pilato sehe to pjacʉre naa dutiri jire. To ã na dutichʉ José crusa cahai sʉ, Jesu pjacʉ cjirore naa wahari jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo cʉ̃hʉ me sitiare yucʉcʉ di pohca, mirra wama tia me sitia yucʉcʉ pohca mehne dahra moreare na tari jire. Jesu pjacʉ cjirore masa copapʉ ti siõ sãahto pano ti cahnohti jiri jire tí me sitia. Ti na tari cjiri treinta kilo nʉcʉri jire. Nicodemo sohõ jiri pja Jesu mehne to coã durucuri pja ñamipʉ Jesu cahai sʉriro jiri jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ã jia tina pʉaro Jesu pjacʉ cjirore naa, judio masa sã yariainare sã yoarucuriro seheta to pjacʉ cjirore me sitia mehne suhtiro cahsaro mehne wahmari jire. ");
INSERT INTO gvc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Crusapʉ Jesure ti wajãno cahai wese jire. Tí wesepʉ masa copa tãcapʉ wahma ti sahari copa jire. Tí copai ne yariariro cjirore siõ sãaerasinire. ");
INSERT INTO gvc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pascua dacho bose nʉmʉi judio masa sã bose nʉmʉi sã chʉhti cjihtire sã cahnori dacho jire. To ã jiri dacho jichʉ tí copa cahacãi to crusa jichʉ, tói siõ sãari jire tina Jesu pjacʉ cjirore. ");
INSERT INTO gvc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo ñami curero jichʉ, bohreahto panocã María Magdalena Jesu masa copapʉ sʉri jire. Tópʉ sʉro tí copare ti tju bihari tãcare ti pjõo cũria tãcare ñʉri jire ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ã ñʉricoro jiro sã cahapʉ mʉrocaa tare ticoro. Simo Pedro mehne yʉhʉ sã pʉaro jii. Wihi, õ sehe ni yahure sãre ticoro: —Mari pʉhtoro pjacʉ cjirore naanocari jihre. Ã jina tiro cjirore ti cũrire mari masieraja —nire ticoro sãre. ");
INSERT INTO gvc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","To ã nichʉ tʉhona, Pedro mehne masa copapʉ ñʉna wahai sã. ");
INSERT INTO gvc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ã ñʉna wahana sã pʉaro mʉroca wahcãi. Ã mʉrocana, yʉhʉ Pedrore mʉroca yʉhdʉ wahcãcʉ masa copapʉ sʉ mʉhtai. ");
INSERT INTO gvc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tópʉ sʉcʉ muhri caha ñʉroca sõi tí copapʉre. Muhri caha ñʉroca sõcʉ tirore ti wahmari suhtiro cjiro dihtare ñʉi. Ã jii tí copare sãaerahi. ");
INSERT INTO gvc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yʉ ã ñʉri baharopʉ Simo Pedro yʉ baharo wihire. Wihi, masa copapʉ sãa, to pjacʉ cjirore ti wahmari suhtiro cjirore ñʉre tiro. ");
INSERT INTO gvc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesu dapure ti wahmari cahsaro cʉ̃hʉre ñʉre tjoa. Tí cahsaro soro coãno to turẽri cahsaro jire. ");
INSERT INTO gvc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ã jicʉ yʉhʉ cʉ̃hʉ masa copapʉ sʉ mʉhtariro tí copapʉ sãai. Jesure to ã mariachʉ ñʉcʉ “Potocãta Jesu masa wijaari jira”, ni tʉhotui yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tí copapʉ sã wahahto pano Cohamacʉ yare ti joari tjui Cristo to yariahtore yahurire, to masa wijaahtore yahuri cʉ̃hʉre sã noano tʉho ñahaerasinimai. Tí copare yʉ ñʉri baharo, “Potocãta Jesu masa wijaari jira”, ni tʉhotui yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ã ñʉ tuhsʉna sã wʉhʉsepʉ tjuaa wahai. ");
INSERT INTO gvc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ã yoa masa copapʉ María majare tjua ta tí copa sopacapʉ wihi, ducuro, tiiro niri jire. Ã tiiparota ticoro muhri caha ñʉroca sõri jire masa copapʉre. ");
INSERT INTO gvc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ã ñʉroca sõno pʉaro anjoare, yehsea suhti tiinare Jesu cjiro to coãriro cjiropʉ ti dujichʉ ñʉri jire ticoro. Cʉ̃iro to dapu coãriro cjiroi dujiri jire. Pairo to dahpori coãriro cjiroi dujiri jire. ");
INSERT INTO gvc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tinare to ñʉchʉ tina sehe ticorore õ sehe ni sinituri jire: —Numino, ¿dohse jiro baro tiico nijari mʉhʉ? —niri jire tina. —Yʉ pʉhtoro pjacʉ cjirore naanocari jihre. Ã jico to pjacʉ cjirore ti cũrire masieraja yʉhʉ —niri jire ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ã ni tuhsʉ, majarerʉcʉ sʉmahno Jesure tói ducurirore ñʉri jire ticoro. Ã ñʉparota Jesure ñʉ masierari jire ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—Numino, ¿dohse jiro baro tiico nijari mʉhʉ? ¿Noare macaco nijari? —niri jire Jesu ticorore. “Ahriro ahri wesere ñʉ wihboriro jira”, ni tʉhotumari jire ticoro Jesure. Ã ni tʉhoturo, õ sehe niri jire ticoro: —Mʉhʉta to pjacʉ cjirore naariro jicʉ to pjacʉre mʉ cũrirore yahuga yʉhʉre. Mʉ yahuri baharo to pjacʉ cjirore naaco wahacohtja —niri jire ticoro tirore. ");
INSERT INTO gvc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","To ã niri baharo Jesu õ sehe niri jire: —María —niri jire. To ã ni pisuchʉ tʉhoro majare ñʉroca, ticoro hebreo ya mehne sã judio masa ya mehne õ sehe niri jire: —Raboni —niri jire ticoro Jesure. (Raboni nino “Buheriro”, nino nina.) ");
INSERT INTO gvc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Yʉ Pʉcʉ cahapʉ mʉjaerasinija yʉhʉ. Yʉ ã mʉjaerasinichʉ yʉhʉre ñahaeco tjiga. Tuhsʉ, paina yʉ yaina cahapʉ wahaga. Ti cahapʉ sʉco õ sehe ni yahuga tinare: “ ‘Yʉ Pʉcʉ cahapʉ wahai tai nija. Mʉsa Pʉcʉ cʉ̃hʉ jira tiro. Yʉ yairo Cohamacʉ cahapʉ wahai tai nija. Mʉsa yairo Cohamacʉ cʉ̃hʉ jira tiro’, nihre Jesu”, ni yahuga tinare —niri jire Jesu Maríare. ");
INSERT INTO gvc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","To ã niri baharo María Magdalena sã Jesu buheina cahapʉ wihi, yahure sãre: —Mari pʉhtorore ñʉhi yʉhʉ —ni, Jesu ticorore to yahu dutirire yahure sãre ticoro. ");
INSERT INTO gvc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tí dacho domingoi ñamichahai sã Jesu buheina sã coyea judio masare cuina, wʉhʉpʉ biha sãa, dujii sã. Sã ã dujichʉ Jesu sã watoi bajuarʉcʉ sʉro, sãre õ sehe nire: —¿Jimajari mʉsa? Noano jiga mʉsa —nire. ");
INSERT INTO gvc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ã ni tuhsʉ, to wamomacarine, to patipahma bato cʉ̃hʉre sãre ñore. Ã jina sã tirore sã pʉhtorore ñʉna, wahchei. ");
INSERT INTO gvc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pari turi Jesu sãre õ sehe nire: —Noano jiga mʉsa. Yʉ Pʉcʉ yʉhʉre to warocariro seheta, mʉsa cʉ̃hʉre yʉ ya buheare buhehtinare warocaja —nire Jesu sãre. ");
INSERT INTO gvc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ã ni tuhsʉ tiro sãre puti sãare. Ã puti sãano Espíritu Santo sãre to sãarʉcʉ sʉ mʉa wahahtore ñono nire sãre. Ño tuhsʉ õ sehe nire: —Mipʉ Espíritu Santore ñahaga mʉsa, mʉsa mehne jihtirore. ");
INSERT INTO gvc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Paina ti ñaa yoarire mʉsa bochʉ, ãta jiahca. Ã jia paina ti ñaa yoarire mʉsa boerachʉ tí bori jisi —nire Jesu sãre to buheinare. ");
INSERT INTO gvc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesu sã watoi to bajuachʉ Toma sʉhdʉariro ti ni pisuriro sã mehne mariahre. ");
INSERT INTO gvc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","To ã mariachʉ sã mehne macaina tirore yahumare: —Mari pʉhtorore sã ñʉhi —ni yahumai sã Tomare. Sã ã ni yahupachʉta õ sehe nire Toma: —To wamomacarine ti cjã puhaa coparire ñʉeracʉ tí coparire yʉ wamo pica mehne be ñʉeracʉ, “Potocãta masa wijaari jira”, nisi yʉhʉ. Ã yoa to patipahma batoi jiri copare yʉ wamomaca mehne siõ sõeracʉ, “Potocãta masa wijaari jira”, nisi yʉhʉ tirore —nire Toma. ");
INSERT INTO gvc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho dachori baharo pari turi sã to buheina sã wʉhʉpʉ jii. Tí pjare Toma sã mehne jire jʉna. Tí wʉhʉ bihari wʉhʉ jire. Bihari wʉhʉ to jipachʉta Jesu wʉhʉpʉ sãa taro, sã watoi bajuarʉcʉ sʉro õ sehe nire: —¿Jimajari mʉsa? Noano jiga —nire. ");
INSERT INTO gvc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ã ni tuhsʉ, tiro Tomare õ sehe ni yahure: —Ñʉga yʉ wamomacarine. Ã yoa mʉ wamo pica mehne yʉ wamomacarine ti cjã puhaa coparire be ñʉga. Tuhsʉ, mʉ wamomaca mehne yʉ patipahma batoi jiri copare siõ sõ ñʉga. “Potocã jierara”, nii tjiga. “Potocã tjira”, niga mʉhʉ, —nire Jesu Tomare. ");
INSERT INTO gvc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","To ã niri baharo Toma õ sehe ni yʉhtire: —Mʉhʉ yʉ pʉhtoro jira. Mʉhʉ yʉ yairo Cohamacʉ jira —nire Toma Jesure jʉna. ");
INSERT INTO gvc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—Yʉhʉre mʉ ñʉri baharo yʉhʉre wacũ tuara mʉhʉ. Paina sehe yʉhʉre ñʉerapahta yʉhʉre wacũ tuaahca. Ã jia tina mʉ yʉhdoro wahcheahca —nire Jesu Tomare. ");
INSERT INTO gvc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ã yoa payʉ paye cʉ̃hʉre Cohamacʉ to tuaa mehne yoa ñore Jesu sã mehne jiro. Tíre to yoarire ahri tjui joa pahñoerati yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ã joa pahñoerapaihta ahri tjui yʉ yahuare joahi “Jesuta Cristo Cohamacʉ to warocariro jira. Tiro potocãta Cohamacʉ macʉno jira”, mʉsa ni masihti cjihtire. Ã jina mʉsa tirore wacũ tuaina Cohamacʉ mehne mʉsa ã jirucuhti cjihtire joahi ahri tjure. ");
INSERT INTO gvc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baharo Tiberia wama tiri bʉcʉpariro dʉhtʉ cahai sãre to buheinare Jesu pari turi bajuare tjoa. Sãre bajuaro õ sehe yoare tiro tjoa. ");
INSERT INTO gvc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo Pedro, Toma sʉhdʉariro ti niriro, Natanae Galilea yahpai jiri maca Caná wama tiri maca macariro, Zebedeo pohna sã pʉaro, paina pʉaro buheina sã õpeinata cahmachui. ");
INSERT INTO gvc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sã ã cahmachuri baharo Simo Pedro sãre õ sehe nire: —Wahi wajãi wahai nija —nire tiro. —Sã cʉ̃hʉ mʉhʉ mehne wahanahtja —nii sã tirore. Ã ni tuhsʉ buhaa wahai. Ã jina dohoria mehne wahai. Wiho mejeta tí ñamine sã noano maca bohreapanahta ne cʉ̃iro wahi wajãerahi. ");
INSERT INTO gvc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bohrea parĩ cahachʉ Jesu padʉroi to ducuchʉ tirore ñʉmai sã. Ã ñʉpanahta tirore “Jesu jira”, ni ñʉ masierahi sã. ");
INSERT INTO gvc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ã jiro sãre tiro õ sehe ni siniture: —¿Ne, wahi wajãri mʉsa? —nire Jesu. —Ne wajãeraputiati sã —ni yʉhtii sã. ");
INSERT INTO gvc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Dohoria poto bʉhʉsehe sehe doca ñoga. Tie sehe doca ñona wahi wajãnahca mʉsa —nire sãre. To ã nichʉ tʉhona sã to niriroihta doca ñoi. Sã doca ño tuhsʉchʉ payʉ wahi sãare. Payʉ wahi sãachʉ wañʉnore dohoriapʉ waja sãana bihoerahi sã. ");
INSERT INTO gvc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ã jicʉ yʉhʉ Jesu cahĩriro Pedrore õ sehe ni yahui: —Mari pʉhtorota jira siro padʉroi ducuriro —nii Pedrore. Yʉ ã nichʉ tʉhoro Jesuta to jichʉ masino, Simo Pedro to suhtirore sãare. Wahi wajãno taro to suhtirore tjuweriro jisinire. To suhtirore sãa tuhsʉ, diapʉ pjuroca ñojare. ");
INSERT INTO gvc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sã paina buheina dohoriai jina, cien metro yoaro diapʉre pahsai sã. Ã jina wañʉnore wahi payʉ sãadʉre dohoria mehne waja nʉjai sã. ");
INSERT INTO gvc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dʉhtʉ cahai wahã sʉna pichaca niti dihta si coãri pichaca bui Jesu to pʉhõ cũrirore wahire ñʉi sã. Pão cʉ̃hʉre ñʉi sã. ");
INSERT INTO gvc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sã ã ñʉchʉ ñʉno Jesu sãre õ sehe nire: —Michapucacã mʉsa wajãrinare mahainacã na tahga —nire sãre. ");
INSERT INTO gvc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","To ã nichʉ Simo Pedro sehe Jesu mehne jiriro dohoriapʉ samu, wañʉnore, bʉjʉina wahi ciento cincuenta y tres wahi sãadʉre waja majare. Payʉ wahi sãapahta wañʉnore tʉhrẽrare. ");
INSERT INTO gvc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—Chʉsinina taga —nire Jesu sãre. “¿Noa baro jijari mʉhʉ?” ni sinitu ñʉerahi sã tirore. Sã pʉhtoro to jichʉ masii sã. ");
INSERT INTO gvc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ã yoa Jesu pichaca cahapʉ sʉro, pãore na, sãre witire. Wahi cʉ̃hʉre witire. ");
INSERT INTO gvc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ã jiro Jesu to masa wijaari baharo padʉroi bajuaro tia taha sãre to buheinare bajuaro nire. ");
INSERT INTO gvc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Sã chʉri baharo Jesu Simo Pedrore õ sehe ni siniture: —Simo Jona macʉno, ¿ahrinare mʉ cahĩriro yʉhdoro yʉhʉre cahĩjari mʉhʉ? —nire Simo Pedrore. —Pʉhtoro, mʉhʉre cahĩja yʉhʉ. Mʉhʉre yʉ cahĩchʉ masina mʉhʉ —ni yʉhtire Simo Pedro. —Ã jicʉ ovejacãre ti nuriro seheta yʉ yainare buhega mʉhʉ —nire Jesu. ");
INSERT INTO gvc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ã ni tuhsʉ pari turi tiro Simo Pedrore õ sehe ni siniture: —Simo Jona macʉno, ¿yʉhʉre cahĩjari mʉhʉ? —nire Jesu. —Pʉhtoro, mʉhʉre cahĩja yʉhʉ. Mʉhʉre yʉ cahĩchʉ masina mʉhʉ —ni yʉhtire Simo Pedro. —Ovejare ñʉ wihboriro ovejare to noano ñʉ wihboriro seheta, yʉ yainare noano buhe ñʉ wihboga —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ã ni tuhsʉ pari turi tiro Simo Pedrore õ sehe ni siniture: —Simo Jona macʉno, ¿potocãta yʉhʉre cahĩjari mʉhʉ? —nire Jesu tjoa. Tia taha ã ni to sinituchʉ tʉhoro Simo Pedro tuaro cahyare. —Pʉhtoro, mʉhʉ masi pahñona. Mʉhʉre yʉ cahĩchʉ masina mʉhʉ —ni yʉhtire Simo Pedro. —Ovejare ti nuriro seheta yʉ yainare buhega mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Potocã mʉhʉre niita nija. Mʉhʉ wahmʉno jicʉ mʉ suhtire sãa, mʉ cahmariropʉ tinia tiri jire mʉhʉ. Ã jiricʉ mʉ jipachʉta baharo mʉ bʉcʉro jichʉ, mʉ wamomacarine mʉ siõrocachʉ pairo mʉhʉre suhtire sãanohca. Tuhsʉ, mʉ waha duaeraropʉ mʉhʉre naanohca —nire Jesu Simo Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ã nino Simo Pedrore dohse waha to yariahtore yahuro nire. Ã jiro Simo Pedro yariaro Cohamacʉre “Noariro, masi pahñoriro jira”, masa ti nichʉ to yoahtore yahuro nire Jesu. Ã Pedro mehne sʉhʉdu tuhsʉro õ sehe ni namore Jesu tirore: —Quihõno yʉ buheriro seheta yoaga mʉhʉ —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","To ã nichʉta Pedro sehe majare ñʉroca, yʉhʉre Joãore Jesu to cahĩriro buherirore tinare yʉ nʉnʉ tichʉ ñʉno Pedro Jesure siniture. Yʉhʉ sehe to ñʉriro tó pano õ sehe niriro jii: “Pʉhtoro, ¿mʉhʉre ñʉ tuhtiinare ñohtiro sehe diro baro jicari tiro?” ni, Jesure sinitu ñʉriro jii yʉhʉ. Tí pjare Jesu to pari wahpa chʉ dujii yʉhʉ sehe. ");
INSERT INTO gvc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ã jiro yʉhʉre ñʉno Pedro Jesure õ sehe ni siniture: —Pʉhtoro, ¿ahriro sehe dohse waharohcari? —ni siniture. ");
INSERT INTO gvc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Tíre mʉhʉre yahueraja. Ahri yahpapʉ yʉ tjua tahto pano ahrirore jirucuchʉ yʉ yoachʉ tíre masierara mʉhʉ. Ã jicʉ mʉhʉre yahueraja. Quihõno yʉ buheriro seheta yoaga mʉhʉ —nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tíre to yahurire jipihtina Jesu yaina ti basi yahu sitemare. Tíre yahu sitea õ sehe nimare tina sehe: “Jesu to cahĩriro buheriro yariasi”, ni yahu sitemare yʉhʉre Jesu yaina ti basi. Ti ã nipachʉta “Tiro yariasi”, nino nierari jimare Jesu. “Ahri yahpapʉ yʉ tjua tahto pano ahrirore jirucuchʉ yʉ yoachʉ tíre masierara mʉhʉ. Ã jicʉ mʉhʉre yahueraja”, nire Jesu Pedrore. ");
INSERT INTO gvc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesu buheriro ahrire yahuriro, ahri tjure joariro jija yʉhʉ. Ã jina ahri yʉ yahua quihõno jichʉ masija mari. ");
INSERT INTO gvc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Payʉ paye cʉ̃hʉre Jesu yoare. To yoarire mari joa pahñochʉ tí tjuri joaa tjuri payʉbia wahaboa. Ã jia tí tjurire mari wihbochʉ mʉ sʉeraboa ahri yahpa. Wahpaa yʉhdʉa wahaboa, yʉ tʉhotuchʉ. Tó puro tjira.");
INSERT INTO gvc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teofilo, ahri quitire mʉhʉre joarocai nija. Pano yʉ joa mʉhtari pũre Jesu to yoaare, to buheare mʉhʉre yahu tuhsʉi. Pʉ mʉanopʉ to mʉjarire yahu batoai. To mʉjahto pano Jesu Espíritu Santo mehne dutiha to bese cũrinare. ");
INSERT INTO gvc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ã yoa Jesu crusapʉ to yariari baharo payʉ tahari pjacʉ tiriro bajua mʉjaha to cũrinare, tina “Potocãta tiro catira”, ti ni masihto sehe. Cuarenta dachori waro tiro bajua mʉjaha tinare. Ã bajuaro tiro to basi to catiriro jiare ñono niha tinare. Ã bajuaro pʉhtoro Cohamacʉ to sʉho jiare yahuha tinare. ");
INSERT INTO gvc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesu to cũrina mehne jisinino tinare õ sehe ni yahuha: —Jerusalẽita jisiniga mipʉre. “Espíritu Santore mʉsare warocaihtja”, yʉ Pʉcʉ to nirirore cohtasiniga. Tíre to nirire mʉsare yahui yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","João mʉsare bautisaro co mehne yoamare. Yʉhʉ sehe tí yʉhdoro yoaihtja mʉsare. Maha dachoricã baharo yʉhʉ sehe Espíritu Santore mʉsa mehne jirucuchʉ yoaihtja mʉsare —niha Jesu. ");
INSERT INTO gvc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ã yoa tina tʉ̃cʉ Olivo wama tidʉpʉ Jesu mehne cahmachuina sehe õ sehe ni sinitu ñʉha tirore: —Pʉhtoro, ¿mipʉre sãre Israe yahpare pari turi cũ, mari coyea warore pʉhto sõihcari mʉhʉ? —ni sinitu ñʉha to yaina. ");
INSERT INTO gvc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ti ã nichʉ tʉhoro Jesu õ sehe niha: —Mʉsa pʉhto sãahti pjare yahu quihõriro, ã wahachʉ yoariro yʉ Pʉcʉ dihta jira. Mʉsa sehere tíre ne masihto basioerara. ");
INSERT INTO gvc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wiho mejeta mʉsare Espíritu Santo to wihichʉ Cohamacʉ ya masiare cjʉanahca mʉsa. Tí masiare mʉsa cjʉana Jerusalẽ macainare, jipihtina Judea yahpa macainare, Samaria yahpa macainare, ã yoa jipihtina ahri dacho mʉ sʉro macainare noaa buheare buhenahca mʉsa. Yʉ yariarire, yʉ masa mʉjarire tinare buhenahca mʉsa —ni yahuha Jesu tinare. ");
INSERT INTO gvc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","To ã ni tuhsʉri baharota, Cohamacʉ Jesure mʉanopʉ mʉjachʉ yoaha jʉna. Tina tirore ti ñʉ nʉnʉ mʉochʉta me curua watopʉ sãa, buti mʉjaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","To ã buti mʉjari baharota tina Jesu to mʉjarirore ti ñʉ mʉono watoi pʉaro anjoa yehsea suhti tiina Jesu to cũrina watoi bajuarʉcʉ sʉha. ");
INSERT INTO gvc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ã bajuarʉcʉ sʉ, tinare õ sehe niha: —Mʉsa Galilea macaina, ¿dohse jiro baro ñʉ mʉorucuna nijari mʉsa? Ahriro Jesu, mʉsa mehne jiriro cjirota, Cohamacʉ mʉanopʉ to mʉjachʉ yoarirota, mipʉre to mʉjachʉ mʉsa ñʉriro seheta, pari turi duji tarohca tjoa —ni yahuha anjoa tinare. ");
INSERT INTO gvc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ã yoa Jesu yaina tʉ̃cʉ Olivo wama tidʉpʉ jiina duji taa, Jerusalẽpʉ tju sʉha. Tʉ tʉ̃cʉ cʉ̃ kilómetro bui curero yoaro jira Jerusalẽ dʉhtʉ cahapʉre. ");
INSERT INTO gvc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tju sʉ, tina mʉanopʉ ti jiri tahtiapʉ mʉjaa wahaha. Ahrina jiha: Pedro, João, Santiago, Andre, Felipe, Toma, Bartolomé, Mateo, Santiago, Simo, Juda jiha. Santiago sehe Alfeo macʉno jiha. Simo sehe cananista wama tiri curua macariro jimaha. Juda sehe Santiago macʉno jiha. ");
INSERT INTO gvc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Payʉ tahari ahrina jipihtina, to cũrina, ã jichʉ numia, María Jesu pocoro, ã yoa Jesu bahana mehne cʉ̃hʉ noano cahmachu, Cohamacʉre ã sinirucua tiha. ");
INSERT INTO gvc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ã yoa tí dachorire masa payʉ cahmachuha. Ciento y veinte jia jiboa. Ã jiro Pedro sehe tiro mehne macaina Cristo yaina watoi ducu, õ sehe ni yahuha tinare: ");
INSERT INTO gvc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Yʉ coyea, Cohamacʉ panopʉ to niriro seheta ã waharo nihre. Tíre Espíritu Santo Davi cjirore yahu dutiha Juda cjirore. Juda cjiro Jesure ñahahtinare ñoriro jihre. ");
INSERT INTO gvc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ã yoahtiro jiparota mari mehne Jesu yare yoariro jimahre. Ã jiro sã mehne macarirota jimahre —niha Pedro. ");
INSERT INTO gvc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Juda cjiro sehe Jesure ño dutia ti waparire to wiari baharo to basita wajã yariaha. Ã yoaro boraa waha, to tʉ misida tʉhnʉa waha, yariaa wahaha. To wiari cjiri mehne paina mahanocã yahpare nuchʉha. ");
INSERT INTO gvc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jipihtina Jerusalẽ macaina masi pihtinocari jire Juda cjiro to ñano yoarire. Ã masia ti ya dʉsero mehne to niñeru mehne ti nuchʉri yahpa cjirore Acéldama wamoari jire. Acéldama nia, “Di yahpa”, nia nina. ");
INSERT INTO gvc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Baharo õ sehe ni namoha Pedro: —Panopʉ to joariro seheta ã wahahre Juda cjiro. Salmo to joari tjui õ sehe ni joaa tiha: “Tiro to jiri wʉhʉ masa marieni wʉhʉ tjuarohca. Ne noa jisi tí wʉhʉre”, ni joaa tiha. Õ cʉ̃hʉre õ sehe ni joaa tiha: “Pairo to dahraa cjirire cohtotariro jirohca”, ni joaa tiha Salmopʉ. ");
INSERT INTO gvc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Ã jina mari cʉ̃iro besejihna. João masare bautisariro cjiro masare to buhero watoi cãina Jesu yaina mari mehne wahare. Tina mehne macarirore cʉ̃iro bese nano cahmana mari mehne macariro cjihto. Jesu mehne mari jichʉ mari mehne ã jirucurirore besero cahmana. Ã mari beseri baharo Jesu to masa mʉjarire mari mehne buherohca —ni yahuha Pedro to coyeare Cristo yainare. ");
INSERT INTO gvc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","To ã nichʉ tʉhoa pʉarore bese dapoha tina. Cʉ̃iro José Justo wama tirirore beseha. Tiro Barsaba ti ni pisuriro jiha. Bese tuhsʉ, pairore Matia wama tirirore beseha. ");
INSERT INTO gvc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Tinare bese dapo tuhsʉ, tina Cohamacʉre õ sehe ni siniha: —Mʉhʉ sã pʉhtoro jipihtina masa ti tʉhotuare masina. Ahrina pʉaro sã beseina jira. Juda cjirore cohtotahtirore diro mʉ cahmarirore besega. Jesure cohãtjiãhno Juda cjiro sehe pichacapʉ wahaha. Tirore cohtotahtiro Jesu to cũriro jirohca. Ã jiro sã mehne noaa buheare buherohca —ni siniha tina Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ã niata tãa mehne doca mʉjaha besea taa. Matia yaro to noano quihõno wijachʉ, tiro sehe Jesu to cũrina once cũrina mehne macariro tjuaha. ");
INSERT INTO gvc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ã yoa Pentecoste wama tiri dacho jichʉ tina jipihtina cʉ̃ wʉhʉi cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tí pjareta wihnono to tuaro taro seheta mʉanopʉ bisiro coa taha. To ã bisiro coa tachʉ tʉhoha jipihtina tí wʉhʉpʉ jiina. ");
INSERT INTO gvc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ã yoa picha pohna yoaro sehe jia tina jipihtina dapu poca bui bajuaha. Tí picha pohnaricã ñahmanoricã yoaro sehe bajuha. ");
INSERT INTO gvc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ã yoa Espíritu Santo tinapʉre sãarʉcʉ sʉa wahaha. Tinapʉre to sãarʉcʉ sʉa wahachʉ, paina ya durucuare to durucuchʉ yoaa mehne tina sehe paina ya durucuare noano durucuha. ");
INSERT INTO gvc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tí dachorire Jerusalẽpʉ payʉ judio masa, cʉ̃ curua macaina masa jipahta, paró paye yahpari macaina jiha. Cohamacʉre ño payoina jiha. ");
INSERT INTO gvc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ã yoa mʉanopʉ coa tachʉ tʉhoa tina Jesu buheina cahapʉ payʉ cahmachu wahcãha. Cahmachuina masape ya durucuare Jesu buheina ti durucu pahñochʉ tʉhoa, tina tʉho cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","—Cuenah. ¿Dohse yoaa ahrina Galilea macaina jipahta mari ya durucuare noano durucujari? Tina mari ya yahpapʉ taina yoaro seheta durucua nina —niha tina sehe. ");
INSERT INTO gvc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","—Jipihtina mari durucuare mipʉre durucua nina: Õpe yahpari macaina mari õre cahmachuina jija: Partia macaina, Media macaina, Elam macaina, Mesopotamia macaina, Judea macaina, Capadocia macaina, Ponto macaina, Asia macaina, Frigia macaina, Panfilia macaina, Egipto macaina, Libia yahpai Cirene cahapʉ jiina, Romapʉ taina jija mari. Cãina judio masa waro jija mari. Paina judio masa dojoina jija mari. ");
INSERT INTO gvc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Creta macaina cʉ̃hʉ, Arabia macaina cʉ̃hʉ jira mari mehne. Mari payʉ paró macaina soro durucua tiina mari jipanata ahrina sehe mari masape curuari macaina durucuare ti durucuchʉ tʉhoja mari. Tina mari ya durucua mehne Cohamacʉ tuaa mehne to yoarire yahua nina —ni durucuha masa ti basi. ");
INSERT INTO gvc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ã niata tina cʉaa waha, ti ñʉri cʉ̃hʉre ti tʉhori cʉ̃hʉre noano tʉho ñahaeraha. —¿Ahrina dohse jiro baro paina ya mehne Cohamacʉ yare ã noano durucujari, mʉsa tʉhotuchʉ? —ni cahma sinitu ñʉha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wiho mejeta paina Jesu yaina ti durucuchʉ tʉhoina mehne macaina sehe tinare õ sehe ni bʉjʉpeha: —¿Dohse ahrina sihbiori sihni cahaa nijari? —ni bʉjʉpeha paina tinare Jesu yainare. ");
INSERT INTO gvc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ã jiro Pedro once Jesu to cũrina mehne wahcãrʉcʉ sʉ, tuaro durucutjiãhno masare õ sehe ni yahuha: —Mʉsa Judea yahpa macaina, jipihtina Jerusalẽpʉ jiina, ahrire masiga mʉsa. Yʉ yahuchʉ tʉhoga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mʉsa tʉhotua quihõno jierara. Nueve hora jira mipʉta. Mari chʉ sihnini hora jierasinica. Ã jia ahrina cahaina jierara. ");
INSERT INTO gvc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ahrina Cohamacʉ panopʉ to niriro seheta yoaa nina. Tí pjapʉre Joere Cohamacʉ yare yahu mʉhtariro cjirore, ahrire yahu dutia tiha Cohamacʉ sehe: ");
INSERT INTO gvc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Sohtori tia dachori jichʉ õ sehe jirohca: ‘Yʉ yairo Espíriture masare jipihtinare warocaihtja. Ã jia mʉsa pohnapʉ yʉ yare yahuahca. Ã yoa mʉsa mehne macaina wahma yapia bajuamehneare ñʉahca. Ã jia mʉsa mehne macaina bʉcʉna cahãnopʉ cahãahca. ");
INSERT INTO gvc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ã jicʉ yʉ cahamacare, mʉare, numia cʉ̃hʉre yʉ yairo Espíriture warocaihtja. Ã jia tina yʉ yare yahuahca. ");
INSERT INTO gvc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tuhsʉ, yʉ tuaa mehne bajuamehneare yoa ñoihca mʉanopʉ. Yahpapʉ cʉ̃hʉre yʉ bajuamehneare ñoihca: Dire, pichacare, mene ñoihca. ");
INSERT INTO gvc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tuhsʉ, sʉ̃ dacho macariro nahitianore cohtotarohca. Ñami macariro di yoaro sehe sohãriro cohtotarohca. Õ sehe waharohca Cristo mʉsa pʉhtoro to tahti dacho, yʉ niri dacho panoi. Tí dachoi ñʉ cʉaa wahaahca masa. Ã jiro wiho jiri dacho jisi. Tí dacho noari dacho jirohca. ");
INSERT INTO gvc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ã jiro õ sehe jirohca. Jipihtina masa Cristore ti ñaa buhirire cohã duti siniinare tiro tinare pichacapʉ wahaborinare yʉhdorohca’, nina Cohamacʉ”, ni joaha Joe. ");
INSERT INTO gvc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Mʉsa Israe masa yʉ yahuchʉ tʉhoga: Jesu Nazare macariro sehe Cohamacʉ to warocariro jihre. Jesure to warocarire masa ti masihto sehe Jesu to Pʉcʉro ya tuaa mehne yoa ñohre mʉsare. Mʉsa tíre masina. ");
INSERT INTO gvc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jesure wajã dutina judio masa jierainare wahre mʉsa. Cohamacʉ panopʉ to cahmariro seheta, “Ã waharohca”, to niriro seheta ã yoahre. Ã jina mʉsa Jesure crusapʉ wajã dutihre Cohamacʉ dutiare cjʉaerainare. ");
INSERT INTO gvc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mʉsa ã yoapachʉta Cohamacʉ sehe Jesure yariariro cjirore masohre. Pari turi ne yariasi tiro. Tiro yaria dojoaerara. Ã catirucuhtiro jira. ");
INSERT INTO gvc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Õ sehe nia tiha Davi cjiro panopʉ macariro Cristo to ni durucuboriro seheta: “Yʉ pʉhtoro yʉhʉ mehne jira mʉhʉ. Jipihtia dachoripe Cohamacʉ yʉ pʉhtoro yʉ cahai mʉ jichʉ ñʉa tihi yʉ cuierahto sehe. ");
INSERT INTO gvc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Mʉhʉ Cohamacʉ yʉhʉre yariaina ti jiropʉre ne cohãsi. Yʉhʉre mʉ cahĩrirore ñanopʉ cohãsi mʉhʉ. Yʉhʉ mʉ cahamacʉno mʉhʉre ño payoriro jija. Yʉ pjacʉre baa dutisi mʉhʉ. Ã jicʉ tuaro wahcheja. Wahchea mehne durucuja. Ã jicʉ mʉhʉre Cohamacʉre noano wacũ tuariro jicʉ ñaa buhiri marieriro jicʉ cuiro marieno noano jinocaja. ");
INSERT INTO gvc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yʉhʉre pari turi catichʉ yoaihca mʉhʉ. Yʉhʉ mehne mʉ jichʉ tuaro wahcheja”, ni joaa tiha Davi cjiro Cristo to ni durucuboriro seheta. ");
INSERT INTO gvc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Coyea, õ sehe noano yahuihtja mʉsare Davi cjirore mari coyeiro, panopʉ macarirore. Tiro yariaa wahaha. Ã jiro tiro to masa copa mipʉre jisinina. (Ã jiro “Yʉ pjacʉre baa dutisi mʉhʉ”, ni joaro to basi wama payo yahuro nieraha.) ");
INSERT INTO gvc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Panopʉ Cohamacʉ Davi cjirore õ sehe niha: “Potocã nii nija. Mʉ panamana ji turiaina mehne macariro mʉ yoaro seheta ahri yahpa macaina bui pʉhtoro jirohca”, nia tiha Cohamacʉ Davi cjirore. Davi Cohamacʉ yare yahu mʉhtariro cjiro jiha. Ã jiro Cristore Cohamacʉ to pʉhto sõhtore masino, Cristo to masa mʉjahtore yahu mʉhta tuhsʉha Davi sehe. Õ sehe niha: “Tiro yariaina ti jiropʉre ji dojoasi. To pjacʉ tói baasi”, nia tiha Davi cjiro. ");
INSERT INTO gvc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ahriro Jesureta Cohamacʉ masohre. Sã jipihtina tirore ñʉhi. ");
INSERT INTO gvc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mipʉre Cohamacʉ poto bʉhʉsehepʉ jira dutiriro jiro. Tó panopʉ to Pʉcʉro “Espíritu Santore mʉ yainare warocaihtja”, to ni cũriro seheta wari jire Jesure. Ã jiro Jesu sehe ahrinare Espíritu Santore warocari jira. Ã jina mipʉre Espíritu to yoaare mʉsa ñʉ, tʉhona nina. ");
INSERT INTO gvc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davi cjiro sehe Jesu to mʉjariro seheta mʉanopʉ mʉjaeraa tiha. Ã jiro tiro to basi õ sehe nia tiha: “Cohamacʉ õ sehe nire yʉ pʉhtorore: ‘Yʉ poto bʉhʉsehei dujiga mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mʉhʉre ñʉ tuhtiinare mʉhʉre cũihtja mʉ cahamaca yoaro sehe jihtinare’, nire Cohamacʉ yʉ pʉhtorore”, nia tiha Davi cjiro. ");
INSERT INTO gvc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Ã jina jipihtina Israe masa ahrire noano masiga mʉsa: Ahriro Jesure mʉsa crusapʉ wajãriro cjirore mʉsa pʉhtoro sõhre Cohamacʉ sehe. Tirore mʉsare yʉhdohtirore Cristore cũre Cohamacʉ —ni yahuha masare Pedro. ");
INSERT INTO gvc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","To ã nichʉ tʉhoa tuaro cahya, pjíro tʉhotua, masa sehe Pedro cʉ̃hʉre õ sehe ni sinitu ñʉha: —¿Sã coyea, dohse yoanahcari sã? —ni sinitu ñʉha tina. ");
INSERT INTO gvc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ti ã ni sinitu ñʉchʉ õ sehe ni yʉhtiha Pedro: —Mʉsa ñaa yoari buhirire cahyaga. Mʉsa ñaa tʉhotumari cjirire tʉhotu cohtota, “Ã tjiri jira” ni, Cohamacʉreta maca, tʉhoga. Ã yoa Jesu yaina jina, bautisarina jiga mʉsa jipihtina. Jesure mʉsa wacũ tuachʉ ñʉno, mʉsa ñaa yoari buhirire borohca Cohamacʉ. Tó sehe mʉsa yoachʉ Espíritu Santore warohca mʉsare. ");
INSERT INTO gvc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mʉsare, mʉsa pohnare, mʉsa panamana ji turiainare, yoaro macainare, ã yoa jipihtina Cohamacʉ mari pʉhtoro to beserinare, “Potocãta yʉhdoihtja mʉsare”, ni cũha Cohamacʉ —niha Pedro. ");
INSERT INTO gvc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tuhsʉ, tuaro mehne õ sehe ni yahu quihõha tinare: —Ahri yahpa macaina, Cohamacʉre ji coaerainare buhiri dahrerohca Cohamacʉ. Wiho mejeta mʉsa sehe, tina watoi jiina, Cohamacʉ yahurire, “Ã tjira”, ni bahrañoga mʉsa yʉhdʉhto sehe —yahu quihõha Pedro masare. ");
INSERT INTO gvc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","To ã nichʉ tʉhoa tina payʉ to yahuare noano tʉhoha. Ã jiro tinare tiro bautisa dutiha. Tí dachore Cohamacʉ yaina mehne macaina tres mil masa waha namoha. ");
INSERT INTO gvc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ã yoa tina masa Cristo to cũrina mehne dachoripe cahmachu, tí buheare tʉho nʉnʉ, tíre yʉhti mʉjaa tiha. Tina pãore nuha, cahma witi, Cohamacʉre sini, Cristo to cũrina mehne noano jinocaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ã yoa Cohamacʉ to tuaa mehne yoa ño mʉjaha to cũrina. Ti ã yoachʉ ñʉa masa jipihtina ñʉ cʉaa wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jipihtina Jesure wacũ tuaina cahmachu, noano jinocaa tiha. Ã jia ti yare cahma witia tiha. ");
INSERT INTO gvc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ti yare dua, jipihtinare paye baro maerainare cãina ti cahmaare waa tiha tina. ");
INSERT INTO gvc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ã jia dachoripe tina Cohamacʉ wʉhʉ wijaaroi cahmachua tiha. Ã yoa cãa wʉhʉse, ti ya wʉhʉsepʉ cʉ̃hʉre nohopeina cahmachu, pãore nuha, wahchea mehne tina cʉ̃noi chʉa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ti ã cahmachuno watoi “Cohamacʉ noariro jira”, ni ño payoa tiha. Paina masa tinare ji coa yʉhdʉa tiha. Ã yoaro dachoripe Cohamacʉ painare to yaina to yʉhdohtina wahachʉ yoaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cʉ̃ nʉmʉ ñamichahapʉ tres jichʉ Cohamacʉ mehne durucuri pja jichʉ Pedro, João mehne Cohamacʉ wʉhʉpʉ wahaa niha. ");
INSERT INTO gvc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dachoripe tí wʉhʉre ti sahrĩ sãari sahrĩno tãa mehne ti yoari sahrĩno macari sopaca cahai paina cʉ̃iro masʉnore na ta duhu dapoa tiha. Tí sopaca noari sopaca wama tiha. Tiro masʉno sehe wahma masa bajuaropʉta dojori wahiro jiro tini masierariro jiha. Ã jiro tiro tí sopaca cahai niñerure sini dujia tiha tí sopacai sãainare. ");
INSERT INTO gvc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ã yoa Pedro, João mehne tí sopacare ti sãa cahachʉ tini masierariro sehe tinare ñʉ, niñerure siniha. ");
INSERT INTO gvc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ã jia tina pʉaropʉta tirore ñʉ, Pedro sehe õ sehe niha: —Sãre ñʉga mʉhʉ —niha Pedro tirore. ");
INSERT INTO gvc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","To ã nichʉ tʉhoro “Ahrina mahanocã yʉhʉre niñerure waahca”, ni tʉhoturo ñʉroca õ tʉhoha tinare. ");
INSERT INTO gvc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","To ã ni tʉhotupachʉta Pedro tirore õ sehe ni yahuha: —Niñerure cjʉaeraja yʉhʉ. Cjʉaerapaihta, ahrire yoaihtja mʉhʉre. Jesucristo Nazare macariro to tuaa mehne wahcãrʉca, tiniga mʉhʉ —niha Pedro tini masierarirore. ");
INSERT INTO gvc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ã ninota to wamomacare poto bʉhʉsehe macari wamomacare ñaha, tirore waja wahcõ dapoha. To ã yoachʉta tini masierarirore to ñʉchʉa tuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","To ã wahachʉta tiro wahcãrʉca purʉcʉ sʉ, tini dʉcaha. Ã tini dʉcaro tiro waha, pu tini “Cohamacʉ noariro jira”, to ni wahcheriro mehne tina mehne Cohamacʉ wʉhʉ macari sahrĩno puhichapʉ sãa wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","To ã tinichʉ “Cohamacʉ noariro jira”, to nichʉ masa jipihtina tirore ñʉha. ");
INSERT INTO gvc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ã jia masa tirore ñʉ masiha. Tiro Cohamacʉ wʉhʉ macari sahrĩno tãa mehne to yoari sahrĩno macari sopaca noari sopaca cahai niñerure to sini dujirire masiha masa. Ã jia tiro to tinichʉ ñʉa, ñʉ cʉaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ã yoa tini masierariro cjiro Pedro cʉ̃hʉre to siõ suha mʉjano watoi, masa jipihtina ñʉ cʉaa waha, noari wapapʉ Salomo wama tiri wapapʉ mʉroca wahcã, cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ti ã cahmachurʉcʉ sʉchʉ ñʉno, Pedro sehe õ sehe ni yahuha tinare: —Mʉsa Israe masa, ¿dohseana ahrirore ñʉ cʉajari? ¿Dohseana sãre mʉsa ñʉ nʉnʉjari? Sã sehe sã ya tuaa mehne noaina sã jia tia mehne sã mʉ sʉro ahrirore tinichʉ yoaerahi sã. Jesu sehe tíre yoahre. ");
INSERT INTO gvc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahã, Isaa, Jacobo mari ñʉchʉsʉma, panopʉ macaina ti yairo Cohamacʉ sehe to cahamacʉno Jesure Jipihtina Bui Jiriro cũhre. Wiho mejeta mʉsa sehe tó sehe jirirore tirore ñʉ tuhtiinare wahre. Baharo pʉhtoro Pilato tirore to wio duapachʉta, mʉsa sehe tirore to wiochʉ cahmaerare. ");
INSERT INTO gvc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pilato tirore wio duamahre. Wiho mejeta mʉsa Jesure ñaa buhiri marierirore, quihõno yoarirore cahmaerana, pairore masa wajãriro sehere wio dutihre mʉsa. ");
INSERT INTO gvc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ã yoana Jesure marine catichʉ yoarirore wajãchʉ yoare mʉsa sã coyea judio masa. To yariachʉ Cohamacʉ tirore masohre. Tíre sã ñʉhi. ");
INSERT INTO gvc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ã jina Jesu pjiriro to jia tiare wacũ tuaina jija. Tirore sã ã wacũ tuachʉ ñʉno ahrirore mʉsa mipʉ ñʉrirore mʉsa ñʉ masirirore Jesu sehe to tuaa mehne tinichʉ yoahre. ");
INSERT INTO gvc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Yʉ coyea, mʉsa pʉhtoa mehne Jesure noano masierapanahta tirore wajãchʉ yoare mʉsa. Tíre masija yʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wiho mejeta panopʉ macaina Cohamacʉ yare yahu mʉhtaina cjiri Cohamacʉ tinare to yahu dutiriro seheta, yahua tiha tina. “Cristo ñano yʉhdʉ, yariarohca”, ni yahua tiha tina. Ti ã ni yahuriro seheta ã wahahre mipʉre. ");
INSERT INTO gvc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ã jina mʉsa ñaare yoari buhirire cahyaga. Mʉsa tʉhotumari cjirire tʉhotu cohtota, ñaare mʉsa goa pjarire duhu, Cohamacʉreta majarerʉca, to ya sehere quihõno tʉhoga. Mʉsa tirore majarerʉca, quihõno tʉhochʉ ñʉno, Cohamacʉ mʉsa ñaare yoari buhirire borohca. Ã boro, mʉsare wahchehti dachorire cũ, mʉsare noano yajeri sãachʉ yoarohca tiro. ");
INSERT INTO gvc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ã yoa tiro mʉsa pʉhtoro cjihtore to beseriro Cristore mʉsare warocarohca tjoa. Tiro Cristo sehe Jesuta jira. ");
INSERT INTO gvc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cohamacʉ cahapʉ jisininohca Jesu, pʉ Cohamacʉ ahri yahpapʉ jipihtiare wahma to cohtota pahñochʉpʉ. To ã cohtota pahñohtore Cohamacʉ yare yahu mʉhtaina cjiri, to yaina waro panopʉ yahu quihõ tuhsʉa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moise cjiro tíre yahuro õ sehe ni mʉhtaha: “Cʉ̃iro mari mehne macarirore mari coyeiroreta Cohamacʉ yare yahu mʉhtahtiro cjihtore Cohamacʉ mari pʉhtoro warocarohca mʉsare. Yʉhʉre to warocariro seheta warocarohca tiro cʉ̃hʉre. Ã jina mʉsare to yahuchʉ tʉhona, ‘Jai’, ni yʉhti pihtinocaga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Õ sehe jirohca. Jipihtina tirore yʉhtieraina to cohãhtina jiahca. Cohamacʉ yaina mehne macaina jisi tina”, ni mʉhtaa tiha Moise cjiro. ");
INSERT INTO gvc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Jipihtina Cohamacʉ yare yahu mʉhtainape Samue, ã yoa to baharo jiina cʉ̃hʉ mipʉ jia dachori cjihtire yahu mʉhtaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mari ñʉchʉsʉma cjirire, Cohamacʉ yare yahu mʉhtaina cjiri cʉ̃hʉre panopʉ macainare yahua tiha Cohamacʉ. Mari cʉ̃hʉre ã ni yahuro nia tiha. Abrahãre to niriro seheta mari cʉ̃hʉre ni yahuro nia tiha. Õ sehe ni yahua tiha Cohamacʉ Abrahãre: “Jipihtiro ahri yahpa macainare noano yoaihtja. Õ sehe tíre yoaihtja: Mʉ coyeiro baharo jiriro sehe masare noano yoabasarohca yʉhʉre”, nia tiha Cohamacʉ Abrahãre. ");
INSERT INTO gvc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Cohamacʉ to macʉnore masa wijachʉ yoaro mari cahapʉ waroca mʉhtare mari ñaa yoaare duhuchʉ yoahtirore. Ã yoaro marine tiro noano yoare —niha Pedro tinare. ");
INSERT INTO gvc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Pedro, João cʉ̃hʉ masa mehne ti durucuro watoi sacerdotea, Cohamacʉ wʉhʉre cohtaina surara pʉhtoro, saduceo curua macaina cʉ̃hʉ tinare tʉhoha. Õ sehe ni buheha Pedro João mehne masare: —Jesu to yariari baharo masa mʉjaa wahahre. To ã masa mʉjarire ñʉna mari cʉ̃hʉ baharo to yaina mari masa mʉjahtore masija mari —ni yahuha Pedro cʉ̃hʉ. Ti ã nichʉ tʉhoa pʉhtoa sehe tina mehne suaha. Ã suaa nahi cahachʉ ñʉa tina Pedrore, João cʉ̃hʉre ñaha, peresu yoaha. ");
INSERT INTO gvc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ã tinare peresu ti yoapachʉta payʉ ti yahuare tʉhoina sehe “Potocãta jira”, ni tʉhotuha. Ã jia Jesu yaina payʉ waha, tí dachoi wahma to yaina ji dʉcaina, ã yoa tó panopʉ Jesure wacũ tua tuhsʉrina mehne mʉa sahserore mari quihõchʉ, cinco mil masa sʉro cahai jiha. ");
INSERT INTO gvc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ã yoa pa dachoi tí maca macaina pʉhtoa, bʉcʉna, ã yoa judio masa buheina cʉ̃hʉ Jerusalẽpʉ cahmachuha. ");
INSERT INTO gvc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ti ã cahmachunoi sacerdotea bui pʉhtoro, Ana wama tiriro cʉ̃hʉ tói jiha. Ã yoa to coyea cʉ̃hʉ jiha. Caifa, João, Alejandro, paina mehne Ana coyea cʉ̃hʉ jiha. To coyea to dahraare dahraina jiha tina cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ã jia tina Pedro cʉ̃hʉre ti cahmarocachʉ, surara sehe pʉhtoa watopʉ tinare naa wihi dapoha. Ti ã na wihi dapochʉ, tina pʉhtoa õ sehe ni sinitu ñʉha Pedro cʉ̃hʉre: —¿Noa ya tuaa mehne mʉsa tirore noariro yoari? ¿Noa jijari mʉsare tíre yoa dutiriro? —ni sinitu ñʉha tina. ");
INSERT INTO gvc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ti ã nichʉ tʉhoro Espíritu Santo to yoa dutiriro seheta to tuaa mehne yahuha Pedro tinare: ");
INSERT INTO gvc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—Mʉsa pʉhtoa, ¿mʉsa bʉcʉna, sã dohse yoa ahriro tini masierarirore sã tinichʉ yoarire masi duana, sãre sinitu ñʉna nijari mʉsa? ");
INSERT INTO gvc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tí pja pini ahrire masiga mʉsa jipihtina, Israe masa. Jesucristo Nazare macariro, mʉsa crusapʉ wajãriro, Cohamacʉ to masoriro tiro sehe ahriro tini masierarirore noariro wahachʉ yoahre. Ã jina ahrirore mipʉre mʉsa ñʉrocaroi to tinichʉ ñʉna mʉsa. Õ sehe nina Cohamacʉ yare ti joari pũi Jesu cjihtore yahuro: ");
INSERT INTO gvc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Ahriro tãca yoaro sehe jiriro jira. Tãcare wʉhʉ dahreina wiho jiriare ti cohãriro seheta mʉsa judio masa tirore cohãhre. Mʉsa ã yoapachʉta mipʉre wʉhʉ dahreina wʉhʉre yoaa ti cũ mʉhtari tãcare ti cũriro seheta Cohamacʉ tirore pʉhtoro sõhre. Tiro Cristo mariachʉ Cohamacʉ yaina wahaeraboa masa. (To ã wiho jiriro jierapachʉta mʉsa mari pʉhtoa mehne tirore cahmaerare. Mʉsa ã cahmaerapachʉta Cohamacʉ sehe tirore mari pʉhtoro sõhre)”, ni joaha panopʉ. ");
INSERT INTO gvc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne, pairo masare pichacapʉ wahaborinare yʉhdoriro ne mariahna. Ahri yahpapʉre Jesu dihta masare yʉhdoriro jira. Ne paina tiro yoaro sehe jiina mariahna —ni yahuha Pedro tinare. ");
INSERT INTO gvc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","To ã ni yahuri baharo Pedro, João mehne buhemahnoeraina jipahta cuiro marieno ti buhechʉ ñʉa, pʉhtoa, bʉcʉna, judio masa buheina mehne ñʉ cʉaa wahaha. Ã jia Jesu yoaro sehe ti buhechʉ ñʉa, õ sehe masiha tina: “Potocã Jesu mehne macaina tjira ahrina”, ni masiha tina. ");
INSERT INTO gvc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ã yoa tini masierariro cjiro Pedro cʉ̃hʉ mehne jiha. Tiro to noariro jichʉ ñʉha pʉhtoa, bʉcʉna, judio masa buheina mehne. Ã jia tina Pedro cʉ̃hʉre “Ñano yoaa nina”, ni yahusã masieraha. ");
INSERT INTO gvc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ã yahusã masieraa pʉhtoa ti cahmachuri tahtiapʉ jiinare Pedro cʉ̃hʉre wijaa dutiha. ");
INSERT INTO gvc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ti wijaari baharo pʉhtoa sehe ti basi õ sehe ni sʉhʉduha: —¿Ahrinare dohse yoanahcari mari? —ni durucuha tina ti basi. Õ sehe ni durucu namoha: —Pedro, João Cohamacʉ tuaa mehne tini masierarirore tinichʉ yoari jire. Ã jia Jerusalẽ macaina jipihtina ti ã yoarire masica. Ã jina mari sehe “Ã yoaerare tina” ni masieraja mari. ");
INSERT INTO gvc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ã jina Jesu to buheri cjirire painare buhe dutiena tjijihna tinare, “Paina tí buheare cahmari”, nina —ni durucuha tina ti basi. ");
INSERT INTO gvc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ã ni durucu tuhsʉa Pedro cʉ̃hʉre pjiroca, õ sehe niha: —Jesu to buheri cjirire ne buhena tjiga painare. Tíre ne durucu namoena tjiga —ni yahumaha tinare. ");
INSERT INTO gvc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ti ã ni yahuchʉ tʉhoa tina Pedro João mehne õ sehe ni yʉhtiha tinare: —Mʉsa õ sehe ni dutichʉ mʉsare yʉhtina, Cohamacʉ sehere yʉhdʉrʉcana niboca sã. ¿Diro ya sehere sã yoachʉ quihõno jijari Cohamacʉ to ñʉrocarore? ¿Mʉsa ya sehere sã yoachʉ quihõno jijari? ¿Cohamacʉ ya sehere sã yoachʉ quihõno jierajari, mʉsa tʉhotuchʉ? ");
INSERT INTO gvc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sã sehere sã ñʉrire, sã tʉhorire sãre yahto basioerara —ni yʉhtiha Pedro, João mehne. ");
INSERT INTO gvc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ti ã nichʉ tʉhoa pʉhtoa sehe pari turi dutimaha tjoa tinare: —Jesu to buherire mʉsa buheri buhiri ñano yʉhdʉnahca mʉsa —niri jimare pʉhtoa tinare. “João, Pedro mehne ñano yoaa nina”, ni masierari jire tina. Ã jia masa sehe tini masierariro to noariro wahachʉ ñʉa, “Cohamacʉ potocãta noariro jira”, niha masa. Ti ã nichʉ tʉhoa pʉhtoa sehe Pedro cʉ̃hʉre ti dohse yoa buhiri dahreboare bocaeraa, tinare wioha. ");
INSERT INTO gvc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tini masierariro, noariro ti yoariro cuarenta cʉhmari bui cjʉariro jiha. ");
INSERT INTO gvc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ã yoa, Pedro João mehne ti wiori baharo tina mehne macaina cahapʉ sʉ, sacerdotea pʉhtoa, bʉcʉna jipihtia tinare ti niri cjirire yahuha. ");
INSERT INTO gvc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ti ã ni yahuchʉ tʉhoa tina jipihtina cʉ̃no potori Cohamacʉre siniha: —Sã pʉhtoro mʉhʉ mʉanore, yahpare, mári cʉ̃hʉre yoariro jipihtina catiinare bajuamehneriro jira mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mʉ Espíritu Santo sã ñʉchʉ cjirore Davire mʉ cahamacʉnore ahrire yahu dutia tiha mʉ niriro seheta: “¿Dohse yoa Israe masa jieraina suajari? ¿Dohse yoa Cohamacʉre ti yʉhdʉrʉcahtire wiho waro durucujari tina? ");
INSERT INTO gvc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Payʉ yahpari macaina pʉhtoa cahmachu, mari pʉhtoro Cohamacʉre, to pʉhtoro sõriro Cristo cʉ̃hʉre ñʉ tuhti, ñano yoa duara tinare”, ni yahua tiha Davi cjiro mʉ ni dutiriro seheta. ");
INSERT INTO gvc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ã tjira. Ahri macai Herode, Poncio Pilato, judio masa jieraina, ã yoa judio masa cʉ̃hʉ cahmachuhre, mʉ beserirore Jesure noariro mʉ cahamacʉnore wajãa taa. ");
INSERT INTO gvc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tí pja mʉ cahmariro seheta “Ã waharohca”, mʉ niriro seheta yoahre tina. Mʉ masia mehne ã ni yahuha mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ã jicʉ mipʉre sã pʉhtoro, tina sãre purĩno mehne mʉ jia tiare ti yahu namo dutierachʉ wacũ payoga mʉhʉ. Sãre mʉ cahamacare cuiro marieno mʉ buheare yahuchʉ yoaga sãre. ");
INSERT INTO gvc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mʉhʉ mʉ tuaa mehne dohatiinare noaina yoaga. Ã jicʉ mʉ buheare cuiro marieno yahu dutiga sãre. Ã yoa Jesu noariro mʉ cahamacʉno to tuaa mehne yoa ño masichʉ yoaga sãre. Ã jicʉ dohatiinare noaina sã waha dutichʉ to tuaa mehne yoadohoga sãre —ni siniha tina Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ti ã ni siniri baharo, ti cahmachuri wʉhʉ ñuhmi mʉaa wahaha. To ã ñuhmichʉta Espíritu Santo to tuaa mehne wacũ tua namoina wahachʉ yoaha tinare. Tinare ã wahachʉ Espíritu Santo to dutiriro seheta yoaa, cuiro marieno Cohamacʉ yare yahu namoha tjoa tina. ");
INSERT INTO gvc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Ã jia Cohamacʉ to tuaa mehne tina Jesu to cũrina õ sehe ni yahua tiha masare: “Jesu yariariro to masarire sã ñʉhi”, ni yahua tiha tina masare. Ã jiro tinare jipihtinare Cohamacʉ noano yoadohorucua tiha. Ã yoa Jesure wacũ tuaina payʉ jia, tina cʉ̃no potori tʉhotuina jia tiha. Ã jia tina ti yare ti cjʉaare “Yʉ ya dihta jira”, ne niera tiha. Tina jipihtina ti yare paye baro maerainare tina mehne macainare tju waa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ã jia tina mehne macaina pjacʉoina mariea tiha. Tina mehne macaina yahpari cjʉaina, wʉhʉse cjʉaina ti yare duaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ã duaa ti wapa narire tina na ta, Jesu to cũrinare waa tiha. Ã jia tina sehe tíre tina mehne macainare tju waa tiha. Jipihtina cjʉaerainare tju waa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tí pjare cʉ̃iro tina mehne macariro José wama tiriro jiha. Jesu to cũrina Josére Bernabé ni wama pisuha. To wama Bernabé “Masare wahchechʉ yoariro jira”, nia nina. Tiro Leví ya curua macariro Chipre nʉco macariro jiha. ");
INSERT INTO gvc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ã jiro tiro yahpare cjʉariro jiro tíre duaha. Ã duaro to wapa narire Jesu to cũrinare waha tiro painare witi dutiro. ");
INSERT INTO gvc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Paina cʉ̃hʉ Bernabé yoaro sehe yoaa timaha. Tina Anania wama tiriro, to namono Safira wama tiricoro jiha. Ti ya yahpare duaha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ã duaparota tiro to wapatarire to basi naha. To namono cʉ̃hʉ to ã yoarire masiha. Ã jiro ti wapataa ti dʉharire na ta, Jesu to cũrinare waha Anania sehe. Ã waro “Wa pahñoi nija”, nimaha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","To ã yoachʉ ñʉno Pedro tirore õ sehe ni yahuha: —Anania, watĩno mʉhʉre mahño dutiri jire Espíritu Santore. Ã jicʉ mʉ ya yahpare dua, mʉ wapatarire mʉ basi nari jire mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mʉ duahto pano mʉ ya yahpa jihre. Ã jiro mʉ duari baharo mʉ ya wapataa jihre. ¿Ã yoacʉ dohse jiro baro ã mahñori mʉhʉ? Mʉhʉ sã dihtare mahñoerare. Cohamacʉ cʉ̃hʉre mahñohre mʉhʉ —niha Pedro tirore. ");
INSERT INTO gvc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","To ã nichʉ tʉhorota, Anania sehe doca caha sʉ, yariaa wahaha. Ã jia jipihtina tiro to ã wahachʉ masia, tuaro cuiha. ");
INSERT INTO gvc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","To yariari baharo wahma yapia ta, to pjacʉre suhtiro cahsaro mehne wahma, sopacapʉ na wijaa, masa copapʉ cohãnocaha tirore. ");
INSERT INTO gvc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ã yoa tia hora baharo Anania mʉnano namono, to yariarire masieraro Pedro cahapʉ sãaha. ");
INSERT INTO gvc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ã jiro Pedro ticorore õ sehe niha: —¿Mʉsa ya yahpare duatjiãhna noho puro wapatari mʉsa? —niha tiro. Ã jiro ticoro to manʉno mʉnano to niriro purota, “Tó purota wapatahi sã”, ni yʉhtimaha ticoro. ");
INSERT INTO gvc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","To ã ni yʉhtichʉ tʉhoro Pedro õ sehe ni yahuha ticorore: —¿Dohse yoana mʉsa cʉ̃no potori Cohamacʉ Espíriture mahño duajari? “¿Potocãta marine buhiri dahrebocari?” nina. Tʉhoga mipʉre. Mʉ manʉ cjirore yarina tara. Mʉhʉ cʉ̃hʉre mʉ pjacʉre naa taa nina —niha Pedro. ");
INSERT INTO gvc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","To ã ni yahuchʉta ticoro doca caha sʉ, yariaa wahaha. Ã jia wahma yapia tí wʉhʉre sãa wihi, ticoro pjacʉre na wijaa wahaha. Na wijaa, to manʉno mʉnano pari wahpa ticoro pjacʉre masa copapʉ cohãha. ");
INSERT INTO gvc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ã jia Jesu yaina jipihtina paina tíre tʉhoa cui yʉhdʉa wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ã yoa masa watoi Jesu to cũrina payʉ tahari Cohamacʉ tuaa mehne yoa ñoa tiha. Ã yoa tina Salomo wama tiri tahtiapʉ tihamahnoeni tahtiapʉ cahmachua tiha. ");
INSERT INTO gvc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ã jia paina Jesu yaina jieraina sehe cui curea, tina cahapʉ wahaera tiha. Ã cuipahta tinare Jesu yaina warore “Noaina jira ahrina”, nia tiha masa. ");
INSERT INTO gvc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ã jia mʉa, numia payʉ Jesure wacũ tua dʉcaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ã jia tina dohatiinare na ta, coma yosaa mehne pjũpaha duhu cũa tiha mahapʉ tinare. Ã yoaa Pedro tinare to ña payochʉ cahmaha tinare na taina sehe dohatiina ti noaina wahachʉ cahmaa. Tinare to ña payoerachʉ Pedro ti bui masʉrʉca cũchʉ cahmaha tina. Tí dihtare cahmaa tiha ti noaina wahahto sehe. ");
INSERT INTO gvc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ã jia Jerusalẽ cahai jia macari macaina cʉ̃hʉ dohatiinare, watĩa ti sãaina cʉ̃hʉre na taa tiha. Ti ã na tachʉ tina jipihtina ti pjacʉri noaina wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ti ã yoachʉ ñʉa sacerdotea bui pʉhtoro, tiro mehne macaina mehne Pedro cʉ̃hʉre ñʉ tuhtiha. Sacerdotea pʉhtoro mehne macaina saduceo curua macaina jiha. ");
INSERT INTO gvc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ã ñʉ tuhtia tina sua yʉhdʉa Jesu to cũrinare ñaha, peresu yoaha. ");
INSERT INTO gvc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ã jiro ñamipʉ Cohamacʉ yairo anjo pjõoha tinare peresui dujiinare. Ã yoa tinare wijaa ta dutiro õ sehe ni yahuha anjo: ");
INSERT INTO gvc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Cohamacʉ wʉhʉpʉ wahaga. Tí wʉhʉpʉ jina Cohamacʉ to masorire ahri noaa buheare yahuga masare —niha anjo tinare. ");
INSERT INTO gvc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","To ã nichʉ tʉhoa, ñamiwacũnu jichʉ Cohamacʉ wʉhʉpʉ sãa, masare buhea tiha tina. Tí dachoihta sacerdotea pʉhtoro, tiro mehne macaina, Israe masa pʉhtoa mehne cahmachu, Jesu to cũrinare peresupʉ jiinare na ta dutimaha surara pʉhtoare. ");
INSERT INTO gvc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wiho mejeta surara pʉhtoa peresu ti yoari wʉhʉpʉ waha, ñʉmaha. Tinare bocaeraha. Bocaeraa tjuaa wahaha. Tju sʉ õ sehe ni yahuha ti pʉhtoare: ");
INSERT INTO gvc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Peresupʉ jia pahmari bihaa pahmari jihre. Ã jia tí pahmari cahai ti peresu yoarinare cohtaina ti ducuchʉ ñʉhi sã. Wiho mejeta pjõo sãa, sã ñʉchʉ, ti peresu yoarina mariahre —ni yahuha tina. ");
INSERT INTO gvc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ti ã nichʉ tʉhoa, surara Cohamacʉ wʉhʉre cohtaina pʉhtoro, sacerdotea pʉhtoa mehne tíre tʉho, cʉaa waha, “¿Dohse waha sohtori tiahcʉ tina ã yoaa?” ni tʉhotuha tina. ");
INSERT INTO gvc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ã jiro tina cahapʉ pairo sʉ, tinare õ sehe ni yahuha: —Mʉsa peresu yoarina Cohamacʉ wʉhʉpʉ jihre. Ñʉna wahaa wiho. Tí wʉhʉpʉ masare buhea nihre tina —ni yahuha. ");
INSERT INTO gvc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","To ã nichʉ tʉhoro, surara pʉhtoro, to surara mehne waha, Jesu to cũrinare pari turi ñaha taha tjoa. Wiho mejeta tinare surara tuhtieraha. Ã jia tinare cjãborina jipahta, masare cuia cjãeraha tinare. “Ahrinare mari cjãchʉ paina masa sehe tãa mehne docaahca marine”, ni tʉhotuha tina surara sehe. ");
INSERT INTO gvc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ã jia tinare na ta, pʉhtoa panoi duhu dapoha tina. Ti ã na wihi dapochʉ sacerdotea pʉhtoro tinare õ sehe ni tuhtiha: ");
INSERT INTO gvc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Mʉsare sã tuaro dutimahi. “Jesu yare buhena tjiga”, nimahi sã mʉsare. Sã ã nipachʉta mʉsa sehe jipihtina Jerusalẽ macainare buhehre mʉsa. Jesu to yariari buhiri, sãre buhiri tichʉ yoa duana nica mʉsa —niha pʉhtoro sehe. ");
INSERT INTO gvc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","To ã nichʉ tʉhoro Pedro sehe paina Jesu to cũrina mehne õ sehe ni yʉhtiha: —Cohamacʉ to dutiri sehere yoa mʉhtanahtja. Ã jina baharo Cohamacʉ cahmachʉ masa ti dutiare yoanahtja. ");
INSERT INTO gvc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Cohamacʉ, mari coyea panopʉ macaina pʉhtoro, Jesure masori jire. Tirota jira mʉsa crusapʉ cjã puha wajã dutiriro. ");
INSERT INTO gvc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jesure “Noariro jira” ni, to poto bʉhʉsehei duji dutihre Jesure Cohamacʉ sehe. Ã jiro Jesu masa pʉhtoro, masare masoriro jiro, Israe masare ti ñaa yoarire cahyaina ji dutiro, ti ñaa yoari buhirire cohã duara Jesu. ");
INSERT INTO gvc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ã jina sã sehe Jesu to yoarire ñʉrina jina tíre yahuja sã. Espíritu Santo tíre ñʉriro jiro yahura tiro cʉ̃hʉ. Tirore Espíritu Santore Cohamacʉ warocahre. Jipihtina Cohamacʉ dutiare yoainare tiro Espíritu Santore wahre —ni yahuha tinare. ");
INSERT INTO gvc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","To ã nichʉ tʉhoa pʉhtoa sehe sua yʉhdʉaha. Ã suaa, tina Jesu to cũrinare wajã duamaha. ");
INSERT INTO gvc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wiho mejeta Gamalie, fariseo curua macariro tói jiro tinare wajã dutiro taro nieraha. Tiro pʉhtoa mehne macariro, dutiare buheriro to jichʉ, masa tirore ño payoa tiha. Tiro Jesu to cũrinare mahanocã cohta dutiro pa sehepʉ tinare naa wahcã dutiha surarare. ");
INSERT INTO gvc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ti ã naari baharo tiro õ sehe ni yahuha masare: —Mʉsa Israe masa, ahrinare mʉsa yoahtire noano tʉhotuga “Mʉsapʉ wajãri”, nina. ");
INSERT INTO gvc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wacũga Teuda cjirore. Tiro to basi “Masare yʉhdʉrʉcariro jija yʉhʉ”, nire masare. To ã yoachʉ ñʉa, masa payʉ cuatro cientos masa tiro mehne macaina tjuare. Baharo paina sehe tirore wajãri jire. To buheare buherina cjiri sehe waha sitea wahari jire. Ã jia tina cjiri mipʉre mariahna. ");
INSERT INTO gvc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Baharo masare ti quihõri pja jichʉ Galilea macariro Juda wama tiriro cjiro masare to buhechʉ tiro mehne masa payʉ tjuare. Tiro cʉ̃hʉ yariaa wahari jire. Ã yoa to yaina jipihtina waha sitea wahari jire. ");
INSERT INTO gvc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ã nicʉ mʉsare mipʉ ahrire nii nija. Ã ñʉnocahga ahrinare Jesu yare yahuinare. Ã yoa ahri buhea, ahrina ti ya buhea Cohamacʉ ya buhea jieraa, pihtia wahaahca Teuda cʉ̃hʉ ti ya buhea ti pihtiriro seheta. ");
INSERT INTO gvc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wiho mejeta ahri Cohamacʉ ya buhea jia, ne pihtisi. Ahri buhea Cohamacʉ ya jichʉ ne ahrire butichʉ yoa masierara mʉsa. Mʉsa ahrire butichʉ yoa duana Cohamacʉ mehne cahmachena niboca mʉsa —niha Gamalie tinare. ");
INSERT INTO gvc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","To ã ni yahuchʉ tʉhoa, “Potocã tjira”, ni tʉhotuha masa. Ã jia tina Jesu to cũrinare pjiroca, ti wihichʉ ñʉa, tinare tjanaha. “Jesu yare buhe namoena tjiga mʉsa”, ni tuhsʉ, tinare waha dutiha. ");
INSERT INTO gvc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ti ã waha dutichʉ tʉhoa tina pʉhtoa cahapʉ jirina cjiri wahaa wahaha. Jesu yare ti yoari buhiri ñano yʉhdʉa tuaro wahcheha Jesu to cũrina. ");
INSERT INTO gvc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ã jia dachoripe Cohamacʉ wʉhʉ cahai jia waparihi, ti ya wʉhʉsei Cristo yare buhea, yahua tiha tina. ");
INSERT INTO gvc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tí dachorire Jesu yaina payʉ wahaha. Wiho mejeta ti ã waharo wato, cʉ̃ curua macaina judio masa jipahta, pa sehepʉ masa bajuaina griego ya durucuina jiha. Ã jia tina tóita masa bajuaina hebreo ya durucuinare õ sehe ni tʉhotu, nureha: “Dachoripe masare yoadohoare ti witichʉ, mari griego ya durucuina wapewahya numia sehere daacã waro wara”, ni tʉhotu, nure cohtaha. ");
INSERT INTO gvc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ti ã nurechʉ masia, Jesu cũrina, doce jiina sehe jipihtina Jesu yainare ti cahapʉ pjiroca, õ sehe ni yahuha tinare: —Sã Cohamacʉ yare buheina jija. Tíre duhu, masare yoadohoare witiborina sã jirucuchʉ tó wahaerara. ");
INSERT INTO gvc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mʉsa sã coyea, siete mʉare, paina noaina ti niinare Espíritu Santo to dutirire yoainare, noano tʉho masiinare macaga. Tinare ahri dahraare cũga mʉsa. ");
INSERT INTO gvc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wiho mejeta sã sehe dachoripe Cohamacʉre sini mʉja, Cohamacʉ yare painare buhenahca —ni yahuha tina Jesu to cũrina. ");
INSERT INTO gvc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ti ã nichʉ tʉhoa, “Jai. Ãta yoajihna”, niha tina jipihtina Jesu yaina. Baharo Estebãre Cristore wacũ tuarirore, Espíritu Santo to dutiare yoarirore beseha tina. Ã jichʉ Felipere, Prócorore, Nicanore, Timore, Parmenare, Nicola cʉ̃hʉre Jesu yainare yoadohohtinare beseha tina. Nicola sehe Antioquía macariro, judio masʉno jierariro, judio masa ya buheare cahmano, tina mehne sãariro jiha. ");
INSERT INTO gvc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tinare bese tuhsʉ, ti beserinare Jesu cũrina cahai na wihiha tina. Ti ã na wihichʉ ñʉa, tina Jesu cũrina sehe tinare Cohamacʉre sini payo tuhsʉ, ti dapu poca bui ti wamomacarine duhu payoha. ");
INSERT INTO gvc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ã yoa Jesu yaina painapʉre Cohamacʉ yare yahu site pahñoa wahaha. Ã jia Jerusalẽpʉ jiina paina Jesu yaina payʉ waha namoha. Sacerdotea cʉ̃hʉ payʉ Jesu yaina wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ã yoa cʉ̃iro masare yoadohoare witi cohtariro Estebã sehe Cohamacʉ to noano yoariro ji, Cohamacʉ tuaare cjʉariro jiha. Ã jiro tiro Cohamacʉ tuaa mehne yoa ño mʉjaha masa ti ñʉrocaroi. ");
INSERT INTO gvc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wiho mejeta judio masa buheri wʉhʉ macaina tirore ñʉ tuhti, to yahuchʉ, tirore soro ni cohtaha. Tina soro ni cohtaina “Cahamaca ji, wijarina cjiri”, wama tiri curua macaina sehe jiha. Ã jia Cirene macaina, Alejandría macaina, Cilicia macaina, ã jichʉ Asia macaina cʉ̃hʉ jiha tina. ");
INSERT INTO gvc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tirore soro ni cohtapahta, Espíritu Santo to masia mehne Estebã to durucu mihnichʉ, tina to buheare ti dohse soro ni yʉhtiboare wacũ bocaeraha. ");
INSERT INTO gvc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ti soro ni yʉhtiboare wacũ bocaeraa, tina painare mahño dutia, wapaha tinare. Ti ã mahño dutichʉ õ sehe ni yahusãmaha tina: —Ahriro Cohamacʉre, ã jichʉ Moise cjirore Cohamacʉ to cũri dutia cʉ̃hʉre to ñano durucuchʉ sã tʉhohi —ni yahusãmaha tina mahñoina Estebãre. ");
INSERT INTO gvc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ti ã nichʉ tʉhoa masa, judio masa buheina, bʉcʉna cʉ̃hʉ tiro mehne suaha. Ã jia tina Estebãre ñaha, ti pʉhtoa cahapʉ naaha tirore. ");
INSERT INTO gvc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Ã yoaa tina painare mahño dutiha: —Ahriro dachoripe Cohamacʉ wʉhʉre, to dutia cʉ̃hʉre ñano durucuriro jira. Tʉhohi sã tirore to õ sehe nichʉ: “Jesu Nazare macariro Cohamacʉ wʉhʉre cohã, ã yoa Moise dutiri cjiri, marine to yahu cũri cjirire cohtotarohca”, nihre Estebã sã tʉhochʉ —ni mahño yahusãmaha tina. ");
INSERT INTO gvc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ã jia jipihtina tói dujiina Estebãre noano ñʉroca õ, to wʉhdʉare ñʉha tina. Anjo yoaro sehe bajuha to wʉhdʉa. ");
INSERT INTO gvc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ã yoa sacerdotea bui pʉhtoro õ sehe ni sinitu ñʉha Estebãre: —¿Ahrina ti nia potocã tjijari? —ni sinitu ñʉha tiro Estebãre. ");
INSERT INTO gvc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","To ã nichʉ tʉhoro, Estebã sehe tinare õ sehe ni yʉhtiha: —Coyea, bʉcʉna sã pʉcʉsʉma tʉhoga. Abrahã mari ñʉchʉ cjiro panopʉ macariro Mesopotamiapʉ to jisinichʉ, Harãpʉ to jihto pano, Cohamacʉ tuariro si siteriro sehe tirore Abrahãre bajuaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ã bajuaro, Cohamacʉ õ sehe ni yahua tiha tirore: “Mʉ ya yahpare, ã jichʉ mʉ coyea poto cʉ̃hʉre duhunoca, wahaga. Pa yahpa, yʉ mʉhʉre ñohti yahpapʉre wahaga”, nia tiha Cohamacʉ Abrahãre. ");
INSERT INTO gvc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","To ã nichʉ tʉhoro Abrahã cʉ̃hʉ Caldea yahpai jiina wijaa, Harãpʉ sʉ, jisinia tiha. Abrahã pʉcʉro to yariari baharo, tiro cʉ̃hʉ tí macai wijaa, ahri yahpa, mipʉ mʉsa jiri yahpapʉ Cohamacʉ yoadohoro mehne taa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cohamacʉ Abrahãre õpʉ sʉho na taparota, tirore dói “Ahri yahpa pʉro jiga”, ni cũerasinia tiha. Ne mahanocã ahri yahpare, “Pʉ tiga mʉhʉ”, ni dutierasinia tiha tiro. Wiho mejeta Abrahã pohna marieriro to jipachʉta, Cohamacʉ sehe tirore õ sehe ni yahu mʉhtaa tiha. “Mʉhʉre ã jichʉ mʉ panamana, pa tjuru macainapʉ cʉ̃hʉre ahri yahpare waihtja”, nia tiha Cohamacʉ Abrahãre. ");
INSERT INTO gvc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ã ninota õ sehe ni yahu namoa tiha Cohamacʉ. “Mʉ panamana pa tjuru macaina pa yahpapʉ waha, tópʉ paina cahapʉ jia, ti cahamaca jiahca tina. Tuhsʉ, cuatro cientos cʉhmari waro tó macaina ñano yoapeahca mʉ panamanare. ");
INSERT INTO gvc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ã jicʉ tó macainare ti ã yoari buhiri buhiri dahreihtja yʉhʉ. Yʉ ã yoari baharo mʉ panamana ji turiaina ahri yahpapʉ wihi, yʉhʉre ño payohtina jiahca tina”, nia tiha Cohamacʉ Abrahãre. ");
INSERT INTO gvc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","To ã ni yahu cũare ti noano wacũrucuhto sehe, õ sehe yoa turia wahcã dutiha tirore. Mʉno pjacʉre mahanocã cahsarocãre yihso na dutia tiha tirore. Ã jiro ocho dachori to macʉno Isaare to pohna tiri baharo, mahanocã cahsarocãre yihso naa tiha tiro Isaa pjacʉre. Baharo Isaa Jacobore pohna ti, to pjacʉ cʉ̃hʉre mahanocã cahsarocãre yihso naa tiha. Baharo Jacobo cʉ̃hʉ doce to pohnare ã dihta yoaa tiha ti pjacʉrire. Tina doce mʉa sehe tópe curuari, mari masa curuari dahpoto macaina cjihti jia tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ã yoa baharo, tina Jacobo pohna, mari ñʉchʉsʉma cjiri, ti bahʉro Josére pahsu tia, paina ti cahamacʉno cjihtore duanocaa tiha Egiptopʉ wahainare. Ti ã yoapachʉta, Cohamacʉ Josére yoadohoa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Jipihti tí to ñano yʉhdʉare Cohamacʉ tirore noano yʉhdʉchʉ yoaa tiha. Cohamacʉ tirore noano tʉho masichʉ yoaa tiha. Ã yoa faraõ Egipto macaina pʉhtoro sehere Josére ñʉ ji coachʉ yoaa tiha. Ã jiro faraõ sehe Josére pʉhto sõa tiha, tiro mehne masare dutihtiro cjihtore. Tirore faraõ ya wʉhʉ cʉ̃hʉre pʉhtoro cũa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ã yoa tí pjapʉre Egiptopʉ, Canaapʉ cʉ̃hʉre paró ne coro taeraa, yahpa sehe wʉaa sãa wahaa tiha. To ã wʉa sãa wahachʉ, masa ti toamari cʉ̃hʉ ñai pihtia wahaa tiha. Ã jia mari ñʉchʉsʉma cjiri ñano yʉhdʉa, ti chʉboare ne bocaeraa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Wiho mejeta Egiptopʉ “Trigo jiyuhca”, ti nichʉ tʉhoro, Jacobo sehe to pohnare, mari ñʉchʉsʉma cjirire tópʉ coã warocaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Baharo pari turi to warocarina cjiri Egiptopʉ ti sʉchʉ tjoa, José to wahmisʉmare “Mʉsa bahʉta jija yʉhʉ”, ni yahu, tinare masichʉ yoaa tiha. Tí pja pʉhtoro faraõ sehe José coyeare coã ñʉno nia tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Baharo José to wahmisʉmare, ti pʉcʉro Jacobore, ã jichʉ jipihtina ti coyea cʉ̃hʉre cahmarocaa tiha. To coyea setenta y cinco masa jia tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","To macʉno to pjirocachʉ tʉhoro Jacobo cjiro wahaa tiha Egiptopʉ to macʉno cahapʉ. To macʉno cahapʉ jiro, tiro yariaa wahaa tiha. Ã yoa to pohna, mari ñʉchʉsʉma cjiri cʉ̃hʉ tópʉ yaria pihtia wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tina ti yariari baharo, ti coyea ti pjacʉri cjirire Siquẽ wama tiropʉ naa tiha. Tópʉ na sʉ, tãa coparipʉ Abrahã Hamor pohnare niñeru mehne to nuchʉri yahpapʉ tina ti pjacʉri cjirire cũa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ã yoa Cohamacʉ Abrahãre “Canaa yahpare waihtja mʉhʉre”, to ni cũriro cjiro mʉ sʉro cahachʉ, Abrahã panamana, Israe masa, Egiptoi jisinia payʉ wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ti ã payʉ wahari baharo, pairo faraõ, Egipto masa pʉhtoro José cjirore masierariro sãa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tiro mari coyeare mahño, ñano yoa, ti pohnare mʉa pohnare wajã dua, cohãnoca dutia tiha tinacãre. Wahma bajuainacãre cohã dutia tiha “Tinacã yariajaro”, nino. ");
INSERT INTO gvc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","To ã yoaro watoi Moise cjihto sehe masa bajuaa tiha. Tirocã noariro, Cohamacʉ to noano ñʉ jicoariro jia tiha. Tia sʉ̃ waro to pʉcʉsʉma tirocãre noano ñʉ wihboa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ã jiro Moisere nʉo namo masieraa, diapʉ tirocãre pʉhʉroi comape mehne ti bihari pʉhʉroi poho bʉroha. Ti ã yoachʉ faraõ macono tirocãre ñʉ boca, na maja, to macʉnore yoaro seheta cjʉaa tiha tirocãre. ");
INSERT INTO gvc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ã jia tina Egipto macaina, noano masiina ya jipihtiare Moisere buhe bʉcʉoa tiha. Baharo, ne cuiro marieno durucuriro, pʉhtoa jia tia cʉ̃hʉre mihni yʉhdʉrʉcʉ sʉriro wahaa tiha Moise. ");
INSERT INTO gvc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ã yoa tiro cuarenta cʉhmari cjʉaro to coyea Israe masare ñʉ duaro ti cahapʉ ñʉno wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tópʉ ñʉno sʉro, Egipto macariro cʉ̃iro Moise coyeirore to ñano yoachʉ ñʉa tiha. Tiro to ñano yoaborirore dʉcata duaro, Egipto macariro sehere wajã cohãnocaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ã wajã cohãno, Moise õ sehe ni tʉhotua timaha. “Yʉ coyea ti coyeirore yʉ yoadohochʉ ñʉa ‘Cohamacʉ marine noano yʉhdʉchʉ yoa dutiro warocare ahrirore’, ni tʉhotuahca yʉ coyea”, ni tʉhotua timaha Moise. Wiho mejeta tina sehe ne ã ni tʉhotueraa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pa dachoi Moise to coyeare pʉaro ti basi cahmacheinare boca sʉa tiha. Ã boca sʉro, tinare yahu duaro tinare õ sehe ni yahua timaha: “¿Mʉsa basi jipanahta cahmachejari mʉsa?” ni yahua timaha Moise tinare. ");
INSERT INTO gvc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","To ã ni yahuchʉ tʉhoro, cʉ̃iro to coyeirore ñano yoariro sehe Moisere tjurocaa tiha. “Mʉhʉ sã pʉhtoro jierara. Sãre yahuboriro jierara mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Canʉre Egipto macarirore mʉ wajãriro seheta yʉhʉ cʉ̃hʉre wajã duacʉ nijari mʉhʉ?” nia tiha tiro Moisere. ");
INSERT INTO gvc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","To ã nichʉ Moise tʉho cʉaa waha, mʉrocaa duhti wahcã, Madiã yahpapʉ wahaa wahaa tiha. Tópʉre pa sehe macariro jiparota, numino boca, pʉaro pohna tia tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ã yoa Moise cuarenta cʉhmari waro tói to jiri baharo, Sinaí wama tidʉ tʉ̃cʉ cahai masa marienopʉ to jichʉ anjo tirore bajuaa tiha. Anjo sehe mahadʉcã jʉ̃ri picha pohnai bajuaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tʉ yucʉcʉcãpʉ to jʉ̃rucuchʉ ñʉno, Moise ñʉ cʉaa wahaa tiha. Tí pichacare cahacã noano to ñʉ wahcãchʉ waroi Cohamacʉ to durucuchʉ tʉhoa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Cohamacʉ jija yʉhʉ. Mʉ ñʉchʉsʉma cjiri, Abrahã cjiro, Isaa cjiro, Jacobo cjiro ti ño payoriro jija”, nia tiha Cohamacʉ Moisere. To ã nichʉ tʉhoro Moise sehe tetere, ne ñʉ wahcõeraa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Cohamacʉ õ sehe ni durucu namoa tiha tirore. “Yʉhʉ ñaa marieriro yʉ õi jiro wato, mʉ ducuri yahpa sehe wiho jiri yahpa jierara. Ã jicʉ mʉ dahpo suhtire tjuwe cũga. ");
INSERT INTO gvc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ã yoa yʉ yaina masa Egiptopʉ ti ñano yʉhdʉchʉ ñʉja. Ti tiichʉ tʉhoja. Ã jicʉ õpʉre wihija yʉhʉ, tinare yʉhdʉ witichʉ yoai tai. Ti ã wahachʉ, ñʉcʉ wahaga mʉhʉ cʉ̃hʉ. Egiptopʉ mʉhʉre warocaihtja. Tinare na wioi wahaga”, nia tiha Cohamacʉ Moisere. ");
INSERT INTO gvc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Tó panopʉ tina sehe mari coyea, Israe masa Moisere cahmaeraa tiha. “Mʉhʉ sã pʉhtoro jierara. Mʉhʉ sãre yoadohoboriro jierara”, ni tuhtia tiha tina tirore. Wiho mejeta baharo, Cohamacʉ ti ã niriro cjirore Egiptopʉ warocaa tiha, mari coyea Israe masare yʉhdʉ witichʉ yoahtiro, ã jichʉ ti pʉhtoro jihtiro cjihtore. Ã yoa anjo, tirore jʉ̃dʉpʉ bajuariro sehe to ã yoahtire yahua tiha tirore. ");
INSERT INTO gvc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moise jia tiha mari coyea, Israe masare Egiptopʉ jiinare na wioriro. Tinare na wioro, Egiptopʉ Cohamacʉ tuaa mehne tiro sehe yoa ño dʉcaa tiha tópʉ jiinare. Pjiri ma sohãri mapʉ ãta yoa ñoa tiha tjoa. Baharopʉ masa marienopʉ cʉ̃hʉre cuarenta cʉhmari waro Cohamacʉ tuaa mehne yoa ño mʉjaa tiha tiro to masare. ");
INSERT INTO gvc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ã yoa Moise cjiro jia tiha mari coyea, Israe masare õ sehe ni yahuriro: “Cohamacʉ cʉ̃iro mʉsa coyeiro, to yare yahu mʉhtahtiro, yʉ yoaro sehe jirirore warocarohca mʉsare”, nia tiha Moise tinare. ");
INSERT INTO gvc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moise masa marienopʉ mari coyea Israe masa mehne jia tiha. Tuhsʉ, Sinaí wama tidʉ tʉ̃cʉpʉ ti cahmachuchʉ tirore yahuriro anjo mehne jia tiha. Ã yoa mari ñʉchʉsʉma panopʉ macaina cjiri mehne jia tiha tiro. Cohamacʉ to dutiare cũriro jia tiha Moise. ");
INSERT INTO gvc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","’Ã jia tí dutiare tʉ̃cʉi Moisere to cũno watoi mari ñʉchʉsʉma cjiri Egiptopʉ tjua duaa Moisere yʉhdʉrʉcaa tiha. Tina tirore cahmaeraa tiha. Ã cahmaeraa tina Moise cjiro wahminore Aarõ wama tiriro cjirore õ sehe nia tiha: “Paina cohamanare yoaga mari yaina cjihti. Tina mari wahahti mahare marine sʉho naahca. ¿Wiho mejeta marine Egiptopʉ jiinare na tariro Moise dohse wahari tiro? Masieraja sã”, nia tiha tina. ");
INSERT INTO gvc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ã jia tí dachorire tina wachʉ masʉre uru mehne yoaa tiha. Ã yoa tuhsʉ, tina wahiquinare wajã, ti yoariro cjiro cahai na ta, ño payoa tiha tirore. Ã jia tina ti yoariro cjirore wachʉre ñʉ, wahche, bose nʉmʉ yoaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wachʉre ti ño payochʉ ñʉno, Cohamacʉ tinare cohã wahcãa wahaa timaha. “Yʉhʉre cohã, mʉanopʉ bajuaa, sʉ̃ dacho macariro, sʉ̃ ñami macariro, ã yoa ñahpichoha poca cʉ̃hʉre ño payowahnojaro”, nino cohã wahcãa wahaa timaha. Cohamacʉ yare yahu mʉhtaina cjiri ã ni joaa tiha: “Mʉsa Israe masa, yʉhʉre nu ñano yoare. Masa marienopʉ cuarenta cʉhmari waro jina wahiquinare mʉsa wajãinare mʉsa wajã, jʉ̃ wa mʉopanahta, yʉhʉre mʉsa ño payoboriro seheta yoamare mʉsa. Wiho mejeta yʉhʉ sehere mʉsa ño payoerare. ");
INSERT INTO gvc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ã jina mʉsa Molo wama tiri masʉre ño payoina jiina, tí masʉre ño payori wʉhʉre cjʉare mʉsa. Ã yoa pairo cohamacʉ ñahpichohaca Refã wama tiria to masʉre mʉsa yoariare mʉsa cjʉare tjoa. Tí masʉrine mʉsa yoarire mʉsa ño payore. Mʉsa ã yoari buhiri mʉsare Babilonia sie sehepʉ cohãrocaihtja yʉhʉ”, ni yahu joaa tiha Cohamacʉ yare yahu mʉhtaina cjiri. ");
INSERT INTO gvc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ã jia masa marienopʉ Cohamacʉ masa mehne to jiri wʉhʉre wahiquina cahsari mehne ti yoari wʉhʉre cjʉaa tiha mari ñʉchʉsʉma cjiri panopʉ macaina. Tí wʉhʉ Cohamacʉ masa mehne to durucuri wʉhʉ jia tiha. Tí wʉhʉpʉ Cohamacʉ dutia to joaa pjĩni tãa pjĩni jia tiha. Tí wʉhʉre Cohamacʉ Moisere to ñoriro seheta, “Õ sehe yoaga”, to ni yoa dutiriro seheta yoaa, tí wʉhʉre cjʉaa tiha tina. ");
INSERT INTO gvc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ã yoa ti panamanapʉ cʉ̃hʉ cjʉa turia nʉnʉ tia tiha tí wʉhʉre, wahiquina cahsari mehne ti yoari wʉhʉre. Baharo mari ñʉchʉsʉma cjiri Josué mehne Cohamacʉ mari coyea Israe masare to cũhti yahpapʉre, ahri yahpapʉre pʉ tia taha. Ti pʉ tia tachʉ ahri yahpai ji mʉhtaina cjirire Cohamacʉ cohãnocaa tiha. Tí pjare Cohamacʉre ti ño payori wʉhʉre na taa, cjʉaa tiha tina ahri yahpapʉ, mipʉre mari jiri yahpapʉ. Pʉ Davi cjiro to jiri tjurupʉ cjʉa batoa tiha tí wʉhʉre. ");
INSERT INTO gvc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tiro Davi cjiro sehe Cohamacʉre wahchechʉ yoariro jia tiha. Cohamacʉ ya wʉhʉ cjihtore pa wʉhʉ tiro yoa duaro, sinia timaha Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","To ã sinipachʉta Salomopʉ Cohamacʉ ya wʉhʉ sehere yoaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","To ã yoapachʉta Cohamacʉ Jipihtina Bui Jiriro sehe masa ti yoari wʉhʉpʉre jierara. Õ sehe nia tiha Cohamacʉ yare yahu mʉhtariro cjiro: ");
INSERT INTO gvc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ ‘Mʉano yʉ dujiro jira. Tói dujicʉ dutija yʉhʉ. Ã jiro yahpa sehe yʉ dahporire duhu payoro yoaro sehe jira. Yʉhʉ tua yʉhdʉariro jija. Yʉ ya wʉhʉ cjihtore yoa masierara mʉsa. Cohamacʉ yʉ jichʉ yʉ jihti wʉhʉre mʉsa yoa masierara. ");
INSERT INTO gvc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yʉ basi ahri yahpare jipihtiro yoahi yʉhʉ’, ni durucua tiha Cohamacʉ”, ni joaa tiha Cohamacʉ yare yahu mʉhtariro cjiro. ");
INSERT INTO gvc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Mʉsa Cohamacʉ yare tʉhopanahta, tirore yʉhti duaerara. Cohamacʉre masieraina yoaro sehe tʉhotuina baro jira mʉsa. Espíritu Santore yʉhdʉrʉca yʉhdʉara mʉsa. Mʉsa ñʉchʉsʉma cjiri ti yoariro cjiro seheta yoara mʉsa cʉ̃hʉ. ");
INSERT INTO gvc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mʉsa ñʉchʉsʉma cjiri jipihtina Cohamacʉ yare yahu mʉhtaina cjirire ñano yoaa tiha. Tina Cohamacʉ yare yahu mʉhtaina cjiri “Baharo cʉ̃iro ñaa buhiri Marieriro tarohca”, ti ni yahu quihõ mʉhtachʉ tʉhoa, mʉsa ñʉchʉsʉma cjiri sehe tinare wajãa tiha. Ã yoa mipʉ cʉ̃hʉre tiro “Ñaa buhiri Marieriro”, tó panopʉ ti niyuriro sehe õpʉ to wihichʉ, “Mʉhʉ mehne macaina jija”, ni ji mahño, tirore wajãhre. ");
INSERT INTO gvc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Cohamacʉ dutiare anjoa sehe yahu turia timaha mʉsare. Ti ã yahu turiachʉ mʉsa tí dutiare cjʉamaha. Wiho mejeta tí dutiare yʉhdʉrʉcara mʉsa —niha Estebã. ");
INSERT INTO gvc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","To ã nichʉ tʉhoa tina sehe tuaro suaha. Ã tuaro suaa, cuaina wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ti ã suapachʉta Estebã sehe Espíritu Santo mehne wacũ tuariro to tuaa mehne mʉanopʉ ñʉroca mʉo, Cohamacʉ si siteare ñʉha. Ã yoaro Cohamacʉ poto bʉhʉsehei Jesu to ducuchʉ cʉ̃hʉre ñʉha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ã ñʉroca mʉono, õ sehe niha: —Ñʉ mʉoga mʉsa. Mʉanopʉ mahanocã to tjuwe mʉachʉ, Jesu Cohamacʉ to warocariro Cohamacʉ poto bʉhʉsehei to ducuchʉ ñʉja yʉhʉ —niha Estebã tinare. ");
INSERT INTO gvc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","To ã nichʉ tʉhoata tina tuaro sañurucu, ti cahmo coparire bihanoca, cʉ̃no potori tiro cahapʉ mʉroca wahcã, tirore ñahaha. ");
INSERT INTO gvc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ñaha tuhsʉ, tirore na wahcã, tí maca dʉhtʉ cahapʉ cohãha tirore. Ã jia tãa poca mehne doca wajãha tirore. Ti ã wajãhto pano tirore yahusãrina tirore tãa poca mehne docahtina ti bui sãa suhtire tjuwe na, wahmʉnore Saulo wama tirirore ti suhtire cjʉabasa dutiha. ");
INSERT INTO gvc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Estebãre ti tãa docaro watoi, sinino sehe õ sehe niha tiro: —Jesu, yʉ pʉhtoro yʉ catiare naga —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ni tuhsʉ, tiro na tuhcua caha sʉ, õ sehe ni tuaro sañurucuha: —Pʉhtoro Jesu, ahrina mipʉ yʉhʉre ti wajãri buhiri tinare buhiri dahrei tjia —ni sañurucuha Estebã. Ã ni sañurucu batoarota, yariaa wahaha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Estebã to ã yariachʉ ñʉno, “Noana”, niha Saulo sehe. Tí dachoreta Jesu yainare Jerusalẽ macainare ñano yoa dʉcaha Saulo mehne macaina sehe. Ti ã yoa dʉcachʉ Jesu yaina Judea yahpapʉ, Samaria yahpapʉ yoaropʉ duhti site wahcãa wahaha. Ti pʉhtoa, Jesu to cũrina dihta wahaeraha. ");
INSERT INTO gvc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ã yoa paina Cohamacʉre ño payoina Estebã pjacʉ cjirore tãca copapʉ, duhu sãa, tiro cjirore tuaro tii payoha tiro cjirore tina. ");
INSERT INTO gvc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wiho mejeta Saulo sehe Jesu yainare ñabiaro yoaa timaha. Tiro ti wʉhʉsepʉ sãa, mʉare, numiare ñaha wahcã, peresupʉ biha dapoa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ã yoa yoaropʉ waha siteina cjiri nohoi ti waharoi Jesu yare buhea tiha. ");
INSERT INTO gvc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Cʉ̃iro tina mehne macariro Felipe cʉ̃ maca, Samaria wama tiri yahpai jiri macapʉ sʉ, Cristo masare yʉhdoriro ya quitire buheha tí maca macainare. ");
INSERT INTO gvc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","To ã buhechʉ, tó macaina sehe tirore tʉho cahmachu, Cohamacʉ to tuaa mehne to yoa ñochʉ ñʉha tina. Ã jia tina jipihtina cʉ̃no potori to yahuare noano tʉho nʉnʉa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Payʉ masa watĩa sãanohrina tiro cahai ti wihichʉ ñʉno, watĩa sehere tiro wijaa dutia tiha masapʉ jirinare. To wijaa dutichʉ, tina watĩa sehe tuaro sañurucu, wijaa wahaha. Tuhsʉ payʉ pjacʉ bʉhainare, pari yuri tiniina cʉ̃hʉre pjacʉ noaina wahachʉ yoaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","To ã yoa ñochʉ ñʉa tí maca macaina payʉ masa wahchea tiha. ");
INSERT INTO gvc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tí pjare Simo wama tiriro tí maca macariro yairo jiha. Ã jiro yaya ti yoarire yoa ñoa tiha Samaria macainare. To ã yoa ñochʉ ñʉa, tó macaina ñʉ cʉaa waha, tirore cua pisaro ñʉina jiha. —Yʉhʉ masi pahñoriro jija —nimaha Simo sehe tinare. ");
INSERT INTO gvc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","To ã yoachʉ ñʉa masa sehe õ sehe nia timaha: —Ahriro Cohamacʉ ya tuaare cjʉariro jira. Cohamacʉ yoaro sehe tuariro jira —nia timaha tirore masa, pʉhtoa mehne. Tina jipihtina noano tʉho nʉnʉha tirore. ");
INSERT INTO gvc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tiro yaya ti yoaa mehne yoari pja yoa ñoa tiha tinare. To ã yoa ñochʉ ñʉa tina cʉaa wahaha. Ã cʉaa waha, tina tirore ño payoa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wiho mejeta ti ã ño payopachʉta Felipe sehe pʉhtoro Cohamacʉ to sʉho jiare, Jesucristo yare noaa buheare yahuha. To ã yahuchʉ tina tirore noano tʉhoha. Ti ã noano tʉhochʉ ñʉno mʉare, numia cʉ̃hʉre bautisaha Felipe. ");
INSERT INTO gvc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ã jiro Simo cʉ̃hʉ Felipere noano tʉhoa tiha. Ã jiro tiro cʉ̃hʉre bautisaha. To ã yoari baharo Felipe mehne tjuaa tiha tiro. Felipe sehe Cohamacʉ tuaa mehne to yoa ñochʉ ñʉno Simo ñʉ cʉaa wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ã yoa Samaria yahpa macaina Cohamacʉ yare ti tuaro cahmachʉ tʉhoa Jerusalẽpʉ jiina tʉhorocaa tiha tinare. Ã ti cahmachʉ tʉhoa Pedrore, João cʉ̃hʉre warocaa tiha Samaria yahpapʉ. ");
INSERT INTO gvc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tópʉ sʉa Pedro cʉ̃hʉ Cohamacʉre siniha: “Ahrina Samaria yahpa macaina mʉhʉre ño payoinare mʉ Espíritu Santo sãajaro”, ni sini payoha tina Cohamacʉre. ");
INSERT INTO gvc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tina Samaria yahpa macaina Jesucristo yaina jia to bautisarina jiha. Tí dihtare masiha tina. Ã jiro Espíritu Santo tinare sãaerasiniha. ");
INSERT INTO gvc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ã jia Pedro, João mehne Samaria yahpa macainare ti wamomacarine ti dapupoca bui ti duhu payori baharo Espíritu Santo tinare sãari jire. ");
INSERT INTO gvc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ã yoa Pedro cʉ̃hʉ ti wamomacari mehne ti duhu payochʉ ñʉha Simo. Espíritu Santo tinare to sãachʉ cʉ̃hʉre ñʉha tiro. Ã ñʉriro jiro, tí tuaare cahmano niñeru mehne wapa duamaha. ");
INSERT INTO gvc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Õ sehe nimaha Simo: —Yʉhʉ cʉ̃hʉre waga ahri tuaare. Yʉhʉ cʉ̃hʉ yʉ wamomacari mehne masa dapupoca bui duhu payoi tai nija Espíritu Santo tinare to sãahto sehe. Ã jicʉ ahri yʉ yoahti wapare wapa duaja —nimaha Simo tinare. ");
INSERT INTO gvc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","To ã nichʉ tʉhoro Pedro õ sehe niha: —Mʉhʉ niñeru mehne Cohamacʉ ya tuaare mʉ nuchʉ duari buhiri mʉ niñeru mehneta pichacapʉ wahaga mʉhʉ. Cohamacʉ mʉ tʉhotuare masina. Mʉhʉ ñariro jisinina. ");
INSERT INTO gvc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ã jicʉ ahrire sã yoaare yoa masierara mʉhʉ. Ahri mʉ yoaa baro jierara. ");
INSERT INTO gvc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Paina ti cjʉaare ñʉcʉ suariro jira mʉhʉ. Ã jicʉ ñaa yoaare ne duhu masierara mʉhʉ. Ã jicʉ ahrire mʉ ñaa yoarire cahyaga mʉhʉ. Cohamacʉre mʉ ñaa tʉhotuare to bohto sehe siniga mʉhʉ. Mʉ ã yoachʉ ñʉno tiro mʉ ñaa buhirire boboca, pa tehe nino —ni yahuha Pedro tirore. ");
INSERT INTO gvc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","To ã nichʉ tʉhoro Simo õ sehe ni yʉhtiha tirore: —Yʉhʉre sini payoga mʉsa Cohamacʉre mʉ niriro sehe yʉ wahaerahto sehe. Tí buhiri pichacapʉ waha duaeraja yʉhʉ —niha Simo tirore. ");
INSERT INTO gvc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Baharo Pedro João mehne Cohamacʉ yare yahuha: “Jesu to masa mʉjachʉ ñʉhi sã”, ni payʉ Samaria yahpai jia macari macainare noaa buheare buheha. Tinare Cohamacʉ yare buhe tuhsʉ, Jerusalẽpʉ tjuaa wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ã yoa Cohamacʉ yairo anjo Felipere õ sehe ni yahuha: —Mipʉre sur sehepʉ wahaga. Jerusalẽ cahai jiri mahapʉ Gazapʉ wahari mahapʉ, masa marienopʉ jiri mahapʉ wahaga —ni yahuha anjo Felipere. ");
INSERT INTO gvc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","To ã nichʉ tʉhoro tiro sehe tí mahapʉ wahaa tiha. Baharo tí mahapʉ cʉ̃iro masʉnore piti bocaro taro niha. To piti bocahtiro jiha Etiopía yahpa macariro pʉhtoro. Tiro numiare cahmaerariro eunuco masʉno jiha. Ã jiro Candace wama tiricoro Etiopía macaricoro pʉhtorocoro yare niñerure jipihtiare ñʉ wihboriro jiha. Wiho jiriro jieraha. Tiro Jerusalẽpʉ Cohamacʉre ño payoro waha tuhsʉha. ");
INSERT INTO gvc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","To ya macapʉ tunuria mehne tjua taro tiapʉ wahaparota buhero niha. Cohamacʉ yare yahu mʉhtariro Isaia cjiro to joari pũre buhero niha. ");
INSERT INTO gvc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ã jiro Espíritu sehe Felipere õ sehe ni yahua tiha: —Siro tunuriapʉ wahariro cahapʉ wahaga —niha Espíritu tirore. ");
INSERT INTO gvc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","To ã nichʉ tʉhoro Felipe sehe tunuria cahapʉ mʉroca wahcã, Isaia cjiro to joarire Etiopía macariro to buhechʉ tʉhoha. Ã tʉhoro Felipe õ sehe ni sinituha tirore: —¿Mʉ buheare tʉho ñahajari mʉhʉ? —niha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","To ã nichʉ tʉhoro Etiopía macariro õ sehe ni yʉhtiha: —Pairo yʉhʉre yahu yʉhdoriro mariachʉ noano masieraja yʉhʉ. Õi yʉhʉre yahu dujii taga yʉ pari wahpa —ni yʉhtiha tiro Felipere. —Jai —ni nuju sʉha to cahai. ");
INSERT INTO gvc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ã yoa Cohamacʉ yare Etiopía macariro to buheri pũ õ sehe niha: “Ovejare ti ñaha wajãriro seheta tiro cʉ̃hʉre ñaha wajãahca masa. Ã jiro ovejacã to pjoare ti sachʉ to sañurucueraro seheta tiro masʉno cʉ̃hʉ dihta marieriro jirohca. ");
INSERT INTO gvc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tirore tina bʉjʉpeahca. Ã jia tiro to ñano yoaerapachʉta tina sehe ñano yoaahca tirore. Tiro ahri yahpapʉ to jichʉ tina tirore wajãahca. Ã jiro tiro pohna marieriro yariaa waharohca”, ni joaha tí pũpʉre. ");
INSERT INTO gvc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tí pũ to ã ni yahuchʉ ñʉno, Etiopía macariro õ sehe ni sinituha: —Yahuga yʉhʉre. ¿Õ sehe Isaia cjiro to niriro diro baro jicari ahriro? ¿Isaia cjiro to basi yahuro nicari? ¿O pairore yahuro nicari? —ni sinituha Etiopía macariro. ");
INSERT INTO gvc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","To ã ni sinitu ñʉchʉ tʉhoro Felipe sehe tí pũre ñʉ, Jesu yare yahuha Etiopía macarirore. ");
INSERT INTO gvc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ã yoa tina tia mehne waha, mácapʉ sʉha. —Ñʉga, õi máca jira. Ahri mácapʉ yʉhʉre bautisaga —niha Etiopía macariro. ");
INSERT INTO gvc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Jesure mʉ noano wacũ tuachʉ ñʉcʉ mʉhʉre bautisaihtja —niha Felipe tirore. —Jesure wacũ tuaja yʉhʉ. Tiro Cristo Cohamacʉ macʉno jira. Tíre noano masija yʉhʉ —niha Etiopía macariro. ");
INSERT INTO gvc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ã ninota tiro tunuria uturirore yʉsʉo dutiha. Tia to yʉsʉ caha sʉri baharo wijaaha tina. Wijaa, tí mácapʉ sʉ, ñumurʉcʉ sʉha tina. Tói ñumurʉcʉ sʉ, Felipe sehe tirore bautisaha. ");
INSERT INTO gvc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bautisa tuhsʉ ti maja sʉrʉcʉ sʉchʉ Cohamacʉ to Espíritu Felipere naa wahaha. To ã wahari baharo Etiopía macariro noano wahcheriro to ya yahpapʉ tjuaa wahaha. To ã yoari bato tichʉ ne pari turi Felipere ñʉeraha. ");
INSERT INTO gvc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ã yoa tuhsʉ Azotopʉ sʉha Felipe sehe. Tuhsʉ, payʉ macarine noaa buheare buheha masare. Pʉ Cesareapʉ buhe batoa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wiho mejeta tí pjare Saulo Jesu yainare ã ñʉ tuhtirucusinino, “Tinare wajãihtja” nino, tiro sacerdotea pʉhtoro cahapʉ wahaha. ");
INSERT INTO gvc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tópʉ sʉro tiro joaa pũrine õ sehe ni siniha sacerdotea pʉhtorore: —Joaa pũrine waga yʉhʉre yʉ tuahti pũri cjihtire. Tí pũripʉ mʉ wama mʉ joa payochʉ, yʉhʉ sehe tí pũri mehne, mʉ dutiro mehne Damascopʉ wahaihtja. Tópʉ sʉ, judio masa mari buhea wʉhʉsepʉ Jesu yaina mʉa, numia cʉ̃hʉre boca sʉcʉ, tinare ñaha dʉhte, õpʉ Jerusalẽpʉ na majare tjuaa taihtja —ni siniha Saulo sacerdotea pʉhtoare. ");
INSERT INTO gvc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ti pũrine na tuhsʉ, tiro waha, Damasco cahai to sʉro cahachʉ waro mʉanopʉ wacũenoca si siteroca boroha tirore. ");
INSERT INTO gvc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wacũenoca to ã si siteroca borochʉta tiro yahpapʉ bora caha sʉro, õ sehe ni durucuchʉ tʉhoha: —Saulo, Saulo, ¿dohseacʉ mʉhʉ yʉhʉre ñano yoajari? Mʉhʉ yʉhʉ mehne suacʉ yʉhʉre yʉhtieracʉ, mʉ basita ñano yʉhdʉra —nino coa taha. ");
INSERT INTO gvc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—Pʉhtoro, ¿diro baro jijari mʉhʉ? —ni sinitu ñʉha Saulo sehe. —Yʉhʉta jija Jesu, mʉ ñano yoarucuriro —niha Jesu Saulore. ");
INSERT INTO gvc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","To ã nichʉ õ sehe ni sinituha Saulo: —Pʉhtoro, ¿dohse yʉ yoachʉ cahmajari mʉhʉ? —niha Saulo. —Wahcãrʉcaga mʉhʉ. Macapʉ wahaga. Tí macapʉ mʉ sʉchʉ tó macariro mʉ yoahtire yahurohca mʉhʉre —niha Jesu Saulore. ");
INSERT INTO gvc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","To ã nichʉ Saulo mehne macaina sehe to durucua dihtare tʉhoha. Wiho mejeta Jesu sehere ñʉeraha. To ã wahachʉ ñʉa, cuia, tina durucu masieraha. ");
INSERT INTO gvc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ã jiro Saulo yahpapʉ coãriro wahcãrʉca, to ñʉchʉ to capari bajueraha. Ã jia tina to wamomacare ñaha, Damascopʉ tʉã wahcãa wahaha tirore. ");
INSERT INTO gvc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tópʉ sʉro, tiro tia dacho waro ne ñʉera, chʉera, ne sihniera tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ã yoa cʉ̃iro Jesu to buheriro Anania wama tiriro Damascoi jiha. Ã jiro Jesu bajua tiha Ananiare. Ã bajuaro õ sehe ni pisuha tirore: —Anania, ¿jimajari mʉhʉ? —niha Jesu. —Jimajã —ni yʉhtiha Anania tirore. ");
INSERT INTO gvc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","To ã nichʉ Jesu sehe õ sehe ni yahuha tirore: —Potori Maha wama tiri mahapʉ wahaga. Ã wahacʉ Juda ya wʉhʉpʉ cʉ̃iro Tarso macariro Saulo wama tirirore macaga. Tiro Cohamacʉre sinino nica. ");
INSERT INTO gvc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tiro cahãnopʉre tirore mʉ yoahtire ño tuhsʉhi yʉhʉ. Õ sehe jiare ñʉhre tiro: Mʉhʉ mʉ wamomacarine tiro bui duhu payo, to capari noaa wahachʉ ñʉhre tiro to cahãnopʉre —niha Jesu Ananiare. ");
INSERT INTO gvc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","To ã nichʉ tʉhoro Anania sehe õ sehe ni yʉhtiha: —Pʉhtoro, tiro mʉ yainare, noainare Jerusalẽ macainare nu ñano yoa mʉjayuhti. Payʉ masa yʉhʉre ã ni yahure. ");
INSERT INTO gvc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ã yoa õ cʉ̃hʉre tiro jipihtina mʉhʉre cahmainare peresu yoaro taro niyuhti. Sacerdotea pʉhtoa tirore ã yoa dutiyuhti —ni yʉhtiha Anania Jesure. ");
INSERT INTO gvc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","To ã nichʉ Jesu sehe õ sehe ni yahuha tirore: —Tiro Saulo sehe yʉ beseriro jira. Tiro yʉ ya buheare judio masa jierainare, ti pʉhtoare, ã jichʉ Israe masa cʉ̃hʉre buherohca. Ã jicʉ wahaga mʉhʉ. ");
INSERT INTO gvc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Payʉ tahari yʉ yare yoaro tiro ñano yʉhdʉrohca. Tíre tirore masichʉ yoaihtja —niha Jesu Ananiare. ");
INSERT INTO gvc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","To ã niri baharo Anania sehe waha, sʉ, Saulo to jiri wʉhʉpʉ sãaha. Sãa sʉ, to wamomacarine Saulo bui duhu payo, õ sehe ni yahuha tirore: —Coyeiro Saulo, mʉ capari mʉ ñʉhto sehe, Espíritu Santo mʉhʉ mehne to jihto sehe, to dutiriro seheta mʉ yoahto sehe, mari pʉhtoro Jesu sehe mahapʉ mʉhʉre bajuariro yʉhʉre warocahre —ni yahuha Anania Saulore. ");
INSERT INTO gvc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","To ã nichʉta to caparire wahi nʉtʉri yoaro sehe bajua to caparipʉ wahãa pahna borachʉ ñʉha Saulo. To ã ñʉ tuhsʉri baharo to wahcãrʉcʉ sʉchʉ pairo sehe tirore bautisaha. ");
INSERT INTO gvc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tirore to bautisa tuhsʉchʉ, tiro sehe chʉ, tuariro wahaha. Ã yoa Saulo mahaa dachoricã Damasco macaina Jesu yaina mehne jiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dói tí dachorita tiro judio masa buhea wʉhʉsepʉ sʉ, Jesu Cohamacʉ macʉno to jiare yahu dʉcaha masare. ");
INSERT INTO gvc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","To ã yahuchʉ ñʉa jipihtina tirore tʉhoina cʉaa wahaha. —Cho, ahriro Jerusalẽpʉre Cohamacʉ yainare Jesure cahmainare ñano yoariro cjiro jira. Ã yoa tirota jimana õ macaina Jesure cahmaina cʉ̃hʉre ñaha, dʉhte, sacerdotea pʉhtoare wiaboriro. Ã yoa duaro õpʉre tari jimahre tiro —niha masa tirore tʉhoina. ");
INSERT INTO gvc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wiho mejeta Saulo sehe cui tʉhoturo marieno buhe mihni wahcãa tiha. “Ahriro Jesu potocãta Cristo, marine yʉhdohtiro jira”, to ni yahu mihnichʉ, tó macaina judio masa ti ni yʉhti yʉhdʉrʉcaborirore bocaeraha. ");
INSERT INTO gvc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ã jia payʉ dachori baharo judio masa tirore wajã duaa, ti basi durucua tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wiho mejeta Saulo tirore ti wajã duachʉ masiha to basi. Tina tí macare sahrĩno tãa mehne ti yoari sahrĩno macaa sopacarire dachopʉre ñamipʉ cʉ̃hʉre cohtaa tiha tirore wajã duaa. ");
INSERT INTO gvc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ti ã wajã duachʉ ñʉa ñamipʉ Saulo buheina tirore pʉhʉro pjiri pʉhi na sãa, tí maca macari sahrĩno baharo bʉhʉsehei duhu boroha tirore. Tó sehe ti yoachʉ yʉhdʉha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ã yoa Saulo Jerusalẽpʉ sʉro, tópʉ Jesu yaina mehne tiro ji duamaha. Wiho mejeta tina tirore “Jesu buheriro jierara ahriro” nia, tirore cui niha. ");
INSERT INTO gvc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ti ã cuipachʉta Bernabé sehe tirore na wahcãha Jesu to cũrina cahapʉ. Ã jiro Saulo mahai Jesure to ñʉrire, Jesu Saulore to durucurire, ã jichʉ Damascopʉ cuiro marieno Jesu yare to buhe dʉcarire yahuha Bernabé sehe. ");
INSERT INTO gvc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","To ã ni yahuri baharo Saulo sehe tina mehne sãano, Jerusalẽpʉ tina mehne jia tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tiro cuiro marieno judio masare Jesu yare yahu yʉhdʉrʉcaro niha. Tina judio masa griego masa yare durucuina jiha. Ã yoa Saulo to ã yahu yʉhdʉrʉcachʉ, tina tirore wajã duamaha. ");
INSERT INTO gvc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ti ã wajã duachʉ ñʉa, Saulo mehne macaina Jesu yaina sehe tirore Cesareapʉ na duhti wahcãa wahaha. Tópʉ tirore sʉho jirucuma Tarsopʉ warocaha tirore. ");
INSERT INTO gvc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ã yoa jipihtiropʉ, Judea yahpapʉ, Galilea yahpapʉ, Samaria yahpapʉ cʉ̃hʉre Cohamacʉ yaina noano jia tiha. Tí pjare ne masa ñano yoaera tiha tinare. Ã jia noano buheha tina. Tina Cohamacʉ yare buhe, tirore masi namo, noano yʉhtia tiha. Ã yoa Cohamacʉre cua pisaro ñʉa tiha. Espíritu Santo tinare to yoadohochʉ tina sehe payʉ wahaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ã yoa Pedro jipihtia macaripʉ waharo, Jesu yaina Lida macaina cahapʉ cʉ̃hʉre sʉha tiro. ");
INSERT INTO gvc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tópʉ sʉro Enea wama tirirore boca sʉha. Enea pjacʉ bʉhariro jiro, ocho cʉhmari waro ti pũpaha cũriro coãa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ã jiro Pedro sehe tirore õ sehe niha: —Enea, Jesucristo mʉhʉre noariro wahachʉ yoara. Wahcãrʉcaga. Mʉ pũpaha coãri cahsarore cahnoga —niha Pedro tirore. To ã nichʉta tiro wahcãrʉcaha. ");
INSERT INTO gvc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ã jia jipihtina Lida macaina, Sarón macaina tirore ñʉa, tina ti ñaa yoaare duhu, Jesure wacũ tuaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ã yoa Jope wama tiri macai Jesure ño payoricoro Tabita wama tiricoro jiha. To wama Tabita griego ya dʉsero mehne Dorca jira. Ticoro noaare yoaro payʉ waa tiha pjacʉoinare. ");
INSERT INTO gvc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ã jiro tí pjare ticoro dohati wahcõ, yariaa wahaa tiha. To yariachʉ ñʉa, tina ticorore noano cosa, mʉano macari tahtiapʉ cũa tiha ticorore. ");
INSERT INTO gvc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida wama tiri maca Jope cahai jire. To ã jichʉ Jesu buheina Jope macaina Pedro Lidapʉ to jichʉ tʉhorocaa tiha. Ã tʉhorocaa, pʉaro warocaha Pedro cahapʉ. Tiro cahapʉ sʉa Pedrore õ sehe ni yahuha tina: —Soaro mehne sã jiropʉ wahaga —ni yahuha tina. ");
INSERT INTO gvc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ti ã nichʉ tʉhoro tina mehne wahaa wahaha tiro. Tópʉ tirore ti na sʉri baharo mʉano macari tahtiapʉ na mʉjaa wahaha tirore. Ã jia jipihtina wapewahya tiro cahai sʉrʉca, tiia tiha. Tabita tina mehne jisininopʉ payʉ suhtire yoaa tiha. Ã jia tina to yoari suhti cjirire ñoha Pedrore. ");
INSERT INTO gvc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wiho mejeta Pedro tinare tí tahtiapʉ jiinare wijaa dutiha. Ti wijaari baharo tiro na tuhcua caha sʉ, Cohamacʉre ticorore sini payoha. Ã jiro to pjacʉ cjirore majare ñʉ: —Tabita wahcãga —niha tiro. To ã nichʉta ticoro sehe ñʉ wahcõ, Pedrore ñʉ, wahcã nuju sʉha. ");
INSERT INTO gvc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","To wahcã nuju sʉchʉ ñʉ, tiro to wamomacare ñaha, tʉã wahcõ dapoha ticorore. Ã jiro tiro tó macainare Jesu yainare, wapewahyare pjiroca, ticorore catiricorore wiaha tinare. ");
INSERT INTO gvc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","To ã yoari baharo jipihtina Jope macaina tíre masia, payʉ masa Jesure wacũ tua dʉcaa tiha. ");
INSERT INTO gvc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Baharo Jopepʉ Simo wahiquina cahsarire cahnoriro mehne payʉ dachori Pedro tiro mehne jia tiha. ");
INSERT INTO gvc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ti pjare Cesareapʉ cʉ̃iro Cornelio wama tiriro jiha. Tiro cien surara pʉhtoro jiha. Tina surara sehe ti ya curua Italiano wama tiha. ");
INSERT INTO gvc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio to ya wʉhʉ macaina mehne judio masa jieraina jipahta, Cohamacʉre ño payoina, cua pisaro ñʉina jiha. Tiro judio masa pjacʉoinare yoadohoro payʉ waha. Ã yoa dachoripe tiro Cohamacʉre siniha. ");
INSERT INTO gvc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Cʉ̃ nʉmʉ ñamichahapʉ tres jichʉ Cohamacʉ yairo anjo tirore bajuaha. Ã bajuaro Cornelio cahapʉ sãaha. —Cornelio —niha anjo tirore. ");
INSERT INTO gvc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","To ã nichʉ tʉhoro Cornelio tirore ñʉ, cuiro õ sehe niha: —Pʉhtoro, ¿yabare cahmajari mʉhʉ? —niha tiro. —Masa pjacʉoinare mʉ warire, Cohamacʉre mʉ sinirire Cohamacʉ noano ñʉno nina. ");
INSERT INTO gvc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ã jicʉ Jopepʉ mʉ mʉare warocaga. Tópʉ Simo Pedro wama tiriro jira. Tirore na ta dutiga mʉ mʉare. ");
INSERT INTO gvc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tiro pairo Simo wahiquina cahsari cahnoriro cahai, pjiri ma dʉhtʉ cahai jiri wʉhʉi jira —niha anjo Corneliore. ");
INSERT INTO gvc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anjo ã ni