﻿USE sofia;
DROP TABLE IF EXISTS sofia.guz_vpl;
CREATE TABLE guz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guz_vpl WRITE;
INSERT INTO guz_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Agwo omochakano Nyasae agatonga igoro na ense, ");
INSERT INTO guz_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Bono ense tiyarenge na kieni kende, gose kende gionsi tikiareengeo, n’omosunte ekerima nigo oyetubete, na Omoika o Nyasae ogatoeerera igoro y’amaache. ");
INSERT INTO guz_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Erio Nyasae agachiika: “Tiga oborabu bobeo,” erio kegima oborabu bokabao. ");
INSERT INTO guz_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nyasae akagokigwa na keria aroche. Erio agaatanana oborabu korwa ase omosunte, ");
INSERT INTO guz_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","akaroka oborabu boria omobaso, na omosunte akayoroka obotuko. Erio agwo rikaba mogoroba, naende bokaba maambia, rituko rie ritang’ani. ");
INSERT INTO guz_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Erio Nyasae agachiika, “Tiga oboiko bobe egati‐gati y’amaache, erio bwatanane amaache korwa ase amaache ande.” ");
INSERT INTO guz_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Igo Nyasae agakora oboiko boria, bogaatanana amaache ayare inse y’eaanga korwa ase amaache ayare igoro y’oboiko; ayio akaba boigo. ");
INSERT INTO guz_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Akaroka oboiko boria igoro. Erio agwo rikaba mogoroba, naende bogakia mambia, rituko ria kabere. ");
INSERT INTO guz_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Naende Nyasae agachiika, “Tiga amaache ayare inse y’erioba asangererekane aase aamo, egere ense enyomo erorekane;” ayio akaba boigo. ");
INSERT INTO guz_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Akaroka aase aria aomo ense, na amaache aria asangererekanete amo akayaroka chinyancha. Nyasae akarora ayio ng’a namaya. ");
INSERT INTO guz_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Erio agachiika agateeba: “Tiga ense emere ebimeri bigokina, buna ebimeri bikorua na emete ekwama amatunda are ne chimbusuro chire imeo, kera oyomo ase egesaku kiaye ekenyene” ayio akaba boigo. ");
INSERT INTO guz_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Na ense ekamera ebimeri bionsi, na Nyasae akarora ng’a ayio namaya. ");
INSERT INTO guz_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Erio agwo rikaba mogoroba, naende bogakia mambia, rituko ria gatato. ");
INSERT INTO guz_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Erio Nyasae agachiika “Tiga emebaso ebe ase oboiko bw’aaria igoro, bwatanane omobaso korwa ase obotuko; erio ebe ebimanyererio bikworokia ebiro bi’amatuko, ne chingaki, n’emiaka, ");
INSERT INTO guz_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ebe emebaso ase oboiko aaria igoro, boyee ense omobaso na oborabu,” ayio onsi akaba boigo. ");
INSERT INTO guz_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Erio Nyasae agakora emebaso ebere emenene, Risase rigaambere ekero kia mobaso n’omotienyi ogaambere ekero kia botuko; agakora ne ching’enang’eni boigo. ");
INSERT INTO guz_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Akayebeka ase eanga aaria igoro, eyee ense oborabu, ");
INSERT INTO guz_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","egaambere omobaso na obotuko, na gwatanana oborabu korwa ase omosunte. Nyasae akarora ayio ng’a namaya. ");
INSERT INTO guz_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Erio agwo rikaba mogoroba, naende bogakia mambia, rituko ria kane. ");
INSERT INTO guz_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Naende Nyasae agachiika, “Tiga amaache atware obonge bw’ebitongwa bire moyo, ne chinyoni chikoiruruka igoro ase ense, chigoetanana inse y’eaanga ya igoro.” ");
INSERT INTO guz_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Erio Nyasae agatonga ebitongwa ebinene bire ase amaache ime, amo n’ebitongwa binde bionsi bimenyete ase amache ime, boigo agatoonga chinyoni. Nyasae akarora ng’a ayio namaya. ");
INSERT INTO guz_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Erio akabisesenia bionsi, agateeba ebitoongwa biria bimenyete amaache ime bisaraare biichore ime ase chinyancha, naende agateebia chinyoni chisaraare ase ense. ");
INSERT INTO guz_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Erio agwo rikaba mogoroba, naende bogakia mambia, rituko ria gatano. ");
INSERT INTO guz_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Naende Nyasae agachiika, “Tiga ense etware ebitongwa bire moyo, kera egesaku n’engencho yaye. Ching’iti chigotugwa, n’echikwagura, ne ching’iti chi’orosana, kera egesaku nengencho yaye” ayio akaba boigo. ");
INSERT INTO guz_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ase igo Nyasae agakora ching’iti chi’orosana, Nyasae akarora ng’a ayio namaya. ");
INSERT INTO guz_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Erio Nyasae agateeba: “Bono tiga tokore omonto; ase omogwekano oito, otobwekaine. Nigo arabe n’echinguru agaambere chinswe chia nyancha, ne chinyoni chikoiruruka igoro, ne ching’iti chigotugwa, ne ching’iti chionsi chi’orosana, na ense yonsi, ne ching’iti chionsi chinene n’echinke.” ");
INSERT INTO guz_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nabo Nyasae agatonga Mwanyabaanto ase omobwekano oye omonyene; ase omobwekano o Nyasae ere akamotonga. Agatonga omosacha na omokungu, ");
INSERT INTO guz_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","akabasesenia, akabateebia: “Moibore, mosarare, moichore ase ense, na moyegaambere. Ngokobeeka inde ogaambere chinswe, ne chinyoni, n’echingiti chionsi chi’orosana. ");
INSERT INTO guz_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nabaeire kera ekemeri gekwama chimbusuro, na kera omote okwama amatunda ebio nabio biraabe endagera yaino. ");
INSERT INTO guz_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Korende ching’iti chi’orosana ne chinyoni chionsi nachieire ebimeri ebibese bionsi bibe endagera yabo.” Ayio onsi akaba boigo. ");
INSERT INTO guz_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nyasae akarora ebinto ebio bionsi akorete, na birobio nigo biareenge ebiya mono. Erio agwo rikaba mogoroba, naende bogakia mambia, rituko ria gatano na rimo. ");
INSERT INTO guz_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Naboigo igoro na ense bigaikeranigwa. ");
INSERT INTO guz_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ase rituko ria gatano na kabere Nyasae agaikerania emeremo yaye yonsi; erio agatimoka. ");
INSERT INTO guz_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nyasae agasesenia rituko ria gatano na kabere, akariatanana, akarikora richenu, ekiagera erio nario rituko atimogete korwa ase emeremo yaye yonsi y’obotongi, eyio konya akorire. ");
INSERT INTO guz_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Oyo noro omogano igoro y’ense, na bionsi ebire imeo buna biatongetwe. ");
INSERT INTO guz_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ase engaki eria’Omonene atongete igoro na ense, kemeri kende tikiarenge komera korwa ase riroba, gose nyeni chinde, ekiagera Omonene Nyasae konya taratoma embura etwe ase ense, nonya ’monto onde tarengeo ore korema riroba. ");
INSERT INTO guz_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Korende obotooru nigo bware gotiira korwa inse na konyiyia riroba ri’ense yonsi. ");
INSERT INTO guz_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Eri’Omonene Nyasae akaimokia amaroba korwa inse akabomba na koroisia omonto korwa ase orotu rwe riroba, akamoutera omoika bw’obogima ase chimioro chiaye, erio omonto akaba n’obomooyo. ");
INSERT INTO guz_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Eri’Omonene Nyasae agasimeka ebimeri ase omogondo aaria Edeni, ensemo ya moocha, erio akabeeka omonto aroro, oria abombete na koroisia. ");
INSERT INTO guz_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Akameria emete korwa ase riroba, emete yonsi ekororwa yasanerwa kegima, eyio yarenge endagera engiya. Nyasae akabeeka omote bw’obogima gati‐gati y’omogondo oria, naende omote onde oyo bw’okomanyera amaya na amabe. ");
INSERT INTO guz_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Orooche rogatuboka korwa ase omogondo o Edeni na rokayobekera amaache. Korwa agwo rokagabekana, rokaba chindooche inye. ");
INSERT INTO guz_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Orooche rwe ritang’ani rokarokwa Pisoni, orwo narwo roetanaine ense yonsi ya Havila. ");
INSERT INTO guz_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Aa noo Etaabu engiya kegima egotoka boigo namagena ande ye rigori rinene. ");
INSERT INTO guz_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Na orooche rwa kabere rokarokwa Gihoni, orwo narwo roetanaine ense yonsi ya Kusi. ");
INSERT INTO guz_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na orooche rwa gatato rokarokwa Tigirisi, orwo rogoeta moocha y’Asuri. Na orooche rwa kane narororwo rokarokwa Eufarati. ");
INSERT INTO guz_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Erio Omonene Nyasae akaira omonto oria, akamobeka ase omogondo o Edeni, ayoroiserie na koyorenda. ");
INSERT INTO guz_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Akamoteebia omonto oria, “Amatunda a kera omote ore ase omogondo oyo nonyare koyaria, ");
INSERT INTO guz_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","gotatiga amatunda y’omote bw’okomanyera amaya na amabe toyaria, ekiagera rituko riria orayarie goika okwe.” ");
INSERT INTO guz_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Eri’Omonene Nyasae agateeba: “Tai buya omonto oyo abe bweka, nimokorere omokonyi oramokoonye.” ");
INSERT INTO guz_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Erio akaimokia amaroba korwa inse akaroisia kera eng’iti, ne chinyoni chionsi. Erio agachirenta ase omonto oria, arore buna agochiroka; naboigo kera egetongwa kianyorete erieta riaye. ");
INSERT INTO guz_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ase igo omonto oyio akaroka chinyoni chionsi n’echingiti chionsi; korende ase ebio bionsi ebiatongetwe, tarorekana mokonyi onde oye. ");
INSERT INTO guz_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Eri’Omonene Nyasae akabeekera omonto oria chitoro chindito mono kegima, ekero araire akamorusia orobaru rwaye oromo, na akairaneria chinyama aase aria. ");
INSERT INTO guz_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Akaroisia omokungu korwa ase orobaru akamoirera omonto oria. ");
INSERT INTO guz_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Erio omonto oria agateeba, “Omoerio oyombwekaine oyo aa Oyo neriuga korwa ase amauga aane, ne chinyama korwa ase chinyama chiane. Oyo nigo ararokwe omokungu, ekiagera oyo nigo arusigwe ase omosacha.” ");
INSERT INTO guz_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ekio nakio gekogera omonto agotiga ise na ng’ina obwatana na mokaye, na abwo babere baba omobere oyomo. ");
INSERT INTO guz_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Omosacha na omokungu nigo baarenge getirianda, na tibaare kororerana obosooku. ");
INSERT INTO guz_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bono eng’iti engenda inse nigo yarenge eng’aini kobua ching’iti chinde chionsi, echi Omonene Nyasae akorete. Engiti ekaboria omokungu: “Inee! Namaene ng’a Nyasae nigo abakanetie ng’a timoria amatunda ’omote onde bwonsi ore mogondo?” ");
INSERT INTO guz_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Omokungu oria akairaneria eng’iti eria: “Amatunda a kera omote ore ase omogondo ’natonyare koyaria ");
INSERT INTO guz_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","otatiga amatunda y’omote ore mogondo gati-gati. Nyasae nigo atokanetie titoria amatunda korwa ase omote oria gose koyakuna, toise gokora bo nigo torakwe.” ");
INSERT INTO guz_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Eng’iti eria ekairaneria omokungu oria “Ayio tari bo ogokwa, timogokwa. ");
INSERT INTO guz_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nyasae nigo akwanete bo akiagera amanyete ng’a ekero moraarie amatunda y’omote oyio nigo morabwekane Nyasae mobe mokomanya amaya na amabe.” ");
INSERT INTO guz_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Omokungu oria agachia korora omote oria buna ore omuya okoriegwa na okogwenera amaiso, na omote oria noyo bw’okoganigwa, ekiagera okobaa okomanya, agatwa amatunda aye, akaria. Erio agwo akairera omosacha oye amatunda ande nere akaria. ");
INSERT INTO guz_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Erio agwo nyuma ko barire, bakaegwa okomanya bakamanya ng’a ngetirianda bare; erio bagatabora amato y’omoko, bakayasonerania, erio bakeboyia. ");
INSERT INTO guz_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Emogoroba eria bakaigwa eriogi ri’Omonene Nyasae ogotaara ase omogondo, erio barabwo bakebisa mogondo gati y’emete. ");
INSERT INTO guz_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Korende Omonene Nyasae akarangeria omonto oria, akamobooria: “Ng’ai ore?” ");
INSERT INTO guz_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ere akamoiraneria: “Nigo naigwa eriogi riao ase omogondo, noboa ase ayio nebisa ekiagera igo nde getirianda.” ");
INSERT INTO guz_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Omonene akamobooria: “Ing’o ogoteebia ng’a ngetirianda ore? Inee! Nkwarire amatunda y’omote oria nagokanetie ng’a toria?” ");
INSERT INTO guz_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Omonto oria akamoiraneria: “Omokungu oyo kwang’ete ng’a abe amo nainche, nere ong’ete amatunda y’omote oyio, na inche nkaria.” ");
INSERT INTO guz_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Eri’Omonene Nyasae akabooria omokungu oria: “Ninki kiagera gwakora aya?” Omokungu oria akamoiraneria: “Neng’iti yang’ainete, nkaria.” ");
INSERT INTO guz_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Omonene Nyasae agateebia eng’iti eria, “Ekiagera gwakorire aya, aye bweka kwaragererigwe kobua ching’iti chionsi; aye nenda oragendere, na orotu orarie buna endagera ase obogima bwao bwonsi. ");
INSERT INTO guz_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Inche nimbeeke obobisa ase egati yao na omokungu oyo, na ase egati y’oroiboro rwao na oroiboro rwaye; noroiboro orwo narogosenyente omotwe oo, na aye nomoorome egetingiro kiaye.” ");
INSERT INTO guz_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Akaonchokera omokungu, akamoteebia, “Ninkomentere emechando emeenge ekero okoba morito, na ekero okoibora abana nonyore obororo; nonya nabo okogania kwao nigo korabe ase omosacha oo, na ere nakogaambere.” ");
INSERT INTO guz_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Erio agateebia Omosacha oria, “Ekiagera kwaigwerete mokao na okaria amatunda ’omote oria nagokanetie ng’a toria, riroba riaragererigwe ase engencho yao. Ase ogwechanda kwao norie okwama kwaeriroba amatuko onsi ay’obogima bwao. ");
INSERT INTO guz_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Riroba narikwamere amagwa na amageri, na aye norie okwama kw’ebimeri bi’orosana. ");
INSERT INTO guz_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Goika okore omokia na goitera ebigeri gokora riroba riame kende gionsi omanye konyora endagera orie; goika oirane ase riroba, ekiagera agwo nao kwarwete. Naki aye norotu, naende noirane ase orotu.” ");
INSERT INTO guz_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu akaaroka mokaye Hawa, ekiagera ere nere ng’ina bw’abare moyo bonsi. ");
INSERT INTO guz_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Erio Omonene Nyasae akaroiseria Adamu na mokaye chingobo chi’amasankwa, erio agwo akababoyia. ");
INSERT INTO guz_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Eri’Omonene Nyasae agateeba: “Rora, omonto oyo obeire buna oyomo oito ase okomanya amaya na amabe. Tabaisa gwancherwa gochia korambora okoboko kwaye atwe amatunda ’omote bw’obogima arie, erinde abe moyo kare na kare.” ");
INSERT INTO guz_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ase ayio Omonene Nyasae akamoseeria korwa ase omogondo o Edeni, akamobeka areme riroba agwo ase arwete. ");
INSERT INTO guz_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ase ensemo ya moocha y’omogondo o Edeni akabeeka ebitongwa bibwate chimbaba, n’omoyio o birende ogwoka omorero okona‐koonchaonchoka chinsemo chionsi. Erio korenda onde bwensi tacha ase omote bw’obogima. ");
INSERT INTO guz_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Bono Adamu akaba na mokaye Hawa, na ere akaba morito, akaibora omwana omoisia, akabora: “Nanyorire omwana omomura ase ogokonywa kw’Omonene.” Ase igo akamoroka Kaini. ");
INSERT INTO guz_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Naende akaibora omwana onde Abeli. Abeli akaba omorisia bwe ching’ondi, na Kaini akaba omoremi bw’omogondo. ");
INSERT INTO guz_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Engaki egaika Kaini akarenta okwama kw’omogondo oye erio kobe ekengwanso ase Omonene. ");
INSERT INTO guz_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeli nere akareenta emanwa entangi enoru korwa ase riicho riaye. Na Omonene aganchera ekengwanso ki’Abeli, ");
INSERT INTO guz_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","korende tagogetigwe nekengwanso gia Kaini. Ase igo, ayio akagera Kaini akagechigwa mono kegima, na obosio bwaye bokaonchoka, bokairura. ");
INSERT INTO guz_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na Omonene akamobooria: “Kaini, nase ki okobeera nendamwamu na obosio bwao bwairurire? ");
INSERT INTO guz_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","“Onye ndiria gwakora buya anga nigo agogete; korende bono aye gwakorire ebibe, ebibe nigo bikoganyererete gesieri; na birobio nigo bikoganetie. Korende nekogwenerete obibue kegima.” ");
INSERT INTO guz_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Erio Kaini agateebia Abeli omwabo: “Inchuo, togende getii.” Ekero baare agwo getii, Kaini akaimokera Abeli momura omwabo, akamoita. ");
INSERT INTO guz_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Eri’Omonene akabooria Kaini: “Ng’ai Abeli momura omino are?” Kaini akamoiraneria: “Inche tinkomanya. Inee! Ninche nkorenda oyominto?” ");
INSERT INTO guz_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Naende Omonene akamoteebia: “Inki gekogera gwakora egookoroo eke ekebe iga? Eriogi ri’amanyinga a momura omino riarure ase riroba, riang’ikeire buna eriogi rikorigia egesiomba. ");
INSERT INTO guz_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Bono aye kwaragererigwe na tokogenderera korema korwa ase riroba. Rirorio nigo riaasamirie omonwa oye na konywa amanyinga y’omwana omino korwa ase okoboko kwao. ");
INSERT INTO guz_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ekero orabe gokorema riroba tirigokwamera endagera nonya ng’ake. Igo orabe omoomboganu na omoetanani ase ense.” ");
INSERT INTO guz_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Erio Kaini agateebia Omonene: “Egesusuro kiane nekerito, tinkonyara gokebogoria. ");
INSERT INTO guz_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Rora, reero gwanseririe korwa ase riroba eri, nimbiseke korwa ase obosio bwao, timborora naende. Nimbe omoomboganu na omoetanani ase ense, na onde bwensi orang’umere nigo arang’ite.” ");
INSERT INTO guz_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Korende Omonene akamoteebia: “Taibo! Onde bwensi oraite Kaini nigo araakanigwe egesiomba ara gatano na kabere.” Na Omonene akabeekera Kaini ekemanyererio ng’a onde bwensi oramoumere tabaisa komoita. ");
INSERT INTO guz_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Erio Kaini akarwa ase obosio bw’Omonene, akageenda, akamenya ase ense ekorokwa okoombogana ere moocha ya Edeni. ");
INSERT INTO guz_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini akaba na mokaye, na ere akaba morito, akaibora Enoku; na Kaini akaagacha omochie, akayoroka Enoku, erieta ri’omwana oye. ");
INSERT INTO guz_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoku akaibora Iradi, Iradi akaibora Metusaeli, Metusaeli akaibora Lameki. ");
INSERT INTO guz_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki akanyuoma abakungu babere. Omokungu oyomo nigo are korokwa Ada, n’oyonde Zila. ");
INSERT INTO guz_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada akaibora Yabeli; oyo nere sokoro y’abare komenya ase ebigutu na babwate ching’iti chigotugwa. ");
INSERT INTO guz_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na momura omwabo nigo are korokwa Yubali; oyio nere sokoro y’abanto baria baare kobugia amakano na ebiroria. ");
INSERT INTO guz_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila akaibora Tubali‐Kaini. Ere nigo areenge omoturi bw’ebinto bi’ebioma na ebie chitaai. Na omosubati omwabo nere Naama. ");
INSERT INTO guz_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki agateebia abakungu baye, inwe “Ada na Zila, igwa eriogi riane, inwe abakungu ba Lameki, tegerera buya moigwe buna ngoteeba, naitire omomura omoke ekiagera ong’akire na kombeeka rioote. ");
INSERT INTO guz_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Onye Kaini ogoakanerwa egesiomba ara gatano na kabere, amaene, Lameki ere naakanerwe ara emerongo etano na ebere, na gatano na kabere.” ");
INSERT INTO guz_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu na mokaye bakaibora omwana onde omomura, erio Hawa akamoroka Seti, agateeba: “Bono Nyasae ong’eire omwana onde omomura ribaga ri’Abeli, oria Kaini aitete”. Erio akamoroka Seti. ");
INSERT INTO guz_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti nere akaibora omwana omomura, akamoroka Enosu. Erio agwo abanto bagachaaka korangeria erieta ri’Omonene ase okomosasiima. ");
INSERT INTO guz_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Oyo noro omoroberio bw’ororeeria rw’Adamu. Ekero keria Nyasae atongete Mwanyabaanto, akabaroisia ase omogwekano oye omonyene. ");
INSERT INTO guz_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ere akabatonga omosacha na omokungu, akabasesenia, akabaroka Mwanyabaanto. ");
INSERT INTO guz_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ekero Adamu konya amenyire emiaka rigana erimo na emerongo etato (130), akaba ise bw’omwana omomura omobwekaine, ore ekieni kiaye ere omonyene, akamoroka Seti. ");
INSERT INTO guz_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Magega y’okoiborwa gwa Seti, Adamu akagenderera komenya goika emiaka ende amagana atano na atato (800), erio akaba ise bw’abana baabande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ase oboamo Adamu nigo amenyete, emiaka amagana kianda, na emerongo etato (930), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ekero Seti konya amenyire emiaka rigana erimo, na etano (105), akaibora Enosu. ");
INSERT INTO guz_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Magega y’okoiborwa kwa Enosu, Seti akamenya naende emiaka ende amagana atano na atato, na etano na ebere (807), akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ase oboamo, Seti nigo akoorete emiaka amagana kianda, na ikomi na ebere (912), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ekero Enosu amenyire emiaka emerongo kianda (90), akaba ise Kainani. ");
INSERT INTO guz_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Magega y’okoiborwa gwa Kainani, Enosu nigo amenyete emiaka amagana atano na atato, na ikomi na etano (815), akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ase oboamo, Enosu nigo akoorete emiaka amagana kianda, na etano (905), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ekero Kainani konya emenyire emiaka emerongo etano na ebere, (70), akaibora Mahalaleli. ");
INSERT INTO guz_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Magega y’okoiborwa kwa Mahalaleli, Kainani nigo amenyete emiaka amagana atano na atato, na emerongo ene (840), akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ase oboamo, Kainani nigo amenyete emiaka amagana kianda, na ikomi (910), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ekero Mahalaleli emenyire emiaka emerongo etano nomo, na etano (65), akaibora Yaredi. ");
INSERT INTO guz_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Magega y’okoiborwa kwa Yaredi, Mahalaleli nigo amenyete emiaka amagana atano na atato, na emerongo etato (830), akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ase oboamo, Mahalaleli nigo amenyete emiaka amagana atano na atato, na emerongo kianda, na etano (895), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ekero Yaredi amenyire emiaka rigana erimo, na emerongo etano nomo, na ebere (162), akaibora Enoku. ");
INSERT INTO guz_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Magega y’okoiborwa kwa Enoku, Yaredi nigo amenyete emiaka amagana atano na atato (800), akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ase oboamo, Yaredi nigo amenyete emiaka amagana kianda, na emerongo etano nomo, na ebere (962), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ekero Enoku amenyire emiaka emerongo etano nomo, na etano (65), akaibora Metusela. ");
INSERT INTO guz_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Magega y’okoiborwa kwa Metusela, Enoku akaba ogotaara amo na Nyasae ase emiaka amagana atato (300), erio akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ase oboamo, Enoku akamenya nemiaka amagana atato, na emerongo etano nomo, ne etano (365), ");
INSERT INTO guz_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","akaba ogotaara amo na Nyasae. Erio tachikororekana naende, ekiagera Nyasae nigo amoirete. ");
INSERT INTO guz_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ekero Metusela amenyire emiaka rigana erimo, na emerongo etano na etato, na etano na ebere (187), akaibora Lameki. ");
INSERT INTO guz_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Magega y’okoiborwa kwa Lameki, Metusela nigo amenyete emiaka amagana atano na abere, na emerongo etano na etato, na ebere, (782), akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ase oboamo, Metusela nigo akoorete emiaka amagana kianda, na emerongo etano nomo, na kianda (969), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ekero Lameki amenyire emiaka rigana erimo na emerongo etano na etato, na ebere (182), akaba ise omwana omomura, ");
INSERT INTO guz_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","akamoroka Nuhu agateeba: “Oyo nere oratoremie intwe ase emeremo yaito, na obokong’u bwaito, ase riroba eri Omonene aragereretie.” ");
INSERT INTO guz_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Magega y’okoiborwa kwa Nuhu, Lameki akamenya emiaka amagana atano, na emerongo kianda, na etano (595), akaba ise bw’abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ase oboamo, Lameki akamenya emiaka amagana atano na abere, na emerongo etano na ebere, na etano na ebere (777), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ekero Nuhu amenyire emiaka amagana atano (500), akaba ise bw’abana abamura, nabwo Shemu, na Hamu, na Yafeti. ");
INSERT INTO guz_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mwanyabaanto bakagenderera komentekana ase ense, na abana abaiseke bakaiborwa agwo ase baare. ");
INSERT INTO guz_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Abamura ba Nyasae bakarora abaiseke ba Mwanyabaanto ng’a nigo baare nebieni ebiya, bakanyuoma ase ogwechorera abakungu korwa ase abaiseke baria koreng’ana buna baabagogetie. ");
INSERT INTO guz_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Eri’Omonene agateeba: “Omoika one tokonyara komenya ime ase Mwanyabaanto kare na kare, ekiagera ere nomobere ogokwa. Ase ayio emiaka yaye nigo erabe rigana erimo na emerongo ebere yoka.” ");
INSERT INTO guz_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ase engaki eyio, na kogenderera, amamonto namenyete ase ense, ekero abana abamura ba Nyasae baare konyuoma abaiseke ba Mwanyabaanto na koibora abana. Abwo nabwo baarenge amamonto yogokumia, are gotogigwa agwo kare. ");
INSERT INTO guz_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Omonene akarora ng’a obobe bwa Mwanyabaanto bwabeire obonge ase ense, na kera okoroberia na okorengereria gwe chinkoro chiabo nokobe botambe. ");
INSERT INTO guz_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ase ayi’Omonene akairianyeka, ekiagera atongete Mwanyabaanto ase ense, agaichana ase omoyo oye. ");
INSERT INTO guz_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Eri’Omonene agateeba: “Ninsirie Mwanyabaanto abwo natongete mbarusie ase ense, gose tari Mwanyabaanto boka, korende ne ching’iti, na ebitongwa bikwagura, ne chinyoni chia igoro. Neitirie ekiagera natongete abanto abwo na ching’iti echio.” ");
INSERT INTO guz_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Korende Nuhu akanyora ogwancherwa ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Oyo noro omooroberio bw’ororeeria rwa Nuhu. Ere nigo areenge omonyaboronge na omoikeranu ase ekiaare kiaye; ere akaba ogotaara amo na Nyasae. ");
INSERT INTO guz_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ere nabwate abana abamura batato, nabwo Shemu, na Hamu, na Yafeti. ");
INSERT INTO guz_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ense ekaba yasarekire ase obosio bwa Nyasae, egaichorwa nobotindi na okoregana kwegeitano. ");
INSERT INTO guz_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nyasae akarora ng’a ense yatutukanire, ekiagera kera omonto obwatirie chinchera chi’obotutukanu ase ense. ");
INSERT INTO guz_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Erio Nyasae agateebia Nuhu: “Narorire ng’a ninsirie Mwanyabaanto, ekiagera baichoirie obotindi na oboregani ense, ase igo nimbasirie amo nense yonsi. ");
INSERT INTO guz_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Eroiserie obwato obonene bw’emete y’ebirobo; obonachane nechitoto ime ebinyomba, na oboome eramu ime na isiko. ");
INSERT INTO guz_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Obwato obwo nigo oraboroisie iga: Obotambe bwaye nigo borabe obw’ebirengo bi’amaboko amagana atato, na obogare bwaye amaboko emerongo etano, na obotambe bwaye gochia igoro amaboko emerongo etato. ");
INSERT INTO guz_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Inse y’ekerama otige ribaga ri’okorenta oborabu ase obwato obwo, orikore obotambe gochia igoro obw’ekerengo gi’okoboko okomo, obeke egesieri rikere ensemo. Onachane obwato obwo ase amarongo atato. ");
INSERT INTO guz_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Naki rora, nindete etoigo igoro y’ense, ninsirie Mwanyabaanto na binde bionsi bire moyo; kera egento kere moyo ase ense goika gekwe. ");
INSERT INTO guz_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Korende ninkore egeteebanio kiogotianania naye; aye nosoe ase obwato ime amo nabamura bao, na mokao, na baka bamura bao. ");
INSERT INTO guz_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Na orente ching’iti ase obwato ime, na chinde chionsi chire moyo, korwa ase kera egesaku, ibere ibere, chinsacha ne chinkuungu, chibe moyo amo naye. ");
INSERT INTO guz_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ase kera egesaku gie chinyoni, ne ching’iti chionsi, na echikwagura igoro ase ense, ochirente ibere ibere amo naye, erinde chibe moyo. ");
INSERT INTO guz_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Oire endagera egochia koriegwa, oyegache erio eyio nebe endagera yaino na ey’echingi’ti ne chinyoni.” ");
INSERT INTO guz_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu nabo akorete igo; agakora ayio onsi koreng’ana buna Nyasae amochigeete. ");
INSERT INTO guz_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Eri’Omonene agateebia Nuhu: “Soa ase obwato ime amo nabaanto bao, ekiagera buna nakorigereirie, narorire ng’a ase ekegori eke naye bweka ore omonyaboronge ase obosio bwaane. ");
INSERT INTO guz_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ekero ogosoa, oirane amo naye ching’iti chichenegete, isano na ibere isano na ibere, chinsacha ne chinkuungu; na ase kera eng’iti etachenegeti, ibere ibere, ensacha na enkuungu. ");
INSERT INTO guz_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Naende oirane ne chinyoni chikoiruruka, isano na ibere isano na ibere, chinsacha ne chinkuungu. Okore ayio ase engencho y’okorenda kera egesaku erio kegenderere koba moyo ase ense. ");
INSERT INTO guz_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Magega y’amatuko atano na abere nindete embura ase ense etwe amatuko emerongo ene, omobaso na obotuko, na kende gionsi nakorete kere moyo ase ense ningesirie kegima.” ");
INSERT INTO guz_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na Nuhu agakora ayio onsi buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu konya okorire emiaka amagana atano na rimo (600) engaki eyio etoigo yachete ase ense. ");
INSERT INTO guz_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu agasoa ase obwato ime amo nabana baye abamura, na mokaye, na baka bamura baye, ase ogwetooria korwa ase etoigo eria. ");
INSERT INTO guz_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Na ase ching’iti chichenegete, ne ching’iti chitachenegeti, ne chinyoni na ebitongwa bionsi ebikwagura igoro ase ense, ");
INSERT INTO guz_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","chigasoa ase obwato amo na Nuhu ibere ibere, chinsacha ne chinkuungu, buna Nyasae achiigete Nuhu. ");
INSERT INTO guz_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Erio magega y’amatuko atano na abere, etoigo egacha ase ense. ");
INSERT INTO guz_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ase omwaka oria ekero konya Nuhu aikire emiaka amagana atano na rimo (600), ase rituko ria ikomi, na gatano na kabere ri’omotienyi o kabere, chinsoko chionsi chi’amaache chikabera ne chinguru korwa inse, na ebibao bia igoro bikaigoka, ");
INSERT INTO guz_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","na embura egatwa igoro ase ense, rioka rioka ase amatuko emerongo ene, omobaso na obotuko. ");
INSERT INTO guz_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ase rituko erio erio Nuhu agasoa ase obwato ime amo na Shemu, na Hamu, na Yafeti, bamura baye, na mokaye, na baka bamura baye batato. ");
INSERT INTO guz_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Amo nabarabwo, chigasoa ching’iti chi’orosana echia kera egesaku, ne ching’iti chigotugwa echia kera egesaku, na echikwagura echia kera egesaku, na kera enyoni y’egesaku kende gionsi. ");
INSERT INTO guz_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Na chirochio chionsi echiare moyo chigasoa ibere ibere ase obwato amo na Nuhu. ");
INSERT INTO guz_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ching’iti ne chinyoni chionsi chiasoete, chinsacha ne chinkuungu chire moyo chia kera egesaku, chigasoa buna Nyasae achiigete Nuhu, eri’Omonene akamosiekera egesieri. ");
INSERT INTO guz_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Etoigo eria ekagenderera igoro y’ense ase engaki y’amatuko emerongo ene, ekagera amaache akamentekana mono, erio agacheng’enenia obwato na koboimokereria igoro mono kegima korwa ase ense. ");
INSERT INTO guz_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Amache aria akaba nechinguru, na akamenteka mono igoro y’ense, na obwato boria bogacheng’enena ase amaache ayio igoro. ");
INSERT INTO guz_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Amache ayio akagenderera komenteka mono na akaba nechinguru chinene, erio agoichora igoro ase ense goika ebitunwa bionsi ebitambe mono kegima, biareenge kera ase inse y’erioba, bikarimera amaache ime. ");
INSERT INTO guz_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Amache ayio akamenteka rioka rioka agoichora, agatiira goika ebirengo bi’amaboko ikomi na atano igoro y’ebitunwa bionsi. ");
INSERT INTO guz_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ne ching’iti chiria ne chinyoni chionsi echiare moyo, chiare gotaara ase ense, chigakwa; chinyoni, ne ching’iti chiatugire, ne ching’iti chi’orosana, na echikwagura, amo na Mwanyabaanto bonsi bagakwa. ");
INSERT INTO guz_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ebitongire bionsi biare koeyanera chimioro na bire moyo, na bionsi ebiareenge ase ense enyomo bigakwa. ");
INSERT INTO guz_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Nyasae agasiria ebinto bionsi biare moyo, ebiareenge igoro ase ense, Mwanyabaanto ne ching’iti chigotaara na amoogoro, na echikwagura, ne chinyoni chia igoro; na bionsi bigasirigwa korwa ase ense engima; Korende Nuhu bweka agatoorigwa amo nabwo baareenge amo nere ase obwato ime. ");
INSERT INTO guz_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Amache ayio akagenderera koyaaba igoro ase ense, ase engaki y’amatuko rigana erimo, na emerongo etano (150). ");
INSERT INTO guz_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nyasae akamoinyora Nuhu ne ching’iti chionsi, echi’orosana, na echiatugire, echiareenge amo nere ase obwato ime. Erio agwo Nyasae akagusia omwaga ase ense, na amaache aria agakea. ");
INSERT INTO guz_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Chinsoko chia amaache chiare kobera korwa inse amo na ebibao bia igoro bigasiekwa, na embura yaare gotwa egasira, ");
INSERT INTO guz_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","na amaache akana gokeea ng’ora ng’ora korwa ase ense, na ekero amatuko rigana erimo, na emerongo etano (150) aerete, amaache aria agakea. ");
INSERT INTO guz_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ase igo, rituko ria ikomi na gatano na kabere, ri’omotienyi o gatano na kabere, obwato bogeeterekerera igoro ase egetunwa egetambe ki’Ararati. ");
INSERT INTO guz_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Na amaache akagenderera gokea goika omotienyi o ikomi. Ase rituko rie ritang’ani ri’omotienyi o ikomi ebichuria bi’ebitunwa bikarorekana. ");
INSERT INTO guz_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Magega y’amatuko emerongo ene kaerire Nuhu akaigora ekebao keria akorete ase obwato, ");
INSERT INTO guz_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","agatoma ekegonkoru, na kerokio gekairuruka gochia aaria na aaria goika amaache agakama korwa ase ense. ");
INSERT INTO guz_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Erio Nuhu agatoma riruma, egere arore gose amaache akamire korwa ase ense, ");
INSERT INTO guz_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","korende riruma riria tirianyora aase rikogwa, ase igo rikairana ase obwato, ekiagera amaache nao areenge igoro y’ense engima. Ase igo, Nuhu akarambora okoboko kwaye, akabwata riruma riria akarisoyia obwato ime ase areenge. ");
INSERT INTO guz_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Erio akaganya amatuko ande atano na abere, naende ase egeka giakabere, agatoma riruma riria korwa ase obwato. ");
INSERT INTO guz_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Riruma riria rikairana chinsa chia mogoroba, ribogoretie rito ribese ri’omozeituni ase omonwa oye. Ase ayio Nuhu akamanya ng’a amaache akeanire korwa ase ense. ");
INSERT INTO guz_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Naende akaganya amatuko ande atano na abere, agatoma riruma riria, korende rirorio tirichieti koirana asare naende. ");
INSERT INTO guz_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ase omwaka bw’amagana atano na rimo, na oyomo (601), rituko rie ritangani ri’omotienyi bw’eritang’ani, amaache agakama kegima korwa ase ense. Nuhu akarusia ekerama ki’obwato, akarigereria, akarora ng’a ense yakamokire. ");
INSERT INTO guz_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Rituko ri’emerongo ebere, na gatano na kabere ri’omotienyi o kabere, ense ekaba yakamokire kegima. ");
INSERT INTO guz_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Erio Nyasae agateebia Nuhu, ");
INSERT INTO guz_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Soka korwa ase obwato, aye na mokao, na abana bao abamura, na abakungu babo. ");
INSERT INTO guz_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Osooke amo na kera egetongwa kere moyo amo naye: chinyoni, ne ching’iti chigotaara, na echikwagura igoro ase ense, erinde chibiare chimenteke, chiichore ase ense.” ");
INSERT INTO guz_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Erio Nuhu agasoka amo na bamura baye, na mokaye, na baka bamura baye. ");
INSERT INTO guz_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Na kera eng’iti, na kera eyekwagura, na kera enyoni, na ebitongwa binde bionsi bigotaara ase ense bigasoka amo noroiboro rwabo, korwa ase obwato. ");
INSERT INTO guz_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Erio Nuhu akaagachera Omonene egesasiimero, akarusia eyemo ase kera eng’iti, na ase kera enyoni echenegete, agachirua buna ekeng’wanso ki’ogosaambwa igoro ase egesasiimero keria. ");
INSERT INTO guz_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Na ekero Omonene aigwete rimisu rigiya rikomogwenera, agateeba ase omoyo oye ime: “Tinkoragereria ense naende nonya ng’ake ase engencho ya Mwanyabaanto, naki ebirengererio bie chinkoro chia Mwanyabaanto nebibe korwa obwana bwabo; nonya nebitongwa bionsi bire moyo tingocha kobisiria naende buna nakorete. ");
INSERT INTO guz_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Engaki ense egendererete kobao, nebe engaki y’ogosimeka na ey’okogesa, engaki y’obokendu na ey’omobaso omoororo, engaki y’etoigo na ey’egurugura, omobaso na obotuko, tichikoera nonya ng’ake.” ");
INSERT INTO guz_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nyasae agasesenia Nuhu amo nabamura baye, akabateebia: “Moibore, momeneteke, moichore ase ense. ");
INSERT INTO guz_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ching’iti chionsi chire ase ense chibooboe na kobairoka inwe; chinyoni chia igoro, ne ching’iti chikwagura igoro ase ense, ne chinswe chionsi chi’enyancha; echio chionsi chiabekirwe ase amaboko aino.” ");
INSERT INTO guz_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kera egetongwa kere moyo na gekwagura inakebe endagera yaino; buna nabaete chinyeni na ebimeri binde bigokina, naboigo nabaeire nebio bionsi. ");
INSERT INTO guz_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Korende timoria chinyama chire nobomoyo, engencho yaye echire namanyinga ime yabo. ");
INSERT INTO guz_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Amaene, amanyinga y’obogima bwaino ninyaganie ’nyaakanwe; korwa ase kera eng’iti ninyaganie, na korwa ase kera omonto oyogoita oyomwabo ninyaganie ’nyaakanwe obogima bw’omonto oyio. ");
INSERT INTO guz_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Onde bwensi oraitere amanyinga a Mwanyabaanto, amanyinga y’omonto oyio neere naiterwe na Mwanyabaanto, ekiagera Nyasae nigo atongete Mwanyabaanto ase omobwekano oye ere omonyene. ");
INSERT INTO guz_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nyasae agateeba: “Na inwe moibore, momenteke, mosaraare, na mobe abange ime ase ense.” ");
INSERT INTO guz_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Erio naende Nyasae agateebia Nuhu amo nabamura baye, ");
INSERT INTO guz_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Rora, inche ngokora nde okobwatana kw’ogotianania nainwe, amo na ororeeria rwaino roraiborwe korwa magega yaino; ");
INSERT INTO guz_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","naende na kera egetongwa kere moyo kere amo nainwe, chinyoni chionsi ne ching’iti chigotugwa, ne ching’iti chionsi chi’orosana echio chire amo nainwe, chionsi echiasokire korwa ase obwato ime. ");
INSERT INTO guz_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ngokora nde okobwatana kw’ogotianania nainwe, ng’a kende gionsi kere moyo tigekomerwa naende n’amaache y’etoigo, gose etoigo tegocha koba naende egosaria ense magega y’ayio.” ");
INSERT INTO guz_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Naende Nyasae agateeba: “Eke nakio ekemanyererio gi’okobwatana kwane kw’ogotianania nakorire egati yane nainwe, na kera egetongwa kere moyo amo nainwe, na ase ebiaare bigochiagocha.” ");
INSERT INTO guz_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Erio naende Nyasae agateeba: “Inche nabekire omokubinyongo one ase amare, noro nobe ekemanyererio gi’okobwatana oko egati yane na ense. ");
INSERT INTO guz_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ekero nkwara amare igoro y’ense, na omokubinyongo nobe okororekana ase amare. ");
INSERT INTO guz_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Erio nimbe nkoinyora okobwatana kwane, okwo nakorire egati yane nainwe, amo na kera egetongwa kere moyo. Amache takoba naende etoigo egoita ebitongwa bionsi bire moyo. ");
INSERT INTO guz_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ekero omokubinyongo okoba ase amare, na inche nkoyorigereria, ning’inyore okobwatana kwane gwa kare na kare, okwo nakorire egati yane, buna inche Nyasae na kera egetongwa kere moyo ase ense.” ");
INSERT INTO guz_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nyasae agateebia Nuhu: “Eke nakio ekemanyererio gi’okobwatana okwo nakorire egati yane na ebitongwa bionsi bire moyo ase ense.” ");
INSERT INTO guz_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Abana ba Nuhu abarwete ase obwato nabwo aba: Shemu, na Hamu, na Yafeti. Hamu nere ise Kaanani. ");
INSERT INTO guz_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Aba batato nabwo baareenge abana ba Nuhu, na korwa ase abwo Mwanyabaanto bakaranda ase ense engima. ");
INSERT INTO guz_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu akaba omoremi, akaba oyo bw’eritang’ani gosimeka emesabibu, nero ekoroisigwa edivai. ");
INSERT INTO guz_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ere akanywa edivai; erio agatinda, akaraara ore getirianda ase eema yaye ime. ");
INSERT INTO guz_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, ise Kaanani, akamorora ore getirianda, agateebia bamura bamwabo babere baareenge isiko amang’ana aya arooche. ");
INSERT INTO guz_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Erio Shemu na Yafeti bakabogoria engobo, bakayebeeka amareko abo igoro, bakagenda kemagega‐magega, bakabisia ise obogetirianda bwaye. Amaiso abo nigo arigereretie aase bakorwa, na tibarora obogetirianda bwa ise. ");
INSERT INTO guz_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ekero Nuhu atindokire korwa ase okonywa kwaye kw’edivai, akamanya eke omwana oye omoke amokoreire, ");
INSERT INTO guz_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","agateeba, “Kaanani aragererigwe; nigo arabe omosomba bw’abasomba ase abamwabo.” ");
INSERT INTO guz_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Naende agateeba, “Omonene, Nyasae o Shemu, nasesenigwe, na Kaanani abe omosomba oye. ");
INSERT INTO guz_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nyasae amentere Yafeti obomenyo, tiga amenye ase chiema chia Shemu, na Kaanani abe omosomba oye.” ");
INSERT INTO guz_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Magega y’etoigo eria Nuhu akamenya naende emiaka amagana atato, na emerongo etano (350). ");
INSERT INTO guz_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhu nigo akoorete emiaka amagana kianda, na emerongo etano (950), erio agakwa. ");
INSERT INTO guz_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Oro narwo ororeeria rw’abana ba Nuhu: Shemu, na Hamu, na Yafeti. Na aba batato bakaibora abana abamura magega y’etoigo eria. ");
INSERT INTO guz_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Abana ba Yafeti nabwo aba: Gomeri, na Magogu, na Madai, na Yavani, na Tubali, na Mesheki, na Tirasi. ");
INSERT INTO guz_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na abana ba Gomeri nabwo aba: Asikenasi, na Rifati, na Togama. ");
INSERT INTO guz_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Na abana ba Yavani nabwo aba: Elisha, na Tarisisi, na Kitimu, na Rodani. ");
INSERT INTO guz_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Aba nabwo chisokoro chi’abaanto abwo bamenyete mbarabare ye nyancha na as’ebisinka. Barabwo nororeeria rwa Yebita abwo bamenyete kera oyomo ase egesaku kiaye, ne chingongo chiabo na kera oyomo ase omonwa oye areenge gokwana. ");
INSERT INTO guz_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Na abana ba Hamu nabwo aba: Kusi, na Misiri, na Putu, na Kaanani. ");
INSERT INTO guz_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Na abana ba Kusi nabwo aba: Seba, na Havila, na Sabuta, na Raama, na Sabiteka. Na abana ba Raama nabwo aba: Seba na Dedani. ");
INSERT INTO guz_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi akaibora Nimurodi. Nimurodi akaba omonto bw’eritang’ani oyorenge nokobua ase ense. ");
INSERT INTO guz_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ere nigo areenge omotwari omokong’u bwe ching’iti, ase obosio bw’ Omonene. Ase ayio, igo abanto banarete goteeba igoro y’omonto: “Igo anga buna Nimurodi, omotwari omokong’u bwe ching’iti, ase obosio bw’ Omonene.” ");
INSERT INTO guz_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Omochakano bw’obogaambi bwaye nigo bware Babiloni, na Ereku, na Akadi, (na Kaline); eyio yonsi nigo yaare ase ense ya Sinari. ");
INSERT INTO guz_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Akarwa ase ense eria, akagenda goika Asuri, akaagacha Ninawi, na Rehoboti‐Iri, na Kala, ");
INSERT INTO guz_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Reseni, omochie omonene oyorenge egati ya Ninawi na Kala. ");
INSERT INTO guz_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misiri neere esokoro ya Abaludi, na Abanami, na Abalehabi, na Abanafutu, ");
INSERT INTO guz_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","na Abapaturusi, Abakasiluhi, (korwa ase bare nao Abafirisiti barwete), na Abakafitori. ");
INSERT INTO guz_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kaanani akaibora Sidoni, omwana oye omotangi, na Heti, ");
INSERT INTO guz_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","na Abayebusi, na Abaamori, na Abagirigasi, ");
INSERT INTO guz_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","na Abahivi, na Abaarikiti, na Abasini, ");
INSERT INTO guz_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","na Abaarivadi, na Abaseremari, na Abahamati. Erio magega y’ayio eamate ya Kaanani egesiarera. ");
INSERT INTO guz_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Orobebe rw’Abakaanani rogachaka korwa ase Sidoni, rokagenda enchera ya Gerari, rogaika Gasa, naende ase enchera ya Sodomu, na Gomora, na Adima, na Seboimu, rogaika Lasa. ");
INSERT INTO guz_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aba nabwo abana ba Hamu, buna bareenge ase chiamate chiabo, na emenwa yabo, ne chinse chiabo, na ebisaku biabo. ");
INSERT INTO guz_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu, oyorenge sokoro y’abana b’Eberi, naende oyio neere orenge omomura omonene omwabo Yafeti, akaiborerwa abana. ");
INSERT INTO guz_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Abana ba Shemu nabwo aba: Elamu, na Asuri, na Arifakisadi, na Ludi, na Aramu. ");
INSERT INTO guz_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Na abana ba Aramu nabwo aba: Usi, na Huli, na Geteri, na Masi. ");
INSERT INTO guz_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arifakisadi akaibora Sela, na Sela akaibora Eberi. ");
INSERT INTO guz_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi akaibora abana babere abamura. Omomura omotangi nigo aare korokwa Pelegi, ekiagera ase amatuko aye nario ense yaatananegete, na oyomwabo nigo aare korokwa Yokitani. ");
INSERT INTO guz_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani akaibora Alimodadi, na Selefu, na Hasarmaweti, na Yera, ");
INSERT INTO guz_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","na Hadoramu, na Usali, na Dikila, ");
INSERT INTO guz_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","na Obali, na Abimaeli, na Seba, ");
INSERT INTO guz_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","na Ofiri, na Havila, na Yobabu. Abwo bonsi nabwo abana ba Yokitani. ");
INSERT INTO guz_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ensemo eria bamenyete nigo yachakerete Mesa gochia Sefari, ase ebitunwa bia moocha. ");
INSERT INTO guz_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aba nabwo abana ba Shemu, buna baareenge ase chiamate chiabo, na emenwa yabo, ne chinse chiabo, na ebisaku biabo. ");
INSERT INTO guz_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Echio nachio chiamate chi’abana ba Nuhu, koreng’ana na ororeeria rwabo ase ebisaku biabo; na korwa ase bare ebisaku bigesiarera ase ense yonsi magega y’etoigo. ");
INSERT INTO guz_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Abanto b’ense engima nigo baarenge nomonwa oyomo na amang’ana abwekaine. ");
INSERT INTO guz_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Abanto abwo bakaimoka kogenda orogendo gochia ensemo ya moocha, bakanyora ense omweya ase ense ya Shinari, bagachaaka komenya aroro. ");
INSERT INTO guz_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Barabwo bagateebania: “Inchuo, toroisie amatobori na toyasambe nomorero.” Igo bakanyora amatabori ribaga ri’amagena, na bakore esike gete ase okoyabwaterania. ");
INSERT INTO guz_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Erio bagateeba: “Inchuo tweagachere omochie na omoorobiri, na obotambe bwaye boike erioba igoro, tweekorere erieta rinene, titobaisa gocha goserebanigwa ase ense yonsi.” ");
INSERT INTO guz_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Eri’Omonene agaika goocha inse, erinde arore omochie na omoorobiri oyio abana ba Mwanyabaanto konya baagachire. ");
INSERT INTO guz_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Omonene agateeba: “Rora, abanto aba negesaku ekemo, na bagokwana omonwa oyomo bonsi na amang’ana abwekaine. Na bono rora, aya naro bachakire gokora, eyio ekworokia ng’a magega y’ayio tibagosinywa gento kende gionsi baraarengererie gokora. ");
INSERT INTO guz_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Eta togende toike inse ase bare, tobatantanie ase omonbwa obo tibaigwana ase chinkwana chiao barabwo ase barabwo.” ");
INSERT INTO guz_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ase igo, Omonene akabaserebania korwa agwo, bagesiarera ase ense yonsi, na abamenyeo. Erio bagatiga koagacha omochie oria. ");
INSERT INTO guz_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Aase ayio baare koagacha akarokwa Babiloni, ekiagera Omonene atantanetie omonwa bw’abaanto b’ense yonsi, na korwa agwo Omonene akabaserebania erio bagende ense yonsi, bayemenye. ");
INSERT INTO guz_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Oyo noro omooroberio bw’ororeeria rwa Shemu. Ekero konya Shemu aikire emiaka rigana erimo (100), akaibora Arifakisadi; ekaba emiaka ebere magega y’etoigo eria. ");
INSERT INTO guz_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Magega y’okoiborwa kwa Arifakisadi, Shemu naende akamenya emiaka amagana atano (500), akaibora abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ekero konya Arifakisadi aikire emiaka emerongo etato, na etano (35) akaibora Sela. ");
INSERT INTO guz_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Magega y’okoiborwa gwa Sela, Arifakisadi nigo kakoorete emiaka amagana ane, na etato (403), akamanya akaibora abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ekero konya Sela akoorire emiaka emerongo etato (30), akaibora Eberi. ");
INSERT INTO guz_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Magega y’okoiborwa kwa Eberi, Sela agaika emiaka amagana ane, na etato (403), erio akaibora abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ekero konya Eberi aikire emiaka emerongo etato, na ene (34), akaibora Pelegi. ");
INSERT INTO guz_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Magega y’okoiborwa gwa Pelegi, Eberi agakoora emiaka amagana ane, na emerongo etato (430), akaibora abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ekero konya Pelegi aikire emiaka emerongo etato (30), akaibora Reu. ");
INSERT INTO guz_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Magega y’okoiborwa kwa Reu, Pelegi gaikire emiaka amagana abere, na kianda (209), akaibora abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ekero konya Reu aikire emiaka emerongo etato, na ebere (32), akaibora Serugi, ");
INSERT INTO guz_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Magega y’okoiborwa gwa Serugi, Reu gaikire emiaka amagana abere, na etano na ebere (207), akaibora abana abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ekero konya Serugi aikire emiaka emerongo etato (30) akaibora Nahori. ");
INSERT INTO guz_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Magega y’okoiborwa kwa Nahori, Serugi agaika emiaka amagana abere (200), akaibora abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ekero konya Nahori aikire emiaka emerongo ebere, na kianda (29), akaibora Tera. ");
INSERT INTO guz_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Magega y’okoiborwa gwa Tera, Nahori gaikire emiaka rigana erimo, na ikomi na kianda (119), akaibora abana bande, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ekero konya Tera aikire emiaka emerongo etano na ebere (70), akaibora Aburamu, na Nahori, na Harani. ");
INSERT INTO guz_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Oyo noro omoroberio bw’ororeeria rwa Tera. Tera akaibora Aburamu, na Nahori, na Harani. Harani akaibora Loti. ");
INSERT INTO guz_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani agatanga gokwa, agatiga Tera ise ore moyo, ase ense eria aiboreretwe, ase Uru y’Abakalidayo. ");
INSERT INTO guz_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aburamu na Nahori bakanyuoma abarugi. Moka Aburamu nigo areenge korokwa Sarai, na moka Nahori Milka, omwana omosubati o Harani; oyio nere orenge ise Milka na Isika. ");
INSERT INTO guz_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Korende Sarai igo areenge omogomba, tabwate mwana. ");
INSERT INTO guz_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera akaira Aburamu omwana oye, na Loti omochokoro oye, omwana o Harani, amo na Sarai, moka momura oye Aburamu; bakagenda komo gochia Uru y’Abakalidayo, bakagenda goika ense ya Kaanani. Korende ekero baigete omochie o Harani, bakamenya aroro. ");
INSERT INTO guz_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera agaika emiaka amagana abere, na etano (205); erio agakwera aaria Harani. ");
INSERT INTO guz_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Omonene agakwana na Aburamu, akamoteebia: “Karwe ase ense eye yao, na ase eamate yao, na ase omochie o iso bwonsi, ogende goika ense ndakworokie. ");
INSERT INTO guz_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ningokore obe egesaku ekenene, ningosesenie, ninkore erieta riao ribe rinene, na aye nobe omosesenigwa. ");
INSERT INTO guz_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","“Nimbasesenie abwo baragosesenie, nere oyogochecheria erieta riao nimoragererie, na goetera asore aye nimbisesenie ebisaku bionsi bi’ense.” ");
INSERT INTO guz_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Erio Aburamu akaimoka, akagenda buna Omonene amoteebetie, na Loti akagenda amo nere. Aburamu nigo areenge omomura bw’ekegori kiemiaka emerongo etano na ebere, na etano (75), ekero are kong’anya korwa Harani. ");
INSERT INTO guz_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aburamu akaira Sarai mokaye, na Loti, omwana omomura omwabo, na ebinto bionsi ebi babwate, ebio konya benyoreire abanyene, na abasomba babo bonsi babwate agwo Harani, bakaimoka, bakagenda ense ya Kaanani. ");
INSERT INTO guz_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ekero baigeteo, Aburamu agaeta gati y’ense eria goika Shekemu, aase aachenu, aase omote okorokwa omwaloni orenge, agwo More. Ase engaki eyio Abakaanani nabwo bamenyete ase ense eyio. ");
INSERT INTO guz_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Eri’Omonene akamoorokera Aburamu, akamoteebia: “Ning’ee ororeeria rwao ense eye ebe omwando obo.” Ase igo, Aburamu akaagachera Omonene egesasiimero agwo, Omonene oyo omoorokerete. ");
INSERT INTO guz_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Erio akarwa agwo, akagenda goika ebitunwa bire ensemo ya moocha ya Beteli, agatenenia eema yaye aroro. Korwa aase agwo Beteli nigo orenge ensemo ya bosongo, na Ai ensemo ya moocha. Na agwo akaagachera Omonene egesasiimero, erio akarangeria erieta ri’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Na Aburamu akabwatia orogendo akagenderera bosio gochia ensemo ya Negebu. ");
INSERT INTO guz_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bono enchara egasoa ase ense eria, na ase engencho enchara eria yareenge enene mono, ekagera Aburamu agatirimboka gochia Misiri achi kobeera aroro ");
INSERT INTO guz_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kobaikire aang’e gosoa Misiri, agateebia Sarai mokaye iga: “Nimanyete ng’a nigo ore omokungu omonyakieni ase okororekana; ");
INSERT INTO guz_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","aande gose Abamisiri, ekero barakorore, nigo barateebe: Oyo mokaye; erio bang’ite inche, korende aye bagotige moyo. ");
INSERT INTO guz_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ase ayio, bagokoboria igo, obateebie ng’a aye mosubati ominto ore, erinde ebe buya ase ’nde, na ase engencho yao imbe moyo.” ");
INSERT INTO guz_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ekero Aburamu asoete Misiri, Abamisiri bakarora omokungu oyio ng’a nigo areenge omonyakieni mono. ");
INSERT INTO guz_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ekero abagaambi baaria abaarenge inse ya Farao bachia korora omokungu oria, bakamotogia mono ase obosio bwa Farao. Na omokungu oria akairwa komenya mwa Farao. ");
INSERT INTO guz_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Farao agakorera Aburamu buya ase engencho ya Sarai, na Aburamu nigo anyorete ching’ondi, ne chieeri chi’okorema, ne chitigere, na abasomba, abamura na abaiseke, ne chitigere chiaberi, ne chingamia. ");
INSERT INTO guz_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Korende Omonene akarenta amaakwa amanene ase Farao amo na abanto baye ase engencho ya Sarai, moka Aburamu. ");
INSERT INTO guz_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Erio Farao akarangeria Aburamu, akamobooria: “Inki eke gwankoreire iga, otaare gonteebia ng’a oyo Sarai mokao? ");
INSERT INTO guz_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Naki gwakorete iga, ogateeba ng’a oyo mosubati omino, erio ekagera na inche nkamoira akaba mokane? Bono mokao oyio moire, ogende nere.” ");
INSERT INTO guz_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Erio Farao agachiika abanto bakoobe Aburamu amo na mokaye na kende gionsi abwate. ");
INSERT INTO guz_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aburamu akarwa Misiri, akagenda gochia Negebu, ere amo na mokaye na ebi bionsi abwate, na Loti akageenda amo nere. ");
INSERT INTO guz_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Nabo Aburamu areenge omotenenku mono, nigo abwate etugo enyinge, ne chifeta, ne chitaabu. ");
INSERT INTO guz_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Akaimoka korwa Negebu, akageenda agaika Beteli, agwo aase atenenetie eema yaye ritang’ani kegima, gati ya Beteli na Ai, ");
INSERT INTO guz_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","agwo nao aase Aburamu aagachete egesasiimero kie ritang’ani kegima na korirangeria erieta ri’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na Loti, oyogendete amo n’Aburamu, nigo abwate ching’ondi, ne chiombe, ne chiema. ");
INSERT INTO guz_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ase igo, ense eria tiyabaisana banyare komenya amo bonsi babere, ekiagera chinibo chiabo nechinyinge chiarenge, goika tibanyara komenya amo. ");
INSERT INTO guz_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Agwo eriomana rigatuboka egati y’abarisia b’Aburamu, na abarisia ba Loti. Ase engaki eyio Abakaanani na Abaperisi nabwo bamenyete ase ense eria. ");
INSERT INTO guz_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Erio Aburamu agateebia Loti, “Tari buya twomane inche naye, gose abarisia baane na abao, ekiagera intwe nabaanto abamo tore. ");
INSERT INTO guz_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Inee! Ense eye yonsi teri ase obosio bwao? Tigango twatananeke. Koragende ensemo ya bomosi, inche ningende eya borio; koragende ensemo ya borio, inche ningende eya bomosi.” ");
INSERT INTO guz_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti akaimokereria amaiso aye igoro akarigereria, akarora ense omweya bw’erikura ria Yorodani, ng’a in’yarenge n’amaache amange kera aase, na igo orenge buna omogondo Omonene, na buna ense ya Misiri; gochia ensemo ya Soari. Nabo yarenge ritang’ani Omonene atarasaria Sodomu na Gomora. ");
INSERT INTO guz_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ase igo, Loti agechorera bweka ense omweya yonsi ya Yorodani. Barabwo bagatananekana. Igo Loti akamanora kogenda gochia moocha. ");
INSERT INTO guz_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aburamu akamenya ase ense ya Kaanani, na Loti nere akamenya egati y’emechie agwo ase ense eria y’omweya, akang’anyia eema yaye gochia Sodomu. ");
INSERT INTO guz_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Abanto ba Sodomu nigo barenge ababe, barenge gokora ebibe ebinge ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Magega Loti na Aburamu kobaatananekire, Omonene agateebia Aburamu: “Imokereria amaiso ao igoro, origererie korwa agwo aase ore, origererie ensemo ya sugusu, na Irianyi, na moocha, na bosongo; ");
INSERT INTO guz_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","naki ense eye yonsi orooche ninkoyee aye na ororeeria rwao goika kare na kare. ");
INSERT INTO guz_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ningokore aye n’ororeeria rwao robe buna orotu rw’ense rotanyare kobareka; onye omonto okonyara kobara orotu rw’ense, rirorio nanyare boigo kobara ororeeria rwao narororwo. ");
INSERT INTO guz_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bono imoka, otaare ense eye, orore obotambe na oboagare bwaye, ekiagera ninkoe aye ense eyio.” ");
INSERT INTO guz_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Erio Aburamu akang’anyia eema yaye, agacha akamenya ebitutu bw’emete ekorokwa emialoni agwo Mamure, ang’e na Heburoni. Akaagachera Omonene egesasiimero aroro. ");
INSERT INTO guz_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ekaba ase amatuko ’Amurafeli, omorwoti o Shinari, na Arioki, omorwoti o Eleasari, na Kedorilaoma, omorwoti o Elamu, na Tidali, omorwoti o Goiimu, ");
INSERT INTO guz_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","abarwoti aba bagakora esegi na Bera, omorwoti o Sodomu, na Birisa, omorwoti o Gomora, na Shinabu, omorwoti o Adima na Shemeberi, omorwoti o Seboimu, na omorwoti o Bela noro Soari. ");
INSERT INTO guz_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Abarwoti abwo bonsi bakabwatana, bagasangererekana ase ense omweya ya Sidimu, agwo nao Enyancha y’omonyo ere. ");
INSERT INTO guz_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Konya bamokoreire Kedorilaoma emeremo ase engaki y’emiaka ikomi na ebere, korende omwaka o ikomi na gatato bakaenena, tibamokorera naende. ");
INSERT INTO guz_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Na omwaka o ikomi na kane Kedorilaoma na abarwoti baria babwataine nere bagacha, bakarwania na kobua Abarefai ase Asteroti‐Karinaimu, na Abasusi ase Hamu, na Abaemi ase Shawe‐Kiriataimu, ");
INSERT INTO guz_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","n’Abahori ase egetunwa Edomu goika Eli-Parani ore ang’e nerooro. ");
INSERT INTO guz_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Erio bakairana goika bagaika Enimisifati, noro okorokwa Kadeshi, bagasaria ense yonsi y’Abaameleki, na eya Abaamori abwo bamenyete Hasasoni-Tamari. ");
INSERT INTO guz_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Agwo omorwoti o Sodomu, na oyo o Gomora, na oyo bw’Adima, na oyo o Seboimu, na oyo o Bela, noro Soari, bakageenda, bakabwatarena korwana esegi ase ense omweya ya Sidimu, ");
INSERT INTO guz_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","barwane na Kedorilaoma, omorwoti o Elamu, na Tidali, omorwoti o Goimu, na Amurafeli, omorwoti o Shinari, na Arioki, omorwoti o Eliesari. Abarwoti abwo baane bakarwania baria batano. ");
INSERT INTO guz_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na ense omweya ya Sidimu nigo yaichire amabwago y’esike gete, na abarwoti abwo ba Sodomu na Gomora ekero baarenge gotama, bakagwa ase amabwago ayio ime, na baria batigarete bagatama gochia ebitunwa igoro. ");
INSERT INTO guz_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Erio ababisa bagasakora chinibo chionsi chia Sodomu na Gomora, na endagera yabo yonsi bakaira chinsobo. ");
INSERT INTO guz_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Naboigo bagoosa Loti, omwana omomura omwabo Aburamu, oyomenyete agwo Sodomu, bakamoira amo nenibo yaye. ");
INSERT INTO guz_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Omonto oyomo, oyotamete korwa ase abooswa, akagenda agateebia Aburamu Omoiberania, oyomenyete ase akaanani k’emete enga buna Emealuni ka Mamure, oria Omoamori, momura omwabo Esikoli na Aneri. Abwo konya bakorire okobwatana na Aburamu. ");
INSERT INTO guz_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Aburamu agachia koigwa ng’a oyomwabo osakoirwe na gwoswa, agatoma abamura baye abakong’u, abaiboire bwoye, abamanyire korwana esegi, babwatie ababisa goika Dani. Abarwani aba nigo baarenge amagana atato, na ikomi na batano na batato. ");
INSERT INTO guz_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Bwachia koba botuko, Aburamu agaatanana abanto baye, erinde barwanie ababisa babo, akababua akabaseria goika Hoba, sugusu ya Damesiki. ");
INSERT INTO guz_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Erio akairania enibo yonsi, na akairania boigo Loti omwabo amo nenibo yaye, na abakungu, na abanto bande abasakoretwe. ");
INSERT INTO guz_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ekero Aburamu are koirana korwa ogoita Kedorilaoma amo n’abarwoti baria baarenge amo nere, omorwoti o Sodomu agasooka akamoorototera Aburamu ase ense omweya ya Shawe, eyio n’Ense omweya y’Omorwoti. ");
INSERT INTO guz_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Erio Melkizedeki, omorwoti o Salemu, akareenta omogati na edivai; ere nigo areenge Omokuani o Nyasae Ore Igoro Mono. ");
INSERT INTO guz_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Akamosesenia, akabora, “Aburamu asesenigwe na Nyasae Ore Igoro Mono, oyotongete igoro na ense; ");
INSERT INTO guz_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nyasae Ore Igoro Mono atogigwe, oyo obekire ababisa bao inse y’amaboko ao!” Aburamu akamoa ensemo ya ikomi ya kera egento ekiabwate. ");
INSERT INTO guz_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Omorwoti o Sodomu agateebia Aburamu: “Ing’a abanto baane, korende enibo ero oire aye.” ");
INSERT INTO guz_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Korende Aburamu agateebia omorwoti o Sodomu: “Naimokirie okoboko kwane na gotiana ase Omonene Nyasae Ore Igoro Mono, oyotongete igoro na ense, ");
INSERT INTO guz_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ng’a tinkoira nonya ng’ake eusi, gose enuga y’egekoroto kiao, gose kende gionsi kiao, obaise gocha goteeba: Ninche natenenkirie Aburamu. ");
INSERT INTO guz_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tinkoira gento kende gionsi otatiga endagera eyio abamura abwo bariete, na ensemo y’abwo bagendete amo nainche; tiga Aneri, na Esikoli, na Mamure, barabwo baire ebiabo.” ");
INSERT INTO guz_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Magega y’amang’ana ayio, naende ring’ana ri’Omonene rigachiera Aburamu ase endooto, rigoteeba: “Aburamu, toiroka, Inche nenguba yao, na eng’eria yao nebe enene mono.” ");
INSERT INTO guz_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Aburamu akamobooria: “Inee! Omonene, ninki gose orang’e, egekogera nigo nde aang’e gokwa ntari na mwana, na oyorache koira omwando one n’Eliezeri, oyo Omodamesiki?” ");
INSERT INTO guz_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Aburamu akabora naende: “Rora, tong’eti abana, na omosomba oyoiboirwe aa bwone, nere oraire omwando one!” ");
INSERT INTO guz_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Erio ring’ana ri’Omonene rikamochiera Aburamu naende, rigateeba: “Omonto oyio, tari ere oraire omwando oo, otatiga omwana oo bori, orarwe ase enda yao, nere oraire omwando oo.” ");
INSERT INTO guz_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Omonene akamosokia isiko, akamoteebia: “Rigereria gochia igoro, na obare ching’enang’eni, gose nonyare gochinchera.” Erio akamoteebia: “Ororeeria rwao naboigo rorabe.” ");
INSERT INTO guz_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Aburamu nigo amwegenete Omonene, na ase engencho eyi’Omonene akagokigwa nere erio akamobara koba omonyene oboronge. ");
INSERT INTO guz_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Eri’Omonene akamoteebia: “Inche ninche Omonene, nakorusetie korwa ase Uru y’Abakalidayo, ninkoe ense eye ebe omwando oo bori.” ");
INSERT INTO guz_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aburamu akamobooria: “Inee! Aye Omonene, naki ndakore imanye ng’a nebe omwando one bori?” ");
INSERT INTO guz_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Omonene akamoiraneria: “Ndetera emori ritororo y’emiaka etato, na embori esubeni y’emiaka etato, na emingichi y’emiaka etato, ne riruma ne riige rie riruma.” ");
INSERT INTO guz_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Akamorentera echio chionsi, agatandora kera eyemo chimbaara ibere, akabeeka kera orobaara rogachikana norwamwabo, korende chinyoni chirochio tachitandora. ");
INSERT INTO guz_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na ekero chinsoti chiachia kogwa ase amabego aria, Aburamu agachiseria. ");
INSERT INTO guz_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Erioba ko riabeire ang’e kogwa, Aburamu akabwatwa ne chitoro chindito, na obwoba obonene mono bokamosoa. ");
INSERT INTO guz_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Eri’Omonene agateebia Aburamu: “Manya amaene kegima ng’a ororeeria rwao inarooche koba abamenyi ase ense etari eyabo, na barabwo inababe abasomba b’abaanto b’agwo, na abwo inababachaande mono ase engaki y’emiaka amagana ane. ");
INSERT INTO guz_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Abanto b’egesaku keria, barabakore babe abasomba babo, nimbagambie, na magega y’ayio nabarweo bare nenibo enyinge mono. ");
INSERT INTO guz_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Korende aye nogende ase chisokoro chiao ase omorembe. Igo oratindekwe ase obogotu obuya. ");
INSERT INTO guz_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Barabwo bagoika ase ekiaare gia kane inabairane gocha aa, ekiagera obobe bw’Abaamori tiboraikerana goika bono.” ");
INSERT INTO guz_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ekero erioba riagure, na omosunte osoire, eriko rigosokia erioki amo nekieri kere nomorero ekebemberi, bigaeta gati-gati ye chinyama chiria. ");
INSERT INTO guz_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ase rituko eri’Omonene agakora okobwatana kw’ogotianania n’Aburamu, agateeba: “Ororeeria rwao naroire ense eye gochakera ase orooche orwo oronene rokorokwa Eufarati, ");
INSERT INTO guz_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ase ense y’Abakeni, na Abakenisi, na Abakadimoni, ");
INSERT INTO guz_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Abahiti, na Abaperisi, na Abarefai, ");
INSERT INTO guz_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Abaamori, na Abakaanani, na Abagirigasi, na Abayebusi.” ");
INSERT INTO guz_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Bono Sarai, moka Aburamu, tamoiborerete bana. Sarai nareenge nomoiseke omosomba Omomisiri, ore korokwa Hagari. ");
INSERT INTO guz_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai agateebia Aburamu: “Norooche bono ng’a Omonene ontangire tinyora abana, menyana nomoiseke oyo one omosomba; aande nabo ndanyore abana korwa asare.” Aburamu akaigwera ogokwana gwa Sarai. ");
INSERT INTO guz_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ase igo, magega Aburamu kamenyire ense ya Kaanani ase emiaka ikomi, Sarai akaimokia Hagari, omosomba oye Omomisiri, akamomoa Aburamu, omosacha oye, ng’a abe buna mokaye. ");
INSERT INTO guz_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Erio bakamenyana na Hagari, na ere akaba morito. Ekero Hagari achia korora ng’a obeire morito, agachaaka gochaaya Sarai moibori omwabo. ");
INSERT INTO guz_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai agateebia Aburamu: “Obobe obo bwanyorete, tiga naye bokonyore! Inakoa omoiseke one omosomba koboko kwao; ere, ekero achia korora ng’a obeire morito, onchayire. Tiga Omonene atwatanane inche naye!” ");
INSERT INTO guz_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aburamu nere agateebia Sarai: “Rora, omosomba oo oyio nase amaboko ao are; moonchie buna oranche.” Erio Sarai akamochanda bobe, na ere agatama korwa asare. ");
INSERT INTO guz_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Omomalaika Omonene akarora Hagari ase erooro ase ensoko y’amaache yareenge ase enchera ekogenda Suri. ");
INSERT INTO guz_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Akamobooria: “Aye omosomba o Sarai, ng’ai okorwa, naende ng’ai okogenda?” Akamoiraneria: “Nigo ngotama korwa ase moibori ominto Sarai.” ");
INSERT INTO guz_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Erio omomalaika Omonene akamoteebia: “Irana gochia ase moibori omino, na bwekeyie asare.” ");
INSERT INTO guz_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Naende omomalaika Omonene akamoteebia: “Nimentekanie ororeeria rwao, na omobaro obo tokonyara kobareka, ekiagera nigo barabe abange mono.” ");
INSERT INTO guz_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Naende Omomalaika Omonene akamoteebia, “Rora, morito ore, noibore omwana omoisia; nomooroke Isumaeli, ekiagera Omonene oigure ekerero ki’emechando yao. ");
INSERT INTO guz_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ere nigo arabe buna etigere y’orosana ase egati y’abanto, na okoboko kwaye nigo korabe igoro y’abanto bonsi, na amaboko ’abaanto bonsi nigo arabe igoro yaye; ere nigo aramenye bosio bw’abamwabo bonsi.” ");
INSERT INTO guz_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ase ayio Hagari Akaroka Omonene oyo okwanete nere Eli‐Roi, engencho yaye “Aye naye Nyasae bw’okorora”; naki akebooria: “Inee! Amaene, narorire Nyasae, na ere ontiga inde moyo magega konamororire?” ");
INSERT INTO guz_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ase ayio ensoko eria ekarokwa Beeri‐Lahai‐Roi; ero nigo ere egati ya Kadeshi na Beredi. ");
INSERT INTO guz_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Erio Hagari akaiborera Aburamu omwana omoisia; nere Akaroka omwana oria oye, Isumaeli. ");
INSERT INTO guz_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aburamu konya obeire nemiaka emerongo etano na etato, na etano nomo (86), ekero Hagari amoiborerete Isumaeli. ");
INSERT INTO guz_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ekero Aburamu amenyire emiaka emerongo kianda, na kianda (99). Omonene akamoorokera, akamoteebia: “Inche ninche Nyasae Omobui; genderera ase obosio bwane, na obe omoikeranu. ");
INSERT INTO guz_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Inche ninkore okobwatana kw’ogotianania egati yane naye, ninkomentekanie mono.” ");
INSERT INTO guz_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Erio Aburamu agatugama inse akaumama, na Nyasae akamoteebia, ");
INSERT INTO guz_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Rora, okobwatana kwane nabwatanire naye nakwo oko: Aye nobe sokoro bw’ebisaku ebinge. ");
INSERT INTO guz_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Bono erieta riao tirikoba naende Aburamu, korende nigo orarokwe Aburaamu, ekiagera nagokorire obe sokoro bw’ebisaku ebinge. ");
INSERT INTO guz_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ninkomente obe na ororeeria oronge mono, ninkore ebisaku ebinge birue asore, na abarwoti nabarue asore boigo. ");
INSERT INTO guz_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Ning’ikeranie okobwatana kw’ogotianania egati yane naye, na ororeeria rwao korwa magega yao, kogenderera ekiaare ase ekiaare, kobe okobwatana gwa kare na kare; imbe Nyasae oo, na oyo bw’ororeeria rwao korwa magega yao. ");
INSERT INTO guz_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Inche ninkoe aye, na ororeeria rwao rorache korwa magega yao, ense eye omenyete bono buna omomenyi, ense yonsi ya Kaanani, ebe eyaino kare na kare, na inche nimbe Nyasae obo.” ");
INSERT INTO guz_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nyasae agateebia Aburaamu: “Aye goika obwate okobwatana kwane kw’ogotianania, aye na ororeeria rwao rorache korwa magega yao, ekiaare ase ekiaare. ");
INSERT INTO guz_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Oko nakwo okobwatana kwane, orabwate egati yane naye, na ororeeria rwao rorache korwa magega yao: Kera omosacha ore ase more arokigwe. ");
INSERT INTO guz_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Goika mwarokigwe risankwa ria isiko ri’ekiimo kiaino ki’obosacha, na ayio nabe ekemanyererio gi’okobwatana egati yane nainwe. ");
INSERT INTO guz_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ekiaare ase ekiaare kera omwana omoisia ore ase egati yaino goika arokigwe ekero akoorire amatuko atano na atato, omobiare o inka amo nomogorwa chitaabu korwa ase abanto ba isiko, otari bw’ororeeria rwao. ");
INSERT INTO guz_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Omobiare o inka na omogorwa chitaabu, bonsi goika barokigwe. Ase igo, ekemanyererio gi’okobwatana kwane inakebe ase emebere yaino goika kare na kare. ");
INSERT INTO guz_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Omosacha onde bwensi otarokirie risankwa ria isiko ri’ekiimo kiaye ki’obosacha, omonto oyio nigo araatananwe korwa ase abanto bamwabo, aserigwe gochia isiko, ekiagera osaririe okobwatana kwane.” ");
INSERT INTO guz_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Naende Nyasae agateebia Aburaamu: “Sarai mokao, tobaisa komooroka naende Sarai, korende erieta riaye nigo rirabe Sara. ");
INSERT INTO guz_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nimosesenie, nkonyorere omwana omomura korwa asare, nimosesenie, abe ng’ina bw’ebisaku; na abarwoti b’abaanto inabaiborwe korwa asare.” ");
INSERT INTO guz_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Erio Aburaamu agatugama inse, agaseka, akabora ase omoyo oye ime: “Inee! Omonto ore nemiaka rigana nanyare koibora omwana?” Sara nere oyo ore nemiaka emerongo kianda aibore omwana? ");
INSERT INTO guz_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Aburaamu agateebia Nyasae: “Koranche, Isumaeli abe moyo ase obosio bwao!” ");
INSERT INTO guz_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nyasae akamokania, akamoteebia: “Taibo, Sara mokao nakoiborere omwana omomura, na aye nomooroke Isaka. Inche ning’ikeranie nere okobwatana kwane kw’ogotianania, kobe okobwatana gwa kare na kare ase ororeeria rwaye rorache korwa magega yaye. ");
INSERT INTO guz_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ase amang’ana igoro ya Isumaeli nakoigure, rora, nimosesenie nimomentekanie mono, naibore abagaambi ikomi na babere; ninkore egesaku ekenene kerwe asare. ");
INSERT INTO guz_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Korende ning’ikeranie okobwatana kwane na Isaka, oyo Sara araibore ase engaki buna eye iga, ase omwaka ogocha.” ");
INSERT INTO guz_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Nyasae ekero akoorire gokwana na Aburaamu, akairana korwa asare, akagenda. ");
INSERT INTO guz_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Erio Aburaamu akabwata Isumaeli omwana oye, na abasomba aba baiboire ase enka yaye, na abagorwa chitaabu, kera omonto omosacha ore ase abanto b’enka ya Aburaamu, akabarokia risankwa ria isiko ri’ekiimo kiabo ki’obosacha, ase rituko riria riria, buna Nyasae amotebetie. ");
INSERT INTO guz_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Aburaamu konya oikire nemiaka emerongo kianda, na kianda (99), ekero arogetigwe. ");
INSERT INTO guz_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Na Isumaeli, omwana oye, nigo konya aikire emiaka ikomi, na etato, ekero arogetigwe. ");
INSERT INTO guz_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ase rituko erio erio Aburaamu akarokigwa amo na omwana oye Isumaeli. ");
INSERT INTO guz_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Na abanto bonsi baiboire ase enka yaye, na abagorwa chitaabu korwa ase abanto ba isiko, bakarokigwa amo nere. ");
INSERT INTO guz_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Omonene akaorokera Aburaamu ase emete enga buna Emealuni agwo Mamure, ekero Aburaamu aikaransete gesieri ki’eema yaye, engaki y’omobaso omoororo. ");
INSERT INTO guz_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Agwo akaimokereria amaiso aye igoro, akarora abanto batato bateneine bosio bwaye. Ekero abarora, akaminyoka korwa gesieri ki’eema, agachia kobarotota, agatung’ama inse, ");
INSERT INTO guz_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","akabora: “Omonene one, onye nanyorire ogwancherwa ase obosio bwao, tong’etaania inche, omosomba oo. ");
INSERT INTO guz_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tiga morenterwe amaache make, mwesibie amagoro, na motimokere aa ase ekiriiri ki’omote oyo. ");
INSERT INTO guz_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Inche imbarentere endagera inke morie, erio monyore chinguru; erio momanye kogenderera gochia ase mware kogenda, naki aase aiga mwaeta mbwone, inche omosomba oino.” Bakamoteebia: “Gaki, kora buna gwateeba.” ");
INSERT INTO guz_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ase igo, Aburaamu akaayerera, agasoa eema ime agwo ase Sara arenge, akamoteebia: “Renta bwango obosie, ebirengo bitato, obokonye, oroisie emegati.” ");
INSERT INTO guz_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Erio Aburaamu akaminyoka getii ase riicho riaye, akarenta emori engiya, enoru, enterere, akayea omosomba oye, akamoteebia: “Yeroisie bwango, orente.” ");
INSERT INTO guz_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Akabogoria amaguta, na amabeere, ne chinyama chi’emori eria aroisetie, agaterekera abageni baria. Ere agatenena ase bare ensemo ase ekiriiri ki’omote, ekero baare koragera. ");
INSERT INTO guz_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Barabwo bakamobooria: “Ng’ai Sara mokao are?” Ere akabairaneria: “Neema ime are.” ");
INSERT INTO guz_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Omonene akamoteebia: “Amaene, inche ning’irane asore omwaka ogocha engaki enga buna eye, na ninyore ng’a Sara mokao onyorire omwana omoisia.” Ko erio Sara nigo ategererete gesieri ki’eema yareenge magega y’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Bono Aburaamu na Sara konya bagotire mono, baetanirie emiaka y’obosae, na Sara konya oeteire emiaka y’okonyora abana. ");
INSERT INTO guz_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ase ayio, Sara agaseka ase omoyo oye ime, ogoteeba: “Buna inde omogotu iga, na omosacha one nere ogotire, naki eranyarekane inyore omogooko oyio?” ");
INSERT INTO guz_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Omonene akabooria Aburaamu: “Ninki Sara agosekera, ogoteeba: Inche amaene ninyibore omwana buna nagotire iga? ");
INSERT INTO guz_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ing’ana ki rire rikong’u igo riramosinye Omonene? Engaki ndairane asore ase omwaka ogocha, engaki enga buna eye, ninyore ng’a Sara onyorire omwana omoisia.” ");
INSERT INTO guz_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara agakana, agateeba: “Inche tinsegeti,” naki nigo noboete. Omonene akamoteebia: “Taibo; korende aye ngwaseka.” ");
INSERT INTO guz_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Erio abanto abwo bakaimoka korwa agwo, bakagenda, bakaba barigereretie gochia Sodomu, na Aburaamu akagenda amo nabarabwo, akabakooba. ");
INSERT INTO guz_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Omonene agateeba: “Inee! Imobise Aburaamu ring’ana ngochia gokora, ");
INSERT INTO guz_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ekero ndoche ng’a ngochia are koba egesaku ekenene gie chinguru, na ebisaku bionsi bi’ense inabisesenigwe goetera asare? ");
INSERT INTO guz_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Naki namochorire, ng’a ere arue ogochika gochia ase abana baye na bonsi abagotoka enka yaye, na baria abarache koiborwa korwa magega yaye, babwatie enchera y’Omonene, bakore oboronge na ekeene, erinde Omonene aikeranerie Aburaamu, onsi aya amorierete eira.” ");
INSERT INTO guz_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Naende Omonene agateeba: “Ekiagera ekerero gia Sodomu na Gomora nekenene, na ebibe biabo biamentekire mono, ");
INSERT INTO guz_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","nigo ndaike gochia inse, indore onye bakorire amabe amange buna ekerero eke kiang’ikeire kegoteeba; onye taibo, nimanye ayio.” ");
INSERT INTO guz_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Erio abanto baria bakarwa agwo, bakagenda gochia Sodomu, korende Aburaamu agatigara oteneine agwo ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Aburaamu agasuka gochia ase Omonene, akamobooria: “Inee! Amaene, nigo orasirie abanyene oboronge amo nabakori amabe? ");
INSERT INTO guz_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Aande ase omochie oria abanyene oboronge emerongo etano mbakareo, nigo orayosirie, gose noyororere amaabera ase engencho y’abwo abanyene oboronge emerongo etano? ");
INSERT INTO guz_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Yaya gaki teeba boigo, ekeene, nosirie abanyene oboronge nabakori amabe amo? Omonyene oboronge tagokorerwa buna abakori amabe! Inee! Aye Omogambi omonene bw’ense engima notige gokora ayare y’oboronge!” ");
INSERT INTO guz_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Omonene akamoteebia: “Inse konyora abanyene oboronge emerongo etano ase omochie oria o Sodomu, rirorio nigo ndatige gosiria omochie aria ase engencho y’abwo, abaronge.” ");
INSERT INTO guz_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Aburaamu akairaneria: “Rigereria, ningendererete gokwana n’Omonene, nonya inche inde orotu rw’amaroba, na eriibu bosa. ");
INSERT INTO guz_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Aande ase baria emerongo etano baise koba batano tibaiyo, abanyene oboronge, Inee, nosarie omochie ekiagera batano tibaiyo?” Nyasae akairaneria: “Tingosaria omochie, kondarore agwo emerongo ene, na batano.” ");
INSERT INTO guz_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aburaamu akagenderera naende gokwana nere: “Aande baraisa kororekana rende emerongo ene?” Nyasae akairaneria: “Ase engencho y’abwo emerongo ene, tingosaria omochie.” ");
INSERT INTO guz_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Aburaamu akabora: “Omonene, koranche, tobaisa kombea nainche, ningendererete gokwana naye. Aande barabaisa konyorekana rende emerongo etato?” Omonene akairaneria: “Tingosaria omochie oria, inse konyora mbare emerongo etato aroro.” ");
INSERT INTO guz_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aburaamu akabora: “Rora, ningendererete gokwana n’Omonene. Baise konyorekana rende emerongo ebere?” Omonene akairaneria: “Ase engencho y’abwo emerongo ebere, tingosaria omochie.” ");
INSERT INTO guz_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Aburaamu akamobooria naende: “Omonene, tobaisa kombea, bono ndimo rioka ngokoboria, barachia konyorekana rende ikomi boka?” Nyasae akairaneria: “Tingosaria omochie, inse konyora agwo ikomi boka.” ");
INSERT INTO guz_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ekero Omonene akoorete gokwana na Aburaamu, akagenda; na Aburaamu akairana bwoye. ");
INSERT INTO guz_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Abamalaika baria babere bakagenda, bagaika Sodomu mogoroba, na Loti nigo areenge oikaransete geita gia Sodomu. Ekero Loti abarooche, akaimoka kobarotota, agatugama inse, akaumama, ");
INSERT INTO guz_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","akabora: “Abaanene baane, gobera gocha aa, mosoe mw’omosomba oino, monyore amaache mwesibie amagoro aino, moraare goika mambia bokie; erio moche moimoke mambia, mogende.” Barabwo bagakana, bagateeba: “Yaya, nigo tokoba aa inchera obotuko obo bwonsi.” ");
INSERT INTO guz_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Korende akabasorora mono, na barabwo bakagobera, erio bagasoa nyomba mwaye. Erio akabaroiseria endagera, na emegati etabekiri memera, na barabwo bakaria. ");
INSERT INTO guz_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ritang’ani batarachia korara, abanto bonsi b’omochie oria o Sodomu, abamura na abagaaka, bagacha bagaetanana enyomba, ");
INSERT INTO guz_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","bakarangeria Loti, bakamobooria: “Abanto abwo bacha mwao bono botuko, ng’ai bare? Basokie isiko aa, tobakore abakungu.” ");
INSERT INTO guz_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti agasoka isiko ase abanto baria, agasieka egesieri korwa magega yaye, ");
INSERT INTO guz_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","akabateebia: “Baminto, nabasoroire, timokora obosooku buna obo. ");
INSERT INTO guz_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Rora, nimbwate abaiseke baane babere abekungi; tiga mbaabarentere, na mobakorere buna moranche, korende abanto aba iga timobakorera ing’ana rinde rionsi, ekiagera basoire nyomba mwane ime na nigo bare inse y’oborendi bwane.” ");
INSERT INTO guz_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Korende barabwo bakamoteebia: “Torwereo!” Naende bagateebania: “Omonto oyo nomomenyi are aa seito, na bono nigo arigetie gototeebereria! Bono nigo toragokorere bobe mono kobua buna nanga tware gokorera abanto abwo.” Erio bagatwoma‐twoma Loti mono, bakarigia kobuna egesieri. ");
INSERT INTO guz_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Korende abanto baria baarenge ime bakarambora amaboko abo, bakang’usa Loti gochia nyomba ime, na erio kegima bagasieka egesieri. ");
INSERT INTO guz_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Erio bagaukoria abanto baria baarenge korwa isiko, erinde bagasinywa konyora egesieri. ");
INSERT INTO guz_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Erio abasacha baria babere bakabooria Loti: “Nore nonde omino aa? Nobwate abana bao banyuomete abaiseke bao, gose abamura na abaiseke bao, gose kobwate bande bamino ase omochie oyo, barusie korwa aase aa. ");
INSERT INTO guz_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Naki intwe nigo twachire gosaria aase aa, ekiagera ekerero kiaye kiamentekire ase obosio bw’Omonene; ase ayio Omonene ototoomire tosarie aase aa.” ");
INSERT INTO guz_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Erio Loti agasooka, agateebia abamura aba konya bariereire abaiseke baye boko: “Imoka bwango, morue aase aa, ekiagera Omonene ngocha are gosaria omochie oyo,” Korende barabwo bagakaga ng’a negosori akobakorera. ");
INSERT INTO guz_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bogachia gokia mambia, abamalaika baria bakaayereria Loti, bakamoteebia: “Imoka bwango, ira mokao na abaiseke bao babere abare aa amo naye, tobaisa gosirigwa ase egesusuro keria omochie oyo ogochia konyora.” ");
INSERT INTO guz_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ekero abeete ogoteebana, abanto abwo bakamobwata okoboko, bakabwata na mokaye na abaiseke baye, ekiagera Omonene amororerete amaabera, akamosokia isiko y’omochie. ");
INSERT INTO guz_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ekero baabasookirie isiko, oyomo obo akabateebia: “Tama, motoorie obogima bwaino; timorigereria magega, gose timotenena aande onsi ase ense eraire. Motame gochia ase ebitunwa, timobaisa gosira.” ");
INSERT INTO guz_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loti akabakania, akabateebia: “Taibo, Omonene one; ");
INSERT INTO guz_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","rora omosomba oo onyorire ogwancherwa ase amaiso ao, kwamentire amaabera ao ase ’nde ase ogotooria obogima bwane; korende inche tinkonyara gotama ng’ikeere ebitunwa; amabe abaise konyora, ang’ite. ");
INSERT INTO guz_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Rora omochie oyo ore ang’e aiga, omochie omoke, noro ndaike bwango. Tiga ntame gochia ase omochie oria, ore omoke iga, ntoorie obogima bwane.” ");
INSERT INTO guz_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ere akamoteebia: “Rora, nagwancheire ase ring’ana erio boigo. Tingosaria omochie oyio gwateeba. ");
INSERT INTO guz_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ayerera, bwetoorie, ekiagera tingokora ing’ana rinde rionsi goika gwasoire omochie oria ime.” Ase ayio, omochie oyio okarokwa Soari. ");
INSERT INTO guz_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Erioba konya riaorokire ekero Loti asoete Soari. ");
INSERT INTO guz_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Eri’Omonene akaruta amagena ’omorero korwa igoro akonyititoka na omorero igoro ya Sodomu na Gomora, ");
INSERT INTO guz_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","agasamba emechie eyio, amo nense eyio yonsi eraire, na agasiria bonsi abamenyete imeo, na ebinto bionsi biare gokina ase ense eria. ");
INSERT INTO guz_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Korende moka Loti nigo areenge korwa magega, akarigereria magega, akaonchoka, akooma, akaba buna rigena ri’omonyoo. ");
INSERT INTO guz_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mambia kobwakia, Aburaamu akagenda aase aria atenenete ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ere akarigereria maate gochia ensemo ya Sodomu na Gomora, na ense yonsi eraire, na agwo akarora erioki rigotiira korwa inse, buna erioki rikorwa ase eriko rinene. ");
INSERT INTO guz_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ekaba ekero Nyasae asaretie emechie eyio y’ense eraire, akaba okoinyora Aburaamu, akarusia Loti ase ogosarigwa koria, ekero asambete emechie eyio ase Loti amenyete. ");
INSERT INTO guz_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti agatiira korwa Soari, agacha akamenya ase ebitunwa amo nabaiseke baye babere, ekiagera nigo oboete komenya Soari; akamenya ase rikuruma amo nabaiseke baye babere. ");
INSERT INTO guz_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Omoiseke oye omotangi agateebia oyomwabo omoke: “Tata ogotire, gose monto onde tari ase ense oyorache gotonyuoma buna engencho y’ense yonsi ere. ");
INSERT INTO guz_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Bono, tiga toe tata edivai anywe, atinde, toraare nere, erinde tomotenenerie egesaku kiaye, tigesira.” ");
INSERT INTO guz_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Bakanyoinsia ise edivai ase obotuko boria; omoiseke oria omotangi agachia, akaraara nere, ise tamanya ekero araara, gose ekero aboka. ");
INSERT INTO guz_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Rituko rikobwatia omoiseke oria omotangi agateebia oria omoke omwabo: “Rora, obotuko bwa igoro nigo naraire na Tata; tomonyooinsie naende edivai ase obotuko obo, erio naye ochie, oraare nere, erinde tomotenenerie egesaku kiaye, tigesira.” ");
INSERT INTO guz_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Bakamonyoinsia naende edivai ase obotuko obwo. Omoiseke oria omoke akaimoka, akaraara nere, ise tamanya ekero araara, gose ekero aboka. ");
INSERT INTO guz_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Naboigo abaiseke abwo babere ba Loti bakorete iga, ekagera bakaba barito korwa ase ise. ");
INSERT INTO guz_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ase igo omoiseke oria omotangi akaibora omwana omoisia, akamoroka Moabu; oyio nere sokoro bw’Abamoabu goika reero iga. ");
INSERT INTO guz_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Na moiseke oria omwabo omoke, nere akaibora omwana omoisia, akamoroka Ben‐Ami; oyio nere sokoro bw’Abaamoni goika reero iga. ");
INSERT INTO guz_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Erio Aburaamu akaimoka korwa agwo mamure, akagenda gochia ensemo y’ense ya Negebu, akaroisia obomenyo bwaye, egati ya Kadeshi na Suri agwo Gerari. ");
INSERT INTO guz_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ekero are agwo, Aburaamu agakwana igoro ya Sara mokaye ogoteeba: “Oyo mosubati ominto.” Abimeleki, omorwoti o Gerari agatoma abanto kwoyia Sara. ");
INSERT INTO guz_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Korende Nyasae akaorokera Abimeleki botuko ase okorota, akamoteebia: “Aye goika okwe, ekiagera omokungu oyo kwarentire nomokuungu bw’omonto onde.” ");
INSERT INTO guz_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeleki konya ataraba nere, akabora: “Aye Omonene, Inee, nigo oraite nonya nabanyaboronge? ");
INSERT INTO guz_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Inee! Omonto oyio tantebeetie ere omonyene ng’a oyo mosubati omwabo? Na omokungu nere aganteebia ng’a oyo momura omwabo? Ase enkoro etari na komocha konde, na ase amaboko amarabu nakorire ayio.” ");
INSERT INTO guz_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Erio Nyasae akamoteebia ase okoroota: “Inche namanyire ng’a ase enkoro etari na komocha gwakorire aya, na inche nkagotanga tigwankorera ebibe. Ase ayio, tinakoa ribaga omokune. ");
INSERT INTO guz_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Bono moiranerie omonto oria mokaye, ekiagera ere n’omobani, nagosabere onyare koba moyo. Korende otamoiranereti, manya amaene, goika okwe, aye amo na abanto bao bonsi ore nabarabwo.” ");
INSERT INTO guz_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleki akaimoka mambia chuni akarangeria abasomba baye bonsi, akabateebia amang’ana aya onsi, na abanto abwo bakaondoka mono. ");
INSERT INTO guz_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Erio Abimeleki akarangeria Aburaamu, akamobooria: “Inki eke gwatokoreire iga? Inki nakomocheire goika kwarentire igoro yane na igoro y’oborwoti bwane ebibe ebinene buna ebi? Gwankoreire amang’ana atagwenereti gokorwa.” ");
INSERT INTO guz_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Naende Abimeleki akabooria Aburaamu: “Inki kwareengereretie goika ogakora ring’ana eri?” ");
INSERT INTO guz_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Aburaamu akamoiraneria: “Nabo nakorete igo, ekiagera narooche ng’a abamoirogete Nyasae tibari aase aa, na barabwo nigo barang’ite ase engencho ya mokane. ");
INSERT INTO guz_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ere amaene nomoiseke ominto, tata noyomo, korende ng’ina nomoao, na inche nkamonyuoma. ");
INSERT INTO guz_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ekero Nyasae andusetie korwa ase omochie o tata kogenda gochia aaria na aaria ngateebia mokane: Obwo nabwo obwanchani orankorere: kera aase toragende oteebe igoro yane ng’a inche momura omino.” ");
INSERT INTO guz_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Erio Abimeleki akaimokia ching’ondi ne chiombe, amo nabasomba, abamura na abaiseke, akaa Aburaamu, akamoiraneria na Sara mokaye. ");
INSERT INTO guz_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki akamoteebia: “Rora, ense yane nigo ere ase obosio bwao; menya aande onsi ase oranche komenya.” ");
INSERT INTO guz_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ere agateebia Sara: “Rora naeire momura omino chisekeli chi’echifeta elifu eyemo, chibe entorobi yao ase amaiso ’abaanto bonsi abare amo naye, erio omanyekane ng’a nomonto omooronge ore.” ");
INSERT INTO guz_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Erio Aburaamu agasaba Nyasae; na Nyasae akagwenia Abimeleki amo na mokaye, na abasomba baye abakungu, na barabwo bakaibora abana. ");
INSERT INTO guz_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Naki Omonene konya okorire abakungu b’enka y’Abimeleki koba abagomba, erio tibaibora, ase engencho ya Sara moka Aburaamu. ");
INSERT INTO guz_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Omonene akamotaarera Sara, akamokorera buna konya amoriereire eira. ");
INSERT INTO guz_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Erio Sara akaba morito, akaiborera Aburaamu omwana omoisia ase obogotu bwaye, ase engaki eria Nyasae amotebeetie. ");
INSERT INTO guz_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Omwana oyio Sara aiborete, Aburaamu ise akamoroka Isaka. ");
INSERT INTO guz_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ekero Isaka akoorire amatuko atano na atato, Aburaamu akamwarokia, buna Nyasae konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aburaamu nigo areenge nemiaka rigana erimo ekero Isaka, omwana oye, aiboretwe. ");
INSERT INTO guz_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara akabora: “Nyasae onkoreire amaseko, na onde bwensi orayaigwe nansegisie.” ");
INSERT INTO guz_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Naende agateeba: “Ning’o nanga ore komoteebia Aburaamu ng’a Sara nagonkie abana? Na bono namoiboreire omwana ase obogotu bwaye.” ");
INSERT INTO guz_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Omwana oria agakina, agatiga okogonka. Ase rituko riria Isaka atigete kogonka, Aburaamu agakora omoyega omonene. ");
INSERT INTO guz_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Korende Sara akarora omwana oria o Hagari Omomisiri, oyio aiborerete Aburaamu, ogochecheria Isaka, omwana oye. ");
INSERT INTO guz_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ase ayio agateebia Aburaamu: “Moserie omokungu oyo omosomba amo nomwana oye, ekiagera omwana bw’omokuungu oyo omosomba takoria omwando amo nomwana one Isaka.” ");
INSERT INTO guz_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ring’ana erio tiriamogwenera Aburaamu nonya ng’ake, ase engencho y’omwana oye. ");
INSERT INTO guz_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Korende Nyasae agateebia Aburaamu: “Ring’ana eri tiriba riibe asore, ase engencho y’omwana oyo, na ase engencho y’omokuungu oyo, omosomba oo. Rinde rionsi Sara akogoteebia, riigwere, ekiagera korwa ase Isaka ororeeria rwao narwatorwe. ");
INSERT INTO guz_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Naboigo, omwana bw’omokuungu oyo omosomba nimokore abe egesaku ekenene, ekiagera nere oyio nomwana oo.” ");
INSERT INTO guz_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Erio Aburaamu akaimoka mambia chuni, akaimokia omogati na ebirandi biroiseirie amasankwa, bire n’amaache, akabiaa Hagari, akamobibekera mareko. Akamorentera na omwana, akamoteebia agende amo nere. Akagenda, akana‐koong’anya ase erooro ya Beeri‐Seba. ");
INSERT INTO guz_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ekero amaache aria areenge ebirandi ime aerire, akaareria omwana inse y’egetutu. ");
INSERT INTO guz_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Erio akagenda, agaikaransa are ake, ase oboare bw’okoruta ensara, ekiagera nigo atebeete: “Tinkonyara korigereria omwana one ekero ogokwa.” Ekero aikaransete omorigereretie, agaaka eriogi riaye, akareera. ");
INSERT INTO guz_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nyasae akaigwa okoreera kw’omwana, na omomalaika o Nyasae akarangeria Hagari korwa igoro, akamoteebia: “Hagari, inki okoreera? Tibwoboa, ekiagera Nyasae oigure okoreera kw’omwana agwo ase araire. ");
INSERT INTO guz_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tenena, oimokie omwana, omobwate koboko kwao; naki nimokore abe egesaku ekenene.” ");
INSERT INTO guz_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Erio Nyasae akaramokia Hagari amaiso, na ere akarora ensoko y’amaache, akagenda, akabuucha, agaichoria ekerandi amaache, akaa omwana oria erio akanywa. ");
INSERT INTO guz_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nyasae akaba amo nomwana oria. Ere akamenya ase erooro, akaba omomanyi bw’okorasa nemegwe. ");
INSERT INTO guz_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Akamenya ase erooro ya Parani, na ng’ina akamonyuomeria omokungu korwa ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ase engaki eyio Abimeleki na Pikoli, omochiki omonene bw’abarwani baye, bagateebia Aburaamu: “Nyasae nare amo naye ase ande onsi ogokora. ");
INSERT INTO guz_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ase ayio, bono karie eira na gotiana ase Nyasae ng’a togonkorera obong’ainereria inche, na abana baane, na abachokoro baane, korende koreng’ana buna inche nagokorerete aye, obwanchani obo naye onkorere nainche boigo, amo nense eye aye omenyete ime.” ");
INSERT INTO guz_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aburaamu agateeba: “Ee, ninkoriere eira.” ");
INSERT INTO guz_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Aburaamu akamwemurunganeria Abimeleki ase engencho y’ensoko eria abasomba b’Abimeleki bamourete. ");
INSERT INTO guz_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki akamoteebia: “Inche timanyeti ning’o okorete ring’ana erio, gose tikwana gonteebia; nonya nokoigwa, tinana koyaigwa otatiga reero rioka.” ");
INSERT INTO guz_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Erio Aburaamu akaimokia etugo yaye, ching’ondi ne chiombe, akaa Abimeleki, na barabwo babere bagakora okobwatana gati yabo. ");
INSERT INTO guz_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Aburaamu agaatanana chimanwa chisigiti isano na ibere, agachibeeka ensemo. ");
INSERT INTO guz_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki akabooria Aburaamu: “Inee, chimanwa echi chisigiti isano na ibere gwatanana, engencho yaye inki?” ");
INSERT INTO guz_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Aburaamu akamoiraneria: “Chimanwa echi chisigiti isano na ibere nigo nagochieire korwa ase okoboko kwane, erinde chibe kirori ase ’nde, ng’a ensoko eye ninche nayeremete.” ");
INSERT INTO guz_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ase ayio bakaaroka ase agwo Beeri‐Seba, ekiagera barabwo babere mbariereranete emuma aroro. ");
INSERT INTO guz_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ekero bakorire okobwatana aria Beeri‐Seba, Abimeleki na Pikoli, oria omochiki omonene bw’abarwani baye, bakaimoka korwa agwo, bakairana ase ense y’Abafilisti. ");
INSERT INTO guz_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Aburaamu agasimeka omote onga buna ekerachuoki aria Beeri‐Seba, na agwo akarangeria erieta ria Nyasae Omonene o kare na kare ase okomosasiima. ");
INSERT INTO guz_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Aburaamu akamenya buna omomenyi ase ense y’Abafilisti amatuko amange. ");
INSERT INTO guz_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ekaba magega y’amang’ana ayio, Nyasae akabeekera Aburaamu ogoteemwa. Akamorangeria: “Aburaamu!” Na Aburaamu akamoitabeera. “Nao inde aa.” ");
INSERT INTO guz_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nyasae akamoteebia: “Moire Isaka, omwana oyo oo omomoima, oyobwanchete, ogende nere goika ense ya Moria. Agwo omorue abe ekeng’wanso ki’ogosaambwa ase egetunwa ekemo ki’ebio ndakworokie.” ");
INSERT INTO guz_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Aburaamu akaimoka mambia chuni, akabeeka ebinto ase etigere yaye, akairana abamura babere amo nere, na Isaka omwana oye. Agaatia chinko agochia gosambera ekeng’wanso, akaimoka, akagenda gochia aase aria ateebetigwe na Nyasae. ");
INSERT INTO guz_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Rituko ria gatato Aburaamu akaimokereria amaiso aye igoro, akarora aase aria korwa aare. ");
INSERT INTO guz_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Erio Aburaamu agateebia abamura baria abaarenge komo: “Ikaransa inwe aiga amo netigere eye! Inche amo nomwana oyo one nkogenda tore gochia aria, tosasime, erio toirane ase more naende.” ");
INSERT INTO guz_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aburaamu akaimokia chinko echi areenge gochia gosambera ekeng’wanso, agatweka Isaka omwana oye, na ere omonyene akaimokia omorero na omoyio. Bakagenda amo bonsi babere. ");
INSERT INTO guz_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka agakwana na Aburaamu ise, agateeba: “Tata!” Ise agoitaba ogoteeba: “Nao inde aa, omwana one.” Isaka akamobooria: “Rora, omorero ne chinko ntobwate, korende ng’ai emaanwa y’eng’ondi ere togochia gokorera ekeng’wanso ki’ogosaambwa?” ");
INSERT INTO guz_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aburaamu akamoiraneria: “Omwana one, Nyasae nenyorere emaanwa y’eng’ondi ase ekeng’wanso eke.” Erio bakagenderera amo bonsi babere. ");
INSERT INTO guz_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kobaikire aase aria ateebetigwe na Nyasae, Aburaamu akaagacha egesasiimero agwo, akaara chinko igoro yaye, agasiba Isaka omwana oye, akamwareria igoro ye chinko chiria. ");
INSERT INTO guz_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Erio Aburaamu akarambora okoboko kwaye, akabogoria omoyio anyenye omwana oye. ");
INSERT INTO guz_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Korende omomalaika Omonene akamorangeria korwa igoro, akabora: “Aburaamu, Aburaamu!” Ere agaitaba: “Nao inde aa.” ");
INSERT INTO guz_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Omomalaika oria akamoteebia: “Torambora okoboko kwao igoro ase omwana oo, gose tomokorera ing’ana rinde rionsi riibe. Bono namanyire ng’a nomoirogete Nyasae, naende narorire ng’a tondineti omwana oo omomoima.” ");
INSERT INTO guz_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aburaamu akaimokerereria amaiso aye igoro, akaonchora ebigoti gochia aa anaaria, akarora eng’ondi emingichi ebwatire ching’unchara ase orosana nemerande. Aburaamu akagenda, akarusia eng’ondi eyio, akayerua, ekaba ekeng’wanso ki’ogosambwa ase ribaga ri’omwana oye. ");
INSERT INTO guz_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Aburaamu Akaaroka aase aria “Omonene nayaroke” (Yahwe‐Yire); buna abanto bagokwana goika reero iga: “Ase egetunwa ki’ Omonene, nao ekonyorekana.” ");
INSERT INTO guz_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Omomalaika Omonene akarangeria Aburaamu korwa igoro eria kabere, akamoteebia: ");
INSERT INTO guz_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Omonene oteebire: Netianirie inche omonyene, ekiagera gwakorire ring’ana eri, gose tondineti omwana oo omomoima. ");
INSERT INTO guz_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ase ogosesenia ningosesenie, na ase okomenta nimente ororeeria rwao, robe oronge buna ching’enang’eni chia igoro na buna omokenye ore engegu y’enyancha, na ororeeria rwao inarobue emechie y’ababisa babo, ");
INSERT INTO guz_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","na ase ororeeria rwao ebisaku bionsi bi’ense inabisesenigwe, ekiagera kwanyigwereire.” ");
INSERT INTO guz_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Erio Aburaamu akairana gochia ase abamura baria baarenge komo; bonsi bakaimoka, bakagenda amo gochia Beeri‐Seba; na Aburaamu akaba okomenya agwo Beeri‐Seba. ");
INSERT INTO guz_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Magega y’amang’ana ayio kaerire Aburaamu agateebigwa ng’a, “Milka oiboreire momura omino Nahori abana. ");
INSERT INTO guz_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Abana abwo nabwo aba: Usi, omwana oye omotangi, na Busi omwabo, na Kemueli, ise Aramu, ");
INSERT INTO guz_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","na Kesedi, na Haso, na Pilidasi, na Yidilafu, na Betueli.” ");
INSERT INTO guz_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli nere omoiborete omoiseke ore korokwa Rebeka. Abwo batano na batato nabwo Milka aiborerete Nahori, momura omwabo Aburaamu. ");
INSERT INTO guz_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naende omokungu oye o sere‐sere, ore korokwa Reuma, akamoiborera Teba, na Gahamu, na Tahasi, na Maaka. ");
INSERT INTO guz_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara nigo akoorete emiaka rigana erimo, na emerongo ebere, na etano na ebere (127); eye nero emiaka y’obogima bwa Sara. ");
INSERT INTO guz_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara agakwera ase Kiriati‐Ariba, agwo nao Heburoni, ase ense ya Kaanani. Aburaamu akagenda komoreera Sara na okweumia okonene, na akaroberia omoyega bw’ogotindekwa kwaye. ");
INSERT INTO guz_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Aburaamu akaimoka korwa ase egetondo kiaye, agateebia Abahiti, ");
INSERT INTO guz_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Inche nomomenyi inde, imenyete ase egati yaino; komoranche mong’e aase ntindeke omokungu one onkwereire, imorusie ase obosio bwane.” ");
INSERT INTO guz_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Abahiti bakairaneria Aburaamu, bakamoteebia, ");
INSERT INTO guz_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Omonene, totegerere! Aye nigo ore omonto omonene o Nyasae ase egati yaito. Tindeka omokungu oo ase embeera ende yonsi engiya orachoore. Onde tari ase egati yaito orakorine embeera yaye gose agotange totindeka omokungu oo.” ");
INSERT INTO guz_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Aburaamu akaimoka, agatugama inse ase amasio ’Abahiti, abanto b’ense eria. ");
INSERT INTO guz_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ere agakwana nabarabwo, akabora: “Komoranche mong’e ribaga ntindeke omokungu one, imorusie ase obosio bwane, monyigwe na monsabere ase Efuroni, omwana o Sohari, ");
INSERT INTO guz_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ang’e rikuruma riaye, erio rire agwo Makipela, ase ensinyo y’oboremo bwaye. Ase rigori riikeranu tiga ang’ere ase amasio aino, togoranereo, ribe aase aane ndabe ngotindeka abakuure.” ");
INSERT INTO guz_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Bono Efuroni nigo areenge oikaransete agwo ase egati y’Abahiti. Ere Efuroni, Omohiti, akairaneria Aburaamu ekero Abahiti bonsi, abaare goetera egeita ki’omochie oye, bamotegererete, ");
INSERT INTO guz_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","agateeba: “Yaya, omonene one, ntegerera. Oboremo boria nakoeire amo ne rikuruma riria rire imeo, ase amaiso ’abaanto baminto nakobieire; otindeke mokao aroro.” ");
INSERT INTO guz_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Erio Aburaamu agatugama inse ase amasio ’abaanto b’ense eria. ");
INSERT INTO guz_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Agateebia Efuroni ekero abanto b’ense eria bamotegererete: “Koranche, ntegerera! Inche nindue rigori ri’oboremo; naye obogorie chifeta korwa ase ’nde, na inche nintindeke mokane aroro.” ");
INSERT INTO guz_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efuroni akairaneria Aburaamu, ");
INSERT INTO guz_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","akamoteebia: “Omonene one, ntegerera! Oboremo obwo bw’erigori rie chisekeli chi’efeta amagana ane, ngento ki toengereranie inche naye? Tindeka mokao agwo.” ");
INSERT INTO guz_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aburaamu bagaancherana na Efuroni; na Aburaamu akarengera Efuroni chifeta chiria ateebete Abahiti kobaigwete, chisekeli chi’echifeta amagana ane, koreng’ana nekerengo giancheranire nabaonchoreria. ");
INSERT INTO guz_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Oboremo bw’Efuroni obwo bware agwo Makipela moocha ya Mamure, oboremo amo ne rikuruma riria riare imeo na emete yonsi yareengeo, ensemo eria yonsi Aburaamu akayeegwa. ");
INSERT INTO guz_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Igo ayeetwe ase amasio ’Abahiti, abwo bonsi baare gosoera egeita kiaye. ");
INSERT INTO guz_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Magega y’ayio Aburaamu agatindeka Sara mokaye ase rikuruma ri’oboremo bware agwo Makipela, moocha ya Mamure, agwo nao Heburoni, ase ense ya Kaanani. ");
INSERT INTO guz_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Nabo oboremo boria, ne rikuruma riria riare imeo, Aburaamu akabinyora korwa ase Abahiti bibe aase kwaye agwo ase agotindeka abakuure. ");
INSERT INTO guz_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Bono Aburaamu konya obeire omogotu, akoorire emiaka emenge; n’Omonene konya omosesenirie ase amang’ana onsi. ");
INSERT INTO guz_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Aburaamu akarangeria omosomba oye oyo konya omokoreire ase emiaka emenge mono, na omorenderete enibo yaye yonsi, akamoteebia: “Beka okoboko kwao inse y’ebinama biane, ");
INSERT INTO guz_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","na inche ninkoboorie otiane ase Omonene Nyasae o igoro na ense, ng’a tokorigeria omwana one omokungu korwa ase abaiseke b’Abakaanani, aba imenyete ase egati yabo. ");
INSERT INTO guz_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Korende ogende ase ense yane na ase eamate yane, orentere omwana one Isaka omokungu korwa aroro abe mokaye.” ");
INSERT INTO guz_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Omosomba oria akamoiraneria: “Aande, omokungu oria atancheraneti gocha amo nainche goika ase ense eye; Inee, nigo ndaire omwana oo goika ase ense eria kwarwete?” ");
INSERT INTO guz_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aburaamu akamoiraneria: “Bwerende, tobaisa koira omwana one aroro. ");
INSERT INTO guz_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Omonene, Nyasae o igoro na ense, oyondusetie o tata korwa ase ense eria naiboreretwe, ere nigo akwanete nainche na gotiana, ogoteeba: Ning’ee ororeeria rwao ense eye, ere natome omomalaika oye agotang’ane; aye norentere omwana one omokungu korwa aroro. ");
INSERT INTO guz_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Na omokungu oria atancheti moche komo, rirorio nosiborwe korwa ase eira eye okoria ase ’nde, korende tobaisa koira omwana one gochia aroro.” ");
INSERT INTO guz_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Erio omosomba oria ababeeka okoboko kwaye inse y’ekebono kia Aburaamu, omonene oye, akerama ase ring’ana erio. ");
INSERT INTO guz_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Erio omosomba oria akarusia chingamia ikomi chi’omonene oye, akaimokia na ebiegwa ebinge ebiya; akaimoka, akagenda gochia Mesopotamia, agaika omochie oria Nahori amenyete. ");
INSERT INTO guz_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Agwo agatimokeria chingamia isiko y’omochie ang’e nensoko y’amaache engaki ya mogoroba, ekero abakungu bagocha kobuucha amaache. ");
INSERT INTO guz_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ere agasaba, agateeba: “Aye Omonene, Nyasae bw’omonene one Aburaamu, nagosabire, onsesenie ase amang’ana aane a reero, okorere omonene one Aburaamu obwanchani. ");
INSERT INTO guz_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Rora, ninteneine aiga ase ensoko y’amaache, na abaiseke b’omochie oyo ngocha bare kobuucha amaache. ");
INSERT INTO guz_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tiga ebe iga; Kondaborie oyomo obo: Koranche obeke enyongo yao inse, inche inywe amaache, na ere karang’iranerie: Ee, kanywe aye, na nimbuuchere chingamia chiao nachirochio; otige oyio abe nere gwachoreire omosomba oo Isaka, na inche erio nimanye ng’a aye Omonene one gwankoreire amaya ase obwanchani.” ");
INSERT INTO guz_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ritang’ani atarakoora ogosaba kwaye, akarora Rebeka ogocha obogoretie enyongo yaye mareko. Ere nomoiseke o Betueli, na Betueli nomwana o Milka, moka Nahori, momura omwabo Aburaamu. ");
INSERT INTO guz_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Na omoiseke oria nigo areenge omonyakieni, naende nomwekuungi, otaraba na mosacha onde. Agatirimboka gochia ase ensoko, agaichoria enyongo yaye amaache, agatiira. ");
INSERT INTO guz_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Erio omosomba oria akaminyoka bwango gochia komoorotota, akamosaba: “Koranche, ong’e amaache inywe.” ");
INSERT INTO guz_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ere akamoiraneria akamoteebia: “Kanywe, omonene one!” Agatoora enyongo yaye bwango, akayebeeka koboko kwaye, akamoa, na ere akanywa. ");
INSERT INTO guz_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Gakoorire komoa amaache, akabora: “Ne chingamia chiao boigo ninchibuuchere, na chirochio chinywe.” ");
INSERT INTO guz_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Akaayerera, akaumora amaache aria areenge ase enyongo ase orotuba ime, akaminyoka bwango ase ensoko naende, agachibuuchera chingamia chiaye chionsi. ");
INSERT INTO guz_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Erio omonto oria akamobeta amaiso, akaba okirete kiri, erinde amanye gose Omonene osesesenirie orogendo rwaye, gose taibo. ");
INSERT INTO guz_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ekero chingamia chiakoorire konywa amaache, omonto oria akamoruseria ekegera gi’etaabu, kiare noborito bwe chigiramu isano na isato, na ebitange bibere bie chitaabu ase amaboko aye, ebiare noborito bwe chigiramu rigana erimo, na emerongo etano. ");
INSERT INTO guz_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Akamobooria: “Nomoiseke o ng’o ore? Naende onteebie gose ribaga ndire mwa iso toranyare koraara botuko.” ");
INSERT INTO guz_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ere akamoiraneria: “Inche nomoiseke o Betueli, oyo Milka aiborerete Nahori.” ");
INSERT INTO guz_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Naende akamoteebia: “Seito obonyansi mboreo, na aase tokorisia aisaine, na enyomba y’abageni bakorara nereo.” ");
INSERT INTO guz_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Erio omonto oria agatugama inse, agasasiima Omonene, ");
INSERT INTO guz_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","agateeba: “Omonene, Nyasae bw’omonene one Aburaamu, atogigwe! Ere tatigeti koorokia omonene one obuya na obwegenwa. Omonene ondaaire enchera, naikire enka y’abamwabo omonene one.” ");
INSERT INTO guz_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Erio omoiseke oria akaminyoka, agaika inka sobo, agateebia abanto ba nyomba mwa ng’ina amang’ana ayio. ");
INSERT INTO guz_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeka nabwate momura omwabo ore korokwa Labani. Ekero Labani arooche ekegera na ebitange ase amaboko ’omoiseke omwabo, na kaigure amang’ana omonto oria ateebetie Rebeka, agasoka, akaminyoka gochia ase ensoko ase omonto oria areenge, akamorora oteneine ase chingamia chiaye, ");
INSERT INTO guz_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","akamoteebia: “Inchuo, aye osesenirie n’Omonene! Naki oteneine isiko aa? Inche nakoroiseirie enyomba ase ogochia koraara, na aase e chingamia chiao.” ");
INSERT INTO guz_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Erio omonto oria agasoa nyomba, na Labani agasibora chingamia chigurube chiabo, agachia obonyansi, na chirochio chikaria. Naende akarentera omonto oria amaache, akarentera na abwo baarenge komo, bagesibia amagoro. ");
INSERT INTO guz_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Erio akaariganigwa ase endagera, korende agateeba: “Tinkoria endagera, goika ndateeba amang’ana ane.” Erio Labani akairaneria: “Gaki, yakwane!” ");
INSERT INTO guz_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Erio agateeba: “Inche nomosomba o Aburaamu. ");
INSERT INTO guz_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Omonene osesenirie omonene one mono, na ere obeire omotenenku. Omoeire amaicho e ching’ondi, na aye chiombe, chifeta ne chitaabu, na abasomba, abamura na abaiseke, chingamia ne chitigere.” ");
INSERT INTO guz_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na Sara, moka omonene one, akamoiborera omwana omomura ekero amenyire omogotu; na omonene one oeire omwana oyio bionsi ebi abwate. ");
INSERT INTO guz_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Omonene one akamboria ntiane, aganteabia: “Torigeria omwana one omokungu korwa ase abaiseke b’Abakaanani, aba imenyete ase ense yabo; ");
INSERT INTO guz_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Korende ogende ase omochie o tata, ase eamate yane, orentere omwana one omokungu korwa aroro. ");
INSERT INTO guz_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Na inche ngateebia omonene one: Aande omokungu oria atancheraneti gocha amo nainche. ");
INSERT INTO guz_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Korende aganteebia: Omonene oyo ngendererete ase obosio bwaye, natome omomalaika oye amo naye, asesenie orogendo rwao. Naye orentere omwana one omokungu korwa ase eamate yane, korwa ase omochie o tata; ");
INSERT INTO guz_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","erio nosiborwe korwa ase eira eyio nakoboririe otiane. Ekero oraike ase eamate yane, onye tibagokoa omoiseke oyio, aye rirorio nobe gwasiboirwe korwa ase ogotiana kwao.” ");
INSERT INTO guz_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Inche igo nacha reero ase ensoko, nasaba iga: Aye Omonene, Nyasae bw’omonene one Aburaamu, koranche onsesenie bono ase orogendo rwane nkogenda. ");
INSERT INTO guz_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Rora ninteneine aiga ase ensoko y’amaache. Tiga ebe iga: Omoiseke onde omo orache kobuucha amaache, na inche imosabe oyio: Koranche ong’e amaache make korwa ase enyongo yao inywe. ");
INSERT INTO guz_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Onye ere okong’iraneria: Ee, kanywe, na nimbuuchere chingamia chiao nachirochio; otige oyio abe nere omokungu Omonene achoreire omwana bw’omonene one.” ");
INSERT INTO guz_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ritang’ani ntarakoora ogosaba ase omoyo one, narora Rebeka ogocha obegete enyongo yaye mareko, ogotirimboka gochia ase ensoko kobuucha amaache.” Na inche namosaba: “Koranche, ong’e amaache inywe.” ");
INSERT INTO guz_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ere orusia enyongo yaye bwango korwa ase amareko aye, oyebeeka inse, onteebia: Kanywe, ne chingamia chiao ninchibuchere boigo. Erio ong’a, nanywa, oa ne chingamia, nachirochio chianywa. ");
INSERT INTO guz_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Erio namobooria: “Nomoiseke o ng’o ore?” Ere ong’iraneria: “Inche nomoiseke o Betueli oyo Milka aiborerete Nahori.” Agwo namobekera ekegera chimioro chiaye, na ebitange ase amaboko aye. ");
INSERT INTO guz_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Erio natugama inse nasasiima Omonene. Naende namotogia Omonene, Nyasae bw’omonene one Aburaamu, oyontang’anete ase enchera endonge, erinde imorentere omwana bw’omonene one omokungu korwa ase eamate yaye. ");
INSERT INTO guz_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Bono rende, onye morigetie gokorera Omonene one amaya, na ayare boronge, monteebie; onye taibo, monteebie, ngende ensemo ende eng’ao korigia. ");
INSERT INTO guz_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Erio Labani na Betueli bakamoiraneria, bakamoteebia: “Amang’ana aya nigo arure ase Omonene; intwe titokonyara gokwana ande, amabe gose amaya. ");
INSERT INTO guz_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rora, Rebeka oyio ore ase obosio bwao, moire, mogende komo, achie koba omokungu bw’omwana bw’omonene oo, buna Omonene konya ateebire.” ");
INSERT INTO guz_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ekero omosomba o Aburaamu aigwete amang’ana abo, agatugama inse ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Erio omosomba oria akarusia ebinto bi’ogwechabera bie chitaabu, na ebie chifeta, amo ne chianga, akaa Rebeka. Naende akaa momura omwabo amo na ng’ina ebiegwa bi’erigori rinene. ");
INSERT INTO guz_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ere na abanto baria baarenge komo bakaria na bakanywa, erio bakaraara aroro. Mambia kobwachia gokia akabateebia: “Ing’a ribaga ng’irane ase omonene one.” ");
INSERT INTO guz_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Momura omwabo Rebeka na ng’ina bakamoteebia: “Tiga omoiseke oyo arabeere aiga koreng’ana amatuko ikomi; magega y’ayio mogende komo.” ");
INSERT INTO guz_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ere akabateebia: “Timobaisa goteebania, ekiagera Omonene onsesenirie ase orogendo rwane; ing’a ribaga ngende ase omonene one.” ");
INSERT INTO guz_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Bakamoteebia: “Tiga torangerie omoiseke, tomoboorie, toigwe buna agoteeba.” ");
INSERT INTO guz_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Bakarangeria Rebeka, bakamobooria: “Inee! Inabwanche ogende nomonto oyo?” Akairaneria: “Ee, nanchire, ngende nere.” ");
INSERT INTO guz_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Erio bakaa Rebeka ribaga amo nomoreri oye bagende nomosomba o Aburaamu na abanto baye. ");
INSERT INTO guz_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bagasesenia Rebeka, bakamoteebia, “Oyominto, obe ng’ina abanto chilifu ne chilifu; ororeeria rwao inarobue emechie y’ababisa bao, royegambere!” ");
INSERT INTO guz_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Erio Rebeka akaimoka amo nabaiseke baye abasomba, bakariina chingamia, bagatunyana omonto oria. Naboigo omosomba oria akaira Rebeka, akagenda nere sobo. ");
INSERT INTO guz_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Bono Isaka konya orure ase ensoko ya Beeri‐Lahai‐Roi, ekiagera nigo amenyete ase ense ya Negebu. ");
INSERT INTO guz_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaka nigo achiete mogondo ekero kia mogoroba, akaba ore nebirengererio. Agwo akaimokereria amaiso aye igoro, akarora chingamia chigocha. ");
INSERT INTO guz_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka nere akaimokereria amaiso aye igoro, akarora Isaka; erio agaika bwango korwa ase engamia igoro, ");
INSERT INTO guz_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","akabooria omosomba oria: “Monto ki oria ogotaara ase omogondo, ogocha koumerana naintwe?” Omosomba oria akamoiraneria: “Oria nere omonene one.” Erio omoiseke oria akabwata egietubo kiaye, agetuba. ");
INSERT INTO guz_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Na omosomba oria agateebia Isaka amang’ana onsi, buna akorete. ");
INSERT INTO guz_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaka agasoyia Rebeka ase eema ya ng’ina ime, akaba omonywomire, naende akaba omwanchete. Ase ogi, Isaka akaremigwa korwa ase omoichano bw’ogokwa kwa ng’ina. ");
INSERT INTO guz_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aburaamu akanyuoma omokungu onde, ore korokwa Ketura. ");
INSERT INTO guz_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nere akamoiborera Simurani, na Yokisani, na Medani, na Midiani, na Isibaki, na Sua. ");
INSERT INTO guz_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisani akaibora Seba na Dedani. Na basinto ba Dedani nabwo aba: Ashurimu, na Letusi, na Leumi. ");
INSERT INTO guz_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Basinto ba Midiani nabwo aba: Efa, na Eferi, na Hanoki, na Abida, na Elidaa. Abwo bonsi nabwo baarenge abana ba Ketura. ");
INSERT INTO guz_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aburaamu akaa Isaka ebinto bionsi ebi abwate. ");
INSERT INTO guz_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Korende abana b’abakuungu baria ba sere‐sere Aburaamu akabaa ebiegwa. Ekero are moyo, konya atarakwa, akabateebia barue ase omwana oye Isaka, bagende gochia moocha, ase ense ya Moocha. ");
INSERT INTO guz_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aburaamu nigo amenyete emiaka rigana erimo, na emerongo etano na ebere, na etano (175), ase obogima bwaye. ");
INSERT INTO guz_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nigo asogetie omoyo ase obogotu n’obuya, ore omogaka, oisanekire nemiaka emenge; agasangerekana amo nabaanto baye. ");
INSERT INTO guz_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaka na Isumaeli bakamotindeka ase rikuruma agwo Makipela ase oboremo bwa Efuroni, omwana o Sohari, Omohiti, moocha ya Mamure, ");
INSERT INTO guz_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ase oboremo boria Aburaamu agorete korwa ase Abahiti. Agwo nao Aburaamu atindegetwe ase Sara mokaye nere atindegetwe. ");
INSERT INTO guz_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Magega y’ogokwa kwa Aburaamu, Nyasae agasesenia Isaka, omwana oye. Na Isaka akamenya ang’e nensoko yaare korokwa Beeri‐Lahai‐Roi. ");
INSERT INTO guz_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Oro narwo ororeeria rwa Isumaeli, omwana o Aburaamu, oyo Hagari, omosomba o Sara, amoiborerete. ");
INSERT INTO guz_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Aya naro amarieta ’abana ba Isumaeli, ase omooroberio bw’okoiborwa kwabo: Nebayoti, nere omwana oye omotangi, na Kedari, na Adibeeli, na Mibusamu, ");
INSERT INTO guz_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","na Misima, na Duma, na Masa, ");
INSERT INTO guz_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","na Hadadi, na Tema, na Yeturi, na Nafisi, na Kedema. ");
INSERT INTO guz_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Aba nabwo abana ba Isumaeli, na aya naro amarieta abo ase emechie yabo na ebitwori biabo, na barabwo nigo baarenge abagaambi ikomi na babere, ase ebisaku biabo. ");
INSERT INTO guz_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isumaeli nigo aigetie emiaka rigana erimo, na emerongo etato, na etano na ebere (137), erio erio agakwa; agasangererekana amo nabaanto baye. ");
INSERT INTO guz_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Abana ba Isumaeli nigo baamenyete bagachaakera Havila, bagaika Suri moocha ya Misiri, ase enchera ekogenda Asuri; bakamenya babebekaine n’abamwabo bonsi. ");
INSERT INTO guz_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Oro narwo ororeeria rwa Isaka, mosinto o Aburaamu. Aburaamu nere oiborete Isaka. ");
INSERT INTO guz_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka nigo areenge nemiaka emerongo ene ekero anyuomete Rebeka, omoiseke o Betueli, Omoaramu o Padan‐Aramu, omoiseke omwabo Labani, Omoaramu. ");
INSERT INTO guz_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka agasabera mokaye ase Omonene, ekiagera nigo areenge omogomba. Omonene akaigwa ogosaba kwaye, na Rebeka mokaye akaba morito. ");
INSERT INTO guz_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Abana bakaba bakomigana enda yaye ime. Ere akabora: “Onye nabo iga, okoba moyo kwane ninki korangwenere?” Akagenda koboori’Omonene. ");
INSERT INTO guz_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Omonene akamoiraneria, “Ebisaku bibere mbire enda yao ime, abanto babere orache koibora, na barabwo mbaatananekane korwa okoiborwa kwabo; oyomo nabe ne chinguru kobua oria onde, oria omonene omosomba bw’oria omoke.” ");
INSERT INTO guz_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ekero amatuko aye ay’okoibora achia goikerana, bakanyora ne chibarongo chiare enda yaye ime. ");
INSERT INTO guz_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Oyo bw’eritang’ani agasooka, ere nigo areenge omobariri, omobere bwonsi nigo orenge namarionya; bakamoroka Esau. ");
INSERT INTO guz_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Magega yaye oyomwabo agasooka, okoboko kwaye kobwatete egetingiro gia Esau na ere bakamoroka Yakobo. Isaka nigo areenge nemiaka emerongo etano nomo (60), ekero mokaye abaiborete. ");
INSERT INTO guz_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ekero abana abwo bakinire, Esau akaba omotwari bwe ching’iti, korende Yakobo nigo areenge omonto omotoereru, ore kobeera ase chiema. ");
INSERT INTO guz_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaka nigo amwanchete Esau, ekiagera areenge komorentera chinyama chi’obotwari bwaye; korende Rebeka nigo amwanchete Yakobo. ");
INSERT INTO guz_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Rituko erimo Yakobo naiyegete omosori gete. Esau agacha korwa orosana, konya orosire mono, ogoyire ase engencho y’enchara. ");
INSERT INTO guz_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Na Esau agasaba Yakobo: “Koranche, ong’e omosori oyio omobariri inywe, ekiagera n akuure enchara.” Ase ayio bakamoroka Edomu (engencho yaye, omobariri). ");
INSERT INTO guz_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo akamoiraneria: “Ritang’ani ng’oonerie omwando oo bw’okoiborwa kw’obotangi.” ");
INSERT INTO guz_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau agateeba: “Rora, inche nigo inde ang’e gokwa, omwando oyo bw’okoiborwa kw’obotangi inki orankonye?” ");
INSERT INTO guz_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo akamoteebia: “Karatiana ritang’ani ase ’nde.” Esau agatiana, erio akaooneria Yakobo omwando oye bw’okoiborwa kw’obotangi. ");
INSERT INTO guz_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Erio Yakobo akaa Esau omogati na omosori bwe ching’ende, na ere akaria na konywa; erio akaimoka akagenda. Naboigo Esau achayete omwando oye bw’okoiborwa kw’obotangi. ");
INSERT INTO guz_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Bono enchara yachete ase ense eria, nenchara y’ogokumia, tari eria yachete ritang’ani ase engaki ya Aburaamu. Erio Isaka agachiera Abimeleki, omorwoti bw’Abafilisti, aria Gerari. ");
INSERT INTO guz_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Na Omonene akaorokera Isaka, akamoteebia: “Totirimboka gochia Misiri, korende omenye ase ense eye ndakworokererie. ");
INSERT INTO guz_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Obe buna omomenyi ase ense eye, na inche nimbe amo naye, ningosesenie; naki ninkoe aye na ororeeria rwao chinse echi chionsi, na ning’ikeranie eira yane eyio natianete ase Aburaamu iso. ");
INSERT INTO guz_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nimente ororeeria rwao robe oronge buna ching’enang’eni chia igoro; ne chinse echi chionsi ninchiee ororeeria rwao; na ase ororeeria rwao ebisaku bionsi bi’ense inabisesenigwe, ");
INSERT INTO guz_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ekiagera Aburaamu naigwerete amang’ana aane, akabwata aya namochiigete, na amachiiko aane, na aya narigete, amo nogoteebereria kwane.” ");
INSERT INTO guz_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ase igo, Isaka akamenya Gerari. ");
INSERT INTO guz_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ekero abanto b’aase aria baamoboretie amang’ana igoro ya mokaye, akabateebia: “Oyo ’mosubati ominto.” Naki nigo oboete goteeba ng’a ere ’mokaye, akarengereria ng’a abanto b’aase aria mbaabaise komoita ase engencho ya Rebeka, ekiagera ere areenge omonyakieni. ");
INSERT INTO guz_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ekero konya bamenyire aria engaki entambe, Abimeleki, omorwoti bw’Abafilisti, akarigereria korwa ase ekebao, akarora Isaka bakogosoria na Rebeka mokaye. ");
INSERT INTO guz_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Erio Abimeleki akarangeria Isaka, akamobooria: “Amaene, oyo ’mokao? Naki gwakora ogateeba ng’a oyo mosubati omino?” Isaka akamoiraneria: “Nigo nareengereretie ng’a, aande nimbaise goitwa ase engencho yaye.” ");
INSERT INTO guz_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki akamobooria: “Inki eke gwatokoreire iga? Aande monto onde oito areenge gochia araare na mokao, na aye anga nigo gwatobeka ase okomocha.” ");
INSERT INTO guz_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ase ayio Abimeleki agatianera abanto bonsi, akabateebia: “Monto onde bwensi aise gokuna omonto oyo ore aa, gose mokaye, goika aitwe.” ");
INSERT INTO guz_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka agasimeka endagera ase ense eria, akagesa ase omwaka oyio ara rigana, n’Omonene akamosesenia. ");
INSERT INTO guz_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Omonto oyio akaba ne chinguru, akagenderera komenteka gokina, goika akaba nokobua okonene. ");
INSERT INTO guz_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nigo abeete nenibo y’amaicho e ching’ondi ne chiombe, na abasomba abange. Ase igo, Abafirisiti bakamororera ribero. ");
INSERT INTO guz_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","(Ne chinsoko chiria chionsi abasomba ba Aburaamu ise Isaka baremete, Abafirisiti konya bachitichire namaroba.) ");
INSERT INTO guz_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Erio Abimeleki agateebia Isaka: “Karue ase tore, ekiagera aye kwamenyire ne chinguru chinyinge gotobua.” ");
INSERT INTO guz_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ase igo, Isaka akang’anya korwa aroro, agatoora ase ense eraire ya Gerari, akamenya aroro. ");
INSERT INTO guz_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka akarubora chinsoko chiria naende, echio chiaremetwe ase engaki ya Aburaamu ise, ekiagera Abafirisiti konya bachitichire magega Aburaamu g akuure. Isaka agachiroka buna ise achirogete ritang’ani. ");
INSERT INTO guz_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Abasomba ba Isaka bakarema agwo ase ense eraire, bakanyora entuboka y’amaache. ");
INSERT INTO guz_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Abarisia b’ensemo ya Gerari bakaba bakwomana nabarisia ba Isaka, bagoteeba: “Amache aya nayaito.” Ase igo, Isaka Akayeroka entuboka eria Eseki, ekiagera bamwomaneretie aroro. ");
INSERT INTO guz_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Naende bakarema, bakanyora entuboka ende, nero bakayiomanera. Ase igo, akayeroka Sitina. ");
INSERT INTO guz_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Akaimoka korwa agwo, akagenda akarema akanyora entuboka ende; eyio ero tibayiomanera. Ase ayio akayeroka Rehoboti, akabora: “Naki Omonene otoeire ense engare, na toragenderere komenteka ase ense eye.” ");
INSERT INTO guz_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaka akarua aroro, agatiira gochia Beeri‐Seba. ");
INSERT INTO guz_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ase obotuko obwo obw’Omonene akamoorokera, akamoteebia: “Inche ninche Nyasae o Aburaamu iso, tibwoboa, ekiagera nigo inde amo naye, ningosesenie aye amo na ororeeria rwao, ase engencho y’omosomba one Aburaamu.” ");
INSERT INTO guz_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Na Isaka akaagacha egesasiimero aroro, akarangeria erieta ri’Omonene, agatenenia chiema chiaye aroro. Na agwo abasomba baye bakarema, bakanyora entuboka. ");
INSERT INTO guz_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Erio Abimeleki akarwa Gerari, amo n’Ahusati, omosemia oye ase obogaambi, na Pikoli, oria omochiki omonene bw’abarwani baye, bagachiera Isaka. ");
INSERT INTO guz_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Na Isaka akababooria: “Inki mwacha korigia aa bwone, na ekero nare nainwe nigo mongechete, naende mwanseretie korwa seino?” ");
INSERT INTO guz_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bakamoiraneria: “Amaene, twarorire maiso marore ng’a Omonene nigo are amo naye. Na nigo torengereretie ng’a totiananie na tokore okobwatana naye ng’a, ");
INSERT INTO guz_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","bono togotokorera bobe bonde, buna intwe totagokunete, gose totagokorerete bobe, otatiga amaya oka; tokagotiga okagenda bwoo nomorembe. Naye bono nomosesenigwa Omonene.” ");
INSERT INTO guz_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Erio Isaka akabakorera omoyega, bakaria na bakanywa. ");
INSERT INTO guz_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Bakaimoka mambia chuni, bagatianania barabwo ase barabwo; na Isaka akabakooba, na barabwo bakarua asare, bakagenda nomorembe. ");
INSERT INTO guz_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ase rituko riria riria abasomba ba Isaka bagaacha, bakamorentera amang’ana igoro y’entuboka eria banyorete, bakamoteebia: “Twanyorire amaache.” ");
INSERT INTO guz_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ere akayeroka Seba; na ase engencho eyio omochie oyio nigo okorokwa Beeri‐Seba goika reero iga. ");
INSERT INTO guz_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ekero Esau gaika nemiaka emerongo ene akanyuoma Yuditi, omoiseke o Beeri, Omohiti, na Basemati, omoiseke o Eloni, nere n’Omohiti. ");
INSERT INTO guz_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Barabwo babere bagakora obogima bwa Isaka na Rebeka koba nobororo obonge. ");
INSERT INTO guz_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ekero Isaka konya abeire omogotu, nonya na amaiso aye konya amerire orotutu, atari korora buya, akarangeria Esau, omwana oye omotangi, akamoteebia: “Omwana one!” Ere agaitaba: “Nao inde aa Tata.” ");
INSERT INTO guz_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Akamoteebia: “Rora bono inche nagotire, gose timanyeti engaki y’ogokwa kwane. ");
INSERT INTO guz_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Bono bogoria obota n’echinsara chiao, ogende borabu otware ching’iti, ondetere chinyama. ");
INSERT INTO guz_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Erio ondoiserie endagera engiya, eria nyanchete, oyendetere indie, erinde ngosesenie konde moyo, ntarakwa.” ");
INSERT INTO guz_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ko bono, ekero Isaka are gokwana nomwana oye Esau, Rebeka nigo ategererete bobisi. Ase igo, ekero Esau agendete borabu gotwara ching’iti amorentere ise, ");
INSERT INTO guz_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka agateebia Yakobo, omwana oye: “Naigure iso ogoteebia momura omino Esau: ");
INSERT INTO guz_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ndetere chinyama chia borabu, ondoiserie endagera engiya indie, erio inyare kogosesenia ase obosio bw’Omonene, konde moyo, ntarakwa. ");
INSERT INTO guz_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ase igo, omwana one, ntegerera bono aya nkogoteebia. ");
INSERT INTO guz_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Genda getii ase riicho, ondetere chimanwa chie chimbori ibere chingiya, na inche nimoroiserie iso endagera engiya, eria anchete. ");
INSERT INTO guz_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Erio omoirere iso arie, erinde anyare kogosesenia ritang’ani atarakwa.” ");
INSERT INTO guz_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Korende Yakobo agateebia Rebeka ng’ina; “Norooche Esau ominto nomonto omerete amarionya ase omobere oye, korende inche omobere one nigo ore omoterere. ");
INSERT INTO guz_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Aande, Tata nigo arantaba‐tabe, na inche imbe ase amaiso aye buna omong’ainereria, inyerentere okoragererigwa ribaga ri’ogosesenigwa.” ");
INSERT INTO guz_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ng’ina akamoteebia: “Okoragererigwa kwao tiga kobe igoro yane; igwa aya nkogoteebia rimo rioka, genda ondetere chimanwa echio chie chimbori.” ");
INSERT INTO guz_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Erio agwo akagenda, akarentera ng’ina chimanwa echio, na ere akaroisia endagera engiya, eria ise anchete. ");
INSERT INTO guz_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Erio Rebeka akabogoria eanga eria engiya mono ya Esau, omwana oye omotangi; eye nigo yagachire nyomba mwaye, akayebekera Yakobo, omwana oye omoke. ");
INSERT INTO guz_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Na amasankwa aria e chimanwa chie chimbori akamoboyia ase amaboko aye ne rigoti. ");
INSERT INTO guz_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Erio ababeeka ase amaboko ’omwana oye Yakobo endagera eria engiya aroisetie, amo nomogati. ");
INSERT INTO guz_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobo akagenda agasoa nyomba mwaise, akamoteebia: “Tata!” Nere agaitaba: “Nao inde aa. Naye ng’o, mwana one?” ");
INSERT INTO guz_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo akairaneria ise iga: “Ninche Esau, omwana oo omotangi. Nakorire buna gwantebeetie; booka, oikaranse egere orie enyama y’obotwari bwane, erio onsesenie.” ");
INSERT INTO guz_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka akamobooria: “Omwana one, naki gwakora kwanyora ching’iti bwango iga?” Yakobo akamoiraneria: “mboora Omonene, Nyasae oo, ochindetera.” ");
INSERT INTO guz_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Erio Isaka agateebia Yakobo: “Inchuo aiga ang’e ase ’nde, ngotabatabe, erinde imanye gose naye omwana one Esau, gose tari ere.” ");
INSERT INTO guz_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo akagenda agaika ise ang’e, na ere akamotaba‐taba, akabora: “Eriogi rirorio neria Yakobo, korende amaboko naya Esau.” ");
INSERT INTO guz_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Na ise tamomanya, ekiagera amaboko aye nigo areenge namarionya buna aya Esau omwabo. Ase igo, akamosesenia. ");
INSERT INTO guz_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Akamobooria: “Amaene, naye omwana one Esau?” Yakobo akamoiraneria: “Ee, Tata ninche.” ");
INSERT INTO guz_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Naende Isaka akamoteebia: “Ng’ererie endagera eyio gocha ang’e aiga, omwana one, indie enyama y’obotwari bwao, erio ngosesenie.” Ase igo, akamoyeirera endagera eria na ere akaria, akamoa na edivai, akanywa. ");
INSERT INTO guz_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isaka ise akamoteebia: “Omwana one, inchwo aiga ang’e ase ’nde, erio onyunyunte.” ");
INSERT INTO guz_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Erio akamoika ang’e, akamonyunyunta. Isaka agatiokerera rimisu rie chianga chiaye, akamosesenia, akabora: “Naama! Rimisu ri’omwana one Esau nigo rigotioka buna rimisu ri’omogondo omuya, osesenirie n’Omonene! ");
INSERT INTO guz_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tiga Nyasae agoitororere riime rikorwa igoro na obonoru bwe riroba, ne rigesa riao ribe rinyinge, na edivai boigo. ");
INSERT INTO guz_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Abanto bagokorere emeremo, na ebisaku bikoe obonene. Obe omonene ase abamino bonsi, abana ba nyoko bagosike; oyorakoragererie, nere naragererigwe, na oyoragosesenie, nere nasesenigwe!” ");
INSERT INTO guz_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ekero Isaka konya aikire gosesenia Yakobo, na Yakobo karure ase obosio bwa Isaka ise, Esau omwabo akairana korwa ase obotwaari bwaye. ");
INSERT INTO guz_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nere boigo akaroisia endagera engiya, akarentera ise, akamoteebia: “Tata, inchwo orie endagera y’obotwari bwane, inche omwana oo, erinde onsesenie.” ");
INSERT INTO guz_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka ise akamobooria: “Aye naye ng’o?” Ere akamoiraneria: “Ninche Esau omwana oo, okoira kwao ogotang’ani.” ");
INSERT INTO guz_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Erio Isaka agakumia mono na koiguswa, akabora: “Kai! Kai! Ning’o oria ocha ondetera endagera engiya, na inche naria yonsi ekero otaracha, namosesenia? Ee! Ee!, Nere bono oikire gosesenigwa!” ");
INSERT INTO guz_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ekero Esau achia koigwa amang’ana aya korwa ase ise, agakuura na korera ekerero ekenene mono ki’obororo, akamoteebia: “Nsesenie nainche boigo, Tata!” ");
INSERT INTO guz_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Korende Isaka akamoiraneria: “Oyomino nigo achicha nobong’ainereria, na ere bono oirire ogosesenigwa kwao.” ");
INSERT INTO guz_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau akabora: “Inee! Tari korokwa Yakobo ase oboronge? Naki eye nengaki ya kabere ang’ainereirie. Ritang’ani akaira omwando one bw’okoiborwa kw’obotangi, naende bono oirire ogosesenigwa kwane!” Naende agwo kegima akamobooria ise iga: “Inee, tontigarereti ogosesenigwa?” ");
INSERT INTO guz_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka akamoiraneria: “Rora, bono naikire komokora obeire omonene oo, na abamwabo bonsi babe abasomba baye, naende namoeire endagera y’omogondo na edivai. Inki rende bono nkogokorera aye, omwana one?” ");
INSERT INTO guz_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau akabooria ise: “Ogosesenia nokomo gwoka kwabwate, Tata? Nsesenia nainche boigo, Tata ominto.” Esau agaaka egakuura, na akarera nobororo. ");
INSERT INTO guz_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Erio Isaka ise akamoiraneria, akamoteebia, “Rora, obomenyo bwao inabobe aare korwa ase obonoru bwe riroba, na aare korwa ase riimi rikorwa igoro. ");
INSERT INTO guz_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Omoro oo bw’esegi nogere obe moyo, aye nomokorere oyomino emeremo; korende engaki neche orekong’ie, nobune rikorogoto erio akobekeire ase rigoti riao.” ");
INSERT INTO guz_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau akagecha Yakobo ase engencho y’ogosesenigwa okwo ise amosesenetie, agateeba ase omoyo oye ime: “Amatuko ay’okomoreera Tata ng’ang’e are; erio nario ndaite Yakobo.” ");
INSERT INTO guz_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Korende ekero Rebeka ateebigwa aya Esau, omwana oye omonene, agoteeba, agatoma omonto korangeria Yakobo, omwana oye omoke, akamoteebia: “Rora, momura omino Esau ogotianeire ng’a nkogoitare. ");
INSERT INTO guz_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Na bono, omwana one, igwa amang’ana aane, imoka otame gochia o Labani, momura ominto aaria Harani. ");
INSERT INTO guz_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Omenye aroro ase engaki enke, goika ekeririanda kia momura omino gekende. ");
INSERT INTO guz_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ekero endamwamu yaye erakee, na ere ebire aya kwamokorerete, erio nintome abanto bache gokorangeria oirane korwa aroro. Nase ki ndakwerwe nainwe mwensi babere ase rituko erimo.” ");
INSERT INTO guz_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Erio Rebeka agakwana na Isaka, akamoteebia: “Nigo ngechirie mono ase obogima bwane ase engencho y’abaiseke b’Abahiti. Onye Yakobo ogochia konyuoma oyomo bw’abaiseke b’Abahiti, koreng’ana buna aba bamenyete ase ensemo eye, rirorio obogima bwane inki borangwenere?” ");
INSERT INTO guz_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Erio Isaka akarangeria Yakobo, akamosesenia, akamoteebia: “Tobaisa konyuoma omoiseke bw’Abakaanani. ");
INSERT INTO guz_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Imoka, ogende Padan‐Aramu ase omochie o Betueli, sokoro yao, onyuome omokungu oyomo korwa ase abaiseke ba Labani, nyoko-rome. ");
INSERT INTO guz_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Na Nyasae Omobui nagosesenie, agokinie, na oroiboro rwao naromente robe omoganda omonene bw’ebisaku. ");
INSERT INTO guz_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ere nakoe ogosesenigwa kwa Aburaamu, aye amo na ororeeria rwao, erinde onyare koira ense eye ore omomenyi bono, eye Nyasae aete Aburaamu!” ");
INSERT INTO guz_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Naboigo Isaka agateebia Yakobo agende, na ere akagenda Padan‐Aramu ase Labani, mosinto o Betueli Omoaramu, Labani nere momura omwabo Rebeka, ng’ina Yakobo na Esau. ");
INSERT INTO guz_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Bono Esau akarora buna Isaka asesenirie Yakobo na komotoma agende Padan‐Aramu anyuome omokungu korwa aroro, ekiagera ekero amosesenetie, akamokania tabaisa konyuoma moiseke onde bwensi bw’Abakaanani! ");
INSERT INTO guz_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Naende akarora ng’a Yakobo oigwereire ise na ng’ina ochiire Padan‐Aramu. ");
INSERT INTO guz_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ase igo, ekero Esau arooche ng’a Isaka ise tancheti abaiseke abwo b’Abakaanani, ");
INSERT INTO guz_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","nonya obwate abakungu bande, akagenda o Isumaeli, akanyuoma Mahalati, omoiseke o Isumaeli mosinto o Aburaamu, mosubati omwabo Nebayoti, abe omokungu oye amo nabakungu baria bande abwate ritang’ani. ");
INSERT INTO guz_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo akaimoka korwa Beeri‐Seba kogenda Harani. ");
INSERT INTO guz_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Agaika aase gete, akaraara agwo botuko, ekiagera erioba konya riagure. Akabogoria rigena erimo ri’aase aria, agatoorera omotwe oye ase rigena riria, karaaire. ");
INSERT INTO guz_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Akaroota, akarora engaasi getenenirie korwa inse y’ense, keigete igoro, na abamalaika ba Nyasae bakoyeriinera na goikera. ");
INSERT INTO guz_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Akarora Omonene oteneine ase obosio bwaye, okobora: “Inche ninche Omonene, Nyasae o Aburaamu, na Nyasae o Isaka. Ense eye oraire ninkoyee aye amo noroiboro rwao; ");
INSERT INTO guz_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","narororwo inarobe oronge buna orotu rw’ense, naye norande gochia ensemo ya bosongo, na moocha, na sugusu, na Irianyi; na asore aye, na ase ororeeria rwao, chiamate chionsi chi’ense inachisesenigwe. ");
INSERT INTO guz_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Rora, inche nimbe amo naye, ninkorende aande onsi ase orabe gokogenda, naende ninkoiranie gocha ase ense eye; naki tinkogotiga goika nagokoreire ayio nagoteebirie.” ");
INSERT INTO guz_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo akaboka korwa ase chitoro chiaye, akabora: “Amaene, Omonene nao are aase aa, na inche tinamanyete.” ");
INSERT INTO guz_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ere akoboa, akabora: “Aa nase okoirokia! Aa takomocha koba enyomba ya Nyasae, aa nao egeita kia igoro.” ");
INSERT INTO guz_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakobo akaboka mambia chuni, akaimokia rigena riria atoorerete omotwe rogoro, akaritenenia buna esiiro koba ekeinyorio, akaumora amaguta igoro yaye. ");
INSERT INTO guz_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Aase aria akaaroka Beteli. Korende ritang’ani omochie oria nigo ore korokwa Lusu. ");
INSERT INTO guz_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Erio Yakobo akaria eira, okobora: “Nyasae karabe amo nainche, andende ase orogendo rwane na kong’a endagera nkoria, ne chianga nkobeeka, ");
INSERT INTO guz_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na inche kondairane ase omochie o Tata nomorembe, eri’Omonene nabe Nyasae one; ");
INSERT INTO guz_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ne rigena eri natenenia aa buna esiiro nigo rirabe enyomba yao, Nyasae. Na kende gionsi orang’e inche, amaene tinkomocha gokoa ensemo ya ikomi.” ");
INSERT INTO guz_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Erio Yakobo akagenderera norogendo rwaye, agaika ense y’abanto ba moocha. ");
INSERT INTO guz_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Agwo akarigereria akarora ensoko yaare ase egetii, na amaicho atato e ching’ondi araire ensoko eyio ensemo, ekiagera ase ensoko eyio nao amaicho are konywera amaache. Na ndiareenge aroro rigena rinene igoro y’omonwa bw’ensoko. ");
INSERT INTO guz_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Agwo nao amaicho onsi areenge gosangererekana, na abarisia nigo baare korusia rigena riria korwa ase omonwa bw’ensoko banyoinsia ching’ondi, naende bariirania ase omonwa bw’ensoko. ");
INSERT INTO guz_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo akababooria: “Baminto, ng’ai seino?” Abarisia baria bakamoiraneria: “Seito naiga Harani.” ");
INSERT INTO guz_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Naende akababooria: “Inee! Momanyete Labani, mochokoro o Nahori?” Barabwo bakamoiraneria: “Ee, ntomomanyete.” ");
INSERT INTO guz_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Naende akababooria: “Mbuya are?” Abarisia bakamoiraneria: “Ee, mbuya are; na rigereria, Raeli, omoiseke oye oyio ogocha ne ching’ondi!” ");
INSERT INTO guz_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Akabateebia: “Rigereria, bono mobaso, chinsa chi’ogosangereria amaicho tichiraika, nyoinsia ching’ondi, naende mochiire korisia.” ");
INSERT INTO guz_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Korende barabwo bakamoiraneria: “Titokonyara gokora bo goika ekero amaicho onsi arache asangererekane amo, erinde abarisia bamanye gotigeria rigena korwa ase omonwa bw’ensoko; erio tomanye konyoinsia ching’ondi.” ");
INSERT INTO guz_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ekero areenge ogendererete gokwana nabarabwo, Raeli agacha obwate ching’ondi chia ise, naki nere orenge gochirisia. ");
INSERT INTO guz_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Bono ekero Yakobo achia korora Raeli, omoiseke o Labani, ng’ina rome, okorenta riicho ria Labani, akaimoka, agatigeria rigena riria korwa ase omonwa bw’ensoko, akanyoinsia ching’ondi chia Labani, ng’ina rome. ");
INSERT INTO guz_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Erio Yakobo akaagata Raeli, akarera na koiyeria amariga. ");
INSERT INTO guz_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Agateebia Raeli, “Inche nomoigwa o iso, omwana o Rebeka.” Raeli akaminyoka, agateebia ise amang’ana ayio. ");
INSERT INTO guz_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ekero Labani achia koigwa amang’ana a Yakobo, omoigwa oye, akaminyoka gochia komoorotota, akamoagata n’amaiga amanene, akamoira gochia nka bwoye. Yakobo agateebia Labani amang’ana onsi. ");
INSERT INTO guz_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Erio Labani akamoteebia: “Amaene, aye namanyinga omobere one.” Ere akamenya bwoye ase engaki y’omotienyi oyomo. ");
INSERT INTO guz_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani agakwana na Yakobo, akamoteebia: “Nonya kore omoigwa one, tegwenereti onkorere emeremo bosa. Nteebia eng’eria yao ninki ndakoe!” ");
INSERT INTO guz_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Bono Labani nigo abwate abaiseke babere; omoiseke oria omonene nigo are korokwa Lea, na oria omoke Raeli. ");
INSERT INTO guz_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea amaiso aye nigo areenge amatu, korende Raeli nigo areenge omonyakieni, naende omwasioku. ");
INSERT INTO guz_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo konya omwanchire Raeli, na ase ayio agateebia Labani, “Ningokorere emiaka etano na ebere, erinde ong’e Raeli, omoiseke oo omoke.” ");
INSERT INTO guz_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani akamoiraneria, “Ayio mbuya. Tiga nkomoe aye kobua ’nkomoa omonto onde; menya aa bwone.” ");
INSERT INTO guz_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ase igo, Yakobo akamokorera emiaka etano na ebere aegwe Raeli. Emiaka eyio ekarorekana asare buna namatuko makeigo, ekiagera nigo amwanchete Raeli mono. ");
INSERT INTO guz_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Erio Yakobo agateebia Labani: “Bono naikeranirie engaki yane, ing’a mokane, tobe nere.” ");
INSERT INTO guz_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ase igo, Labani akarangeria abanto bonsi b’ensemo eria, agakorera omoyega. ");
INSERT INTO guz_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Rigachia koba mogoroba Labani akaimokia Lea, omoiseke oye omonene, akamorentera Yakobo, erio Yakobo akaba nere. ");
INSERT INTO guz_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ase ekero ekio Labani akarua omosomba oye omoiseke okorokwa Silpa, abe omokoreri o Lea, omwana oye. ");
INSERT INTO guz_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Bogachia gokia mambia, Yakobo akanyora ng’a ’Lea aetwe. Erio akabooria Labani: “Inki eke gwankorerete? Tinagokorerete, erinde ong’e Raeli? Naki gwakorete okang’aina?” ");
INSERT INTO guz_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani akamoiraneria: “Aiga seito intwe titori gokora bo, gosokia omoiseke omoke, na gotiga omonene. ");
INSERT INTO guz_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tiga omoyega oyo bw’amatuko aya atano na abere oraera bw’oyio omonene, erio noegwe na oria omoke, naende aye onkorere emeremo emiaka ende etano na ebere.” ");
INSERT INTO guz_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo agancha ebe boigo, erio agaikerania amatuko ayio atano na abere. Erio Labani akamomoa Raeli, omoiseke oye omoke, abe mok’aye. ");
INSERT INTO guz_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani akamoa Raeli, omwana oye, omokoreri, nere Bilia, omosomba oye omoiseke. ");
INSERT INTO guz_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ase igo, Yakobo akaba na Raeli; na agancha Raeli mono kegima kobua Lea. Erio Yakobo naende agakorera Labani emiaka ende etano na ebere. ");
INSERT INTO guz_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ekero Omonene arooche ng’a Lea tanchiri, akamosesenia ase oroiboro rwa abana, korende Raeli ere nigo areenge omogomba. ");
INSERT INTO guz_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea akaba morito, akaibora omwana omoisia, akamoroka Rubeni, naki nigo atebeete: “Omonene ororire buna ’nchayire. Korende ase engencho y’okoibora, bono omosacha one nanyanche.” ");
INSERT INTO guz_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Naende Lea akaba morito, akaibora omwana omoisia, akabora: “Omonene ororire ng’a tinyanchiri, naende ong’eire omwana onde omoisia boigo,” akamoroka Simioni. ");
INSERT INTO guz_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Naende akaba morito, akaibora omwana omoisia, akabora: “Bono engaki eye omosacha one nabwatane amo nainche, ekiagera namoiboreire abana abaisia batato.” Ase ayio akamoroka Lawi. ");
INSERT INTO guz_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Akaba morito naende, akaibora omwana omoisia, akabora: “Engaki eye nintogie Omonene.” Ase ayio akamoroka Yuda. Erio Lea agatenena koibora. ");
INSERT INTO guz_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ekero Raeli arooche ng’a tari koiborera Yakobo abana, akarorera mosubati omwabo ribero, agateebia Yakobo: “Ing’a abana! Otabang’eti, rirorio nigo ndakwe!” ");
INSERT INTO guz_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo akabea Raeli mono, akamobooria: “Inee! Ninche inde ribaga ria Nyasae, oyogotangete tikwaegwa abana?” ");
INSERT INTO guz_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Erio akamoiraneria: “Nimbwate omosomba one omoiseke, Bilia. Motware, erinde inyore abana korwa asare, barokwe abana baane, na goetera asare na inche inyore oroiboro.” ");
INSERT INTO guz_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Naboigo Yakobo akaegwa Bilia, omosomba omoiseke o Raeli, abe mokaye, na Yakobo akaba nere. ");
INSERT INTO guz_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilia akaba morito, akaiborera Yakobo omwana omoisia. ");
INSERT INTO guz_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Erio Raeli akabora: “Nyasae ong’eire oboronge bwane, amaene, oigure ekerero kiane, ong’eire omwana omoisia.” Ase ayio akamoroka Dani. ");
INSERT INTO guz_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilia, omosomba o Raeli, akaba morito naende, akaiborera Yakobo omwana omoisia o kabere. ");
INSERT INTO guz_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raeli akabora: “Ase okoamererania okonene namenyire nkoamererania na mosubati ominto, nabuire.” Ase igo, akamoroka Nafutali. ");
INSERT INTO guz_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ekero Lea achia korora ng’a Bilia okoorire koibora abana, akaimokia Silpa, omosomba oye omoiseke, akamomoa Yakobo, abe mokaye. ");
INSERT INTO guz_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Erio Silpa, omosomba omoiseke o Lea, akaiborera Yakobo omwana omoisia. ");
INSERT INTO guz_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea akabora: “Ninde negesio.” Akamoroka Gadi. ");
INSERT INTO guz_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpa, omosomba o Lea, akaiborera Yakobo omwana omoisia o kabere. ");
INSERT INTO guz_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea akabora: “Inche ninde nomogooko omonene, naki abakungu nabandoke Oyore n’omogooko.” Ase igo, akamoroka Aseri. ");
INSERT INTO guz_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ase engaki ye rigesa ri’engano Rubeni akagenda akanyora amasooni ng’ombe getii, akayatwa, akayarentera Lea ng’ina. ");
INSERT INTO guz_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Erio Raeli agasaba Lea amwatanere amasooni ng’ombe y’omwana oye, korende Lea akamoiraneria: “Inee! Nering’ana rike kwang’urire omosacha one, na bono korigetie koira amasooni ng’ombe ay’omwana one boigo?” Raeli akamoiraneria: “Reero nache araare naye, korang’e amasooni ng’ombe y’omwana oo.” ");
INSERT INTO guz_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ekero Yakobo areenge koirana korwa mogondo mogoroba, Lea akagenda komoorotota, akamoteebia: “Reero goika oraare mwane, nakogorire namasooni ng’ombe ay’omwana one.” Ase obotuko Yakobo akaba nere. ");
INSERT INTO guz_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nyasae akaigwa Lea, na ere akaba morito, akaiborera Yakobo omwana omoisia o gatano. ");
INSERT INTO guz_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea akabora: “Nyasae ong’eire eng’eria yane, ekiagera naete omosacha one omosomba one omoiseke.” Ase igo, Akaaroka omwana oria Isakaru. ");
INSERT INTO guz_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea akaba morito naende, akaiborera Yakobo omwana omoisia o gatano na rimo. ");
INSERT INTO guz_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Erio Lea akabora: “Nyasae ong’eire ekeegwa ekiya; bono omosacha one nansike, ekiagera namoiboreire abana abaisia batano nomo.” Ase igo, akamoroka Sabuloni. ");
INSERT INTO guz_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Magega yaye akaibora omwana omoiseke, akamoroka Dina. ");
INSERT INTO guz_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Korende Nyasae akamoinyora Raeli, akaigwa ogosaba kwaye, na akaigora enda yaye; ");
INSERT INTO guz_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ere akaba morito, akaibora omwana omoisia, akabora: “Nyasae onduseirie ogochaywa kwane.” ");
INSERT INTO guz_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Akaroka omwana oria Yusufu, akabora: “Tiga Omonene karanche amentere omwana onde omoisia.” ");
INSERT INTO guz_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ekero Raeli aiboire Yusufu, Yakobo agateebia Labani: “Ing’a ribaga ngende seito, ase ense yane. ");
INSERT INTO guz_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ing’a abakungu baane na abana baane, aba namenyire nkogokorera, ontige ’ngende seito; naki nomanyete emeremo nabeire nkogokorera.” ");
INSERT INTO guz_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani akamoiraneria: “Oise kong’anchera nkwane iga, rigereria namanyire boronge ng’a Omonene onsesenirie mono ase engencho yao. ");
INSERT INTO guz_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Bono nteebia eng’eria yao ey’oganetie, na inche ninkoyee.” ");
INSERT INTO guz_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo akamoiraneria: “Aye omonyene nomanyete buna nabeire omokoreri oo, na amaicho ao buna abeire ase oborendi bwane. ");
INSERT INTO guz_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Naki enibo yao nigo yareenge enke ritang’ani ekero ntaracha aa, korende bono yamentekanire mono kegima. Omonene ogosesenirie aye, aande onsi ase nabeire nkogenda kogokorera emeremo. Ko bono, inche indi ndabe nkoroisia amang’ana abwone inche omonyene?” ");
INSERT INTO guz_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani akamobooria: “Ninki ndakoe rende?” Yakobo akamoiraneria: “Tinganeti ong’e kende. Oise gonkorera ring’ana eri ndagoteebie rioka, rirorio naende ningenderere korisia amaicho ao, na koyarenda. ");
INSERT INTO guz_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tiga ng’ete reero ase amaicho ao onsi, ndusie korwao kera eng’ondi emechege na egesembe, na emaanwa y’eng’ondi emwamu, na kera embori nyankororo na nyankanga. Erinde echio nachio chirabe eng’eria yane. ");
INSERT INTO guz_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ase igo, amatuko agochia bosio, ekero orache korora eng’eria yane, oboronge bwane nabombeere kirori. Kera embori etari nyankanga gose nyankororo, na kera emaanwa y’eng’ondi etari emwamu, onye ekonyorekana ase ’nde, oyebare ng’a eyio nigo eibire.” ");
INSERT INTO guz_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani agancha amang’ana ayio, agateeba: “Tiga abe buna gwateebire.” ");
INSERT INTO guz_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ase rituko erio erio Labani akarusia chigoree chiimarera ne chinkororo, ne chimbori chiaberi, echiare nyankanga ne chire nyankororo, na kera eyare nebimoa ebirabu ase omobere oye, na kera eng’ondi eyare emwamu. Echio chionsi agachia abana baye abamura bachirende. ");
INSERT INTO guz_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Erio ageatanana korwa ase Yakobo oboare bw’orogendo rw’amatuko atato; na Yakobo agatigara okorisia riicho ria Labani eriatigarete. ");
INSERT INTO guz_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakobo agatwa ebite ebibese biomopopla akabisata chinsemo, erinde emeng’ororia emerabu ekarorekana ase ebite biria. ");
INSERT INTO guz_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Erio akabeeka ebite biria ase chintuba chi’amaache ase amaicho are gocha konywera. Na ekiagera ching’iti chiria chiare koa chiaberi amarieme, ekero chigocha konywa amaache, ");
INSERT INTO guz_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","chirochio chikanyora amarieme bosio bw’ebite ebio, chikabiara chimanwa chire chimarera, ne chinkanga, ne chire nyankororo. ");
INSERT INTO guz_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Na Yakobo agaatanana ching’ondi chimingichi, ne ching’ondi chiaberi agachisang’anania ne chimingichi chie riicho ria Labani echiareenge namagwari, na echiare chimwamu. Naboigo akenyorera amaicho aye ere omonyene, ayio atabegete amo naya Labani. ");
INSERT INTO guz_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kero kende gionsi chimbori gose ching’ondi echiare ne chinguru gochiaganirie amarieme, Yakobo nigo are kobeeka ebite biria bosio bwe ching’iti ase chintuba chiria chinyare konyora amarieme gochikorigereria ebite ebio. ");
INSERT INTO guz_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Korende echiare chinyoro tare gochibekera ebite ebio. Ase igo, echiare chinyoro nigo chiare koba echia Labani, na echiare ne chinguru chiba echia Yakobo. ");
INSERT INTO guz_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ase igo, Yakobo akaba okomenteka koba omotenenku, akaba namaicho amange, na abasomba, abaiseke na abamura, ne chingamia, ne chitigere. ");
INSERT INTO guz_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bono basinto ba Labani bakaigwekana kwemurungania bagoteeba ng’a: “Yakobo oirire enibo yonsi ya tata; na ase enibo eyio bwenyoreire obotenenku obwo bwonsi abwate.” ");
INSERT INTO guz_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo akanyora ng’a Labani oonchokire, tamorigereretie buya buna botambe. ");
INSERT INTO guz_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Eri’Omonene agakwana na Yakobo, akamoteebia: “Irana gochia ase ense ye chisokoro chiao, ase eamate yao, na inche nimbe amo naye.” ");
INSERT INTO guz_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ase igo, Yakobo akagania Raeli na Lea barangerigwe, erio Raeli na Lea bakagenda getii ase Yakobo areenge korisia amaicho aye. ");
INSERT INTO guz_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Agwo Yakobo akabateebia: “Narorire ng’a iso tari kondigereria buya reero buna botambe. Korende Nyasae o tata nigo are amo nainche. ");
INSERT INTO guz_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Inwe ’momanyete ng’a nabeire ngokorera iso ne chinguru chiane chionsi; ");
INSERT INTO guz_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","nonya nabo, iso obeire okong’ainereria, na koonchora eng’eria yane ara ikomi, korende Nyasae tamoete ribaga gonkorera bobe. ");
INSERT INTO guz_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Onye otebeete: ‘Echire nebisembe echio nachio chirabe eng’eria yao, amaicho onsi akabiara echire nebisembe, na ekero atebeete.’ Echire namagwari nachio echio chirabe eng’eria yao, amaicho onsi akabiara echire namagwari. ");
INSERT INTO guz_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Naboigo Nyasae akarusia etugo ya iso, akayeng’a.” ");
INSERT INTO guz_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ase engaki eria amaicho gachiire rieme nkarigereria, nkarora ase chindoto ng’a chigoree echiaete amaicho amarieme nigo chiare namagwari na ebisembe, ne chimechege. ");
INSERT INTO guz_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Erio omomalaika o Nyasae akandangeria ase chindoto: Yakobo! Nainche ngaitaba: ‘Nao inde aa!’” ");
INSERT INTO guz_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Aganteebia: “Imokereria amaiso ao igoro, origererie orore, ng’a chigoree echiaete amaicho amarieme nigo chiare namagwari, na ebisembe, ne chimechege, naki narorire onsi aya Labani abeire okogokorera. ");
INSERT INTO guz_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Inche ninche Nyasae oria kwarooche aria Beteli, aria ase kwaumorerete rigena amaguta rikaba esiiro y’ekeinyorio, na okandiera eira. Bono imoka korwa ase ense eye, oirane gochia ase ense eria kwaiboreretwe.” ");
INSERT INTO guz_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Erio Raeli na Lea bakamoiraneria: “Inee! Ntwe ntori na egetari gose omwando ase omochie o tata? ");
INSERT INTO guz_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tatokorete buna abamenyi? Naki nigo atoonetie, naende akaria enibo eria yonsi. ");
INSERT INTO guz_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Naki enibo eyio yonsi Nyasae arusirie korwa ase tata nigo etotungetie intwe na abana baito. Ase igo, ayio onsi Nyasae agoteebirie, yakore.” ");
INSERT INTO guz_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ase igo, Yakobo akaimoka, akariinia abana baye na abakungu baye ase chingamia igoro; ");
INSERT INTO guz_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","akaira amaicho aye onsi, na enibo yaye yonsi eyio anyorete ase Padan-Aramu, erio akagenda ase ense ya Kaanani o Isaka ise. ");
INSERT INTO guz_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ekero Labani konya achiire konacha ching’ondi chiaye amarionya, Raeli akaiba ebinyasae biaye bi’ogosasiimwa, ebiareenge nyomba mwaye. ");
INSERT INTO guz_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo nigo agendete bobisi korwa o Labani Omoaramu, tamoteebetie ng’a nkogenda are sobo. ");
INSERT INTO guz_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Agatama amo nenibo yaye yonsi eye abwate, akaamboka orooche roria rware korokwa Eufarati, akagenda gochia ebitunwa bia Gileadi. ");
INSERT INTO guz_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ase rituko ria gatato Labani agateebigwa ng’a Yakobo otamire. ");
INSERT INTO guz_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Erio Labani akaira abamwabo, bakamobwatia ase orogendo rw’amatuko atano na abere, akamoikeera ase ebitunwa bia Gileadi. ");
INSERT INTO guz_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Korende Nyasae agaachera Labani Omoaramu ase chindoto botuko, akamoteebia: “Bwerende, tobaisa kwomania Yakobo, korende okwane nere ase obwororo.” ");
INSERT INTO guz_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ekero Labani aikeereire Yakobo, Yakobo nere konya otenenirie eema yaye agwo ase ebitunwa bia Gileadi. Labani nere amo nabamwabo bagatenenia chiema chiabo agwo. ");
INSERT INTO guz_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani akabooria Yakobo: “Inki eke gwakorire iga? Ninki okong’ainera, na koira abana baane abasubati buna abasakorwa korwa ase esegi? ");
INSERT INTO guz_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nase ki gwatamete okeiberia, tigwanteebia? Inche anga nagokoobete nomochengo na amatera, na kobugia chikonu na amakano. ");
INSERT INTO guz_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Naki otantigerete ribaga inyunyunte abachokoro baane na abana baane abasubati, mbaganerie amaya ase orogendo rwabo? Amaene, aye nigo gwankorerete egento ki’oboriri. ");
INSERT INTO guz_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ninde nokobua gw’okogokorera amabe, korende Nyasae o iso nakwanete nainche ase obotuko bwaetete, agankurera aganteebia: Bwerende, tobaisa kwomania Yakobo, korende okwane nere ase obwororo. ");
INSERT INTO guz_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Na bono gwachiire, ekiagera ore namaiga amange ay’abaanto banka seino, korende naki gwakorete okaiba emegwekano y’enyasae yane?” ");
INSERT INTO guz_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo akamoiraneria, akamoteebia: “Nigo noboete, nkarengereria ng’a nobaise kong’ura abana bao abasubati. ");
INSERT INTO guz_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Onde bwensi oranyore obwate ebinyasae biao goika aitwe akwe. Tiga abaminto aba bare aa babe kirori. Rigia! Koranyore kende kiao kere ase ’nde, okeire.” Yakobo tamanyete ng’a Raeli obiibire. ");
INSERT INTO guz_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Erio Labani agasoa eema ya Yakobo, na eya Lea, na ey’abakungu baria babere abasomba, tanyora kende. Agasoka korwa ase eema ya Lea, agasoa eya Raeli. ");
INSERT INTO guz_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Korende Raeli konya obisire ebinyasae ebio ase egeikaransero kiaye igoro y’engamia, akaba obiikaranserete. Labani akariga‐rigia eema ime, tabinyora. ");
INSERT INTO guz_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raeli agateebia ise: “Tata, onyabere, tobaisa kombea, naki tinkonyara koimoka ase obosio bwao, ekiagera nimbwate engencho yaito intwe abakungu.” Nabo akariga‐rigia, korende tanyora chinyasae chiaye. ");
INSERT INTO guz_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Erio Yakobo akabea mono, akomania Labani ase okomotogonyera na goteeba: “Nkomocha ki nakorire? Nebibe biane nakorire mbiribi, goika kwagerire nabeire nobororo engencho enga eye? ");
INSERT INTO guz_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kwariga‐rigirie ase ebinto bionsi. Ngento ki kiao kwanyorao narentanire? Kebeke aiga ase obosio bw’abaminto na obw’abamino, batwatanane inche naye. ");
INSERT INTO guz_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Bono inche namenyire bwoo emiaka emerongo ebere. Ching’ondi chiao gose chimbori, ekero chianga amarieme, ende terekereti; gose inche tinyenyeti chimingichi chinde chie riicho riao, na gochiria. ");
INSERT INTO guz_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Echiaitetwe ne chinyang’au tingochirentereti, ninche omonyene nachiakanete. Echiaibetwe mobaso gose botuko ogachinsaba korwa ase amaboko aane. ");
INSERT INTO guz_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Eye nero yareenge engencho yane: Riberera ri’omobaso boira rikaba rigonsamba, na obokendu boganchanda botuko, ne chitoro chikaera korwa ase amaiso aane. ");
INSERT INTO guz_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Emiaka eye emerongo ebere imenyete bwoo, nabeire nkogokorera emiaka ikomi na ene ase okonyora abaiseke bao babere, na emiaka etano nomo ase okonyora amaicho ao, na aye kwabeire gokoonchora eng’eria yane ara ikomi. ");
INSERT INTO guz_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Onye Nyasae o tata, Nyasae o Aburaamu, Nyasae oyio Isaka airogete ataarenge amo nainche, amaene, nanga nigo gwanseria bono inde namaboko amasa. Emechando na emeremo yane Nyasae oyerorire, Ase igo ere nagotogonyerete obotuko bwaetete.” ");
INSERT INTO guz_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani akairaneria Yakobo, akamoteebia: “Abasubati aba nabana baane, na abana babo nabarabwo nabana baane, na amaicho aya, naro nayaane, na bionsi ebio orooche nebiane. Bono ninki ndanyare gokorera abana baane na abana babo baiboire? ");
INSERT INTO guz_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Inchuo bono, tokore okobwatana, aye nainche, na korokwo inakobe kirori egati yao nainche.” ");
INSERT INTO guz_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Erio Yakobo akaimokia rigena, akaritenenia ribe esiiro y’ekeinyorio. ");
INSERT INTO guz_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakobo agateebia abamwabo: “Sangereria amagena”, na barabwo bakayasangereria, bakayakora etui, bakariera endagera ase etui eyio. ");
INSERT INTO guz_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani akayeroka Yegari‐Sahaduta, korende Yakobo akayeroka Galeedi. ");
INSERT INTO guz_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani akabora: “Etui eye nero kirori egati yane naye reero iga.” Ase ayio akayeroka Galeedi. ");
INSERT INTO guz_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Naende ekarokwa Misipa, naki nigo ateebete: “Omonene nere orabe ogotorigereria aye nainche, ekero torabe totarochaini. ");
INSERT INTO guz_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Korabe gokobachanda abana baane abasubati, gose gokonyuoma abakungu bande abaao goetania barabwo, manya ng’a nonya monto onde taiyo oyarooche, rora, Nyasae nere kirori egati yao nainche.” ");
INSERT INTO guz_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Erio Labani agateebia Yakobo: “Rigereria etui eye na esiiro eye, natenenirie egati yao nainche. ");
INSERT INTO guz_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Etui eye ebe kirori, na esiiro eye ebe kirori boigo, ng’a tingotamboka etui eye inchiche bwoo, gose aye togoetania etui eye na esiiro eye ochiche bwone, tokorerane amabe. ");
INSERT INTO guz_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nyasae o Aburaamu, Nyasae o Nahori, oyorenge Nyasae o ise obo, agambe ase egati yaito.” Ase igo, Yakobo agatiana ase Oyio Isaka ise airogete. ");
INSERT INTO guz_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobo akarua ekeng’wanso agwo ase egetunwa, akarangeria abanto baye bache koragera amo nere, bakaba aroro ase egetunwa obotuko obwo bwonsi. ");
INSERT INTO guz_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mambia chuni Labani akaimoka, akaagata abachokoro baye na abana baye abasubati, akabasesenia; erio akairana gocha bwoye. ");
INSERT INTO guz_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo akagenderera norogendo rwaye, bakaumerana nabamalaika ba Nyasae. ");
INSERT INTO guz_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Na ekero Yakobo abarooche akabora: “Oyo nomoganda o Nyasae!” Ase igo, Akaaroka aase aria Mahanaimu. ");
INSERT INTO guz_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo agatoma abatomwa batang’ane kogenda ase Esau momura omwabo, baike ensemo ya Edomu, ase ense y’Edomu. ");
INSERT INTO guz_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Akabachiika bateebie Esau omonene oye iga: “Aya naro Yakobo, omosomba oo, agokwana: Nabeire nkomenya ase ense y’obogeni, ense ya Labani goika reero iga; ");
INSERT INTO guz_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","nanyorire chiombe, ne chitigere, ne ching’ondi, na abasomba, abamura na abaiseke. Na bono, omonene one, nigo natomire abanto nkomanyie amang’ana ayio, inyoore ogwancherwa ase obosio bwao.” ");
INSERT INTO guz_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Abatomwa baria, ekero bairanete ase Yakobo bakamoteebia: “Ntwaika o momura omino Esau, ere ngocha are gokorotota ore nabaanto amagana ane (400).” ");
INSERT INTO guz_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Erio Yakobo akaondoka mono na koumata, agaatanana abanto baria baarenge amo nere, ne ching’ondi, ne chiombe, ne chingamia, bikaba ebiombe bibere, ");
INSERT INTO guz_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","akarengereria ng’a: “Esau karache aumokere ekeombe kie ritang’ani na kogesiria, keria kende nagetooreke.” ");
INSERT INTO guz_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Erio Yakobo agasaba, akabora: “Aye Nyasae o sokoro yane Aburaamu, Nyasae o Isaka tata, aye Omonene, gwanteebetie ng’a: Oirane gochia seino, na eamate yao, na inche ningokorere amaya. ");
INSERT INTO guz_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Inche tingwenereti nonya ng’ake obuya na obwegenwa bwonsi gwankorerete inche, omosomba oo, naki engaki naambogeete orooche rwa Yorodani nigo nabwate enyimbo yoka koboko kwane, na bono nabeire ebiombe bibere. ");
INSERT INTO guz_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Koranche ontoorie bono korwa ase okoboko kw’oyominto Esau, ekiagera nairokire ng’a nabaise kong’ita, aite na abakungu na abana. ");
INSERT INTO guz_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Korende aye ngwanteebetie: Ningokorere amaya, ninkore ororeeria rwao robe buna omokenye o nyancha, otanyare kobareka, ekiagera nomonge.” ");
INSERT INTO guz_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Erio Yakobo akaraara aroro ase obotuko obwo; agachora korwa ase etugo eria abwate, echio aranyare koa Esau omwabo ebiegwa. ");
INSERT INTO guz_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Agachoora chimbori chiaberi amagana abere, ne chigoree emerongo ebere, ne ching’ondi chiaberi amagana abere, ne chimingichi emerongo ebere, ");
INSERT INTO guz_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ne chingamia chiare gokamwa emerongo etato, amo ne chimori chiabo, ne chiombe chiaberi emerongo ene, ne chieeri ikomi, ne chitigere chiaberi emerongo ebere, ne chitigere chinsacha ikomi. ");
INSERT INTO guz_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Akabeeka ching’iti echio ase amaboko ’abasomba baye, kera riicho akaribeeka ao, agateebia abasomba baye: “Eta motang’ane, na egati ya kera riicho motige ribaga.” ");
INSERT INTO guz_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Agachiika omosomba oria bw’eritang’ani, akamoteebia: “Esau ominto, ekero araumerane naye, na gokoboria: Noyo ng’o ore? Ng’ai ogochia? Etugo eye otang’anetie, neya ng’o?. ");
INSERT INTO guz_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Erio omoiranerie, omoteebie: Ney’omosomba oo Yakobo, nekeegwa akorenteire aye omonene one Esau; ere omonyene ngotobwatia are korwa magega,” ");
INSERT INTO guz_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Agachiika naende oyo o kabere, na oyo o gatato, na abande bonsi abaare gotunyana amaicho, akabateebia: “Moteebie Esau amang’ana ayio ayio ekero mokoumerana nere. ");
INSERT INTO guz_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Naende momoteebie: Omosomba oo Yakobo ngotobwatia are korwa magega.” Ere nigo arengereretie ng’a: “Nimwororobie nebiegwa ebi namotang’aneirie; magega yaye nindore obosio bwaye, aande nanyanchere.” ");
INSERT INTO guz_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Naboigo ebiegwa biria bigatang’anigwa gochia bosio bwaye, ere omonyene akaraara obotuko obwo aase aria atenenetie eema yaye. ");
INSERT INTO guz_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ase obotuko obwo Yakobo akaimoka, akaira abakungu baye babere, na abasomba baye babere abakungu, na abana baye ikomi nomo, akaamboka orooche rwa Yaboki. ");
INSERT INTO guz_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Akabaimokia, akabaambokia orooche, akaambokia na bionsi ebi areenge nabio. ");
INSERT INTO guz_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakobo agatigara ere bweka. Erio omonto oyomo agacha bagakinana nere, goika bogakiamoka. ");
INSERT INTO guz_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nere omonto oria, ekero arora ng’a tari kobua Yakobo, akamokuna enengo y’ebachwa, akamoteng’eria, kobagendererete gokinana. ");
INSERT INTO guz_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Erio akamoteebia: “Ntige ngende, ekiagera bwakiire.” Korende Yakobo akamoteebia: “Tingokoa ribaga ogende, otaransesenia.” ");
INSERT INTO guz_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Akamobooria: “Naki okorokwa?” Akamoiraneria: “Yakobo.” ");
INSERT INTO guz_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Erio akamoteebia: “Bono tokorokwa naende Yakobo, nigo orarokwe Israeli, ekiagera mwakinanire na Nyasae na abanto, na aye kwabuire.” ");
INSERT INTO guz_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo akamobooria: “Koranche, onteebie erieta riao.” Korende akamoteebia: “Nase ki okomboria erieta riane?” Agwo akamosesenia. ");
INSERT INTO guz_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo Akaaroka aase aria Penieli, naki nigo ateebete: “Naroranire na Nyasae obosio ase obosio, na obogima bwane bwatoorigwe.” ");
INSERT INTO guz_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Erioba rikaorokera Yakobo kagoeta Penueli, akaba ogosegora, ekiagera ateng’eretigwe enengo y’ebachwa. ");
INSERT INTO guz_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ase ayio Abaisraeli tibari koria omoki bw’enengo y’ebachwa goika reero iga, ekiagera omonto oria namoteng’eretie Yakobo omoki bw’enengo y’ebachwa yaye. ");
INSERT INTO guz_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo akaimokereria amaiso aye igoro, akarigereria, akarora Esau ogocha amo nabaanto amagana ane. Erio agaatanana abana, akaa kera omokungu abaye, Lea, na Raeli, na abakungu baria babere abasomba. ");
INSERT INTO guz_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Akabeeka abakungu baria abasomba amo nabana babo batang’ane, na Lea amo nabana baye korwa magega yabo, na Raeli na Yusufu akababeeka magega kegima. ");
INSERT INTO guz_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ere omonyene agatang’ana bosio bwabo, akaba okona‐gotung’ama inse chintunda isano na ibere goika agaika ase oyomwabo. ");
INSERT INTO guz_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau akaminyoka gochia komorotota, akamoboania rigoti riaye, na komoagata, barabwo bakareererana. ");
INSERT INTO guz_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ekero Esau achia koimokereria amaiso aye igoro, akarora abakungu na abana, akamobooria: “Aba nabang’o more komo?” Yakobo akamoiraneria: “Aba nabana Nyasae ang’eire inche, omosomba oo, ase obuya bwaye.” ");
INSERT INTO guz_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Erio abakungu baria abasomba bagasuka gochia ang’e, kera oyomo nabana baye, bagatung’ama inse. ");
INSERT INTO guz_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea nere boigo agasuka gochia ang’e amo n’abana baye, nabarabwo bagatung’ama inse. Magega kegima Yusufu na Raeli bagasuka gochia ang’e, nabarabwo boigo bagatung’ama inse. ");
INSERT INTO guz_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Naende Esau akamobooria: “Emeganda eye yonsi twaumerana gochia aa, neya ki?” Yakobo akamoiraneria: “Engencho yaye inyore ogwancherwa ase obosio bwao, aye omonene one.” ");
INSERT INTO guz_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau akamoiraneria: “Oyominto, echi mbwate nching’isaine. Echire echiao, kabe nachirochio.” ");
INSERT INTO guz_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Korende Yakobo akamoteebia: “Taibo, onye nanyorire ogwancherwa ase obosio bwao, koranche obwate ekeegwa eke korwa ase okoboko kwane; naki okorora obosio bwao nigo enga buna okorora obosio bwa Nyasae, ase ogwanchera kwanyancheire inche. ");
INSERT INTO guz_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Koranche oire ebiegwa ebi nakorenteire, ekiagera Nyasae onkoreire obuya obonge, na inche nimbwate ebing’isaine.” Naboigo ere akaebereria Esau na ere agancha, akabiira. ");
INSERT INTO guz_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Erio Esau akamoteebia: “Eta, togende seito, na inche ningotang’ane.” ");
INSERT INTO guz_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Korende Yakobo akamoiraneria: “Omonene one, nomanyete ng’a abana nebing’werere mbwate, naende chimbori ne ching’ondi nigo chibwate chimanwa chikogonka, ne chiombe boigo. Ching’iti echio chiise koayererigwa ase rituko erimo, nigo chirakwe chionsi. ");
INSERT INTO guz_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Koranche, omonene one, oete otang’ane bosio bwane, inche omosomba oo; na inche nindaae ching’iti echio ng’ora ng’ora, buna orogendo rwabo rong’ana, na abana buna chinguru chiabo ching’ana, goika ng’ike bwoo, omonene one, aaria Edomu.” ");
INSERT INTO guz_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Erio Esau akamoteebia: “Ningotigere abanto bande ase aba inde nabwo.” Korende Yakobo akairaneria: “Bakore ki? Otatiga ndore ng’a nanyorire ogwancherwa ase obosio bwao, omonene one.” ");
INSERT INTO guz_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ase rituko erio erio Esau akabwatia enchera, akairana gochia Edomu. ");
INSERT INTO guz_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Korende Yakobo akagenderera, agaika Sukoti, akeagachera enyomba, akaagachera na amaicho aye ebigutu. Ase igo, aase aria akarokwa Sukoti. ");
INSERT INTO guz_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakobo kairanire korwa Padan‐Aramu, agaika buya ase omorembe ase Sekemu, omochie omonene bw’ense ya Kaanani, agatenenia eema yaye isiko y’omochie oyio. ");
INSERT INTO guz_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Korwa ase basinto ba Hamori, ise Sekemu, Yakobo akagora oboremo obwo ase rigori rie chifeta rigana erimo, agwo ase atenenetie eema yaye. ");
INSERT INTO guz_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Akaagacha agwo egesasiimero, agakeroka Eli‐Elohe‐Israeli. ");
INSERT INTO guz_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Bono Dina, omoiseke o Lea, oyio Lea aiborerete Yakobo, akagenda kororana nabaiseke b’ense eria. ");
INSERT INTO guz_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ekero Sekemu, omwana o Hamori Omohivi, omonene bw’ense eria, amorooche, akamobwata, akaba nere, akamosareria obwekungi bwaye. ");
INSERT INTO guz_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Korende magega y’ayio agakorera Dina, omoiseke oyio o Yakobo, buya, akamwancha na gokwana nere amang’ana amaya. ");
INSERT INTO guz_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekemu agakwana na Hamori ise, akamoteebia: “Mborerie omoiseke oyo abe mokane!” ");
INSERT INTO guz_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ekero Yakobo achia koigwa ng’a Sekemu osaririe Dina, omoiseke oye, abamura baye ngetii baarenge korisia, Ase igo Yakobo agakira‐kiri goika bakairana inka. ");
INSERT INTO guz_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamori, ise Sekemu, akaimoka akagenda o Yakobo gokwana nere. ");
INSERT INTO guz_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Abamura ba Yakobo, ekero bachia koigwa ayio, bagacha korwa getii, bare nobororo na ekeririanda ekenene mono, ekiagera Sekemu akorete obokayayu ase Abaisraeli ase okomotachera inse omoiseke o Yakobo, ring’ana ritagwenerete gokoreka. ");
INSERT INTO guz_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori agakwana nabarabwo, akabora: “Omomura one Sekemu omwanchire omoiseke oino, bono komoranche, momomoe amonyuome. ");
INSERT INTO guz_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tonyuomerane intwe nainwe, motoe abaiseke baino, naintwe tobae abaito. ");
INSERT INTO guz_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Inwe nabo moramenye egati yaito, aiga ase ense yaito ribaga ndireo ase more, moramenye na koonchoreria, mwenyorere enibo.” ");
INSERT INTO guz_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekemu agateebia ise Dina na bamura bamwabo: “Nyanchere aya naboria aase more, kende gionsi moramboorie nimbae. ");
INSERT INTO guz_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mboorie enibo ende yonsi na ebiegwa boigo, nimbae buna moraganie, kogicha mong’e omoiseke oyo abe mokane.” ");
INSERT INTO guz_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Erio abamura ba Yakobo bakairaneria Sekemu na Hamori ise ase okong’ainereria, ekiagera konya osaririe Dina, omoiseke omwabo. ");
INSERT INTO guz_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Bakairaneria: “Titokonyara gokora ring’ana eri, komoa omonto otaarogeti, omoiseke ominto, ekiagera ayio nigo arabe aya obosooku ase tore. ");
INSERT INTO guz_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Natonyare gwancha okoboria kwaino ase ring’ana erimo rioka, naende nario eri: Komoranche mobe buna intwe, kera omonto omosacha ore asemore aarokigwe. ");
INSERT INTO guz_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Erio ’natobae abaiseke baito, na intwe toire abaino, tomenye amo, tobe abanto abamo. ");
INSERT INTO guz_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Korende motancheti mwarokigwe, rirorio nigo torarusie omoiseke oito aa, togende nere.” ");
INSERT INTO guz_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amang’ana abo akagwenera Hamori na omomura oye Sekemu. ");
INSERT INTO guz_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Omomura oyio tatebana gokora ring’ana riria, ekiagera omoiseke oria o Yakobo konya omogweneire. Bono Sekemu nigo asikire kobua abande bonsi ase eamate yabo. ");
INSERT INTO guz_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ase igo, Hamori na Sekemu, omomura oye, bakagenda ase egeita ki’omochie obo, bagakwana nabaanto babo, bakabateebia, ");
INSERT INTO guz_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Abanto aba babeire abasani baito, tiga bamenye ase ense yaito, babe abaonchoreria, ekiagera ense eye nenene, netoisane twensi, intwe amo na barabwo. Intwe ntonyuomerane na barabwo. ");
INSERT INTO guz_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Barabwo banchire komenya seito babe obomo naintwe, korende mbaganetie tokore ring’ana erimo, nario eri, ng’a kera omosacha ore ase tore aarokigwe buna barabwo baarogete. ");
INSERT INTO guz_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Amaicho abo, na enibo yabo, na etugo yabo yonsi, inee, tibikoba ebiaito? Tiga twancherane nabarabwo rioka, bamenye aa seito.” ");
INSERT INTO guz_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Abanto bonsi abamenyete ase omochie oria, bakaigwera Hamori na omomura oye Sekemu, na kera omosacha oyomenyeteo akaarokigwa. ");
INSERT INTO guz_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ase rituko ria gatato ekero abwo baarogete baarenge koromwa mono, abamura babere ba Yakobo, Simioni na Lawi, bamura ba ng’ina omo na Dina, bakaimoka nemeyio ya birende, bagasoa ase omochie ime mobosokano, bagaita abasacha bonsi abaarengeo. ");
INSERT INTO guz_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Bagaita Hamori amo na Sekemu momura oye nemeyio ya birende, bakarusia Dina omwabo mwa Sekemu, bakagenda nere. ");
INSERT INTO guz_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Erio abamura bande ba Yakobo bagachiera abwo baitetwe na bagasakora omochie, ekiagera konya basaririe omoiseke omwabo; ");
INSERT INTO guz_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","bakaira ching’ondi, ne chiombe, ne chitigere, na bionsi ebiareenge ase omochie ime, na bionsi ebiareenge ase emegondo boigo. ");
INSERT INTO guz_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bagasakora enibo yabo yonsi, na abana babo, na abakungu babo, na bionsi ebiareenge ase chinyomba bakabiira. ");
INSERT INTO guz_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Erio Yakobo agateebia Simioni na Lawi: “Inwe mwambekire ase emechando, mwankorire ogotioka okobe egati-gati y’abanto b’ebisaku bi’ense eye, Abakaanani na Abaperisi. Inche na abanto baane nabake tore; barabwo baise gosangererekana na kong’umokera nigo barang’ite na gonsiria amo nabaanto baane.” ");
INSERT INTO guz_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Korende barabwo bakamoiraneria: “Inee! Nabo barabwo bagwenerete bakorere omoiseke ominto buna omokungu omotayayi?” ");
INSERT INTO guz_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Rituko erimo Nyasae agateebia Yakobo: “Imoka, otiire ogende omenye Beteli, oagachere Nyasae egesasiimero aroro, Nyasae, oyo okoorokerete ekero kware gotama korwa ase Esau momura omino.” ");
INSERT INTO guz_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Erio Yakobo agateebia abanto baye amo naabwo bonsi baarenge komo: “Rusia emegwekano y’ebinyasae ebigeni b’ebisaku, ebi mobwate ase egati yaino, mwesibie inwe abanyene, moonchorerie chianga chiaino. ");
INSERT INTO guz_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Toimoke totiire gochia Beteli, erinde ing’agachere Nyasae egesasiimero aroro, Nyasae oyonyigwete ekero keria nareenge nobokong’u, akaba amo nainche ase orogendo rwane rwonsi.” ");
INSERT INTO guz_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Barabwo bakaa Yakobo emegwekano y’ebinyasae ebigeni bionsi ebio babwate, na ebigera babeegete ase amato abo, na Yakobo akabitindeka inse y’omote okorokwa omwaloni, oyorenge ang’e na Sekemu. ");
INSERT INTO guz_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ekero baimogete kogenda orogendo rwabo, okoondokia gokarua ase Nyasae, gokabwata abanto b’emechie eria yabaetanaine; Ase igo tibanyara komonyookia basinto ba Yakobo. ");
INSERT INTO guz_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo amo nabwo bonsi baarenge nere bagaika omochie o Lusu, Omochie oyio naende noro okorokwa Beteli, oyio ore ime y’ense ya Kaanani ");
INSERT INTO guz_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Agwo akaagacha egesasiimero, Akaaroka aase aria Eli‐Beteli, ekiagera agwo nao Nyasae aorokerete Yakobo, ekero areenge gotama korwa ase oyomwabo. ");
INSERT INTO guz_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Agwo Debora, omoreri o Rebeka, agakwa, agatindekwa inse y’omote okorokwa omwaloni. Aase agwo akarokwa Aloni‐Bakuti. ");
INSERT INTO guz_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Erio naende Nyasae akaorokera Yakobo, ekero Yakobo areenge korwa Padan‐Aramu, Nyasae akamosesenia. ");
INSERT INTO guz_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Agwo Nyasae akamoteebia, “Erieta riao n’Yakobo, bono tokorokwa Yakobo naende, korende nigo orarokwe Israeli.” Ase igo, akamoroka Israeli. ");
INSERT INTO guz_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Naende Nyasae akamoteebia, “Inche Nyasae Omobui, genderera gosarara, obuche. Egesaku na emeganda y’ebisaku nigo erarue asore, na abarwoti mbarue asore. ");
INSERT INTO guz_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Na ense eye naete Aburaamu na Isaka, ninkoyee aye na ororeeria rwao rorache korwa magega yao.” ");
INSERT INTO guz_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Erio Nyasae akaimoka akagenda igoro, akarwa asare, agwo ase areenge gokwana nere. ");
INSERT INTO guz_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo agatenenia rigena buna esiiro aase aria Nyasae akwanerete amo nere, akaumora ekeng’wanso gi’ekenyugwa amo namaguta igoro yaye. ");
INSERT INTO guz_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Igo Yakobo akaaroka aase aria Nyasae akwanerete amo nere Beteli. ");
INSERT INTO guz_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Erio bagachaaka orogendo rwabo korwa Beteli, ekero batigairie orogendo oroke baike Efarati, Raeli agachaaka kobina ase okoibora, akaba nobokong’u bw’okoibora. ");
INSERT INTO guz_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ekero areenge koromwa mono, omoiboria akamoteebia: “Toondoka, ekiagera naende nomwana omoisia oraibore.” ");
INSERT INTO guz_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Agwo akaba okogireka ase ogokwa; na ekero areenge ang’e ase ogokwa, Akamoroka omwana oyio Ben‐Oni, korende ise akamoroka Benjamini. ");
INSERT INTO guz_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Erio Raeli agakwa, agatindekwa agwo ase enchera ekogenda Efarati, nao Bethlehemu. ");
INSERT INTO guz_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Na Yakobo agatenenia rigena ri’ekeinyorio ase embeera ya Raeli, nao rire goika reero iga. ");
INSERT INTO guz_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Erio Israeli akaimoka, akagenda, agatenenia eema yaye ng’umbu y’omoorobiri o Ederi. ");
INSERT INTO guz_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Engaki eria Israeli amenyete ase ense eria, Rubeni akagenda akaraara na Bilia, omokungu o ise, oria o sere-sere, na Israeli akaigwa amang’ana ayio. Abamura ba Yakobo nigo baarenge ikomi na babere. ");
INSERT INTO guz_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Abana abamura ba Lea nabwo aba: Rubeni, omwana omotangi o Yakobo, na Simioni, na Lawi, na Yuda, na Isakaru, na Sabuloni. ");
INSERT INTO guz_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Abana abamura ba Raeli nabwo Yusufu na Benjamini. ");
INSERT INTO guz_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Abana abamura ba Bilia, omoiseke omosomba o Raeli, nabwo Dani na Nafutali. ");
INSERT INTO guz_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Abana abamura ba Silpa, omoiseke omosomba o Lea, nabwo Gadi na Aseri. Aba nabwo abana abamura Yakobo aiboreretwe agwo Padan‐Aramu. ");
INSERT INTO guz_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo agaika ase omochie o Isaka ise aaria Mamure, ang’e na Kiriati-Ariba, nao Heburoni, agwo ase Aburaamu na Isaka bamenyete buna abamenyi. ");
INSERT INTO guz_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka nigo akoorete emiaka rigana erimo, na emerongo etano na etato (180). ");
INSERT INTO guz_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Erio Isaka ero agakwa, agasangerereka amo nabaanto baye, ore omogotu kegima, omonto bw’emiaka emenge, na abamura baye, Esau na Yakobo, bakamotindeka. ");
INSERT INTO guz_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Oyo noro omooroberio bw’ororeeria rwa Esau, nere Edomu. ");
INSERT INTO guz_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau akanyuoma abakungu baye korwa ase Abakaanani: Ada, omoiseke o Eloni, Omohiti, na Oholibama, omoiseke o Ana, mosinto o Sibeoni, Omohivi, ");
INSERT INTO guz_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Basemati, omoiseke o Isumaeli, omoiseke omwabo Nebayoti, ");
INSERT INTO guz_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada akamoiborera Esau omwana okorokwa Elifasi, na Basemati akaibora Reueli, ");
INSERT INTO guz_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","na Oholibama akaibora Yeusi, na Yalamu, na Kora. Aba nabwo abana abamura Esau aiboreretwe ase ense ya Kaanani. ");
INSERT INTO guz_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Erio Esau akaimokia abakungu baye, na abana baye abamura na abaiseke, na abanto bonsi ababwate abwo bwoye, ne chiombe chiaye, ne ching’iti chiaye chionsi echi atugete, na enibo yaye yonsi eyaniberete ase ense ya Kaanani; akagenda agaika ase ense yareenge aare korwa ase Yakobo omwabo. ");
INSERT INTO guz_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ekiagera babwate enibo enyinge tibare konyara komenya amo; na ense eria tiyare kobaisana bamenye babere bonsi ne chitugo chiabo. ");
INSERT INTO guz_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ase igo Esau, oyokorokwa naende Edomu, akaba okomenya ase ense y’ebitunwa bia Edomu. ");
INSERT INTO guz_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Oyo noro omooroberio bw’ororeeria rwa Esau ise Edomu, ase ense y’ebitunwa bia Edomu. ");
INSERT INTO guz_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Aya naro amarieta a basinto b’Esau: Elifasi, omomura o Ada moga Esau, na Reueli, omomura o Basemati moga Esau. ");
INSERT INTO guz_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Na basinto b’Elifasi nabwo aba: Temani na Omari, na Sefo, na Gatamu, na Kenasi. ");
INSERT INTO guz_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timuna nigo areenge omokungu o sere‐sere o Elifasi, mosinto bw’Esau. Ere akaiborera Elifasi Amaleki. Aba nabwo baareenge abachokoro abamura b’Ada moga Esau. ");
INSERT INTO guz_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Aba nabwo basinto ba Reueli: Nahati, na Zera, na Sama, na Miza. Aba nabwo baarenge abachokoro abamura ba Basemati, moga Esau. ");
INSERT INTO guz_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Na abana aba nabwo abamura ba Oholibama, moga Esau mosubati o Ana, mosinto o Sibeoni: Ere akaiborera Esau Yeusi, na Yalamu, na Kora. ");
INSERT INTO guz_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Aba nabwo baarenge abagaambi korwa ase ororeeria rw’Esau. Basinto b’Elifasi, omomura omotangi bw’Esau, nabwo aba: Omogambi Temani, na omogambi Omari, na omogambi Sefo, na omogambi Kenasi, ");
INSERT INTO guz_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","na omogambi Kora, na omogambi Gatamu, na omogambi Amaleki. Aba nabwo baarenge abagaambi korwa ase ororeeria rw’Elifasi, ase ense y’Edomu. Barabwo nabachokoro abamura b’Ada. ");
INSERT INTO guz_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Naba nabwo basinto ba Reueli, mosinto bw’Esau: Omogambi Nahati, na omogambi Zera, na omogambi Sama, na omogambi Miza. Aba nabwo baarenge abagaambi korwa ase ororeeria rwa Reueli ase ense y’Edomu. Aba nabwo abachokoro abamura ba Basemati, moga Esau. ");
INSERT INTO guz_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Naba nabwo abamura b’Oholibama, moga Esau: Omogambi Yeusi, na omogambi Yalamu, na omogambi Kora. Aba nabwo abagaambi baiboretwe na Oholibama, mosubati o Ana moga Esau. ");
INSERT INTO guz_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aba nabwo basinto b’Esau, nere Edomu; naba nabwo abagaambi babo. ");
INSERT INTO guz_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Aba nabwo basinto ba Edomu Omohori, ababiare b’ense eria: Lotani, na Sobali, na Sibeoni, na Ana, ");
INSERT INTO guz_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","na Dishoni, na Eseri, na Disani. Aba nabwo baarenge abagaambi b’Abahori, basinto ba Edomu, ase ense y’Edomu. ");
INSERT INTO guz_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Na basinto ba Lotani nabwo Hori na Hemamu, na mosubati omwabo Lotani nigo areenge korokwa Timuna. ");
INSERT INTO guz_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Naba nabwo basinto ba Sobali: Alivani, na Manahati, na Sefo, na Onamu. ");
INSERT INTO guz_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Naba nabwo basinto ba Sibeoni: Aya na Ana. Ana oyo nere onyorete chinsoko chi’amaache are morero, ase erooro, ekero areenge korisia chitigere chia Sibeoni ise. ");
INSERT INTO guz_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Na mosinto o Ana nere Dishoni, na omoiseke o Ana nere Oholibama. ");
INSERT INTO guz_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Naba nabwo basinto ba Dishoni: Hemudani, na Esibani, na Itirani, na Kerani. ");
INSERT INTO guz_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Naba nabwo basinto b’Eseri: Bilihani, na Sawani, na Akani. ");
INSERT INTO guz_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Na basinto ba Disani nabwo Usi na Arani. ");
INSERT INTO guz_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Na abagaambi barwete ase Abahori nabwo aba: Omogambi Lotani, na omogambi Sobali, na omogambi Sibeoni, na omogambi Ana, ");
INSERT INTO guz_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","na omogambi Dishoni, na omogambi Eseri, na omogambi Disani. Aba nabwo abagaambi b’Abahori, koreng’ana nebisaku biabo, ase ense ya Edomu. ");
INSERT INTO guz_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Na abarwoti abagamberete ense y’Edomu ritang’ani konya morwoti onde bwensi ataragaambera Abaisraeli nabwo aba: ");
INSERT INTO guz_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, mosinto o Beori, akaba okogaamba ase ense y’Edomu, na omochie oye nigo ore korokwa Dinihaba. ");
INSERT INTO guz_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela agakwa, na Yobabu mosinto o Zera, oyo orwete Bosira, akaba okogaamba ase ribaga riaye. ");
INSERT INTO guz_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu nere agakwa, na Husamu bw’ense y’Abatemani akaba okogaamba ase ribaga riaye. ");
INSERT INTO guz_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husamu nere agakwa, na Hadadi, mosinto o Bedadi, akaba okogaamba ase ribaga riaye; oyo nere obuete Abamidiani, ase ense ya Moabu na omochie oye nigo ore korokwa Aviti. ");
INSERT INTO guz_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi nere agakwa, na Samula, oyo orwete Masereka, akaba okogaamba ase ribaga riaye. ");
INSERT INTO guz_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula nere agakwa, na Saulo, oyo orwete Rehoboti, omochie orenge orooche ensemo, akaba okogaamba ase ribaga riaye. ");
INSERT INTO guz_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saulo nere agakwa, na Baali‐Hanani mosinto o Akibori akaba okogaamba ase ribaga riaye. ");
INSERT INTO guz_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali‐Hanani, mosinto o Akibori, nere agakwa, na Hadari akaba okogaamba ase ribaga riaye, na omochie oye nigo ore korokwa Pau, na mokaye nigo areenge korokwa Mehetabeli, mosubati o Matiredi, mosubati o Mesahabu. ");
INSERT INTO guz_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Aya naro amarieta ’abagaambi barwete ase ororeeria rwa Esau, gotunyana chiamate chiabo, na aase bamenyete nigo are namarieta abo: Omogambi Timuna, na omogambi Aliva, na omogambi Yeteti, ");
INSERT INTO guz_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","na omogambi Oholibama, na omogambi Ela, na omogambi Pinoni, ");
INSERT INTO guz_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","na omogambi Kenasi, na omogambi Temani, na omogambi Mibusari, ");
INSERT INTO guz_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","na omogambi Magadieli, na omogambi Iramu. Aba nabwo abagaambi barwete ase ororeeria rw’Edomu, koreng’ana buna bamenyete chinsemo chiabo ase ense eria bairete ekaba eyabo. (Esau nere sokoro bw’Abaedomu). ");
INSERT INTO guz_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo akaba okomenya ase ense y’Abakaanani, eyio ase ise nere areenge omenyete buna omomenyi. ");
INSERT INTO guz_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Oyo noro omogano bw’ororeeria rwa Yakobo. Yusufu, ekero aikire emiaka ikomi, na etano na ebere, nigo areenge korisia amaicho amo na bamura bamwabo. Omosae oyio akaba ore amo nabamura bamwabo, abana ba Bilia na Silpa, abakungu ba ise. Yusufu akaba okorentera ise amang’ana igoro y’ogokora kwabo okobe. ");
INSERT INTO guz_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Bono Israeli nigo anchete Yusufu kobua abana baye bande bonsi, ekiagera nigo areenge omwana oye bw’obogotu. Akamoroiseria eanga engiya entambe. ");
INSERT INTO guz_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Abamwabo ekero barooche ng’a ise nigo amwanchete ere kobua abamwabo bonsi, barabwo bakamogecha, tibare gokwana amang’ana y’omorembe amo nere. ");
INSERT INTO guz_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufu akaroota chindoto, na ekero ateebetie abamwabo chindoto echio, barabwo bakamenta mono komogecha. ");
INSERT INTO guz_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusufu akabateebia: “Montegerere, moigwe okoroota oko narootete. ");
INSERT INTO guz_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nkarora ng’a intwe nigo twareenge mogondo tokoboa emesaima y’endagera, na omosaima one okaimoka ogatenena boronge, na emesaima yaino ekaba ekoyoetanana, egotugama inse ase omosaima one.” ");
INSERT INTO guz_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Abamwabo bakamobooria: “Inee! Aye nigo orengereretie ng’a nigo orabe omogambi oito, otogambere?” Ase igo, barabwo bakamenta komogecha mono ase engencho y’okoroota kwaye, na ase engencho y’amang’ana aye. ");
INSERT INTO guz_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Naende akaroota konde, na okwo agateebia abamwabo, akabora: “Moigwe! Inche nigo narootete okoroota konde. Nkarora erioba, na omotienyi, ne ching’enang’eni ikomi nemo bigotugama inse ase obosio bwane.” ");
INSERT INTO guz_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Korende ekero ateebetie ise na bamura bamwabo amang’ana ayio, ise akamotogonyera, akamobooria: “nkoroota ki okwo okoroota? Inee! Inche na nyoko, na bamura bamino, amaene, nigo torache togotugamere togosasime aye?” ");
INSERT INTO guz_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Abamwabo bakamobwaterwa ribero, korende ise ere akagacha ogokwana okwo ase enkoro yaye ime. ");
INSERT INTO guz_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Erio abamwabo bakagenda korisia amaicho a ise ang’e na Sekemu. ");
INSERT INTO guz_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Na Israeli akarangeria Yusufu, akamoteebia: “Inee! Abamino tibakari korisia amaicho aaria Sekemu? Inchuo bono ngotome gochia ase bakare.” Yusufu agaitaba: “Nao inde aa.” ");
INSERT INTO guz_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ise akamoteebia: “Genda bono orore gose abamino mbuya bare amo namaicho, erinde ondetere amang’ana.” Ase igo, akamotoma korwa ase omweya o Heburoni, akageenda agaika Sekemu; ");
INSERT INTO guz_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","omonto oyomo akamonyora, ekero areenge kona‐goetanana ase erooro, na omonto oyio akamobooria: “Inki okorigia?” ");
INSERT INTO guz_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Akamoiraneria: “Nabaminto nkorigia; koranche nteebie aase bakorisia amaicho.” ");
INSERT INTO guz_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Omonto oria akabateebia: “Barure aa, bachiire, naki nigo nabaigwa bagoteebania: Tiga togende Dotani.” Erio Yusufu akababwatia korwa magega, akabanyora Dotani. ");
INSERT INTO guz_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Barabwo bakamorora ere okare egeka, ritang’ani konya ataraika ang’e asebare, bakagaamba buna bamoite. ");
INSERT INTO guz_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Barabwo bagateebania: “Omonyandooto oyio ogocha. ");
INSERT INTO guz_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bono ntore ne ribaga; tiga tomoite, tomorute ase engoro eyemo ye chingoro chire aa, erio toteebe ng’a neng’iti y’orosana yamoriete, na torore chindoto echio chiaye buna chirabe.” ");
INSERT INTO guz_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubeni ekero ayaigwete, akarigia komotooria korwa ase amaboko abo, akabakania: “Yaya! Titomoita akwe.” ");
INSERT INTO guz_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Naende akabateebia: “Timoitera amanyinga aye; morute ase engoro eyemo y’echi chire aa ase erooro, korende timorambora amaboko aino gochia asare ase okomoita.” Ere nigo abateebetie igo, erinde anyare komotooria korwa ase amaboko abo, amoiranie ase ise. ");
INSERT INTO guz_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ekaba ekero Yusufu achia goika ase abamwabo, barabwo bakamorusia eanga eria engiya entambe abeegete, ");
INSERT INTO guz_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","bakamobwata, bakamoruta engoro ime. Engoro eyio nigo yareenge bosa, mache tareengeo. ");
INSERT INTO guz_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Erio bagaikaransa inse koragera; bagachia koimokia amaiso abo korigereria, bakarora omoganda bw’Abaisumaeli ogocha korwa Gileadi. Barabwo nigo baare ne chingamia chiabo, chibogoretie ubani, na amaguta akogwenia, na manemane, ase orogendo rwabo baare kogenda Misiri. ");
INSERT INTO guz_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Agwo Yuda agateebia abamwabo: “Inki eratogwenere toite oyominto na kobisa ogokwa kwaye? ");
INSERT INTO guz_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tiga tomoonie ase Abaisumaeli aba, erinde titobaisa komoita namaboko aito, ekiagera noyominto, toiboire komo.” Na abamwabo bagancherana nere. ");
INSERT INTO guz_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Erio Abamidiani bagaeta aroro, baare gokora oboonchoreria; abamwabo bakarusia Yusufu korwa ase engoro eria, na komooneria Abaisumaeli ase chisekeli chi’echifeta emerongo ebere; barabwo bakamoira goika Misiri. ");
INSERT INTO guz_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubeni agachia koirana korigereria ase engoro eria, akanyora Yusufu taiyo ase engoro, ere agatandora chianga chiaye, ");
INSERT INTO guz_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","akeonchora gochia ase abamwabo, akabateebia: “Omwana timonyoreti ase engoro. Ng’ai rende nkogenda?” ");
INSERT INTO guz_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Erio bakaimokia eanga ya Yusufu, na bakanyenya embori, bakaimokia eanga eria, bakayetobeka ase amanyinga; ");
INSERT INTO guz_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","bakagenda n’eanga eria entambe bakayeirera ise, bakamobateebia: “Yemanye eanga eye gose ney’omwana oo gose tari ero.” ");
INSERT INTO guz_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakobo akayemanya, akabora: “Neanga y’omwana one, amaene neching’iti chi’orosana chiamoitire; Yusufu orirwe!” ");
INSERT INTO guz_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Erio Yakobo agatandora chianga chiaye, akeboyia chigunia kenema kiaye, akaba okomoreera omwana oye engaki entambe. ");
INSERT INTO guz_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Abana baye, abamura na abaiseke bonsi, bakaimoka gochia komoremia, korende akaanga, taremigwa, agateeba: “Yaya, goika inkwe, ngende inse ase oboina nkona‐komoreera omwana one.” Ise akaba okona‐kweumia. ");
INSERT INTO guz_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Na Abamidiani baria bakamoonia aaria Misiri ase Potifari, omoteneneri bw’enka ya Farao na omotang’ani bw’abarendi baye bande. ");
INSERT INTO guz_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ekaba ase engaki eria Yuda agatigana n’abamwabo, agatirimboka, agaika ase omonto gete Omoadulamu ore korokwa Hira, bakabwatana nere. ");
INSERT INTO guz_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Aroro Yuda akarora moiseke o Sua, omoiseke bw’Omokaanani gete, akamonyuoma. Bakaba bakorara amo, ");
INSERT INTO guz_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","na moiseke o Sua akaba morito, akaibora omwana omoisia, akamoroka Eri. ");
INSERT INTO guz_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Naende akaba morito, akaibora omwana omoisia, akamoroka Onani. ");
INSERT INTO guz_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Akaba morito naende, akaibora omwana omoisia, akamoroka Sela. Yuda nere nao areenge aria Kisibo ekero amoiborerete abana. ");
INSERT INTO guz_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Na Yuda akanyuomeria Eri, omwana oye omotangi, omokungu ore korokwa Tamari. ");
INSERT INTO guz_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nere Eri, omomura omotangi o Yuda, nigo areenge omobe ase obosio bw’Omonene; ase ayio Omonene akamoita. ");
INSERT INTO guz_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Erio Yuda agateebia Onani: “Motware moka momura omino, erinde omotenenerie egesaku.” ");
INSERT INTO guz_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Korende Onani akamanya ng’a abana abwo agochia koibora tibari gochia korokwa abaye. Kera engaki, arekoba na moka momura omwabo, ekero embego y’oroiboro ere nchera gocha, asomora aitera inse, ng’a erio tabaisa goteneneria oyomwabo egesaku. ");
INSERT INTO guz_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ayio akorete akaba amabe ase obosio bwa Nyasae Omobui, nere Omonene akamoita. ");
INSERT INTO guz_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Erio Yuda agateebia Tamari, moka momura oye: “Genda omenye buna omoboraka ase omochie o iso goika Sela omwana one akine”; naki nigo oboete ng’a nere nabaise gocha gokwa, buna abamwabo bakwete. Ase igo, Tamari akagenda akamenya o ise. ");
INSERT INTO guz_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Magega ya amatuko make, moiseke o Sua, moka Yuda, agakwa; Yuda gakoorire okomoreera, agatiira gochia Timuna ase abanachi amarionya be ching’ondi chiaye, amo nomosani oye Hira Omoadulamu. ");
INSERT INTO guz_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ekero Tamari ateebetigwe ng’a ise biara ’nkogenda akare Timuna konacha ching’ondi chiaye amarionya, ");
INSERT INTO guz_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","akarusia chianga chiaye chi’ogokobania, akeboyia chianga na gwetuba obosio bwaye, agaikaransa geita ki’Enaimu, ang’e nenchera ekogenda Timuna; naki nigo arooche ng’a Sela obeire omonto omonene, na tamoeiri amotware. ");
INSERT INTO guz_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ekero Yuda amorooche, agakaga ng’a nomokuungu omotayayi, ekiagera nigo atubete obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yuda akagobera gochia asare enchera ensemo, akamoteebia: “Inyanchere ’mbe naye,” naki tamanyete gose moka momura oye orenge. Tamari akamobooria: “Inki orang’e, erinde osoe ase ’nde?” ");
INSERT INTO guz_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Akamoiraneria: “Ninche ngotomera emaanwa egoree korwa ase riicho riane.” Omokungu oria akamobooria: “Inee! Inki orang’e kebe intenenera goika kwayentomeire?” ");
INSERT INTO guz_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Akamobooria: “Ngento ki origetie nkoe kebe intenenera?” Akamoiraneria: “Ebonyi yao ere nekemanyererio, na orokini rwao, na enyimbo yao obwate koboko.” Erio akamobia, akaraara nere, na ere akaba morito. ");
INSERT INTO guz_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Erio akaimoka akagenda, akarusia egietubo, akabeeka chianga chiaye chi’ogokobania. ");
INSERT INTO guz_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda akaa omosani oye Omoadulamu emaanwa egoree airere omokungu oria, erinde ere airanie ebinto biria amoete bibe intenenera, korende tamonyora. ");
INSERT INTO guz_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Omoadulamu oria akabooria abanto b’aase aria: “Ng’ai are omokungu oria omotayayi, oyorenge aa Enaimu enchera ensemo?” Bakamokania: “Omokungu omotayayi tana koba aa.” ");
INSERT INTO guz_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ase igo, akairana gochia ase Yuda, akabateebia: “Timonyoreti; naboigo nonya nabaanto b’aase aria nigo bankania ng’a mokuungu motayayi tana kobao.” ");
INSERT INTO guz_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda akabora: “Tiga atware ebinto ebio namoete bibe intenenera, titobaisa gocha kororekana nobosooku. Rora, namotomerete emaanwa egoree, na aye tikwamonyorete.” ");
INSERT INTO guz_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ekaba magega y’emetienyi etato Yuda ateebetigwe ng’a Tamari, moka momura oye, okorire obotomani bw’obotayayi; amo nayio morito are ase obotayayi. Erio Yuda akabora: “Mosokie isiko, asambwe nomorero.” ");
INSERT INTO guz_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Gasokiigwe isiko agatoma abanto ase ise biara, bamoteebie: “Omonto omonyene ebinto ebi, nere ong’ete oborito obo.” Naende akabora: “Manya ebonyi eyio ere nekemanyererio, na orokini oro, na enyimbo eye, gose nebiang’o.” ");
INSERT INTO guz_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Erio Yuda akabimanya, akabora: “Ere nomooronge kombua, nigo akora ayio, ekiagera ntamoete Sela, omwana one, amotware.” Erio Yuda tarara nere naende. ");
INSERT INTO guz_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ekero engaki yaye y’okoibora yachia goika, akarorekana ore ne chibarongo enda yaye ime. ");
INSERT INTO guz_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ekero areenge koibora, omwana oyomo agatang’ania okoboko isiko, na omoiboria akamosibera okoboko okwo eusi embariri, agateeba: “Oyo nere otanga gosoka isiko.” ");
INSERT INTO guz_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kairanirie okoboko kwaye, rora, oyomwabo akaromeng’ana, agasoka isiko. Erio omoiboria agateeba: “Naki okoromeng’ana ne chinguru iga?” Ase ayio bakamoroka Peresi. ");
INSERT INTO guz_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Magega yaye oyomwabo agasoka ore neusi embariri koboko kwaye. Nere akarokwa Zera. ");
INSERT INTO guz_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Bono Yusufu agatirimbokigwa gochia Misiri; na Potifari, omoteneneri bw’enka ya Farao na omotang’ani bw’abarendi baye bande, omonto o Misiri, akamogora korwa ase Abaisumaeli, abwo bamotirimbogetie gochia aroro. ");
INSERT INTO guz_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Omonene nigo areenge amo na Yusufu, na ere akanyora ogosesenigwa. Yusufu akamenya ase enka y’omonene oye, oria Omomisiri. ");
INSERT INTO guz_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ere nigo arooche ng’a Omonene nigo areenge amo na Yusufu, ogerire ebinto bionsi biasesenigwe ase amaboko aye. ");
INSERT INTO guz_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ase igo,, Yusufu aganchwa mono ase obosio bw’omonene oye Potifari na akamobeka koba omokoreri oye; na ere akamobeka abe omoteneneri bw’enka yaye yonsi, na omorigereria bw’ebinto bionsi ebi abwate. ");
INSERT INTO guz_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Korwa engaki eyio amobegete abe omoteneneri igoro y’enka yaye, na bionsi ebi abwate. Omonene agasesenia Omomisiri oria ase engencho ya Yusufu, na ogosesenia kw’Omonene gokaba ase ebinto bionsi abwate ase enyomba na emegondo. ");
INSERT INTO guz_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ase igo, agatiga bionsi ebiareenge nabio ase amaboko a Yusufu; gose taba ogwechandera gento kende gionsi otatiga endagera yoka eria areenge koria. Yusufu nigo areenge omonto omerete buya, naende omonyakieni. ");
INSERT INTO guz_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Magega y’engaki gete moka omonene oye akarigereria Yusufu ase okomogania, akamoteebia: “Inchuo oraare nainche!” ");
INSERT INTO guz_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Korende ere akaanga, agateebia moka omonene oye: “Rora, omonene one techandereti gento kende gionsi ase enka yaye, na bionsi ebi abwate obibekire ase amaboko aane. ");
INSERT INTO guz_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Onde tari ase enyomba yaye oeire okobua otatiga inche, gose tantangeti gento kende gionsi otatiga aye bweka, ekiagera aye mokaye ore. Naki rende ndanyare gokora ebibe ebinene buna ebi, imomochere Nyasae?” ");
INSERT INTO guz_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Akaba okonagokwana na Yusufu rituko ase rituko, korende Yusufu tamwanchera baraare komo, gose koba amo. ");
INSERT INTO guz_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ekaba rituko erimo, ekero Yusufu asoete nyomba gokora emeremo yaye, gose monto onde bw’abaanto b’enyomba eria tareengeo, ");
INSERT INTO guz_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","omokungu oria akamobwata eanga yaye eyare kwambara, akabateebia: “Rara nainche.” Korende Yusufu agatigera omokungu oria eanga yaye eyare kwambara, agatama gochia isiko. ");
INSERT INTO guz_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Omokungu oria, ekero arooche ng’a Yusufu omotigeire eanga yaye koboko kwaye, na gotama gochia isiko, ");
INSERT INTO guz_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","akarangeria abanto ba nyomba mwaye, akabateebia: “Rigereria, omosacha one otorenteire omonto oyo Omoiberania ase egati yaito atokorere echeche; nigo acha ase ’nde ng’a araare nainche, na inche nakuura neriogi rinene. ");
INSERT INTO guz_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Na ekero aigwa ng’a nakuurire neriogi rinene, ontigera eanga yaye koboko kwane, otama gochia isiko.” ");
INSERT INTO guz_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Akagacha eanga eria goika omosacha oye agacha inka, ");
INSERT INTO guz_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","akamoteebia amang’ana ayio ayio, agateeba: “Omoiberania oyo omosomba kwarenta aa nabo asoa ase ’nde gonkorera echeche. ");
INSERT INTO guz_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Korende ekero nachaka gokuura na goaka eriogi ontigera eanga yaye koboko kwane, otama gochia isiko.” ");
INSERT INTO guz_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ekero omonene o Yusufu achia koigwa aya mokaye amoteebirie ng’a: “Aya naro omosomba oo ankorera”, akaba nekeririanda ekenene. ");
INSERT INTO guz_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Omonene oyio akabwata Yusufu, akamobeka echela ime, aase abasomba b’omorwoti basibire, na ere akaba agwo echela ime. ");
INSERT INTO guz_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Korende Omonene akaba ore amo na Yusufu, akamokorera obuya, akamoa ogwancherwa ase omonene bw’echela. ");
INSERT INTO guz_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Omonene oria akabeeka abasibwa bonsi abwo baarenge echela ime ase amaboko a Yusufu; na onsi ayare gokoreka ase echela, ere akaba okoyakora. ");
INSERT INTO guz_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Na omonene oria bw’echela tachia goitaa kende gionsi kiare ase amaboko a Yusufu, ekiagera Omonene nigo areenge amo nere, na ande onsi are gokora, Omonene nigo are koyasesenia. ");
INSERT INTO guz_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ase engaki gete, magega y’amang’ana ayio, omoteneneri bw’ebinyugwa bia Farao na omoteneneri oye bw’abaroisia emegati bakamoochera omonene obo, omorwoti o Misiri. ");
INSERT INTO guz_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ase igo, Farao akabeigwa n’abateneneri abwo babere, omoteneneri bw’ebinyugwa na omoteneneri bw’abaroisia emegati. ");
INSERT INTO guz_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Akababeeka barendwe ase enyomba yomotang’ani bw’abarendi, ase echela eyio Yusufu nere asibetwe. ");
INSERT INTO guz_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Omotang’ani bw’abarendi akamobeka Yusufu abe okobarigereria na kobakorera, na barabwo bakabeera ase egesibo ase engaki enke. ");
INSERT INTO guz_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ase obotuko obomo bonsi babere, omoteneneri oria bw’ebinyugwa na omoteneneri bw’abaroisia emegati b’omorwoti o Misiri, abwo basibetwe echela, bakaba bakoroota chindoto. Kera oyomo akaroota okoroota kwaye okware nengencho eng’ao korwa ase okw’oyonde. ");
INSERT INTO guz_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ekero Yusufu agendete mambia kobarigereria akabanyora nigo baichanete. ");
INSERT INTO guz_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ase igo, akabooria abateneneri abwo ba Farao, abaarenge amo nere ase egesibo ase enyomba y’omonene oye, akabora: “Naki moichaanete iga reero?” ");
INSERT INTO guz_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Barabwo bakamoiraneria: “Nigo twarootete chindoto, na onde tari oranyare kogoteebia engencho ye chindoto chiaito.” Yusufu akabateebia: “Nigoro ya Nyasae kobateebia engencho yaye. Komoranche, mochinteebie.” ");
INSERT INTO guz_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Omoteneneri bw’ebinyugwa agateebia Yusufu okoroota kwaye, akabora: “Ase okoroota kwane nigo narooche omosabibu ore ase obosio bwane, ");
INSERT INTO guz_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","na omosabibu oyio nigo orenge ne chinsagia isato; bwango ogasomoria, ogasokia ebisicha, na okaama ebisago bi’amasabibu amatobu. ");
INSERT INTO guz_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na egekombe kia Farao nigo nakebwate ase okoboko kwane; nkabogoria amasabibu aria, nkayamitera ase egekombe kia Farao, nkaa Farao egekombe eke koboko kwaye.” ");
INSERT INTO guz_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu akamoteebia: “Engencho y’okoroota okwo nero eye: Chinsagia echio isato, ayio namatuko atato. ");
INSERT INTO guz_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Magega y’amatuko atato Farao nakorusie aiga, akoe ogosika, akoiranie ase emeremo yao, na aye nobe gokomoa egekombe koboko kwaye, buna kware komoa agwo ritang’ani, ekero kwareenge omoteneneri bw’ebinyugwa biaye. ");
INSERT INTO guz_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Korende ekero oranyore amaya, ong’inyore nainche, ondorere amaabera. Koranche nagosabire onyatore ase Farao, ondusie ase enyomba eye, ");
INSERT INTO guz_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ekiagera nigo naibetwe korwa ase ense y’Abaiberania, nonya naa tinkoreti ing’ana rinde riibe riagwenerete kombeeka ase echela.” ");
INSERT INTO guz_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ekero omoteneneri bw’abaroisia emegati arooche ng’a okoonchora okwo nigo kwabeete okuya, agateebia Yusufu: “Nainche boigo nigo narootete. Nkarora ng’a inyetwegete chinteru isato chire nemegati emerabu ase omotwe one. ");
INSERT INTO guz_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ase oroteru rwa igoro kegima yarengeo emegati y’ebisaku ao ao yaroiseretigwe Farao, korende chinyoni chigaacha chikayeria korwa ase oroteru igoro, oro netwegete ase omotwe one.” ");
INSERT INTO guz_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Na Yusufu akamoiraneria: “Engencho y’okoroota okwo nero eye: Chinteru echio isato, ayio namatuko atato. ");
INSERT INTO guz_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Magega y’amatuko atato Farao nakoimokie, agosunge ase omote igoro ne chinyoni nachirie chinyama chi’omobere oo.” ");
INSERT INTO guz_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Rituko ria gatato, erio riaare ri’okoinyora okoiborwa gwa Farao, ere agakorera abasomba baye bonsi omoyega, akabarusia echela baria babere, omoteneneri bw’ebinyugwa na omoteneneri bw’abaroisia emegati, ase egati y’abasomba baye. ");
INSERT INTO guz_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Akairania omoteneneri bw’ebinyugwa ase emeremo yaye y’obonyoisia, na ere akaba okomoa Farao egekombe ase okoboko kwaye; ");
INSERT INTO guz_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","korende omoteneneri bw’abaroisia emegati ere akamosunga ase omote igoro, buna Yusufu abanorete chingencho chie chindoto chiabo. ");
INSERT INTO guz_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nonya nabo oyio omoteneneri bw’ebinyugwa taba okoinyora Yusufu, korende akamweba. ");
INSERT INTO guz_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Magega y’emiaka ebere koyaetire Farao akaroota chindoto ng’a oteneine engegu y’orooche rwa Naeli. ");
INSERT INTO guz_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Akarora chiombe isano na ibere, chingiya mono chinoru, chikorwa rooche, chikorisia amasangaka. ");
INSERT INTO guz_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Naende akarora chiombe chinde isano na ibere, chimbe mono chindeu, chikorwa rooche, chigochitunyana korwa magega, chigatenena ase engegu y’orooche ang’e nase chiombe chiria chinde. ");
INSERT INTO guz_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Agwo chiombe chiria chimbe chindeu chikaria chiria chingiya chinoru. Erio Farao akaboka. ");
INSERT INTO guz_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Akaraara naende, akaroota eria kabere, akarora ebigara bitano na bibere ebinene ebinoru, bikinete ase oroboba oromo. ");
INSERT INTO guz_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Magega yabo ebigara binde ebireu, ebiasusanirie nomwaga ore korwa moocha, bikaoroka. ");
INSERT INTO guz_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Agwo ebigara ebio ebireu bitano na bibere bikaria biria binde ebinene ebinoru. Farao akaboka, akanyora ng’a nigo are koroota. ");
INSERT INTO guz_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ekero bwachia gokia mambia, akaba oichaanete, agatoma abanto barangerie abaringoria bonsi ba Misiri na abanto abang’aini bonsi abaarengeo. Farao akabateebia chindoto chiaye, korende onde tatogete ore konyara komoteebia engencho ye chindoto echio. ");
INSERT INTO guz_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Erio omoteneneri bw’ebinyugwa agateebia Farao: “Bono nainyoire okomocha kwane. ");
INSERT INTO guz_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ekero aye Farao gwatobeete intwe abasomba bao, na gotosiekera, inche na omoteneneri bw’abaroisia emegati, ase echela eyere ase enyomba y’omotang’ani bw’abarendi, ");
INSERT INTO guz_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","intwe ase obotuko obomo tokaroota chindoto twensi, kera oyomo okoroota kwaye kore nengencho yaye eng’ao. ");
INSERT INTO guz_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Agwo amo naintwe narengeo omomura oyomo Omoiberania, omosomba bw’omotang’ani bw’abarendi. Tokamoteebia chindoto chiaito, na ere agatoteebia engencho ye chindoto chiria, agatobanorera kera oyomo engencho y’okoroota kwaye. ");
INSERT INTO guz_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na buna ere atoteebetie engencho ye chindoto chiaito, naboigo abeete; inche nkairanigwa ase emeremo yane, na oria onde agasungwa ase omote igoro.” ");
INSERT INTO guz_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Erio Farao agatoma abanto korangeria Yusufu. Bakamorenta bwango korwa ase echela, na ere akagingirwa, akaonchoreria chianga chiaye, akagenda ase obosio bwa Farao. ");
INSERT INTO guz_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao agateebia Yusufu: “Nigo narota okoroota, gose onde tari oranyare gonteebia engencho y’okoroota kwane. Inche naigure amang’ana ao ng’a gokwaigure chindoto, nabo okomanya engencho ye chindoto echio.” ");
INSERT INTO guz_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu akairaneria Farao, akabora: “Tari inche, korende Nyasae orakoe aye Farao okoiraneria kw’omorembe.” ");
INSERT INTO guz_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Erio Farao agateebia Yusufu: “Ase okoroota kwane nigo narooche ng’a nteneine ase engegu y’orooche. ");
INSERT INTO guz_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nkarora chiombe isano na ibere, chinoru chingiya mono, chikorwa rooche, chikorisia amasangaka; ");
INSERT INTO guz_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","naende nkarora chiombe chinde isano na ibere, chimbe mono chindeu, chikorwa rooche, chigochitunyana korwa magega. Ase ense yonsi ya Misiri tinana korora chiombe chimbe buna echio. ");
INSERT INTO guz_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Agwo chiombe chiria chimbe chindeu chikaria chiombe chiria isano na ibere chi’eritang’ani, chiare chingiya chinoru, ");
INSERT INTO guz_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","korende ekero chiachirire tichiarorekana ng’a nchiachiria, nkarora nabo chire buna chiare ritang’ani. Erio nkaboka. ");
INSERT INTO guz_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Naende konararire nkarora ase okoroota kwane ebigara ebinene ebinoru bitano na bibere, bikinete ase oroboba oromo; ");
INSERT INTO guz_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","na ebigara ebiomo ebireu, ebiasusanirie nomwaga ore korwa moocha, bikaoroka korwa magega yabo, ");
INSERT INTO guz_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","na ebigara biria ebireu bikaria biria ebinoru bitano na bibere. Inche ngateebia abaringoria, korende onde tari onyarete gonteebia engencho y’okoroota kwane.” ");
INSERT INTO guz_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Erio Yusufu agateebia Farao: “Chindoto chiao, aye Farao, nigo chire echimo. Nyasae okworokirie, aye Farao, aya agochia gokora iga bwango. ");
INSERT INTO guz_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Chiombe chiria chingiya isano na ibere, eyio nemiaka etano na ebere, na ebigara biria ebiya bitano na bibere, eyio nemiaka etano na ebere; chindoto echio nechimo. ");
INSERT INTO guz_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ne chiombe chiria isano na ibere chimbe chindeu, chiachitunyanete chiria chinoru, eyio nemiaka etano na ebere, na ebigara biria bitano na bibere bitaamete, biasusanirie nomwaga ore korwa moocha, eyio nemiaka etano na ebere y’enchara. ");
INSERT INTO guz_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Aya naro buna nagoteebia aye Farao, ng’a Nyasae okworokirie aya agochia gokora iga bwango. ");
INSERT INTO guz_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Rora, ngochi-gocha ere emiaka etano na ebere y’omoigoto ase ense yonsi ya Misiri, ");
INSERT INTO guz_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","korende magega y’ayio neche emiaka ende etano na ebere y’enchara; na omoigoto oria bwonsi nigo ogochia kwebwa ase ense ya Misiri, ekiagera enchara eria nigo erarie ense eye. ");
INSERT INTO guz_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Omoigoto oria tokoinyorwa ase ense eye, ase engencho y’enchara eye erache gocha korwa magega yaye, ekiagera nigo erabe endito mono. ");
INSERT INTO guz_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Na bono Farao, okoroota kwao nigo gwachete eria kabere, aya nigo akoorokia ng’a Nyasae ochikiire amang’ana aya, na Nyasae nayaikeranie iga bwango. ");
INSERT INTO guz_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ase ayio Farao, rigia omonto ore omomanyi na omong’aini, omobeke igoro y’ense yonsi ya Misiri. ");
INSERT INTO guz_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Na bono Farao, aya naro ogwenerete okore: Obeke abateneneri igoro y’ense eye bachoge ensemo ya isano y’endagera ase ense ya Misiri ase emiaka eye etano na ebere y’omoigoto. ");
INSERT INTO guz_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tiga basangererie endagera eye yonsi y’emiaka eye emiya egocha, bayebeke erendwe ase emechie, ase okobua gwa Farao. ");
INSERT INTO guz_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Na endagera eye egachwe eche koegwa abanto emiaka eye etano na ebere y’enchara, erache gocha ase ense ya Misiri, abanto tibaabaisa gocha gosira ase enchara eyio.” ");
INSERT INTO guz_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Amang’ana ayio akagwenera Farao amo nabasomba baye bonsi. ");
INSERT INTO guz_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farao akabooria abasomba baye: “Inee! Ng’ai toranyore omonto onga buna oyo ore n’Omoika o Nyasae ime yaye?” ");
INSERT INTO guz_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Erio Farao agateebia Yusufu: “Ekiagera Nyasae okomanyirie amang’ana ayio onsi, onde tari aa omanyete, naende ore na obong’aini buna aye. ");
INSERT INTO guz_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Bono naye orabe omoteneneri bw’enka yane, na abanto baane bonsi nabakoigwere buna orabe gokobachika. Ase ekerogo kiane ki’obogaambi oka, nao ndabe omonene gokobua.” ");
INSERT INTO guz_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farao agateebia Yusufu: “Rora nakobekire aye igoro y’ense yonsi ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Erio Farao akarusia ebonyi yaye ere nekemanyererio korwa ase ekiara kiaye, akamoyebeekera Yusufu kiara kiaye, akamobekera na eanga engiya y’egatani, akamobekera ne chisonoi chi’etaabu igoti riaye. ");
INSERT INTO guz_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Akamoriinia ase egari yaye ya kabere y’oborwoti. Abanto bagaaka eriogi, bakobora: “Tung’ama inse!” Naboigo akamobeka abe omogambi bw’ense yonsi ya Misiri. ");
INSERT INTO guz_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Naende Farao agateebia Yusufu: “Ninche Farao. Otancheti aye, onde takoba ase ense yonsi ya Misiri oraimoke gokora gento.” ");
INSERT INTO guz_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao Akaroka Yusufu Safenati‐Panea; akamonyuomeria omokungu, nere Asenati, omoiseke o Potifera, Omokuani bw’Oni. Yusufu akagenda aaria na aaria korigereria ense yonsi ya Misiri. ");
INSERT INTO guz_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Agwo Yusufu, ekero asoete gokorera Farao, omorwoti o Misiri, nigo arenge nemiaka emerongo etato. Na Yusufu akarua ase obosio bwa Farao, agaetanana ase ense yonsi ya Misri. ");
INSERT INTO guz_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Emiaka eria etano na ebere y’omoigoto egaika, ense ekaama endagera enyinge, ");
INSERT INTO guz_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","na Yusufu agasangereria endagera yonsi ase emiaka eria etano na ebere, ase ense ya Misiri, akayegacha ase emechie. Ase kera omochie akagacha endagera yonsi y’emegondo eria yayoetanaine. ");
INSERT INTO guz_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu akagacha endagera ase obonge mono, ekaba enyinge buna omokenye bw’Enyancha, goika agatiga koyerenga, ekiagera tiyare konyara korengeka. ");
INSERT INTO guz_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ritang’ani konya emiaka eria y’enchara etaracha, Asenati, mosubati o Potifera, Omokuani bw’Oni, akaiborera Yusufu abana abaisia babere. ");
INSERT INTO guz_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu Akaaroka omwana oria omotangi Manase, agateeba: “Nyasae ogerire inyebe obokong’u bwonsi na abanto b’enka ya tata” ");
INSERT INTO guz_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Na omwana o kabere akamoroka Efraimu, agateeba: “Nyasae ong’eire oroiboro ase ense y’emechando yane.” ");
INSERT INTO guz_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Emiaka eria etano na ebere y’omoigoto ekaera ase ense ya Misiri, ");
INSERT INTO guz_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","na emiaka eria etano na ebere y’enchara egachaka gocha, buna Yusufu abaanete. Enchara egacha ase chinse chionsi, korende ase ense yonsi ya Misiri endagera n’yareengeo. ");
INSERT INTO guz_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ekero enchara yariete abanto bonsi ba Misiri, barabwo bakamorera Farao abae endagera; na Farao agateebia Abamisiri bonsi: “Genda ase Yusufu, na rinde rionsi arabateebie, goika morikore.” ");
INSERT INTO guz_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ase igo, ekero enchara yasoete ase ense eria engima, Yusufu akaigora ebiage bionsi, akaooneria Abamisiri endagera, ekiagera enchara nigo yabeete endito ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Abanto b’echinse chionsi bagacha Misiri kogora endagera korwa ase Yusufu, ekiagera enchara nigo yareenge endito ase ense engima. ");
INSERT INTO guz_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ekero Yakobo aigwete ng’a endagera nekare ase ense ya Misiri, akabooria abamura baye: “Inaki morigereranetie iga?” ");
INSERT INTO guz_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Naende akabateebia: “Naigure ng’a endagera nekare Misiri, tirimboka gochiao, motogorere endagera toche koria, tobe moyo, titokwa.” ");
INSERT INTO guz_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ase igo, bamura bamwabo Yusufu ikomi bagatirimboka gochia Misiri kogora endagera. ");
INSERT INTO guz_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Korende Yakobo tamwancherete Benjamini, omwabo Yusufu, kogende amo nabarabwo, ekiagera nigo aoboete ng’a aande nabaise gochia konyorwa n’amabe. ");
INSERT INTO guz_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nabo basinto ba Israeli bakagenda amo nabaanto bande abachiete kogora endagera, ekiagera enchara yarenge ase ense ya Kaanani. ");
INSERT INTO guz_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusufu nere orenge gabana igoro y’ense yonsi ya Misiri, naende nere orenge kooneria abanto bonsi b’ense eria endagera. Na abamwabo Yusufu, ekero baigete asare, bagatung’ama inse ase obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu, ekero abarora, akabamanya, korende agekora buna tabamanyeti, agakwana nabarabwo amang’ana amakong’u. Akababooria: “Abanto aba, ng’ai mwarure?” Barabwo bakamoiraneria: “Nigo twarure ase ense ya Kaanani, twachire kogora endagera.” ");
INSERT INTO guz_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nonya Yusufu omanyete abamwabo, barabwo tibamomanyete ere. ");
INSERT INTO guz_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Erio Yusufu akainyora chindoto chiria areenge kobarootera, akabateebia: “Inwe nechirooti more, nigo mwachire koroota ense eye, na korora ase ere bosa etari na getango.” ");
INSERT INTO guz_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bakamokania: “Tari bo, Omonene, intwe abasomba bao nigo twachire kogora endagera. ");
INSERT INTO guz_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Intwe twensi nabana b’omonto oyomo. Intwe abasomba bao nigo tore abanto abaronge, titori chirooti.” ");
INSERT INTO guz_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Akabakania: “Yaya, nigo mwachire koroota ense, na korora ense ase ere bosa etari na getango.” ");
INSERT INTO guz_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Barabwo bakamoiraneria: “Intwe abasomba bao nigo tore abamura ikomi na babere, abana b’omonto oyomo, ase ense ya Kaanani; na bono omoke ominto tari aa, inka akare ase tata, na oyomo ere takaiyo.” ");
INSERT INTO guz_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Korende Yusufu akabateebia “Nabo ere buna konya naikire kobateebia, ng’a inwe nechirooti more. ");
INSERT INTO guz_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ase amang’ana aya nimbateeme: Amaene, buna Farao are moyo, timokorua aa mogende, oria omino omoke ataracha aa. ");
INSERT INTO guz_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Toma oyomo oino agende korenta oyio omino, na inwe abande motigare echela. Nabo morateemwe gose namaene mogoteeba. Onye taibo, amaene buna Farao are moyo, inwe nechirooti more.” ");
INSERT INTO guz_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Erio agasiekera bonsi amo echela ime ase amatuko atato. ");
INSERT INTO guz_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Rituko ria gatato Yusufu akabateebia: “Mokore iga buna ndabateebie, nario morabe moyo; naki inche nomonto imoirogete Nyasae. ");
INSERT INTO guz_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Onye inwe more abanto abaronge, tiga oyomo oino atigare aa ase echela, na inwe abande moirere abwo mwatigete inka endagera, ase engencho y’enchara; ");
INSERT INTO guz_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","erio morente oria omino omoke ase ’nde. Igo amang’ana aino aenekigwe ng’a namaene are, na inwe timobaisa gokwa. Barabwo bagakora bo.” ");
INSERT INTO guz_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Erio bagateebania barabwo ase barabwo: “Amaene, ntwamocherete oyominto. Nigo twarooche ogochandeka kw’omoyo oye, na ekero atosororete titwamoigwete. Ase ayio nakio kiagerire obokong’u obo bwatonyorire.” ");
INSERT INTO guz_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni akabairaneria, “Tinabakanetie ng’a timomochera omosae oyo? Korende inwe mokanga, timwanyigwera. Ase igo, bono amanyinga aye aganigwe aakanwe.” ");
INSERT INTO guz_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Barabwo tibamanya ng’a Yusufu nayaigwete, ekiagera omonogi nareengeo ore komoonchorera. ");
INSERT INTO guz_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Erio akarua ase bare, akagenda ensemo, akarera amariga; naende akairana, agakwana nabarabwo. Akarusia Simioni korwa ase bare, akamosiba korwa ase amasio abo. ");
INSERT INTO guz_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu agachiika abanto baichorie chigunia chiabo endagera, na kera oyomo airanerigwe chitaabu chiaye, chibekwe egunia yaye ime, na aegwe endagera agochia koria inchera. Naboigo baabakorerete. ");
INSERT INTO guz_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Erio bakaberekia chitigere chiabo endagera, bakagenda. ");
INSERT INTO guz_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ekero baigete ase bakorara botuko, oyomo obo agasansora egunia yaye arusie endagera ae etigere yaye, akarora chitaabu chiaye igoro y’endagera ase egunia yaye ime, ");
INSERT INTO guz_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","agateebia abamwabo: “Ayee! Chibesa chiane nigo chiairanetigwe, rigereria, nao chire aa egunia yane ime!” Chinkoro chiabo chikagoyaana, bakarigererania na koiguswa, bagateeba: “Inki eke Nyasae atokoreire iga?” ");
INSERT INTO guz_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ekero baigete ase Yakobo ise, ase ense ya Kaanani, bakabateebia ayio onsi abanyorete, bakaboora, ");
INSERT INTO guz_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Omonto oria omonene bw’ense eria nigo akwanete naintwe amang’ana amakong’u agatoroka ng’a intwe nechirooti, tokoroota ense. ");
INSERT INTO guz_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Korende tokamoteebia: Intwe nigo tore abanto abaronge, titori chirooti. ");
INSERT INTO guz_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nigo tore abamura ikomi na babere, tata noyomo. Oyomo oito takaiyo, na omoke kegima nere okare ase tata inka, ase ense ya Kaanani. ");
INSERT INTO guz_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Omonto oyio, omonene bw’ense eria, agatoteebia: Ase amang’ana aya naro ndamanyere gose nabaanto abaronge more: Tiga oyomo oino aiga ase ’nde, inwe abande genda, moire endagera ase engencho y’enchara ekare inka seino. ");
INSERT INTO guz_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Genda mondetere oyio omino omoke, erio nario ndamanye ng’a timori chirooti, korende nabaanto abaronge. Erio nimbairanerie oyomino, na inwe inamonyore ribaga mobe mokoonchoreria ase ense eye.” ");
INSERT INTO guz_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ekaba ekero baumorete endagera korwa ase chigunia, bakanyora kera oyomo esaro ye chitaabu chiaye nao ere egunia yaye ime. Na ekero barabwo amo na ise barooche chisaro chi’echitaabu chiabo, bakaondoka. ");
INSERT INTO guz_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakobo ise akabateebia: “Mwang’urire abana baane, Yusufu taiyo, na Simioni taiyo, na bono morigetie koira Benjamini nere. Amang’ana aya onsi anyorire inche.” ");
INSERT INTO guz_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Erio Rubeni agateebia ise “Oite abana baane babere abamura onye tinkomoirania gocha asore. Mobeke ase amaboko aane na inche nimoiranie.” ");
INSERT INTO guz_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Akamokania: “Omwana one tagotirimboka amo nainwe, ekiagera oyomwabo okuure na oyo nere otigarete bweka. Amabe aise gochia komonyoora agwo inchera, nigo moragere ngende ase oboina ne chimbuche chiane inde nomoichano.” ");
INSERT INTO guz_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Enchara ekaba enene ase ense. ");
INSERT INTO guz_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Na ekero bakoorire endagera eria bagorete korwa Misiri, ise akabateebia: “Irana naende motogorere endagera nke toche koria.” ");
INSERT INTO guz_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Korende Yuda akabateebia: Omonto oria nigo atochigete bokong’u, agatoteebia: Timogocha kondora obosio bwane oyio omino atacheti amo nainwe. ");
INSERT INTO guz_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Koratoe oyominto agende amo naintwe, rirorio inatotirimboke tokogorere endagera. ");
INSERT INTO guz_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Korende onye togotomoa togende komo, rirorio titokogenda, ekiagera omonto oria nigo atoteebetie, “Timokondora obosio bwane motacheti noyio omino.” ");
INSERT INTO guz_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israeli akababooria: “Ninki mwankorera igo na gonchanda, goika mogateebia omonto oria ng’a mokare noyomino onde inka?” ");
INSERT INTO guz_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Barabwo bakamoiraneria: “Omonto oria nigo atounetie mono amanye amang’ana aito na ay’eamate yaito, agatoboria: Iso moyo are? Mokare nonde omino? Na intwe tokamoiraneria buna atoboretie. Inee! Ntwamanyete aya agochia gokwana ng’a: Gachie morente oyomino?” ");
INSERT INTO guz_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda agateebia Israeli ise: “Mong’e omosae oyo agende amo nainche, erio toimoke togende aroro, erinde egere tobe moyo, titokwa, intwe, naye, amo nabana baito abake. ");
INSERT INTO guz_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nerure imbe intenenera asare: korwa ase okoboko kwane oche komonsaba. Onye tinkomoirania gocha asore, rirorio ontige mbogorie okomocha okwo amatuko onsi ase obosio bwao. ");
INSERT INTO guz_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Onye totatebanire nanga twairanire chintunda ibere.” ");
INSERT INTO guz_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Israeli ise akabateebia: “Onye naboigo are, bono mokore iga: Mobeke ebinto ebiya bi’ense eye yaito ase chigunia chiaino, moirere omonto oyio buna ebiegwa. Momoirere amaguta okogwenia make, na obooke boke, na ubani, na manemane, na amajozi. ");
INSERT INTO guz_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mobogorie chitaabu ara kabere ase amaboko aino, moirane chitaabu chiria chiairanetigwe, echio chiabegetwe igoro y’endagera ase chigunia chiaino ime. Aande nigo chiebetwe chikabekwao. ");
INSERT INTO guz_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Moire na oyomino, mogende komo, mogende ase omonto oria naende. ");
INSERT INTO guz_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nyasae Omobui abae ogwancherwa ase obosio bw’omonto oyio, erio abasiborere oria omino onde, erinde moirane nere amo na Benjamini. Onye inche ekongwenera nsirerwe nabana baane, tiga abe bo.” ");
INSERT INTO guz_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ase igo, abanto abwo bakaimokia ebiegwa, bakaimokia ne chitaabu ara kabere; amo na Benjamini bakagenda, bagatirimboka gochia Misiri, bagachia bagatenena ase obosio bwa Yusufu. ");
INSERT INTO guz_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ekero Yusufu arooche Benjamini ore amo nabarabwo agateebia omoteneneri bw’enka yaye: “Barente abanto abwo nyomba, na onyenye emori, oyeroisie, ekiagera abanto abwo nigo bagocha koragera amo nainche endagera ya mobaso.” ");
INSERT INTO guz_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Omonto oria agakora buna Yusufu amotebetie, agasoyia abanto abwo nyomba ime. ");
INSERT INTO guz_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Korende abanto aba bakaondoka, ekiagera bairetwe nyomba mwa Yusufu, bakaboora: “Nigo twarentirwe nyomba ime ase engencho ye chitaabu chiria chiabegetwe ase chigunia chiaito engaki eria entang’ani. Na bono nigo ararigie gotosoera, na atoimokere, atobwate, atokore tobe abasomba baye, aire ne chitigere chiaito.” ");
INSERT INTO guz_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ase igo, bakamoika ang’e omoteneneri oria bw’enka ya Yusufu, bakaba bagokwana nere gesieri ki’enyomba, ");
INSERT INTO guz_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","bakabateebia: “Koranche Omonene, otoigwe! Engaki eria entang’ani twachete aiga kogora endagera, ");
INSERT INTO guz_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ekero twairanete gochia seito, gotwaikire ase twaraarete botuko, togachia gosansora chigunia chiaito, tokanyora kera omonto chitaabu chiaye nao chire igoro y’endagera ase egunia yaye ime, chitaabu chionsi pi. Bono chitaabu echi chionsi ntwachirentana, naa tochibwate amo naintwe. ");
INSERT INTO guz_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Naende ntwarentana chitaabu chinde, echi togocha kogora endagera. Titomanyeti gose ning’o ochibegete ase chigunia chiaito ime.” ");
INSERT INTO guz_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Akabairaneria “Timoka, motoerere, timoondoka; Nyasae oino, oyore Nyasae o iso, nere obaete enibo eye ase chigunia chiaino; chitaabu chiaino inachinyorete.” Erio akarenta Simioni ase bare. ");
INSERT INTO guz_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Omonto oria akaira abanto baria nyomba mwa Yusufu, akabaa amaache bagesibia amagoro abo, akaa ne chitigere chiabo endagera. ");
INSERT INTO guz_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Barabwo bakabeeka ebiegwa biabo ang’e, baganye Yusufu kagocha mobaso, ekiagera konya baigure ng’a nao bagocha koragerera endagera ya mobaso. ");
INSERT INTO guz_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Na ekero Yusufu achete nyomba ime bakamoirera ebiegwa biria barentete, bagatung’ama inse ase obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Akabakwania, akababooria: “Inee! Iso mbuya are, omogaka oria mwanteebia? Moyo are?” ");
INSERT INTO guz_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Bakamoiraneria: “Ee, omosomba oo tata mbuya are. Nabo moyo are.” Barabwo bagatureka emetwe yabo inse. ");
INSERT INTO guz_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu agachia koimokia amaiso aye, akarora Benjamini omwabo, omwana omwabo baruete enda eyemo nere, akababooria: “Oyo nere oria omoke omino, oria mwanteebia?” Akaonchokera Benjamini, akamoteebia: “Nyasae akoe obuya, omwana one!” ");
INSERT INTO guz_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Erio Yusufu akaimoka, agasoa enyomba ende, ekiagera enkoro yaye nigo yaare namaiga ase omwana omwabo, aroro ase enyomba eyio akarera amariga. ");
INSERT INTO guz_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Erio agesibia obosio, agasoka oremereretie. Naende akabora: “Renta endagera!” ");
INSERT INTO guz_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Bakamobekera endagera bweka ao, na abamwabo boka ao, na Abamisiri baria konya bakoragera komo boka ao, ekiagera Abamisiri nigo bagechete Abaiberania, tibaare koria amo nabarabwo. ");
INSERT INTO guz_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Abamwabo Yusufu bagaikaransigwa ase obosio bwaye, bakaroberigwa gochakera ase oria omonene kogenderera goika ase oria omoke. Bonsi kobaikaransire, bakarigererania, bagakumia. ");
INSERT INTO guz_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Bakaegwa endagera korwa ase emesa ya Yusufu, korende Benjamini ere akarenterwa enyinge kobua abwo bande, ebirengo bitano. Naboigo bakanywa, bakagoka amo nere. ");
INSERT INTO guz_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Erio Yusufu agachiika omoteneneri bw’enka yaye: “Ichoria chigunia chi’abaanto aba endagera, koreng’ana buna baranyare kobogoria, obeke ne chitaabu chia kera omonto igoro y’endagera ase egunia yaye ime. ");
INSERT INTO guz_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Obeke na egekombe kiane keria kiaroisetigwe korwa ase chifeta, okebeke ime ase egunia y’omomura oria omoke kegima, amo ne chitaabu chiria achete nachio kogora endagera.” Ere agakora buna Yusufu amotebetie. ");
INSERT INTO guz_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Bogachia gokia mambia abanto baria bakaegwa ribaga baimokie chitigere chiabo, bagende sobo. ");
INSERT INTO guz_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ekero bagendire egeka geke korwa ase omochie, Yusufu agateebia omoteneneri bw’enka yaye. “Imoka, obwatie abanto baria! Ekero orabanyore obaborie: Nase ki mogoakana amabe ase amaya? ");
INSERT INTO guz_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Inee! Egekombe eke mwaibete, tai kerokio omonene one akonywera? Naende nakio agokorera oboringoria. Mwakorire bobe ase ogokora iga.” ");
INSERT INTO guz_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ekero abaikerete agakwana nabarabwo amang’ana aria aria. ");
INSERT INTO guz_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Barabwo bakamoiraneria: “Naki aye, Omonene oito, ogokwana amang’ana buna ayio? ");
INSERT INTO guz_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tari bo, intwe abasomba bao titware gokora bo. Inee! Chibesa chiria twanyorete igoro y’endagera ase chigunia chiaito ime, titwagochiiraneria naende korwa ase ense ya Kaanani? Naki tware gokora toibe efeta gose etaabu korwa ase enyomba y’omonene oo? ");
INSERT INTO guz_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Oyoranyorekane ore negekombe ekio ase egati yaito intwe abasomba bao, oyio akwe, naintwe boigo rirorio tobe abasomba bao, Omonene oito.” ");
INSERT INTO guz_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Akabora: “Tiga abe buna mwateeba, omonto oranyorekane okebwate nigo arabe omosomba one, korende inwe abande inamobe motari na komocha.” ");
INSERT INTO guz_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Erio bagakora bwango, bagaikia kera omonto egunia yaye inse, na koyesansora. ");
INSERT INTO guz_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Na omosomba oria agachaaka koriga‐rigia, agachakera ase omomura omonene, agachia gokoorera ase omoke, na egekombe gekanyorekana ase egunia ya Benjamini. ");
INSERT INTO guz_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Erio bonsi bagatandora chianga chiabo; kera omonto akabeekera etigere yaye egurube, bakairana gochia ase omochie. ");
INSERT INTO guz_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda na abamwabo, ekero bairanete ase omochie, bakanyora Yusufu nao are nyomba, barabwo bagatung’ama inse bakaumama, ase obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu akababooria: “Ing’ana ki eri mwakorire? Timomanyeti ng’a omonto buna inche nigo ndanyare gokora oboringoria imanye?” ");
INSERT INTO guz_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda akairaneria: “Ninki togoteeba asore, Omonene oito? Ninki togokwana? Gose inatonyare kweenekia ng’a nabaronge tore? Nyasae ororire ebibe biaito intwe abasomba bao; na bono, omonene oito, intwe amo nere, oyo egekombe kianyorekana ase okoboko kwaye, tiga tobe abasomba bao.” ");
INSERT INTO guz_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu akabora: “Yaya, tari bo; tingokora bo. Omonto oyo bweka egekombe kianyorekana koboko kwaye, nere orabe omosomba one, korende inwe abande, genda nomorembe seino ase iso.” ");
INSERT INTO guz_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Erio Yuda akamoika ang’e, akamoteebia: “Koranche, omonene one, ong’e inche, omosomba oo, ribaga ngoteebie ring’ana erimo. Tobaisa kombea inche, omosomba oo, naki aye nigo ore buna Farao. ");
INSERT INTO guz_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Aye omonene one, nigo gwatoboretie intwe abasomba bao: Inee! Mokare na iso gose onde omino? ");
INSERT INTO guz_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Intwe togakoiraneria aye, omonene one: Ee, ntokare na tata, ere ogotire, nakabwate omwana omomura bw’obogotu bwaye, korende momura omwabo nakwete, oyo nere otigarete bweka ase ng’ina, na ise nigo amwanchete mono. ");
INSERT INTO guz_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Erio ogatoteebia intwe, abasomba bao: Gachie momondetere, ache aa imorore. ");
INSERT INTO guz_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Na intwe togakoiraneria aye, omonene one, ng’a omosae oyo takonyara gotiga ise; aise komotiga, ise nigo arakwe. ");
INSERT INTO guz_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Naye ogatoteebia intwe abasomba bao: Momura omino omoke atatirimbogeti amo nainwe, timogocha ase obosio bwane naende. ");
INSERT INTO guz_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Ekero twairanete ase tata, omosomba oo, tokamoteebia amang’ana ao, omonene one. ");
INSERT INTO guz_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na ekero tata atoteebetie ng’a toirane tomogorere endagera inke, ");
INSERT INTO guz_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","tokamoiraneria: Titokonyara gotirimboka gochia ase obosio bw’omonto oria, oyominto omoke atari amo naintwe, korende onye oyominto ogotirimboka amo naintwe, rirorio natogende. ");
INSERT INTO guz_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Erio omosomba oo tata agatoteebia: Momanyete ng’a omokungu one nigo anyiborerete abana abamura babere boka. ");
INSERT INTO guz_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Oyomo nigo ansirerete, na inche ngateeba: Tekomocha koba ng’a neching’iti chi’orosana chiamoitete, tinana komoorora goika reero iga. ");
INSERT INTO guz_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Onye mokoirana oyo nere korwa ase ’nde, na amabe achie komonyoora, rirorio nigo moragere inkwe ngende ase oboina ne chimbuche chiane, inde nomoichano. ");
INSERT INTO guz_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Na bono kondagende inka ase tata, omosomba oo, ntaireti omosae oyo amo naintwe, oyo tata nigo amwanchete mono, takorora buya. ");
INSERT INTO guz_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Ekero ararore ng’a omosae oyo taiyo, nigo arakwe, na intwe, abasomba bao, nigo toragere agende ase oboina ne chimbuche chiaye, ore nomoichano. ");
INSERT INTO guz_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Naki inche, omosomba oo, nigo nebegete nkaba intenenera ase omosae oyo ase tata, nkamoteebia: Ntamoiraneti asore, nigo ndabe omomochi asore ase obogima bwane bwonsi. ");
INSERT INTO guz_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Na bono, omonene one, nagosoroire, ntige imbe omosomba oo ribaga ri’ omosae oyo; ere omotige agende amo nabamwabo inka. ");
INSERT INTO guz_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Naki ndakore ing’irane ase tata, omosae oyo atari amo nainche? Tinkoremereria korora emechando enga buna eyio ekomonyoora tata.” ");
INSERT INTO guz_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Agwo Yusufu agasinywa gotanga okweigwa kwaye, ase obosio bw’abaanto bonsi abateneine ang’e nere, agaaka eriogi, akabora, “Barusie aa bonsi ase obosio bwane!” Ase igo, monto onde tareengeo ase obosio bwa Yusufu ekero emanyekanetie ase abamwabo, ");
INSERT INTO guz_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","korende ekero aagete eriogi ase okorera, Abamisiri amo nabaanto b’enka ya Farao bakamoigwa. ");
INSERT INTO guz_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu agateebia bamura bamwabo: “Ninche Yusufu. Tata moyo are?” Korende bamura bamwabo tibanyara komoiraneria, ekiagera basoetwe nobwoba obonene. ");
INSERT INTO guz_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Erio Yusufu agateebia bamura bamwabo: “Inchuo ase ’nde ang’e!” Barabwo bakamoika ang’e. Naende akabateebia: “Ninche Yusufu omiino, oyo mwaoonetie gocha aa Misiri. ");
INSERT INTO guz_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Korende timoichana, gose timwechanda ase emioyo yaino, ekiagera mwang’oonetie gocha aa. Naki Nyasae nere ontomete mbatang’anere gocha aa, erinde ntoorie obogima bw’abaanto. ");
INSERT INTO guz_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Omwaka oyo noyo o kabere enchara ere ase ense, naende netigarete emiaka etano abanto batareme gose kogesa. ");
INSERT INTO guz_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nyasae nigo antomete mbatang’anere inwe, erinde motigare ase ense, na koba moyo ase ogotooreka kw’abange. ");
INSERT INTO guz_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ase igo,, tari inwe mwantomete gocha aa, korende Nyasae omonyene. Nere ombegete imbe ise Farao, n’Omonene ase enka yaye yonsi, na omogambi ase ense yonsi ya Misiri. ");
INSERT INTO guz_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ayerera bwango, moirane gochia ase tata, momoteebie iga: Aya naro omwana oo Yusufu agoteeba: Nyasae ombekire koba Omonene ase ense yonsi ya Misiri; tirimboka gocha ase ’nde, totebana. ");
INSERT INTO guz_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Aye nigo oramenye ase ensemo ya Goseni, nigo oramenye ang’e nainche, aye amo nabana bao, na abachokoro bao. ");
INSERT INTO guz_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Agwo inche ninkoragerie, erinde tobaisa gocha gosoa ase okoremeerwa, aye amo nabaanto bao, na bionsi ebi ore nabio, ekiagera emiaka etano y’enchara netigarete. ");
INSERT INTO guz_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Na bono imorooche namaiso aino, na Benjamini boigo narooche namaiso aye, ng’a ninche omonyene ngokwana nainwe. ");
INSERT INTO guz_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Moteebie tata obonene bwonsi mbwate aiga Misiri, na binde bionsi mwarorire. Mokore bwango, momorente gocha aa.” ");
INSERT INTO guz_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Erio akaboania Benjamini rigoti, akarera; Benjamini nere akarera kamoboanetie rigoti riaye. ");
INSERT INTO guz_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusufu akanyunyunta abamwabo bonsi, akarera ase bare. Na magega y’ayio abamwabo bakagosoria nere. ");
INSERT INTO guz_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ekero chinkuma chiaigwekanete ase enka ya Farao ng’a abamwabo Yusufu bachire, amang’ana ayio akagwenera Farao amo nabasomba baye bonsi. ");
INSERT INTO guz_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao agateebia Yusufu: “Bateebie abamino iga: Berekia ching’iti chiaino chigurube, moimoke mogende ase ense yaino ya Kaanani, ");
INSERT INTO guz_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Morente iso na abanto b’enka yaye bache ase ’nde. Inche nimbae ebire ebiya bi’ense ya Misiri, na inwe namorie obonoru bw’ense eye. ");
INSERT INTO guz_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Naende goika obateebie iga, Ira chigari korwa aa Misiri, ase okobogoreria abana baino abake, na abakungu baino, mobogorerie na iso, moche nabarabwo. ");
INSERT INTO guz_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Timochandekera ebinto biaino, ebi moratige magega, ekiagera bionsi ebire ebiya mono ase ense ya Misiri nebiaino.” ");
INSERT INTO guz_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Erio basinto ba Israeli bagakora buna bateebetigwe, na Yusufu akabaa chigari buna Farao achiigete, amo nendagera bagochia koria inchera. ");
INSERT INTO guz_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Akaa kera oyomo eanga agochia koonchoreria, korende Benjamini ere akamoa chisekeli chi’echifeta amagana atato amo ne chianga isano, echi agochia koonchoreria. ");
INSERT INTO guz_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Agatomera na ise chitigere ikomi chiabogoretie ebinto ebiya mono bia Misiri, ne chitigere chiaberi chiabogoretie endagera, na emegati, na endagera ende agochia koria inchera. ");
INSERT INTO guz_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Erio agatigana nabamwabo bagende sobo, akabateebia: “Timobaisa kwomana inchera!” ");
INSERT INTO guz_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Barabwo bakarua Misiri, bagaika ense ya Kaanani ase Yakobo ise. ");
INSERT INTO guz_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Agwo bakamanyia ise amang’ana ng’a Yusufu moyo are, naende nere omogambi ase ense yonsi ya Misiri. Yakobo agachia koyaigwa, akagoyaana ase omoyo oye, tanyara kwegena amang’ana abo. ");
INSERT INTO guz_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Korende bakamoteebia amang’ana onsi Yusufu abateebetie. Ere agachia korora chigari chiria Yusufu amotomerete chigocha komoimokia, omoyo oye okaba nobogima oboyia. ");
INSERT INTO guz_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israeli akabora: “Ayio aisanire. Yusufu, omwana one, moyo are. Nigo ndagende komoorora ritang’ani ntarakwa.” ");
INSERT INTO guz_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ase igo, Israeli akaimoka, akagenda, akaira ebinto bionsi ebi abwate, agaika Beeri‐Seba, akaruera Nyasae o Isaka ise ekeng’wanso. ");
INSERT INTO guz_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nyasae akarangeria Israeli ase okorora ekero kia botuko, akabora: “Yakobo! Yakobo!” Ere agaitaba: “Nao inde aa.” ");
INSERT INTO guz_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Erio akamoteebia: “Inche ninche Nyasae, Nyasae o iso; tobaisa kwoboa gotirimboka gochia Misiri, ekiagera ningokore obe egesaku ekenene aroro. ");
INSERT INTO guz_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Inche nintirimboke amo naye goika Misiri, naende tinkomocha gokoirania; na Yusufu nabe okoirania amaiso ao kogw akuure.” ");
INSERT INTO guz_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Erio Yakobo akaimoka korwa Beeri‐Seba, akagenda. Basinto ba Israeli bakabogoria Yakobo ise, amo nabana babo abake, na abakungu babo ase chigari chiria Farao abatomerete chibabogorie. ");
INSERT INTO guz_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Bakaira chitugo chiabo ne chinibo chiabo echi baniberete ase ense ya Kaanani. Nabo bagaika Misiri, Yakobo na oroiboro rwaye rwonsi amo nere, ");
INSERT INTO guz_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","abana baye abamura na abamura babo; na abana baye abaiseke, na abaiseke b’abamura babo. Naboigo akaira oroiboro rwaye rwonsi, akagenda nabarabwo goika Misiri. ");
INSERT INTO guz_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aya naro amarieta Abaisraeli abwo bagendete Misiri: Yakobo na abana baye, nabwo aba: Rubeni, nere omotangi o Yakobo. ");
INSERT INTO guz_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Abana abamura ba Rubeni nabwo aba: Hanoki, na Palu, na Hezironi, na Karimi. ");
INSERT INTO guz_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Na abana abamura ba Simioni nabwo aba: Yemueli, na Yamini, na Ohadi, na Yakini, na Sohari, na Saulo, omwana bw’omokuungu Omokaanani. ");
INSERT INTO guz_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Na abana abamura ba Lawi nabwo aba: Gerisoni, na Kohati, na Merari. ");
INSERT INTO guz_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Na abana abamura ba Yuda nabwo aba: Eri, na Onani, na Sela, na Peresu, na Zera; korende Eri na Onani bagakwera ase ense ya Kaanani. Na abana ba Peresu nabwo Hezironi na Hamuli. ");
INSERT INTO guz_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Na abana abamura ba Isakaru nabwo aba: Tola, na Pua, na Yobu, na Simuroni. ");
INSERT INTO guz_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Na abana abamura ba Sabuloni nabwo aba: Seredi na Eloni, na Yaleeli. ");
INSERT INTO guz_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Aba nabwo abana abamura Lea aiborerete Yakobo agwo Padan‐Aramu. Na omoiseke oyomo aiborete, nere Dina. Abana baye bonsi amo nabachokoro, abamura na abaiseke, nigo baareenge emerongo etato na batato. ");
INSERT INTO guz_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Abana abamura ba Gadi nabwo aba: Sifioni, na Hagi, na Suni, na Esiboni, na Eri, na Arodi, na Areli. ");
INSERT INTO guz_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Na abana abamura b’Aseri nabwo aba: Imuna, na Isiva, na Isivi, na Beria, na omoiseke omwabo nere Sera. Na abamura ba Beria nabwo Heberi na Malikieli. ");
INSERT INTO guz_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Aba nabwo abamura na abachokoro ba Silpa, oyio Labani aete Lea, omwana oye omosubati. Abwo Silpa aiborerete Yakobo, abanto ikomi na batano nomo. ");
INSERT INTO guz_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Abana abamura ba Raeli, moka Yakobo, nabwo Yusufu na Benjamini. ");
INSERT INTO guz_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusufu akaiborerwa Manase na Efraimu, ase ense ya Misiri. Asenati, mosubati o Potifera, Omokuani bw’Oni, akamoiborera abana abwo abamura. ");
INSERT INTO guz_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Na abana abamura ba Benjamini nabwo aba: Bela, na Bekeri, na Asibeli, na Gera, na Naamani, na Eki, na Roshi, na Mupimu, na Hupimu, na Aridi. ");
INSERT INTO guz_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Aba nabwo abamura na abachokoro Raeli aiborerete Yakobo, abanto ikomi na baane. ");
INSERT INTO guz_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Omwana omomura o Dani nere Husimu. ");
INSERT INTO guz_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Na abana abamura ba Nafutali nabwo aba: Yaseeli, na Guni, na Yaseri, na Silemu. ");
INSERT INTO guz_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Aba nabwo abamura na abachokoro abamura Bilia aiborerete Yakobo, abanto batano na babere. ");
INSERT INTO guz_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Abanto bonsi abagendete amo na Yakobo ase ense ya Misiri, abwo baiboretwe korwa asare, nigo baareenge emerongo etano nomo, na batano nomo. Abakungu b’abana abamura ba Yakobo, barabwo tibaabariri. ");
INSERT INTO guz_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Na abana abamura ba Yusufu, abaiboreretwe agwo Misiri, mbabere baarenge. Abanto bonsi ba Yakobo abasoete Misiri nigo baarenge emerongo etano na ebere. ");
INSERT INTO guz_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo agatoma Yuda amotang’anere kogenda ase Yusufu, erinde aoroke ase obosio bwaye agwo Goseni, Naboigo bagaika ase ensemo ya Goseni. ");
INSERT INTO guz_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Erio Yusufu akabeeka egari yaye ang’e, akayeriina, akagenda korotota Israeli aria Goseni. Ekero achia goika asare akamoboania rigoti riaye engaki etari nke. ");
INSERT INTO guz_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israeli agateebia Yusufu: “Bono tiga inkwe, ekiagera nakororire obosio bwao, naende narorire ng’a moyo ore.” ");
INSERT INTO guz_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu agateebia abamwabo na abanto b’enka ya ise: “Nkogenda inde ase Farao imoteebie: Abaminto na abanto b’enka ya tata, aba baarenge ase ense ya Kaanani, bachire ase ’nde. ");
INSERT INTO guz_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Na abanto abwo nabatugi be chitugo, na bono barentire chitugo chiabo, ching’ondi ne chiombe, na binde bionsi bare nabio. ");
INSERT INTO guz_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Bono, Farao karabarangerie na kobaboria meremo ki monarete gokora, ");
INSERT INTO guz_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","nigo moramoiranerie: Intwe abasomba bao nigo tore abatugi be chitugo korwa obwana bwaito goika reero; buna tore igo, nabo ne chisokoro chiaito chiareenge. Na igo namonyore ribaga komenya ase ensemo ya Goseni, ekiagera kera omorisia bwe chitugo nigo are okogechia ase Abamisiri.” ");
INSERT INTO guz_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Erio Yusufu akagenda agateebia Farao: “Tata na bamura baminto bachire korwa ase ense ya Kaanani, amo ne chitugo chiabo, ching’ondi ne chiombe, na binde bionsi bare nabio; barabwo nao bare ase ensemo ya Goseni.” ");
INSERT INTO guz_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Agachora abamwabo batano, akabaira ase obosio bwa Farao. ");
INSERT INTO guz_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao akababooria: “Emeremo yaino nereri?” Bakamoiraneria, “Intwe abasomba bao nigo tore abarisia be chitugo, buna nechisokooro chiaito chiareenge.” ");
INSERT INTO guz_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Naende bakabateebia: “Nigo twachire tobe abamenyi b’ense eye, ekiagera intwe, abasomba bao, titori nase tokorisia amaicho aito, ekiagera enchara nenene mono ase ense ya Kaanani. Ase igo, koranche otoe intwe, abasomba bao, ribaga tomenye ase ensemo ya Goseni.” ");
INSERT INTO guz_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Erio Farao agakwana na Yusufu, akabateebia: “Narorire ng’a iso na abamino bagocheire. ");
INSERT INTO guz_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Bono ense ya Misiri nigo ere ase obosio bwao; bae iso na bamura bamino ribaga bamenye aase are aagiya. Tiga bamenye ase ensemo ya Goseni, naende onye komanyete bande ase egati yabo abamanyete mono emeremo y’obotugi, obabeeke babe abateneneri ase chitugo chiane.” ");
INSERT INTO guz_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Erio Yusufu akarenta Yakobo ise, akamoira ase obosio bwa Farao; na Yakobo agasesenia Farao. ");
INSERT INTO guz_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao akabooria Yakobo: “Inee! Emiaka yao nerenga?” ");
INSERT INTO guz_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo akamoiraneria: “Emiaka yane nakoorire ase ense eye nerigana erimo, na emerongo etato (130). Ase obogima bwane nigo nabeire nobokong’u, naende emiaka yane nemeke, teikereti eye chisokoro chiane chiakorete ase obogima bwabo.” ");
INSERT INTO guz_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakobo agasesenia Farao naende, akarua ase obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu akaa ise amo na bamura bamwabo aase bakomenya, akabaa Ramesesi, orogongo oruya, ensemo engiya mono y’ense eria, buna Farao achiigete. ");
INSERT INTO guz_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nere Yusufu akaba okorenda ise amo nabamwabo bonsi, akabaa endagera buna kera omonto abwate abanto baye bang’ana. ");
INSERT INTO guz_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bono ase ense yonsi endagera tiyareengeo; na enchara nigo yareenge endito mono, konya yanyarire abanto ba Misiri na Abakaanani. ");
INSERT INTO guz_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu agasangereria chitaabu chionsi echianyorekanete korwa ase ense ya Misiri na eya Kaanani ase okooneria abanto endagera, agachibeeka ase ekungo ya Farao. ");
INSERT INTO guz_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ekero chitaabu chionsi chiaerire ase ense ya Misiri na ase ense ya Kaanani, Abamisiri bagachiera Yusufu, bakamosaba, “Toe endagera, titobaisa gokwera ase obosio bwao, ekiagera chitaabu chiaito chiaerire.” ");
INSERT INTO guz_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu akabairaneria, “Onye chitaabu chiaino chiaerire, ndetera chitugo chiaino, na inche mbae endagera morie.” ");
INSERT INTO guz_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Erio bakarentera Yusufu chitugo chiabo, na Yusufu akabaa endagera. Bakarentera Yusufu chibarasi chiabo, ne ching’ondi, ne chiombe, ne chitigere. Igo akaba okobarenda na kobaa endagera ase omwaka oyio oyomo, na barabwo bakamoa chitugo chiabo. ");
INSERT INTO guz_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Omwaka oria oyomo okaera. Naende omwaka o kabere bakamochiera, bakamoteebia: “Titokonyara gokobisa, Omonene oito, ng’a chitaabu chiaito chiaerire, ne chitugo chiaito chiabeire echiao. Titotigareti gento kende togokoa, omonene oito, otatiga emebere yaito na amaremo aito. ");
INSERT INTO guz_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nase ki torakwere ase obosio bwao, na amaremo aito asareke? Togore intwe, ogore na amaremo aito, na intwe tobe abasomba ba Farao, na amaremo aito abe ayaye. Toe chimbusuro tosimeke, titokwa, na amaremo aito abe bosa.” ");
INSERT INTO guz_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Erio Yusufu akagorera Farao amaremo onsi areenge Misiri, naki Abamisiri nigo baoonetie kera omonto oboremo bwaye, ekiagera enchara yareenge endito mono. Naboigo ense ekaba eya Farao. ");
INSERT INTO guz_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Farao akang’anyia abanto abwo bamenye ase emechie, babe abasomba baye, bakore emeremo korwa ensemo eyemo ya Misiri goika eyende. ");
INSERT INTO guz_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Korende Yusufu tagorete amaremo ’abakuani, ekiagera abwo konya bachikeirwe endagera baare konyora korwa ase Farao, nero baare koria. Ase igo, tibagwenerete koonia amaremo abo. ");
INSERT INTO guz_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu agateebia abanto: “Igwa! Reero nabagorire inwe amo namaremo aino, mobe enibo ya Farao. Bwata chimbusuro chiaino echi, chiire mochisimeke ase emegondo. ");
INSERT INTO guz_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Engaki ye rigesa moruserie Farao ensemo ya isano. Chinsemo inye chintigari inachibe echiaino ase chimbusuro na endagera yaino inwe abanyene, na ey’abare ase chinka chiaino, na ey’abana baino.” ");
INSERT INTO guz_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Abanto abwo bakamoiraneria, “Gwatooririe obogima bwaito. Onye twanyorire ogwancherwa ase obosio bwao, Omonene oito, tiga tobe abasomba ba Farao.” ");
INSERT INTO guz_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusufu akabeeka ogochika ase ense ya Misiri, ng’a ensemo ya isano ebe eya Farao; na ogochika okwo ngokora kore emeremo nonya ngoika bono. Korende amaremo ’abakuani oka naro atabeete aya Farao. ");
INSERT INTO guz_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israeli na abana baye bakaba bakomenya ase ense ya Misiri, ensemo ya Goseni, bakayeira ekaba eyabo, bakamenteka na kobucha mono. ");
INSERT INTO guz_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo akamenya ase ense ya Misiri emiaka ikomi, na etano na ebere. Ase igo, agakoora emiaka rigana erimo, na emerongo ene, na etano na ebere (147) ase obogima bwaye. ");
INSERT INTO guz_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ekero engaki y’ogokwa gwa Israeli yabeete ang’e, ere akarangeria Yusufu, omwana oye, akamoteebia, “Onye nkonyora ogwancherwa ase obosio bwao, beeka okoboko kwao inse y’ekebono kiane, na ondiere eira, ng’a nonkorere amaabera na obwanchani. Tontindeka aa ase ense ya Misiri, ");
INSERT INTO guz_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","korende ekero ndakwe, tiga ndare ne chisokoro chiane. Ombogorie korwa aa Misiri, ontindeke aase barabwo batindegetwe.” Yusufu akamoiraneria, “Ninkore buna gwantebirie.” ");
INSERT INTO guz_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Korende Israeli akamoteebia “Tiana ng’a nonkorere bo.” Ere agatiana. Erio Israeli agetureka ase ogotoorera omotwe borere bwaye. ");
INSERT INTO guz_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ekaba engaki magega y’ayio Yusufu ateebetigwe ng’a, “Iso nomorwaire.” Erio akaimokia abana baye babere abamura, Manase na Efraimu, bakagenda komoorora. ");
INSERT INTO guz_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo nere ateebetigwe ng’a “Yusufu, omwana oo, ngocha are gokorora.” Erio Israeli agekomereria, akaboka, agaikaransa borere igoro. ");
INSERT INTO guz_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo agateebia Yusufu: “Nyasae Omobui nang’orokerete aaria Lusu ase ense ya Kaanani, agansesenia, ");
INSERT INTO guz_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","aganteebia: Inche ninkomente, na oroiboro rwao robuche goika robe emeganda y’ebisaku. Ning’ee ororeeria rwao rorache korwa magega yao ense eye ebe omwando obo kare na kare. ");
INSERT INTO guz_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Bono abana bao abamura babere kwaiborerete ase ense ya Misiri ritang’ani ntaracha aa, barabwo nabaane bararokwe. Efraimu na Manase nigo barabe abaane, buna Rubeni na Simioni bare abaane. ");
INSERT INTO guz_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Abana bao bande baiboire magega y’aba, barabwo nabao barabe; korende nigo baratorwe ase amarieta ’abamwabo, na komenya ase omwando obo. ");
INSERT INTO guz_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ekero nare korwa Padan‐Aramu, Raeli nyoko agankwera inchera gonkogenda Kaanani, ritang’ani ntaraika Efarati. Nkamotindeka agwo enchera ekogenda Efarati, nao Bethlehemu.” ");
INSERT INTO guz_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israeli, ekero arooche abana ba Yusufu, akamobooria: “Aba mbarabi?” ");
INSERT INTO guz_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu akamoiraneria: “Aba nabana baane Nyasae ang’erete aiga.” Erio Israeli akamoteebia, “Bandetere aiga ase ’nde, mbasesenie.” ");
INSERT INTO guz_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Bono amaiso a Israeli konya abeire chinchingori ase engencho y’obogotu, tare korora buya. Igo Yusufu akamorentera abana abwo, na ere akabaagata na kobaboania. ");
INSERT INTO guz_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Erio Israeli agateebia Yusufu: “Tinasemeretie ng’a kaa ninche korora obosio bwao naende, na bono Nyasae onyancheire narorire abana bao nabarabwo,” ");
INSERT INTO guz_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu akarusia abana korwa ase amagoro a ise, agatugama inse. ");
INSERT INTO guz_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Erio Yusufu akabwata bonsi babere, Efraimu ase okoboko kwaye gw’okorio, akamobeka ensemo y’okobee ya Israeli, na Manase akamobwata ase okoboko kwaye gw’okobee, akamobeka ensemo y’okorio ya Israeli. ");
INSERT INTO guz_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israeli akarambora okoboko kwaye gw’okorio, agakobeeka igoro ase omotwe o Efraimu, nonya ere orenge omoke; agakorekania amaboko aye na kobeeka okoboko kwaye gw’okobee igoro ase omotwe o Manase, nere orenge omotangi. ");
INSERT INTO guz_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Erio agasesenia Yusufu, akabora, “Nyasae o sokoro yane Aburaamu na o Isaka tata, oyio baare gotaara ase obosio bwaye; Nyasae oyo nere ondisirie ase obogima bwane bwonsi goika reero, ");
INSERT INTO guz_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","omomalaika oria ontooretie korwa ase amabe onsi, asesenie abamura aba. Abana aba babe bagwatorwa ase erieta riane, na ase erieta ria sokoro yane Aburaamu, na eria Isaka tata; tiga bakine babe abanto abange ase ense.” ");
INSERT INTO guz_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu agachia korora ng’a ise obekire okoboko kwaye gw’okorio igoro ase omotwe o Efraimu, ayio tayancha. Akabwata okoboko gwa ise akorusie korwa ase omotwe o Efraimu, erio akobeke ase oyo o Manase. ");
INSERT INTO guz_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu agateebia ise: “Taibo, tata, naki oyo nere omotangi; beeka okoboko kwao gw’okorio ase omotwe oye.” ");
INSERT INTO guz_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Korende ise akaanga, akabora: “Nimanyete, omwana one, nimanyete. Nere boigo nabe egesaku; ere boigo nabe omonene, korende oyomwabo omoke nabe omonene komobua, na oroiboro rwaye narobe egesaku kiabo ao boka.” ");
INSERT INTO guz_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Rituko erio akabasesenia, akabora, “Ekero ogosesenigwa kogokwanwa ase Abaisraeli, abanto baatore amarieta aino na goteeba: Nyasae abakore mobe buna Efraimu na Manase.” Agwo agwo agatang’ania Efraimu ase obosio bwa Manase. ");
INSERT INTO guz_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Erio Israeli agateebia Yusufu: “Rora ng’ang’e inde gokwa. Nyasae nigo arabe amo nainwe, nabairanie gochia ase ense ye chisokoro chiaino. ");
INSERT INTO guz_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Inche nakomentire ensemo y’ekenyoro ekeao kobua abamino. Eyio naurete Abaamori n’omoro one, na obota bwane.” ");
INSERT INTO guz_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Erio Yakobo akarangeria abamura baye, akabateebia: “Sangererekana aa ase ’nde, mbateebie amang’ana arabanyore ase amatuko agochi‐gocha. ");
INSERT INTO guz_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Inchuo montegerere, inwe abana ba Yakobo; montegerere inche Israeli iso. ");
INSERT INTO guz_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubeni, aye nomwana one omotangi, aye nokobua kwane, na ogotongora gwe chinguru chiane. Noetanetie abamino ase okobua, nobaetanetie ase chinguru. ");
INSERT INTO guz_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Aye nkwaberete buna amaache; korende togoetania abande, ekiagera nkwarinete borere bwa iso, okabosaria, ase igo okarenta obosooku. ");
INSERT INTO guz_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simioni na Lawi naba ng’ina omo, ebirwanero biabo nebi’obotindi. ");
INSERT INTO guz_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Omoyo one tosoa ase obobisi bwabo, gose enkoro yane tesanga ase omosangererekano obo; naki ase endamwamu yabo mbaitete abanto, na ase obomwenu bwabo bakanacha chinteng’e chie chintang’ana. ");
INSERT INTO guz_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Endamwamu yabo eragererigwe, ekiagera nigo yareenge entindi, na ekeririanda kiabo, ekiagera tikiareenge namaabera. Nimbaatanane ase abana ba Yakobo, nimbasiarere ase abana ba Israeli. ");
INSERT INTO guz_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Aye Yuda, abamino inabagotogie; okoboko kwao inakobwate ebigoti biababisa bao; abamura ba iso ng’a batugame bosio bwao na amasikani. ");
INSERT INTO guz_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, aye nendo ensae. Omwana one, gokorwa gotwara, nigo oratiire, na korara, na gotimoka buna endo, buna endo eaberi, ning’o orabe noboremu kogotura? ");
INSERT INTO guz_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Enyimbo y’obogaambi tekorua o Yuda, gose omobeeki amachiiko ase ororeeria rwaye, goika achiche oyo orabogorie obogaambi, oyo abanto b’ebisaku bionsi baraigwere. ");
INSERT INTO guz_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nigo arasibe etigere yaye ase omote bw’omosabibu, na emori y’etigere yaye ase chinsagia chi’omosabibu omuya. Nigo arasibie egetambaa kiaye akwambara nedivai, ne chianga chiaye n’amaache amonyinga y’amasabibu ");
INSERT INTO guz_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Amaiso aye nigo arabe amabariri ase okonywa edivai, na amaino aye abe amarabu ase okonywa amabeere. ");
INSERT INTO guz_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sabuloni nigo aramenye ase enyancha mbarabare, agwo ase chimeeri chigotenenigwa, orobebe rwaye rosinyane norw’Abasidoni. ");
INSERT INTO guz_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakaru netigere ere ne chinguru, ekorara obweri bwe chitugo. ");
INSERT INTO guz_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Akarora ng’a aase agotimokera naagiya, na ense eria nero ekomogwenera. Ase igo, agekumba abogorie egurube, akerua kogenderera nemeremo emekong’u. ");
INSERT INTO guz_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani nagambere abanto baye, buna egesaku ekemo ki’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani nabe eng’iti ekweriba inchera, ring’ere ase oboeto, rikoroma egetingiro ki’ebarasi, goika oyoyeriinete agwe masogota. ");
INSERT INTO guz_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Aye Omonene, ninganyete ogotooreka kwao nogosemeria! ");
INSERT INTO guz_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi namigwe nemeganda y’abauri, korende nere nabamige korwa magega. ");
INSERT INTO guz_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aseri natware endagera y’obonoru, narue endagera engiya eragwenere abarwoti. ");
INSERT INTO guz_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutali nengabi esiboire ekominyoka mono, nigo ekobiara chimanwa chingiya. ");
INSERT INTO guz_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusufu nomote omorere okwama ang’e nensoko; chinsagia chiaye nigo chikoranda enyasi igoro. ");
INSERT INTO guz_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Abaruti emegwe bakomoimokera ase okomogwera n’bororo, bakomoruta emegwe na komoorosia, ");
INSERT INTO guz_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","korende obota bwaye tibogosukigwa. Amaboko aye nigo are ne chinguru, naende namaango, goetera ase amaboko ’Omonyene Chinguru o Yakobo, oyore Omorisia na Egetare gia Israeli. ");
INSERT INTO guz_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nyasae o iso, nere oragokonye, Nyasae Omobui, nere oragosesenie nogosesenigwa gokorwa igoro, na ogosesenigwa gokorwa chindiba inse, na ogosesenigwa gokorwa inda na ase chimbeere. ");
INSERT INTO guz_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ogosesenigwa gwa iso nkore ne chinguru ngoetanetie okw’ebitunwa bia kare, na obonene bw’ebigoro bia kare na kare. Ogosesenigwa okwo kobe egutwa ase omotwe o Yusufu, igoro y’egiototeri ki’oyore omogambi ase egati y’abamwabo. ");
INSERT INTO guz_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini n’eseese y’orosana ekoria mono, engaki ya mambia yaria ebi’obotwari bwaye, na engaki ya mogoroba bwatanana ebiasakoire.” ");
INSERT INTO guz_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ebi nabio ebisaku bia Israeli ikomi na bibere; naya naro ise abateebetie ekero are kobasesenia na koa kera oyomo ogosesenigwa kwaye. ");
INSERT INTO guz_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Erio Israeli akabachiika, akabora: “Inche nkoirwa inde gosangererekana amo nabaanto baane. Montindeke ase chisokoro chiane chiatindegetwe ase rikuruma ri’oboremo bware bw’Efuroni Omohiti, ");
INSERT INTO guz_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","rikuruma eri rire ase oboremo agwo Makipela, moocha ya Mamure, ase ense ya Kaanani. Oboremo boria Aburaamu agorete korwa ase Efuroni Omohiti bobe aase ogotindeka. ");
INSERT INTO guz_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Agwo nao Aburaamu atindegetwe ase Sara mokaye ensemo; agwo nao Isaka na Rebeka mokaye batindegetwe, na agwo inche omonyene natindegete Lea. ");
INSERT INTO guz_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Oboremo obwo amo ne rikuruma riria nigo biagoretwe korwa ase Abahiti.” ");
INSERT INTO guz_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ekero Yakobo akoorete gochiika abamura baye amang’ana aya, akaimokia amagoro aye, akayabeeka borere igoro; erio agakwa, erio agasangererekana amo nabaanto baye. ");
INSERT INTO guz_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Erio Yusufu akagwera ise ase obosio bwaye, akarera na komonyunyunta. ");
INSERT INTO guz_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Agachiika abarwaria abaare komokorera, ng’a baake Israeli ise amafuta, tabaisa kogunda; naboigo abarwaria bamokorerete, ");
INSERT INTO guz_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","goika amatuko emerongo ene agaikerana. Ase amatuko ang’ana buna ayio naro egetondo kiare goakwa amariogo. Abamisiri bakamoreera Israeli amatuko emerongo etano na ebere. ");
INSERT INTO guz_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ekero amatuko okomoreera Israeli aerete, Yusufu agakwana nabaanto b’enka ya Farao, akabora: “Onye nkonyora ogwancherwa ase amaiso aino, komoranche monteeberie Farao ");
INSERT INTO guz_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ng’a tata nandierete omwando ogoteeba: Ng’ang’e inde gokwa, ong’ire ontindeke ase oboina boria naremete ase ense ya Kaanani. Momonsabere ribaga ngende gotindeka tata, erio ning’irane.” ");
INSERT INTO guz_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao akairaneria: “Tiira ochie gotindeka iso, buna akorierete omwando.” ");
INSERT INTO guz_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Erio Yusufu agatiira gochia gotindeka ise. Abasomba bonsi ba Farao bakagenda amo nere, na abagaaka bonsi b’enka yaye, na abagaaka bonsi ba Misiri, ");
INSERT INTO guz_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","na bonsi ab’enka ya Yusufu, amo nabamwabo, na ab’enka ya ise. Abana babo boka bagatigara Goseni amo ne ching’ondi ne chiombe chiabo. ");
INSERT INTO guz_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Naende Yusufu akaira amo nere chigari na abariini chibarasi; bakaba omoganda omonene mono. ");
INSERT INTO guz_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ekero baigete ase ekeooreri gi’Atadi ng’umbu y’orooche rwa Yorodani, bakaba bakorera ebirero ebinene mono. Agwo Yusufu akagenderera komoreera ise ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Na Abakaanani abamenyete ase ense eria, ekero bachia korora ebirero agwo Atadi ase ekeooreri, bakaboora: “Ebirero ebi bi’Abamisiri nebinene mono.” Ase ayio, aase aria ng’umbu ya Yorodani akarokwa Abeli‐Misiri. ");
INSERT INTO guz_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Naboigo basinto ba Yakobo bakorete buna ise abachiigete. ");
INSERT INTO guz_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bakamoimokia, bakamoira goika ase ense ya Kaanani. Erio bakamotindeka ase rikuruma riria riare, ase oboremo agwo Makipela, moocha ya Mamure, oboremo boria Aburaamu agorete korwa ase Efuroni Omohiti abe aase aye agotindeka abakuure. ");
INSERT INTO guz_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu, ekero akoorire gotindeka ise, akairana Misiri amo nabamwabo na bonsi abatiirete amo nere. ");
INSERT INTO guz_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ekero abamwabo Yusufu barooche ng’a ise okuure bagateebania. “Aande Yusufu nigo aratorege, arusie egesiomba ase amabe aria twamokorerete.” ");
INSERT INTO guz_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ase ayio bagatoma abanto ase Yusufu komoteebia ng’a: “Iso nigo ateebete iga ritang’ani atarakwa. ");
INSERT INTO guz_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Moteebie Yusufu iga: Nagosabire obaabere abamino amamocho abo na ebibe biabo bagokorerete. Nimanyete ng’a mbagokorerete bobe. Ase igo, bono twagosabire, otwabere ebibe biaito, naki intwe nabasomba ba Nyasae o iso.” Yusufu akarera ekero abamwabo bamoboretie amang’ana ayio. ");
INSERT INTO guz_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Erio abamwabo bagacha, bagatung’ama inse ase obosio bwaye, bakaboora: “Intwe iga nabasomba bao tore.” ");
INSERT INTO guz_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Korende Yusufu akabateebia: “Timoiroka! Inee! Inche inde ribaga ria Nyasae? ");
INSERT INTO guz_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ekeene, inwe nabo mwarengereretie gonkorera amabe, korende Nyasae akayaonchora akaba amaya, na buna mwarorire reero iga, otooririe obogima bw’abaanto abange. ");
INSERT INTO guz_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Gaki, bono timoiroka! Nimbaragerie inwe amo nabana baino.” Naboigo akaba okobaremia, agakwana nabarabwo amang’ana amaya. ");
INSERT INTO guz_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu akamenya Misiri, ere amo nabaanto bamwabo, agakoora emiaka rigana erimo, na ikomi (110). ");
INSERT INTO guz_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Agwo akarora abana b’Efraimu na abachokoro baye goika ekiaare kia gatato, akarora na abana ba Makiri, omwana o Manase, baiboreretwe ase Yusufu. ");
INSERT INTO guz_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusufu agateebia abamwabo: “Ng’ang’e inde gokwa, korende amaene Nyasae nabanyorere enchera y’okobarusia ase ense eye, abatiirie mogende ase ense eria abarierete eira na gotiana, ng’a nae Aburaamu, na Isaka, na Yakobo.” ");
INSERT INTO guz_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusufu agatiania abana ba Israeli agwo, akabora: “Bono, ekero Nyasae arabachere abakoonye, goika moire amauga aane; mogende naro.” ");
INSERT INTO guz_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Erio Yusufu erio agakwa ore n’emiaka rigana erimo na ikomi (110). Bakamoaka amafuta, tabaisa kogunda, bakamobeeka ase esanduki ime aaria Misiri.");
INSERT INTO guz_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Aya naro amarieta y’abamura ba Israeli abasoete Misiri amo na Yakobo ise, kera oyomo amo nabaanto b’enyomba yaye: ");
INSERT INTO guz_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, Simioni, Lawi na Yuda; ");
INSERT INTO guz_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakaru na Sabuloni, na Benjamini; ");
INSERT INTO guz_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani na Nafutali, Gadi na Aseri. ");
INSERT INTO guz_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Abanto bonsi abaiboire korwa ase Yakobo nigo barenge emerongo etano na ebere. Yusufu momura o Yakobo ere konya nao amenyete Misiri korwa kare. ");
INSERT INTO guz_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Korende Yusufu, na bamura bamwabo bonsi, na abanto bonsi b’ekegori keria bagakwera Misiri. ");
INSERT INTO guz_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Abaisraeli bakaba abegenwa ase Nyasae erio bagasarara na komenteka, bagatwara chinguru chinene, bakaba abange na obonge bwabo bokabucha kegima ase ense eria. ");
INSERT INTO guz_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Erio Omorwoti omoyia, oyotamomanyete Yusufu, akaira obogambi bw’ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ere agateebia abanto baye, “Rigereria, Abaisraeli aba babeire abange gotobua, naende babeire ne chinguru gotobua, ");
INSERT INTO guz_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","goika torigie chisemi tobatenenie, tibagenderera komenteka, ekiagera toise gochaka esegi, barabwo nigo barabwatane nababisa baito batorwanie, erio bang’anye korwa ense yaito.” ");
INSERT INTO guz_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ase ayio Abamisiri bakabeeka abateneneri abatindi igoro ase Abaisraeli barenge erio baabachande nemeremo emekong’u mono yobosomba. Agwo Abaisraeli bakaagachera Farao emechie y’okogaacha chinibo, nero Pitoni na Ramesesi. ");
INSERT INTO guz_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Korende buna Abamisiri bagendererete kobachanda mono, naboigo Abaisraeli bagendererete komenteka na gwesiarera, goika Abamisiri bakabairoka mono. ");
INSERT INTO guz_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Erio Abamisiri bakaba abatindi ase Abaisraeli na kobabetereria gokora emeremo emekong’u ");
INSERT INTO guz_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","bagakora obogima bwabo bokaba obokong’u ase okobakoria emeremo y’ogotiringa esike na koroisia amatabori, na emeremo ende ao ao ase emegondo. Ase emeremo ende yonsi Abaisraeli baare gokora nigo baare gokorigwa ase obotindi. ");
INSERT INTO guz_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Omorwoti o Misiri agachiika Sifura na Pua, abaiboria b’Abaiberania, akabateebia, ");
INSERT INTO guz_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ekero mokorigereria abakungu b’Abaiberania kobakoibora, morigererie mwana ki oiborwa; onye nomoisia, momoite, korende karabe omoiseke, momotige abe moyo.” ");
INSERT INTO guz_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Korende abaiboria baria nigo bamoirogete Nyasae, tibakorete buna omorwoti o Misiri abateebeetie, korende barabwo bagatiga abana abamura bakaba moyo. ");
INSERT INTO guz_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Erio Omorwoti o Misiri akarangeria abaiboria baria, akababoria, “Nase ki mwakorire iga Mwatigire abana abaisia bakoiborwa bare moyo.”? ");
INSERT INTO guz_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Abaiboria baria bakairaneria Farao, “Abakungu b’Abaiberania tibari buna aba Abamisiri; barabwo nabaango ase okoibora, nigo bakoibora ritang’ani omoiboria ataraika.” ");
INSERT INTO guz_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nyasae agakorera abaiboria baria amaya, na Abaisraeli bakagenderera komenteka na koba ne chinguru mono. ");
INSERT INTO guz_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Na ekiagera abakungu baria abaiboria bamoirogete Nyasae, ere akabasesenia, na barabwo bakenyorera chinyomba chiabo. ");
INSERT INTO guz_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Erio Farao agachiika abanto baye bonsi, akabateebia, “Kera omwana omoisia oraiborwe ase Abaiberania, momotugute ase orooche rwa Naeli, korende kera omwana omoiseke momotige abe moyo.” ");
INSERT INTO guz_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Narengeo Omonto oyomo bw’egekasu kia Lawi akamonyuoma omoiseke korwa egesaku kia Lawi. ");
INSERT INTO guz_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Omokungu oyio akaba morito, akaibora omwana omoisia, na ekero aroche ng’a omwana oria nomuya mono, akamobisa ase engaki y’emetienyi etato. ");
INSERT INTO guz_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Korende ekero aroche ng’a takonyara komobisa goetania agwo, akaimokia ekebaari ki’amauncho, agakeooma esike, erio agaaka eramu korwa isiko. Erio akaareria omwana oria ase ekebaari ime, agakebeeka ase amauncho ime y’orooche rwa Naeli. ");
INSERT INTO guz_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Omoiseke omwabo omwana oria agatenena aare ake amanye egekonyora omwana. ");
INSERT INTO guz_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Erio omoiseke o Farao agatirimboka gochia Naeli rooche gwesibia, na abasomba baye abaiseke bakaba bakona goonchokanana ase engegu. Ekero aroche ekebaari keria ase amauncho, agatoma omoiseke oyomo akerente; ");
INSERT INTO guz_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","agakemumora, akanyora omwana omoke ore imeo. Omwana oria akarera, na omoiseke o Farao akamororera amabeebe, agakwana, “Oyoiga noyomo bw’abana b’Abaiberania.” ");
INSERT INTO guz_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Agwo agwo Omoiseke omwabo omwana oria akaoroka akaboria omoiseke o Farao, “Inee! Norigetie ngende nkorangererie omokungu okogonkia oyomo bw’Abaiberania ache gokomogonkeria?” ");
INSERT INTO guz_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Omoiseke o Farao akamoiraneria, “Ee, genda!” Erio akagenda, akarangeria ng’ina omwana oria. ");
INSERT INTO guz_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Omoiseke o Farao agateebia omokungu oria, “Moire omwana oyo, omongonkerie, na inche ninkoe eng’eria yao.” Erio omokungu oria akaira omwana, akamorera. ");
INSERT INTO guz_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ekero omwana oria akinire, omokungu oria akamoirania ase omoiseke o Farao koba omwana oye na ere akamoroka Musa, ogoteeba, “Ndooche namorusetie.” ");
INSERT INTO guz_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Egachia koba ekero Musa abeire omonto omonene, rituko erimo akagenda gokwania Abaiberania bamwabo, akarora buna baare gokorigwa emeremo yobosomba emekong’u. Agwo akarora Omomisiri ogoita oyomo bw’Abaiberania bamwabo. ");
INSERT INTO guz_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Erio akamaga‐maga chinsemo chionsi, na ekero arora ng’a monto onde tari aande, agaita Omomisiri oria agakwa, erio akabisa omobere oye ase omokenye ime. ");
INSERT INTO guz_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Naende akagenda rituko ria kabere, akarora Abaiberania babere abasacha bakorwana; akamobooria oria ochegetie oyomwabo, “Nase ki ogoaka oyomino?” ");
INSERT INTO guz_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Omonto oria akamoiraneria, “Ning’o okobegete koba omoteneneri na omogayani igoro yaito? Inee! Nigo origetie kong’ita buna gwaita Omomisiri oria?” Aya akagera Musa akoboa. Ere agateeba ase omoyo oye ime, “Ndoche ng’a eng’ana eye yamanyekanire!” ");
INSERT INTO guz_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ekero Farao achia koigwa amang’ana ayio akarigia goita Musa, korende Musa agatama korwa o Farao akagenda komenya ase ense y’Abamidiani. ");
INSERT INTO guz_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Narengeo Omokuani o Midiani ore korokwa Jethiro obwate abaiseke batano na babere. Barabwo bagacha kobuucha amaache; bagaichoria chintuba amaache banyoisie riicho ria ise. ");
INSERT INTO guz_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Erio abarisia b’aroro bagacha bagaseria abaiseke baria ba Jethiro, korende Musa agatenena agakonya abaiseke baria na kobanyoiseria riicho riabo. ");
INSERT INTO guz_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ekero abaiseke baria bairanete ase ise, ere akababoria, “Nakimwakora reero mwairana bwango iga?” ");
INSERT INTO guz_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bakamoiraneria, “Omomisiri oyomo otokonya korwa ase abarisia baria; amo nayio otobuuchera amaache na gotonyoiseria riicho riaito.” ");
INSERT INTO guz_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Erio ise akababoria abaiseke baye, “Ng’ai are? Naki mwakora mwatiga omonto oyio? Gachie momorangerie ache koragera.” ");
INSERT INTO guz_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa agancha komenya bw’omonto oria na omonto oria akaa Musa Sipora, omoiseke oye, akaba mokaye. ");
INSERT INTO guz_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Omokungu oyio akamoiborera omwana omoisia, na Musa akamoroka Gerisomu, ogoteeba, “Nabeire omomenyi ase ense engeni.” ");
INSERT INTO guz_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Magega y’engaki entambe koyaetire omorwoti o Misiri agakwa. Abaisraeli bakaba bakweumia inse y’obosomba obwo, bakarera bakonywe, na ekerero kiabo korwa ase obosomba kegaika igoro, ase Nyasae obo. ");
INSERT INTO guz_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nyasae akaigwa ekerero kiabo, na akainyora okobwatana kwaye kw’ogotianania, okwo akorete na Aburaamu, na Isaka, na Yakobo; ");
INSERT INTO guz_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nyasae akarigereria ogochandeka kw’Abaisraeli ase obosomba erio akabainyora. ");
INSERT INTO guz_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa nigo arenge omorisia bwe riicho, rituko erimo gakorisia riicho ria Jethiro oyio orenge ise biara na Omokuani o Midiani, akariraa gochia bosongo y’erooro, agaika magega ya Horebu, egetunwa egechenu. ");
INSERT INTO guz_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Agwo omomalaika bw’Omonene akamoorokera ase omogwekano bw’erisase ri’omorero riare gwoka korwa ase obogatagati bw’egetutu gete. Musa akarigereria, akarora ng’a nonya kiare gwoka, tikiare koyia keere. ");
INSERT INTO guz_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Erio Musa agateeba, “Nigo ’ngoeta korwa moino ’ndore okorora oko kw’ogokumia, imanye naki egetutu eke getari koyia keere.” ");
INSERT INTO guz_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ekero Omonene arooche ng’a Musa oikire ang’e arore, akamorangeria korwa ase egetutu ime, “Musa! Musa!” Musa agaitaba ogoteeba, “Nao inde aa.” ");
INSERT INTO guz_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nyasae akamoteebia, “Tobaisa goika ang’e nonya ng’ake. Rusia ebikoroto biao, ekiagera aase agwo oteneine naachenu.” ");
INSERT INTO guz_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Naende akamoteebia, “Inche ninche Nyasae bwe chisokoro chiao, Nyasae o Aburaamu, Nyasae o Isaka, na Nyasae o Yakobo.” Erio Musa agatuba obosio bwaye, ekiagera nigo airogete komorigereria Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Eri’Omonene akabora, “Amaene narorire emechando yabaanto baane abwo bakare Misiri; naigure buna bakweumia inse yamaboko y’Abamisiri abwo bakobachanda, na inche namanyire kegima obororo bwabo. ");
INSERT INTO guz_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Nainche nigo naikire inse mbatoorie korwa ase amaboko ya Abamisiri, mbatiirie korwa ase ense eria ya Misiri, mbaire ase ense engiya engare, ense eichire namabeere nobooke, ense ya Abakanaani, na Abahiti, na Abaamori, na Abaperisi, na Abahivi, na Abayebusi bono genda. ");
INSERT INTO guz_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nainde bono ekerero ki’Abaisraeli giaikire ase ’nde, naende narorire ogochandwa koria Abamisiri bakobachanda, ");
INSERT INTO guz_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ase ayio, ’ngogotoma inde ogende ase Farao orusie abanto baane Abaisraeli korwa ense ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Korende Musa akamoteebia Nyasae, “Inche ninche ng’o, kogenda ase Farao ’ndusie Abaisraeli korwa ense ya Misiri?” ");
INSERT INTO guz_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nyasae akamoiraneria, “Inche nimbe amo naye. Aye noruisie Abaisraeli korwa Misiri erio moche monsasime inche Nyasae ase egetunwa eke, na eke nakio kerabe ekemanyererio asore ng’a ninche omonyene nagotoma.” ");
INSERT INTO guz_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Erio Musa agateebia Nyasae, “Kondaimoke kogenda ase Abaisraeli na kobateebia: Nyasae bwe chisokoro chiaino ontomire inche ase more, barabwo baramboria: Erieta riaye, nere ng’o? Inki ndabateebie?” ");
INSERT INTO guz_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nyasae akamoiraneria Musa, “INCHE NINCHE INDE BUNA INDE. Obateebie Abaisraeli buna oria okorokwa: INCHE ontomire ase more.” ");
INSERT INTO guz_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Naende Nyasae akamoteebia Musa, “Goika obateebie Abaisraeli: Omonene bwe chisokoro chiaino, Nyasae o Aburaamu, Nyasae o Isaka, na boigo Nyasae o Yakobo ontomire ase more; erio nario erieta riane kare na kare; ase erio nigo ’ndabe ekeinyorio ekiare ase ekiare. ");
INSERT INTO guz_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Genda, osangererie abagaaka b’Abaisraeli, obateebie ng’a: Omonene bwe chisokoro chiaino, Nyasae o Aburaamu, na o Isaka, na o Yakobo nang’orokera, aganteebia ng’a mbateebie: Amaene, narorire aya Abamisiri bakobakorera, ");
INSERT INTO guz_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","na igo narire eira ng’a nimbang’anyie korwa Misiri ase mogochandwa, na kobaira ase ense y’Abakaanani, na Abahiti, na Abaamori, na Abaperisi, na Abahivi, na Abayebusi, ense entenenku egoiteka amabeere na obooke. ");
INSERT INTO guz_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Na abagaaka b’Abaisraeli inabaigwe amang’ana ao. Erio mogende, aye na abagaaka ba Abaisraeli, ase omorwoti o Misiri, momoteebie: Nyasae bw’Abaiberania, natoorokera; na bono twanchere togende orogendo rw’amatuko atato gochia ase erooro, erio toruere Omonene oito, ekeng’wanso. ");
INSERT INTO guz_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Korende inche omonyene nimanyete ng’a omorwoti o Misiri takobaa ribaga mogende atabeetereirie nokoboko kwane gwe chinguru. ");
INSERT INTO guz_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Erio inche nindambore okoboko kwane, ng’ake Abamisiri namaakwa aane yogokumia. Erio magega Omorwoti nabae ribaga mogende. ");
INSERT INTO guz_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Nimbae abanto baane ogwancherwa ase obosio bw’Abamisiri; ekero moragende, timokogenda more namaboko amasa. ");
INSERT INTO guz_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kera omokungu asabe omogisangio oye, na omokungu onde bwensi omenyete nyomba mwaye, ebinto bie chifeta na ebie chitaabu amo ne chianga; mobibekere abana baino, abamura na abaiseke. Ase enchera eyio nero morasakore Abamisiri chinibo chiabo.” ");
INSERT INTO guz_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Erio Musa akamoiraneria Nyasae akamoteebia, “Eraba rende ng’a agwo tibanyegeti, gose koigwa eriogi riaane, barabwo nigo baratebe: Omonene takoorokereti.” ");
INSERT INTO guz_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Omonene akamobooria, “Inki ekio obwate koboko kwao?” Musa akairaneria, “Nenyimbo.” ");
INSERT INTO guz_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Omonene akamoteebia, “Yerute inse!” Na ekero Musa ayeruta inse, ekaonchoka ekaba eng’iti, na Musa agatama korwa asere. ");
INSERT INTO guz_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Eri’Omonene akamoteebia Musa, “Rambora okoboko kwao, oyebwate ekemincha.” Erio ere akarambora okoboko kwaye, akayebwata, na ase okoboko kwaye ekaonchoka, ekaba enyimbo naende. ");
INSERT INTO guz_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Na Omonene akamoteebia, “Okore igo, na barabwo inabegene ng’a inche Omonene, Nyasae bwe chisokoro chiabo, Nyasae o Aburaamu, na o Isaka, na o Yakobo nakoorokera.” ");
INSERT INTO guz_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Naende Omonene akamoteebia, “Soyia okoboko kwao eanga yao ime ase egekuba kiao.” Musa agakora boigo; na ekero akorusetie akanyora ng’a kwabeire okorabu se ase buna okwo omorwaire bwa ukoma. ");
INSERT INTO guz_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Naende Omonene akamoteebia, “Irania okoboko kwao eanga ime ase egekuba kiao.” Musa agakora bo, na ekero akorusetie akanyora ng’a kwabeire buya, buna koreng’ana omobere oye onde ore. ");
INSERT INTO guz_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Omonene akamoteebia, “Onye tibakwegena amang’ana ao, gose tibagwancha ase egekone kie ritang’ani, rirorio mbanche ase egia kabere. ");
INSERT INTO guz_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Onye tibakwegena nonya nase ebikone ebio bibere, gose gwancha amang’ana ao, rirorio obuuche amaache make korwa ase orooche rwa Naeli, oyaitere ase ense enyomo; amaache ayio orabuuche korwa ase orooche naonchoke abe amanyinga ase ense enyomo.” ");
INSERT INTO guz_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Erio Musa agateebia Omonene, “Koranche, Omonene one, inche tindi Omokuani omuya, nonya nkorwa kare, gose korwa riria gwachaagete gokwana nainche, omosomba oo. Oromeme rwane nororito na nigo ingotutura.” ");
INSERT INTO guz_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Omonene akamoiraneria, “Ning’o okoa Mwanyabaanto omonwa bw’ogokwana? Ning’o omokorete abe rimama, gose omotino, gose abe okorora, gose koba omouko? Inee! Tari inche Omonene? ");
INSERT INTO guz_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Bono genda! Nainche omonyene nimbe naye naende ninkoe amang’ana ogochia gokwana nomonwa oo na gokworokereria aya ogochia goteeba.” ");
INSERT INTO guz_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Korende Musa akamoiraneria, “Omonene, koranche, toma monto onde bwensi oranche.” ");
INSERT INTO guz_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Eri’Omonene akaba nendamwamu ekoberoroka ase Musa, akamoteebia, “Inee! Aroni momura omino, oria Omolawi, takaiyo? Nimanyete ng’a ere nere omonto omanyete gokwana buya. Naama! Ngocha are gokorotota; ere ekero arakorore nasasoke ase enkoro yaye. ");
INSERT INTO guz_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Aye nokwane nere, omoteebie aya agochia gokwana. Inche nimbae inwe babere amang’ana mogochia gokwana, boigo nimbaorokererie aya mogochi gokora. ");
INSERT INTO guz_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Nere orabe ogokwana nabaanto ribaga riao; ere abe Omokuani oo, na aye obe Enyasae asare ere. ");
INSERT INTO guz_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Aye obogorie enyimbo eyio koboko kwao, nero orakorere ebikone.” ");
INSERT INTO guz_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa akairana gochia ase Jethiro, ise biara, akamoteebia, “Koranche, tiga ing’irane gochia Misiri korora abaminto gose moyo bare.” Jethiro akamoteebia, “Ee, genda nomorembe.” ");
INSERT INTO guz_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ekero Musa konya atararwa aaria Midiani, Omonene akamoteebia, “Irana gochia Misiri, ekiagera baria bonsi barigetie obogima bwao bakuure.” ");
INSERT INTO guz_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa akaimokia mokaye na abana baye, akabariinia etigere igoro, na barabwo bakairana gochia ase ense ya Misiri. Ere akabogoria enyimbo ya Nyasae koboko kwaye. ");
INSERT INTO guz_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Eri’Omonene agateebia Musa, “Bono ekero orabe gokoirana Misiri, origererie buya ng’a nokore ase obosio bwa Farao amakumia onsi aya nakoeire okobua gw’okoyakora. Korende ninkong’ie enkoro yaye, na ere tagotiga abanto bagende. ");
INSERT INTO guz_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Erio omoteebie Farao: Aya nar’Omonene agoteeba: Abaisraeli nomwana one omotangi. ");
INSERT INTO guz_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Inche nagotebirie: Moe omwana one ribaga agende gonsasiima korende koraange, rirorio nigo ndaite omwana oo omotangi.” ");
INSERT INTO guz_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kobare nchera kogenda, Omonene akaumerana na Musa aase baare gotimokera, akarigia komoita. ");
INSERT INTO guz_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Erio Sipora akaimokia rigena riare erioge, agasara omwana oye risankwa ria isiko ri’ekiimo kiaye ki’obosacha akarikunia amagoro a Musa, akabora, “Amaene, nigo ore omonywomi one bw’amanyinga.” ");
INSERT INTO guz_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Agw’Omonene agatiga Musa, tamoita. Erio omokungu oyio agateeba, “Omonyuomi bw’amanyinga ase engencho y’okwaroka.” ");
INSERT INTO guz_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Omonene agateebia Aroni, “Genda gochia ase erooro orotote Musa.” Erio Aroni akagenda, akaumerana na Musa ase egetunwa kia Nyasae, akamonyunyunta. ");
INSERT INTO guz_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa agateebia Aroni amang’ana onsi Omonene amotebetie, na igoro y’ebikone bionsi amochigeete akore. ");
INSERT INTO guz_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Erio Musa na Aroni bakagenda, bagasangereria abagaaka bonsi b’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aroni akabateebia amang’ana onsi Omonene atebeetie Musa, na ere agakora ebikone biria maiso marore ase obosio bw’abaanto. ");
INSERT INTO guz_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Erio abanto bakwegena; na ekero baigwete ng’a Omonene bwechandeire Abaisraeli, na ororire emechando yabo, barabwo bagatung’ama inse, bakamosasiima. ");
INSERT INTO guz_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Erio Musa na Aroni bakagenda ase Farao, bakamoteebia, “Aya nar’Omonene, Nyasae bw’Abaisraeli, agoteeba: Kae abanto baane ribaga basoe ase orogendo gochia gonkorera omoyega bwe Rituko Rinene aaria ase erooro.” ");
INSERT INTO guz_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao akairaneria, “Omonene nere ng’o inyigwe amang’ana aye, na koa Abaisraeli ribaga bagende? Inche timomanyeti Omonene, gose tinkoa Abaisraeli ribaga bagende.” ");
INSERT INTO guz_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Erio Musa na Aroni bakamoteebia, “Nyasae bw’Abaiberania natoorokera. Koranche, otoe ribaga togende orogendo rw’amatuko atato gochia ase erooro, erinde tomoruere Omonene, Nyasae oito, ebing’wanso, tabaisa gocha gotoita namarwaire gose nemioro.” ");
INSERT INTO guz_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Omorwoti o Misiri akabairaneria, “Musa na Aroni, nase ki mogotenenia abanto korwa ase emeremo yabo? Irana gochia ase emeremo yaino y’obosomba.” ");
INSERT INTO guz_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Naende Farao akabora, “Abanto aba babeire abange kobua abanyene ense eye. Naende morigetie kobarusia ase emeremo yabo yobosomba.” ");
INSERT INTO guz_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ase rituko erio erio Farao agachiika abwo abachandi amo nabateneneri, akabateebia, ");
INSERT INTO guz_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Timoa abanto aba naende chimboba ase okoroisia amatabori, buna mware kobaa agwo ritang’ani. Tiga bagende barabwo boka kwerigeria chimboba. ");
INSERT INTO guz_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Korende mobabetererie baroisie omobaro bw’amatabori oyo baare gokora ritang’ani, batari koyokeyia. Barabwo tibari nemeremo ebaisaine. Nakio gekogera bakona‐koboria ng’a: Toe ribaga togende koruera Nyasae oito ekeng’wanso. ");
INSERT INTO guz_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Bae abanto abwo emeremo emerito mono, kegima baisaneke nero, na tibanyora ribaga riogotegerera amang’ana ’oborimo.” ");
INSERT INTO guz_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Abachandi abwo na abateneneri bagasoka bagateebia Abaisraeli, “Farao oteebire iga: Tinkobaa inwe chimboba naende. ");
INSERT INTO guz_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Genda inwe mweka mwerigerie chimboba aande onsi morachinyore; korende goika moroisie omobaro bw’amatabori oria o botambe, kende nkeiyo nonya negeke kegokeigwa korwa ase ekerengo kie emeremo yaino ya kera rituko.” ");
INSERT INTO guz_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Erio Abaisraeli bagesiarera ase ense yonsi ya Misiri na kwerigeria obonyansi ribaga rie chimboba. ");
INSERT INTO guz_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Abachandi baria bakagenderera kobabetereria, bagoteeba, “Goika moroisie kera rituko ekerengo kia amatabori buna konya mokoroisia ekero mware korenterwa chimboba.” ");
INSERT INTO guz_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Abachandi abwo babekire na Farao bakaba bagoaka abateneneri b’Abaisraeli, abwo babegetwe gotenenera emeremo, bakabateebia, “Naki motaikeranetie omobaro oino bw’amatabori igoro na reero, oyio konya mokoroisia botambe?” ");
INSERT INTO guz_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Erio abateneneri b’Abaisraeli bakagenda ase Farao, bagateeba, “Inki ogotokorera abasomba bao iga? ");
INSERT INTO guz_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Chimboba titori koegwa, korende nigo tokona‐kobetererigwa ng’a toroisie amatabori. Na bono, abasomba bao, nigo bakona‐goakwa; korende okomocha nokw’abaanto bao.” ");
INSERT INTO guz_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farao akabairaneria, “Inwe naboro mono. Nigo mobarachete nakio gekogera mogoteeba ng’a: Toe ribaga togende toruere Omonene ekeng’wanso. ");
INSERT INTO guz_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Irana gochia ase emeremo yaino. Timokorenterwa chimboba, korende goika moroisie ekerengo kia amatabori, keria mochikiire koroisia.” ");
INSERT INTO guz_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Abateneneri b’Abaisraeli bakarora ng’a basoire ase obokong’u ekiagera bateebetigwe ng’a, “Goika moikeranie kera rituko ekerengo keria kia amatabori.” ");
INSERT INTO guz_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ekero baare korua ase Farao, bakanyora Musa na Aroni agwo nchera baabaganyete, ");
INSERT INTO guz_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","bakabateebia, “Omonene abarigererie na konacha ekiina, ekiagera mwatokorire koba chindoso ase obosio bwa Farao na ase abasomba baye. Mwabaeire engencho yogotoita.” ");
INSERT INTO guz_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Erio Musa akairana gochia ase Omonene, akamoteebia, “Omonene, nase ki ogokorera abanto aba amabe buna aya? Inki rende gwantomera inche? ");
INSERT INTO guz_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Naki korwa riria nagendete ase Farao gokwana amang’ana ao omentire gokorera abanto bao bobe mono, na aye torakora kende ase okobatooria.” ");
INSERT INTO guz_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Eri’Omonene agateebia Musa, “Bono norore aya ndakorere Farao. Naki ase okoboko kwane gwe chinguru nimobetererie abae abanto baane ribaga bagende, ee, ase okoboko kwane gwe chinguru nabetererigwe abaserie korwa ase ense yaye.” ");
INSERT INTO guz_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nyasae agakwana na Musa, akamoteebia, “Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Naorokerete Aburaamu, na Isaka, na Yakobo buna Nyasae Omobui. Korende ase erieta riane Yahwe, gose Omonene, tinamanyekanete ase bare. ");
INSERT INTO guz_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Naende ninche nakorete okobwatana kw’ogotianania nabarabwo ng’a nimbae ense ya Kaanani, ense eria barenge buna abamenyi. ");
INSERT INTO guz_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Na bono naigure okwerera kw’Abaisraeli abwo Abamisiri babegete inse y’obosomba, naende ning’inyorete okobwatana koria kwane. ");
INSERT INTO guz_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ase igo oteebie Abaisraeli ng’a, Inche ninche Omonene, ndabarusie korwa ase emeremo emerito inse y’Abamisiri. Nimbatoorie korwa ase obosomba bwaino. Ase okoboko kwane koramboire, na goetera ase ebisusuro ebinene, nimbaboorie. ");
INSERT INTO guz_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nimbakore mobe abanto baane, na inche nimbe Nyasae oino. Inwe namomanye ng’a ninche Omonene, Nyasae oino, oyobarusirie korwa ase emeremo emerito inse y’Abamisiri. ");
INSERT INTO guz_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nimbaire goika ense eria nariete eira koa Aburaamu, na Isaka, na Yakobo. Nimbayee ebe omwando oino. Inche ninche Omonene.” ");
INSERT INTO guz_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa agateebia Abaisraeli amang’ana ayio, korende barabwo tibancha gotegerera, ekiagera konya emioyo yabo y akuure, ase engencho y’emeremo y’obosomba obotindi. ");
INSERT INTO guz_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Eri’Omonene agakwana na Musa akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Genda okwane na Farao, omorwoti o Misiri, omoteebie abae Abaisraeli ribaga bagende, barue ase ense yaye.” ");
INSERT INTO guz_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa agakwana n’Omonene, akamoteebia. “Rora Abaisraeli baangire konyigwera, naki rende Farao ere arakore anyigwere, inche omonto ntamanyeti gokwana.?” ");
INSERT INTO guz_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Korende Omonene agakwana na Musa na Aroni, akabachika bagende bateebie Abaisraeli na Farao, omorwoti o Misiri, ng’a batomirwe barusie Abaisraeli korwa ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Abanto aba nabwo barenge emetwe ye chiamate chiabo. Abana abamura ba Rubeni, omomura omotangi o Israeli, nabwo aba: Hanoki, na Palu, na Hezironi, na Karimi. Aba nabwo chiamate chia Rubeni. ");
INSERT INTO guz_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Abana abamura ba Simioni nabwo aba: Yemueli, na Yamini, na Ohadi, na Yakini, na Sohari, na Saulo, omwana bw’omokuungu Omokanani. Aba nabwo chiamate chia Simioni. ");
INSERT INTO guz_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Aya naro amarieta ’abamura ba Lawi, buna batunyaine ase okoiborwa kwabo: Gerisoni, na Kohati, na Merari. Lawi nigo akoorete emiaka rigana erimo, na emerongo etato, na etano na ebere (137). ");
INSERT INTO guz_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Abana abamura ba Gerisoni nabwo Libini na Simei, ne chiamate chiabo. ");
INSERT INTO guz_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Na abana abamura ba Kohati nabwo aba: Amuramu, na Isari, na Heburoni, na Usieli. Kohati nigo akoorete emiaka rigana erimo, na emerongo etato, na etato (133). ");
INSERT INTO guz_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Na abana abamura ba Merari nabwo Mali na Musi. Aba nabwo chiamate chia Lawi, buna batunyaine ase okoiborwa kwabo. ");
INSERT INTO guz_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amuramu akanyuoma Yokebedi, omoiseke omwabo ise; na ere akamoiborera Aroni na Musa. Amuramu nigo akoorete emiaka rigana erimo, na emerongo etato, na etano na ebere (137). ");
INSERT INTO guz_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Na abana abamura ba Isari nabwo aba: Kora, na Nefegi, na Sikiri. ");
INSERT INTO guz_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Na abana abamura ba Usieli nabwo aba: Mishaeli na Elisafani, na Sitiri. ");
INSERT INTO guz_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aroni akanyuoma Elisheba, omoiseke bw’Aminadabu, omoiseke omwabo Nashoni. Ere akamoiborera Nadabu, na Abihu, na Eleazari, na Itamari. ");
INSERT INTO guz_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Na abana abamura ba Kora nabwo aba: Asiri, na Elikana, na Abiasafu. Aba nabwo chiamate chia Kora. ");
INSERT INTO guz_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazari, omwana o Aroni, akanyuoma omoiseke oyomo bw’abaiseke ba Putieli, na ere akamoiborera Finehasi. Abanto aba nabwo barenge emetwe ye chinyomba chi’Abalawi, eamate ase eamate. ");
INSERT INTO guz_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aroni amo na Musa nabwo bari’Omonene atebeetie, “Barusie Abaisraeli ase ense ya Misiri, omoganda ase omoganda.” ");
INSERT INTO guz_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aba nabwo baria Musa na Aroni bateebeetie Farao ng’a barusie Abaisraeli korwa Misiri. ");
INSERT INTO guz_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Rituko riri’Omonene akwanete na Musa ase ense ya Misiri ");
INSERT INTO guz_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","akamoteebia, “Inche ninche Omonene. Otebie Farao, omorwoti o Misiri, amang’ana onsi nkogoteebia.” ");
INSERT INTO guz_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Korende Musa akairaneri’Omonene akamoteebia, “Inche nomonto ntamanyeti gokwana, naki rende Farao arakore anyigwere?” ");
INSERT INTO guz_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Omonene agateebia Musa, “Rora nagokorire obe buna Nyasae ase Farao, na Aroni akwane nere buna omobani oo. ");
INSERT INTO guz_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Aye oteebie oyomino Aroni ayio onsi nagochikiire, na ere akwane na Farao, amoteebie ng’a ae Abaisraeli ribaga barue ase ense yaye. ");
INSERT INTO guz_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Korende ninkong’ie enkoro ya Farao; nonya nabo ninkore ebikone ebinge na amakumia amange ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Korende Farao takobaigwa. Inche nindambore okoboko kwane igoro y’Abamisiri na kobaa ebisusuro ebinene, na nindusie emeganda yane, abanto baane Abaisraeli, korwa ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Erio Abamisiri mbamanye ng’a inche ninche Omonene, ekero ndarambore okoboko kwane ase barabwo na koruisia Abaisraeli korwa ase bare.” ");
INSERT INTO guz_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Aroni bagakora buna Omonene abachigete. ");
INSERT INTO guz_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ekero keria bakwanete na Farao, Musa nigo arenge nemiaka emerongo etano na etato (80), na Aroni emiaka emerongo etano na etato, na etato (83). ");
INSERT INTO guz_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Omonene agateebia Musa na Aroni, ");
INSERT INTO guz_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ekero Farao arababorie ng’a mokore egekone, erio aye Musa oteebie Aroni abogorie enyimbo yaye, ayerute inse bosio bwa Farao, na ero neonchoke ebe eng’iti.” ");
INSERT INTO guz_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa na Aroni bakagenda ase Farao, bagakora buna Omonene abachiigete. Aroni akaruta enyimbo yaye bosio bwa Farao na bw’abasomba baye, na ero ekaonchoka ekaba eng’iti. ");
INSERT INTO guz_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Erio Farao akarangeria abanto abanyasemi na abaragori, na abwo abaringoria ba Misiri bagakora boigo ase oborogi bwabo bwa bobisi. ");
INSERT INTO guz_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kera oyomo obo akaruta enyimbo yaye inse, na chirochio chikaonchoka, chikaba ching’iti; korende enyimbo ya Aroni ekamera chinyimbo chiabo. ");
INSERT INTO guz_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Enkoro ya Farao nigo yarenge enkong’u, na buna Omonene atebeete, taigwera Musa na Aroni. ");
INSERT INTO guz_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Omonene agateebia Musa, “Farao okong’irie enkoro yaye, bwangire koa abanto aba ribaga bagende. ");
INSERT INTO guz_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ase igo, genda oumerane na Farao ekero aragende rooche mambia, ogende otenene ase engegu, omoganye aroro. Enyimbo eria yaonchogete ekaba eng’iti, oyebogorie koboko kwao. ");
INSERT INTO guz_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Omoteebie ng’a: Omonene, Nyasae bw’Abaiberania, ontomire ngoteebie ng’a oe abanto baye ribaga bagende komokorera ase erooro. Naye goika bono toraigwa. ");
INSERT INTO guz_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ase ig’Omonene oteebire iga: Ase ring’ana eri ndakore, nario oramanye ng’a ninche Omonene. Rigereria, ning’ake amaache y’orooche rwa Naeli nenyimbo eye mbwate koboko kwane, na amaache aya naonchoke abe amanyinga. ");
INSERT INTO guz_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ne chinswe chire ase orooche ime inachikwe, chigunde, na orooche narotioke bobe, na Abamisiri nabasinywe konywa amaache aria.” ");
INSERT INTO guz_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Eri’Omonene agateebia Musa moteebie Aroni, aimokie enyimbo yaye, arambore okoboko kwaye igoro ase amaache onsi ay’Abamisiri, ase chindooche chiabo na ase ebirooche, ase amatibo onsi ne chinsoko. Amache ayio onsi aonchoke abe amanyinga. Naboigo amanyinga abe ase ense yonsi ya Misiri, nonya nase chintuba na ase chinyongo chionsi. ");
INSERT INTO guz_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Aroni bagakora buna Omonene abachigete. Ase obosio bwa Farao na abasomba baye, Aroni akaimokia enyimbo yaye, agaaka orooche, na amaache ayare imeo akaonchoka, akaba amanyinga. ");
INSERT INTO guz_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ne chinswe chiare ase orooche chigakwa, na orooche rokagunda na gotioka, na Abamisiri bagasinywa konywa amaache aria. Amanyinga akaba ase ense yonsi ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Erio abaringoria ba Misiri bagakora boigo ase oborogi bwabo. Farao akagenderera gokong’ia enkoro yaye, na buna Omonene konya atebiire, tabaigwa. ");
INSERT INTO guz_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Erio Farao akairana akogenda bwoye, amang’ana aria tayabeka ase omoyo oye. ");
INSERT INTO guz_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Abamisiri bonsi bagakunya‐kunya mbarabare y’orooche ase okorigia amaache bakonywa, ekiagera tibare konyara konywa amaache a rooche. ");
INSERT INTO guz_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Amatuko atano na abere akaera korwa riri’Omonene aagete orooche rwa Naeli. ");
INSERT INTO guz_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Eri’Omonene agateebia Musa, “Genda oteebie Farao: Aya nar’Omonene agoteeba: Bae abanto baane ribaga bagende gonkorera. ");
INSERT INTO guz_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Korende koraange kobaa ribaga bagende, rirorio inche ning’ake ense yao yonsi ase okorenta ebioto. ");
INSERT INTO guz_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Orooche rwa Naeli naroichorwe nebioto, na birobio nabitiire korwa aroro, nabisoe nyomba mwao, na enyomba yao y’okorara, amo noborere bwao; nabisoe ne chinyomba chi’abasomba bao na echi’abaanto bao, ase amariiko ao ase okogeekera emegati, na ase ebituba biao bi’ooboseemiara obosie. ");
INSERT INTO guz_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ebioto ebio inabikogenderere omobere oo, na ey’abaanto bao, na ey’abasomba bao.” ");
INSERT INTO guz_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Eri’Omonene agateebia Musa, “Moteebie Aroni abwate enyimbo yaye, ayeimokie igoro ye chindooche, na ebirooche, na amatibo, erinde agere ebioto bigende igoro ase ense yonsi ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aroni akarambora okoboko kwaye igoro y’amaache onsi a Misiri, na ebioto bigatiira, bigatuba ense eyio yonsi. ");
INSERT INTO guz_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Na abaringoria bagakora boigo ase oborogi bwabo, bakarenta ebioto igoro ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Erio Farao akarangeria Musa na Aroni, akabateebia, “Mosabe Omonene arusie ebioto korwa ase ense na korwa ase abanto baane, na inche ning’ee abanto baye ribaga bagende koruera Omonene ekeng’wanso.” ");
INSERT INTO guz_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa agateebia Farao, “Ase amasikani ao, naye oranteebie ngaki ki ndagosabere aye amo nabasomba bao, na abanto bao, erinde ebioto birue asore na ase chinyomba chiao, bitigare koba ase orooche rwa Naeli oka.” ");
INSERT INTO guz_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao akairaneria, “Ng’ankio.” Musa akamoteebia, “Nigo erabe buna gwateba, erinde omanye ng’a onde tari buna Omonene, Nyasae oito. ");
INSERT INTO guz_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ebioto nabirue asore na ase chinyomba chiao, ase abasomba bao na ase abanto bao; binde tibigotigara otatiga ase orooche rwa Naeli oka.” ");
INSERT INTO guz_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musa na Aroni bakarua o Farao, na Musa akabori’Omonene arusie ebioto ebio amorenterete Farao. ");
INSERT INTO guz_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Omonene agakora buna Musa amoboretie, na ebioto ebio biare ase chinyomba, na ase chigoora, na aande onsi isiko, bigakwa. ");
INSERT INTO guz_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Abanto bakabisangereria, bakabibeka ebinge chinyinge, na ense yonsi egatioka bobe. ");
INSERT INTO guz_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Korende ekero Farao aroche ng’a amang’ana abeire buya, agakong’ia enkoro yaye naende, na buna Omonene ateebete, akanga koigwa Musa na Aroni. ");
INSERT INTO guz_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Omonene agateebia Musa, “Moteebie Aroni aimokie enyimbo yaye aake orotu rw’eriroba, na rororwo naroonchoke robe chinsona ase ense ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Barabwo bagakora bo. Aroni akarambora okoboko kwaye, agaaka riroba nenyimbo yaye, na orotu rokaonchoka rokaba chinsona, na chirochio chikaroma Mwanyabaanto ne chitugo. Orotu rwonsi rwe riroba rokaonchoka rokaba chinsona. ");
INSERT INTO guz_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Abaringoria nabarabwo bagateema korenta chinsona ase oborogi bwabo, korende tibanyara. Chinsona echio chikaba aande onsi, ase Mwanyabaanto na ase chitugo. ");
INSERT INTO guz_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Abaringoria bagateebia Farao, “Eke nekiara kia Nyasae.” Korende Farao agakong’ia enkoro yaye, na buna Omonene ateebete, akanga kobaigwa. ");
INSERT INTO guz_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Omonene agateebia Musa, “Oche oimoke mambia chuni ekero Farao agochia kogenda rooche, otenene ase obosio bwaye, omoteebie: Aya nar’Omonene agoteeba: Bae abanto baane ribaga bagende bankorere. ");
INSERT INTO guz_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Onye tokoa abanto baane ribaga, rirorio nintome chingi chinyinge igoro yao na abasomba bao, na igoro y’abanto bao ne chinyomba chiao. Chinyomba chi’Abamisiri inachiichorwe ne chingi, nonya nense eyio yonsi bamenyete. ");
INSERT INTO guz_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Korende ase rituko erio nintige ensemo ya Goseni, ase abanto baane bamenyete; chingi echio tichigochiao, erio nomanye ng’a ninche Omonene bw’ense eye. ");
INSERT INTO guz_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ninkore ogwatananeka egati y’abanto baane na abao. Ankio egekone eke nagekoreke.” ");
INSERT INTO guz_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Omonene agakora ayio. Chingi chigaacha ase obonge mono ase chinyomba chia Farao, na echi’abasomba baye, na ase ense yonsi ya Misiri. Na ense eria egasarigwa ne chingi chiria. ");
INSERT INTO guz_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Erio Farao akarangeria Musa na Aroni, akabateebia, “Genda moruere Nyasae oino ekeng’wanso, korende naiga ase ense yaito.” ");
INSERT INTO guz_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa akamoiraneria, “Titokonyara gokora igo, ekiagera intwe ntoruere Omonene, Nyasae oito, ekeng’wanso ekeragechie Abamisiri. Na onye Abamisiri bagotorora tokorua ekeng’wanso buna ekio, Inee, tibagocha gotoaka amagena? ");
INSERT INTO guz_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Goika togende orogendo rw’amatuko atato gochia ase erooro, erinde toruere Omonene, Nyasae oito, ekeng’wanso buna atochikiire.” ");
INSERT INTO guz_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao akabateebia, “Nimbae ribaga mogende moruere Omonene, Nyasae oino, ekeng’wanso ase erooro, korende timogenda aare, naende monsabere inche.” ");
INSERT INTO guz_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa akamoiraneria, “Bono buna nkorua asore nimosabe Omonene arusie chingi korwa asore aye Farao, na ase abasomba bao, na ase abanto bao, ankio mambia. Korende aye Farao, tokora obong’ainereria naende, na kwanga koa abanto ribaga bagende baruere Omonene ekeng’wanso.” ");
INSERT INTO guz_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Erio Musa akarua o Farao, agasaba Omonene. ");
INSERT INTO guz_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Omonene agakora buna Musa ateebete, akarusia chingi chiria ase Farao, na ase abasomba baye, na ase abanto baye; tichiatigara nonya neyemo. ");
INSERT INTO guz_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Korende Farao agakong’ia enkoro yaye nonya nengaki eyio, taa abanto ribaga bagende. ");
INSERT INTO guz_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Omonene agateebia Musa, “Genda oteebie Farao: Aya nar’Omonene, Nyasae bw’Abaiberania, agoteeba: Bae abanto baane ribaga bagende, erinde bankorere. ");
INSERT INTO guz_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Naki onye gokwanga kobaa ribaga, na kogenderera kobatanga, ");
INSERT INTO guz_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","erio nario okoboko kw’Omonene koraake chitugo chiao aase chikorisia, ne chibarasi chiao, ne chitigere, ne chingamia, ne chiombe, ne ching’ondi; chirochio chinyore oborwaire obobe mono borachiite. ");
INSERT INTO guz_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Korende Omonene nakore ogwatananeka egati ye chitugo chi’Abaisraeli na echi’Abamisiri. Ase echi’Abaisraeli ende tegokwa nonya neyemo.” ");
INSERT INTO guz_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Omonene agachora engaki, akabora, “Ankio inche Omonene ninchiche nkore ayio ase ense eye.” ");
INSERT INTO guz_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Rituko ria kabere Omonene agakora buna ateebete. Chitugo chionsi chi’Abamisiri chigakwa, korende echi’Abaisraeli ende tiyakwa nonya neyemo. ");
INSERT INTO guz_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao agatoma abanto barigie egiakoregete, na barabwo bakamorentera amang’ana ng’a ase Abaisraeli tugo yabo ende tekweti. Nonya nabo enkoro ya Farao ekagenderera koba enkong’u, tabaa abanto ribaga bagende. ");
INSERT INTO guz_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Omonene agateebia Musa na Aroni, “Genda mobuuche ribu riichire roe korwa riko, na Musa arisiare gochia igoro, ase obosio bwa Farao. ");
INSERT INTO guz_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Narirorio rionchoke ribe orotu, roirurukigwe ase ense yonsi ya Misiri, rorente amagumba na amaote amabe, ase Mwanyabaanto ne chitugo.” ");
INSERT INTO guz_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Erio bakabuucha ribu korwa riko, bakagenda ase obosio bwa Farao. Musa akarisiara gochia igoro, na rirorio rikarenta amagumba na amaote amabe ase Mwanyabaanto ne chitugo. ");
INSERT INTO guz_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Na abaringoria tibanyara gotenena ase obosio bwa Musa, ekiagera amagumba konya abariire barabwo buna Abamisiri bande. ");
INSERT INTO guz_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Korende Omonene agakong’ia enkoro ya Farao, na buna Omonene konya atebirie Musa, Farao akaanga koigwa Musa na Aroni. ");
INSERT INTO guz_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Omonene agateebia Musa, “Oche oimoke mambia chuni, otenene ase obosio bwa Farao, omoteebie: Aya nar’Omonene, Nyasae bw’Abaiberania, agoteeba: Bae abanto baane ribaga bagende, erinde bankorere. ");
INSERT INTO guz_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Engaki eye nindete amaakwa aane onsi igoro yao aye omonyene, na igoro y’abasomba bao, na ase abanto bao, erinde omanye ng’a onde tari, nonya noyomo, ore buna inche, ase ense engima. ");
INSERT INTO guz_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Naki ase engaki eye nanga narambora okoboko kwane ngoake aye amo nabaanto bao namarwaire amabe abaite, aye nanga ngwasira korwa ase ense eye. ");
INSERT INTO guz_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Korende nagotigire obe moyo ase engencho eye inyare kworokia okobua kwane, na erieta riane nario rirararigwe ase ense yonsi. ");
INSERT INTO guz_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ekiagera aye nigo ogendererete gotanga abanto baane, na tori kobaa ribaga bagende. ");
INSERT INTO guz_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ase igo ankio, engaki buna eye, nindete embura y’amagena endito mono, eyio omogwekano oye etana gotwa rinde ase Misiri korwa riria ense eye yachaagete goika bono. ");
INSERT INTO guz_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Bono, origererie orore ng’a chitugo chiao chiarentirwe inka, naboigo na kende kiao gionsi kere isiko. Onye abanto bonsi abare isiko tibakorentwa ase chinyomba ime, embura y’amagena nebaite bakwe, ne chitugo chionsi boigo.” ");
INSERT INTO guz_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Abande b’abasomba ba Farao, abwo bairogete ring’ana ri’Omonene, bakaayerera korenta abasomba babo ne chitugo chiabo inka. ");
INSERT INTO guz_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Korende abwo basiereretie ring’ana ri’Omonene, bagatiga abasomba babo ne chitugo chiabo isiko. ");
INSERT INTO guz_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Eri’Omonene agateebia Musa, “Rambora okoboko kwao gochia igoro, erio embura y’amagena etwe ase ense ya Misiri, etwere Mwanyabaanto ne chitugo, na ebimeri bionsi bi’emegondo ase ense yonsi ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa akaimokereria enyimbo yaye gochia igoro, n’Omonene akarenta chinkoba na embura y’amagena, na okomesa gw’enkoba kogaika ase ense. Naboigo Omonene agaitera embura y’amagena igoro ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Embura enene y’amagena egatwa, na okomesa gw’enkoba gokagenderera amo nembura eyio. Na embura y’amagena eria yarenge endito mono, eyio omogwekano oye etana gotwa ase ense ya Misiri korwa ekero egesaku ekio giachaagete komenyao. ");
INSERT INTO guz_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Embura eria y’amagena egaita Mwanyabaanto bonsi abarenge isiko, amo ne chitugo chionsi ase ense ya Misiri. Egaita na gosaria ebimeri bionsi bi’emegondo, ekabuna na emete yonsi y’orosana. ");
INSERT INTO guz_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ase ensemo ya Goseni yoka, ase Abaisraeli bamenyete, nao embura y’amagena etatwete. ");
INSERT INTO guz_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Farao akarangeria Musa na Aroni, akabateebia, “Ase engaki eye inche nakorire ebibe; Omonene nere omonyene oboronge, inche na abanto baane nabamochi tore. ");
INSERT INTO guz_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nsabere ase Omonene. Chinkoba echi amo nembura y’amagena biatonyarire. Nimbae ribaga mogende, timogwenereti mobeere aa goetania.” ");
INSERT INTO guz_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa akamoiraneria, “Ekero nkorua ase omochie oo ninyimokie amaboko aane nsabe Omonene. Chinkoba echi nachisire, na embura y’amagena tegotwa goetania. Erio aye onyare komanya ng’a ense ney’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Korende nimanyete ng’a, aye na abasomba bao, timomoirogeti Omonene Nyasae nonya mbono.” ");
INSERT INTO guz_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Egatani na esairi bigaakwa, bigasarigwa, naki esairi konya yabekire ebigara, na egatani ngosomoria yare. ");
INSERT INTO guz_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Korende chingano tichiasaretigwe, ekiagera konya tichirakina. ");
INSERT INTO guz_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Korende Musa akarua o Farao, agasoka isiko yo omochie, akaimokia amaboko aye, agasaba Omonene. Erio chinkoba chiria na embura y’amagena bigatangwa, na embura tiyagenderera gotwa ase ense. ");
INSERT INTO guz_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ekero Farao aroche ng’a embura y’amagena ne chinkoba biatangirwe, akagenderera gokora ebibe, bagakong’ia chinkoro chiabo ere amo nabasomba baye. ");
INSERT INTO guz_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Enkoro ya Farao ekagenderera koba enkong’u, na buna Omonene konya akwanire goetera ase Musa, akaanga gotiga Abaisraeli bagende. ");
INSERT INTO guz_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Eri’Omonene agateebia Musa, “Genda ase Farao ekiagera nakong’irie enkoro yaye na boigo ne chinkoro chi’abasomba baye, erinde inyare koorokia ebikone ebi biane ase egati yabo; ");
INSERT INTO guz_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","erio naye nonyare goteebia abana bao na abachokoro bao amang’ana aya nakorire ase egati y’Abamisiri, na ebikone ebi nakorire ase egati yabo. Erio momanye ng’a inche ninche Omonene.” ");
INSERT INTO guz_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musa na Aroni bakagenda ase Farao, bakamoteebia, “Aya nar’Omonene, Nyasae bw’Abaiberania, agoteeba: Inee! Ngoika ririri orabe gokwanga gwekeyia ase obosio bwane? Bae abanto baane ribaga bagende bankorere. ");
INSERT INTO guz_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Onye gokwanga koa abanto baane ribaga bagende, rigereria ankio nindete chingige ase ense yao. ");
INSERT INTO guz_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ne chingige echio inachitube ense eye yonsi, erio monto tanyara korora riroba, na chirochio inachisirie endagera eria etasaretigwe nembura y’amagena, amo na kera omote ore ase ense yao. ");
INSERT INTO guz_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Chinyomba chiaino amo nechi’abasomba bao, na echi’Abamisiri bonsi inachiichorwe ne chingige. Omogwekano bw’echio chisokoro chiao gose chisokoororia chitaroche nonya ng’ake korwa ekero bachaagete komenya ase ense eye goika reero iga.” Erio Musa akaonchoka, akarua o Farao. ");
INSERT INTO guz_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Abasomba ba Farao bakamoteebia, “Ngoika ririri omonto oyo aratobeke ase emechando? Batige abanto aba bagende bakorere Omonene, Nyasae obo. Toramanya nonya mbono ng’a ense ya Misiri yasarekire?” ");
INSERT INTO guz_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Erio Musa na Aroni bakarentwa ase Farao, Ere akabateebia, “Genda, mokorere Omonene, Nyasae oino. Korende ning’o nang’o moganetie mogende komo?” ");
INSERT INTO guz_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa akamoiraneria, “Nigo toragende twensi, abake na abagotu, na abana baito, abamura na abaiseke, ching’ondi ne chitugo chiaito chinde chionsi, ekiagera ntobwate Rituko Rinene ri’Omonene.” ");
INSERT INTO guz_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Korende Farao akabateebia, “Omonene abe amo nainwe onye nkobaa ribaga mogende amo nabana baino. Korende namanyire ng’a nigo more nebirengererio ebibe ase chinkoro chiaino. ");
INSERT INTO guz_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yaya, taibo, genda inwe mweka abasacha, mokorere Omonene. Naki ayio naro konya moganetie.” Erio bagaserigwa korwa ase Farao. ");
INSERT INTO guz_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Omonene agateebia Musa, “Rambora okoboko kwao igoro y’ense ya Misiri, erinde chingige chichiche chirie ebimeri binde bionsi ebitasaretigwe nembura y’amagena.” ");
INSERT INTO guz_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Agwo Musa akaimokia enyimbo yaye igoro y’ense ya Misiri, n’Omonene akarenta omwaga korwa moocha, rituko rigima, omobaso na obotuko. Ekero bwakia omwaga oria korwa moocha konya orentire chingige. ");
INSERT INTO guz_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Chingige chigaacha igoro y’ense yonsi ya Misiri, chikagwa chinsemo chionsi chi’aroro. Chingige chinyinge buna echio chitana gocha ase amatuko aetire, gose tichigochi‐gocha naende nonya ng’ake. ");
INSERT INTO guz_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Chingige echio chigatuba ense eria yonsi goika ekamwama ti, chikaria ebimeri bionsi pi ase ense eria, na amatunda onsi y’emete, ebio bionsi bitasaretigwe nembura y’amagena. Tigiatigarete kemeri kende gionsi ekebese gose amato y’emete ase ense ya Misiri engima. ");
INSERT INTO guz_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ase obwango mono Farao akarangeria Musa na Aroni, akabateebia, “Nakorire ebibe ase Omonene, Nyasae oino, na ase more. ");
INSERT INTO guz_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Gaki bono nasabire, monyabere ebibe biane ekero eke gioka. Monsabere ase Omonene, Nyasae oino, erio anduserie ogoakwa oko tikong’ita.” ");
INSERT INTO guz_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa akarua o Farao, agasaba Omonene. ");
INSERT INTO guz_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Omonene akaonchora omwaga okaba bw’echinguru, okagusa korwa bosongo, okaira chingige chionsi gochia ase Enyancha Embariri. Tiyatigara engige nonya neyemo ase ense ya Misiri engima. ");
INSERT INTO guz_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Korende Omonene agakong’ia enkoro ya Farao, na ere akaanga koa Abaisraeli ribaga bagende. ");
INSERT INTO guz_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Eri’Omonene agateebia Musa, “Imokia okoboko kwao gochia igoro, erinde omosunte ekerima onyare koba ase ense ya Misiri, omosunte oranyare gotaba‐tabwa.” ");
INSERT INTO guz_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa akaimokia okoboko kwaye gochia igoro, na omosunte ekerima okaba ase ense ya Misiri engaki y’amatuko atato. ");
INSERT INTO guz_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Abanto tibanyara kororana; ase amatuko atato onde tarenge gosuka kogenda aande. Korende Abaisraeli barabwo mbabwate omobaso aase onsi ase bamenyete. ");
INSERT INTO guz_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao akarangeria Musa, akamoteebia, “Genda mokorere Omonene. Moire abana baino, korende chitugo chiaino chirochio mochitige aiga.” ");
INSERT INTO guz_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa akamoiraneria, “Yaya, goika otoe ching’iti togochia koruera Omonene, Nyasae oito, ebing’wanso bi’ogosambwa, na ebinde bi’okonyenywa. ");
INSERT INTO guz_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Naende goika toire chitugo chiaito chionsi, ende teri eratigare magega nonya neyemo. Korwa ase echio nao togochia korusia echi toraruere Omonene, Nyasae oito; intwe titomanyeti buna togochia gokorera Omonene goika toraika aroro.” ");
INSERT INTO guz_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Omonene agakong’ia enkoro ya Farao, na ere tancha kobaa ribaga bagende. ");
INSERT INTO guz_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Erio Farao agateebia Musa, “Karue ase obosio bwane! Bwerende, tobaisa gocha kondora naende, naki rituko riria orache korora obosio bwane naende, nigo orakwe.” ");
INSERT INTO guz_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa akamoteebia, “Gwakwanire ekeene; inche tingocha gokorora naende.” ");
INSERT INTO guz_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Omonene agateebia Musa, “Ngotigarete ogoakwa okomo ndarente igoro ya Farao na ense ya Misiri. Magega y’okwo nabae ribaga mogende; na ekero arabae ribaga mogende nigo arabaserie kegima morueo. ");
INSERT INTO guz_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Bono genda okwane na Abaisraeli, ng’a kera oyomo ase abasacha na ase abakungu asabe ebinto bie chifeta, na ebie chitaabu korwa ase omoamate oye.” ");
INSERT INTO guz_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Omonene akaa abanto baye ogwancherwa ase amasio y’Abamisiri; kobua ayio Musa nigo arenge omonto omonene mono ase ense ya Misiri ase amasio ’abasomba ba Farao, na ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa agateebia Farao, “Aya nar’Omonene agoteeba: Botuko gati ninche ng’ete egati y’Abamisiri. ");
INSERT INTO guz_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Abana abatangi bonsi ase ense ya Misiri mbakwe, amo ne ching’iti chintangi chionsi; omwana omotangi o Farao, oyogoikaransa ase ekerogo kiaye ki’obogambi, na omwana omotangi bw’omokuungu omosomba ore rogena gosia, ne ching’iti chintangi chionsi. ");
INSERT INTO guz_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Erio ebirero ebinene inabibe ase ense yonsi ya Misiri, binde bitana koba bo, gose tibigocha koba bo naende nonya ng’ake. ");
INSERT INTO guz_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Korende ase Abaisraeli, nonya nesese tegokogera omonto gose etugo. Erio momanye ng’a Omonene okorire ogwatananeka ase Abamisiri na Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Na abasomba aba bao bonsi nabatirimboke gocha ase ’nde na batung’ameo, bakobora: Genda, karue aa, aye na abanto bao bonsi bakobwatie. Magega y’ayio nindue aa!” Erio agwo Musa akarua o Farao ore nekeririanda ekenene. ");
INSERT INTO guz_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Omonene agateebia Musa. “Farao nagenderere gotabaigwa inwe; ase ayio ning’orokie amakumia ande ase ense ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa na Aroni bagakora amakumia ayio onsi ase obosio bwa Farao, korende Omonene agakong’ia enkoro ya Farao, na ere taa Abaisraeli ribaga barue ase ense yaye. ");
INSERT INTO guz_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Omonene agakwana na Musa na Aroni aria ase ense ya Misiri, akabateebia. ");
INSERT INTO guz_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Omotienyi oyo nobe oyo bw’eritang’ani ase more, oyo bw’ogochaka emetienyi yo omwaka. ");
INSERT INTO guz_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Genda oraarerie omoganda bwonsi bw’Abaisraeli, obateebie: Rituko ria ikomi ri’omotienyi oyo kera omonto ore na mwaye achore emanwa, erio kera enyomba ebe nemanwa eyemo. ");
INSERT INTO guz_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Korende onye abanto b’enyomba eyemo bare abake, batanyare koria emanwa eria bayekoore, rirorio ere na omogisangio oye, oyobasinyaine, basangere emanwa eyemo, koreng’ana buna omobaro bw’abaanto bareo. Ase kera emanwa goika mobare abanto abarache koyeria koreng’ana buna kera oyomo aranyare koria. ");
INSERT INTO guz_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mochore emanwa y’omwaka oyomo etari na kemocho ase omobere oye, ebe eng’ondi gose embori. ");
INSERT INTO guz_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mochigache goika rituko ria ikomi na kane ri’omotienyi oyio. Agwo omoganda bwonsi bw’Abaisraeli bachinyenye mogoroba. ");
INSERT INTO guz_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Barabwo baimokie amanyinga aria, bayagindie emetobwa ebere ya gesieri na omoribo o igoro bw’emetobwa, ase kera enyomba barayeriere emanwa eria. ");
INSERT INTO guz_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ase obotuko obwo barie chinyama chiria chisambire nomorero, amo nemegati etabekiri memera, ne chinyeni chindoro. ");
INSERT INTO guz_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Timoria chinde imbese gose chiyekire ase amaache, korende chionsi goika chisambwe nomorero amo nomotwe na ebirenge, ne chinyama chianda. ");
INSERT INTO guz_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Timotigaria gento kende goika mambia; onye kende kegotigara goika mambia mogesambe nomorero gesire. ");
INSERT INTO guz_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Enchera morayerie nero eye: Mweboyie chinkini chiaino, mokong’e, mobeke ebikoroto ase amagoro aino, mobwate chinyimbo maboko aino, moyerie nomoayerero. Naki eyio n’Epasaka y’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Naki ase obotuko obwo ninche ng’ete ense ya Misiri, ing’ite abana abatangi bonsi ne ching’iti chintangi chionsi; ne chinyasae chionsi chia Misiri ninchigambie. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Amanyinga ayio abe ekemanyererio ase chinyomba chiria morabe momenyete. Ekero ndarore amanyinga aria ning’ete mbatige inwe, na amaakwa aria takobanyora inwe abasirie, ekero ndaake ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Rituko eri inaribe ase more rituko rikoinyorwa, na inwe morirende ribe Rituko Rinene ri’Omonene. Nigo moraribwate ebiaare ase ebiaare, ribe rituko rinene ri’omoyega goika kare na kare.” ");
INSERT INTO guz_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Ase engaki y’amatuko atano na abere goika morie emegati etabekiri memera. Rituko rie ritang’ani morusie ememera korwa chinyomba chiaino kegima, ekiagera monto onde bwensi orarie omogati obekire ememera korwa rituko rie ritang’ani goika eria gatano na kabere, nigo araatananwe korwa ase obomo bw’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ase rituko rie ritang’ani inamobe nomosangererekano bwatananire ase ogosasiima, na ase rituko ria gatano na kabere boigo mobe nomosangererekano bwatananire ase ogosasiima. Ase amatuko ayio timokora meremo ende yonsi, otatiga okoroisia endagera ase kera omonto ayio oka naro morakore. ");
INSERT INTO guz_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Goika mobe mokorenda rituko eri rinene ri’Emegati etabekiri memera, ekiagera ase rituko eri nario emeganda yaino yarusetigwe ase ense ya Misiri. Morende rituko erio ebiaare ase ebiaare. Oko nakwo korabe ogochika ase more kogenderera botambe. ");
INSERT INTO guz_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","“Goika morie emegati etabekiri memera, gochakera omogoroba bwe rituko ria ikomi na kane ri’omotienyi bw’eritang’ani goika omogoroba bwe rituko ri’emerongo ebere na rimo. ");
INSERT INTO guz_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ase engaki y’amatuko atano na abere ememera terorekana ase chinyomba chiaino nonya ng’ake; naki onde bwensi orarie egento kebekire ememera naatananwe korwa ase omoganda bw’Abaisraeli, onye ore omomenyi gose omobiare. ");
INSERT INTO guz_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Timoria gento kende gionsi kebekire ememera; mobe mokoria emegati etabekiri memera aande onsi morabe momenyete.” ");
INSERT INTO guz_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Erio Musa akarangeria abagaaka bonsi b’Abaisraeli, akabateebia, “Genda mochore chimanwa echirabaisane abanto ba kera enyomba, mochinyenye chibe chimanwa chi’omoyega bw’Epasaka. ");
INSERT INTO guz_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Erio moimokie chinsagia chia hisopo, mochitobeke ase amanyinga are egetaabo ime, mogindie omoriibo bw’emetobwa ya gesieri igoro amo nemetobwa eria ebere. Onde tabaisa gosoka korwa nyomba mwaye goika mambia. ");
INSERT INTO guz_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Inaki Omonene nache aete ense ya Misiri aite Abamisiri, korende ekero ararore amanyinga agindirie omoriibo bw’emetobwa ya gesieri igoro na emetobwa eria ebere, nigo araete egesieri ekio, gose tagotiga oria omosiria asoe chinyomba chiaino abaite. ");
INSERT INTO guz_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ring’ana eri goika morirende, ribe ogochika kwaino, inwe amo nabana baino kogenderera botambe. ");
INSERT INTO guz_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ekero moraike ase ense eri’Omonene arabae, buna abarierete eira, goika mobe mokomoruera ekeng’wanso eke. ");
INSERT INTO guz_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na agwo ekero abana baino barache kobaboria: Engencho y’amang’ana aya ninki?. ");
INSERT INTO guz_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Inamobairanerie: Eke nekeng’wanso gi ’Epasaka y’Omonene, ekiagera naetete chinyomba chi’Abaisraeli aaria Misiri ekero aitete Abamisiri, korende agatiga chinyomba chiaito.” Erio Abaisraeli bagatung’ama inse, bagasasiima Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Abaisraeli bakagenda, bagakora onsi ay’Omonene achigete Musa na Aroni. ");
INSERT INTO guz_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Bogachia koba botuko gati, Omonene agaita abana abatangi bonsi ase ense ya Misiri, gochakera omwana omotangi o Farao oyoikaransete ase ekerogo kiaye ki’obogambi, goika omwana omotangi bw’omonto osibire echela, boigo ne ching’iti chintangi chionsi chigaitwa. ");
INSERT INTO guz_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao, amo nabasomba baye bonsi, na Abamisiri bonsi bakaboka botuko. Ebirero ebinene bikaba ase ense yonsi ya Misiri, ekiagera nyomba ende tiyatigarete monto atakwete. ");
INSERT INTO guz_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Erio Farao akarangeria Musa na Aroni obotuko boria, akabateebia, “Imoka, morue aa ase abanto baane, inwe na Abaisraeli bonsi! Genda mokorere Omonene buna mwabeire mokoboria! ");
INSERT INTO guz_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ira ching’ondi chiaino ne chiombe chiaino buna mwaboririe, morue aa; monsabere, na inche nsesenigwe.” ");
INSERT INTO guz_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Abamisiri bagasorora Abaisraeli, bakabaayereria barue ase ense yabo; naki nigo bateebete ng’a, “Aande nigo torabaise gokwa intwe twensi.” ");
INSERT INTO guz_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Abanto abwo bakaimokia amasie abo konya atarabekwa memera, bakaboa ebituba biabo, ebi baare oboseemiara obosie, ase ebitambaa biabo baare kwambara, bakabibogoria ase amareko abo. ");
INSERT INTO guz_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Abaisraeli konya bakorire buna Musa abateebeetie; konya basabire korwa ase Abamisiri ebinto bie chifeta na ebie chitaabu amo ne chianga. ");
INSERT INTO guz_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Omonene konya oeire abanto abwo ogwancherwa ase Abamisiri, na barabwo bakabaa kende gionsi eki baganetie. Ase enchera eye bagasakora Abamisiri. ");
INSERT INTO guz_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Abaisraeli bakamanora kogenda namagoro korwa Ramesesi, bagaika Sukoti. Nigo barenge abasacha koreng’ana chilifu amagana atano na rimo (600,000), abakungu na abana tibaabaretwe. ");
INSERT INTO guz_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Na omoganda omonene mono bw’abaanto b’ebisaku ao ao bakagenda komo, bakairana ching’ondi, ne chiombe, ne chitugo chinde chinyinge mono. ");
INSERT INTO guz_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ase obosie boria konya botarabekwa memera obwo barentanete korwa Misiri bakaroisia emegati etabekiri memera. Ememera tiyarengeo, ekiagera nigo baseretigwe korwa Misiri ase obwango, bataranyora ribaga koroisia endagera bagochia koria. ");
INSERT INTO guz_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Abaisraeli konya bamenyire ase ense ya Misiri ase engaki y’emiaka amagana ane, na emerongo etato (430). ");
INSERT INTO guz_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ase rituko erio erio riomoerio bwe emiaka eyio amagana ane, na emerongo etato, emeganda yonsi y’Omonene ekang’anya korwa ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Obotuko obwo nigo bwarenge obotuko bw’okorenda, ekero Omonene arenge ang’e ase okong’anyia Abaisraeli korwa ase ense ya Misiri. Obwo nobotuko Omonene, bogwenerete korendwa n’Abaisraeli ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Omonene agateebia Musa na Aroni, “Omoroberio bw’Epasaka noro oyo: Omonto omomenyi tabaisa koyeria, ");
INSERT INTO guz_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","korende omosomba onde bwensi omogorwa chitaabu ere ayerie gokwamwarokirie. ");
INSERT INTO guz_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Omogeni omenyete ase more, gose omonto orikire tibayeria Epasaka eyio. ");
INSERT INTO guz_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Goika erierwe enyomba eyemo ime, timobaisa gosokia chinyama chinde isiko; timobuna riuga riaye rinde rionsi. ");
INSERT INTO guz_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Omoganda bwonsi bw’Abaisraeli goika osange omoyega oyio. ");
INSERT INTO guz_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Onye omomenyi omenyete bwoo bwanchete koria Epasaka y’Omonene, ere na abasacha bonsi abare amo nere goika barokigwe. Erio anyare koria Epasaka, na ere abe buna omobiare oino. Korende onde bwensi otarokiri tayeria. ");
INSERT INTO guz_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ogochika nokomo ase omobiare bw’Abaisraeli na omomenyi oyomenyete ase egati yaino.” ");
INSERT INTO guz_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Abaisraeli bonsi bagakora buna Omonene achigete Musa na Aroni. ");
INSERT INTO guz_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ase rituko erio eri’Omonene akang’anyia emeganda yonsi y’Abaisraeli korwa ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nyatananere kera omwana omotangi bw’Abaisraeli, oyo okoigora enda ya ng’ina, ne ching’iti chintangi boigo. Ekiagera kera omwana omomura omotangi bw’Abaisraeli noyone ne ching’iti chitangi boigo nechiane.” ");
INSERT INTO guz_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Erio Musa agateebia abanto, “Mobe mokoinyora rituko eri mwang’anyete korwa ase ense ya Misiri, ense eyio mwarenge abasomba, ekiagera Omonene abang’anyetie korwa agwo nokoboko kwaye gwe chinguru. Ase rituko erio omogati obekire ememera toriegwa. ");
INSERT INTO guz_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Rituko ria reero ase omotienyi bw’Abibu nario mokong’anya korwa aa. ");
INSERT INTO guz_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Omonene nabarierete chisokoro chiaino eira ng’a nabae ense y’Abakanaani, na Abahiti, na Abaamori, na Abahivi, na Abayebusi. Eyio nense entenenku ere namabeere na obooke. Ekero arabaikie agwo goika mobe mokomoruera ekeng’wanso eke ase omotienyi oyio. ");
INSERT INTO guz_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ase engaki y’amatuko atano na abere mobe mokoria emegati etabekiri memera; ase rituko ria gatano na kabere ribe Rituko Rinene ri’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Emegati etabekiri memera eriegwe ase amatuko atano na abere. Emegati ebekire ememera, gose ememera emenyene, tibirorekana ase ense yaino engima. ");
INSERT INTO guz_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ekero mogochaka omoyega, ase rituko erio moteebie abana baino buna nigo mogokora ayio onsi ase okoinyora ay’Omonene abakorerete ekero abang’anyetie korwa Misiri. ");
INSERT INTO guz_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Amang’ana aya abe ekemanyererio ase okoboko kwao, na ase obosio bwao abe ekeinyorio kegokoinyoria, erinde ogenderere gokwana amachiiko y’Omonene, ekiagera Omonene nakong’anyetie korwa Misiri nokoboko kwaye gwe chinguru. ");
INSERT INTO guz_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ase ayio ogochika oko goika korende omwaka ase omwaka ase engaki eyio echiikire.” ");
INSERT INTO guz_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Ekero Omonene arakorae na kogoikia ase ense ya Kaanani, eyio akorierete eira, aye amo ne chisokoro chiao, na akoyee, ");
INSERT INTO guz_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","omorwere omonene kera omwana omomura omotangi; na kera eng’iti entangi y’e tugo yao, echio nigo chirabe echi’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Korende kera emori entangi y’etigere goika oyeboorie ase okorua emanwa y’eng’ondi ebe ekeng’wanso. Onye tibwancheti koyebooria goika oyebune ebigoti. Kera omwana omoisia omotangi o Mwanyabaanto goika omoboorie. ");
INSERT INTO guz_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Engaki erache omwana oo karakoborie: Engencho y’amang’ana aya ninki? Goika omoiranerie: Ase okoboko kwaye gwe chinguru Omonene agatong’anyia korwa Misiri agwo ase twarenge abasomba. ");
INSERT INTO guz_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Naki ekero Farao akong’etie enkoro yaye akaanga gotoa ribaga kogenda, Omonene agaita kera omwana omotangi ase ense ya Misiri amo ne ching’iti chintangi chionsi. Nakio gekogera nkoruera Omonene kera eng’iti entangi ye tugo yane, na omwana one omomura omotangi nigo nkomobooria. ");
INSERT INTO guz_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Amang’ana aya goika abe ekemanyererio ase okoboko kwao na ase obosio bwao, ekiagera Omonene natorusetie korwa Misiri nokoboko kwaye gwe chinguru.” ");
INSERT INTO guz_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ekero Farao aete Abasiraeli ribaga bagende, Nyasae tabaraete baetere ense y’Abafilisti, nonya enchera eyio yarenge omobutokanio. Nyasae nigo arengereretie ng’a aande onye abanto aba bagochia koumera esegi mbaabaisa koirana Misiri. ");
INSERT INTO guz_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ase ayio Nyasae akabaraa goetanana ase erooro gochia Enyancha Embariri. Na Abaisraeli bakarua ase ense ya Misiri bare nebirwanero bi’esegi. ");
INSERT INTO guz_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa akairana amauga a Yusufu buna konya Yusufu amochikiire konya atarakwa. Nigo konya otianirie Abaisraeli, agateeba, “Ekero Nyasae arabachere abakoonye morue ase aa, goika moire amauga aane, mogende naro.” ");
INSERT INTO guz_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Barabwo bakaimoka bakarua Sukoti, bagatoora agwo Etamu aase erooro echakerete. ");
INSERT INTO guz_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Omonene akaba okobatang’ana, mobaso ase riire riare buna esiiro koborokia enchera, na botuko ase omorero orenge buna esiiro kobaa oborabu, erio barore ase bakogenda, omobaso na obotuko. ");
INSERT INTO guz_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Riire riria riare kobaraa mobaso nigo riarenge bosio bwabo botambe, na omorero botuko, toruete ase amasio abo. ");
INSERT INTO guz_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Omonene agakwana na Musa, akamoteebia. ");
INSERT INTO guz_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Bateebie Abaisraeli ng’a bairane gochia Pi‐Hahiroti, batoore agwo ase egati ya Migidoli na enyancha kororia Baali‐Sefoni ase enyancha mbarabare. ");
INSERT INTO guz_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao narengererie ng’a Abaisraeli batantanire enchera bakogenda, na erooro yabatangire tibagenda. ");
INSERT INTO guz_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Inche ninkong’ie enkoro ya Farao, erio ababwatie korwa magega, na inche ninyenyorere ogotogigwa ase okobua Farao amo nomoganda oye bwonsi, na Abamisiri bamanye ng’a inche ninche Omonene. Abaisraeli bagakora buna bateebetigwe. ");
INSERT INTO guz_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ekero Farao, omorwoti o Misiri, ateebetigwe ng’a Abaisraeli batamire, ere amo nabasomba baye bakaonchora ebirengererio biabo, bakaboora, “Inki eke twakora? Tokaa Abaisraeli ribaga korua aa ase barenge gotokorera.” ");
INSERT INTO guz_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Erio Farao akabeeka egari yaye y’esegi amo na abarwani baye b’esegi ang’e. ");
INSERT INTO guz_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Naende akaira chigari amagana atano na rimo, echi achorete, amo ne chigari chinde chionsi, na abariini chituoni bachiriinete. ");
INSERT INTO guz_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Omonene agakong’ia enkoro ya Farao, omorwoti o Misiri, na ere akabwatia Abaisraeli korwa magega, ekero barabwo bang’anyete bare nobomwenu. ");
INSERT INTO guz_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Abamisiri bakababwatia korwa magega amo ne chibarasi chionsi, ne chigari chia Farao, na abariini chibarasi chiaye, na abarwani baye bonsi, bakabanyora batoorire enyancha mbarabare, ang’e na Pi‐Hahiroti kororia Baali‐Sefoni. ");
INSERT INTO guz_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ekero Abaisraeli barigereretie magega bakarora Farao na abarwani baye b’esegi bakobabwatia korwa magega, erio agwo barabwo bakaba nobwoba obonene, bakarera ase Omonene. ");
INSERT INTO guz_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Erio bagateebia Musa, “Inee! Chimbeera tichiarenge Misiri? Nase ayio ogatorenta toche gokwera aa ase erooro? Igo gwatokorera bobe ekero gwatorusia korwa Misiri! ");
INSERT INTO guz_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Titwagotebetie ayio aaria Misiri? Tokagoteebia ng’a: Totige tokorere Abamisiri. Naki anga mbuya tware gokorera Abamisiri kobua gokwera aiga ase erooro.” ");
INSERT INTO guz_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa akabateebia Abaisraeli, “Timwoboa, motenene bokong’u reero morore buna Omonene arabatoorie; naki Abamisiri abamorooche reero iga, timokobarora naende nonya ng’ake. ");
INSERT INTO guz_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Omonene nabarwanere inwe, na inwe mokire‐kiri rioka.” ");
INSERT INTO guz_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Omonene akaboria Musa, “Inki okorera ase ’nde? Bateebie Abaisraeli bagenderere bosio. ");
INSERT INTO guz_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Aye imokia enyimbo yao, na orambore okoboko kwao igoro y’enyancha, erinde yaatananeke, Abaisraeli banyare goeta egati y’enyancha ase ense enkamoku. ");
INSERT INTO guz_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Rora, ninkore chinkoro chi’Abamisiri chibe chinkong’u, barabwo mbaababwatie korwa magega. Nabo inche inyenyorere ogotogigwa ase okobua Farao amo nemeganda yaye yonsi, ne chigari chiaye, na abariini chibarasi chiaye. ");
INSERT INTO guz_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na Abamisiri nabamanye ng’a ninche Omonene, ekero nkwenyorera ogotogigwa ase okomobua Farao amo ne chigari chiaye na abariini chibarasi chiaye.” ");
INSERT INTO guz_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Erio omomalaika o Nyasae, oyio otang’aine omoganda bw’Abaisraeli, akairana magega yabo. Ne riire riria riateneine buna esiiro bosio bwabo rikairana magega yabo, ");
INSERT INTO guz_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","rikabeera gati y’omoganda bw’Abaisraeli na oyo bw’Abamisiri. Agwo riire riria rikabao amo nomosunte; korende ase obotuko riire rikarenta oborabu. Na ase obotuko obogima omoganda oyomo toikanete ang’e noyonde. ");
INSERT INTO guz_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Erio Musa akarambora okoboko kwaye igoro y’enyancha; n’Omonene agasukia enyancha gochia magega ne chinguru chi’omwaga okorwa moocha okagusa obotuko obogima. Naboigo agakora enyancha koba ense enkamoku. Amache agaatananeka, ");
INSERT INTO guz_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","na Abaisraeli bagaeta egati y’enyancha ase ense enkamoku. Amache akaba agotenena buna orwaki ensemo ya borio na ensemo ya bomosi ase bare. ");
INSERT INTO guz_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Na Abamisiri bagasoa na kobabwatia gochia gati y’enyancha amo ne chibarasi chionsi chia Farao, ne chigari chiaye, na abariini chibarasi. ");
INSERT INTO guz_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Bwachia koba mambia, Omonene akaba origereretie omoganda bw’Abamisiri korwa ase esiiro y’omorero na eye riire, akabatantania. ");
INSERT INTO guz_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Omonene akagokora amagoro e chigari chiabo, goika bagasinywa kogenda bosio. Erio Abamisiri bagateeba, “Tiga totame korwa ase Abaisraeli, ekiagera Omonene nkobarwanera are mamincha yaito intwe Abamisiri.” ");
INSERT INTO guz_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Omonene agateebia Musa, “Rambora okoboko kwao igoro y’enyancha, erinde amaache airanerane igoro y’Abamisiri, ne chigari chiabo amo nabariini chibarasi.” ");
INSERT INTO guz_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa akarambora okoboko kwaye igoro y’enyancha, na ekero bwachia gokiamoka, amaache akairana ase konya are botambe. Abamisiri bagatema gotama korwa ase amaache, korende Omonene akabasiria ase amaache. ");
INSERT INTO guz_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Amache akairanerana, akamera chigari, na abariini chibarasi amo nomoganda bwonsi bw’abarwani ba Farao, obatunyanete Abaisraeli, gochia ase enyancha. Monto onde tatigara nonya noyomo. ");
INSERT INTO guz_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Korende Abaisraeli bakagenderera goeta egati y’enyancha ase ense enkamoku, amaache akaba ateneine buna orwaki ensemo ya borio na ensemo ya bomosi ase bare. ");
INSERT INTO guz_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Naboigo ase rituko riri’Omonene atooretie Abaisraeli korwa ase amaboko ’Abamisiri; na Abaisraeli bakarora Abamisiri bakwete bacheng’enenete ase engegu y’enyancha. ");
INSERT INTO guz_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Na ekero Abaisraeli baroche buna Omonene aorokirie okobua kwaye okonene igoro y’Abamisiri, bakamoiroka Omonene, bakamwegena Omonene na Musa, omosomba oye. ");
INSERT INTO guz_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Erio Musa na Abaisraeli bakamoterera Omonene ogoteera oko, bagoteeba: Nimoterere Omonene, ekiagera ere obuire ase okobua okonene; chibarasi amo nabachiriinete obarimeirie ase enyancha ime. ");
INSERT INTO guz_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Omonene nere chinguru chiane, nimoterere ere, ere nogotooreka kwane. Ere Nyasae one, nimotogie; ere Nyasae o tata, ninterere obonene bwaye. ");
INSERT INTO guz_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Omonene nomorwani bwe chiseegi, Omonene nario erieta riaye. ");
INSERT INTO guz_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Orutire chigari chia Farao amo nomoganda oye ase enyancha ime; abarwani baye abachore obarimeirie ase enyancha embariri. ");
INSERT INTO guz_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Amache abatubire, barimeire chindiba ime buna rigena rikorutwa. ");
INSERT INTO guz_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Omonene, okoboko kwao gw’okorio nkore nokobua okonene, Omonene, okoboko kwao gw’okorio ngosenyente ababisa. ");
INSERT INTO guz_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ase okobua kwao okonene nigo okobaiyeria inse abagokoimokera; endamwamu yao ekobera, nigo ekobasamba buna chimboba chinyomo. ");
INSERT INTO guz_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ase omoika korwa ase chimioro chiao amaache akaimoka, agatenena buna orwaki, enyancha egakamoka goika inse kegima. ");
INSERT INTO guz_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Omobisa agateeba, “Nimbabwatie, mbaikeere, mbiatanane ebi ndasakore, omoyo one oisaneke; ninsomore omoyio one o birende, nimbasirie nokoboko kwane.” ");
INSERT INTO guz_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Naboigo ekero aye kwagusete buna omwaga, amaache akabamera; bakamerwa buna embunde ekorimera ase amaache amange ime, yarika inse. ");
INSERT INTO guz_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Omonene, ning’o onga buna aye ase egati ye chinyasae? Ning’o onga buna aye ore nobonene na obochenu? Naye ogwenerete koirokwa na gotogigwa, aye naye oyogokora amakumia. ");
INSERT INTO guz_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ekero kwaramborete okoboko kwao gw’okorio, ense ekabamera. ");
INSERT INTO guz_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ase chiira chiao chi’obwanchani chiria kwabarierete okaraa abanto aba kwabooretie, ase chinguru chiao okabaikia ase obomenyo bwao obochenu. ");
INSERT INTO guz_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Abanto b’ebisaku bakayaigwa, bagatengechigwa ase omoondoko, omoichano na obororo bikabwata abamenyete Bofilisti. ");
INSERT INTO guz_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Abagaambi b’Edomu bakaondoka, abanto abanene ba Moabu bakabwatwa nomotengecho, na abanto bonsi ba Kaanani bakerusia moyo. ");
INSERT INTO guz_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Omoondoko na obwoba bikababwata; ase engencho y’okobua gw’okoboko kwao bagatenena, bagakira‐kiri buna amagena, goika abanto bao baetire, ee, Omonene, goika abanto bao kwabooretie baetire. ");
INSERT INTO guz_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nobasoyie na kobabeeka ase egetunwa kiao aye omonyene, aase aria kweroiseretie, aye Omonene, obomenyo obochenu kwaagachete namaboko ao. ");
INSERT INTO guz_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Omonene nagaambe kare na kare. ");
INSERT INTO guz_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ekero chibarasi chia Farao, amo ne chigari na abariini basoete nyancha ime, Omonene akairania amaache igoro yabo, akabatuba; korende Abaisraeli bagaeta egati y’enyancha ase ense enkamoku. ");
INSERT INTO guz_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Na Miriamu omobani, omoiseke omwabo Aroni, akaimokia ekebangarara kiaye, na abakungu bonsi bakamobwatia bakobugia ebibangarara biabo na goteenga. ");
INSERT INTO guz_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu akabaterera ogoteera kogoteeba, “Moterere Omonene, ekiagera ere obuire ase okobua okonene, chibarasi amo nabachiriinete obarimeirie ase enyancha ime.” ");
INSERT INTO guz_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Erio Musa agatang’ana Abaisraeli kogenda orogendo korwa ase Enyancha Embariri gochia erooro ya Suri. Bagataara ase engaki y’amatuko atato ase erooro, na tibanyora maache. ");
INSERT INTO guz_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Erio bagaika aase are korokwa Mara, tibanyara konywa amaache arengeo, ekiagera arenge amaroro mono. Nakio kiagerete aase aria akarokwa Mara. ");
INSERT INTO guz_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Agwo abanto bakemurunganeria Musa, bakamobooria, “Ninki tokonywa?” ");
INSERT INTO guz_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa akarera ase Omonene, n’Omonene akamworokia ekeng’ese kio omote. Omote oyio Musa akayoruta amaache ime, na amaache aria akaba amaansu. Agw’Omonene akabeekera abanto amaachiko akobaraa, na agwo akaba okobateema. ");
INSERT INTO guz_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Akabora, “Oise koigwera aya inche Omonene oo ngokwana, na koyakora ayare boronge ase amaiso aane, na gotegerera amaachiko aane, na kobwata emeroberio yane yonsi, rirorio inche tingokobekera amarwaire ande onsi buna aria nabeekerete Abamisiri; naki ninche Omonene oo, oyogokogwenia.” ");
INSERT INTO guz_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Erio abanto bagaika Elimu; agwo chinsoko nchiarengeo ikomi na ibere, na emekendo emerongo etan’abere (70). Bagatoora agwo ang’e namaache. ");
INSERT INTO guz_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Omoganda bwonsi bw’Abaisraeli okamanora na koimoka korwa Elimu, na ase rituko ria ikomi na gatano ri’omotienyi o kabere magega kobarure ense ya Misiri, bagaika ase erooro ya Sini, eyio ere egati y’Elimu na Sinai. ");
INSERT INTO guz_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Agwo ase erooro omoganda bwonsi bwa Abaisraeli bakemurunganeria Musa na Aroni, ");
INSERT INTO guz_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","bakabateebia, “Nanga mbuya onye twakwerete ase amaboko a ’Omonene aaria ase ense ya Misiri. Agwo tware goikaransa ase chinyongo chie chinyama, tware koria endagera ende enyinge, twaigota. Korende bono mwatorentire aa ase erooro ase ogotoita intwe twensi nenchara.” ");
INSERT INTO guz_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Eri’Omonene agateebia Musa, “Rora, nimbatwerie endagera korwa igoro. Kera rituko abanto bagende isiko, basangererie eyekobaisana ase rituko erio. Ase enchera eyio inche mbateeme gose mbabwatie amachiiko aane. ");
INSERT INTO guz_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Korende rituko ria gatano na rimo goika basangererie na koroisia ara kabere buna bagosangereria amatuko ande.” ");
INSERT INTO guz_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Erio Musa na Aroni bagateebia Abaisraeli bonsi, “Mogoroba reero inwe nario moramanye ng’a Omonene nere obarusetie korwa ase ense ya Misiri, ");
INSERT INTO guz_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","na mambia inamorore obonene bw’Omonene, ekiagera ere oigure buna mwamwemurunganeirie. Ee, mwamwemurunganeirie Omonene, tari intwe. Intwe inki toisaine moratuemurunganerie?” ");
INSERT INTO guz_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Naende Musa agateeba, “inwe buna morore obonene bw’Omonene ekero arabae chinyama morie mogoroba, na mambia abae omogati morie, moigote ekiagera ere oigure buna mwamwemurunganeirie. Inki mokwemurunganeria ase tore? Intwe titoisaini gento. Tari intwe mwemurunganeirie, korende n’Omonene.” ");
INSERT INTO guz_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa agateebia Aroni, “Bateebie omoganda bwonsi bw’Abaisraeli basuke gocha ase obosio bw’Omonene, ekiagera oigure okwemurungania kwabo.” ");
INSERT INTO guz_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ekaba ekero Aroni arenge gokwana nomoganda bwonsi bw’Abaisraeli, barabwo bakeonchora bakarigereria gochia ase erooro, bakarora obonene bw’Omonene bokooroka korwa ase riire. ");
INSERT INTO guz_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Naigure okwemurungania kw’Abaisraeli. Kwana nabarabwo, obateebie ng’a engaki ya mogoroba mbaegwe enyama barie, na mambia inabarie omogati. Erio bamanye ng’a ninche Omonene, Nyasae obo.” ");
INSERT INTO guz_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Mogoroba chinkware chigaacha, chigaichora ase batoorete, na mambia yaye aase onsi aetanaine aase aria akanyorwa atoorire riimi. ");
INSERT INTO guz_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Na ekero riimi riakamokire, bakarora inse aria ase erooro ebinto binga buna amagoocho, bikarorekana buna obosie oborabu. ");
INSERT INTO guz_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ekero Abaisraeli babiroche tibamanyete gose mbinto ki, bagachaaka koborania barabwo ase barabwo, “Mbinto ki biria?” Musa akabateebia, “Oria nomogati oy’Omonene abaeire morie. ");
INSERT INTO guz_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ring’ana erio nario Omonene achigete: Sangereria endagera eyio, kera oyomo buna agwenerete, ebimunu bibere ase kera omonto. Kera omonto asangererie buna abwate abanto bang’ana ase eema yaye.” ");
INSERT INTO guz_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Abaisraeli bagakora bo, bagasangereria abande enyinge, na abande enke. ");
INSERT INTO guz_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Korende ekero bayerengete ase ebirengo, oyosangereretie enyinge tatigaria kende, na ere oyosangereretie enke taremeretwe gento. Kera oyomo konya osangereirie buna okoria kwaye kwang’ana. ");
INSERT INTO guz_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa akabateebia, “Monto onde tatigaria endagera ende goika mambia.” ");
INSERT INTO guz_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Korende tibaigwera Musa; abande bagatigaria eyende goika rituko ria kabere, na mambia yaye bakayenyora yagundire na yasoirwe namakonde, na Musa akababea mono. ");
INSERT INTO guz_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ase igo kera emambia bakaba bagosangereria kera oyomo buna okoria kwaye kwang’ana; korende ekero omobaso oyesambire, yanyititoka. ");
INSERT INTO guz_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ase rituko ria gatano na rimo baba bagosangereria endagera eria ekerengo ara kabere, ase kera omonto ebimunu bine. Abagaaka bonsi b’omoganda bakagenda goteebia Musa amang’ana ayio. ");
INSERT INTO guz_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ere akabairaneria, “Ring’ana erio nario Omonene konya atebiire: Ankio nerituko richenu ri’ogotimoka, Esabato Enchenu yaatananirwe ase Omonene. Mosambe eki moganetie gosamba, na moiyeke eki moganetie koiyeka, na ebiratigare mobigache goika ankio.” ");
INSERT INTO guz_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Na buna Musa abachigete bakagacha endagera eria yatigarete goika rituko ria kabere; ero tiyagunda etioke, gose tiyasogwa namakonde. ");
INSERT INTO guz_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa akabateebia, “Karie eye reero, ekiagera reero n’Esabato yaatananirwe ase Omonene, ekiagera reero timokoyerora isiko ase erooro. ");
INSERT INTO guz_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ase amatuko atano na rimo mobe mokoyesangereria endagera eye, korende rituko ria gatano na kabere n’Esabato, endagera eyio tegotoka.” ");
INSERT INTO guz_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ase rituko ria gatano na kabere abande ase abanto baria bakagenda koyesangereria, tibayenyora. ");
INSERT INTO guz_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Omonene agateebia Musa, “Ngoika ririri morabe mokwanga ogotebereria kwane na amachiiko aane? ");
INSERT INTO guz_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Inyora ng’a inche Omonene nabaeire Esabato. Ase rituko ria gatano na rimo nkobaa endagera y’amatuko abere. Ase ayio, ase rituko eri ria gatano na kabere mobeere kera omonto aase aye, onde tabaisa korua inka.” ");
INSERT INTO guz_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Naboigo abanto bakaba bagotimoka ase rituko ria gatano na kabere. ");
INSERT INTO guz_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Abaisraeli bakaroka endagera eyio mana; ero nigo yare buna chinyeke chi’amaemba enkomba, chindabu, na obwansu bwaye nigo bware buna omogati ore nobooke. ");
INSERT INTO guz_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa akabateebia, “Omonene otochikiire togache endagera eye inke ya Mana ase engencho ye chinderia chiaito, erinde banyare gocha korora endagera eye Omonene atoete torie ase erooro, ekero atorusetie korwa ase ense ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa agateebia Aroni, “Imokia ekeguuru, obeke ebimunu bibere bia mana imeo, oyebeke ase obosio bw’Omonene egachwe ase engencho y’ebigori bigochi‐gocha.” ");
INSERT INTO guz_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Buna Omonene achigete Musa, naboigo Aroni ayebegete bosio bw’Esanduki ere ne chibao chiriikire oborori, ekagachwao. ");
INSERT INTO guz_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Abaisraeli bakagenderera koria mana engaki y’emiaka emerongo ene, goika bagaika aase ense abanto bamenyete; ense yarenge orobebe rw’ense ya Kaanani. ");
INSERT INTO guz_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ekerengo ki’ebimunu bibere ekio nensemo ya ikomi y’ekerengo gi’efa.) ");
INSERT INTO guz_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Omoganda bwonsi bw’Abaisraeli okaimoka korwa erooro ya Sinai. Barabwo bakabwatia orogendo rwabo, bakana‐gotoora buna Omonene abachiigete, Bagaika Refidimu, bagatoora aroro, korende mache tarengeo abanto baare konyara konywa. ");
INSERT INTO guz_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Erio abanto bakomania Musa, bagoteeba, “Toe amaache tonywe!” Musa akabateebia, “Nase ki mokonyomania? Nase ki mogoteema Omonene?.” ");
INSERT INTO guz_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Agwo bakaba nerang’o enene y’amaache, bakemurunganeria Musa, bakaboora, “Ninki gwatoruseria Misiri gocha aa, amo nabana baito ne chitugo chiaito, togokwa ase erang’o?” ");
INSERT INTO guz_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa akarera ase Omonene, akabora, “Ninki ngokorera abanto aba? Barabwo nigo bare ang’e kong’aka amagena.” ");
INSERT INTO guz_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Omonene akairaneria Musa, “Oete bosio bwa abanto aba, oire abagaaka bande b’Abaisraeli, oire boigo nenyimbo yao, eria kwaagete orooche, motang’ane abanto mogende. ");
INSERT INTO guz_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nondore inteneine agwo ase egetare kia Horebu, nkoganyete. Oake egetare, na amaache arwe aroro, erinde abanto banyore banywe.” Musa agakora bo ase amasio ’abagaaka b’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Akaroka aase aria Masa na Meriba, ase engencho y’eriomana ri’Abaisraeli, naende ekiagera abanto bamoteemete Omonene, bakoboora, “Inee! Omonene nare aa ase egati yaito, gose taiyo?” ");
INSERT INTO guz_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Erio Abaameleki bakaoroka na korwania Abaisraeli aaria Refidimu. ");
INSERT INTO guz_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Erio Musa agateebia Yoshua, “Tochorere abanto bagende korwana n’Abaameleki ankio; inche ninche ’ntenene ekegoro igoro, na enyimbo ya Nyasae in’yebwate koboko kwane.” ");
INSERT INTO guz_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yoshua agakora buna Musa amotebetie, akarwania Abaameleki, na Musa, na Aroni, na Huri bagatiira gochia ekegoro igoro. ");
INSERT INTO guz_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ekaba Musa kaimokirie amaboko aye igoro, rirorio Abaisraeli babua, na kayairanirie inse, Abaameleki babua. ");
INSERT INTO guz_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ekero amaboko a Musa arosire, Aroni na Huri bakaimokia rigena, bakaritereka inse, na Musa akariikaransera. Erio bakaba bagosiira amaboko a Musa, oyomo okoboko gwo korio, na oyonde ogwokobee. Naboigo bakamosiira goika erioba rikagwa. ");
INSERT INTO guz_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Na igo Yoshua akabua Abaameleki kegima, akabaita nemioro. ");
INSERT INTO guz_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Omonene agateebia Musa, “Yarike amang’ana aya ase egetabu, abe amang’ana ’okoinyorwa, oteebie Yoshua ng’a ninsirie Abaameleki erio bebwe kegima, tibaabaisa koinyorwa inse y’erioba.” ");
INSERT INTO guz_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa akaagacha egesasiimero agwo, agakeroka “Yahwe Nisi”, engencho yaye, “Omonene nebendera yane y’esegi”, ");
INSERT INTO guz_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","agateeba, “Ninyimokie okoboko kwane igoro, kobe ekemanyererio ki’Omonene, na gotiana ng’a Omonene nigo aragenderere korwania Abaameleki ebiaare ase ebiaare.” ");
INSERT INTO guz_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jethiro, Omokuani o Midiani, ise biara Musa, akaigwa amang’ana onsi aya Nyasae akorerete Musa na Abaisraeli, abanto baye, na buna abang’anyetie korwa Misiri. ");
INSERT INTO guz_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jethiro akaretana Sipora moka Musa ekiagera Musa konya omoiranirie ase ise. ");
INSERT INTO guz_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Naboigo akarentana Gerisomu na Eliezeri, abana abamura babere ba Musa. (Musa nigo ateebete, “Nabeire omomenyi ase ense engeni”), na akaroka omwana oyomo Gerisomu. ");
INSERT INTO guz_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Boigo akaroka omwana oye okabere Eliezeri agateeba, “Nyasae o tata obeire omokonyi one, agantooria korwa ase ogoita gwa Farao”. ");
INSERT INTO guz_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Nabo Jethiro, ise biara Musa, amo na moka Musa na abana baye babere, bagacha ase erooro aase Musa konya atoorire ase egetunwa kia Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Konya otomire amang’ana ase Musa buna ngocha are aretane moka Musa nabana baye babere. ");
INSERT INTO guz_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Erio Musa agasoka komoorotota, agatung’ama na komonyunyunta. Ekero bakwananirie bagasoa ase eema. ");
INSERT INTO guz_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa agateebia ise biara aya onsi Omonene akorerete Farao amo n’Abamisiri ase engencho y’Abaisraeli, na obokong’u bwonsi obwo banyorete inchera, naende buna Omonene abatooretie. ");
INSERT INTO guz_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ekero Jethiro aigwete amaya onsi Nyasae akorerete Abaisraeli ase okobatooria korwa ase amaboko ’Abamisiri akagoka mono, ");
INSERT INTO guz_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","akabora, “Omonene atogigwe, oyo obatooretie abanto baye korwa ase amaboko ’Abamisiri, na korwa ase Farao. ");
INSERT INTO guz_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Bono namanyire ng’a Omonene nomonene kobua chinyasae chinde chionsi, ekiagera atooririe abanto baye korwa ase Abamisiri abwo baabaenenerete.” ");
INSERT INTO guz_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Erio Jethiro ise biara Musa akamoruera Nyasae ekeng’wanso ki’ogosambwa na ebing’wanso binde bi’okonyenywa. Aroni amo nabagaaka bonsi b’Abaisraeli bagacha bakaragera amo nere, ase obosio bwa Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Rituko ria kabere Musa agaikaransa kogamba ebiina bi’abaanto; na abanto nigo barengeo bamoetanaine korwa mambia goika mogoroba. ");
INSERT INTO guz_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ekero ise biara Musa aroche onsi aya Musa are gokorera abanto, akamobooria. “Inki eke ogokorera abanto? Naki oikaransete aye bweka, na abanto bagoetanaine korwa mambia goika mogoroba?” ");
INSERT INTO guz_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa akamoiraneria ise biara, “Nekiagera abanto bagonchichera, bakorigia oboraai bwa Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ekero bomanire nigo bagocha ase ’nde, na inche nabagambera ebiina biabo na kobamanyia emeroberio ya Nyasae na amachiiko aye.” ");
INSERT INTO guz_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Erio Jethiro agateebia Musa, “Enchera eye y’okobagambera ebiina biabo teri engiya. ");
INSERT INTO guz_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nigo okorosigwa, aye amo nabaanto aba bonsi bare aa. Naki emeremo eye nemerito mono asore, tokonyara koyekora aye bweka. ");
INSERT INTO guz_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Bono ntegerera, ngoteebie chisemi chingiya orakore, na Nyasae nabe amo naye. Aye kabe oyo ogotenenera abanto ase obosio bwa Nyasae, na komoirera amang’ana abo. ");
INSERT INTO guz_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Goika oborokererie amachiiko na emeroberio, na obateebererie buna ebagwenerete babe na gokora. ");
INSERT INTO guz_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Korende ochore abanto abamoirogete Nyasae, abegenwa, abatakorigia riaaki, abaranyare koba abaraai b’abaanto b’emeganda elifu, ne rigana, na emerongo etano, na ikomi. ");
INSERT INTO guz_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Otige barabwo babe bakogambera abanto ebiina bia botambe. Ebiina ebikong’u birobio bakobirentere, korende ebire ebike babigambe barabwo boka. Ase enchera eyio egurube yao tekoba endito mono, ekiagera barabwo mbayebogorie amo naye. ");
INSERT INTO guz_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Korakore igo, buna Nyasae aragochiikere, aye nonyore chinguru chi’okogenderera, na abanto aba bonsi ’nabagende chinka chiabo bare nomorembe.” ");
INSERT INTO guz_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa agancha amang’ana aya ise biara amosemetie. ");
INSERT INTO guz_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Agachora abanto b’Abaisraeli abaranyare gokora emeremo eyio, akababeeka babe abaraai b’Abaisraeli, b’emeganda elifu, ne rigana, na emerongo etano, na ikomi. ");
INSERT INTO guz_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Barabwo bakaba bakogamba ebiina bi’abaanto botambe. Ebiina ebikong’u baba bakobirentera Musa, korende ebire ebike baba bakobigamba abanyene. ");
INSERT INTO guz_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Erio Musa agakooba ise biara, akamotiga okogenda ase ense yaye. ");
INSERT INTO guz_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Rituko rie ritang’ani ri’omotienyi o gatato magega Abaisraeli kobarure ase ense ya Misiri, bagaika ase erooro ya Sinai. ");
INSERT INTO guz_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Bakamanora korwa Refidimu, bagaika ase erooro ya Sinai, bagatoora kororia egetunwa gia Sinai. ");
INSERT INTO guz_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa agatiira gochia egetunwa igoro koumerana na Nyasae. Omonene akamorangeria agwo ase egetunwa, akamoteebia, “Amang’ana aya naro orateebie abanto b’egesaku kia Yakobo, baria Abaisraeli: ");
INSERT INTO guz_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Inwe mwarorire aya nakoreire Abamisiri, na buna nababogoretie inwe buna ekeongo ekobogoria amage aye ase chimbaaba chiaye, nabarentire aiga ase ’nde. ");
INSERT INTO guz_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Bono komoranyigwere na kobwata okobwatana kwane kw’ogotianania, rirorio inamobe abanto baane. Naki ense yonsi neyane, korende inwe inamobe abanto baane abachore kobua abanto b’ebisaku binde. ");
INSERT INTO guz_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Inwe inamobe oborwoti bwane, abanto bagonkorera buna abakuani, egesaku kiane egechenu. Amang’ana aya naro orateebie Abaisraeli.” ");
INSERT INTO guz_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Erio Musa akagenda akarangeria abagaaka b’Abaisraeli amo, akabateebia amang’ana ayio onsi Omonene amochigeete. ");
INSERT INTO guz_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Na abanto bonsi amo bakairaneria, bakaboora, “Ayio onsi Omonene atebiire, inatoyakore.” Musa nere akairera Omonene amang’ana abanto bairaneretie. ");
INSERT INTO guz_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Omonene agateebia Musa, “Ninchiche asore inde ase riire ririto ime, erio abanto aba baigwe kongokwana naye, na barabwo bakwegene botambe.” Erio Musa agateebia Omonene amang’ana abanto bairaneretie. ");
INSERT INTO guz_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Omonene agateebia Musa, “Genda ase abanto aba, obachene reero na ankio, naende obateebie basibie chianga chiabo, ");
INSERT INTO guz_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","bebeke ang’e goika mambia ende ekiagera ase rituko erio ria gatato, inche Omonene ning’ike ase egetunwa gia Sinai, agwo ase abanto bonsi barandore. ");
INSERT INTO guz_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Aye goika obekere abanto aba orobebe roetanane egetunwa eke, obateebie: Mwerende, timotiira ase egetunwa igoro, gose timokuna chinsinyo chiaye. Onde bwensi oragekune nigo araitwe akwe. ");
INSERT INTO guz_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Okoboko kw’omonto onde tigokuna omonto orakore ayio, korende nigo araakwe amagena gose araswe nemegwe. Aya achikirwe ase Mwanyabaanto na ase ching’iti, korende ekero egetureeri kerabugigwe, erio nario abanto baratiire gocha ase egetunwa.” ");
INSERT INTO guz_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa agatirimboka korwa ase egetunwa gochia ase abanto, akabachena, na barabwo bagasibia chianga chiabo. ");
INSERT INTO guz_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Musa akabateebia, “Mwebeke ang’e, na goika rituko ria gatato, timobaisa goika abakungu baino ang’e.” ");
INSERT INTO guz_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ase rituko ria gatato ekero kia mambia bikaba enkoba na okomesa, ne riire ririto rigaika ase egetunwa, na eriogi ri’egetureeri rikooga mono. Abanto bonsi ase egetwori bakaondoka na koiguswa. ");
INSERT INTO guz_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Erio Musa agatang’ana abanto korwa ase egetwori bachie koumerana na Nyasae. Barabwo bagatenena ase egetunwa mbarabare. ");
INSERT INTO guz_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Egetunwa gionsi gia Sinai kegatubwa nerioki, ekiagera Omonene aigete aroro ore ase omorero ime; na erioki rigachongororoka gochia igoro buna eri’eriko rinene ri’oboturi, na egetunwa ekegima gekanyegerigwa mono. ");
INSERT INTO guz_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Eriogi ri’egetureeri rikagenderera kwoga mono kobua. Musa agakwana, na Nyasae akamoiraneria nogoaka gw’enkoba. ");
INSERT INTO guz_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Omonene agaika ase egechuria ki’egetunwa gia Sinai, akarangeria Musa agende asare, na Musa agatiira gochiao. ");
INSERT INTO guz_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Eri’Omonene agateebia Musa, “Tirimboka gochia inse ase abanto, obakuurere tibatamboka orobebe bache kondora. Baise gokora igo, abange babo mbakwe. ");
INSERT INTO guz_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Na abakuani barabwo kobagocha ase ’nde, inche Omonene, goika bechene, timbaisa kobaa egesusuro.” ");
INSERT INTO guz_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa agateebia Omonene, “Abanto aba tibakonyara gotiira gocha aa ase egetunwa gia Sinai, ekiagera aye omonyene ngwatokania, ogatoteebia: Beka orobebe roetanane egetunwa, na ogiatanane kebe egechenu.” ");
INSERT INTO guz_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Omonene akamoteebia, “Tirimboka gochia inse, orente Aroni, motiire nere gocha aa. Korende abakuani na abanto tibaabaisa gotamboka orobebe gocha aa ase ’nde, mbaise kobaa egesusuro.” ");
INSERT INTO guz_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Erio Musa agatirimboka gochia ase abanto, akabateebia amang’ana ayio. ");
INSERT INTO guz_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nyasae agakwana amang’ana aya onsi, agateeba, ");
INSERT INTO guz_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Inche ninche Nyasae Omonene, oyokorusetie ase ense ya Misiri, ase ense y’obosomba. ");
INSERT INTO guz_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Toba ne chinyasae chinde otatiga inche. ");
INSERT INTO guz_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Tobaisa gwekorera omogwekano bw’ogosasimwa, omogwekano o getongwa kende gionsi kere igoro, gose kere ense, gose kere ime ase amaache inse y’ense. ");
INSERT INTO guz_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tobaisa gotugama gose gosasiima emegwekano ekorire, ekiagera inche ninche Nyasae Omonene, Nyasae bwe risemi. Ase engencho y’amabe yabaibori nigo nkoa abana egesusuro goika ekiaare kia gatato na egia kane, abwo bangechete. ");
INSERT INTO guz_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Korende nigo nkoborokia obwanchani bwane botari koera goika ebiaare chilifu, ase abwo banyanchete na babwatete amachiiko aane. ");
INSERT INTO guz_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Toriatora bosa na korikorera bobe erieta ria Nyasae Omonene, ekiagera Omonene tagotiga komoa egesusuro omonto oria okoriatora bosa na korikorera bobe erieta riaye. ");
INSERT INTO guz_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Riinyore na korisika rituko ri’Esabato, orirende ribe richenu. ");
INSERT INTO guz_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Amatuko atano na rimo okore emeremo yao yonsi, ");
INSERT INTO guz_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","korende rituko ria gatano na kabere nerituko ri’Esabato, riatananetwe na Nyasae oo. Ase rituko erio tokora emeremo ende yonsi, aye, gose omwana oo, omomura gose omoiseke, nonya nomosomba oo, omomura gose omoiseke, gose chitugo chiao, gose omomenyi ore ase omochie oo. ");
INSERT INTO guz_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Naki ase amatuko atano na rimo nar’Omonene atongete igoro na ense, ne chinyancha, na bionsi ebire imeo; agatimoka ase rituko ria gatano na kabere. Ase ayio Omonene agasesenia rituko ri’Esabato, akariatanana ribe richenu. ");
INSERT INTO guz_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Sika iso na nyoko, nario oramenye amatuko amange ase ense eye Omonene, are ang’e gokoa. ");
INSERT INTO guz_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Toita. ");
INSERT INTO guz_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Totomana. ");
INSERT INTO guz_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Toiba. ");
INSERT INTO guz_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Tomotebera omogisangio oo oborimo. ");
INSERT INTO guz_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Tobaisa kogania enyomba y’omoamate oo. Tobaisa kogania omokungu bw’omoamate oo, nonya nomosomba oye, omomura gose omoiseke, gose eng’ombe yaye, gose etigere yaye, gose kende gionsi omoamate oo abwate.” ");
INSERT INTO guz_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ekero abanto bonsi barooche okomesa, na koigwa enkoba na eriogi ri’egetureeri na korora egetunwa gekoimoka erioki, bakaiguswa, bagatenenera aare. ");
INSERT INTO guz_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Barabwo bagateebia Musa, “Kwana naintwe aye omonyene, na intwe inatogotegerere, korende Nyasae takwana naitwe ekiagera ogokwana naintwe, nigo torakwe.” ");
INSERT INTO guz_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa akabairaneria, “Timoondoka! Naki Nyasae nigo achire kobateema inwe, erio egere mogenderere komoiroka, erinde timokora ebibe.” ");
INSERT INTO guz_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Abanto bonsi bagatenena aare, korende Musa ere akagenda ang’e ase riire riria rimwamu, ase Nyasae arenge. ");
INSERT INTO guz_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Omonene agateebia Musa, “Amang’ana aya naro orateebie Abaisraeli: Inwe abanyene mwarorire ng’a nigo nakwanire nainwe korwa igoro. ");
INSERT INTO guz_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Timwekorera chinyasae chinde chi’echifeta gose echie chitaabu chi’ogosasimwa; monsasime inche bweka. ");
INSERT INTO guz_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ong’agachere egesasiimero ki’amaroba, onduere ebing’wanso igoro yaye, ebing’wanso bi’ogosambwa, na ebi’omorembe, korwa ase ching’ondi chiao, ne chiombe chiao. Kera aase ndatebe onsasimere, ninchiche asore, ngosesenie. ");
INSERT INTO guz_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Onye gokong’agachera egesasiimero ki’amagena, tokeagacha namagena abaachire; ekiagera onye gokoyabaacha nebikorero biao, rirorio kwayabekire riko. ");
INSERT INTO guz_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Naende totiirera ebiriinero igoro, gokogenda ase egesasiimero, egetirianda kiao tikebaisa kooroka.” ");
INSERT INTO guz_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Aya naro amachiiko orae Abaisraeli.” ");
INSERT INTO guz_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Koragore omosomba Omoiberania, nigo aragokorere ase engaki y’emiaka etano nomo, korende omwaka o gatano na kabere mosibore agende ko tomoakana kende. ");
INSERT INTO guz_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Onye ochete bwoo tarenge na mokungu, rirorio nabo aragende bweka, korende onye orenge nomokuungu, omokungu oye nigo aragende amo nere. ");
INSERT INTO guz_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Onye omonene oye omonyuomeretie omokungu, na ere omoiboreire abana, abamura gose abaiseke, omokungu oria na abana baye nigo barabe enibo y’omonene oye; omosacha oria nigo ararueo ere bweka, ");
INSERT INTO guz_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Korende omosomba oria karatebe: Nimwanchete omonene one amo na mokane, na abana baane, tinganeti korua ase obosomba bwane, ");
INSERT INTO guz_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","erio omonene oye amorente ase obosio bwa Nyasae, amoikie ase egesieri gose ase emetobwa ya gesieri na amotue ogoto kwaye n’esindake. Erio omonto oria abe omosomba oye ase obogima bwaye bwonsi. ");
INSERT INTO guz_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Omonto karaoonie omwana oye omoiseke koba omosomba, omoiseke oyio tagosiborwa buna abasomba abamura barasiborwe. ");
INSERT INTO guz_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Onye omoiseke oyio tagwenereti omonene oye, oyorengereretie komokora abe mokaye, rirorio nigo araboorigwe airane. Omonene oye takoba ne ribaga komoonia ase egesaku ekegeni, ekiagera among’ainete. ");
INSERT INTO guz_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Onye okomoa omomura oye abe mokaye, rirorio amwanche buna omwana oye omoiseke. ");
INSERT INTO guz_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Onye omonto oyio okonyuoma omokungu o kabere, takorina oria omotang’ani endagera yaye, ne chianga chiaye na kende gionsi aganetie buna mokaye. ");
INSERT INTO guz_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Atamokorereti amang’ana aya atato, goika aegwe ribaga arue bwoye ataakaneiri embooria.” ");
INSERT INTO guz_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Monto onde bwensi oraake omonto na amoite akwe, nere goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Korende onye tamong’erete otatiga Nyasae omobegete ase amaboko aye, erio ninkworokie aase omoiti oria aratamere. ");
INSERT INTO guz_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Korende omonto ogoita oyomwabo mweno ase obong’ainereria, ere goika aitwe akwe, naisa gotamera egesasiimero kiane. ");
INSERT INTO guz_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Onde bwensi oraake ise gose ng’ina, nere goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Onde bwensi oraibe omonto goika aitwe akwe, karabe omoonirie gose omobwate ase amaboko aye. ");
INSERT INTO guz_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Onde bwensi oraragererie ise gose ng’ina, nere goika aitwe akwe.” ");
INSERT INTO guz_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Abanto babere kobarabe bakorwana, na oyomo aake oyonde rigena, gose enkundi, amoate chingoma, echio chiramokore omorwaire goika araare borere, ");
INSERT INTO guz_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","karabe otimokire, naende asoke isiko gotaara ogwesiirera enyimbo, rirorio oria omoagete nigo aratigwe, otatiga amoakane ase engencho y’eng’eria eria asiririe ekero arwarete, na ere amorende goika agwene kegima. ");
INSERT INTO guz_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Omonto karaake omosomba oye, omomura gose omoiseke, nenyimbo, erinde akwere ase amaboko aye, goika aegwe egesusuro. ");
INSERT INTO guz_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Korende omosomba oyio karagenderere koba moyo rituko erimo gose abere, omonto oyio takoegwa egesusuro, ekiagera omosomba oyio nenibo yaye. ");
INSERT INTO guz_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Abanto abasacha kobarabe bakorwana, na kogwera omokungu ore morito, na oborito bwaye bogwe, korende atabeti na bobe bonde, omonto oria omogwerete goika aakane buna omosacha bw’omokuungu oria araborie magega abagaambi kobanachire ekiina. ");
INSERT INTO guz_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Korende omokungu oria karakwe, rirorio egesusuro kebe obogima ase obogima, ");
INSERT INTO guz_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eriso ase eriso, na erino ase erino, okoboko ase okoboko, na okogoro ase okogoro, ");
INSERT INTO guz_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ogosambwa ase ogosambwa, na eriote ase eriote, naende ogosionorwa ase ogosionorwa. ");
INSERT INTO guz_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Omonto karaake omosomba oye, omomura gose omoiseke, na komwata eriso, rirorio goika amotige abe omosibore ase engencho y’eriso riaye. ");
INSERT INTO guz_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Naende Karamoake omosomba oye omomura gose omoiseke amogookore erino, goika amotige abe omosibore ase engencho y’erino riaye.” ");
INSERT INTO guz_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Eeri eise goita omonto, omosacha gose omokungu, ne ching’unchara chiaye, goika eakwe amagena ekwe, ne chinyama chiaye tichiriegwa; korende omonyene eng’ombe eyio taegwa egesusuro. ");
INSERT INTO guz_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Korende eeri eyio, onye enarete goita abanto, na omonyene eeri eyio okuureirwe, na ere tayesibeti, ero keraite omonto, omosacha gose omokungu, nigo eraakwe amagena ekwe, na omonyene nere aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Onye embooria ekoborigwa korwa asare, goika arue chionsi echi chiraganigwe, chibe embooria ase obogima bwaye. ");
INSERT INTO guz_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Onye eng’ombe egoita omomura gose omoiseke ne ching’unchara chiaye, ogochika nakwo okwo okomo. ");
INSERT INTO guz_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Onye eeri egoita omosomba, omomura gose omoiseke, omonyene eng’ombe nigo araakane omonyene omosomba oria chisekeli chi’echifeta emerongo etato, na eeri eria eitwe ase ogoakwa amagena. ");
INSERT INTO guz_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Omonto karatige engoro yasie, gose onye okunyire engoro na tayekuneka, na eng’ombe gose etigere egwe imeo, ");
INSERT INTO guz_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","rirorio omonyene engoro goika aakane omonyene etugo chitaabu. Erio eng’iti eria y akuure ebe eyaye. ");
INSERT INTO guz_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Eeri y’omonto keraite ey’omonto onde ekwe, erio barabwo baoonie eeri eyio ere moyo, baatanane chitaabu echio, baatanane ne chinyama chi’eng’ombe eria y akuure boigo. ");
INSERT INTO guz_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Korende onye emanyekanete ng’a eeri eria nigo enarete goita abanto, na omonyene tayesibeti, goika aakane omonyene eeri eria y akuure ase okomoa eeri eria ere moyo; na eria y akuure ebe eyaye.” ");
INSERT INTO guz_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Omonto karaibe eng’ombe gose eng’ondi na koyenyenya, gose ayeoonie, nigo araakane chiombe isano ribaga ri’eng’ombe eyemo, ne ching’ondi inye ribaga ri’eng’ondi eyemo. ");
INSERT INTO guz_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Igo emogwenerete aakane chionsi. Onye tabwati gento, ere omonyene goika aoonigwe ase engencho y’oboibi bwaye. Onye etugo eyio aiba ekonyorekana ase amaboko aye ere moyo, aakane ara kabere, onye neng’ombe, gose etigere, gose eng’ondi. Omoibi karanyorekane ogotagora enyomba botuko ase okoiba, nere aitwe akwe: omonto oria omoita takobarerwa oboiti obwo. Korende onye nigo amoita kobwakiire, rirorio nigo arabarerwe oboiti obwo. ");
INSERT INTO guz_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Omonto kararisie etugo yaye ase omogondo bw’endagera, gose oyo bw’emesabibu, na gotiga riicho riaye ririe endagera y’omonto onde, nere goika aakane endagera enoru korwa ase omogondo oye, gose eyere engiya korwa ase emesabibu yaye. ");
INSERT INTO guz_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Onye omonto ogosamba omorero, na omorero oyio bwesiarere gochia ase amagwa, na emesaima y’endagera ere ase omogondo eyie, omonto oria goika aakane yonsi pi. ");
INSERT INTO guz_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Omonto karae omoiri oye chitaabu, gose ebinto binde biaye amogachere, na birobio biibwe korwa nyomba mwaye, omoibi karanyorekane goika aakane ara kabere. ");
INSERT INTO guz_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Korende atanyorekaneti, oria omonyene enyomba arentwe ase obosio bw’ekegambero, erinde amanywe gose nere obiibete. ");
INSERT INTO guz_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Eriomana rinde rionsi riise gotuboka, onye igoro y’eng’ombe, gose etigere, gose eng’ondi, gose eanga, gose gento kende gionsi kerasire, na omonto oyomo aamererie ng’a nekiaye, ekiina ekio ki’abaanto abwo babere nigo keraarentwe ase obosio bw’egesasiimero. Na oria Nyasae araorokie ng’a nomomochi, goika aakane oria onde ara kabere. ");
INSERT INTO guz_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Omonto karae omoiri oye etigere, gose eeri, gose eng’ondi, gose etugo ende yonsi ebe sagare, na etugo eria eitwe gose eakwe, gose eirwe monto tarora, ");
INSERT INTO guz_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","omoiri oria goika atenene bosio bw’ekegambero atiane ase Omonene ng’a takuneti enibo aetwe sagare. Omonyene etugo eria goika anche ng’a ayio atianwa namaene, na tagoakanwa. ");
INSERT INTO guz_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Korende onye nigo yaibwa korwa asare ere goika aakane omonyene oria. ");
INSERT INTO guz_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Onye yariegwa nenyang’au, arente chinyama chintigari chibe kirori, taakana ase eye enyang’au yaitete. ");
INSERT INTO guz_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Omonto karasabe na koegwa etugo sagare korwa ase omoiri oye, na etugo eyio keraakwe gose ekwe, na omonyene tayerochi, omonto oria goika ayeakane. ");
INSERT INTO guz_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Onye omonyene abao ekero egoakwa gose egokwa, rirorio tagoakanwa. Onye etugo eyio yarenge eyogoakanerwa rirerio, ogoakanerwa okwo kobe kogoisanera ogosirerwa okwo. ");
INSERT INTO guz_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Omonto karamoege na gosaria omoiseke omwekungi otararierwa boko, goika aakane enibo eraisane erio amonyuome. ");
INSERT INTO guz_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Korende onye ise omoiseke okwanga, tamomoa, omonto oyio goika aakane chitaabu chireng’aine rigori ri’omoiseke omwekungi. ");
INSERT INTO guz_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Totiga omokungu omoorogi abe moyo. ");
INSERT INTO guz_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Omonto oraraare neng’iti goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Omonto oraruere enyasae ende yonsi ekeng’wanso, otatiga Omonene bweka, goika asirigwe kegima. ");
INSERT INTO guz_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Tobaisa gokorera omomenyi bobe, gose komochegia, ekiagera nainwe abanyene mwarenge abamenyi ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Tochanda omoboraka onde bwensi, gose omwana entakana oyo abaibori baye bakuure. ");
INSERT INTO guz_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Oise kobachanda abwo, na barabwo kobaraarere ase ’nde, amaene, inche ninyigwe ekerero kiabo. ");
INSERT INTO guz_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Endamwamu yane inayoke, na inche mbaite n’omoro, na abakungu baino nababe ababoraka, na abana baino babe chintakaana batari nabaise. ");
INSERT INTO guz_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Oise komoa singo omonto onde one omotaka ore ase egati yaino, tobaisa gokora buna abwo bakoa abanto singo na koboria ebitoki ebinge; tobaisa komoboria ebitoki. ");
INSERT INTO guz_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","“Onye kogosaba omonto onde egetambaa kiaye akwambara kebe intenenera, goika omokeiranerie erioba ritaragwa, ");
INSERT INTO guz_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ekiagera nakio gioka abwate akwebisia. Eke nakio abwate gekomobekera riberera ase omobere oye. Inee! Otakemoeti, inki rende araraarere? Ere karaarere ase ’nde, ekeene, nimoigwe, ekiagera inche nomonyamaabera. ");
INSERT INTO guz_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tobaisa korama Nyasae, gose koragereria omorai bw’abaanto bao.” ");
INSERT INTO guz_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Totebana kondetera ogotongora kwao kwe rigesa ri’endagera na eri’emesabibu. Ong’e omwana oo omomura omotangi ase abana bao, abe oyone. ");
INSERT INTO guz_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ong’e boigo chimori chintangi chi’echiombe, ne chimaanwa chintangi chi’eching’ondi. Ochitige chikoore amatuko atano na abere, ko rituko ria gatano na gatato ochindetere. ");
INSERT INTO guz_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Mobe abanto baane abachenu; timobaisa koria eng’iti ende yonsi eyaitirwe nenyang’au ase orosana, motugutere chisese chinyama echio.” ");
INSERT INTO guz_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Tobaisa gosiarera oborimo, na tobaisa gokengera omokori amabe ase okomobera kirori bw’oborimo. ");
INSERT INTO guz_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tobaisa koba ensemo y’abare abange kobarigetie gokora amabe, gose tobaisa kobakorera abwo bare abange ogwanchereria na gotanga oboronge ase okoba kirori bw’okoonchorana oboronge. ");
INSERT INTO guz_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tobaisa gwanchereria omonto omotaka ase ekiina kiaye. ");
INSERT INTO guz_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Oise korora eng’ombe y’omobisa oo gose etigere yaye egosira goika omoyeiranerie. ");
INSERT INTO guz_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Korarore etigere y’oyo okogechete yagure negurube ebogoretie, tobaisa koyeetania, korende oyekonye. ");
INSERT INTO guz_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Tobaisa korina omonto omotaka oboronge bwaye, ekero ekiina kiaye gekogambwa. ");
INSERT INTO guz_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Bwetange kegima korwa ase oborimo, na tobaisa kogera omonyaboronge aitwe, ekiagera inche Omonene tingotiga koa omomochi egesusuro. ");
INSERT INTO guz_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tobaisa gwancha oegwe riaaki, ekiagera riaaki nigo rikoukoria omonto erinde takorora ayare boronge; naende nigo rigosaria ekiina ki’abanyene oboronge. ");
INSERT INTO guz_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Tobaisa gokorera omomenyi bobe, naki inwe momanyete buna omomenyi akoigwa ase enkoro yaye, ekiagera nainwe abanyene mwarenge abamenyi ase ense ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Ase emiaka etano nomo osimeke na kobusura endagera, na ogese ebiamire, ");
INSERT INTO guz_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","korende omwaka o gatano na kabere otige omogondo otimoke, toremwa, korende ebirakine na kwama ase omogondo obitigere abataka, na ebi baratigarie bibe endagera ye ching’iti chi’orosaana. Okore boigo nomogondo oo bw’emesabibu na oyo bw’emezeituni. ");
INSERT INTO guz_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ase amatuko atano na rimo okore emeremo yao, korende ase rituko ria gatano na kabere otimoke, na eng’ombe yao na etigere yao nachirochio chitimoke; naboigo nomosomba oo omomura oiboreire bwoo, na omomenyi oo, nabarabwo batimoke.” ");
INSERT INTO guz_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Motegerere mono onsi aya nabateebirie na moyabwate. Timwatora amarieta ye chinyasae chinde; ayio taigugwa korwa ase emenwa yaino.” ");
INSERT INTO guz_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Kera omwaka nobe kogontwarera Amatuko Amanene ara gatato. ");
INSERT INTO guz_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ase omotienyi bwa Abibu, omotienyi oyio mwaruete ase ense ya Misiri, Goika orende Rituko Rinene ri’Emegati etabekiri memera ase enchera eyio nagochigeete. Naboigo orie emegati etabekiri memera ase amatuko atano na abere buna nagochigeete. Na monto onde tabaisa gocha ase obosio bwane namaboko amasa. ");
INSERT INTO guz_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Naende goika orende Rituko Rinene rie Rigesa ekero okogesa ogotongora gw’okwama kw’omogondo oo gwasimegete na ogakora emeremo. “Orende boigo Rituko Rinene ri’Ogosangereria Rigesa ri’omoerio bw’omwaka ekero ogosangereria okwama kw’emeremo yao emekong’u gwakorete. ");
INSERT INTO guz_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ara gatato kera omwaka abanto bao abasacha babe bagocha ase obosio bwane, inche Omonene Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Tobaisa kondetera amanyinga ’ekeng’wanso amo nomogati obekire ememera. Ebitinya bie chinyama echi nkoruerwa ekeng’wanso ase rituko riane rinene, tibitigara goika bokie rituko rikobwatia. ");
INSERT INTO guz_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Goika orente ogotongora okore okuya korwa ase omogondo oo, ase enyomba yane inche Omonene Nyasae oo. “Tobaisa koiyekera emanwa y’embori ime y’amabeere ’eng’ina.” ");
INSERT INTO guz_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Nintome omomalaika agotang’ane na gokorenda ase enchera, agoikie aase aria nakoroiseirie. ");
INSERT INTO guz_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mwerende ase obosio bwaye, na moigwere aya arabateebie. Tobaisa kwanga komoigwera, ere takomoororera amaabera oyoramoche koigwera ekiagera erieta riane nigo rire ime yaye. ");
INSERT INTO guz_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Korende koramoigwere ere, na gokora ayio onsi nakwanire inche, rirorio nindwanie ababisa bao, ninchande abwo bakogochanda. ");
INSERT INTO guz_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Naki omomalaika one nagotang’ane akoire na kogoikia ase ense y’Abaamori, na Abahiti, na Abaperisi, na Abakanaani, na Abahivi, na Abayebusi, na inche nimbasirie. ");
INSERT INTO guz_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Timosasiima chinyasae chiabo, gose gochikorera; na timokora buna abanto abwo bagokora, korende mosirie kegima emegwekano yabo y’ogosasimwa na moyaiyerie inse amagena abo onsi are aase bagosasimera. ");
INSERT INTO guz_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Momokorere Omonene Nyasae oino, na inche ninsesenie endagera yaino na amaache aino, nindusie amarwaire ase more. ");
INSERT INTO guz_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ase ense yaino mokuungu onde tari oborito bwaye boragwe, gose onde takoba omogomba; nimbae obogima obotambe. ");
INSERT INTO guz_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nintang’anie okwoboyia kwane bosio bwaino, na goichanie na gotantania abanto bonsi abwo morabe mokoumerana nabarabwo; ninkore ababisa baino bonsi baonchoke batame korwa ase more. ");
INSERT INTO guz_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nintome ebiaramba birase na goseria Abahivi, na Abakanaani, na Abahiti, korwa ase Kaanani bosio bwao. ");
INSERT INTO guz_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Tinkobaseria ase omwaka oyomo, ense ebaise koba bosa, ne ching’iti chi’orosana chimenteke chibachande. ");
INSERT INTO guz_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nigo ndabaserie ng’ora ng’ora goika momenteke moisane komenya ense eyio. ");
INSERT INTO guz_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Inche ninkobekere orobebe rwao gochakera Enyancha Embariri goikera Enyancha y’Abafilisti, naende korwa ase erooro goika orooche rwa Eufarati, ekiagera nimbeke ababiare b’ense eyio ase amaboko aino, na inwe mobaseerie, batame korwa ase more. ");
INSERT INTO guz_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tobaisa gokora okobwatana konde gwonsi nabarabwo, gose ne chinyasae chiabo. ");
INSERT INTO guz_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Barabwo tibaamenya ase ense yao, baabaise kogera onkorere ebibe. Onye kogokorera chinyasae chiabo, chirochio nachinyare kogotega.” ");
INSERT INTO guz_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Eri’Omonene agateebia Musa, “Tiira gocha aa ase ’nde, aye amo na Aroni, na Nadabu, na Abihu, na abagaaka b’Abaisraeli emerongo etano na ebere. Mobeere aare ake, motugame inse monsasiime. ");
INSERT INTO guz_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Naye Musa bweka orachiche ong’ike ang’e, korende abwo bande tibang’ika ang’e. Boigo n’Abaisraeli barabwo tibachicha amo naye nonya ng’ake.” ");
INSERT INTO guz_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa akagenda agateebia abanto amang’ana onsi ay’Omonene akwanete, na amachiiko aye onsi. Abanto bonsi bakamoiraneria ase eriogi erimo, bakaboora, “Amang’ana ayio onsi Omonene akwanire inatoyakore.” ");
INSERT INTO guz_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Erio Musa akariika amachiiko onsi ay’Omonene omoete. Erio akaimoka maambia chuni, akaagacha egesasiimero inse ye getunwa, agatenenia amagena ikomi na abere koreng’ana nebisaku ikomi na bibere bi’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Agatoma abamura b’Abaisraeli bakarua ebing’wanso bi’ogosambwa, bakanyenyera Omonene chieri chi’ekeng’wanso ki’omorembe. ");
INSERT INTO guz_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa akabogoria ekeng’ese ki’amanyinga aya, akayabeeka egetaabo ime, na ekeng’ese kende akanyororokeria egesasiimero. ");
INSERT INTO guz_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Erio akaimokia egetabu gi’okobwatana kw’ogotianania agwo ase amariko a Omonene ariikire agasomera abanto bakaigwa, erio Barabwo bakaboora, “Natoigwere na gokora onsi ay’Omonene akwanire.” ");
INSERT INTO guz_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa akaimokia amanyinga aria arenge egetaabo ime, akanyororokeria abanto, akabora, “Aya n’amanyinga okobwatana okw’Omonene akorire ase ogotianania nainwe ase okobaa amachiiko aya onsi.” ");
INSERT INTO guz_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Erio Musa, na Aroni, na Nadabu, na Abihu, na abagaaka baria emerongo etano na ebere b’Abaisraeli bagatiira gochia egetunwa igoro, ");
INSERT INTO guz_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","bakarora Nyasae bw’Abaisraeli. Inse y’amagoro aye nigo arenge buna amagena e rigori rinene akorokwa safiro, are nobokenonoku buna obore igoro. ");
INSERT INTO guz_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Omonene tarambora okoboko kwaye kobakorera bobe abagaaka baria b’Abaisraeli. Barabwo kobarorire Nyasae, bakaria na konywa. ");
INSERT INTO guz_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Omonene agateebia Musa, “Tiira gocha aa ase ’nde egetunwa igoro, oganye aa, na inche nkoe chibao chi’amagena chire namachiiko onsi aya narikireo, ayio ogochia kworokereria abanto.” ");
INSERT INTO guz_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa akaimoka amo nomosomba oye Yoshua, erio ere agatiira gochia egetunwa kia Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Agateebia abagaaka baria, “Motoganye aiga goika ekero torairane ase more. Rora Aroni na Huri nao bare aiga amo nainwe; onye omonto ore nobokong’u bonde, agende ababorie.” ");
INSERT INTO guz_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Erio Musa agatiira gochia egetunwa igoro, ne riire rikagetuba. ");
INSERT INTO guz_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Obonene bw’Omonene bogaacha bokabeera igoro y’egetunwa gia Sinai, ne riire rikagetuba ase engaki y’amatuko atano na rimo. Rituko ria gatano na kabere Omonene akarangeria Musa korwa riire gati. ");
INSERT INTO guz_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ase Abaisraeli obonene bw’Omonene bokarorekana buna omorero ogosiria, ase egetunwa igoro. ");
INSERT INTO guz_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa agasoa riire ime, agatiira gochia egetunwa igoro, akabeera aroro ase engaki y’amatuko emerongo ene, omobaso na obotuko. ");
INSERT INTO guz_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Bateebie Abaisraeli ng’a bandetere ebiegwa; aye obisangererie korwa ase kera omonto oyoranche kobirua ase ’nde. ");
INSERT INTO guz_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Na ebiegwa orasangererie korwa ase bare nabio ebi: chitaabu, ne chifeta, ne chitaai; ");
INSERT INTO guz_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri; egatani engiya na amanya e chimbori; ");
INSERT INTO guz_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","amasankwa e chimingichi aakire etaago, na amasankwa amaterere e ching’iti chia rooche, ne chibao chi’emekonge; ");
INSERT INTO guz_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","amaguta e chitaaya, na ebinto bi’okoroisia amaguta akwaakwa abachore, na ebi’okoroisia ubani ye rimusu rigiya; ");
INSERT INTO guz_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","amagena e rigori rinene, buna oiniki na ayande, akobekwa ase egesibao ki’Omokuani na ase egesembe kiaye. ");
INSERT INTO guz_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Obateebie bandoiserie Obomenyo Obochenu, na inche inyare komenya ase egati yabo. ");
INSERT INTO guz_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Mondoiserie Obomenyo na ebinto bionsi ebirabeo, buna ndakworokie.” ");
INSERT INTO guz_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Mondoiserie Esanduki ye chibao chi’omokonge. Obotambe bwaye bobe obw’ekerengo ki’amaboko abere na ekeng’ese, na obogare bwaye okoboko okomo na ekeng’ese, na obotambe bwaye gochia igoro okoboko okomo na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Oyeome netaabu echenire ime na isiko, oyeetananie omong’orooria bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Okore chibonyi inye chi’echitaabu, ochibeke ase amagoro aye ane, ibere ase kera ensemo. ");
INSERT INTO guz_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Obaache emiaro ebere y’emekonge, oyeoome netaabu. ");
INSERT INTO guz_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Osoyie emiaro eyio ase chibonyi ime ase okobogoreria Esanduki eria. ");
INSERT INTO guz_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Emiaro eyio goika ebe ime ase chibonyi echio, terusigwao. ");
INSERT INTO guz_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ime y’Esanduki eria obeke chibao echi chiriikire oborori, echi ndakoe.” ");
INSERT INTO guz_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Oroisie ekemumeko gi’etaabu echenire kebe Oboikaranso bwa amaabera. Obotaambe bwaye bobe ekerengo ki’amaboko abere na ekeng’ese, na obogare bwaye okoboko okomo na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Naende okore emegwekano y’ebitongwa bibere bibwate chimbaba ey’etaabu esunyuntire, oyebeke ase chinsinyo ibere chi’Ekerogo Kiamaabera, ");
INSERT INTO guz_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","oyomo ase kera ensinyo. Oyekore ebe egento ekemo n’Ekerogo kia Amaabera. ");
INSERT INTO guz_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ebitongwa bibwate chimbaba abwo barambore chimbaaba chiabo igoro y’ekerogo kiamaabera, babobekere ekiriri, na amasio abo abe achikaine, na barabwo barigererie ekerogo kiamaabera. ");
INSERT INTO guz_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Oterekerere ekerogo kia amaabera igoro y’Esanduki eria. Erio obeke imeo chibao echi chiriikire oborori, echi ndakoe. ");
INSERT INTO guz_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Agwo ninchiche ng’umerane naye. Korwa igoro y’ekerogo kia amaabera, gati‐gati y’ebitongwa bibwate chimbaba aba babere bare igoro y’Esanduki ere ne chibao chiriikire oborori, nimbe ngokwana naye igoro y’amachiiko aya ngochia koa Abaisraeli goetera asore.” ");
INSERT INTO guz_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Oroisie emesa ye chibao chi’emekonge. Obotambe bwaye bobe obw’ekerengo ki’amaboko abere, na obogare bwaye okoboko okomo, na obotambe bwaye gochia igoro okoboko okomo na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Oyeome netaabu echenire, oyeetananie omong’ororia bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Erio obeke orosingo robe nobogare bong’ana egesanyi gi’okoboko, na oroetananie omong’ororia bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Okore chibonyi inye chi’echitaabu ase emesa eria, ochibeeke ase chikoona inye ase amagoro aye, ");
INSERT INTO guz_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ang’e norosingo; na emiaro esoigwe imeo, erinde emesa enyare kobogorerigwa. ");
INSERT INTO guz_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Obaache emiaro eria korwa ase emekonge, oyeome netaabu, nero emesa erabogorerigwe. ");
INSERT INTO guz_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Oroisie chinteru na ebitaabo ase ubani, ne chisani, korwa ase ebio bagocha koumora ebinyugwa ebikoruegwa. Obiroisie bionsi korwa ase chitaabu chichenire. ");
INSERT INTO guz_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ase emesa eyio obeke emegati erabe ekoruegwa ase ’nde, imbe nkoyerora botambe.” ");
INSERT INTO guz_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Oroisie ekebekerero gie chitaaya gi’etaabu echenire esunyuntire, okeroisie na enterekerero amo ne ritina na emegwekano y’amamumu na ebisicha, bionsi bibe egento ekemo. ");
INSERT INTO guz_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Chinsagia isano nemo chibe chigosoka korwa ase ritina, isato korwa ase ensemo eyemo, na isato korwa ase ensemo ende. ");
INSERT INTO guz_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Orosagia rwe ritang’ani robe nemegwekano etato y’ebisicha binga buna ebi’omolozi, kera ekemo kebe ne rimumu na egesicha, na orosagia rwa kabere boigo robe nemegwekano etato y’ebisicha binga buna ebi’omolozi; ne chinsagia chionsi isano nemo chibe boigo. ");
INSERT INTO guz_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ritina rinyene ri’ekebekerero keria ribe nemegwekano ene y’ebisicha binga buna ebi’omolozi, kera ekemo kebe ne rimumu na egesicha. ");
INSERT INTO guz_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Rimumu erimo ribe inse ya kera chinsagia ibere chigosoka korwa ase ritina. Ase ayio amamumu abe inse ye chinsagia echio isano nemo, chiroisigwe chibe egento ekemo ne ritina. ");
INSERT INTO guz_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Amamumu ayio amo ne chinsagia biroisigwe bibe egento ekemo ne ritina, bionsi biroisigwe korwa ase ribomba erimo ri’etaabu echenire esunyuntire. ");
INSERT INTO guz_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Oroisie chitaaya isano na ibere, ochibeke igoro y’ekebekerero keria, erinde chimoreke gochia bosio. ");
INSERT INTO guz_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ebinachi ne chindogio chiaye biroisigwe korwa ase chitaabu chichenire. ");
INSERT INTO guz_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Okorere chitaabu chichenire chikiro emerongo etano ase okoroisia ekebekerero gie chitaaya amo nebikorero biaye. ");
INSERT INTO guz_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Origererie buya obikore buna nakworogetie ase egetunwa.” ");
INSERT INTO guz_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Oroisie eema y’Obomenyo nebitambaa ikomi biroisirie korwa ase chiusi chi’egatani chisisire amo ne chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri. Omoroisia omong’aini abiroisie bibe nemegwekano y’ebitongwa bibwate chimbaba. ");
INSERT INTO guz_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Obotambe bwa kera egetambaa bobe obw’ekerengo ki’amaboko emerongo ebere, na atano na atato, na obogare bwaye amaboko ane. Ebitambaa ebio bionsi bibe bi’ekerengo ekemo. ");
INSERT INTO guz_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ebitambaa bitano bibwatanigwe bibe rirondia erimo. Naboigo nebitambaa binde bitano. ");
INSERT INTO guz_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Okore ebioro bie chiusi chiburu, obibeke ase ensinyo y’egetambaa eke kere ensinyo y’ensemo eyemo ya kera rirondia. ");
INSERT INTO guz_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Okore ebioro emerongo etano, obibeke ase egetambaa kegochakera rirondia rie ritang’ani, na emerongo etano ase egetambaa kegokoorera rirondia ria kabere. Ebioro bia kera rirondia bibe bichikaine. ");
INSERT INTO guz_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Oture ebigobanio bie chitaabu emerongo etano, obwateranie amarondia ayio abere amo, ebe eema eyemo y’Obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Oroisie amarondia ikomi na rimo ay’amanya e chimbori, abe eema y’ogotuba Obomenyo obwo. ");
INSERT INTO guz_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Obotambe bwa kera rirondia bobe obw’ekerengo ki’amaboko emerongo etato, na obogare bwaye amaboko ane. Amarondia onsi ikomi na rimo abe ay’ekerengo ekemo. ");
INSERT INTO guz_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Obwatanie amarondia atano amo, na amarondia ande atano na rimo oyabwateranie ao. Erio oringe erimo rirondia ria gatano na rimo igoro y’egesoero ki’eema. ");
INSERT INTO guz_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Okore ebioro emerongo etano, obibeke ase ensinyo ye rirondia rinene rie ritang’ani, na emerongo etano ase rirondia rinene ria kabere rigochakera. ");
INSERT INTO guz_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Oture ebigobanio emerongo etano bi’etai ase ebioro biria, obwatanerie amarondia ayio abere abe eema eyemo engima. ");
INSERT INTO guz_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ekeng’ese kie rirondia riria kementire kebekwe gesung’unane, getube magega y’Obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ekerengo gi’okoboko okomo kie rirondia keringwe, getube Obomenyo ase kera rikere riaye. ");
INSERT INTO guz_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Oroisie rirondia ri’amasankwa e chimingichi aakire etaago, ribe rigotuba eema, ne rirondia rinde ri’amasankwa amaterere e ching’iti chia rooche, ribe rikobekwa igoro ye rirondia rie ritang’ani. ");
INSERT INTO guz_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Oroisie chibao chi’emekonge ase Obomenyo, echio chiratenenigwe. ");
INSERT INTO guz_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Obotambe bwa kera ebao bobe obw’ekerengo ki’amaboko ikomi, na obogare bwaye okoboko okomo na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Okore chintamang’o ibere ase kera ebao, ase chibao echio chirabwatanerigwe. Naboigo oranyare koroisia chibao chionsi chi’Obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Koraroisie chibao echio, oroisie emerongo ebere ase ensemo ya Irianyi. ");
INSERT INTO guz_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Oroisie ne chinterekerero chi’echifeta emerongo ene, chibe ibere ibere ase kera ebao ase okobwaterania chintamang’o chiaye ibere. ");
INSERT INTO guz_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ase ensemo ya sugusu y’Obomenyo oroisie chibao emerongo ebere, ");
INSERT INTO guz_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","amo ne chinterekerero chi’echifeta emerongo ene, ibere ibere ase kera ebao. ");
INSERT INTO guz_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ase ensemo ya magega y’Obomenyo eyerochie bosongo, oroisie chibao isano nemo, ");
INSERT INTO guz_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","naende chibao ibere chie chikoona chi’Obomenyo ensemo ya magega. ");
INSERT INTO guz_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kera ebao ase echio ibere ebwatanigwe ne chibao chie chinsinyo, korwa inse goika igoro ase ebonyi entang’ani ere. Ase enchera eyio chibao ibere chibekwe ase chikoona ibere. ");
INSERT INTO guz_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Chibao chionsi nigo chirabe isano na isato, ne chinterekerero chiabo chi’echifeta ikomi na isano nemo, ibere ibere inse ya kera ebao. ");
INSERT INTO guz_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Obaache emeriibo ye chibao chi’emekonge, etano ase okoriiba chibao chie rikere erimo ri’Obomenyo, ");
INSERT INTO guz_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na etano ase okoriiba chibao chie rikere rinde, na etano y’ensemo ya magega, eyerochie bosongo. ");
INSERT INTO guz_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Omoriibo o gati‐gati obekwe omogima, oriibe korwa ensinyo eyemo goika eyende. ");
INSERT INTO guz_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Oome chibao echio netaabu na okore chibonyi chi’echitaabu ase emeriibo erasoigwe, na emeriibo eria oyeoome netaabu. ");
INSERT INTO guz_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Otenenie Obomenyo obwo buna nakworogetie ase egetunwa. ");
INSERT INTO guz_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Oroisie etoto ye chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo ne chiusi chi’egatani engiya, chisisire. Omoroisia omong’aini ayeroisie ebe nemegwekano y’ebitongwa bibwate chimbaba. ");
INSERT INTO guz_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Osunge etoto eria y’egetambaa ase chisiiro inye chi’emekonge chioomire netaabu, chire nebigobanio bie chitaabu, chiratenene ase chinterekerero inye chi’echifeta. ");
INSERT INTO guz_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Osunge etoto eria inse y’ebigobanio, obeke Esanduki eyere ne chibao chiriikire oborori moino y’etoto. Etoto eria yaatanane Aase Aachenu korwa ase Aase Aachenu Mono. ");
INSERT INTO guz_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Erio obeke oboikaranso bw’amaabera igoro y’Esanduki eria ere ne chibao chiriikire oborori ime y’Aase Aachenu Mono. ");
INSERT INTO guz_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Obeke emesa isiko y’etoto ensemo ya sugusu, na ekebekerero gie chitaaya ensemo ya Irianyi, ase Obomenyo ime. ");
INSERT INTO guz_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Naende ase egesoero ki’eema oroisie egetambaa korwa ase chiusi chi’egatani engiya chisisire, amo ne chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, buna omoroisia omong’aini aranyare gokeroisia. ");
INSERT INTO guz_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Naende obaache chisiiro isano chi’emekonge ase ogosunga egetambaa ekio, ochioome netaabu; oture ebigobanio bie chitaai. Okore chinterekerero inye chie chitaai chinyititoire, chibe ase chisiiro echio.” ");
INSERT INTO guz_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Oagache egesasiimero gie chibao chi’emekonge. Obotambe bwaye bobe obw’ekerengo ki’amaboko atano, na obogare bwaye amaboko atano, nabo chinsemo chionsi inye chibe chireng’aine; na obotambe bwaye gochia igoro bobe obw’ekerengo ki’amaboko atato. ");
INSERT INTO guz_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ase chikoona inye chi’egesasiimero oroisie emegwekano ye ching’unchara inye. Ching’unchara echio nigo chirabe egento ekemo negesasiimero; oome gionsi netai. ");
INSERT INTO guz_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Okore chindogio chi’okobuucha ribu korwa ase egesasiimero. Naende okore ebichiko, na ebitaabo, ne chigami, ne chindogio chi’okorenta omorero. Ebinto ebi bionsi biroisigwe korwa ase chitaai. ");
INSERT INTO guz_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Okore boigo egechungi gi’etai na obeke chibonyi inye chie chitaai ase chikoona chiaye inye. ");
INSERT INTO guz_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Obeke egechungi eke korwa inse y’orosingo geike gochia gati‐gati y’egesasiimero. ");
INSERT INTO guz_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Obaache emiaro y’emekonge ase egesasiimero ekio, oyeome netai. ");
INSERT INTO guz_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Oyesoyie ase chibonyi echio chie chinsemo ibere chi’egesasiimero, ebeo ekero gekobogorigwa. ");
INSERT INTO guz_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Egesasiimero keagachwe ne chibao, ime getigwe giasaime. Okeroisie buna kworogetigwe ase egetunwa.” ");
INSERT INTO guz_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Oroisie eraaro y’Obomenyo. Ase ensemo ya Irianyi oroisie ebitambaa bie chiusi chindabu chi’egatani chisisire, bibe ekerengo ki’amaboko rigana erimo, bibe bigokenga eraaro ensemo eyemo. ");
INSERT INTO guz_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Chisiiro chikobibwata chibe emerongo ebere chie chitaai, ne chinterekerero chiabo emerongo ebere chie chitaai. Ebigobanio bie chisiiro chiria ne chinuga chiabo chibe chi’echifeta. ");
INSERT INTO guz_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Naboigo ase ensemo ya sugusu oroisie ebitambaa bire nobotambe bw’ekerengo ki’amaboko rigana erimo, bisiirwe ne chisiiro emerongo ebere, ne chinterekerero chiabo emerongo ebere chie chitaai. Ebigobanio amo ne chinuga chiabo bibe bie chifeta. ");
INSERT INTO guz_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ase obogare bw’eraaro ensemo ya bosongo oroisie ebitambaa bi’ekerengo ki’amaboko emerongo etano, ne chisiiro ikomi, amo ne chinterekerero chiabo ikomi. ");
INSERT INTO guz_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Obogare bw’ensemo ya bosio, erochie moocha, bobe obw’ekerengo ki’amaboko emerongo etano. ");
INSERT INTO guz_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ase ensemo eyemo y’egesoero bibe ebitambaa bi’ekerengo ki’amaboko ikomi na atano, bisiirwe ne chisiiro isato ne chinterekerero chiabo isato. ");
INSERT INTO guz_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Naboigo nensemo ende y’egesoero bibekwe ebitambaa bi’ekerengo ki’amaboko ikomi na atano, bisiirwe ne chisiiro isato, amo ne chinterekerero chiaye isato. ");
INSERT INTO guz_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Na ase egesoero oroisie egetambaa gi’ekerengo ki’amaboko emerongo ebere, korwa ase chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo ne chiusi chi’egatani engiya chisisire, ebe emeremo y’omoroisia omong’aini. Egetambaa ekio gesiirwe ne chisiiro inye ne chinterekerero chiabo inye. ");
INSERT INTO guz_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Chisiiro chionsi echietanaine eraaro nigo chirabe ne chinuga na ebigobanio bie chifeta, ne chinterekerero chiabo chibe chie chitaai. ");
INSERT INTO guz_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Obotambe bw’eraaro eyio bobe obw’ekerengo ki’amaboko rigana erimo, na obogare bwaye amaboko emerongo etano. Egetambaa keria geetanaine eraaro kebe nobotambe gochia igoro bw’ekerengo ki’amaboko atano na keroisigwe ne chiusi chi’egatani engiya chisisire. Chinterekerero chi’eraaro chibe echie chitaai. ");
INSERT INTO guz_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ebikorero bi’Obomenyo ebirabe bigokorerwa ase emeremo ende yonsi, amo nebirochi bi’ebitambaa na ebi’eraaro bionsi, nigo birabe ebie chitaai.” ");
INSERT INTO guz_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ochike Abaisraeli barente amaguta amaya, amitire korwa ase amazeituni, akobekwa ase chitaaya kera rituko, chibe chikogenderera gwoka botambe. ");
INSERT INTO guz_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ime y’Eema y’Omosangererekano, isiko y’etoto eria ekeng’ete aase chibao chirikire oborori chibekire, Aroni na abamura baye inababe bakorenda chitaaya chiria chigwoka korwa mogoroba goika mambia, ase obosio bw’Omonene. Okwo nigo korabe ogochika ase Abaisraeli ebiare ase ebiare.” ");
INSERT INTO guz_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Orangerie Aroni, momura omino, omobeke abe ange naye boigo nabamura baye obatanane korwa ase Abaisraeli, erio obarente ase obosio bwao, babe bagonkorera emeremo y’obokuani, ere Aroni amo nabamura baye Nadabu, na Abihu, na Eleazari, na Itamari. ");
INSERT INTO guz_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Oroiserie Aroni, momura omino, chianga chinchenu chi’obonene na echi’oboseera. ");
INSERT INTO guz_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Oteebie abaroisia abang’aini, abwo naeire obong’aini ne chisemi, baroiserie Aroni chianga, erinde aatananwe abe ogonkorera emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ne chianga baramoroiserie nachio echi: Egesembe ki’obokuani, na egesibao ki’obokuani, na eganchwa, na eganchwa ende erobekanirie egoika inse, na ekegogwa, na orokini. Bakorere Aroni amo nabamura baye chianga chinchenu, erio babe bagonkorera emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Nabwo abaroisia bachiroisie korwa ase chiusi chi’echitaabu, na echi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya. ");
INSERT INTO guz_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Bakore egesibao ki’obokuani korwa ase chiusi chi’echitaabu na echi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya chisisire; keroisigwe nomooroisia omong’aini. ");
INSERT INTO guz_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Egesibao ekio ki’obokuani kebe nebitwanga bibere bi’amareko, aase gekobwateranigwa. ");
INSERT INTO guz_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Orokini rw’okobwataneria egesibao ekio amo robe rw’egetambaa keria ki’egesibao, keroisirie korwa ase chiusi chi’echitaabu, na echi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya chisisire. ");
INSERT INTO guz_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Orente amagena abere a oiniki, na ase amagena ayio omang’ere amarieta ’abamura ba Israeli: ");
INSERT INTO guz_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","amarieta atano na rimo ase rigena erimo, na atano na rimo ase rigena rinde, ase omooroberio bw’okoiborwa kwabo. ");
INSERT INTO guz_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ase chisemi chi’omooroisia omanyete buya gotura na komang’a ekemanyererio, omang’e amarieta ’abamura ba Israeli ase amagena aria abere. Erio obeke amagena aria ase ebikonde bie chitaabu. ");
INSERT INTO guz_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Oyabeeke ase ebitwang’a bi’amareko bi’egesibao keria ki’obokuani, abe ase okoinyora abamura ba Israeli. Naboigo Aroni abogorie amarieta abo ase amareko aye abere, abe ekeinyorio ase obosio bw’Omonene botambe. ");
INSERT INTO guz_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Oture ebikonde bibere bi’etaabu, ");
INSERT INTO guz_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na okore ebichanga bibere bie chitaabu chichenire, bisisire buna engori, bibwatanigwe nebikonde biria. ");
INSERT INTO guz_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Oroisie egesembe gi’ekina ase Omokuani. Omoroisia omong’aini akeroisie ase egetambaa kere buna eki’egesibao ki’obokuani, korwa ase chiusi chi’echitaabu, na echi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya chisisire. ");
INSERT INTO guz_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Egesembe keria kebe keringire rimo. Obotambe bwaye bobe chisentimita emerongo ebere, na ibere, na obogare bwaye boigo. ");
INSERT INTO guz_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Obeke emeng’ororia ene y’amagena e rigori rinene ase egesembe keria. Ase omong’ororia bw’eritang’ani obeke saridio, na topasio, na sumaridi; ");
INSERT INTO guz_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","na ase oyo o kabere alimasi, na safiro, na yasipi; ");
INSERT INTO guz_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","na ase oyo o gatato hiakinto, na agati, na ametisito; ");
INSERT INTO guz_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","na ase oyo o kane kurusolito, na oiniki, na berulo. Amagena ayio onsi abekwe ase ebikonde bie chitaabu. ");
INSERT INTO guz_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Amagena ayio nigo arabe ikomi na abere, abe namarieta ’abamura ba Israeli. Amarieta ayio amang’erwe buna omonto akomang’a ekemanyererio. Kera rigena ribe nerieta ri’egesaku ekemo ki’ebisaku biabo ikomi na bibere. ");
INSERT INTO guz_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Okore ebichanga bie chitaabu chichenire bisisire, bibekwe ase egesembe keria. ");
INSERT INTO guz_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Okore boigo chibonyi ibere chi’etaabu, ochibeke ase emego ya igoro y’egesembe keria. ");
INSERT INTO guz_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Osiberanie ebichanga ebi bibere bie chitaabu ase chibonyi chi’emego ya igoro y’egesembe keria. ");
INSERT INTO guz_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Chinsinyo chinde chi’ebichanga biria bibere ochisiberanie nebikonde biria bibere, naende obibwateranie bionsi ase ebitwanga bi’amareko bire bosio ase egesibao ki’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Okore chibonyi chinde ibere chi’echitaabu, ochibeke ase egesembe keria ase emego ebere ya inse korwa magega, echigeete egesibao. ");
INSERT INTO guz_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Naende okore chibonyi chinde ibere chi’echitaabu, ochibwateranie ase ebitwanga biria bibere bi’amareko bi’egesibao bire bosio, ang’e nomobarero, igoro y’orokini rw’egesibao. ");
INSERT INTO guz_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Chibonyi chiria chibekire ase egesembe chibwateranigwe ne chibonyi chi’egesibao neusi eburu; erio egesembe keria kebeere orokini igoro, tigecha gosuka. ");
INSERT INTO guz_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Naboigo Aroni arabogorie amarieta ’abamura ba Israeli ase egesembe keria gi’ekina igoro y’enkoro yaye ekero agosoa ime y’Aase Aachenu, ayarente abe ekeinyorio botambe ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Obeke Urimu na Tumimu (engencho yaye omobaso na oboikeranu) ime y’egesembe gi’ekina bibe igoro y’enkoro ya Aroni, ekero akogenda ase obosio bw’Omonene. Ekero Aroni are ase obosio bw’Omonene abogorie ekiorokererio gi’ekina botambe ase engencho y’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Okore eganchwa korwa ase egetambaa keroisirie ne chiusi chire buru chioka. ");
INSERT INTO guz_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Obochore engoro gati gati, ase omotwe ogosoera, oyebeke ekenario buna egi’esati, techa gotandoka. ");
INSERT INTO guz_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Okore emegwekano y’amatunda e rikomomanga korwa ase chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, oyebeke eetanane omoringero o inse. Ase egati ya kera omogwekano bwe rikomomanga obeke chindege chi’echitaabu. ");
INSERT INTO guz_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Naboigo ebe emegwekano ye rikomomanga bwateranie ne chindege chi’echitaabu bietanane omoringero o inse bw’eganchwa. ");
INSERT INTO guz_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aroni goika ayebeke eganchwa eyio ekero agokora emeremo y’obokuani, na eriogi rie chindege chiria riigweke ekero agosoa Aase Aachenu ase obosio bw’Omonene, na ekero agosoka, erio tabaisa gokwa. ");
INSERT INTO guz_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Okore ebao y’etaabu echenire, na buna omonto akomang’a ekemanyererio omang’ere amang’ana ayio: “Achenirwe ase Omonene”. ");
INSERT INTO guz_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Oyesiberanie bosio bw’ekegogwa ne chiusi chire buru. ");
INSERT INTO guz_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aroni ayebogorie ase obosio bwaye igoro. Ase igo abogoreranie na korusia amamocho are nebiegwa ebiraatananwe, ebi’Abaisraeli barabe bakoruera Omonene. Aroni nigo arabe okoyebogoria botambe ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Oroisie eganchwa entambe amo nekegogwa korwa ase chiusi chi’egatani engiya, na orokini rwe chiusi chire ne chirangi ao ao. ");
INSERT INTO guz_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Erio oroiserie abamura ba Aroni chiganchwa, ne chinkini; naende obaroiserie ebigogwa emechoro bi’ogosika na ebi’oboseera: ");
INSERT INTO guz_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Obekere Aroni, momura omino, amo nabamura baye, chianga echio. Erio obaake amaguta, obaatanane na kobachena, babe bagonkorera emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Obaroiserie chisirwari chi’egatani, chigoika amariagati abo, chibe chigotuba obogetirianda bwabo. ");
INSERT INTO guz_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aroni na abamura baye goika bachibeke botambe ekero bagosoa Eema y’Omosangererekano, gose kobakogenda ase egesasiimero gokora emeremo y’obokuani Aase Aachenu ime, tibaabaisa kwerentera okomocha na gokwa. Oko nogochika koragenderere ase Aroni na ororeria rwaye. ");
INSERT INTO guz_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Aya naro orakore ase Aroni na abamura baye ase okobaatanana, babe bagonkorera emeremo y’obokuani: Orusie eeri ensae ne chimingichi ibere chitari na kemocho ase emebere yabo. ");
INSERT INTO guz_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Orusie boigo emegati etabekiri memera na amaandasi atabekiri memera, biroisirie namaguta, na emegati emeoo eakire amaguta. Emegati eyio yonsi eroisigwe korwa ase obosie obonuke bw’engano. ");
INSERT INTO guz_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Oyebeke ase egetonga, oyendetere ebe egetonga ime ekero okondetera ekeng’wanso ki’eeri na egie chimingichi chiria ibere. ");
INSERT INTO guz_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Erio orente Aroni amo nabamura baye ase egesoero ki’Eema y’Omosangererekano, obasibie namaache. ");
INSERT INTO guz_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Oimokie chianga chiria, obekere Aroni: Eganchwa erobekanirie egoika inse, na eganchwa eria ende, na egesibao ki’obokuani na egesembe keria; omoboerie norokini rw’egesibao. ");
INSERT INTO guz_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Omobekere na ekegogwa omotwe oye, na ase ekegogwa eke osiberanie ekemanyererio keria egechenu gekoorokia ng’a bwatananirwe. ");
INSERT INTO guz_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Erio oimokie amaguta akweakwa, omonyoororokerie ase omotwe oye, omoyaake na omobeke ensemo ase emeremo emechenu. ");
INSERT INTO guz_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Orente na abamura baye, obabeekere chianga. ");
INSERT INTO guz_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Obaboerie chinkini ebinema biabo, Aroni na abamura baye, na obabeekere ebigogwa emetwe yabo. Ase enchera eyio bwatanane Aroni amo nabamura baye obabeeke ensemo babe bagonkorera emeremo y’obokuani kogenderera botambe. ");
INSERT INTO guz_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Orente eeri bosio bw’Eema y’Omosangererekano; Aroni na abamura baye babeeke amaboko abo ase omotwe bw’eeri eyio. ");
INSERT INTO guz_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Erio oyenyenyere ase obosio bw’Omonene ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Oimokie amanyinga make y’eeri, erinde ogindie nekiara kiao emegwekano ye ching’unchara chi’egesasiimero. Na amanyinga amatigari oyaumore inse ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Orusie ebitinya biria bitubete chinyama chi’enda; naboigo nebi’eriini, ne chinyigo chionsi ibere, amo nebitinya bichitubete; obisambere ase egesasiimero igoro. ");
INSERT INTO guz_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Korende chinyama chieeri eyio, ne risankwa, enda na eura yonsi obisambere isiko y’egetwori. Ekio nekeng’wanso ase engencho y’ebibe. ");
INSERT INTO guz_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Orente emingichi eyemo ase echio ibere, na Aroni na abamura baye babeeke amaboko abo ase omotwe oye. ");
INSERT INTO guz_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Erio oyenyenye na oitorore amanyinga aye ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Onache chinyama chi’emingichi eria chibe ebing’ese; osibie chinyama chi’enda eria amo nebirenge, na obibeeke igoro y’ebing’ese biria na omotwe oye. ");
INSERT INTO guz_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Osambere chinyama echi chionsi chi’emingichi ase egesasiimero igoro. Eke nekeng’wanso ki’ogosambwa ase Omonene, ekeng’wanso ki’omorero kere ne rimisu rigiya rikogwenera Omonene. ");
INSERT INTO guz_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Erio orente emingichi eria ende, na Aroni na abamura baye babeeke amaboko abo ase omotwe oye. ");
INSERT INTO guz_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Magega y’ayio oyenyenye, orusie amanyinga make, na ase amanyinga ayio ogindie mesia y’ogoto kwa borio kwa Aroni amo na mesia y’amato ’abamura baye; ogindie boigo ebiara ebinene bi’amaboko abo a borio, na ebiara ebinene bi’amagoro abo a borio. Oitorore amanyinga amatigari ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Orusie amanyinga make ayare ase egesasiimero, na amaguta ayio akweakwa, onyororokerie Aroni ne chianga chiaye, na abamura baye, ne chianga chiabo. Naboigo Aroni na abamura baye baatananwe ase emeremo emechenu, amo ne chianga chiabo. ");
INSERT INTO guz_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Orusie ebitinya bi’emingichi eyio, na omokera oye ore omonoru, na ebitinya bitubete chinyama chi’enda, na ebi’eriini, ne chinyigo chionsi ibere amo nebitinya bichitubete, na ebachwa ya borio, ekiagera emingichi eyio nigo yarurwe ase ogwatanana abakuani ase emeremo emechenu. ");
INSERT INTO guz_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Orusie omogati oyomo, ne rindasi erimo riroisirie namaguta, na omogati oyomo omoo, ebio bitabekiri memera, bire ase egetonga ime, bibekire ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ebi bionsi obibeeke ase amaboko Aroni amo nay’abamura baye, obisungusie bibe okoruegwa ase Omonene. ");
INSERT INTO guz_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Erio obirusie ase amaboko abo, obisambere ase egesasiimero igoro y’ekeng’wanso keria kere ne rimisu rigiya rikogwenera Omonene. Eke nekeng’wanso ki’omorero. ");
INSERT INTO guz_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Obogorie ritaana ri’emingichi eyio yarurwe ase ogwatanana Aroni, orisungusie ribe okoruegwa ase Omonene. Nerio naribe eriao, erigotungetie korwa ase eng’iti eyio. ");
INSERT INTO guz_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Nabo ekeo Omokuani akobekwa ensemo, naboigo oraatanane ritaana ri’emingichi eyio yarurwe ekeng’wanso amo nekenama kiaye, ebitari ebio bi’emingichi eyio bibe ebitungetie Aroni amo nabamura baye. ");
INSERT INTO guz_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ebi nigo birabe bitungetie Abakuani kogenderera botambe korwa ase Abaisraeli, bibe ekeegwa ki’Omonene korwa ase bare, ekeng’wanso kiabo ki’omorembe. ");
INSERT INTO guz_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Chianga chiria chinchenu chia Aroni nigo chiraegwe ab’ororeria rwaye magega g akuure, bachieboyie ekero bagochia goakwa amaguta na gwatananwa. ");
INSERT INTO guz_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Omomura o Aroni, oyorabogorie emeremo y’obokuani ase ribaga ria ise, goika eboyie chianga echi engaki y’amatuko atano na abere, ekero agochia gosoa Eema y’Omosangererekano na gokora emeremo ime y’Aase Aachenu. ");
INSERT INTO guz_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Oire emingichi eria yarurwe ase ogwatanana abakuani ase emeremo emechenu, oiyekere chinyama chiaye Aase Aachenu. ");
INSERT INTO guz_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Agwo ase egesoero ki’Eema y’Omosangererekano, Aroni na abamura baye barie chinyama chi’emingichi eria amo nemegati ere ase egetonga ime. ");
INSERT INTO guz_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Barabwo barie ebinto ebi biarurwe ase ogokora okobwatanigwa ekero baatananetwe ase emeremo emechenu. Monto onde omoao takoba ne ribaga ri’okobiria, ekiagera ebinto ebi nebichenu. ");
INSERT INTO guz_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Onye chinyama gose emegati bigotigara goika mambia, erio obisambe nomorero; tibibaisa koriegwa, ekiagera nebichenu. ");
INSERT INTO guz_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Naboigo orakorere Aroni amo nabamura baye koreng’ana buna nagochikiire. Ogwatananwa kwabo kobe gokogenderera ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kera rituko orue eeri ebe ekeng’wanso ki’ebibe ase ogokora okobwatanigwa. Ase okorua ekeng’wanso ase okobwatanigwa nigo orabe kogochena egesasiimero. Erio ogeake amaguta na kogiatanana ase emeremo emechenu. ");
INSERT INTO guz_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ase engaki y’amatuko atano na abere obe gokogenderera gokora okobwatanigwa ase egesasiimero na kogechena mono; na kera egento kerabe gekogekuna, nigo kerabe egechenu.” ");
INSERT INTO guz_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Na ebing’wanso orabe gokorua igoro ase egesasiimero nabio ebi: Kera rituko botambe, orue chimanwa ibere chi’eching’ondi echiakoorire omwaka oyomo. ");
INSERT INTO guz_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Emanwa eyemo y’echio oyerue mambia na eria ende mogoroba. ");
INSERT INTO guz_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Amo nemanwa eria entang’ani orue ebimunu bibere bi’obosie obonuke bwochoganirie namaguta amaya, egetuba ekemo na ekeng’ese, amitire korwa ase amazeituni. Naende goika orue edivai egetuba ekemo na ekeng’ese ebe okoruegwa gw’ekenyugwa. ");
INSERT INTO guz_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Emanwa eria ende oyerue mogoroba; oyerue amo nokoruegwa kw’endagera na ogw’ekenyugwa, buna gwakorete mambia, kobe ekeng’wanso ki’omorero kebe ne rimisu rigiya ase Omonene. ");
INSERT INTO guz_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ekeng’wanso eke ki’ogosambwa kebe gekoruegwa ebiaare ase ebiaare botambe agwo ase egesoero ki’Eema y’Omosangererekano, ase obosio bwane, inche Omonene. Agwo ndabe nkoumerana nainwe, naende nkwane naye. ");
INSERT INTO guz_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Agwo ning’umerane n’Abaisraeli, na aase agwo ning’akore abe aachenu nobonene bwane. ");
INSERT INTO guz_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ninchene Eema y’Omosangererekano amo negesasiimero; naboigo ninchene Aroni amo nabamura baye babe bagonkorera ase emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Inche nimenye ase egati y’Abaisraeli, imbe Nyasae obo. ");
INSERT INTO guz_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Erio barabwo nabamanye ng’a inche ninche Nyasae obo; ninche nabarusetie korwa ase ense ya Misiri, erinde imbe imenyete ase egati yabo. Inche ninche Nyasae obo.” ");
INSERT INTO guz_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Oroisie egesasiimero gie chibao chi’emekonge ase ubani egosamberwa. ");
INSERT INTO guz_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Obotambe bwaye bobe obw’ekerengo gi’okoboko okomo, na obogare bwaye okoboko okomo; nabo chinsemo chiaye inye chibe chireng’aine; na obotambe bwaye gochia igoro bobe amaboko abere. Emegwekano yaye ye ching’unchara nigo eraroisigwe ebe egento ekemo negesasiimero. ");
INSERT INTO guz_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Oyeoome netaabu echenire, igoro yaye, ne chinsemo chiaye inye, amo ne ching’unchara chiaye; oyeetananie omong’ororia bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Okore chibonyi ibere chi’echitaabu ochibeke inse y’omong’ororia chinsemo ibere, na emiaro esoigwe imeo, erinde egesasiimero kenyare kobogorerigwa. ");
INSERT INTO guz_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Obaache emiaro eria korwa ase emekonge, oyeoome netaabu. ");
INSERT INTO guz_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Obeke egesasiimero ekio bosio bw’etoto eria ekengete aase aria esanduki egachire, eria ere ne chibao chiriikire oborori amo n’Ekerogo ki’Amaabera igoro yaye. Aase agwo ndabe nkoumerana naye. ");
INSERT INTO guz_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Kera emambia ekero Aroni akoroisia chitaaya nabe ogosambera agwo ubani egotioka buya, ");
INSERT INTO guz_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","naende ekero arabe ogwokia chitaaya engaki ya mogoroba. Ogosambwa okwo kwa ubani nigo koragenderere botambe ase obosio bw’Omonene, ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Timobaisa gosamba ubani eye etachikiri, gose ekeng’wanso ki’ogosambwa, gose okoruegwa kw’endagera, gose timobaisa koumora okoruegwa gw’ekenyugwa igoro yaye. ");
INSERT INTO guz_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ara rimo kera omwaka Aroni akore okobwatanigwa ase ching’unchara chiaye. Naboigo ara rimo kera omwaka nakorere egesasiimero okobwatanigwa namanyinga ’ekeng’wanso ki’ebibe. Ayio nigo arakorerwe ebiaare ase ebiaare. Egesasiimero ekio nagiatananwe kebe egechenu mono ase Omonene.” ");
INSERT INTO guz_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ekero orabe gokobara Abaisraeli ase okorikwa kwabo, kera omonto arue ekeegwa ase Omonene, kebe embooria ase obogima bwaye, tibaabaisa konyora amaakwa ekero bakorikwa. ");
INSERT INTO guz_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ase igo, kera omonto oyorache korikwa goika arue ekeng’ese gi’esekeli ase ekerengo gi’esekeli egokorerwa ase Obomenyo Obochenu, ebe ekeegwa ase Omonene. (Esekeli eyemo nechigera emerongo ebere.) ");
INSERT INTO guz_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kera omonto oyorarikwe, engencho yaye oyokoorire emiaka emerongo ebere na goetania, goika arue ekeegwa eke ase Omonene. ");
INSERT INTO guz_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Oyore omonda takorua goetania ekeng’ese gi’esekeli, gose oyore omotaka takorua inse y’ekio, ekero morarue ekeegwa ekio ase Omonene. Kerokio kebe embooria ase obogima bwaino. ");
INSERT INTO guz_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Koranyore chitaabu echi Abaisraeli bararue chibe embooria, ochikorere ase emeremo y’Eema y’Omosangererekano. Ase igo Abaisraeli babe bakoinyorwa ase obosio bw’Omonene, naende chitaabu echio chibe embooria ase obogima bwabo.” ");
INSERT INTO guz_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Oroisie egetuba gi’etai amo nenterekerero yaye y’etai. Okebeeke egati y’Eema y’Omosangererekano na egesasiimero, na obeeke amaache imeo. ");
INSERT INTO guz_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aroni na abamura baye babe bagwesibia amaache ayio amaboko na amagoro. ");
INSERT INTO guz_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ekero bagosoa ase Eema y’Omosangererekano goika besibie ase amaache ayio, tibaabaisa gokwa; naboigo ekero bakogenda ase egesasiimero ase okoruera Omonene ekeng’wanso ki’omorero ");
INSERT INTO guz_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Barabwo babe bagoisaba amaboko, basibie na amagoro abo, tibaabaisa gokwa. Ekio nigo korabe ogochika koragenderere asare na ase ororeria rwaye ebiaare ase ebiaare.” ");
INSERT INTO guz_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Naende Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Oimokie ebinto bigotioka buya: Amaguta a manemane chikiro ikomi, na omodalasini ore ne rimisu rigiya chikiro isano, na amanukato are ne rimisu rigiya chikiro isano, ");
INSERT INTO guz_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na kasia chikiro ikomi. (Bionsi bibe bi’ekerengo kegokorerwa ase Obomenyo Obochenu). Oimokie na amaguta ’emezeituni ebituba bine. ");
INSERT INTO guz_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ase ebinto ebio oroisie amaguta akweakwa ase chisemi chi’omooroisia omong’aini, abe amaguta amaachenu akweakwa. ");
INSERT INTO guz_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Oake Eema y’Omosangererekano, na Esanduki ere ne chibao chiriikire oborori, ");
INSERT INTO guz_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na emesa amo n’ebinto bireo, na ekebekerero gie chitaaya amo nebikorero biaye, na egesasiimero ase ubani egosamberwa, ");
INSERT INTO guz_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","na egesasiimero ase ebing’wanso bigosamberwa amo nebikorero biaye, na egetuba amo nenterekerero yaye. ");
INSERT INTO guz_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Naboigo oraatanane ebinto ebi, obikore ebichenu kegima, erio onde bwensi orabikune abe omochenu. ");
INSERT INTO guz_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aroni na abamura baye obaake amaguta na kobaatanana babe bagonkorera emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kwana n’Abaisraeli, obateebie ng’a amaguta aya akweakwa abe amaachenu ase ’nde egati yaino ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tabaisa goakwa ase emebere ya Mwanyabaanto bande bonsi. Timoroisia amaguta ande anga buna ayio. Ayio namaachenu, nabe amaachenu ase more. ");
INSERT INTO guz_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Monto onde bwensi aise koroisia amaguta buna ayio gose koyaaka omonto omoao, oyotari Omokuani, nigo araatananwe korwa ase egesaku kiaye.” ");
INSERT INTO guz_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Omonene agateebia Musa, “Oimokie ebinto bigotioka buya: Oborembo bwa nafiti, na amaguta ’amakorogonte na oborembo bwa kalibani, na ebinto binde ebiansu, na ubani engiya; kera egento kebe gi’ekerengo ekemo. ");
INSERT INTO guz_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Korwa ase ebinto ebio oroisie amanukato oyaroisie ase chisemi chi’omooroisia omong’aini ebekwe omonyoo, abe amarabu achenire. ");
INSERT INTO guz_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Orusie bike, erio obiswage bibe obosie. Obeke boke bosio bw’Esanduki ere ne chibao chiriikire oborori, ase Eema y’Omosangererekano, aase ndaumerane naye. Amanukato ayio abe amaachenu mono ase more. ");
INSERT INTO guz_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Timweroiseria amanukato ande onsi y’ogosambwa anga buna ayio. Abe ase more amaachenu ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Monto onde bwensi aise koroisia amanukato anga buna ayio ase okwegokeria rimisu riaye nigo araatananwe korwa ase egesaku ki’abaanto b’Omonene.” ");
INSERT INTO guz_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Rora, nachorire Besaleli, oyore mosinto o Uri, mochokoro o Huri, bw’egesaku kia Yuda. ");
INSERT INTO guz_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Inche Nyasae namoichoirie omoika one, namoeire obong’aini ne chisemi amanye gokora emeremo ende yonsi y’oboroisia, ");
INSERT INTO guz_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","abe oyomanyete koroberia na koroisia ebinto bie chitaabu, ne chifeta, ne chitaai. ");
INSERT INTO guz_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ere abe okobaacha amagena e rigori rinene na koyabeka ase ebikonde, na kobaacha emete, na gokora emeremo ende yonsi y’oboroisia. ");
INSERT INTO guz_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nachorire Oholiabu, mosinto bw’Ahisamaki bw’egesaku kia Dani amokonye ase emeremo eyio. Nabaeire abaroisia bande bonsi obong’aini, erinde banyare gokora ebinto bionsi ebi nagochikiire. ");
INSERT INTO guz_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Barabwo baroisie Eema y’Omosangererekano, na Esanduki ebe ne chibao chiriikire oborori, na Oboikaranso bwa amaabera, na ebinto bionsi bi’Eema eyio, ");
INSERT INTO guz_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","emesa na ebinto birabeo, ekebekerero gie chitaaya gi’etaabu echenire na ebikorero biaye na egesasiimero ase ubani erasamberwe, ");
INSERT INTO guz_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","egesasiimero ase ebing’wanso birasamberwe na ebikorero biaye, na egetuba amo nenterekerero yaye, ");
INSERT INTO guz_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ne chianga chingiya chinchenu chia Aroni Omokuani, na echi’abamura baye, echi barabeeke ekero bagokora emeremo y’obokuani, ");
INSERT INTO guz_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","na amaguta akweakwa, na ubani ere ne rimisu rigiya esamberwe Aase Aachenu ime. Ase ogokora ebinto ebi bionsi goika bakore buna nagochikiire kegima.” ");
INSERT INTO guz_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Omonene agakwana na Musa, akamoteebia. ");
INSERT INTO guz_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Kwana n’Abaisraeli aye omonyene obateebie “Goika morende Chisabato chiane, ekiagera echio nekemanyererio egati yane nainwe ebiaare ase ebiaare, erinde momanye ng’a ninche Omonene oyokobachena. ");
INSERT INTO guz_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ase igo morende rituko ri’Esabato, ekiagera ne rituko richenu ase more. Onde bwensi aise korisaria, nigo araitwe akwe. Onde bwensi aise gokora emeremo ase rituko erio nigo araatananwe korwa ase egesaku ki’abaanto b’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mokore emeremo amatuko atano na rimo, korende rituko ria gatano na kabere n’Esabato Enchenu, rituko ri’ogotimoka, richenu ase Omonene. Onde bwensi aise gokora emeremo ase rituko erio goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Nabo Abaisraeli goika babwate na korenda rituko ri’Esabato ebiaare ase ebiaare, ekiagera oko nokobwatana koragenderere botambe. ");
INSERT INTO guz_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Rituko erio ribe ekemanyererio keragenderere egati yane na Abaisraeli, ekiagera ase amatuko atano na rimo inche Omonene natongete igoro na ense, korende ase rituko ria gatano na kabere ngatiga emeremo yane yonsi, na gotimoka.” ");
INSERT INTO guz_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ekero Omonene akoorire gokwana na Musa agwo ase egetunwa gia Sinai, akamoa chibao ibere chi’amagena chiriikire oborori nekiara kia Nyasae. ");
INSERT INTO guz_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ekero abanto baroche ng’a Musa otebanire goika korwa ase egetunwa, bagasangererekana amo, bagachiera Aroni, bakamoteebia, “Inchuo aa, otokorere enyasae eratotang’ane, ekiagera titomanyeti eki kiamonyorire Musa, oyo otong’anyetie korwa ase ense ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aroni akabateebia, “Rusia ebigera bie chitaabu bire ase amato ’abakungu baino, na ase abana baino, abamura na abaiseke, mobindetere.” ");
INSERT INTO guz_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Erio abanto bonsi bakarusia ebigera bie chitaabu biare ase amato abo, bakamobiirera Aroni. ");
INSERT INTO guz_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ere akanyora ebinto ebi korwa ase amaboko abo, akanyititora chitaabu chiria. Ekero yabwatanire, akayebomba, ekaba omogwekano bw’emori eeri. Abanto bagateeba, “Abaisraeli aba, eye nero enyasae yaino, eyabang’anyetie korwa ase ense ya Misiri.” ");
INSERT INTO guz_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ekero Aroni ayeroche, akaagacha egesasiimero bosio bwaye; erio akararia, akabora, “Ankio nigo rirabe Rituko Rinene ri’Omonene.” ");
INSERT INTO guz_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Rituko ria kabere abanto bakaimoka mambia chuni, bakarua ekeng’wanso ki’ogosambwa, bakarenta na ekeng’wanso ki’omorembe. Abanto bagaikaransa, bakaria na konywa, erio bakaimoka gotenga. ");
INSERT INTO guz_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Korende Omonene agateebia Musa, Tirimboka gochia inse, ekiagera abanto abwo bao kwang’anyetie korwa ase ense ya Misiri besaririe ase ogokora amabe, ");
INSERT INTO guz_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","baonchokire bwango, batigire enchera eria nabachigete gotunyana, bekoreire emori eeri y’etaabu. Bayesasimire na koyeruera ekeng’wanso, bagoteeba, Abaisraeli aba, eye nero enyasae yaino, eyabang’anyetie korwa ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Omonene agateebia Musa, “Narorire abanto aba ng’a nabanyabigoti bikong’u. ");
INSERT INTO guz_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Bono tiga endamwamu yane yoke igoro ase bare, erinde mbasirie, erio ngokore aye obe egesaku ekenene.” ");
INSERT INTO guz_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Korende Musa agasorora Omonene, Nyasae oye, akabora, “Gaaki Omonene nase ki’endamwamu yao ekoberorokera abanto bao, abakwang’anyetie korwa Misiri ase okobua okonene, na ase okoboko kwao gwe chinguru? ");
INSERT INTO guz_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Inee! Nigo origetie Abamisiri bateebe: Igo abarusia aa, oganetie kobaita ase ebitunwa na kobasiria kegima? Ase igo onchoka korwa ase endamwamu yao enene, tokora amabe aya kwarengereirie gokorera abanto bao. ");
INSERT INTO guz_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Inyora abasomba bao Aburaamu, na Isaka, na Israeli, na buna kwabarierete eira ase ogwetiania, okabateebia: Nigo ndamente oroiboro rwaino robe oronge buna ching’enang’eni chia igoro. Nimbae ense eye yonsi nabarierete eira ng’a nimbae ebe omwando obo kare na kare.” ");
INSERT INTO guz_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Eri’Omonene akaonchoka, tabakorera amabe aria konya arengereirie gokorera abanto baye. ");
INSERT INTO guz_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa akeonchora, agatirimboka korwa ase egetunwa igoro, na ase amaboko aye obwate chibao ibere chi’amagena chiriikire oborori chinsemo chionsi ibere, bosio na magega. ");
INSERT INTO guz_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Chibao echio nigo chiaroisetigwe na Nyasae omonyene, na amariko aya nigo ariikire na Nyasae, amang’eire ase chibao chiria. ");
INSERT INTO guz_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoshua akaigwa eriogi ri’abaanto bakwoga, agateebia Musa, “Naigure eriogi ase egetwori, eriogi buna eri’esegi.” ");
INSERT INTO guz_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa akamoiraneria, “Eriogi eri tiriri eri’abaanto babuire esegi, gose eri’okorera kw’abaanto babuirwe, korende eriogi naigure neri’abaanto bagotera.” ");
INSERT INTO guz_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa gaikire ang’e negetwori akarora emori eria, na buna abanto baare gotenga, akaba nendamwamu enene; agaakera inse chibao chiria abwate maboko aye, chigaateka, chikaba ebisamunye ase egetunwa inse. ");
INSERT INTO guz_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Erio akabwata emori eria bakorete, akayesamba na koyesegenya goika ekaba orotu, akaroitera ase amaache ime, na akaa Abaisraeli amaache ayio, na barabwo bakanywa. ");
INSERT INTO guz_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Agwo Musa akaboria Aroni, “Naki abanto aba bagokorete goika okagera bagakora ebibe ebinene buna ebi?” ");
INSERT INTO guz_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aroni akamoiraneria, “Omonene one, toba nendamwamu entindi, aye nomanyete abanto aba ng’a nababe. ");
INSERT INTO guz_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Naki nigo banteebia: Tokorere enyasae eratotang’ane, ekiagera titomanyeti eki kiamonyorire Musa, oyo otong’anyetie korwa Misiri. ");
INSERT INTO guz_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Inche: nkabateebia: Onde bwensi obwate etaabu ayerusie. Barabwo bagachirusia, bagaching’a, na inche ngachiruta ase omorero ime, na emori eye ekabao.” ");
INSERT INTO guz_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa akarora abanto bakoonchobana, na buna Aroni abatigete baonchobaane na gosasiima omogwekano oria, ase amasio ’ababisa babo. ");
INSERT INTO guz_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Agwo Musa agatenena geita ki’egetwori, akabora, “Onde bwensi oyore ensemo y’Omonene ache aa ase ’nde.” Abana bonsi ba Lawi bagasangererekana asare. ");
INSERT INTO guz_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ere akabateebia, Omonene Nyasae, Nyasae bw’Abaisraeli, oteebire iga “Kera oyomo oino abogorie omoyio oye o birende, agende aaria na aaria ase egetwori korwa egeita ekemo goika ekende. Kera oyomo aite onde bwensi aranyore, nonya noyomwabo, gose omosani, gose omogisangio”. ");
INSERT INTO guz_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Abana ba Lawi bagakora buna Musa abateebeetie, na abanto chilifu isato bagaitwa ase rituko erio. ");
INSERT INTO guz_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa akabateebia. “Reero inwe mweatananire ase ogokorera Omonene, kera oyomo ase rigori ria mosubati omwabo gose momura omwabo; ase ig’Omonene obasesenirie reero.” ");
INSERT INTO guz_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Rituko ria kabere Musa agateebia abanto, “Mwakorire ebibe ebinene mono. Na bono ngotiira inde gochia ase Omonene, aande nabo ndabanyorere okobwatanigwa, ekiagera mwakorire ebibe.” ");
INSERT INTO guz_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ase igo Musa akairana gochia ase Omonene, akamoteebia, “Abanto aba bakorire ebibe ebinene mono, bekoreire enyasae y’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Na bono, koranche, obaabere ebibe biabo. Onye taibo, rirorio otinyie erieta riane korwa ase egetabu eria kwarigete.” ");
INSERT INTO guz_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Omonene akairaneria Musa, “Omonto oria onkoreire ebibe, nere ndatinyie erieta riaye korwa ase egetabu yane. ");
INSERT INTO guz_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Korende bono genda, oraae abanto abwo goika aase aria nagotebetie; omomalaika one nagotang’ane. Korende rituko ndiche ekero ndabae egesusuro ase engencho y’ebibe biabo.” ");
INSERT INTO guz_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Omonene akabaa egesusuro, ekiagera bagerete Aroni agakora emori eria, bakayesasiima. ");
INSERT INTO guz_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Omonene agakwana na Musa, akamoteebia, Imoka korwa aa ogende, aye amo nabaanto aba kwang’anyetie korwa Misiri, obaire ase ense eria narierete Aburaamu na Isaka na Yakobo eira, ngateba “Ning’ee ororeria rwaino ense eyio. ");
INSERT INTO guz_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nintome omomalaika agotang’ane, Niserie Abakanaani, na Abaamori, na Abahiti, na Abaperisi, na Abahivi na Abayebusi. ");
INSERT INTO guz_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Nimbaire ase ense ere entenenku y’amabeere na amooke. Inche omonyene tinkogenda amo nainwe, mbaise kobaitera inchera, ekiagera inwe nabanyabigoti bikong’u.” ");
INSERT INTO guz_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ekero abanto baigwete amang’ana ayio amakong’u bakarera na onde taba obegete ebinto biaye bi’ogwechabera. ");
INSERT INTO guz_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Omonene agateebia Musa “Bateebie Abaisraeli: Inwe nabanyabigoti bikong’u. Inse kogenda amo nainwe, nonya netagika eyemo, nigo ndabasirie kegima. Gaki bono rusia ebinto biaino ebi mwechaberete, erio ndore inki ndabakorere.” ");
INSERT INTO guz_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ase igo Abaisraeli bakarusia ebinto biria bechaberete, na tibabibeka korwa ekero baruete egetunwa kia Horebu nakogenderera. ");
INSERT INTO guz_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa nigo anarete koira eema na koyetenenia are ake korwa ase egetwori akayeroka “Eema y’Omosangererekano.” Na onde bwensi oganetie kobori’Omonene ring’ana, goika are kogende ase Eema eria, isiko y’egetwori. ");
INSERT INTO guz_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Engaki ende yonsi Musa arenge kogenda ase Eema eria, abanto bonsi nigo baare koimoka na gotenena, kera omonto ase egesoero ki’eema yaye, na korigereria Musa goika osoire Eema eria ime. ");
INSERT INTO guz_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ekero Musa asoire Eema eria, riire riare buna esiiro riba rigoika na gotenena ase egesoero ki’Eema eria, n’Omonene aba ogokwana na Musa. ");
INSERT INTO guz_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ekero abanto bonsi barorire riire riria rigotenena ase egesoero ki’Eema, baba bakoimoka na gotung’ama inse ase ogosasiima, kera omonto ase egesoero ki’eema yaye. ");
INSERT INTO guz_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Na Omonene aba ogokwana na Musa obosio ase obosio, buna omonto agokwana nomonto onde. Erio Musa aba okoirana gochia ase egetwori, korende Yoshua, omosomba oye omosae, mosinto o Nuni, tare korua ase Eema eria. ");
INSERT INTO guz_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa agateebia Omonene, “Rora, aye nigo gwantebeetie: Baire abanto aba, korende tigwanteebia ng’a ning’o oratome agende amo nainche. Naende oganteebia: Ninkomanyete buya kegima, na buna okorokwa; naye kwanyorire ogwancherwa ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ase igo, onye nanyorire ogwancherwa ase obosio bwao, nagosabire, onyorokie chinchera chiao, erinde inyare gokomanya na konyora ogwancherwa ase obosio bwao, naende rigereria ng’a abanto b’egesaku eke nabaanto bao bare.” ");
INSERT INTO guz_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Omonene akamoteebia, “Inche omonyene nigo ndagende amo naye, na ninkoe obotoereru.” ");
INSERT INTO guz_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa akamoiraneria, “Onye aye omonyene tokogenda amo naintwe, rirorio totige, tobeere aa. ");
INSERT INTO guz_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Naki eramanyekane ng’a inche na abanto bao twanyorire ogwancherwa ase obosio bwao, onye tokogenda amo naintwe? Koragende amo naintwe, natororekane ng’a twachorirwe korwa ase abanto bande b’ense eye.” ");
INSERT INTO guz_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Omonene akairaneria Musa, “Ninkore erio kwamboria, ekiagera kwanyorire ogwancherwa ase obosio bwane, na inche ninkomanyete buya kegima, na buna okorokwa.” ");
INSERT INTO guz_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa akamosaba, “Koranche, onyorokie obonene bwao!” ");
INSERT INTO guz_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Omonene akamoiraneria, “Ninkore obosiani bwane bwonsi boete ase obosio bwao, na erieta riane, inche Omonene, nindirarie ase obosio bwao. Nimororere amabeebe oyio ndarorere amabeebe, na nimororere amaabera oyio ndarorere amaabera.” ");
INSERT INTO guz_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Naende akamokania, akamoteebia, “Tokonyara korora obosio bwane, ekiagera Mwanyabaanto aise kondora, takonyara koba moyo.” ");
INSERT INTO guz_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Naende Omonene akagenderera komoteebia, “Rora, aase aiga are ang’e nainche, aye oranyare gotenena egetare igoro. ");
INSERT INTO guz_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Erio ekero obonene bwane borabe bogoeta, ninkobeke ase omotaro bw’egetare keria, na ngotube nokoboko kwane, goika imbe naetire. ");
INSERT INTO guz_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Erio ndusie okoboko kwane, na aye ondore amagega aane, korende obosio bwane tokonyara koborora.” ");
INSERT INTO guz_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Omonene agateebia Musa, “Baacha chibao chi’amagena ibere chire buna chiria chi’eritang’ani, na inche nindiike ase chibao echio amang’ana aria arenge ase chiria chi’eritang’ani, echio gwatete. ");
INSERT INTO guz_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Oche bwebeeke ang’e mambia, otiire gocha ase egetunwa gia Sinai maambia, bweorokie aroro ase inde ase egechuria ki’egetunwa. ");
INSERT INTO guz_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Monto onde tatiira amo naye, gose monto onde tarorekana aande onsi ase egetunwa eke, gose ching’ondi ne chiombe tichiba chikorisia ang’e negetunwa eke.” ");
INSERT INTO guz_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Erio Musa akabaacha chibao ibere chi’amagena chire buna chiria chi’eritang’ani, akaimoka mambia chuni, agatiira gochia ase egetunwa gia Sinai, buna Omonene konya amochikiire, obogoretie chibao chiria ibere chi’amagena koboko kwaye. ");
INSERT INTO guz_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Omonene agaika ore riire ime, agatenena amo nere, akararia erieta NYASAE OMOBUI. ");
INSERT INTO guz_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Omonene agaeta ase obosio bwa Musa, akeraria, “Omonene Nyasae, nere Nyasae omonyene amaabera na obuya, tari omwango bw’okoba nendamwamu; nigo are nobwanchani botari koera, na obwegenwa. ");
INSERT INTO guz_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nigo agokorera ebiare chilifu obwanchani botari koera; ere nigo akwabera amamocho, na ogosaria, na ebibe, korende tagotiga koa abana na abachokoro egesusuro goika ekiaare kia gatato na egia kane ase engencho y’amabe ’abaibori babo.” ");
INSERT INTO guz_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Erio bwango Musa agatung’ama inse agatureka omotwe, agasasiima, ");
INSERT INTO guz_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","akabora, “Omonene, onye bono nanyorire ogwancherwa ase obosio bwao, nagosabire ogende amo naintwe. Naki abanto aba nabanyabigoti bikong’u, korende otwabere ogosaria gwaito na ebibe biaito, otwanchere tobe abanto bao.” ");
INSERT INTO guz_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Omonene akabora, “Rora, bono ngokora inde nainwe okobwatana kw’ogotianania. Ase amasio ’abaanto bao bonsi ninkore ebikone ebio bitana gokoreka ase ense yonsi, gose ase egesaku kende gionsi. Na abanto bonsi abagoetanaine inabarore ogokora kw’Omonene, naki ayio ndagokorere namang’ana ay’okoondokia. ");
INSERT INTO guz_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Obwate amachiiko ayio ndakoe reero. Norore ase obosio bwao ngoseria Abaamori, na Abakanaani, na Abahiti, na Abaperisi, na Abahivi, na Abayebusi. ");
INSERT INTO guz_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Bwerende, tobaisa gokora okobwatana nabanyene ense eria ase okogenda, baabaise kobatega mogwe. ");
INSERT INTO guz_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Inwe motagore ebisasimero biabo, mobiiyerie inse, na gosenyenta chisiiro chi’amagena ase bagosasimera. ");
INSERT INTO guz_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Tobaisa gosasiima enyasae ende eng’ao, ekiagera Omonene nigo akorokwa Omonyaisemi, nere Nyasae bwe risemi. ");
INSERT INTO guz_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Tobaisa gokora okobwatana nabanyene ense eria, ekiagera ekero bagokora obotomani ase ogosasiima chinyasae chiabo na gochiruera ebing’wanso, mbaabaise kobarangeria inwe morie ebing’wanso biabo. ");
INSERT INTO guz_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Inamoire abakungu korwa ase abasubati babo abwo bagokora obotomani ase ogosasiima chinyasae chiabo, barabwo bakore abamura baino basasime chinyasae chiabo. ");
INSERT INTO guz_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Tibwekorera chinyasae korwa ase ebioma binyititoire na kobombwa. ");
INSERT INTO guz_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Orende rituko rinene ri’Emegati etabekiri memera; na buna nagochigeete, orie emegati etabekiri memera ase amatuko atano na abere, ase engaki yachigetwe, y’omotienyi bw’Abibu, naki ase omotienyi oyio oyio noro kwaruete ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Kera omwana omoisia omotangi nabe oyone, ne ching’iti chintangi boigo, chibe chieri gose chimingichi. ");
INSERT INTO guz_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Korende emori entangi y’etigere goika oyeboorie ase okorua eng’ondi ebe ekeng’wanso. Onye tibwancheti koyebooria, goika oyebune ebigoti. Abana bao abaisia abatangi goika obaboorie. Onde tari orabe ogocha ase obosio bwane, inche Omonene, namaboko amasa. ");
INSERT INTO guz_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Okore emeremo ase amatuko atano na rimo, korende rituko ria gatano na kabere otimoke, nonya nengaki y’okorema na eye rigesa. ");
INSERT INTO guz_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Orende Rituko Rinene rie Chichuma, ase engencho y’ogotongora kw’engano, ne Rituko Rinene ri’Ogosangereria Rigesa, omoerio bw’omwaka. ");
INSERT INTO guz_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Ara gatato kera omwaka abanto bao bonsi abasacha babe bagocha ase obosio bwane, inche Omonene Nyasae, Nyasae bw’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ninserie abanto b’ebisaku korwa asore na kogareyia orogongo rwao, onde tari orakoroure ase chingaki echi isato kera omwaka, ekero orabe kogocha ase obosio bwane, inche Omonene, Nyasae oo. ");
INSERT INTO guz_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Ekero okondetera amanyinga ’ekeng’wanso, tobaisa koyandetera amo nomogati obekire ememera. Tobaisa gotigaria chinyama chinde chi’ekeng’wanso kie rituko rinene ri’Epasaka goika mambia. ");
INSERT INTO guz_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Goika orente ase enyomba yane, inche Omonene oo, ogotongora kwao okore okuya korwa ase omogondo oo. “Tobaisa koiyekera emanwa y’embori, gose yeng’ondi ime y’amabeere ’eng’ina.” ");
INSERT INTO guz_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Omonene agateebia Musa, “Riika amang’ana aya, ekiagera ase amang’ana ayio nakorire okobwatana kw’ogotianania naye amo n’Abaisraeli.” ");
INSERT INTO guz_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa akabeera n’Omonene ase engaki y’amatuko emerongo ene, omobaso na obotuko, tare koria kende, gose konywa, akarika ase chibao echi ibere amang’ana ’okobwatana koria, Amachiiko ayio ikomi. ");
INSERT INTO guz_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa agatirimboka korwa ase egetunwa gia Sinai, obwate ase okoboko kwaye chibao chiriikire oborori, ere tamanya ng’a risankwa ri’obosio bwaye nigo riare komeka‐meka, ekiagera konya okwanire n’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aroni na abanto bonsi, ekero baroche buna risankwa ri’obosio bwa Musa riare komeka‐meka, bakoboa komoika ang’e. ");
INSERT INTO guz_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Korende Musa akabarangeria, erio Aroni amo nabatang’ani bonsi b’omosangererekano bakairana asare, na Musa agakwana nabarabwo. ");
INSERT INTO guz_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Magega y’ayio Abaisraeli bonsi bagacha ase Musa, na ere akabaa amachiiko onsi ay’Omonene konya amoeire ase egetunwa gia Sinai. ");
INSERT INTO guz_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ekero Musa akoorire gokwana nabarabwo, akabeeka egietubo ase obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ekero kende gionsi Musa are gosoa eema ase obosio bw’Omonene gokwana nere, nigo are korusia egietubo goika osoka korwa aroro. Ekero asokire aba ogoteebia Abaisraeli amang’ana onsi aya achikirwe gokwana, ");
INSERT INTO guz_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","na barabwo baba bakorora risankwa ri’obosio bwaye rikomeka‐meka. Erio Musa abeeka egietubo ase obosio bwaye goika airana naende gokwana n’Omonene. ");
INSERT INTO guz_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa akarangeria omoganda bwonsi bw’Abaisraeli amo, akabateebia, “Aya nar’Omonene achiikire morakore: ");
INSERT INTO guz_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mokore emeremo ase amatuko atano na rimo, korende rituko ria gatano na kabere nigo rirabe richenu ase more, rituko ri’Esabato, riogotimoka ase Omonene. Onde bwensi aise gokora emeremo ase rituko erio goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Timobaisa gouta omorero ase rituko ri’Esabato, aande onsi ase momenyete.” ");
INSERT INTO guz_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa agateebia omoganda bwonsi bw’Abaisraeli, “Aya nar’Omonene achiikire: ");
INSERT INTO guz_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Moruere Omonene ebiegwa. Kera omonto oyore nomoyo bw’ogwancha aruere Omonene ebinto ebi: Etaabu, na efeta, na etai; ");
INSERT INTO guz_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri; egatani engiya na amanya e chimbori; ");
INSERT INTO guz_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","amasankwa e chimingichi aakire etaago, na amasankwa amaterere e ching’iti chia rooche, ne chibao chi’emekonge; ");
INSERT INTO guz_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","amaguta e chitaaya, na ebinto bi’okoroisia amaguta akweakwa, na ebi’okoroisia ubani; ");
INSERT INTO guz_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","amagena e rigori rinene buna oiniki na ayande akobekwa ase egesibao na egesembe ki’obokuani.” ");
INSERT INTO guz_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Abaroisia bonsi abang’aini abare ase egati yaino, tiga bache baroisie ebinto bionsi Omonene achiikire, ");
INSERT INTO guz_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","nabio ebi: Obomenyo na eema yaye, na egietubo kiaye, ebigobanio ne chibao chiaye, na emeriibo, ne chisiiro amo ne chinterekerero chiabo; ");
INSERT INTO guz_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Esanduki na emiaro yaye, na Oboikaranso bw’amaabera, na etoto eria erabeekwe ebokenge; ");
INSERT INTO guz_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","emesa na emiaro yaye, na ebikorero biaye bionsi, na emegati eria eraruegwe ase Nyasae; ");
INSERT INTO guz_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ekebekerero gie chitaaya na ebikorero biaye, ne chitaaya chiaye amo namaguta e chitaaya, ");
INSERT INTO guz_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","na egesasiimero ase ubani egosamberwa amo nemiaro yaye, na amaguta akweakwa, na amanukato are ne rimisu rigiya, na ebitambaa bigosungwa ase egesoero ki’Obomenyo obwo; ");
INSERT INTO guz_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","na egesasiimero aase ebing’wanso bigosamberwa amo negechungi kiaye gi’etai, na emiaro yaye, na ebikorero biaye bionsi, na egetuba amo nenterekerero yaye; ");
INSERT INTO guz_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ebitambaa ebirakenge eraaro, ne chisiiro amo ne chinterekerero chiaye, na egetambaa ki’egesoero ki’eraaro, ");
INSERT INTO guz_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","na ebirochi bi’Obomenyo na ebi’eraaro amo ne chingori chiabo, ");
INSERT INTO guz_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ne chianga chiria chinseera chigokorerwa ime y’Ase Achenu, engencho yaye chianga chia Aroni Omokuani, amo nechi’abamura baye, barabe bakobeeka ekero bagokora emeremo yabo y’obokuani.” ");
INSERT INTO guz_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Erio omoganda bwonsi bw’Abaisraeli okaruao agwo ase obosio bwa Musa. ");
INSERT INTO guz_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Naende bakairana kera oyomo buna enkoro yaye yamosugetie, na buna anchete ere omonyene, bakarentera Omonene ebiegwa biabo ase okoroisia Eema y’Omosangererekano na ebinto bionsi ebiaganeirie, ase emeremo eria na ase chianga chiria chinchenu. ");
INSERT INTO guz_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Barabwo bagacha, abasacha na abakungu, na ase ogwancha kwabo bakarenta amameka, na ebigera bi’amato abo, ne chibonyi chi’ebiara, ne chisonoi, na ebinto ao ao bie chitaabu bi’ogwechabera. Kera omonto akarenta ebinto bie chitaabu, ebi aatananete ase ogokorera Omonene. ");
INSERT INTO guz_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Naende kera omonto oyo obwate chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, na egatani engiya, na amanya e chimbori, na amasankwa e chimingichi aakire etaago, na amasankwa e ching’iti chia rooche, akabirenta. ");
INSERT INTO guz_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bonsi abaare konyara korua chifeta ne chitaai bakabirenta bibe ebiegwa ase Omonene, na bonsi abarenge nemekonge eyere emiya ase emeremo ende yonsi, bakayerenta. ");
INSERT INTO guz_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Na abakungu abaroisia abang’aini bagasisa namaboko abo chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, na echi’egatani engiya, bagachirenta. ");
INSERT INTO guz_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Na abakungu bonsi, abasugetigwe ase emioyo yabo, naende bamanyete emeremo eye, bagasisa amanya e chimbori abe chiusi. ");
INSERT INTO guz_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Abatang’ani babo bakarenta amagena e rigori rinene buna oiniki na ayande arabekwe ase egesibao na egesembe ki’obokuani, ");
INSERT INTO guz_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","naende ebinto bie rimisu rigiya amo namaguta e chitaaya, na amaguta akweakwa, na ubani ere ne rimisu rigiya. ");
INSERT INTO guz_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Abaisraeli bonsi, abasacha na abakungu, abarenge nogwancha korenta ebinto bi’emeremo eye Omonene achigete goetera ase Musa, bakarenta ebiegwa biabo ase Omonene. ");
INSERT INTO guz_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa agateebia Abaisraeli, Rora, Omonene ochorire Besaleli, oyore mosinto o Uri, mochokoro o Huri bw’egesaku kia Yuda. ");
INSERT INTO guz_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Omoichoirie omoika o Nyasae, omoeire obong’aini ne chisemi anyare gokora emeremo ende yonsi y’oboroisia, ");
INSERT INTO guz_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","abe oyomanyete koroberia na koroisia ebinto bie chitaabu, ne chifeta, ne chitaai, ");
INSERT INTO guz_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","abe okobaacha amagena e rigori rinene na koyabeeka ase ebikonde, na kobaacha emete, na gokora emeremo ende yonsi y’oboroisia. ");
INSERT INTO guz_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Omonene omoeire ere amo na Oholiabu, mosinto bw’Ahisamaki bw’egesaku kia Dani, obong’aini bw’okworokereria abande oboroisia bwabo. ");
INSERT INTO guz_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Obaichoirie obong’aini ase chinkoro chiabo, erinde banyare gokora emeremo ende yonsi buna okomang’a, na okoroberia, na koroisia ebitambaa bie chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, na echi’egatani engiya, na koroisia ebitambaa binde bionsi. Banyare gokora emeremo ende yonsi na bamanye koroberia oboroisia bonde bwonsi. ");
INSERT INTO guz_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besaleli na Oholiabu amo nabaroisia bande bonsi, aba Omonene konya aeire obong’aini, abare nogwancha kw’ogokora emeremo ende yonsi egwenerete ase okoagacha Obomenyo Obochenu, goika bakore kera emeremo buna Omonene konya achiikire. ");
INSERT INTO guz_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Erio Musa akarangeria Besaleli amo na Oholiabu na abaroisia bande bonsi, aba Omonene aeire obong’aini, abaasugetigwe ase chinkoro chiabo, bache, bachake emeremo eria. ");
INSERT INTO guz_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Barabwo bakaegwa korwa ase Musa ebiegwa ebi bionsi Abaisraeli konya barentire ase okoroisia Obomenyo boria Obochenu. Na Abaisraeli bakagenderera komorentera ebiegwa biabo kera emambia. ");
INSERT INTO guz_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Erio abaroisia baria abang’aini, abarenge gokora emeremo ende yonsi ase Obomenyo boria Obochenu, magega kobatigire emeremo eye baare gokora bagacha ase Musa, ");
INSERT INTO guz_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","bakamoteebia, “Abanto barentire ebiegwa ebinge goetania ebiaganeirie ase emeremo eri’Omonene achigete ekorwe.” ");
INSERT INTO guz_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ase ayio Musa akarareria abanto bonsi b’egetwori, akabachiika, “Onde tabaisa korenta ebiegwa binde goetania ebi konya biasangererigwe ase Obomenyo Obochenu, abe omosacha gose omokungu.” Ase igo abanto bagatiga korenta ebiegwa binde. ");
INSERT INTO guz_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ebi konya barentire nigo biabeete ebinge, bigaetania ebiaganeirie ase emeremo eria yare gocha gokorwa. ");
INSERT INTO guz_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Abaroisia bonsi abang’aini b’abakori emeremo bakaroisia eema y’Obomenyo. Bakayeroisia nebitambaa ikomi, biroisirie korwa ase chiusi chi’egatani engiya chisisire amo ne chiusi chi’amarionya chimbariri Omoroisia omong’aini akabiroisia, bire nemegwekano y’ebitongwa bibwate chimbaba. ");
INSERT INTO guz_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Obotambe bwa kera egetambaa nigo bwarenge obw’ekerengo ki’amaboko emerongo ebere, na atano na atato, na obogare bwaye amaboko ane; bionsi nigo biarenge bi’ekerengo ekemo. ");
INSERT INTO guz_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Akabwatania ebitambaa bitano amo, bikaba rirondia erimo. Naboigo nebitambaa binde bitano. ");
INSERT INTO guz_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Agakora ebioro bie chiusi chiburu, bakabibeeka ase ensinyo y’egetambaa kere ensinyo y’ensemo ya kera rirondia. ");
INSERT INTO guz_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Agakora ebioro emerongo etano, akabibeeka ase egetambaa kegochakera rirondia rie ritang’ani, na emerongo etano ase egetambaa kegokoorera rirondia ria kabere. Ebioro bia kera rirondia bigachikana. ");
INSERT INTO guz_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Agatura ebigobanio bie chitaabu emerongo etano, na ase ebio akabwatania amarondia ayio amo, akaba eema eyemo y’Obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Erio akaroisia amarondia ikomi na rimo ay’amanya e chigoree, akaba eema y’ogotuba Obomenyo boria. ");
INSERT INTO guz_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Obotambe bwa kera rirondia nigo bwarenge obw’ekerengo ki’amaboko emerongo etato, na obogare bwaye amaboko ane. Amarondia onsi aya ikomi na rimo nigo arenge ay’ekerengo ekemo. ");
INSERT INTO guz_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Akabwatania amarondia atano amo, akaba rirondia erimo, naende atano na rimo akaba rirondia erimo. ");
INSERT INTO guz_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Agakora ebioro emerongo etano, akabibeeka ase ensinyo ye rirondia rinene rie ritang’ani, na emerongo etano ase rirondia rinene ria kabere ase rigochakera. ");
INSERT INTO guz_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Naende agakora ebigobanio emerongo etano bie chitaai ase okobwaterania amarondia ayio abere, abe eema engima. ");
INSERT INTO guz_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Agakora rirondia ri’amasankwa e chimingichi aakire etaago, ase ogotuba eema, ne rirondia rinde ri’amasankwa amaterere e ching’iti chia rooche, erirabeekwe igoro ye rirondia rie ritang’ani. ");
INSERT INTO guz_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Naende akaroisia chibao chi’emekonge ase Obomenyo, agachitenenia. ");
INSERT INTO guz_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Obotambe bwa kera ebao nigo bware obw’ekerengo ki’amaboko ikomi, na obogare okoboko okomo na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Agakora chintamang’o ibere ase kera ebao, ase chibao echio chirabwateranigwe. Naboigo aroisetie chibao echi chionsi chi’Obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Akaroisia chibao emerongo ebere ase ensemo ya Irianyi. ");
INSERT INTO guz_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Agakora ne chinterekerero chi’echifeta emerongo ene, chibe ibere ibere inse ya kera ebao ase chintamang’o chiaye ibere. ");
INSERT INTO guz_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Nase ensemo ya kabere, nero ya sugusu y’Obomenyo, akaroisia chibao emerongo ebere, ");
INSERT INTO guz_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ne chinterekerero chiaye chi’echifeta emerongo ene, ibere ibere inse ya kera ebao. ");
INSERT INTO guz_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Korende ase ensemo ya magega y’Obomenyo, eyerochie bosongo, akaroisia chibao isano nemo. ");
INSERT INTO guz_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Naende akaroisia chibao ibere chikaba chikoona chi’Obomenyo ensemo ya magega. ");
INSERT INTO guz_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kera ebao ase echio ibere ekabwatanigwa ne chibao chie chinsinyo, korwa inse goika igoro ase ebonyi entang’ani ere; naboigo bakorete ase chibao echio ibere echiabegetwe ase chikoona ibere. ");
INSERT INTO guz_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Chibao chionsi nigo chiabeete isano na isato, ne chinterekerero chiabo chi’echifeta ikomi, na isano nemo, ibere ibere inse ya kera ebao. ");
INSERT INTO guz_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Akabaacha emeriibo etano y’emekonge, eriibe chibao chie rikere erimo ri’Obomenyo, ");
INSERT INTO guz_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","na etano ase rikere rinde, na etano ase ensemo ya magega, eyerochie bosongo. ");
INSERT INTO guz_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Akabaacha omoriibo o gati‐gati omogima, ase okoriiba chibao korwa ensinyo eyemo goika eyende. ");
INSERT INTO guz_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Erio akaooma chibao echio netaabu, agakora chibonyi chi’echitaabu ase emiaro erasoigwe, naende akaooma emeriibo eria netaabu. ");
INSERT INTO guz_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Akaroisia etoto ye chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo ne chiusi chi’egatani engiya chisisire. Omoroisia omong’aini akayeroisia ekaba emegwekano y’ebitongwa bibwate chimbaba. ");
INSERT INTO guz_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Naende akabaacha chisiiro inye chi’emekonge, agachiooma netaabu, na ebigobanio biaye bie chitaabu. Agakora chinterekerero inye korwa ase efeta enyititoire. ");
INSERT INTO guz_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Na ase egesoero ki’Eema akaroisia egetambaa korwa ase chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani, keroisirie nomoroisia omong’aini. ");
INSERT INTO guz_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Bakabaacha chisiiro isano amo nebigobanio biabo, bakaooma ebisure ne chinuga chiabo netaabu. Chinterekerero chiabo isano nigo chiakorire korwa ase chitaai. ");
INSERT INTO guz_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Erio Besaleli akaroisia Esanduki ye chibao chi’emekonge. Obotambe bwaye nigo bwarenge obw’ekerengo ki’amaboko abere na ekeng’ese, na obogare bwaye okoboko okomo na ekeng’ese, na obotambe bwaye gochia igoro okoboko okomo, na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Akayeooma netaabu echenire, ime na isiko, akayeetanania omong’ororia bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Agakora chibonyi inye korwa ase etaabu enyititoire, agachibeeka ase amagoro aye ane, ibere ase kera rikere. ");
INSERT INTO guz_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Akabaacha emiaro y’emekonge, akayeooma netaabu. ");
INSERT INTO guz_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Agasoyia emiaro eyio ase chibonyi ime ase okobogoreria esanduki eria. ");
INSERT INTO guz_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Akaroisia ekemumeko gi’etaabu echenire ebe Oboikaranso bwa’Amaabera. Obotambe bwaye nigo bwarenge obw’ekerengo ki’amaboko abere na ekeng’ese, na obogare bwaye okoboko okomo na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Erio agakora emegwekano y’ebitongwa bibwate chimbaba babere ey’etaabu esunyuntire, akayebeka ase chinsinyo ibere chi’Oboikaranso bwa amaabera, ");
INSERT INTO guz_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","oyomo ase kera ensinyo, akayekora ekaba egento ekemo n’Oboikaranso bwa amaabera. ");
INSERT INTO guz_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ebitongwa bibwate chimbaba abwo bakarambora chimbaaba chiabo igoro y’Oboikaranso bwa amaabera, bakabobekera ekiriri, na amasio abo agachiikana; na barabwo bakarigereria Oboikaranso bwa amaabera. ");
INSERT INTO guz_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Akaroisia emesa ye chibao chi’emekonge. Obotambe bwaye nigo bwarenge obw’ekerengo ki’amaboko abere, na obogare bwaye okoboko okomo na obotambe bwaye gochia igoro okoboko okomo na ekeng’ese. ");
INSERT INTO guz_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Akayeoma netaabu echenire, akayeetanania omong’ororia bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Erio agakora orosingo rore nobogare bong’ana egesanyi gi’okoboko, na akaroetanania omong’ororia bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Naende agakora chibonyi inye korwa ase chitaabu, ne chibonyi echio agachibeka ase chikoona inye ase amagoro aye ane. ");
INSERT INTO guz_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Chibonyi chiria chikabekwa ang’e norosingo, na emiaro eria egasoigwa imeo, erinde emesa enyare kobogorerigwa. ");
INSERT INTO guz_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Akabaacha emiaro eria korwa ase emekonge, akayeooma netaabu. ");
INSERT INTO guz_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Agakora ebikorero biare kobekwa ase emesa igoro: chinteru na ebitaabo ase ubani, ne chisani, korwa ase ebio bagocha koumora ebinyugwa ebikoruegwa; akabiroisia bionsi korwa ase chitaabu chichenire. ");
INSERT INTO guz_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Akaroisia ekebekerero gie chitaaya gi’etaabu echenire esunyuntire. Akayeroisia nenterekerero amo ne ritina, na emegwekano y’amamumu na ebisicha; bionsi bikaroisigwa bikaba egento ekemo. ");
INSERT INTO guz_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Nigo kiare ne chinsagia isano nemo, chiasogete korwa ase ritina, isato korwa ase ensemo eyemo, na isato korwa ase ensemo ende. ");
INSERT INTO guz_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Orosagia rwe ritang’ani rokaba nemegwekano etato y’ebisicha binga buna ebi’omolozi, kera ekemo ne rimumu na egesicha, na orosagia rwa kabere boigo rokaba nemegwekano y’ebisicha binga buna ebi’omolozi; ne chinsagia chionsi isano nemo chikaba boigo. ");
INSERT INTO guz_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ritina rinyene ri’ekebekerero gie chitaaya keria rikaba nemegwekano ene y’ebisicha binga buna ebi’omolozi. ");
INSERT INTO guz_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Rimumu erimo rikaba inse ya kera chinsagia ibere chigosoka korwa ase ritina. Ase ayio rikaba rimumu erimo inse ya kera orosagia rw’echio isano nemo chiroisirie chikaba egento ekemo ne ritina. ");
INSERT INTO guz_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Bionsi bikaroisigwa korwa ase ribomba erimo ri’etaabu echenire esunyuntire. ");
INSERT INTO guz_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Naende akaroisia chitaaya chiaye isano na ibere, na ebiinachi, ne chindogio chiaye chi’echitaabu chichenire. ");
INSERT INTO guz_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ekebekerero keria gie chitaaya amo nebikorero biaye bionsi bikaroisigwa korwa ase chitaabu chichenire chi’ekerengo gie chikiro emerongo etano. ");
INSERT INTO guz_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Akaroisia egesasiimero gie chibao chi’emekonge ase ubani erasamberwe. Obotambe bwaye nigo bwarenge obw’ekerengo gi’okoboko okomo, na obotambe bwaye gochia igoro amaboko abere. Emegwekano ye ching’unchara ekaroisigwa ekaba egento ekemo negesasiimero. ");
INSERT INTO guz_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Agakeooma netaabu echenire, igoro yaye, ne chinsemo chiaye, amo ne ching’unchara chiaye, akayeetanania omong’ororia bw’etaabu. ");
INSERT INTO guz_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Agakora chibonyi ibere chi’echitaabu, agachibeeka inse y’omong’ororia ase chinsemo ibere. Ase chibonyi echio emiaro egasoigwa, erinde egesasiimero kenyare kobogorerigwa. ");
INSERT INTO guz_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Na emiaro eria akabaacha korwa ase emekonge, akayeooma netaabu. ");
INSERT INTO guz_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Naende akaroisia amaguta amaachenu akweakwa, na ubani echenire are ne rimisu rigiya, akayaroisia buna omooroisia, oyomanyete buya, aranyare koyaroisia. ");
INSERT INTO guz_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Erio akaagacha egesasiimero gie chibao chi’emekonge ase ebing’wanso birasamberwe. Obotambe bwaye nigo bwarenge obw’ekerengo ki’amaboko atano, na obogare bwaye amaboko atano; nabo chinsemo chiaye inye chikaba chireng’aine, na obotambe bwaye gochia igoro nigo bwarenge obw’ekerengo ki’amaboko atato. ");
INSERT INTO guz_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ase chikoona inye chi’egesasiimero akaroisia emegwekano ene ye ching’unchara, akayeroisia ekaba egento ekemo negesasiimero, akaooma gionsi netai. ");
INSERT INTO guz_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Akaroisia ebikorero bionsi bi’egesasiimero nabio ebi: Chindogio chi’okobuucha riibu, na ebichiko, na ebitaabo, ne chigami, ne chindogio chi’okorenta omorero. Ebinto ebi bionsi akabiroisia korwa ase chitaai. ");
INSERT INTO guz_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Agakora egechungi gi’etai, agakebeeka korwa inse y’orosingo, kegaika gochia igoro gati gati y’egesasiimero. ");
INSERT INTO guz_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Agakora chibonyi inye, agachibeka ase chikoona inye chi’egechungi ekio gi’etai, ase emiaro egosoigwa. ");
INSERT INTO guz_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Akabaacha emiaro eria korwa ase emekonge, akayeooma netai. ");
INSERT INTO guz_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Agasoyia emiaro eria ase chibonyi chire chinsemo chi’egesasiimero, erinde kenyare kobogorerigwa. Agakeagacha ne chibao, akagetiga giasaime. ");
INSERT INTO guz_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Akaroisia egetuba amo nenterekerero yaye korwa ase ebirore bie chitaai bi’abakuungu baare gokorera ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ase ensemo ya Irianyi akaroisia ebitambaa bie chiusi chindabu chi’egatani chisisire. Obotambe bwabo nigo bwarenge obw’ekerengo ki’amaboko rigana erimo. ");
INSERT INTO guz_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Chisiiro chiaye emerongo ebere echiare kobibwata nigo chiarenge ne chinterekerero chiabo emerongo ebere chie chitaai, korende ebigobanio ne chinuga chiabo nigo chiarenge chi’echifeta. ");
INSERT INTO guz_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Naboigo ase ensemo ya sugusu akaroisia ebitambaa bire nobotambe bw’ekerengo ki’amaboko rigana erimo. Chisiiro emerongo ebere echiare kobibwata nigo chiarenge ne chinterekerero chiabo emerongo ebere chie chitaai, korende ebigobanio ne chinuga chiabo nigo chiarenge chi’echifeta. ");
INSERT INTO guz_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ase ensemo ya bosongo bakaroisia ebitambaa bire nobotambe bw’ekerengo ki’amaboko emerongo etano, ne chisiiro ikomi amo ne chinterekerero chiabo ikomi, korende ebigobanio ne chinuga chiabo nigo chiarenge chi’echifeta. ");
INSERT INTO guz_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Obogare bw’ensemo ya bosio, erochie moocha, nigo bwarenge obw’ekerengo ki’amaboko emerongo etano. ");
INSERT INTO guz_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ase ensemo eyemo y’egesoero bakaroisia ebitambaa bi’ekerengo ki’amaboko ikomi na atano, ne chisiiro isato amo ne chinterekerero chiabo isato. ");
INSERT INTO guz_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Naboigo ase ensemo ende bakaroisia ebitambaa bi’ekerengo ki’amaboko ikomi na atano, ne chisiiro isato amo ne chinterekerero chiabo isato. Ase igo chinsemo chionsi ibere chi’egesoero chikaba chireng’aine. ");
INSERT INTO guz_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ebitambaa bionsi ebiaetanaine eraaro eria bikaroisigwa ne chiusi chi’egatani engiya chisisire. ");
INSERT INTO guz_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Chinterekerero chie chisiiro chiaye nigo chiarenge chie chitaai, korende ebigobanio ne chinuga chiabo nigo chiarenge chi’echifeta, na ebisure biabo bikaoomwa nefeta. ");
INSERT INTO guz_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Egetambaa ki’egesoero bakaroisia korwa ase chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani chisisire. Obotambe bw’egetambaa keria nigo bwarenge obw’ekerengo ki’amaboko atano koreng’ana nobogare bwaye buna ebitambaa binde bi’eraaro. ");
INSERT INTO guz_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Chisiiro inye, echiare gokebwata, ne chinterekerero chiabo inye, nigo chiarenge chie chitaai, korende ebigobanio biabo nigo biarenge bie chifeta, na ebisure bie chisiiro bikaoomwa nefeta, ne chinuga chiabo nigo chiarenge chi’echifeta. ");
INSERT INTO guz_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ebirochi bionsi bi’eema y’Obomenyo na ebi’ebitambaa bi’eraaro nigo biarenge bie chitaai. ");
INSERT INTO guz_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Oyo noro omobaro bw’ebinto ebiakoreretwe ase okoroisia Obomenyo, engencho yaye Obomenyo bw’Oborori. Omobaro oyo Musa achigete ogakorwa n’Abalawi inse y’oboraai bwa Itamari, mosinto o Aroni, Omokuani. ");
INSERT INTO guz_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besaleli, mosinto o Uri o Huri bw’egesaku kia Yuda, agakora onsi ay’Omonene achigete Musa. ");
INSERT INTO guz_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Amo nere nigo arenge Oholiabu, omwana o Ahisamaki bw’egesaku kia Dani, komokonya. Ere nigo arenge omong’aini bw’okomang’a na kobaacha, na bw’okoroisia ebitambaa bie chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya. ");
INSERT INTO guz_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Etaabu yonsi eyakoreretwe ase emeremo y’okoroisia Obomenyo Obochenu, eyaatananetwe ebe ekerugwa, nigo yarenge chikiro elifu eyemo, na amagana ane, na emerongo etano nomo, na isano (1,465) ase ekerengo gi’esekeli y’Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Efeta eyaruetwe nomoganda bw’abwo barigetwe nigo yarenge chikiro chilifu isano, na emerongo etato, na isano (5,035), ase ekerengo gi’esekeli y’Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kera omonto oyorigetwe, oyokoorire emiaka emerongo ebere na goetania, akarua ebeka eyemo, engencho yaye ekeng’ese gi’esekeli ase ekerengo gi’esekeli y’Obomenyo Obochenu. Abanto abwo nigo barenge chilifu amagana atano na rimo na isato, na amagana atano, na emerongo etano (603,550). ");
INSERT INTO guz_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Chikiro chilifu isano chi’echifeta chiria nigo chiakoretwe ase okoroisia chinterekerero chi’Obomenyo Obochenu ne chi’etoto eria; chikiro chilifu isano ase chinterekerero rigana erimo, chikiro emerongo etano ase kera enterekerero. ");
INSERT INTO guz_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ase chifeta chikiro emerongo etato na isano chiatigarete chiakoreretwe ase okoroisia ebigobanio bie chisiiro na ase okooma ebisure biabo, na koroisia chinuga chiabo. ");
INSERT INTO guz_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Chitaai chiatananetwe chibe ekerugwa, nigo chiarenge chikiro chilifu isato, na amagana atano, na emerongo ene, na isano (3,545). ");
INSERT INTO guz_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ase chitaai chiria akaroisia chinterekerero chi’egesoero ki’Eema y’Omosangererekano, na egesasiimero gi’etai amo negechungi kiaye, na ebikorero biaye bionsi, ");
INSERT INTO guz_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ne chinterekerero chie chisiiro chi’eraaro chibe chinsemo chionsi, na echi’egesoero ki’eraaro, na ebirochi bionsi bi’eema y’Obomenyo, na ebi’eraaro chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Korwa ase chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, bakaroisia chianga chinseera chi’ogokorera emeremo ime y’Aase Aachenu. Bakaroisia chianga chinchenu chia Aroni, buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bagakora egesibao ki’obokuani korwa ase chiusi chi’etaabu, na echi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya chisisire. ");
INSERT INTO guz_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Bagasunyunta etaabu ekaba eng’ao, naende bakayeninta ekaba chiusi chinyerere, bagachisang’ania ne chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, ase okoroisia egetambaa buna omooroisia omong’aini aranyare gokeroisia. ");
INSERT INTO guz_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Bakaroisia ebitwanga bi’amareko bi’egesibao keria, bakabibwatania nakerokio, magega na bosio; chinsinyo chiaye ibere ibere chikabwatanigwa amo. ");
INSERT INTO guz_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Orokini rw’okobwataneria egesibao rokaroisigwa rw’egetambaa keria ki’egesibao keroisirie korwa ase chiusi chi’etaabu, na echi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya chisisire. Bionsi bigakoreka buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Bakabaacha amagena e rigori rinene akorokwa oiniki, bakayabeeka ase ebikonde bie chitaabu; na buna omooroisia omong’aini aranyare komanya komang’era ebimanyererio, bakamang’era amarieta ’abamura ba Israeli. ");
INSERT INTO guz_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Bakayabeeka ase ebitwanga bi’amareko ase egesibao ki’obokuani, abe ase okoinyora abamura ba Israeli. Bionsi bigakoreka buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Egesembe ki’obokuani bagakeroisia, buna omooroisia omong’aini aranyare gokeroisia, korwa ase egetambaa kere buna eki’egesibao ki’obokuani, nakio keroisirie korwa ase chiusi chi’etaabu na echi’amarionya chire buru, ne chimonyinga, ne chimbariri, amo nechi’egatani engiya chisisire. ");
INSERT INTO guz_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bakaroisia egesembe keria keringire rimo; obotambe bwaye nigo bwarenge chisentimita emerongo ebere, na ibere, na obogare bwaye boigo. Chinsemo chiaye inye nigo chiarenge chireng’aine. ");
INSERT INTO guz_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Bagakebeekera emeng’ororia ene y’amagena e rigori. Ase omong’ororia bw’eritang’ani bakabeeka saridio, na topasio, na sumaridi; ");
INSERT INTO guz_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","na ase oyo o kabere alimasi, na safiro, na yasipi; ");
INSERT INTO guz_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","na ase oyo o gatato hiakinto, na agati, na ametisito; ");
INSERT INTO guz_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","na ase oyo o kane kurusolito, na oiniki, na berulo. Amagena ayio onsi bakayabeka ase ebikonde bie chitaabu. ");
INSERT INTO guz_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Na amagena ayio nigo arenge ikomi na abere, akaba namarieta ’abamura ba Israeli, amang’ekire buna ekemanyererio gekomang’wa. Kera rigena rikaba nerieta ri’egesaku ekemo ki’ebisaku biabo ikomi na bibere. ");
INSERT INTO guz_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Bagakora ebichanga bie chitaabu chichenire bisisire, bikabeekwa ase egesembe keria. ");
INSERT INTO guz_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Bagakora na ebikonde bibere bie chitaabu, ne chibonyi ibere chi’echitaabu, na bakabeeka chibonyi echi ibere ase emego ebere ya igoro y’egesembe keria. ");
INSERT INTO guz_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Bagasiberania ebichanga ebi bibere bie chitaabu ase chibonyi echi ibere ase emego y’egesembe keria. ");
INSERT INTO guz_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Naende bakabwaterania chinsinyo chinde ibere chi’ebichanga ase ebikonde biria bibere, na buna biare igo bakabibwaterania nebitwanga bi’amareko bire bosio bw’egesibao ki’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Bagakora chibonyi ibere chi’echitaabu bagachibeeka ase egesembe keria, ase emego ebere ya inse korwa magega, echigeete egesibao. ");
INSERT INTO guz_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Naende bagakora chibonyi chinde chi’echitaabu, bagachibeeka ase ebitwanga biria bibere bi’amareko bi’egesibao bire bosio, ang’e nomobarero, igoro y’orokini rw’egesibao. ");
INSERT INTO guz_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Bagachibwaterania chibonyi chi’egesembe amo nechi’egesibao ki’obokuani neusi eburu; erio egesembe gekabeera orokini igoro, tigecha gosuka. Bionsi bigakoreka buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Agakora eganchwa korwa ase egetambaa keroisirie ne chiusi chiburu chioka. ");
INSERT INTO guz_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ase eganchwa eria bakabochora engoro ase omotwe ogosoera, enga buna engoro y’esati. Engoro eria ekabekwa ekenaario buna egi’esati, techa gotandoka. ");
INSERT INTO guz_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Bagakora emegwekano y’amatunda e rikomomanga korwa ase chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri, bakayebeeka ase omoringero o inse. ");
INSERT INTO guz_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Naende bagakora chindege chi’echitaabu chichenire, bagachibeeka gati y’emegwekano ye rikomomanga chietanane omoringero o inse ase eganchwa. ");
INSERT INTO guz_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ase igo omong’ororia bw’emegwekano ye rikomomang’a bwateranirie ne chindege orenge ase omoringero o inse ase eganchwa eria ekobekwa ase obokoreri bw’obokuani. Naboigo buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Bakaroiseria Aroni amo nabamura baye chiganchwa chi’egatani engiya, ");
INSERT INTO guz_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","na egetinti amo nebigogwa emechoro bi’oboseera bi’egatani engiya, ne chisirwari chi’egatani engiya, ");
INSERT INTO guz_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","na orokini rwe chiusi chi’egatani engiya chisisire, amo ne chiusi chi’amarionya chire buru, ne chimonyinga, ne chimbariri. Bionsi bigakoreka buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Bagatura ebao y’etaabu echenire, na buna omonto akomang’a ekemanyererio, bakamang’a amang’ana aya: “Achenirwe ase Omonene”. ");
INSERT INTO guz_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Bakayesiberania bosio bw’ekegogwa ne chiusi chiburu, buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Naboigo emeremo y’Obomenyo bw’Eema y’Omosangererekano egaikeranigwa n’Abaisraeli; bagakora onsi buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Barabwo bakarentera Musa Obomenyo boria, na eema amo n’ebinto bionsi ebirabeo: ebigobanio, ne chibao, ne chisiiro amo ne chinterekerero chiabo, ");
INSERT INTO guz_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na egietubo ki’amasankwa e chimingichi, aakire etaago, na egietubo ki’amasankwa e ching’iti chia rooche, na etoto eria ekengete, ");
INSERT INTO guz_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","na Esanduki eria ere ne chibao chiriikire oborori, amo nemiaro yaye, na ekerogo kia amaabera, ");
INSERT INTO guz_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","na emesa amo nebikorero biaye bionsi, na Emegati eyare koruegwa ase Nyasae, ");
INSERT INTO guz_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na ekebekerero gie chitaaya gi’etaabu echenire, ne chitaaya chiare kobekwa aroro amo nebikorero biaye bionsi, na amaguta e chitaaya, ");
INSERT INTO guz_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","na egesasiimero gi’etaabu, na amaguta akweakwa, na ubani ekorua rimisu rigiya, na egetambaa ki’egesoero ki’Eema, ");
INSERT INTO guz_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","na egesasiimero gi’etai amo negechungi gi’etai, na emiaro yaye, na ebikorero biaye bionsi, na egetuba amo nenterekerero yaye, ");
INSERT INTO guz_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","na ebitambaa bi’eraaro, ne chisiiro amo ne chinterekerero chiabo, na egetambaa ki’egesoero ki’eraaro, ne chingori, na ebirochi, na ebikorero bionsi bi’obokoreri ase Obomenyo ime, ase Eema y’o mosangererekano, ");
INSERT INTO guz_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ne chianga chiria chinseera chi’abakuani ase obokoreri bwabo ime y’Aase Aachenu, engencho yaye chianga chia Aroni amo nechi’abamura baye barabe bakobeeka ekero bagokora emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Abaisraeli konya bakorire emeremo yonsi boronge kegima buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa akariga‐rigereria ebinto bionsi ebiakoretwe, akarora ng’a abanto babikorire boronge kegima buna Omonene konya achiikire. Erio Musa akabasesenia. ");
INSERT INTO guz_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ase rituko rie ritang’ani, omotienyi bw’eritang’ani, otenenie obomenyo, Eema eria y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Obeeke esanduki ere ne chibao chiriikire oborori imeo, na oyekenge netoto. ");
INSERT INTO guz_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Osoyie emesa, na obeeke ebinto biaye igoro yaye; osoyie na ekebekerero gie chitaaya, na obeeke chitaaya igoro yaye. ");
INSERT INTO guz_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Erio obeeke egesasiimero gi’etaabu ase ubani erasamberwe bosio bw’Esanduki ere ne chibao chiriikire oborori, na osunge egetambaa kere ase egesoero ki’obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Obeeke egesasiimero ase ebing’wanso birasamberwe bosio bw’egesoero ki’obomenyo, Eema eria y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Obeeke egetuba egati y’Eema y’omosangererekano na egesasiimero, obeeke na amaache imeo. ");
INSERT INTO guz_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Otenenie orosenge rw’egetambaa roetanane eraaro, na osunge egetambaa ase egesoero ki’eraaro. ");
INSERT INTO guz_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Oimokie amaguta akweakwa, oake obomenyo na ebinto bionsi ebire imeo na obwatanane obomenyo amo n’ebinto biaye bionsi, erinde bibe ebichenu. ");
INSERT INTO guz_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Naende oake amaguta ase egesasiimero ase ebing’wanso birasamberwe, amo nebikorero biaye bionsi. Naboigo ogiatanane, kebe egechenu mono. ");
INSERT INTO guz_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Oake egetuba amaguta amo nenterekerero yaye, na kogiatanana. ");
INSERT INTO guz_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Orente Aroni amo nabamura baye ase egesoero ki’Eema y’omosangererekano, obasibie namaache. ");
INSERT INTO guz_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Erio obeekere Aroni chianga chiria chinchenu, omoake amaguta na komwatanana, anyare gonkorera ase emeremo y’obokuani, ");
INSERT INTO guz_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Orente na abamura baye, obabeekere chianga chiabo, ");
INSERT INTO guz_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","obaake amaguta buna oraake ise, na barabwo nababe abakuani baane. Ogoakwa kw’amaguta kwabo nkobanyorere obokuani boragenderere botambe ase ororeria rwabo, ebiaare ase ebiaare.” ");
INSERT INTO guz_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa agakora onsi buna Omonene konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ase rituko rie ritang’ani, omotienyi bw’eritang’ani, omwaka o kabere magega kobarure Misiri, obomenyo boria bogatenenigwa. ");
INSERT INTO guz_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa agatenenia Obomenyo boria, akabeeka chinterekerero aase abo, agatenenia ne chibao chiaye, agasoyia emeriibo, na gotenenia chisiiro. ");
INSERT INTO guz_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Akaara eema igoro y’obomenyo boria, na kobeeka egietubo kiaye buna Omonene konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Akaimokia chibao chiriikire oborori, agachibeeka ase esanduki ime, agasoyia emiaro ase chibonyi, akamumeka esanduki eria n’ekerogo ki’amaabera. ");
INSERT INTO guz_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Akabeeka esanduki eria ime y’obomenyo, agasunga etoto eria y’egetambaa ase ogokenga esanduki ere ne chibao chiriikire oborori, buna Omonene konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Akabeeka emesa ase Eema y’omosangererekano ime, isiko y’etoto, ensemo ya sugusu, ");
INSERT INTO guz_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","na akaroberia emegati igoro yaye ase obosio bw’Omonene, buna ere konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Akabeeka ekebekerero gie chitaaya ase obomenyo ime, ensemo ya Irianyi, kororia ase emesa. ");
INSERT INTO guz_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Naende akabeeka chitaaya igoro y’ekebekerero ase obosio bw’Omonene, buna ere konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Akabeeka na egesasiimero gi’etaabu ase Eema y’omosangererekano ime, bosio bw’etoto, ");
INSERT INTO guz_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na igoro yaye agasambera ubani ekorua rimisu rigiya, buna Omonene konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Agasunga egetambaa ki’egesoero ki’obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Na egesasiimero ase ebing’wanso birasamberwe akabeeka ase egesoero ki’eema y’Omosangererekano. Igoro yaye akarua ekeng’wanso ki’ogosambwa, na okoruegwa kw’endagera, buna Omonene konya amochikiire. ");
INSERT INTO guz_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Akabeeka egetuba ase egati y’Eema y’omosangererekano na egesasiimero, akabeeka amaache ogwesibia imeo. ");
INSERT INTO guz_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa na Aroni bakaba bagoisaba amaboko na gosibia amagoro ase amaache ayio. ");
INSERT INTO guz_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ekero baare gosoa Eema y’omosangererekano, gose goika ang’e ase egesasiimero, baba bagwesibia, buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Agatenenia orosenge rw’eraaro roetanane Obomenyo na egesasiimero, na agasunga ebitambaa bi’egesoero ki’eraaro. Naboigo Musa agakoora emeremo eyio yonsi. ");
INSERT INTO guz_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Erio riire rigatuba Eema y’omosangererekano, na obonene bw’Omonene bogaichora ime ase Obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa tanyara gosoa eema y’omosangererekano, ekiagera riire riria riabeete igoro yaye, na obonene bogaichora ime ase obomenyo. ");
INSERT INTO guz_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Na ekero kende gionsi riire riare koimokerera igoro korwa ase obomenyo obwo, Abaisraeli nigo baare koimoka kogenda orogendo rwabo. Naboigo baare gokora ase orogendo rwabo rwonsi. ");
INSERT INTO guz_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Korende onye riire tiriare koimokerera igoro, barabwo tibaare koimoka kogenda goika rituko riria riire riare koimokerera igoro naende. ");
INSERT INTO guz_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Naki riire ri’Omonene nigo riare kobeera ase bomenyo ekero kia mobaso, na ekero kia botuko omorero oba ase riire ime; na agwo Abaisraeli bonsi baba bakorirora aande onsi ase barenge ase orogendo rwabo.");
INSERT INTO guz_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Omonene akarangeria Musa, agakwana nere korwa ase Eema y’Omosangererekano, akamoteebia. ");
INSERT INTO guz_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Kwana n’Abaisraeli, obateebie ng’a ekero omonto onde bwensi akorwa ase egati yabo akondeetera inche Omonene eng’iti y’ekeng’wanso, ayerusie korwa ase chiombe gose ching’ondi, gose chimbori. ");
INSERT INTO guz_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Onye ekeng’wanso ki’ogosaambwa gekorwa ase amaicho chiombe, igo keraabe eki’eeri etari na kemocho ase omobere oye, ayerente agwo ase egesoero ki’Eema y’Omosangererekano, erinde inche ’mwanchere. ");
INSERT INTO guz_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Omonto oria goika abeeke okoboko kwaye igoro ase omotwe bw’eng’iti eria ekoruegwa ekeng’wanso ki’ogosaambwa, erinde yancherwe ase okobwatania omonto oria amo n’ Omonene Nyasae. ");
INSERT INTO guz_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Erio omonto oria onyeenyete eeri eria ensae agwo ase obosio bwane inche Omonene, na abakuani, abamura ba Aroni, barente amanyinga bayasiarere chinsemo chionsi chi’egesasiimero kere agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Naende arusie riiyo ri’eng’iti eria ekoruegwa ekeng’wanso, ayenachane ebitari, ");
INSERT INTO guz_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","na abamura ba Aroni Omokuani baute omorero ase egesasiimero, bachooke chinko ase omorero oyio. ");
INSERT INTO guz_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Naende abakuani, abamura ba Aroni, babeeke ebitari biria, amo nomotwe n’ebitinya, igoro ase chinko chiria chire ase omorero bw’egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Korende chinyama chi’enda, amo nebirenge bia magega, bisibigwe namaache. Omokuani oria otenenerete asaambe eng’iti eria yonsi ase egesasiimero, ebe ekeng’wanso ki’ogosaambwa n’omorero, kere ne rimisu rigiya rikongwenera inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Onye omonto okorua ekeng’wanso ki’ogosaambwa, korwa ase amaicho ye ching’ondi, gose chimbori, nigo araarente emingichi, gose egoree, etari na kemocho ase omobere oye. ");
INSERT INTO guz_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Erio ayenyeenyere ase ensemo ya sugusu y’egesasiimero, agwo ase obosio bwane inche Omonene, na abakuani, abamura ba Aroni, basiarere amanyinga aria ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Naende anachane eng’iti eria ebitari, na Omokuani oria otenenerete, abichooke buya, amo nomotwe n’ebitinya, igoro ase chinko chiria chire ase omorero bw’egesasiimero, ");
INSERT INTO guz_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","korende chinyama chianda na ebirenge bisibigwe namaache. Erio Omokuani arue bionsi na kobisaambera ase egesasiimero. Ekio n’ekengwanso ki’ogosaambwa n’omorero, kere ne rimisu rigiya rikongwenera inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Onye omonto okomoruera Omonene ekeng’wanso ki’ogosaambwa gekorusigwa korwa ase chinyoni, rirorio omonto oyio arente amaruma gose amage amaruma. ");
INSERT INTO guz_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Omokuani arente enyoni eyio ase egesasiimero, na amiine omotwe oye, ayobutore. Erio ayosaambe ase egesasiimero. Anyititorere amanyinga ase egesasiimero ensemo, ");
INSERT INTO guz_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","korende emboochero yaye, amo neubi ere imeo, abitugute ensemo ya moocha y’egesasiimero, ase ribu rigotugutwa. ");
INSERT INTO guz_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Erio ataandorane egekuba, korende tarusia chimbaaba, ayesaambere ase egesasiimero, igoro ye chinko chiria chire ase omorero. Ekio n’ekengwanso ki’ogosaambwa n’omorero, kere ne rimisu rigiya rikongwenera inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Ekero monto onde bwensi akoreeta okoruegwa kw’endagera ase Omonene, arue obosie obonuke, anyororokerie amaguta ase obosie obwo, abeeke na ekoroso. ");
INSERT INTO guz_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Erio omonto oyio arente okoruegwa okwo ase abakuani, abamura ba Aroni. Omokuani otenenerete aimokie obosie boichire roe, amo namaguta, na ekoroso yonsi, abisaambere ase egesasiimero erio bibe ekemanyererio ng’a okoruegwa okwo nokwane inche Omonene. Okwo nokoruegwa kogosaambwa n’omorero kore ne rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ekeratigare korwa ase okoruegwa kw’endagera okwo nakobe okwa Aroni na abamura baye. Ekio negechenu mono, ekiagera kiarusiigwe korwa ase okoruegwa kogosaambwa n’omorero ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Ekero okorenta okoruegwa kw’endagera esaambeire riko nebe emegati etabeekiri memera eroisirie korwa ase obosie obonuke bwochoganirie namaguta, gose emegati emeoo eakire amaguta. ");
INSERT INTO guz_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Onye okoruegwa kwao kw’endagera n’emegati esaambeire orogio, ebe eroisirie korwa ase obosie obonuke amo namaguta, korende ebe etabeekiri memera. ");
INSERT INTO guz_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Oyesamunyorane, erio oumore amaguta igoro ase ebisamunye biria. Okwo nokoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Onye okoruegwa kwao kw’endagera n’emegati ekarangeire esuguria, ebe eroisirie korwa ase obosie obonuke amo namaguta. ");
INSERT INTO guz_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ondetere inche Omonene okoruegwa kw’endagera eroisirie ase enchera eyemo y’echio, na ekero okoruegwa okwo kwairirwe ase Omokuani nere akorente ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Omokuani arusie ensemo y’okoruegwa okwo kw’endagera ebe ekemanyererio ng’a okoruegwa okwo nokwane inche Omonene, ayesaambere ase egesasiimero. Okwo nokoruegwa kogosaambwa n’omorero kore ne rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ekeratigare korwa ase okoruegwa okwo kw’endagera nakebe ekia Aroni na abamura baye. Ekio negechenu mono, ekiagera kiarusiigwe korwa ase okoruegwa kogosaambwa n’omorero ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Okoruegwa konde gwonsi kw’endagera bakonduera inche Omonene tigokoroiseranigwa n’ememera. Timobaisa gosamba ememera, gose obooke, bibe okoruegwa kogosaambwa n’omorero ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Monyare kondeetera ebinto ebio buna ogotongora kw’endagera, korende timobaisa kobisaambera ase egesasiimero. Moise gokora igo, tigokoba ne rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Goika obeeke omoonyo ase okoruegwa kwao gwonsi kw’endagera. Ase okoruegwa okwo tibweba kobeeka omoonyo ekiagera Omoonyo nigo okworokia okobwatana gati yaino na Nyasae. (Tomocha kobekwa ase kera okoruegwa kwao). ");
INSERT INTO guz_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Aye gokorenta ogotongora kw’endagera ase ’nde inche Omonene, goika orente ebigara ebibese bisaambire ase omorero, bisenyentire. ");
INSERT INTO guz_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Oumore amaguta ase okoruegwa okwo, obeeke n’ekoroso; okwo nokoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Omokuani asaambe ebigara bike bia biria bisenyentire, amo namaguta; abisaambe amo n’ekoroso yonsi bibe ekemanyererio ng’a okoruegwa okwo nokwane inche Omonene. Okwo nokoruegwa kw’endagera kogosaambwa n’omorero ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Omonto kararue ekeng’wanso ki’omorembe ase obosio bwane inche Omonene, nigo ararente eeri gose eng’ombe etari na kemocho ase omobere oye. ");
INSERT INTO guz_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Omonto oyio goika abeeke okoboko kwaye igoro ase omotwe bw’eng’iti eyio ekoruegwa ekeng’wanso, erio ayenyeenyere agwo ase egesoero ki’Eema y’Omosangererekano, na abakuani, abamura ba Aroni, basiarere amanyinga aria ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Korwa ase eng’iti y’ekeng’wanso ekio ki’omorembe arusie ebitinya bitubete chinyama chi’enda, n’ebitinya binde bionsi bire ase enda ime, amo ne chinyigo chionsi ibere n’ebitinya bichitubete; n’ebitinya bie riini abirusie amo ne chinyigo. Ebinto ebio bionsi abirue bibe ekeng’wanso ki’ogosaambwa n’omorero ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Erio abamura ba Aroni babisaambere ase egesasiimero, igoro y’ekeng’wanso ki’ogosaambwa kebeekire ase chinko chiria chire ase omorero. Ekio n’ekengwanso kegosaambwa n’omorero kere ne rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Omonto kararue ekeng’wanso ki’omorembe ase ’nde inche Omonene, korwa ase riicho rie ching’ondi, gose chimbori, arente eng’iti etari na kemocho ase omobere oye, etuoni gose eaberi. ");
INSERT INTO guz_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Onye okorua eng’ondi ebe ekeng’wanso kiaye, erio ayerue ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ere goika abeeke okoboko kwaye igoro ase omotwe bw’eng’ondi eyio akorua ebe ekeng’wanso, erio ayenyeenyere agwo bosio bw’Eema y’Omosangererekano. Abamura ba Aroni basiarere amanyinga aria ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","10","Korwa ase ekeng’wanso ekio ki’omorembe arue ebitinya, na omokera bwonsi ayobutore kegima korwa ase riuga ri’omogongo, n’ebitinya bitubete chinyama chionsi chi’enda, n’ebitinya binde bionsi bire ase enda ime, ne chinyigo chionsi ibere, amo nebitinya bichitubete; n’ebitinya bie riini abirusie amo ne chinyigo. Ebinto ebio bionsi bibe ekeng’wanso kegosaambwa n’omorero ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Omokuani otenenerete asaambe ebinto ebio bionsi ase egesasiimero bibe endagera ekoruegwa ekeng’wanso kegosaambwa n’omorero ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Onye ekeng’wanso kiaye nembori, ayerue ase obosio bwane, ");
INSERT INTO guz_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","na omonto oyio goika abeeke okoboko kwaye igoro ase omotwe bw’embori eyio, erio ayenyeenyere agwo bosio bw’Eema y’Omosangererekano. Abamura ba Aroni basiarere amanyinga aye ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","Erio korwa ase ekeng’wanso ekio arue ebitinya bionsi ebire ase enda ime, ne chinyigo chionsi ibere, n’ebitinya bie riini abirusie amo ne chinyigo. Ebinto ebio bionsi abirue bibe ekeng’wanso kegosaambwa n’omorero ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Omokuani abisaambere ase egesasiimero bibe endagera ekoruegwa egosaambwa n’omorero, ere ne rimisu rigiya rikongwenera. Ebitinya bionsi nebiane. ");
INSERT INTO guz_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Oyo nigo oraabe omooroberio ochiikire oragenderere botaambe ebiaare ase ebiaare, aande onsi ase moraabe mokomenya, ng’a timobaisa koria ebitinya, gose konywa amanyinga.” ");
INSERT INTO guz_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Naende Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Kwana n’Abaisraeli, obateebie ng’a monto onde bwensi orakore ebibe mosiabano atancheti, ase amang’ana ande onsi inche Omonene nakaanete ng’a takorwa, goika abe okobwatia amachiiko aya. ");
INSERT INTO guz_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Onye Omokuani oyoakire amaguta ogokora ebibe, na igo arentere abanto bonsi okomocha, goika arue eeri ensae etari na kemocho ase omobere oye, ase engencho y’ebibe ebio akorire, ayerue ase ’nde ebe ekeng’wanso ki’ebibe biaye. ");
INSERT INTO guz_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Arente eeri eria ase obosio bwane agwo ase egesoero ki’Eema y’Omosangererekano. Erio goika abeeke okoboko kwaye igoro ase omotwe bw’eeri eria, na ayenyeenyere agwo ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Omokuani oyoakire amaguta aimokie amanyinga make ay’eeri eria, ayarente ime ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Naende atobeke ekiara kiaye ase amanyinga ayio, ayanyororokerie ara gatano na kabere bosio bw’etoto eyio enachete Obomenyo Obochenu, agwo ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Magega y’ayio Omokuani oria agindie amanyinga make ase emegwekano ye ching’unchara ere ase chikoona chi’egesasiimero ase n’ekoroso egosaamberwa, kere ime ase Eema y’Omosangererekano, ase obosio bwane, na amanyinga ’eeri eria agotigara ayaumore inse agwo ase egesasiimero gi’ekeng’wanso ki’ogosaambwa kere ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Erio arusie ebitinya bionsi bi’eeri eria y’ekeng’wanso ki’ebibe, n’ebitinya bitubete chinyama chi’enda, n’ebitinya binde bionsi bire ase enda ime, ");
INSERT INTO guz_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","amo ne chinyigo chionsi ibere, n’ebitinya bichitubete bire ang’e nomogongo; n’ebitinya bie riini abirusie amo ne chinyigo, ");
INSERT INTO guz_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","koreng’ana buna akobirusia korwa ase eng’ombe eria ekonyeenywa ebe ekeng’wanso ki’omorembe. Erio abisaambere ase egesasiimero gi’ekeng’wanso. ");
INSERT INTO guz_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Korende riiyo ri’eeri eyio amo ne chinyama chionsi, na omotwe, na ebirenge, na enda, na esike, ");
INSERT INTO guz_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ebinto ebio bionsi bi’eeri eyio abisokie isiko y’ebitwori, abiire gochia aase achenire, ase ribu rigotugutwa, abisaambere ase omorero bwe chinko agwo igoro ase ribu. ");
INSERT INTO guz_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Onye omoganda bwonsi bw’Abaisraeli okorire ebibe mosiabano otancheti, na amang’ana ayio abe abisekanire ase bare, keraabe bakorire kende gionsi eki inche Omonene nakaanete ng’a tigekorwa, na igo babeire nokomocha, ");
INSERT INTO guz_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","agwo ekero ebibe biria biraabe biamanyekanire, omosangererekano orue eeri ensae ebe ekeng’wanso ki’ebibe na koyerenta agwo bosio bw’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Agwo ase obosio bwane abagaaka b’omoganda oria goika babeeke amaboko abo igoro ase omotwe bw’eeri eyio, na ero enyenyerwe agwo ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Omokuani oyio oakire amaguta, aire amanyinga make ay’eeri eyio ase Eema y’Omosangererekano ime. ");
INSERT INTO guz_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Erio atobeke ekiara kiaye ime ase amanyinga na anyororokererie ara gatano na kabere ase obosio bwane agwo bosio bw’etoto eria y’egetambaa, ");
INSERT INTO guz_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","agindie amanyinga make ase emegwekano ye ching’unchara chi’egesasiimero kere ime y’Eema y’Omosangererekano, agwo ase obosio bwane, korende amanyinga onsi aya agotigara ayaumore agwo inse ase egesasiimero gi’ekeng’wanso ki’ogosambwa kere ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Naende ebitinya bionsi bi’eeri eyio abirusie na kobisaambera ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Naboigo arakore eeri eyio buna akorete eeri eria ye ritang’ani y’ekeng’wanso ki’ebibe. Ase enchera eyio Omokuani akore okobwatanigwa ase bare, na barabwo nabaaberwe. ");
INSERT INTO guz_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Erio aire eeri eyio isiko y’egetwori, ayesaambere aroro, buna asaambete eeri eria ye ritang’ani. Ekio n’ekengwanso ki’ebibe ase engencho y’omoganda bwonsi. ");
INSERT INTO guz_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Omogambi karakore ebibe mosiabano atancheti, na akore amang’ana ande onsi inche Omonene, Nyasae oye, nakaanete ng’a takorwa, na igo obeire nokomocha, ");
INSERT INTO guz_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","agwo ekero ebibe biria akorete biraabe biamanyekanire asare, arente egoree etari na kemocho ase omobere oye, ebe ekeng’wanso kiaye. ");
INSERT INTO guz_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ere goika abeeke okoboko kwaye igoro ase omotwe bw’egoree eyio, ayenyeenyere agwo aase abanto bakonyenyera ebing’wanso bi’ogosaambwa, ase obosio bwane inche Omonene. Ekio n’ekengwanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Omokuani atobeke ekiara kiaye ime ase amanyinga ayagindie ase emegwekano ye ching’unchara chi’egesasiimero gi’ekeng’wanso ki’ogosaambwa, korende amanyinga onsi agotigara ayaumore agwo inse ase egesasiimero ekio. ");
INSERT INTO guz_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ebitinya biaye bionsi abisaambere ase egesasiimero buna ebi’ekeng’wanso ki’omorembe bigosaambwa. Ase enchera eyio Omokuani akore okobwatanigwa ase omogambi oria ase engencho y’ebibe biaye, na omogambi oria naaberwe. ");
INSERT INTO guz_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Onye omonto onde bwensi ogokora ebibe mosiabano atancheti, ase amang’ana ande onsi inche Omonene nakaanete ng’a takorwa, na igo obeire nokomocha, ");
INSERT INTO guz_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","agwo ekero ebibe bi’omonto oria biraabe biamanyekanire asare arente esubeni etari na kemocho ase omobere oye, ebe ekeng’wanso ki’ebibe biaye. ");
INSERT INTO guz_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Erio abeeke okoboko kwaye igoro ase omotwe bw’embori eria ekoruegwa ekeng’wanso ki’ebibe, na ayenyeenyere agwo ase ebing’wanso bi’ogosaambwa bikonyeenyerwa. ");
INSERT INTO guz_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Omokuani aimokie amanyinga make, atobeke ekiara kiaye agindie emegwekano ye ching’unchara chi’egesasiimero ki’ogosaambera ebing’wanso; amanyinga aya agotigara ayaumore agwo inse, ase egesasiimero ekio. ");
INSERT INTO guz_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Erio arusie ebitinya bionsi bi’embori eyio buna ebitinya bi’eng’iti y’ekeng’wanso ki’omorembe bikorusigwa, na Omokuani asaambere ebitinya ebio ase egesasiimero bibe rimisu rigiya rikongwenera. Ase enchera eyio Omokuani akore okobwatanigwa ase omonto oria, na omonto oria naaberwe. ");
INSERT INTO guz_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Omonto oria kararue emaanwa y’eng’ondi ebe ekeng’wanso ki’ebibe, arente esigiti etari na kemocho ase omobere oye. ");
INSERT INTO guz_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ere abeeke okoboko kwaye igoro ase omotwe bw’emaanwa eria, ayenyeenyere agwo ase ebing’wanso bi’ogosaambwa bikonyeenyerwa, ebe ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Omokuani aimokie amanyinga make ay’emaanwa eyio, atobeke ekiara kiaye agindie emegwekano ye ching’unchara chi’egesasiimero ki’ogosaambera ebing’wanso, korende amanyinga ayagotigara ayaumore agwo inse, ase egesasiimero ekio. ");
INSERT INTO guz_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Erio arusie ebitinya bionsi bi’eng’ondi eyio, buna ebitinya bi’emaanwa y’eng’ondi y’ekeng’wanso ki’omorembe bikorusigwa, na Omokuani abisaambere ase egesasiimero, igoro ase ekeng’wanso kegosaamberwa n’omorero ase ’nde. Ase enchera eyio Omokuani nakore okobwatanigwa ase omonto oria ase engencho y’ebibe biaye, na omonto oria naaberwe. ");
INSERT INTO guz_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Onye omonto okorangerigwa abe kirori na gotiana, anyare koorokia aya aroche, gose aigwete, ko tayaorokia, ere goika abarerwe obobe boria bw’ogotaorokia. ");
INSERT INTO guz_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Onye omonto ogokuna kende gionsi getachenegeti, koraabe omobere okwete bw’eng’iti y’orosana etachenegeti, gose oyo bw’eng’iti etugire etachenegeti, gose oyo bw’akang’iti agake gatechenegeti, nonya amang’ana ayio abisekanete, ere nabe oyotachenegeti, abarerwe obobe bwaye. ");
INSERT INTO guz_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Omonto aise gokuna egento kende gionsi kia Mwanyabaanto getachenegeti, gokoraabe ogotacheneka gwa kende gionsi keramokore abe oyotachenegeti, nonya amang’ana ayio abisekanete asare, ekero arayamanye, nabe nokomocha. ");
INSERT INTO guz_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Omonto karabe omwango gotiana ase ogokora amabe gose amaya, ogotiana konde gwonsi buna abanto bande bakoba abaango gotiana batari korengereria, na ayio abe abisekanete ase omonto oyio, ekero arayamanye, nabe nokomocha ase amang’ana ayio. ");
INSERT INTO guz_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Ekero omonto arabe nokomocha ase amang’ana goika aorokie ebibe ebio akorire. ");
INSERT INTO guz_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Naende andeetere inche Omonene ekeng’wanso gi’okorongeyia okomocha kwaye ase engencho y’ebibe ebio akorire; arente eng’iti eaberi, eng’ondi gose embori, ebe ekeng’wanso ekio ki’ebibe, na Omokuani akore okobwatanigwa ase omonto oria, na omonto oria naaberwe ebibe biaye. ");
INSERT INTO guz_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Korende onye omonto oria takonyara konyora eng’ondi, gose embori, rirorio andeetere inche Omonene amaruma abere, gose amage y’amaruma abere, abe ekeng’wanso gi’okorongeyia okomocha kwaye ase engencho y’ebibe akorire. Erimo ribe ekeng’wanso ki’ebibe, na erinde ekeng’wanso ki’ogosaambwa. ");
INSERT INTO guz_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Arente amaruma ayio ase Omokuani, nere arue ritang’ani riruma erimo ribe ekeng’wanso ki’ebibe, amiine ebigoti bie riruma erio, korende tabutora omotwe korwa ase ebigoti. ");
INSERT INTO guz_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Erio anyororokerie amanyinga make y’ekeng’wanso ekio ki’ebibe ase egesasiimero ensemo. Amanyinga agotigara ayanyititorerie agwo inse ase egesasiimero. Ekio n’ekengwanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Naende arue riruma ria kabere ribe ekeng’wanso ki’ogosaambwa, koreng’ana buna achiikire. Ase enchera eyio Omokuani akore okobwatanigwa ase omonto oria ase engencho y’ebibe ebi akorire, na omonto oria naaberwe. ");
INSERT INTO guz_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Korende onye omonto oria takonyara konyora amaruma abere, gose amage ’amaruma abere, rirorio arente obosie obonuke ebimunu bibere bobe okoruegwa kw’ebibe biaye. Tabeeka amaguta, gose ekoroso, ase okoruegwa okwo, ekiagera nokoruegwa kw’ebibe. ");
INSERT INTO guz_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Arente obosie obwo ase Omokuani, na Omokuani aimokie obosie obwo boichire roe bobe ekemanyererio ng’a okoruegwa okwo kwarurwe ase ’nde inche Omonene, erio abosaambere ase egesasiimero, igoro ase ebing’wanso bigosaamberwa n’omorero ase ’nde. Okwo nokoruegwa gw’okorusia ebibe. ");
INSERT INTO guz_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ase enchera eyio Omokuani akore okobwatanigwa ase omonto oria ase engencho y’ebibe akorire ase ring’ana rinde rionsi ri’ayio, na omonto oria naaberwe. Oboratigare bobe obw’Omokuani, buna obw’okoruegwa kw’endagera bokoba obwaye.” ");
INSERT INTO guz_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Monto onde bwensi karasarie na akore ebibe mosiabano atancheti ase ogotarua ebinto biatananirwe na gochenwa ase ’nde, goika andeetere emingichi etari na kemocho ase omobere oye, ayerusie korwa ase riicho riaye ebe ekeng’wanso gi’okorongeyia okomocha kwaye. Naye oyekorere rigori rireng’aine eri’esekeli egokorerwa ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Omonto oria naakane egento keria egechenu ataruete, naende goika ameente ensemo ya isano ye rigori ri’egento ekio, ayee Omokuani. Erio Omokuani arue emingichi eyio y’ekeng’wanso gi’okomocha na akore okobwatanigwa ase omonto oria, na omonto oria naaberwe. ");
INSERT INTO guz_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Monto onde bwensi aise gokora gento ase amang’ana ayio inche Omonene nakaanete ng’a takorwa, nonya tamanyeti ng’a ayio akorire nokomocha, ere omochire, goika abarerwe okomocha okwo. ");
INSERT INTO guz_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ase ayio arente korwa ase riicho riaye emingichi etari na kemocho ase omobere oye ebe ekeng’wanso gi’okomocha. Naye oyekorere rigori. Ase enchera eyio Omokuani akore okobwatanigwa ase omonto oria ase engencho y’okomocha koria akorire mosiabano atancheti, na omonto oria naaberwe. ");
INSERT INTO guz_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ekio n’ekengwanso gi’okomocha. Omonto oria nigo areenge nokomocha ase obosio bw’Omonene.” ");
INSERT INTO guz_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Omonto aise gokora ebibe na gosaria ase ’nde inche Omonene ase okong’ainereria omogisangio oye ase okwanga koirania ebinto aetwe ase amaboko aye abirende, gose ase okomourereria, gose ase okomoibera ase okomorega, ");
INSERT INTO guz_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","gose onyorire egento giasirete, naende akane na gotiana ng’a takenyorete, bibe ebibe binde bionsi abanto bagokora, ");
INSERT INTO guz_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ekero omonto akorire ebibe buna ebio na obeire nokomocha, nairanie egento keria airete ase obourereria, gose ase okorega, gose egento aetwe korenda, gose egento giasirete agakenyora, ");
INSERT INTO guz_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","gose egento kende gionsi keria atianete ase okong’ainereria; goika akeiranie gionsi, naende ameente ensemo ya isano ase rigori riaye akee omonyene ase rituko riria akorua ekeng’wanso gi’okomocha. ");
INSERT INTO guz_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Erio andeetere inche Omonene emingichi etari na kemocho ase omobere oye; ayerusie korwa ase riicho riaye rie ching’ondi, ebe ekeng’wanso gi’okorongeyia okomocha kwaye; naye oyekorere rigori, na omonto oria ayeirere Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Omokuani akore okobwatanigwa ase omonto oyio ase obosio bwane, na omonto oyio naaberwe ase kende gionsi akorire na kwerentera okomocha.” ");
INSERT INTO guz_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Moe Aroni amo nabamura baye ogochika oko igoro y’ekeng’wanso ki’ogosaambwa; Ekeng’wanso ki’ogosaambwa kebeere igoro ase egesasiimero obotuko bwonsi goika mambia, na omorero bw’egesasiimero orendwe ogenderere gwoka. ");
INSERT INTO guz_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Omokuani abeeke eganchwa yaye y’egatani, amo ne chisirwari chi’ogwetuba, erio abuuche ribu korwa ase omorero oria osaamberete ekeng’wanso ase egesasiimero, aribeke ase egesasiimero ensemo. ");
INSERT INTO guz_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Magega y’ayio arusie chianga chiaye, abeeke chianga ching’ao, naende aimokie ribu, arisokie isiko y’egetwori, ariire gochia aase achenire. ");
INSERT INTO guz_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Omorero ore ase egesasiimero orendwe ogenderere gwoka, torima. Kera emambia Omokuani ameente chinko ase omorero oyio, naende achooke buya ekeng’wanso ki’ogosaambwa igoro ase chinko echio na asaambe ebitinya bi’ekeng’wanso ki’omorembe. ");
INSERT INTO guz_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Omorero oyio orendwe ogenderere gwoka botaambe, ase egesasiimero tobaisa korima. ");
INSERT INTO guz_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Oko nakwo ogochika gw’okoruegwa kw’endagera: Abamura ba Aroni babe bakorua okoruegwa kw’endagera ase obosio bw’Omonene, agwo ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Erio Omokuani otenenerete aimokie obosie obonuke boichire roe korwa ase okoruegwa okwo kw’endagera, na amaguta, n’ekoroso yonsi ere igoro yaye, abisaambere ase egesasiimero, bibe ekemanyererio ng’a okoruegwa okwo nokwane inche Omonene, kore ne rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aroni na abamura baye goika barie eyegotigara ase okoruegwa okwo etabeekiri memera, bayeriere aase achenire, agwo ase eraaro y’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Tebaisa koroiseranigwa n’ememera. Inche nabaeire endagera eyio ebe egetari kiabo gi’okoruegwa kwane kogosaambwa n’omorero. Ekio negechenu mono koreng’ana buna ekeng’wanso ki’ebibe na egi’okomocha bire. ");
INSERT INTO guz_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Kera omonto omosacha ase ororeeria rwa Aroni nanyare koria endagera eyio. Ekio nkebe egetari kiabo kia botaambe, gi’okoruegwa kwogosaambwa n’omorero ase ’nde inche Omonene, ebiaare ase ebiaare. Monto onde bwensi orakune ebing’wanso ebio nigo arabe omochenu.” ");
INSERT INTO guz_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Naende Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Oko nakwo okoruegwa Aroni na abamura baye bararue ase ’nde inche Omonene ase rituko riria onde obo araakwe amaguta na gwatananwa: Ebimunu bibere bi’obosie obonuke, buna okoruegwa kw’endagera gwa kera rituko, ekemo mambia na ekende mogoroba. ");
INSERT INTO guz_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Okoruegwa okwo gokorapuugwe namaguta ase orogio, gosamunyorwe, erio kobe okoruegwa kw’endagera kore ne rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Omokuani, omomura o Aroni, oyo oakire amaguta na gwatananwa ase okomobwatia, nere orarue okoruegwa okwo ase ’nde. Okwo nogochika koragenderere botaambe. Okoruegwa okwo nagosambwe gwonsi ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kera okoruegwa kw’endagera Omokuani akorua goika gosambwe gwonsi, tikobaisa koriegwa.” ");
INSERT INTO guz_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Moe Aroni amo nabamura baye ogochika oko igoro y’ekeng’wanso ki’ebibe: Agwo ase ekeng’wanso ki’ogosaambwa gekonyeenyerwa nao agwo eki’ebibe keranyenyerwe, ase obosio bwane inche Omonene. Ekeng’wanso ekio negechenu mono. ");
INSERT INTO guz_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Omokuani oyio okorua ekeng’wanso ekio nakeriere Aase achenire, agwo ase eraaro y’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Onde bwensi orakune enyama y’ekeng’wanso ekio nabe omochenu; naboigo na kende gionsi kerayekune, na amanyinga ’ekeng’wanso ekio aise gotonyera eanga, eyio esiberigwe agwo Aase achenire. ");
INSERT INTO guz_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Enyongo ye chinyama echio chiraiyekerwe goika yaatwe, korende onye chikoiyekerwa ase esuguria, rirorio ero esisikigwe na ogosibigwa namaache. ");
INSERT INTO guz_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kera omonto omosacha ore ase chinka chi’abakuani arie chinyama echio echire chinchenu mono. ");
INSERT INTO guz_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Korende ekeng’wanso ki’ebibe, ekio amanyinga aye araarentwe ime y’Eema y’Omosangererekano ase ogokora okobwatanigwa ime y’Aase Aachenu tigekoriegwa, nigo kerasambwe n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Oko nakwo ogochika gw’okorua ekeng’wanso gi’okorongeyia okomocha. Ekio n’ekengwanso egechenu mono. ");
INSERT INTO guz_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Aase agwo eng’iti y’ekeng’wanso ki’ogosaambwa ekonyeenyerwa nao eng’iti y’ekeng’wanso gi’okorongeyia okomocha eranyenyerwe. Amanyinga aye asiarerwe ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ebitinya biaye bionsi birusigwe na koruegwa; omokera n’ebitinya bitubete chinyama chi’enda, ");
INSERT INTO guz_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ne chinyigo chionsi ibere amo nebitinya bichitubete bire ang’e nomogongo, n’ebitinya bie riini birusigwe amo ne chinyigo. ");
INSERT INTO guz_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Omokuani abisaambere ase egesasiimero, bibe ekeng’wanso kegosaambwa n’omorero ase Omonene. Ekio n’ekengwanso gi’okorongeyia okomocha. ");
INSERT INTO guz_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Abanto bagwenerete kobwaterana ase okorua ekengwanso ekio, kera omosacha bw’enka y’Omokuani. Oyio nakeriere agwo Aase achenu, ekiagera agwo nase achenu mono kegima. ");
INSERT INTO guz_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Ogochika gw’okorua ekeng’wanso gi’okorongeyia okomocha, nigo kore okomo nogw’ekeng’wanso ki’ebibe. Omokuani oria ogokora okobwatanigwa nakerokio aire chinyama chi’ekeng’wanso eke chibe echiaye. ");
INSERT INTO guz_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Omokuani okorua ekeng’wanso ki’ogosaambwa ase engencho y’omonto onde, Omokuani oyio omonyene aire risankwa ri’ekeng’wanso keria ribe eriaye. ");
INSERT INTO guz_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kera okoruegwa kw’endagera ’echinyeke koroiseirie riiko, na kende gionsi ekeroiseirie ase orogio, gose ase egetega, okwo ’nakobe okw’Omokuani oria okoruete ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Kera okoruegwa kw’endagera gwochoganirie namaguta, gose ogotari namaguta, abamura ba Aroni baegwe, baatananerwe bareng’anerigwe. ");
INSERT INTO guz_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Oko nakwo ogochika gw’okorua ekeng’wanso ki’omorembe, ekio omonto araarente ase Omonene. ");
INSERT INTO guz_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Onye omonto okorua ekeng’wanso ekio ase ogoaka ng’a mbuya mono, rirorio amo n’ekengwanso ekio arue okoruegwa kw’amaandasi atabeekiri memera aroisirie namaguta, na emegati emeoo etabeekiri memera eakire amaguta, na emegati y’obosie obonuke bwochoganirie namaguta. ");
INSERT INTO guz_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Amo n’ekengwanso kiaye ki’omorembe ki’ogoaka ng’a mbuya mono, arente emegati ebekire ememera. ");
INSERT INTO guz_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Korwa ase okoruegwa okwo arue omogati oyomo bwa kera egesaku, ebe ekeegwa ase Omonene. Eyio ebe ey’Omokuani oyio ogosiarera amanyinga ’ekeng’wanso keria ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Chinyama chi’ekeng’wanso kiaye ki’omorembe ki ogoaka ng’a mbuya mono chiriegwe ase rituko riria gekoruegwa; tichibaisa gotigara nonya ne chinsinini goika rituko ria kabere. ");
INSERT INTO guz_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Korende onye omonto okorua ekeng’wanso ase engencho y’eira ariete, gose neki’ogwancha kwaye, nakeriegwe ase rituko riria gekoruegwa, na ekegotigara keriegwe ase rituko ria kabere. ");
INSERT INTO guz_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Chinyama chi’ekeng’wanso ekio chigotigara ase rituko ria gatato goika chisambwe n’omorero chiyie chiere. ");
INSERT INTO guz_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Onye enyama ende yonsi y’ekeng’wanso kiaye ki’omorembe ekoriegwa ase rituko ria gatato, ekeng’wanso ekio tikegwancherwa, gose oyo okeruete takobarerwa ekeng’wanso ekio. Ekio nakebe okogechia, na onde bwensi oraarie enyama y’ekeng’wanso ekio nabarerwe obobe bwaye. ");
INSERT INTO guz_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Enyama eyio keraakune gento kende gionsi getachenegeti esambwe n’omorero, eyie eere. “Onye enyama echenegete, kera omonto ochenekire nare ne ribaga ri’okoyeria, ");
INSERT INTO guz_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","korende oyotachenegeti takoria enyama y’ekeng’wanso ki’omorembe gekoruegwa ase Omonene. Aise gokora igo, nigo araatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“Naende omonto karakune egento getachenegeti, gokeraabe egetachenegeti kere ase omonto, gose ase eng’iti, gose okogechia konde gwonsi, na arie enyama y’ekeng’wanso ki’omorembe gekoruegwa ase Omonene, omonto oyio nigo araatananwe korwa ase abanto baye.” ");
INSERT INTO guz_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Kwana n’Abaisraeli, obateebie ng’a tibaabaisa koria ebitinya binde bionsi, ebi’eng’ombe, gose ebi’eng’ondi, gose ebi’embori. ");
INSERT INTO guz_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ebitinya bi’eng’iti egokwa yoka enyene, na ebi’eng’iti egoitwa neyende, ebio nabikorerwe emeremo emeao, korende tibikoriegwa nonya ng’ake. ");
INSERT INTO guz_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Monto onde bwensi oraarie ebitinya bi’eng’iti yarurwe ekeng’wanso kegosaambwa n’omorero ase ’nde inche Omonene, oyio nigo eraatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Naende timoria amanyinga e chinyoni, gose aye ching’iti aande onsi ase moramenye. ");
INSERT INTO guz_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Monto onde bwensi oraarie amanyinga ande onsi, oyio nigo araatananwe korwa ase abanto baye.” ");
INSERT INTO guz_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Naende Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Kwana n’Abaisraeli, obateebie ng’a omonto onde bwensi orarue ekeng’wanso ki’omorembe, arue korwa ase ekeng’wanso ekio gentungetie inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Arente namaboko aye omonyene ekeng’wanso kiaye kegosaambwa n’omorero ase ’nde inche Omonene; arente ebitinya amo ne ritaana, ne ritaana erio risungusigwe ribe ekeng’wanso kegosungusigwa ase obosio bwane inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Omokuani asaambere ebitinya ase egesasiimero, korende ritaana ribe eria Aroni na abamura baye. ");
INSERT INTO guz_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ekenama kia borio okee Omokuani buna ekeegwa korwa ase ebing’wanso biaino bi’omorembe. ");
INSERT INTO guz_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Omokuani, omomura o Aroni, oyio oraabe okorua amanyinga ’ekeng’wanso ekio ki’omorembe amo nebitinya, nere oraire ekenama keria kia borio kebe egetari kiaye. ");
INSERT INTO guz_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Korwa ase ekeng’wanso ki’omorembe gekoruegwa n’Abaisraeli narusirie ritaana rigosungusigwa amo nekenama kia borio, nabieire Aroni Omokuani na abamura baye. Ebio nabio Abaisraeli barabe bakoa abakuani, bibe ebitari biabo botaambe. ");
INSERT INTO guz_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“Ekio negetari kemotungetie Aroni na abamura baye korwa ase ebing’wanso bigosaambwa n’omorero ase ’nde; nigo kiabeete ekiabo korwa rituko riria baatananetwe bakaba abakuani bagonkorera inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Rituko riria baagetwe amaguta inche ngachiika ng’a egetari ekio korwa ase Abaisraeli kebe ekiabo kogenderera botaambe, ebiaare ase ebiaare.” ");
INSERT INTO guz_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Oko nakwo ogochika igoro y’ekeng’wanso ki’ogosaambwa, na okoruegwa kw’endagera, na ekeng’wanso ki’ebibe, na egi’okorongeyia okomocha, na eki’ogosungusigwa, na eki’omorembe. ");
INSERT INTO guz_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ogochika okwo nakwo Omonene aete Musa ase egetunwa gia Sinai, agwo ase erooro ya Sinai, ase rituko riria achiigete Abaisraeli bamoruere Omonene ebing’wanso biabo. ");
INSERT INTO guz_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ira Aroni na abamura baye amo ne chianga chiabo chi’obokuani, na amaguta akweakwa, na eeri ekoruegwa ekeng’wanso ki’ebibe, ne chimingichi ibere, na egetonga kere n’emegati etabeekiri memera. ");
INSERT INTO guz_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Naende orangerie omoganda bwonsi osangererekane ase egesoero ki’Eema y’Omosangererekano.” ");
INSERT INTO guz_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa agakora buna Omonene amochiigete, na ekero omoganda bwonsi osangererekanete ase egesoero ki’Eema y’Omosangererekano, ");
INSERT INTO guz_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa akayoteebia. “Aya nar’Omonene achiikire akorwe.” ");
INSERT INTO guz_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Musa akarenta Aroni na abamura baye, akabasibia namaache. ");
INSERT INTO guz_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Akabeekera Aroni eganchwa erobekanirie eigete inse, na eganchwa eria ende, akamoboeria norokini. Naende akamobeekera egesibao ki’obokuani, akamoboeria norokini rw’egesibao roroisirie nomonto omong’aini. ");
INSERT INTO guz_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Erio akamobeekera egesembe, na ime ase egesembe ekio akabeeka Urimu na Tumimu (omobaso na oboikeranu). ");
INSERT INTO guz_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Akamobeekera ekegogwa ase omotwe oye, na bosio ase ekegogwa ekio agasiberania ekemanyererio egechenu gi’etaabu kiareenge kworokia ng’a bwatananirwe. Ase igo Musa agakora buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Musa akaimokia amaguta akweakwa, agaaka Obomenyo Obochenu, na kera egento kiareenge imeo, akabiaatanana bikaba ebichenu. ");
INSERT INTO guz_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Akanyororokeria egesasiimero namaguta akweakwa ara gatano na kabere, naende agaaka egesasiimero amaguta aria, agaaka nebikorero bionsi, na egetuba amo nenterekerero yaye ase okobiaatanana bibe ebichenu. ");
INSERT INTO guz_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Akaumora amaguta akweakwa igoro ase omotwe o Aroni, na akamoaka amaguta ase okomwaatanana na komochena. ");
INSERT INTO guz_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Naende Musa akarenta abamura ba Aroni, akababeekera chiganchwa, akababoeria chinkini na akababeekera ebigogwa ebike ase emetwe yabo, buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Musa akarenta eeri ebe ekeng’wanso ki’ebibe, erio Aroni amo nabamura baye bakabeeka amaboko abo igoro ase omotwe bw’eeri eyio. ");
INSERT INTO guz_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Eeri eyio ekanyenywa, erio Musa agatobeka ekiara kiaye ase amanyinga y’eeri eyio, akayagindia ase emegwekano yonsi ye ching’unchara ere ase chikoona chi’egesasiimero, na agachena egesasiimero; na amanyinga aria atigarete akayaumora ase egesasiimero inse, akagiaatanana na kogechena, na igo akagekorera okobwatanigwa. ");
INSERT INTO guz_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Akaimokia ebitinya bionsi biareenge ase chinyama chi’enda, n’ebitinya bie riini, ne chinyigo chionsi ibere amo nebitinya bichitubete, Erio Musa akabisaambera ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Korende ebiatigarete korwa ase eeri eria, riiyo riaye, ne chinyama, na esike, akabisokia isiko y’egetwori akabisaambera aroro, buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Erio akarenta emingichi ebe ekeng’wanso ki’ogosaambwa, na Aroni amo nabamura baye bakabeeka amaboko abo ase omotwe bw’emingichi eyio. ");
INSERT INTO guz_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Emingichi eyio ekanyenywa, na Musa agasiara amanyinga y’emingichi eyio ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Akanachana chinyama chi’emingichi eyio chikaba ebitari, agasibia chinyama chi’enda na ebirenge namaache. Erio agasamba omotwe, na ebitari biria, n’ebitinya, ne chinyama chionsi chi’emingichi eyio ase egesasiimero. Emingichi eyio ekaba ekeng’wanso kegosaambwa n’omorero, kere ne rimisu rigiya rikomogwenera Omonene. Naboigo Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Musa akarenta emingichi ya kabere, eyio yaruetwe ase ogwaatanana abakuani ase emeremo emechenu, Aroni na abamura baye bakabeeka amaboko abo igoro ase omotwe bw’emingichi eyio. ");
INSERT INTO guz_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Emingichi eyio ekanyenywa, na Musa akaimokia amanyinga make, akagindia mesia y’ogoto kwa borio kwa Aroni, na ekiara ekenene gi’okoboko kwaye kwa borio, na ekiara ekenene gi’okogoro kwaye kwa borio. ");
INSERT INTO guz_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Boigo abamura ba Aroni bakarentwa na Musa akagindia amanyinga mesia y’amato abo a borio, na ebiara ebinene bi’amaboko abo a borio, na ebiara ebinene bi’amagoro abo a borio. Erio amanyinga aria atigarete akayasiarera ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Akaimokia ebitinya, na omokera, n’ebitinya bionsi bie chinyama chi’enda, n’ebitinya bie riini, ne chinyigo ibere, amo nebitinya bichitubete, na ekenama kia borio. ");
INSERT INTO guz_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Naende korwa ase egetonga keria kiareenge agwo ase obosio bw’Omonene akarusia omogati oyomo otabeekiri memera, ne rindasi erimo, na omogati oyomo omoo, erio akabibeeka igoro ase ebitinya ebio na ekenama ekio kia borio. ");
INSERT INTO guz_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Akabeeka ebinto ebio bionsi ase amaboko Aroni, na ay’abamura baye, akabisungusia bibe ekeng’wanso ki’ogosungusigwa ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Naende Musa akabirusia korwa ase amaboko abo, akabisaambera ase egesasiimero amo n’ekengwanso ki’ogosaambwa, bibe ekeng’wanso gi’okobaaatanana. Eke n’ekengwanso kegosaambwa n’omorero ase Omonene, kere ne rimisu rigiya rikomogwenera. ");
INSERT INTO guz_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Erio Musa akaimokia ritaana, akarisungusia ribe ekeng’wanso ki’ogosungusigwa ase Omonene. Nigo riabeete egetari kiaye kiarusetigwe korwa ase emingichi eria yaruetwe ase ogwaatanana abakuani. Ase igo Musa agakora buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa akaimokia amaguta akweakwa amo namanyinga areenge igoro ase egesasiimero, akanyororokeria Aroni amo ne chianga chiaye, akanyororokeria na abamura ba Aroni amo ne chianga chiabo. Naboigo agaatanana Aroni na abamura baye amo ne chianga chiabo ase emeremo emechenu. ");
INSERT INTO guz_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Erio Musa agateebia Aroni na abamura baye, “Iyekera enyama eyio agwo ase egesoero ki’Eema y’Omosangererekano, na moyeriere aroro, moyerie amo n’emegati eria ere ime ase egetonga gi’okoruegwa ase ogwatananwa kw’abakuani! Naboigo inche nachiigete, ngateeba: Aroni amo nabamura baye mbayerie. ");
INSERT INTO guz_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Korende enyama amo n’emegati biratigare mobisaambe n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Inwe timobaisa gosoka isiko goetania egesoero ki’Eema y’Omosangererekano, korende mobeereo ase engaki y’amatuko atano na abere, goika amatuko ’ogwaatananwa kwaino aere. ");
INSERT INTO guz_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Buna akorirwe ase rituko ria reero, naboigo Omonene achiikire akorwe kogenderera ase ogokora okobwatanigwa ase more, erinde mwaberwe. ");
INSERT INTO guz_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Inwe nigo moraabeere agwo ase egesoero ki’Eema y’Omosangererekano, omobaso na obotuko, ase amatuko atano na abere, mobe mogokora ay’Omonene achiikire. Motakoreti ayio, inwe nigo morakwe.” ");
INSERT INTO guz_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ase igo Aroni na abamura baye bagakora onsi ay’Omonene achiigete goetera ase Musa. ");
INSERT INTO guz_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ase rituko ria gatano na gatato Musa akarangeria Aroni amo nabamura baye, na abagaaka b’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Naende agateebia Aroni, “Chora eeri ensae na emori, chionsi ibere chitari na kemocho ase emebere yabo, ochirue ase Omonene. Eeri eria ebe ekeng’wanso ki’ebibe, na emingichi ebe eki’ogosaambwa. ");
INSERT INTO guz_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Naende oteebie Abaisraeli ng’a bachore egoree ebe ekeng’wanso ki’ebibe, na emori amo nemaanwa y’eng’ondi echiakoorire omwaka oyomo, chionsi chitari na kemocho ase emebere yabo, chibe ekeng’wanso ki’ogosaambwa, ");
INSERT INTO guz_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","na eng’ombe amo nemingichi chibe ebing’wanso bi’omorembe ase obosio bw’Omonene. Naboigo barue okoruegwa kw’endagera gwochoganirie namaguta, ekiagera ase rituko ria rero Omonene nabaorokere.” ");
INSERT INTO guz_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Abanto bakarenta ebinto ebio bionsi Musa abachiigete, bakabibeeka bosio bw’Eema y’Omosangererekano, na omoganda bwonsi ogaika ang’e, ogatenena agwo ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Erio Musa agateeba: “Eke naki’Omonene abachiigete mokore, erio obonene bw’Omonene mbobaorokere.” ");
INSERT INTO guz_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Erio Musa agateebia Aroni, “Suka gochia ang’e ase egesasiimero, na orue ekeng’wanso kiao ki’ebibe na eki’ogosaambwa, okore okobwatanigwa ase ore aye omonyene, na ase abanto, erinde mwaberwe. Naende orue ekeng’wanso ekio abanto barentire, na okore okobwatanigwa ase bare, buna Omonene achiigete.” ");
INSERT INTO guz_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ase ayio Aroni agasuka gochia ang’e ase egesasiimero, akanyenya emori eria ebe ekeng’wanso ki’ebibe biaye omonyene, ");
INSERT INTO guz_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","na abamura baye bakamorentera amanyinga y’ekeng’wanso ekio, ere agatobeka ekiara kiaye ase amanyinga aria, erio akayagindia ase emegwekano ye ching’unchara ere ase chikoona chi’egesasiimero, na amanyinga atigarete akayaumora ase egesasiimero inse. ");
INSERT INTO guz_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ebitinya ne chinyigo, n’ebitinya bie riini, ebiarusetie ase ekeng’wanso keria ki’ebibe, akabisaambera ase egesasiimero, buna Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Korende chinyama ne riiyo akabisamba n’omorero isiko y’egetwori. ");
INSERT INTO guz_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Magega y’ayio akanyenya eng’iti y’ekeng’wanso ki’ogosaambwa, na abamura baye bakamorentera amanyinga ’ekeng’wanso ekio, nere akayasiarera ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Abamura baye bakamorentera ekeng’wanso ki’ogosaambwa, egetari ase egetari, amo nomotwe, na ere akabisaambera ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Agasibia chinyama chi’enda amo nebirenge, erio akabisaambera amo n’ekengwanso ki’ogosaambwa ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Erio Aroni akarenta ekeng’wanso ki’ebibe bi’abaanto. Akaimokia embori y’ekeng’wanso ki’ebibe bi’abaanto, akayenyenya, akayerua buna aruete eria ye ritang’ani ase engencho y’ebibe biaye omonyene. ");
INSERT INTO guz_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Naende akarenta eng’iti y’ekeng’wanso ki’ogosaambwa, akayerua buna konya achikirwe. ");
INSERT INTO guz_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Akarenta okoruegwa kw’endagera, akaimokia obosie boichire roe, akabosaambera ase egesasiimero amo n’ekengwanso ki’ogosaambwa kia mambia. ");
INSERT INTO guz_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Akanyenya boigo eeri amo nemingichi, chikaba ebing’wanso bi’omorembe ase engencho y’abanto. Abamura baye bakamorentera amanyinga ’ebing’wanso ebio, nere akayasiarera ase egesasiimero chinsemo chionsi. ");
INSERT INTO guz_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ebitinya bi’eeri eyio, na omokera bw’emingichi n’ebitinya bitubete chinyama chi’enda, ne chinyigo, n’ebitinya bie riini, ");
INSERT INTO guz_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ebitinya ebio bionsi bakabibeeka igoro ase amataana, na Aroni akabisaambera ase egesasiimero, ");
INSERT INTO guz_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","korende amataana na ebinema bia borio akabisungusia bibe ekeng’wanso ki’ogosungusigwa ase Omonene, buna Musa achiigete. ");
INSERT INTO guz_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aroni gakoorire korua ekeng’wanso ki’ebibe, na eki’ogosaambwa, na eki’omorembe, akaimokia amaboko aye igoro ase abanto, akabasesenia, naende agaika gocha inse. ");
INSERT INTO guz_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Erio Musa na Aroni bagasoa ase Eema y’Omosangererekano ime, naende ekero basokire korwa aroro, bagasesenia abanto, na obonene bw’Omonene bokaorokera abanto bonsi. ");
INSERT INTO guz_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Omorero ogaika korwa ase Omonene mobosokano, ogasamba ekeng’wanso ki’ogosaambwa amo nebitinya biareenge ase egesasiimero, na ebinto ebio bikayia bikaera. Ekero abanto bonsi baroche amang’ana ayio bagaaka amariogi, bagatung’ama inse, bakaumama. ");
INSERT INTO guz_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabu na Abihu, abamura ba Aroni, kera oyomo akaimokia orogio rwaye, akabeeka omorero ase orogio orwo, na akabeeka ekoroso igoro ase omorero oyio, bakarentera Omonene omorero orenge bw’engencho eng’ao, oyi’Omonene atabachiigete. ");
INSERT INTO guz_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Na omorero ogaika korwa ase Omonene, okabasamba, barabwo bakayia, bagakwera agwo ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Erio Musa agateebia Aroni, “Aya nar’Omonene atebiire, ng’a ere neorokie koba omochenu ase abanto abwo bakomoika ang’e, na ase amaiso b’abaanto bonsi naorokie obonene bwaye.” Aroni agakira‐kiri. ");
INSERT INTO guz_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Erio Musa akarangeria Mishaeli na Elisafani, basinto ba Usieli, ise moke Aroni, akabateebia, “Inchuo mobogorie emebere y’abamino, abana ba iso moke, moyerusie korwa ase Obomenyo Obochenu, moyeire isiko y’egetwori.” ");
INSERT INTO guz_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Barabwo bagaacha, bakabogoria emebere eria eboyirie chiganchwa chiabo, bakayeira isiko y’egetwori, buna Musa abateebeetie. ");
INSERT INTO guz_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa agateebia Aroni amo n’Eleazari na Itamari, abamura ba Aroni, “Timobaisa gotiga chitukia chiaino chitachanuiri, gose timobaisa gotandora chianga chiaino ase okobaichanera. Moise gokora igo, goika mokwe, na endamwamu entindi y’Omonene echiche igoro y’omoganda bwonsi. Korende Abaisraeli bamino bonsi barabwo mbabe bakorera ase engencho y’ogosamba ogotindi Omonene arentire. ");
INSERT INTO guz_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Timobaisa gosoka isiko goetania egesoero ki’Eema y’Omosangererekano. Moise gokora igo, goika mokwe, ekiagera mwatananirwe ase ogoakwa amaguta ’Omonene.” Barabwo bagakora buna Musa abateebetie. ");
INSERT INTO guz_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Omonene agakwana na Aroni, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Aye amo nabamura bao timobaisa konywa edivai, gose ekenyugwa kegotindia, ekero mogosoa ase Eema y’Omosangererekano. Moise gokora igo, goika mokwe. Okwo nogochika koragenderere ase more ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Inwe goika momanye gwaatanana egento egechenu kere ekia Omonene korwa ase ekio getaatananiri koba egechenu, na egento gechenegete korwa ase egetachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Mworokererie Abaisraeli amachiiko onsi aya inche Omonene nabachiikire goetera ase Musa.” ");
INSERT INTO guz_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa agateebia Aroni na abamura baye abatigarete, Eleazari na Itamari, “Imokia okoruegwa kw’endagera, okwo gotigarete korwa ase okwo gwasambirwe n’omorero ase Omonene, mokorie gotabeekiri memera, agwo ase egesasiimero ensemo, ekiagera okoruegwa okwo nogochenu mono. ");
INSERT INTO guz_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mokoriere agwo Aase gete are aachenu. Ekio negetari kiao, na eki’abamura bao, gekorusigwa korwa ase okoruegwa kw’endagera kogosaambwa n’omorero ase Omonene. Ayio nar’Omonene anchiigete. ");
INSERT INTO guz_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Korende ritaana rigosungusigwa, na ekenama gekoruegwa, aye amo nabana bao, abamura na abaiseke, mwaeirwe ribaga kobiriera agwo aase achenire. Ebinto ebio aye na abana bao mwabieirwe korwa ase ebing’wanso bi’omorembe bikoruegwa n’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ekenama gekoruegwa, ne ritaana riria rigosungusigwa, birentwe amo nebitinya bikoruegwa ebing’wanso bigosaambwa n’omorero, bisungusigwe bibe ebing’wanso bi’ogosungusigwa ase obosio bw’Omonene. Ebio nabibe egetari kiao amo neki’abamura bao kogenderera botaambe, buna Omonene achiigete.” ");
INSERT INTO guz_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa agatuka mono komanya inaki embori y’ekeng’wanso ki’ebibe yabeete, akamanya ng’a embori eria nigo yasaambetwe. Ase ayio akaba nendamwamu enene ase Eliezeri na Itamari, abamura ba Aroni, baria batigarete, akabateebia. ");
INSERT INTO guz_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Nase ki motarierete ekeng’wanso keria ki’ebibe agwo aase are aachenu? Ekio negento egechenu mono mwaeirwe, erinde moruserie omoganda ebibe biabo, na gokora okobwatanigwa ase bare ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Rora, amanyinga aye tairetwe agwo Aase Aachenu; nigo yabagwenerete mokeriere agwo aase achenire.” ");
INSERT INTO guz_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aroni akairaneria Musa, “Rora, rituko ria reero abanto barure ekeng’wanso kiabo ki’ebibe, na eki’ogosaambwa, ase obosio bw’Omonene, korende nonya naboigo nomanyete emechando eye nanyorire. Onye inaria ekeng’wanso ki’ebibe rituko ria reero, Inee, nanga nancherwa ase obosio bw’Omonene?” ");
INSERT INTO guz_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ekero Musa aigwete amang’ana ayio agaisaneka. ");
INSERT INTO guz_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Kwana n’Abaisraeli, mobateebie: Ase ching’iti chire ase ense, echi nachio moraarie chinyama chiabo: ");
INSERT INTO guz_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Eng’iti ende yonsi ebwate ebitaago biatananegete kegima, naende ekoria eng’ang’ura, nero moraarie. ");
INSERT INTO guz_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Korende ase ching’iti chikoria eng’ang’ura gose chibwate ebitaago biatananegete timoria engamia, ekiagera nigo ekoria eng’ang’ura, korende tebwati ebitaago biatananegete; ase ayio techenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Timoria egesengi, ekiagera nigo gekoria eng’ang’ura, korende tikebwati ebitaago biatananegete; ase ayio tigechenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Timoria egesusu, ekiagera nigo gekoria eng’ang’ura, korende tikebwati ebitaago biatananegete; ase ayio tigechenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Naende timoria embeche, ekiagera nigo ebwate ebitaago biatananegete kegima, korende teri koria eng’ang’ura; eyio techenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Timoria chinyama chie ching’iti echio, gose timokuna emebere yabo ekwete, ekiagera echio tichichenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Monyare koria chinswe chire ase chinyancha ne chindooche ime, echibwate chingondo chinga buna chimbaaba, na amagoocho. ");
INSERT INTO guz_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Korende ebitongwa binde bionsi bire moyo ime ase chinyancha, gose ase chindooche, bigotaara bire amaicho bitabwati chingondo chinga buna chimbaaba, na amagoocho, timobiria; ebio nokogechia ase more. ");
INSERT INTO guz_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ebio nabigenderere koba okogechia ase more, chinyama chiabo timochiria, na echikwete ase echio timochiria, ekiagera echio nokogechia ase more. ");
INSERT INTO guz_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Kera egento kere ime ase chinyancha ne chindooche getabwati chingondo chinga buna chimbaaba, na amagoocho, ekio nokogechia ase more. ");
INSERT INTO guz_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Nase chinyoni chiraabe okogechia ase more motarie nachio echi: Ekeongo, na ensoti, na obotere; ");
INSERT INTO guz_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","amakoru na ebisaku biamwabo; ");
INSERT INTO guz_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ebigonkoru na ebisaku biamwabo bionsi; ");
INSERT INTO guz_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","esagero, na omoyaaye, na enyakoboke, na ebisaku biamwabo; ");
INSERT INTO guz_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","enyakweumia, na endubi, na ebaraara; ");
INSERT INTO guz_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","etibibi, na egetekere, na ensoti; ");
INSERT INTO guz_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","riagonga, na omoneke, na ebisaku biamwabo; enteema bobe na egetabora mato. ");
INSERT INTO guz_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ebitongwa ebisinini bionsi bire moyo bire ne chimbaaba na amagoro ane, ebio mbibe okogechia ase more. ");
INSERT INTO guz_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Korende ebitongwa ebio ebisinini bibwate chimbaaba na amagoro ane inamorie ebio bigotaroka nebirenge. ");
INSERT INTO guz_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ebisaku bionsi bie chingige, na ebi’amabururu, na ebisase, ebio nabio moraarie. ");
INSERT INTO guz_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Korende ebinde bionsi ase ebitongwa ebio ebisinini bibwate chimbaaba na amagoro ane, ebio mbibe okogechia ase more. ");
INSERT INTO guz_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ase ebitongwa ebio nigo moresoyie ase ogotacheneka. Monto onde bwensi orakune ebikwete ase ebio nabe oyotachenegeti goika omogoroba oyio, ");
INSERT INTO guz_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","na onde bwensi oraimokie egekwete korwa ase ebio nigo arasibie chianga chiaye, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Kera eng’iti ebwate ebitaago, korende tibiatananegeti kegima, naende teri koria eng’ang’ura, eyio nebe eyetachenegeti ase more. Moonto onde bwensi orakune ching’iti echio nabe oyotachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ching’iti chiria chikogendera ebisonsogoro ase echio chibwate amagoro ane tichichenegeti ase more. Monto onde bwensi orakune echikwete ase echio nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Na monto onde bwensi oraimokie eyekwete ase echio nasibie chianga chiaye, nere nabe oyotachenegeti goika omogoroba oyio. Ching’iti echio nachibe chitachenegeti ase more. ");
INSERT INTO guz_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ase ching’iti chinke chigoetanana ase ense, echio nchibe chitachenegeti ase more; Ekenyamunyonge, na embeba, na ekiigo ekenene, amo nebisaku biamwabo; ");
INSERT INTO guz_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ekiigo egeke, na eng’oina, na ensagara, enke na enene, amo n’enyambu. ");
INSERT INTO guz_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ase ching’iti echio chinke echio nchibe chitachenegeti ase more. Monto onde bwensi orachikune ekero chi akuure nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ching’iti echio chiise kogwera egento kende gionsi ekero chi akuure, egento ekio nakebe egetachenegeti, onye negento keroisirie korwa ase emete, gose gokeraabe eanga, gose risankwa, gose esaro, gose egento kende gionsi kegokorerwa emeremo. Egento ekio kebekwe ime ase amaache, naende kebe getachenegeti goika omogoroba oyio; erio nakebe giachenekire. ");
INSERT INTO guz_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Onye eyemo ye ching’iti echio ekogwera enyongo, gose gento kende keroisirie korwa ase amaroba, ekere ime yaye nakebe egetachenegeti, na egento ekio goika giatwe. ");
INSERT INTO guz_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Endagera ende yonsi ekoriegwa nebe eyetachenegeti onye amaache akoumorwa korwa ase enyongo buna eyio akoyekuna, na ekenyugwa kende gionsi kere ime y’enyongo buna eyio nkebe getachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Gento kende gionsi keragwerwe neyemo ye ching’iti echio ekwete inakebe getachenegeti; onye ne riko rikoroisia emegati, gose neri’ endagera, erio riatwe, riabeire eritachenegeti ase more. ");
INSERT INTO guz_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ensoko gose aase amaache akogachwa nabigenderere koba ebichenegete, korende ebinto binde bionsi ebiaao biise gokuna ching’iti echio chikwete mbibe ebitachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Onye eng’iti eyemo y’echio ekwete keragwere embusuro egosimekwa, embusuro eyio negenderere koba echenegete. ");
INSERT INTO guz_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Korende onye embusuro eyio yainekirwe ase amaache ime, na egwerwe neyemo ye ching’iti echio ekwete, rirorio nebe etachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Eng’iti ende yonsi yancheire koriegwa kerakwe, na omonto orayekune, rirorio omonto oyio nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Moonto onde bwensi oraarie enyama y’eng’iti eyio ekwete nasibie chianga chiaye, naende nabe oyotachenegeti goika omogoroba oyio, na onde bwensi oraimokie eng’iti eyio ekwete, nasibie chianga chiaye, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Ebitongwa ebike bionsi bigoetanana ase ense nigo bire okogechia, tibiriegwa. ");
INSERT INTO guz_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Egetongwa kende gionsi egeke kegwekururera enda, gose gekogendera amagoro ane, gose amange, ase ebio bigoetanana ase ense, nigo bire okogechia, timobaisa kobiria. ");
INSERT INTO guz_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Timobaisa gwekora okogechia ase engencho y’ebitongwa ebio bigoetanana, gose gwesoyia ase ogotacheneka ase engencho ya birobio. Moise gokora igo, namobe abatachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Inche ninche Omonene, Nyasae oino; ase ayio mweatanane inwe abanyene, mobe abachenu, ekiagera inche nomochenu inde. Timobaisa gwesoyia ase ogotacheneka ase engencho y’egetongwa kende gionsi egeke ase ebio bigoetanana ase ense. ");
INSERT INTO guz_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Inche ninche Omonene, nabarusetie korwa ase ense ya Misiri imbe Nyasae oino. Ase ayio, mobe abachenu, ekiagera inche nomochenu inde.” ");
INSERT INTO guz_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Oko nakwo ogochika gotenenerete ching’iti ne chinyoni, na kera egetongwa kere moyo kegoetanana ase amaache ime, na ebitongwa ebisinini bigoetanana ase ense, ");
INSERT INTO guz_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","na igo momanye gwaatanana ebichenegete korwa ase ebitachenegeti, ne ching’iti chire moyo chiancheire koriegwa korwa ase echitancheiri koriegwa. ");
INSERT INTO guz_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“oteebie Abaisraeli ng’a omokungu karabe morito na aibore omwana omoisia nabe oyotachenegeti ase engaki y’amatuko atano na abere, amatuko ang’ana buna ekero abwate omotienyi abe oyotachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Omwana oria omoisia arokigwe ase rituko ria gatano na gatato. ");
INSERT INTO guz_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Erio omokungu oria aganye ase engaki y’amatuko emerongo etato na atato, goika amanyinga akame, na ere omonyene nabe oyochenegete. Tabaisa gokuna gento kende gionsi gechenegete, gose gosoa Aase Aachenu, goika amatuko aye ay’ogochenwa aere. ");
INSERT INTO guz_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Korende karaibore omwana egesagane, nabe oyotachenegeti ase chichuma ibere, buna ekero abwate omotienyi, naende aganye ase engaki y’amatuko emerongo etano nomo, na atano na rimo, goika amanyinga aye akame, na ere omonyene nabe oyochenegete. ");
INSERT INTO guz_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Ekero amatuko ’omokuungu oyio ay’ogochenwa aerire, karabe nomwana omoisia aiboire, gose egesagane, omokungu oyio arente eng’ondi yakoorire omwaka oyomo ebe ekeng’wanso ki’ogosaambwa, ne riige rie riruma, gose riruma, ribe ekeng’wanso ki’ebibe. Abirente ase Omokuani agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Omokuani oria arue eng’ondi eyio, gose riruma erio ase obosio bw’Omonene, na akore okobwatanigwa ase omokungu oyio, na igo nabe ochenekire korwa ase ogoiteka kw’amanyinga aye. Oko nakwo ogochika ase omokungu oiborete omwana, omoisia gose egesagane. ");
INSERT INTO guz_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Onye omokungu oria takonyara konyora eng’ondi, rirorio arente amaruma abere, gose amage ’amaruma abere, erimo ribe ekeng’wanso ki’ogosaambwa, na erinde eki’ebibe. Ase enchera eyio Omokuani akore okobwatanigwa ase omokungu oyio, na omokungu oyio nabe ochenekire.” ");
INSERT INTO guz_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Omonene agakwana na Musa na Aroni, akabateebia: ");
INSERT INTO guz_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ekero omonto abeire negesambo, gose abimbire risankwa ri’omobere oye, gose risankwa riatorekire na koonchoka ribe buna oborwaire bwa ukoma, omonto oyio arentwe ase Aroni Omokuani, gose ase oyomo bw’abamura baye ore Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Omokuani oyio areenge oborwaire obwo buya. Kararore ng’a amarionya are ase egesambo keria aonchokire abeire amarabu, na oborwaire bwakorire engoro gochia ime goetania risankwa, rirorio oborwaire obwo nobwa ukoma. Ekero Omokuani arengire omonto oria buya, ateebe ng’a oyio onyorekanire ng’a tachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Onye egesambo keria kere ekerabu, korende tigekoreti engoro gochia ime goetania risankwa, na amarionya egesambo keria tabeti amarabu, rirorio Omokuani abeeke omonto oria ase egesomo ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ase rituko ria gatano na kabere Omokuani amorenge naende, na kararore ng’a oborwaire boria tibwesiarereti ase risankwa, erio amobeeke naende ase egesomo ase engaki y’amatuko ande atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ase rituko ria gatano na kabere amorenge naende, na kararore ng’a egesambo keria giachakire gosira, na oborwaire boria tibwesiarereti ase risankwa erio Omokuani ateebe ng’a omonto oria ochenekire, namaote oka abwate. Omonto oria asibie chianga chiaye, erio abe oyochenegete kegima. ");
INSERT INTO guz_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Korende egesambo keria gokeraabe giesiareire ase risankwa magega Omokuani karorire ng’a ochenekire, omonto oria goika airane ase Omokuani naende, ");
INSERT INTO guz_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","na ere kararore ng’a egesambo keria giesiareire ase risankwa, erio ateebe ng’a omonto oyio tachenegeti. Obwo noborwaire bwa ukoma. ");
INSERT INTO guz_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Ekero omonto abwate oborwaire bwa ukoma araarentwe ase Omokuani, ");
INSERT INTO guz_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","na ere amorenge buya. Kararore egesambo ekerabu ase risankwa, na amarionya aonchokire abeire amarabu, naende onye enyama embariri yachakire gokina imeo, ");
INSERT INTO guz_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","obwo noborwaire bwa ukoma obokoro bogendererete ase engaki entambe ase risankwa ri’omobere bw’omonto oria. Omokuani ateebe ng’a omonto oyio tachenegeti; bono tamobeeka ase egesomo, ekiagera tachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Onye oborwaire obwo bwa ukoma bwasokire ase risankwa isiko, na Omokuani ororire ng’a bwesiareire ase omobere bwonsi korwa omotwe goika amagoro, ");
INSERT INTO guz_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","erio Omokuani amorenge naende, na kararore ng’a oborwaire boria bwatubire omobere bwonsi bw’omonto oria, rirorio ateebe ng’a ochenekire. Onye omobere bwonsi obeire omorabu, omonto oria obeire oyochenegete. ");
INSERT INTO guz_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Korende onye enyama embariri yachakire gokina imeo, omonto oyio tachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ekero Omokuani ararore ng’a enyama eria embariri yasokire, rirorio ateebe ng’a omonto oyio tachenegeti. Enyama eria embariri nigo ere eyetachenegeti. Obwo noborwaire bwa ukoma. ");
INSERT INTO guz_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Korende onye enyama eria embariri ekoonchoka ebe endabu, erio omonto oyio agende ase Omokuani, ");
INSERT INTO guz_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","na ere amorenge buya, na onye egesambo kiaonchokire na koraba, erio Omokuani ateebe ng’a omonto oyio ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Omonto onye orenge ne rigumba ase risankwa riaye, ne rigumba erio koriagwenire, ");
INSERT INTO guz_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","na aase agwo, ase risankwa riareenge obobimbu oborabu bororekane, gose egesambo gekororekana kere nobobariri na oborabu, omonto oria goika agende ase Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ere amorenge buya, na kararore ng’a egesambo keria giakorire engoro gochia ime goetania risankwa, na amarionya areo aonchokire na koraba, Omokuani ateebe ng’a omonto oria tachenegeti. Obwo noborwaire bwa ukoma bwaorokeire ase rigumba riria. ");
INSERT INTO guz_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Korende Omokuani karamorenge na arore ng’a amarionya ’egesambo keria tari amarabu, na tigekoreti engoro gochia ime goetania risankwa, naende giachakire gosira, Omokuani abeeke omonto oria ase egesomo ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Onye oborwaire obwo bwesiareire ase risankwa, erio Omokuani ateebe ng’a omonto oyio tachenegeti, risankwa rianyorire oborwaire. ");
INSERT INTO guz_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Korende onye egesambo keria tikeonchogeti na gwesiarera, eyio engoro ase rigumba riariete, na Omokuani ateebe ng’a omonto oria ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Onye omonto ore ne risambo ri’omorero ayiete ase risankwa ri’omobere oye, na enyama embariri ekineteo ebe egesambo ki’obobariri na oborabu, gose kebe ekerabu, ");
INSERT INTO guz_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Omokuani areenge egesambo ekio. Onye amarionya egesambo ekio aonchokire na koraba, naende egesambo kiabeire engoro gochia ime goetania risankwa ri’omobere oye, obwo noborwaire bwa ukoma bwasokire ase risambo ri’omorero riareenge. Omokuani ateebe ng’a omonto oyio tachenegeti. Obwo noborwaire bwa ukoma. ");
INSERT INTO guz_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Korende Omokuani karaarenge egesambo keria, na arore ng’a amarionya aria areo taonchogeti abe amarabu, naende egesambo tikerakora engoro gochia ime goetania risankwa, korende giachakire gosira, erio Omokuani amobeeke ase egesomo ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Rituko ria gatano na kabere Omokuani amorenge naende. Kararore ng’a egesambo keria giesiareire ase risankwa, erio ateebe ng’a omonto oyio tachenegeti. Obwo noborwaire bwa ukoma. ");
INSERT INTO guz_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Korende onye egesambo keria tikeonchogeti gose giesiarere ase risankwa, korende giachakire gosira, okwo nokobimba kwe risambo, na Omokuani ateebe ng’a omonto oyio ochenekire. Eyio engoro ye risankwa ri’omobere. ");
INSERT INTO guz_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Onye omonto, omosacha gose omokungu, obwate egesambo ase omotwe oye, gose ase ekenyonyobu, ");
INSERT INTO guz_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Omokuani areenge egesambo ekio. Onye gekorete engoro gochia ime goetania risankwa, naende onye amarionya areo are monuri na konyererea, erio Omokuani ateebe ng’a omonto oyio tachenegeti. Erio nerichoncho ri’oborwaire bwa ukoma ase omotwe oye, gose ase ekenyonyobu. ");
INSERT INTO guz_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Omokuani karaarenge richoncho riria na arore ng’a tirikoreti engoro gochia ime goetania risankwa, naende amarionya amamwamu tari aroro, erio Omokuani amobeeke ase egesomo ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ase rituko ria gatano na kabere Omokuani areenge naende oborwaire boria, na onye tibwesiarereti, naende amarionya amonuri tario, naende richoncho tirikoreti engoro gochia ime goetania risankwa, ");
INSERT INTO guz_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","omonto oyio akigite etukia, korende takigita ase richoncho rire, na Omokuani amwatanane, amobeeke ase egesomo ase engaki y’amatuko ande atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ase rituko ria gatano na kabere Omokuani amorenge naende, na onye richoncho riria tiriesiarereti ase risankwa, na tirikoreti engoro gochia ime goetania risankwa, Omokuani ateebe ng’a omonto oyio ochenekire, ase igo asibie chianga chiaye, abe oyochenegete kegima. ");
INSERT INTO guz_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Korende onye richoncho riria riesiareire ase risankwa magega gachenekire, ");
INSERT INTO guz_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Omokuani amorenge naende, na kararore ng’a richoncho riria riesiareire, takorigia korora gose amarionya are monuri nareo, omonto oyio tachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Omokuani kararore ng’a richoncho riria tirionchogeti, na amarionya amamwamu amerire imeo, richoncho riria riagwenire, na omonto oria ochenekire kegima. Omokuani ateebe ng’a omonto oyio ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Onye omosacha gose omokungu obwate ebisambo ebirabu ase risankwa ri’omobere, ");
INSERT INTO guz_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Omokuani amorenge. Nere kararore ng’a ebisambo bie risankwa ri’omobere nigo bire ebirabu ake, ebisambo ebio tibiri bobe; omonto oyio ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Onye omonto osunyokire etukia, risio riachiire magega, nigo are nyaisio, ere ochenekire, ");
INSERT INTO guz_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","na onye osunyokire etukia y’omotwe bosio, boigo ere ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Korende onye ase risio ri’omotwe oye, magega gose bosio, obwate egesambo kere nobobariri na oborabu, obwo noborwaire bwa ukoma bwasokeire ase risio. ");
INSERT INTO guz_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ase ayio, Omokuani karamorenge arore ng’a egesambo kebimbete ase risio riria, magega gose bosio, kere nobobariri na oborabu, na nigo gekororekana buna oborwaire bwa ukoma mbore ase risankwa ri’omobere, ");
INSERT INTO guz_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","omonto oyio nabwate oborwaire bwa ukoma, ere tachenegeti. Omokuani ateebe ng’a omonto oyio tachenegeti; oborwaire nigo bore ase omotwe oye. ");
INSERT INTO guz_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Omonto obwate oborwaire bwa ukoma abeeke chianga amachanchabe, tabaisa gochanua etukia yaye, atube omonwa oye ase egekoba kia igoro, erio aake eriogi na gokuura: Inche tinchenegeti! Tinchenegeti! ");
INSERT INTO guz_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ere agenderere koba oyotachenegeti ekero are noborwaire boria, aatananwe amenye isiko y’egetwori, ao korwa ase abanto bande. ");
INSERT INTO guz_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Onye ukoma bore ase eanga eroisirie korwa ase amarionya gose egatani, ");
INSERT INTO guz_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","gose bore ase egetambaa keroisirie ase chingencho ao ao korwa ase egatani, gose ase amarionya, gose ase rirondia rie risankwa, gose ase egento kende gionsi keroisirie korwa ase risankwa, ");
INSERT INTO guz_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","na onye ekemoa gekororekana kere nekieni buna obonyansi, gose ekebariri, ase eanga, gose ase risankwa, gose ase egetambaa keria, gose ase egento kende keroisirie korwa ase risankwa, obwo noukoma bogwesiarera, na ebinto ebi biorokigwe ase Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Omokuani areenge egento kere na ukoma, erio akebeke ase egesomo ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ase rituko ria gatano na kabere Omokuani akerenge naende. Kararore ng’a ogosareka koria gwesiareire ase eanga, gose ase egetambaa keroisirie ase chingencho ao ao, gose ase risankwa, gose ase egento kende gionsi keroisirie korwa ase risankwa, nigo kiabwatetwe na ukoma obobe mono; egento ekio tigechenegeti. ");
INSERT INTO guz_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ase igo egento ekio gesambwe n’omorero, gokeraabe eanga, gose egetambaa kende gionsi, keroisirie korwa ase amarionya, gose korwa ase egatani, gose gento kende gionsi keroisirie korwa ase risankwa kere noborwaire obwo ime yaye. Obwo noborwaire obobe bwa ukoma; ebinto ebio goika bisambwe n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Omokuani karaarenge na arore ng’a ekemoa keria tigieseraarereti ase eanga eria, gose ase egetambaa keria, gose ase kende gionsi keroisirie korwa ase risankwa, ");
INSERT INTO guz_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","rirorio achike ng’a egento ekio giasarekire, tiga gesibigwe na kebekwe ase egesomo ase engaki y’amatuko ande atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Omokuani areenge ekemoa ase egento keria magega kogiasibigwe. Kararore ng’a ekemoa keria tikeraonchoka, egento keria tigechenegeti, nonya ekemoa ekio tigiesiarereti. Egento keria gesambwe n’omorero, ekiagera ekemoa keria negi’okoboosia, onye kere isiko gose ime ase egento ekio. ");
INSERT INTO guz_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Korende onye Omokuani okorenga egento ekio magega kogiasibigwe, na arore ng’a ekemoa keria ngosira kere, rirorio ataandore aase ekemoa keria kere, akerusie korwa ase eanga eria, gose risankwa, gose egetambaa. ");
INSERT INTO guz_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Onye ekemoa gekororekana naende ase eanga eria, gose ase egetambaa keroisirie ase chingencho ao ao, gose ase gento kende gionsi keroisirie korwa ase risankwa, igo nekemoa gia ukoma kiaorokeire. Egento keria goika gesambwe n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ekemoa gokeranyorekane ng’a giasirire ekero eanga, gose egetambaa keria, gose gento kende gionsi keroisirie korwa ase risankwa, giasibigwe, rirorio gesibigwe eria kabere. Bono egento keria nakebe giachenekire.” ");
INSERT INTO guz_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Oko nakwo ogochika igoro ase ebinto bire na ukoma, kobiraabe chianga chiroisirie korwa ase amarionya gose egatani, gose gokeraabe egetambaa keroisirie ase chingencho ao ao, gose gento kende gionsi keroisirie korwa ase risankwa. Ase ogochika okwo egento ekio inagiatorwe ng’a giachenekire, gose tigechenegeti. ");
INSERT INTO guz_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Oko nakwo ogochika ase omonto obwate oborwaire bwa ukoma. Ase rituko riria arabe agochenwa arentwe ase Omokuani, ");
INSERT INTO guz_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","na Omokuani agende isiko y’egetwori amorenge. Kararore ng’a omonto oria ogwenire korwa ase oborwaire bwa ukoma bwamoriete, ");
INSERT INTO guz_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Omokuani achike abanto barente chinyoni ibere chichenegete chire moyo, na oroko rw’omocharake, na eusi embariri, na orosagia rwa hisopo, ase engencho y’omonto oria ogochia gochenwa. ");
INSERT INTO guz_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Erio Omokuani achike abanto banyeenyete enyoni eyemo igoro ase egetega ki’amaroba kere namaache amaya a rooche. ");
INSERT INTO guz_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Naende aimokie enyoni eria ere moyo amo noroko rw’omocharake, na eusi eyio embariri, na orosagia orwo rwa hisopo, abitobeke ime ase amanyinga ’enyoni eria yanyeenyetetwe igoro y’amaache aria amaya a rooche. ");
INSERT INTO guz_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Anyororokerie amanyinga aria ara gatano na kabere igoro ase omonto oyio ogochia gochenwa ase oborwaire bwa ukoma, ateebe ng’a omonto oria ochenekire, na atige enyoni eria ere moyo eiruruke, egende orosana. ");
INSERT INTO guz_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Omonto oria ogochia gochenwa goika asibie chianga chiaye, na akigite etukia yaye yonsi, naende esibie omobere namaache, erio abe oyochenegete. Magega y’ayio asoe ase egetwori, korende abeere isiko y’eema yaye ase engaki y’amatuko atano na abere, ");
INSERT INTO guz_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ase rituko ria gatano na kabere naende akigite etukia yaye yonsi y’omotwe, ne chinderu, na ebioge bi’amaiso, na amarionya ande onsi are ase omobere oye. Erio asibie chianga chiaye, esibie nomobere namaache, na igo nabe ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Ase rituko ria gatano na gatato arente chimanwa ibere chimingichi chitari na kemocho ase emebere yabo, na emaanwa esigiti yakoorire omwaka oyomo, etari na kemocho ase omobere oye, amo nobosie obonuke, ebimunu bitano na ekemo, bwochoganirie namaguta, ebe okoruegwa kw’endagera. Amo nayio arente amaguta egetuba ekemo. ");
INSERT INTO guz_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Omokuani otenenerete arente omonto oria ogochia gochenwa amo nokoruegwa okwo ase obosio bwane inche Omonene, agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Erio Omokuani oria aimokie emaanwa eyemo, ayerue ebe ekeng’wanso gi’okomocha, ayerue amo namaguta egetuba ekemo, erio abisungusie agwo ase obosio bwane bibe ekeng’wanso ki’ogosungusigwa. ");
INSERT INTO guz_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Anyeenyere emaanwa eria agwo aase achenire, ase ekeng’wanso ki’ebibe na eki’ogosaambwa bikonyeenyerwa, ekiagera ekeng’wanso gi’okomocha neki’Omokuani; ekio negechenu mono. ");
INSERT INTO guz_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Omokuani aimokie amanyinga make ay’ekeng’wanso gi’okomocha, na agindie mesia y’ogoto kwa borio kw’omonto oria ogochia gochenwa, naende agindie ekiara ekenene gi’okoboko kwaye kwa borio, na ekiara ekenene gi’okogoro kwaye kwa borio. ");
INSERT INTO guz_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Naende Omokuani aimokie amaguta aria ataaere oroe rw’okoboko kwaye gw’okobee, ");
INSERT INTO guz_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","atobeke ekiara kiaye gi’okoraga gi’okoboko kwaye kwa borio ime ase amaguta aria are roe rw’okoboko kwaye gw’okobee, erio ayanyororokerie ara gatano na kabere, agwo ase obosio bwane inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Amaguta make ase ayio agotigara ase oroe rwaye ayagindie mesia y’ogoto kwa borio kw’omonto oria ogochia gochenwa, na ekiara ekenene gi’okoboko kwaye kwa borio, na ekiara ekenene gi’okogoro kwaye kwa borio, igoro ase amanyinga ’ekeng’wanso gi’okomocha agindirieo. ");
INSERT INTO guz_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Naende maguta ayagotigara ase oroe rwaye ayaumore igoro ase omotwe bw’omonto oria ogochia gochenwa. Ase enchera eyio Omokuani akore okobwatanigwa ase omonto oria agwo ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Erio Omokuani arue ekeng’wanso ki’ebibe, akore okobwatanigwa ase omonto oria ogochia gochenwa, acheneke korwa ase ogotacheneka kwaye. Magega y’ayio anyenye ekeng’wanso ki’ogosaambwa, ");
INSERT INTO guz_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","akerue amo nokoruegwa kw’endagera ase egesasiimero. Ase enchera eyio Omokuani akore okobwatanigwa ase omonto oria, na omonto oria abe oyochenegete. ");
INSERT INTO guz_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Korende onye omonto oria ore omotaka na takonyara konyora ebinge akorua, rirorio arente emaanwa emingichi ebe ekeng’wanso gi’okomocha kegosungusigwa ase okobwatanigwa kwaye. Boigo arente obosie ebimunu bibere bwochoganirie namaguta, bobe okoruegwa kw’endagera, na amaguta egetuba ekemo. ");
INSERT INTO guz_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Boigo arente amaruma abere, gose amage ’amaruma abere, buna aranyare. Erimo ribe ekeng’wanso ki’ebibe, na erinde eki’ogosaambwa. ");
INSERT INTO guz_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ase rituko ria gatano na gatato arente ebinto ebio bi’ogochenwa kwaye ase Omokuani, agwo ase egesoero ki’Eema y’Omosangererekano, ase obosio bwane inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Omokuani aimokie emaanwa y’eng’ondi eria y’ekeng’wanso gi’okomocha, amo namaguta aria egetuba ekemo, abinduere inche Omonene bibe ekeng’wanso ki’ogosungusigwa. ");
INSERT INTO guz_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Erio anyenye emaanwa eria ebe ekeng’wanso gi’okomocha, na Omokuani aimokie amanyinga make ay’ekeng’wanso ekio, ayagindie mesia y’ogoto kwa borio kw’omonto oria ogochia gochenwa, na ekiara ekenene gi’okoboko kwaye kwa borio, na ekiara ekenene gi’okogoro kwaye kwa borio. ");
INSERT INTO guz_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Omokuani ataaere amaguta ase oroe rw’okoboko kwaye gw’okobee. ");
INSERT INTO guz_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Make ay’amaguta aria are roe rw’okoboko kwaye gw’okobee ayanyororokerie ara gatano na kabere nekiara gi’okoraga gi’okoboko kwaye kwa borio, agwo ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Naende make ay’amaguta ayio are roe rwaye agindie igoro ase amanyinga ’ekeng’wanso gi’okomocha agindire: Mesia y’ogoto kwa borio kw’omonto oria ogochia gochenwa, na ekiara ekenene gi’okoboko kwaye kwa borio, na ekiara ekenene gi’okogoro kwaye kwa borio. ");
INSERT INTO guz_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Amaguta agotigara ase oroe rwaye ayaumore ase omotwe bw’omonto oria ogochia gochenwa. Ase enchera eyio akore okobwatanigwa asare, agwo ase obosio bwane. ");
INSERT INTO guz_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Erio omonto oria arue riruma gose riige rie riruma, koreng’ana buna aranyare koyanyora. ");
INSERT INTO guz_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Erimo ribe ekeng’wanso ki’ebibe, na erinde eki’ogosaambwa, ayarue amo nokoruegwa kw’endagera. Ase enchera eyio Omokuani akore okobwatanigwa ase obosio bwane ase omonto oria ogochia gochenwa.” ");
INSERT INTO guz_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Oko nakwo ogochika ase omonto obwate oborwaire bwa ukoma, oria otanyare korua ebing’wanso bi’ogochenwa bia botaambe bichikiire. ");
INSERT INTO guz_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Eri’Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ekero moraike ase ense ya Kaanani, eyio ndabae ebe eyaino, na kondarente ukoma ase enyomba gete agwo, ");
INSERT INTO guz_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","omonto omonyene enyomba eria agende ateebie Omokuani: Yarorekanire ase enyomba yane ng’a ukoma mboreo. ");
INSERT INTO guz_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Omokuani achike ng’a ebinto bionsi bire ase enyomba eyio birusigweo ritang’ani atarasoao koborenga. Onye tibagokora bo rirorio ebinto bionsi bire nyomba ime nabibe bitachenegeti. Magega y’ayio Omokuani asoe ase enyomba eyio koyerenga. ");
INSERT INTO guz_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Karayerenge na arore ng’a egetamase nkere ase enyasi y’enyomba eyio kere nekieni buna obonyansi, gose ekebariri, naende giakorire engoro gochia ime goetania rioomo, ");
INSERT INTO guz_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","erio Omokuani asoke korwa ase enyomba eyio, na ayesieke ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ase rituko ria gatano na kabere Omokuani airaneo, ayerenge naende. Kararore ng’a ukoma boria bwesiareire ase enyasi y’enyomba eria, ");
INSERT INTO guz_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","achike ng’a amagena aria asoirwe na ukoma atagorwe, atugutwe ase eubi egotugutwa, isiko y’omochie. ");
INSERT INTO guz_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Magega y’ayio chinyasi chionsi chia ime chiomorwe, erio amaoomo atugutwe aase are neubi isiko y’omochie. ");
INSERT INTO guz_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Amagena ande arentwe, abekwe ribaga ri’aria atagorwa na gotugutwa, ne chinyasi, chioomwe nesike enyia. ");
INSERT INTO guz_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ukoma boria koboratuboke naende ase enyomba eria magega amagena aria karusigweo, ne rioomo riria koriaoomoirwe, na enyomba eria yaoomirwe naende, ");
INSERT INTO guz_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Omokuani agende ayerenge naende. Onye egetamase keria giesiareire ase enyomba eria, obwo noukoma, yabeire eyetachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Enyomba eria etagorwe, na amagena onsi amo nemete ne rioomo riaye rionsi biimokigwe, bionsi biirwe ase eubi egotugutwa isiko y’omochie. ");
INSERT INTO guz_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Monto onde bwensi orasoe ase enyomba eyio, ekero egendererete gosiekwa, nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Monto onde bwensi aise koraara ime ase enyomba eyio, gose koragerera aroro, goika asibie chianga chiaye. ");
INSERT INTO guz_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Korende Omokuani karachiche ayerenge arore ng’a ukoma boria tibwesiarereti magega koyaoomirwe, rirorio ukoma bwaerire, na ere ateebe ng’a enyomba eria yachenekire. ");
INSERT INTO guz_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Omokuani arente chinyoni ibere amo noroko rw’omocharake, na eusi embariri, na orosagia rwa hisopo, ase ogochenwa kw’enyomba eria. ");
INSERT INTO guz_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Erio anyeenyete enyoni eyemo igoro ase egetega keroiseirie amaroba kere namaache amaya a rooche. ");
INSERT INTO guz_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Naende aimokie oroko orwo rw’omocharake, na orosagia rwa hisopo, na eusi eria embariri amo nenyoni eria ere moyo, abitobeke bionsi ime ase amanyinga ’enyoni eria yanyenyetwe, na amaache aria amaya a rooche; erio anyororokerie enyomba eria ara gatano na kabere. ");
INSERT INTO guz_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ase enchera eyio Omokuani nachene enyomba eyio namanyinga ’enyoni eria, amo namaache aria amaya a rooche, na enyoni eria ere moyo, na oroko rw’omocharake, na orosagia rwa hisopo, na eusi eria embariri. ");
INSERT INTO guz_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Erio Omokuani atige enyoni eria ere moyo eiruruke, egende orosana isiko y’omochie. Ase enchera eyio akore okobwatanigwa ase enyomba eria, na ero ebe yachenekire.” ");
INSERT INTO guz_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Oko nakwo ogochika igoro y’oborwaire bwa ukoma, ne richoncho, ");
INSERT INTO guz_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","na ukoma bore ase chianga, gose ase chinyomba, ");
INSERT INTO guz_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","naende obobimbu bwe risankwa, na ebisambo, na ebimoa ebirabu. ");
INSERT INTO guz_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ogochika okwo nigo gokworokia onye ebinto tibichenegeti gose mbichenegete. Okwo nogochika gwa ukoma. ");
INSERT INTO guz_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Kwana n’Abaisraeli, mobateebie ng’a onye omonto omosacha okorua amaache anga buna chimengere korwa ase ekiimo kiaye ki’obosacha, amaache ayio neubi. ");
INSERT INTO guz_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Aya naro achiikire ase amang’ana ayio: Amaache ayio karagenderere korua, gose atigire korua, omonto oyio tachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ebirarero bionsi araararere, gose araikaransere, nigo biraabe ebitachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Monto onde bwensi aise gokuna ebiraarero bi’omonto oyio goika asibie chianga chiaye, esibie nomobere namaache, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Na onde bwensi oraikaransere egento omonto oria omorwaire aikaranserete, goika asibie chianga chiaye, esibie nomobere namaache, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Na onde bwensi orakune omonto oyio omorwaire goika asibie chianga chiaye, esibie nomobere namaache, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Omonto oyio omorwaire karatwere omonto ochenegete amate, nere goika asibie chianga chiaye, esibie nomobere namaache, naende abe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Egeikaransero gekobekerwa eng’iti ekoriinwa, gokeraikaranserwe nomonto oria omorwaire, nakebe egetachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Omonto aise gokuna egento kende gionsi kiareenge inse y’omonto oria omorwaire nabe oyotachenegeti goika omogoroba oyio; na onde bwensi oraimokie egento buna ekio nigo arasibie chianga chiaye, esibie nomobere namaache, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Onye omonto oria omorwaire ogokuna omonto onde ataraisaba amaboko, oria okunwa goika asibie chianga chiaye, esibie nomobere namaache naende nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Enyongo ende yonsi omonto oria omorwaire arakune goika yaatwe, na egekorero kende gionsi keroiseirie omote arakune goika gesibigwe namaache. ");
INSERT INTO guz_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Omonto oria gachenekire korwa ase okorua kw’amaache aria anga buna achimengere goika abare amatuko atano na abere ay’ogocheneka kwaye. Erio asibie chianga chiaye, esibie nomobere namaache amaya a rooche, ere nabe oyochenegete. ");
INSERT INTO guz_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ase rituko ria gatano na gatato aire amaruma abere, gose amage ’amaruma abere, ase obosio bwane inche Omonene agwo ase egesoero ki’Eema y’Omosangererekano, ayae Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Omokuani arue erimo ribe ekeng’wanso ki’ebibe, na erinde ribe ekeng’wanso ki’ogosaambwa. Ase enchera eyio akore okobwatanigwa ase omonto oria ase obosio bwane, ase engencho y’okorua kwaye kw’amaache anga buna chimengere. ");
INSERT INTO guz_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Onye omonto omosacha ogosokia embusuro yaye y’oroiboro, rirorio esibie omobere namaache, na agenderere koba oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Eanga ende yonsi, na ebinto binde bionsi bi’amasankwa, embusuro eyio y’oroiboro eratonyere, goika bisibigwe namaache, nabirobio nabibe ebitachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Omonto onye orarire n’omokuungu, na omobekeire embusuro y’oroiboro, bonsi babere goika besibie emebere yabo namaache, nabarabwo nababe abatachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Ekero omokungu are nomotienyi nigo arabe oyotachenegeti ase engaki y’amatuko atano na abere. Onde bwensi oramokune nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Gento kende gionsi arabe okoraarera ekero are nomotienyi, nigo keraabe egetachenegeti, boigo n’ebinto bionsi araikaransere. ");
INSERT INTO guz_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Onde bwensi orakune ebiraarero bi’omokuungu oyio goika asibie chianga chiaye, esibie nomobere namaache, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Na onde bwensi orakune egento omokungu oyio aikaranserete, nigo arasibie chianga chiaye, esibie nomobere namaache; ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ase igo kobiraabe ebiraarero, gose egento omokungu oria aikaranserete, omonto karabikune nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Omosacha karaarare n’omokuungu ore nomotienyi, ogotacheneka kw’omokuungu oyio nakobe asare, ere nabe oyotachenegeti ase engaki y’amatuko atano na abere, na gento kende gionsi araararere nakebe egetachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Omokungu karagenderere goiteka amanyinga ase amatuko amange atari ay’omotienyi oye, gose ayagoiteka goetania amatuko aye ay’omotienyi, nigo arabe oyotachenegeti ase engaki eyio yonsi arabe ogoiteka amanyinga; nabe oyotachenegeti buna ekero are nomotienyi. ");
INSERT INTO guz_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ebiraarero bionsi are koraarera ekero agoiteka amanyinga, nigo biraabe ebitachenegeti buna ebi akoraarera ekero are nomotienyi, naboigo na kende gionsi araikaransere. ");
INSERT INTO guz_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Na onde bwensi orakune ebinto ebio nabe oyotachenegeti; ere asibie chianga chiaye, esibie nomobere namaache, naende nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ekero ogoiteka kwaye kw’amanyinga gwakamire, abare amatuko atano na abere, erio nabe ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ase rituko ria gatano na gatato aire amaruma abere gose amage ’amaruma abere ase Omokuani agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Omokuani arue erimo ribe ekeng’wanso ki’ebibe, na erinde eki’ogosaambwa. Ase enchera eyio nakore okobwatanigwa ase omokungu oria ase obosio bwane, ase engencho y’ogotacheneka kwaye kw’ogoiteka kw’amanyinga. ");
INSERT INTO guz_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Ase enchera eyio okuurere Abaisraeli igoro y’ogotacheneka kwabo, tibaabaisa kogera Obomenyo bwane Obochenu bore ase egati yabo bobe obotachenegeti. Baise gokora bo, nigo barakwe.” ");
INSERT INTO guz_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Aya naro amachiiko ase omonto okorua amaache anga buna chimengere, na oyogosokia embusuro yaye y’oroiboro, na koba oyotachenegeti ase engencho eyio, ");
INSERT INTO guz_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","naboigo nase omokungu ore nomotienyi, na ase onde bwensi, omosacha okorua amaache anga buna chimengere, na omokungu ogoiteka amanyinga, naende ase omosacha okoraara n’omokuungu otachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Magega y’ogokwa kw’abamura baria babere ba Aroni baitetwe n’Omonene, ekero bamorenterete omorero bw’engencho eng’ao, oyio batachigetwe, Omonene agakwana na Musa, ");
INSERT INTO guz_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","akamoteebia, “Teebia Aroni, momura omino, ng’a tabaisa gosoa ime y’Aase Aachenu Mono, moino y’etoto, bosio bw’Oboikaranso bwa amaabera obore ekemumeko gi’Esanduki eria, engaki ende yonsi, ekiagera agwo nao ngochia kooroka ime ye riire igoro y’Oboikaranso obwo bwa amaabera. Aise gokora bo, goika akwe. ");
INSERT INTO guz_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Igo arasoe ime y’Aase Aachenu Mono magega karentire eeri ensae ebe ekeng’wanso ki’ebibe, na emingichi ebe ekeng’wanso ki’ogosaambwa. ");
INSERT INTO guz_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Ritang’ani Aroni atarasoa Aase Aachenu Mono, goika esibie omobere oye namaache, amanye kobeeka chianga chiria chinchenu: Eganchwa erobekanirie eigete inse, ne chisirwari, na orokini, na ekegogwa, bionsi biroisirie korwa ase egatani. ");
INSERT INTO guz_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Erio Aroni aegwe korwa ase omoganda bw’Abaisraeli chigoree ibere chibe ekeng’wanso ki’ebibe, na emingichi eyemo ebe ekeng’wanso ki’ogosaambwa. ");
INSERT INTO guz_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ritang’ani arue eeri ebe ekeng’wanso ase ogokora okobwatanigwa asere omonyene, na ase abanto b’enka yaye, erinde baaberwe. ");
INSERT INTO guz_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Naende arente chigoree chiria ibere ase obosio bwane inche Omonene agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Agwo Aroni aake obomera igoro ye chigoree chiria ibere, obomera obomo ase ’nde, na obonde ase Asaseli. ");
INSERT INTO guz_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Egoree eria eraabe yagwereirwe nobomera ase ’nde, Aroni ayerente ebe ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Na egoree eria eraabe yagwereirwe nobomera ase Asaseli ayerente ere moyo ase obosio bwane inche Omonene, erinde akore okobwatanigwa asero, na koyetiga esiboire egende ase erooro ase Asaseli. ");
INSERT INTO guz_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Naboigo Aroni arente eeri eria ebe ekeng’wanso ki’ebibe biaye, akore okobwatanigwa asere omonyene, na ase abanto b’enka yaye, anyenye eeri eria. ");
INSERT INTO guz_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Erio aimokie orogio roichire omorero bw’amakara korwa ase egesasiimero kere ase obosio bwane, n’ekoroso eichire chindoe ibere, ayerente moino y’etoto eria enachete Obomenyo Obochenu, ");
INSERT INTO guz_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ayebeke ase omorero igoro, agwo ase obosio bwane, erinde erioki ria ekoroso eyio ritube Oboikaranso bwa amaabera obore ekemumeko gi’Esanduki ere ne chibao chiriikire oborori. Atakoreti bo, nigo arakwe. ");
INSERT INTO guz_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Aimokie amanyinga make ay’eeri eyio, ayanyororokerie ase oboikaranso bwa amaabera bosio, na bosio bw’Oboikaranso boria bwa amaabera ara gatano na kabere nekiara kiaye. ");
INSERT INTO guz_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Magega y’ayio anyenye embori eria ebe ekeng’wanso ase engencho y’ebibe bi’abaanto, aire amanyinga ’embori eyio moino y’etoto eria, ayanyororokerie igoro ase oboikaranso bwa amaabera bosio, na bosio bw’Oboikaranso boria akore buna akorete namanyinga ’eeri eria. ");
INSERT INTO guz_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Naboigo akore okobwatanigwa ase Aase Aachenu Mono ase engencho y’ogotacheneka kw’Abaisraeli amo nogosaria kwabo, na ebibe biabo bionsi. Naende akore okobwatanigwa ase Eema y’Omosangererekano, eyio ere amo nabarabwo na ase egati y’ogotacheneka kwabo. ");
INSERT INTO guz_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Monto onde tatigara ime ase Eema y’Omosangererekano korwa ekero Aroni agosoa ime y’Aase Aachenu Mono akore okobwatanigwa goika arueo, gakoorire gokora okobwatanigwa asere omonyene, na ase abanto b’enka yaye, na ase omosangererekano bwonsi bw’Abaisareli. ");
INSERT INTO guz_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Erio asoke agende ase egesasiimero kere agwo ase obosio bwane, agekorere okobwatanigwa, naende aimokie amanyinga make ay’eeri gose ey’embori eyio, ayagindie ase emegwekano yonsi ye ching’unchara ere ase chikoona chi’egesasiimero ekio, ");
INSERT INTO guz_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","naende anyororokerie egesasiimero namanyinga ayio nekiara kiaye ara gatano na kabere. Ase enchera eyio agesibie na kogechena korwa ase ogotacheneka kore ase Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Ekero Aroni akoorire gokora okobwatanigwa ase Aase Aachenu Mono, na ase Eema y’Omosangererekano, na ase egesasiimero, arente embori eria ere moyo. ");
INSERT INTO guz_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Erio goika abeeke amaboko aye abere ase omotwe bw’embori eria ere moyo, aorokie igoro ase embori eyio obobe bwonsi bw’Abaisraeli na ogosaria kwabo gwonsi, na ebibe biabo bionsi. Ase enchera eyio ang’anyie ebio bionsi, abibeke igoro ase omotwe bw’embori eyio. Naende embori eyio eirwe ase erooro nomonto obekirwe ang’e. ");
INSERT INTO guz_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Naboigo embori eria ebogorie ebibe biabo bionsi, egende nabio gochia ase erooro ase abanto batamanyeti. ");
INSERT INTO guz_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Magega y’ayio Aroni asoe Eema y’Omosangererekano, arusie chianga chi’egatani chiria abegete ritang’ani atarasoa Aase Aachenu, achitigeo. ");
INSERT INTO guz_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Erio esibie omobere oye namaache agwo aase gete are aachenu, naende abeeke chianga chiaye chia botaambe. Magega y’ayio asoke, arue ekeng’wanso ki’ogosaambwa ase engencho yaye ere omonyene amo neki’abaanto bonsi na akore okobwatanigwa asere omonyene na ase abanto. ");
INSERT INTO guz_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Naende asaambere ebitinya bi’ekeng’wanso keria ki’ebibe ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Omonto oyio oirete embori eria ase erooro ase Asaseli, asibie chianga chiaye, esibie nomobere namaache; magega y’ayio amanye gosoa ase egetwori. ");
INSERT INTO guz_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Eeri eria amo nembori eria chiaruetwe chibe ekeng’wanso ki’ebibe, echio amanyinga abo arentwe ime y’Aase Aachenu Mono akore okobwatanigwa, chiirwe isiko y’egetwori. Riiyo ne risankwa, amo ne chinyama ne chisike chiabo, bisaamberwe aroro n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Omonto oria orasaambe ebinto ebio nigo arasibie chianga chiaye, esibie nomobere namaache; magega y’ayio amanye gosoa ase egetwori. ");
INSERT INTO guz_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Oyo noro omooroberio ochikiire ase more moragenderere korenda botaambe. Rituko ria ikomi, ase omotienyi o gatano na kabere, inamobe mokweng’ata na gweitia; timokora emeremo ende yonsi, inwe abanyene, gose abamenyi bamenyete ase egati yaino. ");
INSERT INTO guz_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ase rituko erio okobwatanigwa ngokorwe ase more ase okobasibia korwa ase ebibe biaino bionsi, nainwe namocheneke ase obosio bwane inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Rituko erio naribe richenu mono ase more, rituko ri’ogotimoka, na inwe namweng’ate. Oyio nomoroberio ochiikirwe oragenderere botaambe. ");
INSERT INTO guz_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Omokuani oakirwe amaguta na gwatananwa abe Omokuani ribaga ria ise, nere orakore okobwatanigwa okwo. Ere nigo arabeeke chianga chiria chinchenu chi’egatani, ");
INSERT INTO guz_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","na akore okobwatanigwa ase Aase Aachenu Mono, na ase Eema y’Omosangererekano, naende akore okobwatanigwa ase abakuani, na ase omosangererekano bw’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Omoroberio oyio ochiikirwe ase more oragenderere botaambe, ng’a okobwatanigwa kobe kogokorerwa ase Abaisraeli ara rimo ase omwaka ase okobachena korwa ase ebibe biabo bionsi.” Musa agakora buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Teebia Aroni na abamura baye amo n’Abaisraeli bonsi ng’a inche Omonene nachiikire iga: ");
INSERT INTO guz_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Onye omonto onde bwensi okonyenyera eng’ombe, gose emaanwa y’eng’ondi, gose embori, ase egetwori, gose isiko y’egetwori, ");
INSERT INTO guz_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","atayerenteti agwo ase egesoero ki’Eema y’Omosangererekano ebe ekeng’wanso ase ’nde, bosio bw’Obomenyo bwane, rirorio okomocha kw’ogoitera amanyinga nakobarerwe omonto oyio. Ere oiteire amanyinga, ase igo naatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Bono Abaisraeli tibakonyara gokora buna baarenge gokora agwo ritang’ani, tibakonyenyera ching’iti chi’ebing’wanso biabo orosana isiko; goika bachindetere inche Omonene, bachiire ase Omokuani agwo ase egesoero ki’Eema y’Omosangererekano, bachinyeenyereo chibe ebing’wanso bi’omorembe ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Na Omokuani asiarere amanyinga ase egesasiimero kiane agwo ase egesoero ki’Eema y’Omosangererekano, naende asaambe ebitinya bibe rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Abaisraeli tibaabaisa konyenyera ebing’wanso biabo isiko aande na kobirua ase ebirecha, na igo babe abatari abegenwa ase ’nde. Oyio nobe omooroberio ochikiire oragenderere botaambe, ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Ase igo obateebie ng’a monto onde bwensi ase Abaisraeli, gose omomenyi omenyete ase egati yabo, kararue ekeng’wanso kegosaambwa ekegima, gose ekeng’wanso kende gionsi, ");
INSERT INTO guz_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","na omonto oyio atakerenteti ase egesoero ki’Eema y’Omosangererekano na gokerua ase ’nde, nigo araatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Onde bwensi ase Abaisraeli, gose omomenyi omenyete ase egati yabo, oraarie amanyinga ande onsi, inche Omonene nimbe mamincha y’omonto oyio, na inche nimwatanane korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Obomoyo bwa kera omobere nigo bore ime ase amanyinga; nabaeire amanyinga moyanyororokererie ase egesasiimero akore okobwatanigwa ase obomoyo bwaino; amanyinga naro agokora okobwatanigwa, ekiagera obomoyo bore imeo. ");
INSERT INTO guz_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ase ayio natebirie Abaisraeli ng’a monto onde bwensi obo, gose omomenyi omenyete ase egati yabo, tabaisa koria amanyinga ande onsi. ");
INSERT INTO guz_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Omonto onde bwensi ase Abaisraeli, gose omomenyi omenyete ase egati yabo, oraite eng’iti y’orosana, gose enyoni eyancheire koriegwa, goika aitere amanyinga aye inse, erio ayatube amaroba. ");
INSERT INTO guz_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Obomoyo bwa kera omobere nigo bore ase amanyinga. Ase engencho eyio nateebirie Abaisraeli ng’a tibaria amanyinga y’eng’iti ende yonsi, ekiagera obomoyo bwa kera egetongwa nigo bore ase amanyinga aye. Omonto onde bwensi oraarie amanyinga nigo araatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Omonto onde bwensi, omobiare gose omomenyi omenyete ase egati yaino, oraarie eng’iti ekwete yoka enyene, gose eyeitire ne ching’iti chinde chi’orosana, goika asibie chianga chiaye, esibie nomobere namaache; nabe oyotachenegeti goika omogoroba oyio, erio abe ochenekire. ");
INSERT INTO guz_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Korende onye tagosibia chianga chiaye na gwesibia omobere, rirorio nabogorie obobe bwaye.” ");
INSERT INTO guz_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Teebia Abaisraeli ng’a nateebire iga: Inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Timobaisa gokora buna abanto ba Misiri bagokora, agwo ase mwamenyete, gose buna abanto ba Kaanani bagokora, ense eyio nkobaira mochie komenya, gose timobaisa kobwatia chingencho chiabo. ");
INSERT INTO guz_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Moigwere amachiiko aane, na mokore aya nkobachika. Inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ee, mokore aya nkobachika, na mobwate amachiiko aane. Omonto karakore amang’ana ayio nabe moyo. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Monto onde bwensi tabaisa koraara n’omokuungu ore omoamate omwabo. Okwo nokorentera omoamate omwabo obosooku. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Tobaisa koraara na nyoko. Okwo nokomorentera iso obosooku. Torentera nyoko obosooku. ");
INSERT INTO guz_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Tobaisa koraara na nyoko moke, moga iso. Okwo nokomorentera iso obosooku. ");
INSERT INTO guz_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Tobaisa koraara na moiseke omino, omoiseke o iso gose oyo o nyoko, onye moiboire komo ase enyomba eyemo, gose oiboire ase enyomba ende. ");
INSERT INTO guz_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Tobaisa koraara nomochokoro oo, oyo bw’omwana oo omomura, gose oyo bw’omwana oo omosubati. Ayio nigo arakorentere obosooku. ");
INSERT INTO guz_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Tobaisa koraara nomoiseke o nyoko moke, moga iso; oyio nomoiseke omino iso aiborete. ");
INSERT INTO guz_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Tobaisa koraara nomoiseke omwabo iso; oyio nyoko moke, omwabo iso. ");
INSERT INTO guz_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Tobaisa koraara nomoiseke omwabo nyoko; oyio nyoko moke, omwabo nyoko. ");
INSERT INTO guz_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Tobaisa koraara na moga iso moke omwabo iso; okwo nokorentera iso moke obosooku, ekiagera omokungu oyio nyoko moke are. ");
INSERT INTO guz_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Tobaisa koraara na moka momura oo; obwo nobosooku, ekiagera n’omokuungu bw’omwana oo omomura. ");
INSERT INTO guz_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Tobaisa koraara na moka momura omino; okwo nokomorentera momura omino obosooku. ");
INSERT INTO guz_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Tobaisa koraara nomoiseke bw’omokuungu kwabeire nere, gose tobaisa gotwara omochokoro oye, omoiseke bw’omwana oye omosubati, gose oyo bw’omomura oye, ekiagera abwo nabaanto abamo. Obwo nobonyaka obobe. ");
INSERT INTO guz_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Tobaisa koira mokoyoo, omwabo mokao, ekero mokao are moyo; ayio nabaise korenta obobisa. ");
INSERT INTO guz_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Tobaisa koraara n’omokuungu ekero abwate omotienyi, ekiagera ere tachenegeti ase ekero ekio. ");
INSERT INTO guz_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Tobaisa koraara n’omokuungu bw’omosaacha onde na gwesoyia ase ogotacheneka nere. ");
INSERT INTO guz_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Tobaisa korua omwana onde oo abe ekeng’wanso ase enyasae Moleki, ekiagera okwo nokorentera erieta ria Nyasae oo obosooku. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tobaisa koraara nomonto omosacha buna okoraara n’omokuungu; obwo nobonyaka obobe bw’okogechia. ");
INSERT INTO guz_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Tobaisa koraara neng’iti ende yonsi na gwesoyia ase ogotacheneka nero. Na omokungu tabaisa kwerua koraara neng’iti ende yonsi. Obwo nobonyaka obobe kegima bw’okogechia. ");
INSERT INTO guz_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Inwe timobaisa gwekora abatachenegeti ase ogokora buna okwo. Ase enchera eyio abanto b’ebisaku mbesoetie ase ogotacheneka, na bono inche Omonene nkobaseria inde baabatigere inwe ense eyio. ");
INSERT INTO guz_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ogokora kwabo gokarentera ense eria ogotacheneka, na inche nkayea egesusuro ase engencho y’ogosaria okwo, na ense eyio ekaanga tiyatwara abanto bamenyeteo, korende ekabaseria. ");
INSERT INTO guz_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ase igo inwe mwensi, ababiare gose abamenyi bamenyete ase egati yaino, goika morende amachiiko aane na kobwata aya onsi nabachiikire, gose timobaisa gokora kende gionsi gi’okogechia okwo abanto b’ebisaku bakorete. ");
INSERT INTO guz_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Abanto bamenyete ase ense eria ritang’ani riaino nigo bakorete okogechia okwo gwonsi, na igo ense eria ekaba etachenegeti. ");
INSERT INTO guz_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Moise gokora ayio, ense eyio nigo erabaange morue aroro, buna yangete abanto b’ebisaku, abwo baabatang’anerete komenyao, ");
INSERT INTO guz_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ekiagera monto onde bwensi orakore okogechia konde gwonsi buna okwo, oyio naatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“Ase ayio, moigwere amang’ana aya onsi nabachiikire, na moyakore. Timobaisi kwenaria chingencho chi’okogechia chiakoretwe nabaanto abwo baabatang’anerete komenya ase ense eyio. Moise gokora igo, inamwesoyie ase ogotacheneka ase chingencho echio. Inche ninche Omonene, Nyasae oino.” ");
INSERT INTO guz_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Teebia omoganda bwonsi bw’Abaisraeli: Mobe abachenu, ekiagera inche Omonene, Nyasae oino, nigo inde omochenu, ");
INSERT INTO guz_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kera oyomo oino asike ng’ina na ise, naende morende Chisabato chiane. Inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Timontiga na koonchokera emegwekano y’ogosasiimwa, gose timwekorera chinyasae korwa ase ebioma binyititoire na kobombwa. Inche ninche Omonene Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Onye moganetie korua ekeng’wanso ki’omorembe ase ’nde inche Omonene, mobwate emeroberio yachiikirwe, erio nario ekeng’wanso ekio kerancherwe. ");
INSERT INTO guz_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Chinyama chi’ekeng’wanso ekio chiriegwe ase rituko erio erio eng’iti yanyenywa, gose rituko ria kabere, korende echiratigare ase rituko ria gatato chisambwe n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Chiise koriegwa ase rituko ria gatato, ekeng’wanso ekio inakebe okogechia, tikegwancherwa. ");
INSERT INTO guz_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Monto onde bwensi orakerie ekero ekio nabarerwe obobe bwaye, ekiagera okorire egento giatananetwe ase ’nde kebe egetari egechenu. Omonto oyio naatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ekero mokogesa emegondo yaino, timogesa moikie ase chingito kegima, gose timoirana gochora ebitigari ase emegondo. ");
INSERT INTO guz_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Timobaisa gochoora amasabibu atigarete, gose agwete inse, ase emegondo yaino y’emesabibu; ayio motigere abataka na abamenyi. Inche ninche Omonene Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Timoiba, gose timong’ainana, gose timoteebania oborimo. ");
INSERT INTO guz_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Timobaisa gotiana ogotiana kw’oborimo ase erieta riane. Moise gokora igo, nigo moraarentere erieta riane obosooku. Inche ninche Omonene Nyasae. ");
INSERT INTO guz_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Tobaisa korianania omogisangio oo, gose komourereria. Tobaisa gotanga eng’eria y’omonto origete okogokorera emeremo, tebeera ase ore goika mambia. ");
INSERT INTO guz_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Tobaisa koragereria omonto omotino, gose kobeeka ekegocha bosio bw’omonto omouko, korende omoiroke Nyasae oo. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Timokora ayatari boronge ekero ebiina bikogambwa; timobaisa gwanchereria omotaka, gose koiroka omonda, korende monache ebiina ebironge ase abagisangio baino. ");
INSERT INTO guz_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Tobaisa goeta‐eta ase egati y’abanto bamino gokwana obogenki; tobaisa kogera oyomino aitwe ase okoba kirori bw’oborimo. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Tobaisa kogecha oyomino ime ase enkoro yao, korende omokuurere maiso marore, erinde tokora ebibe ase engencho yaye. ");
INSERT INTO guz_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Tobaisa kweruseria egesiomba, gose kogenderera kogecha monto onde bwensi ase egesaku kiao, korende ancha omogisangio oo buna bweanchete aye omonyene. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Mobwate amachiiko aane. Timobaisa gotiga chitugo chiaino chieenane amarieme ne chitari egesaku ekemo. Timobaisa kobusura chimbusuro chi’ebisaku bibere ase omogondo oyomo, timobeeka chianga chiroisirie korwa ase chiusi ao ao. ");
INSERT INTO guz_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Omonto aise koraara nomoiseke ore omosomba na oriereirwe boko nomonto omoao, na omoiseke oria taraboorigwa, gose taranyora obosibore, barabwo babere nigo baraegwe egesusuro, ko tibagoitwa, ekiagera omoiseke oyio taranyora obosibore. ");
INSERT INTO guz_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Omonto oyio arente emingichi eyemo ase ’nde inche Omonene, agwo ase egesoero ki’Eema y’Omosangererekano, ebe ekeng’wanso gi’okomocha kwaye. ");
INSERT INTO guz_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ase okorua emingichi eria y’ekeng’wanso gi’okomocha, Omokuani akore okobwatanigwa ase omonto oyio ase obosio bwane, ase engencho y’ebibe biria akorire, na omonto oyio naaberwe ase ebibe ebio akorire. ");
INSERT INTO guz_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Ekero moraike ase ense ya Kaanani na mosimeke emete y’ebisaku ao ao ekwama amatunda, timobaisa koria amatunda ’emete eyio ase engaki y’emiaka etato ye ritang’ani, korende moyebare ng’a nekanire. ");
INSERT INTO guz_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ase omwaka o kane amatunda ’emete eyio aatananwe abe amaachenu ase ’nde inche Omonene, moyang’e ase okong’iraneria ng’a mbuya mono na gontogia. ");
INSERT INTO guz_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Korende ase omwaka o gatano inamorie amatunda ’emete eyio. Komorakore igo, emete inayame amatunda amange ase more. Inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Timobaisa koria enyama ende yonsi ebwate amanyinga ime yaye. Timobaisa gwancha oboragori, gose oborogi bonde bwonsi. ");
INSERT INTO guz_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Timobaisa konacha chitukia chiaino, gose chinderu chiaino mesia. ");
INSERT INTO guz_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Timobaisa gwesaraga emebere yaino ase okoreera abakuure, gose gwesamba kobeeka ekemanyererio kende gionsi. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Tobaisa korentera omoiseke oo obosooku ase okomoira abe omotayayi ase chie Hekalu, ense yonsi nigo erabaise gokora obotayayi na goichorwa nobonyaka. ");
INSERT INTO guz_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Morende Chisabato chiane, naende mosike Obomenyo bwane Obochenu. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Timorigia ogosemigwa korwa ase abanto abakoboria amang’ana korwa ase emeika y’abanto bakwete, gose timogenda ase abaragori. Moise gokora igo, nigo moraabe abatachenegeti goetera ase bare. Inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Otenene ase omonto omogotu ore ne chimbuche, ase okomosika; omoiroke Omonene oo. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Timobaisa kobakorera bobe abamenyi bamenyete ase ense yaino. ");
INSERT INTO guz_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mokorere abamenyi bamenyete ase egati yaino buna mogokorera ababiare, mobanche buna mweanchete inwe abanyene, ekiagera nainwe nabo mwareenge abamenyi ase ense ya Misiri. Inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Timokorerana oborianania ase ebirengo binde bionsi, ebi’obotaambe, gose ebi’oborito, gose ebi’obonge. ");
INSERT INTO guz_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mokorere ekerengo kia boronge; motware amagena ay’okorenga aboronge, na ebimunu bi’okorenga bia boronge, na ebituba bi’okorenga bia boronge. Inche ninche Omonene, Nyasae oino, nabarusetie korwa ase ense ya Misiri. ");
INSERT INTO guz_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Mobwate amachiiko aane onsi aya nabachiikire. Inche ninche Omonene.” ");
INSERT INTO guz_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Omonene agateebia Musa. ");
INSERT INTO guz_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Kwana n’Abaisraeli, obateebie: Monto onde bwensi oino, gose omomenyi omenyete ase egati yaino, orarue omwana onde oye ase enyasae Moleki, goika aitwe akwe. Omoganda oino bwonsi omoake amagena. ");
INSERT INTO guz_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Inche omonyene nimbe nendamwamu ase omonto oyio, ekiagera orure omwana onde oye ase enyasae Moleki. Nimwatanane korwa ase abanto baye, ekiagera ogerire Obomenyo bwane Obochenu bobe obotachenegeti, na orenteire erieta riane richenu obosooku. ");
INSERT INTO guz_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Onye abanto b’ense yaino bakoombia, tibaita omonto oyio orure oyomo bw’abana baye ase enyasae Moleki, ");
INSERT INTO guz_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","erio inche omonyene nimbe nendamwamu ase omonto oyio na eamate yaye. Nimwatanane amo nabaanto bonsi bamobwatirie, ekiagera bakoonchokera enyasae eria Moleki, ase okoyesasiima, bakaba abatari abegenwa ase ’nde; nimbasirie korwa ase abanto baye.” ");
INSERT INTO guz_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Onye omonto okorigia ogosemigwa korwa ase abanto bakoboria amang’ana korwa ase emeika y’abanto bakwete, gose kogenda ase abarogi, taba omwegenwa ase ’nde, korende abe ogosasiima emeika eyio, inche nimbe nendamwamu ase omonto oyio, na imwatanane korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Eatanane, mwerue mobe abachenu, ekiagera inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mobwate amachiiko aane na koyakora; inche ninche Omonene, nkobachena. ");
INSERT INTO guz_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Kera omonto okoragereria ise gose ng’ina, oyio goika akwe. Ekiagera oragereirie ise na ng’ina, okomocha kw’ogoiteka kw’amanyinga aye nigo koraabe okwaye. ");
INSERT INTO guz_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Onye omonto ogotomana n’omokuungu bw’omonto onde, abwo babere, omosacha oria amo n’omokuungu oria, goika baitwe bakwe. ");
INSERT INTO guz_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Onye omonto okoraara n’omokuungu ore moga ise, igo orenteire ise obosooku; abwo bonsi babere goika baitwe bakwe. Okomocha kw’ogoiteka kw’amanyinga abo nigo koraabe okwabo. ");
INSERT INTO guz_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Onye omonto okoraara na moka momura oye, abwo bonsi babere goika baitwe bakwe; bakorire okogechia. Okomocha kw’ogoiteka kw’amanyinga abo nigo koraabe okwabo. ");
INSERT INTO guz_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Onye omosacha okoraara nomosaacha onde buna akoraara n’omokuungu, abwo bonsi babere bakorire okogechia okobe; goika baitwe bakwe, na okomocha kw’ogoiteka kw’amanyinga abo nigo koraabe okwabo. ");
INSERT INTO guz_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Onye omonto okonyuoma omokungu aire na ng’ina biara abasang’ananie, obwo nobonyaka obobe. Omosacha oria amo nabakungu baria babere basambwe n’omorero bakwe, erinde obonyaka buna obwo tiboba ase egati yaino. ");
INSERT INTO guz_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Onye omonto okoraara neng’iti, omonto oyio aitwe akwe, n’eng’iti eyio eitwe ekwe. ");
INSERT INTO guz_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Onye omokungu ogoika eng’iti ende yonsi ang’e, na koraara nero, omokungu oyio goika aitwe akwe, n’engiti eyio eitwe ekwe. Okomocha kw’ogoiteka kw’amanyinga abo nigo koraabe okwabo. ");
INSERT INTO guz_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Onye omonto okoira omoiseke omwabo, oyo o ise gose o ng’ina, nabwo barorane bare getirianda, obwo nobosooku obonene. Barabwo goika baatananwe barusigwe ase amasio y’abanto b’egesaku kiabo. Omonto oyio orenteire omoiseke omwabo obosooku. Obobe bw’ogosaria okwo nigo boraabe igoro y’omonto oyio. ");
INSERT INTO guz_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Onye omonto omosacha okoraara n’omokuungu ekero abwate omotienyi, omonto oyio orenteire omokungu oyio obosooku ase okorora ensoko y’amanyinga aye, nere oorokirie ase amanyinga agoiteka korwa; abwo babere baatananwe korwa ase abanto b’egesaku kiabo. ");
INSERT INTO guz_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Tobaisa koraara nomoiseke omwabo nyoko, gose omoiseke omwabo iso; obwo nobonyaka obobe, ekiagera abwo nabanyako moke. Obobe bw’ogosaria okwo nigo boraabe igoro yabo. ");
INSERT INTO guz_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Onye omonto okoraara na moga ise moke, omwabo ise, igo orenteire ise moke obosooku. Egesusuro ki’ogosaria kw’ebibe biabo nigo keraabe ekiabo, na barabwo nigo barakwe bataiboreti bana. ");
INSERT INTO guz_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Onye omonto okoira moka momura omwabo, okwo nogosaria, ere orenteire momura omwabo obosooku. Barabwo nigo baragombae. ");
INSERT INTO guz_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Ase ayio mobwate amachiiko aane na emeroberio yonsi nabachiikire, na moyakore, erio ense eria ase nkobaira mogochia komenya tebaanga gose tebaseria korwa aroro. ");
INSERT INTO guz_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Timochia kobwatia chingencho chi’abaanto b’egesaku keria ngochia goseria kerue ase amasio aino; barabwo nigo bakorete amang’ana ayio onsi, na ase engencho y’ayio nkagechigwa nabarabwo. ");
INSERT INTO guz_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Korende inabarierete inwe eira ng’a nimbae ense yabo ebe omwando oino, ense entenenku ere namabeere na amooke. Inche ninche Omonene, Nyasae oino, nabaatananire inwe korwa ase ebisaku binde. ");
INSERT INTO guz_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Inwe goika momanye gwaatanana ching’iti chichenegete korwa ase echitachenegeti, ne chinyoni chichenegete korwa ase echitachenegeti. Timobaisa gwesoyia ase ogotacheneka ase okoria ching’iti gose chinyoni chitachenegeti, gose timoria ching’iti chinde chionsi chikwagura ase ense, echi naatananire chibe chitachenegeti ase more. ");
INSERT INTO guz_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Inwe mobe abachenu baane, ekiagera inche Omonene nigo inde omochenu, nabaatananire korwa ase ebisaku binde, erinde mobe abaane. ");
INSERT INTO guz_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Omosacha, gose omokungu, orarigie ogosemigwa korwa ase emeika y’abanto bakwete, gose oyore omoorogi, goika aitwe akwe. Abanto abwo baakwe amagena bakwe; okomocha kw’ogoiteka kw’amanyinga abo nakobe okwabo.” ");
INSERT INTO guz_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Omonene agakwana na Musa, akamoteebia, “Kwana nabakuani, abamura ba Aroni, obateebie ng’a Omokuani tabaisa gwesoyia ase ogotacheneka ase ogokuna egetondo ki’omonto okuure ase egati y’abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Nare ne ribaga gwesoyia ase ogotacheneka ase abanto aba: Ng’ina na ise, na omwana oye, omomura gose omoiseke, na momura omwabo; ");
INSERT INTO guz_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","boigo na omoiseke omwabo ore omwekuungi, oyo otaraba nomosaacha; asare nigo are ne ribaga gwesoyia ase ogotacheneka. ");
INSERT INTO guz_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ekiagera Omokuani are omotang’ani ase abanto baye, tabaisa gwesoyia ase ogotacheneka. ");
INSERT INTO guz_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Omokuani tabaisa kogingira ensemo ende y’etukia y’omotwe oye, gose konacha chinderu chiaye mesia, gose gwesaraga omobere. ");
INSERT INTO guz_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Abakuani mbabe abachenu ase ’nde inche Omonene obo, na tibarentera erieta riane obosooku, ekiagera nabwo bakorua okoruegwa kw’endagera kogosaambwa n’omorero ase ’nde inche Omonene. Ase ayio goika babe abachenu. ");
INSERT INTO guz_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Omokuani tabaisa konyuoma omokungu omotayayi, gose oyotari omwekuungi, gose oyobatiganire nomosaacha oye, ekiagera Omokuani nigo achenegete ase Omonene oye. ");
INSERT INTO guz_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Goika omobare ng’a nomochenu, ekiagera nere okorua okoruegwa kw’endagera ase ’nde inche Omonene oo; nabe omochenu ase ore, ekiagera inche Omonene nomochenu inde, ninche nkobachena. ");
INSERT INTO guz_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Onye omwana omoiseke bw’Omokuani ogwesaria ase okoba omotayayi, igo orenteire ise obosooku; omoiseke oyio goika asambwe n’omorero akwe. ");
INSERT INTO guz_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Oyore Omokuani omonene ase abamwabo, oyio onyororokeretigwe amaguta akweakwa ase omotwe oye, naende bwatananirwe ase okobeeka chianga chi’obokuani, ere tatiga etukia yaye esang’ang’are, gose tatandora chianga chiaye ase okoreera omonto okuure. ");
INSERT INTO guz_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Tabaisa gosoa enyomba ase abanto babekire omobere bw’omonto okuure gose gwesoyia ase ogotacheneka, naba ise gose ng’ina. ");
INSERT INTO guz_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Tasoka korwa ase Obomenyo Obochenu, gose gokora Obomenyo obo Obochenu bwa Nyasae oye bobe obotachenegeti, ekiagera amaguta aagetwe nigo amwatananete ere agenderere koba oyone, inche Nyasae oye. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ere anyuome omoiseke ore omwekuungi. ");
INSERT INTO guz_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Tabaisa konyuoma omokungu omoboraka, gose oyobatiganire nomosaacha oye, gose oyotari omwekuungi, gose ore omotayayi, korende anyuome omoiseke omwekuungi korwa ase abanto b’egesaku kiaye. ");
INSERT INTO guz_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Erio nario abana baye barabe abachenu, tibasareka ase egati y’abanto baye, ekiagera inche ninche Omonene, ninche nkobachena.” ");
INSERT INTO guz_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Omonene agakwana na Musa naende, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Kwana na Aroni, omoteebie ng’a onde bwensi ore ekerema tabaisa goika ang’e kondeetera inche, Nyasae oye, okoruegwa kw’endagera. Okwo nogochika koragenderere botaambe ase ororeeria rwaye ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Omonto ore na kemocho ase omobere oye tabaisa goika ang’e, onye ore omouko, gose rigata, gose ore na kemocho ase obosio bwaye, gose ore nekiimo ekemo egetambe goetania ekende, ");
INSERT INTO guz_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","gose omonto ore na kemocho ase okoboko gose ase okogoro, ");
INSERT INTO guz_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","gose omonto ore nesukubi ase omogongo oye, gose ore oboengere, gose oyore na kemocho ase eriso, gose oyo obosisa boriete, gose oborwaire bonde ase risankwa, gose omosacha chingetia chiaye chisaregete. ");
INSERT INTO guz_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Omonto onde bwensi ase ororeeria rwa Aroni Omokuani ore na kemocho ase omobere oye tabaisa goika ang’e kondeetera inche Omonene okoruegwa kw’endagera kogosaambwa n’omorero, ekiagera oyio ore na kemocho ase omobere oye tagoika ang’e andeetere inche, Nyasae oye, okoruegwa kw’endagera kogosaambwa n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ere nabe ne ribaga ri’okoria okoruegwa kw’endagera gokoruegwa ase ’nde inche Nyasae oye, okoruegwa okore ogochenu, amo nokore ogochenu mono. ");
INSERT INTO guz_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Korende ekiagera are na kemocho ase omobere oye, tagoika ang’e netoto enachete Obomenyo Obochenu, gose tagocha aike ang’e negesasiimero. Aise goika ang’e, nigo aragere Obomenyo bwane Obochenu bobe botachenegeti. Inche ninche Omonene, ninche nkobachena.” ");
INSERT INTO guz_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Amang’ana ayio naro Musa atebeetie Aroni, amo nabamura ba Aroni, na Abaisraeli bonsi. ");
INSERT INTO guz_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Kwana na Aroni na abamura baye, obateebie ng’a barende na bakore amasikani ase ebinto ebichenu, biria Abaisraeli bagwaatanana ase ’nde, erio tibaabaisa korenta obosooku ase erieta riane richenu. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Obateebie ng’a onye omonto onde bwensi ase ororeeria rwabo, ekero are oyotachenegeti; aise goika ang’e n’ebinto ebio Abaisraeli barabe bagwaatanana ase ’nde inche Omonene, omonto oyio naatananwe korwa ase obosio bwane, tagonkorera ase emeremo y’obokuani. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Omonto onde bwensi ase ororeeria rwa Aroni obwate oborwaire bwa ukoma, gose okorua amaache anga buna chimengere, tabaisa koria ebinto ebichenu goika ekero arabe ochenekire; naboigo na onde bwensi orakune egento getachenegeti, buna egetondo, gose omonto ogosokia embusuro yaye y’oroiboro, ");
INSERT INTO guz_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","na onde bwensi orakune eng’iti ekwagura, eye eramokore abe oyotachenegeti, gose akune omonto oragere abe oyotachenegeti, ogotacheneka kwaye gakoraabe okw’engencho ende yonsi. ");
INSERT INTO guz_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Omokuani onde bwensi orakune egento buna ekio nabe oyotachenegeti goika omogoroba oyio; ere takoria ebinto ebichenu goika ekero arabe bwesibirie omobere oye namaache. ");
INSERT INTO guz_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ekero erioba riagure, abe ochenekire, na magega y’ayio amanye koria ebinto ebichenu, ekiagera ebinto ebio nabio endagera yaye. ");
INSERT INTO guz_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Taria enyama y’eng’iti ekwete yoka enyene, gose eye eitire neng’iti ende y’orosana. Aise koria enyama buna eyio, nigo arabe oyotachenegeti. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Abakuani bonsi goika barende amang’ana aya nachiikire. Batayabwateti, nababe abakori ebibe ase ayio, na barabwo mbakwe, ekiagera bagosaria aya nachiikire. Inche ninche Omonene, ninche nkobachena. ");
INSERT INTO guz_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Omonto otari bw’eamate y’Omokuani tabaisa koria ebinto ebichenu. Omomenyi omenyete amo n’Omokuani, gose omonto orikire komokorera emeremo, abwo tibaabaisa koria ebinto ebichenu. ");
INSERT INTO guz_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Omosomba onde bwensi Omokuani agorete ne chitaabu chiaye omonyene, gose omosomba oiboreire ase enka yaye, abwo nabarie endagera eria Omokuani akoegwa. ");
INSERT INTO guz_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Omoiseke bw’Omokuani karanyuomwe nomonto otari Omokuani tabaisa koria ebinto ebichenu bikoruegwa bibe ebing’wanso. ");
INSERT INTO guz_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Korende omosubati bw’Omokuani osogete otigirwe ore omoboraka, gose batiganire nomosaacha oye, na tabwati omwana, na bono oiranire gocha o ise komenyao buna ekero areenge omoke, nanyare koria endagera eria ya ise. Korende omonto otari bw’eamate y’Omokuani tabaisa koria endagera eria. ");
INSERT INTO guz_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Omonto onde bwensi otari bw’eamate y’Omokuani oraarie ebinto biria ebichenu ase ogotamanya, goika airanie egento egechenu ase Omokuani, buna keria airete, na ameente ensemo ya isano ye rigori ri’egento ekio. ");
INSERT INTO guz_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Abakuani tibaabaisa gokora ebinto ebi ebichenu Abaisraeli bagwaatanana na kobirua ase Omonene bibe ebitachenegeti, ");
INSERT INTO guz_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","na igo bakogera abanto babogorie ebibe biabo, na okomocha kwabo, ase okoria ebinto ebichenu baruete. Inche ninche Omonene, ninche nkobachena.” ");
INSERT INTO guz_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Teebia Aroni na abamura baye, na Abaisraeli bonsi, ng’a ekero omonto onde bwensi bw’Abaisraeli, gose omomenyi omenyete ase egati yabo, aganetie konduera inche Omonene ekeng’wanso ki’ogosaambwa, keraabe nase engencho y’eira, gose neki’ogwancha kwaye, ");
INSERT INTO guz_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","goika arue eeri, gose egoree, gose emingichi, chitari na kemocho ase emebere yabo, erio nario ekeng’wanso kerancherwe. ");
INSERT INTO guz_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Timobaisa korua eng’iti ende yonsi ere na kemocho ase omobere oye, naki ase ekeng’wanso buna ekio timogwancherwa. ");
INSERT INTO guz_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ekero omonto onde bwensi akorua ekeng’wanso ki’omorembe ase ’nde, ase engencho y’eira ariete, gose eki’ogwancha kwaye, korwa ase chiombe gose ching’ondi, goika ebe eng’iti eng’ikeranu, etari na kemocho ase omobere oye, eyio nero erancherwe. ");
INSERT INTO guz_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Timobaisa konduera ching’iti chiukorete, gose chire ebisegora, gose ebirema, gose chire namaote akorua amaira, gose chibwate egesuneri, gose amaote, ng’a chibe ekeng’wanso kegosaambwa n’omorero ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Eeri gose emaanwa y’eng’ondi ebwate ekiimo egetambe goetania ekende, gose ekieng’e mono, nabo oranyare koyerua ebe ekeng’wanso ki’ogwancha, korende ase okoyerua ebe ekeng’wanso ki’ogoikerania eira kwariete, tegwancherwa nainche. ");
INSERT INTO guz_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Eng’iti ende yonsi chingetia chiaye chisaregete ase ogosunyuntwa, gose ase okomiorigwa, gose ase okobutorwa, gose ase okonatwa, timobaisa koyerua ebe ekeng’wanso ase ’nde. Timokora igo ase ense yaino. ");
INSERT INTO guz_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“Eng’iti ende yonsi ere buna echio moranyore korwa ase omomenyi, timobaisa koyerua ebe okoruegwa kw’endagera ase ’nde. Echio nigo chire nebimocho ase emebere yabo, na ase ebing’wanso buna ebio timogwancherwa.” ");
INSERT INTO guz_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Naende Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ekero emori, gose emaanwa y’eng’ondi, gose ey’embori, yabiarirwe, etigwe ebe ase eng’ina ase engaki y’amatuko atano na abere, korende korwa ase rituko ria gatano na gatato yancherwe ebe ekeng’wanso kegosaambwa n’omorero ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Timobaisa konyenya eng’ombe amo nemori yaye ase rituko erimo, gose eng’ondi, gose embori amo ne chimanwa chiabo ase rituko erimo. ");
INSERT INTO guz_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ekero moganetie konduera inche Omonene ekeng’wanso ki’ogoaka ng’a mbuya mono, mokerue ase enchera endonge, erinde monyare gwancherwa. ");
INSERT INTO guz_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ekeng’wanso ekio keriegwe keere ase rituko erio erio, tigetigara nonya ngesinini goika rituko ria kabere. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ase ayio mobwate amachiiko aane na koyakora. Inche ninche Omonene, ");
INSERT INTO guz_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Timobaisa korentera erieta riane obosooku, korende nincheneke ase Abaisraeli. Inche ninche Omonene, ninche nkobachena. ");
INSERT INTO guz_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ninche nabarusetie korwa ase ense ya Misiri, erinde imbe Nyasae oino. Inche ninche Omonene.” ");
INSERT INTO guz_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Omonene agakwana na Musa, akamoteebia ");
INSERT INTO guz_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Kwana n’Abaisraeli, obateebie: Moraarie Amatuko Amanene ay’Omonene, na mobe nemesangererekano yaatananirwe ase ogosasiima. ");
INSERT INTO guz_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ase amatuko atano na rimo mokore emeremo yaino, korende ase rituko ria gatano na kabere n’Esabato, rituko ri’ogotimoka, rituko ri’omosangererekano bwatananirwe ase ogosasiima. Timobaisa gokora meremo ende yonsi. Erio nerituko ri’Esabato ri’Omonene, aande onsi ase moramenye. ");
INSERT INTO guz_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Naende nareo Amatuko ande Amanene ay’Omonene, mobe nomosangererekano bwatananire ase ogosasiima, moyararie ase engaki yachikiire. ");
INSERT INTO guz_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Rituko ria ikomi na kane ri’omotienyi bw’eritang’ani, chinsa chia mogoroba, nario Epasaka y’Omonene. ");
INSERT INTO guz_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Na ase rituko ria ikomi na gatano ri’omotienyi oyio ne Rituko Rinene ri’Omonene, rituko ri’Emegati etabeekiri memera; inamorie emegati etabeekiri memera ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ase rituko rie ritang’ani mobe nomosangererekano bwatananire ase ogosasiima, na timobaisa gokora emeremo ya kera rituko, ");
INSERT INTO guz_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","korende namorue okoruegwa kw’endagera kogosaambwa n’omorero ase Omonene ase engaki y’amatuko atano na abere. Ase rituko ria gatano na kabere namobe nomosangererekano bwatananire ase ogosasiima. Timokora emeremo ya kera rituko.” ");
INSERT INTO guz_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Kwana n’Abaisraeli, obateebie: Ekero moraike ase ense eri’Omonene arabae, na mokogesa okwama kwaino, morente riboa ri’ogotongora kwe rigesa riaino ase Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ase rituko rigotunyana eri’Esabato Omokuani asungusie riboa erio ase obosio bwane, erio monyore ogwancherwa. ");
INSERT INTO guz_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ase rituko riria riboa erio rigosungusigwa inamorue boigo emaanwa emingichi yakoorire omwaka oyomo, etari na kemocho ase omobere oye, ebe ekeng’wanso ki’ogosaambwa ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Amo n’ekengwanso ekio morue obosie ebimunu bine bwochoganirie namaguta, bibe okoruegwa kw’endagera kogosaambwa n’omorero ase Omonene, kore ne rimisu rigiya rikomogwenera. Amo nokwo morue edivai egetuba ekemo ebe okoruegwa gw’ekenyugwa. ");
INSERT INTO guz_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Timobaisa koria okwama okwo okoyia: Ebigara ebibese, gose ebikarangire, gose ebiaroisigwe emegati, ekero motaraarentera Nyasae oino okoruegwa kwaino kw’ogotongora. Ogochika okwo nigo koragenderere ase more ebiaare ase ebiaare, aande onsi ase moramenye. ");
INSERT INTO guz_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Mobare chichuma isano na ibere korwa ase rituko rigotunyana eri’Esabato, rituko riria mokorentera Omonene riboa ri’ogotongora rigosungusigwa. ");
INSERT INTO guz_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Rituko ri’emerongo etano, nario rituko magega y’Esabato ya gatano na kabere, erio morentere Omonene okoruegwa konde kw’endagera enyia. ");
INSERT INTO guz_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Korwa ase kera enka morente emegati ebere eroisirie korwa ase obosie obonuke ebimunu bine amo n’ememera eraabe okoruegwa kw’endagera entang’ani y’okwama, kogosungusigwa ase Omonene. ");
INSERT INTO guz_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Amo nokoruegwa okwo morente ching’ondi isano na ibere echiakoorire omwaka oyomo, na eeri ensae, ne chimingichi ibere, chionsi chitari na kemocho ase emebere yabo, chibe ekeng’wanso ki’ogosaambwa ase Omonene, amo nokoruegwa kw’endagera na okw’ebinyuugwa okwo gochiikire amo. Okwo nokoruegwa kogosaambwa n’omorero ase Omonene, kore ne rimisu rigiya rikomogwenera. ");
INSERT INTO guz_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Naboigo morue egoree eyemo ebe ekeng’wanso ki’ebibe, ne chimanwa ibere chi’eching’ondi, chiakoorire omwaka oyomo, chibe ekeng’wanso ki’omorembe. ");
INSERT INTO guz_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Erio Omokuani asungusie omogati bw’ogotongora amo ne chimanwa chi’eching’ondi echio ibere ase obosio bw’Omonene. Ebinto ebio biatananwe bibe ebichenu ase Omonene, bibe endagera y’Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Rituko erio goika moraarie na mobe nomosangererekano bwatananire ase ogosasiima; timokora emeremo yaino ya kera rituko. Okwo nogochika koragenderere ase more ebiaare ase ebiaare, aande onsi ase moramenye. ");
INSERT INTO guz_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Ekero mokogesa emegondo yaino, timogesa moikie ase chingito kegima, gose timoirana gochora ebitigari ase emegondo yaino; eyio motigere abataka na abamenyi. Inche ninche Omonene, Nyasae oino.” ");
INSERT INTO guz_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Bateebie Abaisraeli ng’a rituko rie ritang’ani ri’omotienyi o gatano na kabere batimoke, batige emeremo kegima. Rituko erio naribe Rituko Rinene ri’Ekeinyorio, rirarigwe ase okobugigwa kw’ebiroria, babe nomosangererekano bwatananire ase ogosasiima. ");
INSERT INTO guz_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Tibakora emeremo yabo ya kera rituko, nabanduere inche Omonene ekeng’wanso kegosaambwa n’omorero.” ");
INSERT INTO guz_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Naende Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Rituko ria ikomi ri’omotienyi oyio o gatano na kabere, erio nario Rituko ri’Okobwatanigwa, mobe nomosangererekano bwatananire ase ogosasiima, na inwe inamobe mokweng’ata na gweitia, na mondetere inche Omonene ekeng’wanso kegosaambwa n’omorero. ");
INSERT INTO guz_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ase rituko erio timokora emeremo ende yonsi; rituko erio nario Rituko ri’Okobwatanigwa ekero okobwatanigwa kogokorwa ase more, ase obosio bwane inche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Omonto onde bwensi oteng’ate na gweitia ase rituko erio naatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Na monto onde bwensi orakore emeremo ende yonsi ase rituko erio, oyio inche Omonene nimosirie korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Timokora emeremo ende yonsi. Okwo nogochika koragenderere ase more, ebiaare ase ebiaare aande onsi ase moramenye. ");
INSERT INTO guz_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Rituko erio aribe ase more rituko ri’Esabato, rituko ri’ogotimoka kegima, na inwe namweng’ate na gweitia. Ase rituko ria kianda ase omotienyi oyio, chinsa chia mogoroba, mochaake korenda Esabato yaino, na mogenderere goika omogoroba onde.” ");
INSERT INTO guz_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Naende Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Bateebie Abaisraeli: Rituko ria ikomi na gatano ri’omotienyi oyio o gatano na kabere nario Rituko Rinene ri’ogochaaka Amatuko Amanene ase Omonene. Amatuko ’Ebigutu agenderere ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ase rituko rie ritang’ani timogokora emeremo ende yonsi ya kera rituko, korende nigo moraabe nomosangererekano bwatananire ase ogosasiima. ");
INSERT INTO guz_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kera rituko ase engaki y’amatuko atano na abere namobe mokoruera Omonene ekeng’wanso kegosaambwa n’omorero. Ase rituko ria gatano na gatato mobe nomosangererekano bwatananire ase ogosasiima moruere Omonene ekeng’wanso kegosaambwa n’omorero. Oyio nomosangererekano bw’engencho enene bwatananire ase ogosasiima; timokora emeremo yaino ya kera rituko. ");
INSERT INTO guz_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Aya naro Amatuko Amanene ase Omonene; moyararie, mobe nomosangererekano bwatananire ase ogosasiima. Ase amatuko ayio momoruere Omonene ekeng’wanso kegosaambwa n’omorero, na ebing’wanso bi’ogosaambwa, na okoruegwa kw’endagera, na ebing’wanso binde, na okoruegwa kw’ebinyugwa, kera ekemo ase rituko riaye richikiire. ");
INSERT INTO guz_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Amatuko aya Amanene nigo amentirwe ase Chisabato chiane chia botaambe, naende amentirwe ase ebiegwa biaino, na ase ebing’wanso bie chiira mwariete, na ebi’ogwancha, mokomoruera Omonene. ");
INSERT INTO guz_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Ase rituko ria ikomi na gatano ri’omotienyi o gatano na kabere, ekero mwakoorire rigesa ri’emegondo yaino, namorende Amatuko Amanene atano na abere ase Omonene. Rituko rie ritang’ani naribe rituko ri’Esabato, rituko ri’ogotimoka kegima, naboigo nase rituko ria gatano na gatato. ");
INSERT INTO guz_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ase rituko rie ritang’ani namoimokie amatunda amaya korwa ase emete yaino emiya, ne chinsagia chi’emekendo, ne chinsagia chibwate amato amange, na echi’emete enga buna emesobeti, na inwe namobe nomochengo ase obosio bw’Omonene, Nyasae oino, ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Amatuko atano na abere ase kera omwaka morende Amatuko ayio Amanene ase Omonene. Okwo nogochika koragenderere botaambe ase more, ebiaare ase ebiaare. Ase omotienyi o gatano na kabere namoyarende. ");
INSERT INTO guz_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Abanto bonsi abare ababiare b’Abaisraeli nabamenye ase ebigutu ase engaki y’amatuko atano na abere. ");
INSERT INTO guz_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Erio chinderia chiaino inachimanye ng’a Omonene nabamenyetie inwe Abaisraeli ase ebigutu ekero nabang’anyetie korwa ase ense ya Misiri. Inche ninche Omonene, Nyasae oino.” ");
INSERT INTO guz_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Naboigo Musa akaba ogokwana n’Abaisraeli igoro y’Amatuko amanene ay’Omonene. ");
INSERT INTO guz_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Omonene agakwana na Musa akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Chiika Abaisraeli ng’a barente amaguta amaya amitire korwa ase amazeituni akobekwa ase chitaaya, erinde chigenderere gwoka botaambe. ");
INSERT INTO guz_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Agwo isiko y’etoto eye ekengete chibao chiriikire oborori chibeekire ime y’Eema y’Omosangererekano, Aroni abe okorenda chitaaya korwa mogoroba goika mambia ase obosio bwane, inche Omonene. Okwo nogochika ase more koragenderere ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aroni arende chitaaya echio chire ase ekebekerero gi’echitaaya gi’etaabu echenire, erinde chigenderere gwoka botaambe ase obosio bwane inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Aye goika oimokie obosie obonuke, oroisie emegati ikomi na ebere. Kera omogati oire obosie boisaine ebimunu bine. ");
INSERT INTO guz_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Oroberie emegati eyio ase chindwaro ibere, etano nomo ase kera orwaro, igoro ase emesa eoomire netaabu echenire, agwo ase obosio bwane inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Obeke ekoroso echenire ase kera orwaro ebe ekemanyererio, ne ribaga ri’emegati eyio, ekoroso eyio eruegwe buna okoruegwa kw’endagera kogosaambwa n’omorero ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Kera rituko ri’Esabato botaambe emegati eroberigwe ase emesa igoro, agwo ase obosio bwane. Okwo nokoruegwa korwa ase Abaisraeli, nakobe okobwatana kw’ogotianania kwa botaambe. ");
INSERT INTO guz_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Emegati eyio nigo eraabe eya Aroni amo nabamura baye, na barabwo nabayeriere Aase achenire, ekiagera nemechenu mono, ebe egetari kiabo botaambe gi’okoruegwa okwo kogosaambwa n’omorero ase ’nde.” ");
INSERT INTO guz_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Nareenge omonto oyomo, ng’ina areenge Omoisraeli, na ise n’Omomisiri. Omonto oyio akagenda ase egetwori akoomana n’omonto onde Omoisraeli. ");
INSERT INTO guz_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Omonto oria ng’ina areenge Omoisraeli akarama erieta ri’Omonene na koriragereria. Abanto bakamobwata, bakamorenta ase Musa. Ng’ina omonto oyio nigo areenge korokwa Selomiti, omosubati o Debiri bw’egesaku kia Dani. ");
INSERT INTO guz_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Abanto bakamobeeka echela, na bakaganya amang’ana korwa ase Omonene ng’a ninki omonto oyio agochia gokorerwa. ");
INSERT INTO guz_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Na Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mosokie isiko y’egetwori omonto oyio oragereretie Omonene, na abanto baria bonsi bamoigwete gakoragereria, babeeke amaboko abo igoro ase omotwe oye, na omoganda bwonsi omoake amagena akwe. ");
INSERT INTO guz_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Erio oteebie Abaisraeli: Monto onde bwensi oraragererie Nyasae oye nabogorie ebibe biaye na anyore egesusuro. ");
INSERT INTO guz_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Omonto oraraame erieta ri’Omonene goika aitwe akwe; omoganda bwonsi omoake amagena. Karabe omomenyi gose omobiare, oyokorama Erieta ri’Omonene goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Omonto oraite omonto onde, nere goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Omonto oraite engi’ti etugire goika nayeakane. Obogima boakanwe nobogima. ");
INSERT INTO guz_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Omonto karaake omonto onde asarie omobere oye, buna omonto oria akorera oyonde, nere naboigo arakorerwe. ");
INSERT INTO guz_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Oyokobuna riuga ri’omonto onde, nere eriaye naribunwe; oyogwata eriso ri’omonto onde, nere eriaye nariaatwe; oyokogookora omonto onde erino, nere eriaye ndigookorwe; oyoraaremarie omonto onde, nere goika aremarigwe. ");
INSERT INTO guz_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Omonto oraite etugo goika nayeakane, na omonto oraite omonto onde, nere goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Mobe ne richiiko erimo rikogaambera abanto bonsi, karabe omomenyi gose omobiare, ekiagera inche ninche Omonene, Nyasae oino.” ");
INSERT INTO guz_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Nabo Musa agateebia Abaisraeli, na barabwo bakamosokia omonto oria oragereretigwe isiko y’egetwori, bakamoaka amagena, bakamoita. Naboigo Abaisraeli bagakora buna Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Omonene agakwana na Musa ase egetunwa gia Sinai, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Kwana n’Abaisraeli, obateebie: Ekero moraike ase ense eria Omonene arabae, ense eyio ebe n’Esabato ase Omonene, etimoke. ");
INSERT INTO guz_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Namosimeke emegondo yaino na gocheera emesabibu yaino, naende mogese okwama kw’emegondo y’ense eyio ase emiaka etano nomo. ");
INSERT INTO guz_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Korende omwaka o gatano na kabere obe omwaka bw’ogotimoka; ense etimokigwe kegima ase Esabato y’Omonene. Ase omwaka oyio timosimeka kende ase emegondo yaino, gose gocheera emesabibu yaino. ");
INSERT INTO guz_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Timobaisa kogesa echikwemeria korwa ase chimbusuro chiagwete, gose timosangereria amasabibu y’emesabibu etacheeretwe. Oyio nigo oraabe omwaka bw’ogotimoka kegima gw’ense eyio. ");
INSERT INTO guz_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Echio chiremerie ase omwaka bw’ogotimoka gw’ense eria, nachio chiraabe chindagera chibaisaine, aye omonyene, na abasomba bao, abamura na abaiseke, na omokori emeremo oo orikire, na omomenyi omenyete bwoo. ");
INSERT INTO guz_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Boigo ching’iti chitugire, ne ching’iti chi’orosana chire ase ense eyio nachirie okwama okwo kwemeretie. ");
INSERT INTO guz_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Mobare chichuma isano na ibere ara gatano na kabere. (Kera echuma eyemo ebe ey’engaki y’omwaka omogima.) Naboigo engaki eyio ebe ey’emiaka emerongo ene, na kianda. ");
INSERT INTO guz_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Erio ase rituko ria ikomi ri’omotienyi o gatano na kabere, Rituko ri’Okobwatanigwa, egetureeri kebugigwe ase ense yaino yonsi. ");
INSERT INTO guz_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mwatanane omwaka oyio bw’emerongo etano, moyochene. Morarie obosibore ase abanto bonsi bamenyete ase ense yaino. Omwaka oyio nobe omwaka bw’Omochengo ase more. Kera omonto ore ase more airanigwe ase omwando oye, na kera oyomo ase eamate yaye. ");
INSERT INTO guz_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Omwaka oyo bw’emerongo etano nobe oyio bw’Omochengo ase more. Ase omwaka oyio timobusura kende, gose kogesa echiemeretie korwa ase chimbusuro chiagwete inse, gose timosangereria amasabibu korwa emesabibu etacheeretwe. ");
INSERT INTO guz_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Omwaka oyio noyo bw’Omochengo. Nobe omochenu ase more. Inamorie chindagera chiemeretie chinyene korwa ase riroba. ");
INSERT INTO guz_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Ase Omwaka oyio bw’Omochengo kera omonto airanigwe ase omwando oye. ");
INSERT INTO guz_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ase igo onye gokooneria omonto onde gento kende gionsi, gose kogora korwa asaare, timobaisa gokorerana oborianania. ");
INSERT INTO guz_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Koragore omogondo korwa ase omonto onde oakane omonto oria koreng’ana n’emiaka eyio etigarete aragese ekero Omwaka bw’Omochengo otaraika. ");
INSERT INTO guz_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Onye emiaka ere emenge, nomente rigori, onye ere emeke, norikeeyie, ekiagera egento ekio agokooneria nomobaro bw’okwama kw’omogondo. ");
INSERT INTO guz_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Timobaisa gokorerana oborianania, korende moiroke Nyasae oino, ekiagera inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Ase ayio, mobwate amachiiko aane na koyakora, na mobwatie emeroberio yane echiikire; erio nario moramenye ase ense na mobe n’obotoereru. ");
INSERT INTO guz_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ense eria iyame okwama kwaye, na inwe monyore endagera mokoria na koigota, naende momenye ase obotoereru. ");
INSERT INTO guz_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Namoisa koboria: Ninki toraarie ase omwaka o gatano na kabere, onye titogosimeka gose gosangereria okwama? ");
INSERT INTO guz_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Momanye ng’a ninche Omonene ndasesenie ense yaino ase omwaka o gatano na rimo, erinde yaame endagera eraisane ase engaki y’emiaka etato. ");
INSERT INTO guz_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ekero morabusure chindagera ase emegondo yaino ase omwaka o gatano na gatato mogenderere koria endagera eria enkoro, goika endagera y’omwaka o kianda egeswe. ");
INSERT INTO guz_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Ense tekoonigwa ebe egenderere koba ey’oyio oyegora, ekiagera ense neyaane; inwe nigo more abamenyi momenyete ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Ase ense eyio yonsi moranyore ebe eyaino, ekero amaremo araoonigwe, namotige ribaga ri’okoyabooria naende. ");
INSERT INTO guz_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Onye oyomino obeire omotaka na aoonie ensemo y’omwando oye, omoamate omwabo ore ang’e namoboorerie ensemo eyio konya aoonirie. ");
INSERT INTO guz_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Omonto oria otabwati omonto omwabo oranyare komobooreria eria aoonetie, korende ere omonyene aise konyora enibo eisaine kobooria omwando oye, ");
INSERT INTO guz_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","rirorio omonyene oyio aboorie omwando oye, na abare emiaka gochakera engaki eria ayoonetie, erio aakane omonto oria onde korwa ekero keria goika ase omwaka bw’omochengo. Erio airanerigwe omwando oye. ");
INSERT INTO guz_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Korende onye omonyene oria tabwati enibo eisaine akobooria omwando oye, nabo omwando oyio oratigare ase okoboko kw’omonto oria oyogorete goika Omwaka bw’Omochengo. Korende ase omwaka oria omwando oyio noiranigwe, na ere omonyene airane ase omwando oye. ");
INSERT INTO guz_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Onye omonto okoonia enyomba ere ime ase omochie ogiteire orwaki, nanyare koyebooria goika ase engaki y’omwaka oyomo korwa ekero ayeoonetie. Ase engaki y’omwaka oyomo omogima nabe ne ribaga ri’okoyebooria. ");
INSERT INTO guz_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Onye enyomba eria tekoboorigwa ase engaki eria y’omwaka omogima, rirorio enyomba eria nigo eraabe ey’omonto oria oyegorete, amo ney’ororeeria rwaye kogenderera botaambe. Enyomba eria tekoiranigwa ase omonyene ekero Omwaka bw’Omochengo oraike. ");
INSERT INTO guz_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Korende chinyomba chire ase ebichie bitagiteiri chindwaki, nachibarwe koba echi’emegondo y’ense eria; nabo chiranyare koboorigwa na koiranigwa ase abanyene ekero Omwaka bw’Omochengo oraike. ");
INSERT INTO guz_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Korende nonya naboigo, abanto b’egesaku kia Lawi mbare ne ribaga kobooria chinyomba chi’emechie ere emiando yabo engaki ende yonsi. ");
INSERT INTO guz_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Onye omonto Omolawi takobooria enyomba aoonetie ere ime ase omochie ore omwando oye, enyomba eyio neiranigwe ase Omwaka bw’Omochengo, ekiagera chinyomba chire ime ase emechie y’Abalawi nigo chire omwando obo ase egati y’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Korende ebitii bi’oborisia bietanaine emechie yabo tibikoonigwa, ekiagera ebio nebiabo kogenderera botaambe. ");
INSERT INTO guz_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Onye oyomino obeire omotaka ere takonyara gwetenenera ere omonyene, aye nomoe ebio aremeire, abeere bwoo buna omomenyi, gose buna omorikwa. ");
INSERT INTO guz_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Tobaisa kwenyorera ebitoki, gose okomentekana konde korwa asare, korende aye omoiroke Nyasae oo, na otige omonto oyio omino amenye bwoo. ");
INSERT INTO guz_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ekero oramoe chitaabu chia singo, tobaisa komosaba ebitoki korwa asare. ");
INSERT INTO guz_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Inche ninche Omonene, Nyasae oino, nabarusetie korwa ase ense ya Misiri, erinde mbae ense ya Kaanani, na inche imbe Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Onye oyomino omenyete bwoo obeire omotaka, ere eoonie omonyene ase ore, tobaisa komokoria emeremo buna omosomba. ");
INSERT INTO guz_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Nabeere ase ore buna omonto orikire, na buna omomenyi oo, abe okogokorera goika ekero Omwaka bw’Omochengo oraike. ");
INSERT INTO guz_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Erio arue bwoo, ere amo nabana baye, airane gochia ase eamate yaye na amenye ase omwando bwe chisokoro chiaye. ");
INSERT INTO guz_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Abwo nabaanto bagonkorera, ninche nabarusetie ase ense ya Misiri. Abwo tibakoonigwa buna abasomba. ");
INSERT INTO guz_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Tobaisa kobagaambera nobotiindi, korende aye omoiroke Nyasae oo. ");
INSERT INTO guz_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Onye koganetie abasomba, abamura gose abaiseke, nabo oranyaare kobagora korwa ase abanto b’ebisaku bibaetanaine inwe. ");
INSERT INTO guz_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nabo oranyaare kogora abana b’abamenyi baria bamenyete ase more, abana babo baria baiboreire ase ense yaino babe abaino. ");
INSERT INTO guz_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Monyaare gotiga abasomba abwo ase abana baino barache magega yaino, babe omwando obo bakobakorera kogenderera botambe. Abwo mbanyare koba abasomba baino. Korende abanto bamino Abaisraeli, timobagaambera nobotiindi. ");
INSERT INTO guz_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Onye omomenyi, gose omonto orikire omenyete bwoo, obeire omonda, na omonto omino bw’Abaisraeli obeire omotaka, eoonie ere omonyene ase omomenyi oria ore bwoo, gose ase monto onde bwensi bw’eamate y’abamenyi; ");
INSERT INTO guz_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","magega yaye omonto oyio nabo aranyare koboorigwa. Omonto omwabo nabo aramoboorie, ");
INSERT INTO guz_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","gose ise moke, gose omwana o ise moke, gose omoamate omwabo ore ang’e, gose ere omonyene karabe nenibo, nabo areboorie ere omonyene. ");
INSERT INTO guz_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ere amo noria omogorete baabare emiaka gochakera korwa ekero eoonetie goika ekero ki’Omwaka bw’Omochengo oraike, erio bakore rigori ri’okoboorigwa kwaye, koreng’ana n’emiaka eyio na koreng’ana neng’eria y’omonto orikire. ");
INSERT INTO guz_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Onye emiaka emenge etigarete goika Omwaka bw’Omochengo oike, goika airanie ang’e bionsi ebi aetwe ekero eoonetie. ");
INSERT INTO guz_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Korende onye emiaka etigarete nemeke, rirorio aakane ase emiaka eyio yoka ase okwebooria. ");
INSERT INTO guz_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Omonene oye amokorere buna akomokorera omonto orikire ase okomokorera emeremo omwaka ase omwaka. Aye goika origererie orore ng’a onde tari okomogaambera ase obotiindi. ");
INSERT INTO guz_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Onye takoboorigwa ase enchera eyemo y’echio, rirorio ere na abana baye batigwe babe abasibore ase Omwaka bw’Omochengo. ");
INSERT INTO guz_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Abaisraeli nabasomba baane, ee, barabwo nabasomba baane aba narusetie korwa ase ense ya Misiri. Inche ninche Omonene, Nyasae oino.” ");
INSERT INTO guz_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Naende Omonene agakwana, “Timobaisa kweroiseria emegwekano mochie gosasiima, gose gotenenia ase ense yaino emegwekano, gose chisiiro, gose rigena ribachire rire nemegwekano, ase okobisasiima, ekiagera inche ninche Omonene, Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Morende Chisabato chiane na mosike Obomenyo bwane Obochenu. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Komorabwatie aya nachiikire, na kobwata amachiiko aane na koyakora, ");
INSERT INTO guz_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","erio nimbatwerie embura ase engaki egwenerete, na ense inayaame endagera, na emete y’emegondo yaame amatunda. ");
INSERT INTO guz_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Okwama kwaino ’nakobe okonene, na mogenderere koora goika engaki y’ogotora amasabibu eike, na mogenderere gotora amasabibu goika engaki y’ogosimeka eike; na inwe namonyore endagera enyinge, naende momenye ase ense yaino ase obotoereru. ");
INSERT INTO guz_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Nindeete omorembe ase ense yaino, na inwe namoraare motari kwoboa monto onde bwensi. Nindusie ching’iti chi’orosana chirueo, ne chiseegi tichikobao. ");
INSERT INTO guz_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Namoserie ababisa baino, nababugwe ase amasio aino, baitwe nemioro. ");
INSERT INTO guz_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Abanto baino batano ’nababue abanto rigana erimo, na abanto baino rigana erimo nababue abanto chilifu ikomi; ababisa baino nababugwe ase amasio aino, baitwe nemioro. ");
INSERT INTO guz_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nimbasesenie moibore abana abange, momeenteke. Ninkore okobwatana kwane kw’ogotianania kogenderera koba nainwe. ");
INSERT INTO guz_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Namogenderere koria endagera enkoro ere enyinge ase ebiage, na ekiagera ere enyinge mono namoyerusie aroro, erinde monyore ribaga mobeeke enyia. ");
INSERT INTO guz_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nimenye ase egati yaino ase Obomenyo bwane Obochenu; tinkobatiga nonya ng’ake. ");
INSERT INTO guz_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nintaare amo nainwe; inche nimbe Nyasae oino, na inwe mobe abanto baane. ");
INSERT INTO guz_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Inche ninche Omonene, Nyasae oino, nabarusetie korwa ase ense ya Misiri, erinde timobaisa koba abasomba aroro; inche nasaretie chinguru chi’Abamisiri, nkabuna amakorogoto barabwo babeegete ase amareko aino, nkabatiga mokaruao mogwesigooria. ");
INSERT INTO guz_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Korende onye timokonyigwera gose kobwata amachiiko aya onsi, ");
INSERT INTO guz_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","na onye timokobwatia aya nachiikire, naende komoraange emeroberio yane echiikire, na timokora amachiiko aane onsi, korende mobe mogosaria okobwatana kwane kw’ogotianania, ");
INSERT INTO guz_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","rirorio nainche nimbakorere amang’ana aya: Nimbarentere omoondoko mobosokano, na oborwaire bw’okoria emebere, na obw’ogosaria amaiso, na obw’ogokoora obogima. ’Namobusure chindagera, korende timokonyora gento, ekiagera ababisa baino nabwo barachirie. ");
INSERT INTO guz_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nimbe mamincha yaino, na inwe namobugwe nababisa baino. Abanto baabageechete nabwo barabagambere, na inwe namobugwe nababisa baino. Mobe mogotama nonya monto onde tari okobabwatia. ");
INSERT INTO guz_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Amang’ana aya onsi karabe abanyorire, na inwe mogenderere kwanga konyingwera, erio nario ndabae egesusuro ara gatano na kabere ase engencho y’ebibe biaino. ");
INSERT INTO guz_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ninsarie chinguru chi’oboenenu, ninkore igoro ome pa, abe buna ekioma, embura tetwa, ne riroba ri’ense yaino rioome pa, ribe buna etai. ");
INSERT INTO guz_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Emeremo yaino emekong’u moraabe mogokora, nigo eraabe bosa, ekiagera ense yaino tekwama endagera, na emete tekwama amatunda. ");
INSERT INTO guz_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Onye naende mokogenderera koba mamincha yane na kwanga konyigwera, nindeete amaakwa amange ase more, ara gatano na kabere, buna ebibe biaino biragwenere. ");
INSERT INTO guz_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nimbatomere ching’iti chintindi chi’orosana chiite abana baino, ne chitugo chiaino, chibakeyie mobe abake goika chinchera chiaino chibe bosa. ");
INSERT INTO guz_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Komoraabe mwanyorire egesusuro ekio gionsi timong’iranera, korende mogenderere koba mamincha yane, ");
INSERT INTO guz_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","rirorio boigo nimbe mamincha yaino, erio inche omonyene imbae egesusuro ara gatano na kabere buna ebibe biaino biragwenere. ");
INSERT INTO guz_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nindeete esegi ase more, inyeruserie egesiomba, ekiagera mwasaririe okobwatana kwane kw’ogotianania. Komoraabe mogosangererekana ase emechie yaino korigia obotamero, nimbatomere amarwaire amabe abaite, goika mobekwe ase amaboko y’ababisa baino. ");
INSERT INTO guz_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ninkeyie chindagera chiaino chibe chinke; abakungu ikomi barugere eriko erimo, na barabwo babareengere endagera ensinini, na inwe namoyerie, korende timokoigota. ");
INSERT INTO guz_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Komoraabe mwanyorire emechando eye yonsi, na mogenderere kwanga konyigwera na koba mamincha yane, ");
INSERT INTO guz_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","erio nario naende ndabae egususuro ara gatano na kabere ase engencho y’ebibe biaino. ");
INSERT INTO guz_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Enchara nebe enene mono goika morie emebere y’abana baino, abamura na abaiseke. ");
INSERT INTO guz_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ninsarie obotunwa bwaino ase mogosasimera, nintagore ebisasiimero biaino ase mogosaambera amanukato, erio intugute emebere yaino ekwete igoro y’emegwekano yaino mogosasiima etari moyo. Inche nimbaange kegima. ");
INSERT INTO guz_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nintagore emechie yaino ebe amatombe, ninsarie kegima aase aino ase mogosasiimera; tingwanchera ebing’wanso biaino, ebio tibikoba rimisu rikongwenera. ");
INSERT INTO guz_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ninsarie ense yaino kegima goika ababisa baino bache komenya imeo bakumie buna esaregete. ");
INSERT INTO guz_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nimbaserebanie mogende komenya ase egati y’abanto b’ebisaku, nimbatunyanerie esegi, naende ninsarie ense yaino ebe bosa, na emechie ebe amatongo. ");
INSERT INTO guz_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ekero mokare ase ense y’ababisa baino, na ense yaino negendererete koba amatongo, ero negokere engaki y’ogotimoka okwo inwe mwayetaangete. ");
INSERT INTO guz_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ekero ense eria egendererete koba amatongo netimoke ogotimoka okwo motayeete ekero mwamenyeteo. ");
INSERT INTO guz_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Nimbatige inwe, abwo moratigare ase ense y’ababisa baino mobe nobwoba ase chinkoro chiaino ime, goika eriogi rie rito ri’omote rikonyegerigwa nembeo naribagose motame; ee, namotame buna omonto ogotama kagoserigwa korwa ase esegi, namogwe nonya onde tari kobabwatia. ");
INSERT INTO guz_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Namogochane buna abanto bagotama korwa ase esegi, nonya monto onde tari kobabwatia. Timokonyara koba ne chinguru chi’okorwania ababisa baino. ");
INSERT INTO guz_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Namokwe mosirere ase ense y’ababisa baino, na ense yabo nebamere kegima. ");
INSERT INTO guz_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Baria bare abake ase more baratigare bare moyo agwo ase ense y’ababisa baino nabasirere aroro ase engencho y’ebibe biabo, naboigo nase engencho y’ebibe bie chisokoro chiabo nabasire buna chisokoro chiabo chiasirete. ");
INSERT INTO guz_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Erio abwo baratigare goika baorokie ebibe biabo, naende baorokie ebie chisokoro chiabo, abwo batabeete abegenwa ase ’nde, na ekiagera baangete konyigwera, ");
INSERT INTO guz_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","bakagera nkaba nendamwamu ase bare goika nkabaira ase ense y’ababisa babo. Onye chinkoro chiabo echio chire chinkong’u chigwekeyia, na barabwo banche konyora egesusuro ki’ebibe biabo, ");
INSERT INTO guz_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","erio nario ndainyore okobwatana kwane k’wogotianania okwo nakorete na Yakobo, na Isaka, na Aburaamu, naende ning’inyore ense eria nabaete. ");
INSERT INTO guz_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ense eria netigwe nabarabwo, erinde egokere engaki y’ogotimoka kwaye ekero etari nabaanto. Abanto abwo nabanyore egesusuro, ekiagera bangete kobwata amachiiko aane, na bakaanga kobwatia emeroberio yane nachiigete. ");
INSERT INTO guz_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Korende nonya nabo ase engaki eyio ekero bagendererete komenya ase ense eria y’ababisa babo, inche tinkobaanga gose kobatiga, na tinkobaseria. Tingotiga okobwatana kwane kw’ogotianania nakorete nabarabwo, ekiagera ninche Omonene, Nyasae obo. ");
INSERT INTO guz_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ase engencho yabo ning’inyore okobwatana kw’ogotianania nakorete ne chisokoro chiabo, echio narusetie korwa ase ense ya Misiri ase obosio bw’abaanto b’ebisaku, erinde imbe Nyasae obo. Inche ninche Omonene.” ");
INSERT INTO guz_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Eyio nero emeroberio echiikire amo namachiik’Omonene aruete goetera ase omonwa o Musa, agwo ase egetunwa gia Sinai, ebe ase egati yaye na Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Omonene agakwana na Musa akamoteebia, ");
INSERT INTO guz_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“oteebie Abaisraeli: Onye eira yarietwe ng’a omonto aruegwe ase ogokorera Omonene, na omonto oyio karaboorigwe arueo, goika akorerwe rigori buna iga: ");
INSERT INTO guz_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Rigori ri’omonto omosacha bw’emiaka emerongo ebere goika emerongo etano nomo, nigo riraabe chisekeli chi’echifeta emerongo etano, ase ekerengo gi’esekeli egokorerwa ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Onye n’omokuungu nigo riraabe chisekeli emerongo etato. ");
INSERT INTO guz_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Onye nomonto omoke bw’emiaka etano goika emerongo ebere, rigori riaye nigo riraabe, ase omomura chisekeli emerongo ebere, na ase omoiseke chisekeli ikomi. ");
INSERT INTO guz_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Onye nomwana bw’omotienyi oyomo goika emiaka etano, rigori riaye nigo riraabe, ase omomura chisekeli isano, na ase omoiseke chisekeli isato. ");
INSERT INTO guz_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Onye nomonto omogotu bw’emiaka emerongo etano nomo na goetania, rigori riaye nigo riraabe, ase omogaka chisekeli ikomi na isano, na ase omong’ina chisekeli ikomi. ");
INSERT INTO guz_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Onye omonto oria orieretwe eira nigo are omotaka mono otanyare goakana rigori riria riabeekirwe, rirorio omonto oria nigo araarentwe ase Omokuani, nere amokorere rigori koreng’ana nokonyara kw’omonto oyio oriete eira. ");
INSERT INTO guz_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Onye eira y’omonto oria ariete niigoro y’eng’iti yancheire nainche Omonene ebe ekeng’wanso, ekeegwa buna ekio ase ’nde ’nakebe egechenu. ");
INSERT INTO guz_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Omonto oria takoba ne ribaga koonchoreria eng’iti eria arente eng’iti eng’ao, takoonchoreria eng’iti engiya arente eyere embe, gose eng’iti embe arente eyere engiya. Onye omonto okoonchoreria ching’iti, erio chionsi ibere ’nachibe chiatananirwe ase ’nde. ");
INSERT INTO guz_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Keraabe eng’iti etachenegeti ebe ekeng’wanso ase Omonene, omonto oria ayerente ase Omokuani, ");
INSERT INTO guz_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","na ere akore rigori ri’eng’iti eria koreng’ana buna ere engiya gose embe. Rigori Omokuani arakore, nario erio riraabe. ");
INSERT INTO guz_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Korende onye omonto omonyene oganetie kobooria eng’iti eria, rirorio aakane rigori riria ribekire, n’ameente eyemo ya isano ase rigori erio. ");
INSERT INTO guz_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Ekero omonto agwaatanana enyomba yaye ebe enchenu ase Omonene, Omokuani akore rigori ri’enyomba eria, buna ere engiya gose embe; buna Omokuani arakore rigori ri’enyomba eria, nario erio riraabe. ");
INSERT INTO guz_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Onye omonto oria bwatananete enyomba eria aganetie koyebooria ebe eyaaye naende, rirorio aakane rigori riria ribekire, na ameente eyemo ya isano ase rigori erio; ase igo etigare ebe eyaaye. ");
INSERT INTO guz_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Onye omonto ogwaatanana ensemo y’oboremo bw’omwando oye, erio aye oyekorere rigori koreng’ana nekerengo gie chimbusuro chikobusurwa aroro, chimbusuro chi’esairi ebitonga ikomi chiakanwe chisekeli chi’echifeta emerongo etano. ");
INSERT INTO guz_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Omonto karaatanane oboremo bwaye korwa ase engaki y’Omwaka bw’Omochengo, rigori erio nario riraabe buna aye kwarikora. ");
INSERT INTO guz_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Korende omonto karaatanane omogondo oye magega y’Omwaka bw’Omochengo, erio Omokuani akore rigori rie chitaabu koreng’ana n’emiaka yatigaire goika Omwaka onde bw’Omochengo, na igo nakeyie rigori. ");
INSERT INTO guz_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Omonto oria oraatanane oboremo bwaye ase ’nde, onye oganetie kobobooria, aakane rigori riria ribekire, naende ameente ensemo ya isano ase rigori erio, na oboremo botigare koba obwaye. ");
INSERT INTO guz_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Onye omonto oria taganeti kobooria oboremo boria, korende aboonerie omonto omoao, rirorio oboremo obwo tibokoboorigwa nonya ’ng’ake. ");
INSERT INTO guz_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Korende ekero oboremo boria bogochia gotigwa ase engaki y’Omwaka bw’Omochengo, bobe obwatananirwe ase Omonene. Oboremo nigo boraabe obw’Omokuani. ");
INSERT INTO guz_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Omonto karaatanane ase Omonene oboremo agorete, obwo botari ensemo y’omwando oye, ");
INSERT INTO guz_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Omokuani akore rigori ri’oboremo boria koreng’ana n’emiaka etigarete goika Omwaka bw’Omochengo. Ase rituko riria kegima, omonto oria aakane rigori riria ribekire, ne chitaabu echi chibe chiatananirwe ase Omonene. ");
INSERT INTO guz_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ase Omwaka oria bw’Omochengo oboremo boria boiranerigwe omonyene oria oboonetie, oyio oboremo bwareenge ensemo y’omwando oye. ");
INSERT INTO guz_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Kera rigori rikobekwa nigo riraareng’anigwe nekerengo gi’esekeli eyio egokorerwa ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Korende chitugo chintangi n’echia Omenene Nyasae, ase igo onde tachiaatanana, keraabe eng’ombe gose eng’ondi, gose embori; eng’iti entangi nigo chire echia Omonene. ");
INSERT INTO guz_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Korende onye eng’iti eria entangi techenegeti, rirorio omonto oria ayeboorie koreng’ana ne rigori riraabekwe, naende ameente ensemo ya isano ase rigori erio, gose onye tekoboorigwa rirorio eoonigwe ase rigori erabeekerwe. ");
INSERT INTO guz_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Korende gento kende gionsi omonto aatananire ase Omonene ase enchera gete kebe ekiaye kegima, keraabe omonto, gose eng’iti gose oboremo bw’omwando oye, egento ekio tikebaisa koonigwa gose koboorigwa. Kera egento giaatananirwe nigo kere egechenu mono ase Omonene. ");
INSERT INTO guz_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Omonto onde bwensi bwatananirwe ase ogosirigwa takonyara koboorigwa; omonto oyio goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Ensemo ya ikomi y’okwama kwa mogondo, keraabe endagera gose amatunda, ebio nebia Omonene, ebio nebichenu ase Omonene. ");
INSERT INTO guz_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Onye omonto oganetie kobooria ensemo yaye ya ikomi, nigo arameente eyemo ya isano ase rigori riaye. ");
INSERT INTO guz_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Boigo eyemo ya ikomi y’amaicho e chiombe, gose ching’ondi, gose chimbori, engencho yaye kera eng’iti ya ikomi ye ching’iti chigoeta inse ase enyimbo y’omorisia, nebe enchenu ase Omonene. ");
INSERT INTO guz_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Omonyene eng’iti eria takoriga — rigereria, onye ere engiya gose embe, na takoyeonchoreria. Onye omonto okoonchoreria ching’iti echio, erio chionsi ibere nchibe chinchenu, tichikoboorigwa.” ");
INSERT INTO guz_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Aya naro amachiiko y’Omonene achiigete Abaisraeli goetera ase Musa agwo ase egetunwa gia Sinai.");
INSERT INTO guz_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ase rituko rie ritang’ani ri’omotienyi o kabere bw’omwaka o kabere magega Abaisraeli kobarure ase ense ya Misiri, Omonene agakwana na Musa ime y’Eema y’Omosangererekano, agwo ase erooro ya Sinai, okomoteebia, ");
INSERT INTO guz_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Kora omobaro bw’omoganda bwonsi bw’Abaisraeli, eamate ase eamate, na enyomba ase enyomba. Oriike amarieta y’ abanto abasacha bonsi, oyomo ase oyomo. ");
INSERT INTO guz_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Aye amo na Aroni mobare abanto abakoorire emiaka emerongo ebere na goetania, baria baranyare korwana esegi, mobaroberie ase esegi, ekeombe ase ekeombe. ");
INSERT INTO guz_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Naende mochore korwa ase kera egesaku omonto oyomo ore omoteneneri obo. Barabwo babe amo nainwe ase okobakonya. ");
INSERT INTO guz_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Amarieta y’ abanto abwo naro aya: Korwa ase egesaku kia Rubeni, Elisuri, mosinto o Sedeuri. ");
INSERT INTO guz_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Korwa ase egesaku gia Simioni, Selumieli, mosinto o Surisadai. ");
INSERT INTO guz_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Korwa ase egesaku kia Yuda, Nahasoni, mosinto bw’Aminadabu. ");
INSERT INTO guz_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Korwa ase egesaku gia Isakaru, Netaneli, mosinto o Suari. ");
INSERT INTO guz_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Korwa ase egesaku gia Sabuloni, Eliabu, mosinto o Heloni. ");
INSERT INTO guz_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Korwa ase basinto ba Yusufu: ase egesaku gi’Efraimu, Elisama, mosinto bw’Amihudi, na ase egesaku kia Manase, Gamalieli, mosinto o Pedasuri. ");
INSERT INTO guz_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Korwa ase egesaku kia Benjamini, Abidani, mosinto o Gidioni. ");
INSERT INTO guz_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Korwa ase egesaku gia Dani, Ahieseri, mosinto bw’Amisadai. ");
INSERT INTO guz_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Korwa ase egesaku gi’Aseri, Pagieli, mosinto bw’Okirani. ");
INSERT INTO guz_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Korwa ase egesaku kia Gadi, Eliasafu, mosinto o Deueli. ");
INSERT INTO guz_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Korwa ase egesaku kia Nafutali, Ahira, mosinto o Enani.” ");
INSERT INTO guz_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Abaaanto aba nabwo barenge abateneneri ase ebisaku ebio biabo, naende abatang’ani be chiamate chi’Abaisraeli, bachoretwe korwa ase omoganda bwonsi. ");
INSERT INTO guz_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa na Aroni bakaira abanto abwo baatoretwe ase amarieta abo, ");
INSERT INTO guz_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","na ase rituko rie ritang’ani ri’omotienyi o kabere bagasangereria omoganda bwonsi bw’ abanto amo. Bakariika amarieta y’ abanto abwo konya bakoorire emiaka emerongo ebere na goetania, eamate ase eamate, na enyomba ase enyomba, na omonto ase omonto. ");
INSERT INTO guz_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Musa akabara abanto abwo na kobarika, agwo ase erooro ya Sinai, buna Omonene konya amochiikire. ");
INSERT INTO guz_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Abanto b’ororeria rwa Rubeni, omotangi o Israeli, bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abaaanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","nigo barenge chilifu emerongo ene na isano nemo, n’amagana atano (46,500). ");
INSERT INTO guz_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Abanto b’ororeria rwa Simioni bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","nigo barenge chilifu emerongo etano na kianda, n’amagana atato (59,300). ");
INSERT INTO guz_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Abanto b’ororeria rwa Gadi bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","nigo barenge chilifu emerongo ene naisano, n’amagana atano nomo, namerongo etano (45,650). ");
INSERT INTO guz_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Abanto b’ororeria rwa Yuda bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","nigo barenge chilifu emerongo etano nebere na inye, n’amagana atano nomo (74,600). ");
INSERT INTO guz_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Abanto b’ororeria rwa Isakaru bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","nigo barenge chilifu emerongo etano nainye, n’amagana ane (54,400). ");
INSERT INTO guz_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Abanto b’ororeria rwa Sabuloni bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","nigo barenge chilifu emerongo etano na isano ibere, n’amagana ane (57,400). ");
INSERT INTO guz_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Abanto b’ororeria rwa Yusufu, narwo orw’Efraimu, bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","nigo barenge chilifu emerongo ene, n’amagana atano (40,500). ");
INSERT INTO guz_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Abanto b’ororeria rwa Manase bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","nigo barenge chilifu emerongo etato naibere, n’amagana abere (32,200). ");
INSERT INTO guz_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Abanto b’ororeria rwa Benjamini bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","nigo barenge chilifu emerongo etato naisano, n’amagana ane (35,400). ");
INSERT INTO guz_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Abanto b’ororeria rwa Dani bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","nigo barenge chilifu emerongo etano nomo naibere, n’amagana atano n’abere (62,700). ");
INSERT INTO guz_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Abanto b’ororeria rw’Aseri bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","nigo barenge chilifu emerongo ene nomo, n’amagana atano (41,500). ");
INSERT INTO guz_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Abanto b’ororeria rwa Nafutali bakariikwa, omonto ase omonto, ase chiamate chiabo ne chinyomba chiabo. Abanto bonsi abasacha, aba konya bakoorire emiaka emerongo ebere na goetania, abwo baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","nigo barenge chilifu emerongo etano naisato, n’amagana ane (53,400). ");
INSERT INTO guz_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Aba nabwo barigetwe na Musa, na Aroni, na abatang’ani b’Abaisraeli ikomi na babere, abatenenerete kera oyomo egesaku kiaye. ");
INSERT INTO guz_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Abaisraeli bonsi abarigetwe, enyomba ase enyomba, baria konya bakoorire emiaka emerongo ebere na goetania, naende baare konyara korwana esegi, ");
INSERT INTO guz_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","nigo barenge chilifu amagana atano nomo na isato, n’amagana atano, namerongo etano (603,550). ");
INSERT INTO guz_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Korende abanto b’ororeria rwa Lawi, barabwo tibaabaretwe amo n’abanto abwo bande, ");
INSERT INTO guz_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ekiagera Omonene nigo atebeetie Musa, ");
INSERT INTO guz_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Abanto b’egesaku kia Lawi tobaabara amo n’Abaisraeli bande. ");
INSERT INTO guz_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Obeeke Abalawi babe bakorenda Obomenyo Obochenu obwo bore noborori, naende babe bakorenda ebinto bire ase Obomenyo boria ime, na ebikorero biaye. ’Nababe bakobobogoria amo n’ebinto biaye bionsi, na gokora emeremo imeo. Barabwo nigo baratenenie chiema chiabo chi’okomenya chietanane Obomenyo obwo. ");
INSERT INTO guz_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ekero Obomenyo obwo boraabe bokong’anyigwa, Abalawi nabwo barabosimore, na ekero boraabe bogotenenigwa naende, nabwo barabotenenie aase agwo. Omonto onde bwensi otachikiri aise goika ang’e n’Obomenyo obwo goika aitwe akwe. ");
INSERT INTO guz_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Abaisraeli bande nabatenenie chiema chiabo, kera egesaku ase egetwori kiaye, na kera omonto abeere inse y’ebendera yaye, ase ekeombe kiaye. ");
INSERT INTO guz_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Korende Abalawi nigo baratenenie chiema chiabo chietanane Obomenyo obwo bore noborori, na komenyao, erinde endamwamu yane etangwe tebaisa kogwera omoganda bwonsi bw’Abaisraeli. Abalawi barende Obomenyo obwo bore noborori.” ");
INSERT INTO guz_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Abaisraeli bagakora onsi buna Omonene abachiigete goetera ase Musa. ");
INSERT INTO guz_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ekero Abaisraeli baratoore, kera omonto abe inse y’ebendera y’ekeombe kiaye, na inse y’ekemanyererio ki’eamate yaye; batoore baetanane Eema y’Omosangererekano, ne chiema chi’ abanto chirigererie Eema eria. ");
INSERT INTO guz_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Abanto abaratoore ensemo ya moocha n’Abayuda, inse y’ebendera y’ekeombe kiabo. Nahasoni, mosinto bw’Aminadabu, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","na omoganda oye nigo ore n’abanto chilifu emerongo etano ebere nainye, n’amagana atano nomo (74,600). ");
INSERT INTO guz_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Abaratoore ang’e nabarabwo n’Abaisakaru. Netaneli, mosinto o Suari, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","na omoganda oye nigo ore n’abanto chilifu emerongo etano nainye, n’amagana ane (54,400). ");
INSERT INTO guz_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Naende abaratoore ensemo yabo n’Abasabuloni. Eliabu, mosinto o Heloni, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","na omoganda oye nigo ore n’abanto chilifu emerongo etano na isanaibere, n’amagana ane (57,400). ");
INSERT INTO guz_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Abanto bonsi bariikire, abare b’egetwori ki’Abayuda, ase ebiombe biabo, nigo bare chilifu rigana erimo namerongo etano netato na isanonemo, n’amagana ane (186,400). Aba nabwo barabe bagotang’ana komanora kogeenda orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“Abanto abaratoore ensemo ya Irianyi n’Abareubeni, inse y’ebendera y’ekeombe kiabo. Elisuri, mosinto o Sedeuri, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","na omoganda oye nigo ore n’abanto chilifu emerongo ene na isanonemo, n’amagana atano (46,500). ");
INSERT INTO guz_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Abaratoore ang’e nabarabwo n’Abasimeoni. Selumieli, mosinto o Surisadai, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","na omogaanda oye nigo ore n’abanto chilifu emerongo etano nakianda, n’amagana atato (59,300). ");
INSERT INTO guz_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Naende abaratoore ensemo yabo n’Abagadi. Eliasafu, mosinto o Reueli, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","na omoganda oye nigo ore n’abanto chilifu emerongo ene naisano, n’amagana atano nomo, na merongo etano (45,650). ");
INSERT INTO guz_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Abanto bonsi bariikire, abare b’egetwori kia Rubeni, ase ebiombe biabo, nigo bare chilifu rigana erimo namerongo etano n’eyemo, n’amagana ane, namerongo etano (151,450). Aba nabwo barabe aba kabere komanora kogeenda orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Ekero abanto barabe bakogeenda orogeendo, Eema y’Omosangererekano n’ebe ekobogorigwa n’Abalawi, na barabwo babe gati‐gati y’ebiombe binde. Ase omooroberio oyo abanto ’’mbabe bagotoora, naboigo barabe ko bakogeenda orogeendo. Kera omonto abe ensemo yaye inse y’ebendera yaye. ");
INSERT INTO guz_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Abanto abaratoore ensemo ya bosongo n’Abaefraimu, inse y’ebendera y’ekeombe kiabo. Elisama, mosinto bw’Amihudi, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","na omoganda oye nigo ore n’abanto chilifu emerongo ene, n’amagana atano (40,500). ");
INSERT INTO guz_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Abaratoore ang’e nabarabwo n’Abamanase. Gamalieli, mosinto o Pedasuri, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","na omogaanda oye nigo ore n’abanto chilifu emerongo etato naibere, n’amagana abere (32,200). ");
INSERT INTO guz_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Naende abaratoore ensemo yabo n’Ababenjamini. Abidani, mosinto o Gidioni, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","na omoganda oye nigo ore n’abanto chilifu emerongo etato na isano, n’amagana ane (35,400). ");
INSERT INTO guz_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Abanto bonsi bariikire, abare b’egetwori gi’Efraimu, ase ebiombe biabo, nigo bare chilifu rigana erimo na isano isato, ne’rigana erimo (108,100). Aba nabwo barabe aba gatato komanora kogeenda orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Abanto abaratoore ensemo ya sugusu n’Abadani, inse y’ebendera y’ekeombe kiabo. Ahieseri, mosinto bw’Amisadai, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","na omoganda oye nigo ore n’abanto chilifu emerongo etano nomo naibere, n’amagana atano abere (62,700). ");
INSERT INTO guz_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Abaratoore ang’e nabarabwo n’Abaaseri. Pagieli, mosinto bw’okirani, nere oraabe omotang’ani abo, ");
INSERT INTO guz_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","na omoganda oye nigo ore n’abanto chilifu emerongo ene neyemo, na magana atano (41,500). ");
INSERT INTO guz_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Naende abaratoore ensemo yabo n’Abanafutali. Ahira, mosinto o Enani, nere oraabe omotang’ani obo, ");
INSERT INTO guz_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","na omogaanda oye nigo ore n’abanto chilifu emerongo etano na isato, na magana ane (53,400). ");
INSERT INTO guz_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Abanto bonsi bariikire, abare b’egetwori gia Dani, ase ebiombe biabo, nigo bare chilifu rigana erimo na merongo etano na isano ibere, na magana atano nomo (157,600). Aba nabwo barabe abamagega kegima komanora kogeenda orogeendo, babe inse y’ebendera y’ekeombe kiabo.” ");
INSERT INTO guz_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Aba nabwo Abaisraeli barigetwe korwa ase kera eamate, ekeombe ase ekeombe. Omobaro obo nigo ore chilifu amagana atano nomo na isato, namagana atano, namerongo etano (603,550). ");
INSERT INTO guz_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Abalawi barabwo tibaabaretwe amo n’Abaisraeli bande, ekiagera nabo Omonene konya achiikire Musa. ");
INSERT INTO guz_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Abaisraeli bagakora onsi buna Omonene konya achiikire Musa. Bagatoora inse ye chibendera chiabo, naende kobakogeenda orogeendo, bakageenda kera oyomo amo neamate yaye, n’enyomba yaye. ");
INSERT INTO guz_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Aba nabwo abanto b’ororeria rwa Aroni, na orwa Musa, ase engaki eri’Omonene akwanete na Musa, agwo ase egetunwa gia Sinai. ");
INSERT INTO guz_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aya naro amarieta y’abamura ba Aroni: Nadabu, omomura oye omotangi, na Abihu, na Eleazari, na Itamari. ");
INSERT INTO guz_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Abamura aba ba Aroni nabwo baagetwe amaguta na gwatananwa ase emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Korende Nadabu na Abihu, barabwo bagakwera ase obosio bw’Omonene, ekero bamoruerete ase omorero otachenegeti, agwo ase erooro ya Sinai. Barabwo tibabwate abana. Ase ayio Eleazari na Itamari bakagenderera gokora emeremo y’obokuani ase amatuko onsi Aroni ise arenge moyo. ");
INSERT INTO guz_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Renta abanto b’egesaku kia Lawi, erinde obabeeke bamokorere Aroni, Omokuani. ");
INSERT INTO guz_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Abalawi abwo ’mbakorere Aroni emeremo, boigo bakorere omoganda bwonsi agwo ase Eema y’Omosangererekano, ekero bagokora emeremo ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Barabwo ’mbatenenere ebinto bionsi bire ase Eema y’Omosangererekano. Ase ogokora emeremo yonsi ase Obomenyo Obochenu nigo barabe bagokorera Abaisraeli bonsi. ");
INSERT INTO guz_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Aroni amo n’abamura baye baegwe Abalawi buna ekeegwa korwa ase Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Obeeke Aroni amo n’abamura baye bakore emeremo y’obokuani, korende monto onde bwensi omoao aise gwesoyia ase emeremo eyio nigo araitwe akwe.” ");
INSERT INTO guz_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Naende Omonene Nyasae agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Rora, inche omonyene neatananerete Abalawi korwa ase Abaisraeli ribaga ri’abana abatangi. Abalawi mbabe abaane, ");
INSERT INTO guz_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ekiagera abana abatangi bonsi nabaane. Ase rituko riria naitete abana abatangi, ne ching’iti chintangi, agwo Misiri, nigo neatananerete abana abatangi bonsi b’Abaisraeli babe abaane, ne ching’iti chintangi boigo. Inche ninche Omonene.” ");
INSERT INTO guz_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ekero Musa arenge agwo ase erooro ya Sinai, Omonene agakwana nere, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bara Abalawi enyomba ase enyomba, na eamate ase eamate. Oriike kera omonto omosacha, naboigo kera omwana omomura okoorire omotienyi oyomo na goetania.” ");
INSERT INTO guz_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Erio Musa akabaabara, buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lawi nigo abwate abamura batato: Gerisoni, na Kohati, na Merari. ");
INSERT INTO guz_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Abamura ba Gerisoni nabwo Libini na Simei. ");
INSERT INTO guz_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Abana ba Kohati nabwo aba: Amuramu, na Isari, na Heburoni, na Usieli. ");
INSERT INTO guz_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Abana ba Merari nabwo Mali na Musi. Abanto abwo nigo barenge chisokoro chie chiamate chi’Abalawi, kera oyomo ase eamate yaye. ");
INSERT INTO guz_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Abanto b’eamate ya Libini na eya Simei, abwo nabwo barenge ab’ororeria rwa Gerisoni. ");
INSERT INTO guz_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Abanto abasacha, aba konya bakoorire omotienyi oyomo na goetania, nigo barenge chilifu isano ibere, na magana atano (7,500). ");
INSERT INTO guz_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Abanto be chiamate chi’Abagerisoni nigo barabe bagotoora ensemo ya bosongo magega y’Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasafu, mosinto o Laeli, nere oraabe omotang’ani bwe chiamate chi’Abagerisoni. ");
INSERT INTO guz_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ase Eema y’Omosangererekano Abagerisoni nabwo barabe bakorenda Obomenyo obonyene, na ebimumeko biaye, na ebitambaa bi’egesoero ki’Eema eria. ");
INSERT INTO guz_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Naende babe bakorenda ebitambaa bigosungwa ase ogotuba eraaro, na ebitambaa bi’egesoero ki’eraaro eetanaine Obomenyo Obochenu, na egesasiimero, ne chingori chiabo. Bakore emeremo ende yonsi eganeirie gokorwa ase ebinto ebio. ");
INSERT INTO guz_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Abanto b’eamate y’Amuramu, na eya Isari, na eya Heburoni, na eya Usieli; abwo nabwo barenge abanto b’ororeria rwa Kohati. ");
INSERT INTO guz_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Abanto abasacha, aba konya bakoorire omotienyi oyomo na goetania, nigo barenge chilifu isano isato, na magana atano nomo (8,600). Abanto aba nabwo barabe bakorenda ebinto bire ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Barabwo nigo barabe bagotoora ensemo ya Irianyi y’Obomenyo boria. ");
INSERT INTO guz_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Elisafani, mosinto bwa Usieli, nere oraabe omotang’ani bw’egesaku ki’Abakohati. ");
INSERT INTO guz_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Barabwo nabwo barabe bakorenda ebinto ebi: Esanduki eria ere ne chibao chiriikire okobwatana kwogotianania, n’emesa, n’ekebeekerero gie chitaaya, na ebisasimero, na ebikorero bionsi bi’Obomenyo boria, biria abakuani bagokorera emeremo, amo negetambaa getubete Aase Aachenu Mono. Bakore emeremo ende yonsi eganeirie gokorwa ase ebinto ebio. ");
INSERT INTO guz_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazari, omomura o Aroni Omokuani, nere oraabe omonene igoro ase abaraai b’Abalawi, naende omoteneneri bw’abaanto barabe bagokora emeremo ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Abanto b’eamate ya Mali, na eya Musi abwo nabwo barenge abanto b’ororeria rwa Merari. ");
INSERT INTO guz_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Abanto abasacha, aba konya bakoorire omotienyi oyomo na goetania, nigo barenge chilifu isano nemo, na magana abere (6,200). ");
INSERT INTO guz_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Barabwo nigo barabe bagotoora ensemo ya sugusu y’Obomenyo boria. Surieli, mosinto bw’Abihaili, nere oraabe omotang’ani bw’ abanto b’egesaku kia Merari. ");
INSERT INTO guz_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Abamerari nabwo barabe bakorenda ebinto ebi: chibao chi’Obomenyo Obochenu, n’emeriibo, ne chisiiro, ne chinterekerero, amo nebikorero biabo bionsi. Bakore emeremo ende yonsi eganeirie gokorwa ase ebinto ebio. ");
INSERT INTO guz_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Nabwo naende babegetwe korenda chisiiro chi’eraaro amo ne chinterekerero chiabo na ebirochi, ne chingori chiabo. ");
INSERT INTO guz_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa na Aroni amo nabamura baye mbabe bagotoora kororia Obomenyo Obochenu ensemo ya moocha, bosio bw’Eema y’Omosangererekano. Barabwo nigo barabe bagokora emeremo eganeirie gokorwa ime y’Aase Aachenu, na gotenenera emeremo ende yonsi erakorerwe Abaisraeli. Omonto onde bwensi otatananiri gokora emeremo eyio, korende aike ang’e ase Obomenyo Obochenu, nigo araitwe akwe. ");
INSERT INTO guz_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Abanto abasacha b’Abalawi, aba konya bakoorire omotienyi oyomo na goetania, abwo Musa na Aroni bariigete, eamate ase eamate, buna Omonene abachiigete, nigo barenge chilifu emerongo ebere na ibere (22,000). ");
INSERT INTO guz_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Omonene agakwana na Musa, akamoteebia, “Bara abanto abasacha abatangi, n’abana abamura abatangi bakoorire omotienyi oyomo na goetania, obariike. ");
INSERT INTO guz_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Inche ninche Omonene. Ase ayio Abalawi ’mbabe abaane. Obanyatananere ribaga ri’abatangi bonsi b’Abaisraeli. Naboigo ne ribaga rie ching’iti chintangi chi’Abaisraeli onyatananere ching’iti chi’Abalawi.” ");
INSERT INTO guz_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Musa akabara na korika abatangi bonsi b’Abaisraeli, ne ching’iti chintangi, buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Abanto bonsi abasacha abatangi n’abana abamura abatangi konya bakoorire omotienyi oyomo na goetania nigo barenge chilifu emerongo ebere na ibere, na amagana abere, na merongo etano ebere, na batato (22,273). ");
INSERT INTO guz_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Naende Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ira Abalawi babe abaane ribaga ri’ abanto abasacha abatangi b’Abaisraeli, naende oire ching’iti chi’Abalawi chibe echiane ribaga rie ching’iti chintangi chi’Abaisraeli. Inche ninche Omonene. ");
INSERT INTO guz_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Abanto abasacha abatangi b’Abaisraeli nabange bare, mbaetanetie Abalawi ase amagana abere, na emerongo etano ebere na batato (273). ");
INSERT INTO guz_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ase ayio oboorie kera oyomo obo ne chitaabu chie chisekeli isano, koreng’ana ne chisekeli chigokorerwa ase Obomenyo Obochenu. (Esekeli eyemo nechigera emerongo ebere). ");
INSERT INTO guz_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Omoe Aroni amo nabamura baye chitaabu echio chi’okobooria abatangi abwo baetanetie Abalawi.” ");
INSERT INTO guz_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ase ayio Musa agasangereria chitaabu chiria chiabooretie abanto baria barenge abange goetania baria babooretigwe ekiagera Abalawi babete ribaga riabo. ");
INSERT INTO guz_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ase engencho y’ abanto baria abatangi b’Abaisraeli, akanyora chitaabu chie chisekeli elifu eyemo, na amagana atato, na merongo etano nomo, na isano (1,365), koreng’ana ne chisekeli chigokorerwa ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa akaa Aroni amo nabamura baye chitaabu chiria chi’okobooria, buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Kora omobaro bw’Abalawi baria bare be chiamate chia Kohati, eamate ase eamate, na enyomba ase enyomba, ");
INSERT INTO guz_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","abwo bare egati y’emiaka emerongo etato na merongo etano, abwo bonsi baranyare gokora emeremo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Emeremo Abakohati barakore agwo ase Eema eria nokorenda ebinto bire ebichenu mono. ");
INSERT INTO guz_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“Ekero abanto barabe bakomanora na koimoka korwa ase ebitwori, Aroni amo n’abamura baye babe bagosoa ase Eema ime, basungore egetambaa keria getubete Esanduki eria ere ne chibao chiriikire oborori, na gotuba Esanduki eria negetambaa ekio. ");
INSERT INTO guz_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Naende batube egetambaa ekio ne risankwa ri’eng’iti ya rooche, na igoro ase risankwa erio baare egetambaa kere buru kegima. Erio basoyie emiaro y’okobogoreria Esanduki eria. ");
INSERT INTO guz_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Igoro ase emesa yemegati ekoruegwa ase Omonene baare egetambaa kere buru kegima, naende babeekeo chinteru, ne chisani ase ubani, amo n’ebitaabo n’ebitoono, ase ebio bagochia koumora okoruegwa kw’ebinyugwa. Emegati ekoruegwa botambe ase Omonene ebekweo boigo. ");
INSERT INTO guz_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Baare egetambaa ekebariri igoro ase ebinto ebio, bagetube ne risankwa ri’eng’iti ya rooche, na basoyie emiaro y’okobogoreria emesa eria. ");
INSERT INTO guz_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Erio baimokie egetambaa kere buru kegima, batube ekebeekerero gie chitaaya amo ne chitaaya chiaye, na ebinachi, ne chindogio chiaye, ne chichuba chire n’amaguta y’amazeituni, ebinto bigokorerwa ase emeremo y’obokuani. ");
INSERT INTO guz_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Nababeeke ekebeekerero ekio amo nebikorero biaye ase omobuko bwe risankwa ri’eng’iti ya rooche, na kobibeka ase ekebogorerio. ");
INSERT INTO guz_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Naende baare egetambaa kere buru kegima igoro ase egesasiimero keroisirie korwa ase etaabu, na bagetube ne risankwa ri’eng’iti ya rooche; erio basoyie emiaro y’okobogoreria egesasiimero keria. ");
INSERT INTO guz_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Nabaimokie ebinto bionsi bigokorerwa ase emeremo agwo ase Obomenyo Obochenu. Babibeke ime ase egetambaa kere buru kegima; erio babitube ne risankwa ri’eng’iti ya rooche na kobibeka ase ekebogorerio. ");
INSERT INTO guz_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Barabwo babuuche ribu, naende batube egesasiimero negetambaa kere monyinga. ");
INSERT INTO guz_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Igoro ase egesasiimero ekio babeeke ebikorero bionsi ebio bigokorerwa ase ogosasiima: chindogio chi’okorenta omorero, ne chigami, na ebichiiko, ne chisani, naende baare risankwa ri’eng’iti ya rooche igoro ase ebio bionsi, babitube. Erio basoyie emiaro y’okobogoreria egesasiimero keria. ");
INSERT INTO guz_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ekero engaki eraike, abanto barabe bakomanora na koimoka korwa ase ebitwori, na ekero Aroni na abamura baye bakoorire gotuba Eema y’Omosangererekano, amo n’ebinto bionsi bireo, Abakohati bachiche babogorie ebinto ebi ebichenu, korende tibabikuna. Baise kobikuna, nigo barakwe. “Emeremo y’okobogoria ebinto ebio bi’Eema y’Omosangererekano nigo erabe ey’Abakohati. ");
INSERT INTO guz_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazari, omomura o Aroni Omokuani, nere oratenenere amaguta e chitaaya, na ubani egotioka buya, na okoruegwa kw’endagera gwa kera rituko, na amaguta akweakwa. Ase igo emeremo yaye ebe ey’okorenda Obomenyo Obochenu, na ebinto bionsi ebichenu, na ebinto bionsi ebichenu ebire imeo.” ");
INSERT INTO guz_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Omonene agateebia Musa na Aroni, ");
INSERT INTO guz_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Timotiga abanto be chiamate chia Kohati basirigwe korwa ase Abalawi. ");
INSERT INTO guz_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ase ayio, ekero barabe bagoika ang’e n’ebinto biria ebichenu mono, Aroni na abamura baye basoe aroro, bae kera oyomo obo emeremo, na komoteebia keria arabe ogokora na kobogoria. Erio nario barabe moyo, tibakwa. ");
INSERT INTO guz_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Korende Abakohati baise gosoa na korora ebinto biria ebichenu, nonya netagika ensinini, nigo barakwe.” ");
INSERT INTO guz_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Kora omobaro bw’Abalawi baria bare b’ororeria rwa Gerisoni, eamate ase eamate, na enyomba ase enyomba. ");
INSERT INTO guz_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Oriike abasacha bonsi abare egati y’emiaka emerongo etato na merongo etano, abwo bonsi baranyare gokora emeremo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Eye nero emeremo abanto be chiamate chia Gerisoni barakore naende buna barabe bakobogoria ebinto ebi: ");
INSERT INTO guz_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Barabwo mbabogorie ebitambaa bi’Obomenyo Obochenu amo nebitubo bi’Eema eria, ne risankwa ri’eng’iti ya rooche rikobituba, na egetambaa ki’egesoero ki’Eema eria, ");
INSERT INTO guz_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","na ebitambaa bi’eraaro eetanaine Obomenyo boria na egesasiimero, na ebitambaa bi’egesoero ki’eraaro, ne chingori chionsi chireo amo nebikorero bigokorerwao. Barabwo bakore emeremo ende yonsi eganeirie gokorwa ase ebinto ebio. ");
INSERT INTO guz_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aroni na abamura baye nabwo barachike Abagerisoni ebinto bionsi barabe bakobogoria, na onsi aya barakore; inwe mobatige batenenere ebinto bionsi barabe bakobogoria. ");
INSERT INTO guz_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Itamari, omomura o Aroni Omokuani, nere oratenenere emeremo abanto be chiamate chi’Abagerisoni barabe bagokora agwo ase Eema y’Omosangererekano.” ");
INSERT INTO guz_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Omonene agateebia Musa, “Kora omobaro bw’Abalawi baria bare ab’ororeria rwa Merari, eamate ase eamate na enyomba ase enyomba. ");
INSERT INTO guz_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Oriike abasacha bonsi abare egati y’emiaka emerongo etato na merongo etano, abwo bonsi baranyare gokora emeremo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Emeremo yabo ase Eema eria ebe ey’okobogoria ebinto ebi: Chibao chi’Obomenyo Obochenu, na emeriibo, ne chisiiro amo ne chinterekerero chiabo, ");
INSERT INTO guz_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ne chisiiro chi’eraaro amo ne chinterekerero chiabo, na ebirochi, ne chingori, amo nebikorero bionsi bigokorerwao. Obaatorere ebinto bionsi barabwo barabe bakobogoria. ");
INSERT INTO guz_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Eye nero emeremo y’ abanto be chiamate chia Merari barabe bagokora agwo ase Eema y’Omosangererekano, inse y’oboteneneri bwa Itamari, omomura o Aroni Omokuani.” ");
INSERT INTO guz_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, na Aroni, na abaraai b’omoganda bagakora omobaro bw’ororeria rwa Kohati, eamate ase eamate, na enyomba ase enyomba. ");
INSERT INTO guz_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Bakariika abasacha bonsi abaare egati y’emiaka emerongo etato na merongo etano, abwo baare konyara gokora emeremo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Abanto abwo barigetwe ase chiamate chiabo nigo barenge chilifu ibere, amagana atano abere, nemerongo etano (2,750). ");
INSERT INTO guz_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Oyio n’oro omobaro bwe chiamate chi’Abakohati abwo baare konyara gokora emeremo agwo ase Eema y’Omosangererekano, abwo Musa na Aroni baabarete, buna Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Oyo n’oro omobaro bw’ororeria rwa Gerisoni, eamate ase eamate, na enyomba ase enyomba. ");
INSERT INTO guz_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Abanto abwo baare egati y’emiaka emerongo etato na merongo etano, naende barenge konyara gokora emeremo ase Eema y’Omosangererekano, bakariikwa. ");
INSERT INTO guz_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Abwo nigo barenge abanto chilifu ibere, amagana atano nomo na merongo etato (2,630). ");
INSERT INTO guz_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Oyo n’oro omobaro bwe chiamate chi’Abagerisoni, abarigetwe, abwo baare konyara gokora emeremo ase Eema y’Omosangererekano, abwo Musa na Aroni baabarete, buna Omonene achiigete. ");
INSERT INTO guz_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Oyo n’oro omobaro bw’ororeria rwa Merari, eamate ase eamate, na enyomba ase enyomba. ");
INSERT INTO guz_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Abasacha abwo baare egati y’emiaka emerongo etato na merongo etano, naende barenge konyara gokora emeremo ase Eema y’Omosangererekano, bakariikwa. ");
INSERT INTO guz_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Abwo nigo barenge abanto chilifu isato, n’amagana abere (3,200). ");
INSERT INTO guz_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Oyo n’oro omobaro bwe chiamate chi’Abamerari, abwo Musa na Aroni baabarete, buna Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Musa, na Aroni, na abaraai b’Abaisraeli nigo baabarete Abalawi bonsi eamate ase eamate, na enyomba ase enyomba. ");
INSERT INTO guz_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Abwo abaare egati y’emiaka emerongo etato na merongo etano, naende barenge konyara gokora emeremo ase Eema y’Omosangererekano, ");
INSERT INTO guz_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","nigo barenge abanto chilifu isano isato na amagana atano, na merongo etano netato (8,580). ");
INSERT INTO guz_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Abwo bonsi nigo baabaretwe buna Omonene achiigete goetera ase Musa. Kera omonto agateebigwa emeremo yaye arakore na ebinto arabogorie buna Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Bachiike Abaisraeli barusie korwa ase ebitwori biabo kera omonto obwate oborwaire bwa ukoma, na omonto okorua amaache anga buna chimengere, na omonto onde bwensi bwesoyirie ase ogotacheneka ase ogokuna egetondo. ");
INSERT INTO guz_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Goika morusie korwa ase ebitwori abasacha na abakungu abwo babeire abatachenegeti babeere isiko, erinde tibaabaisa gokora ebitwori biabo bibe bitachenegeti, agwo ase inche imenyete ase egati y’ abanto bane.” ");
INSERT INTO guz_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Abaisraeli bagakora buna Omonene atebeetie Musa. Bakarusia korwa ase ebitwori abanto abwo. ");
INSERT INTO guz_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Naende Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Teebia Abaisraeli ng’a, ekero omonto omosacha, gose omokungu, arakore ebibe binde bionsi abanto bagokora ase ogotaba abegenwa ase Omonene, na omonto oria oraabe omomochi, ");
INSERT INTO guz_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","omonto oyio goika aorokie ebibe biria. Boigo airanie ase omonto oria aurete rigori ri’eniibo eyio amourete, naende amente eyemo ya isano ye rigori ri’egento ekio. ");
INSERT INTO guz_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Korende onye omonto oria okuure, naende omoamate oye tari okoiranerigwa egento ekio kiairetwe, rirorio kerentwe ase Omonene kebe eki’Omokuani. Amo nayio omonto oyio amente emingichi erakorerwe okobwatanigwa ase are. ");
INSERT INTO guz_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Kera okoruegwa kw’ebinto ebichenu Abaisraeli baraarente ase Omokuani, ebinto ebio ’nabibe ebiaye. ");
INSERT INTO guz_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ebinto bionsi omonto araatanane koba ebichenu nigo birabe ebi’Omokuani oyio okobiegwa.” ");
INSERT INTO guz_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Naende Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Teebia Abaisraeli: Ebaise koba ng’a omokungu bw’omonto obeire otari omwegenwa’ ase are. ");
INSERT INTO guz_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Omonto omoao kararaare nere ase obotomani, nonya ayio karabe abisekanete ase omosacha bw’omokuungu oyio, omokungu oyio bwekorire omosaria, nonya kirori onde tari okomoteeba ekiagera tabwatetwe okobokora. ");
INSERT INTO guz_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Omosacha oye karabe n’Omoika bwe endamwamu akagere mok’aye ng’a bwekorire omosaria, nere abe okorete ayio, gose tayakorete, ");
INSERT INTO guz_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","omosacha oye amoire ase Omokuani. Boigo arue obosie bw’esairi ebimunu bibere, ase engencho y’omokuungu oria. Taumora amaguta igoro y’okoruegwa okwo, gose ubani, ekiagera n’okoruegwa ase engencho ye risemi riaye. Okwo n’okoruegwa koragere okomocha koinyorwe. ");
INSERT INTO guz_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Omokuani arente omokungu oria amobeeke ase obosio bw’Omonene, ");
INSERT INTO guz_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","aumore amaache amaachenu ase egetaabo ki’amaroba, naende aimokie amaroba korwa inse agwo ase Obomenyo Obochenu, ayabeeke ime ase amaache aria. ");
INSERT INTO guz_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Omokuani abeeke omokungu oria ase obosio bw’Omonene, asansore etukia y’omotwe bw’omokuungu oria, naende abeeke okoruegwa koria gw’ekeinyorio ase amaboko ’omokuungu oria. Omokuani omonyene abwate ase okoboko kwaye egetaabo kere namaache amaroro, ayio akorenta okoragereria. ");
INSERT INTO guz_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Erio Omokuani abeeke omokungu oyio inse y’okoragererigwa, amoteebie: Onye omonto omoao taraarete naye, na igo tigwakorete obotomani ase ogotaba omwegenwa ase omosacha oo, rirorio amaache aya amaroro akorenta okoragererigwa takonyara kogokorera bobe bonde. ");
INSERT INTO guz_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Korende onye gwatomanire nomonto omoao ase ogotaba omwegenwa ase omosacha oo, na gwekorire omosaria, ");
INSERT INTO guz_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(agwo Omokuani abeeke omokungu oyio inse y’okoragererigwa gw’okomotiania) rirori’Omonene nagere abanto bao bakoragererie na kogochaaya, karakore enda yao egombae na kobimba. ");
INSERT INTO guz_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Tiga amaache aya akorenta okoragereria kagosoa enda yao, ayekore ebimbe na kogombaa. Omokungu oria airanerie: Ee, ekeene, amina. ");
INSERT INTO guz_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Erio Omokuani ariike amang’ana ayio ay’okoragereria okwo ime ase egetabu, naende ayasibie namaache aria amaroro. ");
INSERT INTO guz_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Erio ae omokungu oria amaache ayio anywe, na ekero amaache aya amaroro asoire ase enda yaye arente okoragererigwa na obororo. ");
INSERT INTO guz_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Omokuani arusie korwa ase okoboko kw’omokuungu oria okoruegwa kwe endamwamu, na kogosungusia ase obosio bw’Omonene. Magega y’ayio akorente ase egesasiimero. ");
INSERT INTO guz_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Naende korwa ase okoruegwa okwo aimokie goke, goichire roe, kobe ekeinyorio ng’a okoruegwa okwo nokwa Omonene, na kogosambera ase egesasiimero, na magega y’ayio ae omokungu oria amaache aria anywe. ");
INSERT INTO guz_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Onye omokungu oria tabeete omwegenwa ase omosacha oye, korende bwekorire omosaria, amaache aya amaroro akorenta okoragererigwa akore enda yaye ebimbe, naende egombae. Ase enchera eyio omokungu oyio abe ekiorokererio gi’okoragererigwa kegwatorwa ase egati y’ abanto baye. ");
INSERT INTO guz_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Onye omokungu oria takorete obotomani korende nigo are omoikeranu, rirorio tagokorerwa bobe, otatiga aibore abana. ");
INSERT INTO guz_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Oko nogochika ase amang’ana ye endamwamu, ekero omokungu atari omwegenwa ase omosacha oye, korende akore obotomani na gwekora omosaria. ");
INSERT INTO guz_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Naboigo ekero omosacha arabe n’Omoika bwe endamwamu na gokagera mok’aye ng’a nomotomani, omosacha oria amorente ase obosio bw’Omonene, na Omokuani akore onsi aya achiikire. ");
INSERT INTO guz_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Omosacha oria takoba nokomocha, korende onye mok’aye okorire ogosaria okwo, goika aegwe egesusuro.” ");
INSERT INTO guz_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Bateebie Abaisraeli ng’a ekero omonto, omosacha gose omokungu, akoria eira abe oyo bweatananire ase Omonene abe Omwerwa oye, ");
INSERT INTO guz_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","goika eatanane korwa ase edivai amo nebinyugwa bigotindia. Tabaisa konywa ebinyugwa binde bionsi bikoroisigwa korwa ase amasabibu, gose taria amasabibu, amabese gose amomo. ");
INSERT INTO guz_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ase amatuko aye onsi eatananete koba Omwerwa taria gento kende gionsi gekoroisigwa korwa ase emesabibu. Taria nonya ne chimbusururo gose amasabo y’amasabibu. ");
INSERT INTO guz_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Tabaisa konacha etukia yaye gose gwekigita goika okoorire amatuko aye onsi ariete eira gweatanana koba Omwerwa Omonene. Ere nabe oyo bweatananire, na atige etukia y’omotwe oye ekiine. ");
INSERT INTO guz_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Tageenda aike ang’e negetondo ase amatuko ayio onsi eatananete koba Omwerwa Omonene. ");
INSERT INTO guz_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ise nakwa, gose ng’ina, gose momura omwabo, gose omoiseke omwabo, tageenda ang’e negetondo na gwesoyia ase ogotacheneka. Ere nigo abwate ase omotwe oye ekemanyererio ng’a bweatananire koba Omwerwa o Nyasae oye. ");
INSERT INTO guz_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ere nigo arabe omochenu aase Omonene ase amatuko aye onsi eatananete. ");
INSERT INTO guz_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Korende omonto karakwe mobosokano ang’e nere, na akore omotwe oye ore nekemanyererio gi’okwerwa kwaye abe otachenegeti, rirorio Omwerwa oyio aganye amatuko atan’abere erio akigite etukia yaye, na abe oyo’chenekire. ");
INSERT INTO guz_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ase rituko ria gatano na gatato, arente amaruma abere, gose amage y’amaruma abere, ase Omokuani agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Omokuani arue riruma erimo ribe ekeng’wanso ki’ebibe, na erinde eki’ogosambwa ase ogokora okobwatanigwa ase Omwerwa oria, ekiagera okorire ebibe ase ogoika ang’e negetondo. Ase rituko erio erio omonto oria achene omotwe oye, ");
INSERT INTO guz_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","na eatanane ase Omonene naende, ase engaki eng’ana buna eria ariete eira koba Omwerwa agwo ritang’ani. Erio arente emanwa emingichi yakoorire omwaka oyomo ebe ekeng’wanso gi’okorongeyia okomocha kwaye ekiagera amatuko aria aye amatang’ani eatananete ase Omonene buna Omwerwa oye takobarwa korende nigo arabe bosa, ekiagera okwerwa kwaye gwakorirwe ogotachenegeti. ");
INSERT INTO guz_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Oko nakwo ogochika ase Omwerwa: Ekero engaki yaye y’ogweatanana yaerire, arentwe ase egesoero ki’Eema y’Omosangerekano. ");
INSERT INTO guz_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ere arue ekeng’wanso kiaye ase Omonene: emanwa emingichi yakoorire omwaka oyomo ebe ekeng’wanso ki’ogosambwa, na emanwa esigiti yakoorire omwaka oyomo ebe ekeng’wanso ki’ebibe, na emingichi eyemo ebe ekeng’wanso ki’omorembe; chionsi chibe chitari na bimocho ase emebere yabo. ");
INSERT INTO guz_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Boigo arente egetonga kere n’emagaati etabekiri memera, na arue amaandasi aroisirie n’obosie obonuke bwochoganirie n’amaguta, na emagaati emeoo eakire amaguta, amo n’okoruegwa kw’endagera na okw’ebinyugwa gochiikire amo. ");
INSERT INTO guz_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Omokuani arente ebinto ebio ase obosio bw’Omonene na arue ekeng’wanso ki’ebibe na eki’ogosambwa ase engencho y’omonto oria. ");
INSERT INTO guz_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Boigo arue emingichi eria ebe ekeng’wanso ki’omorembe ase Omonene, ayerue amo n’emagaati etabekiri memera ere egetonga ime, na okoruegwa kw’endagera na ogw’ekenyugwa gochiikire amo. ");
INSERT INTO guz_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Agwo ase egesoero ki’Eema y’Omosangererekano, Omwerwa oria akigite etukia y’omotwe oye ere ekemanyererio ng’a neatananete ase Omonene. Erio aire etukia yaye, ayerute ase omorero oria ore inse y’ekeng’wanso ki’omorembe. ");
INSERT INTO guz_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Magega, ekero Omwerwa oria akoorire gokigita etukia yaye, Omokuani aimokie rireko ri’emingichi riaiyekirwe, na korwa ase egetonga arusie omogati oyomo otabekiri memera, na omogati oyomo otabekiri memera, ayebeke ase amaboko y’Omwerwa oria. ");
INSERT INTO guz_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Omokuani arente ebinto ebio amo ne ritaana na ekenama bi’emingichi, abisungusie bibe ekeng’wanso ki’ogosungusigwa ase Omonene. Ebinto ebio nigo biatananetwe ase Omokuani. Erio nario Omwerwa oria arabe ne ribaga konywa edivai.” ");
INSERT INTO guz_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Oko nakwo ogochika ase oyoriete eira ng’a abe Omwerwa Omonene, goika arue ase Omonene aya amorierete eira akorua ore Omwerwa oye, korende onye oriire eira arue goetania, goika ayeikeranie kegima koreng’ana nogochika gw’okwerwa. ");
INSERT INTO guz_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Moteebie Aroni amo nabamura baye ng’a, ekero barabe bagosesenia Abaisraeli, bakwane amang’ana aya: ");
INSERT INTO guz_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Omonene abasesenie, abareende; ");
INSERT INTO guz_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Omonene abaraberie obosio bwaye, abaabere; ");
INSERT INTO guz_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Omonene abaonchorere obosio bwaye, abae omorembe. ");
INSERT INTO guz_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Naboigo bararangerie erieta riane ribe igoro y’Abaisraeli ase okobasesenia, erio inche omonyene nimbasesenie.” ");
INSERT INTO guz_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ase rituko riria Musa konya akoorire gotenenia Obomenyo Obochenu naende kaboakire amaguta na kobwatanana amo n’ebinto biaye bionsi, naende gakoorire gwatanana egesasiimero na ebikorero biaye, ");
INSERT INTO guz_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","abatang’ani b’Abaisraeli, abwo barenge abateneneri igoro ase baria baabaretwe, ");
INSERT INTO guz_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","bakarentera Omonene okoruegwa kwabo. Bakarua chigaari isan’emo chitubire, ne chiombe ikomi na ibere, egaari eyemo ase abatang’ani babere na kera eng’ombe eyemo ase omoraai oyomo. Bakarenta ebio agwo bosio bw’Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Eri’Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ancha oire ebiegwa ebio korwa ase bare, erinde bikorerwe emeremo agwo ase Eema y’Omosangererekano. Obie Abalawi, kera omonto anyore buna emeremo yaye ere.” ");
INSERT INTO guz_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ase ayio Musa akaira chigaari chiria ne chiombe, erio agachia Abalawi. ");
INSERT INTO guz_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Akaa Abagerisoni chigaari ibere ne chiombe inye, buna emeremo yabo yarenge. ");
INSERT INTO guz_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Naende akaa Abamerari chigaari inye, ne chiombe isanaisato, buna emeremo yabo yarenge inse y’oboraai bwa Itamari, omomura o Aroni Omokuani. ");
INSERT INTO guz_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Korende Abakohati Musa tabaete gento kende, ekiagera barabwo nigo baetwe emeremo y’okobogoria ebinto ebichenu, na ebio goika bibogorigwe ase amareko. ");
INSERT INTO guz_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ase rituko riria egesasiimero giatananetwe na goakwa amaguta, abatang’ani bakarenta okoruegwa kwabo bosio bw’egesasiimero. ");
INSERT INTO guz_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Omonene agateebia Musa, “Kera rituko omotang’ani oyomo oyomo arue okoruegwa kwaye ase ogwatananwa kw’egesasiimero.” ");
INSERT INTO guz_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Rituko rie ritang’ani Nahasoni, mosinto bw’Aminadabu bw’egesaku kia Yuda, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yaare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","na egoree eyemo yakoorire omwaka oyomo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kwa Nahasoni, mosinto bw’Aminadabu. ");
INSERT INTO guz_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Rituko ria kabere Netaneli, mosinto o Suari bw’egesaku gia Isakaru, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","N’ere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo, na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yaare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Boigo akarua eeri ensae, emingichi eyemo, nemanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kwa Netaneli, mosinto o Suari. ");
INSERT INTO guz_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Rituko ria gatato Eliabu, mosinto o Heloni bw’egesaku gia Sabuloni, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Nere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, negetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obuya bwochoganirie n’amaguta, bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kw’Eliabu, mosinto o Heloni. ");
INSERT INTO guz_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Rituko ria kane Elisuri, mosinto o Sedeuri bw’egesaku kia Rubeni, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Nere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo, na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta, bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Naende akarua egetaabo ekemo gi’etahahu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kw’Elisuri, mosinto o Sedeuri. ");
INSERT INTO guz_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Rituko ria gatano Selumieli, mosinto o Surisadai bw’egesaku gia Simioni, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Nere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etano nebere ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua gwa Selumieli, mosinto o Surisadai. ");
INSERT INTO guz_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Rituko ria gatano na rimo Eliasafu, mosinto o Deueli bw’egesaku kia Gadi, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","N’ere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kw’Eliasafu, mosinto o Deueli. ");
INSERT INTO guz_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Rituko ria gatan’akabere Elisama, mosinto bw’Amihudi, bw’egesaku gi’Efraimu, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","N’ere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo, na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kw’Elisama, mosinto bw’Amihudi. ");
INSERT INTO guz_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Rituko ria gatano na gatato Gamalieli, mosinto o Pedasuri bw’egesaku kia Manase, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","N’ere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Na ase ekeng’wanso ki’omorembe akarua chieri, ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kwa Gamalieli, mosinto o Pedasuri. ");
INSERT INTO guz_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Rituko ria kianda Abidani, mosinto o Gidioni bw’egesaku gia Benjamini, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Nere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emengichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kw’Abidani, mosinto o Gidioni. ");
INSERT INTO guz_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Rituko ria ikomi Ahieseri, mosinto bw’Amisadai bw’egesaku gia Dani, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","N’ere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kw’Ahieseri, mosinto bw’Amisadai. ");
INSERT INTO guz_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Rituko ria ikomi na rimo Pagieli, mosinto bw’Okirani bw’egesaku gi’Aseri, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Nere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, nechimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua gwa Pagieli, mosinto bw’Okirani. ");
INSERT INTO guz_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Rituko ria ikomi na kabere Ahira, mosinto o Enani bw’egesaku kia Nafutali, akarenta okoruegwa kwaye. ");
INSERT INTO guz_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Nere akarua esani eyemo eroisirie korwa ase efeta y’oborito bwe chisekeli rigana erimo na merongo etato, na egetaabo ekemo gi’efeta y’oborito bwe chisekeli emerongo etan’ebere, ase ekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Bionsi bibere nigo biaichire n’obosie obonuke bwochoganirie n’amaguta bokaba okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Naende akarua egetaabo ekemo gi’etaabu y’oborito bwe chisekeli ikomi, giaichire ubani. ");
INSERT INTO guz_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Boigo akarua eeri ensae, emingichi eyemo, na emanwa emingichi eyemo yakoorire omwaka oyomo, chikaba ekeng’wanso ki’ogosambwa, ");
INSERT INTO guz_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","na egoree eyemo ekaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Na ase ekeng’wanso ki’omorembe akarua chieri ibere, chimingichi isano, chigoree isano, ne chimanwa chimingichi isano chiakoorire omwaka oyomo. Oko nakwo kwarenge okorua kw’Ahira, mosinto o Enani. ");
INSERT INTO guz_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Omobaro bwonsi bw’ebinto biaruetwe nabatang’ani b’Abaisraeli ase ogwatananwa kw’egesasiimero ase rituko riria kiaagetwe amaguta nigo biabeete iga: Chisani ikomi na ibere chiaroisirie korwa ase chifeta, na ebitaabo ikomi na bibere biaroisirie korwa ase chifeta, na ebitaabo ikomi na bibere biaroisirie korwa ase chitaabu. ");
INSERT INTO guz_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Kera esani y’efeta nigo yarenge n’oborito bwe chisekeli rigana erimo na merongo etato, na kera egetaabo gi’efeta n’oborito bwe chisekeli emerongo etan’ebere. Ase igo oborito bwonsi bw’echifeta chi’ebinto ebio nigo bwarenge chisekeli chilifu ibere, na amagana ane (2,400), koreng’ana nekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Na ebitaabo biria ikomi na bibere biaroisirie korwa ase chitaabu biichire na ubani, nigo biarenge kera ekemo n’oborito bwe chisekeli ikomi koreng’ana nekerengo gi’esekeli yare gokorerwa ase Obomenyo Obochenu. Oborito bwe chitaabu chi’ebinto ebio bionsi nigo bwarenge chisekeli rigana erimo na merongo ebere. ");
INSERT INTO guz_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ching’iti chiaruetwe chikaba ekeng’wanso ki’ogosambwa nigo chiarenge chieri ikomi na ibere, chimingichi ikomi na ibere, ne chimanwa chimingichi chiakoorire omwaka oyomo ikomi na ibere, amo n’okoruegwa kw’endagera gwachiikire amo, chigoree ikomi na ibere chikaba ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ching’iti chionsi chiaruetwe chikaba ekeng’wanso ki’omorembe nigo chiabeete: Chieri emerongo ebere na inye, chimingichi emerongo etan’omo, chigoree emerongo etan’omo, ne chimanwa chimingichi chiakoorire omwaka oyomo emerongo etan’omo. Ebio nabio ebiegwa biaruetwe ekero egesasiimero giatananetwe na goakwa amaguta. ");
INSERT INTO guz_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ekero Musa asoete ase Eema y’Omosangererekano gokwana n’Omonene, akaigwa eriogi rigokwana nere korwa ase Oboikaranso bwa amaabera, obwo bwarenge igoro ase Esanduki yarenge ne chibao chiriikire oborori. Eriogi erio rikarua ase egati y’Abamalaika babere babegete chimbaaba, rigakwana nere. ");
INSERT INTO guz_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Teebia Aroni ng’a, ekero arabeeke chitaaya isano na ibere ase ekebekerero gie chitaaya, achibeeke erinde chimoreke gochia bosio.” ");
INSERT INTO guz_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aroni agakora bo, akabeeka ekebekerero gi’echitaaya echio, erinde chimoreke gochia bosio bw’ekebeekerero ekio, buna Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ekebekerero gie chitaaya na enterekerero yaye, amo n’emegwekano yaye y’ebisicha nigo biaroisirie korwa ase chitaabu chiturire. Nabo Musa aroisetie ekebeekerero ekio buna Omonene konya amochiikire. ");
INSERT INTO guz_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Atanana Abalawi korwa ase Abaisraeli na obachene. ");
INSERT INTO guz_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ekero okobachena nigo orakore iga: Onyororokie amaache y’ogwesibia igoro yabo, na barabwo bakigite emebere yabo yonsi na basibie chianga chiabo. Erio babe bachenekire. ");
INSERT INTO guz_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Naende barente eeri ensae amo n’okoruegwa kw’endagera kw’obosie obonuke bwochoganirie n’amaguta. Naye oire eeri ende ensae ebe ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Osangererie omoganda bwonsi bw’Abaisraeli na orente Abalawi agwo bosio bw’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ekero kwarentire Abalawi ase obosio bwane, inche Omonene, Abaisraeli goika babeeke amaboko abo igoro ase emetwe yabo. ");
INSERT INTO guz_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Naende Aroni arente Abalawi ase obosio bwane, babe buna ekeng’wanso ki’ogosungusigwa korwa ase Abaisraeli. Naboigo Abalawi baatananwe, babe ekeegwa ase ogonkorera inche Omonene. ");
INSERT INTO guz_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Magega yaye Abalawi goika babeeke amaboko abo igoro ase emetwe ye chieri chiria, naye orusie eeri eyemo ebe ekeng’wanso ki’ebibe, na eyende ebe ekeng’wanso ki’ogosambwa ase ’nde inche Omonene, na igo okore okobwatanigwa ase Abalawi. ");
INSERT INTO guz_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Obeeke Abalawi babe bagokonya Aroni na abamura baye, obaatanane babe buna ekeng’wanso ki’ogosungusigwa ase ’nde inche Omonene. ");
INSERT INTO guz_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ase enchera eyio obaatanane Abalawi korwa ase Abaisraeli, barabwo ’mbabe abaane. ");
INSERT INTO guz_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ekero kwabachenire na kobaatanana babe buna ekeng’wanso ki’ogosungusigwa, barabwo basoe ase Eema y’Omosangererekano babe bagokora emeremo aroro. ");
INSERT INTO guz_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Barabwo baruegwe kegima korwa ase Abaisraeli babe abaane, ekiagera nabachorire ribaga ri’abana abatangi b’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Abana abatangi bonsi b’Abaisraeli n’abaane, ne ching’iti chintangi boigo. Rituko riria naitete abana abatangi bonsi amo ne ching’iti chintangi ase ense ya Misiri, nigo neatananerete abana abatangi b’Abaisraeli amo ne ching’iti chintangi. ");
INSERT INTO guz_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Na bono nachorire Abalawi babe abaane ribaga ri’abana abatangi bonsi b’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Narure Abalawi babe ekeegwa ase Aroni na abamura baye korwa ase Abaisraeli, erinde bakore emeremo ase engencho y’Abaisraeli, agwo ase Eema y’Omosangererekano. Boigo bakore okobwatanigwa ase bare, erinde nintange amaakwa tabanyora ekero bagoika ang’e n’Aase Aachenu.” ");
INSERT INTO guz_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Naboigo Musa, na Aroni, amo n’omoganda bwonsi bw’Abaisraeli bakaba bagokorera Abalawi. Abaisraeli bakabakorera kera ring’ana Omonene konya achiikire Musa baabakorere. ");
INSERT INTO guz_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Abalawi bagechena korwa ase ebibe na bagasibia chianga chiabo, na Aroni akabaatanana bakaba buna ekeng’wanso ki’ogosungusigwa ase obosio bw’Omonene, naende agakora okobwatanigwa ase bare, na kobachena. ");
INSERT INTO guz_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Magega yayio Abalawi bakageenda ase obokoreri bwabo ime ase Eema y’Omosangererekano inse y’oborendi bwa Aroni na abamura baye. Bun’Omonene konya achiikire Musa igoro y’Abalawi nabo Abaisraeli baabakorerete. ");
INSERT INTO guz_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Omonene agakwana naende na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Eye nero emeremo y’Abalawi: Abwo bakoorire emiaka emerongo ebere na etano, na goetania, nigo barabe bagokora emeremo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ekero bakoorire emiaka emerongo etano batige batimoke korwa ase emeremo eria. ");
INSERT INTO guz_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Barabwo ’mbabe ne ribaga ri’ogokonya baria bamwabo bare abakoreri ase Eema y’Omosangererekano, korende tibaabaisa gokora emeremo eyio abanyene. Naboigo oraroberie Abalawi ase emeremo yabo.” ");
INSERT INTO guz_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ase omotienyi bw’eritang’ani, bw’omwaka o kabere, ekero Abaisraeli baruure ense ya Misiri, Omonene agakwana na Musa agwo ase erooro ya Sinai, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Abaisraeli goika barende rituko ri’Epasaka ase engaki echiikire. ");
INSERT INTO guz_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ase rituko ria ikomi na kane ri’omotienyi oyo, chinsa chia mogoroba, ’namorende rituko erio ase engaki echiikire koreng’ana n’emeroberio eria yachigetwe.” ");
INSERT INTO guz_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ase igo Musa agateebia Abaisraeli ng’a barende rituko rinene ri’Epasaka. ");
INSERT INTO guz_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Na abanto bagakora bo, bakarenda rituko riria rinene ri’Epasaka agwo ase erooro ya Sinai, ase rituko ria ikomi na kane riomotienyi bw’eritang’ani, chinsa chia mogoroba. Abaisraeli bagakora amang’ana onsi buna Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Korende ’mbarengeo abanto gete konya besoyirie ase ogotacheneka ase ogokuna egetondo. Barabwo tibanyarete korenda rituko ri’Epasaka ase rituko riria. Ase ayio bakageenda ase Musa na Aroni ase rituko riria, ");
INSERT INTO guz_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","bakabateebia, “Intwe nigo twabeire abatachenegeti ase ogokuna egetondo. Inee! Ninki kiagera twatangirwe titorua okoruegwa ase Omonene ase engaki Abaisraeli bachiikire komoruera okoruegwa kwabo?” ");
INSERT INTO guz_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa akabateebia, “Ganya, inyigwe ay’Omonene arachiike igoro yaino.” ");
INSERT INTO guz_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Kwana n’Abaisraeli obateebie: Onye omonto onde oino, gose oyo bw’ororeria rwaino, obeire oyotachenegeti ase ogokuna egetondo, gose nigo are aare ase orogeendo, na onye origetie korenda rituko ri’Epasaka y’Omonene, ");
INSERT INTO guz_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","nigo ararirende ase rituko ria ikomi na kane, chinsa chia mogoroba ase omotienyi o kabere. Narie emanwa y’eng’ondi y’Epasaka amo n’emagaati etabekiri ememera, ne chinyeni chindoro. ");
INSERT INTO guz_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Tabaisa gotigaria nonya n’ensinini ye chinyama echio goika rituko ria kabere, gose tabuna riuga nonya nerimo ri’emanwa eria. Narende rituko riria rinene ri’Epasaka koreng’ana nemeroberio eria yachiigetwe. ");
INSERT INTO guz_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Korende omonto ochenegete gose otakari aare ase orogeendo, oretange tarenda rituko ri’Epasaka, omonto oyio naatananwe korwa ase abanto baye, ekiagera ere tarenteti okoruegwa kwaye ase Omonene ase engaki eria echiikire. Okomocha kw’ebibe kw’omonto oria ’nkobe igoro yaye. ");
INSERT INTO guz_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Onye omomenyi omenyete ase egati yaino bwanchete koria Epasaka y’Omonene nigo arakore koreng’ana nemeroberio eria yachiigetwe. Mobe nogochika okomo ase omomenyi na ase omobiare.” ");
INSERT INTO guz_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ase rituko erio Obomenyo boria Obochenu bwatenenetigwe, riire rigatuba Obomenyo obwo, engencho yaye Eema y’Oborori. Na korwa mogoroba goika mambia riire riria rikarorekana rire buna omorero. ");
INSERT INTO guz_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Naboigo riire riagendererete botambe gotuba Obomenyo boria Obochenu; ase obotuko rirorekana rire buna omorero. ");
INSERT INTO guz_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ekero kende gionsi riire riria riarenge koimokerera igoro korwa ase Eema eria, erio Abaisraeli nigo barenge komanora, bachaaka orogeendo rwabo. Na aase riire riria riarenge gotenena, aroro agwo nao Abaisraeli barenge gotoora. ");
INSERT INTO guz_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ase ogochika kw’Omonene nigo baare gochaaka orogeendo, na ase ogochika kwaye nigo baare gotoora. Engaki yonsi riire riria riagendererete kobeera igoro ase Obomenyo boria, abanto nigo baare kogenderera kobeera ase egetwori. ");
INSERT INTO guz_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Onye riire riria riarenge kobeera igoro ase Obomenyo boria amatuko amaange, Abaisraeli nigo baigwerete Omonene, na barabwo tibarenge komanora kogeenda. ");
INSERT INTO guz_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ase chingaki chinde riire riria nigo riarenge kobeera igoro ase Obomenyo boria amatuko amake oka. Bun’Omonene achiigete, abanto nigo baare kobeera ase egetwori, naende ekero Omonene arenge kobachiika, bachaaka kogeenda ase orogeendo rwabo. ");
INSERT INTO guz_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Chingaki chinde riire riria nigo riarenge kobeera igoro ase Obomenyo boria korwa mogoroba goika mambia rioka. Ekero kende gionsi riire riarenge koimokerera igoro, abanto nigo barenge gochaaka orogeendo rwabo. Onye riarenge kobeera agwo omobaso na obotuko goika ekero riarenge koimokerera igoro naende, abanto nigo barenge gochaaka orogeendo ekero ekio. ");
INSERT INTO guz_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Onye riire riarenge kobeera igoro ase Obomenyo boria amatuko abere, gose omotienyi oyomo, gose engaki entambe, Abaisraeli nigo barenge kobeera ase egetwori, tibarenge komanora kogeenda, korende ekero riire riaimokereire igoro, barabwo nigo barenge gochaaka orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Bun’Omonene arenge gochiika nigo barenge gotoora, batiga orogeendo, gose baimoka bachaaka orogeendo. Bakaba bakoigwera Omonene buna achiigete goetera ase Musa. ");
INSERT INTO guz_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Roisia chitarumbeta ibere chie chifeta chiturire. Obe gokobibugia ekero ogosangereria omoganda amo, na ekero abanto barabe bakoimoka korwa ase ebitwori gochaaka orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ekero chitarumbeta chionsi ibere chirabugigwe, abanto bonsi ’nabache na gosangererekana agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Korende onye eyemo yoka gekobugigwa, abatang’ani abwo bare abateneneri b’ebisaku bi’Abaisraeli nabwo boka barachiche ase ore. ");
INSERT INTO guz_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ekero morabugie etarumbeta ase eriogi ri’ogotabobora, abanto bare ase ebitwori bi’enseemo ya moocha baimoke bachaake orogeendo rwabo. ");
INSERT INTO guz_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Naende ekero morabugie etarumbeta ase eriogi ri’ogotabobora eria’kabere, abanto bare ase ebitwori bi’enseemo ya Irianyi baimoke bachaake orogeendo. Etarumbeta goika ebugigwe ase eriogi erio ase chingaki chionsi abanto barabe bakomanora gochaaka orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Korende ekero omosangererekano okorangerigwa goochicha amo, chitarumbeta goika chibugigwe, korende tari ase eriogi ri’ogotabobora. ");
INSERT INTO guz_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Abamura ba Aroni Omokuani nabwo barabe bakobugia chitarumbeta echio. Oko nakwo koraabe ogochika ase more kogenderera botambe, ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ekero moraabe mokorwana esegi nababisa baino abwo baraache kobarwania ase ense yaino, mobe mokobugia chitarumbeta ase eriogi ri’ogotabobora, erinde monyaare koinyorwa ase obosio bw’Omonene Nyasae oino, na inwe ’namotoorigwe korwa ase ababisa baino. ");
INSERT INTO guz_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ase amatuko aino y’omogooko, na amatuko achiikire abe Amatuko Amanene ase more, na ase omochakano bw’emetienyi ’namobe mokobugia chitarumbeta igoro y’ebing’wanso biaino bi’ogosambwa, na ebi’omorembe, na chitarumbeta echio chigere mobe mokoinyorwa ase obosio bwa Nyasae oino. Inche ninche Omonene Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ase rituko ri’emerongo ebere ri’omotienyi o kabere, ase omwaka o kabere, riire riria rikaimokerera igoro korwa ase Obomenyo Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Abaisraeli bakaimoka korwa ase erooro ya Sinai, bakageenda bakaba bakona‐gotoora egetwori ase egetwori, ne riire riria rigaika agwo ase erooro ya Parani, rigatenena aroro. ");
INSERT INTO guz_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Omonene agachiika Musa, na Abaisraeli bagachaaka orogeendo rwabo ase ekero egetang’ani. ");
INSERT INTO guz_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Abanto b’egetwori kia Yuda, abatoorete inse y’ebendera yabo, bakaba abatang’ani b’okoimoka gochaaka orogeendo, ekeombe ase ekeombe, na Nahasoni, mosinto bw’Aminadabu, nere orenge omoraai bw’omoganda oria. ");
INSERT INTO guz_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneli, mosinto o Suari, nere orenge omoraai bw’ abanto b’egesaku gia Isakaru, ");
INSERT INTO guz_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","na Eliabu, mosinto o Heloni, nere orenge omoraai bw’ abanto b’egesaku gia Sabuloni. ");
INSERT INTO guz_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ekero Obomenyo bwatagoretwe Abagerisoni na Abamerari, abarenge kobobogoria, bachaaka orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Magega y’ayio abanto b’egetwori kia Rubeni, abatoorete inse y’ebendera yabo, bakaimoka kogeenda ekeombe ase ekeombe, na Elisuri, mosinto o Sedeuri, nere orenge omoraai bw’omoganda oria. ");
INSERT INTO guz_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Selumieli, mosinto o Surisadai, nere orenge omoraai bw’ abanto b’egesaku gia Simioni. ");
INSERT INTO guz_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasafu, mosinto o Deueli, nere orenge omoraai bw’ abanto b’egesaku kia Gadi. ");
INSERT INTO guz_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Erio Abakohati bakaimoka kogeenda babogoretie Ebinto Ebichenu. Ekero konya bataraika ase egetwori bakanyora ng’a baria bande batenenirie Obomenyo boria Obochenu. ");
INSERT INTO guz_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Naende abanto b’egetwori kia Efraimu, abatoorete inse y’ebendera yabo, bakaimoka kogeenda, ekeombe ase ekeombe, na Elisama, mosinto bw’Amihudi, nere orenge omoraai bw’omoganda oria. ");
INSERT INTO guz_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli, mosinto o Pedasuri, nere orenge omoraai bw’ abanto b’egesaku kia Manase. ");
INSERT INTO guz_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidani, mosinto o Gidioni, nere orenge omoraai bw’ abanto b’egesaku gia Benjamini. ");
INSERT INTO guz_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Omoerio abanto b’egetwori gia Dani, abatoorete inse y’ebendera yabo, bakaimoka kogeenda, ekeombe ase ekeombe. Abwo nigo barenge abarendi ba magega ase ebitwori bionsi. Ahieseri, mosinto bw’Amisadai, nere orenge omoraai bw’omoganda oria. ");
INSERT INTO guz_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli, mosinto bw’Okirani, nere orenge omoraai bw’ abanto b’egesaku gi’Aseri, ");
INSERT INTO guz_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","na Ahira, mosinto o Enani, nere orenge omoraai bw’ abanto b’egesaku kia Nafutali. ");
INSERT INTO guz_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Oyo n’oro orenge omooroberio bw’Abaisraeli ekero barenge kogeenda orogeendo rwabo, ekeombe ase ekeombe, ekero kende gionsi baare koimoka korwa ase egetwori. ");
INSERT INTO guz_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa agakwana na Hobabu, mosinto o Reueli Omomidiani, akamoteebia, “Intwe ’nkogeenda tore aase aaria ase Omonene atotebetie ng’a n’atoe. Inchuo ogende amo naintwe, na intwe ’natogokorere amaya, ekiagera Omonene orire eira ng’a nasesenie Abaisraeli.” ");
INSERT INTO guz_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Korende Hobabu akairaneria, “Tinkogeenda amo nainwe; inche nigo ’nkoirana ingende ase ense yane, na ase abanto b’eamate yane.” ");
INSERT INTO guz_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa akamosorora, akamoteebia, “Koranche tobaisa gototiga, ekiagera aye nomanyete buna togochia kona gotoora ase erooro. Ase ayio nobe kogototang’ana. ");
INSERT INTO guz_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Naende koragende amo naintwe, amaya ari’Omonene agochia gotokorera, ayio naro naintwe toragokorere.” ");
INSERT INTO guz_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Abaisraeli bakaimoka korwa ase egetunwa keria kia Omonene, bakageenda orogeendo rw’amatuko atato. Esanduki y’okobwatana kw’Omonene yare ne chibao chiriikire okobwatana ekabatang’ana ekabanyorera aase bagochia gotoora, ");
INSERT INTO guz_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ne riire riria ri’Omonene nigo riarenge igoro ase bare ekero kia mobaso chingaki chinde chionsi barenge koimoka korwa ase ebitwori kogeenda ase orogeendo. ");
INSERT INTO guz_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ekero kende gionsi Esanduki eria yarenge gochaaka kobogorigwa gotang’ana orogeendo, Musa nigo arenge koboora, “Omonene, imoka, ababisa bao tiga baserigwe na goserebanigwa, na baria bakogechete tiga batame korwa ase obosio bwao.” ");
INSERT INTO guz_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na ekero Esanduki eria yarenge goikigwa aase bagotimokera, Musa nigo arenge goteeba, “Aye Omonene, bairanere Abaisraeli aba bare chilifu ne chilifu.” ");
INSERT INTO guz_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Abanto bakerera ase engencho y’emechando yabo. Ekero Omonene aigwete okwereera kwabo akaba n’endamwamu enene, agatoma omorero ogoka ase egati y’ abanto, na omorero oria ogasamba abanto barenge ase chinsinyo chi’ebitwori. ");
INSERT INTO guz_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Abanto bakarera ase Musa ng’a bakonywe, nere agasaba Omonene, na omorero oria okarimigwa. ");
INSERT INTO guz_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Aase aria akarokwa Tabera, ekiagera omorero Omonene bwogete ase egati y’ abanto. ");
INSERT INTO guz_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Abanto baria basang’anaine n’Abaisraeli nigo barenge nobotoonu obonene bw’okogania chinyama, na Abaisraeli boigo bakarera bagateeba, “Naki totanyora chinyama torie? ");
INSERT INTO guz_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Twainyoire chinswe twarenge koria ase ense ya Misiri totare goakanera, na endagera ende enga buna emiongo emerandi, na emenyobio, na ebitunguo biare ao ao, ebiororo amo nebiroro. ");
INSERT INTO guz_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Na bono chinguru chiaito chiatoereire, titobwati endagera ende tokoria otatiga Mana yoka.” ");
INSERT INTO guz_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana nigo yarenge kororekana buna chinyeke chi’amaemba enkomba. ");
INSERT INTO guz_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Abanto nigo barenge gosoka bayesangereria, naende bayesia ne chingena, gose bayeswaga ase chikonu. Erio baba bakoyeiyekera ase chinyongo na koyeroisia yaba emagaati. Igo yarenge gwansa buna amaandasi aroiseirie amaguta. ");
INSERT INTO guz_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Mana eyio nigo yarenge kogwa amo ne riime ase ebitwori ekero kia botuko. ");
INSERT INTO guz_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa akaigwa abanto bakwereera ase chiamate chiabo, kera omonto ase egesoero ki’eema yaye. Omonene akaba nendamwamu enene ase bare; ase ayio Musa akagechigwa. ");
INSERT INTO guz_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ere akamoteebia Omonene, “Nase ki gwankoreire inche, omosomba oo, obobe obo iga? Naende ’ntanyoreti ogwancherwa ase ore. Nase ki kwang’eire emeremo emenene ase okoraa abanto aba? ");
INSERT INTO guz_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Inee! Ninche naiborete abanto aba bonsi? Gose ninche nabatongete? Naki rende ogonteebia ng’a ’mbabogorie na kobarera ase egekuba kiane, buna omoreri akobogoria omwana ekeng’werere okogonka, goika imbaikie ase ense eria kwarierete chisokoro chiabo eira ng’a nobayee?” ");
INSERT INTO guz_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ng’ai ’nkorusia chinyama ’nkoa abanto aba bonsi? Barabwo nigo bakorera ase ’nde bagoteeba: Toe chinyama torie! ");
INSERT INTO guz_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Inche bweka tinkonyara koraa abanto aba, egurube eye n’endito mono ase ’nde. ");
INSERT INTO guz_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Onye aye kogonkorera amang’ana buna ayio, indorere amaabera, ong’ite rimo rioka inkwe ase obosio bwao, erinde timbaisa korora obokong’u obo. ");
INSERT INTO guz_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Omonene akamoiraneria, “Sangereria abagaaka b’Abaisraeli emerongo etan’ebere, abwo basikire, bamanyekanete bare abatang’ani b’ abanto, obarente agwo ase Eema y’Omosangererekano, batenene aroro amo naye. ");
INSERT INTO guz_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Inche ning’ike korwa igoro, ’nkwane naye aroro agwo. Naende nimbae barabwo omoika korwa ase omoika oria ore ime yao. Erio barabwo bakore emeremo amo naye, erinde tobaisa kobogoria obokong’u bw’okoraa abanto aba aye bweka. ");
INSERT INTO guz_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Kwana n’abanto, obateebie: Echene inwe abanyene ase engencho y’ankio; namonyore chinyama mokoria. Omonene oigure okwereera kwaino na buna mwaboria: Ning’o ogotoa chinyama torie? Ekero twarenge ase ense ya Misiri, nigo twarenge buya. Ase ayio Omonene nache abae chinyama morie. ");
INSERT INTO guz_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Timogochiria ase rituko erimo rioka, gose ase amatuko abere, gose atano, gose ikomi, gose emerongo ebere, ");
INSERT INTO guz_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","korende ’namorie chinyama ase omotienyi omogima goika mochiroke chietere ase chimioro na kobagara‐garia emioyo. Ayio nigo arakoreke, ekiagera mwangire Omonene oria omenyete ase egati yaino, mwarerire ase obosio bwaye na gokwana: Ninki kiagerete tokarua Misiri?” ");
INSERT INTO guz_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa agateebia Omonene, “Abanto aba nkoraa, nigo bare abarwani chilifu amagana atano nomo bagotaara namagoro, naye bono gwateebire ng’a nobae chinyama barie ase omotienyi omogima. ");
INSERT INTO guz_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Inee! Ntonyare konyenya ching’ondi gose chiombe chiisaine abanto aba baegwe barie baigote? Gose ne chinswe chionsi chia nyancha chirasangererigwe, erinde chibaisane?” ");
INSERT INTO guz_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Omonene agateebia Musa, “Inee! Nigo orooche ng’a okoboko kwane nokweng’e? Bono norore gose amang’ana ane naikeranigwe ase ore, gose yaaya.” ");
INSERT INTO guz_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ase ayio Musa akageenda, agateebia abanto amang’ana onsi Omonene akwanete. Agasangereria abagaaka emerongo etan’ebere, nabwo bagatenena agwo goetanana Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Eri’Omonene agaika korwa igoro ore riire ime, agakwana na Musa, na akaa abagaaka baria emerongo etan’ebere korwa ase omoika oria oria orenge ime ase Musa. Ekero omoika oria obete igoro ase bare barabwo bakabana, korende tibagenderera gokora igo naende nonya ndinde. ");
INSERT INTO guz_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Bono abanto babere, Elidadi na Medadi, barabwo bagatigara ase egetwori, na omoika ogaacha igoro ase bare. Igo barenge abamo b’abwo bachoretwe, korende tibageenda agwo ase Eema, na barabwo bakabanera agwo ase egetwori. ");
INSERT INTO guz_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Omonto oyomo omosae akaminyoka ase Musa, akamoteebia, “Elidadi na Medadi ’nkobana bare ase egetwori.” ");
INSERT INTO guz_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yoshua, mosinto o Nuni, nigo arenge omokoreri o Musa korwa ekero arenge omosae. Ere agakwana na Musa, akamoteebia, “Musa Omonene one, bakanie.” ");
INSERT INTO guz_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa akamobooria, “Aye nigo ore neribero ase emeremo y’ane? Ninganetie ng’a Omonene ae abanto bonsi omoika oye, erinde babe ababani.” ");
INSERT INTO guz_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Erio Musa na abagaaka b’Abaisraeli bakairana ase egetwori. ");
INSERT INTO guz_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Omonene akarenta omwaga, na omwaga oyio okarenta chinkware korwa ase enyancha, ogachiruta igoro y’ebitwori gochia ase oboare bw’orogeendo rwe rituko erimo goetania ebitwori chigatorerekana, chikaba chinduenyi gocha igoro koreng’ana ekerengo ki’amaboko abere. ");
INSERT INTO guz_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Abanto bakaimoka, bagasangereria chinkware chiria ase rituko riria rigima, na obotuko bwonsi, naende rituko ria kabere. Oyosangereretie chinke nigo asangereretie chiaisaine goetania ebitonga rigana erimo. Bagachikora emetanda aande onsi ase ebitwori. ");
INSERT INTO guz_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ekero abanto babekire chinyama menwa yabo, na konya batarachimera, Omonene akaba nendamwamu enene ase bare, akabaita ase okobaaka namaakwa amanene mono. ");
INSERT INTO guz_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Aase aaria akarokwa Kibiroti‐Hatawa, ekiagera aroro agwo nao abanto baria barenge abatoonu b’okogania chinyama batindegetwe. ");
INSERT INTO guz_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Abanto bakarua Kibiroti‐Hatawa, bakageenda bagaika Haseroti, bakabeera aroro. ");
INSERT INTO guz_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu na Aroni bagakwana amang’ana arenge mamincha ya Musa, ekiagera Musa konya onyuomire omokungu korwa ase Abaetiopia. ");
INSERT INTO guz_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Bagakwana, bagateeba, “Inee! Omonene nigo agokwana na Musa bweka? Tari gokwana naintwe?” Omonene akaigwa amang’ana ayio. ");
INSERT INTO guz_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Omonto oyio Musa nigo arenge omoitongo mono kobua abanto bonsi barenge ase ense. ");
INSERT INTO guz_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Erio agwo Omonene agakwana na Musa, na Aroni, na Miriamu, akabateebia, “Nimbaganetie inwe batato mochiche agwo ase Eema y’Omosangererekano.” Abwo batato bakageenda aroro. ");
INSERT INTO guz_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Omonene agaika korwa igoro ore ime ase riire riria riare buna esiiro, agatenena agwo ase egesoero ki’Eema eria, akarangeria Aroni na Miriamu. Barabwo bagasuka gochia bosio, ");
INSERT INTO guz_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Eri’Omonene akabateebia, “Igwa amang’ana ane: Onye omobani ore ase egati yaino, inche Omonene nigo ’nkwemanyekania ase are ase okorora, naende nakwana nere ase chindoto. ");
INSERT INTO guz_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Korende ase Musa, omosomba one, taibo, ere nomwegenwa ase enyomba yane yonsi. ");
INSERT INTO guz_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nigo ’ngokwana nere obosio ase obosio, gose tindi gokwana nere ase emerabaaro; ere ororire ekieni kiane. Nase ki inwe motabeete n’obwoba gokwana mamincha ya Musa, omosomba one?” ");
INSERT INTO guz_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Endamwamu y’Omonene ekaba enene ase bare, akarua aroro agwo, akageenda. ");
INSERT INTO guz_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ekero riire riria riaruete ase Eema eria, omobere o Miriamu konya obeire noborwaire bwa ukoma, okaraba se. Aroni akaonchoka komorigereria, akarora ng’a omobere oye obeire noborwaire bwa ukoma. ");
INSERT INTO guz_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Erio Aroni agateebia Musa, “Aye omonene one, koranche, tobaisa gotoa egesusuro, ekiagera intwe nigo twakorire egento ki’oboriri, na twakorire ebibe. ");
INSERT INTO guz_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Totiga Miriamu abe buna oyokuure, buna omonto oiboretwe ne chinyama ekeng’ese, chianiarokeire inda, chiaerire.” ");
INSERT INTO guz_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa akarera ase Omonene, “Aye Nyasae, nagosoroire, koranche ogwenie Miriamu!” ");
INSERT INTO guz_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Korende Omonene akairaneria Musa, “Onye rende ise arenge komotwera amate ase obosio bwaye, Inee, tagwenerete anyore obosooku ase engaki y’amatuko atan’abere? Tiga aatananwe korwa ase egetwori abekwe ase aao ase engaki y’amatuko atan’abere, na magega y’ayio airanigwe ase egetwori.” ");
INSERT INTO guz_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ase ayio Miriamu agasokigwa isiko y’egetwori, akabeekwa ase aao ase engaki y’amatuko atan’abere, na abanto tibaimogete kogeenda goika ekero Miriamu airanete ase egetwori. ");
INSERT INTO guz_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Magega y’ayio abanto bakaimoka kogeenda korwa ase Haseroti, bagaika ase erooro ya Parani, bagatoora aroro. ");
INSERT INTO guz_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Chora omotang’ani oyomo korwa ase kera egesaku ase ebisaku bionsi ikomi na bibere bi’Abaisraeli, erio obatome bagende koroota ense ya Kaanani, ense eria ’ngochia koa Abaisraeli.” ");
INSERT INTO guz_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa agatoma abanto korwa ase erooro ya Parani, buna Omonene amochiigete. Abanto abwo bonsi nigo barenge abatang’ani ase Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Aya naro amarieta abo: Korwa ase egesaku kia Rubeni, Samua, mosinto o Sakuri; ");
INSERT INTO guz_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","korwa ase egesaku gia Simioni, Safati, mosinto o Hora; ");
INSERT INTO guz_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","korwa ase egesaku kia Yuda, Kalebu, mosinto o Yefune; ");
INSERT INTO guz_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","korwa ase egesaku gia Isakaru, Igali, mosinto o Yusufu; ");
INSERT INTO guz_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","korwa ase egesaku kia Efraimu, Hosea, mosinto o Nuni; ");
INSERT INTO guz_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","korwa ase egesaku gia Benjamini, Paliti, mosinto o Rafu; ");
INSERT INTO guz_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","korwa ase egesaku gia Sabuloni, Gadieli, mosinto o Sodi; ");
INSERT INTO guz_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","korwa ase egesaku kia Yusufu (nakio ekia Manase), Gadi, mosinto o Susi; ");
INSERT INTO guz_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","korwa ase egesaku gia Dani, Amieli, mosinto o Gemali; ");
INSERT INTO guz_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","korwa ase egesaku gi’Aseri, Seturi, mosinto o Mikaeli; ");
INSERT INTO guz_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","korwa ase egesaku kia Nafutali, Nabi, mosinto o Bofasi; ");
INSERT INTO guz_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","korwa ase egesaku kia Gadi, Geueli, mosinto o Maki. ");
INSERT INTO guz_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Aya naro amarieta y’ abanto baria Musa atomete gochia koroota ense eria. Musa akaroka Hosea, mosinto o Nuni, Yoshua. ");
INSERT INTO guz_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ekero Musa are kobatoma gochia koroota ense ya Kaanani, akabateebia, “Genda motiire gochia Negebu, ensemo ya Irianyi y’ense eria, naende motiire gochia igoro ase ense y’ebitunwa. ");
INSERT INTO guz_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Morigererie buna ense eria ere, naende morore gose abanto bareo ’mbare ne chinguru, gose naboro bare, gose nabake, gose nabange. ");
INSERT INTO guz_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Naende morore gose ense eria abanto bamenyete nengiya gose nembe, naende morore emechie yabo ase bamenyete, onye nigo ere ebitwori gose nigo egiteire chindwaki. ");
INSERT INTO guz_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Morigererie gose riroba ndire nobotobu gose neritaka, naende gose emete nereo, gose teiyo. Mobe abaremu, morentane okwama kw’amatunda gw’ense eria.” (Engaki eria nigo yarenge ekero emesabibu konya yamire ase ogotongorwa.) ");
INSERT INTO guz_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ase ayio bakageenda bakaroota ense eria, bagachaakera korwa ase erooro ya Sini bagaika Rehobu ase enchera ekogeenda Hamati. ");
INSERT INTO guz_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Bagatiira, bakageenda ritang’ani ase ensemo ya Irianyi y’ense eria, na bagaika Heburoni, agwo ase Ahimani, na Sesai, na Talimai, abanto b’ororeria rw’Anaki, bamenyete. (Heburoni konya oagachirwe emiaka etan’ebere ritang’ani omochie o Soani o Misiri otaraagachwa.) ");
INSERT INTO guz_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Bagaika ase rikura ri’Esikoli, na aroro bakabutora orosagia rw’emesabibu rwabwate egesago ekenene mono, bagasomeka omwaro ase orosagia roria, na abanto babere bakarwambana. Naende bagatwa amakomomanga na amako. ");
INSERT INTO guz_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Aase aria akarokwa Rikura ri’Esikoli ase engencho y’orosagia roria Abaisraeli babutorete korwa aroro. ");
INSERT INTO guz_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ekero amatuko emerongo ene aerire, abanto baria chirooti bakairana korwa ase okoroota ense eria. ");
INSERT INTO guz_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Bakairana gochia ase Musa na Aroni, na ase omoganda bwonsi bw’Abaisraeli agwo Kadeshi ase erooro ya Parani, bakabateebia amang’ana onsi, na bakaborokia okwama gw’ense eria. ");
INSERT INTO guz_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Barabwo bagateebia Musa, “Ntwageenda ase ense eria gwatotomete, ’ntwayenyora ng’a nentenenku ere n’amabeere na amooke, rora okwama gw’ense eria. ");
INSERT INTO guz_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Korende nonya naboigo, abanto bamenyeteo nigo bare ne chinguru, na emechie yabo nemenene mono, naende egiteire bokong’u ne chindwaki. Tari ayio oka, korende boigo ’ntwarora abanto b’ororeria rw’Anaki bare aroro. ");
INSERT INTO guz_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Abaameleki nigo bamenyete ase ense ya Negebu, ensemo ya Irianyi y’ense eria; Abahiti, na Abayebusi, na Abaamori, nigo bamenyete ase ense y’ebitunwa. Abakaanani barabwo nigo bamenyete ase enyancha enene mbarabare, ang’e norooche rwa Yorodani.” ");
INSERT INTO guz_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Korende Kalebu agakiria abanto tibaabaisa koamereria Musa, agateeba, “Tiga togende bwango, erinde toire ense eria, ekiagera intwe ’ntonyare kobua ense eria.” ");
INSERT INTO guz_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Abanto baria bagendete amo nere bagateeba, “Intwe titokonyara korwania abanto baria tobabue; nigo bare ne chinguru gotobua.” ");
INSERT INTO guz_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ase ayio bakarentera Abaisraeli amang’ana amabe igoro y’ense eria bagendete koroota, bagateeba, “Ense eria twataara ime yaye koyeroota, nigo ere ense egoita abanto bamenyeteo. Abanto bonsi twarora nabatambe mono. ");
INSERT INTO guz_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ee, ’ntwarora amamonto, abanto b’ororeria rw’Anaki. Intwe nigo twerora ng’a n’ebimonto ebisinini mono, tore omogwekano bw’ebisase. Naboigo twarorekana ase bare.” ");
INSERT INTO guz_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Erio omoganda bwonsi bw’ abanto bagaaka eriogi rinene, bakaba bakorera ase obotuko boria. ");
INSERT INTO guz_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Abaisraeli bonsi bakaba bakwomania Musa na Aroni; bonsi bagakwana “Nigo anga yaba buya onye ’ntwakwerete Misiri, gose ase erooro eye. ");
INSERT INTO guz_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ninki gekogera Omonene agotoira ase ense eria tochie goitwa ase esegi? Abakungu baito, na abana baito, nigo bagochia gwoswa n’ababisa baito. Naki yare koba buya onye ’ntwairana gochia Misiri.” ");
INSERT INTO guz_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Barabwo bagateebania, “Tochore omonto oyomo abe omoraai oito, toirane Misiri.” ");
INSERT INTO guz_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa na Aroni bagatung’ama inse bakaumama ase obosio bw’omoganda bwonsi bw’Abaisraeli osangererekanete. ");
INSERT INTO guz_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Erio Yoshua, mosinto o Nuni, na Kalebu, mosinto o Yefune, abwo barenge amo ne chirooti chiria chiarootete ense eria, bagatandora chianga chiabo, ");
INSERT INTO guz_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","bagateebia omoganda bwonsi bw’Abaisraeli, “Ense eria twataarete ase okoyeroota nigo ere ense engiya mono. ");
INSERT INTO guz_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Onye Omonene okogokigwa naintwe, na gotoyea toyeire, ense eria n’entenenku ere namabeere naamooke. ");
INSERT INTO guz_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Timobaisa kwanga komoigwera Omonene, na timobaisa koboboa ababiare b’ense eria; abwo nigo barabe buna endagera enyororo ase tore. Baurirwe okorendwa kwabo; Omonene nigo are amo naintwe; timobairoka.” ");
INSERT INTO guz_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Korende omoganda bwonsi ogaaka eriogi, ogateeba ng’a baitwe n’amagena. Erio obonene bw’Omonene bokaoroka mosiabanoagwo ase Eema y’Omosangererekano ase Abaisraeli bonsi. ");
INSERT INTO guz_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Omonene agateebia Musa, “Ngoika ririri abanto aba barabe bagonchaaya? Na ngoika ririri barabe batari konyegena, nonya nakorire ebikone ebinge ase egati yabo? ");
INSERT INTO guz_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nkobaaka inde noborwaire bogoita erinde imbasirie, na aye ’ngokore obe egesaku ekenene, naende kere nokobua goetania abanto aba.” ");
INSERT INTO guz_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Korende Musa akamoiraneria, “Aye nigo kwarusetie abanto aba korwa ase ense ya Misiri ne chinguru chinene. Ekero Abamisiri bonsi baraigwe aya gwakorire ase abanto aba, ");
INSERT INTO guz_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","barabwo ’mbatebie abanto b’ense eye amang’ana ayio. Barabwo konya baigure ng’a aye Omonene nigo ore ase egati y’Abaisraeli, kwarorekanire ase bare obosio ase obosio, ne riire riao nigo riteneine ase bare, naende naye okobatang’ana, omobaso ase riire rire buna esiiro, na obotuko ase omorero ore buna esiiro. ");
INSERT INTO guz_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Bono onye aye kogoita abanto aba bonsi amo, erio abanto b’ebisaku abaraigwe chinkuma chiao ’mbateebe: ");
INSERT INTO guz_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Omonene nigo asinyetwe koira abanto aba ase ense eria konya arire eira akobaa; ase ayio obaiteire ase erooro. ");
INSERT INTO guz_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Bono nagosabire, tiga okobua kwao, aye Omonene, kobe okonene buna aye kwarire eira, kogokwana: ");
INSERT INTO guz_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Inche Omonene tindi omwango bw’okoba n’endamwamu, nigo inde omonyene amaabera, naende nigo inde n’obwanchani botari koera. Nigo ’nkwabera amamocho na ogosaria, korende tingotiga koa abana egesusuro goika ekiaare kia gatato, na egia kane, ase engencho y’amabe y’abaibori baabo. ");
INSERT INTO guz_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ase igo nagosabire, bwabere ebibe bi’abaanto aba koreng’ana nobonene bw’obwanchani bwao botari koera, koreng’ana buna aye kwabaaberete korwa ekero barenge Misiri goika reero iga.” ");
INSERT INTO guz_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Eri’Omonene agateeba, “Nabaabeire koreng’ana buna gwansabire. ");
INSERT INTO guz_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Korende ekeene, buna inche inde moyo, naende buna ense yonsi eraichorwe nobonene bwane, ");
INSERT INTO guz_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","onde tari ase abanto aba orasoe ense eria. Aba barorire obonene bwane na ebikone biria nakorete aaria Misiri, na ase erooro eye, korende nonya naboigo babeire bagonteema ase chingaki echi chionsi, nonya ng’ara ikomi, bangire konyigwera. ");
INSERT INTO guz_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ase barabwo onde tari nonya noyomo, oranyare korora ense eria narierete chisokoro chiabo eira ng’a nimbayee. Onde tari ase abwo banchaayete oranyare koyerora. ");
INSERT INTO guz_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Korende Kalebu, omosomba one, ekiagera abwate omoika ore nogwatananekana korwa ase oyo bwa baria bande, naende obeire okonyigwera buya ase amang’ana onsi, nimoire ase ense eria agendete koroota naende ning’ee abanto b’ororeria rw’aye ense eria ebe eyabo. ");
INSERT INTO guz_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Na bono ekiagera Abaameleki na Abakaanani bamenyete ime ase amakura, inwe ankio moonchoke, mochake koirana gochia ase enchera ekogeenda ase omosomo bw’Enyancha Embariri.” ");
INSERT INTO guz_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Inee! Ngoika ririri omoganda oyo omobe oremurunganie ase ’nde? Naigure Abaisraeli banyemurunganeirie. ");
INSERT INTO guz_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Obateebie ng’a inche Omonene nigo ngoteeba iga: Buna inche inde moyo, naigure amang’ana ayio mwakwanire, ayio naro ndabakorere. ");
INSERT INTO guz_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ekiagera mwemurunganirie ase ’nde, inwe mwensi abamwabarirwe na korikwa, abamwakoorire emiaka emerongo ebere na goetania, nigo morakwe, na emebere yaino ekwete ebeere aiga ase erooro. ");
INSERT INTO guz_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ase ense eria nabarierete eira na gotiana ng’a nimbayee, onde tari ase more orachie komenyao, otatiga Kalebu, mosinto o Yefune, na Yoshua, mosinto o Nuni. ");
INSERT INTO guz_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Korende abana baino, abwo mwateebete ng’a nabooswe, aba nabwo ndaire aroro, na barabwo mbamenye ase ense eria inwe mwangire. ");
INSERT INTO guz_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Korende inwe nigo morakwere aiga ase erooro, na emebere yaino esirere aiga. ");
INSERT INTO guz_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Abana baino nababe abarisia ase erooro eye ase engaki y’emiaka emerongo ene, nabarabwo nabachandeke, ekiagera inwe motabeete abegenwa ase ’nde, mbabe bagochandeka goika omonto bw’omoerio bw’ekegori kiaino akwe, na omobere oye osirere ase erooro eye. ");
INSERT INTO guz_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Inwe nigo morachandeke ase emiaka emerongo ene, omwaka oyomo ase kera rituko mwarenge koroota ense eria, nainwe namonyare komanya ng’a inki gekoba ekero nkoba mamincha yaino. ");
INSERT INTO guz_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ninche Omonene nakwanire. Ekeene ninkore egento eke ase omoganda oyo omobe osangererekanire amo, na obeire mamincha y’ane. Aiga ase erooro ninsirie abanto aba, aa ase erooro nao barakwere.” ");
INSERT INTO guz_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Abanto baria Musa atomete gochia koroota ense eria barentete amang’ana amabe igoro y’ense eria, bakagera omoganda bwonsi okemurungania ase Omonene. ");
INSERT INTO guz_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ase ayio Omonene akabaaka noborwaire bogoita, na barabwo bagakwera agwo ase obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Korende Yoshua, mosinto o Nuni, na Kalebu, mosinto o Yefune, barabwo boka bagatigwa bare moyo korwa ase abanto baria bagendete koroota ense eria. ");
INSERT INTO guz_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa agateebia Abaisraeli amang’ana onsi Omonene akwanete, na abanto bakarera mono nobororo. ");
INSERT INTO guz_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ase emambia ye rituko ria kabere bakaimoka, bagatiira gochia ase ense y’ebitunwa, bagakwana, “Rora twachire, nao tore aa, bono twanchire kogeenda ase ense eri’Omonene atoteebetie. Intwe twakorire ebibe.” ");
INSERT INTO guz_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Korende Musa akabateebia, “Nase ki bono mogosaria ogochika kw’Omonene. Timokonyara konyora ogosesenigwa ase okogeendao. ");
INSERT INTO guz_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Timobaisa kogeenda; moise gokora igo, rirorio nigo mogochia goitwa n’ababisa baino, ekiagera Omonene tari amo nainwe. ");
INSERT INTO guz_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Aroro agwo bosio bwaino Abaameleki na Abakaanani mbareo. Nigo bagochia kobarwania baababue na kobakenya, ekiagera inwe mwaonchokire, mwangire komoigwera Omonene; nere takonyara koba amo nainwe.” ");
INSERT INTO guz_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Korende bagekora abaremu, bagatiira gochia ase ense y’ebitunwa, nonya Esanduki eria yare ne chibao chiriikire okobwatana kw’Omonene yatigarete ase egetwori, na Musa nao atigarete. ");
INSERT INTO guz_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Erio Abaameleki na Abakaanani abamenyete ase ense y’ebitunwa, bagatirimboka bakarwania Abaisraeli abwo, bakababua na kobaseria, bakababwatia goika Horima. ");
INSERT INTO guz_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Kwana n’Abaisraeli, obateebie buna barachie gokora ekero baraike ase ense eria ’ngochia kobaa. ");
INSERT INTO guz_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Bateebie: ’Monyare komoruera Omonene eng’iti korwa ase chiombe, gose korwa ase riicho rie ching’ondi, gose chimbori, chibe ekeng’wanso kegosambwa nomorero, gose ekeng’wanso kende gionsi ase ogoikerania eira mwariete, gose eki’ogwancha kwaino, gose ase chingaki chichiikire ase Amatuko aino Amanene, kebe ne rimisu rigiya rikomogwenera Omonene. ");
INSERT INTO guz_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Oyokorua ebing’wanso buna ebio ase Omonene, goika arue okoruegwa kw’endagera, obosie obonuke ebimunu bibere bwochoganirie n’amaguta egetuba ekemo, ");
INSERT INTO guz_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","n’edivai egetuba ekemo kebe okoruegwa gw’ekenyugwa, amo na kera emanwa y’eng’ondi; onye nekeng’wanso ki’ogosambwa gose ekeng’wanso kende gionsi. ");
INSERT INTO guz_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ekero okorua emingichi ebe ekeng’wanso, orente amo nero obosie obonuke ebimunu bine, bwochoganirie n’amaguta egetuba ekemo na ekeng’ese, bibe okoruegwa kw’endagera. ");
INSERT INTO guz_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ase okoruegwa gw’ekenyugwa morue edivai egetuba ekemo na ekeng’ese ebe rimisu rigiya rikomogwenera Omonene. ");
INSERT INTO guz_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ekero okorua eeri ensae ebe ekeng’wanso ki’ogosambwa, gose ekeng’wanso kende gionsi, onye nase ogoikerania eira kwariete, gose ekeng’wanso ki’omorembe ase Omonene, ");
INSERT INTO guz_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","orue amo n’eeri eria obosie obonuke ebimunu bitan’omo, bwochoganirie n’amaguta ebituba bibere, ");
INSERT INTO guz_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","na orue edivai ebituba bibere ebe okoruegwa gw’ekenyugwa. Okwo n’okoruegwa kogosambwa n’omorero kore ne rimisu rigiya rikomogwenera Omonene. ");
INSERT INTO guz_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Ebinto ebi nabio biraruegwe amo na kera eeri, gose emingichi, gose kera emanwa y’eng’ondi gose ey’embori. ");
INSERT INTO guz_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Buna koreng’ana omobaro bwe ching’iti echio chiraruegwe chibe ebing’wanso oraabe, n’okoruegwa kw’endagera naboigo koraabe. ");
INSERT INTO guz_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Abaisraeli bonsi ababiare nabwo barabwatie omooroberio oyio, ekero bakorua okoruegwa kw’endagera kogosambwa nomorero, kobe risimu rigiya rikomogwenera Omonene. ");
INSERT INTO guz_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Onye omogeni ore amo nainwe, gose omomenyi omenyete ase egati yaino, nere oganetie korenta okoruegwa kwaye kogosambwa n’omorero, kobe rimisu rigiya rikomogwenera Omonene, nigo arabwatie omooroberio oria oria obekirwe ase more. ");
INSERT INTO guz_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ase omosangererekano oyio ogochika nokomo koraabe ase more na ase omomenyi omenyete ase egati yaino. Okwo nakobe ogochika koragenderere botambe, ebiaare ase ebiaare. Buna inwe more, naboigo nomomenyi omenyete ase egati yaino arabe ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ogochika nokomo, na omooroberio noyomo, ase more na ase omomenyi omenyete amo nainwe.” ");
INSERT INTO guz_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Kwana n’Abaisraeli, obateebie: Ekero moraike ase ense eria ase ’ngochia kobaira, ");
INSERT INTO guz_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","na mokoria endagera y’ense eria, morente okoruegwa kogosungusigwa ase Omonene. ");
INSERT INTO guz_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ekero moraroisie omogati korwa ase obosie bw’ogotongora kw’endagera, namoyorente ase Omonene obe okoruegwa kw’ogotongora buna mokomoruera endagera korwa ase ekeooreri kiaino. ");
INSERT INTO guz_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ase ebiaare biaino bionsi morentere Omonene okoruegwa korwa ase obosie bw’ogotongora kwaino. ");
INSERT INTO guz_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Korende nenyare koba ng’a mwamochire kobwatia amachiiko ande onsi Omonene achiikire Musa, ");
INSERT INTO guz_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","gose abanto baino tibarakora onsi ay’Omonene achiikire goetera ase Musa, gochaakera rituko riri’Omonene aruete amachiiko, na kogenderera ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Onye okomocha okwo gwakorirwe ase ogotancha, na ase ogotamanya kw’omoganda bwonsi bw’ abanto, rirorio barue eeri ensae ebe ekeng’wanso ki’ogosambwa kere ne rimisu rigiya rikomogwenera Omonene. Amo nekio barente okoruegwa kw’endagera, na ogw’ekenyugwa, koreng’ana nomoroberio ochiikire, amo negoree eyemo ebe ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Omokuani akore okobwatanigwa ase omoganda bwonsi bw’Abaisraeli, na barabwo ’mbaaberwe, ekiagera okomocha okwo nigo gwakoretwe mosiabano ase ogotancha. Barabwo barentire okoruegwa kwabo, ekeng’wanso kegosambwa nomorero ase Omonene, naboigo barentire ekeng’wanso kiabo ki’ebibe ase Omonene ase engencho y’okomocha kwabo gwakoretwe mosiabano ase ogotancha. ");
INSERT INTO guz_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Naboigo omoganda bwonsi bw’Abaisraeli amo nomomenyi omenyete ase egati yabo, bonsi ’nabaaberwe, ekiagera abwo bonsi nigo baabareretwe okomocha koria gwakoretwe mosiabano ase ogotancha. ");
INSERT INTO guz_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Onye omonto oyomo ogokora ebibe mosiabano atancheti, arue emanwa esubeni yakoorire omwaka oyomo, ebe ekeng’wanso ki’ebibe. ");
INSERT INTO guz_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Omokuani akore okobwatanigwa ase obosio bw’Omonene ase omonto oria okorire ebibe atancheti, na omonto oria naaberwe. ");
INSERT INTO guz_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Nigo moraabe n’ogochika okomo ase oyio okorire ebibe mosiabano, atancheti, karabe omobiare bw’Abaisraeli, gose omomenyi omenyete ase egati yaino. ");
INSERT INTO guz_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Korende omonto orakore gento kende gionsi moeneno, karabe omobiare bw’Abaisraeli, gose omomenyi omenyete ase egati yaino, oyio igo oramire Omonene, ere oyio naatananwe korwa ase abanto baye. ");
INSERT INTO guz_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Oyio ochaayire ring’ana ri’Omonene, naende osaririe ogochika kwaye, takororerwa amaabera. Goika aatananwe kegima, nere abarerwe ebibe biaye.” ");
INSERT INTO guz_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ekero Abaisraeli bagendererete koba ase erooro, omonto oyomo akanyorwa ogotenya chinko ase rituko ri’Esabato. ");
INSERT INTO guz_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Abanto baria bamonyorete bakamoira ase Musa na Aroni, na ase omoganda bwonsi. ");
INSERT INTO guz_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Omonto oria agasiekerwa aase gete akarendwa, ekiagera konya teramanyekana boronge egento agwenerete akorerwe. ");
INSERT INTO guz_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Eri’Omonene agateebia Musa, “Omonto oyio goika aitwe akwe: asokigwe isiko y’egetwori, erio omoganda bwonsi omoake amagena.” ");
INSERT INTO guz_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Abanto bonsi b’omoganda bakamosokia isiko y’egetwori, bakamoaka amagena goika agakwa, buna Omonene achiigete Musa. ");
INSERT INTO guz_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Kwana n’Abaisraeli, obachiike ng’a bakore amasugunia ase emego ye chianga chiabo, babeeke ase kera obosugunia eusi ere buru. Naboigo barakore ebiaare ase ebiaare. ");
INSERT INTO guz_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ekiagera amasugunia ayio nabe ekeinyorio ase more. Ekero mokoyarigereria monyare koinyora amachiiko ane onsi na koyabwata. Naboigo moranyare gokonywa, erinde mobe abegenwa ase ’nde na gwetanga korwa ase okogania okobe gwe chinkoro chiaino na amaiso aino. ");
INSERT INTO guz_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ase igo moinyore na kobwata amachiiko ane onsi, nainwe ’namobe abachenu ase ’nde inche Nyasae oino. ");
INSERT INTO guz_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ninche Omonene Nyasae oino, nabarusetie korwa ase ense ya Misiri, erinde imbe Nyasae oino. Inche ninche Omonene Nyasae oino.” ");
INSERT INTO guz_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora, mosinto o Isari, Omolawi bw’eamate ya Kohati, na Datani, na Abiiramu, basinto b’Eliabu, na Oni, mosinto o Peleti bw’egesaku kia Rubeni, ");
INSERT INTO guz_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","bakabwatana, bakaanga koigwera Musa. Amo nabwo ’mbarengeo abanto bande b’Abaisraeli, amagana abere, namerongo etano. Abwo barenge abaraai bachorire korwa ase omosangererekano, bamanyekanete, naende basikire. ");
INSERT INTO guz_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Barabwo bakabwatana, bakaba mamincha ya Musa na Aroni, bakabateebia, “Bono ayio aisanire. Abanto bonsi b’omoganda oyo nigo bare abachenu; Omonene nigo are amo na kera oyomo. Nase ki rende inwe mweimokereirie igoro na mogwekora abanene igoro y’omosangererekano Omonene?” ");
INSERT INTO guz_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ekero Musa aigwete amang’ana ayio akagwa inse maumama. ");
INSERT INTO guz_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Erio agakwana na Kora na abanto bonsi b’ekeombe kiaye, akabateebia, “Ankio mambia Omonene nache aorokie ng’a ning’o ore oyoye, naende ning’o ore omochenu na ning’o arae ribaga amoike ang’e. Nache arente omonto oyio achorire amoike ang’e. ");
INSERT INTO guz_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ankio mambia moche mokore iga: Aye Kora amo na bonsi abagokobwatia, moimokie chindogio, ");
INSERT INTO guz_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","mwanchare omorero mobekeo, na igoro y’omorero oyio mobeke ubani, naende mochirente ase obosio bw’Omonene. Omonto ori’Omonene arachore, nere oyio oraabe oria omochenu. Inwe Abalawi, bono ayio abaisanire.” ");
INSERT INTO guz_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa akagenderera gokwana na Kora, agateeba, “Bono inwe Abalawi, igwa! ");
INSERT INTO guz_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Inee! Nigo morooche ng’a negento egesinini ase more ng’a Nyasae bw’Abaisraeli obaatananire inwe korwa ase omoganda bw’Abaisraeli, na kobarenta mobe ang’e nere, na komokorera Omonene ase Obomenyo bwaye Obochenu, na gotenenera omoganda bw’ abanto, na kobakorera? ");
INSERT INTO guz_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Omonene nigo akoete aye amo n’Abalawi bamino ribaga mobeere ang’e nere. Inee! Igo mokorigia obokuani boigo? ");
INSERT INTO guz_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Aroni ninki aisaine inwe mwamwemurunganirie mamincha yaye? Ase ayio, mwerende, aye amo na bonsi abagokobwatia. Igo mwasangererekanire mamincha y’Omonene.” ");
INSERT INTO guz_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Erio Musa akarangeria Datani na Abiiramu, basinto b’Eliabu. Barabwo bakairaneria, “Intwe titogocha. ");
INSERT INTO guz_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Inee! Aya namang’ana amagusu ase ore ng’a gwatorusetie korwa ase ense eria entenenku ere n’amabeere n’amooke, na ogatorenta aa, erinde otoite tokwere aa ase erooro eye? Na bono aye nigo ogwekora koba omonene igoro ase tore? ");
INSERT INTO guz_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Naende nonya naboigo, aye totorenteti ase ense eria entenenku ere namabeere na amooke, gose totoeti emiando y’amaremo na emegondo y’emesabibu. Inee! Nigo otagete kobaukoria abanto aba bonsi? Intwe titogocha.” ");
INSERT INTO guz_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa akagechigwa mono, agateebia Omonene, “Tobaisa gwanchera ebing’wanso biabo. Inche tindaira nonya netigere yabo eyemo, gose tindakorera nonya noyomo obo bobe.” ");
INSERT INTO guz_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa agateebia Kora, Ankio aye amo na bonsi abagokobwatia mochiche ase obosio bw’Omonene. Aroni nere nache boigo. ");
INSERT INTO guz_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kera oyomo oino aimokie orogio rw’aye rw’omorero, na arobekere ubani na kororenta ase obosio bw’Omonene. Chindogio chionsi nigo chirabe amagana abere, na merongo etano; naye orente orwao, na Aroni nere arente orwaye.’ ");
INSERT INTO guz_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ase ayio kera omonto akaimokia orogio rw’aye, akarobeka omorero, na igoro yaye ubani, bagaacha bagatenena ase egesoero ki’Eema y’Omosangererekano. Musa na Aroni bagatenenenao boigo. ");
INSERT INTO guz_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Erio Kora agasangereria omoganda bwonsi, na barabwo bagatenena bosio bwa Musa na Aroni agwo ase egesoero ki’Eema eria. Erio obonene bw’Omonene bokaorokera omoganda bwonsi. ");
INSERT INTO guz_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Tigera, morue ase abanto b’omoganda oyo, erinde mbasirie ara rimo.” ");
INSERT INTO guz_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musa na Aroni bagatung’ama inse bakaumama, bagateeba, “Aye ’Nyasae, Nyasae okorua obogima ase abanto bonsi, Inee, omonto oyomo gakorire ebibe, naye igo okogechigwa n’omoganda oyo bwonsi?” ");
INSERT INTO guz_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Kwana n’omoganda bw’ abanto oyoteebie: Tigera morue aase aetanaine chiema chia Kora, na Datani, na Abiiramu.” ");
INSERT INTO guz_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa akaimoka amo nabagaaka b’Abaisraeli, bakageenda ase Datani na Abiiramu. ");
INSERT INTO guz_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Erio agateebia omoganda bwonsi bw’ abanto, “Eatanane, nabasoroire, morue ase chiema chi’ abanto aba abakori amabe. Timobaisa gokuna gento kende gionsi kiabo; moise kogekuna nigo mogochia gosirigwa ase engencho y’ebibe biabo bionsi.” ");
INSERT INTO guz_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ase ayio abanto abwo bageatanana bakarua ase chiema chia Kora, na Datani, na Abiiramu. Datani na Abiiramu bagasoka isiko, amo nabakungu babo na abana babo, abanene na abake, bagatenena ase ebisoero bie chiema chiabo. ");
INSERT INTO guz_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa agateebia abanto, “Ase aya namomanye ’ng’a Omonene ontomire gokora aya onsi, naende ng’a tari inche omonyene nebegete gokora buna inyanchete. ");
INSERT INTO guz_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Onye abanto aba bagochia gokwa buna Mwanyabaanto onde bwensi agokwa, gose bakonyora egesusuro buna Mwanyabaanto onde bwensi akonyora, rirori’Omonene tantometi. ");
INSERT INTO guz_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Korende onye Omonene ogochia gokora egento ekeyia, erinde riroba ritandoke, rimere abanto abwo amo n’ebinto biabo bionsi, na barabwo barimere riroba ime bare moyo, bagende gochia aase abakuure, erio ’namomanye ng’a abanto aba bachaayire Omonene.” ");
INSERT INTO guz_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ekero Musa akoorire gokwana amang’ana aya onsi, riroba rigatandoka inse yabo. ");
INSERT INTO guz_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Riroba rikabwereka, rikabamera, amo ne chiamate chiabo, na abanto bonsi ababwatetie Kora, amo n’ebinto biabo bionsi. ");
INSERT INTO guz_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ase ayio barabwo bonsi bakamerwa bare moyo, bakageenda gochia aase abakuure, boigo n’ebinto biabo, erio riroba rikairanerana, rikabatindeka, na barabwo bagasirigwa bakarua ase omosangererekano oria. ");
INSERT INTO guz_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Abaisraeli bonsi abarenge ang’e nabarabwo bagatama, bakarera, bakobora, “Boigo naintwe riroba ndibaise gotomera.” ");
INSERT INTO guz_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Erio omorero okarua ase Omonene, ogasamba abanto baria amagana abere, na merongo etano, abwo konya barentire ubani. ");
INSERT INTO guz_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Teebia Eleazari, omomura o Aroni Omokuani, ng’a arusie chindogio chiria chi’omorero korwa ase omorero oyio ogwoka, na omorero oyio ayosiare gochia aare. Chindogio chiria chi’omorero konya chiabeire chinchenu. ");
INSERT INTO guz_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Chindogio echio chi’ abanto baria basirete ekiagera bakorete ebibe, tiga chisunyuntwe chiroisigwe, chibe ekemumeko gekomumeka egesasiimero, ekiagera abanto baria nigo bachiruete ase obosio bw’Omonene; ase ayio chindogio echio konya chiabeire chinchenu. Echio nachio ekemanyererio ki’ogokuurera.” ");
INSERT INTO guz_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Nabo Eleazari Omokuani akaimokia chindogio chiria chi’etai, echio abanto baria omorero osambete konya barentire ase obosio bw’Omonene. Echio chikaroisigwa, chikaba ekemumeko ki’egesasiimero. ");
INSERT INTO guz_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ekio gekaba ekemanyererio ki’ogokuurera Abaisraeli, ng’a nonya noyomo otari Omokuani, otari bw’ororeria rwa Aroni, tabaisa goika ang’e gosamba ubani ase obosio bw’Omonene. Aise gokora bo, nasire buna Kora amo n’abanto baria bamobwatetie basirete. Aya onsi nigo akoretwe buna Omonene konya achiikire Eleazari goetera ase Musa. ");
INSERT INTO guz_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Korende rituko ria kabere, omoganda bwonsi bw’Abaisraeli okemurunganeria Musa na Aroni, okabora. “Ninwe mwaitire abanto ba Omonene.” ");
INSERT INTO guz_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ekero omoganda oria konya osangererekanire amo ase okoba mamincha ya Musa na Aroni, barabwo bakeonchora bakarigereria Eema y’Omosangererekano bakarora riire riayetubire, na obonene bw’Omonene bokaoroka. ");
INSERT INTO guz_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musa na Aroni bagaacha bosio bw’Eema eria. ");
INSERT INTO guz_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","N’Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Karue ase omoganda oyo, otigere gochia aare, erio inche ’mbasirie ara rimo.” Musa na Aroni bagatung’ama inse bakaumama. ");
INSERT INTO guz_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa agateebia Aroni, “Imokia orogio rwao rw’ogosambera ubani rusia omorero ase egesasiimero oyobeke igoro yaye, erio obeeke ubani igoro ase omorero oyio, oroimokie ogende bwango ase omoganda bw’ abanto, erinde okore okobwatanigwa ase bare, ekiagera Omonene obeire nendamwamu: amaakwa achakire goita abanto.” ");
INSERT INTO guz_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aroni akaimokia orogio rwa ubani buna Musa amoteebetie, akaminyoka gochia ase egati y’omoganda oria. Amaakwa konya achakire ase egati y’ abanto, korende Aroni akabeeka ubani ase orogio roria, agakora okobwatanigwa ase bare. ");
INSERT INTO guz_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ekero Aroni atenenete gati gati ya baria bakwete na baria barenge moyo, amaakwa aria agatiga goita abanto. ");
INSERT INTO guz_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Abanto konya bakuure nigo barenge chilifu ikomi na inye, na magana atano abere (14,700). Baria bakwete ase ogosaria gwa Kora tibarenge ase omobaro oyo. ");
INSERT INTO guz_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ekero amaakwa atigete goita abanto, Aroni akairana ase Musa agwo ase egesoero ki’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Kwana n’Abaisraeli, obateebie ng’a bakoe chinyimbo chiabo, eyemo ase kera omotang’ani o kera egesaku kiabo, chinyimbo ikomi na ibere, Oriike erieta ria kera oyomo ase enyimbo yaye. ");
INSERT INTO guz_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Oriike erieta ria Aroni ase enyimbo y’egesaku kia Lawi. Kera omotang’ani bwe chiamate chia kera egesaku abe n’enyimbo eyemo. ");
INSERT INTO guz_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Erio obeke chinyimbo echio ime ase Eema y’Omosangererekano bosio bw’Esanduki eria ere ne chibao chiriikire oborori, agwo ase inche ndaumerane nainwe. ");
INSERT INTO guz_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Enyimbo y’omonto oria inche ’ndachoore neseboke. Ase enchera eyio ninkore Abaisraeli batige kwemurungania mamincha y’ane, naende ningere batige kwemurungania mamincha yaino.” ");
INSERT INTO guz_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Musa agakwana n’Abaisraeli, akabateebia amang’ana ayio, na abaraai bonsi be chiamate chia kera egesaku bakamoa chinyimbo chiabo, chinyimbo ikomi na ibere, na enyimbo ya Aroni nigo yarenge ase egati ye chinyimbo chiria. ");
INSERT INTO guz_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa akaira chinyimbo chiria ime ase Eema y’Oborori, agachibekao ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Rituko ria kabere Musa agasoa ase Eema eria y’Oborori, akarora enyimbo ya Aroni, eyatenenerete egesaku kia Lawi, yasebokire, ne chinsagia echio chiasokirie amamumu na ebisicha, naende chiamire amatunda amalozi atobire. ");
INSERT INTO guz_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Erio Musa agachisokia isiko chinyimbo chiria chionsi korwa ase obosio bw’Omonene, agachirenta ase Abaisraeli bonsi. Abwo bagachirigereria, na kera omonto akabogoria enyimbo yaye. ");
INSERT INTO guz_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Omonene agateebia Musa, Irania enyimbo ya Aroni ebeere agwo bosio bw’Esanduki ere noborori, erinde egachwe ebe ekemanyererio ki’ogokuurera abanto batari koigwera. Nabo okirie okwemurungania kwabo ase ’nde, timbaisa koigwa amang’ana buna ayio, mbaise kobaita bakwe. ");
INSERT INTO guz_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Naboigo Musa akorete buna Omonene amochiigete. ");
INSERT INTO guz_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Abaisraeli bagateebia Musa, “Rora, intwe twaikeire omoerio oito, tw akuure, twasirire intwe twensi. ");
INSERT INTO guz_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Kera omonto ogoika ang’e ase Obomenyo bw’Omonene, goika akwe. Inee! Ntwensi pi torakwe?” ");
INSERT INTO guz_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Omonene agateebia Aroni, “Aye na abamura bao amo n’abanto b’eamate yaino nigo morabarerwe okomocha konde gwonsi koraabe kogokorerwa ase obokoreri ime y’Aase Aachenu, naende aye na abamura bao inamobarerwe okomocha konde gwonsi koraabe kogokorwa ase obokuani bwaino. ");
INSERT INTO guz_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Renta Abalawi bamino, egesaku gia iso, barabwo bakore emeremo aroro amo naye. Abwo bagokorere aye amo nabamura bao, ekero mogokora emeremo agwo bosio bw’Eema eria ere noborori. ");
INSERT INTO guz_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Barabwo ’nabagokorere, naende bakore emeremo yonsi ase Eema eria, korende tibaabaisa goika ang’e ase ebikorero ebichenu bi’Aase Aachenu, gose tibaika ang’e ase egesasiimero. Baise gokora igo, aye amo nabarabwo igo morakwe. ");
INSERT INTO guz_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Nigo barabwatane naye na gokora emeremo yabo yonsi y’obokoreri ase Eema y’Omosangererekano. Omonto onde omoao otachiikiri tabaisa goika ang’e akore emeremo amo nainwe. ");
INSERT INTO guz_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Aye amo nabamura bao, ninwe mweka morakore emeremo ime y’Aase Aachenu na ase egesasiimero, erio nario endamwamu yane etabaise koba igoro y’Abaisraeli naende. ");
INSERT INTO guz_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ninche nachorire Abalawi bamino korwa ase Abaisraeli, babe ekeegwa ase more. Barabwo baatananirwe ase ’nde inche Omonene, bakore emeremo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Aye amo nabamura bao, ninwe mweka morakore emeremo yonsi y’obokuani, na emeremo yonsi ase egesasiimero, na eria ere moino y’etoto enachete Obomenyo Obochenu. Nabaeire obokuani buna ekeegwa kebe ekiaino. Onye omonto onde omoao otachiikiri ogocha ang’e ase obokoreri obwo, goika aitwe akwe.” ");
INSERT INTO guz_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Omonene agateebia Aroni, “Rora, nakoeire okoruegwa konde gwonsi gokoruegwa ase ’nde, obe gokorenda. Ebinto bionsi ebichenu Abaisraeli bakorua, ebio nakobieire bibe egetari kiao amo neki’ororeria rwao kogenderera botambe. ");
INSERT INTO guz_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ase ebinto bire ebichenu mono, ebiratigare, bitari gosambwa nomorero, ebiraabe ebiao, nabio ebi: Kera okoruegwa kw’endagera, na kera ekeng’wanso ki’ebibe, na ekeng’wanso gi’okorongeyia okomocha. Ebinto bionsi barabwo barabe bakorua ase ’nde, nabibe ebichenu mono ase ore, na ase abamura bao. ");
INSERT INTO guz_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Noriere ebinto ebio aase gete are aachenu mono. Kera omonto omosacha ore ase more nanyare koria ebinto ebio. Ebio n’ebinto ebichenu ase ore. ");
INSERT INTO guz_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Boigo nakoeire okoruegwa Abaisraeli barabe bakorenta ase ’nde buna ebing’wanso bi’ogosungusia. Nakoeire aye amo nabana bao, abamura na abaiseke, ’nabibe ebiaino kogenderera botambe. Kera omonto ochenegete ore ase enyomba yao nanyare koria ebinto ebio. ");
INSERT INTO guz_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Nakoeire kera ekere ekiya mono ki’ogotongora oko Abaisraeli bakondetera: Amaguta y’amazeituni, na edivai, n’endagera. ");
INSERT INTO guz_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Okwama gwonsi kw’eritang’ani ase ebinto bionsi bigokina ase ense yabo, okwo bakondetera, ’nakobe okwao. Kera omonto ochenegete ore ase enyomba yao nanyare koria ebinto ebio. ");
INSERT INTO guz_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Kera egento Abaisraeli baatananire ase ’nde ’nakebe ekiao. ");
INSERT INTO guz_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Kera omwana omotangi bakorua ase ’nde ’nabe oyoo, na kera eng’iti entangi boigo, korende nonya naboigo bwanche embooria ase omwana omotangi o Mwanyabaanto, na ase chintangi chie ching’iti chiria chitachenegeti. ");
INSERT INTO guz_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Abana baboorigwe ekero bakoorire omotienyi oyomo, ne ching’iti boigo. Aye nobeke rigori ri’okobooria, ribe chisekeli isano chi’echifeta, koreng’ana nesekeli egokorerwa ase Obomenyo Obochenu. (Esekeli eyemo nechigera ibere.) ");
INSERT INTO guz_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Korende ching’iti chintangi chi’echiombe, gose ching’ondi, gose chimbori, tichikoboorigwa. Echio nchiatananwe ase ’nde. Amanyinga abo oyanyororokererie igoro ase egesasiimero, na ebitinya biabo obisambe bibe ekeng’wanso kegosambwa nomorero kere ne rimisu rikongwenera. ");
INSERT INTO guz_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Korende chinyama chiabo amo ne ritaana rigosungusigwa, na ekenama kia borio, echio nachio echiao. ");
INSERT INTO guz_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Ebiegwa bionsi ebichenu Abaisraeli barandetere inche Omonene nakobieire aye amo nabana bao, abamura na abaiseke, bibe ebitari biaino kera ekero. Okwo nokobwatana kw’ogotianania kw’omonyoo gwa kare na kare ase obosio bwane inche Omonene, okwo nakorire naye na ororeria rwao.” ");
INSERT INTO guz_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Naende Omonene agateebia Aroni, “Aye tokonyora omwando bw’orogongo ase egati y’Abaisraeli bande. Tokoegwa ensemo ende yonsi ase egati yabo. Inche ninche ensemo yao, naende omwando oo, ase egati y’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Naeire Abalawi ensemo ya ikomi, eye Abaisraeli bakorua, ebe eyabo, ebe eng’eria ase emeremo eye barabe bagokora agwo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Korwa bono na kogenderera Abaisraeli bande tibaabaisa goika ang’e n’Eema eria. Baise gokora bo, nigo barabe nebibe, erio bakwe. ");
INSERT INTO guz_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Korende Abalawi barabwo nigo barakore emeremo ase Eema y’omosangererekano, okomocha kw’ebibe gokoraabeo nakobarwe igoro ase bare. Okwo nakwo koraabe ogochika ase bare kogenderera ebiaare ase ebiaare. Barabwo tibakoba nomwando ase egati y’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ensemo ya ikomi eye Abaisraeli bakondetera buna okoruegwa kwabo nayeire Abalawi ebe eyabo. Ase ayio, nabateebirie ng’a tibakoba nomwando ase egati y’Abaisraeli bande.” ");
INSERT INTO guz_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Kwana n’Abalawi, obateebie: Ekero mokonyora ensemo ya ikomi korwa ase Abaisraeli, eri’Omonene abaeire ebe eyaino, erio morusie ensemo ya ikomi y’okoruegwa okwo, moyerentere Omonene. ");
INSERT INTO guz_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Okoruegwa okwo inwe morarue, nigo korabarwe ase more buna n’okoruegwa kw’endagera korwa ase ebiooreri biaino, na ogw’edivai na amaguta korwa ase ekemitero, okwo abande bakorua. ");
INSERT INTO guz_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ase enchera eye nainwe morentere Omonene okoruegwa kwaino, okwo mokorusia korwa ase ensemo ya ikomi eria mokonyora korwa ase Abaisraeli. Na okoruegwa okwo gw’enseemo ya ikomi okore kw’Omonene, moe Aroni Omokuani. ");
INSERT INTO guz_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Korwa ase ebiegwa ebio bionsi moranyore korwa ase Abaisraeli, mwatananere Omonene biria bire ebiya mono. ");
INSERT INTO guz_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ase ayio otebie Abalawi: Ekero moraabe mwarure ebinto ebiya mono korwa ase ensemo ya ikomi eria, erio ebinto ebio nigo birabarwe ase more, inwe Abalawi, buna okoruegwa kwaino kw’endagera, na okomitwa gw’edivai, na okw’amaguta. ");
INSERT INTO guz_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Inwe amo n’abanto b’echinka chiaino namoriere ebinto ebio aase aande onsi, ekiagera eyio neng’eria yaino moraakanwe ase emeremo mogokora agwo ase Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ekero mwarure ensemo engiya kobua korwa ase okoruegwa okwo, timokoba nokomocha ase okoria eria entigari. Timobaisa gokora ebinto ebichenu bi’Abaisraeli bibe ebitachenegeti, erinde timokwa.” ");
INSERT INTO guz_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Omonene agakwana na Musa amo na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Oyo n’oro omooroberio inche Omonene nachiikire: Teebia Abaisraeli ng’a barente eng’ombe eaberi embariri etari na kemoa ase omobere oye, naende etana kobekerwa rikorogoto ase ogokorigwa emeremo. ");
INSERT INTO guz_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Orente eng’ombe eria, oyee Eleazari Omokuani; na eng’ombe eria eirwe isiko y’egetwori, erio enyenyerweo ase obosio bwaye. ");
INSERT INTO guz_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazari atobeke ekiara kiaye ase amanyinga y’eng’ombe eria, ayanyororokerie ara gatano nakabere bosio bw’Eema y’Omosangererekano. ");
INSERT INTO guz_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Erio chinyama chi’eng’ombe eria, chisamberwe ase obosio bwaye amo ne riiyo na amanyinga, n’esike. ");
INSERT INTO guz_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Erio Omokuani abogorie oroko rw’emecharake na orosagia rwa hisopo, na eusi embariri, erio abirute as’omorero oria ogosamba eng’ombe eria. ");
INSERT INTO guz_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Erio Omokuani asibie chianga chiaye, esibie omobere boigo namaache. Ekero akoorire gokora bo achiche ase egetwori, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Na omonto oria ogosamba eng’ombe eria goika asibie chianga chiaye, esibie nomobere namaache, ere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Omonto ochenegete abuuche riibu ri’eng’ombe eria, erio ariumore isiko y’egetwori, aase achenire. Riibu erio rigachwe agwo ase engencho y’omoganda bw’Abaisraeli ase ogokorerwa emeremo y’ogochena amaache akonyororokigwa ase okorusia ebibe. ");
INSERT INTO guz_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Omonto oria orabuuche riibu riria, asibie chianga chiaye, nere nabe oyotachenegeti goika omogoroba oyio. Oko nakwo ogochika koragenderere botambe ase Abaisraeli na ase omomenyi omenyete ase egati yabo. ");
INSERT INTO guz_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Monto onde bwensi orakune egetondo, nabe oyotachenegeti ase amatuko atan’abere. ");
INSERT INTO guz_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ase rituko ria gatato, naende ase rituko ria gatan’akabere, omonto oria goika esibie n’amaache, nabe ochenekire; korende onye tagwesibia ase amatuko aya abere takoba oyochenekire. ");
INSERT INTO guz_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Monto onde bwensi orakune egetondo, korende tesibia, igo agokora Obomenyo bw’Omonene bobe obotachenegeti. Omonto oyio aatananwe korwa ase Abaisraeli, ekiagera amaache aria ay’okomochena taumoiri ase are; ere agenderere koba oyotachenegeti. ");
INSERT INTO guz_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Oko nakwo ogochika: Omonto onde bwensi orasoe eema eria ase egetondo kere, na omonto onde bwensi ore imeo, nabe oyotachenegeti ase engaki y’amatuko atan’abere. ");
INSERT INTO guz_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Egekorero kende gionsi kere ase eema eria ime, getabwati egekuneko, korende kere giasie, kiabeire egetachenegeti. ");
INSERT INTO guz_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Omonto onde bwensi oranyore omonto okenyirwe orosana ime, gose okwete ogokwa konde gwonsi, na amokune, gose akune riuga ri’egetondo, gose oboina, omonto oyio nabe oyotachenegeti ase engaki y’amatuko atan’abere. ");
INSERT INTO guz_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Ekiagera babeire abatachenegeti, nabaimokie riibu ike ri’ekeng’wanso ki’ebibe, keria giasambirwe, na kobeeka amaache amaya a rooche igoro ye riibu riria. ");
INSERT INTO guz_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Erio omonto ochenegete aimokie orosagia rwa hisopo, arotobeke ase amaache ayio ime, erio anyororokerie eema n’ebinto bionsi bireo, amo n’abanto barenge imeo. Naende anyororokerie omonto oria okunete riuga, gose okunete omonto oitetwe, gose oyokwete bweka, gose oboina. ");
INSERT INTO guz_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ase rituko ria gatato, na ase rituko ria gatan’akabere, omonto ochenegete anyororokie amaache ase oria otachenegeti. Ase igo ase rituko ria gatan’akabere namochene; ere oria ogochia gochenwa nasibie chianga chiaye, esibie nomobere namaache, na ase engaki ya mogoroba nabe ochenekire. ");
INSERT INTO guz_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Omonto obeire oyotachenegeti, nere tancheti gwesibia, arusigwe ase omosangererekano bw’ abanto. Ere okorire Aase Aachenu a Omonene abeire atachenegeti, ekiagera amaache aria y’okomochena tanyororokeretigwe ase are; ere nigo are oyotachenegeti. ");
INSERT INTO guz_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Oko nakwo ogochika kwa botambe ase bare. Omonto oria okonyororokeria amaache aria y’ogochena asibie chianga chiaye, na omonto onde omoao karakune amaache aria, nere nabe oyotachenegeti goika omogoroba oyio. ");
INSERT INTO guz_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Egento kende gionsi omonto oria otachenegeti arakune nakerokio ’nakebe egetachenegeti. Omonto onde bwensi orakune egento keria nabe oyotachenegeti goika omogoroba oyio.” ");
INSERT INTO guz_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ase omotienyi bw’eritang’ani omoganda bwonsi bw’Abaisraeli ogaika ase erooro ya Sini na gotoora agwo Kadeshi. Miriamu agakwana agatindekwa aroro. ");
INSERT INTO guz_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Amaache tarenge agwo ase batoorete; ase ayio omoganda ogasangererekana amo, okaba mamincha ya Musa na Aroni. ");
INSERT INTO guz_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Abanto baria bakaamerererania na Musa, bagakwana, “Nanga nigo yabeete buya kobua onye naintwe ’ntwakwete ekero abaminto baitetwe agwo ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ninki mwatwegegeretie intwe omoganda Omonene gocha ase erooro eye, erio toche gokwera aiga, amo ne chitugo chiaito? ");
INSERT INTO guz_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ninki mwatorusetie Misiri gocha ense eye yamakweri? Aase aa ataka atari kwama endagera, gose amako, gose amasabibu, gose amakomomanga. Nonya namaache tokonywa tari aa.” ");
INSERT INTO guz_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa na Aroni bakarua agwo ase omoganda oria, bakageenda ase Eema y’Omosangererekano, bagatung’ama inse bakaumama agwo ase egesoero. Erio obonene bw’Omonene bokabaorokera. ");
INSERT INTO guz_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Imokia enyimbo eria, erio aye na Aroni mosangererie omoganda bwonsi, na agwo ase amasio y’ abanto bonsi mokwane negetare keria, na amaache ’nasoke korwa aroro. Ase enchera eyio ’mosokerie abanto amaache yokonywa, ne chitugo chiabo ’nchiyanywe.” ");
INSERT INTO guz_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa akaimokia enyimbo eria korwa aase yarenge, agwo ase obosio bw’Omonene, buna Omonene konya amochiikire. ");
INSERT INTO guz_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa na Aroni bagasangereria omoganda bwonsi bosio bw’egetare keria, akabateebia, “Igwa inwe abasaria aba! Inee! ’Nkobasokeria tore amaache korwa ase egetare eke?” ");
INSERT INTO guz_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Musa akarambora okoboko kwaye, agaaka egetare keria nenyimbo yaye ara kabere. Amaache agasoka amaange mono, na omoganda oria okanywa ne chitugo chiabo chikayanywa boigo. ");
INSERT INTO guz_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Omonene agateebia Musa na Aroni, “Ekiagera inwe motanyegenete na koorokia ase amasio y’Abaisraeli ng’a inche nomochenu inde, timokoraa na goikia omosangererekano oyio ase ense eria ebe eyabo. ");
INSERT INTO guz_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Aya naro amaache a Meriba aase Abaisraeli baamereranetie n’Omonene, na ere akeorokia ng’a nomochenu are ase egati yabo.” ");
INSERT INTO guz_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa agatoma abanto korwa Kadeshi gochia ase omorwoti o Edomu bamoteebie, “Amang’ana aya naro intwe Abaisraeli bamino togoteeba: Nomanyete emechando yonsi yatonyorire, ");
INSERT INTO guz_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","buna chisokoro chiaito chiagendete ase ense ya Misiri, chikamenyao emiaka emenge. Abamisiri bagachichanda ase obotindi obobe, bagatochanda naintwe. ");
INSERT INTO guz_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ekero twarerete ase Omonene, ere akaigwa ebirero biaito, agatoma omomalaika agatorusia korwa ase ense ya Misiri. Bono nao tore aiga Kadeshi, omochie ore ase orobebe kegima rw’orogongo rwao. ");
INSERT INTO guz_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Koranche otoe ribaga toete ase egati y’ense yao. Titokogobera gochia ase emegondo y’endagera, gose ey’emesabibu, gose titokonywa amaache korwa ase chinsoko chiaino. Intwe nigo toraete ase enchera enene yoka, titokogobera gochia ensemo ya borio, gose eya bomosi, goika tobe twaetanirie orogongo rwao.” ");
INSERT INTO guz_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Korende omorwoti o Edomu akamoiraneria, “Timobaisa goeta ase egati y’ense y’ane; moise goeta, nigo ndabarwanie esegi imbaite nemioro.” ");
INSERT INTO guz_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Abaisraeli bakamoteebia, “Intwe nigo toraete ase enchera enene yoka, na gatoranywe amaache ao, intwe gose chitugo chiaito, rirorio ’natoakane amaache ayio. Toe ribaga toete rioka namagoro, titokogania gento kende goetania ekio.” ");
INSERT INTO guz_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Abaedomu bakairaneria naende, “Timori ne ribaga goeta ase ense yaito.” Bagacha nabarwani barenge ne chinguru gocha korwania Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ekiagera Abaedomu barinete Abaisraeli ribaga goeta ase ense yabo, Abaisraeli bakarua ase bare, bagaeta ensemo eng’ao. ");
INSERT INTO guz_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Omoganda bwonsi bw’Abaisraeli okarua Kadeshi, okageenda ogaika egetunwa kia Hori. ");
INSERT INTO guz_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Agwo ase egetunwa keria kia Hori, ase orobebe rw’ense ya Edomu, Omonene agakwana na Musa na Aroni, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aroni nakwe, asangererekane amo n’abanto baye. Ere tagosoa ase ense eria naeire Abaisraeli, ekiagera inwe babere mwasaretie, timwanyigwera buna nabachiigete agwo ase amaache a Meriba. ");
INSERT INTO guz_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ira Aroni na Eleazari, momura oye, igoro ase egetunwa kia Hori. ");
INSERT INTO guz_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Orusie Aroni chianga chiaye chi’obokuani, ochibekere Eleazari, momura oye. Aroni ere ’nakwe, na asangererekane amo n’abanto baye, ekero more aaria.” ");
INSERT INTO guz_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa agakora buna Omonene amochiigete. Barabwo bagatiira gochia igoro as egetunwa keria kia Hori, ekero omoganda bwonsi origereretie. ");
INSERT INTO guz_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa akarusia Aroni chianga chiria chi’obokuani, agachibekera Eleazari, momura o Aroni. Aroni agakwera ase egetunwa keria, na Musa na Eleazari bagatirimboka korwao. ");
INSERT INTO guz_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ekero omoganda bw’Abaisraeli orooche ng’a Aroni okuure bakamoreera ase engaki y’amatuko emerongo etato. ");
INSERT INTO guz_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ekero omorwoti oyomo Omokaanani, oyorenge kogaamba agwo Aradi, ensemo ya Irianyi ase ense ya Kaanani, aigwete ng’a Abaisraeli nigo bare ase enchera ekogeenda Atarimu, akabaumokera, akabarwania, na agoosa abande babo. ");
INSERT INTO guz_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Erio Abaisraeli bakariera Omonene eira, bakaboora, “Aye koraabeeke abanto aba ase amaboko aito, intwe natosirie emechie yabo kegima.” ");
INSERT INTO guz_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Omonene akaigwa ogosaba kw’Abaisraeli, akabaa obobui igoro y’Abakaanani. Abaisraeli bakabasiria kegima, bagasaria emechie yabo. Ase ogokora oko, aase aria akarokwa Horima. ");
INSERT INTO guz_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Abaisraeli bakarua ase egetunwa keria kia Hori, bakageenda orogeendo rwabo, bagaetera enchera ekogeenda gochia omosomo bw’Enyancha Embariri, erio bachie goetanana ense ya Edomu. Abanto tibaaba abaremereria ase ogoeta enchera eria. ");
INSERT INTO guz_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Bakemurunganeria Nyasae na Musa, bakaboora, “Ninki mwatwegegeretie korwa ase ense ya Misiri mogatorenta toche gokwera aiga aase erooro? Aiga endagera na amaache tibiiyo, intwe twagechiigwe nendagera eye embe.” ");
INSERT INTO guz_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Eri’Omonene agatoma ching’iti chingeenda inse chire nobosongo chigaacha ase egati y’Abaisraeli, chikabaroma, na abanto abange bagakwa. ");
INSERT INTO guz_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Abanto bakageenda ase Musa, bakamoteebia, “Twakorire ebibe, ekiagera twakwanire mamincha y’Omonene na ase ore. Koranche osabe Omonene arusie ching’iti echi ase tore.” Ase ayio Musa akabasabera. ");
INSERT INTO guz_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Eri’Omonene agateebia Musa, “Roisia omogwekano bw’eng’iti korwa ase etai, erio oyebeke igoro ase omote, erinde kera omonto oromirwe neng’iti kararigererie eng’iti eria nabe moyo.” ");
INSERT INTO guz_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Musa akaroisia eng’iti y’etai, akayebeka igoro ase omote, na monto onde bwensi konya oromirwe neng’iti, onye orenge koyerigereria eng’iti eria, nigo arenge koba moyo. ");
INSERT INTO guz_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Abaisraeli bakaimoka kogeenda orogeendo rwabo, bagaika Oboti, bagatoora aroro. ");
INSERT INTO guz_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Naende bakarua agwo Oboti, bakageenda bagaika Iye‐Abarimu, agwo ase erooro ere moocha ya Moabu, bagatoora aroro. ");
INSERT INTO guz_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Na korwa aroro bakageenda bagaika ase Rikura ria Seredi, bagatoora aroro. ");
INSERT INTO guz_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Magega y’ayio bakaimoka korwa Seredi, bakageenda bagatoora sugusu y’orooche rw’Arinoni, ase erooro eria eigete orobebe rw’Abaamori. Arinoni nigo rware orobebe gati y’Abamoabu na Abaamori. ");
INSERT INTO guz_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Aya naro akogera “Egetabu gi’echisegi chi’Omonene” yakwana igoro ya “Omochie bw’Abahebu ase orogongo rwa Sufa, na amakura ase orooche rw’Arinoni rogoeta, ");
INSERT INTO guz_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","na egetirimboko ki’amakura, aase omochie bw’Ari ore, na gochia orobebe rwa Moabu.” ");
INSERT INTO guz_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Na korwa ase Arinoni bakagenderera n’orogeendo rwabo, bagaika Beeri. Eyio nensoko eria aase Omonene atebeetie Musa, “Sangereria abanto, na inche nimbae amaache banywe.” ");
INSERT INTO guz_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Erio Abaisraeli bagatera ogoteera oko: “Chinsoko, sokia amaache acharaare gocha, naintwe togoke na goteera ase amaache ayio. ");
INSERT INTO guz_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Chinsoko abanene baremete, echio chiaremetwe nenyimbo y’omogaambi, ne chinyimbo chiabo chi’ogotaarera.” Korwa agwo ase erooro bakageenda bagaika Matana, ");
INSERT INTO guz_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","na korwa Matana bakageenda bagaika Nahalieli, na korwa agwo bakageenda bagaika Bamoti. ");
INSERT INTO guz_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bakarua Bamoti, bakageenda gochia ase rikura riarenge ase ense y’Abaamori, ase egetirimboko ki’egetunwa gia Pisiga, ekio kerochie maate ase erooro. ");
INSERT INTO guz_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Korwa aroro agwo Abasiraeli bagatoma abanto ase Sihoni, omorwoti bw’Abaamori bakwane nere, bamoborie, ");
INSERT INTO guz_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Koranche, otoe ribaga toete ase egati y’ense yao. Titogotiga enchera na kogobera gochia ase emegondo y’endagera, gose ey’emesabibu, gose titokonywa amaache korwa ase chinsoko chiaino, korende nigo toraete ase enchera enene goika tobe twaetanirie ense yaino.” ");
INSERT INTO guz_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Korende Sihoni akaanga koa Abaisraeli ribaga baete ase ense yaye. Agasangereria abarwani baye b’esegi, akageenda agaika Yahasi ase erooro, na agwo akarwania Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Korende Abaisraeli bagakenya abanto abange, bakaira ense ya Sihoni, korwa orooche rw’Arinoni goika orooche rwa Yaboki ase ense y’Abaamoni. Ribebe ri’Abaamoni nigo riarendire ne chinguru. ");
INSERT INTO guz_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Abaisraeli bakaira emechie yonsi y’Abaamori, bakaira na Hesiboni, erio bakamenya ase emechie amo nebichie bi’emechie eyio. ");
INSERT INTO guz_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesiboni n’oro orenge omochie omonene o Sihoni, omorwoti bw’Abaamori, oria konya orwanirie omorwoti orenge kogambera Abaamori agwo ritang’ani. Sihoni konya oirire ense yonsi y’omorwoti oyio goikera Arinoni. ");
INSERT INTO guz_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ayio naro akogera abateri be chingero bakobora: “Inchuo ase Hesiboni, tiga omochie oyo oagachwe, tiga omochie o Sihoni oagachwe na kogitwa. ");
INSERT INTO guz_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Omorero okarua ase Hesiboni, chimeme chi’omorero korwa omochie o Sihoni, ogasaria Ari, omochie o Moabu, ogasamba abanene b’ebigoro bi’Arinoni. ");
INSERT INTO guz_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Obobe nobwaino, inwe Abamoabu! Mwasirigwe, inwe abamogosasiima Kemosi! Nere otigire abana baino abamura bagotama, bakorigia aase bakwebisa, na abana baino abaiseke boosirwe, barabwo bairirwe ase Sihoni, omorwoti bw’Abaamori. ");
INSERT INTO guz_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Intwe twabarasire chinsara; Abahesiboni basiriigwe, twabaitire goika Diboni. Tokabasiria goika Nofa na korwa Nofa goika Medeba.” ");
INSERT INTO guz_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ase igo Abaisraeli bakamenya ase ense y’Abaamori. ");
INSERT INTO guz_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa agatoma chirooti gochia koroota omochie o Yaeseri. Abaisraeli bakayorwania, bakayoira amo nebichie biaye, bakabang’anyia Abaamori bamenyeteo. ");
INSERT INTO guz_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Abaisraeli bakairana, bagaetera ase enchera yarenge kogeenda Basani. Ogi, omorwoti o Basani, agacha amo nabarwani baye korwania Abaisraeli agwo Edirei. ");
INSERT INTO guz_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Korende Omonene agateebia Musa, “Tobaisa komoiroka, ekiagera namobekire ase okoboko kwao, ere amo n’abanto baye bonsi, na ense yaye. Aye goika omokore buna gwakorete Sihoni, omorwoti bw’Abaamori, oria omenyete agwo Hesiboni.” ");
INSERT INTO guz_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Abaisraeli bagaita Ogi, bagaita nabana baye abamura, na abanto baye, goika tibatigaria nonya nomonto oyomo ore moyo. Erio bakayeira ense yaye ekaba eyabo. ");
INSERT INTO guz_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Abaisraeli bakagenderera norogeendo rwabo gochia ase enyancha enyomo ya Moabu, bagatoora aroro, moocha ya Yorodani, kororia Yeriko. ");
INSERT INTO guz_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Omorwoti Balaki, mosinto o Sipori, akaigwa amang’ana onsi Abaisraeli konya bakoreire Abaamori. ");
INSERT INTO guz_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Abamoabu bakoboa abanto abwo mono, ekiagera nigo barenge abange; ee Abamoabu bakabegosera Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Abamoabu bagateebia abagaaka ba Midiani, “Omoganda oyo omonene nigo ogochia komena okoore kera egento getoetanaine aiga, buna chintang’ana chikomena obonyansi ase egetii chiabokoora.” Ase engaki eria Balaki, mosinto o Sipori, nere orenge omorwoti bw’Abamoabu. ");
INSERT INTO guz_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ere agatoma abanto ase Baalamu, mosinto o Beori, agwo Petori ore ang’e norooche rw’Eufarati, ase ense yabo. Barabwo bakamoteebia amang’ana a Balaki. “Rigereria, abanto bachire korwa ase ense ya Misiri, nabarabwo nabange, batubete orogongo rwonsi, batoorire ang’e naintwe, barigereretie ense yane. ");
INSERT INTO guz_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Bono inchwo obandagererie, ekiagera barabwo nigo bare ne chinguru chinyinge gotobua. Gokobaragereria, ande nabo ndabaise kobarwania mbabue na kobaseria, barabwo barue ase ense y’ane. Nimanyete ng’a oyo aye ogosesenia, nigo agoseseneka, na oyo aye okoragereria, nigo akoragerereka.” ");
INSERT INTO guz_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Abagaaka ba Moabu na ab’Abamidiani bakabogoria eng’eria y’okoringoreria ase amaboko abo, bakayeirera Baalamu, bakamoteebia amang’ana onsi a Balaki. ");
INSERT INTO guz_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Baalamu agateebia abanto baria, “Rara aa ase obotuko obo, nainche nimbarentere amairanerio korwa ase Omonene ankio mambia.” Ase ayio abanene baria ba Moabu bakabeera aroro amo na Baalamu. ");
INSERT INTO guz_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nyasae agacha ase Baalamu, akamobooria, “Abanto abamore komo mbarabi?” ");
INSERT INTO guz_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Baalamu akamoiraneria, “Balaki, mosinto o Sipori, omorwoti o Moabu, nere otomire abanto aba ase ’nde, ogoteeba ng’a ");
INSERT INTO guz_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","abanto bachire korwa ase ense ya Misiri, na barabwo nigo bare abange, batubete orogongo rwonsi. Ere nigo aganetie imbaragererie, erinde abarwanie, ababue na kobaseria.” ");
INSERT INTO guz_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nyasae akamoiraneria, “Tobaisa kogeenda amo nabarabwo gose gochia koragereria Abaisraeli. Barabwo nigo basesenirie.” ");
INSERT INTO guz_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ase ayio Baalamu akaimoka mambia rituko ria kabere, agateebia abanene baria batometwe na Balaki, “Bono inwe irana mogende ase ense yaino, ekiagera Omonene bwangire kong’a ribaga ngende amo nainwe.” ");
INSERT INTO guz_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ase ayio, abanene baria ba Moabu bakaimoka bakageenda ase Balaki bakamoteebia, “Baalamu nigo aanga, tacheti amo naintwe.” ");
INSERT INTO guz_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Naende Balaki agatoma abanene bande, abange kobua baria b’eritang’ani, naende ababwate amasikani amanene kobua abwo. ");
INSERT INTO guz_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nabarabwo bagaacha ase Baalamu, bakamoteebia, “Aya naro Balaki, mosinto o Sipori, agoteeba: Koranche totiga kende gionsi kegotange tochicha. ");
INSERT INTO guz_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ekeene, inche nigo ’ngochia kogokorera aya arakorentere amasikani amanene, naende kende gionsi oramborie, ekio ningokorere; aye inchwo ondagererie abanto aba.” ");
INSERT INTO guz_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Korende Baalamu akairaneria abasomba baria ba Balaki, akabateebia, “Nonya Balaki arenge kong’a enyomba yaye eichire chifeta ne chitaabu, tintageti gosaria na kwanga koigwera amang’an’Omonene Nyasae anchiikire, na gokora amang’ana ande ase ogwancha kwane, abe amake gose amanene. ");
INSERT INTO guz_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nababoririe komoranche, mobeere aa ase obotuko bwa reero, erio imborie Omonene, imanye gose nabwate amang’ana ande aranteebie.” ");
INSERT INTO guz_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Naende Nyasae agacha ase Baalamu ase obotuko boria, akamoteebia, “Onye abanto aba bachire gokorangeria, imoka ogende amo nabarabwo, korende egento ndagochiike nakio gioka orakore.” ");
INSERT INTO guz_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Baalamu akaimoka mambia rituko ria kabere, akaberekia etigere yaye egeikaransero, akageenda amo nabanene baria ba Moabu. ");
INSERT INTO guz_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ekero Baalamu aimogete kogeenda amo nabasomba baye babere oriinete etigere, Nyasae akaba nendamwamu enene ase are; na omomalaika Omonene agatenena ase enchera gati komotanga tageenda. ");
INSERT INTO guz_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Etigere eria egachia korora omomalaika oria obwate omoyio o birende koboko kwaye, ekagobera gochia enchera ensemo, ekageenda ase omogondo. Baalamu agaaka etigere eria koyeirania ase enchera. ");
INSERT INTO guz_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Naende omomalaika oria Omonene akageenda ase enchera yarenge engote gati y’emegondo y’emesabibu, ne chimbago nchiarenge ase chinsemo chionsi ibere. ");
INSERT INTO guz_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Etigere eria egachia korora omomalaika oria Omonene, ekemigereria gochia orobago ang’e, ekabwaterania okogoro kwa Baalamu ase orobago, na Baalamu akayeaka naende. ");
INSERT INTO guz_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Erio naende omomalaika Omonene akageenda bosio, agatenena aase aagote mono, ase ribaga ritarenge ri’okogobera gochia ensemo ya borio, gose eya bomosi. ");
INSERT INTO guz_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ekero etigere yarooche omomalaika oria, ekarara inse, na Baalamu oyeriinete mogongo igoro. Baalamu akaba nendamwamu enene mono, agaaka etigere eria nenyimbo yaye. ");
INSERT INTO guz_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Eri’Omonene agakunora omonwa bw’etigere eria goika egakwana, ekaboria Baalamu, “Ngento ki nagokoreire goika kwang’akire chintunda echi isato?” ");
INSERT INTO guz_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Baalamu akayeiraneria, “Nekiagera gwankoreire echeche. Onye nabwate omoro ase okoboko kwane, nanga nigo narenge kogoita.” ");
INSERT INTO guz_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Naende etigere ekaboria Baalamu, “Inee! Inche tindi etigere yao, kwabeire gokondiina ase amatuko y’obogima bwao bwonsi goika rituko eri ria reero? Inee! Inche nana‐gokora egento buna eke ase ore?” Baalamu akairaneria, “Yaya.” ");
INSERT INTO guz_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Eri’Omonene akaramokia Baalamu amaiso, na ere akarora omomalaika Omonene oteneine ase enchera gati, obwate omoyio o birende ase okoboko kwaye. Baalamu agekumba, agatung’ama inse, akaumama. ");
INSERT INTO guz_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Omomalaika Omonene akaboria Baalamu, “Nase ki gwaakire etigere yao chintunda echi isato? Rora, inche nigo nacha kogotanga, ekiagera orogeendo oro okogeenda norw’ogosaria rore mamincha yane. ");
INSERT INTO guz_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Korende etigire ero yandora, nero yeonchora gochia enchera ensemo chintunda isato. Ekeene, onye etigere eye eteonchora gochia ensemo korwa asende, nanga nigo nagoita okwe, ntige etigere ere moyo.” ");
INSERT INTO guz_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Erio Baalamu agateebia omomalaika Omonene, “Inche nakorire ebibe, tinamanyete ng’a naye gwateneine gati y’enchera gontanga. Korende bono onye orogeendo rokororekana ng’a norobe ase ore, tiga ing’irane.” ");
INSERT INTO guz_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Omomalaika Omonene agateebia Baalamu, “Genda amo n’abanto abwo, korende amang’ana aria ndagochike, naro oka ogochia gokwana.” Bono Baalamu akageenda amo nabanene baria ba Balaki. ");
INSERT INTO guz_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ekero Balaki aigwete ng’a Baalamu inchera are gocha, akageenda komoorototera agwo Ari, omochie orenge ang’e norooche rw’Arinoni, ase orobebe rwa Moabu. ");
INSERT INTO guz_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki akaboria Baalamu, “Inee! Naki otachete ekero natomete abanto gokorangeria? Nase ki otachete? Nigo gwakagete ng’a tingocha gokoa ogosika kogoisaine?” ");
INSERT INTO guz_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Baalamu akamoiraneria, “Rora, bono nachire ase ore, nigo okagete ng’a inche nimbwate okobua nonya nogoke gokwana ring’ana ase ore? Ring’ana riria Nyasae aranteebie nario ndakwane.” ");
INSERT INTO guz_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Erio Baalamu akageenda amo na Balaki, bagaika Kiriati‐Husoti. ");
INSERT INTO guz_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki akanyenya chiombe ne ching’ondi, akaa Baalamu amo nabanene barenge amo nere. ");
INSERT INTO guz_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Rituko ria kabere mambia Balaki akaira Baalamu igoro ase Bamoti‐Baali, na korwa igoro agwo Baalamu akarora ensemo eyemo y’omoganda bw’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Baalamu akamoteebia Balaki, “Ng’agachere aiga ebisasimero bitano na bibere, naende ondetere chieri isan’aibere, ne chimingichi isan’aibere.” ");
INSERT INTO guz_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki agakora buna Baalamu amoteebetie, na abwo babere bakarua ekeng’wanso igoro ase kera egesasiimero, eeri eyemo na emingichi eyemo. ");
INSERT INTO guz_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Baalamu agateebia Balaki, “Beera aa, otenene mbarabare ase ekeng’wanso kiao ki’ogosambwa; inche ’ngende korora gose ande Omonene nang’orokere. Kende gionsi aranteebie, ekio nakio ndagoteebie.” Baalamu agatiira gochia egetunwa igoro aarabu. ");
INSERT INTO guz_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nyasae agaika korwa igoro, akaumerana na Baalamu. Baalamu akamoteebia, “Naagachire ebisasimero bitano na bibere, naende narure igoro ase kera ekemo eeri eyemo na emingichi eyemo.” ");
INSERT INTO guz_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Omonene agateebia Baalamu ring’ana agochia gokwana. Naende akamotoma airane ase Balaki namang’ana ayio ayio. ");
INSERT INTO guz_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Baalamu akairana gochia ase Balaki, akamonyora oteneine mbarabare ase ekeng’wanso kiaye ki’ogosambwa, amo nabanene bonsi b’Abamoabu. ");
INSERT INTO guz_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Baalamu agakwana obobani bwaye, agateeba: “Balaki, omorwoti o Moabu, ondetire korwa Siiria, korwa ase ebitunwa bia Moocha, oteebire: Inchuo, ondagererie abanto ba Yakobo, inchwo ogambie Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Naki ’ndakore ndagererie oyo Nyasae ataragerereti? Naki ’ndakore ’ngambie oy’Omonene atagambeti? ");
INSERT INTO guz_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Korwa aiga ase ebitare igoro nimbarooche, na korwa aiga ase ebitunwa nimbarigereretie. Abwo n’abanto bamenyete boka, beatananire korwa ase abanto b’ebisaku. ");
INSERT INTO guz_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ning’o oranyare kobara ororeria rwa Yakobo, abwo bare abange buna orotu rw’amaroba? Gose ning’o oranyare kobara nonya nenseemo ya inye y’Abaisraeli? Tiga inkwe buna oyomo bw’abanyene oboronge, na omoerio bw’amatuko ane obe buna oyoobo.” ");
INSERT INTO guz_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki akaboria Baalamu, “Ngento ki eke aye gwankoreire? Nigo nakorangeretie ng’a oche obaragererie ababisa bane, na rora, ribaga ri’ayio kwabasesenirie.” ");
INSERT INTO guz_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Baalamu akamoiraneria, “Inee! Tiyangwenerete inyigwere na gokwana amang’ana ari’Omonene agonteebia nkwane?” ");
INSERT INTO guz_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki akamoteebia, “Inchuo, togende amo naye goika aase ande aao. Korwa aroro nonyare korora abare ang’e. Tokorora bonsi. Korwa aase agwo nobandagererie.” ");
INSERT INTO guz_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Akamoira goika ase omogondo o Sofimu agwo ase egechuria gia Pisiga. Agwo Balaki akaagacha ebisasimero bitano na bibere, akarua eeri eyemo na emingichi eyemo igoro ase kera egesasiimero. ");
INSERT INTO guz_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Baalamu agateebia Balaki, “Beera aa, otenene ensemo y’ekeng’wanso kiao ki’ogosambwa inche ’ngende aaria ng’umbu, toumerane n’Omonene.” ");
INSERT INTO guz_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Omonene akamoorokera Baalamu, akamoteebia amang’ana arenge gochia gokwana, naende akamotoma airane ase Balaki namang’ana ayio ayio. ");
INSERT INTO guz_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Baalamu akairana gochia ase Balaki, akamonyora oteneine mbarabare ase ekeng’wanso kiaye ki’ogosambwa, na abanene b’Abamoabu bateneine agwo amo nere. Balaki akamobooria, “Mang’ana ki Omonene akwanire?” ");
INSERT INTO guz_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Baalamu agachaaka gokwana obobani bwaye, agateeba, “Inchuo aye Balaki, omwana o Sipori, ontegerere oigwe aya ’ngokwana! ");
INSERT INTO guz_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Nyasae tari omonto, erinde akwane oborimo, gose tari Mwanyabaanto, erinde anyare koonchoka. Inee! Aya akwanire, takonyara koyakora? Gose, aya ateebire, takonyara koyaikerania? ");
INSERT INTO guz_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Rora, inche nigo nachigetwe ng’a ’nsesenie; na ekero Nyasae asesenirie, inche tinkonyara koirania ogosesenigwa okwo. ");
INSERT INTO guz_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ere tarochi obobe ase Yakobo, tarochi bokong’u bonde ase Abaisraeli. Omonene, Nyasae obo, nigo are amo nabarabwo, igo bakoraria nomochengo ng’a omorwoti nareo. ");
INSERT INTO guz_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nyasae nere obarentire korwa Misiri; barabwo nigo babwate chinguru buna echi’eng’era. ");
INSERT INTO guz_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Oborogi tibogokora gento ase abanto ba Yakobo, gose oboriori ase Abaisraeli. Nakwanwe igoro y’ abanto ba Yakobo, nabwo Abaisraeli: Rora aya Nyasae akorire! ");
INSERT INTO guz_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Rigereria abanto abwo nigo banga buna endo eaberi ekoboka, na buna endo ekoimokerera igoro, teri korara goika eraria echi yatwarire, goika eranywa amanyinga ay’echi yaitire.” ");
INSERT INTO guz_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Naende Balaki agateebia Baalamu, “Bono tobaisa kobaragereria, gose tobaisa kobasesenia nonya ng’ake.” ");
INSERT INTO guz_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Korende Baalamu akamoiraneria, “Tinagoteebia ng’a amang’ana onsi Omonene agonteebia, ayio naro ’ndakore?” ");
INSERT INTO guz_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki agateebia Baalamu, “Bono inchwo ’nkoire aase ande aao. Aande gose Nyasae nanche obandagererie korwa aroro.” ");
INSERT INTO guz_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ase ayio Balaki akaira Baalamu gochia ase egechuria ki’egetunwa gia Peori, bakarigereria erooro inse. ");
INSERT INTO guz_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Baalamu akamoteebia, “Ng’agachere aiga ebisasimero bitano na bibere, na ondetere chieri isan’aibere, ne chimingichi isan’aibere.” ");
INSERT INTO guz_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki agakora buna atebetigwe, akarua eeri eyemo amo n’emingichi eyemo ase kera egesasiimero. ");
INSERT INTO guz_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ekero Baalamu arooche ng’a Omonene nigo amoganetie asesenie Abaisraeli tagendete naende ase okorigia oboringoria buna chingaki chiria chi’eritang’ani, korende akaonchora obosio bwaye gochia ase erooro. ");
INSERT INTO guz_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Agachia koimokia amaiso, aye, akarora Abaisraeli batoorete egesaku ase egesaku. Erio Omoika o Nyasae ogaacha igoro ase are. ");
INSERT INTO guz_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Agwo Baalamu agakwana obobani obo: “Amang’ana aya naro inche Baalamu, mosinto o Beori, ’ngokwana amang’ana aya nay’ane, inche omonto oramokiigwe amaiso. ");
INSERT INTO guz_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Aya namang’ana y’omonto okoigwa buya aya Nyasae agoteeba, oyo okorora amaroro akorwa ase ere oria Omonguru, oyogotung’ama inse na koramokigwa amaiso aye. ");
INSERT INTO guz_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Inwe abanto ba Yakobo, chiema chiaino naki chire chingiya! Inwe Abaisraeli aase momenyete, naki are aagiya mono! ");
INSERT INTO guz_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Igo mogwekaine omweya orambogete gochia aare, gose emegondo ere mbarabare y’orooche, nigo more buna emegaka Omonene asimegete. Gose emecharake ere ase amaache mbarabare. ");
INSERT INTO guz_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Amache amaange naiteke korwa ase chinyongo chiabo na oroiboro rwabo nigo roraabe oronge mono. Omorwoti obo nabe omonene goetania Agagi, na oborwoti bwaye inabotogigwe mono. ");
INSERT INTO guz_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Nyasae nere obarentire korwa Misiri, chinguru chiabo nigo chire buna echi’eng’era. Barabwo mbasirie abanto abare mamincha yabo, babune amauga y’emebere y’ababisa babo, na baabarase ne chinsara chiabo. ");
INSERT INTO guz_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Abaisraeli nigo batung’aime inse buna endo, buna endo eaberi, ning’o oraabe noboremu abature? Asesenigwe omonto oria okobasesenia inwe, na aragererigwe omonto oria okobaragereria inwe.” ");
INSERT INTO guz_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ase amang’ana ayio Balaki akaba n’endamwamu enene ase Baalamu, agaaka chinkobi, akamoteebia, “Nigo nakorangeretie ng’a oragererie ababisa bane, na rora, bono aye kwabasesenirie chintunda echi isato. ");
INSERT INTO guz_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Bono irana gochia bwoo. Inche igo narengereretie gokoa ogosika okonene, korende Omonene okorinire, tonyora ogosikwa okwo.” ");
INSERT INTO guz_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Baalamu agateebia Balaki, “Inee! Tinateebetie abanto baria gwatomete ase inde ng’a ");
INSERT INTO guz_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Balaki naisa kong’a enyomba yaye eichire ne chifeta, ne chitaabu, tinkonyara kwanga koigwera amang’an’Omonene anchikiire, na tingokora gento kende ase ogwancha kwane, abe amabe, gose amaya. Ay’Omonene agoteeba, ayio naro ngwenerete ’nkore. ");
INSERT INTO guz_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","“Bono ’nkoirana inde gochia ase abanto bane. Inchuo ’nkomanyie egento Abaisraeli barakore ase abanto bao ase amatuko agochia goocha.” ");
INSERT INTO guz_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Erio Baalamu agakwana obobani obo: “Amang’ana aya inche Baalamu, mosinto o Beori, ’ngokwana, amang’ana aya nay’ane, inche omonto oramokiigwe amaiso. ");
INSERT INTO guz_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Aya namang’ana y’omonto okoigwa buya aya Nyasae agoteeba, naende onyorire okomanya korwa ase oria ore Igoro Mono. Na okorora amaroro akorwa ase oria Omobui, oyogotung’ama inse na koramokigwa amaiso. ");
INSERT INTO guz_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Namororire, korende tari bono; namorigereirie, korende tari ang’e. Eng’enang’eni neoroke korwa ase egati y’ abanto ba Yakobo, na enyimbo y’obogambi neoroke korwa ase Abaisraeli. Nesenyente chintakunero chi’emetwe y’Abamoabu, neiyerie abanto b’ororeeria rwa Seti. ");
INSERT INTO guz_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ense ya Edomu nebugwe eirwe, Edomu nebugwe ebe eyabo, eyio nense y’ababisa babo. Abaisraeli ’mbagenderere koba n’okobua. ");
INSERT INTO guz_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Omogambi naoroke korwa ase egati y’ abanto ba Yakobo asirie abanto batameire emechie banyore oborendi.” ");
INSERT INTO guz_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Erio Baalamu akarigereria Abaameleki, agakwana obobani obo: “Abaameleki nabwo barenge ab’eritang’ani ase ebisaku, korende ase omoerio nabasirigwe kegima.” ");
INSERT INTO guz_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Naende akarigereria Abakeni, agakwana obobani obo: “Obomenyo bwabo nabogenderere kobao, buna egeswa keagachire ase engako y’egetare. ");
INSERT INTO guz_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Korende nonya naboigo, Abakeni nabasirigwe, ekero Abaasuri barabaire babe abasibwa.” ");
INSERT INTO guz_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Baalamu akagenderera gokwana obobani bwaye: “Obee! Ning’o oranyare koba moyo ekero Nyasae arakore aya? ");
INSERT INTO guz_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Abanto ’mbachiche ne chimeeri korwa ase engegu ya Kitimu, nabarabwo ’mbachaande Abaasuri na Abaeberi, korende barabwo abanyene ’mbasirigwe boigo.” ");
INSERT INTO guz_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Erio Baalamu akaimoka, akairana bwoye, na Balaki nere akabwatia enchera, akageenda bwoye. ");
INSERT INTO guz_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ekero Abaisraeli batoorete agwo Sitimu, abanto bagachaaka gokora obotomani n’abakuungu b’Abamoabu. ");
INSERT INTO guz_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Abwo bakarangeria Abaisraeli bagende ase emeyega y’ebing’wanso yarenge gokorerwa chinyasae chiabo, na barabwo bakabiria, naende bagasasiima chinyasae chi’Abamoabu. ");
INSERT INTO guz_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Abaisraeli bakabwatana n’enyasae yarenge korokwa Baali‐Peori, bakayesasiima. Omonene akaba n’endamwamu enene ase bare. ");
INSERT INTO guz_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Erio agateebia Musa, “Renta abatang’ani bonsi b’Abaisraeli, obasunge agwo ase obosio bwane erioba ribasambe, erinde endamwamu yane enene etige Abaisraeli.” ");
INSERT INTO guz_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Erio Musa agateebia abagaambi b’Abaisraeli, “Kera oyomo ase more, tiga aite abanto baye bonsi baria babwatanire na Baali‐Peori.” ");
INSERT INTO guz_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Omoisraeli oyomo agacha akarentana omokungu oyomo bw’Abamidiani ase eamate yaye, ase obosio bwa Musa amo nomoganda bwonsi kobateneine agwo ase egesoero ki’Eema y’Omosangererekano, bakorera. ");
INSERT INTO guz_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasi, mosinto bw’Eleazari o Aroni Omokuani, akaimoka korwa ase omoganda bw’Abaisraeli, akabogoria ritimo, ");
INSERT INTO guz_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","akabwatia omonto oria gochia ase akanyomba ka ime, akababeta ritimo bonsi babere, Omoisraeli oria amo nomokuungu oria, ase chinda chiabo. Ase igo amaakwa aria agatiga goita Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Korende abanto abakwete ase ogoakwa okwo nigo babete chilifu emerongo ebere na inye (24,000). ");
INSERT INTO guz_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi, mosinto bw’Eleazari o Aroni Omokuani, nere ogera endamwamu yane yatigire Abaisraeli, ekiagera ere aba ne risemi buna inche inde ne risemi ase egati y’ abanto aba. Ase ayio tinasiretie bonsi ase risemi riane. ");
INSERT INTO guz_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ase ayio, moteebie ng’a, ’ngokora inde nere okobwatana kwane kw’omorembe. ");
INSERT INTO guz_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Okobwatana okwo kw’omorembe ’nkobe ase are ere, na ase ororeria rw’aye, okobwatana kwa botambe kw’obokuani, ekiagera abeete ne risemi ase engencho yane, inche Nyasae oye, naende agakora okobwatanigwa ase Abaisraeli.” ");
INSERT INTO guz_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Omoisraeli oria oitetwe amo nomokuungu Omomidiani nigo arenge korokwa Simuri, mosinto o Salu, omotang’ani bw’eamate yaye ase egesaku gia Simioni. ");
INSERT INTO guz_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Omokungu oria bw’Abamidiani oitetwe ere nigo arenge korokwa Kosibi. Suri ise nere orenge omotang’ani bwe chiamate chinde chi’Abamidiani. ");
INSERT INTO guz_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Umokera Abamidiani, obasirie, ");
INSERT INTO guz_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ekiagera barabwo baabachandire ase okobaebereria gosasiima Peori, na ase amang’ana a Kosibi, omosubati oria bw’omonene bw’Abamidiani. Omosubati oria obo oitetwe ase rituko riria amaakwa achete ase engencho ya Peori.” ");
INSERT INTO guz_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ekaba magega amaakwa aria gaetire, Omonene agakwana na Musa na Eleazari, omomura o Aroni Omokuani, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Mobare omoganda bwonsi bw’Abaisraeli, eamate ase eamate. Moriike, abanto bakoorire emiaka emerongo ebere na goetania, abwo baranyare korwana esegi.” ");
INSERT INTO guz_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Erio Musa na Eleazari Omokuani bagakwana n’abanto baria ase enyancha enyomo ya Moabu, ase orooche rwa Yorodani, kororia Yeriko, akabateebia, ");
INSERT INTO guz_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Riika abanto bonsi abakoorire emiaka emerongo ebere na goetania, buna Omonene achiigete Musa.” Abaisraeli abwo barwete ense ya Misiri nabwo aba. ");
INSERT INTO guz_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubeni nere orenge omomura omotangi o Israeli. Ase egesaku kiaye nigo chiarenge chiamate echi: Abahanoki, abarwete ase Hanoki, na Abapalu, abarwete ase Palu, ");
INSERT INTO guz_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","na Abahezironi, abarwete ase Hezironi, na Abakarimi, abarwete ase Karimi. ");
INSERT INTO guz_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Echi nachio chiamate chi’egesaku kia Rubeni. Abaabaretwe nigo barenge chilifu emerongo ene na isato, na amagana atano abere, na merongo etato (43,730). ");
INSERT INTO guz_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ororeria rwa Palu n’Eliabu ");
INSERT INTO guz_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","amo nabana baye: Nemweli, na Datani, na Abiiramu. (Aba nabwo Datani na Abiiramu bachoretwe korwa ase omoganda. Barabwo bakaamererania na Musa na Aroni, bakaba ase ekeombe gia Kora, ekero baamereranetie n’Omonene. ");
INSERT INTO guz_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Riroba rikabwereka rikabamera amo na Kora, ekero omorero osambete na gosiria abanto amagana abere, na merongo etano. Ayio akaba ekiorokererio ki’ogokuurera. ");
INSERT INTO guz_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Korende abana ba Kora barabwo tibaitetwe.) ");
INSERT INTO guz_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ase egesaku gia Simioni nigo chiarenge chiamate echi: Abaanemweli, abarwete ase Nemweli, na Abayamini, abarwete ase Yamini, na Abayakini, abarwete ase Yakini, ");
INSERT INTO guz_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","na Abazera, abarwete ase Zera, na Abasauli, abarwete ase Saulo. ");
INSERT INTO guz_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Echi nachio chiamate chi’egesaku gia Simioni. Abaabaretwe nigo barenge chilifu emerongo ebere na ibere, na amagana abere (22,200). ");
INSERT INTO guz_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ase egesaku kia Gadi nigo chiarenge chiamate echi: Abazefoni, abarwete ase Zefoni, na Abahagi, abarwete ase Hagi, na ");
INSERT INTO guz_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Abasuni, abarwete ase Suni, na Abaosini, abarwete ase Osini, na Abaeri, abarwete ase Eri, ");
INSERT INTO guz_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","na Abaarodi, abarwete ase Arodi, na Abaareli, abarwete ase Areli. ");
INSERT INTO guz_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Echi nachio chiamate chi’egesaku kia Gadi. Abaabaretwe nigo barenge chilifi emerongo ene, na amagana atano (40,500). ");
INSERT INTO guz_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Basinto ba Yuda, Eri na Onani, bagakwera agwo ase ense ya Kaanani. ");
INSERT INTO guz_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ase egesaku kia Yuda nigo chiarenge chiamate echi: Abasela, abarwete ase Sela, na Abaperisi, abarwete ase Peresi, na Abazera, abarwete ase Zera. ");
INSERT INTO guz_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Chiamate chia Peresi nigo chiarenge: Abahezironi, abarwete ase Hezironi, na Abahamuli, abarwete ase Hamuli. ");
INSERT INTO guz_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Echi nachio chiamate chi’egesaku kia Yuda. Abaabaretwe nigo barenge chilifu emerongo etano ebere na isano nemo, na amagana atano (76,500). ");
INSERT INTO guz_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ase egesaku gia Isakaru nigo chiarenge chiamate echi: Abatola, abarwete ase Tola, na Abapua, abarwete ase Pua, ");
INSERT INTO guz_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","na Abayasubu, abarwete ase Yasubu, na Abashimuroni, abarwete ase Shimuroni. ");
INSERT INTO guz_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Echi nachio chiamate chi’egesaku gia Isakaru. Abaabaretwe nigo barenge chilifu emerongo etano nomo na inye, n’amagana atato (64,300). ");
INSERT INTO guz_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ase egesaku gia Sabuloni nigo chiarenge chiamate echi: Abaseredi, abarwete ase Seredi, na Abaeloni, abarwete ase Eloni, na Abayaleeli, abarwete ase Yaleeli. ");
INSERT INTO guz_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Echi nachio chiamate chi’egesaku gia Sabuloni. Abaabaretwe nigo barenge chilifu emerongo etano nomo na amagana atano (60,500). ");
INSERT INTO guz_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ebisaku bia Yusufu nebi’abamura baye babere, Manase na Efraimu. ");
INSERT INTO guz_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ase egesaku kia Manase nao eamate ya Makiri yarwete. Makiri nere orenge ise Gileadi, na korwa ase are nao Abagileadi barwete. ");
INSERT INTO guz_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ase ororeria rwa Gileadi nigo chiarenge chiamate echi: Abaieseri, abarwete ase Ieseri, na Abaheleki, abarwete ase Heleki, ");
INSERT INTO guz_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Abaasirieli, abarwete ase Asirieli, na Abasekemu, abarwete ase Sekemu, ");
INSERT INTO guz_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","na Abasemida, abarwete ase Semida, na Abaheferi, abarwete ase Heferi. ");
INSERT INTO guz_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehadi, mosinto o Heferi, tabwate abana abamura, korende nabana abaiseke boka abwate, na amarieta y’abaiseke abwo naro aya: Mala, na Nuhu, na Hogila, na Milka, na Tirisa. ");
INSERT INTO guz_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Echi nachio chiarenge chiamate chi’egesaku kia Manase. Abaabaretwe nigo barenge chilifu emerongo etano na ibere, na amagana atano abere (52,700). ");
INSERT INTO guz_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ase egesaku gi’Efraimu nigo chiarenge chiamate echi: Abasutela, abarwete ase Sutela, na Ababeekeri, abarwete ase Bekeri, na Abatahani, abarwete ase Tahani. ");
INSERT INTO guz_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutela nigo arenge ise Erani, na korwa ase are nao Abaerani barwete. ");
INSERT INTO guz_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Echi nachio chiamate chi’egesaku gia Efraimu. Abaabaretwe nigo barenge chilifu emerongo etato na ibere, na amagana atano (32,500). Aba nabwo barenge abana ba Yusufu ne chiamate chiabo. ");
INSERT INTO guz_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ase egesaku gia Benjamini nigo chiarenge chiamate echi: Ababela, abarwete ase Bela, na Abaasibeli, abarwete ase Asibeli, na Abaahiramu, abarwete ase Ahiramu, ");
INSERT INTO guz_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","na Abasefufamu, abarwete ase Sefufamu, na Abahufamu, abarwete ase Hufamu. ");
INSERT INTO guz_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Abamura ba Bela nabwo Aridi na Naamani. Korwa ase Aridi nao Abaaridi barwete, na korwa ase Naamani nao Abanaamani barwete. ");
INSERT INTO guz_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Echi nachio chiarenge chiamate chi’egesaku gia Benjamini Abaabaretwe nigo barenge chilifu emerongo ene na isano, na amagana atano na rimo (45,600). ");
INSERT INTO guz_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ase egesaku gia Dani nigo chiarenge chiamate chi’Abasuhamu, abarwete ase Suhamu. Aba nabwo abanto b’egesaku gia Dani ase chiamate chiabo. ");
INSERT INTO guz_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Abarwete ase chiamate chi’Abasuhamu nigo barenge chilifu emerongo etano nomo na inye, na amagana ane (64,400). ");
INSERT INTO guz_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ase egesaku gi’Aseri nigo chiarenge chiamate echi: Abaimuna, abarwete ase Imuna, na Abaisibi, abarwete ase Isibi, na Ababeria, abarwete ase Beria. ");
INSERT INTO guz_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Abamura ba Beria nabwo Heberi ase eamate y’Abaheberi yarwete, na Malikieli, ase eamate y’Abamalikieli yarwete. ");
INSERT INTO guz_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Omwana omoiseke o Aseri nigo arenge korokwa Sera. ");
INSERT INTO guz_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Echi nachio chiamate chi’egesaku gi’Aseri. Abaabaretwe nigo barenge chilifu emerongo etano na isato, na amagana ane (53,400). ");
INSERT INTO guz_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ase egesaku kia Nafutali nigo chiarenge chiamate echi: Abayaseli, abarwete ase Yaseli, na Abaguni, abarwete ase Guni, ");
INSERT INTO guz_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","na Abayeseri, abarwete ase Yeseri, na Abasilemu, abarwete ase Silemu. ");
INSERT INTO guz_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Echi nachio chiamate chi’egesaku kia Nafutali. Abaabaretwe nigo barenge chilifu emerongo ene na isano, na amagana ane (45,400). ");
INSERT INTO guz_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Abanto bonsi b’Abaisraeli abarigetwe nigo barenge chilifu amagana atano nomo na eyemo, na amagana atano abere na merongo etato (601,730). ");
INSERT INTO guz_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Omonene agateebia Musa, ");
INSERT INTO guz_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Aatananere abanto aba chingongo chibe emiando yabo. Ochiatanane kobwatekana nomobaro bw’ abanto. ");
INSERT INTO guz_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Egesaku kere ekenene keegwe orogongo oronene robe omwando obo, na egesaku kere egeke keegwe orogongo oroke robe omwando obo. Kera egesaku nakeegwe omwando oye koreng’ana nomobaro obo. ");
INSERT INTO guz_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ense yaatananwe ase ogoakerwa obomera. Abanto mbanyore omwando koreng’ana nomobaro bw’amarieta ’ebisaku bie chisokoro chiabo. ");
INSERT INTO guz_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Koreng’ana buna obomera boragwere abanto ba kera egesaku, ekenene gose egeke, nabo baranyore omwando obo. ");
INSERT INTO guz_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ase egesaku kia Lawi nigo chiarenge chiamate echi: Abagerisoni, abarwete ase Gerisoni, na Abakohati, abarwete ase Kohati, na Abamerari, abarwete ase Merari. ");
INSERT INTO guz_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Echi nachio chiamate chi’egesaku kia Lawi: Eamate y’Abalibini, na ey’Abaheburoni, na ey’Abamali na ey’Abamusi, na ey’Abakora. Kohati nere orenge ise Amuramu. ");
INSERT INTO guz_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Moka Amuramu nigo arenge korokwa Yokebedi, mosubati o Lawi, oria oiboreretwe Lawi agwo ase ense ya Misiri. Omokungu oria akamoiborera Amuramu abana aba: Aroni, na Musa, na Miriamu, omoiseke omwabo. ");
INSERT INTO guz_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Basinto ba Aroni nabwo aba: Nadabu, na Abihu, na Eleazari, na Itamari. ");
INSERT INTO guz_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Korende Nadabu na Abihu bagakwa ekero baruete ogosambwa kw’engeencho eng’ao otachiikiri ase obosio bw’Omonene. ");
INSERT INTO guz_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Kera omonto omosacha ase egati yabo oyo konya okoorire omotienyi oyomo na goetania nigo abaretwe. Barabwo nigo barenge chilifu emerongo ebere na isato (23,000). Abanto aba tibaabaretwe amo n’Abaisraeli bande, ekiagera tibaetwe omwando ase egati y’Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Abanto aba nabwo Musa na Eleazari Omokuani bariigete ekero baabarete Abaisraeli agwo ase enyancha enyomo ya Moabu, ase Yorodani kororia Yeriko. ");
INSERT INTO guz_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Korende ase egati y’ abanto aba onde tarengeo, nonya noyomo, ase baria Musa na Aroni Omokuani baabarete agwo ase erooro ya Sinai. ");
INSERT INTO guz_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Omonene nakwanete igoro y’abwo, “Barabwo nigo barakwere ase erooro.” Omonto onde tagotigara ore moyo nonya noyomo, otatiga Kalebu, mosinto o Yefune, na Yoshua, mosinto o Nuni. ");
INSERT INTO guz_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ase engaki eyio abaiseke ba Selofehadi, mosinto o Heferi o Gileadi, o Makiri, o Manase bagaacha. Aba nigo barwete ase chiamate chia Manase, mosinto o Yusufu, na amarieta abo naro aya: Mala, na Nuhu, na Hogila, na Milka, na Tirisa. ");
INSERT INTO guz_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Barabwo bagaacha ase obosio bwa Musa, na obwa Eleazari Omokuani, na ase amasio y’abatang’ani, na ase omoganda bwonsi, bagatenena agwo ase egesoero ki’Eema y’Omosangererekano, bagateeba, ");
INSERT INTO guz_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Tata nigo akwerete agwo ase erooro. Ere tarenge ase egati y’ekeombe keria giasangererekanete amo gekaba mamincha y’Omonene, ase abwo barenge ase ensemo ya Kora, korende ere nigo akwete ase engencho y’ebibe biaye omonyene. Ekero akwete tatigete abana abamura ");
INSERT INTO guz_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Nase ki erieta ria tata rigosirigwa korwa ase eamate yaye ekiagera tabwate abana abamura? Toe naintwe omwando ase egati y’abamura bamwabo tata.” ");
INSERT INTO guz_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa akaira amang’ana abo ase obosio bw’Omonene, ");
INSERT INTO guz_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","n’Omonene akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Abaiseke ba Selofehadi nekeene bakoboria. Bae omwando obo ase egati ya bamura bamwabo ise. Tiga omwando o ise obe oyobo. ");
INSERT INTO guz_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Naende oteebie Abaisraeli ng’a omonto karakwe, onye ere tabwati omwana omomura, omwando bw’omonto oyio omwana oye omoiseke ayoire. ");
INSERT INTO guz_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Onye omonto oyio tabwati nonya nomwana omoiseke, omwando oye abamura bamwabo bayoire. ");
INSERT INTO guz_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Onye omonto oyio tabwati abamura bamwabo, omwando oye oirwe nabamura bamwabo ise. ");
INSERT INTO guz_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Na onye omonto oyio tabwati abamura bamwabo ise, omwando oye oirwe nomoamate oye ore ang’e. Okwo nigo koraabe ogochika kw’oboronge ase Abaisraeli, buna inche Omonene nagochiikire.” ");
INSERT INTO guz_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Omonene agakwana na Musa, akamoteebia, “Tiira gochia igoro ase egetunwa eke ki’Abarimu, na origererie ense naeire Abaisraeli. ");
INSERT INTO guz_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ekero kwayerorire, aye nigo orasangererekane amo n’abanto bao buna Aroni omino asangererekanete amo n’abanto baye, ");
INSERT INTO guz_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ekiagera timwaigwerete ring’ana riane agwo ase erooro ya Sini, rituko riria omoganda bwonsi bwemurunganetie, gose timwaorogetie ng’a inche nomochenu inde, ekero mware kobochorera abanto amaache.” (Aya namaache a Meriba ya Kadeshi ase erooro ya Sini). ");
INSERT INTO guz_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa agakwana n’Omonene akabora, ");
INSERT INTO guz_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Aye Omonene Nyasae, aye oyokorua obogima ase abanto bonsi, chora omonto oraraae omoganda oyo, ");
INSERT INTO guz_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","omonto oranyare gotang’ana abanto kobagosoka na kobakoirana, erinde omoganda bw’ abanto ba Omonene tobaisa koba buna ching’ondi chitari nomorisia.” ");
INSERT INTO guz_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Omonene agateebia Musa, “Ira Yoshua, mosinto o Nuni, omonto oyio omoika one ore ime yaye, erio omobekere amaboko. ");
INSERT INTO guz_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Omorente atenene ase obosio bw’Eleazari Omokuani, na ase amasio y’omoganda bwonsi bw’ abanto, erio ase amasio abo omorarie ng’a nere oirire ribaga ria’o. ");
INSERT INTO guz_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Omoe okobua buna okwao, erio nario omoganda bwonsi bw’Abaisraeli oramoigwere. ");
INSERT INTO guz_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Yoshua abe ogotenena ase obosio bw’Eleazari Omokuani, na Eleazari abe okomonogeri oye ase Urimu, agwo ase obosio bwane amanye ogwancha kwane. Yoshua amo nomoganda bwonsi bw’Abaisraeli nigo barakore emeremo yabo yonsi buna Eleazari arabachiike.” ");
INSERT INTO guz_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa akaira Yoshua buna Omonene konya amochiikire, akamorenta ase obosio bw’Eleazari Omokuani nomoganda bwonsi. ");
INSERT INTO guz_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Naende akabeeka amaboko aye igoro ase omotwe o Yoshua, akamwatanana, akamobeka ase ribaga riaye, buna Omonene konya amochikiire goetera ase Musa. ");
INSERT INTO guz_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Omonene agakwana na Musa, akamoteebia, ");
INSERT INTO guz_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Kwana n’Abaisraeli obachike ng’a ase ekero keria gechiikire goika banduere ebing’wanso na okoruegwa kw’endagera kogosambwa nomorero kore ne rimisu rigiya rikongwenera. ");
INSERT INTO guz_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","“Obateebie: Eke nakio ekeng’wanso kegosambwa nomorero moramoruere Omonene: Kera rituko botambe morue chimanwa chimingichi ibere, echiakoorire omwaka oyomo, chitari na kemocho ase emebere yabo. ");
INSERT INTO guz_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Eyemo y’echio oyerue mambia, na eyende mogoroba. ");
INSERT INTO guz_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Kera eyemo oyerue amo n’okoruegwa kw’endagera, ebimunu bibere bi’obosie obonuke bwochoganirie n’amaguta amitire korwa ase amazeituni egetuba ekemo. ");
INSERT INTO guz_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ekio nekeng’wanso ki’ogosambwa gia kera rituko, ekio Musa aruete ritang’ani agwo ase egetunwa gia Sinai gekaba rimisu rigiya, ekeng’wanso kegosambwa nomorero ase Omonene. ");
INSERT INTO guz_vpl VALUES ("NU28_7","005_28_7","NUM","28","7"