﻿USE sofia;
DROP TABLE IF EXISTS sofia.guxg_vpl;
CREATE TABLE guxg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guxg_vpl WRITE;
INSERT INTO guxg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abalahama biga, jakobo biga, JESU kiristu yajanba yela n ne: ");
INSERT INTO guxg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahama mali Isaka; Isaka ń mali Jakobo; Jakobo ń mali Juda yeni o ninjaba; ");
INSERT INTO guxg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda bo taa Tamaar, ki mali Fares yeni Saara; Fares ń mali Esrom; Esrom ń mali Aram; ");
INSERT INTO guxg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ń mali Aminadab; Aminadab ń mali Naasɔn; Naasɔn ń mali Salmɔn; ");
INSERT INTO guxg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔn ń taa Rahab, ki mali Bɔas; Bɔas ń taa Rut ki mali Obed; ");
INSERT INTO guxg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Obed ń mali Isayi; Isayi ń mali Dafid; O badciamo Dafid ń taa Uri denpua, ki mali Salomɔn; ");
INSERT INTO guxg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔn ń mali Robuam; Robuam ń mali Abia; Abiya ń mali Asa; ");
INSERT INTO guxg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ń mali Josafat; Josafat ń mali Joram; Joram ń mali Osiyas; ");
INSERT INTO guxg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas ń mali Juatam; Juatam ń mali Ahas; Ahas ń mali Esekihas; ");
INSERT INTO guxg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekihas ń mali Manase; Manase ń mali Amɔn; Amɔn ń mali Josias; ");
INSERT INTO guxg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias ń mali Jekonias yeni o ninjaba, ban cuo ba ya yogu ki gede yeni ba Babilɔni, ti yonbidi. ");
INSERT INTO guxg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloni yonbdi ń pendi, ke Jekonias mali Salatiel; Salatiel ń mali Sorobabel; ");
INSERT INTO guxg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel ń mali Abiyud; Abiyud ń mali Eliakim; Eliakim ń mali Asɔar; ");
INSERT INTO guxg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔar ń mali Sadɔk; Sadɔk ń mali Akim; Akim ń mali Eliyud. ");
INSERT INTO guxg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud ń mali Eleyasaar; Eleyasaar ń mali Matan; Matan ń mali Jakob; ");
INSERT INTO guxg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob ń mali Josef, Maari calo, Maari, yua n mali Jesu, ban yi yua kiristu. ");
INSERT INTO guxg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Lan wani, lan cili Abalahama, ki tuoni Dafiid, li tie piiga n nifiima na, lan taa Dafiid ki tuoni Babiloni yonbidi, li mo tie piiga n nifiima na, ki taa Babiloni yonbdi hali kiristu li mo tie piiga n nifiima na. ");
INSERT INTO guxg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesu kiristu ń mali maama n ne. Maari, o naá bo tie Josef cikpenga i, ki punbi U Tienu Foŋanma paalu po, ke bi dá ki taani yeni bi yaba (ki dá ki kuni ti cikpendi) ");
INSERT INTO guxg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","O calo, Josef ń bo tie nitegnka, kaa bua ke o fiagi o yeni, o den jagi ke wan wuoni, ki yie o ŋasiili nni. ");
INSERT INTO guxg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wan taa lan ya maalma yeni, O Diedo maleki ń legdi o po ti dangdi nni, ki maadi o: Dafiid bijua Josef, da jie yeni ŋan kuani a denpua Maari kelima, wan punbi ya biga ne ñani U Tienu Foŋanma kani i. ");
INSERT INTO guxg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O ba mali bonjaga, ŋan yini o Jesu; wani n ba faabi o buolu u tuonbiidi po. ");
INSERT INTO guxg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ne kuli tieni ke O Diedo ń bo cedi ke bi sawalpuaba tuodi ki waani yaali ń tieni ki dudi: ");
INSERT INTO guxg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","I ba la powandiali (ya jifaano dá ki bani ja) ba punbi, ki mali bonjaga, ban yini o Emanuyel, li niima nni tie U Tienu ye yeni ti. ");
INSERT INTO guxg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josef ń den findi, o den tieni nani O Diedo maleki ń waani o yaala, o den ga o denpua ke bi taani ki ye. ");
INSERT INTO guxg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama, o den ki taani yeni o hali ke o ban mali bonjaga ke o yini o Jesu. ");
INSERT INTO guxg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu den mali Betelema, Jude dogu nni, ya yogu ke Herodi den tie badciamo; lanyogu ke ya badtieba n bani i ŋmaali cogma ñani puoli, ki cua Jerusalema, ");
INSERT INTO guxg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yedi: Jufinba badciamo, ban mali yua mɔlane ye le? Kelima, ti la ke o ŋmaabiga pudi puoli, ke ti cua ki ba pugi o. ");
INSERT INTO guxg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","O badciamo Herodi ń gbadi lanya maama, o yama ń ŋmadi lan mugi Jerusalema yaaba kuli. ");
INSERT INTO guxg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","O badciamo ń taani salga yidkaacianba yeni u dogu nn gbanbanda, ki buali ki bandi ban ba mali Kiristu naana. ");
INSERT INTO guxg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ban maadi o: li tie Betelema, Jude dogu nni; kelima o sawalpualo ń diani yaali n ne: ");
INSERT INTO guxg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Fini, Betelema, Juda tinga, fini ka ñidi ki cie, Juda dogciami siiga, kelima bado ba ña a niini, ki ya kpaa n buolu Isirayeli. ");
INSERT INTO guxg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lanyapo, Herodi ń wuoni, ki yini a ŋmaabila banda yeni, ki buali ki bandi ya yogu ke ki ŋmaabiga yeni den pudi ki ñigdi. ");
INSERT INTO guxg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ki waani ba ke ban gedi Betelema, ki maadi ba: “Gedi mani ki ban ga ki bigi yeni laabaali bonŋanla, I ya la o, yin guani ki maadi nni, mini mo ń gedi ki pugi o. ");
INSERT INTO guxg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ban cengi o badciamo ki gbeni, ban ña ki paani u sani. Ban den la ya ŋmaabiga puoli yeni ń go legdi bi liiga, ki ya cuoni, ki ban pundi ki biga ń ye naani, ki sedi. ");
INSERT INTO guxg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ban la ki ŋmaabiga, bi pala ń mangi boncianla. ");
INSERT INTO guxg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ban kua li dieli nni, ki la ki biga yeni o naá Maari, ki gbaani ki pugi o, ki fiidi bi ligbɔga, ki ñani wula, li ŋubli yeni ya tolade n yi miiri ki teni o bi paabu. ");
INSERT INTO guxg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bi den la ti dangdi nni, ke li ki buali ke ban guani ki tɔgni Herodi po, ke bi kogni santianu, ki lebdi ki kuni. ");
INSERT INTO guxg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Puoli banda yeni ń kuni, ke maleki legdi ti dangdi nni, ki maadi Jesefi: “Fii, ki taa ki biga yeni o naá, ki sani ki gedi Ejipti, ki ya ye lanpo hali min ba waani a ya yogu; kelima Herodi ba kpaani ya sani ke o ba biani ki biga ne miali. ");
INSERT INTO guxg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josefi ń fii ku ñiagu ki taa ki biga yeni o naá, ki sani ki gedi Ejipti ");
INSERT INTO guxg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bi den ye Ejipti hali ke Herodi ti kpe. Li tieni yeni ke O Diedo ń bo cedi ke sawalualo waani yaali yeni ń tieni ki dudi: “N yini n bijua, ki ñani o Ejipti tinga nni.” ");
INSERT INTO guxg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodi ń diidi ki sua ke puoli ŋmaabanda yeni bɔndi o, ke o pali beni boncianla, ke sɔni ke ban kpa Betelema dogu nni yeni li tinkundogi kuli, ya bonjabila pia bina lie yeni yaaba n nagi bina lie nani wan den buali ki bi waani o ya yogu yeni, ke o jia ki dagni ki biga yeni ń baa pia ya bina. ");
INSERT INTO guxg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mɔla, o sawalpualo Jeremi ń den waani yaali tieni ki dudi: ");
INSERT INTO guxg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bi gbadi i yigni Roma dogu nni, li bubuuli i kuumoe yeni i fanfabinciami, Raciheli ń buudi o bila kuumoe, kaa bua ban baagi o, ki sɔngi opali, kelima, bi ji ki ye. ");
INSERT INTO guxg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodi ń kpe, ke maleki legdi ti dangdi nni Ejipti, ki maadi Josefi: ");
INSERT INTO guxg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ki yedi: “Fii, ki taa ki biga yeni o naá ki gedi Israyeli dogu nni, kelima yaaba n den kpaani ke ban gbindi ki biga miali nan kpe o. ");
INSERT INTO guxg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josefi ń fii, ki taa ki biga yeni o naá, ki gedi Israyeli. ");
INSERT INTO guxg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","O den gbadi ke Arkelawus n ga o báa Herodi, ki kaa Jude badkpagli po, ke o jie yen wan gedi li dogu nni. O den la ti dangdi nni ke li buali ke wan gedi Galile, ");
INSERT INTO guxg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ke o gedi ki kua ya dogu ke bi yi Nasareti, ke bi sawalpuaba n den waani yaali ń tieni ki dudi: “Bi baa yi o Nasaeti yua.” ");
INSERT INTO guxg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lanyogu, ke Jan bo legdi Jude tinkuonga nni, ki kpaandi ki wangi U Tienu maama ");
INSERT INTO guxg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","O den maadi: “Lebdi mani i pala kelima tanpoli diema nagi. ");
INSERT INTO guxg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jan tie o sawalpualo Esayi ń bo tuodi ki waani yua ya maama, ki tua: “Ne tie yua ya nialu n kpaandi ki tinkuonga nni ki tua: «Bobni mani O Diedo sanu, sondi mani o sanbulmu.” ");
INSERT INTO guxg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan bo la ti yodyuokobdi liadgaalgu, ki ñaagi o ciaga nni ku gbanñagdigu. O bo ŋmani ti naasuudi, ki mua li fuali nni siadi. ");
INSERT INTO guxg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalema niba, yeni Jude yaaba kuli yeni Jurden tinkundogi yaaba den caa o kani. ");
INSERT INTO guxg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bi den tuodi ki dɔgdi ki wangi bi tuobiidi, ki cedi ke Jan batise ba Jurden kpenu nni. ");
INSERT INTO guxg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ama wan den la ke farisienba yeni saduseyenba boncianla kpendi o kani ki bua wan batise ba, ke o maadi ba: “Waalaba buoli, ŋma waani yi ke yin sani ya pabienli n kpendi. ");
INSERT INTO guxg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yin nan loni ya luana n dagdi yeni i tuubma. ");
INSERT INTO guxg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yin da daani i ala nni ki tua: “Ti pia Abalahama ke o tie ti báa! Kelima n kadi ki maadi yi ke a tana ne siiga nni, U Tienu ba fidi fiini ya bila n tie Abalahama puolŋuani.” ");
INSERT INTO guxg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ku yalgu ji caa i tiidi jiina po i; ya tiiga n ki luoni luanŋana, bi ba pedi bu ki lu bu u mu nni. ");
INSERT INTO guxg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mini, n batise yi yeni mi ñima ki bua yin legdi ki waani i biidi ki lebdi i pala. Ama yua n ŋua n puoli ki ba cua pia u paaciamu ki cie nni, hali ke n kan fidi ki pili o taacaakpaga. Wani ba batise yi yeni U Tienu Foŋanma yeni u mu i. ");
INSERT INTO guxg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","O ji muubi li bonlendkaali o nuu nni i. O ba ŋanbi ki tigni u jalu, ki tini ki taani mi dibima, ki wodi ki kuodi li bunbuali nni, ki nan juu ku fengu ya mu n ki pia gbindma nni. ");
INSERT INTO guxg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lanyognu ke Jesu ñani Galile ki cua Jurden kpenu nni, Jan kani ke wan batise o. ");
INSERT INTO guxg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama ke Jan yie, ki yedi: Mini n bua ŋan batise nni, ke a mo nan cua n ya kani! ");
INSERT INTO guxg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ke Jesu jiini o: «Ji cedi lan tieni yeni kelima li buali ke tin tieni yeni i yaali n tiegi kuli ń tieni ki dudi. Jan ji den ki yie o maama. ");
INSERT INTO guxg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ban batise Jesu, ke o ñani mi ñima nni, ke tanpoli luodi, ke o la ke U Tienu Foŋanma jiidi nani ki kpaajiega yeni ki sedi o po. ");
INSERT INTO guxg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ke u nialu ñani tanpoli, ki yedi ya maama ne: «O ne tie n bijabuadga i, n pali mani o po hali boncianla. ");
INSERT INTO guxg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ki fuoŋanbi gedi yeni Jesu i tinkuongi n, ki sitaani bign o. ");
INSERT INTO guxg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ki Jesu loli bu ñɔbu yentuna piina yeni ñiadi piina, ki mi komi cuo gu. ");
INSERT INTO guxg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ki sitaani nagni ki maad o, ya tie U Tienu bijua cedi k a tana ne n kpandi jiedi. ");
INSERT INTO guxg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ki jesu ŋmian o: li diani ki maadi, k ti jiedi po baba k a cedi k o nul pia li miali, ama ya maataana kuli ña U Tienu ñɔbi n. ");
INSERT INTO guxg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ki sitaani tug o ki gedi yen o dingbanli ni, ki duon o jaandieciangu yuli po. ");
INSERT INTO guxg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ki maadi o: a ya tie U Tienu b ijua, ŋan yugi ki jiidi, klima li diani ki maadi: U Tienu tondikaaba ba tebni ki gaba, ba k a taali n da si tanli ");
INSERT INTO guxg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ki Jesu yedi o: li mɔ diani ka kan bigni a diedo U Tienu. ");
INSERT INTO guxg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ki sitaani guani ki tugi o ki gedi yeni o ya juali n kpedi paaa yuli po, ki waani o duliña munli kuli yeni li ŋanmu, ");
INSERT INTO guxg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ki maadi o: n ba teni a lan kuli ne, li ya tie k a gbaani ki pugi nni. ");
INSERT INTO guxg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ki Jesu yedi o: sudi n kan ne, fin sitaani! klima a baa pugi a Diedo U Tienu baba i, ki gɔ dondi wani baba i. ");
INSERT INTO guxg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ki li yogu sitaani siedi ki ŋagu. Li yogu, ki maleki nba nagni ki tieni o buama ");
INSERT INTO guxg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ki Jesu gbadi ki bi cuo San, k o ñani li kani ki gedi Galile. ");
INSERT INTO guxg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O ñani Nasareti ki gedi kafarnahom ki li ki fagi yeni li mɔgli, babilɔni yeni Nepitaali tingn nni. ");
INSERT INTO guxg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ki lan fidi U Tienu tondu Esayi n bo maadi yaali n fidi ki tieni yeni i mɔni. ");
INSERT INTO guxg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yabulɔn yeni Nepitaali dogi n yaabi, yeni yaabi n kua ki kpia li mɔgli bɔnpuoli po Juuridan dogu yeni Galiile yaabi bi nimɔnbi. ");
INSERT INTO guxg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Li dogu n yaabi den ye bɔnbɔnli nni, k te la ya yinyienbi n yabi; ki yaabi n den kali mi kuuma bɔnbɔnli po mɔ la ya yinyienbi n cua ki fandi. ");
INSERT INTO guxg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ki li yogu ki Jesu ji cili ki muandi ki maadi, ŋa mani i tuonbiidi ki lebdi i ba klima U Tienu diema nago. ");
INSERT INTO guxg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Li bo tie yeni k o cuoni Galiile li mɔgli kung, ki la o ninjabi bonbilie, Siimɔn, yua ki bi yiigu Piar yeni Andre ki bi lu bi janbaandi li mɔgli nni ki kpaani i jami. ");
INSERT INTO guxg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu maadi ba: ya ŋua man n ni, n bi cedi yin ya kpaani bi niba ki ji cedi li jancuoli. ");
INSERT INTO guxg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Li yogunu, ki bi ŋa bi janbaandi, ki ji ŋuagu ");
INSERT INTO guxg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ki wan cuoni ki gedi liigi waami, k o la o ninjanbi bonbilie mɔ Jaak Sebede bidi yeni San o kpelo ki bi ye o ñunbiagu nni ki ŋanbdi bi janbaandi. ");
INSERT INTO guxg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","K o yinbi, ki bi ŋa bi janbaandi yeni bi baà, ki ji ŋɔd o. ");
INSERT INTO guxg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","O bo cuoni Galiile jandieciandi nni, ki muandi U Tienu diema maama, ki paagdi i yian buoli kuli. ");
INSERT INTO guxg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bi ji den taagi o yeli kaana kuli Siri dogun ni, ki bi cuoni o kani yeni yaabi n yia i yian buali kuli: yaabi ka sanpola ŋuabi, yaabi n baali i ting yeni ti gbannankpiendi danb. ");
INSERT INTO guxg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","O nuwuligu ji den ŋua o: Galiile, Dekapol, Jerusalem, Jude yeni Jourdin puoli. ");
INSERT INTO guxg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wan la o niwulgu, k jesu don li juali po, k oyegntieb nagni ki kal o kani. ");
INSERT INTO guxg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yeni wan yaadi o nɔbu, ki tundiba, ki maadi ba: ");
INSERT INTO guxg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","pamanli tie yaabi n jiindi bi ba, ki duu U Tienu po i. Ban n tie U Tienu diemani niba. ");
INSERT INTO guxg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pamanli ye, yeni yaabi n kaa yeni ti ninsiidi. ");
INSERT INTO guxg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pamanli ye, yaabi n pia li pañiili, klma U Tienu bo ti cabi bani i tinga. ");
INSERT INTO guxg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pamanli tie yaabi n buudi mi koma yeni o ñuñuunu, i mɔmɔni sanu nni, klma bi ti ba di ki guo. ");
INSERT INTO guxg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pamanli bi ninbadama po, klma bi bo ti di li danbi mɔ ya po m ninñuma. ");
INSERT INTO guxg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pamanli tie yaabi n pia li papienli, ki dugni ban ba ti la U Tienu. ");
INSERT INTO guxg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pamanli tie yaabi n kpaani laafia yen m buama bi lieba po, ki dugni U Tienu ba ti yini bani o bidi. ");
INSERT INTO guxg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pamanli tie yaabi n tuagi i mɔmɔni sanu, ki bi nan wangi bi fala li po, kilima bani n tie U Tienu diema yabi. ");
INSERT INTO guxg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Pamanli yen ŋanbi ki loli ki cuo, yayognu ki bi sugdi, ki maadi ti maa biidi, ki pua mi faama, ki tiendi li bonbiili ki dugni min ya po. ");
INSERT INTO guxg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ya ye mani li pamanli nni yeni i lalayien nni, ki dugni i ñuadi ti ba yabi tapoli po, ki dugni yaabi cindi ki tie U Tienu tondikaaba, bi den cagni bi mɔ yeni. ");
INSERT INTO guxg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","I tie yaami i tinga ne po. Ama, li ya tie ki mi yaama manu gbeni, bi ba tugi be ki guani ki mang o? li ji ki pia buama. Li tie ki ban tugi ki wuli niin po, bi niba n ya ŋmaadi li po. ");
INSERT INTO guxg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yinbi n tie ŋanduna yinyiem, ya dogu n ye li juali po, bonli kan fidi ki legni o. ");
INSERT INTO guxg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yeni, bi ki congi li fidli ki cubdili bobl nni. Ama bi yi cuon li fidli ki sien o naani ki li baa co ki yieni deni yaabi kuli po i. ");
INSERT INTO guxg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","I mɔ ya yinyienm n ya fandi bi niba ki ban fidi ki la i tuonŋanma, ki dondi i baa yua ye tapoli po. ");
INSERT INTO guxg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yin da maali, k n cua k min piini bi tondikaaba yikodi kaa, n cua k min piin ka, ama n cua ki min waani lan buali yaali. ");
INSERT INTO guxg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Klima n maadi yeni i mɔni: tapoli yeni i tinga ya bua lan waagi nandi, ba lanbonli kan fidi ki piini yeni ya yognu k li kuli ne bo pundi. ");
INSERT INTO guxg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yua daani U Tienu maama nni, k ki cɔlni, wan n bo te juodi U Tienu diema nni. Ama yua cɔlni U Tienu diema maama kuli, ki wangi o lieba, k ban ya tie yeni, wani n baa tie nigbengl U Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ki dugni, n maadi, i bontitiedi ya ki ŋani cie U Tienu kadaagu gbanbanda yen farisien nba, i kan kua U Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","I gbadi ki bi bo maadi ti yaja nba: a kan kpaa nulo, ki nulo ya kpaa o lielo, bi bo yi gedi yen o ti buudi danb kani. ");
INSERT INTO guxg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama min maadi: yua beni o pali o ninja po, li buali ki ban gedi yen o ti buudi danbi kani. Nulo ya sugdi o ninja k o tie fanbi, bi bo gedi yen o suif nba buudi danbi kani. Nul ya maadi k o ninja tie yukpienli, bi ba lugu ya mu n kan jundi nni. ");
INSERT INTO guxg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","A ya cua sala yid kanu, ki ba yid sala ki tiadi k a ninjua pia m maama yen a; ");
INSERT INTO guxg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ŋan daani a sala yid kaanu, ki gedi k fin yeni a ninjua n mang yen lieb o, ŋan fidi ki guani ki yidi a sala. ");
INSERT INTO guxg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ŋanbi k cuo a ba fin yeni a lielo ya pia maam; ki yegi ki ca buud daan o kani, ŋan tuodi yin gbadi i lieba maama ki sua ki da paa o san po, wan da ti gedi yen a bi buudi danbi kani, ki ti cedi ban luon a. ");
INSERT INTO guxg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N maad a yeni i mɔni: a kan ñan lan kani, ka ki pani, hali ya yognu ka bi pa li kuli ki kan sieni ba kuuga. ");
INSERT INTO guxg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","I gbadi ki bi bo maadi: a kan dua yeni nuli den pua. ");
INSERT INTO guxg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama min nan maadi: yua nuali o pua k o yanma kua li pua ni, o dua yen o o pali nni. ");
INSERT INTO guxg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A nujienu ninbinli ya ye a po ki cedi ka tie biidi, ŋan ñan o ki lu fagm ki dugni bonyenli ya ki ye a gbanandi po, lan n pia ti ñuadi, yen ban ti taa ŋa ki lu a ya mu n kan bangi jundi nni. ");
INSERT INTO guxg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Li ya sua ka nujienu n kuand a ti biidi nni, jiagu ki lu fagma, ki dugni lan n su yeni a gbanandi kuli n ya ye ya mu kan bangi jundi nni. ");
INSERT INTO guxg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","L den maadi ki yua ñani o denpua, wan ten o ya til n wang i k o ñan o. ");
INSERT INTO guxg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama min n maadi, yua ñani o denpua k li tie mi cuncuma po, li pua ya gedi ki dua yeni ja tian o, o kuani o denpua mi cuncuma nni. Yua kuani ya pua ki o calo ñan o, o mɔ gɔ tieni mi cuncunmi. ");
INSERT INTO guxg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","I gɔ den kpeli ki gbadi ki bi maadi ti yaja nba: a kan maadi maama ki poli ki kandi U Tienu, ki bani ka fa faogu, a ya poli ka bo tieni yaali ŋan tieni. ");
INSERT INTO guxg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama min, n maadi, da l polgi mani can yi i i. Da polgi mani tapoli po, ki dugni tapoli tie naani k U Tienu kaa ki buu ti buudi. ");
INSERT INTO guxg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ba yin da polgi tingi klima li mɔ tie naani k o ŋmaadi o taali, daa polgi mani ba serusalem, ki dugni serusalem tie o bado U Tienu dogu i. ");
INSERT INTO guxg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Da puoni a yuli ki poli, klima a kan fidi ki cedi baa a yuyengu n pendi bi ki bɔndi. ");
INSERT INTO guxg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","I maama ni i bani ki yaali n tie mɔni, yin maadi ki li tie mɔni; yaali n tie faogu, ki li tie faogu i. Yaali n sieni kuli ña ti tuonbiidi kani. ");
INSERT INTO guxg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","I kpeli ki gbadi ki bi maadi: ki nulo ya pua ki pudi o lielo ninbinli, li ŋan ki ban pua ki pudi o mɔ ya ninbinli; a pua ki fendi a lielo ñinli, li buali ki ban pua ki fend a mɔ ya ñinli. ");
INSERT INTO guxg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama min, n maadi: daa gaani man bi niba biadima. Nil ya pab a u jienu kpianu, cab o u ganu kpianu ki wan pabi. ");
INSERT INTO guxg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nulo ya bua bu yen a ki fie a liadi bigi, ŋan cab o a liadi jali mɔ. ");
INSERT INTO guxg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nul ya niina ki ŋan cuoni ki gedi ya banli fagi, ŋan taa li banli fagnu bonbilie. ");
INSERT INTO guxg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Teni yua miad a, da beli yua bua ki ŋan kpend o. ");
INSERT INTO guxg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Igbadi k bi bo maadi: ya bua mani i lieba, ki da bua mani i nandanba beba. ");
INSERT INTO guxg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama min, n maadi: ya bua mani i nandanba, ya jaandi mani yaabi n sɔlgi po, k nan ni; ya jaandi mani yaabi wangdi fala po. ");
INSERT INTO guxg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","yeni, ki ba fidi ki waani ki tie baá yua tagi poli po bidi. Kilima, wani n cedi k o yienu pudi bi nibiadma po yeni bi nimɔnbi po, ki cedi ki taagi ba, bi nimɔnba yeni ti nibiidi po. ");
INSERT INTO guxg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","I ya bua yaabi n bua yinbi beba, i laa ñuadi ki bo laa i? Bi dogdanbi mɔ ki kubi yen kaa? ");
INSERT INTO guxg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","I ya fuondi i naataani beba, i ji tie bee k li cie i liebi? Yaabi n ki ŋua U Tienu maama, bi mɔ ki tie yen kaa? ");
INSERT INTO guxg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yin ji ya tie nimɔnbi, ki da pia biidi k tie nani i baá yua ye tapoli n tie nimɔn maami yeni. ");
INSERT INTO guxg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yin fangi mani i yula ki da wangi bi niba siigi ke ban la ke i tiegi. Yeni i ji kan baa ñuadi i Báa yua n ye tanpoli kani. ");
INSERT INTO guxg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","A ya ba tieni salga a luoda po, ŋan da piebi a naatuna nani bi muyidanba ń tiendi maama yiko bangma diena nni yeni a sanjala po, ke bi niba ń kpiagi ba. N kadi ki maadi yi i mɔmɔni ke bani wani ba bi paabu n yeni. ");
INSERT INTO guxg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama a ya bua tieni a luoda salga, a nuuganu ń da bani a nuujienu ń tieni yaali ");
INSERT INTO guxg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Lan fidi ke a salga ń tieni ŋasiili nni, ke a Báa yua n nua bonli kuli ŋasiili nni ń ŋmiani a a ŋanma. ");
INSERT INTO guxg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","I ya jaandi, yin da tie nani bi muyidanba yeni, bani yaaba n maani ki se ti jaandiedi nni, yeni a sanjala po ki jaandi, ke bi niba ń la ba. N maadi yi i mɔmɔni ke bani wani la bi ñuadi o. ");
INSERT INTO guxg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A ya ba jaani, ŋan kua a dieli nni, ki luoni li ganli, ki jaandi a Báa yua n ye ŋasiili kaanu; a Báa yua n nua ŋasiili nni ba ŋmiani a a ŋanma. ");
INSERT INTO guxg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","I ya jaandi, yin ŋa mi maacianma nani bi nilanba ń maali maama ke mi maacianma n ba cedi U Tienu ń ga bi jaandi. ");
INSERT INTO guxg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Da togdi mani bi tuada kelima i Báa bani yin bua yaali bá ke i dá ki cili i jaandi ki mia o. ");
INSERT INTO guxg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yin baa jaandi maama n ne o: Ti Báa yua n ye tanpoli! a yeli ń gagdi ti gandi nni; ");
INSERT INTO guxg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A diema ń pundi; a buama ń tieni tinga nni nani tanpoli yeni. ");
INSERT INTO guxg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Puni ti dinne ti yentunjiema; ");
INSERT INTO guxg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ŋan tieni ti tuonbiadi po sugli nani ti mo ń́ tiendi sugli yaaba biidi ti po yeni; ");
INSERT INTO guxg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Da ŋa tin baa mi biigma nni, ama ŋan fie ti o biado nui nni. Kelima mi diedma, u paaciamu yeni ti kpiagdi ti a yaali hali ya bina n ki pia gbenma. Ami ! ");
INSERT INTO guxg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","I ya dini sugli yaaba n biidi i po, i Báa yua n ye tanpoli mo ba di sugli i po; ");
INSERT INTO guxg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama i ya ki dini sugli ya niba n biidi i po, i Báa mo kan di sugli i tuonbiadi po. ");
INSERT INTO guxg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","I ya loli bu ñɔbu, yin da biidi i pala nani bi muyidanba yeni, bani yaaba yen ŋmidi ki nunga, ke ban waani bi niba ke bi loli bu ñɔbu. N maadi i mɔni, bani wani la bi ñuadi n yeni. ");
INSERT INTO guxg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama a ya loli bu ñɔbu, ŋan jɔgi a yuli tolade, ki faadi ki ŋanbi a nunga. ");
INSERT INTO guxg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ki da waani bi niba ka ke a loli bu ñɔbu ama a Báa yua n ye ŋasiili nni. Ke a Báa yua n nua ŋasiili nni ba ŋmiani a a ŋanma. ");
INSERT INTO guxg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Da dogindi mani ki tinga ne ŋalmani, naani ke ti bonlulugdi yeni i tontontanmɔni ba biani, naani ke a suuda ba kua ki su. ");
INSERT INTO guxg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama yin ya lingi ki dogindi ŋalmani tanpoli naani ke ti lulugdi yeni i tontontanmɔni kan biidi, ke a suuda mo kan kua ki su. ");
INSERT INTO guxg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kelima a ŋalmani ń ye naani, a pali mo ye lankani i. ");
INSERT INTO guxg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Bu nunbu n tie u gbanu fidsanga. A nunbu ya ŋani, a gbanu kuli baa yieni; ");
INSERT INTO guxg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama a nunbu ya ki ŋani, a gbanu kuli baa ye li bɔnbɔnli nni i. Lanwani i, ya yenyenma n ye a niinni ya tua bɔnbɔnli, li ba tua a po biigcianli i! ");
INSERT INTO guxg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nilobá kuli kan fidi ki ya tuuni canbáanba bilie po. Kelima o baa nani yendo, ki nan bua o lielo; lani yaa ka wan ya taabi yendo ki nan fali o lielo. I kan fidi ki ya tuuni U Tienu po yeni ŋalmani po. ");
INSERT INTO guxg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Lani n cedi ke n maadi yi: «Da yagni mani i yama i miali o, yin ba di yaali lani yaa ka i gbanu po ti tialakaadi po. Li miali ki cie mi jiema aa, bii u gbanu n ki cie ti tialakaadi? ");
INSERT INTO guxg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Diidi mani tanpoli bonyugda: ŋaa buu, ŋaa go yendi mo; ŋaa nan go begindi bonjekaali bá kuli bunbuana nni; Ama i Báa yua n ye tanpoli nan dindi ŋa. I ki pia fuoma ki cie ŋa aa? ");
INSERT INTO guxg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","I siiga nni, ŋma ba fidi o yanyagdi po, ki pugni bá nuukpandunyenli o miali dana po? ");
INSERT INTO guxg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ke be n cedike i yagni i yama ti tialakaadi po? Diidi mani u kuanu nni ku muapuugu ń tie maama: kuu tuuni kuu go pua gaali mo; ");
INSERT INTO guxg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ama, n maadi yi ke bá Salomoɔn yeni o kpiagdi kuli, o nan ki fidi ki nandi yeni bá yengu ń bobi maama. ");
INSERT INTO guxg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","U Tienu ya bobindi u kuanu nni muagu yaagu ye dinne ke bi ba fandi ki kuuni gu u fanu nni, li ba ga ledi i, ke o kan bobni yinba ya niba n ki pia dudugdi boncianla. ");
INSERT INTO guxg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lanwani i yin da yagni mani i yama, ki tua: “Ti ba di be? Ti ba ñu be? Ti ba bobi be? ");
INSERT INTO guxg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Keli ma lani ya bona kuli, bi nilanba n lingi lani. I Báa yua n ye tanpoli bani ke i bua lankuli. ");
INSERT INTO guxg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yin dá cindi ki lingi mi teginma yeni U Tienu diema; I ba yuandi ki lani ya bona ki pugni. ");
INSERT INTO guxg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Da yagni mani i yama saala po; kelima saala ba kubi li yuli. Daali kuli yeni li fala i. ");
INSERT INTO guxg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Daa jaligi mani uba, k U Tiernu mɔ kan jaligi. ");
INSERT INTO guxg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ki dugni bu te bo jaligi i mɔ, ti buud daali. yin bigdi maami ki tieni yeni, bi te ba bigni yeni ki ten i mɔ. ");
INSERT INTO guxg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Be cedi ka nɔ o muanu a ninjua ninbinli nni, k ji ki nɔ o kpadijengu yaali n paani a yali nni. ");
INSERT INTO guxg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A ba tieni ledi ki maadi a ninjua ki wan ŋa k a ñani o muani o ninbinli nni, ki nan ki nua a ya kpadijengu. ");
INSERT INTO guxg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Monafigi, ñan ya kpadijengu ye a ninbinli no, ki fidi nuali ki ñani o muanu a ninjua mɔ ya ninbinli nni. ");
INSERT INTO guxg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Da tugdi mani yali n tie U Tienu yaali ki tieni sangbanli, aya tieni yeni bu juni ni; gɔ da tugdi mani ya laani ki bi tagi yeni wula ki luni i duoli nintuanl ni, i tieni yeni, b bu ŋmaa li po. ");
INSERT INTO guxg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mia mani, bi ba teni, kpaan maani, i ba la, pua mani li ganli, bi ba luodi i po. ");
INSERT INTO guxg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Klima: b tieni yua miadi, ki yua kpaani mɔ laadi, ki luodi yua pua po. ");
INSERT INTO guxg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","I siign nni, ŋmaa n bu teni o bigi li tanli, li ya tie k o miagu kpanu? ");
INSERT INTO guxg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","bii waa li ya tie k o miagu o jam mii? ");
INSERT INTO guxg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yeni yin bia maami kuli, i bani ya bo ŋana ki ba teni i bidi, taalm ŋaa po i, ki i Diedo ba teni yaali kuli ki bua li ya tie ki miagu i. ");
INSERT INTO guxg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yin bua ki bi nibi n ya tiendi yaali kuli i po, i mɔ n ya tiendi yeni li nibi mɔ ya po, ti yikodi yeni U Tieu tondi kadaagu n maadi yaali yeni. ");
INSERT INTO guxg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kua mani ya diñɔbu ñidi, klima ya diñɔbu n yabi sanu caa mi tudmi nni, ki bi niba boncianli nan ŋanbi ki togi lan ya sɔnu. ");
INSERT INTO guxg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama ya diñɔbu ñidi ya sɔnu tie makpangbendgu sɔnu, ki yaabi n togi lan kani nan ki yabi. ");
INSERT INTO guxg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Fangi mani i yula yeni mi tofaama sawalpuaba, bi yi nagni i kani ki tie nani pañoe yeni, ama bi pala nni, ke bi bia nani i fuasangbanli yeni. ");
INSERT INTO guxg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bi luana n wangi ban tie yaaba. Bi ba fidi ki lali duudi konkonbu po oo? ");
INSERT INTO guxg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Li go tie yeni i, tiiŋanbu kuli ba loni luanŋana i tiibiibu mo ń luanbiidi. ");
INSERT INTO guxg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tiiŋanbu kan fidi ki loni luanbiigu, tiibiibu mo kan fidi ki loni luanŋanli. ");
INSERT INTO guxg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ya tibu n ki luoni luanŋana kuli, bi yi cua bu, ki lu u mu nni. ");
INSERT INTO guxg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lanwani ii, bi yi bandi ba bi luana kani i. ");
INSERT INTO guxg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Li ki tie yua n yi nni “O Diedo, O Diedo” ka ba kua U Tienu Diema nni, kase yaaba n tie n Báa yua n ye ŋaljanli nni buama baba. ");
INSERT INTO guxg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Li daali ya pundi, bi niba boncianla ba maadi nni, “O Diedo, O Diedo”, ti den ki jaani ki miadi a yeli po ki bieli mu cicibiadmu uu? A yeli po ti ki tieni yaalidgu bona aa?” ");
INSERT INTO guxg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","N mo ba kadi ki maadi ba, N ki bani hali bada! Fuadi n kani, ti tuonbiidi daano ne! ");
INSERT INTO guxg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Lanwani ii, yua n cengi n maama ki go cɔlni li maama baa tie nani ya yanfodaano n maa o diegu ku tangu po yeni. ");
INSERT INTO guxg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ki taaga ba nii, ki tieni ku ñinkuagu, ku faagu ń figi li diegu, ama ku kan baa, kelima bi maa gu ku tangu po i ");
INSERT INTO guxg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama ya nilo n cengi n maama, ki naa cɔlni ma, baa tie nani ya yanluodaano n maa o diegu mi tanbiima po yeni. ");
INSERT INTO guxg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ki taaga ba nii, ku ñinkuagu ń tieni, ku faagu ń figi, ki pua gu, kun baa ki mumudi yomyomi. ");
INSERT INTO guxg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu ń maadi ki gbeni, wan tundi maama den sia bi niba pala. ");
INSERT INTO guxg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kelima o den tundi nani yua n pia ti yikodi yeni, kaa tie nani a gbanbanda yeni ka. ");
INSERT INTO guxg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","K JESU ñani li juali po, ki jiidi k o nuwuligu ŋɔd o. ");
INSERT INTO guxg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","K gbadl ba nagni o nuntuanli ki maadi: “yobdaan li ya tie k a bua a bu fidi ki paagi nni”. ");
INSERT INTO guxg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ki jesu tandi o nugu ki siigu ki maadi: “n bua, paagi” li yognu mɔno k o gbadimi gbeni, k o paagi. ");
INSERT INTO guxg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ki jesu yed o: “cuo a ñɔbu ki da ŋa oba n gbadi ama gedi ki yaabi n yidi salgi n la ŋa, k ŋan ten o salgi yaali ki Moyiis bo maadi k i gbadli ya paagi wan ten yen, ki ban bandi k a paagi”. ");
INSERT INTO guxg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ki jesu kua kafarnawuum dogu nni, k puldi nba ciamo nagni ki band o ");
INSERT INTO guxg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ki maadi o: “yombdaan n tuonsɔnlo yia ki dua deni, ki lebni ki kan fidi ki fii.” ");
INSERT INTO guxg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ki Jesu maadi o: “n bu gedi ki ban paag o. ");
INSERT INTO guxg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ki pulisi nba ciamo ŋmiani o “canbaa n ki dagdi yeni ŋan kua n deni, maadi lanbonyenli baba, n tuonsɔnlo bu paagi. ");
INSERT INTO guxg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","N mɔ pia canbaa nba ki cɔlinb, ki mɔ pia pulisi nba yaabi n cɔnln nni. N ya maadi yendo: gedi, wan gedi, ki maadi o lielo mɔ baa, wan baa, ki maadi o yombo: tieni ne, wan tieni”. ");
INSERT INTO guxg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu n gbadi o maami ki li ya ki lidi o k o maadi ya bu ŋua o ki tua: yeni i mɔni n maadi, n kpeli ki la o nulo ne Israel buolu nni k o dug n po nandi. ");
INSERT INTO guxg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N maadi fa, bi niba boncianla bo ñaa hali puoli yeni nintuali k baa ki kali ki taani ki dini yeni Abraham, Isaaki yeni Sakɔbi U Tienu deni. ");
INSERT INTO guxg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama sitaani ya ya nibi, b ba te lubi naani k o mu co k kan jundi k bi ŋmani a ñina, k li bubuuli ye. ");
INSERT INTO guxg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","K jesu maadi o jua ne: ya caa k lan tieni nani a dindanli n buali maami. Li yognu k o tuonsɔnbig ne paagi. ");
INSERT INTO guxg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesu bo gedi Pial deni, ki la o cuaro k o dua yeni ti gbanantongdi. ");
INSERT INTO guxg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","K o taa o nugu maani o po, k li gbanantongdi yaadi ki ŋaagu, k o fii k i suani. ");
INSERT INTO guxg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","O yenjuogu, bi cua yeni yaabi n yia i yian buoli kuli jesu kani, k o bieli i cicinbiadmu o maam palu po, ki paagdi bi yianbi, ");
INSERT INTO guxg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ki fidi k U Tienu tondo Isayi n maadi yaali lan fidi ki tieni: o tugi ti biidi yeni ti yian buoli kuli. ");
INSERT INTO guxg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesu n diidi ki sua k o nuwuligu ŋuagu ki yabi, k o puodi bongbanlieli po. ");
INSERT INTO guxg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","K jua ba ne cua ki maadi: canba, n bu ŋɔd a ŋan caa naan kuli. ");
INSERT INTO guxg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu ŋmiani o: i luali pia i fali, ki nuami pia ti tiadi; ama o nul bijua ki pia naani k o ba kpagni o yuli. ");
INSERT INTO guxg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bi ŋuankaaba siign yendi maadi: Yonbidaan, cabi k n da gedi ki pii n baá o. ");
INSERT INTO guxg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ama ki jesu ŋmian o: ya ŋuan ni ki ŋaa bi tinkpib n ya pii bi kuumi. ");
INSERT INTO guxg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","O guani ki doni o ñunbiagun, wani yeni o ŋuankaabi. ");
INSERT INTO guxg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ban paani k o faalu kpid ki yil o ñunbiagu, k a ñunguona bigdi lan cubni o ñunbiagu, li sua k jesu guandi. ");
INSERT INTO guxg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","O yegnkaabi nagni o kani ki findi o, ki maadi: Yonbidaan, faabi'ti, ti bu mi ñum bu dii'ti ! ");
INSERT INTO guxg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","K o maadi ba: bee n cedi ki jie, i dandanli ki yabi ba waami, lani k o fii ki tandi o faalu yeni li mɔgli po, ki li kuli suoni. ");
INSERT INTO guxg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","K li yaakilidi bi kuli, o tie ŋmaa i, ki bi buali bi baan ni, k mi ñuma yeni o faalu kuli cɔlm o? ");
INSERT INTO guxg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wan tuadi bongbanlieli po, Gadarenia dogun, k finfanda lie cua o ki gaa o liigi po, k li sɔnu bo nul bo ki tɔgi o beba kilima li bo pia i jeje. ");
INSERT INTO guxg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ki bi tandi ki maadi: be e n ye tinbi yeni fin siign ni, Daviid bijua, a cua ne ki ŋan waan'ti fala yooo? ");
INSERT INTO guxg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","I duoli bo k ki fagi yeni ban ye naani, ");
INSERT INTO guxg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","k i cicinbiadmu yeni jaandi ki miadi jesu k o ya bu bel'b wan bel'b k kuan'b ti i duoli ne nni. ");
INSERT INTO guxg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","K o beli'b k kuan'bi i duoln, k li duoli san sani ki ban jiidi m ñunciamu nni ki bi bi kuli. ");
INSERT INTO guxg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wan bo yegi yeni yaabi, ki bi sani ki guani o dogun ki waani i cicinbiadmu n bo kubi yaabi yeni n paagi maami. ");
INSERT INTO guxg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","K o nuwuligu ñani ki ŋua jesu, ban lagu ya yognu, ki bi maadi o, ki wan ñaa bi dogun ni. ");
INSERT INTO guxg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","K jesu kua o ŋadgu nni ki puodi li mɔgli, ki lebdi ki kuni o dogu nni. ");
INSERT INTO guxg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ki bi cua yeni jua ba ne o kani k o yia, o nugi yen o taana kulki kpe k o dua i lianŋ po. Ki jesu n la ki bi duu o po boncianli k o maadi l ja: “n biga da jie lba, a biidi piin o”. ");
INSERT INTO guxg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Li yognu k U Tienu kadaagu gbanbanda ba ne ji maali: “yua ne sugdi U Tienu i”. ");
INSERT INTO guxg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ki jesu bandi bi maalma, ki bual ba: “be cedi ki pia li maalbiidi? ");
INSERT INTO guxg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lanbona lie ne siigni, n diidi ya lanbonli maadma paa i, a biidi piini bii fii ki cuoni? ");
INSERT INTO guxg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","N bi waan i, ki yin bandi k o nisaalo bijua pia o paalu i tinga ne po, ki ba fidi ki piini bi niba biidi.” Lan ya yognu, k o maadi yua k o nugi yen o taana bo kpe yeni: “fii ki taa a lianŋ ki ya kuni!” ");
INSERT INTO guxg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","K o fii ki kuni. ");
INSERT INTO guxg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","O nuwuligu n la yeni, k ti jaandi kua ba, ki bi pagi U Tienu yeni wan teni bi niba ya paalu ne. ");
INSERT INTO guxg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesu den ñani lan kani, ki pendi ki la jua ba ne ki bi yi u Matieogu, k o kaa o tuonli nni, ban paa lonpo naani. Ki jesu yedi o: “ya ŋua nni, k o fii ki ŋɔd o. ");
INSERT INTO guxg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Li puoli po ki jesu yeni o ŋuankaaba bi kaa Matieog deni ki je, ki yaaba n bo gaani lonpo yeni bi biidi danba boncianli cua ki kali bi kani. ");
INSERT INTO guxg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Li bo sua ki farisien nba mɔ ye lan kani, ban la yeni ki bi buali o ŋuankaaba: “i canbaa je(di) yeni yaabi ngaani lonpo yeni bi biidi danba, li ŋan nii?” ");
INSERT INTO guxg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesu n gbadi li buali, k o yedi: “yaabi n pia laafia ka kpaani dogda, bi yianma n kpani o. ");
INSERT INTO guxg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gedi mani ki kpaani U Tienu maama ne niima nni, lan diani naani ki maadi: “n bua bi niba n ya jie bi lieba ninñuma, mii bua ki ban ya yid ba salg kaa.” Ki jesu ji guani ki yedi lani: “mii cua k min yini bi nimɔnba ka, ama bi biidi danba.” ");
INSERT INTO guxg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lani ki San o ñunwulka ŋuankaaba nagni ki buali jesu: “li tieni ledi k tinba yeni farisien nba pa ki lolgi bu ñɔbu, k a ŋuankaaba nan ki lolgi i?” ");
INSERT INTO guxg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesau ŋmian ba: “yaabi k bi yinba puobianli jaama, ba fidi ki ya kaa yeni li pabɔnli ya yognu k o puodaan o da ki ye yenba. Lan, bobni mani, klma, o yogu cuoni k o puopaan o calo te kan ya ye yenba, li yognu i, ki bi te ba loli bu ñɔbu. ");
INSERT INTO guxg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nul te kan taa cabpanli, ki libi tiadudngu po. O ya tieni, li cabpanli yeni n bi cedi o tiadudngu yeni n padi ki pugni li lonli n yabdi ki cie cincinli yali po. ");
INSERT INTO guxg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bi ki tugdi mi daapaam ki ŋmadi yeni mi daakpelima. Lan ya ka mim daapaam ba buoni u manu i, ama bi ba piagi mi daapaam li bagpaanli nni, yeni, li baa ye yeni o manu i. ");
INSERT INTO guxg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu n yedi ba yeni, ki li nucingli cua ki gbaani o nuntualn ki maadi: “n jafaano da li kpe mɔlanei, a ya cua ki taa a nugu ki maani o po, o ba guani ki fuodi.” ");
INSERT INTO guxg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ki jesu fii, wan yeni o ŋuankaaba ki ŋɔd o. ");
INSERT INTO guxg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ki li sua ki pua ba, laadi o faadi, ki laa kolgi piiga n bina lie n yeni. Jesu n caa, ki li pua nagni o puoli po ki sii o liadl ñɔgbanli, ");
INSERT INTO guxg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","klima, o bo maali o paln nni k o ya sii ba o liadl k o bi paagi. ");
INSERT INTO guxg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ki jesu gbagi, ki lagu k maadi: “n bi puoga, a dindanli paag a”, ki li yognu mɔno, l pua paagi. ");
INSERT INTO guxg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesu n pundi li nigbengli yua bo yin o yen deni, ki la a yelpieba yen o nuwuligu k bi ñɔgi. ");
INSERT INTO guxg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","K o maadi ba: “ya ña mani, i jifanbiga ki kpe ka, o gɔa i.” k li nibi ji cili k laagu. ");
INSERT INTO guxg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ban beli ki ñani li nuwuligu, ki Jesu kua ki cuo i jifanbiga nugu k o fii. ");
INSERT INTO guxg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ki li laabaali yadi li dogun kuli ");
INSERT INTO guxg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu n ñani li kani ko paani o sɔnu ki caa, ki bi juanma bonbilie tandi ki yin o: “David bijua, a kan jie ti yeni mi nunñumaa?” ");
INSERT INTO guxg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesu n pundi deni, ki bi juanbi yeni nagni o kani, k o buali ba: “i tama k n ba fidi ki nuali nni?” ki bi tuo ki maadi: “iin, ti diedo.” ");
INSERT INTO guxg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Li yogunu ko sii bi ninbina ki maadi ba: “lan tieni nani yin maal maami yeni.” ");
INSERT INTO guxg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ki bi ninbina luodi ki bi ji nua. Ki Jesu maadi ba k ban da cedi nul n bandi (gbandi). ");
INSERT INTO guxg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama, ban ñani ya yogunu, ki bi ji cili ki maadi li laabaali kaana kuli po. ");
INSERT INTO guxg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ban ñan ya yogunu, ki bi cua yeni muug ba jesu kani k a sanpola ŋua o. ");
INSERT INTO guxg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","K o beli li sanpola, ki muugi ji cili ki maadi. K li ji cuo cila ya nuwuligu n bo ye li kani ki bi ji maadi: “tii kpeli ki la ne, Israel dogun ne. ");
INSERT INTO guxg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ki Farisien nba wan nan maadi k o kubbi sitaani ya paalu i, yua n tie a sanpola bado, ki yaandi a sanpola. ");
INSERT INTO guxg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu bo caa i dogciamu yeni a lon gbana nni, ki tundi bi niba b tantaan diedn ni, ki muandi U Tienu laabaamanli, ki gɔ tebi i yian buoli yeni bi ninbadanba. ");
INSERT INTO guxg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesu bo yi la o nuwuligu mi ninñuma n cuo o, ki dugni bi pala bo wadi, ki bi tie nani ya pei ki pia pekpali yeni. ");
INSERT INTO guxg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","K o maadi o ŋuankaaba: “bu kpaabu yabi ama k a tuonsɔnla ki yabi. ");
INSERT INTO guxg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yeni, mia mani o kpadaani, k wan pugni a tuonsɔnla o kpaabun ni. ");
INSERT INTO guxg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","K jesu yiin i o ŋɔdikaabi piiga yeni bonmlie k teni'b u paalu k ban ya bieli a sanpola, k paagdi i kunkodbuoli kuli, yeni b cacagdaami. ");
INSERT INTO guxg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesu n bo sɔni u ŋɔdikaabi piiga n bonmlie yaab yela nne: cincinli yua n tie Simɔn, yua k bi yi'ug Piali, yeni o ninjua Andili; Sebede bid, lan tie Saaki yeni o ninjua Sani; ");
INSERT INTO guxg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filiipi yeni Batelemi; Tomayeni Matieog yua daa bo gaani lonpo; Alfe bijua Saak, yeni Tade; ");
INSERT INTO guxg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔni yua bo kɔni o dogu po; yeni Suuda Iskariɔt yua bo kuadi Jesu. ");
INSERT INTO guxg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Piigi n bonmlie yaabi k Jesu bo sɔmi n yeni k maadib'i k: «daa caa mani yaabi n k tie sufi - nba kani, k gɔ daa kua samaliteni -nba dogu n ni. ");
INSERT INTO guxg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yaa caa mani Isalaheli buolu n ni nibaa po ban tie nani i pei yaabi bodi yeni ");
INSERT INTO guxg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","I yaa caa yi ya kpaandi k u tienu bali nagi. ");
INSERT INTO guxg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yaa paagidi mani b kunkoddanmi, k yiedi b kpienma, k yaa paagdi a gbaada, yaa bieli mani a sanpola k yaandb'i n pun'i ni i k daa kaa, mɔn yaa puuni mani k daa gaan bonli. ");
INSERT INTO guxg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yin daa kubi wula, k bia ŋuuni ligi baa i bɔga n ni ");
INSERT INTO guxg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Daa kubi mani bɔgli daa la mani liada lie daa kpaan mani cacaaɔgu; k gɔ da kubi lanbanli kilema tuonsɔnli kan luo u jiema. ");
INSERT INTO guxg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","I yaa pundi yaa dongbanbig n i bii yaa dongbanciangun i, yin buali k la b nimɔma deni, k gadi k yaa ye lan kani hali yeni yaa daali k i bu pendi. ");
INSERT INTO guxg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","I yaa kua l deni yi gaali l deni nuba i gaali ŋani. ");
INSERT INTO guxg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","B yaa tie numɔma i ñɔgaaliŋani n yaa ye yen'm. B yaa tie numɔma i ñɔgaali ṅ guan i po. ");
INSERT INTO guxg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","B yaa gaa i, k gɔ k sogi i maama yi ña l deni lani yaa kaa l dogu n i, k pidi pidi i taana u tangungu. ");
INSERT INTO guxg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yeni i mɔni i maad'i u tienu n bo bu b nubi kuli yaa daali, sɔdɔm yeni Gomɔl yaab yaali baa yeni l dogun yaabi. ");
INSERT INTO guxg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ŋanbi sogi mani; n sɔni nani pabidi yeni i yangbanli siiga n ni. yaa sogi mani e wae yeni, yaa tie suoo mani o lanjel yeni. ");
INSERT INTO guxg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cuo mani i baa yeni b nubi, k dugn i b bo gadi yeni t buud yudanm kani. ban cuo i k pua i yeni a naapuna b tantaadiena n i. ");
INSERT INTO guxg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","I yaa po i k b bo gadi b dogdanm kani, yeni b batiebi kani. Yin maadi i mɔni n po bani yeni yaaba k tie sufi -nba nunŋ n i. ");
INSERT INTO guxg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yaa yogu k b bu gedi yeni yin daa buali yin bo maadi nandi bii yin bo maadi yaali kaa, i kan luo yaali k i bo maadi l yogu mɔno. ");
INSERT INTO guxg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","K dugn i yim kaa bo maadi i baa u tienu mɔno n bu waani yaali k i bo maadi. ");
INSERT INTO guxg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","O nuli t bo kuadi u ninjua ban kpaa'ɔg bibaa n kuadi u biga, a bila t bo fii k kɔni yeni b danmi k cedi ban kpab'i. ");
INSERT INTO guxg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","B kan yaa t bua i maam k dugn n po. Ama yua bo mind hali yeni l juogi u tieni bo fie wani ");
INSERT INTO guxg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yaa dogu n i k b waani fala, yin sani k gadi dogu tianu. Yeni i mɔni n maad'i i kan waa k gbeni Israheli dogi kuli k u nufosaal bijua k cua. ");
INSERT INTO guxg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","I bani k yua bangi tuonli kan fidi cie o canbaa, o yomo mɔ kan fidi cie o yomdaani. ");
INSERT INTO guxg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yua bangi tuonli yaa tie mani u canbaa yeni, k o yonmo mɔ tie mani o yonmdaano yeni, laa dagidi. B nan yiin o diedaani Besebuul o b ji bo yiin i u deyaaba ledi? ");
INSERT INTO guxg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Lani daa jie mani l nubi, k dugn i bonl k duagi, k t kan dɔgdi, bonl gɔ kan yaa tie haasiili k nuli t kan bandi. ");
INSERT INTO guxg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","N yaa maadi yaali l biigl n i, yin maad'm o yensiin n i. N yaa bulmi k maadi yaali yin maad'm b nib kuli n sogi. ");
INSERT INTO guxg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Daa jie mani yua bo kpa nuli k nan kan fidi kpa o nanligi. Jie mani u tienu wan bo fidi cedi o nuli nanligi yeni o gbanu kuli n bia u muu n i. ");
INSERT INTO guxg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Baa kuadi nuanbidi bonmlie k gaani i ligi waama ne ii? Ama i siign i baa yendi kan baa tingi n i, k l yaa tie k i baa u tienu buami yaa kaa. ");
INSERT INTO guxg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yinm wani u bani i yudi m ɔno n dɔ nandi. ");
INSERT INTO guxg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lani daa jie mani bonli, k dugn i cie t nɔnbidi kuli. ");
INSERT INTO guxg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yua maadi b nubi siign i k u tie n yua, n mɔ t bu maadi n baa yua ye tanpoli po nungn i k n ban'o. ");
INSERT INTO guxg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama yua yie k waa tie n yua b nubi siign i, n mɔ t b yie'ug n baa yua ye poli po nunŋ n k mii ban'o. ");
INSERT INTO guxg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Daa maali mani k baa yeni t mandi kaa b nubi siign i i tingi ne po. N k baa yeni mandi, n baa yeni l kɔkɔnli. ");
INSERT INTO guxg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N baa k mi paadi i bijabigi yeni u baa i, i bipuoga yeni u naa i, u pua yeni u calnaa i. ");
INSERT INTO guxg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","O nuli nataanu mɔno n t bo kpandi u ninnando. ");
INSERT INTO guxg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yua bua u baa bii u naa k cie n waa dagdi yeni wan tɔ n ŋuado. Yua bua u bijua bii u bisalo k cie n o mɔ k dagdi yeni wan tɔ n ŋuado ");
INSERT INTO guxg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yua mɔ gɔ k tugi n dapɔnpɔnli k ŋɔdi'n u mɔ k dagdi yeni wan tɔ n ŋuado ");
INSERT INTO guxg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yua kpaani k wan fie u miali u bu biani u miali. Ama yua luni u miali k dugn i n po u bu gua k la u miali. ");
INSERT INTO guxg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yua gaa'i u gaa mini, yua gaa n mɔ gaa yua sɔn'n i ");
INSERT INTO guxg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sogni ya baa k nuli gaa'o k dugn i u tie u tienu sogni u bua la u tienu sogni ñuadi, numɔni yaa baa k nuli gaa'o k dugn i u tie numɔni, u bu la l numɔno ñuadi. ");
INSERT INTO guxg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yinm n ŋɔdikaabi, i k tie nugbenga kaa ama yua bu kabi baa ñisɔngnmi k teni i siign i yendi k dungn i u tie n ŋuado, n maadi i mɔni, u kan luo u ñuadi. ");
INSERT INTO guxg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu n gbeni o tunda yeni o ŋuankaaba, ko puodi ya longbanbimu sien ki tugni ki muandi U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","San bo ye o dansaldiegun ki gbia ya tuoŋana bo tie kuli, k o sɔni o ŋuankaaba k bi bual o: ");
INSERT INTO guxg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","fin n tie yua k ti guu bii ti gɔ da ba guu tian i. ");
INSERT INTO guxg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu ŋmiani: ya ca mani ki ban waani San yin la yaali yeni yin gbadi yaali: ");
INSERT INTO guxg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bi juanbi nuni guani ki nuali, i wabbmu fii ki cuoni, a gbada nugi tandi, a tubkpaana cili ki gbia, k bi tikpiib fii t kuldn ki talgnba gbia li laabaamanli. ");
INSERT INTO guxg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Li pamanli yabi yaabi n duu n po k bi dindanli cie. ");
INSERT INTO guxg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ban paani ki ca k jesu cili ki ji maadi San po o niwuligun nni, i gedi ki diidi bee i tinkuongn nn i? li galgunli yua ko faagu migni i? ");
INSERT INTO guxg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ama i gedi ki ban la ŋmaa i? ya nilo ŋanbi ki lani k li ŋan nni? diidi mani yaabi n la ti tiaŋandi tie yabi n kua bad diegu. ");
INSERT INTO guxg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","I ji gedi ki ban la bee? U Tienu tondo o? n, i bi jiin n, o cie U Tienu tondo. ");
INSERT INTO guxg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kilima li tie yua k li bo diani ki maadi: diidi mani, n bi sɔni n tondo k wan bobni i sɔni ki guudi a cuama. ");
INSERT INTO guxg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yeni i mɔni n mkaadi, bi puobi madn kuli, ti da ki la San ya lielo, li tie yeni ti Diedo diema nni i big n tie ciamo k cie bi kuli. ");
INSERT INTO guxg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lan cili San yognu ki pan pundi hali mɔlane, ti Diedo diema ti mi tuami, ki bi gbanmandanbi kɔni bi ŋmiali nni. ");
INSERT INTO guxg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kilima bi tondikaabi yeni ti yikod kadaagu bo maadi U Tienu maami yo, k San fidi ki yuandi cua. ");
INSERT INTO guxg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ki ya bua yin gbadi niimn ni, ban yi yua Elin bo bi cua. ");
INSERT INTO guxg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ki yua pia ti tubdi ki ba gbadi, wan gbadi. ");
INSERT INTO guxg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ki mɔlane nibi ne, bi naani yeni bi lee? ya bila n kaa bi niba n paa ki tigli naani, k sieni, ki yi bi lieba, ");
INSERT INTO guxg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ki maadi: ti piebi i naagbaamu (i yelmu), ama i ki jeli (ŋɔni ciagi), k ti yini i kuuyani, i ki mɔni kumɔni (ku bubuuli). ");
INSERT INTO guxg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ki dugni, San cua k ki di, k ki ñu (ki lolgi o ñɔbu), k bi yedi ki cicibiadmu ŋuagu. ");
INSERT INTO guxg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ki nufosaali bijua cua ki di, ki ñu, ki bi yedi k o puoli mani ki kandi, ka tie dañuuli, k tie lonpogaala yeni bi bid danbi dɔnli. Ama mi yanfuomi waani o tuona nni yaali ntie bonmɔnli. ");
INSERT INTO guxg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Li yognu k Jesu cili ki ji fu yeni ya nibi k bi dogin k bi tieni ti paldi boncianli, k bi tɔgu nan ki lebdi. ");
INSERT INTO guxg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yubonli a po, koransen! yubonli a po betesayida! ki dugni ya yaalidgu bona tieni i siigni ya bo tieni Tiir yeni Sodɔm, hali daal o mani bi tugi o kpalpiagu yeni mi fantanpiema ki tuuba o. ");
INSERT INTO guxg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Li ya po i k n maadi: daa jijuog buud daali, Tiir yeni Sodɔm b la sugli ki cie yi i. ");
INSERT INTO guxg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Fin, Kafarnawuum, a mali k fin yeni a yabnu kuli a ba si tawlgbɔngu i? N n, a ba jiidi hali o tinkpiigun, ki dugni ya yaalidgu bona tieni a siigni k a k lebdi ne ya bo tieni Sodɔm i, mani o da sieni ki ye dinla daali. ");
INSERT INTO guxg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Li po n cedi k n maadi, k daa jijuogi daali sodɔm buud baa suu yen ni. ");
INSERT INTO guxg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Li yognu k Jesu gaa mi maama ki maadi: n dond a, ti Diedo, poli yeni tinga canbaa ́, yeni ŋan wuoni bi yanfuodanbi yeni bi nunfandanbi ya bona ki nan tugi lani ki waani a bila. ");
INSERT INTO guxg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","N, n Baá, n dond a yeni ŋan bua ki lan ya tie yeni. ");
INSERT INTO guxg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","N Baá ten nni u paalu bonli kuli po, k nul k bani bijua, li ya ki tie Baá yaa ka, k nul ki bani Baá li ya ki tie o bijua yaa ka yeni yua k o bijua waani o ");
INSERT INTO guxg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cua mani n kani, yinbi yaabi n cɔgi, ki tugi k li kpiagi, k min teni mi fuoma. ");
INSERT INTO guxg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tugi man n fala ki cengi m maami, ki dugni n tie pasiadaani ki gɔ jiind nba, ki bi la i nalimi fuoma. ");
INSERT INTO guxg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ki dugni, n tugli yua k ki kpiagi. ");
INSERT INTO guxg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Li tie saba daali ki jesu pendi ya kpaabu nni ki i dii beni, ki mi kom cuo o ŋɔdikaaba, ki bi togidi ki ŋmani. ");
INSERT INTO guxg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ama Falisien nba n la li bona ke bi maadi jesu: diidi a ŋɔdikaaba ne, bi suani ya tuonli ke ti yiko ki cabi ke lan tieni saba daali. ");
INSERT INTO guxg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ama ke jesu ŋmiani: yi k bangi ki gbandi DAfidi yeni o niba n bo tieni yaali ya yoginu ke mi koma cuo'ba aa? ");
INSERT INTO guxg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bi bo kua U Tienu jongun nni ki tugi saligi kpanu ke wan yeni o yegini ŋmani, ke li naa bo cabi ki wan yeni o ŋɔdikaaba ba yendo n ŋmani. U Tienu ya po li bontitiedi bo ki tie kuali ka. ");
INSERT INTO guxg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yi cogi Moyisi n den diani yaali o ku daagun nni ke bi saligi yidikaaba n yidi saligi laadi daali ke li ki tie biidi. ");
INSERT INTO guxg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ama n maadi, n cua yi kani, ke n maami mɔni ke cie i jaandielin yikodi, li ya po ya tunda ke n tieni mɔn i po ki cie yeni yi yanjanba n den waani yaali damiwoncil po. ");
INSERT INTO guxg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yi bo baa tiani li maama i diani nni;”n bo suni ke mi maadi yeni mi buama ke cie yeni min ya yidi saligi ki wangi. Li tie ki bo bani mi maadi yaali niinma nni, i bo kan maadi n ŋɔdikaaba ke ban tieni yaali ke tie bonbiili ka. ");
INSERT INTO guxg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","N tie o nilo bijua ki pia yiko yeni mi maadi bi niba yaali n tie bi tuonli laadi daali. ");
INSERT INTO guxg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ki jesu siedi bi kani ki ban kua bi jaadieciangun nni, ");
INSERT INTO guxg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ko la nilo ko nugu kpe, ki falisien nba bualo, li cabi ki tin paagi yianmo laadi daali. Bi den maali ki jesu den maadi ki tudi ki ban pun'o i jaligi. ");
INSERT INTO guxg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Ko ŋmian'ba: yi siigan nni ŋmaa ya po i yo ko yangi ba baa u buugun nni laadi daali ko ba ŋaa ke kan ñano ke wan ñiindi lien nni? Yi ya po li bontitiedi buali? Li ya po, o nisalo pia ti kpiagidi ki cie i yanga, lan li buali ki ban paagi yianmo laadi daali i? ");
INSERT INTO guxg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ki jesu maadi li nilo: tandi a nugu, ko tandi li yoginu mɔno ko nugu paagi. ");
INSERT INTO guxg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Li yoginu ki Faliusien nba ñani u jaandieciangun nni, ki ji kpaani ban ba loli maama ki biani jesu. ");
INSERT INTO guxg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu den bansdi ki Falisien nba den kpaani ban bian'o, lani ko tugi o ŋɔdikaaba ki fagidi li kani, ke o niwuligu yeni bi yianma ŋua ko paagi'ba. ");
INSERT INTO guxg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Li yoginu mɔno ko maadi'ba ke ban da ŋaa ki nilo n bandi wan tie yua. ");
INSERT INTO guxg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wan maadi yeni ko tieni nani Isayi n bo maadi yaali. ");
INSERT INTO guxg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Diidi mani n tuonɔnlo yua ke n lugit'o ki bua'o, wani ki n du o po, n ba kuan'o mi fuonma, ke wan fidi ki bu yabi n ki bani U Tienu. ");
INSERT INTO guxg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bi kan kɔni, bii kan tandi lani tie ban da gbadi bi maama kaana kuli. ");
INSERT INTO guxg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O baa mani yeni taliginba, ke nilo yua nagi ba mi kuumi, o ba nualo, ama ki bi niba ya sanu n tuagi nni. ");
INSERT INTO guxg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Li ya po yaabi n ki tie IIfi ba daani 'o. ");
INSERT INTO guxg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bi den cua yeni nilo jesu kani ko tie juamo ki gɔa tie muugi ki dujgini li daano den gbie yeni ti fuobiidi, ki jesu paago ko cili ki maadi ki gɔa nua. ");
INSERT INTO guxg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","O niwuligu n la li bona ki ya ki lidi ki bi buali, o ne n kilisiti, dfiidi bijua yua ke ti gu yeni? ");
INSERT INTO guxg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Falisienba n gbadi li paligu tienu ki bi yedi: o ki tie U Tienu ka, Belisebuli, ti fuobiidi canba n tieno li paalu ke wan beli ti fuobiidi. ");
INSERT INTO guxg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ama ke jesu bandi bi maalima ke maadiba: ya buoli n yabi kɔni yen o niba caa ke wan biai, ki ya dogu bii ya diegu ke kɔnkɔna yabidi kuli ba mudi. ");
INSERT INTO guxg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Li tie yeni ki sitaani ya ba fidi ki beli o sitaan lieba, li tie ko guani ki kɔni yeni oba i. ");
INSERT INTO guxg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yaali n tie bonbiadili, sitaani ya tieni ya paalu ke min beli ti fuobiidi, ki yinbi i ŋɔdikaaba bi le n bieli'b bii? ");
INSERT INTO guxg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama n ya bieli sitaani yeni U Tienu ya fuoŋanbi, yen wani u Tienu diema ba i po. ");
INSERT INTO guxg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","N ba waani yaali ya po k n pia ya paalu n bieli ti fuobiidi, nilo kan fidi ki kua paaldaano deni ke ko daano ne bo ki tuodi ki bani o pundima po, o ya tie o dɔnli o ba yendi yeni o den kuli. ");
INSERT INTO guxg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yinbi yaabi n bani ki U Tienu fuoŋanma tien'n o paalu ki n bieli ti fuobiidi kuli tie n yibalinba. ");
INSERT INTO guxg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","I maadi ke li ki tie fuoŋanbi paalu po ka ke n bieli ti fuobiidi, lan n maadi ne: yabi n cagini ki gɔ sugidi bi lieba ya mia U Tienu bi biidi sugili, o ba di sugili bi po, ama o kan di sugili yabi n sugidi ki maadi ti maabiidi o fuoŋanbi po. ");
INSERT INTO guxg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","U Tienu ba di sugili yaabi n kpagini mi maama po, min o nilo bijua, li yoginu, n maadi ko Tienu kan di sugili yaabi n maadi ti maabiidi ki sugidi o fuoŋanba lan tie mɔlane yeni ya yoginu dua ki baadi kuli. ");
INSERT INTO guxg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tiŋangi kuli luoni a luan ŋanma i, ko tibiigu mɔ luoni ti luanbiidi, bi bandi i tiŋangi o luana kani, ");
INSERT INTO guxg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","yinbi yabi ntie walaba buolu, nibiada, li ba tieni ledi yi mali ya maalinma ŋani i? kelima, yi pali n gbie yeni yaali yi ñɔbu mɔ maadi lani. ");
INSERT INTO guxg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","O niŋanmo suani a tuonŋanma i tinga po ko nibiigu mɔ suani o tuonbiidi ki biligi i tinga po. ");
INSERT INTO guxg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ki n maadi ke ti buudi daali, bi niba ba dugini bi maabiidi yaali ke bi den maadi kuli. ");
INSERT INTO guxg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","I maama po ke bi ba buu'yi, i maama po ke bi ba biani. ");
INSERT INTO guxg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lan ka gbanbanda yeni Falisienba maadi jesu: canba tien paligu ke tin diidi, ");
INSERT INTO guxg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ki jesu ŋmianba ki maadi: kangbada yeni concona buolu bua ban la u paligu, ama yi kan ji la paligu lan ñani Jonasi n bo tieni ya paligu. ");
INSERT INTO guxg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nani Jonasi n bo tie daana ta yeni ñiadi ta o janciangu tugini, li tie yeni ki o nilo bijua ba tieni daana ta yeni ñiadi ta li tinpualin nni. ");
INSERT INTO guxg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninif niba ba fii ki sedi yen nni U Tienu buudi daali kelima bi ŋaa bi tuonbiidi kuli ki cengi Jonasi, mɔlane n ji cua yi kani ki mɔni ki cie Jonasi, li ya po U Tienu ba buu'i. ");
INSERT INTO guxg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","U Tienu buudi daali yanbangu puobadi ba fii yeni o yoginu niba ki bian'ba kelima bi cengi Salomɔ, ke min nan cie Salomɔ ");
INSERT INTO guxg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Fuobiigu ya ñani nilo kani o yi gedi naani kuoni ki kpaani ya daano ko ba ye yen'o, ");
INSERT INTO guxg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","o ya ki la o yi maadi oba, n ba guani min ñani naani po, o ya guani o yi la k U Tienu fuoŋanba ki yeni li daano yenma, li daano yenma tie nani ya diegu ke bi ŋanbi ki tingini ki li ŋani. ");
INSERT INTO guxg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","lan wani o yi gedi ki ban kpaani ti fuobiidi bonbi lele ki pugini o po ban ba ki ya ye lan kani. li daano yinyienu ba ŋanbi ki biagi ki cie cincinli. li nan ba tua yeni ya niba gbadi mi maama li dajijuogi daali bi po. ");
INSERT INTO guxg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu n bo maadi yeni o niwuligu yeni i, ko naa yeni o ninjabi cua ki sedicincanli, sɔni nilo ki ban waani jesu ki bi ye. ");
INSERT INTO guxg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ko maado: diidi a naa yeni a ninjabi gu'ŋa, bi kpaani ban maadi yen'a ");
INSERT INTO guxg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ki jesu ŋmian'o ki maadi: ŋmaa n tie naa i? ŋmaa n tie n ninja i? ");
INSERT INTO guxg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ko tandi o nugu o yeginkaaba po ki maadi: diidi mani yaabi n cengi ne, n naa yeni n ninjab n yeni. ");
INSERT INTO guxg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yaabi n tiendi n baa n bua yaali ban n tie n naa yeni ninjaba ");
INSERT INTO guxg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lan daali, jesu den ñani o deni, ke kali, Galile ñincianma jaali kunu ke bangiba, ");
INSERT INTO guxg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bi niba boncianla den taani o kani, o den kua ki kali o ŋadigu nni, ya niba n yabi yeni kuli den ye li jaali po. ");
INSERT INTO guxg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesu den maadi'ba mi maama boncianla yeni mi kpanjama ke yediba: “o kpakuolo den ñani ke ba pagi i bonbuoli. ");
INSERT INTO guxg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wan den pagini ya yoginu, li tiani den ba u sankunu, ke ti bonyugidi den cua ki dini yi. ");
INSERT INTO guxg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","I tiani mo den ba tancaga tingin, mi tama n ke yabi naan kani, li den pudi tontoni, nani mi tama n ki yabi yeni. ");
INSERT INTO guxg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ama u yienu n den paagi li bonbuli kaala den mali ki kuodi, kelima laa den pia jiin moani ");
INSERT INTO guxg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","I tiani mo den ba i kokoni nni, i kokoni den fii ki dini yi. ");
INSERT INTO guxg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bonbuo tiani mo den ba ki tingŋana nni, ki den pudi ki loni, i ne den loni, kobiga kobiga, i tian mo piluoba luoba, i ne piitata. ");
INSERT INTO guxg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yua n pia atuba ki ba gbadi, wan cengi. ");
INSERT INTO guxg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bi ŋ̇ɔdikaaba den nagini jesu kani ke den yedo: “be ya po yo ka maadiba mi kpajam. ");
INSERT INTO guxg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu den guani ki yedi: “bi puni yinba wani n bandi tanpoli dienma nni bondoginikaali, ama laa tie bi ya po ka. ");
INSERT INTO guxg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kelima yua n pia bi ba pa o ki pugini wan ya pia boncianla, ama yua n ki pia wani bi gaa o kani ba wan pia yaali. ");
INSERT INTO guxg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Li tie lani ya po yo ke maadiba mi kpanjam, kelima ba ke bi nua bi kan la liba, ba ki bi cengi mɔ, bi gbadi liba ki bandila. ");
INSERT INTO guxg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bi ya po li tieni ki gbeni, nani Isayi yua n sɔgini u tienu maama ki yedi: i ba cengi yeni i tuba ke kan gbadi liba, ke nɔnli yeni i nuni, ke kan liba kuli. ");
INSERT INTO guxg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Li tie yeni bani ke Isayi masɔginkaaba kua ki gbeni, wan den yediba yaali, i ba cengi ama i gbadi liba, i ba nɔnli ama i kan la liba, kelima bi naa niba pala juagi, bi gnali bi tuba kaa bua gbadi, bi tie yeni ki kaa bua ki ŋaa bi tuonbiidi ke min nɔnli'ba ki bua'b bii ki faabi'ba. ");
INSERT INTO guxg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Li pamanli ye yeni yi, kelima i nuni nua, i tuba mɔ gba. ");
INSERT INTO guxg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","N waani yi mɔnmɔni, u tienu maama sɔnginkaaba boncianla, yaabi n tiegi den bua ki la ya bonla ki nua ne, ama baa la, bi den bua ki gbadi yi gba yaali ne ama baa gbadi. ");
INSERT INTO guxg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Lan wani yi cengi o kpakuoli kpanjama yeni li bundima. ");
INSERT INTO guxg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ya yoginu ko nilo cengi tanpoli dienmin maama ki naa gbadi lan bua ki yedi yaali, sitaan cua ki ñani ban buli yaala o pali nni, wani n tie ya bonpagikaala n ba u sankunu. ");
INSERT INTO guxg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ya bonbuoli n ba i tancagi tinga nni mɔ tie yua n cengi mi maama ki gaanma tontoni yeni li pamanli. ");
INSERT INTO guxg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama o kan fidi ki sedi ya yoginu ki mi yepaama cua o kani, bii bi niba ya wan'o fala ŋanduna nni, waa pia jiini, se wan gbali ki ba. ");
INSERT INTO guxg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yinba i konkoni tinga mɔ tie yaabi n kpaani ki tua piada, ba kpaagi bontiali po se i ligike tie yaali n dagidi bi po, bi sundi u tienu po, ba tiendi u tienu n buali, bi tie nani ya tinga gbie i konkoni yeni. ");
INSERT INTO guxg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ya bonbuoli ba ki tingŋanga nni, li tie yaaba n cengi mi maama ki gaa mi gbadima yeni mɔmɔni, li tie bani n luoni li bonluonkaali, kobiga kobiga, piiluoba luoba, yeni piitata. ");
INSERT INTO guxg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu gɔ den pua'ba kpanjam tɔma ki yedi;'tanpoli dienm naani nani ya nibi nden buli o kuanu nni. ");
INSERT INTO guxg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wan den gɔa ya yoginu, ko yibali den cua buli i naniidi u kuanu nni, ki guani ki kuni. ");
INSERT INTO guxg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Li bonbulkaali n den pudi ki loni ti muabiandi'ti yaali n tie naniidi yen mɔ kɔ den dɔgidi. ");
INSERT INTO guxg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","O kuadaano, tuonsɔnba den cua ki yedi'o, canba, ŋaa den buli bonbuoŋanm ka a kuanu nni? Be ya po yo ki naniidi mɔ nan ji ye lien n? ");
INSERT INTO guxg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O den guani ki yediba, li tie yibali n sɔni lan ya tuonli, lani ki bi naacenba ŋmiano: a bua tin gedi ki pan ŋabi bii? ");
INSERT INTO guxg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Canba den guan'ba: yen ka, ya jie mani ke yi da te taani ki ŋabi i bonbuoŋanmi, ");
INSERT INTO guxg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ŋaa li kuli n ya kpedi hali li dipeli, lan yoginu n ba yedi a dipela, ban cindi ŋabi i naniidi (ti muabiadi) ki loli ki sia( ju) ama ki yi taani i diŋanmi n bɔnbualin. ");
INSERT INTO guxg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu gɔa den pua'ba mi kpajatianma ki yedi: “tanpoli dienma naani nani ya bonbigu n wa (ñidi) ki cie mi juobinm, ke o nilo den taa ki ŋuu o kuanu n. ");
INSERT INTO guxg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lan ya bonbii ñidi bii wa ki cie i bonbii kuli, ama bu ya kpedi ya yoginu bu yen tua ticianbu ki cie o gogdigu naan kani ki ti bonyugidi ba fidi ki cua ki tieni bi tiadi bu beni nni. ");
INSERT INTO guxg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu gɔ den togidiba kpanjatiali ki yedi: “tanpoli dienma gɔa tie nani li dabinli yeni, o pua den taa ki muani yeni yiemu taa ki sieni ki li kuli fii (k nɔbi) ");
INSERT INTO guxg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu den bangi li niwuligu ki maadi'ba laa bonli kuli yeni mi makpanjam, waa den maadi yenba ka ki pua kpanjam. ");
INSERT INTO guxg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Li kuli ne den tie lan kuani u tienu nisɔngikaaba maam po man tieni, m maadi mi kpanjam, n ba maadi'ba mi kpanjam ki dɔgidi ya bona n den wuo hali ŋanduna cilima yoginu. ");
INSERT INTO guxg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesu nden cabi lan ya niwuligu, o den kua o diegun nni, lan ya yoginu bi ŋɔdikaaba den nangini o kani ki ");
INSERT INTO guxg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","yedi'o: bundi ti po ya naniidi den ye o kuan nni kpanjam, ki jesu ŋmianma, yua buli i bonbuliŋanm tie mini o nisalo bijua. ");
INSERT INTO guxg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","O kuanu mɔ tie ŋanduna, ya bonbuoli ŋan mɔ tie u tienu n die ya niba, aljani nni bila, ti muabiidi tie ya niba n tiendi sitaani n yedi ban tieni yaali. ");
INSERT INTO guxg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yibali yua buli i naniidi tie sitaani, li adipela n ba pe i di ya yoginu tie ŋanduna juodima. Adipela mɔ tie malekinba. ");
INSERT INTO guxg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nani ban yi loli ti muabiidi ki loli maama ki ju o mu nni, li ba tie yeni li ŋandunli juodima yoginu. ");
INSERT INTO guxg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","O nisalo bijua ba sɔni o malekinba ba ñani o diemin ne kuli, yaali tie bonbiili kuli yeni yaabi n tiendi mi biadima. ");
INSERT INTO guxg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ki luba o mu buogun nni naani kani n bia ke bi ba buudi ki ŋmani a ñina. ");
INSERT INTO guxg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Li yoginu, bi niteginkaaba (bi nimɔnba) ba yendi nani o yienu yinyienma yeni bi baa dienma nni. ");
INSERT INTO guxg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tanpolu dienma gɔa tien nani ya piama n wuo o kuanu yeni, ki o nilo laama (piidi) ki gɔ guani ki wuonma, wan gbie yeni ya pamanli po ko den gedi ki ban kuadi wan pia yaali kuli ki guani ki daa u kuanu yeni. ");
INSERT INTO guxg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tanpoli dienma gɔa tie nani ya kpenkpendo den kpaani mi lanbima ki li ŋani boncianla. ");
INSERT INTO guxg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wan den laanma ki mi daagu n paa maama po, o den gedi ki ban kuadi wan pia yaali kuli ki da. ");
INSERT INTO guxg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","tanpoli dienma gɔ tie nani, ti janbaandi ki bi taa ki lu mi ñinciama nni, bi yi cuo i janbuoli kuli, yaabi n ŋani yeni yaabi n ki ŋani, ti janbaandi ya gbie yeni i jam, bi jankpaanba yi dadi ki ñani mi ñinciama jali po. ");
INSERT INTO guxg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bi yi gandi ya jami ŋani ki tieni ti bauodi nni, ama bi ba lu yaabi n ki ŋani wani. ");
INSERT INTO guxg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Li ba tua yeni ŋanduna juodima, malekinba ba cua u tienu n ja ti buudi naani kani, ki paadi bi nibiadiba. ");
INSERT INTO guxg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bi ba lu'ba ya mu n bia nni, naani kani ki bi baa buudi yeni fala ki ŋmani bi ñina. ");
INSERT INTO guxg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Naani yi gbadi laa bonla kuli bonŋanla a? Bi ŋɔdikaaba den guano. ");
INSERT INTO guxg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nn ti gbadi, lani ki jesu den yedi yeni u tienu maama gbanbanda siigan yua n tua tanpoli dienma n ŋɔdika, baa naani nani ya nilo n pia o dieli ki ñangi o ŋalimankpelo nni yen wan pia ya ŋalmani paano. ");
INSERT INTO guxg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ya yoginu ki jesu den maadi'ba lan ya bonli kuli ki gbeni, o den taa o ŋɔdikaaba ki ñani li kani. ");
INSERT INTO guxg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wan den pundi Nasaleti o den kua li bali maama bangima dieli nni ki bangi, li den lidi yaabi n den cengi o bangima kuli ki maadi. ");
INSERT INTO guxg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","O naa nilo ki tie nani tinbi yen kaa? o ba laa yanfuonma m ɔ lee? O tieni ledi yo o ki tiendi mi bancianm? Waa tie o kpagikpielo bijua kaa? Maliyama ka tie o naa, Jaka, Josefi, Simɔno yeni Juda ka tie o waanmu( o ninjaba). ");
INSERT INTO guxg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","o ninsiabi mɔ kuli taani ki ye yen'ti ti dogun ");
INSERT INTO guxg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ya niba n ye li kani den yie kaa tuo ki gaa jesu nani u tie kilisiti, lan wani jeasu pali den biidi yeni ban tie maami po ko yedi'ba, bi kan fali u tienu nisɔnginka kaan tɔgi se o dan dogun nni yeni o diegun nni. ");
INSERT INTO guxg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Waa den tieni bancianm boncianla laa kaanu, kelima bi pajuaga ya po. ");
INSERT INTO guxg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Li yoginu Elodi yua den tie Galile dienma bado ki bi maadi jesu maama. ");
INSERT INTO guxg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O den yedi obadibaanba: ban maadi o nilo yua ya maama yen tie Janbatisi. O fii bi tikpiiba sin siigan ni. Lani n cedi ko fidi ki suani o naa paalu, ki tiendi ciila bona boncianli. ");
INSERT INTO guxg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Diidi yaali ya po n cedi ki Elodi den maali yeni kelima Elodi den taa o walo Filipi denpua Elodiasa ko da ye. ");
INSERT INTO guxg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Li po Jan den yedo: U Tienu bali maama ki cabi ŋan tieni laa bonli, li po Elodi den bua wan mangi Elodiasa pali, ki cedi ko sejenba cuo Jan, ki lolo, ki kuan'o li yonbidielin. ");
INSERT INTO guxg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ama, Elodi den bua wan kpa Jan ki nan jie o niwuligu maama, kelima o niwuligu den nua ki Jan tie sawali pualo yua maadi U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Elodi madijam daali n den pundi ki Elodiasa bisalo den jel i ciaga li nintaanli canba sin siigin, ki mangi o badi pali. ");
INSERT INTO guxg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hali ko den poli, ki niani ko ba pun'o wan miagu yaali kuli. ");
INSERT INTO guxg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Li ya po o jifaano den kua o naa kani, Elodiasa den buali wan ba mia yaali, o naa den guani ki yedi'o ban maadi ki a bua Janbatisi yuli, wan den gaa o naa tundi, o den guani ki yedi: teni nni, ne kanba Janbatisi yuli i tadigan nni. ");
INSERT INTO guxg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","O badi pali den biidi li po, ama wan den poli ki niani ko ba tieni wan miagu yaali o niwuligun yaba n kali ki lind'o kuli siigan, o den cabi ki bi ten'o. ");
INSERT INTO guxg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","O den sɔni ki bi ban jia Jan yuli li yonbidielin. ");
INSERT INTO guxg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bi den cuan li yuli ki li kpie li sanlin, ke teni o jafaano. O den gaa ki gedi ki ten'o naa. ");
INSERT INTO guxg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jan ŋɔdikaaba den cua ki taa o kpiemo ke ban pii, ki gedi ki ban waani jesu. ");
INSERT INTO guxg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesu n den gbadi laa laabaali, o den kua o ñinbiagun nni ki fuadi ki gedi Galile ñincianma po. Ya yoginu ki bi niba den bandi wan ye naani, bi den ñani bi dogin nni ki balin mi ñincianm ki cuoni ki ŋɔd'o. ");
INSERT INTO guxg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesu den cua mi ñincianma kunu bi kani, ya yoginu ko la o niwuligu ki bi ladi k ban caa, mi ninñinma den cuo'o bi po, o den paagi yaaba n yia kuli bi siigan nni. ");
INSERT INTO guxg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dajuogu yoginu, o ŋɔdikaaba, den nagini o kani ki yedo: “tin ye naani ne tie fuali ki o yoginu mɔ bua gedi, cabi o niwuligu ki ban gedi o dogun nni, ki ban ba li bonjekaali.” ");
INSERT INTO guxg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ama jesu den yuani ki yediba, li ki buali ki ban fii ki gedi ki ba mi jiema, li buali ki yinbi mɔno n tenbi ki ba je. ");
INSERT INTO guxg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","O ŋɔdikaaba den yedi'o: ti sieni kpanu bona muu yeni jamilie baba ne, ");
INSERT INTO guxg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu den yediba: “cuani mani n kani na. Lan wani ki jesu den cedi ki o niwuligu kali ti muadi po, o den ta kpano bona muu yeni jamilie yeni ki yaadi o nuni tanpoli po ki pagi U Tienu ki pugni ki maadi o ŋɔdikaaba ki ban bɔgidi li niwuligu. ");
INSERT INTO guxg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Li yoginu ki jesu maadi o niwuligu yeni ki ban kali ti muadi po, ko gaa kpaanu jena taa yeni jamilie yeni ki yadi ki di tanpoluki jaandi ki mia o baa. ki maadi ki ban tugi ki bogidiba ");
INSERT INTO guxg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bi kuli den dini ki guo, lani ban den dini ki sieni ya bonjena ki bi den taani tie piiga n babuodilie. ");
INSERT INTO guxg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yabi n den dini den tie jabi tuuda muu, bi puobi yeni a bila den ki ye li c ɔdili nni ");
INSERT INTO guxg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","L an yoginu o den cedi ko ŋɔdikaaba kua o ñinbiangun nni ki puodi ki gaa liigi ki gedi ne po ya jaali hali ko ban cabi o niwuligu ki ban ya kuni. ");
INSERT INTO guxg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wan den cabi o niwuligu o den siedi ki doni li juali po ki ban jaandi, u yenjuogu den pundi ko ye li po o beba. ");
INSERT INTO guxg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ama o yeni, ñinbiagu den cuoni ki ban pundi mi ñima siiga nni a ñunguona ye o faciangu den fii ki yili o po ");
INSERT INTO guxg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","li den sua ki b cuoni mi ñinciama po, li den tie ñiagu ki caa i siŋafaani ki jesu den cuoni o ñingbanu po ki togidi o ŋɔdikaaba ñinbiagu. ");
INSERT INTO guxg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ya yoginu ko ŋɔdikaaba la ko cuoni o ñingbano po ki nagidi bi kani, bi den bani nani ko tie cilingu, o jijiegu den kua'ba ki bi ji yigini yeni ti jawaandi, ");
INSERT INTO guxg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","li yoginu ki jesu yedi'ba: “Cuo mani yi ba, mini da jie mani, ");
INSERT INTO guxg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","pieli den guani ki yedo: “li ya tie fini, cedi min cuoni mi ñima po ki cua a kani. ");
INSERT INTO guxg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu guani ki ŋmiani: “cua na” pieli den ñani u ñinbiagun nni ki ji cuoni o ñingbanu po ki caa jesu kani. ");
INSERT INTO guxg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama ya yoginu ki pieli den jie u faalu yeni a ñinguona, o jiwaanbu den kua'o, ko den cili ki ba mii, ki yigini ŋanma ke yedi: yonbidaan gaa nni. ");
INSERT INTO guxg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","lan yoginu jesu den tandi o nugu ki cuo'o, ki yedo: a dandanli wa, be tieni ka tami ke n ba ŋaa'a nni? ");
INSERT INTO guxg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesu yeni pieli n den guani ki kua o ñinbiagun ya yoginu ko faalu sedi. ");
INSERT INTO guxg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","O ŋɔdikaabi kuli den baa ki gbani o nintualin nni ki maadi: I mɔn a ko li tie U Tienu bijua i. ");
INSERT INTO guxg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ya yoginu ki bi den puodi mi ñinciamu, bi den pundi Genesalet ya dogun nni. ");
INSERT INTO guxg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Lan dogun yabi den bandi jesu, bi den cili ki muandi ya longbana n sieni o laabaamanli ki bi cuoni yeni a yiama ko tebiba. ");
INSERT INTO guxg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yaabi n tie a miada den mia ke wan cabi ki ban sii o lietil beba, yaabi n den sii kuli den paagi ");
INSERT INTO guxg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisiani -nba yeni li bali maama bangikaaba tianba bo ñani Jerusalema ki cua Jesu kani ki yed'o: ");
INSERT INTO guxg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","be yaa po ke a ŋɔdikaaba miidi a bi nikpiaba bogda i? kelima b ya bua je kuli b kan nidi bi nii ");
INSERT INTO guxg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu bo guaniyedi ba be yaa po ke yi miidi u Tienu balimaama ki bua ki kubi i ya bogida i? ");
INSERT INTO guxg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kelima u Tienu yedi: fangi báa yeni a naá. ki gɔ yedi: Yua maadi o náa yeni o baá maabiigu o pundi ban kpa'o. ");
INSERT INTO guxg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama yinba yi yedi. i báa lani yaa ka yi naá: min bo taa yaala ki todi'a yeni n taa lani ke li tie u Tienu yaala ");
INSERT INTO guxg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yeni i buoni u Tienu maama ki naa kubi i bogida. ");
INSERT INTO guxg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yinba pala lie danba Isayi n bo saawalo yua i po bo tie mɔnmɔni. ");
INSERT INTO guxg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bi naa niba dondi n yeni bi ñɔkuuna i ke b pala fagi yeni nni. ");
INSERT INTO guxg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bi jaandi nni fanma fanma kelima bi bangi yaa bangima n tie bi nisaaliba ya maabilikaama babai. ");
INSERT INTO guxg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu bo yiini u niwuligu ki yedi ba: ");
INSERT INTO guxg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","cengi mani ki gbadi: laa tie yaala n kua u ñɔbu nni kaa jɔgidi o nisaalo, yaala n ña u nɔbu nni n jɔgid'o. ");
INSERT INTO guxg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lani ke o ŋɔdikaaba yedi'o: A banike Falisiani -nba gbadi a maama ke bi pala biidi i ");
INSERT INTO guxg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","O bo guani ki yedi ba: N báa yua ye tanpoli kaa buli ya tibu bi baa ŋabi bu. ");
INSERT INTO guxg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cedi ba mani bi tie ya juama n dia a juama i. Juamo ya dadi juamo mo bani bi lie kuli baa ba u buogu nni. ");
INSERT INTO guxg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piali bo yedi o: a kan bundi ti po m kpanjama yeni? ");
INSERT INTO guxg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu bo yedi: yi mo ko yii pia yanfuoma yoo? ");
INSERT INTO guxg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yii bani ke yaala n kua u ñɔbu nni kuli caa ku tugu nni ki gɔ baa ña kaa. ");
INSERT INTO guxg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama yaala n ña u ñɔbu nni n tie yaala n bi yeni li pali nni lani n jɔgidi o nisaalo. ");
INSERT INTO guxg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kelima yanmaalibiadi yeni m kukpama yeni m conconma buoli kuli yeni u subu yeni m siedi faama yeni t sugidi kuli ña li pali nni ");
INSERT INTO guxg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Lani n tie yaala n jɔgini o. Ama ki je kaa nii kan jɔgini nisaalo. ");
INSERT INTO guxg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu bo ñani lan kani ki gedi Tiri yeni Sidɔni dogi nni. ");
INSERT INTO guxg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ke ya pua bo tie li kani maabiiga ki tie kaana yua bo cua o kani ki kpaani ki tua: o diedo David bijua gbadi n po m ninñinma ki cicibiadi ye n bisalo nni ki yagini oyama hali ke li bia ");
INSERT INTO guxg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu náa bo guani yedi o lieba kuli. O ŋɔdikaaba bo nagini o kani ki yedi'o: A kan cabi o kelima o ŋua ki kpaani ti puoli. ");
INSERT INTO guxg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesu bo guani ki yedi; baa bo sɔni nitɔba po se Isalaheli buolu po bani yaaba n tie nani ya pee n yaadi ye po ");
INSERT INTO guxg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ama o pua yeni bo cua Jesu kani ki gbaani o nintuali nni ki yedi: o diedo todi nni. ");
INSERT INTO guxg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu bo guani ki yedi'o. Laa tiegi o nilo n taa a bil jiem ki lu a sangbanbila. ");
INSERT INTO guxg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","O pua bo yedi: o pua yeni bo yedi. Ama a sangbanbila je ya jejɔgidi n baali b danba saajekaanu kani. ");
INSERT INTO guxg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesu bo guani ki yedi'o. O pua a dandanli yabi boncianli lan tieni nani ŋan bua maama li yogunu ke o bisalo bo paagi. ");
INSERT INTO guxg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu bo ñani li kani ki gedi Galile m ñinciama kunu ki doni ki kali li jua li po. ");
INSERT INTO guxg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","U niwulugu bo cua o kani boncianla. Bi bo cua o kani yeni a diama, a juama, a muula, a tadima yeni yiantɔbi boncianla. Bi bo cua duani ba Yesu kani ke o paagi ba. ");
INSERT INTO guxg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ke u niwuligu bo la ke a muula maadi, ke a tadima paagi, ke a diama cuoni ke a juama mɔ nuali, bi bo kpiagi Isaraheli Tienu. ");
INSERT INTO guxg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu bo yiinio ŋɔdikaaba ki yedi: m ninñima cuo nni bi niba po; baa pia ban baa je yaala. Mii bua min cabi ba ke baa jeni bonla ke u paalu n daa pan pɔdi ba u sanu i. ");
INSERT INTO guxg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","O ŋɔdikaaba bo yedi 'o: t baa la le yaa jiema n baa dagidi ya niwuligu ne kuli li naa fuali nni ");
INSERT INTO guxg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu bo guani ki yedi ba: yi pia paanu bona ŋaa yo? Bi bo guani ki yedi'o: bonalele yeni i janbimu. ");
INSERT INTO guxg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ke o cedi ke bi niba yeni kuli kali kali tinga nni. ");
INSERT INTO guxg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","O bo taa li paanu yeni li jami i ki tuondi u Tienu ki ŋmiŋmidi ki taa teni o ŋɔdikaaba; ke bi bɔgidi bi niba yeni kuli. ");
INSERT INTO guxg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","bi kuli bo dini ki guo kelima Yesu bo tieni u yaalidigu tuonli. Bi bo wodi ya boncaba n sieni ki gbieni bobuociandi lele ");
INSERT INTO guxg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yaaba bo dini bo tie jaba tudanaa, laa taani bi puoba yeni a bila ");
INSERT INTO guxg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ban dini ki gbeni ki Yesu bo cabi u niwuligu, ki kua u ñinbiagu ki gedi Magadani tinga nni. ");
INSERT INTO guxg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisienba bo cua ki dia o ku maadiagu, ki buali o ke wan waani ya maalma tieni tanpoli kasiedi. ");
INSERT INTO guxg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ama, ke o jiini ki yedi ba, “ku yenjuogu ya cua, i yi yedi, “Li daali baa ŋani kelima i la ke poli mɔni” ");
INSERT INTO guxg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ku siŋaagu, yin yedi, “Ku taafaagu baa cua” kelima poli po mɔni ki go biigi.” I ba fidi ki waani poli po niima nni, ama, i kan fidi ki mi yema yogu maalma. ");
INSERT INTO guxg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Mi biadma yeni mi concoma nifiima lingi tanpoli maalma, ama bi kan la maalmabakuli kase Jonasi ya maalma.” Ke Jesu siedi ki ŋa ba. ");
INSERT INTO guxg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesu ŋɔdkaaba den puodi ki gedi bɔngbantɔli, ki sundi kaa taa kpanu. ");
INSERT INTO guxg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu den yedi ba, “yin fangi i yula yeni Farsienba yeni saduseyenba dabinli” ");
INSERT INTO guxg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bi ŋɔdkaaba den gagi bi ŋmiali nni ki tua, “Li tie tin ki taa kpanu yeni.” ");
INSERT INTO guxg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu ń bandi, ki buali ba, “Yinba yaaba ya dudugdi ki yabi ne, be n cedi ke i yedi ke yin ki taa kpanu yeni yapo i, ke n pua li kpanjama? ");
INSERT INTO guxg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","I ki tiani ki go kpaagi ki gbadi kpanu muuda yeni niba tuda mu niima nni yeni yin den duo ya baabuodi ii? ");
INSERT INTO guxg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","bii, kpanu leleda yeni niba tuda na, yin den duo duo ya baabuodi ń den dɔa maama aa? ");
INSERT INTO guxg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Be n cedi ke yi ki bandi ke min yedi yi maama ki nua kpanu maama? Yin fangi mani i yula yeni Farsienba yeni saduseyenba dabinli” ");
INSERT INTO guxg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ke bi ji gbadi ke o ki maadi ya dabinli n fiindi kpanu ka, ama o maadi Farisienba yeni saduseyenba bangima i. ");
INSERT INTO guxg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesu ǹ pundi Sesare, Filipi dogu nni, ke o buali o ŋɔdkaaba, “Bi niba tua ke o ja bijua tie ŋma i?” ");
INSERT INTO guxg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bi tua ke Janbatisi, bi tɔba, Eli, Tianba mɔ, Jeremi, bii bi sawalpuaba nni yendo.” ");
INSERT INTO guxg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ke o buali ba, Ke imɔ te, i yedi ke n tie ŋma i?” ");
INSERT INTO guxg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ke Simɔn Piari ga mi maama, ki jiini, “A tie Kiristo i, U Tienu yua n fuo Bijua.” ");
INSERT INTO guxg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ke Jesu jiini, ki maadi o, “A ye yeni mi yediŋanma, Jonasi bijua Simɔn, kelima, sɔma yeni gbannandi ka dɔgdi ki waani a, ama n Báa yua n ye Tanpoli i. ");
INSERT INTO guxg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","N go ba waani a ke a tie Piari (Tangu), ke li tangu po i ke n ba maa n jaandiegu. Bi tinkpiba diema bulñɔbu kan luodi gu yapo. ");
INSERT INTO guxg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N ba mubni a nui nni ŋaljanli bulñɔbu piemi. ŋan ba loli yaali tinga nni ne, li ba loli Tanpoli, A ya lodi yaali mo tinga nni ne, li ba lodi Tanpoli. ");
INSERT INTO guxg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ke Jesu kpa o ŋɔdkaaba ki yedi ba yeni li nunmɔnli, ke ban da waani nilo ke wani n tie Kiristo. ");
INSERT INTO guxg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lanyogu i, ke o ji cili ki maadi o ŋɔdkaaba, ke o ba gedi Jerusalema, ki la fala boncianla a cancannikpela, salga yidkaaba yudanba yeni a tidianla nui nni, ke bi ba kpa o, wan faadi li daataali daali. ");
INSERT INTO guxg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ke Piari yini o, ki piadi yeni o, ki funi yeni o, ki yedi o “O Diedo, ŋan yedi yaali yeni ń fagdi yeni a. lani ń da tieni a hali bada.” ");
INSERT INTO guxg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ama ke Jesu gbagi, ki yedi Piari, “Fuadi n puoli po, Setaani! A tie n tantuudkaali, kelima, a ki maali U Tienu bona po ka, a maali bi nisaalba bona po i. ");
INSERT INTO guxg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ke Jesu yedi o ŋɔdkaaba, Yua n bua wan ya ŋua nni, wan jiini o yuli, ki tugi o daapɔnpɔnli ki ya ŋua nni. ");
INSERT INTO guxg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kelima, yua n lingi ke wan fie o miali, o ba biani li, yua mɔ n luni o miali mini yapo, o ba la li. ");
INSERT INTO guxg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kelima, be jaadi o nisaalo ń ya pia ŋanduna kuli, ki nan biani omiali? O nisaalo ba fidi ki lebdi ki ga be i, ke li cie o miali i? ");
INSERT INTO guxg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kelima, o Nilo Bijua ba guani o Báa kpiagdi nni, yeni o malekinba. Ki pa yuakuli o panpaani nani wan sɔni maama. ");
INSERT INTO guxg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","N maadi yi i mɔmɔni, bi niba ye i siiga, ki kan leni mi kuuma hali yeni ban ba la O Nilo Bijua ke o kpendi ki kua o diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dana luobi puoli po, ki jesu tugi: Jaka, Jan o ninja ki piadi yenbi ki doni li juali ki ba jaandi. ");
INSERT INTO guxg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","O nunga den lebidi ki ji ñili ko tiadi pieni ke cie mi yinyiema. ");
INSERT INTO guxg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ki li yoginu ki Moyisi yeni Eli cua bi kani ki pagi yenbi. ");
INSERT INTO guxg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piel n la ya yoginu ko gaa mi maama ki yedi jesu: canba li ŋani yeni tin ya ye ne, a ya bua, n ba maa a po jona taa, jonyenli n ya tie a yaali, lieli Moyisi ya jonli n sieni Eli mɔ ya yaali. ");
INSERT INTO guxg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","O bo maadi ki ke gbeni ke li ŋunli jidi ki ligini bi kuli ko o nialo maadi li ŋunlin: “o ne tie n bijua yua k n bua'o, wani ke n duu o po, ya cengi mani o maama. ");
INSERT INTO guxg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","O ŋɔdikaaba n gbadi li maama ki bi ba ki gbaani yeni bi nuni kuli i tingan ");
INSERT INTO guxg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","nni, ki ti jaŋmaandi kua'ba. ");
INSERT INTO guxg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","yoginu ki jesu nagini ki sii'ba ki maadi'ba: fii mani yi da jie ");
INSERT INTO guxg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ban bo ji li juali po, ke jesu yedi'ba ki ban da cedi ki nilo n bandi yaali n tieni ne hali ya yoginu ko nul bijua ba fii ki ñaa o tinkpiigun nni. ");
INSERT INTO guxg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","O ŋɔdikaaba den bualo ki yedi: li tieni ledi ka kadabanda maadi ki tua ki li buali k Eli n kpia bii k cindi ki pundi? ");
INSERT INTO guxg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ki jesu ŋmiani ki maadi'ba: “li tie mɔni k U Tienu bo puoni ke Eli n ba cindi ki ba ki bobini yua ba cua mi faabima po. ");
INSERT INTO guxg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama n maadi,”Eli wan cua daal'o ama yinba n den ki bando, i den cagino ke tiendo yi bua yaali kuli, li tie yen mɔi ko nilo bijua ba cagini i nugin nni. ");
INSERT INTO guxg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yeni ki o ŋɔdikaaba bandi ko maadi Janbatisi ");
INSERT INTO guxg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ya yoginu ke o ŋɔdikaaba bonbitaa yen guani bi liebi yeni o niwuligu kani, ki jua ba ne cua jesu kani ba ki gbani o nungin nni ");
INSERT INTO guxg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ki maadi: “jie n biga yeni mi ninñinma ki teb'o kelima o baali i tinga ki laadi fala boncianli ki dugini li yianu po, o yogitianu o yi ba o muu nni bii mi ñinma nni. ");
INSERT INTO guxg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N den cua yeno a ŋɔdikaaba kani ama bi den ki fidi ki ba tebo. ");
INSERT INTO guxg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ki jesu ŋmiani ki maadi: kangbada buolu, ne yeni be yoinu ki ba gaa mi maama i? nagini man yeno na, ");
INSERT INTO guxg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ki jesu tiani ti fuobiidi yeni po, ke bi ñani ki ji ŋaogu, ko paagi li yoginu mɔno. ");
INSERT INTO guxg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lan, ko ŋɔdikaaba nagini jesu kani ke piadi ki pagi yeno: li tien ledi ke tinba ki fidi ke beli li fuobiigu? ");
INSERT INTO guxg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ki jesu maadi'ba: ki dugini yi dandanli ki yabi U Tienu palu nni, n maadi yeni i mɔni, a dandanli ya yabi ki pundi nani mi juobinma yeni a ya maadi li juali ne fii lan kani, o ba cɔnlin a maama. ");
INSERT INTO guxg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bonli kan ya paa ki cie'yi. ");
INSERT INTO guxg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ya yoginu ki biŋɔdikaaba kuli den taani bi lieba Galile ya tinga nni, ki jesu maadi o ŋɔdikaaba: bi ba kuadi o nilo bijua bi niba n daogu. ");
INSERT INTO guxg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bi ba kpaogu ama dana taa daali o ba yiedi, o ŋɔdikaaba n gbadi li maama ki ya ki lidiba boncianli ki bi ji tie suo. ");
INSERT INTO guxg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ban pundi kapanahom, ya niba n gaani lonpo li jaandielin nni den gedi ki la Piali ki maado: “yi canba paa lonpo yaa? ");
INSERT INTO guxg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ko ŋmiani: “nn, o paa, ya yoginu ki piali kua jesu den, ki jesu gaa mi maama yedi ki sua ki Piali da ki yedi bonli:'fin ya po Pial, ŋanduna baditieba, bi gaani bi lee lonpo? “B bila bii bi canbi? ");
INSERT INTO guxg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piali ŋmiani: “bi canbi” ki jesu jiini, li ya tie yeni bi bila ki ye lonpo nni. ");
INSERT INTO guxg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ama ki fidi ke tin da cɔg li lonpo gaala, gedi ki lu a janpiemu ki cuo ya jamo ba cindi ki nagini, a ya luodi o ñɔbu a bu la li ligibali, ŋan tugi li ligibu ki paa min yeni fini kuli ya po lonpo. ");
INSERT INTO guxg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lanyognu, ke bi ŋɔdkaaba nagni Jesu kani, ki buali o “ŋma n yabi ki cie U Tienu Diema nni?” ");
INSERT INTO guxg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Ke Jesu yini ki biñidga o kani, ki seni ga bi siiga, ki yedi, “N maadi yi i mɔni, I yaa lebdi ki tua nani biwaaga yeni, i kan baa ya sanu ke i ba kua U Tienu Diema nni ");
INSERT INTO guxg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lanwani ii, yua n miini o yuli nani ki biwaaga ne, wani n yabi ki cie U Tienu Diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yua n ga biwaaga nani kine yeni, n yeli po, o ga n ya cangu i. ");
INSERT INTO guxg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ama, yua n cedi ke biwaaga yua n dugi n po nani kine yeni, kua tuonbiadi nni, li bi baa tu o po, ke ban loli li naacianli o tulu nni, ki lu o wan mii mi ñincianma nni. ");
INSERT INTO guxg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mi yema ya paagi, janjanma ŋanduna po! kelima li buali ke li yogu n pundi, ama, sola li yogu ń ba tɔgni yua ya kani, ki pundi! ");
INSERT INTO guxg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A nugu bii a taali ya kuandi a mi tudma nni, ŋan jia ki lu fagma. Li baa tu a po ŋan kua U Tienu diema nni yeni taayenli bii nuuendu ki cei yeni ban lu ŋa ya mu n ki pia gbindma buogu nni yeni taana lie bii nugi lie. ");
INSERT INTO guxg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A nunbu n ya kuandi a mi tudma nni, ŋan kpigdi bu, ki lu fagma. Kelima li baa tu a po ŋan kua U Tienu Diema nni yeni nunfiagu ki cie ba lu ŋa ya mu n ki pia gbindma buogu nni yeni nuni lie kuli. ");
INSERT INTO guxg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Fangi mani i yuli, ki da ŋa a bila ne siiga, bá biyenga nunga ń ŋmidi. Kelima n maadi yi i mɔni ke ŋajanli nni, bi malekinba nua N Báa yua nye U Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ke lima, O Nilo Bijua cua ki bua faabi yaali n bodi i. ");
INSERT INTO guxg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","I maalma tie be i? Nilo ya pia yandi yiani, ke yanyenga bodi, o kan ŋa piiyia n yandi yia yaadi n sieni, ki lingi ki yanbodkaaga aa? ");
INSERT INTO guxg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","O ya la ga, N maadi yi i mɔmɔni, o pali yi mangi li yanga po ki cie piiya n yandi yia yaadi n ki bodi. ");
INSERT INTO guxg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Li tie yeni i, I báa yua n ye ŋaljanli nni mo ki bua ke a bbila ne nni, bá biyenga ń bia. ");
INSERT INTO guxg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","A kpiilo ya biidi a, ŋan gedi ki waani o o biidi, fini yeni wani siiga, a ba maadi ki paadi a kpiilo i. ");
INSERT INTO guxg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama, o ya ki cengi a, ŋan la yendo bii bilie ki pugni a po, ban taani a yeni, kasiedinba bilie bii bitaa siiga, mi maama ba ŋmagdi. ");
INSERT INTO guxg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","O ya yie kaa cengi yi, ŋan gedi yeni li maama li nitaali nni. O ya yie kaa cengi li nitaanli, ŋan ŋa o wan tua a po nani o nilamo bii o lonpogaalo yeni. ");
INSERT INTO guxg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","I mɔmɔni, N maadi yi, yin ba loli yaali tinga nni, li ba loli Tanpoli, yin ba lodi yaali ting nni, li ba lodi Tanpoli. ");
INSERT INTO guxg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","N go maadi yi ke i siiga nni, bilie ya taani jagli ki mia bonli ki tinga nni ne, N Báa yua n ye Tanpoli ba cedi li bonli ń tieni. ");
INSERT INTO guxg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kelima, bilie bii bitaa ya taani naani n yeli po, n baa ye bi siiga. ");
INSERT INTO guxg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ke Piari nagni ki buali Jesu, “O Diedo, n kpiilo ya biidi nni, n ba mia sugli taalma ŋa i? Hali taalma lele ee?” ");
INSERT INTO guxg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ke Jesu jiini o, “N ki yedi taalma lele ka, ama hali piilele taalma lele. ");
INSERT INTO guxg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lanwani ii, U Tienu Diema tie nani ya badciamo n den bua tieni li cɔli ki bandi o naacenba ń kubi o piama maama i. ");
INSERT INTO guxg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wan cili mi diidma, o sua ke naacenyendo kua li panli nni hali ligdibala tuda piiga. ");
INSERT INTO guxg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nani wan den ki pia wan ba tieni maama ki pa yeni, ke canbaa niini ke ban kuadi o wani yeni o pua yeni o bila yeni wai yaali kuli, ki pa o panli. ");
INSERT INTO guxg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ke li naaciemo baá ki gbaani o nintuali, ki mia o sugli, “Canbaa, N bani li panli po, ke N ba pa likuli” ");
INSERT INTO guxg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nani li naaciemo canbaa ń bo tie niñinpadi daano yeni, ke o ga o sugli, ki cabi o li panli. ");
INSERT INTO guxg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ama, li naacimo ń ñani ki la o naacenlielo ke o pia o pia o panli kuukobga. Ke o gedi ki cegi o tulu, ki yedi o, “Pa nni n ligi. ");
INSERT INTO guxg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ke o naacenlielo baa ki gbaani, ki mia o sugli ki maadi, “Tieni n po juunli, n ba pa ŋa.” ");
INSERT INTO guxg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ama, ke o naaciemo yie, ki cuo o naacenlielo ki gedi ki luoni o li kpaadidieli nni, ke o yaa pani o panli, o kan ña. ");
INSERT INTO guxg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bi naacenlieba ń la yaali n tieni, ke bi pali sia, ke bi kua ki togdi bi canbaa kaa dɔgni o bápu. ");
INSERT INTO guxg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ke o naaciemo canbaa yini o, ki yedi o, “N cabi a ŋan pia nni ya panli kuli, kelima a mia nni sugli. ");
INSERT INTO guxg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nani a naacenlielo ń mia ŋa sugli yeni, fini bi kan fidi ki cabi o oo? ");
INSERT INTO guxg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","O canbaa pali den beni o po, ke o cuo o, ki mubni o a jakɔnda nui nni ke bi waani o fala hali ke o pani o panli kuli. ");
INSERT INTO guxg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","N Báa yua n ye Tanpoli mo ba tieni yi yeni, li ya tie ke i siiga nilo pali ki siadi o lielo po. ");
INSERT INTO guxg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu n gbenio maama ke o ñani Galile ki gedi Sude. ");
INSERT INTO guxg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bi niba boncianli bo ŋua'o ke o gɔ paagi ba li kani. ");
INSERT INTO guxg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Falisiani -nba bo ŋɔdi ki bual'o yiko cabi ke je n ñani o denpua li ya sua ke b cuo biidi ba kuli po? ");
INSERT INTO guxg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ke Jesu ŋmiani ki yedi: i ki cogi ke yua bo tagi ba ki ciligi bo tagi bojal yeni bonñua. ");
INSERT INTO guxg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ki gua maadi: Lani yaa po i ke o ja baa ña o báa yeni o naá kani ki gedi wani yeni o denpua n taani ki ya tie gbananyendi. ");
INSERT INTO guxg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bi ji kaa tie nibilie ama niyendo. Lan nilo n daa paadi u Tienu n taani yaala. ");
INSERT INTO guxg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","B yedi 'o: Be n cedi ke Moyisi cabike t tieni m yiema tili. ");
INSERT INTO guxg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ke o yedi ba: i pala n juagi yeni ya po i ke Moyisi cabi i ke yi yadi yeni i puoba ama ki ciliga li bo tie yeni. ");
INSERT INTO guxg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","n maadi yi: yua beli o denpua ke laa tie conconma po ki taa puotiani tieni u subu ya ja gua taa pua yua ke bi bel'o mɔ gua tieni conconbu i. ");
INSERT INTO guxg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ke o ŋɔdikaaba maadi'o: Li ya tie n yeni opua yeni o ja kani laa ŋani yeni nilo n kua pua. ");
INSERT INTO guxg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ama ke Yesu maadi ba: Yua kuli kaa baa fidi tui li tundili, ama yaaba baba ke li cabi ke ban gbadi li niima nni. ");
INSERT INTO guxg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","kelima b tɔbi ye ki mali kaa pia u maalu. ke b tiaba mɔ bi niba n beli bi t madi. ke niba gɔ ye ke li tie ke bani mɔno n beli bi ba t madi ki dugini u Tienu diema po. Yua ba fidi ki gbadi li tundili ne wan gbadi. ");
INSERT INTO guxg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ke bi niba cua yeni a bila ke wan maani o nuugi bi po ki jaani. Ama ke o ŋɔdikaaba bo bieli li niba. ");
INSERT INTO guxg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ke Yesu yedi ba: ŋaa mani a bila k daa beli ba ke ban cua n kani. Kelima yaaba n naani yeni a bila n die u Tienu diema. ");
INSERT INTO guxg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ke o maani o nuugi bi po ki siedi li kani. ");
INSERT INTO guxg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ke jka ba cua Yesu kani ki maadi: canbaa n baa tieni ki laa tuadiŋanli ki bàà ya miali ki pia gbenma i. ");
INSERT INTO guxg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ke Yesu maadi'o: Be cedi ke a buali'n i buali ŋanmi i? Bonyenli baba n ye. Ama a ya bua ŋan ya miali ki pia gbenma ŋan tuo u Tienu ñɔmaama. ");
INSERT INTO guxg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ke o ja yeni maadi 'o: ki laa ñɔmaama po i? ke Yesu maadi: ŋan daa kpa nilo, ŋan daa dua yeni nutiani denpua, daa su, daa pua faama nilo ba po, ");
INSERT INTO guxg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ŋan fangi a báa yeni a naá, ŋan buadi a lielo nani fini a ba yeni. ");
INSERT INTO guxg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ke o ja yeni maadi 'o: n cɔlini lan kuli. n gɔ baa tieni be i ");
INSERT INTO guxg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ke Yesu yedi: a ya bua ŋan tua ya nilo k pia biidi, kudi ŋan pia yaala kuli ki puni b taladidanba. Yeni a baa bàà ŋalimani tanpoli. ki ji cua ki ŋɔdi n. ");
INSERT INTO guxg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","O ja yeni n bo gbadi Yesu n maadi yaala kuli ke o siedi ke o pali ki mangi. Kelima o tie yua pia ŋaliman bonciala. ");
INSERT INTO guxg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ke Yesu maadi o ŋɔdikaaba: i mɔnmɔni po i yedi yi: li paa yeni o ŋalimandaano n kua u Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","n gɔ maadi yi: li kaa paa u yuoyuogu po ke wan kua u pundu bonli nani ama li kan ya tie yeni o ŋalimandaano po. ");
INSERT INTO guxg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","O ŋɔdikaaba n bo gbadi lio maama li bo cuo ba yaalidigu. ke bi maadi: ŋmaa ji baa fidi báá m fuoma i? ");
INSERT INTO guxg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ke Jesu nuali ba ki maadi: Bi niba kani li kan fidi ama u Tienu kani li baa fidi tieni. ");
INSERT INTO guxg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ke Piali jiin'o ki maadi: diidi t ŋaa t bona kuli ki ŋua ŋa; t mɔ baa bàà be i? ");
INSERT INTO guxg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ke Jesu yedi: Yeni i mɔnmɔni yinba yaaba n ŋɔdi nni m yenpanma yogu ya yogu ke o nilo bijua baa t kaa li bali kpagili po yeni o yudandi. i mɔ t baa kaa isaraheli cuga piiga n bona lie yeni nni ki bu li cuga piiga n bona lie. ");
INSERT INTO guxg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nilo yua kuli ŋaa o deni, o kpiiba, o baá yeni o naá, yeni o bila, bii o tinga n yeli po baa gaa m ŋanma taalm kobiga ki gɔ bàà li miali yua k pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama yaaba n bo tie nikpialla mɔla ne ji baa juodi ke yaaba n bo juodi n tua kpialia. ");
INSERT INTO guxg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","U Tienu Diema tie nani ya tindaano den yagdi ki ñani ku siŋapaapangu, ki puogi bi tuonsɔnba ke ban gedi ki sɔni o daamɔngu tiidi kuanu nni. ");
INSERT INTO guxg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ban boni ke li dagdi, ke o baa pa ba ligdibali daali nni, ke o sɔni ba o kuanu nni. ");
INSERT INTO guxg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kudi taa ń pugni, ke o go ñani ki gedi ki la tuonsɔntianba ke bi se ki daaga nni kaa tuuni libakuli. ");
INSERT INTO guxg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ke o yedi bi mo, “Gedi mani ki sɔni n daamɔngu tiidi kuanu nni, N ba pa yi lan buali maama.” Ke bi gedi ki tuuni. ");
INSERT INTO guxg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kudi luoba ń pugni, ke o go ñani, kudi yia ń pugni, ke o go ñani, ki tieni yeni. ");
INSERT INTO guxg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","kKi go guudi ke piiga n kuyengu pugni, ke o go ñani, ki la tianba ke bi se kaa tuuni libakuli. Ke o buali ba “Be n cedi ke i se yentunmunli kaa tuuni libakuli?” ");
INSERT INTO guxg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ke bi yedi o, “Nilobakuli ki puogi ti tuonli.” Ke o yedi ba, “I mo ń gedi n daamɔngu tiidi kuanu nni” ");
INSERT INTO guxg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ku yenjuogu yognu, ke o kuandaano yini o ŋalmankubilo, ki yedi o, “Yini bi tuonsɔnba ki pa ba bi daali pani, ki cili yaaba juodi, ki ban juodi yaaba n cili. ");
INSERT INTO guxg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Piiga n kuyengu ń pendi ke bi ga ya tuonsɔnba ń nagni wan pa ba dibayenli yenli. ");
INSERT INTO guxg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ya tuonsɔnba n cindi li tuonli ń nagni, ki maali ke banwani ba ga lan cie dibali, ama bi den li ga yuakuli dibali i. ");
INSERT INTO guxg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ban ga bi daali pani, ke bi ji fabni o tindaano kani. ");
INSERT INTO guxg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ki maadi, “Yaaba n juodi ki cua ke piiga n kuyengu pendi yeni wan sɔni kuyengu baba i, ama a pani tikuli ke li dɔa i, tinba yaaba n cindi li tuonli hali ku siŋaagu nni, ke u yienu kua ti. ");
INSERT INTO guxg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ama, ke o tindaano jiini bi siiga nni, yendo, “N dɔnli, mii tudi ka. Tii boni ki dagdi ke n ba pa yi dibayenli kaa? ");
INSERT INTO guxg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ga yaali n tie a yaali, ki ya caa. Mini n bua, ki jagi ke min teni yaaba juodi nani yinba yeni. ");
INSERT INTO guxg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N ki pia i mɔni yeni min tieni min bua yaali yeni n bonceli ii? Bii min tieni ti ti bulcindi yeni i ke li kpii i nunbu uu? ");
INSERT INTO guxg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Lanwani ii, Yaaba n juodi ba cindi, ke yaaba n cindi ń juodi. ");
INSERT INTO guxg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nani Jesu ń den do ki caa Jerusalema yeni, ke o piadi li piiga n bilidiba ki seni ba, ban caa ya yognu, ke o yedi ba, ");
INSERT INTO guxg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Diidi mani, ti caa Jerusalema n yeni, bi ba kuadi o Nilo bijua ki mubni o salga yidkaaba yeni a gbanbanda nui nni. ");
INSERT INTO guxg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bi ba jia o ti buudi, ki cedi ban kpa o. Bi ba mubni o bi nilanba nui nni, ban laa o, ki sugi o, ki pua o a finfinba, ki kpaa o li dapɔnpɔnli po. Ama, li daataali daali o ba faadi.” ");
INSERT INTO guxg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ke Sebedenba nagni Jesu kani yeni o bijaba. Ki ñuani o nintuali, ki mia o bonli. ");
INSERT INTO guxg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ke Jesu buali o, “Amiabu tie be i?” Ke o jiini o, “Cedi n bijaba ne, ban ti kali a diema nni, yendo a jienu po, tiano, a ganu po.” ");
INSERT INTO guxg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ke Jesu jiini ki maadi, “A ki bani ŋan miadi yaali. I ba fidi ki ñu min bobindi ki ba ñu ya bonñukaali nni ii?” ke bi yedi o “Ti ba fidi.” ");
INSERT INTO guxg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ke o maadi ba, “Li tie mɔni ke i ba ñu n bonñukaali nni, ama ki kali n jienu po bii n ganu po wani ii, li ki tie mini ka ba cabi lani, ama li tie n Báa ń bobni li kaani yaaba ya po i. ");
INSERT INTO guxg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ŋɔdkaaba piiga yaaba n sieni ń gbadi lanya maama, ke bi pali biidi li naataanliedba po. ");
INSERT INTO guxg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ke Jesu yini ba, ke bi nagni, ke o yedi ba, I bani ke bi nilanba bado n die ba, ke a nigbenga wangi yaaba n sieni bi paalu ń dagdi maama. ");
INSERT INTO guxg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama, li kan ya tie yeni ka i yasiiga. Ama yua n bua wan tua yua n cie ikuli i siiga, wan tua i naaciemo. ");
INSERT INTO guxg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yua mo n bua wan tua liiga yua i siiga, wan tua i naaciemo. ");
INSERT INTO guxg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nani o Nilo Bijua ń ki cua ke ban ya tuuni o po ka ama wani ń ya tuuni bi niba po, ki go yidi o miali salga bi niba boncianli po. ");
INSERT INTO guxg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ban ñani, ki gedi Jeriko, ke bi niba boncianli ŋɔdi o. ");
INSERT INTO guxg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ke juuanba lie kaa u sankunu. Ban gbadi ke Jesu pendi bi kani, ke bi tandi ki maadi, “O Diedo, Dafidi Bijua, gbadi ti niñima, ");
INSERT INTO guxg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ke ku niwulgu funi yeni ba, ki niini ba ke ban suoni, ama, ke bi tandi paama ke li cie kpiama, “O Diedo, Dafidi Bijua gbadi ti niñima.” ");
INSERT INTO guxg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ke Jesu sedi cenm, ki yini ba ki buali ba, “I bua min tieni i po be i?” ");
INSERT INTO guxg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ke bi jiini o, “O Diedo, ti bua ti ninbina ń luodi i.” ");
INSERT INTO guxg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ke ti niñinpadi cuo Jesu, ke o sii bi ninbina. Lanyognu liga ke bi nuni luodi ke bi ji nua, ki ŋua Jesu ");
INSERT INTO guxg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesu yeni o ŋɔdkaaba ń nagi Jerusalema, ki pundi Betifaje, Olifie tiidi juali gamu, Jesu ń sɔni o ŋɔdkaaba bilie, ");
INSERT INTO guxg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ki maadi ba: «Gedi mani ki dogbiga yaaga ye i liiga ne; yin ba pundi ya yognu, i ba la ŋunñua ke o luoli, yeni ki ŋunbiga; yin lodi ba ki cua yeni ba na ");
INSERT INTO guxg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nilo ya maadi yi bonli, yin jiini o: “O Diedo n bua ba. Lanyognu mɔno, o ba cabi, yin gedi yeni ba.” ");
INSERT INTO guxg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mɔla, ya bonli ne tieni ke o sawalpualo ń den tuodi ki waani yaali ń tieni ki dudi ");
INSERT INTO guxg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Yedi mani Siyɔn bisalo: «Lani n yeni, a bisalo kpendi a kani, ki dingi boncianla, ki jagi o ŋunbo, ŋunbiga, ŋunñua ya biga.» ");
INSERT INTO guxg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","O ŋɔdkaaba ń gedi ki tieni Jesu ń waani ba ki ban tieni yaali. ");
INSERT INTO guxg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ban guani yeni o ŋunbo yeni ki ŋunbiga, ki ladi bi po bi tialakaadi, ki cedi ke o jagi ");
INSERT INTO guxg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ku niwulgu siiga, bi niba boncianla den ladi bi tialakaadi u sanu nni; ke bi tianba padi i tiibensɔngi ki ladi u sanu nni. ");
INSERT INTO guxg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yaaba n den ye Jesu liiga yeni yaaba n den ŋua o den kpaandi ki maadi: “Osana, Daafiid Bijua! Mi yedŋanma yua n kpendi O Diedo yeli po! Osana hali tanpojoma. ");
INSERT INTO guxg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wan kua Jerusalema, lan yaa ki lidi yuakuli u dogciamu nni, ke bi ji maadi: One mo tie ŋma i? ");
INSERT INTO guxg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ke ku niwulgu tandi ku tua: “O tie Jesu i, o sawalpualo, ke o tie Galile nni Nasareti yua.” ");
INSERT INTO guxg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesu ń kua U Tienu jaadiegu nni, wan beli ki ñani yaaba n den kuadi yeni yaaba n den daa ku jaadiegu nni kuli, ki tudi ki lu lu yaaba n den cendi i ligi taablinba yeni a kpajekuada kpaga, ");
INSERT INTO guxg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ki yedi ba: li diani: «“N diegu baa yi jaandiegu” Ama ke yinba wani nan cedi ke gu tua suudjongu.» ");
INSERT INTO guxg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ke a juama yeni mu wabmu nagni o kani li jaandieli nni, ke o tebi ba. ");
INSERT INTO guxg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bi salga yidkacianba yeni a gbanbanda ń la wan tieni ya yaalidgu tuona, ki gbadi ke a bila kpaandi ku jaandiegu nni, ki tua: “Osana Daafiid Bijua!”, ke bi pala beni. ");
INSERT INTO guxg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ban maadi o: “A gbadi ban maadi yaali ii? Jesu ń jiini ba “Nn, i da ki kpeli ki cogi yaali diani ne ee?”: “A cedi ke a bila yeni ya canpandmu n da ŋaani mi biima pagi a, ki dondi a.” ");
INSERT INTO guxg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ki ñani ki ŋa ba, ki lie u dogu, ki gedi Betani, ki ban duani li po. ");
INSERT INTO guxg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ku siŋaagu nni wan den gɔa ki lebi u dogu po, ke mi koma cuo o. ");
INSERT INTO guxg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ke o la bu kankanbu u sankunu, ke o nagni, waa la kankanli se kankanfaadi. K o yedi bu: “luanli ń ji da jɔni a ya po palb.” Lanyognu mɔno, ke bu kankanbu yeni kuodi. ");
INSERT INTO guxg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bi todkaaba ń la lani, lan yaa ki lidi ba, ban maadi: “li tieni ledi i, ke bu kankanbu ne kuodi yenma? ");
INSERT INTO guxg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu ń jiini ba: “N maadi yi i mɔni, i ya bi pia ti dudugdi ke tama ki ye, i bi kan tieni min tieni bu kankanbu yaali ne baba ka, ama i ya bi yedi li juali ne: “Figdi li kani ki gedi ban jiidi ki baa mi ñincianma nni.” Li bi ba tieni.” ");
INSERT INTO guxg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","I ya jaandi, ki mia yaali yeni ti dudugdi, i ba baa. ");
INSERT INTO guxg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesu ń gedi ku jaadiegu nni ki ban ya tundi; lanyognu, salga yidkaacianba yeni u dogu nni nikpela ń cua ki buali o: “Aduu li laa yiko po i ki tie ya bona ne kuli, ŋma n cabi li yiko?” ");
INSERT INTO guxg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu ń jiini ba: “N mo ba buali yi i buali, i ya jiini nni i, n mo ba maadi yi ya yiko po ke duu, ki tie lan ya bona.” ");
INSERT INTO guxg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jan batisma, li den ñani le i? Tanpoli bii, bi niba kani i? Ama ban juogi bi ŋmiali nni, ki taa ya maalma ne; ti ya maadi ke li ñani U Tienu kani, o ba buali ti: “Be n cedi ke i den ki tuo ki ga o maama? ");
INSERT INTO guxg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ti ke li ñani bi niba kani mo, ku niwulgu kan tuo ti po; kelima bikuli bani ke o tie sawalpualo i. ");
INSERT INTO guxg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lanwani i, ban jiini Jesu: “Tii bani” Jesu mo ń guani ki jiini ba: “N mo ka maadi yi ya yiko po ke n tie ya bona ne.” ");
INSERT INTO guxg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","I pia mi laa maalma i? O ja bo ye, ki pia bijaba lie, ki yedi o bijakpelo: “Dinne n biga, ŋan gedi ki ban sɔni n daamɔgu tiidi kuanu nni.” ");
INSERT INTO guxg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wan jiini: “Mii caa.” lan yani waamu, wan tuuba, ki lebdi o yama, k gedi, ");
INSERT INTO guxg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wan maadi yua n sieni mo yeni, lan ya biga mo ń jiini: “Canbáa, n ba gedi. “Ama o naa gedi. ");
INSERT INTO guxg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bani bijaba lie yeni, ole po n tieni o báa buama? Ban jiini o: “O bijakpelo” Jesu ń maadi ba: “N maadi yi i mɔni, lonpo gaala yeni a concona ba ga i liiga U Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kelima Jan cua i kani mi teginma sani nni, ama, i naa tuo ki ga o maama. Ama, lompo gaala yeni a concona wani i, tuo ki ga o maama. Ke yinba yaaba n la lankuli, i ki tuuba, ki lebdi i pala ki ga o maama. ");
INSERT INTO guxg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Cengi mani kpanjantɔma. O ja den ye, ki tie diedaano, ki pia ku daamɔngu tiidi kuanu, ki ŋuu i tiidi ki kagni, ki lindi, ki lugdi ku tantiagu po ku buogu, ban baa to naani, ki ŋa ku daamɔngu, ki maa li pagli, ki pani, ki ji ga a tuonsɔnla ke bi guu lebli. O den fii, ki puodi li kpaali ki gedi dogtianu. ");
INSERT INTO guxg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","U kuanu bona ń beni ke ku kpaangu yogu pundi, wan sɔni o naacenba bi kuaguudba kani ke ban ga o kuanu biinu na. ");
INSERT INTO guxg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bi kuaguudba ń cuo bi naacenba, ki pua yendo, ki kpa o lielo, ki jaa o taalo a tana. ");
INSERT INTO guxg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wan sɔni naacentɔba, ke bi yabi ki cie kpiama yaaba, bi kuaguudba tieni bi mo yeni i. ");
INSERT INTO guxg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wan ji juodi ki sɔni o bijua, ki maadi o yama nni: “Bi ba cɔlni n bijua wani.” ");
INSERT INTO guxg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama bi kuaguudba ń la o bi cabáa bijua, ban juogi bi ŋmiali nni maama ne: “O faadilo n yeni; cua mani tin taani, ki kpa o, ki diedi li faali. ");
INSERT INTO guxg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ke bi cuo o, ki dadi ki ñani o ki jɔndi yeni u kuanu, ki kpa o. ");
INSERT INTO guxg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mɔla o kuadaano ji ya cua, o ji ba tieni bi kuaguudba yeni ledi i? ");
INSERT INTO guxg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ke bi jiini: “O ba cedi ya cacagdanba ne ń kpe mi cacagkuuma, wan ga tuonsɔntianba ban ya guu o kuanu, ki tieni o o kuanu biinu ku kpaangu yogu. ");
INSERT INTO guxg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesu ń maadi ba: “I ki kpeli ki cogi i diani nni ii: “A tanmaala ń luni ya tanli yeni, lani n tua li tanpuukaali; lankuli ñani O Diedo kani i, ki tie yaalidgu bona ti nunbu nni. ");
INSERT INTO guxg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Lani n cedi ke n maadi yi: “Bi ba fie U Tienu diema i nui nni, ki teni ya nibuolu n ba fidi ki cedi man loni a luana.” ");
INSERT INTO guxg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“ Yua baá li tanli po ba jendi jendi, li tanli ń baá yua ya po mo, o ba yodi yodi i.” ");
INSERT INTO guxg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Salga yidkaacianba yeni farisienba ń gbadi Jesu maakpanjama, ban bandi ke o maadi bani ya maama i. ");
INSERT INTO guxg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ban ji ya gbaa ke ban cuo o; ama ki nan jie ku niwulgu, kelima bi den bani ke o tie sawalpualo. ");
INSERT INTO guxg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesu ga m maama, ki pua ya maakpanjanma ne: ");
INSERT INTO guxg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ti Diedo diema naani nani ya bado bo tieni o biga janma yeni. ");
INSERT INTO guxg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O bo sɔni o tuonsɔnbila k ban gedi ki maadi yaabi k o yinba mi janma yeni ki bi gbeni mi jiema ki ban baa na ki je. Ama bi niba yen naa den bua ban cua. ");
INSERT INTO guxg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wan sɔni naacentɔba, ki yedi ba: “Ban maadi mani ba ke n bobni mi pocaajiema ki gbeni; n cedi ke bi kpaá n naakpanba yeni n yankpanba, likuli bobni ki gbeni, ji cua mani mi pocaajaanma. ");
INSERT INTO guxg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama baa cengi li pocaali jaanma po, yuakuli den toli wan bua naani, o ne, o kuanu po o tɔa mo o kpenkpendu po. ");
INSERT INTO guxg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yaaba n sieni ń cuo bi naacenba ki pua, ki cagni bi ne, ki kpa bi tianba. ");
INSERT INTO guxg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","O badciamo pali ń be, wan sɔni o jakɔnda ban biani a nibiada yeni miana, ki sia bi dogu. ");
INSERT INTO guxg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yeni k o maadi o o jietienbila: mi jiema tieni ki gbeni, ama yaabi n ba je ki dagdi yenli. ");
INSERT INTO guxg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yeni, gedi mani a sankaditaana nni, ki yini yin la yaabi kuli. ");
INSERT INTO guxg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A tuonsɔnbila ne fii ki gedi a sanjala poki yini ban la yaabi kuli, a nibiada yeni a tadima, talgi nba kuliyeni, o jiediciagu gbie yeni bi niba yen kuli. ");
INSERT INTO guxg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","O badciamo ń kua ki diidi yaaba n kaa, ki ba di mi jaanjiema, ki la yendo ke waa la o jaantiadi. ");
INSERT INTO guxg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wan buali o: “N dɔnli, a tieni ledi i ki kua ne ki naa lani a jaantiadi? Li nilo ń ya ŋmini ");
INSERT INTO guxg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lanwani i, o badciamo ń maadi o naacenba: Loli mani o nui yeni o taana, ki lu o niinpo li biigli nni, li bubuuli yeni li ñinŋmanli ń ye naankani. ");
INSERT INTO guxg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kelima, ban yini yaaba yabi, ama ban gagdi ki lugdi yaaba wa ki cie. ");
INSERT INTO guxg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","lanyapo, farisienba ń jɔndi ki juogi bi ŋmiali nni, ki lingi ban ba tieni maama ki dali ki cuo Jesu o maama po. ");
INSERT INTO guxg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ban sɔni bi naacenba Jesu kani, ke bi yegi yeni Juufinba badciamo, Herodi niba, ban maadi: “Canbáa, ti bani ke a tie mɔmɔndaano, ki wangi U Tienu ń bili ya sanu yeni i mɔni, ŋaa jie nilobá kuli, kaa go pia lugdima bi niba siiga. ");
INSERT INTO guxg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Maadi ti ŋan pia ya maalma: Yiko cabi ke lan pa lompo Sesaari po bii laa cabi i? ");
INSERT INTO guxg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ke Jesu bandi bi biadma po. Bi den guu ke wan maadi ya maama n ba sagni o yeni juufinba bii Roma yikodanba i. Ke o buali ba, yinba mu muyiidmu ne, be n cedi ke i dia nni ku maadiagu ki bua yin cuo nni? ");
INSERT INTO guxg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","“Waani mani nni yin kubi ya dibali ki pa lonpo”. Ke bi nagni o yeni li dibali. ");
INSERT INTO guxg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesu ń buali ba, “ŋma ya nannanli yeni ŋma ya yeli n ye li dibali ne po? ");
INSERT INTO guxg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ke bi jiini, “Sesari i” Ke Jesu yedi ba, “Teni mani Sesari yaali n tie Sesari yaali, ki teni U Tienu, yaali n tie U Tienu yaali.” ");
INSERT INTO guxg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ban gbadi lanya maama, ke li yaalidi ba, ke bi siedi ki ŋa o. ");
INSERT INTO guxg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Li daali mɔno, sadiseyennba, yaaba n maali ke faadma ki ye mi kuuma puoli po, ń cua Jesu kani, ki buali o. ");
INSERT INTO guxg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Canbáa, Moyiisi maadi, ke nilo ya kpe kaa pia biga, o ninjua ń taa o pakuali ki mali o kpiemo po puoli ŋuani. ");
INSERT INTO guxg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To, ti siiga ninjaba lele (7) den ye. o ciamo po ń kuani o pua, ki kpe, waa pia biga. Nani wan den ki pia biga yeni i, o ninjawaaga ń taa o pakuali, ");
INSERT INTO guxg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lan tua yeni mo lielo po, ki tuani o taalo, ki ya maa yeni ki ban biini o lelelo. ");
INSERT INTO guxg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lani ń pendi, o pua mo ń kpe. ");
INSERT INTO guxg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mi faadma yogu, ŋma ba yendi o pua? Kelima bikuli na kuani o. ");
INSERT INTO guxg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu ń jiini ba: “I ye mi tudma nni kelima yii gbia i diani niima nni, i naa go bani U Tienu paaciamu. ");
INSERT INTO guxg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kelima mi faadma yogu, jaba ji kan taa puoba, puoba mo kan ji kuni jaba, bi baa tie nani U Tienu malekinba yeni tanpoli po. ");
INSERT INTO guxg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yaali n nua mi faadma bi tinkpiba siiga, i ki cogi U Tienu ń yedi yaali ii? ");
INSERT INTO guxg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","N tie Abalahama Tienu, Isaka Tienu yeni Jakobo Tienu? U Tienu ki tie bi kpienba ya tienu ka ama bi fuodba ya Tienu i. ");
INSERT INTO guxg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lan yaalidi ya niwulgu n bo ye li kani, ki cengi Jesu tunda. ");
INSERT INTO guxg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisienba ń gbadi ke o mubni sadiseyenba ñɔbu, ban taani ki kali ");
INSERT INTO guxg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","yendo bi siiga, yua n tie yiko banciamo ń buali o ya buali ne, ki bua bigni o: ");
INSERT INTO guxg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ Canbáa, U Tienu maabilkaama nni, mi laa maama n cie mikuli? ");
INSERT INTO guxg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu ń jiini o: “A baa bua O Diedo a Tienu yeni a pali kuli, yeni a naano kuli yeni a maalma kuli. ");
INSERT INTO guxg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mani n tie ya maabilkaama n lii ki cie mikuli. ");
INSERT INTO guxg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya maabilkaama n tua, ki naani yeni cincinli yaama n ne: “A baa bua a lielo nani a bá yeni. ");
INSERT INTO guxg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yiko yeni bi sawalpuaba maama kuli maa lani maabilkaaliedma yeni po i. ");
INSERT INTO guxg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nani farisienba ń den taani ki ye yeni i, Jesu den buali ba. ");
INSERT INTO guxg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ki yedi ba: “I maali be i, Kiristu po? o tie ŋma ya biga i? Ke bi jiini o: Dafiid bijua i. ");
INSERT INTO guxg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ke Jesu maadi ba: “Li ga ledi i ke Dafiid ń gbie yeni Foŋanma ya yognu, ke o yini o O Diedo, wan maadi ya yognu: ");
INSERT INTO guxg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","O Diedo maadi n Diedo: “Kali n jienu ki guudi hali min ba cedi a yibalinba ń tua a taaŋmaada?” ");
INSERT INTO guxg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dafiid ya yini Kiristu O Diedo, li ba ga ledi wan go ya tie o bijua? ");
INSERT INTO guxg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Obákuli ki fidi ki jiini o bá lanbonli. Hali yeni li daali, nilobá kuli ki ji buali o buali. ");
INSERT INTO guxg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lani ki Jesu maadi yeni o nuwuligu yeni o ŋuankaabi ki tua: ");
INSERT INTO guxg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","U Tienu kadabanda nba yeni farisien nba n kubi Moyiisi ñɔmaama, ");
INSERT INTO guxg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ya tie mani ki gɔ cɔlni ban wangi yaali, ama yinbi n da nua ban tiendi yaali, kilima bi maadi ki naa tiendi. ");
INSERT INTO guxg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bi tungi bi niba ya tuga n kpiagi, yaali ki ban mɔno kan tuo ki taa bi nubila ki tugi. ");
INSERT INTO guxg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bi tie bi bona kuli ki bi niba n ya nɔbi (nuabi), yeni bi tila yia ya po ki bi diani U Tienu maama yi gbengi ki cie li liela kuli, ki bi tiadi ñɔgbana pia. ");
INSERT INTO guxg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bani n gɔ ŋanbi ki buadi a kinkaan cincina ti wondn ni yeni bi tintaandiena nni, ");
INSERT INTO guxg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","bi bua k bi ya cua bi niba nni, ban ya fuondiba ki yib canba nba. ");
INSERT INTO guxg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ama yinbi, da ŋaa mani ki bi yii canba nba, kilima i pia canba yendi, yua n ye tapoli po. ");
INSERT INTO guxg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yin gɔ da yii nul i tinga ne po i baá, kilima i pia baá yendo, yua n ye tapoli po. ");
INSERT INTO guxg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Da ŋaa mani k bi yii yonbidaan, kilima, yendo baba n tie i yudaano, lani n tie klisto. ");
INSERT INTO guxg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yua tie kpel i siign ni ba tua i tuonsɔnlo, ");
INSERT INTO guxg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","yua n dongi oba, b bu jiini o, ki yua jiindi oba ban doni o. ");
INSERT INTO guxg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yubɔnli i po, yinbi a gbanbanda yeni falisien munafigi danbi ne, kilima i pangi bi niba U Tienu diema nni kuama, yinbi mɔno, i ki bua ki kua, i gɔ kan ŋaa yaabi n bua ban kua mɔ, ban kua. ");
INSERT INTO guxg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yubɔnli i po, yinbi a gbanbanda yeni falisien mɔnafiki danba, kilima, i gbendi a pakuana (kpepuol) pianmi, k fani ki jaandi ki nan maadi ti maayuyuodi; li po n cedi ki buudi te baa bia. ");
INSERT INTO guxg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Fala tie i yaali yinbi a gbanbanda yeni falisien nba, ki dugni i caa ya longbana n fagn ki kpaani yaabi n bu kua i jaandi. I ya la nuyendi, o biidi gɔ yi pugni ki kuan o o muu diegu. ");
INSERT INTO guxg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yubɔnli i po yinbi yaabi n ki nɔ ki mɔ ji ŋmagdi i liebi, yinbi n maadi k nuli ya puoni o puoni u jaandidieciangu yeli po li ki biidi, ama nul ya puoni k li tie o jaandidieciangu wula po k k cɔlni li puoni, li kanŋaagu. ");
INSERT INTO guxg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","I ki pia yami ba waami, i tie juama paaa, le po n ji yabi ki cie o lieli, wula bii o jandidieciangu yia cedi wula yi ŋanbi U Tienu nugn ni? ");
INSERT INTO guxg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yinbi n gɔ maadi ki nul ya poli salgbinbindli po l ki pia maami ama nul ya poli k li tie salgi yaali n maa l binbindli po k ki cɔln o maami li kan ŋaagu. ");
INSERT INTO guxg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","I tie juama paaa, le n cie l lieli i, salgi bii li binbindli yia cedi k salgi yen mɔni U Tienu nugn ni? ");
INSERT INTO guxg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yua puoni bonli, altaro yeli po, o puoni yeni yaali n maa l po kuli. ");
INSERT INTO guxg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yua n ́ puoni bonli k taa u jaandidieciangu yeli, u ta yeni U Tienu yeli, wani U le yeni li jaandidieli. ");
INSERT INTO guxg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ki yua n gɔ puoni bonli tapoli po yeli po, wan bandi k o puoni U Tienu kankaanu yeli po i, o taani yeni U Tienu kuli. ");
INSERT INTO guxg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yubɔnli i po yinbi a gbanbanda yeni farisien nba munafiki danbi ne, kilkima i paa......... k ŋaan yaali n mɔni, lani n tie k n kuni i mɔni, sugli yeni ti ŋandi nni. ");
INSERT INTO guxg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yinbi bi juanbi mɔ u, ki ji b dadi i lieba! Yinbi n yedi ki bua mi ñunŋanbi, ki bi tindi ki ñani i naasiigi ki nan sieni o taamo ki nali. ");
INSERT INTO guxg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Fala tie i yali, yinbi a gbanbanda yeni ŋalacidanba, kilima i ŋanbd i jieditiadi yeni i ñuñubona puoli po i, ki ŋaa yaali n ye lien nni, k li gbieyeni ti naayignmi yeni o faagu. ");
INSERT INTO guxg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fini farisien juamo ne, cili ki ŋanbi a ñuñubonli nni yeni a jeditagdgin no, ki li puoli po n mɔn fidi ki ya ŋani. ");
INSERT INTO guxg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yubɔnli i po yinbi a gbanbanda yeni farisien ŋalacidanbi ne, kilima i tie nani ya kakula (kula) k bi yi ŋanbi li puoli po lan bedi ama k li tingi po gbieyeni a kpab bedma yeni i cincibiadmu buoli kuli. ");
INSERT INTO guxg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","I mɔ tie yeni, cincanli po i naan yen nimɔnbi yeni ama ki tukdn nan gbie yeni ŋalaci yeni biid. ");
INSERT INTO guxg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yubonli, i po yinba gbanbanda yeni farisienba ŋalacidanba, kelima, i maa bi sawalpuaba kakula ki ŋanbdi bi nimɔnba kakula. ");
INSERT INTO guxg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","I maadi: “Ti ya bo ye ti yaajanba yogu, ti bo kan kuani ti nuu yaaba wuli sawalpuaba sɔma. ");
INSERT INTO guxg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lanwani ii, i tuo ki tieni kasiedi ke i tie yaaba n wuli bi sawalpuaba sɔma bila i. ");
INSERT INTO guxg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","I mɔko gbie yeni i yaajanba tuonbiadi i. ");
INSERT INTO guxg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Waalaba, walabiada buolu, i ba fidi ki ciadi ku mubuogu yeni li daajuodkaali buudi jiama aa? ");
INSERT INTO guxg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lanyapo i ke n ba sɔni i kani bi sawalpuaba, bi yanfodanba, yeni yiko gbanbanda. I ba kpa bine, ki kpaa tianba li daapɔnpɔnli po, yaaba n sieni mo, yin pua ba a finfiba i yikodi cogdiena nni, ki beli ki ñani ba i dogu nni. ");
INSERT INTO guxg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lan ba baa maama, li tie ke ban wuli ya niteginkaaba sɔma ki tinga po, ki cili o niteginka Abeli, ki ban juodi Berekia bijua Sakari, yin bo kpa yua ku jaandiegu yeni li jaanbinbindli siiga baa maa i yula po i. ");
INSERT INTO guxg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N maadi yi i mɔmɔni, ya bona ne kuli ba tieni ya nifiima ne ya yogu i. ");
INSERT INTO guxg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalema, Jerusalema, fini yua n kpa bi sawalpuaba, ki lugdi ban sɔni yaaba i kani a tana! bonmŋa i ke n bi sugni min taani a bila na ya koomado n yi taani o koobimu o fiabi nni yeni, ama a naa pia li buama. ");
INSERT INTO guxg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Diidi, a diegu ba tua diegbenli. ");
INSERT INTO guxg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kelima N maadi yi, i ji kan la nni, ki cili mɔla hali yeni yin yedi, “Mi yediŋanma ye yeni yua kpendi o Diedo yeli po.” ");
INSERT INTO guxg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu ñani ojaanddiecioangu n ni k paani k caa k u ŋuadi kaabi nagn ni k maad 'o yen'o k waan'o l jaanddiociangu n diena n maa maam ");
INSERT INTO guxg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","k jesu ŋmianm i n tua i laa a? L kul t bu bedi k duani tingi sa -la -la -la k baa tan yeni kan sieni k yaa tua l lieli po ");
INSERT INTO guxg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","lani k jesu doni k kali oliif tiidi juali po. ku ŋuadikaabi baa k la'ɔg, k bual'o k wan waani ya yogu k l bona bu tieni yeni ya bona bu waani k u baami yeni ŋanduna juodnmi ji ki fagi. ");
INSERT INTO guxg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","k Jesu ŋmian'mi juo mani i baa k ban daa bɔndi i. ");
INSERT INTO guxg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","B nubi boncianli t bu baa k ya kubi n yeli k tua k bani tie kristo, b bu bɔndi b nubi boncianli ban tudi u sanu ");
INSERT INTO guxg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","I baa gbia k u tɔbu pua k bia gbia o tɔbi i yam n daa ŋmadi kaa l buali k l kuli ne n tieni yo ama ŋanduna juodigi daa kaa. ");
INSERT INTO guxg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","U buolu bo yi t fii k kɔni yeni buol tianu, dogu n fii k kɔni yeni dogutianu. M kom bu yi t baa a dongbanaa i boncianli, a dongbantiana mɔ tingi ń jegi ");
INSERT INTO guxg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","L kuli ne daa tie u madu yianu cilgi. ");
INSERT INTO guxg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","B nubi bu kuad'i ban cuo 'i k waani fala, k kpa'i, ŋanduna nubi kuli kan yaa bua i maam k dugn i n po. ");
INSERT INTO guxg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","l yogu nubi boncianli bu biani b dandanli, k kuadi b liebi k kan yaa bua b liebi nublu. ");
INSERT INTO guxg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","O faaugu dambi t bo fii k yedi k b tie u tienu sogni- nba, k bɔndi b nubi boncianli. ");
INSERT INTO guxg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","T biid boncianli t bo yabdi i tinga ne po, b nubi boncianli buami t bu wadi ");
INSERT INTO guxg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama yua juuni caa yeni l juogi, u tienu bu fie wani ");
INSERT INTO guxg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","B bu muadi u tienu bal laabaamanli ŋanduna kuli, i buoli kuli n gbadi yo, ŋanduna ń ji fidi k juodi. ");
INSERT INTO guxg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","I ya t la o bonbiiugu yua ŋmadi b nubi yam baa k kua o jaanddieciangu n i nani u tienu sogni Daniali n bo maad maam (yua cogi l lanbonli ne wan gbadi l niimn) ");
INSERT INTO guxg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","L yogu yaabi ye Suude dogu n i ban sani k kua a juana n i ");
INSERT INTO guxg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yua ye o dekanbuag po wan daa kua deni n k u bu tugi u tiadi. ");
INSERT INTO guxg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yua ye u kuan po n mɔ daa tua k u bu lebdi k taa u liadli. ");
INSERT INTO guxg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","L dana n i fala b u gbadi a puotunpunma yeni i canpandimu naa -nba i. ");
INSERT INTO guxg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ya jaandi mani k l nantaali daali ń daa tu yeni bɔdilua yogu bii Saaba daali. ");
INSERT INTO guxg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","L dana n i b nubi bu cagn i yaa cacagnmi hal k baa ban k la ŋanduna n cil ya yogu yeni mɔlane. Nul bia ji kan ban k cagn i l cacagbuolu liemi ");
INSERT INTO guxg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","L bo yaa tie k l dana ba tie yeni k fagdi, nul bo kan ciadi ama u tienu nigandikaabi po i k u bu wadi l dana. ");
INSERT INTO guxg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lani nul yaa t maad'i k kristo ye ne lan bii k u ye ne po, yi daa tuo k tie mɔni. ");
INSERT INTO guxg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","K dugn i u faaugu dami t bo fii k yedi k bani n tie Kristo, b tianb n yedi k ban tie u tienu sogni -nba i, bt bu tienu o yaalidigu tuona, lyaa bo tie k b bu fidi, ban bɔndi u tienu nigannkaabi mɔno. ");
INSERT INTO guxg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","N tuodi k waani n yeni. ");
INSERT INTO guxg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Lani, nul yaa t maadi k wan ye i tinkuonŋ n i yi daa caa, bii ku ye deni po yi daa tuo k l tie mɔni. ");
INSERT INTO guxg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","nani u tañigidu i yi ña puoli k gadi nutuali yeni u nufosaalo bijua mɔ t bo cua yeni ");
INSERT INTO guxg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","l bonkpieli n ye naani nanyobil - nba mɔ tigi lan kani. ");
INSERT INTO guxg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","L cacagnm dana t baa pendi yeni k k u yenu bɔndo, o ŋmaali mɔ kan ya pieni t ŋmaabidi bo ña tanpol po k baa baa. ya bona ye tanpol po kuli k pia u paal kul bu sag g ŋmadi yeni l lieli. ");
INSERT INTO guxg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","L yognui k b bu la l bonli tanpol po yal wangi k u nufosaali bijua baami pundi ŋanduna buoli kul ji baa fabn i, b bu la u nufosaali bijua n n ña t tawalgbandi n i yeni u paacianmu yeni t yudandi yua yabi ");
INSERT INTO guxg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","U bo sɔni u maleki -nba yeni a naatuna yaali n mɔ ban taani u nigandikaabi kuli yaab n bo ye puoli, nintuali yaangi yeni yanbangu, ŋanduna kaan kuli. ");
INSERT INTO guxg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Gaa mani l tudli ne o kinkanm kani. Yaa yogu k u tɔ a bendimaana k u faadi cil k bundi, i bani k l kpañili nag. ");
INSERT INTO guxg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nani i mɔ ya t la l bona kuli, yi bandi k u nifosaali bijua nag i, k u ji ye i diñɔna n i. ");
INSERT INTO guxg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yeni i mɔni n maadi l kuli ne b u tieni k sua mɔla nubi yaabi n ye ne k b tɔbi daa kpe. ");
INSERT INTO guxg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","pol yeni i tingi b u pendi ama n maam wan kan ban k pendi. ");
INSERT INTO guxg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Baa nul k bani l daal k bua ya yogu k l bona bu tieni. Maleki - nba ye pol k bani, u tienu bijua mɔno k bani, n baa u tienu yaa kaa. ");
INSERT INTO guxg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nani lan bo tieni nandi nowe yogu yeni l bia t baa tie yeni u nufosaalo bijua baa yogu. ");
INSERT INTO guxg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ya dana n pend o k ñinm fidi yili ŋanduna kul yeni, b nubi bo di k ñu k kuandi b puobi k puuni b bidi b jabi, caa yeni yaa daali k Nowe kua u ŋadugu n i ");
INSERT INTO guxg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","k ŋaa'b k b l ye kaa pia uyanbani baa kuli, k ñinm t baa dinb'i. U nufosaali bijua mɔ ya baanm t baa tie yeni. ");
INSERT INTO guxg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","jabilie t baa ye u kpaabin i wan taa yedi k ŋa tiani ");
INSERT INTO guxg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","puobilie t baa naan i dii wan taa yendi k ŋaa tiani ");
INSERT INTO guxg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lani daa guandi mani, k dugn i i k bani yaa daali k i yonmdaano bu cua. ");
INSERT INTO guxg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ŋanbi mani k sogi ne: U diedaano bo ya bani u suud n bo baa ya yogu u bo kan guani, u bo kan ŋaa u suud n kua u den ");
INSERT INTO guxg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","lani mɔ baan mani k yaa guu kelima o nufosaali bijua t bo yi yaa maali k u bu yogubaa i. ");
INSERT INTO guxg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ya tuonsɔlo k u canba guun'o u tuonsunliebi, k wan yaa tien'mi t m jiemi ban bua yaa yogu, ");
INSERT INTO guxg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","l tuonsɔlo yaa sogi, g bia sogi u canbaa maami, k u t kpeni yaa daali g sua k u ŋanm k sɔni u tuonli l pamanli baa tie l tuonsɔnlo yaali ");
INSERT INTO guxg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yeni i mɔni n maad'i u canbaa bu taa u piami kuli k guun wani. ");
INSERT INTO guxg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama l yaa tie ya tuonsɔlo k pia yaam, k maadi u pal n i k u canbaa daa kan kpen mɔlane, ");
INSERT INTO guxg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","k ji cuo u lieb k pua, k di k ñu yeni a dañuula u canbaa t bo kpeni wan k guu yaa daali, yeni yaa yogu k waa bani, ");
INSERT INTO guxg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","k ñan'o, k taan'o yeni munafigidanmi naani k b baa buudi k ŋmani a ñina. ");
INSERT INTO guxg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Lanwani tapoli po diema baa naani nani Jafa nba piiga yaaba n den ta bi fidisanmu ki bua cindi o po ja yeni. ");
INSERT INTO guxg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bi siiga bobinu den ki tie yandanba, ama bonbimu wani den pia mi yanma. ");
INSERT INTO guxg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bi yan pia danba taa bi bi fidisamu baa den tiadi ki taa mi kpama ki kubi. ");
INSERT INTO guxg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama bi yandanba wani dentiadi ki tami kpama. ");
INSERT INTO guxg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","O poja nden waagi, kaapunditonma, mi guama den gulibikuliki bi guani. ");
INSERT INTO guxg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Gu yɔgisiigu ke bi kpaadi kiyigini. O poja pundo. Fi mani tin tuogi o. ");
INSERT INTO guxg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bani Jafa nba piga yeni kulifiiki bobini bi fidisanmu. ");
INSERT INTO guxg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ke bi yanpiadanba maadi, biyandanba, puni ti mani ti mi kpama kelima ti fidisanmu gbindi. ");
INSERT INTO guxg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ama ke bi yandanma maadi, li kan fiditin tieni ti yaa fidisanmu nni yeni yi yaa yumu nni, gadi mani yaaba n kuadi kani ki da yi yali mo. ");
INSERT INTO guxg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ban gadi ki baa daa mi kpama, ke o poja pundi, ke bi yandanba kua yeni o li pogalikani, ke bi luoni li ganli. ");
INSERT INTO guxg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lan pugini waamu, ke bi pundi ki maadi: «canba, canba, luodi ti po li ganli tinkua.» ");
INSERT INTO guxg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ti yapo, yin daa gɔa mani kelima yii bani li daali ki buali li yogunu. ");
INSERT INTO guxg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Li baa tie yenmanani yaa jua n den ca o sanu, ki yini o tuosɔnba ki teni ba o piama. ");
INSERT INTO guxg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O den taa dibalamu kiteni cincinliyua, o lielo ligibalalie, o taalo ligibaliyenlo, o denteni yua kuli yeni o palu n dagidi maama. ");
INSERT INTO guxg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yua den gaa ligibalamuu dentaa ki sɔni li tuonli ki ba ligibala muu ki pugini. ");
INSERT INTO guxg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yua go den gaalibalalie mo den sɔni ki baa ligibalalie ki pugini. ");
INSERT INTO guxg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama o taalo yua den gaa ligibalayenli, den gadi ki pan gbiidi yaa buogun yabi ki ta ocanba ligiki piini. ");
INSERT INTO guxg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Li den waagi ke canba ti ñani u sanu ki kpeni ki yini bi kuli ki wan diidi yua kuli yaa tuonli n tie maama. ");
INSERT INTO guxg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yua n den gaa ligibalamu n nagini o canba kani ki yedi: «Canba n den gaa ligibalamu ki sɔni ki baa ligibalamu ki pugini.» ");
INSERT INTO guxg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","O canba n yedi o: «li ŋani, a tie yaa tuonsɔnlo n mɔni, a den gaa waamu ki fidi ki kubi. N baa guuni a yaala n yabi. Cua ke yaa ye yeni nni li pamanli n deni.» ");
INSERT INTO guxg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yua den gaa ligibalalie n cua ki yedi: «canba, a den teni nni ligibalalie n sɔni ki baa ligibalalie kipugini. ");
INSERT INTO guxg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","O canba den yedi o, li ŋani a tie yaatuonsɔnlo n mɔni, a den gaa waamu ki fidi ki kubi, n baa guuni a yaala n yabi, cua ki yaa ye yeni nni li pamanli n deni. ");
INSERT INTO guxg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yua n den gaa ligibaliyenli n mɔ n cua ki yedi: «canba, n bani ke a tie yaa nilo n paa. A yendi ŋan ki buli nani kani ki wodi ŋan ki lendi naani. ");
INSERT INTO guxg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","N den jie ŋaa ki ta a ligitanli ki gbiidi ki piini, Diidi a ligitanli n yeni, gaa. ");
INSERT INTO guxg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","O canba den ŋmiani o a tie nibiado yo, ŋaa bua fala, a den bani ke n yendi min ki buli naani, ki wodi min kilindi naani ");
INSERT INTO guxg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","a den kan fidi ki ta nligitanli ki gadi ki bili liligidieli nni, halimin kpeni i, li bo baa mali n po. ");
INSERT INTO guxg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Gaa mani o ligitanyenli ki teni mani yua n pia ligitana piiga. ");
INSERT INTO guxg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","kelima yua n pia, bi baa pugini o wan yaa pia ke li yabi ama yua n ki pia baa wan pia yaala wamuu, bi baa gaa. ");
INSERT INTO guxg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Lu mani o niinpo nani n biigi, li bubuuliyeni fala n baa ye naani. ");
INSERT INTO guxg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yaa yogunu ke oja bija baa guanni yeni o kpiagidi yeni o malekinba, o baa kali o badidiema po. ");
INSERT INTO guxg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","I nibuoli kuli baa taani okani wan paadi yua kuli yeni o kaanu nani o yankpaalo n yi paadi i ŋɔañe yeni a ŋɔatona maama. ");
INSERT INTO guxg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","O baa bili i ŋɔañe o jienu, a ŋɔatona o kaanu. ");
INSERT INTO guxg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yeni o badi baa yedi yaaba n ye o jienu po: «kua mani yinba yaaba ke nba yadi mi yediŋanma i po, kua mani mi badidiema nni yaama ke nba den bobini i po hali ŋanduna n cili yaa yogunu o. ");
INSERT INTO guxg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","kelima mi koma den pianni ki puni nni ti jiedi ke n dini, u ñinñunu den pia nni kipuni nni mi ñinma ke n ñuni. Min den tua caano, i den gaa nni i deni. ");
INSERT INTO guxg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","N den paa cankpalonli, ki den yie nni ti tiadi, min den ki pia laafia mɔ, i den dogidi nni, min den ye li yonmidielinni, i den cua ki fuondi nni. ");
INSERT INTO guxg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ke bi gua ŋmiani o; ti yonmidaano, li laa daali ke ti den laa ŋa ke n koma pia ŋa ke ti teni a ti jiedike a dini? bi ke o ñinñuuni pia ŋa ke ti tena mi ñunma ke a ñuni? ");
INSERT INTO guxg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","bii a den tua caano bi yaa daali ti dogu nni ke ti gaa ŋaa? bii ke o ñinñuuni pia ŋa ke ti puni a mi ñunma ke a ñunii? ");
INSERT INTO guxg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","bii li laa daali ke a den yia, bii ki ye li yonmidieli nni ke ti cua ki fuondi a? ");
INSERT INTO guxg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ke o bado ŋmiani ba, yeni i momɔni maadi yua n den tieni bi kpiiba ne siiga baa yua n tie biñidiga tieni mini. ");
INSERT INTO guxg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Li yaa puoli po u baa gadi ki yedi yaaba n ye u ganu po, fagidimani n kani, yin bia mani i kuli, gadi mani u fantanbuogu nni yagu n den ke n den tuodi ki bobini sitaani yeni o malekinba po. ");
INSERT INTO guxg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kelima mi koma den cuo nni ke i teni nni ti jiedi ke n dini, o ñinñuuni mo den cuo nni, ke i teni mi ñunma ke n ñun. N go den tua caani i dogu nni, ke i gaani, n go den paa cankpalonli, ke i yieni nni, ke n gɔ den yiagi li yonmidielinni, ke i cua ki fuondi nni. ");
INSERT INTO guxg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ke bi gua maadi: «ti yonmidaano, li laa yaa daali ke ti den laa ŋa ke mi koma pia ŋa, bii ñinñuuni pia ŋa, bii ke a tua caano, bii ke a tua caano, bii ke a paa cankpalonli, bii ke a yia bii ke a ye li yonmidieli nni? ");
INSERT INTO guxg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ke o guani ki ŋmianba: N maadi i momɔni nni yaala ke de tieni yaaba ne siiga kuli, yua n tie i biga, i den tieni mini. ");
INSERT INTO guxg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bi kuli baa gadi mi fantanma buogu nni, yaaba n tiegi n baa yaa miala kan gbeni. ");
INSERT INTO guxg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","jesu den maadi laa maama kuli ki gbeni o den yedi o ŋoadikaaba. ");
INSERT INTO guxg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","yi bani ke pa sieni dana lie ke bi baa janbi ki cuo o nisaalo biga ki teni ban joano li dapoanpoanli po ki teni ban kpa o ");
INSERT INTO guxg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","sala yidikacianba yeni udogu ni kpela den taani Kayifa lojagu nni ");
INSERT INTO guxg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bi den jagi ki baa cuo jesu ki teni ban kpa o. ");
INSERT INTO guxg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","bi den yedi ke landa tua mi jaanma yoginu ke bi niba n da ti fiini mi yiema. ");
INSERT INTO guxg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","jesu n den ye o gbaado Simoano deni. ");
INSERT INTO guxg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nani ban den ye mijiema kaanu o pua den cua ki kubi yaa badiga n yi alibate ki gbie yeni tulale ke o daagu pa o den wuli o jesu yuli po. ");
INSERT INTO guxg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","biŋoadikaaba n den la lani bi pala den beni ki bi yedi: be yaa po yo ke yi biani yaa tulale n yene. ");
INSERT INTO guxg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","bi bi baa fidi ki kuai li tulale yaa ligin yabi ki pa aluoda. ");
INSERT INTO guxg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","jesu den bandilaa bonla ki yedi be yaa po yo ke yi jaligi yaa pua n tiena? o tieni boŋanle npo. ");
INSERT INTO guxg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yi baa pia aluoda ke bi ye yeni yoginu kui, ama mini wan ka. ");
INSERT INTO guxg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","wan wuli n po laa tulale yeni otieni la ki baa ŋanbi nkuuma. ");
INSERT INTO guxg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","n maadi yi moamoani ban baa waani olabaaliŋamo naankani kuli ŋanduna nni bi baa togidi o pua ne n tieni yaala npo. ");
INSERT INTO guxg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","judasa bi piiga n ŋoadika liediba siiga yua den gedi bani utienu sala yidi kaaba kani. ");
INSERT INTO guxg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ki yedi yi baa pa nni be n yaa janbo ki teni yi? bi den yedi o, ligi bidi pii ta. ");
INSERT INTO guxg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ki cindi laa yoginu o den kpaani wan baa tieni maama ki janbo ki teni ba. ");
INSERT INTO guxg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","li dacincinli yaa paano n ki pia dabinli daali jesu ŋoadikaaba den maadi ki yedi abua tin gedi le ki ban ŋanbi a po Paki jiema. ");
INSERT INTO guxg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","o den guani yedi ba gedi mani udogu nni o ne deni ki yedi o, canba yedi daa n yoginu nagini n bua n bua ki di Paki jiema yeni n ŋoadikaaba ayaa deni. ");
INSERT INTO guxg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","bi ŋoadikaaba den tieni jesu n den yedi ba yaala ki ŋanbi Paki jiema. ");
INSERT INTO guxg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ku dajuagu n cua o den kali usajekaanu kani yeni o ŋoadikaaba. ");
INSERT INTO guxg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ban den di yaa yoginu o den yedi ba imoamoani n waani yi siiga niyendo baa janbi nni ");
INSERT INTO guxg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","li den biidi bi pala ki yagi bi yama, ke bi siiga yua kuli den cindi ki bualo canba li tie mini yo? ");
INSERT INTO guxg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","o den goa ki ŋmiani ba yua n taani ki tuuni o nu ku saatiagu nni wani n baa janbi nni. ");
INSERT INTO guxg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","onisaalo biga caa nani lan diani idiani o po maama yeni, ama fala baa ye yeni yua n baa janbi o nisaalo bi li den baa ŋani ki cie lan daano po bi yaa den mali o. ");
INSERT INTO guxg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","judasa yua n den baa janbo den yedi o, li tie mini yo jesu den goa ŋmiano ayedi aba la. ");
INSERT INTO guxg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ban den di yaa yoginu jesu den ta paano ki jaandi ki jendi ki tenba o ŋoadikaaba ki yedi ga mani ki ŋmani li ne n tie n gbanandi. ");
INSERT INTO guxg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","o go den ta ki tadi ñokaaga ki jaandi ki mia utienu ŋanbili li po ki teni ba ki yedi yi kuli n ño mani. ");
INSERT INTO guxg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kelima li ne n tie n soama yaa ma n wuli ti tuonbiidi sugili po. ");
INSERT INTO guxg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","n kan go ño bu duven tibu bonluonkaala daama hali min go baa ti taani yeni ki ñoma bon panma n Ba diema nni. ");
INSERT INTO guxg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ban den yindi utienu yani bi den ñani ki gedi olife tiidi juali po. ");
INSERT INTO guxg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","lani jesu den yedi ba ku dajuagu nne n baa tua yi po li tingbali bonla nani lan diani maama ");
INSERT INTO guxg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","n baa pua ki kpa o yankpaalo u pekulu mon n yadi ama n yaa ti fii bi bi kpienba siiga n baa ga yi liiga ki gedi Galile po. ");
INSERT INTO guxg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pieli den ta mi maama ki yedi o, ba bi kuli yaa sani ki ŋaa ŋa mini wani kan sani ki ŋaa ŋa. ");
INSERT INTO guxg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","jesu den goa ki ŋmiano n yedi a, i moamoani ba dinla ñiagu hali ku kotongu daa mua a baa nia nni taalima ta. ");
INSERT INTO guxg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pieli den guano ba li yaa tie min taani ki kpe yena nkan nia ke mii bana yaa ŋoadikaaba n sieni moko den yedi yeni. ");
INSERT INTO guxg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","lanyoginu jesu den gedi wan leni o ŋoadikaaba yaa kaanu n yi Jetisamane o den yediba kali man ne ke min suagi liiga ki ban jaandi. ");
INSERT INTO guxg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","o den ta Pieli yeni Sebede bijaliediba o den cindi ki la ti yanyagiciandi yeni li paboanli o niin nni. ");
INSERT INTO guxg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","lani o den yediba li paboanli cuo nni hali ke naani nani n baa kpe yeni sedi man ne ki yaa jaandi yeni nni ki da guani. ");
INSERT INTO guxg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","o den foagidi yeni ba waamu ki den ba ki labini o nunga po, ki maadi n Ba li yaa baa tuo ŋan foagidi ki tadiñokaaga ne n kani ama lan da tua mini ka n bua maama ama fine n bua maama. ");
INSERT INTO guxg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","o den guani bi ŋoadikaaba kani ki sua ke mi guama guli ba o den yedi Pieli yii fidi ki guudi nni ba yoginu waamu? ");
INSERT INTO guxg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","yaa guu mani ki jaandi ke yin da ti kua mi tulinma nni li yan tiali bua ama ti gbanandi nan tadi ");
INSERT INTO guxg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O go den foagidi yeni ba mi ta liema po ki jaandi ki yedi nBa li yaa tie keli kan tuo ŋan foagidi laa tadiñokaaga ke se min ño a yan buama n tieni ");
INSERT INTO guxg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ogo den guani bi kani ki sua ke bi goa kelima mi guama den gbadi ba. ");
INSERT INTO guxg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","lani go den ñani bi kani ki foagidi ki ban jaandi mi ta taama ki togidi o ma kpiama. ");
INSERT INTO guxg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","jesu den guani oŋoadikaaba kani ki sua ki bi baa goa ke o yedi ba yi baa goa ki fuo yo? diidi uyoginu pundi ke bi baa janbi o nisaalo biga ki teno ti tuonbiidi danba nuu nni. ");
INSERT INTO guxg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","fii mani tin fuadi mani ne yua n baa janbi nni nagini. ");
INSERT INTO guxg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","wan den maadi ba yaa yoginu bi piiga niliediba siiga nyua judasa den cua ki yegi yeni yaa niba n yabi, utienu sala yidi kaaba yeni a nikpela n den soani yaaba den taani ki pundi yeno ki kubi igbiani yeni mu jugimu. ");
INSERT INTO guxg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","wani yua n den baa janbi jesu den tuodi ki waan ba yaa banma n tiena ki yedi ba yua ke n baa bibo wani yeni yin cuo o mani. ");
INSERT INTO guxg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","lan yoginu o den cua jesu kani ki yedi n fuonda canba yeni o den bibi o, ");
INSERT INTO guxg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","jesu den guani ki ŋiano n danli tieni ŋan cua ki bua ki tieni yaala ton toni, lan wani bi den bibi ki cuo jesu nu ki cuo o. ");
INSERT INTO guxg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","diidi yaa niba n den yegi yeni jesu siiga nni niyendo den tandi o nugu ki noadi o juga ki pedi ki jia salayidika ciamo naacemo tubili ");
INSERT INTO guxg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","lani jsu den guani ki yedi o guani ki ŋuuni ajuga ki kaanu kelima yua n baa koani yeni mu jugimu baa bodi yeni mujugimu. ");
INSERT INTO guxg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","naani a ki bani ke n baa fidi ki mia n Ba wan soani n po piiga n toa caga lie. ");
INSERT INTO guxg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ama li yaa tieni yeni idiani baa kua lede nani lan yedi maama idiani nni ke li tie ti ladi li kuli n tieni. ");
INSERT INTO guxg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","jesu den maadi yeni li niba yi cua n kaniki kubi igbiani yeni mujugimu nani yi kpaani o naa yigo yeni n den ye daali kuli utienu diegu nni ki bangi yii den cuo nni. ");
INSERT INTO guxg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","lanbonla kuli ne tieni ke lan kuani utienu nisoaginkaaba n den diani yaala ntieni lani bi ŋoadikaaba kuli den ŋa o ki sani. ");
INSERT INTO guxg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","yaaba n den cuo jesu yeni den gedi no salayidikaciamo deni naan kani ke utienu maama gban banda yeni anikpela den taani. ");
INSERT INTO guxg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","pieli den ŋoa hali puoli po ki ban kua salayikaciamo lojagu nni o den pundi ki kali yeni bi guudi kaaba ki baa le lan baa cuoni maama. ");
INSERT INTO guxg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","sala yidi kacianba yeni anikpela den kpaani ban baa pua jesu po yaa faama ki ba ki kpa o ");
INSERT INTO guxg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","baa den la ban baa fidi ki tabo yeni yaala ba ke yaaba n den tiendi o po mi siedi faama den ye li kani ki yabi li den baa siedi n ba lie ki bi cua ");
INSERT INTO guxg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ki yedi o naa joa den yedi n baa fidi ki mudi utienu diegu ki guani ki maagu dana ta. ");
INSERT INTO guxg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","salayidikaciamo den fii ki yedi o, a kan guani maama baa? yaa niba yene tiendi a po be siedi nyeni. ");
INSERT INTO guxg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","jesu den ŋmini salayidi kaciamo yeni den fii ki yedi o, n yedi a, ŋan waani ti hali utienu yua n fo poa yaa tie kilisiti utienu bijua. ");
INSERT INTO guxg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","jesu den guani ki ŋmiano fini a ba yedi la ama n yedi a, ke a baa le ke o nisaalo biga ka utienu jienu ki ñani ki kpendi a tawala nni tanpolo po. ");
INSERT INTO guxg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","lan wani salayidikaciamba yudaano den cuo ki padi o tiadi ki yedi ti go bua siedin ba ki tieni be? yi gbadi ke o sugidi utienu po. ");
INSERT INTO guxg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yi jagi be bi den guani ki yedi o li pundi wan kpe. ");
INSERT INTO guxg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","bi den sii ti ñinsandi o nunga nni ki pabino yeni bi nugi. ");
INSERT INTO guxg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ki maado ki tua soagini ti po utienu n yedi yaala a yaa tie kilisiti waani yua n pua ŋa. ");
INSERT INTO guxg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","pieli den kaa niini ku lojagu nni yaa pua n den tuuni li kani den cua ki yedi o, a moko den taa ki ye yeni jesu Galile. ");
INSERT INTO guxg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ama o den nia biniba kuli nintuali ki yedi mii bani ŋan bua ki yedi yaala. ");
INSERT INTO guxg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","o den tagi ki ca bubuli ñoabu po ki baa ña puo toa yua n go tuuni li kani den laa o, ki yedi yaaba n ye li kani ojoa ne moko den taa ki ye yeni jesu Nasaleti yua ");
INSERT INTO guxg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","o go den nia ki polini ki tua mii bani laa joa. ");
INSERT INTO guxg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","lan yen waamu yaaba n den ye li kani den nagini ki yedi pieli moamoane a moko li tie bi siiga nni yua yo kelima a maama doagidi ki waana. ");
INSERT INTO guxg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","lanwani o den cindi ki polini ki solini o yuli ki yedi mii bani laa joa lan yoginu ku kotongu den buudi ");
INSERT INTO guxg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","pieli den goa ki tiadi jesu n den yedi o, yaala hali ku kotongu daaa mua a baa nia nni taalima ta lani o den ca ki buudi yeni paboanli. ");
INSERT INTO guxg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","U siŋaapanpangu ke sala yidikaaba cianba yeni u dogu nni nikpela juogi ke bi baa teni ban kpa Yesu. ");
INSERT INTO guxg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bi bo lol'o ki gedi yen'o ki pan ten'o Pilati yua bo tie dogu daano i. ");
INSERT INTO guxg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juda yua bo janbi Yesu n bo la ke b jia wani Yesu buudi ki kadi ke b baa kpa'o. O bo mua ke o yaa bi janbi 'o. Ke o taa a kujapiena piitaa yeni ki gedi ban ŋmiani sala yidikaaba yudanba yeni bi nikpela. ");
INSERT INTO guxg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ki yedi n tieni t tuonbiadi ki kuadi yua naa pia tagili ba kuli. Bi bo guani ki yed'o lani mɔ naa ŋua ti li ŋua fine ");
INSERT INTO guxg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","O bo luni iligi yeni u Tienu diegu nni ki ñani ki gedi ban sadi o bá. ");
INSERT INTO guxg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","sala yidikaa yudaano n bo gandi gandi li ligi yeni ki yedi. Laa ŋani ke laa ligi n kua u Tienu ŋanmani kpagu nni. ");
INSERT INTO guxg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ban bo juogi b bo taa laa ligi ki daa o tanmaalo kpagu ke la ya tie b canbáa ");
INSERT INTO guxg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lani ya po bi bo yini li kuanu m sɔwulikaama kuanu hali yeni dine. ");
INSERT INTO guxg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lanwani o saawalipualo Jeremi n bo maadi ya maama n bo tieni. B bi gaa kujala piitaa Isaraheli yaaba n dini u daagu maama n yeni o po. ");
INSERT INTO guxg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ki daa o tanmaalo kuanu nani o diedo n bo maadi maama yeni. ");
INSERT INTO guxg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu bo sedi t buudidaano nintuali nni ke o bual'o: a tie jufi-nba bado bii? Ke Yesu guani ki yed'o: fini n yedi yeni. ");
INSERT INTO guxg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ama sala yidikaa yudaano yeni a nikpela bo jaligi Yesu. O naa bo yedi bonli ba. ");
INSERT INTO guxg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Lani yogunu Pilati bo yed'o: ŋaa gbia ban jalig'a yaala aa? ");
INSERT INTO guxg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesu naa bo ŋmiani baa bonli ba. Li yaa po t buudi daano yama bo yaadi. ");
INSERT INTO guxg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","O dogudaano bo maani ka wan luodi yonmyendo yua ke bi niba bua'o i jufi -nba jaama. ");
INSERT INTO guxg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lan yogunu o yonbo bo ye ke b yi'o Balabasi. ");
INSERT INTO guxg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","U niwuligu bo taani ke Pilati buali ba: i bua min faabi i po ŋmaa i? Balabasi bii Yesu ban yi yua Kirisi. ");
INSERT INTO guxg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","kelima n bo bani ke bi cuo Yesu li nunponbiadili po i li bujiali kani. ");
INSERT INTO guxg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wan daa bo kaa o bujiali kani o bo ke o denpua yini ki maadi'o. Daa kua o naa niteginkaa maama nni kelima ya ñiagu n pundi ne n la fala boncianli t dangidi nni kelima o ya po. ");
INSERT INTO guxg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sala yidikaa yudaano yeni a nikpela bo tundi bi niba ke ban cedi ban kpa Yesu ki lodi Barnabas. ");
INSERT INTO guxg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","O buujialo bo buali ba: min lodi ŋmaa i po? Ke bi bo yigini Barnabas. ");
INSERT INTO guxg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilati bo guani ki buali ba? Tin tieni be Jesu yua ke yi yi'o Kirisi? Bi bo yedi kpa'o. ");
INSERT INTO guxg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilati bo yedi: O tieni baa biadima? Bi gɔ bo tandi ke li paa cie ban jɔn'o li daapɔnpɔnli po ");
INSERT INTO guxg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilati bo bandi ke o ji kan fidi tieni bonli baa kuli ke u fuugu gɔ pugini ke o taa m ñinma ki nidi bi niba kuli nintuali nni ki yedi: Mii pia tagili ba kuli o naa niteginkaa sɔma wulima nni. li li yinba i. ");
INSERT INTO guxg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","U niwuligu kuli bo guani ki yed'o: o sɔma n guani baa tinba yeni t bila po ");
INSERT INTO guxg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilati bo lodi b po Barnabas i ki cedi ke b pua yesu a gbana. ki teni o nuu ke ban pan jɔn'o li daapɔnpɔnli po. ");
INSERT INTO guxg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wani o buujialo mintela bo kuani Yesu t buujiali deili nni ki taani bi cagili kuli ki kaa ki lind'o. ");
INSERT INTO guxg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","b B bo landi o tiadi ki bobin'o u kpalimɔngu ");
INSERT INTO guxg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","B bo piani o badi fegiliga yeni i kunkoni ki yilin'o ki mubini o jienu li kankagili. Ki ji ki gbaandi o nintuali nni ki tua: t fuond'a fini Jufi- nba bado. ");
INSERT INTO guxg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ke bi ji siini o po t ñinsandi ki yi taa li kankagili ki pua o yuli ");
INSERT INTO guxg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ban bo ñuañuadi'o ki gbeni bi bo bobidi o kpaliba ki guani lani'o o yaa tiadi ki gediki jɔn'o li daapɔnpɔnli po. ");
INSERT INTO guxg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ban bo caa bi bo tuogi Silena dogu nni yua ke b yi'o Simoni ke b tien'i u paalu ke o bugi Yesu daapɔnpɔnli. ");
INSERT INTO guxg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bi bo pundi ban yi yaa kaanu Gɔligɔta lani tie t yukuodi kaanu. ");
INSERT INTO guxg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ke bi ten'o u daamɔngu yeni yaa ñɔgu to ke wan ñu. Ama wan bo leni waa bo ñuni. ");
INSERT INTO guxg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ban bo kpa'o bi bo taa o tiayiekaadi ki tɔni tiatia bɔbɔgidi. ");
INSERT INTO guxg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lani ki ji kaa guu. ");
INSERT INTO guxg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bi bo diani ban bo kpa'o yaali ya yuli ki maadi: O ne n tie Jufi-nba Bado. ");
INSERT INTO guxg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bi bo kpaa nibiada lie ki taani yen'o. O yendo u jienu po o tɔ o ganu. ");
INSERT INTO guxg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A sancenda bo sugid'o ki fegini a yula ki tua: ");
INSERT INTO guxg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","fini yua baa mudi u Tienu diegu ki guani maa dana taa, gaa a yuli naanla. A ya tie u Tienu bijua ŋan jiidi li daapɔnpɔnli po. ");
INSERT INTO guxg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sala yidikaaba yudanba yeni li bali maama banda mɔ bo ñuad'o ki tua: ");
INSERT INTO guxg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","o bo gaa nitɔba ki nan ji kan fidi gaa o yuli. O yaa tie Isaraheli buolu yaaba bado mɔnmɔni wan jiidi li daapɔnpɔnli po mola ne lanwani t baa tuo ki daan'o. ");
INSERT INTO guxg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Odugi u Tienu po i u Tienu yaa bua o mɔnmɔni wan nan gaa'o mola kelima o bo yedi: «ntie u Tienu bijua yo.» ");
INSERT INTO guxg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ban bo taani kpaa'ba yeni ya nubiada mɔ bo sugid'o. ");
INSERT INTO guxg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ki cili u yensiicocoli li biigili bo tieni ki tinga nni kuli yaa caa u hali u yenjuogu. ");
INSERT INTO guxg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Li yenlibidili po Yesu bo yigini ki tiani ki maadi: Eli lamasabataani: Lan tie n Tienu n Tienu ba yaa po ke a ŋaa nni. ");
INSERT INTO guxg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ya niba n bo ye li kani bi tianba bo gbadi ki yedi: o yi o saawalipualo Eli i. ");
INSERT INTO guxg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tontoni b siiga yeni n sani pan taa u ciesuogu ki pagini m ñinmigma nni ki fini li kankagili po ki yugidi ki ten'o ke wan ñu. ");
INSERT INTO guxg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","O lieba bo tua cedi mani t diidi Eli ya baa cua ki ga'o. ");
INSERT INTO guxg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu gɔ bo tiani ke paa ki cabi o naano ki kpe. ");
INSERT INTO guxg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lanyogunu u Tienu diegu nni kpaldɔgikaabu bo padi siiga nni ki cili tanpoli ki ban jiini hali tinga nni ki bɔgidi kaani lie. Ki tinga bo digibi ke a tana yagidi ");
INSERT INTO guxg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A kakula bo yaadi u Tienu nigagidiŋanba yaaba bo kpe siiga boncianli bo fii bi tinkpiba siiga nni ");
INSERT INTO guxg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bi bo ñani a kakuli nni Yesu fiima bi tinkpiba siiga nni puoli. bi bo kua u dogagidiko nni ke bi niba boncianli la laa ba. ");
INSERT INTO guxg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Miteeli -nba canbáa yeni miteeli nba yaaba bo guu la ke i tinga niginigi yeni yaa bona tieni kuli. ke ti jiwaandi cuo ba ke bi maadi. «li ko baa tie mɔni ke o ne tie u Tienu bijua. ");
INSERT INTO guxg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bi puobi yaaba bo ŋɔdi Jesu Galile ki pan baa guud'o bo se fagima ki nua ");
INSERT INTO guxg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lani tie Maali Magdala Maali jaka yeni Josefi naá yeni Zebede bila naá. ");
INSERT INTO guxg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","U yenjuogu ke ja ba tie Aimate yua ke b yi 'o Josefi o mo bo tie Yesu ŋɔdikaa i ke o mo cua. ");
INSERT INTO guxg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ki nagini Palati kani ki mia ke wan taa Yesu gbannandi. Ke Pilati cabi ke bi taa Yesu gbannandi ki ten'o. ");
INSERT INTO guxg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ke Josefi taa Yesu gbannandi ki pɔbini li cincenpienli nni yaala ŋani nni ");
INSERT INTO guxg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ki duan'o li kakupanli nni wan bo cedi ke gbiidi yaala u tantiagu po. ");
INSERT INTO guxg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magidala yua Maliyam yeni Maliyam tua bo ye li kani ki kaa ki tiegi li kuli. ");
INSERT INTO guxg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lan bo fii ki fa bi bo bobini saaba daali ki gbeni yo. ke sala yidkaaba ciamo yeni falisiani -nba gedi ki la o dogudaano Pilati ");
INSERT INTO guxg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ki maadi'o. T bua tiad'a ke ki sua o daa fo o bo maadi ke dana taa daali n baa fii bi tinkpiaba siiga nni ");
INSERT INTO guxg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lani yaa po ŋan cedi ban yaa guu li kakuli hali dana taa daali ke o ŋɔdikaaba n daa cua ki su 'o. ki yedi bi niba ke o fii bi tinkpiba siiga nni laa bɔndiyuami ji baa cie li bo kpiali. ");
INSERT INTO guxg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilati bo yedi ba: I minteeli -nba ye taa bi mani ban gedi guudi nani yi bua maama. ");
INSERT INTO guxg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ke bi gedi ki bobini ban bo guudi li kakuli maama; ki ŋanbi biini li kakuli ki pɔli ki tieni m banma ki sieni soje-nba ke ban yaa guu. ");
INSERT INTO guxg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Saba jaanma ń pendi, li Laadi daacincinli siŋaapanpangu, ke Magdala dogu Maari yeni Maari tiano gedi ki bua gɔndi li kakuli. ");
INSERT INTO guxg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bi sua ke ki tinga migi boncianla, kelima O Diedo maliki ñani tanpoli, ki jiidi, ki bigdi ku tanpabgu yu bi luoni li kakuli yeni, ki kali kupo. ");
INSERT INTO guxg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","O den tuudi nani i taañigdi yeni, ke o tialakaadi pieni ki cie ti kunkundi. ");
INSERT INTO guxg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ti jawaanciandi ń kua li kakuli guudkaaba ban baa, ki pabi, ki tua nani kpiema yeni. ");
INSERT INTO guxg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ama maleki ń ga mi maama ki maadi bi puoba: “Yinba wani ń da jie; kelima n bani ke i lingi Jesu ban kpaa yua li daapɔnpɔnli po yeni. ");
INSERT INTO guxg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O ji ki ye ne; o yiedi o, nani wan den tuodi ki maadi maama. Cua mani ki diidi wan den dua naani.” ");
INSERT INTO guxg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gedi mani tonma ki maadi o ŋɔdkaaba ke o yiedi bi tinkpiba siiga. Maadi mani ba ke o liidi yi, ki gedi Galile; Lanpo i ke i baan la o. N maadi yi lani n yeni. ");
INSERT INTO guxg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bi puoba ń ña li kakuli kani yeni ti jawaandi, ama ke bi pala nan mani boncianla, ki gedi tonma ki ban waani o ŋɔdkaaba o laabaalŋamo. ");
INSERT INTO guxg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jesu ń tuogi ba u sanu nni, ki maadi: “N fuondi yi.” Ban nagni ki gbaani o nintuali, ki cuo o taana. ");
INSERT INTO guxg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Lanwani i, Jesu ń maadi ba: “Da jie mani; gedi mani ki maadi naataani, ke ban gedi Galile, ke lankani ke bi ba la nni.” ");
INSERT INTO guxg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ban den paa u sanu ki caa, li kakuli guudkaaba bi tianba den kua u dogu nni, ki dugni salga yidkaacianba yaali n tieni kuli ");
INSERT INTO guxg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ban taani ki kali yeni u dogu nni nikpelba ki juogi ki bibni bi guudkaaba i ligi boncianla, ");
INSERT INTO guxg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ki maadi ba: Maadi mani: “O ŋɔdkaaba den cua ku ñiagu nni ki ludi ti ke ti gɔa, ke bi suni ki ñani o gbannandi. ");
INSERT INTO guxg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Li ya tie ke Gufeneeli gbadi, ti ba maadi ki sɔngi o pali, ki maadi ki fie yi. ");
INSERT INTO guxg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bi guudkaaba ń ga i ligi, ki tieni nani ban maadi ba maama, Lani ya maama n ji yadi Jufinba siiga hali yeni mɔlane. ");
INSERT INTO guxg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Li piiga n ŋɔdkaayendo ń gedi Galile, Jesu ń bi waani ba ya juali po yeni. ");
INSERT INTO guxg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ban la o, ban baa ki gbaani o nintuali. Ama tianba den ye yeni tama. ");
INSERT INTO guxg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu ń nagni ki maadi ba ne: “bi teni nni Tanpoli yeni ki tinga po paalu kuli. ");
INSERT INTO guxg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gedi mani i nibuoli kuli nni ki ban batise ba, Báa yeni Bijua yeni U Tienu Foŋanma yeli po, ban tua n ŋɔdkaaba. ");
INSERT INTO guxg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yin tundi ba ban cɔlni min waani yi yaali kuli. Lani n yeni, n ye yeni yi daali kuli hali ŋanduna juodma. ");
INSERT INTO guxg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","U tienu bijua Jesu kirisi laabaalŋanmo cilma ");
INSERT INTO guxg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nani lan diani nandi osawalipualo Isahi tili nni. Ya nua min sɔni ya tondo a kani. ");
INSERT INTO guxg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","O tie ya nnilo kpaandi li fuali nni ki maadi ke; ŋanbi mani t yonmdaano sani ke lan tua sansiedu. ");
INSERT INTO guxg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","San bo cua ki wuli bi niba m ñima li fuali nni ki wangi'ba ke ban lebidi bi pala ki ŋaa t tuonbiadi. Ke o Tienu n tieni b po sugili bi po. ");
INSERT INTO guxg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jude dogu nni yaaaba yeni Jelisalemi yaaba kuli bo cuoni Jan kani. B bo tuo ki waani bi tuonbiadi ke Jan wuli'ba Jude kpenu nni. ");
INSERT INTO guxg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan bo laa li liadili ke b lugi yeni u yuoyuogu kobidi ki loli li gbanli o ciaga nni. T ñankpandi yeni t siidi n bo tie o jiema. ");
INSERT INTO guxg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jan bo waan'ba ki yedi: o tiano gɔ ŋua n puoli ki pia u paalu boncianli ki cie n i. Mini k pundi yua ba gbaani ki gbindi o taacaagbani ");
INSERT INTO guxg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mini wani wuli yeni m ñima ama wani baa wul' i yeni fuoŋanma i. ");
INSERT INTO guxg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lani ya daali ke Jesu bo ñani Gaalile dogu nni Naasaleti nni ki cua Jan kani ki gɔ wul'o Jude kpenu i ");
INSERT INTO guxg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu n bo ñani mi ñinma nni yaa yogu o bo la ke tanpoli luodi ke fuoŋanma ñani ki naani ki lanjiepienga yeni ke baa jagini o po ");
INSERT INTO guxg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Li yogu o nialu bo ñani tanpoli po ki maadi: O ne tie n bijua n pia li pakɔnli o po boncianla. N taa n buama kuli ki teni ŋa. ");
INSERT INTO guxg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ama fuoŋanma bo tudi'o ki gedi yen'o hali i tinkuonga nni. ");
INSERT INTO guxg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","O bo tieni danapiina ke Sitaani bigin'o, o bo ye yeni t muayandi ke maleki-ba ke u Tienu maleki -nba caan'o. ");
INSERT INTO guxg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ama ya yogu ke b bo cuo Jan batisi Jesu bo cua Gaalile ki wangi u Tienu laabaaŋanmo. ");
INSERT INTO guxg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","O bo maadi «u yogu kuli pundi n yeni u Tienu diema mo nagi. Lebidi mani i yama ki tuo u Tienu laabaaŋanmo. ");
INSERT INTO guxg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesu bo baa Gaalile ñinciama kani o bo la Siimo yeni o waaalo Andele. B bo lu bi janbuandi m ñinma nni ki kpaani i jami kelimaa b kuli bo tie jankpaanla i. ");
INSERT INTO guxg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu bo yedi'ba: «cua mani ki ŋɔdi nni n baa cedi yi ya co bi niba i» ");
INSERT INTO guxg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Li yogu li yogu b bo ŋaa b janbuandi ki ŋɔdi. ");
INSERT INTO guxg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesu n bo cuoni ki juandi waamu o bo la Zebede bila Saaki yeni o waalo San o ñinbiagu nni ki ŋanbidi bi janbuandi ");
INSERT INTO guxg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus bo yiin'ba ke bi siedi ŋaa b báa Zebede u ñinbiagu nni yeni b tuonsɔntiadi kuli ki ŋua Yesu. ");
INSERT INTO guxg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesu yeni o ŋɔdikaaba bo pundi Kafarnawomi dogu nni saaba daali ki li jaandieli nni ki bangindi yaaba n ye lienn u Tienu ñɔmaama ");
INSERT INTO guxg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","O bangima bo yaalidi'bi, kelimaa o bo bangi yeni yikodi waa bo bangi 'ba nani li bali maama gbanbanda yeni kaa ");
INSERT INTO guxg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ke li sua ja ba ye li kani ke i cicili biadi ŋua'o ke o yigini ki maadi: ");
INSERT INTO guxg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nasaleti Yesutinba yeni fini be yaa po i? A cua ke ŋan biani 'ti yoo oo? N bani ŋan tie yua. A tie u Tienu niŋanmo i. ");
INSERT INTO guxg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ke Yesu gaa t naajadi ke maadi: «suoni mani lan kani ki ña o nini» ");
INSERT INTO guxg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","li yogunu o ja yeni bo jiidi ki baa ke t tagi biidi yeni bua ña ki yigini ki kpandi o nialu. ");
INSERT INTO guxg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Li bo yaa lidi ya niba bo ye li kani. Ke bi buali bi lieba ne mɔ tie be yo oo? I tundi paani ke o tundi yeni yikodi i. O cedi ke a pola mɔno cɔlni o maama ");
INSERT INTO guxg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Lan yognu mɔno ke Yesu yeli doni Gaalile dogu nni. ");
INSERT INTO guxg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ban ñani jufi -nba tantaandieli nni ya yogu ke Yesu yen Saaki yeni San gedi Siimo nba deni. Ke li sua ke Simo cuado dua yeni u gbannantongu. ");
INSERT INTO guxg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Li yogu mɔno ke b maadi wani Yesu li gbannnanbiedi maama ");
INSERT INTO guxg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ke Yesu bo cua ki cuo o nugu ki fiini ki sien'o ke ogbannandi sɔngike o fii ki candi'ba. ");
INSERT INTO guxg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","li yenjuogu bi niba bo taa a yiama kuli yeni yaaba ke a pola ŋua'bi ki gedi yen'ba Yesu kani ");
INSERT INTO guxg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ke u dogu nni niba kuli taa ki ye u diñɔbu kani ");
INSERT INTO guxg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ke Yesu paagi yaaba kuli bo yia, ki gɔ beli ki yaani i cicilibiadi. O bo ki cabi i cicilibiadi ke ban maadi mɔno ki dugini b bo bani wan tie yua. ");
INSERT INTO guxg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesu yagidi ki fii ki gedi naani ke oba ki ye ki jaan i. ");
INSERT INTO guxg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ke Siimo yeni o lieba ŋua ki kpaa'o. ");
INSERT INTO guxg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ki la'o ki maad'o ke bi niba kuli kpaan'o. ");
INSERT INTO guxg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ke o maad'ba ya cuoni mani tin gedi u kaantianu. I dingbanbinmu nni ke min pan muandi lan po mo, ki dugini lan po n cedi ke n baa ");
INSERT INTO guxg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lani ke Yesu tɔgini Gaalile digbana kuli nni ki maadi u Tienu laabaaŋanmo jufi -nba tantaan diena nni. ");
INSERT INTO guxg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","o gbaado bo cua ki gbaani ki mia ki yedi: A ya bua a ba fidi ki paagi n i. ");
INSERT INTO guxg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","m ninñinma bo cuo Yesu ke tandi o nuugu ki sii'o ki yedi: n bua a agbannu n ŋanbi. ");
INSERT INTO guxg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ke li yogunu o gbaado bo siedi ki sua o gbanu kuli ŋanbi. ");
INSERT INTO guxg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ke Yesu maadi ke wan tuodi ki siedi li kani ki kpaa'o ");
INSERT INTO guxg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ki maadi: cuo a ñɔbu ki daa cedi oba n gbadi. Ama ŋan gedi ki pan waani sala yidikaaba. Ki tien'ba m ŋanbima paalu nani moyisi n bo bili maama ke lan tua bi sieda.» ");
INSERT INTO guxg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ama oja yeni n ñani ya yogu ke o kpaandi li maama kaan kuli. Lan po n bo cedi ke Yesu ji bo kam fidi kua u dogu nni ya yogu ke bi niba bo la'o. O bo yi ye u dogu kuni naan kan ki ñiana k ye. ");
INSERT INTO guxg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu bo tieni nani dana lie yeni ki guani Kaparnawomi dogu nni ke bi niba gbadi ke o ye deni. ");
INSERT INTO guxg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ke bi tigidi ki gbie deni ke finfanm ji t ye baa o diñɔbu kani. Ke yesu tundi 'ba u Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bi niba bo tugi o yiamo hali ke o Taana kuli kpe. ke bi cua yen'o Yesu kani ");
INSERT INTO guxg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bi niba bo yia i ke b kan fidi pundi yeni o yiamo Yesu kani Ama bi bo doni Yesu n ya dieli yuli po i ki cibi ki londi ki jiin'o Yesu kan ke dua li ganli po. ");
INSERT INTO guxg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu n bo la ke bi pia li dandanli yeni ke o bo yedi yua ya gbanu kpe yeni yeni ke: «n bijua a bàà a tuonbiadi sugili» ");
INSERT INTO guxg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ama li bali gbabanda dianba bo kaa li kani ki maadi bi pala nni ki tua: « ");
INSERT INTO guxg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Li tieni ledi ke o ne wan maadi nanda i? O sugidi u Tienu i ŋmaa ba fidi ki di o nisaalo tuonbiidi sugili li yaa tie u Tienu baba ya kaa. ");
INSERT INTO guxg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Li yogunu mɔno Yesu bo bandi b pala nni n maadi yaala. O bo yedi'ba be yaa po i ke i maali i pala nni n yeni? ");
INSERT INTO guxg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lan bona lie nni n diidi ya maama paa i? a bàà a tuonbiadi sugili fii taa a kakalugu ki ya cuoni. ");
INSERT INTO guxg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bandi mani ke o nilo bijua pia yiko ki tinga ne po ki baa fidi puni bi niba bi tuonbiadi sugili. O bo yedi o yiamo. ");
INSERT INTO guxg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Fii ki taa a donduanu bonla k ya kuni. ");
INSERT INTO guxg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Li yogunu o ja yeni bo fii ki taa o kakaligu ki pan caa. Ke bi niba kuli ji nua'o. Li bo lidi bi niba kuli ke bi ji yigini ki pagi u Tienu ki tua: tin daa kpeli ki la ya bonla ne buolu. ");
INSERT INTO guxg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu bo guani ñani ki gedi m ñinciama kunu ke u niwuulugu cua o kani ke tundi'ba. ");
INSERT INTO guxg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jesu bo cuoni o bo la Alife bijua Levi. O bo kaa lonpo diegu kani ke o maadi'o «ya ŋua'n» ke o bo fii ki ŋɔdi Yesu. ");
INSERT INTO guxg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Li ya puoli po Yesu bo kaa Levi deni ki baa je yeni t tuonbiadi danba yeni lonpo gaala yeni o ŋɔdikaaba. Li kani bi niba bo ŋɔdo ki yabidi ");
INSERT INTO guxg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","U Tienu tili banda yaaba bo tie gbanbanda n bo la ke Yesu jeni yeni a lonpogaala yeni t tuonbiadi danba yeni. Ke bi maadi o ŋɔdikaaba: laabaal ke o dini yeni a lonpogaala yeni t tuonbiadi danba. ");
INSERT INTO guxg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu bo gbadi ki maadi'ba: yaaba n pia laafia naa bua dogda se yaaba yia. Mii cua bua ya yi bi niŋanba kaa, n cua bua ya yi t tuonbiadi danba i. ");
INSERT INTO guxg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jan ŋɔdikaaba yeni falisiani -nba bo loli u ñɔbu i. Bi niba bo cua Yesu kani, ki yedi'o: Be tieni ke Jan ŋɔdikaaba yeni Falisiani -nba ŋɔdikaaba loli u ñɔbu i? Be tieni ke fini yeni a ŋɔdikaaba naa loli? ");
INSERT INTO guxg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu bo buali 'ba: yua ke bi yiin'o li puokuanli jaanma ba fidi ya kaa konma ya yognu ke o puocaano calo ye b kani i? hali bani baa ye yeni yo lan waagi maama kuli b kan loli ñɔbu. ");
INSERT INTO guxg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama adana cuoni ke bi ba ñani o puocaano Calo. Lan dana nni ke b baa loligi u ñɔbu. ");
INSERT INTO guxg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nilo baa kan taa li cabipanli ki ŋali ki tugini yeni li liadikpeli. A ya tieni n yeni li cabipanli ba dadi ki padi a cabikpeli. a cabipaana n mɔ tolitoli ki findi. ");
INSERT INTO guxg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nilo ba mɔ ka taa m daakaama ki tieni ñinbobikpeli nni kelima o ya tieni n yeni m daakaama baa mɔ ki pudi li ñinbobili. m daama yaa n ye li ñinbobili n gɔ biidi. Ama a ya tieni m daama li ñinbobipanli nni. ");
INSERT INTO guxg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Li bo tie saaba daali ke Jesu yeni o ŋɔdikaaba pendi u kuanu nni ki dogi i difiandi. ");
INSERT INTO guxg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Falisiani -nba bo yedi: «Diidi mani be tieni ke b tiendi yaala n kua m fuodima daali.» ");
INSERT INTO guxg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu bo guani ki yedi'ba: «Yii kpeli cogi Davidi n tieni yaala wan bo luo m jiema aa? ke m koma cuo'o wani yeni ya niba bo ye kuli. ");
INSERT INTO guxg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Li nan bo tieni ledi ke Davidi bo kua u Tienu diegu nni. ki taa sala ke wani yeni o ŋɔdikaaba ŋmani. Ama ke li nan bo cabi ke u Tienu sala yidikaa baba i n ŋmani li paanu. ");
INSERT INTO guxg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu bo yedi 'ba: «saaba ye bi niba po i; bi niba kaa ye saaba po. ");
INSERT INTO guxg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lani po n cedi ke saaba mɔno ye o nisaalo bijua nuugu nni. ");
INSERT INTO guxg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu bo guani kua jufi -nba tantandieli nni. O ja bo ke o nuugu kpe. ");
INSERT INTO guxg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yaaba bo ye li kani bo kpaag'o ki ba diidi Yesu ya baa paagi'o m fuodima daali. Ke ban jalig'o. ");
INSERT INTO guxg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu bo yedi o ja yua ya nuugu bo kpe yeni: «fii gi sedi t siiga nnni». ");
INSERT INTO guxg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lani ke Yesu yedi u niwuligu: «i tuo tin tieni li bonŋanla bii u bonbiigu bi niba fuodima daali gi gaa o miali bii ki ŋaa wan bode» ama b bo ŋmini suooo. ");
INSERT INTO guxg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu bo nuali'ba yeni li pabiili kelima b bo fiini b pala ke li juagi. Lani ke Yesu yedi o ja yeni «tandi a nuugu» ke o tandi o nuugu ke Yesu paag'o.» ");
INSERT INTO guxg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Li yogunu mɔno faalisiani -nba taani kali ki ji juogidi ban baa tieni maama ki cuo Yesu ki kpa'o. ");
INSERT INTO guxg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Li po ke Jesu yeni o ŋɔdikaaba gedi m ñinciama kunu. U niwuligu boncianla bo ñani Galile ye Jude ki ŋua 'o. ");
INSERT INTO guxg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jelusalemi dogu, Idume bii juudeni yaa kandima yeni ya diema kpia Tiir yeni sidɔn. Li niwulugu bo cuoni Yesi kani kelimaa bi bo bani wan suani yaali. ");
INSERT INTO guxg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","O yedi o ŋɔdikaaba ke ban kpaani u ñinbiagu ke wan kua, kelima u niwuligu baa mad'o ");
INSERT INTO guxg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wan bo paagi bi niba boncianli yeni, yaaba bo ye li kani kuli ki yia ji bo tudi bi lieba ki gba ban si'o. ");
INSERT INTO guxg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","T tagibiidi danba ya la'o ya yogunu kuli bi yio gbaani o nituali nni ki ya tandi: «ki tua a tie u Tienu bijua» ");
INSERT INTO guxg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ama o bo yi yie ki maadi ke ban daa cedi ban bandi wan tie yua. ");
INSERT INTO guxg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu bo doni li juali po ki yini wan bua yaaba ke bi cua o kani. ");
INSERT INTO guxg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","O bo lugidi piiga n nibilie ki yin'ba b tondiba. Ke bani n baa fidi ki ya ye yen'o, ke wan suan'ba ke ban ya caa ki wangi u Tienu ñɔmaama ");
INSERT INTO guxg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","O bo pun'ba u paalu ke ban ya diali k ñangi t tɔgbiidi. ");
INSERT INTO guxg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","wan bo yini niba piiga n bonbilie yaaba yela nne simɔni yua ke o bo pul'o Piali. ");
INSERT INTO guxg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saaki yen o yualo San Zebede bijaba. yaaba ke Yesu bo pul'ba. Boanɛr li niima n tie yua maadi nani i tatandi yeni. ");
INSERT INTO guxg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yeni Andre, Filipa, Bartelemi, Matio, Toma, Jak Alifebijua, Tadide Simɔ Zeloti. ");
INSERT INTO guxg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yeni Juda ISkariyoti yua bo t kuad'o. ");
INSERT INTO guxg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lan pugini waamu Jesu yeni o ŋɔdikaaba bo kuni denpo. Ke o niwulugu gɔ taani ban ye naani yeni ki yabi ke wani yeni o ŋɔdikaaaba t ki bàà yaama ki baa je. ");
INSERT INTO guxg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","K jesu niba bo gbia ke b maadi ke ban taa'o kelima b bo tua ke o yanma nni n biidi.» ");
INSERT INTO guxg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","U Tienu maama gbanbanda bo ñani Jerusalemi ki cua. b bo yedi «Belisebul yua tie o pola bado ke o kubi o ya paalu i ki bieli o pola» ");
INSERT INTO guxg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu bo yini'ba o kani kaalindima ki pua'bi m kpanjama: «Sitaani tieni ledi k guani beli sitaani i? ");
INSERT INTO guxg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ya dogu nni ke bi niba gɔ ki kɔni yeni bi lieba laa dogu kan fidi ya se ke li ŋani. ");
INSERT INTO guxg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ya diegu nni ke bi niba gɔ ki kɔni b ŋmiali nni li diegu kan fidi ya se ke li ŋani. ");
INSERT INTO guxg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Li tie ke sitaani ya guani kɔni yeni o bá li waani ke o paqalu bɔgidi n yeni, o kan fidi ye se o juodi n yeni. ");
INSERT INTO guxg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ama nilo ba kuli kan fidi kua o gbanmandaano deni ki fidi fie o piama. ");
INSERT INTO guxg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yesu bo yedi n baa maad'i i mɔnmɔni bi niba n tieni ya tuonbiidi bbi bàà sugili b tuonbiadi po, yeni ban sugi u Tienu ya sugidi. ");
INSERT INTO guxg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama yua sugi u Tienu fuoŋanba wani kan bàà sugili hali a bada. Ama lan daano kan fidi ya ye hali o hjuodima ki kan tieni tuonbiidi». ");
INSERT INTO guxg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu bo maadi li kuli ne agbanbanda kelimaa bi bo tua ke o pia o tɔgu biigu. ");
INSERT INTO guxg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","O naá yeni o waamu bo cua ki se cancanli ki sɔni o nilo ke wan yiin'o ");
INSERT INTO guxg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Li sua ke o niwuligu kaa ki lind'o. Oja den yedi a naá yeni a waamu kaa cancanli ki kpaani ŋa ");
INSERT INTO guxg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu bo ŋmiam' i ŋmaa tie n naá yeni n waamu. ");
INSERT INTO guxg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Lani ke o bo 35diidi yaaba kaa ki lindo yeni kuli ki yedi: n naá yeni n ninjanba n yeni. ");
INSERT INTO guxg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yua pia li dandanli n po ki tiedi n yanbuama lan nilo n tie n nijua yeni n nisalo yeni naá. ");
INSERT INTO guxg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu go bo ye yen'ba m ñinciama kunu ki bangib'ba. Ya niwuligu yabi bo kaani kim lind'o. O bo kua ki kali u ñibiagu nni m ñinma po. Uniwuligu kuli bo se li gbangbanli po i. ");
INSERT INTO guxg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O bo pua m kpanjama ki bangi'ba ya bona n yabi. Ki yed'ba m bangima yogu. ");
INSERT INTO guxg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","cengi mani o kpaalo n bo ñani ki bua yaa buu. ");
INSERT INTO guxg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ya yogu ke o buu bonbintiana bo baa u sankunu i. ke o bonyugida bo cua ki dini. ");
INSERT INTO guxg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","bonbintiana mɔ bo baa a tancagida po naan kani ke tanyoma ki ye. Li bo gbaa pani kelima li kani tandi ki ji. ");
INSERT INTO guxg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ama u yienu n bo doni li bo kuodi kelimaa li bo ki pani ki jiini mɔno. ");
INSERT INTO guxg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ya binbitiana mɔ bo baa t kunkondi ñaga yeni t kunkondi bo fii luoni ki laa fidi loni puu kuli. ");
INSERT INTO guxg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ya bonbitiana bo baa ki tinŋanga yeni bo pani ki kpedi ki loni. bonbitiana bo loni piina ki ya caa ke tiana mo loni piiluob, ke tiani mɔ loni kobiga. ");
INSERT INTO guxg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lani ke Yesu bo maadi: yua daani ki pia atuba ki baa gbadi wan gbadi.» ");
INSERT INTO guxg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesu n bo ye o baba o ŋɔdikaaba piig n bonbilie yeni bo nagini o kani ki bual'o o kpanjama yeni niima nni ");
INSERT INTO guxg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O Tienu n puni yinb'ba ke i bandi o diema nni tuonli, ama yaaba ji ye ne kuli li tie min ya puab'ba m kpanjama i. ");
INSERT INTO guxg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","lan yeni b baa nua yeni bi nnuni ama bi kan la puu kuli bi baa gba yeni bi tuba i, yeni ba gbaa yala. Ama bi kan cengi puu kuli. Lani n tie ban da lebidi ki guani u Tienu kanike wan tieni bi po sugili. ");
INSERT INTO guxg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu bo guani ki yedi'ba: i mɔ ki bani m kpanjama yeni bundimi yo oo? Li ya tie n yeni i baa tieni ledi ki fidi bandi ya kpanjama sieni i? ");
INSERT INTO guxg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","O kpaalo n pagi ya bonbii tie u Tienu maama i. ");
INSERT INTO guxg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bi nitiaba tie nani ya bonbii baa u sakunu yeni. Bi ya gbadi u Tienu maama ya yogu sitaani yi cua ki li yogu ki ñani li maama kuli b pala nni. ");
INSERT INTO guxg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bi nitianba mo tie nani ya bonbii baa a tancagida n yeni bi ya gbadi u Tienu maama ya yogu bi tuoi toma toma yeni lipamanli. ");
INSERT INTO guxg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama baa pia jiimɔni b pala nn i bi kan fidi juuni sedi u yebiadu ya cua, bii bi niba ya wangi'ba fala Yesu maama po toma toma se ban lebidi ki baa. ");
INSERT INTO guxg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bi nitianba mo tie nani ya bonbii n baa t konkondi nni bani mo tie yaaba n gbadi u Tienu maama i. ");
INSERT INTO guxg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ama n yema yanyandi yeni, ŋaimanbuadi, yeni bonbuakaatiana li kuli yi taani ki di o Tienu maama yeni li ji kan fidi sɔni tuonli. ");
INSERT INTO guxg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ama tianba mo tie nani ya bonbii n baa ki tinŋanga yeni, ban wani tie yaaba tuo u Tienu maama ki tuo ma ki luoni. bi nitianba loni bonbii yenli, piita taa, bitianba piiluoba luoba, b tianbi kobiga kobiga.» ");
INSERT INTO guxg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu bo guani yedi'ba: oba kan cuoni li fidilisanli ki cibini l bobli nni ki ŋɔgini li po. Bii ki gubini u gadogu nni. Bi yituani u tuntuankaanu i ");
INSERT INTO guxg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kelimaa li ba kuli k ye ki wuoni ke bi kan wuodi. lba kuli ki ye ki duagi ke b kan dɔgidi. ");
INSERT INTO guxg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O bo yedi 'ba: yi cuo i ba yeni yi gbadi ya maama. Yi gaa Tienu maama ki sɔni li tuonli maam, i paadi mɔ gɔ baa t dɔ n yeni ke li bonli gɔ pugidi. ");
INSERT INTO guxg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lani ya po bi ba pugini yua daani wan ŋanbi daani ama yua k daani b baa ñani wan pia yali. ");
INSERT INTO guxg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu go bo yedi: «U Tienu diema tie nana oo kpaalo n yi buli i bonbii ki tinga yeni. ");
INSERT INTO guxg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wan guani yeni wan nua u yienu yeni u ñiagu kuli, ya yogu kuli li bonbulikaala baa pa ki kpedi hali ŋanma ke waa bani lan maama ");
INSERT INTO guxg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ki tinga n yi cedi i bonbii nm pa. Li cili a kinkaga i ki tuani ti fiandi ki juodi m bonbinma ");
INSERT INTO guxg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","i bonbii ya beni ya yogu b baa taa o guadgu kelima li yogu pundi. ");
INSERT INTO guxg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu go bo yedi: t baa nangi u Tienu diema yeni be i. lilaa kpanjama ke ti bo yi pua ke m bundima ye i. ");
INSERT INTO guxg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","U Tienu diema tie nani ya kpintiigu ke b yi'u mutardi yeni bii li baa ñidi ki cie ŋanduna bonbii kuli. ");
INSERT INTO guxg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ama b ya buli ya yogu li paa t kpedi ki cie u gɔgidigu tiidi kuli gi go tɔ a bengbenga hali ke a bonyugida baadi tiendi b tedi li po. ");
INSERT INTO guxg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","O bo pua m kpanjama boncianli yaali naani yeni wan pua yaama. ki wangi bi niba o laabaaliŋanmo nani bani nbaa fidi ki ji gbadi maama ");
INSERT INTO guxg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","O bo maadi yen'ba kaa pua kpanjama. Ama wani yeni o ŋɔdikaaba yeni bo piadi ki ye b baba i. O yi bundi'ba li kuli. ");
INSERT INTO guxg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Li daali yenjuogu Yesu bo yedi: tin puodi mani ne po ya boanjali. ");
INSERT INTO guxg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lani ke o ŋɔdikaaba taa'o yeni ya ñinbiagu nni ke bi bo ye. ke bi kuli gedi ki ŋaa u niwulugu li kani. ke bi tɔbi mo ŋua'o yeni bi ñinbiadi ");
INSERT INTO guxg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ke u faabiadigu ti fii fiindi a ñinguona ke u ñinbiagu bua pan gbie. ");
INSERT INTO guxg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Le sua ke Yesu dua u ñinbiagu puoli po ki ki gɔ. Ke b fiin'o ki yed'o: canbáa ŋaa bani ke ti bua kpe yaa aa? ");
INSERT INTO guxg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O bo fii ki yie u faagu po yeni li bali ki maadi: «cedi fuugu» ke u faagu yeni m ñinciama kuli duani suoo. ");
INSERT INTO guxg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu bo guani yedi'ba: «be cedi ki jie n yeni? i ki dugi n po yaa aa» ");
INSERT INTO guxg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","T jiwaandi bo kua'ba boncianli. Ke bi ji maadi yeni bi lieba: O ne wani tie ŋmaa yo ke baa u faagu yeni m ñinciama kuli tuodi o maama i. ");
INSERT INTO guxg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","B bo pundi Galasenia diema yaaba kpenu jaali kani. ");
INSERT INTO guxg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu n bo ñani u ñinbiagu nni ya yogu. o tagibiigu n bo ye ya ja nni nbo ñani a kakula po, ki tuog'o. ");
INSERT INTO guxg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","O ja yeni bo li ye a kakula nni oba kuli bo kan fidi lol'o baa yeni i kudi seseli. ");
INSERT INTO guxg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","bi bo kpeli ki kpa kpaa ki loli o taana yeni i kuduseseli. O bo yi fidi ciecie li kuli ki dadi yaadi t kudi nilo ba kuli bo ki fid'o. ");
INSERT INTO guxg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ya yogu kuli, u yensiinu yeni u ñiagu o bo yi ye a kakula nni lini yaa kaa a juana po ki kuudi kaa suondi. ki jaagi wani o bá ya taana a tana ki duoli ");
INSERT INTO guxg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wan bo la Yesu hali fagima. o bo sani ki cua ki gbaani o nintuali nni. ");
INSERT INTO guxg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ki kpaandi ki maadi: «be n ye mini yeni fini siiga nni, Jesu u Tienu yua ye tanpolu bijua? U Tienu yeli po mia sugili k daa wangi'n fala. ");
INSERT INTO guxg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","O bo maadi yeni kelima o bo gbadi ke Yesu yedi: fini o tagibiigu ne ña o ja ne nni» ");
INSERT INTO guxg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu bo bual'o: «a yi ledi?» o bo ŋmian'o n yi niwuligu kelima t yabi. ");
INSERT INTO guxg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","O bo mia yesu ke wan daa beli'ba ki ñani'ba u dogu yeni tinga nni. ");
INSERT INTO guxg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Li bo sua ke i duoli ye li juali kani ki ŋmani ti muadi. ");
INSERT INTO guxg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bi bo mia Yesu ki maadi: A ya beli 'ti ŋan nan cedi tin ŋɔdi i duoli ");
INSERT INTO guxg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu bo cabi u sanu ke bani t tagibiidi yeni ñani o ja yen nni ki sani ki pan kua i duoli nni. ke li duoli kuli ñani li juali po ki sani sani ki pan mñinciam nni ki bia b kuli. b bo pundi duoli tuda lie. ");
INSERT INTO guxg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yaaba bo kpaa li duoli yeni bo sani ki pan waani li laabaalo a longbana nni yeni li dogu bila kuli nni. Bi niba boncianli bo ñani ki gedi ki pan diidi yaala tieni. ");
INSERT INTO guxg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bi bo pundi Jesu kani ki la ya ja bo pia u tagibiigu yeni ke o kaa ki ŋanbi lani ti tiadi ki kaa ke bonli ki pia'o ke t jiwaandi cuo'ba. ");
INSERT INTO guxg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yaaba bo la u tagibiigu n bo ye yua nni; bi bo togidi yaaba cua li kani lan tieni maama ke t tagibiidi ñani oja yeni kani ki kua i duoli nni ");
INSERT INTO guxg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","lan ya po ke bi bo mia Yesu ke wan ña bi tinga nni. ");
INSERT INTO guxg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu nbo bua kua u ñinbiagu ya yogu, t tagibiidi n bo ye yua yeni nni yeni bo mia ke wan cedi wan yegi yen'ba. ");
INSERT INTO guxg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama Yesu bo ki tuo. Ama li yogu o bo yed'o: «Ya kuni a deni po a buolu po ki pan waanb'ba u Tienu n tieni a po yaala kuli, yeni wan tieni a po ya niinm n gbadima ");
INSERT INTO guxg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O ja yeni bo gedi ki pan wangi dekapola dogunni Yesu n tieni o po ya tuonŋanma yeni ya ciila bonla n yabi maama ke o yaalidigu cuo'ba. ");
INSERT INTO guxg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu bo guani kua u ñibiagu ki guani puodi ki gedi ne po ya kpenpuoli jaali kani ya niwuligu n bo taani o kani bo yabi, ke o fii se m ñinciama kunu. ");
INSERT INTO guxg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ke juffi-nba tantaandieli nn canbáa yua ke b yi'o Sayirisi bo cua pundi Yesu kani ya yogu ki la'o yeni, o bo gbaani o taana kani. ");
INSERT INTO guxg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ki miad'o sugili hali boncianla ki yed'o ke o bisalo yia hali ki bua kpe. ke ŋan li cua ki ban maani a nuugu o po ke wan paagi ki ya ye. ");
INSERT INTO guxg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu n bo yegi ye'o ya niwuligu yabi bo ŋua ki miab'o ");
INSERT INTO guxg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","O pua mɔ bo ye li kani ke o sɔma ña hali piig n bina lie ");
INSERT INTO guxg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O bo la fala boncianli yeni ya dogidiena yabi kani, ki biani o piama kuli; ama yeni li kuli li bo tu; li bo li biagidi ki pugidi. ");
INSERT INTO guxg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","o bo gbadi ke b maadi Yesu maama, o bo nagini o puoli u niwuligu nni ki sii o tiadi. ");
INSERT INTO guxg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kelima o bo yedi o pali nni n ya fidi sii ba o tiadi baba n baa paagi. ");
INSERT INTO guxg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ya yogu ke o bo sii 'o o sɔma yeni kuli bo kama sedi ke o gbanu kuli paagi. ");
INSERT INTO guxg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","li yogunu mɔno Yesu bo bandi ke u paalu ñani o niini. O bo ŋmagidi ki buali u niwuligu ŋmaa sii n liadili? ");
INSERT INTO guxg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","O ŋɔdikaaba bo yed'o: a nua u niwuligu n miabi maama ke a nan gua yedi ŋmaa sii'n i? ");
INSERT INTO guxg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ama Yesu bo diidi b kaalindima kaa bandi yua tieni lan bonla. ");
INSERT INTO guxg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","O jawaanbu bo cuo o pua yeni ke o digibi kelima o bani yaala n tieni ninni. O bo gedi gbaani Yesu nintuali nni ki waan'o i mɔnmɔni kuli. ");
INSERT INTO guxg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","o bo yed'o n bisalo a dandanli n tieni a po yaali n ŋani. gedi yeni a yanduama a bàà laafia a yianu po. ");
INSERT INTO guxg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wan bo maadi yen'o ya yogu li bali maama bangima yudaani yeni bi niba bo ñani bi deno po, ki tuogi ki yed'o: A bisalo kpe'o be tieni ke a gɔ mabidi cabáa i? ");
INSERT INTO guxg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ama Yesu bo gbadi ban maadi yaalia; o bo yedi li bali maama dieli canbáa: ŋan daa jie daani n n baba ");
INSERT INTO guxg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","O bo tuo ki baa yegi yen'o. li ya tie piali Jaka yeni o waalo Jan ");
INSERT INTO guxg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ban bo pundi li bali maama bangima dieli Yesu bo la ya niwuligu n yabi, ke bi tianba buudi ke bi tɔbi tiendi u fuugu ki tandi yeni u paalu. ");
INSERT INTO guxg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wan bo kua u diegu yeni nni o bo yedi'ba: Be tieni ki buudi buudi ki gɔ tiendi tiendi u yaalidigu nanda i? i biga naa kpe kaa o gɔa yo. ");
INSERT INTO guxg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","o ñuad'o ama o bo ñani bi kuli cancanli ki i biga báa yeni o naá yeni wan bo yegi ya naataani yeni ki kua yen'bi ki biga n dua naan kani ");
INSERT INTO guxg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu bo cuo ki biga nuu i ki yed'o «talita kumi» li bua yedi ke: i jifanbiga n yedi ŋa fii. ");
INSERT INTO guxg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","li yogu mɔno ke i biga fii ki gɔ cuoni, kelima li jifanbiga bopia piiga n bina lie i. U yaalidigu bi cuo'ba boncianla. ");
INSERT INTO guxg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu bo ten'ba li lanbonli k ban daa maadi nilo ba kuli. O go bo yed'ba ke ban ten'o li bonjekaali ");
INSERT INTO guxg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu bo ñani li kani ki guani o maadogu nni. O ŋɔdikaaba n bo yegi yen'o. ");
INSERT INTO guxg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","M fuodima daali ke o pundi, o bo kua li bali maama bangima dieli nni ki bangi'ba. U Tienu maama niba boncianli bo cengi o maama ke li gɔ mangi'ba. B bo yedi «o ne mɔ bàà m yanbanma ne le yo oo? ŋmaa n ten'o ya yanfuoma na? «O tieni ledi ki fidi tieni ya banciama ne yeni o nuugu i? ");
INSERT INTO guxg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","li ki tie o kpagikpielo Mliyama bijua, yeni Jaka, Jose, Jude yeni Simoni kaa tie o waamu uu? O nisiaba gɔ ye ti sisiiga ne? Ban wani Jesu bo tie b yaa po biidi. ");
INSERT INTO guxg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu bo maadi yeni'ba: b kan fali sawalipualo yeli kaantianu se o danba dogu nni. yeni o niba siiga nni yeni o deni yaaba kani. ");
INSERT INTO guxg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Waa bo fidi tiendi banciamtiama, li yaa tie wan maani o nuugu yianbi ba ya po ki paagi 'ba. ");
INSERT INTO guxg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","b gaafaama bo lidi'o li po. Yesu bo caa a dogibila nni ki ban wangi'ba. ");
INSERT INTO guxg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu gɔ bo yini o piiga n niba lie yeni ki sɔni'ba niba lie lie; ki puni'ba u paalu k ban ya paani t tagibiidi ");
INSERT INTO guxg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","O gɔ bo maad'ba ke ban daa taa bonli ba bi taacenli po. I gbiamu baba ki daa taa jiedi, gi daa taa bɔgili yeni ya gbanñadu pia liiga. ");
INSERT INTO guxg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ama yi pili yi pia ya caacaadi g da taa liadi yenli baba. ");
INSERT INTO guxg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","O bo yedi'ba «Yi ya cani yua ya deni kuli yi ya ye lankani, hali yi pan siedi laa dogu nni. ");
INSERT INTO guxg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","B yaa tuo ki gaa i candigu gaa cengi i maama naankani, yin yi ña laa dogu nni ki piini i taaŋmaada ke la tieni sieda i po. ");
INSERT INTO guxg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bi bo ñani ki pan wangi buolu faagidi yen ti biidi tienima ");
INSERT INTO guxg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","B bo jaandi ki ñangidi t tagibiidi bi niba boncianla po, ki sɔgini m kpama yaaba yia po ke b paagidi. ");
INSERT INTO guxg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","O bado Herodi bo gaa li sawalo kelima Jesu yeli bo ñani kaankuli, nitianba bo tua: Janbatisi n guani ki fii bi tinkpiba siiga nni. Lani n cedi ke o pia u paalu ki suani ya yaalidigu bancianma ne. ");
INSERT INTO guxg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","b mo yi nmaadi ke «ke ELI YO» tianba mo n yedi li baa tie yoguba ya saawalipuala nikpela siiga nni yua bii? ");
INSERT INTO guxg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ama ya yogu ke Herodi bo cengi o maama o bo yedi: Li baa tie Jan min bo jia yua ya yuli yeni n fii bii? ");
INSERT INTO guxg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Li bo sua yogunu ba Herodi bo cuo Jan ki lol'oki luon'o li yonmdieli nni kelima o bo fie o waalo Filipa ya denpua ke o tua o ya pua yeni po. ");
INSERT INTO guxg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jan bo maadi Herodi: laa dagidi yeni ŋan kuani a waalo denpua. ");
INSERT INTO guxg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ama Herodisa pali bo biidi Jan po ke n bua ban kpa'o. Ama o bo kan fidi kpa'o. ");
INSERT INTO guxg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Wani Herodi bo jie Jan kelima o bani ke o tie ya nilo mɔni ki tiegi; kaa pia tagili ba kuli, o ya bo gbadi Jan tundi ya yogu o yama bo yi ŋmadi. Ama yeni li kuli o bo yi fidi cuo o ba ki ya ye yeni li pamanli. ");
INSERT INTO guxg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nani Herodi madijaanma daali n bo pundi. Ki cedi ke Herodiasi bàà u sanu ki ba tieni wan bua yaala. Herodi bo tieni t jaanjiedi ke li yabi ki yini a mintiela canbáa - nba, a mintielitɔtiebi liiga yaaba kuli yeni Galile dogu nni liig yaaba kuli. ");
INSERT INTO guxg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiasa bisalo bo kua bi niba yeni siiga nni ki jeli i ciagi ke li mangi Herodi yeni jaanma tantaani tieba kuli pala. O bado bo yedi: ŋan bua yaala kuli ŋan mia n baa teni ŋa. ");
INSERT INTO guxg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","O go bo poli ki yedi: ŋan mia yaala kuli n baa puni ŋa baa li ya tien dogu mɔno n baa bɔgidi ki teni ŋa. ");
INSERT INTO guxg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","O jifaano bo ñani ki pan buali o naá: a bua min pan mia'o be i? O naá bo maad'o ke Jan batisi yuli. ");
INSERT INTO guxg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Li yogu ke o jifaano guani hali o bado kani. ki mia'o ki yedi: n bua ŋan tieni Jan batisi yuli ki tadiga nni ki pun'n. ");
INSERT INTO guxg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","O bado pali bo biidi paaa ama nani wan bo poli yeni bi nitaaantieba n ye yeni o bo kan fidi yie ");
INSERT INTO guxg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lani ke o bado bo sɔni minteeli-nba canbáa yendo ya minteela n guu kan ke ban cua yeni Jan yuli na. Yaaba bo guu li yonmdieli kua ki cua jia li yuli ");
INSERT INTO guxg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","b bo kpieni li yuli yeni ki taditialigu nni ki cua yeli ki teni o jifaano, ke o jifaano mɔ ji teni o naá. ");
INSERT INTO guxg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jan ŋɔdikaaba n bo gbadi ke li tie yeni bi bo cua ki taa o gbannandi ki pan bili o tanlogu nni. ");
INSERT INTO guxg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesu tondiba bo guani ki taani o kani. B bo togidi ban bo tieni yaala yeni ban bo bangi bi niba yaala kuli. ");
INSERT INTO guxg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","O guani ki yedi'ba tin gedi mani n fanfama po bi niba n k yabi naan ki fuodi. Kelima ya niba bo kuni yeni yaaba bo cuoni kuli bo yabidi. b bo k bàà fuoma ki baa jiedi. ");
INSERT INTO guxg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Li po bi bo kua u ñinbiagu nni ki gedi pan ye b baba. ");
INSERT INTO guxg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama ban bo siedi ki caa i dogi nni niba boncianli bo bandi ban caa naani gi siani bi taana po ki baa gbaa pundi yemba. ");
INSERT INTO guxg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ban bo ñani u ñinbiagu nni Yesu bo la ke u niwuligu yabi paaa ke m niñinma cuo bi po kelima b bo tie nani ya pee k pia pekpaalo yeni. Li yogu o bo cili ki wangi'ba ya bona yabi. ");
INSERT INTO guxg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","U yienu n bo bua baa o ŋɔdikaaba bo nagin'o ki yedi: u yogu pendi o ne mɔ tie fuali nni ñianli k kɔbi. ");
INSERT INTO guxg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","cabi daa ke ban fidi yadi kua i dogbinmu nni ki baa yaala ke b baa je. ");
INSERT INTO guxg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","O bo ŋmia'ba ki yedi ba: Yinba mɔno n puni ba liba ban je. B bo maadi'o «a bua tin pan daa kuumukobilie ya paanu gi fidi dini ba? ");
INSERT INTO guxg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu bo yedi ba: yipia paanu bonjena bona ŋaa yo? Gedi mani ki pan diidi? Ban bo bandi yeni b bo yedi: paanu bonjena mu yeni jami lie. ");
INSERT INTO guxg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","O bo yedi ba ke ban cedi bi niba n kali cagili cagili t muasuandi po ");
INSERT INTO guxg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","B bo kali cagili cagili kobiga kobiga yeni piimu mu i. ");
INSERT INTO guxg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wani Yesu bo taa paanu bonjemuuda yeni jamilie yeni ki yaadi ki diidi tanoli po, ki jaandi u Tienu ki ŋmiidi ŋmiidi ki teni o ŋɔdikaaba ban bɔgidi u niwuligu. O gɔ bo bɔgidi b kuli i janliedi yeni. ");
INSERT INTO guxg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","B kuli bo dini hali ki pan guo. ");
INSERT INTO guxg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","B bo wodi wodi ban ŋmani ŋmani ki sieni ya paanu yoli yola yeni ya janjena ki gbieni piig nbaabuodilie ");
INSERT INTO guxg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yaaba bo ŋmani paanu yeni bo tie jaba tudamu. ");
INSERT INTO guxg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Li yogu Yesu bo fiini o ŋɔdikaaba ke b kua o ñinbiagu ki ga o liiga ki baa duugi ki gedi ne po ya bɔnpuoli Betisayi ya dogu po. hali baa ti cabi o niwuligu ");
INSERT INTO guxg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ban bo t yadi ki kuini o bo doni lijuali po ki pan bo jaandi. ");
INSERT INTO guxg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","U ñiagu n bo bua baa o ŋɔdikaaba bo ye u ñinbiagu nni hali m ñinciama siiga nni. ke Yesu li ye li jaali po o baba. ");
INSERT INTO guxg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Obo la ke b kudi u n ñinbiagu yeni fala kelima u faagu bo togid ba. Li bo bua pundi i kootonmuai fiindimna, Yesu bo cuoni u ñinbiagu po ki caa b kani ki bua balini ki pendi ba. ");
INSERT INTO guxg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ama ban bo la'o ya yogu ke u cuoni u ñingbani po b bo maali ke li tie yigini ke b yigini ");
INSERT INTO guxg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kelima b kuli bo la'o ke i jiejie bo kua'ba. Li yogunu mɔno Jesu bo maadi'ba: ki yedi ba: paagi mani i pala mini le ge. daa jie mani. ");
INSERT INTO guxg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","O bo kua ki taani yen ba u ñinbiagu nni ke faalu mɔ gɔ sedi. Li bo yaalidi'ba hali canyiin. ");
INSERT INTO guxg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","B bo k fidi bangi wan bo taa paanu bonjena mu ki mia u Tienu ki tieni maam, li niima nni kelima b pala bo jɔgini. ");
INSERT INTO guxg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ban bo dugi m ñinciama b bo pundi Senssareti ya tinga nni ki gɔ sieni u ñinbiagu ");
INSERT INTO guxg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ban ñani u ñinbiagu nni ya yogu bi niba bola'o ki band'o ");
INSERT INTO guxg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","B bo yadi a longbana nni ki siani taadi a yiama yeni b duanduankaadi, b bo tugi'ba ki caa yen'ba ban gbadi ke o ye naankan kuli ");
INSERT INTO guxg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wan bo gedi naankani kuli a longbana nni i dogciami nni, b bo yi taani a yiama ki cua yen ba bi niba n bo taandi bi lieba naani; ki ŋanbi mia'o ke wan cabi ba ban sii ba o tiadi kun po baba, yaaba kuli bo yi sii bo yi paagi. ");
INSERT INTO guxg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisiani -nba yeni li bali gbanbanda tianbi yaaba n ñani Jerusalemi bo taani ki cua Jesu kani. ");
INSERT INTO guxg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","B bo la bi ŋɔdikaaba ke bi tianbi dini yeni i nuujɔgidi bii kaa nidi. ");
INSERT INTO guxg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","L i bo tie ki faalisiani -nba yeni ban yi yaaba Jufiiba kuli kan dii kaa ŋanbi nidi. kelimaa b bo ŋua bi danba bogida i. ");
INSERT INTO guxg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Faalisiani -nba yua bo ñani li taanli ki kpeni o daa bo kan dii se wan gbagi ki m ñinma ki ŋanbi ki nidi ki ŋanbi o ba ki ñani li kuali. B bo kubi b danba bogida bontiana yaali n yabi, lan tie i tadiñukaamau, a cuana yeni t kudimɔndi tadimu, Osaadikaanu li kuli ya ŋuudima. ");
INSERT INTO guxg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Faalisiani -nba yeni li bali maama gbanbanda bo buali Jesu: li tieni ledi ke a ŋɔdikaaba wan ki kubi t nikpela kuana i? ki di yeni i nuujɔgina i? ");
INSERT INTO guxg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ama Jesu bo guani ki ŋmiani ba: Yinba pala lie danba Isayi bo tuodi ki waani ki saaawali yeni ke li tie mɔnmɔni. Ya niba nye naan ki jigindi nni yeni bu ñɔbu baba, ama b pala wani b fagi yeni nni. ");
INSERT INTO guxg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Baa jaandi nnii yeni mkpiagidi baa kuli bi niinn. B ŋaa ki bangi bi nisaliba n diani ya bali maama bangima baba. ");
INSERT INTO guxg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yi ŋaa u Tienu bali maama ki nan ŋua bi nisaliba ya jaama bogida ");
INSERT INTO guxg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","O gɔ bo yedi ba: yi li luni u Tienu maabilikaama canyiin. ki waa ŋua yala n tie o bogida. ");
INSERT INTO guxg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kelimaa Moyisi bo yedi: cɔlini a báa yeni a naáki yedi: fini yua maadi a báa bii a naá maabiigu a ba t kpe li po. ");
INSERT INTO guxg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama yinba wan yedi: ke nilo ya yedi o báa bii o naá ke wan bo bua todi'o yaala yeni tie ya paabi n dagidi yeni u Tienu i ");
INSERT INTO guxg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Li po i kan cab'o wan todi o báa lani yaa kaa o naá. ");
INSERT INTO guxg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lanwani yi piini u Tienu maabilikaama yeni i bogida yali ke i fuo lienn. i gɔ tiendi ya bona yabi ki naani yeni lani. ");
INSERT INTO guxg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesu gɔ bo yiini ya niwuligu n bo nagini o kani bo yedi: Yinba kuli n songi mani yeni niinn ki gɔ gbadi. ");
INSERT INTO guxg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","lba kuli ke ye o nifosaali niin po ki cua o niinn ki jɔgin'o. ");
INSERT INTO guxg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","B yanfuodanba n ŋanbi gaa yi naa diani biga. Yua pia a tuba ku baa songi wan songi. ");
INSERT INTO guxg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ya yogu ke Jesu bo siedi ki kua o deni nni. O ŋɔdikaaba bo bual'o laa maama bundima. ");
INSERT INTO guxg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu bo yedi ba. Yinba mɔ daa pia yanfuonma yo oo? yinba gi nua ke yaala kua kua o nilo niinni kan fidi ki biid'o ");
INSERT INTO guxg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kelima yaala kua bu ñɔbu nni nan kan jiidi kali o pali nni. ama li baa jiidi o tugu nni ki gedi pan ña o nigidi kaanu. Jesu bo yedi lan bonla ki waani ki jiema baa kuli kan jɔgini o nilo. ");
INSERT INTO guxg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","o go yedi ba: yaala n ña o nilo nni lani n jɔgid'o. ");
INSERT INTO guxg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kelima po nilo pal nni naa ti maalibiidi, lan tie m conconma buolu kuli u subu li nikpali ");
INSERT INTO guxg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","m conconma li ninponbiadili m biadima, i janbi i, m ŋalima. yi nanga, t tuonjɔgidi tiema, t japaadi, gi bua li kɔnli. ");
INSERT INTO guxg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lan bonbiadili buolu kuli ña o nisaalo nni. ki jɔgid'o. ");
INSERT INTO guxg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wan bo siedi li kani, o gɔ bo gedi ya dogi yi Tyli yeni Sidɔni ya tinmu nni. O bo cua o candiegu kaa bua nilo baa kuli n bandi ke o ye li kani. ama o bo fidi wuoni. ");
INSERT INTO guxg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","li yogu mɔno o pua yua ya bisalo ke t tagibiidi bo ŋua 'o yeni bo gbadi ke b maadi ke o ye. O bo cua ki gbaani Yesu taana po i ");
INSERT INTO guxg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Li pua bo ñani Fenesi Siiri dogu nni. o bo mia ke Yesu n beli ki ñani t tagibiidi o bisalo nni. ");
INSERT INTO guxg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","o bo yedi'o: tieni suo ki biga n dá di t jiedi o. Kelima laa ŋani ban taa ki biga jiema ki luni i sangbanli. ");
INSERT INTO guxg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ama o pua yeni bo guani ki jiin'o: ki yedi ya sangbanbila laabi u saajekaanu kani je a saajɔga i. ");
INSERT INTO guxg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","K e Yesu yedi'o: kelima ŋan maadi ya maama ne po fii ki kuni. ke i cicibiadiga ñani o niinni. ");
INSERT INTO guxg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","O pua yeni bo ñani ki kuni o deni po i. Ke o pan sua ke i cicibidiga yeni ñani o biga niinni ke o dua u duanu po. ");
INSERT INTO guxg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu bo fii Tiiri Tinga nni ki tɔgini Siddoni ki gɔ lindi ki tɔgini Dekapola diema n ki ñani ki pan caa Gaalile ñinciama po. ");
INSERT INTO guxg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bi niba bo cua yeni li tuukpaali o kani ke m maama paa o po. B bo mia ke wan maani o nuugi o po. ");
INSERT INTO guxg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","bo taa'o ki fagidi yen'o o niwuligu ki taa o nuubila ki tuuni o tuba nni ki gɔ taa o ñinsandi ki sii o lanbu po. ");
INSERT INTO guxg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lani o bo nuali tanpoli ki fuodi ki jiini ki yedi: «Efata» lani tie pigidi ");
INSERT INTO guxg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","lan yogunu li tuukpali tuba bo kpaadi u lanbu mo n tabidi wan ji ya maadi bonŋanla. ");
INSERT INTO guxg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu bo yedi ba ke ban daa maadi nilo ba lan bonla. Ama ke bi ŋanbi kpaandi ke bi niba gbadi wan tieni yaala. ");
INSERT INTO guxg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ke bi niba gbadi ke li yaalidi ba hali boncianla ke bi ji tua: o bontienkaala kuli ŋani. o cedi ke a tuukpaana gba ki a muula mo maadi. ");
INSERT INTO guxg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lani dana nni u niwuligu gɔ bo taani ki yaabi baa bo pia ban baa je yaala. Jesu bo yini o ŋɔdikaaba ki yedi ba: ");
INSERT INTO guxg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","U niwuligu ne bonli pia n po m ninñima, kelima dana taa n yeni ke bi ye yen'n, bi naa gɔ pia ban baa je yaala. ");
INSERT INTO guxg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","N ya baa ŋaa ba yeni m koma ke ban yaa kuni, bi baa cuagui u sani nni kelima tianba deni fagi. paaa ");
INSERT INTO guxg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","O ŋɔdikaaba bo ŋmia'o ki yedi: T baa fidi ki baa le ya fuali ne yaa paanu ke u niwuligu nee n di lan dagidi ba. ");
INSERT INTO guxg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu bo guani buali ba: paanu bona ŋaa yo ke i pia? bi bo guani ŋmia'o: paanu bona lele. ");
INSERT INTO guxg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bi bo cedi ke u niwuligu kali tinga nni. O bo taa o paanu leleda yeni ki yadi ki tieni u Tienu balga ki jendi jendi ki teni o ŋɔdikaaba ke ban bili bili u niwuligu kani, ke bi bo bili bili u niniwuligu nintuali nni. ");
INSERT INTO guxg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Janbimu ba mo bo ye waamu ke o gɔ bo tieni u Tienu baliga li mo ya po ki teni o ŋɔdikaaaba ke ban bɔgidi u niwuligu. ");
INSERT INTO guxg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bi kuli bo dini ki guo ke bi taani taani ban jeni ki iseni yaala ke li gbie baabuociandi lie. ");
INSERT INTO guxg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yesu n bo cabi yaa niba bo pundi jaba tuda na ");
INSERT INTO guxg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","li yogu mono wani yeni o ŋɔdikaaba bo fii kua u ñinbiagu i ki pan gedi hali Dalimanuta ya diema nni. ");
INSERT INTO guxg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Li ya puoli po Frisiani -nba bo cua ki bua bigin'o. ki maadi t bua ki mia ŋan tieni t po ciila yaala wani ke a ñani tanpoli po. ");
INSERT INTO guxg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ke Yessu fuodi jiini ki yedi ba: Be tieni ki mola niba kpaani ciila baba i? n maadi i mɔnmɔni bi kan tieni ciila ba mola bi niba po ");
INSERT INTO guxg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Li yogu mono Jesu bo siedi ŋaa ba. Ki kua o ñinbiagu yeni ki dugi kigedi ne po kpenpuoli. ");
INSERT INTO guxg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","O ŋɔdikaaba bo sundi kaa kubi paanu. baa bo pia jiema baa kuli u ñinbiagu nni, paanu yenli baba. ");
INSERT INTO guxg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu bo wuoni ba paanu yeni ki yedi ba: «cuo mani i ba ki lɔgidi Falisiani -nba yeni Herodi dabili. ");
INSERT INTO guxg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","o ŋɔdikaaba bo maali bi ŋmiali nni ki yedi: li tie tin k pia paanu yeni yaa po i. ");
INSERT INTO guxg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu bo bandi ki yedi ba: be yaa po i ke i maali nani yi ki pia kpanu yaa po i? Yi mo daa bandi lba yoo oo? yi daa gbadi yaa aa? Yi mo ya pala gɔ daa juagi. ");
INSERT INTO guxg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yi pia a nubina ki naa nua yo, yi pia a tuba k naa gba yo, nani yi tiani li ba ");
INSERT INTO guxg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","min bo taa paanu bona muu i ki jedi jedi ki bɔgidi bɔgi nitudimuudiba yeni, yin bo taani ya bonjena yeni bo gbie baabuodi ŋaa i? Bi bo guani yedi: «piigalie» ");
INSERT INTO guxg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Min go bo taa paanu bona lele ki jendi jendi ki bɔgidi niba tudana yeni, yi bo taani ya bonjena n sieni baabuodi ŋaa i? ");
INSERT INTO guxg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu bo yedi: yii go li kpaagi kaa bandi hali yeni mola? ");
INSERT INTO guxg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ban bo pundi Betasaida. Bi niba bo cua yeni o ja juamo Yesu kani ki mia ke wan sii'o. ");
INSERT INTO guxg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu bo cuo o juamo yeni o nnuugu ki dia'o ki pan ñan'o u dogu nni. Wan bo sii o nuni ki go maani o nuugi o po ya yogu o bo bual'o: «a nua bonli ba?» ");
INSERT INTO guxg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","O bo ligidi o nibina ki yedi: n nua bi niba ke bi tie nani i tiidi yeni ki cuoni. ");
INSERT INTO guxg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","O bo guani ki maani o nuugi o nini po, ke o ja yeni bo ligidi o nuni ki nuali ŋanma, ki ji la ke o nualicanyiin ");
INSERT INTO guxg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu bo cian'o bi deni po ki yedi'o: ŋan daa guani kua u dogu nni. ");
INSERT INTO guxg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu bo ñani yeni o ŋɔdikaaba ki pan caa Filipyeni Sesare dogibila nni. Ban bo ye u sanu nni o bo buali ba? Bi yedi ke n tie ŋmaa yo? ");
INSERT INTO guxg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bi bo guani yed'o «tianba Janbatisi» tianba «Elia» ke bi tianba mo tua «ke bi saawalipuaba siiga nni yendo n fii» ");
INSERT INTO guxg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ama o bo buali bani ke bi mo ji ye ke o tie ŋmaa yo? Piali bo ŋmiani: A tie u Tienu n gandi yua i. ");
INSERT INTO guxg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu bo kpaa ba li lanbonli ki yedi ba; yi cuo yi ba ki daa yedi nilo baa kuli kani min tie yua. ");
INSERT INTO guxg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu ji bo cili ki wangi ba ke li taladi o nilo bijua n la fala ke a nikpela yeni sala yidikaaba yudanba yeni li bali maama bangi kaaba gbanbanda n yie ki cedi ban kpaa'o. Ama dana taa daali o baa fii bi tinkpiba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O bo kadi wani ba canyiin Piali n bo taa'o ki jɔdi waamu ki fuu yen'o. ");
INSERT INTO guxg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ama Yesu bo guani o ŋɔdikaaba kani. O bo funi yeni Piali ki yedi: «sitaani ña n puoli po» kelima a yaa maalima nan k taa yeni u Tienu ya yaali. li ti nisaliba ya yaa me. ");
INSERT INTO guxg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu go bo yini u niwuligu ke bi nagini o kani ki taani yeni o ŋɔdikaaba ki yedi ba: Yua bua wan ya ŋua n kuli se li daano ni jiini o ba. Ki taa n daapɔnpɔnli ki bugi ki yaa ŋua ni. ");
INSERT INTO guxg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kelima yua n bua wan gaa o miali o baa buon'li. Ama yua mo baa puni o miali mini yeni n laabaaliŋanmo po o gua baa la 'li. ");
INSERT INTO guxg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","O nilo yua baa ki diedi ŋanduna kuli ke o naano nan bodi li baa todi a mo be? ");
INSERT INTO guxg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O nilo baa fidi puni be yo ki lebidi o miali? ");
INSERT INTO guxg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kelima yua jie n fe n po yeni n maama po bii naa niba, yaaba n conbi ki go tie t tuonbiidanba ye n siiga nni. O nilo bijua mo baa jie laa nilo po i fe, o ya t cua yeni o ba kpiagidi; ki ji yegi yeni maleki -nba yaaba n gagidi ŋani hali ya yogu. ");
INSERT INTO guxg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu go bo yedi ba: Hali n yedi i mɔnmɔni yiba yaaba yeni kuli. i siiga nni tianbi kan kpe kaa la u Tienu diema cua yeni u paalu ");
INSERT INTO guxg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","dana luoba n bo pundi, Jesu bo taa Piali Jaka yeni Jan wani yeni bani baba ke bi doni li juali yuli po ");
INSERT INTO guxg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","O tiayiekaadi bo pendi payi payi ki ñiligi boncianla hali hali ke nilo baa kuli kan fidi ŋuudi lan pendi yeni ");
INSERT INTO guxg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eli yeni Myisi bo cili ki dɔgidi bi kani ki cili ki maadi yeni Yeni Yesu. ");
INSERT INTO guxg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piali bo yedi Yesu: li baa ŋan tin ji ya ye ne. a yaa tuo t baa pua jodi taa; fini yenli Moyisi yenli Eli mɔ yenli. ");
INSERT INTO guxg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piali bo bani wan baa maadi yaali. kelima i jeje bo cuo ba. ");
INSERT INTO guxg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","U tawaligu bo cua ki libibni bi po ke u nialu maadi u tawaligu yeni «o ne n tie n bibuadiga ya cengi mani o» ");
INSERT INTO guxg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ya yogu ke o ŋɔdikaaba bo nuali ki lindo baa bo la ke nuli se se Jesu baba. ");
INSERT INTO guxg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ban bo ji li juali po Yesu bo maadi ba ke ban daa waani nilo ba kuli. ban la yaala hali yeni o nilo bijua n baa t fii bi tinkpiba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bi bo tieni wan yedi yaala ama bi bo nia yeni bi yaaba bi tinkpiba fii n tie yaala. ");
INSERT INTO guxg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bi bo buali Yesu? Li tieni ledi ke li bali maama gbanbanda wan naa maadi ke li tie Eli yo n gbaa cua. ");
INSERT INTO guxg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O bo guani maadi ba lan nan tie yeni ke Eli baa gba cua gi ŋanbi li bonli kuli. Ama li nan tieni ledi ke li diani ke o nilo bijua baa la fala boncianla nani yua k pia kpiagidi yeni? ");
INSERT INTO guxg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","N baa yedi ke Eli cua mono, ama bi sɔni o nani lan bo bua maama yeni, nani lan bo diani o po maama yeni. ");
INSERT INTO guxg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ban bo guani bi ŋɔdikalieba kani bi bo la u niwuligu ke bi yabi ki lindi ba ke li bali maama gbanbanda maadi yeni ba. ");
INSERT INTO guxg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ya yogu ke u niwuligu kuli bo la Yesu li yoginu li bo yaa lidi ba. ke bi ji siani ki caa o kani ki ji fuond'o ");
INSERT INTO guxg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu bo buali o ŋɔdikaaba ban bo pagi ya panpagu. ");
INSERT INTO guxg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","U niwuligu sinsiiga nni yendo bo guani yed'o: N bo cua yeni n biga a kani o pia u tagibiigu ke li mabid'o ke waa fidi maadi. ");
INSERT INTO guxg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Li ya fii o po li yi gul'o tinga nni. u ñinsankpankpangu n ya ña u ñɔbu nni ke o ŋmani a ñina. n bo mia a ŋɔdikaaba n dli ki ñani ga a niinni ke baa fidi. ");
INSERT INTO guxg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu bo guani kiyedi ba: yinba yaa niba k pia dandanli yeni; n gɔ baa ye yeni ya caa beyogu i; n gɔ ba bàà sugili yi po caa yeni be daali. cua mani yeni li biga. ");
INSERT INTO guxg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","K e bi cua yen'o Yesu kani. i cicibiadi n bo la Yesu yaa yogu ke bi fuuni i biga lun'o tinga nni ke t ñinsankpankpangu ña u ñɔbu nni. ");
INSERT INTO guxg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu bo buali ki biga báa: u laa yogunu yo ke li bonla cil'o. ke yi biga báa guani ŋmian'o hali o bon waama. ");
INSERT INTO guxg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","U yogu tianu li baa lu'o u muu nni yeni m ñinma nni ki ya bua buon'o. Li ya tie ke a baa fidi tieni bonli baa ki faaab'o ti po. ŋam gbadi ti po m niñinma ki todi tinba. ");
INSERT INTO guxg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu bo guani ki yedi: li ya tie ke a baa fidi libonli. Lanbonli tie faala yua pia li dandanli po. ");
INSERT INTO guxg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Li yogu ki biga baa bo kpaandi ki yedi. N pia li dandanli todi'n ke i dandanli n pugini. ");
INSERT INTO guxg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu n bo la ke bi niba siani ki taagi bi kani wan tandi yeni u paalu i cici biadi po ki maadi: fini u tagibiigu yua muugi ki wabini ne n yedi ŋa: ña ki biga ne nni ki daa faa guani o kani hali a bada. ");
INSERT INTO guxg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","U tagibiigu bo yigini ki digibi ki biga hali ŋanma ki ñani o niinni ki ŋa'o. ki biga bo dua ki naani nani yua kpe yeni. Ke u niwuligu siiga nni tianba bo maadi ke o kpe mɔno o. ");
INSERT INTO guxg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama Yesu bo cuo o nuugu ki fiin'o ke o jawaalo fii ki se. ");
INSERT INTO guxg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu n bo kua li dieli nni ya yogu yeni o ŋɔdikaaba baba, bi bo bual'o yeni u jiejiegu. «Be tieni ke tinba wani naa fidi beli ki ñani naa tagibiiga? ");
INSERT INTO guxg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O bo ŋmiani ba: ya tagibiiga ye ne kan tuo ña ke li yaa tie yeni jaandi yaa kaa. ");
INSERT INTO guxg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bi bo siedi li kani ki tɔgini ki ñani Galile. Yesu nan bo k bua bi niba n bandi ban ye naani ");
INSERT INTO guxg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kelima o bo wangi o ŋɔdikaaba ki yedi ba: bi baa janbi o nilo bijua ki ten'o bi nisaaliba nuugi nni ban kpa'o ama o kuuma dana taa daali o baa fii bi tinkpiba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","O ŋɔdikaaba bo k gbadi li maama niima nni. Ama bi bo jie yeni ban bual'o li po. ");
INSERT INTO guxg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ban bo pundi ya dogu ke bi yi Kapeenawomi. Yesu n bo ye deni yeni ba o bo buali ba? Yi bo nia bee u sanu nni? ");
INSERT INTO guxg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ama bi bo ŋmini silbi kelima u sanu nni bi bo nia yeni bi lieba. ke ban bandi yua baa tie liiga yua. ");
INSERT INTO guxg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Lanwani Yesu bo kali ki yini ban piiga n niba lie yeni ki maadi ba: Yua bua wan tua i liiga yua se wan tuo ke wani n njuodi yi siiga nni ki guani tuo ke o tie bi niba kuli naaciemo. ");
INSERT INTO guxg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Lanwani o bo taa ki bonñidiga ki sieni bi siiga nni, ki gua taa'o ki ŋmabi ki maadi ba: ");
INSERT INTO guxg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Yua tuo candi a bila ne siigi nni ba yendo kelima n ya yeli po o candi mine. yua n candi ni waa candi mini baba kaa o candi yua n sɔni n mɔ i. ");
INSERT INTO guxg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jan bo yedi «canbáa t la ja baa ne ke o beli ki yaandi o sanpola a yeli po ke t yie o po kelima waa ŋua ti. ");
INSERT INTO guxg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ama Yesu bo guani ki yed'o. Daa tiedi mani o po kelima nilo baa ki ye ki tieni yaalidigu tuonli n yeli po. ki gɔ guani ki maadi n po maabiigu. ");
INSERT INTO guxg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ki kɔni yeni t kuli tie t yua i. ");
INSERT INTO guxg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yua teni yi m ñinma kelima n yeli po kelima i ti Kirisi niba o luo o panpaani. ");
INSERT INTO guxg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ama yua ba tuulini ya bidi n daanni nni po ne ke baa yendo tudi u Tienu sɔnu li baa ŋani ki cie li daano ban lan'o li naali ki lu 'o m ñinciamanni. ");
INSERT INTO guxg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","A nuugu ya cedi ke a tie t tuonbiidi ŋan jia'o. Aya kua u Tienu deni ki pia nuuyendu ");
INSERT INTO guxg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Li baa ŋani a po ki cie yeni ŋan ya pia nuugi lie. ban lu ŋa u muubugu nni, ya muu kan gbidi nni. ");
INSERT INTO guxg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A taali mo ya cedi ke a tie t tuonbiidi ŋan jia'o. ");
INSERT INTO guxg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yua kua u Tienu deni ki pia taayenli li baa ŋani o po ki cie ŋan ya pia taana lie ban lu ŋa u muubuogu nni. ");
INSERT INTO guxg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A nuubila mo ya tie a po tingbali bonla ŋan lɔgidi ba. A ya pia nuubiyenli ki baa kua u Tienu deni li baa ŋani a po ki cie ŋan ya pia nuubila lie ban nan la ŋa u muubuogu nni. ");
INSERT INTO guxg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Naani ke a bonfuoda lugi yogu kuli k kan kpe yeni u muu n co naani k kan gbindinni. ");
INSERT INTO guxg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","O muu n baa tɔgini ki saali bi niba kuli naani nani n yaama yen. ");
INSERT INTO guxg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","M yaama mani ama o ya t luo u manu yi baa taa be yo ki gua mangi ma? Yaa ye mani ye i lieba yeni m yanduanma. ");
INSERT INTO guxg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu den siedi laa kaanu ki gadi Jude diena nni Jedena kpenu puoli po; bi niba gɔ den taani o kani kuli boncianla. O den tundiba nani wani n li maani ki tiendi maama. ");
INSERT INTO guxg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Falisi niba den cua o kani, bua dia u diagu yeni yaa baali n tie ne: «li cabi ke o ja n ñani o den pua?» ");
INSERT INTO guxg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ke o ŋmiaba. «Moyisi den maadi be li po?» ");
INSERT INTO guxg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ke bi yedi: «Moyisi den maadi ke o ja yeni n teni o pua yaa tili waani ke o ñani o ki cabi o.» ");
INSERT INTO guxg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Li den tie i kangbadima po i Ke Moyisi bili i po laa maama.» ");
INSERT INTO guxg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ama n cilima nni yogunu, U Tienu den tagi ja yeni o pua. ");
INSERT INTO guxg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","U Tienu den tagi ja yeni o pua. Li yaa po i, Ke o ja baa ña ki ŋa o na yeni o ba ki taani yeni o pua, ");
INSERT INTO guxg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ke ban taani ki tua gbannandi yendi, lanwani baa ji tie bilie kaa, bi ji tie yendo. ");
INSERT INTO guxg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yeni, U Tienu n taani yaala, nisaalo n daa paadi ");
INSERT INTO guxg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ban pundi deni, bi ŋɔdikaaba den buali o laa maama nima nni. ");
INSERT INTO guxg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ke o maadi ba ne: «yua ñani o pua ki gɔ ki taa potɔ tieni n conconma ki mani laa pua po. ");
INSERT INTO guxg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O pua mɔ yaa ñani ki ña o calo, ki kuni ja tɔ, tieni n conconma i ");
INSERT INTO guxg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lanwani bi niba den cuoni yeni o kani ab Yeni li mɔni n maadi i, ");
INSERT INTO guxg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","u baculi kan ba kua U Tienu diema ");
INSERT INTO guxg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Lanwani ke o gaa a bila o nuu nni ki maani o nuu bi po ki gaali bi ba ki yadi o yediŋanma bi po. ");
INSERT INTO guxg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesu den yedi o: «Be yaa po i ke a yeni nni mɔno? Nilo baa kuli ki ñani li yaa tie U T ");
INSERT INTO guxg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","18","wan den fii ki ba gadi liiga, ke o nilo sani ki cua o kani, ki gbaani o nintuali, ki bualo: «canba mɔno n baa tieni ledi ki baa ki kua U Tienu diema nni ki baa yaa miadi kan gbeni?» ");
INSERT INTO guxg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A bani U Tienu bali maama: “daa kpaa nilo, daa tiendi mi conconma, daa su, daa pua, i faama a lielo po, daa janmidi a lielo yen taani ki tiendi yaala, ke yaa cɔlini a ba yeni a na. ");
INSERT INTO guxg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ke o ja yeni: «canba, n cɔlini li kuli daa tie naciema i.» ");
INSERT INTO guxg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ke Jesu yedi o: «bonyenli n pɔdi a. Kuadi a piama kuli ki teni li ligi taliginba. Yeni, a baa baa ŋalmani tanpoli po ki ŋɔdi nni.» ");
INSERT INTO guxg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ama o pali den wadi yeni li maama ke o siedi ki ");
INSERT INTO guxg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu den nɔnli ki diidi o ŋɔdikaaba: «Li paa o piado po yeni wan laa U Tienu diema» ");
INSERT INTO guxg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ke li lidi o ŋɔdikaaba. Ke Jesu gɔ yedi ba! «N bila, U Tienu diema nni kuama paa hali boncianla!» ");
INSERT INTO guxg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Li paa o ŋalmandaano po ki cie u yodiyuogu n baa kua u kpalipiemu bonli nni. ");
INSERT INTO guxg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ke li liidi bi ŋɔdikaaba ke bi ji maadi yeni bi lieba. «ŋmaa n baa fidi ki baa mi faamima?» ");
INSERT INTO guxg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu den diidi ba ki yedi: «li paa o nilo po i ama laa paa U Tienu po kelima bonli kuli tie faala U Tienu kani.» ");
INSERT INTO guxg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ke Pieri ji cili ki maadi yeni o: «diidi tinba ti ŋaa tin pia yaala kuli ki ŋɔdi a.» ");
INSERT INTO guxg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ke Jesu yedi o: «N maadi yeni i mɔni yua ŋaa o deni; o ninjaba; o ninsiaba; o na nba; o ba nba; o bidi bii o tinga min yeni o labaaliŋama po. ");
INSERT INTO guxg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kan baa baliga mɔla ne li yaa pan tie li ŋanduni panli nni yaaka. ");
INSERT INTO guxg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ama yaaba n den liidi, bi tɔba baa juodi, ki yaaba n juodi n kua liiga. ");
INSERT INTO guxg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ban bo do Jelusalema, Ke Jesu kua liiga ke ti jawaandi kua yaaba n bo ŋɔa o puoli. Lanwani Jesu den paadi yeni o piiga n ŋɔdikaaliediba ki maadi ba yaala n cuoni o po. ");
INSERT INTO guxg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Cingi mani tin do Jelusalema ne, bi baa kuadi o nilo biga saligidanba yeni li balimaama danba po ke ban cagini o ki kpaga u ");
INSERT INTO guxg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bi baa laa u, ki cidi o po ti ñansɔndi o po ki piagi o yeni a gbana ki cedi ban kpaga u ama danataa daali i o ba fii.» ");
INSERT INTO guxg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jaka yeni San sebede bila bo nangini ki yedi: «canba, ti bua ŋa. Tieni ti po tin baa mia yaala kuli.» ");
INSERT INTO guxg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ke Jesu yedi ba: «i bua min tieni i po be?» ");
INSERT INTO guxg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ke bi maadi o: «cabi ti tin taani ki kali yeni a a kpiagidi nni yendo a jienu poo lielo a ganu po.» ");
INSERT INTO guxg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ama Jesu den guani ki jiini ba: «i bani yin miadi yaala, i baa fidi ki ñu fala baliga ñinma yaala ke n baa ñu, bii i baa fidi ki wuli fala ñinma yaala ke baa wuli i?» ");
INSERT INTO guxg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ke bi maadi o: «ti dagidi yeni tin fidi.» Ke Jesu maadi ba: «Fala bagili ñinma i baa fidi ki ñu ki bia wuli. ");
INSERT INTO guxg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama yaala n tie ki kali nujienu po bii nuganu po, la tie min kaa n teni i, ama li tie yaaba yapo ke lan kani den bogini.» ");
INSERT INTO guxg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bi ŋɔdikaaba piga n gbadi, ke bi pali biidi Jaka yeni san po. ");
INSERT INTO guxg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ke Jesu yini bi kuli o kani ki maadi: i bani ke ban nua yaaba ke bi tie i buoli liiga yaaba yeni bi maadi ba, ke o paalu danba mo die ba. ");
INSERT INTO guxg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama i yaa siiga, lan daa tie yeni. Yua n bua wan tua niciamo wan yaa tia i tuonsɔnlo. ");
INSERT INTO guxg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yua mɔ bua ki gaa liiga n tua i kuli yaa yonbo. ");
INSERT INTO guxg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","kelima o nisaalo bija ki cua ki bua ban yaa sɔni o po ka, ama ki wani mono n yaa suani tianba po, ki gɔ puni o miali ki kpe ki da ki faabi bi niba bonciala.» ");
INSERT INTO guxg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesu yeni u ŋɔdikaaba pundi Jeliko dogu nni. Ban ba ŋa Jeliko yeni o ŋɔdikaaba niba boncianla den ŋɔdi o, Batime bija, den tie juanmo ki ka o sankunu ki miadi. ");
INSERT INTO guxg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wan den gbadi ke Nasaleti Jesu kpendi u sani po, ke kpandi ki yigini: «Jesu, Davidi, bijua gbadi n po mi ninñima!» ");
INSERT INTO guxg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Niba boncianla den fu yeni o juanmo, ki maadi ke wan suoni. Ama ke o ŋanmi ki kpaandi ki pugini: «Davidi bijua, gbadi n o mi ninñiima.» ");
INSERT INTO guxg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu den gbagi ki sedi ki yedi ke ban cua yeni o. Ke bi yeni o juanmo yeni ki yedi o, paagi a pali: «Fii ki sedi! o yi ŋa» ");
INSERT INTO guxg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ke o taa o liadi cianla ki lunni, ki fii yenma ki cua Jesu kani. ");
INSERT INTO guxg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ke Jesu ŋmiani o ke yedi a bua mintieni a po be yo?» ke o juanmo yedi: «canba, n bua min guani ki nɔnli.» ");
INSERT INTO guxg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ke Jesu maadi o: «yaa caa, a dandanli paagi a.» Li yogunu mɔno ke o nɔnli ki ji ŋua Jesu. ");
INSERT INTO guxg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Didi kile ban den nagii Jedusalema; kipundi betifase ya dogu kunga yeni betani, olive ya jualipo, Jesu den sɔni o ŋaadikaaba. B ombilie. ");
INSERT INTO guxg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ki yediba: «gedimaniya dogbiga nye yiliga na. I ya baa kua lienni ya yogunu, yi baa la ŋunjapani ki nulo daa jago ki o luo. Yin lodo mani ki cuaniona. ");
INSERT INTO guxg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ya nilo n buali yii: be ya po i ki yi tie lani, yini ŋmiano, ti yombedano n pia o buama «O baa cabi yi cuani o n kani» ");
INSERT INTO guxg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Be den gedi ki ban la ki liŋunjapanli yeni ki o luo niipo o bulinaa jabukani yabu n ku yeni li sanja ciali. Ki be lodo. ");
INSERT INTO guxg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ya niba nn den yelikani be siigini tiabaa nn bualiba: Yi tie be lani ki na lodi liŋunjapanli. ");
INSERT INTO guxg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ki bi gua ki ŋmiamba nani Jesu n den yedibi maama. Ki bi niba yeni ŋaaba ki bi gedi. ");
INSERT INTO guxg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesu ŋaadikaliediba guaniyeni o ŋumbo o kanikita bi lidigbagida ki tieni ligali ki Jesu jagi o. ");
INSERT INTO guxg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bi niba bociaala den taadi bi tiayiekaadi yeni ya kaadi faadikin. Bi den cua i kuani nni ki tedi o sɔnɔnni. ");
INSERT INTO guxg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yaba den ye o liga yeni yaba den ŋaa o puoli den kpaadi kiyiniki tua: «Hosana! yombedano ŋanbili nn ya ye yeni yua nn cuoni a yel po. ");
INSERT INTO guxg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","O tienu ŋanbili n seligi ya bali ka dini na, tiyaja Dafidi den kpa ya bali nali nn ba ti kpiagidi nali tanpolijama!» ");
INSERT INTO guxg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu den pundi Jedusalema, ki kua lijandieli nni, ki diidi bolikuli ki gbeni li den sua ki o yeinu bua ki baa, ki o sua giki gedi betani yeni o pigaŋaadikaliedi. ");
INSERT INTO guxg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lan fii fandi ki o nani betani ki gaani, ki n koma cuo o. ");
INSERT INTO guxg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O den nua yali fagima ki bukankanbu se yeni o faadi, ki o gedi bu kani ki bani ki o ba la liba bu po o, ama wa den la liba kuli bu po ki la tie o faadi, kilima la den tie ya yogunu ki yi baa loni. ");
INSERT INTO guxg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ki Jesu maadi bu kankanbu: A ba kuli kango ŋmani a ya laana ki o ŋaadikaaba gbadi wan yendi yaala. ");
INSERT INTO guxg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ban den pundi Jedusalema, ki o kua li jandielin-ni ki deli nani yaaba n den kuadi yeni yaaba n den da kuli lienni. Ki tudi ki l ni yaaba lebidi iligii kpagidi yeni a kpjekuada bokalikaala. ");
INSERT INTO guxg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wa den ŋanilo o bakuliyuann denye lijandelinni ki kuadi kuadima kuli. ");
INSERT INTO guxg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesu den tundiba kiyediba kine: «lidiani kiyedi: n diegu kan ya tie ya diegu ki bi yigu o tienu jandi dielii niibuoli kulipo kaa? ama yimba wani, ta ki tieni a Nayiga yuonu kanu.» ");
INSERT INTO guxg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bisalayidikaciaba yundamba yen o tienu bali maama tundikaaba n den gbadi lani, bi ji den diidi ban ba tieni maama ki kpao. Kidungini, bi den jie o kilima bi niba bociaala pali den mangi o tunda po. ");
INSERT INTO guxg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Li dajoboanli, Jesu yeni o ŋaadikaaba den nani o dagu nni. ");
INSERT INTO guxg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lan den fi ki fa o tiŋaagu, bi den pa o sanu nni ki poa ki gaagi yeni bu kankanbu bi den laa ki bu kankanbu cuodi yeni o jiina kuli. ");
INSERT INTO guxg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pieli den tiadi Jesu n den yedi yal ki maadi: «Llabi, diba! bu kankanbu yuugu ka solo yeni cuodi.» ");
INSERT INTO guxg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu den ŋmiaba, «ya duu mani o tienu po. ");
INSERT INTO guxg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","N waani yi yeni e moani, yua n yedi lijaali ne: Fii ki ban baa minin ciaman nn, ka kubi maalimilie o palinni, ama ki duu wan yedi yala yeni o pali kuli li go ba tua yen n ne, kilima o tienu n ba tien nni. ");
INSERT INTO guxg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yene da, ki n maadi, yii jandi ki miadi yalikuli, ya dua mani ki yiiba likuli, ki li go baali tie yiiya yala. ");
INSERT INTO guxg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yin se ya yogunu ki jaandi, yi ya tiadi ŋa pia n maama yeni nulo kuli ŋa dii sugili o po, ki yi baa ya n ye tanpoli n puniyi mo sugili yituobiadi po. ");
INSERT INTO guxg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ama yi ya puni sugili yaaba n biidi po, yi baa yua n ye tanpolimo kan puni sugili yi biidi po. ");
INSERT INTO guxg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bi den pundi Jedusalema, Jesu n den goadi li jandidieli nni, bisalayidika aciaba. Bisalayidikaciaba, yeni o tienu bali maama tundikaaba, yeni a nikpela, den cua o kani. ");
INSERT INTO guxg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ki bualo: li laa bali ya po-i ki a tiendi ya boanla na? ŋme n puni ŋa li bali ka tiendi l? ");
INSERT INTO guxg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu den yedi ba: «n ba buali yi boyenla; yiya ŋmani nni n moko n ba waani yii ya bali yaapo ki n tiendi laa bonla. ");
INSERT INTO guxg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jan n den wuu binba o tienu nima yeni o tienu den puni o li bali bii. Bi niba den punio? ŋmiani mani. ");
INSERT INTO guxg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bi den juogi bi siiga ke yedi: ti yedi, ki o den baali tanpoli, o ba yedi tii. Be ya po i ki yii na den tuo ki ga o maama? ");
INSERT INTO guxg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ama ti go yedi, bi niba komi, bi den jie bi niba yaba den tigidi yeni, kilima bi niba kuli den tua ki jan tie yua n songidi o tienu maama. ");
INSERT INTO guxg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ki bi ŋmiani Jesu ki yedi: «tii bani.» ki Jesu ma maadiba: «n mako n kan wani i yi yua n yua n puni nni laa bali ki n tiendi laa bonla.» ");
INSERT INTO guxg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Liya puoli Jesu den tundi ba ki pua n kpanjama. Ki maadi: «o nilo den ŋu o damongu tiidi kuanu, ki kpaaki gogidi lindi o k kuanu, ki gbiidi o. Buogu naani kibi ba ŋanbidi o damongu. Ki go maa lidieli ki tienili pagiliki guuni bi niba, ki fii ki gedi o sonu. ");
INSERT INTO guxg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","O yogunu pundi, ki o soani o tuosoanlo yendo bi kuaguba kani kiwan ga o tiidi luana. ");
INSERT INTO guxg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ki bi kuaguba cuo ki pua o ki lebino famma. ");
INSERT INTO guxg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ki o go soani o lielo ki bi pua o yal ki padi o yuli ki go fiago. ");
INSERT INTO guxg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ki o go soani o tiana ki bi cuo ki kpa o. Li ya puolipo bi soani n nacintaba nani bi kpiaba bi pua bi ne ki kpa bi tianba nani ban den kpia tieni cincinli yaba maama. ");
INSERT INTO guxg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","O kuadano go da den sieni ni yendo ki ba saani o, wani den tie o biga yua ki o bua o yali boŋanla. Wani n den tie wan juodi ki soani yuo. O den yedi diidi o tie n biga bi ba conlino. ");
INSERT INTO guxg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ama bi kuagaba den juogibi ŋmioli nni ki yedi: One wani n ba diedi li faali cuamani, tin kpao ki diedi li faali. ");
INSERT INTO guxg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ki bi cego, ki kpao ki luno o kuanu kunu. ");
INSERT INTO guxg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Moanla, o koandano mo baa tieni lede yeni o koanu? o baa cua ki deli yanni bi koanguba ki biambi kuli ki ta o koanu ki guuni tiamba. ");
INSERT INTO guxg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ida bani ki cogi ya diani n tie na bi? Li tanli yal ki atamaala den luni laa tanli nn tua lidieli tanpuli. ");
INSERT INTO guxg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lni ya bonla den nani o tienu kani ki ŋani ki dagidi bi niba po. ");
INSERT INTO guxg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bi denbigidi ban cuo Jesu ama bi den jie o niyuligu kilima bi baniki o den maadi laa. Maama kilima bani. Lan yaani ban siedi ki ŋao. ");
INSERT INTO guxg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lani n pendi bi den soani Jesu kani faliseninba yeni o bado clodo buakaaba bi tianba ki ban diao o maadiagu ki cuo o yeni bi maaman ni. ");
INSERT INTO guxg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bi den cua ki yedio: «canbaa ti baniki a tie maamaani daano ŋaa jie nba kuli, ŋaa gagidi o ba kilima bi niba n nua ki o tie maama po, u tundi bi niba o tienu. Sanŋoandima yeni i moamoani mo. Li pia o sanu ki tin pa lonpo o badieciano sesa? tin pabi, tin da pa i? ");
INSERT INTO guxg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ama Jesu n den bani bi yubontuona po yeni ki o maadi: «be yaapoi ki yiibigidini ki bua ki cuo nni? cuanimani lidibalina mi diidi.» ");
INSERT INTO guxg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kibi cuani Jesu po dibayenli. Ki maadi ba: «ŋma yeli yeni ŋma ya namangun ye lipo? ");
INSERT INTO guxg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ki Jesu maadi: «yim teni mani sesa wan n die yal ki teni o tienu mo o tienu n die yal.» ki li ya kilidiba yeni wan yedi yaala. ");
INSERT INTO guxg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadisaniba yab den ki tuo bi kpienba yiedimapo, den kua Jesu kani. ki buab: ");
INSERT INTO guxg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Camba, Moisi den diani ti po, li ya sua ka ninjua kpe ki ŋa o denpua. Ki o na malo biga, a ba Fiidi ki ta o denpua ki mali o po ti bidi. ");
INSERT INTO guxg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jabalele den ye, o nikpelo po den kuani o pua, ki kpe ka mali biga. ");
INSERT INTO guxg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","KI yua tua o po mota o pua yeni ki mo kpe ka mali biga. Li go den tua yene o talo moya po. ");
INSERT INTO guxg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bani bombalele yeni kuli den tao Ama o ba kuli yakani wa den sieni buolu, o pua yeni mo den kpe. ");
INSERT INTO guxg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bi kpieba yiedima, bi kuli ya ti guaniki ba lmiali, ŋma ba diedi o pua? kilima bani jabalele yeni kuli kuano. ");
INSERT INTO guxg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu den guani ki yediba: «Laatie ipo moamoani ki bi kpieba yiedima po tie yala ki yii tudi, kilima yi bani i diani yedi yala, bi o tienu palu n doa maam n m? ");
INSERT INTO guxg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kilima, ya yogunu kibiti fii bi kpieba siiga, bi kankuani puoba, bi go kan punibi yuli lipokuali po, ama bi kuli ba ya tie nani malekinba yeni tanpoli diema nni. ");
INSERT INTO guxg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ama yala n nua bi kpienba yiedima po, i daa kpa ki cuogi Muiisi tili, naani n togidi o tisogu kani ya maama, o tienu n den maadi yeno ki yedo yala: Mini n tie Ablahama tienu, Isaka tienu, Jakoabo tienu? ");
INSERT INTO guxg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wa tie a kpiema tienu ka o tie yaaba foya tienu yo. Yi tudi bon cianla. ");
INSERT INTO guxg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lbalimaama tundikaaba yendo den gbadi ban nia yala; o den la ki Jesu jiino hali boŋanla. Ki o bualo: «Libalimaama kuli nni, mile n tie li mayuli?» ");
INSERT INTO guxg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu den goa ki yedo: «Limaayulitie mine, Isalele yaaba ti yombidano o bado o tienu tie yendo. ");
INSERT INTO guxg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A ba buo a yombidano a tienu yeni apali kuli, yeni a naano kuli, yen a maalima kuli, yeni a paalu kuli. ");
INSERT INTO guxg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Diidi o bonlielo jua n tua nne: Abaa bua a lielo nani fini a ba yeni laa pia kuliya maama n cie libalimaama nni maani. ");
INSERT INTO guxg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ki lo maado: «Liŋani, camba! a maadi i moni ki o tienu tie yendo tienu ba kuli ki ye kaa tie wani. ");
INSERT INTO guxg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","O nilo n bua wani yeni o pali kuli, yeni o jantial kuli, yeni o paalu kuli, ki go bua anisaalilielo nani fini ŋa bua a yuli maama yeni, lani n cie padi ya padijukana yeni ya sala ki bi yiidi kuli.» ");
INSERT INTO guxg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu n din la ki o giino ya giini n dagidi yeni nn yanfuoma, ki o yedo: «ŋa fagi yeni o tienu diema.» lani ya po n pendi, nilo jiki tuo ki buali Jesu buali. ");
INSERT INTO guxg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu n den tundi bi niba o jan diegu nni, o den buali: «Litien nni lede ki sikilibi nnba maadi ki klisiti tie Dafiti bijua? ");
INSERT INTO guxg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dafiti wani o ba den gbie yeni o tienu fuonna yua ki yedi: «Yombidano maadi n yombidano, kali nugienu po min kedi ŋa ŋma a nananda ting po.» ");
INSERT INTO guxg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dafidi mono den yii u «o yombidano», yeni li ba tieni lede o ga ka n tua Dafidi ya biga? ya nicianba n den taani kuli den gbadi wa maadi yal. ");
INSERT INTO guxg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu tunda nni, o den wani ki ban fangi bi yula yeni yaaba tundi o tienu maama ki bua ban ya goadi yeni a liadiciama, ki go bua bi niba n ya fuondiba ki kpiagidi ba i daamu nni. ");
INSERT INTO guxg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bi go bua liga kali kali a jandidiena nni yeni janciamma kani kuli. ");
INSERT INTO guxg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ki nan janbidi a kpepuona ki fiedi bi diedi ki jandi ya jandi. N faagi ki bua bi niba nn ya nua ba bi ya buudi ba yabiakicie. ");
INSERT INTO guxg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu den ka o tienu dieli nni ki tuoli iligitadiga ki nua bi niba n kpiedi i ligi maama. A piada den kpiendi i ligitadiga ki nua bi niba n kpiedi i ligi maama. A piada den kpiendi i ligi ki li yaba. ");
INSERT INTO guxg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","O kpepuoluolo mo den cuan ki kpieni suulo lie. ");
INSERT INTO guxg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesu den yini o ŋaadikaaba ki yedi ba: «n maadi i monmoni, o kpepuoluodo na puni ki cie yaaba n kpieni i ligi i ligita diga nni kuli.» ");
INSERT INTO guxg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kilima bani wani kuli kpieni bi ŋalimano nni bi ligi bidi, ama wani, yeni o luoma kuli o nani wan pia yaala ki baa je kuli, kikpieni. ");
INSERT INTO guxg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu n den ña o jandiegunni ya yogunu, o ŋoadikoaba siiga yendo den maadi o: «camba didi a tana na diegu n ŋani maama!» ki o maadi: ");
INSERT INTO guxg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","«Jesu den yedi o: A laa ya tanciama naa? bi kon tiŋa ba tanyenli n sieni ki ya maa lilieli po ki a kuli kan padi ki baa.» ");
INSERT INTO guxg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesu den kali difie tiidi juali po ki tuoli o jandidiega, pieli, jaka, jan yeni ŋandili den buali o ya buali na bi bebe kanu. ");
INSERT INTO guxg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Waani ti laa bonla n ba ti cuaya yogunu? be ya nanangu n ba waani ki laa bonli kuli baa tieni? ");
INSERT INTO guxg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Lani Jesu den yedi ba: Cuo mani yi yula ki niloba n da ti boundi yi. ");
INSERT INTO guxg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Biniba boncianlaa baa ti cua n ya yeli p ki yedi: mini n tie kisiti. Ki boandi bi niba boncianla. ");
INSERT INTO guxg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yiya tigbadi ki bi maadi o toabu maama ki go togidi yi o toabu laabaalo, yin da yanginni mani yi yama, laa bonla kuli ba tieni ama li da kan cua nn juodima ka. ");
INSERT INTO guxg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kilima buolu baa ti fii ki tuogi buolu tianu. Diema mo n fii ki tuogi dietianma, n tindigima baa tieni yi kani boncianla, yeni n koncianma mo baa tieni. Laa bonla kuli daa tie nani o maditugukoanu yeni ");
INSERT INTO guxg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yin ŋambi ki ya ban iiya yulipo ne, bi baa cuo ki gedini yibi bujiaba kani ki cabi ban pua yii a jandiena nni. Bigo baa gedini yi bi dogidamba yeni bi batieba kani nn ya po. ");
INSERT INTO guxg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ama bali ki juodima daa cua, li tie tiladi ki o tienu maama n kpa pundi i nibuoli kuli kani. ");
INSERT INTO guxg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bi yati cuo ki gedini yi ti buudi damba kani ya yogunu, yin da yangi nni yi yama yeniyinba maadi yala. Kilima liyogu monlo, o tienu fuoŋama ba songi nni yi yin baa maadi yaala. ");
INSERT INTO guxg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kpelo yeni o waalo siga nni yendo ba cuo o lielo ki cabi ban kpa o, bibaanba ba cuo bi bila ki cabi ban kpa a bila mo ba fii ki sedi bi danba po. ");
INSERT INTO guxg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bi niba kuli baa nani yikilima po. Ama yuu n se kilipa kuli bali yeni n juodima kuli, baa ba n tindima. ");
INSERT INTO guxg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yiya ti laa ki ti cangindi bonla ki li wudi bi niba gbanu ki ye ti kaa bi ye naakani yua n cogini o tienu maama kuli n diidi o yulipo. Ki yaba ye yude kuli sani ki gedi a juana po. ");
INSERT INTO guxg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yua n ka o diegu yulipo n da jiidi ki kua deenni ko baa taa liba. ");
INSERT INTO guxg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yua n ye o kuanu mo da lebidi ki kun ni o den po ki baan taa o tiaykaadi. ");
INSERT INTO guxg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Fala baa ye yeni ya puoba n punbi yeni yaaba n da ŋaandi a bila laa dana nni. ");
INSERT INTO guxg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mia mani o tienu ke laa noama dana nni n tua fawaagu yogunu. ");
INSERT INTO guxg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kelema laa dana nni fala baa ye bali boncianla, maama ki li fala. Buolu daa baa tien, halin n cilima o tienu n den tagi ŋanduna ya yogunu kita pundi hali moala, o buolu kan go tienimo. ");
INSERT INTO guxg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","O Bado o tienu ya bi wadi laadana, niloba kuli kan bi sieni. Ama yeni wan luogidi o buolu siiga yaaba ya po, o ba wadi laa dana. ");
INSERT INTO guxg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Laa yogunu, nilo ya yedi yi: Diidi o tienu n gandi yua ye ne! bi o ye Nepo yinda pia dandanli o maama po. ");
INSERT INTO guxg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kilima tuonanda n yedi ki bi tie o tienu n soniyaaba yeni bi songikaa. Faadanba baa fii ki ya tiendi banma kili tie bonlidikaala hali ke liya baa fidi bi baa boandi o tienu n gandi yaaba. ");
INSERT INTO guxg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yin kubimani yi yula! n tuodi ki waaniyi li kulio. ");
INSERT INTO guxg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ama laa dana nni fala yeniya pendi, o yienu baa biigi, o ŋmaalo nno kan go yayieni. ");
INSERT INTO guxg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A ŋmabila ba na tanpoli ki boali, tanpoli paali kuli mo baa digibi. ");
INSERT INTO guxg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lawanibiba la ke o ja bigua yeti tawaligbandi nni, ki kpendi yeni o paacianu yenu o kpiagidi. ");
INSERT INTO guxg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yeni o baa saani o malekinba ŋanduna kuli nni, ban tani wan gandi yaaba ki cili ŋanduna bianu kiya caa hali o guoga. ");
INSERT INTO guxg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yin diidi mani o kankanbu kanjaman n waniyi yaala. O bena ya bundi, yibani ke o siagu nagidi. ");
INSERT INTO guxg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Li go tie yene i yatila laa bona tiendi, yin bandi ki o ja bijua nagini o buliñoabu kani. ");
INSERT INTO guxg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","N wani yi imoamoani ke n naa nifiima kuli kan pendi kelaa bonla kuliki tieni. ");
INSERT INTO guxg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tanpoli yeni tinga kuli baa pendi, ama n maama kan pendi ba ya yogu. ");
INSERT INTO guxg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ama yaala n tie li daali yeni o yogu, o ba kuli ki bani, baa malekinba mono yaaba nye tanpoli, baa o bijua mono, ama ba bebe bani. ");
INSERT INTO guxg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yin ŋanbi ke diidil kiya se kilipa kilima yiibani ya yogunu kilitie. ");
INSERT INTO guxg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Li naani nani o nilo den bua ke gedi o saNu ki taa o deni ki guuni o tuo. Soanba, ki wani yua kuli yeni o tuoli. Ki cabi yua baa gu nba, n ŋanbi ki ya nua ba. ");
INSERT INTO guxg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lanwani yin ŋanbi keyese, kilima yi bani canba n baa kpeni ya yogu, li baa tie ñiagu, o yoagisigu, kotonmuoanga, bii siŋaagu. ");
INSERT INTO guxg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","O ya ti li pundi ya yogunu kuli, wan dan cua ke yi dua ki goa. ");
INSERT INTO guxg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Min n maadi yi yaala, n maadi yua kuli, n ya se kilipa. ");
INSERT INTO guxg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paki juanma yaama n ki den ŋmadi yen dabinlin densieni dna lie saloyidikacianba yudanba yen u tienu maama g banbanda den kpaani yaa snu kibbaa jnbi Jesu ki cuo o k kpa o. ");
INSERT INTO guxg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bi den maadi yeni bi lieba: «lan tie mi jaanma yogunu, b den jie k biniba n dti fii yeni ku fuugu ki yie li po» ");
INSERT INTO guxg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yaa yogunu ke Jesu den ye o gbaado simono deni, ban den di yaa yogunu, o pua den kua ki kubi omuu nni yaa bada ki biyiga alibate ke ki gbie yeni tulate, ke o dunga pa, ke bi yionadiŋama. O denjobidi libadiga ki wuli o yuli po. ");
INSERT INTO guxg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Li den coagi bi tianba ke bi maadi biŋnniali nni, ki tua: «be yaa po yo ke o biidi yaa tulale n yena. ");
INSERT INTO guxg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bi bibaa fidi ki kuudo yaa ligi n cie dubala kobita ki teni aluoda» Ke bi funi yeno lipo. ");
INSERT INTO guxg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama Jesu den yedi: «ŋao mani yeni sua be yaa po yo ke yi biidi opali? o tieni n yaa po bonŋanle. ");
INSERT INTO guxg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yi pia a luoda yi siiga nni yaa yoginu kul yeni yin bua yaa yoginu kuli yi baa fidi ki tieni ba miŋanma, ama mini wani yi kan yaa pianni yaa yoginu kuliyi kan. ");
INSERT INTO guxg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wan wani tieni wan ba fidi ki tien yaala a wuli o wuli n gbanandi po kelima n piinma po. ");
INSERT INTO guxg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Moamoan i maadi yi; ban baa waani o labaalinŋamo ŋanduna nni naan kani kuli bi baa tiadi ki togidi o pua nan tieni n po yaala» ");
INSERT INTO guxg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","K sua juda Isakalielo bi piiga nni kediba siiga yua den gedibi sala yidi kacianba kani kelima o den bua ki kuado bi po. ");
INSERT INTO guxg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bi salayidi-ka cianba n den gbadi laa maama yaa yoginu, bi pala den mangi ki bi den jagi ban baa puna yaaligi, o den kpaan wan baa ba yaa sanu ki kuado bi po. ");
INSERT INTO guxg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","li dancincinli daali yaa paano n ki den ŋmadi yeni dabinli, ban yen taki pebiga ki yidi sala paki jaajiema po den bualo: «abua tin gedi le ki ban bobini a po paki jiema ŋan di.» ");
INSERT INTO guxg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","O den soani o goadi kaaba siiganni bonbi lie, ki yedi ba: «yin gedi u dociannu nni yi baa la o ja ke o bagi linin cuali yin ŋoado man. ");
INSERT INTO guxg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wan baan kua yaa diegu nni ŋoado mani ki maadi yeni laa diegu daano, canba buali: «min le yaa diel, ke n ba je paki jiema yeni n ŋaadikaaba. ");
INSERT INTO guxg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yeni o ba waani yi li die tual yaali n yabi ki ŋani, yin bobi nni man n po lan kani. ");
INSERT INTO guxg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","bi ŋaadi kaaba den fii kua u dogunni bi den la ke lali bonla kuli tie nani wan den maadi ba maama kebi bobini o po paki jiema. ");
INSERT INTO guxg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kuyen juogu n den pundi, o den cuu yeni o piiga n ŋoaka lie diba li kani. ");
INSERT INTO guxg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ban den taani ki kali mi jiema kaanu ki di, ke Jesu yedi; «i mamoani n waani yi, yi siiga yendo yua n taani ki di l yeni nni baa janbi nni» ");
INSERT INTO guxg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bi kuli yaa yama den ŋmadi yeni bi siiga yua k uli ji den cili ki bualu laa tie mini bi yeni kaa? ");
INSERT INTO guxg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu den yediba: «li tie yinba bi piiga nni liedi ba siija yendo yua taani ki tuuni yeni nni kusatiagunni. ");
INSERT INTO guxg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kelima o ni saalo biga baa siedi ŋanduna niinni nani landiani o po diani maama ama li yuboanli baa ye yeni yaa daan o nba janbi o ni saalo biga libi ŋani lan daano bi yaa bimalo.» ");
INSERT INTO guxg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ban den di yaa yaa yogunu, Jesu den ta paana, ki tieni u tienu baliga, ki jenda. Ki tenba ki nnaadi: «yin ga nnan ne, li tie n gbanandi.» ");
INSERT INTO guxg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","o go denta ki tadi nukaaga, ki tieni u tien u baliga ki teniba, kebi kuli na. ");
INSERT INTO guxg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O den yediba ki ne n tie n saama n kuani o ŋan taado, yaa saama n wulibi niba boncianla. ");
INSERT INTO guxg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yeni imaani n luaani yi, n kan go nu palipe duunt hali yaa daali ke n bao guanu u tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ban den yini ba yanbu ki pendi, b den don o lite tiidi juali po. ");
INSERT INTO guxg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu den yedi ba: yikidi ba yadi kiŋa nni, kelima li diani nba pua ki kpa o pe kpaalo ti pebidi monyadi. ");
INSERT INTO guxg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yeni n yaa ti guani ki fii bi kpienba siiga nni, n baaga yi linga kigedi galile. ");
INSERT INTO guxg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pidi den yedo n li yaa tie ba ke n lieba sani mini wani kan sam pipe. ");
INSERT INTO guxg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu den yedo: «yeni i moani po n maada ba dinla niagu moni yeni o kokolo n ti buudi taalima lie po, a ba nia keŋaa bani na taalimata.» ");
INSERT INTO guxg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ama pieli den yedo: «ba li yaa tie min taani ki kpe yema, n kan tieni lanwani palpe bi kuli den taani ki niani yeni. ");
INSERT INTO guxg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","likani kebi pundi yaa kaanu ke b yi u jetesemane ke Jesu maadi o ŋoadi kaaba kali man ne min gedi ki ban jaandi. ");
INSERT INTO guxg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","b den ta gidi, jaka yeni jan, lani li pa boanli den kuao ke o yama mo yagi. ");
INSERT INTO guxg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","jesu den yediba: «li paboali cuo nni ha li kili naani nani kpe yen. Sedi mani ne kiya jandi.» ");
INSERT INTO guxg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesu den suli ke fuadi bikani, ki ba kilabini tiipo ki jaandi k l yedi li yaa tie kiliba tuo u naayogunu n foagidi o kani. ");
INSERT INTO guxg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","o den yedi: «abba, n ba a fidi bonlikuli liya batuo ŋan foagini n kani ya fala tadinukaaga n tie-na ama lan da tie mini n bua maama ka, ama a yanbuama n tieni.» ");
INSERT INTO guxg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","o denguani ki cua bi kani kisua kebi goa ke oyedi pieli: «simono a goa yo? ŋaa fd fidi ke guudinni ba yogu waamu? ");
INSERT INTO guxg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Fii moni ki ya jandi, ki yintiba nni tulimani. Lipali bua ama tigbannandi ki pia paalu.» ");
INSERT INTO guxg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","yeni ki o go guani ke lebidi ki ban jaandi kiyedi nani waa bi kpia ki maadiya lanbona. ");
INSERT INTO guxg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O go den liguani ki sua ke bi goa, kilima n guama den ye bi nubina po, lan wani ba ji den fiidi ki ŋmiano liba. ");
INSERT INTO guxg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","yeni o den guani ki cua bi kani bombi ta po ke yendiba: «i da li goa ki fuodi halimoala? Lidagidi! oyogunu pundi, o nisaalo bija ji caa ke ban ban kuado ti biidi damba nugunni. ");
INSERT INTO guxg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fii-mani, tin gedimani, diidi yua n ba koadi nni, o nago.» ");
INSERT INTO guxg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wan den maadi ya yogunu, ke bi piigani liediba siiga, yendo yua kibi yii wa juda nageni g pundi yeni bi niba bociaala yeni ti jatiadi ijuugimu a lambana lijandieli cambaaba yeni a gbamba nda yeni lijandieli nikpela soani yaba. ");
INSERT INTO guxg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","yua den ba kuaado den wani ba ya banma ke o ba tieni, ki kuaado bi po yua ki sani ki filo ki moadi moadi o tan kpina po «wni yeniyin cuo-mani boŋanla kigedi yeno.» ");
INSERT INTO guxg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Juda n pundi ya yogu o li puadi ki noanli jesu, ki maadi a tankpina. ");
INSERT INTO guxg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Laayogunu ke bi nagini ki cuo. ");
INSERT INTO guxg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","U ŋoadikaaba siiga yendo n noadi i juuga ke cua ki nani bi salayidiciaaba siiga yendo ya tuubili. ");
INSERT INTO guxg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu den yedi ba: «i cua ke koni yeni nni nani n tie o nayigo yeni, yeniti jatiadi i juugimu a lambana ke la cuo nni? ");
INSERT INTO guxg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","min den ye yeni yii, ke tuundi yii daali kuli o jandiegu nni, yii den cua nni. Ama moanla o yogu pundi ki i dianni n den maadi yaala n tien nni.» ");
INSERT INTO guxg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lawani yaaba n den yeni jesu kuli n sanni ke ŋao. ");
INSERT INTO guxg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","O jawaalo yendo den yua o wa, ki piini o, gbamnu po bu kpalibu bebe. Ya yogu ki nibi yeni mubino, ");
INSERT INTO guxg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wan ñoanliba yeni o kpalibu ki sani yen cankpeloli. ");
INSERT INTO guxg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ban ta Jesu ki gediyeno o salayidi kaaciamo kani, nani ki lijandieli cambaaba yen lijandieli nikpela yeni o tienu maama tili gbambanda taani. ");
INSERT INTO guxg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pieli den yua hali fagima yeni bi salayidika ciaaban cambaaba diegu kani, o den kali sejennba siga ki nagini omu kilima ti waadi den ye. ");
INSERT INTO guxg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lijandieli caabaaba yeni bi nikpe juogi kaaba den lingi ban-ba jaligi yaala Jesu ki fidi ke kpa o. Ama bi naa den la liba kuli o po; ");
INSERT INTO guxg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kilima niba bociaala den pua o po mifaama; ama yeni bi faama po kuli laa tua maani. ");
INSERT INTO guxg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bi nitianba n fike pua mi ki jaligi Jesu. Ki yedi: ");
INSERT INTO guxg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«ti den gbadi ki o maadi: “n ba muadi li naa jandieli yaali ki bi maa yeni bi niba nu nuugii danata siiga, n ba guani ke ma ya jandieli ke nisaalo ya nugii ka maali, ");
INSERT INTO guxg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ba yen la maama po kuli, ba la ban fidi kijaligo yaala ya po? ");
INSERT INTO guxg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","O salayidi ciamo den fii ki sedi bi siiga ke buali Jesu: «ŋa-pia ŋan ba ŋmiani yaala? ");
INSERT INTO guxg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ke o ka ki ŋmini suo wa ŋmiani liba. O salayidikaciamo go den bualo yeni ya lanboli n tiena: «a tie kilisiti, u tienu n seligi o bijua yua yo?» ");
INSERT INTO guxg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ki Jesu ŋmian: «n tie a ba la o nisalo bijua, ke o ka o paciaabu daano jienu po ya yogunu ki o paalu ñani tanpoli po ki jiidi u po nani nani o taawaligbamgou yeni.» ");
INSERT INTO guxg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ke o salayidi kaciamo cuo o tiadi ki dadi padi ke yedi: i go bua ki gbadi o laa sieda yo o po? ");
INSERT INTO guxg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","i gbadi wan suugi o tienu maama. I jagi ki tin tieni o be? bi kuli den taani ki yedi lidagidi wan kpe. ");
INSERT INTO guxg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","bine kiili kiya ciidi o po ti nisoandi ki pibinio nunga yeni li cabili, ki pua o yi tanpabi ki maadi yeno: «bundi!» ki sejeba gedi yeno ki pua wa. ");
INSERT INTO guxg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lanwaninipieli den ye likani u diegu tiipo, janfanyendo den ye likani ki tuunni bi salayi kaciaaba po n cua o kani. ");
INSERT INTO guxg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wan den la pieli ki o se likani ki yie o mu. O den ŋanbi ki noanlo ki, yedo: «a moko den li ye yeni sasaleti, Jesu.» ");
INSERT INTO guxg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ama ki o nia, ki yedi: «mi bani ŋan bua maadi yaalo.» liyogu o den ñani doujagu yeni nni (u kotongu den mua.) ");
INSERT INTO guxg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ama lan po moko, yaa jafaano n tuuni likani den la o ki go kili ke maadi yeni yaaba n ye li kani: «o ja ne mo bisiiga yendo! ");
INSERT INTO guxg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ama o go den nia. Lan den pugini waan mu, ya niba n den se likani den yedi pieli: maamoni a li tie bisiiga yua yo; kilima a moan ñani galile yo.» ");
INSERT INTO guxg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lan wani o den cili ke poligi ki tua: «mibani yin maadi ya jua yeni ya maama.» ");
INSERT INTO guxg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Laa yogunu u kotogu den mua mi liema. Pieli den guani ki tiadi Jesu n den yedo yaala: «hali ki u kotogu talimilie, a ba nia ki ŋaa-bani nni talimata.» o den ñani ke ban buudi. ");
INSERT INTO guxg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","O tiŋa panpangu, li jandieli yeni juki n ba nikpe juocaaba den tani ki diidi ban jaligi maama ki loma guveneeli kani bi den cabi ki sejenba lolio ki bi jedi yeno pilata kani. ");
INSERT INTO guxg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilata den buali Jesu: a tie jufi ba bado yo? Jesu den gua ŋmiano: Fin moano n yedi. ");
INSERT INTO guxg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","bi salayidikaciaba canba den galigi yesu ki o tien di yaala ki ŋani. ");
INSERT INTO guxg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilata n bualo: ŋaa pia liba ki ba maadi? agbadi ban jaliga ki maadi ka tien nni ya bobigu kuli. ");
INSERT INTO guxg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ama Jesu den ki guano maama ba kuli. Pilata n den laa bola kuli, kili ya ki lido. ");
INSERT INTO guxg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Li den tie bogidili ki binli kuliguveneeli, paki jaama dana siiga bi ba ŋani niyendo dasaliga ki ŋa o. Bi den maani ki ŋa bi niba n mia ban kin ba ŋa yua. ");
INSERT INTO guxg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ki sua jua ba ye li dansalidieli ki bi yi u banasa yeni o lieba, bi den kpa bi ba niba bocian la ya yagu po ki den fi yie loma guvenneli bali maama. ");
INSERT INTO guxg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lan wani ki o niligu nagi nni pilata kani ki mia o ki wan ŋa niyen do nani ban tie n di maama bi damba bogida po yeni. ");
INSERT INTO guxg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilata den bualiba: yi bi bua mi ŋa yi po yua ki yi maadi ki o tie yi bado. ");
INSERT INTO guxg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","O den maadi kilima o den bani salayidikaciaba n den bua ban tien no maam a, bi den jaligi di Jesu kilima bi den pia yi nanga o po ki dugi nni niba bociaala den tua o ŋoadikaaba. ");
INSERT INTO guxg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama bi salayidikaciaaba den tudi linitingli ki ban maadi pilata ki wan ŋa banabasa ki kpa Jesu. ");
INSERT INTO guxg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilata go yedi ba: n ya ŋa yipo banabasa, yi bado yi bua mi tieno be yo? ");
INSERT INTO guxg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ban yiginni ki puginni: kpao mani. ");
INSERT INTO guxg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Laa wani pilata n buali: be ya po? o bidi be yo? ama kibi kpaadi ki yiigi nni hali boŋanla kpao mani. ");
INSERT INTO guxg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nani pilata n den tuo linitingili n bua maama, o den. ŋa banabasa, pilata sejenba n pua Jesu a gbana. Laa puolipo, pilata n madi o sejenba ki ban gedi yeno ki kpa o. ");
INSERT INTO guxg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ki sejenba ta Jesu ki gedi yeno bi cagiciaali kani ki tan nni bi tuo soanlieba kuli. ");
INSERT INTO guxg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sejenba n taanni ki gbeni, ki bi ta liadifogidimoangu ki lan Jesu. Ki bi lugi konkoni ya fogiliga ki yilinno, o yuli po. ");
INSERT INTO guxg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ki ji fuodo nani bayi fuodi o bado maama ki ñuado, ti fuonda juf ba bado. ");
INSERT INTO guxg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bi den puu ya lanbana n yabi o yulipo ki si o po ti ŋoansoandi ki gbandi o nintuali, nani bi coan nni o yeni. ");
INSERT INTO guxg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ban den ñoandi o ki gbeni, ki bi landi o lindi fagidi moangu yali ki bi lan o yeni, ki yuadi ki ta o ya tiadi ki lano ki ñano o dogu nni ki gedi yeno nanni ki bi ba kpali danpoanpoanli po. ");
INSERT INTO guxg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ama ya jua bi yi u simono ki o tie silindi ya dogu n yua, ki o ba tie alesaolili yeni lufut ki bi cindo, bi sanu den ña likani ki bi yieno ki wan tugi Jesu dandanpoli. ");
INSERT INTO guxg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sejenba den jedi yedi no ya kanu bi yi goligolita. Laa yeli bundima bua ki yedi, ti yu kpabicuodi kani. ");
INSERT INTO guxg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bi den bua ki ñumio ya duven n den ŋmadi yeni mili ama wa den ñuni. Sejenba ta o tiadi. ");
INSERT INTO guxg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ki bi kpa o lidapoanpoanli po, ki ta o tiadi ki toanni titia. ");
INSERT INTO guxg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Li den tie li dali kudi ta yogunu yeni, ya yoginu ki bi den kpa o lidanpoanpoan-li po. ");
INSERT INTO guxg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ki bi dian nni ki tabi nni yali ya po ki bi den kpa o li dapoanpoanli po. ");
INSERT INTO guxg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yi dian ni yeni nima nni den bua ki yedi: Jufi n ba bado, bi go den kpa bi bibiadalie ki pugini o po. ");
INSERT INTO guxg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yendo den ye o jienu po ki yendo moan ye ganu po. ");
INSERT INTO guxg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A sanpeda den sugido ki tibidi biyula. Ki tua: ha! Fini yua n den maadi ka ba fidi ki mudi li jandieli danata daali ŋa gua maali, a ya ba fidi tie nni tin diidi, ");
INSERT INTO guxg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Fie a yuli fini moanlo ñan o dadu po ki giidi. ");
INSERT INTO guxg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bi salayikaciaba yeni u tienu maama gbanbanda moan den sugidi Jesu ke ñoando. O den maadi bi ninba boncianla kani: o den fie ninba boanciaala ya yogunu kili damba den ye fala nni ama ka fidi fie o ya yuli. ");
INSERT INTO guxg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","O den maadi ki ne: n tie kilisiti; mini n tie ya bado ndie Isalele yaaba. Li ya tie ki o maama tie moan-moani, o bi ña li dapoanpoanpo ki jidi! yen wani ti kuli bi ba dani o ni nni bi niliediba yaaba ki bi den kpa o bi siiga moan den sugido. ");
INSERT INTO guxg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kudi luoba yogunu li biigili den ba yi tinga kulipo, li den tie yeni hali kuti yiayogunu. ");
INSERT INTO guxg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kudi yia po, Jesu den kpaadi ki yiginni ki yedi: eloi, eloi, lamasanbagitani? Lani n bua ki yedi n tienu, n tienu be ya po ka ŋani? ");
INSERT INTO guxg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ya niba n den ye likani n gbadi laa maama yogunu, «eloi» ban ki ŋanbi li maama nima nni, bi den yedi: cingi-mani o yi o sawali pualo «elia o!» ");
INSERT INTO guxg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bi siiga yendo n sani ki ban ta o ciesiobu ki ñua li damiligilinni, babini li kankagili juoga ki niindi ki Jesu n ñu. Ki bi maadi tin guudi mani ke le elia ya ba kua ki jiino lidapoanpoanli po! ");
INSERT INTO guxg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu n yigini yeni pauma, ku fuodi ki giini ki kpe. ");
INSERT INTO guxg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lanyogu o kpalibu yaa ba n den juami ki piigi lijaandidi bunbaba den cili tanpoli ki padi ki jiidi hal tinga. ");
INSERT INTO guxg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A mintila canba yua n den se li kani n la Jesu kuma, o den yedi maamoani ya ja na go li tie o tienu biga! ");
INSERT INTO guxg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bi puoba mo de se foangima ki nua. Laa puoba siiga maliyema magidela dogu yua, yeni maliyema jaka na o die kpalo yeni jose. ");
INSERT INTO guxg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Banin den yegi jeni Jesu ki gedi galile todi o tuolinni. ");
INSERT INTO guxg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Laa daali den tie n libogili jufi n ba fuodima jama o yen juogu n dagidi. ");
INSERT INTO guxg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Alimate dogu yua Josefi, yua den ye jufinba nikpela cegili kaaba siiga nni. O den gu tanpoli diema pundima. O den ba li papaali ki gedi pilata ki mia o ki wan casi wan ta Jesu gbanandi. ");
INSERT INTO guxg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Li den lidi pilata yeni Jesu n tuodi ki kpe maama. Ke o yini amintela kobiga n yudano ki buali o gbadi i Jesu kpe na. ");
INSERT INTO guxg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wan bandi amintela kobiga yudaano kani ke o kpe ke o cabi JOsefi o gbanandi. ");
INSERT INTO guxg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josefi den daa u kpalipiemu ki jiini o li dap ɔnpɔnli po ki bobini o o kpalipienbu yeni ki gadi ki pan duani o yaa kakuli ke bi kpiedi u tangu po ki bindi li tanli ki biini. ");
INSERT INTO guxg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magidala Maliyama yeni Maliyama yose na den se ki nua ban duani o naani kani. ");
INSERT INTO guxg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mi fuodima daali n den pendi, Madagalapua yuan yi Maliyama den daa Alomata ki cua banmii Jesu gbannandipo. ");
INSERT INTO guxg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Li den tie li dacincinli siŋaɔgu panpangu ke bi den gadi li kakuli. ");
INSERT INTO guxg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bi den yedi bi lieba: ŋma baa pan luodi ti po, yaa tangu n biigi li kakuli? ");
INSERT INTO guxg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yaa yogunu ke biyaa gi nɔnli li kakulipo, ki la nilo ba ke o bindi li kakuli tanciangu. ");
INSERT INTO guxg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ban den kua li kakuli nn, bi den la o jawaalo ke o lani ti tiapiendi ki ka bi nu jienu po ke u jawaanbu cuoba. ");
INSERT INTO guxg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","O den yedi ba: da jie mani, yi kpaani Jesu Nasaleti yua ke bi kpagu yeni. O fii u, waa ki ye ne. Diidi mani ban den duani o naani. ");
INSERT INTO guxg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ama yi gadi ke pan yedi O ŋɔdikaaba yeni pie li ke o gaa liiga ki gadi Glile. Lani po kebi baa laani nani wan den yedi ba maama. ");
INSERT INTO guxg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bi den ñani li kakuli nni, ki sani. Li den lidiba hali ki jegiba bi den ki maadi nilo liba kuli kelima bi den jie hali. ");
INSERT INTO guxg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Li dacincinli daali siŋaɔgu panpani, wan den fii yaadaali yaa Maliyama ke o den beli ki ñani o niini cilicilibiamu lele yen den kpia ki la o. ");
INSERT INTO guxg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","O pua yen den ban togidi yaaba den yeni o yaa yogunu ki den kpiini ki go buudi o po. ");
INSERT INTO guxg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ban den gbadi ke o guani ki fuo, ke o pua yen la o, ama bi den ki tuo daani. ");
INSERT INTO guxg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lan n den pendi, o den dogidi o ba niba lie kani yeni Manati tiadi ya yogunu ke bi den cuoni ki ñani u dogu nni. ");
INSERT INTO guxg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Laa niba n den gadi ke pan togidi yaa ŋɔdikaaba n sieni, ama bi mo den ki tuo ki daani. ");
INSERT INTO guxg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lan den pugini waamu, Jesu den dɔgidi o ba o ŋɔdikaaba piiga n yendo kani yaa yogunu ki den taani kikaa li kpagili po. O den maadi ba bi dandanli luoma yeni Pajuali, kelima baa den tuo ki daani yaba den yedi ba ke bi laa Jesu ke o fii bi tinkpiiba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","O gua den yedi ba; Gadi mani ŋanduna munli kuli ki yaa wangi O Labaaliŋanmo. ");
INSERT INTO guxg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yua n tuo ki daani, yin wuli U Tienu ñima o baa faadi, ama yua n ki tuo daani, bi baa jia o buudi. ");
INSERT INTO guxg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yaa ŋua mani yaa banciama n ba ŋua yaa ba tuo daani. N yeli nni, bi baa beli ti maalibiidibi baa maadi mi malanma. ");
INSERT INTO guxg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bi baa cuo i we yeni bi nuugi, bi go yaa ñunba ŋɔgibugu mo li kan fidi ki tieni ba yaala n bia. Bi yaa maani bi nuugi a yiama po, se ban paagi. ");
INSERT INTO guxg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ti yonmidaano n den maadi ba ki gbeni o den yugi ki doni tanpoli po ki pankali U Tienu jienu. ");
INSERT INTO guxg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","O ŋɔdikaaba den siedi ke pan wangi o labaali kuli yaa yogunu ke ti yonmidaano den suani yeni ba, o den ta bi po i mɔmɔni yeni n bangiciama baoncianla den ŋuaba o maama nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bi niba boncianla jagi ke ban diani, ki togdi ya bontienkaala n tieni ti siiga nni, ");
INSERT INTO guxg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ti kpaagi yaaba n tie kasiednba leni bi nuni hali micilma, ki tua U Tienu maama tuonsɔla. ");
INSERT INTO guxg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lan wani, n mo kali, ki jagi, ki buali, ki bandi bonŋanla yaali n tieni hali mi cilma, ki ba diani, ki togdi a leni mi kpaagma, fini, n buado leni n nicɔlnka Teofili. ");
INSERT INTO guxg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yeni, a ba bandi ŋan ga ya bangima mɔmɔni cain. ");
INSERT INTO guxg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","herodi ṅ bo tie Jude badciamo ya yogu, salga yidka bo ye, ki yi Sakali, ki tie Abia salga yidkaaba cagli yua. O denpua bo tie Aron puolŋuanu, ki yi Elisabeti ");
INSERT INTO guxg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bi kuli bo tie nitegnkaaba U Tienu nintuali; bi kuli bo cɔlni U Tienu ñɔmabona, leni o yobdaano bali maama kuli, kaa pia kpiadma. ");
INSERT INTO guxg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bi bo ki pia biga kelima Elisabeti bo tie ŋɔlga, ke bani bilie kuli ji bo podi o. ");
INSERT INTO guxg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dayeli, Sakali den yidi salga U Tienu dieli nni, li den tie bi cagli salga yidma yogu i; ");
INSERT INTO guxg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bi den cɔlni salga yidkaaba danbogda, ki lugdi o ke wan kua salga yidkaanu, ki ŋubni li ŋubli. ");
INSERT INTO guxg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Li ŋubli salga yidma yognu, ku niwulgu kuli den se niipo, ki jaandi. ");
INSERT INTO guxg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","O diedo maleki den ludi o, ki legdi, ki sedi li ŋubli salga binbinli jienu po. ");
INSERT INTO guxg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakali ṅ la o, o yama ṅ pudi, ti jawaandi ṅ cuo o. ");
INSERT INTO guxg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama, maleki ṅ maadi o: “Da jie, Sakali, ki dugni, U Tienu gbadi a jaandi. A denpua Elisabeti ba punbi, ki mali a po bonjaga, ŋan yini o Jan. ");
INSERT INTO guxg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","O ba tua a po pamancianli, ke bi niba boncianla ba mangi bi pala o madi po. ");
INSERT INTO guxg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","O ba tua niciamo O Diedo nintuali. O kan ñu daamɔngu, ki nan buali daapaama. O ba ya gbie leni U Tienu foŋanma, ki da ŋaani mi biima. ");
INSERT INTO guxg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isayeli yaaba boncianla ba guani O Diedo, bi tienu kani. ");
INSERT INTO guxg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","O ba sɔni o tuonli ki dudi U Tienu nunbu nni leni Elia fuoma leni o paaciamu, ki cedi bibaanba leni bi bila ṅ guani ki mangi leni bi yaba, ki todi yaaba n ki tie nicɔlnkaaba, ban togdi bi nitegnkaaba maalma, ki ji bobni, ki tua ya nibuolu n ye U Tienu po. ");
INSERT INTO guxg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakali ṅ buali maleki: “Be n ba teni min bandi? Kelima mini nba n ciandi, ke n denpua mo podi boncianla”. ");
INSERT INTO guxg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maleki ṅ guani ki jiini o: Mini n tie Gabiyeli, ki ye U Tienu kani, ki tuuni o po. Wani n sɔni nni ke min caa u tondu, ki pa ŋa ya laabaalŋamo ne. ");
INSERT INTO guxg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lanwani, lan ba tieni maama n ne: A ba tua muulo, ki kan fidi ki maadi, hali ki tuoni ya daali ke min puni a ya laabaalŋamo ne yogu ba pundi, lan tieni ki dudi. ");
INSERT INTO guxg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lan kuli ṅ den tie ya yognu, bi niba den guu Sakali, ke li pagi ba leni wan waagi salga binbinli dieli nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wan ji den ñani, o ji den kan fidi ki maadi leni li nitaanli. Bi ji den bandi ke o la bonlegdikaali salga binbinli dieli nni. Wani ji den tua muulo, ki ji maadi leni o nui. ");
INSERT INTO guxg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wan gbeni o salga yidma dana, ke o guani, ki kuni o denpo. ");
INSERT INTO guxg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lan tieni danaba, o denpua Elisabeti ṅ punbi, ki tieni ŋmaali mu, ki ye deni, kaa ña. O den maadi o pali nni, ");
INSERT INTO guxg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“ Ne tie O Diedo tuonli i. O diidi nni leni mi yanbuama, ki piini yaali n den tie n po fee, bi niba kuli siiga. ");
INSERT INTO guxg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ŋmaali luoba ṅ pendi, Elisabeti tugpunbdi puoli, U Tienu ṅ sɔni maleki Gabyeli Galile dociamu nni, ke bi yi li dogu Nasareti. ");
INSERT INTO guxg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","jifaano kani, ke o tie ja cikpenga, ke bi yi o Josefi, ke o tie o badciamo, Davidi puolŋuanu. Li jifaano den yi Maari. ");
INSERT INTO guxg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maleki ṅ kua o kani, ki yedi o: “Mangi a pali, fini yua ke U Tienu cabi a o ŋanbili; O Diedo ye leni a.” ");
INSERT INTO guxg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari yama ṅ yagi boncianla, li maama po; wan buali o pali nni lan ya fuodi niima nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maleki ṅ maadi o: Da jie, Maari, kelima U Tienu n cabi a o ŋanbili. ");
INSERT INTO guxg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yaali n ba tieni n ne: Li kan kandi dana, a ba punbi, ki mali bonjaga, ki yini o Jesu. ");
INSERT INTO guxg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","O ba tua niciamo, ban yini o “Tanpojoma Tienu Bijua” O Diedo U Tienu ba teni o o yaja, o badciamo Dafidi badkpagli. ");
INSERT INTO guxg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O ba diedi ya buolu n ñani Jakobo kani hali ya yogu n ki pia juodma. ");
INSERT INTO guxg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maari ṅ maadi maleki, li ba tieni ledi, kelima n tie powandiali i, n ki bani ja? ");
INSERT INTO guxg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maleki ṅ guani ki jiini o, “U Tienu foŋanma ba jiidi a po, ke Tanpojoma Tienu paaciamu ṅ fibni a leni o junjungu. Lan ya po i, ke bi ba yini ŋan ba mali ya biga U Tienu Biga. ");
INSERT INTO guxg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Diidi, a kpiilo Elisabeti mo punbi, ki guu bonjaga yeni wan ciandi maama kuli, ke bi tua ke o ji kan baa biga; o ji ye o ŋmaaluobidi n yeni. ");
INSERT INTO guxg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kelima U Tienu ki pia wan gbali yaala. ");
INSERT INTO guxg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maari ṅ maadi: “N tie O Diedo tuonsɔnlo i, ŋan yedi nni yaala ṅ tieni ki dudi nani lan buali maama. Ke maleki ñani ki ŋa o. ");
INSERT INTO guxg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Li ki waagi ke Maari fii, ki ŋmaa tonma, ki gedi Jude juana dociamu nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ki kua Sakali deni, ki fuondi Elisabeti. ");
INSERT INTO guxg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wan gbadi Maari fuondi ya yognu, ke o biga yugi ki ciidi o tugu nni, ke Elisabeti gbie leni U Tienu foŋanma. ");
INSERT INTO guxg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ke o fiini u nialu, ki kpaandi, ki yedi: “A baa mi yedŋanma bi puoba kuli siiga, ke a tugu nni biga mo gbie leni mi yedŋanma. ");
INSERT INTO guxg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Be n teni ke n dagdi yeni li seli, ke O Diedo naa cua n kani ki bua la nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kelima diidi min gbadi ke a fuondi nni ya yognu, ke n biga jeli leni li pamanli n tugu nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","U yenyienŋamu (mi yedŋama) ye leni fini yua n dugi ke U Tienu ṅ sɔni a po ya tondu ba tieni ki dudi” ");
INSERT INTO guxg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lan yognu, Ke Maari yedi: “N naano yiini O Diedo kpiagdi. ");
INSERT INTO guxg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ke n yantiali mangdi li pali, O Diedo U Tienu, n candaano po. ");
INSERT INTO guxg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kelima o tuo ki tibni ki diidi mini talga, o tuonsɔnlo. Lan ya po, lan fii lan faa, leni yogu kuli, bi ba yini nni o cabŋandaano. ");
INSERT INTO guxg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kelima U Tienu, U Paaciamu daano tieni n po yaali n yabi. ");
INSERT INTO guxg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","O ŋanma ba tandi nifiima ṅ tuu nifiima yaaba n cɔlni o po. ");
INSERT INTO guxg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O tandi o nuu leni u paaciamu, ki yadi yaaba ya pala n gbie leni ti japaadi' ");
INSERT INTO guxg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O tudi ki jiini bi paadanba bi badkpaga po. ki nan duoni talganba. ");
INSERT INTO guxg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O gbieni a konkonba leni a bonŋana, ki nan deli ki yaani bi ŋalmandanba i nuukuomi. ");
INSERT INTO guxg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nn, O puni Isayeli, mi todma o pakɔnli kuli po, ki waani o ŋanma ya nibuolu n tie o tuonsɔnba po. ");
INSERT INTO guxg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Nani wan bo niani ti yajanba) Abalahama leni o puolŋuani hali ya yogu n ki pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maari kali leni Elisabeti nani ŋmaali taa yeni, ki guani ki kuni o denpo ");
INSERT INTO guxg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeti madi ji bo nagi n yeni, ke o mali bonjaga. ");
INSERT INTO guxg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","O kuantalieba leni o kpiiba den bandi O Diedo ṅ tieni o po ya ŋanbli. ki tieni u badu leni o, ki waani bi pamanli ṅ dagdi maama. ");
INSERT INTO guxg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","O madi n ́pendi daaniili daali, ban cua ki ba kuani ki canpandga ku kɔnciagu. Bi den bua ban yini ki biga “Sakali” nani o báa n ́yi maama, ");
INSERT INTO guxg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ama ke o naá jiini ki maadi, “N N, O baa yi Jan i.” ");
INSERT INTO guxg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ama ke bi maadi o, “Nilo ki ye i diegu nni ki gaani lan ya yeli” ");
INSERT INTO guxg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lan wani, ke bi buali bibáa mi muulma nni, wan bua yini ki biga maama. ");
INSERT INTO guxg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","O báa ń buali, ban teni o ki kpagdiankaaga (walga), wan diani ya lanbona ne, “O yeli tie Jan.” Lan tua bi kuli ya po pagili. ");
INSERT INTO guxg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lan yognu liga, o ñɔbu ń mubdi, o lanbu ń tabdi. Wan ji ya maadi, ki kpiagdi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ti jawaandi den cuo yaaba n den gaani ki lindi ba. Li laabaali den yadi i kaani kuli, Jude juana dogi nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yaaba n den gbadi li maama den maadi: “Ya biga ne ba tua be?” kelima U Tienu den ye leni o. ");
INSERT INTO guxg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakali ki biga báa den gbie leni U Tienu foŋanma, ke o pua sawali, ki yedi: ");
INSERT INTO guxg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Dondi mani O Diedo, Isayeli tienu, kelima, o todi o buolu, ki faabi u. ");
INSERT INTO guxg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ti ya po, o candaano yua n gbie leni u paaciamu mali o tuonsɔnlo, o badciamo Dafidi puolŋuani siiga. ");
INSERT INTO guxg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wan den sɔni o sawalpuaba yaaba n gbie leni U Tienu foŋanma, ke bi niani ti yajanba yaala hali mi cilma, tieni ki dudi. ");
INSERT INTO guxg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ke o ba faabi ti ti yibalinba nui nni, leni ti nantieba gbanmanu kani. ");
INSERT INTO guxg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","O tie bonli kuli ke li wangi o ŋancianma ti yajanba po, ki gɔa ki tiadi o n̄ɔnianu. ");
INSERT INTO guxg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wan den niani ti yaja, Abalahama yaali tieni ki dudi. ");
INSERT INTO guxg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","O poli ke o ya fie ti ti yibalinba nui nni, o ba cabi ti ki nunmanga, tin ya jaandi o kaa jie ");
INSERT INTO guxg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ki tuuni o tuona, ki tie o buolŋamu, ki tie nitegnkaaba o nintuali daali kuli ti yenyienu nni. ");
INSERT INTO guxg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nn, Ke fini, ki biñidga, bi ba yini a Tanpojoma sawalpualo, kelima, a ba ga sanliiga, ki cuoni U Tienu nintuali, ki bobni o sanu ");
INSERT INTO guxg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ki teni o buolu ń bandi ke U Tienu puni u mi faabma, ki tieni u tuonbiidi po sugli. ");
INSERT INTO guxg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kelima ti tienu gbie leni ti niñinpadi leni mi ŋanma. Lanyapo, ku yenpudkaagu ba ña tanpoli, ki yendi ti po. ");
INSERT INTO guxg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ki yendi yaaba kuli n ye li biigli nni leni mi kuuma junjungu nni, ki pegdi ti taaŋmaadi mi yanduanma (li yanŋaali) sanu po ");
INSERT INTO guxg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ki biga den yabdi, ke o yantiali mo paagdi ki pugdi. O den ti juodi ki ye ki tinkuonga nni i, hali yeni ya yogu ke o ti legdi ki waani o yuli Isayeli buolu po. ");
INSERT INTO guxg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","l yogu romi badcianmo Ogusto bo diani k pua sawali o diema nni niba kuli ċɔdili. o cincinli cɔdili bo tieni ya yogu ke kirisus bo tie badcianmo i siri diema n ni. ");
INSERT INTO guxg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","u cincinl cɔdli bo tieni ya yogu ke kirisus bo tie badcianmo i siri diema nni. ");
INSERT INTO guxg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","yua kuli bo ye gedi ban cɔdi wan ñani ya dogu n nni. ");
INSERT INTO guxg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","yeni k josefi bo ñani nasareti k doni galile ki tɔgn nni jude, k pudi betelemi, david dogu, o bo tie David cugli yua i. ");
INSERT INTO guxg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josefi bo gedi lan kani wan yeni o cikpenga Maari ku pia o tugu. k b pan cɔdi. ");
INSERT INTO guxg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ban den ye betelem i k maari t gbaani t maadi. ");
INSERT INTO guxg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","maari den mali bojaga o cincinmadi ki pin'o i kplaldi k duan'o ti yandi jeditiagu nni kelima bi canba dieli nni yiali den ki ye. ");
INSERT INTO guxg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","I kuanni bo kuu li kani ke a yankpaala dua ki guu bi yandi. ");
INSERT INTO guxg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","K u tienu maleki yendi cua bi kan ku tienu yudandi jiidi b po ke ti jiwaanndi cuo ba. ");
INSERT INTO guxg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Maleki maadi ba. i daa pia mani jeje n bua pua'yi sawalmanli yu baa tie yua kul pamancianli. ");
INSERT INTO guxg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ba fie ti mali dinla David dogu nni wan tie o candaano. ");
INSERT INTO guxg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ti bo band'o maama nne i ba la i canpandiga k o dua ti yandi jeditiɔgu nni ki piini i kpaldi. ");
INSERT INTO guxg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ke li yogunu mɔno ki bi la u tienu meleki nba k bi cua ki pugini i yua bo ye yeni po ki bi ji yiini ki dondi u tienu. ");
INSERT INTO guxg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","U Tienu yeli n yabdi tanpolu po, o pamangu n ya ye i tinga po nne yeni u nubuakaab po ");
INSERT INTO guxg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ban yin ki gbeni ya yognu k u tienu meleki nba lebidi tanpolu po ka yankpala mɔ boe yeni bi lieba. ti gedi manni Betelemi dogun nni yaal k diidi yaala cua, u Tienu n waani ti yaali. ");
INSERT INTO guxg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","K bi kagini ki gedi l yognu tonma k la yeni i mɔni Maari yeni Josefi yeni ki bipanga yua mali k b taa'ga k duan'ga ti yandi jeditiagu nni. ");
INSERT INTO guxg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A yankpaala n gedi ki la'o, ki guani ki togdi yua kuli u Tienu meleki n den baa pua labaal maam e canpandigi yen po. ");
INSERT INTO guxg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yaba n den songi a yankpaala labaal kuli li de lidiba. ");
INSERT INTO guxg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ke maari yi guani ki tiadi o pal nni yala tieni kuli yeni ya maama madi kul. ");
INSERT INTO guxg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A yankpaala den guani ki lebdi bi yankpaamuagu po i k yin k dondi u tienu yen ban de songi yaala ki gɔ la yaala. U tienu meleki n den maad yaala den tie mɔni ");
INSERT INTO guxg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesus n den mali l daaniin po k l tie ki ban gedi kɔnd'o, ki bi kɔnd'o ki pun o yel Jesus. Lan yeli k u tienu meleki bo lugdi u po. ");
INSERT INTO guxg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lan bo buali maam moyisi yikotili nni. L yognu ya pudi l tie taladi ki ban kuani ki canpandiga u kɔnciagu. Lan yognu n pendi ke bi taa Jesus ki gedi yen'o jerusalemi ke pan waan'o u Tienu. ");
INSERT INTO guxg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","dianni u tienu yikotili nni, ki cincinbiga kuli k o tie bonjaga tie u tienu yuu i. ");
INSERT INTO guxg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","B bo ye ba ki tieni u Tienu balga yen kpajiemulie i nanni lan bo bual maam u Tienu yikotili nni. ");
INSERT INTO guxg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ja bo ye Jerusalem dogu nni k u yeli tie Simeyɔn. O bu tie yua tiegi k gɔ tie ya nulo tuagi u Tienu sɔnu. O den ye ki daani Israel fiema ki fonŋanba ye yen o. ");
INSERT INTO guxg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","tienu foŋanba de dɔgd'o k u kan kpe gaa la mesi u Tienu tondo. ");
INSERT INTO guxg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tienu foŋanba n jiidi u po wan gedi l jaandiel nni ki sua ke Jesus danba cua yen o, k ba tieni a bogda nanni simeyɔn yikotili nni lan bo buali maam. ");
INSERT INTO guxg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyɔn ga ki biga o nugi nni ki ji yiin i ki dondi u Tienu. ");
INSERT INTO guxg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","tienu ji ŋa a tuonsɔnlo wan ya caa yeni laafia. a cɔlni a ñɔniannu. ");
INSERT INTO guxg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nunbu la o candaano ka sɔn'o. ");
INSERT INTO guxg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ki a pun'o li papaali ke wan todi ŋanduna. U Tienu meleki. ");
INSERT INTO guxg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","tie muuyiema i ki ba yendi ŋanduna. wan baa tie Isaraheli yudandi. ");
INSERT INTO guxg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yen o naa bo ye pamangou Simeyɔn n maad yaala Jesus po. ");
INSERT INTO guxg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyɔn yedi m yeŋanma b po ki madi marri. Nan ya bani ke biga ne ye Isaraheli buolu kuli yaa po i. L bo fidi yaa tie ti po bibaaga bii m yedonma yu ki bi niba ba kpagi. ");
INSERT INTO guxg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mɔla yaala den duagi bi niba maalima bo dɔgdi fin wani l baa ti tie nani b taa jugi ke muu pundi a pali yen. ");
INSERT INTO guxg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tienu tondo mɔ bo ye l kani ke tie puaki k u yeli tie. Ani k u tie Fanial biga ki tie Aser cugl yua. O bo tie puocianmo i. ko bina lile po n bo yeni wan kuni o ja. ");
INSERT INTO guxg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ti. ki ti kali ti pakuadi ke ye o baba ki pan pundi piniini yen bina naa. O ña jandieli nni ki suani u tienu tuonli ki jaani ki gɔ loligi o ñɔba yieni yen ñiagu. ");
INSERT INTO guxg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","li puocianmo mɔ pundi lan yogunu; ki yin k dondi u Tienu k maadi yaba kokul den guu Jerusalemi fiema o janjanbiigu nni. ");
INSERT INTO guxg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tieni k gbeni nani u Tienu ñɔmaam n den buali maama. ki maari yeni Josefi gɔ lebidi Galile k kun Nasareti b dogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesus ji kpedi tonm tonma ki o yanfuonma caa liiga k u gɔ tie u Tienu nulo ");
INSERT INTO guxg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kuli Jesus baa yeni o naa bo yi tun ki caa Jerusalemi paki jaanmi. ");
INSERT INTO guxg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","yognu ki Jesus den pia piiga n bina lie ko ji yi ŋɔdi o baa yeni o naa ban gedi Jerusalemi paki jaanmi nani lan den bual maama. ");
INSERT INTO guxg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","jaanmi n den gbeni ya yognu o baa yeni o naa den gɔ cuo u sani k ji kuni ama k Jesus wani ñindi Jerusalemi kelima bi den kpaan'o kaa la'o. ");
INSERT INTO guxg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","b tieni m maalma ko baa yegi yeni o lieba yaaba ki bi den taani ki cua yen. ki bi mɔ cuo l celi nani da yeli yeni. K b cil k kpaan'o o kpiiba yeni o bankaaba siiga. ");
INSERT INTO guxg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ama baa den la'o ki b gɔ lebdi Jerusalemi k bu kpaan'o. ");
INSERT INTO guxg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","L dataa dali ki bi la'o l jaandieli nni ku kaa l balo maama banda siiga nni k songi ba k gɔ buali ba i buali. ");
INSERT INTO guxg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yaaba bo song'o kuli den ye panmangu yeni wan pia ya nunfanbu o maama gɔ jiima po. ");
INSERT INTO guxg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","L den pia o danba o yaalidigu yeni wan kaa naani. O naa den bual'o n biga be ced kaa sɔn ti lani. Mi yeni a baa den ye ti jawaandi nni k kpaan ŋa kaan kuli. ");
INSERT INTO guxg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","K Jesus den jiin ba. Be po i ki den kpaani n. I ki bani ki ba sɔni n baa tuona a. ");
INSERT INTO guxg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama bi den k gbadi o maama yeni niinma nni ");
INSERT INTO guxg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","K Jesus den cua ki ŋɔdi ba ki bi lebdi bi kuli Nasareti. O den cɔln o danba. K u naa den ta yal den tieni kuli k bili o pal nni. ");
INSERT INTO guxg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus den find tonma ko yantiali mɔ gɔ caa liiga o Tienu yen b niba den bua'o boncianla ");
INSERT INTO guxg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberi badciamo n dini li bali, li piiga n bina mu po, Ponsi Piilaati den tie Suude bado, ke Herodi tie Gaalile bado, ke o ninjua Fiilipi tie Iture yeni Traconiiti bado, Lisaniasi tie Abilen bado. ");
INSERT INTO guxg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hani yeni Kayiifi n den tie bi Salyidcianba. Laa binli i ke U Tienu bo maadi leni Sakari bijua Jan mi fanpienma nni. ");
INSERT INTO guxg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jan bo gedi Surdan fuanli nni kuli. O bo yii bi niba ke ban cua ke ban wuli ba U Tienu ñima, ke lan waani ke bi lebdi bi yama ke U Tienu dini sugli bi tuonbiadi po. ");
INSERT INTO guxg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yeni ke U Tienu Sawalpualo Esayi n bo diani yaala o tili nni tieni yeni mɔni: Bi gbia o nulo nialu ke o kpaandi mi fanpienma ki tua: Bobni man o sani, ");
INSERT INTO guxg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Baalɔdga kuli ba piini, Juali kuli yeni gbangbanli kuli ba sali, Ti sangolndi ba sondi, Ti sanbuodi kuli ṅ sali, ");
INSERT INTO guxg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ke bi niba kuli ba lá U Tienu ŋalbalgo. ");
INSERT INTO guxg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jan bo maadi ya niwulgu n bo cuoni ki bua ke wan wuli ba U Tienu ñima ki: A waalaba buoli! ŋma tundi yi ke yi sani U Tienu mutuoli yaali n cuoni? ");
INSERT INTO guxg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Waani man i tuona nni ke i lebdi i yenyienu. Da kubi man i pala nni ke: «Ti tie Abrahama yaabila!» kelima, diidi man a tana ne: N maadi yi ke U Tienu ba fidi ki cedi ke ŋan kpandi Abrahama bila. ");
INSERT INTO guxg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tin faami! Bi bobni li yali ki ba cua ki guli i tiidi: Ya tubu kuli ki loni luanŋanli bi ba cua bu ki juu bu u muu. ");
INSERT INTO guxg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lani ke ku niwulgu buali o: Ti ba tieni ledi? ");
INSERT INTO guxg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ke o ŋmiani ba: li ya tie ke yua pia liada lie, wan teni yua ki pia, liadyenli. Yua pia ti jiedi mɔ, wan bɔgdi ki teni yua ki pia. ");
INSERT INTO guxg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A patendgaala (lonpogaala) mɔ bo cua ke wan wuli ba U Tienu ñima. Bi bo buali Jan: ... Canbaa, ti ba tieni ledi? ");
INSERT INTO guxg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","... ke o ŋmiani ba, Da gaa man ti patendi (lonpo) ke ti cie Gobna n seni maama. ");
INSERT INTO guxg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sijenba mɔ den buali o: ... Ke tinba i, ti mɔ ba tieni ledi? ... O den ŋmiani ba, da fie man obá ligi, ki gɔ da fani ku faagu obá po: I pali ṅ ya mani i ŋmaapani po. ");
INSERT INTO guxg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bi niba den ye li dandanli nni paaa, ki ji den buali bi bá nni, bii Jan n baa tie O Candaano. ");
INSERT INTO guxg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ke Jan ŋmiani bi kuli: ... Min wan wuu yi mi ñima nni. Ama o nulo ba cua, ki pia u paalu ki cie nni. Mii dagdi yeni min lodi o taacagbanu. Wani, o ba wuli yi mi Foŋanma yeni U Tienu muu nni. ");
INSERT INTO guxg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","O kubi o dilendyetonga, ki ba lendi o dii, ki wodi i diŋami ki kuodi o bɔnbuali nni. Ku fengu wani, o ba lu gu ya muu n kan baa jundi (gbeni) nni. ");
INSERT INTO guxg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jan gɔ ŋanbi ki puuni bi niba U Tienu ñɔmaama n buali maama, muandi ba laabamanli. ");
INSERT INTO guxg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ama, o bo jalgi o bado Herodi yeni wan kuani Herodiati, o ninjawaalo denpua, ki gɔ tieni ya tuonbiadi n yabi. ");
INSERT INTO guxg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodi gɔ bo cuo Jan ki luoni o dansalgi ki pugni o tuonbiadi po. ");
INSERT INTO guxg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bi niba kuli cua ke Jan n wuli ba U Tienu ñima. Ke Jan wuli Jesu mɔ U Tienu ñima. Ama, ya yogu ke Jesu den jaandi, ke Tanpoli po luodi. ");
INSERT INTO guxg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ke Mi Foŋanma jiidi o po, ki naani nani li lanjeli yeni, ke nialu bă ñani tanpoli po ki maadi: ... A tie n bibuadga. N pali mani a po boncianla. ");
INSERT INTO guxg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ya yogu ke Jesu bo cili o tuonli, o den pia bina piita i. Nani bi niba n bo maali (maadi) ke tie Sosefi bijua yeni, o yaajanba yela nne: Eli, ");
INSERT INTO guxg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ke Eli mali Matati, ke Matati mali Levi, ke Levi mɔ mali Melki, ke Melki mali Yannayi, ke Yannayi mɔ gɔ mali Sosefi, ");
INSERT INTO guxg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ke Sosefi mali Matatiasi, ke Matatiasi mɔ mali Amɔsi, ke Amɔsi mali Nahumi, ke Nahumi mali Esli, ke Esli mali Naggayi, ");
INSERT INTO guxg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ke Naggayi mali Maati, ke Maati mali Matatiasi, ke Matatiasi mali Semeyin, ke Semeyin mɔ mali Yode, ke Yode mɔ mali Yoda, ");
INSERT INTO guxg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ke Yoda mali Yuanani, ke Yuanani mali Resa, ke Resa mali Sorobabeeli, ke Sorobabeeli mali Ceyaltieli, ke Ceyaltieli mali Neri, ");
INSERT INTO guxg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ke Neri mali Melki, ke Melki mali Adi, ke Adi mɔ mali Kosami, ke Kosami Elmadami, ke Elmadami mali Eri, ");
INSERT INTO guxg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ke Eri mali Jesu, ke Jesu mali Elieseri, ke Elieseri mali Yorimi, ke Yorimi mali Matati, ke Matati mali Levi, ");
INSERT INTO guxg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ke Levi mali Simeyɔn, ke Simeyɔn mali Suda, ke Suda mali Sosefi, ke Sosefi mali Yonami, ke Yonami mɔ mali Eliakimi, ");
INSERT INTO guxg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ke Eliakimi mɔ gɔ mali Meleya, ke Meleya mali Mena, ke Mena mali Matata, ke Matata mali Natan, ke Natan mali Dafiidi, ");
INSERT INTO guxg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ke Dafiidi mali Isayi, ke Isayi mali Obeedi, ke Obeedi mali Boosi, ke Boosi mali Salmɔn, ke Salmɔn mali Nasɔn, ");
INSERT INTO guxg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ke Nasɔn mɔ mali Aminadabi, ke Aminadebi mɔ gɔ mali Admin, ke Admin mali Arni, ke Arni mali Hetsirɔn, ke Hetsirɔn mali Pereti, ke Pereti mali Suda, ");
INSERT INTO guxg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ke Suda mali Sakɔbi, ke Sakɔbi mali Isaki, ke Isaki mali Abrahami, ke Abrahami mali Tera, ke tera mali Nayɔri, ");
INSERT INTO guxg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ke Nayɔri mali Serugi, Serugi mali Reyu, ke Reyu mali Pelegi, ke Pelegi mali heberi, ke Heberi mali Cila, ");
INSERT INTO guxg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ke Cila mali Kayinami, ke Kayinami mali Arfaksadi, ke Arfaksadi mali Semi, ke Semi mali Nowe, ke Nowe mali Lemeki, ");
INSERT INTO guxg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemeki mali Matusalemi, ke Matusalemi mali Henoki, ke Henoki mali Yeredi, ke Yeredi mali Maleleeli, ke Maleleeli mali Kenami, ");
INSERT INTO guxg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ke Kenami mali Enoki, ke Enoki mali Seti, ke Seti mali Adami, wani yua tie ya cincinnulo ke U Tienu bo cindi ki tagi o. ");
INSERT INTO guxg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus den gbie yeni m tagŋanmi, k u den ñani jurdeni bɔnga nni k l tagiŋanba tod'o k u gedi u fanfanpiegun nni. ");
INSERT INTO guxg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Naani ke sitaani bign'o dan piina. U den ki dii l ba l dana. L yogu n pend i k m kom cu'o. ");
INSERT INTO guxg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sitaani maadi Jesus: l ya tie ka tie u tienu biga, cab k l tanli n kpandi m jiem. ");
INSERT INTO guxg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus ŋmian'o l diani u tienu kaddaaog nni k nul k fo m jiem po baba ka ");
INSERT INTO guxg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","den duon'o pol. K waan'o u tienu diema yala n tie g tinga ne k maad'o. ");
INSERT INTO guxg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ba tena ya paalu baa tie u tienu diema piam kul yaal ntie l ŋandul kaan k dugn l kul den ye n nugun yo k bua ten mi bua yua. ");
INSERT INTO guxg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","wani a ya tuo ki gbaani n nintuali ni l kul baa tie a yaal i. ");
INSERT INTO guxg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Guani ki maad'o: ya dondi a yonmdaano u Tienu. Wan badba i ka b pug'o. ");
INSERT INTO guxg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","gedi yen'o hal Jerusalemi k duon'o u jaanddiegu tanpolu k maad'o: a ya tie u Tienu bijua yugi k ŋa a ba m fanfanma nni k dugn i l diani: ");
INSERT INTO guxg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","k u bu cabi meleki nba ban yaa guu ŋa. ");
INSERT INTO guxg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","l guan. b bu ŋa yeni b nugi k tanli kan gbebi ba tanyeli. ");
INSERT INTO guxg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","K Jesus ŋmia i: l gɔ diani. A kan niini k bigni o yonmdaano u Tienu. ");
INSERT INTO guxg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ya yognu k sitaan den gbeni o bignma kuli k u sani k fagdi k ban bo bil ya yognu pudi. ");
INSERT INTO guxg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus bo ye yeni fuoŋanba paalui k lebdi Galile ko yeli doni diema kuli nni. ");
INSERT INTO guxg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","K tundi u tienu ñɔmaama a jaandiena nni k b niba dond'o. ");
INSERT INTO guxg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","K gedi nasareti dogu nni ban bo ŋub 'o naani k kua l jaandieli saba daali. nani wan bo tug g tie maama. k fii k bo cogi tienu ñɔmaama tili. ");
INSERT INTO guxg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","K bi waan'o u tienu tondo isai tili wan pɔbidi l tili ko la naan kani k b diani k: ");
INSERT INTO guxg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","M yomdano fomnŋanb ye n po kelima u lugdn ki sɔgni kpaŋanba k bo muadi o ñɔmaama i cacagi danba k gɔ paagi yaaba pala biidi k yaaba tie juanma n nuali, k fie b cacagdama. ");
INSERT INTO guxg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","k gɔ muadi u tienu ŋanba binl ");
INSERT INTO guxg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","K u pɔbini l tili k teni o naacenba k gedi kali. U jaanddiieogu nni k a nubina kuli fid o po. ");
INSERT INTO guxg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dinne mɔno u bu cili yinm yaa song'o yeni kani u tienu tondo ñɔmaama tie mɔni. ");
INSERT INTO guxg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","yaab den song'o kul lden cuo'b u yaalidigu. K b tɔb maadi ki waa tie Josefi bijua kaa? ");
INSERT INTO guxg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","k jesus maadi bi: n bani ki bo puan i m makpanjama dogda dogd a ba ama e bia bomaadi maad'ti ŋan tienii yaala kaperinahumin dogu nni. ŋan gɔ tieni n yeni a dogun i k ti diidi. ");
INSERT INTO guxg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","K jesus pugn ama e mɔni baa bani k pagi u tienu tuonsɔnlo u dogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E mɔni ke maadi yi a pakuana den yabi boncianli Isaraheli dogu nni Eli yogu. lan ya yogu i ke taagi bo ba binataa yen bɔgidima. k m koncianma ba u dogu kuli nni. ");
INSERT INTO guxg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ama den sɔno'a ba pakua yedi kani k cedi b den t sɔn'o yendi kani k u den ye Sarepta Sidon dogun nni. a i. ");
INSERT INTO guxg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","A gbaada den ye ki yabi Isaraheli dogu nni u tienu tuonsɔnlo Eli yogu. Ama ki baa bo paagi baa yedi. B bo paagi Sirija i ku yeli tie Naamani ");
INSERT INTO guxg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","I yaabi den songi Jesus k ye l jaandieli n k kuli pala den biidi ");
INSERT INTO guxg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","b nubi kuli den fii k tudu Jesus k ñan'o hali l juali po l jaandieli n maa naan yeni k bi tud'o k lu'o tinga nni ");
INSERT INTO guxg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesus n den ñan b siiga nni k paani k caa Jesus den tieni i tundi yeni u tebigu Kafarnahumi. ");
INSERT INTO guxg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Den gedi Kaperinahomi galile dogu nni ki tieni i tundi ba u tiemu ñɔmaama po saba daali. ");
INSERT INTO guxg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yaaba den songi pala den mangi boncianli kelima u den yeni yikodi. ");
INSERT INTO guxg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","O ja den ye l jaandieli nni ki t tagbiid yeni mu cicibiadimu den cedi k o yign i yen paalu ");
INSERT INTO guxg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","O a bua tien 'ti be ne, a cua k ŋan bianti yaa? U tienu nuŋanmo tondo. ");
INSERT INTO guxg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ama k Jesus tiani yeni pabieli k maadi suon i k ña o ja ne gbanu nni. k t cicibiid yeni fuun'o k lun'o tinga b niba siiga k waa janbi ama k ñani u po. ");
INSERT INTO guxg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","k l yogu k ti jawaandi kua b niba, k b maadi b lieba. Lan ñɔmaam tue be i k pia u paalu yen yikodi k yi beli i cicibiadi ban saa ña i! ");
INSERT INTO guxg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ke Jesus yeli doni kaankul a dongbana nni. ");
INSERT INTO guxg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus n den ñani l jaandieli kan u den gedi Simo deni k sua k Simo juado ye yeni u gbanantogu, k b buali k b mia Jesus k wan tieni l bonli k paa'o ");
INSERT INTO guxg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","k Jesus tibn i o po k cedi ko yugbaagu ñani u po. k o fii l yogu k cil suani u tienu tuona. ");
INSERT INTO guxg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","O yienu n den baa ya yogu yaaba den pia b yianba b den po, b den ba yenmi Jesus kani k u yi e nui yua kul po wan paagi. ");
INSERT INTO guxg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","I cicibiadi den ña boncianli b ssiga nni, k yigini. A tie u tienu bijua i. Ama k Jesus yi tiani ban gɔ suono kelima b den bandi k u tie Kristo. ");
INSERT INTO guxg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lden fandi ya yogu k Jesus ñani o deni k gedi u fanfanpiegu nni. k b niba cil k kpaan; o ban t la'o k gedi o kani kaa ji bua ko seedi ŋaab'a. ");
INSERT INTO guxg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama k u maadi bi: l tie taladi min min muandi u tienu labanŋanli dogban tiana nni. Kelima lan yaa po i k u tienu sɔn n i. ");
INSERT INTO guxg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","k ji tundi u tienu labamanli Jude jaandiel nni. ");
INSERT INTO guxg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dayenli, ke Jesu bo ye Senesareti kpenkunu, ke ku niwulgu bo gobi ki lindi o, ki cengi U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ke o lá ñinbiadi lie u kpenkunu. A jankpaanla bo jiidi ki ŋanbdi bi jankpaantiadi. ");
INSERT INTO guxg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ñinbiayengu den tie Simɔn yaagu. Jesu den kua lienni ki maadi o, ke wan fagdi waama yeni u kpenkunu, ama o den ye gu niinni ki tundi ku niwulgu. ");
INSERT INTO guxg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wan tundi ki gbeni, ke o maadi Simɔn: ... Sudi waama, ki jiidi naani n ñua, fini yeni a lieba n lu i jankpaantiadi. ");
INSERT INTO guxg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","... Ke Simɔn ŋmiani o, Canbaa, ti sɔni ñiamungu ti ki cuo lbá, ama, ŋan buali ke min lu yeni, n ba lu. ");
INSERT INTO guxg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bi lu ki cuo i jami boncianla ke bi jankpaantiadi ji bo bua padi mɔno. ");
INSERT INTO guxg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Li yogu ke bi yini bi lieba ku ñinbiagu po ke ban baa ki todi ba. Ban baa ke bi cuo ki gbieni bi ñinbiadi, hali ke ti bua mii kelima ku kpiagu po. ");
INSERT INTO guxg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔn Pieri n la lani, ke jiidi ki gbaani Jesu taana po ki maadi: ... N diedo, fagdi n kan ne, kelima n tie tuonbiiadaano. ");
INSERT INTO guxg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Li yogu ke i jewaani kua ba yeni ban la ya ciila. ");
INSERT INTO guxg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Li gɔ bo tieni yeni Simɔn tuonsɔnlieba, Saak yeni San, Sebede bila. Li yogu ke Jesu maadi Simɔn: ... Da jie! Lan cili mɔlane, a ji baa taandi bi niba n po. ");
INSERT INTO guxg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ban kpeni yeni bi jankpaantiadi, bi ŋaa ti kuli ki ji ŋua Jesu. ");
INSERT INTO guxg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Daatɔli, ke Jesu den ye dogu bá nni, ke jua bá ti baa ke mi kpaadma kubi o. Wan lá Jesu, ke o gbaani o nintuali nni, ki jaandi ki maandi: ... N Diedo, a ya bua, a ba fidi ki paagi nni. ");
INSERT INTO guxg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ke Jesu tandi o nugu, ki sii o ki maadi: ... Nn, n bua, paagi. Li yogu mɔno, ke mi gbaadma siedi ki ŋaa o. ");
INSERT INTO guxg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ke o kpaani o, ki maadi «ke wan da maadi nulo yaali n baa o» Ama, ke o maadi o ke wan gedi o dandanciamo kani ki ji bili o paabu li jaanddiebinbindli po nani Moyisi n den maadi maama yeni. Li ji baa nani sieda i i po. ");
INSERT INTO guxg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesu laabaali ji den yadi kaanakuli. Ku niwulgu ji den ŋua ki bua bi yiani n gbeni. ");
INSERT INTO guxg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama, o den gedi naani n kuoni ki ba jaandi. ");
INSERT INTO guxg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Daayenli, ke Jesu den tundi U Tienu laabamanli, Farisieninba yeni Yikotundkaaba den kaa ki cengi. Bi den ñani Gaalile, Sude yeni Jerusalemi dingbankonkogi nni. Ti Yonbdaano paalu den ye yeni Jesu ke o paagdi bi yianba. ");
INSERT INTO guxg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nibbá ti baa yeni bi yiamo ke o taana kuli kpe. Bi den kpaani ke ban kua yeni o Jesu kani. ");
INSERT INTO guxg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ama, bi den ki fidi kelima ku niwulgu po. Li yogu ke bi doni ki cibi li dieli poli po ki jiini bi yiamo ki lianga po, ku niwulgu siiga Jesu kani ");
INSERT INTO guxg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wan lá ke bi jaba yeni pia li dandanli o niinni, ke Jesu yedi: «N dɔnli, a tuonbiadi piini o». ");
INSERT INTO guxg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yikodanba yeni Farisieninba ji buali ki maadi: ... O ja ne tie ŋma i ki maadi ti majɔgndi? ŋma ba fidi ki piini ti biidi, li ya ki tie U Tienu bábá yaa ka? ");
INSERT INTO guxg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ama, Jesu den bani bi maalma, ki maadi ba: «Be ya po n cedi ke i pia li maalma? ");
INSERT INTO guxg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Be n tie faala? Maadi: «A tuonbiadi piini» bii «fii ki ya cuoni»? ");
INSERT INTO guxg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Li ŋani! I ba bandi ke o nulo biga pia yiko ki tinga ne po yeni wan piini ti tuonbiadi. Ke o ji maadi o tuomo: ... N cabi: Fii, taa a lianga ki ya kuni. ");
INSERT INTO guxg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Li yogu ku niwulgu nni, ke o ja yeni fii ki taa o lianga ki kuni ki dondi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","yaaba n den ye li kani kuli ke ti jawaandi cuo ba. Ke bi ji dondi U Tienu ki maadi: ... Ti lá dinne tin ki kpeli ki lá yaala ! ");
INSERT INTO guxg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Li puoli po, ke Jesu den pendi ki lá Patendi (Lonpo) Gaalo ke bi yii o, Lefi, ke o kaa o tuonli nni. Ke o yini o, ki maadi o: ... Ya ŋua nni! ");
INSERT INTO guxg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ke o ja yeni fii ki ŋaa li kuli ki ŋua Jesu. ");
INSERT INTO guxg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lefi bobni mi jaanma o denpo ki bua gaa Jesu. Bi niba boncianla den dini yeni Jesu, bi siiga a patendi gaala den ye. ");
INSERT INTO guxg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisieninba yeni Yikotundkaaba den ye bi bá ki yini Jesu Kpaaga. ... Be n tieni ke i ba di yeni a patendi gaala, ya febddanba ne? ");
INSERT INTO guxg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ke Jesu ŋmiani ba: ... Yaaba n pia laafia ki bua dogda, bi yianba n bua o. ");
INSERT INTO guxg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","yaaba n tiegi po ka ke n cua, ama n cua ke min lebdi ti tuonbiadi danba yama. ");
INSERT INTO guxg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bi tɔba den buali o: ... Jan ŋɔdikaaba yeni Farisieninba wani yen loli bu ñɔbu ki ya jaandi, ama Jesu ŋɔdikaaba wani yen di ki ñu i. ");
INSERT INTO guxg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","... Ke Jesu ŋmiani ba, i lá aa, li paa yeni o puodaano dɔnlinba n loli ñɔbu ke o puodaano dá ye yeni ba. ");
INSERT INTO guxg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","O yogu cuoni, ke o ba siedi ki ŋaa ba, li yogu bi ba loli ñɔbu. ");
INSERT INTO guxg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ki pua ba mi makpanjama ne: ... Nulo n da taa li cabpanli, ki libi li cabkpeli po. Lan yaa ka bi bua biidi li cabpanli. Ban jia ya cabli n mɔ n ki ŋani ki libi li cabkpeli. ");
INSERT INTO guxg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Li tie yeni mɔ, nulo kan piagi mi daakaama a cuakpela nni, lan yaa ka mi daama ba fidi ki cedi ŋan pudi pudi, mi daama n wuli, a cuana mɔ biidi o. ");
INSERT INTO guxg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Li buali, ke n ń piagi mi daapaanma a cuapaana nni. ");
INSERT INTO guxg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mɔmɔni, ti ya ñuni mi daakpelma, ti ji ki bua mi daapaanma; ti ji maadi: Mi bonkpelma n mani. ");
INSERT INTO guxg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Saaba daali, ke Jesu pendi i dii kpaabu nni, ke o ŋɔdkaaba togdi i dii ki ŋmani. ");
INSERT INTO guxg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisieninba buali ba: Be ya po i ke i tie yaala n kua saaba daali? ");
INSERT INTO guxg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu gaa mi maama ki ŋmiani ba: I ki cogi yaala n diani ya yogu mi koma bo cuo Daviid yeni o ŋɔdkaaba a? ");
INSERT INTO guxg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O kua ku jaanddiegu nni ki taa U Tienu lalaagu ki ŋmani, ki teni o ŋɔdkaaba ke bi mɔ ŋmani. Ama ke li nan bo ki cabi ke ban ŋmani, bi salyidkaaba bábá yaa ka. ");
INSERT INTO guxg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ke Jesu pugni ki maadi: O nufosaalo bijua n tie saaba canbaa. ");
INSERT INTO guxg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Saaba daatɔli ke Jesu kua ku jaanddiegu nni ki tundi U Tienu maama. Nulo bá bo ye ke o nujienu kpe. ");
INSERT INTO guxg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bi yikodanba yeni Farisieninba bo kpaani ke ban cuo Jesu. Bi bo kpaagi o ke ban diidi ki lia o ba tebi a yiama saaba daali i: ");
INSERT INTO guxg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama, Jesu n bo bani bi maalma yeni, ke o maadi o yiamo: ... Fii ki sedi asalasiiga! Ke o fii ki sedi. ");
INSERT INTO guxg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ke Jesu maadi yaaba n sieni: N pia ibuali ki ba buali yi: Li bo dagdi ke tin tieni li bonŋanli bii ke ku bonbiigu i saaba daali i? Li dagdi ke tin fie o nulo miali bii tin ŋaa wan kpe i? ");
INSERT INTO guxg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ke o ligdi o ninbina bi po ki maadi li naaciemo: Tandi a nugu! ke o tandi. Ke li nugu paagi” ");
INSERT INTO guxg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bi yikodanba yeni Farisieninba pala bo beni paaa, ke bi ji maadi bi ŋmiali nni ban ba taani ki tieni Jesu maama. ");
INSERT INTO guxg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lan daali, ke Jesu gɔ fuadi ki doni li juali po ki ba jaandi. Ke o jaandi U Tienu ku ñiamungu kuli. ");
INSERT INTO guxg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","lan ti fandi ya yogu, ke o yiini o ŋɔdkaaba, ki lugdi bi siiga piiga n bonblie ki yini ba o ŋɔdkaaba. ");
INSERT INTO guxg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simɔn yua ke o bo yini o Pieri, o ninjua Andre, Jaak, Jan, Fiilipi, Batelimi, ");
INSERT INTO guxg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiog, Toma, Saaki, Alfe bijua, Simɔn yua pali kɔni u dogu po. ");
INSERT INTO guxg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jude, Jaaki bijua, yeni Juda Iskariyɔti yua n ti ba juodi ki kuadi o. ");
INSERT INTO guxg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesu n bo ñani li juali po ki jiidi yeni ba, ke o sedi li gbangbanli po. o ŋɔdkaaba boncianla bo ye li kani, bi niba boncianla mɔ bo ye ki ñani Jude kuli nni, yeni Jerisalemi yeni Tiri dingbana nni yeni Sidɔn dogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bi kuli bo baa ke ban cengi o, ki wan gɔ paagi ba. Yaaba ke asanpola bo mabi ba mɔ bo paagi. ");
INSERT INTO guxg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yua bo kpaani ke wan sii o kelima ke u paalu bo ña o gbanu nni ki paagdi i yiani buoli kuli. ");
INSERT INTO guxg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","jesu bo gbagi ki diidi o ŋɔdkaaba ki maadi ba: Li pamanli tie yinba yaaba n tie talgnba yaali kelima yinba n ti baa ye U Tienu Diema nni. ");
INSERT INTO guxg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Li pamanli tie ynba yaaba ke mi koma pia yi mɔlane yaali, kelima i ti ba guo. li pamanli tie yinba yaaba n buudi mɔlane kelima i ti baa laa i. ");
INSERT INTO guxg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bi niba ya ki bua yi, ki bieli yi, ki sugdi yi, ki biidi i yela kelima o nufosaalo bijua po, li pamanli baa tie i yaali. ");
INSERT INTO guxg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Li bona ya ti baa yi, yin ya kpanbi leni li pamanli kelima i ñuadi ti baa yabi U Tienu deni. Bi yaajanba mɔ bo tieni U Tienu tondkaaba yeni. ");
INSERT INTO guxg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ama, yinba a piada, li ti baa bia i po kelima i lá ñuadi o. ");
INSERT INTO guxg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yinba yaaba n guo mɔlane, li ti baa bia i po kelima mi koma ti ba cuo yi. Yinba yaaba n laa mɔlane, li ti baa bia i po kelima i ti ba cagni, ki ya ye li pabɔncianla nni. ");
INSERT INTO guxg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Yinba yaaba ke bi niba kuli pagi yi, li ti baa bia i po kelima bi yaajanba mɔ bo tie yeni leni ku faagu Tienu tondkaaba. ");
INSERT INTO guxg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yinba yaaba n cengi nni ne kuli, n bua maadi yaala ne: Ya bua man i nannanda, ya tie man mi ŋanma yaaba n ki bua yi po; ");
INSERT INTO guxg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ya jaandi man ki ya miadi mi yedŋanma n jiidi yaaba n polgi bu ñɔbu po. Ya jaandi man yaaba n cagni po ya po. ");
INSERT INTO guxg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nulo ya pabi a tankpinyenli ŋan teni o tankpintɔli mɔ. Nulo ya taa a liadbiga ŋan cabi o a liadgbengli mɔ. ");
INSERT INTO guxg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yua mia ŋa ŋan teni o. Yua taa a bonla mɔ ŋan da buali o li po. ");
INSERT INTO guxg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ya tie man i lieba yin bua ke ban ya tie i po yaala. ");
INSERT INTO guxg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","I ya bua yaaba n bua yi bábá, i maali ke i ba lá ya paabu n ŋani i? Bi tuonbiaddanba mɔ bua bi dɔnlinba. ");
INSERT INTO guxg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","I tie mi ŋanma yaaba n mɔ tie yi mi ŋanma, i gɔ ti ba baa ti laa ñuadi i? Bi tuonbiaddanba mɔno ki tie mi ŋanma a? ");
INSERT INTO guxg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","I ya kpendi man ki daani ke bi ba guani ki ŋmiani yi, i gɔ ba lá ti bulcindi i? Bi tuonbiaddanba mɔ kpendi bi tuonbiaddanlieba ke ban guani ki ŋmiani ba. ");
INSERT INTO guxg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama yinba, yin ya bua man i nannanda ki tie ba mi ŋanma, ya kpendi man ki da daani ke ban guani ki ŋmiani yi. I ya tie yeni i ñuadi ti baa yabi, i ti baa tie O Bado U Tienu bila kelima u ŋanbdi yaaba n ki tie mi ŋanma yeni bi tondanba. ");
INSERT INTO guxg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","I báa gbie yeni mi ŋanma. Mɔ ya tie man yeni. ");
INSERT INTO guxg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Da bu a lieba, bi kan bu a mɔ, da biandi a lieba, bi kan biani a mɔ. Ya di man sugli i lieba po, U Tienu ba di sugli i mɔ ya po. ");
INSERT INTO guxg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ya todi man i lieba U Tienu mɔ ba todi yi. U den bibni ya golungu n yabi ki ñagi ñagi ke li gbie ki yadi ki wulgi n po, kelima yin bigni maama ki puuni i lieba, U Tienu mɔ ti ba bigni yeni ki teni yi. ");
INSERT INTO guxg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","O pua ba mi makpanjama ki maadi ba: O juamo ba fidi ki dadi o juanlielo? Ban bonblie kan baa ku buogu nni? ");
INSERT INTO guxg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tuonbanglo ki cie o canbáa. Ama ya tuonbanglo n ŋanbi ki bangi ki gbeni, o baa tien nani o canbáa yeni. ");
INSERT INTO guxg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Be n cedi ke a nua ya muanu n ye a ninjua ninbili nni, ama ki nan ki nua ya dajenli n ye a ya ninbinli nni? ");
INSERT INTO guxg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A ba tieni ledi ki maadi a ninjua: «N ninjua tieni suo ke min ñani u muanu yu n ye a ninbinli nni? ŋalacidaano! Dá pandi ya daagu n ye a ninbinli nni o, ki ŋanbi ki nuali ki fidi ki ñani u muanu yu ye a ninjua ninbinli nni. ");
INSERT INTO guxg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ki tinŋanga kan loni ti luanbiidi. Tibiigu mɔ kan loni luanŋana. Bi bani tibu kuli yeni bu luana i. ");
INSERT INTO guxg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bi ki puadi kankana konkontibu po, bi gɔ ki puadi cancanba konkonbɔngu po. ");
INSERT INTO guxg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","O numɔno n pia ya bonŋana o pali nni, o ñangi lani. O nubiigu n mɔ pia yaala o pali nni, o mɔ ñangi lani, kelima o nufosaalo pali nni n gbie yaala o ñangi lani. ");
INSERT INTO guxg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","be n cedi ke i yii nni “Yonbdaano, Yonbidaano”! ki nan ki tie min maadi yaala? ");
INSERT INTO guxg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","N bua waani yi yua cuoni n kani ki cengi n maama, ki gɔ tie man buali maama, yenyienu n naani yeni yaala. ");
INSERT INTO guxg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","O tie nani ya nulo maa ku diegu. o gbiidi ke li ñuagi ki pan nandi ku tantiagu ki bili li fiagli. Ku bɔngu ya gbie ki yadi, mi ñima yi yili li diegu, ki nan kan ki guli gu kelima bi maa gu ke ku paa. ");
INSERT INTO guxg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama yua cengi n maama kaa tie man buali maama o tie nani yua maa ku diegu ti tandi po kaa bili li fiagli. Ke ku bɔngu ya gbie ki yadi, ke mi ñima yili li diegu, ku ba wobi ki baa li yogu mɔno ki kpandi ku langbengu. ");
INSERT INTO guxg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wan maadi ku niwulgu wan pia ya maama, Jesu kua Kapernaumi. ");
INSERT INTO guxg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sijenba canbáa bo pia o tuonsɔnlo, ke o yia, ki ji mi kuuma po. ");
INSERT INTO guxg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wan gbadi ke bi maadi Jesu maama, sije canbáa sɔni o kani nani Suifi yikodanba ŋa yeni, ke bi gedi ki fabni o kani ke wan cua ki paagi o tuonsɔnlo. ");
INSERT INTO guxg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bi cua ki lá Jesu ki mia o sugli boncianla ... Bi maadi o, o ja ne dagdi yeni ŋan ŋanbi o po. ");
INSERT INTO guxg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kelima, o bua ti buolu. Wani n maa ti po ti jaanddiegu. ");
INSERT INTO guxg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lani, ke Jesu yegi leni ba ki caa. Li ji bo ki fagi leni deni, ke sijegbengli yeni sɔni o dɔnlinba ke ban maadi o. Ti Yonbdaano, da mabndi a bá, kelima n ki dagdi leni min gaa n denpo. ");
INSERT INTO guxg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Lan ya po n cedi, ke li bo ki dagdi yeni min cua n bá ki lá ŋa. Ama, maadi lanbonyenla ke n tuonsɔnlo n paagi. ");
INSERT INTO guxg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kelima, min mɔno tie sije yua n juadi, ama n pia bi naacenba n yikodi po, leni min sɔni yendo: “Gedi”, o baa caa i, n maadi tɔo: “Cua”, o baa cuoni i. N ya n tuonsɔnlo: “Tieni ne”, o baa tie i. ");
INSERT INTO guxg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu n gbadi li maama, ke li lidi o, ama ki mangi o. Ke o gbagi ki maadi ya niwulgu n ŋua o: “Mɔmɔni po, Israyeeli nni ne kuli, n ki baa lá ya nulo ke o pia ya dudugdi ne.” ");
INSERT INTO guxg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sije yeni tondkaaba lebdi deni ki sua ke o tuonsɔnlo paagi o. ");
INSERT INTO guxg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Li kani ke Jesu kua Nayini dogu nni. O ŋɔdkaaba leni ku niwulgu boncianla ciandi o. ");
INSERT INTO guxg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wan cili ki kua u docamu nni, ki cendi ku niwulgu ke bi pii li pakuali biyendga. Bi dogtieba boncianla bo ŋua a kupiila. ");
INSERT INTO guxg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","T yonbdaano lá li pakuali ke mi ninñima cuo o, ke o maadi: ... Da buudi man! ");
INSERT INTO guxg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ke o nagni ki kulianga ki maani o nugu ki po, ke yaaba n tugi sedi.... Ke Jesu yedi, o naaciemo, n cabi a fii. ");
INSERT INTO guxg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ke mi kuuma fii ki kali ki maadi. Ke Jesu ŋmiani o o naá. ");
INSERT INTO guxg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ke bi niba kuli jie, ki ji dondi U Tienu ki maadi: U Tienu cua ki bua fie u niba. Ki gɔ pugni: U Tienu cua ki tebi o kpiemo! ");
INSERT INTO guxg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ya lanbona ke bi maadi Jesu po ne bo yadi Suude leni li dogkuni kuli. ");
INSERT INTO guxg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jan ŋɔdkaaba maadi o yaala n den tieni kuli, ke bi siiga, ke o yini bonbilie. ");
INSERT INTO guxg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ki sɔni ba ti Yonbdaano kan ke ban buali o: ... Fini n den cuoni bii, tin gɔ dá guudi tɔo i? ");
INSERT INTO guxg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ke li danba sedi o nungi nni ki maadi o: ... Jan-Baptisti n sɔni ti. Yaala ke bo bua buali a nne: “Fini n den cuoni bii, tin dá guudi Tondtɔo i?” ");
INSERT INTO guxg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ya yogu ke o pundi li kani Jesu bo paagi ni niba boncianla, i yianbuolbuoli kuli, ki paagi yaaba n den gbie leni mu cicibiadmu, ki nuali a juama boncianla. ");
INSERT INTO guxg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ke Jesu maadi ba: Guani man Jan kani ki dugni o yin lá yaala: Bi juanba nɔnli, a waba cuoni, a gbaada paagi, a tubkpaana gbadi, ke bi kpienba yiedi, ke talginba gaa li pamanli. ");
INSERT INTO guxg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pamanli lenli yua luni o dudugdi kelima n ya po. ");
INSERT INTO guxg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jan tondkaaba den lebdi yo, ke Jesu ji maadi leni ku niwulgu Jan po. ... I gedi ki lá be mi tinfanma nni? U faalu n liebi ya ñinmuagu ne. ");
INSERT INTO guxg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","I gedi ki lá ŋma i? Yua bobi ti tiadŋandi? Yaaba n bibi ti tiadgbengdi ki ye u manu nni kua bi badcianba diedi nni. ");
INSERT INTO guxg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ama i ji gedi ki lá ŋma i? U Tienu tondo? N maadi yi, o cie U Tienu tondo mɔno. ");
INSERT INTO guxg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kelima, o ya po i ke li diani: N ba sɔni n Tondo a nunga nni, wan bobni a sanu. ");
INSERT INTO guxg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","N maadi pua n mali yua kuli, ama yua n yabi ki cie Jan ki ye, yua n wa U Tienu diema nni n yabi ki cie o. ");
INSERT INTO guxg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","... Ya niba n den cengi o kuli leni a lonpogaala den dugi U Tienu po mɔmɔni, ki tuo ki Jan n wulbi a U Tienu ñima. ");
INSERT INTO guxg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama Farisieninba leni U Tienu bali maama tundkaaba yie ke o kan wulbi ba U Tienu ñima, bi luni U Tienu buama. ");
INSERT INTO guxg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","N ba nangi mɔlane niba leni be i? Bi naani leni be? ");
INSERT INTO guxg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bi tie nani ya bila n kaa ki daaga nni, ki yii bi lieba ki tua: «Ti piebi yipo mu yelmu, ke yii jeli ki ciaga! Ya yogu ke ti gɔ yiini mi kuuma yani, yi gɔ ki buudi ! ");
INSERT INTO guxg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Lani, Jan-Baptisti cua, kaa ŋmani kpanu, kaa ñuni ku daamɔngu. Yi maadi be i? “O pia cicibiigu o niinni. ");
INSERT INTO guxg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","O nulo bijua cua ki di ki ñu, ki i yigni: “O ja ne maalma tie wan di ki ñu i, o tie a lonpogaala leni ti tuonsɔnbiaddanba dɔnlinba.” ");
INSERT INTO guxg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ama, U Tienu yanfuoma cua yaaba n tua ma po i. ");
INSERT INTO guxg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisieni den yini Jesu ke wan je. Ke Jesu gedi ki kali ki di. ");
INSERT INTO guxg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ke puoconconli bá cua, ke yua kuli o u dogu nni, ke o ye ku yenyebiigu nni. Nani, wan bo gbandi ke Jesu cua Farisieni deni ki di yeni, ke o taa o tulaali konkonga. ");
INSERT INTO guxg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ki cua ki sedi o puoli po, kpiani o taana. Ki buudi ke o ninsiidi pan milgi Jesu taana; ke o taa o yudi ki fiadi fiadi, ki balgi Jesu taana po, ki tiendi tulaali. ");
INSERT INTO guxg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisieni yua bo yini o yeni n lá lani, ke o maadi: O ja ne ya bo tie U Tienu tondo yeni mɔni, o bo ba bandi o pua yua siigi o ne n ye ya yenyienbiigu nni. ");
INSERT INTO guxg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesu doni o nialu ki maadi: ... Simɔn n pia maama bá ki bua maadi ŋa. ... Ke Farisieni ŋmiani o: Nn, Canbá́a, maadi. ");
INSERT INTO guxg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","... Niblie n bo dini li panli bi pandaano kani. Nuyendo den ba pa dibala kobiimu, yua tua mɔ n pa dibala piimu. ");
INSERT INTO guxg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nani ban bonblie kuli, obá n bo ki pia ki ba pa li panli yeni, ke o pandaano cabi ba ke ban da pa. A ya po, ban boblie siiga ŋma n ba ŋanbi ki bua o pandaano? ");
INSERT INTO guxg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔn ŋmiani: ... N maali ke yua ya panli n ŋanbi ki yabi. ... Jesu maadi o ke o jiini li po n yeni. ");
INSERT INTO guxg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ki gbagi ki diidi o pua yeni ki gɔ maadi: ... A lá o pua ne i? To, min cua a deni, ŋaa teni nni mi ñima ke n ba ŋuudi n taana; ama, wan taa o ninsiidi ki ŋuudi n taana, ki fiadi a leni o yudi. ");
INSERT INTO guxg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A ki lɔni nni ki waani nni a buama, ama, wani, hali min kua ne, o li lɔngi n taana i. ");
INSERT INTO guxg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A ki sɔgi n yuli po tulaali, ama wani, o wuli n taana po tulaali. ");
INSERT INTO guxg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lan ya po, n maadi a: O tuonbiadi kuli piini, li po n cedi ke o waani nni o buama kuli. Yua ke bi dini sugli o po waama nne, wangi o buama waama nne i! ");
INSERT INTO guxg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ki ji maadi o pua: ... A tuonbiadi kuli piini. ");
INSERT INTO guxg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wan n den yini yaaba ki pugni o po ji maadi bi bá nni: “O ja ne tie ŋma i ki piindi bi niba tuonbiadi?” ");
INSERT INTO guxg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ama, ke Jesu maadi o pua: ... Kelima, a dugi n po, a baa mi faabma; ya caa leni li pamanli. ");
INSERT INTO guxg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lan den pugini waami, ke jesu gedi a longbanani yen i dogiciamani, k muadi U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","O Den ye yen o ŋuankaaba piig n bonbilie, yen bi puobi yaaba kuli den bieli t cicibianda ke gɔ paagidi bi yiama: Mari, Magidala pua yua ko den paagu k cicibiada lele den kub bo. ");
INSERT INTO guxg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Sann, chuza denpua, chuza den tie Herod tuonsɔnli, Suzann yeni o lieba kuli den todi jesu yeni o ŋuankaaba yeni bi ŋalimanu ");
INSERT INTO guxg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","O nuwuligu den ñan a longbana nni k cua o kani, k jesu pua ba ya maa kpanjama ne: ");
INSERT INTO guxg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","O kpakpaalo den ñani, ke bi pagi o bonbi, wan den pagi yeni, ke mi bonbima baa o sankuni, k bi ŋmaadi, ke ti bonyugiti dini. ");
INSERT INTO guxg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tianli baa a tana ni ke pani ke kpe, kelima i tinga den kuoni. ");
INSERT INTO guxg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Li tianli mɔ baa ti konkondi ke pani, ama ti konkondi fii ki luoni li po. ");
INSERT INTO guxg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ke li liela baa i tinŋanga po, ke pani ke loni a luana. Jesu pugini ke maadi: ... yua pia a tuba ke cengi, wan cengi ");
INSERT INTO guxg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","O ŋuandikaaba bual'o l maa kpanjama niima ni. ");
INSERT INTO guxg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ko maadi ba: yinba la li yumanli gbia U Tienu diema ŋasiili, ama lieba po li tie maa kpanjama. Bi pia i nuni, ama bi naa nua; bi cengi, bi naa gbia. ");
INSERT INTO guxg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Diidi mani li maa kpanjama niima ni: U Tienu maama, ");
INSERT INTO guxg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“o sankuni” tie yaaba cengi mi maama, ama sitaan n cua ke kua bi pala ni ke bel'o, wan da daani li maama po ke la mi faabma. ");
INSERT INTO guxg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A tana po tie: yaabi n cengi mi maam, ke tuo yeni li pamanli, ama ke kan ŋa lan kpa jiina bi po. Bigili yogunu, wan sundi li kuli po. ");
INSERT INTO guxg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Mi bonbima yaali baa ti konkondini” wangidi, yaaba cengi mi maama, ama ke ŋa mi maalima, mi piama yen li ŋandunli bona n cedi wan da loni luana. ");
INSERT INTO guxg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Mi bonbima yaali baa i tinnŋanga ni”maadi ti, ya niba n cengi U Tienu maama ke biligidi bi pala ni ke suani yenli li tuonli, ke puni li juunli ke loni a luana. ");
INSERT INTO guxg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","... Bi ki congi fidili ki cubidi bobili ni bii k wuondi gadogu yagima nni, bi yi tuani naani ke bi niba ya kua, ban la mi yinyema. ");
INSERT INTO guxg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yaali wuo mɔlane kuli, te bi juodi ke ña mi yinyema nni yen ya bonli n tie ŋasiili, te ba dogidi li daa gbengili daali. ");
INSERT INTO guxg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ŋanbi mani ki diidi i yula po, yin cengi maama, kelima, yua pia bi ba pugini wani; ama yua pia, ban gaa wan daani ke pia yaali. ");
INSERT INTO guxg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu naa yen o ŋuandikaaba cua ki lagu, ama bi bo ki fidi nagin'o ki dugini o nuwuligu po. ");
INSERT INTO guxg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ke bi maad'o: a naa yen a ŋuandikaaba ye cincanli ki kpaan'a. ");
INSERT INTO guxg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","... N naa yen n ŋuandikaab tie yaaba n cengi U Tienu maama, ki gɔ tugidi k suani li tuonli lan buali maama. ");
INSERT INTO guxg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Daa yenli k jesu den kua o ñin biaguni wan i yeni o ŋɔdkaaba. Yeni ko maadi ba:... tin puodi mani bongbantianli po. K bi tugi o ñin-gbanu. ");
INSERT INTO guxg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ban bo puodi ya yogunu, k jesu guandi. Ko faaciangu kpil k fidi o ñinbɔnguni. Mi ñima den bua cubini o ñinbiagu. Li ji den paa bi po. ");
INSERT INTO guxg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","K jesu ŋɔdikaaba den nagini ki yigini ki fiin'o: canbaa, canbaa mi ñima bu di ti naa. Ko findi k gaa mi jama o faalu yen a ñinguona po, k li kuli sedi suoo. ");
INSERT INTO guxg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Li puoli po ko maadi o ŋɔdikaaba:... i dindanli ye le e? ti jawandi yeni o yaalidigu den kua ba, k bi maadi bi ŋmialini: O ne tie ŋma i? diidi mani: o pia ti yikodi o faalu yeni a ñinguona po, k bi cɔlini o. ");
INSERT INTO guxg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","B ji bo kua Gerasa doguni, li bo ye Galile nuntuali. ");
INSERT INTO guxg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ya yogunu k jesu bo tugi o taali ki ŋmaa i tinga po, o doguni o nulo yua k ti cicibiadi bo kub'o yeni, bo sani ki cend'o. O den ki yie tiadi ki gɔ ki kpendi deni, ama o den yi dua a kakula nni. ");
INSERT INTO guxg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ya yogunu ko la jesu, ko baa ki gbaani o taana po ki yigini yeni o paalu kuli. ... A bua be n po, jesu, U Tienu badicamo biga? N miad'a sugili, da wangidini fala. ");
INSERT INTO guxg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","O bo maadi yeni kelima jesu bo cedi k ti cicibiadi kuli siedi ki ŋagu. Yeni ban bo yi lol'o yeni i kudiseseli a taana yeni o nugi, o bo yi cie li kuli, ti cicibiadi n tug'o ke kua yen'o li fuali nni. ");
INSERT INTO guxg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu bual'o: ... A yeli i? ... ŋmian'o: ti yabi. Kelima ti fuobiidi boncianli den ŋuagu. ");
INSERT INTO guxg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Li fuobiidi den miadi jesu sugili k wan da kuan ba naani tie fala kangbediguni. ");
INSERT INTO guxg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Li den sua ki duoli boncianli den kobi li kani k bi kpaab li juali po. K ti cicibiadi ne mia jesu sugili, k wan cabi ba, k ban gedi ki kua li duoli nni. Ko cabi ba. ");
INSERT INTO guxg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","K bi ŋaa li ja, ki ji kua li duoli nni. Ki li duoli ñani li juali, k san sani ki baa mi ñima nni kpe. ");
INSERT INTO guxg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A duogula n la yeni, ki bi sani k gedi ki pagi o dogu nni, yen i dogbanbimu nni ");
INSERT INTO guxg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","K bi niba ña, k caa ki diidi yaali bo tieni. Bi bo pundi jesu kani, k la o ja yua k ti fuobiidi bo siedi kani yeni, ko kaa jesu taana po. O den la ti tiadi, ki li ba kuli ji k kub, o. Ti jawandi den kua ba. ");
INSERT INTO guxg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yaabi bo la ya bona n bo tieni kuli lan kani, ki bi dugini maama ki ti fuobiidi yaadi k ŋaa li ja, ko ji la mi faabima. ");
INSERT INTO guxg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerase dogu niba kuli, ti jawandi bo kua ba boncianli. K bi maadi jesu k wan ña bi dogu nni. Ko guani k kua o ñinbiagu nni k lebidi ");
INSERT INTO guxg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ko ja yua ti fuobiidi bo ñan o kani yeni, buali jesu k wan cian'o, ama jesu bo bel'o, k maad'o: kuni a deni k pan waan ba, yaali ko tienu tieni a po. ");
INSERT INTO guxg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ko kuni ki pagi yaali n tieni ne kuli. ");
INSERT INTO guxg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wan den guani galile, bi niba boncianli den gagu kelima bi den gu o baama. ");
INSERT INTO guxg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Li yogunu ja ba cua jesu kani ko yeli tie jayiris, o den tie o jandieguni canbaa. Ko baa k gbaani jesu taana po ki miagu sugili k wan cua o deni. ");
INSERT INTO guxg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","O bonpuoyenga ko pia nani piiga yen bina lie yeni, k den mɔ yeni mi kuuma. K jesu fii k gedi o kani, ko nuwuligu tudi k mɔ ban nagini jesu kani. ");
INSERT INTO guxg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Li kani pua ba den ye ki wuuli o faadi kli k koligidi, hali piiga yeni bina lie. O bo biani o ligi kuli dogida deni, ama o bo ki fidi ki tebi o ba. ");
INSERT INTO guxg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ko nagini jesu puoli po ki sii o liadili, ki li yogunu mɔno, ko faadi sedi. ");
INSERT INTO guxg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","K jesu buali: ... ŋma n sii nni? Nani bi kuli n bo tieni mi niama, k Pial maadi: ... canbaa, tin diidi mani, o nuwuligu lini ki maba. ");
INSERT INTO guxg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama kop ŋmian'o: ... o nulo sii nni, kelima mi tuama o paalu ñani n gbano nni. ");
INSERT INTO guxg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wan bo la li kuli k li k tie wuolin bonli, ko pua nagini, ki jegili, ki baa ki gbaani jesu taana po k cili ki dugidi yaali ya po ko siigu yeni wan paag'o maama toma. ");
INSERT INTO guxg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","K jesu maadi li pua: ... n bipuoga, a paagi ki dugini a dindanli yabi n po. Ya caa k laafia n cian'a ");
INSERT INTO guxg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","O da den k maadi ki gbeni, ko nulo ñan li jandidieli nni canbaa deni, k maad'o: a jafaanu kpe o, ji da mabi canbaa. ");
INSERT INTO guxg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesu den gbadi li maama, ko maadi Sayiris: ... da jie, ya duu n po baba, a jafaano ba paagi. ");
INSERT INTO guxg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wan pundi deni, o ki cabi ki nulo ba kua, lan ñani: Pial, San, Sak yeni i biga náa yeni o baà. ");
INSERT INTO guxg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kaana kuli den tie: bubuuli yeni i fanfabini. K Jesu maadi: da buudi mani, o ki kpe ka, ama o guandi. ");
INSERT INTO guxg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bi niba den ñuadi laagu ki ban nani ko kpe i. ");
INSERT INTO guxg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeni k jesu cuo i bonpuo biga nugu, k maadi yeni o paalu: ... n biga fii! ");
INSERT INTO guxg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","O den guani ki fuodi, k fii, k jesu maadi: k ban ten'o mi jiema wan je. ");
INSERT INTO guxg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","K li yaa ki lidi o dama. Jesu den kpaaba tiadiba, k ban da ŋa bi niba n bandi yaala n tieni. ");
INSERT INTO guxg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","jesu bo taan o kpaaga piig n bonblie, k ten'b o paalu yen t yiko k ban bel t fuobiid(staan) k gɔ paagi b yiama. ");
INSERT INTO guxg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","L puol po ko sɔn'b k ban kpaandi o laabamanli i tinga kul po, k teb i yian buol kul. ");
INSERT INTO guxg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Oden cegli ba: i da tugdi man lba k l nua i cenli po: lan tie lanbanli, bɔgli, ligii k bual jiedi po. da kpaani man ya tiadi ki ba lebdi. ");
INSERT INTO guxg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bi ya gaa yi ya diegun, yin ya ye hali ya daali ki ba siedi lan kani. ");
INSERT INTO guxg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nulo ya ki gaa yi naan kani, yin ña lan kani k pidi lan ya doguni tanbiini yaali n tabi i taana, lani baa tie yaali wangi i buama b po. ");
INSERT INTO guxg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yeni ko kpaaga fii k gedi. B den tɔgdi a longbana nni. kaana kuli, b den maadi U Tienu maama k gɔ tebi bi yiama. ");
INSERT INTO guxg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","O badciamo Herodi bo tie lan ya dogu nni yikodaano, wan bo gbadi ke tiama maadi ke sua: “San batiir” n yied bi tinkpiiba siign, ");
INSERT INTO guxg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","bi tɔba ya po “Eli n guani”, bi tɔba mɔ gɔga ya po “l tie U Tienu tondi siigni yendi guani”. ");
INSERT INTO guxg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ama k Herodi jiin ;... San? Min mɔno n cabi k bi jagdi o yul. To, o daano tie ŋmaa i k bi maadi o po ya yaalidgu bona ne kul? O bo kpaani ke bua wan band'o ");
INSERT INTO guxg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposoronba bo guani ke dugni jesu ban bo tieni yaal kul. k Jesu tugi ba k piad waam, l bo ke fagi yen ya dogu k bi yi Bedsayida. ");
INSERT INTO guxg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ama bi nibi n bandi ban ye naani, k bi fii k ŋua. Yesu gaaba k cili k maadi ba o laabamanli, k tebi yaaba n bo yia k suni k ban paagba. ");
INSERT INTO guxg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","O dajuogu n nagi ya yognu ko yienu cil m baama, k aposoronba piiga n bonba lie nagni jesu kan maadi yen'o: cabi k ban ged ya longbana kɔb yen ne, k baa o duankaanu yen l bonjekaali (mi jiema) klma tin ye naan tie fualin ni. ");
INSERT INTO guxg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ama k jesu maadi o kpaaga: yinbi mɔno n tenba m jiem ke ban je. Ama ko kpaaga ŋmian'o, tin pia yaal k cie kpanu bona mu yen i jami bona lie. k t ji bu tien ledi ba m jiem ya nib ne kul po i? ");
INSERT INTO guxg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","klma b tie nibi tuda mu i. Jesu maadi o kpaaga: tien man cagli kul nibi piimu k cedi ban kali. ");
INSERT INTO guxg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","B cɔlni o maama k kaani b kuli. ");
INSERT INTO guxg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","K jesu tugi kpano bona mu yen i jami bona lie, k yaadi k diidi pol po k jaandi k yadi m yediŋanba, l puol po ko jend jendi, ko kpaaga tugi k bɔgdiba k ban di. ");
INSERT INTO guxg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","K bi kuli dini k l sieni baabuodi piig n bona lie. ");
INSERT INTO guxg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dayenli k jesu piadi k ba jaandi, o den ye yen o kpaaga, k jesu bualiba... b nibi ne mali k n tie ŋmaa i? ");
INSERT INTO guxg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","K b jiin'o Tɔba ya po a tie San-batiir, tɔba mɔ ya po Eli, tɔba mɔ gɔgi maadi k U Tienu tondi ya yognu po yendi n guani k yiedi b tinkpiiba siign. ");
INSERT INTO guxg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","K Jesu buali ba, i ya po, i tama k n tie ŋmaa i? Piel gaa m maama k jiin: a tie Jesu, U Tienu n sɔn yua bijua. ");
INSERT INTO guxg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","da ŋa man nulo n gbandi. ");
INSERT INTO guxg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","K Jesu pugni k maadi: l bual ko nulo bijua n la fala boncianli ko doguni yikodam yen l gbanbanda n cuon, k kpani, k min yiedi danata daal. ");
INSERT INTO guxg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yeni Jesu maadi yeni bi kuli, ya daano bua k wan ŋɔdni, l bual k wan yie o ba, k tugi o dapɔnpɔnli, daal n tu daali k ŋɔdni. ");
INSERT INTO guxg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yen i mɔn, yua bua kuogi o miali, o ba buonga toma, ama, yua ya buoni o miali k dugni min ya po, wani ba la ya miali k pia gbema. ");
INSERT INTO guxg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nulo ya tugi li ŋandunli bona kuli k li cie U Tienu, k nan ba kpe, o pia m laa ñuadi? ");
INSERT INTO guxg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nulo ya jien i fee k gɔ jie m maama mɔ i fee, o nulo bijua mɔ ya guanu daali o ba la n baa yudand yen o ninŋama kuli. ");
INSERT INTO guxg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yen i mɔni, i siigni b niba boncianli kan kpe k k la U Tienu diema ");
INSERT INTO guxg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Dana niini puoli po, k Jesu tugi Piel, San, yen Sak, k bi doni li juali k ba jaandi. ");
INSERT INTO guxg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ban jaandi ya yognu, ko nunga lebdi, ko tiadi ji pien k cie ti kunkundi. ");
INSERT INTO guxg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","K b niba bonba lie pagi yen'o: Moyiisi yen Eli. ");
INSERT INTO guxg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","k se k ñili k maadi yeni Jesu n ba kpe nanda Serusalem ni ");
INSERT INTO guxg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piel yen o lieba guandi ama k b fii k la Jesu se yen b niba bonba lie k ñili. ");
INSERT INTO guxg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Li niba n se ya yognu Jesu kani, k Piel maadi :... canba, l ŋan k tin ya ye ne. T bi maa jona taa i. Yenli n ya tie a yaal, o lielo Moyiisi yaal, o taalo mɔ Eli yaal. Yen lan ya kuli, piel ji bo k bani wan maadi yaal. ");
INSERT INTO guxg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","O maadi k da k juodi mɔno, k li tieni nani l ŋunli yeni k jiidi k libini bi po, ti jiwaandi kua jesu ŋuankaaba. ");
INSERT INTO guxg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","K bi gbadi o niali k li maadi li ŋunli nni k sua :... o ne tien n biga yua k n buaga k lugdo, yin ya cengi man o. ");
INSERT INTO guxg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ban gbadi l nialo, k bi ji diidi k la jesu se obebe. Ama bi ŋuankaabi den muubi bi ñɔna k ki maadi oba kuli ban la yaali. ");
INSERT INTO guxg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lan den fandi k jesu ñani li juali po k jiidi, k bi niba boncianli ŋuagu k kpaani k ban diidi o. ");
INSERT INTO guxg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","O nuwuligu siigni, bi gbadi ja ba ko yedi: canbaa, ŋan diidi n bijua npo. O tie n bonjayenyenga. ");
INSERT INTO guxg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","K cicibiadiga (fuobiidi) n fii o po, ko yigni k baali, ko siini ñinsankpinkpɔngu, ki jegli, ki ji nani mi kuuma. ");
INSERT INTO guxg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","N maadi a ŋuankaaba k ban beli li cicibiadiga k bi gbali. ");
INSERT INTO guxg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","K jesu tandi k maadi: be cedi ki dindanli pɔdi yeni yinbi kangbada buolu, u laa yogunu ki ba gbadi niimn ni. Yeni ko maadi li ja: cua yeni a biga na. ");
INSERT INTO guxg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","I biga n cuoni ya yogunu, k li cicibiadiga cedi ki biga baa k jegli. K jesu maadi yeni mi tuama li cicibiadiga po ko sani k ñani. Ko paagi li biga k tug'o k teni o baà. ");
INSERT INTO guxg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","K li yaagilidi bi kuli yeni U Tienu buama. Bi niba kuli pali den mani jesu palidi yeni o bulicidi po; ko maadi o ŋuankaabi: ");
INSERT INTO guxg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ŋanbi mani ke luod i tuba k ya tiani mi baa yedi yaali ne: bi niba ba kuadi o ja bijua, bi nisaaba nuu nni. ");
INSERT INTO guxg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama bi ŋuankaaba bo ki gbia, li maakpanjami bo duagiba. Ti jawaandi po, ke bi bo ke buali jesu ke ba bandi niima nni. ");
INSERT INTO guxg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bi den kpaani ke ban bandi yua n tie ciamo bi siigani, mi niama ji fii. ");
INSERT INTO guxg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesu bo bandi ban maliti yaali bi palti nni, ko tugi i biga ke sen'o. ");
INSERT INTO guxg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ke maadi ba: “yua gaa i naa biga n ya yeli po, o gaa min mɔno'i, yua ya gaa min mɔ, o gaa yua sɔn nni, kilima yua jiin o ba ke kpandi biga, bi ba kpiagidi wani wan tɔ ciamo. ");
INSERT INTO guxg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","San gaa m maama ke yedi: canbaà t la o nulo ko deli mu cicinbiadimu a yeli nni, ama ti delo ke wan da fandi ke tieni li liema, kilima o ki ŋua ŋan. ");
INSERT INTO guxg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ke jesu maadi, da deli mano, kilima ya nulo ki tie a nando i, lani ya nulo tie a donli. ");
INSERT INTO guxg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ya yogunu ke jesu bo jagi ke ba lebidi kuni o baa kani, ko fii kua Serusalem nni. ");
INSERT INTO guxg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","O bo sɔni o tondiba bonbi lie k bi kua liiga Samali longbanbigi nni ke kpaani li dieli. ");
INSERT INTO guxg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama ke Samali niba yie ke bel'o li dieli, ke dugini jesu bo maani ke caa Serusalema. ");
INSERT INTO guxg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","O tondiba n la ke li tie yeni, ke Sak yen San tandi ke maadi: ... canbaa, a bua ke tin cedi ko mu n ña poli ke biani b kuli fami ke ban tua fantama. ");
INSERT INTO guxg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ama ke jesu gbagi ke gaa ti jadi ke maadiba, i ke ban ki gbie yen fuoŋanbi, ki maadi ya maabiidi ne? O nulo bijua ke cua ke wan biani li ŋandunli ka, ama ke wan faabi bi niba ke tenbi ya miali k pia gbema. ");
INSERT INTO guxg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ke bi siedi lan ya kani ke gedi longbantianu. ");
INSERT INTO guxg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ban bo paani o sanu, ke ja ba cendi ke maadi jesu: ... N baa ŋua ŋa ŋan caa naani kuli. ");
INSERT INTO guxg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","K jesu ŋmiani l ja: 'I luali pia i fali, ti bonyugiti pia ti tiadi, ama o nulo bijua ke pia wan ba duani naani. ");
INSERT INTO guxg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","K jesu maadi o tian o: ya ŋuan! ... canbaa cabi ke min piini n baa o! ");
INSERT INTO guxg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","k jesu ŋmiani: “cedi bi tinkpiba n piini bi tinkpiiba”! ama fini, gedi ke kpaandi U Tienu maama kaana kuli ");
INSERT INTO guxg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ke o tiano mɔ gɔ maadi jesu. U Tienu n ba ŋɔdi ŋa, ama, cedi ke min gedi ke cabi n denpo. ");
INSERT INTO guxg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ke jesu ŋmian o: “ya daano ko yen naakuuli ke bia gbagidi ke diidi puoli, ke dagidi yen wan kua U Tienu deni. ");
INSERT INTO guxg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Li puoli po, ke O Diedo go lugdi o ŋɔdkaaba piilele (70), ki sɔni ba bilie lie ke ban liidi o u dogu po leni ya dongbana ke wani o bá bi ba gedi. ");
INSERT INTO guxg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ki maadi ba, “u bontaadu yogu pundi. ku kpaangu yabi ama a tuonsɔnla ki yabi. Tin mia O Diedo yua n die u kuanu, wan sɔni a tuonsɔnla o kuanu nni. ");
INSERT INTO guxg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ya caa mani. N suani yi nani mu pabimu yeni i yangbanli siiga. ");
INSERT INTO guxg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yin da taa ligbɔgli, ki da kubi sancenbɔgli ki buali taacaadi, ki go da biandi yaama i fuondi po u sanu nni. ");
INSERT INTO guxg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ke yin ba kua ya diegu nni kuli, yin cindi ki yedi, “Mi yanduanma ń ya ye ku diegu ne nni”. ");
INSERT INTO guxg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mi yanduanma nilo ya ye li diegu nni, i yanduanma baa ye leni o, li ya ki tie yeni, mi ba guani i po. ");
INSERT INTO guxg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yin ya ye lan ya diegu nni, ki di ki go ñu ban puni yaala, kelima o tuonsɔnlo dagdini o ŋmapani. Yin da ña diegu ki tuadi diegu. ");
INSERT INTO guxg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yin kua ya dogu nni kuli, ke bi ga i cangu, yin di ban candi yi yaala, ");
INSERT INTO guxg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ki paagdi yaaba n tie bi yiama. Yin yedi ba, “U Tienu diema nagi i kani”. ");
INSERT INTO guxg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama, yin ba kua ya dogu nni ke baa ga i cangu, yin ña ki cendi bi sanjala po, ki yedi, ");
INSERT INTO guxg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ti pidi i dogu ne ya taatama n tabi ti taana, ki guani ki yadi i po, ke lan tua tiadma i po! Ama yin ya bani yaali ne, “U Tienu diema nagini. ");
INSERT INTO guxg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","N maadi yi ke ti buudi daali, Sodoma buudi baa pia sugli ki cie lan ya dogu. ");
INSERT INTO guxg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","korasen, sola! Betsahida, sola! Ya yenmaaltuona n tieni i siiga ne ya bo tieni Tiiri leni Sidoni dogi nni, li dogi niba bo ba tuo ki lebdi bi pala hali ke li dá fagi, ki la ti yubɔntiadi, ki pugi bi bá mi fatanpienma. ");
INSERT INTO guxg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ama, ti buudi yogu, Tiiri leni Sidoni yaala baa pia sugli ki cie yinba. ");
INSERT INTO guxg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ke fini, Kapenawuma, a maali ke a ba duoni a yuli ŋaljanli nni bii? N n bi ba jiini a hali ku tinkpibuogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yua n cengi yi, o cengi mini i, yua n ki ga i maama ki ga mini ya maama i, yua n yie n maama yie yua n sɔni nni maama i. ");
INSERT INTO guxg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Li tondba piilele den guani leni li pamanli, ki maadi O Diedo, “Ti Diedo, ba ́ mu cicibidmu mɔno cɔlni ti maama a yeli po.” ");
INSERT INTO guxg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","K Jesu maadi ba, “N den nua Setaani ke o ñani ŋaljanli nni ki baa. ");
INSERT INTO guxg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Cengi mani, N puni yi ti yikodi, ke yin ya ŋmaadi i wee leni i nami leni yibali paaciamu po kuli. lan ba baa maama kuli, liba kuli kan fidi ki tieni yi yaala n bia. ");
INSERT INTO guxg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ama, yeni lankuli, yin da mangdi i pala ke mu cicibiadmu cɔlni i maama baba po ka, ama yi pala ń́ ŋanbi ki ya mani kelime i yela diani ŋaljanli nni” ");
INSERT INTO guxg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lanyognu liga, ke o pali mangi boncianli U Tienu foŋanma po, ke o yedi, “N dondi a, Báa, Tanpoli yini ki tinga Diedo, kelima a dɔgni lanya bona bi yanfodanba leni bi nunfandanba po, ki nan dɔgdi a yaaba n ki pia yama nani mu biñidmu yeni po. Nn, Báa, kelima, li den ŋɔdi a yanjagŋanli bonŋanla.” ");
INSERT INTO guxg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","N Báa duu n po ki, kubni nni a bona kuli, ke obá kuli ki ban Bijua ń tie yua, lan ñani Báa baba, obá mo ki bani báa ń tie yua li nan ya ki tie Bijua yaa ka, yeni Bijua ń bua yua ki ba dɔgdi o po. ");
INSERT INTO guxg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ki guani ki gbagi o ŋɔdkaaba po, ki maadi ba ŋasiili nni. “Mi yedŋanma yaaba n laadi yin laadi yaala. ");
INSERT INTO guxg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N maadi yi, sawalpuaba bonianla yeni bi badcianba den suni ke ban la yin laadi yaala, ki nan ki la ŋa, ke ban gbadi yin gbia yaala, ki nan ki gbadi ŋa. ");
INSERT INTO guxg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Diidi mani, jufinba yoko tundkaaba yendo ń fii, ki bua bigni Jesu, ki maadi, “Canbáa, N ba tieni ledi i, ki baa ya miali n ki pia gbenma? ");
INSERT INTO guxg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu ń buali o, “Be diani yiko tili nni? A cogi be li tili nni?” ");
INSERT INTO guxg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wan jiini ki maadi, “A baa bua O Diedo, a Tienu leni a pali kuli, leni a naano kuli, leni a paalu kuli, leni a yantiali kuli, ki go ya bua a nisaalilielo nani abá yeni.” ");
INSERT INTO guxg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu ń maadi o, “A jiini bonŋanla. Ya tie yeni, a baa ye ki fo. ");
INSERT INTO guxg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ama o tundka yeni den bua wan kuni obá i mɔni, ki buali Jesu, “ŋma n tie lielo?” ");
INSERT INTO guxg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ke Jesu jiini, “Nilo den ñani Jerusalema ki caa Jeriko, ki cendi bi sanjiaba, ke bi fie o tiadi kuli, ki pua ki janbi o, ke o nagni mi kuuma ");
INSERT INTO guxg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Li sua ke salga yidka kubi li sanu, ki ji, wan la o ja yeni, ke o jadi ki lɔgdi o, ki ban caa. ");
INSERT INTO guxg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lan go tieni yeni, Levi yua mo ń ya pendi, o mo ń la o, wan jadi, ki balni, ki pendi. ");
INSERT INTO guxg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ama, Samari yua n den caa u sanu, ki pudi o kani, Wan la o, o pali ń sia yeni ti niñinpadi. ");
INSERT INTO guxg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wan nagni, ki fiadi fiadi o nala, ki tieni mi kpama leni ku daamɔngu. Ki jagni o o ya ŋunbo po, ki ciani o ban gaani bi canba naani, ke bi kubi o lan buali maama. ");
INSERT INTO guxg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lan fandi, ke o ñani ligi lie ki teni o canguulo, ki maadi, “ŋan ŋanbi ki kubi lan buali maama. ligi ya pɔdi, ke a pugni yii kuli, N ya guani, N ba pa ŋa. ");
INSERT INTO guxg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bani bonbtaa siiga yeni, a maali ke ole n tie o ja yua baa bi sanjiaba sanu nni yeni nisaalilielo? ");
INSERT INTO guxg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","O tundka ń maadi, “Yua n gbadi o niñima yeni n tie o nisaalilielo.” Jesu ń maadi o, “Ya caa ki mo n ya tiendi yeni” ");
INSERT INTO guxg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ban paani u sanu ki caa, ke bi kua dogbiga bá ke li kani pua, ke bi yi o Marita biali o, ki mia ke wan tuo ki cani o deni. ");
INSERT INTO guxg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","O den pia o ninsalo ke o yi Maari. Ke o kali Jesu taana kani, ki cengi o maama. ");
INSERT INTO guxg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ama ke Marita gbaa leni a tuona, ki bua tieni mi bonjiema, wan nagni ki maadi Jesu, “O Diedo, ŋaa la ke n waalo ñɔli mini baba yeni a tuona aa? Lanwani, maadi o wan todi nni.” ");
INSERT INTO guxg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ama ke O Diedo jiini, ki maadi o “Marita, Marita a yagni a yama bona boncianli po, ");
INSERT INTO guxg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ama bonyenli baba n tie bonmɔnli, Mari lugdi yaali n ŋani ki cie, bi kan fidi ki fie la.” ");
INSERT INTO guxg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Daa yenli ki jesu den jaandi ki gbeni, ko ŋɔdikaaba siigni yendo bual'o: ti Diedo, bangi ti i jaandi nani San n bangi o ŋɔdikaabi maama yeni. ");
INSERT INTO guxg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","O den ŋmian ba: i ya baa jaandi, yin maadi ne: n baà yua ye aljandini, a diema pundi. ");
INSERT INTO guxg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Teni ti daali mi yentunjiema. ");
INSERT INTO guxg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","tieni sugli ti biidi po kuli nani tin tiendi sugli ti lieba po teni. K ya gu ti yeni li bigli yogunu. ");
INSERT INTO guxg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","K o pugni ki maadi: li tie nani ya nulo pia o donli ko baa o yogsiigu ki miagu: “kpendin kpano bona taa. ");
INSERT INTO guxg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kelima n donli ba ñani u sani k ba ki can nni, ama n nan k pia ba li bonjekaali ko ba je. ");
INSERT INTO guxg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Li ya sua k o donli ye jiin'o: “cedi k nfuodi, ki da mabi ni, n ganli luo, n k bidi mɔ duan'o. N kan fidi ki fii ki ten'a ");
INSERT INTO guxg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","n maadi, ba o ya kan fii ki ten'o ki li tie o donlugu po, o bi fii ki dugni li cɔnli po ki ten'o. ");
INSERT INTO guxg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yeni k n maadi: mia mani, bi ba puni; kpaan mani, i bu la; pua mani li ganli, bi ba luodi yin kua. ");
INSERT INTO guxg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kelima, bi tieni yua miadi, ki yua kpaani laadi, ki bi luodi li ganli yua kuogi po. ");
INSERT INTO guxg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Cegdi nba ye i siigni, ŋma ya po n kpeli ke teni o biga o waa ya yogunu k o buali o jamo? ");
INSERT INTO guxg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bii, o ya buali jenli po wan ten'o o namo? ");
INSERT INTO guxg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yinba bi biid dama, i ya bani yin teni i bidi a bonŋama, taalm ŋa i ki ti Diedo bi teni fuoŋanma yaabi n bual'o kuli? ");
INSERT INTO guxg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Daa yenli, ki jesu deli i cicibiadiga ja ba kani k o tie muuga. Li cicibiadiga n ñani li ja kani, k o ji cili maadi, ki li yaa ki lidi bi niba. ");
INSERT INTO guxg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","K bonciali ji cili ke maadi:... ne tie Belisebuul paalu po i, mu cicibiadimu canbaa, k o tugi ki bieli li cicibiadimu. ");
INSERT INTO guxg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","B tiama, ban den bua ban piugu ku diagu, ki bi bual'o ki wan tieni mi bama bii paligu k li ñani polu po ki ban diidi. ");
INSERT INTO guxg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama nani wan bo bani bi maalima k o jiin ba: o tɔbu n pua ya dogu, a diena yi baali, ki li ŋmadili ye. ");
INSERT INTO guxg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","I maal k n bieli mu cicibiadimu besebuul yeli po. Li ya tie yeni, mi bɔgidma bo ba tieni sitaani diema nni. O diema bo ba bia fanma. ");
INSERT INTO guxg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lan ni, li ya tie k n bieli mu cicibiadimu belsebuul yeli po, ŋma nan tieni i niba o paalu ki bi paagdi bi yiama. Li po n cedi k bi tie i po buud dama ");
INSERT INTO guxg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama, li ya tie U Tienu paalu po k bieli mu cicibiadimu, U Tienu diema pundi i kani. ");
INSERT INTO guxg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ya nulo pia mi tuama ki gɔ pia ti tɔb tiadi ki gu o deni, o ŋalimano kuli ye li wuoli nni. ");
INSERT INTO guxg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama yua ya paa ki cie ya kɔni yen'o, o yi fie o tɔb tiadi kuli yen o ŋalimano ki bɔgdi ");
INSERT INTO guxg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ya nulo ki tie n yua, tie n yibalo, k yua ki taagi yen nni, yadi yaali k n taan nni. ");
INSERT INTO guxg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ya yogunu k bi deli cicinbiadiga, o yi sani ki ban kua li fuali nni, ki kpaani naan kani ko ba fuodi, ama o ya ki la naani k o ba kua, o yi yedi o ba nni: nba guani naani k n bo ñani. ");
INSERT INTO guxg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","O yi guani ki sua ki bi tingni lan ya kaano ki ŋanbi. ");
INSERT INTO guxg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Li ya tieni yeni, o yi guani ki gedi ki ban kpaani o lieba bonbi lele, k bi bia ki ciegu k pugni o po, ban ji ya ye. Li nulo yinyienu ji ŋanbi ki pa k cie cincinli. ");
INSERT INTO guxg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yayogunu k o maadi yeni, k o pua ba yigni bi niba nni: pamanli ya pua mal'a ki ŋaan'a o biili ");
INSERT INTO guxg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","K Jesu ŋmian o: li pamanli ŋanbi ki ye yaabi n cengi m maama ki gɔ cɔln ni li kuli. ");
INSERT INTO guxg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bi niba bo baadi ki pugdi, k o maadi: ti yogu ne niba tie nibiidi, bi o paligu po, ama bi ji kan la paligu ke li ya tie Jonas n bo tieni yaali ka. ");
INSERT INTO guxg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nani Jonas n bo tie bama Ninif nib po yen, o nulo bijua mɔ baa tie mɔlane niba ne po bama i. ");
INSERT INTO guxg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Daajijuogu daali, o yanbangu puo bado, bu fii ki kɔniyeni li yogunu niba, kelima o ba li ŋandunli ni ki bua cengi Salumɔ tundli yaali gbie yeni mi yanfuoma. Ama bonli nan ye ne cie salumɔ. ");
INSERT INTO guxg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Li daajijuogu daali, Ninif niba bu fii ki kɔni yeni bi yogu yab. Kelima bi ŋa damiwoncili ki cengi jonas maama. Ama k bonli ye ki cie Jonas ne kanba. ");
INSERT INTO guxg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nul kan cuoni fidili ki wuon i lɔdign ni bii ki cunbni bobli. N n, bi yi tuani naani ki ya niba n kua gu diegu nni, n la mi yinyenma. ");
INSERT INTO guxg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A nuni tie nani fidili yeni ki yendi a gbanu. A nuni ya ye laafia nni, a gbanu kuli ye mi yinyenma nni, ama a nuni ya ki pia laafia, a gbanu kuli ye li bonli nni. ");
INSERT INTO guxg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tien suoo ki ŋanbi ki diidi, ke a fidili n da cua yeni bonbonli a po. ");
INSERT INTO guxg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A gbanu kuli ya ye mi yinyenma nni, ki ba bɔgdima ki ye bonbonli nni, l baa tie a po nani li fidili n tien a mi yinyenma. ");
INSERT INTO guxg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ban bo maadi ya yogunu yeni, ki farisien ba yin jesu k wan ba ki je o deni. Ki jesu kua li ja deni, ki cili ki ba je, ");
INSERT INTO guxg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ke farisien bandi k o cili ki je, k ki ŋuudi o nugi. k li ya k lid'o. ");
INSERT INTO guxg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","K jesu jiin k maadi: yinb farisien nba, i yi ŋanbi ki wuli, ki caadi, ama ki pala nni gbie yen o naayidbu yen mi biadima. ");
INSERT INTO guxg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yinbi, i ki bani k yua tagi niin po, wan tagi deni mɔa? ");
INSERT INTO guxg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Teni mani U Tien yaali ye i pala nni kuli k o bu ŋanbi. ");
INSERT INTO guxg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ama yubonli i po, farisien nba, i di jodi boncianli bonli kuli nni, k k bua ki maadi i mɔmɔni, k gɔ sundi U Tienu buama po. Yin bo baa tien yaali, k da ŋa li ba kuli yeni. ");
INSERT INTO guxg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yubonli i po, farisien nba, kelima i maan a kankaan cincina ti jandiedi nni. I bua ki ban fuondi bi niba n yabi naani. ");
INSERT INTO guxg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yubonli i po, i naani yen ya kula ki naani yeni bonli, k bi tɔgdi bii k cuoni li po k jeje k ye. ");
INSERT INTO guxg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wan maadi yeni, ki yiko tudka gaa ti jadi ki bual'o:... canbaa, a maadi k ŋan sugd ti bi. ");
INSERT INTO guxg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu maadi: yubonli a po fin yiko daan'o ne. I tungi bi niba ya tuga kpiagi, ama, yinba mɔno ki bua yin sii ba i nugi li ba kuli ya po. ");
INSERT INTO guxg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yubonli i po, kelima i t iendi ti bontitagdi ki nangi U Tienu tondi yaaba ki yajaanb bo kpaab. ");
INSERT INTO guxg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","I wangi yeni mɔni i yaajaanba n bo sɔni ya tuonbiidi kuli: bi kpa U Tienu tondi, ki mɔa maa bi kula. ");
INSERT INTO guxg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Li ya po k U Tienu, o yanfuoma nni bo maadi: “n te bi sɔni ntondi yeni n ŋɔdikaaba; i ba kpa tiama, ki cagni yaaba n sieni”. ");
INSERT INTO guxg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Li po n cedi ke ti yogunu yaaba te bi pa, U Tienu tondi yaaba ki bi kpabi kuli hali li ŋandunli cilima. ");
INSERT INTO guxg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ki cili Abel kuuma, ki pan gedi Zakali kuuma li jaandi binbindli po. N maadi, ti yogunu yaaba, te kan fidi ki buu bi buudi ki gbeni. ");
INSERT INTO guxg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yubonli i po, yinba yiko tundikaaba, i tugi mi banma k li cie bonli kuli. L k tie ki kan la U Tienu baba ka, ama i bi pani bi niba boncianli, ki bi kan fidi ki kua. ");
INSERT INTO guxg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesu n bo ñani gu diegu nni, ki yiko gbanbanda yeni farisien nba ji tudi o, ki bual'o i buali boncianli. ");
INSERT INTO guxg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bi ji den kpaani wan baa jiini yaali, lan cua yeni kɔnli. ");
INSERT INTO guxg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ya yogu ke ku niwulgu den taani ki pundi a tuda, ke bi niba ji ŋmaadi bi lieba, ke o cili ki dá maadi leni o ŋɔdkaaba, “Fangi mani i yuli leni farisienba nɔbli, bani yaaba n pia mi muyima. ");
INSERT INTO guxg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ama bonlibá ki ye ki duagi, ki kan dɔgdi, bonli ki ye ki wuo, ke bi kan bandi. ");
INSERT INTO guxg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lanwani i, yin maadi yaali li biigli nni, bi ba gbadi li mi yenyenma nni, ke yin sɔbi ki maadi yaali li dieli nni, ke a gana luo, bi ba kpaandi la li dieli binbinli po. ");
INSERT INTO guxg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","N dɔnlinba, n yedi yi, da jie mani yaaba n ba kpa ti gbannandi, ki ji kan fidi ki tieni libá kuli ki pugni. ");
INSERT INTO guxg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ama, n ba tuodi ki waani yi yin ba ya jie yua. Yin jie yua kpa, ki go pia ya paalu n ba lu ŋa ku mubuogu nni. Nn, n maadi yi, jie mani o. ");
INSERT INTO guxg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","bi ki kuadi nuanmu mu mu ka kuumu lie e? Leni lani kuli, U Tienu nunga nni, bi kan sundi mu siiga nni bá yenga po. ");
INSERT INTO guxg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ama yinba wani, bá i yudi, bi cɔdi ki bani ti dugli. Da jie mani pu, i pia muyuli ki cie ya nuankuli n yabi. ");
INSERT INTO guxg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","N yedi yi, ya nilo kuli n tuo ke o bani nni, bi niba siiga, o 'Ja Bijua' mo ba tuo ke n bani o U Tienu malekinba kani. ");
INSERT INTO guxg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama yua nia bi niba siiga ke waa tie n yua, bi ba sundi o po U Tienu malekinba kani. ");
INSERT INTO guxg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yua n maadi mabiadma o 'Ja Bijua' po, ba baa sugli, ama yua n maadi ki sugi U Tienu Foŋanma, o kan baa sugli. ");
INSERT INTO guxg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bi ya dia yi, ki caa leni yi ti jaandiedi nni, ti buudi danba kani leni yikodanba kani ti buudi po, yin da yagi i yama leni yin ba maadi yaala ki fie i yuli, bii yin ba yedi yaala. ");
INSERT INTO guxg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kelima lanyognu liga, U Tienu Foŋanma ba tundi yin ba yedi yaala. ");
INSERT INTO guxg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ke niyendo yedi o ku niwulgu siiga “Canbaa, maadi n kpelo wan bɔgdi ti báa ń sieni ti ya faali, ki teni nni. ");
INSERT INTO guxg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu ń yedi o, “O ja, ŋma n kaani nni ke min ya tie i buudidaano bii i ke min tua i kɔnpaadilo li faali bɔgdima po? ");
INSERT INTO guxg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ki yedi ba, “Fangi mani yibá lini mi ŋalmanbuacianma, kelima nilo miali ki ŋua o ŋalmani yabmu ka. ");
INSERT INTO guxg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Lani ke Jesu pua ba ya kpanjama ne, “Piado bá den koni ki baa boncianla, ");
INSERT INTO guxg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ke o kali, ki jagi, ki yedi o pali nni, “N ji ba tieni ledi i, kelima mii ji pia kaanu ki ba bili n kpaandi ne kuli? ");
INSERT INTO guxg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ki yedi, “Min ba tieni maama n ne. N ba mumudi n bunbuana, ki guani ki ma yia n tiani, ki bili lien nni n bondikaali leni n bonpiakaali kuli. ");
INSERT INTO guxg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lani, n ji ba pagi n yuli “Mini, min bili ya piama kandi, ki ba tuoni nni ya bina n yabi. Ya kaa, ki fuo, ki di, ki ñu, ki mangdi a pali. ");
INSERT INTO guxg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ama, ke U Tienu yedi o “O yanluodaano ne, dinne ñiagu liga i, ke n ba ñani a naano, ki ŋa a. ŋan bili yaali kuli ba tua ŋma ya yaali i? ");
INSERT INTO guxg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Li tie nani yua n taagi mi piama o yuli po, ki nan ki pia pu U Tienu kani.” ");
INSERT INTO guxg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesu yedi o ŋɔdkaaba, “lanwani i, yin da buali i miali po, yin ba di yaali bii, i gbanu po, li bonlakaali po ");
INSERT INTO guxg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kelima, li miali gie ti jiedi, ke u gbanu mo cie ti tialakaadi. ");
INSERT INTO guxg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Diidi mani a bonyugda, baa buu, baa yendi, baa pia bilkaanu, baa pia bɔnbuana, ama U Tienu nan dingi a. yinba, i pia mayuli ki cie ti bonyugditi! ");
INSERT INTO guxg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","I siiga, ŋma ba fidi ki fagni o miali bá a dana waamu? ");
INSERT INTO guxg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","I ya ya bani ke i kan fidi ki tieni yaali n waa ki cie ne, be ya po i ke i maali yaali n sieni kuli po o? ");
INSERT INTO guxg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Diidi mani ti puudi ń tie maama, tii tuuni, tii pia gaalu mo, ama bá o badciamo Salomɔn leni o kpiagdi, waa pundi bi siiga bá yengu ń bobi maama. ");
INSERT INTO guxg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","U Tienu ya bobindi u kuanu nni muadi yeni, tini yaadi ye dinne ke bi ba faa ki taa ti, ki kuuni u fanu nni, ki cuoni umu, li ki pia tama ke o ba bobni yi mo, oo yinba yaaba ya dudugdi n ki pia fuoma! ");
INSERT INTO guxg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Da buali mani yin ba di yaali leni yin ba ñu yaali po, ki go da yagni i yama. ");
INSERT INTO guxg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kelima ŋanduna dogi kuli lingi lanya bona i, ke i Báa moko bani ke i bua li bona. ");
INSERT INTO guxg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ama yin lingi mani o diema, i ba baa lanya bona ki pugni ");
INSERT INTO guxg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Da jie mani ba waamu, kelima i Báa pali mani ke wan puni yi o diema. ");
INSERT INTO guxg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kuadi mani i piama, ki puni a luoda li ligi. ŋali mani i po ya ligbɔgli n kan cadi, ŋaljanli nni ya ŋalmani yaali n ki pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kelima a ŋalmani ń ye naani, a pali mo ye lankani i. ");
INSERT INTO guxg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","N̄agni mani i liadfagda u gbanñagdu, i fidsanmu ń ya tundi ki co; ");
INSERT INTO guxg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yin ya tie nani ya niba n guu bi canbáa ń ba ña mi pocaajaama po, ki kpeni yeni, o ya pua li ganli ya yognu, ban kagni ki luodi o po. ");
INSERT INTO guxg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ya tuonsɔnba, ke bi canbáa ba pundi ki sua ke bi dá nua, bani baa mi yedŋanma n yeni. I mɔmɔni, n maadi yi, o ba ñagni o gaaligu u gbanñagdu, ki cedi ban kali u jedikaanu, wan tieni ba mi jiema ban je. ");
INSERT INTO guxg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Canbàa ya pundi yɔgsiigu bii siŋaafaani, ki sua ke bi cegni ki guu o, lan ya tuonsɔnba baa mi yedŋanma n yeni. ");
INSERT INTO guxg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ama, min ba pugni yaali n ne, yin ya bani ke o diedaano ya bi bani ya yognu ke o suuro ba kua o deni ki suu o, o bi kan ŋa ban kua o deni ki su o, ");
INSERT INTO guxg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yin egni iba, ki ya guu kelimaa i ki baniO Ja bijua n ́ ba guaniya yognu. ");
INSERT INTO guxg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pieri ń buali: «O Diedo, a pua lan ya kpanjama tinba baba ya po bii, li tie yuakuli ya po i?» ");
INSERT INTO guxg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","O Diedo ń yedi: «O laa tuonsɔnlo i, ke o canbáa ba guuni ke wan ya diidi o tuonsɔnlieba tuona, ki puuni ba bi daali jiema lan buali ya yognu, ");
INSERT INTO guxg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","o canbáa ya kpeni ki sua ke o tuuni lan buali maama, lanya tuonsɔnlo baa mi yedŋanma n yeni. ");
INSERT INTO guxg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","I mɔmɔni n maadi yi, canbáa ba taa o piama kuli ki piani lanya tonsɔnlo. ");
INSERT INTO guxg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama li tuonsɔnlo ya maadi o pali nni: «N canbáa kpenma dá ba fagdi», ki ji cili ki pua o tuonsɔnlieba, bi jaba yeni bi puoba kuli, ki go cili ki di ki go ñu wan bua maama, ke mi daama ga o. ");
INSERT INTO guxg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","O ya tie yeni, o canbáa ba ti ludi ki kpeni wan ki guu o ya yognu, ki cedi ban pua ki duoli o kaani kuli, ki beli ki ñani o, ki kuani o bi tuonsɔbiadba danba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nani li tuosɔnlo ń den bani o canbáa ń bili o ya tuonli yeni i, ki nan ki sɔni lan buali maama yeni i, o canbáa ba cedi ban pua o ya lanbana n yabi. ");
INSERT INTO guxg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama, ya tuonsɔnlo n ki tuodi ki bani, ki sɔni ya tuonli n buali ke lan dadi o tubli ii, bi ba pua o lanbana waaamu. Ban teni yua ke li yabi, bi ba buali o yaali n yabi. Ban piani yua yaali n cie, bi ba buali o yaali n cie. ");
INSERT INTO guxg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«N cua ki tinga po ke min sia mu i. N sugni ke li mu ji co i. ");
INSERT INTO guxg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","N pia mi ñinwulma, ke bi ba wuli nni. I ki bani min bua tonma maama, ke li kuli ń tieni ki tii. ");
INSERT INTO guxg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","I tama ke n cua ki tinga po yeni mi yanduanma yo oo? N n! I mɔmɔni, n maadi yi, n cua yeni mi paadma i. ");
INSERT INTO guxg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kelimaa, lan cili mɔlane, dieyengu nni, niba mu ba paadi, niba lie ń kɔni yeni niba taa; niba taa mo ń kɔni yeni niba lie. ");
INSERT INTO guxg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bi ba paadi bibáa ń kɔni yeni o bijaba, a bila mo ń kɔni yeni bibáa. Binaá ba kɔni yeni o bisiaba, a bisala mo ń kɔni yeni binaá. Calnaá ba kɔni yeni o biyuaga, ki biyuaga ń kɔni yeni calnaá.» ");
INSERT INTO guxg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu go den maadi ku niwulgu yaali ne: «I ya la taayinbɔnu puoli, i yi maadi: “Ki taaga ba nii!” Lan go tieni yeni. ");
INSERT INTO guxg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mi faawaama ya fii nintuali, i yi maadi: “Ku wulgu ba tieni!” Lan go tua yeni. ");
INSERT INTO guxg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yinba i muyiidmu ne! I fidi ki diidi ki tinga maalma yeni tanpoli maalma, ki bandi a bona. Li nan tieni ledi i, ke yi ki fidi ki bandi U tienu n ́ bobindi yaali mɔlane? ");
INSERT INTO guxg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Li tieni ledi i, ke yi kan fidi ki tuodi ki cegni yaali n tiegi i po mɔlane? ");
INSERT INTO guxg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A ya caa ti buudi yeni a yibali, ŋan mɔndi ki mangi yeni o u sanu nni, wan da ti cedi ti buudi yudanba ń buu ki cuo a, ban mubni a bi paatieba nui nni, ban luoni a li kpaadidieli nni. ");
INSERT INTO guxg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N maadi a, a kan ña li kpaadidieli nni, kaa pani a pana kuli ki gbeni.» ");
INSERT INTO guxg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bi nub yab n den ye li kan den mad yesu, li yogunu gog yal n den cua galileb yaab ki pilat den kpab ki tan ye sagl. ");
INSERT INTO guxg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","O ŋiab: Edaan ki lan galile nub n tie bid danb ki cie yaa galile n sien nni, kelma wan kpab yeni? ");
INSERT INTO guxg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","kai, n maad e, e yaa lebd e yeyienu, e kul ba kpe nan ban yene. ");
INSERT INTO guxg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","lan yaã ka, a piga n nuniida yab ki silo diegu baa kpaab yen, e daan ki ban n tien ti bid ki cie galile yaabaa? ");
INSERT INTO guxg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kai n yed yi, ki yi moko yaa lebd yi yam yi kul baa bod yene. ");
INSERT INTO guxg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lan, yesu den pua n naa kpanjam ki yed: O jaa den ŋuu o kankanbu o dumontiibu kuan nni. O den cua ki ling a kankana waa laa. ");
INSERT INTO guxg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lan wan o den yed o kuanguulo: diid bina taa kin cuon ki ling o kankanb ne po a kankana, mii laad. Ped o be yaa po k o kub n fanfanm fanm fanm? ");
INSERT INTO guxg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","O kuan guulo den ñian o k yed: canbaa ced wan bind dun gog. n baa gbiidk lind o k tien o t yan biind. ");
INSERT INTO guxg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","daal ba ya bin n ŋua oba lo yaalan ŋan ped o. ");
INSERT INTO guxg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dan yenl n fuodm daal, yesu den tund b nub li daal maam bangm diel nni. ");
INSERT INTO guxg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","o pua den ye lienni k pia t tag bid, yal n den ced k o yia hal piig n bena niin, k o tiib. k gunb k kan fid k yaal k sed. ");
INSERT INTO guxg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu den laao, k maad an yed: o pua ne, a paag a yianun po. ");
INSERT INTO guxg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","O den maam o po o nugi. lanyogunu leg, o pua yen den yaab k sed, k kpiagd o tienu. ");
INSERT INTO guxg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ama li bal maam bangm tiel camba pal b den biid yesu n paag o nulo m fuodm daal. ");
INSERT INTO guxg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yom daan den guan k yed o: yinb palalie danb, li naan m fuodm daal yi siign yua kul k yi lod o nua, lan yaa ka o ŋunbo ki ñan o li yandiel nni k banñun o? ");
INSERT INTO guxg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","O pua yua n tie abalaham yabl k staan lol o hal piig n bena niin, laa pund min faab o n fuodm daalii? ");
INSERT INTO guxg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wan den maad yaa yogunu, efe den cuo o nanda kul. ama onuwunlgu pal den mang yen wan tund yaa banm kel pia t kpiagd kul. ");
INSERT INTO guxg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu go den yed: o tienu diem naan yen be? n ba nangm yen be? ");
INSERT INTO guxg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","O tie nan ya tub ya bobim n wa k cie e tiid kul, k o nulo bulo o kuanu nni, k o pud k kped k tua tub. A bonyugda den ted t ted di o bena po. ");
INSERT INTO guxg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","O go den yed: Nba mang o tienu diem yen be? ");
INSERT INTO guxg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","O naan yen ya dabinl k o pua taa tien bignm taan, k sien hal k li kul ga. ");
INSERT INTO guxg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu den suag liig, ki muand e dog ciam yen a dogibla nni, ban ca jelusalem. ");
INSERT INTO guxg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","O nulo den yed o: ti yomdano lan wan ya nulb n ba ciad kaa yab? Yesu den guan ki yed yab n ye li kan. ");
INSERT INTO guxg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Moand man ki kua yaa buluñoabu n miab kan, kelma n tuod ki wan yi ki bi nub boncianl ba te moa ban kua li kan ki nan kan fid. ");
INSERT INTO guxg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","O diedaano ya fi ki luon o duñuabu, ki bi tua: canba luod ti po. O ba guan ki yed yi: Mii ban yin ñan naan. ");
INSERT INTO guxg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","lan wan yi ba guan ki yed o: tiTi den din ki ba ñun a go den ban g ti e dog san nni moko. ");
INSERT INTO guxg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","O go ba guan ki yed yi: N yed yi, mii ban yi ñan naan, fuad nan n kan, yinb yab n tiend ti biad. ");
INSERT INTO guxg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lan yogunu yi ya la abalaham, isaak jakob yen bi sawalpuab kulki bi ye otien diem nni, ki yinb wan ba ya ye niinpo, yi ba ya buud ki cegn yi ñina. ");
INSERT INTO guxg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","bi nub ba ti ña nintual, yen puol po, nuganu yen nujienu po ki taan ki kal o tienu diem o sa dikanu kan. ");
INSERT INTO guxg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","diid, bi tianb yab n tie puol yab moala, ba tua liig yab mo ba tua puol yab. ");
INSERT INTO guxg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","lan yogunu fadisieninba bi tab den cua o kan ki yed o: ña ne kelma hedod bua ki kpaŋg ");
INSERT INTO guxg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Oden guan ki yed ba yed ban, yed man li ŋaago, ki n diel ki nand ti tag biad bi nub niinni, ki go paabd bi nub din ne yen saala, li dataal daal n ba soan ki juod ");
INSERT INTO guxg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","li tie doole min suag liig din yen ya daal n ŋua, kelma laa dagd sawalpualo n kpe ki laa tie jedusalem. ");
INSERT INTO guxg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","jedusalem, jedusalem, fini yua kpa bi sawalpuab, ki luud o tienu n soan a kan yab a tana, tualmi ŋa ke n den bua ki gogd taani a nuba n kan nani o kokolo n li wuug o koobila o fiabi nni maam, ama yii den tuo. ");
INSERT INTO guxg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lan yaa ka, yi diegu baatua dingbengu. N maad yi, yi kan go lan hal yin ba yed ya yogunu: O tieŋanm nu n ba yad o yed yab, n cuon wan ti yomdan yel nni. ");
INSERT INTO guxg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","U Tienu fuodma daali, ke Farisieninba yudanba siiga yendo den yini Jesu o denpo, ke ban je: ");
INSERT INTO guxg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yaaba n den cua ki ba je, den kpaagi Jesu. Yiamo bá mɔ den kaa o nintuali po, ke o gbanu kuli tie a mɔla bábá. ");
INSERT INTO guxg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu den maadi yeni U Tienu bali maama tundkaaba yeni yikodanba tundkaaba yeni Farisieninba. Ki buali ba: Li cabi ke ban paagi o yiamo saaba daali bii laa cabi i? ");
INSERT INTO guxg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bi ki ŋmiani o lbá. Lan wn ii, ke Jesu cuo o yimo, ki paagi o, ki maadi o, ke wan ya kuni o denpo. ");
INSERT INTO guxg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lani ke o gɔ buali ba: ... I siiga ŋma i ke li ya tie o biga lan yaa ka o nua n baa li caali nni ke o kan tuodi ki ñani o? ");
INSERT INTO guxg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Baa den fidi ki ŋmiani o lala maama po lbá. ");
INSERT INTO guxg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wan den bandi ke yaaba n cua mi jaanma kuli den lingi ke ban kali liiga kankaani po, ke o pua ba mi makpanjama ne: ");
INSERT INTO guxg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Li ya tie ke o nulo yini u puokuanu jaanma, da gedi ki kali liiga. Li ba fidi tuu ke o yini o nulo ke cie ŋa, ");
INSERT INTO guxg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ke wan yua yini yi kuli ba cua ki maadi ŋa: “Fii ki teni o ne u kankaanu, a ji fii yeni i fee i ki gedi ki pan kali puoli. ");
INSERT INTO guxg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama, bi ya yini a mi jaanma, ŋan gedi ki kali puoli po. Yua yini a yeni ya ti cua, o ba maadi: “N dɔnli, ti bobni u kankaanŋanu a po, cua ki kali liiga!” Li baa tie a po ti yudandi i yaaba ke bi yini ba yeni kuli nunga nni. ");
INSERT INTO guxg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lan wan ii, yua doni o bá bi ba jiini o, ke yua jiini o bá bi ba doni o. ");
INSERT INTO guxg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ke Jesu maadi yua n yini o: A ya bobni mi jaanma u yensiinu lan yaa ka ku yen yenjuogu, ŋan da yini a dɔnlinba, a ninjanba, a naataani lan yaa ka a kuantaalieba yaaba n tie bi ŋalmandanba, kelima, bi mɔ ti ba yini a ki ŋmiani ŋa li ŋanma. ");
INSERT INTO guxg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama, a ya bobni mi jaanma, ŋan yini a luoda, a juama, a tuoma, talginba. ");
INSERT INTO guxg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lan wan ii U Tienu ba ŋanbi a po kelima ban wan kan fifi ki ŋmiani a ŋanma. U Tienu ba guani ki ŋmiani a ŋanma ya yogu ke o ba fiini bi kpienŋanba. ");
INSERT INTO guxg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yaaba n den ye mi jaanma kani siiga yendo n den gbadi laa maama, ke o maadi Jesu: Li pamanli ye yeni yua n ba baa ki je U Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesu den gɔ maadi o: O nulo den jagi ke o tieni mi jaancianma, ki yini bi niba boncianla. ");
INSERT INTO guxg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mi jiema yogu n n pundi, o den sɔni o naaciemo ke wan gedi ki maadi wan yini yaaba: Cua man na kelima li bonla kuli ŋanbi ki gbeni o. ");
INSERT INTO guxg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ama bikuli yendo yendo den mia sugli nani bi taani ñɔbu yeni. O nikpialo den yedi o naaciemo: N daa u kuanu, kali min gedi ki pan lá u, ŋan pan mia n po sugli. ");
INSERT INTO guxg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","One mɔ den yedi: N daa naakpakuoda piiga, n caa ki bua pan biigi a, ŋan pan mia o sugli n po. ");
INSERT INTO guxg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tɔa momko den yedi: N dá kuani o pocaano mɔlane, lan ya po n kan fidi ki gedi. ");
INSERT INTO guxg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","O naaciemo den lebdi ki guani o canbáa kani, ki waani o li kuli. Lani, o diedaano yeni pali den beni, ke o yedi o naaciemo: Kua u dogu siiga nni yeni i sani nni tontoni ki cua yeni a luoda, a tadma, a juama yeni a waba na. ");
INSERT INTO guxg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lan tien waamu, o naaciemo den guani ki yedi: Canbáa n tieni ŋan bo puogi nni yaala, u kaanu gɔ sieni. ");
INSERT INTO guxg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Lani ke Canbáa den gɔ yedi o, ke wan ña u dogu nni ki diidi a sanbila nni yeni a naga balinma ki tigdi bi niba, ke ban cua na n diegu n gbie. ");
INSERT INTO guxg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N yedi ke min den kpia ki yini yaaba yeni, bi siia bá yendo kan leni n jaanjiema. ");
INSERT INTO guxg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ku niwulgu den yegi yeni Jesu u sanciamu nni. O jigdi ki yedi ba. ");
INSERT INTO guxg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Yua cua n kani ki bua ki ŋɔdi nni yaa yie o báa, yeni o naá, yeni o pua, yeni o bila, o kpeliba, yeni o waamu, bá o yuceli mɔ, o kan tua n ŋɔdka. ");
INSERT INTO guxg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yua n ki bugi o dapɔnpɔnli ki ŋua nni kan fidi ki ya tie n ŋɔdka. ");
INSERT INTO guxg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yi siiga nni ŋma baa bua maa li diecianli ki dá kan kali ki bandi wan ba biani yaala, ki lia o ya pia ya ligi n ba dagdi wan gbeni. ");
INSERT INTO guxg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","O ya ki tieni yeni, ki pu li tanpuuli ki naa fidi ki juodi, yaaba n ba pendi li kani kuli baa ñuadi o, ki yedi. ");
INSERT INTO guxg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","O ja ne cili li diemaali ki naa fidi ki juodi. ");
INSERT INTO guxg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bii o laa badciamo n baa ye ki bua ki tuogi bu tɔbu yeni o badciantɔo, ki nan pia bi tɔtieba tuda piiga, nani o dá kan kali ki biigi o ya ba fidi ki tuogi bu tɔbu yeni yua n cuoni o kani ki pia tɔtieba tuda piilie? ");
INSERT INTO guxg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","O ya sua ke o kan fidi, o ba sɔni o tondiba hali ke o yibali dá ye fagma, ki mia o wan waani o wan bua yaala ban mangi yeni bi lieba. ");
INSERT INTO guxg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Li tie yeni i siiga, yua n ki luni wan pia yaala kuli, kan tua n ŋɔdka. ");
INSERT INTO guxg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mi yaama mani, ama mi ya ti luo mi manu, bi ba taa be ki gɔ mangi ma? ");
INSERT INTO guxg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Maa pia mayuli ban pagi ma u kuanu nni, maa pia ban taa ma ki kali leni ti baadi man ti tua dulma, hali ban lu ma bábá. yua n pia a tuba ki ba gbadi wan gbadi. ");
INSERT INTO guxg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lani, ke a lonpo gaala leni ya tuonbiiddanba n sieni den kpendi Jesu kani, ki cengi o maama. ");
INSERT INTO guxg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ke farisieninba leni ti yikodi tundkaaba ji bulni bulni, ki tua “O nilo ne gaani ti biidi danba hali ki di leni ba.” ");
INSERT INTO guxg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ke Jesu pua ba ya makpanjama ne, ki maadi ba ");
INSERT INTO guxg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“O laa nilo i siiga nni n baa pia pee kobga, ki biani payendo, ki kan ŋa piiyia n pee yia yeni, ku muagu nni, ki guani ki kpaani ya pia n bodi hali ki ban la o. ");
INSERT INTO guxg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","O ya la o, o ba bugi o o buapiadi po, ki mangi o pali boncianla.” ");
INSERT INTO guxg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","O ya pundi denpo, ba yini o dɔnlinba leni o kuantalieba ki maadi ba, “Mangi mani i pala leni nni, kelima n la n pia yua bi bodi. ");
INSERT INTO guxg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Lanyapo, N yedi yi, ke li pamanli baa ye tanpoli kelima biiddanyendo lebdi o pali ki cie niteginkaaba piiyia n biyia yaaba n ki buali pali lebdima. ");
INSERT INTO guxg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Bii, o laa pua n baa pia dibala piiga, ki biani dibayenli, ki kan cuoni ki fidsanga, ki tigni li dieli ki fiidi bonŋanla hali ki ban la li? ");
INSERT INTO guxg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","O ya la la, o ba yini o dɔnlinba leni o kuantalieba, ki maadi ba, “Mangi mani i pala leni nni, kelima n la n dibali yaali bi bodi.” ");
INSERT INTO guxg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","N yedi yi, biiddanyendo ya lebdi o pali, li tie pamancianli i, U Tienu malekinba po.” ");
INSERT INTO guxg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ke Jesu maadi, “Nilo den pia bijaba lie, ");
INSERT INTO guxg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","o bonwaalo po den yedi o báa, “N Báa, bɔgdi n faali biinu ki teni nni mɔlane” Ke o bɔgdi ba o piama. ");
INSERT INTO guxg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Lan tieni dana waamu, ke o waalo po baani o bonkubkaali ki gedi hali ya dogu n fagi, lan dogu po i, ke o biidi o ligi, ki daa yaali n ki tie o po bonbuakaali mɔno, ki biidi o ligi mi bibiadyema nni. ");
INSERT INTO guxg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wan dini o ligi ki gbeni, mi konbiadma ń baa li dogu nni, mi koma ń gbadi o. ");
INSERT INTO guxg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ke o gedi ki mia li tuonli li dogtielo bá kani, ke o kaani o o kuanu nni ke wan ya guu i duoli. ");
INSERT INTO guxg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O den ya baa ti duojiedi, o den ba di leni li pamanli, ama obá nan den ki puni o sanu. ");
INSERT INTO guxg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ama ki bonjaga yeni yama ń den guani, ke o maadi o pali nni, “N báa pia naacenba biŋa i, ke bi di ke jiema ki muani ba, ke mini nan ba kpe leni mi koma nekanba! ");
INSERT INTO guxg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“ N ba siedi ne, ki guani ki kuni n báa po, ki ban maadi o, “N Báa, n biidi U Tienu po leni a nunga nni. ");
INSERT INTO guxg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","N ji ki dagdi min ya tie a biga, ga nni min tua a naacenba nni yendo. ");
INSERT INTO guxg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ke ki bonjaga yeni siedi ki kuni o báa po. Wan dá den paa hali fagma, o báa den la o, ke ti niñipadi cuo o, ke o sani ki wobi o, ki muadi o tankpina po. ");
INSERT INTO guxg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ke ki biga maadi o, “N Báa, n biidi U Tienu po leni a nunga nni. N ji ki dagdi ŋan yini nni a biga. ");
INSERT INTO guxg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bibáa ń maadi o naacenba, “Cua mani leni liadŋanli, ki lani o, ki pilini o li nubiñinli leni ti taacaadi. ");
INSERT INTO guxg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Diidi mani natonbikpanbili, ki kpa, ke tin tieni mi jaanma, ki mangi ti pala. ");
INSERT INTO guxg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kelima, n biga den kpe, ki ji pia li miali, o den bodi, ke n guani ki la o. Ke bi ji cili mi jaanma. ");
INSERT INTO guxg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Li sua ke o kpelo bi ye u kuanu po. Wan kpendi, ki nagi deni, ke o gbadi ki ciaga yani leni ku jeligu. ");
INSERT INTO guxg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wan yini naacenyendo ki buali lanya bona niima nni. ");
INSERT INTO guxg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","O naaciemo ń maadi o, “A waalo n kpeni, ke a báa kpaá li nakpanbili ki tieni mi jaanma kelima o guani ki kpeni leni laafia.” ");
INSERT INTO guxg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ki bikpelga pali ń be, wan yie ke o kan kua deni, o báa ń ña ki baagi o. ");
INSERT INTO guxg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ama o kpelo ń jiini ki maadi o báa, “Diidi, bina ŋa n yeni, ke n tuuni a po a tuona, n nan ki kpeli ki tudi a nunga nni, Ama a nan ki kpeli ki puni nni bá ŋɔtonpanli, ke min tieni mi jaanma leni n dɔnlinba, ");
INSERT INTO guxg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama A bijua yua n biidi a ŋalmani yeni a poconcona ń kpeni, ke a nan kpaá o po naatonkpanbili. ");
INSERT INTO guxg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","O báa ń maadi o, “N bijua, fini li ye leni nni daali kuli, ke min die yaali kuli tie a yaali i. ");
INSERT INTO guxg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ama, li bi dagdi leni tin tieni mi jaanma, ki mangi ti pala, kelima a waalo ne den kpe, ki ji pia li miali mɔla, O den bodi ke ti guani ki la o. ");
INSERT INTO guxg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ke Jesu go maadi o ŋɔdkaaba, “piado bá den ye, ki pia o ŋanlmankublo, ke bi ti cua ki tuali o ke o ŋalmankublo yeni biandi o piama. ");
INSERT INTO guxg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ke o piado yini o ki maadi o “Be n teni ke min gbia apo ya maama ki ŋani? Tieni nni a ŋalmankubli cɔli, kelima a ji kan ya tie n ŋalmankublo.” ");
INSERT INTO guxg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","K o ŋalmankublo maadi o pali nni “N ji ba tie ni ledi i, n cab áa ń ji bua beli nni li tuonli ne? N ji ki pia paalu ki ko, ke n ya miadi mo, li pia i fee ");
INSERT INTO guxg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","N bani min ba tieni yaala ke bi ya beli nni n ligkubli tuonli mi ba cani ya niba ń tuo ki ga n cangu” ");
INSERT INTO guxg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yeni, ke o yini o canbaa pandanba yendo yendo, ki buali yua n kpia ki cua “A pia n canbaa panli yiŋa i? ");
INSERT INTO guxg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ke o maadi, mi kpama golindi kobga (100).” K o maadi o, “Ga a pantili ki kali tonma ki diani golindi piimu (50) ");
INSERT INTO guxg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ke o ŋalmankublo buali tiano, “ke fini mo, a pia n canbaa panli yiŋa i? Ke o mo maadi “Mi ŋalkaama kpalpiadi kobga (100)” Ke o maadi o “Ga a pantili ki diani kpapiadi piiniin (80) ");
INSERT INTO guxg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Canbaa den pagi ya ŋalmankublo n den ki tiegi yeni kelima o den tieni bu nunfanbu. Kelima ŋanduna ne bila fani yeni bi lieba ki cie mi yenyenma nni ya bila ");
INSERT INTO guxg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","N maadi yi, Taa mani i ŋanduna janbi ŋalmani ki kpaani danlinba, li ya ti gben, yin baa yaaba n ba ga i cangu naani ke li ki pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yua n tiegi yaala n wa nni, ba ya tiegi yaala n yabi nni mo. Ke yua n ki tiegi yaala n wa nni kan ya tiegi yaala n yabi nni mo. ");
INSERT INTO guxg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","A ya ki fidi ki kubi i janbi ŋalmani, ŋma ba dugi apo, ki piani a o ŋalmani yaali n mɔni i? ");
INSERT INTO guxg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bi ya ki dugi a po ŋan kubi nitɔba ligi, maama, ŋma ba teni a a ligceli? ");
INSERT INTO guxg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Naaciemo bá kan fidi ki ya pia canbaanba bilie. Kelima, o ba fidi ki ya nani yendo ki nan bua o lielo, lan yaa ka wan cɔlni canbaa kpialo ki nan fali canbaalielo. A kan fidi ki ya ŋua U Tienu leni ŋalmani ");
INSERT INTO guxg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisienba ń gbadi li maama yeni, ke bi ji ñuadi o. ");
INSERT INTO guxg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ke o maadi ba. “I ba maadi ki baa i mɔni, bi niba kani, ama U Tienu bani i pala. Bi niba ń nua yaali ke li tie kpiagdi yeni, U Tienu wani ya nunga nni ke li tie cancagndi i. ");
INSERT INTO guxg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yikodi maama yeni bi sawalpuaba n den kubi, ki ŋmagdi u dogu yo hali ke Janbatisi ti cua. Lan cili lanyogu, bi wangi U Tienu diema laabaalŋamo, nilo kuli tiendi ania ki kpaani wan kua lien nni ");
INSERT INTO guxg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ama tanpoli leni ki tinga pendima ki paa ki cie li bali maama nni lanbyenli ń bodi ki kan tieni. ");
INSERT INTO guxg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ya nilo n ñani o denpua ki kuani potiano conbi, yua n kuani ya pua n ñani o calo kani mo conbi. ");
INSERT INTO guxg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Cengi mani, ŋalmandaano bá den ye ki la ti tiakpiagdi, ki di ti jiemandi, ki ye u yenyienŋamu nni daali kuli, ke o pali mani boncianla o piama po. ");
INSERT INTO guxg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","O luodo mo den ye, ke bi yi o Lasari, ke o dua o piado bulñɔjabu kani, ki pia a nala o gbanu po kuli. ");
INSERT INTO guxg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","O den suni ke wan baa ya jiejɔgdi n baali o piado jedikaanu, bá i sangbanli den lagdi o nala i. ");
INSERT INTO guxg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ke o luodo tikpe, ke malekinba tugi o, ki duoni o Abalahama kani. O piado mo ń kpe, ban pii o, ");
INSERT INTO guxg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wan den ye o mubuogu nni ki laadi fala, ki ti yaadi ki diidi, ki la Abalahama hali fagma ke o wobi Lasari ki tabni o pali. ");
INSERT INTO guxg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ke o yigni paama ki maadi, “Ti Báa Abalahama, diidi nni leni mi niñima, ki sɔni Lasari wan tuu mi ñima leni o nubili, ki maani n lanbu po, bun sɔngi, kelima n ye leni mi cacagma i ku mubuogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ama ke Abalahama maadi “N biga ya tiani ke a yenyienu nni, a den baa yaala n ŋani boncianla a po ke Lasari mo den laadi fala boncianla. Ama mɔlane, o ji ye ne, u yenyienŋamu nni, ke a mo falaciamu nni ");
INSERT INTO guxg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Li ya ñani lankani i, buociangu ye siiga nni, ki paadi tinba yen yinba, ke nilo kan fidi ki ña ti kani ki gedi i kani, obá mo kan fidi ki ña i kani ki cua ti kani. ");
INSERT INTO guxg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","O ŋalmandaano ń maadi “N Báa Abalahama, mia sugli ki sɔni o n báa diegu nni. ");
INSERT INTO guxg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kelima n pia naataanjaba mu, wan tuodi ki tiadi ba. N jie ke bi mo ń da ti pundi ya falacimu nni ke n ye ne. ");
INSERT INTO guxg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ama ke Abalahama maadi, “Bi pia Moyiisi leni bi sawalpuaba maama; ban cengi mani “ ");
INSERT INTO guxg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O piado ń guani ki maadi, “li kan tuo, ti Báa Abalahama, ama nilo ya ñani bi kpienba kani, ki gedi ki maadi ba, bi ba lebdi bi yama” ");
INSERT INTO guxg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ama ke Abalahama maadi, “Bi ya ki cengi Moyiisi leni bi sawalpuaba maama, bá nilo ya yiedi bi tinkpiba siiga, bi kan cengi o.” ");
INSERT INTO guxg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus maadi o ŋɔdikaaba: L kan fidi b nibaa n ya ye k kan tieni biidi. Ama yubɔnli yua tulmi o lielo. ");
INSERT INTO guxg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","l bo baa tu l daano po yen wan la l naatanli k ya kagi u ñibɔugu nni yen wan bo t bidi ne siiga yendi ");
INSERT INTO guxg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","lani wan yi cuo i baa a kpiilo ya tieni biidi, gɔ taa'o u ya lebdi, ŋan mia sugli o po. ");
INSERT INTO guxg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","O ya tuo ku tiena t biidi daaln i taalmi m lile, k cua k maadi ŋa ŋan mia u po sugili u po. ");
INSERT INTO guxg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","B tondikaaba maadi u tienu: Pugni ti dudugdii ");
INSERT INTO guxg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","U tienu n gɔ maadi bi l ya den tie ki pia t dudugdii, ba k l waa k cie m jonbima yeni, i den bo fidi k niini o tibu nne: “k ye figdi a jiina i tinga ne nni k gad pan sedi m ñiciama nni” wan cɔln i. ");
INSERT INTO guxg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","L ya tie ki siiga yendi pia o tuonsɔnlo k u ko u kpaabu bii ku kpaa t yandi. i ya la'o ku ñani u kuannu po, k kpeni, i bo tuo yedi, “cua kali k je e” ");
INSERT INTO guxg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","I kan maadi k wan tieni m dajojiem, k wan lebdi u tiadi k nagni m jiema ki yaa je k gbeni k gɔ ñuni k gbeni yo o mɔ cua je k bia ñuu. ");
INSERT INTO guxg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Canbaa bo jaandi u tuonsɔlo kelima u cedi ku tieni wan bua yaal i l kan yaa tie yeni. ");
INSERT INTO guxg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","yeni i mɔ ya kani. ya yogu ki sɔni ban buali yaal kuli. yin yi maadi: tinm tie ya tuonsɔma k ŋua ŋmaapani ama t sɔni ti tuonli. ");
INSERT INTO guxg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ya yogu ku den bua gedi Jerualemi, Jesus den cuoni Samari yeni Galile kpaal l po i ");
INSERT INTO guxg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","wan ti kua dogu baan ne nni. k kpaada piig tuog'o; k sdi fagnma ");
INSERT INTO guxg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","k baln i Jesus yeni paama: Jesus t canbaa jie ti m ninñima! ");
INSERT INTO guxg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","k Jesus la ba ki madibi: gedi mani k la salgi yidikaaba! ban caa ya yognu k bi paagi. ");
INSERT INTO guxg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","k b siiga yedi n bandi ku paagi, wan guani k ya yini k dondi u tienu yeni paama ");
INSERT INTO guxg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","k baa gbaani Jesus taana kan tibni u yuli k tuu i tingi k tieni Jesus balgi, k n nulo nan botie samariteni. ");
INSERT INTO guxg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","k Jesus maadi: B tie bani bonm piiga k paagi bonm yiani yabi sieni wan ye le i? ");
INSERT INTO guxg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nul tɔ ji ki ye k l tie k o caani guani k dondi u tienu? ");
INSERT INTO guxg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","k maadi Samariteni jua yeni gɔ fii kelima a pia ti dudugdi n po, a ciadi. ");
INSERT INTO guxg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","K farisieni nba bual'o be daali k u tienu diema baa cua i? K Jesus ŋmiianba: U tienu diema k baadi. Utienu diema ya bo cua nul kaa nua'o. ");
INSERT INTO guxg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","b kan maadi cua mani u ye nebii o ye ne po. Yin ŋanbi k ya tiani. U tienu diema ye i siiga nni. ");
INSERT INTO guxg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Guani k maadi o ŋɔdikaaba: Oyogu t bo cua ki baa niani k yi ya y yeni u nulo bijua l ya tie baa daayeli i kan fid. ");
INSERT INTO guxg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ama b bo ti maadi “Kristo ye ne” yi daa caa, i daa jegli ");
INSERT INTO guxg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","I tañigidi yi pudi kaanyedi t tawaligbandi nni k cil ki fandii kaan yenu ki ya ya caa tiali po. L ti baa ti tie yeni u nul bijua daali. ");
INSERT INTO guxg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","L buali k wan guo fala paaa yo ti ye yogu ne niba n yie'o ");
INSERT INTO guxg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ya daali k o nulo bijua bo guan i, a bona bo tieni nani Noe: ");
INSERT INTO guxg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","B niba den di, k ñu, k kuandio b puobi k bia puu'bi, hal yeni ya daali k Noe kua o ñibiagu. l yogu k u togu ji biidi ki kpa bi kuli. ");
INSERT INTO guxg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","yaali mɔ gɔ bo cua Loti yogu n yeni: b niba den di k ñu k daa, k kuadi, k ŋuundi, k maa. ");
INSERT INTO guxg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama ya daali k Loti ñani Sodome k tacianga yeni i tatintandi yeni i tañigdi baa k kpa b kuli. ");
INSERT INTO guxg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lbaa ti tie yeni ya daali ko nulo bijua bo legidi. ");
INSERT INTO guxg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","L Daaali ya pundi nul ya ye ldepil po bii k se deni po wan daa jiidi k tugd o bona yali k u ŋa. L bia baa tie yeni, yua ya ye kuaan po wan daa kpeni u deni. ");
INSERT INTO guxg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gua tiadi mani yaali baa Loti denpua ");
INSERT INTO guxg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yua kpaani k wan fie o miali u ba bia ama yua luni u miali bo lamfiema ");
INSERT INTO guxg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ldaali ñiaɔgu, n maadi, nibi lie bo duani gadogu yedi po, yeli bo cua ama tianli n ñindi ");
INSERT INTO guxg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Puoblie bo taani k bindi u naakpiagu: yeli n bo cua k tianli ñindi. ");
INSERT INTO guxg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","nibi lie den baa ye o kuaan po yendi n kpeni tɔ n ñindi. ");
INSERT INTO guxg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","K Jesus ŋɔdikaaba bual'o: Lboli bo ti tieni le kani ti yudaano? K u jiin'bi: n kuum nti baa ye naani lan kani k nanyobli nba bu taani. ");
INSERT INTO guxg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ki fiddi ki waani ki jaandi tie bonmonli, k tin ya jaandi ki da wadi ti pala, jesu pua o ŋɔdikaaba mi maa kpanjama: ");
INSERT INTO guxg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O dogu nni den pia buud daano ba, ko k jie U Tienu k gɔ cengi nulo. ");
INSERT INTO guxg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","K li dogu nni gɔ bo pia pakuali pokuuli ba ko tundi ki ŋua'gu k wan kun'o i mɔni o yibali kani. ");
INSERT INTO guxg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ti buudi daan'o ne bo ki ceng'o hali k li pan waagi. Ama ko ji te kali ki maal ki sua: “yeni i mɔni k n ki jie U Tienu, k tie lieba mi bua yaali. ");
INSERT INTO guxg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Li paakuali ne mabi nni boncianli, n bi jia o buudi k wan ŋaa nni mi fuodi. ");
INSERT INTO guxg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","U Tienu pugini maadi: cengi mani, o buudi daano, faagu daano ne, n maadi yaali. ");
INSERT INTO guxg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ki li ya tie yeni, i ki bani ku Tienu ba kɔni o bid po, yaabi ko lugdi ba k bi dongi bi niali o po, yienu yen ñiagu, ko kan todi ba? ");
INSERT INTO guxg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Min n maadi ti ko bi kɔn bi po, ya tie ko nulo bija ya te guani, o gɔ bi la li dindanli i tinga ne po. ");
INSERT INTO guxg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","O gɔ den pua ya maa kpanjam ne ke li nua yaab n yi bi ba nimɔma, ki nan ji nundi bi lieba: ");
INSERT INTO guxg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nib lie bo gedi o jandiegu nni ki bi jaandi: yendi bo tie farisien ko lielo tie lonpo gaalo. ");
INSERT INTO guxg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisien bo se ki jaandi o pali nni: U Tienu, n tiend'a balgi yen min ki kpiini, k k pua faagu, k k conmi nani nlieba yeni, nan o lonpo gaalo ne yeni. ");
INSERT INTO guxg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","N co u ñɔbu taalm lie dana lele siigin ni, n tien taal piiga po mu ŋalimanu talgi nba. ");
INSERT INTO guxg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","O lonpo gaalo ne wani bo se fagma ki taabi, k kan tuo ki yaadi ba o yuli tapoli po. Ama, o bo fabini o pali ni ke maadi: n Tienu diidi yen mi nuñima kelima n tie biidi daano ");
INSERT INTO guxg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","N maadi, U Tienu tuo ki gaali o lonpo daano ki cie farisien. Kelima, yua dongi o ba, bi bu jiin'o, yua jiindi o ba, bi baa dongi wani. ");
INSERT INTO guxg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","B niba bo baadi yeni bi bidi jesu kani, k wan yadi mi yediŋanma bi po. Ama ko ŋɔdikaabi bieli ba. ");
INSERT INTO guxg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","K jesu yinba ki maadi ba: yin cedi mani ban cua n kani, da bieli'b mani, kelima yaabi n yeni U Tienu deni tie nani ban yeni. ");
INSERT INTO guxg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","I mɔni po n maadi: yua k ga u Tienu diema nani i biga ne yeni, o kan bangi kua U Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yeni k Kpaagl ba tieni i buali:... canbaa mɔn, mi baa tieni ledi k la ya miali ki pia gbema? ");
INSERT INTO guxg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","K jesu ŋmiani o: be cedi ka yin nni canbaa mɔn nni? Nul ki mɔni li ya ki U Tienu baba yaa ka. ");
INSERT INTO guxg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A bani U Tienu ñɔmaama: a kan conmi, a kan kpa nulo, akan su, ŋan cedi janmi buudi, ki cɔnlini a náa yeni a baà. ");
INSERT INTO guxg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ki li ja ŋmiani: n cɔnlini lio kuli k da tie biga. ");
INSERT INTO guxg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeni jesu maadi: a gɔ da sieni bonyenli: kuadi ŋan pia yaali kuli, k tugi li ligi kuli ki bɔgdi talgi nba, li puoli po ŋan ya ŋuan nni. ");
INSERT INTO guxg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wan gbadi yeni ko pali kuli wadi kelima li ja bo tie ŋaliman daani ");
INSERT INTO guxg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu den la ko pali wadi ko maadi: li pa boncianli yen ŋalman daano n kua U Tienu diema nni ");
INSERT INTO guxg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","li ki pa ku yuoyuogu n kua kpalipimu bonli, k cie yen ŋalma daano n kua U Tienu diema n ");
INSERT INTO guxg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ki bi niba yen kuli taani ki buali: ŋmaa nan b la li maa kan gbedigu? ");
INSERT INTO guxg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","K jesu ŋmian o: yaali n pa bi niba po, k pa U Tienu po ");
INSERT INTO guxg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yeni k Pieri buali: k tinba i? ti ŋa tin pia yaali kuli k ŋua ŋa ");
INSERT INTO guxg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","K jesu maadi ba: ... i mɔn po n maadi ki yua ŋa o deni, o pua, o ninjaba, o bidi, o naataani kuli k dugni U Tienu diema po. ");
INSERT INTO guxg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","O bu la ti ñuadi yaali n yabi, mɔlane yen ya dana baadi, ya miali ki pia gbema. ");
INSERT INTO guxg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu bo tugi o ŋɔdikaaba piig n bonbilie k piadi yenba ki maadi ba: diidi mani, t do Serusalem n yen, ko Tienu tondi n bo dian yaali o nulo bijua po kuli ji bu tieni. ");
INSERT INTO guxg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bi bu cuogu ki mubin'o yaabi ki bani U Tienu nuguni, ban laagu, k sugd'o, k sii ti ñɔsɔndi o po. ");
INSERT INTO guxg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bi ba puagu, ki kpaagu. Dana ta daali o bu yiedi ");
INSERT INTO guxg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","O ŋɔdkaaba bo ki gbadi li maama niima nni, kelima li pa bi po yen ban gbadi li maama. Bi ji bo ki bani jesu n bua maadi yaali li po ");
INSERT INTO guxg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesu n bo nagi seriko, o juamo bo kaa o sankuni ki miadi. ");
INSERT INTO guxg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wan gbadi li ñɔgli o sanu po, ko buali yaali tieni. ");
INSERT INTO guxg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ki bi ŋmian'o ki jesu n pedi. ");
INSERT INTO guxg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yeni ko cili ki yigni yeni o paalu:... jesu, Dafiid bijua, diidn yen nunbaagu. ");
INSERT INTO guxg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yaabi bo ye liiga bo maad'o, k wan suoni, ama ko ŋanbi k yigni: Dafiid bijua diidn yen nunbaagu. ");
INSERT INTO guxg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ki jesu cedi k bi ba yen'o o kani, wan pundi ya yogunu, ki jesu bual'o: ");
INSERT INTO guxg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","A bua k min tieni be k ten'a i? ko juamo ŋmian'o: n diedo, cedi ki mi nuali. ");
INSERT INTO guxg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A bu fidi ki nuali, kelima a dindanli paag'a. ");
INSERT INTO guxg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","L yogunu ko nuali, ki ji ŋua jesu ki dondi U Tienu. Ban la yaali n tieni ne, ko nuwuligu kuli mɔ ji dondi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus bo pendi Jerico dogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lsua jua baa ne mɔ ye l dogu nni yi'u Saase ku tie ŋanman daano k dungn o tie lonpo gaala canbaa i. ");
INSERT INTO guxg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wan gbadi k Jesus pa k pendi. ");
INSERT INTO guxg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","K u sani. K ga liiga k pan doni tibu bá ne po k b yi u Sikomar k wan la Jesus k dungn o tie jinjega i. ");
INSERT INTO guxg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesus n pundi l kan ya yognu, k u yaad la'o bu tibu po k maad'o: ");
INSERT INTO guxg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Saase jiidi tonma dinne n bo cani a deni. K u jiidi tonma ki ga'o yen pamanli. ");
INSERT INTO guxg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","B niba n gbadi yeni k b ji bulnbulni k diidi wan caa bua cani o nubiigu ");
INSERT INTO guxg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ama k Saase sedi k maadi k o bɔgdi o ŋalmani ki teni b cacagidama. K l gɔ ya sua k u den kubi nuli panli o bua guani ki ŋmiani l daano tabual m taa. ");
INSERT INTO guxg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","L yogu k Jesus k u la m fiema o deni yeni k dugni o mɔ tie Abrahami yabili. ");
INSERT INTO guxg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","K dugni o nifossalo bijua baa k wan guan k kpeni k bia faabi yaaaba den bodi ");
INSERT INTO guxg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","B niba n bo songi Jesus tundi yeni k sua k u paa k nagidi Jerusalemi. B nubi ji maal k u bua kaani u tienu diema n yeni. ");
INSERT INTO guxg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","L yogu k u maadi k jua baa ne n den tie nigbengli g fii gedi dogbanbanfagli k pan di labaali k guani k kpeni. ");
INSERT INTO guxg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","K kpeni k kubi o dogu. k yiini o naaceb bonm piig g bɔgdiba wula dibala k yua kul ń mɔnd k lan nob. ");
INSERT INTO guxg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wan gedi ku dogni yaaba diani l tili k ten'o k maad'o k bi bo'a bi dogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ku yedi ba ku kan kpeni, wan pan dini l bal k kpen wan ji yiin u naaceb k yua kul nagni ki waani wan sɔ maama yeni e ligi yeni. ");
INSERT INTO guxg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Cincin yua n baa k nagni k maadi: canbaa ŋan den teni i ligi yal yeni mi sɔ k dibala piig pugni l po. ");
INSERT INTO guxg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","U canbaa ń maad: n faa n naaciemo a tie tuosɔnli. A bo gaa dingbana piig canbaandi. ");
INSERT INTO guxg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tɔ n mɔ cua k maadi canbaa n mɔ sɔni yeni i ligi yeni k baa dibala k pugni l po. ");
INSERT INTO guxg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","U canba n maad'o a bo gaa dingbana mu canbaandi. ");
INSERT INTO guxg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tiani n mɔ cua yua juodi k maadi canba n den taa a ligi yeni k pɔbni k begini n tiadi nni. ");
INSERT INTO guxg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","N den jie ŋa ka tie canbabiadi. k taa min k bil naani k bia yendi min k bul naani ");
INSERT INTO guxg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","K u canbaa maad'o: a tie naacenbiadi a bani k tie canbabiado i k taa min k bili yaala k gɔ yend min k bul naani. ");
INSERT INTO guxg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A den bo kan taa n ligi k billi banki i n ya ti kpeni ya daal mi ga yeni t ñuadi. ");
INSERT INTO guxg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","K maad yaaba den ye likan k ban fie o liyendiga yeni k ten i yua pia pia bona piig ");
INSERT INTO guxg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","K b niba maad canba wɔ nan pia bona piiga ! ");
INSERT INTO guxg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","K canbaa maad ki b bo pugni yua pia i ama yua k pia ban bia fie wan pia yaali yeni. ");
INSERT INTO guxg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","K maad k ban baa yeni o yibala yaab den yedi k u kan yendi'b yeni k kpa ba o nintual nni. ");
INSERT INTO guxg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus n maad ki gbeni k u taa o niba yaab ŋua'o k ye liiga k b doni Jerusalemi. ");
INSERT INTO guxg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ban nagdi Betefaje yeni Betani k k fag yeni olife jua kan, k u sɔni o naacenb bonmilie k madi ba ");
INSERT INTO guxg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Gadi mani o dogu yala n ye i liiga po ne i bo i ŋunbiga k nil ku luol yin lod'o na. ");
INSERT INTO guxg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nul ya buali yaali n cedi ki lodo yin maad k u yonmdaano n bua ");
INSERT INTO guxg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ban sɔni yaaba gedi ki guani k li tie nani Jesus n bo maad maama. ");
INSERT INTO guxg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ban bo lodi o ŋuumo ya yogu k b bondanb buali ba k be ced k lod o ŋuum i? ");
INSERT INTO guxg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","K b maad'b ku yomdaano n bua. ");
INSERT INTO guxg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","K bi guani yen'o Jesus kani k bmaani bi tiadi i ŋunbiga po k jagni Jesus ");
INSERT INTO guxg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wan pend ya yognu b nib bo yi land b tiadi k bil o sani po. ");
INSERT INTO guxg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ban bo ñani Olifie jual po k ji k nagdi Jerusalemi ku ŋɔdikaaba kul ji yiini k dondi u tienu yen ban bo la ya yaaligu kuli. ");
INSERT INTO guxg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","K tua m yediŋanma n ya ya o bado yua cuon u tienu yel po t yomdaano, laafia n ya ye tanpol po k ti kpiagidi n ya kaan kul ");
INSERT INTO guxg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","L yogu k falisian nba yab bo ye b niba nni maad Jesus: maad a ŋɔdikaaba ki ban suoni ");
INSERT INTO guxg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","K Jesus k baa b ya suoni, a tana n baa yiini k dondi u tienu. ");
INSERT INTO guxg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wan pundi Jerusalemi dogu nni k u gbel k caani l bubuuli k maadi ");
INSERT INTO guxg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","K maadi a ya bo ban k diine daali ne tie a yomdaano daali ama keto l duagi ninbina po i. ");
INSERT INTO guxg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A danaa cuoni a po k kan ya ŋan, k a yibalaa ti bu kaalida kaana kul k pib a k luon a kaan kuli. ");
INSERT INTO guxg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","B bu biani fin yeni a dogo niba kul pil pil k kan sieni baa dikpiyenli k l se, k dugn i a den k bandi a Tienu can'a ya daal i. ");
INSERT INTO guxg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus kua ou jaanddiegu nni k beli a kpinkpenda k maad'b: ");
INSERT INTO guxg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ldiani k maadi k den baa tie jaanddiegu, k yinma tug k l ̇tɔ a nɔyiga cend kaanu. ");
INSERT INTO guxg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesus bo tundi b niba daal kul u jaanddiegu niin po i. Ama k b tondanb ye yeni yikodanba kpaani k ban kpa'o ");
INSERT INTO guxg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama b bo bani ban bu didal maama k dugn i yua kuli bo songi o maama ");
INSERT INTO guxg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dayenli, ke jesu den tundi bi niba ku jaanddiegu cancanli ki muandi ba li laabamanli, ke ku jaanddiegu liiga yaaba cua yeni bi yikodanba yeni u dogu yudanba, ");
INSERT INTO guxg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ke bi buali Jesu ya buali ne: ... Maadi ti, a kubi ŋmaa yiko ki tuuni, lan yaa ka, ŋma n teni li yiko? ");
INSERT INTO guxg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesu maadi: ... N mɔ pia i buali ke bi buali yi, ŋmiani man nni: ");
INSERT INTO guxg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jan den kubi ŋmaa yiko i, ki wuu bi niba U Tienu ñima? Li den tie U Tienu yiko bii bi niba yiko i? ");
INSERT INTO guxg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ke bi ji buni bulni bi siiga: Ti ya maadi: “Ke U Tienu yiko” o ba buali ti: “Be cedi ke i den ki dugi o po”? ");
INSERT INTO guxg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ama ti ya ŋmiani: “Ke bi niba”, ku niwulgu ne ba luudi ti a tana ki kpa ti, kelima bi niba ne kuli dugi ke Jan bo tie U Tienu tondo i. ");
INSERT INTO guxg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ke bi maadi ke bi ki bani Jan n bo kubi yua yiko ki tuuni. ");
INSERT INTO guxg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","... Jesu ŋmiani ba, ke o mɔ ki bani wan kubi yua ya yiko ki tuuni. ");
INSERT INTO guxg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ke o pua bi niba ya makpanjama ne: ... Ja bá den ŋuu ku damɔngu diidi, ki ggni bi niba ki gedi naani n fagi ki ba waagi. ");
INSERT INTO guxg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mi cuama yogu ke o sɔni o tuonsɔnlo, ke wan gedi ki gaa bu kpaabu ligi, ke kpaguula pua ki beli o, baa teni o lbá. ");
INSERT INTO guxg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ke o bondaano gɔ sɔni tuonsɔntɔlo. Ke bi gɔ pua o, ki beli o, baa teni o lbá. ");
INSERT INTO guxg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Canbáa gɔ sɔni tuonsɔntɔlo bonbta po. Ke bi pua ki duoli o mɔ ki beli o. ");
INSERT INTO guxg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ke o kpadaano maadi: N tieni ledi? N ba sɔni n biga yaaga ke n ŋanbi ki bua ga. Bi ba fidi ki cɔlni wani. ");
INSERT INTO guxg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","A tuonsɔnla n lá ga ya yogu, ke bi juogi bi ŋmiali nni, ki maadi: “Yua n ti ba di li faali n yeni. Tin kpa o man, ki diedi li faali.” ");
INSERT INTO guxg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ke bi cuo o ki fili o, ki ñani o bu kpaabu nni, ki kpa o. O kpadaano ba tieni a tuonsɔnla yeni ledi? ");
INSERT INTO guxg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","O ba gedi ki biani a tuonsɔnla yeni, ki taa bu kpaabu ki guuni nitɔba. Li maama po ke bi maadi: “U Tieni n wuoni mani”. ");
INSERT INTO guxg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ke Jesu nɔnli ba suoo ki maadi: “I gbia U Tienu lanbona yia diani li tili nni ne ledi? Ya tanli ke a tanmaala bo yie ki luni yeni, laa tanli n ti guani ki tua ku diegu fiagli tanjali. ");
INSERT INTO guxg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yua n li baa li tanli po, o ba kɔni kɔni. Li tanli ya baa yua ya po mɔ, li nandi o i yomi yomi. ");
INSERT INTO guxg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ke U Tienu maama tundkaaba yeni bi salyidkacianba bandi ke li makpanjama nua bani, ke bi ji lingi ke ban cuo Jesu li yogu mɔno, ki jie bi niba. ");
INSERT INTO guxg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Li po ke bi kpaagi Jesu, ki sɔni bi niba ke bi yini bi bá nimɔnba. Bi bo ba lá i jalgi Jesu maama nni. Yeni, bi bo ba fidi ki cuo o, ki kubni o Romi bado yiko yiko yeni o yudandi nni. ");
INSERT INTO guxg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Lani ke bi niba yeni ji nagni o: ... Canbáa, ti bani ke a maadi i mɔmɔni, ki gɔ tundi bi niba lan buali maama. A ki jie bi yikodanba, ama a wangi bi niba U Tienu sanu yeni mɔni. ");
INSERT INTO guxg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","To, maadi ti, li buali ke tin ya pa Sesari ti patendi (lonpo) bii laa cabi i? ");
INSERT INTO guxg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesu bani bi janbi maama, ki ŋmiani ba: ");
INSERT INTO guxg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","... Waani nni man bu lugbu dibayenli! ŋma ya nannangu yeni ŋma ya yeli n ye li po? ... Ke bi niba jiini ke Sesari. ");
INSERT INTO guxg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","... To! ke o maadi ba, teni man Sesari yaala n tie Sesari yaali, ki teni U Tienu yaala n tie U Tienu yaala. ");
INSERT INTO guxg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bi bo ki fidi ki jalgi Jesu o maama nni bi niba siiga. Ke o ŋmiani bo lidi ba, ke bi bo luo ban ba maadi yaala. ");
INSERT INTO guxg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusehannba, ban yaaba n bo ki tuo ke bi kpienba ti ba fii ku kaagu nni, bi siiga ke bi tɔba nagni Jesu, ki buali o ya buali ne: ");
INSERT INTO guxg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","... Canbáa, Moyisi diani nni o bo diani yiko ne ki teni ti: Li ya tie ke o nulo kuani o pua, ki kpe ki ki pia biga, o ninjua ń taa o pakuali ki mali o a bila. ");
INSERT INTO guxg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","To, jablile n den ye ki tie kpiiba, o ciamo po kuani o pua, ki kpe kaa pia biga. ");
INSERT INTO guxg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bilie po yua yeni bita po yua yeni yaaba n sieni taa li pua, ");
INSERT INTO guxg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ke bi kuli kpe kaa pia biga” ");
INSERT INTO guxg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","O pua yeni mɔ ti yuandi ki kpe. ");
INSERT INTO guxg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To, bi kpienba n ba fii ya daali ku kaagu nni, ŋma n ji ba diedi o pua i? kelima bi kuli kuani o. ");
INSERT INTO guxg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu ŋmiani ba: ... Tin dá ye ya ŋanduna ne nni, bi jaba kuandi bi puoba ki bi puoba kuni bi jaba. ");
INSERT INTO guxg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama yaaba ke U Tienu diidi ki sua ke bi ŋani ki dagdi yeni ban fii ku kaagu nni ki kua li ŋandunpanli nni wan kan kuani bi puoba ki gɔ kan kuni bi jaba. ");
INSERT INTO guxg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bi kan fidi ki kpe, kelima bi baa tie nani Menekinba yeni, ki tie U Tienu bila, kelima bi ba fii bi kpienba siiga. ");
INSERT INTO guxg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ke bi kpinba n fii ku kaagu nni, Moyisi mɔno, bo diani li ya yogu ke o lá ku tuntuugu co u muu: Lan wan ii, o yeli n tie yonbdaano Abrahami Tienu, Isaaki Tienu yeni Jakɔbi Tienu. ");
INSERT INTO guxg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ama, U Tienu ki tie bi kpienba Tienu ka, ama fuodba Tienu; lan wan ii, o ya po, li tie mɔmɔni ke yaajanba ta yeni fo. ");
INSERT INTO guxg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Li po, a yikobanda gaa mi maama ki maadi: ... Canbáa, a ŋanbi ki ŋmiani li po. ");
INSERT INTO guxg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kelima, bi ji bo jie yeni ban buali i buali. ");
INSERT INTO guxg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ke Jesu mɔ ji buali ba: ... Li tieni ledi ke bi maadi ke O Tondo ba ña Dafiidi yaabila siiga? ");
INSERT INTO guxg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kelima Dafiidi mɔno maadi I Yani tili nni: Yonbdaano maadi n Yonbdaano: Cua ki kali n jienu, ");
INSERT INTO guxg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ya caa yeni ya yogu ke n ba cedi a yibalinba ń tua a taaŋmaakaanu. ");
INSERT INTO guxg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dafiidi yini U Tienu Tondo ke o Yonbdaano: Li ba tieni ledi i o tondo yeni n ya tie o yaabili. ");
INSERT INTO guxg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ke ku niwulgu den cengi o, ke omaadi o ŋɔdkaaba: ");
INSERT INTO guxg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","... Diidi U Tienu yikobanda yaaba n bua a bogda tiadi lama, ki ŋanbi ki bua ku niwulgu nni, ti jaanddiedi nni yeni ti wondi nni ban ya kaa liiga. ");
INSERT INTO guxg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bi fiedi a pakuana ligi i, ki nan yen sedi ki jaandi lan waagi nani bi tie bi nimɔnba yeni. Bi ya tubŋmaglu n ti baa bia. ");
INSERT INTO guxg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu nɔnli ya ŋalmandanba n kpieni i ligi ku jaanaddiegu nni, ");
INSERT INTO guxg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ke o lá pakuatalgi mɔ ke o cua ki kpieni i ligi dibala lie. ");
INSERT INTO guxg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lani, ke o maadi: ... Mɔmɔni po, n maadi yi, pakuatagi ne n kpieni ya ligi yabi ki cie yua kuli, ");
INSERT INTO guxg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kelima bi kuli ne kpieni ban ki bua yi i. Ama, wan gbegdi o piama kuli i, ki kpieni. ");
INSERT INTO guxg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bi tɔba den maadi ku jaanddiegu po: “Tinba n den maa gu leni a tanŋana, ki teni i ligi ke bi maa gu. Lani n tie bonŋancianla” Jesu maadi ba: ");
INSERT INTO guxg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","U yogu cuoni na, yin nua yaala ne kuli ba bolni; tanli bá ti kan ya maa li lieli po. ");
INSERT INTO guxg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","... Lani, ke bi bo buali o, Canbáa, u laa yogu i ke li bona ba tieni? Be n ti ba waani ti, ke li bona ba tieni i? ");
INSERT INTO guxg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu maadi ba: ... Yin faami, yin da cedi ban kuani yi mi tudma nni. Kelima, boncianla ba cua n yeli po, ki maadi: “Mini n tie O Tondo!” lan yaa ka: “U yogu pundi o!” Yin da cegi ba! ");
INSERT INTO guxg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yi ya ti gbadi ke tɔbu pua, ke a kɔnkɔna kɔni, yin da jie. Kelima li bona kuli dá ba cindi ki cua yo ŋanduna gbenma n fidi ki cua. ");
INSERT INTO guxg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lani ke o gɔ bo maadi: ... U dogu ti ba fii ki pua dogtɔu bu tɔbu. Diema mɔ n fii ki pua dietɔma bu tɔbu. ");
INSERT INTO guxg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ki tinga ti ba migi i dogi nni; mi koma leni i yiani ba baa i dogi nni; ya bona n pia ti jawaandi leni ku yaalidgu ba tieni tanpoli po. ");
INSERT INTO guxg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yeni li kuli ne n ti fidi ki tieni, bi ba cuo yi ki waani yi fala, ki gedi leni yi ki teni suifinba jaanddiedi yikodanba kani ke ban luoni yi dansalgi. n ya bi ba gedi yi bi badba kani leni leni dogdanba kani. ");
INSERT INTO guxg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Li bona ti ba cua yi, ke yin kuni i mɔmɔni n po. ");
INSERT INTO guxg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lan wan ii, yin ya pia ti dudugdi paaa: Yinb ka ba kɔni yibá po. ");
INSERT INTO guxg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ama, mini puni mi mabanma yi maadi ki paadi i yibalinba, ki gɔ puni ya yanfuoma ke obá kan fidi yi. ");
INSERT INTO guxg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yi danba, yi ninjanba, yi kpiiba leni yi dɔnlinba mɔno ba cedi ban cuo yi, ki kpa bitɔba i siiga. ");
INSERT INTO guxg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Obá ti kan ya bua i nublu kelima n ya po. ");
INSERT INTO guxg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama, i yuli po bá yuyengu kan bia. ");
INSERT INTO guxg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","I ya pia li mindli, i ba baa U Tienu ŋalbalgo. ");
INSERT INTO guxg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","... Ya yogu ke i ba lá yibalinba sijenba ke bi kaalindi Jerisalemi, yin ya bani o mudma nagi. ");
INSERT INTO guxg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lan wan ii, Jude dotieba ń sani ki do a juana nni, yaaba n y Jerusalemi dogu nni ń bobni tonma ki ña. Yaaba ye i kuani nni ń da kpeni u dogu nni! ");
INSERT INTO guxg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kelima, li dana tie U Tienu mutuoli dana yia nni ke i diani n yedi yaala ba tieni. ");
INSERT INTO guxg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Li dana nni, fala ba gbadi a potunpunba leni bi pomadinba! Kelima U Tienu mutuoli ba lagi li niba po. ");
INSERT INTO guxg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bi ba kpa li dogu nni niba leni li kadmanli lan yaa ka ki taa bitɔba ki puodi leni ba i doglami po, ki bi nilanba yaaba ki bani U Tienu ń diedi Jerusalemi ya caa leni ya yogu ke bi paalu po ba pendi. ");
INSERT INTO guxg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","... Ku yaalidgu bona ba tieni u yienu nni, o ŋmaalo nni leni a ŋmaabila nni. Ki tinga po, li mɔgli ba do leni ti jadi, bi niba n jie ki tadi. ");
INSERT INTO guxg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ti jawaandi ba kpa bi niba gbanu, bi ya maali ya yubɔnli n ba cua ŋanduna munli po. Kelima yaala n ye tanpoli po kuli ki pia paalu ba jegi. ");
INSERT INTO guxg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lani, ke bi ba lá O nusaalo bijua ke o ye ti tawalgbandi nni ki cuoni leni o paacianu leni ti yudandi. ");
INSERT INTO guxg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ya yogu ke li bona cindi ki tiendi, yin yaadi i yuli, ki ya pia li juunli kelima i faabu dana ji ki fagi. ");
INSERT INTO guxg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ke o pugni ya manannangu ne: ... Diidi man bu kankanbu, lan yaa ka titɔbu. ");
INSERT INTO guxg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ti ya lá ke bu puugu cindi ki pudi, ti nani ke ku siagu nagi. ");
INSERT INTO guxg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yeni mɔ i, i ya lá ke li bona ti tiendi, yin bandi nani ke U Tienu diema nagi. ");
INSERT INTO guxg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mɔmɔni po, n maadi lan kuli ne ba tieni ke mɔlane niba yaaba n ye ne, ke nitɔba da ki kpe. ");
INSERT INTO guxg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ki tinga leni tanpoli ba pendi, ama n ñɔbona ki pia pendma. ");
INSERT INTO guxg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Cuo man yibá, da taa man yi yula kuni mi jiema leni mi daama, ki gɔ da cagni yibá ŋanduna ne yenyienu po. Lan yaa ka li daagbengli ba cua ki cii yi. ");
INSERT INTO guxg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kelima, li ba baa nani ku jabaangu yeni ŋanduna niba kuli po. ");
INSERT INTO guxg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yin da gɔa man, ki ya jaandi yogu kuli ke U Tienu n puni yi u paalu ke yin fidi ki ña ya yubɔnli n cuoni nni, ki sedi o nufosaalo bijua nunga nni. ");
INSERT INTO guxg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesu bo taa o yentuna kuli tundi bi niba ku jaanddiegu nni; ku ñiagu wan gedi ki duani Oliifi tiidi juali po. ");
INSERT INTO guxg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ku siŋaapanpangu kuli, bi bo yen tigdi ku jaanddiegu nni ki ya cengi o ");
INSERT INTO guxg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tin den ye k l sieni nani dan ŋa yeni yeni “kpanu yaali ki pia dabina jaam” jaam yaali k b tua paki yeni. ");
INSERT INTO guxg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","K salikiyikaaba canbaa nba yeni b yikodamba pkaani ya sani k ban kpa Jesus. Ama bi den jie k ñɔgli bo tieni. ");
INSERT INTO guxg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yeni k sitaani kua Juda pal nni k b ji yi'o Ikariyoti piiga bolie siiga yeni yedi. ");
INSERT INTO guxg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Juda den gedi k la salikiyidkaab canbaa yeni u jaanddiegu nni nikpelo k ban taan ñɔb ki ban ban bo tieni maama k kuadi Jesus k b niba n daa bandi. ");
INSERT INTO guxg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","K bi kuli pali mangi k b cuo ki ban ten'o i ligi. ");
INSERT INTO guxg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","k u tuo l yogu mɔ̀no k ji kpaanii ya sani k u bo kuadi Jesus k niba n daa bandi. ");
INSERT INTO guxg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kpanu yaali k pia dabina jaami daali yua k nil kul bo b kpa paki pebiga n pundi ");
INSERT INTO guxg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","K Jesus sɔni Sani yeni Piaali ki maadi ba. gedi manni k tien man ti paki jiem. ");
INSERT INTO guxg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","k b guani bual'o a bua ti tieni l jiem le kani? ");
INSERT INTO guxg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","E ya pan bua kua o dogu nni i bo tuogi o nul k o tug l ñuncuali. Yi ŋɔd'o hali wan pan b kua ya deni. ");
INSERT INTO guxg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yin bo maadi yeni o diedaani maama nne: “Canbaa ye ki ti bual ŋa: k i laa dieli nni k bu je paki jaanjiema yeni o ŋɔdikaaba.” ");
INSERT INTO guxg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yeni o bo waani o dietuadugu po ya u dieciangu k ŋnb lien nni ki bo bobni. ");
INSERT INTO guxg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","k b gedi, k la yaal kuli k l tie nani Jesus n bo maadi maama K bobn nni paki jaama jiem. ");
INSERT INTO guxg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","O yogu n pund: k Jesus ji kali k bo di yeni o ŋɔdikaabi. ");
INSERT INTO guxg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","K u maadi ba: N den ŋanbi bua min jaani yeni paki jaam yo k fidi ki la fala. ");
INSERT INTO guxg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","N maadi n ji kan bani ki di yeni ya caa yeni ya daal k li t bu la l niima u tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ku taa u sɔma ki jaan k maadi ga mani k bɔgdi i ŋmiali nni ");
INSERT INTO guxg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kelima n maadi, n ji kan bani ñu u damɔngu ne yaa caa yeni ya yogu k u tienu b u kani o bali k gbeni. ");
INSERT INTO guxg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","K gɔ tugi kpanu mɔ k tieni u Tienu balkk jendi jendi k teni u naaceb k maadi bi: ne tie m gbannandi k taa teni ya tie mani yeni k ya tiani m po ");
INSERT INTO guxg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ban dini ki gbeni ya yogu ku gɔ taa u sɔmi ki k madi: ne tieu tienu b niba dɔnlpaangu sɔmi k bu wuli i po. ");
INSERT INTO guxg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ama yua bu kuadi n i ye nekama k kaa yeni ti ");
INSERT INTO guxg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mɔni o nifosaalo bijua ji caa i nani u Tienu n bo cabi maama, ama fala i yua kuadi ye po. ");
INSERT INTO guxg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","K Jesus ŋɔdkaab ji buali b ŋmali nni k b siiga ne ŋmaa bo fidi k tiel'i. ");
INSERT INTO guxg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","K Jesus ŋɔdikaab ji polidi yeni b lieba yua baa tie liiga yua. ");
INSERT INTO guxg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","K jesus maadi: u dogu batieba n paa b niba k yabi tuuni yiko tuonli mɔ k bi yib'i b “ŋanbtieba”. ");
INSERT INTO guxg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yi daa maadi yeni. Ama yua b tɔ diedo i siiga n tɔ biga, k yua baa die mɔ n tɔ tuonsɔnli o liebi kani ");
INSERT INTO guxg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","I ya kani ŋmaa die? Yua kaa di bii yua tuuni? i ya po yua kaa di kaa? Mi yua ye i siiga nne n tie nani o tuonsɔnli. ");
INSERT INTO guxg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","I den ye yeni n momɔni m bigma kul yogu ");
INSERT INTO guxg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","nani n baa n den teni m diema n mɔ teni, ");
INSERT INTO guxg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","I ji ba yi di k gɔ ñu m diema nni, k bia kali l bal kpagili po ki ya diedi Isaraheli buoli piga n bomlie. ");
INSERT INTO guxg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Siimɔ Siimɔ cuo a ba: sitaan bua wan kuani i guudiga nni k tindi, nani ban yi ledi i dii k ñani u fegu yeni. ");
INSERT INTO guxg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama n jaani a po k ŋan daa luo dudugidi ka mɔ ya daali ka bo guani ŋan mɔ paagi a kpiiba pala. ");
INSERT INTO guxg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","N yomdaano m maadi ŋa l ya tie ba m kua danalgi bii ki kpe n tuo ");
INSERT INTO guxg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","K jjesus jiin pieri m maadi ŋa i mɔni dinla mɔno k sua k o kokol daa buudi a nia bomtaa po ki ŋaa ban n i. ");
INSERT INTO guxg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Min sɔni k ligi k ye, k bɔgli k ye k tacaagu k ye i bonli pɔdi i ");
INSERT INTO guxg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mɔda i ya pia ligi yi taa, iya pia bɔgli yi gɔ taa, i yaa pia jugpiega yi kuadi l liadli k daa. ");
INSERT INTO guxg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kelima yaali bo diani u tienu ñɔmaam tili nni, l tie k lan tieni i. l bu diani maama ne i. B den taa'o a nubiada siiga. k ban bo maadi yali ji tieni. Mɔni ban bo diani yaali n po n ji bo tieni. ");
INSERT INTO guxg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","k b maad t yomdaano jugpiemu lie ye. K ŋmian bi, l dagdi. ");
INSERT INTO guxg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ko ñani k toli Olife juali po nan wan yi tun g tie maama k u ŋɔdikaaba ŋɔd'o ");
INSERT INTO guxg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wan ya yogu k u maadi ya jaan mani k daa kua bbida nni bigili nni. ");
INSERT INTO guxg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","K u siedi k fagidi k pan cie k gbaani o duna po k jaan ");
INSERT INTO guxg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","N baa fuadi n kani ya fala ne. ama lan da tie n ya buama, lan tieni nan ŋan bua maama. ");
INSERT INTO guxg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","K u tienu meleki ñan tanpol po k ten'o u paalu ");
INSERT INTO guxg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","K l pawadli kua 'o k u jaandi bonŋanla, ka tuntonjena ti cieni o po nani sɔm yeni k baal tinga nni. ");
INSERT INTO guxg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","l puol po ko fii ki nagni o ŋɔdkabi kani k sua k b gɔ k o pal biidi. ");
INSERT INTO guxg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ku maadi bi: be cedi ki guandi? fii mani ki ya jaani k da ba l bignli nni. ");
INSERT INTO guxg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus da den k jaan k gben, k u nuwugu pundi kJesus ŋɔdkaab piig n bonmlie yeni siiga yedi ye liig k b yi'u juda yeni ye b liiga wan nangni Jesus wan muadi u tankpili ");
INSERT INTO guxg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","wan maad'o: Tankpinmuadli kaa bu kuadi o nul bijua. ");
INSERT INTO guxg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesus ŋɔdkaab n bo nɔ yaal bo cua yeni k b bual'o t yomdaano t mɔ nɔdi ti jugpiemi k cua bii? ");
INSERT INTO guxg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","k l yogu b siiga yendi cua k jia salkiyidkaa kul canba tuonsɔnlo jienu tubli. ");
INSERT INTO guxg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","jesus maadi ba: “ŋaabi mani” k guani sii o tuonsɔnlo ye tubli k l paagi. ");
INSERT INTO guxg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","K Jesus maadi salgi yidkaab canba yeni o jaandiegu nni sije nba yeni o dogu n nikpela ban yaab bo bua ban cuo'o; “n tie bibiadli ya ki cuon i k kubi i jugpiemu yeni i gbiami? ");
INSERT INTO guxg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","n den ye yeni daal kuli o jaandiegu nni k nul k cuo ni; ama mɔda ji tie i yiognu k l bunbɔnli ji tie u paalu”. ");
INSERT INTO guxg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","K b cuo'o k gedi yen'o hal salki yidkaab kul canbaa kan. K Piali ye hal puoli k ŋua ");
INSERT INTO guxg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","B den cuon i o muu o lujɔga nni k i nib taani ki kaa k pɔl mɔ ye b siiga ni. ");
INSERT INTO guxg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","K tuonsɔcaano baa ne den la'o ko kaa o muyiegu kan k diid'o k maadi: “u ne den yi ye yen'o” ");
INSERT INTO guxg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","K Piali nia k maadi: Mi k ban'o. ");
INSERT INTO guxg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","k gɔ sudi yamu k tiani gɔ la Piali k maadi l tie mɔni a mɔ yi ye yen'o ku madi mi ki ye yen'o. ");
INSERT INTO guxg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","k gɔ tieni nan kudi yengu yeni nutiani n maadi: mɔni u ne mɔden ye yen'o u gɔ tie Galile yu i ");
INSERT INTO guxg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","k Pial maadi yeni paama min ki bani ŋan bua maadi yaala. L yogu g sua k u da maadi k gbeni ku kotogu buudi. ");
INSERT INTO guxg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","K ti yomdaano ji gbegi g nuali Piali k Pial ji tiadi wan den maado yaali. K sua ku kotogu daa buudi a bo nia ka k ban n i ");
INSERT INTO guxg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","K o ñani cancanli k buudi nisipiedi. ");
INSERT INTO guxg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yaab den guu Jesus den laa'o k bia puag'o. ");
INSERT INTO guxg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","K pibn i o nuga k bual'o: a de ye ka tie u tienu tondo kaa maadi yua pua ŋa. ");
INSERT INTO guxg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","K ji sugd'o sugbuoli kuli ");
INSERT INTO guxg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lan den fandi k u dogu nikpela yeni salki yidkaab canba nba yen a gbanbanda bo tani ki ba yen i Jesus b buudi dam kani ");
INSERT INTO guxg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","K b cil i buali: “A ya tie kristu ŋan maadi ti. K jesus ŋmia'bi: N ya jiin i kan ya pia n po dandanli, ");
INSERT INTO guxg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","K ya buali i buali ki kan jiin i. ");
INSERT INTO guxg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama mɔda o nul bijua b kali o baa yua tie diedo jienu po. ");
INSERT INTO guxg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","K b kul ji yigini a tie u tienu bijua yoo! ko jiim'a yima n ye k tie u tienu bijua. ");
INSERT INTO guxg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","k yabi ye ting po ji yigni, i gɔ bua la kasieda i. T songi u ñɔba nni mɔlane. ");
INSERT INTO guxg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","O nuwuligu kuli den fii ki gedi yeni jesu gufeneeli Pilat kani. ");
INSERT INTO guxg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bi ji den kpaani ki ban jalg'o:... ti la o nulo ne k o baadi yeni li ŋmadli ti niba siign. O deli ki ban da pa o badiciamo cesa lonpo, ki gɔ sua k o tie U Tienu n gandi yua, o bado. ");
INSERT INTO guxg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Lani ki Pilat bual'o:... a tie Suf nba bado yaa? ... K jesu jiin: fini yedi. ");
INSERT INTO guxg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","K Pilat maadi o jaandiegun nikpela: n ki la ya tagili n dagdi yeni k tin kpa o ja ne. ");
INSERT INTO guxg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ama ki bi kuli niini maadi: o cili hali Galile yo, k tɔgni Sude ki ji pundi ne. ");
INSERT INTO guxg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat n gbadi ki bi yini Galile, k o buali ki bua bandi o ya bo ñan Galile. ");
INSERT INTO guxg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wan den bandi k o tie Erod diema yua, k o cedi ki bi gedi yen'o. Laa dana kuli Erodi den ye Serusalem nni. ");
INSERT INTO guxg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erodi pali den mangi yeni wan la jesu, kelima li waagi k o den kpaani ki wan bandi o, kelima o den gbadi ki bi maadi o maama. O den sundi ki wan la ya paligu k o tie. ");
INSERT INTO guxg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O den tieni buali boncianli, ama jesu den ki jiini lba. ");
INSERT INTO guxg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","L yogunu k o jaandiegu nikpela yen yiko tundikaaba se ki maadi yeni paama kaa jie. ");
INSERT INTO guxg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yeni ki Erodi den taani yeni o mintielinba ki fali'o, bi den lan'o li badliedli. Erodi den cedi ki bi guani yen'o Pilat kani. ");
INSERT INTO guxg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Laa ya yogunu, li kɔnli den ye Erodi yen Pilat siiga, lan ya daali, ki bi guani ki mangi. ");
INSERT INTO guxg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat den yin liiga yabi, a nikpela yen bi niba. O den maadi ba: ");
INSERT INTO guxg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","I baa yeni o nulo ne k o wangi ti buolu mi tudma sanu. Ama, n bual'o i kuli siiga, n la tagli ba yaali ki maadi ne kuli o po. ");
INSERT INTO guxg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodi mɔ gɔ ki la lba o po ki dugni, o cedi k bi guani yen'o. O nulo ki biid pu kuli k li dagdi yeni wan kpe. ");
INSERT INTO guxg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","N cedi ban pua'o, ki ŋa'o. ");
INSERT INTO guxg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mi pendima jaanma kuli, a yi luodi dansalyenga. ");
INSERT INTO guxg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ki bi niba yen kuli tandi maadi:... kpa man'o, ki luodi Barabasa! ");
INSERT INTO guxg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bi den luoni Barabasa kelima o den baadi yeni li ŋmadli o dogun i, k gɔ kpa o nulo. ");
INSERT INTO guxg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ama Pilat den kpaani wan ŋa jesu k o buali bi niba ");
INSERT INTO guxg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","yabi se ki yigni yeni: ban kpaa o, ban kpaa o. ");
INSERT INTO guxg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","K o guani ki bual o, o tien be ki li dagdi yen ban kpaa o? N k la tagiliba k li dagdi yeni ban kpaa o, n bi cedi ban pua o, k ŋa o. ");
INSERT INTO guxg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yeni, ki bi kuli tandi ki sua k ban kpaa o, ban kpaa o, ki bi tantandi biid Pilat pali boncianli ");
INSERT INTO guxg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilat ji den te juodi ki cabi, ki tieni bi buama. ");
INSERT INTO guxg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilat den cedi ki bi luodi o nikpali Barabasa, ki tugi yesu ki ten ba ban kpaani yua. ");
INSERT INTO guxg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ban bo caa yen o, ki bi cendi Simɔ siren ja, k o ñani o kpaabu po, k bi niin o ki wan taani jesu ki wan bugi o dapɔnpɔnli. ");
INSERT INTO guxg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bi niba boncianli bo ŋua o. Ki bi puobi fabni ki buudi o po. ");
INSERT INTO guxg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","K o gbagi ki maadi ba:... jerusalem puoba, da buudi mani n po, ya mua mani i yula po yeni i bila. ");
INSERT INTO guxg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kelima a dana baadi, k tie pamanli ya puoba ki pia bid, k tie ŋɔlmi, k kpeli ki ŋaani biga po. ");
INSERT INTO guxg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Li yogunu bi ba maadi a juaciama: “baa mani ti po”, ki gɔ maadi a juabila “legni mani po.” ");
INSERT INTO guxg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kelima bi ya tiendi dasɔngu mama ne, bi ji ba tieni dakuogu ledi? ");
INSERT INTO guxg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bi bo ba yeni bibiadmu lie, k bo bi taani k kpaa ba yen o. ");
INSERT INTO guxg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ban bo pundi ya kaano, ki bi yi li: “yukpabgu”, bi kpaa jesu li dapɔnpɔnli po, wan yeni i bibiadmu lie yeni, yendi o ganga po, o lielo o jienu po. ");
INSERT INTO guxg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesu bo jaandi:... n baà, tieni sugli bi po, kelima bi ki bani ban tiendi yaali. A minteela den tɔni o tiadi, titia, ki bɔgdi bɔgdi. ");
INSERT INTO guxg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","O nuwuligu den se ki nua li kuli. k cedi o dogu yudanba den ñuadi k sua:... wan ka den fabi bi niba, wan ji fabi oba, o ki yedi k o tie U Tienu n lugdi yua kaa! ");
INSERT INTO guxg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A minteela mɔ den se ki la o. B den nagni ki ten o, li damilma, ");
INSERT INTO guxg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ki maadi:.. a ya bani k a tie suifinba bado, fabi a yuli! ");
INSERT INTO guxg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bi den diani ki tabni o yuli po k sua: “o ne tie Suifinba bado.” ");
INSERT INTO guxg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","I bibiadmu siiga, o yendi den sugdi jesu ki maadi a ki tie U Tienu tondo kaa? (U Tienu n lugdi yua) ");
INSERT INTO guxg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","O lielo den ŋmian o:.. a ki jie U Tienu? ");
INSERT INTO guxg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","tinba wan dagdi yenli: ti pa, ti biid panli, ama, o nulo ne ki pia tagiliba kuli. ");
INSERT INTO guxg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","K o pugni ki maadi:... jesu, ya tiani n po, ya yogunu k a do a baa kani ");
INSERT INTO guxg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ki jesu maadi o:... yen i mɔni, dine mɔno, a baa ye yen n aljada n, ");
INSERT INTO guxg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Li den tie yensiinu nni, k u dogu kuli gaa ki bondi, li bonbonli den waagi nani kudi ta yeni. ");
INSERT INTO guxg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","O Yienu ji dee nua, k o jaandiegu cabciangu padi siiga nni. ");
INSERT INTO guxg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeni ki jesu yigni:... n baa, n kubndi n naano a nugu nni. Wan maadi ki gbeni k o kpe. ");
INSERT INTO guxg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rom minteelkpeli n la li kuli k o dondi U Tienu k maadi:... yeni i mɔni, o ja ne bo tie U Tienu biga. ");
INSERT INTO guxg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ban den la yaali n tieni kuli, o nuwuligu den lebdi ki kuni ki pua bi pala po. ");
INSERT INTO guxg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesu donlinba yen bi pua yaabi n den ŋua jesu hali Galile den se fagma ki diidi li kuli. ");
INSERT INTO guxg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ja ba den ye ki bi yi u Sosef, o bo tie suifinba taanli yua, o den ki pia tagiliba kuli, ");
INSERT INTO guxg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","o den ki cengi bii ki tie Suifinba n suani yaali kuli. O den maani ki caa Arimate yen Sude dogun ki gu U Tienu baama. ");
INSERT INTO guxg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","O den gedi ki mia Pilat jesu gbanu(o kpiemo). ");
INSERT INTO guxg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wan den jiin o li dapɔnpɔnli po, k o finfin o a caba, ki duan o li kuli nni. Naani k ba baa ki pi kpiemo daan. ");
INSERT INTO guxg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Li den tie ŋaljuma, ki sua k saba da ki cindi. ");
INSERT INTO guxg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bi puoba yaabi den ŋua jesu hali Galile, bo ciani Sosef, bi den diidi li kuli, ki la ban pi jesu maama. ");
INSERT INTO guxg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Li puoli po ki lebdi ki kuni, ki pan bobni, ya kpanma nulu mani yeni tolali. Bi den gu Saba daali nani yiko n buali maama. ");
INSERT INTO guxg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Laadi daacincinli ku siŋapanpangu, ke bi puoba bobni ya tulali nuulu n mani, ki gedini li kakuli kani. ");
INSERT INTO guxg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ki diidi ki sua ke ya tangu n bi luoni li kakuli bulñɔbu bindi ki ŋa u tanfalu ke u yaa. ");
INSERT INTO guxg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ke bi kua li kuli nni, ama baa la O Diedo Jesu, gbannandi. ");
INSERT INTO guxg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ban ji ye see, kaa bani ban ba maali yaala, jaba lie ń ludi ba, ki sedi bi kani, ki la ya tiadi n ñilgi ");
INSERT INTO guxg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Keti jiwaandi cuo bi puoba yen kuli K b kul tibni a ke ji maad K be n cedi ke i kpaani yua yaab n fuo siign? ");
INSERT INTO guxg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O ji ki ye ne; o yiedi o ya tiani wan den maadi yaal ya yogu ke o den ye Galile ");
INSERT INTO guxg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Li buali ke nilo biga n'kua tbiid danba nu i nn, k ban kpaa'o ke wan fidi ki yiedi dana taa daali. ");
INSERT INTO guxg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ke bi ji tiadi Jesu maama. ");
INSERT INTO guxg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ke bi ñani li kuli; kani ki sani ki ban b waani bi piiga n yendo ");
INSERT INTO guxg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Li den tie Mari magdala, Jaan, Mari, Jak naa potɔba den pugdi ki waani o ŋɔdkaaba ");
INSERT INTO guxg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama, bi den ki ga li puoba maama, kelma li puoba maama den ki pia ma yul ");
INSERT INTO guxg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lan yog'nu Piar sani ki gedi li kuli kani ki duandi ki sua ke kadinga bili liba. Ke li lidi o bon cianla yen yaala n tieni. ");
INSERT INTO guxg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Li daali, ke yegni bilie ged ya dogu ke bi yi Emaus piiga n kilo lie, sedusalema dogu nni. ");
INSERT INTO guxg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bi den kali ki diidi yaala n tieni kuli ");
INSERT INTO guxg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ban cili ki boe, ki buali bi siiga nni yaala n tieni, ke Jesu nagni bi kani, ki yegi yeni ba ");
INSERT INTO guxg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ama, bi nuni den kan fidi ki la o, ki bandi ");
INSERT INTO guxg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu ń maadi ba, yinba bilie ne cuoni ki maadi be ya maama i? Ban sedi yeni li pabɔnli ");
INSERT INTO guxg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bi siiga nni, yua ke bi yi Keleyopasi ń jiini o, “Fini a baba n ye Jerusalema ne, kaa bani ya bona n tieni nekanba a dana ne?” ");
INSERT INTO guxg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu ń buali o “Be ya bona” ban jiini o “Li bona nua Nasleti yua, Jesu, yua n den tie ya sawalpualo n pia u paaciamu, U Tienu kani leni bi niba kani, o tuona nni leni o maama nni. ");
INSERT INTO guxg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ke salga yidkaaba yudanba leni ti yikodi cuo o ki cabi ke ban buu, ki cuo o, ki kpa o, ki kpaa o li daapɔnpɔnli po. ");
INSERT INTO guxg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ama ti bi daani ke wani n bi ba faabi Isayeli. Nn, Lani baba ka, li bona ń tieni dantaali n yeni. ");
INSERT INTO guxg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ama, yaali n pugdi, ti cagli nni ya puoba n gedi li kakuli po ku siŋapanpangu n kuani ti ku yaalidgu ");
INSERT INTO guxg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ban ki la ti gbannandi, ke bi guani ki maadi ke malekinba dɔgdi bi kani, ki maadi ke o pia li miali ");
INSERT INTO guxg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ya jaba n bi ye leni ti gedi li kakuli po, ki sua ke li tie nani bi puoba ń maadi maama yeni. Ama bi ki la o.” ");
INSERT INTO guxg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesu ń yedi ba “hain, bi yanluodanba yaaba ya pala n ki kagi leni mi dugi o sawalpualo ń yedi yaala ya po ");
INSERT INTO guxg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Li den ki buali ke kirisiti ń la fala, lan ya bona po ka ki fidi ki kua o kpiagdi nni i? ");
INSERT INTO guxg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ki cili hali Moyiisi, ki tuadi bi sawalpuaba, ki sɔgni ba ya bona n nua wani o bá i diani nni kuli. ");
INSERT INTO guxg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ban den nagi ban caa ya dogbiga nni, ke Jesu tieni nani o bua suagi liiga yeni. ");
INSERT INTO guxg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ke bi niidi o ki maadi o “Cani ti kelima li ji ŋmani yenjuogu i, li daali juodi n yeni.” Ke Jesu kua ki ye leni ba. ");
INSERT INTO guxg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wan kali yeni ba, ki bua ki bua di, ke o taa kpanu, ki yadi mi yedŋanma li po, ki ŋmiidi, ki teni ba. ");
INSERT INTO guxg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","lanyogu ke bi nuni ji luodi, ke bi bandi o, ke o bodi bi nunga nni. ");
INSERT INTO guxg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ke bi ji maadi bi ŋmiali nni, “Wan bi maadi leni ti u sanu nni, ki luodi ti nuni i diani po yeni, ti pala bi ki co nani u mu yeni ka aa?” ");
INSERT INTO guxg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","lanyognu, ke bi fii, ki gedi Jerusalema ki la ke piiga n yendo yeni ke bi taani, ki ye leni bi lieba, ");
INSERT INTO guxg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ki maadi, “O Diedo fii bi tinkpiba siiga, mɔmɔni liga. O dɔgdi o yuli ki waani Siimɔn “ ");
INSERT INTO guxg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","lanyognu ke bi tondkaliedba dugni ba yaali n tieni u sanu nni ban bo yegi, yeni Jesu ń waani o bá maama, wan ŋmiidi kpanu ya yognu ke bi bandi o. ");
INSERT INTO guxg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ban den maadi li bona maama ya yognu, ke Jesu wani liga legdi ki sedi bi siiga nni, ki maadi ba, “Mi yanduanma ń ya ye leni yi. ");
INSERT INTO guxg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ama, bi yama ń́ ŋmadi, ti jawaandi ń kua ba, ke li tie nani bi la fanfandgu yeni. ");
INSERT INTO guxg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesu ń yedi ba “la tieni ledi i ke i yama ŋmadi? Be ya po i ke i buali i pala nni? ");
INSERT INTO guxg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Diidi mani n nui leni n taana, li tie mini ligi i. Sii mani nni ki diidi. Kelima ciciiga ki pia nandi ki buali kpaba nani yin la ke mini pia maama. ");
INSERT INTO guxg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wan maadi yeni, ke o waani o nui leni o taana ");
INSERT INTO guxg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ban dá den tie yaaba n ki pia dudugdi yeni, ke li pamanli ŋmadi yeni tama, bi den ki daani, Jesu ń maadi ba, “yii pia jiema bá aa?” ");
INSERT INTO guxg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ban teni o janŋaadjenli. ");
INSERT INTO guxg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesu ń ga, ki ŋmani bi nunga nni. ");
INSERT INTO guxg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ki yedi ba, “Min den ye leni yi n den maadi yi ke ban diani yaali Moyiisi yikodi maama leni bi sawalpuaba maama leni pisoma nni kuli buali ke lan tieni ki dudi i.” ");
INSERT INTO guxg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ki ji pibdi bi yama, ke li buali ke ban cengi i diani. ");
INSERT INTO guxg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ki maadi ba, “Yeni ke li diani ke li buali ke Kirisiti ń la fala, ki kpe, ki yiedi bi tinkpiba siiga li daataali daali ");
INSERT INTO guxg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ke o yeli po, bi ba kpaandi o laabaaliŋamo, ki cili Jerusalema, ki gedi i nibuoli kuli po, ke ban lebdi bi pala ki baa bi tuonbiidi sugli. ");
INSERT INTO guxg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yinba n tie kasiedinba lanya bona po. ");
INSERT INTO guxg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Diidi mani, n sɔni n Báa ñɔnianu i po. Ama, yin guudi u dogu nni, hali ya daali ke u paalu ba ña tanpoli ki jiidi i po. ");
INSERT INTO guxg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ke Jesu ñani ba ki gedi leni ba hali naani n nagni Betaani. Ke o duoni o nui, ki yadi mi yedŋanma bi po. ");
INSERT INTO guxg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wan den yadi mi yedŋanma bi po ya yognu, ke o siedi bi kani, ke bi duoni o tanpoli. ");
INSERT INTO guxg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lani ke bi dondi o, ki guani ki lebdi Jerusalema leni li pamancianli. ");
INSERT INTO guxg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bi ji den li ye li jaandieli nni ki kpiagdi U Tienu yeli ");
INSERT INTO guxg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","U cilyogu, mi maam n bo ye, mi maama bo ye yeni U Tienu, mi maama bo tie U Tienu ");
INSERT INTO guxg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mi bo ye u cilyogu yeni U Tienu. ");
INSERT INTO guxg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Bi tieni bonli kuli yeni mani i. Ke ban tieni yaali kuli, liba ki tieni ke maa ye. ");
INSERT INTO guxg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Li miali bo ye mani nni i, ke li miali bo tie bi niba yenyenma ");
INSERT INTO guxg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mi yenyenma yendi li bɔnbɔnli nni, ke li bɔnbɔnli ki tuo ki ga ma. ");
INSERT INTO guxg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ke U Tienu sɔni nilo, o tondo, ke bi yi o Jan. ");
INSERT INTO guxg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ke o cua, ki tua kasiedi ki ba kadi ki maadi mi yenyenma nni, ke yua kuli ń fidi ki dugi o maama po ");
INSERT INTO guxg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","O bo ki tie mi yenyenma, ama o dɔgdi ke wan saa i mɔni mi yenyenma po ");
INSERT INTO guxg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Li yenyenma bo tie yenyenmɔnma, ki cua ŋanduna nni, ki yendi bi niba kuli po. ");
INSERT INTO guxg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mi bo ye ŋanduna nni, mani n tagi ŋanduna, ama ŋanduna ki bandi ma ");
INSERT INTO guxg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mi bo cua mi yaaba siiga, ama mi yaaba naa bo tuo ki ga ma. ");
INSERT INTO guxg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama, yaaba n ga ma po yeni yaaba n dugi mi po, mi cabi ba u paalu ke ban tua U Tienu bila ");
INSERT INTO guxg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bi mali ke li naa tie mi sɔma po, li naa go tie ti gbannandi buama po ki nan buali o nisaalo buama po; ama U tienu po. ");
INSERT INTO guxg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ke mi maama tua nisaalo, ki cua ki ye ti siiga, ki gbie yeni li ŋanbli yeni i mɔmɔni; ke ti la, ki ñuadi o kpiagdi, ya kpiagdi n tie ki bonjayenga yua n ñani Ba po ya kpiagdi. ");
INSERT INTO guxg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jan saa i mɔni o po, ki kpaandi, ki maadi: N maadi o ya maama i, ki tua “Yua n ŋua n puoli po, bo liidi nni, kelima o bo ye ke n dá ki ye. ");
INSERT INTO guxg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","O ŋanbli yeni o ŋalmani yaali n ki pia gbenma po, o cabi ti li ŋanbili yeni mi yedŋanma, ");
INSERT INTO guxg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kelima Moyiis den teni yiko, ke li ŋanbli yeni i mɔmɔni ñani Jesu kiristo kani i ");
INSERT INTO guxg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nilobá kuli ki kpeli ki la U Tienu; Ki bonjayenga yua n ye leni Ba, wani n cedi k bi bandi o. ");
INSERT INTO guxg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jan kasiedi n ne: Jufnba bo sɔni Jerusalema salga yidkaaba yeni yiko gbanbanda, ke bi cua ki buali o: “Fini, a tie ŋma i?” ");
INSERT INTO guxg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ke o kadi ki yedi, kaa nia; o bo yedi ba ke wani ka tie Kiristu. ");
INSERT INTO guxg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ke bi buali o: Li nan ga ledi i? A tie Eli yo oo? Ke o yedi: mii tie o. Atie sawalpualo yo oo? Ke o jiini: N n. ");
INSERT INTO guxg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Lanwani i, ban maadi o: A tie ŋma i? A ba yedi be a yeceli po? lan todi ti tin caa yaaba sɔni ti u tondu ");
INSERT INTO guxg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wan maadi: mini n tie yua ya nialu n kpaandi ki tinkuonga nni ki tua: «Naadi mani, ki sali O Diedo sanu, nani o sawalpualo Esayi ń yedi maama.» ");
INSERT INTO guxg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisienba ń sɔni ya tonda ń buali o: ");
INSERT INTO guxg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Be n cedi ke a batise bi niba, ki naa tie Kiristo, kaa tie Eli, ki naa go tie sawalpualo? ");
INSERT INTO guxg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jan ń jiini ba: «Mini, N batise yeni mi ñima. Ama ti siiga nni, nilo ye, ke i ki bani o, ke o ba cua n puoli po ");
INSERT INTO guxg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","N ki dagdi yeni min lodi o taacaaŋui.» ");
INSERT INTO guxg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ya bona ne kuli den tieni Betani dogu nni, Jurden kpenjaali po, naani ke Jan bo batise bi niba. ");
INSERT INTO guxg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lan fandi, wan la Jesu, ke o kpendi o kani, wan maadi: Diidi mani, U Tienu pabiga n yeni yua n piindi ŋanduna biidi. ");
INSERT INTO guxg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","N maadi wani ya maama i, ki tua: «Nilo ŋua n puoli po, ki nan lii nni, kelima o den ye ke n dá ki ye. ");
INSERT INTO guxg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","N den ki bani o, ama li tie ke lan tua bonwaankaali Isayeli po, ke n cua ki batise yeni mi ñima. ");
INSERT INTO guxg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jan tieni ya kasiedi ne, ki waani: «N la ke mi foŋanma ñani tanpoli nani ki kpajiega yeni, ki jiidi ki sedi o po. ");
INSERT INTO guxg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","N den ki bani o; ama yua sɔni nni ke n batise yeni mi ñima yeni, wani n maadi nni: «ŋan ba la mi foŋanma ke mi jiidi ki sedi yua ya po yeni, wani n batise yeni U tienu Foŋanma.» ");
INSERT INTO guxg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ke n la, ki tieni kasiedi, ki waani, ke wani n tie U Tienu Bijua. ");
INSERT INTO guxg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lan fandi, ke Jan go ye likani yeni o ŋɔdkaaba bilie, ");
INSERT INTO guxg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","wan la Jesu ke o pendi, ke o maadi: «Diidi mani U Tienu Pebiga n yeni.» ");
INSERT INTO guxg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Li ŋɔdkaliedba ń gbadi Jan maama, ban ŋɔdi Jesu. ");
INSERT INTO guxg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesu ń gbagi ki la ke bi ŋua o, wan maadi ba: «I kpaani be? Ban jiini o: Rabbi (li niima nni tie Canbáa - o tundka - A ye le i? ");
INSERT INTO guxg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Cua mani, ki diidi. Ban ŋɔdi, ki la wan ye naani, ki tundi yeni o lan daali. Li den tie nani kudi piiga po yeni. ");
INSERT INTO guxg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Siimɔn ninjua Andere den tie yaaba n gbadi Jan maama, ki ŋɔdi Jesu yeni siiga nni, yendo. ");
INSERT INTO guxg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Wani n kpia ki cendi o ninjua Siimɔn, ki maadi o: «Ti la Mesi» (lani n tie Kiristu) ");
INSERT INTO guxg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ki ciani o Jesu kani, Jesu ń nuali o, ke o maadi: «A tie Siimɔn i, Jonas bijua; bi ji ba yini a Sefas (li niima nni n tie Tangu) ");
INSERT INTO guxg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lan fandi ke Jesu bua gedi Galile, ki la Filip, ki maadi o: Ya ŋua nni. ");
INSERT INTO guxg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip bo tie Betsayida yua i, Andere yeni Pieri dogu. ");
INSERT INTO guxg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip ń cendi Natanayel, ki maadi o: «Ti la Moyiis ń diani yua ya po yiko tili nni, ke bi sawalpuaba maadi o maama yeni, Josef bijua, Jesu, Nasaret yua.» ");
INSERT INTO guxg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel ń yedi o: «Bonŋanli ba fidi ki ña Nasareti dogu nni ii? Filip ń jiini o: Cua ki diidi. ");
INSERT INTO guxg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu ń la ke Natanayel kpendi o kani, wan maadi o po ya maama ne: Diidi mani, o ne tie Isarayeli yua i cain, laa pia tudma! ");
INSERT INTO guxg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel ń buali o: A bandi nni le i? Jesu ń jiini o: «Hali ke Filip dá ki yini a ŋan bi ye bu kankanbu kani, n bi la ŋa.» ");
INSERT INTO guxg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayel ń jiini ki yedi o: Rabbi, a tie U Tienu bijua i, a tie Isarayeli Badciamo i. ");
INSERT INTO guxg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu ń guani ki jiini o: «Min maadi a ke n la ŋa bu kankanbu ñiali n cedi ke a dugi; a ba la ya bona n yabi ki cie ne. ");
INSERT INTO guxg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ki maadi o: «I mɔmɔni, n maadi yi, u yogu kpendi, ke i ba la ke tanpoli luodi ke U Tienu malekinba do ki go ji o nisaalo Bijua po.» ");
INSERT INTO guxg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dana taa ń pendi, ke li pocaali tieni Kana dogu nni, Galile diema nni. Jesu naá den ye li kani, ");
INSERT INTO guxg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bi den yini Jesu yeni o ŋɔdkaaba mo li pocaajaanma po. ");
INSERT INTO guxg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ku daamɔngu ń ti pɔdi, Jesu naá ń maadi: “Bi ji ki pia daamɔngu. ");
INSERT INTO guxg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu ń jiini o: «Pua, be n ye mini yeni fini siiga? N yognu dá ki pundi.» ");
INSERT INTO guxg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","O naá ń maadi o tuosɔnba: “O ya maadi yaali kuli, yin tieni.” ");
INSERT INTO guxg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Li sua ke cunbobciandi luoba ye li kani ki tie tana yaadi, ke yengu kuli ba fidi ki ga boba lie bii a taa ñima. bi den sieni ti juufinba ñincuoma bogda po i. ");
INSERT INTO guxg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu ń maadi ba: «Gbieni mani ti cunbobdi ne yeni mi ñima.» Ban luuni mi ñima ki gbieni ti hali i ñɔmiani. ");
INSERT INTO guxg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","To, kabi mani ki gedi ki teni mi pocaajiema yudaano. Ban kabi ki gedi ki teni mi jiema yudaano. ");
INSERT INTO guxg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mi pocaajiama yudaano n ́ leni ya ñima n kpandi mi daama, ki nan ki bani man ñani naani, ama ke Jesu tuonsɔnba yaaba n luuni mi ñima yeni wani nan bani, wan yini o pocaano calo. ");
INSERT INTO guxg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ki maadi o: “Yua n bobni mi jaanma kuli yen cili ki ñani ya daama n mani, o canba ya ñuni ki guo, wan ji ñani ya daama n ki ŋanbi ki mani. Fini wani nan guuni mi daamanma hali yeni mɔlane. ");
INSERT INTO guxg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Lani n tie Jesu ń cili ki tieni ya yaalidgu bonli Kana, Galile diema nni. Lani n dɔgdi ki waani Jesu yudandi, ke o ŋɔdkaaba tuo ki dugi o po. ");
INSERT INTO guxg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lani ń pendi, ke o jiidi, ki gedi Kapernawuma yeni o naá, o ninjaba yeni o ŋɔdkaaba, ke bi tieni li kani a dana waamu. ");
INSERT INTO guxg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juufinba paki jaanma den nagi, ke Jesu guani ki doni ki gedi Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ki gedi ku jaandiegu nni, ki la ke yaaba n cendi i ligi yeni a yankpenkpenda kaa lienni, ki kuadi i nee, i pee yeni i kpaajiemu. ");
INSERT INTO guxg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ke o taa baabu, ki gbabi ke bu tua finfibli, ke o pua ki beli ki ñani ba ku jaandiegu nni, ki ñani ti yandi, ki tudi ki yayadi bi liglebdiba ligi, ki tudi ki luluni bi kaga yeni bi taablinba. ");
INSERT INTO guxg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ki maadi a kpajekuada: «Ñani mani ne kuli ki fuadi, da cedi mani n Báa diegu ń kpandi kpenkpendidiegu. ");
INSERT INTO guxg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","O ŋɔdkaaba ń tiadi ke li diani ki waani: “A diegu yankuatuonli siagi n pali boncianla.” ");
INSERT INTO guxg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juufinba ń ga mi maama ki buali o: “A ba waani li laa yaalidgu bonli i, ki tuadi nanda? ");
INSERT INTO guxg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu ń guani ki jiini ba: «Pua ki mudi mani ku jaandiegu ne, dana taa baba ba dagdi min guani ki maa ki fiini gu. ");
INSERT INTO guxg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Juufinba ń maadi: “Ti tieni piina n bina luoba i, ki maa ki juodi ku jaandiegu ne; ke fini wani tua ke aba guani ki fiini gu dana taa baba! ");
INSERT INTO guxg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama o den maadi o gbannandi ya jaandieli i. ");
INSERT INTO guxg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Lani n cedi, wan yiedi bi tinkpiba siiga nni, o ŋɔdkaaba tiadi ke o den maadi li maama, lani n den cedi ke bi dugi i diani po yeni Jesu ń den maadi ya maama kuli po. ");
INSERT INTO guxg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesu ń den ye Jerusalema Paki jaanma dana nni, bi niba boncianla den la o yaalidgu tuona, ki tuo ki dugi o yeli po. ");
INSERT INTO guxg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama Jesu wani den ki dugi bi po kelima o den bani bikuli. ");
INSERT INTO guxg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","O den ki bua ke bi tieni kasiedi nilobá po kuli kelima wani o bá den bani yaali n ye o nisaalo nni. ");
INSERT INTO guxg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ama o nilo den ye Farisienba siiga nni, ke bi yii o Nikodema, ke o tie Juufinba bado, ");
INSERT INTO guxg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","O den cua Jesu kani ku ñiagu, ki maadi o: “Rabbi (Canbáa), ti bani ke a tie banciamo i, ki ñani U Tienu kani; kelima obá kuli kan fidi ki tieni ŋan tie ya yaalidgu bona ne li ya ki tie ke U Tienu ye yeni o. ");
INSERT INTO guxg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu ń jiini o: «I mɔmɔni, i mɔmɔni, n maadi a, nilo ya ki guani ki mali ki pandi o bá, o kan la U Tienu diema. ");
INSERT INTO guxg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodema ń buali: “O nilo ba tieni ledi i, ki guani ki mali, ki nan kpelgi o? O ba fidi ki guani ki kua o naá tugu nni ki go mali ii? ");
INSERT INTO guxg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu ń jiini o: «I mɔmɔni, i mɔmɔni, n maadi a, nilo ya ki mali yeni mi ñima yeni mi foŋanma, o kan kua U Tienu diema nni. ");
INSERT INTO guxg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ti gbannandi ń mali yaali tie gbannandi, Mi Foŋanma ń mali yaali mo tie Foŋanma. ");
INSERT INTO guxg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Lan da lidi a ke n maadi a: «Li buali ke ŋan guani ki mali, ki pandi a bá.» ");
INSERT INTO guxg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","U faalu figi un bua naani i, ke a gbia u fuugu, ama a nan ki bani un ñani naani, ki caa naani. Li go tie yeni i, ya nilo ke mi foŋanma mali o. ");
INSERT INTO guxg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodema ń buali o: “Li ba tieni ledi i? ");
INSERT INTO guxg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu ń jiini o: «A tie Israyeli banciamo i, ki nan ki bani ya bona ne ee? ");
INSERT INTO guxg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","«I mɔmɔni, i mɔmɔni, n maadi a, ti maadi tin bani yaali, ki tiendi kasiedi ki kadi ki maadi tin la yaali; ke yinba wani nan ki tuo ki ga ti kasiedi maama. ");
INSERT INTO guxg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N ya maadi tinga n ne maama ke maa pia o po dudugdi, a ba tieni ledi i, ki ya dugi min ba maadi a tanpoli bona po? ");
INSERT INTO guxg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nilo bá́ kuli ki doni tanpoli, li nan ya ki tie yua n ñanu tanpoli ki jiidi yaa ka, O nisaalo Bijua yua n ye tanpoli. ");
INSERT INTO guxg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nani Moyiis ń den fiini ki sieni o waa ki tinkuonga nni yeni, li buali ke ban fiini ki sieni o nisaalo Bijua mo yeni i, ");
INSERT INTO guxg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","lan fidi ke yua n dugi o po ń baa ya miali n ki pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kelima U Tienu buadi ŋanduna hali ki teni o bijayendga, lan fidi ke yua n dugi o po wan da kpe ka, ama wan baa ya miali n ki pia gbenma ");
INSERT INTO guxg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yin ya bani ke U Tienu ki sɔni o Bijua ŋanduna nni ke wan jia ti buudi yeni ŋanduna ka, ama ke o po, ŋanduna ń baa mi faabma. ");
INSERT INTO guxg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yua n dugi o po, bi ji kan jia o buudi; ama yua n ki dugi o po, bi tuodi ki jia o buudi o, kelima o nan ki tuo ki dugi U Tienu bijayenyenga yeli po. ");
INSERT INTO guxg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lanya buudi tie be i, mi yenyenma cua ŋanduna nni, ke bi niba faadi li bɔnbɔnli ki cie mi yenyenma, kelima bi tuona den tie tuonbiadi ");
INSERT INTO guxg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kelima yua n tie ti biidi ki bua yenyenma maama, o kan gedi mi yenyenma nni, kelima mi ba pibdi ki waani o tuonbiidi. ");
INSERT INTO guxg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama yua n tuuni yeni i mɔni lingi mi yenyenma ń ye naana, keli ma mi ba pibdi ki waani ke o tuona dagdi yeni U Tienu ń bili maama. ");
INSERT INTO guxg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lani ń pendi, Jesu den yegi yeni o ŋɔdkaaba ki gedi Jude tinga nni. O ji den ye li kani yeni o ŋɔdkaaba ki batise bi niba. ");
INSERT INTO guxg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jan mo den ye Enɔn, ki batise bi niba, kelima mi ñima den yabi li kani, ke bi niba mo kpendi boncianla ki bua wan batise ba. ");
INSERT INTO guxg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Lanyogu Jan dá den ki kua dansalga (li kpaadidieli nni) ");
INSERT INTO guxg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Li sua ke Jan ŋɔdkaaba den gagi yeni Juufi yendo, ke li nua mu cicibiadmu beliga jaandi po. ");
INSERT INTO guxg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ke bi cua ki la Jan ki maadi o: Rabbi, ŋan den ye yeni yua Juurden kpenpuoli yeni, ŋan den tieni kasiedi yua ya po yeni, o mo ji batise bi niba, ke bi kuli ji caa o ya kani i. ");
INSERT INTO guxg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jan ń jiini ba: “Nilo kan fidi ki baa yaali n kandi ban puni o yaali tanpoli. ");
INSERT INTO guxg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yinba mono tie n kasiedinba, ke n maadi: “N ki tie Kiristu, ama bi sɔni nni o liiga i.” ");
INSERT INTO guxg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yua n yeni o pocaano tie o calo i; ama o calo dɔnli yua n kuu ba, ki cengi o poja maama pali mani boncianla yeni wan cengi o ja nialu: lanya pamanli tie n mo ya pamanli i, ki tie bonŋancianli. ");
INSERT INTO guxg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Li buali ke wani ń ya kpedi ki pugdi, ke mini wadi. ");
INSERT INTO guxg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yua n ñani tanpoli yabi ki cie bonli kuli; yua n tie ki tinga yua li tie tinga yua i, o maadi nani ki tinga yua yeni i. Yua n ñani tanpoli n cie bi niba kuli. ");
INSERT INTO guxg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","O tiedi kasiedi, ki kadi ki maadi wan la yaali yeni wan gbadi yaali, ama obá kuli naa cengi o kasiedi maama. ");
INSERT INTO guxg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yua n tuo ki ga o kaseidi maama kadi ki maadi, ki waani ke U Tienu tiegi, ki tie mɔmɔndaano. ");
INSERT INTO guxg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kelima U Tienu ń sɔni yua maadi U Tienu maama, kelima U Tienu ń teni o ya foŋanma ki pia biginma. ");
INSERT INTO guxg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Báa bua Bijua, ki mubni bonli kuli o nui nni. ");
INSERT INTO guxg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yua dugi Bijua po baa pia ya miali n ki pia gbenma; yua n ki dugi Bijua po kan la miali, ama U Tienu pabienli n baa maa o yuli po. ");
INSERT INTO guxg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisien nba n gbadi ki ti yonbdaano laadi bi niba ki wuulibi U Tienu ñima ki cie San. ");
INSERT INTO guxg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","I mɔni Jesu ka bi wulibi, o ŋuantieba n bi wulibi, ");
INSERT INTO guxg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ko ñani Jude ki guani ki lebdi Galile ");
INSERT INTO guxg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Li den tie mabili k wan tɔgni Samari, ");
INSERT INTO guxg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","k o caa ki te pundi Samari dogbigi ba ki bi yiil Sisaari, lii bo fagi yeni Jakobi n den teni o bijua Sosiaf ya tingi yeni kani. ");
INSERT INTO guxg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ki jakobi caali bo ye li kani, ki Jesu cuon cuoni ki te cɔgi, ki ji kaa li caali kani, li den tie nani kudi lie yeni. ");
INSERT INTO guxg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ki Samari pua ba cua ki bua luuni mi ñima ki ñu. ");
INSERT INTO guxg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kilima o yegni den gedi o dogun, ki bua lingi li bonjekaali ");
INSERT INTO guxg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ki Samari dogun pua ne maadi o: ledi ki fin Juufi buali min Samari pua mi ñima po i? kilima juufi nba yeni Samari yabi bo ki mani. ");
INSERT INTO guxg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ki Jesu guani ki ŋmiani o: a ya bani U Tienu paabi, ki bani yua n miadi mi ñima ki bua ñu ne, fini mɔno bo bi miagu mi ñima, ki wan ten a mi ñinŋanbi. ");
INSERT INTO guxg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","K ol pua ne maadi, ti yonbidaano ŋaa pia bonli ki bi luuni, ki li caalio mɔ gɔ ñua, a bua la le i li ñunŋanbi? ");
INSERT INTO guxg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","fin n cie ti baa jakobi yua n den teni ti li caali? li caali ki wani yeni o bila yeni o bonkobdi kuli ñu. ");
INSERT INTO guxg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ki Jesu ŋmiani o: ya nibi kuli ñuni mi ñimi ne, o ñuñuni gɔ ba cuobi. ");
INSERT INTO guxg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ama yua n ñu ya ñima k n ba teni, ñuñuni kan bamgi cuogu, k min ba teni ya ñima baa tie o po nani ñunbunbungi yeni ya mialiki pia gbemi ñima bundi lien nni. ");
INSERT INTO guxg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","O pua yeni n maadi o: ti yonbidaano ten nni li ñima, ki ñuñuun n ji da baa ki cuon, ki min ji da baa cua ne ki luuni mi ñuma. ");
INSERT INTO guxg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ki Jesu maadi o, ki wan gedi ki pan yiini o calo n cua na. ");
INSERT INTO guxg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","O pua yeni jiini, mii pia ja. Ki Jesu yedi o, a maadi mɔni ki ŋaa pia ja i. ");
INSERT INTO guxg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kilima, a pia jabi mui, ki ŋan gɔ ye yeni yua mɔlane mɔ ki tie a calo ka. A li yedi i mɔni. ");
INSERT INTO guxg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","O pua yeni jiini, ti Diedo, n bani k a tie U Tienu tondu i. ");
INSERT INTO guxg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ti baa nba den dondi U Tienu li juali ne po i; ki yinbi ji yedi ki jerusalem n pia naan kani ki baa dondi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ki Jesu ŋmiani o pua yeni, ŋanbi ki cengi n maami, o yogu baadi ki ji te kan gedi li juali po ki buali jerusalem ka, ki bua dondi ti diedo (baa U Tienu). ");
INSERT INTO guxg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yinbi wani dondi yin ki bani yua i, ki tinbi dondi tin bani yua, kilima gaapo ñani juufi nba kani. ");
INSERT INTO guxg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama o yogu cuoni, li yogu pundi mɔno, yaabi n dondi ti baa U Tienu yeni bi pali, i mɔmɔni nni, kilima ti baa U Tienu kpaani yaabi n baa pug o i. ");
INSERT INTO guxg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","U Tienu tie fuoŋanbi ki ya dondo yeni i mɔmɔni. ");
INSERT INTO guxg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","K o pua yeni maad o: N bani k U Tienu tondu bi cua (yua ki bi yigu krisu) o ti ya cua, o bi waani a bona kuli. ");
INSERT INTO guxg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesu n maad o: min mɔno, min yua maadi yen a ne. ");
INSERT INTO guxg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Li yognu ki jesu yegni guani, ki li yaakilidib yeni ban lagu k o pagi yeni Samari pua. Ama oba naa tuo ki buali wan kpaani bii wan pagi yen o yaali ya po. ");
INSERT INTO guxg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ko pua yeni ji ŋaa o cuali, ki lebdi o dogun ki pan maadi bi niba. ");
INSERT INTO guxg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Cua mani ki diidi ya ja n maadi n min sɔni yaali kuli, wan ka baa tie krisui? ");
INSERT INTO guxg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ki bi nibi ñani o dogun ki cua jesu kani. ");
INSERT INTO guxg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ki li yognu, k o yegni balimo k wan di, ki tua Rabi ya di. ");
INSERT INTO guxg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ama ki Jesu maadi ba: min pia ya jiem ki ba je yeni, i ki ban li. ");
INSERT INTO guxg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","K o yegni ji maadi bi ŋmiali nni: ki nul n baa ten o mi jiema k o jen biii? ");
INSERT INTO guxg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ki jesu yedi bi: n jiedi tie ki min sɔni yua n sɔni nni n bua yaali, ki sɔni o tuona kuli ki juodi. ");
INSERT INTO guxg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yi maadi ki bontutugu yogu sieni ŋmaali na kaa i? Diidi mani, n maadi; yaadi mani ki diidi o kpaabi, li ji pieni fuaa, o bonyendi yogu pundo. ");
INSERT INTO guxg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yua pedi i dii, wan ga o paagu, o ji taandi li bona ki ŋuundi ya miali ki pia gbemi bualin, ki lan fidi ki yua den buli yeni yua n pedi n ya ye li pamanli nni. ");
INSERT INTO guxg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kilima ban maadi yaali tie i mɔni, yua buli ye oba i, ki yua pedi mɔ ye oba. ");
INSERT INTO guxg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N suani ki yin gedi ki pedi ya kpaabu ki dee koni; bi tɔbi n den koni li kpaabu ki la fala, ki yinbi ji bi je bi fala ñuadi. ");
INSERT INTO guxg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samari dogu n nibi boncianli bi tuo jesu, kilima o pua yeni bi bi maadiba: o maadn min baa suani yaali kuli n yenyienu n. ");
INSERT INTO guxg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samari yaabi cua ki la jesu, ki bi balimo ki wan cua k ya ye yenbi, k o tieni bi kani daa lie. ");
INSERT INTO guxg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ki bi niba boncianli duu o po, ki dugni o maami po. ");
INSERT INTO guxg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ki bi maadi o pua yeni: laa tie ki ŋan yedi ti yaali ka cedi ki ti du o po; tinbi mɔno den tuodi gbadi yeni i mɔni k wan n tie ŋanduna gaapo. ");
INSERT INTO guxg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Li dana lie n pendi, ki jesu ñani li dogun ni ki gedi Gaaliile. ");
INSERT INTO guxg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kilima wan mɔno bi maadi k U Tienu tondikaabi kan la li cɔligu bi dogun yaabi kani. ");
INSERT INTO guxg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wan pundi Gaaliile, k li dogun yaabi ŋanbi ki gaagu, ki bi den la wan den tieni yaali Jerusalem m jaam yogu, k li ma bi mɔ den gedi k b di li jaami. ");
INSERT INTO guxg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","K o guani ki lebdi Kaana, Gaaliile dogun ni, naani k o bi cedi k mi ñim kpandi o damɔngu. L sua ki yiko daano ba ye Kafarnawum k o bigi yia. ");
INSERT INTO guxg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wan gbadi ki jesu ñani Jude ki cua Gaaliile, k o nagni o kani ki miagu sugli ki wan mɔndi ki jiidi Kafarnawum k tebi o bijua, li sua ki li bigi nuud mi kuumo. ");
INSERT INTO guxg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ki jesu maadi o: i ya la ti palidi yeni yaalidigu bona, i kan baa ki duu n po. ");
INSERT INTO guxg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","K li yiko daano maadi o: ti yonbidaano cua tin gedi ki sua ki bigi da ki kpe. ");
INSERT INTO guxg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ki jesu maadi o: ya kuni, a bijua paag o. K o gaa jesu n yedi o ya laabaali ki ji kuni. ");
INSERT INTO guxg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","O den paa o san po i, k o tuonsɔnla tuog o ki maad o, a bijua paago. ");
INSERT INTO guxg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","K o bualib ya yognu po k o won paagi, ki bi maadi o: k wonli kudlele yognu k o gbanu won sɔngi ");
INSERT INTO guxg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","K bi baa tiadi k li yognu k jesu won maad o k o bigi paag o. Li daali ki wani yeni o deni yaabi kuani bi dindanli jesu nni. ");
INSERT INTO guxg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ki jesu ñan Jude ki guani Gaaliile guani ki tieni yaalidigu bona taalm lie po. ");
INSERT INTO guxg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lani ń pendi, Juufinba den pia mi jaanma, ke jesu gedi Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jeruselema yeni, den pia ñunpindbuogu ke ku yi Jesu danba maama nni, Betesda, ke gu kuu yeni li paloli bulñɔbu, ki pia ciadi mu. ");
INSERT INTO guxg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","bi yianba bonciala den dua li ciadi nni kuli: a juama, a diama, mu wabmu, yeni ti gbannankpiendi danba, ke bi kaa ki guu mi ñima lengdima; ");
INSERT INTO guxg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kelima li den pia ya yognu ke maleki den yi jiidi ki gbidi mi ñima; yua den kpia ki jiidi mi ñima ń gbidi ya yognu, o den yi paagi; hali wan yia ya yianu kuli. ");
INSERT INTO guxg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","O yiamo den ye likani, ki yiagi hali piitaa n bina niin n yeni. ");
INSERT INTO guxg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesu ń la o ke o dua, ki bandi ke wan yiagi li waagi, ke o buali o: «A bua ŋan paagi ii? ” ");
INSERT INTO guxg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","O yiamo ń ŋmiani o “N Diedo, n ki pia yua n ba todi nni min jiidi ku ñinbuogu nni mi ñima ń lengdi ya yognu. N ya nagni, n ba sua ke nitiano kpia ki jiidi ki ŋa nni. ");
INSERT INTO guxg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesu den yedi o: «Fii ki taa a duakaagu ki ya cuoni.» ");
INSERT INTO guxg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lanyognu liga, o yiamo ń paagi, wan taa o duankaagu ki ya cuoni. ");
INSERT INTO guxg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Li den tie mi fuodma daali i, Juufinba ń buali yua n paagi yeni; “Dinne tie fuodma daali, li ki buali ke ŋan taa a duankaagu. ");
INSERT INTO guxg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wan guan ki ŋmiani ba: “Yua n paagi nni maadi nni ke min taa n duankaagu ki ya cuoni.” ");
INSERT INTO guxg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ban buali o: “ŋma yedi a ke ŋan taa a duankaagu ki ya cuoni?” ");
INSERT INTO guxg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ama yua n den paagi den ki bani yua n paagi o; kelima Jusu den kua ku nilgu nni ke waa ji bandi o. ");
INSERT INTO guxg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lan pugni waamu ke Jesu guani ki cendi o li jaandieli nni, ki maadi o: Mɔla, a paagi; ji da tieni tuonbiadi ke yaali n cie a yianu ne ń ji da cuo ŋa. ");
INSERT INTO guxg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yua n paagi yeni ń gedi ki maadi Juufinba ke Jesu n paagi o. ");
INSERT INTO guxg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lani n cedi ke Juufinba den ŋua Jesu yeni mi yibalma, kelima o tieni lan ya bona mi fuodma daali. ");
INSERT INTO guxg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ama ke Jesu guani ki ŋmiani ba: «N báa li tuuni hali yeni mɔlane, N mo tuuni i. ");
INSERT INTO guxg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lanyapo, ke Juufinba ji den lingi ke ban biani o miali, kelima li ki tie wan ki cɔlni mi fuodma daali baba ka, ama ke o yi U Tienu o báacelo, ki sengi o yuli U Tienu sensienu. ");
INSERT INTO guxg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Lanwani i, Jesu ń guani ki ga mi maama, ki yedi ba: «I mɔmɔni, i mɔmɔni, n maadi yi, Bijua kan fidi ki tieni libá kuli o yuli po, o tiendi wan nua ke Báa tiendi yaali i; ke Báa ń tiendi yaali, Bijua mo tieni lani i, paadma bá kuli ki ye. ");
INSERT INTO guxg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kelima Báa bua Bijua, ki wangi o wan tiendi yaali kuli; o go ba waani o ya bona n cie yin nua yaali ne, lan yaa ki lidi yi. ");
INSERT INTO guxg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kelima, nani Báa ǹ yiedi bi kpienba, ki puuni li miali yeni, Bijua mo puuni wan bua yua li miali. ");
INSERT INTO guxg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Báa ki jiagi nilo buudi, ama o cabi Bijua i, li buujiali kuli. ");
INSERT INTO guxg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Li tieni yeni, ke yuakuli ń kpiagi Bijua yeli nani ban kpiagdi Báa yeli maama. Yua n ki kpiagdi Bijua yeli, o ki kpiagdi Báa yua n sɔni o. ");
INSERT INTO guxg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«I mɔmɔni, i mɔmɔni, n maadi yi, yua n cengi n maama, ki dugi yua n sɔni nni po, pia ya miali n kan gbeni. Bi kan jia o ya buudi, ama o ñani mi kuuma nni, ki kua li miali nni. ");
INSERT INTO guxg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«I mɔmɔni, i mɔmɔni, n maadi yi, u yogu kpendi, u pundi mɔno, ke bi kpienba baa gbia U Tienu Bijua nialu; yaaba n ba gbadi lan ya nialu baa fo. ");
INSERT INTO guxg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","kelima nani Báa ń kubi li miali o niinni yeni, Bijua mo kubi li miali o niinni yeni i, o cedi ke Bijua mo pia li miali o niinni yeni i. ");
INSERT INTO guxg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O puni o yikodi, ke wan ya jiagi ti buudi, kelima o tie o nisaalo bijua i. ");
INSERT INTO guxg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Li bona ń da lidi yi ka. Kelima u yogu kpendi, ke yaaba n ye a kakula nni ba gbadi o maama ki ña bi kakula nni. ");
INSERT INTO guxg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Yaaba n tieni mi ŋanma ba yiedi ki ya pia li miali, ama yaaba n tieni ti tuonbiadi ba yiedi ban jia bi buudi. ");
INSERT INTO guxg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","N kan fidi ki tieni libá kuli n yuli po; nani min gbia maama yeni, n jiagi ti buudi ke li tiegi, kelima n ki lingi n ya yanbuama ka, ama yua n sɔni nni ya yanbuama. ");
INSERT INTO guxg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mini n ya tieni kasiedi n yuceli po, n kasiedi ki tie mɔni. ");
INSERT INTO guxg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nitiano ye, ki tiendi kasiedi n po, n bani ke wan tiendi ya kasiedi n po tie mɔmɔni i. ");
INSERT INTO guxg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","I sɔni bi niba Jan po ke o tieni kasiedi i mɔmɔni po. ");
INSERT INTO guxg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mini ya po, nisaalo ka ba tieni kasiedi n po, ama n maadi lani ke yin baa mi faabma i. ");
INSERT INTO guxg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jan den tie ya fidsanga n co, ki tuudi, ke i den bua yin mangi i pala yeni o yenyenma waamu. ");
INSERT INTO guxg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Min wani, n pia ya kasiedi n yabi ki cie Jan kasiedi; kelima, Báa ǹ bili nni ke min sɔni ya tuona, min tuuni ya tuona mɔno tiendi kasiedi n po ke Báa n sɔni nni. ");
INSERT INTO guxg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ke wani Báa yua n sɔni nni mɔno tieni kasiedi n po; i ki kpeli ki gbadi o nialu, i ki kpeli ki la o nunga. ");
INSERT INTO guxg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","O maama ki ye i niinni, kelima i ki dugi wan sɔni yua ya po. ");
INSERT INTO guxg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","I cogi ki kpaagi i diani nni, kelima i tama ke yini n ba puni yi ya miali n kan gbeni: yini n tiendi kasiedi n po. ");
INSERT INTO guxg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","I nan ki bua yin ŋɔdi nni ki baa li miali. ");
INSERT INTO guxg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","N yudandi ki ñani bi niba kani ka ");
INSERT INTO guxg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ama n bani ke i ki kubi U Tienu buama i niinni. ");
INSERT INTO guxg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N jiidi ki cua n Báa yeli po i, ke i ki ga n cangu; tiano ya cua o yeceli po, i nan ba ga o. ");
INSERT INTO guxg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","I nan ba tieni ledi i, ki dugi n po, yinba yaaba lingi ti yudandi i lieba kani, ki nan ki lingi ya yudandi n ñani U Tienu baba ya kani. ");
INSERT INTO guxg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Da maali mani ke min ba jalgi yi Báa kani; yua n ba jalgi yi tie Moyiisi, wani ya po i, ke i pia li dandanli. ");
INSERT INTO guxg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kelima i ya bi daani Moyiisi nni, i bi baa dugi n po mo; kelima o diani ki maadi n ya maama i. ");
INSERT INTO guxg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama i ya ki pia dandanli o diani po, li ba ga ledi, yin ya pia li dandanli n maama po? ");
INSERT INTO guxg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lani n pendi, ke Jesu gedi Galile ñincianma jaalieli ke bi go yi li Tiberiyadi. ");
INSERT INTO guxg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ku niwulgu den ŋua o boncianla kelima bi den la wan tieni ya yaalidgu bona bi yianba po. ");
INSERT INTO guxg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesu ń do li juali po, ki ban kali yeni o ŋɔdkaaba. ");
INSERT INTO guxg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Li den sua ke Paaki, juufinba jaanma nagi. ");
INSERT INTO guxg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu ń yaadi li yuli, kil a ke bi niba boncianla kpendi o kani, ke o maadi Filipi: «Ti ba da le i kpanu ya niba ne kuli ń baa ki di? ");
INSERT INTO guxg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","O den maadi yeni, ki bua wan bigni o i, kelima o den bani wan ba tieni maama. ");
INSERT INTO guxg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi ń jiini o, “Ti ya daá bá dibala kobilie kpanu, li kan dagdi bá juakuli ń baa bonjenga jenga. ");
INSERT INTO guxg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","O ŋɔdkaaba siiga nni, yendo, Siimɔn Pieri ninjua ń maadi o: ");
INSERT INTO guxg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ Naacenyendo ye ne ki pia kpanu amu yeni jami lie; lani ba fidi ki tieni be yeni ya nicianba ne? ");
INSERT INTO guxg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesu ń maadi: «Cedi mani ban kali. Likani den pia ku muagu boncianla. Bi den ki luo niba tuda mu, ban cedi ban kali. ");
INSERT INTO guxg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesu ń ga kpanu, ki yadi yedŋanma li po ki go tieni yeni i jami mo ya po, ki cedi ban bɔgdi ba, yuakuli ń ga wan bua maama. ");
INSERT INTO guxg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ban ŋmani ki guo, ke Jesu maadi o ŋɔdkaaba ke ban duo ban ŋmani ki sieni yaali ki da ŋa llibá ń bia. ");
INSERT INTO guxg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","O ŋɔdkaaba ń duo ban ŋmani a kpanu muuda ki sieni ya bonjena, ki gbieni baabuodi piiga n tilie. ");
INSERT INTO guxg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Li niba ń la ke Jesu ń tieni ya yaalidgu tuonli, ban maadi: “One n tie yeni i mɔni ya sawalpualo n bo ba cua ŋanduna ne.” ");
INSERT INTO guxg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesu ń bandi ke bi ba cua ki cuo o ki dini o li balcianli, ke o yaadi bi kani, ki kua li juali nni wani obaba. ");
INSERT INTO guxg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ku jenjuogu ń pundi, ke o ŋɔdkaaba jiidi mi ñincianma jaali po. ");
INSERT INTO guxg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ki kua ku ŋadgu ki ba puodi li mɔgli, ki gedi Kaperinawuma. Ku ñiagu den bii, ke Jesu da ki guani bi kani. ");
INSERT INTO guxg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","U faaciangu ń fii, ki fiini a ñinguona. ");
INSERT INTO guxg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ban kudi ku ŋadgu ki fagdi waamu, ban la Jesu ke o cuoni u ñingbanu po, ki nagdi bikani, ban jie. ");
INSERT INTO guxg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ama ke Jesu maadi ba: «Mini i, da jie mani! ” ");
INSERT INTO guxg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bi den bua bantaa o ku ŋadgu nni, ama ke ku toli ban caa naapo ");
INSERT INTO guxg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ya niwulgu n den se li mɔgli kunga den bani ke ŋadyengu baba n ye, ama Jesu nan den ki kua li ŋadgu nni yeni o ŋɔdkaaba, bi den gedi bi baba i. ");
INSERT INTO guxg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lan den fandi ke ŋadtiandi den ñani Tiberiyadi ki cua naani ke Jesu den yadi mi yedŋanma kpanu yeni i jami po ki teni ba ke bi ŋmani yeni, ");
INSERT INTO guxg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Li niba ń diidi ki sua ke Jesu yeni o ŋɔdkaaba, obá kuli ki ye li kani, ke bi kua ti ŋaditi, ki gedi Kapernawuma ki baan lingi Jesu. ");
INSERT INTO guxg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ban puodi li mɔgli, ki la o nepo ya jaali, ke bi buali o: “Rabbi, be yognu i ke a cua ne?” ");
INSERT INTO guxg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ke Jesu jiini ba: «i mɔmɔni, i mɔmɔni, n maadi yi, i lingi nni li nan ki tie min tieni ya yaalidgu bona ke i la ka, ama yin den baa kpanu ki ŋmani ki guo yeni i. ");
INSERT INTO guxg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ya tuuni mani ki da lingi ya jiema n ba dudi ka ama yin ya lingi ya jiema n kan dudi, ki baa tundi ki ye hali ya miali n ki pia gbenma. O nisaalo Bijua n ba teni yi lanya jiema; kelima wani ya po i, ke Báa U Tienu jaa o tanpɔn ki tieni mi banma. ");
INSERT INTO guxg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ban buali o: “Ti ba tieni ledi i, ki sɔni U Tienu tuonli? ");
INSERT INTO guxg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu ń jiini ba: «U Tienu tuonli tie ke yin ya dugi wan sɔni yua ya po i.» ");
INSERT INTO guxg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ban buali o: “A ba tieni o laa yaalidgu bonli i, tin ki bandi, ki dugi a po? A ba tieni be i? ");
INSERT INTO guxg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ti yaajanba bo dini maani, ki tinkuonga nni, nani lan diani maama: “Ke o teni ba ki tinga kpanu ke bi ŋmani.” ");
INSERT INTO guxg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesu ń maadi ba: «i mɔmɔni, i mɔmɔni, n maadi yi, Moyiis ka bo teni yi tanpoli kpanu; ama n Báa tieni yi tanpoli kpanu mɔnli. ");
INSERT INTO guxg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kelima U Tienu kpanu tie ya kpanu n ñani tanpoli ki jiidi, ki tieni ŋanduna li miali. ");
INSERT INTO guxg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ban maadi o: “Ti Diedo, ya tundi ki puuni ti lan ya kpanu.” ");
INSERT INTO guxg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu ń maadi ba: «Mini n tie li miali kpanu. Yua n cua n kani, koma ji kan cuo o, yua n dugi n po mo, ñuñuunu ji kan cuo o. ");
INSERT INTO guxg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ama n maadi yi, i la nni, ama i naa dugi n po. ");
INSERT INTO guxg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","N Báa ń teni nni yaaba kuli ba cua n kani, yua n cua n kani mo, n kan ñani o niinpo. ");
INSERT INTO guxg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kelima n ñani tanoli ki jiidi ke min tieni yaali n ki tie n yanbuama ka ama yua n sɔni nni ya yanbuama i. ");
INSERT INTO guxg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","To yua n sɔni nni yanbuama tie ke min da buoni wan teni nni yaali libá kuli, ama ke min guani ki yiedi la li daajuodidaali. ");
INSERT INTO guxg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","N Báa buama tie ke yua n la Bijua, ki dugi o po ń baa ya miali n ki pia gbenma, ke n go ba yiedi o li daajuodidaali. ");
INSERT INTO guxg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Juufinba den bulni bulni bi ŋmiali nni, kelima o maadi ke o tie ya kpanu n ñani tanpoli ki jiidi. ");
INSERT INTO guxg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ki maadi: “One ki tie Jesu ka aa? waa tie Josefi bijua kaa? tin bani yua ya naá yeni o báa kaa? Li ba ga ledi i, wan maadi: “N ñani tanpoli ki jiidi?” ");
INSERT INTO guxg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu ń jiini ba: «Da bulni mani i ŋmiali nni. ");
INSERT INTO guxg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Obá kuli kan fidi ki cua n kani, li nan yaa tie n Báa yua n sɔni nni yaa ka dadi o; n go ba yiedi o li daajuodikaali. ");
INSERT INTO guxg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Li diani bi sawalpuaba tili nni: “Bi ba tundi bi kuli, ki waani ba U Tienu ń tie yau. Lanwani i, yua n gbadi Báa maama, ki ga o tundli ba cua n kani. ");
INSERT INTO guxg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Li bua waani ke obá kuli ki la Báa, li nan yaa tie yua n ñani U tienu kani yaa ka; wan wani i, la Báa. ");
INSERT INTO guxg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","I mɔmɔni, i mɔmɔni, n maadi yi, yua n dugi n po ba ba ya miali n ki pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mini n tie li miali kpanu. ");
INSERT INTO guxg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I yaajanba den dini maana ki tinkuonga nni, ama bi nan den kpe. ");
INSERT INTO guxg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ne tie ya kpanu n ñani tanpoli ki jiidi, yua n ŋmani lan ya kpanu ji kan kpe. ");
INSERT INTO guxg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","N tie ya kpanu n pia li miali, ki ñani tanpoli ki jiidi. Yua n ŋmani lan ya kpanu, o baa tundi ki pia ya miali n ki pia gbenma; ke min ba teni a kpanu tie n gbannandi, ke n ba teni ŋanduna kuli miali po. ");
INSERT INTO guxg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wan maadi lani i, ke juufinba ji gagi bi ŋmiali nni, ki maadi: O ba ga ledi i, ki teni ti o gbannandi tin ŋmani ii? ");
INSERT INTO guxg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesu ń maadi ba: «I mɔmɔni, i mɔmɔni, n maadi yi; i ya ki ŋmani o nisaalo Bijua gbannandi, ki go ki ñuni o sɔma, i kan ya pia miali i niinni. ");
INSERT INTO guxg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yua n ŋmani n gbannandi ki go ñuni n sɔma baa bia ya miali n ki pia gbenma, n go ba yiedi o li daajuodikaali. ");
INSERT INTO guxg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kelima n gbannandi tie jiemɔndi ke n sɔma mo tie bonñukaali. ");
INSERT INTO guxg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yua n ŋmani n gbannandi ki go ñ̃uni n sɔma baa ye n niinni, ke n mo ye o niinni. ");
INSERT INTO guxg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nani Báa yua n fo ǹ sɔni nni yeni, ke wani Báa po i, ke n pia li miali, lanwani i, yua n ŋmani nni mo baa pia li miali n ya po. ");
INSERT INTO guxg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ne tie ya kpanu n ñani tanpoli ki jiidi. li ki tie nana i yaajanba ń bo ŋmani maana, ki nan kpe yeni ka: yua n ŋmani ya kpanu ne ba baa ya miali n ki pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesu den maadi la ya bona ti jaandiedi nni ki wangi Kapernawuma yaaba. ");
INSERT INTO guxg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesu ŋɔdkaaba siiga nni, boncianli den gbadi ya maama ne ki maadi: “Ya maama ne paa mi gbadma; ŋma ba fidi ki cengi ya maama ne? ");
INSERT INTO guxg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesu den bandi ke o ŋɔdkaaba sɔbni ki maadi o ya maama po i, ke o buali ba: «Ya maama ne jiendi yi bii? ");
INSERT INTO guxg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","I ji ya la ke o nusaalo Bijua, ke o guni ki doni wan den kpia ki ye naani te? ... ");
INSERT INTO guxg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mi Foŋanma n puuni li miali; ti gbannandi ki pia fuoma. Min maadi yi ya maama tie fuoma yeni miali. ");
INSERT INTO guxg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama i siiga nni, bi tianba ye ki ji pia dudugdi. Kelima Jesu den bani hali mi cilma yaaba n den ki dugi o po yeni yua n ba te janbi. ");
INSERT INTO guxg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ki go pugni: «Lani ya po i, ke n maadi yi ke obá kuli kan fidi ki cua n kani, li nan yaa tie ke Báa n puni o li paabu. ");
INSERT INTO guxg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ki cili lanyognu, o ŋɔdkaaba boncianla den fuadi ki ŋa o, kaa ji yegdi yeni o. ");
INSERT INTO guxg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesu ń buali o piiga n ŋɔdkaaliedba: «Ke yinba i, i kan sani ki ŋa nni ii? ");
INSERT INTO guxg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Siimɔn Pieri ń jiini o: “Ti Diedo, ti ba sani ki ŋɔdi ŋma i? Fini n pia ya miali n ki pia gbenma maama. ");
INSERT INTO guxg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ti dugi a po ki go bandi ke fini n tie Kiristu, U Tienu nigagdiŋamo. ");
INSERT INTO guxg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu ń jiini ba: «Mini ka lugdi yi yinba piiga n biliediba aa? I siiga nni, yendo tie cicibiadga i. ");
INSERT INTO guxg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","O den maadi Siimɔn bijua, Juda Isikariyɔti i; kelima wani n den ba janbi o, ki teni yibalinba, wani yua den tie piiga n biliedba yeni nni, yendo. ");
INSERT INTO guxg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Li po n pendi, k jesu gedi Galile, o bo ki waagi Jude. Jufi nba bado bo kpaani k ban kpagu ");
INSERT INTO guxg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2",". Jufi nba jaam yaali ki yii jondi jaami bo nagi. ");
INSERT INTO guxg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Lani ki jesu ninjab maad o, ña ne ki gedi Suude. K a ŋuantieba n fidi la a tuona yaali k a suani. ");
INSERT INTO guxg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nilo k wuo wan suani ya tuonli: a ya suani lan tuonli kuli, mɔndi ŋanduna nib kuli n band a. ");
INSERT INTO guxg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","O ninjabi bo ki pia o po li dandanli. ");
INSERT INTO guxg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesu maadi ba: n yogu da ki pundi ŋama yinbi wan ya yogu peli yogkuli. ");
INSERT INTO guxg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ŋanduna kan fidi ki kuad i, min, o kuadn, ki dugni n tie o sieda yua n wang o k o tuona ki ŋani. ");
INSERT INTO guxg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Do mani, yinbi, li jaam po, min wani da kan do ki dugni n yogu da ki pundi. ");
INSERT INTO guxg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wan maadi ba k gben, k o ñindi Galile ");
INSERT INTO guxg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","O ninjab n doni mi jaam po, li puoli po k o ŋɔd li wuolin k bi niba k lagu. ");
INSERT INTO guxg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mi jaam yogu, k jufinba kpaan o ki maadi: o ye leee? ");
INSERT INTO guxg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","O niwuligun nni bi maadi o po ki tua: o tie nimɔni (ŋantaadi daani), bi tianbi mɔ ya po: n n, o bɔndi bi niba(o tiendi ti belbɔndi). ");
INSERT INTO guxg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bi nibi den jie yeni ban maadi jesu po jufinba gbadi. ");
INSERT INTO guxg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mi jaam ji mangi ki kua siinga yo ki jesu kua o jandiegu nni ki cili ki cogni U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ki li ya k lidi jufinba k bi maadi: o tieni ledi ki bani mi cogma ki nan ki kua o cogu( kalaatu). ");
INSERT INTO guxg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","K Jesu ŋmianba: n yikod k tie n yali ka, ama yua n sɔn nni yali ");
INSERT INTO guxg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yua bua tie o buam, o b bandi ki lia n yikod ñaa U Tienu kani bii n palu po. ");
INSERT INTO guxg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yua maadi o yuli po, kpaani o ñuadi baba i, ama, yua kpaani yua n sɔn o ya ñuadi, tie yua mɔni k k bua jɔdi ki maadi i mɔmɔni o ba nni. ");
INSERT INTO guxg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moyiis den ki teni li yikodi? Ama siign nul ki cɔlnil li yikod. Be ya po i ki kpaani ki yin kpa nni? ");
INSERT INTO guxg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","K o niwuligu guani ji jiin o: ti cicibiadm ŋua a. Bi le n kpaani ki ban kpa a ni? ");
INSERT INTO guxg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","K i Jesu yediba: tuonyenli baba k n tieni ki li yaa ki lidi i kuli ne. ");
INSERT INTO guxg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyiis bo teni yin ba cɔlni, l bo ki ñani Moyiis kan ka, li bo cili yajaanba kani ki ti kɔndi bo cili, k a kɔndi saaba daali ");
INSERT INTO guxg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nil ya gaa ti kɔndi saaba daali k nan cɔlni Moyiis yikodi, be ya po i ki kɔn yen n k paagi o yiamo saaba daali? ");
INSERT INTO guxg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Da bu mani yeni lugdm ama ya bu mani yeni i mɔmɔni ");
INSERT INTO guxg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalema yaaba siiga, b tianba ń yedi, “Ban lingi yua ki bua kpa ka ne ee?” ");
INSERT INTO guxg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Diidi, wani n maadi wan bua maama yeni, ke bi nan ki maadi o libakuli. Daalinba yikodanba ki bani ke wani n tie Kiristo, bii laa tie yeni ii? ");
INSERT INTO guxg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ama ti bani li nilo ń ñani naankani wani.” ");
INSERT INTO guxg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ke Jesu tandi ku jaandiegu nni, ki tundi, ki tua, “I bani nni, ki go bani min ñani naani. N ki cua n yuli po ka, Yua n sɔni nni yeni tie o mɔmɔndaano i, i ki bani o. ");
INSERT INTO guxg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","N bani o, kelima n nani o kani i, wani n sɔni nni. ");
INSERT INTO guxg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bi den bigni ke ban cuo o, ama, obakuli den ki maani o nuu o po, kelima, o yogu dá den ki pundi. ");
INSERT INTO guxg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ama ku niwulgu nni, boncianli den tuo ki dugi o po, ki tua, “Kiristo ń ba ti cua ya yogu, o ba fidi ki tieni yaali n cie ya bancianma yeni ya yaalidgu n tie ne ee?” ");
INSERT INTO guxg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisienba den gbadi ke ku niwulgu sɔbni ki maadi li Jesu maama, ke salga yidkaaba yeni Farisienba sɔni a jakɔnda yudanba, ke ban cuo o. ");
INSERT INTO guxg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ke Jesu yedi, “N dá ye yeni yi u you waamu, ki ba ti yuandi ki guani yua n sɔni nni po. ");
INSERT INTO guxg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","I ba lingi nni, ama, i kan la nni; min caa naani, i kan fidi ki cua likani.” ");
INSERT INTO guxg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ke juufinba ji maadi bi ŋmiali nni, Ya nilo ne caa le i, ke ti ba lingi o kikan la o oo? O bua gedi yaaba n yadi ki kua bi nilanba siiga ki ban ya tundi ba bii? ");
INSERT INTO guxg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wan maadi ya maama ne mɔ tie be i, 'I ba lingi nni, i kan la nni; min caa naankani, i kan fidi ki pundi likani'?” ");
INSERT INTO guxg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mi jaanma damiidi ligi i, li daacianli daali, Jesu den tandi, ki maadi, ki tua, “U ñuñuunu ya pia yua, wan cua n kani ki ñu. ");
INSERT INTO guxg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nani i diani nni, lan yedi yaali maama, “Yua n dugi n po, li miali kpenu ñima ba puubi o niinni. ");
INSERT INTO guxg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","O den maadi Foŋanma maama, yaama ke yaaba n dugi o po ba baa; bi dá́ ki puuni Foŋanma, kelima, Jesu dá ki la o kpiagdi. ");
INSERT INTO guxg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ku niwulgu nni, nitianba ń gbadi lanya maama, ke bi yedi, “O li tie sawalpualo i yeni i mɔni.” ");
INSERT INTO guxg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ke nitianba yedi, “Kiristo n yeni.” Ama ke nitianba mo yedi, “Kiristo ñani Galile yo oo? ");
INSERT INTO guxg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","I diani nni, bi ki yedi ke Kiristo ba ña Dafiidi cugli nni ka aa, ki tie Betehema, Dafiidi dongbanli nni ka aa?” ");
INSERT INTO guxg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lanwani ii, ke mi paadma tieni bi siiga nni o po. ");
INSERT INTO guxg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nitianba den bua ban cuo o, ama obakuli den i maani o nuu o po. ");
INSERT INTO guxg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ke sejenba yudanba guani ki la salga yidkaaba yeni farisienba, ke bi buali ba, “Li tieni ledi i, ke yii guani yeni o?” ");
INSERT INTO guxg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ke sejenba yudanba jiini, “Tii kpeli ki la ya nilo n maadi nani wani yeni.” ");
INSERT INTO guxg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ke farisienba buali ba, “i mɔ bodi n yeni ii? ");
INSERT INTO guxg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yikodanba bii farisien bi ye lienni, ki tuo ki dugi o po oo? ");
INSERT INTO guxg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama ya niwulgu n ki bani yiko ne, sola bi po.” ");
INSERT INTO guxg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodema, (ya farisien n den tuodi ki dugi o po) yedi ba, ");
INSERT INTO guxg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ti yiko cabi ke ban jia nilo ti buudi kaa cengi o ki bandi wan tieni yaali ii? ");
INSERT INTO guxg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ke bi jiini, ki yedi o, “A mɔ ñani Galile yua yo oo? Kpaagi i diani nni, ki lia sawalpualo ya ye, ki ñani Galile,” ");
INSERT INTO guxg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bi den yadi ke yuakuli kuni o denpo. ");
INSERT INTO guxg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu den gedi olifi tiidi juali po. ");
INSERT INTO guxg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ku siŋaapanpangu nni, ke o go guani ku jaandiegu nni, ke bi niba kuli cua o kani, ke o tundi ba. ");
INSERT INTO guxg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yiko gbanbanda yeni farisienba ń cua yeni ya pua ke bi ludi o, ke o conbi. ");
INSERT INTO guxg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ban seni o pua yeni, bi niba kuli siiga, ki maadi Jusu: “Canbáa, ti ludi o pua ne ke o conbi, ke ti cuo o. ");
INSERT INTO guxg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moyiisi yedi o yiko tili nni ke li dagdi ke ban lugdi ya puoba n tieni yeni a tana: ke fini mo, a yedi be? ");
INSERT INTO guxg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bi den maadi yeni, ki bua ban bigni o, ki fidi ki jalgi o. Ama Jesu den tibni, ki dangi yeni o nubili tinga nni. ");
INSERT INTO guxg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ban den li ŋua ki buali o yeni i, ke o yaadi ki sedi, ki yedi ba: «I siiga, yua n ki pia tuonbiadi ń kpia ki lugdi o li tanli. ");
INSERT INTO guxg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ki guani ki tibni, ki dangi tinga nni. ");
INSERT INTO guxg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ban gbadi Jesu maama, bi yantiali den jalgi ba, ban ji ya yadi yendo yendo, ki cili bi nikpelo ki ban yadi ki gbeni; Jesu ji den ye o baba i, yeni o pua, ke o se wan bi se naani. ");
INSERT INTO guxg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesu ń yaadi ki sedi, o ji ki la bá niyendo, kase o pua yeni baba, wan buali o: «Pua, yaaba n bi jalgi a yeni ye le i? Obá ki buni ki cuo ŋa, aa? ");
INSERT INTO guxg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","O den jiini: “N Diedo, obá kuli.” Jesu ń maadi o: «N mo ki buni ki cuo ŋa; ya caa, ki ji da sɔni tuonbiadi.» ");
INSERT INTO guxg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesu go den maadi bi niba, ki yedi: «Mini n tie ŋanduna yenyenma; yua n ŋua nni kan cuoni biigli nni, ama o ba baa li miali yenyenma. ");
INSERT INTO guxg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lanyapo, farisienba ń yedi o: “A tiendi kasiedi a yuceli po; a kasiedi ki tie kasiedi mɔno. ");
INSERT INTO guxg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu den guani ki jiini ba: «Bá n n ya tiendi n yuli po kasiedi, n kasiedi tie mɔmɔni, kelima n bani min ñani naani ki caa naani; ama yinba ki bani min ñani naani, ki buali min caa naani. ");
INSERT INTO guxg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yinba jiagi ti buudi yeni ti gbannandi maalma i; mini nan ki jiagi nilobá buudi. ");
INSERT INTO guxg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","N ya jia buudi mo, n bujiali tiegi, kelima mii ye n baba, ama Báa yua n sɔni nni, ye yeni nni. ");
INSERT INTO guxg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bi diani i yiko tili nni, ke niba lie kasiedi tie mɔmɔni; ");
INSERT INTO guxg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","N tiendi n po kasiedi, ke n Báa yua n sɔni nni mo tiendi n po kasiedi. ");
INSERT INTO guxg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ban buali o: “A báa ye le? Jesu ń jiini: «I ki bani nni ki buali n Báa. I ya bi bani nni, i bi baa bani n Báa mo. ");
INSERT INTO guxg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu den maadi lanya maama, ki tundi ba ku jaandiegu nni, ban den bilgi naani bi ŋalmani, ama obá naa den cuo o, kelima o yognu daa den pundi. ");
INSERT INTO guxg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesu go den yedi ba: «N caa n yeni, i ba lingi nni, i ba kpe i tuonbiadi nni, i kan fidi ki cua min caa naani. ");
INSERT INTO guxg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Lanyapo, juufinba ń maadi: “O bua kpa o bá yo oo, nani wan yedi: «I kan fidi ki cua min caa naani? ” ");
INSERT INTO guxg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Wan maadi ba: «I tie tinga yaaba i, mini tie tanpoli yua i. yinba tie ŋanduna ne yaaba i, mini ki tie ŋanduna ne yua ka. ");
INSERT INTO guxg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lanyapo i ke n maadi yi ke i ba kpe yeni i tuonbiadi; kelima i ya ki dugi min tie yua po, i ba kpe yeni i tuonbiadi. ");
INSERT INTO guxg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ban buali o: “A tie ŋma i? “Jesu ń jiini ba: «Min yedi yaama hali mi cilma yeni.» ");
INSERT INTO guxg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N pia a bona boncianli ki ba maadi i po, ki go jia ti buudi yeni yi li po. ama yua n sɔni nni tie mɔmɔndaano, ke min maadi ya maama ŋanduna nni ne tie min gbadi o kani ya maama i. ” ");
INSERT INTO guxg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bi naa den gbadi ke o maadi Báa (U Tienu) ya maama i. ");
INSERT INTO guxg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Lanwani i, Jesu ń maadi ba: «I ya ti fiini ki seni o nisaalo Bijua, lanyognu i ba bandi min tie yua, ke n ki tie libá kuli n yuceli po, ama n maadi ki dugni n Báa ń tundi nni maama i. ” ");
INSERT INTO guxg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yua n sɔni nni ye yeni nni; waa ŋa nni n baba, kelima yognu kuli, n tie yaali n mani o po. ");
INSERT INTO guxg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nani Jesu ń den maadi lan ya maama yeni, bi niba boncianla den dugi o po. ");
INSERT INTO guxg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wan yedi Juufinba yaaba n den dugi o po yeni: «I ya tuo ki ŋua n maama, i tie n ŋɔdkaaba yeni i mɔni; ");
INSERT INTO guxg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","I ba bandi i mɔmɔni, i mɔmɔni ń faabi yi. ");
INSERT INTO guxg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bi den guani ki jiini o: “Ti tie Abalahama puolŋuani i, hali tin ye, ti naa tua nilo yonbi; li ba ga ledi ŋan maadi ke ti bi ba faabi ti?” ");
INSERT INTO guxg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu ń guani ki jiini ba: «I mɔmɔni, i mɔmɔni n maadi yi ya nilo n tiendi ti tuonbiadi kuli tie ti tuonbiadi yonbo ");
INSERT INTO guxg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I bani ke yonbo ki tie yua n baa tundi ki ye ku diegu nni ka; ama ku diegu nni bijua wani tie ku diegu nni yua i, hali yognu kuli. ");
INSERT INTO guxg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Lanwani i, Bijua ya faabi yi, i ba baa mi fuoma (i ba yali i bá) yeni i mɔni. ");
INSERT INTO guxg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N bani ke i tie Abalahama puoli ŋuani; ama i lingi ke yin kpa nni kelima min maadi ya maama naa kua i pala nni. ");
INSERT INTO guxg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","N maadi min la yaali n Báa kani i; ama yinba tie yin gbadi yaali i mo ya báa kani i. ");
INSERT INTO guxg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ban jiini o: “Ti báa tie Abalahama.” Jesu ń yedi ba: «I ya bi tie Abalahama bila, i bi baa tuuni Abalahama tuona i.» ");
INSERT INTO guxg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mɔlane, i lingi ke yin kpa nni, mini yua n maadi yi i mɔni, ke n gbadi U Tienu kani i, Abalahama naa den tieni yeni. ");
INSERT INTO guxg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","I tuuni i báa tuona i. Ban jiini o: “Tii tie conconbila ka; ti pia báa yendo i, U Tienu.” ");
INSERT INTO guxg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu ń maadi ba: «U Tienu ya bi tie i Báa, i bi baa bua nni, kelima n ñani U Tienu kani i, ki cua; n ki cua n yuceli po ka, ama wani n sɔni nni.» ");
INSERT INTO guxg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Li tieni ledi i, ke i ki gbia n maama? Kelima i kan fidi ki cengi n maama. ");
INSERT INTO guxg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","I báa n tie setaani, ke i lingi ke yin tieni i báa yanbuama. O tie nikpalo hali mi cilma, o naa ŋua i mɔmɔni sanu, kelima i mɔmɔni ki ye o niinni. O ya pua mi tofaama, o maadi yeni o yantiali; kelima o tie tofaadaano, ki go tie mi tofaama báa. ");
INSERT INTO guxg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nani min maadi i mɔmɔni yeni, i naa dugi n po. ");
INSERT INTO guxg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","I siiga nni, ŋma ba fidi ki waani n tuonbiadi? To. n ya maadi i mɔmɔni i, be nan cedi ke i ki dugi n po? ");
INSERT INTO guxg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yua n ñani U Tienu kani, cengi U Tienu maama. I ki cengi, kelima i ki ñani U Tienu kani ka. ");
INSERT INTO guxg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juufinba ń jiini ki maadi o: “Tii pia i mɔni yeni tin maadi ke a tie Samari yua aa, ke ki cicibiadga ŋua ŋa aa?” ");
INSERT INTO guxg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu ń jiini: «Cicibiadga ki ŋua mini; min kpiagdi n Báa yeli, ke yinba nan fanbdi nni. ");
INSERT INTO guxg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","N ki lingi n yuli po kpiagdi ka, yua n ye ki lingi n kpiagdi, wani n go jiagi ti buudi. ");
INSERT INTO guxg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","I mɔmɔni, i mɔmɔni, n maadi yi, yua n ŋua n maama, o kan kpe palbu. ");
INSERT INTO guxg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juufinba ń maadi o: “Mɔla wani i, ti ji bandi ke ki cicibiadga ŋua ŋa. Abalahama kpe, bi sawalpuaba mo kpe, ke fini nan yedi ke yua ga a maama kan kpe palbu. ");
INSERT INTO guxg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A cie ti báa Abalahama yua n kpe yo oo? Bi sawalpuaba moko kpe. A tama ke a tie ŋma i? ");
INSERT INTO guxg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu ń jiini: «N ya kpiagdi n yuli, n yudandi tie fanma. N Báa n kpiagdi nni, yin maadi yua ke o tie i tienu yeni, ");
INSERT INTO guxg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ama ke i nan ki bani o. Min wani bani o; n ya bi maadi ke n ki bani o, n bi baa tie nani yinba, tofaadaano. Ama n bani o, ki kubi o maama. ");
INSERT INTO guxg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I báa Abalahama den mangi o pali yeni wan ba la n daali dɔgdima; o la li, ke li tua o po pamancianli. ");
INSERT INTO guxg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juufinba ń maadi o: “A dá ki pundi bina piimu, ki nan la Abalahama bii! ");
INSERT INTO guxg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu ń maadi ba: «I mɔmɔni, i mɔmɔni, n maadi yi, hali ke Abalahama daa bo ye, n bo ye. ");
INSERT INTO guxg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Lanya maama po, bi den taa a tana ki ba lugdi o; ama Jesu den wuoni ki ñani ku jaandiegu nni. ");
INSERT INTO guxg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesu b pa o sɔnu po, ki te la jua ba k o tie juamo hali ya yognu ki bi mal o. ");
INSERT INTO guxg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","K o yegntieba bual o: Rabi, o jua ne biidi be, bii o danbi n biidi, ki bi mal o ko tie juamo o? ");
INSERT INTO guxg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu guani ki ŋmian bi: laa tie ki wani bii o danbi biid ka, ama U Tienu n bua waani o buama maami o po. ");
INSERT INTO guxg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Li buali ki lan tieni, ya yognu ki li faa kuli, yua suani ya tuona; gu ñiagu ya cua, nul kan fidi ki sɔni tuonli ba kuli. ");
INSERT INTO guxg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Hali ya yognu k n ye li ŋandunli nni, n tie yinyiemi li ŋandunli nni. ");
INSERT INTO guxg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wan yedi yeni, k o sii ti ñɔsɔndi tingi, ki buuni ti tandi yeni o ñɔsɔndi, ki ji taa li tandi ki faani o juamo ninbina. ");
INSERT INTO guxg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ki ji maadi o; ya caa ki ban faadi Silowe( ya yeli niima tie sɔnŋa) ñincili. k o gadi ki pan wuli ki nuali. ");
INSERT INTO guxg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","O lieba yeni yaabi den yi ban o, ko miadi yeni ji maadi: yua den yi kaa ki miadiyeni kaa a? ");
INSERT INTO guxg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tianbi den yedi: wani. Bi tɔba mɔ den maadi ki wan ka, ki bi naani. Ki wani oba ji den yedi: “min ni” ");
INSERT INTO guxg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ki bi ji bual o: a tieni ledi k a ninbina nualii? ");
INSERT INTO guxg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","K o guani ki ŋmiani: ya ja ki bi yii u jesu yeni n den buuni ti tandi ki faani n ninbina ki gɔ maadi ni, k min gedi ki ban faadi Silowe ñincinli nni ki gɔ wuli, k n gedi ki pan wuli, ki ji nuali. ");
INSERT INTO guxg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ki bi bual o: li ja ye lee? k o guani ki maadi ba: mii bani. ");
INSERT INTO guxg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ki bi taa o ja yeni, ki gedi yeni o faalisien kani. ");
INSERT INTO guxg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesu n bo buuni ti tandi ki faani o juamo nungi ko ji nuali ya daali bo tie saaba daali. ");
INSERT INTO guxg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lani ya po n cedi ki farisien nba buali o wan tieni maama ki te guani ki nual o, k o yedi ba: o buuni ti tandi waami ki faani n nungi po, k n ji faadi, ki nuali. ");
INSERT INTO guxg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ke Farisienba tianba yedi, “Ya nilo ne ki ñani U Tienu kani ka, kelima, waa cɔlni mi fuodma daali.” Ke tianba yedi, “Li ba ga ledi i, tuonbiadi daano ń tieni ya yaalidgu bona aa?” Ke mi paadma tieni bi siiga, ");
INSERT INTO guxg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ke bi go buali ojuamo, “A yedi be i, o ja ne po, nani wan luoodi a nuni yeni?” Ke o juamo yedi, “O tie sawalpualo i.” ");
INSERT INTO guxg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juufinba dá bo ki li tuo ke o ja ne den tie juamo i, ke o cedi ke o nɔanli, ki cedi ke bi yini o danba, ke bi cua ki sua ke o nua. ");
INSERT INTO guxg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ke bi buali o danba, “One tie i biga ke i mali o ke o tie juamo oo? Li nan ga ledi i, ke o ji nua mɔlane?” ");
INSERT INTO guxg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ke o danba jiini ba, “Ti bani ke ti biga i, ke o mali, ki tie juamo. ");
INSERT INTO guxg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Li tieni ledi, ke o ji nua mɔlane, ti ki bani lani i, ti go ki bani yua luodi o nuni. Buali o mani, o ji ki tie biga ka, o ba fidi ki maadi obá.” ");
INSERT INTO guxg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","O danba den maadi yeni, kelima, bi jie jufinba i. Kelima, Jufinba juogi ki jagi ke yua ba tuo ke o tie Jesu, bi ba deli ki ñani o bi jaandiegu nni i. ");
INSERT INTO guxg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lanyapo i ke o danba yedi “O tie cegdinka i, buali o mani.” ");
INSERT INTO guxg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ke bi yini yua n den tie juamo, ki yedi o, “ŋan jaandi ki kpiagi U Tienu, Ti bani ke ya ja ne tie tuonbiadi daano i.” ");
INSERT INTO guxg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ke o ja ne jiini, “N ki bani o ya tie nibiado. Min bani yaali n tie ke N den tie juamo, ki ji nua mɔlane,” ");
INSERT INTO guxg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ke bi buali o, “O tieni a be i? O tieni ledi i, ki luodi a nuni?” ");
INSERT INTO guxg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ke o jiini, “N waani yi, ke yii bua yin cengi nni! Be n cedi ke i go bua gbadi be i? Bii i mɔ bua yin tua o ŋɔdkaaba i, bii laa tie yeni ii? ");
INSERT INTO guxg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ke bi sugi o, ki yedi o, “Fini n tie o ŋɔdka, tinba wani tie Moyiisi ŋɔdkaaba i. ");
INSERT INTO guxg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ti bani ke U Tienu maadi yeni Moyiisi, ama ti ki bani yuane ń ñani naankani. ");
INSERT INTO guxg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ke o ja yeni jiini, ki yedi ba, “Li pia yaalidgu ke yii bani wan ñani naana, ama, ke o nan luodi n nuni. ");
INSERT INTO guxg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti bani ke U Tienu ki cengi biidi daano, ama, yua n cengi o maama, ki tie o buama, o cengi o ya maama i. ");
INSERT INTO guxg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hali ŋanduna cilma, tii kpeli ki gbadi ke bi luodi yua n mali ki tie juamo nuni. ");
INSERT INTO guxg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Li nilo ya bi ki ñani U Tienu kani, o bi kan fidi ki tieni libakuli. ");
INSERT INTO guxg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ke bi jiini ki yedi o, “A den li mali ti tuonbiadi nni i, ki ji bua ŋan tundi ti ii?” Ki deli ki ñani o. ");
INSERT INTO guxg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesu ń gbadi ke bi deli ki ñani o bi jaandieli nni, ke o cendi o, ki buali o, “A daani O Nilo Bijua nni ii?” ");
INSERT INTO guxg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ke o jiini, ki yedi, O Diedo, o tie ŋma i, ke N ba dugi o po?” ");
INSERT INTO guxg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu ń maadi o, “A la o, wani n maadi yeni a ne.” ");
INSERT INTO guxg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ke oja ne maadi, “O Diedo, N daani”, ki gbaani ki pugi o. ");
INSERT INTO guxg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesu ń maadi, “N cua ti buudi jiama po i, ke yaaba n tie juama ń nɔanli, ke yaaba n yedi ke bi nua ń juani.” ");
INSERT INTO guxg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ke Farisienba yaaba n den ye likani, gbadi li maama, ki buali o, “Timɔ tie juama yo oo?” ");
INSERT INTO guxg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu ń yedi ba, “I ya bi tie juama, i bi kan ya pia biidibakuli, ama, i yedi mɔla, 'Ti nua,' lanwani ii, i bii ye ti biidi nni i.” ");
INSERT INTO guxg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","mɔni n maadi ke yua bua kua l yandeli n i kaa tɔgn i diñɔbi kaa k nan yugi guoli, o tie suudi, o tie bibiadgi ");
INSERT INTO guxg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","yua tɔgni l yandeli diṅɔbi k kua n tie yankpaalo. ");
INSERT INTO guxg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","4","yua yi guu o diṅɔb yi luodi l ganli, wan kua i pei n gbadi o lantɔgu. yaaba n tie u yii wan yiini yangi kuli k taa o yeli k ña yemi niin po. U ya ñan yeni b kuli niin po, wan gaa liigi ban yaa ŋua o puoli po. kelima b bani o lantɔgu ");
INSERT INTO guxg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","B kan tuo ŋɔdi caani. b bo sani mɔno k fagdi o kani k dugni baa bani o lantɔgu. ");
INSERT INTO guxg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu bo pua'b l makpanjama i ama b nan bo gbadi l niimn i ");
INSERT INTO guxg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesu bo guani k maadi lani «yeni i mɔni n maad'i mi tie l yandeli diñɔbi ");
INSERT INTO guxg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","yaabi kpia baa yeni kuli tie suuda yeni bibiadnmi ama i pei naa sogi b maama. ");
INSERT INTO guxg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mi tie o diñɔbi yua kua n kani kuli, u faabi u ba n yeni. u baa fidi k ya kua k gɔ ña k laadi u jiema k di ");
INSERT INTO guxg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suudi wan baadi k wan su i, k kodi k gɔ biidi; mini wan baa k ban baa l miali yeni i mɔni k gɔ yaa ye t mandi n i. ");
INSERT INTO guxg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Min tie u yankpaamɔni. U yankpaamɔn yi taa u miali k lu i u pei po i. ");
INSERT INTO guxg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ama ya nukpalo k tie yankpaali, kaa die yandi, ya la k o yangbanli baadi, u bo ñɔli i pei k sani u yangbanl n baa kua i pei siign i k yaam bi ");
INSERT INTO guxg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","u yi sani k dungn i u tuuni i ligi po i. i pei k tie bonli u kani. ");
INSERT INTO guxg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Min tie yankpaamɔni n bani i pei k pei mɔ gɔ ban'ni ");
INSERT INTO guxg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nani n baa n ban'n i k mɔ gɔ bani n baa yeni, n bo luni n miali k fie n pei ");
INSERT INTO guxg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","n gɔ pia pe tɔbi k baa tie n yandeli n i yaabi l waani k min kpaa b ban mɔyi, b mɔ bo sogi m maam k ban kuli n ji taani k yaaa tie yandeyendu n pei k yaa pia yankpaa yendi. ");
INSERT INTO guxg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","N baa buam n i k u lugd'n, n bo lu n mial k gɔ guani k gaa l miali ");
INSERT INTO guxg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nul kaa bo fie n mial, n yantiali k bo lu n mial, n gɔ pia yiko yua k bo fid fidi guan k gaa l miali. n baa ṅ maadi k min tuni yaali n yeni. ");
INSERT INTO guxg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesu n maadi yeni k l cua yeni u ñɔniagu sufi nba yudamba siiga n i. ");
INSERT INTO guxg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","B siiga n i boncianli bo yedi k pola n ŋua'ug, k u tie gaadi. k be yaa po i k sogi u maam i? ");
INSERT INTO guxg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","K b tɔbi yedi k a pola n ŋua yua k maadi nandi ne kaa, k sanpol bo fidi cedi juama n nuaal ii? ");
INSERT INTO guxg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sufi nba bo dini jaama yua k b yi guani tiadi o jaanddeciangu ŋanma po yeni l bo tie o fawaapiegu yognu i ");
INSERT INTO guxg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","k Jesu ye o jaanddeciangu n i, Salomɔni ciagu n i. k cuoni k caa k gɔ k lebi. ");
INSERT INTO guxg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","K jufi nba yudama gobi k kaalind'o k bual'o yaa caa yeni be yaa daali k gɔ bo cedi tin maal mlele i a po i? A yaa tie kristo nan kadi maadi 'ti ");
INSERT INTO guxg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","K Jesu ŋmiam 'i «m maadi no k i k tuo? M tuuni o yaalidigu tuona yaali n baa yeli po, l wangi min tie yua. ");
INSERT INTO guxg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama yim k tuo k l tie mɔni kelima i k tie n yandel n pei. ");
INSERT INTO guxg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","N pei gbia n lantɔgu: n banm' i k b mɔ gɔ ban'n ");
INSERT INTO guxg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","; N tenm'i yaa miali k pia gbenma; b kan baa kpe, nul bia kan fidi ñanb'i n nuugi n i. ");
INSERT INTO guxg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","N baa n tugi'bi k teni 'n, u cie bonli kuli o baa kan fidi fie bonli n baa nuugi n i ");
INSERT INTO guxg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Min yeni n baa taani k tie nuyendi i ");
INSERT INTO guxg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","K sufi nba yudanma gɔ gandi a tanaa k bo jaa'og. ");
INSERT INTO guxg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Lani k Jesu maadb'i «n tuuni a tuoŋanma boncianli yeni n baa paalu k i la, lan yaa po k i gɔ bua jaan 'n a tanaa. ");
INSERT INTO guxg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","K sufi -nba yudanma ŋmian'o: t k bua jaa 'a a tanaa tuonŋanli baa po kaa, ama k dugn i ŋan sugi u tienu ya po i. A tie nufosaali k nan ji yiin i a ba u tienu. ");
INSERT INTO guxg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","K jesu maadi: la k diani i ñɔmaama yikotili nn i k maadi k i tie i tieni? ");
INSERT INTO guxg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","l yaa tie k yiko tili n i k b yiin i tieni yim yaabi k u tienu ñɔmaam nɔ'i. yua kuli bani k u tienu tili k pia piinmi. ");
INSERT INTO guxg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","yua k u baa yidi i yenŋanm k sɔn'o ŋanduna n i k yedi k sugi u tienu! kilema n maadi k tie u tienu bijua. ");
INSERT INTO guxg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nyaa tuni n baa n yedi k min tuni yaali yi daa gaa n maam. ");
INSERT INTO guxg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama n yaa tuni n baa tuona, ki k gaa n maam mɔno yin nan tuo k l tuona ñani u kani, k fidi bandi k n baa ye ye'n k mɔ ye n baa n ");
INSERT INTO guxg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","K sufi nba yudanma gɔ ji kpaani k ban cuo'og ku febi k yaadi. ");
INSERT INTO guxg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","K jesu guani k lebdi suurdeni kpenu puol po naani k sani bon cindi wuuli b nibi yeni k ji ye lan po. ");
INSERT INTO guxg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","K b nubi boncianli ji baadi u kani k tua Sani bo k tuni baa tuonyeli k l tie yaalidgu bonli. Ama wan bo yedi o ja ne po yaal kuli bo tie mɔni. ");
INSERT INTO guxg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lan kani k nubi boncianli tuo k gaa Jesu. ");
INSERT INTO guxg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jua ba bo ye Betani, k bi yigu Lasaar, li longbanli bo tie Maari yeni o ninsalo Mart dogu i. ");
INSERT INTO guxg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lan Maari n bo jogi i tolaali Jesu ki gɔ tugi o yudi ki fiali jesu taana, o ninjua n bo yia k yi Lasaar. ");
INSERT INTO guxg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","O ninsiabi bo sɔni ki ban waani jesu k o dɔnli buado naa paa. ");
INSERT INTO guxg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesu n gbadi li maami k o jiini: o yianu naa tie mi kuumi yaali ka, ama, ti Diedo diema nni, ki fidi, k o nul bijua n la ti yudandi. ");
INSERT INTO guxg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeni lan ya kuli, Jesu bo buadi Marti yeni o ninsalo yeni Lasaar. ");
INSERT INTO guxg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ya yognu k o gbadi ki Lasaar gbanu ki dagdi, o gɔ da bo ki luo ki tieni daana lie naani k o bo ye yeni. ");
INSERT INTO guxg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yeni k o maadi o yegnkaabi, tin lebdi mani Jude. ");
INSERT INTO guxg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","K o yegnkaabi maadi o: canba, mɔlane k sufi nba bo kpaani ban ja ŋa a tana, k a gɔ yedi k tin lebdi Jude i! ");
INSERT INTO guxg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ki Jesu ŋmiani: t ki pia piiga n kudi lie ka yienu nni i? nul ya cuoni yienu, k o maadi bonli ki dugni o nua ŋanduna ne yinyiemi. ");
INSERT INTO guxg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama, nul ya cuoni bonbonli nni, o maadi ki dugni o ki yegi yeni yinyiemi ba kuli. ");
INSERT INTO guxg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wan pua bi li maakpanjami ki gbeni, k o maadi: Lasaar, ti dɔnli, guandi, ama n ba find o. ");
INSERT INTO guxg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","K o yegnkaabi maadi o: yonbidaan, o ya guandi, o bi paagi. ");
INSERT INTO guxg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesu bo bua yedi ba k o kpe i, ama k ban maal k o maadi guamɔnbi. ");
INSERT INTO guxg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeni ki Jesu maadi a sala siigni: Lasaar kpe o. ");
INSERT INTO guxg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","I ya po, k fidi k yin tuo yeni i mɔni, li tie n po pamanli yeni min bo ki ye. Ama tin gedi mani o den po. ");
INSERT INTO guxg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Be ya po i k Toma, yua bo tami k yesu yiedi bo maadi o liebi, tin ŋɔdi mani ki mɔ kpe yeno. ");
INSERT INTO guxg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesu den pundi ki sua ki Lasaar kpe o ki bedi hali dana naa. ");
INSERT INTO guxg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nani Betani n bo ki fagi yeni Serusalemi yeni, ");
INSERT INTO guxg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sufi nba boncianli bo gadi ki bua tieni Marti yeni Mari i kuufuondi. ");
INSERT INTO guxg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lan ya yognu ki Marti gbadi ki jesu pundi, k o hedi o liigi bo, l bo sua ki Mari kaa o bulñɔbu nni ");
INSERT INTO guxg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marti maadi Jesu: yonbidaan a ya bo ye ne, n ninjua bo kan kpe. ");
INSERT INTO guxg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama, yeni lan ya kuli, n bani k a ya buali yaali ti Diedo, ti Diedo ba teni a. ");
INSERT INTO guxg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu ŋmiani o: a ninjua bu yiedi. ");
INSERT INTO guxg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","N bani, Marti ŋmianio, o bu yiedi li daajijuogi daali. ");
INSERT INTO guxg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu maadi: min tie o yiedo, ki tie li miali. Yua pia li dandanli ki duu n po bu la li miali, ba o ya kpe; ");
INSERT INTO guxg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yua fuo ki dug n po, kan bangi ki kpe. A dug li po i? ");
INSERT INTO guxg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ke o maadi o: Nn, yonbidaano, n bani ke a tie Kiristo, U Tienu bijua, yua ba cua li ŋandunli nni. ");
INSERT INTO guxg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wan yedi lani, ke o siedi ki gedi ki ban yini o ninsalo Maari suoo. Ki yedi o, “Canbáa cua, ki yi a.” ");
INSERT INTO guxg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wan gbadi lani, ke o kudi ki fii, ki gedi o kani. ");
INSERT INTO guxg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Li yognu, ke Jesu da ki pundi u dogu nni, ki da li ye Marta ń tuogi o naankani yeni. ");
INSERT INTO guxg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juufinba yaaba n bi ye yeni o li dieli nni, ki baagi o yeni ń la ke o kudi ki fii, ki ñani yeni, ke bi ŋɔdi o, ki maali ke o caa li kakuli kani ki baa buudi i. ");
INSERT INTO guxg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maari ń cua Jesu ń ye naani, ki la o, ke o baa ki gbaani o taana po, ki yedi o, “O Diedo, a ya bi ye ne i, n ninjua bi kan kpe.” ");
INSERT INTO guxg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu ń la ke Maari buudi ke juufinba mo buudi, ke mi maalma kua o, ke o yama ŋmadi; ");
INSERT INTO guxg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ke o maadi, “I piini o le i?, ke bi maadi o, “O Diedo, cua na ki diidi.” ");
INSERT INTO guxg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu bo buudi. ");
INSERT INTO guxg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ke juufinba yedi, “Diidi mani wan den bua Lasaari maama!” ");
INSERT INTO guxg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama ke nitianba maadi, “Ya nilo n luodi yua n mali juamo yeni, bi kan fidi ki cedi o nilo ń da kpe ee?” ");
INSERT INTO guxg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ke li bonli kua Jesu, ke o gbanu dá li ŋɔa, ke o gedi li kuli kani. Li den tie tanfalu i, ke ku tangu bii bu bulñɔbu. ");
INSERT INTO guxg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ke Marta, o kpiemo ninsalo yedi Jesu, O Diedo, ya yognu ne o nuugi o, tin pii o, dana na n yeni. ");
INSERT INTO guxg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ke Jesu yedi o, “N ki yedi a ke a ya dugi n po, a ba la U Tienu kpiagdi ii?” ");
INSERT INTO guxg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ke bi biidi ku tangu, Ke Jesu yaadi ki diidi poli, ki yedi, “N Báa, N tiendi a balga yeni ŋan cengi n maama. ");
INSERT INTO guxg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N bani ke a li cengi n maama yogu kuli, ama, li tie ku niwulgu yugu n taani ki lindi nni ne penio i ke n maadi yeni, ke ban la ki dugi ke fini n sɔni nni.” ");
INSERT INTO guxg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wan yedi lani, ke o tandi ki maadi, “Lasaari, Fii ki ña na!” ");
INSERT INTO guxg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ke o kpiemo fii, ki ñani; ke o nui yeni o taana fiini a caba, ke li cabli bobni o nunga. Ke Jesu yedi ba, “findi findi mani o, ki ŋa wan ya caa.” ");
INSERT INTO guxg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lani ke juufinba boncianli yaaba n bo cua Maari kani, ki la Jesu ń bo tieni yaali, ji bo dugi o po. ");
INSERT INTO guxg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama, nitianba guani ki lebdi farisienba kani, ki togdi ba Jesu ń tieni yaali. ");
INSERT INTO guxg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lanyapo i ke salga yidkaaba yudanba yeni farisienba taani yikodanba tantaanli, ki yedi, “Ti ba tieni ledi i? O nilo ne tiendi yaalidgu bona boncianla ");
INSERT INTO guxg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ti ya ŋa o yeni, ke o tie wan bua yaali, bi niba kuli baa dugi o po i; Roma yaaba ba cua ki fie ti tinfanma yeni ti dogtieba i.” ");
INSERT INTO guxg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ama, ke nilo ye bi siiga ki yi Kayifa, ki tie lanyognu salga yidkaaba yudaano, yedi ba, “Yi ki bani libakuli. ");
INSERT INTO guxg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","I ki bani ke niyendo ya kpe bi dogtieba kuli po, li baa tu yeni ban buoni u dogu kui ii. ");
INSERT INTO guxg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ama, wani obá ka bo maadi li maama. Wan den tie salga yidkaaba yudaano yeni, bi den pua o sawali ke Jesu ba kpe ki fie bi niba miali. ");
INSERT INTO guxg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Li ki tie bi dogtieba baba po ka, ama, o kuuma ba cedi U Tienu bila yaaba n yayadi ŋanduna nni yeni ń guani ki taani kaanyendu. ");
INSERT INTO guxg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lanwani ii, li daali ligi i, ke bi cili ki bobindi ban ba tieni maama, ki kpa Jesu. ");
INSERT INTO guxg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lanyapo i ke Jesu ji den ki wangi o yuli jufinba nitaanli nni, ama, o den fuadi ki gedi ku tinpiengu po, ya dogu nni ke bi yi Efrayimi. O ji den ye lanpo i, yeni o ŋɔdkaaba. ");
INSERT INTO guxg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juufinba pendima jaanma ji den nagdi, ki juufinba boncianla den ña dogtiani, ki do ki caa Jerusalema, ki ba ŋuudi ki ŋanbi bi yula. ");
INSERT INTO guxg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bi den nua Jesu, ki maadi bi ŋmiali nni, ban den ye ku jaandiegu nni ya yognu, “I maalma tie be i? Ke o kan cua mi jaanma?” ");
INSERT INTO guxg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ke salga yidkaaba yudanba yeni Farisienba teni bu ñɔbu, ke nilo ya la Jesu naani, wan tuali ba, ban cuo o. ");
INSERT INTO guxg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pak (Mi Pendma) jaamna ń sieni dana luoba, Jesu ń pundi Betani, Lasaar ń bo ye naani ke o yiedi o bi tinkpiba siiga yeni. ");
INSERT INTO guxg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ban tieni o mi daajuojiema li kani Marta den den tieni ba mi jiema ke Lasar kaa yeni o u jedikaanu. ");
INSERT INTO guxg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maari ń taa tolaade kɔnkɔnli yaal ya nuulu n mani ke li dunga yabi, ki wuli Jesu taana po, ki gbaani ki fiadi fiadi yeni o yudi; Tolaade nuulu ń ga ki yendi ku diegu. ");
INSERT INTO guxg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","O ŋɔdkaaba siiga yendi, Siimɔn bijua Suuda Isikariyot, yua n ba ti janbi o ń maadi: ");
INSERT INTO guxg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Be n cedi ke ti kan bi kuadi li tolaade ki ga ligi dibala kobi taa ki todi a luoda a? ");
INSERT INTO guxg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O den ki maadi yeni ke wan juogi a luoda ka, ama, o den tie suudo i; wan den kubi bi ligbɔgli yeni, o den su ki jobdi ban kpiendi ya ligi yin tua o ligceli. ");
INSERT INTO guxg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ama ke Jesu maadi: ŋa wan ya kubi li tulaade, ki guuni n kupiima daali. ");
INSERT INTO guxg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","I ye yeni a luoda daali kuli; ama i kan ya tundi ki ye yeni nni. ");
INSERT INTO guxg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bi niba boncianli ń gbadi ke Jesu ye Betani ban cua, laa tie Jesu baba po ka ke bi cua, ama bi go den bua ban la Lasaar, Jesu ń den yiedi yua bi tinkpiba siiga yeni. ");
INSERT INTO guxg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Salga yidkaaba cianba ń kali ki jagi ke ban kpa Lasaar mo. ");
INSERT INTO guxg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kelima jufnba boncianli den yiedi ba Lasaar yiedma po, ki ji ŋua ki dugi Jesu po. ");
INSERT INTO guxg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lan fandi, ke bi niba boncianli yaaba n cua mi jaanma gbadi ke bi maadi ke Jesu caa Jerusalem, ");
INSERT INTO guxg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ban padi ti kaadbensɔngdi (ti biadi) ki tuogi o, ki ya yigni: “Osana” Ti kpiagdi U Tienu yeli, mi yedŋanma yua n cua O Diedo yeli po, Israyeli Badciamo! ");
INSERT INTO guxg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu den baa ŋunbiga, ki jagi nani lan bo diani maama, ");
INSERT INTO guxg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ji da jie Siyɔn bisalo; diidi, a badciamo kpendi, ki jagi ki ŋunsiaga. ");
INSERT INTO guxg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","O ŋɔdkaaba dá den ki gbadi li bona niima nni; ama Jesu ń baa ti kpiagdi, ke bi ji tiadi ke li bona den diani o ya po i, Ke li den tie ke ban tieni yeni i, o po, lan tieni ki dudi. ");
INSERT INTO guxg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yaaba n den ye yeni o ya daali ke o den yini Lasaar li kakuli nni, ki yiedi o bi tinkpiba siiga yeni, den saagi i mɔni, ki tiendi o po kasiedi. ");
INSERT INTO guxg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ku niwulgu den tuogi o, kelima bi den gbadi ke o tieni lan ya yaalidgu bona. ");
INSERT INTO guxg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ke farisienba ji maadi bi ŋmiali nni: I la ke i ji kan fidi libá kuli, i gbali o; diidi mani, ŋanduna niba kuli ŋɔdi o. ");
INSERT INTO guxg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Greknba siiga nni yaaba n den doni, ki cua ki ba pugi U Tienu mi jaanma yogu, ");
INSERT INTO guxg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ke bi maadi Filiip, Betsayida, Galile diema nni yua, ki yedi yeni mi niidma: Canbáa, ti bua la Jesu. ");
INSERT INTO guxg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filiip ń gedi ki maadi Andre bani bilie ń maadi Jesu. ");
INSERT INTO guxg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu ń jiini ba: «U yogu pundi ke o nisaalo bijua ń baa ti kpiagdi. ");
INSERT INTO guxg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","«I mɔmɔni i mɔmɔni, n maadi yi, dibima ya baá tinga nni, kaa kpe, mi baa ye mi baba i; ama mi ya kpe, mi ba loni boncianla.» ");
INSERT INTO guxg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yua n bua o miali ba biani li, ke yua n luni li ŋanduna ne nni baa tundi ki kubi li hali ya yogu n ki pia gbenma. ");
INSERT INTO guxg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yua n tuuni n tuonli, ba ya ŋua nni i; n ya ye naani n tuonsɔnlo mo baa ye lankani i. Yua n tuuni n tuonli, Báa ba selini o. ");
INSERT INTO guxg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Molane n yama ji ŋmadi. N ba maadi be? ... Ba, faabi nni ya yognu ne ... Ama lani ya po i ke n pundi hali ya yognu ne. ");
INSERT INTO guxg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Báa, kpiagi a yeli! Ke nialu ñani tanpoli ki maadi: N kpiagi li, ki go ba kpiagi li. ");
INSERT INTO guxg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ya niwulgu n bi ye likani, ki gbadi, maadi ke li tie taatantandi. Ke tianba yedi ke maleki n maadi yeni o ");
INSERT INTO guxg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ke Jesu maadi: Mini ya po ka ke i gbadi ya nialu ne, yinba ya po i. ");
INSERT INTO guxg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mɔlane, ke bi jiagi ŋanduna ne buudi; Mɔlane, bi ba tudi ki ñani ŋanduna ne naabiigki niipo. ");
INSERT INTO guxg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mini, bi ya fiini nni, ki tinga ne po, ki duoni nni, n ba dadi bi niba kuli n kani. ");
INSERT INTO guxg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","O den maadi yeni ki wangi wan ba kpe maama i. ");
INSERT INTO guxg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ku niwulgu ń maadi: Ti gbadi ke yiko maadi ke Kiristo wani baa tundi ki ye hali ya yogu n ki pia gbenma; li ga ledi i, ke fini wani nan yedi ke: «Li buali ke ban fiini ki duoni o nisaalo bijua? ŋma n tie li nisaalo bijua? ");
INSERT INTO guxg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu ń maadi ba: «Mi yenyenma dá ba tieni u yogu waamu i siiga. Ya cuoni mani ke mi yenyenma dá ye i po, ke li bɔnbɔnli ń da ti ludi yi. Yua n cuoni bɔnbɔnli nni ki bani wan caa naani. ");
INSERT INTO guxg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mi yenyenma ń dá ye yi po yeni, yin ya dugi mani mi yenyenma po, ki fidi ki ya tie mi yenyenma bila.» Jesu ń yedi lan ya bona, wan fuadi fagma, ki ban wuoni kaatiani. ");
INSERT INTO guxg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hali yeni wan tieni ya yaalidgu bona boncianla bi nunbu nni, bi den ki dugi o po ");
INSERT INTO guxg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ki fidi ke o sawalpualo Esayi ñɔmaama ń tieni ki dudi: «O Diedo, ŋma gbadi tin tuodi ki waani ya tunda? O Diedi nuu nan dɔgdi ŋma ya po i?» ");
INSERT INTO guxg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yaali n pugdi, bi den kan fidi ki ya dugi kelima Esayi go maadi: ");
INSERT INTO guxg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«O juani bi ninbina; ki juagi bi pala ke ban da fidi ki ya nua yeni bi ninbina ki da gbadi yeni bi pala; ke ban da lebdi bi pala, min tebi ba. ");
INSERT INTO guxg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esayi maadi lan ya bona ya yogu ke o la o kpiagdi, ki maadi o maama ");
INSERT INTO guxg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ama, bá bi badtieba siiga boncianla den dugi o po, ama Farisienba po, bi den kan kadi ki maadi ke ban da ti beli ba ki ñani ba yiko bangma diena nni. ");
INSERT INTO guxg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kelima bi den bua ban ya dondi bi niba ki cie yeni ban ya dondi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ki nan sua ke Jesu bo kpaandi ki maadi: «Yua dugi n po ki dugi mini ya po ka ama yua n sɔni nni ya po i. ");
INSERT INTO guxg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ke yua n nua nni nua yua n sɔni nni. ");
INSERT INTO guxg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","N cua nani yenyenma yeni ŋanduna nni ke yua n dugi n po n da ye bɔnbɔnli nni. ");
INSERT INTO guxg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nilo ya gbadi n maama, kaa taa ma ki bili o pali nni, mini ka ba jia o buudi; kelima mii cua ki ba jia ŋanduna buudi ka ama ke min faabi ŋanduna i. ");
INSERT INTO guxg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yua n yie nni kaa ga n maama pia yua n ba jia o buudi; min yaadi ki maadi ya maama, mani n ba jia o buudi li daajuodkaali. ");
INSERT INTO guxg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kelima, mii maadi n yeli po ka ama Báa yua n sɔni nni ya yeli po; wani o bá tuodi ki waani nni min ba maadi yaala yeni min ba pua ya sawali. ");
INSERT INTO guxg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N go bani ke o yikodi maama tie ya miali n ki pia gbenma. Lan ya po i ke min maadi ya bona kuli, n maadi nani Báa ń maadi nni maama i. ");
INSERT INTO guxg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ke paki jaanma daa ki pundi, Jesu den bani ke o yogu pundi ke o baa guani o ba po yeni yaa buanma ke o pia o niba po yeni li juodima. ");
INSERT INTO guxg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mɔla Sitaani kua Suda Isikariyoti Simo bijua yua baa kuadi Jesu. ");
INSERT INTO guxg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu den bani ke o ba mubini o bonli kuli ke wan mo den baa U Tienu po i ke gɔ den baa guani o kani. ");
INSERT INTO guxg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wan jeni ki gbeni, o landi o liadili ki taa li cabili ki bugi. ");
INSERT INTO guxg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ki nuudi o ŋuadikaaba taana ki fiadi yeni li cabli yia ke o bugi yeni. ");
INSERT INTO guxg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wan pundi Simo pieri kani, ke o maadi o: «Yonmidaano, a bua ŋuudi n taana yaaa?» ");
INSERT INTO guxg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ke Jesu ŋmiani o: «I kan gbadi min tieni yaala ne niima nni, yoguba yaa kaa.» ");
INSERT INTO guxg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pieri madi o: «A kan ŋuudi n taana paliba.» ke Jesu yedi o: N yaa ki ŋuudi a taana, a ki pia n kani libakuli.» ");
INSERT INTO guxg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔn Pieri maadi o: «yonmidaano, daa ŋuudi n taani o baba ka, ŋuudi n yuli yeni n nui mɔ» ");
INSERT INTO guxg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu ŋmiani o: «Yudi ki ŋuudi a taana ji kpaani ban ŋuudi o ki pugini kaa wan fidiki ŋanbi ke yaa ŋani, yi yan, ama yi kuli kaa» ");
INSERT INTO guxg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu den bani yua bi kudi o, laa po n cedike oden maadi: «yi kuli kaa ŋani» ");
INSERT INTO guxg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesu n ŋuudi bi taana ki gbeni, ki gadi ki kali yeni o tiadi, ki maadi ba: «yi bani min tieni yaala? ");
INSERT INTO guxg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","I yin yonmidaano yen canbaa. ");
INSERT INTO guxg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Li yaa sua min canba yeni yonmidaano n ŋuudi i taana, i mɔ n yaa ŋuudi i lieba taana. ");
INSERT INTO guxg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","kelima binbiiguken teni ike lan fidi ke mɔ n yaa tie nani min tieni yeni. ");
INSERT INTO guxg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","I mɔni yeni i mɔni, n maadi i: tuonsɔnlo ki cie o canba; yeni mɔ ke o tandi o kicie yua sɔni o. ");
INSERT INTO guxg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","I yaa bani lan ki cɔlni a, baliga tie i yaa le. ");
INSERT INTO guxg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","N ki maadi i kuli kaa, kelima n pia min gandi yaaba i. ");
INSERT INTO guxg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","N maadi ki sua ke li bona daa ki tieni ke yin fidi ki bandi min tie yua. ");
INSERT INTO guxg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","I mɔni po i mɔni po n maadi; yua n gaani ga n tondo yua n gaani ga yua sɔni nni. ");
INSERT INTO guxg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu bo maadi li maami kelima li ŋmadiyaama lani ke o maadi: «I mɔn po i mɔni n maadi, i siga nni yendo baa kuadi nni. ");
INSERT INTO guxg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","O ŋuantiba ji dennua bi lieba ki buali bi ŋmiali nni wan maadi yua. ");
INSERT INTO guxg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","wan den bua yua den dua opo. ");
INSERT INTO guxg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ke Simɔn Pieri sɔbi sɔbi o tubili nni ki yedi o«Jesu maadi ŋmai i?» ");
INSERT INTO guxg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ke o nangini Jesu kani ki buoli o, «Yonmidaano, ŋmai?» ");
INSERT INTO guxg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Li yogunu ke Jesu yedi o: «Min ba teni yua kpanu» ki taa ki teni Juda, Simɔn Kanati biga. ");
INSERT INTO guxg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","kpanu po n pendi, ke sitaani kua o; ke Jesu yedi o «ŋan bua tieni yaali yeni tieni toni. ");
INSERT INTO guxg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jesu n deni maadi, bani yaabi n deni kaa nulo baa kuli die bani li niima nni. ");
INSERT INTO guxg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bi tɔba de maali ke Suda n kubi i ligikpɔgu yeni ke Jesu den maadi o, «Daa mi janma tiadi» Bi tɔba maalima den tie ke u baa baa libaa ki teni talga nba i yedi» ");
INSERT INTO guxg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Suda n gaa kpanu, ke o ñani toni ki sua ke li bondi o. ");
INSERT INTO guxg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Suda n ñani ke Jesu yedi: «Mɔla o nilo bija laa ti yudandi, ke U Tienu mɔ laa ti yudandi. ");
INSERT INTO guxg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","U Tienu yaa laa ti yudandi ki dugini o bija po, wani U Tienu mɔ waani u yudandi u bija nni. ");
INSERT INTO guxg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","N biidi n jikan yaa ye yeni lan waagi. I baa kpaani n. N ji maadi i mɔni nani min den maadi Sufa nba yudamba yaala. I kan fidi ki cua min caa naani. ");
INSERT INTO guxg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","N bu teni lanbonpanli; yaa bua mani i lieba nani min den ba i maama yeni. ");
INSERT INTO guxg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Li po bi niba bu bandi ki tieni ŋɔdikaaba, ke li yaa tie ki pia mi buama i lieba po. ");
INSERT INTO guxg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ke Simɔn Pieri yedi o: «N yonmidaano, a caa le i?» ke Jesu yedi o: «A kan fidi ŋɔdi min caa naani, yogu baa yaa kaa» ");
INSERT INTO guxg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ke Pieri ŋmiani o: «N yonmidaano be n cedi ke n kan fidi ki ŋɔdi a mɔla ne? Li yaa buali ke min kpe a po, n ye. ");
INSERT INTO guxg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ke Jesu ŋmiani o: «A baa kpe n po? I mɔni yeni i mɔni min maadi a; a ba nia taalimataa kaa ki bani nni ke ̵kokolo daa ki buudi. ");
INSERT INTO guxg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ke Jesu yedi: Daa ŋmadi mani yanmaka, i ya dugi u tienu po yin ya dugi n mɔ po. ");
INSERT INTO guxg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","N baa deni pia li yiali boncianla, li ya bo ki tie mɔni n bo kan yedi kin b gadi k ban cegni li yiali i po. ");
INSERT INTO guxg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","K guani ki tugi ki lan fidi mini nye naani, i mɔ n ya ye li kani. ");
INSERT INTO guxg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","I bani ya sɔnu ki n caa. ");
INSERT INTO guxg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ki Toma yed'o; “yomdaano, tiki bani ŋani caa naani; ledi ki ti bu bandi u sanu?” ");
INSERT INTO guxg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ki Jesu yed'o: “N tie u sɔnu, i mɔni, limiali, nulo kan fidi ki baa baa kani kiki tɔgini n kani. ");
INSERT INTO guxg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","I ya ban nn, i bani n Baa mɔ, mɔla mɔ i band'o ki goa la'o. ");
INSERT INTO guxg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ke Filipi yed'o: “Yomdaano, waant'i Baa, ki lan dagidi ti “. ");
INSERT INTO guxg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ke Jesu yed'o: Filipi, min waagi yeni maama yeni ki a goa sua ki a ki bandin nni? ");
INSERT INTO guxg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Da maali mani ke n ye n Baa nni ke n Baa mɔ ye n nni ka? Mi maama yua ke n maadi ne ki tie mi buana ka, ama Baa yua yenni yeni'n sua o tuona. ");
INSERT INTO guxg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Daa mani nni ke n ye Baa nni, ke Baa mɔ ye nni, bii ya du mani n po kitɔgini; n tuona po. ");
INSERT INTO guxg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","I mɔni yeni'i mɔni, n maadi, yua du n po, b tieni ya tuona n gbengi ki cie min tie yaali nne kelima n caa n Baa po. ");
INSERT INTO guxg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","yaali kuliki bu mia n yeli po, n bu tieni kilan fidi binuba n bandi ke tienu bijuan o biju nn. ");
INSERT INTO guxg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","I ya mian nni yaali kuli n yeli po, n bu tieni. ");
INSERT INTO guxg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","I ya buan ni, yin cɔlni n lanbona. ");
INSERT INTO guxg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","N bu mia Baa, ki wan te ni todikaa bieno, yua baa tundi ki ye yeni, ");
INSERT INTO guxg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","mi tagima yeni i mɔni. ŋanduna kan fidi gao kelima o ki nua'o, k goa ki ban'o. ");
INSERT INTO guxg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","N kan ŋaai i baba kaa, n t b guan ni. ");
INSERT INTO guxg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Li ya suli waamu, ŋanduna niba ji kani la'n. Ama yimba wani bu la'n, kelima min baa fo yeni, i mɔ baa fo. ");
INSERT INTO guxg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Li daali ke i bu bandi ke i ye n Baam, ki yen nni, ki mɔ ye i nni. ");
INSERT INTO guxg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yua tuo ke goa mi maama ki cɔlni, wani n bua'n. N Baa baa bua li daano, ki n mɔ buali daano. N bu legdi ki waano min tie yua. ");
INSERT INTO guxg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Lani ke suda bual'o (li ki tie Suda Iskariyoti kaa?). Be ya po i ke a bu legidi ki waani a baa, timba n la'a, ke a nan ji kan waani a baa ŋanduna yaba? ");
INSERT INTO guxg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ke Jesu guani ki ŋmian'o: Yua bua'n, u baa kubi mi maama. N Baa baa bua'o. Min yeni n Baa u kani ke yaa yen'o. ");
INSERT INTO guxg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","yua ki bua'n, u kani kubi mi maama. Min yedi yaali ne ki tien yuli po maama ka. N Baa yua sɔn'nni yaali. ");
INSERT INTO guxg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","N yed'i li kuli ne ka daa ye yeni. ");
INSERT INTO guxg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","M tag yama yua tie i todika, ke n Baa bua sɔno n yeli po n t an bu waani bonlikuli niimn. ");
INSERT INTO guxg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","N bu cabi yin ya ye laafia. N ki tieni nani ŋanduna yaabi n tieni yeni kaa. Daa ŋmadi mani i yama, da jie mani pu. ");
INSERT INTO guxg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","N tua i gbaadi min maad'i kin caa yeni ama ki goa bu guan nni i kanaa? li ya bosua ki buanni, min yedi ki n caa n Baa kani, i bo baa ye li pamanlinni kelima n Baa yabi ki cie nni. ");
INSERT INTO guxg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N tuad'i ki yedi mɔlane kili bona daa k tieni, ki li ya t tieni yin tuo ki gaa yeni i mɔni ");
INSERT INTO guxg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","N ji kan maadi maacianma yeni yi kelima, ŋanduna ne yikodaano ba pundi, waa pia paalu n po, ");
INSERT INTO guxg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama, ki fidi ŋanduna ń bandi ke n bua Báa, n tieni nani Báa ń́ bili ke min tieni maama i. Cedi mani tin fii ki siedi ne.” ");
INSERT INTO guxg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mini n tie ku daamɔngu tiimɔnbu, ke n Báa tie o kuandaano. ");
INSERT INTO guxg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","O pedi ya benli n tuugi yeni nni, kaa luoni kuli, ki gbadi ki ŋanbdi ya benli n luoni, lan fidi ki ŋanbi ki loni. ");
INSERT INTO guxg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","I ji ki pia jɔgindi kelima min maadi yi ya maama po. ");
INSERT INTO guxg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ya ye mani yeni nni ke n mɔ ye yeni yi. Nani benli baba ń kan fidi ki loni, kaa tuugi yeni tibu, lanwani ii, i mɔ kan fidi ki loni, kase ke i ye yeni nni. ");
INSERT INTO guxg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mini n tie ku daamɔgu tibu ke i tie a bena. Yua n ye yeni nni, ke n mɔ ye yeni o o ba loni boncianla, kelima N yaa ye, i kan fidi ki tieni libakuli. ");
INSERT INTO guxg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","nilo yaa ye yeni nni, bi baa lu o nani li benli yeni, wan kuodi, bi baa gandi a bena, ke lu o muu nni, ŋan cuo. ");
INSERT INTO guxg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","I ya ye yeni nni, ke n maama mo ye yeni yi, mia mani yin bua yaali kuli yi ba laa. ");
INSERT INTO guxg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","I ya luoni boncianla n Baa ba baa ti kpiagidi lan waani ke i tie n ŋɔdikaaba. ");
INSERT INTO guxg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nani ti Baa n buadi nni maama nmo buadi yi. Ya ye mani n buama nni. ");
INSERT INTO guxg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","I ya kubi n maabilkaama, yi ba ye n buama nni nani min kubi n Baa maabilkaama, ki ye o buama nni yeni i. ");
INSERT INTO guxg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","N Maadi yi ya bona ne kuli, ke n pamanli n ya ye i niinni, ke i pamanli ń gbie ki dudi. ");
INSERT INTO guxg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","N maabilkaama tie, ke yin ya bua i lieba nani min bua yi maama yeni. ");
INSERT INTO guxg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nilo ki pia buacianma ki cie ke wan lu a miali o dɔnlinba po. ");
INSERT INTO guxg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","I ya tie a bona nani min bili yi maama, i baa tie n dɔnlinba. ");
INSERT INTO guxg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N ji kan ya yi yi n naacenba, kelima o naaciemo ki bani o canbáa ń tie yaali. N yini yi n dɔnlinba kelima, min gbadi yaali n Baa kani, n cedi ke i bandi. ");
INSERT INTO guxg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yinba ka lugdi nni, ama mini n lugdi yi, ki sɔni yi, ke, ke yin gedi ki loni a luana, ke li luana ń ya bii ye. Ke yin ba mia yaali kuli n Báa kani, n yeli po, o ba teni yi. ");
INSERT INTO guxg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Min bili ke yin ya tiendi ya bona tie, ke yin ya bua i lieba. ");
INSERT INTO guxg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ŋanduna ya nani yi, yin ya bani ke bi tuodi ki nandi mini yo, ki fidi ki nandi yi. ");
INSERT INTO guxg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","I ya bi tie ŋanduna yaaba, ŋanduna bi ba buadi lanbuali maama. Ama yin ki tie ŋanduna yaaba yeni, ke mini n lugdi yi ŋanduna nni yeni, lanyapo i ke ŋanduna nani yi. ");
INSERT INTO guxg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ya tiani mani min maadi yi ya maama, 'Naaciemo ki cie o canbaa.' Bi ya waani nni fala, bi ba waani imo fala; bi ya cɔlni n maama, bi ba cɔlni i yaama mo. ");
INSERT INTO guxg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bi ba tieni yi lanya bona kuli, n ya yeli po, kelima baa bani yua n sɔni nni. ");
INSERT INTO guxg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","N ya bo ki cua ki maadi ba, bi bo kan ya pia biidi, ama, mɔlane, bi ji kan baa sugli bi biidi po. ");
INSERT INTO guxg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yua n nani nni, nani n Baa mɔ i. ");
INSERT INTO guxg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","N yaa bo sɔni ya tuona ke obakuli kan fidi ki sɔni bi siiga, bi kan ya bo pia biidi, ama mɔla, bi la likuli, ki nandi mini yeni n Baa kuli. ");
INSERT INTO guxg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bi tieni yeni, ke yaali n diani bi yikodi nni ń tieni ki dudi i, 'Bi nani nni fanfanma i.' ");
INSERT INTO guxg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","O candaano, min ba sɔni yua wan ña Baa kani, wani n tie ya mɔmɔni Foŋanma yaama n ña Baa kani ya cua, o ba tieni kasiedi n po. ");
INSERT INTO guxg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","I mɔ tiendi kasiedi n po, kelima i bo ye yeni nni hali mi cilma. ");
INSERT INTO guxg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","n wangi laa bona kuili ke lan ti tua yi po tan tuudi kaali. ");
INSERT INTO guxg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","bi ba ti ñani libalimaama bangima diena nni uyogu kpendi ke yua n baa kpa yi baa nua ke o tuuni tuonŋanli UTienu po. ");
INSERT INTO guxg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","o baa tiendi lanbona kuli kelima waan bani Ba bi mini mo ");
INSERT INTO guxg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","n maadi yi lanbona, ke li yoginu yaa ti cua yin tiadi ki den tuodi waani yi li kuli. den ki yidi yi cincinli yogu kelima n den ye yni yi. ");
INSERT INTO guxg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","n ca yua n den sɔni nni kane ama yi niini nni ba yendo ki buali nni a caa le? ");
INSERT INTO guxg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","yi pala gbie yeni li pabiidili kelima n waani la. ");
INSERT INTO guxg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","li sieni waamu n baa yedi imɔmɔni: “li baa ŋani yi po yeni mini gedi, kelima n yaa gedi oTodika kan cua yi kani ama n yaa gedi n baa suano yi kani. ");
INSERT INTO guxg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","yua n ba fiali ti nunsiidi yeni yaa cua yaa yoginu li baa tie yaalidigu ŋanduna yaaba po. ti tuonbiadi po, mi teginma po, yeni ti buudi po, ");
INSERT INTO guxg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","yaala n tie ti buudi po, kelima bi ki daani nni, ");
INSERT INTO guxg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yaala ntie miteginma po, kelima n ca Ba po ki kaa go laadi nni ");
INSERT INTO guxg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","yaala n tie tibuudi po kelima n jia ŋanduna bado ti buudi. ");
INSERT INTO guxg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","n pia mi maama boncianla ki bua ki maadi yi, ama yi kan fidi ki gbadima moala ne. ");
INSERT INTO guxg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","yaa yoginu ki moamoani fuama yua baa cua o baa ŋmagidi yi imoamoani bonla kuli nni. kelima o kan yaa maadi oyuli po maama ama wan gbadi yaali kuli o baa yedi yi libona kul; i ki go waani yi yaa bona n baa cua. ");
INSERT INTO guxg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","o ba kpiagi n yeli kelima o ba ta yaa bonla ki n pia yeni kuli ki yaa wangi yi. ");
INSERT INTO guxg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","nBa n pia yaala kuli tie n yaale. n yedi ki fuoŋanma baa cua ki ga lin bonla kuli ke lan yaa tie n yali ke o wangi yi. ");
INSERT INTO guxg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","li yaa pugini waamu, yi kan la nni, li go yaa pugini waamu yi ba la nni. ");
INSERT INTO guxg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","o ŋɔdikaaba tianba den yedi bilieba, wan yedi ti yaala yeni li tie be. li yaa pugini waamu yi kan la nni li go yaa pugini waamu yi baa la nni kelima n ca nBa po? ");
INSERT INTO guxg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","lanwani bi den yedi omaadi be yaa maame ki yedi li pugini waamu? tinba ki bani wan maadi yaala. ");
INSERT INTO guxg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu den nua ki bi pia i buali ki bua bualo. ke o yediba yi bua buali nni min yedi yaala, li yaa pugini waamu yi kan la nni li yaa go pugini waamu yi ba la ni? ");
INSERT INTO guxg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","i moamoani yeni i moani n maadi yi. yi buudi ki go fabini ama ŋanduna wani yaa po li baa tie pamanle yi baa laadi li paboanli ama yi paboanli baa lebidi ki tua pamanli bonla. ");
INSERT INTO guxg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","li tie nani yaa pua n ye fala nni omadi yoginu yaa pundi ama wan laa yaa fala yeni o mali yaa yoginu o kan go tiadi o fala yeni po. yeni wan mali ki bipanga ŋanduna nni. ");
INSERT INTO guxg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","yinba mo yi pala boandi ŋanduna po ama yi ba guani ki la nni yi pala mo baa ye li pamanli nni, nilo ba kan fidi ki fie laa pamanli. ");
INSERT INTO guxg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","laa daali yi kan buali nni buali ba kuli imoamoani yedi li yaa tie yi mia n Ba yaala kuli n yeli nni tieni la. ");
INSERT INTO guxg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","hali lan yoginu yi daa mia li ba kuli nyeli nni, mia mani yi baa ba ke yi pala n mangi. ");
INSERT INTO guxg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","n maadi yi lan kuli yeni mikpanjama ama uyogu cuoni n kan maadi yeni mi kpanjama ama n baa maadi yeni cain hali ki li yieni nani n Ba n waani maama. ");
INSERT INTO guxg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Li daali yi ba mia yaali kuli n yeli po, mii yedi ke n ba jaandi ti Ba yi po; ");
INSERT INTO guxg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kelima Ba wan bua'i kelima yi bua nni. kelima i daani k n ñani Ba kani ki cua. ");
INSERT INTO guxg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","N ñani Ba po ki cua ŋanduna n ni; ke go ba ña ŋanduna nni ki guani n Ba po. ");
INSERT INTO guxg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bi ŋɔdikaaba den maadi: mɔla a maadi ke li yendi ti po, naa go maadi k li pia galima. ");
INSERT INTO guxg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mɔla ti bandi ka bani bonli kuli ke ŋaa go bua buali ba kuli lan bonli po, ti daan ke a ñan UTienu kani ki cua. ");
INSERT INTO guxg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu de guani ki yediba: i daan mɔlaa? ");
INSERT INTO guxg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Diidi o yoginu pundi, nn li pundi ki gbeni mɔ ko, i ba yayadi ki kuni yua kuli o den po, i ba ŋaa n ni n bebe ama mii ye n bebe kelima Ba ye yen nni. ");
INSERT INTO guxg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","N maadi laa bonla ki yi fidi ki ba mi yanduanma n ya po. Li ŋandunli nni, i ba pia a maba ama yin paagi yi ba: n paadi li ŋandunli. ");
INSERT INTO guxg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","jesu n den maadi lan bonli kuli yaa puoli po, o den yaadi ki noanli tanpoli ki yedi: «NBa uyoginu pundi kpiagi ABijua ki Abiga mo n kpiaga ");
INSERT INTO guxg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ki kuli tie nani ŋan puni nni li bali bini saaliba kuli po maama ke min pa ŋan puni nni yaaba kulu yaa miali n kan gbeni. ");
INSERT INTO guxg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","yaa miali n kan gbeni tie ke ban bandi fini yua bebe yua tie UTienu moamoani, yeni ŋan soani yua Jesu kilisiti ");
INSERT INTO guxg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","n kpiagi a, ki tinga po, n gbeni ŋan den puogi nni yaa tuonli. ");
INSERT INTO guxg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","moala n Ba ke min fidi ki ba yaa kpiagidi ke n den cindi ki pia hali ke ŋanduna daa tagi. ");
INSERT INTO guxg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","n teni ke ŋan den ñani yaaba ŋanduna nni ki puni nni yeni bandi Ayeli, bi den tie a yaa yaaba ke a den puni nni ba bi kubi amaama. ");
INSERT INTO guxg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","bi bandi moala ke ŋan puni nni yaala kuli ñani akani. n teni ba amaama yaama ke a teni nni, bi gaama ki daani ke bani ki ñani a yaa kani ki cua, ke fini mo n den soani nni. ");
INSERT INTO guxg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","n miadi a, ŋan puni nni yaaba po, laa tie ŋanduna yaaba po ka ke n miadi a, kelima bine tie ayaa yaaba. ");
INSERT INTO guxg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","yaala kuli n ye niini nni ye amo yaa niin nni, ŋan pia yaala kuli mo tie nyaa yaale n pali mani li po. ");
INSERT INTO guxg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","mini kan yaa ye ŋanduna niini nni, ama, bani wani baa ye ŋanduna nni kelima n kpendi a kani, Ba yua n gagidi ki ŋani, kubi ba Ayeli po. yaa yeli ke a puni nni ke ban tua yendo. nani mini yeni fini, n tie yendo maama ");
INSERT INTO guxg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Min den yenba ya yoginu, n den kubiba ŋan den pun nni ya yeli yeni, den kubiba ba ki bi siigin nni yendo ki bodi, li ya ki tie ya biga ba bodi yaa ka, ke lan gbieni i diani n den maadi yaali. ");
INSERT INTO guxg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mɔla n kpendi a kani, ama n den yedi lani, yali ki da ye yenba, ki min fidi ki paa'ba n pamanli kuli. ");
INSERT INTO guxg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N pun'bi a maama, ŋanduna niba nanba kelima bi tie ŋanduna yaabi. Nani n mɔ n gɔ ki tie ŋaqnduna yua maama ");
INSERT INTO guxg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mii miadi'ŋa ki ŋa ñanba ŋanduna ne ka, ama ki ŋan kubiba yibalo kani. ");
INSERT INTO guxg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nani min ki tie ŋanduna yua maami, ba mɔ kɔ ki tie ŋanduna yaabi yen. ");
INSERT INTO guxg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gagidi ki ŋanbiba i mɔmɔni nni kelima a maama tie mɔmɔni. ");
INSERT INTO guxg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nani ŋan den sɔni nni ŋanduna ne maama, n mɔ ko suani'ba yeni. ");
INSERT INTO guxg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","N gagidi(n kuogi) n yuli kelima bi ya po, ke ban mɔ ko n gagidi bi ba i mɔmɔni nni. ");
INSERT INTO guxg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","M ii jaandi ban beba ya po ka, ama yeni yaabi kuli ba te tuo ki daani nni kelima bi ya maama po. ");
INSERT INTO guxg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ki bi kuli n fidi ki tua yendo nani fin n baa n ye n nni maama, ke n mɔ ye a n nni. N miadi'ŋa ki ban mɔ ko n ya ye ti n nni, ke ŋanduna yaaba n gaa ki fini n suan nni ");
INSERT INTO guxg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","N punba ŋan den pun nni ya kpiagidi, ki ban fidi ki tua yendo nani fin yeni mini n tie yendo maam. ");
INSERT INTO guxg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Min ya ye bi ni nni, ka ye n ni nni, ki ban fidi ki tua yendo i mɔni. ke li ŋandunli n bandi ka den sɔn nni ka bua'ba ya buanma buolu kan bua nni. ");
INSERT INTO guxg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","N baa, ŋan pun nni yaabi yeni, n bua ban ya ye min ye naani kani. ki ban fidi ki ya nua n kpiagidi yaali ka den pun nni. Kelima a den bua nni hali ki ŋanduna da ke ye. ");
INSERT INTO guxg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baa yua tiegi, ŋanduna ki bani'na, ama min wani n ban'na yeni yaabi kuli n bani ka sɔn nni. ");
INSERT INTO guxg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N cedi ki bi bandi a yeli, n gɔ baa tiendi yeni ki ŋan pia n po ya buanma n ya mi nni, ki min ya ye bi ni nni. ");
INSERT INTO guxg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Li puoli po ki jesu guani ki lebidi sedlon naani ko bo kuo o goligun nni yeni o ŋɔdikaaba. ");
INSERT INTO guxg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","JIIda yua bo ba kuado, bo bani lan kani, kelima jesu den m, aani ki kua lan kani yeni o ŋɔdikaaba. ");
INSERT INTO guxg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jiida bo yeggi yeni, sijenba yeni bi canba nba yabi den kpa bi niba ki pugini Falisien nba, ke bi kubi a fida, togisi nba yeni ti tondaadi. ");
INSERT INTO guxg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nani jesu n bani ya bona ba tieni yeni ko nagini ki maadi: yi kpaani ŋmaa i? ");
INSERT INTO guxg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ki bi ŋmiani: Nasalete jesu, ki jesu yedi'ba: min n ye” jida yua bo kuadi jesu bo ye sejem nba. ");
INSERT INTO guxg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ko ŋmian'ba “mini n yeni” ki bi kuli lebidi ki ba puoli po tinga nni. ");
INSERT INTO guxg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ko pugini ki buali'ba: “i kpaani ŋmaa i?” ki bi ŋmiani: Nasaleti jesu” ");
INSERT INTO guxg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ki jesu ŋmianbiba: “n tuodi ki maadi ki mini, lani, yi cabi yaabi ne ki ban ya caa, li ya tieen ki kpaani mini. ");
INSERT INTO guxg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ne kuli den tieni ki lan fidi o maama n sɔni li tuonli. ŋaa ten nni ya niba, ba yendo ki bia bi siiga nni. ");
INSERT INTO guxg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Lani ki simɔ piali ñani o jugi o tuagun ki cua ki jia o dindacianmo tuonsɔnlo tubili jienu po, Bi bo yi li tuonɔnlo Malkist. ");
INSERT INTO guxg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Lani ki jesu maadi piali: “guani ki ŋuuni a jugi o tuagun nni, n ki dagidi yeni min la n ba n ten nni ya fala ya?” ");
INSERT INTO guxg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lani ki Jifnba liiga yabi yeni sijem nba cuo jesu ki lol'o. ");
INSERT INTO guxg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bi bo gadi yeno Ann yua bo tie Kaifi cuado kani, li binli kaifi den tie yua kpa bi niba. ");
INSERT INTO guxg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Li den tie ki wan n den yedi jufnba ki li ba ŋani ke nido n kpe bi niba kuli po. ");
INSERT INTO guxg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔno piali den ŋua jesu, yeni ŋɔdika tianu. O den tie ya ŋɔdika ko padicanmo bado bano, o den kua yeni jesu o padicianmo bado lojagu nni, ");
INSERT INTO guxg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama Simɔno piali den se niin ni buliñɔbu kani. Lani ke ya ŋɔdika ke ko badicianmo yudaano den ñani ke maadi yeni ya pua den gu o buliñɔbu teni piali kua. ");
INSERT INTO guxg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Lan wani ya pua n den gu o buliñɔbu yeni den yedi piali: “naani a mɔ gɔa tie o jua ne ŋɔdika kaa? “ko guani ki yedi: “mii tie'o”. ");
INSERT INTO guxg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bi puobi yabi den gu den taani ki se ki yel o mu li kani, bi den ta ti daadi ki cuon o mu ki yel kelima ti wadi den ye. Pial mɔ kɔ den ye yenba ki se ki yel yen bani. ");
INSERT INTO guxg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","O kopadicianmo yudaano den buali jesu yaali n tie o ŋɔdikaabi po yeni o banginma po. ");
INSERT INTO guxg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu den ŋmiano: “den maadi asala nni ke laa tie wuolin nni ka. N den bangi daali kuli li balimaama bangima diena nni yeni li jaandielin nni jufinba yen taagi naan kani. Mii den maadi wuolin nni. ");
INSERT INTO guxg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Be ya po i ki buali nni lan ya buali i? Yi buali yaabi n gbadi n maama”. ");
INSERT INTO guxg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesu n den yedi lan ya bonla i, mintiel yudaano yendo yua n den se yeni den pua'o “. Bi ŋmiandi yeni o padicianmo?” ");
INSERT INTO guxg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ke jesu den guani ki ŋmiano: “li ya tie ki maadi ki tudi, ŋan waan nni yaali n tie bonbiili, ama li ya tie ke n maadi ki cuobi, be ya po kan puan nni?” ");
INSERT INTO guxg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anna den cedi ki bi gedi yeni jesu o padicianmo bado Kaifa kani. ");
INSERT INTO guxg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Piali den ye li kani ki yeli o mu, lani ki bi bualo: “a mɔ ko ki tie bi ŋɔdikaaba siigin ne yua kaa?” Ko nia ki yedi: “laki tie yeni.” ");
INSERT INTO guxg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","O kopadicianba bado naciemo siigin ni yendo, yua n den tie ninja yeni piali n den jia yua ya tubili yeni den yedi: “mii bo la'ŋa o gogidigu yen'o?” ");
INSERT INTO guxg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piali gɔa den nia ki pugini ki li yoginu ko kotogu buudi. ");
INSERT INTO guxg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bi den gedi yeni jesu Kaifa deni o bujia kaanu. Li tie o siŋapanpangu, bani bi ba kan den kua o bujia kaanu kani ki ban da jɔgini bi ba ki ban fidi ki je Paki jiema. ");
INSERT INTO guxg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lani ke Pilat den ñani ki den buali'ba; 'o jua ne maam tie bee ki kub'o?” ");
INSERT INTO guxg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bi den guani ki ñian'o: “o naa jua yaa bo den nibiado ti kan bi cuo'o.” ");
INSERT INTO guxg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat den ŋmianba: “ta'o mani yinbi yanba ki juagu ti buudi ke ŋɔdi nani li balimaama n tie maama.” Bi den yedi Pilata: “ti balimaami ki cabi tin cuo nilo ki jua o buudi ki cuo ki kpagu.” ");
INSERT INTO guxg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bi den yedi yeni ke jesu maayedikaanma n kua, nani wan den waani ko ba kpe ya kuumi. ̇ ");
INSERT INTO guxg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Lani ki Pilati den guani ki kua o bujia kaano kani, ki den yini jesu ki bualo: “fin n tie jufinba badicanmo? ");
INSERT INTO guxg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu den ŋmian'o: “a buali laa bualo a yuceli po bii li tie ki ban mia'ŋa ki ŋan buali yeni?” ");
INSERT INTO guxg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilata den bualo: “n mɔ tie jufi yo” A buolu yaaba yeni bikopadicianma n cuo'ŋa ki cua ten nni. A tieni bee? ");
INSERT INTO guxg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","37","Jesu den guani ki ŋmiano: “n dienma ki tie ŋanduna ne yaali ka, li ya bo tie yeni n naacenba bo ban kɔni ki gaa nni jufinba kani. Mɔmɔni n dienma ki tie ŋanduna ne yaanma ka.” Pilata den bualo: «lanwani a tie badiciamo yo?» o den guano fini aba yedi ke n tie badiciamo li tie lani yaa po yo ke n cua ki mali: “li ya sanu nni k n cua ŋanduna nni ke min fidi ki tieni sieda i mɔmɔni po, ki yaabi kuli n tie i mɔmɔn yaaba n cengi n nialo.” ");
INSERT INTO guxg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilata den yed'o: “be n tie i mɔmɔn?” wan den yedi lani, o den ñani ki gedi jufinba kani: “ki yedi, mii la o ja n tieni yaali ki li bia. ");
INSERT INTO guxg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kelima li tie bogidili ke ŋan luodi dansaligi yendo ke ten'ti Pak jaanm ne. Lan wani yi nan bua ke min faabi yi po jufinba bado bii?” ");
INSERT INTO guxg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ke bi go taandi ki maadi: “laa tie lan jua, ama Banabasa” Ke sua banabasa den tie nikpalo. ");
INSERT INTO guxg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","lanwani Pilata den ta Jesu ki teni Sojenba ki bi pua o agbana. ");
INSERT INTO guxg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sojenba den ta i konkoni ki piani ke li tie nani OBado fogilga yeni ki yilini Jesu yuli po, ki go lano gaali moangu. ");
INSERT INTO guxg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","bi den cuoni o kani ki tua ti fuonda fini jufinba Bado, bi go den pabino. ");
INSERT INTO guxg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","li yaa po, Pilata den guani ki ñano ku niwuligu kani ki yedi ba yi laa n baa guani yi nilo yeni yi baa bandi ke mii la ke o, pia tagili ba kuli. ");
INSERT INTO guxg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesu den cua bi kani ki yili i konkoni fogiliga ki go la ku gaali moangu, Pilata den yedi ba noanli mani o joa nna ” ");
INSERT INTO guxg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","bi salayidka cianba yu danba yeni Aminteela yudanba n den la Jesu bi den tiani kpaa ki tabino lidapoanpoanli kpaa ki tabino li da poanpoanli po kelima mini wan ki la wan tieni yaa biidi yaala n pundi ban cuo o. ");
INSERT INTO guxg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jufinba den guani ki yedi o, tin wai pia li bali maama ye ma laa balimaama mo yaa po, ki li bili li pundi wan kpe, kelimao yedi ke o tie UTienu bijua. ");
INSERT INTO guxg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilata n den gbadi lan bonla ku je jiegu den pugini. ");
INSERT INTO guxg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","o den guani ki kua u bujia kaakaanu kani, li yoginu Jesu naa den ŋmiano maama ba kuli. ");
INSERT INTO guxg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","lane kei Pilata guani ki bualo a kan ŋmiani nni li ba bii? ŋaa bani ke n pia yaa bali ki fidi ki gaa ŋa bi ki teni ban kpa ki tabina? ");
INSERT INTO guxg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ki Jesu den guani ki ŋmiano ŋaa pia bali ba n po li yaa den tie ke li cabi tanpoli po. li tie lani yaa po yo ke yua n cuo nni ki tena tieni ti tuonbiadi gi cie ŋa. ");
INSERT INTO guxg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","wan den guani ki ŋmiano laa maama po, Pilata den kpaani wan ŋa o, ama Jufinba den tiani tiani ki yedi o, li yaa tie ke ŋa onilo na ŋaa tie Sesa doanli” ");
INSERT INTO guxg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pila n den gbadi laa maama o den ñani Jesu niin po u bujakaanu kani ki kali o kpali po ban yii yaa kaanu Pave, ama Ebilu nni bi yi u Gabata ");
INSERT INTO guxg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","li den tie ya daali ki bi baa bogini mi faabima jaanma daali, ki bua ki pundi kudi piiiga yoginu Pilata den yediba diidi mani yi bado yeni ” ");
INSERT INTO guxg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ki bi tiani hali foagima foagima, kpaa ki tabino, Pilata den yedi ba: yinba yi ba n kpaa ki tabi yi bado? bi kopadicianba canbaan ba den guani ki ŋmiano tinba wani naa pia badi tiano se Sesa yaa ka ");
INSERT INTO guxg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","lanwani Pilata den cabiba ke ban ban kpaa ki tabino li dapoanpoanli po. ");
INSERT INTO guxg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","lane ki bi taa Jesu ki ñano cancanli ki bugino li dapoanpoanli ki teli ban yi naani (crame) Ebilu maama nni ki yi goligota. ");
INSERT INTO guxg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","bi den kpaa ki tabino lidapoanpoanli po, yeni nibilie yendo o jienu o tiano mo o ganu po. ");
INSERT INTO guxg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilata mo den diani idiani ki tabini li dapoanpoanli po ki yedi one n tie Nasaledi, jsu Jufinba bado. ");
INSERT INTO guxg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","yaa Jufinba n den pendi ki cogi idiani yeni bi den yabi kelima ban den kpaa ki tabini jesu lidapoanpoanli po naankani ki den foagi yeni udogu nni, bi den diani li diani Ebilu, Laten, yeni Gileki. ");
INSERT INTO guxg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","bi kopadicianba yudanba yeni Jufinba den yedi Pilata, da diani ki jufinba bado ka ama ŋan diani o den yedi mini n tie jufinba bado. ");
INSERT INTO guxg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","pilata den guani ki ŋmiani ba mini n diani yaala n diani lane. ");
INSERT INTO guxg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aminteela n den kpaa ki tabini Jesu lidapoanpoanli po, bi den ta o tiadi ki boagidi kaani na, ke toatielo kuli ga kaan yendu, yeni o gaaligu yaagu n tie cabiyenli ki lugi yeni igaali otanpolo yeni gu tinga kuli. ");
INSERT INTO guxg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","li ŋamu po Aminteela den yedi bi lieba tin da padigu ama tin toa tiatia ki bandi yua n baa di. li kuli tieni ki baa gbieni yi diani n den maadi yaala kuli, bi boagidi n tiadi bi ŋmiali nni ki toani tiatia nliadiciangu po. ");
INSERT INTO guxg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bi toatieba den tini lan bonla kuli, Jesu na Maliyama yeni o naa waali kilopa yua nden tie pua Maliyama yeni Magidala yua maliyama laa puoba den se Jesu dapoanpoanli kani. ");
INSERT INTO guxg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","yaa yoginu ke Jesu den la ona yeni wan bua yaa ŋoadika ke o, se yeno o den yedi opua na noanli abijua nna. ");
INSERT INTO guxg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","o den yedi oŋoadika yeni noanli anaa, li yoginu o ŋoadika yeni den ta ki kuno o denpo. ");
INSERT INTO guxg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","li puoli po jesu den bandi ki libonla kuli tieni ki dudi moala nani idiani n den yedi yaala Jesu den yedi ba n bua ki ñu. ");
INSERT INTO guxg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","o ñin bogu den se ki gbie yeni mi ñinmiligima ki nagi li kani bi den ta ucietuogu tuuni ku lanba foagidigu ki ñua min ñinmiligima nni ki duoni o ñoabu kani ke wan ñu. ");
INSERT INTO guxg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","jesu n den leni mi ñinmiligima o den yedi li gbeni o den tibini o yuli ki cabi o naano ki kpe. ");
INSERT INTO guxg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","li den tie li bogidili daali ki baa fandi mi fuodima daali ki Jufinba ki den bua ki bi tinkpiba n yaa kpaa ki taabi adapoanpoana po mi fuodima daali yaala n moani bi po, jufinba den gedi ki ban mia Pilata ke ban kuakua ban kpaa ki tabini yaaba adapoanpoana po taana ki ban kpe ban jiini bi gbanandi. ");
INSERT INTO guxg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A minteela den cua ki pua ki koani cincili yua, taana ki tuani o lielo mo yaa taana bani yaaba nden kpaa ki taani yeni Jesu ");
INSERT INTO guxg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ban den pundi jesu kani bi den sua ke o kpe ki li waagi baa den koani o yaa taana. ");
INSERT INTO guxg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","li yoginu minteeli yendo den coagi jesu logili li kpaanli mi soama yeni mi ñima den ñana li kani. ");
INSERT INTO guxg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","yua n den la yeni n wangi sieda o sieda yeni tie moamoani ki ban fidi ki mo daano. ");
INSERT INTO guxg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","lan bonla kuli den cua ki diani n den yedi yaala kuli n tieni ki dudi o kpabili ba yenli kan kua. ");
INSERT INTO guxg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","idiani tiami go yedi bi baa la ban den mu yua yaa logili. ");
INSERT INTO guxg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","lan bonla kuli n den pendi Josefi yua n den tie Alimate dogu nilo ki tie Jesu ŋoadika ŋa siili nni ama ki nan jie jufinba den gedi ki mia Pilata wan punba ban taa Jesu gbanandi Pilata den cabo Josefi den cua ki ta o gbanandi. ");
INSERT INTO guxg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodema yua n den cua Jesu kani ku ñiagu mo den cua Josefi kani ki kubi mili tulale badiga ki li ŋmadi yeni Alowe ki li kpiagu baa yaa tie nani kobiga. ");
INSERT INTO guxg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ban den ta Jesu gbanandi ki yieno mi kuuma tiadi ki ŋanbi ki fino nani Jufinba bogida n den buali maama bi ku piili po. ");
INSERT INTO guxg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ban den kpaa ki tabino naani ku gogidigu den kuu li kani li gogidigu den pia li ka kuli yaali n daa piini kpiemo. ");
INSERT INTO guxg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","kelma lan de tie jufinba bogidili daali ki li ka kuonli mo den koabi li kani bi denta bi den ta Jesu ki duano lien nni. ");
INSERT INTO guxg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Laadi o dacincinli daali o siŋapanpangu ki sua ki li da biigi, Maliyama Makidala yua den gedi li kakuli po, bi den la ki li tanli biid li kakuli ñɔbu kani. ");
INSERT INTO guxg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yeni ke bi san ki gedi Simɔ piali po yeni ya ŋɔdika ki jesu buo'o yeni, o den yediba: “bi ñani ti yonbidaano li kuli nni, ti bani ban bil'o naani. ");
INSERT INTO guxg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piali yeni o ŋɔdika lielo den ñani ki gedi li kakuli po. ");
INSERT INTO guxg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bi kuli den taani ki sani, ama ko ŋɔdika lielo den siani ki cie Pial ke kpia ki9 pundi li kakuli kani. ");
INSERT INTO guxg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O den guani ki diidi lien nni, o den la kadinga ki li bili tingin, ama waa den kua lien nni. ");
INSERT INTO guxg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔ piali den yuandi ki cua o puoli, o den kua li kakulin nni. ko la kadinga ki li bili tii po. ");
INSERT INTO guxg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yeni ya cabili n den fini o yuli, laa ya cabili ki den ta yeni kadinga ama li den pɔbi ki bili kaan tianu. ");
INSERT INTO guxg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yeni ko ŋɔdika lielo mɔ den kua, wan yua n den kpia ki pundi li kakuli kani. O den la ki daan. ");
INSERT INTO guxg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kelima hali yeni ti ye ya yoginu baa den ba ki bandi i diani n yedi yaali jesu po ko ba fii bi tikpiiba siigin. ");
INSERT INTO guxg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bi ŋɔdikaaba den guani bi diedi po. ");
INSERT INTO guxg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lan ya yoginu, Maliyama se niin ni li kakuli kani ki buudi; wan den buudi ya yoginu, o den tibini ki diidi li kakulin nni. ");
INSERT INTO guxg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ko la Meleki bonbilie ke bi la ti tiapiendi ki ka, yendo li yuli po o lielo m ɔ a taana po naani ki jesu gbannandi den dua. ");
INSERT INTO guxg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bi den yedo: “o pua, bee ntieni ka buudi i?” Ko ŋmian'ba: “kelima bi ñani bi yonbidaano, mii bani ban bilo naani. ");
INSERT INTO guxg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wan den yedi la ya bonla, ko ŋmagidi ki la jesu ko se li kani, ama waa den bani ki li tie jesu. ");
INSERT INTO guxg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu den yedo: “o pua be cedi ka buudi? a kpaani be? “O den mali ki li tie o gogidigu daano, lani ko yedo: “canba li ya tie ki fini n ta'o, wan nni naani ka duan'o min gedi ki tug'o.” ");
INSERT INTO guxg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu ŋmian'o: “maliyama “ko ŋmagidi ki maad'o Eblu maama nni ki yedi: “Adabbuni” li niinmin tie “canba” ");
INSERT INTO guxg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu maadi: “da si nni kelima n da ki doni n ba po, ama gedi n ninjaba po ki ban yedi'ba ke n ba do ki gedi n ba po yeni yua n tie yi mɔ ya ba. N baa leni imɔ ya baa. ");
INSERT INTO guxg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magidala Maliyama den cua ki waani ko la o yonbidaan, ki wani nyedo la ya lanbona. ");
INSERT INTO guxg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Li daali yenjuogu i, li daacincinli laado nni, ya yoginu ka buliñɔna kuli den luo bi ŋɔdikaaba n den ye naani kani kelima bi den jie jufinba, jesu den cua ki sedi bi siigan nni ki yedi'ba: “mi yanduanma n ya ye yeni” ");
INSERT INTO guxg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","wan den yedi laa bonla, o den waani ba o niiyeni ologili yaa yoginu ke o ŋɔdikaaba den la ti yonbidaano bi pala den mangi. ");
INSERT INTO guxg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesu go den yediba: “mi yanduanma n yaa ye yeni yi, nani n Ba n sɔni yeni n moko suani yeni. ");
INSERT INTO guxg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesu n maadi ba ki gbeni kwe o piebi po ki maadi ba, gaali mani fuoŋanma. ");
INSERT INTO guxg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","yaa daano kuli ki baa di sugili o biidi po o biidi ba biini, yaa daano mo ke kan di sugili o biidi po biidi mo kan piini. ");
INSERT INTO guxg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ke Jesu go pugini ki maadi “ke mi yanduanma n yaa ye yeni yi, nani nBa n sɔni nni n moko suani yene.” ");
INSERT INTO guxg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jesu n maadi ki gbeni, kee o piebi bi po kimaadiba gaali mani fuoŋanma, yaa daano ke yi baa di sugili o biidi po o biidi baa piini ya daano mo ke kan di sugili o biidi po o biidi mo kan piini. ");
INSERT INTO guxg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","dana nii puoli po oŋɔdikaaba den ye deni nni ke Toma ye yeni ba: li yoginu ke agana kuli lo, ke Jesu ba ki sedi bi siiga nni ki maadi: “mi yanduanma n yaa ye yeni yi.” ");
INSERT INTO guxg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ki pugini ki maadi Toma nagini yeni a nubili, ki diidi n nii, ki nagini yeni anubili ki sii n logili, da tami nnpo ya daani nni.” ");
INSERT INTO guxg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma den ŋmiano ki maadi: “n yonbidaano tie n Tienu”. ");
INSERT INTO guxg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ke Jesu maado kelima alaa nni ki daani nni, li pamanli ye yeni yaaba daani kki laa nni. ");
INSERT INTO guxg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ke Jesu go tieni mi banma boncianla oŋɔdikaaba siiga yaa banma n ki diani yaa tili ne niini nni. ");
INSERT INTO guxg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ama li bona den diani ke yin fidi ki tuo ke Jesu tie Kilisiti, UTienu Bijua, yeni yi daani yi baa pia li miali o yaa yeli po. ");
INSERT INTO guxg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lani ń pendi, Jesu go legdi ki waani o bá o ŋɔdkaaba Tiberiyad mɔgli kunga. Wan den waani o bá maama n ne. ");
INSERT INTO guxg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siimɔn Pieri, Toma, ban yi yua Didim Natanayel, Galile nni Kaana yua, Sebede bijaba yeni Jesu ŋɔdkaaba bilie den taani ki ye ");
INSERT INTO guxg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Siimɔn Pieri ń maadi ba: “N ba gedi u jankpaanu.” Ban yedi o: “Ti mo ba yegi yeni a ki gedi.” Ban ñ ki kua ku ŋadgu. Li daali, ñiamungu baa cuo pu. ");
INSERT INTO guxg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lan fandi, ke Jesu ye gbangbanli li jaali po; ama ke bi ŋɔdkaaba ki bani ke li tie wani Jesu i. ");
INSERT INTO guxg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesu ń maadi ba: «A bila, i ki pia bonjekaali i? Ban jiini o: “n n “ ");
INSERT INTO guxg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wan maadi ba: «Lu mani i taalu ku ŋadgu jienu po, i ba cuo.» Ban lu nani wan maadi maama, ki ji gbali mi dadima, kelima i jami den yabdi. ");
INSERT INTO guxg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesu ń den ŋanbi ki bua ya ŋɔdkaa ń maadi Pieri: O Diedo i! Siimɔn Pieri ń bandi ke li tie O Diedo, wan la o liadli, ki ñagni gbanñagdigu, kelima o den ye benbili i. ki baa mi ñima nni ");
INSERT INTO guxg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ya ŋɔdkaaba n sieni ń nagni yeni ku ŋadgu, ki dadi u taalu ke u gbie yeni i jami, kelima bani yeni li gbangbanli ji den tie nani nuukpanduna kobilie yeni. ");
INSERT INTO guxg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ban ñani ki doni gbangbanli, ke bi la ke a mukuana co, ke i jami ye o mu nni yeni kpanu. ");
INSERT INTO guxg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu ń yedi ba: «Cua mani yeni yin cuo ya jami waamu na ");
INSERT INTO guxg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Siimɔn Pieri ń kua ku ŋadgu nni, ki dadi ki duoni u taalu gbangbanli ke u gbie yeni kobga n piimu n jangbenga taa. Bá yeni i jami ń yabi maama kuli, u taalu naa den padi. ");
INSERT INTO guxg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesu ń maadi ba: «Cua mani, ya di mani» Bá ŋɔdkaayendo ki paani o pali ki buali: “A tie ŋma i? “Ki nan bani ke li tie O Diedo i. ");
INSERT INTO guxg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesu ń nagni, ki taa kpanu, ki teni ba; ki go teni ba i jami mo. ");
INSERT INTO guxg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Li ji den tie mi taama n yeni, ke Jesu dɔgdi o ŋɔdkaaba kani, ki waani o bá hali wan yiedi bi tinkpiba siiga. ");
INSERT INTO guxg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ban dini ki gbeni, Jesu ń buali Siimɔn Pieri: «Jonaas bijua Siimɔn, a bua nni ki cie bi ne i? Wan jiini o: “Nn n Diedo, a bani ke n bua ŋa. “Jesu ń yedi o: «Ya kpaa n pebidi.» ");
INSERT INTO guxg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wan go yedi o mi liema: Jonaas bijua Siimɔn, a bua nni i? Pieri ń go jiini o: “Nn n Diedo, a bani ke n bua ŋa.” Jesu ń yedi o: «Ya kpaa n pañoe.» ");
INSERT INTO guxg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wan go buali o mi taama: Jonaas bijua Siimɔn, a bua nni i? Lan biidi Pieri pali yeni wan buali o taalma taa: “Abua nni i? Wan jiini o: “N Diedo, a bani bonli kuli, a bani ke n bua ŋa. Jesu ń yedi o: «Ya kpaa n pañoe,» ");
INSERT INTO guxg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","«N maadi a i mɔmɔni, ŋan dá den tie naaciemo, a den yen ñagni a bá, u gbanñagdu, ki gedi ŋan bua naani. A ya ti ciandi, a ba ti tandi a nui, nitiano ń ñagni a, ki gedi yeni a, ŋan ki bua ke a gedi naani.» ");
INSERT INTO guxg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu den maadi lani, ki bua wan waani Pieri ń ba ti kpe ya kuubuolu i, ki kpiagi U Tienu. Wan maadi yeni ki gbeni, ke o yedi o: «Ya ŋua nni,» ");
INSERT INTO guxg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pieri ń gbagi, ki sua ke Jesu ń bua ya ŋɔdkaa yeni, mi yenjojiema di yogu, yua n den kpagni ki buali Jesu: “ŋma ba (kuadi) janbi a?” yeni ke o ŋua ba; ");
INSERT INTO guxg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wan la o, wan buali Jesu: “N Diedo, one mo te, o ba juodi ledi i?” ");
INSERT INTO guxg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu ń yedi o: «N ya bua wan ya ye hali mi ba guani, li nan la ŋa le? Fini ń ya ŋua nni. ");
INSERT INTO guxg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lanyapo, laabaali den yadi li naataanli nni ke lanya ŋɔdkaa wani kan kpe. Ama Jesu den ki maadi ke o kan kpe ka; ama: “N ya bua wan ya ye hali mi ba guani te, li la ŋa le i? ");
INSERT INTO guxg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Lan ya ŋɔdkaa n tie kasiedi ki wangi yi li bona po ne, o diani li bona. Ti bani ke o kasiedi tie mɔmɔni, ");
INSERT INTO guxg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesu go tieni bontɔla boncianla. Li ya bi tie ke ti ba diani likuli, n ki tama ke ŋanduna kuli ba dagdi ki ga lan ya diani kuli. ");
INSERT INTO guxg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofili li cincintili yua ke diani maadi yesu n cindi ki tieni yeni wan tundi yaala; ");
INSERT INTO guxg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hali yeni ya daali k o bo doni poli pon ");
INSERT INTO guxg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Li puoli po yo k o bo teni wan bo lugidi yaaba a tuonsɔnba k o bo legidi bi nungi po o fala puolo po fuoŋanba paalu. Dana piina o tundi legidi bi nungi nni ki maadi u Tienu diema maama. ");
INSERT INTO guxg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","B den ya cendi liebi o den yi yedi'b ki ban da fagidi yeni Jerusalemi ama ki nan da guudi bàa puoni u, nani wan bo maadi «i gbadi n maama ke» ");
INSERT INTO guxg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","San bo wuuli hali yeni dinne yeni mi ñinma i ama yinba ba ti wuli yeni fuoŋanba li dana kan fagidi» ");
INSERT INTO guxg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ban bo taani ya yogu ke bi bual'o: «badiciamo li yognu i ke a ba sieni Israheli diema aa?» ");
INSERT INTO guxg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","K o maadi'bi «laa tie yin'bi ka bi bandi li yogu bii li tinbuali yua ke u Tienu bàa cuo yeni u paaceli. ");
INSERT INTO guxg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama i ba gaà u paaciamu ya yogu ke fuonŋanma ti ba cua yim n ba tua mini yeni Jerusalemi sieda siedanba, Jude yeni sanmaali kuli dogu nni yeni ki tinga n pan juodi naankani kuli. ");
INSERT INTO guxg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yagu ke Jesu bo maadi'bi li bona kuli ki gbeni nani wan bo nua tanpoli yeni, k o doni k u tawaligbangu baa ki legini bi nunbina. ");
INSERT INTO guxg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ban go bo da nua tanpoli ya yogu, ki nibilie nagini bi kani ki lani tiapiena. ");
INSERT INTO guxg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bi bo maadi: «Yimi galile yaaba be cedi ki se lan kani ki nua tanpoli» ");
INSERT INTO guxg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lani ki bi bo guani Jerusalemi Olife juali po yua kɔbi yeni Jerusalemi nani ban cuoni ya banli Sabbat daali. ");
INSERT INTO guxg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ban bo pundi ke bi doni gu dietuagu po, ban bo tundi ki ye naani. li bo tie Piaali, San, Saaki, Andili, Filipi, Tuoma, Baatelemi, Maatio, Saaki Alife bijua, Siimo o jakagidiga, yeni Jude Saaki bijua. ");
INSERT INTO guxg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","B bo taani tie nani nuyendo yeni ki taani jaani, yeni bi puobi, Maali Jesu naà yeni o waali. ");
INSERT INTO guxg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Li dani k Piaali bo fii o naataani siiga nni, bi bo tie nani 120, maadi. ");
INSERT INTO guxg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","N naataani li bo tie buama yaali k u Tienu maama n tieni ki tii, nani fuoŋanma n bo yedi Daavidi ñɔba nni Juda po, yua bo waani jesu ke b cuo, o. ");
INSERT INTO guxg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kelima o bo tie ti yua ke go bo baadi ti ñuadi li yaalidugu po. ");
INSERT INTO guxg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Dinne li nulo daa u kuanu yeni obiadma paadi, lan kani k o jiidi baa ke li yuli liidi, k o gbanandi yodi k o tugu nni bona kuli yadi. ");
INSERT INTO guxg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalemi niba kuli bo ŋanbi bani li bonli ke b ji puni li kuanu li yeli bi danba maama nni “Hakeldama”, li niima n tie mi sɔma kuanu. ");
INSERT INTO guxg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Lan cedi ki li diani pisoma tila nni,”ŋaa mani k o kuanu n kpandi pabɔnli ke nulo n daa kua li kani. ke nutiani n gaa u yudandi sienu. ");
INSERT INTO guxg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Li tie buami yaali ke bi niba yaabi bo ciani ti o badiciamo Jesu n bo ye ya yoguti siiga nni ");
INSERT INTO guxg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Lan cili San ñinwulima ya caa ya daali k o bo ñani ti siiga nni yaabi bo tua siedanba o yiedima po yeni timi. ");
INSERT INTO guxg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ke bi tieni nibalie liiga, Josefi ke yi'o Barsabas, k go yi'o Justus yeni Maatiasi. ");
INSERT INTO guxg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","24 B bo jaandi ki maadi «fini o badiciamo yua bani yua kuli yantugu ŋan waani ti nibalie ne ŋan lugidi yua. ");
INSERT INTO guxg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ke wan gaa li yiali u yaalidigu yeni u tienu tuonli ke Juda kan cɔlini ki nan ŋɔdi u sancelu. ");
INSERT INTO guxg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ke bi tɔni tia tia ki lugidi Maatiasi k b ji bo cɔd'o ki pugni tuonsɔnba piigi n yendi yeni po. ");
INSERT INTO guxg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pantekoti daali ń pundi, bi kuli dentaani ki kaanyendu i. ");
INSERT INTO guxg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bi ti ludi ki gbadi ke fuugu ñani tanpoli ki nani faaciangu yeni, ki gbie ban bi ye ya dieli nni yeni kuli. ");
INSERT INTO guxg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ban la ke i landi tie nani mu yeni ki dɔgdi bi po, ki bɔgdi bɔgdi ki maani yuakuli po. ");
INSERT INTO guxg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bikuli ń gbie yeni mi foŋanma, ki ji cili ki ya maadi mi maalanma nani foŋanma ń puni ba ke ban maadi maama. ");
INSERT INTO guxg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Layognu, Juufinba yaaba daani U Tienu nni den ñani ŋanduna dogi nni kuli, ki cua ki dá ye Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ban gbadi ku fuugu, ban taani ki sani ki cua, lan lidi ba yeni yuakuli ń gbia ke bi maadi o danba maama nni. ");
INSERT INTO guxg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bi den ye ku yaalidgu yeni li pamancianli nni; bi den maadi: “Ti ya ba maadi i mɔni, bani yaaba n maadi ne kuli ki tie Galile yaaba ka aa? ");
INSERT INTO guxg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Li nan tieni ledi i, ke ti gbia bi maama yuakuli danba maama nni? ");
INSERT INTO guxg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Persi yaaba, Medesi yaaba yeni Elamiti yaaba yeni yaaba n kua Mesopotami, Jude diema nni, yeni Kapadɔsi, Pɔn yeni Asi, ");
INSERT INTO guxg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Friji yeni Panfili, Ejipti nni yeni Libi dogi yia n ye Sireni po, yeni ya canba n ñani Roma ki cua, ");
INSERT INTO guxg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Juufinba yeni Proselitinba, Kretan yeni Arabi yaaba, ti den gbia ke bi maadi ti danba maama nni U Tienu paaciamu tuonli” ");
INSERT INTO guxg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bi den ye li pamancianli nni kaa bani ban ba tieni yaali kuli; bi den maadi bi ŋmiali nni: “Ne mo ya niima nni nan ji tie be i?” ");
INSERT INTO guxg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ama bi tianba den ñuadi ba ki maadi, “Bikuli ñuni mi daamɔnpaanma i ke li ga ba.” ");
INSERT INTO guxg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ama Pieri den fii wani yeni li piiga n yendo, ki duoni u nialu, ki yedi ba, “Jude niba yeni yinba yaaba n kua Jrusalema nni, li ŋani yin bandi yaali ne yin ŋanbi ki cengi n lanbona. ");
INSERT INTO guxg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kelima, ya niba ne ki ñuni daama ki guo nani yin maali maama ka, kelima ti dá ye siŋaagu, kudi taa yognu i. ");
INSERT INTO guxg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Li tie o sawalpualo Joweli ń den waani ya maama i: ");
INSERT INTO guxg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ A daajuodidana ya pundi,” U Tienu ń yedi yaali n ne, “N ba yadi n foŋanma gbannandi kuli po. I bijaba yeni i bisiaba ba tua sawapuaba, i naacenba yeni i jifanba ba la mi dɔgdima, i nikpelba ń ya laadi a bona ti dangdi nni. ");
INSERT INTO guxg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Li baa tie yeni i, n tuonsɔnba, bi puoba yeni bi jaba po li dana nni N ba yadi n foŋanma bi po, ban ya pua sawali. ");
INSERT INTO guxg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","N ba cedi yaalidgu bona ń tieni tanpoli po, ki tieni li pagli maalma ki tinga po, mi sɔma, u mu yeni i muñii walgu. ");
INSERT INTO guxg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","u yienu ba kpandi bɔnbɔnli, o ŋmaalo ń kpandi sɔma ki sua ya daacianli ke i ba la ki bandi O Diedo guanma pundi. ");
INSERT INTO guxg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Li ba tieni ke yua n jaandi U Tienu O Diedo yeli po ba baa mi faabma. ");
INSERT INTO guxg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israyeli yaaba, cengi mani ya lanbona ne: Nasareti Jesu, U Tienu ń tieni yua ya po kasiedi i kuli ya nunbu nni yaali n nua o yaalidgu tuonŋama, U Tienu ń cedi ke o tieni ya bancianma yeni ya maalma ke ikuli bani, ");
INSERT INTO guxg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nani U tienu ń bobni maama, ke li ŋua o bancianma, bi kuadi o, ki cuo o ki mubni yaaba n fali yiko nui nni, ke bi kpaa o li daapɔnpɔnli po, ki kpa o. ");
INSERT INTO guxg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","U Tienu yiedi o, ki faabi o yeni mi kuuma fala, kelima, li bo ki buali ke wan ya ye mi kuuma nuu nni. ");
INSERT INTO guxg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kelima Dafidi yedi yaali ne o po: “N den tundi ki nua O Diedo ke o ye n liiga, kelima o ye n nuujienu po ke mii ji pia begma. ");
INSERT INTO guxg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lanwani ii, n ye li pamancianli nni, ki mangidi n pali yeni n lanbu. Yaali n pugdi, n gbannandi baa ye li dandanli nni. ");
INSERT INTO guxg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kelima a kan ñɔli ki ŋa n naano bi kpienba diema nni, a go kan ŋa a niŋamo gbannandi ń bedi. ");
INSERT INTO guxg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A dɔgdi li mi yema sani, ki waani nni, a ba cedi min gbie yeni a yema. ");
INSERT INTO guxg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","N kpiiba, n ba maadi yeni yi li dandanli nni ti yaaja Dafiidi maama: o den kpe, ke bi pii o, ke o kakuli ye ti siiga nni hali yeni mɔlane. ");
INSERT INTO guxg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nani wan den tie sawalpualo, ki bani ke U Tienu bo loli yni o ku dɔnligu, ki niani o ke o ba cedi o puoliŋuani nni, yendo ń kali o badigbandi po yeni. ");
INSERT INTO guxg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","o bo tuodi ki bandi, ki maadi Jesu yiedma po, “Bi den ki ñɔli ki ŋa o bi kpienba tinga nni, ke o gbannandi mo ki bandi bedma. ");
INSERT INTO guxg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Lan ya Jesu, U Tienu duoni o yeli, tikuli tie li kesiedinba. ");
INSERT INTO guxg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ama, nani wan doni, ki kali U Tienu jienu yeni, o baa Báa ń den niani o ya foŋanma, o yadi lan ya foŋanma i ti po ke i la ki go gbadi ne. ");
INSERT INTO guxg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kelima, Dafiidi naa den doni tanpoli, ama, o den maadi, “O Diedo yedi N Diedo, «Kali n jienu, ");
INSERT INTO guxg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hali min ba cedi a yibalinba ń tua taaŋmaakaanu» ");
INSERT INTO guxg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Lanyapo i, ke li buali ke Israyeli diegu kuli ń bandi yeni i mɔni ke yin kpaa ya Jesu li daapɔnpɔnli po yeni, U Tienu cedi ke o tua Diedo yeni Kiristi» ");
INSERT INTO guxg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ban gbadi lanya maama, ki mi sia bi pala, ke bi buali Pieri yeni ya tondba n sieni, “Ti kpiiba, ti ji ba tieni ledi i?” ");
INSERT INTO guxg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ke Pieri guani ki jiini ba, “Yuakuli ń biidi o pali o tuonbiadi po, ki tieni mi ñinwulma bogdili Jesu Kiristi yeli po, ke wan di sugli o biidi po, i ba baa U Tienu Foŋanma paabu, ");
INSERT INTO guxg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kelima li nɔnianu tie yinba yeni i bila yaama i yeni yaaba n ye fagma, hali ban yabi maama kuli, ke U Tienu ba yini.” ");
INSERT INTO guxg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","O den maadi mi maama boncianla, ki kadi ki waani ba, ki paani bi pala; O den maadi ne, “Yin fangi j yula yeni ya nifiima n kua mi tudma nni ne. ");
INSERT INTO guxg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lanwani ii, bi den tuo ki ga o maama, ke bi tieni ba mi ñinwulma bogdili, ke li daali mɔno, yaaba n den pugni bi ŋɔdkaaba po den kiluo niba tuda taa (3000). ");
INSERT INTO guxg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bi den tugni bi tuona ki tundi yaali n tie mi yenŋɔdma, ki bɔgdi kpanu bi ŋmiali nni, ki tie bi jaandi. ");
INSERT INTO guxg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ti jawaandi ń cuo naano kuli, ku yaalidgu yeni mi bancianma maalma boncianla ń tieni bi ŋɔdkaaba dandanli po. ");
INSERT INTO guxg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yaaba n den tie dugkaaba kuli den taani ki ye kaanyendu, ke ban den pia yaali kuli den tie tantaanbona i. ");
INSERT INTO guxg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bi den kuadi bi piama yeni bi bonkubkaali ki bɔgi bi ŋmiali nni, yuakuli yeni wan dagdi yeni yaali. ");
INSERT INTO guxg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Li den tie yeni i daali ń tuu daali bi den ye li jaandieli nni, ki taa payianyendu, ki ŋmiidi kpanu, ki bɔgi bi ŋmiali nni, ki taandi ki di yeni li pamanli yeni li pali yumiinli, ");
INSERT INTO guxg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bi den pugu U Tienu, ke bi niba taa bi po, ki selni ba. Daali ń tuu daali, O Diedo den pugdi bi po yaaba n den baa mi faabma. ");
INSERT INTO guxg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yeni ke Pieri yen i Jan den caa ku jaandiegu nni, i jaandi yogu, nani kudi yia yogu yeni ");
INSERT INTO guxg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bi den yi maani ki tugi nilo, ke bi mali o ke o tie wabo ki caa ki kaandi o ku jaandiegu bulñɔcianbu, ban yi yaabu bu bulñɔŋanbu yeni kani, ke o miadi yaaba n pendi ki kua ku jaandiegu nni. ");
INSERT INTO guxg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wan la Pieri yeni Jan ke bi pendi ki kua ku jaandiegu nni, ke o mia ba li todli ");
INSERT INTO guxg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pieri ń sedi ki nuali o tiii, wani yeni Jan, ki yedi o: «Diidi ti». ");
INSERT INTO guxg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","O wabo ń nuali ba, ki ya daani ke o ba baa paabu bi kani i. ");
INSERT INTO guxg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pieri ń maadi: «N ki pia wula ki buali ligi, ama min pia yaali, n ba teni a. Nasleti Jesu Kiristi yeli po, cuoni!» ");
INSERT INTO guxg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pieri ń cuo o nuujienu, ki yogi ki fiini o, lannyognu mɔno, o taana ń todi, o taagbina ń paagi. ");
INSERT INTO guxg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yugyenma, o wabo ń fii, ki ya cuoni, ki kua ku jaandiegu nni, wani yeni Pieri yeni Jan, ke o cuoni, ki yugi, ki dondi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bi niba kuli ń la o ke o cuoni ki dondi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ban bandi ke li tie ya nilo n yi miadi ku jaandiegu bulñɔŋanbu kani yeni i; ku yaalidgu yeni li pamancianli ń cuo ba yeni yaali n tieni o ne. ");
INSERT INTO guxg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nani wanden li ye yeni Pieri yeni Jan yeni ii, bi niba kuli den sani ki nagni ba Salomɔn ciagu nni yeni li li pamancianli ");
INSERT INTO guxg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pieri ń la kunilgu, wan buali ba: «Isarayeli niba, be n cedi ke i pala mani boncianla? Be n cedi ke i cini i nuni ti po nani tinba mɔno ya paalu bii ti papienli po i, ke o nilo ne cuoni yeni ii? ");
INSERT INTO guxg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahama, Isaka T yeni Jakobo Tienu, ti yaajanba Tienu n kpiagi o tuonsɔnlo Jesu yeli, yin den nia ke yii bani yua Pilati nintuali, wan den jagi ke wan faabi o ya yognu yeni. ");
INSERT INTO guxg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","I den yie o niŋamo yua n tie niteginka maama, ki cedi ke bi luodi ki ŋa o nikpalo. ");
INSERT INTO guxg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I cedike bi kpaá li miali naabiiga, U Tienu ń yiedi (faadi) yua bi kpienba siiga ke tinba n tie li kasiedinba. ");
INSERT INTO guxg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mɔlane, yaaba n daani o yeli po - yin nua ya nilo, ki go bani o ne - lanya yeli n paagi o. Wan pia ya dandanli Jesu nni n cedi ke o paagi cain ikuli ya nunbu nni. ");
INSERT INTO guxg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","N kpiiba, n bani ke yii bani i, ki sɔni yanbɔntuonli i nani i yikodanba yeni. ");
INSERT INTO guxg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ama, U Tienu ń cedi ke o sawalpuaba kuli pua ya sawali, ke li buali ke o wan lugdi ya bibuadga ń la fala yeni, tieni ki tii. ");
INSERT INTO guxg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lanwani ii, yin biidi i pala i tuonbiadi po, ki lebdi ki ŋɔdi u sanŋamu, i biidi ń piini, ti Diedo yema ń cua yeni li pasɔngli jamaano; ");
INSERT INTO guxg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","wan yuandi ki sɔni wan lugdi ya Kiristi i po, Jesu. ");
INSERT INTO guxg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","O tie yua ke tanpojoma ba ga hali yeni ya yogu ke U Tienu ń tuodi ki cedi ke o sawalpuaŋanba yaadi ki waani ya bona kuli n ba tieni ki dudi. ");
INSERT INTO guxg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyiisi maadi lani n yeni: “O Diedo U Tienu lugdi ki dɔgdi sawalpualo nani mini yeni i kpiiba siiga. Yin cengi wan ba maadi yi yaali kuli. ");
INSERT INTO guxg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Li ya sua ke niloba ki cengi li sawalpualo maama, bi ba biani (bolini) o cain bi niba siiga.” ");
INSERT INTO guxg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nn, bi sawalpuaba kuli yaaba n pendi, ki maadi li maama, ki cili hali Samiali yeni yaaba n yuandi o puoli po kuli waani lanya dana. ");
INSERT INTO guxg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","I tie bi sawalpuaba yeni ya ñɔnianu ke U Tienu loli yeni ti yaajanba bila i, nani wan yedi Abrahama maama: “Ki tinga po dansani kuli ba baa mi yedŋanma a ya puolŋuani po.” ");
INSERT INTO guxg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","U Tienu ń duoni o tuonsɔnlo, o dá cindi ki sɔni o i siiga nni i, ke wan fidi ki yadi mi yedŋanma yaaba n ba lebdi bi yama, ki ŋa bi tuonbiadi sanu ki ŋɔdi u sanŋamu» ");
INSERT INTO guxg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pieri yeni jan n da den maadi yeni bi niba, bi kodipadicianba yeni, U Tienu diegu gudikaaba yudaano yeni sadisa yaaba den cua li kani. ");
INSERT INTO guxg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","B pala den beni kelima Pieri yeni Jan den bangi bi niba ki wangi ba ke bi tinkpiba baa fii kelima Jesu den fii bi tinkpiba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bi den cuo bad ki kuani ba li kpaadidieli nni hali ke li pan fandi kelima li den tie yenjuogu jigi. ");
INSERT INTO guxg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yeni moko, yaaba n den cengi bi maama siiga boncianla den daani Jesu, ke bi cɔli den bua pundi niba tudamuu(5000). ");
INSERT INTO guxg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lan den fandi, jufinba yudaano yeni a nikpela yeni li balmaama bangkaaba den taani Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bi kodipadicianba bado Ana yeni kayifa yeni Jan yeni Alesanda yeni yaaba n sieni ki tie bi kopadicianba yudaano kuli. ");
INSERT INTO guxg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bi den cedi ke Pieri yeni Jan sedi bi siiga, ke bi buali ba: «U laa paalu ya po, bi ŋme yeli nni ke i tieni yeni?» ");
INSERT INTO guxg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Lani U Tienu fuoma yua n gbieni pieri ke o den yedi ba: ");
INSERT INTO guxg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«yinba bi paatieba yeni isayele nikpela, i buali dinne ya tuonŋanli n tieni ya wabo ne po yeni lan gaa maama ke o paagi. ");
INSERT INTO guxg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","To, Yinba yaaba n ye kuli yeni Isayele yaaba yaaba n sieni kuli, yin bandi ke li tie Nasareti yua Jesu Krisiti yeli po, yin den jɔni yua li dapɔnpɔnli po, ke U Tienu ffini o bi tinkpiiba siiga, ke yaa ja n tie na paagi cain ki se i nutuali. ");
INSERT INTO guxg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesu tie: yaa tanli ke i den luni, ke nan tie tanmaala. Lani n tua li tanpuuli tanjali. ");
INSERT INTO guxg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mi faabma ki ye nitɔ kuli kani kelima yetɔli kuli ki ye ŋanduna nni tin baa faabi kelima yaali yapo taladi». ");
INSERT INTO guxg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bi cancannikpela yeni n den laa Pieri yeni Jan n pia yaa paapali, bi den pagi ba kelima bi banni ke bi tie taliginba kaa kua cogu. Bi den bandi ke bi tie yaaba n den ki ye yeni Jesu. ");
INSERT INTO guxg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ban den nua ke ya ja n paagi yeni se Pieri yeni Jan kani, baa den fidi ŋmiani ba libakuli. ");
INSERT INTO guxg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bi den cedi ke bi ñani bi cancannikpeliba taanli nni, ke bi juogi. Bi den yedi: ");
INSERT INTO guxg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ti baa tieni bi naa jaba lede? kelima Jerusalema yaaba kuli bani ke bi tieni mi bancianma, ti moko nan kan fidi ki nia. ");
INSERT INTO guxg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama ki fidi ke laa maama n daa yadi bi niba siiga, tin fuu yeni ba ki yie bipo ke ban da go maadi oba kuli laa yeli nni». ");
INSERT INTO guxg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lani, bi den gɔ ki yini ba ki yie bipo cain ke ban da gɔ maadi ki bangi bi niba Jesu yeli nni. ");
INSERT INTO guxg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pieri yeni Jan den gua ki yedi ba: «Biigi mani ki lie li ya tiegi U Tienu po ke tin tuo i ya maama ki cedi wani U Tienu yaama. ");
INSERT INTO guxg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kelima ti kan fidi ke kan yedi tin la ke go gbadi yaala». ");
INSERT INTO guxg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bi cancannikpeliba bia den funi yeni ba ki yuandi ki ŋa ba. Baa den laa ban baa cuo ba yaali yapo, kelima bi niba kuli den kpiagdi U Tienu kelima yaala n den tieni po. ");
INSERT INTO guxg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kelima ban den tieni ya ja po mi bancianma ke o paagi den kpeligi ki cie bina piinaa. ");
INSERT INTO guxg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pieri yeni Jan n den ñani, bi den gadi bi lieba po ki pan wani ba bi kopadicianba yudanba yeni bi nikpelba n yedi ba yaala kuli. ");
INSERT INTO guxg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ban den gbadi lani, bi den taani yanyenma ki jandi ki mia U Tienu ki yedi: «Ti Diedo, fini n den tagi tapoli, ki tinga, mi ñincianma yeni yaala n ye mi niinni kuli. ");
INSERT INTO guxg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","A den maadi ke U Tienu fuoma yua cedi ke ti yaja Dafidi a naaciemo sɔgni a maama ki yedi: «be n cedi ke bi nilanba fii ki tiendi o fuugu? ke i nibuoli mo pia laa yantiabiada? ");
INSERT INTO guxg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ki tinga badiba kuli fii ki sedi. Bi badijaba mo taani ki tuu ñɔyenbu ki fii ki sedi O Diedo yeni wan gandi yua po. ");
INSERT INTO guxg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mɔmɔni o bado Elodo gufeneri Ponisa Pilata den taani yanyenma yeni yaaba n kaa tie Isabele yaaba kuli u naa dogu nni ki juogi ban baa tieni maama ki cuo fini U Tieni ya nacengagdiŋamo Jesu, ŋan gandi yua. ");
INSERT INTO guxg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ban den taani yeni, bi den tieni ŋan tuodi ki bili yaala kelima a paciamu yeni a yanjagili po. ");
INSERT INTO guxg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mɔla o Diedo, cengi ban funi leni timaama, ki paagi tinba a naacenba tin yaa wangi a maama yeni li pamanli. ");
INSERT INTO guxg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tandi a nuu ke tin ya taagi a naacengagidiŋamo Jesu yeli ki paagdi bi niba sinankeeninba yeni mi bancianma». ");
INSERT INTO guxg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ban den jaandi yeni, ban taani naakani den digdi. Bi den gbie yeni u Tienu fuoma yua ki bi wangi U Tienu maama yeni li papaali. ");
INSERT INTO guxg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yaaba n den daani kuli den pia yenyenma yeni yanjagidiyenli. Oba kuli naa den yeni ke wan pia yaala tie wani baba n baa die yaala, nilo kuli den tuo ke o piama tua o lieba kuli yaala. ");
INSERT INTO guxg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesu tondibila den tieni siedi wani o Diedo Jesu fiima bi tinkpiba siiga po yeni u paaciamu. U Tieni sela mo den ye yeni bikuli. ");
INSERT INTO guxg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bii siiga luodo ki den ye kelima yaaba n den pia i kuani ki kpendinni li ligi ");
INSERT INTO guxg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ki biliti Jesu tondiba taana kani. Bi den yen ñandi lienni ki bɔgdi ki tendi yua kuli nani o luoma n tie maama. ");
INSERT INTO guxg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josefi, Jesu tondiba n den ciliyua yaa yeli Barnabasa, lani n tie yua pagidi bi niba pala. O den tie Lefiti buolu yua ki ñani Sipila diema nni. ");
INSERT INTO guxg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","O moko den pia u kuanu, ki kuadi ki cua yeni li ligi ki bili Jesu tondiba taana kani. ");
INSERT INTO guxg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ama niyendo, ban yi yua Ananiasa yeni den ye. Oja yeni den kuadi o kpaabu, ");
INSERT INTO guxg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ki juogi yeni o pua ki kubi i ligi bɔgdima. O den cua yeni yaala n sieni ki bili Jesu tondba taana kani. ");
INSERT INTO guxg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ama ke Piali madi: “be cedi ke a ŋa sitaan k o kua a pali ki gbie k a pan pua fuonŋanma faama i ki ŋuuni u kpaabu ligi bɔgdnma i? ");
INSERT INTO guxg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lan bo ki kuadi, li bo li ki tie a kpacelu kaa? lan bo ti kuadi l gɔ bo li ki tie a yaala kaa? A tieni led i ki ti maali li bonla a pali nni. A ki pua niba kaa faama a pua u Tienu i faama.” ");
INSERT INTO guxg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anananiasi n gbadi li maam wan cie ki gbaani ki fuodi ki jiini. ");
INSERT INTO guxg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ke ti jiwaandi cuo yaaba kuli bo gbadi lan bonla. ke bi jawaaba kadigi o ki bo piini. ");
INSERT INTO guxg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kudi puoli po k o denpua pundi kaa bani yaala bi tieni. ");
INSERT INTO guxg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piali ka maadi o: «maadi n li ya tie ki kuadi u kpaabu ne nani yin waani i ligi maama.» K o jiini: «li ligi n yeni» ");
INSERT INTO guxg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ke Piali maadi o: «i tieni led i ki taani bigni o yonmdaano tagnmi i. Yaaba n pii a calo n yeni.» ");
INSERT INTO guxg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ko baa li yogu ki jiini, ke bi jawaaba guani sua o kpe o. ");
INSERT INTO guxg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ke ti jiwaanciandi cuo yaaba ye li jaandieli kuli yeni yaaba bo gbadi li bonla. ");
INSERT INTO guxg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ti bonninandi yeni u yaalidgu bo tieni u niwulgu siiga nni bi tuonsɔnba nui po. Bi bo tani ye Salomɔn jaanli kani. ");
INSERT INTO guxg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ama ke ba yendo boo pia papaali yeni wan taani bi po ke bi niba nan bo bua bi maama. ");
INSERT INTO guxg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bi niba yaaba bo pia li dandanli ti yonmdaano nni bo pugdi bi jaba yeni bi puoba. ");
INSERT INTO guxg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bi bo yi cendi yeni a yiama u sanu po i ki duani ba ti gadogdi yeni i diduani po i, ki fidi yaala ke Piali ya ti pendi ya yogu u junjungu n fidiki legini bi tianba. ");
INSERT INTO guxg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Niba boncianli yaaba bo ña Jerusalemi kaalindnma mo bo baadi yeni a yiama yeni yaaba ke i cicibiadi kubi ba ke bi paagdi. ");
INSERT INTO guxg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ama k o yikacianmo fii ya niba kuli bo ye yeni o siiga nni (ki tie Sadusiani jaandi niba); bi bo ye yeni pabɔnli. ");
INSERT INTO guxg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ke bi cuo bi tuonsɔnba ki kuani ba gobna dansalgi dieli nni ki luoni ba. ");
INSERT INTO guxg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama u ñuagu u Tienu meleki bo ki luodi li ganli ki ñani ba ki maadi ba: ");
INSERT INTO guxg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Pan sedi mani li jaandieli nni ki waani bi niba li miali maama» ");
INSERT INTO guxg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ban bo gbadi lani ki fii ki kua li jaandieli nni gu siŋaagu nni ki tundi bi niba. Ama k oyikacianmo cua yeni yaaba bo ye yeni o ki yini mi taankalima ki sɔni ke bi gedi ñani bi tuonsɔnba dansalgi. ");
INSERT INTO guxg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ama ya soje gbenga bo gedi boo la ba dansaldieli nni, ke bi guani maadi ne: ");
INSERT INTO guxg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Ti la k u dansaldieli luoi kpakpab ke sojenba yaaba guu se u bulñɔbu nni; Ama tin luodi ya yogu tii obo deni nni.» ");
INSERT INTO guxg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Li jaandieli nni soje cianma yeni o yidkacianmo n gbadi yeni ke li cuo ba i jeje yeni yaala ba fidi ki cua li puoli po. ");
INSERT INTO guxg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ke o nulo cua ki maadi ba: «ya niba ki luomi dansalgi ye li jaandieli nni ki tundi u nuwulgu.» ");
INSERT INTO guxg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ke o sojecianmo yeni sojenba gedi ki guani yenba suoo kaa tieni ba paalu bonli, kelima bi bo jie ke bi niba bo lugdi ba a tana. ");
INSERT INTO guxg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ban guani yenba bi sieni ba bi ceglkaaba kani ke o yidikacianmo buali ba ");
INSERT INTO guxg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ke maadi: «ti kuani ke yi daa tieni i tundi o nulo ne yeli po ke i nan tieni li tundi ki gbieni Jerusalemi kuli ke li ja sɔma ba wuli po. ");
INSERT INTO guxg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piali yeni o tuonsɔnba bo ŋmia ba ki yedi ti bi cɔlni u Tienu ya maama ki cie bi niba maama. ");
INSERT INTO guxg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ti yaja nba Tienu fiini Jesu bi tinkpiiba siiga nni yua ke i bo cɔni o bu tibu po ki kpaa o. ");
INSERT INTO guxg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","U Tienu duoni wani ki kaani o u nuuienu ke wan tua o bado bijua ti candaano, ki daa nua Isaraheli yaaba biidi ki gɔ mia sugli b biidi po. ");
INSERT INTO guxg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ti tie iesd nba li bona po yeni fuoŋanma gɔ yua ke u Tienu puni tinba yaaba n cɔlni o.» ");
INSERT INTO guxg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bi ceglkaaba n bo gbadi bi pala bo biidi ke bi bua ban kpaa bi tuonsɔnba ");
INSERT INTO guxg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ama falisiani yua ke bi bo yi o Galmali ki tie bil maama bangika kuli siiga nni yua pia ti kpiagidi ke bi cɔlni o bi niba kani bo yi ñani Yesu tuonsɔnba lan nii po lan waaagi. ");
INSERT INTO guxg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Lani k o bo uansi yedi «Yinba Isaraheli yaaba yeni yi bua ki tieni bi niba yaala ne. ");
INSERT INTO guxg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kelima Todasi bo fii ki sedi yognu bá ki u niwulgu bo ŋɔdi o ki pundi nani niba kobina bi bo kpaa'og ke yaaba bo ŋua'o sani ki yadi. ");
INSERT INTO guxg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Li puoli Juda Galile mo bo fii li cɔdli yogu ki dadi niba waamu. K o kpe ke yaaba bo ŋua o kuli sani ki yadi. ");
INSERT INTO guxg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mɔla n ji maadi yi fagdi mani ke ŋa ba suoo li ya tie ke li tuadnma ñani bi niba kani li kan tuo. ");
INSERT INTO guxg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama li ñani u Tienu ya kani yinkan fidi paadi ba yi ti bo bandi mono ki kɔni yeni u Tienu i.» Ke bi gbadi niinma nni. ");
INSERT INTO guxg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Li puoli po ke yi nni bi tuonsɔnba ki puabi ba, ki kuami ba ke ban da faa maadi Yesu maama ke ŋaa ba ke bi kuni. ");
INSERT INTO guxg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bi bo ñani i nikpeli tundi kani kani ke bi pala mangi yeni u Tienu n bua ke bani ń la fala o ya yeli o. ");
INSERT INTO guxg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Faadima fandi kuli u Tienu tuonsɔnba bo yi cua li jaadieli nni yeni bi niba deni ke wangi ke Yesu tie u Tienu n gandi yua i. ");
INSERT INTO guxg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Laa dana siiga Jesu ŋɔdikaaba bo pugdi pugdi, k Heleniti jufinba bo fii k yie Ebliba yaaba po, pakuano bo ki laadi mi jiema. ");
INSERT INTO guxg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jesu tuonsɔnba piiga n bonmilie yeni bo yini bi ŋɔdikaaba ki yedi bi: «laa dagdi ti ŋa u Tienu maama ke ya bɔgdi mi yema. ");
INSERT INTO guxg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","N naataani lugdi mani i siiga nni niba lele yaaba pia ti kpiagdi ki gɔ gbie yeni mi yanfuonma ke ti ba fidi ki teni ba li tuonli. ");
INSERT INTO guxg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","tima wani ti ba guani ki tugni ki ya jaandi yeni u Tienu ñɔmaama.» ");
INSERT INTO guxg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bi laabaalo bo mangi yaaba n bo taani kuli po. Yeni ke b bo lugdi Etieni o ja yua gbi yeni tu dugdi yeni mi yanfuonma, yeni Filipi, Prokori, Nikanɔri, Timɔn, Parmenasi, yeni Nikola yua lebidi bi niba pala Antiosi. ");
INSERT INTO guxg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yaaba gaa u tienu ñɔmaama bo kua yeni li niba jesu ŋɔdikaaba kani ke bi jaani ki gɔ maani i nui b po. ");
INSERT INTO guxg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yeni u Tienu maama bo yadi kaan kuli ke bi ŋɔdikaaba bo pugni Jerusalemi diema nni. ");
INSERT INTO guxg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etieni bo gbie yeni ŋalbaligi yeni u paaciamu ki tiendi mi banciama boncianla ke li pia mi yaalidma bi niba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ama ya niba n bo tie Sinagɔg nni yaaba ke b yi bi Sirenian yeni Alesandrian nba yaaba pia mi yaama yeni Silisi yeni Azi bo fii. Li niba bo pagi yeni Etieni. ");
INSERT INTO guxg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama b bo kan fidi ki sedi Etieni nunga nni yua gbie yeni u Tienu paalu ki maadi mi yanfuomaama. ");
INSERT INTO guxg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Li puoli po ke b wuoni lebidi b niba pala ke bi maadi: «ti gbadi ke Etieni ñani a ñɔbona ki sugi u Tienu yeni Myiisi. ");
INSERT INTO guxg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ke suadi b niba, a nikpela yeni a gbandianla ke b cendi Etieni ki cuo o ki gedi yeni o b ceglikaaba kani. ");
INSERT INTO guxg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","B bo baa yeniu faagu siedanba ke b maadi: «O ja ne li maadi ki sugdi u kaanŋanmo ne yeni yikodi. ");
INSERT INTO guxg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kelima ti gbadi k yedi ke naazareti jesu ba mudi u kaanŋanmo ne k gɔ lebdi balmaama tunda. ");
INSERT INTO guxg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ke ya niba kuli bo kali i celi tema bo cini a nubina o po i ki la k o nunga tie nani meleki yeni. ");
INSERT INTO guxg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Salga yikaaba ciamo ń maadi: «ya bona ne tie mɔnmɔni yoo?» ");
INSERT INTO guxg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etienu ń jiini n kpiiba yeni n bàanba cengi mani nni: Ti yudandi Tienu n dɔgdi ti yaja Abrahama wan den ye Mosopotami karan den yedi o. ");
INSERT INTO guxg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ki ŋa a dogu yeni a kpiiba, ki gedi min ba waani ŋa naani» ");
INSERT INTO guxg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Lawani o den ñani Kalide yaaba dogu, ki gedi ki kali kaaran. O báa n den kpe k o ñani lan kani, ki gedi ki kali yi ji ye ya dogu nni mɔlane. ");
INSERT INTO guxg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","O den k puni o o tifancelu; ba naani k e o ba ŋmaa o taali. Ama o den niano (ya yogu ke Abalahama da den k pia biga) ke o cabi lan ya dogu wun tua o dogu celu wani yeni o puoli ŋuani o kuuma puoli. ");
INSERT INTO guxg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","U Tienu den yedi o yaali ne, ke o puoli ŋuani bo kali doglamu nni nani bina ba, li dogu niba ba cedi ban tua yonbi hali bina kobina (4oo) ");
INSERT INTO guxg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mini n ba jioa ti buudi yeni ya nibuolu n cuo ba ti yonbdi yeni. U Tienu n yedi yaali n yeni, lani ya pendi, bi ba ña li dogu ki ya pugi nni lan kani.» ");
INSERT INTO guxg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","O den teni Habrahami ti kɔndi ke ti tie dɔnlilolma bi siiga nni. Yeni ke Abrhami bo tua Isaka báa ki kɔndi o li daaniidaali; isaka ka mɔ tua Jakobo báa, Jakobo mɔ n tua piiga nbilalie yaaba n ba tua piiga n buoli lie (12) nikpeliba cuga. ");
INSERT INTO guxg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","A cuga n i kpeliba bo nani Josefi ki cuo'o ki kaadi o ke bi gedi yeni o Ejipti, ama u Tienu bo ye yeni o ");
INSERT INTO guxg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","O bo nanli o ki faabi o o fala kuli nni ki puni o li yanbili yeni mi yanfuoma ki sua ke Farawɔni n tie Ejipti Badciamo, ke Farwɔni dini o o kpaagli yua n todi o u dogu kubma nni. ");
INSERT INTO guxg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Li yogu kmi koma yeni mi cacagma baa Ejipti yeni kaana dogi nni. Ti yaajanba, ji bo ki pia bonjekaali. ");
INSERT INTO guxg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ama jakobo n gbadi ke i fee(ŋalkama) ye Ejipti, ke o cindi ki sɔni ti yajanba ke bi gedi ki baa. ");
INSERT INTO guxg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mi gediliema ke Josefi waani o yuli o kpiiba (naataani), ki cedi ke farawɔni bandi Josefi diegu yaaba. ");
INSERT INTO guxg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josefi n nagini o yuatieba ke ban maadi o báa wan tugi u diegu nni yaaba kuli ń cua Ejipti dogu nni. Bi kuli bo taani niba piilele n niba mu ");
INSERT INTO guxg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Lan tieni maama ke Jakobo jiidi ki kali Ejipti dogu nni n yeni. Lan tieni a bina waamu ke o kpe wan yeni ti báanba. ");
INSERT INTO guxg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ke b tugi o gbanandi ki gedi ki pii Sisama, Abrahama n bo cɔdi i ligi ki daa ya kakuli Hamori bijaba kani. ");
INSERT INTO guxg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","UTienu n bo ñani Abrahama yaali nni bo pundiya yogu, Jakobo buolu n bo pɔli ki yabdi ki pugni Ejipti dogunni ");
INSERT INTO guxg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Hali ke badciantiano ti kali Ejipti Farawɔn gbandi po. wani nan bo k bani Josefi. ");
INSERT INTO guxg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Lan ya badciamo n bo bɔndi ti buolu yaaba, ki kuani ba mi cacagma nni hali ke b lu bi. ");
INSERT INTO guxg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lan yognu i ke Moyiisi mali o bo ŋani u Tienu nunga nni, ke bi ŋaani o o báa diegu nni ŋmaali taa (3) ");
INSERT INTO guxg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ban luni Moyiisi k o badciamo jifaano gandi o, ki wubi o nani o bimadiga yeni. ");
INSERT INTO guxg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moyiisi kua u cogu ki ga Ejipti tunda yeni u nunfanbu kuli. Obo pia u paaciamu o maama nni yeni o tuada nni. ");
INSERT INTO guxg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Wan pundi bina piina ke o jagi ke wan gedi ki fuondi o kpiiba Isarayeli yaaba. ");
INSERT INTO guxg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wan la ke b kubi Isarayeli nulo ki cagni ke Moyiisi nanli o, ki tuu li panli, ki kpaa Ejipti yua. ");
INSERT INTO guxg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","O bo maali k u Tienu bo tɔgni o nuu po i ki faabi ba, ama bi nan boo gbadi yeni. ");
INSERT INTO guxg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lan fii fandi, ke o cua ki sua ke Isarayeli yaaba kɔni. Wan bigni ke ba taani ba ki paadi li kɔnli; ki maadi: canbanba mia mani sugli, i tie kpiiba i. li kpiili ye i siigs nni be cedi ki manbiidi i lieba yama nanda? ");
INSERT INTO guxg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama yua n mabni o lielo yeni n gaa o po ti jadi ki yedi “ŋa dini ŋa li bali ki puni a u sanu ke ŋan jia ti buudi? ");
INSERT INTO guxg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A buaŋan kpaa n nani ŋan won kpaa Ejipti jua maama yo oo? ");
INSERT INTO guxg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moyiisi n gbadi yeni, wan sani ki gedi u cangu Mandian dogu nni wan mali naani bila lie ");
INSERT INTO guxg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Wan pendi bina piina, meneki n dɔgdi o po ki tinkuoga Sinayi juali p0, k u tutuugu yugu n ye siiga nni. co u muu pienu ");
INSERT INTO guxg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyiisi n la u mu, lan nan lidi o yeni lan ya dɔgdima; wan nagni ki bua diidi wan gbadi u diedo nialu, k u maadi ne: ");
INSERT INTO guxg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","N tie a yajanba tienu, Abalahami, Isaka yeni Jakobo Tienu i. Ti jawaandi ń cuo Myiisi, o gbanu ń ŋɔa wan bo baa ya papaali k o ba tibni ki diidi yua maadi. ");
INSERT INTO guxg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Odiedo n ́yedi o “pidi a taacaadi kelima ŋan ye naani ne tie tinŋanga i. ");
INSERT INTO guxg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mɔnmɔni, n la n buolu ń laadi ya fala Ejipti dogu nni. N gbadi ke bi buudi, ki fabni, ke jiidi ke mi faabi ba. Mɔlane ne gedi mini n sɔni a Ejipti dogu nni. ya caa. ");
INSERT INTO guxg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ban bo yie ya Moyiisi maama, ki buali o: “ŋma dini a bado bii buudi yudaano yeni?”wani k u Tienu sɔni nani bado yeni candaano. U Tienu cedi ke meleki nuu dɔgdi o po u tutuugu nni. ");
INSERT INTO guxg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moyiisi n bo ñani ba Ejipti dogu nni. O bo tieni yaalidigu ");
INSERT INTO guxg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wani li moyiisi n maadi Isaraheli yaaba “u Tienu lugdi ki dɔgdi i po o sawalopualo i kpiibasiiga nni sawalipualo nani mini yeni.” ");
INSERT INTO guxg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lan ya nilo n bo ye li nitaali siiga ki tinkuoga nni yua bo yua bo maadi sinayi juali po yeni. Ya nilo bo ye yeni ti báanba ya nilo n ga li miali maama ke wan sɔgni ti ");
INSERT INTO guxg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Lan ya nilo i ke ti yajanba yie kaa cɔlni. Bi yie o maama, ke bi pala guani ki kua Ejipti tuona nni. ");
INSERT INTO guxg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Lan yognu b bo maadi harɔn “tagi ti po ya tagbuoli ke ti baa ŋua ki pugi. Ama ya Moyiisi n ñani ti Ejipti dogu nni, yeni tii bani lan tieni maama. ");
INSERT INTO guxg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lanwani i b bo tugi naabiga ki pugi ki po, ki padi b pada, ke bi pali mani bi nui bontagikaali po ");
INSERT INTO guxg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ama k u tienu lebdi bi yama ki cedi ke bi pugi tanpoli ŋmabidi ŋmabidi nani lan diani maama bi sawalipuaba tili nni yeni ki tinkuoga po nni “Isaraheli diegu, bina piina n yeni ki tinkuoga nni i puni nni i yankodike e ki padi n po a pada aa? ");
INSERT INTO guxg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","I tuo ki pugi Molɔki u tienu yeni Renfan tienu ŋmabiga. yi go tagi ya bulo ki pugi yeni yia po, n ba cedi ban cuo yi ti yobdi, ki gedi yeni yi hali Babilɔnipendma. ");
INSERT INTO guxg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","UTienu mabilkaama kpagu po ti yaajaba la kasiedi ki tinkuoga nni nani u tienu n bo maadi o bali maama yeni Moyiisi maama yeni ke o cedi lan dɔgdi o po nani wan bo la maamasina yi juali po yeni ");
INSERT INTO guxg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lan ya felijongu i ke ti yajaanba tugi bi cenli nni, ki yegi yeni Jesue ki cua. lani i tieni ban pundi ya tinga po ki sua u Tienu bo beli yaaba bo cindi ki kaa ki po ke ti yaajanba daa ki pundi yogo (daali) ");
INSERT INTO guxg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wani yua baa u Tienu ŋanbili ki bo jagi ke ban maa dieli Jakobo Tienu po. ");
INSERT INTO guxg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama saalomɔn n maa u Tienu po diegu ");
INSERT INTO guxg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ama u Tienu naa kua ya dieli nni ke bi niba nui maa; nani o swalipualo ń yedi maama ");
INSERT INTO guxg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Tanpoli po ntie n badikpagli ke ki tinga tie n taaŋmakaanu. ke u laa diegu ke i ba fidi ki maa n po? o diedo maama n yeni. mi ba kali le i ki fuodi i? ");
INSERT INTO guxg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","n ya nuu ka tagi lan ya bona kuli i? ");
INSERT INTO guxg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nisaalo fini yua ya tulu se bontantanli ke i pala yeni i tuba ki pia maalima ba kuli ku kɔnciagu po ki sedi ki pani mi fuoŋanma u sanu; I li tie nani i yaajanba ń́ tieni maama yeni i ");
INSERT INTO guxg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","O laa o sawalipualo i, ke i yaajanba ki waani fala, ki cagni o? Bi bo kpaa ya sawalipualo bo liidi ki cua ki sua ki yua tie niteginka daa pundi; mɔlane yinba n mɔ kuadi o ki nikpalo po. ");
INSERT INTO guxg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","yinba yaaba ń ga malekinba ń bili ya mabilikaama, ki naa taa ma ki bili i yula nniyeni. ");
INSERT INTO guxg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Saliga yidkaaba nitaali ń gbadi lan ya maama ke mi duolo bi pala, ke bi ŋmani a ñina Etieni po. ");
INSERT INTO guxg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nani wani n bo gbie yeni mi fuoŋanma yeni, k o yaadi ki nua tanpoli cenmm, ki la u Tienu yudandi ke Jesu se uTienu nujienu po. ");
INSERT INTO guxg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Etieni n yedi: «diidi mani, n la ke tanpoli luodi, k o ja bijua se u Tienu nujienu po. ");
INSERT INTO guxg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ama li nantaali ń taani ki yigni o po, ki pii bi niba ki sani ki wolo o. ");
INSERT INTO guxg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ki pua ki peli ki ñani o bi dogu nni, ki lugdi o tana: yaaba ń bo kasiedinba bo bili tialakaadi naaciemo bá kani, ke b yii o Soli. ");
INSERT INTO guxg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ban bo lu Etieni a tana ya yogu, o jaadi o Tienu ki maadi: «O diedo Jesu gaa mi fuoma» ");
INSERT INTO guxg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ki baa ki gbaani, ki yignio paama ki maadi: «daa tugni ya biidi ne (tuobiadi) ne bi ya yula po. Wan yedi lani ki gbeni ke o jiidi.» ");
INSERT INTO guxg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Landaali bi niba den cili ki wangi Krisiti n yini yaaba, yaaba n ye Jerusalema o falabiado. Jesu tondiba yaaka, yaaba n sieni kuli den yayadi Jude diema nni. ");
INSERT INTO guxg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Yaa niba n den fangi U Tienu den piini Etiena ki mua opo i kumoe boncianla. ");
INSERT INTO guxg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Solo den moandi ki baa bolini Krisiti n yini yaaba. O den kua ti diedi nni ki co bi jaba yeni bi puoba kuli, ki kuandi ba li kpaadieli nni. ");
INSERT INTO guxg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yaaba n den yayadi yeni, den caa i kaani boncianla ki wangi U Tienu Laabaalŋamo. ");
INSERT INTO guxg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipiden jiidi ki gadi ya dogu n ye Samali diema nni ki wangi laa niba U Tienu n Gandi yua maama fuuli. ");
INSERT INTO guxg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bi niba n den gbadi Filipi n yedi yaala ki laa wan tieni ya bancanma, bi den cengi o maama bonŋanla. ");
INSERT INTO guxg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","I cicibiadimi den tangi ki ña ban ye yaaba ya niinni. Yaaba ya gbanandi n ffaani yeni a waba boncianla moko den paagi. ");
INSERT INTO guxg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Li pamanli den tieni boncianla laa dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Li den sua ke o nilo ye u dogu yeni niinni ke li waagi, ki yi Simono. O den tiendi ti belbondi ke li paki Samali yaaba, ki jigini o yuli ke o tie niciamo. ");
INSERT INTO guxg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bi niba kuli, a bila yeni a nikpela, den ga o maama boncianla ki tua: «One n tie U Tienu paalu, ban yi yu u paaciamu». ");
INSERT INTO guxg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bi den cengi o maama kelima wan n tiendi ya belbondi den paki ba hali ke li waagi. ");
INSERT INTO guxg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama Flipi n den wangi ba U Tienu diema Laabaalŋamo yeni Jesu Krisiti yeli, bi den daani o maama ke o wali ba U Tienu ñinma, bani bi jaba yeni bi puoba kuli. ");
INSERT INTO guxg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simono wani oba den daani Filipi ki nua wan tiendi ya sinankeeninba yeni ya bancianma ke li paki o. ");
INSERT INTO guxg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jesu tondiba yaaba n sieni Jurusalema n den gbadi ke Samali yaaba ga U Tienu maama, bi den sɔni bikani Pieri yeni Jan. ");
INSERT INTO guxg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ban den pundi likani, bi den jaandi yaaba n daani po ke ban baa U Tienu Fuoma yua. ");
INSERT INTO guxg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","U Tienu Fuoma yua daa den jiidi bi siiga oba kuli po. Bi da den wali o Diedo Jesu Krisiti yeli nni baba. ");
INSERT INTO guxg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lane Pieri yeni Jan den maani bipo bi nui ke bi baa U Tienu Fuoma yua. ");
INSERT INTO guxg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simono n den laa ke bi baa U Tienu Fuoma yua kelima bi tondiba maani bipo bi nui, o den cuani bipo i ligi ki yedi: ");
INSERT INTO guxg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Pa mani mini moko laa paalu, ke min maani n nui yua ya po, wan baa U Tienu Fuoma yua.» ");
INSERT INTO guxg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pieri den yedi o: «Fini yeni a ligi kuli n bodi, kelima a tama ke a baa pa i ligi ki baa U Tienu paalu. ");
INSERT INTO guxg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ŋaa pia biinu yeni ŋantaadoba kuli li naa tuondi nni, kelima a pali naa tiegi U Tienu nintuali. ");
INSERT INTO guxg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lani ya po ŋan biidi a pali a yanjagibidli po ki ŋa li ki mia o Diedo li ya baa tuo wan pa ŋa sugli ŋan pia ya yanmaalma po. ");
INSERT INTO guxg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","kelima n den nua ke li nunponbiadli gbie n niinni, ti tuonbiadi go lola a mo.» ");
INSERT INTO guxg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simono den gua ki yedi: «mia n po mani o Diedo ke yin yedi yaala kuli n da cua n kani.» ");
INSERT INTO guxg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pieri yeni Jan n den tiendi siedi o Diedo ki go wani o maama b den gɔ Jerusalema ki wangi Samali dogi boncianla nni, o laabaalŋamo. ");
INSERT INTO guxg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","O diedo maleki den maadi yeni filipi ki yedi o: «Fii ki gadi u ganu po, ki pundi ya sɔnu n ñani Jerusalema po ki caa Gaza po. Ki ŋɔdi ya sɔnu n pɔndi mi fanpiema yeni nni.» ");
INSERT INTO guxg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipi den fii ki gadi. Li den sua ke Etiopi diema nilo yua n tie mɔlga, Kadasi Etiopi pobado, yua n ki o ligkublo, den gadi Jerusalema ki ban kpiagi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wan den lebdi ke baa guani o denpo, o den ka i taami tolgu nni ki cogi o Sawalpualo Isayi tili. ");
INSERT INTO guxg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","U tienu Fuoma den yedi Filipi: «Gadi ki nagni ya tantolgu ne ki yegi yeni gu.» ");
INSERT INTO guxg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi den sani ki nagni gu ki gbadi ke Etiopi yua cogi o Sawalpualo Esayi tili nni. O den buali o: «A ga ŋan cogi yaala n bua ki yedi yaala bi?» ");
INSERT INTO guxg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","O den gua ki yedi o: «N baa gaa ledi ki bandi, nitɔ yaa bundi npo i?» Lani, o den mia Filipi wan do ki kali yeni o u tantolgu nni ban yegi. ");
INSERT INTO guxg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wan den cogi iDiani nni naankani n den maadi ya maama ne: «B den dia o nani o pia yeni ki caa yeni o u yankodikaanu po. Nani i pabiga n ŋmimi yua n mɔgidi o kobidi kani maama. Waa den yaadi o ñɔbu. ");
INSERT INTO guxg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bi den miidi o, ki jia opo ya buudi n ki tiegi. ŋma baa fidi ki togdi o buolu maama? Kelima bi ñani o miali ŋanduna nni.» ");
INSERT INTO guxg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","I mɔliga den yedi Filipi: «N bua ŋan wani nni, Sawaalpualo maadi ŋma ya maama i? O maadi o yuli maama bi nitɔ yaama yo? ");
INSERT INTO guxg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipi den cili yeni laa dianu ki wani o Jesu laabaalŋamo. ");
INSERT INTO guxg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ban den ŋua b sani keli suagi liiga, B den pundi mi ñinma kani. I mɔliga den yedi: «Diidi mi ñinma nna. Be n yie npo ke min da wali?» ");
INSERT INTO guxg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi den gua ki yedi o: «A ya daani yeni a pali kuli, li baa fidi.» Ke i mɔliga den gua ki yedi: «N daani ke Jesu Krisiti tie U Tienu Bijua.» ");
INSERT INTO guxg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","O den wani yua n gobdi u tantolgu wan sieni gu. Filipi yeni i mɔliga den jiidi ki kua mi ñima nni ke o wali o. ");
INSERT INTO guxg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ban den ñani mi ñima nni, o Diedo Fuoma den taa Filipi ke ki mɔliga den suagi liiga yeni o sancenli ke o pali mani. ");
INSERT INTO guxg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipi den sua ke o ye Asota dogu nni. O den ñani Asota ki caa Sesale, ki wangi o Laabaalŋamo wan tagini ya dogi kuli hali ki pan pundi. ");
INSERT INTO guxg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ama Soli bo li k ŋa ki dieli o yomdaano ŋɔdikaaba ki wangi bi fala, ki gedi a sala yikaciamo deni ");
INSERT INTO guxg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","O den yi gedi ki gaa ya tila cabi o ke wan gedi jufinba jaandidɔngu nni Damasi. O ya la b siiga yua, jaba bii puobi wan loli'bi ki kuani yemi Jerusalemi. ");
INSERT INTO guxg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Soli n bo pa u sanu po ki nagdi Damasi dogu ke mi yiema ti cua ki kaani ki lindi o; ");
INSERT INTO guxg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","k o baa tinga nni ke gbadi u nialu ke li maad o: «Soli Soli be be cedi k a yonbidi n?» ");
INSERT INTO guxg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ke Soli jiini o «A tie ŋma i n yonmdaano?» k o yonmdaano guani jiini o: n tie jesu yua ke wangi o fala i; ");
INSERT INTO guxg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","«Ama fii ki kua u dogu nni b ba maadi ŋa yaali k a ba tieni yaala.» ");
INSERT INTO guxg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ke yaaba bo paa u sanu yeni Sloi ji se ki ŋmini; b gbadi u nialu ki naa la nulo. ");
INSERT INTO guxg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol bo fii, wan yaadi ki bo nuali o bo kan fidi la lba. ke b cuo u nuu ki dadibi o ki gedi yeni o hali Damasi. ");
INSERT INTO guxg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","K o tieni daa taa kaa nuali o bo ki ñuni ki gɔ ki jeni. ");
INSERT INTO guxg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jesu ŋɔdika bo ye Damasi ke b yi o Ananiasi. Oyonmdaano bo maadi yeni o mi dɔgdima nni: «Ananias.» Ke o maadi «mini yen i n yonmdaano» ");
INSERT INTO guxg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ke o yonmdaano maadi o: «Fii ki gedi u sanu po yua ke b yi u jienu, juda deni, buali ya nulo ñani Tarsi, yua ke b yi o Soli kelima o jaani. ");
INSERT INTO guxg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","K o la mi dɔgdima nni o nulo ke b yi o Ananias k o kua ki mani o nui o po ki fidi wan nuali.» ");
INSERT INTO guxg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ama ke Ananias jiini: “yonmdaano n gbadi ke bi niba maadi o ja ne po, Wan waani a niŋanma fala maama Jerusalemi. ");
INSERT INTO guxg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","O bo pia ti yikodi a yedikaciama kani ke fidi ki cuo nulo yua jaandi a yeli po”. ");
INSERT INTO guxg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ama o yonmdaano maadi o: «gedi o tie tuonsɔtiagu ke n lugdi o ke wan waani n yeli Isaraheli badciama yeni b bila yaaba k dugi n po; ");
INSERT INTO guxg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","N ba waani o wan ba gaa fala kuli maama ki n yeli po» ");
INSERT INTO guxg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yeni ke Ananias gedi ki kua o deni. ki tani i nui o po, ki maadi: «n naataanu Soli, o yonmdaano yua legdi a nunga po u sanu po ŋan bo baadi, n sɔni n ki ŋan fidi ki nuali ke fuoŋanma n gbie a nni.» ");
INSERT INTO guxg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Li yogu ke li tie nani ti nipuudi yeni ki ñani o nubina nni ki baa k o gɔ nuali. ");
INSERT INTO guxg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","K o ji dini ki baa mi tuama. O bo ye yeni Damasi ŋɔdikaaba ki tieni dana. ");
INSERT INTO guxg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Li yognu ko ji wangi a jaadiena nni ki maadi k o tie u Tienu bijua i. ");
INSERT INTO guxg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yaaba bo gbadi kuli bo ye u yaalidgu nni ki maadi: «waa tie ya nulo bo biidi yaaba kuli bo jaandi Jesu yeli kaa? O bo kua ne ke pan cuo b ŋɔdikaaba ki gedi yemba bi salyidikacianba kani.» ");
INSERT INTO guxg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ama Soli bo baa o paaciamu ke li pugdi, ke yagi jufinba yaaba bo ye Damasi yama ki wangi ke u Tienu bijua tie Jesu Kristi. ");
INSERT INTO guxg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lan tieni dana ke jufi nba jougi ki bo kpaa o. ");
INSERT INTO guxg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ama k o bandi bi juogli. B bo suli a gana kuli yieni yeni ñiagu i ki fidi ban ñani o miali. ");
INSERT INTO guxg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ama ke ñiayengu ke bi ñani o li guoli u baabuogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wan bo pundi Jerusalemi, Soli bo bigni ke wan ŋɔdi b ŋɔdkaaba, ama b kuli bo jie o kaa bani k o tie o ŋɔdika i. ");
INSERT INTO guxg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ama ke Barnabasi taa o ki yeni o b tuonsɔnba kani. Ki dugdi bi Soli n bo la ti yonmdaano nandi u sanu po. ke o yonmdaano maadi o yeni wan bo wani nandi jesu yeli po. ");
INSERT INTO guxg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ke o tuogi bi ki sua k o bo kua Jerusalemi ki gɔ ki ña i. O bo maadi yeni i mɔnmɔni ti yonmdaano jesu po. ");
INSERT INTO guxg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ki gɔ pagi yeni jufi Greki nba; ama ban wani bo tundi kpaani ke ban ñani o miali. ");
INSERT INTO guxg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","O naataani n gbadi ban taa o ki gedi yeni o Sesare ki pedi yeni o hali Tarsi. ");
INSERT INTO guxg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yeni ke u jaandidɔngu bo ye ye mi yalma nni Jude dogu kuli nni, Galile yeni Samari, bo fii ki sedi ti yonmdaano jijiegu nni yeni fuoŋanma paalu pugnma nni kristi yaaba bo pugdi k yabi. ");
INSERT INTO guxg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","lan ji legdi ke Piaali bo waa diema kuli nni, o bo gedi yaaba gaa u Tienu maama kani hali Lide. ");
INSERT INTO guxg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Li kani k bo la ja bá ne ke b yi o Ene ko bo wabi ki duani bina nii o gadugu po. ");
INSERT INTO guxg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piaali k a maadi o: «Ene, Jesu kristi paagdi ŋa. Fii ki ŋanbi a gadogu» li yogu k o fii. ");
INSERT INTO guxg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yeni ke Lidi yeni Sarɔn yaaba bo la o ki lebdi bi pala ki ke ti yonmdaano kristi nni ");
INSERT INTO guxg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope nni bo pia ŋɔka bá ke bi yi o Tabita, li niima n tie «Dorka» li pua bo gbie i a tuadiŋanma po i ki tie suglidaano bi cacagidanba po. ");
INSERT INTO guxg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ke li bo ti tuu k o yia ki kpe; ban bo wuli o bi bo duani o u dietuadigu po i. ");
INSERT INTO guxg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nani Lidi n bo kɔbi yeni Jope ke bi ŋɔdikaaba bandi ke piaali ye li kani, ke bi sɔni nibalie ke ban baani o: «cua yeni tinba mɔlane» ");
INSERT INTO guxg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ke Piaali fii ke bi gedi. Ban bo pundi bi bo doni yeni o u dietuadugu po i. Ke a pakuana kuli ji se o kani ki buudi, ki wangi o ya tiadi ke Dorkasi bo ŋali wan bo ye yenba. ");
INSERT INTO guxg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ke Piaali cedi ke bi ñani bi niba kuli deni nni k o baa ki gbaani ki jaani; ki gbagi ki diidi mi kuuma ki maadi: «Tabita, fii» Wan ŋubidi o nubina, wan la Piaali wan fii ki kali. ");
INSERT INTO guxg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piaali ka tandi o u nuu ki fiini seni o. Wan yini a pakuana yeni yesu ŋɔdikaaba ya yogu bi sua o fuo. ");
INSERT INTO guxg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lan maama bo yadi Jope dogu kuli nni ke bi niba boncianli tuo ki daani yonmdaano nni. ");
INSERT INTO guxg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Li bo tuu ki Piaali bo waagi Jope ja bá ne kani ke bi yi o Simo k o tie gbanjabilo. ");
INSERT INTO guxg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","O ja den ye Sesale dogu nni ke b yi o Koneya. O den tie Itali minteela kobiga yudaano. ");
INSERT INTO guxg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","O ja yeni den ŋua U Tienu ki fangi o, wani yeni u diegu nni yaaba kuli. O den todi Jufinba boncianli ki gua jaandi U Tienu yogu kuli. ");
INSERT INTO guxg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dayenli, u siŋaɔgu kudiyiani yogu, ke u laa U Tieni maleki kua o kani ki yedi o: «Koneya.» ");
INSERT INTO guxg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O den nonli maleki ke ti jawaandi cuo o ke o yedi o: «N Daano, a yedi be.» Maleki den gua ki yedi o: «A jaandi yeni a ŋanma a luoda po pundi U Tienu kani ke waa sundi lipo. ");
INSERT INTO guxg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mɔla ŋan sɔni bi jaba ban gadi Jafa ki ban yini Simono, ban gua yeni yua Pieri, wan cua a kani. ");
INSERT INTO guxg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","O cani o jabdo Simono, yua yaa diegu n baali mi ñinciana.» ");
INSERT INTO guxg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Maleki n den ñani o kani, o den yini o naacenba siiga niba lie, yeni yaa mintela n gugu siiga yendo ke o mo jaandi ki tie o naciemo. ");
INSERT INTO guxg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornela n maadi ba yaala n bo tieni kuli, ki sɔni ba Jafa dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lan den fii ki faa u siŋaɔgu kudi luoba gogu, bi jaba yeni den ye u sɔn nni ki nagdi Jafa, Pieri mo den doni u diegu yuli po ki baa jaandi. ");
INSERT INTO guxg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mi komi den cuo o ke o bua je. Ban den ŋanbdi mi jiema ya yogu, ke o laa o dɔgdi. ");
INSERT INTO guxg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O den laa ke tanpoli luodi, ke yaa bonla n tie nani bu kpalcianbu yeni ñani tanpoli po ke bi muubi bu ñɔkunaadi kuli ki jiinihali tingi po, ");
INSERT INTO guxg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ke ki tinga yandi buoli kuli yeni bonbalinkaana buoli kuli yeni bonyugdi buoli kuli ye bu kpalicianbu yeni niinni. ");
INSERT INTO guxg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","U nialu den yedi o: «Pieri, fii ki kpa ki ŋmani.» ");
INSERT INTO guxg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pieri den yedi: «O Diedo, n kan tieni lani, kelima n daa ŋmani yaala n tie kuali yeni yaala n jɔgni baa yenma.» ");
INSERT INTO guxg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","U nialu yeni gua den maadi mi liema ki yedi o: «U Tienu ya yedi ke yaala n ŋani ŋan da nua la ke li jɔgni.» ");
INSERT INTO guxg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Liden tieni yeni taalma taa. Lan yogu li den gɔ ki doni tanpoli. ");
INSERT INTO guxg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pieri n da den mali ki bua ke ban bandi Simono diegu n ye naakani, ki sedi bu bulñɔjabu kani. ");
INSERT INTO guxg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bi den kpaani ki buali Simono ban gua yi yua Pieri ya cani lankane. ");
INSERT INTO guxg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Laa yogu, Pieri n da bungi li dɔgidli yeni n bua yedi yaala, U Tienu Fuoma den yedi o: «Cengi, niba taa cua ki lingi a. ");
INSERT INTO guxg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fii ki jiidi, ki yegi yeni ba ki da bangi liba, kelima mini n sɔni ba.» ");
INSERT INTO guxg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pieri den jiidi, ki yedi bi jaba yeni: «Mini n tie yin lingi yua. Be cuani yi ne?» ");
INSERT INTO guxg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bi den yedi o: «A minteela kobiga yudaano Koneya n sɔni ti a kani. O tie niteginka ki gua fangi U Tienu. Jufinba nibuolu yaaba kuli tieni opo ya siedi n ŋani. U Tienu sɔni maleki o kani ki waani ke o wan gbadi ŋan baa yedi yaala.» ");
INSERT INTO guxg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pieri den kuani ba li dieli nni ki ga bi cangu. Lan den fii ki fa o den fii ki yegi yeni ba. Bi kpiiba yaaba n ye Jafa siiga bi tianba den ciani o. ");
INSERT INTO guxg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Li dalieli daali b den pundi Sesale. Li sua ke Koneya den yini o kpiiba yeni o buakaaba ke b taani ki cua. ");
INSERT INTO guxg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pieri n den kua ya yogu, Koney den tuogi o ki bialo ki gbaani o taana kani. ");
INSERT INTO guxg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pieri den fiini o ki yedi o: «Fii n moko tie nisaalo.» ");
INSERT INTO guxg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pieri yeni Koneya n den boe ki kua o dieli nni, Pieri den laa k b niba taani boncianla. ");
INSERT INTO guxg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Oden yedi ba: «I bani k li kua ke Jufi ṅ taani yeni onilamo, yaaka ki kua o dieli nni. Ama U Tienu dɔgdi npo ke min da gua nua oba kuli ke o jɔgni U Tienu po. ");
INSERT INTO guxg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lani n cedi ke yin den sɔni ke b yini nni ya yogu, n den fii ki cua ka bangi liba. Lanwani n buali yi, be ya po ke yi sɔni ki yini nni?» ");
INSERT INTO guxg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koneya den gua ki yedi: «Dinne dana taa, li yenlebidli yogu, n den ye n dieli nni ki jaandi. Lanyogu ya ja n laa ya tiadi n ñiligi den dɔgdi o yuli n kani ki yedi nni: ");
INSERT INTO guxg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","«Koneya, U Tienu gbadi a jaandi ki gua tiani todma a luoda po. ");
INSERT INTO guxg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ŋan sɔni Jafa po, ban ban yini Simono ban gua yi yua Pieri. O cani o jabido Simono, yua yaa diegu n kuu yeni mi ñincianma. ");
INSERT INTO guxg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lanyogu n den sɔni ke ban yini a. A ŋanbi yeni ŋan cua. Mɔla tikuli ye U Tienu nituali ki bua ki gbadi wani o Diedo n yedi yaala kuli.» ");
INSERT INTO guxg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pieri den yaadi ki yedi: «mɔmɔni n bandi mɔla ke U Tienu ki gagdi b niba yeni b lieba. ");
INSERT INTO guxg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yua n fangi o ki tiendi yaala n ŋani, wan tie nibuolu kuli, o ba fidi ki cua o kani. ");
INSERT INTO guxg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","U Tienu den sɔni u tondu Isalele yaaba po ki waani ba mi yanduanma Laabaalŋamo, kelima Jesu Krisiti ya po, wani yua n tie b niba kuli Diedo. ");
INSERT INTO guxg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yi bani ke Jan den wangi b niba ban lebdi b yama ke wan wuli ba U Tienu ñima. Yi gua bani yaala n den cili ki tieni laa yogu Galile nni ki yuadi ki tieni Jude kuli nni. ");
INSERT INTO guxg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","U Tienu den cedi ke U Tienu Fuoma yua jiidi Nsaleti yua Jsu po ki gbie o niinni maama, ki puni o u paalu. Yi gua bani ke o den caa i kaani kuli ki ŋanbdi b niba po, ki faabdi Sutaani n den miabi yaaba kuli ki paagdi ba kelima U Tienu den ye yeni o. ");
INSERT INTO guxg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ti tie siedinba wan den tieniyaala Jufinba diema nni yeni Jerusalema nni kuli. B den jɔnio u dagu po ki kpa u. ");
INSERT INTO guxg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama li dataali daali U Tienu den fiini o b tin kpiiba siiga ki cedi ke o dɔgdi o yuli t po. ");
INSERT INTO guxg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Waa den dɔgdi o yuli Jufinba kuli po ka, kali U Tienu n den tuodi ki gandi ya siedinba po, tinba yaaba n den taani ki di ki gua ñu yeni o wan den fii b tinkpiiba siiga ya yogu. ");
INSERT INTO guxg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wani Jesu ṅ den puogi ti ke tin ya wangi b niba o Laabaalŋamo, ki ya tiendi siedi ke U Tienu dini wani Jesu li bai ke wan ya tie o bujialo ya niba n fo yeni b tinkpiiba kuli po. ");
INSERT INTO guxg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","B sawalpuaba kuli maadi o maama ki yedi ke yua n tuo ki daani o kuli baa baa sugli o tuonbiadi po kelima o yaa yeli po.» ");
INSERT INTO guxg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pieri n da den maadi yaa yogu, U Tienu Fuoma yua den jiidi yaaba n cengi o maama kuli po. ");
INSERT INTO guxg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Li den paki yaaba n den daani ki tie Jufinba ki yegi leni Pieri kuli, ban laa ke U Tienu puni b nilaba o paalu yua ṅ tie U Tienu Fuoma yua, ke o jiidi bipo. ");
INSERT INTO guxg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","B den bandi ke U Tienu puni ba o paalu yeni kelima b dengba ke b maadi mi malanma ki kpiagdi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Lani Pieri den yedi: «Ya niba n tie na baa U Tienu Fuoma yua nani ti moko n den baa maama. ŋme baa fidi ki yie bipo ke tin da wɔli ba?» ");
INSERT INTO guxg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Oden teni li ñɔbonli ke ban wɔli ba Jesu Krisiti yeli nni. B den mia o wan sedi yeni ba danaba. ");
INSERT INTO guxg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesu tuonsɔnba yeni i nataani yaaba bo ye Jude bo gbadi ke yabi ki dugi Jesu po mɔ gaa uTienu ñɔmaama. ");
INSERT INTO guxg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piaali n bo doni Jerusalemi a kɔnjakpela bo kpag'o ki maadi: ");
INSERT INTO guxg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«a taani kali yeni a jola ki dini» ");
INSERT INTO guxg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ama ke Piaali waani li maama tuago tuago. O bo maadi ");
INSERT INTO guxg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«N bo jaani Jope dogu nni ki la u dɔgiduguki li naani u kpalibu ki ñani tanpoli po kaana kuli po. Li bo ji k tuoli nni ");
INSERT INTO guxg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ke n ñuadil 'li ki diid'li ki la ti muayandi, a bonbalikaana yeni tanpoli po bonyugida» ");
INSERT INTO guxg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ke n gbadi u lantɔgu ke li maadi'n: Piaali fii ki kpa ki ŋmani!» ke n jii: ");
INSERT INTO guxg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","N badiciamo n yie jɔgndi yeni bonbiidi k baa kua n ñɔbu nni» ");
INSERT INTO guxg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ama k u lantɔgu yeni guani maadi tanpoli po. U Tienu n yedi ki yaali k tie jɔgndi daa taal'li lan tua jɔgndi» ");
INSERT INTO guxg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","L i bo tieni taalmi taa ki guani lebidi tanpoli po. ");
INSERT INTO guxg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nibataa n bo se n deni ti bo kua naani, b bo ñani Sesare i ke b sɔnbi n kani. ");
INSERT INTO guxg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mi tagima maadi n ke n yegi yemi ki gedi ke paadinma n daa ye. A naataanbila bonlie yen mini n bo taani gedi k kua o ja yeni deni ");
INSERT INTO guxg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","O bo maadi ti wan la u tienu meneki k o se o deni ki maadi: «Sɔni bi niba Jope ki baa yeni Siimɔ yua ke b gɔ yi'o Piaali. ");
INSERT INTO guxg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","O ba teni ŋa sawali yali ba gaa ŋa fini yeni a diegu. ");
INSERT INTO guxg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","N bo cili ki maadi'b ya yogu ke fuonŋanma bo jiidi b po nani lan bo jiidi ti po ciligi yeni. ");
INSERT INTO guxg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","N bo tiadi'i u tienu ñɔmaama yua yedi k: «San bo wuli yeni mi ñinma yimi ba wuli yeni fuonŋanma i. ");
INSERT INTO guxg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","L i ya tie k u Tienu teb'bi u paabu nani timi yaabi dugi Jesu Krisiti nni n baa tie ŋma ki yie u Tienu po i. ");
INSERT INTO guxg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ban bgadi li bona b bo ŋmini ki ji dondi u Tienu ki maadi «u Tienu n ŋa yaabi ki dugi o po biidi ke ban baa li miali» ");
INSERT INTO guxg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yaaba ke ti yonmidi po ke bo beli'b Jerusalemi lan bo cili yeni Etiani kuumi b bo gedi Fenesi Cipili yeni Antiosi. B bo maadi jufinba baba i u Tienu ñɔmaama. ");
INSERT INTO guxg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama b siiga nni b tianbi yaabi bo ñani Cipili yeni Sireni baa Antiosi ki waani Grekinba u Tienu ñɔmaama. ");
INSERT INTO guxg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","U Tienu nuu bo ye yemi ke bi niba boncianli la li dandanli ki ji dugi u Tienu po. ");
INSERT INTO guxg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Laabaal yua bo nua'b bo baa b tuba nni Jerusalemi jaandidɔgu kani, ke b sɔni Barnabasi hali Antiosi. ");
INSERT INTO guxg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wan bo pundi o bo la u Tienu ŋanbidi, o pali bo mani k o paani b pala kuli ki kuni u Tienu. ");
INSERT INTO guxg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kelima o bo tie ya nulo ke fuonŋanma ti dugidi ye yen'o i k niba boncianli bo taani o tienu po. ");
INSERT INTO guxg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ke Barna basi gedi Tarisi ki pan ba kpaani Soli. ");
INSERT INTO guxg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wan bo pan la'oo bo gedi yen'o hali Antiosi. Binmuli ke b taani b lieba u jaadidɔngu kani ki tundi b niba boncianli, Antiosi ke b cili ki yii'b Jesu ŋɔdikaaba. ");
INSERT INTO guxg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Li yogo bi tondikaaba bo ñani Jerusalemi ki jiidi Antiosi ");
INSERT INTO guxg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","B siiga nni yedi bo ye ke b yi'o Agabusi k o fii yeni o tagnmi ki maadi ke mi koma ba cua ŋanduna nni boncianli. Ke li bo ti cua Klodi yogu i. ");
INSERT INTO guxg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ke Jesu ŋɔdikaaba cuo ke b bo todi b naataani yaaba ye Jude ");
INSERT INTO guxg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","B bo tieni li todli b bo sɔni Barnabasi yeniSoli yeni i ligi ki teni b nikpela. ");
INSERT INTO guxg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lan yogu o baddciamo Herodi bo cuo u Tienu niba ke wangi ba fala. ");
INSERT INTO guxg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O kpaa Saaki San nijua yeni ki jugsiega i. ");
INSERT INTO guxg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wan bo la ke li mangi Jufinba wan cedi ban cuo Piali mɔ. Li bo tie jaama dan nni, ya jaama ke bi ŋmani kpanu yaali ki dabinli. ");
INSERT INTO guxg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wan bo cuo o, o bo kuani o ti yonmdi dieli nni o bo puogi sojenba caga na ke guudi o. O bo bua pagi jaama po n pendi yo wan sieni o bi niba siiga nni ki buni o. ");
INSERT INTO guxg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piali bo luo li yonmdieli nni ama u Tienuniba taanli bi jaandi o po. ");
INSERT INTO guxg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ya daali ke Herodi maali wan ba tieni o maama, Piali bo dua sojenba bonmlie siiga nni ki gɔa. ki luagi i kudisiseli ke soje bonlis se u bulñɔbu po ki guu li yonmdieli. ");
INSERT INTO guxg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","U Tienu maleki bo kua ki sedi li yonmdieli ke mi yenyenma yendi, k o pua piali ki fiini o ke maadi: «fii tonma» ke i kudisiseli ñani o nugu nni ki baa. ");
INSERT INTO guxg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ke maleki maadi o; «la a tiadi ki taa a taacaadi» ke Piali tieni. k o guani maadi o: La a gbadli ke ŋɔdi. ");
INSERT INTO guxg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ke Piali ŋɔdi maleki ki ñani. O ba bani ke maleki n tie yaala tie mɔni. o bo maali ke li tie dangdi ");
INSERT INTO guxg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ya yognu ke bi pendi cincinli ya guudika yeni liolo kani; bi ji bo pundi u bulñɔbu kani yaali tieni yeni ti kudi ki caa u dogu nni. ke li luodi li bá bi nunga nni, ke bi jiidi u sanu po ke maleki ji ŋa Paili. ");
INSERT INTO guxg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Piali n bo ti guani o kani ya yogu k o maadi: «N nuake yeni i mɔnmɔni ke u tienu sɔni omaleki k o baa ñani n Herodi nui nni yeni jufunba n bo guu yaala.» ");
INSERT INTO guxg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wan bo tieni li, o bo gedi Mali deni, San yua ke bi bo yi o Marki naá. Yaaba bo pia li dandanli bo taani li kani ki jaani. ");
INSERT INTO guxg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Wan bo pua li ganli ya yognu o jifaano bá ke bi yi o Rodi n cua ke ba luodi ");
INSERT INTO guxg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Wan bandi Piali nialu ya yognu o pali mangi k o sundi kaa luodi li ganli ki sani ki pan maadi yaaba ye deni nni ke Piali u bulŋɔbujabu kani. ");
INSERT INTO guxg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bi bo yedi o: «a gaadi yoo» Ama ke gɔ maadi ke li tie mɔnmɔni. Ke bi maadi: «o maleki i» ");
INSERT INTO guxg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ama ke Piali gɔ li tun ki pua li ganli ya yognu ke bi ti luodi li ganli ke bi la' o ke li yaalidi ba. ");
INSERT INTO guxg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ke Piali ka waani u nuu ke ban ya ŋmini ke maadi ba u Tienu n tieni maama ki ñani o ti yonbidi dieli nni. Ke o maad: «waani mani li bona Saaki yeni o naataani.» Lan puoli po yo k o gedi u kaantianu. ");
INSERT INTO guxg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lan bo fandi ya yogu u yangmadigu bo ye soje nba siiga nni kelima baa bo bani yaala tieni Piali. ");
INSERT INTO guxg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodi n bo kpaani o kaa la'o, buali sojenba, ki cabi ke ban kpaa'o. K o jiidi jude Sesare nni ki ye li kani. ");
INSERT INTO guxg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Horodi pali bo beni Tiri yeni Sidoni niba po. ke bi tani cua o kani. Ki waani Blasi o badciamo baanlo ke wan todi ba ban dɔnli yeni o bado kelima bi jiema kuli bo ña lan bado ya dogu. ");
INSERT INTO guxg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodi bo bili dayenli ki lani o badtiadi ki kali o bali kalikanu po, o bo maadi ki maadi ba mi maama. ");
INSERT INTO guxg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ke bi niwulgu yigni: ne tie u Tienu nialu laa tie nulo yaali ka!» ");
INSERT INTO guxg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Li yognu k o yonmdaano meleki cua ki pua 'o kelima o bo k teni u Tienu ti kpiagidi. Asidibila n bo pundi o po ke kpaa o. ");
INSERT INTO guxg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ama u Tienu maama bo yadbidi ki pugni. ");
INSERT INTO guxg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabasi yeni Soli bo gbeni bi tuonli Jerusalemi. Bi bo ñani li po ki tugi San yua ke biyi o Marc. ");
INSERT INTO guxg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Krisiti nitaanli yaaba n ye Antiosa siiga den pia bi sawalpuaba yeni bi bangikaaba. Bi yela den tie Banabasa, Simeyono ke b gua yi u o nijeli yeni silena yua Lusiyusa yeni Manayema yua k bi bo taani ki wubi o yeni Herodi yeni Suoli. ");
INSERT INTO guxg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ban bo loli u ñɔbu ki jaandi ya yogu, U Tieni fuoŋanma ṅ yedi: «Tugi mani Barnabasa yeni Sawuli ki piari ki seni ba bibá, ban ya tuuni min yini ba ya tuonli po.» ");
INSERT INTO guxg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lane, ban gua den loli u ñɔbu ki jaandi ki mia U Tienu, b den maani b nui bi jaba yeni po ki cabi ba ke bi gadi. ");
INSERT INTO guxg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","U Tienu Fuoma yua den sɔni Barnabasa yeni Solo yeni ke bi gadi Selusi dogu nni ki kua ku ñinbiagu nni ki duodi ki gadi Sipila kpendigili po. ");
INSERT INTO guxg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ban den pundi Salamina dogu nni, b den muandi U Tienu maama li balmaama bangma diena nni, Jufinba n den taagi naakani. Jan marika den tie b todka. ");
INSERT INTO guxg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ban den gɔgɔgdi ke pan puodi li kpendigli yeni nni kuli hali ke pan pundi Pafoso dogu nni. Lankani, b den laa o lingdi o yua n tie Jufi ke b yi o Bali Jesu yua n tie o Sawolpuadaano. ");
INSERT INTO guxg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","O den ye gufeneeli ban yi yua Sejiyusa Polusa kani. Gufeneeli yeni den tie yanfodaano. O den yini Barnabasa yen Solo kelima o bua gbadi U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","O lingdo yeni ban gua yi yua E limasa den yie bipo ki muandi ke Gufeneeli n da tuo li dandanli. ");
INSERT INTO guxg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lane Solo, Ban gua yi yua Polo k u gbie yeni U Tienu Fuoŋanma diidi o nangdi ki maadi o: ");
INSERT INTO guxg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Fini Satana big, a gbie yeni u nunfanma yeni mi biadma, a tie mɔmɔnmaado kuli ya yibali, a kan ŋa ki da ŋmaadi ti Diedo sɔni nni? ");
INSERT INTO guxg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mɔlane diidi, o Diedo nu ma a po n yeni, a bu juani mɔlane mono ki ji kan ya nua hali lan waagi. Li ŋunli yeni li bɔnbɔnli n jiidi Elymas po, wan juani ki ji kpaani yua n ba ŋmagidi o. ");
INSERT INTO guxg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lan yogu canba Sergusa n la yaala tieni yeni, wan dugi U Tienu po g dugni u gbadi U Tienu maama ke li ya ki lidi o. ");
INSERT INTO guxg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul yeni o yeglieba n ñaa halpaphos n ñinma po ki pan puodi Perisi dogu nni lan tie Panphylie ya diema. Ama Jan wan n ŋaaba ki lebdi Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paul yeni o lieba ñani Perisi ke ban pundi Antiosa, Pisidi diema nni. Lan kani ban kua u jaandiogu nni SSba dualgi kaali. ");
INSERT INTO guxg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ban cogi U Tienu bali yeni a Sawalpuala maama ki gbeni ya yogu, u jaandieogu nni canba n cua ki maadi ba: «N ninjaba, li ya sua ke i pia maama yaala ṅ bu paani bi niba pala yin maadi.» ");
INSERT INTO guxg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔli ṅ fii ki doni u nu ki maadi: «Yim yaaba ṅ tie Israyeli yaaba yim yaaba ṅ dondi U Tienu kuli n cengi ne: ");
INSERT INTO guxg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","U Tienu bo lugdi Israyeli buolu ki cedi k b poli Egipti dogu nni yeni u paalu po ke ti ŋanmi li dogu, ");
INSERT INTO guxg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ki juuni yeni ba mi fanpiema nni ke li bua pundi bina piinaa. ");
INSERT INTO guxg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Lani ya puoli, o den buoni nilanbuoli lele kanana diema nni ki puni o nibuolu ke o diedi bi diema. ");
INSERT INTO guxg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Lani ya bina kuli cuali den bua pundi bina kobina n bina piimu. La ya puoli, U Tienu den lugdi a bujiala hali ke pan pundi o Sawalpuolo Samuel Yogu. ");
INSERT INTO guxg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Lani ya yogu ke u dɔngni yaaba mia k b bua u bad, ke U Tienu teni ba Kis bijua Solo ke u tie Binjamini ya cugln yua ke u kali li kpaali po bina piina. ");
INSERT INTO guxg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ke U Tienu bo fiini o k gɔ kaani Davidi k u tie b bado. Li bo tie wan Davidi po i ke U Tienu bo tuodi ki maadi: «N la Davidi, Esayi bijua, ke u tie n pali nni big ke u tie min bua yaali kuli.» ");
INSERT INTO guxg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Wan ya yajanguni i ke Jesu mali nani U Tienu ṅ bo puoni maama yeni. ");
INSERT INTO guxg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Li cili ya yogu ke Jan bo cili ki tundi b niba yaala n tie ti biidi gbiandma ke Jesu daa cua. ");
INSERT INTO guxg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jan n sɔni u tuonli ki gbeni ya yogu, ke o buali ba: «I mali ke n tie ŋma i? N ki tie wani ka ama n puoli po, o nulo baadi ke n ki dagdi min lodi o tacagbani. ");
INSERT INTO guxg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","N ninjaba, Abrahama ya buona yen yaaba n ye siigi nni ki dɔndi U Tienu ne, b teni ti u paabu ya Laabaamanli. ");
INSERT INTO guxg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kelima yaaba n kua Jerusalema yeni b yudaano kuli ki bandi o, b bo tieni ki yedi yaala ke b cogi nni a jaandiena nni ki gɔ jaligi o. ");
INSERT INTO guxg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yeni ban bo li ki la yaala ke b baa jalgo kuli, ama mia pilati ke wan kpagu. ");
INSERT INTO guxg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ban pan tieni ki dugi yaala n bo li diani kuli, k b jiini o li dapɔnpɔnli po, g jiidi ki piigu li kakuli nni. ");
INSERT INTO guxg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama yeni lani kuli, U Tienu yiedi o b kpienma siiga nni. ");
INSERT INTO guxg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yaaba n bo ñani Galile yeni ki doni Jerusalema, laa u dana ŋa kuli wan yiedi. Ban n ji tie siedanba b niba nungi nni. ");
INSERT INTO guxg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Tim wani, ti ji baadi yeni ya Laabaamanli ke o bo puoni ti yajanba. ");
INSERT INTO guxg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","U Tienu cɔlni u puoni tim yaaba n tie b bidi yen po, ki yiedi Jesu bi kpienma siiga nni. Lani n cedi ke li Diani i biayeli tili nni dianjali a lie po ki maadi: «A tie n biga dinla, min n ji tie a ba.» ");
INSERT INTO guxg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wan gua yiedi o b kpiema siiga nni ke u gbanu n da bedi yeni i ke u ji maadi: «N ba teni Davidi yedŋanma yaala n ŋani. ");
INSERT INTO guxg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Lan yapo n cedi ke li gua den diani biayeli kadatiɔngu kani ki yedi«A kan cedi a nuŋamo n bedi.» ");
INSERT INTO guxg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kelima Davidi n bo sɔni U Tienu buama ki gbeni, o den kpe ke bi pii u o ba kani, ke u bedi. ");
INSERT INTO guxg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama U Tienu ṅ bo yiedi yua wan bo ki bedi. ");
INSERT INTO guxg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Lan wan yin bandi n ninjaba ke li tɔgni li jua kani k b muandi ti biidi piima. ");
INSERT INTO guxg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Lan tɔgni u kani yeni, yua n dugi kuli ji tie yua n tiegi bonli kuli nni, yaala ke li bu kan fidi ki tieni yeni Moyisi yikodi kadaaɔgu. ");
INSERT INTO guxg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Lan wan yin ŋanmi ki diidi i yula po, ke a Sawalpuala n yedi yaala yeni n daa tieni ki dudi. ");
INSERT INTO guxg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Diidi mani, yim yaaba n nundi lan yagidi, yin bia, kelima n suani yeni dana le, ya tuonli ke b a nulo ya yedi ke li kan tuo ke li tie mɔmɔni.» ");
INSERT INTO guxg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul yeni Barnabasa n maadi ke b gbeni ke ji kuni i, b niba n miaba sugli ki maadi ba, ke ban guani ya Saaba daali n ŋua ki gua tieni i tundi. ");
INSERT INTO guxg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Li tintaanli po n gbeni u jaandieli nni, b niba boncianli n naagi Pɔl yen Barnabasa kani, ban ŋanmi ke paani b pala ke maadi ba ke ban ŋanmi ki kuba U Tienu ŋalibalga. ");
INSERT INTO guxg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Saaba daali yal ji den tuani i, b niba boncianli ji den naagni ki cengi U Tienu Laabaali. ");
INSERT INTO guxg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Jufinba wan n ji la ke nuwulugi tigdi yeni, ban ji fii ki yedi ki naagni ke ji maadi ti mabiidi Pɔl n tundi yaala yeni po, ke gɔ sugidi o. ");
INSERT INTO guxg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ama pɔl yeni Barnabasa n ŋanmi ki maadi ba: «Ke li nan bu buali bani n kpia ki gbadi U Tienu maama t la ki yie, ke gua diidi ki sua ke li ki dagdi yeni ya midn kan ban k gbeni eni, mɔlawani, t ba ŋmagdi b canma po i. ");
INSERT INTO guxg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ki dugi U Tienu bo maadi t niini nni: «N siena ke ŋan ya tie yaaba k bani U Tienu ya yinyenma, k gadi yeni u faabu hali ki tinga juogi.» ");
INSERT INTO guxg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Yaaba n ki ban U Tienu n gbadi li maama ya yogu, k b pala mangi, k ji tieni U Tienu maama baliga. Boncianli yaaba n bo dagdi yeni ban kua U Tienu diema nni kuli daan ki dugi li maama po. ");
INSERT INTO guxg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","U Tienu ñɔmaama ji den yadi li dingbana kuli nni. ");
INSERT INTO guxg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama Jufinba bɔndi b jaba yeni b puoba yaaba n bo tie numɔnkuli, k b fii ki siedi Pɔl yen Barnabasa po tud ki ñam b dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ama ke Pɔl yeni Barnabasa piidi piidi b dogu nni tanbiini n taana po. Lan yo ki gadi Icone dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ke b ŋɔdkaaba pala ji bo mani k b gbie yeni U Tienu Fuoŋanma. ");
INSERT INTO guxg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","O bo pundi Ikone ke Poli yeni Barnabasi taani kua jufinba n bangi u Tienu maama naani ki maadi k jufi Greki boncianla gaa bi maama. ");
INSERT INTO guxg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama Jufinba yaaba bo k pia kangbadma tagma nani bi nilanba yeni, bo fiini u tonu bi nijanba po i. ");
INSERT INTO guxg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Poli yeni Barnabasi bo waagi ki li kani, ki maadi yeni li papaali u Tienu paalu po, ki tiendi sieda o ŋanbili tondo Jesu kristi nni. bi bo tien li ke ti bonninnadi yeni u yaaligdu n yaa tie Poli yeni Barnabasi nuu po i. ");
INSERT INTO guxg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ama i dogi boncianla niba bo paadi; Tianba bo ye jufinba po bi tɔba mɔ u Tienu tuonsɔnba po. ");
INSERT INTO guxg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ya yognu ke yaaba bo jaandi yeni jufinba bo juogi yeni bi yudanba ke ban pua Poli yeni Barnabasi ki lugdi ba a tana ki kpaa bi. ");
INSERT INTO guxg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Poli yeni Barnabasi n bo bandi li bonla bi bo sani kua Listri yeni Derbe yeni ya dogi kpia. ");
INSERT INTO guxg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","lan kani ke bi bo wangi o labaŋanmo. ");
INSERT INTO guxg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listri dogu nni ja bá bo ye ki mali ki tie wabi kaa bo bani cuoni. ");
INSERT INTO guxg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Li ja bo cengi Poli k o maadi. Ke Poli maani o nubina o po ki nuali sua o pia ti dugidi yeni wan paagi. ");
INSERT INTO guxg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","lani k o maadi o yeni paama: «fii a sedi a taana po» k o ja yugi ki cuoni. ");
INSERT INTO guxg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","U nuwulgu n bo la Poli ntieni yaala ke bi doni i niali ki maadi Liakonian maama nni: «i tieni jiidi ti po nani bi naba yeni. ");
INSERT INTO guxg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ke bi bo yini Barnabasi «zesi» Poli «merikiri», kelima bi bo tie mamaadi jala i. ");
INSERT INTO guxg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zesi yika yua k o jaandidieli bo ye u dogu bulñɔbu kani bo cua yeni i nee yeni u diñɔbu caba wani yeni u nuwulgu bo bua ban yidi salaa i. ");
INSERT INTO guxg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ama bi tuonsɔnba Poli yeni Barnabasi n gbadi lani bi bo padi bi tiadi ki peli kua u nuwulgu ki yigni ");
INSERT INTO guxg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ki maadi «bi jaba be n cedi ki tie lani.» ti mɔ nufosaalba i nani yenba yeni mi buama nai yenba. Ti cua yeni o labaŋanmo yali ke yin cedi ti bonyuodi tienme ki uTienu yua fuo po ki tagi ki tinga yeni tanpoli, mi ñinciama yeni yaala ye leni kuli. ");
INSERT INTO guxg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ya yogu po o bo cabi ke dongbali kuli ncuoni u sanu nni. ");
INSERT INTO guxg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ba yeni wan ki ŋa ki tie kasieda wan tie yua ki tie mi ŋanma, ki tieni yi tanpoli taaga yeni a kpañiŋana ki je ki li pamanli nni. ");
INSERT INTO guxg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yeni lan maama kuli Poli yeni Barnabasi fidi cedi ke baa tieni bi salaa. ");
INSERT INTO guxg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Antiosi yeni Ikoni Jufi tianba bo baa ki maadi u nuwulgu ke gbadi niima nni. kee bi lugdi poli a tana ki fili o ki ñani o u dogu nni, ki maali k o kpe i. ");
INSERT INTO guxg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ama u Tienu ŋɔdikaaba n bo kaani lidi o ya yogu, k o fii ki kua u dogu nni. Ya daali ŋɔdi k o gedi Derbe yeni Barnabasi. ");
INSERT INTO guxg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ban bo tundi u Tienu ñɔmaama ke bi ŋɔdikaaba ti ñani li dogu nni ke bi guani Listri, Ikoni yeni Antiosi. ");
INSERT INTO guxg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bi bo cɔgdi yeni ya pugdi bi ŋɔdikaaba tagnm ki gɔ paandi bi pala ke ban ya ye ti dudugdi nni ki maadi. «ti bo la fala boncianla yo ki fidi kua u tienu diema nni» ");
INSERT INTO guxg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ban bo kaani a nikpela a jaandiena caga nni, li puoli po ke bi jaani ki loli bu ñɔbu, bi bo taa ba ki piani u Tienu i ban dugi yua nni. ");
INSERT INTO guxg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ke bi puodi Pisidi ki pundi Panfili. ");
INSERT INTO guxg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bi bo muandi u tienu laabaali Atali. ");
INSERT INTO guxg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ki ñani lan kani ke bi cuo Antiosi sanu naani kani k u Tienu ŋanbidi bo ye yenba ke ban sɔni bi tuona ki tii. ");
INSERT INTO guxg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ban bo pundi Antiosi bi bo yini a jaandien nni caga yaaba kuli, ki togdi ba ya bona kuli ku Tienu bo tieni yenba yaala kuli yeni wan bo findi bi nilanba dandanli nandi. ");
INSERT INTO guxg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bi bo ye yeni bi ŋɔdkaaba ke li waagi. ");
INSERT INTO guxg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","nitianba bo ñani jude ki jiidi ki tundu i naataani ki maadi: «a yaa kɔndi nani lan buali maama Moyiisi bal tili nni a kan baa gaa po.» ");
INSERT INTO guxg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Poli yeni Barnabasi n bo cendi ba ke ki tieni li buoli yenba, i naataani bo bo cuo ke yeni Barnabasi n do bi tuonsɔnba yeni a nikpela kani Jerualemi a ki kali li laabaalo po. ");
INSERT INTO guxg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nani ban bo tie li jaandieli tondi yeni ban tɔgni Fenisi yeni ki wangi bi nilanba ke ban tuo ki gaa Jesu maama. Bi bo cua yeni li pamanli i naataani kuli po. ");
INSERT INTO guxg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ban pundi Jerusalemi li jaandieli nni tuonsɔnba, yeni li nikpela n gaa ba ban togdi ba u Tienu n tieni yaali kuli yenba. ");
INSERT INTO guxg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lan yognu nitianba bo ye Falisiani nba cagli nni ke mɔ bo tuo gaa, bo fii ki maadi: «Li bo ŋani ki dagdi ke ti kɔndi ba ki cedi ban ya ŋua moyiisi bali maama» (moyiisi yikodi maama) ");
INSERT INTO guxg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bi tuonsɔnba yeni li jaandieli nikpela bo taani kali ki ba diidi li maama po. ");
INSERT INTO guxg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bi bo dadi li maama po ki li waagi Piaali n fii ki sedi ki maadi bi. «I bani k u tienu bo tieni mi lugdima i siiga nni li waagi boncianla, ke n ñɔbu po bi lanba n gbadi u Tienu laabaŋanmo ki gɔ tuo ki dugi n po. ");
INSERT INTO guxg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ke u Tienu bani yua kuli ya yantugu, tieni ba kasieda ki tem ba mi fuoŋanma nani wan tieni ti po maama. ");
INSERT INTO guxg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yeni ke waa tieni paadnma tinba yeni bani siiga nni ki ŋuudi bi pala li dandanli nni. ");
INSERT INTO guxg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mɔla be ya po i ke i kpaani u Tienu mi maama ki taadi ya tuga kpiagi ki bua ki tuni bi ŋɔdikaaba ya tuga ke ti báa, mɔno bo ki fidi tugi? ");
INSERT INTO guxg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ama ti pia li dandanli ke ti ba baa gaa po ti yonmdaano Jesu ŋanbidi po nani bani yeni.» ");
INSERT INTO guxg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ku nuwulugu kuli ŋmini ki gba Poli yeni Barnabasi ke b maadi u Tienu n bo teni ke bi tieni ya bonninandi yeni ya yaalidma bi nilanba siig nni. ");
INSERT INTO guxg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ban bo maadi ki gbeni, Saaki bo gaa mi maama ki maadi: “n naataani songi mani n maama. ");
INSERT INTO guxg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simo bo togdi lan bo tieni maama k u Tienu todi yeni o ŋanbidi ke bi nilanba ń mɔ fidi ki lugdi bi siiga bi niba ban doni o yeli. ");
INSERT INTO guxg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","O sawalipualo laabaalo taani yeni lan bo dianiki yedi yaala. ");
INSERT INTO guxg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Lan bona puoli po yo ke n ba ti guani ki gɔ sieni Davidi diegu yugu n bo ba. Nba ŋmagdigu ki ŋanbi siegu. ");
INSERT INTO guxg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Yeni ya niba sieni ba kpaani o yonmdaano, yeni ya nilanba gaa o yeli. ");
INSERT INTO guxg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Oyonmdaano yua bo tieni a bona ke bi bandi ti ya yogu nni n maadi yaala n yeni. ");
INSERT INTO guxg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Lan cedi ke n maalima tie ke ti kan ya ŋmadi bi nilanba yaaba ya pala ŋmagdi u Tienu po. ");
INSERT INTO guxg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama ti diani ba ke ban da jɔgni bi ba yeni i buli jiema, ki cuo bi ba yeni mi cunconma buali kuli k gɔ daa di mi sɔma. ");
INSERT INTO guxg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ya bina bo pendi, bi niba bo dogu kuli nni ki cogi moyiisi balmaama ki gɔ wangi u Tienu laabaalo a jaandiena nni saba daali. ");
INSERT INTO guxg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Li bo naani li ŋani bi ŋɔdikaaba yeni u jaadidɔngu nikpela po, yeni u jaadidɔngu po ke ban lugdi Jude yua ke b yi o Barsabasi yeni Slasi, u jaandidɔngu yudanba, ki sɔni ba Atiosi yeni Poli yeni Barnabasi. ");
INSERT INTO guxg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bi bo diani nanda i: «bi tuonsɔnba, a nikpela yeni i naataani, n diani i naataani yaba tie nilanba Antiosi, Siri yeni Slisi, ti fuondi i. ");
INSERT INTO guxg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ti gbadi ke bi niba ñani ti siiga nni ki gedi i kani ke ti naa puni ba sanu, ki ŋmadi i yama yeni bi tunda. ");
INSERT INTO guxg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Li bo baa ŋani ti kuli po ke yi cabi ti ti lugdi bi niba ki sɔni ba i kani bani Barnasi yeni Poli, ");
INSERT INTO guxg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yaaba bo taa bi miali ki cabi ti yonmdaano Jesu Kristi po. ");
INSERT INTO guxg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ti gɔ sɔni Jude yeni Silasi ke bi ba maadi yi a bona. ");
INSERT INTO guxg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Lani li ŋani ki dagdi fuoŋanma po yeni tinba mɔ ya po ke ti daa tuni bonli ke laa ŋani. ");
INSERT INTO guxg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Lani n tie ki kubi i yula yeni n padjiema yi gɔ daa ŋmani mi sɔma yeni ya bona ke bi padi i buli, yi kubi iyula yeni mi cumconma buali kuli. i ya kubi i yula yeni lani bona li baa ŋani i po. n cabdi i n yeni.» ");
INSERT INTO guxg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Lani ke bi guani sɔni ba, ban bo pundi Antiosi ki taani u niwulgu ki teni ba li tili. ");
INSERT INTO guxg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ban bo cogi li ya yogu ke bi la li papaali. ");
INSERT INTO guxg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judeyeni Slasi bo mɔ bo tie sawalpuali ki fiidi i naataani yeni u Tienu ñɔmaama ki gɔ paagi bi pala. ");
INSERT INTO guxg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ban bo tieni dana li po i naataani bo guani teni ba li lanbonmanli ke bi mɔ ń guani kuni yeni laafia ki pan teni yaaba sɔni ba. ");
INSERT INTO guxg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Li bo mani Silasi po ke wan ya ye. ");
INSERT INTO guxg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ama Poli yeni Barnabasi bo ye Antiosi yeni nitianba boncianli bi bo wangi ki gɔ tundi ti yonmdaano ñɔmaama. ");
INSERT INTO guxg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Lan tieni dana ke Poli maadi Barnabasi: «ti guani i diidi inaataani ya dogi nni ke ti waani ti yonmdaano ñɔmaama ki diidi ban ye maama.» ");
INSERT INTO guxg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabasi bo bua wan gedi yeni San yua ke bi yi o Maarki. ");
INSERT INTO guxg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama ke Poli diidi sua ke laa dagdi yeni wan gedi. Wani ji bo ŋaa ba hali Panfili dogu nni kaa ji bo todi ba bi tuonli nni. ");
INSERT INTO guxg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ke mi paadma tieni bi siiga nni ke bi yadi lieba. Ke Barnabai taaa Marrki ke bi ji bo gedi Cipri. ");
INSERT INTO guxg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ama Poli bo lugdi Sllasi ke wan yegi yeni o, ke o naataantieba mia ke ti yonmdaano ŋanbidi n ya ye yeni owan caa naan kani. ");
INSERT INTO guxg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","O bo puodi ki gedi Siri yeni Silisi ki paagidi li jaandieli yaaba pa. ");
INSERT INTO guxg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔli ń pundi Derbi yeni Listri mo, ki sua ke Jesu ŋɔdka ke bi yi o Timote, ke o ye likani, Juufipua yua n daani U Tienu nni ya bijua, ke o báa tie Gresi yua. ");
INSERT INTO guxg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ya kpiiba n den ye Listri yeni Ikoni den tieni o po kasiedi ŋamo ");
INSERT INTO guxg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔli den bua wan yegi yeni o ki gedi u sanu; lanwani ii, ke o ga o ki kuani o ku ciagu, kelima Juufinba den ye li dogi nni, ki bani ke o báa tie Gresi yua. ");
INSERT INTO guxg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ban den caa ya dogi nni kuli, bi den caagu u tondu ti jaandiedi nni ke ban cɔlni Jesu ŋɔdkaaba yeni Jerusalema nikpelba ń den diani ki bili ya yikodi. ");
INSERT INTO guxg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","U Tienu nitaanli dudugdi den pugni, ki go yabdi ki pugdi daali kuli. ");
INSERT INTO guxg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔli yeni o yegni den tɔgni ki ñani Friji yeni Galatia diema nni, ki sua ke foŋanma den kuani ba ke ban da gedi Asi diema nni ki kpaandi, ki tundi mi maama. ");
INSERT INTO guxg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ban nagi Misia, ban bigni ke ban gedi Bitinia nni, ama Jesu foŋanma den ki puni ba u sanu. ");
INSERT INTO guxg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ban pendi ki balni Misia, ki jiidi Truasi dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Li bonlegdikaali ń legdi Pɔli po ku ñiagu nni: Maseduani jua den se likani, ki yi o ki tua: “Cua Maseduani ki todi ti.” ");
INSERT INTO guxg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Li bonli ń legdi Pɔli po, ke ti jagi li yogu ke ti bobni ki fii ki gedi Maseduani kelima U Tienu yi ti ke ti tundi ki waani o laabaalŋamo bi ya po i. ");
INSERT INTO guxg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tin fii Truasi, ti taa u sansieru ki gedi Samotrasi, li daalieli tin pundi Neyapoli. ");
INSERT INTO guxg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tin ñani li kani, ti gedi Filipi yu n tien Maseduani ya dociamu, ki tie ya dogu n yabi ki cie, li diema nni ki den ŋua Roma bali, tin kali li kani dana bá ");
INSERT INTO guxg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Saba (mi fuodma daali ń pundi, tin ña ki fagdi yeni bu bulñɔcianbu, ki gedi bɔngu bá kani naani ke ti maali ke tin kadi jaandieli (jaandi yaali). Ti den kali ki maadi yeni ya puoba n taani ki cua likani. ");
INSERT INTO guxg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Bi siiga nni ban yi ya pua Lidia, ke o tie Tiyatira pua, ki pugi U tienu den cengi ti. O Diedo ń luodi o pali ke wan ya fiini Pɔli ń maadi ya maama. ");
INSERT INTO guxg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ban tieni o mi ñinwulma bogdili, ki yadi mi yedŋanma o diegu po, ke o mia ti ki yedi, «I ya diidi ki sua ke n duu U Tienu po, yin cua n deni, ki ya ye.» Ke ti tuo o maama ");
INSERT INTO guxg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Li sua ke ti caa i jaandi, pua ke o bu ti baadi ń cendi ti. O den kuandi o yonbdanba ŋalmani li baabuli po. ");
INSERT INTO guxg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","li pua den ŋua tinba yeni Pɔli ki kpaandi ki tua, “Ya niba ne ti Mi tanpojoma Tienu tuonsɔnba i, bi tundi ki wangi yi mi faabma sanu i.” ");
INSERT INTO guxg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","O tieni yeni ke laa luo dana bá. Ama Pɔli pali ń beni o po, wan gbagi ki yedi ki cicibiadga, “N maadi a Jesu Kiristi yeli po, ña o niinni” Ke ki ñani ki yaadi ki ŋa o. ");
INSERT INTO guxg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","O canbàanba ń la ke bi ŋalmani dandanli bodi, ke bi cuo Pɔli yeni Silasi ki gedi yeni ba bi paatieba kani. ");
INSERT INTO guxg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ban kuani ba ti buudi yudaano kani, ki maadi, “Ya niba ne kuandi li ŋmadli ti dogu nni. Bi tie Juufinba i, ");
INSERT INTO guxg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bi tundi ya bona ke Roma yikodi ki tuo ke lan ga bii lan cɔlni.” ");
INSERT INTO guxg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bi dogtieba den taani ki fii, ki yie Pɔli yeni Silasi po, ke ti buudi danba biidi bi pala, ki landi bi tiadi, ki papadi, ki cabi bu ñɔbu ke ban pua ba a gbana. ");
INSERT INTO guxg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ban pua ba ki gbeni, ki cuo ba ki ban luoni li kpaadidieli nni, ki puogi li kpaadidieli guudka ke wanya guu bonŋanla. ");
INSERT INTO guxg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wan gbadi ban bili o ya tuonli, ke o kuani ba liiga po kpaadidieli nni ki pilni bi taana i kudseseli. ");
INSERT INTO guxg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ku yɔgsiigu ń yɔgdi, ke Pɔli yeni Silasi yiini i yani ki dondi U Tienu, ki jaandi, ke ya kpaada n sieni cengi ba. ");
INSERT INTO guxg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Li ludli nni, mi tindigbima ń tieni, ki migi li kpaadidieli fiagli, lanyognu, a bulñɔna kuli ń luodi, yuakuli ya kudseseli ń cie ki baa. ");
INSERT INTO guxg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Li kpaadidieli guudka ń findi mi guama nni ki sua ke a gana kuli yaa, wan nɔdi o jugsiega ke o ba muu ki kpa o yuli, kelima o bi tama ke a kpaada kuli sani ki ciadi i. ");
INSERT INTO guxg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ama Pɔli ń tiani paama ki maadi, “Da tieni a yuli bonbiigu keli maa tikuli ye nekanba i. ");
INSERT INTO guxg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Li kpaadidieli guudka den mia ke bi yendi u kaanu, ke o sani ki kua ki digbi yeni ti jawaandi ki baa ki gbaani Pɔli yeni Silasi nintuali. ");
INSERT INTO guxg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ki ñani ba, ki maadi “N Diedi n ba tieni ledi i ki baa mi faabma?” ");
INSERT INTO guxg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ban jiini o “Ya duu O Diedo Jesu Kiristi po, a ba baa mi faabma fini yeni a dansanu kuli.” ");
INSERT INTO guxg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ban maadi o O Diedo maama, wani yeni odiegu nni yaaba. ");
INSERT INTO guxg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lanyognu, li kpaadidieli guudka ń taa ba li ñiagu mɔno, ki gedi yeni ba o deni, ki ŋuudi ŋuudi bi nala, wani yeni o deni yaaba kuli ń tuo ban tieni ba mi ñinwulma bogdili yenma. ");
INSERT INTO guxg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wan kuani Pɔli yeni Silasi o dieli nni, ki seni ba mi jiema, wani yeni o diegu nni yaaba kuli pala ń mangi yeni wan tuo ki ga U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lan fandi, ti buudi yudanba ń sɔni u tondu ban maadi li kpaadidieli guudka ke wan luodi ki ŋa bi niba yeni ban ña. ");
INSERT INTO guxg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","O guudka ń caa Pɔli u tondu, ki maadi, “Ti buudi danba sɔni u tondu ke ban maadi nni min luodi ki ŋa yi yin ña: mɔlane, i ba fidi ki ña yeni mi yanduanma. ");
INSERT INTO guxg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ama Pɔli ń maadi ba, “Bi pua ti asala siiga, ki naa buni ti, yeni tin tie Roma yaaba kuli - ki luoni ti li kpaadidieli nni. Bi jibua ban luodiki ŋa ti li wuoli nni bii? N, n! Ban cua bibá ki luodi ti” ");
INSERT INTO guxg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","O guudka ń caa ti buudi yudanba u tondu, ban gbadi ke Pɔli yeni Silasi tie Roma yaaba, ti jawaandi ń cuo ba. ");
INSERT INTO guxg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ti buudi yudanba ń cua ki mia ba sugli, ki luodi ki ñani ba, ki maadi ba ke ban ña ki fagdi yeni bi dogu. ");
INSERT INTO guxg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔli yeni Silasi ń ña li kpaadidieli nni ki cua Lidia deni. Pɔli yeni Silasi ń la bi kpiiba, ban paani bi pala, ki fidi ki ña li dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ban bo tɔgni pendi Afipoli yeni Apoloni ya dogu nni ban pundi teslonika ya dogu nni Jufinba bo pia li jaandieli. ");
INSERT INTO guxg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nani Poli n bo limaani ki tiendi maama, o bo kua taani yenba mi fuodma dan taa nni, o bo maadi yenba yaala tie i diani bundma. ");
INSERT INTO guxg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Poli bo pɔbdi li tili ki cogi ki ŋanbi wan ba ke li tie buama yaala ke Kristi la fala ke gɔ fii bi tinkpiiba kani. o bo yedi: «Jesu yua ke n yedi n tie Krisit» ");
INSERT INTO guxg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jufinba siiga nni bi tianba bo tuo ki taani Poli yeni Silasa po. yeni greki nba yeni bi puoba yaaba tie gmadkaaba yeni u niwulgu. ");
INSERT INTO guxg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ama Jufinba yaaba n pia kangbadima yeni ki nanga bo a nibiada ki daaga po, ki taani o niwulgu ki fiini ti fuudi u dogu nni. Bi bo gedi ki pigni Jason ki bua cuo Poli ki gedi yeni o o niwulgu nni. ");
INSERT INTO guxg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ama Ban boo la'og, bi bo fili Jason yeni o kpiiba i ki caa yenba u dogu nni bujiala kani ki yigni: «Ya niba n gmadi u dogu mɔ pundi ne kanba» ");
INSERT INTO guxg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Joson bo n ga ya niba o deni po bo yiedi sesari bali maama ki yedi: ke baditiano ye ki yi Jesu. ");
INSERT INTO guxg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","o niwulgu yenu u dogu banda n gbadi li maam li bo yagi bi yama. ");
INSERT INTO guxg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bi bo ti pani Josoi yeni o lieba po ke bi ñani ba ki ŋa. ");
INSERT INTO guxg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Li daali ñiagu ke bi taa Poli yeni silasi ki gedi yenba Bele ban bo pundi bi bo kua Jufinba bangima dieli nni. ");
INSERT INTO guxg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ya Jufinba bo ye lan dogu nni bo tie nimɔnba ki cie Tesalonik nba bi bo kuani bi yama yeni i mɔnmɔni u Tienu maama bangima nni ki ŋanbi diidi daali kuli u Tienu maama diani n maadi yaala ya tie mɔnmɔni. ");
INSERT INTO guxg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Lan bo cedi ke bi siiga nni bi niba bo dugi, yeni Greki nba puoba yeni bi jaba yaaba. ");
INSERT INTO guxg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ama Tesaloni Jufi nba n bo gbadi ke Poli maadi u Tienu maama Bere ke bi gedi ki gua fiini o nuwulgu. ");
INSERT INTO guxg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Li yognu ke Poli kpiiba gba ki sɔni o mi ñinciama po; Ama ke Silasi yeni Timote wani ye lan kani. ");
INSERT INTO guxg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Yaaba bo ciani Poli bo gedi yeni o hali Ateni. Ban bo ŋa o lan kani ke bi maadi ba Silasi yeni Timote po ke wan tuodi cua bi kani. ");
INSERT INTO guxg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Poli n bo guu ba Ateni o tagnma bo yagi kelima o dogu yeni kuli bi gbie yeni i buli ");
INSERT INTO guxg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yeni ke poli kua li jaandieli nni ki maadi yeni Jufi nba yeni ya niba bo jaani u Tienu. yeni yaaaba ko bo laadi ba daali kuli bi niba tantaankaanu kani. ");
INSERT INTO guxg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ama Epikiriani yeni Stihisiani nba gbabanda bo kpagi'o. ke bi tianbi yedi: «o maciandaano bua maadi be i?» ke bi tianba tua ke: «li naani o kelima o bo wangi ba yesu yeni mi bi tinkpienba findnma. ");
INSERT INTO guxg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ke bi taa Poli ki gedi yeni o Aleopasa kani ke yedi: a ba fidi ki wani ti ke gbadi ŋan bangi ya bangiciama yeni? ");
INSERT INTO guxg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kelima a maadi a boncana ti tuba nni, lan ya po ke ti bua bandi ŋan maadi ya bonla yeni niima nni.» ");
INSERT INTO guxg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ama Atenasa dogtieba yeni ya canba n bo ye li kani biani bi yaama ki ya cengi aboncana. ");
INSERT INTO guxg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lani ke Poli bo fii ki sedi Alopaja nituali nni li yedi: «yinba Ateni yaaba n la ki kuni i yama i jaandi. ");
INSERT INTO guxg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kelima min tɔgni i dogi nni naan kuli n la yi tagi tagi yaala ki dondi ki la yi ban jaan naani ke bi diani: Ya Tienu ke yi bani yi». Lanwani i jaani mi yanbɔnma nni min yei yi yaala n yeni. ");
INSERT INTO guxg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","U Tienu yua tagi ŋanduna yeni ya bona ye len nni kuli ki tie tanpoli yeni ki tinga kuli yomdaano yekaanu kan ya tie bi niba n taa bi nugi ki maa ya bonla ki yi jaandieli ka. ");
INSERT INTO guxg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Waa luo bonli ba kuli ki bua bi nisaalo nugu n sɔni o po, kelima wan mono n teni bi niba li miali yeni mi fuoma yeni yaali ye kuli. ");
INSERT INTO guxg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","UTienu bo tagi jayedo baba i k o mali ya niba yeni ya mabuoli ye ki tinga ne kuli po. O bo tuodi ki bili bi po u siagu yognu yeni i yeyienkaani bianu. ");
INSERT INTO guxg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Bi niba bo baa kpaani u Tienu i. Ki ŋanbi kpaani o ki la 'o. kelima waa fagi yeni ti. ");
INSERT INTO guxg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ama wani ya po i ke ti cuoni ki fuo, yeni ti yema kuli, Yeni ke yi ssiga nni o lonpualo yedi. ti mo tie o ya yaabila i. ");
INSERT INTO guxg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Lan ya po nani ti tie uTienu bila yeni li buali, tin daa maali nani wani u Tienu naani nani wula yeni. bii ligi lan yaa ka tanli yua ke o kpekpiedo kpiedi ke li tie o nisaalo maalma. ");
INSERT INTO guxg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ti bi ki bani puu ya yognu k u Tienu bo cɔdi ti biidi, ama mɔla u Tienu wangi bi niba kaana kuli ke ban lebdi bi yama. ");
INSERT INTO guxg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","UTienu bili ya daali ki go gandi o nitegika k o ba bu ŋanduna i mɔnmɔni. U Tienu bo teni lan nilo i mɔnmɔni bignma k o fii bin tinkpiba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Atanasi yaaba n bo gbadi ke Poli maadi bi tinkpienba fiima yeni bi tianba bo ñuadi o ama ke bi tɔba mɔ bo yedi: «ti daa ba faa cengi o maama datɔli.» ");
INSERT INTO guxg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Li po n pendi ke Poli yaadi ki ŋaa ba. ");
INSERT INTO guxg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ke nitɔba cua bi kani ki dugi li maama po yeni Denis, Aheropajiti, pua bá ke bi bo yi o Damaris yeni bi tɔba. ");
INSERT INTO guxg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lanya bona ń́ pendi, Pɔli ń ñ̃a Ateni, ki gedi Korenti. ");
INSERT INTO guxg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Likani, wan cendi Juufi ke bi yi o Akila, ke bi mali o Pɔnti, ke o dá ñani Itali ki pundi, wani yeni o denpua Prisila, kelima Kulodi den ñani bu li ñɔbonli ke Juufinba kuli ke ban ña Roma dogu nni. Pɔli ǹ tuogi ba. ");
INSERT INTO guxg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kelima bi den taa kpenkpendtuonli i, wan kali yeni ba ban ya tuuni, kelima bi den caandi ti jondi i ki kuadi. ");
INSERT INTO guxg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pɔli den wangi mi maama li jaandieli nni mi fuodma daali. O den maadi ke Grekinba yeni Juufinba tuo ki ga o maama. ");
INSERT INTO guxg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ama Silasi yeni Timote ń ñani Maseduani, ki jiidi ki cua, Foŋanma ń niini Pɔli wan kadi ki waani yeni i mɔni ke Jesu n tie Kiristi. ");
INSERT INTO guxg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Juufinba ń yie, ki sugdi o, Pɔli ń yogi o tialakaadi bi po, ki maadi ba, “I sɔma ń guani ki wuli i yucela po; Mini naa pia tagliba kuli. Lan cili mɔlane ki ji ya caa, n ba gedi bi nilanba kani i” ");
INSERT INTO guxg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ke o ñani lankani, ki gedi Titiyusi Justusi, ya ja n pugi U Tienu deni. O deni den ki fagi yeni li jaandieli, ");
INSERT INTO guxg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, li jaandieli yudaano den taani ki daani O Diedo nni wani yeni yaaba n ye o deni kuli; ke Korenti niba yaaba n gbadi li maama kuli den tuo ki duu U Kiristi nni yeni mi ñinwulma bogdili. ");
INSERT INTO guxg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ke O Diedo legdi Pɔli po ti dangdi nni ku ñiagu ki maadi, “Da jie, ama ya maadi ki da ŋmini. ");
INSERT INTO guxg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kelima, N ye yeni a, ke obakuli kan bigni ke wan tieni a yaali n bia, kelima n pia bi niba ke bi yabi u dociamu ne nni” ");
INSERT INTO guxg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔli den tieni li kani binli yeni bina luoba, ki tundi ba, ki wangi ba U Tienu maama. ");
INSERT INTO guxg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ama Galio ń tua Asihaya gufeneri, Juufinba ń fiini ki nanga Pɔli po, ki gedi yeni o ti buudi danba kani, ");
INSERT INTO guxg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ki maadi, “Ya nilo ne bɔndi bi niba ke bi pugi U Tienu, ama ti yikodi naa cabi yeni” ");
INSERT INTO guxg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Lanyognu, Pɔli ń ya bua ga mi maama, Galio ń maadi Juufinba, “Yinba, Juufinba, li ya bi tie jodi bii tuonbiadi maama, li bi baa pia u sanu ke min maadi yeni yi. ");
INSERT INTO guxg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama nani lan tie lanbona yeni yela maama yeni i maabilkacema yeni ii, yinba mɔno ń ŋanbi ma i ŋmiali nni. N ki bua lan ya maama buudi daano.” ");
INSERT INTO guxg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galio ń beli ba ki ñani ba ti buudi diegu nni. ");
INSERT INTO guxg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Lanwani ii, bikuli ń taani ki cuo Sosteni, yua den tie li jaandieli yudaano, puapua o ti buudi diegu cancanli. Ama Galio nan den ki songi ban tie yaali. ");
INSERT INTO guxg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔli den waagi li kani waamu yeni o kpiiba, ki ti fii ki cabi ba ku kua ku ñinbiagu ki gedi Siri wani yeni Prisila yeni Akila. Wan ba fii li ñinbiayaali kani, o den cedi ke bi kuo o Sankreya dogu nni kelima o den niani U Tienu ke o baa ŋua Nasaleti ñɔmaama i. ");
INSERT INTO guxg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ban pundi Efesa, Pɔli ń cabi Prisila yeni Akila lankani, ki gedi obá li jaadieli nni ki ban ya tundi Juufinba. ");
INSERT INTO guxg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bi den mia ke wan kali bi kani waamu, wan yie. ");
INSERT INTO guxg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","O den cabi ba, ki yedi ba, “N ba guani i kani li ya tie U Tienu buama.” ki fii Efesa. ");
INSERT INTO guxg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pɔli ń pundi Sesare, wan do, ki fuondi Jerusalema Kiristi nitaanli, ki ñani lankani, ki jiidi ki gedi Antiyosi. ");
INSERT INTO guxg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Wan kali likani waamu, wan fii likani ki toli Galatia yeni Prijia diema nni ki ya paandi Kiristi ŋɔdkaaba kuli. ");
INSERT INTO guxg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Juufi ja, ke bi yi o Apolɔsi ke bi mali o Aleksandri ń cua Efesa. O den bani mi maama, ki go paa mi dianma nni. ");
INSERT INTO guxg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bi den kuani o O Diedo maama tundma cogu. O yantiali den tiegi yeni U Tienu maama, o den maadi ki go maali ki li tuagi yeni Jesu maama. Ama o den bani Jan ñinwulma bogdili baba i. ");
INSERT INTO guxg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolɔsi den fuoni o yama, ki maadi li jaandieli nni. Ama Prisila yeni Akila ń cengi o maama, ban piadi yeni o ki ŋanbi ki waani o O Diedo sanu. ");
INSERT INTO guxg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Wan den bua wan pendi ki gedi Acihayia, o kpiiba den paani o pali, ki diani li tili, ki teni Acihayia Kiristi ŋɔdkaaba ki waani ba ke ban ga o cangu. Wan pundi likani, o den todi U Tienu ŋanbli ń cedi ke yaaba duu Jesu po. ");
INSERT INTO guxg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolɔsi den yaadi Juufinba asala siiga nni, ki nia yeni ba, ki taadi i diani banma ki wangi ba ke Jesu n tie Kiristi. ");
INSERT INTO guxg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Li sua ke Apolo ń bo ye Korenti, Pɔli den tɔgni ya dogi n ye a juana nni kuli, ki ban pundi Efesi dogciamu nni, ki kadi yeni Jesu ŋɔdkaaba siiga tianba. ");
INSERT INTO guxg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pɔli ń yedi ba: «Yin dugi U Tienu po yeni, i baa mi Foŋanma aa?» Ban ŋmiani o: «N n, tii gbadi ke bi maadi Foŋanma maama mɔno» ");
INSERT INTO guxg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pɔli ń buali ba: «To bi nan tieni yi mi ñinwulma bogdili yeni be i?» Ban jiini: “O Ñinwulka Jan yaama” ");
INSERT INTO guxg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Lanwani ii, Pɔli ń jiini ba: «Jan den tieni ti tuonbiadi sugli ya ñinwulma bogdili i. O den waani bi niba ke ban ya daani yua n ba ŋɔdi o puoli wani n tie Jesu.» ");
INSERT INTO guxg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bi niba ń gbadi lan ya maama, ke bi tuo ki ga mi ñinwulma bogdili O Diedo Jesu yeli po. ");
INSERT INTO guxg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔli ń́ maani o nui bi po, ke Foŋanma jiidi bi po, ke bi ji maadi mi maalanma nni ki pua sawali. ");
INSERT INTO guxg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bi den tie nani jaba piiga n bilie i. ");
INSERT INTO guxg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔli den kua yikodi tundma dieli nni, ki maadi yeni li papaali, nani ŋmaali taa yeni, ki tie ania ke ban gbadi U Tienu diema niima nni. ");
INSERT INTO guxg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama, Juufinba bi tianba den juagi bi pala kaa tuo ki cɔlni Jesu sanŋɔdma, ki go maadi ki biidi Jesu yeli asala siiga. Lanyapo, Pɔli den yaadi ki ŋa ba, ki taa bi ŋɔdkaaba, ki piadi ki ban tundi ba daali kuli Tiranusi cogdieli nni. ");
INSERT INTO guxg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pɔli den li kubi yeni i hali bina lie, ke yaaba ye Asi kuli, Juufinba yeni Gilekinba kuli, gbadi O Diedo maama. ");
INSERT INTO guxg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","U Tienu den tie Yaalidgu tuada yeni Pɔli nui, ");
INSERT INTO guxg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Lanyapo, ya yianba den fidi ki sii Pɔli ninfiancabli bii o tiayiekaagu den yi baa laafia, mu cicibiadmu mo den ñ ki ŋaani yiantianba mo. ");
INSERT INTO guxg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ama Juufinba, ŋantaadi danba mo den ye li diema nni, ki bieli ki ñangi mu cicibiadmu mun ye yaaba niinni O Diedo Jesu yeli po. Bi den yi yedi: “Jesu, Pɔli ń wangi yua ya maama yeli po, n yedi yi yeni li niinli ke yin ña ki ŋa bi niba ne” ");
INSERT INTO guxg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yaaba n den tiendi lani den tie Juufi salga yidkacianba siiga yendo, ke bi yii o Sefa ya bijalelediba i. ");
INSERT INTO guxg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Cicibiadyenga ń jiini ba “N bani Jesu, N go bani Pɔli mo; Ke yinba mo tie bile i? ");
INSERT INTO guxg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ki cicibiadga yaaga n ye o nilo nni yeni ń bibi ŋantaadi tofaadanba, kiloli ba ki puapua ki duoli ba ban ña li dieli nni ki sani mubili yeni ti yiadi. ");
INSERT INTO guxg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ya niba n ye Efesi kuli, Juufinba yeni gilekinba ń gbadi li maama, ki bandi. Ti jawaandi ń kua ba, ban kpiagi O Diedo Jesu yeli. ");
INSERT INTO guxg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Yaaba n den daani Jesu nni mo den nagdi ki wangi ban tieni ya tuonbiadi, ki miadi sugli ti po ");
INSERT INTO guxg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bi ñɔgdanba yeni ti bulbɔndi danba den cua yeni bi tila ke bi juu ke a buodi u mu nni asala siiga. Li tila kuli dunga den pundi ligdibala tuda piimu (50.000) ");
INSERT INTO guxg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Lanyapo, O Diedo maama den yadi i kaankuli yeni u paaciamu. ");
INSERT INTO guxg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pɔli ń sɔni o tuonli ki gbeni Efesi dogu nni, Foŋanma den kuani li jagli ke wan tɔgni Maseduani yeni Acihayi po, ki gedi Jerusalema; O den maadi “Min kali nekanba yeni, li buali ke min pundi Roma po mo.” ");
INSERT INTO guxg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pɔli den sɔni o todkaaba bilie Maseduani, lani n tie Timote yeni Erasitusi yaaba n den tie o naacenba. Ama wani obá go den tieni Asi diema nni waamu. ");
INSERT INTO guxg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lanyognu, bi den fiini mi janjancianma Efesi dogu nni, ki mi nua Jesu sanŋɔdma. ");
INSERT INTO guxg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wula maano den ye ki yii Demetriyusi, o den duadi Diyana jaandieli bonnanana ki kuandi o tuonsɔnba po li baali boncianla ");
INSERT INTO guxg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Lanwani ii, o den yini li tuonsɔnba yeni ya maaba sieni, ki taani ba ki yedi ba, “Canbáanba, i kuli bani ke ku maagu ne tuonli kuandi ti li baali boncianla. ");
INSERT INTO guxg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","I la ki go gbadi, li ki tie Efesi ne baba ka ama Asi nni kuli, ke ban yii yua Pɔli bɔndi ki lebdi bi niba maalma ke bi ŋɔdi o. O yedi ba ke ban tagi ya buli yeni i nui ki tie tienu. ");
INSERT INTO guxg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Li ba fidi bi niba ń fali ti kpenkpendu tuonli ne; lani baba ka, bi go ba fidi ki fanbi ti pobulo Diyana yua n dagdi yeni ti kpiagdi yeni budieli. Wani yua ke Asi kuli yeni ŋanduna kuli bugi ba buoni o kpiagdi.” ");
INSERT INTO guxg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ban gbadi lanya maama, ke bi fii yeni li pabienli ki yigni ki tua “Efesi yaaba Diyana ye yeni ti kpiagdi” ");
INSERT INTO guxg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ke li ŋmadli tieni u dogu nni kuli, ke bi niba taani ku kua u badu guagu nni, ki cuo pɔli yegni yaaba n den ñani Maseduani ki cua, Gayusi yeni Arisitarkusi. ");
INSERT INTO guxg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔli den bua kua ku niwulgu siiga, ama bi ŋɔdkaaba den pani o. ");
INSERT INTO guxg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asi diema nni yikodanba yaaba n den tie dɔnlinba den sɔni u tondu ki waani o ke wanda kua ku guagu nni. ");
INSERT INTO guxg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bi niba den yigni ki maadi maayenma, ke tianba mo maatɔma, kelima bi den ye ti yanyagdi nni ke bi siiga boncianli ki bani ban taani yaali ya po. ");
INSERT INTO guxg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juufinba ń dadi Aleksandro ki ñani bi niba siiga, ki seni o liiga Aleksandro ń cili ki ya gangi o nui, ki bua wan waani li nitaanli li bonli niima nni. ");
INSERT INTO guxg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama, ban bandi ke o tie Juufi, ban taani ki tandi ki maadi maayenma lan waagi kudilie ki tua, “Efesi yaaba Artemisa ye yeni ti kpiagdi.” ");
INSERT INTO guxg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","yiko tuonsɔnlo ń mɔndi ki jiini ku niwulgu yama, ke o maadi, “Yinba Efesi yaaba, o laa nilo n ye ne, kaa bani ke Efesi dogciamu n tie ti pobulciamo Diyana budieli guudka, ya nannanli n ñani tanpoli ki baa? ");
INSERT INTO guxg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Yin bani ke lanya bonli ki pia niama yeni ii, i ba dingi i yama ki da jegibi ki sɔni tuonkaadi. ");
INSERT INTO guxg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kelima yin cua yeni ya niba ti buudi ne ki tie jaandieli suuda, baa go tie yaaba n fanbi tin jaandi ya bulo mo. ");
INSERT INTO guxg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Lanwani ii, Demetriyuusi yeni bi maaba yaaba n ye yeni o ya pia tagli yeni nilobá, ti buudi diena ye, ke ti buudi yudanba mo ye; bi ba fidi ki jia bi maama yeni biyaba. ");
INSERT INTO guxg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ama i ya pia maatɔma li buali li maama jiama ń cɔlni li nitaali sanu i. ");
INSERT INTO guxg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kelima, lanyapo, bi ba fidi ki jalgi ti ke ti yie yiko i ki fiini li ŋmadli dinne ki naa bani yaali ya po, ti go kan fidi ki waani li niima nni mo. ");
INSERT INTO guxg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wan maadi lanya maama ki gbeni, ke o cabi li nitaanli. ");
INSERT INTO guxg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ku fuugu po ń pendi, Pɔli ń sɔni ki yini bi ŋɔdkaaba, ki paani bi pala, ki ji cabi ba, ki fii ki gedi Maseduani. ");
INSERT INTO guxg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wan pendi li diema nni, o den maadi n yabi, ki paani bi pala, ke o cua Gresi. ");
INSERT INTO guxg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Wan tieni li dogu nni ŋmaali taa, Juufinba ń tidi loli ki sedi o po yeni i janbi, lan sua ke o bua kua ku ñinbiagu ki gedi Siri, wan jagi, ki guani ki lebdi Maseduani. ");
INSERT INTO guxg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yaaba n den ba ciani o Asi po n tie, Sopateri, Piirusi bijua, ke o ñani Bere; Aristarki yeni Sekɔndi, ke bikuli ñani Tesaloniki ki tie dugikaaba; Gaayusi, ke o ñani Derbi, Timote, Ticiki yeni Trofimi, ke bi tie Asi yaaba. ");
INSERT INTO guxg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ama lanya niba den ga ti liiga ki ba guudi ti Trowa. ");
INSERT INTO guxg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ya kpanu n ki pia dibinli daana ń pendi, ke Ti kua ku ñinbiagu Filipi, ki tieni dana mu, ki pundi bi kani Trowa, ki kali likani dana lele. ");
INSERT INTO guxg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Laadi daacincinli daali, tin taanni ki bua ŋmiidi kpanu, Pɔli ń maadi yeni bi dugikaaba. O den bobni ki bua li ya fiifandi, wan fii i, lanwani ii, o den maadi ke ku yɔgsiigu ti yɔgdi. ");
INSERT INTO guxg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mu fidsanmu den yabi poli dieli nni, tin den taani naana. ");
INSERT INTO guxg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","O naaciemo den kaa li takobonli kani ke bi yi o Etikusi, mi guama den paadi o. Nani Pɔli ń den maadi boncianli yeni ii, li naaciemo mi guama ń paadi li naaciemo, wan lagdi li dietuaditaali po ki baa ki kpe ");
INSERT INTO guxg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ama Pɔli ń jiidi, ki duani ki labni o po, ki wobi o. K yedi, “Da wadi mani i pala ka, kelima o fo.” ");
INSERT INTO guxg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Wan guani ki do, ki ŋmiidi kpanu, ki ŋmani. Wan maadi yeni ba ki pugni hali i siŋafaani, wan cabi ki fii. ");
INSERT INTO guxg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ban guani yeni o naaciemo ke o fuo, lan sɔngi bi pala. ");
INSERT INTO guxg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tinba wani den kua ku ñinbiagu, ki ga Pɔli liiga, ki gedi Aso, tin den ba guudi naani ki taa Pɔli ku ñinbiagu nni. Wani mɔno den bua yeni i, kelima, o dá den jagi ke wan tɔgni u sanu i. ");
INSERT INTO guxg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wan cendi ti Aso yeni, ke ti kuani o ku ñinbiagu ki gedi Mitileni. ");
INSERT INTO guxg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tin fii lankani, ti tieni dayenli i, ki pundi Cihiyo kpendegli kani, li daalieli ke ti pundi Smo kpendegli, li daataali daali, tin pundi Mileti dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nani Pɔli ń den jagi ke wan tɔgni Efesa po, o den ki bua wan biani mi yaama Asi diema nni, kelima o den peli ki bua o ya ba fidi, wan pundi Jrusalema pantekoti daali i. ");
INSERT INTO guxg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Wan pundi Mileti, Wan sɔni bi niba Efesa, ban yini o po Kiristi nitaanli nikpelba. ");
INSERT INTO guxg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ban pundi o kani, wan maadi ba, “Yinba mɔno bani ibá ke hali min ŋmaa n taali Asi ne, min ye maama yeni yi yognu kuli. ");
INSERT INTO guxg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","N li ŋua ki tuuni U Tienu tuonli yeni li pali nni yumiinli, yeni ti ninsiidi yeni Juufinba ń loli ki sedi n po yeni ya janbi kuli. ");
INSERT INTO guxg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Yinba mɔno bani ke mii dɔgni yi libakuli ke li nua yaali n tie bonmɔnli i po, yeni min tundi yi maama asala siiga, ki go caa i dansani nni maama. ");
INSERT INTO guxg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","I bani min tuodi ki waani Juufinba yeni gilekinba ke ban biidi bi pala bi tuonbiadi po, ki lebdi bi yama ki ŋɔdi U Tienu, ki dugi ti Diedo Jesu po. ");
INSERT INTO guxg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mɔlane, Foŋanma tigi nni, ki caa yeni nni Jerusalema, n naa bani yaali n ba tieni nni lanpo, ");
INSERT INTO guxg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ama Foŋanma tuodi ki waani nni ke i kudseseli yeni falaciamu guu nni. ");
INSERT INTO guxg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama mii tama ke n miali tie bonmɔnli n po, ki ba pani nni min dudi n nɔnma banlu yaali n pia n po mayuli po, lani n tie ke min sɔni O Diedo ń puogi nni ya tuonli, ki tieni kasiedi U Tienu ŋanbli laabaalŋamo po. ");
INSERT INTO guxg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Diidi mani mɔlane, n bani ke yinba yaaba ya siiga ke n kpaandi ki waani U Tienu diema laabaali ne, i kan la n nunga jiga. ");
INSERT INTO guxg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kelima n kadi ki maadi yi i mɔni dinne, ke mii pia tagliba kuli ke li nua nisaaloba kuli sɔma. ");
INSERT INTO guxg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kelima, min waani yi U Tienu yanbuama, mii dɔgni yi libakuli. ");
INSERT INTO guxg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Lanwani ii, yin fangi i yula ki cegni ibá, ki guudi U Tienu Foŋanma ń guuni ya yankulu ke yin ya tie yankpaaba/ gobdikaaba. Yin ya faami, yin gobdi ya yognu U Tienu nitaanli, wan baa yaaba ki taani o kani yeni o sɔcema. ");
INSERT INTO guxg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N bani ke n ya fii, ki siedi ki ŋa yi, yaaba n tie nani i fuasangbanbiadi yeni ba kua i siiga, ki kan taa ki cabi u yankulu. ");
INSERT INTO guxg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","N bani ke bi niba ba kua i siiga, ki bɔndi yi yeni bi nufantunda ke yin tua ŋɔdkaaba. ");
INSERT INTO guxg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Lanwani ii, yin sedi taajalalie, ki guudi. Yin ya tiani ke bina taa n yeni, ke n tundi yi yienu yeni ñiagu kaa cedi. ");
INSERT INTO guxg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mɔlane, n mubni yi U Tienu yeni o ŋanbli ñɔmaama nui nni, yaama n ba fidi ki cedi yin paagi ki cie, ki go baa u biinu wan bili ya ŋalmani o nigagdiŋanba po. ");
INSERT INTO guxg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","N naa kuani n yama niloba kuli ligi bii o wula lanyaaka o tialakaadi nni. ");
INSERT INTO guxg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Yinba mɔno bani ke n ya nui ne kuani n yuli po buama yeni yaaba n ye yeni nni ya buama i. ");
INSERT INTO guxg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Lan tie yaali kuli, n tieni nannanli ki waani yi yin ba todi a tadma maama yeni i tuona, yeni yin baa tiani O Diedo Jesu ń yedi ya maama, wan yaadi kiyedi yaama obá: «Mi yedŋanma ye ŋan teni po ki cie ŋan ga.» ");
INSERT INTO guxg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Wan maadi yeni, ki gbeni i, ke o gbaani ki jaandi yeni bikuli. ");
INSERT INTO guxg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bikuli den buudi boncianla, ki cuo Pɔli tulu nni ki wobi o. ");
INSERT INTO guxg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bikuli den ye yeni li pabɔnli kelima ban den gbadi ke o maadi ke bi kan ji guani ki la o nunga, lani ń pendi i, ke bi ciani o ku ñibiagu kani. ");
INSERT INTO guxg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tin cabi ba ki fii, ki kua ku ñinbiagu, ti taa sansiedu ki gedi Kosi dogu nni, lan fiifandi, ke ti pundi Rodesi dogu nni, ki pendi lankani ki pundi Patara. ");
INSERT INTO guxg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ti den la ñinbiagu ke ku caa fenesi po, ke ti kua gu. ");
INSERT INTO guxg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tin den nagi Cihipri kpendegli, ti den balni ki ŋa li ti ganu po, ki toli Siri po, ki gedi ki sedi Tiiri, ke bi tugdi ku ñinbiagu tuga. ");
INSERT INTO guxg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ti den la jesu ŋɔdkaaba, ki tieni lankani dana lele. Foŋanma den fandi ba ke bi waani Pɔli ke wan da gedi Erusalema. ");
INSERT INTO guxg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ti cangu ǹ den juodi likani, ke ti cabi ba, ki tugni ti sanu, ke bani yeni bi puoba yeni bi bila piadi ti hali ki ñani ti u dogu nni. Ke ti gbaani ki jaandi u ñinkunu. ");
INSERT INTO guxg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ti den cabi ba ki kua ku ñinbiagu, ke bi guaniki kuni bi denpo. ");
INSERT INTO guxg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tin den pendi Tiri, tiden suagi ki gedi Pitolemayisi. Lankani, ti den fuondi tikpiiba, ki juadi yeni ba dayenli. ");
INSERT INTO guxg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lan fiifandi, ke ti fii ki gedi Sesare, ki kua Filipi yua n tie ban den gandi ya nileledba o laabaalŋamo tundma po yen yendo deni, ki ye yeni o ");
INSERT INTO guxg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Li nilo den pia bonpola taa, ke bi tie powandina, ki pua sawali. ");
INSERT INTO guxg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tin tieni likani dana waamu, sawalpualo bá den ñani Jude, ki jiidi ki cua, ke bi yii o Agabusi, ");
INSERT INTO guxg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","O den nagni tikani ki taa Pɔli gbanñagdu, ki loli o ya taana yeni o nui, ki yedi ne: “Foŋanma ń yedi yaali n ne, 'Maama ne i, ke Juufinba ba loli yua yeni ya gbanñagdu ne, ki mubni o bi nilanba nui nni'.” ");
INSERT INTO guxg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tin gbadi lan ya maama, tinba yeni ya niba n ye likani kuli ń taani ki maadi Pɔli ke wan da gedi Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ke Pɔli jiini, “Be yapo i, ke i buudi ki yagni n yama? Kelima, N bobni ki gbeni o, Li ki tie ke ban loli nni baba ka, ama ki go ke Jerusalema nni, O Diedo Jesu yeli po” ");
INSERT INTO guxg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nani Pɔli ń den ki bua ke o cengi ti cegli yeni i, ti ji den ki ŋua ki niidi o, ti den yedi, “O Diedo yanbuama ń tieni lan buali maama” ");
INSERT INTO guxg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Lanya dana ń pendi, ke ti baani ti tuga ki doni ki gedi Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bi ŋɔdkaaba den ñani Sesare, ki ŋɔdi ti lipo. Bi den yegi yeni nilo ke bi yii o Minasɔn, ke o tie Cihipri yua, ki den tie ŋɔdkaa, tin baa ye yeni yua. ");
INSERT INTO guxg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Tin pundi Jerusalema, ti kpiiba den ga ti cangu yeni li pamanli. ");
INSERT INTO guxg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lan fiifandi, ke Pɔli gedi yeni ti Jaka kani, Kiristi nitaanli nikpelba kuli den ye likani. ");
INSERT INTO guxg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Wan fuondi ba ki gbeni, ke o dugni ba U Tienu ń tieni yaali kuli bi nilanba siiga o tuonli sanu po. ");
INSERT INTO guxg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ban gbadi lani, ke bi dondi U Tienu, ki maadi o, “Ti kpiilo, a la ya niba n tuo ki dugi Jesu po Juufinba siiga ki luo tuda tuda. Bi kuli sedi taajala lie i, ki baa cɔlni li bali yikodi. ");
INSERT INTO guxg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Be maadi ba a maama, ke a tundi Juufinba yaaba n ye bi nilanba siigi, ki waani ba ke ban ŋa Moyiisi maama, ke ban da kɔndi bi bila, ki go da ŋua bi yaajanba bogda mo. ");
INSERT INTO guxg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ti ji ba tieni ledi i? Li naa pia tama ke bi kan gbadi ke a cua ne. ");
INSERT INTO guxg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Lanwani ii, ŋan tieni tin ba waani a yaali. Niba na ye ne ki niani U Tienu bi ñɔnianu. ");
INSERT INTO guxg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Taa li niba, fini yeni bani ń wuli ki ñani li kuali, ŋan pa bipo, ban kuo bi yudi. Lanwani ii, bi niba ba bandi ke ban maadi a po ya maama kuli tie tofaama. Bi ba bandi ke fini mɔko ŋua li bali yikodi. ");
INSERT INTO guxg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ama yaali n nua bi nilanba yaaba tuo ki ga Jesu sanŋɔdma po, ti diani ba li tisɔnkaali, ki waani ba ke ban cuo bi yula yani i buli padjiema, yeni mi sɔma, yeni mu yansɔdkamu nandi yeni mi conconma.” ");
INSERT INTO guxg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ke Pɔli taa li niba, ke li fiifandi ke o wuli yeni ba, ki ñani li kuali yeni ba, ki kua ku jaandiegu nni ki waani ban ba tieni ya dana yeni yukuli ń ba padi ya padli bi ŋanbma po. ");
INSERT INTO guxg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ban den bili ya danleleda ń nagi gbenma, ke Juufinba ñani Asi ki, ki la Pɔli ku jaandiegu nni, ke bi maadi ki fiini bi niba pala, ki cuo Pɔli. ");
INSERT INTO guxg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bi den tandi ki tua “Israyeli niba, todi mani ti. Ya nilo n kpaagi ki tundi bi niba i kaankuli ya bona n ki cɔlni ti buolu, ti yikodi yeni tin kua naani ne. Lani baba ka; o go kuani bi nilanba ti jaandiegu nni, ki jɔgni lanya kaangagdiŋanmɔnu.” ");
INSERT INTO guxg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kelima bi den kpia ki la ke wani yeni Efesi yuaTrofima, ke bi yegi u dogu nni, ke bi maali ke o den kuani o ku jaandiegu nni i. ");
INSERT INTO guxg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Li ñɔgli den tieni u dogu nni kuli, ke bi niba sani ki taani, ki cuo Pɔli. Bi den dadi ki ñani ku jaandiegu nni, ki luoni a bulñɔna kuli. ");
INSERT INTO guxg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ban jagi ke ban kpa o, ke li maama kua sejenba yudaano tubli nni ke Jerusalema kuli ye li ŋmadli nni i. ");
INSERT INTO guxg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Lanyognu ke o taa sejenba ki sani ki jiidi ki pundi li ñɔgli kani. Bi niba ń sejenba yeni bi yudaano ke bi ŋa Pɔli yeni ti puadi. ");
INSERT INTO guxg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ke sejenba yudaano nagni ki cedi ke bi cuo Pɔli, ki cedi ke bi loli o yeni i kudseseli. Ke o buali wan tie yua yeni wan tieni yaali. ");
INSERT INTO guxg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bi niba den tandi ki maadi maayenma, ke tianba mo maadi maatɔma. Nani seje yudaano ń kan den fidi ki maadi libakuli kelima ku fuugu po yeni, o den cedi ke bi gedi yeni Pɔli li kpaadidiepaali nni. ");
INSERT INTO guxg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ban den pundi a ŋmaada kani i, bi den tugi Pɔli kelima bi niba jadi den yabdi. ");
INSERT INTO guxg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kelima ku niwulgu den ŋua puoli ki yigni ki tua, “Ban gbeni o maama!” ");
INSERT INTO guxg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ban den bua kuani Pɔli li kpaadidiepaali nni ya yognu, ke o maadi seje yudaano, “N ba fidi ki maadi bonli i?” Seje yudaano ń buali o, “A maadi Gileki maama? ");
INSERT INTO guxg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Lanwani ŋaa tie Ejipti jua yua n den fiini mi janjanma ki kuani jakɔnda tuda na mi fanpienma nni ka aa? ");
INSERT INTO guxg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔli ń yedi, “N tie Juufi, ki ñani Tarsi dociamu, Silisi diema nni. N tie dogcianmɔnu dotielo i. N mia ke ŋan cabi nni u sanu min maadi yeni ku niwulgu. ");
INSERT INTO guxg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Seje yudaano ń cabi o u sanu, ke Pɔli sedi a ŋmaada po ki duoni o nuu, ki gaani ki toli ku nilgu. Bi kuli ń suoni silbi, ke maadi ba Ebrewu maama nni ki yedi, ");
INSERT INTO guxg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«N ninjaba yeni n baanba, cengi mani min pia ya maama ki bua ki maadi yi, ke yin ga ma». ");
INSERT INTO guxg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","O niwulgu n den gbadi ke Pɔli maadi Hebilu maabuolu nni, bikuli den suoni Silibi. Pɔli den yedi: ");
INSERT INTO guxg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«N tie Jufi ki mali taasa Cilisi ya yogu ama den kua Gamali cogu o naa dogu nni. O den bangi ti yaajanba maama cain, n den kuani yama kuli U Tienu po nani i kuli n bua wan maama dinne. ");
INSERT INTO guxg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","N den wangi yaaba n ŋua laa fala paa, n den loli b jaba yeni b puoba kuli ki kuani ba li yonmidieli nni. ");
INSERT INTO guxg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ba sala yidikaaba cianba yeni b ni kpe juogi kaaba ba fidi ki tieni siedi ke ban den teni li tili ke min gadi Damasa ke pan teni ti ninjaba yaaba tie Jufinba min den gadi naa po ke loli yaaba n ŋɔa o sɔnu ki cuani ba Jelusaema ki ban pua ba. ");
INSERT INTO guxg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Li den bua ki pundi naani o yie sinu yeni mini den pa u Sɔnu ki caa Damasa nni den nagi. La yo o yen ciangu den ñiliti ki ñani tanpoli po ki ba Lidini. ");
INSERT INTO guxg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","N den jiidi ba tinga ki gbadi o nialu ka li maadi Solo Laabaali ki wangi fala. ");
INSERT INTO guxg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","N den gua buali o a tie ŋmaa yonbidaano i? o den ŋmiani nni Jesu Nasaleti yua ki wang fala. ");
INSERT INTO guxg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Min yen yaaba n den yegi bi den la n yenyenma ama bi den gbadi yua maadi yeni min ya nialu. ");
INSERT INTO guxg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","N den yed: N ba tieni lede n yonbidaano? N yonbdaano den yedi: Fii ki pundi Damasa, lan kani bi ba wani a ŋa ba tieni yala kuli. ");
INSERT INTO guxg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","N den nua kelima yenyenma ciangu n yen n po, n yegi lieba n den dadi nni ki pundi Damasa. ");
INSERT INTO guxg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Lan kani ke n den bandi ban yi yua Ananiasa, oja yen tie nimono U Tienu bali maama po, ya Jufinba ye Damasa kuli tiedi o po sieda ŋaamo. ");
INSERT INTO guxg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wan Ananiasa den cua min ye naani, ki nagi ni kani ke yedi: N ninjua Solo, ŋɔli, li yogu ki la o. ");
INSERT INTO guxg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","O den yedi: ti ya yaaba ke U Tienu lugdi ba ka bani o yama buama ki ya tiegi, ki gu wan ba maadi ya maama o ya ŋɔbu nni. ");
INSERT INTO guxg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","A ba tua o siedi b niba yaŋa nintuali nni ŋan laa yaala yeni ŋan badi yaala yeni ŋa gbadi galo. ");
INSERT INTO guxg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Mɔla a kaa gu be? Fii ki ñani a biidi, kelima bi jaandi Jesu ya yeli po. ");
INSERT INTO guxg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Min den guani Jerusalema, ya yogu ki den ye li jaandieli nni ki jandi U Tienu, li den cua n po nani ba yeni. ");
INSERT INTO guxg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","N den u yonbdaano ki yedi: Fii ki ñaa Jerusalema tonma tonma kelima bi kan gua ŋaaba ban tieni a po ya sieda kuli. ");
INSERT INTO guxg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","N den yedi: «N yonbdaano, ban mɔlo ba ki cuo yaaba ṅ den ŋua a ki kuani ba a yonbi diena nni, ki kpa tianba a jaandiena nni. ");
INSERT INTO guxg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","N den tie sieda yi po ya daali k b den wuli Etina sɔnma, n den taa yi yapo mɔmɔni, k guudi yaaba n den ye tiadi.» ");
INSERT INTO guxg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ama n yonbdaano den yedi: «Ti ki gadi kelima n nua ke n ya gadi hali fagma bi nilanba yapo.» ");
INSERT INTO guxg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","O niwulgu den ŋmini ke maadi ki den pundi hali li kani ke bi ji yigniki yedi: «kpa mani ya nibuolu nan ki nano yeni ki tingi, kelima la ŋa ya nilo na ya pia li miali. ");
INSERT INTO guxg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ya yogu ki bi tandi kin landi li liada ki yadi ti tandi, ");
INSERT INTO guxg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","a mintiela yudaano den cua kua yeni o paalu ki cuo Pɔli. O den seni o niwulgu kuli ki buali Pɔli n tieni yaala bi ya nintuali nni, ki bandi yaala n tieni ki bi taandi ya tantaani buoli na. ");
INSERT INTO guxg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ya yogu ke bi loli Pɔli i baabi i, o den yedi a mintiela kobga yudaano yua n den se o kani: «Li cabi ke yin pua ya nilo n tie Loma ki daa buni yeni o?» ");
INSERT INTO guxg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","A mintiela kobga yudaano n gbadi yeni, o den gadi a mintiela yudaanciamo kani ke yedi: «a mɔ la ke tin tieni lede? kelima o nilo yeni tie Loma yua cain.» ");
INSERT INTO guxg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","A mintiela ciamo den gadi ki yedi: «bi maadi a ya linani Loma cain» Pɔli den ŋmini. ");
INSERT INTO guxg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","A mintiela ciamo den guani ke yedi o «Li en tie faala ka ki tua Loma yua cain ama yen ya liigi kpiagi.» ");
INSERT INTO guxg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Lan yogu yaaba den puo wan Pɔli den siedi, ti ja waandi den cuo li mintiela yudaano kelima waa gbadi ki Pɔli tie Loma yua yi cain ke den lolo yi baabi yeni. ");
INSERT INTO guxg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Li daa taa daali, a mintiela yudaano den bua ki bandi i mɔmɔni yaala ya po ke Jufinba kɔni yeni Pɔli, o den lodi yi baabi Pɔli nungi nni, ki yiini li jandieli yudanba yeni bi nikpela ki taani ba. O den jiini Pɔli ki sieni o bi kuli ya siiga nni. ");
INSERT INTO guxg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔli den nuali salga yidkaaba taancianli, ki maadi, “N kpiiba n den ye U Tienu nintuali yeni li yantiaŋanli hali yeni ya daali ne.” ");
INSERT INTO guxg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Salga yidkaciamo Ananiasi ń yedi yaaba n den se o kani ke ban pua o ñɔbu po. ");
INSERT INTO guxg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔli ń maadi o, “U Tienu ba pua a mo, diidi mani li guonpienli ne. A kaa ki bua maani a nuu li bali maama po ki bu n ya buudi yo oo, ki nan kandi yiko po ki cabi ke ban pua nni.” ");
INSERT INTO guxg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Yaaba n den se o kani ń maadi, “A ba sugi U Tienu salga yidciamo yeni yo oo?” ");
INSERT INTO guxg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔli ń maadi, “N kpiiba, n bi ki bani ke o tie salga yidciamo. Kelima li diani, A kan maadi maabiigu a dogu yikodaano po.” ");
INSERT INTO guxg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔli ń bandi ke li nitaanli nni, cagyenli tie Farisienba ke li caglieli tie Saduseyenba, wan doni o nialu ki tandi ki maadi li ni taanli nni, “N kpiiba, N tie Farisien, ki tie Farisien bijua. Min daani mi yiedma bi kpienba siiga nni po i, ke bi bua jia nni ti buudi ne.” ");
INSERT INTO guxg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Wan yedi lani, mi niama ń fii Farisienba yeni Saduseyenba siiga, mi paadma ń tieni ku nilgu siiga. ");
INSERT INTO guxg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kelima Saduseyenba yedi ke faadma ki ya, maleki ki ye ki buali foŋanma, ama Farisienba wani bani ke likuli ne ye ki tie mɔni. ");
INSERT INTO guxg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lanyapo, ban fiini ku fuugu, ki ya sugdi biyaba. Farisienba gbanbanda bi tianba ń fii ki cili ku ñɔniagu, ki yedi, “Ti nan ki la ya nilo ne ń pia ya tagli. ŋma bani maleki bii Foŋanma yaa maadi yeni o?” ");
INSERT INTO guxg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ku ñɔniagu ń fii ki pugni, o sejeciamo ń jie ke bi ba ti pua ki papadi Pɔli, wan sɔni u tondu, ke o sejenba ń jiidi ki fie o li nitaanli nui nni yeni u paalu ki cua ki kuani o li kpaadidieli liiga po diepaali nni. ");
INSERT INTO guxg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ku ñiagu ń bii, O Diedo ń cua ki sedi o kani, ki yedi, “Da jie, kelima nani ŋan maadi ki tieni n po kasiedi Jerusalema yeni, a go ba tieni li kasiedi Roma nni mo.” ");
INSERT INTO guxg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lan fandi, Juufinba siiga, bi tianba ń poli, ki niani ke bi kan di libakuli bi go kan ñu libakuli hali yeni ban ba kpa Pɔli. ");
INSERT INTO guxg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Yaaba n den taani ki jagi li janbi ñɔlolma den ki luo niba piina (40). ");
INSERT INTO guxg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ban gedi salga yidkaciamo yeni a nikpela kani ki maadi, “Ti poli ki niani ke ti kan di ti go kan ñu libakuli hali yeni tin ba kpa Pɔli. ");
INSERT INTO guxg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lanwani ii, ŋan cedi ban maadi o sejeciamo ke ban jiini o i kani na, yin ŋanbi ki kpaagi o maama nni. Tinba wani tuodi ki bobni o po, ki ba kpa o ke bi dá ki pundi yeni o i kani. ");
INSERT INTO guxg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ama, Pɔli ninsalo bijua ń gbadi ke bi loli ki sedi ki ba guudi ki kpa o, wan kua li kpaadidiepaali nni, ki tuali Pɔli. ");
INSERT INTO guxg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pɔli ń yini seje kobgo ciamo ki maadi o, “Taa o naaciemo ne, ki ciani o o sejeciamo kani, kelima o pia maama ki bua maadi o.” ");
INSERT INTO guxg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Lanwani ii, seje kobga yudaano ń taa o naaciemo ki ciani o o sejeciamo kani, ki maadi, “Pɔli yini nni, ke n kua o kani, ke o maadi nni ke min ciani o naciemo ne a kani. O pia maama ki bua maadi a.” ");
INSERT INTO guxg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","O sejeciamo ń cuo o naaciemo nuu, ki piadi yeni o, ki buali o, “A pia be ya maama i ki bua maadi nni?” ");
INSERT INTO guxg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","O naaciemo ń maadi, “Juufinba taani ki loli ki ba mia ŋan cedi ban won jiini Pɔli bi nitaanli nni, nani bi bua ŋanbi ki kpaagi o maama nni yeni. ");
INSERT INTO guxg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ama, ŋan da cengi bi maama, kelima, bi ki luo niba piina, ki poli, ki niani ke bi kan di, bi go kan ñu libakuli hali yeni ban ba kpa Pɔli. Bi bobni ki gbeni o, bi ji guu ŋan ba jagi ki cuo yaali i.” ");
INSERT INTO guxg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","O sejeciamo ń cabi o naaciemo wan ña, ki nan tuodi ki kpaa o, ki maadi, “Da cedi niloba kuli ń bandi ŋan maadi nni yaali ne”. ");
INSERT INTO guxg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ke o yini seje kobga cianba bilie, ki myedi ba, “Yin bobni sejenba kobilie (200) yaaba n ba gedi Sesare, yeni tanpuala piilele (70), yeni bi kpandanba kobilie (200). I ba fii ku ñiagu, kudi taa yognu, ki gedi Sesare. ");
INSERT INTO guxg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","O go den yedi ba ke ban bobni ti yanjagkaadi, Pɔli ń ba jagi yaadi, ki taa o mi yanduanma nni, ki gedi ki mubni o gobna Feliksi nuu nni. ");
INSERT INTO guxg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","26","Ke o diani ya tili ne: “Kolodi Lisiasi n diani ya tili ne, gobna ciamo Feliksi po, N fuondi a. ");
INSERT INTO guxg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","O ja ne, Juufinba n cuo o, ki bobni ke ban kpa o, ke n gbadi ke o tie Roma yua i, ke n ŋɔdi ba yeni sejenba, ki fie o bi nuu nni. ");
INSERT INTO guxg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","N den lingi min bandi ban jalgi o yaali ya po, ke n cedi ke bi jiini o bi nitaanli nni. ");
INSERT INTO guxg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bi waani nni ke bi jalgi o ya maama n nua bi bali maama i, ama ke waa pia ya tagli n buali kuuma bii ban luoni o. ");
INSERT INTO guxg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","N go gbadi ke bi loli ki sedi o po yeni i janbi, lani n cedi ke n kagni ki taa o ki sɔni ke ban cua yeni o a kani, ki yedi yaaba n jalgi o ke ban bobni yaali n tie o tagli kuli, ki cua ki waani ke ye ki gbia. Ya gaani n cabdi.” ");
INSERT INTO guxg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sejenba ń cɔlni o tondu. Bi den taa Pɔli ki gedi yeni o Antipatri ku ñiagu yeni. ");
INSERT INTO guxg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lan fiifandi, sejenba boncianli den cedi ke a tanpuala n ciani o, ke bani bibá guani ki lebdi li kpaadidieli po. ");
INSERT INTO guxg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","A tanpuala ń pundi Sesare, ki teni gobna li tisɔnkaali, bi go den taa Pɔli ki waani o. ");
INSERT INTO guxg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gobna ń cogi li tili, o buali Pɔli wan tie ya diema yua. Ki bandi ke o tie Silisia yua i. ");
INSERT INTO guxg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Wan maadi, Yaaba n kpaani ke ban bu a buudi ya pundi, n ba cengi a maama kuli ki gbeni. O den cedi ke bi kubi o Herodi badidieciangu nni. ");
INSERT INTO guxg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Dana mu bo pendi ke salayidkaaba cianmo Ananasi yeni bi nikpejuogikaaba, yeni mi mabanma liiga yua, yua ke bi yi o Tetule lan niba n bo ciani Poli o dogdaano kani kelima bi bi pia yenba ti buudi. ");
INSERT INTO guxg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ya yognu ke Poli bo sedi o dogdaano nituali nni, Omabando Tetule bo cili mi maama ke bua wan jaligi o ki yedi: «o dogdaano ya ŋalibalgi po i ke ti kuli ye yeni mi yanduanma yeni a maalŋama mɔ ya po i ke ti dogu kuli lebdi ki ŋanbi ");
INSERT INTO guxg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Li tie ŋalbalgi boncianli a po ti pala nni yeni ŋan tieni yaala kuli; ti jaandi ŋa hali boncianla Felisi. ");
INSERT INTO guxg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ki fidi, min da biandi a yaama, n ba mia a ŋan cengi nni bonŋanla yeni mi yanfuomama. ");
INSERT INTO guxg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kelima ti diidi ki sua ke o ja ne tie ya nibiado n ba fidi ki fiini ŋanduna nni juufinba pala ki cedi ban fiini mi yiema. O tie Nasareti jaantieba liiga yua i. ");
INSERT INTO guxg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","O jagi ki ba fanbi ku jaandiegu i ke ti cuo o. ");
INSERT INTO guxg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ama, Lisia o seje ciamo mɔndi ki fie o ti nui nni yeni u paalu, ki gedi yeni o. ");
INSERT INTO guxg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","A ya buali pɔli li maama po, a ba gbadi i mɔmɔni tin jalgi o yaali ya po. ");
INSERT INTO guxg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ke juufinba todi ki jalgi Pɔli ki yedi ke ke ban jalgi o yaali ya po tie mɔmɔni i. ");
INSERT INTO guxg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ama gobna n ́ teni Pɔli mi maama ke wan maadi, Pɔli ń jiini, “N gbadi ke a tie ti buudi yudaano u dogu ne li tieni bina, ke n pali mani yeni mi ba yaadi mini nba, ki waani i mɔmɔni. ");
INSERT INTO guxg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","A ba fidi ki kpaagi ki bandi ke piiga n dana lie n yeni, mi gedi Jerusalema ki ba pugi U Tienu. ");
INSERT INTO guxg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ban la nni ku jaandiegu nni, n ki bo gagi yeni nilo, n bi ki fiindi bi niba pala yiko cogdieli kani yeni u dogu nni. ");
INSERT INTO guxg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bi kan fidi ki teni kasiedi ban jalgi nni yaali ya po. ");
INSERT INTO guxg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ama n tuo a nintuali nni ke ban yi yaali jaanbuofanu yeni, n li ŋua mani i ki pugi ti yaajanba Tienu, N dugi ki go cɔlni yaali n ye yiko tili nni yeni sawalpuaba ń diani yaali kuli. ");
INSERT INTO guxg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","N pia li dandanli U Tienu nni nani ya niba ne yeni, ke mi faadma ba tieni bi niteginkaaba yeni bi nibiadba po kuli. ");
INSERT INTO guxg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Lanyapo i ke n tie ania ke min ya pia ya yantiaŋanli n ki pia tagli U Tienu yeni bi niba po. ");
INSERT INTO guxg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Li tieni bina ke mii ye ne, n cua yeni li todli n dogu yaaba po yeni i ligi bu paabu po. ");
INSERT INTO guxg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Min tieni lani, juufinba yaaba n ñani Asi den la nni ku jaandiegu nni ke n tie mi wuliŋanbima bogda, laa den tie niwulgu nni bii ŋmadli ń ye naani. ");
INSERT INTO guxg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bi niba ne ya pia maamaba, bi ji ba fidi ki nagni a nintuali ki waani ban jalgi nni yaali ya po. ");
INSERT INTO guxg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Lanyaaka li niba ba fidi ki waani juufinba yiko danba nintuali ban la yaali n po ke laa tiegi. ");
INSERT INTO guxg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Li nan yaa tie min den ye bi siiga nni ki tandi ki maadi yaama ke yuakuli gbadi yaa ka, “Bi kpienba faadma po ya buudi ke bi bua jia nni a nintuali nni dinne.” ");
INSERT INTO guxg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliksi yua n den bani li maama fuuli den yedi ke juufinba ń juuni, ki yedi, “Komanda Lisia ya ñani Jerusalema ki kpeni, n ba jia i buudi.” ");
INSERT INTO guxg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ki puogi seje kobga yudaano ke wan ya guu Pɔli bonŋanla, libakuli ń da pɔdi o, ki da ŋa o nitaanli nni bá niyendo ń da cua o kani yeni bonli ke o bua todi o. ");
INSERT INTO guxg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Lan tieni danaba, Feliksi den guani pɔli kani yeni o denpua Drusila, ke o tie juufi, ki cedi ke bi yini Pɔli ke o ba cengi o yaali n tie ti dudugdi Jesu Kiristo nni. ");
INSERT INTO guxg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ama nani Pɔli ń den kubi mi maama mi teginma po, mi yanduanma po yeni ya buudi n ba juodi ki cua po yeni, ti jawaandi den cuo Feliksi, ke o yedi: «Dá guani ki lebdi o, ama n ya baa u sanu ya yogu, n ba sɔni ki yini a.» ");
INSERT INTO guxg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Lan yognu goga, o den daani ke pɔli ba suu o i ligi, lanyapo, ke o den suani ki yi o ki boe yeni o. ");
INSERT INTO guxg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ama bina lie ń pendi, ke Pɔrsiwusi Festusi ga Feliksi ki tua gobna, Ama nani Feliksi den bua juufinba ninmanga yeni, ke o cedi ke Pɔli li luo li kpaadidieli nni. ");
INSERT INTO guxg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festusi ń pundi diema nni, lan tieni dana taa, wan ńa Cesare, ki gedi Jerusalema. ");
INSERT INTO guxg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","juufi salga yidciamo yeni bi yikodanba ń cua o kani ki waani o ke bi pia mi maama yeni Pɔli, ki bua ban jia ti buudi yeni o. ki mɔndi ki niidi Festusi ke wan cengi bi maama. ");
INSERT INTO guxg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bi den mia o u sanu ke wan tuo ban janbi Pɔli; ke wan cedi ban taa o ki gedi yeni o Jerusalema, yeni bi ba fidi ki kpa o u sanu po. ");
INSERT INTO guxg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ama Festusi den ŋmiani ba ke Pɔli tie kpaadli i ki ye Sesare kpaadidieli nni, ke wani mɔko ba gani lipo. ");
INSERT INTO guxg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ke lanwani ii, yaaba n bua ba fidi ki ŋɔdi o ban gedi lipo. Ke li ya tie ke bi pia jalgi bá Pɔli po, bi ba fidi ki waani o tagli. ");
INSERT INTO guxg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festusi ki tieni likani ke li pendi dana niin bii piiga, ki fii ki jiidi kigedi Sesare, wan pundi ke li fandi, ke o kali ti buudi diegu nni, ki cedi ke bi taa Pɔli ki cua yeni o ");
INSERT INTO guxg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pɔli ń pundi, Jerusalema Juufinba yaaba n ye likani ń jalgi o boncianla, ki waani wan pia yatagli ama ke kasiedi naa ye. ");
INSERT INTO guxg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔli ń maadi ki fie o yuli ki yedi, “N naa tieni yaali n bia Juufinba yiko po, bii ku jaandiegu po lanyaaka Sesari po.” ");
INSERT INTO guxg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ama Festusi den bua wan mangi Juufinba pali, ki buali Pɔli, “A ba fidi ki do ki gedi Jerusalema ban buu a maama ne lipo n nintuali?” ");
INSERT INTO guxg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔli ń yedi, “N ye o badciamo Sesari buudieli kani, ki guu ke ban buu nni lankani i. Mii pia tagli bakuli Juufinba po nani fini aba ń bani maama bonŋanla. ");
INSERT INTO guxg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ama li ya tie ke n tudi, bá ki tieni yaali ke li buali n kuuma, N naa jie min kpe. Ama ban jalgi nni yaali ya po ya ki tuagi sanu, nilo bakuli kan taa nni ki mubni bi nuu nni. N suagi n buudi Sesari po i.” ");
INSERT INTO guxg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festusi den kali ki juogi yeni o juogikaaba li maama po, ki jiini Pɔli, ki yedi, “A yedi ke a suagi a buudi Sesari kani, bi ba buu a lankani i!” ");
INSERT INTO guxg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Lan tieni dana waamu, ke o bado Agripa yeni Berenisi cua Sesare ki bua cani Festusi. ");
INSERT INTO guxg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ban tieni dana waamu, ke Festusi taa Pɔli maama ki waani o bado, ki maadi, “Feliksi den cedi ke bi taa niloba ki cua yeni o ne ke o tie kpaadli. ");
INSERT INTO guxg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Min den gedi Jerusalema, Juufinba salga yidkaaba yeni bi cancannikpelba den jalgi li nilo boncianla, ki mia ke ban buu ki cuo o, ki kpa o ");
INSERT INTO guxg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ke n mo jiini ba ke laa puni sanu ke Roma yaaba ń taa nilo ki mubni o o yibala nui nni ke baa buni o ki puni o u sanu ke o ba maadi ki fie o yuli ti buudi kani. ");
INSERT INTO guxg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ama ban taani ki cua ne, mii guudi dana, li fiifandi ke n cedi ke bi taa o ki cua yeni o ti buudi kaanu. ");
INSERT INTO guxg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ban den fii ki jalgi o, ki waani wan pia ya tagli kuli, maamɔnma bakuli naa den ye. ");
INSERT INTO guxg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ban nia ya maama po tie bi jaandi sanu maama i, yeni niloba ke bi yii o Jesu, ke o den kpe, ama ke Pɔli wani nan yedi ke o fo. ");
INSERT INTO guxg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mii den bani min ba kpaagi lanya maama maama, ke n buali o o ya ba tuo ki gedi Jerusalema ban buu o maama lanpo. ");
INSERT INTO guxg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ama Pɔli ń den yedi ke o baa ye li kpaadidieli nni, ke o suagi o maama o badciamo Sesari buudi kaanu, n den yedi o ke wan ya ye likani ki guu hali min ba taa o ki sɔni o Sesari kani. ");
INSERT INTO guxg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa den yedi Festusi, “N moko bua min cengi li nilo maama.” Festusi ń jiini o “cedi saala” “Aba cengi o maama.” ");
INSERT INTO guxg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lanwani ii, lan fandi, Agripa yeni Berenisi den bobi bi tiakpiagdi ki cua ti buudi kaanu yeni sejenba yeni u dogu yikodanba. Festusi den cedi ke bi taa Pɔli ki cua yeni o bikani. ");
INSERT INTO guxg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festusi den yedi, “O Bado Agripa yeni yinba ya nikpiaga n ye yeni ti ne, I la ya nilo ne ee; Jerusalema Juufinba yeni nekanba yaaba la nni ki yigni ki tua ke waa dagdi wan go ya pia miali. ");
INSERT INTO guxg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","N diidi ki sua ke waa tieni yaali n dagdi yeni mi kuuma; ama wani mɔno ń suagi o maama O Badciamo kani yeni, n ba taa o ki mubni o o badciamo nui nni. ");
INSERT INTO guxg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama mii bani min ba diani yaali cima li tisɔnkaali nni, ki teni o badciamo, lani n cedi ke n cedi ke bi cua yeni o i kani o bado Agripa, ke ŋan todi nni min fidi ki diani yaali n tiegi li maama po ");
INSERT INTO guxg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kelima laa tuagi sanu ke min sɔni kpaadli kaa diani ki waani ban jalgi o ya maama po fuuli. ");
INSERT INTO guxg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Lanwani ii, Agripa den yedi Pɔli, “Maadi ki fie a yuli.” Ke Pɔli duoni o nuu, ki saa i mɔni ki yedi. ");
INSERT INTO guxg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","O badciamo Agripa, n ye li pamanli nni yeni min ga mi maama a nintuali ki ba maadi ki fie n yuli juufinba yaaba n jalgi nni nuui nni; ");
INSERT INTO guxg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kelima a tie bancianma daano yaali n nua juufinba yema yeni bi bogda po. Lanyapo i ke n mia ŋa ke ŋan pa juunli ki cengi nni. ");
INSERT INTO guxg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ti ya ba maadi i mɔni, juufinba kuli bani min ye maama hali n jawaama nni n dogu nni yeni Jerusalema po. ");
INSERT INTO guxg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bi bani nni hali mi cilma, ki ba tuo ki saa i mɔni ke n den cɔlni farisienba yema, ya jaanbuolu n cɔlni mi teginma sanu. ");
INSERT INTO guxg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mɔlane n ji se ne ke bi jiagi nni ti buudi kelima n lingi ya ñɔnianu ke U Tienu den niani ti yaajanba ");
INSERT INTO guxg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kelima li tie ya ñɔnianu ke ti piiga n cuglieda den pugi U Tienu yeni ti cɔlindi yienu yeni ñiagu ki daani ke ban baa i. O badciamo Agripa, li dandanli po i, ke juufinba jalgi nni. ");
INSERT INTO guxg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Beyapo i ke i siiga nni bá niyendo ki maali ke U Tienu ba fidi ki faadi bi tinkpiba. ");
INSERT INTO guxg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Yoguba, n den maali ke mi tieni bona boncianli ki kɔni yeni yaaba n taagi Nasareti Jesu yeli. ");
INSERT INTO guxg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","N tieni li bona Jerusalema dogu nni. Salga yidkaaba ciamo ń den puni nni ya yiko po cedi ke n luoni bi dugikaaba boncianli a kpaadidiena nni, n den solgi ban den kpa yaaba. ");
INSERT INTO guxg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","N den ŋmalgi bi tuba yognu kuli ti yikodi codiena nni ki niidi ba ke bi sugdi U Tienu. N den fiindi n pabienli bi po, ki wangi ba falaciamo bá i doglami nni mɔno. ");
INSERT INTO guxg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Min den tuuni lanya tuona, n den caa Damasi ke li tie salga yidkaaba ciamo yikodi sanu nni; ");
INSERT INTO guxg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","O badciamo, li sanu po, u yensiinu, n den ya yenma n ñilgi ki tuudi ki cie u yienu, ke mi ñani ŋaljanli nni ki yendi ki lindi mini yeni n yegni. ");
INSERT INTO guxg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ti kuli ń lagdi ki baá, n den gbadi ke u nialu maadi yeni nni ebrewu maama nni, “Soli, Soli, be n cedi ki a wangi nni ya falaciamo ne? li paa a po yeni ŋan taa a taali ki pua li bonmuukaali.” ");
INSERT INTO guxg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ke n buali “A tie ŋma i, O Diedo? Ke o diedo jiini N tie Jesu, ŋan falgi yua i. ");
INSERT INTO guxg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mɔla, fii ki sedi a taana po; lanyapo i ke n dɔgdi a po, ki lugdi a ke ŋan tua n tuonsɔnlo yeni n kasiedi yaali nua ŋan bani nni mɔlane yaali ya po yeni min ba yuandi ki waani a ya bona; ");
INSERT INTO guxg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","N go ba faabi a min suani a ya dogtieba yeni ya nilanba siiga nui nni. ");
INSERT INTO guxg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ke ŋan luodi bi nuni, ki ñani ba li biigli yeni Setaani paaciamu nui nni, ki ŋmagdi ba mi yenma yeni U Tienu po, ke ban fidi ki baa U Tienu sugli bi tuonbiadi po, ki di min gagdi ki ŋanbi yaaba faali kelima ban pia ya dudugdi n po. ");
INSERT INTO guxg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","O badciamo Agripa, lanwani ii, n ki fali ŋaljanli nni bonlakaali; ");
INSERT INTO guxg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ama, cincinli, Damasa yaaba po, ki tuani Jerusalema po, yeni Jude dogu nni yaaba kuli yeni bi bi nilanba po, n teni ba u tondu ke ban biidi bi pala bi tuonbiadi po, ki lebdi bi tɔgu, ki guani U Tienu kani ki ya tuuni ya tuonŋana n dagdi yeni ti tuonbiadi sugli. ");
INSERT INTO guxg_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Lanyapo i ke jufinba cuo nni ku jaandiegu nni ki bigni ke ban kpa nni. ");
INSERT INTO guxg_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hali yeni mɔla kuli, U Tienu todi nni, kelima n se ki saagi i mɔni bi niba kuli yeni a nigbenga siiga ke yii nua bontɔli kase bi sawalpuaba yeni Moyiisi ń waani ke yaali n ba tieni ke laa pia tama; ");
INSERT INTO guxg_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ke li buali ke Kirito ń la fala, ki tua yua n ba kpia ki faadi bi tinkpiba siiga, ki fii ki kpaandi ki waani jufinba buolu yeni bi nilanba mi yenma.” ");
INSERT INTO guxg_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔli ń maadi o mɔmɔnsaali ki dudi, ke Festusi tandi ki yedi, “Pɔli a tie gaado i, a bancianma n cedi ke a gaadi.” ");
INSERT INTO guxg_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ama ke pɔli maadi, “O nicɔlinka Festusi, mii tie gaado ka, ama n paani n pali i, ki ñani i mɔmɔni lanbona ki maadi yeni li yumiinli ");
INSERT INTO guxg_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kelima o badciamo bani lanya bona kuli po, lani n cedi ke n fuoni n yama ki maadi o, kelima n bani ke bonli ki ye li maama po ki duagi o; kelima libakuli ki tieeni wuoli nni. ");
INSERT INTO guxg_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","O badciamo Agripa, a dugi bi sawalpuaba po oo? N bani ke a dugi bi po” ");
INSERT INTO guxg_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa ń maadi pɔli, “A bua li y pugni waamu ŋan maadi kuani n yama min tuo ki tua Kirito ŋɔdka yo oo? ");
INSERT INTO guxg_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔli ń yedi, “N jaandi ki miadi U Tienu ke lan tie mɔla ne yo oo, lan ba waagi yo oo, lan da tie fini baba ka ama yaaba cengi n maama dinne ne ń tua nani mini yeni, ama lan da tie li kpadidieli kudseseli ya po ka.” ");
INSERT INTO guxg_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ke o badciamo fii, ke gobna yeni Bernisi yeni yaaba n bo taani ki kaa yeni ba kuli fii; ");
INSERT INTO guxg_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ban ñani ku dieciangu nni ke bi maadi yeni bi lieba ki tua, “Ya nilo ne ki tieni ya bonli n pundi kuuma bii cuoma.” ");
INSERT INTO guxg_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa ń yedi Festusi, “Bi bi ba fidi ki luodi o nilo ne ki ŋa o li ya bi ki tie ke o pendi yeni mi maama Sesaari kani.” ");
INSERT INTO guxg_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ban jagi ke ti ba kua ku ñinbiagu ki gedi Itali, ke bi taa Pɔli yeni ya kpaada n sieni ki mubni Ogusti sejenba kobga yudaano nui nni, ke bi yii o Juliwusi. ");
INSERT INTO guxg_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ti den kua ya ñinbiagu n ñani Adramiti ki ba balni Asi ñinkunu. yeni ke ti den kua mi ñincianma nni. Aristarki, Maseduani diema nni Tesaloniki jua den yegi yeni ti. ");
INSERT INTO guxg_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lan fiifandi, ti den sedi Sidɔn dociamu nni, lankani, Juliwusi den kubi Pɔli yeni mi yanduanma, hali ki cabi o ke o gedi ki ban ga o kpiiba cangu. ");
INSERT INTO guxg_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tin ñani lankani, ti den suagi liiga mi ñincianma nni ki sedi Cihipri kpendegli kani, naani n legni ti yeni u faalu, kelima u faalu den togdi ti. ");
INSERT INTO guxg_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","tin pendi ki nagi Sisili yeni Panfili ñinkunu, ke ti sedi Miira, Lusi diema nni. ");
INSERT INTO guxg_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Lankani i ke sejenba kobga yudaano la ñinbiagu ke ku ñani Aleksandri ki caa Itali, Ke o kuani ti ku niinni. ");
INSERT INTO guxg_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tin fii ki cuoni waamu waamu nani dana bá, ki mɔndi ki pundi Kinidi, u faalu ki tuo ke tin tin cuoni, lanwani ii, ti den kpibi u sanu ki toli ki balni Kreti ñinkunu naani n liegi ki toli Salmɔni. ");
INSERT INTO guxg_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ti den cuoni yeni fala ki balni u ñinkunu hali ki ban pundi kaanu bá ke bi yii Feri Hafensi ki u kuu yeni Laseya dociamu. ");
INSERT INTO guxg_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ti den sedi likani ke li waagi waamu, kelima Juufinba nɔlolma mo den pendi o, li cenli ti sanu po ji den bia, lanyapo, Pɔli den tuodi ki waani ba, ");
INSERT INTO guxg_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ki maadi, “N yegni, N la ke tin bua fii ya sanu ne baa pia mi janjanma, ti go ba biani a bona boncianli, laa tie a tuga yeni ku ñinbiagu baba ka, ama, ti miana mo.” ");
INSERT INTO guxg_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama sejenba kobga yudaano den cengi o ñinbiakudlo yeni o bondaano maama i, o den ki cengi Pɔli maama. ");
INSERT INTO guxg_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kelima li den ki ŋani ku faawaagu ń cua ki naa ti li ñinbiayaali kani a ninbiakudla boncianla den cegli ba ke ban fii likani, biya ba mɔndi ki pundi Foniksi, ku fawaagu ń naa ba lanpo. Foniksi tie Kreti ñinbiayaali ki ye yaanga nintuali yeni yanbangu nintuali sanu po. ");
INSERT INTO guxg_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yanbangu faalu ń cili ki figi suo suo, bi den bani ke ban bua maama n yeni, ke bi yugdi ti kudkpiagdi, ki fii, ki balni Kreti ñinkunu, kaa fagi yeni li jaali. ");
INSERT INTO guxg_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ama lan yani waamu, ku faaciangu yu n figi yeni u paalu ke bi yii u Erakilɔn nũani li kpendegli po, ki figi boncianla. ");
INSERT INTO guxg_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ku ñinbiagu den ki fidi ki ba tuogi ku faaciangu; nani kun den ki tuo pegdima yeni ii, bi ji den ŋa ke ku faaciangu tugi ku ñinbiagu ki caa yeni gu kun bua naani. ");
INSERT INTO guxg_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ti den tɔgni ki balni naani ke Kawuda kpendegli legni ti; ti den la fala paaa ki ti fidi ki seni ki ñinbiabigu yaaga n ba faabi ti. ");
INSERT INTO guxg_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ban fidi ki yugdi ki ñinbiabiga ki kuani, ke bi taa u baabu, ki loli ki tabni ku ñinbiaciangu. Bi den jie ke ku ñinbiagu ń da ti gedi ki tuoni Sirti tanbiibenli, lanwani ii, bi den gbabi ki jiini a ñinbiacaba ki ji ŋa ke ku faagu tudi ku ñinbiagu. ");
INSERT INTO guxg_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ku taafaagu den figi ki pua ti hali boncianla, lanwani ii, bi den cili ki ñangi ku ñinbiagu tuga ki lu mi ñima nni. ");
INSERT INTO guxg_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Li daataali daali ku ñinbiagu tuonsɔnba den taa bi tuonsɔntiadi ki luni mi ñima nni. ");
INSERT INTO guxg_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nani lan den tieni dana ke u yienu yeni a ŋmaabila den ki ñani, ke ku taafaagu mo pua ti yeni, ti naa ji den daani ke ti ba baa faabma bakuli. ");
INSERT INTO guxg_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ban den tieni lanya dana kaa dini liba yeni, ke Pɔli sedi ku ñinbiagu tuonsɔnba siiga ki yedi ba, “N yegni, i den ya cengi n gadi, i den kan fii ki cua Kreti tin kua ya janjanma nni ke ti ye ne yeni tin biani yaali ne kuli. ");
INSERT INTO guxg_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","N ji tigni yi ke yin paani i pala, kelima ti siiga nni nilo ji kan biani o miali, li ya ki tie ku ñinbiagu yaagu n ba bia yaa ka. ");
INSERT INTO guxg_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kelima, ku ñiagu nni, min cɔlni yua ya sanŋɔdma ki go pugi ya tienu maleki won legdi n po. ");
INSERT INTO guxg_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ki yedi nni, 'Da jie Pɔli, a ba pundi Sesari nintuali, go diidi, U Tienu ŋancianma po, o guuni a yaaba n yegi yeni a ne ke obakuli kan biani o miali. ");
INSERT INTO guxg_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Lanwani ii, yin paanii pala kelima n bani ke li ba tieni wan waani nni maama i. ");
INSERT INTO guxg_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ama ti ba gedi ki tuoni kpendegli jaali i.” ");
INSERT INTO guxg_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tin pundi piiga n ñiataagu, ke ti li kubi ti sanu Adriatiki ñincianma po yeni, ku yɔgsiigu, a ñinbiakudla tama ke ti nagdi gbangbanli i. ");
INSERT INTO guxg_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ban bigni mi ñima ñuamu, ki la miada piina (m 40); lan gedi waamu ban biigi ki la miada piitaa (m 30) ");
INSERT INTO guxg_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bi den jie ke ti ba tuoni tangbaagu i, lani n den cedi ke bi jiini ku ñinbiagu kugkpiaga na, ki ji jaandi ke lan fandi tonma. ");
INSERT INTO guxg_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","A ñinbiakudla den bua ban ña ki ŋa ku ñinbiagu, ki jiini mi faabma ñinbiabiga mi ñima nni, ki ji tie nani bi bua jiini liiga ya kudkpiagdi yeni, ");
INSERT INTO guxg_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ama Pɔli den yedi seje yudaano yeni sejenba, “Bi niba ne yaa ye ku ñinbiagu nni, i kan baa faabma.” ");
INSERT INTO guxg_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Lanwani ii, sejenba den jia ki ñinbiabiga baabi ki ŋa ke ki gedi fagma. ");
INSERT INTO guxg_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Lan cili ki fandi, ke Pɔli paani bi pala ke ban la mi jiema ki di. O den maadi, “Dinne tie li piiga n danaali n yeni ke i guu kaa di liba kuli; jiema ki kua i ñɔbu nni. ");
INSERT INTO guxg_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Lanwani ii, n paandi i pala ke yin kali ki bɔgdi mi jiema ki taani ki di, kelima li ba todi yin baa mi faabma. I siiga bá niyendo kan biani o yudi bá yuyengu.” ");
INSERT INTO guxg_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Wan maadi lani, ke o taa kpanu, ki jaandi U Tienu bi kuli ya nunbu nni. Ki ŋmiidi kpanu, ki cili ki ŋmani. ");
INSERT INTO guxg_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ke bikuli la li papaali ki dini. ");
INSERT INTO guxg_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ti den tie niba 276 ku ñinbiagu nni. ");
INSERT INTO guxg_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ban dini ki guo, ke bi luni ban tugi ya ŋalkaama (kpanu tiibima) mi ñima nni, ki bua ban yuagi ku ñinbiagu. ");
INSERT INTO guxg_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lan den fandi i, bi den ki bandi ban nanli ya tinga, Ama bi den la ñinlaagu ke ku jaali tie tanbiinbenli. Bi den maali ke ban gedi ki sieni ku ñinbiagu lankani i. ");
INSERT INTO guxg_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bi den jia ti kudkpiagdi ki ŋa ke ti mii mi ñima nni, layognu ke bi pɔbdi ki duoni a ñinbiacaba ke u faalu pieni ku ñinbiagu ki gedi yeni gu li jaali po. ");
INSERT INTO guxg_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bi den sedi faali lie ń cendi naani i, ke ku ñinbiagu gedi ki feli ku tanbiingu nni. Liiga den feli ki cedi ke ku ñinbiagu se kaanyendu kaa migni. Ama a ñinguona den pua paama, ki mudi ku ñinbiagu puoli. ");
INSERT INTO guxg_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sejenba den jagi ke ban kpa a kpaada, ban da ti dugi ki ciadi. ");
INSERT INTO guxg_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ama sejeyudaano den bua wan faabi Pɔli, lani n den cedi ke o yie bi jagli. O den yedi ke yaaba n ba fidi ki dugi mi ñima ń dugi ki pundi li jaali po. ");
INSERT INTO guxg_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ya niba n sieni den ŋɔdi bi tiaba i a taaba po yaaba n sieni ban baa yaali ku ñinbiagu nni, ke li ba todi ban dugi ki pundi li jaali. Li den tieni yeni i, ke tikuli baa mi faabma ki pundi li jaali (ki tinga) po. ");
INSERT INTO guxg_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tin den ciadi, ke bi gedi yeni ti li jaali po, ke ti bandi ke li kpendegli yii Malti. ");
INSERT INTO guxg_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bi dogtieba den ki ga ti cangu baba ka, ama bi den cuoni u mu ti po kelima ki taaga yeni ti waadi po. ");
INSERT INTO guxg_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ama Pɔli ń baani ti baadi ki tieni u mu nni, ke ku muwalgu tuogi li waalabli ke li finfini o nuu. ");
INSERT INTO guxg_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bi dogtieba ń la ke li waalabli juani Pɔli nuu, ke bi ji maadi bi ŋmiali nni k tua. “Ya nilo ne baa tie nikpalo i, ke sani ki ciadi mi ñima nni, ama yeni wan ciadi mi ñima nni kuli, U Tienu teginma naa tuo ke wan ya pia miali.” ");
INSERT INTO guxg_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ama, o den yogi ki luni o waa o mu nni, ke bonliba ki tieni o. ");
INSERT INTO guxg_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bi den guu ke u yukɔnu ń cedi wan mɔli, bii wan ti cii ki baa ki kpe i. Ama ban den li kpaagi o ke li waagi ke liba kuli ki pia o, bi den lebdi bi maalma ki yedi ke o baa tie bulo i. ");
INSERT INTO guxg_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Mi tinfanma den ye kaa fagi yeni likani, ki tie li kpendegli yudaano ke o yii Pubiliyusi ya tinga. O den ga ti cangu bonŋanla hali dana taa. ");
INSERT INTO guxg_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Li sua ke u yukɔnu yeni ki canbuonga cuo Pubiliyusi báa. Pɔli ń gedi o kani, ki jaandi, ki maani o nui o po, ki tebi o. ");
INSERT INTO guxg_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Lani ń pendi, ya niba n den yia li kpendegli po kuli den cua Pɔli kani ke o jaandi ke bi paagi. ");
INSERT INTO guxg_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bi dogtieba mo den cɔlni ti, ki tieni ti li seli. Tin den bobindi ki bua fii ki cabi ba, bi den teni ti yaali n tie ti bonbuakaana. ");
INSERT INTO guxg_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Lan tieni ŋmaali taa, ke ti kua ya ñinbiagu n den ye li kpendegli kani ku faawaagu yognu, Aleksandri ñinbiagu ke “A bulileba” nannanli ya ku po ");
INSERT INTO guxg_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Lan pendi, ti den sedi Sirakusi, ki tieni dana taa. ");
INSERT INTO guxg_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Tin ñani likani, ti fii ki gedi Rejiyo dociamu nni. Tin tieni dayenli, ke ku faagu ñani yanbangu ki luodi, dana lie siiga ke ti pundi Pusolesi dociamu nni. ");
INSERT INTO guxg_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Likani, ti den kadi yeni ti kpiiba ke bi ga ti cangu dana lele. Ti den kubi yeni i ki ban pundi Roma. ");
INSERT INTO guxg_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Lankani ke ti kpiiba den gbadi ti maama, ki tuogi ti hali ke ti da ye Apiwu daaga nni yeni A Candietaada kani. Pɔli ń la ti kpiiba, ke o jaandi U Tienu ki ba li papaali. ");
INSERT INTO guxg_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tin pundi Roma, bi den cabi Pɔli ke o ye o baba i wani yeni seje yua n guu o. ");
INSERT INTO guxg_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Lan tieni dana taa ke Pɔli yini Juufinba yudanba ki taani. Ban pundi, ke o maadi ba, “N kpiiba, bake mii tieni tudma bakuli, ke mi nua ti buolu, bii ti bogda bii ti jaajanba, bi cuo nni nani kpaadli yeni Jerusalema, ki mubni nni Roma yaaba nui nni. ");
INSERT INTO guxg_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ban den buali nni ibuali, bi den jagi ke ban cabi nni, kelima, baa den la min tieni yaali ke li dagdi yeni mi kuuma cuonu. ");
INSERT INTO guxg_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama Juufinba ń den yie bi maama, li den tua n po taladi ke mi suagi n maama o badciamo Sesari kani, Li naa tie ke n pia jalgi bakuli n buolu po. ");
INSERT INTO guxg_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kelima min suagi ti buudi ne yeni i, ke n mia ke min kali yeni yi, ki maadi yi min pia ya maama. Kelima Israyeli dandanli po ke n ye yeni i kudseseli ne.” ");
INSERT INTO guxg_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ke bi yedi o, “Ti ki kpeliki ga tisɔnkaali, ke li ñani Jude, ki maadi a maama, ti kpiiba siiga nni mo obakuli ki kpeli togdi a maama ki maadi a po bonbiigu. ");
INSERT INTO guxg_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama ti bua tin cengi fini aba kani i, ŋan pia ya maalma u jaanbuolu yeni po, kelima ti bani ke i kaani kuli, baa pia maalŋanma bakuli li jaanbuolu po.” ");
INSERT INTO guxg_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ban bili o ya daali, bi niba boncianla den cua o kani, wan ye naani. Ke o waani ba o maama, ki tieni kasiedi, ki waani U Tienu diema. O den cili siŋaagu hali yeni ku yenjuogu, ki taa sani lie kuli ki ba lebdi bi yama, ban tuo ki ga ke Jesu maama tie maamɔnma, yini n tie Moyiisi yiko tili yeni bi sawalpuaba maama. ");
INSERT INTO guxg_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bi niba bi siiga den tuo ke wan maadi ya maama tie mɔmɔni, ama bi tianba den ki dugi o maama po. ");
INSERT INTO guxg_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nani bi maama ń den ki cendi yeni, bi den yadi ki kuni ya yogu ke Pɔli maadi ba ya lanbona ne, “Mi Foŋanma den pia i mɔni man kadi ki waani i yaajanba o sawalpualo Esayi maama nni. ");
INSERT INTO guxg_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","O den yedi, 'Gedi ya nibuolu ne kani, ki maadi ba, “I cengi yeni i tuba, i naa gbia; ki nua yeni i nuni, ama i naa gbia niima nni. ");
INSERT INTO guxg_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kelima ya nibuolu ne pali tadi ki juagi, baa gbia bonŋanli yeni bi tuba, ki ŋubni bi nuni. Bi jie ke ban la yeni bi nuni, ki gbadi yeni bi tuba, ki go gbadi niima nni yeni bi pali, ki da ti lebdi bi pala, min tebi ba.” ");
INSERT INTO guxg_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Lanwani ii, yin ya bani ke bi sɔni ki waani bi nilanba U Tienu ŋanbli, ke bi tuo ki ba cengi, ki ba ga li.” ");
INSERT INTO guxg_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Wan maadi lan ya maama, ke bi yadi, ki gagi bi ŋmiali nni boncianla. ");
INSERT INTO guxg_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔli den tieni binmuna lie i wan den haya ya diegu nni, ki gaani yaaba n caa o kani kuli. ");
INSERT INTO guxg_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","O den wangi U Tienu Diema maama, ki go tundi ba yaali n nua O Diedo Jesu Kiristi po yeni li papaali. Nilobakuli den ki pani o o tuona po. ");
INSERT INTO guxg_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mini Pɔli, Jesu Kiristu tuonsɔnlo, ke bi yini nni ke min tua ya tondo ke o gagdi ki baa wangi U Tienu laabaalŋamo, ");
INSERT INTO guxg_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","U Tienu bo tuodi ki niani, ki cedi ke bi sawalpuaba diani a tilŋama dianŋami nni, ke li ba tua yeni, ");
INSERT INTO guxg_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ke li nua o Bijua yua n mali, ki tie Dafiidi puolŋuanu, yaa tie ti gbannandi po. ");
INSERT INTO guxg_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ke li dɔgdi yeni U Tienu Foŋanma paaciamu, ki waani ke o tie U Tienu Bijua ki dugni o iedma bi kpienba siiga, wani yua n tie Jesu Kiristu, T Diedo. ");
INSERT INTO guxg_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Wani ya po ke ti baa li ŋanbli, ki tua o tondba ki ba cedi o yeli po bi nilanba ń tuo ki ya cɔlni, ki go dugi o po. ");
INSERT INTO guxg_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Yinba yaaba ke Jesu Kiristu yini ne, i mo ye li nibuoli siiga nni. ");
INSERT INTO guxg_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","N diani li tili ne yinba yaaba n ye Roma, ki tie U Tienu buakaaba, ke o gagdi ki yini yi ke yin tua niŋanba: U Tienu ti Báa yeni ti Diedo Jesu Kiristu ń puni yi li ŋanbli yeni mi yanduanma ! ");
INSERT INTO guxg_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","N dá ba tieni U Tienu balga Jesu Kiristu yeli po yinba ya po, kelima ŋanduna kuli bani i dudugdi ń caa ki se naani. ");
INSERT INTO guxg_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","U Tienu, min tuuni yua ya po, ke li nua o Bijua laabaalŋamo, tie n kasiedi, ke n maadi i maama daali kuli kaa cedi. ");
INSERT INTO guxg_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","N miadi n jaandi nni kaa cedi, ke li ya tie o yanbuama po, min baa u sanu yeni li pamanli ki cua yiani. ");
INSERT INTO guxg_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kelima n bua min la yi, ki bɔgdi yeni yi U Tienu Foŋanma paabu, yin fidi ki ya se taajala lie ke li paa. ");
INSERT INTO guxg_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Lani yaa ka, n ya cua i siiga, ti kuli ń taani ki baa li papaali kelima yinba yeni mini ń taani ki pia ya dandanli po. ");
INSERT INTO guxg_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","N naataani, mii bua min wuoni yi ke n yen kali, ki jagi ke min cua i kani, ki la yi, ki cie ya luana n ye i siiga yeni ya nibuoli n sieni; ama hali yeni mɔla kuli, n dá ki ba sanu. ");
INSERT INTO guxg_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Li tie n po panli i, ke min gedi ki la Girekinba yeni bi yanbɔndanba, ki gedi ki la a gbanbanda yeni yaaba n ki kua cogu kuli. ");
INSERT INTO guxg_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Lanyapo, li tie n po buamɔnma i, ke min kpaandi ki waani yinba yaaba n ye Roma po, o laabaalŋamo. ");
INSERT INTO guxg_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kelima mii ji jie fee yeni min waani o laabaalŋamo: li tie U Tienu paaciamu faabma i, yua n daani kulipo; ki cili juufinba ki tuadi Gilekinba ");
INSERT INTO guxg_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Li laabaalŋamo n dɔgdi ki wangi U Tienu teginma yaama n ŋua li dandanli, ki go tie li dandanli po, nani lan diani maama: “O niteginka baa fo o dandanli po. ");
INSERT INTO guxg_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","U tienu panbienli ñani tanpoli ki ddɔgdi, ki yie bi niba tuonbiadi kuli po yeni yaali n ki tuagi i mɔmɔni sanu po bani yaaba n cedi ke bi tuonbiadi dɔgni i mɔmɔni. ");
INSERT INTO guxg_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kelima lan buali ke ban ya bani U Tienu po yaali ki duagi ba bá waamu; U Tienu wani o bá n waani ba. ");
INSERT INTO guxg_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Lanyapo, U Tienu ŋandi yaadi n ki pia bianu, O paaciamu yuu n ki pia gbenma yeni o yenyema ki duagi ba; bi nua likuli yeni bi nuni, hali ŋanduna tagma. Ti ya diidi wan tagi yaali kuli, bi niba ki pia ban ba yedi yaali ki faabi bi yula. ");
INSERT INTO guxg_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Kelima, ban bandi U Tienu, bi naa kpiagi o nani o tie U Tienu; baa tieni o balga yeni o tuonŋama; ama bi maalbiidi biani ba ke bi luoni bi pala ki ki kua li biigli nni. ");
INSERT INTO guxg_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bi tie ti japaadi ki maali ke bi tie yanfodanba i, ki na tie gaada. ");
INSERT INTO guxg_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bi lebdi U Tienu yua n ki pia juodma yudandi ki nan ŋua ya bonnannandi tie o nisaalo yua n ba kpe, lani yaa ka ti bonyugditi, ti yandi yeni a bonbalinkaana. ");
INSERT INTO guxg_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Lani ya po i ke U Tienu tulni ba ti tuonjɔgindi po, ke ban ya tiendi bi pala ń faadi yaali; ke bi ji tie bi ŋmiali nni, yaali n pia i fee, hali ki biidi bi gbanu. ");
INSERT INTO guxg_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bani yaaba n lebdi ki ŋa U Tienu mɔmɔni, ki nan ŋua mi tofaama, bani yaaba n kpiagdi U Tienu tagma ki nan ŋa wani o tagdo yua dagdi yeni ya kpiagdi n ki pia gbenma. Ami ! ");
INSERT INTO guxg_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Lanyapo i, ke U Tienu tulni ba ke bi faadi ti tuonjɔgindi yeni i fee tuona: Kelima bi puoba ŋa U Tienu ń tagi ba yaali ya po ki ŋɔdi ti cancagindi tuona. ");
INSERT INTO guxg_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bi jaba moko, lani n yeni, bi ŋa ban tagi o pua yaali ya po, ki fiindi bi gbanu, ki ŋua b jalieba ki cagni bi yula ki fiagdi bi bá. Bi ba baa bi gaadyema ń dagdi yeni ya pani. ");
INSERT INTO guxg_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nani ban den ki maali ke ban bandi U Tienu yeni, U Tienu mo ŋmagdi ba bi pala ń bua ya tuonjɔgindi po i, ke ban ya tie ya bona n ki pia mayuli. ");
INSERT INTO guxg_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bi pala gbie yeni yaali n ki tiegi kuli, mi biadma, mi ŋaanma, bu nunfanbiadbu, ki nanga, mi kuukpama, li kɔnkɔnli, mi niama, ku tugtongu, ");
INSERT INTO guxg_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Bi tie dokpala, jonjondanba, yenyiekaaba, japaadanba, maciandanba, tuonbiididanba, danyiekaaba yeni yanluodanba. ");
INSERT INTO guxg_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bi tie yanpiidanba, ŋanwaadanba, bi yama ki siadi bi nisaallielo po, baa pia niñingbadma mo. ");
INSERT INTO guxg_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bá ke bi bani U Tienu buudi po, ki bani ke yaaba n tie lan ya bona dagdi yeni mi kuuma; baa tie li bona baba ka, ama bi go taa yaaba n tie li bona po, ki go puuni ba i mɔni. ");
INSERT INTO guxg_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yeni ke fini yua jiagi a lieba buudi ke a mo yaa tieni li bona ke bi baa jaliga kelima fini n buu ki gɔ tiendi ti biidi. ");
INSERT INTO guxg_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ama ti bani ke u Tienu biidi jiama nua yaaba n jiindi i mɔni po. ");
INSERT INTO guxg_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ama fini yua jaligi a lieba, ke nan tie li bona a maali ke a bu ñaa ti buudi nni i? ");
INSERT INTO guxg_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Bii a yini U Tienu bua cianla, o sugli yeni o pasɔngili kuli fanmi a? ");
INSERT INTO guxg_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kelima maa a kangbadima po n cedi ke U Tienu pali biidi yaa daali ke o jiagi ti biidi. ");
INSERT INTO guxg_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Wan yua bigindi yua kuli yeni o tuona, ");
INSERT INTO guxg_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ki caa liiga ki kpaani U Tienu kpiagili yeni yaa miali n kan gbeni. ");
INSERT INTO guxg_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ama bi japadanba yeni kanmaadi mɔni nba, a kangbada yeni bi mutuodanba, ");
INSERT INTO guxg_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","yaalidigu yeni li ŋmadili bu cua yaa nalinga n tieni bonbiilikuli po, cincinli Sufinba yeni yaaba n ki tie Sufinba. ");
INSERT INTO guxg_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ama li pamanli yeni ti ŋandi n yaa ye yaaba n tiendi yaala n ŋani, cincinli Sufinba yeni yaaba ki tie ba, ");
INSERT INTO guxg_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","kelima U Tienu ki pia bɔgili. ");
INSERT INTO guxg_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Li yapo yaaba ke yikodi baa cuo ba yeni yaaba n yie ti yikodi kuli kpe le nni. ");
INSERT INTO guxg_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kelima yaaba n cindi ti yikodi kaa tie yaaba n mɔni U Tienu po, ama yaaba n suani yeni laa. ");
INSERT INTO guxg_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kelima yaaba n ki bani U Tienu yaa kpagi ti yikodi, bi tieni li po yeni kelima ban mɔno bu tua yikodi i. ");
INSERT INTO guxg_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Li po, wangi yiko tuona yanjagili tie sieda, ");
INSERT INTO guxg_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","maalima wangi yaa daali ke U Tienu baa bu bi niba ki tɔgini Jesu Krisiti labaamanli po. ");
INSERT INTO guxg_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","A yaa yii sufa, a ye ti yikodi ki kpanmi yeni U Tienu, ");
INSERT INTO guxg_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ki bani o buama yeni li bona yia ke yikodi bo cabi, ");
INSERT INTO guxg_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","A yaa tie a juama yeni li bonbonli nni ŋmagidi ka, ");
INSERT INTO guxg_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ki yendi bi yanbondanba, ki tundi bi tɔba, daa maali ke a mi banma yeni i mɔni kaa. ");
INSERT INTO guxg_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Li yaa tie ke a tundi bi niba, be n cedi ke a ki tundi a baa i? A tundiki ban daa su, a ki suu? ");
INSERT INTO guxg_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Fini yua tundi ke ban daa conmi a ki conmi i? Fini yua yie a pada a ki su ti jandie nni i? ");
INSERT INTO guxg_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","A wangi a baa ke U Tienu teni fini o maama ke gɔ ji kuandi o i fe kelima a ki cɔli nni o maama. ");
INSERT INTO guxg_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kelima bi nundi U Tienu ki dugini a yaa po i nani lan diani yeni. ");
INSERT INTO guxg_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ti kɔndi ŋani li ya sua ke a cɔlini ti yikodi, li ya sua ke a yie, a kɔndi bu tua fanma i. ");
INSERT INTO guxg_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Li yaa sua ke jelo cɔlini yikodi, o gua tie jeli yaa? ");
INSERT INTO guxg_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Jeli yaa cɔli nni yikodi, o ki pia mabili nani fini yua bani o ki yie yeni? ");
INSERT INTO guxg_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Li yapo sufa mɔno tie yua lebdi o pali, li ki tie o gbanandi po kaa. ");
INSERT INTO guxg_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","kelima ti kɔndi tie li pali nni, i diani po kaa. O nilo donda ki ŋaa o kani kaa, U Tienu kani. ");
INSERT INTO guxg_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Roma yaaba pia be ke li cie ya nibuoli n sieni, ku kɔnciagu ñuadi tie be? ");
INSERT INTO guxg_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Lan tieni maama kuli, li mɔni boncianla kelima, U Tienu kpia ki mubni bani i, o ñɔmaama. ");
INSERT INTO guxg_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Be ya po i! Bi siiga nni, tianba yaa dugi, bi yenyiema ba fidi ki buoni U Tienu ń niani ba yaala i? ");
INSERT INTO guxg_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Lani waa ye! bá bi niba kuli ya tie tonandanba, U Tienu wani li tie mɔmɔndaano i, nani lan diani maama yeni: «KI fidi ban bandi a maama nni ke a tiegi, a ya buni yeni bi niba mo, ŋan paadi ba.» ");
INSERT INTO guxg_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ti biadma ya dɔgdi U Tienu teginma, ti ba maadi be? U Tienu ya waani o pabienli ti biadma po, waa ji tiegi ii? (N maadi nani bi nisaalba ń maali maama i) ");
INSERT INTO guxg_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","yeni ka! U Tienu ya ki tiegi o ba bu ŋanduna ledi i? ");
INSERT INTO guxg_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","N tofaama ya dɔgdi U Tienu mɔmɔni, ki waani o kpiagdi, li ba ga ledi i, ban bu nni nani n tie biidi daano yeni i? ");
INSERT INTO guxg_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nani nitianba ń tabi ku tuotabgu ki tua ke ti maadi maama: «Be n cedi ke ti kan ya tiendi mi biadma, man yuandi ki cua yeni li bonŋanli?» U Tienu ba bu, ki cuo ba lan buali maama. ");
INSERT INTO guxg_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Lanwani i, i maali ke ti tie nimɔnba yo oo? kalam! Kelima ti bontitiedi waani ke tikuli Jufinba yeni ya nibuoli n sieni kuli ti tuonbiadi n yendi ti. ");
INSERT INTO guxg_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nani lan diani maama: «Niteginka ji ki ye bá niyendo.» ");
INSERT INTO guxg_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","nilobá kuli ki pia yanfuoma. obá ki lingi U Tienu, bikuli bodi, bikuli tua yanpiidanba; ");
INSERT INTO guxg_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bá niyendo ki ye, ki tiendi yaali n ŋani, bá niyendo. ");
INSERT INTO guxg_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Bi kodgu tie kakuyaanli. Bi kubi bi lanbu ki pua mi tofaama, bi ñɔgbana gbie yeni ti waalɔbdi. ");
INSERT INTO guxg_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Bi ñɔna gbie yeni ti solindi yeni ku tugtongu. ");
INSERT INTO guxg_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Bi taana yua mi sɔma wulma po. ");
INSERT INTO guxg_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","U ŋmanbiidi yeni li yubɔnli n ye bi sanu po. ");
INSERT INTO guxg_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bani ki bani mi yanduanma sanu; ");
INSERT INTO guxg_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Bi nuni ki bani U Tienu fangli. ");
INSERT INTO guxg_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","To mɔla, ti bani ke yiko ń bili ya ñɔmaama, o bili ma yaaba n cɔlni li yiko po i, ke yuakuli ń fidi ki mubni o ñɔbu, ke ŋanduna kuli ń bandi o biidi U Tienu nintuali. ");
INSERT INTO guxg_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kelima, obá kuli kan fidi ki maadi ki faabi o bá U Tienu nintuali ki dugni o cɔlni yiko ń bili yaali. Kelima yiko n cedi ke o nilo bandi ti biidi. ");
INSERT INTO guxg_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ama, mɔlane, yiko baba ka; U Tienu go dɔgdi o mɔmɔni ke bi bandi, ke yiko yeni bi sawalpuaba tieni kasiedi. ");
INSERT INTO guxg_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","U Tienu saa i mɔmɔni yaaba n dugi Jesu Kiritu po ki pia li dandanli. Paadma bá kuli ji ki ye. ");
INSERT INTO guxg_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Kelima yuakuli tieni ti tuonbiidi kaa ji dagdi yeni U Tienu kpiagdi. ");
INSERT INTO guxg_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ama U Tienu ŋanbli po, ke bi faabi ba Jesu Kiritu daafaabma sanu po. ");
INSERT INTO guxg_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Kelima U Tienu bo tuodi ki lugdi wani Jesu Kiristu, ke o ba tua ti candandi yaaba n dugi o sɔma po, ki fidi ki waani o teginma, kelima, yogu bá, o bo ŋa kaa buni ki cuo bi niba bi tuonbiadi po, ke wan waani o juunli. ");
INSERT INTO guxg_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ki waani o teginma mɔlane, ke bi niba ń bandi ke o teginma po, o ba faabi yua n dugi Jesu Kiristu po. ");
INSERT INTO guxg_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Be ya po i, ke o nisaalo baa kpiagdi o yuli? Laa tuo. Ti laa yikodi i? A tuoŋana yikodi bii? N n, ti dudugdi yikodi po. ");
INSERT INTO guxg_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kelima ti maali ke o nisaalo ba mi faabima ti dudugdi po i, ama yiko cɔlindi tuona po ka. ");
INSERT INTO guxg_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Bii U Tienu tie Jufinba tienu baba i? Waa tie bi nilanba mo ya tienu yo oo? Nn o tie bi nilanba mo ya tienu. ");
INSERT INTO guxg_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Kelima tienyendu baba n ye, ki ba faabi yaaba n kua ku kɔnciagu yeni yaaba n ki kua ku kɔnciagu. ");
INSERT INTO guxg_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ti ji fanbi yiko, ki ŋua ti dudugdi yoo? Kalam! Ti dɔgdi ki waani yiko ń pia ya mayuli i. ");
INSERT INTO guxg_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ti baa yedi ledde ti yaaja Abalahanma po o den ba laa panpaani ti gba nandi po? ");
INSERT INTO guxg_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","li yaa den tie k Abalahanma tuonŋanma po ki den yia o o ni moano n den baa fidi ki kpiagi wani o ba, ama utienu yaa nin tuali ka ");
INSERT INTO guxg_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","lani yaa po ki diani yedi? Abalahanma den daani utienu keli po teni ke o yino niteginka. ");
INSERT INTO guxg_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","moala po yua n soani li tuonli baa ba o panpaani o kanbaa ki yaa nua ke li tie paabu ka ama ke li tie panpaani. ");
INSERT INTO guxg_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","li tie yene yua n ki soani tuonli ki nan daani yua n tiendi mi teginma po o biidi daano po ba coadi o mo yaa dandanli ki li tiegi ");
INSERT INTO guxg_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","yene ke Dafidi mo gaali ki ŋalibaliga ye yaa nilo ke utienu n ki coadi yua yaa teginma kelima o tuona po ki nan yedi, ");
INSERT INTO guxg_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","li pamanli ye yeni yaaba n ba sugili bi bi biadima po yeni utienu n piini yaaba yaa tuonbiidi, ");
INSERT INTO guxg_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","li panmanli ye yeni ti yonbidaano n kan go tiadi yua yaa tuonbidi pon ");
INSERT INTO guxg_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","nani laa pamanli baa tie yaaba n kua ku koanciagu bebe yaa po yo? kelima li yedi k Abalahama den daani utienu ke utienu nualo ke o tie niteginka ");
INSERT INTO guxg_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","o den tie lede ke o den nuali o teginma? yaa yoginu ke Abalahama den kua ku koanciagu bi ke o daa den kua gu? yaa yoginu ke o daa den kua ama ki tie jelo. ");
INSERT INTO guxg_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abalahama den ba ku koanciagu nannanli ke li tie li dandanli teginma pengu, yaa yoginu ba ke daa tie jelo ki wan tua ba yaaba n daani kuli po ke wan nuali bi mo ki nunmanga ki bi tiegi ");
INSERT INTO guxg_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ki wanga yaaba n tie junga yaa ba ki laa tie ti coanli bebe kaa, ama ke li tie yaaba n cuoni li dandanli nni yaa tana, nani ti baa Abalahama yaa dandanli yeni, hali ke o daa den kua o koanciaguu. ");
INSERT INTO guxg_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Li naa tie li bali maama yaapo ka ke u Tienu den niani Abalahama yeni o puoli ŋuani kuli ko ba cabi ban diedi ŋanduna. Ama ki li tie li dandanli teginma po. ");
INSERT INTO guxg_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","li yaa tie li bali maama yaa kubima ke ti baa tie o faaajielo lanwaani li dandanli tie fanfanma u ñoanianu mamo baa bodi ");
INSERT INTO guxg_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","kelima li balimaama baa cuani UTienu pabienli ama li bali maama yaa ye naani libali maama miidima moko ki ye. ");
INSERT INTO guxg_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","li yaa po ki yaaba n ba ba onñoanianu ba kelima li dandanli yeni o ŋanbili po, ke lan tindi yaaba n tie Abalahama puoliŋuani ba yaaba n ki da tie yaaba n tuo li bali maama bebe ka ama yaaba n pia abalahama yaa dandanli (yua n tie ti kuli yaa ba) ");
INSERT INTO guxg_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","nani lan diani maama n cabi ki tua yi nibuoli yeni mi diecianma kuli yaa ba ki go tie yaaba n daani utienu kuli yaa ba yua n tiendi li miali yaaba n kpe, ki go cedi yaa bonla n ki ye n tua yaaba n ye. ");
INSERT INTO guxg_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","yeni yaa maama n den ye o po kuli Abalahama dandanli utienu nni kili pia wan guu yaala yeni wan baa tua mi diecianma kuli yaa ba nani wan den yedi o, maama, li kuli baa tua o yaa puoli ŋuani nni. ");
INSERT INTO guxg_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abalahama dandanli ki den jiidi ba ke o den pia bina kobiga, ke o gbanandi tadi yeni o pua Sala bina den pendi ti madi. ");
INSERT INTO guxg_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ama o den kpiagidi utienu ki daano ke o baa tieni opo o ñoaniani kuli o ki den tie pajuagili daano. ");
INSERT INTO guxg_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","o den ŋanbi ki daani ki go bani cain ke utienu n niano yaa ñoaniani kuli o baa tieni la. ");
INSERT INTO guxg_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","li yaa po utienu den ŋanbi opo ke o tie yua n tiegi. ");
INSERT INTO guxg_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","laa tie Abalahama bebe yaa po ka, ama o den diani ki bua wan ŋanbi li kuli. ");
INSERT INTO guxg_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","utienu den guani ki diani ke li tie ti moko yaa po wan baa nuali yaaba ke ti tiegi tinba yaaba n daani ti yonbi daano jesu kilisiti yua nden fii bi tinkpiba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","naan kani ke o den gaa ti tuon biidi ki kpe, ki gua ki fiini ti ke ti tiegi. ");
INSERT INTO guxg_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Tin dugi Jesu po n cedike ti laa u faabu, kiguani ki mangi yeni UTienu. ");
INSERT INTO guxg_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","o ŋalibaliga po n cedi ke ti dugi o po yeni, ti mo pia ti ñuadi o kani. ");
INSERT INTO guxg_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Tin ji yaa mangidi ti pali fala nni ki nan bandi ke fala n baadi yeniania. ");
INSERT INTO guxg_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ania n baadi yenili dandanli. ");
INSERT INTO guxg_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Li dandanli mo kan bɔndi nilo kelima U Tienu fuoŋanmi nteni U Tienu buama ti pala nni. ");
INSERT INTO guxg_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","K i dugini, yaa yogunu ke ti daa bo pia paalu, Krisiti bo kpe yaaba n bo yeti biidi nni po. ");
INSERT INTO guxg_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Yaa yogunu ke nilo ba kpenli o mɔnkundaano po; laa kandi u bo kpenli numɔno po i. ");
INSERT INTO guxg_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ama U Tienu wan n tie o buama kelima Jesu bo kpe ti po, yaa yogunu ke tidaa bo tie biididanba i. ");
INSERT INTO guxg_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Mɔla po u sɔma n cedike ti ji tie mɔnkundanba yeni i, tijibaa ciadi yeni U Tienu mutuoli. ");
INSERT INTO guxg_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ke dugini, yaa yogunu pendi, ti bu tie u yibala i, ke jiti guani ki mangi yeni U Tienu ki tɔgini u biga kuuma nni po, ke o miali n fie ti. ");
INSERT INTO guxg_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Laa ki gbeni, tin mangi ti pala ki tienu U Tienu baligi, ti Diedo Jesu Krisiti po, yua n cedi ki ti guani ki kangi yeni U Tienu. ");
INSERT INTO guxg_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nani ti biidi n tɔgini nifosaalo yendo po ki kuani b niba kuli ti biidi nni ke li baa yendi bi kuuma yeni, ke yua n ji biidi kuli wan kpe. ");
INSERT INTO guxg_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","kelima halin lan ciliti yikodi yogunu i ke ti biidi kua dulña nni. ");
INSERT INTO guxg_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ama mi kuuma cili hali Adama yogunu ke pan pundi Moyisi yogunu, ki gadi liiga yaaba n bobiidi ki naa naaniAdama yua n bo baadi. ");
INSERT INTO guxg_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Faala paabi ki naani nani ti biidi yaala. Niyendo yaa biidi po n cedi ke boncianla bo kpe, Jesu Krisiti ŋalibaliga yeniu paabu jiidi niba boncianla po. ");
INSERT INTO guxg_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","O nuyendo yua n biidi n baa yen yaala ki taa yeniu paabu. ke nuyendo biidi puolu po mɔ cedi ke ti buudi baa yeni kutubŋmaali, ke faala paabu yali baa yeni ti mɔnkundi mɔ ti biidi boncianla puoli lipo. ");
INSERT INTO guxg_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Niyendo baba yaa biidi yo baa yeni mi kuuma, boncianla mɔ baa gaa ŋalibaliga bonciala yeni ti monkundi fala paabu JesuKrisito baba kani. ");
INSERT INTO guxg_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Lan wani, nani niyendo baba yaa biidi n cedi ke yuakuli n kpaadi biidaano lani gɔ cedi ke niyendo mɔnkuntuonli po mɔ cedi ke u paabu teni li mialibi niba kuli. ");
INSERT INTO guxg_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nani niyendo kan cɔlini po n cedi ke yuakulijitie biididaano, to, niyendo mɔ yaa cɔlini po ba cedi nilo kuli n kpandi mɔnkundaano. ");
INSERT INTO guxg_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","To ti yikodi mɔ nan baa ke ti biidi n ŋanmi ki yabidi i. Ama t biidi n yabi naani, ŋalibaliga ŋam ki gbie la kani. ");
INSERT INTO guxg_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Lan kuli ne tieni, nani ti biidi n ba yeni n kuumi n yeni, ŋalibaliga n tɔgini ti mɔnkundi lan baa yeni yaa miali n ki pia gbema ti Diodo Jesu Krisiti kani. ");
INSERT INTO guxg_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ti baa yedi be? Tin ki ye ti tuonbiadi nni ke U Tienu ŋanbili ye ti po ki pugidi? ");
INSERT INTO guxg_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kelima; tim yaaba n kpe ti tuonbiadi po, li baa gaa ledi i tin gɔ yaa fuo ti tuonbiadi nni? ");
INSERT INTO guxg_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","I bani yaa yogunu ke bi den wuli i U Tienu ñinma Jesu Krisiti nni, ke o kuuma po i ke i den wuli i? ");
INSERT INTO guxg_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Lanwani, tin den wuli yeni, bi dentaani ki piini ti yeni o o kuuma nni lan fidi ke o baa n baa ti kpiagidi, li tie u paalu n den teni ke Krisiti fii bi tinkpiiba siiga maama, ti moko baa yaa ye yeni li miapanli yeni. ");
INSERT INTO guxg_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kelima ti den taani ki yeni o, ti gɔ baa yiedi yeni o. ");
INSERT INTO guxg_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ti bani ke tin den tie yaa niba kpiama, ke ti ji ki tie bani ka kelima bi den taani kipiini ti yeni Jesu lan fidi ke tin gbannandi yia pia ti tuonbiadi n bodi ke tin daa ji daa tie ti tuonbiadi yonbi. ");
INSERT INTO guxg_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kelima yua n kpe fuodi yeni ti tuonbiadi. ");
INSERT INTO guxg_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Li yaa tie ke den kpe yeni Krisiti, ti gɔ baa yaa daani ke ti baa ye ki fuo yeni o. ");
INSERT INTO guxg_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ti bani ke Jesu den fii bi kpienba siiga, o kan gɔ kpe kelima mi kuuma ji kipia paalu o po. ");
INSERT INTO guxg_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Wan den kpe yaa kuuma, li den tie ti tuonbiadi yapo ke o den kpe yenma li kuli po, ama mɔla wan gua ye ki fuo, o fuo U Tienu yapo i. ");
INSERT INTO guxg_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Li tie yenma i mɔ yaa kani, ke yogunu baa, i den kpe i tuonbiadi po, ama mɔla, i fuo yeni U Tienu, Krisiti yapo. ");
INSERT INTO guxg_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Lani yapo, yin daa tuo mani ke ti tuonbiadi n yendi i gbannandi yaala n baa kpe, yin daa tuo mani ke yaa tiendi i gbannandi bonbuakala yaala kuli. ");
INSERT INTO guxg_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Daa taa mani i gbannandi ki tua jɔngidi tuonsɔntiadi ama yin taa mani i ba ki teni U Tienu yua n fuo nani yin kpe ke i gbannandi tua yaa tuonsɔntiadi n dagidi U Tienu po yeni. ");
INSERT INTO guxg_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Daa cabi mani ti tuonbiadi n paadi i kelima yiko ji kaa die i U Tienu ŋanbili n ji die i. ");
INSERT INTO guxg_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ti baa ye be? ti baa tiendi ti tuonbiadi kelima yiko paalu ji die ti; ama o ŋanbilia po? ");
INSERT INTO guxg_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Lanwani i bani ke yin tua yua yaa nacenba, i baa yaa cɔlini o, i tie yua ke i cɔlini o yeni yaa tuonsɔnba? ");
INSERT INTO guxg_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ama U Tienu yaa ŋanbili po kelima i den tie ti tuonbiadi yaa yonbi, ama i tuo ki cɔlini yeni i pali yaa tunda ke bi den teni i. ");
INSERT INTO guxg_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Bi den ñani i ti tuonbiadi nni kuli ke i jitua mi teginma yaa yonbi. ");
INSERT INTO guxg_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","N maadi nani i gbannandi n ki pia paalu yeni, li tie yeni ke i taa i gbannandi ki cabiki tua ti jɔngidi yeni ti tuonbiadi yaa yonbi, yeni wani cabi mani i gbannandi n tua teginma yaa ma ŋanmi i yaa yonbi. ");
INSERT INTO guxg_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","kelima yaa yogunu ke i den tie ti tuonbiadi yaa yonbi i, i baga den ki ye yeni buudi. ");
INSERT INTO guxg_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Li loni i po be? ke li yaa tie fe baba? kelima li ñuadi kuli tie mi kuuma i. ");
INSERT INTO guxg_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mɔla yin ñani ti biidi nni, i tua U Tienu yaa yonbi, i ji pia mi tegiŋanma, yaa miali n kan gbeni. ");
INSERT INTO guxg_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","kelima ti biidi paabu ti mi kuuma i ama U Tienu ŋanbili tie yaa miali n kan gbeni ti yonmidaano Jesu Krisiti nni. ");
INSERT INTO guxg_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","I ki bani, kelima, n maadi yeni yaaba n bani yiko, ki yiko suani o tuonli hali ki li fagi, o nisaalo yenma nni. ");
INSERT INTO guxg_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","L tie nani yiko n yi cabi o pua wan kuni o ja yeni, ama li sua nani k o ja kpe, o ji ki ye yeni yiko tili. Ya yiko kadagu n den taandi wani yeni o ja yeni ji ki suani. ");
INSERT INTO guxg_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","O ja da ya ye ki pia li miali, k o siedi ki kuni ja tiano, o tie conconli; ama o ja ya kpe, yiko ji pia nu o po, o ya kuni ja tiano, o ji ki tie conconli. ");
INSERT INTO guxg_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","N naataani, li tie yeni i mɔ ya po, yaali n tie yiko po wani, i kpe li kuum n o, ki dugni yinba yeni klistu n bo taani ti gbannandi yeni, i ji pia i diedo, yua n yiedi bi tinkpiiba siigni, ki tin mɔ n ji fidi ki ya suani a tuona U Tienu po yeni. ");
INSERT INTO guxg_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Yen i mɔni, tin mɔn da den ye m kuuma gbannadn yeni, li yiko den kuandi ti ya maalbiidi n den caa yen ti m kuuma po. ");
INSERT INTO guxg_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ama mɔlane, ti ji ñani yiko mabl n o, k dugni ti den kpe yeni yaali n den kubi ti dansaligi. Ti ji bu fidi ki sɔni yen U Tienu yeni m maalpanma yaali ki fuoŋanma ŋmagd ti, ki ji cedi m maalkpelima. ");
INSERT INTO guxg_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ti ji ba yedi be? Yiko tie bonbiili yaa? N n, ya yogunu k n bandi ti biidi ki dugni mi ñɔmaama po i. Tii den bani nunponli li bo ya ki tie ñɔmaama nni ka. Ki da pia nunponli a lielo po. ");
INSERT INTO guxg_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ti biid ji la o sanu k n ji pia li nunponli ŋanduna ne bona po kuli. ");
INSERT INTO guxg_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Yayogunu, ki da den bani yiko, n fo, ama min ji te gbadi mi ñɔmaama yayogunu, ki ti biidi yendi n yinyienu k n ji kpe. ");
INSERT INTO guxg_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","mi ñɔmaama bo tie ki lan baa yeni li miali, ama ki min ya po, li ba mi kuuma. ");
INSERT INTO guxg_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ki dugni, ti biidi la o sanu lan kani, ki tugi m ñɔmaama ki bɔndn nni k n kpe li ñɔmaama po. ");
INSERT INTO guxg_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Yiko ji pia jɔngdi ba, ama m ñɔmaama ki pia tagiliba. ");
INSERT INTO guxg_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Yeni ki yaali n den ŋani yen ji ba yen mi kuuma? N n, lan ka. ti biidi n ba yenli. Ti biidi wuoni li bonŋanli ki baadi yen mi kuuma. Li tie yeni ki ti biidi wan yeni, i mɔni wan tie yaali ki mi ñɔmaama mɔ ji cedi ki ti biidi ji ŋan ki yabdi ki pendi. ");
INSERT INTO guxg_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ti bani ki yiko ñani U Tienu kani, ama min wani tie ya nulo ki bi kuabi ki ñan nni ti biidi nni ki ti biidi ji ŋa nni. ");
INSERT INTO guxg_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ki dugni min ji bani min suani yaali. N suani min bua yaali ka, ama n suani min ki bua min sɔni yaali. ");
INSERT INTO guxg_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Li tuo k n sɔni min bo ki bua sɔni yaali. N bani ki li ki ŋani. ");
INSERT INTO guxg_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Lan wani min mɔno ka suani lan, ya biidi n kubi n yeni, n cedi kin suani lan ya tuonli. ");
INSERT INTO guxg_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","N bani k n ki ŋani, n bua li bonŋanli tiema, ama ki li nan pa yen ni. ");
INSERT INTO guxg_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","N bua k min ya tie li bonŋanli k nan kan fidi ki tieni, ama ti biidi yaali k, n k bua yeni, n nan tiendi lani. ");
INSERT INTO guxg_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","K n ya suani yaali k n bo ki bua min sɔni, min kan sɔnli ama ya biidi ye yen nni suani nni tuonli. ");
INSERT INTO guxg_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","N ji te la ki yaali ne n ye yen nni: n ya bua sɔni bonŋanli, n ji te yi juodi yeni bonbiili. ");
INSERT INTO guxg_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","N bua ya yiko n ñan U Tienu kani. ");
INSERT INTO guxg_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ama n gɔ lieli ye yen n. N yam n tuo ya yiko yen, ki cedi k n tie nani dansaligi yen, ki cɔln ti biidi yiko. ");
INSERT INTO guxg_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","N tie cicagdaani paaa. ŋma n bu fabn nni. Ki ñani n gbannandi yaali bua wan kuan n mi kuuma nni. ");
INSERT INTO guxg_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","U Tienu n ga balgi. Wani baba n bu fidi k fabn nni ti yombidaano jesu klistu po kelima, n pali nni, n ŋua u Tienu yiko, qamaq n gbannad'n, n ŋua ti biidi yiko. ");
INSERT INTO guxg_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Lanwani i, mɔlane, buu-cuoma bá kuli ji ki ye yaaba n fo Jesu Kiristu nni po. ");
INSERT INTO guxg_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ki dugni U Tienu Foŋanma yaama puuni li miali Jesu Kiristu nni, yikodi faabi nni yeni ti biidi yeni mi kuuma yikodi. ");
INSERT INTO guxg_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kelima, yiko ń gbali yaali, ke li ñani ti gbannandi tadingu po, U Tienu wani fidi ki tieni. O sɔni o bijacelo ya gbannandi nni n naani yeni ti biidi gbannandi yeni, ki buni ki cuo ti tuonbiadi li gbannandi nni. ");
INSERT INTO guxg_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","O tieni yeni ke yiko ń waani ti mi teginma sanu ki dudi ti po, tinba yaaba n cuoni, kaa ŋua ti gbannandi ka ama U Tienu Foŋanma. ");
INSERT INTO guxg_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Yaaba fo ti gbannandi po fiini ti gbannandi buama ya po i; yaaba n fo mi foŋanma po mo fiini mi foŋanma buama po i. ");
INSERT INTO guxg_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kelima, ti gbannandi buacianma tie kuuma i, mi foŋanma buacianma mo tie li miali yeni mi yanduanma. ");
INSERT INTO guxg_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kelima ti gbannandi buacianma tie U Tienu po yibalma i, kelima maa ŋua U Tienu yiko, mi kan fidi ki cɔlni yiko. ");
INSERT INTO guxg_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","yaaba n fo ti gbannandi po kan fidi ki tua U Tienu buakaaba. ");
INSERT INTO guxg_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Yinba ya po, U Tienu Foŋanma ya ye i niinni, yii fo ti gbannandi po ka, ama mi foŋanma po i. Nilo ya ki pia Kiristu foŋanma o niinni, waa tie Kiristu yua. ");
INSERT INTO guxg_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kiristu ya ye yeni yi, Ti gbannandi ya kpe ti tuonbiadi po, mi foŋanma baa ye yeni yi, ki tie miali mi teginma po. ");
INSERT INTO guxg_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yua n yiedi Jesu bi kpienba (tinkpiba) siiga foŋanma ya ye yeni yi, wani yua n yiedi Jesu bi kpienba siiga ba guani ki teni i gbannankpiendi li miali kelima o foŋanma yaama ye yeni yi ya po. ");
INSERT INTO guxg_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Lawani i, n naataani, ti ji ki pia panli ti gbannandi po ki baa lingi ti gbannandi buama ka. ");
INSERT INTO guxg_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kelima i ya fo ti gbannandi ń bua maama, i ba kpe; ama i ya yie ti biidi, ki kpaa i gbannandi mi foŋanma paalu po, i baa pia li miali. ");
INSERT INTO guxg_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kelima U Tienu foŋanma ń gobdi yaaba tie U Tienu ya bila i. ");
INSERT INTO guxg_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","I nan ki ga yonbdi fuoma ka ki go baa jie; ama i baa ti wubdi ya foŋanma i, mani ya po i, ke ti yigni ki tua: Abba, Báa! ");
INSERT INTO guxg_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","U Tienu foŋanma mi bá tieni kasiedi, ki waani ti yantiali ke ti tie U Tienu bila. ");
INSERT INTO guxg_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Lanwani i, ti ya tie o bila, ti go tie o faadila i: U Tienu faadila, ki ba bɔgdi li faali yeni Kieistu, li ya tie ke ti tuo yeni i mɔni ki ga fala yeni o, ti ba baa ti kpiagdi yeni o. ");
INSERT INTO guxg_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","N maali ke mɔlane ya fala kan fidi ki bogni yeni saala ya kpiagdi n ba dɔgdi ti po. ");
INSERT INTO guxg_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Mi yentagma mo se ki guu yeni li dandancianli U Tienu bila dɔgdima. ");
INSERT INTO guxg_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Mi tagma den tua yuongu bonli ke li naa ŋua mani ya buama ka ama o tagdo yaama. ");
INSERT INTO guxg_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Ama li dandanli den ye, ke dayenli, mi mo ba faabi mi bá yeni ti tuonbiadi yonbdi, ki taani yeni U Tienu bila ki baa mi faabma ti kpiagdi nni. ");
INSERT INTO guxg_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ama ti bani ke hali yeni dinne, mi tagma kuli duni yeni fala ki gbaa yeni ti madi. ");
INSERT INTO guxg_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Li ki tie mani baba ka, ama ti mo, tinba yaaba n baa U Tienu foŋanma nani paakpiabu yeni, ti mo duni yeni fala, ki guu ke wan wubi ti ki daa ki faabi ti gbannandi. ");
INSERT INTO guxg_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kelima ti dandanli po i, ke ti baa mi faabma. Ama, ŋan nua ya dandanli ji ki tie dandanli; ŋan nua yaali, a go baa daani li ii? ");
INSERT INTO guxg_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ama ti ya daani tin ki nua yaali, ti se taajala lie i, ki guu. ");
INSERT INTO guxg_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Lan tie maama n yeni, mi foŋanma mo go todi ti, ti tadingu nni, kelima ti jaandi nni, tii bani yaali n dagdi ti po, ki ba mia. Ama mi foŋanma mini mi bá gbaa, ki duni, ki miadi tipo. ");
INSERT INTO guxg_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ke yua fiidi, ki bani yaali n ye ti pala nni bani mi foŋanma maalma, kelima U Tienu po i, ke mi miadi bi niteginkaaba po. ");
INSERT INTO guxg_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tin bani yaali n tie ke, yaaba n ŋua U Tienu po yeni wan tuodi ki jagi ki yini yaaba, o taani bonli kuli ki ŋanbdi bi po. ");
INSERT INTO guxg_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kelima wan den tuodi ki bani yaaba, o den tuodi bobni ba ke bi tie o Bijua nannanli, ke o Bijua ń ya tie bijakpelo o waamu siiga. ");
INSERT INTO guxg_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Wan tuodi ki jagi ki bobni yaaba, bani i, ke o go yini. Wan yini yaaba, o go faabi ba, wan faabi yaaba, o go puni ba ti kpiagdi. ");
INSERT INTO guxg_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ti nan ba maadi be i, lan ya bona po? U Tienu ya taa ti po ŋma ba yie ti po? ");
INSERT INTO guxg_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Wani yua n ki den tuo ki ga o Bijua fala nni, ama, o den mubni o bi niba nui nni, ke o kpe tikuli ya po, li ba ga ledi i, ke o kan go teni ti bonli kuli o ya po? ");
INSERT INTO guxg_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ŋma ba fidi ki jalgi U Tienu ń gandi yaaba? U Tienu n bu, ki faabdi. ");
INSERT INTO guxg_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ŋma ba fidi ki bu ki cuo ba? Kiristu n kpe ti po, hali ke o yiedi o, ke o kaa U Tienu jienu po ti yudandi nni, wani n tie ti candaano, ki miadi ti po. ");
INSERT INTO guxg_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ŋma ba fidi ki paadi ti yeni Kiristu buama? pupuagdi bii, yanyagdi bii, falabiadma bii, mi koma bii, bi ya fie ti tiadi ki ŋa ti mubila bii, ti jawaanciandi bii, ki jugpienga i? ");
INSERT INTO guxg_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nani lan diani maama” «A ya po i, ke bi kpa ti hali yentunmunli, ke bi nua ti nani ba caa yeni ya pee o yankodikaanu yeni.» ");
INSERT INTO guxg_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ama, yeni lankuli, yua n buadi ti cedi ke ti paadi yeni ti yudandi. ");
INSERT INTO guxg_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kelima n pia li dandanli ke mi kuuma lanyaaka li miali, bii malekinba, lanyaaka ti yonbdi, bii mɔlane bona bii ya yogu n ŋua ya bona, ");
INSERT INTO guxg_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Lanyaaka Upaaciamu bii li bonli ń kpedi maama kuli bii lan ñua maama kuli, lanyaaka tagma bákuli kan fidi ki paadi ti yeni U Tienu Buama, wan dɔgdi yaama Ti Diedo Jesu Kiristu nni. ");
INSERT INTO guxg_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","N maadi mɔmɔni Krisiti nni, mini ki pua faama U Tienu fuoma wangi nni ke n ki pia faama. ");
INSERT INTO guxg_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","N ye yeni ti yanyagiciandi yeni li pabɔnli yogunukuli. ");
INSERT INTO guxg_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","kelima n bi baa bua ban solini nni ki paadi nni yeni Krisiti, n kpiiba yapo, yaaba n kpi yeni ti gbannandi nni yaa ŋamu po. ");
INSERT INTO guxg_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Bani Isalele buolu buudi yaaba, U Tienu den cedi ke bi tua bimɔnmu, ki dɔgidi bi po o kpiagidi, ki kuani i yantaadi yeni ba, ki tieni ba o bali maama, ki dɔgidi bi po ban baa jaandi o maama, ki niani ba o ñɔniagu. ");
INSERT INTO guxg_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Bi tie ti yaja nba puoli ŋuani, Krisiti moko den mali li yaa buolu nni ti gbannandi po. Wani yua n die bonla kuli. U Tienu n pagidi hali yaa yogunu kuli, Amina ");
INSERT INTO guxg_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Mii bua yedi ke U Tienu ñɔnianu kipia mayuli ka. Kelima yaaban mali ki tie Isalele puoli ŋuani, bi kuli ka tie Isalele buolu yaaba mɔmɔni. ");
INSERT INTO guxg_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Laa gɔ tie Abrahama puoli ŋuani kuli ka tie o bi mɔnmu. Ama li yedi: «Isaka puoliŋuani n baa tie a buolu» ");
INSERT INTO guxg_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Li bua yedi ke laa tie yaaba mali nani bi nisaaliba kuli n maa maama n ba tie U Tienu bila. Ama yaaba n mali nani wani U Tienu n bili u ŋɔnianu maama n tie o buolu mɔmɔni. ");
INSERT INTO guxg_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","U Tienu n bu niani yaa ñɔnianu n tie ne: «Binli, tin ye yaa yogunu ne yaa pundi, n baa guani ki cua, sala ba maali i bonjaga.» ");
INSERT INTO guxg_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ama lani baba ka, Rebeka yeni Isaaka den taani bi yaaba ki mali a sanpola bilie. ");
INSERT INTO guxg_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Li bilieda daa den ke cua li ŋandunli nni, ki buali ban tieni ti tuonbiadi lani yaa kaa a tuonŋanma ke U Tienu den gandi ba ke lan togini bi tuona po, ama li den ñani U Tienu yua yi wanbua yua kani. ");
INSERT INTO guxg_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","U Tienu den yedi Rebeka: «ŋan baa kpaa ki mali yua baa tuo ke daa tie nacenbiga.» ");
INSERT INTO guxg_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Li ba tieni nani lan diani maama: «N den bua Jakobo ki nani Esyu» ");
INSERT INTO guxg_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Lanwani, ti baa yedi be? U Tienu ki tiegi ba? yeni ka. ");
INSERT INTO guxg_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","U Tienu den yedi Musa: «N baa gbia mi ninñinma min bua yua yapo. N gɔ baa li palisiadili min buayua yapo. ");
INSERT INTO guxg_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Lanwani, laa ñani yua bua naani kani kaa, bii o mɔndilipo ka, ama li ñani U Tienu niñingbadima po. ");
INSERT INTO guxg_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","kelima li diani ki yedi Farawon: «N yeni a ke a tua o badiciamo yaala yapo tie ke n bua min dɔgini n paalu kelima a yapo, ki gɔ cedi n yeli n pundi ŋanduna kuli nni kelima a yapo. ");
INSERT INTO guxg_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Lanwani U Tienu gbia mi niñima wan bua yua yapo ki gɔ juadi li paliwan bua yua ya pali. ");
INSERT INTO guxg_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Yendo bu guani ke yedi nni: Be yapo ke U Tienu fu yeni ti? kelima ŋma n baa fidi ki yie o yanbuama? ");
INSERT INTO guxg_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Fini o nisaalo, a tie ŋma ke baa nia yeni U Tienu? U tiagu baa tuo yedi o tiamaalo ke: «Be yapo ke a maa n nni nanda? ");
INSERT INTO guxg_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","o tiamaalo ki pia li bali yeni wan ñani yɔgikonyenli nni ki maa yaa tiagu n ba tuuni li tuonli mɔnli, ki ñani laa yɔgikonyenli nni ki maa yaa tiagu n kan tuuni tuon mɔnli. ");
INSERT INTO guxg_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ti ji baa maadi be, U Tienu bua wan waani o pabienli ke dɔgidi u paalu ama ke nan cuo o ba bonciala ke yaabu ke dagidi, o mutuoli ");
INSERT INTO guxg_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","kelima u bua wan dɔgi o kpiagidi n yabi maama yaa niba n tie nani wan den gbadi yaa tiadi po n ninñima wan den tuodi ke gandi yaaba ke ban taani yeni o o kpiagidi nni. ");
INSERT INTO guxg_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Lanwani wa yini ti Sufinba siiga baba ka, ama o yini ti yaaba n ki tie Sufinba moko siiga. ");
INSERT INTO guxg_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nani wan yedi o sawalipualo Ose tili maama: «N baa yeni yaa nibuoli n ki tie n buolu niba, ke gɔ yini yaa buoli ki mii bua baa min bua yaaba» ");
INSERT INTO guxg_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Li baa tieni yeni bi po nani kani ke yedi ba: «yii tie n buolu» Lankani bi yini ba: «U Tienu yua fuo bijaba» ");
INSERT INTO guxg_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","O sawalipualo Esayi den kpaandi ki maadi Isayeli ki yedi: «Isirayeli buolu yaa tie nani n ñincianma tanbini yeni, yaaba n baa tindi baa tie waamu. ");
INSERT INTO guxg_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","kelima O Diedo ba tieni ki juodi i tinga nni wan den yedi yaala ke li kan waagi» ");
INSERT INTO guxg_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Li baa tie nani Esayi n kpia maama ki yedi: Li miali Diedo u paciamu kuli daani o yua den cedi ke ti ti siiga nitianba sieni, ti buolu den baa bodi tn tua nani Sodomi yeni Gomori yaaba yeni. ");
INSERT INTO guxg_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Lanwani ti baa yedi ledi? Yaa nibuoli n ki tie Isirayeli yaaba ki den lingi n teginma laa n teginma bi dandanli po. ");
INSERT INTO guxg_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ama Isirayeli buolu yaaba den lingi n teginmakelima li bali maama kubima po naa den baa. ");
INSERT INTO guxg_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Be yaapo ke baa den laa n teginma? Baa den lingi ki baa kelima li dandanli yapo. Lanwani bi den tuudi li tantuudikaala. ");
INSERT INTO guxg_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Nan lan diani maama: «diidi ke laa, n bili siyoa juali kani yaa tanli n baa cedi bi niba n baa, Ama yua n dugi o po kuli, o kan laa i fe baa yaa daali n cuoni.» ");
INSERT INTO guxg_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","N naataani, n pali nni buama yeni min miadi U Tienu yaali n jaandi nni tie ke ban baa u faabu. ");
INSERT INTO guxg_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","N tiendi bi po kasiedi yeni bi yankuali U Tienu tuona po, ama bi nan ki pia li tuonbanma. ");
INSERT INTO guxg_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ban ki bani U Tienu teginma sanu, ki nan lingi ke ban bili bi yuli po teginma sanu yeni, bi ki cɔlni U Tienu teginma sanu. ");
INSERT INTO guxg_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kelima Kiristu n tieni ki dudi yiko, ke lan tua faabma bi dugkaaba kuli po. ");
INSERT INTO guxg_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Lani n cedi ke Moyiisi waani yiko ń bili ya teginma niima nni: “Ya nilo n cɔlni lan ya teginma baa pia limiali li teginma po.” ");
INSERT INTO guxg_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ama ya teginma n ñani ti dudugdi kani ń maadi maama n ne: “Da maadi a pali nni: “ŋma ba do tanpoli? Lani n ba cedi Kiristu ń ña tanpoli ki jiidi. ");
INSERT INTO guxg_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Lani yaa ka: “ŋma ba jiidi ki kpientinga nni? “lani n ba cedi Kiristu ń fii lankani ki yiedi bi tinkpiba siiga. ");
INSERT INTO guxg_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Mi maama yeni nan maadi be i? Mi maama ye, ki kuu a kani, ki ye a ñɔbu nni yeni a pali nni. Ti dudugdi ya maama n yeni, tin wangi yaama. ");
INSERT INTO guxg_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","A ya yaadi a ñɔbu, ki tuo, ki ga ke Jesu n tie O Diedo, ki dugi a pali nni ke U Tienu yiedi o bi kpienba siiga, a ba baa u faabu. ");
INSERT INTO guxg_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kelima a ya dugi yeni a pali kuli, a ba baa mi teginma, a ya yaadi a ñɔbu ki maadi bi niba siiga ke a tuo ki ga, a ba baa li ŋanbli. ");
INSERT INTO guxg_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Nani i diani ń maadi maama: “Yua n dugi o po, o kan di fee, ");
INSERT INTO guxg_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Lanwani i, paadma bá kuli ki ye Juufinba yeni bi nilanba siiga, kelima bi kuli pia Diedyendo i, ke o yedŋama ki pia banlu yaaba n jaandi ki miadi o po. ");
INSERT INTO guxg_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kelima yua n jaandi O Diedo yeli po ba baa mi faabma. ");
INSERT INTO guxg_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Bi ba tieni ledi i, ki jaani ki mia ban ki daani yua ya yeli po? Bi ba tieni ledi i, ki dugi ban ki cengi yua ya maama po? Bi ba tieni ledi ki cengi o maama, nilo yaa ye ki ba waani ba? ");
INSERT INTO guxg_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Li ba tieni ledi i, bi tundkaaba ń ya ye, bi yaa sɔni ba? Nani lan diani maama: “Diidi mani bi cenli ń ŋani maama, bani yaaba n wangi mi yanduanma, bani yaaba n wangi a laabaalŋama ! ");
INSERT INTO guxg_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ama, bikuli ka tuo ki ga o laabaalŋamo. Esayi tuodi ki maadi: “O Diedo, ŋma nan tuo ki gbadi a tonda maama? ");
INSERT INTO guxg_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ti dudugdi ña o nilo ń gbadi yaali kani i. Ban gbia yaali mo nan ña Kiristu maama kani i. ");
INSERT INTO guxg_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lani n cedi ke n buali: “Baa gbadi ti tondu uu? Bi li gbadi, kelima li diani: “Bi nialu gedi kaankuli, ki kagni ki lindi ki tinga, bi maama mo yadi ŋanduna nni tinbanli kuli.” ");
INSERT INTO guxg_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ama min buali yaali da aa: “Isirayeli yaaba ki den bani bii? Moyiisi den kpia ki maadi: “N ba cedi yaaba n ki dagdi yeni buolu ń ñuni yi li mutuoli lan tua i po ponponli, n ba cedi ya buolu n ki pia banma ń fiini i pala. ");
INSERT INTO guxg_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Esayi go paani o pali, ki maadi: “Yaaba n den ki lingi nni yeni, bani n la nni. N dɔgdi ki waani n bá yaaba n den ki pia n buama po.” ");
INSERT INTO guxg_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ama o maadi Isirayeli yaaba po ne: “N tiani n nui yentunmunli ki bua mangi yeni yaaba n fiindi mi yenyiema yeni a tubkangbada buolu. ");
INSERT INTO guxg_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Lanwani i, n ji buali ne: “U Tienu ji luni o buolu yo oo? yeni ka! Kelima n mo tie Isirayeli yua, ki tie Abalahama puolŋuanu, ki tie Benjamini cuuli nni yua. ");
INSERT INTO guxg_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","U Tienu ki ñɔli ya buolu ke o den tuodi ki bani hali ke li fagi. I ki bani i diani ń maadi Eli po ya maama aa? wan den fabni maama U tienu kani Isayeli yaaba po, ki tua: ");
INSERT INTO guxg_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“ O Diedo, bi kpaá a sawalpuaba, ki tudi ki luni a jaanbinbinda; mini baba n sieni ke bi go lingi ke ban biani n miali. ");
INSERT INTO guxg_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ama U Tienu guani ki jiini o be i? O jiini ki yedi: «N guuni n yuli po niba tuda lele, yaaba n dá ki gbaani ki pugi o bulo Baali. ");
INSERT INTO guxg_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Li go tie yeni i, mɔlane, nitianba sieni, ban gandi yaaba U Tienu ŋalbalgo po. ");
INSERT INTO guxg_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ama li ya tie li ŋanbli po, lani naa ŋua a tuona; lanyaaka li nan ji ki tie ŋanbli yeni i mɔni. Li ya tie ke li ŋua tuana mo, li ji ki tie ŋanbli, lanyaaka li tuona ji ki tie tuona. ");
INSERT INTO guxg_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Lankuli wangi be i? Isirayeli yaaba ki baa ban den lingi yaali, ama U Tienu ŋanbli po, ban gandi yaaba baa la. yaaba n sieni ki tie pajuaga danba wani ki baa pu. ");
INSERT INTO guxg_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Nani i diani ń yedi maama: “U Tienu teni ba mi yanpiiyema, bi pia i nuni ki naa nua, ki pia a tuba ki naa gbia, hali yeni mɔla kuli. ");
INSERT INTO guxg_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dafiidi moko yedi: “Bi jedikaanu ń tua bi po diagu, ki tua taalu bii tingbali, ban pa ki baa bi tuonbiadi po sugli. ");
INSERT INTO guxg_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Bi nuni ń bɔndi, ban ji da nua, bi ciamu ń pɔli, ki buani bi jumu, ban ya tiibi yognu kuli. ");
INSERT INTO guxg_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","N ji buali da: “Bi tuudma ji tua bi tingbali yo oo? yeni ka! Ama bi tingbali cedi ke bi nilanba baa mi faabma, ke li tua bi po ponponli, ki fiini bi pala. ");
INSERT INTO guxg_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","To, bi tingbali ya tua ŋanduna po ŋalmani, ke bi pɔdma mo cedi ke bi nilanba baa ŋalmani, bikuli ya lebdi bi pala, lanya ŋalmani ka baa cie ee? ");
INSERT INTO guxg_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","N maadi yinba i, bi nilanba: Min tie tondo bi nilanba siiga n ne, n jaandi U Tienu n tuonli po. ");
INSERT INTO guxg_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Li ya bi ba tuo, min fiini n naataani pala, ki kuani ba li ponponli, ki faabi tianba. ");
INSERT INTO guxg_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kelima U Tienu ya luni o buolu, ke ŋanduna guani ki mangi yeni o, bi ya guani ki ŋɔdi bi Diedo, li kan tua miali ka bi tinkpiba siiga aa? ");
INSERT INTO guxg_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Bi yedi ke a bonkpiala ya ŋani, ki dagdi U Tienu po, li tie ke ku kpaangu kuli mo ŋani, ki dagdi U Tienu po i. A jiina ya kpaa, ki dagdi U Tienu po, li tie ke a bena mo dagdi ki ŋani U Tienu po i. ");
INSERT INTO guxg_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Bi ya cua ki ñani bentiana, ke fini tilialbu benu, ke a tugni, ki baadi bu tiŋuukaabu sinma li beni kaanu, ");
INSERT INTO guxg_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ŋan da kpiadi a yuli i beni yeni yeli po ka. A ya kpiagdi a yuli, ŋan ya bani ke fini ka tugi a jiina; ama a jiina n tugi a. ");
INSERT INTO guxg_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","A ba maadi: “Bi cua ki ñani i beni, ke n mo fidi ki tugni. ");
INSERT INTO guxg_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Li tie mɔmɔni ke ya beni n ki pia dandanli i, ke bi cua ki ñani; ke fini a tuugi kelima a dandanli po i. ŋan ji da pia japaadi, ama ŋan ya jie. ");
INSERT INTO guxg_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kelima U Tienu ya ki tuo ki ŋa bu tiiŋuukaabu beni, o kan di sugli fini bu tilialbu beni mo ya po. ");
INSERT INTO guxg_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Lanwani i, ŋan cɔlni U Tienu ŋanbli, yeni o maba. A maba yaaba n tudi ki yie o maama po; ŋanbli fini yua n tiegi po. lanyaaka o ba cua ki ñani o mo. ");
INSERT INTO guxg_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Bani yaaba n tudi mo, bi ya ki tundi ki ye mi tudma nni, ki lebdi bi pala, o ba guani ki tugni bi mo, kelima U Tienu paaciamu po, o ba fidi ki guani ki tugni bi mo. ");
INSERT INTO guxg_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Fini yua den ñani bu tiilialbu po, ke bi tugni a yeni bu tiiŋuukaabu, ke a naa tuodi ki tie bu, bani yaaba n den ñani bu tiiŋuukaabu kani n ji kan guani ki tugni yeni bi tiibuolu uu? ");
INSERT INTO guxg_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Kelima, n naataani, n ki bua ke ya yaalidgu bonli ne duagi yi, ki ba cedi yin yini i yula yanfodanba; Li tie ke Isirayeli yaaba bi tianba juagi bi pala, ki baá mi tudma nni, hali ke bi nilanba kuli baa ki kua, ki baa U Tienu ŋanbli. ");
INSERT INTO guxg_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Lani n cedi ke Isirayeli yaaba kuli ba baa mi faabma nani lan diani maama: “O candaano ba ña Siyɔn, ki cua ki ñani ti tuonbiadi Isirayeli yaaba pali nni.” ");
INSERT INTO guxg_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","N ya piini bi tuonbiadi, lani n ba tua n ñɔnianu yeni ba. ");
INSERT INTO guxg_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Yaali n nua o laabaalŋamo po, bi tie yibalinba kelima yinba bi nilanba ya po; ama yaali n nua ban gandi yaaba li ŋanbli po, bi tie U Tienu ń bua yaaba kelima bi yaajanba po. ");
INSERT INTO guxg_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kelima U Tienu yiinu yeni o paabu ki pia lebdima. ");
INSERT INTO guxg_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Nani yognubá, i den ki tuo ki ŋua U Tienu ń bili ya sanu, ke bi tudma po, ke i baa U Tienu niñingbadma yeni, ");
INSERT INTO guxg_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Bi mo tudi U Tienu sanu, ke yin baa ya niñingbadma po yeni ya po, bi mo ń baa mi niñingbadma ");
INSERT INTO guxg_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kelima U Tienu luoni bi niba kuli mi ti tuonbiadi nni, ke wan fidi ki gbadi bikuli niñima. ");
INSERT INTO guxg_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","kesaa, U Tienu ŋalmani yeni o yanfuoma yeni o banma yabi ki go ñua! ŋma ba fidi ki kpaagi o yanjaga? ŋma ba fidi ki bandi o sanbila? ");
INSERT INTO guxg_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ŋma kpaagi ki bandi U Tienu maalma? bii ŋma n ba fidi ki tua o ceglika? ");
INSERT INTO guxg_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ŋma kpia ki teni U Tienu bonli ki ji guu ke wan ŋmiani o? ");
INSERT INTO guxg_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Bonli kuli ñani U Tienu kani i, wani n die likuli, likuli ye o ya po i. Wani n yeni ti kpiagdi yeni ti yudandi li bina yeni li bina! Ami ! ");
INSERT INTO guxg_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","N naataani, n mia yi ki go paandi i pala ke yin diidi U Tienu niñingbadma po, ki yidi i gbannandi ya salga fuo, ki ŋani, ki mani U Tienu po. Lani n ba todi yin fidi ki kpiagi o bonŋanla. ");
INSERT INTO guxg_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Da ŋua mani mɔlane jamaano ka. Yin lebdi i pala, ki pandi i yantiali, ki fidi ki bandi U Tienu buama, yeni yaali tuagi, ki mani, ki ŋani cain. ");
INSERT INTO guxg_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","U Tienu ń puni nni ya ŋanbli po, n miadi i siiga nni yuakuli, ke obá ń da dongi o yuli, ki maali ke o cie o lieba, ama, yuakuli ń maali yeni mi yanfuoma, ki dagni U Tienu ń seni o dudugdi naani. ");
INSERT INTO guxg_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kelima nani tin pia i gbannanbuoli, ke ti taani ki tie ti gbanu yeni, li gbannandi kuli naa taa taa tuona. ");
INSERT INTO guxg_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Lanwani, tinba yaaba n yabi, ti taani ki tie gbannanyendu i, Kiristu nni. ");
INSERT INTO guxg_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Nani tin pia yuakuli yeni o yenpaabu, ke bu ŋua wan baa ya ŋanbli yeni i, yua n pia sawali paabu, wan ya wangi ke li ŋua o dudugdi ń dagdi maama. ");
INSERT INTO guxg_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Yua n pia tuonli paabu, wan ya tuuni. Li ya tie tundma paabu, wan ya tundi. ");
INSERT INTO guxg_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Yua n pia ya paabu n paagdi bi niba pala, wan ya paagdi bi pala; yua pia li todli paabu, wan ya todi yeni ti bulcindi. Yua ya paabu tie mi gobdima, wan ya gobdi yeni li yankuali. Yua n pia ti niñinpadi baabu, wan ya tuuni yeni li pamanli. ");
INSERT INTO guxg_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Mi buama ń lɔgdi mi muyima. Yin ya jie ti biidi. Yin ŋanbi ki mubni yaali ŋani nuujadlie. ");
INSERT INTO guxg_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Yaali n nua i naataani buama, i pala ń ya siadi i lieba po; yaali nua ti bulcindi, yin cɔlni i yaba. ");
INSERT INTO guxg_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","I gbanu ń ya saagi yeni li tuonli, ki nan ŋa i kpadje. Yin ya tiegi U Tienu tuona nni, ki tuuni U Tienu po. ");
INSERT INTO guxg_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","I pala ń ya mani li dandanli po. Fala yogu, yin tieni li juunli ki ya jaandi yognu kuli. ");
INSERT INTO guxg_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Yin ya todi bi niteginkaaba bi buama banlu, ki ya bobindi bi canba po ku canmangu. ");
INSERT INTO guxg_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Yin yadi mi yedŋanma yaaba n wangi yi fala po, yadi mani mi yedŋanma bi po, ki da solini. ");
INSERT INTO guxg_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Yin mangi i pala yeni yaaba n mangdi bi pala, ki buudi yeni yaaba n buudi. ");
INSERT INTO guxg_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Yin ya pia maalyenma i lieba po. Yin da pia japaadi maalma, ama li yumiinli maalma. Da yini mani i bá ke i tie yanfodanba. ");
INSERT INTO guxg_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Yua tieni yi biadma, yin da ŋmiani o biadma. Yin lingi yaali n ŋani bi niba kuli po. ");
INSERT INTO guxg_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Li ya tie ke li maa i ya po i, ke i ba fidi, yin tieni ania ki ya ye yeni bi niba kuli mi yanduanma nni. ");
INSERT INTO guxg_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","N buakaaba, da tuu mani panli i bá. yin guudi U Tienu pabienli cuama; kelima li diani: «Li pantuuli tie n yaali, mini n ba tuu mi biadma panli, O Diedo n maadi.» ");
INSERT INTO guxg_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ama, koma ya pia a yibaliya, ŋan puni o mi jiema, ñuñuunu n ya pia o, ŋan puni o mi ñima; kelima a ya tieni yeni, mukuantona i, ke a tugni o. ");
INSERT INTO guxg_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Da ŋa ti biidi ń paadi ŋa, ama ŋan tieni mi ŋanma, lan paadi yaali bia. ");
INSERT INTO guxg_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Nilo kuli n yaa cɔlni yikodanba, kelima yiko ki ye ke ki ñani U Tienu kani kaa. Yaa yikodanba n ye kuli, U Tienu n kaani ba. ");
INSERT INTO guxg_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Lani, yua n yie bi yikodanba yie U Tienu n sieni ke o bona n baa yaa suani maama, ke U Tienu mutuoli baa jiidi o po. ");
INSERT INTO guxg_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","kelima yikodanba ki ye ke ban yaa mabindi ŋanma ka, ama ti biidi. Da jie mani bi ka. I ya ŋanbidi, bi baa pagi i. ");
INSERT INTO guxg_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","kelima U Tienu tuonsɔnba ye i po i. Ama i yaa tie biidi, yaa bani mani ke bi baa ŋmagi i tuba. ");
INSERT INTO guxg_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Li yaa po i ke ti cɔldi bo baa tie yeni yanjagili i, ama mabiili ka. ");
INSERT INTO guxg_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Li po, yaa paa mani i panpaani kelima bi yikodanba tie U Tienu tuonsɔnba i ki fiini bi tuona nni. ");
INSERT INTO guxg_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Paa mani yua kuli yin baa paagu yaala: paa mani o lonpo gaali o lonpo, i panpani daano mɔ o panpani, cɔlni mani yua dagidi yin cɔlni o, ki selini yua dagidi yin selini o. ");
INSERT INTO guxg_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Daa pia mani nilo baa yaa panli li yaa ki tie ke yin yaa bua i lieba baba yaaka. Kelima yua bua o lielo tiendi yikodi n bua yaala kuli. ");
INSERT INTO guxg_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Yeni, a kan conmi, a kan kpaa nilo, a kan suu, ŋan daa bua a lielo bonla yeni yaali n sieni kuli taani ki tie bonyenla: «A baa bua a lielo nani a baa yeni.» ");
INSERT INTO guxg_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Mi buanma ki duolidi o baa, li po n ke mi buanma tie mala. ");
INSERT INTO guxg_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Lanwani, i bandi ke u yogu ba ke yin findi kelima ti fiema nagi ki cie yaa yogunu ke ti den gaa o. ");
INSERT INTO guxg_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","U yɔgisiigu pendi o ke u ti siŋaagu mo nagi o, tin ŋaa mani li bonbonli nni tuona kuli ki taa mi yinma jakɔntiadi ");
INSERT INTO guxg_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Yin yaa suani a papientuona nani lan buali ke tin yaa suani u yensiigu nni yeni. Tin ŋaa mani li jiedicianli yeni li dañucianli, a concona tuona yeni ti jɔngindi tuona, a kɔnkɔna yeni i nanga. ");
INSERT INTO guxg_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Tugi mani ti yonmidaano Jesu Kirisiti ke wan tua i jakɔntiadi ke yin laa ki ji daa kpaani ke yin sɔni i yanma n kua yaa tuonbiidi nni kuli. ");
INSERT INTO guxg_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ga mani yua ntadi ti dudugdi nni cangu, ki da teni o tagli yeni i maakpaga. ");
INSERT INTO guxg_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","O nilo ye, ke o dududi po, ke o di bonli kuli, yua tadi wani ii, di kpinfaadi yeni luana baba i, ");
INSERT INTO guxg_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Yua n di bonli kuli ń da nundi yua n ki di bonli kuli, ke yua n ki di bonli kuli mo ń da jalgi yua n di bonli kuli. Kelima U Tienu tuo o tuada. ");
INSERT INTO guxg_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","A tie ŋma i ki ba jalgi nitiani yonbo? O ya se ee, o ya baá aa, li tie o canbáa maamam i. Ama o baa se, kelima U Tienu ba pugni o u paalu ki cedi wan ya se. ");
INSERT INTO guxg_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Poyenpo, nilo baa maali, ke o cie o lielolo. Potɔli po, tiano mɔ n maali ke bikuli dɔa i. Yuakuli ń bili o yuli nni ke o maalma tiegi. ");
INSERT INTO guxg_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Yua n kpaagi li daali, kpaagi li O Diedo po i; ke yua n di mo, o di O Diedo po i, kelima o tiendi U Tienu balga. Yua n ki dini, cuo o yuli kaa dini O Diedo po i, o mo tiendi U Tienu balga. ");
INSERT INTO guxg_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Kelima, obakuli ki kubi o miali o yuceli po. ");
INSERT INTO guxg_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Kelima ti fo, ti fo O Diedo po i; ti ya kpe mo, tikpe O Diedo po i. Lanwani ii, tin fo oo, tin kpe ee, ti tie O Diedo yaaba i. ");
INSERT INTO guxg_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kelima, lanyapo i ke Kiristo bo kpe, ki go fo, ke wan ya tie bi kpienba yeni yaaba fo kuli Diedo. ");
INSERT INTO guxg_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ama, fini, be n cedi ke jalgi a kpiilo? Ke fini mo, be n cedi ke a nundi a kpiilo? Kelima bi ba jia tikuli buudi U Tienu kalkaanu. ");
INSERT INTO guxg_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kelima, li diani, “N fo” O Diedo n yedi lani, “Mini ya po, dunli kuli ba gbaani, lanbu kuli ń yaadi ki kpiagi U Tienu yeli.” ");
INSERT INTO guxg_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Yeni, ke yuakuli ba togdi o yuli po U Tienu nintuali o tuada. ");
INSERT INTO guxg_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Lanwani ii, tin da jalgi ti lieba, ama, tin jagi ki cuo, ke nilo kan tua o lielo po tantuudkaali bii diagu o naataano po. ");
INSERT INTO guxg_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","N bani, ke n pali go paa Jesu po, ke libakuli ki jɔgni li yuli po. Kase yua maali ke bonli kuli tie jɔgindi o po. ");
INSERT INTO guxg_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Mi jiema po, a ya ba yagi a kpiilo yama, lanwani ii, ŋaa ji cuoni mibuama sanu po ka. Da cedi mani ti jiedi po, Kiristo ń kpe yua yapo ń bia. ");
INSERT INTO guxg_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Lanwani ii, yin da cedi i tuadŋama ń tua tuatiigu. ");
INSERT INTO guxg_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Kelima, U Tienu Diema ki tie jiedi yeni bonñukaama ya maama ka, ama, li tie mi teginma, mi yanduanma, yeni li pamanli mi Foŋanma nni. ");
INSERT INTO guxg_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Lanwani ii, yua n tuuni Kiristo po, ki tuagi lanya sanu, U Tienu ba tuo o yema, bi niba mo ń pagi o tuada. ");
INSERT INTO guxg_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Lanwani ii, tin ya ŋua mi buama sanu yeni yaali n ba ŋanbi yuakuli. ");
INSERT INTO guxg_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Da biidi U Tienu tuonli ti jiedi po. Tin ya bani ke bonlikuli ŋani, ama, li jɔgni yua n ba di, ki tua tantuudkaali o lieba po i. ");
INSERT INTO guxg_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Li ŋani ke nilo ń da ŋmani nandi, ki da ñu daama mo, yeni ya bonli n ba cedi a kpiilo yama ń ña a niinni. ");
INSERT INTO guxg_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ŋan pia ya dudugdi, tin ya ye fini yeni U Tienu siiga. Mi yediŋanma baa ye yeni yua n ki jalgi o yuli wan jagi ki cuo yaali ya po. ");
INSERT INTO guxg_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Yua ya yama n lengidi, ke o dini, o ba taa i tagli, kelima laa ñani ti dudugdi kani ka. To yaali n ki tie dudugdi maama mo, tie tuonbiadi i. ");
INSERT INTO guxg_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Mɔlane, tinba yaaba n pia u paalu ń gbadi a tadma tadingu niima nni, ki da dongi ti yuli. ");
INSERT INTO guxg_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Ti siig, yuakuli ń ya tie ti yaali n ŋani, ki mangi o lielo pali, klan pugni o dudugdi. ");
INSERT INTO guxg_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kelima bá Kiristo bo ki dongi o yuli. O bo li tie nani lan diani maama yeni, yaaba n den sugdi a sugdi guani n yuli po.” ");
INSERT INTO guxg_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Kelima, ban bo diani ya diani kuli tie tinba ya tundma po i, ke a i diani ń wangi ya juunli yeni yin paandi ti pala maama, tin fidi ki baa li dandanli. ");
INSERT INTO guxg_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","N miadi ke li juunli yeni mi baagima Tienu ń cedi yuakuli ń taa yantiayenli o lielo po nani Jesu Kiristo yeni. ");
INSERT INTO guxg_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Ke tin fidi ki taani yantiayenli yeni ñɔyenbu, ki fidi ki kpiagi ti Diedo Jesu Kiristo Báa yeni O Tienu. ");
INSERT INTO guxg_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Lanwani ii, yin ya gaani i lieba cangu nani Kiristo ń ga i cangu maama ke wan kpiagi U Tienu yeli. ");
INSERT INTO guxg_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Kelima, n yedi ke Kiristo yua ku kɔnciagu naciemo ki waani U Tienu mɔmɔni, ke lan dɔgdi ki waani wan tieni yeni i yaajanba ya ñɔnianu. ");
INSERT INTO guxg_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Yeni bi nilanba ke ban tieni U Tienu balga, o niñingbadma po. Nani lan diani maama, “Lanyognu n kpiagi a yeli bi nilanba siiga, ki yiini ki dondi a yeli.” ");
INSERT INTO guxg_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Li go diani, “Mangi mani i pala, bi nilanba, yinba yeni i dogtieba.” ");
INSERT INTO guxg_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ki go diani, “Dondi mani O Diedo, yinba bi nilanba kuli; bi dogtieba kuli ń dondi o.” ");
INSERT INTO guxg_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Isayi go yedi, “Li benpaali ba pudi Jese cugli nni, ki fii, ki diedi bi nilanba. Bi nilanba ba baa li dandanli o po.” ");
INSERT INTO guxg_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Mɔlane, N miadi ke U Tienu dandanli ń gbieni yi yeni ti dudugdi pamanli yeni mi yanduanma, ke yin ya gbie yeni li dandanli Mi Foŋanma paalu po. ");
INSERT INTO guxg_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","N kpiiba, mini mɔno pali paa i po, N pali paa i po, kelima yinba mɔno gbie yeni ti ŋandi, ki gbie yeni banmabuoli kuli. N pali go paa i po kelima, i ba fidi ki ya tigi i lieba. ");
INSERT INTO guxg_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","N go dangi yi ya tisɔnkaali ne yeni li pamancianli, ki bua min tiadi yi, kelima U tienu ń puni nni ya paabu po. ");
INSERT INTO guxg_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Li paabu tie ke n ba tua Jesu Kiristo n ba sɔni ya naaciemo bi nilanba siiga. Ke min tua salga yidka, ki waani ba U Tienu laabaalŋamo. N ba tieni lani, lan todi, bi nilanba paabu ń tua ya paabu n ŋani ki gbie yeni mi Foŋanma. ");
INSERT INTO guxg_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","N pamancianli tie ke min kpiagi Jesu Kiristo yeli yeni U Tienu ń tieni ya bona kuli. ");
INSERT INTO guxg_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Kelima mii pia papaali ki ba yedi libakuli kase Kiristo ń sɔni ya tuonli n po, ki ba cedi bi nilanba ń la yaalidgu yeni u paaciamu tuona, ki cɔlni. ");
INSERT INTO guxg_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Mi Foŋanma paaciamu po min cili Jerusalema yeni li tinkundogi, ki ban pundi hali Iliri, min fidi ki yadi ki waani Kiristo laabaalŋamo. ");
INSERT INTO guxg_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Lanya sanu nni i, ke n payianu den tie ke min yadi, ki waanu o laabaalŋamo, ama, li ki tie ban bani Kiristo yeli naankani ka, li tieni ke min da ti gedi ki maa nitiano ń bili ya fiagli po i. ");
INSERT INTO guxg_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Nani lan diani maama: “Yaaba n ki kpeli ki baa li maalma o maama po, ba bandi o,” ke yaaba n ki kpeli ki gbadi mo ba gbadi niima nni. ");
INSERT INTO guxg_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Lanya po i, ke li pani nni ke mi cua i kani. ");
INSERT INTO guxg_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ama, mɔlane, N ji ki pia kaanu, ki ba kali ya tinbuali ne, li ki luo bina ke N lingi ke min pundi i kani. ");
INSERT INTO guxg_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Lanwani ii, N ya caa, Esipañi, n ba jadi i kani, yin ciani nni, li waagi ke n jiki baa i yegnu. ");
INSERT INTO guxg_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Mɔlane, N caa Jerusalema, ki bua sɔni bi dogkaaba po. ");
INSERT INTO guxg_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Kelima, li baatie pamancianli i, Maseduani yeni Acihaya yaaba po, ke ban teni bu paabu, ki todi talginba, Jeruslema dugkaaba siiga. ");
INSERT INTO guxg_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Nn, li den tie bi po pamancianli i, yende, bi tie bi pandanba i. Kelima, bi nilanba ya baa bi yenpaabu, li tie ke bimo ń baa bikani ŋanduna bona i. ");
INSERT INTO guxg_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Lanwani ii, N ya sɔni lanya tuonli ki gbeni, ki diidi ki sua ke min taani ya paabu kuli kua bi nui nni, N ya caa Esipañi, N ba tɔgni i kani. ");
INSERT INTO guxg_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","N bani ke min ba pundi i kani, li ba sua ke i kuli gbie yeni Kiristo yediŋanma i. ");
INSERT INTO guxg_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","N kpiiba, Mɔlane, ti Diedo Jesu Kiristo yeli po, yeni Foŋanma buama po, N tigi yi, ki paandi i pala, ke yin mua ti jadi yin jaandi ki miadi U Tienu ya yognu kuli, ki todi nni. ");
INSERT INTO guxg_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Yin ya jaandi ki miadi ke Jude yaaba yaaba n ki cɔlni yeni ń ŋa nni, min fuodi, ke Jerusalema dugkaaba pali ń mangi n tuonli po. ");
INSERT INTO guxg_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ya jaandi mani, ki mia ke U Tienu buama po, ke min pundi i kani yeni li pamanli, ki taani yeni yi ki baa mi fuoma. ");
INSERT INTO guxg_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","N miadi ke Mi yanduanma Tienu ń ya ye yeni ikuli. Ami ");
INSERT INTO guxg_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","n fuondi n ninsalo yua n tie sancle jaandiegu nni tuonsoanlo ");
INSERT INTO guxg_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ke yin ga o ti yonbidaano yeli po maama ndagidi binigagidi ŋanba po yaala n buali yin todo kuli, kelima wani o ba den tua todika yaa nbi n yabi po yeni min yaa po kuli. ");
INSERT INTO guxg_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","fuondi mani Pilisila yeni Akilasa n tuonsoalieba ti yonbidaano Jesu Kilisi yeli po. ");
INSERT INTO guxg_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","bani n den luni bi miana ki fie min polo yaa miali min bebe ka tiendi ba baliga ama yeni li jaandie yaba kuli ");
INSERT INTO guxg_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","fuondi yaa jaandiegu nye bi deni, fuondi mani Epayineti n doanli moano, o tie kilisiti po bon kpiali Asi yaa dogu nni. ");
INSERT INTO guxg_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","fuondi mani maliyama yua n soani li tuonpaali yi po. ");
INSERT INTO guxg_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","fuondi mani An dienikusi, yeni Juniasi, n baa n ba yeni n yonbi lieba bi tie utienu tonda siiga ni moanba yaaba n kpa kicili uTienu tuonli yeni min. ");
INSERT INTO guxg_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","fuondi n danli ANpilia ti yonbi daano yeli nni. ");
INSERT INTO guxg_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","fuondi n tuonsoalielo yudiben kilisiti nni yeni Sitasine n danli moano ");
INSERT INTO guxg_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","fuondi mani Apilasa wan yua n se ke li pa kilisiti nni yeni, Asitibolo deni yaaba. ");
INSERT INTO guxg_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","fuondi mani ti kpiilo Elodiana, fuondi mani Narsise den po yaaba yaaba n ye ti yonbi daano kuli. ");
INSERT INTO guxg_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","fuondi mani Trifeni yeni Trifoni yaaba n soani tuonpaali ti yonbi daano po, fuondi Pilisila wan yua n soani boncianla ti yonbidaano po. ");
INSERT INTO guxg_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","fuondi rufu yua ke yonbidaan lugido yeni o na yua n tie ti kuli yaa na, ");
INSERT INTO guxg_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","fuondi Asynkilita Fileseno, hermesi, Patroba Hermasi, yeni ti jaba yaaba n ye yeno. ");
INSERT INTO guxg_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","fuondi mani Filologi, yeni Julie Merde yeni o nisalo Olynpe yeni o nigagidi ŋanba yaaba n ye yeni ba. ");
INSERT INTO guxg_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","yin yaaa binini mani yi yaba ki fuodi ba. li jaandieli yaaba kuli fuondi yi, ");
INSERT INTO guxg_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","moala ncegili yi yin foagimani yeniyaaba ncuoni yeni siiga mipaadima yeni a koankoana, yin kubi n tunda yaala ke yi ga n kani, yin foagidi yeni li danba ");
INSERT INTO guxg_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","kelima laa nibuolu ki suani ti Yonbidaano po ka, ama bi yaa puona po, yeni ya maama nmani bi niba po ki boandi yaaba n ki daani, ");
INSERT INTO guxg_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","yi coanli n pia yaa nannanli po pundi li ŋandunli kuli n ye yeni li pamanli kelima laa bonla po, n bua ke yin yaa tie yaa danba n bua yaala n ŋani kuli po, ki sani ki ŋa yaala n bia kuli. ");
INSERT INTO guxg_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","li ji kan waagi mi yanduanma Tienu baa mudi sutaani yuli yi taana tii po UTienu nyaa ye yeni yi ti yonbidaano Jesu kilisiti po. ");
INSERT INTO guxg_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timote n tuonsoanlielo fuondi yi lusiyusa, jasono, yeni Sopateli n kpiiba. ");
INSERT INTO guxg_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Mini Teryusa n diani li tili ne n fuondi yi ti yonbidaano yaa yeli po. ");
INSERT INTO guxg_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayusa n canba yeni yaaba n ye li jaandieli nni yaaba kuli, Elasita yua n kubi udogu ligi fuondi yi, yeni n ninjoa karitusi. ");
INSERT INTO guxg_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ke ti yonbi daano Jesu kilisiti ŋanbili n yaa ye yeni yi kuli Amina ke yua n baa fidi ki todi n gbadima min wangi ya labaali ŋanmo Ti yonbi daano Jesu kilisiti nni, ");
INSERT INTO guxg_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","yua n fidi ki todi yi yeni olabaali ŋamo ke n todiba Jesu kilisiti nni ke nani yaala doagidi ki waani ŋasiili nni yaala ke da foagi. ");
INSERT INTO guxg_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ama moala ne o nisoaginkaaba yaaba ke UTienu den doagidi ba idian pokuli ke lan fidi ki nibuoli kuli n coanli li dandanli maama. ");
INSERT INTO guxg_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ke UTienu bebe n ga ti kpiagidi yua n tie o yanfodaano li bina yeni li bina Amina. ");
INSERT INTO guxg_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Pɔl, ban yini yua ke wan tua Jesu Kiristu tondo, ke li ŋua U Tienu buama, yeni n naataano Sɔsteni, ");
INSERT INTO guxg_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Ti diani li tili ne, ki ba teni U Tienu nitaanli yaali n ye Korenta, bani yaaba n baa mi yedŋanma Jesu Kiristu yeli po, ke bi gagdi ba ke ban tua niŋanba, yeni yaaba n li taagi ti Diedo Jesu Kiristu yeli hali ban ye naani kuli, bi Diedo yeni ti yua. ");
INSERT INTO guxg_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ti Báa U Tienu yeni ti Diedo Jesu Kiristu ń puni yi mi yedŋanma yeni mi yanduanma ! ");
INSERT INTO guxg_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","N jaandi n Tienu yognu kuli, i po, kaa cedi yeni wan tieni i po ya ŋanbli Jesu Kiristu yeli po. ");
INSERT INTO guxg_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Kelima wani ya po, i baa ya ŋalmani n yabi, ki nua mi maama yeni mi banma, ");
INSERT INTO guxg_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Ban tieni Kiristu po ya kasiedi fiigi bonŋanla i siiga, ke i kubi yeni i mɔni ke li paa. ");
INSERT INTO guxg_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Mɔla, i ji ki luo yenpaabu bá kuli, yinba yaaba n guu ti Diedo Jesu Kiristu dɔgdima. ");
INSERT INTO guxg_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","O ba pugni yi u paalu, ke bi kan fidi ki jalgi yi hali ti Diedo Jesu Kiristu ń ba cua ya daali. ");
INSERT INTO guxg_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","U Tienu tie tin dugi yua ya po, wani yua n yini yi ke yin ŋɔdi o bijua yeni li papienli. ");
INSERT INTO guxg_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","N naataani, n miadi yi, ki paandi yi pala, ti Diedo Jesu Kiristu po, ke yin ya taa ñɔbu, ki da pia paadma i siiga, ama yin ya taa yantiayenli yeni maalyenma. ");
INSERT INTO guxg_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Kelima, n naataani, n gbadi ke Kolowe niba maadi ke a kɔnkɔna ye i siiga. ");
INSERT INTO guxg_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","N bua yedi ke i siiga yuakuli maadi maama ne: “Mini n tie Pɔl yua yo! Ke mini, Apolosi yua! Ke mini Sefasi yua! Ke mini Kiristu yua! ");
INSERT INTO guxg_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Kiristu ji paadi paadi yo oo? Bi kpaa Pɔl i, i po, li dapɔnpɔnli po oo? Bii, bi batise yi Pɔl yeli po i? ");
INSERT INTO guxg_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","N jaandi U Tienu yeni min ki batise bá niyendo yi siiga, lan ñani kirisipusi yeni Gayiwusi yaa ka. ");
INSERT INTO guxg_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","lani yaa ka, bi bi ba yedi ke bi batise yi n ya yeli po i. ");
INSERT INTO guxg_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","N go batise Sitefanasi diegu nni yaaba; lan ñani lankani, n ji ki tama ke n batise nitiano. ");
INSERT INTO guxg_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kiristu ki sɔni nni ke min ya batise bi niba ka, ama ke min ya wangi o laabaalŋamo, Li naa go tie ke min ya wangi yeni mi yanfomaama ka, ke Kiristu daapɔnpɔnli ń da tua fanma. ");
INSERT INTO guxg_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kelima li daapɔnpɔnli maawangma tie yanluomaama i, yaaba n bodi po; ama tinba yaaba n baa mi faabma po, mi tie U Tienu paaciamu i. ");
INSERT INTO guxg_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Li go diani ki yedi ne: “N ba buoni bi yanfodanba yanfuoma, ki biani bi nunfandanba nunfanbu. ");
INSERT INTO guxg_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","O yanfodaano ye le? o gbanbando ye le? Ti jamaano ne ñɔniadaano ye le? U Tienu ki cedi ke ŋanduna yanfuoma kpandi gaadma aa? ");
INSERT INTO guxg_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Kelima, nani ŋanduna yeni o yanfuocema ki bandi U Tienu yeni U Tienu yanfuoma, li tua U Tienu po yanbuama i, ke wan faabi yaaba n dugi o po yeni mi gaadmaama. ");
INSERT INTO guxg_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Jufinba buali yaalidgu bona po, ke binilanba lingi mi yanfuoma. ");
INSERT INTO guxg_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Tinba ti wangi ban kpaa ya Kiristu li daapɔnpɔnli po i; li tie janjanma jufinba po, ki tie gaadma bi nilanba po. ");
INSERT INTO guxg_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ama, ban gagdi ki yini yaaba ya po, ban tie jufinba bii nilanba aa, li tie bi po U Tienu paaciamu yeni U Tienu yanfuoma i. ");
INSERT INTO guxg_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Kelima U Tienu gaadma pia mi yanfuoma ki cie bi nisaalba, ke U Tienu tadingu pia u paalu ki cie bi nisaalba. ");
INSERT INTO guxg_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","N naataani, yin ya bani ke yinba yaaba ke bi gagdi ki yini i siiga, ti gbannandi yanfodanba ki yabi, u paaciamu danba ki yabi, bi ŋalmandanba mo ki yabi. ");
INSERT INTO guxg_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ama U Tienu taa ŋanduna yanluoma bona i, ki tulni bi yanfodanba, ki taa ŋanduna tadingu bona, ki tulni u paaciamu danba. ");
INSERT INTO guxg_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","U Tienu lugdi ya bona n ki pia mayuli ŋanduna nni, yeni bi niba ń fali yaali, ke laa pia fuoma, ki fanbi ban nua yaali ke li pia mayuli. ");
INSERT INTO guxg_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","O tieni lani, ke nisaalo ń da kpiagdi o yuli U Tienu kani. ");
INSERT INTO guxg_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Wani ya po i, ke i fo Jesu Kiristu nni, wani yua n tua ti po yanfuoma, teginma, gagdiŋanma yeni daafaabma, ");
INSERT INTO guxg_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Nani lan diani ki maadi maama: “Yua n kpiagdi o yuli, wan kpiagi o yuli O Diedo nni. ");
INSERT INTO guxg_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","N kpiiba, min den gedi i kani ki ba dɔgdi U Tienu ŋasiili ki waani yeni, n dee kubi mi mabanma bii mi yanfuoma ka ki muandi yi. ");
INSERT INTO guxg_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Kelima min den ye yi siiga yeni, ki jagi ki jagi ki cuo ke Jesu Kristo bábá yaaa ka, min ki bani libá ki ba maadi li po, Jesu Kristo yua ke bi den kpaa o li dapɔnpɔnli po yaa ka. ");
INSERT INTO guxg_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","N den cua yi kani ki tie nani yiamo yeni, ki jawaani pia nni, ke n jegli paaa. ");
INSERT INTO guxg_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","N dee pia mi mabanma leni mi yanfuoma ka, ki tundi i tundi, ki gɔ muandi n laabaali, ama n maama nni leni n tunda nni, Foŋanma n den wangi mi paalu. ");
INSERT INTO guxg_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Li den tie yeni ke yin da taa dandanli ki teni o nufosaalo yanfuoma ka, ama ki ya dugi U Tienu paalu po. ");
INSERT INTO guxg_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ama leni li kuli, leni mi yanfuoma i ke ti tundi yaaba ke bi yama gagdi Kristo ŋɔgkaaba nni. Li yanfuoma ki tie ŋanduna ne yaama, mi gɔ ki tie ŋanduna ne badbijaba yaama; ban wan ba bia bikuli. ");
INSERT INTO guxg_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ti maadi U Tienu ya yanfuoma i, mi den tie ŋasiili yaama n wuo i, ke u den tuodi ki bobni ti yudandi po ki sua ke ŋanduna da ki ye. ");
INSERT INTO guxg_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ŋanduna badbijaba ne, obá naa bani li yanfuoma, bi den kan cedi ke ban kpaa Yudandi Yonbdaano dapɔnpɔnli po. ");
INSERT INTO guxg_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ama nani lani diani U Tienu tili nni yeni: O nulo nibinli n kan baa lá yaala, ke o tubli mɔ n kan baa gbadi yaala, ya maalma n kan fidi ki kua o nulo pali nni palbi yeni, U Tienu bobni mani yaaba n bua o po. ");
INSERT INTO guxg_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Tinba i ke U Tienu cedi ke mi foŋanma wangi ti u ŋasiili, leni i mɔni, mi foŋanma wan nua bonla kuli, bá yaala n wuo U Tienu pali nni mɔno. ");
INSERT INTO guxg_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ŋma bani yaala n ye bi nifosaalba pali nni? Nifosaalo bábá n bani o pali nni yaala n ye o pali nni. U Tienu mɔ, li tie yeni, U Tienu foŋanma bábá yaa ka, obá ki bani yaala n ye U Tienu pali nni. ");
INSERT INTO guxg_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Tinba wan ki kubi ŋanduna ne yema ka ki tuuni li tuonli, U Tienu n puuni ti u foŋanma ke ti fidi ki bani wani U Tienu n puni ti ya paabu kuli. ");
INSERT INTO guxg_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Tin maadi yaala yeni: Ti ki maadi nani nifosaalo yanfomaama n buali maama ka, ti maadi nani U Tienu foŋanma n tundi ti ke tin ya maadi maama i. N nua ke ti wangi yaaba n pia U Tienu foŋanma, yaala n tie U Tienu foŋanma yaala. ");
INSERT INTO guxg_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ya nulo ki pia U Tienu foŋanma, kan fidi ki gaa yaala n ñani U Tienu foŋanma kani. O ya po li tie gaadmaama i, o kan fidi ki gbadi mi niima nni, kelima U Tienu foŋanma n yen puni bi niba li banma. ");
INSERT INTO guxg_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Yua n pia U Tienu foŋanma ba fidi ki ya bani bonla kuli ya niima nni, ama obá nan kan fidi ki ya bani u ya niima nni. ");
INSERT INTO guxg_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Kelima nani lan diani U Tienu tili nni yeni, ŋma bani ti yobdaana maalma, ŋma ba fidi ki teni u i cegli. Tinba wan nan pia Kristo maalma. ");
INSERT INTO guxg_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","N ninjab yen n nipuob, n kan fidi k ya maadi yeni nani jaanditieba yeni, ama nani min gbannanbuama danba yeni, nani yaaba da guani k mali jesu nni yeni. ");
INSERT INTO guxg_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","N tieni mi naaŋanma i, ti nandi ka. Hali yeni mɔla kuli i da k bobni k dagdi. ");
INSERT INTO guxg_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Kelima i da li tie gbannanbuadanba i lani ya po i, ke li nunponli yeni a kɔnkɔna da bii ki ye i siiga. I ki cɔlni u gbanu i yema nni ii, i ki cɔlni bi niba yikodi yi cenli ni ii? ");
INSERT INTO guxg_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Nilo ya yedi: “mini taa Apolɔsi po i” ne ki tie gbannanbuama yema ka aa? ");
INSERT INTO guxg_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ŋma tie Apolɔsi, ke ŋma tie pɔli? Yi dugi ya tuonsɔnba po, ke u tienu puogi ba o tuonli. ");
INSERT INTO guxg_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","N ŋuundi, ke Apolɔsi jɔgni, ama u tienu n cedi ke li pa. ");
INSERT INTO guxg_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Lan wani ii, yua n ŋuundi yeni yua n jɔgni k tie liba kuli. Ama u tienu n cedi ke li pa. ");
INSERT INTO guxg_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Mɔla yua n ŋuundi yeni yua n jɔgni kuli tie yema i, yua kuli ba baa o panpaai nani o tuonli n dagdi maama. ");
INSERT INTO guxg_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Kelima ti tie u tienu tuonsɔnlai. I tie u tienu gɔgdigu, u tienu tagma. ");
INSERT INTO guxg_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Nani u tienu n puni nni o ŋalbalga yeni. N bili li fiagli nani tanmaaciamo yeni N bili li fiagli ke tɔa n maa ki tuani. Ama yua n ba maa ki tuani ṅ ya cegi. ");
INSERT INTO guxg_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Kelima oba kuli kan fidi ke maa fiagtianli ke li kandi ban bili yaali, lani n tie jesu kiristo. ");
INSERT INTO guxg_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Mɔla, yaa n maa fiagli po yeni wula yoo, muadi yoo? ");
INSERT INTO guxg_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","U yensiinu ba dogdi ki maani o tuonli n dagdi maama. Kelima o mu ba bigni o ku waani yua kuli tuonli ṅ dagdi maama. ");
INSERT INTO guxg_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","O nilo ṅ maa yaali ya mɔni ki ciadi, o bo baa o panpaai. ");
INSERT INTO guxg_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ama li ya juu (sia) oba la fala waamu, ama bi ba faabi'o u mu po ");
INSERT INTO guxg_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","I bani ki tie u tienu yekaanu, ke u tienu fuoma ye i niinni? ");
INSERT INTO guxg_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Nilo ya biidi u tienu yekaanu, u tienu ba biani'o. Kelima u tienu yekaanu tie kaan ŋanmu i nani yimba yeni. ");
INSERT INTO guxg_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Nilo ṅ da bɔndi o yuli. Nilo ya maali ke o tie yanfodaano ti jamaano ne, wan go tu a gaado, yeni, o baa pia mi yanfuoma. ");
INSERT INTO guxg_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Kelima ki tinga nni yanfuoma tie u tienu po gaadma i. Kelima bi diani: “o gaadma yaalidi o yanfodaano. ");
INSERT INTO guxg_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Yaali n pugdi u tienu bani ki bi yanfodaama yantiana tie bonyuyuodi i “ ");
INSERT INTO guxg_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Lanwani i, li ji ki buali japaadi bi niba po. Kelima yinba n yeni buoli kuli. ");
INSERT INTO guxg_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Lan tie Pɔli ii, Apolɔsi ii, bii Sefasi, li ŋandunli, mi yema aa, bii mi kuuma, m ɔlane ya bona bii ya bona n ba yuandi ki, lan kuli, yinba n yeni. ");
INSERT INTO guxg_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Kiristo n yeni yi mɔ, ke kristo mɔ tie U Tienu ");
INSERT INTO guxg_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Lanwani i, bi nua ti ke ti tie Kiristu naacenba, U Tienu ń gagdi ki lugdi yaaba ke ban ya wangi o banma yaama n duagi ");
INSERT INTO guxg_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Bi nan ki buali bontɔli yaaba n wangi mi yeduagikaama ki kandi li papienli yeni ti dudugdi. ");
INSERT INTO guxg_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Mini ya po, li ki maadi nni libá kuli yeni yin jia n buudi bii bi bujiaba ń jia n buudi. Mini n bá mo kan bu n buudi kelima n naa pia biidi bá kuli. ");
INSERT INTO guxg_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Ama lani ka kuni nni i mɔni, yua n ba jia n buudi n tie O Diedo i. ");
INSERT INTO guxg_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Lanyapo i, li ki buali ke yin jia buudi bá kuli, ke u yogu dá ki pundi, guudi mani hali O Diedo cuama, wani n ba tieni mi yenyenma ki dɔgdi yaali n duagi li biigli nni kuli, ki ba dɔgdi yaali n wuo bi niba pala nni kuli. Lanyogu i, ke U Tienu ba teni yuakuli wan dagdi yeni ya kpiagdi. ");
INSERT INTO guxg_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","N naataani, yinba ya po i, ke n taa mini yeni Apolosi yema nannanli, ki bua waani yi, ke yin togdi ti yema, ki da tieni ki pendi yaali n diani ki bili, ke i siiga, nilo ń da kpiagdi yendo, ki fali o lielo. ");
INSERT INTO guxg_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Kelima ŋma n cedi ke a ki taa yeni a lieba? A pia be ke laa ñani U Tienu kani? To, li ya tie ke U Tienu n puni a, be n cedi ke a kpiagdi a yuli nani ŋaa baa li U Tienu kani ka yeni i? ");
INSERT INTO guxg_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Mɔla i guo, mɔla i ji tie ŋalmandanba i, bá ke tii ye i kani, i cili ki ji diedi u kaanu. U tienu ń todi yin diedi u kaanu, ti mo ń ti fidi ki diedi yeni yi! ");
INSERT INTO guxg_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Kelima, li naani ke U Tienu cedi ke timba bi tondba n juodi bi niba kuli ya siiga, li tie nani ti buudi jia ki cuo ti ke li buali ke tin kpe yeni i. Kelima bi ñani ki sieni ti asala siiga nni, bi niba yeni malekinba siiga nni. ");
INSERT INTO guxg_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Kiristu po cedi ke ti tie gaada, ama, yinba, i pia li miali Kiristu nni, ki tie yanfuodanba; tinba tadi, ke yinba tie paatieba. Bi kpiagdi yi yela, ki nan fali tinba! ");
INSERT INTO guxg_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Hali yeni mɔla kuli, mi koma, u ñuñuunu, yeni mi mubima n bua kpa ti. bi cagni ti, ki wangi ti fala; ke ti waa, tii bani tin caa naani. ");
INSERT INTO guxg_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Ti tuuni yeni ti nui, ki cɔgi, bi sugdi ti, ke ti kpiagdi U Tienu; bi cagni ti, ke ti tuo ki gaani. ");
INSERT INTO guxg_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Bi ya tabi ti ku totabgu, ti yen jiini mi yama ki maadi yeni li padingli; ti ji tie nani ŋanduna baadi yeni, nani bi niba ń yie ki luni yaali hali yeni mɔla. ");
INSERT INTO guxg_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Mii diani yi ne kuli ki bua min kuani yi i fee ka, ama n diani yi nani n bibuadkaamu yeni. ");
INSERT INTO guxg_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Kelima i ya ti pia Kiristu tundkaaba tuda piiga, lani naa wangi ke i pia Báanba ke bi yabi ka, kelima mini n todi yeni o laabaalŋamo, ki cedi ke i mali Kiristu nni. ");
INSERT INTO guxg_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Lanwani i, n mia yi ke yin ya togdi n yema. ");
INSERT INTO guxg_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Lanyapo, n sɔni Timote i kani, wani yua n tie n bibuadga, ke o dudugdi yabi O Diedo po; wani n ba tiadi yi min pia ya sanbila Kiristu po, yeni mi tundi maama ti jaandiedi nni, kaankuli. ");
INSERT INTO guxg_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Nitianba i siiga nni gbie yeni ti japaadi nani n ji kan cua i kani yeni. ");
INSERT INTO guxg_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ama, li ya tie O Diedo yanbuama, li ji kan waagi, n ba cua i kini, ki bandi yaabi n fiindi ti japaadi paaciamu, li ki tie bi maama ka. ");
INSERT INTO guxg_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Kelima U Tienu diema ki tie maama ka, ama paaciamu i. ");
INSERT INTO guxg_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","I bua be? Min cua i kani yeni balju bii yeni mi buama yeni mi yandingma i? ");
INSERT INTO guxg_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","N gbia ke bi maadi i maama ki tua ke mi conconma ye i siiga ke lan ya conconma buolu ki ye bá bi nilanba kani; mi yabdi hali ke i siiga, yendo dua yeni a báa denpua. ");
INSERT INTO guxg_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","I yabdi ti japaadi! yii tuo ki biidi i pala li tuonbiadi po, ki ba beli ki ñani i siiga yua n tieni lan ya tuonjɔgindi ! ");
INSERT INTO guxg_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Bá ke n fagi yeni yi ti gbannandi po, n nan ye i siiga yeni n yantiali. N jia ti buudi ki cuo yua n sɔni lan ya cancagindi nani n ye i siiga yeni. ");
INSERT INTO guxg_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ti Diedo Jesu Kiristu yeli po, yinba yeni n yantiali ń taani ki ye yeni ti Diedo Jesu Kiristu Paaciamu, ");
INSERT INTO guxg_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Li buali ke yin cedi ke setaani ń biani lan ya nilo gbannandi, o naano ń fidi ki baa u faabu ti Diedo Jesu ń ba cua ya daali. ");
INSERT INTO guxg_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","I kpiagdi i yula fanma i, yii bani ke li dabinli waamu ne ba fiini ti bugdi kuli ii? ");
INSERT INTO guxg_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","yin buoni mani li dabinkpeli, yeni, i ba tua bugpaandi, nani yin ki pia dabinli yeni, kelima bi padi Kiristu ti paak pabiga o. ");
INSERT INTO guxg_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Lanwani i, tin jaani mi jaanma lan da tie yeni li dabinkpeli, ki da tie i janbi yeni mi biadma dabinli, ama yeni ya kpanu n ki pia dabinli lani n tie li papienli yeni i mɔmɔni. ");
INSERT INTO guxg_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","N diani yi li tili, ke yin da pia dɔnligu yeni yaaba n tie mi conconma, ");
INSERT INTO guxg_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","mii maadi ŋanduna nni concona kuli ka, bii bi fafagdanba yeni a suuda, lani yaa ka yeni yaaba n ŋua i buli ka; li ya bi tie yeni i, li bi buali ke yin ña ŋanduna nni i. ");
INSERT INTO guxg_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Mɔlane, min diani ki waani yi yaali n tie ke yin da cuo dɔnlgu yeni yua tua ke o tie i naataano, ki nan conbi, ki tie fafagdaano, bii ki ŋua i buli, bii ki tie suudo, lan yaa ka nisugdo, bii daañugaado, lan yaa ka yua n buadi jodi dima; yin da taani ki di yeni lan ya nilo. ");
INSERT INTO guxg_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","N ya jia niinpo yaaba buudi, li ba pugni nni be? I kan jia ti buudi yeni i siiga nni yaaba ka aa? ");
INSERT INTO guxg_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Yaali n nua niinpo yaaba, U Tienu ba jia bi buudi, yin beli ki ñani o nibiado i siiga. ");
INSERT INTO guxg_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","I siiga nni nilo ya baa maama yeni o lielo, o ba yini o bi nilanba kani ti buudi ki kan gedi bi nimɔnba kani ii? ");
INSERT INTO guxg_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","I ki bani ki bi nimɔnba ba jia ti buudi yeni ŋanduna aa? ");
INSERT INTO guxg_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","I ki bani ki ti ba jia ti buudi yeni malekinba aa? Li ba gaa ledi keti kan jia ti buudi yeni mi yema mabidi? ");
INSERT INTO guxg_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","I ya ba fidi ki jia mi yema maabidi, li tieni ledi i, ke yi ba liidi ki kpaagi li maama ki ŋa yaaba n ki pia mayuli i jaandi ni taanli nni i? ");
INSERT INTO guxg_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","N maadi yi, li tie i fee i. Nilo ki ye i siiga nni ki ba fidi ki jia maama nilo yeni o naataano siiga nni yeni mi yanfuoma aa? ");
INSERT INTO guxg_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ama nilo ṅ yini o kpiilo ti buudi daano yua ki dugi kani. ");
INSERT INTO guxg_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Yaali n mɔni tie ke kɔnkɔnli n ji da ye kristo nitaanlinni. Lani tie biginli i po. Li ga ledi ke kan ŋmali o biidka tubli. Li tien ledi ke janbdi i lieba? ");
INSERT INTO guxg_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Li tie ke i tieni mi tudma i kpiilo po ");
INSERT INTO guxg_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","I bani ke yua n ki tiegi kan di u tienu diema faali ii? Da cengi mani mi tofaama, ti cancangindi, i buli jɔdma, mi conconma, mi naaŋmaama ya jaba n dua yeni bii jalieba, ");
INSERT INTO guxg_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","bu subu, mi ŋaanma, li daañugaadli, ku totabgu, yeni jodi. Oba kuli kan di u tienu diema faali. ");
INSERT INTO guxg_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","B tianba i siiga nni tie yeni i, bi ŋuudi i pala ke i ji ŋani, ki guan ki mangi yeni u tienu. Ti badciamo jesu kristo yeli po yeni u tienu foŋanma po. ");
INSERT INTO guxg_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","“ Bi cabi nni buoli kuli” ama li kuli ka tie bonmɔnli, ki pia mi buama. Bi cabi nn buoli kuli ama n kan tua bonliba kuli yonbo. ");
INSERT INTO guxg_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Mi jiema ye ku puogu po, ke ku puogu mɔ ye mi jiema po. Ama u tienu ba biani lan ya bona kuli. Ama u gbann ki ye mi conconma cagindi po ka, ama ti yonbdaano po. O tuonsɔnlo ba lingi bonli kuli u gbanu po. ");
INSERT INTO guxg_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","U tienu bu faadi ti diedo yeni tinba o paa ciamu po. ");
INSERT INTO guxg_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","I ke bani ke i gbanu ti( u tienu) kristo gbannandi ii? N ba taa kristo gbannandi ki taani yeni li poconconli ii? Lani ṅ da tieni! ");
INSERT INTO guxg_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","I ke bani ke yua n taani yeni conconli tua gbannanyendi yeni ooo? Mani lan diani maama “bani bilie kuli taani gbannanyengu” ");
INSERT INTO guxg_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ama yua n taani yeni o diedo ba taani ki tua yeni o yantiayenli. Yin fangi i yula yeni mi concomma cancangindi. Ya tuonbiidi n sieni ke nilo ba tieni km taabi o gbanu, ama mi conconma cancangindi tie ya tuonbiidi n taabi o gbanu i. ");
INSERT INTO guxg_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Sani mani ya bontitiedi ke ŋani, ya tuonbiidi n sieni kuli jɔgni ti gbanu i. I ke bani ke mi conconma biidi ti gbanu i. ");
INSERT INTO guxg_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","I ki bani ke i gbanu tie u tienu foŋanma yekaanu uu? Yaama n ye i niinni. Yin gaa yaama u tienu kani. Yeni, l ji ki yeni i yuli ii? ");
INSERT INTO guxg_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Kelima bi cɔdi, ki daa yi. Ama yin taa l gbanu ki kpiagi u tienu yeli. ");
INSERT INTO guxg_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Mɔlane yaal n nua ya bona po k dian ne, li ŋan yen nul n da nagn pua. ");
INSERT INTO guxg_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ama m buam po, ja kul ba pia o pua, k pua kuli pia o calo ");
INSERT INTO guxg_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","O ja ba ten o pua yaal n taanb k b ye yen lieb, o pua n mɔ da bel o calo yaal k'o mia'og kuli, ");
INSERT INTO guxg_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","o pua k pia yiko o gbannand po, k li ya k tie o calo ka, yen mɔ'i ko ja k pia yiko o gbannand po k li ya k tie o pua yaa ka ");
INSERT INTO guxg_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Da yied man yen yin taan i lieb m buam sanu n k li ya k tie ki taan k kal k cuo yanjagl, yeni ki b ŋanb k ya jaand, k ŋanb k kɔbn i lieb, yeni k sitaan kan fid k bign ni. ");
INSERT INTO guxg_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","N maadi li bona nan cegl yeni, l k tie yen yikod kan, n miad k nil kul ");
INSERT INTO guxg_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","n ya tie nan min yeni. Nil kul pia ya paabu ko gaa u tienu kani, l paabu ye jiag jiag ");
INSERT INTO guxg_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Yinb yab k pia puob yen a pakuana, n maadi k l ŋan i po, i ba ye li yinyienun nan min yen ");
INSERT INTO guxg_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ama, b ya kan fid k cuo b ba, li bual k ban kuan lieb, klma l ba su b po yen ban kuan lieb k da sien k ye m buam fala n ");
INSERT INTO guxg_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Mɔlane n tien ni ya yiko ne yinb yab kuan lieb, min ka, ama u tienu. Pua kan sied k ŋaa o calo, ");
INSERT INTO guxg_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ama o ya tienl, o ji kan kun ja tian, o ba ye oba, lan ya ka wan guan k mangi yen o calo, ja mɔ kan bel o denpua ");
INSERT INTO guxg_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Ama yaal n sien kul u tienu n maad, k fid k nil yua pia pua yua k jaand n tien mɔndl k da bel l pua, k ya ye yen'o, ");
INSERT INTO guxg_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","li tie yeni ya pua kuni ya ja k jaandi, k li ja bo sun k wan kuan li pua, o pua yen mɔ k pia ya yiko ko b bel l ja ");
INSERT INTO guxg_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Klma o pua jaandi tod li ja ko fuo t ŋandn, o pua yua k ban k'u tienu ye fuo ti ŋandn k dugn o ja jaandi po, lan ya ka, i bid kan ya fo ti ŋandn, ama mɔlane b fuo ti ŋandn ");
INSERT INTO guxg_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ama li ya tu k yua k ban u tienu sied, ŋaogu wan ya caa, li sanu n ni, o ja bii o pua ji k cɔlm o puoni. U tienu yi'ti k tin ya fuo laafiaa n. ");
INSERT INTO guxg_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","k dugn o pua, a k bani naan kani ba fie a calo, bii fin o ja naan ka b gaa a denpua miali ");
INSERT INTO guxg_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Yua kul n ya fuo u tienu n bo tag'o k wan ya fuo nand, u tienu n yin yua kul o tuonln, ne tie n yikod ti jaanddieln. ");
INSERT INTO guxg_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Yinb yab kul kɔnd ya yognu k'u tienu bo yin nii? da kpaan man yin ñan bii yin piin i kɔnd bam ka, yua k'u tienu yin'o ko k kpel k ban'o bual ban kɔnd'o? li k tie niinl ye ban kɔnd'o. ");
INSERT INTO guxg_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","yaal n tie bonmonli k tie ti kɔndi ka, ama yaal n ŋanb k mɔn tie ti cɔlnd u tienu ñɔmaamn ");
INSERT INTO guxg_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","N ninjab, n nipuob, lan tie ya tuonli kul, k t suan, tin sien k ya ceg k l paa. ");
INSERT INTO guxg_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","I bo tie yonbi ya yognu k u tienu bo yini nii? li bo pia'i o yanpudgu? ama i ya b fid k yal iba, kagn man, ");
INSERT INTO guxg_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ya nilo k u tienu yin'o k o bo tie yonbg, li daan'o n yal oba u tienu po, li tie yeni yua n yal oba, ya yognu k u tienu yin'o ko dindanl yab, o ji yi tie jesu yonbo'i. ");
INSERT INTO guxg_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","B den daa'i yen ya daagu n pa, lan, da tie man b nib yonbi. ");
INSERT INTO guxg_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Yua kul n sien k ya fuo u tienu maamn nan ya yognu k u tienu yin'o k o dindanl yab yen. ");
INSERT INTO guxg_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Yinb yab sien k k ban jab, n pia yiko ba kul k l tie i yal yonbidaan nungn, ama ya du man i lieb po yen ti tienu po. ");
INSERT INTO guxg_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Li ya po, yen ya fala(cicagm) mab'i kul, l ŋan yen k yin ya ye i ba'i. ");
INSERT INTO guxg_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","I lol ŋasiil yen pua k nua li puobianli sanun ni? da kpaan man k yin wad i pala. I lol ŋasiil yen pua, bii i ye yanli? da kpaan man yin tien puobianli. ");
INSERT INTO guxg_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Ama li ya tie ki tien puobianli, yin da tie biid. Yab n kuan liebi, fala yen a maba boncianli yi gbadb ya yognu k b ye yen liebi, n bua yin kua li maba n. ");
INSERT INTO guxg_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","N maadi ne, n ninjab yen n nipuob: o yogu k yabi, mɔlane, yab pia puob n ya ye nan b ya bo k pia yen. ");
INSERT INTO guxg_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Yinb ya buud, tien man nan i k pia ninsiid yen, yinb yab ye li pamanlin n, yinb yab tie nimɔnb, yinb yab daa bona kuli, ya tiend man nan ya danb k pia lba yen, ");
INSERT INTO guxg_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Yinb yab n kpend yeni li ŋandunli, i bontitied n ya naan nan yab k pia ñuad li ŋandunl yen, klma, li ŋandunli ji caa o juodma. ");
INSERT INTO guxg_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","N bua k yalnba yal tie cicagbuol kuln, yua k kuan pua bii k kun ja, yi tug oba k cab t yonbdaano, k mangi yonbidaan pali, ");
INSERT INTO guxg_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Ama yua tien puobianli, yi tug oba k cabi ŋanduna ne bona, kpaan wan mangi o pua pali, ");
INSERT INTO guxg_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Yua k kuan pua bii k ban ja, tug oba k cabi u tienu tuona, o kpaan wan ya ŋan o gbannand yen o nalg kuli, li tie yeni mɔ ya pua k kun ja po mɔ, o yi tug oba k cabi ŋanduna ne bona, k kpaan mangi o calo pali. ");
INSERT INTO guxg_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","N maad ne, k lan fid k tod'i, k da baad yen jeje i po, ama lan ya mɔn i po u tienu sanun k gbanñagl n da kua'i. ");
INSERT INTO guxg_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Ama, ya daan'o mali ko k ŋanb k kub o pua k dugn o buakaal yabd yen wan tien o puobianli nan wan bo sun maama, ");
INSERT INTO guxg_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","L k tie bonbiil, ama o kal k jag ko kan tien puobianli k mabl ba kul k ye o po, ko b fid k cuo oba, l baa tie bonŋanl yen o ya k kuan'o. ");
INSERT INTO guxg_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Li tie yeni k wan kuan o pua, o kub k ŋan, li tie yen mɔ yua k kuan pua po, o ŋanb k kub k l ŋan boncianli. ");
INSERT INTO guxg_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Opua ŋanb k kub o calo ya yognu k b da fuo, ama o calo ya tua yua k ye (yua kpe), o b fid k guan k kun ja tian, ama li kul ne 