﻿USE sofia;
DROP TABLE IF EXISTS sofia.gupk_vpl;
CREATE TABLE gupk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gupk_vpl WRITE;
INSERT INTO gupk_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Nawu KAWOHRNAN bimarneyimeng Eleydja. ");
INSERT INTO gupk_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Ngayi ngamarneyimeng ngalkodjmong kure kunred Djarabad yingimen kure Djeydon ba ngunwon manme. Ngudda yiray kure kubolkkimuk, kumekke yini.” ");
INSERT INTO gupk_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Wanjh Eleydja kamwam darnkih kure kubolkkimuk kurrukdangmaye kure Djarabad. Nungka binang ngalbu ngalkodjmong menehme manyahyay nungka bidjawam “kamak ngudda yimka ngarduk kunronj.” ");
INSERT INTO gupk_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Ngaleng wam bomey kunronj mak biyawoyhdjawam, “kamak ngudda yimka ngardduk manyahwurd lodno.” ");
INSERT INTO gupk_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Ngalkodjmong biwokmey, “marneyimeng kure kungey nuye kahni nawu KAWOHRNAN nawernkimuk Kod. Ngayi minj ngakarrme manbu lodno ngayime woyhbukki. Ngayi ngakarrme manyahyey mane wanjh bolkkime ngare kured. Mak ngayi ngakarrme manyahwurd manduy mak manyahwurd kunkalkid. Ba ngakinje ngarrewoneng ngayi mak ngardduk nayawh yerre wanjh bu nganemarrwer dowenh.” ");
INSERT INTO gupk_vpl VALUES ("K117_13","012_17_13","1KI","17","13","14","Eleydja yimeng, “Nawu KAWOHRNAN, Kod kure Israel bu kakurduyime kunmak kabukubukmen. Nguddangke ngahlanno manduy minj kayakmen nguddangke budjulung kunkalkid minj mak kayakmen. Bu wanjh yerre kamunkewe mandjewk. Yirrokmen kured ba ngudda yikinje bu yiyimeng. Yikinjemen manyahwurd manlod mak yimka kure ngayi. Wanjh yikinjemen ngurrewoneng. Wanjh bonj bu kamak rowk.” ");
INSERT INTO gupk_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Ngalekke ngalbu ngalkodjmong dokmeng kured marnbom rowk bu Eleydja bimarneyimeng. Ngalbu ngalkodjmong ngalenngarre nayawh mak Eleydja birrikarekarrmeng manme kunkuyeng bedberre. ");
INSERT INTO gupk_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Bu kunwok nuye nawu KAWOHRNAN bimarnewokdi Eleydja. Bu ngalengarre rowk ngalkodjmong ngahlanno manduy minj kayakmen dja budjulung kunkalkid minj mak kayakmen. ");
INSERT INTO gupk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kune wanjh yimerranj bu Jesus Christ dolkang. Meri Mary ngalu ngal-badjan nuye wanjh birri‑berrebom Djodjib Joseph bu kamene‑marren, med, minj bedda bene‑marrimeninj, wanjh ngaleng kuk-bekkarrinj bu kuk‑dulmuk‑ni kure kun-ngudj nuye Nawaralmakkaykenh. ");
INSERT INTO gupk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kaluk Meri ngalengngarre na‑bininjkobeng Djodjib, nungka na-mak bininj, nungka minj djareniwirrinj bu bi‑yemi‑mulewayinj kure kabbal, nungka karre‑marnbom bu kabi‑bawon kure minj kabbal. ");
INSERT INTO gupk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kaluk kumekke bu Djodjib kune bengkah‑bengkang, wanjh andjel angel nuye nawu Kaworhnan Rowk bi‑marne‑bebmeng kure bukirri. Kaluk nawu andjel bi‑marneyimeng, “Djodjib, nawu mawah-mawah ke Deybid David, minj yi-kele yi-mang ngalu Meri bu yi‑kan kure ku-red. Nawu wurdyaw kah‑yaw‑kan nakka wanjh Nawaralmakkaykenh bi‑yaw‑wong. ");
INSERT INTO gupk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kaluk ngaleng ka‑yaw‑mang na-rangem, wanjh ngudda yi‑ngey‑kurrmen Jesus nungka kan‑kange‑yerrke bininj rowk nuye kun‑warre‑kenh bedberre.” ");
INSERT INTO gupk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kune wanjh yimerranj kure nawu Kaworhnan Rowk bu bi‑marneyimeng nawu na-kare Aydjaya Isaiah, bu yimeng, ");
INSERT INTO gupk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kaluk ngale ngal‑yawk wanjh ka‑yaw‑kan. Kaluk bu kabi‑yaw‑mang na‑rangem, wanjh bininj kabirri‑ngeybun Yimanyuwel Immanuel (kaluk mane kun-ngey ka‑yime, ‘Kod kam‑wam kure ngad karri‑djarrkni’”). ");
INSERT INTO gupk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wanjh Djodjib dolkkang, durrkmirri kure andjel nuye Kaworhnan Rowk bi‑marneyimeng. Wanjh Djodjib bene‑marrinj ngalu Meri. Bi‑kang kure ku-red nuye, ");
INSERT INTO gupk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","minj bedda bene‑yuwirrinj kaluk rerrih danginj nawu wurdyaw. Wanjh Djodjib bi‑ngey‑kurrmeng namekke wurdyaw Jesus. ");
INSERT INTO gupk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus wanjh danginj kure kun-red ku‑bolk‑kimuk ka-bolk‑ngeyyo Bedliyem Bethlehem kaluk kure ku-bolk‑warlah ngalengarre Djudeya Judea bu kumekke bolkyimerranj Ayrod Herod nawu King worhnang. Wanjh kumekke Jesus danginj, birri-buyika bininj nawu ben-bengdayhkeng kinhkinh nawu birri‑dolkkang koyek-beh djarreh, wanjh birri‑wam kure Djerudjalem Jerusalem. ");
INSERT INTO gupk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wanjh bedda birri-djawayhmeng, “Baleh nawu wurdyaw danginj nawu ka-worhnan bedberre bininj nawu Dju Jews? Wanjh ngad ngarri‑nang kinhkinh nuye kure koyek djarreh ngarrih-ni, wanjh ngad ngarrim-wam ngarri‑marne‑barddurrungkulhdanj nuye.” ");
INSERT INTO gupk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kaluk kuneng kun-wok King Ayrod bekkang, nungka wanjh njilng‑warreminj, mak bininj rowk warridj nawu kumekke birrih‑ni kure kun-red Djerudjalem birri-njilng-warreni. ");
INSERT INTO gupk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wanjh Ayrod ben-kayhmeng birri-kihkimuk nawu kabirri‑worhnan djungkay mak nawu man‑karre kabindi-bukkan birri-buyika bedberre kure kun-red Djerudjalem, wanjh ben‑djawam bu baleh nawu Christ danginj. ");
INSERT INTO gupk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kaluk bedda birri-marneyimeng, “Kure kun-red Bedliyem kure ku-bolk‑warlah Djudeya Judea ngalengarre. Nawu na-kare bi-wok-bimbom bi‑wok-mulewam kuneng‑kenh kure djurra, kure yimeng, ");
INSERT INTO gupk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Ngudda kun-red Bedliyem, kure kun-red ngale‑ngarre Djudeya, ngudda nawu ku‑bolk‑mak, yi-yurrhke rowk kure ku‑bolk‑buyika ngalengarre Djudah Judah. Wanjh ngudda kumekke-beh kure ngudda, kam‑re nawu bininj kaben-marne-worhnan bininj nuye, nane nawu bininj na-kudji kaben‑nahnan bininj ngardduk nawu Yidjrayel Israel mawah‑mawah, yiman ka‑yime nawu djebed shepherd kaben-nahnan mayh nuye.’” ");
INSERT INTO gupk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wanjh King Ayrod ben-kayhmeng ben‑marne‑wokdi molkno birrimekke bininj nawu koyek-beh, wanjh ben-djawam bu baleh bolkyimeng ngalekke kinhkinh ben‑marnebebmeng bedberre. ");
INSERT INTO gupk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wanjh King Ayrod ben-munkeweng birrimekke nawu bininj kure kun-red Bedliyem, ben‑wok‑rayekwong ben-marneyimeng, “Ngurri‑yawa namekke wurdyaw kaluk ngurri‑ngalke, ngurrim‑ray werrk kandi‑marneyime ba ngayemanwali nga-re nga‑barddurrungkulhdan nuye.” ");
INSERT INTO gupk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kaluk bu kumekke ben-marneyimeng nawu ka‑worhnan, wanjh bedda birri‑bolk‑bawong, birri-wam. Wanjh kinhkinh birri-nang kure koyek, wanjh makka kuk-dokmeng bedberre wanjh kaluk danginj kure kumekke wurdyaw yongohyoy. ");
INSERT INTO gupk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kaluk bu birrimekke bininj birri-nang ngalekke kinhkinh, bedda wanjh birri‑njilngmakminj, birri‑djurrkwong. ");
INSERT INTO gupk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wanjh birrim-wam kure ku‑rurrk kure wurdyaw yongohyoy kaluk ngal‑badjan dorrengh bindi-djarrk-ngalkeng ngalu Meri Mary. Wanjh birri‑marne‑bard‑durrungkulhdanj bu bedda birri-burlumeng nungka nuye. Yerre wanjh birri-dangmarrhmey nawu na-makmak birrim‑kang bu birri-wong nuye. Kaluk nawu kold gold kun-wardde karlba marlahmarlhmeng, mak brangkindjendj frankincense manbu man-kurrk manjmak, mak mer myrrh manbu kun-karlkid yiman djarduk. ");
INSERT INTO gupk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wanjh Kod ben-bengdayhkeng bukirri bu minj kabirri-durndeng kure King Ayrod, wanjh bedda birri-durndi kure bedberre kun-red, kure man‑bolh-buyika ngalengarre kure birri‑wam. ");
INSERT INTO gupk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kaluk bu kumekke birri-bolk‑bawong nawu bininj birri-kang koyek, wanjh andjel angel bi‑marne‑bebmeng Djodjib Joseph kure bukirri, wanjh bi‑marneyimeng, “Yi-rrolka! Yiben-ka wurdyaw ngalbadjan dorrengh, ngurri-kelelobmen kure kun-red Yidjib Egypt, King Ayrod Herod kabi-yawan nawu wurdyaw ka‑djare kabi-bun. Wanjh ngurri‑din kumekke kun-red kure Yidjib kaluk yawoyh‑marneyime ngudberre kumekke ngurri‑bolk‑bawon.” ");
INSERT INTO gupk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wanjh ku-kak rerrih Djodjib dolkkang wanjh birri-wam Yidjib, bu ben-kang wurdyaw, ngalbadjan. ");
INSERT INTO gupk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wanjh birrih-ni kure kun-red Yidjib kaluk bu rerrih wanjh King Ayrod doweng. Kune yimeng kure Kaworhnan Rowk bi-marneyimeng nawu na‑kare Yodjeya Hosea bu yimeng, 'Kaluk ngayi nga‑kayhme nawu beywurd ngardduk kure Yidjib‑beh'. ");
INSERT INTO gupk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bu Ayrod bengkang birrimekke bininj birri‑kang koyek birri-wurrhkeng, nungka wanjh ridduy. Wanjh ben-wok‑rayekwong nawu kabirrih‑durrkmirri nuye bu kabindi-ngalke nawu na-rahrangem rowk nawu bokenh man-djewk bedberre, mak nawu birri-yahwuyahwurd kure kun‑red Bedliyem Bethlehem mak darnkih kure kumekke kun-red, bu kabindi-bun rowk. Kune King Ayrod kurduyimeng, bengkang njale kun-dung bu wurdyaw danginj nawu koyek-beh bininj birri-wam kure Djerudjalem Jerusalem. ");
INSERT INTO gupk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wanjh woybukki danginj bu yimerranj kure nawu na-kare Djeremaya Jeremiah bimbom yimeng, ");
INSERT INTO gupk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","'Kure kun-red ngalengarre Ramah Ramah wanjh birri‑bekkang daluh-daluk birri-nalkiwam, birri‑njilng-warreni. Wanjh ngalekke ngalu Reydjel Rachel ben-marne‑nalkbom ngalengarre wurdurd, mak minj djareniwirrinj na-ngale bi‑njilngmarnbuyinj, birrimekke wurdwurd wanjh ngalengarre birri‑doweng.' ");
INSERT INTO gupk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kaluk bu King Ayrod doweng, nawu andjel nuye Kaworhnan Rowk bi-marne‑bebmeng Djodjib kure bukirri, kure birrih-ni kun-red Yidjib. ");
INSERT INTO gupk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Wanjh nawu andjel bi-marneyimeng, “Yi‑rrolka, yiben-ka ngal-badjan, wurdyaw. Ngurri‑durndeng kure kun-red ngalengarre Yidrayel Israel. Bininj nawu birri‑djareni birri‑buyinj nawu namekke wurdyaw bedda wanjh birri-doweng”. ");
INSERT INTO gupk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Wanjh Djodjib dolkkang ben-mey wurdyaw ngal-badjan wanjh birri-durndi kure kun-red Yidrayel. ");
INSERT INTO gupk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kaluk bu Djodjib bi-woh‑bekkang Arkelaya Archelius, nawu beywurd nuye King Ayrod, worhnah-worhnang kumekke kun-red kure kornkumo nuye worhnang kure kun-red ngalengarre Djudeya Judea. Wanjh Djodjib keleminj minj rayi kumekke niwirrinj. Kaluk kumekke andjel bi-bengdayhkeng Djodjib kure bukirri, nungka wanjh wam ku-bolk‑buyika kure ku-bolk‑kimuk ngalengarre kun-red Kalilee Galiee. ");
INSERT INTO gupk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kaluk kure kun-red ka-bolk‑ngeyyo Nadjared Nazareth, wanjh kumekke bedda birrih-ni. Wanjh kumekke birri-woybukwong manbu kun‑wok kure nawu birri-kare birri‑yingkih‑yolyolmeng nawu Jesus, “Nungka nawu Na-kang Nadjared”. ");
INSERT INTO gupk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bu Jesus mak nawu ben-bukkang nuye bininj birri-wam darnkih kure kunred Jerusalem, bedda wanjh birri-woh-di kure kunred Bedbadji Bethphage kure mandulum kabolk-ngeyyo Olives. Wanjh kumekke Jesus ben‑munkeweng bene-bokenh nuye bininj nawu ben-bukkang. ");
INSERT INTO gupk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kumekke wanjh ben-marneyimeng, “Ngune-ray kure kunrurrk‑wern, ngune-ngimen ba ngurrben-ngalke bokenh donkey kumekke kabene‑di ngalbadjan, yaw kabeneh‑dukkayindi. Wanjh ngurrben‑yerrkemen, ngurrben-ka kure ngayi. ");
INSERT INTO gupk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bu yiman nangale ngun-djawan ngurrewoneng bu njale-kenh ngurrbenh-kan nawu donkeys, wanjh ngurrben-marneyimen nawu Kaworhna ka-djare berrewoneng. Werrk ngundi-won. ");
INSERT INTO gupk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kune wanjh kurduyimerranj bu kunyungki kunwok kurrmeninj bu kamwam woybukki kure nakare Zechariah kure yimeng, ");
INSERT INTO gupk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ngurrben-marneyimen bininj kure kubolk-kimuk ‘Ngurri-na nawu Kaworhnan kamh-re kumekke kure ngudda. Nungka minj nabang, nungka nawu namak duninjh. Nungka kamh-re kam‑barndi kure ngalkerrnge donkey.” ");
INSERT INTO gupk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wanjh nawu bininj nuye ben-bukkang bene-wam bene‑kurduyimeng kure nungka Jesus ben-marneyimeng berrewoneng. ");
INSERT INTO gupk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wanjh bene-kang donkey yaw ngalengarre. Wanjh kumekke bene‑barrkbom berrewoneng kunmadj. Nungka Jesus djal‑barndi kure donkey. ");
INSERT INTO gupk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaluk birri-wern bininj birri-di bedda birri-madj-yerrkkerrinj nawu nakuyeng wanjh birri-kurrmeng kure manbolh. Nawu birri-buyika bininj birri-dulk-dadjdjeng birri-kang birri-kurrmeng kure manbolh. ");
INSERT INTO gupk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wanjh birri-wern bininj birri-dokmeng nuye Jesus. Nawu birri‑buyika, birri-munkekadjung birri-kayhmeng birri-yimeng, “Mah. Karri‑yimen Hosanna! God bene-djarrk-wam namekke bininj nawu Beywurd nuye David! Nungka kamh-re kure kunngey nuye nawu Kaworhnan Rowk. Namekke wanjh God kabi‑marne-kurduyimen kunmak. Karri-yimen Hosanna God nawu Kaddum kah-ni.” ");
INSERT INTO gupk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bu Jesus wam ngimeng kure kunred Jerusalem wanjh nawu bininj rowk kumekke birri-ni birri-kange-barrhmeng rowk, birri‑djawarrinj, “Nangale bininj kam-wam kadberre?” ");
INSERT INTO gupk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wanjh birri-wern bininj bindi-wokmey birri-yimeng, “Nane wanjh Jesus nawu kunwok kam-kan nuye Ngabbard, nakang Nazareth kure kubolk-kimuk ka‑bolk‑ngeyyo Galilee, nakang kumekke-beh kam-wam.” ");
INSERT INTO gupk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesus ben-karrmeng 12 djawirna. Nakudji namekke bininj nawu ngeyyoy Djudas Iskariod. Wanjh wam ben-yikang kure nawu birri‑kihkimuk djungkay kure birri-wokmarnburrinj. ");
INSERT INTO gupk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nungka ben-djawam kunwardde, bu ben-marneyimeng, “Njale kandi‑karremulewan bu Jesus bidkenwon ngudberre?” Bedda wanjh birri-wong kunwardde nawu 30 silver coins. ");
INSERT INTO gupk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wanjh bu rerre Judas dedjmey bolkyawam baleh keno bu Jesus kabirri‑mang nawu birriwarre bininj. ");
INSERT INTO gupk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mandjewk la mandjewk, Djus bininj birri-karrmeng mulil kunkamak ngeyyoy Manlod-berelhmiken Kandidjdjawa. Kunyungki benbekad kunkamak birri-karrmeng Passover mulil. Kunekke benbekad rerrih, djawirna nuye birrim-yikang Jesus, birri‑djawam, “Baleh yi-djare ngarri-marnbun ba manme karri‑ngun manbu Passover mulil?” ");
INSERT INTO gupk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wanjh Jesus yimeng, “Ngurri-ray kure kubolk-kimuk wanjh ngurri-nan namekke bininj, ngurri-marneyimen, ‘Nawu Kanbukkan ka-yime korroko wanjh darnkih kamh-re ka‑bolkyimerran nuye. Ka-djare Passover mulil ngarri‑ngun nuye djawirna kaluk kure nguddangke kurrambalk.” ");
INSERT INTO gupk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanjh djawirna nuye birri-wam, kure birri-yingkih-marnbom ngalengarre Passover mulil. ");
INSERT INTO gupk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kaluk bu ngokdanj, Jesus wanjh neyhneykendi kure balabbala ‘table’, birri-djarrk-nguneng nawu 12 djawirna. ");
INSERT INTO gupk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wanjh bu birrimekke birri-nguneng manme, Jesus ben‑marneyimeng, “Ngayi woybukki marneyime ngudberre: nakudji bininj ngudberre ngan-kukweykan kure birri-warre bininj.” ");
INSERT INTO gupk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bedda ben-njilng-warrewong nuye djawirna. Wanjh birri‑bebbeh-marneyimeng Jesus, “Nawu Yiworhnan, yiddok ngayi kukweykan ngudda?” ");
INSERT INTO gupk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus yimeng, “Nawu ngane-djarrk-bid-djuhme kure ngalanno wanjh namekke ngan-kukweykan.” ");
INSERT INTO gupk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kaluk ngan-marne-bolkyimerran ngayi nawu Bininj Duninjh kure ka-kurduyimerran ngardduk. Ngayi nga-rrowen. Wok‑kurmerrinj Ngabbard kunkare. Bininj ngan-kukweykang ngayi, kukwarrewong kure Ngabbard. Nungan Ngabbard kaluk kabi-kukmorrong namekke bininj bu munguyh munguyh. Kunukka kamakniwirrinj. ");
INSERT INTO gupk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Djudas korroko bengkan bu Jesus bi-marneyimeng. Wanjh yimeng, “Nawu Kanbukkang, yiddok ngayi kukweykan ngudda?” Wanjh Jesus yimeng, “Yoh. Makka nguddangke kunwok.” ");
INSERT INTO gupk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kaluk bu kumekke bedda birri-nguneng manme, wanjh Jesus lod-mey manbu kandidjdjawa wanjh bi-manjbom Kod. Rerre wanjh lod-bakkeng, wanjh ben-wong nuye djawirna wanjh ben‑marneyimeng, “Ngurri-ma mane kandidjdjawa, wanjh ngurri-ngu. Mane wanjh kundarrkid ngardduk.” ");
INSERT INTO gupk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wanjh ngalanno warridj mey, bi-yi-manjbom Kod, wanjh ben‑bowong nuye djawirna wanjh ben‑marneyimeng, “Ngurri‑wern ngurri-bongu mane. ");
INSERT INTO gupk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mane ngardduk kunkurlba manbu ka-menyime bu Kod wok‑kurrmerrinj bu mulewarrinj nungka ka-djare kaben‑bengmidjdan bininj. Mane kunkurlba ngardduk ka‑bowarrhme bedberre birri-djal-wern bininj ba bu Kod kaben-bengmidjdan bedberre kure kunwarre. ");
INSERT INTO gupk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kune wanjh bengdayhke ngudberre, ngayi minj nga‑yawoyh‑bongun mane barnem-no kunkalkid, kaluk karri‑yawoyh‑djarrk‑bongun bu rerrikah kumekke kure kubolk‑kimuk Ngabbard kah-ni nawu Kaworhnan Rowk ngardduk.” ");
INSERT INTO gupk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kaluk bu birri-wayini manbu yiwarrudj wanjh birri-wam kure mandulum kabolkngeyyo Olives. ");
INSERT INTO gupk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wanjh Jesus ben-marneyimeng djawirna nuye, “Bu bolkkime kukak ngudda kandi-bawon, ngurri-kelerlobme. Korroko Kod yimeng nawu: “Ngayi nga-bun nawu shepherd, nawu mayh sheep wanjh nakka kabirri-kelerlobme kure kubolk-buyika.” Kod wokkurmerrinj kure Nadjamun Djurra. ");
INSERT INTO gupk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kaluk bu rerre Kod ngan-dolkkayhwe kure kumidj. Kaluk nga‑yingkih-dokme ngudberre kure kunred Kalili. ");
INSERT INTO gupk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wanjh Bida (Peter) yimeng, “Bedda birriwern kabirri‑kelerlobme, ngayi minj nga-kelerlobme bu ngudda‑kenh.” ");
INSERT INTO gupk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kaluk Jesus bi-marneyimeng, “Nga-yime ke woybukki, Bu bolkkime kukak, ngudda wanjh kan-waral-kuk-wakwan bu bokenh kunkudji-kenh, bu rerre bawurl ka-kayhme.” ");
INSERT INTO gupk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wanjh Bida (Peter) yimeng, “Kunukka minj ngayi nga-yime bu waral-kuk-wakwan! Ngayi ngarr-djarrk-di kure baleh ngayi nga‑rrowen kure ngudda!” Mak nawu birriwern djawirna nuye nakka mak warridj kunekke rerrih birri-yimeng. ");
INSERT INTO gupk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wanjh Jesus birri-djarrk-wam nawu djawirna nuye ben‑bukkang kure kunred ka-bolk-ngeyyo Kedsemani (Gethsemene). Wanjh ben‑marneyimeng, “Kondanj ngurri-nin nga-re kuni. Nga-rri yiwarrudj.” ");
INSERT INTO gupk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesus ben-kang Bida (Peter) mak bene-bokenh nawu bebeywurd nuye Zebedi, nungka dedjmey bu njilng-warreminj mak kange‑warreminj. ");
INSERT INTO gupk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wanjh ben-marneyimeng, “Ngayi nga-njilng-warre kure kandji ngardduk kundurddu ka-djokkohme. Wanjh kondanj ngurri-nin, ngurri‑bolknahna bu ngayi ngam-durndeng.” ");
INSERT INTO gupk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kaluk bu wam kure minj djarreh-kah la darnkih, kumekke kukwerrinj kumirrk nuye kure kukurlk wanjh yiwarrudj di, wanjh yimeng, “Ngabba, wanjh kune kamak, wanjh yuwn kan‑bowon mane ngalanno kure nga‑bongun manbu kure nga‑djak‑bekkan-kenh. Wanjh bonj, nga-kurduyime kure ngudda yi-djare, minj kure ngayi nga‑djare.” ");
INSERT INTO gupk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wanjh Jesus durndi kure djawirna nuye, wanjh ben-nang birrih-kodjdjeyoy. Wanjh bi‑marneyimeng nawu Bida (Peter), “Ngudda minj karri‑djarrk‑worhnayinj bu kundjungbu? ");
INSERT INTO gupk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mak ngurri-bolk-nahna mak yiwarrudj ngurri-din ba kunukka kunngudj ngun-won ngudberre mak nawarre minj ngun‑djurrkkan ngudberre mak ngun-marnbun bu ngurri-yime kunwarre. Wanjh kunmalng ngudberre makka ka-djare kunmak ka-yime, mak kungudj kure kunburrk ngudberre makka manngudj-warre.” ");
INSERT INTO gupk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus durndi yawoyh-di yiwarrudj, yimeng, “Ngabba, minj nga-djare nga-djak-bekkan. Kure ngudda yi-djareni bu nga‑djak-bekkan, kune wanjh ngayeman nga-kurduyime kure ngudda yi-djareni ngardduk. ");
INSERT INTO gupk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wanjh yawoyh-durndi ben-nang birri-kodjdjeyoy, birri‑kodjdjewakwarrinj. ");
INSERT INTO gupk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wanjh Jesus durndi bokenh kunkudji-kenh di yiwarrudj, kunyawoyh-kudji yimeng mankare yerrih kunwok. ");
INSERT INTO gupk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wanjh Jesus yawoyh-durndi kure djawirna nuye kure birrih‑yoy, wanjh yimeng, “Yiddok ngudda ngurri‑djal‑kodjdje‑mulmurrngkarren mak ngurrih‑djal‑yo? Ngurri-na! Wanjh korroko kamh‑yimerran kamh-re darnkih nawu bininj ngan‑kuk‑weykang ngayi nawu Bininj Duninjh kure birriwarre bininj ngandi-mang. ");
INSERT INTO gupk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wanjh ngurri-dolkka, karri-re. Wanjh ngurri-na nane nawu bininj kamh-re nawu ngan-djarrwarraykang, ngan-kuk-weykan.” ");
INSERT INTO gupk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bu Jesus munguyh wokdi-wokdi wanjh Judas kam-wam nawu birri-djarrk-wam 12 kure Jesus nuye djawirna. Mak birri-wern bininj birrim-djarrk-wam nawu birrim-kang mandjawak mak kundulk. Nawu birrikihkimuk djungkay mak nawu dabborrabbolk nawu bindi-marne-worhnang bininj wanjh bindi-munkeweng. ");
INSERT INTO gupk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Korroko Judas karremarnbom bu ben-bengdayhkeng bu yimeng, “Wanjh bininj nawu nga-bunjhmang wanjh nakka Jesus nawu ngurri-mang.” ");
INSERT INTO gupk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kaluk kunekke rerrih Judas bi-yikang Jesus, bu yimeng, “Ngudda nawu kanh-bukkang! Kamak bu ngarr-keb-narren”. Rerre wanjh bi-bunjhmey. ");
INSERT INTO gupk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Wanjh Jesus yimeng, “Nawu ngarr-dabbolk, wanjh yi‑djal‑kurduyimen kure yim-wam-beh.” Wanjh birrimekke nawu birrim-yorrmeng birrim-wam birri-darrkid-mey Jesus. ");
INSERT INTO gupk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kaluk bu kumekke birri-mey Jesus, wanjh nakudji bininj nawu Jesus djawirna nuye yirrhmey nawu mandjawak nakimuk wanjh bi-kanem-dadjdjeng nawu bi-marne-durrkmirri nuye djungkay. ");
INSERT INTO gupk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wanjh Jesus bi-marneyimeng namekke nawu nuye djawirna, “Yi-bawo nawu mandjawak nakimuk. Yi‑kurrmen kure yi-mey. Nangale nawu ka-mang mandjawak, nakka wanjh mandjawak kaben-bun. ");
INSERT INTO gupk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngudda minj ngurri-bengkan bu nga-djare-niwirrinj nga‑djawayinj Ngabbard, wanjh ben-munkewemeninj birriwern angels nawu 12 djuram. ");
INSERT INTO gupk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wanjh bonj, nga-djare ka-kurduyimerran ngardduk kure Djurra Nadjamun ka-wok-bimdi ngardduk kure ngan‑yolyolmeng kunkare.” ");
INSERT INTO gupk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wanjh Jesus ben-marneyimeng birriwern nawu birri-kuniwam. Yimeng, “Ngudda kandi-kuniyikang mandjawak dorrengh mak kundulk dorrengh, yiman ngayi nabang rerre. Bu kunbenbekad‑kuyeng rowk, ngayi ngah-ni kure Temple kure kuberrk bu ngaben‑bukkang, minj ngudda kumekke kandi-mayinj. ");
INSERT INTO gupk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wanjh kuneng rowk kure baleh kurduyimerranj wanjh ka‑woybukkenwon kure birri-kare birri-bimbom kure korroko birrih-ni.” Kune bu Jesus yimeng. Wanjh djawirna nuye birri‑bawong, birri-kelerlobmeng. ");
INSERT INTO gupk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bu djarreh kam‑barrhbom, nawu birri‑kihkimuk djungkay mak nawu kabirri‑wohrnan dabborrabbolk birri‑wokmarnburrinj bu Jesus wanjh kabirri‑bun ka‑rrowen. ");
INSERT INTO gupk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kumekke birri‑dukkang wanjh birri‑kang kure worhnang nawu ka‑ngeyyo Baylad Pilate. Nungka nakang Rome. ");
INSERT INTO gupk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus wam kure kumirrk nuye Baylad nawu worhnang. Nungka bi‑djawam, “Yiddok ngudda yi-worhnan nawu bedberre Djuws Jews bininj?” Jesus bi‑marneyimeng, “Yoh. Makka nguddangke kunwok.” ");
INSERT INTO gupk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nawu birri‑kihkimuk djungkay mak dabborrabbolk birri‑djuhbom Jesus, nungka minj wokdiwirrinj. ");
INSERT INTO gupk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Wanjh Baylad bi‑marneyimeng Jesus, “Yiddok ngudda minj yi‑bengkan bu ngundih‑djuhbom kure njalehnjale‑kenh?” ");
INSERT INTO gupk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus minj ben‑wokmayinj bu yimeninj kure kunwern birri‑djuhbom. Wanjh Baylad yimeng, “Njalekenh minj yiben‑wokmang?” ");
INSERT INTO gupk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mandjewk la mandjewk bu birri-karrmeng mulil ngalengarre nawu worhnang wanjh bi-yerrkkeng na-kudji bininj bebmeng wam kure birri‑kaberrkdi bininj. Birri-wern bininj birri-kuknang nangale birri-mey. ");
INSERT INTO gupk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wanjh kumekke na-kudji bininj rurrkkendi, nawu ngeyyoy Barabbas. Kaluk namekke birri-wern birri‑bengkang na-warreni duninjh. ");
INSERT INTO gupk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bu bininj birri‑raworrinj kure Baylad wanjh nungka ben-djawam, yimeng, “Na-ngale ngurri‑djare nga‑bebke ngudberre, Barabbas? O Jesus nawu ka-ngeyyo ‘Christ’?” ");
INSERT INTO gupk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kaluk Baylad ben‑bengkang birrimekke bininj birri‑bidkenwong Jesus kure nungka bu bedda wanjh birri‑kirnweng. ");
INSERT INTO gupk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kaluk Baylad rerrkang kure ben‑djadmeng nuye kure ningih‑ni. Baylad nuye ngal‑bininjkobeng bi‑marne‑munkeweng kunwok, yimeng, “Yuwn baleh yi‑marneyime namekke bininj, yi-bawo. Nungka minj njale warrewoyinj. Bolkki ngayi nga‑bukirribom nungka. Wanjh ngan‑njilng-warreminj.” ");
INSERT INTO gupk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wanjh birri‑kihkimuk djungkay mak nawu dabborrabbolk bindi-marneyimeng birri-wern, “Ngurri-marneyimen Baylad, ‘Barabbas kam-bebme, Jesus dowimen.’”. ");
INSERT INTO gupk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kaluk Baylad yimeng, “Ngaben‑karrme bene‑bokenh: Barabbas, Jesus. Wanjh na-ngale ngurri‑djare nga‑bebke ngudberre?” Birri-wern birri‑yimeng, “Barabbas!” ");
INSERT INTO gupk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wanjh Baylad djawayhmeng, “Nane Jesus – baleh nga‑yimewon nawu ka‑ngeyyo ‘Christ’?” Wanjh bedda rowk birri‑yimeng, “Ngurri‑bid-dulubu kure kun-dulk cross!” ");
INSERT INTO gupk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Baylad yimeng, “Njale warrewong?” Wanjh bedda birri‑wernh-kayhmeng munguyh, “Ngurri‑bid-dulubu kure kun‑dulk ‘cross’!” ");
INSERT INTO gupk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Baylad ben‑nang minj baleh yimeninj. Bedda bininj wanjh birri‑ridduy. Wanjh nungka kunronj bomey bid-djirridjburrinj kure kumirrk bedberre bedda bininj. Ben-bukkang ba minj nangale bi-djuhbuyinj. Yimeng, “Nga-bid-bele. Ngayi minj kandi‑djuhbun bu nane bininj ka-rrowen. Ngudda ngurri‑djareni bu ngurri‑durrkmirri.” ");
INSERT INTO gupk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bedda birri‑yimeng, “Kan-djuhbun ngadberre - ngad mak wurdwurd ngadberre - bu nungka ka‑rrowen!” ");
INSERT INTO gupk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wanjh Baylad bi‑bebkeng Barabbas bedberre. Wanjh nawu Jesus ben-bidkenwong bininj nawu birri‑widjbirhkeng kunyarl dorrengh. Ben‑marneyimeng birri‑bang birri‑bid-dulubom kure kundulk. ");
INSERT INTO gupk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nawu Baylad nuye djawirna birri-ngimihweng Jesus kure bedberre kurrurk-kimuk, mak birri-wern nawu birri-bang birri‑raworrinj nuye. ");
INSERT INTO gupk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wanjh birri-yerrkkeng kun-madj nuye, mak na-buyika birri‑djongbom nawu yiman nawu worhnang nuye kun-madj djongburrinj, nawu kuk-buyika man-burrba. ");
INSERT INTO gupk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mak birri-bang birri-mey kinj man-mirrh-yih, wanjh birri‑marnbom kodj-burlh nawu kun-kodj-kenh, rerre wanjh birri‑marnekurrmeng kure kun-kodj nuye. Kunkaninj birri‑marne‑kurrmeng kure ku-bidkun nuye, yiman nawu ka-worhnan nuye. Wanjh birri-boddanj kure kumirrk nuye wanjh birri‑djekmiwong Jesus, wanjh birri-marneyimeng, “Ngundi‑burlumeng ngudda yi-worhnan bedberre bininj nawu Djuws!” ");
INSERT INTO gupk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mak birri-kuknunjbom. Birri-yimey manekke kunkaninj wanjh birrih-bom kure kunkodj nuye. Munguyh birri-djal-bom. ");
INSERT INTO gupk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bu bedda birri-ngurdmeng bu birrih‑bom, wanjh birri‑yerrkkeng nawu kukbuyika kun-madj djongbuh‑djongburrinj. Birri-djongbom nawu nuye kunmadj. Wanjh birri‑kang birri-wam kure birri-barnnameng nungka. ");
INSERT INTO gupk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kumekke wanjh birri-yi-bebmeng kure ku-berrk, kumekke birri‑nang na-kudji bininj nawu Sayrin-beh Cyrene nawu ngeyyoy Saymon Simon. Birri‑djurrkkang nungka ngorrkan kure kunkarlang nuye kun‑dulk ‘cross’ nuye Jesus. ");
INSERT INTO gupk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wanjh birri-bebmeng kure ka-bolkngeyyo Kolkoda Golgotha manbu ka-yime “Kun-red ngalengarre kun‑kodjmurrng”. ");
INSERT INTO gupk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Birrimekke birri-bang birri-bowong Jesus, birri-rawong kun‑bang mak birri-mey kure kun-dulk ngalengarre kun-kalkid birri-bo-wong ngudkeng nuye kun-kanjbabang. Wanjh Jesus bo‑bekkang manekke kun-bang wanjh nungka warnyakminj, minj bonguyinj, bekkang manbang. ");
INSERT INTO gupk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kaluk bu bedda birri-dulubom kure kun-dulk ‘cross’, wanjh birri‑madj-yerrkkeng, birri-dahkenweng. Nakudji nabang ben‑marneyimeng, “Ngudda yi-winhme ngurri-kang kunmadj nuye Jesus”. ");
INSERT INTO gupk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wanjh birrimekke birri-bang birri-rerrkang, birri-nahnang. ");
INSERT INTO gupk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kaddum kure kundulk birri-kurrmeng kunngey ngeyyoy, “Nane Jesus nawu worhnan bedberre bininj nawu Djuws”. ");
INSERT INTO gupk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mak bene-bokenh bininj nawu bene-bangni, wanjh bindi‑djarrk‑barnnameng Jesus dorrengh. Na-kudji kukbarndi kure ku-kun nuye Jesus. Na-buyika kukbarndi kure kudjakku nuye. ");
INSERT INTO gupk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bininj birri-wam birri-yurrhkeng, nakka kun-warre birri-yimeng nuye Jesus, mak birri-marnewarnyakminj nuye. ");
INSERT INTO gupk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Birri-marneyimeng, “Ngudda yi-yimeng bu yi-rurrk-bakke manbu Dembel Temple, kaluk yi-yawoyh-rurrkmarnbun kun‑kodjdje man‑kudji bokenh! Bolkki wanjh yi-rrolka! Yim-kolu kure ‘cross’ kun‑dulk bu ngudda woybukki Beywurd nuye Kod!” ");
INSERT INTO gupk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wanjh nawu birri-kihkimuk djungkay, mak nawu kabindi‑bukkabukkan man-karre, mak nawu dabborrabolk warridj birrih-duy Jesus. ");
INSERT INTO gupk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mak birri-marneyimerrinj, “Nungka ben-kukmarnbom birri‑buyika bininj mak minj ka-kukmarnburren nungan weleng‑kenh! Mak nungka wanjh ka-worhnan kadberre nawu Yidrayel Israel bininj! Wardi kam-kolu kure ‘cross’ kun-dulk ba karri-woybukwon! ");
INSERT INTO gupk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nungka kabi-woybukwon Kod mak bolkki wanjh Kod bi‑kukmarnbu, bu nungka kabi-marnedjare. Kone wanjh nungan welengken yimeng, ‘Ngayi Beywurd nuye Kod’.” ");
INSERT INTO gupk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kunekke rerrih mak bininj bene-bokenh bene-yimeng nawu bindi‑barnnameng Jesus dorrengh bu beneh-duy. ");
INSERT INTO gupk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kaluk bu benbekad buldjdjarn dung-yibmeng, wanjh kumekke ku‑bolkwern kak-bakmeng rowk, ben-karrmeng bokenh kun-kudji minj kun-kuyeng ben-karrmeninj. ");
INSERT INTO gupk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kaluk bu wolewoleminj bokenh kun-kudji kun-dung yimerranj, Jesus kayhmeng wernkih, bu yimeng, “Yilay! Yilay! Lama sabachthani?” (mane kunwok ka-yime, “Ngardduk Kod! Ngardduk Kod! Njale ngayi kan-bawong?”) ");
INSERT INTO gupk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kaluk birri-buyika bininj nawu kumekke birrih-di birri‑bekkang wanjh birri-yimeng, “Nakka kabih-kayhme Yilaydja Elijah!” ");
INSERT INTO gupk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wanjh na-kudji bininj rlobmeng wernkih mey nawu kun-madj na‑kerlkkerlk wanjh djuhkeng kure kunbang warreminj, wanjh dukkang kure kun-dulk kumekke wanjh bi‑bowoyinj bu Jesus bonguyinj. ");
INSERT INTO gupk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Birri-buyika bininj birri-yimeng, “Med, karri-bawo, wardi karri‑nan Yilaydja kam-re ba kabi-kukmarnbun.” ");
INSERT INTO gupk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wanjh Jesus kayhmeng kun-kimuk, yerre wanjh nungan baworrinj bu ngerh-yakminj, wanjh doweng. ");
INSERT INTO gupk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kunekke rerrih nawu man-burrba barndih-barndi kure Dempel Temple ku‑rurrk nakka wanjh djalkmiwam bu bakmeng bokenh, kaddum djalkmiwam kam-koluy kanjdji. Warridj bolk-rokang mak wardde‑barrabarrhmeng. ");
INSERT INTO gupk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mak nawu birrih-dudjendi kure ku-midj nakka wanjh dangmarrhmiwam bedberre, wanjh birriwern nawu Kod nuye bininj nawu kunyungki birri-doweng, nakka wanjh birri‑yawoyh‑kerrngehminj. ");
INSERT INTO gupk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kaluk bu Jesus yawoyh-kerrngehminj kure ku-midj wanjh bedmanwali birrimekke bininj birri-dolkkang kure kumidj-beh, birri-wam kure ku-bolkkimuk kubolk-djamun kure birri-wern bininj bindi‑nang. ");
INSERT INTO gupk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nawu birri-bang birri-nahnang Jesus kumekke birrih-di, mak nawu ‘centurion’ nawu kaworhnan bedberre dorrengh. Bu birri‑nang kun‑red bolkrokang mak njalehnjale nawu kurduyimeng, bedda wanjh birri-keleminj, wanjh birri-yimeng, “Woybukki duninjh nane bininj Beywurd nuye Kod”. ");
INSERT INTO gupk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Birri-wern daluk-daluk birri-munkekaydjuy Jesus kure Kalili Galilee mak birrih-nahnang, nakka mak birrimh-di djarreh kure ‘cross’ kundulk, wanjh birrih-nang. ");
INSERT INTO gupk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wanjh birri-djarrkni ngalekke Meri Makdalen Mary Magdalene, mak ngalu Meri ngal-badjan bedberre Jesus, Djayms James, Djosib Djoseph, mak ngalbuyika ngalu daluk ngalbadjan berrewoneng Djayms, Djon John nawu Zebedi Zebedee ben-bornang. ");
INSERT INTO gupk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bu Jesus ben-bukkabukkang, nakudji bininj kam‑dolkang nakang kunred Aramadiya Aramathea. Ngeyyoy Djosib Joseph. Nungka wanjh barndi. ");
INSERT INTO gupk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kaluk ngokdanj, Djosib wam bi-yikang Baylad Pilate, wanjh bi-djawam yimeng, “Kamak bu kan-kukwon Jesus.” Wanjh Baylad ben‑wokrayekwong nawu djamun nuye ba Jesus kabirri‑kukwon nawu Djodjib. ");
INSERT INTO gupk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wanjh nawu Djodjib bi-kukmey Jesus wanjh bi-kuk-dukkang nawu na-bele manburrba. ");
INSERT INTO gupk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wanjh bi-kuk-kang bi-kuk-kurrmeng kure kuwardde-rurrk. Manekke wanjh Djodjib nuye, man-kerrnge kure nungka wardde-dadjdjeng. Wanjh wardde-djirrkkang man‑wardde‑dulmuk kure dang-balhmeng kure dang-rurrk-ni wanjh bolk-bawon, wanjh nungka wam. ");
INSERT INTO gupk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kunekke rerrih Meri Makdalen, ngal-buyika Meri bene-wam bene-rerrkang kure kabbal borledmi-kenh. ");
INSERT INTO gupk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kunkodjdje-buyika manbu benbekad ngalengarre ‘Sabad’ ‘Sabbath’, wanjh nawu birri-kihkimuk djungkay mak nawu Barisis Pharisees birri-yikang Baylad. ");
INSERT INTO gupk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wanjh birri-marneyimeng, “Nawu yi-kimuk, ngad ngarri‑bengkan bu namekke Jesus nawu kurrih-kurrinj, bu darrkid-ni wanjh kune yimeng, ‘Bu kun-kodjdje bokenh man‑kudji rerre, ngayi wanjh nga‑yawoyh‑dolkkan kure kun‑dowikenh.’ ");
INSERT INTO gupk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","“Yiben-wokrayekwo birri-buyika birri-bang ba kabirri‑dang‑nahnan kure kunwardde‑rurrk bu ka-yimerran kun-kodjdje bokenh kun-kudji. Mak nawu djawirna nuye wardi kabirrim-re kabirri‑mang wanjh kabindi-marneyime birri-buyika bininj bu nungka dolkkang kure kun‑dowikenh. Jesus kurrinj bu kun-yungki bu kun-yungki bu mulewam nungka dolkkayinj. Wanjh kaluk bu nuye djawirna kabirri-mulewam nungka dolkkang, wanjh kabirri‑kurren kure kun-kimuk duninjh!” ");
INSERT INTO gupk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wanjh Pilate ben-marneyimeng, “Mah! Wanjh ngurrben-ka birri‑buyika birri-bang ba kabirri-wernh-dang-nahnang kure baleh ngudda ngurri-bengkan.” ");
INSERT INTO gupk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Birri-wam birri-dang-barlhmeng, birri-dang-rayekwong ba minj nangale ka‑rrangmarrhmang. Birri‑bang birri-di birri‑dang‑nahnang. ");
INSERT INTO gupk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bu benbekad ngalengarre Sabbad Sabbath bu yakminj, wanjh kunkudji bu kam-yimerranj Sunday bu djarreh kam‑barrhbom, wanjh Meri Makdelen mak ngal-buyika Meri bene-wam bene‑bolk‑nang kure ku‑midj kure kuwardde-rurrk. ");
INSERT INTO gupk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kaluk kunekke rerrih kunkimuk bolk-rokang. Andjel nuye nawu Kaworhnan Rowk kam-koluy kure kaddum-beh, wam kure kuwardde‑rurrk, wanjh wardde-djirrkkang manbu manwardde‑kimuk. Wanjh rerrkang kure kuwardde kaddum. ");
INSERT INTO gupk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kaluk nungka kuk-waydi yiman namarrkon kah-mayhke mak kun‑madj nuye djongbu-djongburrinj madj-beleminj yiman ka‑yime waydi kunngol. ");
INSERT INTO gupk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nawu birri-bang birri-dang-nahnang nakka wanjh birri‑keleminj bu birri-nang nawu andjel, mak birri-deldelmeng, mak birri‑kuk‑mankang yiman rerrih birri-doweng. ");
INSERT INTO gupk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wanjh andjel ben-marneyimeng daluk bokenh, “Yuwn ngune‑kele, ngayi nga-bengkan bu ngudda nguneh-yawan Jesus nawu birri‑kuk‑barnnameng kure kundulk cross. ");
INSERT INTO gupk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nungka minj kondanj ka-rri. Nungka Kod bi-rrolkkayhweng kure yimeng ngudberre. Ngunem-ray ngune-bolk-nan kure kundarrkid nuye birri-kurrmeng. ");
INSERT INTO gupk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Werrk ngune-durnde ngurrben-marneyimen nawu ben‑bukkabukkang nuye. Ngurrben-marneyimen, ‘Jesus yawoyh‑dolkkang kure kundowi‑ken. Nungka ka-rrokme ngun‑madbun ngudberre kure Kalili kaluk kumekke ngurri-nan.’ Mane kunwok ngurrben‑marneyimen. Ngayi ngam-wam marneyime ngurrewoneng.” ");
INSERT INTO gupk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kaluk nawu daluk bokenh werrk bene-bolk-bawong kumekke wanjh bene‑marrkinwam. Bedda bene-djurrkwong, mak bedda bene‑keleminj warridj. Bene-djareni bindi-marne-mulewayinj bininj nawu ben-bukkang nuye Jesus kure baleh yimeng. ");
INSERT INTO gupk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","KKumekke minj djarreh bene-rlobmeninj, kumekke bene‑darnh‑nang kumirrk Jesus. Ben‑ngeybom berrewoneng. Wanjh nawu daluk bokenh benem‑yikang darnkih bene‑marne‑bard‑durrungkulhdanj nuye bene‑denge‑karrmeng. ");
INSERT INTO gupk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesus ben-marneyimeng berrewoneng, “Minj ngune-kele. Ngune‑ray ngurrben-marneyimeng nawu ngayi ngarri-danginj kabirri‑re kure Kalili kaluk kumekke ngandi-nan. ");
INSERT INTO gupk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wanjh kumekke nawu daluk bokenh bindi-yikang bininj nawu ben‑bukkang nuye Jesus. Wanjh nawu birri-nang birri‑dang‑nahnang birri-wam kure kubolk-kimuk, mak bindi‑marne‑yolyolmeng nawu birri-kihkimuk djungkay kure baleh yimerranj bedberre. ");
INSERT INTO gupk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wanjh djungkay birri-kaberrk-raworrinj bininj nawu dabborrabbolk deleng, wanjh birri-karre-marnbom. Bu bedda birri-djareni nawu birri-bang birri-kurrinj. Bu bedda bindi‑karre‑mulewam nawu birri-bang nakimuk kunwardde. ");
INSERT INTO gupk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bindi-marneyimeng, “Ngurrben-marneyimen nawu bininj, bu bininj nawu Jesus ben-bukkabukkang birrim-wam kukak bu birri‑djirdmey kure ngudda ngurrih-kodjdjeyoy. ");
INSERT INTO gupk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bu ‘governor’ ngun-wobekkan ngudberre bu kuneng-ken, kaluk ngadman ngarri-wokdi, minj nun-djuhbun ngudberre. Yuwn ngurri-njilng-warre.” ");
INSERT INTO gupk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wanjh birri-bang birri-mey kunwardde. Birri-wam wanjh bindi‑marneyimeng kure birri-wern bininj, bindi-kurrinj. Wanjh birri‑wern bininj nawu Jews birri-bekkang manekke ka-kurren kunwok. Wanjh kumekke birri-wern bininj nawu Jews kabirri‑woybukwon munguyh manekke manu ka-kurren kunwok. ");
INSERT INTO gupk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nawu birrimekke 11 nawu ben-bukkabukkang nuye birri-wam kure Kalili wanjh birri-wam kure mandulum, kure Jesus ben‑marneyimeng wanjh kumekke birri-narren. ");
INSERT INTO gupk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wanjh kumekke bedda birri-nang Jesus, wanjh birri‑marne‑bard‑durrungkulhdanj nuye. Kaluk birri-buyika minj birri‑woybukwoyi bu nungka dolkkang. ");
INSERT INTO gupk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Wanjh Jesus kam-wam kure darnkih bedberre. Ben‑marneyimeng, “Nawu Ngabbard ngan-wong kunngudj nuye, nga-karrme kunngudj nuye. Nga-worhnan rowk kure kaddum kure kondanj kukurlk. ");
INSERT INTO gupk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wanjh ngurri-ray kure birri-warlah-ken bininj nawu birrim‑dolkkang kubolk-bubuyika kuwern. Mak ngurrben-bukka ba ngayi ngandi-kadjung. Ngurrben-kodjdjuhkemen kure kunngey Ngabbard, Beywurd, Nawaralmakkayken. ");
INSERT INTO gupk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngurrben-bukkabukka kuwern rowk kure marneyimeng ngudberre ba ngayi ngandi-wok-marrkmang. Woybukki ba karri-djarrk-re ngayi dorrengh munguyh mak kure ka‑yi‑ngurdme rowk. ");
INSERT INTO gupk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mane kunwok manmak. Kabi‑yolyolme Jesus Christ1, nawu beywurd nuye Kod. 1 “Christ” – mane kunngey kayime “Nawu Ngabbard Bi‑munkeweng” ");
INSERT INTO gupk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kune wanjh yingkih‑karremarnbom kure nakare Isaya Isaiah bimbom, bi‑wok‑mulewam bu kunyungki, bu yimeng, “Nungan Kod yimeng, “Kan‑bekka! Ngayi nga‑munkewe bininj nawu ngan‑marne‑wokdi ngayi ngardduk, ka‑yingkih‑bolh‑marnbun manbolh‑kenh. ");
INSERT INTO gupk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kure kubolk‑mudjmudj nane bininj kah‑kayhme kah‑yime, “Manbolh ngurri‑marnbu nuye nawu Kaworhnan Rowk! Karri‑marnbu manbolh mandjad nuye!” ");
INSERT INTO gupk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nungka Djon John ben‑kodj‑djuhkeng bininj, bebmeng kure kubolk‑mudjmudj, ben‑marne‑mulewam ben‑marneyimeng kure bininj birriwern, “Ngurri‑borledmen nuye nawu Kaworhnan. Ngurri‑bawo kunwarre, Kod ngun‑bengdubberranj ngudberre, bu ngurri‑kodj‑djuhmen. ");
INSERT INTO gupk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wanjh kure kunred ngalengarre Djerusalem Jerusalem mak kubolk‑warlah Djudeya Judea birriwern bininj birrim‑wam bu birri‑yikang Djon. Wanjh kumekke birri‑warnyak‑mulewarrinj kunwarre bedberre, Djon ben‑kodj‑djuhkeng kure mankabo Djordan Jordan. ");
INSERT INTO gupk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Djon djongburrinj kunmadj nawu marnbom kure kunmarre mayh nuye nawu kamel camel. Mak nawu kunngardmokenh kulahno mayh marnbom dukkarrinj, mak nguneng djaddedde mak mankung. ");
INSERT INTO gupk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Djon yolyolmeng bedberre yimeng mane kunwok, “Nakudji bininj kam‑re nawu wernh‑ngudj‑kimuk duninjh ngan‑yurrhke ngayi. Ngayi minj ngamak ba nga‑boddan nga‑rrenge‑yerrkke nawu kah‑denge‑djongburren nuye. ");
INSERT INTO gupk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngayi kodj‑djuhke ngudberre kure kunronj, nungka ngun‑kodj‑djuhke ngudberre kure Nawaralmakkaykenh.” ");
INSERT INTO gupk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wanjh kunekke rerrih Jesus bolk‑bawong Nazared kure Kalili wam kure Djon ningih‑ni, wanjh kumekke Djon bi‑djuhkeng Jesus kure mankabo kabo‑ngeyyo Djordan. ");
INSERT INTO gupk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus bidbom kure kuronj‑beh, worhnang kaddum nang dangmarrhmiwam, Nawaralmakkaykenh yiman marlum kamh‑koluy kure nungka dingih‑di. ");
INSERT INTO gupk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wanjh kam‑wokdi kure kaddum‑beh, yimeng, “Ngudda beywurd nardduk. Ngayi wanjh nga‑djurrkwon nguddangke.” ");
INSERT INTO gupk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kunekke rerrih Nawaralmakkaykenh bi‑kang Jesus kure bi‑munkeweng kubolk‑mudjmudj. ");
INSERT INTO gupk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kure kumekke kubolk‑mudjmudj Jesus ni kunkodjdje kunwern 40, kumekke birrih‑ni mayh nawu birribang. Kure kubolk‑mudjmudj ningih‑ni Jesus, Naderr Satan wanjh bi‑djurrk‑kang. Kumekke andjels birri‑marne‑bebmeng birri‑bidyikarrmeng Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wanjh bininj birri‑kang Djon kure kururrk birri‑dangbalhmeng. Wanjh Jesus wanahwam kure Kalili mulewam manmak kunwok nuye Ngabbard. ");
INSERT INTO gupk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wanjh ben‑marneyimeng, “Kune wanjh darnkih kah‑yimerranj kamh‑re Kod nawu Kaworhnan Rowk. Ngurri‑borledmen, ngurri‑bawo kunwarre, ngurri‑woybukwo manmak kunwok.” ");
INSERT INTO gupk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus wanah‑wam kure manwern mankabo‑kimuk kabo‑ngeyyo Kalili Galilee, wanjh woh‑nang ben‑nang Saymon, Andru Andrew nawu bene‑danginj. Beneh‑weng warrkaridj kure kubuldjdjarn, djenj beneh‑mey. Bedda bene‑durrkmirri bu beneh‑mey djenj. ");
INSERT INTO gupk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wanjh bu Jesus ben‑marneyimeng berrewoneng, “Ngunem‑ray ngayi kandi‑kaydju, bu bukkan ngurrewoneng ngurrben‑mang bininj.” ");
INSERT INTO gupk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wanjh kunekke rerrih Saymon, Andru bene‑bawong warrkaridj berrewoneng manbu djenj beneh‑mey wanjh bene‑munkekadjuy Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesus wanah‑wam minj djarreh‑niwirrinj ben‑yawoyh‑nang bene‑buyika bininj, bene‑ngeyyoy Djayms James, Djon John nawu bebeywurd nuye Zebedi Zebedee. Bedda kure bene‑barndi kabbala bene‑marnbom berrewoneng warrkaridj. ");
INSERT INTO gupk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mak kornkumo berrewoneng nawu Zebedi nawu birrih‑djarrk‑durrkmirri nuye kumekke birrih‑barndi kure kabbala bebeywurd nuye Zebedi. Kunekke rerrih Jesus ben‑kayhmeng benemekke nawu bene‑danginj, wanjh rerre bindi‑bawong birri‑buyika kornkumo dorrengh, wanjh bene‑munkekadjuy Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus birri‑wam nuye bininj kure kabolk‑ngeyyo Kabernayum Capernaum. Kunekke wanjh benbekad yimerranj Sabbad Sabbath, Jesus wam ngimeng kure kururrk kure yiwarrudj birri‑di Sinakok Synagogue, kumekke durrkmirri ben‑bukkang birrimekke bininj. ");
INSERT INTO gupk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Birri‑wern bininj birri‑kangebarrhmeng birri‑bekkang kunwok, ben‑bukkang kunmurrngrayek kunwok nuye Ngabbard, minj ka‑rohrok nawu bininj mankarre kure kabindi‑bukkan. ");
INSERT INTO gupk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kumekke Jesus ningih‑ni, nakudji bininj di kure kururrk yiwarrudj, nungka karrmeng nawarre. Wanjh namekke nawarre kayhmeng, yimeng, ");
INSERT INTO gupk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus kure Nadared‑beh Nazareth‑beh, yey! Ngudda njale yi‑djare? Yiddok ngudda yim‑wam kan‑bun ngadberre? Ngayi bengkan ngudda, ngudda Kod nuye yi‑kukdjamun.” ");
INSERT INTO gupk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wanjh Jesus bi‑marneyimeng bi‑wok‑rayek‑wong, “Yi‑ngurdmen. Yi‑bebmen, yi‑bawo nakkan bininj!” ");
INSERT INTO gupk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nawarre bi‑marnbom namekke bininj deldelmeng kunkimuk duninjh. Kumekke rerre nawarre bi‑kayhmeng wernkih, wanjh bebmeng, wam, bi‑bawong bininj. ");
INSERT INTO gupk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kaluk birriwern bininj birri‑nang birri‑kange‑barrhmeng. Wanjh birri‑djawarrinj bu birri‑marneyimerrinj, “Kaluk baleh kune kukyimerranj? Nane bininj kah‑yolyolme mankarre‑kerrnge, mak kah‑yolyolme yiman ka‑yime nawu ka‑worhnan duninjh. Nungka kaben‑marneyime nawu na‑warre kunwaral nawern, kaben‑kundjibun.” ");
INSERT INTO gupk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Manekke kunwok wernminj kure kubolk‑warlah Kalili Jesus nuye. ");
INSERT INTO gupk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus birri‑wam nuye bininj benemekke Djayms James, Djon John birri‑djarrk‑wam birri‑bolkbawong kururrk ngalengarre kure yiwarrudj birri‑di. Wanjh birri‑wam kure Saymon Simon, Andru Andrew berrewoneng kured. ");
INSERT INTO gupk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ngalu Saymon nuye ngal‑binjbalak yoy doweh‑doweng karrmeng kundjak. Wanjh bininj nawu kumekke birrih‑ni birri‑marneyimeng Jesus ngaleng‑kenh. ");
INSERT INTO gupk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wanjh Jesus bi‑yikang kure ngaleng yongohyoy. Wanjh bi‑bidkarrmeng bi‑rrolkkayhweng. Kumekke rerrih kundjak bi‑bawong, wanjh ngaleng makminj. Wanjh ngaleng wam kinjeng manme ben‑wong birri‑nguneng. ");
INSERT INTO gupk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bu ngokdanj‑ngokdanj mununminj, birri‑wern bininj bindim‑kang nawu kundjak birri‑karrmeng, bindim‑kang kure Jesus. Mak nawu wayarra birri‑karrmeng, nakka mak bindim‑kang kure Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wanjh kumekke kunred kure birrih‑ni birri‑kaberrk‑raworrinj birrih‑ni kure kurrambalk kure kururrk. ");
INSERT INTO gupk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wanjh kumekke Jesus ben‑marnbom birri‑wern nawu mankukbuyika kundjak birri‑karrmeng. Mak ben‑bebkeng wayarra nawu birrikukbuyika bindi‑karrmeng birri‑wern. Kaluk wayarra birrikuk‑bengkang Jesus, wanjh kunekke‑kenh Jesus ben‑ngurdkeng birrimekke wayarra. ");
INSERT INTO gupk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bu kunkodjdje‑buyika kamh‑kabelni, Jesus dolkkang kukak rerrih, wanjh bolk‑bawong kure yongohyoy. Wam bolk‑ngalkeng kure minj bininj birri‑niwirrinj, wanjh yiwarrudj di. ");
INSERT INTO gupk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wanjh rerre, Saymon bedda birri‑wam birri‑yawam Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kaluk bu birri‑ngalkeng wanjh birri‑marneyimeng, “Birri‑wern bininj ngundih‑yawan!” ");
INSERT INTO gupk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wanjh Jesus yimeng, “Ngad wanjh karri‑re kubolk‑bubuyika. Karri‑re darnkih kure ka‑rurrk‑kaberrkdi ba nga‑yolyolme bedberre bininj. Kunekke‑kenh ngam‑wam.” ");
INSERT INTO gupk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wanjh birri‑djarrk‑wam kure ku‑yaw‑bolkkimuk kunred ngalengarre Kalili. Nungka yolyolmeng kure kunrurrk nuye yiwarrudj‑kenh, nungka ben‑bebkeng bedberre nawu nawarre birri‑karrmeng. ");
INSERT INTO gupk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nakudji bininj kundjak karrmeng. Kaluk kulah‑mokni, wanjh bim‑yikang Jesus, kam‑wam bard‑durrungkulhdanj, wanjh bi‑marne‑kongiburrinj Jesus bu yimeng, “Nga‑djare kan‑marnbu kan‑djirridjbu. Nga‑bengkan ngudda yi‑karrme kunngudj.” ");
INSERT INTO gupk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wanjh Jesus bi‑kongibom namekke bininj. Bid‑yirriyoy Jesus, bi‑karrmeng bu yimeng, “Ngayi nga‑djare marnbun. Wanjh yi‑makmen.” ");
INSERT INTO gupk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wanjh kun‑djal‑kudji rerrih manekke kundjak bi‑bawong namekke bininj, wanjh kulah‑makminj. ");
INSERT INTO gupk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wanjh Jesus bi‑marneyimeng namekke bininj bu ka‑re werrk, wanjh bi‑wok‑rayek‑wong bi‑marneyimeng, ");
INSERT INTO gupk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Minj nangale yi‑marne‑mulewan bu kune nga‑rrurrkmirri ke. Yi‑djalay yingan kure djungkay yi‑kuk‑bukkarren. Kod Ngabbard bi‑wong Moses kure mankarre. Kaben‑bukkan bininj kure ngayi belewo.” ");
INSERT INTO gupk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wanjh bonj, namekke bininj bolk‑bawong kumekke, wanjh wam. Ben‑marne‑yolyolmeng birri‑wern bininj bu Jesus bi‑marnbom. Jesus minj rayinj kure birri‑kaberrkdi. Wanjh djalwah‑djalwam kure kunred minj nangale niwirrinj. Birri‑wern bininj birri‑yorrmeng birri‑kang kubolk‑bubuyika birri‑bebmeng kure nungka ningih‑ni. ");
INSERT INTO gupk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kaluk kunkodje bokenh, wanjh Jesus bolk‑bawong kure Galilee. Kam‑durndi kure kunred Kabernayum Capernaum. Birriwern bininj birri‑wobekkang bu kam‑durndi kure kunred nuye kumekke ningihni. ");
INSERT INTO gupk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Birri‑marnebebmeng kure nungka, wanjh kumekke birriwern bininj bindi‑djokkohmeng kure kurrangmaye darnkih. Jesus ben‑marne‑yolyolmeng bedberre nuye kunwok. ");
INSERT INTO gupk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Birribuyika bininj birrim‑bebmeng, birrim‑kang nakudji bininj nawu nabirl. Kunbid‑kudji‑bakmeng (4) bininj birrim‑ngorrkang birrim‑wam madj‑dorrengh kure nungka yongohyoy. ");
INSERT INTO gupk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bedda minj baleh birri‑bolk‑ngalkemeninj ba birri‑yi‑ngimeninj kure nungka Jesus, birriwern bininj birri‑kaberrkdi nuye birri‑djokkohmeng. Kumekke bedda birri‑bidbom kure kaddum kukodj. Birri‑yerrkkeng birri‑dangmarrhme kaddum kure Jesus dingihdi kure kanjdji, wanjh kumekke birri‑koluyhweng namekke nawu nabirl kunmadj dorrengh. ");
INSERT INTO gupk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus ben‑nang bedberre birri‑wernh‑woybukwong, wanjh nungka bi‑marneyimeng nawu nabirl, “Djakerr, wanjh kunwarre nguddangke yakminj rowk. Ngayi bengmidjdan.” ");
INSERT INTO gupk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bininj nawu mankarre bindi‑bukkabukkang, birrih‑ni kumekke. Bedda yiman birrih‑djawarrinj bedda birri‑bengkarrinj: ");
INSERT INTO gupk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Njale! Njale‑kenh nane bininj ka‑yime kunwarre? Nungka ka‑wokdi kunwarre kure Kod nuye. Minj nangale bininj ka‑bengmidjdan kunwarre, nadjalkudji Kod ka‑bengmidjdan kunwarre.” ");
INSERT INTO gupk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kunekke rerrih Jesus bengkang kure nungan kunmalng nuye kure birri‑yolyolmeng bedman. Nungka ben‑marneyimeng: “Njale‑kenh ngudda ngurrih‑djawarren kure kukange ngudberre? ");
INSERT INTO gupk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kamak ngayi nga‑benmidjdan nane nawu nabirl nuye kunwarre. Ngudda minj ngurri-bengmidjdan kunwarre. Mak kamak nungka nga‑bard‑marnbun warridj. Minj yi-bard-marnbun nane bininj.” ");
INSERT INTO gupk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Nga‑djare ngudda ngurri‑bengkan: ngayi nawu Bininj Duninjh. Kod ngan‑wong kunngudj bu ngayi nga‑bularrbun bininj bedberre kunwarre kondanj kure kukurlk.” Kunekke‑kenh Jesus bi‑marneyimeng namekke nawu nabirl, ");
INSERT INTO gupk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngayi marneyime, yi‑rrolkka, yi‑madj-ma, wanjh yi‑rrokmen kured!” ");
INSERT INTO gupk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kunekke rerrih nungka dolkkang, madj-mey, wanjh dokmeng. Birriwern birri‑nang Jesus bi‑marne‑kurduyimeng. Birri‑kange‑barrhmeng, wanjh birri‑burlumeng Kod Ngabbard. Birrih‑marneyimeng, “Nawu ngad karri‑nang kunbuyika duninjh bolkkime. Minj karri‑bengkayinj!” ");
INSERT INTO gupk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kaluk bolk‑bawong kumekke, yawoyh‑wam kure mankarndan kure mankabo‑warlah. Birri‑kaberrkwern bininj birri‑wam kure nungka. Wanjh Jesus dedjmey ben‑bukkang. ");
INSERT INTO gupk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kaluk Jesus wanahwam bi‑nang Levi, nawu beywurd nuye Alfeyus. Nungka ningihni kure kururrk ngalengarre tax kabirri‑karremulewan. Worhnan nawu tax. Wanjh Jesus bi‑marneyimeng, “Kan‑munkekadju, ngarr‑re!” Wanjh Levi dolkkang bi‑munkemey Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kaluk bu rerrih, Jesus nawu nuye djawirna birri‑nguneng manme kure Levi nuye kurrambalk. Nawu birriwern bininj nawu tax birrih‑mey, birrim-wam bu birri‑djarrk-nguneng manme. Mak birribuyika birriwarre bininj birrim‑wam, birri‑djarrk‑nguneng. Bedda birri‑kaberrk-wern bininj birriwarre birri‑munkekadjuy Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pharisees nawu mankarre birri‑bengkang bindi‑walenang Jesus birri‑djarrk‑nguneng manme nawu birriwarre bininj mak nawu tax kabirrih‑mang warridj. Wanjh bindi‑djawam Jesus nawu djawirna nuye bu birri‑yimeng, “Njale‑kenh Jesus kabirrih‑djarrk‑ngun mak kabirrih‑djarrk‑bongun birrimekke nawu tax kunwardde kabirri‑mang mak nawu birriwarre bininj?” ");
INSERT INTO gupk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bu Jesus ben‑bekkang, wanjh yimeng bedberre, “Kone wanjh ngurri‑bengkan‑‑ bininj nawu ka‑bekkarren bu kamak rowk, wanjh minj ka‑djare doctor. Bininj nawu kah‑dulkkihyo, nakka wanjh ka‑djare doctor. Mah, kune ngayi minj ngam‑rayinj bu ngaben‑kayhmeninj bininj nawu birrimak, ngaleng ngam‑wam ngaben‑kayhme bininj nawu birriwarre.” ");
INSERT INTO gupk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kaluk Djon nuye djawirna, nawu ben‑bukkabukkang, bedda minj birri-djareniwirrinj birri‑nguyinj manme bu kundedjumbung, birri‑di yiwarrudj. Mak warridj bininj nawu Pharisees. Wanjh birribuyika bininj birri‑wam kure Jesus wanjh birri‑djawam, “Djon nuye bininj mak nawu Pharisees bindi‑bukkang wanjh birri‑bawong manme bu birri‑di yiwarrudj. Bu njale‑kenh bininj nawu ngudda yiben‑bukkang minj birri‑bawoyinj manme bu kunekke‑kenh?” ");
INSERT INTO gupk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wanjh Jesus yimeng bedberre, “Bu mulil kabirri‑marnbun bu yiman bininj daluk kabene‑marren, wanjh nawu djawirna nuye nawu kaliyi, wanjh bedda minj kabirri‑bawoyinj manme bu nungka kabirrih‑djarrk‑ni, kayakki.” ");
INSERT INTO gupk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wanjh kaluk rerrih bu namekke nawu kaliyi kabirri‑mang, wanjh bedda kabirri‑bawon manme.” ");
INSERT INTO gupk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wanjh Jesus yimeng, “Minj nangale ka‑rradje manburrba kure namadj‑kerrnge ka‑name‑kenh kure madjkare. Wardi bu kunekke ka‑yime bininj, wanjh nawu nakerrnge ka‑kuk‑warremen nawu nakare, wanjh minj kabene‑madj‑rohrok. Wanjh bu ka‑madj‑warremen rowk. ");
INSERT INTO gupk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Minj nangale ka‑borrahkendong manu manbanem kalkid‑no manbo‑kerrnge kure nakare ngalanno. Wardi bu kumekke ka‑yime bininj, wanjh manbu manbo‑kerrnge ka‑rradjme namekke ngalanno, wanjh ka‑bo‑warrawarrhme, mak manbu ngalanno manwarre. Wanjh manbu wine kalkidno manbo‑kerrnge, bininj kabirri‑borrahkendong kure nakerrnge ngalanno. Wanjh namekke namak nawu ka-kimukminj.” ");
INSERT INTO gupk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kaluk bu kunkangbakmeng manbu Sabbad Sabbath, Jesus mak nuye bininj birrih‑djarrk‑wam kure dalk‑kaberrkdi manbu karrmeng manme. Wanjh nawu ben‑bukkang bedda wanjh birri‑dalkdurrkmey. ");
INSERT INTO gupk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wanjh nawu Pharisees birri‑marneyimeng Jesus, “Yi‑na! Njale‑kenh kune kabirri‑kurduyime bu kabirrih‑bakke manbu mankarre Sabbad ngalengarre? Ngadberre mankarre minj nangale ka‑bakke.” ");
INSERT INTO gupk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus ben‑wokmey yimeng, “Deybid bakkeng manekke mankarre kure bininj birri‑marrwedoweng. Ngudda yiman ngurri‑bimnayinj kure Kod nuye kunwok kure ka‑wok‑bimdi bu kune Deybid kurduyimeng bu nungka bininj nuye birri‑bekkang birri‑marrwedoweng? ");
INSERT INTO gupk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wanjh nungka ngimeng kure Kod nuye kunrurrk, kure djungkay nakimuk ningihni nawu Abiathar. Nawu Deybid lodmey lodno manbu mandjamun kumekke yoy. Wanjh nungka nguneng manekke lodno, mak ben‑wong bedberre nawu birrih‑djarrk‑wam. Manu mankarre kah‑yo manekke lodno ngalengarre bu minj nangale ka‑ngun, bedman djungkaywi kabirri‑ngun.” ");
INSERT INTO gupk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kumekke wanjh ben‑marneyimeng, “Karri-durrkmirri karri-re wanjh kure Sabbad karri-ngerhme, karri-di yiwarrudj. Kod marnbom manbu Sabbad mankarre wanjh kan‑wong kadberre bu kan‑bidyikarrmeng kure ngad bininj. ");
INSERT INTO gupk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wanjh ngayi nawu Bininj Duninjh nga‑worhnan kure Sabbad.” ");
INSERT INTO gupk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kaluk Jesus yawoyh‑ngimeng kure kunrurrk yiwarrudj dingihdi. Nakudji bininj ni kumekke, nawu kunbid nuye bidwelebmeng. ");
INSERT INTO gupk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wanjh birribuyika bininj birrih‑ni nawu birri‑djareni birri‑djuhbom Jesus, bedda wanjh birri‑djal‑kuknang Jesus bu kabi‑marnbun namekke bininj bu ka‑bakke bedberre mankarre manbu Sabbath, wanjh Jesus kabirri‑djadme. ");
INSERT INTO gupk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wanjh Jesus bi‑marneyimeng namekke bininj nawu bidwarre, yimeng, “Yi‑rrolkka, yi‑rri kondanj kure kubuldjdjarn bedberre ba ngundi‑nan birri‑neh bininj.” ");
INSERT INTO gupk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wanjh Jesus ben‑djawam nawu birrih‑kurdunang, ben‑marneyimeng, “Ngayi djawan ngudberre, baleh ka‑karreyime Sabbath ngalengarre bu kunbenbekad djamun? Baleh nga-yime? Manmak nga-kurduyime o manwarre? Bu nga-marnbun nane bininj o nga-bun?” Wanjh birrimekke bininj minj birri‑wokdiwirrinj. ");
INSERT INTO gupk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wanjh Jesus ben‑nang, ben‑duy rowk. Nungka njilng‑warreminj bedberre ben‑kange‑bengkang bu bedda wanjh birri‑kange‑rayekminj. Wanjh Jesus bi‑marneyimeng bininj nawu bidwarre, “Yi‑bid‑yirriyun.” Wanjh nungka bid‑yirriyoy, wanjh bid‑yimerranj yiman kunyungki bidyih‑yibidyimeng, bid‑makminj. ");
INSERT INTO gupk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wanjh bininj nawu Pharisees birri‑bolk‑bawong, birri‑bebmeng, wanjh kunekke rerrih birri‑mayali‑bekkarrinj, Herod nuye bininj dorrengh, nawu birri‑djarrk‑karremarnbom bu birri‑buyinj Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kaluk Jesus nuye dajwirna nawu ben‑bukkang birri‑bolk‑bawong, birri‑wam kure mankabo‑warlah darnkih. Birri‑kaberrk‑wern bininj nawu birri‑kang Kalili bindi‑munkekadjuy. ");
INSERT INTO gupk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Wanjh birri‑kaberrk‑raworrinj bininj nawu birri‑kang Djudeya‑beh, bu bindi‑munkekadjuy mak bininj nawu birri‑kang Djerusalem, mak bininj nawu birri‑kang kunred ka‑bolk‑ngeyyo Yidumeya, mak bininj nawu birrim‑wam kure Djordan kure ngalengarre darnkih kunred, mak bininj nawu birri‑kang Tayer‑beh mak Sidon‑beh birrim‑wam. Bedda wanjh birri‑wobekkang Jesus kure kurduyimeng, wanjh birri‑moken‑raworrinj kure nungka. ");
INSERT INTO gupk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kunekke‑kenh bu Jesus ben‑marneyimeng nuye djawirna bu kabirri‑marnekurrme mankudji manyahwurd kabbala nuye, bu birri‑wern bininj birri‑kaberrkdi, birri‑kuk‑djirrkarrinj. ");
INSERT INTO gupk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kaluk birriwern nawu birri‑dulkkihyoy, wanjh birri‑djareni bu birri‑karrmeninj Jesus ba ben‑marnbuyinj. Birri‑bengkang bu nungka ben‑marnbuninj birriwern. ");
INSERT INTO gupk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mak kunwaral‑kunwarre rowk bu birri‑nang Jesus, wanjh birri‑bebbeh‑mankang kure kumirrk nuye Jesus wanjh birri‑bebbeh‑kayhmeng bu birri‑yimeng, “Ngudda nawu Kod nuye Beywurd!” ");
INSERT INTO gupk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wanjh Jesus ben‑wok‑rayekwong nawu kunwaral kunwarre rowk, kunrayek duninjh. Ben‑marneyimeng “Yun kandi‑mulewan.” ");
INSERT INTO gupk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kaluk Jesus wam bidbom kure mandulum, wanjh ben‑kayhmeng birri‑buyika bininj nawu nungka ben‑marne‑djareni. Wanjh birri‑wam kure nungka Jesus dingihdi. ");
INSERT INTO gupk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wanjh Jesus ben‑rohrokmeng birrimekke nawu 12 bininj nawu ben‑ngey‑kurrmeng 'apostles' bu kure kaben‑munkewe. Nungka ben‑marnedjareni bedberre bu birri‑djarrk-wam birri‑yikarrmeng kure ben‑munkeweng bedberre birri‑mulewam kunwok nuye Ngabbard kure bindi‑marne‑yolyolmeng bininj. ");
INSERT INTO gupk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kaluk kaben‑won kunngudj bu kabindi‑burriwe nawu wayarra nawern kabirri‑karrme. ");
INSERT INTO gupk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wanjh ben‑kurrmeng birrimekke nawu 12 nuye bininj. Bedda wanjh birri‑ngeyyoy Saymon nawu Jesus bi‑ngeykurrmeng Bida (Peter), ");
INSERT INTO gupk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mak Djayms nawu beywurd nuye Zebedi, mak Djon nawu Djayms bene‑danginj. Nane bokenh bininj Jesus ben‑ngeybom berrewoneng Boanerkes. Nane kunngey ka‑yime “Ka‑ngurdulme.” ");
INSERT INTO gupk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Mak birribuyika birri‑ngeyyoy Andru, Filip, Bardolomu, Mediyu, Tomas mak Djayms nawu beywurd nuye Alfayus, mak Thadayus mak Saymon nawu ben‑widnang birri‑kang Rome, ");
INSERT INTO gupk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mak nawu Djudas Iskariot, nawu kaluk kabi‑kukweykan Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wanjh Jesus ngimeng kure kunrurrk, birriwern bininj birri‑kaberrk‑raworrinj nuye kure kumekke kunred, wanjh nungka bininj nuye minj birri‑nguyinj manme, bindi‑dangdjangnang. ");
INSERT INTO gupk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wanjh bininj nawu namud nuye Jesus, wanjh birri‑marne‑bengwarreni wanjh birri‑wam bu birri‑mayinj nungka birri‑marneyimerrinj, “Nungka wanjh bengwarrminj!” ");
INSERT INTO gupk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Birribuyika nawu bindi‑bukkang mankarre birrim‑wam, birrim‑koluy kure Djerusalem‑beh, wanjh bedda birri‑yimeng, “Ngurri‑bekka: nane Jesus ka‑karrme nawarre wayarra ka‑ngeyyo Belzebul Narderr, nawu ka‑worhnan. Namekke kabi‑won kunngudj wanjh kaben‑marne‑bebke nawu kaben‑karrme wayarra!” ");
INSERT INTO gupk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wanjh Jesus ben‑kayhmeng birrim‑marne‑wam kure darnkih, wanjh dedjmey bu yolyolmeng parables bedberre, warlkayindi kunwok. Wanjh yimeng, “Wayarra minj ka‑burriweng nungan, larrk. ");
INSERT INTO gupk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kayakki. Ngurri‑bengkan ngudman deleng bu bininj nawu kabirri‑djarrkyo kure kubolk‑kudji, bu kabirri‑burren wanjh kabirri‑kuk‑yakworren, mak kabirri‑bolkwarrewon! ");
INSERT INTO gupk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wanjh nakudji namud bedberre bu birrimekke bininj kabirri‑burren, wanjh kabirri‑yakworren, wanjh bedberre nawu birrimud wanjh kabirri‑yalarrme. ");
INSERT INTO gupk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kumekke wanjh marneyime bu nawu wayarra duninj Satan kaben‑burren wayarra deleng, wanjh bonj, minj kabirri‑di, wanjh bolkkime kabirri‑yakmen. ");
INSERT INTO gupk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wanjh kandi‑bekka, mak ngurri‑bengkan manbuyika. Bu nangale ka‑djare ka‑ngimen kure bininj nawu kurduwern kurrambalk nuye bu yiman ka‑djirdmang nuye njalehnjale, wanjh nakka kabi‑dukkarrukkan werrk namekke nawu kurduwern bininj. Wanjh kabi‑marnedjirdmang njale kure kurrambalk nuye. ");
INSERT INTO gupk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Wanjh marneyime kunwoybuk ngudberre, baleh yerrkka bu kunwarre ngurri‑kurduyime mak baleh yerrkka kure ngurri‑yime kunwarre nuye Kod, wanjh nakka Kod ngun‑bengmidjdan ngudberre. ");
INSERT INTO gupk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nangale bininj kabi‑marne‑wirrihmerren nawu Nawaralmakkaykenh, wanjh nakka Kod minj kabi‑bengmidjdan nuye kure kunwarre bu munguyh munguyh.” ");
INSERT INTO gupk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus kunekke yimeng bu koneng, bedda birri‑yimeng, “Nungka ka‑karrme nawarre kunwaral.” ");
INSERT INTO gupk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kunekke‑kenh wanjh birri‑marne‑bebmeng Jesus nuye ngalbadjan mak nawu birri‑danginj. Birri‑di kure kuberrk wanjh birri‑marne‑wok‑munkewerrinj nuye Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Birri‑kaberrkwern bininj birri‑djarrk‑di nungka dorrengh Jesus, wanjh birri‑marneyimeng, “Yi‑na! Ngalbadjan ke mak nawu ngurri‑danginj kabirrih‑ni kuberrk ngundi‑yawan ngudda.” ");
INSERT INTO gupk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus ben‑wokmey, yimeng, “Ngalngale ngardduk ngalbadjan mak nawu ngarri‑danginj?” ");
INSERT INTO gupk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wanjh nungka ben‑nang bininj nawu birri‑borledminguneng mak birri‑djarrk‑rerrkang nungka dorrengh, wanjh yimeng bedberre, “Ngurri‑narrimen rowk! Ngudda yiman ngayi ngardduk ngalbabadjan nawu karri‑danginj! ");
INSERT INTO gupk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nangale nawu kabi‑wok‑marrkmang kure Kod nuye kunwok, wanjh nakka ngayi ngarri‑danginj nawu bininj, daluk, mak ngayi ngardduk ngalbabadjan kure kabirri‑wok‑marrkmang Ngabbard.” ");
INSERT INTO gupk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kaluk Jesus wanjh wanahwam kure mankabo‑warlah ngalengarre mankarndan wanjh kumekke yawoyh‑dedjmey bu ben‑bukkabukkang. Wanjh birri‑kaberrkwern bininj birri‑borledminguneng, wanjh nungka bidbom kure kabbala, wanjh rerrkang, wanjh nawu bininj ben‑bawong birrimh‑di kure mankarndan. ");
INSERT INTO gupk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kumekke wanjh Jesus ben‑marne‑yolyolmeng bedberre manwern kunwok kure benh‑bukkang manbu parables, warlkayindi kunwok. Bu ben‑marne‑yolyolmeng bedberre, wanjh yimeng, ");
INSERT INTO gupk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kandi‑bekka! Nakudji bininj wam kure kabbal mim‑burriweng. ");
INSERT INTO gupk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Manbuyika mim‑burriweng, manyika mim warrawarrhmeng kure manbolh, wanjh kikkik birrim‑kaberrk‑wam, birri‑nguneng rowk, birri‑yakwong. ");
INSERT INTO gupk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mak manyika mim‑warrawarrhmeng kure kuwarddeh‑wardde, kure kukurlk minj manwern yuwirrinj. Wanjh manekke manmim djordminj werrk, mak kukurlk minj manwern yuwirrinj bu diwirrinj djordmeninj. ");
INSERT INTO gupk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kaluk bu dungbebmeng manekke kolhde‑no kolhde‑ruy wanjh darlehminj, kaluk kunekke‑kenh minj wernh‑dedjmadrayinj kure bolk‑dulubuyinj. ");
INSERT INTO gupk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mak manbuyika manmim warrawarrhmeng kure mandjabudjabul manu mankonyi. Kaluk bene‑djarrk‑djordminj, wanjh manbu mandjabudjabul manu mankonyi bi‑djokkohmeng, minj barnem‑no karrmeninj. ");
INSERT INTO gupk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kaluk manbuyika manbu mimno, wanjh mim‑warrawarrhmeng kure mankulkmak. Wanjh birri‑djordminj wanjh birri‑marnburrinj manme manwern. Manbuyika wernminj bu marnburrinj 30, mak manbuyika wanjh marnburrinj 60, mak manbuyika marnburrinj mandjalwern bu marnburrinj 100.” ");
INSERT INTO gupk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wanjh Jesus yawoyh‑wokdi, yimeng, “Bu ngudda ngurri‑karrme kunkanem, wanjh kandi‑wernh‑bekka.” ");
INSERT INTO gupk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wanjh bininj birriwern birri‑bawong Jesus. Birrih‑ni nuye nawu djawirna mak birribuyika bininj. Wanjh bedda birri‑djawam manbu warlkkayindi kunwok. ");
INSERT INTO gupk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wanjh kumekke ben‑marneyimeng, “Ngudda wanjh Kod ka‑djare ngun‑bukkabukkang ngudberre yehyeng rowk nawu ka‑warlkkarren kure nungka‑kenh nawu Kaworhnan Rowk. Nawu birribuyika bininj, minj birri-wernh-bekkayinj manwoybuk kunwok kure nga-mulewam parables. ");
INSERT INTO gupk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“Bu kabirri‑nan kure kuberrk wanjh minj kabirri‑nan kure kanjdji duninjh. Kabirri‑bekkan kunwok wanjh minj kabirri‑wernh‑bengkan. Bu kabirri‑wernh‑bengkan, wanjh kunukka kabirri‑kange‑borledmen ba bu Kod kaben‑bengmidjdan bedberre kure kunwarre. Ngayi minj nga-marnedjare birri-wernh-bekkan. Kunekke-kenh ngayi nga-warlkan kunwok.” (Isaya 6:9‑10) ");
INSERT INTO gupk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wanjh Jesus ben‑yawoyh‑marneyimeng, “Yiddok minj ngudda ngurri‑wernh‑wokbekkan manu kunwok manbu parable? Baleh ngurri‑yime? Bu kayakki, wanjh yiddok ngurri‑wernh‑bekkan manbubuyika manbu manwern parables? Wanjh kandi‑bekka: ");
INSERT INTO gupk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bininj nawu manmim ka‑mim‑we, wanjh yiman ka‑we kunwok manmak. ");
INSERT INTO gupk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kaluk mim‑no manbu mim‑warrawarrhmeng kure manbolh, wanjh kaben‑yolyolme bininj nawu kabirri‑bekkan kunwok, wanjh nawu Satan Wayarra kam‑re werrk, ka‑mang, ka‑kan kunwok kure kukange‑beh bedberre, kure warrhmeng bedberre. ");
INSERT INTO gupk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wanjh bu ka‑rohrok mim‑no manbu ka‑warrawarrhme kure kuwarddeh‑wardde, makka wanjh yiman bininj nawu kabirri‑bekkan kunwok, wanjh werrk kabirri‑wok‑marrkmang bu kunnjilng‑mak dorrengh. ");
INSERT INTO gupk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kaluk bedda yiman rerrih mim‑no manbu minj wernh-dedjmad-rayinj, kabirri‑woybukwon bu kundedjdjumbung. Bu kunrid kaben‑marne‑bebme mak bu kabindi‑dung bininj nawu kabirri‑warnyak kure Kod nuye kunwok, wanjh kunekke rerrih bedda kabirri‑bawon bu kabirri‑mankan. ");
INSERT INTO gupk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mak mim‑no manbu warrawarrhmeng kure mandjabudjabul manbu manmirrhyi, makka yiman bininj nawu kabirri‑bekkan kunwok, ");
INSERT INTO gupk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kaluk bu njalehnjale kam‑bebme wanjh kan-njilng-warrewon, kunwok manmak kabirri-bawon. Bedda minj kabirri‑karrme barnem‑no. ");
INSERT INTO gupk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wanjh mim‑no manbu warrawarrhmeng kure mankulkmak, wanjh kaben‑yolyolme bininj nawu kabirri‑bekkan kunwok kure bulkkidj kabirri‑karrme kukange bedberre, kabirri‑wok‑marrkmang, wanjh bedda yiman kolhde‑no manbu kah‑wernmen yiman ka‑yime mim‑no mandjalwern bu ka‑marnburren 100 mak manbuyika wanjh marnburrinj 60, mak manbuyika marnburrinj 30.” Manekke wanjh Jesus yolyolmeng. ");
INSERT INTO gupk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus ben‑yawoyh‑marneyimeng bedberre, “Minj nangale kam‑kan lamp kure kururrk bu ka‑kurrme kanjdji kure ngalan‑no, mak ka‑kurrme kanjdji kure balahbala. Kayakki! Nawu ka‑wurlhke lamp, wanjh ka‑barnname kaddum bu ka‑bolkwayalhme. ");
INSERT INTO gupk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ka‑rohrok rowk bu marneyime, yehyeng rowk nawu bolkkime minj kabirri‑nan kure ka‑warlkkayindi, wanjh bu rerre kam‑bebme kure kabbal ba bininj kabirri‑nan. ");
INSERT INTO gupk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bu ngudda ngurri‑karrme kunkanem, wanjh kandi‑wernhbekka!” ");
INSERT INTO gupk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesus ben‑yawoyh‑marneyimeng bedberre, “Ngurri‑nahnarrimen ba bu ngurri‑wernkaremenmenbekkan kure kandi‑bekkan. Bu ngudda yiben-won birribuyika bininj, wanjh Kod nunganwali ngun-won bu ka-rohrok. ");
INSERT INTO gupk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bu ngudda yi-karrme njalehnjale, Kod ngun-won manwern. Bu ngudda minj njalehnjale yi-karrme, wanjh Kod Ngabbard ngun-kaybun.” ");
INSERT INTO gupk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus ben‑yawoyh‑marneyimeng bedberre bininj, “Kure Kod ka‑wohrnan rowk nuye bininj wanjh yiman ka‑yime manmim. Bininj ka‑burriwe manekke mimno kure kukurlk, wanjh makka manmak. ");
INSERT INTO gupk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wanjh kunkak kam‑re, bu bininj ka‑kodjeyo, wanjh bu kam‑kabelwe kumurrng, wanjh bininj ka‑rrolkkan, kaluk bu manbu manmim ngalengman ka‑kolhdemarnburren wanjh ka‑djordmihwerren. Wanjh nane bininj nawu mimweng, minj bengkayinj bu baleh marnburrinj. ");
INSERT INTO gupk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kure kunkurlk ka‑marnbun manme manwern bu ngalengman ka‑marnburren ka‑kolhde‑bebme manyahwurd ka‑bebme, wanjh kumekke ka‑kimukmen, wanjh ka‑karrme manme manwern kure barnem‑no. ");
INSERT INTO gupk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wanjh manme kah‑djolengmen, wanjh ka‑re nawu bininj ka‑nan manbarnem manwern, ka‑rradadje ka‑kurrmekurrme. Wanjh kunekke ka‑yimerran kure Kod ka-worhnan Rowk. ");
INSERT INTO gupk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wanjh Jesus yawoyhyimeng bedberre, “Bu bukkabukkan ngudberre, ngadjare marnemulewan ngudberre yiman ka‑yime bim ba bu ngurri‑menmenbekkan kure baleh ka-yime Kod Kaworhnan Rowk. Mah, nabuyika parable nga‑mulewan: ");
INSERT INTO gupk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wanjh kone marneyime ngudberre, Kod nawu ka‑wohrnan rowk, namud nuye yiman ka‑yime mim‑no manyah-yahwurd duninjh, yiman manbornde manmim. Bininj nawu ka‑dudjeng manmim yawurd. ");
INSERT INTO gupk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bu wanjh ka‑wernh-djordmen, ka‑yimerran kundulk mankimuk minj ka‑rohrok kure mandulk-buyika kundulk, wanjh ka‑karrme manyende mankihkimuk, wanjh kikkik kabirrim‑re kabirri‑marnbun kunred kure kundulk ngalengarre mandjurlemak. ");
INSERT INTO gupk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus munguyh ben‑marneyolyolmeng birriwern bininj manbu kunwok ka‑warlkarren parables. Birribuyika birri-bekkang manyahwurd, birribuyika nawu bininj birri-wernh-bekkang manwern. ");
INSERT INTO gupk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ben‑marne‑mulewam parables kure kabbal birriwern bininj birri‑ni. Kaluk birri‑durndi kure bedman birrih‑ni nuye bininj, yolyolmeng bedberre manu ka‑warlkarren bu nungka ben‑bengdayhkeng nuye bininj bu mandjad God nuye kunwok. ");
INSERT INTO gupk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kumekke bu ngokdanj, Jesus yimeng bedberre nawu ben‑bukkang nuye, “Mah. Wanj karri‑djowkke kure‑beh.” ");
INSERT INTO gupk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kumekke bindi‑bawong bininj nawu birri‑kaberrkwern. Jesus korroko bidbom kure kabbala, wanjh nuye bininj birri‑djarrk‑bidbom, wanjh birri‑wam. Birribuyika bininj bindi‑munkekadjuy manbuyika kabbala. ");
INSERT INTO gupk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kumekke wanjh kunkurra mankimuk ben‑marne‑bebmeng bedberre, kunronj bo‑ngimen kure kabbala wanjh ben‑djuhkeng bedberre. Kaluk manbu kabbala wanjh bo‑barlmeng, darnkih wanjh birri‑yibmeninj. ");
INSERT INTO gupk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus kodjeyoy kure kabbala. Wanjh nuye nawu ben‑bukkang birri‑djurlhmeng birri‑marneyimeng, “Nawu kan‑bukkan! Yiddok minj kan‑bidyikarrme ngadberre, wardi karri‑ngakme!” ");
INSERT INTO gupk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wanjh Jesus dolkkang, bidwayhmeng duy kunkurra, kunronj ben‑marne‑wokdi, “Ngune‑ngurdmen ngune‑djal‑din!” Wanjh kumekke bene‑ngurdmeng rowk, minj njale mak rokayi. ");
INSERT INTO gupk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nungka ben‑marneyimeng nuye bininj, “Njale-kenh ngurri‑kele? Minj ngudda ngayi kandi‑woybukwon.” ");
INSERT INTO gupk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bedda wanjh birri‑djal-keleminj duninjh, mak birri‑mayahmeng. Birri‑marneyimerrinj, “Njale! Baleh nane bininj bene-wok-marrkmey kunkurra, munronj?” ");
INSERT INTO gupk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kumekke wanjh birri‑bolkmey borledmikeng kure manbo‑kimuk kure kunred bedberre nawu Kerasen bininj. ");
INSERT INTO gupk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Kumekke nakudji bininj nawu ningihni kure birrimidj‑dudjendi, kuwardde‑rurrk‑wern. Mak malng‑no birri‑kaberrk‑malng‑di birri‑karrmeng namekke bininj. Wanjh namekke bininj ni munguyh kure kunred manbu midj‑dudjendi. Kaluk nungka ni kunkak‑kuyeng, kunbenbekad‑kuyeng kure kumidj kuwern, kure mak kurrulu‑dulum kaddum. Wanjh nungka munguyh kayhmen. Nungka njilng‑burrinj kunwardde dorrengh burri‑burrinj. Birri‑dukkang birri‑berl‑rawong kunbid kure kunmad nuye, wanjh nungka bakkeng rowk. Minj nangale bininj bi‑ngurdkemeninj. Bedda birri‑moken‑dukkang birri‑rayekwong birri‑karrmeng bu birri‑dirrbkeng wanjh kumekke yerrkkeng bu bebmeng wam. Nungka wanjh murrng‑rayekminj. Bu nungka Jesus koluy kure kabbala‑beh, wanjh namekke bininj bi‑nang Jesus djarreh‑beh. Bi‑marne‑rlobmeng darnkih, bi‑marne‑mankan kure kumirrk nuye Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesus bi‑wok‑rayekwong, “Ngudda nawu yi‑waral‑warre duninjh, yim‑bebmen wanjh yi‑bawo namekke bininj!” Nawu bininj wanjh wernkih wokdin, yimeng, “Njale‑kenh ngudda yim‑wam, wardi kanh‑warrewon, ngudda Jesus nawu Beywurd nuye Kod nawu Ka‑wern‑worhnan Duninjh? Ngudda yi‑wok‑kurrmerrimen kure Kod bu ngudda minj kan‑marnbun bu nga‑djak‑bekkan.” ");
INSERT INTO gupk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wanjh Jesus bi‑djawam, “Ngudda nangale yi‑ngeyyo?” Wanjh bi‑wokmey, yimeng, “Ngayi ngarri‑ngeyyo Djuram, mak ngarri‑djal‑wern.” ");
INSERT INTO gupk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wanjh nane nawern namalng‑warre duninjh birri‑wernh‑djawam Jesus bu minj ben‑munkewemeninj kure djarreh kubolk‑buyika. ");
INSERT INTO gupk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kaluk kumekke kunred bikbik birriwern birri‑kaberrk‑di birri‑dalk‑nguneng kure mandulum. ");
INSERT INTO gupk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nawu birri‑malng‑warre duninjh birri‑wernh‑djawam Jesus, birri‑marneyimeng, “Med, kan‑bawo kan‑mungkewemen kure bikbik ba bu ngarrben‑marne‑ngimeng.” ");
INSERT INTO gupk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus wanjh ben‑djal‑bawong bu birri‑bebmeng birri‑wam, wanjh bindi‑marne‑ngimeng nawu bikbik. Wanjh birriwern bik birri‑kaberrk‑rlobmeng, birri‑mankang kure kungarlk‑warrewarre, birri‑ngakmeng kure kuro‑ronj. Kaluk bikbik nawu birri‑djal‑wern nawu 2 thousand. ");
INSERT INTO gupk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Birribuyika bininj nawu bindi‑nahnang bikbik birri‑nang bu baleh yimerranj bedberre wanjh bedda birri‑kele‑rlobmeng rowk. Bindi‑marne‑mulewam bedberre nawu kumekke kubolk‑kimuk birrih‑ni, mak nawu birrih‑ni kumekke kure kabbal. Wanjh birri‑djal‑wern bininj birri‑wam bu birri‑nang kure kurduyimeng Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Birrimekke bininj birrim‑wam kure Jesus. Bindi‑nang berrewoneng Jesus la bininj nawu bi‑marnbom. Nungka ni kure Jesus nuye kurrenge, kaluk djongbuyindi kunmadj, bengmakminj. Wanjh bedda birri‑keleminj. ");
INSERT INTO gupk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bininj nawu birri‑darrkid‑nang Jesus bi‑marne‑kurduyimeng namekke bininj, mak baleh kurduyimerranj nawu bikbik bedberre, wanjh bindi‑marne‑mulewam bininj bedberre nawu birri‑bebmeng. ");
INSERT INTO gupk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wanjh birriwern birri‑djawam Jesus bu kabolk‑bawon kubolk‑kimuk bedberre. ");
INSERT INTO gupk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wanjh Jesus bidbom kure kabbala. Nane bininj nawu birrimalng‑warre birri‑bawong bih‑djawam Jesus, nungka djareni bene‑djarrk‑rayinj. ");
INSERT INTO gupk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kaluk Jesus bi‑rrabkeng, wanjh bi‑marneyimeng, “Yi‑rrurnde kured ke, Yiben‑marneyimen bininj nguddangke, bu baleh kunmak Nawu Kaworhnan ngun‑marne‑kurduyimeng bu nungka ngun‑kuk‑kongibom.” ");
INSERT INTO gupk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wanjh nawu bininj wam, ben‑marne‑yolyolmeng bininj rowk nawu birrih‑ni kure kubolk‑wern ngalengarre kunred kabolk‑ngeyyo Dekapolis. Ben‑marne‑yolyolmeng bu baleh kun‑wernh‑mak Jesus bi‑marne‑kurduyimeng. Wanjh birriwern bininj rowk birri‑marne‑kange‑barrhmeng duninjh. ");
INSERT INTO gupk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kaluk Jesus yawoyh‑djowkkeng mankabo‑kimuk bu bolkmey borledmikeng. Nungka dingihdi kure darnkih marnkarndan, wanjh birri‑marne‑kaberrk‑di nuye. ");
INSERT INTO gupk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kaluk nakudji bininj bi‑marne‑bebmeng. Nungka ngeyyoy Djayrus. Nungka worhnang kure kunrurrk kure yiwarrudj‑kenh. Bu nungka bi‑nang Jesus, wanjh bi‑marne‑mankang kure kurrenge nuye. ");
INSERT INTO gupk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mak bi‑wernh‑djawam Jesus, yimeng, “Ngayi ngardduk ngalbeywurd ngalyahwurd kundjak kunkimuk ka‑karrme. Darnkih ka‑rrowen! Yim‑ray ba yi‑bidkurrmerren ngalengarre ba ka‑makmen mak ka‑rrarrkidmen!” ");
INSERT INTO gupk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wanjh Jesus bene‑djarrk‑wam Jairus. Mak birri‑djal‑wern birri‑munkekadjuy mak birri‑djokkohmeng Jesus nuye. ");
INSERT INTO gupk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wanjh ngalkudji daluk di, ngalu kurlbah‑kurlbawam munguyh bu mandjewk la mandjewk (12 years). ");
INSERT INTO gupk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ngaleng wanjh wam kure birriwern doctors. Ben‑kuk‑wong nawern kunwardde (money), mak kuk‑yakwong rowk, wanjh bonj. Bedda minj birri‑marnbuyinj. Ngalengman kuk‑bekkarrinj bu minj makmeninj, wanjh ngalengman njilng‑warrewarreminj. ");
INSERT INTO gupk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kaluk bi‑wobekkang Jesus, wanjh ngaleng kam‑wam kure kubodme nuye Jesus kure birri‑kaberrk‑wern bininj, wanjh bi‑djal‑woh‑karrmeng nawu manburrba nakuyeng nuye Jesus djongbu‑djongburrinj. ");
INSERT INTO gupk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ngaleng bengka‑bengkang, yimeng, “Nga‑karrme nuye kunmadj, nga‑djal‑makmen.” ");
INSERT INTO gupk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wanjh kundjalkudji rerrih bi‑marne‑ngurdmeng ngalengarre kure kurlbah‑kurlbawam. Wanjh kuk‑bekkarrinj kure kanjdji kukange ngalengarre kure djak‑ngurdme ngalengarre. ");
INSERT INTO gupk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wanjh Jesus warridj kunekke rerrih bekkarrinj bu kunngudj nuye bebmeng, wanjh borledmeng, yimeng bedberre nawu birri‑kaberrk‑di, “Njale! Nangale nawu ngan‑madj‑karrmeng?” ");
INSERT INTO gupk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanjh nawu nuye bininj birri‑yimeng, “Ay? Yiben‑kaberrk‑na nawu ngundi‑djokkohme! Njale‑kenh yi‑yimeng, 'Nangale ngan‑karrmeng?'” ");
INSERT INTO gupk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus bolk‑nang bu bolk‑yawam nangale kure bi‑madj‑karrmeng. ");
INSERT INTO gupk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wanjh ngalekke daluk, bu bekkarrinj bi‑marne‑kurduyimerranj, ngaleng kuk‑deldelmeng mak bi‑marne‑keleminj, bu bi‑marne‑mankang kure kundenge nuye Jesus. Wanjh bi‑marne‑mulewarrinj kure kunwoybuk. ");
INSERT INTO gupk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wanjh Jesus bi‑marneyimeng, “Ngal‑korlonj, ngudda wanjh kan‑woybukwong, wanjh bu ngudda yi‑makminj. Mah, yi‑ray kunmak dorreng, bu yi‑maknin rowk kure kundjak yi‑karrmeng. ");
INSERT INTO gupk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bu Jesus wokdi, wanjh bininj birrim‑bebmeng nawu birrih‑ni kure kurrambalk nuye Jairus nawu worhna‑worhnang kunrurrk manbu yiwarrudj ngalengarre. Wanjh birri‑marneyimeng Jairus, “Ngalu ngalbeywurd ke, wanjh bonj, korroko doweng. Wanjh yi‑djal‑bawo Jesus, yuwn bu munguyh yi‑djurrkkan nawu kan‑bukkabukkan.” ");
INSERT INTO gupk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus ben‑wokbawong kure birri‑marneyimeng Jairus, Jesus bi‑marneyimeng, “Yuwn yi‑kele. Kan‑djal‑woybukwo.” ");
INSERT INTO gupk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wanjh ben‑kang Bida, Djayms mak Djon nawu Djayms bene‑danginj. Ben‑denghkeng nawu birrimekke bininj, wanjh bedda bindi‑bawong, birri‑wam. ");
INSERT INTO gupk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bu birri‑bebmeng kurrambalk nuye Jairus, wanjh Jesus ben‑bekkang bininj nawu kumekke birrih‑ni birri‑njilngwarreminj, birri‑nalkbom mak birri‑kayhmeng wernkih duninjh. ");
INSERT INTO gupk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wanjh Jesus ngimeng kure kururrk, wanjh ben‑marneyimeng, “Njale‑kenh ngurri‑njilng‑warreworren, mak ngurri‑nalkbun? Ngale wurdyaw minj dowimeninj, ngaleng ka‑djal‑kodjdjeyo.” ");
INSERT INTO gupk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wanjh bedda birri‑kuk‑djekmiwong. Jesus ben‑bebkeng rowk kure kuberrk, ben‑djal‑kang ngalengarre kornkumo, ngalbadjan la nawu nuye bininj. Wanjh birri‑ngimeng kunrurrk kure ngalekke wurdyaw yongohyoy. ");
INSERT INTO gupk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wanjh bi‑bid‑karrmeng, wanjh bi‑marneyimeng, “Talitha koum!” Mane kunwok ka‑yime, “Wurdyaw, yi‑rrolkka!” ");
INSERT INTO gupk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wanjh ngaleng dolkkang kundjalkudji rerrih wanahwam kundenge ngalengarre. Ngaleng mandjewk ngalegarre‑ni, wanjh 12 bu yimerranj. Wanjh kunekke rerrih birri‑kange‑barrhmeng rowk. ");
INSERT INTO gupk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wanjh Jesus ben‑wok‑rayekwong duninjh bu minj nangale bininj kabi‑wok‑mulewan kure birriwern kabirri‑wobekkan. Wanjh ben‑marneyimeng bu kabirri‑won ngalekke wurdyaw manme bu ka‑ngun. ");
INSERT INTO gupk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wanjh Jesus bolk-bawong kumeke wanjh kam-wam kure kunred nuye. Kaluk nawu ben-bukkabukkang nuye birri-djarrk-wam nungka dorreng. ");
INSERT INTO gupk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bu benbekad manbu Sabad, wanjh dedjmey benh-bukkabukkang kure kunrurrk manbu yiwarrudj-kenh. Wanjh birriwern nawu birri-bekkang birri-kange-barrhmeng mak birri-marneyimerrinj, “Baleh-beh nane bininj kah-mang kunwok manbu karri-bekkan? Nangale bi-mayali-wong bu yimanek ka-wernh-bengkan rowk? Mak baleh-beh kundulkarre bu kah-kurduyime kubid nuye kunwernhmak duninj? ");
INSERT INTO gupk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bu nungka nakka wanjh carpenter kadberre! Nungka wanjh ngalbadjan ngalka Mary, mak nawu birri-danginj James, Joses, Judah, mak Simon. Mak nawu ngaldahdaluk nuye nakka karrih-ni!” Wanjh bedda birri-marne-kodjdayhmeng nuye. ");
INSERT INTO gupk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wanjh Jesus ben-marneyimeng, “Kandi-bekka. Nangale bininj nawu prophet, nakka wanjh bininj kabirri-kayhme kure kubolkwern. Kure nungan nuye kunred, nakka kabirri-dung, minj kabirri-kayhme nawu nuye namud kure mak nawu kabirri-djarrk-ni!” ");
INSERT INTO gupk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wanjh nungka minj mak durrkmirriwirrinj manbu kundulkarre dorreng. Ben-djal-karrmeng kubid nuye yikahwi nawu birri-dulkkihni bu ben-marnbom kumekke kunred. Djal bonj. ");
INSERT INTO gupk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kaluk Jesus kange-barrhmeng bu bedda minj birri-woybukwoyinj kumeke kure Nazareth. Wanjh nungka wanahwam kudjalbolkwern kure kubolk-bubuyika bu benh-bukkang. ");
INSERT INTO gupk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wanjh Jesus ben-kayhmeng nuye 12 djawirna, nawu ben-wong kundulkarre ba kabirri-we kunwaral nawarrewarre bedberre nawu kabirrih-karrme. Ben-munkeweng bu birri-wam bokenh-bokenh. ");
INSERT INTO gupk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kaluk Jesus ben-bengdayhkeng, yimeng, “Yun njale ngurri-kan kure ngurri-re. Ngurri-djal-ka kunkarndudj, minj njale mak ngurri-kan. Yun ngurri-lod-kan manbu buriddi, mak baladji, yun mak ngurri-kukkan nawu kunwardde kure ngurri-ngardmodukkayindi. ");
INSERT INTO gupk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mah, ngurri-dengedjongburrimen kundenge-ken, yun mak ngurri-madj-kan bokenh nawu ngurri-djongburren-keng.” ");
INSERT INTO gupk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mak ben-marneyimeng, “Bu ngurri-bebme kure kunred, wanjh bu ngurri-ngalke bininj nawu ngun-kayhme kure kunrurrk nuye ngurri-ngimen, kumekke manrurrk-kudjiwi ngurri-djal-yun, mak bu ngurri-bolk-bawon. ");
INSERT INTO gupk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bu ngurri-bebme kure kunred, kure bedda nawu kabirrih-ni kumekke minj nangale ngun-kayhme bu minj ngundi-bekkan, wanjh bu kumekke kunred ngurri-bolk-bawon, wanjh ngurri-denge-djulng-werrimen ba kundjulng ngalengarre kumekke kunred ngun-denge-bawon. Kumekke ngurri-kurduyimen ba ngurrben-marne-mulewan bininj bu kunwoybuk dorreng.” ");
INSERT INTO gupk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wanjh 12 nawu ben-bukkabukkang nuye birri-wam bindi-marne-yolyolmeng bu bindi-marneyimeng, “Ngurri-warnyak-mulewarrimen!” ");
INSERT INTO gupk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wanjh bedda bindi-kuk-burriweng nawern wayarra nawu bininj birri-karrmeng kure mak bindi-marnbom birriwern nawu birri-dulkkihni bu bindi-djal-kodjdjuhkeng manbu oil kunkalkkid dorreng. ");
INSERT INTO gupk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kaluk bu Herod nawu king-ni, nungka wobekkang rowk bu baleh Jesus kurduh-kurduyimeng kundulkarre dorreng, birriwern bininj birri-ngey-bengkang Jesus. Birribuyika birri-yimeng Djon yawoyh-darrkidminj kure kumidj-beh, kumekke-ken kure nungka kah-karrme kundulkarre kure ka-kurduyime kunwern. ");
INSERT INTO gupk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Birribuyika mak birri-yimeng, “Jesus nungka wanjh Elijah!” Mak birri-badbuyika birri-yimeng bu nungka wanjh prophet yiman ka-yime nawu korroko birri-wok-mulewam God. ");
INSERT INTO gupk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wanjh Herod bi-wobekkang Jesus, nungan yimeng, “Nungka nawu Djon yawoyh-darrkidminj, nawu ngardduk bininj birri-komdadjkeng!” ");
INSERT INTO gupk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kaluk bu kunyungki Herod nungan wanjh ben-munkeweng bininj bu birri-mey Djon bu birri-dukkang wanjh birri-dang-balhmeng rurrkendi kure prison. Herod kunekke kurduyimeng bu ngaleke-ken daluk Herodias, ngalu ngalbininjkobeng nuye-ni Filip, nawu Herod benedanginj. Herod bi-mey Herodias wanjh bene-marrinj. ");
INSERT INTO gupk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kaluk Djon bih-marneyimeng Herod, “Kunuka minj kunmak bu yi-mey ngalu ngalbininjkobeng nuye nawu ngune-danginj, bu yi-karrebakkeng.” ");
INSERT INTO gupk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kuneke-ken ngalu Herodias bi-rruy Djon, bu djareni birri-buyinj. Kayakki, minj Herod bi-marne-kurduyimeninj. ");
INSERT INTO gupk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Wanjh Herod bi-marne-keleminj Djon bi-nahnang bu yimeng Djon nungka wanjh namak bu Kod nuye bininj. Kaluk Herod bi-bekkang Djon bu wokdi, wanjh kodj-mayahmeng duninjh. Wanjh bonj, djal-djareni bi-bekkayinj munguyh. ");
INSERT INTO gupk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wanjh kam-wam ngalengarre benbekad bu Djon ka-rrowen-kenh. Kaluk kunekke kurduyimerranj bu Herod nuye-ni birthday. Wanjh ben-marne-marnbom mulil mankimuk. Manme kurrmeng bedberre birri-kihkimuk nawu kabirrih-worhnaworhnan government, mak nawu kabirrih-worhnan kure djamun, mak nawu birri-ngey-kihkimuk bininj kure Kalili-beh. ");
INSERT INTO gupk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Wanjh ngalyawk ngalu Herodias bi-yawmey, kam-wam kumeke borrkeng bedberre. Kaluk bu ngaleng borrkeng, Herod mak nawu manme birrih-djarr-nguneng, birri-njilng-makminj. Wanjh King Herod bi-marneyimeng ngaleke ngalyawk, “Ngayi won njalehnjale nawu yi-djare. Wanjh kan-djawa!” ");
INSERT INTO gupk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kaluk djal-wok-kurrmerrinj bu bi-marneyimeng ngalu ngalyawk, “Njalehnjale nawu kan-djawan nakka wanjh won. Mak won ngardduk kure nga-worhnan bu ngarr-bolk-larlmirran kunred!” ");
INSERT INTO gupk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wanjh ngalu ngalyawk bebmeng, wam kure ngalbadjan bi-djawam, “Kaluk njale nga-djawan nawu king ngan-won?” Wanjh ngalu ngalbadjan yimeng, “Yi-djawa ngun-won kunkodj nuye Djon nawu benh-kodj-djuhkeng. ");
INSERT INTO gupk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wanjh ngaleke ngalyawk werrkwerrk durndi kure king wanjh bi-marneyimeng, “Nga-djare kan-won kunkodj nuye Djon nawu ben-kodj-djuhkeng. Bolkkime kan-wo ngardduk kure ngalngbalabala.” ");
INSERT INTO gupk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wanjh nawu king wernh-njilng-warreminj. Kure nungka wok-kurrmerrinj ngalengarre ngalu ngalyawk bu kabi-won njale nawu ka-djare. Mak nawu bininj kumeke birrih-djarrk-nguneng manme birri-bekkang bu nungka wok-kurrmerrinj. Wanjh minj mak djareniwirrinj bu bi-dahmeninj ngalbu ngalyawk kure bi-djawam. ");
INSERT INTO gupk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kaluk werrkwerrk bi-munkeweng nakudji djamun bu kabi-kodj-kan nawu Djon. Wanjh nawu djamun wam bi-bom Djon kure rurrkkendi. ");
INSERT INTO gupk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Wanjh bim-kodjkang kure bi-kodj-dahkendoy kure ngalngbalabala wanjh bi-wong ngaleke ngalyawk, wanjh ngaleng kang bi-wong ngalbadjan ngalengarre. ");
INSERT INTO gupk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kaluk nawu Djon nuye-ni nawu ben-bukkabukkang birri-wobekkang bu baleh kurduyimerranj nuye. Wanjh birrim-wam birri-mey kunburrk nuye wanjh birri-kang birri-kuk-dudji kure kuwardde-rurrk. ");
INSERT INTO gupk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kaluk bininj nawu Jesus ben-munkeweng, wanjh birrim-durndi kure Jesus birri-djarrk-di, wanjh birrih-marne-mulewam kure birrih-kurduyimeng bu bindih-bukkang kunwok nuye. ");
INSERT INTO gupk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wanjh birri-kaberrk-wern bininj birrim-wam mak birri-wam Jesus nawu ben-bukkabukkang nuye djawirna. Minj manme mak birri-nguyinj bindi-dangdjangnang. Kaluk ben-marneyimeng, “Ngurrim-ray, karri-re kure minj nangale ka-rri kumeke ba bu karri-ngehme.” ");
INSERT INTO gupk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wanjh birri-bidbom kabbala birri-wam birri-bolkmey birri-djal-kudji kure minj nangale diwirrinj. ");
INSERT INTO gupk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wanjh bonj, birriwern bininj bindi-nang bu birri-bolk-bawong wanjh bindi-bengkang. Kaluk birriwern bininj nawu kubolk-bubuyika-beh birri-rlobmeng kurrenge kure Jesus wanahwam. Wanjh birri-bolk-mey werrk, rerre Jesus mak nuye bininj wanjh birri-bebmeng. ");
INSERT INTO gupk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kaluk bu Jesus bidbom kure karrkad nungka ben-kaberrk-nang bininj birriwern birri-yingkih-madbom kumeke, ben-nang yiman ka-yime mayh rerrih nawu sheep birrih-di mak nawu shepherd minj birri-karrmeninj. Wanjh ben-kongibom, wanjh kumeke manwern dedjmey ben-bukkabukkang bedberre. ");
INSERT INTO gupk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mak korroko wanjh ngokdanj, Jesus nuye nawu ben-bukkabukkang birrim-yikang mak birri-marneyimeng, “Minj nangale kondah ka-yo. Wanjh korroko wanjh kah-ngokdan. ");
INSERT INTO gupk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wanjh yiben-munkewemen birri-ray ba kabirri-re kure kabbal mak kure kururrk-kaberrk-di ba bu manme kabirri-bayahme ba kabirri-kuk-karrme nawu kunwardde bedberre.” ");
INSERT INTO gupk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wanjh Jesus ben-wokmey, yimeng, “Ngudda wanjh, ngurrben-wo manme kabirri-ngun.” Wanjh bedda birri-marneyimeng, “Minj ngarri-bayahme manwern manme ba bu ngarrben-woyinj rowk nane nawu bininj! Minj ngarri-kuk-karrme nadjalwern kunwardde. Bu ngad ngarri-durrkmirriwirrinj bu dird 8, wanjh ngarri-kuk-marnbuyinj, wanjh bonj. (Bu yiman 50 thousand dollars) ");
INSERT INTO gupk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wanjh Jesus ben-djawam, “Kandi-marneyimen baleh ka-yime manbu manlod kandidjdjawa ngurrih-karrme bu bolkkime? Wardi ngurri-ray ngurri-nan.” Kaluk bu birri-rohrokmeng, wanjh birri-marneyimng, “Ngarrih-karrme kunbid-kudji kandidjdjawa mak djenj bokenh.” ");
INSERT INTO gupk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wanjh Jesus ben-marneyimeng nuye nawu ben-bukkabukkang bu bindi-bengdayhkeng bininj rowk bu kabirri-yerrkan kure mandalk-mak kure birri-bebbeh-mokenhdi. ");
INSERT INTO gupk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wanjh birri-yerrkang rowk birri-ni bu birri-bebbeh-mokenhni mak bindi-rohrokmeng 50 mak 100. ");
INSERT INTO gupk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wanjh Jesus mey nawu djenj bokenh mak lodno 5, wanjh bolk-nang kaddum wanjh bi-manjbom Ngabbard Kod bu maneke-ken manme. Wanjh rerre lod-bakkeng wanjh ben-wong nuye nawu ben-bukkabukkang bu bindi-wong bininj nawu kumeke birrih-kaberrkdi. Mak ka-rohrok kurduyimeng nuye nawu djenj. ");
INSERT INTO gupk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wanjh birrimeke bininj birriwern wanjh birri-nguneng birri-worrkminj rowk. ");
INSERT INTO gupk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wanjh nawu ben-bukkabukkang birri-dahkendoy 12 kure kundjabarrk yikahwi buriddi mak djenj manbu birri-warrhkeng bu birrih-nguyinj. ");
INSERT INTO gupk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kaluk nawu birrimeke bininj birrih-kaberrkdi nakka bindi-rohrokmeng 5 thousand binihbininj nawu manme birri-nguneng. ");
INSERT INTO gupk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wanjh kuneke rerrih Jesus ben-marneyimeng nawu ben-bukkabukkang nuye bu kabirri-bidbun kure kabbala wanjh kabirri-marne-dokme borledmi-ken kure Bethsaida. Nungka wanjh bolk-maddi rerre kaben-munkewe nawu bininj birriwern birrih-kaberrk-di. ");
INSERT INTO gupk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kaluk bu ben-munkeweng birri-dokmerrinj kured wanjh nungka wam kure manduluhdulum bu ka-rri yiwarrudj. ");
INSERT INTO gupk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kaluk kuneke kukak yimerranj, nawu ben-bukkabukkang nuye birrih-dahkendi manbu kabbala, wanjh kuburldjarn birrih-di kure manbokimuk. Mak nawu Jesus nakka wanjh nadjalkudji dingihdi kure karrkad-kah. ");
INSERT INTO gupk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wanjh nungka ben-nang nawu ben-bukkabukkang nuye bu birrih-karrikmeng wernkih wanjh kunkurra manbu benh-kuk-bidjibmeng. Kaluk bu djarreh kamh-barrhbom Jesus ben-yikang wanahwam bo-melhmelmeng wam kure kaddum kurrula. Wanjh djalwahdjalwam ben-yurrhkeng nawu kure kabbala birrih-barndi. ");
INSERT INTO gupk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kaluk nawu ben-bukkabukkang nuye birri-nang wanahwam kure kubokehkekeb, wanjh bedda birri-yimeng yimanek nungka wayarra kam-waral-mankang, wanjh bedda birri-kele-kayhmeng. ");
INSERT INTO gupk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kaluk bu birri-nang, bedda birri-keleminj duninj. Wanjh kundjal-burrikudji Jesus wokdi, yimeng, “Ngayi! Ngurri-kange-rayeknin! Yun ngurri-kele!” ");
INSERT INTO gupk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wanjh Jesus bidbom kure kabbala birrih-djarrk-barndi. Manbu kunkurra makka wanjh djal-ngurdmeng. Wanjh nawu ben-bukkabukkang wanjh birri-kange-barrhmeng bulkkidj duninj. ");
INSERT INTO gupk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kaluk bu birri-kurdunang Jesus ben-wong manme mak ben-worrkiwong 5 thousand bininj, wanjh minj birri-bengkayinj bu baleh menyimeng. Minj birri-mayali-mayinj. ");
INSERT INTO gupk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bu kumeke bolkyimeng birri-djowkkeng borledmi-ken, wanjh birri-bidbom kukarndan ngalengarre Gennesaret. Wanjh kabbala kumeke birri-dukkang. ");
INSERT INTO gupk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wanjh bu birrim-koluy kure kabbala-beh, bininj nawu kumeke-beh birri-nang Jesus wanjh werrk bedda yikahwi birri-kuk-burrknang nungka. ");
INSERT INTO gupk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wanjh birri-rlobmeng kure kubolk-kimuk kumeke bu bindi-mey bindim-kang kalakkalak dorreng nawu birri-barndi birri-dulkkihyoy. Bindi-kang kure Jesus nawu birri-wobekkang bu baleh yarrkka nungka wam. ");
INSERT INTO gupk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus nungka wanahwam kure kubolk-kihkimuk mak kubolk-yahyahwurd mak wam kabbal kumeke kure kubolk-kudji. Mak baleh wam, wanjh bindim-djal-kang munguyh nawu birri-dulkkihni kure bininj nawu kabirri-bayahme njalehnjale. Kaluk birri-djal-djareni duninj bu birri-madj-karrmeng nuye kunmadj kure kurrid ngalengarre. Wanjh birri-madj-karrmeng, bedda wanjh birri-djal-makminj rowk. ");
INSERT INTO gupk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bu kunbenbekad djamun yakminj wanjh rerre daluk birriwam birribayahmeng kunkalkid nawu banjni namanjmakkayken. Birrimekke daluhdaluk birringeyyoy Mary Magdalen mak Salomi mak ngalbuyika Mary nawu James ngalbadjan. Wanjh birrikayinj yimankek birrimarnekurrmeninj kure kunburrk nuye Jesus. ");
INSERT INTO gupk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kumurrng kamhyimerranj Sunday ngalengarre kamhkabelweng bu daludaluk birridolkkang. Wanjh birriwam kure kuwardderurrk kure Jesus yongohyoy. ");
INSERT INTO gupk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Bedda birrihwam wanjh birridjawarrinj, “Nangale kawarddedjirrkkan kadberre ba karringimen? Warrih maneke kunwardde manwarddedulmuk.” Bu daludaluk birribolknang korroko dangmarrhmiwam. ");
INSERT INTO gupk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wanjh bedda birringimeng kure kuwardderurrk, birrinang nayawurrinj ningihni kururrk kure kukun. Djongbuyindi madjbele duninjh. Wanjh birrinang, birrikeleminj wanjh birrikangebarrhmeng. ");
INSERT INTO gupk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nungka benmarneyimeng, “Minj ngurrikele. Ngabengkan ngudda ngurrihyawan Jesus nawu Nazareth-beh nawu birrikukbarnameng kure kundulk cross. Nungka Kod biyawoyhdarrkidwong. Wanjh ngurrina — konda minj karri. Ngurrina kure kunburrk nuye birrikurrmeng. Nungka wam.” ");
INSERT INTO gupk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wanjh kumekke benmarneyimeng bedberre, “Ngurridurnde kure Peter mak birribuyika djawirna. Ngurrbenmarneyimen kabirridurndeng kure kunred kalili. Jesus kare kumekke ngunmadbun ngudberre. Kumekke ngurrinan. Ngurribengkan bu ngunmarneyimeng ngudberre.” ");
INSERT INTO gupk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bedda wanjh daluhdaluk birriwernhkeleminj. Minj njale birribengkayinj, birrideldelmeng. Birribebmeng kure kuwardderurrk-beh, wanjh birrikelerlobmeng. Minj bindimarnewokdiwirrinj warrih birriwernhkeleminj. ");
INSERT INTO gupk_vpl VALUES ("LK1_26b","072_1_26b","LUK","1","26b","26b","Kod bi‑munkeweng namekke andjel angel Kabriyel Gabriel kure kubolk‑kimuk ka‑bolk‑ngeyyo Nadjared Nazareth, kure kubolk‑warlah Kalili Galilee. ");
INSERT INTO gupk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bi‑munkeweng bi‑marne‑bebmeng ngalyawk ngalu minj bininj bene‑yuwirrinj. Ngalekke ngalu mak birri‑berrebbom bininj minj bene‑marrimeninj nawu ngeyyoy Djodjib Joseph, nawu King Deybid David bene‑mud. Ngalekke ngalyawk ngalu ngeyyoy Meri Mary. ");
INSERT INTO gupk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Namekke andjel kam‑wam bi‑marneyimeng, “Ngudda ngalu Kod ngun‑marneyimeng bu ngudda yi‑mak, wanjh nungka ngune‑djarrk‑re!” ");
INSERT INTO gupk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wanjh Meri bekkang manekke kunwok ngaleng njilng‑warreminj, mayahmeng, ngalengman bengkah‑bengkang yimarnek njale‑kenh kune bi‑marne‑wokdi. ");
INSERT INTO gupk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wanjh andjel bi‑ngeybom yimeng, “Meri, minj yi‑kele. Kod nungka namak ke. ");
INSERT INTO gupk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kan‑bekka, marneyime, kaluk ngudda yi‑kuk‑dulmuk wanjh yi‑yaw‑mang narangem, wanjh yi‑ngey‑kurrme nane wurdyaw Jesus. ");
INSERT INTO gupk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kaluk nungka nakuken, ka‑ngeyyo ‘Beywurd nuye Kod nawu na‑djal‑wernh‑kimuk’. Kod nawu Kaworhnan Rowk, wanjh kabi‑marnbun nungka nakimuk ka‑worhnan kure Deybid worhnang korroko. ");
INSERT INTO gupk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kaluk nungka ka‑djal‑worhnan munguyh‑munguyh kure nawu Djeykob Jacob ngurri‑mud, minj ka‑ngurdme nuye, munguyh ka‑djal‑worhnan.” ");
INSERT INTO gupk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri bi‑wokmey andjel nawu kunwok kam‑kang, bi‑marneyimeng, “Kaluk baleh yimerranj? Ngayi minj bininj ngane‑yuwirrinj.” ");
INSERT INTO gupk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wanjh namekke andjel bi‑wokmey, bi‑marneyimeng, “Nawaralmakkaykenh kaluk ngun‑yikarrme, Kod nawu Kaworhnan Rowk, kaluk kunngudj nuye ngun‑barrkbun. Ba kune ka‑kurduyime, wanjh namekke nawu yi‑yawmang wanjh namekke nuye Kod. Kaluk ka‑ngeyyo ‘Beywurd nuye Kod’. ");
INSERT INTO gupk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kune mak marneyime. Yilidjabed Elizabeth ngalu ngudda ngone‑mud, ngaleng mak bolkkime ka‑yaw‑kan narangem, ngaleng ngalkohbanj. Dird 6 ka‑marnbun bu kah‑kan, ngalu birri‑marneyimeng ngaleng ngal‑walirrng‑warreni. ");
INSERT INTO gupk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Minj njale ka‑rayek kure nungka Kod.” ");
INSERT INTO gupk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wanjh Meri yimeng, “Yoh. Ngayi nga‑djal‑marne‑durrkmirri nuye nawu Kaworhnan Rowk. Bonj, nga‑djare ngan‑djal‑marne‑kurduyime manekke kunwok bu ngudda kan‑marneyimeng.” Namekke andjel bi‑bawong, wam. ");
INSERT INTO gupk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kunekke wanjh yimerranj, kaluk nawu worhnang namekke nawu ngeyyoy Akadja Augustus. Wanjh ben‑wok‑rayekwong bindi‑ngey‑kurrmeng bininj rowk kure kubolk‑warlah‑kenh kure kunred ngalengarre Rowm Rome. ");
INSERT INTO gupk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Kune wanjh yimerranj kun‑yungki bindi‑ngey‑kurrmeng kure Kiriniya Quirinius worhnang kure ka‑bolk‑ngeyyo Djiriya Syria.) ");
INSERT INTO gupk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wanjh bininj rowk birri‑wam bindi‑ngey‑kurrmeng, kaluk bedda birri‑bebbewam kure kubolk‑kihkimuk bedberre. ");
INSERT INTO gupk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nungka Djosib bolk‑bawong Nadjared Nazareth kure Kalili Galilee kubolk‑kimuk, yawoyh‑dolkkang wam kure ngalengarre kunred Bedliyem Bethlehem kure Djudeya Judea. King Deybid David ni korroko kumekke kunred. Namud nuye Djosib Joseph. ");
INSERT INTO gupk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nungka Djosib wanjh wam ngey‑kurrmerrinj. Meri Mary bene‑djarrk‑wam ngalu birri‑berrebbom nuye kuk‑dulmuk‑ni. ");
INSERT INTO gupk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Kure Bedliyem Bethlehem Djosib, Meri minj bene‑ngalkemeninj kunred bedda minj bene‑yuwirrinj, bene‑wam bene‑yoy kunred kure mayh kaberrkdi manme yoy. Kumekke beneh‑ni wanjh kam‑wam ngalengarre bih‑bom wurdyaw kodjyungki dolkang. Bi‑karrmeng ngalbadjan kumekke bi‑rrukkang nungka bi‑wayhkeng, bi‑kurrmeng kodjdjeyoy kure mayh kundalk. ");
INSERT INTO gupk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Minj djarreh rayi, kunekke rerrih kunkak kam‑wam, wanjh bininj birrim‑bebmeng kure kundalk kunred bindi‑nahnang bedberre mayh birri‑yoy. ");
INSERT INTO gupk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kunekke rerrih andjel angel kam‑kang kunwok kure kaddum‑beh birri‑djaldi. Birri‑nang ben‑wayalhmeng nungka Ngabbard kuwern kunred bedda wanjh birri‑keleminj. ");
INSERT INTO gupk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Andjel yimeng, “Minj ngurri‑kele. Ngayi nga‑karrme woybukki kunwok ngudberre ngurri‑djalwern kure kubolk‑wern. ");
INSERT INTO gupk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","12","Bolkki ngalyawkyawk kabi‑karrme wurdyaw bininj kumekke kure Bedliyem, kumekke kunred kure Deybid David djordminj. Ngurri‑ray kumekke ngudda ngurri‑yawan. Nungka birri‑dukkang kunmadj birri‑kurrmeng ka‑yo kure mayh birri‑yoy. Ba ngudda ngurri‑bengkan mane kunwok ngayi marneyimeng ngudberre woybukki. Namekke na‑kudji ka‑re ka‑kukmarnbun bininj. Nadjalkudji Ngabbard bi‑weykang kadberre karri‑djalwern Kaworhnan kadberre.” ");
INSERT INTO gupk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kuneng yimeng birri‑wern andjel birri‑woh‑bebmeng kaddum‑beh birri‑di namekke andjel. Birri‑manjbom Kod. Birri‑yimeng, ");
INSERT INTO gupk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Bulkkidj karri‑marnedjare Kod nawu kaddum kah‑ni. Ben‑kange‑karrmeng nuye bininj kure birri‑marne‑durrkmirri.” ");
INSERT INTO gupk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Andjel bindi‑bawong birri‑durndi kaddum. Bininj birri‑marneyimerrinj, “Karri‑re Bedliyem Bethlehem, karri‑nan Nakimuk kan‑bengdayhke kadberre baleh yimeng.” ");
INSERT INTO gupk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Birri‑dokorrokmeng bindi‑nang ngal‑badjan kornkumo wurdyaw yoy kure kundalk mayh birri‑yoy. ");
INSERT INTO gupk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kaluk bedda bindi‑nang bindi‑wok‑mulewam andjel ben‑marneyimeng namekke wurdyaw. ");
INSERT INTO gupk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kaluk, birri‑wern bindi‑bekkang bedda djebed shepherds bindi‑mulewam. Birri‑wern birri‑djurrkwong. ");
INSERT INTO gupk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary ben‑wok‑karrmeng djebed kure bedda birri‑marneyimeng. ");
INSERT INTO gupk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wanjh djebed birri‑durndi kure birri‑nahnang. Kunkange dorrengh birri‑manjbom Kod birri‑bekkang birri‑nang, wanjh durrkmirri rowk andjel angel bindi‑marneyimeng. ");
INSERT INTO gupk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bu kunkodjdje 7 wanjh kam‑wam nungka wurdyaw lakkayenminj. Bedda bene‑ngey‑kurrmeng ‘Jesus’. Manekke kunngey andjel angel bi‑yingkih‑wong bu ngalbadjan minj bi‑yawkayinj. ");
INSERT INTO gupk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wanjh korroko kam‑wam kure Modjidj Moses nuye kunwok wok‑yoy nuye Kaworhnan bu daluk kabirri‑kuk‑djirridjburren wurdyaw‑kenh. Wanjh Djosib Joseph, Meri Mary bene‑kang Jesus kure Djerudjalem Jerusalem nungka bene‑wong Kaworhnan kadberre. ");
INSERT INTO gupk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wokyoy nuye nawu Kaworhnan, “Binihbininj birri‑yungki bedda wanjh birri‑djamun nungka Kod nuye kornkumo ngalbadjan wanjh kabene‑yaw‑won” ");
INSERT INTO gupk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kunwok nuye Kaworhnan, ngalbadjan kornkumo kabindim‑kan bokenh marlum bene-mak. Kabene‑won nawu djungkay. Bokenh marlum kaben‑bun Kod nuye. Bedda bene‑yimeng Meri, Djosib. ");
INSERT INTO gupk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kumekke Djerudjalem Jerusalem na‑kudji bininj nawu ngeyyoy Djimeyon Simeon, namak bininj, Kod nuye mankarre karrmeng rowk. Mak nungka bi‑djal‑madbom Kod kure Yidjrayel Israel nuye mawah‑mawah ben‑marnbom. Nawaralmakkaykenh bene‑djarrk‑wam. ");
INSERT INTO gupk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Korroko bi‑marneyimeng Nawaralmakkaykenh nungka minj ka‑rrowen, kabi‑nan werrk Christ nawu Kaworhnan Rowk kan‑berrebom kadberre. ");
INSERT INTO gupk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kumekke Nawaralmakkaykenh bi‑kadjuy kure dempel temple birri‑di yiwarrudj. Ngalbadjan kornkumo benem‑yaw‑ngihngimeng Jesus nangarrken‑ni, bene‑marne‑kurduyimeng kure mankarre yoy, ");
INSERT INTO gupk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","wanjh nungka Djimeyon bi‑wanjbimey, bi‑burlumeng Kod yimeng, ");
INSERT INTO gupk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bolkki Kod ngayi nga‑rrowen nga‑djurrkwon ngayi nga‑kukmononmang kure kan‑berrebbom ngayi. ");
INSERT INTO gupk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ngayi nga‑nang kumim ngardduk, ngudda nawu kan‑wong ngadberre nane wurdyaw ngan‑yerrkke ngan‑kangemarnbun ngadberre. ");
INSERT INTO gupk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Yi‑yingkih‑karre‑marnbom bininj birri‑wok‑buyika rowk ngundi‑kurdunan. ");
INSERT INTO gupk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nungka ka‑bolk‑wayalhme yiman kundung kure birri‑wern bininj kubolk-wern. Nungka ngun‑bukkan ngudberre kunkerrnge ngudberre ngudda Kod. Ngun‑marnbun ngudberre birri‑buyika bininj kabirri‑wok‑marrkmang Yidrayel ngurri‑mud.” ");
INSERT INTO gupk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kornkumo ngalbadjan bedda wanjh bene‑mayahmeng bu Djimeyon yimeng bi‑mulewam Jesus. ");
INSERT INTO gupk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Djimeyon ben‑marneyimeng, “Nga‑djare Kod ngun‑marneyime ngurrewoneng bu kamak.” Bi‑marneyimeng ngalbadjan, “Kan‑bekka, marneyime nane wurdyaw Kod bi‑munkeweng bu bininj kaben‑larlmang, kaben‑marnbun birri‑wern kabirri‑bawon Kod wanjh kabirri‑mayahme. Mak kaben‑marnbun birri‑wern kabirri‑yikan kaben‑yerrkke Kod. Nungka kaben‑bukkan bu Kod kunngudj nuye. Birri‑wern kabirri‑wirrihme. ");
INSERT INTO gupk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kod bi‑munkeweng nungka kaben‑marnbun bininj birri‑wern kabirri‑mayali‑bukkarren. Ngudda ngalbadjan wanjh yi‑djak‑bekkan yiman rerrih mandjawak ngun‑kange‑dulubun.” ");
INSERT INTO gupk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kaluk mak kumekke ni ngal‑kudji ngal‑kare ngalu bi‑wokmulewam Kod, ngalu ngeyyoy Ana Anna, ngalengarre kornkumo ngeyyoy Banyuwel Phanuel, bedda birri‑mud Adja Asher. Ngaleng wanjh kohbanjminj. Bu ngal‑yawkyawk‑ni bene‑marrinj bininj, beneh‑ni bu mandjewk 7, wanjh nungka doweng. ");
INSERT INTO gupk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Wanjh ngaleng ngalu ngal‑bamu‑ni munguyh bininj‑yak, ngale wanjh kohbanjminj, mandjewk 84 ngalengarre. Ngaleng minj rurrk‑bawoyinj kure dempel temple, munguyh‑munguyh djaldi yiwarrudj bolk‑nahnang kure kunrurrk nuye Kod, benbekad mak kukak, manme bawong bi‑djawam Kod kunwern. ");
INSERT INTO gupk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kumekke Jesus birrih‑ni kururrk, kunekke rerrih Anna ben‑marne‑bebmeng, wanjh bi‑manjbom Kod, bi‑mulewam Jesus, kure bininj birri‑madbom Kod ben‑yerrkkeng bininj nawu birrih‑ni kure Djerudjalem Jerusalem. ");
INSERT INTO gupk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wanjh Jesus nuye ngalbadjan kornkumo bene‑durrkmirri rowk kure mankarre yoy God nuye kunwok. Wanjh bu bene‑yaw‑wong rowk wanjh birri‑durndi kure Galilee, kure kubolk‑kimuk bu bedda birrih‑ni ka‑bolk‑ngey‑yo Nadared Nazareth. ");
INSERT INTO gupk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nawu wurdyaw djordminj, kundarrkid nuye murrng‑rayekminj, kunmayali dorrengh nuye wernminj Kod bi‑marne‑durrkmirri kunmak nuye. ");
INSERT INTO gupk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kod nawu kan-marne-djare kadberre birriwern bininj kunekke-kenh: kan-wong kadberre beywurd nuye na-djal-kudji. Bininj nawu karri-woybuk-won minj karri-dowen, karri-djal-darrkid munguyh munguyh kure nungka. ");
INSERT INTO gupk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus bi-marneyimeng Martha, “Ngayi wanjh nga-djal-kudji bu dolkkayhwe ngudberre, kerrngehmen ngudberre ngurri-wern bininj. Nangale nawu ngan-woybukwon, bu ka-rrowen wanjh ka-djal-yawoyh-kerrngemen kure ngayi.” ");
INSERT INTO gupk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus ben-marneyimeng, “Minj ngurri‑njilng-warremen. Ngurri-woybukwo Kod, kandi‑woybukwo ngayi. ");
INSERT INTO gupk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kure ngardduk Ngabbard nuye kunred kubolk-kimuk. Kure woybukki ngayi marneyime ngudberre. Ngayi nga-rrokme nga-bolkmarnbun ngudberre. ");
INSERT INTO gupk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ngayi nga-yingkih-bolkmarnbun ngudberre ngayeman ngam-durndeng mang ngudberre, ba karri-djarrk-ni kure ngayi ngah-ni. ");
INSERT INTO gupk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ngudda ngurri-bengkan kure manbolh ngayi nga-re.” ");
INSERT INTO gupk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas bi-marneyimeng, “Yi-worhnan, ngad minj ngarri‑bengkan baleh kunred yi-re, ngad minj ngarri‑bengkan kure manbolh yi-re.” ");
INSERT INTO gupk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus bi-marneyimeng, “Ngayi nawu manbolh, ngayi nawu woybukki, ngayi nawu kundarrkid. Nangale nawu ka-re kure Ngabbard, nakka wanjh kam‑re kure ngayi werrk, kumekke wanjh ku-djal-kudji manbolh kure Ngabbard. ");
INSERT INTO gupk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kunyungki minj kandi-bengkayinj, bolkki wanjh kandi‑bengkan ba kunukka ngurri‑bengkan ngardduk Ngabbard warridj. Bolkkime wanjh ngudda ngurrih‑bengkan, ngurri‑nan nungka.” ");
INSERT INTO gupk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip bi-marneyimeng, “Yi-worhnan, mah! Kan‑bukka ngadberre Kod nawu Ngabbard ba ngarri‑nan bolkki. Kunekke ngad ngarri-djare.” ");
INSERT INTO gupk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus bi-marneyimeng, “Filip, ngayi bu korroko karri‑djarrk‑wam kunred la kunred. Ngayi minj kan‑kukburrknan ngayi? Nangale ngan-nang ngayi wanjh nakka kabi-nan Kod Ngabbard. Njale-kenh ngudda yi-djawayhme bu yi-yimeng ‘Kan-bukka Kod nawu Ngabbard’? ");
INSERT INTO gupk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ngudda minj yi-wernh-bengkan bu ngayi ngah-ni kunkange nuye Kod nawu Ngabbard nungka kah-ni kunkange ngardduk. Mane kunwok kure ngayi marneyime ngudberre minj ngayi ngardduk. Nungka Kod nawu Ngabbard kah-ni kunkange ngardduk wanjh nungan ka-rrurrkmirri kure njale ngayi nga‑kurduyimeng. ");
INSERT INTO gupk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kandi-woybukwo kure ngah-yime ngudberre kure ngayi ngah-ni kure kunkange Ngabbard, mak Ngabbard kah-ni kure kunkange ngardduk. Mak kandi-woybukwoyinj kure kandi-ngudj-nang nga‑marnedurrkmirri nuye Ngabbard. ");
INSERT INTO gupk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Woybukkih, woybukkih marneyime ngudberre, birri‑ngale bininj nawu ngayi ngandi-woybukwon, wanjh bedmanwali kabirri‑durrkmirri bu ka-rohrok yiman ngayi ngah-marnedurrkmirri. Ngayi nga-re kure Kod nawu Ngabbard. Wanjh warridj kabirri-durrkmirri bu kunmakmak ngayi ngah‑marnedurrkmirri! ");
INSERT INTO gupk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ngudda ngardduk bininj kandi-ngey-woybukwon wanjh ngudda ngurri-djare kandi-djawan njaleh-njale, wanjh ngayi marnedurrkmirri ngudberre. ");
INSERT INTO gupk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yoh. Ngudda ngurri-djare njaleh-njale nawu kandi‑djawan kure kunngey ngardduk, wanjh kunekke ngayi nga‑djal‑durrkmirri kure kandi-djawan.” ");
INSERT INTO gupk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesus ben-marneyimeng bedberre, “Bu ngayi kandi-marnedjare bulkkidj, wanjh kunukka kandi-wokmarrkmang. ");
INSERT INTO gupk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kaluk ngayi nga-djawan nawu Ngabbard Kod ba bu ngun-won ngudberre kuk-buyika kungudj nawu ngun-bidyikarrme ngudberre, kure ngurri-djarrkdi munguyh. ");
INSERT INTO gupk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Namekke wanjh Nawaralmakkaykenh kure kabi-yolyolme Kod bu kunwoybuk dorrengh, kure ngurri-bengkan. Bininj nawu birri-kang kure kukurlk, wanjh bedda minj kabirri-mang Nawaralmakkaykenh. Kure ka-ngimeng bedberre. Ngudda ngurri-kudji ngurri-bengkan bu nungka ngurri-djarrk-re ka-ni kukange ngudberre. ");
INSERT INTO gupk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ngayi minj bawon ngudberre bu ngurri-mayahmey yiman ka-yime ngurri-marladj. Ngayi werrk ngam-durndeng ngudberre. ");
INSERT INTO gupk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kune bu bolkkime darnkih kabolk-yimerran bu minj ngandi-yawoyh-nan nawu bininj birri-kang kondanj kukurlk. Ngudda ngurri-djal-kudji kure kandi-nan. Ngayi nawu nga-djal-darrkid-di, wanjh kaluk kunekke-kenh ngudmanwali ngurri-djal-darrkid. ");
INSERT INTO gupk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ba kumekke ngurri-bengkan bu kune ngayi nga-ni kure Kod nawu Kornkumo kukange nuye, mak ngudda ngurrih-ni kure ngayi kukange ngardduk, mak ngayi ngah-ni kure kukange ngudberre. ");
INSERT INTO gupk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nangale nawu bininj ngan-marnedjare, nakka wanjh bengkang mankarre ngardduk. Ngan-wokmarrkmang. Nawu nangale bininj ngan-marnedjare ngayi, wanjh Ngabbard ngardduk nunganwali kabi-marnedjare namekke bininj. Ngayi warridj nga-marnedjare. Wanjh nga-marne-kukbukkarren kure nungka nuye.” Mane wanjh Jesus yimeng. ");
INSERT INTO gupk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Wanjh Djudas nawu nabuyika yimeng. Minj nawu Djudas Iskariot, bi-djawam Jesus, yimeng, “Yiworhnan, njale-kenh bu ngudda yi-kukbukkarren ngadberre, mak birribuyika bininj kukurlk kabirrih-ni minj yiben-marne-kukbukkarren bedberre?” ");
INSERT INTO gupk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus yimeng, “Nangale nawu bininj ngan-marnedjare, wanjh nakka ka-kurduyime kure ngayi nga-bukkabukkan. Nawu ngardduk Ngabbard kabi-marnedjare namekke bininj. Wanjh ngayi, ngardduk Ngabbard nganem-yikan bu ngarri-djarrk-di namekke bininj. ");
INSERT INTO gupk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nangale nawu minj ngan-marnedjare, nakka minj ngan-wokmarrkmang kure nga-bukkabukkan. Mane wanjh kunwok nga-wokdi, minj ngayi ngardduk. Nuye Kod nawu Kornkumo ngardduk ngan-munkeweng. ");
INSERT INTO gupk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ngayi marne-marneyime ngudberre bu bolkkime karrih-djarrkdi. ");
INSERT INTO gupk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kaluk rerrih nawu God nawu Kornkumo kabi- munkeweng ngudberre Nawaralmakkaykenh bu ngun-bidyikarrme ngudberre mak ngun-bukkabukkan ngudberre kuwern kure ngayi ngardduk, mak ngun-bengdayhke ngudberre bu kunwok rowk bu ngayi korroko marneyimeng ngudberre. ");
INSERT INTO gupk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ngayi yibawon ngudberre kunkange dorrengh. Ngayi won ngudberre kure ngurri-kuk-manonma. Bininj nawu birri-kang kukurlk-beh minj ngundi-won ngudberre kunkange. Minj ngurri-njilng-warremen. ");
INSERT INTO gupk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ngayi wanjh korroko marneyimeng ngudberre bu ngayi nga-re bawon ngudberre, kaluk ngam-yawoyh-durndeng ngudberre. Bu ngudda kandi-marnedjare ngayi wanjh ngurri-njilng-makmen munguyh bu ngayi wanjh bawon ngudberre, nga-re kure Kod nawu Kornkumo ngardduk nawu na-ngudjkimuk duninjh kure ngayi. ");
INSERT INTO gupk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bolkkime wanjh ngayi bengdayhke ngudberre, bu kaluk ngurri-nan rerre ngan-marne-bolkyimerran, wanjh kumekke kandi-woybukwon. ");
INSERT INTO gupk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Minj marneyime ngudberre bolkkime. Korroko wayarra kamh-re nawu ngan-mang. Nungka ka-worhnan kondanj kure kukurlk. Nungka minj ngan-marne-worhnan ngayi. Kayakki! ");
INSERT INTO gupk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngayi nga-wokmarrkmey rowk kure nawu ngardduk Ngabbard kure ngan-wokrayekwong. Kunekke-kenh bininj rowk kabirri-bengkan kure ngayi nga-marnedjare Ngabbard. Mah, karrim-dolkka rowk, karri-bolk-bawo kondanj kure kunred, wanjh karri-re.” ");
INSERT INTO gupk_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","Nane nawu djurra ka‑yolyolme bu Kod bi‑bukkang nawu Jesus Christ. Kaluk bu nungka Jesus mey kunwok, wanjh ben‑bukkang bininj nawu kabirri‑marne‑durrkmirri nuye kure baleh ka‑bolkyimerran kure mak darnkih ka‑yimerran. Jesus bi‑munkeweng nawu andjel nuye. Ngan‑bukkang ngayi Djon bu nga‑marne‑durrkmirri Jesus. ");
INSERT INTO gupk_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","Wanjh ngayi bolkkime nga‑mulewan kunwoybuk dorrengh kure njaleh‑njale ngayi nga‑nang mak nga‑bekkang. Ngayi nga‑yolyolme kure Kod nuye kunwok mak kure Jesus Christ nungan mulewarrinj kure kunwoybuk nuye. ");
INSERT INTO gupk_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","Ka‑njing‑mak bininj nawu ka‑djal‑bimnan munguyh kure ka‑wok‑bimdi nane djurra Kod nuye kunwok, mak kabirri‑njilng‑mak bininj nawu kabirri‑bekkan kabirri‑woybukwon kure ka‑wok‑bimbuyindi nuye. Bu kone wanjh darnkih kamh‑re nuye bu kone ka‑kurduyime rowk. ");
INSERT INTO gupk_vpl VALUES ("RV1_4","096_1_4","REV","1","4","5","Ngayi Djon nga‑munkewe mane kunwok kure bininj nawu yiwarrudj ngudberre ngurrih‑di kure kubolk‑bubuyika kure 7 kure kubolk‑kimuk ngalengarre Asia. Ngurri‑bengkan Kod nawu ningih‑ni kunyungki duninjh mak kah‑djal‑ni bolkkime, mak nungka narrarrkid munguyh munguyh. Mak ngurri‑bengkan 7 birri‑malng‑mak nawu kabirrih‑di kure kumirrk nuye Kod nuye throne. Ngurri‑bengkan Jesus Christ nawu nawoybuk kure kah‑wokdi kure kornkumo kadberre, mak nawu kunyungkih bu yawoyh‑dolkkang kure kundowiken. Nungka mak kaben‑djal‑marne‑worhnan bedberre kings rowk nawu kabirri‑worhnaworhnan kure kubolk‑warlah‑ken rowk kondanj kukurlk. Wanjh nga‑djare Jesus Christ nawu God mak nuye kunwaral kabirri‑di kumirrk nuye, bu ngundi‑djal‑kongibun kure ngundi‑kange‑marnbom ngudberre. Mah, wanjh karri‑djarrk‑burlumen Jesus nawu kan-marnedjare nawu kurlba-wam kadberre, bu ngad kanbebkeng kure kunwarre karri-dulkkayindi. ");
INSERT INTO gupk_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","Karri-djarrk-burlumen Jesus nawu kan-marnbom kadberre nuye bininj bu karri-yimerranj djungkay nuye ngad nawu karri-djal-wern rowk bu ngad karri-marne-durrkmirri Kod nawu kornkumo nuye Jesus Christ. Karriburlumen Jesus nawu namakkaykenh duninj mak nawern-dulkarre-kimuk duninj, djal munguyh munguyh, wanjh bonj. ");
INSERT INTO gupk_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","Ngurri‑na! Nungka Jesus kamh‑re kure kaddum kunngol‑beh, birri‑wern bininj kabirri‑darrkid‑nan, mak bininj nawu birri‑ngorrk‑dulubom warridj. Mak birri‑wern bininj nawu kondanj kukurlk kabirrih‑ni, kaluk bedda kabirri‑nalkbun wernkih bu nungka‑kenh. Yoh. Kone wanjh ka‑kurduyimerran. Wanjh bonj. ");
INSERT INTO gupk_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","Kod nawu Kaworhnan Rowk ka‑yime, “Ngayi nawu Alpha mak Omega. Ngayi wanjh ngah-ni kunyungkih duninjh, mak nga‑djal‑ni bolkkime, mak ngayi nawu nga‑djal‑darrkid munguyh munguyh. Ngayi nawu nga‑djal‑wernh‑ngudj‑kimuk duninjh.” ");
INSERT INTO gupk_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","Ngayi Djon nawu ngudda karri‑danginj. Ngad karri‑yikadjurren Christ dorrengh bu karri‑djarrk‑djak‑bekkan nuye, mak karri‑marne‑durrkmirri Kod nawu Kaworhnan Rowk, mak karri‑madbun bu yalmo yalmo, bu karri‑djale munguyh kure kunmak. Ngayi nawu ngah‑weykang kunwok nuye Kod mak ngayi ngah‑mulewam kure Jesus yimeng kadberre manbu kunwoybuk dorrengh, wanjh kunekke‑kenh bininj ngandi‑kurrmeng kure manyunkurr ka‑bolk‑ngeyyo Patmos. ");
INSERT INTO gupk_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","Kaluk bu benbekad nuye nawu Kaworhnan Rowk, ngayi ngan‑kang nawu Nawaralmakkayken, wanjh nga‑bekkang wok‑kimukminj bu kam‑wokdi kure kubodme ngardduk, wokyimeng yiman trumpet. ");
INSERT INTO gupk_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","Wanjh yimeng, “Bu ngudda yi‑nan kure bukka‑bukkan wanjh yi‑bimbu kure djurra, ba yiben‑marne‑munkewe nawu bininj nawu yiwarrudj bedberre kure kubolk‑buyika ka‑bolk‑ngeyyo 7: Efesus, Smerna, Perkamum, Thiyatira, Sardis, Filadelfiya, Layodiseya.” ");
INSERT INTO gupk_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","Yiman nga‑yimeng, “Nangale kam‑wokdi kubodme ngardduk?” Wanjh nga‑borledmeng, nga‑nang 'golden lampstands' waydi runguh‑ruy yiman ka‑yime kunrak 7. ");
INSERT INTO gupk_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","Nga‑nang nangale dingihdi kure lampstands. Nungka kuk‑yimeng yiman “Bininj Duninjh”. Nawu nungka djongbuyindi nawu madj‑kuyeng mak golden manburrba berre‑dukkayindi. ");
INSERT INTO gupk_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","Kure kukodj nuye mak kumarre nuye yiman waydi yiman ka‑yime kunngol manbele waydi duninjh. Kunmim nuye ruy yiman kunrak. ");
INSERT INTO gupk_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","Kurrenge nuye nakka ruy yiman ka‑yime wirlmurrng 'steel' kure kah‑rung, kah-waydi duninjh. Bu nungka kam‑wokdi, wanjh wokyimeng yiman kunronj kam‑bo‑wokyi‑koluy. ");
INSERT INTO gupk_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","Nungka nga‑nang karrmeng 7 kinjkinj kure kubid kukun nuye. Mak kure kurrang nuye nga‑nang kam‑bebmeng mandjawak nakimuk, djurrmak duninjh. Kaluk nakka djurrk-bokenh duninjh. Mak kunkeb nuye keb‑waydi yiman kundung rerrih manbu ka‑wern‑wayarlhmeng benbekad buldjdjarn ngalengarre. ");
INSERT INTO gupk_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","Kaluk kumekke nga‑nang, wanjh nga‑mankang kure kurrenge nuye yiman bininj nawu ka‑rrowen rerrih. Nungka ngan‑marne‑bid‑kurrmerrinj kure kubidkun nuye, mak ngan‑karrmeng wanjh yimeng, “Yuwn yi‑kele. Ngayi nawu nga‑djal‑kudji nga‑rrokme mak ngam‑re rerre. ");
INSERT INTO gupk_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","Ngayi nawu nga‑rrarrkid munguyh. Ngayi nga‑rroweng, yi‑na: ngayi nga‑djal‑darrkid munguyh munguyh! Yi‑na mak ngayi nga‑karrme ‘key’ nawu kundowiken ngalengarre mak kunred kure bininj nawu birri‑doweng kabirri‑dukkayindi. ");
INSERT INTO gupk_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","Wanjh yi‑bimbu nawu yi‑nang, mak kure yi‑nan ka‑kurduyime bu bolkkime, mak bu rerrih. ");
INSERT INTO gupk_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","Mak nga‑mulewan ka‑warlkkayindi ngalengarre kure kinjkinj bu kan‑yinang nga‑karrmeng kure kubidkun ngardduk, mak manbu 7 golden lampstands. Nawu 7 lampstands nakka wanjh yiman ka‑yime kaben‑kodj‑mulewan bininj nawu yiwarrudj bedberre kure 7 kunred. Kaluk makka rowk wanjh kaben‑kodjmulewan kure 7 kinjkinj, nakka wanjh 7 andjels bedberre kure bininj nawu yiwarrudj bedberre kure 7 kunred. ” ");
INSERT INTO gupk_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","Wanjh Jesus ngan‑bengdayhkeng, yimeng, “Nane yi‑bimbu nane nawu andjel nuye, nawu ka‑kan kaben‑won bininj nawu yiwarrudj bedberre kabirrih‑ni kure ka‑bolk‑ngeyyo Efesus: Ngayi ngah‑karrme 7 kinjkinj kure kubidkun ngarduk, mak ngayi ngah‑re kure 7 gold lampstands kunrak kure kah‑rung. ");
INSERT INTO gupk_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","Ngayi nga‑bengkan kure ngudda ngurri‑kurduyime, mak ngurri‑marne‑durrkmirri kure kunkimuk. Minj ngurri‑bawon kure kunmak ngurri‑djallay munguyh kunmak. Ngayi bengkan ngudberre bu minj ngurrben‑wok‑marrkmang dabborrabolk nawu birriwarre. Mak ngurrben‑rohrokmen birrimekke kabirri‑yime bedda yiman yiwarrudj bedberre. Bu ngurrben‑bengkan bedda wanjh kabirri‑kurren. ");
INSERT INTO gupk_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","Ngudda ngurri‑djale kure kunrayek kam‑bebme bu yiwarrudj ngudberre bininj, kandi‑ngeybun, minj ngurri‑wunjibme ngurri-djal-durrkmirri munguyh ngarduk. ");
INSERT INTO gupk_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","Mak ngayi bengdung ngudberre bu manbuyika: Ngudda minj kandi‑wern‑marnedjare, minj ngurri‑marnedjare‑mulewarren. Bu kunyungki kandi‑marnedjare-niwirrinj bu kunkange dorrengh. ");
INSERT INTO gupk_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","Wanjh ngurri‑bengka kure kunyungki ngurrih‑djal‑wam kunmak rowk, wanjh ngurri‑kange‑borledmen, wanjh ngurri‑durnde kure kunyungki kunmak ngurri‑wam. Bu minj ngudda ngurri‑kange‑borledme kunukka wanjh ngayi ngam‑re nga‑mang nga‑kan manu lampstand ngudberre. ");
INSERT INTO gupk_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","Bu kunkudji kure kunmak ngurri‑kurduyime ngarduk ngayi: Ngudda ngurri‑widnan kunwarre bedberre nawu Nikolaytian bininj. Mak ngayi warridj nga-widnan kunwarre bedberre. ");
INSERT INTO gupk_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","Bu ngudda ngurri‑karrme kunkanem, wanjh ngurri‑bekka kure baleh nawu Nawaralmakkaykenh nungan kaben‑marneyime bininj nawu yiwarrudj bedberre: Bininj nawu munguyh kabirri‑djale nakka wanjh kabirri‑winhme kure ngayi. Wanjh ngaben‑won bu kabirri‑ngun manme manbu kaben‑darrkid‑won. Manekke wanjh barnem‑no kure kundulk kure ka‑dudjendi kure Kod nuye kubolk‑makkaykenh. ");
INSERT INTO gupk_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","Jesus ngan‑yawoyh‑bengdayhkeng ngayi nawu John, kure yimeng, “Mane yi‑bimbu nuye andjel nawu ka‑kan kure yiwarrudj bedberre nawu kabirrih‑ni kure kabolk‑ngeyyo Smerna: Ngayi Jesus nga-yime: nawu nga‑djal‑kudji nga‑rrokme mak ngam‑re rerre. Ngayi nga‑rroweng mak nga‑yawoyh‑kerrngehminj. ");
INSERT INTO gupk_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","“Nga‑bengkan bu kunrayek kamh‑bebme ngudberre. Nga‑bengkan bu ngudda ngurri‑marladj, kone marneyime bu woybukki ngudda ngurri‑kuken ngardduk. Nga‑bengkan bu birribuyika bininj ngundi‑wurrken ngundi‑kurrenwan ngudberre. Bedda yiman kabirri‑ngeyburren Djuws bininj. Kayakki, bedda minj woybukki nawu bininj Djuws. Bedda wanjh bininj nawu Satan Narderr nuye bu kabirri‑mokenraworren. ");
INSERT INTO gupk_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","Bolkkime bu kam‑re kunrayek wanjh ngurri‑djak‑bekkan. Minj ngurri‑kele kure kumekke. Ngayi marneyime ngudberre, nawu wayarra Satan ngun‑djurrkan ngudberre. Ngun‑dangbarlhme ngudberre kure kururrk kure prison. Wanjh ngurri‑djak‑bekkan kubid kunkudji benbekad kundung, 10 days. Ngurri‑kange‑woybuk‑nin, mak bu ngundi‑bun ngurri‑dowen. Kaluk ngayi wanjh kerrngehmey ngudberre ba ngurri‑malng‑darrkid munguyh. ");
INSERT INTO gupk_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","Bu ngudda ngurri‑karrme kunkanem wanjh ngurri‑bekka kure baleh Nawaralmakkayken kaben‑marneyime nawu yiwarrudj bedberre bininj: Wanjh birrimekke nawu kabirri‑djale wanjh kabirri‑winhme kure ngarduk, birri‑nukka minj kabirri‑re kure kubolk‑warre bu minj kabirri‑yawoyh‑malng‑dowen.” ");
INSERT INTO gupk_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","Jesus yimeng, “mane yi‑bimbu nuye angel nawu ka‑kan kure nawu yiwarrudj bedberre kure kabirrih‑ni kure ka‑bolk‑ngeyyo Perkamum: Ngayi Jesus ngah-yime: Ngayi nga‑karrme mandjawak nakimuk djurrmak duninjh, kure kurrang ngarduk kam‑bebmeng, kaluk nakka djurr‑bokenh duninjh. ");
INSERT INTO gupk_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","“Ngayi nga‑bolk‑bengkan kure ngudda ngurrih‑ni. Kaluk kumekke kure wayarra nawu Satan Narderr kah‑ni kure nungan kunred ka‑worhnan. Ngudda ngurri‑kange‑woybuk‑ni kure ngayi. Mak ngudda minj ngurri‑kele bu ngayi kandi‑woybukwong kure kunrayek kam‑bebme ngudberre kumekke kure kubolk‑kimuk nawu wayarra Satan kah‑ni. Kumekke bolkyimerranj bu birri‑bom nawu Antibas nawu nungka kange‑woybuk‑ni. Ngardduk kunwok weykahweykang.” ");
INSERT INTO gupk_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","Mak ngayi nga‑karrme manbuyika kure bengdung ngudberre. Wanjh ngurri‑buyika ngudda ngurri‑munkekadjung bininj nawu Balam nawu ben‑bukkang bininj bu korokko kunkare. Kaluk nungka bi‑bukkang nabuyika bininj nawu Balak bu ben‑kuk‑borledkeng nawu Israel ben‑keb‑mawahmeng kure kunwarre birri‑yimeng bu manme birri‑nguneng manbu birri‑wong kure idols mak birri‑djirdmarrinj daluk bininj bu kunwarre‑kenh. ");
INSERT INTO gupk_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","Mak warridj birri‑buyika bininj ngudberre nawu kabirri‑kadjung kure nawu Nikolaytian bininj kabindi‑bukkan bedberre. ");
INSERT INTO gupk_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","Wanjh ngurri‑kange‑borledmen! Bu minj ngurri‑kange‑borledme, wanjh kunukka ngam‑re ngarri‑burren birrimekke bininj nawu bindi-bekkan Nikolaytians mandjawak dorrengh ngardduk bu ngam‑bebke kure kurrang ngardduk. ");
INSERT INTO gupk_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","Bu ngudda ngurri‑karrme kunkanem wanjh ngurri‑bekka kure baleh Nawaralmakkayken kaben‑marneyime nawu yiwarrudj bedberre bininj: Bininj nawu munguyh kabirri‑djale nakka wanjh kabirri‑winhme kure ngayi. Nakka ngaben‑won manbu ka‑warlkkarren manme manbu ‘manna’. Ngaben‑bebbeh‑won manwardde‑bele manbu manngey‑kerrnge duninjh kure ka‑bebbeh‑ngeydi. Wanjh minj nangale ka‑ngey‑bengkan, nungka na‑djal‑kudji ka‑bengkan nawu ka‑ngey‑mang. ");
INSERT INTO gupk_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","Mak Jesus ngan‑bengdayhkeng bu yawoyh yimeng ngardduk, “Mane wanjh yi‑bimbu nuye angel ka‑kan kure nawu yiwarrudj bedberre kabirrih‑ni kure ka‑bolk‑ngeyyo Thiyatira: Ngayi nawu Beywurd nuye Kod, ngarduk kumim kah‑rung yiman ka‑yime kunrak, mak kure kurrenge ngarduk nakka yiman steel kah‑rung ka‑waydi duninjh. Wanjh ngayi nga‑yime, ");
INSERT INTO gupk_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","“Ngayi nga‑bengkan kure ngudda ngurri‑kurduyime mak nga‑bengkan bu ngudda kandi‑marnedjare kure kandi‑woybukwon. Mak nga‑bengkan kure ngurri‑durrkmirri ngarduk, mak minj ngurri‑ngudj‑yawarren. Ngayi nga‑bengkan kure ngurri‑kurduyime kure kunwern ngayi ngarduk bu bolkkime, bu korroko ngurri‑durrkmirri kunyawurd. ");
INSERT INTO gupk_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","Ngayi nga‑widnan kunwarre kure bengdung ngudberre: ngalekke daluk Djezebel ngalu ngalwarre. Ngalengman marnbom bu ben-wurrhkeng bi-wokmulewam Kod. Kayakki, larrk. Ngalka wanjh ben‑bengwarrewong nawu ngayi ngandih‑marne‑durrkmirri. Ben‑bengwarrewong kure birri‑djirdmarrinj bininj daluk. Ben‑wong bedberre manme birri‑nguneng kure birri‑marne‑durrkmirri ‘idols’. Njale‑kenh ngurri‑wok‑marrkme ngalekke daluk? ");
INSERT INTO gupk_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","Ngayi nga‑madbom wardi bu warnyak‑mulewarrimeninj ngalengarre kure kunwarre yimehyimeng. Wanjh ngaleng minj ka‑djare bu ka‑bawon ngalengarre kunwarre. ");
INSERT INTO gupk_vpl VALUES ("RV2_22","096_2_22","REV","2","22","23","Ngayi wanjh nga‑kuk‑burriwe kure kubolk-warre kure ka-djak-bekkan. Mak birrimekke nawu bininj nawu kunwarre birri‑djarrk‑yimen ngaleng dorrengh wanjh nakka kabirri‑djak‑bekkan kunkimuk kure ngayi ngardduk. Wanjh bonj. Kaluk ngaben‑bun nawu ngaleng kabirri‑munkekadjung birribuyika bininj. Kaluk birrimekke bininj nawu kunwarre kaben‑bukkan, bu kabirri-kange-borledme wanjh minj ngaben‑bun. Wanjh birriwern bininj nawu yiwarrudj bedberre ba ngurri‑bengkan rowk kure ngayi nga‑djal‑kudji nawu kange‑bengkan rowk ngudberre kure nga‑bengkan kunmayali ngudberre bininj ngurri‑wern. Bu ngayi ngam-durndeng wanjh karremulewan ngadberre rowk kure baleh ngurri-yimeng. ");
INSERT INTO gupk_vpl VALUES ("RV2_24","096_2_24","REV","2","24","25","Wanjh ngudda ngurribuyika nawu kunred ngurrih‑ni kure Thiyatira minj ngurri‑kadjuyinj kure ben‑bukkang birri‑buyika bininj, minj ngudda ngurri‑borlhmeninj mane kunwok manbu kabirri‑ngeybun “Ka‑warlkkayindi manbu wayarra nawu Narderr Satan nuye mankarre‑dulmuk”. Bu ngurri‑djal‑wernh‑karrmen wernkih bu manmak bukkang ngudberre bu ngayi ngam‑re. Manekke wanjh mankudji ngurri-durrkmirri kure marneyime ngudberre. ");
INSERT INTO gupk_vpl VALUES ("RV2_26","096_2_26","REV","2","26","26","Bininj nawu munguyh kabirri‑djale nakka wanjh kabirri‑winhme kure ngayi. Bu birrimekke bininj ngandi‑marne‑durrkmirri kure ka‑yi‑ngurdmen rowk, wanjh ngaben‑won kunngudj bu kabindi‑marne‑worhnan kure bininj nawu birri‑djal‑wern rowk. ");
INSERT INTO gupk_vpl VALUES ("RV2_27","096_2_27","REV","2","27","27","Wanjh birrimekke bininj wanjh kabirri‑worhnan rowk kure birribuyika bininj bedberre kunrayek duninjh. Birri‑karrme kundulk yiman miyarrurl manekke kunngudj dorrengh. Mak kabindi‑kuk‑burriwe yiman ‘plate’ rerrih wanjh kabirri‑murrng‑bakabakme. ");
INSERT INTO gupk_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","Mane mankudji kunngudj kure ngan‑won nawu kornkumo ngardduk.Mak nga‑won nane bininj manbu kinhkin ka‑waydi bu kamh‑yibarrhbun. ");
INSERT INTO gupk_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","Bu ngudda ngurri‑karrme kunkanem wanjh ngurri‑bekka kure baleh Nawaralmakkayken kaben‑marneyime nawu yiwarrudj bedberre bininj.” ");
INSERT INTO gupk_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","Wanjh Jesus ngan‑yawoy‑bengdayhkeng, yimeng, “Kone yi‑bimbu nuye nawu andjel wanjh ka‑kan kure nawu yiwarrudj bedberre kabirrih‑di kure kunred ka‑bolk‑ngeyyo Sardis: “Ngayi Jesus ngah-yime. Ngayi nawu nga‑karrme 7 kunwaral mak 7 kinhkinh, wanjh kone nga‑yime: Nga‑bengkan bu baleh ngudda ngurri‑kurduyime. Wanjh bininj kabirri‑yime bu yimanek ngudda ngurri‑darrkid. Kayakki – ngudda woybukki ngurri‑doweng rowk. ");
INSERT INTO gupk_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","Wanjh ngurrim‑dolkkarrimen! Mak ngurri‑marnburrimen. Ngudda kunyahwurd kunngudj ngurri‑karrme, wardi mak ngurri‑ngudj‑dowen. Wanjh ngurri‑murrng‑rayek‑worrimen! Minj ngurri-ngudme bu ngurri‑marnedurrkmirri kure ngarduk Kod. ");
INSERT INTO gupk_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","Wanjh ngurri‑wernh‑karrmen nawu kunyungki ngurri‑mey mak kure ngurri‑bekkang. Wanjh ngurri‑woybukwon, bu ngudda ngurri‑kange‑borledmen. Bu minj ngudda ngurrim-dolkkan wanjh kunukka ngayi ngam‑re yiman bininj nawu molkno kam‑re ka‑ngimeng kure kurrambalk ka‑madj‑djirdmang yiman kunekke ka‑yime ngam‑re. Ngudda minj ngurri‑bengkan bu ngayi ngam‑re. ");
INSERT INTO gupk_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","Yikahwi bininj nawu ngurrih‑ni kure kunred Sardis bedda minj birri‑kange‑burlerri‑worrimeninj bu kunwarre birri‑yimeninj. Kaluk bedda ngarri‑djarrk‑re ngayi dorrengh nawu birri-kange-bele. Yiman ka-yime mak kunmadj bedberre nabele duninj kabirri‑djongburren. ");
INSERT INTO gupk_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","Bininj nawu munguyh kabirri‑djale, nakka wanjh kabirri‑winhme kure ngayi. Wanjh nakka kabirri‑djongburren nawu kunmadj madjbele duninjh. Kure kabirri‑ngeydi nakka minj ngaben‑ngey‑yerrke kure djurra nawu kabirri‑darrkid munguyh, wanjh nga‑marneyime nawu Kornkumo ngardduk mak nawu andjel nuye bu bedda nawu birrimekke nawu ngardduk bininj. ");
INSERT INTO gupk_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","Bu ngudda ngurri‑karrme kunkanem wanjh ngurri‑bekka kure baleh Nawaralmakkayken kaben‑marneyime nawu yiwarrudj bedberre bininj.” ");
INSERT INTO gupk_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","Wanjh Jesus ngan‑yawoyh‑bengdayhkeng, yimeng, “Kune yi‑bimbu nuye nawu andjel wanjh ka‑kan kure nawu yiwarrudj bedberre kabirrih‑di kure kunred ka‑bolk‑ngeyyo Filadefiya: Ngayi Jesus ngah-yime: Kone nga‑yime nawu ngakukdjamun duninjh mak ngawoybuk duninjh, nawu mak kure ngah‑karrme ‘key’ nawu Deybid (David) nuye. Ngayi nga‑rrangmarrhmang nawu dang‑no, minj nangale ka‑rrangbalhme. Minj nangale ka‑rrangmarrhmang kure ngayi nga‑rrangbalhme. ");
INSERT INTO gupk_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","Ngayi nga‑bengkan kure ngudda ngurri‑kurduyime. Wanjh ngayi nga‑rrangmarrhmang ngudberre manbu minj nangale ka‑rrang‑barlhme. Nga‑bengkan bu ngudda ngurri‑ngudjwarre. Wanjh ngurri‑woybukwon ngardduk kunwok. Minj kandi‑kukwakwan. ");
INSERT INTO gupk_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","Birrimekke bininj nawu Narderr Satan nuye, nakka wanjh kabirri‑yime yimanek bedda Djuws. Bedda kabirri‑kurren. Bedda minj woybukki bininj nawu Djuws. Ngayi ngaben‑marnbun bu kabirrim‑re kure ngudda bu kabirri‑bard‑durrungkurlhdanj kure kurrenge ngudberre. Wanjh kabirri‑mulewarren bu ngayi marne‑djarrk‑djare ngudberre. ");
INSERT INTO gupk_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","Ngudda kandi‑wok‑marrkmey ngayi, minj ngurri‑bawoyinj njalehnjale. Ngayi wanjh djal‑karrmeng ngudberre rowk kure kunrayek kunkimuk duninjh kam‑bebme bu ka‑yimerran rerrih kure kubolk‑warlah‑ken rowk bedberre. Kaluk kaben‑rohrokme bininj rowk nawu kondanj kukurlk ngurri‑djarrk‑ni. ");
INSERT INTO gupk_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","Ngayi bolkkime ngam‑yawoy‑durndeng. Wanjh ngurri‑wernh‑karrmen nawu kunyungkih ngurri‑mey. Minj nangale ngun-ngurdke kure ngurri-winhme. ");
INSERT INTO gupk_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","Bininj nawu ngandi‑woybukwon munguyh wanjh nakka ngaben‑marnbun bu kabirri‑murrng‑rayekmen, mak ngaben‑kurrme kure God nungka Temple nuye. Kaluk bedda minj kabirri‑bolk‑bawon kumekke kabirri‑ni munguyh. Mak ngaben‑ngey‑bimbun kure kunburrk bedberre manbu kunngey nuye God ngardduk, mak kunngey ngalengarre kubolk‑kimuk nuye. Kaluk kabolk‑ngeyyo Mankerrnge Djerusalem kam‑kolung kaddum‑beh kure ngardduk Kod kah‑ni. Ngaben‑marne‑ngey‑kurrmerren ngardduk kunngey‑kerrnge kure bedberre kukange. ");
INSERT INTO gupk_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","Bu ngudda ngurri‑karrme kunkanem wanjh ngurri‑bekka kure baleh Nawaralmakkayken kaben‑marneyime nawu yiwarrudj bedberre bininj. ");
INSERT INTO gupk_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","Wanjh Jesus ngan‑yawoyh‑bengdayhkeng, yimeng, “Kone yi‑bimbu nuye andjel, wanjh ka‑kan kure nawu yiwarrudj bedberre kabirrih‑di kure kunred kabolk‑ngeyyo Layodiseya. Ngayi Jesus ngah-yime: Ngayi nawu nga‑ngeyyo Wanjh Bonj, ngayi nga‑mulewam bu kunwoybuk dorrengh. Ngayi wanjh nga‑worhnan rowk kure Kod marnbom. ");
INSERT INTO gupk_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","Ngayi nga‑bengkan kure ngurri‑kurduyime bu ngudda minj ngurri‑kange‑rung mak minj ngurri‑kange‑bonjdjek. Minj nga-djare ngurri-kange-monek. ");
INSERT INTO gupk_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","Wanjh ngudda minj ngurri‑kange‑rung mak minj ngurri‑kange‑bonjdjek wanjh ngayi, kukbebke ngudberre kure kurrang ngardduk, yiman ka-yime nga‑nunjwe. ");
INSERT INTO gupk_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","Ngudda ngurri‑yimerran, “Wanjh ngad karri‑kuken mak karri‑mang kunwern, minj njale mak karri‑yawoyh‑djare!. Minj njale mak wanjh bonj.” Minj ngurri‑kuk‑bengkarren bu ngudda ngurriwarre bininj bu ngurri‑marladj mak ngurri‑mim‑dubbe mak ngurri‑kuk‑larrk. ");
INSERT INTO gupk_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","Ngayi wanjh bengdayhke ngudberre ngurrim‑ray ba won ngudberre ‘gold’ yiman ka‑marlamarlme, nawu marnburrinj kure kunrak ba ngudda ngurri‑kukenmen. Mak ngurrim‑ray, won ngudberre kunmadj‑bele ba ngurri‑djongburren mak ngurri‑kuk‑balhmerren ba bu minj ngurri‑yawoyh‑yeme. Mak ngurrim‑ray won ngudberre ‘medicine’ bu ngurri‑mim‑barurren kure kumim ngudberre wanjh ngurri‑wernh‑mim‑bayhme wanjh ngurri‑bolknan. ");
INSERT INTO gupk_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","Ngayi bengyolyolme ngudberre bu mandjad mak bengdung ngudberre kure woybukki bu marnedjare ngudberre. Kunmayali ngurri‑bekka ba ngurri‑bawon kunwarre kure ngurrih‑yime. ");
INSERT INTO gupk_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","Ngayi kondanj ngah‑di! Ngayi ngah‑di kuberrk kure kurrangmaye, ngah‑dangdong. Bu ngayi kandi‑bekkan ngurri‑dangmarrhmang, wanjh ngayi ngam‑ngimen, karri‑djarrk‑ngun manme. ");
INSERT INTO gupk_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","Bininj nawu kabirri‑djale munguyh, wanjh kabirri‑winhme kure ngayi. Wanjh nakka ngarri‑djarrkni kure ngardduk ‘throne’, yiman ngayi nga‑winhmeng bu wayarra nawu Satan Narderr kure nga‑ngudj‑yakwong bu kune wanjh ngane‑djarrkni ngardduk Kornkumo kure nungka nuye ‘throne’. ");
INSERT INTO gupk_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","Bu ngudda ngurri‑karrme kunkanem wanjh ngurri‑bekka kure baleh Nawaralmakkayken kaben‑marneyime nawu yiwarrudj bedberre bininj. ");
INSERT INTO gupk_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","Kaluk kumekke nga‑waralnang kubuyika. Nga‑nang kure kumim ngardduk dangmarrhmey kure kubolkmak heaven. Namekke nakudji kunyungkih ngan‑marnewokdi yiman trumpet rerrih, wanjh ngan‑marneyimeng, “Yim‑ray kondanj kure kaddum heaven, ngayi bukkan ngudda bu baleh kaluk ka‑bolkyimerran bu rerrih.” ");
INSERT INTO gupk_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","Wanjh kunekke rerrih nawu Nawaralmakkaykenh ngan‑kang, wanjh kumirrk ngardduk nga‑nang throne manbu kah‑di kure kubolkmak Heaven, kaluk kumekke nga‑nang nakudji rerrkang. ");
INSERT INTO gupk_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","Kumekke nga‑nang nungka ningih‑ni kure throne nakka kunburrk nuye kukyimeng yiman kunwardde manmak yiman jasper mak carnelian marlamarlhmeng. Bi‑borledminguneng kumekke kure throne kukyimeng yiman ngalyod ka‑medjyime nawu medjmak duninjh mak waydi. ");
INSERT INTO gupk_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","Kumekke nga‑nang ‘throne’ birri‑borledminguneng 24 thrones kumekke birrih‑ni 24 dabborrabbolk. Kaluk bedda birri‑djongburrinj nawu namadj‑bele kunmadj mak gold kodjburrh birrim‑kodj‑djongburrinj. ");
INSERT INTO gupk_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","Nga‑nang namarrkon mayhkeng ngurdulmeng kure kumekke throne. Nga‑nang kure kumirrk ngalengarre manekke throne, 7 djarlk ruy manbirli‑kimuk, kaluk makka 7 kunwaral nuye God. ");
INSERT INTO gupk_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","Mak kumekke kure kumirrk ngalengarre throne manekke kurrula bo‑marnburrinj, bo-beleminj yiman budjdjulung wanjh bo‑waydi yiman ka‑yime crystal. Kure kuburldjdjarn manekke throne birri‑borledminguneng 4 mayh nawu birri‑darrkidni. Bedda kabirri‑karrmeng manwern kunmim kure kumirrk bedberre mak kure kubodme. ");
INSERT INTO gupk_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","Nawu nayungki mayh ka‑kukyime yiman lion. Nabuyika mayh ka‑kukyime yiman bulikki. Nabuyika mayh ka‑kukyime yiman bininj. Nabadbuyika mayh nga‑nang nakka ka‑kukyime yiman marram ka‑rrolkan. ");
INSERT INTO gupk_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","Birrimekke mayh ka‑birri‑bebbeh‑karrme 6 medjek. Kunburrk bedberre kabirri‑karrme kumim manwern. Kabirri‑karrme kumim kure kandji kuwanj bedberre. Birrimekke 4 mayh kabirri‑yime benbekad‑kuyeng mak kunkak‑kuyeng. Minj kabirri‑ngurdme, munguyh kabirri‑yime, “Nakukdjamun! Nakukdjamun! Nakukdjamun Kod nawu ka‑djalworhnan munguyh nawu ngudj‑kimuk duninjh! Nawu ningihni kunyungkih duninjh, mak ka-djal-ni bolkkime, mak nawu ka-djal-darrkid munguyh munguyh. ” ");
INSERT INTO gupk_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","Birrimekke nawu 4 mayh kabirri‑darrkidni, kabirri‑burlume mak kabirri‑makwan, mak kabirri‑manjbun nadjalkudji nawu kah‑ni kure throne kure ka‑rrarrkid munguyh munguyh. ");
INSERT INTO gupk_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","Wanjh nawu 24 dabborrabbolk munguyh kabirri‑mankang kumirrk nuye nawu kah‑ni kure throne. Mak kabirri‑manjbun nawu darrkid munguyh. Mak kabirri‑kodj‑yerrkkerren nawu kabirri‑kodj‑djongburren nawu kodjburrh bedberre. Wanjh kabirri‑kurrme kure kumirrk ngalengarre throne. Wanjh kabirri‑marneyime, ");
INSERT INTO gupk_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","“Ngudda nawu yi‑djal‑wernh‑kimuk duninjh, nawu Yiworhnan God ngadberre, wanjh kunekke‑kenh ngad ngundi‑burlume, ngad nawu ngundi‑wok‑marrkmey, ngundi‑woybukwon. Wanjh ngundi‑mulewan bu ngudda yi‑ngudj‑kimuk duninjh. Yoh, ngudda yi‑marnbom yehyeng rowk. Mak kure yi‑wokdi kure marnburrinj rowk, ka‑djal‑di rowk kure yingan yi‑djareni.” ");
INSERT INTO gupk_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","Wanjh nga‑nang djurra nawu scroll dornnameng kure kubid nuye namekke nawu kah‑ni kure throne. Kaluk namekke nawu scroll bimdi kure kumirrk, kubodme. Dangbalhmirranj kure 7 ngolin nawu yiman bidi kure belbmeng. ");
INSERT INTO gupk_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","Wanjh nga‑nang andjel nawu ngudjkimuk‑kenh kam‑wokdi wernkih. Yimeng, “Nangale nawu bininj namak ka‑bakke ngolin nawu wanjh ka‑rrangmarrhmang nawu djurra scroll? Na-djal-kudji nawu ka-bengkan ka-rrangmarrhmang djurra. ");
INSERT INTO gupk_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","Minj nangale ka‑rrangmarrhmang. Minj birri‑dangmarrhmayinj nawu bininj nawu kabirrih‑ni kure kaddum mak kondanj kabirrih‑ni kure kukurlk mak kanjdji duninjh kabirrih‑ni. Nangale minj bim‑nayinj kure ka‑wokbimdi. ");
INSERT INTO gupk_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","Ngayi wanjh nga‑nalkbom wernkih minj nangale namak bu dangmarrhmayinj nawu djurra scroll bu bimnayinj kure kururrk. ");
INSERT INTO gupk_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","Nakudji nawu narrabbolk ngan‑marneyimeng ngayi, “Yun yi‑nalkbun! Nakudji bininj kam‑re nawu kunyungki winhmeng. Nungka yiman ka‑yime nabang mayh nawu lion. Kaluk namekke danginj kure namud nuye Djudah. Mak Deybid (David) bi‑kebmawahmeng nuye. Nungka wanjh nadjalkudji ka‑rrangmarrhmang nawu djurra scroll. ");
INSERT INTO gupk_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","Wanjh nga‑nang nawu Kod nuye Lamb dingih‑di kure kuburldjdjarn darnkih kure throne, kukyimeng yiman mayh nawu yiman sheep nawu birri‑bom. Ngaben‑nang warridj 4 mayh nawu birri‑darrkidni mak dabborrabbolk warrinj ngaben‑nang birri‑borledminguneng nawu Lamb. Nungka wanjh ka‑karrme 7 kunkanemdulk mak 7 kunmim, nakka wanjh 7 kunwaral nuye Kod nawu ben‑munkeweng kure kubolk‑warlah‑kenh kure kukurlk. ");
INSERT INTO gupk_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","Nga-nang rerrkang kure throne, wanjh nawu Lamb kam‑wam, mey namekke djurra nawu scroll kure kubidkun nuye. ");
INSERT INTO gupk_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","Bu kumekke mey nawu djurra scroll, wanjh nawu 4 mayh nawu birri‑darrikidni, mak nawu 24 dabborrabbolk birri‑marne‑mankang kure kumirrk nuye nawu Lamb. Kumekke wanjh birri‑bebbeh‑karrmeng birri‑dirri nawu harps. Mak gold ngalanno birri‑karrmeng nawu ka‑rrahkendi kalkidno manmak duninjh kure kabirri‑kinje kundolng ka‑marnburren wanjh kabirri‑nome ka‑ban manmak duninjh yiman perfume kure yiwarrudj ngalengarre kabirrih‑di Kod nuye bininj. ");
INSERT INTO gupk_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","Wanjh kumekke birri‑wayini kure mankarre‑kerrnge nuye Lamb. Birri‑yimeng, “Ngudda yi‑makkaykenh duninjh bu yi‑mang nawu djurra scroll, wanjh yi­‑rrangmarrhmang ngalengarre ngolin nawu bidi. Ngudda wanjh kunyungki yi‑rroweng, kure mak ngundi‑bom, yi‑kurlbawam. Kunkurlba ke ngudda yiben‑dundiweng rowk kure bininj nuye Kod kure birri‑mud‑buyika rowk, mak birri‑wok‑buyika rowk, mak birri‑kurlah‑buyika rowk, mak nawu kubolk‑buyika rowk kabirrih‑ni. Yiben‑kukbayahmeng bininj rowk, yiben‑kang rowk kure Ngabbard. ");
INSERT INTO gupk_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","Ngudda yiben‑marnbom bedberre bininj bu kabirri‑yimerran djungkay nuye kabirri‑marne‑durrkmirri nawu kadberre Kod, wanjh bedda kaluk rerrih kabirri‑worhnan kondanj kure kukurlk kunred. Wanjh bu kunekke ngudda yi-rrangmarrhmey nawu djurra.” ");
INSERT INTO gupk_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","Ngayi nga‑bolknang, mak ngaben‑bekkang birriwern andjel, kabirri‑kukdokme bindi‑borledminguneng nawu dabborrabolk mak nawu mayh birri‑darrkid mak nawu nungka Lamb kure kubuldjdjan kah‑di. Bedda wanjh andjel birri‑djal‑wern birri‑kaberrk‑wern duninjh millions mak millions. ");
INSERT INTO gupk_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","Wanjh birri‑wayini birri‑bolkboyhmikang duninjh. Birri‑yimeng, “Nane Lamb nawu birri‑bom, nungka nawu namakkaykenh duninjh bu ka‑karrme kunngudj rowk kure ka‑kukenmen duninjh, kure kunmayali ka‑karrme manmak, mak kunkurddu nuye. Ngundi‑ngey‑kimuk‑won duninjh, kure ngundi‑wok‑marrkmey bu ngad ngundi‑djal‑wernh‑burlume duninjh.” ");
INSERT INTO gupk_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","Kumekke ngaben‑bekkan birriwern kabirri‑wayini, kure kaddum kabirrih‑ni mak kabirri‑wayini kondanj kure kukurlk karrih‑ni, mak kure kanjdji duninjh kure ngalengarre kunred kabirrih‑ni, mak kure kurrula kabirrih‑ni kabirri‑wayini. Wanjh bedda kabirri‑djal‑wayini bu munguyh munguyh. Kabirri-yime, “Nuye Kod nawu kah‑ni throne, nawu mak Lamb ngarrben‑djal‑burlume munguyh. Bedda wanjh bene‑ngey‑kuken duninjh. Bene‑woybuk kure kunmak, kure mak kunngudj berrewoneng bu kabene‑worhnan munguyh munguyh.” ");
INSERT INTO gupk_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","Wanjh nawu mayh 4 nawu birri‑darrkidni birri‑yimeng, “Bonj”. Wanjh dabborrabbolk birri‑mankang, bindi‑burlumeng berrewoneng Ngabbard, Lamb. ");
INSERT INTO gupk_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","Nawu Lamb nuye Kod ka‑djal‑karrme scroll kure kubid nuye munguyh. Ngayi nga‑nang Lamb dangmarrhmey nakudji ngolin nawu bidi. Wanjh nga‑bekkang nakudji mayh nawu narrarkkid wokdi wokyimeng yiman namarrkon, yimeng “Yim‑ray!” ");
INSERT INTO gupk_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","Wanjh ngayi nga‑bolknang kumekke kure kumirrk ngardduk nga‑nang djarrang dingih‑di nawu kukbele. Bininj nawu barndi kure djarrang karrmeng bunarrang mak bi‑wong ka‑karrme kodjkolng crown. Wanjh wam, bebmeng kure djarrang nuye. Kaluk nungka nabang nawu bu ka‑winhme munguyh kure ka‑djare kaben‑bun bininj rowk kure kabirri‑burren‑kenh. ");
INSERT INTO gupk_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","Nawu Lamb dangmarrhmey nabuyika ngolin nawu bidi wanjh kumekke nga‑bekkan nabuyika mayh nawu narrarrkid yimeng, “Yim‑ray!” ");
INSERT INTO gupk_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","Wanjh kukbuyika bininj kam‑barndi kure djarrang nawu kukkurlba. Nakka wanjh ka‑karrme kunrid kaben‑marnbun bininj kabirri‑burren mak kabirri‑yolyolmerren. Kaben‑marnbun bininj bu kabirri‑burren kondanj kukurlk, nawu bi‑wong sword mandjawak nakimuk‑kenh. ");
INSERT INTO gupk_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","Nga‑nang Lamb dangmarrhmey nabuyika ngolin. Nga‑bekkang nabuyika mayh nawu narrarrkid yimeng, “Yim‑ray!” Wanjh nga‑bolknang nga‑nang ngardduk, mak nga‑nang ngal‑kuk‑kurlduk djarrang, kamh‑barndi bininj ka‑karrme “scales” kure kubid nuye ka‑rohrokme njalehnjale. ");
INSERT INTO gupk_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","Wanjh nga‑bekkang yiman kam‑wokdi kure kuburldjdjarn bedberre mayh nawu birri‑darkkid. Bu wokdi yimeng, “Minj ka‑wernh‑djordmen manme. Bu ngudda yi‑djare yi‑yawoyh‑bayahme manme nguddangke. Ka‑bidbun nawern kunwardde (money). Kure nawern kunkalkid oil mak wine kunbang.” ");
INSERT INTO gupk_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","Mak kunyawoyh‑kudji nawu Lamb yawoyh‑dangmarrhmey nabuyika ngolin. Mak nga‑bekkang kam‑wokdi kukbuyika mayh nawu narrarkkid, yimeng, “Yim‑ray!” ");
INSERT INTO gupk_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","Nga‑nang djarrang nawu medj‑yimeng kunyahwurd yiman kurlah-buyika. Bininj nawu kabi‑mornekan nakka ngeyyoy ‘Kundowikenh’. Nabuyika bininj bi‑munkekadjuy. Nungka ka‑ngeyyo ‘Kumekke kunred kure bininj nawu birri‑doweng kabirri‑dukkayindi’. Nakudji ben‑munkeweng, ben‑marneyimeng, “Ngurri‑ray ngurrben‑bun kure kubolkbuyika kabirrih‑ni. Birribuyika ngurrben‑bawon.” Benebokenh kabindi‑bun mandjawak dorrengh. Birribuyika mak kabindi‑marnbun bu kabirri‑dowen kunmarrwe. Birribuyika mak kundjak kaben‑bun. Birribuyika bininj mayh kabindi‑bun. ");
INSERT INTO gupk_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","Nawu wanjh Lamb dangmarrhmey nabuyika‑wali ngolin, wanjh nga‑bolknang kandji kure altar kunmalng bedberre birrimekke nawu bindi‑bom kure birri‑woybukwong Kod nuye kunwok, mak birri‑weykang Kod nuye kunwok. ");
INSERT INTO gupk_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","Wanjh birrimekke bedberre kunmalng birri‑kayhmeng wernkih, bu birri‑yimeng, “Yi‑kukdjamun nawu Yi‑woybuk kure Yi‑worhnan Yi‑kimuk, baleh kure ka‑bolkyime bu yiben‑djadme bininj kure kondanj kukurlk kabirrih‑ni mak yiben‑mangdurndiwe kure ngad‑kenh kure ngandi‑bun ngadberre?” ");
INSERT INTO gupk_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","Bindi‑wonowong kunmadj nawu kornam-kuyeng nawu nabele, wanjh bindi‑marneyimeng bu kabirri‑madbu kunyawu‑kuyeng, birribuyika mak nawu djakerr, yabok kabindi-bun, kabirri-doweng bedda nawu karri‑djarrk‑marnedurrkmirri nuye Kod. Wanjh bonj. Kod ka‑bengkan bu birringale bininj. ");
INSERT INTO gupk_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","Nga‑djal‑nang munguyh nawu Lamb bu dangmarrhmey nawu 6th ngolin, kure bolkroh‑bolkrokang bu wernkih duninj, mak kundung makka mununminj yiman burlerriminj. Nawu dird kukbuyikahminj kurlbahminj yiman kunkurlba rerrih. ");
INSERT INTO gupk_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","Mak kinhkin kure kungol‑beh kam‑warrahwarrhmeng kure kondanj kukurlk yiman manme manbu mandak ka‑warrahwarrme kure kunkurra mankimuk ka‑woh‑djorrhke kundulk. ");
INSERT INTO gupk_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","Manbu kunngol makka yakminj yiman djurra scroll dornamerrinj. Mandulum rowk mak manyunkurr rowk makka djirrkkarrinj rowk kure kubolk‑buyika. ");
INSERT INTO gupk_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","Wanjh birriwern bininj kabirri‑warlkarren kure kuwardde‑wardde‑rurrk kure mandulum ngalengarre. Bininj nawu birrikodjkimuk kabirri-warlkarren, mak bininj nawu kabindi‑marne‑worhnang kure army, mak nawu birri‑kuken. Mak bininj nawu kabirri‑dukkayindi, mak birribuyika bininj rowk, bedda rowk birri-warlkarren kure kuwardde-wardde-rurrk kure mandulum ngalengarre. ");
INSERT INTO gupk_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","Mak birri‑marne‑kayhmeng manbu kunwardde bu birri‑marneyimeng, “Yim‑wardde‑warrhmen, kan‑barrkbun ngadberre, kan‑warlkan ngadberre kure Kod nawu kah‑ni kure throne, nawu kure Lamb bu bedda ngandi‑dung ngadberre. ");
INSERT INTO gupk_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","Manekke benbekad korroko wanjh kam‑wam! Bu Kod mak nawu Lamb kabene‑bebke kunkange‑rid berrewoneng, nangale minj kaben‑mirrkmang berrewoneng. ");
INSERT INTO gupk_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","Bu kumekke ngaben‑nang nawu 4 andjel birri‑bebbeh‑di kure koyek, karrikad, walem, kakbi, birri‑di kure kondanj kukurlk. Birri‑kurra‑barlhmeng bu minj baleh kurrabuyinj kure kondanj kukurlk ngalengarre mak kure kurrula mak kure kundulk manwern. ");
INSERT INTO gupk_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","Wanjh nga‑nang nabuyika andjel kam‑bidbom koyek‑beh, karrmeng yiman ka-yime djirddudjirddu nawu karri-belbme, nuye Kod nawu Kah‑djal‑darrkidni Munguyh. Wanjh ben‑kayhmeng wernkih duninjh nawu birribuyika andjel nawu Kod ben‑wong kunngudj nuye kure kabirri‑bolk‑warrewon kure kondanj kukurlk kure mak kurrula rowk. ");
INSERT INTO gupk_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","Wanjh namekke andjel yimeng bedberre, “Yun ngurri‑bangme‑bolkbun, yun ngurri‑bun njalehnjale kure kumekke kunred. Med rerrih ngad bu ngarrben‑milh‑belbme werrk nawu djirddudjirddu naw bininj kabirri‑marne‑durrkmirri nuye nawu ngad kadberre Kod.” ");
INSERT INTO gupk_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","Kaluk nga‑bekkang bu baleh kabirri‑yime bininj kure bindi‑rohrokmeng bu bindi‑milh‑belbmeng kure kunngey. Nakka wanjh 144 thousand bininj kure nawu namud rowk bedberre ben‑kebmawahmeng kure Israel baburr bedberre. ");
INSERT INTO gupk_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","Nawu kunmilh bedberre di kunngey bininj nawu birrim‑kaberrk‑dolkkang kure namud nuye Djudah, nakka wanjh bindi‑rohrokmeng 12 thousand. Mak nawu Ruben nuye namud kunekke rerrih 12 thousand bininj. Mak nawu Gad nuye namud kunekke rerrih 12 thousand bininj. ");
INSERT INTO gupk_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","Mak nawu Asher nuye namud kunekke rerrih 12 thousand bininj. Mak nawu Nabdali namud birrim‑dolkkang kunekke rerrih 12 thousand bininj. Mak kure Manasa nuye namud kunekke rerrih 12 thousand bininj. ");
INSERT INTO gupk_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","Mak kure Simeyon nuye namud, kunekke rerrih 12 thousand bininj. Mak nawu Levi kunekke rerrih 12 thousand bininj. Mak nawu Isakar kunekke rerrih 12 thousand bininj. ");
INSERT INTO gupk_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","Mak nawu Zebyulun kunekke rerrih 12 thousand bininj. Mak Djoseb kunekke rerrih 12 thousand bininj. Mak Bendjamin kunekke rerrih 12 thousand bininj. Birrimekke bininj birri‑karrmeng kunngey kure kumilh bedberre. ");
INSERT INTO gupk_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","Kumekke wanjh ngayi nga‑bolknang, ngaben‑nang, birri‑kaberrkdi nawu birri‑djalwern bininj, minj nangale bininj kaben‑rohrokme nakka birri‑djal‑kaberrk‑wernminj kure bedda birrim‑dolkkang kure kubolk‑bubuyika rowk, mak birri‑nguya‑buyika rowk, mak birri‑kurlah‑buyika rowk, mak birri‑wok‑buyika rowk nawu kondanj kure kukurlk‑beh birrim‑dolkkang‑beh. Wanjh birri‑kaberrkdi rowk kure kumirrk ngalengarre throne, mak kure nawu Lamb. Kaluk kabirri‑djongburren nawu namadj‑kuyeng kunmadj nawu madjbele. Birri‑bebbeh‑karrmeng kunworr manbu kulwirri kure kubid bedberre. ");
INSERT INTO gupk_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","Wanjh bedda birri‑wernh‑kayhmeng kaddum. Birri‑yimeng, “Kod nawu kadberre kah‑ni kure throne, mak nawu Lamb warridj, nawu kabene‑karrme kunngudj bu ngad kandi‑darrkidwon kadberre. Nawu kan‑kukmarnbom kadberre Kod.” ");
INSERT INTO gupk_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","Wanjh birriwern andjel birri‑di bu birri‑borledminguneng manekke throne mak nawu dabborabbolk mak mayh nawu birridarrkidni, wanjh birri‑bard‑durrungkurlhdanj rowk kure kumirrk ngalengarre throne. Bedda birri‑burlumeng Kod bu birri‑yimeng, ");
INSERT INTO gupk_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","“Wanjh bonj! Ngudda nawu Kod ngadberre, wanjh ngudda ngundi‑burlume, wanjh ngundi‑marneyime kunmak, ngudda nawu Yimakkaykenh duninjh, kure yi‑wernh‑bengkan rowk, ngudda ngundi‑manjbun wanjh ngundi‑wok‑marrkmey ngudda nawu yi‑ngudjkimuk duninj, bu yi‑karrme kunngudj rowk, makka wanjh nguddangke rowk bu munguyh munguyh! Wanjh bonj!” ");
INSERT INTO gupk_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","Nakudji dabborrabbolk ngan‑djawam, “Nane baleh‑beh bininj birrim‑dolkang nawu kabirri‑djongburren kunmadj madjbele? Bedda baleh birrim‑dolkang?” ");
INSERT INTO gupk_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","Ngayi wanjh nga‑wokmey, nga-marneyime, “Ngayi ngaben-wakwan bininj baleh beh birrim-dolkang.” Wanjh nane nawu dabbolk ngan‑marneyimeng, “Nane bininj birrim‑bebmeng kure birri‑djak‑bekkang. Mak kunmadj bedberre birri‑djirridjbom birri‑madj‑beleworrinj kure kunkurlba nuye nawu Lamb. ");
INSERT INTO gupk_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","Wanjh koneng‑kenh bedda kabirrih‑di kure kumirrk ngalengarre throne kure Kod kah‑ni, kure kabirri‑marne‑durrkmirri nuye munguyh bu benbekad‑kuyeng mak kunkak‑kuyeng kure kururrk djamun nuye. Nakka kaben‑djal‑bengkan kure ben‑marne‑kodbarrebom kure kabirri‑djarrk‑ni nungka dorrengh. ");
INSERT INTO gupk_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","Bedda minj kabirri‑yawoyh‑marrwedowen mak minj kabirri‑yawoyh‑kombukdowen mak manbu kundung minj kaben‑kinje, kabirri‑lardmen. ");
INSERT INTO gupk_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","Wanjh nawu Lamb kure kah‑di kuburldjdjarn throne, namekke wanjh nawu shepherd bedberre, kaben‑nahnan munguyh munguyh. Nungka wanjh kaben‑marnedokme kaben‑kan kunronj manbu njilhmi kure kah‑boyo kure kaben‑darrkidwon bininj. Mak Kod kaben‑mim‑nalk‑djirridjbun kure minj kabirri‑yawoyh‑mim‑nalkre. ");
INSERT INTO gupk_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","Kune yakminj rowk, wanjh ngayi Djon nga‑bekkang yiman bininj birri‑djalwern rowk kure kaddum heaven birri‑kayhmeng kumekke birri‑yimeng, “Halleluyah! Karri‑manjbun Kod ngadberre nawu nakudji Namakkaykenh Duninjh mak Nangudj‑kimuk Duninjh! Nakudji nawu ka-karrme kunngudj bu ngad kandi‑darrkidwon kadberre. Nakudji nawu kan‑kukmarnbom kunngudj bu ngad kandi‑darrkidwon kadberre. Nawu kan‑kange-marnbom kadberre bininj. ");
INSERT INTO gupk_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","Nungka wanjh kan‑djadme bu woybukki kure mandjad duninjh! Nungka bi‑djadmeng mak bi‑warreweng ngalekke ngalwarre duninjh ngalbu daluk ka‑ngeyyo Babylon ngalu ben‑bengwarrewong birridjalwern bininj rowk kure kondanj kukurlk, wanjh birriwarre duninjh. Ngaleng ben‑bom nawu Kod nuye bininj, wanjh Ngabbard bi‑bom bu ben‑kangdurndiweng.” ");
INSERT INTO gupk_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","Wanjh bininj kure Kaddum birrih‑ni birri‑yawoyh‑kayhmeng, bu birri‑yimeng, “Halleluyah! Ngalekke Babylon kah‑rung, wanjh kundolng ngalengarre makka wam kaddum bu munguyh munguyh.” ");
INSERT INTO gupk_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","Wanjh birrimekke nawu bininj 24 Dabborrabbolk mak nawu 4 mayh nawu birri‑darrkidni, birri‑marne‑mankang nuye Ngabbard nawu kah‑ni kure throne mak birri‑manjbom nuye. Bedda birri‑yimeng, “Wanjh bonj! Halleluyah! Karri‑manjbun Kod” ");
INSERT INTO gupk_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","Wanjh kumekke kam‑wokdi kure ningih‑ni throne nuye yimeng, “Karri‑djal‑manjbu kadberre Kod nawu ngudda ngurri‑marne‑durrkmirri mak nawu ngurri‑djare ngurri‑wok‑marrkmang, ngudda nawu wurduh‑wurdurd mak nawu ngurri‑kihkimuk!” ");
INSERT INTO gupk_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","Wanjh kumekke nga‑bekkang yiman bininj birri‑kaberrk‑wern birri‑kayhmeng wernkih duninjh, kure wokyimeng yiman kunronj kure kam‑bowarrhme kam‑bokoluy, mak wokyimeng yiman namarrkon ka‑ngurdulme. Kumekke wanjh birri‑yimeng, “Halleluyah! Kod nawu kadberre nawu Ngudj‑kimuk Duninjh kure Yi‑worhnan rowk kunred! ");
INSERT INTO gupk_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","Wanjh ngad karri‑djurrkwo mak karri‑njilng‑makmen kure karri‑mulewan bu Kod nawu Namakkaykenh, Nangudj‑kimuk kadberre. Wanjh Lamb bu kabene‑marren ngalu daluk kah‑di kure kaddum wanjh ngalekke ngalbininjkobeng nuye. Wanjh bi‑yingkih‑marne‑marnburrinj bu nungka nuye kabene‑marren. ");
INSERT INTO gupk_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","Nungka bi‑wong kunmadj nawu namak manburrba nawu linen nawu ka‑bame nawu nabele duninjh, bu kure ngaleng ka‑djongburren.” (Kaluk nawu linen manburrba, nakka wanjh kabi‑kodjmulewan kure njalehnjale kunmak birri‑kurduyimeng kure Kod nuye bininj. ");
INSERT INTO gupk_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","Wanjh andjel ngan‑yawoyh‑marneyimeng, “Mane yi‑bimbu rowk: “Kure kabirri‑njilngmak kure Lamb kaben‑kayhme kabirrim‑re kabirri‑djarrk‑ngun manme kure mulil ngalengarre bu kabene‑marren kure nawu Lamb nuye daluk.” Nawu andjel yawoyh‑yimeng, “Mane wanjh woybukki kunwok nuye Kod.” ");
INSERT INTO gupk_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","Wanjh kune nga‑bekkang ngayi nga‑mankang kure kurrenge nuye andjel wanjh nga‑boddi, wanjh ngan‑marneyimeng, “Yun ngayi kan‑marne‑boddi! Ngayi nga‑rrurrkmirri nuye Kod yiman ngudda kure mak ngurri‑danginj kure birri‑karrme kunwok kure manwoybuk nuye Jesus. Birrikare birri-mulewam manekke kunwok manwoybuk nawu kure Jesus. Mah, wanjh Kod yi‑marne‑boddin!” ");
INSERT INTO gupk_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","Ngayi Djon nga‑nang kaddum dang‑marrhmey kure kumirrk ngardduk. Nga‑nang djarrang dingihdi nawu kuk‑bele. Wanjh nga‑nang bininj barndi kure djarrang. Nungka nawu ngeyyoy “Na‑kange‑woybuk”, mak warridj ngeyyoy “Nawoybuk Duninjh”. Nungka wanjh kan‑djadme kadberre bininj rowk kure mandjad duninjh mak minj kan‑bangmibun kure ngad bininj, kaben‑bun birriwarre bininj. ");
INSERT INTO gupk_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","Kure kumim nuye makka yiman kunrak kah‑rung. Kure kukodj mak ka‑kodj‑djongburren nawern kodjkolng. Mak kunngey nuye bimdi kure nungka, minj nangale ka‑bengkan, nungka wanjh nadjalkudji ka‑bengkan. ");
INSERT INTO gupk_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","Nungka kuk‑djongburrinj kunmadj madj‑kuyeng kunkurlba dorreng djuhmeng. Nungka bininj ka‑ngeyyo “Kunwok nuye Kod”. ");
INSERT INTO gupk_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","Nawu djawirna kabirrih‑ni kure kaddum nawu Kod nuye djuram rowk. Bedda wanjh birri‑munkekadjuy namekke bininj nawu barndih‑barndi ngal‑kuk‑bele djarrang. Bedda wanjh birri‑djarrk‑barndi kure birri‑kuk‑bele djarrang. Birri‑djongburrinj namakkaykenh kunmadj nawu madjbele . ");
INSERT INTO gupk_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","Kaluk kure nuye kurrang‑beh bebmeng nuye mandjawak mirrhmak, nawu ka‑karrme kure kaben‑bun bininj nawu kubolk‑bubuyika rowk. Kaluk nungka kaben‑marne‑worhnan kumekke kure kunred kabirrih‑ni. Nungka ka‑karrme kundulk yiman miyarrurl manekke kunngudj dorrengh. Nungka kaben‑djuyme bedberre yiman grapes. Nungka ka‑kurduyime kure kunkange‑rid nuye God Ngabbard nawu ngudj‑kimuk duninjh. ");
INSERT INTO gupk_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","Kaluk kure kunmadj nuye ka‑djongburren mak kure kundad nuye ka‑ngeydi “Nakodjkimuk nawu Ka‑djalwernhworhnan Rowk.” ");
INSERT INTO gupk_vpl VALUES ("RV19_17","096_19_17","REV","19","17","17","Wanjh nga‑nang andjel dingih‑di kure kundung. Wanjh ben‑marne‑kayhmeng wernkih duninjh bedberre marram, warrk, djawurndu. Ben‑marneyimeng, “Ngurrim‑ray. Ngurri‑kaberrk‑raworrinj kure mankimuk mulil manme nuye Kod. ");
INSERT INTO gupk_vpl VALUES ("RV19_18","096_19_18","REV","19","18","18","Ben‑marneyimeng, “Ngurrben‑kukngun bininj nawu birrikodjkimuk 'kings', mak bininj nawu birri‑worhnan kure army, mak birri‑kihkimuk bininj. Mak ngurrben‑kukngun nawu djarrang mak nawu bininj bindi‑mornekang, mak kunburrk bedberre bininj kabirri‑dukkayindi, mak birribuyika rowk, bedda nawu birri‑yawuyawurd mak nawu birrikimuk bininj.” ");
INSERT INTO gupk_vpl VALUES ("RV19_19","096_19_19","REV","19","19","19","Ngayi nga‑nang Nabang Mayh mak nawu kondanj kukurlk kabirri‑worhnan. Mak nawu bedberre djuram birri‑kaberrkdi wanjh kabirri‑burren namekke nawu bininj kah‑barndi kure ngal‑kuk‑bele djarrang mak nawu nuye binihbininj. ");
INSERT INTO gupk_vpl VALUES ("RV19_20","096_19_20","REV","19","20","20","Namekke nawu Nabang Mayh mak Dabborrabbolk nawu Kurrikurrinj, wanjh Jesus nuye bininj bene‑darrkid‑mey. Namekke dabborrabbolk bi‑marne‑durrkmirri nawu Mayh Nabang, bu bi-wok-mulewam, kurduyimeng kunngudj dorrengh kure birri‑kange‑barrhmeng bininj. Mak bininj nawu ben‑wurrhkeng birri‑karrmeng nawu kunmorninj nuye Nabang Mayh, wanjh birri‑marne‑bard‑durrungkulhdanj nuye kundulk birri-marnbom yiman Nabang Mayh nuye. Wanjh bonj, Nabang Mayh mak namekke dabborrabbolk bindi‑weng kure kunrak mankimuk, kundolng-banjinj yiman nud-no. ");
INSERT INTO gupk_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","Wanjh djuram berrewoneng ben‑bom, namekke nawu kah‑barndi kure djarrang nawu kuk‑bele. Wanjh ben‑bom rowk mandjawak dorrengh nawu kam‑bebmeng kure kurrang nuye. Kaluk wanjh kumekke birrim‑koluy marram, warrk, djawurndu, wanjh bindi‑kuk‑nguneng rowk, wanjh, birri‑worrkminj. Wanjh kumekke nga‑nang bonj. ");
INSERT INTO gupk_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","Kumekke ngayi Djon nga‑nang andjel kam‑koluy kure kaddum‑beh. Karrmeng key ngalengarre kure kanjdji duninjh kudjorlok ngalengarre. Mak karrmeng kubid nuye manmurrngrayek kunyarl ‘chain’. ");
INSERT INTO gupk_vpl VALUES ("RV20_2","096_20_2","REV","20","2","2","Wanjh andjel bi‑rrarrkidmey mayh ngalu yiman ka‑yime mayh yiman ngalyod. Namekke mayh‑bang nakareni nawu wayarra Narderr Satan. Wanjh bi‑kukdukkang bu ka‑ni mandjewk la mandjewk, 1 thousand years. ");
INSERT INTO gupk_vpl VALUES ("RV20_3","096_20_3","REV","20","3","3","Bi‑kukweng kure kanjdji duninjh, mak bi‑marne‑bolk‑balhmeng, mak bi‑marne‑dang‑rayekwong. Kaluk andjel kumekke kurduyimeng, wanjh namekke wayarra Satan minj kaben‑wurrhke bininj nawu kabirri‑ni kure kukurlk. Kaluk bu ka‑yakwon mandjewk kure kunkuyeng ni, 1 thousand years. Bu nawu andjel kabi‑bebke bu ka‑woh‑ni kundedjumbung nuye. ");
INSERT INTO gupk_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","Wanjh nga‑nang thrones, bininj birri‑barndi kumekke bu Kod ben‑wong kunngudj bu kabindi‑djadme. Mak ngaben‑malng‑nang bininj nawu birri‑doweng nawu bedda birri‑mulewam nuye Jesus mak birri‑mulewam kure Kod nuye kunwok, kure bininj nawu birriwarre bindi‑kom‑dadjeng. Bedda minj birri‑boddayinj nuye nawu Nabang Mayh, mak minj birri-boddayinj nuye kundulk birrimarnbom yiman Nabang mayh nuye, mak bedda minj kunmorninj birri‑karrmeninj nawu Nabang Mayh nuye kunmorninj kure kumilh mak kubid bedberre. Wanjh nakka birri‑yawoyh‑kerrngeminj bu kabirri‑djarrk‑worhnan Christ dorrengh. Kabirri‑djarrk‑ni mandjewk la mandjewk, 1 thousand years. ");
INSERT INTO gupk_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","Bedda nawu birri‑yungki bininj bu kabirri‑yawoyh‑kerrngemen nawu birrih‑doweng. Birri‑buyika bininj nawu birri‑doweng minj kabirri‑yawoyh‑kerrngemen bu ka‑yakmen mandjewk ngalengarre kunkuyeng, 1 thousand years. ");
INSERT INTO gupk_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","Bedda wanjh kabirri‑njilng‑makminj, kabirri‑kuk‑djamunminj nawu birri‑yungki nawu birri‑yawoyh‑kerrngeminj. Bu kundowiken rerrih kam‑re, wanjh minj kaben‑bun, minj kabirri‑yawoyh‑dowen. Wanjh birrimekke bedda kabirri‑yimerran djungkay nuye nawu Kod mak nuye Christ. Mak kabirri‑djarrk‑worhnan dorreng Christ bu mandjewk la mandjewk, 1 thousand years. ");
INSERT INTO gupk_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","Bu manekke mandjewk ngalegarre ka‑yakmen, nawu Christ kabi‑bawon nawu Naderr Satan kam‑bebme kure ka‑rurrkkenhni. ");
INSERT INTO gupk_vpl VALUES ("RV20_8","096_20_8","REV","20","8","8","Wanjh Naderr ka‑re kaben‑wurrhke bininj kure kubolk‑warlahkenh kukurlk rowk. Nawu Naderr kaben‑wurrhken bininj nawu birrih-ni kure Kok mak kure Makok. Wanjh kaben‑kaberrkrawon bu kabirri‑burren. Kaluk bininj nawu birri‑djalwern duninjh yiman kunkawadj rerrih manbu kah‑yo kure wadjbud. ");
INSERT INTO gupk_vpl VALUES ("RV20_9","096_20_9","REV","20","9","9","Wanjh birrimekke nawu Naderr nuye bininj rowk nakka kabirrih‑ni kubolk‑bubuyika rowk kure kukurlk. Wanjh birri‑raworrinj wanjh bindi‑marne‑bebmeng kure bedda birrih‑yoy nawu Kod nuye bininj kure kubolkkimuk manbu Kod ka‑yi‑marne‑bolk‑djare. Mak kunrak kam‑warrhmeng kure kaddum‑beh wanjh ben‑kinjeng birri‑kukruy rowk nawu Naderr nuye bininj. ");
INSERT INTO gupk_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","Nane Wayarra nawu ben‑wurrhkeng, nakka wanjh birri‑burriweng kure kunrak mankimuk, kundolng banjinj yiman nud-no. Kabirri‑djarrk‑rung nawu Nabang Mayh mak nawu Ka‑kurren Dabborrabbolk. Wanjh kumekke kabirri‑djak‑bekkan kure kumunun ngalengarre, mak benbekad ngalengarre bu munguyh munguyh. ");
INSERT INTO gupk_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","Wanjh kubuyika ngan‑kang ngan‑bukkang kure ‘throne’ kubolk‑kimuk kure kubolk‑bele. Nga‑nang kamh‑barndi kumekke. Kondanj kukurlk rowk mak nawu kure kunngol nakka wanjh birri‑kele‑rlobmeng rowk nuye, birri‑yakminj. ");
INSERT INTO gupk_vpl VALUES ("RV20_12","096_20_12","REV","20","12","12","Mak ngaben‑nang nawu birri‑doweng, nawu birri‑kihkimuk mak nawu wurdu‑wurdurd. Birri‑kaberrkdi kure kumirrk throne nuye Kod. Wanjh nakudji djurra dangmarrhmey nawu ka‑karrme kunngey Kundarrkid. Ka‑mulewan nangale ka‑mang nawu kundarrkid nuye Ngabbard. Wanjh nabuyika nawern djurra dangmarrhmey. Wanjh nawu birri‑doweng bininj ben‑djadmeng kure baleh birri‑yimeng, kure baleh yingkih wok‑bimdi bedberre kure nawern djurra. ");
INSERT INTO gupk_vpl VALUES ("RV20_13","096_20_13","REV","20","13","13","Bininj nawu birri‑keb‑ngakmeng kure kurrula birrim‑dolkkang. Wanjh mak bininj kure birri‑di kure kundowikenh ngalengarre kured, kure bininj nawu birri‑doweng kabirri‑dukkayindi, nakka wanjh birrim‑dolkkang kure kumirrk ngalengarre throne. ");
INSERT INTO gupk_vpl VALUES ("RV20_14","096_20_14","REV","20","14","15","Rerre wanjh bu kundowikenh mak kunred ngalengarre, wanjh nungka ben‑weng kure kunrak kure kah‑rung munguyh. Mane manbu kunrak yiman ka‑yime birli‑no manbirli‑kimuk duninjh. Nangale bininj nawu minj ka‑ngeydi kure djurra nawu kabi‑yolyolme kure kundarrkid, wanjh nakka kabi‑kuk‑burriwe kure manbirli‑kimuk kunrak manbu kah‑djal‑rung munguyh. Kunyungki birri‑doweng kondanj kure kukurlk, kaluk bolkkime kabirri‑yawoyh‑doweng kumekke kure kunrak kunkimuk. ");
INSERT INTO gupk_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","Wanjh ngayi Djon nga‑bolk‑nang kaddum mak kondanj kukurlk wanjh kerrngehminj kaddum mak kondanj kukurlk. Manu manyungki makka wanjh yakminj, mak kurrula warridj yakminj. ");
INSERT INTO gupk_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","Wanjh ngayi nga‑nang kubolk‑kerrnge kure Djerusalem ngalengarre, kubolk‑djamun kunred. Nga‑nang kam‑koluy kaddum‑beh kure Kod bolk‑munkeweng. Kaluk manekke yiman daluk ngalu djongburrinj namakkayken kunmadj bu kuk‑mahmaworrinj bininj nuye ba bu kabi‑mirrkmang nawu nabininjkobeng ngalengarre kure kabene‑marren. ");
INSERT INTO gupk_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","Wanjh nga‑bekkang nangale wokdi bu rerrkang kure ‘throne’, wok‑kimukminj bu kayhmeng, “Kan‑bekka: Bolkki wanjh Kod kabirri‑djarrk‑ni munguyh munguyh, kumekke wanjh kabirri‑djarrk‑yo. Bedda wanjh kabirri‑yimerran bininj nuye rowk, bu Kod nungan kah‑djal‑ni munguyh nawu bedberre Kod. ");
INSERT INTO gupk_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","“Nungka kaben‑mim‑nalk‑djirridjbun rowk. Bedda minj kabirri‑yawoyh‑dowen, minj mak kunnjilng‑warre kabirri‑yawoyh‑karrme, minj mak kabirri‑yawoyh‑nalkbun, minj kabirri‑yawoyh‑kange‑warre. Manbu mankare makka wanjh yakminj rowk bu munguyh munguyh.” ");
INSERT INTO gupk_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","Kaluk namekke bininj nawu kah‑ni kure ‘throne’ yimeng, “Ngurri‑na! Nawu njalehnjale wanjh nakka ngayi nga‑marnbun ka‑kerrngehmen rowk” wanjh yimeng “Kone yi‑bimbu, mane kunwok kunwoybuk, kaluk ka‑kurduyimerran kure ngayi marneyimeng.” ");
INSERT INTO gupk_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","Kumekke ngan‑marneyimeng, “Bonj, djal‑kurduyimerranj rowk. Ngayi nawu nga‑ngeyburren 'Alpha mak Omega'. Mane kunwok ka‑yime: Nawu nga‑rrokme munguyh mak kure ngayi ngurdme rowk, nga‑yakwon rowk. Nangale nawu ka‑kombukdowen, wanjh ngayi nga‑bo‑won kunronj kure ka‑darrkid‑won. Mane ngarduk kunronj ngayi bo-won ngudberre. ");
INSERT INTO gupk_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","Bininj nawu kabirri‑warnyak kunwarre wanjh ngaben‑won manmak manbu ngayi ngardduk rowk. Ngayi wanjh bedberre Kod, bedda wanjh ngardduk bebeywurd. ");
INSERT INTO gupk_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","Bininj kabirri‑kele‑rlobme, bedda wanjh kaben‑kuk‑burriwe kure kunrak mankimuk, kundolng- banjinj nud-no. Mak bininj nawu ngayi minj ngandi‑woybukwon, mak bininj nawu man‑djal‑warre duninjh kabirri‑yime, mak bininj nawu kabirri-djirdmarren bininj, daluk, kabirri‑kuk‑yerrkkerren, mak bininj nawu bindi-bun birribuyika bininj, mak bininj nawu birri‑marrkidjbu, mak bininj nawu kabirri‑marne‑boddan kondanj kure kukurlk‑waken bedberre, mak nawu bininj kabirri‑kurren. Wanjh kabirri‑re rowk kure kunrak mankimuk, kundolng banjinj nud-no. Mane wanjh rerre ka‑yimerranj bu kundowiken. Kabirri‑yawoyh‑malng‑dowen. ");
INSERT INTO gupk_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","Wanjh nakudji kure 7 andjel nawu birri‑karrmeng kunyungki 7 ngalanno kunrid dorrengh, nakudji wanjh kam‑wam kure ngayi, wanjh ngan‑marneyimeng, “Yim‑ray! Ngarr‑djarrk‑re, bukkan nungka nuye ngalbininjkobeng nawu Lamb.” (Namekke andjel benh‑mulewam bininj nawu kabirri‑woybukwon Jesus.) ");
INSERT INTO gupk_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","Wanjh nawu andjel kunwaral ngardduk ngan‑mey ngan‑kang kure mandulum mankimuk. Wanjh kumekke ngan‑bolk‑bukkang nga‑nang kure kubolk‑djamun kure kunred Djerusalem. Kamh‑koluy kure Kod kah‑ni kaddum. ");
INSERT INTO gupk_vpl VALUES ("RV21_11","096_21_11","REV","21","11","21","Bolk‑wayalhmerrinj kunmakmak dorrengh nuye Kod. Bolk‑waydi yiman ka‑yime namakkaykenh kunwardde ka‑ngeyyo Jasper, wanjh marlamarlhmeng yiman ka‑yime budjulung. Wanjh namekke andjel nawu nganh‑wokdi, namekke karrmeng kundulk mankukdjaddjad nawu kure rohrokmeng. Nakka kundulk birri‑marnbom gold. Wanjh rohrokmeng kure kumekke kubolk‑kimuk Djerusalem, kungurrid kungurrid, kumirrk, kubodme. Kumekke wanjh bolk‑warlahminj wam 12 thousand kunkuyeng kure ngalengarre kunred. (Yiman ka‑yime 12 thousand football ovals) mak 12 thousand wam kure kaddum ngalengarre kukodj. Wanjh manekke kubolk-kimuk kunred makka wanjh gold duninjh kure birri‑marnbom yiman ka‑yime budjdjulung nawu kuk‑waydi. Wanjh kumekke kubolk‑kimuk Djerusalem, makka wardde‑borledminguneng warnamyoy yiman ka‑yime fence djarreh duninjh. Wanjh namekke andjel rohorokmeng nawu 'fence' mankimuk kah-ni 144 kaddum, yiman ka-yime 144 kunberl. Kure manekke 'fence' birri‑marnbom kunwardde manmak ka‑yime ‘jasper’. Wanjh ka‑karrme 12 dangno bu ka‑rrangmarrhmang‑kenh. Wanjh manekke dang‑no kabirri‑karrme 12 kunngey Israel namud. Wanjh 12 andjels kabirrih‑di kure kurrangmaye. Kaluk manbu bokenh‑mankudji dangno kah‑di kure koyek, mak bokenh‑mankudji kah‑di kure kakbi, mak bokenh‑mankudji kah‑di kure walem, mak bokenh‑mankudji kah‑di kure karrikad. Manekke 12 dangno makka wanjh 12 mankimuk pearl yiman ka‑yime ka‑marlah‑marlmeng kumim. Kaluk ka‑bebbeh‑di bedberre kure dangno mankudji bedberre. Wanjh 12 manwardde balabbala birri‑di kure kandji kure 'fence'. Wanjh manekke manwardde birri‑bebbeh‑ngeydi 12 apostles nawu nuye Lamb. Mak birrimekke 12 manwardde balabbala birri-karrmeng kunwardde manmakkaykenh, namakmak medjno. Manbu kure mankudji manwardde-balabala ka-karrme jasper. Manbuyika manbu ka-karrme sapphire. Manbuyika manbu ka-karrme agate. Manbuyika manbu ka-karrme emerald. Manbuyika manwardde-balabala manbu ka-karrme manmak kunwardde manbu ngeyyoy onyx Mak manbadbuyika ka-karrme carnelion Manbuyika ka-karrme quartz, Manbuyika ka-karrme beryl Manbuyika ka-karrme topaz Manbuyika ka-karrme crysopase Manbuyika ka-karrme jacinth Mak manbu rerreh maka amathyst. Mak kure kukurlk manbolh makka wanjh manbolh‑kimuk ngalengarre kumekke kure kubolk‑kimuk, makka wanjh ‘gold’ manbu yiman ka‑yime budjdjulung nawu ka‑bame. ");
INSERT INTO gupk_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","Mak manbu Temple kumekke minj nga‑nayinj kure kubolk‑kimuk. Nungan Kod nawu Ngudj‑kimuk Duninjh nawu Kaworhnan Rowk mak nuye Lamb, bedda yiman kabene‑kukyime Te mple kure kabirri‑marne‑bard‑durrungkurlhdanj bininj, kure kumekke kunred. ");
INSERT INTO gupk_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","Kaluk kumekke dird, kundung minj kabene‑bolk‑wayalhmeng, kayakki. Kod nuye kunmakmak ka‑kukwaydi kure kumekke kubolk‑djamun, mak nuye Lamb, nakka wanjh yiman ka‑yime birlino ‘torch’ ka‑rung ka‑bolk‑wayalhmeng kumekke. ");
INSERT INTO gupk_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","Wanjh bedda kabene‑bolk‑wayalhmeng kure karri‑djalwern rowk bininj kure kondanj kukurlk karrih‑ni ba ngad karri‑re kunmak rowk. Mak bininj nawu kabirri‑worhnan kondanj kukurlk, wanjh kabirrim‑kan kure kunmakmak bedberre kure kumekke, wanjh kabirri-won kure Kod. ");
INSERT INTO gupk_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","Manbu 12 dangno ngalengarre kumekke kure kubolk‑kimuk minj kabirri‑dangbalhmerrinj kure benbekad rowk ngalengarre. Mak kunkak minj ka‑rri kumekke. ");
INSERT INTO gupk_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","Bininj rowk kabirrim-kan njalehnjale rowk nawu namakmak, mak nangeykimuk dorrengh kure birrim‑dolkkang‑beh kubolk‑bubuyika nakka wanjh kabirri‑yingimeng, kabirri-won kure Kod. ");
INSERT INTO gupk_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","Ka‑djal‑yo namakmak nadjamun‑kenh. Bininj nawu kunwarre kabirri‑kurduyime kure kabindi‑wurrhke birribuyika bininj, makka minj kabirri‑kan kumekke. Bininj nawu kabirri‑ngeydi nawu Lamb nuye Djurra kure kaben‑darrkidwon, wanjh birrimekke bininj kabirri‑ngimen kure Kod nuye kubolk‑djamun. ");
INSERT INTO gupk_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","Ngayi ngan‑bukkang andjel nga‑nang mankabo manbu bininj ka‑rrarrkid‑won. Nga‑nang manbo‑bele kabo‑narren, kam‑koluy kure Kod nuye ‘throne’, nawu mak nuye Lamb. ");
INSERT INTO gupk_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","Ngayi nga‑nang bo‑yoyomeng kure kubuldjdjarn manbolh mankimuk‑ken kure kubolk‑kimuk. Mak manbu kundulk kaben‑darrkid‑won bininj kabene‑bebbe‑di kure mankabo ka‑bo‑rlobme kure kubuldjdjarn. Manekke wanjh manme ka‑marnburren munguyh munguyh, dird la dird. Mak manbu kunworr ka‑worr‑bebme kure kundulk, makka kaben‑marnbun bininj kure kubolk‑bubuyika. ");
INSERT INTO gupk_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","Minj kan‑yawoyh‑walkwon bininj. Nungka Kod nuye ‘throne’ ka‑djal‑di kure kubolk‑kimuk. Mak Lamb kumekke kabene‑djarrk‑ni. Mak bininj nawu kabirri‑marne‑durrkmirri wanjh bedda kabirri‑marne‑bard‑durrungkulhdan nuye kumekke. ");
INSERT INTO gupk_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","Kaluk bedda kabirri‑kebnan mak kunngey nuye ka‑ngey‑di kure kumilh bedberre. ");
INSERT INTO gupk_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","Kunkak minj ka‑rri, mak bininj nawu kumekke kabirrih‑ni minj kabirri‑yawan kundung mak birlino. Kod nawu Kaworhnan Rowk nungan ka‑bolk‑wayalhme bedberre. Nawu bedda wanjh kabirri‑worhnan yiman ‘kings’ rerrih bu munguyh munguyh. ");
INSERT INTO gupk_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","Kaluk nawu angel ngan‑marneyimeng, “Mane kunwok manwoybuk, ngurri‑woybukwon. Kod nawu Kaworhnan Rowk, ben‑wong Nawaralmakkayken nuye birrikare ‘prophet’. Bi‑munkeweng andjel nuye bu kan‑bukkang kadberre ba karri‑marne‑durrkmirri kure baleh bolkki ka‑kurduyimerran. ");
INSERT INTO gupk_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","Wanjh Jesus yimeng, “Ngurri‑bekka! Ngayi bolkki ngam‑re! Ngayi kunmak nga‑marneyime nangale bininj nawu ka‑wernh‑karrme kunwok ngardduk nawu kure nane djurra ka‑wok‑bimdi.” ");
INSERT INTO gupk_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","Ngayi Djon ngayeman nga‑wok‑bekkang mak nga‑nang kure njalehnjale rowk nga‑bimbom. Bu kumekke nga‑nang nga‑bekkang, nga‑mankang kure kurrenge nuye andjel, wanjh nga‑burlumeng nuye angel nawu nganh‑bukkang kure ngah‑nang. ");
INSERT INTO gupk_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","Wanjh ngaleng andjel ngan‑marneyimeng, “Yun ngayi kan‑marne‑mankang! Ngayi nakka nga‑durrkmirri yiman ngudda. Mak nawu ngurri‑danginj nawu birrikare ‘prophets’ mak bininj rowk kure kabirri‑marrkmang kunwok kure nawu djurra ka‑wok‑bimdi. Yi‑marne‑bard‑durrungkulhda nuye God.” ");
INSERT INTO gupk_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","Wanjh andjel ngan‑yawoyh‑marneyimeng ngardduk, “Manekke kure yih‑bimbom kure djurra, makka minj yi‑warlkkan, korroko wanjh darnkih kamh‑re ngalengarre bu kone rowk ka‑kurduyimerran. ");
INSERT INTO gupk_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","Wanjh nangale bininj nawu ka‑kurduyime kure kunwarre, nakka wanjh kunwarre djal‑kurduyimen munguyh. Nangale nawu kange‑kurduk munguyh nakka wanjh kange‑kurduk munguyh. Mak nangale nawu ka‑kurduyime kunmak, wanjh nakka kunmak munguyh ka‑djale, nangale nawu ka‑kuk‑djamunworren wanjh kuk‑djamunnin munguyh. ");
INSERT INTO gupk_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","Wanjh Jesus yimeng, “Kandi‑bekka! Ngayi wanjh bolkkime ngam‑yawoyh‑durndeng! Birriwern nawu kandi-marne-durrkmirri bedda wanjh birri-winhme kure ngayi. ");
INSERT INTO gupk_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","Ngayi nawu nga‑ngeydi “Alpha mak Omega” nane kunngey ka-yime “Kunyungki mak Rerre”. Nga-rredjmang rowk, mak nga-ngurdme rowk. ");
INSERT INTO gupk_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","Kod nungan kaben-marne-kurduyime kunmak bedberre bininj kure kaben‑madj‑djirridjbun bedberre ba kabirri‑ngun kure barnem‑no manme kure kundulk‑beh ba kaben‑darrkid‑won mak kabirri‑ngimen kure kunrurrk‑dangmaye ngalengarre kured kubolk‑kimuk. ");
INSERT INTO gupk_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","Kure kuberrk kubolk‑kimuk kure kabirrih‑di nawu birri‑warre bininj, mak bininj nawu bedda birri‑marrkidjbu, mak nawu kabirri‑djirdmarren bininj, daluk, mak bininj nawu kabindi-bun birribuyika bininj bininj nawu ‘idols’ kabirri‑marne‑mankan, mak kabirri‑kurren kabindi‑wurrke birri‑buyika bininj.” ");
INSERT INTO gupk_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","Ngayi Jesus nga‑munkeweng ngardduk andjel bu ka‑yolyolme koneng kunwok kunwoybuk kure nawu yiwarrudj bedberre. Ngayi nawu Deybid (David) nuye mawahmawah. Ngayi nga‑rranginj kure nuye namud. Ngayi nakudji ngun‑kangekarrmeng bu ngan‑munkeweng. Ngayi yiman ka‑yime kinhkinh kure ka‑bolk‑wayalhme kure kamh‑barrhbun djarreh. ");
INSERT INTO gupk_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","Wanjh Nawaralmakkayken ka‑yime “Yim‑ray!” Ngalekke daluk ngalu kam‑re kure nabininjkobeng ngalengarre wanjh ka‑yime, “Yim‑ray!” Wanjh ngurri‑wern nawu kandi‑bekkan wanjh ngurri‑yimen “Yim‑ray!” Nangale nawu ka‑kombukdowen wanjh ngayi marneyime, “Yim‑ray.” Wanjh nangale nawu bininj ka‑djare, wanjh kam‑re ka‑bongun kunronj kure kabi‑kange‑darrkid‑won, nakka minj njale ka‑karremulewan. Mane kunronj nuye Jesus, wanjh kan-bo-won kadberre, kabirri-bongun. ");
INSERT INTO gupk_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","Wanjh ngayi ngaben‑bengdayhke nawu kabirri‑bekkan kunwok kure djurra wok‑bimburrinj kure yingkih‑yoy. Bu nangale ka‑karre‑wern‑won kure kunwok nuye, wanjh nakka Kod kabi‑marnbun ka‑djak‑bekkan kundjak kure nane djurra ka‑bimdi ka‑yolyolme kure kundjak. ");
INSERT INTO gupk_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","Mak birri‑ngale kabirri‑wok‑bularrbun manekke kunwok kure ka‑wok‑bimdi wanjh Kod nakka kaben‑kaybun manekke mandjoleng kure kundulk‑beh manbu kaben‑darrkid‑won bininj, mak minj kabirri‑ngimen birrimekke bininj kure kubolk‑djamun nuye, kure nane djurra ka‑mulewan. ");
INSERT INTO gupk_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","Kaluk Jesus mulewam manekke kunwok makka manwoybuk duninjh, wanjh ka‑yime, “Yoh. Bolkkime ngayi ngam‑durndeng.” Ngayi nawu Djon nga‑yime, “Mah, wanjh yim‑ray ngudda nawu Jesus Yi‑worhnan Rowk.” ");
INSERT INTO gupk_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","Wanjh ngayi nga‑djare Jesus nawu Kaworhnan Rowk bu ngun‑kongibun ngudberre, mak ngurri‑djarrk‑di nawu Kod nuye binihbininj rowk. Wanjh Bonj. ");
ALTER TABLE gupk_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
