﻿USE sofia;
DROP TABLE IF EXISTS sofia.gup_vpl;
CREATE TABLE gup_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gup_vpl WRITE;
INSERT INTO gup_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kerrngehkenh duninjh God bolkmarnbom rowk, kaddum dja kurorre. ");
INSERT INTO gup_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Wanjh minj njale bangmemarnbuyindangimeninj kurorre, dja mak bolklarrkni. Dja kunkak yiman rerrih barrkbom kukku manbu boyoy kanjdji, dja God nuye Namalngmakkaykenh, yiman kunmayorrk rerrih djahdjalrokani kaddum kore kubokehkekeb. ");
INSERT INTO gup_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Wanjh God yimeng, “Mah, kumwolkayinda.” Wanjh kumwolkayindanj. ");
INSERT INTO gup_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dja God nang manbu kumwolkayindanj, nang kamak rowk. Wanjh nungka welenglarlmey manbu kumhwolkani dja manbu kunkak. ");
INSERT INTO gup_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dja nungka God ngeykurrmeng, manbu kumhwolkani manu wanjh ngeykurrmeng barnangarra, dja manbu kunkak, manu wanjh ngeykurrmeng kumunun. Wanjh kunkak wam, kunkabel kumwam, wanjh kunbarnangarrakudji kunu. ");
INSERT INTO gup_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","God yimeng, “Mah, kunngol kumray kakurrmerren kubulkayh kore kaboyo, ba kabebbehbolarlmang.” ");
INSERT INTO gup_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Wanjh God marnbom kunngol dja bebbehbolarlmey, ngalengman manu kaboyo kanjdjikah, dja mak ngalengman manu kaboyo kaddumkah. Wanjh kundjalmekbe yimerranj. ");
INSERT INTO gup_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Wanjh God welengngeykurrmeng kunngol. Wanjh kunkak wam, kunkabel kumwam, wanjh kunu kunbarnangarra bokenh. ");
INSERT INTO gup_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Wanjh God yimeng, “Mah, kukku manbu kaboyo kanjdjikah kore kunngol, wanjh bomornnamiyinda kukudji ba kamrorrebebme.” Wanjh kundjalmekbe yimerranj. ");
INSERT INTO gup_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Wanjh God welengngeykurrmeng kunrorre. Dja kukku manbu bomornnamerrinj kukudji, wanjh kunu ngeykurrmeng kurrula. Wanjh God nang kamak rowk. ");
INSERT INTO gup_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Wanjh God yimeng, “Mah, ngalengman kunrorre bebkemen mankolhdebubuyika, ngalengman manbu kakarrme manmim, dja ngalengman kundulk, kakarrme manbarnem manmim dorrengh, manbebbehbubuyika.” Wanjh kundjalmekbe yimerranj. ");
INSERT INTO gup_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ngalengman kunrorre ngalkeng mankolhdebubuyika, ngalengman manbu kakarrme manmim, manbebbehbubuyika, dja ngalengman kundulk kakarrme manbarnem manmim dorrengh, manbebbehbubuyika. Wanjh God nang kamak rowk. ");
INSERT INTO gup_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Wanjh kunkak wam, kunkabel kumwam, wanjh kunu kunbarnangarra danjbik. ");
INSERT INTO gup_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","God yimeng, “Mah, manbu kabirriwolkan birrimbebmerrimen kore kungolbeh ngarre kaddum, ba kabirrilarlmang barnangarra dja kumunun, kabirribukkarren munguyh munguyh ngarre kurrung dja kudjewk, dja mak ngarre kunbarnangarrabubuyika dja mandjewkbubuyika. ");
INSERT INTO gup_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Bedda kaluk birriwolka kungol ngarre kaddum ba kabirribolkwolkan kanjdji kurorre.” Wanjh kundjalmekbe yimerranj. ");
INSERT INTO gup_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God marnbom mankihkimuk bokenh, manbu manwernhkimuk, manu ngalengman kawolkan kawohrnan barnangarrakenh, dja manbu manwohbirluyahwurd, manu ngalengman kawolkan kawohrnan kumununkenh, dja mankokkarrng warridj kunimarnbom. ");
INSERT INTO gup_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Wanjh God welengkurrmeng manbu kabirriwolkan, kurrmeng kore kungol ngarre kaddum ba kabirribolkwolkan kanjdji kurorre, dja mak kabenebebbehwohrnan barnangarrakenh dja mak kumununkenh, dja mak kabirribebbehlarlmang kore kahwolkan dja kore kunkak. Wanjh God nang kamak rowk. ");
INSERT INTO gup_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kunkak wam, dja kunkabel kumwam, wanjh kunu kunbarnangarra kunkarrngbakmeng. ");
INSERT INTO gup_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Wanjh God yimeng, “Mah, nawu kukbubuyika kamimbi wernhmerrimen kore kukku rowk, dja mak nawern nawu welyi birriray kaddumkah kurorre kore kungol ngarre kaddum.” ");
INSERT INTO gup_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Wanjh kunu God marnbom nakihkimuk djenj yiman kayime birddurrangkan, mak nadjalbubuyika rowk nawu kamimbi nawu kamirndere kukukku, benmarnbom birribebbehkukbubuyika rowk. Dja mak nadjalwern rowk nawu welyi benmarnbom birribebbehkukbubuyika rowk. Wanjh God nang kamak rowk. ");
INSERT INTO gup_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Wanjh God benmarneyimeng kunmak kunwok, yimeng, “Ngurrima nawern yaw, ngurrimirndewernworrimen, barlmirrangimen kore kukku manbowarlahbubuyika, dja mak nawu ngurriwelyi, ngurrimirndewernworrimen kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kunkak wam, kunkabel kumwam, wanjh kunu kunbarnangarra five. ");
INSERT INTO gup_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Wanjh God yimeng, “Mah, kunrorre ngalkemen bebbehkukbubuyika nawu kamimbi, mayh nadjalwern, nawu kelebuk, dja nawu kawake, dja nawu kele, birribebbehkukbubuyika.” Wanjh kundjalmekbe yimerranj. ");
INSERT INTO gup_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God benmarnbom mayh kukbubuyika, kele nawu birribebbehkukbubuyika, kelebuk nawu birribebbehkukbubuyika, dja mak nawu kawake kurorre birribebbehkukbubuyika rowk. Wanjh God nang kamak rowk. ");
INSERT INTO gup_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Wanjh God yimeng, “Kab ngarrbenmarnbu bininj, yiman ngad rerrih karrirohrok dja kabirrimarnewohrnan djenj nawu kare kukukku, mak nawern nawu welyi nawu kare kuwonge, dja mak mayh kelebuk, dja kurorre rowk, dja mak mayh rowk nawu kawake kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Wanjh God benmarnbom bininj, yiman nungka rerrih kabirrirohrok. Yiman God nungan rerrih kabirrirohrok benmarnbom. Benmarnbom bu narahrangem dja ngaldahdaluk. ");
INSERT INTO gup_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kaluk benmarneyimeng kunmak kunwok, dja yimeng, “Ngurrima nawern wurdyaw, bininj ngurrimirndewernworrimen, ngurribarlmirrangimen kurorre dja ngurribolkkarrmen. Dja mak ngurrimarnewohrna djenj nawu kare kukukku, mak nawern welyi nawu kare kuwonge, dja mayh rowk nawu kamimbi nawu kahre kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Wanjh God yimeng, “Ngurrina, ngaye ngokko ngakurrmeng ngudberre bininj mankolhdebubuyika rowk kakarrme manmim, manbu karri kurorre kubolkbubuyika rowk, dja mandulkbubuyika rowk kakarrme manbarnem manmim dorrengh, manmekbe rowk wanjh manme ngudberre ngurringun. ");
INSERT INTO gup_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Dja nawu mayh rowk nawu kele, dja mak nadjalwern rowk nawu welyi nawu kare kuwonge, dja mak mayh rowk nawu kawake kurorre, mayh nawarlahkenh rowk nawu kakarrme kunngolek bu kamimbi, bedda wanjh ngabenmarnekurrmeng kabirringun manbu kundalk manbu mandalkkuk, dja manbu kundulk kakarrme manworrkuk.” Wanjh kundjalmekbe yimerranj. ");
INSERT INTO gup_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Wanjh God nang yehyeng rowk nawu marnbom, nang kamak duninjh. Kunkak wam, kunkabel kumwam, wanjh kunu kunbarnangarra six. ");
INSERT INTO gup_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kunu wanjh God yakwong rowk bu bolkmahbolkmarnbuni kaddum dja kurorre, dja mak yehyeng rowk nawu kumekbe karri. ");
INSERT INTO gup_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","3","Wanjh bu kunbarnangarra seven God ngehmeng. Nungka yakwong rowk kore durrkmihdurrkmirri, wanjh ngehmeng dja ngokko yakwong rowk kore durrkmihdurrkmirri bolkmahbolkmarnbuni, kunmekbekenh kunu nungka kukenhmeng kunbarnangarra seven, larlmey, marnbom bu kunbarnangarradjamun nungan nuye. ");
INSERT INTO gup_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Wanjh kunih kunu kayolyolme bu kaddum dja kurorre God bolkmahbolkmarnbuni. ");
INSERT INTO gup_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","6","Bu Yawey nawu God bolkmarnbom kurorre dja kaddum, minj kundulk bangmediwirrinj kurorre, dja manmim minj bangmebebmeninj, dja Yawey God minj bangmemunkewemeninj mandjewk kore kurorre, dja minj nangale mak diwirrinj bu bolkyilkbuyi. Djal kukku kumbobebmi kurorrebeh bolkdjuhkeyi rowk. ");
INSERT INTO gup_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Wanjh Yawey nawu God mey kundjulng kore kurorrebeh dja bimarnbom nayungkih duninjh bininj, biwelengkebbuhmeng nuye kunngolek kore kukeb nuye bininj, wanjh bininj mimbiminj. ");
INSERT INTO gup_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kaluk Yawey nawu God manme dudji kore koyek kabolkngeyyo Eden, wanjh kunmekbe kunu nungka bikurrmeng bininj nawu bimarnbom. ");
INSERT INTO gup_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Wanjh nungka Yawey nawu God welengmarnbom kundulk rowk, dangerrinj kurorrebeh, kundulk manbu bininj kanan mandulkmakkaykenh, dja mak manbu kakarrme manme manmakmak. Kumekbe kore manme dudjihdudjindi, kubulkayh, kumekbe dulkdi manbu kahwon bininj kunngolek bu kamimbi munguyh munguyh, dja mak manbadbuyika manbu kahwon kunmayali kore kunmakkenh dja kore kunwarrekenh. ");
INSERT INTO gup_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mankabo balboyakbuni kore Eden, djuhkeyi manme manbu dudjihdudjindi. Kaluk bewhkah yungkikah Eden, wanjh kumekbe kunu mankabo kabolarlmilarlmirranj kabomarnburrinj kunkarrngbakmeng. ");
INSERT INTO gup_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mankabo manbu karrokme, kangeyyo Pishon, wanjh manu kabalboborledme kore kubolkwarlah rowk kunred kabolkngeyyo Havilah. ");
INSERT INTO gup_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Kumekbe kunred kahyo gold kunwardde nawu namakkaykenh, dja mak manjmakmak perfume yiman kunkalkkid, dja kunwardde kunmakmak duninjh kangeyyo cornelians. ");
INSERT INTO gup_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Manbadbuyika mankabo manbu kabolarlmang, manu wanjh Gihon, kabalboborledme kore kunred kubolkwarlah rowk kabolkngeyyo Cush. ");
INSERT INTO gup_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Dja mak manbu mankaboberlbuyika manbu karranjbikwon, manu wanjh Tigris, manbu kabalboyakbun koyekkah kunred kubolkwarlah kunbolk Asshur. Wanjh ngalengman manbu kunkarrngbakmeng kabalkabore, manu wanjh kangeyyo Euphrates. ");
INSERT INTO gup_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Wanjh Yawey nawu God bimey nahni bininj nawu nayungkih dja bikurrmeng kore manme dudjihdudjindi kore kunbolk Eden, ba kabolkyilkbun dja kabolknahnan. ");
INSERT INTO gup_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Wanjh Yawey nawu God biwokrayekwong nahni bininj, yimeng, “Ngudda kamak yingun mandjalwern manbubuyika manbarnem kore maninjmanu kundulk rowk kondah kore manme kahdudjindi. ");
INSERT INTO gup_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mandjalkudji manbu kundulk, manbu kahwon kunmayali kore kunmak dja kunwarre, yuwn yingun manmekbe manme. Bu yingun maninjmanu manbarnem, wanjh bonj, yidjalmalngdowen kundjalmekbe kunbarnangarra rerrih.” ");
INSERT INTO gup_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Wanjh Yawey nawu God yimeng, “Minj kunmak bu nahni bininj kahdjalni nadjalkudji. Ngaye ngamarnbun nawu kabibidyikarrme nawu kamak kabenedjarrkni.” ");
INSERT INTO gup_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wanjh Yawey nawu God benmarnbom mayh kukbubuyika rowk kore kurorrebeh, nawu kare kore kabbal, dja mak marnbom nadjalwern kukbubuyika rowk nawu welyi dja kare kuwonge. Nungka benkang kore bininj ba kanan bu baleh kabenbebbehngeykurrme. Kore baleh bininj benngeykurrmi bedda rowk nawu birrimimbi, wanjh kundjalmekbe birringeyyoy. ");
INSERT INTO gup_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Wanjh nahni bininj ngeykurrmeng rowk mayh nawu kelebuk, dja mak nawern nawu welyi nawu kare kuwonge, dja mak mayh rowk nawu kare kore kabbal. Dja bininj minj bimarnengalkemeninj nawu bibidyikarrmeninj kamak benedjarrkniwirrinj. ");
INSERT INTO gup_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Wanjh Yawey nawu God bikekurrmeng bininj, kerroweng duninjh. Bu nungka keyohkeyoy, God mey kunkudji kunbirrkbirrkmurrng kore bininjbeh biwelengmokbalhmeng kunkulahwi. ");
INSERT INTO gup_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Wanjh Yawey nawu God bimarnbom ngalkudji daluk kore kunbirrkbirrkmurrngbeh bininj, wanjh bimarnekang kore bininj. ");
INSERT INTO gup_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Wanjh bininj welengyimeng, “Kalukburrk bebmeng nawu kunmurrng wam kore ngayebeh, dja kunburrk bu ngayebeh kunburrk. Ngahli wanjh kangeyyo ngalbininjkobeng, dja ngaleng kunu kumkukmarnbuyindanj bininjbeh.” ");
INSERT INTO gup_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kunmekbekenh kunu bininj kabenbenebawon ngalbadjan dja kornkumo, dja kabenebelbmerren ngalbininjkobeng nuye wanjh kabenekudjihmen. ");
INSERT INTO gup_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Namekbe bininj dja ngalbininjkobeng benekukworrhworrni, kaluk minj beneyemeninj. ");
INSERT INTO gup_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kaluk nawu nayin namekbe wanjh djalwernhkurrehkurreni dja mak bendjalwernhyurrhkeyi rowk mayhbubuyika rowk nawu kelekeleh kore Yawey nawu God marnbom. Wanjh namekbe nawu nayin balwokdanj bidjawam daluk, yimeng, “Yiddok woybukkih duninjh God yimeng, ‘Yuwn bu ngunengun manbu manbarnem kore kahdulkdingihdi kondah kore manme kahdudjindi’?” ");
INSERT INTO gup_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Ngalbu daluk yimeng, “Nganengun rowk manme manbu mandulkbubuyika manbu kondah kahdudjindi, dja God kanbenemarneyimeng, ‘Mandjalkudji manbu kubulkayh kahdulkdi, manmekbe manme yuwn ngunengun, yuwn bu mak ngunekarrme, marndi ngunebaldjaldowen.’” ");
INSERT INTO gup_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","Wanjh nayin kumyimeng, “Aba. Minj woybukkih ngunedowen! God kaburrbun bu kundjalmekbe kunbarnangarra bu ngunengun wanjh ngunemayalidangen, nguneyimerran yiman nungka rerrih, nguneburrbun bu kore kunmakkenh dja kunwarrekenh.” ");
INSERT INTO gup_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Wanjh ngalbu daluk dulknang, nang mandulkmakkaykenh dja nang manbarnemmak, dja ngalengman kanjdjiwi wurrmey, yimeng, “Ngadjalmang ngangun ba ngamayalidangen.” Wanjh mey manmekbe manme, nguneng, wanjh bibalmarnekang nabininjkobeng nawu benedjarrkni, nunganwali balnguneng. ");
INSERT INTO gup_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Bu benenguneng wanjh kunmayali benemey, benekuknarrinj wanjh benewohburrbom bu beneworrhworr. Wanjh benewam, benemey kunworr, benebibbom dja benenameng bu benedukkarrinj. ");
INSERT INTO gup_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Wanjh bu wolewolehminj, kunmayorrkmak kumwam, dja bedda nawu bininj dja ngalbininjkobeng benebekkang Yawey nawu God bu rengehrey kore manme dudjihdudjindi, kaluk benemarnewarlkkarrinj kore kurruhdurrulk. ");
INSERT INTO gup_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Wanjh Yawey nawu God bikayhmeng namekbe bininj, yimeng, “Ngudda baleh?” ");
INSERT INTO gup_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nungka biwokmey, yimeng, “Ngaye bekkang kondah kore manme kahdudjindi dja ngakeleminj, marnewarlkkarrinj dja ngakukworrhworr!” ");
INSERT INTO gup_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Wanjh Yawey nawu God yimeng, “Nangale ngunmarneyimeng yikukworrhworr? Yiddok yinguneng manbu manme kore kurrulkbeh bu ngaye wokrayekwong marneyimeng, ‘Yuwn yingun?’” ");
INSERT INTO gup_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Wanjh nawu bininj yimeng, “Ngahli daluk ngalbu ngudda kanwong nganedjarrknikenh, ngaleng wanjh nganwong manmekbe manme manmekbe kurrulkbeh, wanjh nganguneng.” ");
INSERT INTO gup_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Wanjh Yawey nawu God bidjawam ngalbu daluk, “Baleh kuhni bu yikurduyimeng?” Ngaleng yimeng, “Nahni nayin ngankoweng nganmarnekarrebuyikawong, kunmekbekenh kunu wanjh nganguneng.” ");
INSERT INTO gup_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Wanjh Yawey nawu God bimarneyimeng namekbe nayin, yimeng, “Bu kunmekbe yikurduyimeng, wanjh yidjalwake kore kunjam ke munguyh. Ngudda kaluk yingun kundjulng djalmunguyh bu yihmimbi. Kuhni kunyid djalyingan ke, minj mak nawarlahkenh mayhbubuyika kelebuk dja kele, ngudda djal ke kunyid yidjalkudji. ");
INSERT INTO gup_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ngaye ngamarnbun ngorrewoneng bu ngunewidnarrenkenh. Ngudda ke wurdwurd dja ngalengngarre wurdwurd kabirribebbehnjirrkerren munguyh. Ngalengngarre wurdwurd ngundibun kukodj ngundikodjdjubulhme, dja nguddambu ngurrbenbaye kumadbundedj.” ");
INSERT INTO gup_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Wanjh Yawey God bimarneyimeng ngalbu daluk, “Ngaye kaluk ngakimukwon duninjh ke kundjak bu wurdyaw yihmerlem. Kaluk yidjakbekkan bu wurdyaw karrurrkmirri bu karrangenkenh. Djamku bu baleh kakurduyime bu kunmekbe kundjak ke, dja nawu nabininjkobeng yidjalmarnedjare munguyh, dja nungka ngunmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Wanjh Yawey God bimarneyimeng nawu bininj, “Ngudda yibekkang ngalbininjkobeng ke, yinguneng manmekbe manme manbarnem manmekbe kurrulkbeh, manbu ngaye wokrayekwong marneyimeng, ‘Yuwn yingun.’ Bu kunmekbe yikurduyimeng wanjh kunyid ngunmarnekarrme manbu kunrorre. Bu yidjalmimbi, yingudjngarrhme bu yirrurrkmirri djalmunguyh, ba bu kunrorre kangalke manme manbu ngudda ke yingunkenh. ");
INSERT INTO gup_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Wanjh kangalke kundalk dja kinj manmirrhyi, dja mak yibalwelengngun manbu kurralkwaken manrakel. ");
INSERT INTO gup_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ngudda kaluk yirrurrkmirri kunkimuk duninjh kunkebkurrngirn dorrengh, ba kunu kunrorre kangalke ke manme. Kunmekbe yikurduyime munguyh, kaluk yibalwelengdurndeng kukulk. Ngudda yimmarnbuyindanjbeh kukulk, kunmekbekenh kunu yiyawoyhdurndeng. Ngudda wanjh kundjulng, kaluk yiyawoyhdurndeng kundjulng.” ");
INSERT INTO gup_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam bingeykurrmeng ngalbininjkobeng nuye Eve, dja ngaleng kunu ngalbadjan ngalkudji kadberre karriwarlahken nawu karrimimbi. ");
INSERT INTO gup_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Dja Yawey nawu God mey mayh nuye kunkulah berrewoneng bininj dja ngalbininjkobeng, marnbom benbenedjongbom benedjongbuyindi. ");
INSERT INTO gup_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Wanjh Yawey nawu God yimeng, “Nawu bininj yimerranj yiman ngad rerrih, kakarrme kunmayali bu kaburrbun kore kunmak dja kunwarre. Marndi mak kayawoyhbidyirriyongen kamang manbarnem kore kurrulkbeh manbu kahwon bininj kunngolek bu kamimbi munguyh munguyh, dja marndi kangun wanjh kamimbi munguyh munguyh.” ");
INSERT INTO gup_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kunmekbekenh Yawey nawu God bikukmunkeweng kore kumekbe manme dudjihdudjindi, Eden, ba kabolkyilkbun kurorre kore nungka kummarnbuyindanjbeh. ");
INSERT INTO gup_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Bu Yawey bidjalbebkeng nawu bininj kore Edenbeh, wanjh kumekbe benwelengkurrmeng Cherubim nawu yiman mayh welyi Godbeh, kaluk koyekkah kore manme dudjihdudjindi, nawu birrimarnedurrkmirri nungan God birrimarnebolknahnani, dja nawu mandjawak yiman kunak rerrih djurruhdjurrungi djurrbohdjurrborledmi kore kumekbe bendjangnanikenh, ba minj nangale baldarnhrawinj kore kumekbe dulkdi kundulk manbu kahwon bininj kunngolek bu kamimbi munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Wanjh Adam beneyonginj Eve ngalbu ngalbininjkobeng nuye, wanjh ngaleng yawkani, dja biyawmey nawu Cain. Dja ngaleng yimeng, “Wanjh ngayawmey bininj bu Yawey nawu God nganbidyikarrmeng.” ");
INSERT INTO gup_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kaluk mak ngaleng biyawmey Abel nawu benedanginj Cain. Abel kaluk nungka bennahnani mayh nawu sheep, dja Cain nungka bolkyilkbuni kurorre. ");
INSERT INTO gup_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Dja kaluk bu Cain kumkang yikahwi manme manbu kunrorre bimarnengalkeng, kumkang biwong nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Dja Abel nawu nungka wanjh mey mayh nuye nawu nadjdjamanni nawu nawernhmak kunbalem dorrengh, wanjh kumkang biwong Yawey. Wanjh nungka Yawey yimeng kamak bu nang Abel dja nawu nungka balweykang biwong nungka. ");
INSERT INTO gup_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Dja bu binang Cain dja manbu nungka biwong, wanjh nungka Yawey minj yimeninj kamak. Kunmekbe wanjh Cain nungka yidduy duninjh, dja mak kebbumeng. ");
INSERT INTO gup_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Wanjh Yawey bimarneyimeng Cain, “Njalekenh ngudda yihyiddung, dja njalekah mak yihkebbume? ");
INSERT INTO gup_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bu ngudda yikurduyime kunmak wanjh minj nuk ngayime ke yimak? Dja bu ngudda minj yikurduyime kunmak, wanjh kunu kunwarre yiman ngunmarneyo kuberrkkah kore kururrkdangmaye ke, ngunmadbun, kadjare ngundarrkidmang, dja nguddambu wanjh yiman rerrih yibu, yuwn yimarrkmang.” ");
INSERT INTO gup_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Wanjh Cain bimarneyimeng Abel nawu benedanginj, yimeng, “Kab ngarray kore kabbal.” Bu kumekbe kabbal benehni Cain bibom nawu benedanginj, wanjh bikukkurrmeng. ");
INSERT INTO gup_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Wanjh Yawey bidjawam Cain, yimeng, “Nawu ngudda ngunedanginj Abel, kaluk baleh wam?” Wanjh Cain biwokmey, yimeng, “Ngayembu ngawakwan, yiddok ngaye yimankek nganahnan nawu nganedanginj?” ");
INSERT INTO gup_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Wanjh Yawey yimeng, “Ngudda baleh yikurduyimeng? Kanbekka, kunkurlba nuye nungka nawu ngunedanginj wanjh yiman ngankayhme kukulkbeh. ");
INSERT INTO gup_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Wanjh kuhni bu ngudda ke kunyid, dja bonj minj mak yiyawoyhbolkyilkbun kunrorre nawu yiman bikurlbabonguneng yibidkenwong nawu ngudda ngunedanginj. ");
INSERT INTO gup_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wanjh bu ngudda yimankek yibolkyilkbun kunrorre, wanjh minj ngunmarnengalke manme. Dja ngudda yiman yikelerlobme yidjalwohrewohre munguyh kubolkbubuyika kurorre dja yiredyak.” ");
INSERT INTO gup_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Wanjh Cain bimarneyimeng nawu Yawey, yimeng, “Kuhni bu ngudda kandahmeng wernkih duninjh, wanjh ngabekkarren kunrayek duninjh. ");
INSERT INTO gup_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Bolkkime wanjh ngudda kankukmunkewe minj ngabolkyilkbun, dja mak minj ngamyawoyhre kore ngudda. Ngaye kaluk ngaredyak, dja ngadjalwohre munguyh kubolkbubuyika bu ngakelerlobme. Dja nawu yimankek nganngalke wanjh nganbun ngankukkurrme.” ");
INSERT INTO gup_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Wanjh Yawey bimarneyimeng, “Burrkyak, dja bu nangale ngunbun yirrowen, wanjh kunu seven bininjwali kabirridowen.” Wanjh nungka Yawey bikukbimbom Cain ba minj nangale nawu bingalkemeninj bibuyi. ");
INSERT INTO gup_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Wanjh Cain wam bolkbawong kumekbe kore Yawey ni, wanjh nungka wam ni kore kubolkwarlah kabolkngeyyo Nod, koyekkah kore Eden. ");
INSERT INTO gup_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain wanjh beneyonginj ngalbininjkobeng nuye, wanjh ngaleng yawkani, wanjh biyawmey Enoch. Cain rurrkdundulubuni kubolkkimuk wanjh kunu bolkngeykurrmeng Enoch, beywurd bolkngeykenkang. ");
INSERT INTO gup_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoch nunganwali bibornang Irad, nawu nunganwali Irad bibornang Mehujael, Mehujael wanjh bibornang Methushael, dja Methushael nunganwali bibornang Lamech. ");
INSERT INTO gup_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech benbenemey daluk bokenh, ngalkudji ngeyyoy Adah, dja ngalbuyika ngeyyoy Zillah. ");
INSERT INTO gup_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah wanjh biyawmey Jabal. Dja nungka Jabal wanjh Mawah bedberre nawu kabirriyo kore dabburlin, dja kabirrimirndenahnan mayh. ");
INSERT INTO gup_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nawu Jabal benedanginj wanjh ngeyyoy Jubal, dja nungka wanjh Mawah bedberre nawu kabirribun lyre manbu yiman guitar, dja mak kabirribuhme nawu flute. ");
INSERT INTO gup_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Dja Zillah ngaleng mak biyawmey narangem nawu ngeyyoy Tubal-Cain, dja nungka marnbuni kukbubuyika yehyeng bu wirlmurrng bronze dja iron. Kaluk Tubal-Cain benedanginj ngaldaluk, ngaleng wanjh ngeyyoy Naamah. ");
INSERT INTO gup_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Wanjh Lamech benbenemarneyimeng ngalbibininjkobeng nawu nuye, yimeng, “Ngudda nawu Adah dja Zillah ngalbibininjkobeng ngardduk, kandibekka, kunwok ngardduk ngunebekka. Ngaye ngabom bininj ngakukkurrmeng bu nungka werrk nganbom, yawurrinj ngabom bu nungka werrk ngankanjbarrhmey. ");
INSERT INTO gup_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Bu seven bininj birridowimeninj bu Cain nangale bibuyi bikukkurrmeninj, wanjh seventy seven bininj kabirridowen bu nangale nganbun ngaye Lamech ngankukkurrme.” ");
INSERT INTO gup_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam beneyawoyhyonginj ngalbininjkobeng nuye wanjh ngaleng biyawmey narangem dja bingeykurrmeng Seth. Ngalkai yimihyimi, “God nganwong nabuyika wurdyaw bimarnebolkmey Abel, dja Cain bibom.” ");
INSERT INTO gup_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth warridj bibornang narangem, dja bingeykurrmeng Enosh. Wanjh yiman bu kunmekbe bininj birridedjdjingmangi birrimarnekayhmi Yawey nuye kunngey bu birrihdi yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Kuhni wanjh kabimdi kabenyolyolme Adam nuye nawu benbornang dja nawu benkebmawahmeng. Bu God benmarnbom bininj, wanjh benmarnbom bu kabirrirohrok nungka nawu God. ");
INSERT INTO gup_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Benmarnbom bininj dja daluk, benmarneyimeng kunmak kunwok, dja benngeykurrmeng “Bininj”. ");
INSERT INTO gup_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Bu Adam mimbini mandjewk 130, wanjh bibornang beywurd nawu nungka benerohrokni, dja bingeykurrmeng Seth. ");
INSERT INTO gup_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Dja bu Seth danginj, Adam djahdjalmimbini mandjewk 800, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Wanjh mandjewk nuyeni rowk Adam bu mimbini wanjh nine hundred dja thirty, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Bu Seth mimbini mandjewk 105, wanjh bibornang nawu Enosh. ");
INSERT INTO gup_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Dja bu Enosh danginj, Seth djahdjalmimbini mandjewk 807, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Wanjh mandjewk nuyeni rowk Seth bu mimbini wanjh 912, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Bu Enosh mimbini mandjewk 90, wanjh bibornang Kenan. ");
INSERT INTO gup_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Dja bu Kenan danginj, Enosh djahdjalmimbini mandjewk eight 815 mak benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Wanjh mandjewk nuyeni rowk Enosh bu mimbini wanjh 904, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Bu Kenan mimbini mandjewk 70, wanjh bibornang Mahalalel. ");
INSERT INTO gup_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Dja bu Mahalalel danginj Kenan djahdjalmimbini mandjewk 840, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Wanjh mandjewk nuyeni rowk Kenan bu mimbini wanjh 910, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Bu Mahalalel mimbini mandjewk 65, wanjh bibornang Jared. ");
INSERT INTO gup_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Bu Jared danginj, Mahalalel djahdjalmimbini bu mandjewk 830, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Wanjh mandjewk nuyeni rowk Mahalalel bu mimbini wanjh 895, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Bu Jared mimbini mandjewk 162, wanjh bibornang Enoch. ");
INSERT INTO gup_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Dja bu Enoch danginj, Jared djahdjalmimbini mandjewk 800, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Wanjh mandjewk nuyeni rowk Jared bu mimbini wanjh 962, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Bu Enoch mimbini mandjewk 65, wanjh bibornang Methuselah. ");
INSERT INTO gup_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Dja bu Methuselah danginj, Enoch munguyh benehdjaldjarrkrey God bu mandjewk 300, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Wanjh mandjewk nuyeni rowk Enoch bu mimbini wanjh 365. ");
INSERT INTO gup_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoch benehdjarrkrey God, kaluk baldjalyakminj, dja God birrarrkidmey bikang. ");
INSERT INTO gup_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Bu Methuselah mimbini mandjewk one 187, nungka bibornang Lamech. ");
INSERT INTO gup_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Dja bu Lamech danginj, Methuselah djahdjalmimbini mandjewk 782, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Wanjh mandjewk nuyeni rowk Methuselah bu mimbini wanjh 969, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Bu Lamech mimbini mandjewk 182, wanjh nungka bibornang beywurd, dja bingeykurrmeng Noah, mak yimeng, “Nungka kaluk kankangemarnbun kadberre, bu karrihdurrkmirri dja mak karrihngudjngarrhme bulkkidj duninjh, bu karribolkyilkbun kunrorre, manbu Yawey marnbom kunyid.” ");
INSERT INTO gup_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Dja bu Noah danginj, Lamech djahdjalmimbini mandjewk 595 dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Wanjh mandjewk nuyeni rowk Lamech bu mimbini wanjh 777, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Bu Noah mimbini mandjewk 500, wanjh benbornang Shem, Ham dja Japheth. ");
INSERT INTO gup_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bu bininj birridedjdjingmey birrimirndewernmerreni kore kurorre, wanjh ngalbebeywurd bindimarnedanginj. ");
INSERT INTO gup_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Wanjh yikahwi nawu birrikukyimi yiman angel rerrih, bu bedda bindinang birrimekbe daluk birrinang birrimakkaykenhni, wanjh bindimey nawu bindibebbehdjarrngbom dja birrimarreni. ");
INSERT INTO gup_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Wanjh Yawey yimeng, “Kunngolek ngardduk minj munguyh karri kore bininj, dja bedda djalbininjwi, minj kabirrimimbi munguyh, kaluk ngamarnbun mandjewk bedberre bu 120, wanjh kabirridowen.” ");
INSERT INTO gup_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Kaluk kumekbe wanjh birrini kore kurorre nawu birringeyyoy Nephilim, kaluk birrikornamkuyengni duninjh dja birrikukkihkimukni dorrengh. Mak rerre birrini bu birrimekbe nawu birrikukyimi yiman angel rerrih birriyoy ngalbebeywurd bedberre bininj, dja bindimarneyawdanginj wurdwurd. Bedda wanjh birrimekbe nawu korrokoni birrihni nawu bindiyurrhkeyi birribuyika, dja bininj birriwarlahkenh bindiburrbuni bindiburlumi dja bindiyolyolmi. ");
INSERT INTO gup_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Wanjh Yawey bennang bininj rowk nawu birrihni kurorre dja bennang birriwarreminj duninjh, dja yehyeng rowk nawu bininj birrihburrbuni kukangebeh bedberre wanjh djalwernhwarreni duninjh bu munguyh. ");
INSERT INTO gup_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Wanjh Yawey njilngwarreminj duninjh bu bininj benmarnbom kore kurorre, dja kangewarreminj. ");
INSERT INTO gup_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Wanjh kunmekbe Yawey yimeng, “Ngaye ngabenbularrbun bininj rowk nawu ngabenmarnbom, ngabenyakwon rowk nawu kabirrihni kurorre; bininj, mak mayh duninjh, dja mayh nawu kawake, dja nawern warridj nawu welyi nawu kare kuwonge, ngabenyakwon rowk, dja nganjilngwarreminj bu ngabenmarnbom.” ");
INSERT INTO gup_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Dja nadjalkudji bininj Noah, wanjh Yawey bimakwam bu namakni nuye. ");
INSERT INTO gup_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Kuhni wanjh kabiyolyolme Noah. Noah wanjh namakni, nungka wanjh nadjalkudjini namakni kore birriwern rowk nawu birridjarrkmimbini. Nungka munguyh benehdjarrkrey God. ");
INSERT INTO gup_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nungka Noah benkarrmi danjbik bebeywurd, Shem, Ham dja Japheth. ");
INSERT INTO gup_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dja bininj rowk God bennang birriwarreminj duninjh, dja mak wernminj duninjh bu birrihburreni kore kurorre rowk. ");
INSERT INTO gup_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God bolknang kurorre rowk, nang bolkwarreminj bu bininj rowk kore kurorre birrihkurduyimi kunwarre. ");
INSERT INTO gup_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Wanjh God bimarneyimeng Noah, yimeng, “Ngaye nganjilngbekkarrinj ngabenyakwon rowk nawu kabirrimimbi, dja wernminj duninjh kore kurorre bu kabirrihburren. Kanbekka, marneyime, ngaye bedda ngabenyakwon dja kunrorre dorrengh ngabendjarrkyakwon. ");
INSERT INTO gup_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Wanjh yimarnbu Ark manbu kabbala mankimuk ke, kundulk manbu karrulkngeyyo cypress yirrulkma yirrundulubu, dja yirurrkmarnbun kunrurrkwern, dja mak yima manbu tar dja yibelebelbmen kururrk dja mak kuberrk, ba kukku minj kambongimen. ");
INSERT INTO gup_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kuhni wanjh yikurduyimen bu yimarnbun; kuhni kare mankuyengkenh, 140 metres, dja kuni kayime mandedjwarlah, 23 metres, dja bu kakodj wanjh 13 metres. ");
INSERT INTO gup_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Yimarnbu mak kaddumkah ngarre ark, dja yuwn yibangmekodjbalhme. Yiwohbawon 50 centimetres kore kaddum kungorrk ngarre ark. Kaluk kunrurrkdangmaye yiname kungorrk, dja balabala yimarnbun danjbik yiman kanjdji, kubulkayh dja mak kaddum. ");
INSERT INTO gup_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Dja yina, ngaye wanjh ngamunkewe kundjurrh kore kurorre, kabenkebngakke rowk nawu kabirrimimbi kabenyakwon, kabirridowen rowk yehyeng nawu kunngolek kakarrme kondah kabirrihni kurorre. ");
INSERT INTO gup_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Dja kaluk ngarayekwon kunwok ngardduk ngawokkurrmerren bu berrebbun ngudda. Ngudda kaluk yibidbun kore kabbala, ngudda, bebeywurd ke, ngalbininjkobeng ke, dja ngalbibininjkobeng bedberre bebeywurd ke, wanjh ngurridjarrkbidbun. ");
INSERT INTO gup_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ngudda mak yibenngimewe mayh bokenhbokenh nawu kukbubuyika rowk nawu kabirrimimbi, kaluk nakudji narangem dja ngalkudji ngaldaluk birribebbehkukbubuyika rowk, ba kunu ngurridjaldjarrkdarrkid. ");
INSERT INTO gup_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kaluk nawern mayh nawu welyi birribebbehkukbubuyika, mayh duninjh birribebbehkukbubuyika, dja mayh nawu kawake kurorre birribebbehkukbuyika, kaluk bokenh birribebbehkukbubuyika rowk wanjh kabirrimre kore ngudda, ba kunu kabirridjaldarrkid. ");
INSERT INTO gup_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Dja mak manme yika manbu manbubuyika rowk, dja yikarekurrmen, manbu ngudda ngurringun dja mak bedda mayh kabirringun.” ");
INSERT INTO gup_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Wanjh kuhni Noah kurduyimeng rowk kore God biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Wanjh Yawey bimarneyimeng Noah, “Yibidbu kore kabbala, ngudda dja nawu ngurrimud ngurridjarrkbidbu, dja ngaye ngalkeng ngudda yidjalkudji nawu ngayime yimak, kore birridjalwern rowk nawu bolkkime ngurridjarrkmimbi. ");
INSERT INTO gup_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Yibenka seven narahrangem dja seven ngaldahdaluk birribebbehkukbubuyika rowk mayh nawu ngurriyime bele nawu ngurringun, dja mak yibenka nakudji narangem ngalkudji ngaldaluk mayh birribebbehkukbubuyika rowk nawu ngurriyime burlerri nawu minj ngurringun. ");
INSERT INTO gup_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Dja mak yibenka seven narahrangem dja seven ngaldahdaluk nawu mayhmayh nawu kare kuwonge, birribebbehkukbubuyika rowk. Kuhni wanjh yikurduyimen ba munguyh kabirridjaldarrkid, birribebbehkukbubuyika rowk kore kubolkbubuyika kurorre. ");
INSERT INTO gup_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Dja kaluk bu kunkodjke seven wanjh ngaye ngamunkewe mandjewk, kadjaldjakdung munguyh bu kunbarnangarra dja kunkak bu kunkodjke forty, dja ngabenbularrbun ngabenyakwon rowk nawu kabirrimimbi nawu ngabenmarnbom.” ");
INSERT INTO gup_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Wanjh Noah kurduyimeng rowk kore Yawey biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah wanjh mandjewk nuyeni 600 bu kundjurrh bebmeng kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Wanjh Noah dja bebeywurd nuye, ngalbininjkobeng nuye, dja ngalbibininjkobeng bedberreni nawu bebeywurd, bedda wanjh birribidbom kore kabbala ba minj kundjurrh benkebnguyi. ");
INSERT INTO gup_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Dja birridjarrkbidbom warridj mayh duninjh nawu bininj birriyimi bele dja burlerri, dja nawern nawu welyi, mak mayh nawu kawake kurorre, narahrangem ngaldahdaluk birribebbehkukbubuyika rowk, wanjh Noah birridjarrkbidbom kore kabbala. Kunmekbe kurduyimeng bu God biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Wanjh bu kunkodjke seven wanjh kundjurrh kumbebmeng kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Bu Noah nungka mimbini 600 mandjewk kaluk bu kunbarnangarra seventeen kore dird bokenh, wanjh kukku manbu kanjdjibeh kurorre kumhdjalbobebmerrinj, mak yiman ngolduhmeng dja kumdjurrhbumi. ");
INSERT INTO gup_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Wanjh djahdjaldjakdungi kore kurorre bu kunbarnangarra dja kunkak bu kunkodjke forty. ");
INSERT INTO gup_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Wanjh bu kunmekbe kunbarnangarra Noah bidbom kore kabbala, bebeywurd birridjarrkbidbom nawu Shem, Ham dja Japheth, mak Noah nuye ngalbininjkobeng, dja ngalbibininjkobeng bedberre nawu birridanjbik bebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Dja mak birridjarrkbidbom mayh kele birribebbehkukbubuyika rowk, dja mayh kelebuk birribebbehkukbubuyika rowk, dja mak mayh nawu kawake kurorre birribebbehkukbubuyika rowk, dja mak mayhmayh birribebbehkukbubuyika rowk, birribebbehkukbubuyika rowk nawu birriwelyi. ");
INSERT INTO gup_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Kaluk bokenhbokenh birribebbehkukbubuyika rowk nawu birrikarrmi kunngolek dja birrimimbini, Noah birridjarrkbidbom kore kabbala, ngalkudji ngaldaluk dja nakudji narangem birribebbehkukbubuyika rowk nawu birrimimbini, birringimeng. Kunmekbe birrikurduyimeng bu God biwokrayekwong Noah. Wanjh nungka Yawey biwelengdangbalhmeng bedberre. ");
INSERT INTO gup_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Wanjh kundjurrh djalbobidbuni munguyh bu kunkodjke forty, dja bowernmerrinj, wayhkeng kabbala kaddumkah wam, kurorre bolkbawong. ");
INSERT INTO gup_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Wanjh bokihbokimukmeni dja munguyh djahdjalbobidbuni kore kurorre, dja kabbala darlkadarlkani kaddum kubokehkekeb. ");
INSERT INTO gup_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Kaluk bobidburrinj bulkkidj, dja manwarddekuyengkuyeng kukku warddebarrkbom rowk. ");
INSERT INTO gup_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Dja mak munguyh djalbobidburreni bobidbom wernhwarddekodjyibkeng rowk, kaddum balwernhbowayhmeng seven metres. ");
INSERT INTO gup_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Wanjh nadjalwern rowk nawu birrimimbini nawu birrihrey kurorre birriyakminj rowk; nawern nawu welyi, mayh kelebuk dja kele, nawarlahkenh rowk nawu birrimirnderey kurorre, dja mak bininj rowk. ");
INSERT INTO gup_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Birriwern rowk nawu birrihni kuberrkkombuk dja birrikarrmi kunngolek bu birrimimbini wanjh birridowerrinj rowk. ");
INSERT INTO gup_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","God benbularrbom benyakwong rowk nawu birrimimbini kurorre; bininj, dja mayh duninjh, dja mayh nawu kawake kurorre, dja nawern nawu welyi nawu kare kuwonge, bedda rowk benbularrbom kore kurorre. Noah nadjalkudji dja nawu birrihdjarrkni kore kabbala birridjalmekbe wanjh birridarrkidni. ");
INSERT INTO gup_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kaluk manbu kukku yiman wohrnani rerrih kore kurorre bu kunkodjke 150. ");
INSERT INTO gup_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Wanjh God benburrbom Noah dja mayh rowk nawu kele dja kelebuk nawu birridjarrkdahkendi kabbala, wanjh nungka God munkeweng kunmayorrk kore kurorre, dja bokohbokolungi. ");
INSERT INTO gup_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kukku manbu kumbobebmi kanjdjibeh kurorre wanjh bongurdmeng, dja mak kore ngolduhmi wanjh balhmeng, dja mandjewk ngurdmeng. ");
INSERT INTO gup_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Dja kukku yeledj djahdjalbokolungi munguyh. Bu kunkodjke 150 wanjh bokolurrinj, ");
INSERT INTO gup_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","dja bu kunbarnangarra seventeen bu dird seven wanjh manbu kabbala barndanginj kuwarddekimuk kawarddengeyyo Ararat. ");
INSERT INTO gup_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kukku munguyh djahdjalbokolungi bu dird ten. Kaluk bu kunbarnangarrakudji bu dird ten wanjh warddebebmeng birriwarddekodjnang kunwarddebubuyika. ");
INSERT INTO gup_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kaluk bu kunkodjke forty yakminj, wanjh Noah dangmarrhmey window kore kabbala manbu marnbom kore kabbala, ");
INSERT INTO gup_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","dja munkeweng nakudji wakwak, dja namekbe wakwak djahdjalrengehrey munguyh madbuni kukku kahbokolungkenh kurorre. ");
INSERT INTO gup_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Wanjh Noah munkeweng dorddorok ba kanan bu kunubewu kukku bokoluy kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Dja nawu dorddorok minj baleh bolkngalkemeninj bu rerrkayi, wanjh bimarnedurndi Noah kore kabbala, dja kukku boyohboyoy kurorre rowk. Wanjh Noah bidbebmeng mey ngalmekbe dorddorok, ngimowong kore nungka di kore kabbala. ");
INSERT INTO gup_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Wanjh Noah madbuni kunkodjke seven, wanjh kunu yawoyhmunkeweng dorddorok kabbalabeh. ");
INSERT INTO gup_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wanjh bu wolewolehminj ngalmekbe dorddorok bimarnedurndi, dja manmalaworrkerrnge dorrengh kore kukeb ngarre, manbu bolkkime ngaleng malaworrdurrkmengbeh kore olive kundulk, wanjh kunu Noah burrbom bu bokolurrinj kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Wanjh yawoyhmadbom kunkodjke seven, dja yawoyhmunkeweng dorddorok, dja kunukka minj ngaleng biyawoyhmarnedurndeyi. ");
INSERT INTO gup_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Wanjh bu Noah mandjewk nuyeni 601, bu kunbarnangarrakudjini bu dird nakudji wanjh kukku boyakminj kore kurorre dja bolkbukminj. Nawu Noah kodjmarrhmey manmekbe kabbala dja bolknang nang kurorre balbolkbukminj. ");
INSERT INTO gup_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Wanjh bu kunbarnangarra twenty seven bu dird bokenh wernhbolkbukminj rowk. ");
INSERT INTO gup_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Dja God bimarneyimeng Noah, yimeng, ");
INSERT INTO gup_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ngurribebmerrimen kore kabbala, ngudda, ngalbininjkobeng ke, bebeywurd ke dja ngalbibininjkobeng bedberre. ");
INSERT INTO gup_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Dja yibenbebkemen rowk birribebbehkukbubuyika nawu kabirrimimbi nawu ngurridjarrkdahkendi, nawern nawu welyi, mayh duninjh, dja nawarlahkenh rowk nawu kawake kurorre, ba kunu kabirriyawmayawmang kore kurorre, nawern yaw kabirrimang kabirriwernmerren kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Wanjh kunu Noah dja bebeywurd nuye birribebmerrinj, dja ngalbininjkobeng nuye dja ngalbibininjkobeng bedberre nawu bebeywurd, birridjarrkbebmerrinj, dja mak mayh rowk; mayh duninjh, dja nadjalwern nawu kawake kurorre, nadjalwern nawu welyi, nadjalwern rowk nawu kare kurorre, wanjh birrimirndebebmerrinj kabbalabeh, kaluk bedman nawu birribebbehkukrohrokni; ngalbadjan, kornkumo, yayaw, wanjh birridjarrkbebmerrinj. ");
INSERT INTO gup_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Wanjh Noah marnbom altar kunwardde yiwarrudjkenh nuye nawu Yawey, wanjh mey yikahwi kukbubuyika rowk nawu birriyimi bele, kaluk mayh dja mayhmayh, wanjh benkukwurlhkeng kore manmekbe kunwardde bu biwong rowk Yawey. ");
INSERT INTO gup_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Wanjh Yawey bu nomeng manbu manmanjmakni wanjh nungan burrbom baybaywi, yimeng, “Ngaburrbun bininj rowk wanjh munguyh kabirridjaldjare kunwarre kore kukange bedberre bu birriyayahwurd dja mak bu birridabbolk, dja bonj, ngaye minj kunyawoyhkudji ngayawoyhmarnbun kurorre bu kayidwernmerren bedberre. Dja ngaye minj mak kunyawoyhkudji ngabenyawoyhbun ngabenyakwon rowk nawu kabirrimimbi mayh yiman bu kunihbu ngakurduyimeng.” ");
INSERT INTO gup_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Dja bu kunrorre kadjaldi wanjh munguyh kadjalyime bu kamre kore manmim karrudjindangenkenh dja mak bu manme kabirrimoyhmang, dja bu kunbonjdjek kamre mak manbu kawurlhmikenh, dja mak bu kurrung kamre dja kudjewk, kunbarnangarra dja kunkak. Kuhni wanjh munguyh kadjalyime, minj kayakmen.” ");
INSERT INTO gup_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God kunmak kunwok benmarneyimeng Noah dja bebeywurd nuye, dja yimeng bedberre, “Ngurrbenborna birriwern wurdwurd, ngurrimirndewernmerrimen dja ngurrimirndebarlmirrangimen kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dja kaluk ngundikengeme ngudberre bulkkidj mayh nawarlahkenh rowk nawu kare kurorre, dja nadjalwern rowk nawu welyi nawu kare kuwonge, mayh nawarlahkenh rowk nawu kawake kurorre, dja djenj nawarlahkenh rowk nawu kare kukukku, bedda rowk ngudda ngurrbenmarnewohrna. ");
INSERT INTO gup_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dja mayh rowk nawu kamimbi ngaye won ngudberre bu ngurringun, yiman bu kerrngehkenh ngaye wong ngudberre mankolhdebubuyika, wanjh bolkkime won yehyeng rowk.” ");
INSERT INTO gup_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Dja ngaleng, yuwn kunkanj ngurringun nawu kunkurlba dorrengh, dja kundarrkid karri kore kukurlba. ");
INSERT INTO gup_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Dja bu bininj dja nuk mayh nabang kabibun bininj kakurlbare karrowen wanjh woybukkih ngaye ngayime namekbe nunganwali karrowen. Kaluk ngayime karrowen mayh nawu kabibun bininj bu karrowen, dja mak bininj ngayime karrowen nawu kabibun nabuyika bininj bu karrowen. ");
INSERT INTO gup_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Dja ngaye God marnbom ngudberre bininj, yiman ngaye God rerrih karrirohrok, kunmekbekenh kunu nawu kabibun bininj bu karrowen, wanjh namekbe nunganwali bininj kabirribun kabirrikukkurrme. ");
INSERT INTO gup_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Dja ngudda, ngurrbenborna wurdwurd birriwern, ngurrimirndewernmerrimen duninjh, ngurribaldjalwernhmirndewernworrimen kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","10","Wanjh God benmarneyimeng Noah dja bebeywurd nuye dorrengh, yimeng, “Ngaye ngarayekwon kunwok ngardduk ngawokkurrmerren, berrebbun ngudda dja nawu ngurrbenkebmawahme, dja mak nawarlahkenh rowk nawu kamimbi nawu ngurridjarrkni; nawern nawu welyi, mayh kelebuk dja kele, birrimekbe rowk nawu ngurrimdjarrkbebmerrinj kabbala, nadjalwarlahkenh rowk nawu kamimbi kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ngaye ngarayekwon maninjmanu kunwok ngardduk ngawokkurrmerren berrebbun ngudda minj kunyawoyhkudji kundjurrh kabenyawoyhkebngun kabenyakwon rowk nawu kabirrimimbi, minj kunyawoyhkudji kundjurrh kamre nawu kabolkwarrewon rowk kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Dja God yimeng, “Kuhni ngurrina kayime ba ngurriburrbun bu ngawokkurrmerren bu ngaye berrebbun ngudda dja nawarlahkenh rowk nawu kamimbi nawu ngurridjarrkni. Ngawokkurrmerren berrebbun ngudberre, kaluk bedda dorrengh nawu yerreyerre kabirridangerren djalmunguyh. ");
INSERT INTO gup_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ngaye nganameng ngalyod ngardduk kore kungol, kunu wanjh ngurriburrbun bu ngaye ngawokkurrmerrinj berrebbom ngudda dja ngurriwern rowk nawu ngurrini kurorre. ");
INSERT INTO gup_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Bu yarrkka ngaye ngamarnbun kunngol kawernmerren kore kurorre dja ngalyod kabebme kawarnamyongen kore kungol, ");
INSERT INTO gup_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","wanjh kunu ngaburrbun bu ngaye ngawokkurrmerrinj berrebbom ngudberre dja mak ngurridjalwern birrikukbubuyika nawu ngurridjarrkmimbi. Minj kunyawoyhkudji kukku kabowernmerren kayimerran kundjurrh bu kabenkebngun rowk nawu kabirrimimbi. ");
INSERT INTO gup_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Yarrkka bu ngalyod kabebme kore kungol wanjh ngaye nganan dja ngaburrbun bu ngaye God ngawokkurrmerrinj djalmunguyh munguyh, bu berrebbom bininj dja mak birrikukbubuyika rowk nawu ngurrimimbi kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kunu wanjh God bimarneyimeng Noah, yimeng, “Kunmekbe wanjh kayime ba ngurriburrbun bu ngarayekwong kunwok ngardduk, ngawokkurrmerrinj berrebbom ngudberre rowk nawu ngurridjarrkmimbi rowk kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nawu Noah birribebeywurd nuyeni nawu birrimbebmeng kabbalabeh wanjh Shem, Ham dja Japheth. Ham wanjh bibornang Canaan. ");
INSERT INTO gup_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Birrimekbe wanjh birridanjbik nawu Noah nuyeni bebeywurd dja bedda wanjh mawahmawah kadberre karriwern rowk nawu karrihni kubolkbubuyika rowk. ");
INSERT INTO gup_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah wanjh nungka bolkyilkbuni kurorre, dja kaluk dudji manrakel manbu grapes. ");
INSERT INTO gup_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Wanjh bu bonguneng mankalkkid manrakelbeh, wanjh mayahmeng, yongohyoy kuklahlarrkni kururrk kore dabburlin nuye. ");
INSERT INTO gup_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Wanjh Ham nawu bibornang Canaan bikuklarrknang kornkumo dja benbenemarneyimeng birridanginj nuye nawu beneni kuberrk. ");
INSERT INTO gup_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Wanjh Shem dja Japheth benemey manburrba benekurrmeng kukarlang berrewoneng benengorrkang dja benededjkenhdurndi benekukbarrkbom kornkumo nawu kuklarrkyoy. Benekebborledmeng kubuyika benebolknang ba minj benekuklarrknayi kornkumo. ");
INSERT INTO gup_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kaluk bu Noah kodjkerrolkkang bu bonguneng mayahmeng, dja bekkang bu nawu beywurd nayahwurd duninjh nuye bimarnekurduyimeng, ");
INSERT INTO gup_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","wanjh Noah yimeng, “Ngadjare kunyid kamre nuye Canaan kakukmarladjmen duninjh, karrurrkmirri yiman rerrih birrikarremulewam bedberre nawu birridangerrinj.” ");
INSERT INTO gup_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mak kuhni warridj Noah yimeng, “Ngaburlume Yawey, nawu God nuye Shem. Kaluk ngadjare Canaan nuye kabirriyimerran kabindimarnedurrkmirri Shem nuye. ");
INSERT INTO gup_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ngadjare God kabimarnebolkwarlahwon Japheth, dja mak ngadjare Japheth nuye nawu kabenkebmawahme, wanjh kabirridjarrkni kore Shem nuye bininj, dja Canaan nuye kabindimarnedurrkmirri Japheth nuye.” ");
INSERT INTO gup_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Wanjh bu kundjurrh yakminj, wanjh Noah munguyh djahdjalmimbini bu mandjewk 350. ");
INSERT INTO gup_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kaluk mandjewk nuyeni rowk bu mimbini wanjh 950, wanjh doweng. ");
INSERT INTO gup_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Kuhni kabenyolyolme nawu Shem, Ham dja Japheth bindibornang mak bindikebmawahmeng. Bedda nawu Shem, Ham dja Japheth nawu Noah benbornang, wanjh bindibornang bebeywurd kaluk yerrekah bu kundjurrh yakminj. ");
INSERT INTO gup_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Nawu Japheth benbornang bebeywurd nuye wanjh; Gomer, Magog, Madai, Javan, Tubal, Meshech dja Tiras. ");
INSERT INTO gup_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Nunganwali Gomer benbornang bebeywurd; Ashkenaz, Riphath, dja Togarmah. ");
INSERT INTO gup_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Dja Javan nuyeni bebeywurd bu benbornang wanjh Elishah, Tarshish, Kittim, dja nawu Dodanim. ");
INSERT INTO gup_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Bedda rowk wanjh bindimawahmeng birriwern bininj nawu birrini kore kurrula darnkih dja kore manyunkurrbubuyika. Bedda birrikaberrkwernminj, birriyarlarrmeng birribebbehwam kore bedman bedberrekih kunred, birriyawmud duninjh birridjarrkni, kore bedman nawu birriredbo duninjh, birribebbehdjenbubuyika. ");
INSERT INTO gup_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Dja nawu Ham benbornang bebeywurd nuye wanjh Cush, Mizraim, Put dja Canaan. ");
INSERT INTO gup_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Nawu nunganwali Cush benbornang Seba, Havilah, Sabtah, Raamah, Sabtecah. Dja nunganwali Raamah benbenebornang bebeywurd nawu Sheba dja Dedan. ");
INSERT INTO gup_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Dja Cush wanjh mawah nuye Nimrod, nawu nungka yimerranj ngudjmakni duninjh, benyurrhkeng birribuyika bininj rowk kore kurorre birrihni. ");
INSERT INTO gup_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Dja Yawey warridj yimeng bu nungka Nimrod mayhmakni duninjh, wanjh kunu bininj birriyimi, “Yiman yerreh Nimrod, nawu Yawey yimi mayhmakni duninjh.” ");
INSERT INTO gup_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kunred nuye bu wohrnawohrnani, wanjh dedjdjingmey kore kurehred kabolkngeyyo Babel. Kunmekbe kunred kabolkngeyyo warridj Babylon. Dja mak kore kurehred kabirribolkngeyyo Erech, dja Akkad, dja Calneh kore kubolkwarlah kabolkngeyyo Shinar. ");
INSERT INTO gup_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dja kumekbe kunredbeh nungka wam kore kabolkngeyyo Assyria. Kumekbe rurrkdundulubom bolkmarnbom kabolkngeyyo Ninevah, dja mak Rehoboth-Ir, dja Calah. ");
INSERT INTO gup_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Dja mak kunred Resen bolkmarnbom kaluk kubulkayh kore Ninevah dja Calah. Kunmekbe kubolkkimuk kaluk kururrkwern duninjh. ");
INSERT INTO gup_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Dja Mizraim nungka mawah nuye bininj nawu birribebbehdi kore namudbubuyika bedberre, kaluk birringeyyoy Lud, dja mak Anam, dja Lehab, Naphtuh, Pathrus, Casluh, dja mak Caphtor. Kaluk nawu bininj namud bedberre ngeyyoy Caphtor, bindikebmawahmeng bininj nawu Philistiabeh. ");
INSERT INTO gup_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","19","Nawu Canaan nungka wanjh bibornang Sidon nawu nadjdjaman nuye, dja mak nawu nungka Canaan mawahmawah nuye wanjh bininj nawu Heth benkebmawahmeng, dja mak bininj nawu birrikang kore kunred Jebus, dja bininj nawu Amor benkebmawahmeng, dja nawu Gergash benkebmawahmeng, dja bininj nawu birringeyyoy Hiv, dja mak bininj nawu Canaan benkebmawahmeng kore namudbubuyika birringeyyoy Ark, dja mak Arvad, dja mak Zemar, dja mak bininj nawu birrikang kore kunred Hamath, dja kore kunred kabolkngeyyo Sin. Kaluk bedda nawu Canaan nawu birriyawmud duninjh birrikaberrkwernminj birriyarlarrmeng, dja kunred kubolkwarlah kabolkngeyyo Canaan wanjh yiman dedjdjingmey kore Sidon, djalwam kore kunbolk Gaza, darnkih kore Gerar, mak kunmekbe djalwam darnkih kore kunbolkbuyika manbu Sodom, Gomorrah, Admah dja Zeboiim. Kaluk burnbom kore kunred kabolkngeyyo Lasha. ");
INSERT INTO gup_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Bedda wanjh birrimekbe nawu Ham mawah nuyeni nawu bedman birriyawmud duninjh, nawu mak bedman birribebbehdjenbubuyika, dja kunred bedberre bu birrini, dja nawu birriredbo duninjh. ");
INSERT INTO gup_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Dja Shem wanjh benedanginj Japheth. Kaluk nungka Shem nawernwarreni. Nungka wanjh mawah bedberre nawu birriwern Hebrew bininj rowk. ");
INSERT INTO gup_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem benbornang bebeywurd nuye wanjh birringeyyoy Elam, Asshur, Arpachshad, Lud dja Aram. ");
INSERT INTO gup_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Dja nunganwali Aram benbornang Uz, Hul, Gether dja Meshech. ");
INSERT INTO gup_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Dja mak Arphaxad bibornang Shelah, dja nunganwali Shelah bibornang Eber. ");
INSERT INTO gup_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber nunganwali benbenebornang bebeywurd bokenh, nawu nakudji wanjh ngeyyoy Peleg (Peleg kunekke kunngey kayime kalarlmiyindan) dja bu nungka ni wanjh birrirorrelarlmey. Dja nawu benedanginj wanjh ngeyyoy Joktan. ");
INSERT INTO gup_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Nunganwali Joktan benbornang Almodad, Sheleph, Hazarmaveth, Jerah, Hadoram, Uzal, Diklah, Obal, Abimael, Sheba, Ophir, Havilah dja Jobab. Birrimekbe rowk wanjh Joktan nuyeni bebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Wanjh kunred bedberre kore birrini dedjdjingmey kore kunred Mesha, dja djalwamwi darnkih kore kunbolk Sephar kore kubolkduluhdulum kore koyek. ");
INSERT INTO gup_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Bedda wanjh birrimekbe nawu Shem Mawah nuyeni, nawu bedman birriyawmud duninjh, nawu mak bedman birribebbehdjenbubuyika, dja kunred bedberre bu birrini dja nawu birriredbo duninjh. ");
INSERT INTO gup_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Kuhni kabenmulewan bininj mawahmawah bedberre nawu Noah benbornang. Nakka birriyawmud duninjh kabirribebbehngeydingeydi, nawu bedman birriredbo duninjh. Dja birrimekbe kaluk kumekbebeh birriwelengmirndeyarlarrmeng birribebbehwam, birribebbehmarnburrinj bedmandeleng birriredbo kore kurorre rowk. Kaluk yerrekah bu kundjurrh yakminj. ");
INSERT INTO gup_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kerrngehkenhni bininj rowk nawu birrihni kurorre wanjh birriwokkudjini, kundjenkudji birridjarrkwokdi. ");
INSERT INTO gup_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kaluk bu bininj birrihrey koyek wanjh birribolkngalkeng kabbal kore kubolkwarlah kabolkngeyyo Shinar, wanjh kumekbe birriyerrkang. ");
INSERT INTO gup_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wanjh bedda birrimarneyimerrinj, “Kab karrimarnbu manwern brick, karrikinje kukunak ba karayekmen.” Wanjh birribawong kunwardde bu birrirurrkmarnbuni, dja birrimarnbuni manwern brick, dja tar birribarungi bu birribelbmi. ");
INSERT INTO gup_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Wanjh birrimarneyimerrinj, “Kab karrimarnbu kadberre kubolkkimuk, dja karrirurrknamen warridj manrurrkkuyeng duninjh manbu kadjalewi kaddum kungol, ba karringeykukenworren, dja marndi kandikukyarlarrke karribebbehre kubolkbubuyika rowk kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Wanjh Yawey kumkoluy kanan kubolkkimuk dja manrurrkkuyeng manbu bininj birrimarnbuni. ");
INSERT INTO gup_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Dja nungka Yawey yimeng, “Bedda bininj wanjh birridjalkudji dja birriwokkudjiwi. Kuhni wanjh yiman birridjaldedjdjingmey, dja kunwern mak kaluk kabirrikurduyime warridj, wanjh bonj yehyeng nawu bedda kabirrikarremarnbun, yimankek kabirrikurduyime, wanjh minj kabirribarabun. ");
INSERT INTO gup_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kab ngarrkolung ngarrbendjenborledke ba bu kabirribebbehwokwakwarren dja kabirrimayahmerren.” ");
INSERT INTO gup_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wanjh Yawey benyarlarrkeng, benbebbehmunkeweng kumekbebeh birribebbehwam kubolkbubuyika rowk kore kurorre, wanjh birribawong bu kubolkkimuk birrirurrkmarnbuni. ");
INSERT INTO gup_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Dja kumekbe wanjh Yawey benbebbehdjenborledkeng dja birribebbehmayahmeng. Wanjh kunmekbekenh kunu kabolkngeyyo Babel. Kunekke kunngey kayime “Birrimayahmeng”. Dja mak kumekbebeh Yawey benyarlarrkeng benbebbehmunkeweng birribebbehwam kubolkbubuyika rowk kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Kuhni wanjh kabenyolyolme nawu Shem benbornang dja benkebmawahmeng. Kaluk yerrekah mandjewk bokenh bu kundjurrh yakminj, kaluk bu Shem nuyeni mandjewk wanjh 100, nungka wanjh bibornang Arphaxad. ");
INSERT INTO gup_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Dja bu Arphaxad danginj Shem djahdjalmimbini mandjewk 500, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Bu Arphaxad mimbini bu mandjewk 35 wanjh nungka bibornang Shelah. ");
INSERT INTO gup_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Dja bu Shelah danginj, Arphaxad djahdjalmimbini bu mandjewk 403, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Bu Shelah mimbini bu mandjewk 30, wanjh bibornang Eber. ");
INSERT INTO gup_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Dja bu Eber danginj, Shelah djahdjalmimbini mandjewk 403, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Bu Eber mimbini bu mandjewk 34 wanjh bibornang Peleg. ");
INSERT INTO gup_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Dja bu Peleg danginj Eber djahdjalmimbini bu mandjewk 430, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Bu Peleg mimbini bu mandjewk thirty nungka bibornang Reu. ");
INSERT INTO gup_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Dja bu Reu danginj, Peleg djahdjalmimbini bu mandjewk 209, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Bu Reu mimbini mandjewk 32 wanjh nungka bibornang Serug. ");
INSERT INTO gup_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Dja bu Serug danginj, Reu djahdjalmimbini mandjewk 207, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Bu Serug mimbini mandjewk 30, wanjh bibornang Nahor. ");
INSERT INTO gup_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Dja bu Nahor danginj, Serug djahdjalmimbini bu mandjewk 200, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Bu Nahor mimbini mandjewk 29 wanjh nungka bibornang Terah. ");
INSERT INTO gup_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Dja bu Terah danginj, Nahor djahdjalmimbini mandjewk 119, dja benbalbornabornang birribuyika bebeywurd mak ngalbebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Dja Terah bu mimbini mandjewk 70, nungka wanjh benbornang Abram, Nahor, dja Haran. ");
INSERT INTO gup_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Kuhni wanjh kabenyolyolme nawu Terah benbornang dja benkebmawahmeng. Terah wanjh kornkumo bedberre nawu Abram, Nahor dja Haran. Haran nunganwali bibornang nawu Lot. ");
INSERT INTO gup_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kaluk Haran doweng kore kunred bolkngeyyoy Ur kore kubolkwarlah bedberre nawu birringeyyoy Chaldea, kumekbe kore Haran danginj. Dja bu doweng wanjh Terah nawu nuyeni kornkumo, nungka wanjh djaldarrkidni. ");
INSERT INTO gup_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram dja Nahor bindibebbehmey ngalbibininjkobeng. Abram nuyeni ngalbininjkobeng kaluk ngeyyoy Sarai, dja ngalbu Nahor nuyeni ngaleng wanjh ngeyyoy Milcah, ngalbeywurd nuyeni Haran. Nungka Haran wanjh kornkumo berrewoneng Milcah dja Iscah. ");
INSERT INTO gup_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Dja Sarai ngaleng ngalwurdyakni dja ngalwalirrngwarreni. ");
INSERT INTO gup_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kaluk Terah benmey beywurd nuye Abram, dja Mawah nuye nawu Lot nawu Haran bibornang, dja mak ngalbininjdoy nuye Sarai, ngalbu Abram nuye ngalbininjkobeng, dja birridolkkang birribolkbawong Ur kunred bedberre bininj nawu birringeyyoy birrikang Chaldea, dja birribalbolkyikani kunred kubolkwarlah Canaan, dja bu birribebmeng kabolkngeyyo Haran, wanjh kumekbe birriyerrkang birrini. ");
INSERT INTO gup_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah wanjh mandjewk nuyeni 205 bu mimbini, wanjh doweng kore kunred Haran. ");
INSERT INTO gup_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yawey wanjh bimarneyimeng Abram, “Yibolkbawo kekih kunred, yibenbawo nawu ngurrimud, dja nawu kornkumo ke nuyeni, dja yiray kore kunred kubolkwarlah ngaye kaluk bolkbukkan. ");
INSERT INTO gup_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ngaye kaluk won birrimirndewern bininj nawu ngudda yibenkebmawahme, kabirriyimerran birriredbo nawu birrikuken, dja ngaye kaluk marnekurduyime djal kunmak, dja ngaye kaluk ngeykukenwon, dja ngudda yibenmarnekurduyime kunmak bedberre birriwern nawu ngundingeyburrbun. ");
INSERT INTO gup_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nawu ngundimarneyime kunmak, wanjh ngayemanwali ngabenmarneyime kunmak. Dja nawu kabirridjare ke kunyid kabirrimarnbun, ngayemanwali ngabenmarnemarnbun kunyid bedberre. Dja kore ngudda ngabenmarnekurduyime kunmak bedberre nawu birribebbehmud rowk kore kurorre kabirrihbebbehdi.” ");
INSERT INTO gup_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kunmekbe bu Yawey bimarneyimeng, wanjh Abram wam, dja nawu Lot benedjarrkwam. Kaluk mandjewk nuyeni Abram wanjh 75 bu nungka bolkbawong Haran. ");
INSERT INTO gup_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nungka bikang Sarai ngalbu ngalbininjkobeng nuyeni, mak Lot warridj bikang nawu Abram benedanginj Haran biwakwam, dja mak birrimadjkang rowk yehyeng nawu wernworrinj bedberre, dja bininj nawu bindikarremulewani kore Haran nawu bindimarnedurrkmirri. Wanjh bedda birridolkkang birribolkbawong, birribalbolkyikani kubolkwarlah kabolkngeyyo Canaan. Kaluk bu kumekbe Canaan birribolkmey. ");
INSERT INTO gup_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram balhdjalbolkyurrhyurrkeyi kore kubolkwarlah Canaan, kaluk bolkmey kore Shechem kore mandulkkuken dulkdi manu nuyeni Moreh. Bu kunmekbe wanjh bininj nawu birrikang Canaan birrihdjalyingkihni kore kumekbe kubolkwarlah. ");
INSERT INTO gup_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kumekbe wanjh Yawey bimarnebukkarrinj Abram, dja bimarneyimeng, “Kondanjkunu kunred kubolkwarlah ngaye kaluk ngabenbolkwon bininj nawu ngudda yibenkebmawahme.” Wanjh kunu Abram marnbom altar kunwardde yiwarrudjkenh Yawey nawu bimarnebukkarrinj. ");
INSERT INTO gup_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kaluk kumekbebeh nungka Abram djalwam balhbolkyikani kore kuwarddewardde koyekkah Bethel, dja kumekbe dabburlin nameng. Yiman kubulkayh ni, dja Bethel karrikadkah reddi dja Ai wanjh koyekkah. Kumekbe wanjh marnbom altar kunwardde yiwarrudjkenh Yawey nuye dja yiwarrudj di bikayhmeng Yawey nuye kunngey. ");
INSERT INTO gup_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kaluk wanjh Abram dolkkang bolkbawong balhdjalley walem balbolkyikani kore kabolkngeyyo Negeb. ");
INSERT INTO gup_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kaluk kumekbe kunred kubolkwarlah Canaan wanjh djewkwarrewong bolkdarlehminj dja manme birriyawarreni. Dja bu bolkwarreminj duninjh, manme birridjalyawarreni bulkkidj, kunu wanjh Abram koluy wam kore kubolkwarlah Egypt ba kumekbe kadjalwohni waken. ");
INSERT INTO gup_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","12","Bu darnkih bebmeng kore Egypt Abram bimarneyimeng Sarai ngalbininjkobeng nuye, yimeng, “Ngaye ngaburrbun bu ngudda daluk yikukmakkaykenh, dja bu bininj nawu Egyptbeh ngundinan kaluk kabirriyime bu ngudda ngalbininjkobeng ngardduk, wanjh kunu ngandibun ngarrowen, dja ngudda ngundibawon yirrarrkid. ");
INSERT INTO gup_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Wanjh yibenmarneyimen bu ngudda ngarrdanginj, ba ngandinahnan ngandimarneyime kunmak nguddakah, dja mak minj ngandibun, ngandibawon ngarrarrkid nguddakah.” ");
INSERT INTO gup_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Wanjh bu Abram bebmeng kore Egypt, kaluk bininj nawu Egyptbeh birrinang bu ngalmekbe daluk ngalkukmakkaykenhni duninjh. ");
INSERT INTO gup_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Bu bininj birringeykimuk nawu birrimarnedurrkmirri Pharaoh nawu nungka king wohrnani kore Egypt, bu bedda birrinang wanjh birrikukburlumeng kore Pharaoh, dja birrimey birrikang kore Pharaoh kunrurrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kunmekbekenh kunu Pharaoh bimarnekurduyimeng Abram kunmak ngalengkah, dja biwong Abram sheep, bulikki, donkey nawu narahrangem dja ngaldahdaluk, dja mak bininj dja daluk nawu birrimarnedurrkmirri, dja mak mayh nawern nawu camel. ");
INSERT INTO gup_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Wanjh Yawey benmarnemarnbom kunyid bedberre Pharaoh dja nawu birrihdjarrkni kore kunrurrk nuye, kunkihkimuk kundjak benhmangi, bu Saraikenh ngalbu Abram nuyeni ngalbininjkobeng. ");
INSERT INTO gup_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Wanjh Pharaoh bikayhmeng Abram, dja bimarneyimeng, “Njale bu kuhni kanmarnekurduyimeng? Njalekah minj kanmarneyimeninj bu ngaleng ngalbininjkobeng ke? ");
INSERT INTO gup_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Dja njalekah yiyimeng bu ngaleng ngunedanginj ba kunu ngaye ngamey ngamarnbom ngalbininjkobeng ngardduk? Yina, ngahli wanjh ngalbininjkobeng ke, yika mak yidjallaywi.” ");
INSERT INTO gup_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pharaoh benwokrayekwong bininj nuye Abramkah, dja bedda birrimunkeweng ngalbininjkobeng dorrengh nuye, dja mak yehyeng rowk nawu karrmi. ");
INSERT INTO gup_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Wanjh kunmekbekenh kunu Abram bolkbawong Egypt, wanjh dolkkang wam kore Negeb, nungka mak ngalbininjkobeng nuye dja yehyeng rowk nawu karrmi, dja Lot warridj birridjarrkwam. ");
INSERT INTO gup_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram wanjh nungka wernhkukenminj, kaluk karrmi nawern mayh, dja mak money yiman silver dja gold. ");
INSERT INTO gup_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abram rengehrey yeledj, Negeb bolkbawong, djalwam kore Bethel, dja bebmeng kured kubulkayh kore Bethel dja Ai, kore kerrngehkenhni nameng dabburlin nuye. ");
INSERT INTO gup_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Kaluk kumekbe kunu kore kerrngehkenh altar marnbom kunwardde yiwarrudjkenh. Wanjh kumekbe Abram yiwarrudj yawoyhdanginj biyawoyhkayhmeng Yawey kunngey nuye. ");
INSERT INTO gup_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Dja Lot nawu benedjarrkrey Abram, nungka mak karrmi mirndewern mayhbubuyika dja mak dabburlin nawern. ");
INSERT INTO gup_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Minj bolkmakniwirrinj, minj manwern manme diwirrinj bu yimankek benedjarrkniwirrinj, dja nawern yehyeng benebebbehkarrmi, wanjh kunu kunmekbekenh minj benedjarrkniwirrinj. ");
INSERT INTO gup_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Wanjh kunyid ngalmeng berrewoneng bininj nawu bindimarnedurrkmirri, kaluk bedman nawu Abram birrimarnenahnani mayh, dja mak bedman nawu Lot nuye birrimarnenahnani wanjh birridangwerreni. Kaluk kumekbe bininj nawu birrihyingkihni kumekbe kunred kubolkwarlah wanjh birrikang Canaan, dja mak bininj nawu birringeyyoy Periz nuye. ");
INSERT INTO gup_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Wanjh Abram bimarneyimeng Lot, “Yuwn ngarrdurren ngudda ngaye, dja yuwn mak kabirridurren ngudda ke bininj nawu mayh kabirrinahnan dja ngardduk bininj, dja ngad wanjh ngarrmud. ");
INSERT INTO gup_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dja yiddok minj yibolknan kabolkwarlah, ngarrkuklarlmirra ngarrbebbehre. Bu ngudda yibolkdjarrngbun yire kudjakku wanjh bonj ngaye ngare kukun, dja bu ngudda yibolkdjarrngbun yire kukun, wanjh bonj ngaye ngare kudjakku.” ");
INSERT INTO gup_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Wanjh Lot bolknang rowk kabbal kanjdjikanjdji ngarre Jordan mankabo, dja nang bokimukni, dja yiman kayime njilhmi karrmi kubolkwarlahkenh djahdjalley darnkih kore Zoar, bolkrohrokni yiman kayime bu kore manme Yawey dudji kore Eden, dja yiman kayime kubolkwarlah Egypt warridj. Dja bu kunmekbe Yawey minj bangmebolkbularrbuyinj Sodom dja Gomorrah. ");
INSERT INTO gup_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Wanjh kunu Lot bolkdjarrngbom kunmekbe kabbal rowk ngarre kanjdjikanjdji Jordan mankabo, dja djahdjalrey koyek, wanjh kunu kunmekbe benebebbehmunkewerrinj. ");
INSERT INTO gup_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram wanjh ni kore kubolkwarlah Canaan, dja Lot ningihni kore kubolkkihkimuk kanjdjikanjdji kore kabbal ngarre Jordan mankabo. Kaluk nungka nameng dabburlin nuye darnkih kore kunred Sodom. ");
INSERT INTO gup_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Dja bininj nawu birrihni kore Sodom bedda wanjh birrihdjalkadjungi kunwarre, birrihmarneyimi Yawey kunwarre duninjh. ");
INSERT INTO gup_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","15","Bu Lot bibawong, wanjh kalukburrk Yawey bimarneyimeng Abram, yimeng, “Kore yihdi, wanjh yibolkna kakbi, walem, koyek mak karrikad, kumekbe rowk djarreh kore yihbolknan, kaluk ngaye bolkwon ngudda dja nawu ngudda ke yibenkebmawahme, kabirribolkkarrme djalmunguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Dja ngaye kaluk ngabenmarnbun ngudda ke nawu yibenkebmawahme kabirrimirndewernmerren duninjh, yiman kayime kundjulng rerrih kabirrimirndeyimerran. Bu yiman bininj kamirnderohrokme kundjulng ngarre kurorre, wanjh ngudda ke nawu yibenkebmawahme yimankek bedmanwali kabindimirnderohrokme. ");
INSERT INTO gup_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Wanjh yirrolkka, yidjallay kubolkbubuyika djarreh kore kuninjkunu kubolkwarlah, kunmekbe yikurduyimen dja ngaye bolkwon ngudda.” ");
INSERT INTO gup_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kunu Abram madjwabkeng dabburlin nuye dja wam ni kore darnkih oak dulkdingihdi mandulkkuken nuye Mamre kore Hebron, dja kumekbe Abram marnbom altar kunwardde yiwarrudjkenh Yawey nuye. ");
INSERT INTO gup_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kaluk bu kumekbe wanjh kunkarrngbakmeng kings birriwohrnani. Bedda nawu Amraphel nawu wohrnani kore kabolkngeyyo Shinar, dja mak Arioch nawu wohrnani kore kabolkngeyyo Ellasar, Kedorlaomer nawu wohrnani kore Elam, dja Tidal nawu wohrnani kore Goyim. ");
INSERT INTO gup_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Wanjh bedda birrimarnbom kunyid, bindibuni birribuyika kunbidkukudji nawu birribuyika kings, kaluk Bera nawu wohrnani kore Sodom, Birsha nawu wohrnani kore Gomorrah, Shinab nawu wohrnani kore Admah, Shemeber nawu wohrnani kore Zeboiim, dja mak king nawu wohrnani kore Bela, kumekbe kunred warridj kabolkngeyyo Zoar. ");
INSERT INTO gup_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Birrimekbe nawu kunbidkukudji kings birriwokmarnburrinj birriraworrinj kabirribidyikarrmerrenkenh kore kanjdjikanjdji ngarre Siddim, kore bolkkime kabongeyyo “Kurrula Manbu Manbodjirla”. ");
INSERT INTO gup_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Nawu Kedorlaomer benmarnbom birrimekbe kings bu birrimarnedurrkmirri kunkuyeng yiman 12 mandjewk, dja bu mandjewkbuyika thirteen, bedda wanjh birriwarnyakminj, minj birriyawoyhmarrkmayi. ");
INSERT INTO gup_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Wanjh bu mandjewkbuyika fourteen, Kedorlaomer dja bedman nawu birriwokmarnburrinj kabirribidyikarrmerrenkenh, wanjh birrimwam miwadj dorrengh bedberre, dja bindibom bininj nawu birringeyyoy Rephaim kore kunbolk bolkngeyyoy Ashteroth-Karnaim, dja mak bindibom bininj nawu birringeyyoy Zuz kore kunred nuye Ham, dja mak bindibom bininj nawu Em benkebmawahmeng kore kunbolk bolkngeyyoy Shaveh-Kiriathaim. ");
INSERT INTO gup_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Dja mak bindibom bininj nawu Hor benkebmawahmeng kore kuwarddekimuk ngarre kunbolk Seir, wanjh bedda rowk bindibuni, birrihdjalwam kaluk birriburnbom kore kunred El-Paran kore darnkih kubolkdarleh. ");
INSERT INTO gup_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Bu bindibom rowk wanjh birridurndi kore En-Mishpat, kumekbe kunred warridj kabolkngeyyo Kadesh, wanjh bindibom bindimarnebolkmarladjwong kunred bedberre bininj nawu Amalek birringeyyoy dja mak nawu Amor benkebmawahmeng birrihni kore kunred Hazazon-Tamar. ");
INSERT INTO gup_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Wanjh kumekbe kunbidkukudji kings nawu birriwohrnani kore Sodom, Gomorrah, Admah, Zeboiim dja Bela Zoar, wanjh bindimey miwadj bedberre birriraworrinj ba bu kabirriburren kore kanjdjikanjdji ngarre Siddim. ");
INSERT INTO gup_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Wanjh bindibuni Kedorlaomer nawu king wohrnani kore Elam, Tidal nawu wohrnani kore Goyim, Amraphel nawu wohrnani kore Shinar, dja Arioch nawu wohrnani kore Ellasar, kaluk bedman nawu kunkarrngbakmeng kings wanjh bindibalbuni nawu bedman kunbidkukudji king. ");
INSERT INTO gup_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kaluk kumekbe kore kanjdjikanjdji ngarre Siddim wanjh kudjorlokwernni, kore mankalkkid bitumen kalkkidyongoyoy, dja bu king nawu benewohrnani kore Sodom dja Gomorrah bu bedda benekelerlobmeng, yikahwi bininj berrewoneng birrimankang kore kudjorlohdjorlok, dja birribuyika birrikelerlobmerrinj kore birriwarddebidom kuwarddewardde. ");
INSERT INTO gup_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Dja nawu bedman kunkarrngbakmeng kings nawu birridjarrkrey nawu bindiwidnani bindibom, wanjh birrikang rowk yehyeng bedberre bininj nawu birrihni kore Sodom dja Gomorrah, dja manme rowk bedberre birrikang dja birriwam. ");
INSERT INTO gup_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Dja warridj birridarrkidmey dja birrikang Lot, nawu Abram benedanginj biwakwam, nawu nungka kumekbe ni kore Sodom, dja mak birrikang nawu yehyeng nuye wanjh birridjarrkwam. ");
INSERT INTO gup_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kaluk nakudji nawu kelerlobmeng, wam bimarneyimeng Abram nawu Hebrew bininj. Dja Abram ni darnkih kore mandulkkuken dulkdingihdi nuyeni Mamre nawu bininj bedberre birringeyyoy Amor, nawu birridanginj Eshcol dja Aner, nawu bedda birriwokmarnburrinj Abram kabirribidyikarrmerrenkenh. ");
INSERT INTO gup_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Bu Abram bekkang bu nungka nawu benemud birrikelehmeng birrimey birrikang, wanjh nungka benkayhmeng 318 bininj nawu birriburrbuni bu kabirriburrenkenh, nawu bedda birridanginj kore nungka Abram kunred nuye, dja wanjh bedda bindikadjuy, birridjalwam kore kunred Dan birribebmeng. ");
INSERT INTO gup_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Dja bu kukak Abram benlarlmey bininj nuye nawu birriburreni, wanjh bindibom bindikadjuy kore kunred Hobah birribebmeng, kaluk kakbikah kunred Damascus. ");
INSERT INTO gup_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Dja nungka Abram durndiweng rowk yehyeng, dja mak bimdurndiweng Lot nawu namud nuye dja mak yehyeng nawu Lot nuyeni, dja mak morlehmorlenj dja birribuyika bininj nawu bindikang. ");
INSERT INTO gup_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Wanjh bu Abram kumdurndi bu benbom Kedorlaomer dja birribuyika kings nawu nungka birribidyikarrmerreni, wanjh king nawu wohrnani kore Sodom kumbebmeng kabirrabke kore kanjdjikanjdji ngarre kunred Shaveh, kaluk kumekbe kunngey kamenyime, “King nuye Kanjdjikanjdji”. ");
INSERT INTO gup_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Wanjh Melchizedek nawu king bu wohrnani kore kunred Salem, nungka kumyibebmeng buriddi dja wine, nungka wanjh priestni yiwarrudj dingihdi nuye God nawu Kawernhwohrnan duninjh. ");
INSERT INTO gup_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Wanjh nungka Melchizedek kunmak kunwok bimarneyimeng Abram, yimeng, “Ngadjare God ngunmarnekurduyime kunmak Abram, nawu nungka God Kawernhwohrnan duninjh, nawu bolkmarnbom kaddum dja kurorre. ");
INSERT INTO gup_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Dja ngaburlume God nawu Kawernhwohrnan duninjh nawu ngunbidyikarrmeng yibenbom nawu ngundiwidnani.” Wanjh Abram yiman larlmey yehyeng rowk nawu mey dja ten madjyoy, wanjh nakudji kore tenbeh Abram bimadjwoyi Melchizedek. ");
INSERT INTO gup_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Dja namekbe king nawu wohrnani kore Sodom yimeng, “Kanwo ngaye nawu bininj rowk ngardduk, dja nawu yehyeng, wanjh ngudda yidjalkarrmen yingan ke.” ");
INSERT INTO gup_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Dja Abram bimarneyimeng namekbe king nawu wohrnani kore Sodom, yimeng, “Ngaye ngabidwayhmeng nuye Yawey God nawernhkuken duninjh nawu bolkmarnbom kaddum dja kurorre, dja ngawokkurrmerrinj nuye kunwok kunrayek duninjh, ngayimeng bu minj njale ngaye ngakan nawu ngudda ke, minj mak ngawohkan kunyarl kunkudji, dja mak kunyarl ngarre nawu yirrengedjongburren, minj ngakan ba minj ngudda kaluk yiwohyime bu marndi yimankek ngudda kankukenhmeng. ");
INSERT INTO gup_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Minj njale ngakan, djal bonj ngakang nawu bininj ngardduk birringuneng, dja nawu yilarlmang yibenwon bedberre bininj nawu ngarridjarrkwam yiman Aner, Eshcol dja Mamre, bedda yibenwo nawu bedberre.” ");
INSERT INTO gup_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kaluk rerrikah, Yawey nuye kunwok bimarnebebmeng Abram bu yiman biwaralnani rerrih, bu nungka Yawey yimeng, “Abram, yuwn yikele, dja ngaye yiman ngakandename ke, ngabenngurdke bu yimankek ngundibun, dja kaluk ngaye karremulewan bu kunkimuk duninjh.” ");
INSERT INTO gup_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Dja Abram yimeng, “Aba, ngudda Yawey nawu yidjalwohrnan rowk, kaluk njale yimankek ngudda kanwon, dja ngaye munguyh wurdyawyak ngahre, dja ngawakwan wanjh Eliezer nawu nakang Damascus wanjh kamang ngardduk yehyeng?” ");
INSERT INTO gup_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Mak Abram yimeng, “Yina, ngudda minj wurdyaw kanwoyi, wanjh kunu nakudji nawu nganmarnedurrkmirri nungka wanjh kamang rowk ngardduk bu ngawakwan.” ");
INSERT INTO gup_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Wanjh kaluk kuninjkunu kunwok Yawey bimarneyimeng, yimeng, “Minj nungka kamang nawu ke yehyeng, dja yingan ke wurdyaw nawu kaluk rerrihkah yibornan kore kunburrk ke, namekbe kaluk kamang rowk.” ");
INSERT INTO gup_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Dja Yawey bibebkeng Abram kuberrk dja yimeng, “Kaddum yingolna, wardibu yimirnderohrokmen mankokkarrng? Wanjh nawu ngudda yibenkebmawahme yiman kunmekbe rerrih kabirrimirndeyimerran!” ");
INSERT INTO gup_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Wanjh Abram biwoybukwong Yawey bu bimarneyimeng, wanjh kunmekbekenh Yawey yimeng, “Abram nungka namak kore ngaye.” ");
INSERT INTO gup_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mak Yawey bimarneyimeng, “Ngaye wanjh Yawey nawu bebkeng kunredbeh bolkngeyyoy Ur, kore bininj nawu Chaldea kabirrini, djahdjalmikani ba bolkwon kondanjkunu kunred kubolkwarlah yibolkkarrme.” ");
INSERT INTO gup_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Dja Abram yimeng, “Ngudda Yawey nawu yidjalwohrnan rowk, kaluk baleh kayimerran ba ngaburrbun bu ngaye ngabolkmang rowk?” ");
INSERT INTO gup_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Wanjh Yawey bimarneyimeng, “Kanmarneka bulikki ngaldaluk, mak goat ngaldaluk, dja sheep narangem, kaluk mandjewk bedberre wanjh danjbik, dja yimka warridj dorddorok dja mak korlobok yaw.” ");
INSERT INTO gup_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Wanjh Abram benmey rowk bimmarnekang wanjh benkukwarlaybom benbebbehkukwarlaykurrmekurrmeng, dja nawu mayhmayh minj benbenekukwarlabuyi dja benbenedjalkukmokenkurrmeng. ");
INSERT INTO gup_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Wanjh bu marram kumkoluy kore mayh kukyohkukyoy, wanjh Abram benkelehmeng. ");
INSERT INTO gup_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Bu balhdungyibmi Abram keyonginj wanjh kerroweng duninjh, wanjh yiman kundulmuk kunkak bibarrkbom bikelehmeng duninjh. ");
INSERT INTO gup_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Wanjh Yawey bimarneyimeng, “Kuninjkunu wanjh yiburrbu bu woybukkih nawu ngudda ke yibenkebmawahme kaluk kabirridjalwohni kore kunred kubolkwarlah minj bedman bedberrekih, dja birribuyika kabindibongkarrme dja kabindimarnbun kabirridurrkmirri bedberre, dja kabindimarneyime kunwarre yiman kabindikuyindombuyhwe bu mandjewk 400. ");
INSERT INTO gup_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Dja ngaye kaluk ngabendung birrimekbe nawu birriredbo nawu kabindimarnedurrkmirri, dja kaluk rerrikah ngudda ke bininj kabirrimbebme, nadjalwern duninjh yehyeng dorrengh kabirrimyibebme. ");
INSERT INTO gup_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Dja nguddambu, bonj, ngudda kaluk yirrowen bu yiwernhkohbanjmen duninjh dja ngundikukdudjeng. Kaluk yimalngre kore mawahmawah ke birriyingkihmalngdokmeng, kaluk kunmodmikenh dorrengh. ");
INSERT INTO gup_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kaluk bu ngudda yibenbornan, dja bedmanwali kabindibornan, dja bedmanwali kabindibornan, dja mak bedmanwali, wanjh kaluk kunmekbe wanjh ngudda ke nawu yibenkebmawahme kabirrimdurndeng kondah, dja med rerrih, bininj nawu Amor benkebmawahmeng minj bangmewernhwernmerrimeninj kunwarre bedberre.” ");
INSERT INTO gup_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Wanjh bu dungyibmeng dja ngokdanj, kaluk bebmeng djabbirlana kunakkenh kaluk kundolng dorrengh, mak kunkong manbu manwoldjen dorrengh, wanjh bu benebebmeng wanjh benewam kubulkayh kore kukdakukdarrahyoy. ");
INSERT INTO gup_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Wanjh bu kundjalmekbe kunbarnangarra Yawey wokkurrmerrinj bimarneyimeng Abram biberrebbom, yimeng, “Kaluk ngudda ke nawu yibenkebmawahme ngaye ngabenbolkwon kondanjkunu kunred kubolkwarlah, kabolkdedjdjingmang kore mankabo ngarre Egypt, kadjalewi kabolkburnbun kore mankuken mankabo manbu Euphrates. ");
INSERT INTO gup_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Kaluk kunred kubolkwarlah bedberre nawu Ken benkebmawahmeng, dja nawu Keniz benkebmawahmeng, dja nawu Kadmon benkebmawahmeng, dja mak ngabenbolkwon ke mawahmawah bedberre kunred nawu Heth benkebmawahmeng, nawu Periz benkebmawahmeng, nawu birringeyyoy Reph, dja mak bininj nawu Amor benkebmawahmeng, dja mak bininj nawu birrikang Canaan, dja nawu Girgash benkebmawahmeng, dja mak bininj nawu birrikang Jebus.” ");
INSERT INTO gup_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Kaluk Sarai ngalbu Abram ngalbininjkobeng nuye minj bimarneyawmayi. Dja Sarai bikarrmeng ngalkudji ngalyawk ngalbu Egyptbeh ngalbu Sarai bimarnedurrkmirri, dja ngaleng wanjh ngeyyoy Hagar. ");
INSERT INTO gup_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Wanjh Sarai bimarneyimeng Abram, yimeng, “Yina, Yawey wanjh nganmarnbom minj ngayawmang, wanjh yima ngalbu nganmarnedurrkmirri, dja nguneyuwn, kunubewu ngaleng kayawmang wanjh namekbe ngaye ngardduk wurdyaw.” Wanjh Abram biwokmarrkmey bu Sarai bimarneyimeng. ");
INSERT INTO gup_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wanjh kunu bu Abram ni kore kubolkwarlah Canaan bu mandjewk ten, Sarai ngalu ngalbininjkobeng nuye bikang ngalbu bimarnedurrkmirri ngalbu Egyptbeh, dja biwong Abram kabeneyo. ");
INSERT INTO gup_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Wanjh beneyonginj dja kaluk Hagar yawkani. Dja bu Hagar narrinj wurdyaw kahkan wanjh kunu biwidnani Sarai ngalbu bimarnewohrnani. ");
INSERT INTO gup_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Wanjh Sarai bimarneyimeng Abram, yimeng, “Ngudda welengname bu ngaleng nganwidnan, ngaye wong ngardduk ngalbu nganmarnedurrkmirri nguneyonginj, dja bolkkime bu ngaleng narrinj wurdyaw kahkan, wanjh ngaye nganwidnan. Ngadjare Yawey kandjadme ngarrku, kayime nangale warrewong, ngaye dja kunubewu ngudda.” ");
INSERT INTO gup_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Wanjh Abram bimarneyimeng Sarai, yimeng, “Yina, ngaleng wanjh nguddah ke bu ngunmarnedurrkmirri, yimarnekurduyimen nawu ngudda yidjare.” Wanjh Sarai binjilngwarrewoni bulkkidj, wanjh kunu Hagar kelerlobmeng bibawong. ");
INSERT INTO gup_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Kaluk nawu angel nuye Yawey bingalkeng Hagar kore kukku manbu njilhmi kore kubolkdarlehni, kaluk manmekbe manbu njilhmi, kaluk darnkih kore manbolh manbu kahre kore kabolkngeyyo Shur. ");
INSERT INTO gup_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Wanjh angel yimeng, “Hagar, ngudda ngalbu yimarnedurrkmirri Sarai, balehbeh yimwam, dja baleh yire?” Ngaleng yimeng, “Ngaye ngakelerlobmeng ngabawong Sarai ngalbu nganmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Wanjh angel nuye Yawey bimarneyimeng, “Yirrurnde kore ngaleng ngalbu ngunmarnewohrnan dja yiwokmarrkma kore ngaleng ngunmarneyime.” ");
INSERT INTO gup_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mak angel yimeng, “Ngaye wanjh Yawey. Ngaye ngamirndewernwon nawu ngudda ke nawu yibenkebmakkahme, dja kabirrimirndewernmerren, minj nangale kabenmirnderohrokme.” ");
INSERT INTO gup_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mak kuhni warridj angel nawu Yawey nuye bimarneyimeng, “Yina, ngudda wanjh bolkkime yihkan wurdyaw, kaluk yiyawmang narangem, yingeykurrmen Ishmael, dja Yawey bekkang ngudda ke kunnjilngwarre.” ");
INSERT INTO gup_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","“Kaluk nungka kayimerran bininj nawu yiman donkey nawu kele, nungka yiman kabenwidnan birribuyika, dja birribuyika kabirriwidnan, dja nungka kayidngalhngalke bedberre rowk nawu birridanginj.” ");
INSERT INTO gup_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Wanjh Hagar bingeykurrmeng Yawey bimarnewokdanj, bingeykurrmeng, “Ngudda wanjh God nawu ngarrinan.” Dja ngaleng yimeng, “Ngaye wanjh nganang namekbe nawu ngannan dja minj kanbuyinj.” ");
INSERT INTO gup_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Wanjh kunmekbekenh kunu ngaleng bongeykurrmeng kunngad manbu boyoy, bongeykurrmeng. “Kungad nuye nawu kadjalmimbi munguyh dja nganhnan ngaye.” Kadjalboyo munguyh kumekbe kubulkayh kore Kadesh dja Bered. ");
INSERT INTO gup_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Wanjh Hagar bimarneyawmey Abram beywurd nuye, dja Abram bingeykurrmeng Ishmael. ");
INSERT INTO gup_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram wanjh mandjewk nuyeni 86 bu Hagar bimarneyawmey Ishmael. ");
INSERT INTO gup_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kaluk bu Abram mandjewk nuyeni yimerranj 99, wanjh Yawey bimarnebukkarrinj dja yimeng, “Ngaye wanjh El-Shaddai. Ngudda kanwokma, dja munguyh yidjalkurduyimen mandjad bu kundjalmak. ");
INSERT INTO gup_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ngaye ngawokrayekworren kore ngawokkurrmerren dja berrebbun ngudda, dja ngaye ngabenmirndewernwon bulkkidj nawu ngudda yibenkebmawahme.” ");
INSERT INTO gup_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Wanjh Abram mankang kunkeb bolkdoy kurorre, dja God bimarneyimeng, ");
INSERT INTO gup_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Dja ngayembu, kuhni wanjh ngardduk bu ngawokkurrmerren berrebbun ngudda, wanjh ngudda kaluk yiyimerran Mawah bedberre birribebbehmirndewern nawu birriredbobubuyika. ");
INSERT INTO gup_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Bonj yingeyyoy Abram, dja yidjalngeyyo Abraham, dja ngaye marnbun ngudda bu yiyimerran Mawah bedberre birribebbehmirndewern nawu birriredbo. ");
INSERT INTO gup_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ngaye marnbun bu birriwern duninjh yibenkebmawahme, kaluk ngaye marnbun yiyimerran birribebbehmirndebubuyika birriredbo, dja kings kabirrimbebmerren kore nguddahbeh nawu yibenkebmawahme. ");
INSERT INTO gup_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Dja mak ngaye ngarayekwon kunwok ngardduk ngawokkurrmerren ba minj kawokyakmen kore ngaye berrebbun ngudda dja nawu yibenkebmawahme rowk bu djalmunguyh munguyh. Ngaye wanjh ngadjalyime God ke dja mak bedman bedberre God, nawu kaluk yibenkebmawahme. ");
INSERT INTO gup_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kondah kubolkwarlah Canaan kore bolkkime ngudda wakewaken yidjalwodjalwohre, wanjh ngaye kaluk bolkwon kondanjkunu kubolkwarlah rowk, ngudda dja nawu yibenkebmawahme, ngudda ngurridjalbolkkarrme bu munguyh, dja ngaye ngadjalyime God bedberre bedda dorrengh nawu yibenkebmawahme.” ");
INSERT INTO gup_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Wanjh God bimarneyimeng Abraham, “Ngudda wanjh kanwokkarrmen kunwok ngardduk bu ngawokkurrmerrinj berrebbom ngudda, dja nawu yibenkebmawahme bedmanwali ngandiwokkarrme djalmunguyh.” ");
INSERT INTO gup_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dja mak God bimarneyimeng Abraham, “Kuhni wanjh ngardduk kunwok bu ngawokkurrmerrinj bu berrebbom ngudda dja nawu yibenkebmawahme, nawu kunwok ngudda kandiwokkarrme. Kaluk narahrangem rowk nawu ngurridjarrkni nanu wanjh ngurridjallakkayenworrimen. ");
INSERT INTO gup_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ngurriwern ngurrilakkayenworrimen rowk, kuhni wanjh ngurrimulewarren bu ngaye ngawokkurrmerrinj ngudda berrebbom. ");
INSERT INTO gup_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Djalmunguyh nawu rerrererre kabirridangerren narahrangem rowk nawu ngurrini kaluk ngurrbenlakkayenwo rowk, bu kabirriyawdangen kaluk kunkodjke eight bedberre, ngurrbenlakkayenwo rowk, kaluk bedda dorrengh nawu ngundimarnedurrkmirri ngudberre nawu minj ngudberre Mawah, kaluk nawu bedman kabirridangen kore kured ngudberre ngurrini, dja mak bedman nawu ngurrbenkarremulewan ngurrbenwon kunwardde birriwokbubuyika.” ");
INSERT INTO gup_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","“Bedda wanjh ngurrbenlakkayenwo rowk nawu ngundimarnedurrkmirri, nawu kabirridangen kore ngurrini dja mak nawu ngurrbenkarremulewan. Kuhni bu ngurrikurduyime wanjh kunwok ngardduk bu ngawokkurrmerrinj bu berrebbom wanjh yiman kawokbimbuyindangen kuburrk ngudberre djalmunguyh. ");
INSERT INTO gup_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kaluk narangem nawu minj ngurrilakkayenwon wanjh nungka kayimerran yiman minj ngurrimud, dja nungka wanjh bakkeng kunwok ngardduk bu ngawokkurrmerrinj berrebbom.” ");
INSERT INTO gup_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dja mak God bimarneyimeng Abraham, yimeng, “Ngalbu ngalbininjkobeng ke Sarai, bonj yingeybun Sarai, dja kaluk kadjalngeyyo Sarah. ");
INSERT INTO gup_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ngaye kaluk ngamarnekurduyime kunmak dja woybukkih ngaye won beywurd ke, bu ngaleng ngunmarneyawmang. Ngaye ngamarnekurduyime kunmak ba kayimerran Makkah bedberre bininj nawu birribebbehmirndewern birriredbobuyika, dja ngaleng nawu kabenkebmakkahme wanjh kumekbebeh kabirrimbebmerren kings nawu kabindimarnewohrnan bininj nawu birribebbehmirndewern.” ");
INSERT INTO gup_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Wanjh Abraham mankang kunkeb bolkdoy kurorre djekmeng dja nungan baybaywi yimeng, “Yiddok bininj kayawbornan beywurd bu mandjewk nuye one hundred? Dja yiddok Sarah kayawmang wurdyaw bu mandjewk ngalengngarre ninety?” ");
INSERT INTO gup_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dja Abraham bimarneyimeng God, yimeng, “Bonj, yiddok minj yidjalbawon Ishmael ngardduk beywurd? Kamak bu nungka dorrengh yimarnekurduyime kunmak.” ");
INSERT INTO gup_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dja God yimeng, “Burrkyak, dja Sarah ngalbininjkobeng ke ngaleng woybukkih ngunmarneyawmang beywurd, kaluk ngudda yingeykurrmen Isaac. Wanjh ngamarnerayekworren nuye kunwok ngardduk dja minj kayakmen, kaluk ngawokkurrmerren ngaberrebbun nungka dja nawu kabenkebmawahme djalmunguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Dja wanjh Ishmael nawu, ngaye bekkang bu ngudda kandjawam Ishmaelkah. Yina, woybukkih ngaye kaluk ngamarnekurduyime kunmak, dja ngamarnbun birriwern kabenbornan, dja ngamirndewernwon duninjh nawu kabenkebmawahme. Nungka kaluk Mawah bedberre twelve nawu kabindimarnewohrnan birrimirndebubuyika bininj nawu twelve birriredbo, dja ngaye ngabenmarnbun nungka nuye nawu kabenkebmawahme kabirriyimerran birriredbo nawu birrikuken. ");
INSERT INTO gup_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Dja ngaleng manbu kunwok ngardduk ngarayekwon, kaluk ngawokkurrmerren ngaberrebbun Isaac nawu Sarah kaluk ngunmarneyawmang, bu ngaye ngarrungname bu dird twelve kayakmen.” ");
INSERT INTO gup_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kuhni rowk God yakwong kore Abraham benewokdi, wanjh bibawong bidbom. ");
INSERT INTO gup_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Wanjh kundjalmekbe kunbarnangarra Abraham bikang Ishmael nawu beywurd nuye, dja mak benkang rowk bininj nawu birrimarnedurrkmirri, bedman nawu birridanginj kore kured nuye, dja mak bedman nawu karremulewam bedberre, kunwardde benwong birribuyika, kaluk narahrangem rowk nawu birrini kured nuye, wanjh benlakkayenwong rowk. Kuhni kurduyimeng bu God bimarneyimeng. ");
INSERT INTO gup_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham nungka wanjh mandjewk nuyeni bu birrilakkayenworrinj wanjh 99, ");
INSERT INTO gup_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","dja mak bilakkayenwong beywurd nuye nawu Ishmael, dja nungka wanjh thirteen bu mandjewk nuye. ");
INSERT INTO gup_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Kundjalmekbe kunbarnangarra Abraham dja Ishmael nawu nuye beywurd benedjarrklakkayenminj, ");
INSERT INTO gup_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","dja mak bininj rowk nawu birrini kured nuye, bedda dorrengh nawu birrimarnedurrkmirri, bedman nawu birridanginj kured nuye dja bedman nawu birriwokbuyika benmarnekarremulewam, bedda rowk birridjarrklakkayenminj Abraham dorrengh. ");
INSERT INTO gup_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kaluk Yawey biyawoyhmarnebukkarrinj Abraham bu nungka reddi kore mandulkkuken dulkdingihdi nuyeni Mamre. Kaluk barnangarraburrk bu wernhdungbahbangni, bu Abraham ni kore kururrkdangmaye ngarre dabburlin nuye. ");
INSERT INTO gup_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Wanjh nungka balwohnang bennang bininj danjbik kabirrihdi darnkih nuye. Bu nungka bennang wanjh nungka rlobmeng kumekbe kururrkdangmayebeh, bendabkeng dja boddanj kanjdji kurorre. ");
INSERT INTO gup_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Dja yimeng, “Ngudda nawu ngurriwohrnan, bu ngudda ngurriyime yimankek ngamak, yuwn kandibangmebawon ngaye nawu ngamarladj, dja med karridjalwohnin. ");
INSERT INTO gup_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","5","Bu ngudda kandidjalwohmarnebebmeng ngaye nawu ngahdurrkmirri ngudberre, dja bu ngurrihwirle ngurrihre wanjh kab ngabomang kukku kunboyahwurd ngurridengedjirridjburren dja ngurridjalwohngehmen kore kudjurle, dja ngare ngamang manme manyahwurd, ngamkan ngudberre ngurringun, ba ngurringudjmakmen wanjh kunu ngurrire.” Bedda birriyimeng, “Mah, kunmekbe yikurduyimen.” ");
INSERT INTO gup_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Wanjh Abraham dokorrokmeng durndi kore Sarah kore dabburlin, dja bimarneyimeng, “Werrkwerrk yirrudma manwern kandidjdjawa manduyh, yikarrmen yikinjemen manlodkilehkilelk.” ");
INSERT INTO gup_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Dja nungka rlobmeng kore bulikki mirndemirnderri, mey nakudji kukmak bulikki yaw nawu kanjkelk, dja biwong bininj nawu bimarnedurrkmirri, dja nungka kinjeng werrkwerrk. ");
INSERT INTO gup_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Wanjh Abraham kang manbu yiman cheese, dja mak kundjikka dja bulikki yaw nawu ngokko kumyingkihmarnbuyindanj, dja benmarnekurrmeng, dja nungka Abraham kumekbe kudjurle djahdjaldarnhdi bedberre bendangmadbuni birrihnguni. ");
INSERT INTO gup_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Wanjh bedda birridjawam, “Baleh Sarah ngalbu ngalbininjkobeng ke?” Abraham yimeng, “Kururrk kahdi kore dabburlin.” ");
INSERT INTO gup_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wanjh Yawey yimeng, “Ngaye woybukkih ngamdurndeng bu mandjewkbuyika, dja bu kumekbe kabolkyime, wanjh ngalbininjkobeng ke Sarah kayawmang narangem.” Sarah wanjh ngaleng bihbekkani bu dingihdi kore dabburlin kururrkdangmaye, kaluk kubodme nuye. ");
INSERT INTO gup_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Kaluk Abraham dja Sarah bedda wanjh benewernhkohbanjni, dja yakminj ngarreni Sarah bu yimankek wurdyaw yawmayi. ");
INSERT INTO gup_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Wanjh kunu ngalengman Sarah djekmeng baybaywi dja yimeng, “Bu ngaye ngakohbanjminj dja mak nabininjkobeng ngardduk nakohbanj warridj, yiddok kuhni nganmarnekurduyimerran bu ngannjilngmarnbun?” ");
INSERT INTO gup_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Wanjh Yawey bimarneyimeng Abraham, “Njalekah Sarah djekmeng dja ngalengman marneyimerrinj bu yimeng, ‘Yiddok woybukkih ngayawmang bu ngaye ngakohbanjminj?’” Wanjh nungka Yawey yimeng, ");
INSERT INTO gup_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","“Njale yimankek karayek kore ngaye nawu Yawey? Ngaye ngamdurndeng mandjewkbuyika bu ngarrungnameng, dja Sarah kaluk kayawmang narangem.” ");
INSERT INTO gup_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Wanjh Sarah keleni wanjh kunu yakwarrinj dja yimeng, “Ngaye minj ngadjekmeninj.” Dja nungka yimeng, “Ngudda yiyimeng dja yidjekmeng.” ");
INSERT INTO gup_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Wanjh birrimekbe nawu bininj birridolkkang birribalhrey birribalhbolknani kanjdji kore Sodom, dja Abraham birribaldjarrkwam nungka kabendjalwohmunkewe wohkah. ");
INSERT INTO gup_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Wanjh Yawey marneyimerrinj, “Minj nuk ngaye ngamarnewarlkkan Abraham bu baleh ngaye ngokko darnkih ngakurduyime, ");
INSERT INTO gup_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","dja nungka Abraham nawu kabenkebmawahme kabirriyimerran birriredbo nawu birrikuken dja birringudjkimuk, dja kore nungka Abraham kaluk ngabenmarnekurduyime kunmak birribebbehmirndebubuyika nawu birriredbo rowk kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Dja ngaye korroko ngadjalyingkihdjarrngbom ba bu nungka kabenwokrayekrayekwon wurdwurd nuye dja bininj nawu kabirridjarrkni, ba bedda kabirrikurduyime kunmak ngandiwokmarrkmang nawu ngaye Yawey ngadjare, ba bu kunu ngaye nawu Yawey ngamarnekurduyime nawu ngaye ngaberrebbom nuye.” ");
INSERT INTO gup_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Wanjh Yawey bimarneyimeng Abraham, yimeng, “Wokwarlahminj duninjh nawu ngawobekkang bedberre nawu kabirrini kore Sodom dja Gomorrah, djaying kunwarre bedberre wernminj duninjh, ");
INSERT INTO gup_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","wanjh ngakolung nganan bu kunmekbe kunwarre duninjh kabirrihkurduyime nawu ngawobekkang, dja bu burrkyak, wanjh kunu ngaburrbun.” ");
INSERT INTO gup_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Wanjh nawu bininj bokenh beneborledmeng bindibawong benedjalley benebalbolkyikani Sodom, dja Abraham djahdjaldi kore kumirrk nuye Yawey. ");
INSERT INTO gup_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Wanjh Abraham bimarnewam darnkih dja yimeng, “Bu ngudda yibenbun birriwarre bininj yiddok woybukkih duninjh yibendjaldjarrkbun dorrengh nawu birrimak? ");
INSERT INTO gup_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bu yimankek fifty bininj nawu birrimak kabirrini kore kumekbe kubolkkimuk, yiddok ngudda yibenbun rowk nawu kumekbe kabirrini, minj nuk kunu yibendarrkidbawon rowk bedberrekenh nawu fifty birrimak? ");
INSERT INTO gup_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ngudda minj nuk yiman kuhni yikurduyime, bu birriwarre yibenbun, minj ngudda yibendjarrkbun dorrengh nawu birrimak. Kunkudjiwi minj yibenbebbehmarneyime nawu birrimak dja birriwarre, kunukka minj ngudda yikurduyime. Ngudda nawu kandjadme ngadberre bininj kubolkbubuyika rowk, wanjh woybukkih yidjalkurduyime kunmak.” ");
INSERT INTO gup_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Wanjh Yawey yimeng, “Bu ngaye ngabenngalke fifty bininj nawu birrimak kore kubolkkimuk Sodom, wanjh bedda bedberrekenh ngabenbawon kabirridjaldarrkid bininj birriwern rowk nawu kumekbe kabirrini.” ");
INSERT INTO gup_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Wanjh Abraham yawoyhwokdanj yimeng, “Yina, bu ngaye bolkkime minj ngarrangyemeninj bu ngawokdanj ke nawu Yiwohrnan Rowk, dja ngaye nawu yiman rerrih kundjulng mak kunyirrke, ");
INSERT INTO gup_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","wanjh yimankek bu djal forty five birrimak bininj kabirrini dja minj yiman fifty? Yiddok ngudda yibenbun rowk bininj nawu kumekbe kubolkkimuk kabirrihni bu five yak nawu birrimak?” Nungka Yawey yimeng, “Bu ngaye kumekbe ngabenngalke forty five birrimak, wanjh minj ngabenbun bininj nawu kumekbe kabirrini.” ");
INSERT INTO gup_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Wanjh kunyawoyhkudji Abraham wokdanj yimeng, “Bu yimankek djal forty birrimak yibenngalke?” Wanjh Yawey yimeng, “Bu bedda bedberre nawu forty, minj ngabenbun bininj.” ");
INSERT INTO gup_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Wanjh Abraham yimeng, “Yuwn nuk kandung ngudda nawu Yiwohrnan rowk, dja kanbawo ngawokdi. Dja bu djal thirty yibenngalke kumekbe?” Wanjh Yawey biwokmey, yimeng, “Minj ngabenbun bininj bu kumekbe ngabenngalke thirty nawu birrimak.” ");
INSERT INTO gup_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham yimeng, “Yina, bu bolkkime minj ngarrangyemeninj ngawokdanj ke nawu Yiwohrnan Rowk, dja bu yimankek djal twentywi yibenngalke kumekbe?” Wanjh Yawey yimeng, “Bedda twenty bedberre minj ngabenbun bininj.” ");
INSERT INTO gup_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Wanjh Abraham yimeng, “Yuwn nuk kandung, ngudda nawu Yiwohrnan rowk, dja kanbawo ngayawoyhwokdi kunkudji, dja bu djal tenwi birrimak kumekbe yibenngalke?” Wanjh nungka Yawey biwokmey, yimeng, “Bedda bedberre nawu ten birrimak, minj ngaye ngabenbun bininj nawu kabirrihni kumekbe kubolkkimuk.” ");
INSERT INTO gup_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Bu Yawey burnbom bu benewokdi Abraham, wanjh nungka bibawong, dja Abraham durndi kured. ");
INSERT INTO gup_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Benemekbe bininj bokenh nawu angels wanjh benebolkmey Sodom bu balhdungyibmi, dja Lot nungka ningihni kore kururrkdangmaye ngarre kubolkkimuk Sodom, dja bu nungka benbenenang nawu bininj bokenh nungka dolkkang benbenedabkeng dja boddanj kanjdji rorrehrorrenani. ");
INSERT INTO gup_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Dja benbenemarneyimeng, “Ngudda nawu ngunewohrnan, ngadjare ngunemre nguneyo kore kunrurrk ngardduk ngaye nawu ngamarladj. Kumekbe ngunedengedjirridjburren dja nguneyo, dja mak ngunedolkkan ngunerewi bu kukabel.” Dja bedda beneyimeng, “Burrkyak, ngad nganeyo kondah kuberrk kore berrebboyen bininj kabirrimirndemornnamerren bu kabirriwokdikenh.” ");
INSERT INTO gup_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Dja nawu Lot kebbabiminj, benbenewernhdjawani wanjh kaluk benewokmarrkmey birridjarrkngimeng kore nuye kunrurrk. Wanjh nungka benbenemarnemarnbom manmak manme, dja kinjeng mandulmuk kandidjdjawa manbu minj karrmeninj manbu nguklurlmeninjkenh, wanjh benenguneng. ");
INSERT INTO gup_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bu minj birribangmekodjkeyuwirrinj wanjh bininj rowk nawu birrini kumekbe kubolkkimuk Sodom, nawu birriyawurrinjni dja mak birridabborrabbolkni, birridjalwern rowk wanjh birrirurrkdabkeng Lot nuye kunrurrk. ");
INSERT INTO gup_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Dja birrimarnekayhmeng Lot, birriyimeng, “Baleh bininj nawu benemwam kore ngudda bolkkime? Yibenbenemdjalwohbebkemen ba ngad ngarrbenbenekukburrbun.” Kunmekbe birriyimeng, dja birridjareni yimankek birrikaliyuwirrinj bu djal bedman bininj deleng. ");
INSERT INTO gup_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot bebmeng kuberrk kore bininj birrihdi dja yerre kumdangbalhmeng, ");
INSERT INTO gup_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","dja yimeng, “Ngaye djawahdjawan ngudberre nawu karridabbolk, yuwn kunmekbe ngurrikurduyime kundjalwarre. ");
INSERT INTO gup_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kandibekka marneyime ngudberre, ngaye ngabenbenekarrme ngalbebeywurd bokenh nawu minj bininj birribangmeyuwirrinj, kab bedda ngabenbenembebke ngurrbenbenemarneyime bu baleh ngudman ngurridjare, dja yuwn njale ngurrbenbenemarneyime nanih nawu bininj bokenh, dja bedda benemwam kore kunrurrk ngardduk ngabenbenenahnan.” ");
INSERT INTO gup_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Dja bedda birriyimeng, “Yibalderrehmen nguddanu!” Dja mak birrimarneyimerrinj bu birribekkang nawu Lot, “Nanih nawu bininj nawu kumdjalwohwam nawu nakang baleh, dja nungka yimankek kandjadme kadberre.” Dja birrimarneyimeng, “Ngad kunwernhwarre ngundimarneyime ngudda, dja bedda nawu bininj bokenh yiman walakkih ngarrbenbenemarneyime.” Wanjh munguyh birriwernhkukdjirrkkani Lot dja birridjareni birridangbakkemeninj manu rurrkdangmayebalhmeng. ");
INSERT INTO gup_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Dja bedda nawu bininj bokenh nawu benehni kururrk benebidbebmeng benemberldurrkmeng Lot, benengimowong kururrk benedangbalhmeng. ");
INSERT INTO gup_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Wanjh bindimimbuyikawong bininj nawu kumekbe birrihdi kuberrkkah kore kururrkdangmaye darnkih, bedda yiman birrimimdubberranj, nawu birriyawurrinjni dja birridabborrabbolkni, birridjalbolkbirrkahbirrkani, minj birrirurrkdangmayengalkemeninj. ");
INSERT INTO gup_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wanjh nawu bininj bokenh benemarneyimeng Lot, beneyimeng, “Yiddok birribuyika yibenkarrme kondah kore kubolkkimuk, bibinjdoy, bebeywurd, ngalbebeywurd, dja mak nuk nangale nawu ngudda ke? Wanjh yibenbebkemen yibenkan kondah kubolkkimukbeh, ");
INSERT INTO gup_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","dja ngad ngokko darnkih ngarrbenbularrbun rowk nawu kondanjkunu kabirrihni kunred. Yawey wanjh bekkang nawu wokwarlahminj duninjh bu kunwarre bedberre nawu kabirrihni kondah kubolkkimuk, wanjh nungka Yawey kanbenemunkeweng nganerurrkbularrbun rowk.” ");
INSERT INTO gup_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Wanjh Lot wam kore bininj bokenh nawu birrimarrimeninj ngalbebeywurd nuye, yimeng, “Werrkwerrk ngunedolkka ngunebolkbawon kondah, dja Yawey ngokko darnkih kabenbun nawu kondah kubolkkimuk kabirrini.” Dja bedda nawu bibinjdoy nuye beneyimeng bu yimankek kabenbenehmalelmang. ");
INSERT INTO gup_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Wanjh bu darnkih kumbarrhbuni, nawu angels bokenh benedjurrkdjurrkwong Lot, benemarneyimeng, “Werrkwerrk, yika ngalbininjkobeng dja mak ngalbebeywurd bokenh nawu kondah ngurrini, yibenka, dja marndi ngurridowen bu God kabendung nawu kondah kabirrihni kubolkkimuk.” ");
INSERT INTO gup_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Dja Lot bu wohbolkmaddi, bedda nawu angel bokenh bindibidkarrmeng nungka, ngalbininjkobeng nuye dja mak ngalbebeywurd bokenh nuye, dja bindimyikang kumekbe kubolkkimukbeh kamak rowk, kunmekbe beneyimeng bu Yawey bikongibom Lot. ");
INSERT INTO gup_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Dja kundjalmekbe rerrih bu bindibebkeng nakudji yimeng, “Ngurrikelerlobmerrimen, yuwn ngurribolknan yerre, dja yuwn baleh ngurridangen kore kondah kanjdjikanjdji kabbal. Ngurridjalkelerlobmenwi kore kuwarddewardde, dja bu burrkyak marndi ngurridowen.” ");
INSERT INTO gup_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Dja Lot yimeng, “Kunukka kunwid, ngudda nawu ngunewohrnan, ");
INSERT INTO gup_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","kandibekka ngaye nawu ngamarladj, ngudda nguneyimeng bu yimankek ngamak, dja kandimarnekurduyimeng kunwernhmak duninjh, kandikongibom bu kandibawong ngarrarrkid, dja minj ngakelerlobme kore kuwardde, marndi kunihbu kunyid nganwohmarnebebme dja ngarrowen! ");
INSERT INTO gup_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ngunena, kunihbu kubolkkimuk minj djarreh duninjh bu ngakelerlobme, dja minj kunwernhbolkkimuk. Kandimunkewemen kumekbe ngakelerlobme, dja yiddok minj kubolkyahwurd, dja kunu minj ngarrowen ngadjaldarrkid.” ");
INSERT INTO gup_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Wanjh nakudji yimeng, “Kanbekka, ngaye won kuhni mak bu kandjawam, minj ngabenbun nawu kumekbe kunred kabirrini kore ngudda yibolkyolyolmeng. ");
INSERT INTO gup_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Dja werrkwerrk yikelerlobmen, yire kumekbe, dja ngaye minj baleh ngabangmekkurduyime, djalmadbun yibolkmang.” Kunmekbe wanjh kabolkngeyyo Zoar. (Zoar kunekke kunngey kayime Kunyahwurd.) ");
INSERT INTO gup_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Bu Lot bolkmey Zoar wanjh dungbebmeng. ");
INSERT INTO gup_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Wanjh Yawey munkeweng manbang manbu rungirungi kore heavenbeh bu djakdungi yiman mandjewk kore bininj nawui birrihni kore Sodom dja Gomorrah. ");
INSERT INTO gup_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kuhni wanjh yimeng bu bolkyakwong rowk kubolkkihkimuk kumekbe kanjdjikanjdji kore kabbal, dja benyakwong rowk nawu birrihni kumekbe kubolkkihkimuk, dja mak kolhderuy rowk kumekbe. ");
INSERT INTO gup_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Dja Lot nuye ngalbininjkobeng bu bimunkebuni Lot, borledmeng bolknang rerre, wanjh kunu kukyimerranj yiman djirla. ");
INSERT INTO gup_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wanjh bu kukabel Abraham dolkkang durndi kore kukak benehdi benehwokdi Yawey, ");
INSERT INTO gup_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","dja nungka bolknang kanjdji kore Sodom dja Gomorrah mak kubolkbubuyika rowk kumekbe kanjdjikanjdji, dja nungka nang kundolng manbu dolngdolkkani kumekbe kubolkwarlahbeh, wanjh mandolngkimuk duninjh, yiman yerreh manbirludjawurl duninjh kore kahrung. ");
INSERT INTO gup_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kunmekbe wanjh bu God bolkyakwong kubolkkihkimuk ngarre kanjdjikanjdji, God biburrbom Abraham dja bimunkeweng Lot bibebkeng kumekbebeh, ba minj dowimeninj, bu nungka God benyakwong rowk nawu birrihni kubolkkihkimuk kore Lot. ");
INSERT INTO gup_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot dja ngalbebeywurd bokenh nuye kaluk birribolkbawong Zoar, dja birrini kore kuwarddewardde, dja nungka keleni, minj niwirrinj kore Zoar. Nungka dja ngalbebeywurd nuye birrini kore kuwardderurrk. ");
INSERT INTO gup_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Wanjh kaluk bu ngalbu ngalwernwarre bimarneyimeng ngalwalawalak, yimeng, “Kornkumo ngarrku kohbanjminj, dja minj bininj kondah kani ba bu karriyo, yiman kabirriyime kubolkbubuyika rowk. ");
INSERT INTO gup_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kab ngarrbowo kunbang wine nawu kornkumo ngarrku, dja wanjh kaneyo, ba kunu minj kayakmen ngad bu karrimud, bu nungka Ngabbard kayawbornan ngarrku.” ");
INSERT INTO gup_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Wanjh bu kunmekbe kumunun benebowong kornkumo manbang wine, dja ngalwernwarre ngimeng beneyonginj kornkumo, dja nungka wakwani bu ngaleng kurrmerrinj dja mak bu dolkkang. ");
INSERT INTO gup_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Dja bu malaywi wanjh ngalu ngalwernwarre bimarneyimeng ngalwalawalak, “Yina, ngaye kukak nganeyonginj Ngabbard, kab bolkkime mak ngarryawoyhbowo manbang wine, wanjh ngudda yingimen nguneyo ba kunu minj kayakmen nawu karrimud bu Ngabbard kayawbornan ngarrku.” ");
INSERT INTO gup_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Wanjh kunu beneyawoyhbowong kunbang bu kunmekbe kumunun warridj, dja ngalbu ngalwalawalak dolkkang wam beneyonginj, dja nungka wakwani bu ngaleng kurrmerrinj dja mak bu dolkkang. ");
INSERT INTO gup_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kuhni wanjh kunu benemekbe bokenh nawu ngalbebeywurd nuyeni Lot beneyawkani wurdyaw nawu nungka benbenebornang. ");
INSERT INTO gup_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ngalwernwarre yawmey narangem, bingeykurrmeng Moab, nungka wanjh mawah bedberre namud nawu kabirringeyyo Moab. (Kaluk Moab kamenhyime “kore ngabbardbeh”) ");
INSERT INTO gup_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Dja ngalwalawalak ngaleng warridj yawmey narangem, bingeykurrmeng Ben-Ammi, nungka wanjh mawah bedberre nawu kabirringeyyo Ammon. (Ben-Ammi kamenyime “Beywurd Bedberre Namud Ngardduk”) ");
INSERT INTO gup_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Wanjh Abraham dolkkang balhrey balhbolkyikani Negeb. Kaluk yerrkang kubulkayh kore kunred bokenh Kadesh dja Shur dja mak wam djahdjalwohni waken kore Gerar. ");
INSERT INTO gup_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Wanjh bu kumekbe ni Abraham yimeng bu Sarah ngalbu ngalbininjkobeng nuye wanjh yimeng bu benedanginj, wanjh kunu Abimelech nawu king nawu wohrnani kumekbe kore Gerar bikimey Sarah. ");
INSERT INTO gup_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Dja God bimarnebebmeng Abimelech bukirri bu kumunun, dja bimarneyimeng, “Kanbekka, marneyime, bu ngudda yimey ngalinjngalu daluk wanjh kunu yidjaldowen, dja ngaleng wanjh kabeneni nabininjkobeng ngarre.” ");
INSERT INTO gup_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech minj Sarah bibangmemarnebebmeninj darnkih wanjh kunu nungka yimeng, “Ngudda nawu yiwohrnan, yiddok ngudda kanbun ngaye ngardduk nawu ngarriredbo nawu minj kunwarre ngarriyimeninj? ");
INSERT INTO gup_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Dja Abraham nganmarneyimeng bu ngaleng ngaldaluk nuye, dja mak ngalengman yimeng bu nungka benedanginj. Wanjh ngaye bu kuhni ngayimeng ngamey, wanjh woybukkih ngayimeng yimankek kamak, dja minj kunwarre ngayimeninj.” ");
INSERT INTO gup_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Wanjh God biwokmey bukirri, “Ngaye ngaburrbun bu woybukkih yiyimeng yimankek kamak, dja ngaye wanjh karrmeng ba minj kunwarre kanmarneyimeninj, kunmekbekenh kunu ngaye denghkeng ba minj yikarrmeninj. ");
INSERT INTO gup_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Wanjh bonj, yirrurndiwemen ngalbu nuye ngalbininjkobeng, nungka wanjh prophet kanmarnemulewan kunwok ngardduk, dja nungka kaluk ngunmarnedi yiwarrudj ba minj yirrowen. Dja bu minj yirrurndiwe, kunu wanjh woybukkih ngayime ke, ngudda dja nawu yibenkarrme rowk, kaluk ngurridjaldowen.” ");
INSERT INTO gup_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Bu malaywi Abimelech dolkkang kukabel, wanjh nungka benkayhmeng rowk nawu birrimarnedurrkmirri, wanjh kuhni rowk benmarneyolyolmeng dja bedda wanjh birrikeleminj duninjh. ");
INSERT INTO gup_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelech bikayhmeng Abraham dja bimarneyimeng, “Njale ngudda kanmarnekurduyimeng ngadberre? Njale yiddok ngaye kunwarre ngayimeng ke, bu ngudda kanmarnbom ngaye dja nawu ngabenmarnewohrnan ngundimarneyime kunihbu kunwarre duninjh? Dja kuhni bu kanmarnekurduyimeng, wanjh yiman bininj kabirriyime yimankek minj nangale kakurduyime.” ");
INSERT INTO gup_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Dja mak Abimelech yimeng, “Njale ngudda yiburrbuni bu kuhni kanmarnekurduyimeng?” ");
INSERT INTO gup_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham biwokmey yimeng, “Ngaye ngamarneyimerrinj, ‘Woybukkih nuk minj nangale kondah kabimarnekele God, wanjh ngandibun ngalbininjkobengkah ngardduk.’ ");
INSERT INTO gup_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Dja mak woybukkih ngaleng yiman nganedanginj duninjh, dja kornkumo nakudji ngarrewoneng dja ngaleng ngalbadjanbuyika ngarre, dja wanjh yimerranj ngalbininjkobeng ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Bu God nganmarneyimeng ngabolkbawon kore Ngabbard ngarrihni, ngawohrey, wanjh ngaye ngamarneyimeng ngalbininjkobeng ngardduk, ngayimeng, ‘Kuhni bu kunmak kandjalmarneyimen, bu baleh yarrkka ngarre, wanjh yiyime bu ngaye ngarrdanginj.’” ");
INSERT INTO gup_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Wanjh Abimelech biwong Abraham sheep dja bulikki, dja bininj daluk nawu birrimarnedurrkmirri, dja mak bimarnedurndiweng Sarah ngalbininjkobeng nuye. ");
INSERT INTO gup_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelech yimeng, “Yina, kubolkwarlah ngardduk yibolknan dja bu baleh yidjare, kunukka wanjh yini.” ");
INSERT INTO gup_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Dja mak Abimelech bimarneyimeng Sarah, yimeng, “Ngaye ngawong nawu ngudda ngunedanginj kunwardde nakimuk, ba nawu ngurridjarrkre kabirribularrbun yiman kabirribengmidjdan, dja kabirriyime bonj ngudda minj kunwarre yiyimeninj.” ");
INSERT INTO gup_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Yawey ngokko benmarnbom daluk rowk nawu birrini kore Abimelech nuye kunred minj birriyawmayi, kuhni yimeng bu Sarahkenh ngalbu Abraham nuyeni ngalbininjkobeng. Wanjh Abraham yiwarrudj di bidjawam God, dja nungka God bimarnbom Abimelech, dja ngalbininjkobeng nuye dja daluk nawu birrimarnedurrkmirri, benmarnbom warridj ba wurdyaw kabirriyawoyhyawmang. ");
INSERT INTO gup_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Kaluk Yawey bimarnekurduyimeng Sarah kunmak bu nungka yingkihdjedjenkurrmeng, dja nungka Yawey bimarnekurduyimeng bu nungka biberrebbom. ");
INSERT INTO gup_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah ngaleng wanjh kanihkani wurdyaw dja bimarneyawmey Abraham beywurd bu nungka wernhkohbanjminj, namekbe wurdyaw danginj bu God biyingkihmarnedungnameng. ");
INSERT INTO gup_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham bingeykurrmeng Isaac beywurd nuye nawu Sarah bimarneyawmey. ");
INSERT INTO gup_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Bu beywurd nuye nawu Isaac bu danginj, kaluk kunkodjke eight nuye wanjh Abraham bilakkayenwong kore God biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Dja Abraham nungka wanjh mandjewk nuyeni 100 bu Isaac nawu beywurd nuye bimarnedanginj. ");
INSERT INTO gup_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Wanjh Sarah yimeng, “God ngannjilngmarnbom bu ngadjekme, dja birriwern rowk nawu kuhni kabirriwobekkan, bedda dorrengh kaluk ngarridjarrkdjekme.” ");
INSERT INTO gup_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Dja mak ngaleng yimeng, “Nangale yimankek bimarneyimeninj Abraham bu ngaye wurdyaw ngadjikkawoyi? Dja ngaye ngamarneyawmey beywurd bu nungka wernhkohbanjminj.” ");
INSERT INTO gup_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nawu wurdyaw wanjh djordmehdjordmeni, kaluk djikkabawong. Dja kunbarnangarra bu Isaac djikkabawong wanjh Abraham marnbom mulil mankimukkenh. ");
INSERT INTO gup_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Dja Sarah nang bu wurdyaw nawu Hagar ngalbu ngalkang Egypt bimarneyawmey Abraham, nungka wanjh bidjekmiwoni Isaac. ");
INSERT INTO gup_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Wanjh Sarah bimarneyimeng Abraham, “Yibenbenekukmunkewemen ngalmekbe ngalbu nganhmarnedurrkmirri dja nayaw ngarre, dja namekbe nawu nayaw ngarre ngalbu nganhmarnedurrkmirri, minj nungka kalarlmang nawu yehyeng ke bu yibawon, dja Isaac nuye rowk, nawu ngaye nayaw ngardduk.” ");
INSERT INTO gup_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Wanjh kunu Abraham bimarnenjilngwarreminj duninjh Ishmael nawu beywurd nuye. ");
INSERT INTO gup_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Dja God bimarneyimeng, “Yuwn bu kunihbukenh yiwernhnjilngwarre berrewoneng wurdyaw ke dja daluk ngalbu ngunmarnedurrkmirri. Dja kore Isaac ngaye won mawahmawah ke nawu berrebbom, kunmekbekenh yikurduyimen kore baleh Sarah ngunmarneyime. ");
INSERT INTO gup_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Dja mak ngaye ngabenmirndewernwon mawah nuye nayaw nawu ngalmekbe ngalbu ngunmarnedurrkmirri biyawmey, dja kabirriyimerran birriredbo warridj. Kuhni ngakurduyime bu nungka mak ngudda ke beywurd.” ");
INSERT INTO gup_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wanjh Abraham dolkkang maninjmanu kukabel, mey buriddi mak kukku budjdjurlung dorrengh nawu mayh kunkulah, dja bingorrkenwong Hagar, dja benbenemunkeweng Hagar dja nayaw ngarre nawu Ishmael. Wanjh kunu benewam benedjalwohrey kore kubolkdarleh ngarre Beersheba. ");
INSERT INTO gup_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kaluk bu kukku boyakminj manbu borrahkendi mayh kunkulah, ngaleng bikurrmeng Ishmael kore kudjurle, kaluk mandulkyahwurd. ");
INSERT INTO gup_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Wanjh wam wurd djarreh, yiman bininj kaburriwe bunarra, kumekbe yerrkang ni, dja ngalengman yimeng, “Minj ngadjare nganan bu wurdyaw karrowen.” Dja bu kumekbe ni ngaleng wanjh nalkbuhnalkbuni. ");
INSERT INTO gup_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Wanjh God bibekkang Ishmael bu nungka dorrengh nalkbuhnalkbuni, wanjh angel nuye God bikayhmeng Hagar kaddumbeh dja bimarneyimeng, “Hagar, njale yihkangewarre? Yuwn yikele, dja ngaye God nganalkbekkang wurdyaw kore kahyo. ");
INSERT INTO gup_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mah. Yirrolkka, yiwayhkemen Ishmael dja yibidkarrkarrmen, dja ngaye ngamarnbun kabenkebmawahme birriwern, kabirrimirndewernmerren kabirriyimerran birriredbo nawu birrikuken.” ");
INSERT INTO gup_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Wanjh God bimarnbom Hagar bu bolknang dja nang kaboyo kungad. Wanjh kunu ngaleng borrahkendoy rowk kore mayh kunkulah wanjh bibowong Ishmael bonguneng. ");
INSERT INTO gup_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Wanjh God binahnani nawu Ishmael bu nungka djordmehdjordmeni. Nungka ni kore kubolkdarleh wanjh mayhmakminj duninjh bu bunarra burriweyi. ");
INSERT INTO gup_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Bu nungka ni kore kubolkdarleh ngarre Paran, wanjh ngalbadjan nuye bimarnemey ngalbininjkobeng nuye kore Egyptbeh. ");
INSERT INTO gup_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kaluk yiman kunmekbe rerrih Abimelech kumwam kore Abraham, dja kaluk Phicol dorrengh, bininj nawu benmarnewohrnani djuram nuye Abimelech, wanjh Abimelech bimarneyimeng Abraham, yimeng, “God ngunehdjarrkre bu baleh yarrkka ngudda yikurduyime. ");
INSERT INTO gup_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kondah wanjh yiwokkurrmerrimen kore ngarrhdi, kunwok kunrayek duninjh, God nuye kunngey dorrengh, kanmarneyime bu ngudda minj kunwarre kanmarnekurduyime ngaye dja wurdyaw dorrengh ngardduk, mak mawahmawah kanmarnekurduyimen kunmak, dja mak kubolkwarlah warridj kore ngudda yidjalwohni nawu minj ke kunred, yikurduyimen kunmak, yiman bu ngaye werrk marnekurduyimeng ngudda.” ");
INSERT INTO gup_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Wanjh Abraham yimeng, “Ngaye kuninjkunu ngawokkurrmerren kunwok kunrayek duninjh.” ");
INSERT INTO gup_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Wanjh Abraham bimarneyimeng Abimelech bu bininj nuye nawu birrimarnedurrkmirri Abimelech birriwam birringadyirrurrkmey manu nungan Abraham nuye kungad. ");
INSERT INTO gup_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Dja Abimelech yimeng, “Ngaye ngawakwan bu nangale kuhni yimeng. Minj korroko kanmarneyimeninj, dja bolkkimewi ngahdjalbekkan.” ");
INSERT INTO gup_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Wanjh Abraham kumkang sheep dja bulikki biwong Abimelech dja bedda nawu Abimelech dja Abraham benewokmarnburrinj. ");
INSERT INTO gup_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham larlmey seven sheep yaw ngaldahdaluk kore kumirnde nuye dja benkurrmeng bebbehbeh. ");
INSERT INTO gup_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Wanjh Abimelech yimeng, “Njalekenh yilarlmey yibenkurrmeng bebbehbeh nanih nawu seven sheep yaw ngaldahdaluk?” ");
INSERT INTO gup_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham biwokmey yimeng, “Ngadjare kanbidyimang nanih nawu seven sheep yaw, ba ngurriburrbun ngaye ngangadkaruy manih manbu kahbongadyo.” ");
INSERT INTO gup_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Wanjh kunu kunmekbe kunred kabolkngeyyo Beersheba, kunmekbe kabolkngeyyo bu bedda nawu bininj bokenh benewokkurrmerrinj kunrayek duninjh kunwok. ");
INSERT INTO gup_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bu Abraham Abimelech benewokmarnburrinj kore Beersheba wanjh Abimelech bikang Phicol nawu benmarnewohrnani djuram nuye, wanjh benedurndi kore kunbolkwarlah bedberre nawu Philistine bininj. ");
INSERT INTO gup_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham dulkdudji tamarisk kundulk kore Beersheba, dja kumekbe yiwarrudj di bu bikayhmeng Yawey kunngey nuye God nawu kahdjalmimbi munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Dja Abraham kumekbe ni kunkuyeng kore kubolkwarlah bedberre nawu Philistines. ");
INSERT INTO gup_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kaluk rerrekah wanjh God birohrokmeng Abraham. Nungka bikayhmeng, yimeng, “Abraham!” Dja Abraham biwokmey, yimeng, “Kondah ngaye ngahdi, bekkahbekkan.” ");
INSERT INTO gup_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Wanjh God yimeng, “Yika ke beywurd, nawu nadjalkudji beywurd ke Isaac nawu yimarnedjare duninjh, dja yiray kore kunred kabolkngeyyo Moriah, kumekbe kore kuwarddekimuk ngaye kaluk marnewarddeyolyolme, kumekbe kunu yibun bu yikukwurlhke bu kanwon ngaye.” ");
INSERT INTO gup_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Wanjh kunu Abraham dolkkang kukabel, kurrmeng kubodmekenh nuye donkey, benbenekang bininj bokenh nawu benemarnedurrkmirri, dja mak Isaac bikang nawu beywurd nuye. Wanjh rerrngdadjdadjkeng rowk manbu kakinjekenh, wanjh birridolkkang birribolkyikani kore God bimarnebolkyolyolmeng. ");
INSERT INTO gup_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Bu kunbarnangarra danjbik Abraham balwohnang bolknang djarreh. ");
INSERT INTO gup_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Wanjh benbenemarneyimeng bininj bokenh nawu benemarnedurrkmirri, yimeng berrewoneng, “Ngunenin kondah kaluk donkey dorrengh, bu ngaye dja yawurrinj nganere kunukka, nganedi yiwarrudj. Kaluk nganemdurndeng ngorrewoneng.” ");
INSERT INTO gup_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Wanjh Abraham rerrngmey manbu kakinjekenh, dja birerrngwong Isaac nawu beywurd nuye bu rerrngkani, dja nungan Abraham kanihkani kuybuk dja mandjawak. Wanjh benebalhdjarrkrey. ");
INSERT INTO gup_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Dja Isaac bimarneyimeng kornkumo nuye nawu Abraham, yimeng, “Ngabba?” Wanjh Abraham yimeng, “Njale yidjare, Korlonj?” Isaac yimeng, “Yina, ngarrkarrme kuybuk dja kunrerrng, dja kaluk baleh sheep yaw nawu ngarrbun ngarrkukwurlhke ngarrwon God?” ");
INSERT INTO gup_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham biwokmey yimeng, “Korlonj, God nungan kaluk kanwon sheep yaw bu ngarrbun ngarrkinje ngarrwon.” Wanjh benebalhdjarrkrey. ");
INSERT INTO gup_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Bu benebebmeng kore God bimarnebolkyolyolmeng, Abraham marnbom kunwardde yiwarrudjkenh dja rerrngkurrmekurrmeng kaddumkah, wanjh biwelengdukkang Isaac nawu beywurd nuye dja bikurrmeng kaddum kore rerrngyoy kore altar. ");
INSERT INTO gup_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Wanjh bidyirriyonginj mandjawak mey, yimankek bikuyindulubuyi beywurd nuye. ");
INSERT INTO gup_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Dja angel Yawey nuye bikayhmeng kaddumbeh, yimeng, “Abraham! Abraham!” Dja nungka yimeng, “Kondah ngaye ngahdi, bekkahbekkan.” ");
INSERT INTO gup_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Wanjh angel yimeng, “Yuwn yibun nawu Isaac, yuwn baleh yimarnekurduyime, dja bonj, bolkkime wanjh ngaburrbun bu ngudda kanmarnekele ngaye God, bu ngudda minj yinganenghmeninj kankaybuyi beywurd ke, nawu nadjalkudji beywurd ke.” ");
INSERT INTO gup_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Wanjh Abraham balwohnang dja nang sheep nawu narangem kanemdjardabmeng kore kuyahyay kundulk. Wanjh wam mey namekbe sheep dja bom kinjeng bu biwong God, dja bibawong nawu nuye beywurd, minj bibuyi. ");
INSERT INTO gup_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kunu wanjh Abraham bolkngeykurrmeng “Yawey nungan kanwon.” Dja kunu bininj kabirridjalyime bu munguyh kabirriyime, “Kore Yawey nuye kunwarddekimuk nungan kanwon.” ");
INSERT INTO gup_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kaluk wanjh angel nawu nuye Yawey wanjh biyawoyhkayhmeng Abraham kaddumbeh, ");
INSERT INTO gup_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","dja yimeng, “Kuhni ngayime ngaye Yawey ngayeman ngawokkurrmerrinj, kunwok kunrayek duninjh, bu ngudda kuhni yikurduyimeng, bu minj yinganenghmeninj kankaybuyi beywurd ke nawu nadjalkudji beywurd ke, ");
INSERT INTO gup_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","wanjh ngaye woybukkih marnekurduyime kunmak, ngaye ngabenmirndewernwon nawu ngudda yibenkebmawahme ba kabirrimirndeyimerran yiman kayime mankokkarrng rerrih kore kungol yinan, dja mak yiman kayime kunkayalanj rerrih kore kukadjid kurrula kahyo. Dja nawu ngudda yibenkebmawahme kaluk kabindibolkyimang kubolkkihkimuk bedberre nawu kabindiwidnan, kaluk kabirribolkkarrme. ");
INSERT INTO gup_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dja kore bedda nawu ngudda yibenkebmawahme ngabenmarnekurduyime kunmak birribebbehmirndebubuyika rowk nawu birriredbo kore kubolkwarlahkenh rowk. Kuhni ngakurduyime bu ngudda kanwokmarrkmey kore ngawokdanj ke.” ");
INSERT INTO gup_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Wanjh kunu Abraham dja Isaac bindimarnedurndi bininj bokenh nawu benemarnedurrkmirri Abraham, dja benedolkkang birridjarrkwam kore kunred Beersheba, dja wanjh Abraham kumekbe djahdjalni. ");
INSERT INTO gup_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Kaluk yerrekah wanjh Abraham bekkang bu Milcah warridj bimarneyawmey wurdwurd nuye Nahor nawu Abraham benedanginj. ");
INSERT INTO gup_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","23","Bedda nawu bebeywurd wanjh birringeyyoy Uz, nawu nadjdjaman, Buz nawu benedanginj, dja Kemuel, Chesed, Hazo, Pildash, Jidlaph, dja Bethuel. Bedda wanjh Milcah bimarneyawmey eight bebeywurd nuyeni Nahor nawu Abraham benedanginj. Kaluk Kemuel bibornang Aram. Dja Bethuel nungka wanjh kaluk bibornang Rebekah. ");
INSERT INTO gup_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Dja mak ngalbuyika ngalbu Nahor bidjalwohmey ngalbu ngeyyoy Reumah, ngaleng wanjh benyawmey Tebah, Gaham, Tahash dja Maacah. ");
INSERT INTO gup_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah wanjh mandjewk ngarreni bu djahdjalmimbi wanjh 127, ");
INSERT INTO gup_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","wanjh ngaleng doweng kore kunred Kiriath-arba, kunmekbe kunred kabolkngeyyo warridj Hebron kore kubolkwarlah Canaan. Abraham wam bimarnenjilngwarreni dja bimarnenalkbuni Sarah bu doweng. ");
INSERT INTO gup_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Wanjh nungka dolkkang bolkbawong kore ngalbininjkobeng kukyoy, dja wam kore bininj nawu Heth benkebmawahmeng, dja wanjh benmarneyimeng, ");
INSERT INTO gup_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngaye ngamwam nawu ngakang kubolkbuyika dja kondah ngadjalwohni, yiddok minj ngurribolkweykan kandibolkwon kore ngakukdudjengkenh ngalbu nganmarnedoweng?” ");
INSERT INTO gup_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Bedda nawu Heth benkebmawahmeng birriwokmey Abraham, dja birriyimeng, ");
INSERT INTO gup_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ngudda nawu yikimuk, kanbekka ngadberre. Ngudda nawu yiman yingudjkimuk dja yiwohrnawohrnan kore ngad ngadberre, wanjh ngalbu ngunmarnedoweng yikukdudje kore kumidj kuwardderurrk kuwernhmak duninjh ngadberre, minj nakudji kore ngad ngunkaybun nawu nungan nuye kumidj ba ngudda yikukdudjeng.” ");
INSERT INTO gup_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham dolkkang boddanj kanjdji kumirrk bedberre bininj nawu Heth benkebmawahmeng nawu birrikang kumekbe kunred. ");
INSERT INTO gup_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Dja benmarneyimeng, “Bu ngudda ngurrinjilng ngakukdudjeng ngalbu nganmarnedoweng, wanjh kandibekka, wardi djawan ngudberre, ngudda kandimarnewokdi nawu Ephron, ngurrimarneyime nawu beywurd nuye Zohar, ");
INSERT INTO gup_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ba nungka kabolkweykan ngardduk kunwardderurrk nawu nungan nuye kore kunred Machpelah, kunmekbe kunwardderurrk wanjh darnkih kore nungka nuye kabbal kabalbolkburnbun. Ngurridjawa bolkweyka ngardduk bu kunmak, kore ngudda nawu ngurribekkan, kunwardde ngakukwon rowk nawu nungka rohrokmeng, ba ngabolkkarrme ngakukdudjengkenh.” ");
INSERT INTO gup_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wanjh nawu Ephron nungka kumekbe birridjarrkni bininj nuye nawu Heth benkebmawahmeng, dja nungka biwokmey Abraham kore bedda birribekkang nawu birridjarrkmirndemornnamerrinj darnkih kore kururrkdangmaye ngarre kumekbe kubolkkimuk ni. ");
INSERT INTO gup_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Wanjh yimeng, “Burrkyak, ngudda nawu kanmarnewohrnan, kanbekka, ngaye bolkwon kabbal dja kunwardderurrk dorrengh. Kore bininj ngardduk kabirribekkan, wanjh ngaye bolkwon, wanjh yikukdudje ngalbu ngunmarnedoweng.” ");
INSERT INTO gup_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Wanjh Abraham yawoyhboddanj kanjdji kumirrk bedberre bininj nawu birrikang kumekbe kunred kubolkwarlah. ");
INSERT INTO gup_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Dja bu bedda birribekkang, nungka bimarneyimeng Ephron, yimeng, “Ngadjare kanbekkan, ngadjare kukwon kunwardde rowk nawu yirohrokmeng ngarre kunmekbe kabbal. Ngadjare kankukyimang kunwardde yikan, kanbolkwon, kumekbe kunu ngakukdudjeng ngalbu nganmarnedoweng.” ");
INSERT INTO gup_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron biwokmey Abraham, yimeng, ");
INSERT INTO gup_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Kanbekka, ngudda nawu kanmarnewohrnan, kunmekbe kabbal bu bininj kabirriyime yiman 400 silver shekels kanwoyi kunwardde, dja bonj minj njale nuk 400 shekels bu ngudda dja ngaye. Bonj yidjalkukdudje ngalbu ngunmarnedoweng.” ");
INSERT INTO gup_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Wanjh Abraham biwokmarrkmey, dja bimarnerohrokmeng Ephron kunwardde nawu Ephron ngeybom kore bedda birribekkang nawu Heth benkebmawahmeng, mandjad rohrokmeng kore mankarre bedberre. ");
INSERT INTO gup_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Wanjh kunu Ephron nuyeni kabbal kore Machpelah, darnkih kunred Mamre, kaluk kabbal dja kunwardderurrk dorrengh, dja kundulk rowk kore kabbal rowk, wanjh birriwokrayekworrinj bolkyimerranj Abraham nuye kabolkkarrme, bu bininj nawu Heth benkebmawahmeng wanjh birribekkang rowk nawu birrimirndemornnamerrinj darnkih kururrkdangmaye ngarre kumekbe kubolkkimuk. ");
INSERT INTO gup_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Wanjh kaluk Abraham bikukdudji Sarah ngalbu ngalbininjkobeng nuyeni kumekbe kore kuwardderurrk kore Machpelah darnkih Mamre, kabolkngeyyo warridj Hebron, kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kuhni wanjh kayolyolme bu bininj nawu Heth benkebmawahmeng birribolkweykang birribolkwong Abraham kabbal kaluk kunwardderurrk dorrengh, ba kumekbe kabolkkarrme kabenkukdudjengkenh. ");
INSERT INTO gup_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham wanjh wernhkohbanjminj duninjh, dja Yawey biwernhmarnekurduyimeng kunmak rowk dja kunwernhkah. ");
INSERT INTO gup_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kaluk Abraham bikarrmi nakudji bininj nawu bimarnedurrkmirri korroko duninjh, nawu nahnani yehyeng rowk nawu Abraham karrmi. Wanjh Abraham bimarneyimeng, “Yibidkurrmerrimen kanjdji kore kurrad ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ngadjare yiwokkurrmerren kunwok kunrayek duninjh, kore kunngey dorrengh Yawey nawu God kore kaddum dja mak kore kurorre. Yiwokkurrmerren bu ngudda minj beywurd ngardduk yimarnemang daluk ngalbu ngalkang kondah kore karrini bedberre kunred Canaan. ");
INSERT INTO gup_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Dja ngudda yiray kore ngardduk kunred kore ngaye ngarrimud kabirrini, dja kumekbebeh yimarnemang daluk Isaac nuye nawu beywurd ngardduk.” ");
INSERT INTO gup_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Wanjh namekbe nawu bimarnedurrkmirri yimeng, “Kunubewu yimankek ngalbu daluk minj kadjare nganemre kondah kubolkwarlah, yiddok kunu beywurd ke ngakan kore kunred kubolkwarlah kore ngudda yimdolkkang?” ");
INSERT INTO gup_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham yimeng, “Yuwn kunukka. Yuwn kumekbe yikan nawu beywurd ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Dja Yawey nawu God kore kaddum heaven nganbebkeng kore kornkumo ngardduk ngarrihni, kore kubolkwarlah kore ngarranginj, dja nganmarnewokdanj dja wokkurrmerrinj kunwok kunrayek duninjh bu nganberrebbom, yimeng bu kondah kubolkwarlah kaluk kabenbolkwon nawu ngaye ngabenkebmawahme. Nungka wanjh kabimunkewe angel ngunyingkihmarnedokme, ba beywurd ngardduk yimarnemang daluk kumekbebeh. ");
INSERT INTO gup_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Dja bu daluk minj kanjilng ngunemdjarrkre, wanjh kunu bonj kabularrbuyindangen kuhni kunwok kunrayek duninjh bu kanmarnewokkurrmerren. Dja kuhni bu kundjalkudji, yuwn beywurd ngardduk yikan kumekbe.” ");
INSERT INTO gup_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Wanjh kunu namekbe bininj nawu bimarnedurrkmirri Abraham bidkurrmerrinj kore kurrad nuyeni Abraham nawu bimarnewohrnani, dja bimarnewokkurrmerrinj kunwok kunrayek duninjh bu dalukkenh Isaac nuye. ");
INSERT INTO gup_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Wanjh namekbe bininj kang ten camel mayh nawu nuyeni Abraham nawu bimarnewohrnani, dja dolkkang wam, kang nawern namakmak dorrengh nawu Abraham biwong kabenwonkenh, wanjh wam bolkyikani kore nawu Nahor nuyeni kubolkkimuk kore kubolkwarlah Mesopotamia. ");
INSERT INTO gup_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Wanjh kuberrkkah kore kumekbe kubolkkimuk kaluk kore boyoy kunngad birrihbomangi, nungka benmarnbom camel birribarddurrukkulhdi. Wanjh dungkedjelkminj bu daluk birrimrey birribomangi. ");
INSERT INTO gup_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Wanjh namekbe bininj danginj yiwarrudj, yimeng, “Ngudda Yawey nawu God nuye Abraham, nawu nganmarnewohrnan. Ngaye djawan kanbidyikarrmen bolkkime, ba kakurduyimerran bu ngamwamkenh, dja yikongibu yimarnekurduyimen kunmak Abraham nawu nganmarnewohrnan. ");
INSERT INTO gup_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Yina, ngaye ngahdi darnkih kore maninjmanu njilhmi kaboyo, dja daluk nawu birrikang kondah kubolkkimuk kabirrimre kabirribomang. ");
INSERT INTO gup_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kab bu ngamarneyime ngalyawk, bu ngayime, ‘Ngadjare kanmarneboma budjdjurlung ke ba ngabongun.’ Dja ngaleng kayime, ‘Yibongu, dja ngabenbowon camel ke warridj.’ Ngalyawk ngalbu kunmekbe kayime, wardi bu ngaldjalmekbenin ngalbu ngudda yimarnedjarrngbom nuye Isaac nawu ngunmarnedurrkmirri. Bu kuhni kakurduyimerran, wanjh ngaye ngaburrbun bu ngudda yikongibun nawu ngaye nganmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Minj bangmeyakwoyi bu yiwarrudj dingihdi, wanjh kumekbe ngalbu Rebekah kumbebmeng budjdjurlung ngorrkani kukkukenh kukarlang ngarre. Ngalmekbe ngalyawk Rebekah wanjh kornkumo ngarreni Bethuel nawu Milcah ngalbadjan nuye, dja ngalbu Milcah ngalbininjkobeng nuyeni Nahor, nawu nungka Abraham benedanginj. ");
INSERT INTO gup_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ngalmekbe ngalyawk ngalkukmakkaykenhni duninjh, dja minj bininj benebangmeyuwirrinj. Ngaleng wanjh koluy kore njilhmi boyoy, borrahkendoy bobarlkeng budjdjurlung, wanjh kumbidbom. ");
INSERT INTO gup_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Wanjh namekbe bininj rlobmeng birrabkeng, dja yimeng, “Ngadjare kanwohbowo manboyahwurd ngawohbongun kore ngudda ke budjdjurlung.” ");
INSERT INTO gup_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ngaleng yimeng, “Yibongu ngudda nawu kanmarnewohrnan.” Wanjh ngaleng werrkwerrk koluyhweng budjdjurlung kukarlangbeh, karrmeng kore kubid, dja bibowong. ");
INSERT INTO gup_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Bu ngaleng yakwong bu bibowong, wanjh ngaleng yimeng, “Ngabomang bedberre nawu camel ke warridj. Ngadjalbomang munguyh bu kabirribongun rowk kabirriboyakwon.” ");
INSERT INTO gup_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Wanjh kunu werrkwerrk ngaleng boyakbom kore mayh bedberre birriborrahkendongi, dja rlobmeng durndi kore kungad, benmarnebomangi camel nuyeni rowk. ");
INSERT INTO gup_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Dja namekbe bininj bidjalnani wokyak, ba kaluk kaburrbun bu Yawey kabimarnekurduyime nawu kumwamkenh, dja nuk burrkyak. ");
INSERT INTO gup_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Bu camels birribonguneng rowk birriyakwong, wanjh nawu bininj bebkeng nawu kunkebkenh gold, walakkih dulmuk, dja bokenh gold kunberlkenh ngalengngarre dulmukwurd, wanjh biwong Rebekah. ");
INSERT INTO gup_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Wanjh nungka bidjawam, yimeng, “Kanmarneyimen, ngudda nangale ngunbornang? Yiddok kunrurrkkimuk nuye bu ngad ngarriwohyo?” ");
INSERT INTO gup_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Wanjh ngaleng bimarneyimeng, “Ngaye wanjh kornkumo ngardduk wanjh Bethuel nawu Milcah bimarneyawmey Nahor.” ");
INSERT INTO gup_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Dja yimeng warridj, “Ngad ngarrikarrme kundalk dja manme bedberre mayh, dja mak kunrurrk bu ngurriwohyo.” ");
INSERT INTO gup_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Wanjh namekbe nawu bininj barddurrukkurlhdanj dja biburlumeng Yawey, ");
INSERT INTO gup_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","dja yimeng, “Ngaburlume Yawey nawu God nuye Abraham nawu nganmarnewohrnan, bu nungka minj bawoyi bu kabikongibun, kunmak kabidjalmarnekurduyime, kabidjalburrbun munguyh kabinahnan nawu nganmarnewohrnan. Dja wanjh ngayembu, nungka Yawey mandjad nganmikang ngamwam kore kunred bedberre birrimud nuye nawu nganmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Wanjh ngalbu ngalyawk ngaleng wanjh rlobmeng, dokmeng kured dja benmarneyimeng rowk nawu birrihni ngalbadjan ngarre kururrk. ");
INSERT INTO gup_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Dja nawu Rebekah benedanginj nungka ngeyyoy Laban, nungka wanjh dokorrokmeng bimarnebebmeng bininj nawu di kumekbe kore njilhmi boyohboyoy. ");
INSERT INTO gup_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Bu Laban bimarnenang ngaldaluk Rebekah bu kebdjongbuyindi dja berldjongbuyindi, dja bibekkang yolyohyolyolmi bu bininj bimarneyimeng, wanjh kundjalmekbe rerrih nungka Laban wam kore bininj, bingalkeng, kaluk kumekbe djahdjaldi camel dorrengh kore njilhmi boyoy. ");
INSERT INTO gup_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban yimeng, “Yimray ngarre, ngudda nawu Yawey ngunmarnekurduyime kunmak, dja njalekah yihdi kuberrk? Dja ngokko ngaye ngayingkihbolkmarnbom ke dja mak camels bedberre.” ");
INSERT INTO gup_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Wanjh kunu namekbe bininj benewam kore Laban nuyeni kunrurrk, dja Laban bodmeyerrhyerrkkeng nawu camels, dja biwong kundalk dja manme bedberre. Dja mak benmarnebokurrmeng kukku kundengekenh nungka dja bininj nawu birridjarrkrey ba kabirridengedjirridjburren. ");
INSERT INTO gup_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bu manme bimarnekurrmeng kangun, nawu Abraham bimarnedurrkmirri yimeng, “Minj ngaye ngabangmengun, ngayolyolme werrk bu njale ngamwamkenh.” Wanjh Laban yimeng, “Mah yiyolyolmen.” ");
INSERT INTO gup_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Wanjh nungka yimeng, “Ngaye wanjh ngamarnedurrkmirri Abraham. ");
INSERT INTO gup_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawey kunmak duninjh bimarnekurduyimeng nungka nawu nganmarnewohrnan, dja nungka kukenminj duninjh. Nungka biwong namirndebubuyika nawu mayh, dja silver dja gold, dja bininj daluk nawu ngarrimarnedurrkmirri, dja camels, dja donkeys. ");
INSERT INTO gup_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Dja Sarah ngalbu ngalbininjkobeng nuyeni nungka nawu nganmarnewohrnan, wanjh ngaleng bimarneyawmey bu kohbanjminj, dja nungka biwong namekbe beywurd yehyeng rowk nawu nuye. ");
INSERT INTO gup_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Dja nungka nawu nganmarnewohrnan ngandjurrkkang ngawokkurrmerrinj kunwok kunrayek duninjh, bu nungka nganmarneyimeng, ‘Yuwn beywurd ngardduk yimarnemang daluk ngalbu ngalkang kondah kore karrihni kubolkwarlah bedberre bininj nawu birrikang kondah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Dja ngudda yiray kore kunred nuyeni kornkumo ngardduk kore ngaye ngarrimud kabirrini, kaluk kumekbebeh daluk yimarnemang beywurd ngardduk.’ ");
INSERT INTO gup_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Kunmekbe nganmarneyimeng, dja ngaye ngamarneyimeng nungka nawu nganmarnewohrnan, ngayimeng, ‘Kunubewu yimankek ngalbu daluk minj nganemre.’ ");
INSERT INTO gup_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Dja nungka nganmarneyimeng, yimeng, ‘Yawey nawu nganehdjarrkre, nungka kaluk kabimunkewe angel nuye ngunedjarrkre, dja ngunmarnekurduyime kunmak bu ngaye ngayimeng, dja beywurd ngardduk yimarnemang daluk kaluk kumekbebeh kore ngarrimud kore nawu nganbornang nuyeni kunred. ");
INSERT INTO gup_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kaluk bu ngudda yikurduyime rowk, wanjh kabularrbuyindangen kore yiwokkurrmerrinj kunwok kunrayek duninjh. Bu yire kore ngaye ngarrimud, dja bu bedda minj ngundiwon daluk, wanjh kunu bonj kabularrbuyindangen bu ngudda kanmarnewokkurrmerrinj kuhni bu kunwok kunrayek duninjh.’” ");
INSERT INTO gup_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Kunmekbe wanjh nganmarneyimeng Abraham, dja bolkkime ngamwam kore njilhmi kaboyo dja yiwarrudj ngarranginj ngayimeng, ‘Ngudda Yawey nawu God nuye Abraham nawu nganmarnewohrnan, bu ngudda yidjare yikurduyime nawu ngamwamkenh, ");
INSERT INTO gup_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","wanjh yina ngahdi kondah darnkih kore maninjmanu njilhmi kabirrihbomang, kab bu ngalyawk kamre kabomang dja ngamarneyime, “Ngadjare kanwohbowo manboyahwurd kore budjdjurlung ke ngawohbongun.” ");
INSERT INTO gup_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Dja bu ngaleng kayime ngardduk, “Yibongu, dja ngabomang bedberre nawu camels ke warridj.” Daluk ngalbu kunmekbe kayime, wardibu ngaldjalmekbenin ngalbu ngudda Yawey yimarnedjarrngbom beywurd nuye nawu ngaye nganmarnewohrnan.’” ");
INSERT INTO gup_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kuhni ngayimeng, dja bu ngaye minj ngabangmeyakwoyi bu ngawokdi baybaywi kukange ngardduk, wanjh kumekbe Rebekah kumbebmeng budjdjurlung ngorrkani kukkukenh kukarlang ngarre, dja ngaleng koluy kore njilhmi kaboyo dja bomey. Ngaye ngamarneyimeng, ‘Ngadjare kanbowo.’ ");
INSERT INTO gup_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Wanjh ngaleng werrkwerrk budjdjurlung koluyhweng kukarlangbeh dja yimeng, ‘Yibongu dja camels ke warridj ngabenbowon.’ Wanjh kunu ngaye ngabonguneng, dja ngaleng benbowong camels warridj. ");
INSERT INTO gup_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Wanjh ngaye ngadjawam, ‘Ngudda nangale ngunbornang?’ Wanjh ngaleng yimeng, ‘Ngaye kornkumo ngardduk wanjh Bethuel nawu Milcah bimarneyawmey Nahor.’ Kunu wanjh ngakebdjongbom ring, dja kunberlkenh ngaberldjongbom. ");
INSERT INTO gup_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Wanjh ngadjalbarddurrukkurlhdanj bu ngaburlumeng nawu Yawey. Ngaburlumeng nungka Yawey, nawu God nuye Abraham nawu nganmarnewohrnan, dja nungka God mandjad nganmikang ngamwam kore ngurrimud nuye nawu nganmarnewohrnan, ba beywurd nuye ngamarnemang daluk ngalbu Abraham benedanginj bikebmawahmeng.” ");
INSERT INTO gup_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Wanjh namekbe bininj nawu Abraham bimarnedurrkmirri yimeng bedberre, “Wanjh bu ngudda ngurrimarnewoybuk ngurrimarnekurduyime kunmak nungka nawu nganmarnewohrnan, wanjh kandimarneyimen, dja bu burrkyak wanjh kandimarneyimen ba ngaburrbun bu baleh ngakurduyime.” ");
INSERT INTO gup_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Wanjh Laban dja Bethuel benewokmey beneyimeng, “Kuhni wanjh Yaweybeh, wanjh ngad minj baleh mak ngundimarneyime bu yimankek kamak dja nuk kawarre. ");
INSERT INTO gup_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Yina ngahli wanjh Rebekah, yima dja ngunere, wanjh bonj benemarrimen beywurd nuye nawu ngunmarnewohrnan, kore Yawey nungka ngunbukkang.” ");
INSERT INTO gup_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Bu namekbe bininj nawu Abraham bimarnedurrkmirri bu benbenebekkang kore beneyimeng, nungka boddanj kanjdji kurorre kore Yawey kumirrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Wanjh namekbe bininj bebkeng yehyeng namakmak nawu birridjongburreni silver dja gold, dja mak kunmadj, dja biwong Rebekah, dja warridj ngalbadjan dja narangem benbenewong namakmak. ");
INSERT INTO gup_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Wanjh nungka dja bininj nawu birridjarrkrey birringuneng birribonguneng dja kumekbe birriwohyonginj. Bu nungka dolkkang bu malaywi wanjh yimeng, “Kandimunkewemen ngarrurndeng kore nganmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Dja nawu Rebekah benedanginj dja ngalbadjan ngarre beneyimeng, “Kab minj ngalyawk ngarriwohni kondah bu yiman ten kunkodjke, kunmekbe wanjh ngurrire.” ");
INSERT INTO gup_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Wanjh nungka yimeng, “Yuwn kandimaddeng, dja Yawey nganmarnekurduyimeng bu ngamwamkenh. Wanjh kandimunkewemen ba ngare kore nungka nawu nganmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wanjh bedda beneyimeng, “Wardi ngalyawk nganekayhme nganedjawan.” ");
INSERT INTO gup_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wanjh benekayhmeng Rebekah benedjawam, “Yiddok ngunere nanih nawu bininj?” Dja ngaleng yimeng, “Yoh ngare.” ");
INSERT INTO gup_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Wanjh kunu benemunkeweng Rebekah ngalbu birrimud, daluk dorrengh ngalbu bihnahnani birridjarrkwam namekbe bininj nawu Abraham bimarnedurrkmirri, dja bininj nawu birridjarrkrey. ");
INSERT INTO gup_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wanjh bedda nawu Laban dja ngalbadjan beneyimeng kunmak kunwok ngarre Rebekah, beneyimeng, “Ngalyawk ngalbu kanemud, nganedjare ngudda wurdwurd ke kabirrimirndewernmerren duninjh, dja nawu ngudda ke yibenkebmakkahme kabindibolkyimang kubolkkihkimuk bedberre nawu kabindiwidnan, kaluk kabirribolkkarrme.” ");
INSERT INTO gup_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kunu wanjh Rebekah dolkkang dja daluk dorrengh nawu birrimarnedurrkmirri, wanjh camels birrimorneni, dja birridjarrkwam namekbe nawu bininj. ");
INSERT INTO gup_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Bu kumekbe bolkyimi, Isaac nungka bolkbawong Beer Lahai Roi, dja wanjh nungka wam ningihni kore Negeb. ");
INSERT INTO gup_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Bu wolewolehminj Isaac wam kore kabbal burrbuhburrbuni, wanjh balwohnang nang camels kabirrimhre. ");
INSERT INTO gup_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Dja Rebekah balwohnang dja bu ngaleng binang Isaac, ngaleng wanjh kumkoluy dja bimarneyimeng nawu Abraham nuye kabimarnedurrkmirri, yimeng, ");
INSERT INTO gup_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“Kaluk nangale nahni bininj nawu kahdjalle kore kabbal, nawu kamre kandabke kadberre?” Wanjh nawu bininj yimeng, “Nungka wanjh beywurd nuye nawu nganmarnewohrnan.” Kunu wanjh ngaleng kummey nawu manburrba ngarre nawu kunkebkenh, dja kebbarrkburrinj. ");
INSERT INTO gup_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Wanjh namekbe bininj bimarneyolyolmeng Isaac yehyeng rowk nawu nungka kurduhkurduyimi. ");
INSERT INTO gup_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Wanjh Isaac bimey ngalyawk Rebekah, bikang kore dabburlin nuye kore ngalbadjan nuye Sarah yoy kunkare, dja Rebekah yimerranj ngalbininjkobeng nuye. Wanjh Isaac bimarnedjareni. Kunu wanjh nungka njilngmakminj bu ngalbadjan nuyeni ngalbu Sarah bimarnedoweng. ");
INSERT INTO gup_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Kaluk Abraham bimey ngalbuyika ngalbininjkobeng ngalbu ngeyyoy Keturah. ");
INSERT INTO gup_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ngaleng bimarneyawmey Zimran, Jokshan, Medan, Midian, Ishbak dja Shuah. ");
INSERT INTO gup_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Kaluk Jokshan benbenebornang Sheba dja Dedan. Kaluk nawu nunganwali Dedan benkebmawahmeng bininj nawu birribebbehngeyyoy Ashur, dja mak Letush dja mak nawu Leumm. ");
INSERT INTO gup_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Dja Midian nuyeni bebeywurd wanjh Ephah, Epher, Hanoch, Abida dja Eldaah. Birrimekbe rowk wanjh Keturah benyawmey dja benkebmakkahmeng. ");
INSERT INTO gup_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham biyibawong Isaac yehyeng rowk nawu karrmi. ");
INSERT INTO gup_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Dja bu nungka Abraham djahdjaldarrkidni nungka burudjang benwong bebeywurd nuyeni nawu dalukbubuyika nawu nungka bendjalwohmey bindiyawmey. Wanjh benmunkeweng rowk kore kubolkwarlahbuyika, kaluk koyek, ba minj bedda birridjarrkraworrimeninj Isaac nawu beywurd nuye. ");
INSERT INTO gup_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham nuyeni mandjewk rowk bu djahdjalmimbini wanjh 175. ");
INSERT INTO gup_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Wanjh nungka ngolekdadjmeng, doweng bu wernhkohbanjminj duninjh, dja malngwam kore Mawah nuyeni birriyingkihmalngdokmeng. ");
INSERT INTO gup_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Bebeywurd nuye nawu Isaac dja Ishmael bedda wanjh benekukdudji kore kuwardderurrk kore kunred Machpelah darnkih Mamre, kaluk kore kabbal nuyeni Ephron beywurd nuyeni Zohar nawu mawahmawah nuye Heth. ");
INSERT INTO gup_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Mahni kabbal nawu Abraham korrokoni karremulewam bu birribolkweykang bininj nawu Heth benkebmawahmeng. Wanjh kumekbe Abraham benekukdudji, dja Sarah kumekbe benemidjraworrinj ngalbu ngalbininjkobeng nuyeni. ");
INSERT INTO gup_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Bu Abraham doweng wanjh God bimarnekurduyimeng kunmak Isaac nawu beywurd nuye Abraham, dja nungka Isaac yerrkang ni darnkih kore kunngad boyoy manbu bongadngeyyoy Beer Lahai Roi. ");
INSERT INTO gup_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Kuhni kabiyolyolme Abraham beywurd nuye nawu Ishmael nawu Hagar bimarneyawmey Abraham. Hagar ngaleng ngalkang Egyptbeh dja bimarnedurrkmirri Sarah. Wanjh nawu Ishmael benbornang dja benkebmawahmeng nahni bininj rowk. ");
INSERT INTO gup_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Kuhni wanjh birringeyyoy bebeywurd nuye, nawernwarre kangeydi werrk, kabirringeydi rowk, kaluk yerre wanjh nayahwurd duninjh kangeydi. Kuhni wanjh birringeyyoy; Nebaioth nawu nadjdjaman nuyeni Ishmael, dja Kedar, Adbeel, Mibsam, ");
INSERT INTO gup_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO gup_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish dja Kedemah. ");
INSERT INTO gup_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Kunmekbe wanjh birringeyyoy Ishmael nuyeni bebeywurd. Bedda wanjh birriyimerranj rowk bu birribebbehwohrnani namudbubuyika bedberre. Kunmekbe wanjh birribebbehbolkngeykenhkani warridj kubolkyahwuyahwurd bedberre kore birrireddi. ");
INSERT INTO gup_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael nuyeni mandjewk rowk bu djahdjalmimbini wanjh 137. Wanjh nungka ngolekdadjmeng, doweng dja malngwam kore mawah nuyeni birriyingkihmalngdokmeng. ");
INSERT INTO gup_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Dja nungka nawu benkebmawahmeng birrini kore kubolkwarlah, kaluk kabolkdedjdjingmang kore kunred Havilah, kadjalewi kabolkburnbun kore kunred Shur, darnkih kore Egypt, dja mak kore karribalhbolkyikan kunred Asshur. Dja bedda birriyidwernni bindimarneyidngalhngalkeyi bedberre birribuyika bininj nawu Abraham benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Kuhni wanjh kabiyolyolme Isaac nawu Abraham nuyeni beywurd. Abraham bibornang nawu Isaac. ");
INSERT INTO gup_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kaluk bu Isaac mandjewk nuyeni wanjh forty nungka benemarrinj Rebekah, ngalbu ngalbeywurd nuye Bethuel nawu Aramean bininj, nakang Paddan Aram kore kubolkwarlah Mesopotamia. Dja ngaleng wanjh benedanginj Laban nawu Aramean bininj. ");
INSERT INTO gup_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac nuyeni ngalbininjkobeng wanjh ngalwalirrngwarreni, wanjh kunu Isaac bimarnedanginj yiwarrudj bidjawam Yawey bu ngalengkenh. Wanjh Yawey bibekkang bu yiwarrudj dingihdi dja ngalbininjkobeng nuye ngalbu Rebekah ngaleng wanjh kanihkani wurdyaw. ");
INSERT INTO gup_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kaluk Rebekah bekkabekkarreni namekbe bokenh wurdyaw beneburreni kore kunjam ngalengngarre, wanjh yimeng, “Njalekenh mak ngaye ngahmimbi bu kuhni kurduyimerranj ngardduk?” Kunmekbekenh kunu wanjh ngaleng wam bidjawam Yawey. ");
INSERT INTO gup_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Dja nungka Yawey bimarneyimeng, yimeng, “Nawu ngudda yibenbeneyawkan wanjh kabenebebbehyimerran benebebbehredbubuyika nawu kabenebebbehmud, nawu kaluk kabenebebbehkuklarlmiyindan. Kaluk mirndebuyika nawu nakudji nuye kabirriwernhngudjkimukmen, nabuyika nawu mirndebuyika nuye nanu wanjh birringudjwarre. Dja nawu kamdokme karrangen, nungka wanjh kabimarnedurrkmirri nawu yerre kamdangen.” ");
INSERT INTO gup_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kaluk bu kumwam ngarre wurdyaw bihbuni wanjh benedanginj narangem bokenh. ");
INSERT INTO gup_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nawu werrk danginj nungka wanjh kukkurlbakurlbahni, dja kunburrk rowk nuyeni wanjh muddubbeni. Wanjh kunmekbekenh kunu benengeykurrmeng Esau. ");
INSERT INTO gup_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kaluk rerre wanjh nawu benedanginj wanjh danginj. Nungka wanjh bidjalmadkarrmi nawu nawernwarre Esau. Kunmekbekenh kunu nungka wanjh ngeyyoy Jacob. Isaac wanjh mandjewk nuyeni yimerranj 60 bu Rebekah benbeneyawmey. ");
INSERT INTO gup_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kaluk namekbe narangem bokenh benedjordminj. Wanjh Esau yimerranj mayhmakni dja djareni djahdjalley kubehbeberrk. Dja Jacob nungka namodmikenhni, nungka djahdjalni kured, djahdjalwohrey kore dabburlin. ");
INSERT INTO gup_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac biwernhmarnedjareni Esau, djareni nguyihnguyi mayh nawu Esau bimarnedjangkani. Dja Rebekah ngaleng wanjh biwernhmarnedjareni Jacob. ");
INSERT INTO gup_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kaluk kunkudjikenh bu Jacob kinjehkinjeyi manme kunkalkkid, wanjh Esau kumbebmeng kuberrkbeh kore rengehrey, dja nungka bulkkidj djalwernhmarrwedoweng. ");
INSERT INTO gup_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Wanjh nungka bimarneyimeng Jacob, yimeng, “Werrkwerrk kanwo yikah manmekbe mankukkurlba manme ngangun, dja ngaye ngadjalwernhmarrwedoweng bulkkidj.” (Kunmekbekenh kunu wanjh nungka ngeyyoy Edom warridj, dja Edom, kunekke kunngey kayime “Kukkurlba”.) ");
INSERT INTO gup_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Dja Jacob biwokmey, yimeng, “Kanwo werrk yimweyka nawu nawernwarrekenh, yerre wanjh yingun manme.” ");
INSERT INTO gup_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau yimeng, “Yina, ngaye bolk darnkih ngarrowen, dja njalekenh yimankek ngaburrbun nawernwarrekenh?” ");
INSERT INTO gup_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Dja Jacob yimeng, “Kanmarnewokkurrmerrimen werrk kunwok kunrayek duninjh!” Wanjh Esau wokkurrmerrinj kunwok kunrayek duninjh bu bimarneweykang Jacob nawu nungan Esau nuyeni nawernwarrekenh, biwong Jacob. ");
INSERT INTO gup_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kunu wanjh Jacob biwong Esau buriddi mak manmekbe mankukkurlba manme kunkalkkid. Wanjh Esau nguneng dja bonguneng wanjh dolkkang wam. Kunu wanjh Esau warnyakminj djalbawong nawu nuyeni nawernwarrekenh. ");
INSERT INTO gup_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kaluk kore kumekbe kubolkwarlah wanjh yawoyhdjewkwarrewong bolkdarlehminj, manme birriyawarreni. (Kaluk kunbuyika minj kunkudjiwi bu bolkdarlehminj bu Abraham darrkidni.) Wanjh Isaac wam kore kunred kabolkngeyyo Gerar kore kubolkwarlah bedberre Philistines kore nawu king Abimelech wohrnawohrnani. ");
INSERT INTO gup_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yawey bimarnebukkarrinj Isaac, dja bimarneyimeng, “Yuwn yire kore kubolkwarlah Egypt, dja yidjalnin kore kubolkwarlah bu ngaye wokrayekwon. ");
INSERT INTO gup_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kondah kubolkwarlah yidjalwohnin wurd kunkuyeng, dja ngaye ngarrdjarrkre dja marnekurduyime kunmak. Kunmekbe ngayime ke bu ngaye kaluk bolkwon ngudberre, ngudda dja nawu yibenkebmawahme, bolkwon rowk kondanjkunu kubolkwarlahbubuyika, wanjh kunu ngakurduyime, bu ngawokkurrmerrinj kunwok kunrayek duninjh nuye kornkumo ke Abraham. ");
INSERT INTO gup_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ngaye ngabenmarnbun nawu ngudda yibenkebmawahme bininj kabirrimirndeyimerran yiman mankokkarrng kamirndeyime kore kungol, dja ngabenbolkwon kondanjkunu kubolkwarlahbubuyika rowk, dja mak kore bedda nawu yibenkebmawahme, wanjh ngabenmarnekurduyime kunmak birribebbehmirndebubuyika rowk nawu kabirrihni kubolkbubuyika kore kondah kurorre. ");
INSERT INTO gup_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kunmekbe kunu ngakurduyime bu Abraham nganwokmarrkmangi dja nganwokkarrmi rowk kore ngaye ngahdjareni, dja mak kore ngawokrayekwong, dja mak ngawokkurrmerrinj, dja mankarre rowk bu ngakarremarnbom. Kunmekbe rowk nungka kurduhkurduyimi bu nganwokkarrmi.” Kuhni Yawey bimarneyimeng nawu Isaac. ");
INSERT INTO gup_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Wanjh kunmekbekenh kunu Isaac ni kore Gerar. ");
INSERT INTO gup_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bu bininj nawu kumekbe birrini birridjawam Isaac Rebekahkenh nungka yimeng, “Ngaleng wanjh ngaye nganedanginj.” Nungka keleni bu yimankek yimeninj, “Ngaleng wanjh ngalbininjkobeng ngardduk.” Dja nungka burrbuhburrbuni baybaywi yimeng, “Bininj nawu kondah kunred kabirrini wardi ngandibun Rebekahkah, dja ngaleng ngalkukmakkaykenh.” ");
INSERT INTO gup_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Bu Isaac kumekbe ni bu korroko wanjh Abimelech nawu king nawu benmarnewohrnani Philistine bininj, nungka bolknang kanjdji bu nungka dingihdi darnkih kore window, dja benbenenang Isaac benehkeyoy Rebekah ngalbu ngalbininjkobeng nuye. ");
INSERT INTO gup_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kunu wanjh Abimelech bikayhmeng Isaac dja yimeng, “Yina, ngaleng wanjh ngalbininjkobeng ke, wanjh njalekenh ngudda yiyimeng bu ngunedanginj?” Isaac yimeng, “Ngaye ngayimeng marndi ngandibun bu ngalengkah.” ");
INSERT INTO gup_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Wanjh Abimelech yimeng, “Njale kuhni ngudda kanmarnekurduyimeng ngadberre? Nakudji nawu ngad bininj marndi benewarriboyuwurrinj ngalbininjkobeng ke, dja kunu ngudda kanmarnbuyi bu ngad kunwarre ngarriyimeninj.” ");
INSERT INTO gup_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Wanjh Abimelech benwokrayekwong nungka nuye rowk, yimeng, “Nawu kabenbenemarneyime kunwarre nanih nawu bininj dja ngalbininjkobeng nuye, namekbe wanjh kadjaldowen.” ");
INSERT INTO gup_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac kaluk dudji manmim kore kumekbe kubolkwarlah, dja bu kunkudjiwi mandjewk nungka mangi manwern duninjh manme yiman 100. Yawey bimarnekurduyimeng kunmak. ");
INSERT INTO gup_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Wanjh nungka kukenminj, dja mak munguyh wernhkukenwernminj, kaluk nungka djalwernhkukenminj duninjh. ");
INSERT INTO gup_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nungka benkarrmi namirndebubuyika mayh, dja mak birriwern bininj nawu birrimarnedurrkmirri, wanjh kunu nawu Philistine bininj birrimarnekirnni. ");
INSERT INTO gup_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kaluk kunngad rowk manbu kornkumo nuyeni bininj birringadkaruy bu nungka Abraham rengehrey kumekbe, wanjh bedda nawu Philistine bininj birringaddudji rowk. ");
INSERT INTO gup_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Wanjh Abimelech bimarneyimeng Isaac, yimeng, “Yiray, kanbawo ngadberre, dja ngudda yiwernhngudjkimukminj ngadberre.” ");
INSERT INTO gup_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Wanjh kunu Isaac bolkbawong kumekbe, dja wam bolkmarnbom kore kanjdjikanjdji ngarre Gerar dja kumekbe kunu ningihni. ");
INSERT INTO gup_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac nuye bininj birriyawoyhngadkaruy rowk kunngad manbu Philistine bininj birringaddudji bu kornkumo nuyeni nawu Abraham doweng, manbu kerrngehkenh birringadkaruy bininj nuyeni Abraham, bu nungka ningihni kumekbe. Dja Isaac yawoyhbongadngeykurrmeng rowk kunngeykudjiwi bu kornkumo yingkihbongadngeykurrmeng. ");
INSERT INTO gup_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaac nuye bininj nawu birrimarnedurrkmirri wanjh birringadkarungi kumekbe kore kanjdjikanjdji dja birribongalkeng kukku njilhmi. ");
INSERT INTO gup_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Dja bininj nawu birrinahnani mayh nawu birrikang Gerar, dja nawu Isaac nuyeni bininj nawu birrinahnani mayh, wanjh birriboyirrurreni. Dja bedda nawu birrikang Gerar birriyimeng, “Maninjmanu kukku wanjh ngad ngadberre.” Wanjh kunu Isaac bongadngeykurrmeng “Birridurrinj” bu bedda birriboyirrurrinj. ");
INSERT INTO gup_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Wanjh birriyawoyhngadkaruy manbobuyika dja manmekbe warridj birriboyirrurrinj, wanjh kunu Isaac bongadngeykurrmeng “Kandiwidnan”. ");
INSERT INTO gup_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Wanjh nungka bolkbawong kumekbe, dja bininj nuye birriyawoyhngadkaruy manbobuyika, dja minj birriboyirrurrimeninj. Wanjh kunu nungka bongadngeykurrmeng “Kubolkwarlah”, wokkihyimi dorrengh, “Bolkkime wanjh Yawey kanmarnebolkwarlahwong ba karrini kamak rowk dja ngad karrimirndewernmerren kondah kubolkwarlah.” ");
INSERT INTO gup_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kaluk Isaac bolkbawong kumekbe dja wam kore Beersheba. ");
INSERT INTO gup_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Wanjh kundjalmekbe kumunun bu bolkmey wanjh Yawey bimarnebukkarrinj, dja yimeng, “Ngaye wanjh God nuyeni kornkumo ke Abraham. Yuwn yikele, ngaye ngarrdjarrkre, dja ngaye marnekurduyime kunmak, dja ngabenmirndewernwon nawu ngudda yibenkebmawahme. Kuhni ngakurduyime bu Abrahamkenh nawu nganmarnedurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kaluk kumekbe Isaac marnbom altar kunwardde yiwarrudjkenh, dja kumekbe danginj yiwarrudj bikayhmeng kunngey nuye Yawey. Kumekbe nungka nameng dabburlin nuye, dja mak bininj nuye nawu birrimarnedurrkmirri birringadkarungi. ");
INSERT INTO gup_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Dja bu kunmekbe birribalhyimi, Abimelech kumbebmeng Gerarbeh, birrimdjarrkwam Ahuzzath nawu nungan nuye bibidyikarrmi, dja Phicol nawu benmarnewohrnani djuram nuye. ");
INSERT INTO gup_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac bendjawam, “Njalekenh ngurrimwam kore ngaye dja ngudda wanjh kandiduy kandikukmunkeweng?” ");
INSERT INTO gup_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bedda birriwokmey birriyimeng, “Ngad mandjad ngarrihnan bu Yawey ngunehdjarrkre, wanjh kunu ngundimarneyime, wardi karriwokkurrmerrimen kunwok kunrayek duninjh, ngad dja ngudda, wardi karriwokmarnburrimen, ");
INSERT INTO gup_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ba ngudda minj njale kunwarre kanmarneyime ngadberre, yiman rerrih bu ngad minj baleh ngundimarneyimeninj, kunmakwi ngundihdjalmarneyimi, dja ngundimunkeweng kunmodmikenh dorrengh, dja bolkkime wanjh Yawey ngunmarnekurduyimeng kunmak.” ");
INSERT INTO gup_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Wanjh Isaac benmarnemarnbom mulil, wanjh birringuneng dja birribonguneng. ");
INSERT INTO gup_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Dja wanjh bu kukabel bedda kunu birriwokkurrmerrinj kunmekbe kunwok kunrayek duninjh. Wanjh Isaac benmunkeweng kabirridurndeng, wanjh birribawong kunmodmikenh dorrengh. ");
INSERT INTO gup_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Wanjh kunmekbe kunbarnangarra rerrih Isaac nuye bininj nawu birrimarnedurrkmirri birrimarnebebmeng, dja birrimarnemulewam kunngad manbu birringadkaruy. Birriyimeng, “Ngad ngarribongalkeng kukku.” ");
INSERT INTO gup_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Nungka Isaac bongadngeykurrmeng Shiba, dja kunmekbekenh kunu kunmekbe kubolkkimuk munguyh kadjalbolkngeyyo Beersheba. ");
INSERT INTO gup_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Bu Esau nungka mandjewk nuyeni forty nungka benemarrinj Judith ngalbeywurd nuye Beeri nawu Nahit bininj, dja mak benemarrinj Basemath ngalbeywurd nuye Elon nawu Nahit bininj. ");
INSERT INTO gup_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Dja bedda nawu ngalbibininjkobeng nuye wanjh bindinjilngwarrewoni Isaac dja Rebekah. ");
INSERT INTO gup_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Bu Isaac wernhkohbanjminj dja wernhmimbulerranj minj njale wernhnayi, wanjh bikayhmeng Esau nawu nuye beywurd nawu nadjdjaman, dja bimarneyimeng, “Korlonj.” Esau biwokmey yimeng, “Njale yidjare?” ");
INSERT INTO gup_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac yimeng, “Kanbekka, marneyime. Ngaye ngakohbanjminj, dja ngawakwan bu baleh kayime ngarrowen. ");
INSERT INTO gup_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Mah, wanjh yima bunarra ke dja yiray kore kubehbeberrk, yidjangka mayh ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kanmarnekinjemen namanjmak nawu ngahdjaredjare dja yimkan ngardduk ngangun, ba ngaye marneyime kunmak kunwok, wanjh yerre ngawelengdowen.” ");
INSERT INTO gup_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekah ngaleng wanjh bibekkani kore Isaac bimarneyimi Esau nawu beywurd nuye. Dja Esau wam kore kabbal kadjangkan mayh kamkukyirrurndeng, ");
INSERT INTO gup_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Wanjh Rebekah bimarneyimeng nayaw ngarre nawu Jacob, yimeng, “Ngabekkang kornkumo ngorrewoneng bimarneyimeng Nakokok Esau bu yimeng, ");
INSERT INTO gup_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kanmarnedjangka mayh dja kanmarnekinjemen namanjmak ngangun, ba ngaye marneyime kunmak kunwok kumirrk nuye Yawey, rerre wanjh ngawelengdowen.’ ");
INSERT INTO gup_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kunmekbe bimarneyimeng kornkumo ngorrewoneng, wanjh kunu ngayime ke Djedje, kanwokmarrkma kore ngaye wokrayekwon. ");
INSERT INTO gup_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Yiray kore mayh kadberre kamirnderri, dja kanmarneka bokenh goat yaw nawu namak, ba ngaye ngakinje namanjmak nuye kornkumo ke nawu nungan kahdjaredjare. ");
INSERT INTO gup_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Dja wanjh kaluk ngudda yimarnekan kornkumo ke kangun, ba ngunmarneyime kunmak kunwok, rerre wanjh kawelengdowen.” ");
INSERT INTO gup_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob bimarneyimeng Rebekah ngalbu ngalbadjan nuye, yimeng, “Aba, nawu ngardduk Kokok nawu Esau nungka namuddubbe, dja ngaye ngamudyak. ");
INSERT INTO gup_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Dja baleh bu kayime Ngabbard ngankukbekkan? Kunu wanjh nungka kayime ngahkowe, wanjh kunukka nungka ngandung, nganmarneyime kunyid kadjare ngardduk, dja minj kunmak kunwok nganmarneyime.” ");
INSERT INTO gup_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Wanjh ngalbadjan yimeng, “Djedje, bu yimankek ngunmarneyime kadjare kunyid ke, wanjh kunu nganmarneyimerra ngaye. Dja bonj, kandjalwokmarrkma, dja yiray yimka nawu mayh.” ");
INSERT INTO gup_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Wanjh Jacob wam mey nawu mayh bokenh benbenemkukkang kore ngalbadjan nuye, dja ngaleng kinjeng namanjmak nawu kornkumo nuye djarehdjareni. ");
INSERT INTO gup_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Wanjh Rebekah mey nawu namak duninjh kunmadj nuye Esau nawu nayawwernwarre ngalengngarre, mey namekbe kunmadj nawu ngaleng bihmadjkarrmi kumekbe kururrk kore yongohyoy, dja ngaleng bidjongbom nayawwalawalak ngalengngarre nawu Jacob. ");
INSERT INTO gup_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Dja mak bibiddukkang mayh kunkulah nawu goat dja kukom warridj. ");
INSERT INTO gup_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Wanjh bibidkenwong nayaw ngarre nawu Jacob namekbe namanjmak dja mak buriddi manbu ngaleng kinjeng. ");
INSERT INTO gup_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Nungka ngimeng kore kornkumo dja yimeng, “Ngabba.” Nungka yimeng, “Ayh! Ngudda yingale, Korlonj?” ");
INSERT INTO gup_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Wanjh Jacob bimarneyimeng kornkumo, yimeng, “Ngaye wanjh Esau nawu ngawernwarre ke. Ngakurduyimeng bu ngudda kanmarneyimeng. Yirrolkka wanjh yiwohngun yikahwi mayh ngardduk nawu ngahdjangkani, ba kanmarneyime kunmak kunwok ke.” ");
INSERT INTO gup_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac bidjawam beywurd, yimeng, “Njalekah bu werrkwerrk yidjalngalkeng Korlonj?” Jacob biwokmey, yimeng, “Yawey nawu God ke, nungka wanjh nganbidyikarrmeng, kamak rowk ngangalkeng.” ");
INSERT INTO gup_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Wanjh Isaac bimarneyimeng Jacob, yimeng, “Yimray darnkih ba bidbekkan Korlonj, ba kunu ngaburrbun ngudda woybukkih beywurd ngardduk nawu Esau, dja kunubewu nawid.” ");
INSERT INTO gup_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob wam darnkih kore kornkumo nuye Isaac, dja nungka bibidbekkang, wanjh marneyimerrinj, “Kamerlkyime yiman Jacob kunmerlk nuye, dja kabidyime yiman Esau kunbid nuye.” ");
INSERT INTO gup_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nungka minj biwernhkukburrkburrkbekkayi dja nungka kunbid nuye bidmudwernni yiman yerreh benedanginj nuye nawu Esau bidyihbidyimi, wanjh kunu nungka kaluk bimarneyimeng kunmak kunwok. ");
INSERT INTO gup_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Nungka bidjawam yimeng, “Yiddok ngudda woybukkih beywurd ngardduk nawu Esau?” Wanjh Jacob yimeng, “Yoh, wanjh ngaye.” ");
INSERT INTO gup_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Wanjh Isaac yimeng, “Korlonj, yimka yikahwi nawu mayh ke nawu yidjangkani, yimka ngangun ba marneyime kunmak kunwok nawu marnehmarnekarrme.” Jacob bimmarnekang dja nungka nguneng, dja bimmarnebokang wine dja bonguneng. ");
INSERT INTO gup_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Wanjh kornkumo nuye nawu Isaac bimarneyimeng, “Yimdarnhray darnkih Korlonj, ba kanbunjhmang.” ");
INSERT INTO gup_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Wanjh kunu nungka wam kore kornkumo dja bibunjhmey. Bu Isaac bimadjnomeng nungka bimarneyimeng kunmak kunwok, dja yimeng, “A, beywurd ngardduk kakukbanj yiman rerrih kabbal kabanj manbu Yawey marnekurduyimeng kunmak. ");
INSERT INTO gup_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ngadjare God ngunwon kunberle kaddumbeh kabolkkihwon kabbal ke, dja manme manwern duninjh kadjokodjordmen ke, manmim manwern ba yingun, dja mak manbowern wine manbu manbokerrnge yibongun. ");
INSERT INTO gup_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ngadjare birrimudbubuyika bininj ngundimarnedurrkmirri, dja mak nawu birribebbehmirndewern ngundimarneboddan. Ngadjare ngudda yibenmarnewohrnan nawu ngurrimud, dja nawu ngalbadjan ke kabenkebmakkahme ngundimarneboddan. Nawu kabirridjare kunyid ngundimarnemarnbun, wanjh ngadjare kunyid kabenmarnebebme bedberre, dja nawu kabirridjare kunmak ke, wanjh ngadjare kunmak kabenmarnebebme bedberre.” ");
INSERT INTO gup_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac yakwong kore bimarneyimi kunmak kunwok, dja nungka Jacob bibalhbawoni kornkumo, wanjh kundjalmekbe rerrih benedanginj nuye nawu Esau kumbebmeng kore mayh kumhdjangkanibeh. ");
INSERT INTO gup_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nungka warridj mayh kumkinjeng nawu namanjmak dja kumkang kore kornkumo nuye, wanjh bimarneyimeng, “Ngabba, yirrolkka dja yingun yikahwi nawu mayh ngardduk nawu ngahdjangkani, ba kunu kanmarneyime kunmak kunwok kore nguddahbeh.” ");
INSERT INTO gup_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Wanjh kornkumo nuye nawu Isaac bidjawam, yimeng, “Nangale ngudda?” Nungka biwokmey, yimeng, “Ngaye wanjh ngawernwarre Esau.” ");
INSERT INTO gup_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Wanjh Isaac deldehdeldelmi bulkkidj dja yimeng, “Nangale wanjh nawu djangkang mayh, dja kumkang kore ngaye? Ngaye nganguneng bu ngudda minj yimbangmebebmeninj dja ngamarneyimeng kunmak kunwok, dja bonj wanjh nungka woybukkih kunmak kayimerran nuye.” ");
INSERT INTO gup_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Bu Esau bibekkang kornkumo nuye kunwok, nungka kayhmeng wernkih duninjh kunmimnalk dorrengh, bu njilngwarreminj duninjh, dja bimarneyimeng kornkumo. “Ngaye warridj kanmarneyimen kunmak kunwok, Ngabba.” ");
INSERT INTO gup_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Dja nungka yimeng, “Nawu ngunedanginj kumwam ngankoweng dja ngunyirrurrkmey kunmak kunwok nawu marneyimeninj ngudda.” ");
INSERT INTO gup_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Wanjh Esau yimeng, “Nungka wanjh mandjad kangeyyo Jacob nawu kahkurren. Nungka bokenhkah ngankoweng. Kerrngehkenh nungka nganyirrurrkmey nawu ngarddukniwirrinj bu nawernwarrekenh, dja bolkkime nganyirrurrkmey bu kanmarneyimeninj kunmak kunwok.” Wanjh Esau bidjawam kornkumo, yimeng, “Minj nuk ngudda kanwohmarnekarrme bu ngaye kunmak kunwok kanmarneyime?” ");
INSERT INTO gup_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac biwokmey Esau, yimeng, “Yina, ngaye ngamarnbom nungka ngunmarnewohrnan, dja nawu ngurrimud rowk ngurrimarnedurrkmirri nungka, dja nungka ngawong manmim dja manbokerrnge wine ba kunmak rowk kani. Dja mak baleh ngaye ngakurduyime ke, Korlonj?” ");
INSERT INTO gup_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau bimarneyimeng kornkumo, yimeng, “Yiddok ngudda kundjalkudji kunmak kunwok yikarrme, Ngabba? Ngaye warridj kanmarneyimen kunmak kunwok, Ngabba.” Wanjh Esau nalkbom wernkih. ");
INSERT INTO gup_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Wanjh kornkumo nuye nawu Isaac biwokmey yimeng, “Yina, ngudda kaluk yini djarrehkah kore manme manwern kadjokodjordmen, dja mak djarrehkah kore kunberle kaddumbeh kabolkkihwon. ");
INSERT INTO gup_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Bu ngudda yimimbi wanjh mandjawak yikan yibenbunkenh, dja ngudda yimarnedurrkmirri nawu ngunedanginj. Dja kaluk bu yiwunjibmingalme, ngudda yiman rerrih yibakke nawu nungka ngunbongkarrme.” ");
INSERT INTO gup_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Wanjh Esau biwidnani Jacob bu nungka kornkumo bimarneyimeng kunmak kunwok. Dja Esau nungan baybaywi marneyimerrinj, “Ngokko darnkih Ngabbard karrowen karrimarnenjilngwarre, kunu wanjh ngabun ngakukkurrme nawu nganedanginj Jacob.” ");
INSERT INTO gup_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Bu Rebekah wobekkang bu kuhni yimeng nawu nayawwernwarre ngarre Esau, wanjh ngaleng bikayhmeng Jacob nawu nayawwalawalak ngalengngarre, dja bimarneyimeng, yimeng, “Yina, nawu ngunedanginj Esau, nungka wanjh kakangemarnburren bu kayime kaluk ngunbun ngunkukkurrme. ");
INSERT INTO gup_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Wanjh kunmekbekenh kunu Djedje, kanwokmarrkma, yirrolkka, yikelerlobmen kore ngaye nganedanginj Laban kore Haran. ");
INSERT INTO gup_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nungka ngunewohni bu kundedjdjumbungkenh, kaluk bu ngunedanginj kayidyakmen. ");
INSERT INTO gup_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Wanjh bu nungka nawu ngunedanginj kayidyakmen dja kabengmidjdan kore baleh ngudda yimarnekurduyimeng, wanjh kunu ngaye kunwok marnemunkewe ba yimdurndeng kumekbebeh. Dja njalekah yimankek bu kunbarnangarrakudji ngudda benbenedjarrkbalanhmang?” ");
INSERT INTO gup_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Wanjh Rebekah bimarneyimeng Isaac, yimeng, “Ngaye wanjh ngawarnyakminj bu ngamimbi bu bedda daluk birriwern ngalbu mawahmawah Heth nuye. Wanjh bu Jacob daluk kabimang kore birrimekbe daluk nawu yiman bedda, daluk nawu birrikang kondah kubolkwarlah, wanjh yiman yerreh ngadjaldjare ngarrowen.” ");
INSERT INTO gup_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kunu wanjh Isaac bikayhmeng Jacob dja bimarneyimeng kunmak kunwok, dja biwokrayekwong, yimeng, “Yuwn ngunemarren daluk ngalbu ngalkang kunbolk Canaan. ");
INSERT INTO gup_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yirrolkka, yiray kore kunred Paddan Aram kore kunrurrk nuye kornkumo ngarre ngalbadjan ke nawu Bethuel. Dja kumekbe yimang daluk ngunemarren, kaluk ngalbeywurd nuye Laban nawu badjan ke. ");
INSERT INTO gup_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ngadjare El Shaddaingunmarnekurduyime kunmak, dja mak ngunmarnbun bu yibenbornan birridjalwern, kaluk nawu yibenkebmawahme bininj kabirrimirndewern kore kabirrimudbubuyika kabirrihni. ");
INSERT INTO gup_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngadjare mak ngunwon ngudda dja nawu yibenkebmawahme, ngunwon kunmak nawu nuyeni Abraham, ba kunu ngudda ngurribolkkarrme kunred kubolkwarlah kore bolkkime karrihni, kore minj kadberrekih kunred, kaluk kunred nawu God bibolkberrebbom Abraham.” ");
INSERT INTO gup_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Wanjh Isaac bimunkeweng Jacob, dja nungka wam kore Paddan Aram, kore Laban beywurd nuye Bethuel nawu Aramean bininj, nawu nungka Laban benedanginj Rebekah, ngalbu ngalbadjan berrewoneng Jacob dja Esau. ");
INSERT INTO gup_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Kaluk Esau bekkang bu Isaac kunmak kunwok bimarneyimeng Jacob dja bimunkeweng kore Paddan Aram, ba kumekbe daluk kabimang kabenemarren, dja mak Esau bekkang bu Isaac kunmak kunwok bimarneyimeng Jacob, nungka biwokrayekwong dorrengh, yimeng, “Yuwn ngunemarren ngalbu daluk kore nawu Canaan benkebmawahmeng.” ");
INSERT INTO gup_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Dja mak nungka bekkang bu Jacob benbenewokmarrkmey kornkumo dja ngalbadjan, dja bu nungka wam kore Paddan Aram. ");
INSERT INTO gup_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Wanjh Esau bengdayhmeng bu daluk bokenh nuye ngalbu Canaanbeh wanjh benenjilngwarrewong kornkumo nuye nawu Isaac. ");
INSERT INTO gup_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kunu wanjh nungka Esau wam kore Ishmael nawu beywurd nuye Abraham, dja benemarrinj Mahalath ngalbu ngalbeywurd nuye Ishmael, dja benedanginj nawu Nebaioth. Esau wanjh bimey Mahalath dja benrawong ngalbibininjkobeng nawu ngokko benbenekarrmi. ");
INSERT INTO gup_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob bolkbawong Beersheba, dja wam bolkyikani Haran. ");
INSERT INTO gup_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nungka bebmeng kore kubolkkudji dja dungyibmeng, wanjh kunmekbekenh kunu nungka kumekbe yonginj. Nungka mey mankudji kunwardde manbu kumekbe yoy, dja kurrmeng kodjbahkodjbarndi, wanjh kumekbe kekurrmerrinj. ");
INSERT INTO gup_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Wanjh nungka bukirribom yiman stairs rerrih manbu balhrey kurorrebeh, djahdjalleywi kaddum heaven. Dja kumekbe angels nawu birrimarnedurrkmirri God wanjh birribalbidbuni dja birrimkolungi manmekbe stairs. ");
INSERT INTO gup_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Wanjh kaluk Yawey bimarnedanginj kungurrid nuye, dja nungka yimeng, “Ngaye wanjh Yawey nawu God nuye Abraham nawu Mawah ke, dja mak God nuye Isaac. Kondah kunred kore yihyo ngaye kaluk bolkwon ngudda dja nawu yibenkebmawahme. ");
INSERT INTO gup_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dja bedda nawu yibenkebmawahme kaluk kabirrimirndeyimerran yiman kundjulng rerrih kore kurorre, kabirrikaberrkwernmen kabirriyarlarrme, kabirribolkmang karrikad, koyek, dja kakbi, dja mak walem. Dja kore ngudda dja nawu yibenkebmawahme ngaye ngabenmarnekurduyime kunmak bedberre nawu birribebbehmudbubuyika rowk kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Dja kanbekka, marneyime, ngaye ngarrdjarrkre dja mak nahnan bu baleh yarrkka yire, dja mak kaluk durndiwe ngudda kondah kunred kubolkwarlah. Dja ngaye minj bawon, ngadjalkurduyime werrk nawu ngaye berrebbom ngudda.” ");
INSERT INTO gup_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Wanjh Jacob kodjkerrolkkang dja yimeng, “Woybukkih wanjh Yawey kani kondah dja ngaye minj ngayingkihburrbuyi.” ");
INSERT INTO gup_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wanjh nungka keleminj dja yimeng, “Kondah wanjh ngadjalbolkkengeme! Kondah kadjalbolkyime God nuye kunrurrk, dja mak kondah kururrkdangmaye ngarre kaddum heaven.” ");
INSERT INTO gup_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Wanjh kunmekbekenh kunu Jacob dolkkang bu kukabelbuyika dja mey manmekbe kunwardde kore kodjdihkodjdi, dja warddedjabnameng dja yakbom mankalkkid kore manmekbe kunwardde. ");
INSERT INTO gup_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nungka bolkngeykurrmeng kumekbe Bethel. Dja kerrngehkenhni kumekbe kunred bolkngeyyoy Luz. ");
INSERT INTO gup_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Wanjh Jacob wokkurrmerrinj kunwok kunrayek duninjh, yimeng, “Bu ngudda God ngarrdjarrkre, dja kannahnan kore yiman kunihbu ngahre, dja mak kanwon buriddi ngangun, kunmadj ngadjongburren, ba ngamdurndeng kore Ngabbard ngardduk nuye kunrurrk kunmodmikenh dorrengh, wanjh kunu ngudda nawu Yawey ngayime ngudda God ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Dja maninjmanu kunwardde manbu ngawarddedjabnameng, wanjh kayimerran ngudda God kunrurrk ke. Dja yehyeng rowk bu ngudda kanwon, bu yarrkka yiman ten kanwon, wanjh ngaye nakudji marnedurndiwe bu munguyh.” ");
INSERT INTO gup_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Wanjh Jacob dolkkang wanjh rengehrey dja bolkmey kubolkwarlah kore kabirrihni birrimudbubuyika bininj nawu birrikang koyek. ");
INSERT INTO gup_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Wanjh kumekbe kore kabbal nungka nang kunngad, dja kumekbe darnkih birriyoy birrimirndedanjbik nawu sheep, dja manmekbe kunngad bininj mayh birrimadbuni bindibowoyi. Wanjh kunmekbekenh kunu birrimekbe mayh birriyoy kumekbe. Kunwardde manbu birringadbalhmeng mahni kungad wanjh manwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dja berrebboyen bu kumirndebubuyika rowk nawu sheep bindimirndemornnamerrinj, wanjh bininj nawu birrinahnani sheep birriwarddedjirrkkayi, dja sheep birribowoyi. Wanjh kunmekbe birriwarddedurndiweng kore ngaddangbalhmeng. ");
INSERT INTO gup_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Wanjh Jacob bendjawam bininj nawu birrinahnani sheep kumekbe, yimeng, “Ngudda nawu karridabbolk, ngudda ngurrikang baleh?” Bedda birriyimeng, “Ngad ngarrikang kunbolk Haran.” ");
INSERT INTO gup_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Wanjh nungka yimeng bedberre, “Yiddok ngurriburrbun Laban nawu Nahor Mawah nuyeni?” “Yoh”, birriyimeng, “wanjh ngarriburrbun.” ");
INSERT INTO gup_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Wanjh Jacob bendjawam, yimeng, “Kaluk nungka kamak?” Wanjh bedda birriyimeng, “Yoh nungka kamak, dja yina, Rachel ngalbu ngalbeywurd nuye ngalih wanjh kamhre, kamhmirndekan sheep.” ");
INSERT INTO gup_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob yimeng, “Ngurrina, kaddum kahdjaldungdi, minj ngurribangmemirndemornname nawu sheep. Wanjh ngurrbenbowo dja ngurrimirndeka kabirridalkngun.” ");
INSERT INTO gup_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bedda birriyimeng, “Minj kunukka ngarribangmeyime, dja med ngarrimadbun mayh kumirndebubuyika rowk kabindimirndemornname, wanjh kunu ngarriwarddedjirrkkan manbu kahngaddangbalhmiyindi. Kumekbe wanjh sheep ngarrbenbowon kukku.” ");
INSERT INTO gup_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wanjh bu nungka djahdjalwokdi, Rachel bebmeng sheep dorrengh nawu kornkumo ngarre nuye, dja ngalengbu bennahnani. ");
INSERT INTO gup_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Wanjh bu Jacob binang Rachel ngalbu ngalbeywurd nuye Laban nawu badjan nuye, dja mak nang mayh nuye nawu sheep, Jacob wam warddedjirrkkang manmekbe kunwardde, dja benbowong mayh nawu nuye nawu Laban. ");
INSERT INTO gup_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Wanjh Jacob bibunjhmey Rachel dja nalkbom wernkih. ");
INSERT INTO gup_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Wanjh Jacob bimarneyimeng Rachel bu nungka nayaw nuye kornkumo ngarre, dja bu nungka wanjh nayaw ngarre Rebekah. Wanjh kunu ngaleng rlobmeng bimarneyimeng kornkumo. ");
INSERT INTO gup_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Wanjh kunmekbe rerrih bu Laban biwobekkang Jacob nawu nayaw nuye, nungka dokorrokmeng birrabkeng. Nungka biwanjbimey, bibunjhmey dja bimkang kore kururrk nuye, wanjh kumekbe Jacob yolyolmerrinj dja bimarneyimeng rowk. ");
INSERT INTO gup_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Wanjh Laban yimeng nuye, “Woybukkih ngudda wanjh yawmey duninjh.” Wanjh Jacob benehni bu dird nakudji. ");
INSERT INTO gup_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kaluk Laban bimarneyimeng Jacob, yimeng, “Bu ngudda ngarrmud minj nuk kunmekbekenh kanmarnedurrkmirri bu minj marnekarremulewan. Kanmarneyimen baleh yiyime karremulewan?” ");
INSERT INTO gup_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Wanjh Laban benbenekarrmi ngalbebeywurd bokenh. Ngalwernwarre wanjh ngeyyoy Leah, dja ngalwalawalak ngaleng wanjh ngeyyoy Rachel. ");
INSERT INTO gup_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah ngalmimwarreni dja Rachel ngalkukmakni dja ngalmakkaykenhni duninjh. ");
INSERT INTO gup_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob bimarnedjareni Rachel, wanjh yimeng, “Ngaye marnedurrkmirri seven mandjewk bu ngudda kanwon ngalbeywurd ke ngalwalawalak ngalbu Rachel.” ");
INSERT INTO gup_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban yimeng, “Kunwernhmak bu won ngudda, minj ngadjare ngawon nabuyika bininj, wanjh kondah yinin kore ngaye.” ");
INSERT INTO gup_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Wanjh kunu Jacob bimarnedurrkmirranginj bu mandjewk seven ba Rachel bimayi. Dja nungka bu bimarnedjareni Rachel bulkkidj, wanjh kunmekbekenh kunu nungka bekkarrinj bu yiman minj kunwern kunbarnangarra bu bimarnedurrkmirranginj. ");
INSERT INTO gup_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kaluk Jacob bimarneyimeng Laban, yimeng, “Kanwo daluk ngalbu ngardduk. Ngayakwong bu mandjewk seven marnedurrkmirranginj, dja ngadjare nganeyo.” ");
INSERT INTO gup_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Wanjh Laban benmirndemornnameng birriwern rowk nawu kumekbe kured birrini, dja mulil marnbom benwong. ");
INSERT INTO gup_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Dja bu ngokdanj nungka bikang ngalbeywurd nuye ngalbu Leah dja biwong Jacob, wanjh Jacob beneyonginj. ");
INSERT INTO gup_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Dja ngalkudji ngalbu bimarnedurrkmirri Laban ngalbu ngeyyoy Zilpah, ngaleng wanjh Laban biwong ngalbeywurd Leah kabimarnedurrkmirri. ");
INSERT INTO gup_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Wanjh yimankek bu barrhbom, kaluk Jacob bikuknang Leahni! Wanjh Jacob bimarneyimeng Laban, “Njale kuhni bu ngudda kanmarnekurduyimeng? Ngaye wanjh marnedurrkmirranginj bu Rachel ngamayi. Njalekah ngudda kankoweng?” ");
INSERT INTO gup_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban biwokmey, yimeng, “Minj kondah ngarriyime kakarremak bu ngalwalawalak werrk bininj kabimang, dja ngalwernwarre werrk kabimang bininj. ");
INSERT INTO gup_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Bonj wanjh, ngunedjalyuwn bu kunbarnangarra seven bu bimulilmang, wanjh kunu ngundiwon ngalbuyika warridj, bu kanyawoyhmarnedurrkmirri mandjewk seven.” ");
INSERT INTO gup_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Wanjh Jacob kodjdukmeng, nungka benehyoy Leah bu kunbarnangarra seven, wanjh Laban biwong ngalbeywurd nuye ngalbu Rachel ngalbininjkobeng nuye. ");
INSERT INTO gup_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ngalkudji ngalbu bimarnedurrkmirri Laban ngalbu ngeyyoy Bilhah, wanjh Laban biwong ngalbeywurd nuye Rachel kabimarnedurrkmirri. ");
INSERT INTO gup_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Wanjh Jacob benehyoy Rachel warridj, dja nungka biwernhmarnedjareni Rachel, dja Leah walakkih. Dja nungka biyawoyhmarnedurrkmirranginj Laban kunbuyika bu seven mandjewk. ");
INSERT INTO gup_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Bu Yawey binang Jacob minj bimarnedjareniwirrinj Leah, wanjh nungka bimarnbom kamak kayawkan, dja Rachel ngaleng ngalwalirrngwarreni. ");
INSERT INTO gup_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah yawkani dja yawmey narangem. Dja ngaleng yimeng, “Yawey nungka burrbom ngardduk bu kunnjilngwarre, dja woybukkih nuk wanjh nabininjkobeng ngardduk bolkkime nganmarnedjare bu kunmekbekenh.” Kunmekbekenh kunu bingeykurrmeng namekbe wurdyaw Reuben. ");
INSERT INTO gup_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kaluk yawoyhyawkani dja bu narangem bimarneyawdanginj, wanjh yimeng, “Bu Yawey bekkang bu minj Jacob nganmarnedjare, kunmekbekenh kunu namekbe warridj nganyawwong.” Kunu wanjh ngaleng bingeykurrmeng Simeon. ");
INSERT INTO gup_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Wanjh yawoyhyawkani, dja bu narangem bimarneyawdanginj, wanjh ngaleng yimeng, “Kaluk burrk wanjh nabininjkobeng ngardduk nuk nganbelbme, dja ngaye ngamarneyawmey danjbik bebeywurd.” Kunu wanjh ngaleng bingeykurrmeng Levi. ");
INSERT INTO gup_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Wanjh yawoyhyawkani dja bu bimarneyawdanginj narangem, ngaleng yimeng, “Kuninjkunu wanjh ngaburlume Yawey.” Kunu wanjh bingeykurrmeng Judah. Wanjh Leah ngurdmeng, minj yawoyhyawmayi. ");
INSERT INTO gup_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Bu Rachel narrinj bu ngaleng minj Jacob bimarneyawmayi wurdyaw, wanjh ngaleng kirnni bikirnweyi ngalbu benedanginj. Wanjh kunu bimarneyimeng Jacob, “Kanyawwo wurdwurd, dja bu burrkyak, wanjh ngarrowen.” ");
INSERT INTO gup_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Wanjh Jacob birruy, yimeng, “Yiddok ngaye yimankek yiyime God, nawu nungan ngunmarnbom minj yiyawmang?” ");
INSERT INTO gup_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Wanjh ngaleng yimeng, “Ngahli wanjh Bilhah ngalbu nganmarnedurrkmirri. Nguneyuwn ba ngaleng nganmarneyawmang, nawu kayawmang, wanjh namekbe ngaye ngardduk wurdyaw.” ");
INSERT INTO gup_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Wanjh kunmekbekenh kunu ngaleng biwong Bilhah ngalbu bimarnedurrkmirri, biwong Jacob bu ngalbininjkobeng yimerranj. Wanjh Jacob beneyonginj. ");
INSERT INTO gup_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Dja ngaleng yawkani bimarneyawmey Jacob beywurd. ");
INSERT INTO gup_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Wanjh Rachel yimeng, “God wanjh yiman ngandjadmeng, yimeng ngamak, nungka nganbekkang bu ngakebdjarrkmi dja nganyawwong narangem.” Kunmekbekenh kunu ngaleng bingeykurrmeng Dan. ");
INSERT INTO gup_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah ngalbu Rachel bimarnedurrkmirri wanjh yawoyhyawkani, dja bimarneyawmey Jacob nabuyika beywurd. ");
INSERT INTO gup_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Wanjh Rachel yimeng, “Ngaye yiman nganeyimarreni bulkkidj ngalbu nganedanginj, dja ngaye ngawinhmeng.” Wanjh kunu ngaleng bingeykurrmeng Naphtali. ");
INSERT INTO gup_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Bu Leah narrinj bu ngaleng ngurdmeng, minj kayawoyhyawmang, wanjh ngaleng bikang Zilpah ngalbu bimarnedurrkmirri, dja biwong Jacob kabeneyo. ");
INSERT INTO gup_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Wanjh Zilpah ngalbu Leah bimarnedurrkmirri, ngaleng wanjh bimarneyawmey Jacob beywurd. ");
INSERT INTO gup_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Wanjh Leah yimeng, “Kunukka wanjh kunmak.” Wanjh kunu ngaleng bingeykurrmeng Gad. ");
INSERT INTO gup_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpah ngalbu bimarnedurrkmirri Leah wanjh bimarneyawmey Jacob nabuyika beywurd. ");
INSERT INTO gup_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Wanjh Leah yimeng, “A! Ngadjalnjilngmak, morlehmorlenj kaluk kabirriyime bu ngaye nganjilngmak.” Wanjh kunu ngaleng bingeykurrmeng Asher. ");
INSERT INTO gup_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kaluk bolkyimi bu manmim wheat birrimimmoyhmangi, Reuben wam kore kabbal dja ngalkeng mankolhde manme manbu ngeyyoy mandrake, dja kumkang kore ngalbadjan Leah. Wanjh Rachel bimarneyimeng Leah, “Kab kanwo yikah manbu mandrake manbu nayaw ke ngalkeng.” ");
INSERT INTO gup_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Dja Leah bimarneyimeng, “Yiddok minj yiyime bonj bu kanyimey nabininjkobeng ngardduk? Yidjare yikan mandrake warridj manbu nayaw ngardduk ngalkeng?” Wanjh Rachel yimeng, “Kaluk kamak nguneyuwn Jacob kuninjkunu kumunun bu ngudda kanwon mandrake manbu nayaw ke ngalkeng.” ");
INSERT INTO gup_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Wanjh kunu bu Jacob kumbebmeng kabbalbeh bu wolewoleh, Leah wam birrabkeng, yimeng, “Ngudda bolkkime ngarryo, dja ngaye karremulewam ngaweykang mandrake manbu nayaw ngardduk ngalkeng.” Wanjh kunu beneyonginj bu kunmekbe kumunun. ");
INSERT INTO gup_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Wanjh God bibekkang Leah, dja yawkani, bimarneyawmey Jacob beywurd nabuyika nawu marnbom kunbidkudji ngalengngarre. ");
INSERT INTO gup_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Wanjh Leah yimeng, “God ngankarremulewam bu ngalbu nganmarnedurrkmirri ngawong nabininjkobeng ngardduk.” Wanjh kunu ngaleng bingeykurrmeng Issachar. ");
INSERT INTO gup_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah yawoyhyawkani, dja bimarneyawmey Jacob beywurd nabuyika nawu marnbom kunbidkudji dja nakudji ngalengngarre. ");
INSERT INTO gup_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Wanjh Leah yimeng, “God nganwong burudjang namakmak. Bolkkime wanjh nabininjkobeng ngardduk yiman ngankukenhme, kunmekbe kakurduyime bu ngaye ngamarneyawmey kunbidkudji dja nakudji bebeywurd.” Wanjh kunu ngaleng bingeykurrmeng Zebulun. ");
INSERT INTO gup_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kaluk rerrikah ngaleng yawmey ngaldaluk, dja bingeykurrmeng Dinah. ");
INSERT INTO gup_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Wanjh yerre God biburrbom Rachel bibekkang dja bimarnbom ba kamak kayawkan. ");
INSERT INTO gup_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Wanjh ngaleng yawkani, yawmey narangem dja yimeng, “God nganmarneyakwong bu bininj ngandiwarreweyi.” ");
INSERT INTO gup_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ngaleng bingeykurrmeng Joseph, wokkihyimi, “Ngadjare Yawey nganmarnerawon nabuyika narangem.” ");
INSERT INTO gup_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Wanjh bu Rachel biyawmey Joseph, kaluk yerrekah Jacob bimarneyimeng Laban, yimeng, “Kanmunkewemen ba ngarrurndeng kunred ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kanwo ngalbibininjkobeng ngardduk, dja mak wurdwurd nawu ngaye marnehmarnedurrkmirri beddakenh, dja kanmunkewemen ngare. Ngudda yiburrbun bu kunkimuk ngaye marnehmarnedurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Dja Laban bimarneyimeng, yimeng, “Bu ngudda nuk yiyime ngamak, yuwn yire, ngarrnin. Ngaye ngabolbmeng bu mankurdang nganmarneyimeng bu Yawey nganmarnekurduyimeng kunmak bu nguddakenh. ");
INSERT INTO gup_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Dja bu ngudda njale yidjare marnekarremulewan, wanjh yingeybu, won.” ");
INSERT INTO gup_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob yimeng, “Ngudda yiburrbun bu ngaye kamak marnehmarnedurrkmirri, dja bu mayh ke kamak rowk ngabennahnani. ");
INSERT INTO gup_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Bu ngaye minj ngambangmerawinj, wanjh minj ngudda yikarrmeninj nawern, dja bu ngaye dorrengh wanjh ngunmarnewernminj duninjh, dja Yawey ngunmarnekurduyimeng kunmak kore baleh yarrkka ngaye ngahrey. Dja kaluk baleh kayime bu ngaye ngabenmarnemang bedberre nawu ngaye ngardduk?” ");
INSERT INTO gup_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Wanjh Laban bidjawam, “Kaluk njale won?” Jacob biwokmey yimeng, “Yuwn njale kanwon, dja ngaye mayh ke ngabenyawoyhwon manme, dja ngabendjalnahnan bu kuhni kaluk kanmarnekurduyime. ");
INSERT INTO gup_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kanmunkewemen ngare bolkkime kore mayh ke kabirrihmirnderri, dja ngabenbebke rowk nawu mayh nawu birrimudbubuyika dja birrikukdjirlhdjirlmikenh, dja ngabenbebke rowk sheep yaw nawu birrikukbulerri, dja goat nawu birrikukdjirlhdjirlmikenh dja birrimudbubuyika. Bedda wanjh bu ngabenmang wanjh yikarremulewan ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Dja kaluk yinan bu ngawoybuk, bu ngudda yirohrokme nawu kankarremulewan. Bu yinan ngaye yimankek ngakarrme goat nawu minj mudbubuyika dja minj kukdjirlhdjirlmikenh, dja sheep yaw nawu minj kukburlerri, wanjh namekbe yiyime ngadjirdmey.” ");
INSERT INTO gup_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Wanjh Laban yimeng, “Mah, kunmekbe ngarrkurduyimen kore ngudda yimeng.” ");
INSERT INTO gup_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Madjamku kunmekbe yimeng Laban, dja kundjalmekbe kunbarnangarra Laban benbebkeng rowk goat narahrangem nawu birrikuklayirrhlayirrmikenh dja birrikukdjirlhdjirlmikenh, dja ngaldahdaluk nawu birrimudbubuyikani dja birrikukdjirlhdjirlmikenh, birriwern rowk nawu birriwohmudbeleni. Dja mak benbebkeng rowk birrikukbulerri sheep yaw, dja benwong bebeywurd nuye kabindinahnan. ");
INSERT INTO gup_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Dja bindikang djarreh duninjh bu kunbarnangarra danjbik, dja Jacob nungka djahdjalni kured bennahnani birrimirndebuyika nawu Laban nuye mayh. ");
INSERT INTO gup_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yiman djamku kuhni Laban kurduyimeng, dja Jacob nungka wanjh dulkberldjobkeng manbu karrulkngeyyo poplar, almond, dja plane kundulk, wanjh dulkmornihmorninjkurrmeng. ");
INSERT INTO gup_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Wanjh manmekbe kundulk rowk manbu dulkmornihmorninjkurrmi wanjh nungka dulkdjabdjabnameng kumirrk bedberre mayh, kore kukku borrahkendi bedberre mayh kore birrimrey birribonguni. Dja mayh bu birrimrey birribonguni wanjh kumekbe warridj birrimarreni. ");
INSERT INTO gup_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Wanjh kumekbe birrihdjalmarreni kore kurrulkmihmimirrk kore dulkdjahdulkdjabdjabdi. Dja kaluk yayaw bedberre nawu bindiyawmangi wanjh birrikuklayirrhlayirrmikenh, birrimudbubuyikani, dja birrikukdjirlhdjirlmikenh. ");
INSERT INTO gup_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob benlarlmey nawu yaw benkurrmeng bebbehbeh, dja mayh nawu mirndehmirnderri nungka benkebborledkeng birribalhbolknani kore Laban nuye mayh birrihmirnderri, nawu birrikuklayirrhlayirrmikenh dja birrikukbulerri. Dja wanjh nungka benkurrmeng mayh nuye bebbehbeh, minj bindirawoyi nawu Laban nuye. ");
INSERT INTO gup_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Dja yarrkka bu birriwernhngudjmak nawu ngaldahdaluk mayh bindihmangi, wanjh Jacob dulkdjabnami kore kukku borrahkendi birribonguni, kukok bedberre kundulk, ba kunu birrimarreni kore darnkih dulkdjabdjabdi. ");
INSERT INTO gup_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Dja bu nungka bennani birringudjwarreni myah, wanjh minj dulkdjabnameninj. Wanjh kunu nawu birringudjwarre mayh kaluk Laban nuye, dja nawu birringudjmak wanjh Jacob nuye. ");
INSERT INTO gup_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Wanjh bu kunmekbe kurduhkurduyimi Jacob wernhkukenminj duninjh, dja mayh mirndewernminj nuye nawu sheep dja goat, dja mak benkarrmi birriwern daluk dja bininj nawu birrimarnedurrkmirri, dja mak camel dja donkey. ");
INSERT INTO gup_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kaluk Jacob wobekkang bu Laban nuye bebeywurd birriyimi, “Jacob kang rowk nawu Ngabbard nuyeni, dja kore nawu Ngabbard nuyeni nungka kukenminj.” ");
INSERT INTO gup_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Dja mak Jacob nang bu Laban bimarnekebbumi, dja kerrngehkenhni kamakni. ");
INSERT INTO gup_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Wanjh Yawey bimarneyimeng Jacob, yimeng, “Yirrurnde kore kubolkwarlah bedberre nawu mawahmawah ke kore ngudda ngurrimud kabirrini, dja ngaye wanjh ngarrdjarrkre.” ");
INSERT INTO gup_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Wanjh Jacob benbenekayhmeng Rachel dja Leah kabenemre kore kabbal kore mayh nuye mirnderri. ");
INSERT INTO gup_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Dja nungka benbenemarneyimeng, “Ngaye nganan bu kornkumo ngorrewoneng nganhmarnekebbume dja kerrngehkenhni kamakni. Kunu bonj, dja God nawu Kornkumo ngardduk wanjh nganehdjarrkrey nganbidyikarrmeng. ");
INSERT INTO gup_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ngudda nguneburrbun bu ngaye ngamarnedurrkmirranginj kornkumo ngorrewoneng kunngudj dorrengh ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Dja kunu yiman djamku, dja nungka ngankoweyi, dja kunwernhkah borledkeyi nawu yimankek nganmarnekarremulewayi, dja God birrenghkeyi ba minj kunwarre nganmarnekurduyimeninj. ");
INSERT INTO gup_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Bu nungka yimeng, ‘Kaluk mayh nawu birrimudbubuyika wanjh ke bu karremulewan.’ Wanjh mayh rowk bindiyawmangi birrimudbubuyikani. Dja bu yimeng, ‘Kaluk mayh nawu birrikuklayirrhlayirrmikenh wanjh ke bu karremulewan.’ Wanjh mayh rowk bindiyawmangi birrikuklayirrhlayirrmiken. ");
INSERT INTO gup_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kunu God biyimey mayh rowk nawu nuyeni kornkumo ngorrewoneng, dja nganwong ngaye. ");
INSERT INTO gup_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Kaluk bolkyimi bu mayh bedberreni birrimarreni, ngaye ngabukirribom, ngawohnang nganang mayh nawu goat narahrangem nawu bindihmangi ngaldahdaluk wanjh birrikuklayirrhlayirrmikenh, birrimudbubuyikani dja birrikukdjirlhdjirlmikenh. ");
INSERT INTO gup_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Dja ngabekkang angel nuye God nganmarneyimeng bukirri, yimeng, ‘Jacob!’ Dja ngayimeng, ‘Ngaye konhda, bekkabekkan.’ ");
INSERT INTO gup_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Dja nungka yimeng, ‘Yiwohrna, dja yinan goat rowk nawu narahrangem nawu kabindimang ngaldahdaluk wanjh birrikuklayirrhlayirrmikenh, birrimudbubuyika, dja birrikukdjirlhdjirlmikenh. Kuhni ngakurduyime bu ngaye nganang rowk nawu Laban ngunhmarnekurduyimi. ");
INSERT INTO gup_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ngaye wanjh God, dja marnebebmeng kore kunred Bethel, kore ngudda mankalkkid oil yikalkkidyakbom kore kunwardde manbu yiwarddedjabnameng, dja kore ngudda kanmarnewokkurrmerrinj kunwok kunrayek duninjh. Mah. Wanjh yirrolkka yibolkbawo kondah kubolkwarlah, dja werrkwerrk yirrurndeng kore kubolkwarlah kore yirranginj.’” ");
INSERT INTO gup_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Bu Jacob kuhni benbenemarneyimeng wanjh Rachel dja Leah benewokmey beneyimeng, “Minj njale Ngabbard nganbeneyibawon. ");
INSERT INTO gup_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nungka wanjh nganbenemarnekurduyime yiman bu ngad nganewokbuyika! Nungka nganbenekukweykang dja warridj kahkukyakwon nawu mey bu nganbeneweykang. ");
INSERT INTO gup_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Yehyeng rowk nawu God biyimey Ngabbard, wanjh woybukkih yimerranj ngad ngadberre, dja mak wurdwurd dorrengh nawu ngadberre. Wanjh kunu bu baleh God ngunmarneyimeng, wanjh kunmekbe yikurduyimen.” ");
INSERT INTO gup_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Wanjh kunu Jacob dolkkang benkurrmeng wurdwurd nuye dja mak ngalbibininjkobeng kore camel birrimorneni. ");
INSERT INTO gup_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Dja nungka benmirndemunkeweng mayh nuye kabirrimarnedokme. Yehyeng rowk dorrengh nawu wernmerreni nuye kore Paddan Aram wanjh kang, dja birriwam birribolkyikani kore kornkumo nuye nawu Isaac kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Bu Laban wam benhmuddjobkeyi nawu sheep, wanjh Rachel djalmey wokyak nawu god nawern nuye kornkumo nawu yiwarrudj benmarnedi kore kururrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Dja warridj Jacob bikoweng Laban nawu Arameabeh bu nungka minj bimarneyimeninj kakelerlobme. ");
INSERT INTO gup_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nungka kelerlobmeng kang rowk yehyeng nawu nuye, wanjh dolkkang wam djowkkeng mankabo Euphrates dja djahdjalley balbolkyikani kore kurruluhdulum ngarre kabolkngeyyo Gilead. ");
INSERT INTO gup_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kaluk bu kunbarnangarra danjbik wanjh bininj birrimarneyimeng Laban bu Jacob kelerlobmeng. ");
INSERT INTO gup_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Wanjh nungka Laban benkang nawu birrimud dja bindingudjkadjuy bu kunbarnangarra seven, dja bindimarnebebmeng kore kurruluhdulum ngarre Gilead. ");
INSERT INTO gup_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Wanjh kumekbe kukak God bimarnebebmeng Laban nawu Aramean bininj, bimarnebebmeng bukirri dja bimarneyimeng, “Marndi yinahnarrimen, dja yuwn njale yimarneyime Jacob nawu kunmak dja kunwarre.” ");
INSERT INTO gup_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob wanjh dabburlin nuye nameng kore kunwarddekimuk ngarre kunbolk Gilead bu Laban bimarnebebmeng, dja Laban dja nawu birrimud birriyonginj kumekbe warridj. ");
INSERT INTO gup_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Wanjh Laban bimarneyimeng Jacob, yimeng, “Ngudda njale yikurduyimeng? Ngudda kankoweng dja yibenbenekang ngalbebeywurd ngardduk yiman rerrih nawu bininj kabindidukkan daluk kabindikan bu kabirriburren war. ");
INSERT INTO gup_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Njalekah ngudda manmolk yikelerlobmeng dja kankoweng? Njalekah minj kanmarneyimeninj ba kunu ngaye munkewemeninj bu karriwarnmakmeninj karriwayiniwirrinj bu birridoyi tambourine dja birribuyi lyre. ");
INSERT INTO gup_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Njalekah ngudda minj yibenbawoyi ngabenbunjhmayi ngabenwoknayi nawu ngabenkebmanjmeng dja ngalbebeywurd ngardduk? Ngudda kunu yikurduyimeng yiman yerreh yikodjkuluyak. ");
INSERT INTO gup_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ngaye wanjh ngakarrme kundulkarre bu marneyime kunwarre, dja bonj, God nawu kornkumo ke nuye wokdanj ngardduk kukak, yimeng, ‘Marndi yuwn njale yimarneyime Jacob nawu kunmak dja kunwarre.’ ");
INSERT INTO gup_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Bonj, ngaye ngaburrbun bu ngudda wanjh yibolkbawong bu ngudda yidjareni bulkkidj yirrurndeng kore kornkumo ke kani. Bonj kunu, dja njalekah yidjirdmey nayahwurd gods nawu ngardduk?” ");
INSERT INTO gup_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob biwokmey Laban, yimeng, “Ngaye ngamwam manmolk bu ngakeleni, dja ngaye ngayimeng bu ngudda kanyirrurrkmayi ngalbebeywurd ke. ");
INSERT INTO gup_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Dja bolkkime marneyime, bu yingalke nangale kakarrme gods ke, wanjh bonj namekbe kadjaldowen. Bu nawu ngad karrimud dorrengh kabirrinan wanjh kanbukka yehyeng nawu ngaye ngakarrme bu ngudda ke, dja yidjalka.” Kaluk Jacob nungka wakwani bu Rachel djirdmey namekbe nawu gods. ");
INSERT INTO gup_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Wanjh Laban ngimeng kore Jacob nuye dabburlin, dja Leah ngalengngarre, dja dabburlin berrewoneng benemekbe daluk bokenh nawu bindimarnedurrkmirri, dja minj kumekbe ngalkemeninj nawu god nuye. Wanjh nungka kumbebmeng kore Leah ngarre dabburlin dja ngimeng kore Rachel ngalengngarre. ");
INSERT INTO gup_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel wanjh korroko mey nawu gods nuye dja dahkendoy kore camel nuyeni baladji kubodmekenh, dja ngaleng wanjh ngerrehmeng. Bu kumekbe ni Laban wernhmadjyawani kore dabburlin rowk, dja minj ngalkemeninj. ");
INSERT INTO gup_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Dja Rachel bimarneyimeng kornkumo, yimeng, “Ngudda nawu yiwohrnan ngardduk, yuwn kandung bu minj marnedolkkan dja ngaye kunbodme ngarrowen.” Wanjh Laban benmadjyawam, dja minj ngalkemeninj namekbe nawu gods nuyeni nawu benmarnedi yiwarrudj kururrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Wanjh Jacob ngukwarreminj dja birruy Laban. Jacob yimeng, “Baleh yiddok ngayimeng? Njale yiddok kunwarre ngakurduyimeng ke bu rerre ngudda kanmunkekadjuy bu kanbuyi? ");
INSERT INTO gup_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ngudda wanjh kanmadjyawam rowk nawu ngahkarrme, njale yiddok yingalkeng nawu ke yehyeng? Wanjh yikurrmen kondah kore ngaye ngarrimud kabirrinan, dja mak ngudda ngurrimud, ba kunu bedda kandidjadme ngarrku, kabirriyime nangale kunwarre yimihyimi, kunubewu ngudda dja ngaye nuk. ");
INSERT INTO gup_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ngaye mandjewk twenty ngarrdjarrkni, dja sheep ke ngaldahdaluk dja mak goat minj bindimarneyawdowimeninj. Dja ngaye minj nganguyi nawu sheep narahrangem kore ngudda ke mayh mirndehmirnderri. ");
INSERT INTO gup_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Dja bu mayh nabang buni bikukdjalkdjalkmangi nawu ngudda ke, wanjh namekbe nawu mayh ke minj ngamkayi kore ngudda bukkayi, dja ngayeman ngakarremulewani. Dja ngudda kandjalyidjawani ngakarremulewani bu mayh bindidjirdmangi bu barnangarrakenh dja mak bu kukakkenh. ");
INSERT INTO gup_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kunih wanjh kunu ngakurduyimi, bu barnangarra wanjh ngarungi kundungbang dja bu kukak ngabonjdjekdoweni, dja mak minj ngawernhkeyuwirrinj. ");
INSERT INTO gup_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ngaye mandjewk twenty ngani kore ngudda ke kunrurrk. Ngaye mandjewk fourteen marnedurrkmirranginj bu ngalbebeywurd ke bokenh kanwongkenh, dja mak mandjewk six marnedurrkmirranginj bu mayhkenh nawu kekih kanwongkenh. Dja ngudda kunwernhkah yibuyikawoni nawu kankarremulewani. ");
INSERT INTO gup_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Bu God nawu Ngabbard nuye, nawu God nuyeni Abraham, dja nawu Isaac kabimarnekele, bu nungka minj nganbidyikarrmeninj, wanjh woybukkih ngudda kankukmunkewemeninj ngalarrkniwirrinj. God nang ngardduk kunmurrngrayek, dja bu ngawernhdurrkmirranginj, dja wanjh kukakni nungka ngunduy.” ");
INSERT INTO gup_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Wanjh Laban biwokmey Jacob, yimeng, “Bedda wanjh ngalbebeywurd ngardduk, dja wurdwurd wanjh ngabenkebmanjmeng, dja mayh wanjh ngardduk, yehyeng rowk nawu yihnan nakka wanjh ngardduk. Kunu bonj, dja njale yimankek bolkkime ngabenmarnekurduyime ngalbebeywurd ngardduk dja wurdwurd berrewoneng nawu bedda bindiyawmey? ");
INSERT INTO gup_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kuhni yina ngarryimen, wanjh ngarrwokmarnburren ngudda dja ngaye, ba kanmulewan ngarrku.” ");
INSERT INTO gup_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Wanjh Jacob mey kunwardde dja warddedjabnameng. ");
INSERT INTO gup_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Dja benmarneyimeng nawu birrimud nuye, “Ngurriwarddemoyhma.” Wanjh bedda birrimey kunwardde dja birridulminjameng kukudji, dja kumekbe darnkih birringuneng manme. ");
INSERT INTO gup_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban dja Jacob benebebbehwarddengeykurrmeng. Laban nuye kunwok wanjh “Jegar Sahadutha”. Dja bu Jacob nuye kunwok wanjh “Galeed”. ");
INSERT INTO gup_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban yimeng, “Maninjmanu manbu birridulminjameng kunwardde wanjh bolkkime kanmulewan ngudda dja ngaye.” Kunmekbekenh kunu warddengeykurrmeng Galeed. ");
INSERT INTO gup_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Dja mak warddengeykurrmeng Mizpah. Kunmekbe warddengeykurrmeng bu yimeng, “Ngadjare Yawey kanbebbehnahnan bu ngudda dja ngaye kore ngarrhbebbehni. ");
INSERT INTO gup_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Bu kunubewu ngudda kunwarre yibenbenemarnekurduyime ngalbebeywurd ngardduk, dja kunbuyika bu ngudda yibenmang dalukbubuyika yibenrawon ngalbebeywurd ngardduk, madjamku minj nangale karrini kannan ngarrku, yiburrbu God kannan bu ngudda dja ngaye.” ");
INSERT INTO gup_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Mak Laban bimarneyimeng Jacob, yimeng, “Yina, maninjmanu manbu kunwardde birridulminjameng dja mak manbu kawarddedjabdi bu ngaye ngawarddenameng kubulkayh ngarrku. ");
INSERT INTO gup_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Maninjmanu manbu kunwardde birridulminjameng wanjh kanmulewan, dja maninjmanu manbu kawarddedjabdi wanjh kanmulewan bu maninjmanu kunwardde manbu birridulminjameng ngaye minj ngawarddeyurrhke ngamre kore ngudda, dja ngudda minj yimwarddeyurrhke maninjmanu kunwardde manbu birridulminjameng dja manbu kawarddedjabdi, minj yimre kore ngaye bu kunwarrekenh ngarrmarneyimerren. ");
INSERT INTO gup_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nawu God nuyeni Abraham dja nuyeni Nahor, nawu God nuyeni kornkumo berrewonengni, kandjadme ngarrku.” Wanjh kunu Jacob wokkurrmerrinj kunwok kunrayek duninjh, kunngey dorrengh God nawu kornkumo nuye nawu Isaac bimarnekeleni. ");
INSERT INTO gup_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Dja Jacob kinjeng mayh God nuye bu yiwarrudj di kumekbe kore kuwarddekimuk, dja benkayhmeng nawu birrimud kabirringun, wanjh birringuneng dja kumekbe birrini bu kukakkuyeng kore kuwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Wanjh bu kukabel Laban dolkkang benbunjhmey nawu benkebmanjmeng dja ngalbebeywurd nuye, dja benmarneyimeng kunmak kunwok, wanjh kunu nungka benbawong dja dokmeng kured. ");
INSERT INTO gup_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Wanjh Jacob djahdjalley, dja angel nuye God birridabkeng. ");
INSERT INTO gup_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Bu Jacob bennang nungka yimeng, “Nanih wanjh God nuye bininj nawu kabirriburrenkenh.” Kunmekbekenh kunu nungka bolkngeykurrmeng kunmekbe kunred Mahanaim. ");
INSERT INTO gup_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob benyingkihmunkeweng bininj nuye kunwok kabirriyingkihyirrokme kabirrimarnekan nuye Esau nawu benedanginj nuye kore kunred Seir, kumekbe kubolkwarlah bolkngeyyoy warridj Edom. ");
INSERT INTO gup_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jacob benwokrayekwong birrimekbe bininj nawu benmunkeweng, yimeng, “Kuhni wanjh ngurrimarneyimen Esau nawu yiman nganmarnewohrnan, ngurriyimen, ‘Kuhni wanjh ngunmarneyime Jacob nawu yiman namarladj, kayime ke, “Ngaye ngadjalni kore Laban, kumekbe ngahdjalni munguyh, bolkkime ngambolkbawong. ");
INSERT INTO gup_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Dja ngabenkarrme bulikki, donkey, sheep, dja goat, dja bininj daluk nawu ngandimarnedurrkmirri, dja wanjh ngaye ngamunkewe kuhni kunwok ngudda marneyime nawu kanmarnewohrnan, ba kunu ngudda kunubewu yiyime ngamak.”’ Kuhni bu ngurrimarneyime nawu Esau.” ");
INSERT INTO gup_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kaluk birrimekbe bininj nawu Jacob benmunkeweng wanjh birrimmarnedurndi Jacob dja birriyimeng, “Ngad ngarriwam kore ngunedanginj nawu Esau, dja nungka wanjh kamhre ngunhdabke, dja 400 bininj kabirrimdjarrkre.” ");
INSERT INTO gup_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob wanjh keleni duninjh dja mak kangewarreni duninjh, wanjh kunu nungka benlarlmey bininj rowk nawu birridjarrkrey benmarnbom mirndebokenh. Dja mak sheep, goat, bulikki, camel, mirndelahlarlmey warridj. ");
INSERT INTO gup_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Dja nungka burrbom baybaywi, yimeng, “Bu Esau kunubewu kamre kabenbun kabenyakwon nawu birrimirndekudji, wanjh kunubewu birrimirndebuyika kabirrikelerlobme.” ");
INSERT INTO gup_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Wanjh Jacob danginj yiwarrudj yimeng, “Ngudda nawu God nuyeni Mawah ngardduk nawu Abraham, dja mak God nuye Ngabbard Isaac, ngudda Yawey nawu kanmarneyimeng ngarrurndeng kore kubolkwarlah ngardduk dja nawu ngarrimud, dja ngudda kunmak kanmarnekurduyime. ");
INSERT INTO gup_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ngaye wanjh ngawarre, minj ngamak bu ngudda kankongibuni kanmarnekurduyimi kunmak, kanburrbuni munguyh kannahnani. Dja bu ngamdjowkkeng manih mankabo Jordan ngadjalkarrmi kunkarndudjwi, dja bolkkime wanjh ngayimerranj nganemirndebokenh. ");
INSERT INTO gup_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ngaye djawan kanbebkemen kore kunbid nuye nawu nganedanginj Esau, dja ngakengeme, marndi nungka nuk kamre kanbun, dja ngalbabadjan warridj wurdwurd dorrengh. ");
INSERT INTO gup_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Dja ngudda yiyimeng bu ngudda kanmarnekurduyime kunmak, dja yibenmirndewernwon nawu ngaye ngabenkebmawahme, kabirrimirndeyimerran yiman kunkayalanj kamirndeyime kore kurrula kurrid, nawu minj nangale kamirnderohrokme dja manmirndewern.” ");
INSERT INTO gup_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","16","Wanjh Jacob kumekbe yonginj bu kukak, dja kore nungka karrmi nungka djarrngbom nawu kabiwon Esau burudjang; 200 goats ngaldahdaluk, twenty goats narahrangem, 200 sheep ngaldahdaluk, twenty sheep narahrangem, thirty camels ngalbabadjan, dja yayaw bedberre, forty bulikki ngaldahdaluk, ten bulikki narahrangem, twenty donkeys ngaldahdaluk, dja ten donkeys narahrangem. Nungka benwong kabindinahnan bininj nuye nawu birrimarnedurrkmirri, mirndebubuyika kabindibebbehmirndenahnan. Wanjh nungka benmarneyimeng bininj nuye nawu birrimarnedurrkmirri, yimeng, “Ngurriyingkihdokmen, mirndekudji karrokme, wanjh djarrehkahwurd mirndebuyika, dja djarrehkahwurd mirndebuyika, bu munguyh.” ");
INSERT INTO gup_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Wanjh nungka biwokrayekwong nawu dokmidokmi, yimeng, “Bu ngaye nganedanginj Esau ngundabke dja ngundjawan, ‘Ngudda nangale ngunmarnewohrnan, dja baleh yire, dja nangale nuye nanih nawu mayh nawu kahdokme?’ ");
INSERT INTO gup_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Wanjh kunukka ngudda yiyime, ‘Bedda wanjh Jacob nuye nawu namarladj. Nungka wanjh ngunwon burudjang bu ngunmarnemunkeweng, ngudda nawu Esau nawu kanmarnewohrnan, dja warridj nungka kamre rerre.’” ");
INSERT INTO gup_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Dja Jacob benwokrayekwong nayungkih, yerre, wohbulkayh, dja yerre duninjh, kaluk birribuyika rowk nawu bindimirndekadjungi mayh, benmarneyimeng, “Ngudda kunkudjiwi ngurrimarneyimen Esau bu ngurridabke. ");
INSERT INTO gup_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Dja mak yuwn ngurribengmidjdan dja ngurriyimen nuye, ‘Jacob nawu namarladj nungka wanjh yerre kamre warridj.’” Kuhni Jacob yimeng bu nungka burrbom baybaywi, yimeng, “Ngaye kunubewu nganjilngmarnbun, bu ngamunkewe nawu ngawon burudjang ngayingkihdokmihwe, wanjh yerre bu nganan, wanjh kunubewu kamak rowk ngankimang.” ");
INSERT INTO gup_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Wanjh kunu nawu Jacob kabiwon Esau wanjh yingkihdokmihweng, dja nungan wanjh kumekbe yonginj kured bu kukak. ");
INSERT INTO gup_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Wanjh bu kundjalmekbe kumunun, Jacob dolkkang benkang ngalbibininjkobeng nuye nawu benebokenh, dja daluk benebokenh nawu benemarnedurrkmirri, dja bebeywurd nuye nawu eleven, dja bedda birridjowkkeng mankabo Jabbok. ");
INSERT INTO gup_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Nungka benmey dja benmunkeweng birridjowkkeng mankabo, dja mak yehyeng nuye nawu karrmi warridj nungka munkeweng. ");
INSERT INTO gup_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Wanjh Jacob nungka djahdjalni nakudjihkudji, dja wanjh nabuyika bininj bimarnebebmeng, wanjh benehdjalkommarreni kunkakkuyeng munguyh kore kumbarrhbom. ");
INSERT INTO gup_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Bu namekbe bininj narrinj bu nungka minj biburriwemeninj Jacob, nungka bibom kungadmo dja bingadmoyirrhmey bu benekommarreni. ");
INSERT INTO gup_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Wanjh nungka nawu bininj yimeng, “Kanbawo ngare dja kumbarrhbom.” Dja Jacob yimeng, “Minj bawon yire, bu minj kanmarneyime kunmak kunwok.” ");
INSERT INTO gup_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Dja nawu bininj yimeng, “Ngudda baleh yingeyyo?” Dja nungka yimeng, “Jacob.” ");
INSERT INTO gup_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Wanjh nawu bininj yimeng, “Minj munguyh yingeyyo Jacob, dja Israel yidjalngeyyo, kunmekbe yingeyyo bu ngudda ngunedurrkmarreni God, dja bininj ngurridurrkmarreni, dja ngudda yiwinhmeng.” ");
INSERT INTO gup_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Wanjh Jacob bidjawam, yimeng, “Kab ngadjare kanmarneyime, baleh yingeyyo?” Dja nungka yimeng, “Njalekah kandjawan bu baleh ngangeyyo?” Wanjh kunmekbe nungka bimarneyimeng kunmak kunwok. ");
INSERT INTO gup_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Wanjh Jacob bolkngeykurrmeng kunmekbe kunred Peniel, wokkihyimi, “Kunmekbe ngabolkngeykurrme bu ngaye nganang God kukeb dja nganbawong ngarrarrkid.” ");
INSERT INTO gup_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Wanjh kumdungbebmeng bu nungka bolkyurrhkeng Peniel, nungka burriwarreminj dja kunngadmo biwarrewoni. ");
INSERT INTO gup_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kunmekbekenh kunu bininj nawu Israel benkebmawahmeng djalmunguyh minj kabirringun kunngadmokanj kore kangadmodjinhdjinduluburren, dja kumekbe bininj Jacob bibom. ");
INSERT INTO gup_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Wanjh Jacob bolknang dja nang kaluk Esau kamhre, dja 400 bininj dorrengh. Wanjh kunu nungka benlarlmey wurdwurd, dja Leah, Rachel, dja daluk benebokenh nawu bindimarnedurrkmirri, bindibebbehkarrmi wurdwurd. ");
INSERT INTO gup_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nungka bendokmiweng daluk nawu bindimarnedurrkmirri dja wurdwurd berrewoneng, wanjh Leahwali dja wurdwurd ngalengngarre benkurrmeng yerrekah, dja yerre duninjh benbenekurrmeng Rachel dja Joseph. ");
INSERT INTO gup_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Dja nungka naweleng wanjh dokmi dja balwohboddaboddangeni kurorre kunwernhkah seven, bu nungka balhbebmi kore nawu benedanginj. ");
INSERT INTO gup_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Dja Esau nungka rlobmeng birrabkeng, berlwakbom biwanjbimey, bibunjhmey, wanjh benemarnenalkburrinj. ");
INSERT INTO gup_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Wanjh Esau balwohnang bennang daluk dja wurdwurd, wanjh bidjawam Jacob, yimeng, “Birringale nanih nawu ngurridjarrkre?” Jacob biwokmey, yimeng, “Bedda wanjh wurdwurd nawu God burudjang nganwong ngaye nawu ngamarladj.” ");
INSERT INTO gup_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Wanjh daluk nawu bindimarnedurrkmirri dja wurdwurd berrewoneng birrimwam dja birrimarneboddanj. ");
INSERT INTO gup_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Wanjh Leahwali dja wurdwurd ngalengngarre birrimwam birrimarneboddanj. Wanjh yerre duninjh benemwam Joseph dja Rachel, dja bedda warridj benemarneboddanj. ");
INSERT INTO gup_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau bidjawam, “Dja njalekenh nawu birrimirndebubuyika mayh nawu ngabennang?” Wanjh Jacob yimeng, “Ngabenmunkeweng ba ngudda kunubewu yiyime ngamak ngudda nawu kanmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Dja Esau yimeng, “Ngaye ngokko ngakarrme nawern, ngudda nawu ngarrdanginj. Nawu yikarrme, wanjh yidjalkarrmen yingan ke.” ");
INSERT INTO gup_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Wanjh Jacob yimeng, “Burrkyak, ngaye kebdjarrkme, bu ngudda yiyime yimankek ngamak, wanjh kanbidyima nawu ngaye won burudjang. Dja woybukkih ngaye bu kebnan wanjh yiman rerrih God ngakebnan, bu ngudda kamak rowk kankimey. ");
INSERT INTO gup_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","God nungka kunmak nganmarnekurduyimeng burudjang, dja nawu ngakarrme wanjh bonj nawern, kunmekbekenh kunu ngaye kebdjarrkme, kanbidyima nawu ngaye marnemunkeweng won burudjang.” Wanjh kuhni nungka bimarneyimi kebbabiminj, wanjh kaluk Esau nungka biyimey. ");
INSERT INTO gup_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Wanjh Esau yimeng, “Kab karridjarrkray dja ngaye mak.” ");
INSERT INTO gup_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Dja Jacob bimarneyimeng, “Ngudda nawu kanmarnewohrnan, yiburrbun bu wurdwurd birringudjwarre, dja ngabennahnan sheep, goat, dja bulikki nawu kabindiyawdjikkawon. Bu yimankek bu kunbarnangarrakudji ngabendjirrkkan wernkih, wardi mayh kabirridowerren rowk. ");
INSERT INTO gup_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Wanjh kunu ngudda nawu kanmarnewohrnan kanmarneyingkihdokmen ngaye nawu ngamarladj, dja ngaye yeledj ngamdjalle yiman mayh kabirrire nawu ngabendjirrkkan, dja mak yiman bu wurdwurd yeledj kabirrire, kunmekbe ngayime munguyh, kaluk marnebebme ngudda nawu kanmarnewohrnan, kore kunred Seir marnebebme.” ");
INSERT INTO gup_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Wanjh Esau yimeng, “Wanjh yiyimen kamak ngabenbawon ngurridjarrkre yikahwi nawu bininj ngardduk nawu ngarridjarrkre.” Dja Jacob yimeng, “Njalekah yimankek kunmekbe yikurduyime? Ngadjaldjare ngudda yiyime ngaye ngamak, ngudda nawu kanmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Wanjh kunu Esau dolkkang kunmekbe kunbarnangarra, baldjaldurndi kore kunred Seir. ");
INSERT INTO gup_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Dja yiman djamku Jacob yimeng rawinj kore Seir, dja nungka barlungmeng wam kore kunred Succoth, dja kumekbe nungka rurrknameng kunrurrk nuye dja djurlenameng bedberre mayh. Kunmekbekenh kunu kabolkngeyyo Succoth. ");
INSERT INTO gup_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Wanjh kaluk Jacob bu kumhrey Paddan Arambeh nungka kaluk bebmeng kamak rowk kore kubolkkimuk Shechem kore kubolkwarlah Canaan, dja nungka birriyoy darnkih kore kubolkkimuk. ");
INSERT INTO gup_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dja Jacob karremulewam kunred kore dabburlin nuye nameng, kunwardde 100 silver benwong bebeywurd nuye Hamor nawu kornkumo nuye Shechem bu birribolkweykang. ");
INSERT INTO gup_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Wanjh kumekbe Jacob marnbom kunwardde yiwarrudjkenh dja nungka warddengeykurrmeng, “God, nawu God nuye Israel.” ");
INSERT INTO gup_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Kaluk Dinah ngalbu ngalyaw ngarre Leah ngalbu bimarneyawmey Jacob, wanjh Dinah wam kabennan morlehmorlenj ngalbu birrihni kumekbe kunred. ");
INSERT INTO gup_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kaluk Shechem nawu beywurd nuye Hamor nawu namud Hiv, nawu nungka benmarnewohrnani bininj kumekbe, wanjh bu nungka binang Dinah, wanjh bidjaldarrkidmey beneyonginj. ");
INSERT INTO gup_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Wanjh nungka bulkkidj bimarnedjareni bikangebakkeng Dinah ngalbu ngalbeywurd nuye Jacob, wanjh nungka bimarnedjareni ngalmekbe ngalyawk dja kunwok kunkerlh bimarneyimeng. ");
INSERT INTO gup_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Wanjh Shechem bimarneyimeng kornkumo nuye nawu Hamor, yimeng, “Kanmarnema ngalbu ngalyawk ba nganemarren ngamarnbun ngalbininjkobeng ngardduk.” ");
INSERT INTO gup_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Bu Jacob bekkang bu ngalbeywurd nuye, bininj bimarneyimeng kunwarre, wanjh nungka nuye bebeywurd birrini kuberrk kore kabbal birrinahnani mayh nuye, wanjh kunu Jacob djalngurdmeng, minj baleh bangmeyimeninj, nungka benmadbuni bebeywurd kabirrimdokme kured. ");
INSERT INTO gup_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Wanjh Hamor nawu Shechem nuye kornkumo nungka wanjh wam kabenewokdi Jacob. ");
INSERT INTO gup_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kaluk Jacob nuye bebeywurd bedda wanjh bu birriwobekkang baleh yimerranj, wanjh birrimbebmeng kabbalbeh. Dja bedda birrikangewarreni duninjh, dja mak birriyidduy duninjh, bu Shechem kurduyimeng bininj nawu Israel benkebmawahmeng kabirriyime kunwarre duninjh birriyemikarrinj, bu nungka beneyonginj Jacob nuye ngalbeywurd, kunu wanjh nawu kunwarre birriyimi minj nangale kurduyimeninj. ");
INSERT INTO gup_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Dja Hamor benmarneyimeng, yimeng, “Nawu beywurd ngardduk Shechem, nungka kabidjalmarnedjare ngalbu ngudda ngurridanginj. Ngaye djawan ngudberre bu ngurriwon kabenemarren kayimerran ngalbininjkobeng nuye. ");
INSERT INTO gup_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kamak nuk karriworren daluk, ngudda kandiwo ngarrimarren ngudberre ngalbebeywurd, dja ngadmanwali ngalbebeywurd ngadberre ngurrimarren. ");
INSERT INTO gup_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ngudda kamak ngurrini kore ngad, dja ngudda kamak ngurrimre kore kubolkwarlah ngadberre, ngurrini, dja ngurrikarremulewan ngurrimang yehyeng, mak ngurriweykan kondah kore ngadberre kunred kubolkwarlah, dja kaluk kamyawoyhwernworren ngudberre.” ");
INSERT INTO gup_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Wanjh Shechem warridj wokdi, dja benmarneyimeng nawu Dinah ngarre kornkumo dja birridanginj, yimeng, “Ngaye ngadjare ngurriyime nuk ngamak, dja ngaye won bu baleh kandiyidjawan, ngudda ngurriyime bu ngaye won ngudberre dalukkenh ngamang. Bu ngurringeybun nakimuk duninjh won ngudberre, wanjh ngaye won nawu baleh ngudda kandiyidjawan, dja kandidjalwo ngalbu ngalyawk ba nganemarren.” ");
INSERT INTO gup_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wanjh bu ngaldaluk bedberre Dinah kunwarre nungka bimarneyimeng, wanjh kunmekbekenh kunu bedda nawu Jacob nuye bebeywurd bu bindiwokmey Shechem dja kornkumo nuye nawu Hamor, bedda wanjh bindikoweng, ");
INSERT INTO gup_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","bindimarneyimeng, “Kunukka minj ngad ngarrikurduyime, minj ngarriwon ngalbu ngarridanginj kore bininj nawu minj birrilakkayenwoyi. Kunukka wanjh ngarriyime kundjalwarre duninjh ngarriyemikarren. ");
INSERT INTO gup_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ngad ngarriyime kamak ngunemarren bu kuhni kundjalkudji ngurriyime, bu ngudda ngurriyimerran yiman ngad, dja ngurrilakkayenworren rowk nawu narahrangem rowk ngudberre. ");
INSERT INTO gup_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Bu kunmekbe ngurrikurduyime wanjh ngad biwon ngudberre ngalbebeywurd ngadberre, dja ngarrimang ngalbebeywurd ngudberre ngarrimarren. Wanjh ngarribolkmarnbun ngarrini kore ngudda dja karriyimerran yiman karrikudjiwi. ");
INSERT INTO gup_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Dja bu ngudda minj ngurrikodjdukme ngurrilakkayenworrenkenh, wanjh kunu ngad ngarrikan ngalbu ngarridanginj dja ngarrire.” ");
INSERT INTO gup_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Wanjh nawu bedda birrikarremarnbom berrewoneng Hamor dja beywurd nuye nawu Shechem, wanjh bedda benebekkarrinj kamak rowk. ");
INSERT INTO gup_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Wanjh namekbe nawu yawurrinj bimarnedjareni Jacob nuye ngalbeywurd, wanjh kunu nungka djalwam werrkwerrk, kakurduyime nawu bedda birrimarneyimeng. Dja nungka wanjh nawernhkuken kore nawu birrimud. ");
INSERT INTO gup_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Wanjh kunu Hamor dja Shechem nawu beywurd nuye benewam kore kururrkdangmaye kore kumekbe kubolkkimuk dja birriwokdi bininj rowk nawu birridjarrkni kumekbe kubolkkimuk. ");
INSERT INTO gup_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Wanjh bedda beneyimeng, “Nahni nawu bininj kabirridjare karridabbolkmen, kab ngurriyimen kamak kabirrini kore kubolkwarlah kadberre, kabirrikarremulewan kabirrimang yehyeng mak kabirriweykan. Ngurrina, kondah bu kabolkwarlah, bedda kamak kabirrini. Ngad wanjh karrbenmang ngalbebeywurd bedberre, dja bedda kabindimang ngalbebeywurd kadberre. ");
INSERT INTO gup_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Dja bedda nawu bininj kabirrikodjdukme karridjarrkni yiman karrikudjiwi, bu kuhni karridjalkurduyime, narahrangem rowk ngad kadberre wanjh karrilakkayenworren yiman bu bedda rerrih. ");
INSERT INTO gup_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Minj nuk ngurrinan bu bulikki bedberre, dja yehyeng nawu kabirrikarrme, dja mayhbubuyika bedberre warridj, wanjh nahni rowk kayimerran ngad kadberre? Wanjh kunu karrbenmarnekodjdukmen dja kabirribolkmarnbun kore ngad karridjarrkni.” ");
INSERT INTO gup_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bininj rowk nawu birrimirndemornnamerrinj kore kumekbe kururrkdangmaye, wanjh bindimarnekodjdukmeng Hamor dja beywurd nuye nawu Shechem. Wanjh narahrangem rowk nawu birrihni kumekbe kubolkkimuk wanjh birrilakkayenworrinj. ");
INSERT INTO gup_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Bu kunbarnangarra danjbik bu bedda birridjakbekkani rowk, benebokenh nawu Jacob nuye bebeywurd, kaluk Simeon dja Levi nawu Dinah birridanginj, bedda wanjh benemey mandjawakkuyeng berrewoneng, dja benemwam kore kumekbe kubolkkimuk bu minj njale bedda birriburrbuyi, dja bindidulubom bindikukkurrmeng narahrangem rowk. ");
INSERT INTO gup_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Bindidulubom mandjawak, kaluk bedda dorrengh Hamor dja beywurd nuye nawu Shechem, dja benemey Dinah kore ngaleng ni kore Shechem nuyeni kunrurrk dja birriwam. ");
INSERT INTO gup_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Nawu birribuyika Jacob nuye bebeywurd bindimarnebebmeng nawu birrikukyoy, dja bedda birrikang yehyeng nawu birringalkeng kore kumekbe kubolkkimuk. Kunmekbe birriyimeng bu bininj bimarneyimeng kunwarre ngalbu bedda birridanginj. ");
INSERT INTO gup_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bedda birrikang sheep, goat, bulikki, dja donkey, dja mak yehyeng warridj nawu bedberre kore kubolkkimuk, dja mak kore kabbal. ");
INSERT INTO gup_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bedda wanjh birrikang rowk nawu namakmak bedberre, dja daluk rowk warridj bindidukkang bindikang, dja mak wurdwurd bedberre, dja birrikang yehyeng kore kunrurrk bedberre. ");
INSERT INTO gup_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Wanjh Jacob benbenemarneyimeng Simeon dja Levi, “Ngudda wanjh kunyid ngunemarnbom ngardduk, dja bininj nawu birrimdolkkang Canaan dja bininj nawu Periz benkebmawahmeng, nawu kabirrini kondah kubolkwarlah, bedda wanjh kaluk ngandiwidnan. Ngaye minj birriwern ngabenkarrme, dja bu bedda kabirriraworren kandidabke kandibunkenh, ngaye dja ngardduk bininj karridowen.” ");
INSERT INTO gup_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Dja bedda benewokmey beneyimeng, “Yiddok yiyime bonj kamak bu nungka bidjalmarnekurduyimeng ngalbu ngad ngarridanginj, yiman ngaleng ngalwarre rerrih ngalbininjwern kakukweykaweykarren?” ");
INSERT INTO gup_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Wanjh God bimarneyimeng Jacob, yimeng, “Yirrolkka, yiray kore Bethel, kumekbe yibolkmarnbu yinin, dja altar kunwardde yiwarrudjkenh yimarnbu ngayekenh, nawu God nawu marnebukkarrinj bu ngudda yikelerlobmeng kore ngunedanginjbeh nawu Esau.” ");
INSERT INTO gup_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Wanjh kunu Jacob benmarneyimeng nawu birrimud dja bininj rowk nawu birridjarrkrey, wanjh yimeng, “Ngurribawo rowk nawu birriwokbubuyika bedberre gods nawu ngurrikarrme, dja ngurrikukdjirridjburrimen ngurrikukbeleworrimen, dja kunmadjbele ngurridjongburrimen. ");
INSERT INTO gup_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Wanjh ngurrimray, wanjh karrire kore Bethel, ba kumekbe ngaye ngamarnbun altar kunwardde yiwarrudjkenh nuye God nawu nganbekkang bu ngaye ngakangewarreni, dja nawu mak nganehdjarrkrey bu baleh yarrkka ngarey.” ");
INSERT INTO gup_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Wanjh kunu bedda birriwong Jacob birriwokbubuyika bedberreni gods nawu birrikarrmi, mak kunkanemkenh nawu birrikanemdjongbuyindi, birriwong rowk, dja Jacob dudji rowk kanjdji kore oak kundulk kore Shechem. ");
INSERT INTO gup_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Wanjh birriwam, dja God benmarnbom birrikeleminj bininj nawu birrini kubolkkihkimuk rowk kumekbe darnkih, ba minj bindikadjuyi Jacob dja nawu birrihdjarrkrey. ");
INSERT INTO gup_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob dja bedda rowk nawu birridjarrkrey wanjh birrimbebmeng kore kunred Luz, kumekbe kore kabolkngeyyo warridj Bethel, kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Wanjh kumekbe nungka marnbom altar kunwardde yiwarrudjkenh, dja kumekbe God korroko bimarnebukkarrinj bu nungka kelerlobmeng benedanginjbeh, wanjh kunmekbekenh kunu Jacob bolkngeykurrmeng “God nawu kunred Bethelkenh.” ");
INSERT INTO gup_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kaluk Deborah ngalbu Rebekah binahnani wanjh doweng, dja birrikukdudji kanjdji kurrulk oak, kaluk walemkah Bethel. Wanjh kunu birridulkngeykurrmeng “Kundulk kore birrinalkbuni”. ");
INSERT INTO gup_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Bu Jacob kumdurndi Paddan Arambeh God biyawoyhmarnebukkarrinj dja bimarneyimeng kunmak kunwok. ");
INSERT INTO gup_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God bimarneyimeng, “Ngudda yingeyyo Jacob, wanjh minj munguyh mak ngundingeybun Jacob, dja Israel yidjalngeyyo.” Wanjh kunu bingeykurrmeng Israel. ");
INSERT INTO gup_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Wanjh God bimarneyimeng, yimeng, “Ngaye wanjh God nawu Ngangudjkimuk Duninjh. Ngudda yibenborna birriwern wurdwurd, ngurrimirndewernworrimen. Nawu ngudda yibenkebmawahme kaluk kabirriyimerran birriredbo, dja mak birrimirndekihkimuk nawu birriredbo. Dja king kabirrimbebmerren kore nguddahbeh nawu yibenkebmawahme, kaluk kabindibebbehmarnewohrnan birribebbehmirndewern bininj. ");
INSERT INTO gup_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Dja kunred nawu ngabenbenebolkwong Abraham dja Isaac, wanjh ngudda bolkwon warridj, dja ngabenbolkwon nawu ngudda kaluk yibenkebmawahme.” ");
INSERT INTO gup_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kaluk God bibawong bolkbawong kumekbe kore benehwokdi. ");
INSERT INTO gup_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Wanjh Jacob warddedjabnameng kumekbe kore God benehwokdi, wanjh nungka boyakbom manbu bibowong God, dja mak mankalkkid oil yakbom kore manmekbe manbu djabnameng. ");
INSERT INTO gup_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kumekbe kore God benehwokdi Jacob bolkngeykurrmeng Bethel. ");
INSERT INTO gup_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wanjh bedda birribolkbawong Bethel. Bu birrimhboyenrey kaluk Ephrath djarrehni rerrih, Rachel wurdyaw bihbuni, dja baraburreni. ");
INSERT INTO gup_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bu ngaleng barahbaraburreni bu wurdyaw bihbuni, wanjh daluk ngalbu bibidyikarrmi wurdyawkenh wanjh bimarneyimeng, “Yuwn yikele, dja yiyawmey narangem nabuyika.” ");
INSERT INTO gup_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Wanjh Rachel kuyindoweng, dja bu ngolekyakmeni ngaleng bingeykurrmeng, “Nayaw ngardduk bu ngakangewarre.” Dja kornkumo nuye bingeykurrmeng Benjamin. Kunekke kunngey kayime “Wurdyaw kunbidkunkenh ngardduk.” ");
INSERT INTO gup_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Wanjh kunu Rachel doweng dja birrikukdudji kore darnkih manbolh manbu kahre kore Eprath. Kumekbe Eprath kabolkngeyyo warridj Bethlehem. ");
INSERT INTO gup_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kaluk kaddumkah kore kumidj ngarre Jacob warddedjabnameng, manmekbe manbu kadjalwarddedjabdi munguyh, kabimidjmulewan Rachel ngarre kumidj. ");
INSERT INTO gup_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel yawoyhwam dja dabburlin nameng bewhkah ngarre kunred Migdal Eder. ");
INSERT INTO gup_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Bu Israel ni kumekbe kubolkwarlah, kaluk Reuben bimarnengimeng beneyonginj Bilhah, ngalbu kornkumo nuyeni daluk ngalbu benedjalwohni, dja Israel wobekkang bu kunmekbe yimeng. Jacob benbornang twelve bebeywurd. ");
INSERT INTO gup_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Nawu nayayaw ngarreni Leah wanjh Reuben nawu nadjdjaman nuye Jacob, dja mak Simeon, Levi, Judah, Issachar dja Zebulun. ");
INSERT INTO gup_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Nawu nayayaw ngarreni Rachel wanjh Joseph dja Benjaminj. ");
INSERT INTO gup_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Nawu nayayaw ngarreni Bilhah ngalbu Rachel bimarnedurrkmirri, wanjh Dan dja Naphtali. ");
INSERT INTO gup_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Dja nawu nayayaw ngarreni Zilpah ngalbu Leah bimarnedurrkmirri, wanjh Gad dja Asher. Bedda wanjh birribebeywurd nuye Jacob nawu birrimarnedanginj kore Paddan Aram. ");
INSERT INTO gup_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob kumdokmeng kured kore kornkumo nuye nawu Isaac kore kunred Mamre, darnkih kore Kiriath Arba. Kumekbe mak kabolkngeyyo warridj Hebron kore Abraham ningihni korrokoni, dja mak Isaac kumekbe ni. ");
INSERT INTO gup_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac djahdjalmimbini bu mandjewk 180. ");
INSERT INTO gup_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Wanjh nungka ngolekdadjmeng doweng, dja malngwam kore mawahmawah nuye birriyingkihmalngdokmeng. Bu nungka doweng wanjh nungka wernhkohbanjminj duninjh. Dja bebeywurd nuyeni nawu Esau dja Jacob benekukdudji. ");
INSERT INTO gup_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Kuhni wanjh kabenyolyolme Esau dja nawu benbornang dja nawu benkebmawahmeng. (Esau nungka mak ngeyyoy Edom.) ");
INSERT INTO gup_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau benbenemey ngalbibininjkobeng kore Canaanbeh daluk, ngalkudji Adah ngalbu ngalbeywurd nuye Elon nawu Nahit bininj, dja ngalbuyika Oholibamah ngalbu ngalbeywurd nuye Anah, nawu nungan nuyeni kornkumo wanjh Zibeon ngalbu ngeyyoy Hiv, ");
INSERT INTO gup_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","dja mak Esau bimey Basemath ngalbu ngalbeywurd nuyeni Ishmael dja ngaleng benedanginj Nebaioth. ");
INSERT INTO gup_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah bimarneyawmey Esau Eliphaz. Basemath biyawmey Reuel. ");
INSERT INTO gup_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Dja Oholibamah benyawmey Jeush, Jalam, dja Korah. Birrimekbe wanjh bebeywurd nuye Esau nawu birrimarnedanginj kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau benkang ngalbibininjkobeng nuye dja bebeywurd ngalbebeywurd dja bininj nuye rowk nawu birridjarrkni, dja mak benkang mayh nuye rowk, dja yehyeng rowk nuye nawu mangi kore Canaan, dja nungka wam kore kubolkwarlah djarrehkah kore benedanginj nawu Jacob. ");
INSERT INTO gup_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nawu bedda benebebbehkarrmi wanjh nawern duninjh, wanjh kunu minj benedjarrkniwirrinj munguyh, dja kore kubolkwarlah kore benedjalwohningini minj manme manwern yuwirrinj, dja mayh berrewoneng nawern duninjh. ");
INSERT INTO gup_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Wanjh kunmekbekenh kunu Esau nawu mak ngeyyoy Edom, nungka bolkmarnbom ni kore kurruluhdulum ngarre Seir. ");
INSERT INTO gup_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Kuhni kabenyolyolme Esau dja nawu Esau benbornang dja benkebmawahmeng. Esau wanjh nungka mawah bedberre bininj nawu birringeyyoy Edom, nawu birrini kore kurruluhdulum ngarre kunred Seir. ");
INSERT INTO gup_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Kuhni birringeyyoy Esau nuye bebeywurd dja Mawah nuye. Kaluk benbenebornang Eliphaz nawu nayaw ngarre Adah ngalbu Esau nuye ngalbininjkobeng, dja Reuel nawu nayaw ngarre Basemath ngalbu Esau nuye ngalbininjkobeng. ");
INSERT INTO gup_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Dja nawu Eliphaz nunganwali bebeywurd nuye wanjh Teman, Omar, Zepho, Gatam dja Kenaz. ");
INSERT INTO gup_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Dja namekbe Eliphaz nawu Esau bibornang nungka biwohmey ngalbuyika daluk ngalbu ngeyyoy Timna, ngaleng wanjh bimarneyawmey Amalek. Birrimekbe bininj rowk wanjh Esau nuye ngalbininjkobeng Adah benkebmakkahmeng. ");
INSERT INTO gup_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Dja nawu Reuel benbornang wanjh Nahath, Zerah, Shammah, dja Mizzah. Birrimekbe wanjh Esau nuye ngalbininjkobeng Basemath benkebmakkahmeng. ");
INSERT INTO gup_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Dja nayayaw ngarre Esau nuye ngalbininjkobeng Oholibamah, ngalbu ngalbeywurd nuye Anah nawu Zibeon kornkumo nuyeni, wanjh nayayaw ngarre nawu bimarneyawmey Esau wanjh Jeush, Jalam, dja Korah. ");
INSERT INTO gup_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Nanih wanjh nawu birriwohrnani kore Esau benkebmawahmeng. Bebeywurd nuye Eliphaz nawu nadjdjaman nuye Esau, wanjh nawu birriwohrnani kaluk Teman, Omar, Zepho, Kenaz. ");
INSERT INTO gup_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, dja Amalek. Birrimekbe wanjh bedda nawu birriwohrnani nawu Eliphaz benkebmawahmeng kore kubolkwarlah Edom, bedda wanjh Adah benkebmakkahmeng. ");
INSERT INTO gup_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Dja bebeywurd nuye Reuel nawu Esau bibornang, wanjh bedda nawu birriwohrnani kaluk Nahath, Zerah, Shammah, dja Mizzah. Bedda wanjh birrimekbe nawu birriwohrnani, nawu Reuel benkebmawahmeng kore Edom, bedda wanjh Basemath benkebmakkahmeng, ngalbu Esau nuye ngalbininjkobeng. ");
INSERT INTO gup_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dja nayayaw ngarre Oholibamah ngalbu Esau nuye ngalbininjkobeng, bedda wanjh nawu birriwohrnani kaluk Jeush, Jalam, dja Korah. Bedda wanjh birrimekbe nawu birriwohrnani nawu Esau nuye ngalbininjkobeng Oholibamah benyawmey, ngalbu ngalbeywurd nuyeni Anah. ");
INSERT INTO gup_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bedda wanjh birrimekbe bebeywurd nuye Esau nawu mak ngeyyoy Edom, dja nawu bindimarnewohrnani birribuyika bedberre bininj. ");
INSERT INTO gup_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Bininj nawu birringeyyoy Hor, wanjh birriyingkihni kumekbe kubolkwarlah. Nanih wanjh bebeywurd dja mawahmawah nuye Seir nawu birrimekbe nawu Hor birringeyyoy. Nawu benbornang wanjh Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO gup_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, dja Dishan. Bedda nawu bebeywurd nuye Seir kore Edom nawu bindimarnewohrnani kore nawu birringeyyoy Hor. ");
INSERT INTO gup_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan nuye bebeywurd wanjh namud bedberre ngeyyoy Hori dja mak Heman. Dja Timna ngaleng benedanginj Lotan. ");
INSERT INTO gup_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal nuye bebeywurd wanjh Alvan, Manahath, Ebal, Shepho, dja Onam dja nawu bindikebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon nuye bebeywurd wanjh Aiah dja Anah. Nanih wanjh namekbe Anah nawu bongalkeng kore kubolkdarleh bu bennahnani donkey nuye Zibeon nawu kornkumo nuye. ");
INSERT INTO gup_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah benbenebornang Dishon dja Oholibamah ngalbu ngalbeywurd nuye Anah. ");
INSERT INTO gup_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon nuye bebeywurd wanjh Hemdan, Eshban, Ithran, dja Keran. ");
INSERT INTO gup_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer nuye bebeywurd wanjh Bilhah, Zaavan, dja Akan. ");
INSERT INTO gup_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan nuye bebeywurd wanjh Uz dja Aran. ");
INSERT INTO gup_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Bedda wanjh birrimekbe nawu bindimarnewohrnani bininj nawu birringeyyoy Hor. Kaluk birriwohrnani Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO gup_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, dja Dishan. Bedda wanjh bindibebbehmarnewohrnani nawu birringeyyoy Hor kore birribebbehmud kore kubolkwarlah Seir. ");
INSERT INTO gup_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nanih kabirringeydi king nawu birriwohrnani kore kubolkwarlah Edom, bu minj Israel birribangmekarrmeninj king benmarnewohrnayi. ");
INSERT INTO gup_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela nawu beywurd nuye Beor, nungka yimerranj king wohrnani kore Edom. Kubolkkimuk nuye bolkngeyyoy Dinhabah. ");
INSERT INTO gup_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bu Bela doweng, wanjh Jobab nawu beywurd nuye Zerah nawu nakang Bozrah, nunganwali wanjh yimerranj king. ");
INSERT INTO gup_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Bu Jobab doweng, Husham nawu nakang kubolkwarlah bedberre nawu Teman benkebmawahmeng, nunganwali yimerranj king. ");
INSERT INTO gup_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Bu Husham doweng, wanjh Hadad nawu beywurd nuye Bedad, nawu bibom Midian kore kubolkwarlah Moab, nunganwali yimerranj king. Dja kubolkkimuk nuye bolkngeyyoy Avith. ");
INSERT INTO gup_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Bu Hadad doweng, Samlah nawu nakang Masrekah, nunganwali yimerranj king. ");
INSERT INTO gup_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Bu Samlah doweng, Shaul nawu nakang Rehoboth kore mankabo, nunganwali yimerranj king. ");
INSERT INTO gup_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Bu Shaul doweng Baal Hanan nawu beywurd nuye Acbor, nunganwali yimerranj king. ");
INSERT INTO gup_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bu Baal Hanan nawu beywurd nuye Acbor doweng, Hadad nunganwali yimerranj king. Kubolkkimuk nuye bolkngeyyoy Pau, dja ngalbininjkobeng nuye ngeyyoy Mehetabel ngalyaw ngarre Matred, ngalbu ngalbeywurd nuye Mezahab. ");
INSERT INTO gup_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nanih wanjh birringeyyoy nawu birriwohrnani nawu Esau benkebmawahmeng, kaluk nawu birriyawmud duninjh birribolkngeykenkani kunred bedberre. Kaluk Timna, Alvah, Jetheth, ");
INSERT INTO gup_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO gup_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO gup_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel dja Iram. Bedda wanjh birrimekbe nawu birriwohrnani kore Edom. Kunred kore birrini nawu birriyawmud duninjh, wanjh birribolkngeykenkani. Kuhni wanjh biyolyolmeng Esau nawu benkebmawahmeng bininj nawu birringeyyoy Edom. ");
INSERT INTO gup_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob ni kore kubolkwarlah bu kornkumo nuye djalwodjalwohrey korroko, kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nahni kunwok wanjh kabenyolyolme Jacob dja nawu nungka benbornang. Kunkareni, Joseph nawu yawurrinjni bu mandjewk nuyeni seventeen, wanjh nungka mayh benmirndenahnani, birridjarrknahnani nawu birridanginj, nawu nayayaw berrewoneng Bilhah dja Zilpah nawu kornkumo nuye ngalbibininjkobeng. Wanjh Joseph benmulewam kore kornkumo, yimeng bu bedda kunwarre birriyimi nawu birridanginj. ");
INSERT INTO gup_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Kaluk Israel biwernhmarnedjareni Joseph, dja nawu birribuyika wurdwurd nuye, nungka yiman walakkih benmarnedjareni. Nungka Joseph danginj bu kornkumo kohbanjminj, kunmekbekenh kunu nungka biwernhmarnedjareni. Wanjh Israel namak duninjh bimarnemarnbom Joseph nawu kadjongburrenkenh. ");
INSERT INTO gup_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Wanjh bu nawu birridanginj birrinang kornkumo biwernhmarnedjareni nungka nawu Joseph, wanjh kunu bedda birriwidnani, dja minj baleh kunmak birrimarneyimeninj. ");
INSERT INTO gup_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kaluk Joseph kodjbukirriwam, dja bu benmarneyimeng nawu birridanginj, bedda birriwernhwidnang. ");
INSERT INTO gup_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nungka benmarneyimeng, “Kandibekka ngaye ngamulewarren bu ngakodjbukirriwam. ");
INSERT INTO gup_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kaluk ngad karridalkdukkani kore kabbal, dja kumekbe ngaye ngardduk kundalk mandobbokenh wanjh dalkdolkkang dalkdjabdanginj mandjad, dja ngudda ngudberre kundalk birrimirndemornnamerrinj kore ngaye ngardduk kundalk, birrimarnedalkboddanj kore ngaye ngardduk kundalk.” ");
INSERT INTO gup_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Wanjh nawu birridanginj birrimarneyimeng, “Yiddok yiwohrnan ngadberre woybukkih, yiddok ngudda kaluk ngundiwokmarrkmang dja ngundimarnedurrkmirri?” Bu nungka kuhni kodjbukirriwam, dja mak bu benmarneyimeng, kunu wanjh birriwernhwidnani. ");
INSERT INTO gup_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Wanjh nungka yawoyhkodjbukirriwam, dja benmarneyimeng birridanginj, yimeng, “Kandibekka, ngayawoyhkodjbukirriwam, dja kaluk kundung, dird dja eleven mankokkarrng ngandimarneboddangeni.” ");
INSERT INTO gup_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Wanjh bu kuhni bimarneyimeng kornkumo warridj, wanjh nawu kornkumo birruy bimarneyimeng, “Njale kuhni bu yibukirribom? Yiddok woybukkih ngaye dja ngalbadjan ke dja nawu ngurridanginj, wanjh ngarrimre ngarriboddan kurorre kumirrk ke?” ");
INSERT INTO gup_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Wanjh nawu birridanginj birrimarnekirnni, dja kornkumo nungka wanjh djalkarrmeng kunwok kukange nuye. ");
INSERT INTO gup_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kaluk nawu Joseph birridanginj birriwam kabindidalkwon mayh nuye kornkumo bedberre, birriwam darnkih kore kabolkngeyyo Shechem. ");
INSERT INTO gup_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Wanjh Israel bimarneyimeng Joseph, yimeng, “Ngudda yiburrbun bu nawu ngurridanginj kabindidalkwon mayh darnkih kore Shechem. Ngaye munkewe kore bedda.” Wanjh bimarneyimeng, “Mah kamak.” ");
INSERT INTO gup_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Wanjh kornkumo yimeng, “Yiray wanjh dja yinan bu kamak bedda kabirrini nawu ngurridanginj dja mayh warridj, dja yimdurndeng kanmarneyime.” Kunu wanjh nungka bimunkeweng kumekbebeh kanjdjikanjdji ngarre Hebron, dja wam kore Shechem. ");
INSERT INTO gup_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Bu bebmeng kore darnkih Shechem, wanjh nakudji bininj bingalkeng bu nungka Joseph djahdjalrengehrey kore kabbal, dja bidjawam, “Ngudda njale yihyawan?” ");
INSERT INTO gup_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nungka yimeng, “Ngabenyawan nawu ngarridanginj, kab kanmarneyime bu bedda baleh mayh kabindidalkwon.” ");
INSERT INTO gup_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Dja namekbe bininj yimeng, “Bedda birriwam dja ngabenbekkang birrimarneyimerrinj, ‘Karriray kunred Dothan.’” Wanjh Joseph djahdjalwam benyikang nawu birridanginj, benngalkeng kore darnkih Dothan. ");
INSERT INTO gup_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bedda wanjh birrinang bu djarreh kumhrey, dja bu nungka minj bangmebebmeninj bedberre, bedda birriwokmarnburrinj kabirribunkenh. ");
INSERT INTO gup_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Bedda birrimarneyimerrinj, “Nanih nawu kamhre nawu munguyh kahkodjbukirrire. ");
INSERT INTO gup_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Wardi karribu dja karrikukburriwe kore mandjorlokburrk, kaluk karrimulewan bu karriyime nawu mayh nabang bibom bikukyakwong. Wanjh karrinan bu baleh kayimerran bu nungka kahkodjbukirrire!” ");
INSERT INTO gup_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Dja Reuben nawu nawernwarre duninjh bedberre, bu bekkang kuhni, nungka minj djareniwirrinj kunmekbe birrimarneyimeninj, yimeng, “Yuwn bu karribun!” ");
INSERT INTO gup_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","“Yuwn mak ngurrikurlbawarrhke! Dja wardi ngurridjalburriwemen kore kudjorlok manbu kukkukenh kondah kore kubolkdarleh, yuwn baleh mak karrimarneyime.” Kuhni nungka Reuben yimeng ba kaluk bibebkemeninj kore bedda birrimarneyimeninj, dja birrurndiwemeninj kore kornkumo. ");
INSERT INTO gup_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Wanjh kunu Joseph benmarnebebmeng nawu birridanginj, bedda wanjh birriyerrkkeng nawu namak duninjh nawu djongbuhdjongbuyindi, ");
INSERT INTO gup_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","dja nungka birrikang birriburriweng kore kudjorlok, kaluk kumekbe kudjorlok bukni, minj boyuwirrinj. ");
INSERT INTO gup_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wanjh bedda birriyerrkang birrihnguni manme, dja birribolknang bindinang kabirrimhre bininj nawu Ishmael benkebmawahmeng kore Gileadbeh, camel dorrengh bedberre nawu birringorrkani namanjmak yiman spices, balm dja myrrh, kabirrikan kore Egypt kore birrihrey. ");
INSERT INTO gup_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Wanjh Judah benmarneyimeng nawu birridanginj, yimeng, “Njale kaluk karrimang bu karribun nawu karridanginj dja karrikukwarlkkan? ");
INSERT INTO gup_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kab karrikukweyka kore bininj nawu Ishmael benkebmawahmeng, dja yuwn baleh karrimarneyime, dja nungka karridanginj bulkkidj.” Wanjh nawu birridanginj birrikodjdukmeng. ");
INSERT INTO gup_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Bedda nawu Ishmael benkebmawahmeng bininj wanjh birribayahmeng dja birriweykani njalehnjale. Bu bindimarnebebmeng, wanjh Joseph birridanginj birriwayhkeng Joseph kudjorlokbeh, dja birrikukweykang bu bedda bindiwong kunwardde nawern, yiman twenty silver shekels, dja bedda birrikang Joseph kore Egypt. ");
INSERT INTO gup_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kaluk bu Reuben kumdurndi kore kudjorlok, dja nang Josephyak kumekbe kore kudjorlok, nungka welengdjobkerrinj manburrba nawu djongbuhdjongbuyindi, ");
INSERT INTO gup_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","dja nungka yawoyhdurndi kore birridanginj dja yimeng, “Yawurrinj wanjh wam, dja ngaye baleh ngakurduyime?” ");
INSERT INTO gup_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Wanjh bedda birrimey Joseph nuye nawu djongburreni, dja birribom goat, dja namekbe nawu Joseph nuye nawu djongburreni wanjh birridjuhkeng kore goat kunkurlba. ");
INSERT INTO gup_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Wanjh bedda birrikang namekbe nawu namak duninjh nawu djongburreni, birrikang kore kornkumo, dja birriyimeng, “Ngad ngarringalkeng nanih, wardi yikukna, dja kunubewu nuye nawu beywurd ke dja nuk burrkyak.” ");
INSERT INTO gup_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wanjh nungka wernhkukburrknang dja yimeng, “Namekbe wanjh nuye beywurd ngardduk. Mayh nabang bibom bikukyakwong, Joseph bonj wanjh, woybukkih bikukdjalkdjalkmey.” ");
INSERT INTO gup_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Wanjh Jacob djobkeng manburrba nuye nawu djongbuhdjongbuyindi, dja djongburrinj nawu kunnjilngwarrekenh, dja bimarnenjilngwarreni kunkuyeng kunbarnangarra kunwern. ");
INSERT INTO gup_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bebeywurd nuye rowk dja ngalbebeywurd birrimrey nuye kabirrinjilngmarnbunkenh, dja yiman bendabmeng rerrih, minj njilngmakmeninj. Nungka yimeng, “Bonj, ngadjalnjilngwarre munguyh nuye beywurd ngardduk, kaluk ngayemanwali ngarrowen, ngamalngre kanjdji kore nungka kore kunbolk Sheol.” Kuhni yimi kornkumo bu bidjalmarnenalkbuni. ");
INSERT INTO gup_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kaluk bininj nawu Midianbeh birrikukweykang Joseph kore kunbolk Egypt. Nawu Potiphar bimey, nawu King Pharaoh bimarnedurrkmirri, dja benmarnewohrnani djamun nawu birrirurrknahnani Pharaoh nuye. ");
INSERT INTO gup_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Wanjh Judah benbawong nawu birridanginj, dja wam beneni nakudji bininj nawu nakang kunred Adullam nawu nungka ngeyyoy Hirah. ");
INSERT INTO gup_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Bu kumekbe ni, Judah binang ngalbeywurd nuye nakudji bininj nawu Canaan bikebmawahmeng, nawu nungka ngeyyoy Shua. Wanjh Judah benemarrinj dja beneyoy ngalmekbe daluk. ");
INSERT INTO gup_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wanjh ngaleng yawkani, kaluk narangem yawmey, kornkumo bingeykurrmeng Er. ");
INSERT INTO gup_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kaluk yawoyhyawkani dja yawmey narangem, bingeykurrmeng Onan. ");
INSERT INTO gup_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Wanjh yawoyhyawmey nabuyika warridj, bingeykurrmeng Shelah. Ngaleng ni kore kunred Kezib bu nungka danginj. ");
INSERT INTO gup_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kaluk bu Er djordminj, wanjh Judah daluk bimarnemey daluk nuye nawu beywurd nadjdjaman nuye, ngaleng ngeyyoy Tamar. ");
INSERT INTO gup_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Dja Er nawu nadjdjaman nuye Judah, nungka bu Yawey binang kunwarre djalkadjuy, wanjh kunu Yawey bibom, doweng. ");
INSERT INTO gup_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Wanjh Judah bimarneyimeng Onan, “Nguneyuwn ngalbu beneni Nakokok, bu mankarre kahyo bininj kabeneyo kamarrdjukun nuye nawu nawernwarre bu beneni, ba kunu wurdwurd yibenbornan nawu yiman nungka nuye rerrih.” ");
INSERT INTO gup_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Dja Onan burrbom bu wurdwurd benbornayi, bininj birriyimeninj minj nungka nuyeniwirrinj, wanjh kunu bu rey beneyoy ngalbu nawernwarre nuyeni, nungka manduk yakbom kore kurorre, ba minj yawbornayi nuyeniwirrinj nawu benedanginj. ");
INSERT INTO gup_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wanjh Yawey nang bu kuhni kurduhkurduyimi kunwarre, wanjh kunu nungka warridj bibom doweng. ");
INSERT INTO gup_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Wanjh Judah bimarneyimeng ngalbinjdoy nuye Tamar, yimeng, “Ngudda yidjalkamarrdjukunnin kore kornkumo ke nuye kunrurrk, kumekbe yidjalnin munguyh, kaluk beywurd ngardduk nawu Shelah kadjordmen.” (Kunmekbe yimeng bu nungka keleni bu yimankek nunganwali Shelah dowimeninj yiman birridanginj nuye benedoweng.) Wanjh kunu Tamar wam ningihni kore kornkumo ngarreni kunrurrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kaluk rerrikah Judah nuyeni ngalbininjkobeng ngalbu ngalbeywurd nuye Shua, wanjh doweng. Wanjh Judah njilngwahnjilngwarreni, wanjh kaluk bu njilngmakminj wanjh nungka wam bidbom kore kunred Timnah, kore bininj birrimuddadjkeyi sheep nuye, dja nawu benedabbolk Hirah Adullumbeh wanjh benedjarrkwam. ");
INSERT INTO gup_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kaluk bu Tamar bekkang bu nabininjdoy kahre kore Timnah kabirrimuddadjke sheep, ");
INSERT INTO gup_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","wanjh ngaleng yerrkkerrinj nawu kamarrdjukunkenh bu djongbuhdjongbuyindi, dja manburrba djongburrinj kebbarrkburrinj, wanjh wam yerrkang ni kore bininj kabirringimen kore kunred Enaim, kaluk kore manbolh manbu kahre kore Timnah. Kunmekbe yimeng bu ngaleng nang Shelah djordminj dja minj biwoyi beneniwirrinj. ");
INSERT INTO gup_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kaluk Judah binang Timnah, dja nungka yimeng bu yimankek ngaleng daluk ngalbu kakukweykarren kore bininj. Kunmekbe nungka yimeng bu ngaleng kebbarrkbuyindi. ");
INSERT INTO gup_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nungka minj burrbuyi bu ngaleng ngalbinjdoy nuye, wanjh nungka wam kore ngaleng ni kore kubolhdid, dja yimeng, “Yimray wanjh, ngarryo.” Dja ngaleng bidjawam, “Njale kaluk kanwon ngarryokenh?” ");
INSERT INTO gup_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Nungka yimeng, “Ngaye marnemunkewe goat yaw kore ngardduk mayh kamirnderri.” Wanjh ngaleng bidjawam yimeng, “Yiddok ngudda kanwon njale ngadjalwohkarrme, kaluk marnedurndiwe bu ngudda yimmunkewe?” ");
INSERT INTO gup_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Nungka yimeng, “Njale kaluk yidjare won yidjalwohkarrme?” Wanjh ngaleng biwokmey yimeng, “Kanwo ring kunbidkenh nawu yingan kekih nawu yiman rerrih yihngeybimdi, kaluk kunyarl dorrengh, dja mak kunkarndudj manbu yihkarndudjkarren.” Wanjh kunu nungka biwong, dja beneyonginj. Kaluk ngaleng yawkani nungka nuye wurdyaw. ");
INSERT INTO gup_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Wanjh ngaleng bu wam wanjh yerrkkerrinj nawu kebbarrkbuyindi dja yawoyhdjongburrinj kamarrdjukunkenh kunmadj. ");
INSERT INTO gup_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kaluk Judah munkeweng goat yaw, bininj nawu benedabbolk nawu nakang Adullam, nungka kang ba daluk bimarnedurndiwemeninj nawu biwong nawu djalwohkarrmi. Nungka kaluk bidjalyawam, minj bingalkemeninj. ");
INSERT INTO gup_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Wanjh bendjawam bininj nawu birrini kumekbe, yimeng, “Baleh daluk ngalbu kakukweykaweykarren kore ngudberre yiwarrudjkenh, ngalbu ni kore kubolhdid kore Enaim?” Bedda birriyimeng, “Minj kondah niwirrinj ngalbu kakukweykaweykarren kore ngadberre yiwarrudjkenh.” ");
INSERT INTO gup_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Wanjh kunu nungka durndi kore Judah ni dja yimeng, “Minj ngangalkemeninj dja mak bininj nawu kumekbe birrini birriyimeng bu minj kumekbe niwirrinj daluk ngalbu kakukweykaweykarren kore bedberre yiwarrudjkenh.” ");
INSERT INTO gup_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Wanjh Judah yimeng, “Bonj, balkarrmen nawu kahkarrme, marndi bu ngarryawan wanjh bininj kandidjekwiwon ngarrku. Ngaye ngamarnemunkeweng goat yaw, dja minj ngaleng yingalkemeninj.” ");
INSERT INTO gup_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kaluk rerrikah bu yiman dird danjbik Judah birrimarneyimeng, “Ngalbinjdoy ke ngalbu Tamar wanjh kukweykarrinj kore bininj, dja wanjh kayawkan.” Judah yimeng, “Ngurrimbebkemen dja kunak ngurrikukwurlhkemen karrowen.” ");
INSERT INTO gup_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Bu birrimbebkeng ngaleng kunwok munkeweng nuye nawu nabininjdoy, yimeng, “Ngaye wurdyaw ngakan nuye bininj nawu nuye nahni.” Dja mak yimeng, “Yinan bu yimankek yikukburrknan nangale nuye nawu nahni bininj nuye nawu yiman rerrih kahngeybimdi, kaluk kunyarl dorrengh, dja kunkarndudj?” ");
INSERT INTO gup_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Wanjh Judah kukburrknang dja yimeng, “Ngaleng wanjh ngalmak, dja ngaye ngawarre bu minj ngawoyi beywurd ngardduk nawu Shelah.” Dja nungka Judah minj beneyawoyhyuwirrinj. ");
INSERT INTO gup_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Bu kumwam ngarre wurdyaw bibuni wanjh narahrangem bokenh kanihkani. ");
INSERT INTO gup_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Bu wurdyaw mahmirri, nakudji bidbebmerrinj, wanjh kunu daluk ngalbu bibidyikarrmi wurdyawkenh, kunyarl mey nawu kukkurlbani dja bibendedukkang, yimeng, “Namekbe wanjh bebmeng werrk.” ");
INSERT INTO gup_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Dja bu nungka biddurndiwerrinj, wanjh nawu benedanginj danginj werrkwerrk, wanjh ngaleng yimeng, “Kunukka wanjh ngudda yibebmeng werrkwerrk.” Wanjh kunu nungka ngeyyoy Perez. ");
INSERT INTO gup_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Wanjh nunganwali danginj nawu benedanginj nawu bendedukkayindi kukkurlba kunyarl, wanjh nungka ngeyyoy Zerah. ");
INSERT INTO gup_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Bininj nawu Ishmael benkebmawahmeng, nawu birrikang Joseph kore Egypt, wanjh birribalkukweykang dja Potiphar bimey. Nungka Potiphar wanjh Egyptbeh bininj nawu king Pharaoh bimarnedurrkmirri, kaluk wohrnani bedberre djamun nawu king Pharaoh birrimarnerurrknahnani. ");
INSERT INTO gup_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawey wanjh benedjarrkrey Joseph, dja nungka Joseph bu baleh yimerrangeni nuye wanjh kamak rowk, dja nungka Joseph ni kore kunrurrk nuye Egyptbeh bininj nawu bimarnewohrnani. ");
INSERT INTO gup_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Bu nungka nawu bimarnewohrnani nang bu Yawey benedjarrkrey Joseph, dja Yawey bibidyikarrmi ba bu baleh yimerrangeni nuyeni Joseph wanjh kamak rowk, ");
INSERT INTO gup_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","wanjh namekbe bininj Potiphar bimarneyimeng Joseph namak, dja bikurrmeng nungan kabinahnan, dja bimarnbom nungka Joseph benmarnewohrnani bininj nuye nawu birridurrkmirri kururrk nuye, dja mak bimarnenahnani nawu yehyeng rowk nuye. ");
INSERT INTO gup_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Wanjh kundjalmekbe bu Potiphar yimeng bimarnbom Joseph kawohrnan kore kunrurrk nuye dja mak kore yehyeng nuye rowk, wanjh munguyh Yawey benmarnekurduyimi kunmak bininj nuye nawu namekbe Egyptbeh bininj. Kuhni Yawey kurduyimi bu nungka Josephkenh. Yehyeng nawu Potiphar karrmi wanjh God bimarnekurduyimi kunmak, kaluk kore kunrurrk dja mak kore kabbal. ");
INSERT INTO gup_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Wanjh kunu nungka bidjalyibawong rowk Joseph wohrnani. Dja bu nungka Joseph bikarrmi bimarnedurrkmirri, minj njale burrbuyi nawu Potiphar, nungka djalburrbuni manme nuye manbu nungan ngunihnguni. Dja Joseph nungka wanjh kukmakni dja mak kebmakni warridj. ");
INSERT INTO gup_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Wanjh kaluk ngalbininjkobeng nuye nawu bimarnewohrnani, ngaleng wanjh binani Joseph dja yimeng, “Yimray, ngarryo.” ");
INSERT INTO gup_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Dja nungka birrahmeng, yimeng, “Bu ngaye ngankarrme ngawohrnan, wanjh nungka nawu nganmarnewohrnan minj njale kaburrbun kondah kore kunrurrk, yehyeng nawu nungka kakarrme wanjh nungka ngankurrmeng ngamarnenahnan. ");
INSERT INTO gup_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Minj nangale nabuyika kawernhwohrnan kondah kore kunrurrk, dja ngaye ngadjalwohrnan. Minj njale ngankaybuyi, dja yidjalkudji ngudda nawu nuye ngalbininjkobeng. Kaluk baleh yimankek ngaye kuhni kunwarre duninjh ngayime, dja God ngamarneyime kunwarre?” ");
INSERT INTO gup_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Dja madjamku ngaleng munguyh bu kunbarnangarrabubuyika bihmarneyimi, dja nungka Joseph bidjaldahmi, minj beneyuwirrinj dja minj mak niwirrinj kore ngaleng. ");
INSERT INTO gup_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kaluk kunbarnangarrakudji bu nungka ngimeng kururrk kore durrkmihdurrkmirri, dja minj nangale mak nawu birridurrkmirri birriniwirrinj kururrk, ");
INSERT INTO gup_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","wanjh ngaleng bimarnekarrmeng manburrba nawu kaddum djongbuyindi, dja yimeng, “Yimray ngarryo.” Dja nungka djalbawong manburrba kubid ngalengngarre dja kelerlobmeng kuberrk. ");
INSERT INTO gup_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Bu ngaleng nang nungka bawong manburrba kubid ngalengngarre dja nungan kelerlobmeng kuberrk, ");
INSERT INTO gup_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","wanjh ngaleng benkayhmeng nawu birrimarnedurrkmirri, dja benmarneyimeng, “Nabininjkobeng ngardduk bimkang nahni nawu Hebrew bininj kanyemikan kadberre. Nungka ngimeng kondah nganeyuwirrinjkenh dja ngaye ngakayhmeng. ");
INSERT INTO gup_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Bu nungka nganbekkang ngaye ngakayhmeng, wanjh nungka bawong manburrba nuye kore ngaye dja kelerlobmeng kuberrk.” ");
INSERT INTO gup_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Wanjh ngaleng kurrmeng manburrba nuye Joseph darnkih kore ngaleng ni, dja bimadbuni kamdurndengkenh nawu Joseph bimarnewohrnani, ");
INSERT INTO gup_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","dja kunkudjiwi kunwok bimarneyimeng, yimeng, “Nawu Hebrew bininj nawu ngunmarnedurrkmirri nawu ngudda yimkang kore ngad, nungka wanjh nganmarnengimeng nganyemikankenh, ");
INSERT INTO gup_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","dja bu ngaye ngakayhmeng wanjh kundjalmekbe rerrih nungka bawong manburrba nuye kore ngaye, dja kelerlobmeng kuberrk.” ");
INSERT INTO gup_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wanjh namekbe nawu Joseph bimarnewohrnani bu bekkang kuhni kunwok nawu ngalbininjkobeng nuye bimarneyimeng bu yimeng, “Kuhni wanjh kunukka nganmarnekurduyimeng bininj nawu ngudda ngunmarnedurrkmirri”, wanjh nungka kangewurlhmeng. ");
INSERT INTO gup_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Wanjh nawu Joseph bimarnewohrnani bikang Joseph birrangbalhmeng kore prison, kore bininj nawu king benhdangbalhmi birridangbalhmiyindi, wanjh kumekbe dangbalhmiyindi. ");
INSERT INTO gup_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Dja bu Joseph kumekbe ni kore dangbalhmiyindi, wanjh Yawey benedjarrkrey, bihkongibuni bihmarnekurduyimi kunmak munguyh, dja bininj nawu bennahnani nawu birridangbalhmiyindi, nungka Yawey bimarnbom bimarneyimeng Joseph namak. ");
INSERT INTO gup_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Wanjh kunu namekbe bininj nawu bennahnani bikurrmeng Joseph benmarnewohrnani bininj rowk nawu kumekbe birridangbalhmiyindi kore prison, dja nungka wohrnani kore yehyeng nawu kumekbe prison birrikurduyimi. ");
INSERT INTO gup_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yawey benedjarrkrey Joseph dja bimarnbom bu baleh nungka yimi wanjh kamak rowk yimerrangeni, wanjh kunu namekbe nawu bennahnani minj baleh biyidjawayi kore Joseph nahnani. ");
INSERT INTO gup_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Kaluk yerrekah bininj bokenh benenjilngwarrewong nungka nawu benehmarnedurrkmirri, nawu king Pharaoh, nawu wohrnawohrnani kubolkwarlah Egpyt. Nakudji bininj nawu wohrnani bedberre nawu birrimarnebokani king Pharaoh, dja nabuyika nawu wohrnani bedberre nawu manme birrimarnekinjeyi nawu king. Nungka wanjh yidduy bu kunmekbe beneyimeng bininj bokenh nawu benekihkimuk benemarnedurrkmirri, ");
INSERT INTO gup_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","wanjh benbenedangbalhmeng kore prison, kore kunrurrk nuye bininj nawu wohrnani bedberre bininj nawu king birrimarnerurrknahnani, kaluk kubolkkudjiwi kore Joseph dangbalhmiyindi. ");
INSERT INTO gup_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Wanjh namekbe nawu wohrnani bedberre djamun nawu king birrimarnerurrknahnani, wanjh bikurrmeng Joseph kabenbenenahnan, wanjh nungka benbenemarnedurrkmirri, benbenemarnekani manme. Kaluk bedda kunkuyengwurd benedangbalhmiyindi. ");
INSERT INTO gup_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kaluk kunkudji kumunun king Pharaoh nuye bininj nawu bimarnebokani dja mak nabuyika nawu bimarnekinjeyi manme, nawu benedangbalhmiyindi kore prison, wanjh benebebbehkodjbukirriwam, kaluk manbebbehkarrebubuyika. ");
INSERT INTO gup_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","7","Kaluk bu kukabel bu Joseph benbenemarnebebmeng benbenenang bedda nawu benekihkimukni benemarnedurrkmirri Pharaoh nawu birridjarrkdangbalhmiyindi, benbenenang bedda wanjh benenjilngwarreni. Wanjh kunu Joseph benbenedjawam, “Njalekah bolkkime ngunekebbume?” ");
INSERT INTO gup_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wanjh bedda beneyimeng, “Ngad nganekodjbukirriwam, dja minj nangale kaburrbun bu kanbenemarnekarreyolyolme.” Wanjh Joseph benbenemarneyimeng, “God nadjalkudji kaburrbun dja kanmarnekarreyolyolme. Wanjh ngadjare kandimarneyime nawu njale ngunekodjbukirriwam.” ");
INSERT INTO gup_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wanjh kunu bininj nawu king bimarnebokani bimarneyimeng Joseph bukirri nawu nuye nungka kodjbukirriwam, yimeng, “Bu ngaye ngakodjbukirriwam nganang manrakel kore kumirrk ngardduk, ");
INSERT INTO gup_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","dja kore manrakel kaluk danjbik manyenhyende, wanjh bu worrbebmerrinj, wanjh kundjalmekbe rerrih mannguy dangerrinj, dja manme mirndedjolengminj manbu grapes. ");
INSERT INTO gup_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh nuye banikkin ngakarrmi kubid ngardduk wanjh ngamey grapes dja ngakalkkiddjuwimeng kore banikkin nuye Pharaoh, dja ngabidkenwong banikkin nuye.” ");
INSERT INTO gup_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Wanjh Joseph bimarneyimeng, “Kuhni wanjh kakarreyime. Manbu danjbik manyende kayolyolme kunbarnangarra danjbik, ");
INSERT INTO gup_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","kaluk bu minj kabangmeyakmen kunbarnangarra danjbik wanjh Pharaoh ngunbebke dja ngunmarnbun yiyawoyhmarnedurrkmirri, dja ngudda kaluk yibidkenwon banikkin yiman bu kerrngehkenh yihkurduyimi bu ngudda yimarnebokani. ");
INSERT INTO gup_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Dja yina! Kaluk bu ngudda ke kayimerran kamak rowk, wanjh kanburrbu ngaye, dja kankongibu kunmak kanmarnekurduyimen, ngadjare kanmulewan kore Pharaoh ba ngabebme kondah kururrkbeh. ");
INSERT INTO gup_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kunmekbe yikurduyimen dja ngaye ngandidjirdmey kore Hebrew ngadberre kubolkwarlah, dja kondah Egypt warridj minj njale kunwarre ngayimeninj ngandikurrmengkenh kondah kubolkwarre kore kururrkmunun.” ");
INSERT INTO gup_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wanjh bininj nawu king bimarnekinjeyi manme, bu nungka bimarnekarrebekkang nabuyika nuye bu kamak rowk, wanjh nungka bimarneyimeng Joseph, “Ngaye warridj ngakodjbukirriwam, ngangorrkani kukodj ngardduk basket danjbik manmekenh. ");
INSERT INTO gup_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kaluk kore basket manbu kaddum duninjh, dahkendi manme manbu mankerrikenh manbubuyika nuye Pharaoh, dja mayhmayh birringuni manme kore basketbeh kukodj ngardduk.” ");
INSERT INTO gup_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Wanjh Joseph yimeng, “Kuhni wanjh kakarreyime. Nawu basket danjbik kaluk wanjh kayolyolme kunbarnangarra danjbik. ");
INSERT INTO gup_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kaluk bu minj kabangmeyakmen kunbarnangarra danjbik wanjh Pharaoh ngunbebke dja ngunkomdjobke wanjh ngunkukbarnname kurrulk, dja mayhmayh ngundikukngun.” ");
INSERT INTO gup_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Wanjh bu kunbarnangarra danjbik kaluk Pharaoh nuyeni birthday bu burrbuni kore nungan danginj, nungka mulil marnbom bedberre bininj nawu birrikihkimukni birrimarnedurrkmirri, dja nungka benbenebebkeng bininj nawu bimarnebokani, dja nabuyika nawu bimarnekinjeyi manme, benbenemkang kore bininj nuye nawu birrimarnedurrkmirri birrikihkimukni. ");
INSERT INTO gup_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nawu bimarnebokani nungka king bimarnbom biyawoyhmarnedurrkmirri, bibidkenwoni banikkin. ");
INSERT INTO gup_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Dja nawu bimarnekinjeyi manme, nungka bikukbarnnameng kore kurrulk, kunmekbe yimerranj bu Joseph benbenemarnekarreyolyolmeng. ");
INSERT INTO gup_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Wanjh yiman djamku kuninjkunu karreyimerranj, dja bininj nawu king bimarnebokani minj biburrbuyi Joseph, bidjalbengmidjdanj. ");
INSERT INTO gup_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kaluk rerrikah bu mandjewk bokenh, wanjh Pharaoh kodjbukirriwam. Nungan bukirriburrinj kore yimankek darnkih mankabo Nile dingihdi. ");
INSERT INTO gup_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Wanjh kumekbe nang seven birrikukmak dja birridjurdudjurduh bulikki birrimbidburrinj kore kukabobeh, birringuni kunbak. ");
INSERT INTO gup_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Wanjh kumekbe birribuyikawali seven bulikki birrimbidburrinj yerre nawu birrimowarreni dja birrimurrngbebmerrinj. Wanjh kumekbe birridjarrkdi nawu bulikki rowk, kumekbe kore kurrid ngarre Nile mankabo. ");
INSERT INTO gup_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Wanjh nawu birrimowarreni birrimurrngbebmerrinj bulikki bindikuknguneng bindiyakwong rowk nawu birrikukmakni birridjurdudjurduhni. Wanjh Pharaoh kodjkerrolkkang. ");
INSERT INTO gup_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kaluk nungka yawoyhkeyonginj, wanjh yawoyhkodjbukirriwam. Kumekbe nang seven manburrkkimukni dja manmakni manme djordmerreni kore kundalkkudji. ");
INSERT INTO gup_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Wanjh kumekbe kaluk yerre kolhdebebmerrinj seven manmowarreni manme manbu yiman manmayorrkwurlhkenh kinjeng. ");
INSERT INTO gup_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Wanjh manmekbe manme manbu manmowarreni bindinguneng manbu manmak manburrkkimuk manme, bindiyakwong rowk. Wanjh Pharaoh kodjkerrolkkang, yimerrinj, “A! Ngaye ngakodjbukirriwam.” ");
INSERT INTO gup_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Wanjh kunu bu kukabel nungka kangewarreminj, dja benmarnekayhmeng birriwern rowk bininj nawu birrikurdangni nawu birrini kore Egypt dja mak nawu birrimayaliwernni bininj, dja Pharaoh benmarneyimeng kore kodjbukirriwam, dja minj nangale mak bimarnekarreyolyolmeninj Pharaoh. ");
INSERT INTO gup_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Wanjh bininj nawu wohrnani bedberre nawu benmarnebokani king Pharaoh, nungka bimarneyimeng Pharaoh, yimeng, “Ngaye bolkkime ngabengdayhmeng bu kunwarre ngayimeng. ");
INSERT INTO gup_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Bu ngudda Pharaoh kanbeneduy nawu ngundimarnedurrkmirri, dja kanbenekurrmeng ngaye dja bininj nawu wohrnani bedberre nawu manme ngundimarnekinjeyi, kanbenedangbalhmeng kore kunrurrk nuye bininj nawu kawohrnan bedberre nawu ngundimarnerurrknahnan. ");
INSERT INTO gup_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kaluk ngad nganekodjbukirriwam bu kunkakkudji, nungka dja ngaye nganebebbehkodjbukirriwam manbebbehkarrebuyika. ");
INSERT INTO gup_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Wanjh kumekbe ngarridjarrkni yawurrinj nawu Hebrew, nawu bimarnedurrkmirri bininj nawu kabenmarnewohrnan nawu ngundimarnerurrknahnan. Wanjh bu ngad nganemarneyimeng namekbe Hebrew, nungka wanjh nganbenebebbehmarnekarreyolyolmeng ngarrewoneng kore nganebebbehkodjbukirriwam. ");
INSERT INTO gup_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Dja bu nungka nganbenemarnekarreyolyolmeng wanjh kundjalmekbe kurduyimerranj, ngaye kandurndiweng yawoyhmarnedurrkmirri, dja bininj nawu manme ngunmarnekinjeyi, nungka wanjh yikukbarnnameng kore kurrulk.” ");
INSERT INTO gup_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Wanjh Pharaoh bimunkeweng bininj kabikimang Joseph, wanjh werrkwerrk birribebkeng kore dangbalhmiyindi kubolkwarre kore kururrkmunun. Wanjh bu nungka djawurrkburrinj dja djongburrinj namak, wanjh kumwam bimarnebebmeng king Pharaoh, danginj kumirrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Wanjh Pharaoh bimarneyimeng Joseph, “Ngaye ngakodjbukirriwam, dja minj nangale nganmarnekarreyolyolme, dja ngaye wobekkang bu ngudda yibekkan nawu bininj kakodjbukirrire wanjh ngudda yimarnekarreyolyolme.” ");
INSERT INTO gup_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Wanjh Joseph biwokmey Pharaoh, yimeng, “Ngaye ngawid, dja God ngunmarnekarreyolyolme kunmak ngudda nawu king Pharaoh.” ");
INSERT INTO gup_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Wanjh Pharaoh bimarneyimeng Joseph, “Kanbekka, bu ngakodjbukirriwam wanjh ngaye ngahdi kore kurrid ngarre Nile mankabo, ");
INSERT INTO gup_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","wanjh seven bulikki birridjurdudjurduh dja birrikukmak birrimbidburrinj kore kukabobeh Nile, dja birringuni kunbak. ");
INSERT INTO gup_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Wanjh seven birribuyika bulikki bedmanwali birrimbidburrinj nawu birridjalmowarreni duninjh, birrimurrngbebmerrinj, birrikukyimi yiman minj kab korroko nganayi kore kubolkwarlah Egypt rowk. ");
INSERT INTO gup_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Wanjh bulikki nawu birrimowarreni birrimurrngbebmerrinj, bedda wanjh bindinguneng bindiyakwong nawu seven birridjurdudjurduh bulikki nawu birrimbebmerrinj werrk. ");
INSERT INTO gup_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Dja bu bindinguneng, kunmekbe birridjalkukyimi yiman rerrih minj bindinguyi, dja birridjalmurrngbebmerrinj munguyh, yiman bu kerrngehkenh birrikukyimi. Wanjh ngakodjkerrolkkang.” ");
INSERT INTO gup_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Dja mak nganang bu ngakodjbukirriwam seven manme djordmerreni kore kundalkkudji, kaluk manburrkkimuk dja manmak, ");
INSERT INTO gup_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","dja seven manme manbu manweleberrkni manmowarreni dja mak yiman manmayorrkwurlhmikenh kinjeng, wanjh manmekbe kolhdedangerrinj rerre. ");
INSERT INTO gup_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Wanjh manme manbu manmowarreni bindinguneng manbu seven manmakni. Dja ngaye kuhni ngabenmarneyimeng birrikurdang, dja minj nangale nganmarnekarreyolyolmeninj.” ");
INSERT INTO gup_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Wanjh Joseph bimarneyimeng Pharaoh, yimeng, “Nawu ngudda Pharaoh yikodjbukirriwam wanjh mandjalkudjiwi. God ngunyingkihbengdayhkeng bu baleh darnkih kakurduyime. ");
INSERT INTO gup_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nawu seven birrimak bulikki wanjh ngundimarnemulewan seven mandjewk, dja seven manmak manme wanjh seven mandjewk. Nawu yikodjbukirriwam wanjh mandjalkudji. ");
INSERT INTO gup_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Dja seven nawu birrimowarre bulikki nawu birrimurrngbebmerrinj nawu yerre bindimarnebidburrinj, wanjh ngundimarnemulewan seven mandjewk, dja manbu seven manlarrk manme manbu yiman kunmayorrk wurlhmi kinjeng, manekke warridj wanjh ngundimarneyolyolme seven mandjewk bu kabolkdarlehmen, manme kayakmen kore kubolkwarlah Egypt rowk. ");
INSERT INTO gup_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Wanjh kunmekbe bu ngayimeng ke nawu king Pharaoh, God ngunyingkihbengdayhkeng bu baleh kakurduyime darnkih. ");
INSERT INTO gup_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kaluk kamre seven mandjewk bu manme manwern duninjh karrikarrme kore kubolkwarlah Egypt rowk. ");
INSERT INTO gup_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Dja rerrikah wanjh kamre seven mandjewk bu minj kadjordmen manme, karridjalyawarren rowk. Wanjh bininj kaluk karribengmidjdan kore manme manwern karrikarrmi kore Egypt, kadjalbolkwarremen duninjh. ");
INSERT INTO gup_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Wanjh bu kunmekbe kayimerran kadjewkwarremen rowk, karriyawarren duninjh, wanjh kunmekbekenh kunu kaluk karribengmidjdan kore manwern karrikarrmi. ");
INSERT INTO gup_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Dja bu bokenh yikodjbukirriwam, wanjh kunu ngunbukkan bu nungka God wokrayekworrinj duninjh, dja nungan God darnkih kakurduyime kore ngunbukkang.” ");
INSERT INTO gup_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Mak Joseph yimeng, “Wanjh kunu yidjarrngbu bininj nawu mayalimak dja kaburrbun yeledj kabenmarneyime, dja yikurrmen kawohrnan kore kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Dja mak yibenkurrmen bininj nawu kabirribolknahnan, dja bu mandjewk seven bu manme manwern wanjh bedda kabirrimang yikah manme. Birriwarlahkenh bininj birrika kunkarrngbakmeng manbu manme bedberre, dja mankudji kabindiwon nawu kabirrimang kabirrikarekurrme. ");
INSERT INTO gup_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kaluk bu kamre mandjewk kore manme manwern wanjh manme kabirrimang kabirrikarekurrme bu ngudda Pharaoh yiwohrnan yibenmarneyimen kabirrikarekurrme kore kubolkkihkimuk, wanjh kumekbe kunu kakareyo. ");
INSERT INTO gup_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Manmekbe manme kakareyo ba bu kaluk karringun bu kamre seven mandjewk kore kabolkdarlehmen karriyawarren kore kubolkwarlah Egypt. Kunmekbe yikurduyimen ba minj bininj karridowen bu manmeyak kondah kubolkwarlah Egypt.” ");
INSERT INTO gup_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Bu kunmekbe Pharaoh bekkang nungka dja bininj nuye birrikihkimuk nawu birrimarnedurrkmirri, wanjh birribekkarrinj kamak bu kuhni kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Wanjh Pharaoh bendjawam bedda nawu birrikihkimuk nuye, “Minj nuk nabuyika karringalke bininj yiman nungka Joseph nawu kunmalng God nuye kakarrme?” ");
INSERT INTO gup_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Wanjh kunu Pharaoh bimarneyimeng Joseph, “Bu God kuhni rowk ngunbukkang, minj nangale nabuyika kaburrbun yeledj kabenmarneyime, dja minj nangale mayalimak yiman ngudda. ");
INSERT INTO gup_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ngudda wanjh yibenmarnewohrnan bininj nawu kabirrini kururrk ngardduk, dja bininj rowk ngardduk ngundiwokmarrkmang kore yibenwokrayekwon. Dja ngudda yidjalwohrnan, dja ngaye ngadjalkudji nawu king ngawernhwohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Wanjh Pharaoh bimarneyimeng Joseph, “Yina ngaye kurrmeng ngudda yiwohrnan kubolkwarlah rowk Egypt.” ");
INSERT INTO gup_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Wanjh Pharaoh bidyerrkkerrinj nawu biddjongbuyindi nawu nungan king ngeydi, dja bibiddjongbom Joseph, dja bidjongbom manburrba namak duninjh, dja bimangiwong wirlmurrng gold chain. ");
INSERT INTO gup_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Dja bikurrmeng karrahkenhdi kore wirlbarra, nungka king nuye nawernhmakni dja Joseph nuye manmakni rerrih. Wanjh bininj birrikayhmeng nuye Joseph bu kumhrey, “Ngurrimarnewayhmen.” Kunu wanjh bimarnbom kawohrnan kubolkwarlah rowk Egypt. ");
INSERT INTO gup_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Dja mak Pharaoh bimarneyimeng Joseph, “Ngaye wanjh Pharaoh, dja bu ngudda minj yibenmarnekodjduhme bininj, minj baleh kabirrikurduyime kore kubolkwarlah rowk Egypt.” ");
INSERT INTO gup_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Wanjh Pharaoh bingeykurrmeng Joseph Zaphenath-paneah, dja biwong daluk benemarrinj ngalbu ngeyyoy Asenath, ngalbeywurd nuye Potiphera nawu wohrnani yiwarrudj bedberre kore kunred On. Wanjh Joseph rey kubolkbubuyika rowk kore kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph wanjh mandjewk nuyeni thirty bu dedjdjingmey bimarnedurrkmirri king Pharaoh nawu wohrnani kore Egypt. Wanjh Joseph bu di kore Pharaoh wanjh bebmeng, dja wam rengehrey kore kubolkbubuyika rowk kore kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Wanjh bu mandjewk seven manme manwern djordmerreni, manwern duninjh, ");
INSERT INTO gup_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","dja nungka manme mangi bu mandjewk seven kore manwern birrikarrmi kore Egypt, dja nungka karekurrmi kore kubolkkihkimuk. Kore kubolkkihkimukbubuyika nungka bebbehkarekurrmi manme manbu djordmerreni kumekbe kore kabbal darnkih kore kubolkkimuk, kudjalmekbe darnhkarekurrmi. ");
INSERT INTO gup_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Wanjh Joseph karekurrmi manmim mandjalwernkenh duninjh, yiman kamirndeyime kunkayalanj kore kurrid kurrula, kaluk minj munguyh bimbuyi rohrokmeninj, dja manwern duninjh, minj nangale rohrokmeninj. ");
INSERT INTO gup_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bu minj kumbangmeyimerrangimeninj bu mandjewk kawarremen, wanjh Joseph benbenebornang bebeywurd bokenh. Asenath ngalbeywurd nuye Potiphera nawu bininj yiwarrudj wohrnani bedberre kunred On, ngalmekbe Asenath bimarneyawmey Joseph. ");
INSERT INTO gup_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph bingeykurrmeng nadjdjaman Manasseh. Dja yimeng, “Kunmekbe ngangeykurrmeng bu God nganmarnbom ngabengmidjdanj kunmurrngrayek ngardduk, dja mak yiman ngabenbengmidjdanj nawu ngarrimud.” ");
INSERT INTO gup_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Dja nawu nawalawalak nungka wanjh bingeykurrmeng Ephraim. Dja nungka yimeng, “Kunmekbe ngangeykurrmeng bu God nungka nganmarnbom ngayerdwernminj kore kondah kubolkwarlah kore nganjilngwarreni.” ");
INSERT INTO gup_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Wanjh mandjewk seven bu manme manwernni kore kubolkwarlah Egypt kaluk yakminj, ");
INSERT INTO gup_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","dja dedjdjingmey bu seven mandjewk bininj birriyawarrinj manme bu Joseph yimeng. Kubolkbubuyika rowk birriyawarreni, dja kore kubolkbubuyika rowk kore kubolkwarlah Egypt wanjh manme yongohyoy. ");
INSERT INTO gup_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kaluk bu birriwernhmarrwedoweni bininj kore Egypt rowk, wanjh kunnalk dorrenghni bininj birrikayhmi Pharaoh, birridjawani manmekah. Dja Pharaoh benmarneyimeng rowk bininj nawu Egyptbeh, “Ngurriray kore Joseph, dja bu baleh ngunmarneyime, kunmekbe ngurrikurduyimen.” ");
INSERT INTO gup_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Wanjh bu warlahminj manme birriyawarreni kubolkwarlah rowk Egypt, Joseph dangmarrhmey kunrurrk rowk kore manme karehkareyoy, dja weykani bedberre bininj nawu Egyptbeh. Dja djewkwarreminj duninjh, meyakminj kore kubolkwarlah Egypt rowk. ");
INSERT INTO gup_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Dja mak bininj birrimdolkkarrinj kubolkbubuyika rowk, birrimrey kore Egypt kore Joseph mimweykahweykani. Kunmekbe birrikurduyimi bu birriyawarreni duninjh kubolkbubuyika rowk kurorre. ");
INSERT INTO gup_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Bu Jacob bekkang manme manbu manmim birrikarrmi kore Egypt, wanjh nungka benmarneyimeng bebeywurd nuye, yimeng, “Njalekah ngudda ngurrihdjalkuknarren?” ");
INSERT INTO gup_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Dja mak yimeng, “Kandibekka, ngaye ngabekkang bu manmim kabirrikarrme kore Egypt. Ngurriray kumekbe dja ngurrikan kunwardde ngurrimimmang kadberre, ba kunu karridarrkid dja minj karridowen.” ");
INSERT INTO gup_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Wanjh ten nawu Joseph birridangerrinj birriwam kabirrimang manmim kore Egypt. ");
INSERT INTO gup_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Dja Jacob keleni bu Benjaminj birridjarrkrawinj, marndi baleh yarrkka kunyid biwohmarnengalmeninj, wanjh kunmekbekenh kunu nungka minj bimunkewemeninj Benjaminj nawu Joseph ngalbadjan ngalkudji berrewoneng. ");
INSERT INTO gup_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Wanjh kunu Israel nuye bebeywurd birrimdjarrkbebmeng birribuyika bininj nawu birrimwam kabirrimang manmim, dja manme birriyawarreni kore kubolkwarlah Canaan warridj. ");
INSERT INTO gup_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Kaluk Joseph wohrnawohrnani kore kubolkwarlah Egypt, dja nungka wanjh mimweykani bedberre bininj rowk. Wanjh kunu bu Joseph nuye birridangerrinj birribebmeng, birrimarneboddanj kanjdji birrirorrenani. ");
INSERT INTO gup_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Bu Joseph bennang nawu birridanginj nuye, wanjh kundjalmekbe benkukburrknang, dja bu baleh yarrkka benhmarneyimi, wanjh yiman yerreh benkukwakwani, dja warridj bu wokdi bedberre wanjh yiman yerreh benduy, dja bendjawam, “Ngudda balehbeh ngurrimdolkkang?” Bedda birriwokmey, “Ngad ngarrimdolkkang kubolkwarlah Canaan, manme ngarridjare ngarrimang.” ");
INSERT INTO gup_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kaluk Joseph benkukburrknang nawu birridanginj, dja bedda minj nungka birrikukburrknayi. ");
INSERT INTO gup_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Wanjh nungka bengdayhmeng bu korrokoni benbukirribom. Wanjh benmarneyimeng, “Ngudda ngurrimwam ngurribolknabolknan, wardi ngurribolkyawan kore baleh yimankek ngurrimkuningimen kandibun!” ");
INSERT INTO gup_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bedda birriwokmey birriyimeng, “Ngudda nawu yiwohrnan, burrkyak, ngad nawu ngarrimarladj, ngad wanjh ngarrimwam manme ngarrimang. ");
INSERT INTO gup_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ngad wanjh kornkumo nadjalkudji ngadberre, ngad nawu ngarrimarladj wanjh ngarriwoybuk, minj ngarrimrawinj ngarribolknabolknankenh.” ");
INSERT INTO gup_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Wanjh nungka yimeng bedberre, “Burrkyak, dja ngurrimwam ngurribolkyawan kore baleh yimankek ngurrimkuningimen kandibun” ");
INSERT INTO gup_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Dja bedda birrimarneyimeng, “Ngad nawu ngarrimarladj wanjh twelve ngarridangerrinj, kornkumo nakudji ngadberre, nawu kani kore kubolkwarlah Canaan. Yina, nawu nayahwurd duninjh bolkkime kabenedjarrkni Ngabbard, dja nakudji yakminj.” ");
INSERT INTO gup_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph benmarneyimeng, “Wanjh yiman ngaye ngayimeng ngudberre, ngudda ngurrimwam ngurribolknabolknan. ");
INSERT INTO gup_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Dja kuhni wanjh ngakurduyime rohrokme ngudberre. Ngawokrayekworren Pharaoh nuye kunngey dorrengh, bu nayahwurd minj kamre, ngudda minj kondah ngurribolkbawon. ");
INSERT INTO gup_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ngurrimunkewemen nakudji kabimkan ngurridanginj nawu nayahwurd, dja ngurribuyika ngurridangbalhmiyindi kore prison, ba kunu kunwok ngudberre ngarohrokme, ngaburrbun bu ngudda kunwoybuk ngurriwokdi. Dja bu burrkyak, wanjh ngawokrayekworren kore Pharaoh kunngey dorrengh bu ngudda woybukkih ngurrimwam ngurribolknabolknankenh.” ");
INSERT INTO gup_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Wanjh nungka bendangbalhmeng rowk bu kunbarnangarra danjbik. ");
INSERT INTO gup_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Kaluk bu kunbarnangarra danjbik Joseph benmarneyimeng, “Kuhni ngurrikurduyimen dja ngurridarrkid, dja ngaye ngamarnekele God. ");
INSERT INTO gup_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Bu ngudda bininj nawu ngurriwoybuk wanjh nakudji nawu ngurridanginj dangbalhmiyindin kondah kore prison, dja ngurribuyika nawu wanjh ngurridurnderren, dja manmim ngurrikan bedberre nawu kabirrini kured ngudberre nawu kabirrihmarrwe. ");
INSERT INTO gup_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Dja ngurrimdjalka nayahwurd duninjh ngurridanginj, ba kunu kunwok ngudberre ngaburrbun kunwoybuk, dja minj ngurridowen.” Wanjh bedda birrimarnekodjdukmeng. ");
INSERT INTO gup_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Dja bedda birrimarneyimerrinj, “Woybukkih wanjh ngad kunwarre karrimarneyimeng nawu karridanginj. Ngad karrinang nungka kangewarreni bu nungka kandjawadjawani kadberre bu minj karribuyi, dja ngad minj karrimarrkmayi, wanjh kunmekbekenh kunu karrikangewarre, kuhni kurduyimerranj kadberre.” ");
INSERT INTO gup_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben benwokmey, “Ngaye ngayimeng ngudberre, ‘Yuwn kunwarre ngurrimarneyime nawu yawurrinj.’ Dja ngudda minj kandimarrkmayi, wanjh bolkkime ngadmanwali kunwarre kumwam kadberre bu kunkurlba nuye karremulewayindanj.” ");
INSERT INTO gup_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Bedda minj birriburrbuyi bu Joseph benbekkani, dja nungka bu wokdi bedberre wanjh kunwokbuyika kunwok wokdi, dja nabuyika biwokmulewani benmarneyolyolmi bu bedberrekih kunwok. ");
INSERT INTO gup_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Wanjh nungka Joseph benbodmekenhwong dja dedjdjingmey nalkbuni, dja kaluk benmarneborledmeng yawoyhwokdi bedberre. Dja benmarneyimeng bininj nuye birrimey Simeon birridukkang kore kumirrk bedberre nawu birridanginj. ");
INSERT INTO gup_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph benwokrayekwong bininj nuye kabindimarnebarlke baladji bedberre nawu birridanginj nuye, manmim kabirridahkendong, dja kunwardde kabindibebbehmarnedurndiwe kore baladji bedberre, dja mak kabindiwon manme kabirrirekenh. Bu kuhni bindimarnekurduyimeng, ");
INSERT INTO gup_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","bedda manmim birridelengkurrmeng kubodme kore donkeys bedberre, wanjh birriwelengbolkbawong. ");
INSERT INTO gup_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Bu kukak birriwohyonginj wanjh kumekbe nakudji dangmarrhmey baladji nuye, manme kabiwon donkey nuye, wanjh nungka nang kunwardde nuye yongohyoy kore kurrangmaye baladji! ");
INSERT INTO gup_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Wanjh benmarneyimeng nawu birridanginj, yimeng, “Kunwardde ngardduk ngandimarnedurndiweng. Kondah kahyo kore baladji ngardduk.” Wanjh bedda birrikangewarreminj dja birriborledmerrinj birrideldelmeng dja birriyimeng, “Baleh kuhni bu God kanmarnekurduyimeng kadberre?” ");
INSERT INTO gup_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bu birrimarnebebmeng kornkumo bedberre nawu Jacob kore kubolkwarlah Canaan, wanjh birrimarneyimeng rowk nawu benmarnekurduyimerranj. Birriyimeng, ");
INSERT INTO gup_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Bininj nawu kawohrnan kumekbe kubolkwarlah, yiman yerreh kanduy ngadberre, kanmarneyimeng yiman bu ngad ngarriwam ngarribolknahbolknanikenh. ");
INSERT INTO gup_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kunmekbe nungka yimeng ngadberre, dja ngad ngarrimarneyimeng, ‘Ngad ngarriwoybuk bininj, minj ngarrimrawinj ngarribolknabolknankenh, ");
INSERT INTO gup_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","dja ngad twelve ngarridangerrinj, kornkumo nakudji ngadberre. Nakudji yakminj, dja nawu nayahwurd duninjh bolkkime kabeneni Ngabbard kore Canaan.’ ");
INSERT INTO gup_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kunmekbe ngarriyimeng, wanjh namekbe bininj nawu kawohrnan kumekbe kubolkwarlah kanmarneyimeng ngadberre, ‘Kuhni wanjh ngaburrbun bu nguddambu ngurriwoybuk bininj. Ngurribawo nakudji nawu ngurridanginj kondah kore ngaye nganeni, dja ngurrika manme bedberre nawu ngurrihdjarrkni kured nawu kabirrimarrwe dja ngurridurnde. ");
INSERT INTO gup_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Dja ngurrimka nawu nayahwurd duninjh ngudberre nawu ngurridanginj, ngurrimka kore ngaye ba kunu ngaye ngaburrbun bu ngudda minj ngurrimrawinj ngurribolknabolknankenh, dja ngudda wanjh ngurriwoybuk bininj. Wanjh kunu marnedurndiwe ngudberre nawu ngurridanginj, dja ngudda kamak ngurrire baleh yarrkka kondah kubolkwarlah dja ngurribayahme dja mak ngurriweykan njalehnjale.’” ");
INSERT INTO gup_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bu bedda birriyakwong bu birrimarneyimi kornkumo, wanjh bedda birriwelengyakbom manme, wanjh birribebbehdobbokenhnang kunwardde bedberre benmarnebebbehyoy kore baladji bedberre! Bu bedda dja kornkumo bedberre birridobbokenhnang nawu kunwardde wanjh birrikeleminj. ");
INSERT INTO gup_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Wanjh Jacob nawu kornkumo bedberre benmarneyimeng, “Ngudda kandibeywurdyakwon. Joseph yakminj, Simeon yakminj, dja bolkkime ngurridjare ngurrikan Benjaminj. Kuninjkunu wanjh nganmarnekurduyimerranj kunwarre duninjh.” ");
INSERT INTO gup_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Wanjh Reuben bimarneyimeng kornkumo, yimeng. “Bu ngaye minj ngamyirrurndeng ke Benjaminj wanjh bonj, ngardduk beywurd bokenh yibenbenebun. Kanwo Benjaminj nganahnan dja ngaye ngamyirrurndeng ke.” ");
INSERT INTO gup_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Dja Jacob yimeng, “Beywurd ngardduk minj kumekbe ngurridjarrkre, nawu benedanginj ngalbadjan ngalkudji berrewoneng doweng ngokko, dja nungka nadjalkudji kahdi. Bu yimankek ngurrire, nungka baleh yarrkka kunyid kabiwohmarnengalme, wanjh kunu kandimarnbun ngaye nawu ngabulu, kunnjilngwarre dorrengh ngarrowen ngamalngre kore Sheol.” ");
INSERT INTO gup_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kaluk manme birridjalyawarrinj bulkkidj kumekbe kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Wanjh kunu bu bedda birringuneng rowk manmim manbu birrimey kore Egypt, wanjh kornkumo bedberre benmarneyimeng, “Ngurridurnde dja ngurrimyawoyhmang manyahwurd manme kadberre.” ");
INSERT INTO gup_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Wanjh Judah bimarneyimeng, yimeng, “Nawu bininj kanwokrayekwong ngadberre, yimeng bu ngarridanginj minj ngarrikan wanjh nungka minj ngarriyawoyhkebnan. ");
INSERT INTO gup_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wanjh Ngabba, bu ngudda yimunkewe nawu ngarridanginj ngarridjarrkre, wanjh kunu ngarrire ngundimarnemang manme. ");
INSERT INTO gup_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Dja bu minj yimunkewe, wanjh kunu minj ngarrire, dja namekbe bininj kanmarneyimeng ngadberre bu minj ngarrikan nawu ngarridanginj, wanjh minj nungka ngarriyawoyhkebnan.” ");
INSERT INTO gup_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Wanjh Israel bendjawam, “Njalekah kunmekbe kandimarnekurduyimeng bu kunwarre, ngurrimarneyimeng namekbe bininj bu ngurrikarrme nabuyika nawu ngurridanginj?” ");
INSERT INTO gup_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bedda birriwokmey birriyimeng, “Nungka kandjawadjdjawani munguyh ngadkenh dja nawu karrimud, bu yimeng, ‘Yiddok kornkumo ngudberre kadjaldarrkid?’ dja, ‘Yiddok nabuyika ngurrikarrme nawu ngurridanginj?’ Dja ngadbu ngarridjalwokmawokmangi kore kandjawadjdjawani ngadberre. Minj nuk ngarriburrbuyi nungka yimeninj, ‘Kondah yimka nawu ngurridanginj.’” ");
INSERT INTO gup_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Wanjh Judah bimarneyimeng kornkumo nuye nawu Israel, yimeng, “Yimunkewemen yawurrinj bu ngaye ngakan, wanjh ngarrire werrk ba ngad dja ngudda dja wurdwurd ngadberre karridjaldarrkid, dja minj karridowen. ");
INSERT INTO gup_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ngaye ngayeman ngawokkurrmerren nganahnan kamak rowk, ngudda kanwo ngaye nganahnankenh. Bu ngaye minj ngamdurndiwe ke kondah yiyawoyhdarrkidnan, wanjh ngaye kandjalwelengnamen munguyh bu ngarrarrkid. ");
INSERT INTO gup_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Dja bonj bu minj karridenghkerrimeninj, ngarrirawinj dja ngarrimdurndeyi bokenhkah.” ");
INSERT INTO gup_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Wanjh Israel nawu kornkumo bedberre benmarneyimeng, “Bu yiman bu ngurridjalle, wanjh kuhni ngurrikurduyimen. Ngurridahkendo kore baladji ngudberre yikahwi nawu namakmak, nawu kondah kubolkwarlah karrikarrme, dja ngurrikan ngurriwon burudjang namekbe bininj, ngurrikan manyahwurd balm manbu karrikukdelkkerrenkenh, dja nayahwurd mankung, dja mak manmanjmak spice dja myrrh, dja pistachio nut dja almond. ");
INSERT INTO gup_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dja bokenh kunwardde ngurribebbehkan, dja ngurriwon kunwardde nawu ngundimarnedurndiweng kore kurrangmaye baladji ngudberre. Kunubewu mungu ngundimarnedurndiweng ngudberre. ");
INSERT INTO gup_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dja ngurrika warridj nawu ngurridanginj, dja ngurridjaldurnde kore namekbe bininj werrkwerrk. ");
INSERT INTO gup_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Dja ngadjare God nawu Ngudjkimuk Duninjh kabimarnbun ngunkongibun namekbe bininj, ba nungka kabimmunkewe nabuyika nawu ngurridanginj, dja Benjaminj dorrengh ngurrimdjarrkdurndeng. Dja ngaye bu ngandimarnedowen wurdwurd, wanjh bonj ngandidjalmarnedowen.” ");
INSERT INTO gup_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Wanjh kunu bedda nawu bininj birrikang nawu kabirriwon burudjang, dja mak kunwardde bokenh manbu birringalkeng kore baladji bedberre, dja mak Benjaminj warridj birrikang. Bedda birridokorrokmeng birriwam kore Egypt dja birrimarnebebmeng Joseph, birridanginj kumirrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Bu Joseph bennang Benjaminj dorrengh, nungka bimarneyimeng bininj nawu bimarnedurrkmirri kunrurrk nuye, yimeng, “Nanih nawu bininj yibenka kore ngardduk kunrurrk, yibu mayh, dja manme yiyingkihmarnbu, bedda wanjh ngarridjarrkngun bu barnangarraburrk.” ");
INSERT INTO gup_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Namekbe bininj kurduyimeng kore Joseph bimarneyimeng, dja benkang bedda nawu birridangerrinj kore Joseph nuye kunrurrk. ");
INSERT INTO gup_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wanjh bedda nawu birridangerrinj bu benkang kore Joseph nuye kunrurrk wanjh kunu birrikeleminj, bedda birrimarneyimerrinj, “Bu kerrngehkenh kunwardde birrimdurndiweng kadberre birridahkendoy kore baladji, wanjh kunmekbekenh kunu kondah kankang kadberre. Nungka kadjare kandarrkidmang kadberre dja kanmarnbun bu karrimarnedurrkmirri, dja mak kamang donkey kadberre.” ");
INSERT INTO gup_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Wanjh kunu bedda birriwam kore namekbe bininj nawu bimarnedurrkmirri Joseph, birriwokdi nuye kore kururrkdangmaye bu birribalhngimi, ");
INSERT INTO gup_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","birriyimeng, “Ngudda nawu yiwohrnan, ngad ngarrimwam kondah kerrngehkenhni manme ngarrimey. ");
INSERT INTO gup_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Dja bu ngarriwam ngarriwohyonginj kukak, baladji ngadberre ngarridangmarrhmey, ngarribebbehkukngalkeng kunwardde rowk nawu ngarriwong manmekenh, wanjh yongohyoy kore kurrangmaye baladji. Wanjh ngarrimkang ngarrimyawoyhdurndiweng. ");
INSERT INTO gup_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Dja ngad ngarrimkukkang warridj nabuyika kunwardde nawu manmekenh ngarrimang. Ngad ngarriwakwan bu nangale baladji dorrengh warddedurndiweng ngadberre.” ");
INSERT INTO gup_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Wanjh nungka yimeng, “Bonj kamak, yuwn ngurrikele. Nawu God ngudberre dja nuye kornkumo nawu ngudberre, nungka ngunwong namakmak kore baladji ngudberre. Dja ngaye wanjh ngayingkihmey nawu kunwardde ngudberre.” Bu kuhni yimeng wanjh nungka Simeon bimbebkeng bedberre. ");
INSERT INTO gup_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Namekbe bininj nawu Joseph bimarnedurrkmirri benngimewong kore Joseph nuye kunrurrk, benbowong kukku birridengedjirridjburrinj, dja benwong manme donkey bedberre birringuni. ");
INSERT INTO gup_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bedda nawu birridangerrinj birribekkang bu kaluk manme kabirringun kumekbe, wanjh kunu birriyingkihmarnbom nawu kabirriwon Joseph burudjang bu nungka kambebme barnangarraburrk. ");
INSERT INTO gup_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Bu Joseph kumdokmeng kured, bedda birriwong burudjang nawu birrimkang kururrk, dja birrimarneboddanj kanjdji kurorre. ");
INSERT INTO gup_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nungka bendjawam bu yimankek birrimak, dja wanjh nungka yimeng, “Dja nawu nakohbanj kornkumo ngudberre nawu kandimarneyolyolmeng, yiddok nungka kamak? Yiddok munguyh kadjaldarrkid?” ");
INSERT INTO gup_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wanjh bedda birriwokmey birriyimeng, “Nungka nawu yiman namarladj nawu kornkumo ngadberre, nungka wanjh kadjaldarrkid dja kamak kani.” Wanjh bedda birrimarneboddangeni birrikukenhmi. ");
INSERT INTO gup_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Bu nungka Joseph bolknang dja binang Benjaminj nawu nungka benedanginj, ngalbadjan ngalkudji berrewoneng, nungka bendjawam, “Yiddok nahni nawu nayahwurd duninjh ngudberre nawu ngurridanginj nawu kandimarneyolyolmeng?” Dja mak bimarneyimeng Benjaminj, “Ngudda nawu yawurrinj, ngadjare God ngunmarnekurduyime kunmak.” ");
INSERT INTO gup_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Wanjh bu binang namekbe nawu benedanginj, nungka Joseph bimarnekangenalkbom duninjh, wanjh nungka djalbebmeng werrkwerrk bolkyawam ba kanalkbunkenh. Nungka ngimeng kore nungan nuye kunrurrk kore yongohyoy, dja kumekbe bimarnenalkbom. ");
INSERT INTO gup_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kaluk bu kebdjirridjburrinj rowk wanjh nungka kumbebmeng, kangerayekworrinj dja yimeng bedberre nawu birrimarnedurrkmirri, “Ngurrimka manme.” ");
INSERT INTO gup_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nungka nakudjihkudji ni dja birriwong manme, dja nawu birridanginj, bedman birridjarrkni bebbehbeh birringuni, dja bininj nawu Egyptbeh nawu kumekbe birringuneng, bedman bebbehbeh birridjarrkni. Kunmekbe birriyimi bu bininj nawu Egyptbeh minj kabirridjarrkngun nawu Hebrew bininj, dja bininj nawu Egyptbeh kabirriwarnyak duninjh kabirridjarrkngun. ");
INSERT INTO gup_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wanjh nawu birridanginj bedda bu Joseph nuye bininj benmarneyimeng kabirriyerrkan birrimirrkmey, wanjh benbolkbukkang kore birriyerrkarrinj, nawernwarre werrk yerrkang, yerre walawalakko, yerre wanjh nayahwurd duninjh balyerrkang. Wanjh kunu birrinarrinj dja birrikangebarrhmeng. ");
INSERT INTO gup_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Bu manme bindimarnemey kore Joseph nungka ni, wanjh Benjaminj nuyeni manme mandjalwern duninjh. Wanjh mulil bedda birridjarrknguneng bu Joseph dorrengh, birribonguneng warridj, birrinjilngmarnburreni. ");
INSERT INTO gup_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Wanjh Joseph biwokrayekwong bininj nawu bimarnedurrkmirri kururrk nuye, yimeng, “Nanih nawu bininj baladji bedberre yibenmarnebarlkemen, manme yibenmarnedahkendo, yirohrokmen manwern duninjh manbu darnkih kabirribarabun kabirringorrkan. Dja yibenbebbehmarnedurndiwemen kunwardde bedberre, yikurrmen kore kurrangmaye baladji bedberre. ");
INSERT INTO gup_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Wanjh yikurrmen ngardduk banikkin nawu silver, kore kurrangmaye baladji nuye nawu nayahwurd duninjh, dja kunwardde dorrengh nuye yikurrmen nawu nungka karremulewam manmimkenh nuye.” Wanjh nungka djalkurduyimeng rowk nawu Joseph bimarneyimeng. ");
INSERT INTO gup_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Wanjh bu kumbarrhbuni, nani nawu bininj nawu birridangerrinj, wanjh bindimunkeweng donkey dorrengh bedberre kabirrire. ");
INSERT INTO gup_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Minj djarreh birribolkbawoyi kubolkkimuk bu Joseph bimarneyimeng namekbe bininj nawu bimarnedurrkmirri, yimeng, “Werrkwerrk yibenkadju birrimekbe bininj dja bu yibenmarnebebme yibenmarneyimen, ‘Njale ngudda ngurrimarneyimeng kunwarre nawu nungka kunmak ngunmarneyimeng? Dja njalekenh ngurridjirdmey nawu silver banikkin nuye? ");
INSERT INTO gup_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Dja wanjh namekbe nawu banikkin wanjh nanu nuye nawu nganmarnewohrnan kahbongubongunkenh, dja mak mankurdangkenh kahbonanganan ba bu kaburrbun baleh bininj kabirrikurduyime. Kuhni wanjh kunwarre duninjh ngudda ngurrikurduyimeng.’” ");
INSERT INTO gup_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wanjh bu nungka bebmeng bedberre, kuhni kunwok rowk nungka benmarneyimeng. ");
INSERT INTO gup_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Dja bedda birrimarneyimeng, “Njalekah ngudda nawu kanmarnewohrnan kuhni kunwok yiyime? Ngad nawu ngarrimarladj, minj yiman kunmekbe ngarrikurduyime. ");
INSERT INTO gup_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Dja warridj ngarrimdurndiweng ngudberre kubolkwarlah Canaanbeh kunwardde nawu ngarringalkeng kore baladji ngadberre, wanjh kunu njalekah yimankek ngarridjirdmang silver mak gold nawu kayo kore kunrurrk nuye nawu ngunmarnewohrnan? ");
INSERT INTO gup_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bu yingalke kore ngad nawu ngarrimarladj, wanjh namekbe nawu kakarrme, bonj, karrowen dja ngarribuyika ngundimarnedurrkmirri ngudda nawu kanmarnewohrnan.” ");
INSERT INTO gup_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Wanjh nungka yimeng, “Kunu bonj, dja bu ngangalke nawu nangale kakarrme, wanjh namekbe nanu nganmarnedurrkmirri, dja ngurribuyika wanjh bonj, minj biwelengname ngudberre.” ");
INSERT INTO gup_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Wanjh werrkwerrk bedda rowk birribebbehkoluyhweng baladji bedberre kurorre dja birridangmarrhmey. ");
INSERT INTO gup_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Wanjh namekbe bininj nawu bimarnedurrkmirri Joseph dedjdjingmey yawahyawani. Wanjh yawam kore nawernwarre werrk, djalwam kore walawalakko rowk, dja yerre duninjh yawam kore nayahwurd duninjh nuye. Dja banikkin badngalkeng kore Benjaminj nuyeni baladji! ");
INSERT INTO gup_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bu kuhni yimeng bu ngalkeng wanjh bedda birrimadjdjalkmarrinj manburrba bedberre nawu birridjongbuyindi, wanjh birriyawoyhkurrmeng baladji bedberre kore kubodme donkey dja birridurndi kubolkkimuk. ");
INSERT INTO gup_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Bu Judah dja nawu birridanginj birrimbebmeng kore Joseph nuye kunrurrk, wanjh Joseph kumekbe djahdjalni, dja bedda birrimarnemankarrinj kore kurorre. ");
INSERT INTO gup_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Wanjh Joseph benmarneyimeng, “Njale kuhni bu ngudda ngurrikurduyimeng? Minj nuk ngurriburrbun bu bininj nawu yiman ngaye wanjh ngarrikurdang, ngarrikarrme nawu kanbukkan baleh bininj ngurrikurduyime, bebke ngudberre?” ");
INSERT INTO gup_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Wanjh Judah yimeng, “Njale nuk ngad ngundimarneyime ngudda nawu kanmarnewohrnan? Njale nuk ngarriyime? Baleh yimankek ngarrikurduyime ngarrimulewarren bu minj kuhni ngarriyimeninj? God nungka nganmarnekarrebebkeng bu kunwarre ngarriyimeng ngad nawu ngarrimarladj. Wanjh kumekbe ngad kaluk ngundimarnedurrkmirri ngudda nawu kanmarnewohrnan, ngad dja nungka warridj nawu bimarnengalkeng banikkin karrmi.” ");
INSERT INTO gup_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Dja Joseph yimeng, “Kunukka minj ngaye ngakurduyime! Nadjalkudji nganmarnedurrkmirri namekbe bininj nawu bimarnengalkeng banikkin karrmi, dja nguddambu bonj, kunmodmikenh dorrengh ngurridurnde kore kornkumo ngudberre.” ");
INSERT INTO gup_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Wanjh Judah biyikang darnkih dja yimeng, “Ngudda nawu kanmarnewohrnan, ngaye nawu ngamarladj, wanjh djawan kanbawo ngawokdi ke ngudda nawu kanmarnewohrnan, dja yuwn kandung ngaye nawu ngamarladj, dja madjamku ngudda yiman ngunerohrok yerreh nungan nawu Pharaoh. ");
INSERT INTO gup_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ngudda nawu kanmarnewohrnan, ngudda kandjawam ngad nawu ngarrimarladj, ngudda yiyimeng, ‘Yiddok ngurrikarrme kornkumo, dja nuk nawu ngurridanginj?’ ");
INSERT INTO gup_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Dja ngad ngundimarneyimeng, ‘Ngad ngarrikarrme kornkumo nawu nakohbanj, dja mak ngarridanginj nawu nayahwurd duninjh, nawu bimarnedanginj Ngabbard bu kohbanjminj. Nawu benedanginj nuye wanjh doweng dja nungka nadjalkudji kahdi nawu ngalbadjan ngalkudjihni berrewonengni, dja Ngabbard kabimarnedjare bulkkidj.’” ");
INSERT INTO gup_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Wanjh ngudda kanmarneyimeng ngadberre nawu ngarrimarladj, yiyimeng, ‘Yimka kondah kore ngaye, ba ngaye ngakuknan nganan kumim ngardduk.’ ");
INSERT INTO gup_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Dja ngad ngundimarneyimeng nawu kanmarnewohrnan, ngarriyimeng, ‘Nungka nawu yawurrinj minj kabibawon Ngabbard, dja bu kabibawon wanjh kunu Ngabbard nawu karrowen.’ ");
INSERT INTO gup_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Wanjh ngudda kanmarneyimeng ngadberre nawu ngarrimarladj, yiyimeng bu minj ngarrimdjarrkre nawu ngarridanginj nayahwurd duninjh ngadberre, ngad minj ngundiyawoyhkebnan. ");
INSERT INTO gup_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Wanjh bu ngad ngarridurndi kore nungka nawu namarladj nawu Ngabbard, ngad ngarrimarneyimeng kunwok rowk nawu ngudda nawu kanmarnewohrnan yiyimeng ngadberre.” ");
INSERT INTO gup_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Wanjh kaluk bu Ngabbard ngadberre yimeng, ‘Ngurriyawoyhray, ngurrima kadberre manyahwurd manme.’ ");
INSERT INTO gup_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Wanjh ngad ngarrimarneyimeng, ‘Minj ngarrire. Bu nayahwurd duninjh ngarridjarrkre, wanjh kunu ngarrire, dja minj ngarriyawoyhkebnan namekbe bininj bu minj nungka dorrengh nayahwurd duninjh ngarridjarrkre.’ ");
INSERT INTO gup_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Wanjh kunu nungka nawu namarladj nawu Ngabbard, wanjh kanmarneyimeng ngadberre, yimeng, ‘Ngudda ngurriburrbun bu ngalbu ngalbininjkobeng ngardduk nganmarneyawmey narahrangem bokenh. ");
INSERT INTO gup_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Nakudji nganbawong dja ngayimeng woybukkih wanjh mayh bikukdjalkdjalkmey, dja minj ngayawoyhnayi. ");
INSERT INTO gup_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Bu ngurrikan nahni warridj, nganbawon dja bu yimankek baleh yarrkka kunyid kabiwohmarnengalme, ngudda wanjh kandimarnbun ngaye nawu ngabulu, wanjh kunnjilngwarre dorrengh ngarrowen, ngamalngre kore Sheol.’” ");
INSERT INTO gup_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Kuhni yimeng Judah biyolyolmeng kornkumo, wanjh mak yimeng nawu Judah, “Kunmekbekenh wanjh bu ngamarnebebme nungka nawu namarladj Ngabbard, dja namekbe nawu yawurrinj minj ngarridjarrkre, wanjh kunu nungka bu kannan ngadberre nungka yak, nungka wanjh karrowen, dja ngad ngarrimarnbun nungka nawu namarladj Ngabbard ngadberre nawu bulu, kunnjilngwarre dorrengh karrowen kamalngre kore Sheol. Kunmekbe kayimerran bu nungka wanjh yiman kabidjalburrbun nawu yawurrinj, nungka kabidjalmarnemimbi. ");
INSERT INTO gup_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Dja ngaye nawu ngamarladj, ngayeman ngawokkurrmerrinj nuye nawu yawurrinj bu Ngabbard ngamarneyimeng, ‘Bu ngaye minj ngamdurndiwe ke, wanjh kunu ngaye kandjalwelengnamen ngudda Ngabba munguyh bu ngamimbi.’” ");
INSERT INTO gup_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Wanjh kunu Judah yimeng, “Kunmekbekenh wanjh ngaye nawu ngamarladj wanjh djawan, ngaye kondah ngahni nungkakenh nawu yawurrinj, dja marnedurrkmirri ngudda nawu kanmarnewohrnan, dja nungka bonj, yibawo karrurndeng, nawu ngarridanginj birridjarrkdurnde. ");
INSERT INTO gup_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Dja minj mak ngaye baleh ngayime ngarrurndeng kore Ngabbard bu nawu yawurrinj minj nganedjarrkre. Ngaye minj ngadjare nganan kunnjilngwarre Ngabbard nuye.” ");
INSERT INTO gup_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Wanjh Joseph minj munguyh kangerayekworrimeninj kore bininj kumirrk bedberre nawu birrimarnedurrkmirri. Wanjh kunu nungka kayhmeng yimeng, “Ngadjare ngurriray kandibawo rowk.” Wanjh kunu minj nangale mak Joseph birridjarrkniwirrinj bu nungka mulewarrinj bedberre nawu birridanginj. ");
INSERT INTO gup_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Dja nungka wernkih duninjh nalkbom, birrinalkbekkang bininj nawu Egyptbeh, dja kaluk Pharaoh dja nawu birrini kururrk nuye birriwobekkang. ");
INSERT INTO gup_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph yimeng bedberre nawu birridanginj, “Ngaye wanjh Joseph. Yiddok ngardduk kornkumo kadjaldarrkid?” Wanjh kunmekbe nawu birridanginj nuye minj mak baleh birriyimeninj yimankek birriwokmayi, dja birrikeleminj duninjh bu nungka dorrengh benmarnedanginj. ");
INSERT INTO gup_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Wanjh Joseph benmarneyimeng nawu birridanginj nuye, “Mah, ngadjare ngurrimdarnhray.” Bu kunmekbe birrikurduyimeng birridarnhyikang wanjh nungka benwelengmarneyimeng, “Ngaye wanjh karridanginj nawu Joseph nawu ngudda kandikukweykang kore Egypt. ");
INSERT INTO gup_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Dja bonj, yuwn ngurrikangewarre, dja yuwn mak ngurriwelengnamerren bu ngaye kandikukweykang kondah, dja God nganmunkeweng ngamyingkihdokmeng ngudberre ba bu nungka kanngehke dja minj mak karridowe rowk.” ");
INSERT INTO gup_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","“Dja kuhni ngayime. Kanbekka. Dja mandjewk bokenh kamarnbun bu minj manme karrikarrmeninj kondah kubolkwarlah Egypt, dja mak kaluk bu five mandjewk minj bininj kabirribolkkarung kabirrimimdudjengkenh, minj mak kabirrimimmoyhmang. ");
INSERT INTO gup_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dja God nganmunkeweng ngamyingkihdokmeng ngudberre, ba kunu yikahwi nawu ngudberre bininj ngurridjaldarrkid kondah kurorre. Nungka wanjh ngunngehke kundulkarre duninjh nuye dorrengh ba ngurriwern ngurridjaldarrkid.” ");
INSERT INTO gup_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Kunmekbe wanjh, minj ngudda kandimmunkewemeninj kondah, dja nungka God nganmunkeweng. Nungka nganmarnbom yiman kornkumo rerrih nuye Pharaoh, ngabenmarnewohrnan bedberre bininj nawu kabirrini kururrk nuye, dja ngawohrnan kore kubolkwarlah Egypt rowk.” ");
INSERT INTO gup_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Wanjh werrkwerrk ngurridurnde kore Ngabbard, dja ngurrimarneyimen, ‘Kuhni wanjh beywurd ke nawu Joseph ngunmarneyime, “God nganmarnbom ngawohrnan kore kubolkwarlah Egypt rowk. Wanjh yimray kore ngaye djalwerrkwerrk, dja yuwn yiwohbolkmaddeng. ");
INSERT INTO gup_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ngudda kaluk yini kore kunred Goshen, darnkih kore ngaye, ngudda, dja mak wurdwurd ke, dja mak mawahmawah ke, dja mak mayh nawu sheep, goat, bulikki, dja mak yehyeng rowk nawu yikarrme. ");
INSERT INTO gup_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ngaye kaluk won manme kumekbe, dja five mandjewk kamre bu kadjewkwarremen, minj manme kadjordmen. Bu minj yimre ngudda dja nawu ngurridjarrkni dja nawu ke rowk, wanjh ngurridjalyawarren duninjh.” Kuhni ngurrimarneyime nawu nganbornang.’” ");
INSERT INTO gup_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Mak Joseph yimeng bedberre nawu birridanginj, “Ngudda wanjh ngudman kandikuknan, dja Benjaminj ngudda warridj nawu ngarrdanginj kannan, dja wanjh woybukkih ngaye nawu ngawokdi ngudberre. ");
INSERT INTO gup_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ngurrimarneyimen Ngabbard bu ngandikukenwong kondah kore Egypt, dja mak ngurrimarneyolyolmen yehyeng nawu ngurrinang. Dja ngurrimka Ngabbard kondah, djalwerrkwerrk ngurrimka.” ");
INSERT INTO gup_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Wanjh nungka bimarneberlwakbom kukom nuye Benjaminj dja bimarnenalkbom, dja Benjaminj nunganwali bimarnenalkbom. ");
INSERT INTO gup_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Dja nungka benbunjhmey rowk nawu birridanginj dja benmarnenalkbom. Wanjh kaluk rerrikah bedda nawu birridangerrinj birriwokdi nuye. ");
INSERT INTO gup_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kaluk kore Pharaoh nuye bininj birriwobekkang bu Joseph nuye birridanginj birrimwam Egypt, wanjh Pharaoh dja bininj nuye nawu birrikihkimuk, nawu birrimarnedurrkmirri Pharaoh, bedda rowk birrinjilngmakminj. ");
INSERT INTO gup_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh bimarneyimeng Joseph, yimeng, “Yibenmarneyimen nawu ngurridanginj bu ngayimeng ngadjare bedda birrimadjkurrmen kubodme bedberre nawu mayh bedberre dja birridurnden kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Wanjh kumekbe bindima kornkumo dja mak bininj rowk ngudberre, dja kabirrimyawoyhdurndeng kore ngaye. Wanjh ngaye bolkwon ngudberre kore kuwernhbolkmak kondah kubolkwarlah Egypt, dja munguyh ngurringun manme manmak duninjh. ");
INSERT INTO gup_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Dja mak ngaye Pharaoh wokrayekwon ngudda Joseph, wanjh yibenmarneyimen bu kabirrikan wirlbarra kondah Egyptbeh ba kabirrimdahkendan wurdwurd dja ngalbibininjkobeng, dja mak nawu kornkumo ngudberre, wanjh birrimray kondah rowk. ");
INSERT INTO gup_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Dja mak yibenmarneyimen, ‘Yuwn ngurrinjilngwarre bu yehyeng ngurribawon nawu ngudberre. Bonj, dja ngurridjalbawo, dja kondah kore kubolkwarlah Egypt kunwernhmak duninjh ngarre ngurrimang.’” Kuhni rowk nawu Pharaoh bimarneyimeng Joseph. ");
INSERT INTO gup_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Wanjh nawu bebeywurd nuye Israel kunmekbe birrikurduyimeng. Joseph benwong wirlbarra bu Pharaoh biwokrayekwong, dja mak manme benwong kabirrirekenh. ");
INSERT INTO gup_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Benbebbehmadjwong rowk kunmadjmakmak, dja Benjamin nungka wanjh biwong kunwardde nakimuk, 300 silver shekels, dja kunmadjwern duninjh. ");
INSERT INTO gup_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Dja kuhni wanjh bimarnemunkeweng kornkumo nuye, kaluk ten donkeys nawu birringorrkani namakmak duninjh nawu nakang kumekbe Egypt, dja ten donkeys ngaldahdaluk nawu birringorrkani manmim dja manme dja yehyeng nuye kornkumo bu kamrekenh. ");
INSERT INTO gup_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Wanjh nungka Joseph benmunkeweng nawu birridanginj nuye dja benmarneyimeng, “Yuwn ngurridurren bu ngurrire.” ");
INSERT INTO gup_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wanjh birriwam birriwelengbolkbawong Egypt, birrimarnebebmeng kornkumo bedberre nawu Jacob kore kubolkwarlah Canaan. ");
INSERT INTO gup_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wanjh birrimarneyimeng, “Joseph nungka kadjaldarrkid. Nungka kawohrnan kore kubolkwarlah Egypt rowk.” Jacob wanjh kukkangebarrhmeng dja minj benwoybukwoyi. ");
INSERT INTO gup_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Dja kaluk bu bedda birriwokmulewam rowk bu Joseph benmarneyimeng, dja mak bu nang wirlbarra manbu Joseph bimarnemunkeweng kabikankenh, wanjh kunu nungka Jacob nawu kornkumo bedberre wanjh yawoyhkangemarrmarrminj. ");
INSERT INTO gup_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Wanjh Israel yimeng, “Bonj, ngaburrbun kadjaldarrkid Joseph nawu beywurd ngardduk. Ngare nganan dja yerre wanjh ngawelengdowen.” ");
INSERT INTO gup_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wanjh kunu Israel bolkbawong wam, nungka kang yehyeng rowk nawu nuye. Bu nungka bolkmey Beersheba, nungka bom mayh kinjeng nuye God. Nahni God wanjh God nuyeni Isaac warridj, nawu Jacob bibornang. ");
INSERT INTO gup_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dja kunmekbe God bimarnewokdanj Israel bu yiman nungka biwaralnani bu kukak, yimeng, “Jacob, Jacob!” Wanjh Jacob biwokmey, yimeng, “Kondah ngaye.” ");
INSERT INTO gup_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Wanjh God bimarneyimeng, “Ngaye wanjh God. Dja ngaye God nuye nawu ke kornkumo. Yuwn yikele bu yire kore Egypt, dja bu kumekbe yini ngaye kaluk won birrimirndewern bininj nawu ngudda yibenkebmawahme, kabirriyimerran birriredbo nawu birrikuken. ");
INSERT INTO gup_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ngaye ngudda ngarrdjarrkre Egypt, dja woybukkih ngaye durndiwe kondah warridj. Dja nungka kaluk Joseph yimarnedowen kore nungka ngunedi.” ");
INSERT INTO gup_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Wanjh Jacob bolkbawong Beersheba, dja bebeywurd nuye Israel birrikang Jacob nawu kornkumo bedberre, dja wurdwurd bedberre, dja ngalbibininjkobeng bedberre bindikang, birridahkendi kore wagon manbu Pharaoh munkeweng kabenkankenh. ");
INSERT INTO gup_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Dja birrikang warridj mayh bedberre dja yehyeng bedberre nawu birrikarrmi, nawu benmarnewernminj kore kubolkwarlah Canaan. Wanjh Jacob dja bedda rowk nawu nungka benbornang dja nawu benkebmawahmeng wanjh birriwam rowk kore Egypt. ");
INSERT INTO gup_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Nungka benkang rowk bebeywurd dja mawamawahmikenh, ngalbebeywurd dja ngalmawahmikenh. Birriwern rowk nawu benbornang dja benkebmawahmeng birridjarrkwam Egypt. ");
INSERT INTO gup_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jacob dja nawu nungka benbornang dja benkebmawahmeng nawu birrimwam Egypt, kuhni wanjh birringeyyoy birrimekbe nawu Israel benbornang dja benkebmawahmeng. Reuben nungka Jacob nuyeni nawu nadjdjaman. ");
INSERT INTO gup_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben bebeywurd nuye wanjh Hanoch, Pallu, Hezron, dja Carmi. ");
INSERT INTO gup_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon bebeywurd nuye wanjh Jemuel, Jamin, Ohad, Jakin, Zohar, dja Shaul nawu nungka nayaw ngarreni daluk ngalbu ngalkang Canaan. ");
INSERT INTO gup_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi bebeywurd nuye wanjh Gershon, Kohath dja Merari. ");
INSERT INTO gup_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah bebeywurd nuye wanjh Er, Onan, Shelah, Perez, dja Zerah. (Bedda nawu Er dja Onan wanjh ngokkokenh benedoweng kore kubolkwarlah Canaan.) Nawu Perez nungan nuye bebeywurd wanjh Hezron dja Hamul warridj birridjarrkwam. ");
INSERT INTO gup_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaachar bebeywurd nuye wanjh Tola, Puah, Jashub, dja Shimron. ");
INSERT INTO gup_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Dja Zebulun bebeywurd nuye wanjh Sered, Elon, dja Jahleel. ");
INSERT INTO gup_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Birrimekbe wanjh nayayaw ngarreni Leah nawu bimarneyawmey Jacob kore Paddan Aram, dja warridj ngalbeywurd nuye ngalbu Dinah. Nanih nawu bebeywurd dja ngalbeywurd, dja mawamawahmikenh nuye Jacob nawu Leah ngarreni wanjh thirty three. ");
INSERT INTO gup_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad bebeywurd nuye wanjh Zephon, Haggi, Shuni, Ezbon, Eri, Arodi, dja Areli. ");
INSERT INTO gup_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher bebeywurd nuye wanjh Imnah, Ishvah, Ishvi, dja Beriah. Ngaldaluk bedberre wanjh Serah. Beriah nungan nuye bebeywurd wanjh Heber dja Malchiel birridjarrkwam. ");
INSERT INTO gup_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Birrimekbe wanjh nayayaw ngarreni Zilpah ngalbu Laban biwong Leah ngalbeywurd nuyeni. Bedda nawu Zilpah bimarneyawmey Jacob wanjh sixteen bebeywurd dja mawamawahmikenh dja ngalmawahmikenh nawu Zilpah ngarreni. ");
INSERT INTO gup_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Dja nayayaw ngarreni Rachel ngalbu ngalbininjkobeng nuye Jacob, wanjh Joseph dja Benjaminj. ");
INSERT INTO gup_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Bu Joseph ni kore kubolkwarlah Egypt wanjh bebeywurd nuye benedanginj nawu Manasseh dja Ephraim, nawu ngalbadjan berrewoneng wanjh Asenath ngalbeywurd nuyeni Potiphera, nawu nungka yiwarrudj wohrnani bedberre kore kunred On. ");
INSERT INTO gup_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjaminj bebeywurd nuye wanjh Bela, Becher, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, dja Ard. ");
INSERT INTO gup_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Birrimekbe wanjh nayayaw Rachel ngarreni nawu Jacob benbornang. Bedda wanjh fourteen bebeywurd nuye Jacob dja mawamawahmikenh nawu Rachel ngarreni. ");
INSERT INTO gup_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan beywurd nuye wanjh Hushim. ");
INSERT INTO gup_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali bebeywurd nuye wanjh Jahzeel, Guni, Jezer, dja Shillem. ");
INSERT INTO gup_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Birrimekbe wanjh nayayaw ngarreni Bilhah ngalbu Laban biwong Rachel ngalbeywurd nuyeni. Bedda wanjh nawu Bilhah bimarneyawmey Jacob, wanjh seven nawu bebeywurd dja mawamawahmikenh nawu Bilhah ngarreni. ");
INSERT INTO gup_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Bedda nawu birridjarrkwam Egypt Jacob dorrengh, nawu nungka benbornang dja nawu benkebmawahmeng wanjh 66 bininj dja daluk. Dja nawu ngalbibininjkobeng bedberre minj bindirohrokmeninj. ");
INSERT INTO gup_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Dja nawu bebeywurd nuye Joseph nawu benedanginj kore Egypt, bu bedda dorrengh wanjh 70 bininj dja daluk bu Jacob dja nungka nuye nawu birriwam kumekbe Egypt. ");
INSERT INTO gup_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob bimunkeweng Judah yingkihdokmeng kore Joseph, kabimarneyime kabimdabke kore Goshen, wanjh birriwam kore kunred Goshen. ");
INSERT INTO gup_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Wanjh Joseph mey nuye wirlbarra, dja wam kore Goshen kabirrabke kornkumo nuye nawu Israel. Bu Joseph bimarnebebmeng wanjh kundjalmekbe rerrih nungka biwanjbimey nuye kornkumo dja bimarnenalkbom kunkuyeng. ");
INSERT INTO gup_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Wanjh Israel bimarneyimeng Joseph, yimeng, “Bonj, bu ngayeman yawoyhkebnang ngudda, ngaburrbun yidjaldarrkid, wanjh kamak ngarrowen.” ");
INSERT INTO gup_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Wanjh Joseph benmarneyimeng nawu birridanginj dja birriwern nawu kornkumo nuye birridjarrkni, yimeng, “Ngaye ngare nganewokdi Pharaoh, ngamarneyime, ‘Ngaye ngarridanginj dja Ngabbard dja bininj nuye rowk nawu birrini kore kubolkwarlah Canaan wanjh birrimwam kore ngaye. ");
INSERT INTO gup_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Bedda nawu bininj wanjh mayh kabirrinahnan dja birrimmirndeyorrkeng nawu sheep, goat, dja bulikki bedberre, dja mak birrimkang yehyeng bedberre nawu kabirrikarrme.’ Kunmekbe wanjh ngayime nuye Pharaoh mulewan ngudberre.” ");
INSERT INTO gup_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“Dja bu nungka Pharaoh ngunkayhme ngudberre ngurringimen nuye dja ngundjawan ngudberre, ‘Ngudda baleh ngurridurrkmirri?’ ");
INSERT INTO gup_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Wanjh ngudda ngurridjalwokma, ngurriyimen, ‘Ngad nawu ngarrimarladj, ngad ngarrinahnani mayh bu ngarriyawurrinjni dja munguyh ngarridjalnahnan, yiman Mawah ngadberre birrikurduyimi.’” Mak Joseph yimeng bedberre, “Bu kuhni ngurriyime wanjh ngunbolkwon ngurrini kore kunred Goshen, dja Egyptian bininj kabindinjirrhmiwon rowk bininj nawu mayh kabirrinahnan, minj kabirridjarrkni.” ");
INSERT INTO gup_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Wanjh Joseph wam ngimeng kore Pharaoh, dja bimarneyimeng, yimeng, “Kornkumo ngardduk dja nawu ngarridanginj birrimwam, kaluk sheep, goat, dja bulikki bedberre birrimmirndeyorrkeng, dja mak birrimkang yehyeng nawu kabirrikarrme, birrimwam kubolkwarlah Canaanbeh dja bolkkime kabirrini kore kunred Goshen.” ");
INSERT INTO gup_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Wanjh Joseph benmey yikah kubidkudji nawu birridanginj dja benkang kore Pharaoh kumirrk nuye. ");
INSERT INTO gup_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaoh bendjawam, “Ngudda baleh ngurrikurduyime ngurridurrkmirri?” Dja bedda birrimarneyimeng Pharaoh, “Ngad nawu ngarrimarladj, ngad wanjh mayh ngarrihdjalnahnan, yiman mawahmawah ngadberre birrikurduyimi.” ");
INSERT INTO gup_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Wanjh birrimarneyimeng Pharaoh, “Ngad ngarrimwam ngarridjare kondah kubolkwarlah ngarriwohni, dja kore kubolkwarlah Canaan minj karralkdi bedberre mayh ngadberre nawu ngarrimarladj, dja bolkwarreminj duninjh bu djewkwarrewong, wanjh bolkkime ngundidjawan ngarridjare kanbolkwon ngadberre nawu ngarrimarladj, ngarrini kore kunred Goshen.” ");
INSERT INTO gup_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Wanjh Pharaoh bimarneyimeng Joseph, yimeng, “Kornkumo ke dja nawu ngurridanginj birrimwam kore ngudda. ");
INSERT INTO gup_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Bu bedda baleh kabirridjare kabirrini wanjh bonj kumekbe yibenbolkwo. Kornkumo ke dja nawu ngurridanginj yibenbolkwo kore kuwernhbolkmak, bonj birrinin kore kunred Goshen. Dja bu yibenburrbun yikah kore bedda nawu birrimak, wanjh yibenkurrmen kabirrinahnan mayh ngardduk.” ");
INSERT INTO gup_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Wanjh Joseph bimkang Jacob nawu kornkumo nuye bingimiwong kore Pharaoh, bimarnedanginj kumirrk nuye, wanjh Jacob bimarneyimeng Pharaoh kunmak kunwok. ");
INSERT INTO gup_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Wanjh Pharaoh bidjawam Jacob, yimeng, “Ngudda kaluk baleh yimi mandjewk ke bu yimimbi?” ");
INSERT INTO gup_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Wanjh Jacob bimarneyimeng Pharaoh, yimeng, “Ngaye mandjewk ngardduk bu ngadjalwohreywohrey wanjh 130 mandjewk. Minj nawern mandjewk ngamimbiniwirrinj dja mak kunrayek nganmarnebebmi. Ngaye bu mandjewk ngardduk minj yiman bedda nawu mawahmawah ngardduk bu birridjalwohreywohrey.” ");
INSERT INTO gup_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Wanjh Jacob biwoknang bimarneyimeng Pharaoh kunmak kunwok. Dja wanjh bibawong Pharaoh dja wam. ");
INSERT INTO gup_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Wanjh Joseph benbolkwong kornkumo nuye dja nawu birridanginj, kuwernhbolkmak benbolkwong kunred Rameses kumekbe kore Pharaoh biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Dja mak Joseph manme benwoni nawu kornkumo nuye, dja birridangerrinj, dja birriwern rowk nawu birridjarrkni kornkumo, manme benmarnerohrokmi bedberre. Nawu benkarrmi wurdwurd birriwern wanjh manwern benwoni, dja nawu wurdwurd birrimirndeyahwurd benkarrmi wanjh manyahwurd benwoni. ");
INSERT INTO gup_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Wanjh kore kubolkwern rowk bolkdarlehminj duninjh, bu djaldjewkwarreni munguyh, kunmekbekenh wanjh minj manme birrikarrmeninj. Egypt dja Canaan bolkwarreminj duninjh bu kunmekbekenh mandjewk djewkwarrewong. ");
INSERT INTO gup_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Bininj nawu birrini kore Egypt dja Canaan wanjh birribayahmi manme, dja birrikukwong rowk Joseph kunwardde bedberre, birriyakwong bu manmim birrimimmangi, dja nungka kang kunwardde kore kunrurrk nuye Pharaoh. ");
INSERT INTO gup_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wanjh bu kunwardde bedberre kukyakminj rowk, bininj nawu birrini kore Egypt dja Canaan, wanjh birriwern Egyptian bininj birrimwam kore Joseph, birrimarneyimeng, “Kanwo ngadberre manme. Njalekah yimankek ngarridowen kore ngudda kumirrk ke? Dja kunwardde ngadberre wanjh yakayakminj.” ");
INSERT INTO gup_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Wanjh Joseph benwokmey, yimeng, “Kandiwo mayh ngudberre dja ngaye won ngudberre manme bu ngudda kandiwon mayh. Kunekke wanjh ngurrikurduyimen dja wanjh kunwardde badyakminj ngudberre.” ");
INSERT INTO gup_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Wanjh kunu bedda birrimkang mayh bedberre kore Joseph birriwong, dja nungka benwong manme bu bedda birriwong djarrang, sheep, goat, bulikki dja bedberre. Wanjh nungka benwoni manme bu bedda birriwoni mayh bu namekbe mandjewkkenh. ");
INSERT INTO gup_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Dja bu namekbe mandjewk yakminj, wanjh mandjewkbuyika bedda birrimwam kore nungka dja birrimarneyimeng, “Ngad minj ngarriwarlkkan ke nawu kanmarnewohrnan, bu kunwardde rowk ngadberre wanjh kukyakayakminj, dja mayh rowk ngadberreni, bolkkime wanjh ngudda ke rowk nawu kanmarnewohrnan. Minj njale mak ngarrimkarrme bu ngundiwon ngudda nawu kanmarnewohrnan, ngarridjalkarrme ngadman kunburrk ngadberre dja mak kabbal ngadberre. ");
INSERT INTO gup_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Njalekah ngad yimankek ngarridowen kore ngudda kumirrk ke, ngad ngarridowen dja kunred warridj ngadberre karrowen? Kandjarrkma ngadberre kabbal dja ngad warridj kanma, ngarridjarrkweykarren kabbal dorrengh manmekenh ngadberre. Dja ngad bu kabbal dorrengh ngadberre wanjh ngarrimarnedurrkmirri nawu Pharaoh. Dja kanmimwo manmim ba ngarridarrkid dja minj ngarridowen, dja minj kunred kabolkmarladjmen duninjh.” ");
INSERT INTO gup_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Wanjh kunu Joseph bolkbayahmeng rowk kubolkwarlah Egypt, Pharaoh bimarnemey, dja Egyptian bininj rowk birribolkweykang kabbal bedberre rowk bu manme birridjalyawarreni bulkkidj duninjh. Wanjh kunred kubolkwarlah bolkyimerranj Pharaoh nuye, ");
INSERT INTO gup_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","dja bininj nawu nungka benmarnbom birrimarnedurrkmirri kubolkwernkenh rowk kore Egypt. ");
INSERT INTO gup_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kunbolkkudji nungka minj bolkmayi, kaluk kunred bedberre bininj nawu birriwohrnani yiwarrudj bedberre, dja bedda munguyh kunwardde Pharaoh benwoni. Wanjh namekbe kunwardde bu Pharaoh benwoni wanjh bedda birrimangi manme, wanjh kunu minj bedda birribolkweykayi kunred bedberre. ");
INSERT INTO gup_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Wanjh Joseph benmarneyimeng bininj, yimeng, “Kandibekka, ngaye wanjh bonj djarrkmey ngudberre dja kabbal dorrengh ngudberre ngamarnebolkmey Pharaoh. Manih wanjh manmim ngudberre ngurrimimdudjeng kore kabbal. ");
INSERT INTO gup_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Dja bu ngurrimimmoyhmang bu yiman kunbidkudji baladji ngurribarlke, wanjh nakudji ngurriwo Pharaoh bu munguyh, dja nawu kunkarrngbakmeng baladj wanjh ngurrikarrme ngudberre, yikah ngurrimimdudjeng kore kabbal, dja yikah ngudberre manme ngurringun, ngudda dja nawu ngurridjarrkni, dja wurdwurd ngudberre kabirringun.” ");
INSERT INTO gup_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wanjh bedda birriyimeng, “Ngudda kanngehkeng ngarridarrkid, wanjh bonj ngudda nawu kanmarnewohrnan ngarridjare kanmarneyimen bu ngarrimak, dja bonj, kamak ngad Pharaoh ngarrimarnedurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Wanjh kunu Joseph mankarre marnbom ngarre kubolkwarlah Egypt, munguyh kadjalkarreyime bu bininj manme kabirrimoyhmang kunbidkudji yarrkka, wanjh Pharaoh kabirriwon mankudji. Kundjalkudji kunred minj bolkyimerrangimeninj Pharaoh nuye, kaluk kunred bedberre nawu birriwohrnani bedberre yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Wanjh kunu bininj nawu Israel benkebmawahmeng birrini kore kubolkwarlah Egypt kore kunred Goshen, dja yehyeng bedberre benmarnewernmerreni, dja wurdyaw nawern birrimey, birrimirndewernminj duninjh. ");
INSERT INTO gup_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Wanjh Jacob ni kore kubolkwarlah Egypt bu mandjewk seventeen, wanjh Jacob nuye mandjewk bu nungka mimbini wanjh 147. ");
INSERT INTO gup_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wanjh bu ngokko darnkih kumwam nuye bu nungka nawu Israel kadjaldowen, nungka bimkayhmeng Joseph nawu beywurd nuye dja bimarneyimeng, “Bu ngudda yiyime ngamak, wanjh yibidkurrmerrimen kurrad ngardduk, dja kanberrebbun bu ngudda kunmak dja kunwoybuk kanmarneyime. Yuwn kankukdudjeng kondah kore Egypt, ");
INSERT INTO gup_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","dja bu ngamalngre kore mawahmawah ngardduk, wanjh ngadjare ngakukyo kore bedda kabirrikukyo. Kankukka kondah Egyptbeh dja kankukdudjeng kore bedda kabirrikukdudjindi.” Joseph biwokmey, yimeng, “Ngaye kunmekbe ngakurduyime bu ngudda yiyimeng, Ngabba.” ");
INSERT INTO gup_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Dja Jacob yimeng, “Kanmarnewokkurrmerrimen kunwok kunrayek duninjh.” Wanjh nungka Joseph wokkurrmerrinj kunwok kunrayek duninjh. Wanjh Israel nungka welengboddanj kore kunkarndudj manbu karndudjkarreni, bu biburlumeng God. ");
INSERT INTO gup_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kaluk rerrikah wanjh bininj bimarneyimeng Joseph, yimeng, “Kornkumo ke wanjh kahdowen.” Wanjh kunu Joseph benbenekang bebeywurd nuye Manasseh dja Ephraim birridjarrkwam. ");
INSERT INTO gup_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Wanjh bu bininj bimarneyimeng Jacob, yimeng, “Beywurd ke nawu Joseph wanjh ngunmarnebebmeng”, wanjh Israel kumngudjrayekworrinj kumdolkkang kumhni kore balabbala. ");
INSERT INTO gup_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob bimarneyimeng Joseph, yimeng, “El Shaddai nganmarnebukkarrinj kore kunred Luz kore kubolkwarlah Canaan, dja kumekbe nungka nganmarneyimeng kunmak kunwok, ");
INSERT INTO gup_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","dja nganmarneyimeng, ‘Ngaye marnbun ngudda bu yibenbornan birriwern wurdwurd, dja nawu yibenkebmawahmen wanjh kabirrimirndewernmen, dja mak kabirribebbehmirndeyimerran birribebbehmirndekihkimuk, dja ngaye ngabenbolkwon kumekbe kunred kore bolkkime yihdi ba bu kabirribolkkarrme djalmunguyh.’” ");
INSERT INTO gup_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Kunmekbe yimeng Jacob biwokmulewam God, dja kuhni mak nungka bimarneyimeng Joseph, yimeng, “Bonj, dja kuhni yina kayime, bebeywurd ke bokenh nawu ngundimarnedanginj kondah kore Egypt bu ngaye minj ngambangmerawinj ke, bedda wanjh kabeneyimerran yiman ngardduk rerrih bebeywurd. Ephraim dja Manasseh bedda wanjh kabeneyimerran ngardduk yiman Reuben dja Simeon ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Bu yimankek wurdwurd birribuyika ngundimarnedangen yerrekah, bedda wanjh ngudda ke, dja Ephraim dja Manasseh kabenembolkweykan kabindimbolkwon kumekbebeh. ");
INSERT INTO gup_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kunmekbe ngakurduyime Rachelkah bu doweng. Bu ngaye ngarrurndengi Paddanbeh, wanjh ngakangewarreni bu Rachel doweng kore kubolkwarlah Canaan bu karribalhrey, darnkih karribebmeninj Ephrath. Wanjh ngaye kumekbe ngakukdudji darnkih kore manbolh manbu kare Ephrath.” (Kumekbe kunred wanjh kabolkngeyyo warridj Bethlehem.) ");
INSERT INTO gup_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Bu Israel benbenenang Joseph nuye bebeywurd wanjh nungka bidjawam, yimeng, “Benengale beddanu?” ");
INSERT INTO gup_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph bimarneyimeng kornkumo, “Bedda wanjh bebeywurd ngardduk nawu God nganwong kondah kore Egypt.” Wanjh Israel yimeng, “Ngadjare yibenbenemka kore ngaye ba ngaye ngabenbenemarneyime kunmak kunwok berrewoneng.” ");
INSERT INTO gup_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Dja Israel nungka wanjh wernhmimbulerranj dja kohbanjminj, nungka minj njale wernhnayi. Wanjh kunu Joseph bebeywurd nuye benbenemkang darnkih, dja kornkumo nuye benbenebunjhmey benbenewanjbimey. ");
INSERT INTO gup_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel bimarneyimeng Joseph, yimeng. “Ngaye ngayimeng bu minj ngudda yawoyhkebnayi, dja God nungan kurduyimeng ngardduk ngabenbenenan wurdwurd ke warridj.” ");
INSERT INTO gup_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Wanjh Joseph benbenekoluyhweng kore Israel beneni kubard nuye, dja nungka Joseph boddanj kanjdji rorrehrorrenani. ");
INSERT INTO gup_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Wanjh Joseph benbenekang, Ephraim bikang kubidkun nuye bikurrmeng kore Israel nuye kudjakku, dja Manasseh Joseph bikang kubiddjakku nuye bikurrmeng kore Israel nuye kukun, wanjh kumekbe benbenekang darnkih kore Israel ni. ");
INSERT INTO gup_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Dja nungka nawu Israel bidkurrmerrinj kunbidkun nuye kore Ephraim nuye kukodj, madjamku nungka Ephraim nawalawalak, dja berlyurrhkerrinj bidkurrmerrinj kunbiddjakku nuye kore Manasseh nuye kukodj, madjamku Manasseh nungka wanjh nadjdjaman. ");
INSERT INTO gup_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Wanjh nungka Israel bimarneyimeng Joseph kunmak kunwok, yimeng, “Ngadjare God nawu Mawah ngardduk nawu Abraham dja Ngabbard Isaac benemarnedurrkmirri, God nawu ngandjalnahnani nganmikani bu ngayahwurdni dja munguyh ngandjalnahnani, dja mak bolkkime ngannahnan. ");
INSERT INTO gup_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nungka angel nawu nganbebkeyi bu baleh yarrkka kunwarre nganmarnebebmi. Ngadjare nungka kabenbenemarnekurduyime kunmak nanih nawu yawurrinj bokenh. Ngadjare kunngey ngardduk dja kunngey berrewoneng Ngabbard Isaac, dja ngardduk Mawah nawu Abraham kandingeykerrngehme ngadberre, kunmekbe kabaldjalyimerran munguyh munguyh. Dja ngadjare nawu kabindikebmawahme kabirrimirndewernmen kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Bu Joseph nang kornkumo nuye bidkurrmerrinj kunbidkun nuye kore Ephraim nuye kukodj, wanjh nungka Joseph minj djareniwirrinj. Wanjh kunu nungka bibidkarrmeng kornkumo nuye kunbid, bibidwayhkemeninj kore Ephraim nuye kukodjbeh, bibidkurrmeninj kore Manasseh nuye kukodj. ");
INSERT INTO gup_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph bimarneyimeng kornkumo, yimeng, “Kuwid Ngabba, nanih wanjh nadjdjaman, yibidkurrmerrimen kunbidkun ke kukodj nuye.” ");
INSERT INTO gup_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Dja kornkumo nuye birrahmeng yimeng, “Ngaburrbun Korlonj, ngaburrbun. Nungka warridj Manasseh wanjh kabenkebmawahme namirndewern bininj, dja warridj kabirrimirndekukenmen. Dja nawu nawalawalak nuye kabiyurrhke, dja nawu kabenkebmawahme wanjh kabirriwernhmirndeyimerran birribebbehmirndewern nawu birriredbo.” ");
INSERT INTO gup_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kunmekbe kunbarnangarra nungka Israel benbenemarneyimeng kunmak kunwok, yimeng, “Bininj nawu Israel benkebmawahmeng kaluk bingeybun ngorrewoneng bu bedda kabindimarneyime bininj kunmak kunwok, kaluk kabirriyime, ‘Ngarridjare God ngunmarnbun ngurriyimerran yiman Ephraim dja Manasseh.’” Bu kuhni yimeng nawu Israel nungka birrokmiweng Ephraim, dja Manasseh bikurrmeng rerre. ");
INSERT INTO gup_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Wanjh Israel bimarneyimeng Joseph, yimeng, “Kanbekka, ngaye ngokko darnkih ngarrowen, dja God ngurridjarrkre munguyh dja ngunkan ngudberre ngurridurndeng kore kunred bedberre nawu mawahmawah ngudberre. ");
INSERT INTO gup_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Dja ngudda nawu yibenmarnewohrnan nawu ngurridanginj, ngaye kaluk bolkwon kore kawohdulum kunred Shechem kore ngaye ngabenbolkyimey bininj nawu Amor benkebmawahmeng bu mandjawak dja bunarra ngardduk ngabenbuni.” ");
INSERT INTO gup_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Wanjh Jacob benkayhmeng bebeywurd nuye dja yimeng, “Wurdwurd, ngurrimray nadjakerryih dja nakokokyih ngurrimirndemornnamerrimen ngardduk dja kandiwokbekkan ngaye bu marneyime ngudberre. Ngadjare marneyime ngudberre bu kaluk baleh kabebbehkurduyimerran ngudberre yerrekah. ");
INSERT INTO gup_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ngaye wanjh nawu nakornkumo ngudberre bu ngakarrme kunngey bokenh. Kunkudji ngangeyyo Jacob dja mak kunbadbuyika ngangeyyo Israel bu nungan God nganngeywong. Kandibekkabekka bolkkime.” ");
INSERT INTO gup_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ngudda nawu Reuben, ngudda wanjh ngardduk nawernwarre duninjh nawu nadjdjaman, nawu kundung ngarruy. Bu ngaye ngayawurrinjni dja ngangudjmakni wanjh ngudda nawu yirrokmeng bu bornang. Ngudda nawu yikimuk duninjh dja mak balhberr yirri ngardduk. ");
INSERT INTO gup_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Minj mak bu yibenmarnewirrihmerren dja mak yibenmarnewohrnan birrikilehkilelk nawu ngurridangerrinj. Minj ngudda kunu yimarnburren yimak dja yidjalyimerran yiman kayime kukku manbu kabore dja kaboyarlarrme bebbehbeh. Dja ngudda kunu yiwam yiyonginj kore kunmadj ngardduk bu kanmarnbom ngayemeng bulkkidj.” ");
INSERT INTO gup_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","6","“Simeon dja Levi ngudda nawu ngunedjaldanginj duninjh. Ngudda wanjh ngurrbenbuni bininj bu kunkare mandjawakyi bu ngunedjalyiddungi dja mak ngurrbendjalbuni burudjang. Dja mak ngurrbenmarneyildadjkeyi mayh bedberre bu yimankek marlehmarlelh ngunehyimi. Ngaye minj ngadjare kaneraworren bu kuninjkunu kunwarrekenh kunmekbe bu ngudda nguneburrbun kore ngunemayaliyime ngonewoneng. ");
INSERT INTO gup_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bu ngudda munguyh ngunedjalyiddung dja ngunekukbengwarrmen dja mak ngunemimkongiyakmen wanjh ngaye ngadjare God ngunbenedjarrkdung ngunebokenh. Ngudda nawu ngunekebmawahme nawu ngonewoneng wanjh nakka kabirribebbehmirndeyarlarrme kore wanjh ngaye ngabenkebmawahme nawu birribuyika. Wanjh kunukka ngudda nawu ngurrimud minj mak ngurrikukenworren ngudmandeleng, dja larrk.” ");
INSERT INTO gup_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Ngudda nawu Judah, wanjh nawu ngurridanginj ngundiburlume. Bu ngudda wanjh munguyh yibendjalyurrhke bininj nawu yimankek birribang ngundibun. Wanjh kuninjkunukenh nawu ngudda ngurridanginj wanjh ngundimarneboddan ngudda ke. ");
INSERT INTO gup_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ngudda yiman kayime nawu lion kukyawurrinj nawu nabang duninjh. Ngudda wanjh yire dja yibun ke mayh, wanjh bu yimdurndeng wanjh yingehme bu yikeyokenh. Minj nangale kelebuk bu kamre ngunkodjkedolkkayhwe kore yihkeyo. ");
INSERT INTO gup_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ngudda nawu ngurrimud wanjh kabindingalke nawu kings bu kabindimarnewohrnankenh bininj nawu ngabenkebmawahme nawu kabirringeyyo Israel kore ngaye ngabenngeywon. Kaluk bu yerrekah wanjh nakudji kambebme nawu yibenkebmawahme ke, dja nungka wanjh nawu king duninjh kayimerran, wanjh birriwarlahkenh bininj kabirriwokmarrkmang nuye. ");
INSERT INTO gup_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kaluk yerrekah nungka kamre, wanjh kakan yaw djarrang kakebbongname kore mandulkbarnemmak kahdi manbu grapes. Kaluk nungka kamadjdjirridjburren kore mankalkkidbeh grapes, yiman kayime manbokurlbah rerrih. ");
INSERT INTO gup_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Dja mak nungka kabongun manbowern mankalkkid manbu grapesbeh wanjh kunmim nuye kamimburlerran bu kamimkakyongen. Dja mak manbowern kabongun yiman kayime kore kundjikkabeh wanjh kunyidme nuye kabelemen.” ");
INSERT INTO gup_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Ngudda nawu Zebulun, ngudda wanjh yireddi kore kukadjid mankarndan ngarre adjbud. Wanjh manbu mankimuk kabbala kamre karrangen kore ngudda yireddi ba bu yidarnhnahnan bu kamak rowk kahdi. Ngudda ke kunred wanjh kayawbolkkimuk bu kare kangurdme kore kabolkngeyyo Sidon.” ");
INSERT INTO gup_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","“Dja ngudda nawu Issachar, ngudda wanjh yiman kayime djarrang nawu nangudjrayek kamadjngorrkan, bu karrurrkmirri kunrayek dja bu kabolknan kanan kore kurralkmak, wanjh kayerrkan kangudjngehme kumekke. Dja nungka munguyh kadjaldurrkmirri, dja mak bu bininj kabirridjaldjurrkkan wanjh nungka munguyh karrurrkmirri bedberre.” ");
INSERT INTO gup_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ngudda nawu Dan yibenkebmawahme nakka wanjh kabindidjadme birribuyika bininj nawu ngaye ngabenkebmawahme. ");
INSERT INTO gup_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ngudda wanjh kaluk yiman kayime nayin nabang nawu kahdi kurrid manbolh dja kabimadbun djarrang kabibun ba bu nawu kahmorneni kaddum wanjh kabiburriwe kore kurorre kamankan kubodme nuye.” ");
INSERT INTO gup_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ngudda nawu Yawey, ngaye wanjh madbun bu ngudda kanngehke!” ");
INSERT INTO gup_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ngudda nawu Gad, yikahwi bininj kabirridjare ngundibun dja ngundimarnedjirdmang, kaluk yinganwali yibenyikadjung dja mak yibenyimang rowk.” ");
INSERT INTO gup_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ngudda nawu Asher, ngudda ke kunbolk wanjh munguyh kakarrme manme manmakmak, yiman kayime manbu kings kabirringun.” ");
INSERT INTO gup_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Ngudda nawu Naphtali, ngudda yiman kayime mayh nawu deer kanemdulkwern ngalbu kayawkarrme nayawmakmak kilehkilelk.” ");
INSERT INTO gup_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Dja ngudda nawu Joseph, ngudda yiman kayime manrakelmak manbu kadjordmen kore njilhmi kahdi darnkih, dja manbu manyenhyende wanjh makka kawernmerren dja kabarnemwelehwelme manbu manme. ");
INSERT INTO gup_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","24","Dja kaluk yikahwi bininj birridjareni kunyid dorrengh ngundiyameninj mankole, dja mak bedda yimankek ngundidjalkuyinjbuyi dja bedda minj ngundidjorrngmayi bu ngundibuyi. God nawu dulkarrekimuk ngunmurrngrayekwong ngudda. Ngaye nawu Jacob ngamunkekadjung namekbe nawu God dulkarrekimuk ngardduk. Nungka kabennahnan bininj ngaye nawu ngabenngeywong Israel yiman kayime shepherd kanahnan mayh nuye nawu sheep. Nungka wanjh yiman kayime kunwarddekimuk manbu balhberr karri bedberre. ");
INSERT INTO gup_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nungka wanjh ngardduk God ngaye nawu nakornkumo ke, dja mak ngudda ke God wanjh nungka munguyh ngunbidyikarrme. Nungka wanjh nadjalkudji nadjaldulkarrekimuk duninjh mak ngunwon nawu namakmak kore kaddumbeh dja mak nawu kanjdjibeh. Dja warridj namak ngunnahnan ngudberre nawu ngurrimud ba bu munguyh kabirriyawwernmerren, dja mak mayh bedberre kabirriyawwernmerren.” ");
INSERT INTO gup_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","“Ngaye wanjh kornkumo ke dja ngadjare kuhni wanjh God kakurduyime ke bu kundjalwernhmakmak duninjh bu karri munguyh. Ngaye wanjh ngadjare kuninjkunu God ngunmarnekurduyime nawu ngudda ngaye ngardduk beywurd Joseph. Dja mak ngudda wanjh yidjalwernhkuken bedberre nawu ngurridangerrinj.” ");
INSERT INTO gup_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Dja ngudda nawu Benjaminj, ngudda wanjh yiman kayime dalkken nabang nawu marrwedowikenh kahre. Dja bu malahmalaywi ngudda yibun mayh bu yingun yiworrkmiworren, dja bu wolewoleh kayimerran ngudda yibun mayh wanjh yikukdjalkdjalkmang yiwarlaykurrmekurrme bebbehbeh.” ");
INSERT INTO gup_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Kuhni rowk yimeng nawu Israel. Wanjh nungka benbebbehmarneyimeng rowk bebeywurd nuye bu baleh kaluk kabenbebbehmarnekurduyimerran bedberre. Nungka benmarneyolyolmeng rowk bedberre birrimekbe nawu twelve bebeywurd nuye, nawu kaluk birribebbehyimerranj twelve nawu birribebbehmarnbom namud bedberre bininj nawu Israel benkebmawahmeng. Nungka nawu kornkumo benwong kunwok kunmak bedberre, benbebbehmarneyimeng rowk kunwok manbu mandjalkarredjadni manbu bedberrekih. ");
INSERT INTO gup_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Wanjh Jacob benwokrayekwong, yimeng bedberre, “Ngaye ngokko darnkih ngarrowen, ngamalngre kore mawahmawah ngayekenh birriyingkihmalngdokmeng. Kaluk kandikukdudjeng kore mawahmawah kadberre kabirrikukdudjindi kore kuwardderurrk kore kabbal nuyeni Ephron nawu Heth bikebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kaluk kore kuwardderurrk kore kabbal kore Machpelah, koyekkah Mamre kore kubolkwarlah Canaan, kaluk kunwardderurrk manbu Ephron nawu Heth bikebmawahmeng bolkweykang, Abraham bibolkyimey kabbal dorrengh karribolkkarrmekenh karrbenkukdudjengkenh.” ");
INSERT INTO gup_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","“Kumekbe bindikukdudji Abraham dja Sarah ngalbu ngalbininjkobeng nuye, kumekbe bindikukdudji Isaac dja Rebekah ngalbu ngalbininjkobeng nuye, dja kumekbe mak ngaye ngakukdudji Leah. ");
INSERT INTO gup_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kaluk kabbal dja kunwardderurrk manbu kumekbe karri wanjh Mawah benbolkyimey bu bininj nawu Heth benkebmawahmeng birribolkweykang.” ");
INSERT INTO gup_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Bu Jacob yakwong bu benwokrayekwoni bebeywurd nuye, wanjh nungka dengewayhmeng kore balabbala wanjh balwelengngolekdadjmeng baldoweng, malngwam kore mawahmawah nuyeni birriyingkihmalngdokmeng. ");
INSERT INTO gup_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Wanjh Joseph kukburriwerrinj kore kornkumo kukyoy dja bimarnenalkbuni bikukbunjhmangi. ");
INSERT INTO gup_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Bu kumekbe wanjh mankarre yoy bedberre nawu Egyptian bininj bu bininj nawu doweni wanjh munguyh birridjalkukbarungi bu forty barnangarra. Wanjh Joseph benwokrayekwong bininj nawu birrimarnedurrkmirri nawu birriburrbuni nawu bedman birridoweni bindikukbarungi ba minj birrikuknudmeninj, benmarneyimeng kabirrikukbarung kornkumo nuye nawu Israel. Wanjh kunu bedda birrikukbarungi, birridjalkukbarungi munguyh bu kunbarnangarra forty. Dja nawu birriwern Egyptian bininj munguyh birrihdjalmarnenalkbuni kunbarnangarra seventy. ");
INSERT INTO gup_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Dja bu yakminj birrimarnenalkbuni wanjh Joseph wokdanj bedberre bininj nawu birridjarrkni Pharaoh, benmarneyimeng, “Bu nuk ngudda ngurriyime ngaye ngamak, ngaye djawan ngudberre ngadjare ngurrimarneyime Pharaoh ");
INSERT INTO gup_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","kuhni kunwok bu ngardduk kornkumo ngandjurrkkang ngamarnewokkurrmerrinj kunwok kunrayek duninjh. Bu nungka darnkih dowehdoweni nungka nganwokwong nganmarneyimeng ngakukdudjeng kore kumidj nungan yingkihmidjmarnbom nungan nuye kore kubolkwarlah Canaan. Wanjh kunu ngaye djawan Pharaoh, kanmunkewemen ngakukdudjeng kornkumo ngardduk wanjh ngamdurndeng.” ");
INSERT INTO gup_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Wanjh Pharaoh biwokmey yimeng, “Yiray wanjh yikukdudje kornkumo ke bu nungka ngundjurrkkang yimarnewokkurrmerrinj kunwok kunrayek duninjh.” ");
INSERT INTO gup_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Wanjh Joseph wam kabikukdudjeng kornkumo nuye, kaluk birridjarrkwam bininj nawu birrikihkimuk birrimarnedurrkmirri Pharaoh, dabborrabbolk nawu birridjarrkni Pharaoh, dja dabborrabbolk rowk nawu birrini kore kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Dja mak birridjarrkwam rowk nawu Joseph birridjarrkni, dja birridanginj nuye, dja nawu kornkumo birridjarrkni. Bedda birridjarrkwam dja birridjalkudji birrini kore Goshen, nawu wurdwurd bedberre dja mayh nawu sheep, goat dja bulikki, bedda wanjh minj birridjarrkrawinj, dja birrini kore Goshen. ");
INSERT INTO gup_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Dja mak wirlbarra dorrengh birridjarrkwam dja bininj nawu birrimorneni djarrang. Wanjh nawu birriwam wanjh birrimirndewern duninjh. ");
INSERT INTO gup_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kaluk birribolkmey kore kunrurrk bininj kabirrimimkarrhkarrhme kore kunred Atad, kaluk bewhkah Jordan mankabo, wanjh kumekbe birrimarnenalkbuni wernkih duninjh, dja birrikangewarreni duninjh, dja kumekbe Joseph bimarnenjilngwarreni kornkumo nuye bu kunbarnangarra seven. ");
INSERT INTO gup_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Bu bininj nawu birrikang kumekbe kubolkwarlah Canaan bindinang birrinjilngwarreni kore kabirrimimkarrhkarrhme kore kunred nuye Atad, wanjh birriyimeng, “Nahni bininj nawu Egyptbeh kabirrikarrme kundowikenh dja kabirrimarnenjilngwarre duninjh.” Wanjh kunmekbekenh kunu birribolkngeykurrmeng Abel-Mizraim. ");
INSERT INTO gup_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Wanjh kunu bebeywurd nuye Israel birrimarnekurduyimeng bu nungka benwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bedda birrikukkang kore kubolkwarlah Canaan dja birrikukdudji kore kuwardderurrk kore kabbal kore Machpelah, koyekkah Mamre kore Ephron nawu Heth bikebmawahmeng bolkweykang Abraham. Nungka wanjh wardderurrkmey kabbal dorrengh kabirribolkkarrmekenh kabindikukdudjengkenh. ");
INSERT INTO gup_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Wanjh bu Joseph bikukdudji kornkumo nuye, nungka durndi kore Egypt, birridjarrkdurndi birridanginj nuye dja mak birriwern rowk nawu birridjarrkwam nawu birrikukdudjikenh kornkumo nuye. ");
INSERT INTO gup_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Wanjh bu kornkumo bedberre doweng, kunu wanjh birridanginj nuye Joseph birriburrbuni, birrimarneyimerrinj, “Wardi kunubewu Joseph kanwidnan kadberre dja kanmarnedurndiwe kunwarre bu ngad kunwern kunwarre karrimarnekurduyimi.” ");
INSERT INTO gup_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Wanjh kunu bindimunkeweng bininj kore Joseph dja birrimarneyimeng, “Kornkumo ke kanwokrayekwong ngadberre bu minj bangmedowimeninj, yimeng, ");
INSERT INTO gup_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Kuhni wanjh ngurrimarneyimen Joseph, “Ngaye djawan ngudda Joseph bu yibengmidjda kunwarre nawu ngurridanginj ngundimarneyimeng, dja ngaburrbun kunwarre kunwern ngundimarnekurduyimi.” Kuhni yimeng kornkumo ke dja ngad nawu karridanginj wanjh ngundidjawan kab yibengmidjda kunwarre ngadberre nawu ngarrimarnedurrkmirri God nuye nawu kornkumo ke.’” Wanjh bu kuhni kunwok birriyimeng bindiwokmulewam nawu birridanginj rowk, Joseph wanjh nalkbom. ");
INSERT INTO gup_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Wanjh birridanginj nuye birrimyikang birrimankarrinj kumirrk nuye birrimarneyimeng, “Yina, ngad ngundimarnedurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Dja Joseph benmarneyimeng, “Yuwn ngurrikele. Yiddok ngaye yimankek ngurriyime God? ");
INSERT INTO gup_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ngudda wanjh bonj, ngurridjareni kunwarre nganmarnekurduyimerrangimeninj ngardduk, dja God djareni kunmak ba bu birriwern kabirridjaldarrkid yiman bu bolkkime yimerranj. ");
INSERT INTO gup_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Wanjh kunu yuwn ngurrikele, ngaye nahnan ngudberre, manme won warridj ngudda dja wurdwurd ngudberre.” Wanjh kuhni kunmakmak benmarnewokdi munguyh benkangemarnmarnbuni. ");
INSERT INTO gup_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Wanjh Joseph ni kore kubolkwarlah Egypt, nungka dja birriwern rowk nawu kornkumo nuyeni. Wanjh Joseph mimbini bu mandjewk 110. ");
INSERT INTO gup_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph bennang nawu benkebmawahmeng, nawu Ephraim benbornang, dja wurdwurd nuye Machir nawu beywurd nuye Manasseh, bedda warridj Joseph bendjarrkmey kore kubard nuye bu birridanginj. ");
INSERT INTO gup_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Wanjh Joseph benmarneyimeng nawu birrimud, yimeng, “Ngaye ngokko darnkih ngarrowen. Dja God kaluk kamre ngunbidyikarrme ngudberre, dja ngunkan ngudberre ngurribolkbawon kondanjkunu kubolkwarlah, ngunkan kore kubolkwarlah kore benmarnewokkurrmerrinj Abraham, Isaac dja Jacob, nungka benmarnewokkurrmerrinj kunwok kunrayek duninjh bu kaluk kanbolkwon kadberre.” ");
INSERT INTO gup_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Wanjh Joseph bendjurrkkang birriwokkurrmerrinj kunwok kunrayek duninjh bininj nawu Israel benkebmawahmeng, yimeng, “God kamre ngunbidyikarrme ngudberre dja ngudda kandimurrngkan kondahbeh.” ");
INSERT INTO gup_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Wanjh kunu Joseph doweng bu nungka mandjewk nuyeni wanjh 110. Wanjh birrikukbaruy dja birrikukdahkendoy kore kundulk kumekbe kore Egypt, djahdjalkukdahkendi minj birrikukdudjeyi. ");
INSERT INTO gup_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Kunkare wanjh nakudji bininj ni nawu kunngey bokenh ngeyyoy. Kaluk Israel dja Jacob kunngey bokenh nuye. Nungka dja nawu bebeywurd nuye birridjarrkwam kore Egypt. Kaluk bedda wanjh birringeyyoy Reuben, Simeon, Levi dja Judah, Isaachar, Zebulun, dja Benjamin, Dan dja Naphtali, Gad dja Asher. Dja mak bedda bindidbebbehkang ngalbihbininjkobeng dja wurdwurd bedberre nawu bedman birridjarrkyoy. Bedda rowk nawu Jacob nungka benbornang dja nawu benkebmawahmeng rowk, wanjh seventy ni. Dja mak nabuyika beywurd nuye Israel nawu ngeyyoy Joseph, nungka wanjh ngokko yingkihni kore Egypt. ");
INSERT INTO gup_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kaluk yerrekah wanjh Joseph doweng, dja nawu birridanginj nuye birridowerrinj rowk. Dja mak bininj nawu birridjarrkdabborrabbolkni wanjh birridoweng rowk. ");
INSERT INTO gup_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kaluk binihbininj nawu Israel benkebmawahmeng, bedda wanjh bindikarrmi birriwern wurdwurd. Birriwern duninjh wurdyaw birriyawmahyawmarrinj, birrimirndewernmerrinj, birribalmirndekimukminj kore kumekbe birrihdi kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kaluk yerrekah wanjh nakerrnge king wanjh dedjdjingmey wohrnani kumekbe kubolkwarlah Egypt. Bedda birringeybom nawu Pharaoh. Kaluk nungka minj biwobekkayi nawu Joseph. ");
INSERT INTO gup_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Wanjh Pharaoh benmarneyimeng bedberre nungka nuyeni bininj nawu birriredboni, yimeng, “Kandibekka. Ngurrina nanih bininj nawu Israel benkebmawahmeng, wanjh bedda birrimirndewernminj dja birringudjkimukminj, wardi kunubewu kandingudjyurrhke kadberre. ");
INSERT INTO gup_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Dja baleh nuk ngad kandiyimowon? Kab karrbenmarneyingkihkarremarnbu, wardi kabirrimirndewernmerren munguyh dja bu bininj kabirrimre kandibunkenh, bedda nawu Israel benkebmawahmeng kaluk kabirriraworren nawu kandiwidnan, kandibun kadberre dja mak kabirrire kubolkbubuyika, kabirribolkbawon kubolkwarlahkenh kadberre.” Kumekbe bu Pharaoh benmarneyimeng nuye bininj. ");
INSERT INTO gup_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kumekbekenh kunu wanjh bindikurrmeng bininj nawu bindidjurrkkani bindimarnbuni bininj nawu Israel benkebmawahmeng bu birridjaldurrkmirri bedberre munguyh, ba bu birrikangedombuyhweyi bu kundulmuk duninjh birringorrkani bedberre. Wanjh bininj nawu Israel benkebmawahmeng birrimarnerurrkmarnbom manrurrkwern manbu Pharaoh nuye kore nungka karehkarekurrmi yehyeng nuye. Kaluk benebolkngeyyoy Pithom dja Ramses. ");
INSERT INTO gup_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Bininj nawu Egyptbeh wanjh bindiwarrewoni nawu Israel benkebmawahmeng. Dja bonj, djal djamku kuhni bindimarnekurduyimi. Bu bindihdjaldjurrkkani kunrayek duninjh munguyh, wanjh bedda bininj nawu Israel benkebmawahmeng wanjh birridjalmirndewernmerreni munguyh dja birridjalkaberrkwernmerreni warridj. Wanjh nawu bininj birrikang Egypt kaluk bindikengemi bedda nawu Israel benkebmawahmeng dja mak bindiwarreweyi bu bindimarneyimi bedberre. ");
INSERT INTO gup_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Wanjh kunmekbekenh kunu birrimekbe bininj nawu birrikang Egypt bindimarnbuni bininj nawu Israel benkebmawahmeng bu birridjaldurrkmirri bedberre bulkkidj duninjh. ");
INSERT INTO gup_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Bindimarnbom bindimarnedurrkmirri kore kunrurrkkenh birrimangi birrimarnbuni brick dja tar, dja mak kunbubuyika birrihdurrkmirri kore dudjihdudjindi manu manmekenh. Kaluk bedda nawu bininj birrikang Egypt wanjh birrimimkongiyakni bedberre bininj nawu Israel benkebmawahmeng. Bindidjaldjurrkkani munguyh, dja mak bindidjalnjilngwarrewoni munguyh. ");
INSERT INTO gup_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Wanjh nawu Hebrew daluk, wanjh ngalbihbininjkobeng bedberre bininj nawu Israel benkebmawahmeng, wanjh bu bedda wurdyaw bindimarneyawdangeni wanjh daluk bokenh bindibidyikarrmi. Bedda benengeyyoy Shiphrah dja Puah. Kaluk wanjh Pharaoh benbenemarneyimeng benemekbe daluk, yimeng berrewoneng, ");
INSERT INTO gup_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Bu ngurrbenbidyikarrme nawu Hebrew daluk bu wurdyaw karrangen, dja bu ngunenan narangem, wanjh nguneyawbu, dja bu ngaldaluk, wanjh bonj, nguneyawbawo karrarrkid.” ");
INSERT INTO gup_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Dja bedda nawu daluk bokenh wanjh benekengemi God, wanjh minj benekurduyimeninj nawu king benbenewokrayekwong, dja bindidjaldarrkidbawoni narahrangem rowk. ");
INSERT INTO gup_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kaluk kunmekbekenh kunu nungka king nawu wohrnani kore Egypt benbenekayhmeng bedda nawu daluk bokenh, dja yimeng berrewoneng, “Njalekah kunih bu ngunekurduyimeng, dja narahrangem ngurrbendarrkidbawong?” ");
INSERT INTO gup_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Bedda nawu daluk bokenh benemarneyimeng Pharaoh, beneyimeng, “Ngad yimankek kunmekbe nganekurduyimeninj. Dja nawu Hebrew daluk minj kabirrirohrok nawu daluk birrikang Egypt, dja bedda nawu Hebrew daluk wanjh birringudjmak dja mak werrkwerrk kayawdangen bedberre, bu minj ngad nganebangmebolkmang bu ngarrbenbidyikarrmekenh.” Kuhni bu benemarneyimeng nawu king. ");
INSERT INTO gup_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bu kunmekbe benekurduyimeng benemekbe daluk bokenh, wanjh God kunmak benbenemarnekurduyimeng, dja bininj nawu Israel benkebmawahmeng wanjh birridjalmirndewernminj munguyh dja birribalmirndekimukminj duninjh. ");
INSERT INTO gup_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Dja God benbeneyawwong benemekbe daluk bokenh nawu bindibidyikarrmi birribuyika daluk bu wurdyaw benhbuni. Kunmekbe God benbenemarnekurduyimeng bu bedda benemarnekeleni nawu nungka God. ");
INSERT INTO gup_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Wanjh Pharaoh benwokrayekwong bedberre rowk nawu bininj nuye, nawu nungan birriredbo, yimeng, “Narahrangem rowk nawu kabindimarneyawdangen bedberre nawu Hebrew bininj dja daluk, wanjh ngudda ngurrbenyawburriwemen kore mankabo, dja ngaldahdaluk rowk wanjh ngurrbendjaldarrkidbawo.” ");
INSERT INTO gup_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Bu kumekbe bolkyimi nakudji bininj nawu Levi bikebmawahmeng wanjh benemarrinj daluk ngalbu ngaleng warridj Levi bikebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kaluk ngaleng yawkani ngaldaluk. Kaluk yerrih wanjh yawoyhyawkani dja narangem bimarneyawdanginj. Dja bu ngaleng nang namekbe wurdyaw kukmakni wanjh biyawwarlkkang bu dird danjbik. ");
INSERT INTO gup_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Wanjh ngalmekbe daluk bu minj munguyh biyawwarlkkayi, wanjh kumekbe basket mey manbu birrimarnbom kundalk manbu mandalkkuyeng kukabo dingihdi. Wanjh manekke basket mey, baruy manbu yiman tar yerrih bu belbmeng ba kukku minj bongimeninj. Wanjh ngalbadjan bimey wurdyaw bikurrmeng kore basket, dja benedjarrkkang ngalyaw dorrengh, benekang kore mankabo kurrid ngarre. Kumekbe wanjh benekurrmeng benewarlkkang kore kurralk manbu mandalkkuyeng. ");
INSERT INTO gup_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kaluk ngalbadjan durndi kured dja ngalyaw ngarre, ngalbu benedanginj nawu wurdyaw, dingihdi djarrehbeh ba bu binahnani djarreh wurd nawu narangem bu baleh bimarnekurduyimerrangimeninj. ");
INSERT INTO gup_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kaluk ngalbu Pharaoh nuye ngalbeywurd wam kumekbe kore mankabo wurlebmeninj, dja daluk nawu birribidyikarrmi birrihdjalley kore kurrid ngarre mankabo. Ngaleng wanjh nang basket kore kurralk yongohyoy, dja bimunkeweng ngalyawk ngalbu bihmarnedurrkmirri, yimeng, “Yimka nawu basket!” ");
INSERT INTO gup_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ngalmekbe ngalbu ngalbeywurd nuye Pharaoh, bu dangmarrhmey basket, dja biyawnang nawu wurdyaw. Kaluk namekbe wurdyaw nalkbuni, wanjh ngalbu ngalyawk biyawkongibom. Wanjh ngaleng yimeng, “Ahwurd! Nanih wanjh nadjalkudji nawu Hebrew wurdyaw.” ");
INSERT INTO gup_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Wanjh ngaldaluk ngalbu benedanginj nawu namekbe wurdyaw, bebmeng bidjawam ngalmekbe ngalbeywurd nuye Pharaoh, yimeng, “Yiddok minj ngare ngakimang ngalkudji ngalbu Hebrew daluk ngunmarneyawdjikkawon?” ");
INSERT INTO gup_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Wanjh Pharaoh nuye ngalbeywurd yimeng, “Mah, yiray.” Wanjh ngalyaw wam bimey ngalbadjan nuye nawu wurdyaw. ");
INSERT INTO gup_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Wanjh Pharaoh nuye ngalbeywurd bimarneyimeng, “Yika nanih nawu wurdyaw, dja yinahna ngardduk, wanjh ngaye karremulewan.” Wanjh ngalbu ngalbadjan bimey namekbe wurdyaw dja binahnani. ");
INSERT INTO gup_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kaluk bu djordminj, ngaleng biyawwong Pharaoh nuye ngalbeywurd wanjh namekbe wurdyaw yimerranj ngalengngarre, dja bingeykurrmeng Moses. Kuhni bu ngalengman yimeng, “Ngaye ngabebkeng kukkubeh, wanjh kunmekbekenh kunu ngangeykurrme Moses kangeyyo.” ");
INSERT INTO gup_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kaluk bu Moses djordminj, dja nungka wanjh bininj yimerranj. Wanjh kaluk nungka bebmeng wam kore nawu Hebrew bininj birrihni nawu nungka birrimudni, dja kumekbe bennang bindimarnedurrkmirri bininj nawu birrikang Egyptbeh. Bennang kore bindidjurrkkani bindimarnbuni kunkimuk bindimarnedurrkmirri. Dja kumekbe binang nakudji bininj nawu Egyptbeh bihbuni nawu Hebrew bininj nungan Moses birrimudni. ");
INSERT INTO gup_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Wanjh nungka Moses djalwernhbolknanganang rowk, dja bu minj nangale nayi, wanjh nungka bibom namekbe bininj nawu Egyptbeh, wanjh bikukkurrmeng, dja bikukdudji kore kukayalanj bikukwarlkkang. ");
INSERT INTO gup_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kaluk malamalaywihni Moses bebmeng, dja benbenenang benebokenh nawu Hebrew bininj bedmandeleng benehburreni dja wanjh njilngwarreminj. Wanjh nungka bidjawam nawu nakudji yidngalkeng, bimarneyimeng, “Njalekah yihbun nawu ngunedjalmud duninjh?” ");
INSERT INTO gup_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Wanjh namekbe bininj biwokmey, yimeng, “Ngayh! Dja nangale ngunkurrmeng bu ngudda kanhmarnewohrnan, dja kandjadme ngadberre? Yiddok ngudda yidjare kanbun ngaye, yiman kayime ngudda yibom bininj nawu Egyptbeh?” Wanjh kunu Moses keleni dja baybaywi burrbuhburrbuni marneyimerrinj, “Woybukkih wanjh bininj rowk kabirriburrbun bu baleh ngakurduyimeng.” ");
INSERT INTO gup_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kaluk yerrekah bu Pharaoh biwobekkang kore Moses kurduyimeng, wanjh nungka karremarnbom bu bibuyikenh. Wanjh Moses kelerlobmeng bolkbawong Egypt dja mak bibawong Pharaoh. Nungka wanjh wam kore kubolkwarlah bolkngeyyoy Midian. Kumekbe djalwohrey, wanjh kalukburrk nungka yerrkang ni kore kungad darnkih. ");
INSERT INTO gup_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Kaluk kumekbe kore kubolkwarlah Midian nakudji bininj ni nawu ngeyyoy kunngey bokenh. Reuel dja Jethro kunngey bokenh nuye. Nungka wanjh priestni, wohrnawohrnani yiwarrudj bedberre. Dja nungka benkarrmi seven ngalbebeywurd. Kaluk bedda nawu seven birriyawkyawkni birriwam kore kungad birribomangi birriborrahkendongi kore manbu boyohboyoy bedberre mayh, sheep dja goat nawu nuye kornkumo bedberre. ");
INSERT INTO gup_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kaluk yikahwi bininj nawu birrihnahnani mayh wanjh birrimwam bindimunkeweng bedda nawu yawkyawk, dja Moses dolkkang benbidyikarrmeng nawu yawkyawk, bu benngehkeng bedberre, dja mak benbowong mayh bedberre nawu mirndehmirnderri. ");
INSERT INTO gup_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kaluk bu bedda birridurndi kore kornkumo bedberre, nungka bendjawam, “A! Njalekenh ngudda djalwerrkwerrk ngurrimbebmeng bolkkime, dja kuhni nuk kundedjumbungni?” ");
INSERT INTO gup_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wanjh bedda birriwokmey birriyimeng, “Nakudji nawu bininj nakang Egypt kanngehkeng ngadberre kore bininj nawu mayh kabirrinahnan kandimarnekurduyimi kunwarre. Dja warridj nungka kanmarnebomey dja mayh benbowong.” ");
INSERT INTO gup_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Wanjh Reuel bendjawam ngalbebeywurd nuye, yimeng, “A! Kaluk baleh kunu nawu bininj kahni? Njalekah ngurribawong? Dja ngurriray, ngurrimkimang ba kangun manme.” ");
INSERT INTO gup_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Wanjh Moses bekkarrinj kamak kumekbe kadjalni kore namekbe nawu bininj kore ni. Kaluk ngalkudji ngalbeywurd nuye bininj ngalbu ngeyyoy Zipporah nungka biwong Moses benemarrinj. ");
INSERT INTO gup_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Dja ngaleng bimarneyawmey narangem wanjh Moses yimeng, “Ngaye ngamwam ngani kore kubolkwarlah minj ngardduk kunred.” Wanjh kunmekbekenh kunu bingeykurrmeng Gershom. ");
INSERT INTO gup_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Wanjh Moses dingihdi bu kunkuyeng kore Midian. Kalukburrk namekbe king nawu wohrnani kore Egypt wanjh doweng. Kaluk bininj nawu Israel benkebmawahmeng wanjh munguyh birrinjilngwarreni dja birrikayhmi kunnjilngwarre dorrengh kore birribongdi kore bininj nawu birrikang Egypt bindikurrmeng, dja bindimarnbom bindimarnedurrkmirri. Wanjh kumekbekenh kunu birrikayhmi bu yimankek nangale benbidyikarrmeninj. Birrikayhmi kore God benbekkang. ");
INSERT INTO gup_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Wanjh God bendjalbekkang bu birrikayhmi kunnjilngwarre dorrengh. Dja God burrbom bu kunkare nungka wokkurrmerrinj benberrebbom Abraham, Isaac dja Jacob. ");
INSERT INTO gup_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Dja nungka God bennang birrimekbe bininj nawu Israel benkebmawahmeng wanjh burrbuni kore benmarnekurduyimerranj dja benkongibom. ");
INSERT INTO gup_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses nahnani mayh kumirnde nuye Jethro nawu bindoy nuye. Nawu nungka Jethro priestni dingihdi kore Midian. Wanjh Moses benmirndekang mayh djarreh kore kubolkdarleh borledmikenh, dja bebmeng kore mandulumkimuk kawarddengeyyo Horeb. Kunmekbe kunred wanjh God nuye kunwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kaluk kumekbe angel nuye Yawey bimarnebukkarrinj dingihdi kore kunak manbirluwoldjen kumbebmerreni kore mandulkyahwurd. Moses wanjh nang manekke kundulk, dja mak kunak nang dja minj dulkruyi. ");
INSERT INTO gup_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Wanjh Moses yimeng, “Ngaray darnkih nganan manihbu kunbuyika duninjh dja njalekah minj karrulkrung.” ");
INSERT INTO gup_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Bu Yawey binang Moses wam dulknang, wanjh nungka bikayhmeng kore kurrulkbeh yimeng, “Moses! Moses!” Wanjh Moses yimeng, “A! Ngaye wanjh konhda ngahdi. Bu bekkabekkan.” ");
INSERT INTO gup_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Wanjh God yimeng, “Yuwn yimre darnkih, dja yirrengeyerrkerrimen nawu yihdengedjongbuyindi, wanjh kunukka kore yihdi wanjh kubolkdjamun ngardduk.” ");
INSERT INTO gup_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Dja mak God yimeng, “Ngaye wanjh God nuye kornkumo ke. Ngaye wanjh God nawu nuye Abraham, dja mak God nuye Isaac, dja mak God nuye Jacob.” Wanjh Moses djudkurlmeng dja kebwarlkkarrinj dja nungka keleni bu yimankek binayi God. ");
INSERT INTO gup_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Wanjh Yawey yimeng, “Ngaye woybukkih nganang kunnjilngwarre bedberre ngardduk bininj nawu kabirrini kore Egypt, dja ngabenbekkang bu birrikayhmi kore bininj nawu birrikang Egypt kabindidjurrkdjurrkwon bulkkidj. Ngaye ngaburrbun rowk kabirrihdjakbekkan. ");
INSERT INTO gup_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Wanjh kunmekbekenh kunu ngaye ngamkoluy ba ngabenbebke kore bininj nawu birrikang Egypt kabindimarnekurduyime kunwarre. Ngabenbebke Egyptbeh, dja ngabenkan kore kubolkmak kabolkwarlah duninjh, kumekbe kore manme manmakkaykenh manwern duninjh kadjokodjordmerren. Kumekbe kunred kore bininj bolkkime kabirrihni nawu birribebbehwokbubuyika nawu kabirribebbehmirndengeyyo bininj nawu Canaan benkebmawahmeng, dja mak bininj nawu Heth benkebmawahmeng, dja mak bininj nawu kabirringeyyo Amor, dja mak nawu kabirribebbehngeyyo Periz bininj, dja mak Hiv bininj, dja mak nawu birrikang kunred Jebusbeh.” ");
INSERT INTO gup_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","“Dja bolkkime kanbekka. Ngabenbekkang bininj nawu Israel benkebmawahmeng, bu birrikayhmi, dja nganang bu bininj nawu Egyptbeh kabindidjurrkdjurrkwon munguyh kabindikuyindombuyhwe. ");
INSERT INTO gup_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kunmekbekenh ngaye wanjh munkewe ngudda kore Pharaoh, ba yibenbebke ngardduk bininj nawu Israel benkebmawahmeng kabirrimbebme kumekbe kore Egyptbeh. Mah, wanjh yiray!” ");
INSERT INTO gup_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Wanjh Moses bimarneyimeng God, yimeng, “Ngaye nuk ngawarre bu minj nuk ngare kore Pharaoh ngabenbebke bininj nawu Israel benkebmawahmeng kore Egyptbeh?” ");
INSERT INTO gup_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Dja God bimarneyimeng, “Ngaye kaluk ngarrdjarrkre. Bu yibenbebke Egyptbeh wanjh kondah ngurrimre bu kandimarnedi yiwarrudj kore maninjmanu kunwarddekimuk. Kunmekbe wanjh kaluk yiburrbun bu woybukkih ngaye munkeweng.” ");
INSERT INTO gup_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Wanjh Moses bimarneyimeng God, yimeng, “Yina, wardi bu ngaye ngare kore kabirrihni, ngabenmarnebebme birrimekbe bininj nawu Israel benkebmawahmeng, dja ngabenmarneyime, ngayime, ‘God nganmunkeweng ngaye, namekbe wanjh God bedberre nawu mawahmawah, nungka nganmunkeweng.’ Dja bu kuhni ngabenmarneyime, wardi ngandidjawan, ngandimarneyime, ‘Baleh kaluk kangeyyo nahni nawu God ngunmunkeweng?’ Bu kunmekbe ngandimarneyime, ngaye baleh ngabenmarneyime?” ");
INSERT INTO gup_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Wanjh God bimarneyimeng Moses, yimeng, “Ngaye nawu ngayingkihyingkihdi dja ngahni munguyh.” Dja mak God yimeng, “Kuhni wanjh yibenmarneyimen bininj nawu Israel benkebmawahmeng, wanjh yiyimen, ‘Namekbe nawu nganmunkeweng kangeyyo “Ngaye nawu ngayingkihni bu munguyh munguyh.” ’ Kuhni wanjh kunngey nuye.” ");
INSERT INTO gup_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kuhni warridj God bimarneyimeng Moses, yimeng, “Kuhni wanjh yibenmarneyimen bininj nawu Israel benkebmawahmeng, yiyimen, ‘Yawey nawu God nganmunkeweng ngamwam ngudberre. Nungka wanjh God ngudberre nawu mawahmawah. Nungka wanjh God nuye Abraham, dja nungka God nuye Isaac, dja God nuye Jacob.’ Kuhni bu yibenmarneyimen. Kuhni wanjh ngadjalngeyyo munguyh munguyh, kaluk nawu rerrererre kabirridangerrinj wanjh kunmekbe ngandidjalngeybun Yawey bu munguyh munguyh.” Kuhni bu Yawey nawu God bimarneyimeng Moses. ");
INSERT INTO gup_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Wanjh Yawey biyawoyhmarneyimeng Moses, yimeng, “Yiray wanjh, dja yibenmirndemornnamen dabborrabbolk bininj nawu Israel benkebmawahmeng, dja yibenmarneyimen bu ngaye marnebebmeng nawu Yawey, dja ngaye nawu God bedberre nawu mawahmawah Abraham, Isaac dja Jacob. Dja yibenmarneyimen bu ngaye ngabennang bu baleh bindihmarnekurduyimi kore Egypt, ");
INSERT INTO gup_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","dja ngabenmarnewokkurrmerren bu woybukkih duninjh ngabenbebke Egyptbeh kore kabirrinjilngwarre, dja ngabenkan kore kubolkwarlah nawu bininj kabirrihni kore Canaan, dja mak nawu Heth benkebmawahmeng, dja mak bininj nawu birringeyyoy Amor, dja mak nawu kabirribebbehngeyyo Periz, dja mak nawu Hiv bininj, dja mak bininj nawu birrikang kunred Jebus. Kaluk kunred kore manme manwern kadjokodjordmerren. Kuhni wanjh yibenmarneyimen. ");
INSERT INTO gup_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Wanjh bedda bininj nawu Israel benkebmawahmeng dabborrabbolk wanjh ngundibekkan. Kaluk ngurridjarrkray kore king nawu kawohrnan kore Egypt ngurrimarneyimen, ‘Yawey nawu God ngadberre nawu Hebrew bininj, wanjh kumwam bebmeng ngadberre, wanjh kunukka bolkkime ngundidjawan kanmunkewe ngadberre kunkak danjbik kore kubolkdarleh ba bu mayh ngarrimarnebun nuye Yawey nawu God ngadberre.’ Kuhni wanjh ngurrimarneyimen namekbe nawu king.” Kuhni bu God bimarneyimeng Moses. ");
INSERT INTO gup_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Dja mak God bimarneyimeng, “Ngaye ngaburrbun bu nungka king nawu kawohrnan Egypt minj ngunmunkewe ngudberre, kalukburrk bu ngaye ngawernhdjurrkkan namekbe nawu king, ngadjurkkan kundulkarre dorrengh wanjh kunu ngunmunkewe ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Wanjh ngayeman kaluk ngakurduyime kundulkarre dorrengh bedberre bininj nawu birrikang Egypt, bu ngayeman ngabenbun rowk, ngabenmarneyime kundjalwern bu kabirrikunikangebarrhme. Kunmekbe kaluk wanjh namekbe nawu king ngunmunkewe ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Dja mak kunbuyika ngakurduyime. Ngaye ngabenmarnbun bininj nawu Egyptbeh ngundimarneyime kunmak, ba bu ngurrire, minj ngurribidlarrkre. ");
INSERT INTO gup_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kaluk ngudberre daluk rowk kabindiyidjawan daluk Egyptbeh nawu kabirridarnhmarnedi dja nawu kabirriwohni kore kunrurrk ngudberre, kabindiyidjahwon yehyeng manmakmak nawu ngurridjongburren silver dja gold dja mak kunmadj, dja wanjh ngurrbendjongbu nawu bebeywurd dja ngalbebeywurd ngudberre. Kunmekbe wanjh ngurrbenyiyakwon kunmakmak bedberre bininj nawu Egyptbeh.” ");
INSERT INTO gup_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Wanjh Moses biwokmey Yawey nawu God, yimeng, “Dja kaluk baleh ngayime bu ngabenmarneyime bininj nawu Israel benkebmawahmeng, dja bedda minj ngandiwoybukwon dja minj mak ngandibekkan, dja wanjh kabirriyime bu yimankek ngudda Yawey minj kanmarnebebmeninj?” ");
INSERT INTO gup_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Wanjh Yawey bimarneyimeng Moses, yimeng, “Ngudda njale nakka yikarrme kubid ke?” Moses yimeng, “Mahni wanjh kundulk ngarrulkkarrme.” ");
INSERT INTO gup_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yawey yimeng, “Yirrulkburriwemen kurorre.” Wanjh Moses dulkburriweng kurorre, wanjh manekke kundulk djalkukyimerranj nayin duninjh, wanjh Moses kelerlobmeng. ");
INSERT INTO gup_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Wanjh Yawey bimarneyimeng, “Yidarrkidma kuberd.” Wanjh kunu Moses bidyirriyonginj, mey nawu nayin, wanjh yawoyhdulkyimerranj kundulk kore kubid nuye. ");
INSERT INTO gup_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Wanjh Yawey bimarneyimeng, “Kuhni yikurduyimen bedberre ba kabirriwoybukwon bu ngaye marnebukkarrinj, ngaye nawu Yawey, ngaye nawu God bedberre nawu mawahmawah. Ngaye wanjh God nuye Abraham, dja mak God nuye Isaac dja mak God nuye Jacob.” ");
INSERT INTO gup_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kuhni mak Yawey bimarneyimeng Moses, yimeng, “Yibidngimen kore namekbe nawu yidjongbuyindi.” Wanjh Moses bidngimiworrinj, dja bu bidbebkerrinj wanjh kundjak bimey kubid bidkulahwarreminj, bidbeleminj duninjh yiman yerrih delek. ");
INSERT INTO gup_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Wanjh Yawey yimeng, “Yiyawoyhbidngimen.” Wanjh kunu yawoyhbidngimeng, dja bu bidbebkerrinj kumekbe wanjh bidmakminj rowk, bidkulahmakminj yiman kunkulah rowk kubuhburrk nuye. ");
INSERT INTO gup_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Wanjh Yawey yimeng, “Kuhni yibenmarnekurduyimen bu yibenbukkan kundulkarre ngardduk. Kundulk werrk yibenbukka dja bu minj ngundiwoybukwon dja minj mak ngundiwokbekkan wanjh kuhni kunbuyika yibenbukka kunbidwali ba bu kunukka nuk ngundiwernhwoybukwon. ");
INSERT INTO gup_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Dja bu minj ngundiwoybukwon dja minj mak ngundiwokbekkan bu manekke bokenh yibenbukkan, wanjh yiboma kukku kore mankabo, dja yiboyakbu kuberrkkombuk wanjh manekke kukku kaboyimerran kunkurlba kumekbe kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Wanjh Moses bimarneyimeng Yawey, yimeng, “Aba! Yina nawu kanmarnewohrnan, ngaye ngadjalwokmayaliwarre. Minj kerrngehkenh ngawokmayalimakniwirrinj dja bu ngudda kanmarnewokdanj ngaye ngadjalwokmayaliwarre bolkkime. Ngaye yeledj ngawokdi dja ngadjenkelk.” ");
INSERT INTO gup_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Wanjh Yawey bimarneyimeng, “Yina! Yiburrbun ngaye nawu Yawey ngabenmarnbun bininj bu kabirriwokdi, dja bu kabirridangdubbe, dja bu kabirrikanemdubbe. Ngabenmarnbun warridj bininj bu kabirribolknan dja nuk kabirrimimbunjemen. Dja ngaye wanjh Yawey ngabenmarnbun bininj kabirriyimerran kore ngadjare. ");
INSERT INTO gup_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kunu wanjh yiray, dja ngaye bidyikarrme bu yiwokdi, ngayeman kunwok bukkabukkan bu baleh ngudda yibenmarneyime.” ");
INSERT INTO gup_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Wanjh Moses yimeng, “Ngudda nawu kanmarnewohrnan, djaldjawan nabuyika yimunkewemen.” ");
INSERT INTO gup_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Wanjh kunu Yawey kangewurlhmeng dja bimarneyimeng Moses, yimeng, “Kab, dja nawu ngudda ngunedanginj nawu Aaron nawu Levi ngunbenedjarrkkebmawahmeng. Ngaburrbun bu nungka wokmak. Kaluk nungka kamhre bolkkime ngundabke, dja bu ngunnan, nungka wanjh kakangemarrmarrmen. ");
INSERT INTO gup_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ngudda kaluk yimarneyimen dja mak yiwokwon kunwok nawu nungka kaluk kayime, ngaye kaluk bidyikarrme bu yiwokdi, dja nungka mak ngabidyikarrme bu kawokdi. Ngaye benbenebukkan bu baleh ngunekurduyime. ");
INSERT INTO gup_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Nungka kaluk kawokdi ke, kore ngudda yidjare kabenmarneyime bininj. Dja ngudda yiman God rerrih kore yimarneyime baleh kabenmarneyime. ");
INSERT INTO gup_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Dja mak ngudda maninjmanu kundulk yirrulkkan kore kubid ke, ba yibenbukkan kunbubuyika kundulkarre ngardduk, ba kabirriburrbun bu ngaye marnebukkarrinj ngudda.” Kuhni wanjh Yawey bimarneyimeng Moses. ");
INSERT INTO gup_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Wanjh Moses durndi kore bindoy nuye Jethro dja bimarneyimeng, “Kab djawan bu kanmunkewe, ngarrurndeng kore Egypt ngabennan nawu ngarrimud ba bu bedda kunubewu kabirridjaldarrkiddi.” Wanjh Jethro bimarneyimeng Moses, yimeng, “Mah, wanjh kamak bu yire.” ");
INSERT INTO gup_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Kaluk bu kerrngehkenh Moses djahdjalni kore Midian, wanjh Yawey bimarneyimeng, “Bininj rowk nawu birridjareni ngundibuyi, bedda wanjh birridoweng, dja wanjh yirrunde kore Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Wanjh kunu Moses benmey ngalbininjkobeng nuye dja bebeywurd nuye, benkurrmeng kore kubodme nuye mayh nawu donkey birrimorneni dja birridjarrkdurndi kore kubolkwarlah Egypt, dja Moses dulkkahdulkkani kubid nuye kundulk manbu God nuye. ");
INSERT INTO gup_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Wanjh Yawey bimarneyimeng Moses, yimeng, “Bu ngudda yirrurndeng kore Egypt, wanjh yikurduyimen rowk kore Pharaoh kumirrk nuye, yibukka kunbubuyika rowk bu namakmak nawu ngaye dulkarrewong. Yibukka dja bonj, yiman djamku yibukkan, dja ngaye munguyh ngakangerayekwon ba nungka minj bininj kabenmunkewe. ");
INSERT INTO gup_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","23","Dja ngudda kaluk yimarneyimen Pharaoh, yiyime, ‘Kuhni bu Yawey ngunmarneyime, Mah. Wanjh yibenmunkewemen ngardduk bininj nawu Israel benkebmawahmeng ba ngandimarnedi yiwarrudj. Dja bedda wanjh yiman kayime nadjdjaman rowk ngardduk. Dja bu ngudda kandahme minj yibenmunkewe, kunukka wanjh ngaye ngabun beywurd ke nawu nadjdjaman.’ Kuhni bu yimarneyime nawu Pharaoh.” ");
INSERT INTO gup_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Wanjh Moses dja nawu birrimudni birribolkbawong Midian dja birriwam. Birridjalwam wanjh birriwohyonginj wohka. Kaluk kumekbe kore birriyonginj, wanjh Yawey bendabkeng bu yimankek bibuyi dowimeninj Moses nuye wurdyaw nawu nadjaman. ");
INSERT INTO gup_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Wanjh Zipporah ngalbu Moses nuye ngalbininjkobeng, mey kunwardde manbu manwarddemirrhmak dja birradjkeng bilakkayenwong nayaw ngarre, wanjh bikulahkurrmeng kore kurrenge nuye nayaw, dja mak ngaleng bimarneyimeng nawu wurdyaw, yimeng, “Woybukkih wanjh ngudda nawu ngardduk kunkurlbakenh.” Kunmekbe yimeng bu bilakkayenwong wurdyaw. Wanjh kumekbekenh kunu Yawey birrarrkidbawong namekbe nayaw dja minj bibuyi. ");
INSERT INTO gup_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Kaluk Yawey bimarneyimeng Aaron, yimeng, “Yiray kore kubolkdarleh yirrabke Moses.” Wanjh nungka wam birrabkeng kore God nuye kunwarddekimuk, dja bibunjhmey. ");
INSERT INTO gup_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Wanjh Moses bimarneyimeng kunwok rowk nawu God bimarneyimeng bu bimunkeweng, dja mak kunbubuyika rowk namakmak nawu Yawey biwokrayekwong Moses, kaluk kakurduyime kabenbukkabukkankenh bu God bimarnebebmeng. Kuhni rowk Moses bimarneyimeng Aaron. ");
INSERT INTO gup_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Wanjh Moses dja Aaron benebolkbawong manwarddekimuk bolkngeyyoy Horeb, dja benewam kore kubolkwarlah Egypt. Kaluk bu kumekbe benebebmeng, wanjh bindimirndemornnameng rowk dabborrabbolk bedberre bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Dja Aaron benmarneyimeng kunwok rowk nawu Yawey bimarneyimeng Moses, dja mak kurduyimeng namakmak kundulkarre dorrengh kore bininj birrinani benhbukkani bu Yawey bimarnebebmeng. ");
INSERT INTO gup_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Wanjh bedda nawu bininj birriwoybukwong, dja bu birribekkang bu Yawey kumwam bedberre kabenbidyikarrmekenh, dja bu nungka nang kunnjilngwarre bedberre, wanjh bedda birridjudkurlmi birriburlumeng nuye. ");
INSERT INTO gup_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Kaluk bu yerrekah Moses dja Aaron benewam kore Pharaoh benemarneyimeng, “Yawey nawu God ngadberre bininj nawu Israel kankebmawahmeng, kuhni wanjh ngunhmarneyime, ‘Ngudda Pharaoh, yibenmunkewemen ngardduk bininj ba bu ngandimulilmang ngandikukenwon kore kubolkdarleh.’” ");
INSERT INTO gup_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Dja Pharaoh yimeng, “Nangale kaluk Yawey bu yimankek ngaye ngawokmarrkmang dja munkewe ngudberre bininj nawu Israel ngunkebmawahmeng? Ngaye ngakukwakwan Yawey, dja warridj minj munkewe ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Wanjh bedda nawu Moses dja Aaron benemarneyimeng, “God nawu ngadberre Hebrew bininj, bebmeng ngarrewoneng, wanjh ngundidjawan bu kanmunkewemen ngadberre, kunkak danjbik ngarrire kore kubolkdarleh, mayh ngarribun dja yiwarrudj dorrengh ngarridi nuye God ngadberre nawu Yawey. Bu minj ngarrire wardi Yawey kundjak kamunkewe ngadberre kanbun dja nuk kabenmunkewe bininj bu kanbun mandjawak.” Kuhni bu Moses dja Aaron benemarneyimeng nawu Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Dja bonj, namekbe nawu wohrnawohrnani kore Egypt minj benbenebekkayi, dja benbenemarneyimeng, yimeng, “Ngayh! Ngudda Moses dja Aaron, njalekah ngurrbendjurrkkan bininj nawu Israel benkebmawahmeng kabirribawon kabirridurrkmirri? Bonj. Dja ngurridjarrkdurrkmirrin rowk.” ");
INSERT INTO gup_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Mak Pharaoh yimeng, “Dja ngunena! Ngudberre bininj nawu Israel benkebmawahmeng wanjh birrimirndewernminj, dja ngudda ngurrbenngurdke kore kabirridurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Bu kundjalmekbe kunbarnangarra wanjh Pharaoh benwokrayekwong bininj nuye nawu birribangni nawu bindidjurrkkani bininj nawu Israel benkebmawahmeng, dja mak benwokrayekwong yikahwi bininj nawu Israel benkebmawahmeng nawu bindinahnani bedmandeleng. Bedda wanjh bindinahnani nawu birriredboni bininj bu birridurrkmirrikenh. ");
INSERT INTO gup_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","8","Pharaoh benmarneyimeng birrimekbe bininj rowk, yimeng, “Nahni bininj nawu Israel benkebmawahmeng minj kabirriwernhdurrkmirri. Kunmekbekenh kunu wanjh kuhni ngandidjawan, kabirriyime, ‘Kanmunkewemen ngadberre ngarrire mayh ngarribun dja yiwarrudj dorrengh ngarridi God ngadberre.’ Bonj. Karrbenmarnerayekwo. Dja ngudda bu ngurrbendalkwon brickskenh kabirrihmarnbun, wanjh bonj kunukka, bolkkime yuwn ngurrbendalkwon, dja bedman birriray birridalkma bedman bedberre. Madjamku bedman kabirridalkyawan, dja munguyh kabirridjalmarnbun nawernkenh brick, yiman kerrngehkenh birrimarnbuni bu ngurrbendalkwoni dorrengh, dja yuwn kabirriwohmirndeyahwurdmen brick manbu kabirrihmarnbun. ");
INSERT INTO gup_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ngurrbenmarnewernwo kabirridurrkmirri ba kabirridjaldurrkmirri, dja minj kabirribekkan nawu kabindihkowe.” Kuhni bu Pharaoh benmarneyimeng bininj nuye. ");
INSERT INTO gup_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Wanjh kunmekbekenh wanjh bininj nawu bindidjurrkkani dja bininj nawu bindiwohrnani wanjh birrimbebmeng dja bindimarneyimeng bininj nawu Israel benkebmawahmeng, wanjh birriyimeng, “Pharaoh yimeng bu nungka ngundalkkaybun. ");
INSERT INTO gup_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mak Pharaoh yimeng bu ngudman ngurriray ngurridalkma kore baleh yarrkka ngurridalkngalke, dja ngurridjalmarnbun yiman kunyungkih ngurrihmarnbuni nawernkenh brick. Minj mak kawohmirndeyahwurdmen nawu ngurrimarnbuni ngurridurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Wanjh kunu bininj nawu Israel benkebmawahmeng birriyarlahyarlarrmeng birriwam kubolkbubuyika rowk kore kubolkwarlah Egypt, birridalkmangi brickskenh kabirrimarnbun. ");
INSERT INTO gup_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Wanjh bininj nawu bindidjurrkkani bindiwernhdjurrkdjurrkwoni bulkkidj, birriyimi, “Kunbarnangarrabubuyika ngurridjalmarnbu nawernkenh brick yiman kunyungkih rerrih ngurrihmarnbuni bu ngundidalkwoni.” ");
INSERT INTO gup_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Yikahwi bininj Israel nawu benkebmawahmeng, wanjh Pharaoh bendjarrngbom benkurrmeng kore bindimarnewohrnani birribuyika bininj nawu Israel benkebmawahmeng. Dja Pharaoh nuye bininj nawu bindidjurrkkani bedda wanjh bindiwidbihkeng birrimekbe nawu bindikurrmeng kabindimarnewohrnankenh bininj nawu Israel benkebmawahmeng, bindiwidbihkeyi bindidjawani dorrengh, “Njalekenh minj baleh ngurriyakwoyi ngurrihmarnbuyi nawernkenh brick yiman kunyungkih ngurrihmarnbuni?” ");
INSERT INTO gup_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Wanjh bedda bininj nawu Israel benkebmawahmeng, nawu bindimarnewohrnani birribuyika, wanjh birriwam kore Pharaoh birrimarneyimeng kunnjilngwarre dorrengh, “Njalekenh kuhni bu kunrayek kanmarneyime ngadberre nawu ngarrimarladj? ");
INSERT INTO gup_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Djaldjamku minj ngad kandidalkwon ngadberre nawu ngarrimarladj, ngandidjalmarneyime ngarrimarnbun brick. Dja yina, njalekenh ngandiwidjbihke ngad nawu ngarrimarladj? Kuhni wanjh djalburudjang dja ngudda ke bininj wanjh ngandikebrokwarrewong ngadberre.” Kuhni bu birrimarneyimeng Pharaoh nawu bininj Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Dja wanjh Pharaoh yimeng, “Ngudda wanjh ngurringudjwarre dja minj ngurriwernhdurrkmirri! Kunmekbekenh kunu ngurriyime, ‘Mah. Karriray karribun mayh bu mak karrimarnedi yiwarrudj Yawey nuye.’ Kuhni bu ngurriyime. Wanjh bonj. ");
INSERT INTO gup_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ngurridurnde ngurridurrkmirrin, dja minj mak dalkwon ngudberre dja ngurridjalmarnbu nawernkenh brick yiman kunyungkih ngurrihmarnbuni.” ");
INSERT INTO gup_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Bedda nawu birriwohrnani bedberre bininj nawu Israel benkebmawahmeng, bu birriwokbekkang, wanjh kunu bedda birriburrbom mankarrerayek duninjh bebmeng bedberre. ");
INSERT INTO gup_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Wanjh bu birribawong birribebmeng kore Pharaoh kunrurrk nuye wanjh bindimarnebebmeng bindidabkeng Moses dja Aaron nawu bindimadbuni kuberrk, ");
INSERT INTO gup_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","dja bindimarneyimeng, “Ngudda wanjh ngunemarnbom kunyid dja ngurrbenmarnbom Pharaoh dja bininj nuye nawu kabirrimarnedurrkmirri wanjh kandiwidnan kadberre, dja yiman rerrih ngurrbenbidnakenwong mandjawak kandibunkenh. Wanjh kunmekbekenh kunu ngad ngarridjare Yawey ngunbenenan dja ngunbenedjuhbun ngorrewoneng.” ");
INSERT INTO gup_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Wanjh Moses yawoyhdanginj yiwarrudj kore Yawey dja yimeng, “Ngudda nawu Yawey, njalekenh kunwarre yibenmarnekurduyimeng bedberre nanih bininj nawu Israel benkebmawahmeng? Dja njalekenh ngaye kanmunkeweng bedberre bu kondah? ");
INSERT INTO gup_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Bu ngawam kore Pharaoh ngudda Yawey marnewokdanj, nungka wanjh kundjalwarre kahkurduyime bedberre nanih bininj nawu Israel benkebmawahmeng. Dja ngudda minj kanwohbidyikarrmeninj bu kanbebkemeninj ngad nawu bininj ke. Dja djalburrkyak.” ");
INSERT INTO gup_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Wanjh Yawey bimarneyimeng Moses, yimeng, “Mah! Dja bolkkime wanjh yinan bu baleh ngamarnekurduyime Pharaoh, ngayeman nawu ngarrulkarrekimuk ngamarnbun nungka kaluk kabenmunkewe kabirrire bininj nawu Israel benkebmawahmeng. Yoh, wanjh, dja mak ngaye nawu ngarrulkarrekimuk ngamarnbun Pharaoh kabendjirrkkan dorrengh ba kabirribolkbawon kubolkwarlah nuye.” ");
INSERT INTO gup_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Wanjh God biyawoyhmarneyimeng Moses, yimeng, “Ngaye wanjh Yawey. ");
INSERT INTO gup_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ngaye ngabenbebbehmarnebebmeng ngabenbebbehmarnekukbukkarrinj Abraham, Isaac dja Jacob. Dja bedda minj ngabenmarnengeybukkarrimeninj bu ngahngeyyo Yawey, dja birridjalburrbuni bu ngangeyyo El Shaddai. ");
INSERT INTO gup_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Dja ngabenmarnewokrayekworrinj kunwok ngardduk warridj nawu ngawokkurrmerrinj ngabenberrebbom bu kaluk ngabenbolkwon kubolkwarlah Canaan, kore birridjalni kore minj bedberrekihniwirrinj kunred. ");
INSERT INTO gup_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Dja mak warridj ngabenbekkang bininj nawu Israel benkebmawahmeng bu kunnalk dorrengh ngandikayhme dja nawu bininj Egyptbeh yiman kabindihbongkan rerrih, dja wanjh ngaye ngaburrbun kore ngawokkurrmerrinj ngabenberrebbom korroko.” ");
INSERT INTO gup_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Kunmekbekenh kunu yibenmarneyimen bininj nawu Israel benkebmawahmeng, kanwokmulewa ngayime bedberre, ‘Ngaye wanjh Yawey, nawu ngayeman bebke ngudberre kore ngundihdjurrkkani ngurrihdurrkmirri bedberre bininj nawu Egyptbeh, ngaye yerrkke ngudberre kore ngundihbongkarrme rerrih. Ngaye ngabidyirriyongen kunngudj dorrengh ngardduk bu bebke ngudberre. Dja warridj ngabenwelengname bininj nawu Egyptbeh kore ngabenmarnekurduyime kunkimukkenh duninjh. ");
INSERT INTO gup_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ngaye mang ngudberre dja mak marnbun ngurriyimerran ngardduk bininj, dja ngaye ngayimerran God ngudberre. Kaluk bu kunmekbe ngakurduyime, wanjh ngurriburrbun bu ngaye wanjh Yawey nawu God ngudberre, dja ngaye bebkeng ngudberre kore bininj nawu Egyptbeh ngundihbongkarrmi. ");
INSERT INTO gup_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kaluk ngaye kan ngudberre kore kubolkwarlah ngaye ngawokkurrmerrinj kunwok kunrayek duninjh kore ngabenbolkwonkenh Abraham, Isaac dja Jacob, wanjh kunmekbe kubolkwarlah ngaye bolkwon ngudberre ngurribolkkarrme. Bonj. Kumekbe ngayime, ngaye nawu Yawey.’ Kuhni yibenmarneyimen bininj nawu Israel benkebmawahmeng.” ");
INSERT INTO gup_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Kuhni rowk bu God bimarneyimeng Moses, wanjh Moses benmarneyimeng bininj nawu Israel benkebmawahmeng, dja bedda minj birribekkayi Moses. Kumekbekenh minj birribekkayi dja bininj nawu Egyptbeh bindidjurrkkani bindimarnbuni kunkimuk bindimarnedurrkmirri yiman bindibongkarrmi rerrih, dja kunu wanjh minj birribekkayi, dja birridjalkangewarreni. ");
INSERT INTO gup_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Wanjh Yawey bimarneyimeng Moses, yimeng, ");
INSERT INTO gup_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Yiray kore Pharaoh nawu kawohrnan kubolkwarlah Egypt dja yimarneyimen kabenmunkewe bininj nawu Israel benkebmawahmeng kabirrire ba kabirrimarnebolkbawon kubolkwarlah nuye.” ");
INSERT INTO gup_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Dja Moses biwokmey Yawey, yimeng, “Yina, nahni bininj nawu Israel benkebmawahmeng minj ngandibekkan ngaye. Dja bonj, njalekah yimankek kuhni Pharaoh nganbekkan ngaye nawu ngadjalwokwarre?” ");
INSERT INTO gup_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Wanjh Yawey benbenewokrayekwong Moses dja Aaron, dja wokrayekwon berrewoneng bu kabindibebkekenh bininj nawu Israel benkebmawahmeng kore kunbolk Egyptbeh. ");
INSERT INTO gup_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Nanih wanjh kabirringeybimdi nawu birriwohrnani kore nawu bedman birribebbehmudni. Reuben nawu Israel beywurd nuye nawu nadjdjaman wanjh bebeywurd benbornang Hanoch, Pallu, Hezron dja Carmi. Bedda wanjh Reuben nuye birrimudni duninjh nawu bindingeykenhkani. ");
INSERT INTO gup_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Nawu Simeon benbornang bebeywurd nuye wanjh Jemuel, Jamin, Ohad, Jakin, Zohar dja Shaul. Nungka nawu Shaul ngalbadjan nuye daluk ngalbu ngalkang Canaan. Bedda wanjh Simeon nuye birrimudni duninjh nawu bindingeykenhkani. ");
INSERT INTO gup_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Nanih wanjh birringeyyoy nawu Levi benbornang dja benkebmawahmeng. Levi bebeywurd benbornang Gershon, Kohath, dja Merari. Nungka Levi djahdjalmimbini 137 mandjewk. ");
INSERT INTO gup_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Nawu Gershon benbenebornang bebeywurd nuye nawu birrimudni duninjh wanjh Libni dja Shimei. ");
INSERT INTO gup_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Nawu Kohath benbornang bebeywurd nuye wanjh Amram, Izhar, Hebron, dja Uzziel. Kohath djahdjalmimbini 133 mandjewk. ");
INSERT INTO gup_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Nawu Merari benbenebornang bebeywurd nuye wanjh Mahli dja Mushi. Nanih wanjh Levi nuye birrimudni duninjh nawu benbornang dja benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram benemarrinj ngalkornkumo nuye ngalbu ngeyyoy Jochebed, ngaleng bimarneyawmey Amram bebeywurd nuye Aaron dja Moses. Nungka Amram djahdjalmimbini 137 mandjewk. ");
INSERT INTO gup_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar benbornang bebeywurd nuye, wanjh Korah, Nepheg dja Zichri. ");
INSERT INTO gup_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziel benbornang bebeywurd nuye, wanjh Mishael, Elzaphan dja Sithri. ");
INSERT INTO gup_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron benemarrinj Elisheba, ngalbeywurd nuye Amminadab, dja mak ngaleng benedanginj Nahshon. Dja ngaleng Elisheba bimarneyawmey Aaron bebeywurd nuye Nadab, Abihu, Eleazar dja Ithamar. ");
INSERT INTO gup_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Nawu Korah benbornang bebeywurd nuye wanjh Assir, Elkanah dja Abiasaph. Bedda wanjh Korah nuye birrimudni duninjh nawu bindingeykenhkani. ");
INSERT INTO gup_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar nawu beywurd nuye Aaron wanjh benemarrinj ngalkudji ngalbeywurd nuye Putiel, dja ngaleng bimarneyawmey Phinehas. Nanih wanjh kabirringeybimdi nawu birriwohrnani kore Levi nuye birribebbehmudni, nawu bedman birribebbehmudni duninjh kabirridjarrkngeydingeydi. ");
INSERT INTO gup_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Bedda wanjh benemekbewi Aaron dja Moses nawu Yawey benbenemarneyimeng, “Ngurrbenbebbehmirndemornnamen bininj nawu Israel benkebmawahmeng, dja ngurrbenbebbehmirndebebke Egyptbeh.” ");
INSERT INTO gup_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Dja bedda wanjh benemekbe nawu benewokdi nuye Pharaoh nawu wohrnani kore Egypt, beneyimeng kabindibebke bininj nawu Israel benkebmawahmeng Egyptbeh. Bedda wanjh benedjalmekbewi Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Bu Yawey wokdanj nuye Moses kore Egypt, ");
INSERT INTO gup_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","nungka bimarneyimeng, “Ngaye wanjh Yawey. Pharaoh nawu kawohrnan kore Egypt yimarneyimen yehyeng rowk nawu ngaye wokwong.” ");
INSERT INTO gup_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Dja Moses bimarneyimeng Yawey, yimeng, “Yina! Ngaye ngawokwarre wanjh njalekah yimankek Pharaoh nganbekkan?” ");
INSERT INTO gup_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Wanjh nunganwali Yawey bimarneyimeng Moses, yimeng, “Yina, ngaye marnbun ngudda ba bu yiyimerran yiman God rerrih bu yire kore Pharaoh, dja Aaron nawu ngunedanginj ngamarnbom ba bu kayimerran yiman prophet ke rerrih, wanjh nungka ngunwokmulewan kore Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ngudda kaluk yiwokdin kunwok rowk nawu ngaye wokrayekwon, dja Aaron nawu ngunedanginj, nungka wanjh kabimarneyime Pharaoh kabenmunkewe bininj nawu Israel benkebmawahmeng kabirrimarnebolkbawon kubolkwarlah nuye. ");
INSERT INTO gup_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Dja kunu bonj. Ngaye wanjh ngadjalmarnbun Pharaoh kakangerayekmen. Dja djamku ngaye ngawernwon nawu ngabukkan kundulkarre dorrengh kondah kore kubolkwarlah Egypt, dja ngabenkangebarrhke. ");
INSERT INTO gup_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Djal bonj, Pharaoh minj ngunbenewokmarrkmang. Wanjh kunmekbe ngayime ngabendjadme duninjh bininj nawu Egyptbeh dja ngabenbun. Dja ngaye ngabenmirndeyibebme ngardduk bininj nawu Israel benkebmawahmeng, kabirribebme Egyptbeh. ");
INSERT INTO gup_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Bu kunmekbe ngayime ngakurduyime rowk ngabidyirriyo ngaye ba ngarrulkarrebukkarren bedberre bininj nawu Egyptbeh dja ngabenbebke bininj nawu Israel benkebmawahmeng kore kunred bedberre kabirridjarrknibeh, wanjh kunu bininj nawu Egyptbeh kaluk kabirriburrbun bu ngaye wanjh Yawey.” Kuhni bu yimeng Yawey. ");
INSERT INTO gup_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Wanjh Moses dja Aaron kuhni benekurduyimeng rowk nawu Yawey benbenewokrayekwong. ");
INSERT INTO gup_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Dja bu Pharaoh birriwokdi wanjh Moses mandjewk nuye wanjh 80, dja Aaron 83. ");
INSERT INTO gup_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Wanjh Yawey benbenemarneyimeng Moses dja Aaron, yimeng, ");
INSERT INTO gup_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kaluk bu Pharaoh ngunbenemarneyime, wanjh kayime, ‘Mah, ngunekurduyimen kunmakmak kundulkarre dorrengh, ba bu ngaye ngaburrbun bu ngudda ngunemulewarren bu ngunewoybuk.’ Bu kuhni Pharaoh ngunbenemarneyime, wanjh kunu ngudda Moses yimarneyimen Aaron karrulkmang kundulk nuye karrulkburriwe kore Pharaoh kumirrk nuye, wanjh karrulkyimerran nayin.” ");
INSERT INTO gup_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Wanjh kunu Moses dja Aaron benewam kore Pharaoh dja benekurduyimeng nawu Yawey benbenewokrayekwong. Aaron dulkburriweng kundulk nuye kumirrk bedberre Pharaoh dja bininj nuye nawu birrimarnedurrkmirri, wanjh dulkyimerranj nayin. ");
INSERT INTO gup_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Wanjh Pharaoh benkayhmeng bininj nawu birrimayaliwernni dja mak nawu birrimarrkidjbuni nawu birrikang kumekbe Egypt, dja bedda warridj kumekbe rerrih birrimarnbom kunkurdang. ");
INSERT INTO gup_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Bedda rowk birribebbehdulkburriweng kundulk bedberre wanjh dulkyimerranj nayin. Dja kundulk manbu Aaron nuye wanjh benkuknguneng benkukyakwong kundulk bedberreni manbu nayin birrikukyimerranj. ");
INSERT INTO gup_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Yimankek djamku, dja Pharaoh djalkangerayekminj munguyh kore Yawey yingkihyimeng, dja nungka Pharaoh minj benbenewokmarrkmayi Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Wanjh Yawey bimarneyimeng Moses, yimeng, “Pharaoh kangerayekminj ngundahme, minj kabenmunkewe bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kaluk bu malamalaywi nungka Pharaoh kare kore mankabo, wanjh yirrulkkan kundulk manbu yimerranj nayin, dja yimadbun Pharaoh kore kurrid ngarre mankabo. ");
INSERT INTO gup_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Wanjh yimarneyimen nungka nawu Pharaoh, kanwokmulewa bu ngayime nuye, wanjh yiyimen, ‘Yawey nawu God ngadberre nawu Hebrew bininj, wanjh nganmunkeweng kore ngudda Pharaoh ba marneyime kanmunkewe ngad nawu bininj nuye ba ngarrimarnedi yiwarrudj kore kubolkdarleh. Dja yina, ngudda minj yibangmewokmarrkmayi. ");
INSERT INTO gup_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","18","Mah, wanjh yina, mahni kundulk manbu ngahdulkarrme wanjh ngabobarrhmang mankabo, wanjh manekke kukku kaboyimerran kunkurlba. Dja nawu djenj kore mankabo nakka karrowerren rowk dja mankabo kaluk kabonudbanjmen bulkkidj, dja bininj nawu Egyptbeh kabirribowirrihme minj kabirribongun. Wanjh kuhni kayime nungka nawu Yawey, bu nungka kaluk kakurduyime ba bu yiburrbun bu nungka Yawey.’ Kuhni yimarneyime nawu Pharaoh.” Kuhni kunwok bu Yawey God biwokwong Moses bu kabimarneyime Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Wanjh Yawey bimarneyimeng Moses, “Yimarneyimen Aaron karrulkmang manekke kundulk nuye dja kabidwayhme kore kukku manbu kaborri kore kubolkwarlah Egypt. Kaluk mankabowern dja mak manlabbarlwern, ba bu kabokurlbamen rowk. Kore kubolkwarlah rowk Egypt kukku kadjalbokurlbamen rowk manbu kukku kaboyo njilhmi rowk kore karrulkmirnderri dja mak kore manwarddebarrarn, manekke warridj kaboyimerran kunkurlba.” ");
INSERT INTO gup_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses dja Aaron benekurduyimeng rowk kore Yawey benbenewokrayekwong. Wanjh Aaron dulkwayhkeng kundulk nuye bu Pharaoh dja bininj nuye nawu birrimarnedurrkmirri birrinang, wanjh bobarrhmey manbu mankabo, dja kukku rowk kumekbe kore mankabo wanjh boyimerranj kunkurlba. ");
INSERT INTO gup_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Dja djenj kore mankabo wanjh birridowerrinj, dja bonudminj bulkkidj wanjh kunu bininj nawu Egyptbeh minj birribonguyi kukku kore manekke mankabobeh. Wanjh kukku bokurlbahminj rowk kore kumekbe kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Dja birrikurdang nawu birrikang Egypt, wanjh kunmekbe kunkudjiwi birrikurduyimeng bu mankurdang bedberre, wanjh kunu Pharaoh djalkangerayekni munguyh bu Yawey yingkihyimeng, minj benbenemarrkmayi Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Wanjh Pharaoh balborledmeng ngimeng kore kunrurrk nuye, dja minj kuhni mak balwohburrbuyi. ");
INSERT INTO gup_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Dja bininj rowk nawu Egyptbeh wanjh bu minj birribonguyi kukku kore mankabobeh, wanjh kunu birribolkkarungi birringadkarungi kore mankabo darnkih birriboyawani bu kabirribongunkenh. ");
INSERT INTO gup_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Bu Yawey boborledkeng rowk manbu mankabo wanjh kaluk yerrekah wanjh seven kunkodjke. ");
INSERT INTO gup_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Wanjh Yawey bimarneyimeng Moses, yimeng, “Yiray yingimen kore Pharaoh dja yimarneyimen bu ngaye Yawey ngayime nuye benmunkewemen bininj ngardduk ba ngandimarnedi yiwarrudj, ");
INSERT INTO gup_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","dja bu ngandahme minj kabenmunkewe, wanjh kumekbe ngayiddung, dja wanjh kordbolbok ngamirndekurrme kore kubolkwarlah nuye. ");
INSERT INTO gup_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kaluk kore mankabo kamirndewernmerren kordbolbok dja kumekbebeh kabirrimirndebebmerren kore kunrurrk nuye Pharaoh, kadjalle kore kunrurrk kore kahyo dja mak kore balabbala nuye kore nungka Pharaoh kakodjkeyo. Mak kamirndere kore kunrurrk bedberre bininj nawu Pharaoh kabirrimarnedurrkmirri dja bininj rowk nuye, dja mak kore manme kabirrikinje, dja kore kandidjdjawa kabirrimarnbun. ");
INSERT INTO gup_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kordbolbok kaluk karrolkan kore Pharaoh dja bininj rowk nuye dja kore bininj rowk nawu kabirrimarnedurrkmirri nuye. Kuhni bu yimarneyimen Pharaoh.” ");
INSERT INTO gup_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Wanjh kuhni mak Yawey bimarneyimeng Moses, yimeng, “Yimarneyimen Aaron kundulk dorrengh nuye bidwayhmen kore mankabo rowk dja mak kore kulabbarl rowk, dja kamarnbun kordbolbok kamirndebebmerren kore kubolkwarlah Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Wanjh kunu Aaron bidwayhmeng kore kukku ngarre Egypt, wanjh kordbolbok mirndebebmerrinj bolkbalhmeng rowk kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Dja nawu birrikurdang kunkudjiwi birrikurduyimenj mankurdang bedberre, birrimirndebebkeng kordbolbok kore kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Wanjh Pharaoh benbenemarnekayhmeng Moses dja Aaron, dja yimeng, “Ngunedjawa Yawey kakan kordbolbok kanbawon ngaye dja mak bininj ngardduk, wanjh kunukka ngabenmunkewe bininj nawu Israel benkebmawahmeng kabirribun mayh nuye Yawey, yiwarrudj kabirridi dorrengh.” ");
INSERT INTO gup_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses bimarneyimeng Pharaoh, yimeng, “Mah wanjh. Ngadjare ngudda kanmarnedungname bu yiwarrudj marnedi ngudda, dja ngabenmarnedi yiwarrudj bedberre bininj nawu ngundimarnedurrkmirri, dja ngudda ke bininj rowk, ba kordbolbok kayakmen kore ngudda dja kunrurrk ngudberre, dja kubolkkudji kore mankabo kordbolbok kadjaldi.” ");
INSERT INTO gup_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Wanjh Pharaoh yimeng, “Kaluk malaywi kanmarnedi.” Moses yimeng, “Ngaye ngakurduyime bu ngudda kandjawam. Kaluk ngunmarnekurduyimerran, ba bu ngudda yiburrbun bu minj nangale mak nabuyika yiman kabenerohrok Yawey nawu God ngadberre. Kordbolbok kaluk ngunbawon ngudda dja kunrurrk ngudberre, kabindibawon bininj nawu ngundimarnedurrkmirri dja ngudda ke bininj rowk, dja kubolkkudji kore mankabo kordbolbok kadjaldi.” ");
INSERT INTO gup_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Wanjh Moses dja Aaron benebebmeng benebawong Pharaoh, wanjh Moses yiwarrudj di kunkayhmi dorrengh kordbolbokkenh nawu Yawey benmirndemunkeweng kore Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Wanjh kunmekbe Yawey kurduyimeng bu Moses bidjawam, wanjh kordbolbok dowerrinj rowk kore kubolkwarlahkenh rowk, kore kunrurrk dja kabbal. ");
INSERT INTO gup_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Dja birrikukmornnameng nawu kordbolbok dja bolknudbanjni duninjh. ");
INSERT INTO gup_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Wanjh yiman djamku bu Pharaoh nang God bibawong bu kordbolbok dowerrinj, nungka Pharaoh yawoyhkangerayekminj bu Yawey yingkihyimeng, dja minj benbenebekkayi Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Wanjh kunu Yawey bimarneyimeng Moses, yimeng, “Yimarneyimen Aaron dulkwayhkemen kundulk nuye kabolkdong kundjulng ngarre kurorre ba bu manbu kundjulng kamirndeyimerran mudmud kubolkwernkenh rowk kore kubolkwarlah Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Wanjh kunmekbe beneyimeng. Aaron bidwayhmeng kundulk nuye dorrengh, bolkdoy kundjulng ngarre kurorre, wanjh mudmud mirndebebmerrinj kore bininj dja mayh. Kundjulng rowk kubolkwernkenh rowk kore kubolkwarlah Egypt wanjh yimerranj wernminj mudmud. ");
INSERT INTO gup_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Wanjh bininj nawu birriburrbuni kunkurdang birrirohrokmi birrimirndebebkemeninj mudmud manbu kunkurdang bedberre, dja birridulkarreyawarrinj. Wanjh nawu mudmud djahdjalmirnderri kore bininj dja mayh. ");
INSERT INTO gup_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Wanjh birrimekbe bininj nawu birrikurdang birrimarneyimeng Pharaoh, birriyimeng, “Kuhni wanjh God nungan kurduyimeng.” Bu kuhni birriyimeng wanjh djaldjamku, dja Pharaoh djalkangerayekni munguyh kore Yawey biyingkihmulewam dja minj benbekkayi. ");
INSERT INTO gup_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Wanjh Yawey bimarneyimeng Moses, yimeng, “Malaywi ngudda yirrolkka bu kukabel dja yimadbu Pharaoh bu nungka kare kore kukku. Dja bu yinan, wanjh yimarneyimen, ‘Kuhni Yawey kayime ke, “Ngudda yibenmunkewemen bininj ngardduk ba ngandimarnedi yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Dja bu ngudda yibendenghke, minj yibenmunkewe bininj ngardduk, wanjh yina, ngaye ngamirndemunkewe djoned nawern kamirndebebmerren kore ngudda dja bininj ke nawu ngundimarnedurrkmirri, dja bininj ke rowk, dja kore kunrurrk ngudberre. Kaluk kunrurrk rowk ngudberre nawu Egyptbeh wanjh kamirndebarlme djoned, dja kore kurorre wanjh kabolkbalhme rowk nawu djoned. ");
INSERT INTO gup_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Dja bu kunmekbe marnekurduyime, wanjh ngaye mak ngabolklarlmang kunred kabolkngeyyo Goshen kore bedda nawu bininj ngardduk kabirrini ngakurduyime kundjalbuyika bedberre. Kumekbe wanjh djoned minj kamirndebebmerren. Kuhni kaluk ngakurduyime ba bu ngudda Pharaoh kaluk yiburrbun bu ngaye wanjh Yawey ngahdjalni kondah kore kunred ke. ");
INSERT INTO gup_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kuhni bu ngakurduyime wanjh yiman bebbehbeh ngabenbebbehkurrme nawu bininj ngardduk dja nawu ngudda ke bininj. Kaluk malaywi kunukka ngaye ngakurduyime ngunwernhbukkankenh ngudda nawu Pharaoh.” Kuhni bu Yawey ngunmarneyime ngudda nawu Pharaoh.’ Kuhni yimarneyime nawu Pharaoh.” ");
INSERT INTO gup_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kuhni yimeng Yawey wanjh kaluk kunmekbe kurduyimeng. Nawern duninjh djoned mirndebebmerrinj kore Pharaoh nuye kunrurrk, dja kunrurrk bedberre bininj nuye nawu birrimarnedurrkmirri, dja kore kubolkwarlah Egypt rowk, kaluk namekbe djoned wernhbolkwarrewong rowk. ");
INSERT INTO gup_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Wanjh kunu Pharaoh benbenekayhmeng Moses dja Aaron dja yimeng, “Ngurriray, ngurribun mayh nuye God ngudberre yiwarrudj ngurrimarnedi dorrengh kondah kore Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Wanjh Moses yimeng, “Kunukka minj kunmak bu yimankek ngarriyime, dja bininj ke nawu Egyptbeh kabirriwarnyak duninjh bu ngad ngarribun mayh ngarriwon Yawey nawu God ngadberre. Wanjh bu yimankek ngad yiwarrudj ngarridi ngarrimarnebun mayh dorrengh ngarribun kore bininj nawu Egyptbeh ngandinan, minj nuk kunukka ngandidong kunwardde ngandikukkurrme. ");
INSERT INTO gup_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kunu wanjh ngarridjalle kunkak danjbik kore kubolkdarleh, kaluk kumekbe ngarribun mayh nuye Yawey nawu God ngadberre. Kumekbe ngarrikurduyime kore nungka kaluk kanwokrayekwon ngadberre.” ");
INSERT INTO gup_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Wanjh kunu Pharaoh yimeng, “Ngaye munkewe ngudberre, ngurribun mayh nuye Yawey nawu God ngudberre ngurridi yiwarrudj dorrengh kore kubolkdarleh. Kundjalkudji, yuwn djarreh ngurrire. Dja yiwarrudj kandimarnedin ngaye dja ngurridjawa bu nganmarnebengmidjdan ngayekenh.” ");
INSERT INTO gup_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Wanjh Moses yimeng, “Yina, ngaye ngabebme bawon ngudda, wanjh ngarri yiwarrudj nuye Yawey ngadjawan bu malaywi djoned kamirndedurnderren rowk, ngundibawon ngudda nawu Pharaoh, dja bininj ke nawu ngundimarnedurrkmirri, dja bininj rowk. Kunmekbe ngayime. Dja kundjalkudji yuwn yiyawoyhkurren Pharaoh, bu kandenghke ngad nawu bininj nuye, dja wanjh kanmunkewemen ba ngad ngarribun mayh nuye Yawey, yiwarrudj ngarridi dorrengh.” ");
INSERT INTO gup_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Wanjh Moses bebmeng bibawong Pharaoh dja yiwarrudj di Yawey nuye. ");
INSERT INTO gup_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Dja Yawey kurduyimeng nawu Moses bidjawam, benmirndebebkeng djoned bindibawong Pharaoh, dja bininj nuye nawu birrimarnedurrkmirri dja bininj rowk nuye, minj nawohkudji djoned diwirrinj. ");
INSERT INTO gup_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Wanjh kuhni yiman djaldjamku, dja kuninjkunu warridj Pharaoh yawoyhkangerayekminj dja minj benmunkewemeninj bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Wanjh Yawey bimarneyimeng Moses, yimeng, “Yiray yingimen kore Pharaoh dja yimarneyimen, ‘Yawey nawu God ngadberre Hebrew bininj, kuhni wanjh kayime ke ngudda Pharaoh, ngunmarneyime, “Yibenmunkewemen bininj ngardduk ba ngandimarnedi yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Dja bu ngudda kandahme minj yibenmunkewe, dja munguyh yibendenghke. Wanjh kanbekka, marneyime, ngaye Yawey kundjak kunrayek ngamunkewe kore mayh ngudberre nawu kamirnderri kore kabbal, kaluk djarrang, dja mayh nawern nawu donkey, camel, sheep dja goat. ");
INSERT INTO gup_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Dja ngaye yiman bebbehbeh ngabenkurrme mayh bedberre bininj nawu Israel benkebmawahmeng dja mayh ngudberre bininj nawu Egyptbeh. Kundjalbubuyika ngabenbenebebbehmarnekurduyime, ba minj nawohkudji kawohdowerren kore mayh rowk bedberre bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Dja ngaye Yawey ngarrungnameng malaywi, wanjh kunu ngakurduyime kondah kore kubolkwarlah Egypt.” Kuhni bu Yawey ngunmarneyime.’” Kuhni bu Yawey biwokwong Moses bu bimarneyimeng Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Wanjh kuhni yimeng Yawey. Wanjh bu malaywi nungka kunihbu kurduyimeng. Mayh nawu bininj bedberre nawu Egyptbeh, wanjh dowerrinj rowk, dja nawu mayh bedberre bininj nawu Israel benkebmawahmeng, wanjh bonj, minj nawohkudji dowimeninj. ");
INSERT INTO gup_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Wanjh Pharaoh benmunkeweng bininj, wanjh birrinang bu minj nawohkudji dowimeninj mayh bedberre bininj nawu Israel benkebmawahmeng. Kuhni wanjh yiman djaldjamku rerrih, dja Pharaoh djalyawoyhkangerayekni munguyh, minj benmunkewemeninj bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Wanjh Yawey benbenemarneyimeng Moses dja Aaron, yimeng, “Nguneray kore kabirrikinje brick manbu kunrurrk kabirrimarnbun. Nguneray kumekbe kore kunak karung, dja ngunewohma kubid yikahwi kunyirrke manbu kahyo. Dja Moses ngudda kaddum yiburriwemen manekke kunyirrke bu Pharaoh kanan. ");
INSERT INTO gup_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Wanjh kaluk kayimerran kundjulng manbu kabolkbarrkbun kore kubolkwarlahkenh ngarre kubolkwarlah Egypt. Manekke kundjulng kaluk kamarnburren bulng. Wanjh kabirrimokmen nawu bininj dja mayh kore kubolkwarlah Egypt rowk.” ");
INSERT INTO gup_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Wanjh kunu benemey kunyirrke manbu yoy kore brickskenh birrikinjeyi, dja benewam benedanginj kore Pharaoh kumirrk nuye, dja Moses burriweng kaddum, wanjh manekke kunyirrke yimerranj bulng, dja benmarnbom bininj dja mayh birrimokminj dja moknudminj. ");
INSERT INTO gup_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Dja bininj nawu birriburrbuni kunkurdang, bu bulng benmey, wanjh kunmekbekenh kunu bedda minj baleh birriyimeninj yimankek birribebmeninj birridangimeninj kore Moses. Dja bulng birrikarrmi bedda nawu birrikurdangni, dja mak birriwern rowk bininj nawu Egyptbeh. ");
INSERT INTO gup_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kuhni wanjh yimankekni djamku dja Yawey biyawoyhkangerayekwong, wanjh nungka Pharaoh minj benbenewokmarrkmayi bu Yawey biyingkihmarneyimeng Moses. ");
INSERT INTO gup_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Wanjh Yawey bimarneyimeng Moses, yimeng, “Malaywi wanjh yimalaydolkkan bu kumkabel djarreh, dja yiray yimarnedangimen Pharaoh kumirrk nuye dja yimarneyimen bu ngaye Yawey nawu God bedberre nawu Hebrew bininj, wanjh ngayime, ‘Yibenmunkewemen bininj ngardduk ba ngandimarnedi yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Dja bu kandahme, wanjh bolkkime ngaye marnemunkewe kunbubuyika rowk nawu kunmurrngrayek nawu yiman ngunkangebarrhke ngudda Pharaoh, dja bininj ke nawu ngundimarnedurrkmirri, dja bininj ke rowk. Kuhni ngakurduyime ba ngudda yinjilngwarremen dja yiburrbun bu minj nangale nabuyika god karri kore kurorre rowk nawu yiman ngaye Yawey nganerohrok. ");
INSERT INTO gup_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Dja yina! Bu ngaye ngadjareniwirrinj wanjh korroko ngamunkewemeninj kundjak ngurridjaldowimeninj, ngudda dja bininj ke rowk ngurriyakmeninj. ");
INSERT INTO gup_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Dja ngaye bawong ngudberre ngurridarrkid ba bu bukkan ngardduk kundulkarre. Ngaye bawong ngudberre ngurridarrkid ba kunngey ngardduk kandingeyyolyolme kandiwobekkan kore kubolkwarlahkenh rowk. ");
INSERT INTO gup_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ngudda wanjh munguyh yikimukworren, dja minj yibenmunkewe ngardduk bininj.’ ");
INSERT INTO gup_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","‘Wanjh kanbekka, marneyime. Malaywi bu yiman kunihbu karrungdi ngaye ngamunkewe mankurrk mandjalkimuk duninjh yiman kunwardde kahdjakdung. Kadjaldjakdung yiman minj korroko djakduyi kondah kore Egypt. ");
INSERT INTO gup_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kunu wanjh yibenmunkewemen bininj kabirrimang mayh dja mak yehyeng rowk nawu karri kore kabbal, kabirringimowon kore kudjurlemak. Kumekke yikurduyimen dja bininj dja mayh rowk nawu kabirridjaldi kore kabbal nawu minj nangale kabindimang kabindikan kured, wanjh mandulmuk mankurrk kaluk kabenbun yiman kunwardde kadjakdung, dja kabirridowen rowk, bininj dja mayh.’” ");
INSERT INTO gup_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kuhni yimeng Yawey, wanjh kunu Pharaoh nuye bininj nawu birrimarnedurrkmirri, nawu birriwokkengemi Yawey nuye kunwok, bedda wanjh bindimarneyimi bininj bedberre nawu bindimarnedurrkmirri dja mak mayh nawu bedberre birrikelerlobmerreni rowk kore kururrk. ");
INSERT INTO gup_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Dja birribuyika bininj nawu minj birriwokwoybukwoyi Yawey nuye kunwok, bedda wanjh birrimarlelmangi dja bindidjalbawoni bininj nawu bindimarnedurrkmirri dja mayh bedberre, kore kabbal bindidjalbawoni. ");
INSERT INTO gup_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Wanjh bu malaywibuyikani, Yawey bimarneyimeng Moses, yimeng, “Mah wanjh, yibidwayhmen kaddum ba dulmuk duninjh mankurrk kadjakdung kore kubolkwarlah Egypt rowk, kabenbun bininj dja mayh dja mak manme rowk manbu birridudji kore kabbal, kabun rowk kore kubolkwarlah Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Wanjh Moses kundulk nuye dulkwayhkeng kaddum, wanjh Yawey munkeweng namarrkon nawern dja mankurrk mandulmuk, dja namarrkon bolkdongi bu kunak dorrengh. Wanjh Yawey marnbom dulmukminj duninjh mankurrk djakduy kore kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Kaluk dulmuk duninjh mankurrk yiman kunwardde djakdungi, dja namarrkon djahdjalmayhkeyi yiman kunak rerrih munguyh kore mandulmuk mankurrk bu warrawarrhmi. Nawu mankurrk wanjh wernhdulmukminj duninjh djahdjaldjakdungi bulkkidj yiman minj korroko djakduyi kore kubolkwarlah rowk Egypt kunkuyeng kore kerrngehkenh duninjh dja mak bolkkime. ");
INSERT INTO gup_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Manekke mankurrk bom yakwong yehyeng rowk nawu dingihdi kore kabbalbubuyika kore kubolkwarlah rowk kore Egypt, kaluk bininj dja mayh benbom dja mak bom yakwong manme manbu birridudji kore kabbal, dja dulkdoy dulkbakkabakkeng kundulk rowk manbu dulkdingihdi kore kabbalbubuyika rowk. ");
INSERT INTO gup_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Dja kudjalbolkkudji kore kunred Goshen kore bininj nawu Israel benkebmawahmeng birrihni, kumekbe minj djakduyi mankurrk. ");
INSERT INTO gup_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Wanjh Pharaoh bimunkeweng bininj benbenekayhmeng Moses dja Aaron dja benbenemarneyimeng, yimeng, “Kuninjkunu wanjh ngaye kunwarre ngayimeng. Yawey nungka kunmak kahdjalkurduyime, dja ngaye dja bininj ngardduk ngarrihkurduyime kunwarre. ");
INSERT INTO gup_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ngunedjawa Yawey dja ngarriwunjibmingarlmeng bu namarrkon nakihkimuk dja mak mandulmuk duninjh mankurrk. Ngaye munkewe ngudberre, dja minj mak ngurrini kondah.” ");
INSERT INTO gup_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses bimarneyimeng, yimeng, “Bu ngaye ngabebme kondah kubolkkimukbeh, wanjh kundjalmekbe rerrih ngabidwayhme kore Yawey, ngadjawan, wanjh namarrkon kangurdme, dja mandulmuk mankurrk minj kayawoyhdjakdung. Kunmekbe ngakurduyime ba ngudda kaluk yiburrbun bu kondanjkunu kunred wanjh Yawey nuye. ");
INSERT INTO gup_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Dja bonj, kuhni yiman djaldjamku rerrih dja ngudda dja bininj ke nawu ngundimarnedurrkmirri, ngaye ngaburrbun bu minj ngurribangmekengeme Yawey nawu God.” Kuhni Moses bimarneyimeng Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Mahni mankurrk mandulmuk benmarnewarrewong manbu dudjindi. Yikahwi manbu dudjindi manmim manbu kangeyyo flax dja barley, makka wanjh mankurrk djalwarrewong duninjh. Dja barley makka wanjh mimbebmerrinj, dja flax manu wanjh karrmi mannguy. Kunmekbekenh kunu wanjh warreminj. ");
INSERT INTO gup_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Dja manmim manbu wheat dja makka wanjh yerre kadjordmen wanjh kunmekbekenh kunu manekke manmim mandjalmakni, minj mankurrk warrewoyi. ");
INSERT INTO gup_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kaluk Moses wanjh bebmeng bolkbawong kubolkkimuk kore Pharaoh ni, dja wam bidwayhmeng kore Yawey, yiwarrudj di, wanjh namarrkon dja mandulmuk duninjh mankurrk djalngurdmeng rowk, minj djakduyi kore kubolkwarlah Egypt. ");
INSERT INTO gup_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kuhni wanjh yiman djamku rerrih dja bu Pharaoh nang ngurdmeng rowk mandulmuk mankurrk, dja mak namarrkon, wanjh nungka yawoyhyimeng kunwarre, dja munguyh djalkangerayekworrinj. Nungka dja mak bininj nawu birrimarnedurrkmirri birriyawoyhkangerayekworrinj. ");
INSERT INTO gup_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Wanjh kuhni Pharaoh kangerayekni dja minj benmunkewemeninj bininj nawu Israel benkebmawahmeng. Kumekbe bu Yawey yingkihyimeng Moses biwokwong. ");
INSERT INTO gup_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Wanjh Yawey bimarneyimeng Moses, yimeng, “Yiray, yingimen kore Pharaoh, dja ngaye ngabenkangerayekwong nungka dja bininj nuye nawu kabirrimarnedurrkmirri. Kuhni ngakurduyimeng ba ngaye ngabenbukkan kuhni bu kunbubuyika. Kundulkarre dorrengh ngardduk nawu ngakurduyime kore bedda, ");
INSERT INTO gup_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","dja mak ngakurduyime ba ngudda ngurrbenmarneyime bebeywurd dja mak mawahmawah, ngurrbenmarneyime bu baleh ngaye ngakurduyime ngabenyemikan bininj nawu Egyptbeh, dja bu baleh manu kunbubuyika bu ngakurduyime kore bedda ngabenbukkankenh. Ngudda rowk kaluk ngurriburrbun bu ngaye wanjh Yawey.” ");
INSERT INTO gup_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Wanjh Moses dja Aaron benewam benengimeng kore Pharaoh dja benemarneyimeng, “Kuhni kayime Yawey nawu God ngadberre nawu Hebrew bininj, wanjh yimeng, ‘Yiddok munguyh ngudda kandahme bu minj yimarladjworren kore ngaye nawu Yawey? Yibenmunkewemen bininj ngardduk ba ngandimarnedi yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Dja bu ngudda kandahme, minj yibenmunkewe bininj ngardduk, wanjh kuhni ngaye marneyime, malaywi ngaye ngamunkewe djaddedde kore kunred kubolkwarlah ke, ");
INSERT INTO gup_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","kaluk kabirribolkbarlme rowk kubolkwarlah ba bu minj nangale kawohbolknan, dja kabirringun kabirriyakwon manbu dulmuk mandjewk minj yakwoyi, dja kundulk rowk ngudberre nawu karri kore kabbal wanjh kabirringun kabirriyakwon. ");
INSERT INTO gup_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Kaluk kabarlmerren nawu kunrurrk ke dja kunrurrk bedberre nawu ngundimarnedurrkmirri, dja kunrurrk bedberre bininj rowk nawu Egyptbeh. Kabolkyimerran yiman minj korroko birrinayi nawu kornhkornkumo dja mawahmawah ngudberre. Minj birrinayi bu kerrngehkenh birrimwam dja minj mak yerre birrinayi, kaluk bolkkime kabirridjalnan.’ Mah, kuhni bu ngunmarneyime ngudda nawu Pharaoh.” Bu kuhni Yawey biwokwong wanjh Moses bimarneyimeng Pharaoh. Kaluk bu kuhni bimarneyimeng, wanjh nungka balborledmeng bebmeng bibalbawong Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Wanjh bininj nawu birrimarnedurrkmirri Pharaoh birrimarneyimeng, “Kaluk baleh kayime nanih bininj yibawon kunyid kamarnbun kadberre? Yibenmunkewemen djalbininjwi ba kabirridi yiwarrudj nuye Yawey nawu God bedberre. Minj nuk yibangmeburrbun bu Egypt djalbolkwarreminj?” ");
INSERT INTO gup_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Wanjh kunu bininj nuye Pharaoh bindimey Moses dja Aaron, bindimdurndiweng kore Pharaoh, dja nungka benbenemarneyimeng, “Bonj. Ngurriray, ngurrimarnedi yiwarrudj Yawey, nawu God ngudberre. Dja mak ngurringalehngale ngurridjarrkre?” ");
INSERT INTO gup_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Wanjh Moses yimeng, “Ngad wanjh ngarridjalmulilmang Yawey, wanjh kunmekbekenh kunu ngarriwern ngarrire, wurdwurd dorrengh dja kohbakohbanj, kaluk ngarridjarrkre bebeywurd dja ngalbebeywurd dorrengh, dja mak mayh ngadberre nawu ngarrbenmirndekarrme.” ");
INSERT INTO gup_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Wanjh Pharaoh kurrinj bu yimeng, “A, yoh! Kamak ngurriray mak Yawey ngurriray, ngudda dja wurdwurd dja daluhdaluk ngudberre.” Kuhni bu yimeng. Dja burrkyakni. Nungka burrburreni bu kurreni dja kunyid karrmi bedberre bu kunmekbe benmarneyimi. Wanjh benmarneyimeng, “Dja burrkyak, ngaye ngaburrbun ngudda ngurridjare kunyid ngurringalke. ");
INSERT INTO gup_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ngurrbenbawo wurdwurd dja daluhdaluk. Djalbininjwi ngurriray ngurridi yiwarrudj Yawey nuye, dja kunmekbe wanjh ngurrihdjare.” Kunmekbe yimeng Pharaoh dja benbenekukburriweng kore nungkahbeh nawu Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Wanjh Yawey bimarneyimeng Moses, yimeng, “Yibidyirriyongimen ba bu yibidwayhmen kore kubolkwarlah Egypt djaddeddekenh, ba kabirrimirndebebmerren kore kubolkwarlah Egypt, kabirringun kabirriyakwon manme manbu mankurrk minj yakwoyi.” ");
INSERT INTO gup_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Wanjh Moses dulkwayhkeng kundulk nuye kaddumkah kore kubolkwarlah Egypt, dja Yawey marnbom kunmayorrk koyekbeh kumwam, kunmekbe kunbarnangarra dja mak kumunun djahdjalley kore kubolkwarlah Egypt munguyh, dja bu kukabel manekke kunmayorrk benmirndeyibebmeng djaddedde. ");
INSERT INTO gup_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Dja nawu djaddedde mirndebebmerrinj kore kubolkwarlah Egypt rowk, dja birriyerrkang kore kunred rowk Egypt, kaluk nadjalmirndewern duninjh, mirndeyimi yiman minj nangale nayi korroko, dja minj nangale kayawoyhnan bu rerrererreh, ");
INSERT INTO gup_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","dja namekbe djaddedde djalbolkbarrkbom kubolkwarlah rowk, bolkyimerranj yiman bolkburlerranj rerrih, dja birringuneng manme rowk kore kumekbe kubolkwarlah dja mak manme manbu di kore kundulk manbu dulmuk mandjewk minj yakwoyi. Minj manwohkudji manme diwirrinj kaluk kundulk dja manbuyika manme manbu di kore kabbal, djalyakayakminj kore kubolkwarlah Egypt rowk. ");
INSERT INTO gup_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Wanjh Pharaoh djalwerrkwehwerrkwerrk benbenekayhmeng Moses dja Aaron, dja yimeng, “Ngaye kunwarre ngayimeng nuye Yawey nawu God ngudberre, dja mak ngudda warridj benbenemarneyimeng kunwarre. ");
INSERT INTO gup_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Wanjh kunwohkudji kandimarnebengmidjdan dorrengh kunwarre ngardduk, dja ngunedjawa Yawey nawu God ngudberre kadjalmang kakan kuninjkunu kundulmuk kundjak ngayebeh bu nganhbunkenh.” ");
INSERT INTO gup_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Wanjh Moses bebmeng bibawong Pharaoh dja bidjawam Yawey. ");
INSERT INTO gup_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Wanjh Yawey borledkeng kunmayorrk, wanjh mayorrkkimukminj dja borledminj bu kumwam karrikadbeh, dja benmirndewayhkeng djaddedde benmirndemunkeweng kore kurrula manbu kabongeyyo Manborodjme. Minj nawohkudji djaddedde wohdiwirrinj kore kumekbe kubolkwarlah Egypt rowk. ");
INSERT INTO gup_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Dja yiman djaldjamku rerrih dja Yawey bikangerayekwong Pharaoh, dja nungka Pharaoh minj benmunkewemeninj bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Wanjh Yawey bimarneyimeng Moses, yimeng, “Yibidwayhmen kaddum ba kakakmankan mandulmuk kunkak kore kubolkwarlah Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Wanjh Moses bidwayhmeng kaddum, dja kakmankang kunkak manbu kundulmuk. Djalkakyoy kore kubolkwarlah Egypt rowk bu kunbarnangarra danjbik. ");
INSERT INTO gup_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Dja bu kunmekbe kunbarnangarra danjbik bininj nawu Egyptbeh minj birrinarrimeninj, dja mak minj nangale dolkkayi bu bebmeninj kuberrk kore birrini. Dja bininj nawu Israel benkebmawahmeng rowk wanjh bendjalmarnebolkwolkani kore kunred kumekbe kore birrini. ");
INSERT INTO gup_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Wanjh Pharaoh bikayhmeng Moses, yimeng, “Bonj wanjh ngurriray, ngurrimarnedi yiwarrudj Yawey, dja kamak wurdwurd warridj ngurridjarrkray dja ngalbihbininjkobeng warridj. Dja kundjalkudji, mayh ngudberre nawu ngurrbenmirndekarrme, wanjh ngurrbenbawo, birrinin kondah.” ");
INSERT INTO gup_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Dja Moses yimeng, “Kunbuyika mak marneyime. Kanwo mayh nawern ba bu ngarrimarnebun ngarrimarnekinje bu ngarriwon Yawey nawu God ngadberre. ");
INSERT INTO gup_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ngad wanjh ngarridjalkan mayh rowk ngadberre warridj, minj mak nawohkudji mayh ngarriwohbawon kondah, dja ngarrikan nawu ngarrimarnedi yiwarrudj dorrengh Yawey nawu God ngadberre. Dja minj ngarribangmeburrbun bu baleh nanu ngarribun bu yiwarrudjkenh Yawey nuye. Kaluk bu ngarribebme wanjh kunmekbe ngarriburrbun.” ");
INSERT INTO gup_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kuhni wanjh yiman djaldjamku dja Yawey bikangerayekwong Pharaoh, dja nungka minj benmunkewemeninj. ");
INSERT INTO gup_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Wanjh Pharaoh bimarneyimeng Moses, yimeng, “Yidjallay, kanbawo ngaye. Dja yina, yinahnarrimen, yuwn yimdurndeng kanyawoyhkebnan, dja bu ngudda kanyawoyhkebnan wanjh kundjalmekbe kunbarnangarra rerrih ngaye wanjh bun, dja ngudda yirrowen.” ");
INSERT INTO gup_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Wanjh Moses yimeng, “Kuhni bu ngudda yiyime kunukka wanjh kunwoybuk, ngaye minj yawoyhkebnan ngudda.” ");
INSERT INTO gup_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Wanjh Yawey bimarneyimeng Moses, yimeng, “Kundjalwohkudji ngakurduyime ngabenbun Pharaoh dja bininj rowk kore nawu Egyptbeh, wanjh kumekbe kaluk rerrikah ngunmunkewe ngudberre rowk, dja bu kunmekbe kayime ngunmunkewe, wanjh ngundjurrkkan bulkkidj duninjh. ");
INSERT INTO gup_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Wanjh bolkkime yibenmarneyimen bininj nawu Israel benkebmawahmeng, yibenmarneyimen bininj rowk dja daluk rowk kabindiyidjawan bininj nawu Egyptbeh nawu kabindibebbehdarnhmarneni kabindiwon yehyeng namakmak nawu kabirridjongburrenkenh silver dja gold.” ");
INSERT INTO gup_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kaluk Yawey benmarnbom bininj nawu Egyptbeh bu bindimarnekurduyimi kunmak nawu Israel benkebmawahmeng. Dja mak bininj nawu birrimarnedurrkmirri Pharaoh dja bininj rowk nawu Egyptbeh, bedda wanjh birriyimi bu nungka nawu Moses wanjh nakimuk dja nakuken duninjh. ");
INSERT INTO gup_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Wanjh Moses bimarneyimeng Pharaoh yimeng, “Kuhni Yawey ngunmarneyime, wanjh kayime ke, ‘Bolkkime kukakburlhdjan bu ngaye nawu Yawey ngare kore ngurrihni kubolkwarlah Egypt, ");
INSERT INTO gup_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","dja nawu nadjdjaman rowk kore kubolkwarlah Egypt wanjh kabirridowen. Ngaye ngabun nawu ngudda yibornang nadjdjaman ke, mak ngadjalle ngabenbun rowk nawu birrikihkkimuk birriwern, dja kaluk bedda dorrengh nawu bedman daluk nawu birrimarladj kabindimarnedurrkmirri birribuyika manmim kabirrimimberelhme, dja mak ngabenbun rowk nawu mayh nadjdjaman. ");
INSERT INTO gup_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Dja kaluk bulkkidj duninjh ngurrinalkbun kore kubolkwarlah Egypt rowk, ngurrinjilngwarremen ngurriwernhnalkbun yiman minj korroko ngurrinalkbuyi, dja minj mak rerre ngurrinalkbun yiman kunihbu ngurriyime. ");
INSERT INTO gup_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Dja bedda nawu Israel benkebmawahmeng, ngaye minj kuninjkunu ngabenmarnekurduyime. Djal burrkyak kuhni. Minj njale mak kakurduyimerran bedberre. Kuhni ngaye nawu Yawey ngakurduyime rowk, ba kaluk ngurriburrbun bu ngaye bebbehbeh bebbehmarnekurduyime ngudda nawu Egyptbeh bininj, dja bininj nawu Israel benkebmawahmeng.’ Kuhni bu Yawey ngunmarneyime ngudda nawu Pharaoh.” ");
INSERT INTO gup_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mak Moses bimarneyimeng nawu Pharaoh, yimeng, “Nanih rowk nawu ngundimarnedurrkmirri Pharaoh wanjh kabirrimre kore ngaye ngarri, dja kanjdji ngandimarneboddan, ngandimarneyime, ‘Ngurriray! Ngudda dja bininj rowk nawu ngundikadjung.’ Wanjh rerrikah bu kunmekbe kabirriyime ngardduk, wanjh ngare.” Bu kuhni Moses yimeng rowk, wanjh kangewurlhmi duninjh dja bebmeng bibawong Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Kaluk Yawey biyingkihmarneyimeng Moses, yimeng, “Pharaoh minj ngunbekkan. Kuhni kayime ba bu bolkkime ngaye ngawernwon kunbubuyika kundulkarre dorrengh nawu ngakurduyime kore Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses dja Aaron benekurduyimeng rowk kuhni bu kunbubuyika nawu kundulkarre dorrengh kore Pharaoh kumirrk nuye, dja Yawey bikangerayekwong Pharaoh, dja nungka minj benmunkewemeninj bininj nawu Israel benkebmawahmeng bu birribolkbawoyi kubolkwarlah nuye. ");
INSERT INTO gup_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Wanjh Yawey benbenemarneyimeng Moses dja Aaron kore kubolkwarlah Egypt beneni, yimeng, ");
INSERT INTO gup_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Maninjmanu dird wanjh kayimerran ngudberre kaluk karrokme kore dirdbubuyika ngarre, bu kayimerran munguyh munguyh kore mandjewk nakerrnge. ");
INSERT INTO gup_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ngurrbenmarneyimen birridjalwern rowk bininj nawu Israel benkebmawahmeng, bu birridjarrkmirndemornnamerrinj kore yiwarrudj kore kunbarnangarra ten ngarre maninjmanu dird. Wanjh birribebbehma mayh yaw kaluk bedberre nawu kabirridjarrkyo, kaluk nakudji mayh djarrkbedberre nawu kunrurrkkudji kabirridjarrkyo. ");
INSERT INTO gup_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Dja bu yikahwi nawu kabirridjarrkyo minj birriwern, minj kabirringun kabirriyakwon mayh yaw, wanjh kunu birribuyika nawu kabindidarnhmarneyo wanjh birridjarrkma nakudji mayh yaw, dja birrimirnderohrokmerrimen nawu kabirridjarrkngun kabirriyakwon, wanjh birrimekbe birridjarrkma mayh yaw. ");
INSERT INTO gup_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Dja nawu lamb kaluk nadjalmaknin ngurribebbehma minj kakarrme kunmok, kaluk narangem nawu nakudji mandjewk nuye, kaluk sheep yaw dja goat yaw. ");
INSERT INTO gup_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Dja namekbe mayh yaw ngurridjalbebbehkarrmen kaluk bu fourteen kunbarnangarra ngarre maninjmanu dird, wanjh kumekbe ngurridjalwern bininj nawu Israel ngunkebmawahmeng rowk ngurrimirndemornnamerren yiwarrudj, dja ngurrbenbu mayh yaw ngudberre bu kabalbolkmununmen. ");
INSERT INTO gup_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wanjh yikahwi kunkurlba ngurrima ngurridelkke kururrkdangmayekenh ngarre kunrurrk kore ngurringun nawu mayh. Ngurribaru kunkurlba kore kundulk bokenh manu kadjabdi kunrurrkdangmayekenh, dja manbuyika kundulk manbu kaddumkah karrulkyirriyo kururrkdangmaye ngarre. ");
INSERT INTO gup_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mayh yaw wanjh ngurrikerribu dja ngurrikanjngu kundjalmekbe kumunun rerrih, ngurringu mandulmuk kandidjdjawa dorrengh, dja warridj manworrbang kunworr. ");
INSERT INTO gup_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Yuwn ngurriwohngun mankanjkuk, dja yuwn mak ngurrikinje kore kukku, dja mandjalkerrikenh ngurringu. Kaluk ngurringun kunkodj, kundad, kunnjam, kundiw, kundayken, dja kundurddu dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Yuwn bu yikahwi ngurriwohbawon malamalaywi kawohyo, dja nawu kadjalwohyo malamalaywi wanjh ngurridjalkanjyakwo rowk kore kunak. ");
INSERT INTO gup_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Kuninjkunu wanjh ngurriyime bu ngurringun. Wanjh ngurridjongbuyindi ngurrirekenh, ngurringadmodukkarrimen dja mak ngurridengedjongbuyindi, dja kunkarndudj ngurrikarndudjkarren kubid dja djalwerrkwerrk wanjh ngurringun. Mahni wanjh mulil ngardduk, ngaye nawu Yawey, dja ngurringun nawu mayh bu ngaye darrkidbawonkenh ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Dja ngaye ngadjalle kore kubolkwarlah Egypt bu kunmekbe kumunun, dja ngabenmarnebun rowk nawu nawehwernwarre rowk kumekbe kore kubolkwarlah Egypt, kaluk bininj dja mayh warridj nawu kelebuk, dja ngaye ngabendjadme ngabenbun nawu god nawarrewarre rowk bedberre bininj nawu Egyptbeh. Ngaye wanjh Yawey. ");
INSERT INTO gup_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Dja mahni kunkurlba ngurribarungi, kaluk nganbukkankenh ngudberre kore kunrurrk ngurrini, dja bu nganan kunkurlba, ngaye darrkidbawon ngudberre, minj njale kundjak ngunmang ngunbunkenh bu ngabenbun nawu kabirrihni kore kubolkwarlah Egypt.” Kuhni wanjh Yawey benbenemarneyimeng Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Wanjh Yawey benbeneyawoyhmarneyimeng, yimeng, “Kuninjkunu kunbarnangarra wanjh kayimerran kunbarnangarra ngurriburrbunkenh munguyh, wanjh bu kuninjkunu kunbarnangarra kandimulilmang ngaye nawu Yawey. Ngurrikarremarnbun ba nawu yerreyerre kabirridangen kabirridjalmarnbun kuninjkunu kunbarnangarra ngandimulilmang djalmunguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Bu seven kunbarnangarra kaluk ngurridjalngun mandulmuk kandidjdjawa, dja kunbarnangarra manbu karrokme wanjh ngurribebke manbu mannguklurlmikenh, yuwn kayo kururrk ngudberre. Dja nangale nawu kangun manbu kakarrme mannguklurlmikenh bu kunmekbe seven kunbarnangarra rowk, wanjh namekbe nawu kangun ngurridjalbebkemen, ngurribawo nadjalkudji nungandeleng kahdjalni. ");
INSERT INTO gup_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Kunbarnangarra manbu karrokme wanjh ngurrimirndemornnamerren bu kundjamun ngayekenh, dja bu seven kunbarnangarra ngurrimirndemornnamerren kundjamun bu ngayekenh nawu Yawey. Minj nangale kawohdurrkmirri bu kunmekbe kunbarnangarradjamun bokenh, kundjalkudji ngurridjalmarnbun manme manbu ngurringunkenh.” ");
INSERT INTO gup_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Ngudda kaluk ngurrimarnbun mulil kandidjawakenh manbu mandulmuk, dja bu kuninjkunu kunbarnangarra ngaye mirndebebkeng ngudberre kore ngurribebbehmirnderri kubolkwarlah Egyptbeh. Wanjh kunmekbekenh kunu ngurrikarremarnbun kandimulilmang ngudda dja nawu rerrererre kabirridangen bedmanwali ngandimulilmang bu kuninjkunukenh kunbarnangarra djalmunguyh. ");
INSERT INTO gup_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kaluk dird manbu karrokme wanjh bu kunbarnangarra fourteen bu kabaldungyibme, wanjh ngurringun. Mandulmuk kandidjdjawawi ngurridjalngun, kaluk ngurriburnbun bu kunbarnangarra twenty one, bu kabaldungyibme. ");
INSERT INTO gup_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Bu kunmekbe kunbarnangarra seven yuwn mannguklurlmikenh kayo kore kunrurrk ngudberre, dja bu yimankek nangale kangun manbu kakarrme mannguklurlmikenh, wanjh ngurridjalbebkemen, ngurribawo nadjalkudji nungandeleng kahdjalni. Bu djamku namekbe danginj kore ngudberre, dja kunubewu nawokbuyika nawu kawohyo kore ngudda, wanjh kunu ngudda ngurridjalbebkemen. ");
INSERT INTO gup_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Minj njale ngurriwohngun manbu kakarrme mannguklurlmikenh, dja kore kunrurrk rowk ngudberre ngurridjalngu mandulmuk kandidjdjawa.” Kuhni rowk Yawey benbenemarneyimeng Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Wanjh Moses benkayhmeng rowk bininj nawu Israel benkebmawahmeng dabborrabbolk, dja benmarneyimeng, “Ngurridjarrngbu mayh yaw, nakudji ngurribebbehma ngudberre nawu ngurrimud nawu ngurrirohrokme ngurridjarrkngun, wanjh ngurribu mayh yaw ngarre Yawey kandarrkidbawonkenh. ");
INSERT INTO gup_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Dja ngurrimang kunworr manbu kangeyyo hyssop, dja manekke kunworr ngurridjuhke kore kunkurlba mayh nuye manbu ngurribodahkendoy kore djabirlana. Wanjh ngurridulkbarung kaddumkah kore ngurribalhngimen dja mak bokenh kurlirrih, ngurridulkbarung kunkurlba manbu kahyo kore djabirlana, dja mak minj nangale kabebme kururrkbeh bu kukakkuyeng. ");
INSERT INTO gup_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Dja Yawey kawohre kabenbun bininj nawu Egyptbeh, wanjh bu kanan kunkurlba kaddumkah kururrkdangmaye dja kore kurlirrih bokenh, wanjh kunu nungka karurrkdangmayeyurrhke ngudberre, dja kabirrahme nawu kabenbun bininj, ba minj kangimen kunrurrk ngudberre ngunbunkenh.” ");
INSERT INTO gup_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","25","“Yawey ngunbolkberrebbom kubolkwarlah, dja nungka kaluk ngunbolkwon. Wanjh bu ngurribebme ngurribolkmang kumekbe kubolkwarlah maninjmanu wanjh ngurrimarnbun, ngurrikarremarnbun ba munguyh ngurriburrbun mulil ngurrimarnbun kore ngaye marneyimeng, ngudda dja nawu ngurrbenkebmawahme djalmunguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Dja bu narahrangem ngudberre ngundidjawan kabirriyime, ‘Baleh kakarreyime maninjmanu mulil ngurrimarnekurduyime nuye Yawey?’ ");
INSERT INTO gup_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Wanjh bu kuhni kabirriyime, ngudda ngurrbenmarneyimen, ‘Maninjmanu wanjh karriburrbun Yawey nuye bu kandarrkidbawongkenh. Karrikurduyimen bu nungka kanmarnerurrkyurrhkeng ngad kadberre kunrurrk, bininj nawu Israel kankebmawahmeng bu ngarrihni kore Egypt. Nungka benbom bininj nawu Egyptbeh dja ngad nawu kandarrkidbawong. Kunmekbekenh kunu karrbenbun nawu mayh.’ Kuhni bu ngurrbenmarneyimen ngudberre narahrangem.” Bu kuhni Moses yimeng rowk, wanjh bininj rowk bedda birridjudkurlmeng bu birriburlumi Yawey. ");
INSERT INTO gup_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Wanjh bedda bininj nawu Israel benkebmawahmeng birriwam birridjalkurduyimeng rowk nawu Yawey benbenewokrayekwong Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kaluk bu kumununbulhdjarn Yawey benbom rowk nawehwernwarre kore kubolkwarlah Egypt, bibom beywurdwernwarre nuye Pharaoh nawu wohrnani. Bendjalbom rowk nawehwernwarre. Kaluk bedda bedberre warridj nawu birridangbalhmiyindi kore kururrkmunun prison, benbom nawehwernwarre bedberre rowk bininj nawu Egyptbeh, dja mak nawehwernwarre rowk nawu mayh kelebuk benbom, wanjh birridowerrinj rowk. ");
INSERT INTO gup_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Wanjh Pharaoh dja bininj nuye nawu birrimarnedurrkmirri dja bininj rowk nawu Egyptbeh, wanjh birrikakdolkkarrinj dja birribebbehnalkbuni bulkkidj duninjh kore kururrkbubuyika rowk kumekbe kore Egypt dja kore kururrkbubuyika bedberre nawehwernwarre birridoweng. ");
INSERT INTO gup_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Bu kunmekbe kukak rerrih wanjh Pharaoh benbenekayhmeng Moses dja Aaron, wanjh benbenemarneyimeng, yimeng, “Bonj. Wanjh ngurridolkka ngurriray kandibawo ngadberre, ngudda dja bininj nawu Israel benkebmawahmeng wanjh ngurriray ngurridi yiwarrudj Yawey nuye bu ngudda nguneyimeng. ");
INSERT INTO gup_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ngurrbenmirndeka mayh bu ngudda nguneyimeng, dja ngurridjallaywi. Dja bu ngaye warridj, yidjawa Yawey bu ngandimarnekurduyime kunmak ngardduk.” ");
INSERT INTO gup_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Wanjh bininj nawu Egyptbeh bindidjurrkdjurrkwoni bininj nawu Israel benkebmawahmeng. Birridjareni bindimunkewemeninj djalwerrkwewerrkwerrk bindimarnebolkbawoyi, kubolkwarlah bedberre, birriyimeng, “Wardi ngarridowerren rowk bu minj ngurrire!” ");
INSERT INTO gup_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Wanjh kunu bininj nawu Israel benkebmawahmeng birrimey buriddi bedberre bu minj birribangmekurrmeninj mannguklurlmikenh, dja minj mak birrikinjemeninj, dja djabirlana manbu kandidjawakenh birrikarrmeninj wanjh birridukkang kore kumadj bedberre birringorrkang kukarlang. ");
INSERT INTO gup_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Dja bedda bininj nawu Israel benkebmawahmeng ngokko birrikurduyimeng warridj nawu Moses benmarneyimeng, ngokko bindidjawani bininj nawu Egyptbeh kabindiwon yehyeng namakmak nawu birridjongburreni silver dja gold, dja mak kunmadj. ");
INSERT INTO gup_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yawey benmarnbom bininj nawu Egyptbeh bindimarneyimeng nawu Israel benkebmawahmeng kunmak, bindiyidjalyibawong rowk yehyeng nawu bindiyidjawam. Bu kuhni birriyimeng wanjh bininj nawu Israel benkebmawahmeng bindikukyiyakwong bininj nawu Egyptbeh. ");
INSERT INTO gup_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Wanjh bedda bininj nawu Israel benkebmawahmeng birribolkbawong kubolkkimuk kabolkngeyyo Rameses. Kumekbe birrihni kore kubolkwarlah Egypt. Birribolkbawong, birridjalwam kurrenge, wanjh birribebmeng kabolkngeyyo Succoth. Bedda wanjh birrimirndewernni. Kaluk bininjwi wanjh birridjalwernhmirndewernni duninjh dja mak daluk dja wurdwurd dorrengh birridjalwern, minj bindirohrokmeninj. ");
INSERT INTO gup_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Dja mak birrimirndebubuyika birridjarrkrey nawu birriwokbubuyika, dja mak birriwern duninjh mayh bindimirndekani. ");
INSERT INTO gup_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Dja manekke buriddi nawu birrikukyibebmi Egyptbeh wanjh birrikinjeng mandulmuk buriddi, dja minj birribangmekurrmeninj manu mannguklurlmikenh bu Egypt birrihni, dja bindimunkeweng Egyptbeh djalwerrkwerrkni. Minj nangale birriwohmaddeyi, dja mak minj birriyingkihmarnbuyi manme bedberre. ");
INSERT INTO gup_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Kaluk mandjewk rowk bu bininj nawu Israel benkebmawahmeng birrihni kore Egypt wanjh 430 mandjewk. ");
INSERT INTO gup_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kaluk bu 430 mandjewk balyakminj wanjh kundjalmekbe kunbarnangarra rerrih, Yawey nuye bininj birriwern rowk birrimirndebebmeng bu birribolkbawoni kubolkwarlah Egyptbeh. ");
INSERT INTO gup_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Kunmekbe kumunun wanjh Yawey djahdjalwohrnani kunkakkuyeng bennahnanikenh nuye bininj benbebkengkenh kubolkwarlah Egyptbeh, wanjh kunmekbekenh kunu kuninjkunu kumunun bininj nawu Israel benkebmawahmeng kabirrimarnbun kumunun bu minj kabirrikodjkeyo bu kukakkuyeng Yawey nuye. Kuhni birrikurduyimeng bedda dja nawu rerrererre kabirridangerren djalmunguyh. ");
INSERT INTO gup_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Wanjh Yawey benbenemarneyimeng Moses dja Aaron, yimeng, “Kuhni wanjh kakarreyime mulilkenh bu darrkidbawongkenh. Bininj nawu birriwokbuyika minj kabirringun, birribawo. ");
INSERT INTO gup_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Dja bininj rowk nawu ngurrbenmang bu bininj kabindiweykan, ngurrbenkukwon kunwardde, bedda nawu ngurrbenmang ngundimarnedurrkmirrikenh wanjh kamak kabirringun bu ngurrbenlakkayenwon werrk. ");
INSERT INTO gup_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Dja bininj nawu kabirridjalwohdi kore ngudda, bedda wanjh minj kabirringun. Dja mak bininj birriwokbuyika, nawu kabirrihdurrkmirri ngudberre nawu ngurrbenkarremulewan, bedda warridj minj kabirringun. ");
INSERT INTO gup_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Dja bu ngurringun ngurridjalngun kore kundjalrurrkkudji, yuwn ngurriwohkanjkan kuberrk, dja yuwn nawohkudji kunmurrng ngurrimurrngbakke nanu mayh nuye ngurribun. ");
INSERT INTO gup_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ngurridjalwern rowk bininj nawu Israel ngunkebmawahmeng wanjh ngurringun mulil.” ");
INSERT INTO gup_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Dja bu bininj nawu birriwokbuyika kabirrihni kore ngudda, dja kabirridjare mulil ngardduk ngurridjarrkngun, kore ngaye Yawey darrkidbawongkenh, wanjh ngurrbenlakkayenwo narahrangemwi bedberre rowk, dabborrabbolk nawu binihbininj, dja mak nawu wurdwurd bedberre. Wanjh kunu bedda ngurriraworren ngurringun mulil. Bu bedda kabirriyimerran yiman bininj rerrih nawu birridanginj kore ngudda. Dja bininj nawu minj nangale bilakkayenwoyi wanjh yuwn nawohkudji kore bedda kaluk kangun. ");
INSERT INTO gup_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kaluk mankarrekudji ngudberre rowk nawu ngurridanginj kured dja nawu kabirridjalwohni kore ngudda.” Kuhni bu Yawey benbenemarneyimeng Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Wanjh bininj nawu Israel benkebmawahmeng rowk kunmekbe birrikurduyimeng. Birridjalkurduyimeng bu Yawey benbenewokrayekwong Moses dja Aaron. ");
INSERT INTO gup_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Dja bu kundjalmekbe kunbarnangarra rerrih Yawey benmirndebebkeng kubolkwarlah Egyptbeh dja namudbubuyika birribebbehrey. ");
INSERT INTO gup_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","2","Yawey bimarneyimeng Moses, yimeng, “Nawu nawehwernwarre rowk ngurrbenmarnbu nadjamun ngardduk. Nawu nayungkih karrangen ngudberre rowk ngudda bininj nawu Israel benkebmawahmeng wanjh ngayeman ngardduk, bininj dja mak mayh kelebuk.” ");
INSERT INTO gup_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Wanjh Moses benmarneyimeng bininj nawu Israel benkebmawahmeng, yimeng, “Kuninjkunu kunbarnangarra ngurridjalburrbu. Kumekbe kunbarnangarra bu karribebmeng Egyptbeh, karribebmeng kubolkwarlahbeh kore karrbenhmarnedurrkmirri yiman bu karrihbongdi rerrih. Dja nungka Yawey kunngudj nuye kanbebkeng kunmekbekenh kunu ngurridjalburrbun bu munguyh. Wanjh yuwn njale ngurringun buriddi manbu kakarrme mannguklurlmikenh. ");
INSERT INTO gup_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Karribawon Egypt bolkkime kuninjkunu kunbarnangarra kore maninjmanu dird manbu karrokme manbu kangeyyo Abib. ");
INSERT INTO gup_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ngurriburrbu bu Yawey kunwok kunrayek duninjh nuye wokkurrmerrinj korroko. Benyingkihbolkberrebbom mawahmawah, yimeng bu kaluk kanbolkwon kunbolkmak kore manwern manme kadjordmen. Kaluk wanjh Yawey ngunyibebme ngudberre kumekbe kunbolk kubolkwarlah. Bolkkime wanjh kumekbe kunbolk bedberre nawu Canaan benkebmawahmeng, dja nawu Heth benkebmawahmeng, dja nawu kabirribebbehngeyyo Amor dja Hiv, dja nawu birrikang kunred Jebus. Wanjh bu kumekbe Yawey ngunyibebme, ngurrimarnbu kuhni mulil bu kuninjkunu dird manbu karrokme kudjewkbubuyika rerrih.” ");
INSERT INTO gup_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","“Bu seven kunbarnangarra ngurringu buriddi manbu minj kakarrme mannguklurlmikenh, dja bu kunbarnangarra seven kayakmen, wanjh mulil ngurrimarnbun nuye Yawey. Bu kunmekbe seven kunbarnangarra rowk ngurringun mandulmuk buriddi manbu minj kakarrme mannguklurlmikenh, dja kore kubolkwarlah rowk yuwn kawohyo manu mannguklurlmikenh manme, dja mak buriddi manbu kakarrme mannguklurlmikenh. ");
INSERT INTO gup_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Dja bu ngurrimarnbun manu mulil ngurrbenmarneyimen bebeywurd ngurriyimen, ‘Kuhni karrikurduyime karriburrbunkenh bu baleh Yawey kanmarneyimeng bu nungka kanbebkeng Egyptbeh.’ ");
INSERT INTO gup_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Kunmekbe ngurriyime dja maninjmanu mulil wanjh yiman rerrih manu kawohbimdi kubid ngudberre ngunbukkankenh dja mak kawohbimdi kumilh ngunbengdayhkekenh ba Yawey nuye mankarre ngurriburrbun ngurringeyhngeybun dja nungka Yawey kanbebkeng kadberre nungka kunngudj nuye. ");
INSERT INTO gup_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kunmekbekenh kunu wanjh maninjmanu mankarre mulilkenh karriburrbun. Karrimarnbun mulil yerreyerre kudjewkbubuyika bu kuninjkunu dird.” Kuhni rowk bu Moses benmarneyimeng bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Wanjh Moses benmarneyimeng, yimeng, “Kaluk Yawey ngunyibebme ngudberre kore kunmekbe kubolkwarlah bedberre nawu bindimarneyimi bininj nawu Canaan benkebmawahmeng. Kumekbe bu nungka Yawey kunwok kunrayek nuye wokkurrmerrinj, kanbolkberrebbom kadberre, dja warridj mawahmawah dorrengh kadberre. Wanjh kaluk bu Yawey ngunbolkwon. ");
INSERT INTO gup_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Wanjh ngurriwo nayungki rowk nawu karrangen. Nawehwernwarre rowk nawu narahrangem nawu mayh kelebuk ngudberre, bedda wanjh kabirridjalyime nungka Yawey nuye. ");
INSERT INTO gup_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Dja nawu donkey nawernwarre ngurriyidurndiwemen ngudberre, ngurribidyimang Yawey bu ngurriwon sheep yaw, dja bu minj ngurridurndiwe nawu donkey wanjh ngurridjudbakkemen. Dja nawu nawehwernwarre nawu bebeywurd ngudberre ngurrbenbidyima Yawey ngurrbenyikarremulewa ngurrbendurndiwemen ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Dja bu yerrih bu bebeywurd ngundidjawan bu njalekenh kuhni ngurrikurduyime, wanjh ngurrbenmarneyimen, ‘Yawey kunngudj nuye kanbebkeng Egyptbeh kore karrihbongdi. ");
INSERT INTO gup_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Dja bu Pharaoh djahdjalkangerayekni kandahmi, minj kanmunkewemeninj, kunu wanjh Yawey benbom rowk nawehwernwarre kumekbe kore kubolkwarlah Egypt, kaluk nawehwernwarre bedberre nawu bininj dja mak mayh kelebuk. Wanjh kunmekbekenh kunu ngad karribun mayh narahrangem nawu nayungki karrangen, karribun, karrikinje Yawey nuye. Dja nawu nawehwernwarre nawu bebeywurd kadberre bedda wanjh karrbenyikarremulewan karrbenbidyimang Yawey karrbendurndiwe kadberre. ");
INSERT INTO gup_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kuhni karrikurduyimen wanjh yiman rerrih manu kawohbimdi kubid ngudberre ngunbukkankenh dja mak kawohbimdi kumilh ngunmarnemulewankenh bu Yawey kanbebkeng Egyptbeh kunngudj kunkimuk nuye.’ Kuhni bu ngurrbenmarneyime nawu bebeywurd ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kuhni wanjh kayolyolme bu Pharaoh benmunkeweng bininj nawu Israel benkebmawahmeng, God benmikang kore kubolkdarleh djarreh, dja bu manbolh manbu darnkih minj benmikayi dja wardi bindimarnebebmeninj bininj nawu Philistiabeh. Dja bu birriburrimeninj wanjh God yimerrinj, “Wardi bininj nawu Israel benkebmawahmeng kabirrimayaliborledme kabirridurndeng Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Wanjh kunmekbekenh kunu God benmikang djarreh kore manbolh manbu kare kore kubolkdarleh, kadjalle kore darnkih kurrula kabongeyyo Red Manbokurlba. Bininj nawu Israel benkebmawahmeng birribolkbawong Egyptbeh birrikani nawu bindibunikenh birribuyika nawu bindidabkemeninj. ");
INSERT INTO gup_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Wanjh bu Moses bolkbawong Egypt, wanjh kang Joseph nuye kunmurrng dja Joseph korroko wokkurrmerrinj kunwok kunrayek bedberre bininj nawu Israel benkebmawahmeng, kuhni wanjh yimeng, “Woybukkih wanjh God kaluk karrire ngunbidyikarrmekenh, wanjh kunmekbe kandidjalmurrngka bu ngurrire kondahbeh.” ");
INSERT INTO gup_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Bu bininj nawu Israel benkebmawahmeng birribolkbawong Succoth wanjh birriwohyonginj kabolkngeyyo Etham kore darnkih kubolkdarleh. ");
INSERT INTO gup_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Bu kunbarnangarra yarrkka Yawey benmarnedokmi kore kungol manbu nungka djabnameng kumirrk bedberre benmikanikenh, dja bu kumunun yimerrangeni nungka benmarnedokmi, rungi yiman kunak manbu nungka djabnameng benmarnebolkwolkani ba bu birrirawinj kunbarnangarra dja mak kunkak. ");
INSERT INTO gup_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Dja manekke manu kunngol manbu djabnameng minj benwohbawoyi bu kunbarnangarra yarrkka. Dja bu kunkak yarrkka, wanjh manbu kunak minj benwohbawoyi, dja munguyh djahdjaldokmi kumirrk bedberre bininj nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Wanjh Yawey bimarneyimeng Moses, yimeng, “Yibenmarneyimen bininj nawu Israel benkebmawahmeng kabirridurndeng kabirriyo darnkih kabolkngeyyo Pi Hahiroth, kubulkayh ngarre kabolkngeyyo Migdol dja Manbokurlba. Birriyuwn kurrula darnkih borledmikenh ngarre kabolkngeyyo Baal Zephon. ");
INSERT INTO gup_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Wanjh Pharaoh kaluk kayime bu ngudda bininj nawu Israel ngunkebmawahmeng ngurridjalwakbun, dja minj ngudda baleh ngurriyime, kubolkdarleh ngunbalhmeng ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kunmekbe nungka kayime, dja ngaye Yawey ngakangerayekwon dja nungka ngunkadjung ngudberre. Kaluk bu ngaye ngabenbun Pharaoh dja miwadj nuye rowk wanjh ngaye ngangeykukenmen, dja kumekbe wanjh bininj nawu Egytpbeh kaluk kabirriburrbun bu ngaye Yawey.” Wanjh bininj nawu Israel benkebmawahmeng birrikurduyimeng bu nungka yimeng bedberre. ");
INSERT INTO gup_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kaluk bu nungka nawu wohrnani kore Egypt, bu birrimarneyimeng bu bininj nawu Israel benkebmawahmeng birrikelerlobmeng birriwam, wanjh nungka nawu Pharaoh dja bininj nuye nawu birrimarnedurrkmirri wanjh birrimayaliborledmeng bedberre dja birriyimeng, “Njale kuhni bu ngad karrikurduyime, bu karrbenmunkewe bininj nawu Israel benkebmawahmeng, dja bedda minj mak kandimarnedurrkmirri?” ");
INSERT INTO gup_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Wanjh kuhni Pharaoh yingkihkurrmeng chariot nuye dja mak benkang miwadj nuye birridjarrkwam, dja mak ");
INSERT INTO gup_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","birrikang chariots rowk ngarre Egypt kaluk 600 manu manwernhmak duninjh, dja bininj nawu birriwohrnani chariots ngarre rowk. ");
INSERT INTO gup_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Dja Yawey bikangerayekwong Pharaoh nawu wohrnani kore Egypt ba kabindikadjung bininj nawu Israel benkebmawahmeng bu bedda birrihdjalley minj birrimarnekeleniwirrinj Pharaoh. ");
INSERT INTO gup_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Bedda bininj nawu Egytpbeh bindikadjuy, kaluk Pharaoh nuye djarrang, chariots dja bininj nawu chariots birridahkendi, djarrang bindidjurrkkani. Wanjh kaluk bindimarnebebmeng bininj nawu Israel benkebmawahmeng kore birriyoy kore kurrula darnkih kabolkngeyyo Pi Hahiroth borledmikenh ngarre Baal-Zephon. ");
INSERT INTO gup_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Bu Pharaoh dorrengh bindimarnebebmeng darnkih, wanjh bininj nawu Israel benkebmawahmeng birriwohrnang wanjh bindinang bininj nawu Egytpbeh kabindimhkadjung, wanjh kunu birrikeleminj duninjh, dja bedda birrimarnekayhmeng Yawey. ");
INSERT INTO gup_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Dja birrimarneyimeng Moses birriyimeng, “Yiddok kumidjyak kore Egypt bu ngudda kanbebkeng ba bu ngarridowen kondah kubolkdarleh? Njale ngudda kanmarnekurduyimeng bu kanbebkeng Egyptbeh? ");
INSERT INTO gup_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Dja bu karrihni kore Egypt, ngad kuhni wanjh ngundimarneyimeng, ‘Kanbawo ngadberre, ngarrbendjalmarnedurrkmirri bininj nawu Egytpbeh.’ Wanjh kunmakniwirrinj bu ngarrbenmarnedurrkmiwirrinj, dja kunwarre bu kondah kubolkdarleh ngarridowen.” ");
INSERT INTO gup_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Kuhni birriyimeng, wanjh Moses yimeng bedberre, “Yuwn ngurrikele, ngurridjaldin kelebuk, dja ngurrina bu Yawey ngunmarnedurrkmirri bolkkime ngunngehke. Dja bedda bininj nawu Egytpbeh ngudda ngurrbennan bolkkime, wanjh minj ngurriyawoyhbennan bu munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yawey nungka kabenbun ngudberre, minj baleh ngurrikurduyime, ngurridjalngurdmen dja ngurridjaldin.” ");
INSERT INTO gup_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Wanjh Yawey bimarneyimeng Moses, yimeng, “Njalekah kandikayhme? Yibenmarneyimen bininj nawu Israel benkebmawahmeng kabirridjalle. ");
INSERT INTO gup_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Yirrulkma kundulk ke, dja yibidwayhmen kaddumkah ngarre kurrula dja yibolarlma, ba ngudda bininj nawu Israel ngunkebmawahmeng ngurridjalle kubolkbuk kurorre kubulhdjarn kurrula. ");
INSERT INTO gup_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Dja ngaye ngabenmarnbun bininj nawu Egytpbeh ba ngundiwidnan dja ngundidjalkadjung ngudberre, dja kaluk ngangeykukenmen bu ngabenbun rowk Pharaoh nuye bininj namirndewern, chariots nuye, dja bininj nuye nawu kabindidjurrkkan djarrang. ");
INSERT INTO gup_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Dja bu kunmekbe ngayime ngangeykukenmen bu ngabenbun wanjh kunu bininj nawu Egytpbeh kabirriburrbun bu ngaye wanjh Yawey nawu nawernhkimuk duninjh.” Kuhni bu Yawey bimarneyimeng Moses. ");
INSERT INTO gup_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Wanjh God nuye angel nawu benmarnedokmi bininj nawu Israel benkebmawahmeng nawu mirnderey, wanjh borledmeng benmunkebuni, dja kunngol manbu djabdihdjabdi benmarnedokmi wanjh borledmeng danginj kubodme bedberre. ");
INSERT INTO gup_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Kunmekbe danginj kubulkayh bedberre bininj nawu Egytpbeh dja bininj nawu Israel benkebmawahmeng birribebbehmirnderri. Dja bininj nawu Israel benkebmawahmeng benmarnebolkwolkani manmekbe kunngol, dja bininj nawu Egytpbeh benmarnebolkmarnbom kumunun rerrih. Wanjh kuhni minj baleh birriyimeninj bindimarnebebmeninj darnkih kukakkuyeng dja minj birriburrimeninj. ");
INSERT INTO gup_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Wanjh Moses bidwayhmeng kaddumkah ngarre kurrula dja Yawey boyarlarrkeyi kurrula kukakkuyeng bu nungka kunmayorrkkimuk munkeweng koyekbeh, nungka bolkmarnbom kubolkbuk kore kurrula bu boyarlarrkeng bobebbehdi. ");
INSERT INTO gup_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Dja bininj nawu Israel benkebmawahmeng birridjalley dja birridjowkkeng kurrula kore kubolkbuk kanjdji, dja manu kurrula wernhbowayhmi kaddum kukun dja kudjakku bedberre. ");
INSERT INTO gup_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Wanjh bininj nawu Egytpbeh bindikadjungi, nadjalwern rowk nawu Pharaoh nuye djarrang, chariots, dja bininj nawu bindidjurrkkani djarrang, wanjh djal bindikadjungi kore kubolkbuk kore kurrula. ");
INSERT INTO gup_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Dja bu kumbarrhbuni, Yawey nawu di kaddum kore kunak dja kunngol manu djabdihdjabdi, wanjh nungka kanjdji bennang bininj nawu Egytpbeh nawu birrimirnderey, dja benmarnbom benkelehmeng. ");
INSERT INTO gup_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Nungka marnbom nawu chariots bedberre kuyinyibmeninj, dja yeledj birrihdjalley birribarabuni, wanjh bedda bininj nawu Egytpbeh birriyimeng, “Aba bonj! Karrikelerlobmen karrbenbawon bininj nawu Israel, dja Yawey kabenbidyikarrme kanbun kadberre nawu Egyptbeh.” ");
INSERT INTO gup_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Wanjh Yawey bimarneyimeng Moses, yimeng, “Yibidwayhmen kaddumkah ngarre kurrula ba kaborrurnderren kore bininj nawu Egytpbeh, chariots bedberre dja bininj nawu kabindidjurrkkan djarrang bedberre.” ");
INSERT INTO gup_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Wanjh kunu Moses bidwayhmeng kaddumkah ngarre kurrula, wanjh bu kumbarrhbuni borrurnderrinj kore berrehboyen boyihboyimi, dja bininj nawu Egyptbeh bu yimankek birrikelerlobmeninj wanjh birridjalbebmeng kore kurrula, kumekbe Yawey benbom benyakwong rowk. ");
INSERT INTO gup_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kurrula borrurnderrinj, benbarrkbom chariots dja bininj nawu djarrang bindidjurrkkani dja namirndewern nuye Pharaoh nawu bindikadjuy kore kurrula, benkebngakkeng rowk. Minj nawohkudji darrkidniwirrinj birrimekbe bininj nawu Egytpbeh. ");
INSERT INTO gup_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Dja bininj nawu Israel benkebmawahmeng, bedda ngokkokenh birribebmi birridjalley kore kurrula kore kubolkbukni, bu manu kurrula wernhbowayhmi kaddum kukun dja kudjakku bedberre. ");
INSERT INTO gup_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Kuhni kunbarnangarra wanjh Yawey kurduyimeng bu benngehkeng kore bininj nawu Egytpbeh bindibuyi. Wanjh bininj nawu Israel benkebmawahmeng bindinang bininj nawu Egytpbeh birrikukyoy kore kurrula ngarre kurrid. ");
INSERT INTO gup_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Wanjh bu bininj nawu Israel benkebmawahmeng birrikurdunang Yawey kurduyimeng kundulkarre kunkimuk dorrengh bu benbom bininj nawu Egytpbeh, wanjh bedda birrimarnekeleminj Yawey, dja birriwoybukwong Yawey dja mak birriwoybukwong Moses nawu bimarnedurrkmirri nuye. ");
INSERT INTO gup_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Wanjh maninjmanu mankarre bininj nawu Israel benkebmawahmeng dja Moses dorrengh, wanjh birriwayinidanginj nuye Yawey, bu birriyimeng, “Ngaye ngamarnewayini nuye Yawey nawu winhmeng rowk, dja karriburluburlumen munguyh. Nakka wanjh benkukburriweng kore kurrula benkebnguneng djarrang nawern dja nawu birriwarre duninjh bininj birrimorneni. ");
INSERT INTO gup_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ngamarnewayini Yawey nungka namakkaykenh. Nungka wanjh ngardduk God dja ngadjalburlume bu nungka nganngehkeng, dja nawu dulkarrekimuk duninjh dja nganngudjwon ngardduk. Nungka wanjh God bedberre nawu ngandikebmawahmeng, dja ngaye wanjh ngangeyburluburlume. ");
INSERT INTO gup_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Nungka Yawey kunmekbe kangeyyo. Dja mak nungka Yawey kadjare kabeneburren nawarrewarre dja kabenbun. ");
INSERT INTO gup_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Nungka benkukburriweng Pharaoh nuye djarrang dja wirlbarra, dja bininj nuye nawu birringudjbang kore Kurrula manbu Manborodjme dja wanjh birrikebngakmeng rowk. ");
INSERT INTO gup_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kurrula kunkimuk benkukbarrkbom, wanjh birriyibmerrinj yiman kunwardde kore kanjdji kurrula. ");
INSERT INTO gup_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ngudda Yawey yibenbom rowk bininj nawu ngundiwirrihmeng dja ngudda kunberlkukun ke makka wanjh kundulkarre duninjh kakarrme bu yibenkukyakwong rowk. ");
INSERT INTO gup_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ngudda king duninjh nawu yiwernhdulkarrekimuk, dja bininj nawu minj ngundiwokmarrkmayi nakka wanjh yibenburriweng. Manbu kunkangeyid ke makka yiman kayime kunak mankimuk bu karung, wanjh kunmekbe ngudda yikangeyidyimeng bu bininj yibenbom rowk yiman kayime kunak kayakwon mandalkdarleh. ");
INSERT INTO gup_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ngudda bu yingolekburriwerrinj kore kukeb ke, dja kundjalmekbe rerrih kukku manbu borokani djaldjabdanginj, wanjh manbu kukku bodjabdi yiman warnamyonginj kukuwi, dja kore kubulkayh kurrula, makka wanjh borayekminj yiman kayime bokedjelkminj duninjh. ");
INSERT INTO gup_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Nawu nganwirrihmeng, nakka wanjh burlumerreni, bu yimiyimi, ‘Ngaye ngabenngudjkadjung dja ngabendarrkidmang, wanjh ngabenbun dja ngamang bedberre namakmak nawu kabirrihkarrme dja kunbid ngardduk bu ngabenbun mandjawakwi, dja ngabenkukyakwon rowk.’ ");
INSERT INTO gup_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Bonj, dja ngaleng ngudda yingolekburriwerrinj bu yibenbarrkbom kukku wanjh benkebnguneng dja birrikukyibmerrinj kanjdji kore kurrula manbu yiman kayime wirlmurrng manwernhdulmuk. ");
INSERT INTO gup_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yawey, ngudda minj nangale nabuyika god ngunerohrok! Minj nabuyika god kakukbame kunmakmakkenh yiman ngudda. Minj nabuyika god nakurdumak yiman ngudda kore yikurdumakkaykenh yiman kunkimuk duninjh yidjalkurduyime ba bininj ngundimarnekangebarrhme. ");
INSERT INTO gup_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Bu ngudda yiberlyirriyongen kunberlkukun ke, wanjh manbu kunrorre makka karrangmarrhmire wanjh nawu ngudda ngurriyidko bininj kabirridjalkukyibmerren. ");
INSERT INTO gup_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Dja ngad nawu kanngehkeng bininj wanjh kanka bu yirrokdokme ngadberre ngudda nawu kandjalmarnedjare munguyh munguyh. Dja wanjh kandjalbolhbukkabukkan ngadberre, ngudda ke kunngudj dorrengh bu kanmikan kankurrme kore kubolkdjamun ke. ");
INSERT INTO gup_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Wanjh birriwarlahkenh bininj kore kubolkbubuyika, bu ngundiwobekkan, wanjh bedda kabirrideldelme bu kunkele dorrengh. Dja mak bininj nawu kunbolk Philistia kabirriyo wanjh kabirriwernhnjilngwarremen. ");
INSERT INTO gup_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Dja nawu kabirriwohrnawohrnan kore kunbolk Edom nakka wanjh kabirrikelemen duninjh; dja mak nawu birringudjbang bininj birrikang Moab wanjh kabirrikukdeldelme kunkele dorrengh. Dja mak bininj nawu birrikang kunbolk Canaan, wanjh nakka kabirridjalkelerlobme. ");
INSERT INTO gup_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bedda wanjh kabirridjalwernhkelemen duninjh bu bedda kabirrinan ngudda ke kunngudj, ngudda nawu Yawey. Bedda wanjh kabirringurdmerren bu kunkelekenh. Wanjh kunmekbe nawu ngudda ke bininj kabirrihre, birrimekbe bininj nawu ngudda yibenbebkeng kore birridurrkmirri bu birribongdi, wanjh djal kamak kabindihyuhyurrhke. ");
INSERT INTO gup_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kaluk yibenkan, yibenkurrme nawu ngudda ke bininj kore ngudda kunwarddekimuk manbu yibolkdjarrngbom ba bu yihni. Mahni kunbolkdjamun yibolkmarnbom kubid ke, ngudda nawu Yawey, dja kumekbe wanjh ngudda yirurrkmarnbom kunrurrk manbu Temple kore yihyo. ");
INSERT INTO gup_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Kaluk ngudda Yawey wanjh king duninjh dja yidjalwohrnan rowk, munguyh dja munguyh.” ");
INSERT INTO gup_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Nawu djarrang bedberre, dja bininj nawu birribarndi kore djarrang birridedjbongdongi bendorrorrkeyi, namekbe wanjh kukku benkebngungeng. Nungka Yawey benbarrkbom manmekbe kurrula nawu bininj birrikang Egypt. Dja bedda nawu Israel benkebmawahmeng bedda wanjh birrimelmeng kunbolkdarleh kore bodjalkmiwam manbu kurrula. Wanjh birridjaldjowkkeng rowk. Mahni wanjh birriwayini. ");
INSERT INTO gup_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Wanjh Miriam, ngalbu prophetni wayinidanginj. Ngalka wanjh Aaron benedanginj, dja mey tambourine karrmi kubid. Wanjh birriwern daluhdaluk rowk birrimunkekadjuy, birribuni tambourines dja mak birriborrkkeyi. ");
INSERT INTO gup_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam benmarnewayini, yimeng, “Karriwayinin nuye nawu Yawey, dja nungka wanjh namakkaykenh dja kanmarnewinhmeng! Nungka benkukburriweng djarrang dja bininj nawu birrimorneni, dja birringakmeng kore kurrula.” ");
INSERT INTO gup_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kaluk Moses benkang nawu Israel benkebmawahmeng kore kubolkdarleh kabolkngeyyo Shur. Kumekbe bedda birribolkbawong kore Kurrula Manborodjme, dja birrihdjalley kore kubolkdarleh bu kunkodjke danjbik dja kukkuyak birrihdjalley. ");
INSERT INTO gup_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Birriwam birribebmeng kore kabolkngeyyo Marah, wanjh kumekbe kukku boyoy, dja mak minj birribonguyi dja ngaleng manbowarreni. (Wanjh kunmekbekenh birribolkngeykurrmeng Marah manbu kamenmenyime “kukku manbo manbodjan”.) ");
INSERT INTO gup_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kaluk nawu binihbininj birriyolyolmi bu birrinjilngwarreni dja birridjawam Moses, “Kab, njale ngarribongun? Dja kukku yak!” ");
INSERT INTO gup_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Wanjh Moses danginj yiwarrudj bu bulkkidj duninjh, bu bidjawam Yawey. Dja Yawey bibukkang kundulk. Bu Moses dulkmey wanjh nungka dulkburriweng kore kukku. Wanjh kundjalmekbe rerrih manmekbe kukku wanjh bomanjmakminj bu kamak birribonguneng. Kumekbe Yawey benwong mankarre manbu ba kabirriwokmarrkmang, dja mak nungka kumekbe rerrih benrohrokmeng ba kanan bu kabirriwernhkarrme nungka nuye mankarre. ");
INSERT INTO gup_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Yawey yimeng, “Ngudda bu ngurriwernhmarrkkang rowk nawu wokrayekwon ngudberre, dja ngurridjalkurduyime rowk kore manbu ngayime mandjad, wanjh minj mak bun ngudberre kunwern kundjakwi manbu yiman kayime ngamunkeweng bu benbom bininj nawu birrikang Egypt. Ngaye Yawey nawu marnbun ngudberre ba minj ngurridulkkihngalme.” ");
INSERT INTO gup_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Wanjh nawu Israel benkebmawahmeng birriwam birribebmeng kore kunred Elim. Kaluk kumekbe kunred karrmi manbowern kukku kore njilhmi yoy, kaluk manmekbe kukku birrirohrokmeng twelve njilhmi. Dja mak manbu marrunj makka seventy dulkmirnderri kumekbe. Wanjh bedda kumekbe birrimadjkurrmeng dja birriyonginj kore kukku darnkih. ");
INSERT INTO gup_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Birridjalmirndewern duninjh nawu Israel benkebmawahmeng birribolkbawong kumekbe kunred Elim dja birriwam birribolkmey kore kubolkdarleh kabolkngeyyo Sin, kuburldjarn kore kunred Elim dja kunwarddekimuk Sinai. Kaluk birribebmeng bu kunbarnangarra fifteen dja dird nakudji bu yerre birribolkbawong kore kunred Egypt. ");
INSERT INTO gup_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Wanjh nawu Israel benkebmawahmeng bedda wanjh birrinjilngwarreni wanjh birrimarnewokkihnjurluhnjurlukmi Moses dja Aaron kumekbe bu birrihdi kore kubolkdarleh. ");
INSERT INTO gup_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Wanjh bindimarneyimeng, birriyimeng, “Ngad wanjh kamakniwirrinj bu Yawey kanbuyi ngadberre kore kunred Egypt. Kaluk kumekbe ngarriyerrkang ngarrikinjeng kunkanj dja ngarriworrkmiworrinj. Dja wanjh ngudda kanbebkeng ngadberre dja kankang kore kubolkdarleh ba bu ngarrimarrwedowen dja wardi ngarridjalyakmen kondah.” ");
INSERT INTO gup_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Wanjh Yawey bimarneyimeng Moses, “Ngaye kaluk ngamunkewe manme ngudberre bu kawarrawarrhme kaddumbeh yiman kayime mandjewk. Kaluk nahni bininj wanjh birriray kuberrk kunkodjke rowk, dja kabirrimoyhmang manme. Birrimoyhma djal kunkodjkekudjikenh kabirringun. Ngaye ngadjare ngabennan birrimekbe nawu Israel benkebmawahmeng bu kabirrikurduyime kore ngaye ngabenbengdayhke. Ngabenrohrokme. ");
INSERT INTO gup_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Dja bu kunkodjke six, bedda wanjh kabirrimoyhmang manbu manme manwern ba bu kunkodjke bokenh kabirringun. Wanjh kabirrikurrmekurrme bu kayingkihyo bedberre.” ");
INSERT INTO gup_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Wanjh Moses dja Aaron bindimarneyimeng birrimekbe bininj rowk nawu Israel benkebmawahmeng, “Bu karrungyibme bolkkime wolewoleh ngudda wanjh ngurriburrbun bu nungka Yawey wanjh nadjalkudji nawu ngunbebkeng ngudberre kore ngurrihbongdi kunred Egpyt. ");
INSERT INTO gup_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Dja mak bu malaywi, bu kukabel, ngudda wanjh ngurrinan Yawey nuye kunmakmak duninjh ba bu ngurriwohburrbun bu nungka ngurridjarrkdi. Dja nungka wanjh ngunbekkang ngudberre bu ngurrimarnewokkihnjurlukmi nuye. Ngad minj njale, bu kandihmarneyime ngarrewoneng, dja nakka wanjh nungka Yawey ngurrihmarneyimi.” ");
INSERT INTO gup_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Wanjh Moses yawoyhwokdi, yimeng bedberre, “Nawu Yawey nungan kakurduyime ngudberre, bu kunbarnangarrawern ngunwon ngudberre kunkanj bu wolewoleh ngurrikanjngunkenh, dja mak bu kunkabelwern nungka ngunwon manwern buriddi kore ngurridjare. Nungka ngunbekkang bu ngurrinjilngwarreni dja ngurrimarneyolyolmi nuye. Dja ngad wanjh nganeyeng! Minj ngudda ngandiyolyolmi, dja wanjh Yawey ngurrimarnewokkihnjurluhnjurlukmi.” ");
INSERT INTO gup_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kaluk Moses bimarneyimeng Aaron, “Yiray yibenkayhmen nawu Israel benkebmawahmeng rowk. Yibenmarneyimen bu kabirrimornnamerren kore kumirrk nuye Yawey, dja nungka wanjh benbekkang bu kabirriwokkihnjurluhnjurlukmi.” ");
INSERT INTO gup_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Bu kunmekbe Aaron wokdiwokdi bedberre nawu Israel benkebmawahmeng, wanjh bedda birribolknang kore kubolkdarleh. Dja birridjalnang bu kumbolkwolkkang wernkih duninjh manbu kunmakmak Yawey nuye bu bebmeng kore kunngol. ");
INSERT INTO gup_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Wanjh Yawey bimarneyimeng Moses, yimeng, “Ngaye ngabekkang bu baleh birrihyimi nawu Israel benkebmawahmeng bu ngaye ngandiyolyolmi. Dja yibenmarneyimen, ‘Bu kunbarnangarrawern kabalhdungyibme, ngudda wanjh ngurringun kunkanj, dja bu kunkabelwern ngudda wanjh buriddi ngurringun dja ngurriworrkmiworren. Kuhni wanjh ngurriwohburrbun bu ngaye Yawey nawu God ngudberre.’” ");
INSERT INTO gup_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Wanjh bu balkngokdangeni, mayhmayh nawu djirndi mirndewernminj bebmeng dja bolkbarrkbom kore kured birrihyoy, dja bu kumekbe kukabel wanjh kunberle kurrmeng kore birrihyoy kured. ");
INSERT INTO gup_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Wanjh bu manmekbe kunberle yakminj rowk, wanjh manme yoy, manbu manyahwuyahwurd, mankukbeleni manbu kukyimi ice. ");
INSERT INTO gup_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Bu kunmekbe birrinang nawu Israel benkebmawahmeng, wanjh birrimarneyimerrinj, “Kaluk mahni njale?” Dja minj bedda birriburrbuyi manmekbe manme. Wanjh Moses benmarneyimeng, “Mahni wanjh buriddi manbu Yawey ngunwong ngudberre ba ngurringun. ");
INSERT INTO gup_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Dja nungka Yawey ngunwokrayekwong ngudberre bu yimeng, ‘Ngudda wanjh ngurribebbehmoyhma manmekbe manme ngudberre. Ngurridjalmoyhma manbu namud ngudberre kabirriyakwon kore ngurribebbehyo. Ngurridjalmoyhma ba bu kabirribebbehngun rowk yiman kayime nakudji djabirlana kahdahkendi.’” ");
INSERT INTO gup_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Wanjh nawu Israel benkebmawahmeng kunmekbe birrikurduyimeng. Yikahwi bininj nawu birringorrmangi manwern, dja yikahwi nakka birrimangi mandjalyahwurd ");
INSERT INTO gup_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wanjh birrirohrokmeng. Dja bininj nawu mangimangi manwern, nakka wanjh birriyakwong rowk, mak nabuyika bininj nawu moyhmangi manyahwurd, bedda warridj birringuneng rowk. Dja nawu birrimekbe birrimoyhmangi bu birrirohrokmerreni birrimangi bu djal birringunikenh. ");
INSERT INTO gup_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Wanjh Moses benmarneyimeng, “Yuwn bu ngurrikarekurrme bu malaywikenh.” ");
INSERT INTO gup_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Dja yikahwi nawu minj birriwokmayi Moses bu benmarneyimeng dja bedda birridjalkarekurrmeng bu malamalaywihkenh. Wanjh bu kumbarrhbom, manme manbu birrikarekurrmeng wanjh makka warreminj dja yolk dundulubom. Wanjh Moses benduy birrimekbe bininj. ");
INSERT INTO gup_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Bu kunkabelwern bedda birridolkkani birrimoyhmangi manme manwern bu birrikurrmikurrmi, wanjh bu kunmekbe dungbidbuni, wanjh bolkrungi dja manbu manme djalyoy kurorre, wanjh makka kelkdangeni dja yakminj. ");
INSERT INTO gup_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Wanjh bu kunkodjke six nawu birrimekbe bininj birrimangi bu birrimngorrmangi bokenhkah, ba bu kabirribebbehngun yiman nakudji djabirlana birrikurrmi. Wanjh bininj nawu bindiwohrnani bedberre wanjh birriwam birrimarnemulewam Moses. ");
INSERT INTO gup_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Wanjh Moses yimeng bedberre, “Kuhni wanjh Yawey wokrayekwong ngudberre, yimeng, ‘Malaywi wanjh ngurringehmen, dja kunukka kunkodjke Sabbath manbu kunbarnangarradjamun ngardduk. Dja bolkkime ngurrikinjemen manbu ngurridjare ngurrikinje, dja warridj ngurrikarekurrmen yikahwi manme bu malaywikenh.’” ");
INSERT INTO gup_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Wanjh bedda birrikurrmekurrmeng bu malaywikenh, dja kaluk maninjmanu manme minj warremeninj dja yolk minj dundulubuyinj manmekbe manme. ");
INSERT INTO gup_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Wanjh bu kunbarnangarra Sabbath Moses benmarneyimeng, “Bolkkime wanjh ngurringu manme manbu ngurrihmoyhmangi wolewolekenh. Dja bolkkime wanjh kunkodjke manbu Sabbath nuye Yawey. Minj njale mak ngurringalke kurorre kore ngurrihmang manme. ");
INSERT INTO gup_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ngudda wanjh ngurrimoyhmang manbu manme bu kunkodjke six, dja bu manbuyika kunkodjkekudji, makka Sabbath, wanjh burrkyak. Minj manme kahyo.” ");
INSERT INTO gup_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kaluk bu yimerranj kunkodjke bu kunbidkudji dja bokenh, yikahwi nawu bininj birriwam yimankek birrimoyhmayi manme, dja larrk, birriyawam minj njale mak yuwirrinj kore kurorre. ");
INSERT INTO gup_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Wanjh nawu Yawey bimarneyimeng Moses, “Balehkah kabolkyime bu ngudda nawu bininj kandiwokmarrkmang bu wokrayekwon dja bengdayhke ngudberre? ");
INSERT INTO gup_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ngurrina, ngaye Yawey wong ngudberre manbu kunbarnangarra Sabbath. Kunmekbekenh kore kunkodjke six, wanjh ngaye won manme manwern, manbu bokenh kunkodjke ngurringun. Dja kore kunbarnangarra seven, wanjh ngudda ngurridjalnin rowk kore ngurrihni kured. Yuwn nangale kabalre kore kubuyika.” ");
INSERT INTO gup_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Wanjh bedda birringehmi kore kunbarnangarra seven. ");
INSERT INTO gup_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Wanjh bininj nawu Israel benkebmawahmeng birringeykurrmeng manmekbe manme “Manna.” Kaluk kukyimi manmim dja manyahwuyahwurd dja mak manbelebeleh kaluk manjyimi yiman kayime buriddi manbu mankung rawong dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kaluk Moses yimeng, “Nawu Yawey wokrayekwong dja yimeng, ‘Ngurrikarekurrmen yikahwi manmekbe manme bedberre nawu ngurrbenkebmawahme bu yerrekah. Ba kabirrinan manekke manme manbu ngaye wonihwoni ngurrihnguni kore kubolkdarleh bu bebkeng ngudberre kore Egypt ngurrihbongdi.’” ");
INSERT INTO gup_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Wanjh Moses bimarneyimeng Aaron, “Yima ngalng dja yirrahkendo manekke manme, yiman bokenh litres. Wanjh yikurrmen kore kumirrk nuye Yawey, dja kadjalyo bedberre nawu karrbenkebmawahme bininj.” ");
INSERT INTO gup_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kaluk yerrekah Aaron kurduyimeng bu Yawey biwokrayekwong nawu Moses. Nungka mey manbu manme dja dahkendoy kore ngalng, dja kurrmeng namekbe ngalng kore kumirrk ngarre manwarddebala bokenh manbu kawokbimbuyindi kore kunwok kunwoybuk kore Yawey wokkurrmerrinj, ba bu bininj kabirriburrbun kunwoybuk kunwok manbu Yawey wokdanj. ");
INSERT INTO gup_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Kaluk birrimekbe nawu Israel benkebmawahmeng birrihnguni manmekbe manme bu mandjewk 40 kaluk bu birribebmeng kore kunbolk Canaan, dja kumekbe birriyoy munguyh. ");
INSERT INTO gup_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Kaluk nawu birrirohrokmi manbu manna makka bu djal mandjad, scales dorrengh kore birrirohrokmeng bokenh litres, kore birriwarlahkenh bininj birrikurduyimi.) ");
INSERT INTO gup_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kaluk birridjalwern rowk nawu Israel benkebmawahmeng birribolkbawong kumekbe kubolkdarleh kabolkngeyyo Sin dja birrirengehrey kore nawu Yawey benwokrayekwong. Dja birrihdjalwohyoy waken kore kubolkbubuyika. Wanjh birribebmeng bu birriyonginj kore kunred Rephidim, dja minj kukku boyuwirrinj kumekbe bu bedda birrihbonguyinj. ");
INSERT INTO gup_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Wanjh kunu birridangwerrinj Moses dja birrimarneyimeng, “Ngarridjare kukku ngarribongun, dja kanbowo!” Wanjh Moses yimeng bedberre, “Njalekenh ngaye bu ngaye kandidung? Dja njalekenh nungka Yawey kumekbe ngurrirohrokme?” ");
INSERT INTO gup_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kaluk bedda birriwernhkombukdoweng bu birridjaldjareni kukku birribonguyi, wanjh bedda birriyolyolmi Moses bu birriyimeng, “Njalekenh ngudda kanbebkeng ngadberre kore Egyptbeh? Yiddok kanbebkeng dja kankang ngad, dja mak wurdwurd dja mayh ngadberre dorrengh ba bu ngarridjaldowe kondah kore kukkuyak?” ");
INSERT INTO gup_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Wanjh Moses bikayhmeng nawu Yawey, bu bidjawam, “Kab, baleh ngakurduyime bedberre? Wanjh darnkih bu ngandikodjdong kunwardde ngandikukkurrme.” ");
INSERT INTO gup_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Wanjh nawu Yawey bimarneyimeng Moses, “Yiray yirrokdokmen bedberre bininj, dja yibenka yikahwi nawu kabindihmarnewohrnan nawu Israel benkebmawahmeng, birrimekbe ngurridjarrkray. Dja mak yirrulkkanaka kubid ke manekke kundulk manbu yibowidjbihkeng Mankabo Nile. Dja wanjh yiray! ");
INSERT INTO gup_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kaluk ngaye ngarri kumekbe kore kumirrk ke, ngarri darnkih kore kuwardde ngarre kore kunred Horeb. Wanjh yiwarddedong kundulkwi manbu yihkarrme, kaluk kukku kambobebme kore kuwarddebeh ba kabirribongun birrimekbe bininj.” Moses wanjh kuninjkunu kurduyimeng dja bedda nawu dabborrabbolk nawu kabindimarnewohrnan nawu Israel benkebmawahmeng nakka wanjh birrihdi birrihkurdunani Moses. ");
INSERT INTO gup_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kaluk Moses kunmekbe bolkngeykurrmeng kunngey bokenh, Massah dja mak Meribah. Kaluk Meribah kamenyime, “birrirohrokmeng” dja mak manngeybuyika Massah wanjh kamenyime, “birridangwerrinj.” Kuhni bu bedda nawu Israel benkebmawahmeng birridangwerreni, dja birrirohrokmeng bu birrikewkmi nawu Yawey, bu birriyimeng, “Yiddok woybukkih nawu Yawey ngarrihdjarrkdi?” ");
INSERT INTO gup_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Kaluk kumekbe Rephidim bininj nawu Amalek benkebmawahmeng birrimwam bindibuni nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Wanjh Moses bimarneyimeng Joshua, “Yibendjarrngbu yikahwi bininj kadberre dja ngurrire ngurriburren birrimekbe bininj nawu Amalek benkebmawahmeng. Dja bu malaywi ngaye ngabidbun ngarrangen kore mandulum dja ngarrulkkan kore kubid ngardduk mahni kundulk manbu God nuye.” ");
INSERT INTO gup_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joshua biwokmarrkmey Moses wanjh nungka dja bininj nawu benkang wanjh birriwam birriburreni nawu Amalek benkebmawahmeng. Wanjh bedman Moses, Aaron dja Hur birriwam birribidbom kore mandulum. ");
INSERT INTO gup_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kaluk bu Moses berlwayhmi kaddum, wanjh nakka nawu Israel benkebmawahmeng birriwinhmi, dja bu nungka berlkolungi wanjh nakka Amalek benkebmawahmeng birriwinhmi. ");
INSERT INTO gup_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Wanjh bu Moses djalberlwayhmi kunkuyeng, nungka berlwarremeni, wanjh benemekbe Aaron dja Hur benekurrmeng kunwardde kanjdji nuye, ba kabirayekwon bu kayerrkan. Wanjh Aaron dja Hur beneberlmey Moses beneberlwayhkeng kaddum kaluk benebebbehdi dja Moses kuburldjarn di berrewoneng. Kaluk bedda benehdjalberlkarrmeng ba minj beneberlbarlanhmayi. Wanjh kunmekbe birrikurduyimeng bu kalukburrk, wanjh dungyibmeng. ");
INSERT INTO gup_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Wanjh kunu Joshua dja bininj nuye, bindibom mandjawak dorrengh birrimirndewern djamun nawu Amalek benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kaluk nawu Yawey bimarneyimeng Moses, “Yibimbu kore djurra bu kuninjkunukenh birriburrinj ba bu bininj kabirriburrbun munguyh. Dja yibengdayhkemen nawu Joshua bu yibimbunkenh. Dja wanjh ngabenngeybularrbun nawu birrimekbe Amalek benkebmawahmeng bu ngabenkukyakwon kore kondanjkunu kurorre.” ");
INSERT INTO gup_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Wanjh Moses marnbom manbu altar dja kumekbe bolkngeykurrmeng, “Yawey, nungka yiman kayime ngardduk kunmadj nawu banner.” ");
INSERT INTO gup_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Moses yimeng, “Ngaye ngabidwayhmeng kaddum kore Yawey kahni dja kawohrnan rowk. Nungka Yawey kaluk kabenbun bininj nawu Amalek kabenkebmawahme bu munguyh dja munguyh.” ");
INSERT INTO gup_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Bininj nawu ngeyyoy Jethro wanjh birroybom Moses, dja nungka wanjh priestni kore kunbolk Midian. Kaluk Jethro wobekkang rowk bu baleh benmarnekurduyimerranj Moses dja mak bininj nawu Israel benkebmawahmeng kore Yawey benbebkeng kore kunbolk Egyptbeh birrihbongdi. ");
INSERT INTO gup_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","Wanjh Moses nuye ngalbininjkobeng ngeyyoy Zipporah, dja benbeneyawmey narahrangem bokenh. Kaluk nawu nawernwarre nakka wanjh ngeyyoy Gershom, dja kunmekbe bu danginj, Moses yimeng, “Ngaye wanjh ngadjalwokbuyika bu ngamwam kore kubolkbuyikabeh.” Dja nawu nawalawalak, nakka wanjh bingeykurrmeng Eliezer. Kaluk bu danginj, Moses yimeng, “Nawu God nuye ngardduk ngabbard, nungka wanjh nganbidyikarrmeng. Nungka nganngehkeng kore king nawu kawohrnan kunbolk Egypt bu djareni nganbuyi.” Wanjh Moses benmunkeweng Zipporah dja nawu wurdwurd bu birriwam kore Jethro, nawu birroybom Moses. Wanjh Jethro benkimey kore nuye. ");
INSERT INTO gup_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Kaluk Jethro nawu Moses birroybom, benkang Moses nuye ngalbininjkobeng Zipporah dja nayayaw ngalengngarre, wanjh birriyikang Moses. Kaluk nungka Moses yongohyoy kore kubolkdarleh darnkih kore kuwarddekimuk manbu God nuye. ");
INSERT INTO gup_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kaluk nungka Jethro djalyingkihwokmunkewerrinj werrk kore Moses bu yimeng, “Ngaye Jethro, nawu doybom ngudda, wanjh ngarrimhre kore ngudda, ngalbininjkobeng dja narahrangem ngarre, nawu benbeneyawmey.” ");
INSERT INTO gup_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Wanjh Moses wam birrabkeng nawu birroybom dja kumekbe bimarnebarddurrukkurlhdanj, bibunjhmey dja benedjawarrinj bu kamak rowk bedda bu benebebbehdi, wanjh benewam benengimeng kore Moses nuye dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Kaluk Moses bimarneyolyolmeng Jethro njalehnjale kore Yawey benbom benkukyakwong rowk bedberre nawu king Egyptbeh dja mak nuye bininj. Dja mak nungka benbidyikarrmeng nawu Israel benkebmawahmeng. Dja mak Moses bimarneyolyolmeng bu birrihrey kunrayek dorrengh, kore kubolkdarleh kore kukku birriboyawani dja manme birriyawani, wanjh nungka Yawey bendjalngehkeng. ");
INSERT INTO gup_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Bu kunmekbe Jethro bekkang rowk, nungka wanjh njilngmakminj bu Yawey nungka kunmak kurduyimeng bedberre nawu Israel benkebmawahmeng dja benbebkeng kore kubid bedberre bininj nawu birrikang Egypt kore bindibongkarrmi. ");
INSERT INTO gup_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Wanjh nungka yimeng, “Ngaburlume nawu Yawey! Nungka ngunngehkeng kore kubid bedberre Pharaoh dja bininj nawu Egyptbeh. Dja mak benngehkeng rowk bininj nawu Israel benkebmawahmeng kore kubid bedberre bininj nawu Egyptbeh! ");
INSERT INTO gup_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Dja wanjh bolkkime ngawohburrbun bu nungka Yawey wernhdulkarrekimuk duninjh, dja kabenyurrhke birribuyika nawu gods. Kunmekbe nungka kurduyimeng bedberre bininj nawu birridjalburlumerrinj, kore bindinjirrhmiwoni nawu Israel benkebmawahmeng.” ");
INSERT INTO gup_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Wanjh Jethro, nawu Moses birroybom, kumkang mayh bu kukwurlhkeng nuye God, dja mak nabubuyika bu bimarnekurrmeng kore God. Aaron dja nawu bindimarnewohrnani bininj nawu Israel benkebmawahmeng, birrimyikang Moses nuye nabininjdoy ba birridjarrknguni manme manbu mandjamun kore God. ");
INSERT INTO gup_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Wanjh bu kunkodjkebuyika Moses yerrkang kore bendjadmeng bininj nawu birridangwerreni, dja kabenmarneyime bu nangale nakka kakarrme mandjad, dja nangale kadjare kunwarre. Wanjh bedda birriwakbuyinguneng Moses bu birrimadbuni kunbarnangarrakuyeng, kore kumkabelbeh dja kaluk kangokdan. ");
INSERT INTO gup_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Bu kunmekbe Moses nuye nabininjdoy binang nawu Moses bu karrehkarremarnbuni bedberre, wanjh bidjawam, “Njale ngudda yibenmarnekurduyime bedberre birriwern bininj? Dja njalekenh ngudda yidjalkudji yiyerrkan dja yibendjaddjadme bedberre, dja bedda wanjh djal kabirrimadburren kukabel nawu kukak kayimerran!” ");
INSERT INTO gup_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Wanjh Moses bimarneyimeng, “Kunukka wanjh kabirrimre kore ngaye bu kabirridjare ngaye ngabenbengdayhke kore God kadjare kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bu birrimekbe bininj kabirridangerren, bedda kabirrimre kore ngaye wanjh ngaye ngakarremarnbun bedberre baleh nawu kunmak kayime. Dja ngaye ngakarreyolyolme bedberre manbu God nuye mankarre, dja mak manbu kabenbengdayhke.” ");
INSERT INTO gup_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Wanjh Moses nuye bindoy bimarneyimeng, “Ngudda minj yikurduyime mandjad. ");
INSERT INTO gup_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ngudda dja birrimekbe bininj nawu ngundihyikan wanjh nakka ngurringudjwarremen. Dja kuhni kundjalkimuk bu yihdurrkmirri, dja yuwn bu kunukka yikurduyime yidjalkudji. ");
INSERT INTO gup_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Mah. Dja ngaye kanbekkabekka bu marneyime, dja ngaye ngadjare God bu ngunedjarrkdi. Wanjh ngunewokdi God bedberre birrimekbe bininj dja yibenmulewa bu yimarneyime nawu God kore bedda kabirridangwerrenkenh. ");
INSERT INTO gup_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Wardi yibengdayhkemen bedberre mankarre dja mak manbu God kabenbukkabukkan, dja yibenbukkabukka kore mandjad kabirrini dja baleh bu kunmak kabirrikurduyime.” ");
INSERT INTO gup_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","“Wanjh yibendjarrngbu yikahwi bininj nawu birrikurdumak kore nawu birriwern Israel benkebmawahmeng kabirrihdi, ngurridjaldjarrngbun bininj nawu kabirrikengeme God dja mak nawu kabindidjalwirrihme birribuyika bininj nawu kabirrikurren dja nawu birridedjwarlah. Yibenbebkemen birrimekbe bininj nawu yibendjarrngbun, dja yibenkurrme ba bu kabindinahnan nakka wanjh kabindilarlmang birriwern bininj rowk bu kabindibebbehnahnan. Yikahwi kabindimarnewohrnan kore one thousand bininj, yikahwi bu kabindimarnewohrnan one hundred bininj, dja mak yikahwi nawu kabindimarnewohrnan kore fifty bininj, yikahwi bu kabindimarnewohrnan kore ten. ");
INSERT INTO gup_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Yibenmarnbu birrimekbe birrimak bininj bu munguyh kabindidjadme kore bininj kabirridurrenkenh. Dja bininj rowk wanjh kabirrimkan manbu mankarrekilehkilelkkenh dja kabindidjadme kamak rowk. Dja wardi bu mankarredulmukkenh kabenmarnebebme, wanjh birrimka kore ngudda bu yibendjadmekenh. Bu kuhni kabirriyime, nakka nawu yibendjarrngbun bininj, wanjh ngundingehke, dja minj yiyawoyhngorrkan manbu mandulmuk duninjh. Bedda warridj wanjh ngurridjarrkngorrkan. ");
INSERT INTO gup_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Dja bu kuhni yikurduyime kore God ngunwokwon, wanjh kunukka yidjalkurduyime kore yihdurrkmirri, dja minj yingudjyawarren. Wanjh nawu birriwern bininj nakka wanjh kabirridokmerren kured bu kabirrinjilngmak.” Kuhni rowk nawu Jethro bimarneyimeng Moses. ");
INSERT INTO gup_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Wanjh Moses bibekkang bu nabininjdoy nuye bimarneyimeng, wanjh nunganwali kurduyimeng rowk. ");
INSERT INTO gup_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nungka bendjarrngbom yikahwi bininj nawu birrikurdumak kore bininj nawu Israel benkebmawahmeng birridjarrkdi, dja benmarnbom bu kabindimarnewohrnan bininj nawu birrimirndebuyika yiman thousands, dja mak hundreds dja mak fifties dja mak nawu tens. ");
INSERT INTO gup_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Bedda wanjh munguyh bindidjadmeng, dja bu kunrayek benmarnebebmeng, wanjh birriwam birridjawam Moses bu mankarrekenh. Manbu mankilehkilelk, wanjh bedman birridjalyolyolmi dja birribebbehdjadmi. ");
INSERT INTO gup_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kaluk Moses bimunkeweng nuye nabininjdoy Jethro bu wanjh wam durndi kore nuye kunred. ");
INSERT INTO gup_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Wanjh bininj nawu Israel benkebmawahmeng birribolkbawong Rephidim, bedda wanjh birriwam birribebmeng kore kubolkdarleh kabolkngeyyo Sinai. Kaluk bedda birribolkmarnbom, birrihyoy kore kubolkdarleh darnkih kore kuwarddekimuk Sinai. Bu kunmekbe bolkyimi dird danjbik bu yerre birribolkbawong Egypt. ");
INSERT INTO gup_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Wanjh nungka Moses bidbom kore kuwarddekimuk biyikang God. Wanjh Yawey bikayhmeng Moses kore kuwarddekimukbeh dja bimarneyimeng, “Yibenmarneyimen kuhni bedberre nawu Jacob nuye bininj, bedda nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Yiyimen, ‘Ngurridjalwern ngurrinang bu baleh ngaye ngakurduyimeng bedberre bininj nawu kabirrihni Egypt. Dja ngudda ngurriburrbun bu ngaye bebkeng ngudberre yiman kayime namarddorl kawayhke yaw ngalengngarre, dja mak kang ngudberre kondanjkunu kore ngaye. ");
INSERT INTO gup_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Mah. Bu ngudda munguyh kandiwokmarrkmang dja ngurrikarrme kunwok ngardduk rowk kore ngurrikurduyime bu ngaye ngadjare, wanjh kunukka ngurriyimerran bu djal ngardduk bininj nawu ngaye marnedjare dja menemey ngudberre ngurridjalkudji kore kubolkbubuyika kondah kurorre. Nawu birriwarlahkenh bininj rowk kore kondah kurorre, wanjh nakka ngabenkarrme. ");
INSERT INTO gup_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Dja ngudda wanjh ngurridjalkudji ngurriyimerran priests kore ngaye ngadjare, dja mak ngurriyimerran rowk bu ngurridjalkukdjamun duninjh ngardduk.’ Wanjh kuninjkunu kunwok ngudda yibenmarneyimen nawu Israel benkebmawahmeng.” ");
INSERT INTO gup_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Wanjh Moses kumkoluy kore Yawey benehwokdi dja benkayhmeng dabborrabbolk nawu bindimarnewohni bedberre bininj rowk. Moses kumekbe benmarneyolyolmeng kore Yawey biwokrayekwong bu kabenmarneyime. ");
INSERT INTO gup_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wanjh birriwern rowk nawu bininj birriyimeng, “Kore Yawey yimeng rowk, ngad wanjh kundjalmekbe ngarrkurduyime.” Wanjh Moses durndi kore Yawey balhkani kunwok bedberre nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yawey bimarneyimeng Moses, “Ngaye ngamre yikan ngudda kungolbulerri dorrengh ngabarrkburren, dja bu ngawokdangen, wanjh birrimekbe nawu Israel benkebmawahmeng kaluk nganbekkan wanjh munguyh ngundiwoybukwon ngudda.” Wanjh Moses bimarneyolyolmeng Yawey bu baleh bedda birriyingkihyimeng nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Wanjh Yawey bimarneyimeng Moses, “Yiray kore birrimekbe bininj dja yibenbengdayhkemen bu kabirrimarnburren yiman birridjamun bininj ngardduk, bu bolkkime dja mak malaywi. Yibenmarnbu warridj bu kabirriyingkihmadjdjirridjbun ngayekenh. ");
INSERT INTO gup_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Dja ngurriyingkihdin ngardduk bu danjbikkah malaywibuyikakenh. Bu kunmekbe kunbarnangarra ngaye nawu Yawey wanjh ngamkolung kore Kuwarddekimuk Sinai, dja ngandinan birriwern bininj nawu kumekbe kabirrihni. ");
INSERT INTO gup_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Dja yibolkmarnbu bedberre dja mak nawu mayh bedberre ba minj kabirrire kumekbe darnkih kore kunwarddekimuk Sinai. Yibenmarneyimen, ‘Yuwn bu ngurriwarddebidbun dja mak minj ngurriwarddekarrme kondah kanjdji ngarre. Bininj nawu kawarddekarrme nakka wanjh karrowen. ");
INSERT INTO gup_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Bininj nawu kawarddekarrme, wanjh minj nangale kare darnkih bu kabikarrme kubid dorrengh. Nakka wanjh birrikodjdo kunwarddewi, dja nuk bunarra birridulubu. Bininj dja nuk mayh bu kawarddekarrme, kunukka yuwn kahdjaldarrkiddi.’ Kaluk yerre bu trumpet kakayhme, kunmekbe wanjh kabirrire rowk darnkih kore kuwarddekimuk kanjdji ngarre.” ");
INSERT INTO gup_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Wanjh kunmekbe nungka Moses yawoyhkoluy kuwarddebeh kabenyikan nawu kurorre kabirrihdi, dja wanjh benyingkihmarnbom kore Yawey. Dja bedda birrimadjdjirridjbom kunmadj bedberre. ");
INSERT INTO gup_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Wanjh Moses benmarneyimeng, “Ngurriyingkihmarnburrimen bu kunkodjke danjbik. Dja mak yuwn ngurrikalikarren bu kunmekbe kabolkyimerran.” ");
INSERT INTO gup_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kaluk yerrekah bu kunkak bokenh, bu kumkabel kumwan, wanjh namarrkon bebmeng, mayhkemayhkeyi dja ngurduldulmeng. Dja kunngolburlerri dorrengh bebmeng kore kaddum kuwarddekodj. Dja mak birribekkang trumpet wokdanginj wernkih duninjh bu kayhmeng. Wanjh birriwern rowk bininj nawu birrihmirnderri wanjh birrikukdeldelmi kunkele dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Wanjh Moses wam benkimey birrimekbe nawu Israel benkebmawahmeng kuberrkkah kore birrihni, ba kabirrimirrkmarren God. Wanjh birrimirndedanginj kore darnkih kuwarddekimuk kanjdji ngarre, dja birrimadbom nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Kaluk manmekbe kunwarddekimuk Sinai warddebarrkbuyindi kundolng dorrengh, dja Yawey kumkoluy kumekbe kunak dorrengh. Manmekbe kundolng makka wanjh dolngwam kaddum yiman kayime bu karriwurlhke kunak manbirlukimuk duninjh. Dja mak manbu kuwarddekimuk bolkrokarokani wernkih duninjh. ");
INSERT INTO gup_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Dja manbu trumpet kayhmikayhmi dja wernhwokdarrahmeng. Wanjh Moses wokdanj, dja God biwokmey bu wokdanginj kore ngurdurdulmeng birribekkang. ");
INSERT INTO gup_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Wanjh bu nungka Yawey kumkoluy kore kuwarddekodj Sinai, dja bikayhmeng Moses bu kabalbidbun kore kaddum kuwarddekimuk. Wanjh Moses wam, bidbom. ");
INSERT INTO gup_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Wanjh nungka Yawey bimarneyimeng Moses, “Yiray, yikolu kurorre dja yibenbengdayhkemen birrimekbe bininj bu minj kabirridjirrkkarren dja kabirrikukmurrmiwerren, dja wardi kabirrimelme kore ngurrbenmarnebolkmarnbom, bu yimankek kabirridjare ngandikuknan ngaye. Bu kumekbe kabirrikurduyime nakka wanjh birridjalwern bu kabirridowen. ");
INSERT INTO gup_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Dja mak nawu priests, bu kabirrimre kore ngaye nakka wanjh kabirriyingkihmarnburren kore ngayekenh. Dja bu minj kabirrimarnburren kore ngaye nawu Yawey, wanjh ngaye ngabenbun.” ");
INSERT INTO gup_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Nungka Moses wanjh bimarneyimeng Yawey, “Birrimekbe bininj minj kabirrimbidbun manbu kunwarddekimuk Sinai, dja nakka wanjh ngudda kanmarneyimeng ngadberre, ‘Ngurribolkmarnbu ba minj kabirrire kore darnkih kahwarddekimuk, dja nakka wanjh kadjalbolkdjamun.’” ");
INSERT INTO gup_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Wanjh Yawey bimarneyimeng Moses, “Yirrurnde yimkimang Aaron ngunemdjarrkbidbu, dja yuwn nawu priests dja nawu birribuyika bininj kabirridjirrkkarren bu yimankek kabirrimbidbun kore ngaye. Dja bu kabirrikurduyime, wanjh ngaye Yawey ngabenbun.” ");
INSERT INTO gup_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Wanjh Moses koluy kore bininj birrimirnderri, dja benmarnemulewam kore baleh Yawey bibengdayhkeng. ");
INSERT INTO gup_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","God wokdanj, kunih kunwok rowk nungan yimeng, ");
INSERT INTO gup_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ngaye wanjh Yawey nawu God ngudberre, nawu bebkeng ngudberre kore kunbolk Egyptbeh, kore ngurrbenhmarnedurrkmirri nawu ngundihbongkarrmi. ");
INSERT INTO gup_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Yuwn bu ngurrbenwohkadjung nabubuyika nawu gods, dja ngaye ngadjalkudji duninjh God ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Yuwn bu ngurrimarnbun ngudberre yehyeng nawu idols, yiman kabenekukrohrok njalehnjale nawu kaddumwaken, mak kanjdjibeh kondah kurorrewaken, mak kukkuwaken kayo kore kaborri kanjdji. ");
INSERT INTO gup_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Yuwn bu ngurrimarneboddan nawu idols mak yuwn bu ngurriburluburlume nawu idols. Dja ngaye Yawey nawu God ngudberre, wanjh ngakirnwern. Kunmekbekenh kunu ngaye kaluk ngabendung bininj nawu ngandiwidnan ngardduk, dja bu bedberre mawahmawah bedmanwali ngandiwidnan, wanjh bedda warridj ngabendung. ");
INSERT INTO gup_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Dja ngaleng, ngaye munguyh ngabendjalmarnedjare duninjh birrimirndewern bininj dja nawu mawahmawah bedberre bu ngandimarnedjare dja kabirriwokmarrkmang manbu mankarre ngardduk. Kuhni ngakurduyime munguyh munguyh.” ");
INSERT INTO gup_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Yuwn bu kandingeywarrewon ngaye. Dja ngaye, Yawey nawu God ngudberre. Minj ngayime namak bininj nawu kunmekbe kayime ngardduk.” ");
INSERT INTO gup_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Ngudda munguyh ngurriburrbu kunbarnangarra manbu Sabbath, dja munguyh ngurridjalmarnbun maninjmanu kunbarnangarradjamun bu djal ngaye ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Dja bu six kunbarnangarra wanjh ngurridurrkmirrin dja ngurriyakwo rowk kore ngurrikarrme bu ngurrikurduyime, ");
INSERT INTO gup_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","dja kunbarnangarra seven, mahni wanjh Sabbath ngardduk, ngaye Yawey nawu God ngudberre. Kunukka wanjh ngurridjalngehmen, dja yuwn ngurridurrkmirri, ngayime ngudda, dja wurdwurd ngudberre, dja mak bininj dja daluk nawu ngundihmarnedurrkmirri, dja mak mayh ngudberre, dja mak bininj nawu kubolkbubuyikabeh ngurriwohyo kore kunred ngudberre. Yuwn nangale karrurrkmirri bu kunbarnangarra Sabbath. ");
INSERT INTO gup_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Dja ngaye wanjh Yawey ngabolkmarnbom kaddum dja kurorre, dja mak kurrula, dja mak yehyeng rowk ngamarnbom nawu kurorrewaken, dja mak kungolwaken dja mak kukkuwaken. Bu ngarrurrkmirranj six kunbarnangarra. Kaluk bu kunbarnangarra manbu seven, kunukka wanjh ngangehmeng. Kunmekbekenh kunu ngaye Yawey ngamarneyime kunmekbe Sabbath kunbarnangarra seven wanjh ngayimeng bu kunbarnangarramak, dja ngamarnbom kunbarnangarradjamun ngardduk.” ");
INSERT INTO gup_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Ngurrbenbenebekka dja ngurrbenbenenahna kornkornkumo nawu ngudberre, dja ngalbabadjan ngudberre, ba bu kunkuyeng ngurridjaldarrkiddi kore kunred ngaye bolkwon ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Yuwn nangale ngurribun ngurrikukkurrme. ");
INSERT INTO gup_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Yuwn nangale bininj kabiwohkodjekmang daluk ngalbu minj ngalbininjkobeng duninjh nuye, dja yuwn bu daluk kabiwohkodjekmang nawu bininj minj nabininjkobeng duninjh ngalengngarre. ");
INSERT INTO gup_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Yuwn njale ngurridjirdmang. ");
INSERT INTO gup_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Yuwn ngurrikurren bu ngurrimulewan nabuyika. ");
INSERT INTO gup_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Yuwn ngurriwurrmang nawu birribuyika kunrurrk bedberre, dja yuwn bu mak ngurrbenwurrmang ngalbibininjkobeng bedberre ngalbu kabindibebbehkarrme, dja yuwn bu mak ngurrbenwurrmang bininj dja daluk nawu kabindihmarnedurrkmirri, dja mak nawu mayh bedberre dja mak yehyeng rowk nawu birribuyika bedberre, yuwn ngurriwurrmang.” ");
INSERT INTO gup_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Bu bininj nawu Israel benkebmawahmeng kunmekbe birribekkang ngurdulmeng dja trumpet kayhmeng, dja mak birrinang bu mayhmayhkeyi, dja mak kundolng wayhmiwayhmi kore kuwarddekimukbeh, bedda wanjh birrikeleminj duninjh bu birrideldelmeng. Wanjh djarrehkah birridanginj dja minj birrimdarnhderrehmeninj kore darnkih kunwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kaluk bedda birrimarneyimeng Moses, “Djal yingan ngudda yiwokdin ngadberre ba ngad wanjh ngundibekkan. Dja yuwn bu nungan God kawokdi ngadberre, dja kunukka ngarridowen.” ");
INSERT INTO gup_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Wanjh Moses benmarneyimeng bedberre, “Yuwn bu ngurrikele. Dja nungka God kumwam bu ngunrohrokme ngudberre. Nungka kadjare ngudberre bu ngurrikengeme munguyh nuye, ba kunukka minj ngurriwokburriwe nuye.” ");
INSERT INTO gup_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Wanjh bedda djarreh birridanginj minj birridarnhderrehmeninj kore darnkih kunwardde, dja nungka Moses wam darnkih kore kunngolburlerri kore God kumkoluy ningihni. ");
INSERT INTO gup_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Wanjh nawu Yawey bibengdayhkeng Moses, yimeng, “Kuhni yibenmarneyimen nahni bininj nawu Israel benkebmawahmeng, ‘Nguddabidju ngurrinang bu ngaye ngawokdanj kore ngudda bu ngawokdanginj kore kaddum heavenbeh. Kuhni wanjh marneyimeng, ");
INSERT INTO gup_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","“Yuwn ngurrihmarneboddan nabubuyika gods yerrih, dja ngaye ngadjalkudji kanmarneboddan. Yuwn bu ngurrihmarnbun gold dja silver ba bu kakukyimerran yiman god nayahwurd kore ngurridjare. ” ’ ");
INSERT INTO gup_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","‘Dja ngaleng ngurrimarnbu altar manbu kunkulk dorrengh ngardduk, ba mayh kandimarnebun ngardduk yiman nawu sheep dja nanikud dja bulikki. Yikahwi ngurriwurlhke ba kukmokenh karung, dja mak yikahwi ngurridjalkanjkinje ba bu ngurridjarrkngun kunmodmikenh dorrengh ngayekenh. Wanjh ngamre marnekurduyime kunmak ngudberre bu baleh kabolkyime ngadjare bu bininj ngandingeyburlume. ");
INSERT INTO gup_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Bu ngurrimang kunwardde bu ngurrimarnbun altar ngardduk, yuwn bu ngurrimarnbun tools dorrengh bu ngurridadjdadjke kunwardde kore baleh ngurrikukmarnbun. Wanjh kunukka ngurriwarrewon dja minj mandjamun ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Dja yuwn bu bininj kabidbun steps kore altar ngardduk, wardi birribuyika bininj kabirrinan kore dedjlarrk kanjdji kunmadj, dja kawarre.’” ");
INSERT INTO gup_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Wanjh Yawey bimarneyimeng Moses, “Mahni mankarre makka wanjh yibenkarrewon nawu Israel benkebmawahmeng. Ngurrbenmarneyimen, ");
INSERT INTO gup_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘Bu yikukbayahme nawu Hebrew bininj, kaluk nawu ngunmarnedurrkmirri, wanjh nakka nanu kahdjaldurrkmirri ke bu kunbidkudji dja nakudji mandjewk. Dja bu kabolkyimerran seven mandjewk, wanjh ngudda yimunkewemen namekbe bininj bu kare. Nungka minj njale mak ngunkarremulewan. ");
INSERT INTO gup_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Dja bu namekbe bininj minj bikarrmeninj ngalbininjkobeng bu dedjingmang ngunmarnedurrkmirri, nakka wanjh ngunbawon kadjalre dalukyak. Dja bu yiman bikarrmeng ngalbininjkobeng bu dedjingmang ngunmarnedurrkmirri, wanjh nakka ngalbininjkobeng dorrengh kabenedjarrkre bu nungka ngunbawon. ");
INSERT INTO gup_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nawu kabimarnewohrnan bininj nawu kabihdurrkmirri nuye wanjh kabiwon daluk kabenemarren, dja ngalbu daluk ngalka wanjh kabenyawmang narahrangem dja ngaldahdaluk, wanjh ngalmekbe daluk dja nawu ngalengngarre wurdwurd nakka wanjh kabirridi munguyh kore namekbe nawu kawohrnan. Dja bu kabimunkewe namekbe nawu kabihdurrkmirri nuye kare, wanjh nadjalkudji kare, kabenbawon ngalbininjkobeng dja nawu wurdwurd.’ ");
INSERT INTO gup_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","‘Dja nawu kabihmarnedurrkmirri kayime, “Ngaye ngamarnedjare nawu ngahmarnedurrkmirri, dja mak ngabenmarnedjare ngalbininjkobeng ngardduk dja mak wurdwurd ngardduk. Wanjh ngaye ngadjare ngahdi munguyh, dja minj ngare.” ");
INSERT INTO gup_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Wanjh nawu kawohrnan bininj kabikan namekbe nawu kabihmarnedurrkmirri kore nawu kabindidjadme. Dja yerre kabiname kore door kundulk dja kabikanemdulubun wirlmurrng dorrengh. Wanjh kunmekbe kakurduyimerran nuye bu kabidjalmarnedurrkmirri munguyh dja munguyh.’ ");
INSERT INTO gup_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","‘Bu bininj kabikukweykan ngalbeywurd nuye ba kabongdi dja kabimarnedurrkmirri nabuyika bininj, wanjh minj nawu namekbe kabimarnewohrnan kabibawon kare. Minj karohrok yiman narahrangem bu kabirridurrkmirri. ");
INSERT INTO gup_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Dja bu nawu kawohrnan kabikukbayahme ngalmekbe daluk bu kabimarnedurrkmirri bu kunmekbekenh kadjare kabenemarren, dja kamayaliborledme dja minj kabimarnedjare, wanjh nungka bidurndiwemen nawu kornkumo bu kabikukbayahme. Mak yuwn bu nawu kabimarnewohrnan kabikukweykan ngalmekbe daluk kore nawu birriwokbuyika bininj. Dja nungka minj kunmak bimarnekurduyimeninj ngalmekbe daluk.’ ");
INSERT INTO gup_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","‘Dja bu bininj kabikukbayahme daluk ngalbu kabihmarnedurrkmirri dja kabiwon ngahli daluk ba kabenemarren nuye nabeywurd, wanjh kabimarnbun ngalmekbe daluk yiman ngalbeywurd nuye rerrih.’ ");
INSERT INTO gup_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","‘Dja bu bininj kabimang ngalbuyika daluk bu kayimerran ngalkerrnge ngalbininjkobeng, wanjh kunukka minj kabidenghke ngalbu ngalyungkih bu kangun manme, dja bu kunmadj kadjongbuyindi dja bu kabeneyo nahni bininj. ");
INSERT INTO gup_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Bu maninjmanu danjbik nungka bininj minj kabiwon, wanjh kunukka nahni bininj wanjh bibawo ngalmekbe daluk bu kare, dja minj ngalka kunwardde kabikarremulewan warridj.’” ");
INSERT INTO gup_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Dja Moses yimeng bedberre kore Yawey biwokwong bedberre, yimeng, “Nangale nawu bininj kabibun nabuyika bininj bu kabibun kabikukkurrme wanjh nungka ngurribu nunganwali karrowen. ");
INSERT INTO gup_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Dja bu namekbe bininj kabibun nabuyika bininj bu djal mungu, wanjh kunukka God kadjalbawon bu kunmekbe kadjalkurduyimerran, wanjh kamak bu namekbe bininj kelerlobmen kore kunbolk ngabolkmarnbun. ");
INSERT INTO gup_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Dja bininj nawu kakarremarnburren dja kabibun kabikukkurrme nabuyika bininj, wanjh nakka nanu nunganwali ngurribu bu karrowen. Mak bu yiman kahdi kawernhkarrme kore altar ngardduk wanjh ngurridjalyerrkkemen ngurrika kubolkbuyika dja ngurribu karrowen.” ");
INSERT INTO gup_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Nangale nawu kabibun nuye kornkumo dja nuk ngalbadjan nuye wanjh nakka ngurribu ba karrowen. ");
INSERT INTO gup_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Dja mak nangale nawu kabidjirdmang nabuyika bininj dja kabikukweykan dja yiman mak kabihdjalkarrme bu ngurridarrkidmang, wanjh nakka ngurribu, ngurrikukkurrme. ");
INSERT INTO gup_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Nangale nawu kunwarre kayime berrewoneng kornkumo dja ngalbadjan bu kadjare kabenedowe, wanjh nakka ngurribu, karrowen.” ");
INSERT INTO gup_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Bu bininj bokenh kabenedangwerren, wardi nakudji kabikodjdong nabuyika kunwardde dja yika kunbid nuye kabirrong, dja kabimarnbun kakanjbabang dja minj kabibulkkidjmang dja wanjh nakka nanu kahdjalyo dja minj mak kabalwohre. ");
INSERT INTO gup_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Dja kaluk namekbe bininj nawu kanjbabangni, bu karrolkkan kawohrewohre kurobbe, kunkarndudj dorrengh, wanjh namekbe nawu bikodjdoy nakka nanu minj ngurriwelengname. Dja nakka bikarremulewa nawu bikodjdoy, dja mak bibidyikarrmen bu kabinahnan kaluk bu rerrikah nawu karrulkkihni kamakmen dja kayawoyhdurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Dja bininj nawu kabenkarrme bininj dja daluk nawu kabirrimarnedurrkmirri, dja bu kabibun daluk yika mak bininj nawu kabihmarnedurrkmirri kundulk dorrengh, wanjh kunubewu nawu kabihmarnedurrkmirri karrowen kundjalmekbe rerrih. Bu kuhni kakurduyimerran, wanjh nahni bininj nunganwali ngurridong. ");
INSERT INTO gup_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Dja nawu kahdurrkmirri karrulkkihni bu kunkodjke nakudji yika bokenh, dja kamakmen, karrolkkan, wanjh nawu kabihmarnewohrnan nakka minj mak ngurribun. Dja bininj nawu kabimarnedurrkmirri wanjh nungan nuye.” ");
INSERT INTO gup_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Bu bininj bokenh yiman kabeneburren dja kabenebun ngalbu ngalmerlemyi kumekbe kahdi, dja kabenemarnbun wurdyaw ngarre kambebmen dja kabarrkendowen, wanjh kawarre. Dja bu minj benelorrkemeninj ngalmekbe daluk kore kunburrk ngarre, wanjh namekbe bininj nawu biwarrewong wanjh nakka karremulewa kunwardde bu baleh yarrkka ngalbu daluk ngalengngarre nabininjkobeng kadjare, bu nawu kabindidjadme bininj kabirribawon. ");
INSERT INTO gup_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Dja bu yiman kundjak kangalme kunkimuk duninjh ngalengngarre kunburrk, wanjh ngurribu namekbe bininj nawu biwarrewong. Kuhni wanjh mandjadkenh ngurrirohrokmen. Bu daluk karrowen, wanjh nawu biwarrewong warridj karrowen. ");
INSERT INTO gup_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ngurrikarremarnbu munguyh ba bu mandjaldjad. Bu bininj kawayhke yiman nakudji kunmim nabuyika nuye, wanjh nunganwali kakarremulewan nakudji kunmim nuye; bu kunyidmekudji kabimarnewarrhke, wanjh kakarremulwan kunyidmekudji nuye; bu kunbid karradjke, wanjh kunbid nuye kakarremulwan; bu kurrenge karradjke, wanjh kakarremulwan kurrenge. ");
INSERT INTO gup_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Bu kabikulahwurlhke, wanjh nunganwali kakarremulewan bu nungka kakulahrung. Dja bu kabilonbun, wanjh karohrok nunganwali kakarremulewan yiman kayime kamang kunlon.” ");
INSERT INTO gup_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Dja nawu bininj kabenkarrme nawu kabirrimarnedurrkmirri, dja bu kabirrong nuye bininj yika daluk nawu kabihmarnedurrkmirri dja kabimimdong, dja kamimwarremen, kaluk namekbe bininj wanjh bimunkewemen nawu kabihmarnedurrkmirri kare dja bikarremulewa kunmimenh. ");
INSERT INTO gup_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Dja bu kabirrong dja kabiyidmebakke dja kabiyidmewarrhke namekbe nawu kore kabihmarnedurrkmirri yiman daluk yika bininj, wanjh namekbe bininj nawu kawohrnan bimunkewemen kare dja bikarremulewa kore biyidmewarrhkengkenh.” ");
INSERT INTO gup_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Yiman bu kayime nawu bininj nuye bulikki kabibun bininj yika daluk, wanjh ngurribu namekbe bulikki bu ngurrikodjdong kunwardde dja ngudda mak yuwn ngurringun namekbe bulikki. Dja bininj nawu bulikki nuyeni nakka wanjh minj ngurriwelengname. ");
INSERT INTO gup_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Dja bu namekbe bulikki kerrngehkenhni benhbuyi birriwern bininj kunmarddorr dorrengh, dja bu bininj nawu karrmi wanjh birriyingkihbengdayhkeng dja minj dangbalhmeninj nawu bulikki, wanjh kunbuyika. Dja kuhni bu kabibun bininj dja yika daluk, wanjh ngurribu namekbe bulikki kunwardde dorrengh, dja mak bininj nawu mayh nuye wanjh nungan warridj ngurribu. ");
INSERT INTO gup_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Dja bu namud nuye bininj nawu bulikki biwarrewong kabirridjare namekbe bininj bu kabenkarremulewan, wanjh bonj, nakka ngurridarrkidbawon bu nungka kabenkukwon money kore kabirridjare. ");
INSERT INTO gup_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Mahni mankarre wanjh kayolyolme warridj kore bulikki yimankek kabibun wurdyaw. ");
INSERT INTO gup_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Dja bu bulikki kabenbun bininj dja daluk nawu kabirrimarnedurrkmirri nabuyika bininj, wanjh nungka nawu bulikki nuye, wanjh kabikukwon nakimuk djilba nawu money, yiman 30 shekels, dja namekbe bulikki wanjh ngurridjaldo ba karrowen.” ");
INSERT INTO gup_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Wardi bu bininj kabolkkarung kudjorlok, dja nuk minj kadjorlokbarrkbun bu kunmakkenh, kunubewu mayh kamre kamankan kore kudjorlok, dja karrowen, yiman bulikki dja nuk donkey. ");
INSERT INTO gup_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Bu kuhni kayimerran, wanjh bininj nawu minj djorlokbarrkbuyinj, wanjh kabikarremulewan bininj nawu karrmi mayh nawu mankang. Dja bininj nawu djorlokbawong, wanjh kakukkarrme mayh nawu doweng.” ");
INSERT INTO gup_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Bu bininj bokenh kabenebebbehkarrme bulikki bokenh, dja nakudji wanjh kabibun nabuyika bull bu karrowen, wanjh nahni bininj bokenh kabenekukwalaybun mayh nawu doweng, dja mak kabeneweykan nawu karrarrkid mayh, dja kabenekukwalaybun nawu money. ");
INSERT INTO gup_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Dja mak nawu bininj nuye bulikki bu kunyungkihni benhbuni birribuyika mayh dja nawu nuye bulikki minj dangbalhmeninj, wanjh bikarremulewa bu yiman kabiwon bulikki nakerrnge. Dja bulikki nawu doweng, nakka wanjh nunganwali kakukmang bu kayimerran nuyekih.” ");
INSERT INTO gup_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Wanjh Moses benyawoyhbengdayhkeng, bu yimeng, “Bu bininj kadjirdmang bulikki yika sheep dja mak kabun dja nuk kakukweykan, wanjh kunukka kabikarremulewan kunbidkudji bulikki kore bininj nuyeni nawu bulikki, dja kabikarremulewan kunkarrngbakmeng nawu sheep kore bininj nawu sheep nuyeni.” ");
INSERT INTO gup_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Kaluk nawu dedjorlkwern bininj bu karurrkbakke kururrk ba bu kadjirdmang njalenjale bu kukak, dja bininj nawu kunrurrk nuye kabidarrkidmang dja kabibun, dja mak bu namekbe dedjorlkwern karrowen, wanjh bininj nawu bibom minj kawowarre kore kunkurlba nuye nawu dedjorlkwern. ");
INSERT INTO gup_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Dja ngaleng, bu kuhni kakurduyime yerrekah bu kumbarrhbom, dja bu kabibun namekbe dedjorlkwern bininj kore kunbarnangarra, wanjh kunbuyika, dja kunwarre kurduyimeng bu bikurlbawarrhkeng nawu dedjdjolkwern. Bininj nawu dedjorlkwern wanjh kakarremulewan bu kadjirdmang njalehnjale, dja kabikukwon bininj nawu nuye kunmadj djirdmey. Kaluk bu nahni nawu dedjorlkwern minj njale mak kakukkarrme nawu nuyekihniwirrinj, wanjh kunukka nungka ngurrikukweyka yiman kayime slave ba kakarremulewarren nawu kore benhmarnedjirdmangi.” ");
INSERT INTO gup_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Bu nangale bininj nawu dedjorlkwern kadjirdmang mayh yiman kayime bulikki, dja nuk donkey dja yika nawu sheep, dja bu birribuyika bininj kabirringalke bu kadjalkarrme mayh nawu kadjaldarrkid, wanjh nakka kabikarremulewan bininj nawu nuye mayh bu bokenhkah kore mayh nakudji.” ");
INSERT INTO gup_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Dja bininj nawu yiman kabawon bulikki nuye yika djarrang dja mak sheep nuye bu kare karralkngun kore manme karrudjindi, dja yika kore manrakel kahdi, dja bu namekbe bininj kabawon mayh nuye kaballe kore nabuyika bininj nuye kunbolk kore kabaldalkngun, wanjh namekbe bininj nawu mayh nuye kabikarremulewan nabuyika bininj nawu manme dja kundalk bimarneyakwong.” ");
INSERT INTO gup_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kab bininj nawu yiman kawurlhke kunak, dja manmekbe kunak kabirluwarlahmen kore kundalk manmirrhyi, dja kabalbirluwarlahmen kore kabbal nuye nawu bininj nabuyika dja kabalrung nuye manme manbu dudjehdudjengi, wanjh namekbe bininj nawu wurlhkeng kunak, wanjh kabikarremulewan nabuyika bininj nawu kore manme nuye bimarneruy.” ");
INSERT INTO gup_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Bininj nawu kabikukwon money dja nabubuyika namakmak kunmadj kore namekbe nabadbuyika bininj bu kabimarnekarrme nuye, dja mak bu dedjorlkwern kangimen kumekbe kunrurrk dja kadjirdmang namekbe money dja namekbe kunmadj, dja bu bininj kabirridarrkidmang nawu dedjorlkwern bininj, wanjh nakka kabikarremulewan bokenhbokenh nawu kore djirdmey. ");
INSERT INTO gup_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Dja bu bininj minj kabirringalke nawu dedjorlkwern, wanjh namekbe nawu kunrurrk nuye ngurrika kore nawu kabirridjadmekenh bininj, ba bu kabirribekkarren dja kabirriyime bu kunubewu nungandeleng djirdmayi njalehnjale nawu nabuyika nuye.” ");
INSERT INTO gup_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Bu yiman bininj bokenh kabeneyidangwerren nawu njale yarrkka yiman kayime donkey, sheep, bulikki, kunmadj dja njalenjale nawu warrhkerrinj, mak bu bedda kabenebebbehyime, ‘Nahni ngardduk!’ dja yiman kabenewelengnamerren, wanjh benemekbe bokenh bininj beneray kore bininj nawu kabindidjadmekenh. Wanjh namekbe bininj nawu kabirriyime bu kawowarre, wanjh kabikarremulewan bokenhbokenh nawu namekbe beneredbo bininj.” ");
INSERT INTO gup_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Kunmekbe rerrih mak bu bininj yiman kabidjawan nawu nuye nguneredbo bu kabimarnenahnan nawu donkey, bulikki sheep dja mak nabubuyika mayh, wanjh bu yiman namekbe mayh karrowen dja yika kalonburren, dja yika dedjorlkwern kadjirdmang nawu mayh, dja minj nangale kaburrbun kore baleh wam namekbe mayh. ");
INSERT INTO gup_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Wanjh bu nahni bininj bokenh kabenedangwerren namekbe mayhkenh, wanjh namekbe bininj nawu bimarnenahnayi nahni mayh wanjh wokkurrmerrimen kore kumirrk nuye Yawey. Bu kamulewarren bu minj bikilekmeninj namekbe mayh, wanjh nabuyika bininj nawu nuyekih mayh biwokmarrkma namekbe bininj dja minj kabikewkme, dja bininj nawu yimankek bimarnenahnayi mayh wanjh minj kabikarremulewan. ");
INSERT INTO gup_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Dja bu namekbe mayh nawu woybukkih birridjirdmey bu nahni bininj nahnayi, wanjh nakka bikarremulewa bininj nawu mayh nuye. ");
INSERT INTO gup_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Dja bu yiman nabang mayh kamre kabun nawu mayh bu kumekbe bininj kanahnan, dja wanjh kakanjdadjdadjke, wanjh kakukmang kakukkan kabenkukbukkan birriwern bu woybukkih bibom nabang mayh, wanjh kunukka kabirriburrbun ba namekbe bininj minj kabikarremulewan nabuyika nawu mayh nuye.” ");
INSERT INTO gup_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Mak bininj nawu kabibidyikarrme mayh nawu nabuyika bininj nuye, wanjh namekbe mayh kamankan bu karradbakme mak yika bu karrowen, dja bu bininj nawu mayh nuye minj kumekbe karri, wanjh bininj nawu karrmi mahni mayh bu kurduyimerranj, mayh nakka nanu bikarremulewa namekbe nawu nuye mayhkenh. ");
INSERT INTO gup_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Dja ngaleng bu bininj nawu nuyekih mayh karranhmadbun nuye mayh bu kuhni kakurduyimerran, wanjh nabuyika bininj nawu bidjawam bihbidyikarrme wanjh minj kabikarremulewan. Bu yiman namekbe mayh kabibidyikarrme bu moneykenh, wanjh kunukka money nawu ngokko bikukwong, wanjh kakarremulewayindan kabarrkbun nawu kore mayhkenh karrowen nawu bihbidyikarrmi.” ");
INSERT INTO gup_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Wanjh Moses benyawoyhbengdayhkeng, yimeng, “Yiman bininj kabingalke daluk ngalbu minj bininj birriberrebbuyi dja mak minj bininj benebangmeyuwirrinj, dja bu kabikowe bu kabimang kabeneyo ngalmekbe daluk, wanjh kunukka kabenbenekarremulewan ngalbadjan dja kornkumo bu kabenemarrenkenh, dja nungka bikarrmen ngalmekbe daluk bu kabimarnbun ngalbininjkobeng nuye. ");
INSERT INTO gup_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Dja bu kornkumo ngalengngarre daluk kabidahme namekbe bininj minj kadjare kabimang ngalbeywurd nuye, wanjh namekbe bininj bidjalkukwo karohrok money bu kabikarremulewan kabenemarrenkenh ngalengngarre daluk ngalbu minj bininj beneyuwirrinj.” ");
INSERT INTO gup_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Ngalngale daluk ngalbu kahkurduyime kunwarre yiman kayime murnde kamang dja marrkidjbu kamarnburren, wanjh ngurribu, ngurrikukkurrmen.” ");
INSERT INTO gup_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ngurribu ngurrikukkurrmen nangale bininj nawu yiman kayime kunwarrekenh kabeneyo nawu mayh.” ");
INSERT INTO gup_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Dja mak ngurribu nangale bininj yika daluk nawu mayh kabiwon dja kamarnebun nuye nawu nabuyika god. Yawey nakka nadjalkudji God duninjh kadberre.” ");
INSERT INTO gup_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Yuwn bu ngurrbenwarrewon nawu birriwokbuyika bininj. Ngurriburrbun ngudda wanjh ngurriwokbuyikani bu ngurrihni Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Dja yuwn bu mak ngurrimarnedjirdmang ngalengngarre ngalbu kamarrdjukun dja mak nawu ngalbadjanyak dja kore kornkumoyak. ");
INSERT INTO gup_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Bu kunmekbe ngurrikurduyime bedberre dja bedda kabirrikayhme Yawey ba bu kabenbidyikarrmekenh, wanjh woybukkih, nungka kabenbekkabekkan. ");
INSERT INTO gup_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Dja Yawey kayiddung ngudberre dja kunukka bun ngudberre dja ngurridowen mandjawakwi. Wanjh nawu ngalbibininjkobeng ngudberre nakka wanjh kabirriyimerran kamahkamarrdjukun dja wurdwurd ngudberre nawu ngurrbenbornang nakka wanjh birrimarladj kabirridi.” ");
INSERT INTO gup_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Bu ngurrbenkukwon waken kunwardde bininj nawu Yawey nuye, nawu minj njale kabirrikukkarrme, yuwn bu ngurrikurduyime yiman nawu kunwardde kabenhwonowon ba bininj kunwernkenh kabirrikukdurndiwe. Yuwn bu ngurrbendjanwohme bu kunwern kunwardde ngundimarnekukdurndiwe. ");
INSERT INTO gup_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Dja bu yikukwon waken nawu nguneredbo ba bu yibidyikarrme, dja nungka ngunwon nuye kunmadj bu yikarrme kore kunwardde ngunkukdurndiwekenh, wanjh nahni kunmadj yiwo kunbarnangarra rowk bu darnkih kabaldungyibme ba bu kakakdjongbuyindi. ");
INSERT INTO gup_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Dja wanjh nakka nadjalmekbe nakudji kunmadj nawu kadjongbuyindi bu kahkukbalhmerren ba bu kakodjkeyo kamak. Bu burrkyak, dja kunu nungka kabikayhme Yawey bu kunmekbekenh, wanjh nungka kabibidyikarrme, dja nungka nawu mimkongiwern.” ");
INSERT INTO gup_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Yuwn bu ngurrimarneyime kunwarre God nuye, dja yuwn bu mak kunwok kunwarre ngurrimarneyime nuye nawu kawohrnan ngudberre bininj.” ");
INSERT INTO gup_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Yuwn bu mak ngurridahme nawu Yawey nuye manbu manmim dja yika mankalkkid ngurrimangi, dja yika wine ngurribomarnbom kore ngurriborrahkendoy kore ngalngkimuk ngudberre. Dja mak ngurriwo nabebeywurd ngudberre nawu kaluk nadjaman rowk. ");
INSERT INTO gup_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Karohrok yerrih bu ngurriwo bulikki dja sheep yayaw ngudberre nawu nadjaman rowk. Ngaleng ngurrbenbawon ba kabirrihni kore ngalbabadjan bu seven kunbarnangarra, dja kore kunkodjke eight, wanjh ngurriwo nawu Yawey.” ");
INSERT INTO gup_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Kaluk ngudda wanjh Yawey nuye bininj. Wanjh kunukka yuwn bu ngurringun kunkanj nawu nabang mayh kabun. Dja ngurrikanjburriwemen mahni kunkanj kore duruk kabirrikanjngun.” ");
INSERT INTO gup_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Moses benbukkabukkang manbu mankarrekenh Yawey nuye, yimeng, “Yuwn ngurrire ngurrihyolyolme bu ngurrbenkowe bininj. Yiman kayime bu ngurrire kore court, yuwn ngurribidyikarrme nawu nawarre bininj bu ngurrikurren kore court.” ");
INSERT INTO gup_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Dja mak yuwn bu ngurrbenngunjdjikan birriwern bininj kore kabirrikurduyime kunwarre. Dja yuwn mak ngurrbenngunjdjikan birriwern bininj nawu court kabirrire dja kabirridjalkurren ba bu kabirriwarrewon manbu mandjad mankarre. ");
INSERT INTO gup_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Bu bininj nawu namarladj kahre kore court, kunubewu ngurridjare ngurribidyikarrme, dja bonj, yuwn bu ngurrimarnewarrewon manbu mandjad mankarre nuye nahni nawu namarladj.” ");
INSERT INTO gup_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Bu ngurrinan mayh nawu bulikki yika donkey kabalhbengmayahme nuye nawu ngunehyidko, dja bonj, ngurriyikan nuye. ");
INSERT INTO gup_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Mak kunmekbe rerrih kayime nawu nguneyidko nuye djarrang bu kamankan kabibakke nawu dulmuk kunmadj kahngorrkan, wanjh yuwn mak ngurribawon bu ngurrire. Dja ngurribidyikarrmen nawu nguneyidko bu ngurriwayhke namekbe djarrang ba bu kamak karrangen.” ");
INSERT INTO gup_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Bu namaraldj bininj kare court, wanjh ngurrikarreyolyolmen bu djal mandjad nuye. Yuwn bu ngurriwarrewon nawu minj nakuken. ");
INSERT INTO gup_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Dja mak yuwn ngurrikurren bu ngurrimulewan bininj kore ngurriwiddjung nungka kore court. Ngurrimulewa bu djal mandjad. Dja bininj nawu minj kunwarre kurduyimeninj, dja yika bininj nawu kundjalwoybuk kawokdi, wanjh yuwn bu ngurribun. Dja nawu Yawey minj kabibawon nawu nawarre bininj bu kare.” ");
INSERT INTO gup_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Bu nawarre bininj kadjare ngunkukwon money ba bu ngurrikurren kore court, wanjh yuwn ngurrimang mahni kunwardde kore kamweykan. Namekbe kunwardde wanjh ngunmayaliwarremen ba bu minj ngurridjalburrbun bu mandjadkenh, dja kunukka ngurribalhwernhwarrewon bininj nawu minj kunwarre kurduyimeninj.” ");
INSERT INTO gup_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Yuwn bu ngurrbenwarrewon bininj nawu birrikang kubolkbuyika kore ngurrihni. Ngurriburrbu kunkareni bu ngurrihni Egypt, wanjh ngudda ngurriwokbuyika bedberre nawu birrikang Egypt.” ");
INSERT INTO gup_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Bu mandjewk kunbidkudji dja nakudji ngudda wanjh ngurridjaldudjeng manme kore kabbal ngudberre, dja bu kadjolengmen wanjh ngurrimoyhmang bu ngurringunkenh. ");
INSERT INTO gup_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Wanjh bu mandjewk nawu kayimerran kunbidkudji dja bokenh, wanjh nakka minj ngurribolkkarung dja minj mak kunmekbe ngurridudjeng manme. Dja bu manme kadjordmerren kumekbe, wanjh nakka ngurrbenwo birribuyika bininj nawu minj birrikuken, dja bu bedda kabirribawon yikahwi, wanjh ngurrbenwon mayh nawu kurralkwaken. Kunmekbe rerrih ngurrikurduyimen manbu grapes dja olives manbu kadjordmerren ngudberre kore mandjewk manbu Sabbath.” ");
INSERT INTO gup_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ngurridjaldurrkmirrin bu kunkodjke six, dja bu kayimerran kunkodjke seven, wanjh ngurringurdmen, dja kunukka ngurridjalngehmen. Kuhni mak kayimerran bedberre mayh dja bininj nawu kabirrihdurrkmirri ngudberre. Ngayime bulikki, mak donkeys, mak slaves nawu birridanginj kore ngudberre namud, dja mak nawu birridjenbubuyika ngurrihni. Bedda rowk wanjh minj kabirridurrkmirri kore manbu Sabbath ba bu kabirringehme.” ");
INSERT INTO gup_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Kab ngurrinahnarrimen dja ngurriburrbu rerrih bu ngurrikurduyime rowk kore Yawey ngunmarneyimeng ngudberre. Yuwn bu mak ngurrbenkayhme bu ngurrbenngeybun nabubuyika nawu gods. Namekbe nawu gods wanjh yuwn bu ngurringeybun, dja kunngey bedberre minj kambebme kurrangbeh ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Moses benmarneyimeng kore Yawey benwokrayekwong, yimeng, “Kuhni wanjh Yawey yimeng, ‘Bu mandjewkbubuyika rowk, wanjh ngurrikarrmen danjbikkah mulil bu ngaye kandimulilmang, dja kunmekbe ngurrikurduyimen munguyh.’ ");
INSERT INTO gup_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","‘Ngurrikarrmen mulil manbu buriddi minj kakarrme manguklurlmikenh. Mandjalmekbe ngurridjalngun bu kunkodjke rowk seven, kore wokrayekwong ngudberre bu ngurrihni kunbolk Egypt. Ngurrikarrmen mahni mulil kore kabolkyime dird Abib, dja kunmekbe dird bu ngurribebmeng kunbolk Egypt.’ ‘Minj nangale mak kambebme kumirrk ngardduk bu nungka djal bidlarrk. ");
INSERT INTO gup_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Kab ngurrikarrmen mulil ngarre manme manbu kore ngurrimang mandjoleng kore kabbal ngudberre ngurridudjengi, dja ngurridjalngu manbu manyungkih ngurrimang. Dja warridj ngurrikarrmen mulil manbuyika ngarre bu kahyiburnburn nawu mandjewkkudji kore ngurriyakwon bu ngurrimoyhmang rowk manme kore ngudberre kabbal.’ ");
INSERT INTO gup_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","‘Mandjewkbubuyika rowk wanjh kuhni bu ngurrikarrme maninjmanu danjbik mulil. Dja bu ngurrikarrme mulil, wanjh kuhni danjbikkah, wanjh bininj rowk ngudberre ngurrimray ba ngurribebmerren kore kunmirrk ngardduk. Ngaye wanjh Yawey nawu Ngahwohrnan Rowk.’ ");
INSERT INTO gup_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","‘Bu kandimarnekinje mayh nawu kandiwon ngaye, wanjh yuwn bu kunmekbe kandiwon buriddi warridj manbu kakarrme mannguklurlmikenh. Dja mak bu kandimarnekinje kore maninjmanu mulil, wanjh yuwn bu ngurrikarekurrme manbu mayh nuye kunbalem ba kayo bu kunkodjkekudji kukabelkenh ngurrikinje. ");
INSERT INTO gup_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Dja mandjewkbubuyika ngurrima manme manbu manyuhyungkih dja manmakkaykenh ngurrimang, dja ngurrimka kore kunrurrkdjamun ngardduk, ngaye Yawey wanjh God ngudberre.’ ‘Dja bu ngurrikinje nanikud yaw, wanjh yuwn bu ngurridjuhke ngurrikinje kore ngalbadjan ngarre kundjikkakenh.’” ");
INSERT INTO gup_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Moses benmarneyimeng kore nawu Yawey benbengdayhkeng, dja yimeng, “Nawu Yawey ngunmarneyime, ‘Yina! Ngaye wanjh ngamunkewe ngardduk angel bu karrokme ngudberre, nawu ba ngunnahnan kore ngurrirengehre. Kaluk ngunkanahkan ngudberre kore kunred ngaye ngayingkihbolkmarnbom ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ngurriwokbekkabekka dja ngurriwokmang kore baleh ngunmarneyime ngudberre. Yuwn bu ngurridahme. Kunukka minj ngunmarnebengmidjdan ngudberre bu ngurridahme, dja ngaye Yawey ngamunkeweng. ");
INSERT INTO gup_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Dja bu ngurribekkabekkan yeledj bu kayime ngudberre dja mak ngurrikurduyime bu ngaye wokraykewon ngudberre, wanjh kunukka ngabenbun nawu ngundiwidnan, dja ngabendahme bininj nawu ngundidahme.’ ");
INSERT INTO gup_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","‘Wanjh nawu angel ngardduk nungka karrokme ngudberre bu ngunkan kore kunredbubuyika kore kabirrihyo bininj kabirringeyo Amor, dja nawu Heth benkebmawahmeng, dja nawu kabirringeyyo Periz, dja nawu Canaan benkebmawahmeng, dja nawu kabirringeyyo Hiv, dja mak nawu birrikang kunred Jebus. Kaluk nakka ngaye ngabenbun ngabenkukyakwon rowk.’ ");
INSERT INTO gup_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","‘Yuwn bu ngurrimarneboddan dja ngurriburlume bedberre nawu nabubuyika gods. Yuwn bu mak ngurrikurduyime bu yiman bedda kabirrihkurduyime kore yiwarrudj bedberre. Dja ngaleng ngurribakbakkemen nawu idols bedberre, dja ngurribakkemen dja ngurriburriwe maninjmanu kunwarddekuyeng nawu bedda kabirridjabname kurorre dja kabirriyime yimankek kuwarddedjamun. ");
INSERT INTO gup_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ngaye wanjh Yawey ngudberre God. Bu ngudda kandimarnebarddurrukkurlhdan ngardduk ngadjalkudji, wanjh kunukka ngamarnekurduyime kunmak ngudberre manmekenh dja kukkukenh, dja ngaye wanjh kundjak ngawe ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mak morlehmorlenj ngudberre bu kabirriyawmang minj kayawdowen ngudberre. Dja mak won ngudberre kunngolekkuyeng ba kunkuyeng ngurridarrkiddi.’ ");
INSERT INTO gup_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","‘Dja bininj birriwern nawu ngundidung dja mak ngundinjirrhmiwon, nakka wanjh ngabenmarnbun bu ngaye wernkih ngandikengeme ngaye. Dja bininj nawu ngurrihburren, ngaye wanjh ngamayaliwarrewon. Dja nawu ngurriyidko bininj, wanjh ngabenmarnbun bu kabirriborledkerren dja kabirrikelerlobme ngundibawon ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ngaye ngabenmarnbun nawu ngurriyidko ba bu ngurriwinhme dja ngurrbenbun. Ngaye ngabenburriwe bininj nawu kabirringeyyo Hiv, dja bininj nawu Canaan benkebmawahmeng, dja nawu Heth benkebmawahmeng ba kabirribolhbawon manbolh ngudberre kore ngurrire ngurribolkmang. ");
INSERT INTO gup_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Dja ngaleng, minj ngabendjirrkkan birrimekbe bininj bu yiman kayime nakudji mandjewk. Dja yiman bu werrk ngabendjirrkkayi, wanjh kunukka kunred manbu kabolkdarlehme dja mayh nawu birribang kabirriwernmerren ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Dja ngaleng yeleyeledj ngabendjirrkkan ba kaluk ngurrimirndewernmen bu ngurribolkmang kumekbe kunred ngurrini.’ ");
INSERT INTO gup_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","‘Mahni kunred won ngudberre karredjingman kore Kurrula manbu Manborodjme dja kayiburnbun kore Kurrula Mankimuk. Dja mak karredjingmang kore kubolkdarleh, dja kabolkdadjme kore mankabo Euphrates. Dja won ngudberre kundulkarre ba ngurridjalle bu ngurribolkmang, dja ngurrbenburriwe birrimekbe bininj nawu kumekbe kunred kabirrihni. ");
INSERT INTO gup_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Yuwn bu ngurriwokmarnburren birrimekbe bininj dja mak minj ngurrbenyikadjung nawu gods bedberre. ");
INSERT INTO gup_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Yuwn bu mak ngurrbenbolkwon kunred ba bu ngurridjarrkni, dja wardi kunukka ngaye kandibengmidjan dja kunwarrehwarre ngundibalbukkan birrimekbe bininj bu ngundibukkan ngurriboddan bedda bedberre gods. Wanjh kunukka kadjalwarre bu ngudmandeleng ngurriwarreworren dja ngurridowen.’” ");
INSERT INTO gup_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Wanjh Yawey bimarneyimeng Moses, “Ngudda Moses, dja mak Aaron, Nadab, Abihu dja birribadbuyika 70 dabborrabbolk nawu birrikang Israel nuye mawahmawah, wanjh ngurrimray kore ngaye bu ngurribarddurrukkurlhdan ngardduk, kaluk djarrehbeh. ");
INSERT INTO gup_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Wanjh Moses nakudji bu darnkih kamderrehme ngardduk ngaye nawu Yawey; dja nawu birribuyika rowk, nakka yuwn kabirrimdarnhre. Dja mak nawu birrimirndebuyika bininj rowk, nakka wanjh minj kabirrimre kore kuwarddekimuk bu minj kabirrimdjarrkre Moses dorrengh.” ");
INSERT INTO gup_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses yolyolmeng bedberre bininj nawu Israel benbekmawahmeng, manbu kunwok rowk dja mankarre rowk nuye Yawey. Wanjh birrimirndewern birriwokmey birridjarrkyimeng, “Ngad wanjh ngarridjalkurduyime rowk kore Yawey yimeng.” ");
INSERT INTO gup_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Wanjh Moses biwokbihbimbom rowk kore Yawey yimeng. Kaluk bu djarreh kumhkabelni Moses dolkkang wanjh marnbom altar kore darnkih kuwarddekimuk kanjdjikah. Wanjh warddedjabnameng bebbehbeh twelve kunwarddewardde manbu menmenyimeng kunmokukurr kunbubuyika bedberre bininj nawu Israel benkebmawahmeng. Twelve kunwardde bebbehkadjurrinj twelve kunmokukurr. ");
INSERT INTO gup_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Wanjh Moses benmunkeweng yawuhyawurrinj bu mayh birrimarnemokenkinjeng nawu Yawey, dja mak birrimarnebom nuye bulikki yaw ba bu birridjarrknguni kore birrikarrmi kunmodmikenh nuye Yawey. ");
INSERT INTO gup_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses kurlbamey kunkurlba kore birribom nawu mayh, kurlbawarlaybom wanjh dahkendoy kore yikahwi bannikin, dja mak mey warlaybuyika kunkurlba dja djuhdjuhkeng kore altar. ");
INSERT INTO gup_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Wanjh mey namekbe djurra nawu kore wokbimbuyindi manbu Yawey benmarnewokkurrmerrinj. Wanjh benmarnebimngeybom bedberre nawu bininj rowk, ba bu birriwokbekkani. Wanjh bedda birriyimeng, “Ngad ngarridjalkurduyime rowk kore Yawey yimeng dja ngarridjalwokmarrkmang nungka.” ");
INSERT INTO gup_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Wanjh Moses ngalngmey bannikin nawu kunkurlba dahkendi wanjh kurlbaburriweng kore bininj nawu birrihdi, dja benmarneyimeng, “Mahni kunkurlba kamenmenyime manbu kore Yawey nungan wokkurrmerrinj ngudberre kore maninjmanu kunwok rowk nuye.” ");
INSERT INTO gup_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kaluk Moses, Aaron, Nadab, Abihu dja mak seventy bininj nawu dabborrabbolk birrihwohrnani bininj nawu Israel benkebmawahmeng, wanjh birriwam, birribidbom kore kuwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Wanjh birridarrkidnang God bedberre nawu Israel benkebmawahmeng. Nungka danginj kore manbolkbalabala manbu blue sapphire kukyimi yiman kunngol manbu djalblue medjyimi! ");
INSERT INTO gup_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Birrimekbe bininj nawu bindihwohrnani nawu Israel benkebmawahmeng birrinang God, dja nungka God minj benbuyi. Wanjh birringuneng manme dja mak birribonguneng kumekbe. ");
INSERT INTO gup_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Wanjh Yawey bimarneyimeng Moses, “Yimbidbu kondah kuwarddekimuk kore ngaye. Dja kumekbe yirrin, ba won manbalabala kunwardde manbu ngabimbom mankarre rowk ngardduk dja kunwok manbu ngabenwokrayekwon bedberre, ba bu yibenbukkabukkan nawu birrimekbe bininj.” ");
INSERT INTO gup_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Wanjh Moses dja Joshua, nawu bihmarnedurrkmirri dja bibidyikarrmi, benebidbom kore God nuye kuwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Dja Moses benyingkihmarneyimeng nawu dabborrabbolk, “Ngurridin kondah kandimadbu kaluk nganemdurndeng ngudberre. Nahni nawu Aaron dja mak Hur, nakka wanjh ngurridjarrkdi. Bu nangale bininj kabirridangwerren wanjh kabindidjawan nahni bininj bokenh ba kabindimarnekarremarnbun.” ");
INSERT INTO gup_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kaluk bu Moses wam warddebidbom kore kuwarddekimuk, kaluk mahni kunngol wanjh warddebarrkbom. ");
INSERT INTO gup_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Dja kunmakmak nuye Yawey kumkoluy kaddumbeh kore kuwarddekimuk Sinai, dja manbu kunngol dingihdi warddebarrkbom bu kunkodjke six. Wanjh bu kunkodjke balmarnburrinj seven, Yawey bikayhmeng Moses kore kunngolbeh. ");
INSERT INTO gup_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Bu nawu Israel benkebmawahmeng bininj, nakka bu birrinang manbu kunmakmak nuye Yawey, wanjh birriyimi kunak kunkimuk duninjh rungihrungi kaddum kore kuwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Wanjh Moses wam ngimeng kore kunngol, wanjh balwernhbidbom kaddum duninjh kore kuwarddekimuk. Kumekbe kunu nungka danginj bu kunkodjke forty kunkak dja kunbarnangarra. ");
INSERT INTO gup_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","2","Wanjh Yawey bimarneyimeng Moses, “Yibenmarneyimen nawu Israel benkebmawahmeng kabirrimkan ngandiwon ngardduk namakmak. Yimangamang ngardduk kore birribebbehkudjikudji bininj kabirridjare ngundiwon ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Nahni namekbe namakmak yimang bu ngundiwon yiman wirlmurrng manbu gold, dja mak silver, dja bronze. ");
INSERT INTO gup_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Dja warridj kunyarl manbu kukblue, dja kukpurple dja kukkurlba, dja mak manburrba linen namakmak dja nanikud kunngabek, ");
INSERT INTO gup_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","dja mak kabirrimkan ngardduk ngundiwon sheep narangem kunkulah nawu birrimedjmarnbom mankurlba, dja kunkulah ngarre marndingunjngunj dja mak kundulk manbu acacia. ");
INSERT INTO gup_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Ngundiwon mak kunkalkkid manbu oliveskenh ba ngurrikinjekenh kore lamps; dja mak manbu spices bu kabirrimarnbun mankalkkidmanjmak manbu kabindikodjdjuhkekenh bininj dja mak bu kabirrimarnbun manmanjmakkaykenh incense; ");
INSERT INTO gup_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","dja warridj ngundiwon manwarddemakmak manbu onyx, dja nabubuyika jewels nawu kabirrikurrme kore nawu ephod dja mak kore nawu nadjamunkenh kunmadj nawu kuberrekalk kabibalhme.” ");
INSERT INTO gup_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Dja yibenmarneyimen bu kabirrirurrkmarnbun ngardduk manbu manrurrkdjamun, dja ngaye wanjh ngamre ngarridjarrkni kore bedda. ");
INSERT INTO gup_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ngurrimarnbu manmekbe manrurrkdjamun kore bukkabukkan manbu kore ngurriyimowon ba kamak bu ngurrimarnbu rowk.” ");
INSERT INTO gup_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Wanjh Yawey biwokrayekwong Moses, yimeng, “Yibenmarneyimen nawu bininj, ‘Kuhni wanjh Yawey kanwokrayekwong kadberre bu yimeng, “Ngurrima manbu acacia kundulk ba ngurrimarnbun Ark. Bu kakuyeng wanjh nakka 110 centimetres dja bu kawarlahwarla wanjh nakka 110 centimetres, dja bu kaddum ngurrirohrokme nakka wanjh 70 centimetres. ");
INSERT INTO gup_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kaluk ngurridukka yiman ngurribaru kururrkbeh wirlmurrng gold duninjh kore kuberrkbeh dja mak kumelk ngarre Ark, dja mak ngurrikurrme nakuyeng wirlmurrng gold bu ngurriwakbuyingun kurrid ngarre kore kaddum. ");
INSERT INTO gup_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Dja mak ngurrimarnbu kunkarrngbakmeng wirlmurrng gold rings manbu ngarre Ark, dja ngurribelbmen kore kunkarrngbakmeng kundenge ngarre, kaluk bokenh rings kore kudjakku dja mak bokenh kore kukun. ");
INSERT INTO gup_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Dja mak ngurrimarnbu mandulkkuyeng bokenh manbu acacia kundulk, kaluk ngurribaru rowk manbu wirlmurrng gold. ");
INSERT INTO gup_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Wanjh manmekbe mandulkkuyeng ngurringimewo kore nawu rings kahdi kore kurrid ngarre Ark, ba kamak bu bininj kabirringorrkan manmekbe Ark. ");
INSERT INTO gup_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Manmekbe bokenh mandulkkuyeng wanjh ngurribawo, djaldin munguyh kore Ark. Dja yuwn bu ngurriwayhke.” ");
INSERT INTO gup_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“Yerre wanjh ngaye Yawey won manwarddebalabala bokenh manbu kabimbuyindi ngardduk kunwok kunwoybuk bu ngaye ngawokkurrmerrinj ngudberre. Wanjh ngurridahkendo kumelk ngarre Ark.” ’ ” ");
INSERT INTO gup_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Wanjh lid nawu kaddumkenh ngarre Ark ngurrimarnbu wirlmurrng gold duninjh. Kaluk nahni kakuyeng 110 centimetres, dja bu kawarlahwarla nakka wanjh 70 centimetres.” ");
INSERT INTO gup_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","“Dja mak ngurridongorro namekbe gold ba ngurrimarnbun nawu kakukyime Cherubim bokenh, wanjh ngurrbenbenekurrmen kurrid ngarre lid bu kabenebebbehdi. ");
INSERT INTO gup_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Kaluk benemekbe Cherubim benebebbehdin, nakudji kurridkudji din, dja mak nabuyika din kurridbuyika. Kaluk ngurrbenbenemarnbu bu kabenebelbmerren lid dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Namekbe bokenh Cherubim wanjh kunwel kabenewelwarlahmen kaddum, kaluk lid kabenebarrkbun, dja mak kabenemirrknarren kore kabenehbebbehdi dja kabenenan kanjdji kore lid kabenehdi.” ");
INSERT INTO gup_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“Wanjh ngurrikurrmen namekbe lid kaddum kore Ark, dja rerrih wanjh ngurridahkendong nahni manwarddebala bokenh nawu kaluk won, manbu kabimbuyindi kunwok kunwoybuk manbu ngawokkurrmerren ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Kaluk ngaye ngamre karrinarren kumekbe, kaddumkah kore lid dja kubulkayh kore cherubim bokenh kabenehdi kore Ark nawu kakarrme manwarddebalabala bokenh manbu kabimbuyindi ngardduk kunwok kunwoybuk kore ngawokkurrmerrinj ngudberre. Wanjh kumekbe kaluk won ngardduk mankarre rowk manbu ngudberre nawu Israel ngunkebmawahmeng.” Kuhni rowk Moses benbengdayhkeng kore Yawey bimarneyimeng. ");
INSERT INTO gup_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Wanjh Moses yawoyhwokdi bedberre yimeng, “Nawu Yawey nganmarneyimeng, ‘Yibenbengdayhkemen kore ngaye wokrayekwon ngudberre, dja yiyimen, “Ngurrimarnbu manbalabala table manbu acacia kundulk, kaluk bu kakuyeng 100 centimetres, dja bu kawarlahwarla kunukka 50 centimetres, dja mak bu kakuyeng bu kaddum ngurrirohrokme nakka wanjh 75 centimetres. ");
INSERT INTO gup_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Wanjh ngurribaru wirlmurrng gold duninjh kuberrkkah rowk ngarre, dja mak ngurrikurrme nakuyeng wirlmurrng gold kore kungorrk bu kawakbun kaddumkah ngarre. ");
INSERT INTO gup_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Dja mak ngurrimarnbu kundulkyahwurd manbu kabelbmiyindi kore table ngarre kurrihdirrid rowk kore kaddumkenh, kaluk eight centimetres bu kanjdji kore kaddum, dja mak ngurrikurrme nakuyeng wirlmurrng gold warridj kore maninjmanu kundulk. ");
INSERT INTO gup_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Wanjh ngurrimarnbun warridj kunkarrngbakmeng wirlmurrng gold rings dja kabirribelbme kore kunkarrngbakmeng kurrid ngarre table, kanjdji kore ngarre kahdaddi. ");
INSERT INTO gup_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ngurrima namekbe rings dja ngurrikurrmen kore darnkih kundulk nawu kahwakbuyingun kaddumkah kore table, ba kamak bu bininj kabirrikarrme manmekbe mandulkkuyeng manbu kabirringorrkankenh. ");
INSERT INTO gup_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kaluk manmekbe mandulkkuyeng bokenh wanjh ngurrimarnbun acacia kundulk, dja ngurribaru wirlmurrng gold duninjh. Kaluk bu bininj kabirringorrkan manbu table wanjh kabirrikarrme mahni mandulkkuyeng bokenh bu kabirriwayhke.” ");
INSERT INTO gup_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","“Yerre wanjh ngurrimarnbu wirlmurrng gold duninjh manbu yehyeng rowk ngarre manbu manbalabala, yiman plates dja bannikin, ngalng nawern nakka manbu winekenh ngurribodahkendong bu ngurribowon nawu Yawey kore ngurriboyakarrbun kumekbe.” ");
INSERT INTO gup_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","“Dja mak kumekbe kore manbalabala wanjh munguyh ngurrikurrmekurrmen manbu kandidjawa ba kabimulewan bu ngudda ngurrihdi kore ngaye ngardduk kubolkdjamun. Maninjmanu buriddi kadjaldi munguyh kore kumirrk ngardduk.” ’ ” Kuhni rowk wanjh Moses benbengdayhkeng kore Yawey bimarneyimeng. ");
INSERT INTO gup_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Wanjh Moses yawoyhwokdi bedberre yimeng, “Nawu Yawey nganmarneyimeng, ‘Yibenbengdayhkemen kore ngaye wokrayekwon ngudberre, dja yiyimen, “Ngurridongorro wirlmurrng gold duninjh ba bu ngurrimarnbun lampstand, manbu lamp kore ngurrihbarnname, wanjh ngurrirawon namekbe ngurribelebelbmen nawu cups kakukyime yiman mannguyyayaw dja mak mannguy duninjh. Wanjh ngurrimarnbu rowk ba bu djal nadjalburrkkudji. ");
INSERT INTO gup_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Manmekbe lampstand bu ngurrimarnbun kakarrme six manyende kaluk karringihdi kore kungorrk ngarre, yiman danjbik kore kurridkudji dja danjbik kore kurridbuyika. ");
INSERT INTO gup_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kaluk manbu manyendewern wanjh makka kabebbehkarrme danjbik cups kakukyime yiman mannguy ngarre almond mak kunmekbe kayime rerrih manbu five manyende kabebbehkarrme yiman kayime almond mannguy. Kaluk namekbe six cups makka kabebbehkarrme manbu kakukyime mannguy dja kunworr. Dja mak manbu six manyende manbu kahbebbehdi kore lampstand makka wanjh kadjalrohrok rowk. ");
INSERT INTO gup_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Dja mak ngurriyawoyhmarnbu kunkarrngbakmeng cups kakukyime yiman almond mannguy kabarndi kore lampstand. Wanjh kunmekbe rerrih karohrok nawu namekbe cups kabebbehkarrme mannguy dja kunworr. ");
INSERT INTO gup_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ngurrikurrmen manmekbe mannguy kanjdji kore kahbebbehyendi manbu kore kamhbelbmikenh kore lampstand. Wanjh manbu lampstand kore manmekbe six manyende kamhbelbmikenh wanjh makka karohrok rowk. ");
INSERT INTO gup_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Bu ngurrimarnbun mahni rowk, wanjh ngurridongorro nawu wirlmurrng gold duninjh, dja ngurrimarnmarnbu ba bu kaburrkkudjihmen rowk, yiman lampstand burrk ngarre, dja mak manyehyende, dja mak mannguyyawyaw.” ");
INSERT INTO gup_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Kaluk ngurrimarnbu seven lamps manbu kunkalkkid kahrungkenh, dja ngurribarnnamen kore maninjmanu lampstand ba kamak kabolkwolkan kore kumirrk ngarre. ");
INSERT INTO gup_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Manbu ngurrirradjke kunyarl manbu karung kaddum kore lamp, dja mak manbalabala nayahwurd nawu ngurrikurrme kanjdji kore lamps wanjh ngurrimarnbu rowk wirlmurrng gold duninjhwi. ");
INSERT INTO gup_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ngurrima 34 kilograms nawu gold ba ngurrimarnbun namekbe lampstand dja mak njalehnjale ngarre. ");
INSERT INTO gup_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Dja ngurrinahnarrimen bu ngurrimarnbun rowk kore ngamarneyimeng dja ngabukkang Moses kore kuwarddekimuk bu nganehwokdi.” ’ ” ");
INSERT INTO gup_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Wanjh Moses benmarneyimeng bininj nawu Israel benkebmawahmeng, yimeng, “Kuhni wanjh Yawey kanwokrayekwong kadberre bu yimeng, ‘Ngurrimarnbu Manrurrkdjamun Dabburlin ngardduk. Ngurrimadjmarnbun ten kunmadj bu kabarndi yiman kayime kawarnamyo nawu curtains. Ngurrbenkurrme bininj bu kabirrimadjmarnbun. Bedda birrima nawu linen manburrba namakmak dja kabirribibbun kunyarlwi manbu medjbuyika yiman kukblue, kukkurlba dja kukpurple. Dja mak ngurrima nawu bidmak bininj bu kabimbibbun bim nawu Cherubim kore manburrba rowk nawu curtains. ");
INSERT INTO gup_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kaluk namekbe manburrba kadjalrohrok rowk, 12 metres bu kakuyeng dja bokenh metres bu kawarlahwarla. ");
INSERT INTO gup_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Wanjh kunbidkudji manburrba ngurrirawon bu yibibbun ba kakukkudji bu kamokendi, mak kunmekbe rerrih ngurriyawoyhyimowon nawu nabadmirndebuyika manburrba ba ngurrimokenbibbun. ");
INSERT INTO gup_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","5","Wanjh ngurrimarnbun namekbe curtains ba bu kabelbmerren dja kakudjihmerren ba bu kawakbuyingun rowk kore Manrurrkdjamun Dabburlin. Namekbe nawu kunbidkudji manburrba ngurrimokennamen. Wanjh ngurrimarnbu fifty loops kukblue manburrbawi, kore kayiburnbun nawu manburrba dja mak nabadbuyika mokenh nawu nakka wanjh ngurriyawoyhkurrme fifty loops. Kaluk namekbe loops nakka wanjh yiman kabenemirrkmarren. ");
INSERT INTO gup_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Dja mak ngurrimarnbun fifty gold nginj ba ngurribelbme namekbe manburrba nawu kore bokenh wanjh kakudjimen.’ ");
INSERT INTO gup_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","‘Mak ngurriyawoyhmarnbun nabuyika dabburlin nawu kabarrkbun kore kaddum namekbe Manrurrkdjamun Dabburlin. Kaluk nahni wanjh ngurrimarnbu kunbid bokenh dja nakudji manburrba nawu curtains kore goat kunngabekwi. ");
INSERT INTO gup_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kaluk namekbe manburrba ngurrirohrokme bu karohrok rowk, 14 metres bu kakuyeng dja bokenh metres bu kawarlahwarla. ");
INSERT INTO gup_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Wanjh kunbidkudji manburrba ngurrirawo bu ngurribibbun ngurrimokenmarnbun. Yerre kunbidkudji dja nakudji nawu manburrba bu ngurrirawon yiman ngurriyimowong nawu nayungkih ngurrimarnbom. Wanjh ngurribakbakke nawu sixth manburrba bu ngurribokenhme kore kurrangmaye ngarre dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Mak ngurriyawoyhmarnbun fifty loops kore kurrid kayiburnbun nawu manburrba ngarre nakudji mokenh, mak kunmekbe ngurriyawoyhyimowon nawu nabubuyika. ");
INSERT INTO gup_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Wanjh yerre ngurrimarnbu fifty nginj nawu bronze wirlmurrng, nawu kahkardmang nawu loops. Wanjh ngurrikurrme kore loops ba kabelbmerren dja karaworren bu kadjalkudjihmerren namekbe dabburlin manbu kabarrkbunkenh. ");
INSERT INTO gup_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Dja mahni manburrba wanjh kayurrhke wurd nawu Manrurrkdjamun Dabburlin, dja ngurridjalbawon kawelhwelme kore borledmikkenh Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Wanjh kumekbe djal 50 centimetres kawelhwelme kore kungurrid ngarre manmekbe Manrurrkdjamun Dabburlin, ba bu yiman kakukbalhme bu kamak.’ ");
INSERT INTO gup_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","‘Dja mak ngurrimarnbun nabadbuyika kunmadj nawu ngarre Manrurrkdjamun Dabburlin ba bu karurrkbarrkbun. Kaluk nakka ngurrimarnbun kunkulahwi sheep ngarre medjmak kunrodjbe, wanjh ngurribalbarrkbun warridj nawu kunkulahwi marndingunjngunjbeh.’ ");
INSERT INTO gup_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","‘Ngurrima acacia kundulk ba ngurridjabdjabname mandulkdjad bu kakarrme manbu kawarnamyo ngarre Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kaluk nabebbehkudji nawu mandulkdjad wanjh nakka four metres bu kakuyeng dja 70 centimetres bu kawarlahwarla, ");
INSERT INTO gup_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","dja mandulkdjad nawu kadjabdi, wanjh kabebbehkarrme nawu kundadkenh ba kabebbehdi kore kurrid. Kunmekbe ngurriyimowo nawu nadjalwern kundulk frames bu ngurrimarnbun yiman kerrngehkenh ngurriyimowon. ");
INSERT INTO gup_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kaluk ngurrimarnbu twenty frames ngarre walemkah kore Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Namekbe nabebbehkudji nawu mandulkdjadkenh wanjh kakarrme bokenh wirlmurrng silver mandadkenh bu ngurrikurrme kanjdji, kundulkyahwurd yiman kayime kundad manbu ngurridjadnamen nawu mandulkdjad bokenh. ");
INSERT INTO gup_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Mak ngurriyawoyhmarnbu twenty mandulkdjadkenh ngarre kakbikah kore Manrurrkdjamun Dabburlin, ");
INSERT INTO gup_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","dja forty silver mandadkenh ngarre, bokenh ngarre kabebbehkudji nawu mandulkdjadkenh.’ ");
INSERT INTO gup_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","23","‘Ngurrimarnbu kunbidkudji dja nakudji namekbe mandulkdjadkenh ba kabibodmebarrkbun kaluk karrikadkah kore Manrurrkdjamun Dabburlin, dja mak bokenh ngarre kurrid kore kubodme. ");
INSERT INTO gup_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Wanjh namekbe nawu bokenh mandulkdjadkenh wanjh nakka bokenh ngurribelbmen wirlmurrng ring dorrengh, kore kanjdji dja mak kore kaddum. Namekbe bokenh mandulkdjadkenh nawu kahdi kore kurrid bokenh wanjh kunmekbe ngurriyimowo. ");
INSERT INTO gup_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Bu kumekbe karri kunbidkudji dja danjbik nawu mandulkdjadkenh kore kawarnamyo kubodme ngarre manbu Manrurrkdjamun Dabburlin, dja mak karringidi sixteen silver mandadkenh, yiman bokenh bokenh karri kore mandulkdjadkenh rowk.’ ");
INSERT INTO gup_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","‘Ngurrimarnbu mandulkkuyeng kore acacia kundulk ba ngurribelbme nawu mandulkdjadkenh kahdjabdjabdi kore kurrid ngarre Manrurrkdjamun Dabburlin. Wanjh ngurrimarnbu kunbidkudji ba kakarrme ngarre kurridkudji. ");
INSERT INTO gup_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Dja nabadbuyika kunbidkudji rerrih namekbe mandulkkuyeng ngurrimarnbun ba kakarrme mandulkdjadkenh kore kurridbuyika. Dja mak kunbidkudji ngurrimarnbun ngarre nawu mandulkdjadkenh kore karrikadkah kahdjabdi, kore kubodme duninjh ngarre Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Dja mak nawu mandulkkuyeng kahdi kore kubulkayh wanjh nakka ngurrikurrmen wohka din kore kundulk frames, ba kakadjung kore kurridkudji ngarre Manrurrkdjamun Dabburlin, kumirrk kore kubodme ngarre.’ ");
INSERT INTO gup_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","‘Mak ngurribaru gold wirlmurrng dorrengh nawu mandulkdjadkenh rowk, dja mak ngurrimarnbu rings kaluk gold wirlmurrng ngarre kurrid kore namekbe mandulkdjadkenh ba kakarrme nawu mandulkkuyeng, dja nakka warridj ngurribaru wirlmurrng goldwi.’ ");
INSERT INTO gup_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","‘Wanjh ngurridjabnamen manbu Manrurrkdjamun Dabburlin bu djal bulkkidj, kore ngaye Yawey ngayolyolmeng dja ngabukkang Moses kore kuwarddekimuk nganehwokdi.’ ");
INSERT INTO gup_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","‘Nahni mak ngurrimarnbu mankudji manbuyika curtain. Kaluk ngurrimang manburrba manbu namakmak linen, dja ngurribibbu kunyarl makka kukblue kamedjyime, dja mak kukpurple dja mak kukkurlba. Dja ngurrikurrmen bininj nawu kawernhburrbun bu kabimbibbun bim nawu Cherubim kore manburrba. ");
INSERT INTO gup_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Wanjh ngurriwelhwelkemen namekbe manburrba nawu wirlmurrng gold nginj dorrengh kore kunkarrngbakmeng mandulkdjad manbu acacia kundulk nawu ngurriyingkihbarung wirlmurrng gold dorrengh, dja ngurridjabnamen kore kunkarrngbakmeng wirlmurrng silver manbu mandadkenh ngarre. ");
INSERT INTO gup_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Dja ngurriwelhwelkemen namekbe manburrba kore nginj kaddum, dja ngurrikurrme namekbe Ark nawu kakarrme manwarddebalabala bokenh manbu kabimbuyindi ngardduk kunwok kunwoybuk kore ngawokkurrmerrinj ngudberre, dja ngurrikurrmen kore borledmikkenh nawu curtain. Nahni curtain nakka wanjh yiman kawarnamyo kubulkayh kore Kunbolk manbu Kubolkdjamun dja mak kore Kunbolk manbu Kuwernhbolkdjamun Duninjh. ");
INSERT INTO gup_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Wanjh ngurrikurrmen manbu lid ngarre Ark ba karrangbalhme, dja wanjh ngurribalkurrmen Ark kore Kunbolk manbu Kuwernhbolkdjamun Duninjh. ");
INSERT INTO gup_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Dja ngurrikurrmen manbu manbalabala kuberrkkah kore manburrba kahdi, kaluk kakbikah Manrurrkdjamun Dabburlin. Wanjh ngurrikurrmen nawu lampstand kaluk walemkah kore kubuldjarn ngarre table.’ ");
INSERT INTO gup_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","‘Kaluk ngurrimarnbu manburrba curtain nawu kurrangmaye ngarre kore Manrurrkdjamun Dabburlin. Bu ngurrimarnbun wanjh ngurrima nawu linen manburrba namakmak bu nawu bidmak bininj madjmarnbom, dja ngurribibbun kunyarlwi manbu medjbuyika yiman kukblue, kukkurlba dja kukpurple. ");
INSERT INTO gup_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Dja ngurrimarnbu nginj nawu wirlmurrng gold, dja mak kunbidkudji mandulkdjad kaluk acacia kundulk wanjh ngurribarung wirlmurrng gold dja ngurridjabname. Ngurriyawoyhmarnbun. Warridj kunbidkudji wirlmurrng bronze mandadkenh kore ngurridjabname.’ Kuhni rowk nawu Yawey kanwokrayekwong.” ");
INSERT INTO gup_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Wanjh Moses benmarneyimeng bininj nawu Israel benkebmawahmeng, yimeng, “Kuhni wanjh Yawey kanwokrayekwong kadberre bu yimeng, ‘Ngurrimarnbu manbu altar ngardduk. Makka acacia kundulk ngurrimang dja ngurrimarnbun 130 centimetres bu kaddum. Dja mak ngurrimarnbun square 230 centimetres bu kakuyeng dja mak 230 centimetres bu kawarlahwarla. ");
INSERT INTO gup_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Mak ngurrimarnbu four yiman kayime kunkanemdulk kahkanemdulkdarrnghme kabebbehdi kore kunkarrngbakmeng kurrid ngarre dja kabelbme rowk kore altar ba kakudjimen rowk altar dorrengh. Wanjh yerre ngurrikurrmekurrme wirlmurrng bronze kore kuberrkkah rowk ngarre namekbe altar.’ ");
INSERT INTO gup_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","‘Kaluk ngurrima wirlmurrng bronze dja ngurrimarnbu yehyeng nawu altar ngarre, yiman nawu djabirlana ngarre kunburlekenh dja kunbalem raworrinj, dja nawu shovels, bannikin dja forks nawu kunkanjkenh dja mak pans ngarre kunak ba kamak bininj kabirribirlukanakan. ");
INSERT INTO gup_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Dja mak ngurrimarnbu nakimukkenh wirlmurrng bronze screen ba kakarrme kore kunak karung, dja mak ngurrikurrmen kunkarrngbakmeng wirlmurrng bronze ring kore kurrid rowk manbu screen ngarre, ba bu bininj kabirrikanahkan. ");
INSERT INTO gup_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Wanjh ngurrikurrmen namekbe screen kore kumelk altar kanjdjikah kore kumaye ngarre, kaluk wohkah kaddum dja minj ngurriwernhkoluyhwe.’ ");
INSERT INTO gup_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","7","‘Dja mak ngurrimarnbu mandulkkuyeng bokenh acacia kundulkwi, manbu bininj kabirridulkngimewo kore kahrurrk rings kore kurrid ngarre altar, ba bu kabirriwayhke. Wanjh ngurribalbaru nahni mandulkuyeng kaluk wirlmurrng bronze. ");
INSERT INTO gup_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ngurrimarnbu namekbe altar bu kundulk manbalabala, wanjh yerre kore kanjdji kaluk kumelk nakka ngurribawon kamelkdjorlok. Ngurriyimewo bu ngurrimarnbun altar bu yiman ngayingkihbukkang Moses kore kuwarddekimuk.’ Kuhni wanjh Yawey kanwokrayekwong kadberre.” ");
INSERT INTO gup_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Wanjh Moses yimeng, “Dja kuhni warridj Yawey kanbengdaykeng kadberre, yimeng, ‘Ngurrimarnbu manburrbawi manbu kawarnamyo kore kuberrkkah Manrurrkdjamun Dabburlin. Nawu manburrba nakka wanjh ngurriyirrikurrmen namekbe manburrba bu ngurriwarnamkan dja ngurrirohrokme 46 metres bu kakuyeng. Wanjh ngurrimarnbu namekbe curtains manburrba nawu linen namakmak bu birriridjmeng. ");
INSERT INTO gup_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Dja wanjh ngurriwelhwelkemen namekbe curtains kakaridi dorrengh wirlmurrng silver nawu nginj kore nakukkuyeng wirlmurrng silver, manbu belbmi kore mandulkdjad ngarre kabebbehdangen kore bronze wirlmurrng mandadkenh. Kaluk twenty manbu mandulkdjad kahdi. ");
INSERT INTO gup_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kaluk kore kakbikah nakka ngurrirohrokme 46 metres kakuyeng. Wanjh karohrok yerre ngurriwelhwelkmen nawu manburrba curtains kakaridi dorrengh wirlmurrng silver nawu nginj kore nakukkuyeng wirlmurrng silver, manbu belbmi kore mandulkdjad ngarre kabebbehdangen kore bronze wirlmurrng mandadkenh. Kaluk twenty manbu mandulkdjad kahdi.’ ” ");
INSERT INTO gup_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ ‘Dja manbu karrikadkah kore courtyard nakka ngurriwarnamka manburrbawi 22 metres bu kakuyeng, kaluk ten mandulkdjad kadjabdjabdi, dja mak ten mandadkenh dorrengh kore kumekbe kahwarnamyo. ");
INSERT INTO gup_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kunmekbe kayime rerrih kore koyekkah courtyard, kore kamdungbebme. Wanjh nakka ngurrirohrokme 23 metres bu kakuyeng. ");
INSERT INTO gup_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kore kurridkudji ngarre kurrangmaye, wanjh kunukka manburrba kawelhwelme nawu seven metres bu kakuyeng, kakarrme danjbik mandulkdjad dja mandadkenh ngarre ba kadjabdikenh. ");
INSERT INTO gup_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Mak kore kurridbuyika ngarre kurrangmaye, kunmekbe rerrih ngurriyimowo bu ngurriwelhwelke manburrba dja ngurrirohrokme bu seven metres bu kakuyeng, wanjh danjbik mandulkdjad manbu karayekwon dja mak kabaldengebarndi kore danjbik mandadkenh.’ ” ");
INSERT INTO gup_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“ ‘Kore kurrangmaye ngarre kuberrkkah wanjh kunukka ngurriwelhkemen manburrba nawu ngurrirohrokme nine metres bu kakuyeng. Ngurrimadjmarnbun nawu curtains nawu namakmak linen manburrbawi, dja nawu bidmak bininj kabimbibbun kunyarlwi manbu medjbuyika yiman kukblue, kukkurlba dja kukpurple. Ngurriwelhkemen mahni curtain kore kunkarrngbakmeng mandulkdjad manbu ngurridjabdjabname kore kunkarrngbakmeng madulkdad ngarre. ");
INSERT INTO gup_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kaluk manmekbe mandulkdjad manwern manbu kawarnamyo kore kuberrkkah wanjh makka kakarrmerren nawu nakukkuyeng wirlmurrng silver dja nginj dorrengh nawu wirlmurrng silver, dja mak kabebbehdangen kore mandadkenh ngarre manbu wirlmurrng bronze.’ ” ");
INSERT INTO gup_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","“ ‘Dja manbu kuberrkkah ngarre Manrurrkdjamun Dabburlin, wanjh makka ngurrirohrokme 46 metres kakuyeng dja 23 metres bu kawarlahwarla, wanjh ngurribalwelhwelhkemen manburrba bu kawakbuyingun manmekbe kuberrkkah rowk, nakka wanjh 230 centimetres kaddum. Dja manbu curtains manburrba manbu linen namakmak. Dja nawu mandadkenh mandulkdjad ngarre wanjh ngurrimarnbun wirlmurrng manbu bronze. ");
INSERT INTO gup_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Njalehnjale nawu ngurridurrkmirrikenh kore Manrurrkdjamun Dabburlin, wanjh ngurrimarnbun wirlmurrng bronzewi. Ngayime yiman tentpegs dorrengh.’ Kuhni rowk wanjh Yawey kanwokrayekwong.” ");
INSERT INTO gup_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Wanjh Moses yimeng, “Dja kuhni warridj Yawey kanbengdaykeng kadberre, yimeng, ‘Ngudda nawu Moses, wanjh yibenkayhmen bininj nawu Israel benkebmawahmeng bu kabirrimkan ke mankalkkid manbu olives duninjh, ba bu kamak karung kore ngurriwurlhke nawu lamps kunkakwern rowk bu kabolkburlerran. ");
INSERT INTO gup_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaron dja nawu benbornang rowk, nakka wanjh birrinahna lamps rowk manbu kahrung munguyh kore kumirrk ngardduk, ngaye nawu Yawey. Kaluk kukakkuyeng kore kambarrhbun, wanjh bedda kunbarnangarra rowk kabirrimarnbun lamps ba kadjalwurlhke kuberrkkah kore manburrba kahdi kumirrk ngarre Ark nawu kakarrme manwarddebala bokenh kore kabimbuyindi manbu kunwok kunwoybuk ngaye ngawokkurrmerrinj ngudberre. Kumekbe kahdi kore Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre. Nawu Israel kabenkebmawahme rowk wanjh kabirrimarrkmang mahni mankarre bu kundjalmekbe rerrih munguyh.’ Kuhni rowk nawu Yawey kanwokrayekwong kadberre.” ");
INSERT INTO gup_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Yawey bimarneyimeng Moses, yimeng, “Yibenkayhmen nawu ngunedanginj Aaron bu ngunyikan, kaluk kabenkan nawu nungka benbornang Nadab, Abihu Eleazar, dja Ithamar. Wanjh yibenlarlma birrimekbe ba minj kabirridjalrohrok birribuyika bininj nawu Israel benkebmawahmeng, dja nakka wanjh kabirriyimerran priests kabirridurrkmirri ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Yimarnemarnbu kunmadj nuye Aaron nawu ngunedanginj ba birribuyika bininj kabirriyime nungka nakuken dja mak kabirriburlume. ");
INSERT INTO gup_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Yibenmarneyimen nawu birrikodjkuluwern bininj nawu ngabenmarnbom birrikurdumak, wanjh yibenbengdayhkemen ba kabirribibbun kunmadj nuye Aaron ba bu yikurrme bu kayimerran priest nawu nganmarnedurrkmirri. ");
INSERT INTO gup_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Namekbe kunmadj kabirrimarnbun nawu kaberrekalkdjongburren, dja mak nawu Ephod dja mak nawu kuberrkkah karri nawu robe, dja mak nawu kanjdji robe kadjongbuyindi nawu kakarrme bim warridj, dja mak nawu kakodjdjongbuyindi nawu turban kore kakodjdukkarren, dja manburrba nawu kangadmodukkarren. Birrimekbe bininj kabirrimarnbun kunmadj bedberre Aaron dja nawu benbornang warridj. Wanjh dja ngandimarnedurrkmirri ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Dja mak birrimekbe birrikurdumak bininj nawu kunmadj kabirrihmarnbun wanjh nakka kabirrimang kunyarl manbu wirlmurrng gold, dja mak kunyarlbubuyika manbu kukblue, dja kukpurple dja kukkurlba, dja mak manburrbamak manbu linen.” ");
INSERT INTO gup_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ngudda ngurrimarnbun warridj nawu nadjamun vest kangeyyo ephod. Ngurrimang kunyarl manbu medjbubuyika, yiman kukblue, kukpurple, dja kukkurlba. Ngurribibbu gold kunyarl dorrengh dja linen manburrbamak. Dja ngurribibbun kunyarlwi yiman bim namak kore mahni kunmadj. ");
INSERT INTO gup_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kaluk ngurrikurrme yiman straps bokenh kore kukarlang bokenh ba bu kabirrimadjdukkarren, dja wanjh ngurridjalkkenhnamen kore kurrid ngarre kunmadj. ");
INSERT INTO gup_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Dja mak kabirribibbun manburrba nakuyeng ba nawu priest karrukkarren ephod dorrengh. Dja kabirriname kore kandjdjikah ngarre nawu ephod. Mahni manburrba karohrok bu manburrbamak linen kore kunmadjbuyika birrimarnbom.” ");
INSERT INTO gup_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","11","“Kaluk ngurrimang bokenh manwarddemak manbu Onyx, dja mak ngurringalkemen nakudji bininj nawu karrurrkmirri bu kanamename yiman jewels, dja nawu bidmak. Wanjh nungka karradjdadjke manwarddemak bokenh bu kabenbimngeybimbun nawu bebeywurd nuye Jacob kumekbe kore manwardde onyx bokenh. Six kunngey kore mankudji kunwardde dja manwarddebuyika makka birribuyika six. Dja ngurrbenngeynamen bu nawu nawernwarre beywurd karrokme werrk wanjh ngurrihdjalle kanjdji kore nayerre duninjh nawu nawalawalak. Yerre wanjh nahni bininj kaname gold wirlmurrng manbu kabebbehwakbuyingun mahni manwarddemak bokenh. ");
INSERT INTO gup_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Wanjh namekbe manwarddemak bokenh ngurridjalkkenhnamen kore bokenh straps nawu kore nadjamun vest ba ngurriburrbun bu ngaye minj ngabenbengmidjdan birrimekbe rowk twelve kunmokukurr bedberre nawu Israel benkebmawahmeng. Kaluk Aaron kadjongbuyindi nawu ephod kore kabirrihngeydi kore kukarlang nuye yiman kayime kangeyngorrkan kore kumirrk ngaye ngardduk nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Wanjh ngurrimarnbom mahni bokenh gold wirlmurrng manbu kawernhkarrme nawu kunwardde bokenh. ");
INSERT INTO gup_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Wanjh ngurrimarnbu warridj bokenh kunyarl chains kaluk wirlmurrng gold duninjh bu ngurridukkarrukkan yiman kayime kunyarl rope. Yerre wanjh ngurridjalkkenhnamen namekbe wirlmurrng chains kore bokenh gold wirlmurrng kilehkilelk ba kakarrme namekbe manwardde bokenh.” ");
INSERT INTO gup_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ngurrimarnbun warridj kunmadj bu nawu nakimuk priest kaberrekalkbalhmerren ba kawernhburrbun kore God kadjare bininj rowk bu kabirrikurduyime. Ngurrimarnmarnbu dja ngurribibbun bu ngurribimbun karohrok bu ngurrimarnbom nawu ephod, dja warridj manburrba wanjh karohrok bu nakareni. ");
INSERT INTO gup_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Nawu kabihberrekalkbalhme nakka wanjh square 22 centimetres bu kakuyeng dja 22 centimetres bu kawarlahwarla, dja mak ngurribakke ngurrimarnbun bokenh ba kamarnburren yiman nawu pocket yerre. ");
INSERT INTO gup_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Wanjh ngurrikurrmekurrmen kunkarrngbakmeng manwarddemak manbu gems kore kuberrekalk kaluk kore kaddum wanjh ngurrikurrme nakka wanjh ruby, yibeng topaz, yerre garnet; ");
INSERT INTO gup_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","wanjh nabadbubuyika kunwardde yikurrmekurrme nawu row bokenhkah, wanjh ngurrikurrmen manwarddemak manbu emerald, sapphire, dja diamond ");
INSERT INTO gup_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","dja kanjdji kore danjbikkah nawu nakka wanjh ngurrikurrmen manwarddemak manbu turquoise, dja mak agate dja mak amethyst. ");
INSERT INTO gup_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Dja mak kore yerre duninjh wanjh ngurrikurrmen manbu beryl, cornelian dja mak jasper. Ngurribebbehnamen namekbe twelve manwarddemak rowk kore gold wirlmurrng kabebbehkarrme. ");
INSERT INTO gup_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kaluk ngurrirohrokmen kunbidbokenh dja bokenh nawu manwarddemak nawu kore kabihberrekalkbalhme, kaluk nabebbehkudji nawu manwarddemak wanjh kakadjurren nabebbehkudji beywurd rowk nuye Israel benbornang. Dja ngurringeynamen mankudji mankudji kunngey bedberre kunbidbokenh dja bokenh kunnguya ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ngurrimarnbu warridj chains kaluk wirlmurrng gold duninjh ngurriyimowon yiman kunyarl ngarre nawu kabiberrekalkbalhme nawu priest. ");
INSERT INTO gup_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Dja mak ngurrimarnbun bokenh wirlmurrng gold rings wanjh ngurrikurrmen kaddumkah kore kurrid bokenh nawu nahni kunberrekalkkenh kunmadj. ");
INSERT INTO gup_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ngurridukka nawu bokenh chains kore bokenh gold rings kore kurrid ngarre. ");
INSERT INTO gup_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Mak ngurridukka nahni bokenh chains kore bokenh gold wirlmurrng manbu manwarddemak onyx kawernhkarrme, kaluk ngurribarnnamen kore kunkarlang ngarre straps kaluk kumirrk ngarre nawu ephod. ");
INSERT INTO gup_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Wanjh ngurrimarnbu bokenh gold rings wanjh ngurrikurrmen kore bokenh kurrid bebbehdin kanjdjikah kore nawu kabihberrekalkbalhme dja mak kururrkbeh kurrid kore nawu ephod. ");
INSERT INTO gup_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Dja mak ngurriyawoyhmarnbu bokenh gold rings wanjh ngurridukka kanjdji kore nawu kukarlang kahdi straps kore kumirrk ngarre. Ngurrikurrmen darnkih kore kabelbmikenh, kaluk kaddumkah kore nawu ngokko birribibbom belt ngarre nawu ephod. ");
INSERT INTO gup_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ngurridukka namekbe rings nawu kore kunberrekalkkenh dja ngurrirawo rings kore nawu ephod. Kaluk ngurridukka blue kunyarl dorrengh. Wanjh kabalbelbmikendin kaddum kore belt nawu birribibbuni, ba minj kawarrhme.” ");
INSERT INTO gup_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Wanjh bu Aaron kangimen kore kubolkdjamun, nungka wanjh djongburrimen kabihberrekalkbalhme kunmadj nawu kakarremarnburrenkenh, dja nawu kakarrme kunngey kabirrihngeydi nawu kunnguya rowk bedberre mawahmawah nuye Israel. Kuhni kakurduyime ba bu ngaye Yawey wanjh munguyh ngabenburrbun ngardduk bininj rowk.” ");
INSERT INTO gup_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","“Kaluk ngurrikurrmen nawu Urim dja Thummim kanjdji kore nawu kabihberrekalkbalhme ba kabenedi darnkih kore Aaron nuye kundurddu bu kamre kubolkdjamun dja karrangen kumirrk ngardduk. Nakka munguyh djaldjongbuyindin bu kamngime kore ngaye, ba bu kaborlhme kore baleh ngabenwokrayekwon bininj nawu Israel benkebmawahmeng.” ");
INSERT INTO gup_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Mak ngurrimarnbu nawu nakuyengkenh kunmadj namekbe nanu wanjh nawu Aaron kadjongbuyindi kanjdji kore ngarre nawu ephod, dja birribibbu kore djal blue manburrba manbu kukblue. ");
INSERT INTO gup_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Mak ngurrimarnbu kawohrurrk kaddum ngarre kore Aaron kakomdi. Kaluk kawakbuyingunkenh nawu kunkomkenh ngokko birribibbu nawu narayek manburrba ngarre kahrurrk kukodj ba minj kadjalkmire. ");
INSERT INTO gup_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Kore kanjdjikah nawu namekbe nakuyeng kunmadej, wanjh ngurrikurrmen yeng bokenh. Ngurrimang kunyarl manbu madjbubuyika yima kukblue, dja kukpurple dja kukkurlba, dja ngurribibbu nawu kakukyime mandjoleng manbu pomegranates, dja mak ngurrimarnbu nayahwurd wirlmurrng gold bells. Wanjh ngurrikurrmen nawu bells dja mak nawu pomegranates kanjdji kore kuberrkkah nawu kunmadj, kaluk gold bells kahbebbehdi kubuldjarn kore pomegranates nawu kahdi bebbehdi. ");
INSERT INTO gup_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Wanjh nawu Aaron djongburrimen namekbe kunmadjkuyeng munguyh bu karrurrkmirri yiman priest. Bu kamngimen dja kabebme kore kubolkdjamun bu kamre kore kumirrk ngardduk, wanjh nawu bells kabun kawokdi bu nungka karengehre, dja wanjh Aaron minj karrowen.” ");
INSERT INTO gup_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Dja mak ngurrimang gold duninjh dja ngurridongohdo bu manbalabala kamarnburren dja mak kakuyenghmen, dja ngurriderrmen ba kabimbuyindi bu ngurrihngeynamen, ‘Kukdjamun kore nawu Yawey nuye.’ ");
INSERT INTO gup_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Wanjh ngurrimang kunyarl nawu kukblue, dja ngurridukkan namekbe gold wirlmurrng kabimbuyindi dorrengh kore kumirrk ngarre turban nawu Aaron kahkodjdukkayindi. ");
INSERT INTO gup_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Wanjh Aaron kakanakan kore kumilh nuye bu kamkan nawu njalenjale nadjamun bu bininj nawu Israel benkebmawahmeng kabirridjare ngandiwon. Wardi bu kabirribarabun kore ngandiwonkenh, wanjh ngadjalnan kore Aaron kadjongbuyindi, dja wanjh ngaye nawu Yawey ngadjalnjilngmak kore bedda ngandiwon njalehnjale. ");
INSERT INTO gup_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Dja mak ngurrima linen manbu manburrbamak medjkilelh, dja ngurrimarnbu kunmadj nawu shirt dja nawu kakodjdukkarrenkenh nuye Aaron. Mak ngurrimarnbu nuye nawu kukarlang kawelhme nawu nawarlah dja nakuyeng, kaluk nawu bidmak kabibbun bim kumekbe kunyarl dorrengh.” ");
INSERT INTO gup_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Mak ngurrbenmarnemarnbu bedberre nawu Aaron bebeywurd rowk kunmadj namakmak, yiman shirts, dja nawu kakarlang kawelhme, dja nawu kabirrikodjdjongbuyindi. Kuhni ngurrikurduyimen ba birriwern bininj kabindiburlume dja kabirriyime bu birrikuken. ");
INSERT INTO gup_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Wanjh namekbe kunmadj ngurrimang ngurrbendjongbu Aaron nawu ngunedanginj, dja mak nawu nabebeywurd nuye. Kaluk ngurrbenkodjuhkemen olive mankalkkid ba kabirriyimerran kabirridurrkmirri yiman priests. Kunukka wanjh ngudda kanwon nahni bininj rowk.” ");
INSERT INTO gup_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Mak ngurrimarnbu bedberre nawu kanjdjikenh kabirrihdjongbuyindi ba kabenbarrkbunkenh kore kungorrk dja kore kunkarre kaluk kaddumkah. Kuhni wanjh minj bininj kabindikuknan kumekbe kore kunburrk bedberre. ");
INSERT INTO gup_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Wanjh Aaron dja bebeywurd nuye, wanjh birridjongburrimen nahni kunmadj munguyh bu kabirringimen Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, dja mak bu kabirrimre darnkih kore altar bu kabirridurrkmirri ngardduk yiman priests kore kubolkdjamun. Bu minj kabirridjongbuyindi namekbe kunmadj nawu kanjdjikenh, wanjh kabirriwowarreworren dja kunukka wanjh kabirridowen. Wanjh mahni mankarre kahdjalyo munguyh bedberre Aaron dja nawu mawahmawah nuye.” ");
INSERT INTO gup_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Wanjh nawu Yawey bimarneyimeng Moses, yimeng, “Kuhni bu ngurrikurduyime bu ngurrbenmarnbun Aaron dja mak nabebeywurd nuye bu kabirriyimerran priests nawu ngandimarnedurrkmirri ngaye. Ngurrima nakudji bulikki yaw, dja bokenh sheep kaluk narangem bokenh nawu minj njale kabirrikarrme. ");
INSERT INTO gup_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ngurrikinjemen buriddi bu ngurrimarnbun kandidjawa manbu mannguklurlmikenhyak, dja ngurrirawon kunkalkkid manbu olives. Yikahwi buriddi mak ngurrimarnbun bu kunkalkkid olives yak. Yikahi buriddi warridj ngurrimarnbun kakukyime cakes kaluk ngurribarung olive kunkalkkid dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Wanjh ngurridahkendo manmekbe manme kore kundjabarrk, dja ngurrimka kandiwon ngaye bu kandimarnebun namekbe nawu bulikki dja mak sheep narangem bokenh.” ");
INSERT INTO gup_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Kaluk ngurrbenkan Aaron dja nabebeywurd nuye kore kurrangmaye ngarre Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, wanjh kunmekbe ngurrbenkukdjirridjbun kukkuwi. ");
INSERT INTO gup_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Wanjh ngurrimadjmang nahni kunmadj dja ngurridjongbun Aaron nawu kanjdjikenh, dja mak nabuyika kunmadj nawu kanjdjikenh ephod, dja mak ngurridjongbu ephod, dja mak nawu kunberrekalk kabalhme, dja yerre ngurringadmodukka belt dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Wanjh ngurribalkodjdukka nawu turban kore kukodj nuye, dja mak ngurribarnnamen nadjamun manbalabala gold kore kabimbuyindi, ‘Kukdjamun kore nawu Yawey nuye.’ ");
INSERT INTO gup_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Yerre ngurrimang manmekbe mankalkkid manbu ngurrikodjdjuhkekenh, wanjh ngurrikodjdjuhkemen ba kunu ngurrimarnbun kayimerran priest. ");
INSERT INTO gup_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Wanjh ngurrbenka nabebeywurd nuye wanjh nawu kanjdjikenh kunmadj namekbe ngurrbendjongbu. ");
INSERT INTO gup_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Dja mak ngurrbenkodjdukka kunmadj dja ngurrbenngardmorrukka nawu manburrba belt ngurrimarnbom, dja Aaron dorrengh. Wanjh Aaron dja nawu mawahmawah nuye nakka wanjh priests kabirriyimerran, dja ngawokrayekwong bu kadjalyo munguyh bedberre. Kuhni bu ngurrikurduyimen bu ngurrimarnbun Aaron dja nabebeywurd nuye bu kabirriyimerran priests.” ");
INSERT INTO gup_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Kaluk ngurrimka namekbe bulikki darnkih ngarre Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, wanjh Aaron dja nabebeywurd nuye kabirribidkurrmerren kore kukodj nuye namekbe bulikki. ");
INSERT INTO gup_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Yerre wanjh ngurribu namekbe mayh kore kumirrk ngardduk nawu Yawey kaluk darnkih kurrangmaye ngarre Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Dja wanjh kunbidwi ngudberre ngurrima yikahwi manbu kunkurlba nuye bulikki dja ngurridelkkemen kore kurrid kaddumkah ngarre altar, dja mak yerre ngurrikurlbayakarrbu kore kanjdji kumelk ngarre altar. ");
INSERT INTO gup_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Wanjh ngurrimang kunbalem bulikki nuye kore kanjdji nawu kakarrme yiman kayime mannjam, kaluk kore kundiw dja mak ngurrima kundaykenh bokenh dja kunbalem dorrengh ngarre, wanjh ngurrikinjemen rowk kore altar. ");
INSERT INTO gup_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Dja ngaleng ngurridjalmang kunkanj kunkulah, dja mak njalehnjale ngarre kunnjam nuye namekbe bulikki wanjh ngurrikan kuberrkkah djarreh kore ngurrihdi, dja kumekbe wanjh ngurriwurlhkemen. Kuhni ngurrikurduyime yiman kayime bu kabularrbuyindan ngudberre kunwarre.” ");
INSERT INTO gup_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Dja mak ngurrima nakudji sheep nawu narangem, wanjh Aaron dja nabebeywurd nuye kabirribidkurrmerren kore kukodj nuye. ");
INSERT INTO gup_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Wanjh ngurribu, ngurrima kunkurlba dja manbu makka ngurridjuhdjuhkemen kore kurrihdirrid kunkarrngbakmeng ngarre altar. ");
INSERT INTO gup_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Wanjh ngurrikukdjobdjobke nawu narangem sheep bu ngurrikilelhme. Dja mak ngurridjirridjbu kukku dorrengh nawu kunnjam kore kahyo dja kunkarre nuye, wanjh ngurrirawo kunkodj dja mankilekilelh nawu ngurridjobdjobkeng. ");
INSERT INTO gup_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Yerre wanjh ngurrimokenkinjemen kore altar ba kunak kakanjyakwon rowk. Kaluk namekbe mayh wanjh kandimarnekinje ngaye nawu Yawey, dja bu nganome manbu kundjawuymak wanjh ngaye nganjilngmak, dja namekbe mayh ngudda kandiwong ngaye nawu Yawey.” ");
INSERT INTO gup_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Wanjh ngurrimang nawu nabuyika narangem sheep, dja Aaron dja nabebeywurd nuye kabirriyawoyhbidkurrmerren kore kukodj nuye. ");
INSERT INTO gup_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ngurribu wanjh ngurrikurlbamang yikahwi nuye, wanjh ngurrbenkanembarung kundurrk kore kukun bedberre birrimekbe Aaron dja nabebeywurd nuye. Dja mak ngurribaru kore kunbidbadjan bedberre kaluk kubidkukun, dja mak kurrenge bedberre kaluk manbu kundengebadjan kore kurrengekun bedberre. Wanjh ngurribaldelkdelkke kunkurlba kore kunkarrngbakmeng kurrihdirrid rowk ngarre altar.” ");
INSERT INTO gup_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","“Dja mak ngurrima yikahwi maninjmanu kunkurlba kore altar kakurlbarri, wanjh ngurriborawo kunkalkkid dorrengh manbu ngurrikodjdjuhkekenh nawu priests. Wanjh ngurrikukdelkkemen Aaron dja mak kunmadj nuye, dja mak nabebeywurd nuye dja kunmadj bedberre. Kunukka wanjh bedda kabirriyimerran ngardduk duninjh, dja kunmadj bedberre dorrengh.” ");
INSERT INTO gup_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Dja mak ngurridadjkemen kunbalem kore nahni narangem sheep, dja mak kunberdbalem dja mak kunbalem nawu kore kanjdji kahyo. Mak ngurridadjke kunmakmak manbu kundiw, dja kundaykenh bokenh dja kunbalem ngarre dorrengh, dja mak kundadkun dorrengh. Kaluk nahni sheep ngurribom kore ngurrbenmarnbom nawu priests. ");
INSERT INTO gup_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Yerre ngurrimang basket buriddi dorrengh manbu mannguklurlmikenhyak, nawu ngurrikurrmeng kore kumirrk ngardduk nawu Yawey. Wanjh kunmekbe ngurrilodmang nakudji buriddi, dja cake manbu marnbuyindanj olive kunkalkkid dorrengh dja nakudji biscuit kaluk manbinjbinj. ");
INSERT INTO gup_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Wanjh ngurrikurrmekurrme manekke manme kore kubid bedberre Aaron dja nawu benbornang, dja ngurrbenmarneyimen bu ngandiwon ngaye nawu Yawey. Bedda wanjh birriwayhkemen kore kumirrk ngardduk kunbidwi bedberre bu kabirriberlwayhme. ");
INSERT INTO gup_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Wanjh ngurrimang manekke manme kore kubid kabirrihkarrme dja ngurrikurrme kaddum kore mayh ngurrimokenkinje. Kuhni yiman kayime kandiwon manme. Bu nganome karung, wanjh nganjilngmakmen ngudberrekenh. ");
INSERT INTO gup_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ngudda nawu Moses, yerre wanjh yikanjmang kunberrekalk nuye sheep narangem kore ngurrimarnbom Aaron bu yimerranj priest, wanjh kanwo ngaye nawu Yawey. Yiwayhkemen kubid ke bu yiberlwayhme. Kaluk bu ngurrimarnbun Aaron bu kayimerran priest, wanjh maninjmanu kunkanj wanjh ngudda ke kore ngurriyikadjurren nawu mayh.” ");
INSERT INTO gup_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ngudda yibenmarnema kunkanj bedberre Aaron dja nawu nabebeywurd dorrengh dja yibenmarnekurrmen bedberre. Ngayime nawu kunberrekalkkenh dja mak kundadkenh kunkanj kore narangem sheep nawu ngurribom dja bedda birrikanjwayhkeng kore kumirrk ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Kaluk ngakarremarnbun ngudberre bu manmekbekenh dja wanjh kayo munguyh. Bu bininj nawu Israel benkebmawahmeng kabirrikinje mayh dja kabirridjarrkngun kore kunmodmikenh ngardduk dorrengh, wanjh munguyh bindikanjwo nawu Aaron dja nabebeywurd nuye manbu kunberrekalkkenh dja kundadkenh. Kuhni wanjh ngaye ngandikanjwon, ngaye nawu Yawey.” ");
INSERT INTO gup_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Kaluk yerrekah bu nawu Aaron karrowen, wanjh kunmadj nadjamun nuye ngurrbenwo nawu mawahmawah nuye. Bu ngurrbenkodjdjuhke birrimekbe bininj kunkalkkiddjamun dorrengh dja ngurrbenmarnbun nawu priests, wanjh kunmekbe kabirridjongburren nahni kunmadj nawu Aaron nuyeni. ");
INSERT INTO gup_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Kaluk yerrekah bu Aaron nuye beywurd kayimerran priest, kumunke nuye nawu Aaron, wanjh djongburrimen namekbe kunmadj kadjongbuyindi bu kunkodjke seven kore nungka kamngimen dabburlin manbu kore ngaye ngamre bu djahwon ngudberre, bu nungka karrurrkmirri kore Kubolkdjamun.” ");
INSERT INTO gup_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Wanjh ngurrima nahni sheep nawu narangem bu ngurribun kore ngurrbenmarnbun Aaron dja nawu bebeywurd nuye bu kabirriyimerran nawu priests. Kaluk ngurrikanjkinjemen kore kurobbe kubolkdjamun. ");
INSERT INTO gup_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Wanjh Aaron dja nawu beybeywurd nuye birriray kore kurrangmaye ngarre Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, wanjh kumekbe bedda kabirrikanjngun manmekbe kunkanj nawu sheep narangem, dja mak kandidjawa manbu kahdahkendi kore nahni kundjabarrk. ");
INSERT INTO gup_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Bedda wanjh kabirridjarrkngun mahni kunkanj, manbu kandikanjwong ngaye nawu Yawey ba bu ngabenmarnebengmidjdanj kunwarre bedberre, bu kunmekbe ngurrbenmarnbom birriyimerranj priests ngardduk, dja kore ngaye ngabenmarnbom birridjamun nawu djal ngardduk. Kuhni wanjh minj nangale mak kakanjngun maninjmanu kunkanj, dja wanjh nakka mandjamun duninjh. ");
INSERT INTO gup_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kaluk yerre bu kabirriyimerran priests, dja bu kabirrikanjngun kore sheep narangem dja mak manbu buriddi, wardi bu kabirribawon mahni manme kadjalyo bu kukabel kamre, wanjh makka ngurriwurlhkemen ba kayakmen rowk. Yuwn bu bininj kabirringun dja wanjh makka mandjamun manme.” ");
INSERT INTO gup_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Kuninjkunu ngurrikurduyimen kore wokrayekwong ngudberre bu ngurrikurduyimen bedberre Aaron dja nawu bebeywurd nuye. Kaluk ngurridurrkmirrin kunkodjke seven bu ngurrbenhmarnmarnbun kabirriyimerran nawu priests. ");
INSERT INTO gup_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Bu kunkodjkekudjikudji wanjh ngudda ngurribu nakudji bulikki ngardduk dja ngurrikinjemen ba bu ngaye ngamarnebengmidjdan kunwarrekenh. Kunukka ngayime bu mahni altar wanjh burlerranj kore ngadjare, dja wanjh ngurrimarnbun ba kamakmen. Ngurribun mayh dja mak ngurridelkkemen manbu altar ba kayimerran ngaye ngardduk ngadjalkudji. ");
INSERT INTO gup_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ngurrihdjalkurduyimen rowk bu kunkodjke seven. Wanjh kunukka namekbe altar kayimerran mandjamun duninjh, dja nawu nangale bininj, dja njalehnjale nawu kawohkarrme namekbe altar wanjh nakka warridj kayimerran nadjamun.” ");
INSERT INTO gup_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Wanjh Yawey biyawoyhwokdi dja bimarneyimeng nawu Moses, “Bu kunkodjkekudjikudji munguyh wanjh ngurribu dja kandimarnekinjemen bokenh lambs kore altar, kaluk nawu nakudji mandjewk berrewoneng. ");
INSERT INTO gup_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Wanjh ngurribu nakudji lamb bu kumkabel dja nabadbuyika lamb wanjh yerre ngurribu bu kabalhngokdan. ");
INSERT INTO gup_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kaluk bu kukabel, bu ngurribun nawu nayungkih lamb ngarddukkenh, wanjh nakka ngurrikinjemen warridj nakudji kilogramme manbu kandidjawa dja mak nakudji litre kunkalkkid duninjh manbu olives kore ngurriyingkihrawong. Dja mak ngurriyakbu kurorre nakudji litre manbu wine, dja kunukka yiman kandiwon ngaye nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kaluk bu wolewoleh duninjh, kabolkburlerran, wanjh kandimarnebu nabadbuyika lamb. Bu kunmekbe kabolkyime wanjh kandiwo warridj kandidjawa, dja kunkalkkid manbu olives, dja mak manbu wine, karohrok bu malamalaywi ngurriyimowong. Maninjmanu kandiwon ngaye nawu Yawey, dja bu ngurrikinje wanjh nganome manbomanjmak, wanjh ngawarnmakmen.” ");
INSERT INTO gup_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Kaluk ngurrikurduyimen kuninjkunu rowk munguyh munguyh. Kaluk kandimarnekinjemen namekbe mayh kore ngahdi, kore kumirrk kurrangmaye ngarre Dabburlin kore ngaye ngamre bu djahwon ngudberre. Bu kunmekbe wanjh, ngarrmarren ngudda nawu Moses, dja ngawokdan ke. ");
INSERT INTO gup_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Dja mak ngarrinarren bininj nawu Israel benkebmawahmeng kumekbe warridj. Kaluk kumekbe ngamdjaldi kunwernhmakmak ngardduk dorrengh bu ngawernhbolkwolkan kunmekbe, dja wanjh kabolkyimerran kunbolkdjamun ngardduk.” ");
INSERT INTO gup_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Dja mahni Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre dja mak manbu altar, makka wanjh ngamarnbun bu kayimerran rowk kore ngardduk duninjh. Dja mak ngabenmang Aaron dja nabebeywurd nuye dja ngabenmarnbun bu kabirryimerran priests ngardduk nawu ngandimarnedurrkmirri. ");
INSERT INTO gup_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Wanjh ngarridjarrkni nawu Israel benkebmawahmeng dja mak ngabenmarnewohrnan, dja ngaye wanjh God duninjh bedberre. ");
INSERT INTO gup_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Bedda wanjh kabirriburrbun bu ngaye nawu bedberre God ngangeyyo Yawey, dja ngaye ngabenbebkeng kore kunbolk Egyptbeh, ba bu kamak ngarridjarrkni. Ngaye Yawey nawu bedberre God.” Kuhni rowk bu Yawey bimarneyimeng nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Wanjh Yawey yawoyhwokdanj bimarneyimeng Moses, “Ngurrimarnbu altar kaluk acacia kundulk dorrengh manbu ngurriwurlhke incense mankalkkidmanjmak. ");
INSERT INTO gup_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kaluk ngurrimarnbun bu square fifty centimetres kakuyeng dja mak fifty centimetres kawarlahwarla, dja mak 90 centimetres bu kaddum. Dja mak ngurrimarnbu manbu kunkanemdulk ngarre makka wanjh yiman kayime kukkudji karaworren manmekbe burrk ngarre altar. ");
INSERT INTO gup_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Wanjh ngurribarrkbun bu ngurrikurrmen wirlmurrng gold duninjh, kore kaddum dja kungorrk rowk, dja mak kunkanemdulk warridj. Dja mak mankuyeng manbalabala manbu wirlmurrng gold, wanjh ngurrikurrmen kore altar kaluk kawakwakbun kumekbe. ");
INSERT INTO gup_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Dja mak ngurrimarnbu kunkarrngbakmeng wirlmurrng gold rings dja ngurrikurrmen kanjdji kore manbalabala kawakbun bokenh bokenh kore kurrid bokenh. Kaluk nahni rings kakarrme mandulkkuyeng bokenh bu bininj kabirrikanahkan nawu altar. ");
INSERT INTO gup_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Manbu mandulkkuyeng bokenh, makka ngurrimarnbu acacia kundulk, kaluk ngurribaru wirlmurrng gold duninjh. ");
INSERT INTO gup_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Wanjh ngurrikurrmen namekbe altar kore kuberrkkah ngarre curtain nawu kabarndi kumirrk nawu Ark manbu kakarrme manwarddebala bokenh nawu kabimbuyindi kunwok kunwoybuk kore ngawokkurrmerrinj. Kumekbe kaluk kumirrk ngarre lid nawu kahbarrkbun namekbe Ark. Wanjh kumekbe kaluk ngaye ngamre karrinarren.” ");
INSERT INTO gup_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","8","“Ngadjare manbu mankalkkidmanjmak bu kahdjalrung kunkodjkekudjikudji munguyh munguyh kore kumirrk ngardduk nawu Yawey, dja nawu mawahmawah ngudberre wanjh bedmanwali kabirridjalwurlhke munguyh. Kaluk Aaron nungka wanjh wurlhkemen namekbe incense nawu namanjmak kore altar munguyh munguyh bu kukabelwern, bu kamre kanahnan nawu lamps. Wanjh yawoyhwurlhkemen manbu mankalkkidmanjmak incense kunkodjke rowk bu wolewoleh nungka kamre kawurlhwurlhke lamps. ");
INSERT INTO gup_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Yuwn bu ngurrimang manmekbe altar bu kandimarnekinje nawu nawarre incense. Dja bu njalehnjale kandiwoyi dja kandimarnekinje, yiman mayh, dja yika manmim, wanjh yuwn bu ngurrikinje kore manmekbe altar, dja yuwn bu mak kandimarneboyakbun manbu wine kore manmekbe altar. ");
INSERT INTO gup_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Dja bu mandjewkbubuyika wanjh Aaron kunkudjikenh kayawoyhmarnbun manmekbe altar ba kayawoyhyimerran manmak kore ngaye. Nungka wanjh delkkemen mahni kunkurlba kore kunkamendulk ngarre altar. Nungka wanjh kamang mahni kunkurlba kore mayh bu ngurribun ba bu ngaye Yawey ngabengmidjdan ngudberre kunwarre rowk. Wanjh kumekbe kahdjalkurduyimerran mandjewkbubuyika munguyh munguyh. Kaluk nahni nawu altar nakka wanjh djal ngaye ngardduk nawu Yawey.” ");
INSERT INTO gup_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","12","Wanjh Yawey yawoyhwokdanj, bimarneyimeng Moses, “Bu ngurrbenrohrok bu ngurriyime baleh kayime birrimekbe bininj nawu Israel benkebmawahmeng, kaluk bu kunmekbe kabolkyime, wanjh birribebbehkudjikudji bininj kandikarremulewan ngaye Yawey, yiman kayime kabirribebbehkukbayahmerren ba kundjak kunkimuk nawu minj kamarnbuyindan bedberre yerre bu ngurrbenrohokme. ");
INSERT INTO gup_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kaluk bininj nawu ngurrbenrohrokme wanjh kabirribebbehkukkurrme yikahwi money nawu nakudji coin ngarre kubolkdjamunkenh. Kaluk namekbe money, nakka wanjh bedda ngandikukwon ngaye nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Wanjh bininj nawu ngurrbenrohrokme bu nawu mandjewk bedberre 20 dja mak nawu kabindibalyurrhke nawu mandjewk twenty, wanjh bedda rowk ngandikukwo rowk namekbe kunwardde nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Bu ngandikukwon money ba yiman kayime kabirridarrkiddurndiwerren kore ngardduk, wanjh nawu bininj yiman kukwarddekimuk wanjh nakka minj kabirrikukkurrme nawern, dja ngaleng namekke nadjalkudji coin. Dja mak bininj nawu minj nakimuk money kabirrikukkarrme, wanjh nakka kabirridjalkukkurrme namekbe nakudji coin.” ");
INSERT INTO gup_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","“Ngurrimang rowk kore kabirrikukkurrme ngardduk dja wanjh ngurribayahme njalehnjale nawu ngarre kabirridurrkmirrikenh kore Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre. Kaluk kuhni wanjh ba Yawey kadjalburrbun bu bininj nawu Israel benkebmawahmeng wanjh yiman kayime birridarrkidbayahmeng bedberre kundarrkid.” ");
INSERT INTO gup_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","18","Wanjh Yawey bimarneyimeng Moses, “Ngurringalngmarnbu nakimukkenh bannikin nawu kaluk wirlmurrng manbu bronze, dja mak nawu kahdedjbarndi kaluk wirlmurrng bronze yerrih, ngarre nawu priests kabirrihdjirridjburrenkenh. Wanjh ngurrikurrmen namekbe banikkin dja mak nawu kahdedjbarndi kubulkayh kore Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, dja kore altar, wanjh kukku yiborrakendong kore nawu banikkin. ");
INSERT INTO gup_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Wanjh Aaron dja nabebeywurd nuye kabirribiddjirridjburren dja kabirridengedjirridjburren kukkuwi kore namekbe banikkin. ");
INSERT INTO gup_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Bu bedda kabirringimen kore Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, wanjh birrikukdjirridjburrimen kukkuwi ba minj kabirridowen. Dja mak bu kabirrimre kore altar bu kabirridurrkmirri yiman priests bu ngandimarnebun ngardduk nawu Yawey dja kabirrikinje, ");
INSERT INTO gup_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","wanjh birribiddjirridjburrimen dja birridengedjirridjburrimen ba kunukka minj kabirridowen. Mahni mankarre manbu Aaron dja mawahmawah nuye bu kabirriwokmang bu kuninjkunu rerrih munguyh.” ");
INSERT INTO gup_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","25","Wanjh Yawey bimarneyimeng Moses, “Ngurrima spices nawu namakmak yiman six kilograms kunkalkkid myrrh, mak three kilograms nawu namanjmak cinnamon, dja three kilograms namanjmak cane, dja six kilograms cassia. Wanjh ngurrirohrokmen namekbe rowk kore mankarre kayime. Dja mak ngurrimang kunkarrngbakmeng litres olive kunkalkkid, wanjh ngurrirawo rowk bu kakalkkidmarnburren yiman kayime manmanjmak perfume. Kaluk wanjh kamarnbuyindan manbu mandjamun olive kunkalkkid. Dja maninjmanu mankalkkidmanjmak wanjh ngurrimang dja ngurrbenkodjbarung bininj bu ngayekenh. ");
INSERT INTO gup_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","28","Kaluk ngurridjuhkemen namekbe kunkalkkid kore Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, dja mak kore Ark nawu yirrahkendoy manwarddebala bokenh manbu kabimdi kunwok kunwoybuk ngardduk ngawokkurrmerrinj, dja manbu table dja njalehnjale ngarre, dja nawu lampstand dja nawu tools ngarre, dja mak altar kore ngurrikinje mankalkkidjmanjmak, dja mak nabuyika altar kore kabirrikinje mayh nawu ngandiwon ngardduk, dja mak nawu tools ngarre, mak banikkin nakimuk, dja nawu kahdedjbarndi ngarre. ");
INSERT INTO gup_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ngudda kunu ngurrimarnbun bu kayimerran mandjamun rowk. Kaluk njalenjale bu kakilekme wanjh kunu nadjamun duninjh kayimerran warridj.” ");
INSERT INTO gup_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Wanjh kunkalkkid ngurrima ngurrbenkodjdjuhke Aaron dja nabebeywurd nuye ba kabirriyimerran djal ngaye ngardduk bininj, dja ngandimarnedurrkmirri yiman priests. ");
INSERT INTO gup_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ngudda Moses yibenmarneyimen nawu Israel benkebmawahmeng, ‘Nawu Yawey kayime nahni nawu kunkalkkid wanjh nakka nuye nadjamun bu kuninjkunu bininj kabindikodjdelkkerren munguyh munguyh bu kabirriyingkihmarnburren kabirridurrkmirri nuye yiman priests. ");
INSERT INTO gup_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Dja yuwn ngurrbenkodjdjuhkerren maninjmanu kunkalkkid dorrengh nawu kunburrk bininj, dja mak yuwn bu ngudmandeleng ngurrikalkkidmarnbun maninjmanu mankalkkid. Wanjh nakka ngurriwerhburrbun bu mahni mankalkkid wanjh mandjaldjamun duninjh. ");
INSERT INTO gup_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Dja bu nangale bininj kakalkkidmarnbun namekbe perfume nawu manmanjmak, dja mak bininj nawu kabikodjdelkke bininj nawu minj priest, wanjh nakka nanu ngaye ngayarlarrke kore nawu bininj nuye rowk.’” ");
INSERT INTO gup_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Wanjh Yawey bimarneyimeng Moses, “Ngurrima nahni nawu manjmak spices, yiman resin, onyx, galbanum, dja frankincense duninjh. Ngurribebbehwayhme bu ngurrirohrokme bu karohrok kahbebbehyo. ");
INSERT INTO gup_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ngurrirawo maninjmanu spices ba kamarnburrren incense manmanjmak bu kabanj, dja mak djila ngurrirawon ba bu manmak kadjalyime dja mak mandjamun duninjh. Kuhni karohrok bu bininj kabirriyime nawu perfume kabirrimarnbun. ");
INSERT INTO gup_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Wanjh ngurridongorro yikahwi mahni incense, kaluk ngurrimarnbun kundjulng, wanjh ngurrika ngurrikurrmen kumirrk ngarre Ark kore kahdahkendi manwarddebala bokenh kore kabimdi kunwok kunwoybuk ngawokkurrmerrinj. Kaluk kukmekbe kore Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre. Kumekbe wanjh ngamre bu karrinarren. Kaluk manmekbe incense wanjh ngurriwernhburrbun bu ngurriyime mandjaldjamun duninjh. ");
INSERT INTO gup_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Yuwn bu ngurrimarnbun manmekbe incense bu ngudman ngudberrekih. Ngurriyimen bu mandjaldjamun ngardduk nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nangale nawu kamarnbun manmekbe mankalkkidmanjmak kore nungka kadjare, wanjh nakka ngawohyarlarrke kore bininj nuye.” ");
INSERT INTO gup_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","2","Wanjh Yawey bimarneyimeng Moses. “Yina, ngaye wanjh ngamey Bezalel nawu beywurd nuye Uri kaluk kore kunmokukurr ngarre Judah. Kaluk Uri nawu nakka wanjh beywurd nuye Hur. ");
INSERT INTO gup_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Kaluk ngaye ngakurrmeng Namalngmakkaykenh ngardduk ngaye nawu God, dja kangebarlkeng. Dja mak ngawong manbu ba nakurdumak bu karrurrkmirri kore njalenjale kamarnmarnbun, dja kamayaliwernmen ba nawern nawu karrurrkmirri. ");
INSERT INTO gup_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","5","Kaluk nungka wanjh kabimbun nawu bimmak, ba bu bininj kabirrimarnbun njalehnjale nawu kore gold, silver dja wirlmurrng manbu bronze, dja ba kabirridadjke nawu jewels bu kabirrikurrmekurrme, dja mak kore kabirrimarnbun njalehnjale kundulkwi, dja mak kundjalwern bu kabirrimarnmarnbun. ");
INSERT INTO gup_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Dja mak ngaye ngamey Oholiab nawu beywurd nuye Ahisamach nawu kumdolkkang kunmokukurr Dan. Dja nungka wanjh kabenedjarrkdurrkmirri Bezalel. Warridj ngaye wanjh ngabenwong birridjalwern bininj nawu kabirrimarnmarnbun rowk kore ngawokrayekwong ngudberre, ba bu birrikurdumak. ");
INSERT INTO gup_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ngayime nawu Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre dja manbu Ark kore manwarddebala bokenh kahdi nawu kabimdi kunwok kunwoybuk ngaye ngawokkurrmerrinj, dja mak nawu kaddumkah ngarre dja mak njalehnjale nawern ngarre nawu dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","9","Nahni mak karawoyindan nawu namekbe manbalabala dja njalehnjale ngarre, yiman kayime gold lampstand dja njalehnjale nawu ngarre, dja altar ngarre nawu ngurriwurlhke manbu incense, dja altar ngarre nawu kandimarnekinjekenh mayh, dja njalehnjale ngarre nawu kabirrikarrme, yiman kayime mak banikkin nakimukkenh dja mak nawu ngarre kanjdjikenh. ");
INSERT INTO gup_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Dja mak ngabenwong bedda nawu kabirribibbun kunmadj nadjamun nuye Aaron nawu priest, dja mak nabebeywurd nuye manbu kunmadj bedberre ba kabirridjongbuyindi bu kabirridurrkmirri yiman priests. ");
INSERT INTO gup_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Mak nawu kabirrimarnbun nawu namakmak kunkalkkid olive bu bininj kabindikodjdjuhkekenh, dja mak manmanjmak incense manbu ngurriwurlhke kore kubolkdjamun. Kaluk birrimekbe bininj wanjh kabirrimarnbun namekbe rowk nawu kore ngaye wokrayekwong ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","13","Wanjh Yawey bimarneyimeng Moses, “Yibenmarneyimen nawu Israel benkebmawahmeng, ‘Ngurriwernhburrbu Yawey nuye kunkodjke manbu Sabbath. Bu ngurrikurduyime wanjh ngurriborlhme bu ngaye Yawey ngunburrbun dja mak ngudda kandiburrbun. Dja mak nawu mawahmawah ngudberre kuhni birrikurduyimen warridj. Kuhni bu ngurridjalburrbun rowk bu ngaye nawu Yawey, wanjh marnbun ngudberre bu ngudda djal ngaye ngardduk bininj.’” ");
INSERT INTO gup_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Ngurrimarnbu manmekbe Sabbath kunbarnangarra djamunnin ngudberre. Dja bu nangale bininj kawarrewan manmekbe Sabbath wanjh namekbe bininj ngurribu, karrowen. Dja mak nangale nawu karrurrkmirri bu Sabbath kore djal nungan kadjare wanjh ngurribawo dja minj ngurriyawoyhraworren. ");
INSERT INTO gup_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kaluk bu six kunkodjke makka wanjh ngurridurrkmirri, dja manbu kunkodjke seven, wanjh mahni Sabbath ba bu ngurringehmekenh. Maninjmanu kunkodjke wanjh ngardduk, dja ngaye wanjh Yawey. Nangale nawu karrurrkmirri kore djal nungan kadjare bu Sabbath nakka wanjh ngurribu, karrowen. ");
INSERT INTO gup_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ngudda nawu Israel ngunkebmawahmeng dja warridj nawu mawahmawah ngudberre, wanjh ngurrikarrmen manmekbe Sabbath munguyh munguyh. Mahni Sabbath wanjh kamenyime bu ngaye ngawokkurrmerrinj ngudberre rowk. ");
INSERT INTO gup_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Wanjh manmekbe manbu Sabbath kunbarnangarra makka wanjh munguyh munguyh ngunbengdayhke ngudda nawu Israel ngunkebmawahmeng, dja mak ngaye nganbengdayhke bu ngaye nawu Yawey ngamarnbom kaddum rowk dja mak kurorre rowk bu ngarrurrkmirri six kunbarnangarra, dja bu kunbarnangarra seven wanjh makka minj ngarrurrkmirriwirrinj dja wanjh ngangehmeng.” Kuhni rowk bu Yawey bimarneyimeng nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Bu Yawey ngurdmeng benehwokdi Moses kore Mount Sinai, nungka biwong bokenh kunwardde manbalabala kaluk manbu kunwok kunwoybuk nuye Yawey wokbimbuyindi, kaluk nungan God bihbimbom nuye kunbidwi kore maninjmanu manwarddebala bokenh. ");
INSERT INTO gup_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kaluk bininj nawu Israel benkebmawahmeng wanjh birrimadbom kunkuyeng nawu Moses, dja nungka minj kumkoluyi kore kuwarddebeh. Wanjh birrimirndeyikang nawu Aaron dja birrimarneyimeng, “Mah. Yimarnbu kadberre god ba kanmarnedokme kadberre. Dja namekbe bininj Moses nawu kanyibebmeng kadberre kore Egypt, minj karriburrbun bu baleh nungka bimarnekurduyimerranj.” ");
INSERT INTO gup_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Wanjh Aaron benmarneyimeng, “Mah. Ngurriyerrkkemen dja ngurrimka nawu kabirrihkanemdjongbuyindikenh, manbu gold wirlmurrng nawu bedberre ngalbihbininjkobeng ngudberre dja mak ngalbebeywurd dja nabebeywurd ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Wanjh birriwern rowk birriyerrkkerrinj kore kunkanemkenh, dja birrikang dja birriwong Aaron. ");
INSERT INTO gup_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Wanjh nungan Aaron mangimangi kore birriwong rowk, dja kinjeng bu mey gold wirlmurrng duninjh, wanjh kukmarnbom idol bedberre. Kaluk kukmarnbom wirlmurrng gold mandjawakwi bu kukyimi bulikki yaw. Wanjh birrimekbe bininj birriyimeng, “Ngurrina! Ngad nawu Israel kankebmawahmeng! Dja nahni wanjh god nawu kanbebkeng kadberre kore Egyptbeh!” ");
INSERT INTO gup_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kaluk bu Aaron nang baleh bu kurduyimerranj wanjh nungka marnbom altar kore kumirrk nuye namekbe bulikki yaw, dja yimeng bedberre, “Bu malaywi wanjh ngad karrimulilmang nawu Yawey.” ");
INSERT INTO gup_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Wanjh bu kumdungbebmi malaywi bedda birridolkarrinj. Wanjh birrimey mayh, dja yikahwi birrimokenkinjeng kore altar, dja yikahwi mak birribom bu birridjarrknguni kore kunmodmikenh nuye Yawey. Kaluk birriyerrkang, birridjarrknguneng dja birribonguneng, wanjh yerre birridolkkang dja birridedjingmey bu kunwarre duninjh birrikurduyimi. ");
INSERT INTO gup_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Wanjh Yawey bimarneyimeng Moses kore kuwarddekimuk, yimeng, “Werrkwerrk yikolu kore kondahbeh! Birrimekbe bininj nawu yibenbebkeng kore Egyptbeh wanjh nakka birriwarreworrinj dja ngandibodmewong ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Bedda wanjh werrkwerrk ngandiwokbawong ngardduk kore ngabenwokrayekwong. Dja bedda wanjh birrimarnbom idol bu wirlmurrng goldwi, dja kakukyime nawu bulikki yaw. Wanjh birrihmarneboddangeni namekbe nawu idol, dja mak birriwoni nuye bu birrimarnebom mayh, dja mak birriyimeng, ‘Ngurrina! Ngad nawu Israel kankebmawahmeng! Dja nahni wanjh god nawu kanbebkeng kadberre kore Egyptbeh!’” ");
INSERT INTO gup_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“Ngaye ngabennang birrimekbe bininj bu minj kandiwokmarrkmang ngaye dja kabirrikangerayek ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Bonj, yuwn bu kandenghke, dja kanbawon ba wanjh ngayiddung duninjh bedberre bu ngabenbularrbun. Ngudda yiwid, dja ngaleng marnbun ngudda ba yibenkebmawahme birribuyika bininj birridjalwern, dja kabirrimirndewernmerren dja mak kabirringeykimuk.” ");
INSERT INTO gup_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Wanjh Moses yimankek bimarnbuyi nawu Yawey, nawu God nuye, bu kabenkongibunkenh. Wanjh yimeng, “Ngudda nawu Yawey, bu kundulkarre dorrengh yibenbebkeng birrimekbe bininj nawu Israel benkebmawahmeng kore Egyptbeh. Bu kore kubid ke dja kunngudjkimuk ke yibenbebkeng. Dja njalekenh bu yiyiddung dja yibenbun? ");
INSERT INTO gup_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Dja bu kunmekbe yikurduyime, wardi bininj nawu Egyptbeh kabirriyime, ‘Njalekenh Yawey benbebkeng kore birrihbongdi dja benkang kore kuwarddewardde kumekbe benbularrbom rowk?’ Wanjh ngaye djawadjawan bu yuwn yiyiddung, dja yibawo. Yimayaliborledmen dja yuwn bu yibenbularrbun nawu bininj ngudda ke. ");
INSERT INTO gup_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Yiburrbu kore ngudda yiwokkurrmerrinj bedberre Abraham, dja Isaac dja Jacob. Ngudda yingeykurrmerrinj bu yibenmarnewokkurrmerrinj, yiyimeng, ‘Kalukburrk ngaye wanjh ngabenmarnbun nawu mawahmawah ngudberre bu kabirrimirndeyimerran yiman kayime mankokkarrng kawernmerren kore kunngol, dja mak ngabenbolkwon kore ngabenbolkberrebbom, ba bu mawahmawah bedberre wanjh kabirribolkkarrme mahni kunred bu munguyh munguyh.’” Kuhni bu Moses bimarneyimeng nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Wanjh kunmekbekenh nawu Yawey mayaliborledmeng, dja minj benbuyi birrimekbe bininj kore nungka benyingkihbengdayhkeng bu benbularrbuyikenh. ");
INSERT INTO gup_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Wanjh Moses yawoyhkoluy kore kuwarddekimukbeh, kaluk kumyikoluy dja karrmi kubid nuye manwarddebalabala bokenh manbu bimbuyindi kumirrk dja kubodme ngarre manbu kunwok kunwoybuk nuye bu Yawey wokkurrmerrinj. Namekbe manwarddebala bokenh wanjh God nungan marnbom. Nungan mak bimbom mankarre nuye, bu warddedadjkeng kore maninjmanu kunwardde. ");
INSERT INTO gup_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kaluk Joshua benbekkang bu birrikayhkayhmi birrimekbe bininj, wanjh bimarneyimeng Moses, “Ngabekkan nakka yiman nuk kabirrihburren kore kured yiman nawu birriyidko bininj bindimarnebebmeng!” ");
INSERT INTO gup_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Wanjh Moses yimeng “Burrkyak. Nakka minj kabirrihburren. Minj kabirrihkayhme bu bindibom birribuyika bininj. Dja nakka wanjh kabirrihdjalwayini kore ngabenbekkan.” ");
INSERT INTO gup_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Bu Moses bebmihbebmi darnkih kore kured, wanjh nungka nang namekbe bulikki yaw idol, dja mak bennang nawu bininj birriborrkkeyi. Wanjh nungka yidduy duninjh dja mak wohburriweng manmekbe kunwardde bokenh dja warddebarrabarrmeng kore kurorre darnkih kore kanjdjikah kuwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Wanjh mey namekbe bulikki yaw idol dja kinjeng ba wirlmurrng gold yawoyhyimerranj dja djulngdongohdoy marnbom yiman kundjulng, wanjh rawong kukku dorrengh, benmarnbom bininj nawu Israel benkebmawahmeng bu birribonguneng manmekbe kukku manbu gold dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Wanjh Moses bidjawam Aaron, “Baleh nahni bininj birrikurduyimeng ke bu ngundimarnbom yibenkang kore kuhni birrikurduyimeng kunwarre duninjh?” ");
INSERT INTO gup_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Wanjh biwokmey yimeng, “Nawu Kanmarnewohrnan, yuwn ngaye kandung! Ngudda yiburrbun bu birrimekbe bininj kabirridjare bu kabirrihdjalkurduyime kunwarre! ");
INSERT INTO gup_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bedda mak ngandimarneyimeng, ‘Namekbe Moses nawu nganbebkeng ngadberre kore Egyptbeh, wanjh minj ngarriburrbun bu baleh bimarnekurduyimerranj nuye. Kab ngudda yimarnbu kadberre god nawu kanmarnedokme kadberre.’ ");
INSERT INTO gup_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Wanjh ngabenmarneyimeng bu birrimkang nawu kabirrihkanemdjongbuyindi. Wanjh bedda birrikanemyerrkyerrkkerrinj dja ngandiwong wanjh ngaburriweng kore kunak, dja wanjh nahni mayh kukbebmeng!” ");
INSERT INTO gup_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Kaluk Moses wohburrbom bu Aaron benbawong birrimekbe bininj bu birridjalkurduyimi kore bedman birridjaldjareni, dja minj birriyawoyhwokmayi nuye. Dja bedda birriwarreworrinj dja benmarnbom nawu kabirriyidko bedberre bu bindidjekmiwong. ");
INSERT INTO gup_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Wanjh Moses dolkkang danginj kore kurrangmaye ngarre kunbolk kore birrihni, dja kayhmeng, yimeng. “Birringalehngale nawu Yawey nuye bininj, wanjh nakka birrimray kondah kore ngaye!” Wanjh bininj rowk nawu Levi benkebmawahmeng birrimdolkkarrinj birridangerrinj kore Moses dingihdi. ");
INSERT INTO gup_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Wanjh Moses benmarneyimeng birrimekbe bininj nawu Levi benkebmawahmeng, “Yawey nawu God nuye Israel benkebmawahmeng rowk, kuhni wanjh kayime, ‘Bininj rowk ngurrima sword dja ngurribarnkurrmen kore ngurringadmodukkarren. Wanjh ngurriray kore kurehrered ngudberre dja ngurrbenbu nawu ngurridanginj dja nawu djawirna ngudberre, dja mak nawu ngurriredbo bininj.’” ");
INSERT INTO gup_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Wanjh nawu Levi benkebmawahmeng birrikurduyimeng kore Moses benwokrayekwong. Wanjh kunmekbe kunbarnangarra birriwern bininj birridoweng yiman 3000. ");
INSERT INTO gup_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Wanjh Moses benmarneyimeng, “Bolkkime ngudda ngurrikurrmerrinj bu ngurriyimerranj djal Yawey nuye bininj. Ngudda ngurriwokmarrkmey dja ngurrbenbom beybeywurd dja nawu ngurridangerrinj ngudberre. Kunmekbekenh kunu nawu Yawey ngunmarneyimeng kunmak ngudberre bolkkime.” ");
INSERT INTO gup_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Wanjh bu kunbarnangarrabuyika Moses benmarneyimeng bininj rowk, “Ngudda ngurrikurduyimeng kundjalwarre duninjh. Dja wanjh bolkkime ngabidbun kuwarddekimuk kore Yawey dja ngadjawadjawan nungka bu wardi ngunmarnebengmidjdan ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Wanjh Moses durndi kore Yawey dja bimarneyimeng, “Birrimekbe bininj bedda wanjh kunwarre kunkimuk birriyimeng. Bedda wanjh birrimarnbom idols manbu gold duninjh, nawu yimankek gods bedberre. ");
INSERT INTO gup_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Dja bolkkime wanjh ngaye djawan bu yimarnebengmidjdan kunwarre bedberre. Dja bu burrkyak, wanjh kanngeybularrbu ngaye kore nawu djurra yibenngeybimbom ngudda ke bininj rowk.” ");
INSERT INTO gup_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Wanjh Yawey bimarneyimeng Moses, “Ngaye ngabenngeybularrbun kore djurra ngardduk nawu kunwarre birrihyimi dja minj ngaye ngandiwokmarrkmayi. ");
INSERT INTO gup_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Dja wanjh yiray, yibenka nawu ngaye ngardduk bininj kore ngabolkyolyolmeng ke, kaluk yiburrbu bu angel ngardduk karrokorrokme ngudberre. Kaluk bu rerrihkah ngaye wanjh ngabenbun birrimekbe bininj kore kunwarre birrihyimi.” ");
INSERT INTO gup_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kaluk yerrekah Yawey munkeweng kundjak kunkimuk bu benbuni nawu Israel benkebmawahmeng. Nungka benduy bu bedda birridjirrkkang Aaron bu benmarnemarnbom nawu bulikki yaw nawu gold wirlmurrng duninjh. ");
INSERT INTO gup_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Wanjh Yawey bimarneyimeng Moses, “Mah, yibolkbawo kondah kore ngurrihni, ngudda dja bininj yibenbebkeng kore kunbolk Egyptbeh. Dja wanjh ngurriray kore kunred ngaye ngabenberrebbom bu ngawokkurrmerrinj bedberre nawu mawahmawah ngudberre Abraham, Isaac dja Jacob dja mak bedberre nawu kabindimawahme. ");
INSERT INTO gup_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ngaye kaluk ngamunkewe angel bu kahdokdokme ngudberre ba ngunbolhbukkan, dja ngabendjirrkkan nawu kumekbe kabirrihni nawu Canaan benkebmawahmeng, dja bininj nawu kabirringeyyo Amor, dja nawu Heth benkebmawahmeng, dja mak nawu kabirribebbehngeyyo Periz dja mak nawu Hiv, dja mak nawu birrikang kunred Jebus. ");
INSERT INTO gup_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Kab ngurridjallay kunmekbe kore mahni kunbolkmak, kore manme kawernmerren ngudberre. Dja bonj, ngaye minj mak karridjarrkre. Wardi wohbun ngudberre kore manbolh ngurrire, dja wanjh ngudda nawu kandidjalwokburriwe ngaye munguyh.” ");
INSERT INTO gup_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Bu nawu Israel benkebmawahmeng birribekkang manmekbe kunwok kunrayek, bedda wanjh birriwernhnjilngwarreminj, dja minj birrihdjongbuyindiwirrinj nawu namakmak jewelry dorrengh, ");
INSERT INTO gup_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kuhni wanjh Yawey biyingkihmarneyimeng Moses, “Yibenmarneyimen nawu Israel benkebmawahmeng bu bedda munguyh ngandjalwokburriwe ngaye. Bu ngaye ngabenmikayi ngarridjarrkreyi bu djalkundedjumbung, nakka wanjh ngabenbun. Dja bonj, birriyerrkyerrkkerrimen nawu jewelry, wanjh kaluk ngayeman nganjilngmarnburren bu baleh ngakurduyime bedberre.” Kuhni bu Yawey bimarneyimeng Moses bedberre. ");
INSERT INTO gup_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Wanjh nawu Israel benkebmawahmeng birriyerrhyerrkkeng nawu jewelry bedberre rowk kore birrihni kuwarddekimuk Sinai. Dja bu birribolkbawong birrirey, wanjh minj munguyh birriyawoyhdjongbuyindiwirrinj nawu jewelry. ");
INSERT INTO gup_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Nungka Moses munguyh kani nawu dabburlin nuye, wanjh djabnami djarrehkah kore kabirrihyongoyo kured. Kaluk Moses ngeykurrmeng namekbe dabburlin, “Dabburlin manbu kore Yawey karridabkerrenkenh”. Dja nangale nawu djareni kabidjawan Yawey nawu yiman njale djareni wanjh wam kore mahni “Dabburlin manbu karridabkerren Yawey” kore djarrehwurd kuberrkkah kore birrihyoy. ");
INSERT INTO gup_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Dja yiman baleh yarrkka Moses rey kore namekbe dabburlin, wanjh birriwern bininj birridolkkarrinj dja birridangerrinj kore kurrangmaye bedberre dabburlin rowk, dja birribalmunkenang Moses bu balngimeng kore mahni dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Bu Moses balngimi kore dabburlin nuye, wanjh manbu kunngol kunkuyeng kumngolkolungi wanjh dangeni kore kurrangmaye ngarre manmekebe dabburlin bu Yawey benewokdi Moses. ");
INSERT INTO gup_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bu bininj nawu Israel benkebmawahmeng birrinani manmekbe kunngol kumkolungi dja danginj kore kurrangmaye ngarre dabburlin, wanjh bedmanwali birriboddanginj, bebbehbeh rowk kumekbe kore kurrangmahdangmaye bedberre dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Wanjh Yawey benehwokdi Moses kaluk benemirrknarrinj bu benehwokdi yiman kayime bininj nawu djawirna bokenh kabenehwokdi. Wanjh bu beneyakwoni bu benehwokdi wanjh nungka Moses durndengi kured. Dja bininj nawu bibidyikarrmeng Moses minj bolkbawoyi kore dabburlin. Kaluk nungka wanjh Joshua nawu Nun bibornang. ");
INSERT INTO gup_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Wanjh Moses bimarneyimeng Yawey, “Ngudda kanmarneyimeng bu ngaye ngabenkan nahni nawu bininj dja minj yiyimeninj bu nangale yimunkewe ba nganedjarrkre. Dja mak ngudda kanmarneyimeng, ‘Ngaye burrbun ngudda dja mak ngeyburrbun ke, dja mak ngaye nganjilngmak ke!’ ");
INSERT INTO gup_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Bu ngaye njilngmarnbom ke, wanjh kanbukkabukka manbu ngokko yikarremarnbun, ba ngaye wanjh burrbun ngudda, dja mak ba kanmarnenjilngmak munguyh. Yiburrbu bu nahni birriwern bininj nawu ngabenmirndekan, wanjh nakka ngudda ke bininj.” ");
INSERT INTO gup_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Wanjh Yawey biwokmey yimeng, “Ngaye kaluk karridjarrkre, dja mak won ngudberre ba ngurringehme.” ");
INSERT INTO gup_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Wanjh Moses bimarneyimeng, “Bu ngudda minj karridjarrkre, wanjh yuwn kankukmunkewe ngadberre bu ngarribolkbawon kondanjkunu. ");
INSERT INTO gup_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Dja bu ngudda minj karridjarrkre, wanjh minj nangale mak kaburrbun bu ngudda yinjilngmak ngadberre, ngaye dja nawu ngudda ke bininj rowk. Dja bu ngudda minj karridjarrkre ngaye dja nahni ngudda ke bininj, wanjh minj ngarribuyikaworren bedberre nawu birribuyika bininj rowk nawu kondah kabirrihni kore kurorre.” ");
INSERT INTO gup_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Wanjh Yawey bimarneyimeng Moses, “Mah! Ngaye wanjh ngakurduyime kunmekbe kore ngudda kandjawam, dja mak kannjilngmarnbun ngardduk, dja mak ngeyburrbun ngudda.” ");
INSERT INTO gup_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Wanjh Moses yimeng, “Bolkkime wanjh kanmarnekukbukkarrimen ba nan bu ngudda yidjalwernhmakkaykenh.” ");
INSERT INTO gup_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Wanjh Yawey bimarneyimeng Moses, “Ngaye nawu Yawey wanjh bukkan ngardduk kunmakmak rowk kore kumirrk ke, dja ngangeymulewarren ngardduk ba kanngeybekkabekkan. Ngaye ngadjalkongibun bininj nawu ngadjare, dja nangale nabuyika bu wardi ngabendjalwarnyak, wanjh minj ngabenkongibun. ");
INSERT INTO gup_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Dja med, ngudda ngaleng minj kankebnan ngaye. Bu nangale nakka djal bininj nawu ngankebnan nakka wanjh bonj, karrowen.” ");
INSERT INTO gup_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Wanjh Yawey yawoyhyimeng, “Manbu kunwardde kahdi kaluk darnkih kore ngaye, wanjh kumekbe yibarndin. ");
INSERT INTO gup_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Dja bu kunwernhmakmak ngardduk ngunyurrhke kumekbe, wanjh ngaye kurrme kore kahwarddebarrarn yerre wanjh kukbalhme kunbid ngardduk bu kumekbe yurrhke. ");
INSERT INTO gup_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kaluk bu ngabidwayhme wanjh kunbodmewi kandjalbodmenan, dja manbu kunkeb makka yuwn nangale kankebnan.” ");
INSERT INTO gup_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Wanjh Yawey bimarneyimeng Moses, “Yiyawoyhdadjdadjke bokenh kunwardde manbalabala, yiman yimi manbu manyungkihni, dja kaluk ngayawoyhbimbun karohrok bu bimbuyindi maninjmanu manyungkih kunwardde, manbu ngudda yibakkeng. ");
INSERT INTO gup_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Bu malamalaywi, wanjh yiyingkihmarnburrimen bu kukabel, dja yimbidbu kore kaddum mahni kunwarddekimuk. Kaluk kumekbe yikurrmerrimen kore kumirrk ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Minj nangale mak ngunemdjarrkre dja mak minj nangale karri darnkih kore kuwarddekimuk. Yiman mak kayime nawu mayh kumirnde, nakka mak minj kundalk kangun darnkih kore kuwarddekimuk.” ");
INSERT INTO gup_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Wanjh Moses dadjkeng bokenh kunwardde manbalabala, yiman yimi nawu kerrngehkenh karrmihkarrmi. Wanjh bu kumhkabelni nungka dolkkang, wanjh warddebidbom, yiman bu Yawey bimarneyimeng, dja mak kang kunbid nuye, dja yibidbom manbu kunwardde bokenh. ");
INSERT INTO gup_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kaluk kumekbe nungka Yawey kumkoluy kunngol dorrengh wanjh benehdjarrkdi Moses, wanjh Yawey ngeymulewarrinj nuye kunngey. ");
INSERT INTO gup_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Wanjh Yawey bimirrkyurrhkeng Moses dja yimeng, “Ngaye wanjh Yawey. Ngaye Yawey nawu God, dja ngaye ngamimkongiwern duninjh, dja ngabenmarnekurduyime kunmak bedberre bininj rowk bu djal burudjang. Minj ngayiddung werrkwerrk dja ngaleng ngaye munguyh ngabenmarnedjare bininj rowk, dja minj mak ngakurren bu kowe. ");
INSERT INTO gup_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ngabendjalmarnedjare munguyh birridjalwern rowk nawu bininj. Ngabenmarnebularrbun kunwarre bedberre nawu ngandiwokburriwe dja kabirriyime kunwarre. Dja bonj, ngaleng wanjh ngabenbun bininj nawu kabirridjaldjare kunwarre kabirriyime. Kaluk ngabenbun mawahmawah bedberre nawu birrimekbe birriwarre bininj bu kunmekbe kunwarrekenh. Kaluk bedmanwali ngabenbun nawu kunwarre kabirrihdjalyime dja mak wurdwurd bedberre dja mak mawahmawah dja doydoyh kabindihyime.” Kuhni rowk yimeng nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Wanjh kundjalmekbe rerrih Moses boddanj kore kurorre dja wanjh biburluburlumi nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Moses yimeng, “Ngudda nawu yiwohrnan rowk, bu ngudda yinjilngmak ngardduk, wanjh karridjarrkray ngaye dja mak nawu nahni bininj rowk. Ngaye ngabenburrbun nahni bininj minj kabirridjare ngundiwokmarrkmang, dja djawan ngudda kanmarnebengmidjda ngadberre nawu nawarrehwarre ngarrikarrme dja ngadberre kunwarre. Dja kanka ngadberre ba ngarriyimerran ngudda ke bininj duninjh.” ");
INSERT INTO gup_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Wanjh Yawey yimeng, “Ngaye ngawokkurrmerren ngudberre. Ngaye wanjh ngakurduyime kunkimuk duninjh kundulkarre ngardduk dorrengh kore kumirrk ngudberre. Ngakurduyime manbu minj nangale nabuyika bininj nayi kondah kore kurorre dja kore kubolkbubuyika rowk. Dja mak nawu bininj ngurrihdjarrkdi, wanjh nakka kabirrinan ngardduk kundulkarre. Ngaye, nawu Yawey, wanjh ngadjalkurduyime kunmakmak ngudberre dja wanjh ngurrikangebarrhme. ");
INSERT INTO gup_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Dja bu kandiwokmarrkmang kore wokrayekwon bolkkime, wanjh nakka ngabenkelekadjung ngudberre nawu bininj rowk, ngayime nawu kabirringeyyo Amor, dja nawu Canaan benkebmawahmeng, dja nawu Heth benkebmawahmeng, dja mak nawu kabirribebbehngeyyo Periz, dja mak Hiv, dja nawu birrikang kunred Jebus, dja ngaleng ngurridjalkurduyime bu ngaye marneyime ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Kaluk bu ngurringime kunbolkbubuyika bedberre birrimekbe bininj, wanjh yuwn bu ngurriwokmarnburren bedda dorrengh, wardi ngundidarrkidmang kore kungarlkwarre. ");
INSERT INTO gup_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Dja wanjh ngurribakbakemen bedberre altars, dja manbu kunwardde kore kabirrimarneboddan nawarre, dja ngurridjobkemen kundulkdjamun ngalengngarre god ngalbu ngaldaluk kangeyyo Asherah. ");
INSERT INTO gup_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Dja mak yuwn ngurrimarneboddan nabuyika god, dja ngaye nawu Yawey wanjh ngadjalkudji God ngudberre, dja ngaye yiman kayime ngakirnwern ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Dja mak ngurrinahnarrimen bu minj ngurriwokmarnburren nawu bininj kumekbe kunbolk kabirrihni. Wardi mak bu kabirrimarneboddan nawu gods bedberre dja kabirribun mayh bu kabindiwon bedberre nawu god, wanjh ngundidjawan bu wardi ngurriraworren dja ngurribalmarneboddan nawu bedberre gods dja mak ngurridjarrkngun mulil nawu kore mayh kabirrikinje gods bedberre. ");
INSERT INTO gup_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Dja ngurrinahnarrimen warridj bu ngurrbenmang yawkyawk nawu kumekbe kabirrihni ba bu ngurrbenwon nawu nabebeywurd ngudberre bu kabirrimarrenkenh, wardi birrimekbe yawkyawk wanjh kabirridjalmarneboddan bedberre gods, dja wardi kabindimarnbun bebeywurd ngudberre bu kabirriraworren dja kabirridjarrkboddan namekbe nawu gods. ");
INSERT INTO gup_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Dja mak yuwn ngurrimarnbun idols bu kore ngurrikinje nawu wirlmurrng bu ngurrikukmarnbun idol nawu god.” ");
INSERT INTO gup_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Dja ngaleng ngurrimulilma mulil manbu buriddi minj kakarrme mannguklurlmikenh. Kaluk bu kunkodjke seven wanjh kunmekbe ngurringun manme manbu minj kakarrme manbu kahnguklurlke kandidjawa kore ngaye wokrayekwong ngudberre. Kuhni bu ngurrikurduyimen kore ngaye dungnameng ngudberre, yiman dird nawu kangeyyo Abib, dja namekbe dird bolkyimeng bu ngudda ngurrimbebmeng kore Egyptbeh.” ");
INSERT INTO gup_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nawu ngalbabadjan kabindihkarrmehkarrme kaluk nadjahnadjaman nakka wanjh ngaye ngardduk rowk bininj, yiman mak mayh nawu nadjaman kaluk nawu kahdangerren kore yihmirndekarrme ke. ");
INSERT INTO gup_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Bu ngurridjare ngurribayahme nadjaman nawu donkey wanjh kandikarremulewan nakudji lamb, dja bu minj yidjare yirrurndiwe namekbe nawu donkey yaw wanjh yidjudbakkemen. Dja mak ngurrbendurndiwemen bu ngurrbenkukbayahmen nawu nadjahnadjaman nabebeywurd bininj ngudberre.” “Minj nangale mak kamre karrangen kumirrk ngardduk bu djal bidlarrk.” ");
INSERT INTO gup_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Kaluk ngudda ngurridjaldurrkmirri bu six kunkodjke, dja manbu kamarnburren kunkodjke seven makka wanjh ngurringehmen. Kaluk bu yiman ngurrihdudjeng manme ngarre kabolkyime, dja mak bu kabolkyime kore ngurridjolengmang manme, bonj, kunmekbe ngurridjalngehmen bu kunkodjke seven.” ");
INSERT INTO gup_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ngurrimulilma ngarre mulil manbu Djandikenh, bu ngurrimoyhmang manbu manyungkih manme manbu wheat bu ngurridjolengmang, dja mak ngurrimulilma ngarre kudjurlekenh kayimerran, dja ngurrimang manbu mandjoleng kore kabarndi.” ");
INSERT INTO gup_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Kaluk bu mandjewkbubuyika, wanjh binihbininj rowk ngudberre birrimbebmen danjbikkah bu kandimarneboddan kore kumirrk ngardduk, ngaye Yawey nawu Ngabenmarnewohrnan Rowk nawu God ngudberre nawu Israel ngunkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Bu ngurribolkbawon ngudberre kunred, dja ngurrimre rowk kore maninjmanu mulil danjbik, wanjh yuwn ngurriburrbun bu birribuyika bininj kabirribolkdjirdmang ngudberre. Burrkyak, dja ngabenngurdke. Ngaye ngabenkukburriwe bininj rowk nawu bolkkime kabirrihni kubolkbubuyika ba bu ngurringimen ngurribolkkarrme, dja mak ngabolkwarlahwon kunred ngudberre.” ");
INSERT INTO gup_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Bu kandiwon mayh, dja ngurrikinje kore altar, yuwn bu kumekbe kandiwon buriddi manbu mannguklurlmikenh kakarrme dorrengh. Dja mak bu ngurrikarrme mulil manbu ngaye darrkidbawongkenh, wanjh yuwn bu ngurrikarekurrme yikahwi manme bu kunkodjkebuyikakenh.” ");
INSERT INTO gup_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ngaye nawu Yawey ngudberre God dja ngudda wanjh ngurrimka kore ngaye yikahwi manme manyungkih bu ngurridedjingmang ngurrimoyhmang.” “Dja mak yuwn ngurrikinje nawu sheep yaw, dja yika goat yaw, wanjh yuwn bu ngurrikinje kore ngalbadjan ngalengngarre kundjikkakenh.” ");
INSERT INTO gup_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Wanjh Yawey bimarneyimeng Moses, “Yibihbimbu nahni kunwok rowk, dja ngaye ngawokkurrmerren kore namekbe kunwok rowk bedberre nawu Israel benkebmawahmeng, dja mak ngudda ke warridj.” ");
INSERT INTO gup_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Kaluk Moses yerrkang bu kunkodjke forty dja kunkak forty, kore kuwarddekimuk bu Yawey benehdjarrkdi. Kaluk minj kukku bonguyi dja mak manme minj nguyi bu kumekbe dingihdi. Wanjh kumekbe Moses bihbimbom kore kunwardde manbalabala kunwok rowk nawu Yawey wokkurrmerrinj nuye, manbu Kunbidbokenh Mankarrekihkimuk. ");
INSERT INTO gup_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moses wanjh nungka kumyikoluy kore Kunwarddekimuk Sinai, bu karrmi kubid nuye kunwardde bokenh manbalabala manbu bimbuyindi kunwok kunwoybuk nawu Yawey wokkurrmerrinj. Dja Moses wanjh kebbami duninjh bu kunmekbekenh nungka benehwokdi Yawey, dja minj mak burrbuyi bu nungan kebbami. ");
INSERT INTO gup_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Bu Aaron dja birribuyika bininj nawu Israel benkebmawahmeng birrinang Moses, wanjh minj birridarnhrawinj kore nungka, dja birrikebnang nuye bu kebbamibami duninjh dja wanjh birridjalkeleminj. ");
INSERT INTO gup_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Dja Moses benkayhmeng bedberre Aaron dja mak nawu bindiwohrnawohrnani kore binihbininj rowk, wanjh birridurndi bu darnkih nuye, dja nungka benmarnewokdanginj bedberre. ");
INSERT INTO gup_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Kalukburrk bininj rowk nawu Israel benkebmawahmeng birriyikang darnkih. Dja wanjh Moses benwoni mankarre rowk manbu kore Yawey biwong bu benewokdi kore kuwarddekimuk Mount Sinai. ");
INSERT INTO gup_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kaluk bu yakwong kore benmarneyolyolmi, wanjh nawu Moses nungan kebbarrkburrinj manburrbawi. ");
INSERT INTO gup_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Dja bu nungka ngimi manbu dabburlin bu kabenewokdi nawu Yawey, wanjh kebwerrhmerrinj nawu kore kebdjongbuyindi kaluk bu benewokdi nawu Yawey kaluk bu kumyawoyhbebmi. Bu bebmi wanjh benmarneyolyolmi nawu Israel benkebmawahmeng kore baleh Yawey biwong dja bimarnerayekwong bu Moses kabenwon. ");
INSERT INTO gup_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Kaluk bedda birridjalkebnani bu djalkebbami. Bu yakwong kore benmarneyimeng, wanjh nungka yawoyhkebbarrkburrinj kaluk yerrekah kakebwarrhmerren bu yawoyhngimi bu Yawey kabenewokdi. ");
INSERT INTO gup_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses benmornnameng rowk bininj nawu Israel benkebmawahmeng wanjh benmarneyimeng, “Kuhni kunwok wanjh nawu Yawey ngunwokrayekwong ngudberre, dja ngaye marneyime kore nungka nganwokwong ngudberre. Nungka yimeng, ");
INSERT INTO gup_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‘Ngudda ngurrikarrme six kunbarnangarra ba bu ngurridurrkmirri. Dja manbu kahmarnburren kunbarnangarra seven, makka wanjh kunbarnangarradjamun ngudberre. Kaluk makka ngaye ngardduk bu kunmak kandimarneyime dja kunu ngurringehmen. Dja nangale nawu karrurrkmirri bu kunbarnangarradjamun, nakka wanjh ngurribu. ");
INSERT INTO gup_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Dja mak yuwn ngurriwurlhke kunak bu karung kore kured ngudberre bu kunmekbe kunkodjke Sabbath.’” ");
INSERT INTO gup_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Wanjh Moses benmarneyimeng nawu Israel benkebmawahmeng rowk kore birrimirnderri, yimeng, “Kuhni wanjh nawu Yawey kanwokrayekewong. ");
INSERT INTO gup_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Njalehnjale nawu ngurrihkarrme, wanjh yika ngurrikan ngurriwon Yawey. Bu ngurridjare wanjh ngurrimkan ngurriwon nuye Yawey manbu wirlmurrng, yiman gold, silver, dja bronze. ");
INSERT INTO gup_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Dja mak bu ngurridjare wanjh ngurriwo Yawey manburrba linen namakmak, dja mak kunyarl manbu kukblue, kukpurple dja mak kukkurlba, dja mak manburrba birrimarnbom goat kunngabek dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Dja nuk ngurrimka kunkulah nawu narangem sheep kaluk birrimarnbom kakukkurlbamen. Dja mak ngurrimka kunkulah ngarre marndingunjngunj, dja mak kundulk manbu acacia. ");
INSERT INTO gup_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Dja mak ngurrimka manbu olive kunkalkkid ngarre lamps, yika manbu spices bu kabirrirawon kunkalkkid ngarre olives ba bu kabirrikodjbarung nawu priests, dja mak kunkalkkid manbu ngurrimarnbun incense manbu mankalkkidmanjmak. ");
INSERT INTO gup_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Dja mak ngurrimka manwarddemak yiman onyx, dja mak nabubuyika nawu jewels bu kabirrikurrme kore ephod nawu nakimuk priest nuye, dja mak kore nawu kabenhberrekalkbalhme nuye.” ");
INSERT INTO gup_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Wanjh Moses yawoyhwokdi benmarneyimeng nawu Israel benkebmawahmeng, “Ngudda nawu ngurriwernhburrbun nawu ngurrimarnmarnbun njalehnjale wanjh ngurrimray ngurrimarnbu njalehnjale rowk kore Yawey kanwokrayekwong kadberre. ");
INSERT INTO gup_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ngayime nawu Manrurrkdjamun Dabburlin kuberrkkah, dja mak nawu kaddum kahbalhme nawu dabburlin, ngayime nawu nginj, dja nawu kundulk frames, dja mak mandulkdjad, dja nawu mandulk bu kabirridjabname, dja mandadkenh ngarre. ");
INSERT INTO gup_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Dja mak manbu Ark, dja mandulkkuyeng ngarre manbu kabirriwayhkekenh, dja mak manbu kaddumkah ngarre dorrengh, dja nawu manburrba nawu kawelhwelme kore kumirrk ngarre. ");
INSERT INTO gup_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Dja mak ngurrimarnbu manbu manbalabala table, dja kundulk bokenh mankuyeng bu kabirrikanakankenh, dja mak njalehnjale nawu ngarre kore manbalabala kabarnhbarndi, dja mak kandidjawa manbu kanhbengdayhke kadberre bu God kumwam karridjarrkdi; ");
INSERT INTO gup_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","dja mak lampstand bu kabolkwolkankenh, dja nawu njalehnjale ngarre dja mak kunkalkkid ngarre; ");
INSERT INTO gup_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","dja mak manbu altar kore kabirrikinje mankalkkidmanjmak, dja mak mandulkkuyeng ngarre nawu kabirrikanakankenh, mak kunkalkkid manbu karrbenkodjdjuhkekenh, dja mak manbu mankalkkidmanjmak ngarre. Dja mak manburrba manbu kawelhwelhdi kore kurrangmaye ngarre Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Dja mak ngurrimarnbu nawu altar ngarre kore mayh kabirrimarnekinje nuye Yawey, mak nawu ngarre wirlmurrng bronze screen kaluk mandulkkuyeng, dja mak nawu tools ngarre, dja mak wirlmurrng bronze banikkin nakimukkenh, dja ngarre mandadkenh. ");
INSERT INTO gup_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Dja mak ngurrimarnbu manburrba manbu kawelhwelhdi ngarre kuberrkkah manbu Manrurrkdjamun Dabburlin, dja nawu kundulk nawern kadjabdi dja mak manbu mandadkenh ngarre, dja mak manburrba ngarre kore kabirribalhngimen kumekbe ngarre kuberrkkah. ");
INSERT INTO gup_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Dja mak ngurrimarnbu tentpegs ngarre kanjdjikenh ngurridjabname manbu Manrurrkdjamun Dabburlin, dja mak kore kurberrkkah ngarre, dja mak kunyarl ngarre. ");
INSERT INTO gup_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ngurrimarnbu manburrba ba bu ngurrimadjmarnbu kunmadj kukdjamun ba bu Aaron dja nawu nabebeywurd nuye kabirridjongburren bu kabirridurrkmirri yiman priests kore Yawey nuye kubolkdjamun.” ");
INSERT INTO gup_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Wanjh bu Moses yakwong yolyohyolyolmi bedberre nawu Israel benkebmawahmeng, bedda wanjh benbawong dja birriwam. ");
INSERT INTO gup_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Wanjh nawu birridjareni birrimkang birrimarnekurrmeng nuye Yawey namakmak ngarre Manrurrkdjamun Dabburlin kore nawu Yawey kamre bu kabendjahwon bedberre. Dja mak bedda birrimkang njalehnjale ngarre yiman kunmadj nawu priests bedberre namekbe dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Birridjalwern nawu bininj dja daluk birrimkang njalehnjale namakmak nawu gold jewelry pins, earrings, rings dja bracelets. Kaluk bedda birridjareni dja birrikurrmeng rowk bu birrimarnewayhkeng kunbid bedberre kore kumirrk nuye Yawey. ");
INSERT INTO gup_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Dja mak bininj nawu birrikarrmi kunyarl manbu kukblue, dja kukpurple dja kukkurlba, dja linen manburrbamak, dja nawu birrikarrmi nanikud kunngabek dja yika narangem sheep kaluk kunkulah dja medjyimi mankurlba, kunkulah ngarre marndingunjngunj, wanjh bedda birrimkang rowk bu birrimarnekurrmeng kore Yawey. ");
INSERT INTO gup_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Birriwern birrimkang rowk nuye Yawey wirlmurrng nawu silver dja bronze, dja mak bininj rowk nawu birrikarrmi acacia kundulk birrimkang bindiwong nawu birridurrkmirri kore Manrurrkdjamun Dabburlin birrinami. ");
INSERT INTO gup_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Dja mak daluk nawu kabirriwernhburrbun wanjh birrimarnbuni kunbidwi bedberre yiman kunyarl medjbuyika yiman kukblue, kukpurple dja mak kukurlba, dja mak manburrbamak linen, wanjh birrimkang bindiwong. ");
INSERT INTO gup_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Dja mak daluk rowk nawu birrikurdumakni bu birrimarnbuni kunyarl kaluk nanikud kunngabek nuye, wanjh birrimarnbuni kore birridjareni. ");
INSERT INTO gup_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Dja nawu kabirriwohrnawohrnan bininj wanjh nakka birrimkang manwarddemak onyx dja nabubuyika jewels bu kabirrikurrme ngarre ephod dja nawu kabihberrekalkbalhme nawu priest. ");
INSERT INTO gup_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Dja mak birrimkang manbu spices dja olive kunkalkkid ngarre lamps, dja mak kunkalkkid manbu kabindikodjdjuhkekenh, dja mak ngarre kunkalkkid manbu mankalkkidmanjmak ngarre. ");
INSERT INTO gup_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Wanjh birridjalwern rowk bininj nawu Israel benkebmawahmeng birrimkang nawu namakmak birrikarrmi bu birriwong nawu Yawey. Bedda birridjareminj bu birrikurduyimeng, bininj dja mak daluk ba bu birridurrkmirri dja birriyakwong rowk kore Yawey benmarnewokwong bedberre bu biyingkihmarneyimeng nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Wanjh Moses benmarneyimeng nawu Israel benkebmawahmeng, “Ngurrina! Nungka Yawey bidjarrngbom nakudji bininj nawu kumdolkkang kore namud nuye Judah. Nahni bininj nawu Bezalel nawu beywurd nuye Uri, dja nawu Hur bikebmawahmeng. Bedda wanjh nawu Judah benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Kaluk Yawey bikukbarlkeng Namalngmakkaykenh nuye God dja biwong kunmayali ba bu kawernhburrbun bu kamarnmarnbun njalehnjale manwern manbubuyika. ");
INSERT INTO gup_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","33","Nungka wanjh nakurdumak bu kawernhburrbun bu kamarnbun yehyeng nawu kore wirlmurrng gold, silver dja bronze, dja mak kadjobdjobke kunwardde, dja mak jewels wanjh kabalkurrme kore wirlmurrng, dja kundulk kamarnbun dja mak kunbubuyika warridj nungka kamarnbun. ");
INSERT INTO gup_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Yawey wanjh benbenedjarrngbom Bezalel dja mak nabuyika bininj nawu kangeyyo Oholiab ba bu benemekbe bininj kabindibalbukkan nawu birribuyika bininj warridj. Oholiab nakka wanjh kamdolkkang kore namud nuye Dan, dja beywurd nuye Ahisamach. ");
INSERT INTO gup_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Yawey wanjh benbukkabukkang birrimekbe birriwern bininj ba bu kabirrimarnbun nawu njalehnjale dja mak kabirrikarrebimbun kore kabirrihdadjke wirlmurrng dja kunwardde. Wanjh bedda mak kabirribibbun kore linen manburrbamak, kaluk karaworren kunyarl manbu kukblue, kukpurple dja mak kukkurlba. Bedda wanjh birrikurdumak rowk.” ");
INSERT INTO gup_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Wanjh Moses benyolyolmeng dja benmarneyimeng, “Nahni bininj nawu Bezalel, dja mak nawu Oholiab dja mak birribuyika birriwern bininj nawu Yawey benmarnbom birrimayalimakminj dja birrikurdumakminj ba bu kabirrimarnbun manbu Yawey nuye Manrurrkdjamun. Bedda wanjh kabirridurrkmirri rowk kore Yawey wokrayekwong.” ");
INSERT INTO gup_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Kaluk Moses benkayhmeng Bezalel, dja mak nawu Oholiab dja mak birriwern bininj nawu Yawey benmarnbom birrikodjkurludjad dja birrikurdumak. Birrimekbe bininj birridjareni birridurrkmirri kumekbe. ");
INSERT INTO gup_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Wanjh Moses benwong kunwardde dja njalehnjale rowk kore nawu Israel benkebmawahmeng birrikurrmekurrmeng bu kabirrirurrkmarnbunkenh ngarre Manrurrkdjamun Dabburlin. Dja mak nawu Israel benkebmawahmeng rowk birriyibebmi kore Moses, dja birrihdjalkurrmi bu kukabelbubuyika rowk. Wanjh bedda birridjaldjareminj bu birrikurrmi. ");
INSERT INTO gup_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Kaluk nawu birrikurdumakni bininj birrihdurrkmirri kore birrihrurrkmarnbuni manbu manrurrkdjamun nuye Yawey, wanjh birribawong kore birrihdurrkmirri. ");
INSERT INTO gup_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Dja birriyikang Moses birrimarneyimeng, “Bonj. Nawu kunwardde dorrengh kabirrimhdjalkan munguyh kore Yawey nganmarneyimeng bu ngarrikurduyime wanjh nadjalwern duninjh! Wanjh kamak bu kabirridjalbawon.” ");
INSERT INTO gup_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Wanjh Moses benwokrayekwong bedberre nawu Israel benkebmawahmeng kore birridi kunred, dja benmarneyimeng bu nawu kabirrihkurrme nawu kunwardde dorrengh kore Yawey nuye manrurrkdjamun, wanjh bedda kabirringurdme rowk. Dja wanjh bedda birringurdmeng birrikurrmi. ");
INSERT INTO gup_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Dja nawu kunwardde dorrengh nakka wanjh barlmeng kore bedda birrihkurrmi ba kamak kabirriyakwon rowk kore birridurrkmirrikenh kumekbe. ");
INSERT INTO gup_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Yikahwi bininj nawu birridurrkmirri wanjh birrikodjkurludjad, dja birrimekbe wanjh birrimarnbom ten manburrba nawu curtains manbu welhdiwelhdi yiman warnamyoy ngarre Manrurrkdjamun Dabburlin. Bedda birribibbuni manburrba manmak nawu linen, kunyarl dorrengh nawu kukblue, kukkurlba dja mak nawu kukpurple. Dja mak nakudji bininj nawu wernhburrbuni bibbuni yiman bim nawu Cherubim kore manburrba. ");
INSERT INTO gup_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kaluk namekbe curtains nawu birrimarnbom nakka wanjh rohrokni rowk, twelve metres bu kakuyeng dja bokenh metres bu karrirdwarlah. ");
INSERT INTO gup_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Nawu five curtains nakka wanjh birribelebelbmeng yiman birrinameng kukudji, mak nawu nabuyika five wanjh kunmekbe rerrih birriyimowong yiman nawu nayungki birrimarnbom. ");
INSERT INTO gup_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Wanjh birrimey manburrba nawu kukblueni, dja birribibbom loops, dja birribelbmeng kore kurrihdirrid ngarre nayerre curtain kore five nawu belbmerrinj, dja wanjh nabuyika five, nakka wanjh kunmekbe rerrih birriyimowong. ");
INSERT INTO gup_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Kaluk namekbe nawu loops marnbuyindanj fifty kore nakudji curtain mak kunmekbe rerrih bu karohrok nawu nayerre curtain. Dja nawu loops wanjh rohrokni dja mirrkmarrinj kore namekbe curtains bokenh. ");
INSERT INTO gup_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Dja mak birrimarnbom fifty nginj, nawu wirlmurrng gold ba kabelbmerren nawu curtains wanjh kabalraworren bu kamarnbuyindan mandjalkudjikenh kawarnamyo bu birribarnnameng kore ngarre dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Dja mak birrimarnbom nabadbuyika curtain bu birribarnnameng kaddum kore Manrurrkdjamun Dabburlin ba bu kakodjbarrkbun. Birrimey nawu nanikud kunngabek, dja birrimarnbom eleven manburrba curtains. ");
INSERT INTO gup_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kaluk namekbe eleven manburrba nakka wanjh karohrok rowk, thirteen metres bu kakuyeng dja bokenh metres bu karrirdwarlah. ");
INSERT INTO gup_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Wanjh nawu birribibbom five curtains bu birrirawong birrimarnbom nakudji nakimukkenh, dja mak nabadbuyika six manburrba wanjh birrirawong yimerranj nabuyika nakukkudji nakimuk. ");
INSERT INTO gup_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Wanjh birribibbom fifty loops kore kurrihdirrid ngarre nayerre curtain kore nawu five curtains raworrinj nadjalkukkudji, dja kunmekbe rerrih birriyimowong kore nawu six curtains raworrinj. ");
INSERT INTO gup_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Kaluk wanjh birribalmarnbom fifty nginj nawu bronze wirlmurrng, ba karaworren kore bokenh ngarre curtains ba kamarnbuyindan mandjalkudji. ");
INSERT INTO gup_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Mak birribadyawoyhmarnbom bokenh dabburlin bu birrikurrmeng kuberrkkah rowk kore Manrurrkdjamun Dabburlin. Kaluk nakudji dabburlin birrimarnbom kunkulah nuye sheep narangem nawu birrimedjmarnbom manmedjkurlba, dja mak bu birrimarnbom nabuyika, wanjh birribibbom kunkulah ngarre marndingunjngunj ba bu birribarrkbomkenh kuberrkkah kore Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Wanjh birridjabnameng kundulk frames kaluk acacia kundulk ba karayekwon manbu Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kaluk nawu nabebbehkudji kundulk frame nakka wanjh four metres bu kakuyeng dja bu kawarlahwarla nakka wanjh 70 centimetres. ");
INSERT INTO gup_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Nawu frames rowk karrmi mandulkdjad bokenh manbu djabnamikenh, mankudji kore kurridkudji dja mak kurridbuyika kabebbehdi. Kaluk nawern rowk nawu frame manbu karaworren dja kammarnbuyindanj bu kundjalkudjiwi. ");
INSERT INTO gup_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Kaluk birrimarnbom twenty frames ngarre Manrurrkdjamun Dabburlin kaluk kore walemkah, ");
INSERT INTO gup_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","dja mak birrimarnbom forty mandadkenh manbu wirlmurrng silver ba birribebbehdjabnameng mandulkdjad ngarre frames rowk. ");
INSERT INTO gup_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Dja mak birrimarnbom twenty frames ngarre Manrurrkdjamun Dabburlin kore kakbikah ");
INSERT INTO gup_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","dja mak forty mandadkenh manbu wirlmurrng silver ba bu frames rowk bebbehkarrmi bokenh, dja mandulkdjad birridjabnameng, bokehbokenh kore frames rowk. ");
INSERT INTO gup_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Bedda mak birrimarnbom six frames kaluk karrikadkah ngarre Manrurrkdjamun Dabburlin kurredjkah, ");
INSERT INTO gup_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","dja mak bokenh frames ngarre kurruhbe kore Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kaluk namekbe bokenh frames birribokenhmeng bu birrirawong kore kanjdji dja mak kore kaddum. Kaluk ring nawu wirlmurrng belbmeng namekbe bokehbokenh frames. Kunmekbe birriyimowong kore kurrubbehdubbe bokenh. ");
INSERT INTO gup_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Wanjh dingihdi eight frames dja mak 16 mandadkenh manbu wirlmurrng silver. Kaluk bokenh mandadkenh kabebbehdi kore kanjdji ngarre nabebbehbuyika nawu frames. ");
INSERT INTO gup_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Wanjh birrimarnbom fifteen mandulkdjad manbu acacia kundulk, dja birrikurrmeng kubulkayh kore frames rowk bu belbmikenh kurridkudji kore kurridbuyika ngarre frames bebbehbeh. Wanjh birrimarnbom kunbidkudji mandulkdjad kore kurridkudji ngarre Manrurrkdjamun Dabburlin, dja mak kunbidkudj mandulkdjad kore kurridbuyika ngarre, dja mak kunbidkudji ngarre karrikadkah ngarre Manrurrkdjamun Dabburlin, kore kurredjkah. ");
INSERT INTO gup_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Birrikurrmeng nahni mandulkdjad rowk nakudji nakudji bebbehdi kore frames manbubuyika, dja birrikurrmeng rowk kore kubulkayh, wanjh yiman kayime kukyimerranj mandulkkuyeng duninjh kare kurredj kore karrokme kurrid bokenh ngarre dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Wanjh birribaruy manbu wirlmurrng gold duninjh mahni mandulkdjad rowk, dja mak nawu frames rowk. Dja mak birrinameng manbu wirlmurrng gold dorrengh nawu rings kore kurrihdirrid nawu frames ba bu kakarrme mandulkdjad, bebbehbeh nakudji mandulkdjad kore mankudji frame. ");
INSERT INTO gup_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Wanjh birrimarnbom manburrba nawu curtain, bu birribibbuni kunyarl nawu medjyimi kukblue, dja kukpurple dja mak kukkurlba. Birribibbuni nawu manburrba manbu manmak linen. Kaluk bininj nawu wernhburrbuni wanjh bibbuni bim nawu Cherubim kore nawu curtains. ");
INSERT INTO gup_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Wanjh birrimarnbom kunkarrngbakmeng mandulkdjad kaluk acacia kundulk ngarre manburrba nawu curtain, dja mak birribaruy mahni kundulk rowk manbu wirlmurrng gold duninjh. Dja mak birrimarnbom manbu wirlmurrng gold nawu nginj ngarre mandulkdjad bu djabdidjabdi, dja mak nawu kunkarrngbakmeng wirlmurrng silver mandadkenh ngarre ba bu birridjabnameng nawu kunkarrngbakmeng mandulkdjad. ");
INSERT INTO gup_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Wanjh kore nawu kurrangmaye ngarre Manrurrkdjamun Dabburlin, nakka wanjh birrimarnbom manburrba manmak manbu linen, dja birrimarnbom kunyarl nawu medjyimi kukblue, dja mak kukpurple dja mak kukkurlba. Dja nahni curtain karrmi bim warridj dja wanjh kukmakni. ");
INSERT INTO gup_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Dja mak birrimarnbom kunbidkudji mandulkdjad bebbehkarrmi nginj nawu nginj, dja mak manbu mandadkenh ba bu birridjabnameng mandulkdjad, dja kore kaddumkah birribaruy mahni mandulkdjad rowk manbu wirlmurrng gold duninjh, dja warridj wirlmurrng gold birribaruy kore mandulkdjad rowk. Kaluk birrimarnbom manbu mandadkenh bu wirlmurrng bronze. ");
INSERT INTO gup_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Nawu Bezalel marnbom manmekbe manbu Ark kaluk acacia kundulk. Marnbom bu 110 centimetres kakuyeng dja 70 centimetres bu kahdirdwarlah, dja mak 70 centimetres bu kaddum rohrokmeng. ");
INSERT INTO gup_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Wanjh nungka baruy wirlmurrng gold duninjh kore kururrk dja kuberrk, dja mak kuyenghmeng wirlmurrng gold duninjh dja kurrmeng bu wakbuyinguneng nawu Ark. ");
INSERT INTO gup_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Mak nungka marnbom kunkarrngbakmeng wirlmurrng gold rings ngarre wanjh belbmeng kore kunkarrngbakmeng kurrenge ngarre Ark, bokehbokenh kore kurrid bokenh ngarre. ");
INSERT INTO gup_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","5","Wanjh marnbom mandulkdjad mankuyeng bokenh, kaluk acacia kundulk, wanjh kaluk balbaruy wirlmurrng gold duninjh. Wanjh dulkngimewong mahni kundulk bokenh kore rings nawu kahdi kurrid ngarre Ark ba bu bininj kabirringorrkan. ");
INSERT INTO gup_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Dja mak marnbom kaddumkah ngarre Ark, kaluk wirlmurrng gold duninjh dja mak namekbe manbu kaddumkenh nakka wanjh 110 centimetres bu kakukkuyeng dja 70 centimetres bu kawarlahwarla. ");
INSERT INTO gup_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Wanjh nawu Bezalel dongohdoy namekbe wirlmurrng gold duninjh dja marnbom nawu kukyimi Cherubim bokenh, wanjh yiman belbmeng kore lid. ");
INSERT INTO gup_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kaluk namekbe mayh bokenh benebelbmikenhdi kore nawu kaddumkenh benemirrkmarreni kore benebebbehdi kore kurrid bokenh ngarre Ark. ");
INSERT INTO gup_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Benewelwarlahminj kaddum, yiman benebarrkbuni namekbe kaddumkenh, dja mak benemirrkmarreni kumekbe, dja wanjh benebolknang manbu kaddumkah ngarre ark. ");
INSERT INTO gup_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kaluk nawu Bezalel dorrengh birrimarnbom manbalabala table manbu acacia kundulk; nakka birrimarnbom wanjh 90 centimetres kakuyeng, 50 centimetres bu kawarlahwarla, dja 70 centimetres bu kaddum rohrokmeng. ");
INSERT INTO gup_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Wanjh bedda birribarungi mahni manbalabala bu gold wirlmurrng duninjh, dja mak birrimarnbom manbu gold wirlmurrng bu nakuyengkenh dja manbik, wanjh birrikurrmeng bu yiwakbom kore maninjmanu manbalabala. ");
INSERT INTO gup_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Wanjh birrimarnbom mandulkbik kore kaddumkah kurrid ngarre table, kaluk rohrokmeng eight centimetres bu kore kaddum kaluk kahdjabdjabdi kore kurrihdirrid ngarre table, wanjh birribalkurrmeng nakuyengkenh gold bu yiwakbom ngarre kaddumkah. ");
INSERT INTO gup_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Dja mak birrimarnbom kunkarrngbakmeng wirlmurrng gold rings ngarre nawu manbalabala, dja mak birribelbmeng kore kunkarrngbakmeng kore kurruhbe kunkarrngbakmeng kore kurrenge ngarre kahdingihdi kanjdji. ");
INSERT INTO gup_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Kaluk namekbe nawu rings birrikurrmeng kurruhbe darnkih kore kaddumkah ngarre manbalabala, dja mandulkdjad karrmi bu bininj kabirridulkngimewon dja kabirrikanakan mahni manbalabala. ");
INSERT INTO gup_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Kaluk mahni mandulkdjad makka wanjh birrimarnbom acacia kundulk dja birribaruy bu gold wirlmurrng duninjh. ");
INSERT INTO gup_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Dja mak birrimarnbuni njalehnjale rowk ngarre manbu manbalabala, bu wirlmurrng gold duninjh birrimarnbom, yiman plates, banikkin, cups, dja mak jars nawu ngarrekih bu kabirrihborrakendongkenh wine manbu bininj rowk birrimarnekurrmi nuye nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Wanjh birrimarnbom lampstand kaluk wirlmurrng gold duninjh, dja dongidongi bu kukyimerranj manbadjan ngarre lampstand, dja mak nawu mandadkenh kore birridjabnamikenh. Dja nawu cups kore lamps birrikurrmikenh, wanjh birrimarnbuni gold duninjh bu kukyimi mannguy dja njalehnjale dorrengh ngarre mannguy, wanjh belbmeng rawong manbadjan dja mandadkenh. ");
INSERT INTO gup_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Birrimarnbom six manbu yiman manyeyende bu belbmikenhdi kore kurrid ngarre lampstand, kaluk danjbik karri kore kurridkudji dja mak danjbik kore kurridbuyika. ");
INSERT INTO gup_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Dja mak manbu manyendekudjikudji bebbehkarrmi danjbik cups manbu kukyimi almond mannguy, dja nawu cups nawern bebbehkarrmi njalehnjale ngarre mannguy. Kaluk namekbe manyende kabebbehdi kore lampstand nakka wanjh karohrok rowk. ");
INSERT INTO gup_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Kaluk mak kunkarrngbakmeng cups kukyimi yiman almond mannguy belbmi kore manbadjan lampstand dja mak bebbehkarrmi nawu njalehnjale ngarre mannguy. ");
INSERT INTO gup_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Kaluk manbu six manyenhyende makka bebbehberlwarlahminj kore lampstand makka wanjh djalrohrokni rowk. Dja kanjdji kore kaddumkah manyende bokenh wanjh mannguykenh belbmi, manbuyika belbmi kanjdji kore manyende bokenh manbu kubulkayh, dja manbadbuyika belbmi kanjdji kore manyende bokenh manbu manyerre. ");
INSERT INTO gup_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Manbu mannguy, dja manyenhyende dja manbadjan ngarre lampstand makka birrimarnbom bu birridongohdoy nadjalkudji wirlmurrng gold duninjh dja djalburrkkudji. ");
INSERT INTO gup_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Dja mak birrimarnbom seven gold lamps ngarre namekbe lampstand, dja mak manbalabalayahwurd dja manbu kabirribirlumarnbunkenh, wanjh wirlmurrng gold duninjh rowk. ");
INSERT INTO gup_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Bu birrimarnbom lampstand dja mak njalehnjale rowk ngarre, wanjh birrimey mankimukkenh burrk mankudji manbu gold wirlmurrng manbu birrirohrokmeng 34 kilograms. ");
INSERT INTO gup_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Wanjh birrimarnbom altar manbu mankalkkidjmanjmak kabirrikinje. Kaluk birrimarnbom kore acacia kundulk bu birrinameng 50 centimetres bu kakuyeng mak 50 centimetres bu kawarlahwarla, dja mak 90 centimetres bu kaddum. Dja kore kukebkakebkale ngarre altar, makka wanjh kunbidbakmeng nawu kunkanemdulk djalbelbmikenhdi kore manburrk ngarre altar. ");
INSERT INTO gup_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Dja mak birribalbarungi gold duninjh kore kaddum dja mak kore kurrihdirrid, dja mak kore kunkanem ngarre altar, dja mak birribalkurrmeng wirlmurrng gold nawu nakuyengkenh bu wabminguneng manburrk ngarre. ");
INSERT INTO gup_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Bedda wanjh birrimarnbom dja birrinameng gold rings darnkih kore kaddumkah, kaluk bokenh kore kurridkudji, dja mak bokenh kore kurridbuyika ngarre altar, dja bininj nawu kabirringorrkan altar wanjh kabirringimewon mandulkdjad bokenh kore rings. ");
INSERT INTO gup_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Dja mahni mandulkdjad bokenh birrimarnbom kore acacia kundulk, dja mak birribalbaruy wirlmurrng gold duninjh. ");
INSERT INTO gup_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Dja mak birrimarnbom mankalkkidmanjmak mandjamun manbu kabirrikodjbarungkenh nawu priests, dja mak birrimarnbom nawu manmanjmakkaykenh incense duninjh yiman mankalkkidmanjmak perfume. ");
INSERT INTO gup_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Wanjh bedda birrimarnbom altar manbu birribomkenh mayh bu birrimarnekinjeng nuye God. Kaluk birrimarnbom kundulk nawu acacia dja rohrokmeng 230 centimetres bu kakuyeng, mak 230 centimetres bu kawarlahwarla, dja mak 130 centimetres bu kaddum karohrokme. ");
INSERT INTO gup_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Kaluk birrimarnbom kunkarrngbakmeng kunkanemdulk kore kurridbubuyika, dja nahni kunkanemdulk rowk bu raworrinj manburrk ngarre altar. Dja mak birribalkurrmeng wirlmurrng nawu bronze ba belbmiyindanj kore kungorrk dja mak kore kaddum ngarre nawu altar. ");
INSERT INTO gup_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Mak birrimey wirlmurrng manbu bronze dja birrimarnbom nawern tools nawu altar ngarre, bu bininj kabirrikinje mayh, yiman djabbirlana, dja mak shovels, banikkin manbu kunkurlba kabirrihdjuhkekenh, dja mak nawu forks ngarre manbu kunkanjkenh, dja banikkin manbalabala nawu kabirrikanakankenh manbu kunyirrke. ");
INSERT INTO gup_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mak birrimarnbom nakimukkenh screen manbu wirlmurrng bronze ba kakarrme kunak bu karung kore kaddum altar, dja birrinameng kanjdji kaluk kururrk ngarre altar, kanjdji kore rim dja wohkah kore kanjdji. ");
INSERT INTO gup_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","6","Dja mak birrimarnbom nawu wirlmurrng bronze rings dja mak birrimarnbom mandulkdjad bokenh manbu acacia kundulk, dja birribalbaruy wirlmurrng bronze. Wanjh birribebbehngimowong kore kunkarrngbakmeng rings kore kurruhbe ngarre altar. ");
INSERT INTO gup_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Wanjh bininj birringimowoni nawu mandulkdjad kore rings. Kaluk birridulkkurrmeng kurridkudji dja mak kurridbuyika, ba bu kamak rowk kabirriwayhke dja mak kabirringorrkan nawu altar. Manbu altar wanjh birrimarnbom ngarre kundulkbalabala dja ngaleng birribawong kore kumelk bu kalohlorrk. ");
INSERT INTO gup_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Yikahwi morlehmorlenj wanjh birrimarnedurrkmirri nuye Yawey kore kurrangmaye ngarre Manrurrkdjamun Dabburlin kore Yawey kamre kabendjahwon nawu Israel benkebmawahmeng, dja birrimekbe daluk birribebbehkarrmi baddumanj nawu wirlmurrng bronze. Wanjh nawu birrimarnbuni njalehnjale kore dabburlinkenh, wanjh birrimey nahni baddumanj bedberre dja birrimarnbom banikkin nakimukkenh bu kabirridjirridjburrenkenh, dja mak birrimarnbom manbu kanjdjikah ngarre, makka wanjh wirlmurrng bronze dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Kaluk bedda birribolkmarnbom kuberrkkah ngarre dabburlin. Wanjh birrimarnbom manburrba curtains bu kunmekbe warnamyoy. Kaluk kore walemkah nawu manburrba nakka wanjh 46 metres bu kakuyeng dja mak birrimarnbom manburrba manbu manmak linen. ");
INSERT INTO gup_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Kaluk nawu curtains nakka birriwelhwelkeng kore wirlmurrng silver nginj nawu birridukkang silver kunyarl dorrengh kore mandulkdjad djabdidjabdi. Kaluk twenty mandulkdjad birridjabnameng kore twenty mandadkenh manbu wirlmurrng bronze. ");
INSERT INTO gup_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Dja kore kakbikah wanjh karohrok birrimarnbom nawu curtains. ");
INSERT INTO gup_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Dja mak kore karrikadkah ngarre kuberrkkah nawu curtains nakka wanjh 23 metres bu kakuyeng. Kaluk nawu curtains welhwelmi kore silver nginj nawu birridukkang kore ten mandulkdjad silver kunyarl dorrengh. Dja birridjabnameng mandulkdjad kore ten mandadkenh manbu wirlmurrng bronze. ");
INSERT INTO gup_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Dja mak kore kamdungbebme, yiman koyekkah, makka mak 22 metres bu kakuyeng. Dja nawu kurrangmaye ngarre dabburlin di kore koyekkah. ");
INSERT INTO gup_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Dja kore kurridkudji kore kurrangmaye nakka curtains welhwelmi dja birrididrohrokmeng bu darnkih seven metres, dja welhmi kore danjbik mandulkdjad djabdidjabdi kore danjbik mandadkenh. ");
INSERT INTO gup_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Mak kore kurridbuyika kurrangmaye namekbe curtains wanjh seven metres bu kakuyeng, kaluk kakarrme danjbik mandulkdjad dja danjbik mandadkenh. ");
INSERT INTO gup_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Nadjalwern rowk nawu curtains kore wakbuyinguni kuberrkkah wanjh nakka birrimarnbom manburrba manbu manmak linen. ");
INSERT INTO gup_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Mak nawu mandadkenh rowk ngarre mandulkdjad, nakka wanjh birrimarnbom wirlmurrng bronze. Dja nawu nginj dja kunyarl bu birridukkang kore mandulkdjad, wanjh birrimarnbom wirlmurrng silver duninjh, dja mak kore kukodjkenh ngarre posts nakka birribaruy silver duninjh warridj. Nadjalwern nawu posts kahdingihdi kore kuberrkkah nakka wanjh dukkayindi silver kunyarl dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Nawu curtain ngarre kurrangmaye kore kuberrkkah, nakka birribibbuni kunyarlwi manbu kukblue, kukpurple dja kukkurlbani, dja manburrba manbu manmak linen. Namekbe curtain wanjh kukmakni yiman bu birriwernhburrbuni bininj birribibbuni. Nawu curtain nakka wanjh nine metres bu kakuyeng mak 230 centimetres bu kaddum, karohrok nawu nabubuyika curtains dingihdi kore kuberrkkah ngarre dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kaluk namekbe curtains welhwelhdi kunkarrngbakmeng mandulkdjad dja mak kunkarrngbakmeng mandadkenh manbu wirlmurrng bronze. Dja nawu nginj dja kunyarl wanjh birrimarnbom wirlmurrng silver, dja mak kore kukodj ngarre mandulkdjad nakka mak wirlmurrng silver birribaruy. ");
INSERT INTO gup_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nadjalwern nawu tentpegs bu birridjabnami kandjikenh kore dabburlin, dja mak kore kuberrkkah ngarre manburrba nawu curtains, nakka wanjh birrimarnbom wirlmurrng bronze rowk. ");
INSERT INTO gup_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Kondah kabimbuyindi yehyeng rowk bu bininj birrimangi bu birrimarnbuni njalehnjale nawu ngarre Manrurrkdjamun Dabburlin kore kahdi manwarddebala bokenh manbu Yawey biwong Moses. Manekke manwarddebala bokenh kabimbuyindi kore Yawey nungan wokkurrmerrinj kunwoybuk dorrengh. Kaluk bu bininj birrimarnbuni njalehnjale ngarre dabburlin, wanjh Moses benwokrayekwong nawu Levi benkebmawahmeng bu kabirribimbun yehyeng rowk kore nahni djurra. Kaluk bininj nawu ngeyyoy Ithamar, nawu Aaron bibornang, wanjh wohrnawohrnani rowk kore birribimbuni nahni djurra. ");
INSERT INTO gup_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Nawu Bezalel nawu beywurd nuye Uri, nawu mawahmawah nuye Hur kore namud nuye Judah, nungka wanjh marnbom njalehnjale kore Yawey biwokrayekwong Moses. ");
INSERT INTO gup_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Nabuyika bininj nawu ngeyyoy Oholiab nawu beywurd nuye Ahisamach kore namud nuye Dan, namekbe wanjh bibidyikarrmeng Bezalel. Nawu Aholiab nungka kurdumakni, dja wernhburrbuni bu bimbom mankarre ngarre manbu birrimarnbunikenh, dja nungka mak marnbumarnbuni kore wirlmurrng dja mak kore kunwardde, dja mak njalehnjale yiman nawu bibbuni kunmadj bu kamak bibbuni kore kunyarl nawu kukblue, dja kukpurple dja mak nawu kukkurlba, dja mak manburrba manbu manmak linen. ");
INSERT INTO gup_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nawu wirlmurrng gold duninjh manbu birriwong Yawey ba bu birrinameng njalenjale ngarre Manrurrkdjamun Dabburlin, wanjh birrirohrokmeng kaluk 1000 kilograms kore bedberre mankarre. ");
INSERT INTO gup_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Bu Moses benrohrokmeng dja benngeybimbom bininj nawu Israel benkebmawahmeng, wanjh birridjalwern yiman 603550 bininj nawu birridabbolkni. Wanjh birrimekbe bininj rowk birribebbehwong yeng nawu silver dja wanjh wernhmerrinj bu birrirohrokmeng namekbe 3400 kilograms kore bedberre mankarre. ");
INSERT INTO gup_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kaluk namekbe silver nawu 3400 kilograms nakka wanjh birrimey dja birrimarnbom one hundred mandadkenh ngarre Manrurrkdjamun Dabburlin, dja mak ngarre manburrba nawu curtain. Kaluk birrimarnbom mandadkenh bu bebbehkarrmi 34 kilograms nawu wirlmurrng silver. ");
INSERT INTO gup_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Dja mak bedda birrimey 30 kilograms nawu silver dja birrimarnbom nginj nawu ngarre mandulkdjad dja mak birribaruy nawu kore kukodj ngarre mandulkdjad dja mak kunyarl ngarre manbu silver bu birridukkang. ");
INSERT INTO gup_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Nawu wirlmurrng manbu bronze kore birriwong nuye Yawey nakka birrirohrokmeng 2400 kilograms. ");
INSERT INTO gup_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Kaluk bedda birrimey nawu wirlmurrng bronze dja birrimarnbom nawu mandadkenh ngarre kore kurrangmaye Manrurrkdjamun Dabburlin kore Yawey kamre bu kabendjahwon bedberre, dja mak birrimarnbom altar dja screen manbu bronze wirlmurrng, dja mak tools nawu ngarre altar. ");
INSERT INTO gup_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Dja mak birrimey mahni wirlmurrng bronze dja mak birrimarnbuni mandadkenh ngarre manburrba kahwelhwelme kaluk kawakbuyingun kore kuberrkkah ngarre dabburlin, dja ngarre kore kururrkdangmayekenh. Dja mak birrimarnbom nawu tentpegs bu birridjabnami kanjdjikah ngarre dabburlin dja mak ngarre manburrba nawu kawakbuyingun kore kuberrkkah ngarre. ");
INSERT INTO gup_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Wanjh bininj nawu birridurrkmirri kore Manrurrkdjamun Dabburlin, bedda birrimey kunyarl manbu kukblue, dja mak kukpurple dja mak kukkurlba, wanjh birrimarnbuni kunmadj bedberre nawu priests ba kabirridjongbuyindi bu kabirridurrkmirri kore kubolkdjamun. Bedda birrimarnbom manbu nadjamun kunmadj nuye Aaron, kore Yawey biwokrayekwong nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Wanjh birrimarnbom nawu ephod manbu wirlmurrng gold duninjh, dja birribibbom kunyarl nawu kukblue, dja mak kukpurple dja mak kukkurlba. Birribibbuni rowk manburrbawi manbu manmak linen. ");
INSERT INTO gup_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Dja mak birridongohdoy namekbe wirlmurrng gold bu birribelngwong, wanjh birridjobdjobkeng bu birrikuyengwong dja yiman kunyarl kukkuyengni birrimarnbom. Kaluk nawu birriwernhburrbuni bininj birrimekbe nanu birrimarnbom namekbe gold bu birriyimowong karaworren namekbe kunyarl nawu kukblue, kukpurple, dja mak kukkurlba, dja mak kore manburrba manmak linen manbu birriridjmeng. ");
INSERT INTO gup_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Kaluk birrimarnbom nawu kunkarlangkenh bokenh nawu ngarre ephod, dja belbmeng kore kurrid ngarre ba bu karrukayindi kaddumkah kore kukarlang bokenh nawu priest. ");
INSERT INTO gup_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Dja mak nawu kunngadmokenh namakmak ngarre ephod wanjh birribibbuni kunyarl nawu gold, dja mak kukblue, dja mak kukpurple dja mak kukkurlba. Birribibbom kore ephod bu belbmiyindanj. Birrimarnbom manburrbawi manbu manmak linen nawu birriridjmeng. Kuhni rowk birrimarnbom kore Yawey biwokrayekwong nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Wanjh birribebbehkurrmeng manwarddemakkaykenh kangeyyo onyx kore wirlmurrng gold bu belbmikenh ngarre, dja mak birriwarddedadjkeng bu bindingeynamehnameng twelve bebeywurd nuye Israel. ");
INSERT INTO gup_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Wanjh birribelbmeng namekbe manbu manwarddemakkaykenh kore kunkarlang ngarre ephod, ba bu nawu priests minj kabindibengmidjdan nawu bebeywurd rowk nuye Israel. Kuhni wanjh birrimarnbuni rowk kore Yawey biwokrayekwong Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Wanjh birrimarnbom kunmadj nawu kaberrekalkbalhme yiman kabarrkbun nawu ephod. Kaluk birribibbuni karohrok kore birrimarnbom nawu nadjamun vest, bu kunyarl nawu gold, dja mak kukblue, dja mak kukpurple dja mak kukkurlba. Birribibbuni kore manburrbawi manmak manbu linen kunyarlwi. ");
INSERT INTO gup_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Nakka wanjh kukyimi square, 22 centimetres bu kakuyeng dja 22 centimetres bu kawarlahwarla, kaluk birribakkeng bu madjyimerranj yiman pocket. ");
INSERT INTO gup_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Wanjh yerre birrikurrmeng manwarddemakkaykenh nawu jewels dja birribelbmeng kunkarrngbakmeng bu yirriyoy. Wanjh nawu kore kaddum belbmiyindi nawu manwarddemak nawu ruby, dja mak topaz, dja mak quartz manbu kukkarlba. ");
INSERT INTO gup_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Nawu kanjdji kore bokenhkah wanjh birribelbmeng manwarddemak nakka wanjh turquoise, dja mak sapphire, dja mak emerald. ");
INSERT INTO gup_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Dja mak nawu kanjdji, kore mahni danjbik, wanjh birribelbmeng manwarddemak manbu jacinth, dja mak agate, dja mak amethyst; ");
INSERT INTO gup_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Wanjh nawu yerre duninjh nakka wanjh birribelbmeng chrysolite, onyx dja jasper. Wanjh birribebbehbelbmeng rowk manbu manwarddemak kore wirlmurrng gold bu wernhkarrmikarrmi. ");
INSERT INTO gup_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kaluk bindibebbehngeynameng kunngey bedberre nawu nabebeywurd nuye Israel kore nawu kunwardde jewels kaluk twelve birrirohrokmeng. Birringeybimbom nabebbehkudji nawu kunwardde jewel rowk bebbehkarrmi kunngey kunngey nawu kore twelve namud bedberre nawu Israel benkebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Mak birrimarnbom wirlmurrng nawu gold duninjh chains bu birridukkarrukkang yiman birriyimowong kukyimi manbu kunyarl rope nawu kunberrekalkkenh. ");
INSERT INTO gup_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Dja mak birrimarnbom bokenh gold manbu kukyimi mannguykilelh dja bokenh rings nawu gold yerrih kaluk birribelbmeng kaddumkah ngarre kore kurrid bokenh nawu kunberrekalkkenh. ");
INSERT INTO gup_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Wanjh birribalbelbmeng nahni bokenh gold chains kore bokenh gold rings kore kurrid ngarre namekbe nawu kunberrekalkkenh, ");
INSERT INTO gup_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Mak birribelbmeng bokenh kore kurridbuyika nawu kore ngarre chains dja bokenh gold mannguy. Wanjh birribelbmeng namekbe gold chains kore bokenh nawu kunkarlang ngarre straps dja mak nawu kore kumirrk ngarre nawu ephod. ");
INSERT INTO gup_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Dja mak birriyawoyhmarnbom nabuyika bokenh wirlmurrng gold rings wanjh birrikurrmeng kanjdjikah kore ngarre nawu kunberrekalkkenh, mak kore kururrkbeh kurrid darnkih kore nawu ephod. ");
INSERT INTO gup_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Dja mak birribadmarnbom nabuyika bokenh gold rings kaluk nawu kare kore kanjdji ngarre nawu kunkarlangkenh straps bu karri kore kumirrk ngarre nawu ephod, darnkih kore kunngadmokenh ngarre nawu ephod. ");
INSERT INTO gup_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Dja mak birrimey nawu kukblue kunyarl dja birridukkang nawu rings ngarre kunberrekalkkenh kore rings ngarre nawu ephod, ba bu kabelbmikenh kore kunngadmokenh. Kuhni birrimarnbom ba bu nawu kunberrekalkkenh minj kawelhwelme kore ephod. Wanjh kunmekbe birrikurduyimeng rowk dja birrimarnbom kore Yawey biwokrayekwong nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Wanjh bedda birrimey manburrba manbu kukblue, birrimarnbom kunmadj nakuyeng nawu priest kabirridjongbuyindi kanjdjikenh, dja kuberrkkah karri nawu ephod. Bedda birriyingkihmarnbom manmak manburrba bu birribibbuni namekbe nawu kunmadj. ");
INSERT INTO gup_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Birrimarnbom bu kawohrurrk kore kubulkayh ngarre manburrba nawu kuberrkkah kahdi, rawoyindanj nawu kunkomkenh collar nawu ngokko birriyingkihbibbom wanjh bu wakbuyinguneng kore kahrurrk ba kunukka minj kamadjdjalkmire. ");
INSERT INTO gup_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Wanjh yerre birribibbuni yiman manbarnem manbu pomegranates bu birribelbmeng kanjdjikah kurrid ngarre nawu nakuyeng kunmadj. Birribibbuni kaluk kunyarl kukblue, dja mak kukpurple dja mak nawu kukkurlba, dja mak linen nawu birriridjmeng bu kunyarl birrimarnbom. ");
INSERT INTO gup_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Mak birrimarnbom wirlmurrng gold duninjh nawu bells nakilehkilelk, wanjh birriwelhwelkeng kore nawu pomegranates birrikurrmeng kanjdjikah kore nawu nakuyeng kunmadj. ");
INSERT INTO gup_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Wanjh kore kanjdji ngarre nawu nakuyeng kunmadj bu kuberrkkah wanjh kumekbe di nawu bells kubulkayh nawu pomegranates bebbehbebbehdi. Wanjh nawu priest namekbe munguyh djongbuyindi bu wam durrkmirrurrkmirri yiwarrudjkenh. Kaluk kunmekbe rowk kore Yawey biwokrayekwong Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Wanjh birribibbom warridj kunmadj nawu manburrba milemakkaykenh bedberre nawu Aaron dja nabebeywurd nuye, ");
INSERT INTO gup_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","dja mak birribalmarnbom turbans nawu kabirrikodjdukkarrenkenh, dja mak nawu kabirrimilhdukkarrenkenh, dja mak kunmadj nawu kanjdjikenh kabirridjongbuyindi, wanjh kaluk milemakkaykenh manburrba dorrengh. ");
INSERT INTO gup_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Dja mak birrimarnbom kunngadmokenh namakkaykenh, kaluk manburrba ngarre nawu milemakkaykenh linen, dja mak kunyarl manbu kukblue dja mak manbu kukpurple dja mak manbu kukkurlba. Dja birribibbuni bim kore namekbe kunmadj. Kuhni birrimarnbom rowk kore Yawey biwokrayekwong Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Wanjh bedda birrimarnbom warridj manbalabala nawu wirlmurrng gold duninjh manbu birribelngwong, yiman birribimbom kunwok bu bimdibimdi. Wanjh birribelbmeng kore Aaron nuye turban nawu kodjdjungbuyindikenh. Nakka wanjh kunkodjkenh nawernhdjamunni. Nawu birrimarnbuni wanjh birriwirrkmeng birringeynameng bu birribimbom, “Nakka Wanjh Yawey Nuye.” ");
INSERT INTO gup_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Wanjh birridukkang namekbe nawu gold manbalabala kore nawu turban kaluk kukblue kunyarl dorrengh, kore Yawey kunmekbe biwokrayekwong Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Wanjh bininj nawu birrihdurrkmirri kore mahni Dabburlin kore Yawey kamre kabendjahwon bedberre bininj nawu Israel benkebmawahmeng, wanjh birriyakwong rowk. Birrimekbe bininj nawu Israel benkebmawahmeng wanjh birridjalkurduyimeng rowk kore Yawey biwokrayekwong Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Yerre wanjh birriwong Moses manbu Manrurrkdjamun Dabburlin dja mak njalehnjale ngalengngarre yiman nawu nginj, dja mak nawu kundulk frames dja mak kundulk crossbars, dja mak mandadkenh dja mandulkdjad bu djabdidjabdi. ");
INSERT INTO gup_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Dja mak nawu kahbarrkbunkenh, kaluk birrimarnbom kore sheep kunkulah manbu birrimedjmarnbom kukkurlba, dja mak nawu kahbarrkbunkenh nawu birrimarnbom kunkulah ngarre marndingunjngunj, dja mak manburrba nawu kahdangmayebalhme kore kurrangmaye ngarre kore kubolkdjamun duninjh. ");
INSERT INTO gup_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Dja mak birriyakwong birrimarnbom nawu Ark manbu kakarrme manwarddebala bokenh kore kabimbuyindi kunwok kunwoybuk bu Yawey wokkurrmerrinj. Dja mak birriyakwong nawu mandulkdjad manbu kabirrikanahkankenh manbu Ark, dja mak nawu kaddumkah ngarre kahdangbalhmikenh. ");
INSERT INTO gup_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Dja mak birriyakwong manbu manbalabala dja ngalng rowk ngarre, dja mak kandidjawa manbu kabenhbukkabukkan bu God kahdi. ");
INSERT INTO gup_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Dja mak nawu lampstand nawu birrimarnbuni bu wirlmurrng gold duninjh, dja mak lamps nawern kumekbe kahdi, dja mak njalehnjale ngarre, dja mak manbu olive kunkalkkid ngarre bu kabirriwurlhkekenh kunak. ");
INSERT INTO gup_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Dja mak birriwong Moses nawu altar birrimarnbom, kaluk birribaruy gold, dja mak kunkalkkid nawu nungka kabenkodjdjuhke bu kabenmarnbun bininj nawu priests, dja mak incense nawu namanjmak duninjh, dja mak manburrba nawu kahbalhme kore kurrangmaye ngarre dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Dja mak nabadbuyika altar kaluk birrimarnbom manbu wirlmurrng bronze dja ngarre screen, dja mak mandulkdjad bu kabirringorrkankenh. Dja mak nawu njalehnjale ngarre, dja mak banikkin nakimuk nawu kabirridjdirridburrenkenh, dja nawu kanjdjikenh kore kabirribarnname. ");
INSERT INTO gup_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Mak birriwong Moses nawu manburrba curtains nakimuk ngarre kuberrkkah dabburlin, dja mak mandulkdad dja mandadkenh kore kabirridjabname, dja mak nabadbuyika manburrba curtain nawu kahbalhme kurrangmaye kore kuberrkkah, dja mak kunyarl dja tentpegs ngarre kanjdjikah kabirridjabname kuberrkkah nawu curtains. Dja mak tentpegs dja njalehnjale rowk nawu kore Manrurrkdjamun Dabburlin manbu kore Yawey kamre kabendjahwon bedberre. ");
INSERT INTO gup_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Wanjh bedda birrimadjkang kunmadj birribibbuni nawu priests bedberre ba kabirridjongburren bu kabirridurrkmirri nuye Yawey kore kubolkdjamun. Kaluk nawu manmadjdjamun manbu nuye Aaron dja mak manmadjbuyika kunmadj manbu bedberre nawu nabebeywurd nuye, ba bu kabirridjongbuyindi bu kabirridurrkmirri priests. ");
INSERT INTO gup_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Wanjh nawu Israel benkebmawahmeng birridurrkmirranginj rowk kore Yawey biwokrayekwong Moses. ");
INSERT INTO gup_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Wanjh Moses wam wernhnang kore birridurrkmirranginj dja mak wohnang bu birrikurduyimeng kamak rowk kore Yawey wokrayekwong. Wanjh Moses benmarnedi yiwarrudj dja bidjawam Yawey bu kunmak kabenmarnekurduyime bedberre. ");
INSERT INTO gup_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Wanjh Yawey bimarneyimeng Moses ");
INSERT INTO gup_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Bu kunbarnangarra yungkih kaluk bu dird nawu kahdokme, ngurridjabdjabnamen nawu Manrurrkdjamun Dabburlin, kaluk nawu dabburlin manbu kore ngaye Yawey ngamre djahwon ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Wanjh kumekbe ngurrikurrmen nawu Ark manbu kakarrme manwarddebala bokenh kore kunwoybuk kunwok ngawokkurrmerrinj. Dja mak manburrba ngurriwelhwelkemen kore kumirrk ngarre Ark. ");
INSERT INTO gup_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Wanjh ngurrimngimowo manbalabala table dja ngurrikurrmekurrme njalehnjale nawu ngarre kumekbe. Kaluk lampstand ngurrimngimowo dja ngurrinamehnamen nawu lamps kore lampstand. ");
INSERT INTO gup_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Wanjh ngurrikurrmen nawu gold altar ngarre kabirrikinje mankalkkidmanjmak kore kumirrk ngarre Ark kore manwarddebala bokenh kahdi nawu kabimdi kunwok kunwoybuk bu ngawokkurrmerrinj. Yerre wanjh ngurribarnnamen manbu manbuyika curtain manburrba kore kurrangmaye ngarre nawu Manrurrkdjamun Dabburlin.” ");
INSERT INTO gup_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Wanjh ngurrimang nawu altar manbu kandimarnekinje mayh nawu kandiwon, dja ngurrikurrmen kore kumirrk ngarre nawu Manrurrkdjamun Dabburlin kore ngaye Yawey ngamre djahwon ngudberre. ");
INSERT INTO gup_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Dja mak nawu nawernhkimuk bannikin nawu ngurridjirridjburrenkenh, wanjh ngurrikurrmen kore kubulkayh nawu Dabburlin dja altar, dja mak kukku ngurriborrakendong ba kabobarlme. ");
INSERT INTO gup_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Wanjh ngurrinamen manbu kawarnamyo kawakbuyingun nawu kuberrkkah ngarre Dabburlin, dja ngurribalbarnnamen manburrba nawu curtain ba kawelhwelme kore kurrangmaye.” Kuhni rowk Yawey bimarneyimeng nawu Moses bu biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Wanjh Yawey biyawoyhwokrayekwong nawu Moses, yimeng, “Kaluk bu yinameng rowk, wanjh yimang olive kunkalkkid manbu yibenkodjdjuhkekenh nawu bininj, wanjh yirrelkkemen kore Manrurrkdjamun Dabburlin, dja mak nadjalwern rowk nawu kumekbe kahyo. Kuhni yikurduyimen ba bu mahni Manrurrkdjamun Dabburlin dja njalehnjale ngarre, wanjh kayimerran djal ngaye ngardduk duninjh. ");
INSERT INTO gup_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Yerre wanjh yirrelkkemen kunkalkkidwi kore altar manbu kandimarnemokenkinje mayh nawu kandiwon ngaye, dja mak yehyeng rowk ngarre. Wanjh kuhni yimarnbun rowk bu ngaye ngardduk. ");
INSERT INTO gup_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Dja mak yirrelkkemen warridj namekbe kunkalkkid dorrengh nawu nakimukkenh bannikin, dja ngarre kanjdjikah. Kuhni wanjh yimarnbun bu djal ngaye ngardduk.” ");
INSERT INTO gup_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Wanjh yibenmang Aaron dja nabebeywurd nuye dja yibenka kore kurrangmaye ngarre Manrurrkdjamun Dabburlin kore ngaye ngamre bu djahwon ngudberre, wanjh kunmekbe yibenkukdjirridjbu kukkuwi bu ngayekenh. ");
INSERT INTO gup_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Wanjh nawu manmadjdjamun nakka wanjh yidjongbu nawu Aaron. Dja mak yikodjdelkkemen kunkalkkid dorrengh dja kanmarnekurrmen ba bu nungka nganmarnedurrkmirri yiman ngaye ngardduk priest. ");
INSERT INTO gup_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Dja mak yibenka nawu Aaron benbornang wanjh yibendjongbu nawu kunmadj bedberre. ");
INSERT INTO gup_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Wanjh yibenkodjdelkkemen namekbe mankalkkid dorrengh karohok bu yiman nawu kornkumo bedberre yiyimowong, ba bu kabirriyimerran priests ngardduk ngandimarnedurrkmirri. Bu kuhni yiyime, wanjh kunukka kadjalyirriyo bedberre bu kabirridurrkmirri priests, nawu mak mawahmawah kabindibalyime warridj munguyh.” Kuhni rowk bu Yawey biwokrayekwong nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Wanjh Moses kunmekbe kurduyimeng rowk kore Yawey biwokrayekwong nuye. ");
INSERT INTO gup_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Wanjh Moses dja nawu Israel benkebmawahmeng birrinameng Manrurrkdjamun Dabburlin. Birridjabnameng bu kore kunyungkih kunbarnangarra kore dird nawu kahdokme dja mak mandjewk nawu munkekadjuy nawu kahdokme bu bedda birriwelengbolkbawong kunbolk Egypt. ");
INSERT INTO gup_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kaluk bu birridjabnameng nawu Manrurrkdjamun Dabburlin, wanjh birrikurrmeng manbu mandadkenh ngarre mandulkdjad, dja mak birrimarnbom nawu mandulkdjad frames, dja mak birringimiweng mandulkdjad kore kubulkayh frames, dja wanjh birridjabnameng mandulk rowk kore djabdidjabi. ");
INSERT INTO gup_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Wanjh yerre Moses dorrengh birrikodjbarrkbom nawu manburrba kore Manrurrkdjamun Dabburlin, dja mak nawu kaddumkah dabburlin balbarrkbom warridj kunmekbe kore Yawey biwokrayekwong nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Wanjh Moses mey nawu manwarddebala bokenh manbu kabimdi kunwok kunwoybuk kore Yawey wokkurrmerrinj, dja dahkendoy kore Ark. Wanjh kurrmeng mandulkkuyeng kore rings ngarre Ark wanjh yerre kurrmeng nawu kaddumkah ngarre ba kahdangbalhme. ");
INSERT INTO gup_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Wanjh kang nawu Ark kore Manrurrkdjamun Dabburlin, dja welhwelkeng manburrba bu minj nangale bininj kanan nawu Ark manbu kakarrme manwarddebala bokenh kore kunwoybuk kunwok Yawey wokkurrmerrinj. Kuhni kurduyimeng kore Yawey biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Wanjh Moses kurrmeng nawu manbalabala kore Manrurrkdjamun Dabburlin manbu kore Yawey kamre kabendjahwon bedberre, kuberrkkah ngarre manburrba nawu kahwelhwelme kumekbe. ");
INSERT INTO gup_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Wanjh balmey kandidjawa nawu bininj birriwong Yawey, dja kurrmeng kore table, kore Yawey biwokrayekwong nuye. ");
INSERT INTO gup_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Mak Moses kurrmeng nawu lampstand kore Dabburlin manbu kore Yawey kamre kabendjahwon bedberre, kaluk walemkah, borledmikenh ngarre manbalabala. ");
INSERT INTO gup_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Wanjh balwurlhkeng nawu lamps kore kumirrk nuye Yawey, kore Yawey biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Wanjh Moses kurrmeng nawu gold altar kore Dabburlin manbu kore Yawey kamre kabendjahwon bedberre, kaluk kore kumirrk ngarre manburrba nawu kahwelhwelme. ");
INSERT INTO gup_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Wanjh kinjeng nawu manmanjmakkaykenh incense kumekbe, kore Yawey biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Yerre wanjh welhwelkeng manburrba nawu curtain kore kurrangmaye ngarre Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Wanjh Moses kurrmeng altar kore kabirrihkukkinje mayh nawu kabirriwon Yawey, kaluk darnkih kore kurrangmaye ngarre Manrurrkdjamun Dabburlin, manbu kore Yawey kamre kabendjahwon bedberre. Wanjh biweng mayh nawu bininj birriwong Yawey, mokenh bimarnekinjeng nuye, dja manmim warridj kinjeng, manbu birriyingkihwong Yawey. Kuhni rowk Moses kurduyimeng kore Yawey biwokrayekwong. ");
INSERT INTO gup_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Wanjh Moses dorrengh birrimey nawernhkimukkenh bannikin nawu kabirridjirridjburrenkenh dja birrikurrmeng kubulkayh Dabburlin manbu kore Yawey kamre kabendjahwon bedberre, dja kore nawu altar, wanjh kukku borrahkendoy. ");
INSERT INTO gup_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Kaluk Moses, Aaron dja nawu Aaron benbornang wanjh manmekbe kukku djal bedda bedberre bu birribiddjirridjburreni dja mak birridengedjirridjburreni. ");
INSERT INTO gup_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Kaluk bedda birridjirridjburreni bu birrimarnburrinj ba bu birringimi kore Manrurrkdjamun Dabburlin manbu kore Yawey kamre kabendjahwon bedberre, dja mak bu birrirey darnkih kore nawu altar. Kuhni rowk wanjh Yawey biyingkihwokrayekwong nawu Moses. ");
INSERT INTO gup_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Wanjh Moses dorrengh birrinamehnameng nawu kuberrkkah kore wakbuyinguneng manbu altar dja mak manbu Manrurrkdjamun Dabburlin. Dja mak birriwelhwelkeng nawu manburrba curtain kore kurrangmaye ngarre kuberrkkah manbu Dabburlin. Kuhni wanjh Moses yakwong rowk kore bimarnedurrkmirranginj nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Wanjh manmekbe kunngol barrkbom kore Dabburlin manbu kore Yawey kamre kabendjahwon bedberre, dja mak kunmakmak duninjh nuye Yawey barlmeng rowk kore Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Bu kunngol barrkbom, dja mak kunmakmak duninjh nuye Yawey bolkbarlmiyindi kore Manrurrkdjamun Dabburlin manbu kore Yawey kamre kabendjahwon bedberre, wanjh kunmekbekenh kunu Moses minj ngimeninj manbu Manrurrkdjamun Dabburlin. ");
INSERT INTO gup_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kaluk bu manmekbe kunngol wayhmi kore Manrurrkdjamun Dabburlin, wanjh nawu Israel benkebmawahmeng birridolkkani bu birribolkbawoyi birrirey kuredbuyika. ");
INSERT INTO gup_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Dja bu manmekbe kunngol djahdjaldi kore Manrurrkdjamun Dabburlin, wanjh kunukka minj birrirawinj. Bedmanwali birrihdjaldi kubolkkudji kaluk bu ngolwayhmi. Bedda munguyh birridjalmadbuni kore manbu kunngol. ");
INSERT INTO gup_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Bu yarrkka birrirey nawu Israel benkebmawahmeng rowk, wanjh manbu kunngol nuye Yawey barrkbuni nawu Manrurrkdjamun Dabburlin bu barnangarra rowk. Dja bu kukak rowk, wanjh kunak kakrungi kore kunngol. Wanjh bedda birrinang rowk. ");
INSERT INTO gup_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Korroko nawu Israel benkebmawahmeng minj birribangmekarrmeninj nawu king. Nawu birrikukenni bininj bindidjadmi birriwarlahkenh bininj rowk. Wanjh kumekbe nakudji bininj ni nawu nakang kunred Bethlehem kore kubolkkimuk Judah. Nungka ngeyyoy Elimelech. Ngalbininjkobeng nuyeni ngalu ngeyyoy Naomi. Dja bebeywurd bokenh nuye benengeyyoy, nakudji ngeyyoy Mahlon, dja nabuyika nawu ngeyyoy Chilion. Bedda rowk wanjh birridi kore Bethlehem (Kaluk mahni kunbolk yikahwi birringeybuni Ephrathah.) Wanjh bedda birridjarrkdolkkang, birribolkbawong Bethlehem dja birriwabmeng djarreh kore kunbolk Moab. Kaluk djewkwarrewong kore Judah, dja bolkdarlehminj, wanjh manme yakminj kore kubolkwarlah Judah. Kumekbekenh wanjh birriwam. ");
INSERT INTO gup_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Bu kumekbe birriwam waken birrihni, wanjh Elimelech doweng kumekbe, benwakwam ngalbininjkobeng dja bebeywurd nuye. ");
INSERT INTO gup_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Birrihni, kalukburrk bebeywurd benemekbe, daluk bindibebbehmey nawu benemekbe nawu daluk bokenh benengeyyoy ngalkudji ngeyyoy Orpah, dja ngalbuyika ngeyyoy Ruth. Kunmekbe birrirerrkang mandjewk nawern ten. ");
INSERT INTO gup_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Birrirerrkang korroko, wanjh bedmanwali bebeywurd benedoweng, nawu ngokko kornkumo berrewonengni nungka dokmeng doweng. Wanjh ngalbadjan minj karrmeninj nabininjkobeng dja yayaw ngarre. ");
INSERT INTO gup_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Kaluk bu kumekbe birrihni Moab, Naomi bekkang bu Yawey yawoyhdjewkmarnbom bedberre kore ngalengngarre kunred Judah, dja manme manrakel bekkang djordmerrinj, karrmi manwern manme. Bu kunmekbe bekkang wanjh welengbolkbawong kumekbe kore ningihni Moab, dja ngalbinjmorne ngarre bedda dorrengh birridjarrkbolkbawong. ");
INSERT INTO gup_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","8","Wanjh birrimahmirranginj birrirawinj kore kunred Judah. Bu birribaldolkkarrinj birribalhrey, Naomi benbenemarneyimeng, “Kab ngunebekkarrimen ba ngunedurndeng kore ngurrimud kabirrihni. Kaluk bu ngunedurndeng ngadjare Yawey ngunbenenahnan, yiman kayime ngurrbenbenehnahnani nawu ngabenbeneyawmey bu benehmimbini, dja ngaye dorrengh kandihdjarrknahnani. ");
INSERT INTO gup_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Dja ngadjare bu Yawey kaluk ngunbenemarnekarremarnbun, bu ngunebebbehmang bininj ba ngundibebbehnahnan kunmak.” Wanjh Naomi benbenebunjhmey benbenewoknang, wanjh kumekbe benemarnenalkbom. ");
INSERT INTO gup_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Wanjh benewelengmarneyimeng berrewoneng ngalbinjmorne, “Burrkyak, ngad minj nganedurndeng, dja kanedjarrkray kore ngudda ngurrimud kabirrihni.” ");
INSERT INTO gup_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","13","Wanjh Naomi benbenemarneyimeng, “Yuwn kab kandimaddeng, dja ngunedurnde. Wanjh nuk minj ngayenu ngamerlem ba ngayawmang ngorrewoneng bambu ngurriyawoyhmarren. Ngunedurnde, minj kunu ngayenu ngangudjmak nganeyawoyhmarren bininj, dja ngayenu wanjh ngangudjwarreminj ngakohbanjminj. Bu yiman nganjilngniwirrinj, kuninjkunu kumunun yimankek nganemarrimeninj bininj, ngayawmayi wurdyaw, kunubewu minj ngurrbenbenemadbuyi bu benedjordmeninj. Nguddambu wanjh kunu ngunekohbanjmeninj. Marndi nuk minj ngurrbenbenemadbuyi ngurrimarrimeninj, dja birribuyika ngundimayi ngorrewoneng. Nguneburrbun bu kakarrewarre, dja Yawey nganbodmekenhwong bu doweng ngardduk nabininjkobeng dja bebeywurd birridjarrkdoweng. Ngayembu kunmekbekenh kunu benbenehkongibun ngorrewoneng.” ");
INSERT INTO gup_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Wanjh beneyawoyhmarnenalkbom, wanjh ngalbu Orpah bibunjhmey ngarre ngalbinjmorne, biwoknang wanjh durndi kore ngarrekih kunred. Ngalbuyika ngalu Ruth, ngalu wanjh bimaddi. ");
INSERT INTO gup_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Wanjh Naomi bimarneyimeng ngalbu Ruth, “Yina, ngalbu ngudda ngunehbardkoni durndi kore nawu ngurrimud, dja ngudberre nawu ngurrihmarnedi yiwarrudj, dja kab yimunkekadju, ngunedjarrkdurndeng.” ");
INSERT INTO gup_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Wanjh Ruth biwokmey, “Yuwn yikebbabi kanhdjawan munguyh yimankek bu yiyime bawon, bad burrkyak, minj bawon mak ngarrurndeng. Bu yiman baleh yire kunukka ngarrdjarrkre, kore baleh yiyo, kunu ngarrdjarrkyo. Woybukkih duninjh nawu namud ngudda ke, nakka djarrkngarrku, nawu ngudda ke God, nakka djarrkngarrku yerreh. ");
INSERT INTO gup_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Bu baleh kore yarrkka yirrowen kumekbe wanjh ngaye mak ngarrowen, kudjalbolkkudjiwi kandibebbehkukdudjeng. Woybukkih duninjh marneyime minj bawon, dja kundjalkudji bu ngudda nuk yirrowen, dja kunubewu ngaye nuk, wanjh kunu kankuklarlmang ngarrku, djalbonj. Bu yiman kowe, wanjh kunu kamak nganbun nawu Yawey.” ");
INSERT INTO gup_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Bu Naomi binang Ruth njilngrayekminj, bimaddi duninjh bu minj durndeyi kore ngarrekih kunbolk, wanjh Naomi ngurdmeng bimenbawong. ");
INSERT INTO gup_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Wanjh benebaldjarrkwam benedjarrkbebmeng Bethlehem. Bu benebalbebmeng kumekbe bininj daluk birriwern bu bindinang birrikangebarrhmeng, wanjh bindiyolyolmi berrewoneng. Nawu daluhdaluk birrihdjawarreni, “Yiddok ngahli Naomi?” ");
INSERT INTO gup_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","21","Wanjh Naomi benwokmey, yimeng, “Yuwn kandiyawoyhngeybun Naomi bu kunmak, dja kandingeybu Mara bu kunnjilngwarre. Dja God nawu ngudjkimuk duninjh wanjh nungka marnbom ngardduk bu kunwernhrayek. Bu kondah ngabolkbawong ngakarrmi nawern, dja nungka Yawey ngandurndiweng bu ngabidlarrkminj. Njalekah wurd munguyh kandihngeybun Naomi? Bu Yawey ngandjalwarreweng ngaye. Yoh, nungka nawu Ngudjkimuk Duninjh, wanjh ngandjalwernhwarrewong ngaye.” ");
INSERT INTO gup_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Wanjh kunih kunmekbe kunu bu Naomi kumdurndi kore kunbolk Moabbeh, dja ngalbinjmorne ngarre Ruth benemdjarrkwam kumekbebeh kore ngalengngarre kunred. Bedda benebolkmey Bethlehem bu kerrngehkenh dedjdjingmey birrihmangi manme manbu kangeyyo barley. ");
INSERT INTO gup_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Kumekbe kore kunred Bethlehem wanjh nakudji bininj di nawu nakukenni duninjh, dja ngeyyoy Boaz. Nungka wanjh namudni Elimelech nawu Naomi ngalengngarre nabininjkobeng. ");
INSERT INTO gup_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Bu Ruth dja Naomi benehdi Bethlehem, wanjh Naomi bidjawam ngarre ngalbinjmorne, “Kanmunkewemen ngare kore kabbal kabirrihmang manmim ba ngare ngamoyhmang manbu yikahwi kabirrihbabawon. Kaluk ngangalke bininj nawu minj ngandahme, ngarrurrkmirri ngamoyhmang kore kumunke nuye.” Naomi biwokmey, bimarneyimeng, “Mah wanjh yiray Ngalkurrng.” ");
INSERT INTO gup_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Wanjh Ruth dolkkang wam kore kabbal, moyhmangi kumunke bedberre bininj nawu ngokko birrihmimmangi, wanjh mungu baldjalwam bebmeng kore Boaz kabbal nuye, nawu Elimelech benemudni. ");
INSERT INTO gup_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","5","Kaluk nungan Boaz kumbadbebmeng Bethlehembeh, wanjh Boaz benmarneyimeng birrimekbe bininj nawu birrihmarnedurrkmirri. Wanjh benmarneyimeng, “Ngadjare Yawey ngurridjarrkre.” Bedmanwali birriwokmey birriyimeng, “Ngudda warridj ngarridjare ngunnahnan kunmak rowk nawu Yawey.” Wanjh Boaz bidjawam nakudji bininj nawu wohrnani bedberre kumekbe nawu birrihdurrkmirri, wanjh Boaz djawayhmeng, “Ngahli daluk nangale kabenemud?” ");
INSERT INTO gup_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","7","Wanjh nawu wohrnani bininj biwokmey bimarneyimeng, “Ngahli ngalu ngalredbuyika kumdolkkang Moabbeh, Naomi benemdjarrkwam. Wanjh ngaleng ngandjawam nganmarneyimeng, ‘Kamak bu ngarrurrkmirri ngare kumunke bedberre ngamimmoyhmang?’ Wanjh djaldurrkmirrangeni kukabelkuyeng, dja kundjalkudji ngehmeng ni kudjurle.” ");
INSERT INTO gup_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Wanjh kunmekbekenh Boaz bimarneyimeng ngalmekbe daluk, “Kanbekka daluk, wokrayekwon, yuwn mak yire yimoyhmang kabbalbuyibuyika, dja ngurridjaldjarrkray nawu ngaye ngardduk yawkyawk ngalbu kabirrihdurrkmirri. Yinahna manmekbe kabbal munguyh manbu kabirrihdurrkmirri, kumunke yiray bedberre. Dja ngabenmarneyimeng nawu bininj ngardduk ngandihmarnedurrkmirri minj ngundikebkangbun. Bu yikombukdowen, yiray yibongun kore yawuhyawurrinj kabirrihborrahkendong kore budjdjurlung.” ");
INSERT INTO gup_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Bu kunmekbe bekkang bimarneyimeng nawu Boaz, wanjh ngalmekbe daluk barddurrukkurlhdanj mankang kunkeb bolkdoy kurorre, wanjh ngalengmanwali biwokmey, bimarneyimeng, “Njalekah nguddanu kankelkkelkbun, njale ngudda kanhnahnan ngayenu nuk kannan ngawokbuyika?” ");
INSERT INTO gup_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Wanjh nunganwali biwokmey, yimeng, “Ngabekkani ngandimarneyimi birriwern bu nguddakah kunwern bu yihnahnani ngalbinjmorne ke bu doweng nabininjkobeng ke, dja bu yibenbenebawong ngalbadjan dja mak kornkumo, dja mak bininj ke dja kunred ke yibolkbawong, dja yimwam kondanjkunu ngurriraworrinj kore minj korroko bininj yibenkukburrbuyi. ");
INSERT INTO gup_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Kaluk ngadjare Yawey nunganwali ngunmarnekurduyime kunmak yiman nguddahbu yihkurduyimi yibenhnahnani bedberre. Dja yimbadwam kore Yawey nawu God ngadberre nawu Israel ngankebmawahmeng, bu ngunnahnan munguyh. Wanjh ngadjare ngunwernhwon kunmakmak bulkkidj duninjh.” ");
INSERT INTO gup_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Wanjh ngalengmanwali biwokmey, yimeng, “Nguddanu wanjh yimak. Bu kunmekbe kanhmarneyime kanhnjilngmarnbun, dja yiman bu yiyime ngaye ngamak. Ngadjare kuhni kandjalmarneyime, dja bonj, ngaye ngaldjalwarre kore yawkyawk ngundimarnedurrkmirri.” ");
INSERT INTO gup_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Bu darnkih birrihngunikenh manme, Boaz bimarneyimeng Ruth, “Yibekkarrimen yimre ba won manme yingun, yiloddjuhke kore kunkalkkid yiman kayime wine rerrih.” Wanjh yerrkang kore kungurrird bedberre nawu manme birrihdjobkeyi kore birrihdurrkmirri, wanjh Boaz balweykang manbu mankerrikenh manmim, bibalwong Ruth. Nguneng manmekbe manmim manbu mankerrikenh, worrkminj, dja yikahwi bawong. ");
INSERT INTO gup_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Wanjh nguneng rowk manme dja dolkkang wam yingkihdokmeng kore birrihmimmoyhmangi. Wanjh Boaz benwokrayekwong bininj birrihdjobkeyi manmim, benmarneyimeng, “Ngurribawo ngahli daluk, kamoyhmang manmim kore mandobbokenh kore kayongoyo, dja yuwn ngurridjangnan. ");
INSERT INTO gup_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Dja mak ngurribalmarnedurrkdurrkma yikahwi kore mandobbokenbeh, ngurrikurrmekurrmen, kaluk ngalengman kaballe kamoyhmang, dja yuwn ngurriyirrung.” ");
INSERT INTO gup_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Wanjh munguyh djalmimmoyhmangi dja djalwam dungyibmeng, wanjh manbarnem ngarlahngarlhkeng, wanjh mimbarlmeng manwern mandobbokenhkimuk. ");
INSERT INTO gup_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","19","Wanjh kang kured, balkanakang birrelengbukkang ngalbinjmorne ngarre, wanjh bebkeng manmekbe manbu manbarnangarrakenh manbu bawong, wanjh biwong ngalbinjmorne. Wanjh ngalbinjmorne ngarre bimbaddjawam, “Baleh kab kunu yihmimmoyhmangi? Nangalehmayh nanu kabbal nuye yihdurrkmirri? Ngadjare God kabimarneyime kunmak namekbe bininj nawu ngunhnahnani.” Wanjh Ruth ngalengmanwali bimwokmey ngalbinjmorne ngarre, bimarneyimeng, “Ngahdurrkmirri kore kabbal nuye bininj nawu djaying kangeyyo Boaz.” ");
INSERT INTO gup_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Wanjh Naomi welengyimeng, “Ngadjare Yawey kunmakmak kabiwon. Nahni bininj nawu yingeybom, Boaz, nanu wanjh namud ngad ngarrku darnkih duninjh, mankarre kahyo namekbe nanu nungka wanjh bu karrurrkmirri ngarrku kannahnan warridj. Bu kuhni ngunmarneyimeng ngaburrbun bu Yawey minj kabengmidjdan bu kanberrebbun kadberre, dja kanhwon kunmakmak nawu djedjenkurrmeng kadberre rowk, nawu karrimimbi dja ngarrku bininj dorrengh nawu birridowerrinj.” ");
INSERT INTO gup_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Wanjh Ruth biwokyolyolmeng Boaz kore biwokrayekwong, bu bimarneyimeng, “Yirrarnhdurrkmirrin kore nawu ngaye ngardduk bininj kabirrihdurrkmirri, yidjalle yiburnbun bu kabirriyakwon manu manmim ngardduk.” ");
INSERT INTO gup_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Wanjh Naomi yimeng, “Wanjh kunmak kunu Ngalkurrng, bu ngurrihdjarrkdurrkmirri daluhdalukdeleng nawu nungan nuye kabirrihmarnedurrkmirri, dja yuwn yire kabbalbubuyika, wardi ngundikebkangbun.” ");
INSERT INTO gup_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Wanjh Ruth djalkurduyimi kunmekbe munguyh, birrihdjarrkrey daluhdaluk nawu Boaz nuye birrihmarnedurrkmirri, ngaleng dorrengh birrihdjarrkmimmoyhmangi. Wanjh mimyakminj manbu manmim kangeyyo barley, dja mak manbuyika manbu wheat. Ngaleng benehdjalyoy munguyh ngarre ngalbinjmorne. ");
INSERT INTO gup_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Kalukburrk wanjh Naomi bimarneyimeng ngarre ngalbinjmorne, “Ngalkurrng, kab ngakarremarnbun bu bininj ba ngunemarren bambu kunmak rowk yini? ");
INSERT INTO gup_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Namekbe yiburrbun nawu Boaz, yawkyawkbubuyika ngurrihdjarrkdurrkmirri kore kabbal. Yuwn yikukbengmidjdan, nakka wanjh ngad ngarrku namud. Kanbekka, marneyime, kuninjkunu kumunun nungkambu kabadre kakakmimkarrhkarrhme kumekbe kore kabirrihmimbun. ");
INSERT INTO gup_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","5","Mah. Wanjh yiwurlebmen yikukdelkdelkkerrimen nawu manjmakmak, dja yidjongburrimen nawu namakmak. Wanjh bu yibekkarren wanjh yibalkolu kunmekbe kore kabirrihmimbun. Dja yuwn yibangmekukbebme nuye, dja yibawo med, yimengordmadbu kangun kabongun kayakwon. Bu kakeyongen, med yikodjkebawo kakerrowen, wanjh kunmekbe kunu yiballay yirrengewerrhme nuye, wanjh yikekurrmerren. Kaluk nungan ngunmarneyime bu baleh yikurduyime.” Wanjh Ruth ngalengmanwali bibalwokmey ngalbinjmorne ngarre, yimeng, “Wokkarrme rowk bu yarrkka kanhmarneyime.” ");
INSERT INTO gup_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","7","Wanjh Ruth balkoluy kumekbe kore birrihmimbuni, kundjalmekbe kurduyimeng bu ngalbinjmorne ngarre bihwokrayekwoni bihmarneyimi. Kaluk Boaz bu nguneng dja bonguneng bekkarrinj kangemakminj, marrmarrminj duninjh, wanjh wam kekurrmerrinj kore manmim mimluhmimlulhdi. Kaluk Ruth baldjemhdjemhmiwam, birrengewerrhmeng wanjh balkekurrmerrinj. ");
INSERT INTO gup_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kumununburrk Boaz lorrmeng, wanjh borledmeng darnhkangebarrhmeng binang daluk kahdarnhkeyo kurrenge nuye. ");
INSERT INTO gup_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Wanjh bidjawam, “Ngalngale nguddanu?” Wanjh ngalengmanwali bibalwokmey yimeng, “Ngayenu Ruth, ngudda nawu darnkih ngarrmud ngadberre nawu ngudda kanmarnewohrnan. Wanjh ngadjare ngudda kannahnan dja ngarrmarren.” ");
INSERT INTO gup_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boaz yimeng, “Wanjh ngaye ngadjare Yawey ngunmarnekurduyime kunmak ngudda nawu ngalyahwurd ngardduk. Kerrngehkenh bu yingulkmakni bu kunmekbe yihdjalyimi yihnahnani ngalbinjmorne ke, wanjh ngunemdjarrkwam, dja bolkkime kunmekbe kayime yerreh yiwernhngulkmakminj duninjh, bu minj yawurrinj yiyawayi ngunemarrimeninj nawu nakuken dja mak nawu namarladj. ");
INSERT INTO gup_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Wanjh kanbekka, yuwn yikele, dja birrimirndewern rowk nawu kondah kabirrihni, kabirriburrbun bu nguddanu yidjalmak daluk. Kaluk kunmekbe ngakurduyime ke bu ngudda yarrkka kandjurrkkan. ");
INSERT INTO gup_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Woybukkih wanjh ngaye kunu namud darnkih ke nawu marnewohrnan, dja mak nabadbuyika bininj kumekbe kamhdi nawu mak darnkih duninjh namud ke. ");
INSERT INTO gup_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","14","Med dja bolkkime kumunun yikeyuwn, kaluk malamalaywi ngare ngabekkan namekbe nawu bininj bu kunubewu ngunmarnewohrnan. Bu baleh kayime, nungka kadjaremen ngunnahnan, wanjh kunu bonj, dja bu minj kadjaremen ke ngunnahnan, wanjh kunu ngayeman nahnan. Ngarayekwon kunwok kore Yawey nawu kadjalmimbi munguyh. Med yikeyuwn, kaluk kabarrhbun.” Wanjh Ruth balkekurrmerrinj kore kurrenge nuye. Dolkkang bu djarreh kumhkabelni ba minj nangale biwernhkukburrknayi. Boaz yimeng, “Minj ngadjare nangale kabekkan bu daluk kumwam kondah kore kabirrimimbun.” ");
INSERT INTO gup_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Dja mak bimarneyimeng ngalmekbe Ruth, “Yiyerrkkerrimen nawu kaddum yihdjongbuyindi yimwaynamen.” Balwaynameng wanjh nungka dahkendoy manbu manmim manwern, wanjh bimimngorrkenwong kore kukarlang ngarre. Wanjh Ruth balbidbom yirrurndi balwam kore kukadjeh. ");
INSERT INTO gup_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","17","Balwam bimarnebebmeng ngalbinjmorne ngarre, binang kumhdi bimdjawam, “Kaluk kuhni yiddok kamak rowk Ngalkurrng bu yiwam?” Wanjh Ruth ngalengmanwali bimbadwokmey bimarneyolyolmeng rowk kore Boaz bihmarnekurduyimi. Dja mak bibadmarneyimeng ngalbinjmorne ngarre, yimeng, “Dja nungka minj djareniwirrinj ngaye ngamlarrkdurndeyi kore ngudda. Kunmekbe kunu nganwong manih manbu manwern manme.” ");
INSERT INTO gup_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomi biwokmey bimarneyimeng, “Med, yibengyirrin Ngalkurrng, kaluk yibekkan bu kunwok bu kamarnbuyindan, minj bolkkime bu kabolkmang, dja werrkwewerrkwerrk kadjalle ngunmarnekarremarnbun.” ");
INSERT INTO gup_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Wanjh Boaz bidbom kore birrihmirndemornnamerreni birrihyolyolmi mankarre kore kururrkdangmaye ngarre kore kukadjeh, kumekbe yerrkang ningihni. Kaluk Elimelech nuyeni namud darnkih duninjh nawu Boaz biyolyolmeng kumhdjalley. Wanjh Boaz bimarneyimeng, “Buyh! Ngudda nawu yihre, dabbolk! Yimbarlungmen, kondah yiyerrka.” Wanjh kumbarlungmeng yerrkang. ");
INSERT INTO gup_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Wanjh Boaz benmey kunbid dja kunbid nawu birribuyika bininj birrikihkimuk, benmarneyimeng, “Kondah ngurrimyerrkarrimen.” Wanjh bedmanwali birriyerrkarrinj. ");
INSERT INTO gup_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Wanjh Boaz biwelengmarneyimeng namekbe namud nawu ngokko bikimey, yingkihyingkihni kumekbe, bimarneyimeng, “Naomi ngalbu kumdurndi Moabbeh kadjare kaweykan kabbal kunyahwurd bu nuyeni nawu ngad kanemud Elimelech. ");
INSERT INTO gup_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ngamwam ngadjareminj bengdayhke marneyime, yirrangduluburrimen kayime kore kumirrk bedberre nawu karrihni, nanih birrikihkimuk dorrengh, nawu kabirriwohrnan kore kunred. Ngudda bu yidjaremen yirrurndiwe, wanjh kunu yirrurndiwemen, dja bu burrkyak, wanjh kanmarneyimen ba ngaburrbun. Minj mak nangale nabuyika karrurndiwe, dja ngudda nawu yikukdokme dja ngaye yerre balhmarnedi.” Namekbe bininj kumyimeng, “Ngoyh, ngarrurndiwe manmekbe kabbal.” ");
INSERT INTO gup_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Wanjh Boaz balyimeng, “Bu yiman yirrangduluburren kunekke kabbal kore kubid Naomi, wanjh kunu Ruth dorrengh yimang, ngalbu kamarrdjukun ngalkang Moabbeh, ba bu wurdyaw yibornan wanjh nuye namekbe nawu doweng ba kabbal kakarrme kore nuyeni manbu bolkwakwam nawu doweng.” ");
INSERT INTO gup_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Wanjh namekbe nabuyika namud yimeng, “Ngayenu nuk minj ngarrurndiwe manmekbe kabbal, kakarrewarre, minj kunmekbe ngakurduyime. Bu yimankek ngarrurndiwe, wanjh kunu minj ngad ngadberre wurdwurd, dja nabuyika nuye nawu doweng. Dja yingan yimang yidjaldurndiwemen manmekbe kabbal dja ngayenu kakarrewarre minj ngarrurndiwe.” ");
INSERT INTO gup_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","Kuninjkunu korroko kore Israel, bu birrikurduyimi, birridurndiweyi birriworreni birrimulewarreni bu kunwoybuk yongeni, wanjh nakudji balwelengdengeyerrkkerrinj biwong nabuyika. Kunmekbe kunu mankarre yoy bedberre bu karremarnbuyindangeni. Wanjh bu namekbe nawu namud nawu kumhkukdokmi nuye nunganwali bimarneyimeng Boaz, “Yingan ke wanjh yirrangduluburrimen manmekbe kabbal.” Wanjh kumbadyerrkkerrinj nawu kundengekenh, nawu ngokko kumhwokdi, dja biwong. ");
INSERT INTO gup_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Wanjh Boaz benwelengmarneyimeng nawu birrikihkimuk kumekbe birrihdjarrkni, dja mak nawu birriwern bininj, yimeng, “Ngudda wanjh bolkkime kandinang kunmekbe ngakurduyimeng, ngarrangduluburrinj kore Naomi namekbe rowk nawu bedberreni Elimelech dja bebeywurd nuye bokenh Chilion dja Mahlon. ");
INSERT INTO gup_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Dja Ruth warridj ngalbu Moabbeh, kamarrdjukun nuyeni Mahlon, ngaleng warridj ngamang ngardduk ngalbininjkobeng, ba ngabornan beywurd bu bininj wanjh kawayhke kunngey kore nuye nawu doweng, kore kunred nungan nuye kabolkkarrme ba kunngey nuye nawu doweng minj kadjobme kore namud nuye dja kore kunred nungan nuyekih. Ngudda rowk kandinang bolkkime bu kunmekbe ngakurduyimeng, ba bu ngurriyolyolme bu kandinang bu kunmekbe ngakurduyimeng.” ");
INSERT INTO gup_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Wanjh namekbe nawu bininj birrihmirnderri kore kurrangmaye kumekbe kukadjeh, birrikihkimuk warridj birriyimeng, “Yoh ngundinang bu kunmekbe yikurduyimeng, kaluk ngarriyolyolme. Dja ngarridjawan Yawey kabimarnbun ngalmekbe daluk ngalbu kumngimeng kore ngudda bu kayimerran yiman Rachel dja Leah nawu benehmangi nawern wurdyaw nuyeni Jacob, wanjh yikukenmen dja ngundiburrbun rowk nawu kabirrini kore kunred Bethlehem. ");
INSERT INTO gup_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Mak ngad bu ngarridjare bu Yawey ngunwon wurd nawern kore ngalinjngalu daluk, kamarnbuyindan namud ke yiman karohrok Perez nuye namud nawu wurdyaw berrewonengni Judah dja Tamar.” ");
INSERT INTO gup_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","14","Wanjh Boaz bimey Ruth ngalbininjkobeng nuye, wanjh benebalmarrinj, benewam kore kunred nungka nuyeni, kumekbe benehyoy. Beneyonginj, wanjh Yawey benbenewong nawu wurdyaw bu yawmey narangem. Wanjh morlehmorlenjbubuyika birrimarneyimeng Naomi, “Karriburlumen duninjh Yawey nawu ngunkarrmeng, bu munguyh minj yiniwirrinj yimudyakniwirrinj. Ngarridjare namekbe wurdyaw birriwern kabirriburlume dja kangeykukenmen kore Israel. ");
INSERT INTO gup_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ngalbu ngudda ngalbinjmorne ke ngunmarnedjare duninjh, dja bu yikarrmeninj kunbidkukudji dja bokenh seven yayaw nawu bininj, wanjh yinjilngmakniwirrinj, dja ngalinjngalu yikarrme Ruth, ngalbinjmorne ke ngalbu ngunwernhnjilngmarnbun duninjh, wanjh ngaleng ngalbu yawmey namekbe narangem, nawu yihyime Makkah. Wanjh nungka nawu namekbe ngunkangekerrngehme, dja yiman ngunkukkerrngehme bu yikohbanjmen.” ");
INSERT INTO gup_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Wanjh Naomi bimey namekbe wurdyaw, biwanjbikarrmi, binahnani. ");
INSERT INTO gup_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Dja kaluk nawu morlehmorlenj kumekbe birrimhdarnhyoy, birrimekbe nanu birringeykurrmeng Obed, birriwokkihyiyimeng dorrengh, “Naomi, bimarnedanginj Namakkahmikenh.” Wanjh namekbe nawu Obed kaluk bu dabbolkminj wanjh bibalbornang Jesse, kalukburrk Jesse bibalbornang David. ");
INSERT INTO gup_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Nahni wanjh birrimekbe nawu Perez nuye namud birribalhbornabornarreni. Perez kornkumo, beywurd nuye Hezron. Hezron kornkumo, beywurd Ram. Yibeng Ram bibalbornang Amminadab nuye beywurd. Yibeng Amminadab kornkumo, bibalbornang Nahshon. Yibeng nunganwali Nahshon, bibalbornang Salmon beywurd nuye. Salmon kornkumo, bibalbornang Boaz nuye beywurd. Yibeng Boazwali bibalbornang, kornkumo Boaz, beywurd nuye Obed. Yibeng nunganwali Obed kornkumo, bibalbornang Jesse beywurd. Dja Jesse kornkumo, David wanjh beywurd. Kumekbe wanjh kunu kabalyirriyo kore birribalhbornabornarreni. Bonj. ");
INSERT INTO gup_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Nawu KAWOHRNAN bimarneyimeng Elijah. ");
INSERT INTO gup_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Ngaye ngamarneyimeng kamarrdjukun kore kunred Zaraphath yingimen kore Sidon ba ngunwon manme. Ngudda yirey kore kunbolkkimuk, kumekke yini.” ");
INSERT INTO gup_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Wanjh Elijah kumwam darnkih kore kunbolkkimuk kunrrukdangmaye ngalengarre Zaraphath. Nungka binang ngaleng kamarrdjukun menehme manyahyay nungka bidjawam “kamak ngudda yimka ngarduk kukku.” ");
INSERT INTO gup_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Ngaleng wam bomey kukku dja biyawoyhdjawam, “kamak ngudda yimka ngardduk manyahwurd buriddi.” ");
INSERT INTO gup_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Kamarrdjukun ngaleng biwokmey, “marneyimeng kore kungey nuye God nawu KAWOHRNAN nawu nawernkimuk. Ngaye minj ngakarrme manbu buriddi ngayime woyhbukki. Ngaye ngakarrme manyahyey mane wanjh bolkkime ngare kured. Ngaye djal ngakarrme manyahwurd kandidjawa dja mak kunkalkid. Wanjh ngakinje ngarrewoneng ngaye dja ngardduk nayawh yerre wanjh bu nganemarrwern dowenh.” ");
INSERT INTO gup_vpl VALUES ("K117_13","012_17_13","1KI","17","13","14","Elijah yimeng, “Nawu YIWOHRNAN, God kore Israel bu kakurduyime kunmak kabolkbarrabarrkmeng. Nguddangke banikin kandidjawa minj kayakmen nguddangke budjulung kunkalkid minj mak kayakmen. Bu wanjh yerre kamunkewe mandjewk. Bu ngudda wanjh yiyimeng, yirrokmen kured. Dja yikinjemen manyahwurd buriddi bu yimkan kore ngaye dja yikinjemen ngurrewoneng. Wanjh bonj bu kunmak rowk.” ");
INSERT INTO gup_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Ngalmekbe ngalbu kamarrdjukun dokmeng kured marnbom rowk bu Elijah bimarneyimeng. Ngalbu kamarrdjukun ngalengngarre nayawh dja Elijah birrikarekarrmeng manme bedberre kunkuyeng. ");
INSERT INTO gup_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Nawu KAWOHRNAN bimarnewokdanginj Elijah. Wanjh nawu ngalengarre rowk kamarrdjukun, banikin kandidjawa minj kayakmen dja budjulung kunkalkid minj mak kayakmen, kuhni kurdduyimerranj rowk. ");
INSERT INTO gup_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Bininj nawu kadjalwarnyak kabekkabekkan kunwok bedberre birribuyika bininj nawu kunwarre kabirrikurduyime, wanjh nakka God kabimarnekurduyime kunmak. Nahni bininj minj kabenngunjdjikkan birribuyika bininj nawu kunwarre kabirriyime, mak minj kabirriraworren bininj nawu kabirridjekmiwon God bu kabirrimalehmalelwon. ");
INSERT INTO gup_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Nawu namak bininj, wanjh kunbuyika kakurduyime. Nungka kadjalborlhme Yawey nuye mankarre manbu kabinjilngmarnbun. Nungka kadjalburrbun mahni mankarre kunbarnangarrakuyeng dja mak kunkakkuyeng. ");
INSERT INTO gup_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Namekbe bininj yiman kayime manbu kahdulkdi darnkih kore mankabo. Manmekbe kundulk kaluk kakarrme manwern manme, dja mak minj kamarlaworrdowen. Wanjh kore njalehnjale kakurduyime, wanjh kunmak rowk kabimarnebebme. ");
INSERT INTO gup_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Dja nawu birriwarre bininj minj kunmekbe kakurduyimerran bedberre. Bedda wanjh yiman kayime kundalkdarleh manbu kunmayorrk kabuhbuhme dja kadjalburriwe. ");
INSERT INTO gup_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","God kabendjadme dja kabenwarrewan nahni birriwarre bininj. Wanjh minj bedda kabirriraworren nawu God nuye bininj bu kabirridjarrkmarnedi yiwarrudj nuye. ");
INSERT INTO gup_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Kaluk nawu Yawey munguyh kabendjalnahnan nawu birrimak bininj; dja nawu birriwarre bininj wanjh nakka kabenbawon kabirridjalyakmen. ");
INSERT INTO gup_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Njalekenh bininj nawu kabirriwohrnan kunredbubuyika bedberre kabirridjalkarremarnburren bu kabirrikurduyime kunwarre? Dja njalekenh birriwarlahkenh bininj rowk kabirrimarnburren bu kunwarrekenh kabirrikurduyime? Bu kabirrirohrokme, wanjh kabirridjalbarabun! ");
INSERT INTO gup_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Nawu kings dja princes kondah kurorrebeh wanjh kabirriwokburriwe nawu Yawey. Bedda wanjh manmolk kabirribekkarren bu kabindibunkenh Yawey dja mak namekbe bininj nuye nawu bikodjdjuhkeng mankalkkid dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Bedda kabirriyime, “Mah! Karriwe God nuye wirlmurrng chains, dja karringehkerren kore nungka kandukkang bu kankarrme!” ");
INSERT INTO gup_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Dja God nawu king duninjh kahni kore heaven, wanjh kabendjekmiwon bedberre. Nawu Kawohrnan Rowk kabenmalelwon bedberre. ");
INSERT INTO gup_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Wanjh kabendung bu kabenwokrayekwon, dja kayiddung bedberre, mak kabenmarnbun kabirridjalkelemen. ");
INSERT INTO gup_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Wanjh kamulewarren bedberre, kayime, “Ngaye wanjh ngakurrmeng king duninjh nawu ngaye ngamunkeweng kore kunred Zion, kore kuwarddekimuk ngardduk, manbu kubolkdjamun duninjh!” ");
INSERT INTO gup_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Wanjh namekbe nawu king kayime, “Ngaye ngamulewan kore nawu Yawey nganbengdayhkeng, yimeng ngardduk, ‘Ngudda wanjh beywurd ngardduk. Bolkkime ngaye ngayimerranj ke kornkumo. ");
INSERT INTO gup_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Kanmarrkdjawan njalehnjalekenh, dja ngaye won ngudda kunbolk rowk kore birriwarlahkenh bininj kabirrihni, dja wanjh kondah kurorre rowk kayimerran ngudda ke. ");
INSERT INTO gup_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ngudda yiman yibenbakkebakke kundulkwi wirlmurrng dorrengh; yibendjalbarrhke yiman kayime plate.’ ” ");
INSERT INTO gup_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Mah, wanjh ngudda nawu kings rowk, ngurrinahnarrimen dja kandibekkabekkan kore marnebengdayhke, ngudda nawu ngurrbenmarnewohrnan binihbininj kondah kurorre! ");
INSERT INTO gup_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Ngurrimarnedurrkmirrin nawu Yawey dja ngurrimarnekelenin. Ngurrikukdeldelmen bu ngurrinjilngmarrmarr nuye. ");
INSERT INTO gup_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Ngurriburlumen nawu nuye Beywurd ba minj kawernhdung dja ngunbularrbun ngudberre, dja wardi ngurridjaldowe bu ngurriwokburriwe nuye. Nungka wanjh karrung kundjalburrikudji. Dja bininj nawu kabirridjare nungka kabenngehke, wanjh kabirrinjilngmak. ");
INSERT INTO gup_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Ngudda Yawey, ngaye ngabenkarrme birriwern bininj nawu ngarriyidko! Birridjalwern ngandiwirrihme! ");
INSERT INTO gup_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Birriwern bininj ngandiyolyolme, dja kabirriyime, “Nawu God minj kabibidyikarrme.” ");
INSERT INTO gup_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Ngaye wanjh ngaburrbun bu ngudda Yawey nawu yiwernhmakkaykenh, dja ngudda kankukdjurruddi yiman shield ngardduk dja kankangemarnbun. ");
INSERT INTO gup_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Wanjh ngaye ngakelekayhme nuye nawu Yawey, dja nungka ngankayhmimang kore kaddum kuwarddekimuk kubolkdjamun nuye kahni. ");
INSERT INTO gup_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Bu ngakekurrmerren wanjh ngadjalkodjkeyongen. Kaluk ngayawoyhdolkkan, dja nawu Yawey nganahnan ba ngadjaldarrkiddi. ");
INSERT INTO gup_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Kunmekbekenh ngaye minj ngabenkengeme birridjalwern duninjh bininj bu kabirrimyorrme dja ngandidjokohme kuhri kuhri. ");
INSERT INTO gup_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Yawey, yirrolka! Kanngehkemen, ngudda nawu God ngardduk! Yibendjalbun nawu ngandiwirrihme, yibenkiyarrkdo dja yibenyidmebakke bedberre bininj nawu kunwarre kabirriyime. ");
INSERT INTO gup_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yawey ngudda yidjalkudji kanngehke kore ngarribongdi. O Yawey, ngarridjare ngudda kunmak kanmarnekurduyime ngad bininj ke. ");
INSERT INTO gup_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Ngudda nawu God ngardduk, ngaye ngakayhme dja ngadjare kanbekkabekkan dja kanwokmang. Ngaburrbun ngudda bu yidjalmak duninjh. Bolkkime kankongibu dja kanbekkan bu yiwarrudj ngarri. Dja kunyid nganmarnengalmeng dja wernmerrinj ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ngabenmarneyime nawu birriwern bininj, ngayime, “Ngudda nawu djalbininj, njalekenh kandidjalngeywirrihme? Yiddok ngudda munguyh ngurrimunkekadjung kunwok manbu minj kunwoybuk, ngudda nawu ngurrbenyawan gods nawu kabirrikurren munguyh? ");
INSERT INTO gup_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Ngurriburrbu! Nawu Yawey bendjarrngbom bininj nuye nawu kunmak kabirridjalkurduyime. Mak nungka nganbekkan ngaye bu yiwarrudj ngarri nuye. ");
INSERT INTO gup_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Mah, ngudda bininj bu ngurriyiddung, wanjh bu yuwn kunwarre ngurriyime. Mak bu ngurrikodjkekurrmerren wanjh ngurridjalburrbu bu njale kunmayali ngurrikarrme baybaywi kore kukange, dja kunu ngurridjalwokyak. ");
INSERT INTO gup_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Ngurriwo dja ngurribu mayh nawu Yawey kadjare. Ngurridjalwoybukwo dja ngurriwokmarrkma nuye.” ");
INSERT INTO gup_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Birriwern bininj kabirrihdjawayhme, bu kabirriyime, “Kaluk nangale kanwon kunmakmak kunwern kunmak? Ngudda Yawey, kanna ngadberre kunkongi dorrengh.” ");
INSERT INTO gup_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Dja ngaye ngayime bu ngudda Yawey kankangebarlkeng ngardduk kunnjilngmak dorrengh ke. Ngaye ngawernhnjilngmakminj kore ngudda, dja birribuyika bininj kabirrinjilngmak bu kabirrikarrme manwern manme dja manbomak manbu wine. ");
INSERT INTO gup_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Dja mak ngaye ngakodjkekurrmerren dja ngadjalkeyo kunmodmikenh dorrengh bu kunmekbekenh ngudda Yawey yidjalkudji kannahnan dja kanngehke munguyh. ");
INSERT INTO gup_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Ngudda nawu Yawey, kanbekkabekka ngaye bu yiwarrudj ngahdi! Mak kanbekkan bu ngaye ngahngolekdurrkmarren. ");
INSERT INTO gup_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ngudda wanjh king ngardduk dja mak God ngardduk. Wanjh kanbekkabekka kore ngakayhme dja djawahdjawan ngudda bu kanbidyikarrmekenh. Ngaye wanjh ngahdjaldi yiwarrudj bu marrkdjawan ke, ngudda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Bu kunkabel rowk ngudda kanwokbekkan. Kunkabelbubuyika ngaye ngamkan kunwok ngardduk kore kumirrk ke, dja yeledj ngadjalmadbun kaluk bu ngudda kanwokmang. ");
INSERT INTO gup_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Ngudda minj ngurrirohrok nabubuyika gods. Ngudda minj yinjilngmak kore njalenjale nawu nawarre. Kaluk nawu birriwarre bininj nakka minj ngurridjarrkyo kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Mak bininj nawu kabirrihburlumerren nakka minj kabirridi kore kumirrk ngudda ke. Ngudda wanjh yibenwidnan bininj rowk nawu kunwarre kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Ngudda yibenbularrbun bininj nawu kabirrihkurrehkurren dja mak nawu kabindibalkowe birribuyika. Kaluk ngudda nawu Yawey yibenwernhwidnan bininj nawu kabindibun kabindikukkurrme birribuyika. ");
INSERT INTO gup_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ngaye wanjh, ngudda kanmarnedjare bulkkidj duninjh, dja kunmekbekenh kunu ngaye ngamre dja ngamngime kore ngudda ke kunred. Mak ngabarddurrukkurlhdan dja marneboddan ke, kore manrurrkdjamun manbu temple ke. ");
INSERT INTO gup_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Yawey ngudda, ngaye ngabenkarrme birriwern bininj nawu ngandiwidnan. Ngudda nawu mandjad duninjh yidjalburrbun, wanjh kanka kore mandjad manbolh. Mak yibolhdjaddjadwo ke manbolh kore kumirrk ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Nawu birrimekbe birriwarre bininj wanjh munguyh kabirridjalkurrehkurren dja minj kunwoybuk kabirridjalwokdi. Bedda wanjh kabirridjare bu kabindiwarrewon nawu birribuyika bininj. Bedberre kunwok, makka yiman kayime kumidj kawokdi kore kurorre. Bedberre kundjen, wanjh kadjare kadjalkurrehkurren munguyh. ");
INSERT INTO gup_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","O God, yibendjadmen dja yibenwarrewan. Warridj ngadjare kabirrikukkolung kore manwarrehwarre mankarre kabirrihmarnbun. Bedda minj ngundiwokmarrkmang, wanjh yibenkukmunkewemen ba bu kanbawon munguyh. ");
INSERT INTO gup_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Dja bininj nawu kabirrimre kore ngudda ba yibenkukdjurruddin, wanjh nakka birriwernhnjilngmaknin! Dja mak munguyh birriwayinin kunnjilngmak dorrengh. Mak yibenkukbarrkbu kunbid ke dorrengh, ba kunukka kamak kabirrini birrimekbe nawu ngundimarnedjare duninjh. ");
INSERT INTO gup_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","O Yawey, woybukkih ngudda kunmak yibenmarnekurduyime bininj nawu yibenmakwan. Mak yibenkukbalhme dja yibenmarnekukdjurruddin bedberre. ");
INSERT INTO gup_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Ngudda nawu Yawey, yuwn kanbun bu yiyiddung ngardduk. Mak yuwn kanbengyolyolme kunrayek dorrengh kore ngudda bu kanmarnekangewurlhme. ");
INSERT INTO gup_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Yawey kankongibu! Ngaye ngangudjwarreminj. Kanmarnbu! Ngaye ngawernhbabang kore kunmurrng rowk ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Mak ngakangewarre duninjh dja baleh kabolkyime bu ngudda kanbidyikarrme? Yiddok kunkuyeng duninjh? ");
INSERT INTO gup_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","O Yawey, yimborledmen dja kanngehke kore ngabongdi. Ngudda kandjalmarnedjare munguyh munguyh, wanjh kunmekbekenh kunu kanngehkemen. ");
INSERT INTO gup_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Bu ngad bininj ngarridowen, wanjh minj ngundiyawoyhburrbun. Nangale bininj mak ngunyawoyhburlume bu kahkukdudjindi kanjdji kore kumidj? ");
INSERT INTO gup_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ngaye ngangudjyakworrinj kore ngadjakbekkabekkani munguyh. Mak kunkakkuyeng nganalkkihyoy. Wanjh manbu kunmadj ngahdahkendi makka madjkihminj kunmimnalk ngardduk dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Mak ngawernhnjilngwarreminj duninjh, dja kunmekbekenh minj ngawernhbolknan. Mak ngamimwarreminj kunmimnalk dorrengh bu nawu ngarriyidko bininj ngandinjilngwarrewong. ");
INSERT INTO gup_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Ngudda bininj nawu kunwarre ngurrikurduyime, wanjh kandibawo, ngurriray! Nawu Yawey, nakka nganbekkang kore ngahnalkbunalkbuni. ");
INSERT INTO gup_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Nawu Yawey nganbekkang kore ngakayhmeng dja ngadjawam bu ngankongibun. Mak nawu Yawey nganwokmang kore ngahdi yiwarrudj nuye. ");
INSERT INTO gup_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Bininj rowk nawu ngandiyidko, wanjh kabirriyemengalme, dja kabirrikangewarremen. Bedda wanjh kundjalburrikudji kabirridjalbarabun, mak kabirridurnden dja ngandidjalbawon ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Ngudda Yawey, nawu God ngardduk, ngaye ngawarlkkarren kore ngudda ba bu kannahnan. Kanngehkemen kore birriwarre bininj rowk nawu ngandihkelekadjung. ");
INSERT INTO gup_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Wardi bedda ngandibun ngandikukdjalkdjalkmang yiman nabang lion. Bedda kabirridjare ngandikan kore minj nangale nganbidyikarrme, dja wanjh ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Yawey, ngudda nawu God ngardduk! Ngaye minj nangale bininj ngawarrewoyi. ");
INSERT INTO gup_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Mak nawu nganedabbolk nakka minj ngawarrewoyi. Dja minj mak ngadjirdmayi nuye bininj nawu nganeyidko bu djal burudjang. ");
INSERT INTO gup_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Bu kuhni ngaye ngakurduyimeninj wanjh ngudda yibawo bininj nawu ngarriyidko bu nganngudjkadjung, ngandarrkidmang dja ngandibun, kaluk bu ngankukbawon kore kurorre ngahkukyo. ");
INSERT INTO gup_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Wanjh ngudda nawu Yawey, wardi yiyiddu! Yibenbu nawu ngaye ngandihnjirrhmiwon. Dja yibenmarnekurduyimen mandjad kore yibendjadme. ");
INSERT INTO gup_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Mak ngadjare yibenmirndewo bininj nawu kubolkbubuyikabeh kore ngudda yihyerrkan kore throne kaddum yihbarndi. Ngudda yibenmarnewohrnawohrnan rowk. ");
INSERT INTO gup_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Ngudda nawu Yawey yibendjadmen nawu kubolkbubuyikabeh bininj rowk! Mak ngaye warridj kandjadmen ngudda nawu Yiwernhwohrnan Duninjh! Ngudda wanjh kankangedjadme dja kanrohrokme wardi bu ngaye ngamak bininj. ");
INSERT INTO gup_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Ngudda kanmayalinan dja mak kankangenan warridj, wanjh ngudda nawu kundjalmak yidjalkurduyime. Mak ngadjare bu ngudda yibenmarnbu nawu birribang bininj bu kabirringurdme kabirrihkurduyime kunwarre. Dja kannahna ngadberre bininj nawu ngundiwoybukwon. ");
INSERT INTO gup_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Ngudda God nawu Yiwernhwohrnan Duninjh, ngudda wanjh kankukdjurruddi yiman shield ngardduk, mak yibennahnan munguyh bininj nawu mandjad kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Ngudda yinan kore kunmak kadjalkurduyimerran dja yibendjadme bininj bu djal mandjad. Wanjh ngudda kunbarnangarrabubuyika yiyiddung wernkih kore yibennan bininj nawu kunwarre kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Bu baleh yarrkka nawu ngurriyidko minj kabirriborledme dja kabirribawon kunwarre bedberre, wanjh ngudda yidjurrbun nawu mandjawak dja kamarnbun bunarra kunkak dorrengh ba bu yibenbun. ");
INSERT INTO gup_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ngudda wanjh yiyingkihmarnbun manbu yibenbunkenh. Manbu bunarra dorrengh yingkihmang ba bu yiwurlhke bu yibenmarnewe nawu nawarre bininj. ");
INSERT INTO gup_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Nawu nawarre bininj nakka kabirrimayalimarnburren ba bu kunwarrekenh kabirrikarremarnbun dja kabirrikowekowe. ");
INSERT INTO gup_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Wanjh birrimekbe bininj nawu kunmekbe kabirrihkurduyime nakka wanjh kabirribolkkarung kanjdji duninjh, wanjh bedmanbidju kumekbe kabirrikukwarrhme. ");
INSERT INTO gup_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Manbu kunyid kabirrimarnbun makka wanjh kamdurndeng bedberre bedda, wanjh kabirrikodjkuluwarremen kore bedmandeleng kunwarre kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Ngudda Yawey nawu yidjalkurduyime kunmak kore djal mandjad munguyh munguyh, dja kunmekbekenh ngaye ngawayini ke bu ngeyburluburlume ngudda Yawey nawu Yiwernhwohrnan Duninjh. ");
INSERT INTO gup_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Ngudda nawu Yawey, nawu Yiwohrnan ngadberre! Manbu kunngey ke, wanjh manwernhngeymakkaykenh duninjh kore kubolkbubuyika rowk kondah kurorre! Dja ngudda nawu yihni kaddum kore heaven kore ngudda ke kunmakmak duninjh. ");
INSERT INTO gup_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Ngudda yibenbukkang nawu wurdwurd dja nawu birribarrken bu bedda warridj ngundiburluburlume. Dja bininj nawu ngurriyidko wanjh yibenbularrbun rowk, dja yibenbun nawu yimankek kabirrimarnburren bu ngundinjirrke. ");
INSERT INTO gup_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Bu ngaye ngabolknan kaddum kore heaven manbu yimarnbom kunbidwi ke, dja nganan manbu dird dja mankokkarrng manbu yikurrmeng kumekbe, wanjh ngaye ngadjawarren, ");
INSERT INTO gup_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Adju! Njalekenh ngudda kanmarnemarrkwarre ngad nawu binihbininj? Kab njalekenh mak kannahnan ngadberre nawu djal bininj duninjh? ");
INSERT INTO gup_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Mak ngudda kankurrmeng ngad bininj darnkih kore ngudda nawu God duninjh ba bu ngad ngarridarnhdi kore ngudda. Mak ngudda kanmarnbom ba bu ngarrimak dja ngarringeykimuk. ");
INSERT INTO gup_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ngudda kankurrmeng ba bu ngarriwohrnawohrnan kore njalehnjale rowk nawu ngudda yimarnbom kunbidwi ke. Wanjh ngad kunu ngarriyurrhke rowk kore yehyeng rowk yimarnbom, yiman ");
INSERT INTO gup_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","nawu sheep, dja mak bulikki, dja nawu mayh kurralkwaken, ");
INSERT INTO gup_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","mak nawu kungolwaken mayhmayh, dja djenj nawu kurrulawaken, mak njalehnjale nawu kayo kore kurrula kanjdji kukku. ");
INSERT INTO gup_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Yoh, ngudda Yawey nawu Yiwohrnan rowk ngadberre, manbu kunngey ke makka manwernhmakkaykenh duninjh dja ngundingeyburlume kore kubolkbubuyika rowk kondah kurorre! ");
INSERT INTO gup_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Ngaye djalburlume ngudda nawu Yawey kunkange ngardduk dorrengh, dja mak ngabenbengdayhke bedberre birriwern ba bu bedda kabirrikangebarrhme dja ngundiburluburlume kore yirrurrkmirrikenh kundulkarre dorrengh ke. ");
INSERT INTO gup_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","God, nawu Yiwernhngudjkimuk duninjh, ngaye djalmanjbun, mak ngawayini nguddakenh kunnjilngmak dorrengh bu burluburlume. ");
INSERT INTO gup_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Dja bu ngundimirrkmang nawu ngaye ngarriyidko bininj, wanjh kabirrikelerlobme dja kabirrimankan kaluk kabirriyakmen rowk kore kumirrk ke. ");
INSERT INTO gup_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Ngudda yiyerrkan kore yibenhdjadmekenh, dja yibendjadme bininj kore djal mandjad dja kunwoybuk. Ngaye warridj ngudda kandjadmeng, dja ngudda wanjh kanmakwam dja kanmulewam bu ngaye ngamak. ");
INSERT INTO gup_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ngudda yibenwokdjalwong nawu kubolkbubuyikabeh dja yibenbom nawu birriwarre bininj. Ngudda yibenngeybularrbom dja nakka kabirridjalngeyyak munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Birrimekbe nawu ngarriyidko wanjh birriyakayakminj rowk. Mak kore kuredbubuyika bedberre birrihni ngudda yibenmarnerurrkbakbakkeng. Bolkkime minj nangale kabenyawoyhburrbun. ");
INSERT INTO gup_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","8","Ngudda Yawey wanjh yidjalwohrnan munguyh munguyh dja yihni kore throne kore yiyingkihkukmarnburrinj bu yibendjadmekenh birriwarlahkenh bininj rowk kore kondah kurorre. Ngudda yibendjaldjadme djal mandjad duninjh. Mak ngudda yibenhnahnan birriwern rowk bininj kore ngudda ke kunmakkenh. ");
INSERT INTO gup_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Ngudda Yawey yidjalkudji nawu yibenbidyikarrme bu kunyid kawernmerren bedberre. Wanjh nawu birrimarladj bininj nakka kabirrimrlobme kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Binihbininj nawu ngundingeykukenhme nakka wanjh ngundiwoybukwon, dja ngudda yidjalwoybuk dja minj mak yibenbodmewon. Kaluk kunmekbekenh bedda ngundimarrkkebbun. ");
INSERT INTO gup_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Ngudda Yawey yidjalwohrnawohrnan kore Zion wanjh ngad ngundimarnewayini dja ngundiburluburlume. Mak ngundimulewan bu ngarrbenbengdayhke bininj nawu kubolkbubuyika kabirrihni ba bu kabirriborlhme kore ngudda yikurduyimeng. ");
INSERT INTO gup_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Ngarriburrbun bu ngudda Yawey minj munguyh yibengmidjdan kunwarre bedberre bininj nawu birrinarmandeyi dja yibendjalbun. Dja mak ngudda munguyh yibenkayhmibekkan bininj nawu kabirribongdi. ");
INSERT INTO gup_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Nawu Yawey kankongibu! Yibenna nawu ngarriyidko bininj bu ngandinjirrhmiwon. Ngaye wanjh darnkih bu ngarrowen. Ngadjare kanbebkemen! ");
INSERT INTO gup_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Kanngehkemen ba bu ngawayini ke kore kurrangmaye ngarre kunred Zion. Kunmekbe kore ngadjalnjilngmak kore ngudda kanbidyikarrmeng. ");
INSERT INTO gup_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Birribuyika bininj kore kubolkbubuyika yiman birrikukwarrawarrhmeng kore benmanbidju birribolkkaruy, mak birriwarreworrinj kore bedman kunwarre birrikurduyimeng. ");
INSERT INTO gup_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Ngudda nawu Yawey yihdjalkurduyime djal kunmak bu yibendjadme bininj mandjaldjad duninjh, dja bininj rowk ngundikurdunan. Dja nawu birriwarre bininj nakka wanjh bedmandeleng kabirriwarreworren kore kunwarre kabirridjalkurduyime. ");
INSERT INTO gup_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Wanjh nawu birriwarre bininj nakka kabirrire kore kunred ngarre kundowikenh dja kabirridjarrkni birribuyika bininj nawu kubolkbubuyikabeh nawu ngudda ngundiwirrihmeng. ");
INSERT INTO gup_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Ngudda Yawey minj yibenbengmidjdan bininj nawu birrimarladj dja mak bininj nawu kunyid dja kunrayek kabenmarnewernmerren. ");
INSERT INTO gup_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Ngudda Yawey, wardi yidjalkurduyimen kore yidjare! Yuwn yibenbawon nawu kubolkbubuyikabeh bininj bu bedda kabirriwinhme. Wanjh yibenmirndekurrme kore ngudda ke court bu yibendjadmekenh. ");
INSERT INTO gup_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Mak yibenmarnbu birrimekbe bininj bu kabirrikukdeldelme kunkele duninjh dorrengh ba bu kabirrinarren bu bedda djal bininj birringudjwarre. ");
INSERT INTO gup_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Ngudda Yawey, njalekenh yihdi djarreh? Kunrayek nganmarnewernmerrinj ngardduk dja njalekenh ngudda bolkkime yihwarlkkarren? ");
INSERT INTO gup_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Birriwarre bininj kabirriburlumerren dja mak nawu birribang bininj nakka kabindingudjkadjung nawu birrimarladj bininj, dja kabindidarrkidmang kore mankarre manwarre manbu bedda kabirrikarremarnbom. ");
INSERT INTO gup_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Nawu birriwarre nakka kundjarewern, dja kabirriburlumerren kore kunwarre bedberre. Bedda kabindimakwan nawu birridedjwarlah bininj, dja mak ngundiwidnan ngudda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Bedda kabirriwernhburlumerren kaluk kunmekbekenh bedda minj kabirrikangeborledkerren kore ngudda, mak minj ngundimarnedjare ngudda God. ");
INSERT INTO gup_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Birrimekbe nawu birriwarre bininj wanjh kabirrikukenworren dja kabirriburlumerren. Minj kabirriwernhburrbun manbu mankarre ngudda ke, mak munguyh kabindidjalnjirrke nawu kabirriyidko bedberre. ");
INSERT INTO gup_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Kore kukange bedberre bedda kabirrihyimerren, “Ngad minj njale kanbun kadberre! Ngad nakka karrihdjalnjilngmak munguyh munguyh, dja minj mak kunrayek kambebme kadberre.” ");
INSERT INTO gup_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Bedda wanjh kunwok kunwarre kabirriyime dja warridj kabirridjalkurren dja kabindidung birribuyika bininj. Birrimekbe birridjalwarre bininj wanjh kabirriyolyolme kore kabirrikarremarnbun bu kunwarre kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Bedda wanjh kabirriwarlkwarlkkarren kuberrkkah kore kurrambalk, kabirrihmadbun nawu djakwarre bininj kumekbe kamyimowon wanjh kabirridarrkidmang dja kabirribun. ");
INSERT INTO gup_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Nawu nawarre bininj yiman lion nawu kahmarrwedowen. Nakka kahwarlkkayindi kore kurralk dja kabimadbun bininj nawu namarladj kamre, dja karrolkkarren kabidarrkidmang kore walabbi dja kabibalkukdorrorrke. ");
INSERT INTO gup_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Nawu nawarre bininj yiman nabang dja ngudjbang duninjh, wanjh kabenbun birrimak bininj. ");
INSERT INTO gup_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Wanjh nawu nabang bininj kanjdji kayimerren, “Nawu God minj kaburrbun! Nakka kahmimbalhmiyindi dja minj ngannan kore ngaye ngakurduyime.” ");
INSERT INTO gup_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Mah, Yawey, yirrolkka ngudda nawu God, wardi yibidwayhmen dja yiberlyirriyun ba yibenbidyikarrmen bininj nawu ngundimarnedjare dja bedda kabirridjalngudjwarre. ");
INSERT INTO gup_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Nawu birriwarre bininj ngundinjirrhmiwon dja njalekenh bedda kabirriyimerren kanjdji kore kukange bedberre, “Nungka God minj ngandjadme!” ");
INSERT INTO gup_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Dja ngudda God yihbennan kore kunwarre kabindiwarrewon bedberre nawu birrimarladj bininj. Ngudda yiburrbun kore kunyid kawernmerren dja yidjare yibenbidyikarrme. Bedda nawu birrimarladj wanjh kabirrikurrmerren kore ngudda yibenbidyikarrme, dja ngudda yiman kornkumo duninjh bedberre nawu kornkumo yak. ");
INSERT INTO gup_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Mah! Wanjh yibenberlbakbakkemen nawu birriwarre bininj. Yibenbu ba yibenngurdke nawu manmolk kabirrihkurduyime kunwarre. ");
INSERT INTO gup_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Ngudda Yawey wanjh king duninjh munguyh munguyh, dja nawu birriwarlahkenh bininj nawu birriwarre kore kubolkwarlahkenh, nakka kaluk kabirridarrkidyakmen kondah kore kurorre. ");
INSERT INTO gup_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Ngudda yibenbekkabekkan nawu birrimarladj bininj kore bedda kabirridjare yibenbidyikarrme. Ngudda munguyh yibenkangemarnbun mak yibenbekkabekkan bu kabirrikayhme dja ngundidjawadjawan. ");
INSERT INTO gup_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Mak ngudda yibennahnan nawu birrimarladj bininj, dja mak bininj nawu kabirribongdi kore nawu birribang duninjh bindikurrmeng. Ngudda yibennahnan ba kunukka minj nangale nawu kahni kondah kurorre kabenyawoyhkelehme birribuyika. ");
INSERT INTO gup_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Ngakelerlobme kore Yawey nawu munguyh ngankukdjurruddan ba bu ngangehme bu kamak rowk. Dja njalekenh bu kunukka kandimarneyime, “Waw! Yikelerlobmen yirrolka yiman mayhmayh karrolkan, dja yiwarlkarren kore kuwarddekimuk! ");
INSERT INTO gup_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Ngurrina! Nawu birriwarre bininj ngokko birriyingkihmarnbom nawu bunarra bedberre, dja kabirriwarlkkayindi kore munhmunun dja kabindidulubun nawu birrimak bininj. ");
INSERT INTO gup_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Nawu nawoybuk bininj, nakka baleh kakurduyime bu kunwarre kawernhmerren?” Kuhni yikahwi bininj kabirriyime. ");
INSERT INTO gup_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Nawu Yawey kayerrkan kore throne nuye, kaddum kore temple manbu manrurrkdjamun nuye. Nungka wanjh kabenkurdunan binihbininj kanjdji kondah kore kurorre, ba bu kaburrbun rowk kore bedda kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Nawu Yawey kabenrohrokme bininj rowk, nawu birrimak dja nawu birriwarre. Nungka kabenwirrihme kukange nuye dorrengh bininj nawu kabirridjalmanjngun bu kunwarre kabirrihkurduyime. ");
INSERT INTO gup_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Nakka wanjh kabenmarneburriwe kunyirrke dja manbirlukimuk bu kabenkinje birrimekbe nawu birriwarre bininj, dja mak kabenmarnemunkewe kunmayorrkwarre bu kabenkukbukwon. ");
INSERT INTO gup_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Nungka Yawey nakka nadjalkudji nadjalmak duninjh. Nungka kadjaldjare bu bininj kabirridjadmerren bu djal mandjad duninjh. Dja birriwern bininj nawu kunmak kabirrikurduyime nakka kaluk kabirrikebnan. ");
INSERT INTO gup_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Ngudda Yawey kanbidyikarrmen! Birriwern bininj nawu ngundiwoybukwong nakka wanjh birridarrkidyakminj rowk! Nawu birrimak bininj ngudda ke, wanjh bonj, minj kabirrihni kondah kurorre. ");
INSERT INTO gup_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Bininj rowk kabirrikurrekurren bu kabirrikowerren, dja minj nangale mak nawoybuk dja kabirridjalkurren munguyh. ");
INSERT INTO gup_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Wanjh birrimekbe nawu kabirrihburlumerren yiddok minj yibendjendjobdjobke? ");
INSERT INTO gup_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Bedda wanjh kabirrihburluburlumerren dja kanjdji baybaywi kabirriyimerren, “Ngad wanjh ngarriyolyolme kore ngad ngarridjare, dja minj nangale kandabke. Dja wanjh karriwokdangen ba bu karrimang rowk manbu karridjare!” ");
INSERT INTO gup_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Wanjh Yawey kayime, “Mah. Ngaye ngarrolkkan dja ngabenbidyikarrme bininj nawu birringudjwarre dja mak nawu birrimarladj Ngabenbekkan bedda kabirrikayhme dja ngabenkukdjurruddan ba bu birriwarre bininj minj kabindimarneyime kunwarre.” Kuhni yimeng nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Dja nawu Yawey wanjh nawoybuk kore kawokkurrmerren, wanjh manbu kunwok nuye makka yiman kayime silver manbu bininj kabirriwolngwon seven times kore kunak. ");
INSERT INTO gup_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","O Yawey, kankukbalhmen ngadberre kore nawu birriwarre bininj ngandiwirrihme. Kannahna ba bu ngarringehme munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Nawu birriwarre bininj wanjh kabirrihdjalrengehre bu kabirriburluburlumerren, dja birridjalwern nakka kabirriburlumerren kore kundjalwarre duninjh kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Ngudda Yawey, baleh kabolkyime? Yiddok ngudda bu kanbengmidjdan ngaye? Bu yiddok munguyh munguyh? Mak yiddok kunkuyeng bu ngudda kanmarnekebwarlkkarren? ");
INSERT INTO gup_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Ngaye ngawarnyak kunmayali kunwarre ngakarrme. Yiddok ngaye ngahdjalnjilngwarre munguyh bu barnangarrakuyeng? Mak yiddok munguyh ngandihdjalbun nawu ngarriyidko? ");
INSERT INTO gup_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Yawey! Ngudda ngardduk God, kanwokma bu yiwarrudj ngahdi dja djawahdjawan. Kanmimbayhkemen, wardi ngadjalmimburdme bu ngarrowen. ");
INSERT INTO gup_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Wanjh kunu kabirriyime nawu ngaye ngarriyidko, “Bonj, wanjh ngad ngarriwinhmeng!” Bedda wanjh kabirrimarrmarr ngayekenh bu ngamankan. ");
INSERT INTO gup_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Bonj, ngaleng wanjh ngaye ngawernhburrbun bu ngudda kanhmarnedjare munguyh munguyh. Dja kore kukange ngardduk wanjh ngadjalmarrmarr duninjh kore ngudda kanngehkekenh. ");
INSERT INTO gup_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Yoh, ngaye ngadjalwayini munguyh nuye Yawey, dja nungka ngandjalmarnekurduyime kunmak rowk. ");
INSERT INTO gup_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Yikahwi bininj baybaywi kabirriyimerren, “God yak, dja God minj nakka kahdi!” Kuhni kabirriyime bininj nawu birribengwarr! Bedda wanjh kabirridjare kabirridjalkurduyime kunwarre. Minj kunmak kabirrikurduyime. Minj nangale bininj kakurduyime kunmak. Bonj, minj nakudji namak. ");
INSERT INTO gup_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Nawu Yawey kahni kaddum wanjh kamhbolknan kanjdji ba kabennan bininj rowk. Nungka kadjare kabenngalke bininj nawu mayaliwern dja nawu kabirriyawan nawu God. ");
INSERT INTO gup_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Dja larrk. Minj nangale bininj namak kahdi. Bedda wanjh birridjalwarrewarreminj rowk, dja birridjalbawong God. Minj nangale kakurduyime kunmak. Bonj, minj nadjalkudji namak kahdi. ");
INSERT INTO gup_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Adju! Bedda nawu birriwarre bininj, baleh kabolkyime bu bedda kabirriborlhme? Minj bedda kabirringeykayhme nawu Yawey, dja kabindidjalbun Yawey nuye bininj dja kabindiyakwon. ");
INSERT INTO gup_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Kumekbe kabirrihni Yawey nuye bininj, dja kabirriwernhkelemen. Dja God nungka kabirridjarrkdi. birrimak bininj, dja mak kabenbidyikarrme. ");
INSERT INTO gup_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ngudda nawu ngurriwarre bininj, ngurrikarrewarrewon bedberre bininj nawu birrimarladj, dja med, kabirrikelerlobme kore Yawey nawu kabennahnan. ");
INSERT INTO gup_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Wanjh ngaye ngadjare nangale nawu kamdolkkan kore Zion ba kamre kabenbebke bininj nawu Israel benkebmawahmeng kore kabirribongdi! Bu Yawey, kabenmarnekurduyime kunmak bedberre nawu bininj nuye, wanjh nawu Jacob nuye namud birrinjilngmarrmarrnin, dja nawu Israel benkebmawahmeng, nakka wanjh birriwernhnjilngmakmen. ");
INSERT INTO gup_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","O Yawey kanbekka bu djawan! Nangale bininj namak bu kahyo kore ngudda kubolkdjamun ke? Nangale yidjare bu kahyo kore mandulum manbolkdjamun ke? ");
INSERT INTO gup_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Nakka bininj nawu minj kunwarre kakurduyime, dja warridj kadjalkurduyime kore kunmakkenh. Namekbe bininj wanjh kadjalwokdi kukangebeh nuye kore kunwoybuk, dja minj kakurren. ");
INSERT INTO gup_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Mak minj kabiyolyolme kunwarrekenh nawu beneredbo bininj, dja minj mak kabiwarrewon. Minj kabimulewan nabuyika bininj bu kabiwowarrewon. ");
INSERT INTO gup_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Namekbe bininj wanjh kabiwirrihme bininj nawu nawarre dja nawu nabang. Dja kabenburlume bininj nawu kabirriwoybukwon nawu Yawey. Namekbe bininj, bu kawokkurrmerren, wanjh minj kamayaliborledme bu kunwarddekenh, dja bonj, kadjalkurduyime kore kunwok nuye. ");
INSERT INTO gup_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Nungka mak kabenbidyikarrme nawu kabirridjawan kunwarddekenh, dja minj karredjwarlahmen. Kadjalmadbun yeledj kaluk bu kabirrikukdurndiwe. Nahni bininj namak, minj kayawan kunwardde ba bu kabimarnekurren bininj kore court. Bininj nawu kakurduyime kuhni rowk, wanjh nungka kadjaldi dja minj kamankan munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Ngudda nawu God, ngaye ngamwam kore ngudda ba bu kannahnan, dja ngadjare kanngehke! ");
INSERT INTO gup_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ngaye ngamarneyimeng nawu Yawey, “Ngudda wanjh kanmarnewohrnan ngardduk. Minj njale namakmak ngahkarrme, djal ngudda yidjalkudji.” ");
INSERT INTO gup_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Ngabenburrbun Yawey nuye bininj nawu kondah kubolkkimuk kabirrihni. Bedda birrimak duninjh dja ngandinjilngmarnbun. ");
INSERT INTO gup_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Dja birribuyika bininj nawu kabirrimarneboddan nabubuyika gods, yiman idols, nakka wanjh kunyid kawernmerren bedberre. Dja ngaye minj ngarriraworren bininj bu kabirrimarnekinje mayh bedberre idols. Dja minj mak ngabenngeybun kunngey bedberre birribuyika gods bu ngarri yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yawey, ngudda yidjalkudji kanmarneyingkihkurrmeng kunmak ngardduk dja kannjilngmarnbun munguyh. Ngudda wanjh kanmarnebolknahnan munguyh. ");
INSERT INTO gup_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Ngudda kanwon namakmak, dja kanmarnekurduyime bu djal kunmakkenh, dja ngaye wanjh madbun ke kunnjilngmak dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Ngaye ngaburlume Yawey nawu nganbengdayhke munguyh. Mak bu kukakwern, ngaye ngadjalbekkan bu nungka nganbukkabukkan kanjdji kore kukange ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ngaye wanjh munguyh ngadjalburrbun nawu Yawey yiman bu ngakebnan kore kumirrk ngardduk. Nungka kahdarnhdi kore kubolkkukun ngardduk, wanjh kunu minj njale mak ngankukrokayhwe. ");
INSERT INTO gup_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Wanjh kunmekbekenh kunu ngawernhnjilngmak dja ngayolyolmerren bu ngadjalmarrmarr kore nungka. Mak ngadjalngehme kore nungka kannahnan. ");
INSERT INTO gup_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Dja ngudda Yawey minj kanbawon bu ngakukdudjindi kore kumidj. Mak minj yibawon bininj nawu namak ke bu kakuknudmen. ");
INSERT INTO gup_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ngudda wanjh kanbolhbukkang manbolhmak ba bu ngadjaldarrkkiddi. Kaluk kankangenjilngmarnbun bu ngudda munguyh ngarrhdjarrkdi, dja kankurrme kore kubidkukun ke ba ngadjalwernhnjilngmak bu munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Yawey, ngaye minj kunwarre ngayimeninj! Ngadjare ngudda kankayhmibekkan ngahdi yiwarrudj. Kanbekkabekka dja ngaye minj ngakurren bu ngayolyolmerren. ");
INSERT INTO gup_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ngudda yidjalkudji kandjadme bu djal mandjad. Ngudda munguyh yinan kore kunmak dja kunwarre kakurduyimerran, wanjh ngadjare ngudda kannan bolkkime. ");
INSERT INTO gup_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ngadjare bu kankangeburrbun dja kukak dorrengh kankangerohrokme, dja minj kunwarre yingalke, dja minj ngayimeninj. Ngadjalkarremarnburrinj ba bu minj ngawokdi kore kunwarrekenh. ");
INSERT INTO gup_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Ngaye minj ngakurduyime kore birribuyika bininj kabirrikurduyime. Dja ngadjalwokmarrkmang manbu kunwok ke ba bu minj ngabenngunjdjikkan nawu birribang bininj. ");
INSERT INTO gup_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ngadjalkadjungi manbolh ke. Mak minj ngawohmankayi. Ngadjalrengehrey bu ngudda djalmunkekadjungi. ");
INSERT INTO gup_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Ngaye ngaburrbun bu ngudda kanbidyikarrme, wanjh kunmekbekenh bu ngarri yiwarrudj dja djawadjawan. Wanjh kanbekka dja kanwokma! ");
INSERT INTO gup_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Ngudda yihdulkarrekimuk, dja kanngehke ngad bininj kore kunbid kukun ke, dja ngad ngarrimrlobmeng kore ngudda ba yibendabke nawu birriyidko ngadberre. Kanmarnebukkarren ba ngarriburrbun ngudda kandjalmarnedjare, dja ngarridjalkangebarrhme. ");
INSERT INTO gup_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Kanwernhnahna munguyh, dja kankukbalhmen mak kanwarlkka kore kanjdji kubid ke yiman mayhmayh yaw kawarlkkayindi kanjdji kore kuwel ngarre ngalbadjan. ");
INSERT INTO gup_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Yuwn yibenbawon nawu birriwarre bininj bu bedda ngandiwabminguneng ba bu ngandidjokohme dja ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Bedda minj kabindikongibun birribuyika dja nakka kabirridjalburlumerren munguyh. ");
INSERT INTO gup_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Ngokko wanjh ngandihkelekadjungi kurih kuhrih dja ngandidabdabkeng. Bolkkime wanjh ngandiwernhkuknan ba ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Dja bedda yiman lions nawu kabirrimarrwedowen kabirriyawan manme, mak bedda yiman lion nakimuk bu kahwarlkkayindi kore kungarre ba bu ngankukdjalkmang. ");
INSERT INTO gup_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yawey! Wardi baleh kab yikurduyime. Yirrolka dja yibenbu birrimekbe nawu birriwarre bininj bu mandjawak dorrengh ke. Dja kanngehkemen, dja wardi bedda ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Wanjh yiberlyirriyun kubid ke dja kanngehkemen kore nawu birriwarre bininj ngandibongkarrme. Bedda kabirridjaldjare manbu kondah kurorrebeh, kaluk kabirradjaldarrkidbolkyakmen. Dja ngad bininj nawu ngudda kanmarnedjare, wanjh kandjalwon manme, dja mak yibenworrkmiwon wurdwurd ngadberre, dja mak nawu mawahmawah ngadberre, nakka kaluk manwern kabirrikarrme. ");
INSERT INTO gup_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Dja ngaye minj kunwarre ngayimeninj bu ngawarrewoyi. Kaluk ngaye wanjh kebnan ngudda! Bu ngarrolkkan kore ngakeyo dja ngamimbayhmen, wanjh ngaye kebnan dja ngadjalwernhnjilngmakmen. ");
INSERT INTO gup_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Yawey, ngaye marnedjare ngudda nawu kanmurrngrayekwon. ");
INSERT INTO gup_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yawey wanjh nakka ngardduk kunwardde manbu manrayek, mak ngannahnan dja ngangehke. Nungka ngardduk God nawu ngankukbalhme, dja ngakelerlobme kore nungka ba ngannahnan. Nungka munguyh ngankukdjurruddi dja mak nganngehke. Ngaye wanjh ngawarlkkarren kore nungka ngankurrme. ");
INSERT INTO gup_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Ngaye munguyh ngakayhme nawu Yawey, dja ngad bininj rowk wanjh karriburluburlumen! Nungka wanjh nganbebke kore birribang bininj nawu ngarriyidko. ");
INSERT INTO gup_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Nungka nganngehkeng kore manbu yiman kundowikenh ngarre kunyarl, makka ngandukkarrukkayi, warridj kukku manbu bodjurrbuhmi ngankuyinngakkeng. ");
INSERT INTO gup_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Mak ngankukdukkadukkang kunyarl manbu kumidj ngarre, mak kundowikenh nganbongkarrmeninj ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Ngahkarrmi kunkimuk kunrayek, wanjh ngaye ngakayhmikayhmi nawu Yawey. Ngadjalkayhmi nungka nawu God ngardduk ba nganbidyikarrmeng. Nungka wanjh ngankayhmibekkang kore nuye templebeh dingihdi, wanjh kanwokmangi kore kunkanem nuye. ");
INSERT INTO gup_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Wanjh nungka yiddungi, dja kondah kurorre makka bolkwodjorrhmiyindanj, dja manbu kunwarddekimuk makka wanjh deldelmeng nawu kanjdjiwi kurredjmad! ");
INSERT INTO gup_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Wardi kundolng dolngbebmi kore kukeb nuye dja yiman wehmiwehmi manbirluworldjenbabang kore kurrangbeh yiman kunyirrke manbang duninjh. ");
INSERT INTO gup_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Wanjh nungka dangmarrhmey manbu kunngol yiman kayime manburrba dja kumkoluy kunmayorrkkimuk dorrengh kore kumhdengebarndi. ");
INSERT INTO gup_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Nungka kumwam yiman kayime morneni kore kubodmebodme bedberre mayh nawu birriwelyi dja wanjh dolkarrinj kaddum. Yiman kayime nungka rengehrey kore kunmayorrk dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Mak manbu kunkak makka yiman kukbarrkburrinj, dja kunngol manbu kore namarrkon kangurdulme, makka ngolbalhmeng bu nungka yiman djongburrinj. ");
INSERT INTO gup_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Kore nungka dingihdi wanjh bolkwaydi wernkih duninjh, dja wanjh munkeweng manyirrkerrk, dja namarrkon mayhkemayhkeyi kunkimuk yiman kunak duninjh, dja wanjh kunngolburlerri djalkmiwam. ");
INSERT INTO gup_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Wanjh wokdanginj nawu Yawey! Wokdi yiman kayime ngurdulmi kunkimuk kore kaddumbeh! Kunwok nuye nawu Nawernhkimuk Duninj wanjh wokwarlahminj. ");
INSERT INTO gup_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Nungka benkelekadjungi bunarra dorrengh bu benyarlarrkeng nawu birriyidko nuye. Nungka benbuni manbu namarrkon kunkimuk dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Nungka yiddungi dja kebbuhmi, wanjh darrarrhmi kore kurrula, wanjh manbu mankabokimuk makka boyakmerreni wanjh bu bolkbukmeni nakka bolkdjorlokni kanjdji duninjh. ");
INSERT INTO gup_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Wanjh kunmekbe nungka nganberlmey kore kaddumbeh, dja nganwayhkeng kore kurrulaburldjarn ngahdjuhmiyindi. ");
INSERT INTO gup_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Mak nganbebkeng kore birringudjbang bininj nawu ngarriyidko bu bedda birridjareni ngandibuyi. Bedda wanjh birringudjbang dja ngaye larrk. ");
INSERT INTO gup_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Bedda ngandimarnebebmeng bu kundjak kundulmuk wernmerrinj ngardduk. Bu kunmekbe kunbarnangarra ngandibuyi, dja Yawey nganyikarrmeng dja wanjh kamak. ");
INSERT INTO gup_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Kaluk nungka nganbebkeng dja ngankurrmeng kore kubolkmak. Nungka wanjh nganngehkeng dja nungka njilngmakminj ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Ngudda Yawey yikurduyimeng kundjalmak ngardduk bu ngaye mandjad ngahrey, dja kanwong kore nganmarnekurrmeng kahdjedjenyo ngardduk bu ngaye minj kunwarre ngayimeninj. ");
INSERT INTO gup_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Ngaye ngadjalkurduyimeng kore ngudda ke mankarre, dja minj bodmewoyi dja bawoyi ngudda nawu God ngardduk bu kunwarre ngakurduyimeninj. ");
INSERT INTO gup_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Kore kunmayali ngardduk nakka ngadjalkarrme mankarre ke. Minj mak ngabengmidjdan kore ngudda ke kunwok manbu kanwokwong. ");
INSERT INTO gup_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ngaye djalwernhwokmarrkmang mak nganahnarren ba bu minj kunwarre ngakurduyime. ");
INSERT INTO gup_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Ngudda Yawey yikurduyimeng kundjalmak ngardduk bu ngaye mandjad ngahrey, dja kanwong kore nganmarnekurrmeng kahdjedjenyo ngardduk bu ngaye minj kunwarre ngayimeninj. ");
INSERT INTO gup_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Yawey ngudda yibenmarnekurduyime kunmak bedberre bininj nawu ngundidjalwoybukwon kore yibenmarnewokkurrmerrinj bedberre, dja mak ngudda yibenmarnekurduyime kunmak bedberre nawu birrimak bininj. ");
INSERT INTO gup_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Bininj nawu kabirriwarnyak kunwarre kore kukange bedberre dja minj kabirrimayaliborledme, wanjh ngudda yibendjalmarnedjare bedberre dja minj yibenbawon. Dja bininj nawu kabirridjare ngundidjalwokwarrewon ke, nakka wanjh yibenhdjalbengwarrewon bedberre. ");
INSERT INTO gup_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Ngudda yibenngehke bininj nawu birrimarladj. Bininj nawu kabirriburlumerren, wanjh ngudda yibenmarnbun bu kabirriyemengalme. ");
INSERT INTO gup_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Dja ngudda Yawey wanjh kanhdjalkangewolkan munguyh dja ngudda munguyh yimarnbun manbu kunkak kore ngani bu nganmarnebolkwolkayindan. ");
INSERT INTO gup_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Ngudda mak kanbidyikarrme ba ngabenbun birriwern bininj nawu birribang. Ngudda God ngardduk dja kanwayhke ba ngabidbun kore kawarnamhyo kunkimukkenh. ");
INSERT INTO gup_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Ngayolyolme God nawu mankarre kamarnbun wanjh mankarremakkaykenh duninjh, dja mak nuye kunwok wanjh kunwok kundjalmak duninjh. Yoh. Nawu Yawey kabenkukbalhme nawu kabirrikelerlobme kore nungka ba bu kabenbidyikarrme. ");
INSERT INTO gup_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Ngudda Yawey, yidjalkudji God! Ngudda God ngadberre, yidjalkudji nawu kunwardderayek duninjh ngadberre kore ngarriwarlkkayindi. ");
INSERT INTO gup_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Nungka God nadjalkudji nganwon kunngudj, dja mak nungka nganmikan kore manbolh mandjad. ");
INSERT INTO gup_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Warridj nganmarnbun bu wernkih ngarlobme yiman mayh nawu deer. Dja nungka nawu nganbidyikarrme bu ngarrengebarndangen kaddum kore kuwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Mak nganbidbukkabukkan bu ngarriburrenkenh bininj kore war, warridj kunberl ngardduk nganwong kunngudj ba bu ngarrowkke nawu manbang bunarra. ");
INSERT INTO gup_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ngudda yidjalkudji nawu kankukdjurruddi ba bu ngaye ngawinhme. Ngudda yiman yiboddan ba bu kanbidmang ngardduk kunbidkun dja kanngeykimukwon. ");
INSERT INTO gup_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Mak manbolh kore ngahre nakka yibolkbirrhmeng ngardduk ba bu ngaye ngahdjalre kamak rowk dja minj mak ngabungkarrkbun. ");
INSERT INTO gup_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Nawu ngarriyidko bininj, nakka munguyh ngabenngudjkadjuy dja ngabenyurrhkeng bedberre wanjh ngabenbom. Minj ngangurdmeninj dja ngabendjalyakwong. ");
INSERT INTO gup_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Ngaye ngabenbuni, yiman kayime ngabenkukdjubulhmeng, wanjh birrikukwarrawarrhmi kore kurrenge ngardduk dja minj birriyawoyhdokkayi. ");
INSERT INTO gup_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Yawey, ngudda nawu kanngudjmarnbom kore ngarriburrenkenh ba bu ngawinhmeng. Warridj yibendjurrkkang nawu ngarriyidko bininj bu ngandimarneboddanj kore kurrenge ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Nawu ngaye ngandiwidnan bininj ngudda yibenmarnbom bu birrikelerlobmerrinj ba bu ngaye ngawinhmeng dja ngabenyakwong. ");
INSERT INTO gup_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Bedda birrikelekayhmi bu nangale kabenkayhmibekkan, dja djalburrkyak, minj nangale benbekkayi. Bedda ngundikayhmi ke, dja minj yibenwokmayi. ");
INSERT INTO gup_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Ngabendjubudjubulhmi yiman kundjulng ngabenmarnbuni dja kunmayorrk benbubuhmi. Ngaye ngabenyakarrbuni yiman kunkih kore manbolh. ");
INSERT INTO gup_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Yawey ngudda kanbebkeng kore bininj ngardduk nawu ngandidungi, mak ngudda kanmarnbom bu ngabenmarnedokme birribuyika bininj bedberre nawu birridjenbubuyika dja bolkkime bedda ngandihmarnedurrkmirri ngaye. ");
INSERT INTO gup_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Bedda ngandibekkabekkan dja werrkwerrk ngandiwokmarrkmang. Bininj nawu kubolkbubuyikabeh wanjh ngandikengehme. ");
INSERT INTO gup_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Bedda kabirridjalkele dja kabirridjalkangewarremen. Kabirrimbebmerren kunkele dorrengh kore kabirrihyongoyo. ");
INSERT INTO gup_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yawey, ngaye djalmanjbun dja burluburlume! Ngudda nawu yidjalmimbi munguyh. Ngudda nawu yiman manwarddekimuk kore ngawarlkkarren. Wanjh ngarriwern bininj rowk ngundingeyburluburlumen. ");
INSERT INTO gup_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Mak kankidmey bu yibenbom, dja yibenkurrmeng nawu kubolkbubuyikabeh kore kubid ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Warridj kore bininj nawu ngarriyidko wanjh ngudda kankukbalhmi dja kanmarnbom bu ngawernhdokme bedberre birridjalwern nawu ngandiwirrihmeng. Ngudda kanbebkeng kore nawu birribang bininj ngandibuyi. ");
INSERT INTO gup_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Yawey, ngaye djalburluburlume munguyh bu ngarriraworren bininj kore kubolkbubuyika rowk Ngaye wanjh ngeyburluburlume ngudda ke kunngey. ");
INSERT INTO gup_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Ngudda yidjarrngbom bininj ke, dja yimarnbom king. Wanjh yiwong kundulkarre dja kunu nungka winhmeng munguyh. Ngudda wanjh yibendjalmarnedjare David nawu yikodjdjuhkeng, dja mak nawu mawahmawah nuye munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Bu karribolknan, dja karribekkan manbu kaddum duninjh, wanjh yiman kahyolyolme manbu God nuye kunmakmak, dja manbu kunngol makka kabimulewan God nawu marnbom rowk kunbidwi nuye. ");
INSERT INTO gup_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Mak bu kunbarnangarrabubuyika dja djalmunguyh manbu kunngol kabihmulewan dja kabihyolyolme nawu God. Mak kabalyime manbu kunkakwern bu kanmarneyime God nuye kunmayali kunwern. ");
INSERT INTO gup_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Minj kunwokkudji kawokdi, dja birriwarlahkenh bininj rowk nawu kabirriwokdi kunwokbubuyika, wanjh bedda kabirribekkabekkan kore kunngol kahmulewan. ");
INSERT INTO gup_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Dja maninjmanu kunwok kare kubolkwarlahkenh rowk, dja maninjmanu kunwok kahdjalre djarreh duninjh kore kubolkbubuyika rowk. God marnbom kaddum duninjh, yiman dabburlin djabnameng ngarre kundung bu kahdi. ");
INSERT INTO gup_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Wanjh nawu kundung kawayhme yiman bininj kambebmen bu kabimang ngalbininjkobeng bu mulil ngarre kabenemarrenkenh. Dja mak nawu kundung yiman kayime nawu ngudjbang bininj bu karlobme kunnjilngmak dorrengh, dja kabenyurrhke birribuyika rowk. ");
INSERT INTO gup_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Dja mahni kundung wanjh kambebme, kare, kayibme, kamyawoyhdurndeng kore kaddum kunngol. Minj nangale kawarlkkarren nuye nawu kundungbang. ");
INSERT INTO gup_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Kaluk mankarre nuye nawu Yawey, makka mandjalmakkaykenh duninjh, dja wanjh kanmalngkerrngehme kadberre. Manbu kore Yawey kanbukkabukkan kadberre manbu kunwok, wanjh minj kankowe. Warridj kunmayali kabenwon nawu birrikodjkuluwarre bininj. ");
INSERT INTO gup_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Mak kore nawu Yawey kayolyolme kadberre bu makka mandjad; makka warridj kanmarnbun bu karrikangenjilngmak. Mak kore kanmarnewokrayekwon, nakka wanjh yiman kayime kanmarnewernhbolkwolkan kadberre. ");
INSERT INTO gup_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Bu ngad karrikelemen nawu Yawey, wanjh kamak kore nungka; nakka djalmunguyh karrimarneboddan. Mak kore kawokmarnburren kadberre, makka djal mandjad duninjh, dja manmakkayhkenh. ");
INSERT INTO gup_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Nawu wirlmurrng gold nakka walakkih bu karridjare. Dja karriwernhdjarenin manbu kunwok nuye Yawey kore wokmarnburrinj kadberre. Dja kore Yawey nuye njalehnjale nawu karremarnbom, makka manwernhmanjmakkaykenh dja karrokme manbu mankung manmanjmak. ");
INSERT INTO gup_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Ngudda nawu Yiwohrnan rowk, ngudda bu kanbukkabukkan dja kanbengdayhke ba bu ngaye wokmarrkmang ke, wanjh ngaye nawu marnedurrkmirri ke, ngawohmang nawu kahdjedjenyo ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Minj ngad bininj ngarriwernhburrbun kore ngarrihkurduyime kunwarre. Dja ngaye djawan bu yibengmidjda ngardduk kunwarre ngakurduyime manbu kawarlkkayindi. ");
INSERT INTO gup_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Dja yuwn kanbawon ngaye nawu marnedurrkmirri ke bu ngaye ngamarnburren kunwarre ngakurduyime. Ngaye wanjh ngawarnyak bu kunwarre ngandjurrkkan. Ngadjare kunukka kamak ngani, minj njale ngawarrewon kore ngudda, dja minj kunwarre duninjh ngakurduyime. ");
INSERT INTO gup_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Nawu Yawey! Ngadjare kunwok ngardduk dja mak kunmayali ngardduk kore baybaywi ngabekkarren, bu kamakmen rowk kore ngudda. Mak ngadjare bu njilngmarnbun ngudda yidjalkudji nawu kannahnan dja kanngehke ngaye. ");
INSERT INTO gup_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Ngarri yiwarrudj dja ngadjawan Yawey ba ngunbekkan dja ngunngehke bu ngudda kunrayek yikarrme. Ngadjare God nawu ngeykimuk duninjh, nawu Jacob bimarneboddanj, wanjh ngundjalnahnan. ");
INSERT INTO gup_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Nakka kahdi kore kubolkdjamun duninjh nuye, wanjh ngadjawan bu ngunmarnemunkewe nawu ngunbidyikarrme. Nakka wanjh kahdi kore Zion, wanjh ngadjare mak ngunnahnan kunmekbebeh. ");
INSERT INTO gup_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ngadjawan bu kaburrbun nawu namakmak ke nawu yikurrmeng nuye, wanjh kanjilngmakmen bu njale ngudda yimarnekinjeng bu yiwong nuye. ");
INSERT INTO gup_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Mak ngadjawan Yawey bu kakurduyime nawu njale ngudda yidjare kore kukange ke. Mak ngadjawan bu ngunbidyikarrme ba bu kakurduyimerran rowk ngudda yikarremarnburren. ");
INSERT INTO gup_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Ngudda nawu king, wanjh ngudda kaluk yiwinhme, dja warridj karrimulilmang mak manmadjmak karriwayhke kore kunngey nuye nawu God kadberre. Wanjh ngarridjare nawu Yawey wanjh ngunmarnekurduyime rowk kore ngudda yidjawan. ");
INSERT INTO gup_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Bolkkime ngaye ngaburrbun bu Yawey kabingehke nahni bininj nawu bikodjdjuhkeng nuye. Mak kabiwernhbekkan kore kaddumbeh bu kahdi kubolkdjamun nuye. Nakka narrulkarrekimuk duninjh kore kubidkun nuye dja kabingehke. ");
INSERT INTO gup_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Yikahwi bininj kabirriyime bu kabirrinahnarren nawu djarrang dja chariots dorrengh, dja ngad wanjh karridjalwoybukwon kunngey nuye Yawey nawu God kadberre. ");
INSERT INTO gup_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Kaluk birrimekbe bininj wanjh nakka kabenbungwarrewon wanjh kumekbe kabirrimankan, dja ngad nakka karridengerayekmen bu mandjad karridi. ");
INSERT INTO gup_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yawey, yiwo kunngudj ke king nawu yidjarrngbom ba bu nungka kadjalwinhme. Kanwokma ngadberre bu ngarridi yiwarrudj ngundidjawan. ");
INSERT INTO gup_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Yawey, ngudda yiwernhdulkarrekimuk duninjh, dja nawu bininj ngudda yidjarrngbom dja yimarnbom king, wanjh kunmekbekenh king nawu ngudda yimarnbom wanjh kawernhmarrmarr duninjh. Nungka wanjh mulil kakarrme kore kunwernkah yimarnbun kawinhme kore kabirriburren birriyidko nuye. ");
INSERT INTO gup_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Ngudda yikurduyimeng kore nungka wernhdjareni kore kukange nuye dja ngudda minj yikaybuyi. ");
INSERT INTO gup_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Ngudda yikimey namekbe bininj nawu yidjarrngbom, dja yiwong kunmakmak kunwern. Mak yikodjdjongbom nawu manmak duninjh gold crown manbu kings kabirrikodjdjongbuyindi. ");
INSERT INTO gup_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Nungka ngundjawam bu kunkuyeng kadjalmimbi wanjh ngudda yiwong kundarrkid ba bu kadjaldarrkiddi munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Ngudda yiwong kunngudj ba bu nungka kunwernkah winhmeng. Wanjh kunmekbekenh nungka wernhkukenminj duninjh. Mak ngudda yingeykimukwong dja yimarnbom bu wernhkimukminj. ");
INSERT INTO gup_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Woybukkih ngudda yimarnekurduyimeng kunmak bu munguyh munguyh. Dja yinjilngmarnbom bu darnkih yihdi nuye ngudda nawu yiwernhmakkaykenh. ");
INSERT INTO gup_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Namekbe nawu king ngunwokmarrkmang dja ngundjalwoybukwon ngudda Yawey. Ngudda wanjh yidjalmarnedjare munguyh munguyh, dja kunmekbekenh nungka kahdjaldi dja minj nangale kakukrokayhwe. ");
INSERT INTO gup_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Yawey ngudda yibendarrkidmang nawu ngurriyidko bininj, kunbidkukun ke dorrengh. Ngudda yibendjalbongkurrme nawu ngundiwidnan rowk, kubidkukun ke dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Bu ngudda yibenmarnebebme wanjh yibenwurlhke yiman kunak kabirrikukrung kore kunkangeyid ke. Nakka kaluk manbirluwoldjen kabenkukyakwon. Ngudda yiman mayh yibenkukwukme. ");
INSERT INTO gup_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ngudda kaluk yibenbularrbun nawu namud rowk bedberre kondah kore kurorre, wanjh nawu mawahmawah bedberre kabirridarrkidkukyakayakmen. ");
INSERT INTO gup_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Kore kabirrihkarremarnbun yimankek ngundikanjkurrmeninj bu ngundibuyi dja makka kaluk kayimerran bu djalburrkyak, kabirridjalbarabun. ");
INSERT INTO gup_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Ngudda yibenmarnbun bu kabirrikelerlobmerren. Yimarnburren bu yiburriwe bunarra kore bedda. ");
INSERT INTO gup_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Mah, Yawey ngudda wanjh ngurriwernhngudjbang duninjh, wanjh ngad ngundiburluburlume. Dja mak ngarriwayini ke dja ngundiyiburlume bu yikarrme kundulkarre duninjh. ");
INSERT INTO gup_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Ngabba God! Ngabba God! Njalekenh ngaye kanbodmekenhwong dja kandjalbawong? Mak njalekenh bu ngudda djarreh yihdi bu minj kanbekkan kore ngahdjalngeyngeyyime dja ngakayhme ke ba bu yimre kanbebke? ");
INSERT INTO gup_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Ngabba God! Woybukkih ngaye ngadjalkayhmiyo kunbarnangarrakuyeng, dja ngudda minj kanwokmang, mak kumununkuyeng warridj ngakayhme. Minj ngaye ngangurdme. ");
INSERT INTO gup_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Ngaye ngaburrbun bu ngudda King dja Yidjaldjamun duninjh, mak ngudda yiwohrnan kore kaddum duninjh yiyerrkan kore bininj nawu Israel benkebmawahmeng ngundiburluburlume. ");
INSERT INTO gup_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Nawu mawahmawah ngadberre nakka ngundiwoybukwong. Bedda ngundimarrkmangi dja kunekbekenh ngudda yibenngehkeng. ");
INSERT INTO gup_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Bu ngudda ngundimarnekayhmi wanjh nakka yibenbidyikarrmi. Mak bu ngundimarrkkebbuni nakka minj yibendahmeninj. ");
INSERT INTO gup_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Ngaye wanjh ngadjalwarre, dja yiman ngayeng, minj bininj duninjh ngaye. Bininj rowk ngandiborrkbun dja mak birriwern ngandiwidnan, minj ngandimarnedjare. ");
INSERT INTO gup_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Mak birrimekbe nawu ngandikuknan nakka ngandidjekmiwon, bedda kabirridjenbebme ngardduk dja kabirrikodjburdeburdebme. ");
INSERT INTO gup_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Bedda ngandimarneyime, “Yikayhmen nawu Yawey, ba kunubewu ngunbidyikarrme! Ngudda yiyime nungka yimankek ngunmarnedjare, dja njalekenh minj ngunngehke?” Kuhni wanjh ngandimarneyime. ");
INSERT INTO gup_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Dja ngudda nawu Yiwohrnan Rowk yibidyikarrmeng ngalbadjan ngardduk bu nganyawmey kamak rowk. Mak kanmarnbom bu wokmarrkmey kore ngabarrkenni rerrih. ");
INSERT INTO gup_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Bu kunmekbe kunbarnangarra ngarranginj, ngudda wanjh kannahnani; mak ngudda yidjaldi God ngardduk munguyh, bu ngalbadjan ngardduk nganyawmey dja mak bolkkime. ");
INSERT INTO gup_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Wanjh yuwn bu djarreh yihdi dja yuwn bu mak kanbawon. Manbu kunyid makka darnkih nganmarnebebme, dja minj nangale nabuyika nganbidyikarrme. ");
INSERT INTO gup_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Nawu ngandiwirrihme bininj wanjh ngandidjokohmeng yiman kayime nawu birribang bulikki. Bedda yiman birridulkarrekimuk bulikki nawu birrikang Bashan, dja bedda wanjh ngandidahme munguyh. ");
INSERT INTO gup_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Birrimekbe nawu ngarriyidko nakka yiman lions nawu kabirrimarrwe dja ngandimarnedangbarrme! ");
INSERT INTO gup_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Wanjh ngaye ngarrulkarreyakminj, yiman kayime kukku manbu kabirriboyakarrbun kore kunkulk, dja kunmurrng ngardduk minj kamurrngbelbmibelbmikenh, dja mak kunkange ngardduk yiman kadjalkelkdan dja kawarremen. ");
INSERT INTO gup_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Manbu kunngudj ngardduk makka wanjh bukminj, mak kundjen ngardduk ngadjenbelbmerrinj kore kaddum kurrang ngardduk. Ngudda wanjh kanbawong bu kankukkurrmeng kore kundjulng, kore darnkih ngakuyindowimeninj. ");
INSERT INTO gup_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Birriwarre bininj ngandimarnemirndebebmeng dja ngandidjokohmeng yiman kayime duruk birribang. Korroko ngandibiddulubom, dja mak ngandidengedulubom ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Bu ngakukmorarraminj dja ngakuknarrinj kunmurrng ngardduk. Birriwern bininj ngandikuknan dja kabirriburlumerren ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Mak kunmadj ngardduk kabirridjalmang dja kabirrihdirri kunkod ba kabirribebbehmadjkarrme. ");
INSERT INTO gup_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Ngudda nawu Yawey, yuwn bu djarreh yihdi ngardduk. Ngudda yidjalkudji nawu kunngudj kanwon, wanjh yimray werrkwerrk bu kanbidyikarrme. ");
INSERT INTO gup_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Kanngehkemen kore bininj nawu kabirridjare ngandibun mandjawakwi. Kandarrkidnahna kore bininj yiman kayime nabang duninjh duruk ngandibun kundulkarre dorrengh bedberre. ");
INSERT INTO gup_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Warridj kabirriyime yiman kayime lions dja kabirridjare ngandibaye. Birrimekbe bininj yiman kayime bulikki nabang duninjh nawu kadjare ngandidulubun kunkanemwi. ");
INSERT INTO gup_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ngaye wanjh ngeymulewan ke bu ngarridjarrkdi bininj nawu ngarridangerrinj. Bu ngaye dja nawu ngudda ke bininj ngarridi, wanjh ngaye burluburlume ke. ");
INSERT INTO gup_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Ngudda bininj nawu ngurrikele nawu Yawey, wanjh ngurriburluburlumen. Ngudda nawu Jacob ngunkebmawahmeng, wanjh ngurringeyburlume. Ngudda nawu Israel ngunkebmawahmeng, wanjh ngurrimarnebodda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Nungka wanjh binahnani nuye bininj kore kunrayek kunkimuk bimarnebebmeng. Minj bidjalbawoyi. Minj mak bimarnekebwarlkkarrimeninj nuye. Bonj, nahni bininj bikayhmeng Yawey bu kabibidyikarrmekenh, dja wanjh Yawey biwokbekkang. ");
INSERT INTO gup_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Ngaye wanjh burluburlume kore ngarrimirndemornnamerren rowk. Ngaye ngadjaldi kumirrk bedberre bu ngakurduyime kore ngaye marneyingkihwokkurrmerren. ");
INSERT INTO gup_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Bu kumekbe nawu birrimarladj bininj wanjh kabirringun dja kabirriworrkmiworren. Dja bininj nawu kabirridjare nawu Yawey, wanjh kabirridjalburlume nuye. Wanjh kundjalmak benmarnekurduyimerra munguyh! ");
INSERT INTO gup_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Kaluk birriwarlahkenh bininj rowk kondah kurorre wanjh kabirriwohburrbun nawu Yawey, dja wanjh kabirrikangeborledkerren kore nungka. Bininj kore namudbubuyika rowk kore kubolkbubuyika rowk, wanjh bedda kabirrimarneboddan nuye. ");
INSERT INTO gup_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Nawu Yawey wanjh nadjalkudji kawohrnawohrnan rowk, dja nungka kabenmarnewohrnan kore kubolkbubuyika rowk. ");
INSERT INTO gup_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Nawu birrikuken bininj rowk kondah kurorre wanjh kabirrimarnekarrme mulil nuye nawu Yawey, dja mak kabirrimarneboddan nuye. Dja mak bininj nawu kabirridowerren rowk, bedda wanjh kabirrimarneboddan nawu Yawey. Minj bedman kabirrimimbiworren! ");
INSERT INTO gup_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Bininj nawu kabirringalme yerrekah, wanjh kabirrimarnedurrkmirri nawu Yawey. Kaluk nawu mawahmawah kadberre, dja mak nawu bedmanwali kabindikebmawahme, wanjh bedda warridj kabirriborlhme nawu Yaweykenh. ");
INSERT INTO gup_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Birrimekbe bininj rowk wanjh kabirrimulewan bu Yawey kabidjaldjadme mandjad duninjh. Bedda kabindibengdayhke wurdwurd nawu minj birringalmeninj. Nawu Yawey wanjh nungan kurduyimeng rowk. ");
INSERT INTO gup_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Nawu Yawey ngannahnan ngardduk yiman kayime namak shepherd kamirndenahnan mayh nuye sheep. Nungka kanwon kunmak kunwern dja minj njale mak ngadjare! ");
INSERT INTO gup_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Nungka ngankurrme ba bu ngangehme kamak rowk kore kabbal manbu kakarrme mandalkmak. Dja mak nungka ngankanakan kore ngabongun manbomak kukku, bu kunmodmikenh dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Nawu Yawey ngankangemarnbun bu nganmalngkerrngehme. Nungka nganbolkbukkan kore manbolh manbu kunmakkenh ngarre ba bu ngaye ngangeyburlume nuye. ");
INSERT INTO gup_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Bu ngaye ngayakmen, bu ngarrowen, yiman kayime ngare kore kunkak nganbarrkbun, wanjh bonj, minj ngakele kunwarrekenh, dja ngadjalburrbun ngudda Yawey ngarrdjarrkre munguyh. Ngudda yikarrme manbu kunkarndudj kore kubid ke bu kankangemarnbun, wanjh kunmekbekenh ngaye ngadjalkangemak. ");
INSERT INTO gup_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ngudda kanmarneyingkihmarnbun mulil kore kumirrk bedberre bininj nawu ngaye ngarriyidko, dja mak kankodjdjuhke mankalkkidmak dorrengh. Ngudda wanjh yihdjalborrahkendong kore banikkin ngardduk dja kabobarlme kore kaddum ngarre bu yiman kayakarrburren. ");
INSERT INTO gup_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Woybukkih, wanjh manbu kunkongi dja kunmakmak ke makka nganehdjaldjarrkdi munguyh, dja ngadjalyo munguyh munguyh kore kunrurrk ngudda ke nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Kondah kurorre rowk dja njalehnjale nawu kahdi kurorre, nakka wanjh Yawey nuye. Birriwarlahkenh bininj rowk nawu kabirrihni kubolkbubuyika kore kondah kurorre, nakka wanjh Yawey nuye. ");
INSERT INTO gup_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Nungka wanjh bolkmarnbom kunbolk rowk bu kurrmeng kanjdjikah kore kurrula duninjh, dja kore kukku kaboyo bolknameng kanjdji duninjh. ");
INSERT INTO gup_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Kaluk nangale bininj namak ba bu kabidbun kore kurrulum nuye Yawey? Nangale bininj kangime kore kubolkdjamun nuye nawu Yawey? ");
INSERT INTO gup_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Nakka nawu kunmak kadjalkurduyime dja mak kadjalburrbun kore kunmakkenh, dja mak minj kabimarneboddan nawu idols, dja minj mak kakurren bu kawokkurrmerren. ");
INSERT INTO gup_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Namekbe namak bininj wanjh nawu Yawey kabimarnekurduyime kunmak. Kaluk God nawu kabingehke wanjh kabidjalmakwan. ");
INSERT INTO gup_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Kuhni kabirrikurduyime birriwern bininj nawu kabirriyawan God. Yoh, birrimekbe bininj kabirridjare ngundikebnan, ngudda God nuye Jacob. ");
INSERT INTO gup_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Mah, wanjh. Ngurrina! Ngurridangmarrhma manbu mankare duninjh gates ba kamngimen king nawu namakkaykenh duninjh. ");
INSERT INTO gup_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Kaluk nangale nahni nawu namakkaykenh king? Nungka wanjh Yawey nawu narrulkarrekimuk duninjh, dja nawu kabenyurrhke birriwarre bininj kunngudj nuye dorrengh kore kabirriburren. ");
INSERT INTO gup_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Mah, wanjh ngurridangmarrhma manbu mankare gates ba kamngimen king nawu namakkaykenh duninjh! ");
INSERT INTO gup_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Kaluk nangale nahni nawu namakkaykenh king? Nungka wanjh Yawey nawu wernhdulkarrekimuk duninjh! Nungka nadjalkudji king namakkaykenh duninjh. ");
INSERT INTO gup_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Ngudda Yawey, ngaye ngamalngkurrmerren kore ngudda! ");
INSERT INTO gup_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Ngudda nawu God ngardduk, ngaye wernhwoybukwon ngudda. Yuwn kanbawon bu ngayemengalme! Mak yuwn yibenbawon nawu ngarriyidko bu ngandidjekmiwon kore ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Nangale bininj nawu ngunwoybukwon nakka wanjh minj kayemengalme. Dja bininj nawu kabindikowe birribuyika bininj bu kunwarrekenh, wanjh kabirriwernhyemengalme. ");
INSERT INTO gup_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Nawu Yawey, kanbukkabukkan kore yidjare ngakurduyime, mak kanbolhbukka ba ngakurduyime kore kunmakkenh. ");
INSERT INTO gup_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Kanka kore kunwoybuk ke, dja kanbukkabukkan warridj. Kuhni ngudda yiyime dja ngudda God ngardduk nawu kanngehke, dja ngaye woybukwon bu barnangarrakuyeng rowk. ");
INSERT INTO gup_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Nawu Yawey, yidjalburrbu ngudda bu kanwernhkongibun dja kandjalmarnedjare kore kunkareni dja mak bolkkime. ");
INSERT INTO gup_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Yuwn mak yiburrbun manbu kunwarrehwarre kore ngaye ngakurduyimi bu ngayawurrinjni, bu ngaye wokburriweyi ngudda. Ngudda kandjalmarnedjare, wanjh kunmekbekenh kunu kandjalburrbun, dja ngudda Yawey wanjh yidjalmakkaykenh. ");
INSERT INTO gup_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Nawu Yawey wanjh nakka nadjalmak duninjh, dja kunmak kadjalkurduyime. Kunmekbekenh kunu wanjh kabenbukkabukkan nawu birriwarre bininj ba kabirriborlhme nuye kore mandjad kabirrire. ");
INSERT INTO gup_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Nungka kabenkan bininj nawu minj kabirrikukdokmibuyhwerren ba bu kabirrikurduyime kunmak, dja mak kabenbolhbukkabukkan nuye manbolh. ");
INSERT INTO gup_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Nawu Yawey kandjalmarnedjare dja minj kankowe ngad bininj nawu karriwokmarrkmang mankarre nuye kore wokkurrmerrinj kadberre. ");
INSERT INTO gup_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","O Yawey, ngaye wernhwarrewong ngudda dja ngadjare yibengmidjda kunwarre rowk ngardduk kore yiwokkurrmerrinj ngudda ke kunngey dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Nangale bininj kabimarnekelemen dja kabimarneboddan nuye nawu Yawey? Wanjh kabibukkan namekbe bininj ba bu kadjalle kore nawu kawohrnan rowk bimarnekarremarnbom nuye. ");
INSERT INTO gup_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Wanjh namekbe bininj kadjalkuken munguyh, dja mak wurdwurd nuye kabirribolkmang kumekbe kunred kore kabirrini. ");
INSERT INTO gup_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Nawu Yawey kayimerran djawirna bedberre bininj nawu kabirrimarneboddan, dja mak kabenbukkan bedberre kunwok manbu nungka yingkihwokkurrmerrinj. ");
INSERT INTO gup_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Ngaye ngadjalnan Yawey nawu nadjalkudji nganbidiyikarrmekenh ba bu nganbebke kore kunwarre nganbongkarrme. ");
INSERT INTO gup_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Yawey, yimborledmen dja kankongibu ngaye, dja ngadjalkudji ngarri dja kunyid wernmerrinj ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Manbu kunnjilngwarre ngardduk makka munguyh kahwernmerren. Ngadjare yiwemen nawu njalehnjale nganhnjilngwarrewon munguyh. ");
INSERT INTO gup_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Wanjh yina ngardduk kunrayek dja kore ngahdjakbekkan, dja yibengmidjda ngardduk kunwarre rowk. ");
INSERT INTO gup_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Yawey yibenmirndena nawu ngaye ngarriyidko! Mak yibenna bu bedda ngandiwernhwidnan duninjh! ");
INSERT INTO gup_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Kankukdjurruddin ba bu ngadjaldarrkid, dja kanngehkemen. Ngaye djalwoybukwon, wanjh yuwn kanbawon bu ngayemikarren. ");
INSERT INTO gup_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Ngaye kunkange dorrengh woybukwon, dja mak wokmarrkmang, wanjh ngadjare bu ngudda kannahnan ba bu ngadjalmalngdarrkid. ");
INSERT INTO gup_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O God, kanngehkemen ngad bininj nawu Israel ngankebmawahmeng kore kunrayek rowk ngarrikarrme. ");
INSERT INTO gup_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Yawey, ngaye djawan bu ngudda kanmakwan. Ngaye mandjad ngadjalkurduyime munguyh, dja warridj ngaye wanjh woybukwon, dja minj mak kewkme, dja minj mak ngamarrkbaworrimeninj ke. ");
INSERT INTO gup_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Yawey, ngaye ngadjare bu ngudda kandjadme. Kanmayalirohrokmen dja kanwernhkangenan ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Dja kunu ngaye minj ngabengmidjdan bu ngudda kandjalmarnedjare, dja wanjh ngadjalkurduyime munguyh kore ngudda ke kunwoybuk. ");
INSERT INTO gup_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ngaye minj ngarridjarrkraworren bininj nawu kabirrihkurrekurren dja nawu kabirriburluburlumerren. ");
INSERT INTO gup_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Dja ngaye ngawarnyak ngarrimirnderri bininj nawu kabirrikurduyime kunwarre, dja ngabendjalbodmewon birriwarre bininj rowk. ");
INSERT INTO gup_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Ngaye yiman ngabiddjirridjburren bu ngamulewarren minj kunwarre ngakurduyimeninj dja ngaye ngadjalboddan kore altar ngudda ke ngudda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Mak ngawayini ke kore kurobbe, dja burluburlume ngudda, bu ngaye mulewan kore kunmakkaykenh duninjh ngudda yidjalkurduyime munguyh. ");
INSERT INTO gup_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yoh, Yawey, ngaye mak ngamarnedjare kunrurrk manbu temple ke kore ngudda yihni, kumekbe kore ngarrinan kunmakmak ke bu kahbolkwolkan. ");
INSERT INTO gup_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Yuwn bu kanbularrbun ngaye yiman yikurduyime bedberre nawu birriwarre bininj. Mak yuwn kanbun bu ngarrowen kankukkurrme yiman bu yibenhmarnekurduyime nawu birrimarndeyi bininj. ");
INSERT INTO gup_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Bedda wanjh birriyidwern dja kabirridjirdmang money dja minj kabirridjare kunmak kabirriyime. ");
INSERT INTO gup_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Ngaye wanjh ngadjalkurduyime kunmak, dja minj kunwarre ngayime. Wanjh kankongibu dja kanngehkemen. ");
INSERT INTO gup_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Wanjh bolkkime ngahdi kunmak dorrengh kore kubolkrayek! Ngaye ngarriraworren bininj nawu ngundimarnemirnderri dja kunmekbe wanjh ngaye djalburluburlume ngudda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Nawu Yawey nakka nganmarnebolkwolkan dja mak nganngehke. Ngaye wanjh minj nangale nabuyika ngakengeme. Nungka nawu Yawey ngankukbalhme, kaluk minj ngayawoyhkele djal bininj. ");
INSERT INTO gup_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Bu nawu birriwarre bininj kabirrimre ngandibun bu yiman ngandikukngun, dja mak bininj nawu ngarriyidko dja nawu ngandiwidnan ngandibun, wanjh kabirribarabun dja kabirridjalmankan. ");
INSERT INTO gup_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Kunukka bonj, bu bininj birridjalwern ngandiwakbuyingun, wanjh nakka minj ngakangewarre. Mak bu nawu ngarriyidko kabirrimre bu ngandibun, wanjh nakka ngadjalmarrkmang nawu Yawey, dja minj ngakele. ");
INSERT INTO gup_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ngaye ngahdi yiwarrudj, dja kundjalkudjikenh ngadjawan nawu Yawey. Ngaye ngadjare bu ngayo munguyh kore nungka nuye kunrurrk. Mak ngaye ngadjare ngayawan Yawey kore nuye temple, dja mak ngadjare ngadjalnan nungka nawu namakkaykenh. ");
INSERT INTO gup_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Bu kunrayek nganmarnebebme, nawu Yawey ngankukbalhme kore kayo. Nungka nganwarlkkan kore dabburlin manrurrkdjamun nuye. Ngandjalkurrme kaddum kore manwarddekimuk. ");
INSERT INTO gup_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Nungka nganbidkenwon nawu ngarriyidko bu ngabenyurrhke bedberre nawu ngandiwakbuyingun. Wanjh ngamarnekinje mayh nuye nawu Yawey, kore Nadjamun Dabburlin nuye, dja ngadjalmarnewayini bu ngaburlume nuye. Ngadjalwayini nuye dja ngawernhmarrmarr dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Nawu Yawey, kanbekka bu kayhkayhme. Kankongibu dja kanwokma. ");
INSERT INTO gup_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Manbu kunkange ngardduk makka nganmarneyime bu ngaye yawayawan ngudda ba bu kebnan ke, wanjh ngamwam bu yawan ba kebnan ngudda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Kanna, dja yuwn kanmarnekebwarlkkarren bu kanbawon. Yuwn bu kandung ngaye nawu marnedurrkmirri ke ngudda nawu munguyh kanbidyikarrme. Ngudda wanjh God nawu kanngehke wanjh yuwn kanmunkewe dja mak kanbawon ngaye. ");
INSERT INTO gup_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Ngalbadjan dja kornkumo ngardduk bu yimankek ngandibawoyi, ngudda Yawey wanjh kandjalkimang. ");
INSERT INTO gup_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Nawu Yawey, kanbukkabukka manbu ngudda ke manbolh. Ngaye ngabenkarrme birriwern bininj nawu ngarriyidko, dja kanmika ba ngakurduyime mandjad. ");
INSERT INTO gup_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Yuwn bu yibenbawon nawu ngarriyidko bininj bu bedda ngandimang, dja nakka ngandimarnekurrehkurren bu ngayekenh ba bu ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ngaye ngawernhwoybukwon mak ngani bu nganan kunmakmak nuye nawu Yawey bu ngaye ngadjaldarrkiddi kondah kurorre. ");
INSERT INTO gup_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Wanjh ngurrimadbu nawu Yawey ba nungka ngunbidyikarrme, mak ngurrimurrngrayeknin dja ngurrikelebuknin ba ngurrimadbun nungka bu ngunbidyikarrme ngudberre. ");
INSERT INTO gup_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","O Yawey! Ngaye wanjh ngakayhme ke, ngudda nawu yiman kunwarddekimuk kore ngaye ngawarlkkarren! Yuwn kandahme dja kanbidyikarrmen bu yiwarrudj ngarri. Dja bu minj kanwokmang nakka wanjh ngaye yiman ngakolung bu ngarriraworren bininj nawu birridowerrinj. ");
INSERT INTO gup_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Kanbekkabekka kore yiwarrudj ngahdi dja djawahdjawan bu ngudda kanbidyikarrme. Ngaye wanjh ngaberlwayhme kore ngabolknan kubolkdjamun duninjh ke. ");
INSERT INTO gup_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Yuwn kankan kore birriwarre bininj ngarriraworren, nawu kabirrikurren bu yimankek yeledj kabirriwokdi dja nakka djal manmolk kabirrihmarnbun kunyid. ");
INSERT INTO gup_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Yibenmarnbu bu kabirridjakbekkan! Warridj yibenbu kore kunwarre kabirrihkurduyime. Yibenwo kunwarre duninjh yiman bu bedda birridjareni bindiwoni birribuyika bininj. ");
INSERT INTO gup_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Bedda minj kabirridjare bu kabirribekkan kore kunmak ngudda yihkurduyime kubid ke. Wanjh ngudda yibenbularrbu dja yibenkukbawo munguyh kore kabirrihkukyo. ");
INSERT INTO gup_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Yawey, ngaye djalburlume bu ngudda kanbekkang kore ngakayhmeng bu yiwarrudj ngahdi, dja wanjh ngudda kankongibom. ");
INSERT INTO gup_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Ngudda nakka shield ngardduk bu kankukdjurruddi, kunmekbekenh ngaye woybukwon duninjh. Ngudda kanbidyikarrmeng, wanjh ngaye ngamarrmarr duninjh dja kunu mulilmang dja mak ngawayini bu manjbun ngudda. ");
INSERT INTO gup_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Warridj kunngudj yibenwon nawu bininj ke, mak yibenngehke dja yibennahnan bininj nawu yibendjarrngbom. ");
INSERT INTO gup_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Yimray Yawey bu kanngehke ngadberre. Kunmak kanmarnekurduyimen ngadberre bininj nawu ngudda ke rowk. Ngudda wanjh yiman kayime shepherd ngadberre dja munguyh kanwanjbikarrme ngadberre. ");
INSERT INTO gup_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Ngudda ngurrikihkimuk nawu ngurrihni kore heaven, wanjh ngurringeyburluburlumen nawu Yawey! Ngurriyimen nakka wanjh nadjalmakkaykenh dja narrulkarrekimuk duninjh! ");
INSERT INTO gup_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Ngurriburlumen Yawey nawu nangeymakkaykenh duninjh. Nawu Yawey nakka nawernhkukdjamun duninjh dja yiman kahbame kunmakmak nuye dorrengh, wanjh ngurrimarnebodda! ");
INSERT INTO gup_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Nawu Yawey kawokdi, wanjh manbu kurrula kabiwokmarrkmang. God nawu Namakkaykenh kawokdi yiman kayime kangurdulme kaddum dja kawokngoyowhme djarreh kore manbu kurrula. Bu kawokdi wanjh kawokyurrhke kunwok ngarre kurrula duninjh. ");
INSERT INTO gup_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yawey nakka wernhwokkimuk duninjh. Nawu Yawey kawokdi kundulkarre dorrengh nuye nawu kawohrnan rowk. ");
INSERT INTO gup_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Kunwok nuye Yawey kahdulkbakbakke manbu cedar kundulk, mak kabolkdjalkdjalkmire kundulk manbu cedars manbu kahdulkmirnderri kore kunred Lebanon. ");
INSERT INTO gup_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Nungka kabolkrokayhwe kubolkkimuk Lebanon bu kabolkdohdolkan yiman bulikki yaw. Mak kamarnbun kuwarddekimuk manbu Hermon kabolkdolkan yiman bulikki yaw nawu nabang. ");
INSERT INTO gup_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Bu nawu Yawey kawokdi, nakka yiman kayime namarrkon kamayhmayhke dja kabolkdongorrong. ");
INSERT INTO gup_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Bu nawu Yawey kawokdi, wanjh manbu kubolkdarleh kahbolkrokahrokan. Bu nungka kawokdi wanjh kabolkdeldelme kubolkdarleh kore kabolkngeyyo Kadesh. ");
INSERT INTO gup_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Bu nawu Yawey kawokdi, nakka karrulkborledke kundulk manbu oaks, dja kunworr ngarre makka kaworrkudjkudjmire. Dja birriwern nawu kabirrihni kore manrurrkdjamun temple nuye, wanjh kabirriburlume bu kabirrikayhme kabirriyime, “Nawernhmakkaykenh Duninjh!” ");
INSERT INTO gup_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Nawu Yawey nakka kahyerrkan kaddum duninjh, dja kawohrnan kore kabodjurrbuhme kukku munguyh munguyh. Yawey wanjh king duninjh nawu kawohrnan rowk munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Nawu Yawey wanjh kunngudj kabenwon bininj nuye, dja mak kabenwon kunmodmikenh nuye ba kamak kabirrihni. ");
INSERT INTO gup_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Ngaye burluburlume ngudda nawu Yawey! Ngudda kanbebkeng kore kumidjbeh dja yibenwarrewong nawu ngarriyidko ba minj birrimulilmayinj dja birriburlumerrimeninj ngayekenh. ");
INSERT INTO gup_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Yawey ngudda nawu God ngardduk! Ngakayhmi bu ngarrangeni yiwarrudj dja djawam bu kanbidyikarrmekenh, wanjh ngudda kanmarnbom. ");
INSERT INTO gup_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Yawey, ngudda kandolkkayhweng kore kundowikenh, dja kanngehkeng ba minj ngakoluyi kanjdji duninjh kore kubolkwarre. ");
INSERT INTO gup_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Ngudda ngurriwern bininj nawu Yawey nuye, ngurrimarnewayinin! Ngurriburlumen, ngurringeyburlumen kunngeydjamun nuye. ");
INSERT INTO gup_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Bu yarrkka nungka kayirrung kadberre, nakka minj kahdjalkangedi bu kunkuyeng, dja manbu kunkongi nuye kahdjaldi bu munguyh munguyh. Bu karrinalkbun kunkakkuyeng, karrimarrmarr duninjh bu kamdungbebme. ");
INSERT INTO gup_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Bu ngaye ngabekkarrinj kamak rowk, wanjh ngaburrbuni bu baybaywi ngayimerrinj, “Ngaye minj nangale mak nganwodjorrhme!” ");
INSERT INTO gup_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Yawey, ngudda nakka ngarrdabbolkni, ngudda kannahnang dja kanmarnekukdjurruddanginj. Dja bu ngudda kanmarnekebwarlkkarrinj ngardduk, wanjh ngaye ngakeleminj dja ngakangewarreminj. ");
INSERT INTO gup_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","O Yawey, ngaye ngarri yiwarrudj bu ngakayhmeng ke, djawahdjawani ngudda, wanjh ngayimeng, “Nawu Yiwohrnan Rowk kankongibu! ");
INSERT INTO gup_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Yiddok baleh kunmak kakurduyimerran bu ngaye ngarrowen dja bu ngakukdudjindan kore kumidj? Mak bu kundjulng ngayimerran kunukka baleh ngayime bu ngudda burlume dja mak ngamulewan bu ngudda yidjalwoybuk duninjh? ");
INSERT INTO gup_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Yawey ngaye ngadjare kanbekkabekkan dja kankongibu. Kanbidyikarrmen Yawey!” ");
INSERT INTO gup_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Bu nganjilngwarreni ngudda kankangeborledkeng bu nganjilngmakminj, wanjh ngaye marneborrkeng. Wanjh ngaye minj ngadjalnjilngwarreni dja ngudda kanmarnbom bu ngamarrmarrminj duninjh. ");
INSERT INTO gup_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Wanjh kunu ngawayini ngudda djahdjalburluburlume kunkange dorrengh ngardduk, mak minj ngangurdme. Ngudda Yawey wanjh God ngardduk, wanjh djalmanjbun bu munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Yawey ngaye ngamwam ngawarlkkarren kore ngudda kannahnan. Yuwn kanbawon bu yerrekah ngayemekarren. Ngudda nawu yidjalkurduyime kunmak wanjh kanngehkemen. ");
INSERT INTO gup_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Mak kanwokma bu ngaye djawahdjawan dja werrkwerrk yimray kanngehkemen! Ngudda yiman manwarddekihkimuk ngardduk dja mak ngudda yiman manrurrk mankimuk kore ngani kamak rowk ba minj nangale nganbun. ");
INSERT INTO gup_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Bu kunmekbekenh wanjh kanka mandjad kore ngudda yidjare, dja kanbolkbukkabukkan dja kanka munguyh, ngudda nawu yiwernhngeykimuk duninjh. ");
INSERT INTO gup_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Bu ngamankan kore ngandimarnebolkkaruy dja kandidarrkidmang ngardduk, wanjh kanbebkemen kore ngabongdi ba bu ngawarlkarren kore ngudda nawu yidjalkudji kannahnan munguyh. ");
INSERT INTO gup_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Ngaye ngamalngkurrmerren kore kubid ke. Yawey ngudda God nawu Yidjalwoybuk, wanjh kanbebkemen kore kunwarre ngahdi. ");
INSERT INTO gup_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Ngaye ngabenwidnan bininj nawu kabirrihmarneboddan nawarrewarre idols. Dja ngaye wanjh djalwoybukwon ngudda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ngudda yimimkongiwern duninjh kaluk kunmekbekenh ngaye mulilmang dja ngawernhmarrmarr kore ngudda kanmarnedjare. Ngudda kannani rowk kore ngahdjakbekkani, wanjh ngudda kankangeburrbuni kore ngaye ngawernhnjilngwarreni. ");
INSERT INTO gup_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ngudda minj kanbawoyinj nawu ngarriyidko ngandibuyi, dja kankurrmeng kore kubolkmak ngarri. ");
INSERT INTO gup_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Kankongibu Yawey! Ngaye ngawernhnjilngwarreminj dja ngakuyinmimdubberran. Warridj nganalkbun munguyh dja kunu ngawarreworren kunburrk dja mak kunmalng ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Ngaye munguyh ngadjalnjilngwarre duninjh. Ngadjalnalkbun munguyh munguyh, wardi darnkih ngarrowen. Manbu kunrayek wanjh nganngudjyakwon, dja mak ngabekkarren yiman ngamurrngkelkdan. ");
INSERT INTO gup_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Birridjalwern bininj ngandiwidnan dja mak nawu ngarriredbo ngandiwarrewan. Nawu ngardduk djawirna wanjh bedda ngandikengeme. Bu bedda kandinan djarreh ngamre, wanjh kabirrikelerlobme bu kandibawon. ");
INSERT INTO gup_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Bedda kabirriyime ngaye yimankek ngarroweng, dja minj mak ngandiyawoyhburrbun. Bedda ngandikukburriwe yiman kayime ngaye ngaburriwe cup nawu bakmeng. ");
INSERT INTO gup_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Ngabenbekkabekkan birriwern bininj bu munguyh ngandiyolyolme kore ngandimarnekurrehkurren. Ngaye wanjh ngakele bu munguyh dja birriwern bininj kabirrikarremarnburren bu ngaye ngandibun ba ngarrowen. ");
INSERT INTO gup_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Dja bonj, ngaye ngadjalkangekurrmerren kore ngudda, Yawey. Ngaye marneyime, “Ngudda Yawey wanjh God ngardduk!” ");
INSERT INTO gup_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Ngudda yidjalkudji yibolknameng rowk kore ngaye ngarranginj dja mak kore ngarrowen. Kanngehkemen kore ngandiwidnan bininj, dja bininj nawu ngandikelekadjung. ");
INSERT INTO gup_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Kannahna dja kankongibu ngaye nawu marnedurrkmirri ke. Ngudda nawu kanmarnedjare munguyh munguyh wanjh kandjalngehke. ");
INSERT INTO gup_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","O Yawey, yuwn bu kanbawon ngaye ngayemengalme, dja ngakayhmeng ke bu kanbidyikarrmekenh. Dja ngaleng, yidjalmarnbu nawu birriwarre bininj bu bedman kabirriyemengalme, dja yerre kabirridjalkukyo kore kumidj. ");
INSERT INTO gup_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Bedda wanjh kabirriburlumerren dja kabirriwidnan nawu birrimak bininj, dja kabindiyolyolme bu kunwarre dorrengh. Mah, wanjh yibenngurdkemen kore kabirrikurrehkurren ba bu kabirriwokyak. ");
INSERT INTO gup_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Ngudda wanjh yimakkaykenh. Ngudda yidjehdjenkurrmeng kunmakmak bedberre bininj nawu ngundikengeme. Ngudda yibenwon birrimekbe bininj kunmakmak kore birriwarlahkenh bininj ngundikurdunan. ");
INSERT INTO gup_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Yibenwarlkkan kore ngudda yihni ba kabirringehme, dja birriwarre bininj minj kabindimarnekurduyime kore kabirrikarremarnburren. Yibennahnan kore ngudda ke kunred dja bininj nawu kabindiyolyolme minj kabindidjuhbun kumekbe. ");
INSERT INTO gup_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Ngaye ngaburluburlumen nawu Yawey! Nungka wanjh woybukkih kanmarnedjareminj wernkih duninjh bu birriwarre bininj ngandiwabminguneng bu ngandibuyi. ");
INSERT INTO gup_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Ngaye ngakeleni duninjh, dja ngayimeng, “A! Ngudda minj kannan ngaye!” Dja bonj, ngudda wanjh kanbekkang kore ngakayhmi bu djawadjawam kankongibunkenh dja kanbidyikarrmekenh. ");
INSERT INTO gup_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Ngudda bininj rowk nawu Yawey nuye, wanjh ngurrimarnedjarenin! Nungka wanjh kandjalnahnan ngad bininj nawu minj karribawon kore karriwoybukwon. Dja bininj nawu bedman kabirriburlumerren, wanjh nakka kabenbun kore kunwarrekenh bedberre. ");
INSERT INTO gup_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Mah, ngurrimurrngrayeknin, dja ngurrikangemarnburrimen ngudda bininj rowk nawu ngurridjalmadbun nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Kawernhnjilngmak nawu bininj bu God kabimarnebengmidjdan kunwarre nuye, dja kabimarnebularrbun rowk manbu kunwarrekenh nuye. ");
INSERT INTO gup_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Kahnjilngmak nawu bininj bu Yawey minj kabidjadme dja kabiwarrewan. Kahnjilngmak namekbe bininj nawu minj kadjare kakurren kore kukange nuye. ");
INSERT INTO gup_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Ngaye, bu ngaye kunwarre ngakurduyimeng dja minj ngawarnyakmulewarrimeninj, dja ngadjaldi wokyak, wanjh ngabekkang ngangudjwarreminj kore kunmurrng ngardduk. Dja ngaye ngadjalngeyngeyyimi bu barnangarrakuyeng. ");
INSERT INTO gup_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Yoh, Yawey, barnangarrawern dja mak kunkakwern ngudda kandulmukwoni bu kunwarrekenh ngardduk. Mak kunngudj ngardduk makka yakminj rowk yiman kayime manbu kundungbang nganngudjwarrewon. ");
INSERT INTO gup_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Wanjh ngawarnyakmulewarrinj bu ngayolyolmerrinj bu marneyimeng ngudda. Minj mak ngawarlkkayi kunwarrekenh ngardduk. Ngaye wanjh marneyimeng ngudda Yawey, bu ngayimeng, “Ngaye ngamulewarren ke kore kunwarre ngakurduyimeng.” Wanjh ngudda yibularrbom rowk ngardduk kunwarre. ");
INSERT INTO gup_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Wanjh kunmekbekenh kunu ngayime ngudberre bininj nawu ngundingeyburrbun, nakka wanjh yiwarrudj birrdin bu ngudda ngundiyawayawan. Mak kunrayek manbu kawayhme bedberre, yiman kukku bu kahbokimukmen wanjh kunukka minj kabirrikebngakme. ");
INSERT INTO gup_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ngudda Yawey wanjh yidjalkudji ngardduk nawu kankukbalhme, dja bu kunrayek kabebme ngardduk ngudda kankukdjurruddi. Ngudda kankurrme kore ngarriwayini bu ngarriyime, “Ngudda Yawey wanjh kanngehkeng ngadberre.” ");
INSERT INTO gup_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Wanjh nawu Yawey kayime, “Ngaye bolhbukkabukkan kore mandjad yibolhkadjung, mak ngaye bengdayhke dja nahnan ngudda kore yire. ");
INSERT INTO gup_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Dja yuwn bu yimayaliyimerran yiman djarrang nawu minj njale kaburrbun. Dja nakka bininj kabibongkanakan kunyarl dorrengh ba kunukka kabidarnhyikan.” ");
INSERT INTO gup_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Nawu birriwarre bininj nakka kabirrikarrme kunrayek kunwern. Dja Yawey kabenmarnedjare bininj nawu kabirrikangewoybukwon, dja nuye kunmakmak nakka kabenwakbuyingun bu munguyh. ");
INSERT INTO gup_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Mah, wanjh ngudda nawu ngurrimak bininj, ngurrinjilngmaknin dja ngurrimarrmarr kore Yawey. Ngudda nawu ngurrimayalimak, wanjh ngurridjalwayinin nuye bu ngurridjalmarrmarr. ");
INSERT INTO gup_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Ngudda ngurrimak bininj, wanjh ngurriwayinin nawu Yawey bu kunnjilngmak dorrengh. Ngudda nawu ngurriwokmarrkmang, wanjh kamak bu ngurriburluburlume nuye. ");
INSERT INTO gup_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Ngurribu harps dorrengh bu ngurridirri manbu ten kunyarl kakarrme ba bu ngurrimarnewayini dja ngurriburlume. ");
INSERT INTO gup_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Mak ngurrimarnewayinin nuye manbu mankarrekerrnge. Ngurribu instruments bu kamak rowk, dja mak ngurrikayhme nuye bu ngurrimarrmarr duninjh. ");
INSERT INTO gup_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Nawu Yawey wanjh djal kunwoybuk kawokdi dja mak kunwok nuye djalmandjad. Nungka kakurduyime rowk kore kawokkurrmerren. ");
INSERT INTO gup_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Warridj nawu Yawey kadjare bu ngudda kunmak ngurrikurduyime dja mak bu djal mandjad ngurridjadmerren. Nungka kandjalmarnedjare ngad karriwarlahkenh bininj nawu kurorre karrihni. ");
INSERT INTO gup_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Mak nungka marnbom kaddum dja njalehnjale ngarre kore kunwok nuye. ");
INSERT INTO gup_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Nawu Yawey bomornnameng manbu kurrula, dja manbu kaburrk wanjh makka djalbokurrmeng kanjdji ba bu kahborri munguyh. ");
INSERT INTO gup_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Mah wanjh ngad karriwarlahkenh bininj nawu kondah kurorre karrihni, karrimarnebarddurrukkurlhda Yawey nawu nadjalkudji kawohrnan rowk. ");
INSERT INTO gup_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Bu kunmekbe nungka wokdanginj mahni kurorre wanjh bolkmarnbuyindanj! Manbu kurorre rowk biwokmarrkmey kore nungka yimeng. ");
INSERT INTO gup_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Mak bu ngad karriwarlahkenh bininj karrikarremarnbun kunwarre, wanjh Yawey kabularrbun mankarrewarre kadberre bu kakarrewarrehwarrewon. ");
INSERT INTO gup_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Dja kore nungka kakarremarnbun, nakka kadjaldi bu munguyh munguyh. Nungka kadjalkurduyime kore nungka karremarnburren bu munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Bininj nawu kabirrimarneboddan Yawey dja kabirriyime nungka God bedberre, wanjh nungka kabenmarnekurduyime kundjalmak bedberre. Nungka wanjh bendjarrngbom dja benmarnbom bu djal nuye bininj. ");
INSERT INTO gup_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Nawu Yawey kahdi kaddum kore heaven dja kabolknan kanjdji kore kurorre. Kaluk kabennan birriwarlahkenh bininj rowk. ");
INSERT INTO gup_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Kahyo kaddum kore nuye, dja wanjh kannan karriwarlahkenh kadberre rowk nawu kondah kurorre karrihni. ");
INSERT INTO gup_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Nungka nawu kunmayali kanwon karriwarlahkenh bininj rowk dja kankurdunan, dja mak kanmayalinan rowk kadberre kore njale karrikurduyime . ");
INSERT INTO gup_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Nawu birrikihkimuk nawu kings, bu kabenmirndekarrme birridjalmirndewern nawu armies, wanjh bonj, minj kabirringehkerren kore nawu birriyidko bedberre. Mak bininj nawu birringudjbang, wanjh bonj, nakka minj kabirrimarnburren bu kabirringehkerren. ");
INSERT INTO gup_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Dja warridj bu kabirriburren war, minj kabirrimarnemarrkkurrmerren bedberre nawu djarrang nabang bu kabenkan kore minj nangale kabenbun. ");
INSERT INTO gup_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Kaluk nawu Yawey kabennahnan bininj nawu kabirrimarnekele dja mak kabirrimarnekurrmerren kore nungka, mak bu kabirrimarrkmang kabirriwernhburrbun bu nungka kabenmarnedjare munguyh. ");
INSERT INTO gup_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Warridj nungka minj kabenbawon bu bedda kabirridowen, dja mak kabendarrkidwon kore manme kayakmen dja kunmarrwekenh kawernmerren bedberre. ");
INSERT INTO gup_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Ngad wanjh karrikurrmerren kore nawu Yawey, nawu nadjalkudji kanbidyikarrme dja kankukdjurruddi kadberre. ");
INSERT INTO gup_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Karridjalkangenjilngmak nungkakenh, dja karridjalwoybukwon nungka nawu nangeydjamun duninjh. ");
INSERT INTO gup_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O Yawey, kandjalmarnedjarenin ngadberre, dja ngudda yidjalkudji bu ngundimadbun dja ngundimarrkkebbun ngudda. ");
INSERT INTO gup_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Ngaye ngahdjalburlume nawu Yawey bu djal munguyh. Minj ngangurdme bu ngaye ngadjalburluburlume. ");
INSERT INTO gup_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Ngaye wanjh ngaburlume nawu Yawey ngardduk kukange dorrengh! Nawu birrimarladj bininj nakka wanjh birriwokbekka nawu Yawey, dja kabirrimarrmarr duninjh. ");
INSERT INTO gup_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Mah, wanjh karridjarrkngeykimukwon nawu Yawey, ngaye dorrengh. Mak karridjarrkngeyburlumen nuye. ");
INSERT INTO gup_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Ngaye ngayawayawam dja ngadjawadjawam nawu Yawey, wanjh nungka nganwokmey, dja nganngehkeng kore kunkele kunwern ngahkarrmi. ");
INSERT INTO gup_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Bininj nawu nungka kabirriyikan nakka kabirrinjilngmak dja yiman kabirrikebbame, dja minj mak kabirriyemengalme. ");
INSERT INTO gup_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Ngaye nakka ngamarladjni dja bu ngakayhmeng nawu Yawey, nungka wanjh ngankayhmibekkang dja nganbebkeng kore kunrayek kunwern ngahkarrmi. ");
INSERT INTO gup_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Nawu angels birriwern nuye nawu Yawey wanjh kabindidjurruddi bininj rowk nawu kabirrimarnekele nuye, wanjh kabenngehke. ");
INSERT INTO gup_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Wardi yiman kayime ngudda yimanjbekka bu yirohrokmen nungka nadjalmak duninjh nawu Yawey. Bininj nawu kabikurrmerren kore Yawey wanjh nakka kunmak kabimarnekurduyime. ");
INSERT INTO gup_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Ngudda nawu bininj nuye Yawey, wanjh ngurrimarnekelenin. Bininj nawu kabirrikele nuye, nakka kaluk kabirrikarrme njalehnjale nawu kabirridjare. ");
INSERT INTO gup_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Mayh nabang duninjh yiman lions, wanjh kabirringudjyakworren dja kabirridjalmarrwedowen. Dja bininj nawu kabirridjalmadbun Yawey, nakka wanjh kabirrikarrme namakmak nawern. ");
INSERT INTO gup_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Wurdwurd! Ngurrimray ngaye kandibekkan, dja bukkabukkan ngudberre ba bu ngurrimarneboddan Yawey. ");
INSERT INTO gup_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Bu ngudda ngurridjare ngurridarrkiddi kunkuyeng, dja mak bu ngurridjare ngurrinan kunmodmikenh, wanjh kuhni ngurrikurduyimen. ");
INSERT INTO gup_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Yuwn bu ngurriwokdi kunwarrekenh dja mak ngurringurdkerrimen kore ngurrikurrekurren. ");
INSERT INTO gup_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Yuwn bu mak ngurridjalkurduyime kunwarre. Ngurribawo, dja ngurrikurduyimen djal kunmakkenh. Ngurridjarenin kunmodmikenh, dja ngurrimarnburrimen bu kamak rowk ngurrini kunmodmikenh dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Nawu Yawey kabennahnan nawu birrimak bininj dja nungan kabenbekkabekkan bu kabirrikayhme nuye. ");
INSERT INTO gup_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Nawu birriwarre bininj nakka kabenwirrihme, dja kabenngeybularrbun ba bu minj nangale kabenyawoyhburrbun kondah kurorre. ");
INSERT INTO gup_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Yawey kabenkayhmibekkan nawu birrimak bininj bu kabirrimarnekayhme nungka, dja munguyh kabenbebke bu kunrayek kawernmerren bedberre. ");
INSERT INTO gup_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Mak nungka karrarnhdi bedberre bininj nawu kabirrikangewarre, dja bininj nawu kabirrimarrkbaworren dja kabirrikangewarre, wanjh nakka kabenngehke. ");
INSERT INTO gup_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Bininj nawu nadjalmak kunubewu kunrayek kabebme nuye. Wanjh Yawey kaluk kabibebke dja kabingehke munguyh. ");
INSERT INTO gup_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Nungka kabiwernhnahnan ba minj kunwohkudji kunmurrng nuye kawohbakme. ");
INSERT INTO gup_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Nawu nawarre bininj, wanjh kunwarre kabibun. Dja bininj nawu kabirriwidnan nawu namak bininj, nakka wanjh God kabendjadme dja kabenwarrewan bedberre. ");
INSERT INTO gup_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Nawu Yawey kabenngehke nawu kabirrihmarnedurrkmirri nuye. Bininj nawu kakurrmerren kore Yawey kabinahnan, nakka wanjh kani kamak, dja Yawey minj kabiwarrewan. ");
INSERT INTO gup_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Yawey! Ngudda yibendabkemen bininj nawu ngaye ngandiwidnan. Wardi yibenbun bininj nawu ngaye ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Kankukbalhmen yiman bu yidjurruddangen kore ngaye, dja kanbidyikarrmen kore kunyid wernmerrinj ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Bininj birribang ngandiwernhkadjung bu ngandibunkenh. Yimka mankole dja lama ke, dja yibenbu. Kankangemarnbu bu kanmarneyimen, “Ngaye wanjh ngehke!” ");
INSERT INTO gup_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Bininj nawu kabirridjare ngandibun wanjh ngadjare bedda kabirridjalbarabun dja kabirriyemekarren. Bedda nawu birridjareni yimankek ngandibuyi, wanjh yibenkelekadju ba kabirridurnderren kunkele dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yawey, ngadjare mak yimunkewemen nawu angel ngudda ke, ba kabenkukwe nahni bininj yiman kunmayorrk kahburriwe kundalkdarleh. ");
INSERT INTO gup_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Warridj yibenmarnbu bu kabirrikelerlobme kore kubolkmunun bu ngudda ke angel kabenhkelekadjung. ");
INSERT INTO gup_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Dja ngaye minj njale ngawarrewoyi bedberre. Bedda bu djal burudjang wanjh kabirriyingkihmarnburren kore ngandidarrkidmang ngardduk bu yimankek ngandibun. Bedda ngandimarnebolkkaruy kanjdji duninjh. ");
INSERT INTO gup_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Wanjh yibenmarnbu kabirrikangebarrhme bu yibenbun. Ngadjare bedman kabirriwohmankan kore kudjorlok manbu bedmanbidju birrimarnbom, ba bu kabirribularrbuyindan. ");
INSERT INTO gup_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Wanjh kunu nganjilngmakmen kore ngudda nawu Yawey. Ngadjalmarrmarr bu ngudda wanjh kanngehke. ");
INSERT INTO gup_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Ngaye ngakayhme, kukange ngardduk dorrengh bu ngayime, “Minj nabuyika god yiman ngudda Yawey! Minj nangale ngunerohrok! Ngudda yibenngehke nawu birrimarladj bininj kore nawu birribang kabindiwarrewon. Warridj yibenngehke nawu birrimarladj kore nawu birribang bininj kabindimarnedjirdmang.” ");
INSERT INTO gup_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Nawu birribang bininj kabirrikurrehkurren bu ngandidjuhbun kore minj njale ngaburrbun. Bedda ngandimarnekarremarnbun. ");
INSERT INTO gup_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Ngaye ngadjalkurduyime kunmak, dja bedda ngandidjaldjuhbun ba bu ngandiwon kunwarre. Wanjh ngaye ngakukmayahme dja mak ngakangewarremen duninjh. ");
INSERT INTO gup_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","14","Bu bedda birridulkihyoy, wanjh ngaye nganjilngwarreni bedberre dja ngabenmarnenalkbuni, warridj minj manme nganguyinj. Dja ngadjaldanginj yiwarrudj bedberre. Dja bu ngudda minj yibenmarnbuyi kore ngaye djawani, wanjh ngaye ngadjalbolknani bu nganalkkihrey bu ngaye yiman rerrih ngahmarnenalkbuni nawu nganedabbolk dja ngalbadjan ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Wanjh birrimekbe nawu ngandiwidnani birrinjilngmakmeni bu ngandinang ngaye ngamankang. Birrimirndemornnamerrinj manmolh ba bu ngandidjekmiwong. Bedda birriraworrinj nawu birridjenbuyika bininj dja ngandimarnekurrehkurreni. ");
INSERT INTO gup_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Bedda yiman kayime bininj nawu kabirriwirrihme God dja ngandiwabminguneng dja ngandidjekmiwong dja ngandiwidnani. ");
INSERT INTO gup_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Dja ngudda Yawey yidjaldi yibennahnan bu kunmekbe ngandimarnekurduyime. Wanjh nuk kanbidyikarrmen, wardi ngandibun. Kanngehke ngaye kore bedda ngandikuyinbun yiman lions nabang dja wardi ngarrowen. ");
INSERT INTO gup_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Dja bu bininj ke kabirrimirndemornnamerren ngaye warridj, wanjh ngaye kaluk burluburlume ngudda dja mak manjbun kore kumirrk bedberre. ");
INSERT INTO gup_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Yuwn yibenbawon nawu ngaye ngandiwidnan bu kabirrinjilngmak ngayekenh. Nakka ngandiwidnan bu djal mankarreburudjang. Bedda wanjh kabirriburlumerren bu ngaye ngandidjekmiwon. ");
INSERT INTO gup_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Birrimekbe nawu birriwarre bininj wanjh minj kabirridjare kunmodmikenh. Bedda wanjh kabindimarnekurrehkurren bininj nawu kabirrihdjalni kamak rowk kore kurorre. ");
INSERT INTO gup_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Namekbe nawu birriwarre bininj ngandidarrkidjuhbun bu kabirriyime, “Yah! Kunukka wanjh ngudda yikurduyimeng! Ngad wanjh ngundinang kunmim ngadberre!” ");
INSERT INTO gup_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Ngudda nawu Yawey! Ngudda yibenkurdunang rowk kore bedda ngandimarnekurduyimi. Dja yuwn kanbawon bu yidjaldi djarreh! ");
INSERT INTO gup_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Ngudda God ngardduk! Ngudda wanjh kanmarnewohrnawohrnan! Wanjh kankidma, dja kanbidyikarrmen. ");
INSERT INTO gup_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yawey, ngudda nawu God ngardduk. Wanjh yibenbukka bininj nawu ngandidjuhbun bu ngaye ngaye ngamak bininj, bu djal mandjad ngakurduyime. Dja yuwn bu yibenbawon bu bedda ngandidjekmiwon. ");
INSERT INTO gup_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Mak yuwn bu yibenbawon bedda kabirrimarneyimerren ngayekenh, “Bonj, wanjh karridarrkidmey nahni nawu karrihdjareni bu karrimarnekarrewarrehwarrewong!” ");
INSERT INTO gup_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Bedda nawu kabirrinjilngmakmen ngayekenh bu ngandinan ngamankan, wanjh ngadjare yibenmarnbun bu kabirridjalbarabun dja kabirriyemekarren. ");
INSERT INTO gup_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Dja bininj nawu ngaye ngandiburlume bu ngudda kanmakwan, wanjh bedda kabirridjalnjilngmaknin dja ngundidjalwayini ke bu kabirrikayhme munguyh munguyh, kabirriyime, “Karridjalburluburlumen nawu Yawey! Nungka wanjh kabirrokmiwe nuye bininj nawu kabimarnedurrkmirri!” ");
INSERT INTO gup_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Wanjh ngaye ngayolyolme bu mulewan nguddakenh, dja ngayime bu ngudda yidjalkurduyime kundjalmak bu munguyh. Dja mak ngaye burluburlume ngudda kunbarnangarrakuyeng bu munguyh. ");
INSERT INTO gup_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Kuhni ngaburrbun kanjdji kore kukange ngardduk. Ngayolyolme bininj nawu birriwarre, dja kunwarre bedberre. Bedda wanjh minj kabirrimarnekele God, dja minj nungka kabirridjalwokmarrmang. ");
INSERT INTO gup_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Nahni bininj nawu nawarre, wanjh kaburlumerren. Nungka kayimerren, “Ngaye ngamak!” Minj mak kahmulewarren kunwarrekenh nuye, dja minj kawirrihme nuye kunwarre. ");
INSERT INTO gup_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Nahni bininj nawu nawarre wanjh bu kawokdi, wanjh kunwok kunwarre kayime, dja mak kahkurrehkurren. Nungka mayaliwarreminj, dja bawong kore kunmak kurduyimeninj. ");
INSERT INTO gup_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Nahni bininj nawu nawarre, bu kakeyo manbalabala nuye, minj kakodjkeyo, dja baybaywi kadjalkarremarnburren kunwarrekenh. Nungka wanjh kakebrokmarnburren kore kunwarre. Minj mak kaburriwe kunmayaliwarre. ");
INSERT INTO gup_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Nawu Yawey, ngudda wanjh kanmarnedjare bulkkidj duninjh, dja kunkimukkenh yiman kayime kaddum heaven. Ngudda mak kanmarneyime bu djal kunwoybuk duninjh. Nakka kunkimuk duninjh yiman kaddum duninjh. ");
INSERT INTO gup_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Nawu Yawey! Ngudda yidjalkudji yikurduyime kundjalmak duninjh bu munguyh munguyh, dja minj kunwarre yiyime. Kunwok kunmak ke kadjaldi yiman kayime kuwarddekimuk. Dja mak ngudda kandjadme ngad bininj bu djalmandjad duninjh. Bu kanmarnewokdi kore kandjadmekenh wanjh mahni kunwok ke kahburrk duninjh yiman kore kurrula. O Yawey, ngudda kannahnan ngad bininj dja mak yehyeng rowk nawu kahdarrkid, wanjh yidjalnahnan rowk. ");
INSERT INTO gup_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Ngudda kanmarnedjare ngad bininj bu bulkkidj duninjh! Nawu ngarrikuken bininj dja mak nawu ngarrimarladj, wanjh ngarrimre kore ngudda yidjalkukdjurruddi ngadberre. ");
INSERT INTO gup_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Kumekbe wanjh ngarridjalngun dja ngarribongun manwern kore ngudda kanwon rowk, dja kanworrkmiwon bu kanwon manme manmakmak ke. Kamak bu kanwon kunmakkenh kore ngudda ke kunwernkenh. ");
INSERT INTO gup_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Ngudda yidjalkudji yimarnbun manbu kundarrkidkenh, dja ngad kandarrkidwon, manbu ngudda ke! Dja mak ngudda kanmarnebolkwolkan ngadberre kore ngudda ke, ba bu ngad ngarribolknan mandjad. ");
INSERT INTO gup_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Ngad nawu ngundiburrbun, wanjh ngarridjare ngudda kandjalmarnedjare munguyh. Ngad nawu ngarriyime bu djal kunmak ke, wanjh ngarridjare ngudda kanmarnekurduyime kunmak ke bu munguyh. ");
INSERT INTO gup_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Kannahnan ngaye, dja nawu kabirriburlemerren bininj wardi ngandimelme, dja nawu birriwarre bininj wardi ngandimarnbun bu ngakelerlobme. ");
INSERT INTO gup_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Dja wanjh ngahnan nawu kabirrikurduyime kunwarre, wanjh kabirridjalyo kore yibenkukburriweng, dja minj mak kabirriyawoyhdolkkan. ");
INSERT INTO gup_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Yuwn bu ngurrinjilngwarremen bedberre nawu birriwarre bininj. Dja yuwn bu mak ngurrikirnwe bedberre nawu kabirrikurduyime kunwarre. ");
INSERT INTO gup_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Nakka birriwarre bininj wanjh yiman kayime kundalk manbu kahdarlehmen. Dja bedda warridj yiman kayime mankolhdemak, dja kaluk kabirridjalbukmen. ");
INSERT INTO gup_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Ngudda wanjh ngurridjalkangekurrmerren nawu Yawey, dja ngurridjalkurduyimen kunmak. Ngurridjaldin kamak rowk kore kurorre. ");
INSERT INTO gup_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Ngurrimarnenjilngmarnburrimen kore nawu Yaweykenh. Dja nungka wanjh ngunwon kunmakmak kore ngurridjare. ");
INSERT INTO gup_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Ngurrikurrmerrimen kore Yawey bu ngunbolhbukkan dja mak ngunnahnan. Ngurrikangekurrmerren kore nungka, dja nungka ngunmarnekurduyime kunmakkenh. ");
INSERT INTO gup_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Kaluk nungka ngunmarnbun ba bu ngurrimak bininj, yiman kayime ngurrikukbame! Nungka mak ngundjadme dja ngunmakwan, ba ngurribolkwolkan yiman kayime manbu kundungbang. ");
INSERT INTO gup_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Ngurridjaldin dja ngurridjalmadbun yeledj nawu Yawey, dja yuwn bu ngurrinjilngwarremen bininj bedberre nawu kabirrikurduyime kunwarre kore kabirrikarremarnburren. ");
INSERT INTO gup_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Yuwn bu mak ngurriyiddung bedberre. Dja yuwn bu ngurrbenburrbun munguyh. Wardi kunmekbe ngurrimarnburren ngudmandeleng bu ngurriyime kunwarre. ");
INSERT INTO gup_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Kaluk birrimekbe nawu birriwarre bininj, wanjh God kabenngeydadjke. Ngudda nawu ngurridjalmadbun nawu Yawey, wanjh nungka ngunbolkwon kunbolk nuye. ");
INSERT INTO gup_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Med, dja darnkih kabolkyime wanjh nawu birriwarre bininj kabirridjalyakmen. Bu kuhni ngurrbenyawan, wanjh bonj, minj ngurrbenngalke. ");
INSERT INTO gup_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Dja bininj nawu minj kabirriburlumerren wanjh kabirribolkmang dja kabirridjalngehme, kunmodmikenh dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Bininj nawu birriwarre, wanjh kabindimarnekarremarnburren kunwarrekenh bedberre birrimak bininj, dja kabindimarneyidmebayerren. ");
INSERT INTO gup_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Dja nawu Kawohrnan Rowk kabendjaldjekme nawu birriwarre bininj. Kaluk nungka kaburrbun kore kabolkyime bu nungka kabendjadme bedberre. ");
INSERT INTO gup_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Nawu birriwarre bininj kabirrikarrme mandjawakkimuk, dja bonarra kabirrikarrme, ba bu kabindibun nawu birrimarladj dja mak nawu minj birrikuken. Bedda kabirridjare kabindibun nawu birrimak bininj. ");
INSERT INTO gup_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Dja ngaleng nawu mandjawakkimuk kabirrikarrme wanjh kabirrikangeduluburren. Dja nawu bonarra bedberre wanjh kadjalbakme rowk. ");
INSERT INTO gup_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Bininj nawu birrimak minj birrikuken, dja kamak rowk! Bininj birriwern nawu birridjalwarre, wanjh kabirrikarrme kunwern, dja wanjh kawarre! ");
INSERT INTO gup_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Nawu birriwarre bininj bedberre kundulkarre, wanjh karrulkarreyakmen rowk. Dja nawu Yawey kabenbidyikarrme nawu birrimak bininj. ");
INSERT INTO gup_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Bininj nawu minj kabirriyime kunwarre, wanjh nawu Yawey kabennahnan munguyh. Dja kabenmarnekarrme kunmakmak kore kadjehdjenyo munguyh. ");
INSERT INTO gup_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Bu kunrayek kabenmarnebebme nawu birrimak bininj, wanjh kabirridjalre kamak. Bu manme yak kore kunbolk rowk, wanjh bedda minj kabirrimarrwe, dja kabirriworrkmiworren. ");
INSERT INTO gup_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Dja nawu birriwarre bininj kabirridjalyakmen rowk. Nawu birriyidko nawu Yawey, wanjh kabirridjalyakmen yiman kayime mannguymak, dja yiman kayime kundolng kare. ");
INSERT INTO gup_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Nawu birriwarre bininj wanjh kabirridjalmang njalehnjale, dja minj kabindimarnedurndiwe bedberre nawu birrikarrmi. Dja ngaleng birrimak bininj wanjh birridjalnjilngmak bu kabirriweykan njalehnjale. ");
INSERT INTO gup_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Bininj nawu Yawey kabenmarneyime kunmak, wanjh kabirribolkmang dja kabirrihyo kore kubolkmak. Dja bininj nawu Yawey kabenwarrewan, wanjh kabenngeydadjke bedberre. ");
INSERT INTO gup_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Bininj nawu kadjare kabirridjare kabirribolhkadjung nuye Yawey, wanjh Yawey kabenbidyikarrme ba minj kabirrimankan. ");
INSERT INTO gup_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Wardi bu namak bininj kabungbarrkbun, wanjh minj kamankan kunkimukkenh. Nawu Yawey kaberlyirriyongen dja kabikarrme. ");
INSERT INTO gup_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Ngaye wanjh ngayawurrinjni, dja wanjh bolkkime ngaye ngakohbanj, dja minj ngabennayinj bininj nawu birrimak bu kunrayek kabenbularrbun, dja wurdwurd bedberre minj mak kabirriwernhmarrwedowen. ");
INSERT INTO gup_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Bedda wanjh kabirrinjilngmak bu kabindiwon njalehnjale kore birrimarladj bininj, dja nawu wurdwurd bedberre, wanjh God kabenmarneyime kunmak. ");
INSERT INTO gup_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Mah, ngurribawo kunwarre, dja ngurridjalkurduyimen bu djal kunmak. Bu kuhni ngurriyime, wanjh ngurridjalyo munguyh kore kubolkmak. ");
INSERT INTO gup_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Bu kuhnikenh, nawu Yawey kabenmarnedjare bininj nawu kabirrikurduyime bu dja mandjadkenh. Dja minj mak kabenbawon nawu nuye birrimak bininj. Nungka kabenmarnebiddjurruddi bu munguyh. Dja nawu birriwarre bininj, wanjh Yawey kabenburriwe nawu bedberre wurdwurd. ");
INSERT INTO gup_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Yawey kabenwon kunbolk bedberre nawu birridjalmak ba bu kabirridjalyo kumekbe bu munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Nawu namak bininj kawokdi bu kunmakkenh, kore God nuye kunmayali, dja bu kawokdi wanjh mandjad duninjh. ");
INSERT INTO gup_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Nungka wanjh kaburrbun God nuye mankarre kore kukange, dja kadjalre kore manbolhmak dja minj kamankan. ");
INSERT INTO gup_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Nawu birriwarre bininj kabirridjare kabindibun nawu birrimak bininj, dja kabindimarnewarlkkarren ba kabindidarrkidmang. ");
INSERT INTO gup_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Dja nawu Yawey minj kabenbawon bu kabindibun. Bu birriwarre bininj kabindidjadme, wanjh Yawey kabenbidyikarrme bininj birrimak. ");
INSERT INTO gup_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Mah, dja ngurridjalmadbun nawu Yawey, dja ngurridjalmarrkmang kore ngunbukkan. Wanjh nungka ngunngeykimukwon ba bu ngunbolkwon ngudberre kunbolk. Kaluk bu nungka kabenburriwe nawu birriwarre bininj, wanjh ngudda ngurrbennan kore kabenmarnekurduyimerran. ");
INSERT INTO gup_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ngaye ngakurdunang bininj nabang dja nawu nawarreni. Wanjh nungka wernhkimukworrinj yiman kayime kundulmak bu kadjordmen kore kundjulngmak ngalengngarre. ");
INSERT INTO gup_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Dja bonj, nungka wanjh werrkwerrk djalyakminj rowk! Ngaye ngayawam, dja larrk, yakminj, bonj. ");
INSERT INTO gup_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Ngurrbenngunjdjikka bininj nawu minj kabirriyime kunwarre, dja kabirridjalkurduyime kunmak! Bininj nawu kadjare kunmodmikenh, wanjh nakka kahre munguyh. ");
INSERT INTO gup_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Dja ngaleng bininj nawu birriwarre, wanjh kabirribularrbuyindan. Minj kabirrire munguyh. ");
INSERT INTO gup_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Nawu Yawey kabenngehke birrimak bininj, dja nungka yiman kayime kabendjurruddi bedberre munguyh, ba bu kabirridjarrkdi nuye bu kunyid kabenmarnewernmerren. ");
INSERT INTO gup_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Yawey kabenbidyikarrme dja mak kabenbebke kore birriwarre bininj kabindibongkarrme, dja mak kabenngehke munguyh. Kunmekbekenh kunu bedda wanjh kabirridjalwarlkkarren kore nungka kabennahnan. ");
INSERT INTO gup_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","O Yawey, bu yiyiddung ngardduk, wanjh yuwn bu kanbengyolyolme, dja yuwn bu mak kanwernhdung bu ngaye njilngwarrewong. ");
INSERT INTO gup_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Ngaye ngababang kore ngudda kandulubom bonarra ke dorrengh, dja kore ngudda kanwidjbihkeng wernkih duninjh. ");
INSERT INTO gup_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Ngaye ngabekkarren bu ngarrowen kanjdji kore kuburrk ngardduk, bu kuhni ngudda kandjaldung. Ngaye ngabakkabakkeng ke mankarre, dja kunu ngamurrngwarreworrinj. ");
INSERT INTO gup_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Ngaye wanjh kunwarre ngayimi, dja ngadjalburrburren munguyh bu ngaye ngadjalwarre duninjh, wanjh ngadjalkangewarre. ");
INSERT INTO gup_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Ngaye wanjh ngadjalwarre bininj dja ngabengwarrminj, wanjh kunmekbekenh ngamokwernminj, dja ngamoknudminj. ");
INSERT INTO gup_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Ngaye wanjh ngadjalnjilngwarreminj dja mak ngangudjyawarren. Ngadjalnalkkihre kundowikenh bu kunbarnangarrakuyeng. ");
INSERT INTO gup_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Mak ngawernhbabang kore kunbodme ngardduk, dja kunburrk rowk ngardduk wanjh kadjalwarrewarremen. ");
INSERT INTO gup_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Ngaye ngangudjyawarren munguyh, dja minj ngaye ngamurrngrayekworren. Kaluk ngadjalkongiburren dja ngakangewarre duninjh. ");
INSERT INTO gup_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Ngudda nawu kanmarnewohrnan, ngudda kankangenan baybaywi kore kukange ngardduk, dja yiburrbun kore njalehnjale ngaye ngadjaldjare. Ngudda kanbekkabekkan kore ngaye ngangolekwerren. ");
INSERT INTO gup_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Yoh, ngahdurddubekkarren bu wernkih kawokdi. Ngaye ngangudjyakmen, dja mak ngamimwarremen, minj ngawernhbolknan. ");
INSERT INTO gup_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Ngaye ngadjalmokwern dja djawirna ngardduk ngandidjalbawon, minj kabirrimre darnkih ngaye. Nawu namud duninjh bininj ngardduk minj kabirrimyikan kore ngaye. ");
INSERT INTO gup_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Nawu ngarriyidko bininj kabirridjare ngandibun, dja ngandimarnekunidi. Bedda ngandiyolyolme bu ngandiwarrewonkenh. Bu djal barnangarrakuyeng wanjh kabirrikarremarnburren ba bu ngandikowe. ");
INSERT INTO gup_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Ngaye yiman kayime ngabengwarr dja minj ngabekkan kunwok. Mak ngaye yiman kayime ngadjenwarreminj, dja minj ngawokdi. ");
INSERT INTO gup_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Ngaye ngayimerran yiman bininj nawu minj nangale kabiwokbekkan dja minj nangale kabiwokmang. ");
INSERT INTO gup_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Ngaye wanjh ngabengdi dja ngamaddi ngudda nawu Yawey! Kaluk ngudda kanwokmang, ngudda nawu God ngardduk bu yiwohrnawohrnan rowk. ");
INSERT INTO gup_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Dja ngaye ngayimeng, “Yuwn yibenbawon bu ngandimarneburlumerren, dja ngandidjekmiwon kore ngaye ngarrengeyirrebme.” ");
INSERT INTO gup_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Bolkkime wanjh ngaye ngabekkarren bu ngadjalyirrebme dja ngamankan. Mak ngadjaldjakbekkan munguyh. ");
INSERT INTO gup_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Wanjh ngawarnyakmulewarren kore ngaye kunwarrekenh ngayimi. Ngaye wanjh ngawernhkangewarreworren kunwarrekenh ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Ngabenkarrme birriwern nawu ngarriyidko, dja bedda birringudjbang warridj. Mak nawu ngandiwirrihme bu djal burudjang, wanjh birridjalwern. ");
INSERT INTO gup_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Bininj nawu ngaye kunmak ngabenmarnekurduyime, wanjh kabirriborledme dja ngandiwarrewon, mak bu ngaye kunmak ngakurduyime, wanjh bedda ngandiwirrihme. ");
INSERT INTO gup_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Yawey, yuwn bu kandjalbawon. Yuwn bu mak djarreh yire, ngudda nawu God ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Yimray werrkwerrk ba kanbidyikarrmen, ngudda nawu kanmarnewohrnan dja nawu kanngehke. ");
INSERT INTO gup_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Ngaye ngayimerrinj kanjdji baybaywi ngardduk, “Ngaye ngadjalnahnarren, dja minj ngabaworren bu ngawokdi kunwok kunwarre. Ngaye yiman ngarrangdukkarren bu ngarridjarrkdi kore nawu birriwarre bininj.” Kuhni ngayimi kore baybaywi. ");
INSERT INTO gup_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Wanjh ngadjaldi wokyak, dja minj njale ngayimeninj. Minj ngawokdiwirrinj, yibeng kunwok kunwarre, dja kunwok kunmak. Larrk. Dja bonj, ngadjalnjilngwarreminj. ");
INSERT INTO gup_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Kaluk ngakangewurlhmeng. Ngaburrbuni, dja wanjh ngarruy. Wanjh ngawokdanginj kundjen ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Ngayimeng, “Ngudda nawu Yawey, ngadjare kanbukkan kore baleh kabolkyime bu ngaye ngayakmen ngarrowen. Ngaye baleh kayime mandjewk ngardduk? Kanbukkan ba bu ngawernhburrbun bu ngad bininj wanjh woybukkih minj kunkuyeng ngarridjaldarrkiddi. ");
INSERT INTO gup_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Ngudda kanmarnbom ngaye yiman yeng. Ngarranginj, dja werrkwerrk ngayakmen. Ngudda yibenwon bininj rowk kunngolek ngudda ke, dja wanjh bonj, kabirringolekyakmen ba kabirridarrkid bu djal kundedjumbung. ");
INSERT INTO gup_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Ngad nawu bininj, wanjh yiman kunwoyik. Ngarrirengehre balehbaleh, dja bu djal burudjang. Ngarrimang njalenjale, dja ngarriburrbun kaluk ngarrbenmarnebawon dja birringale kabirrimang?” ");
INSERT INTO gup_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","“Ngudda nawu Kanmarnewohrnan, ngaye bolkkime ngayawarren. Dja bonj, ngaye ngadjalkangekurrmerren kore ngudda, dja djalmadbun munguyh. ");
INSERT INTO gup_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Kanngehkemen kore ngaye kunwarre, dja ngakurduyimi kunwarre kunwern bu ngaye ngawarreworrinj. Yuwn kanbawon bu nawu birribengwarr bininj ngandidjekmiwon. ");
INSERT INTO gup_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Ngaye minj njale ngawokdi, dja minj ngamulewarremeninj. Dja ngudda yingan kankurrmeng kore ngahdi bolkkime kunyid dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Ngadjare ngudda yingurdmen kore kandung, dja yiman kunbid ke kanwidjbihkeng dja darnkih ngarrowen! ");
INSERT INTO gup_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Ngudda kandung ngad bininj rowk, dja kanbun kore kunwarrekenh ngadberre. Kaluk yibenmarneburriwe njalehnjale namakmak bedberre nawu birrikuken. Bininj rowk wanjh yiman kayime kayakmen werrkwerrk yiman kunngolek kadjalyakmen.” ");
INSERT INTO gup_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","“O Yawey, kanbekka bu ngahdi yiwarrudj ke. Kanwokbekka bu ngaye djawan bu kanbidyikarrme. Ngaye nganalkbun, dja yuwn bu kanmarneborledkerren. Ngaye wanjh djarrehbeh ngamwam kore ngudda, ngaye yiman ngadjenbuyika, yiman mawahmawah ngardduk warridj. ");
INSERT INTO gup_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Yuwn bu kanwernhnan, ba ngayawoyhmarrmarr. Kaluk darnkih ngarrowen dja ngadjalyakmen, bonj.” ");
INSERT INTO gup_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Ngaye ngahdjaldi bu ngahdjalmadbuni nawu Yawey. Wanjh nungka nganburrbom dja ngankayhmibekkang. ");
INSERT INTO gup_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Nungka nganbebkeng kore kanjdji kudjorlok ngabongdi bu darnkih ngarroweng. Nungka nganbebkeng kore kukih bu ngayibmeninj dja kankurrmeng kore kubolkrayek ba bu ngarey kamak rowk. ");
INSERT INTO gup_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Dja mak nganwong mankong mankerrnge dja ngawayini bu ngaburlume nawu God kadberre. Mak birriwern bininj kuhni kabirrikurdunan, wanjh bedda kabirriburlume dja kabirrikangekurrmerren kore nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Bininj nawu kabirriwoybukwon Yawey wanjh bedda kabirriwernhnjilngmak. Bedda minj kabindiwoybukwon bininj nawu kabirriburlumerren dja kabirrimarneboddan nawu nabubuyika gods. ");
INSERT INTO gup_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Ngudda Yawey nawu ngardduk God, ngudda yikurduyimeng kunwern bu yihdurrkmirri kundulkarre kunkimuk dorrengh ngadberre. Ngudda kanmarneyingkihkarremarnbom bu kunwern! Minj nangale nabuyika god yiman ngudda. Minj nangale bininj ngunmayaliburrbun, dja minj nangale kawernhburrbun rowk kore ngudda yikurduyime kundulkarre ke. Dja kundjalwern duninjh. ");
INSERT INTO gup_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Ngaye bolkkime ngawohburrbun bu ngudda minj yidjare ngad bu ngundiwon dja ngundimarnekinje mayh ba bu ngarridi yiwarrudj. Ngudda wanjh kanbukkabukkang ba bu ngaye ngaborlhmeng bu ngudda minj yidjare bu manbubuyika woyi kore kunwarrekenh ngardduk bu ngaye marnekurrmeninj. ");
INSERT INTO gup_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Wanjh ngaye ngayimeng, “Yina! Ngaye ngamwam kore djurra kabimbuyindi bu nganyolyolme. Kuhni wanjh kayime: ");
INSERT INTO gup_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","‘Ngaye ngawernhnjilngmak bu ngakurduyime kore ngudda yidjare, ngudda nawu God ngardduk. Manbu mankarre ke ngudda kanbukkang dja yiman kahbimbuyindi rowk kore kukange ngardduk.’ ” ");
INSERT INTO gup_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","“Wanjh ngayolyolme bedberre bininj ngudda ke kore ngarrimirnderri. Ngaye wanjh mulewam bedberre kumekbe bu ngudda kanngehke ngadberre. Maninjmanu kunwok ngannjilngmarnbom dja ngarrinjilngmakminj. Ngudda Yawey yiburrbun bu ngaye minj ngawokngurdkerrimeninj, dja bonj, ngaye djalmulewan. ");
INSERT INTO gup_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Ngaye minj ngawarlkkayinj manbu kunwok kunmak nguddakenh kore kukange ngardduk. Ngaye ngabenmarneyime birridjalwern bininj nawu ngarrimirndemornnamerrinj bu ngudda kanmarnebengmidjdan ngadberre kunwarre, dja mak kanngehke. Ngudda wanjh kandjalmarnedjare dja minj kanbawon bu munguyh munguyh. Kuhni rowk wanjh ngaye ngayolyolmeng bedberre bininj. Ngaye minj ngabenmarnewarlkkayi maninjmanu kunwok nguddakenh.” ");
INSERT INTO gup_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","“Ngudda nawu Yawey, kandjalkongibu kore ngudda kandjalmarnedjare, dja yuwn bu kanbawon. Ngudda wanjh kanmarnedjare dja mak yidjalkurduyime kore yiwokkurrmerrinj, wanjh kunmekbekenh ngaye ngadjalngehme. ");
INSERT INTO gup_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Bolkkime manbu kakangeyid makka nganmarnewernmerren ngardduk. Dja ngardduk kunwarre wanjh djalwernmerrinj, dja ngannjilngwarrewong, yiman kayime ngangarrnghmang, dja minj mak ngayawoyhbolknan. Ngaye ngadjalkangebarrhme dja ngadjaldowe.” ");
INSERT INTO gup_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","“O Yawey, ngaye manjbun bu kanngehkemen, dja kanbidyikarrmen werrkwerrk ngudda nawu Yawey. ");
INSERT INTO gup_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Dja bininj nawu kabirridjare ngandibun, wanjh yibenmarnbu bu kabirriyemingalme dja kabirridjalbarabun. Dja nawu kabirridjare ngandinjlingwarrewon, wanjh yibenmunkewemen ba kabirrikelerlobmerren kunyemi dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Yikahwi bininj ngandiborrkbun bu ngandidjekmiwon, wanjh ngadjare yibenngurdkemen kunyemi dorrengh.” ");
INSERT INTO gup_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","“Dja bininj nawu ngudda ngundiyawayawan nakka wanjh yibenmarnbu bu kabirriwernhnjilngmak. Dja bininj nawu ngundimarnedjare, bedda nawu ngudda yibenngehkeng, wanjh wardi birrihdjalyimen munguyh, ‘Nawu Yawey wanjh Nadjalwernhkimuk Duninjh!’ ");
INSERT INTO gup_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Dja ngaye wanjh ngamarladj dja ngadjalyawarren. Dja ngudda nawu God ngardduk, ngudda yiwohrnawohrnan rowk, dja bonj, ngudda kanburrbun! Ngudda yidjalkudji nawu kanbidyikarrme dja ngardduk nawu kanngehke. Mah, werrkwerrk kanngehkemen!” ");
INSERT INTO gup_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Bininj nawu kabenkongibun nawu birrimarladj bininj, nakka wanjh kadjalnjilngmak. Dja nawu Yawey kabibingehke namekbe bininj bu kunrayek kawernmerren nuye. ");
INSERT INTO gup_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Nawu Yawey kabinahnan dja kabimarnbun ba bu nungka kadjaldarrkid dja minj karrowen. Birribuyika bininj kabirriyime bu Yawey kabimarnekurduyime namekbe bininj. Yawey minj kabibawon bu nawu birriyidko bininj kabirrimarnebebme. ");
INSERT INTO gup_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Yawey kabimarnbun namekbe bininj bu darnkih karrowen dja nungka kamakmen dja kadjalyo kamak rowk. ");
INSERT INTO gup_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Ngaye wanjh ngadjaldi yiwarrudj, bu ngayimeng, “Yawey, kankongibu! Ngaye ngabakkeng ke mankarre wanjh kandjalmarnbu ngardduk!” ");
INSERT INTO gup_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Nawu ngarriyidko bininj wanjh kabirridjawarren bu kunwarrekenh ngandimarneyime, “Adju, dja baleh kabolkyime bu nahninjanu bininj karrowen, dja mak kunngey nuye kangeyyakmen?” ");
INSERT INTO gup_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Bu bininj nawu nganeyidko kamre bu nganewokdi, wanjh kadjalkurren. Nungka kadjare ngankowe, dja bu nganbawon wanjh kabalrengehre bu ngandiyolyolme kore kurobbe. ");
INSERT INTO gup_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Birriwern bininj nawu ngandiwirrihme wanjh kabirringayawkworren ngayekenh. Bedda kabirridjare kunrayek duninjh nganmarnebebme. ");
INSERT INTO gup_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Bedda kabirriyime, “A! Nakka karrowen. Kundjak kunkimuk kabimang, dja minj kayawoyhdolkkan kore kahkeyo!” ");
INSERT INTO gup_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Dja nakudji bininj nawu djawirna duninjh ngardduk, nahni warridj nganbawong. Ngaye ngakangekurrmeng, dja nganedjarrknguni manme. Bonj, nungka wanjh bolkkime ngandjalwirrihmeng. ");
INSERT INTO gup_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Ngudda nawu Yawey kankongibu! Kandolkkayhwemen ba ngabenbun bininj nawu ngandiwirrihme. ");
INSERT INTO gup_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Bu bedda minj ngandibun, wanjh ngaye ngawernhburrbun bu ngudda kanmarnenjilngmak. ");
INSERT INTO gup_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ngaye minj kunwarre ngayimeninj, dja ngudda kunmekbekenh kanbidyikarrmeng dja kankurrmeng bu ngahdjaldi kore kumirrk ke bu munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Mah! Karriburluburlumen Yawey, nawu God kadberre bininj nawu Israel kankebmawahmeng. Karridjalburlume bu djal munguyh munguyh. Amen, dja Amen! ");
INSERT INTO gup_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Nawu mayh deer nakka kakombukdowen dja kadjare kukku kabongun. Wanjh kunmekbe rerrih karohrok ngaye ngadjare ngudda nawu God ngardduk! ");
INSERT INTO gup_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Ngaye ngamarnedjare God nawu kahdarrkid! Ngadjare ngarrarnhkurrmerren duninjh kore nungka. Dja baleh kabolkyime bu ngare nungka nganenarren kore kumirrk nuye? ");
INSERT INTO gup_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Ngaye ngadjalnalkbun bu barnangarra rowk dja mak kumununwern, dja minj mak ngangun manme. Mak bu barnangarrakuyeng bininj nawu ngandiwidnan wanjh ngandimarneyime, “Ngayh! Baleh nawu God ngudda ke?” ");
INSERT INTO gup_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Bu ngawernhnjilngwarre wanjh ngakangemulewarren kore God, dja kuhni yarrkka ngaburrbun kore kunrayek kumbebmi ngardduk. Mak ngaburrbun bu birribuyika bininj ngarrihdjarrkrey kore God nuye Temple bu ngarriwayini dja ngarriburlumi dorrengh. Kaluk ngabenmarnedokmi bu ngarrimirndebidbuni ngarriwernhnjilngmak dorrengh kore mulil ngarrimarnemarnbuni nuye! ");
INSERT INTO gup_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Dja njalekenh ngaye nganjilngwarre dja ngakangewarre bolkkime? Wanjh ngadjalkangekurrmerren kore God ba ngayawoyhburlume nungka nawu nganngehke dja God ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","O God ngardduk! Ngaye woybukkih ngadjalnjilngwarre kore kanjdji kukange ngardduk. Dja bonj, ngaye ngaburrbun bu ngudda yikurduyimeng kunkimuk, kore Jordan Mankabo karredjingmangbeh, kaluk darnkih kuwarddehwardde manbu kawarddengeyyo Hermon dja Mizar. ");
INSERT INTO gup_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Kunrayek munguyh durndiwerreni ngardduk, yiman kayime kukku manbu kabowarrhme kaddumbeh wanjh nganbuni, dja kore ngudda ke kurrula wanjh yiman kanbarrkbom. ");
INSERT INTO gup_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Dja ngaleng wanjh kunbarnangarrawern nawu Yawey ngandjalmarnedjare bu munguyh. Dja bu kumunun rowk, wanjh ngamarnewayini nuye, mak ngarri yiwarrudj nuye God nawu kanmalngmimbiwon. ");
INSERT INTO gup_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Wanjh ngamarneyime God nawu yiman kunwarddekimuk ngardduk, “Njalekenh ngudda kanbengmidjdanj? Mak njalekenh bu ngahdjalrengehre kunnjilngwarre dorrengh kore nawu ngarriyidko ngandihdjaldungi? ");
INSERT INTO gup_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Birrimekbe nawu ngarriyidko bininj wanjh ngandimarnbun bu ngadjakbekkan duninjh, dja munguyh ngandimarnedjekme dja ngandimarneyime, ‘Baleh nawu God ngudda ke?’” ");
INSERT INTO gup_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Wanjh njalekenh bu ngahnjilngwarre dja mak ngakangewarre duninjh? Bonj! Wanjh ngakangekurrmerren kore God dja ngayawoyhburlume munguyh God ngardduk nawu nganngehke. ");
INSERT INTO gup_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","O God, kanmulewa dja kanmakwan ngaye. Bininj nawu ngundiwirrihme ngudda dja bedda kabirridjare ngandiwowarrewon, dja ngadjare ngudda yibenbengdayhke bu ngaye minj kunwarre ngayimeninj. O God kanngehkemen kore birriwarre bininj nawu ngandimarnekurren. ");
INSERT INTO gup_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Ngudda korroko kannahnani, dja bolkkime njalekenh kanbawong? Njalekenh yibenbawon nawu ngarriyidko bininj bu ngandiwirrihme dja ngandimarnekurduyime kunwarre ba bu ngadjalrengehre kunnjilngwarre dorrengh? ");
INSERT INTO gup_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Mah, ngudda kanmarnebolkwolka dja mak kanbukkabukkan kunwoybuk ke, ba bu kandurndiwe kore ngudda ke kuwarddekimuk kubolkdjamun ke, dja kore ngudda yiyo. ");
INSERT INTO gup_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Ngudda nawu God, bu kuhni kanmarnekurduyime, wanjh ngaye ngare kore altar ngudda ke, dja ngakinje mayh bu won kore yidjare. Ngudda kannjilngmarnbun wernkih duninjh bu munguyh, dja wanjh ngaye ngahdirri kore nawu harp dja ngawayini bu ngaye burlumburlume ngudda God, nawu God ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Adju? Njalekenh ngaye ngahnjilngwarre, dja mak ngakangewarre? Ngaye wanjh ngamarnburren bu ngadjalwoybukwon nawu God, dja ngayawoyhburlume nungka nawu God ngardduk. Nungka nawu nganngehkeng. ");
INSERT INTO gup_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","O God, ngarriburrbun bu nawu mawahmawah ngadberre ngundikurdunang korroko bu ngudda ngurrikurduyimi kundulkarre ke dorrengh. Ngad ngarrbenbekkabekkang bu ngundimulewam nguddakenh. ");
INSERT INTO gup_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Bedda birriyolyolmi kore ngudda yibenburriweng birribuyika bininj kubid ke, dja yibenkurrmeng mawahmawah ngadberre bu yibenbolkwong. Dja yibenkukberelhmeng nawu birribuyika bininj dja yibenbebkeng ngadberre mawahmawah kore birribongdi. ");
INSERT INTO gup_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Minj bedmandeleng bu birriwinhmeng dja bindiburriweng birribuyika bininj bu birridjalmey bedberre kunbolk. Nawu mawahmawah ngadberre minj birringudjbangniwirrinj kore bindibuni. Kaluk yingan yibenbidyikarrmeng kundulkarre ke dorrengh, dja kore yibenmarnebukkarrinj bu woybukkih yibendjalmarnedjareni. ");
INSERT INTO gup_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ngudda God, wanjh king duninjh ngardduk dja kanmarnewohrnan. Ngudda kanmarnbun ngad bininj nawu Jacob ngankebmawahmeng bu karringehme yerrekah bu ngarriburren. ");
INSERT INTO gup_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ngudda wanjh kanbidyikarrme bu ngarrbendurndiwe nawu ngandiwidnan bininj. Ngad ngarrbenbun nawu ngarriyidko kore ngudda ke kunngey. ");
INSERT INTO gup_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Ngaye minj ngaburlumerren bu ngakarrme ngardduk bunarra dja mandjawak. Minj nakka nganbidyikarrme kore ngarriburren. ");
INSERT INTO gup_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Ngudda God wanjh yidjalkudji kanngehkeng kore ngarriburrinj nawu ngarriyidko bininj. Ngudda yibenmarnbom bu kabirriyemengalme bininj nawu ngandiwirrihmeng. ");
INSERT INTO gup_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Yoh, ngad wanjh ngundiburluburlume ngudda God bu kunbarnangarra rowk. Ngad wanjh ngundingeyburlume ngudda bu ngundimanjbun munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Dja med, bolkkime wanjh njalekenh ngudda kanwarnyakminj dja kanyemikang ngadberre? Dja njalekenh ngudda minj mak karridjarrkkunireyi kore ngarriburreni? ");
INSERT INTO gup_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ngudda kanmarnbom bu ngarrikelerlobmerrinj bu ngarrbenkengemeng nawu ngandibuni. Nawu ngandiwirrihme bininj wanjh ngandimarnemey njalehnjale nawu ngadberreni. ");
INSERT INTO gup_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Ngudda kanbawong kore birriwarre bininj ngandibuni yiman sheep, dja ngad wanjh ngarrikeleyarlarrmerrinj kore kunred bedberre birribubuyika bininj. ");
INSERT INTO gup_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Ngudda yiman kayime kankukweykang ngad nawu bininj ke, dja birribuyika bininj ngandibalkukbayahmi bu ngundikarremulewan yiman nadjalyahwurd money. Bu djal burudjang ngudda kankukweykang! ");
INSERT INTO gup_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Nawu ngarridarnhni bininj ngandinang kore baleh yikurduyimeng ngadberre dja bolkkime wanjh ngandiyolyolme dja mak ngandidjekmiwon. ");
INSERT INTO gup_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Ngudda wanjh kanmarnbom ngadberre bu birriwern nawu birridjenbubuyika bininj kabirrikodjbordebme ngadberre dja warridj ngandiyolyolme. ");
INSERT INTO gup_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Dja kunu ngaye wanjh ngadjalyemengalme kunbarnangarrakuyeng dja kunyemi nganmey. Ngadjalbolknan kanjdji kunyemi dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Ngabenbekkan birriwern nawu ngandiwiddjung dja ngandidarrkidyolyolme. Nawu nganeyidko nakka wanjh munguyh kadjare nganbun. ");
INSERT INTO gup_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Dja njalekenh kuhni kurduyimerranj ngadberre? Ngad minj ngundibengmidjdangimeninj mak ngarribakkemeninj mankarre ke kore kanmarnewokkurrmerrinj ngadberre. ");
INSERT INTO gup_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Ngad minj ngundibawoyi kore kukange ngadberre, dja mak minj ngarribolhbawoyi ngudda ke manbolh. ");
INSERT INTO gup_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Dja bonj, ngudda wanjh kanwarrewam ngadberre dja ngarridjalngudjyawarren kore kubolkwarre. Warridj kankurrmeng kore kunkak duninjh manbu kundowikenh kanbarrkbom. ");
INSERT INTO gup_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Dja njalekenh? Minj ngundingeybengmidjdangimeninj ke kunngey, ngudda nawu God ngadberre. Mak minj ngarriboddangimeninj nabuyika god nawu birridjenbuyika bedberre. ");
INSERT INTO gup_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Ngudda kanmayaliburrbun ngadberre nawu bininj ngarriwarlahkenh, dja minj njale kawarlkkayindan ke. Yoh, ngudda kankangeburrbun! ");
INSERT INTO gup_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Dja bonj, ngudda kanbawon kore bininj kandidjaldung ngadberre bu nguddakenh kunbarnangarrakuyeng. Bedda kabirriyime ngad yiman mayh nawu sheep bu kandidjalbun munguyh. ");
INSERT INTO gup_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Ngudda nawu Yiwohrnan Rowk! Njalekenh ngudda yidjalkeyo? Mah, yirrolkka! Yuwn bu munguyh kandjalbodmewon. ");
INSERT INTO gup_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Njalekenh kanmarnewarlkkarren ngadberre? Yuwn bu yibengmidjdan bu ngad ngarrihdjakbekkan dja kunrayek duninjh bebmeng ngadberre! ");
INSERT INTO gup_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Yoh, woybukkih ngad ngarridjalmankang kurorre kore ngarridjalngudjyakminj, yiman ngarrikukyo kore kundjulng. ");
INSERT INTO gup_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Mah! Ngudda nawu kanmarnedjare munguyh ngadberre, wanjh kunmekbekenh yimray kandjalbebkemen ngadberre! ");
INSERT INTO gup_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Mah. Ngakarrme kunwok kunmakkayhkenh kore kukange ngardduk. Wanjh kunmekbekenh ngawokdi bu ngaye ngayolyolme nawu king. Manbu kundjen ngardduk, nakka yiman pen rerrih bu bininj kabimbun nawu kawernhburrbun. Wanjh kuhni ngayime: ");
INSERT INTO gup_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ngudda king ngardduk, wanjh ngudda yiwernhkukmak bu yibenyurrhkeng nawu birribuyika bininj. Nawu God ngunmarnekurduyimeng kunmak munguyh munguyh, dja kunmekbekenh ngudda yidjalwokdi kunwok manbu kunmakkenh. ");
INSERT INTO gup_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Ngudda nawu yirrulkarrekimukenh! Mah, yikanahkan mandjawakkimuk ke. Ngudda yiman yidjongburrimen namakmak yiman king duninjh ba bu bininj rowk ngundiburluburlume. ");
INSERT INTO gup_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ngudda king duninjh bu yimornenin djarrang dja yiwinhme kore ngurriburren. Ngudda wanjh yiwinhme kore kunwoybukkenh dja kunmakkenh,dja kore yidjadmen bu djal mandjad. Dja ngaleng ngudda minj yingan yiburlumerren. Mah, yidjalkurdumak bu yibenbun nawu birriwarre bininj kunbidkukun dorrengh ke. ");
INSERT INTO gup_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Ngudda nawu king, wanjh manbu bunarra ke kabendulubun kundurddu bedberre bininj nawu ngurriyidko. Bininj nawu kunredbubuyikabeh nakka wanjh kabirrimankarren kore yibenkukmelme rowk. ");
INSERT INTO gup_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Ngudda God wanjh king duninjh, dja yidjalwohrnawohrnan rowk bu munguyh. Ngudda wanjh munguyh yidjaldjadme bu kamak rowk kore ngudda yibenmarnewohrnan bininj. ");
INSERT INTO gup_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ngudda yidjare kore djal kunmakkenh, dja yidjalwidnan kore kunwarre, wanjh kunmekbekenh God ngudda ke ngundjarrngbom kore nawu ngurridabbolk yibenyurrhkeng, dja ngunnjilngmarnbom yiman kayime ngunkodjdelkkeng mankalkkid dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Manbu kunmadj ke yidjongbuyindi nakka kamadjbanj nawu manmanjmak manbu myrrh, dja mak manbu aloes, dja mak manbu cassia. Ngudda king duninjh, dja kore manbu manrurrkkimuk ke, wanjh bininj kabirridirri instruments ke ba ngundinjilngmarnbun. ");
INSERT INTO gup_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Nawu ngalbebeywurd nuye nawern kings, nakka wanjh kabirrihdi kumekbe kabirriraworren birribuyika daluk nawu ngudda yibenkukenhme. Dja kore kukun ke kahdi ngalbininjkobeng ke, ngalbu kadjongbuyindi kunmadj manbu birribibbom gold duninjh nawu kubolkkimuk Ophirbeh. ");
INSERT INTO gup_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Ngudda nawu ngalbininjkobeng bu nahni king duninjh ngunmarnedjareminj, wanjh kanbekkabekka dja yiwernhburrbu kore marneyime. Yibendjalbengmidjda nawu namud ke bininj, dja nawu kornkumo nuye birriredbo, dja yibendjalbawo. ");
INSERT INTO gup_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Bolkkime wanjh nawu king ngunkuknan dja kunmekbekenh ngunmarnedjare dja kayimerran nawu ngunmarnewohrnan. Wanjh nungka yimarnebodda. ");
INSERT INTO gup_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Birrikuken daluk ngalbu birrimdolkkang kukadje Tyre birrimkang ke nawern namakmak bu ngundiwon. Mak nawu birrikuken bininj kabirridjare ngundidjawan bu yibenmarnekurduyime kunmak bedberre. ");
INSERT INTO gup_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Ngalkukmakkaykenh duninjh ngalbu princess dja birribibbom gold warridj nawu ngalengngarre kahdjongbuyindi. ");
INSERT INTO gup_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ngudda nawu king, yina! Ngahli daluk nawu ngunemarren kamre. Kahdjongbuyindi kunmadj namakkaykenh. Ngahli wanjh kabirrimkan kore ngudda. Dja mak ngalbu ngalyawkyawk ngalengngarre kabirrimunkekadjung, dja wanjh kabirrimre. ");
INSERT INTO gup_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Bu kabirribebme dja kabirringimen kore manrurrkmak ke, bedda wanjh kabirriwernhnjilngmak dja kabirrimarrmarr duninjh bu kabirrimirndengimen. ");
INSERT INTO gup_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Nawu mawahmawah ngudberre kaluk bu kabirriyakmen, wanjh ngudda yibenmarnbun nawu bebeywurd ke ba kabirriwohrnawohrnan kubolkbubuyika rowk kore kurorre. ");
INSERT INTO gup_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Wanjh ngamarnbun kunngey ke bu bininj rowk ngurriyime ngudda yingeykimuk duninjh, dja minj mak ngundingeybengmidjdan munguyh munguyh kore kubolkbubuyika rowk. Wanjh birriwarlahkenh bininj rowk ngundiburlume bu munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","God nungka kannahnan bu karrikelerlobme kore nungka. Mak kunngudj kanwon kadberre. Nungka karrihdjarrkdi bu baleh yarrkka kunrayek dja kunyid kambebme kadberre, wanjh nungka kanbidyikarrme. ");
INSERT INTO gup_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Kunmekbekenh kunu minj karrikele. Bu kondah kunred kabolkdjalkmire dja wardi manbu kunwarddekimuk makka kawarddewarrawarrhmerren kore kurrula kanjdji, bonj, ngad nakka minj karrikele. ");
INSERT INTO gup_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Manbu kurrula kawernhwokdi dja djarna kabun, mak manbu kunwarddekihkimuk makka wanjh kawodjorrhmiyindan. Dja ngad minj mak kumekbe karrikele. ");
INSERT INTO gup_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Mankudji mankabo manbu kamkan kunnjilngmak kore kukadje nuye God. Kunmekbe kore kubolkdjamun nuye God kahni, nungka nadjalkimuk duninjh nawu kawohrnan rowk. ");
INSERT INTO gup_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Nungka kumekbe kukadje kahni wanjh minj kabolkwodjorrhmiyindan. Nungka kabibidyikarrme bu kamhkabel djarreh. ");
INSERT INTO gup_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Kunredbubuyika kunukka yarrkka, nakka kabolkwodjorrhmiyindan. Nawu kabirriwohrnawohrnan kabirrimarrkbaworren. Bu God karrarrarrhme wanjh kabolkmarnbun kurorre bu kabolkkelkdan dja kayimerran yiman kukku. ");
INSERT INTO gup_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yawey nawu kabenkarrme birridjalmirndewern duninjh soldiers nuye, wanjh nakka karrihdjarrkdi. Nungka wanjh God nuye Jacob wanjh kandjurruddi kadberre dja kannahnan. ");
INSERT INTO gup_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Mah, wanjh ngurrimray dja ngurrina nawu Yawey kore nungka kurduyimeng bu bolkbularrbom kubolkwern kondah kurorre. ");
INSERT INTO gup_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Nungka kanbengurdke wars bu bininj kabirriburren kondah kubolkwarlahkenh kurorre. Dja kabenmarnebakke bedberre mankole dja bunarra dja manbu kunbid birrikarrmi bu birriburrenikenh, wanjh kadjalburriwe kore kunak. ");
INSERT INTO gup_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Wanjh nungka kayime, “Ngurringurdmen dja ngurriburrbu bu ngaye God. Ngudda bininj rowk wanjh kaluk kandingeyburluburlume kore kubolkbubuyika rowk, dja kandingeyburlume kondah kurorre.” ");
INSERT INTO gup_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yawey nawu kabenkarrme birridjalmirndewern duninjh soldiers nuye, wanjh nakka karrihdjarrkdi. Nungka wanjh God nuye Jacob wanjh kandjurruddi kadberre dja kannahnan. ");
INSERT INTO gup_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Mah, wanjh karribiddowkmen kunnjilngmak dorrengh, ngad nawu karriwarlahkenh bininj rowk! Mak karrimarnekayhmen nawu God bu karriwernhnjilngmak! ");
INSERT INTO gup_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Bininj rowk birrimarnekelenin nawu Yawey, nawu Nawernhkimuk Duninjh! Nungka wanjh king nakihkimuk duninjh, dja kahdjalwohrnawohrnan kore kubolkwarlahkenh rowk. ");
INSERT INTO gup_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Nungka kanwong kundulkarre nuye bu karriwinhmeng dja mak kanmarnbom bu karrbenmarnewohrnan bedberre nawu birridjenbubuyika bininj. ");
INSERT INTO gup_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Dja bolkdjarrngbom kunred kore kanbolkwong kadberre, bu karrihni kunmak dorrengh, ngad bininj nawu mawahmawah nuye Jacob nawu God bimarnedjareni. ");
INSERT INTO gup_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Yawey nawu God bidbom kaddum. Wanjh birriwern kabirrikaykayhme nuye kunnjilngmak dorrengh, dja yikahwi mak kabirribuhbuhme wernkih duninjh kore trumpets. ");
INSERT INTO gup_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Mah, wanjh karrimarnewayinin nawu God! Karridjalburluburlumen nawu king kadberre! Karriwernhwayinin kore nungka. ");
INSERT INTO gup_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Nungka wanjh king duninjh nawu kawohrnan kore kubolkwarlahkenh rowk kondah kurorre. Karriburluburlumen nuye, mankong dorrengh wanjh karriwayinin kore nungka. ");
INSERT INTO gup_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","God kahyerrkan manbu throne nuye kore kawohrnankenh. Nungka wanjh kabenmarnewohrnan birriwarlahkenh bininj kore kubolkbubuyika rowk. ");
INSERT INTO gup_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Bu kunkare God biyingkihberrebbom Abraham, dja bolkkime birriwern bininj nawu kabirringeykimuk kabirrimre kore kubolkbubuyikabeh dja kabirrimirndemornnamerren Abraham nuye bininj dorrengh. Nawu God kabenmarnewohrnan birridjalwern kings nawu kabirriwohrnawohrnan kore kubolkbubuyika rowk. Nungka wanjh nangeywernhkimuk duninjh. ");
INSERT INTO gup_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Karriburluburlumen nawu Yawey. Nungka wanjh nawernhkimuk duninjh, dja kamak bu karriburlume munguyh. Nungka wanjh God kadberre, dja kahdi kore nuye kunredkimuk, kurrurrkmirnderri kore kuwarddekimuk kabolkngeyyo Zion, manbu kubolkdjamun nuye. ");
INSERT INTO gup_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Maninjmanu kuwarddekimuk Zion wanjh kubolkmakkaykenh, dja kunwarddekihkimuk duninjh. Birriwarlahkenh bininj kabirrimarrmarr bu kabirribolkburrbun dja God nawu king nawernhkimuk duninjh kahyo kumekbe. ");
INSERT INTO gup_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","God kahyo kunmekbe bu bininj kabenngehke, warridj nungka kabenmarnedjurruddi nawu bininj nuye ba bu kamak rowk kabirrihni. ");
INSERT INTO gup_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Nawu kings birriwern birrimornnamerrinj bu yimankek kabirrirurrkbakke kore Zion. ");
INSERT INTO gup_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Dja kaluk bu birribolknang, wanjh birrikangebarrhmeng, dja birrikeleminj duninjh, wanjh birrikelerlobmerrinj. ");
INSERT INTO gup_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Bedda birrikukdeldelmeng duninjh, dja kundjak benkarrmeng yiman kayime daluk ngalbu kadjakbekkan kore darnkih kayawmang. ");
INSERT INTO gup_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Dja ngudda nawu God yibenbularrbom yiman kayime kunmayorrkkimuk bu kamre koyekbeh dja kahdjerrknadjerrkname nawern kabbala nawu Tarshishbeh. ");
INSERT INTO gup_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Ngad ngarriwobekkang kore God kurduyimeng, dja wanjh bolkkime ngarrinang kore kunred kururrkwern nuye Yawey nawu Narrulkarrekimuk Duninjh, nawu God kadberre. God wanjh kabolknahnan kumekbe munguyh munguyh ba bu kamak rowk. ");
INSERT INTO gup_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","O God, ngad ngarridi kore manrurrkdjamun manbu Temple ke, dja kumekbe ngarridjalburrbun bu ngudda kanmarnedjare munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Nawu bininj nawarlahkenh kondah kurorre ngundingeyburlume dja wanjh ngundiburluburlume kore djarreh kubolkbubuyika rowk. Ngudda yikurduyime djal kunmakkenh kunbidkukunwi ke. ");
INSERT INTO gup_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Kunmekbekenh kunu bininj nawu birrikang kuwarddekimuk Zion wanjh kabirrimarrmarr kore ngudda. Warridj ngudda God wanjh yidjaddjadme kundjalmak dorrengh, wanjh bininj nawu Judah benkebmawahmeng ngundimarnenjilngmakmen kore kabirriyo kuredbubuyika bedberre. ");
INSERT INTO gup_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Kandibekka ngudda bininj rowk kumekbe. Mah, wanjh ngurridjalrengehray kore kunred Zion. Ngurrirengehre dja ngurrirohrokmen kururrkkimuk ngarre. ");
INSERT INTO gup_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Mak ngurribolkna kore kawarnamhyo mankimuk dja mandjalmurrngrayek manbu kabolkwakbuyingun ngarre. Mak ngurrina rowk, kaluk yerrekah ngurribolkmulewan bu ngurrbenmarneyime nawu mawahmawah ngudberre. ");
INSERT INTO gup_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Kaluk ngurrbenmarneyimen, “Namekbe God, wanjh God kadberre munguyh munguyh. Nungka wanjh kandjalkan munguyh munguyh.” ");
INSERT INTO gup_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Kuhni ngurribekka ngudda ngurriwarlahkenh bininj rowk nawu kubolkbubuyika rowk ngurrihni. Kandibekka ngurridjalwern bininj rowk kore kondah kurorre ngurrihni. ");
INSERT INTO gup_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Kandibekka nawu ngurridjalyeng dja mak nawu ngurriwohrnawohrnan. Kandibekka nawu ngurrikuken bininj, warridj nawu ngurrimarladj. ");
INSERT INTO gup_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Ngaye won ngudberre kunwok manbu mayalimak. Kore kukangebeh ngardduk ngayime ba bu ngudda wanjh ngurrimayalibayhme. ");
INSERT INTO gup_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ngaye wanjh ngabenbekkabekkan bu bininj kabirriyolyolme kunwoybukkenh. Bu ngahdirri instrument nawu lyre kore ngawayini, wanjh kunu ngayolyolme kunwok manbu kanbukkabukkankenh ngad bininj rowk, dja ngayolyolme kore baleh kakarremenmenyime kunwok manbu kamenwarlkayindi. ");
INSERT INTO gup_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Yiddok ngakelemen bu kunrayek kambebme ngardduk? Yiddok ngandihkelehme nawu birriwarre bininj bu ngandiwakbuyingun ngardduk? ");
INSERT INTO gup_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Bedda nawu njalenjale kabenmarrkkan yiman nawu namakmak, dja kabirriburlumerren bu kabirriyime bedda birrikuken duninjh. ");
INSERT INTO gup_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Minj nangale bininj kabayahme kunmalng nuye nabuyika bininj. Minj kakarremulewan kore God ba bu kabikukbayahme nabuyika ba bu kayawoyhdarrkiddi. ");
INSERT INTO gup_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Bininj minj karribayahme kundarrkid bu djal nawern money karrikukkarrme. Dja larrk, minj karribayahme manbu kundarrkid. ");
INSERT INTO gup_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Kunukka minj nangale bininj kakarremulewan nuye God ba bu kabibawon karrarrkid munguyh, dja minj karrowen bu kakuknudmen kore kumidj. ");
INSERT INTO gup_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Bininj rowk kabirridowe. Bininj nawu birribengwarr dja mak bininj nawu birrikodjkuludjad, wanjh bedda rowk kabirridjaldowe. Kabindimarnekukbawon nawu kabirrikukkarrme dja birribuyika bininj kabirrimang rowk. ");
INSERT INTO gup_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Yikahwi bininj nawu birringeykimuk wanjh kabirribolkngeybun ba kabolkngeykenhdan bedberre. Dja bonj, bedda warridj kabirridjaldowe dja kabirridjaldi kore kumidj munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Bininj nawu nawernhkuken minj kangehkerren, dja kahdjaldowen yiman kayime mayh. ");
INSERT INTO gup_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Kuhni kabenmarnekurduyimerran bininj nawu kabirridjalburlumerren, dja mak bininj nawu kabindikadjung, dja kabindibekkabekkan bedberre. ");
INSERT INTO gup_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Bedda rowk wanjh kabirridowerren yiman sheep yerreh, dja wanjh kabirrire kore kumidj. Kumekbe wanjh kundowikenh kabenmirndenahnan! Bedda wanjh bonj, kabirrikuknudmen kore kumidj. Minj kabirridurnden kore kururrkmak bedberre. Nawu birrimak bininj wanjh munguyh kabindimarnewohrnan nawu birriwarre. ");
INSERT INTO gup_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Dja ngaye, wanjh God nganngehke kore kundowikenh, dja woybukkih nungka ngankimang ba ngahdi kore nungka. ");
INSERT INTO gup_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Yuwn bu ngurrikangewarre bu ngurrinan bininj nawu kakukenworren, dja kadjehdjenkurrme kunkimuk. ");
INSERT INTO gup_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Bu nungka karrowen, wanjh minj njale kakukkan kore kundowikenh. Minj kakukkarrme kore kanjdji kakolung. ");
INSERT INTO gup_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Bu nawu nakuken bininj kahdarrkid wanjh kanjilngmak dja kaburlumerren. Bininj rowk kabirriburlume. ");
INSERT INTO gup_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Bonj, nungka wanjh kare kore kundowikenh karohrok nawu birrikebmawahmeng birriyingkihdoweng. Minj kabirriyawoyhnan kore kabolkwolkan. ");
INSERT INTO gup_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Bininj nawu kaburlumerren, bu minj kawernhburrbun kunmak, wanjh karohrok mayh nawu kadjaldowe. ");
INSERT INTO gup_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","God nawu Narrulkarrekimuk Duninjh, nawu kangeyyo Yawey, wanjh kawokdangen, dja kabenkayhme birriwarlahkenh bininj bu kabirrire kore nungka. Wanjh djarrehbeh kabirrimre kore koyekbeh dja mak kore karrikadbeh. ");
INSERT INTO gup_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","God wanjh kahdi kore kunred Zion, manbu kubolkmakkaykenh nuye. Dja karrikuknan bu nungka nawernhmakkaykenh duninjh. ");
INSERT INTO gup_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Nakka wanjh God kadberre, dja nungka kawokdi. Nungka kamre manbirlukimuk dorrengh, dja manbirluwoldjen kangun rowk kore kamre. Warridj kamkan namarrkon dja kunmayorrkkimuk bu kamre! ");
INSERT INTO gup_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Nungka kabenkayhme nawu kabirrihni kaddum kore heaven, dja mak kabenkayhme bininj nawu kurorre kabirrihni. Nungka kabendjadme bininj nuye. ");
INSERT INTO gup_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Nungka kayime, “Ngurrbenmirndemornnamen bininj nawu birriwokkurrmerrinj ngardduk kore ngandiwong dja ngandimarnebom mayh ngardduk.” ");
INSERT INTO gup_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Kaddum kunngol rowk kamulewan God bu nungka kadjalkurduyime mandjad duninjh. Dja nungan nadjalkudji kandjadme ngad bininj rowk. ");
INSERT INTO gup_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Wanjh God kayime, “Ngudda nawu ngardduk bininj, wanjh kandibekkabekka. Ngaye ngawokdangen bu welengname ngudberre, ngudda nawu Israel ngunkebmawahmeng. Ngaye God, wanjh ngudberre God. ");
INSERT INTO gup_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ngudda kanwon njalehnjale dja mayh, dja kandimarnekinje kunbarnangarrawern. Bonj, kamak. Dja minj ngayiddung ngudberre bu kunmekbekenh. ");
INSERT INTO gup_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Dja med, ngaye minj ngadjare bulikki kore kunrurrkbeh ngudberre, dja minj ngadjare nenikud ngudberre ngurrimirndekarrme. ");
INSERT INTO gup_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Kaluk mayh rowk wanjh ngardduk. Ngakarrme mayh nawu kuberrk kare, dja mak bulikki kore kubolkbubuyika kunwern duninjh. ");
INSERT INTO gup_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Ngawernhburrbun mayhmayh nawu karrolkan kore kuwarddekimuk. Mayh nawern nawu kelebuk wanjh ngardduk rowk.” ");
INSERT INTO gup_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","“Bu ngaye ngamarrwedoweyi, wanjh minj ngamulewarren ngudberre. Ngayingkihkarrme kurorre rowk, dja mayh rowk. ");
INSERT INTO gup_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Yiddok ngurriyime bu ngaye ngangun kunkanj ngarre bulikki, dja ngabongun kunkurlba ngarre nenikud? Burrkyak. ");
INSERT INTO gup_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Yuwn bu kanwon manme. Dja ngaleng kanmanjbun ngaye nawu God. Kuhni kanwo. Dja bu ngurriwokkurrmerren bu kanberrebbun, wanjh maninjmanu ngurridjalkurduyimen kore ngaye nawu Nakimuk Duninjh God. ");
INSERT INTO gup_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ngudda kankayhmen bu kunyid kambebme ngudberre, dja wanjh ngaye ngehke ngudberre ba bu ngudda kandiburlume.” Kuhni bu God yimeng. ");
INSERT INTO gup_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","God kunbuyika kabenmarneyime nawu birriwarre bininj, kayime, “Adju! Njalekenh ngudda ngurribengdayhkerren manbu ngardduk mankarre? Dja njalekenh ngurriyolyolme kore ngaye wokkurrmerrinj ngudberre? ");
INSERT INTO gup_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Ngudda minj kandibekkabekkan kore ngaye bukkabukkan njalehnjalekenh. Ngurridjalwokburriwe ngardduk kunwok. ");
INSERT INTO gup_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ngurriraworren bininj nawu birridedjolkwern rowk, dja ngurridjarrkkurduyime bininj nawu kabirridjirdmarren. ");
INSERT INTO gup_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Ngudda munguyh ngurriyolyolme kunwarrekenh, dja munguyh ngurrikurrehkurren. ");
INSERT INTO gup_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ngurrbenwarrewan dja ngurriwiddjung bininj nawu namud duninjh ngudberre! ");
INSERT INTO gup_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Kuhni rowk ngurrikurduyimi, dja ngaye minj bengdayhkeyi, dja ngadjaldi. Wardi ngurriyimeninj bu ngaye ngurrirohrok? Dja burrkyak, ngaye bolkkime ngawernhyiddung, dja bengdayhke ngudberre, dja karrikebnarren bu ngaye welengname ngudberre.” ");
INSERT INTO gup_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Mah, wanjh kandibekka ngudda nawu kandjalbengmidjdan ngaye nawu God, dja bu burrkyak, wardi kukdjalkmang, dja minj nangale ngunngehke. ");
INSERT INTO gup_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Bininj nawu nganwon njalenjale bu ngaye nganmanjbun warridj, wanjh kunu nganburlume. Dja mak bininj nawu kadjalre kore manbolh ngardduk, wanjh ngaye God ngadjalngehke.” b ");
INSERT INTO gup_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","O God, ngudda nawu munguyh kandjalmarnedjare, wanjh kandjalkongibu! Ngudda yiwernhmimkongiwern duninjh! Kanmarnebularrbu ngardduk kunwarre rowk. ");
INSERT INTO gup_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Kankangedjirridjbu dja kanmarneburriwe kunwarre rowk ngardduk, dja kankangemarnbu ba minj ngayawoyhwokburriwe ke. ");
INSERT INTO gup_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Yoh, wanjh kumekbe kunwarre ngakurduyimi bu minj wokmarrkmayinj. Ngaye munguyh ngadjalburrbun bu ngahkurduyimi kunwarre kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","O God, ngaye ngakurduyimeng kunwarre duninjh kore yidjalkudji ngudda ke. Ngaye ngudda yidjalkudji njilngwarrewong bu ngaye wanjh ngakurduyimeng kundjalwarre manbu kore ngudda yiwarnyak duninjh. Bu kumekbekenh ngudda djalmandjad kandjuhbun kore ngaye ngakurduyime kundjalwarre. Ngudda wanjh kunmak yiyime bu ngaye kanwarrewan. ");
INSERT INTO gup_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Woybukkih, ngaye nawu ngadjalyingkihwarreni duninjh bu ngarranginjbeh, dja mak bu ngadjalningihni kore ngalbadjan kuwarlirrng ngarre. ");
INSERT INTO gup_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ngudda yidjare bu marnekangewoybukworren bulkkidj duninjh. Dja yingan kankangebukkabukkan munguyh ba bu ngaborlhme ngudda ke kunmayali. ");
INSERT INTO gup_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Mah, wanjh kanwernhkangebelewo, yiman kayime kankukdjuhke manbu kunmalaworr hyssop dorrengh. Kankangedjirridjbu ba ngadjalwernhkangebelemen duninjh, yiman rerrih snow kadjalwernhbame. ");
INSERT INTO gup_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ngadjare kannjilngmarnbun wernkih duninjh. Ngudda korroko kanmurrngngerrehmeng, dja bolkkime wanjh ngadjare ngamarrmarr kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Yimirrkborledmen, ba bu minj yiyawoyhnan kunwarre ngardduk, dja mak kanmarnebularrbun kundjalwarre rowk kore ngaye ngakurduyimi. ");
INSERT INTO gup_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Ngudda God, kankangekerrngehmen, ba bu kunmak duninjh kunmayali ngakurduyime, dja kanmarnbu ba minj ngakangeborledme bu bodmewoyi ke. ");
INSERT INTO gup_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Yuwn bu kankukmunkewe kore ngad ngarrdjarrkre, dja mak yuwn bu kanyimang nawu Namalngmakkaykenh ke kore kukange ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Kanyawoyhnjilngmarnbu kore ngudda kanngehkekenh. Kankangemarnbu warridj ba ngaye wokmarrkmang ngudda munguyh dja minj ngamarrkbaworren. ");
INSERT INTO gup_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Kaluk bu kuhni yikurduyime ngardduk, wanjh ngaye ngabenbukkabukkan bininj nawu ngundiwokwirrihmeng, ba bu bininj birriwarre kabirrimdurnden kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Yoh, ngudda God ngardduk, ngudda nawu kanngehkeng ngaye, wanjh kanbebkemen kore kuninjkunu kunwarre bu ngabenbuyi bininj. Bu kuhni yikurduyime wanjh ngaye ngawayini kurobbe bu mulewan ngudda, dja ngayime ngudda wanjh yidjalkurduyime kunmak duninjh. ");
INSERT INTO gup_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Ngudda nawu Yiwohrnan Rowk, kanwokmarnbu ba bu werrknin ngaye djalburluburlume. ");
INSERT INTO gup_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ngaye ngaburrbun bu ngudda minj yidjare nawu mayhwi ngundimarnekinje. Ngudda yiman yidjareniwirrinj wanjh ngaye woyi nawu mayh sheep ngakinjeyi ke, wanjh kunukka ngaye yawoyhnjilngmarnbuyi ngudda. Dja burrkyak, ngudda minj yidjare bininj ngundidjalmarnekinje mayh. ");
INSERT INTO gup_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Ngudda kunbuyika yidjare. Bu bininj kabirridjalwarnyakmulewarren dja kabirrinjilngwarreworren bu kabirriburrbun bedberre kunwarre, wanjh ngudda yibenbekkabekkan dja minj yibenwirrihme. ");
INSERT INTO gup_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","O God, yibenkongibu bininj kore kured Jerusalem dja mak yibenbidyikarrmen bedberre kore yidjare. Yiyawoyhbolkmarnbu manbu kawarnamyo ngarre Jerusalem. ");
INSERT INTO gup_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Bu ngudda kuhni yibenmarnekurduyime, wanjh nawu bininj ke mandjad kabirridjalkurduyime ba bu ngudda yinjilngmakmen. Wanjh bedda kunu ngundiwon mayh nawu sheep dja mak bulikki bu ngundiwon dja kabirrikinje kore altar ngudda ke. ");
INSERT INTO gup_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Ngudda bininj kunukka bonj bu ngurrimurrngrayek dja munguyh ngurriburlumerren kore kunwarre ngurrikurduyime. Kunbarnangarrakuyeng ngudda ngurriburlumerren. Dja njalekenh? God wanjh korroko ngunwarreweng ngudberre. ");
INSERT INTO gup_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Warridj manwarrehwarre ngurrikarremarnbun. Bu ngurriwokdi, wanjh ngurridjalyime kunwarre dja mak ngurrikurrehkurren. ");
INSERT INTO gup_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ngurrimanjngun kunwarre dja ngurriwarnyak kunmak. ");
INSERT INTO gup_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Ngurridjare ngurrbenmarneyime djal kunwarre bedberre birribuyika bininj. Ngudda wanjh ngurridjalkurrehkurren bu munguyh. ");
INSERT INTO gup_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Wanjh kunmekbekenh kunu God ngunbun ngudberre, dja ngunbularrbun dja minj ngurriyawoyhmakmen. Nungka ngundarrkidmang kore kured ngudberre dja ngundjalkukkan djarreh kore ngurrihni. Nungka wanjh ngunkukyerrkke ba ngunburriwe djarreh kore bininj kabirridarrkiddi kondah kurorre. ");
INSERT INTO gup_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Bu God kabenyimewon kore birriwarre bininj, wanjh nawu birrimak bininj kabirrimarnekelemen nuye. Dja mak kabindidjekmiwon bedberre nawu birriwarre bininj, dja kabirriyime, ");
INSERT INTO gup_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Ngurrina! Birrimekbe bininj minj birriwoybukwoyi God bu bennahnayi bedberre. Dja ngaleng bedda birriburlumerreni bu yimankek birrikukenniwirrinj duninjh, dja mak birriyimi bu money bedberre yimankek kabenbidyikarrme! Mak bindiwarrewoni birribuyika bininj ba bu bedman yimankek birrimurrngrayekworrimeninj.” ");
INSERT INTO gup_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Ngaye wanjh ngadjalkurrmerren kore God nawu kanmarnedjare munguyh munguyh dja minj mak nganbawon. Kunmekbekenh ngaye wanjh nuye bininj, dja ngahdjaldi kamak rowk. ");
INSERT INTO gup_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Yoh, God, ngaye wanjh burluburlume bu munguyh kore ngudda yikurduyimeng rowk ngardduk. Warridj bu ngarrimirndemornnamerren, ngudda ke bininj dorrengh, wanjh kunmekbe ngaye ngeymulewan bu ngudda yingeymak, dja djalburluburlume ke. ");
INSERT INTO gup_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Nawu birribengwarr bininj kabirriyimerren kanjdji kore kukange bedberre, “Kondah nuk minj God karri!” Birrimekbe bininj kabirridjalkurduyime kunwarre duninjh. Minj nakudji kakurduyime kunmak. ");
INSERT INTO gup_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Wanjh God kabolknan kanjdji kurorre kore nungka kahni kaddum heaven, dja kabenkurdunan birriwarlahkenh bininj rowk. Nungka kadjare kabinan nangale nawu kabirrimenmenburrbun kunmakkenh, dja mak kabinan bu nangale bininj nawu kabiwokmarrkmang nungka. ");
INSERT INTO gup_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Dja burrkyak, bedda birriborlekerrinj rowk nawu birriwarlahken bininj dja mak bedda birriwarreminj duninjh. Minj nangale nawu kakurduyime kunmak. Minj nakudji. Bu djalburrkyak! ");
INSERT INTO gup_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Wanjh God kayime, “Yiddok nawu birriwarre bininj minj kabirrimayalibayhme bu kabirriburrbun? Nakka wanjh kabindibun dja kabindiyakwon nawu bininj ngardduk yiman kayime buriddi rerrih bu kabirringun. Birrimekbe birriwarre bininj minj kabirridi yiwarrudj bu ngaye ngandikayhme.” ");
INSERT INTO gup_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Wanjh birrimekbe birriwarre bininj birrikangebarlmiyindanj kunkele, dja mak minj njale diwirrinj nawu kabenkelehme! Ngudda nawu Israel ngunkebmawahmeng, God kaluk kabenbun nawu ngundibun ngudberre dja kabenmurrngburriwe. Nungka kabenwidnan duninjh dja ngunmarnbun bu ngudda ngurrbenmarnbun bedberre bu bedda kabirriyemengalme. ");
INSERT INTO gup_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Wanjh ngarri yiwarrudj bu nungka God kamre kore kunred Zionbeh dja kabenngehke nawu Israel bininj! Bu nungka kabenkukenwon nuye bininj, wanjh nawu Jacob benkebmawahmeng kabirridjalnjilngmakmen dja kabirrimarrmarrnin. ");
INSERT INTO gup_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","O God, ngudda yirrulkarrekimuk! Wanjh kanngehkemen. Ngudda nawu yimurrngrayek duninjh dja yingudjwern, wanjh kanbebkemen. ");
INSERT INTO gup_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","O God, kanbekkabekka kore yiwarrudj ngahdi bu djawahdjawan. Kanwokbekka kore ngaye ngawokdi. ");
INSERT INTO gup_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Birridjenbubuyika bininj ngandibun. Nakka birribang dja kabirridjare ngandibun bu ngarrowen. Bedda minj ngundimarnekele ngudda nawu God. ");
INSERT INTO gup_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Dja ngadjalburrbun woybukkih bu God nganbidyikarrme. Nawu Kawohrnan Rowk wanjh munguyh nganhkarrme. ");
INSERT INTO gup_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ngadjare nungka karrurndiwe kunwarre bedberre bininj nawu ngandimolkyolyolme, ba bedman kabirriwarreworren. Nungka minj munguyh nganbawon, dja wanjh kabenbularrbun nahni nawu ngandiwidnan ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Kamak bu ngaye won njalehnjale dja ngadjalkurrme ngardduk kore ngudda nawu Yawey. Dja mak ngaye ngeyburluburlume ngudda ke kunngey ngudda nawu yindjalngeymak. ");
INSERT INTO gup_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Mak ngudda yidjalkudji kanbebkeng kore ngawarredongi. Mak nawu ngarriyidko bininj wanjh ngabenang kumim ngardduk bu birrimankang. ");
INSERT INTO gup_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","O God, bu ngahdi yiwarrudj djawahdjawan, wanjh kanbekka dja yuwn bu kanwokdahme bu ngaye djawan bu kankongibun. ");
INSERT INTO gup_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Kanbekkabekka dja wanjh kanwokmang. Ngaye ngadjalwernhkangewarreminj dja ngadjalngeyngeyyime bu djawadjawan kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Dja ngandimarneyiddung ngardduk nawu ngandiwidnan bininj, wanjh kunmekbekenh ngahkele. Bedda ngandidarrarrhmiwon. Ngandiwon kunyid dja ngandiwidnan duninjh. ");
INSERT INTO gup_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Kunkimuk duninjh kunkele ngakarrme, dja mak ngawernhmenkengeme nawu kundowikenh. ");
INSERT INTO gup_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Ngahkukdeldelme bu kunkelekenh, dja ngamayaliwarremen bu ngadjalburrbun munguyh bu kunwarre duninjh ngawernhkengeme. ");
INSERT INTO gup_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Ngayimerrinj bu kunwel ngakarrmeninj wanjh ngarrolkayi ngarawinj djarreh bu ngangehmeninj. ");
INSERT INTO gup_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Yoh. Ngaye wanjh ngarawinj djarreh kore kubolkdarleh nganiwirrinj. ");
INSERT INTO gup_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Dja mak werrkwerrk ngabolkngalke bu ngakodjbarrkbuyindiwirrinj kore mahni kunyid manbu yiman kayime kunmayorrkkimuk bu nganbun. ");
INSERT INTO gup_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Ngudda nawu Yiwohrnan Rowk, yibenmayaliborledkemen ba kunukka minj kabirriwokdi mandjad. Dja nganan kunyid kawernmerren kore birriwern bininj kabirrini dja kabirriburren. ");
INSERT INTO gup_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Yidwernmerrinj bedberre bininj nawu kabirrihni kumekbe kunredkimuk Birriwern bininj birribangminj kumekbe dja kabirridurrinj dja mak kabirriwidnarren bu barnangarrakuyeng dja kumununkuyeng. ");
INSERT INTO gup_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Kunrayek kawernmerren warridj bedberre nawu kabirrihni kore kumekbe kunredkimuk. Bininj kumekbe wanjh kabirrikelehmerren dja mak kabirrikurrehkurren munguyh. ");
INSERT INTO gup_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","13","Ngudda nawu djawirna duninjh ngardduk, nawu ngarrdabbolk dja ngarrmarnedjaremerren, njalekenh ngudda mak kanyolyolme dja kandjekmiwon? Nawu ngarriyidko kabirriyime dja wanjh ngaye ngadjaldi kamak, dja wardi ngamarnewalkkarren nuye. Dja ngudda? ");
INSERT INTO gup_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Yiburrbu kore ngarrdjarrkrey bu ngarrwokdi dja ngarrborlhmi, mak ngarrdjarrkdi yiwarrudj kore temple. Wanjh kamak rowk. ");
INSERT INTO gup_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Dja nawu ngarriyidko bininj, wanjh ngadjare kundowikenh kabenmang. Nakka wanjh birridowimen bu birrikolung kanjdji kore kundowikenh ngarre kunred Sheol. Wanjh kunwarre kahdi kore kukange bedberre nawu ngarriyidko. ");
INSERT INTO gup_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Dja ngaye wanjh ngamarnekayhme nawu God, dja wanjh nungka nawu Yawey nganngehke. ");
INSERT INTO gup_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Ngadjaldi yiwarrudj bu ngakayhmi kore nungka bu munguyh kore kukabel, dja mak kore barnangarra dja mak bu kumunun. Ngadjaldjawadjawan bu kunwarre nganmarnerayekwon, dja wanjh nawu Yawey nganwokbekkan. ");
INSERT INTO gup_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Bu kuhrikuhri ngarriburren, wanjh nungka nganmalngngehke dja ngankurrme bu kamak rowk. Birriwern duninjh bininj ngandimarnebebme kunyid dorrengh dja kabirridjare ngandibun ngarrowen. ");
INSERT INTO gup_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","God nawu yingkihwohrnawohrnani rowk bu munguyh munguyh, wanjh nganbekkan bu ngabenmulewan nahni birriwarre bininj, dja wanjh nungka kabendung dja kabenburriwe, kunmekbekenh bu bedda minj munguyh birriborledkerrimeninj kore kunmak birrikurduyimeninj, dja minj mak birrimarnekeleninwirrinj nawu God. ");
INSERT INTO gup_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Nahni bininj nawu ngaye nganedabbolk wanjh nungka borledmeng dja kabenbun nawu djawirna benkarrmi. Nungka wanjh djalwokbakkeng kore benmarnewokkurrmerrinj. ");
INSERT INTO gup_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Makka djal kaddukaddum kore nungka yimihyimi, dja kanjdji kore kukange nuye, nakka minj kunwoybukniwirrinj, dja nungka kurrehkurreni bu yolyohyolyolmi. Nungka wokdi bu kamak rowk, dja djareni benbuyi bininj mandjawak dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Bonj, wanjh kumekbe kayime bu kunrayek kambebme ngudberre, wanjh ngurriyibawon rowk kore nawu Yawey ba ngunmarnebebme dja ngunbidyikarrme. Minj ngunbawon ngudda nawu ngurrikangewoybuk bu nangale ngunkukwarrhke. ");
INSERT INTO gup_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Ngudda nawu God, wanjh yibenkukburriwe nawu birribang bininj kore kumidj ba kabirrikuknudmen. Bininj nawu kabindibun birribuyika, dja nawu kabindikowe, wanjh bedman kabirriwohdowe bu kabirridjaldabbolk. Dja ngaye, bonj, wanjh ngakangekurrmerren kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","O God, kankongibu! Bininj ngandiwernhkadjung ba bu ngandibun, dja barnangarrakuyeng nawu ngarriyidko ngandidjaldarnhbun. ");
INSERT INTO gup_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Nawu ngandiwirrihme ngandibun kunbarnangarrakuyeng. Birriwern nawu kabirriburlumerren kore ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Bonj, bu ngaye ngakelemen, wanjh ngakangekurrmerren kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Ngaye ngamarnekurrmerren nawu God, dja ngaburlume nuye kunwok. Ngaye ngawoybukwon nawu God, dja minj ngayawoyhkelemen. Baleh mak ngandimarnekurduyime nawu djal bininj? ");
INSERT INTO gup_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Nawu ngandiwidnan bininj wanjh barnangarrakuyeng ngandiwokborledke bu ngandiyolyolme. Bedda munguyh ngandimarnekarremarnburren bu yimankek ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Bedda kabirrimornnamerren manmolk ngarddukkenh, dja kabirriwarlkkayindi ba bu ngandikurdunan kore njalehnjale ngakurduyime. Bedda kabirridjaldjare ngandibun ngarrowen. ");
INSERT INTO gup_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","O God, yuwn bu yibenbawo bu kabirrikelerlobme kore ngudda yiyiddung. Wardi yibendu birriwern bininj kore kubolkbubuyika, wanjh yibenburriwemen bedberre kanjdji. ");
INSERT INTO gup_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Ngudda God yiburrbun rowk bu bininj ngandinjilngwarrewong kunwernkenh. Ngudda yiman kayime kanmimnalkdahkendongi kore budjurlung ke, dja yibimbuyi kunmimnalk rowk ngardduk kore djurra ke. ");
INSERT INTO gup_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Dja bu ngarrangen yiwarrudj dja marnekayhme ke, wanjh kundjalburrikudji birrimekbe nawu ngandiwidnan wanjh kabirrikelerlobme! Ngaye ngaburrbun bu kuninjkunu nawu God nganehdjarrkdi dja nganbidyikarrme. ");
INSERT INTO gup_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Nungka nawu God, dja ngaburlume nungka nawu wokkurrmerrinj. Nungka nawu Yawey, dja ngaburlume nuye kunwok rowk. ");
INSERT INTO gup_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Ngaye ngadjalkangekurrmerrinj kore God, wanjh ngaye minj ngayawoyhkelemen. Baleh mak ngandimarnekurduyime nawu djal bininj? ");
INSERT INTO gup_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","O God, ngaye ngawokkurrmerrinj kore ngudda, wanjh kunmekbekenh ngaye ngakurrmekurrme namakmak kore ngudda ba bu manjmanjbun ke. ");
INSERT INTO gup_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Ngaye ngaburrbun ngudda kanbebkeng kore kundowikenh, dja kanwayhkeng kore ngamankayi. Kumekbekenh wanjh ngaye won namakmak nawu marnekurrmeng. Wanjh ngaye ngahre kore kumirrk nuye God nawu kanmarnebolkwolkan ba bu ngadjalmimbi kore nuye. ");
INSERT INTO gup_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","O God kankongibu! Kandjalkongibu! Ngaye ngamkelerlobmeng kore ngudda dja ngakangekurrmerren ba yidjurruddin ngardduk. Ngaye ngakurrmerren kore ngudda ba kanbarrkbun, ngahdjaldi kore ngudda kaluk bu yerrekah manbu kunyid nganmarneyakmen. ");
INSERT INTO gup_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Ngaye wanjh ngamarnekayhme nawu Nawernhkimuk God Duninjh. Nungka munguyh kakurduyime kore yingkihkarremarnbom ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Nungka nganbekkan kore kaddum kahni, wanjh nganngehke dja kabendung bininj nawu ngandiwernhkadjung dja bedda kabirriyimengalme. God wanjh kanmarnedjare dja minj kanbawon munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Ngaye ngarridjarrkdi birribang bininj nawu birriwarre duninjh. Bedda kabindibun bininj, warridj kabindiyolyolme bu kabindimarnekowe bininj. ");
INSERT INTO gup_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Dja ngadjaldjare ngudda bu bininj rowk ngundiburluburlume kore kaddum yihni. O God, yibenmarnbu birriwarlahkenh bininj kondah kurorre ba bu ngundinan bu ngudda yiwernhmakkaykenh duninjh. ");
INSERT INTO gup_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Nahni birriwarre bininj wanjh birrikarremarnbom bu ngandidarrkidmang. Wanjh ngaye ngawernhkarrewarreminj. Bedda wanjh ngandimarnekarremarnbom ngandibungkarrkbom, dja bonj, wanjh bedmandeleng birrimankang! ");
INSERT INTO gup_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","O God, ngaye ngadjalkangewoybuk kore ngudda, dja minj ngamarrkbaworren kore nguddakenh. Wanjh ngaye marnewayini ke, dja mak ngamarnmarnbun music kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Mah, ngadjare ngakabeldong ba bu ngarrirri nawu instruments, nawu harp dja lyre. Ngaye ngawernhdirri bu kumkabel djarreh bu ngaye yiman kayime ngadjurlhme nawu kundung! ");
INSERT INTO gup_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Wanjh ngaye manjbun ngudda nawu Yiwohrnan Rowk, ba bu birriwarlahkenh bininj ngundingeybekkan kore kubolkbubuyika rowk. Ngaye ngawayini bu burluburlume ngudda kore birridjenbubuyika bininj ngarrihdjarrkni. ");
INSERT INTO gup_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Ngudda kandjalmarnedjare munguyh munguyh kore kanjdji dja mak kaddum kore heaven. Ngudda wanjh yidjalwoybuk duninjh dja minj kankowe kandjdji dja mak kaddum kore kunngol. ");
INSERT INTO gup_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Dja ngadjaldjare ngudda bu bininj rowk ngundiburluburlume kore kaddum yihni. O God, yibenmarnbu birriwarlahkenh bininj kondah kurorre ba bu ngundinan bu ngudda yiwernhmakkaykenh duninjh. ");
INSERT INTO gup_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Ngudda bininj nawu ngurrbenmarnewohrnawohrnan dja ngurringeykimuk, yiddok ngurridjalyime kore mandjad bu ngudda ngurrbendjadme bininj? Yiddok ngurrbendjaddjadme bininj kore kunwoybuk dja kunmak dorrengh? ");
INSERT INTO gup_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Burrkyak duninjh! Ngudda bu kanjdji baybaywi ngurridjaldjare kunwarre ngurrikurduyime. Munguyh ngurrbenbun bininj kore kondah kurorre. ");
INSERT INTO gup_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Nawu birriwarre bininj wanjh kabirridedjingmang kunwarre kabirriyime bu bedda kerrngehkenh kabirringalme dja kabirrikurrehkurren kore birridjalyahwurd! Bedda kabirridjalre kore bedberre manbolh. ");
INSERT INTO gup_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Bedda yiman kayime nabang nayin, dja kabirrikarrme manbang kore kurrang bedberre. Mak kabirrikanembalhmerren yiman nayin nabang nawu cobra. ");
INSERT INTO gup_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Dja mak minj kabindibekkan birrimak bininj bu kabirriwokdi, yiman cobra nayin minj nangale bininj kabibekkan. ");
INSERT INTO gup_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O God Yawey, nawu birriwarre bininj kabirriyime yiman kayime nabang lions, wanjh yibenyidmebakkemen bedberre, dja wardi yibenyidmeyerrkke kore kurrang bedberre! ");
INSERT INTO gup_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Ngadjare bu kabirridjalyakmen rowk yiman kukku bu kaboyakmen kore kurorre. Ngadjare mak bu kabirridjalbarabun kore kunwarre kabirrikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Ngadjare mak bu kabirridjaldowe yiman duberrk bu kakukkelkdan dja kadjalyakmen rowk. Ngadjare bu bedda kabirridjaldowe yiman nabarrken nawu karrowen bu kangalme, dja minj kabolknan. ");
INSERT INTO gup_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Ngadjare God wanjh kundjalburrikudji kabuhme kunyid duninjh dorrengh bu kabenkukburriwe birriwarre bininj, dja kabirriyakwon rowk. ");
INSERT INTO gup_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Nawu birrimak bininj wanjh kabirrinjilngmak bu kabindinan birriwarre kore God kabenbun bedberre dja karrengedjuhme kore bedberre kunkurlba. ");
INSERT INTO gup_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Kaluk birriwarlahkenh bininj rowk kabirriyime, “Yoh, woybukkih. God kabenwon kunmakmak nawu birrimak bininj. Nungka wanjh woybukkih kandjadme ngad karriwarlahkenh bininj kondah kurorre.” ");
INSERT INTO gup_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","O God, kanngehkemen kore ngarriyidko bininj nawu ngandiwidnan. Kankukdjurruddin dja yikahwi bininj ngandimarnebebme wardi ngandibun. ");
INSERT INTO gup_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Kanbebkemen kore birriwarre bininj nawu kabirridurrkmirri kore kunwarrekenh Kanngehkemen kore bininj nawu kabirridjare ngaye ngakurlbare. ");
INSERT INTO gup_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Yina! Bedda kabirriwokworren wanjh kabirriwarkkarren ngardduk. Nawu birribang bininj manmolk ngandimarnekarremarnbun. Nawu Yawey! Yiburrbun bu ngaye minj ngabenwarrewoyi bedberre. ");
INSERT INTO gup_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Bedda ngandidung bu djalburudjang. Ngaye minj kunwarre ngayimeninj. Dja bonj, bedda kabirridjaldjare ngandibun. Wanjh djawahdjawan bu yimray yinan kore kunmekbe kunrayek wernmerrinj ngardduk! ");
INSERT INTO gup_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Yawey, ngudda God nawu yibenmirndekarrme birridjalwern armies, dja ngudda God ngadberre bininj nawu Israel ngankebmawahmeng! Wanjh yirrolkka bu yibenbun birriwern bininj nawu birrikang kubolkbubuyikabeh. Yuwn bu yibenkongibun nahni birriwarre bininj nawu kabindiweykan birribuyika bininj. ");
INSERT INTO gup_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Birrimekbe bininj wanjh bedda kabirrimdurnderren kore kukadje bu kabalhdungyibme. Bedda kabirrirengehre yiman kayime duruk nabang bu kabirridowme dja kabirriyawarren bu kabindibun bininj. ");
INSERT INTO gup_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Ngudda Yawey wanjh yibenbekkabekkan kabirridarrahme kore kunwarrekenh kabindimarneyime birribuyika bininj. Bu kabirriwokdi, wanjh kabirridjare kabindiwarrewon birribuyika bininj. Bedda kabirriyimerren warridj, “Minj nangale kanbekkan kore karriwokdi!” ");
INSERT INTO gup_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Dja ngudda Yawey wanjh yibendjekmiwon! Mak yibennjirrhmiwon nawu birriwarlahkenh bininj nawu minj bedda ngudda ke. ");
INSERT INTO gup_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Ngaye ngakangekurrmerren kore ngudda dja yingudjkimuk duninjh dja ngabolknan dja madbun ngudda bu yimre. Ngudda God yiman kayime kunredkimuk kore ngawarlkkarren ba bu minj njale ngankilekme. ");
INSERT INTO gup_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Ngudda God ngardduk nawu kanmarnedjare. Wanjh yimray darnkih dja nganedjarrkdi. Kanbawo bu ngabendjaldjekmiwon nawu ngarriyidko bininj. ");
INSERT INTO gup_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Nawu kawohrnan Rowk, ngudda nawu kankukdjurruddi. Djawan bu ngudda minj yibenbun birrimekbe birriwarre bininj bu kabirridowerren. Bu yibenbularrbun wanjh ngad bininj ngudda ke kunubewu ngarribengmidjdan bu njalekenh yibenbom nawu birriwarre bininj. Kamak bu yibendjalmarnbun bu bedda kabirridjalmayahme kunngudj ke dorrengh dja wanjh yibendjalkoluyhwemen. ");
INSERT INTO gup_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Bedda wanjh kabirriwokdi kunwarrekenh, dja wanjh kabirridjalyime kunwarre, wanjh ngadjare yibenkardmang kore kabirriburlumerrenkenh. Bedda mak kabirriwokdi kunwokwarre, dja mak kabirrikurrehkurren. ");
INSERT INTO gup_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Ngudda yiyiddu bedberre dja yibenbularrbu bu yibenkukyakwon rowk. Kunukka birriwarlahkenh bininj kore kubolkbubuyika rowk djarreh wanjh ngundiwobekkan bu ngudda God yibenmarnewohrnan nawu Jacob benmawahmeng. ");
INSERT INTO gup_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Nawu ngarriyidko bininj wanjh bedda kabirrimdurnderren kore kukadje bu kabalhdungyibme. Bedda kabirrirengehre yiman kayime duruk nabang bu kabirridowme dja kabirriyawarren bu kabindibun bininj. ");
INSERT INTO gup_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Dja mak yiman duruk nabang bedda kabirriyawan manme, dja bu minj kabirringalke manwern, wanjh kabirriyidmebukkarren. ");
INSERT INTO gup_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Ngayeman wanjh ngawayini kore mulewan ngudda ke kunngudjkimuk. Mak bu malamalaywi rowk ngaye ngawayini kore ngudda kandjalmarnedjare. Ngudda yiman kayime kunred kunmak kore ngawarlkkarren, dja bu kunyid kabebme ngardduk, wanjh ngamkelerlobme kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","O God, ngudda kanwon kunngudj ke, dja ngaye wanjh ngawayini bu burluburlume ngudda nawu kankukdjurruddi. Ngakurrmerren kore ngudda God nawu kandjalmarnedjare. ");
INSERT INTO gup_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","O God, ngudda kanwirrihmeng ngadberre, dja nganbom. Ngudda nganduy dja nganngudjyakwong. God ngudda kandungi, wanjh bolkkime kanyawoyhmarnbu! ");
INSERT INTO gup_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ngudda yibolkrokayhweng kondah kubolk ngadberre dja yibolkdjalkmey. Bolkkime wanjh yibolkmarnbu dja wanjh kabolkwarrewarremen. ");
INSERT INTO gup_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Ngudda kanwong kunrayek duninjh ngadberre ngad nawu ngudda ke bininj. Bu kuhni yiman kayime ngudda kanbowong kunbang dja ngad yiman ngarriworromkang. ");
INSERT INTO gup_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Ngudda yibenbengdayhkeng bininj nawu ngundimarnekele ba minj kabirribularrbuyindan. Bedda wanjh kabirriwarlkarren kore ngudda ba bu birriyidko bininj minj kabindibun. ");
INSERT INTO gup_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Bolkkime wanjh kanngehkemen kubidkukun ke ngad bininj nawu kanmarnedjare. Mak kanwokma kore ngarridi yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Wanjh God wokkurrmerrinj kore nuye kunmakmak, yimeng, “Ngawinhme rowk, dja ngabolkyarlarrke kunbolk nuye Shechem, dja ngabolkrohrokme kore kanjdjikanjdji kunbolk kabolkngeyyo Sukkoth. ");
INSERT INTO gup_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Kunbolk kangeyyo Gilead, wanjh ngardduk, dja mak kunbolk nuye nawu Manasseh. Kore kunbolk Ephraim nuye wanjh ngabenmang soldiers ngardduk kumekbe. Dja kore kunbolk nuye nawu Judah, kumekbebeh ngadjarrngbun nawu king ngadjare. ");
INSERT INTO gup_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Dja mak kunbolk Moab bedberre, wanjh ngakurrme yiman ngardduk ngalng bu ngabiddjirridjburren. Mak manbu kunbolk Edom bedberre, wanjh ngakurrme kanjdji kore ngaburriwe nawu ngarrengedjongurrenkenh bu ngarrengeyerrkkerren. Dja mak ngakayhme bu ngabenbun dja ngawinhme bininj kore kunbolk Philistiabeh.” ");
INSERT INTO gup_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","O God, yiddok kankan kore kukadje kore kawarnamyo kunkimuk manbu kabirriburrenkenh? Nangale ngankan ngaye kore kunbolk bedberre nawu kabirringeyyo Edom? ");
INSERT INTO gup_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Aba, yiddok woybukkih ngudda nawu God kanwirrihmeng dja kanbawong? Yiddok yibenbawong dja minj yibenbidyikarrme nawu soldiers ngadberre bu kabirriburren nawu ngarriyidko bininj? ");
INSERT INTO gup_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Ngundidjawadjawa bu kanbidyikarrme kore nawu ngarriyidko kabirrimre! Minj nangale djal bininj ngarridjawan dja bedda birridjalngudjwarre. ");
INSERT INTO gup_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Ngarriburrbun bu nawu Godk nadjalkudji ngarridjarrkre wanjh ngarriwinhme. Nungka wanjh kabenkoluyhwe kurrenge nuye bininj nawu ngarriyidko. ");
INSERT INTO gup_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Ngudda nawu God ngardduk, kankayhmibekkabekka bu ngahdi yiwarrudj dja djawahdjawan! ");
INSERT INTO gup_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ngaye kured ngabolkbawong djarreh, wanjh kankayhmibekka bu djawahdjawan! Ngaye ngakangewarre. Wanjh kanka kore ngudda kannahnan ba bu ngadjalni kamak rowk. ");
INSERT INTO gup_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Ngudda wanjh kannahnan dja kanbidyikarrme bu nawu ngandiwidnan ngandimarnebebme. ");
INSERT INTO gup_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Ngaye ngadjare ngamre darnkih ngarrdjarrkni kore ngudda munguyh munguyh ba yikukdjurruddan ngardduk dja kankukbalhme. ");
INSERT INTO gup_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Ngudda kanbekkang kore ngawokrayekworrinj ke, ngudda nawu God. Dja ngudda wanjh ngokko kanwong nawu yidjehdjenkarrme ngadberre bininj rowk nawu ngundingeykengeme ke. ");
INSERT INTO gup_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Ngaye nawu king kondah ngadjare kanwo mandjewk nawern ba ngarrarrkiddi bu kunkuyeng, dja minj darnkih kabolkyimerran bu ngarrowen. ");
INSERT INTO gup_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Warridj ngadjare ngadjalwohrnan kore kumirrk ke munguyh munguyh. Ngudda wanjh kanmarnedjare dja minj kandjalbawon, wanjh kunu kankukdjurruddin. ");
INSERT INTO gup_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Wanjh ngaye ngadjalwayini bu burluburlume ke munguyh munguyh, dja ngamkan kunbarnangarrawern bu wonowon ke kore ngayingkihwokkurrmerrinj ke. ");
INSERT INTO gup_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Ngaye wokyak ngahdjaldi bu ngahmadbun God kamre. Nungka nadjalkudji nganngehke. ");
INSERT INTO gup_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Dja nungka wanjh nadjalkudji ngandjurruddi dja nganngehke. Nungka wanjh ngannahnan dja nganbidyikarrme ba bu ngaye ngawinhme dja minj njale nganrokayhwe. ");
INSERT INTO gup_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Adju! Ngudda bininj nawu kandidung ngaye! Ngaye wanjh ngangudjwarre, yiddok munguyh kandidjalbun? Ngurriburrbun ngaye minj ngakarrme bu ngakandenamerren. ");
INSERT INTO gup_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Ngudda ngurridjare bu kandiburriwe kore ngahni kaddum, dja kandingeywarrewon. Ngurrinjilngmarnburren bu kandiwowarrewon. Ngurrikurrekurren. Ngurriwokdi kunwok kunmak bu kurobbe, dja kore baybaywi kukange ngudberre wanjh kandikidname. ");
INSERT INTO gup_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Ngaye wanjh ngadjalmarrkebbun nadjalkudji nawu God ngardduk, dja ngaye wokyak. Ngakurrmerren kore nungka nawu ngadjalwoybukwon munguyh. ");
INSERT INTO gup_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Dja nungka wanjh nadjalkudji ngandjurruddi dja nganngehke. Nungka wanjh ngannahnan dja nganbidyikarrme ba bu ngaye ngawinhme dja minj njale nganrokayhwe. ");
INSERT INTO gup_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","God nungan ngangehke, dja mak nganmakwan. Ngawarlkarren kore nungka yiman kunwarddekimuk kore ngangehme, dja nungka nawu ngudjkimuk duninjh dja ngandjurruddi. ");
INSERT INTO gup_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Ngudda nawu ngardduk binihbininj, ngurrikurrmerrimen nawu God munguyh munguyh. Ngurrimulewarren manbu kunrayek rowk bu ngurrikarrme, dja nungka kannahnan ba karrikangengehmen. ");
INSERT INTO gup_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Ngad bininj rowk nakka yiman bu karringolekwerren karohrok nawu birrikuken dja nawu birrimarladj. Ngad yiman djal yeng, djal kukwob, minj karridulmuk. ");
INSERT INTO gup_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Yuwn bu karrikurrmerren bedberre nawu kabirriburrehburren, dja yuwn bu mak karridjirdmang njalehnjale, dja wanjh karribawo rowk. Bu karrikukenmen, wanjh yuwn bu karrikurrmerren kore nawu karrikukkarrme. ");
INSERT INTO gup_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Kunwernhkah ngawobekkani nawu God bu nakka nadjalkudji kakarrme kundulkarre rowk. ");
INSERT INTO gup_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Yoh, woybukkih ngudda kanmarnedjare munguyh munguyh. Ngudda nawu Yiwohrnan Rowk kanmarnekurrme manbu kahdjehdjenyo ngadberre bininj rowk kore kunmak ngarrikurduyime bu kondah kurorre ngarrihni. ");
INSERT INTO gup_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Ngudda God, ngudda wanjh God ngardduk, ngaye ngadjare bu ngarrdjarrkni. Ngaye marnedjare ngudda kore kukange ngardduk, ngaye yiman kayime bininj nawu kakanjbukmen. Ngaye yawan ngudda yiman kayime bininj nawu kakombukdowe bu kaboyawan kubolkdarleh kore kukku yak. ");
INSERT INTO gup_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ngaye nang ngudda kore yihni kubolkdjamun ke. Wanjh ngaye nang bu ngudda yirrulkarrekimuk duninjh, dja mak yidjalmakkaykenh. ");
INSERT INTO gup_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Ngudda wanjh kandjalmarnedjare bulkkidj duninjh. Bu ngaye ngarrarrkidbaworren, wanjh kamak, dja ngaburrbun bu ngudda kandjalmarnedjare. Wanjh ngaye kunu burluburlume ngudda kore kurrang ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Dja bu ngaye ngadjaldarrkid wanjh ngaye burluburlume kunkodjkebubuyika rowk kaluk bu ngarrowen. Ngaye ngaberlwayhme bu yiwarrudj dorrengh ngahdi kore ngudda ke kunngey. ");
INSERT INTO gup_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Warridj ngudda kanmalngworrkmiwon kore kunmakmak kunwern kanwon, wanjh ngaye ngawernhnjilngmak bu marnewayini ke ngardduk kurrang, bu kunjilngmak dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Bu ngaye ngalorrhmiyo, wanjh burrbuhburrbun yerrih bu kunkakkuyeng. ");
INSERT INTO gup_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Bu kunmekbekenh ngudda munguyh kanbidyikarrmi. Ngaye ngakurrmerren kore ngudda bu kannahnan yiman kayime mayhmayh yaw kakurrmerren kanjdji kore ngalbadjan ngarre kunwel. Wanjh ngawayini kunnjilngmak dorrengh kunmekbe. ");
INSERT INTO gup_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Ngaye wanjh munguyh wernhkarrme ngudda kore kukange ngardduk, dja kubidkukun ke kanwernhkarrme ba minj ngamankan. ");
INSERT INTO gup_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Bininj nawu kabirridjare ngandibun, wanjh bedman ngaleng kabirrikolung kanjdji duninjh kore kunred ngarre kundowikenh. ");
INSERT INTO gup_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Wardi kabirridowe mankimuk mandjawakwi kore kabirriburrenkenh, dja dalkken kaluk kabindikanjngun. ");
INSERT INTO gup_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Dja nawu king kadjalmarrmarr kore God! Bininj rowk nawu kunwoybuk kabirridjalyime kore kunngey nuye God, wanjh bedda kabirriburluburlume. Dja bininj nawu kabirrikurrehkurren, wanjh kabirridjalwokyakmen. ");
INSERT INTO gup_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","O God kanbekkabekka kore ngahdi yiwarrudj, dja kunyid wernmerrinj ngardduk! Nawu ngarriyidko bininj kabirridjare ngandibun, dja yimdjurruddin ngardduk! ");
INSERT INTO gup_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Kanwarlka ba bu birriwarre bininj nawu ngandimarnekarremarnbun minj ngandingalke. Bedda nawu kabirrimirnderri bu kunwarre kabirridjarrkkurduyime. ");
INSERT INTO gup_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Bedda wanjh kabirriyolyolme nakka yiman kabindikangewarrewon birrimak bininj, dja kabindimarneyime kunwok kunwarre ba bu kabindinjilngwarrewon. Kundjen bedberre yiman mandjawakmirrkmak, dja kunwok kunyidkenh bedberre yiman mankole mankebmak. ");
INSERT INTO gup_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Birrimekbe birriwarre bininj minj kabirrikele. Wanjh kabindimarnekunidi nawu birrimak bininj, dja kundjalburrikudji kabindidulubun. ");
INSERT INTO gup_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Bedda wanjh kabirrikangerayekworren ba bu kabirrikarremarnbun bu kunwarrekenh kabindimarneyime. Mak kabirrikarremarnbun bu kabindidengekardmang nawu birrimak bininj. Dja kabirriyimerren, “Minj nangale kannan kore kunwarre karrikurduyime!” ");
INSERT INTO gup_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Kabirrikarremarnbun bu kabirrikurduyime kunwarre duninjh, dja kabirriyimerren, “Ngad wanjh karrikarrekarrme kore karrikurduyime dja wanjh kamak rowk!” Bininj minj kabirrimayaliburren dja minj kabirrikangeburrburren, dja kanjdji baybaywi kabirriyimerren. ");
INSERT INTO gup_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Dja bonj. God nungan wanjh kundjalburrikudji kabenmarnekarrewarrewon, yiman kabenlonbun mankolewi. ");
INSERT INTO gup_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Nungka wanjh kabenbularrbun bu kumekbekenh birriwokdi kunwok kunwarre. Birriwern birribuyika bininj wanjh kabindinan kore kabenmarnekurduyimerran bedberre, wanjh kabindimarnekodjbordebordebme dja kabindiwiddjung. ");
INSERT INTO gup_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Kaluk birriwarlahkenh bininj rowk wanjh kabirrimarnekele nawu God. Bedda kabirriyolyolmerren dja kabirriburrbun kore God kurduyimeng. ");
INSERT INTO gup_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Mah, nawu birrimak bininj wanjh birriwernhmarrmarr kore Yawey, dja kabirrirlobme kore nungka ba kabennahnan. Bedda nawu kabirridjaldjare kunmak kore kukange bedberre, wanjh birriburluburlumen nuye! ");
INSERT INTO gup_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","O God, ngundiburluburlume bu ngarridi kore kukadje Zion. Mak ngarrikurduyime rowk kore ngad korroko ngundimarnewokkurrmerrinj. ");
INSERT INTO gup_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Ngudda yibenbekkabekkan nawu ngundimarnedi yiwarrudj, dja kunmekbekenh kunu birriwarlahkenh bininj rowk kabirrimre kore ngudda. ");
INSERT INTO gup_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Kunwarre kunwern ngarrikarrmi dja wanjh ngarriwernhnjilngwarreni dja minj ngarribidyikarrmerrimeninj. Wanjh yingan kanmarnebengmidjdanj ngadberre. ");
INSERT INTO gup_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Bu ngudda yibendjarrngbun yikahwi bininj dja yibenkan darnkih ba bu kabirrihyo kore ngudda ke kunrurrkkimuk. Wanjh birrimekbe bininj kabirrinjilngmarrmarr. Dja kunmakmak kunwern kahdi kumekbe kore ngudda ke temple manbu kunrurrkdjamun, wanjh ngarrimang dja yiman ngarriworrkmiworren. ");
INSERT INTO gup_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Ngudda kanwokmang kore ngarridi dja yikurduyime ngadberre kore kundulkarre dorrengh ke, dja mak kore ngudda ke kundjalmak. Ngudda wanjh God nawu kanngehkeng, dja bininj birriwarlahkenh kore kubolkbubuyika rowk kondah kurorre, dja nawu kabirrihni bewh djarreh kore borledmikenh kurrula, wanjh ngundimarnekangekurrmerren. ");
INSERT INTO gup_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ngudda yibolkmarnbom kundulkarre ke manbu kuwarddekimuk rowk. Ngudda yidjalngudjworrinj kunngudjkimuk ke. ");
INSERT INTO gup_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ngudda yibongurdkeng kurrula bu kunmayorrk borokayhweng wernkih duninjh. Yidjalngurdkeng kore borrolkkani kunkimuk. Ngudda karohrok yibenngurdkeng bininj nawu birriburreni. ");
INSERT INTO gup_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Birriwarlahkenh bininj nawu kondah kurorre kabirrihni, wanjh ngundikurdunan kundulkarre ke dorrengh, dja wanjh kabirrikangebarrhme. Bedda wanjh ngundimarnewayini ke kunjilngmak dorrengh, kore kamdungbebme dja mak kore karrungyibme! ");
INSERT INTO gup_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ngudda God nawu yibolknahnan dja yibolkdjuhke kondah kurorre rowk kore ngarrihni. Yibolkmarnbun ba manwern manbubuyika manme kadjordmerren. Ngudda God nawu yibobarlke mankabowern ba kunbolk bedberre bininj kabenwon manmim manbu manme bedberre. Ngudda wanjh yiyingkihkarremarnbom bu kuhni yikurduyime. ");
INSERT INTO gup_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Mak yibolkdjuhdjuhke kore manme kabirridudjeng ba manme kakolhdebebmerren. Yibolkmarnmarnbun dja yimunkewe mandjewk ba bu kunkulk kakelkdan. ");
INSERT INTO gup_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Bu mandjewkbubuyika kare wanjh yimarnbun bu manme kawernmerren, dja kabirridahkendong kore wirlbarra dja wanjh kabarlme rowk. ");
INSERT INTO gup_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Kore kubolkdarleh wanjh yibolkmarnbun ba bu mandalkmak kawernmerren, dja kore manduluhdulum rowk wanjh kamirndewernmerren mayh nawu kabirringun mahni kundalk, dja wanjh bininj kabirrinjilngmakmen. ");
INSERT INTO gup_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Kore kabbal rowk, wanjh kabirrimirndekarrme nawern mayh nawu sheep dja goat kore mandalkmak. Dja kore kanjdji wanjh manmim manwern kabolkbarrkbun. Mahni yiman kayime bu kunbolk kakayhme dja kawayini kunnjilngmak dorrengh kore ngudda! ");
INSERT INTO gup_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Mah, ngudda ngurriwarlahkenh bininj nawu kondah kurorre ngurrihni! Wanjh ngurrimarrmarrnin duninjh dja ngurrimarnekayhmen nawu God. Ngurridjalburluburlumen nuye. ");
INSERT INTO gup_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Ngurriwayinin bu ngurringeyburlumen! Ngurridjalburlumen God nawu nawernhmakkaykenh. ");
INSERT INTO gup_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Ngurrimarneyimen God, “Ngudda ngurrikurdumak, dja ngurriyime kunwernhmak duninjh! Ngudda yidjaldulkarrekimuk duninjh, dja nawu ngurriyidko wanjh ngundiwernhkengehme. ");
INSERT INTO gup_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Yehyeng rowk kondah kurorre, dja mak ngad ngarriwarlahkenh bininj rowk wanjh ngundimarneboddan. Ngundidjalngeyburlume ngudda ke kunngey.” ");
INSERT INTO gup_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Ngurrimray dja ngurrina kore God kurduyimeng, bu kunwern kanmarnekurduyimeng kadberre karriwarlahkenh bininj bu kundulkarre duninjh nuye. ");
INSERT INTO gup_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Nungka wanjh kurrula bodjalkmey ba bu nawu mawahmawah kadberre birridjowkkeng bu birrimelmeng kurrenge kore kukayalanj manbu bukminj. Wanjh kunmekbe karrikurdunang dja wanjh karrimarrmarrminj. ");
INSERT INTO gup_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","God wanjh kawohrnan rowk kundulkarre dorrengh munguyh munguyh. Nungka kabennangahnan birriwarlahkenh bininj kubolkbubuyika rowk. Bininj nawu kabirriwokburriwe God, wanjh yuwn bu kabirringeykimukworren. ");
INSERT INTO gup_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Yoh, ngudda ngurriwarlahkenh bininj rowk wanjh ngurridjalburlumen God kadberre. Ngurridjalburlumen bu ngurriwayinin wernkih duninjh. ");
INSERT INTO gup_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Nungka wanjh kanhdjalkarrme kadberre munguyh ba bu karridjaldarrkid, dja minj mak kanbawoyinj bu karrimankayi. ");
INSERT INTO gup_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Ngudda nawu God kanrohrokmi ngadberre yiman kayime bininj kabirribelewon manbu silver kore kunak kunwernhbang kabirrikinje. Kuhni yiman kayime ngudda kanrohrokmeng. ");
INSERT INTO gup_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Ngudda kankang kore ngarridukkayindi, dja mak yiman kanngorrkenwong ngadberre nawu ngandulmukwong. ");
INSERT INTO gup_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Dja yibenbawong bininj birriwarre bu kandiwarrewong. Ngad kunu ngarrirey kore kurrungbang yiman kunak, dja mak kore kundjurrh. Dja bonj, ngudda kankang bu kanbebkeng kore kubolkmak bu ngarringehme. ");
INSERT INTO gup_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Ngaye wanjh ngamre kore Temple manbu kunrurrk ke ba bu marnekinje mayh ngardduk kore ngayingkihwokkurrmerrinj ke. ");
INSERT INTO gup_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Bu ngakarrmi kunyid kunkimuk, wanjh ngaye ngayemanbidju ngawokkurrmerrinj bu kundjen ngardduk ngawokdi. ");
INSERT INTO gup_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Wanjh kunmekbekenh ngamkan mayh nawu kunbalem dorrengh, yiman mayh nawu sheep nararangem, bu ngundimarnekinje kore altar. Ngaye ngamkan won nawu bulikki dja mak nawu nanikud. ");
INSERT INTO gup_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Ngudda bininj nawu ngurrikengehme nawu God, wanjh ngurrimray kandibekka bu ngaye ngayolyolmerren dja marneyime kore nawu God nganmarnekurduyimeng ngardduk. ");
INSERT INTO gup_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Yoh, ngaye ngadjalkayhmi nuye kurrang ngardduk. Ngaye ngakayhmeng nuye bu ngaburluburlumi warridj. ");
INSERT INTO gup_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Bu yiman ngadjareniwirrinj kunwarrekenh baybaywi kore kukange ngardduk, wanjh kunukka nawu Kawohrnan Rowk minj nganbekkabekkayi. ");
INSERT INTO gup_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Dja bonj, nungka nawu God woybukkih nganbekkang dja nganwokmey ngaye kore ngahdi yiwarrudj. ");
INSERT INTO gup_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Mah, karriburluburlumen nawu God. Minj nganwokburriweng kore yiwarrudj ngahni bu ngahdjawani, dja minj mak ngurdmeng kore nganmarnedjareni. ");
INSERT INTO gup_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Ngad karrihdi yiwarrudj dja ngundidjawan ngudda God bu kankongibun ngadberre, dja kanmarnekurduyimen kunmak, dja mak kandjalnan mimkongiwern duninjh. ");
INSERT INTO gup_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Kuhni ngarridjare ngudda God ba bu birriwarlahkenh bininj kondah kurorre kabirrihni wanjh ngundikurdunan kore yikurduyime kamak rowk, dja mak kabirriburrbun ngudda nawu yibenngehke bininj kore kubolkbubuyika rowk. ");
INSERT INTO gup_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Ngudda nawu God! Ngad ngarridjare birriwarlahkenh bininj rowk bu ngundidjalburlume ngudda. Bedda nawu kabirrihni kubolkbubuyika rowk, wanjh ngundidjalburlumen! ");
INSERT INTO gup_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Ngudda yibenmarnewohrnan birriwern rowk bu djal mandjad, dja yibenbolhbukkan bininj nawu kabirrihni kubolkbubuyika rowk ba kabirriburrbun kunmakkenh. Kunmekbekenh kunu wanjh birridjalwarlahkenh bininj ngundidjalmarnemarrhmarr dja ngundimarnewayini kore kabirrinjilngmak nguddakenh. ");
INSERT INTO gup_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Yoh, ngudda nawu God, wanjh ngarridjare birriwarlahkenh bininj ngundiburluburlume. Ngarridjare bininj birridjalwern rowk wanjh ngundidjalburlume. ");
INSERT INTO gup_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Kaluk bu kuhni kabirriyime, wanjh ngudda nawu God duninjh ngadberre kanmarneyime kunmak ke, dja yibolkmarnbun ngadberre kunred ba bu manme kawernmerren ngadberre. ");
INSERT INTO gup_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","God wanjh kanmarneyime kunmak, dja bininj rowk nawu kabirrihni kubolkbubuyika rowk, wanjh kabirrimarnekelemen nuye. ");
INSERT INTO gup_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","O God, yirrolkka dja yibenburriwe bininj nawu ngurriyidko ba bu kabirrikelerlobmerren bedda nawu ngundiwidnan. ");
INSERT INTO gup_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Yidjalbubuhmen ba yibenyarlarrkemen yiman kundolng kadjalle bu kunmayorrk kaburriwe. Nawu birriwarre bininj nakka wanjh kabirridarrkidyakayakmen kore kumirrk ke yiman kayime ngolin kakelkdan bu kunak kamre darnkih. ");
INSERT INTO gup_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Dja nawu birrimak bininj kabirrimarrmarr dja kabirrinjilngmakmen kore kumirrk nuye God. Kabirrimarnekayhme bu kunnjilngmak dorrengh nuye. ");
INSERT INTO gup_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Mah wanjh karrimarnewayinin nuye nawu God, karringeyburlumen nuye. Karrimulewa nungka nawu kahre kore kunngol. Nungka wanjh kangeyyo Yawey, dja karridin kumirrk nuye bu kunnjilngmak dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Nungka kahdi kore kunrurrk manrurrkdjamun nuye, dja kabennahnan nawu birrimarladj bininj yiman kayime kornkumo duninjh bedberre. Warridj kabenkukdjurruddi nawu kamahkamarrdjukun. ");
INSERT INTO gup_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","God kabenbolkwon bininj nawu namudyak ba bu kahdi kore bininj nawu kabirriwanjbimang yiman namud duninjh nuye. Warridj kabenbebke bininj nawu kabirribongdi ba kabirrire kamak rowk. Dja bininj nawu kabirriwokburriwe God nuye, wanjh bedda kabirridi kore kubolkdarleh. ");
INSERT INTO gup_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O God, ngudda yibenkani ngudda ke bininj kore yibenmarnedokmi. Ngudda yibenkang kore kubolkdarleh birrirengehrey. ");
INSERT INTO gup_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Ngudda God bedberre nawu Israel benkebmawahmeng, dja ngudda yidjalkudji God kore kunwarddekimuk Sinai. Bu yibebmeng wanjh mahni kurorre bolkrokani kore kumirrk ke, dja mandjewk djakdungi kaddumbeh. ");
INSERT INTO gup_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Ngudda yimarnbom mandjewk bu djakdungi kamak rowk ba bu bolknjurlhkeng ngudda ke kunbolk. ");
INSERT INTO gup_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Dja ngudda ke bininj birribolkmey dja birrihni kumekbe. Ngudda nawu yiwernhkuken duninjh dja yibenwonowong nawu birrimarladj bininj. ");
INSERT INTO gup_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Nawu Kawohrnan Rowk wokrayekwong bininj bedberre, dja birridjalwern birrimulewam kore God yimeng. Wanjh birriyimi, ");
INSERT INTO gup_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Ngurrina! Nawu kings dja bedberre armies wanjh kabirrikelerlobmerren!” Wanjh bininj birrimak kabirrimadjmangi kunmadj nawu birriyidko bedberre birribawong. ");
INSERT INTO gup_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Birringalkeng yehyeng nawu wirlmurrng gold dja silver birrimarnbuni kukyimi mayh nawu doddorok, dja birrinang kunmud ngarre kukbami. Adju, njalekenh yikahwi ngudberre ngurridjaldi kured dja minj ngurridjarrkmeyi namekbe namakmak? ");
INSERT INTO gup_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","God nawu dulkarrekimuk duninjh benburriweng nahni nawu kings kore kubolkkimuk, wanjh munkeweng snow bu mankani kore kuwarddekimuk Zalmon. ");
INSERT INTO gup_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Kunwarddekimuk rowk kore kunbolk Bashan wanjh birribolkmakkaykenh, dja birrikihkimuk rowk. ");
INSERT INTO gup_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Yikahi kabirribarndi kaddum kore mahni kunwarddekimuk, dja njalekenh bedda kabirrinan kunkirn dorrengh, kore God bolkdjarrngbom bu kahdi? Kumekbe wanjh nawu Yawey nungan kadjaldi munguyh munguyh. ");
INSERT INTO gup_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Nawu Kawohrnan Rowk kakarrme wirlbarra nawern duninjh yiman millions. Dja kumwam kore kuwardde Sinai dja ngimeng kore manrurrkdjamun nuye. ");
INSERT INTO gup_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Ngudda God nawu Yawey, ngudda wanjh yibidbom kaddum duninjh dja yibenkani birridjalwern bininj nawu ngudda yibendarrkidmey, dja birriwern bininj nawu ngundiwokweyi, wanjh bonj, ngundidjalwong namakmak rowk. Dja ngudda wanjh yidjaldi munguyh kore ngudda ke. ");
INSERT INTO gup_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Wanjh karriburluburlumen nawu Kawohrnan Rowk. Nungka munguyh kanmarnengorrkan kadberre narrulmuk duninjh manbu karrikarrme. Nungka wanjh God nawu kanngehke. ");
INSERT INTO gup_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Nawu God kadberre, wanjh kanngehke. Nungka Yawey nawu Kawohrnan Rowk kadberre, dja kanngehke kore kundowikenh. ");
INSERT INTO gup_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Woybukkih wanjh God kabenkodjberelhme nawu kabirriwidnan. Bedda nawu kabirridjaldjare kabirrikurduyime kunwarre, wanjh nungka kabenkodjberrelhme bedberre kunkodj rowk. ");
INSERT INTO gup_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Nawu Kawohrnan Rowk kayime, “Ngaye ngabendurndiwe kore kunbolk Bashanbeh, dja mak ngabenbidbuyhwe bedberre kore kurrula kanjdji duninjh. ");
INSERT INTO gup_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Kuhni ngakurduyime ba bu ngudda ngurrimelme kunkurlba nawu ngurriyidko bedberre bu kakurlbare. Dja nawu duruk ngudberre kabirrikurlbabelenghme kunwern.” ");
INSERT INTO gup_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O God, ngudda yiwinhme munguyh bu yidjalle kore yidjare, dja birridjalwern ngundikurdunan. Ngudda nawu God dja mak king ngardduk wanjh yimre kore manrurrkdjamun ke. ");
INSERT INTO gup_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Ngudda ngurrimdjarrke birriwern bininj. Yikahwi nawu kabirriwayinrengehre wanjh kabirrimdokme, dja mak yawkyawk nawu kabirridongohdong tambourines. ");
INSERT INTO gup_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Bu karridjalwern karrimirndemornnamerren nuye, wanjh karriburluburlumen nawu Yawey, ngad nawu Israel kankebmawahmeng rowk. ");
INSERT INTO gup_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Yikahwi kadberre nakka wanjh Benjamin benkebmawahmeng, dja kabirridokdokme rowk bu kabirrire. Dja mak birriwern birrikihkimuk bininj kore nawu Judah benkebmawahmeng wanjh bedda mak karrihni. Dja kabirrihni mak nawu birrikihkimuk bininj nawu Zebulun dja Naphtali bindikebmawahmeng. ");
INSERT INTO gup_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","O God, kanbukka kundulkarre ke manbu karohrok bu kunkareni yikurduyimi kunwern kadberre kunngudj kunkimuk ke dorrengh. ");
INSERT INTO gup_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Bu ngudda yidjalni kore kunred Jerusalem dja yihni manrurrkdjamun ke, wanjh kings nawern kamkan namakmak bu ngundiwon. ");
INSERT INTO gup_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Mah, wanjh yibendu bininj nawu kabirrihni kunbolk Egypt. Nakka yiman yerrih nabang mayh nawu kare kore kurralkkimuk kurrird mankabo. Warridj yibendu birriwarlahkenh bininj kore kubolkbubuyika ba bu ngunmarneboddan dja ngundiwon wirlmurrng silver namakmak. Bedda yiman kayime bulikki birribang, dja wurdwurd bedberre warridj. Dja bininj nawu kabirridjare kabindibun birribuyika, wanjh yibendjalburriwe balehbaleh. ");
INSERT INTO gup_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Bininj nawu Egypt kabirrihni wanjh ngundimarnemunkewe kunwok bedberre. Dja bininj nawu kabirrihni kore kunbolk Ethiopiah, wanjh ngundimarneboddan ngudda nawu God. ");
INSERT INTO gup_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Mah, ngurriwarlahkenh bininj rowk kore kondah kurorre, wanjh ngurrimarnewayinin God. Ngurriburluburlumen nawu Kawohrhan Rowk. ");
INSERT INTO gup_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Ngurriburlumen nungka nawu kare kaddum munguyh munguyh dja bu kawokdi kunkimuk duninjh, wanjh kawokyime yiman namarrkon kangurdulme ");
INSERT INTO gup_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Karrimulewa bu God wanjh Narrulkarrekimuk Duninjh. Nungka nawu kawernhwohrnan Rowk kore bininj nawu Israel benkebmawahmeng. Dja nawu kanbukkan nuye kunngudj kore kaddum. ");
INSERT INTO gup_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Ngudda God nawu yihni manrurrkdjamun ke, wanjh ngudda kankangebarrhke! Ngudda God kadberre nawu Israel kankebmawahmeng, wanjh ngudda kanwon ngad nawu ngudda ke bininj kundulkarre dja kunngudj ke. Mah, wanjh kabirriburluburlumen nawu God! ");
INSERT INTO gup_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Ngudda nawu God, kanngehkemen, dja ngokko 