﻿USE sofia;
DROP TABLE IF EXISTS sofia.guoNT_vpl;
CREATE TABLE guoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guoNT_vpl WRITE;
INSERT INTO guoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Xan, Mateo, amxot lelaxaelen Jesucristo pejwʉajnapijiw pejwʉlan. Jesucristo David pamon. Davidbej Abraham pamon. ");
INSERT INTO guoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham paxʉlan pawʉl Isaac. Isaac paxʉlan pawʉl Jacob. Jacob xabich paxipon. Kaen pawʉl Judá. ");
INSERT INTO guoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá paxi. Kaen pawʉl Fares. Asan pawʉl Zara. Japi pen pawʉl Tamar. Fares paxʉlan pawʉl Esrom. Esrom paxʉlan pawʉl Aram. ");
INSERT INTO guoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram paxʉlan pawʉl Aminadab. Aminadab paxʉlan pawʉl Naasón. Naasón paxʉlan pawʉl Salmón. ");
INSERT INTO guoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón paxʉlan pawʉl Booz. Booz pen pawʉl Rahab. Booz paxʉlan pawʉl Obed. Obed pen pawʉl Rut. Obed paxʉlan pawʉl Isaí. ");
INSERT INTO guoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí paxʉlan pawʉl David. Japon David, reypon Israel tʉajnʉpijiwliajwa. Rey David paxʉlan pawʉl Salomón. Japon pen pawʉl Betsabé. Japow majt Urías pijow. ");
INSERT INTO guoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón paxʉlan pawʉl Roboam. Roboam paxʉlan pawʉl Abías. Abías paxʉlan pawʉl Asa. ");
INSERT INTO guoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa paxʉlan pawʉl Josafat. Josafat paxʉlan pawʉl Joram. Joram paxʉlan pawʉl Uzías. ");
INSERT INTO guoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías paxʉlan pawʉl Jotam. Jotam paxʉlan pawʉl Acaz. Acaz paxʉlan pawʉl Ezequías. ");
INSERT INTO guoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías paxʉlan pawʉl Manasés. Manasés paxʉlan pawʉl Amón. Amón paxʉlan pawʉl Josías. ");
INSERT INTO guoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías paxi. Kaen pawʉl Jeconías. Japamatkoiyan judíos bʉ'fos esclavosliajwa Babilonia paklowax poxade, jaxotde malech tanbichliajwapi Babilonia paklowaxpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Do baxael, judíos kofas wʉt, japi nawia pejtʉajnʉ poxadin. Do jawʉt, Jeconías paxʉlanpon. Japon pawʉl Salatiel. Salatiel paxʉlan pawʉl Zorobabel. ");
INSERT INTO guoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel paxʉlan pawʉl Abiud. Abiud paxʉlan pawʉl Eliaquim. Eliaquim paxʉlan pawʉl Azor. ");
INSERT INTO guoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor paxʉlan pawʉl Sadoc. Sadoc paxʉlan pawʉl Aquim. Aquim paxʉlan pawʉl Eliud. ");
INSERT INTO guoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud paxʉlan pawʉl Eleazar. Eleazar paxʉlan pawʉl Matán. Matán paxʉlan pawʉl Jacob. ");
INSERT INTO guoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob paxʉlan pawʉl José. José pijow pawʉl María. Japow Jesús pen. Jesúslap Cristo, Dios to'aspon jiw bʉ'weliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","David pamjiwkolapikal, Abraham sʉapich, puexa japi catorce. Do baxael, judíos bʉ'fos wʉt esclavosliajwa Babilonia paklowax poxade, japibej catorce matxajʉs wʉt, David sʉapich, pamjiwkolakal. Do baxael, Cristo nalaelt wʉt Judea tʉajnʉxot, japonbej catorce pamjiwkolakal, Babilonia paklowaxxot nawenpi sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo nalaelt wʉt, ma-aech. Jesucristo penaxaelpow, japow pawʉl María. José jʉmdut, asamatkoi japow fisliajwapon. Pe José japow bʉ'moejs-el wʉtfʉk, japow moejow Espíritu Santo pejpamamaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José chiekal pachaempon. Japonliajwa wepachaema-esal tasalaliajwapon japow jiw pejwʉajnalel, masoxtat moejow xotow. Samata, José nejchaxoel kofsliajwapon María. ");
INSERT INTO guoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","José japox nejchaxoelafʉl wʉt, Dios pej-ángel jʉmtispon, xamoejt wʉt: “José, David pamon, ¡nabej nejchaxoele' María fis-elaliajwam nijowliajwa! María paxʉlch faenaxael. Japon nalaelsaxael Espíritu Santo pejpamamaxtat. Japon asamatkoi jiw bʉ'weyaxael. Samata, ¡wʉlduim Jesúswʉltat!” —tis José Dios pej-ángel, xamoejt wʉton. ");
INSERT INTO guoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Puexa japoxan ja-aechlisox, me-ama Dios pejprofeta chajia jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kaeow pawis, chinax poi bʉ'moejs-esalpow, masoxtat moejowaxael. Japow paxʉlchaxael wʉt, poiyaxael. Pawʉlaxaelon Emanuel” —aech Dios pejprofeta. (Japawʉl jʉmchiliajwa: “Dios xatisxot” —chiliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José nathikt wʉt, fitlison María pijowliajwa, me-ama Dios pej-ángel jʉmtispon, xamoejt wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","José bʉ'moejs-el María, japow moejow xot. María paxʉlan nalaelt wʉt, José wʉlduw paxʉlan Jesúswʉltat. Jʉm-aechon: “Pawʉlaxaelon Jesús” —aech José. ");
INSERT INTO guoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús nalaelt Belén paklowaxtat, Judea tʉajnʉxot. Japamatkoiyan Herodes reypon Judea tʉajnʉxot. Japamatkoiyan wʉt, ithaej matabijs pat juimt julanlelsan Jerusalén paklowaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pat wʉti, wʉajnachaemt wʉt, jʉm-aechi: —¿Amxotkat nalaelt judíos pejrey? Xanal taenx ithaejt, yamxʉch pijan, julan wʉt juimt julanlelsan. Samata, xanal fʉlaenx itpaeliajwan sitaeyax japoch yamxʉch —aech ithaej matabijs. ");
INSERT INTO guoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rey Herodes japox wʉltaen wʉt, xabich nejchaxoelon. Jerusalén paklowaxpijiwbej japox wʉltaen wʉt, xabich nejchaxoeli. ");
INSERT INTO guoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Do jawʉt, Herodes to'a pejjiw wʉljaesliajwapi puexa sacerdotespaklochow, judíos chanaekabʉanapibej. Japi pat wʉt Herodesxot, Herodes wʉajnachaemt wʉt, jʉm-aechon japiliajwa: —¿Amxotkat nalaelsaxael Cristo, japon to'axaespon Dios? —aech Herodes. ");
INSERT INTO guoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Japi jʉm-aech: —Nalaelsaxaelon Belén paklowaxtat, Judea tʉajnʉxot. Jasox chajia jʉm-aech Dios pejprofeta lelpox, jʉm-aech wʉt: ");
INSERT INTO guoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Jiw tato'lan nalaelsaxael Belén paklowaxtat, Judea tʉajnʉxot. Japon tato'laxael Dios pejjiw, Israel tʉajnʉpijiw. Samata, Belén paklowax kaes pejme pachaemaxael. Me-ama asapaklowaxan Judea tʉajnʉxot, jachiyaxil’ —aech Dios pejprofeta chajia lelpox —aech sacerdotespaklochow, judíos chanaekabʉanapibej, Herodesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Samata, Herodes maliach wʉllala ithaej matabijs, japi fʉlaeliajwadin Herodes poxadin, japon Herodes matabijsliajwa yamxʉchliajwa. Ithaej matabijs pat wʉt Herodesxot, Herodes jʉm-aech: —¿Maswʉtkatjim xamal matxoela taenam japa-ithaejt? —aech Herodes. ");
INSERT INTO guoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Do jawʉt, Herodes matabijt wʉt, to'apon ithaej matabijs Belén paklowax poxade. To'a wʉt, Herodes jʉm-aech japiliajwa: —¡Xabʉa'de japoxade xaljamch chiekal jalwekaliajwam! Faenam wʉt, ¡xan najʉm-amde, xanbej fʉlaeliajwan itpaeliajwanbej tajsitaeyax japoch xaljamchliajwa! —aech Herodes. ");
INSERT INTO guoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Do jawʉt, ithaej matabijs follisi, rey Herodes to'as poxade. Do jawʉtbej, majt ithaejt taenpox, pejme taeni. Japi taen wʉt japa-ithaejt, xabich nejchachaemili. Do jawʉt, japi itafol wʉt, japa-ithaejt wʉajna dukafʉl. Do baxael, japa-ithaejt napata-ek. Do jawʉt, japa-ithaejt nakthiandik xaljamch okxot. ");
INSERT INTO guoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Do jawʉt, ithaej matabijs lowlisi ba. Jaxot taenlisi xaljamch, pen sʉapich, japow pawʉlpow María. Japi sitaen xot xaljamch, brixtat nuilisi xaljamch pejwʉajnalel. Do jawʉt, fafaklisi pejcha-aelbaúlx. Do jawʉt, juk wʉt, chaxduwlisipon oro, incienso, mirrabej. Puexa japoxan xabich ommaenkpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Do jawʉx, ithaej matabijs jʉmtispi, xamoejt wʉt: “¡Herodes poxade nabej nawe'!” —tisi. Samata, ithaej matabis asanʉamtlel joeya. Jasoxtat ithaej matabijs nawia pejtʉajnʉ poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ithaej matabijs chijia wʉt, do japamadoitat, José moejt wʉt, xamoejton Dios pej-ángel. Do jawʉt, jʉmtispon: “¡Nande! ¡Bʉflaem xaljamch, pen sʉapich, Egipto tʉajnʉ poxade! ¡Jaxotde duilmach! Asamatkoi xam pejme jʉmchiyaxaelen xaljamch bʉnwiasliajwam. Malis xaljamch pen. Amalis Herodes xaljamch wʉlwekaxael boesaliajwaspon” —tis, José xamoejt wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dolisdo', José nathikt wʉt, japamadoitat bʉflaechlison xaljamch Egipto tʉajnʉ poxade. Malis xaljamch pen. ");
INSERT INTO guoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egipto tʉajnʉxot piach duili. Do baxael, Herodes tʉp wʉt, pejme kaxa nawenlisi. Me-ama Dios pejprofeta chajia jʉm-aech Dios jʉm-aechpox, jʉm-aech wʉt paxʉlanliajwa: “Taxʉlan wʉllalaeyaxaelen pejme nawiasliajwa Egipto tʉajnʉxotdin” —aech Dios jʉm-aechpox paxʉlanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Do jawʉt, Herodes pajut matabijt wʉt ithaej matabijs asanʉamtlel joeyapox, jawʉt xabich palalapon japiliajwa. Samata, pejsoldaw keto'apon yamxi poejiwkal beliajwapi, kolewaechanpi, kaes jampibej, japi duili Belén paklowaxxot, paklowax tathoetlel duilpi paxibej. Jasox keto'apon, nejchaxoel xot ithaej matabijs chajia jʉm-aechpox Jesús nalaelsaxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Japox ja-aechlisox, me-ama Jeremías, Dios pejprofeta chajia lelpox jʉm-aech yamxi beyaxaespoxliajwa: ");
INSERT INTO guoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Do jawʉt, puexa jiw jʉmtaeyaxael xabich wʉnowpoxan Rama paklowaxxot. Japi watho', Raquel pamojiw, xabich pinjametat wʉnoeyaxaeli, paxi nejxaejwas xoti. Japi watho' kofaxil paxi nejxaejwaspoxan” —aech profeta Jeremías chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baxael, asamatkoi, Herodes tʉp wʉt, José Egipto tʉajnʉxot Dios pej-ángel jʉmtispon, xamoejt wʉt: ");
INSERT INTO guoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“¡Nathikde! ¡Bʉflaem yamxʉlan, pen sʉapich! ¡Nawem Israel tʉajnʉ poxade, yamxʉlan boesasiapi, japi puexa chiekal tʉp xotlisi!” —tis José Dios pej-ángel. ");
INSERT INTO guoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Do jawʉt, José nant wʉt, bʉ'follison yamxʉlan Israel tʉajnʉ poxade. Malis yamxʉlan pen. ");
INSERT INTO guoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jawʉt, José wʉltaen wʉton Arquelao reypox Judea tʉajnʉxot pax Herodes pejwʉlela, José xabich pejlewla Arquelaoliajwa. Samata, Joséliajwa pachaema-el namanaliajwapon japatʉajnʉxot. Madoi José moejt wʉt, Dios jʉmtispon. Do jawʉt, Dios fiachpon namanasamata Judea tʉajnʉxot. Samata, matnoch xenton Galilea tʉajnʉ poxaliajwade. ");
INSERT INTO guoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","José bʉ'fol pijow, yamxʉlanbej, duilaliajwa Nazaret paklowaxxot. Samata, Dios pejprofeta chajia jʉm-aechpox Dios pijaxtat, japox ja-aechlisox. Profeta chajia jʉm-aech Jesúsliajwa: “Japon Nazaret paklowaxpijnaxael” —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Do baxael, japamatkoiyan wʉt, Juan, jiw bautisan, naewʉajan jiw pajilaxtat, Judea tʉajnʉxot, papat wʉti japonxot. ");
INSERT INTO guoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan jiw naewʉajan wʉt, jʉm-aechon: “¡Kofim babijaxan isfʉlampoxan! ¡Isfʉldelax Dios nejxasinkpoxan! ¡Dios puexa pejjiw tato'laxaelmatkoi mox pawʉajna!” —aech Juan. ");
INSERT INTO guoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaías, Dios pejprofeta, chajia lelon Juanliajwa. Jaxot jʉm-aechon, lel wʉt: “Kaen aton pasaxael. Japon pinjametat jiw naewʉajnafʉlaxael pajilaxtat. Japon jʉmchiyaxaelbej jiwliajwa: ‘¡Babijaxan isfʉlampoxan kofim wajpaklonliajwa! Me-ama jiw wʉajna nʉamt chiekal chaemt paklon pasliajwa, ¡xamalbej ja-amde nejnejchaxoelaxantat! ¡Isfʉlde Dios nejxasinkpoxan!’ —chiyaxaelon pajilaxtat” —aech Isaías, chajia lel wʉt Juanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan naxoelox baels camellolatat. Japox pakchowax. Pejcinturónmʉat pabʉ'tkal. Pejnaxaeyax, me-ama sui'. Afpon miel. ");
INSERT INTO guoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Do jawʉt, Jerusalén paklowaxpijiw fʉlaeni Juanlel, taeliajwapi. Fʉlaenbej Judea tʉajnʉpijiw. Mox duili Jordánlajtxot, japibej fʉlaen. Japi jiw fʉlaen naewesliajwa Juan naewʉajanpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Japamatkoiyan japi pajut chapaei babijaxan ispoxan Dios beltaeliajwas. Do jawʉx, Juan japi jiw bautisa Jordánlajtxot. ");
INSERT INTO guoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Do jawʉt, xabich fariseos, saduceosbej, fʉlaenbejpi Juan jiw bautisafʉlxot. Do jawʉt, Juan japi jiw taen wʉt, jʉm-aechon japiliajwa: “Xamal, me-ama jom, dʉkpi weliajwa jit boejtaen wʉt, ja-am. Pe asamatkoi, xamal tʉpam wʉt, weyaximil, pat wʉt kastikamatkoi. ");
INSERT INTO guoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Samata, ¡kofim babijaxan isfʉlampoxan! Do jawʉx, ¡isfʉlde Dios nejxasinkpoxan! Jasox isfʉlam wʉt, jiw matabijaxael, diachwʉajnakolax xamal babijaxan isfʉlampoxan kofamlis. ");
INSERT INTO guoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","¡Xamal nakaewa nabej najʉm-aeche': ‘Xatis Abraham pamojiwas. Samata, diachwʉajnakolax Dios xatis nakbʉ'weyaxael’ —nabej aeche' nakaewaliajwa! Pe nakiowa, babijaxan isfʉlam wʉt, Dios xamal bʉ'weyaxil. Dios nejxasink wʉt, ampa-ia' Abraham pamojiw kiladofaxaelon. ");
INSERT INTO guoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Xamal naebaechnaechan liktam, naboes-elnaechan. Do jawʉx, jitat it-owam. Jachiyaxaellap-is Dios, xamal kastika wʉt, naexasis-emil wʉt Dios” —aech Juan, jiw bautisan, babijaxan ispiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Juan pejme jʉm-aech: “Diachwʉajnakolax xan jiw bautisax mintat, kofa wʉti babijaxan isfʉlpoxan japi Dios naexasisfʉlaliajwa. Pe mox pawʉajna kaen fʉlaeyaxaenpon, japon kaes pejme paklonaxael. Me-ama xan, jachiyaxilon. Xan omjinil japon pejkajachawaesnanliajwa. Fʉlaeyaxaenpon, japon Espíritu Santo to'axael jiw kajachawaesfʉlaliajwas. Espíritu Santo pejpamamax, me-ama jit, jiw babijaxan ispi wetoejwaliajwas, japi jiw pachaemaliajwa Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Lulpijin trigo matbokkiyan, batat cha-owaliajwa trigo. Trigobok, trigotonanbej, pelton lausliajwa. Jachiyaxaelbej fʉlaeyaxaelpon. Japon tamejaxael jiw pachaempikal Diosxotse, japi jiw, Dios naexasiti. Asew, babijaxan ispi, japi Dios naexasis-eli, pelsaxaes jitadik, itkʉawaxil poxadik” —aech Juan puexa jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Do jawʉt, Jesús Galilea tʉajnʉxot nakolt wʉt, fʉlaechon Jordánlajt poxade, Juan bautisaliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Do jawʉt, Juanlax jʉm-aech Jesúsliajwa: —Xam kaes paklonam. Me-ama xan, jachi-emil. Samata, kaes pachaem xan nawoesa nabautisaliajwam —aech Juan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pe Jesús jʉmnot wʉt, jʉm-aechon Juanliajwa: —¡Xamlax isde japox amwʉt! Pachaem isliajwas puexa Dios naktato'alpox —aech Jesús Juanliajwa. Do jawʉt, Juan ow-aech. ");
INSERT INTO guoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jawʉt Juan bautisa Jesús. Jesús julan wʉt mintat, jawʉt taenon athʉ fafachpox. Jawʉt Espíritu Santo fʉloek a-utat japon pejmatwʉajasik. Me-ama a-ut, kabʉan-aech Espíritu Santo. ");
INSERT INTO guoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Do jawʉt, Dios pajut jʉm-aechsik: “Amponlap taxʉlan, xabich nejxasinkaxpon. Xan xabich nejchachaemlax japonliajwa” —aech Dios Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Do jawʉx, Jesús Espíritu Santo bʉ'fos pajilax poxade, jaxotde Jesús xapaejsliajwas Satanás babijax isliajwapon. ");
INSERT INTO guoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Japamatkoiyan Jesús chinax naxae-el cuarenta matkoiyan Dios piach kawʉajnafʉlaliajwa. Samata, Jesús xabich litaxaela. ");
INSERT INTO guoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Do jawʉt, Satanás fʉlaen xapaejsliajwapon Jesús babijax isliajwa. Do jawʉt, Satanás jʉm-aech Jesúsliajwa: —Diachwʉajnakolax xam Dios paxʉlnam wʉt, ¡ampi ia' to'im pan nadofaliajwa! —aech Satanás Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús jʉmnot wʉt, jʉm-aechon: —Dios pejjamechan, chajia lelspox jʉm-aech: ‘Jiw duilaxil naxaeyaxankalliajwa. Jiw wewe'pasbej Dios pejjamechan naexasisfʉlaliajwa’ —aechox —aech Jesús Satanásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Do jawʉt, Satanás pejme xapaejsliajwa wʉt, bʉ'fos Jesús Jerusalén paklowax poxade. Bʉ'foson Dios pejtemploba matwʉajase, kaes athʉ poxase. Jaxotse nosas Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Do jawʉt, Satanás jʉm-aech: —Diachwʉajnakolax xam Dios paxʉlnam wʉt, ¡ma amxot diwmik satadik! Xam naxbijaximil sat. Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox: ‘Dios to'axoek pej-ángeles xam chiekal tataeflaliajwapi. Diwmik wʉt, xam jaelsabaxaeli naxbijasamatam ia', najalasamatambej’ —aech Dios pejjamechan, chajia lelspox —aech Satanás Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús jʉmnot wʉt, jʉm-aechon: —Xan diwaxinil. Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechbejpox: ‘¡Nabej xapaejs nejpaklokolan Dios, asbʉan jʉmch taeliajwam diachwʉajnakolax xam weyaxaelam wʉt!’ —aech Dios pejjamechan, chajia lelspox. Xan chiekal matabijtax Dios natataeflafʉlpox. Xan xapaejsaxinil tajpaklokolan Dios —aech Jesús Satanásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Do jawʉx, Jesús xapaejtas wʉt Satanás, bʉ'foson pinamʉax matwʉajase, xabich athʉ poxase. Jaxotse Jesús itpaeis potʉajnʉchan, popaklowaxanbej, ampathatat. Itpaeisbejpon puexa xabich pachaempoxan, ampathatatpi. ");
INSERT INTO guoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Do pejme Satanás jʉm-aech Jesúsliajwa: —Puexa taenampoxan xam chaxdusaxaelen, xan tajwʉajnalel brixtat nukam wʉt, najʉm-am wʉtbej: ‘Xam xabich pachaemam. Xam tajpaklokolnam’ —na-am wʉt —aech Satanás Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús jʉmnot wʉt, jʉm-aechon Satanásliajwa: —Satanás, ¡chijiamde xanxot! Xam sitaeyaxinil. Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox: ‘Kaen, Dios, jiw pejpaklokolan. ¡Japonkal sitaem! ¡Naexasisfʉldebej!’ —aech Dios pejjamechan, chajia lelspox —aech Jesús Satanásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Do jawʉt, Satanás chijia Jesúsxot. Jawʉtbej Dios pej-ángeles fʉloek Jesús kajachawaesliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Do jawʉx, Jesús wʉltaen Juan, jiw bautisan, jiaspox jiw jebatat. Jawʉt Jesús nawia'an Galilea tʉajnʉ poxadin. ");
INSERT INTO guoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Do jawʉt, nakoltlison Nazaret paklowaxxot dukaliajwa Capernaum paklowaxxot. Japapaklowax Galilea pukababʉ'tat. Zabulón tʉajnʉ, Neftalí tʉajnʉbej, jaxot mox. ");
INSERT INTO guoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dolisdo', ampox ja-aech jachiliajwa Isaías chajia lelpox. Japon chajia lelpox jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Zabulón tʉajnʉ, Neftalí tʉajnʉbej jaxot mox Galilea puka, Jordánlajt wesklel. Jaxot, Galilea tʉajnʉxot, asew jiw duil. Japi judíos-el. Japi matabija-el Dios pejtato'laxan. Samata, japi jiw, me-ama duili itkʉataxxot, ja-aechi. Pe asajiw naewʉajnas wʉti, japi jiw naexasisaxael Dios tato'alpox. Ja-aech wʉt, japibej bʉ'weyaxaes Dios. Do ja-aech wʉt, japi pejnejchaxoelaxan, me-ama itliak wʉt, jachiyaxael. Do ja-aech wʉtbej, japi, me-ama nanʉamsaxael itliakaxxot” —aech Isaías chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Do japamatkoiyan wʉt, Jesús naewʉajan wʉt, jʉm-aechon: “Wʉajnawechmatkoi mox pawʉajna Dios puexa pejjiw tato'laxaelpox. Samata, ¡kofim babijaxan isampoxan, isliajwam Dios nejxasinkpoxan!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús laeja wʉt Galilea pukababʉ'tat, taenpon kolenje nabaxisiw. Kaen pawʉl Simón. Japon asawʉl Pedro. Asan pawʉl Andrés. Japi kolenje nakaewa. Japi xawawael baxi tarayatat pukaxot, japi nabaxisiw xot. ");
INSERT INTO guoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús jʉm-aech japiliajwa: —¡Xabʉa't! ¡Xan nakfʉlaem matabijaliajwam xan naewʉajanaxpoxan! Xamal matabijam nabaxisaxan. Baxi xawawaelam wʉt, notam. Jasoxtatbej xamal itpaeyaxaelen jachiliajwam jiwliajwa, japi jiwbej tajnachalaliajwa, Dios pejjiwaliajwabejpi —aech Jesús japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Do jawʉt, pejew tarayan waela wʉti, nakfollisi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesús kaes fʉlaech wʉt, kolenje nabaxisiw taenpon. Japi kolenje, nakaewa. Kaen pawʉl Santiago. Asan pawʉl Juan. Japi Zebedeo paxi. Pax sʉapich, chaemti tarayan falkamtat. Jesús japi kolenje tadʉton japi pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Do jawʉt, pax waeltlisi falkamtat. Jawʉt japi kolenje nakfollisi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús nanʉamt puexa Galilea tʉajnʉxot. Naewʉajnafʉlbejpon judíos naewʉajnabachanxot chimiawʉajan, Dios puexa pejjiw tato'laxaelwʉajan. Boejthʉtbejpon jiw, nejmachwaxaetat bʉ'xaenki. ");
INSERT INTO guoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Puexa Siria tʉajnʉpijiwbej wʉltaenapi Jesús. Samata, japi bʉflaen nejmachwaxaetat bʉ'xaenki Jesús poxadin. Bʉflaeni xabich nabijati xaeyaxantat. Bʉflaenbejpi asew dep webaespi pejmatpʉatanxot. Bʉflaenbejpi asew, me-ama na-achapi dep pijaxtat. Bʉflaenbejpi asew laelpaxilpi. Japi puexa Jesús chiekal boejthʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Xabich jiw Jesús fʉlafos. Japi Galilea tʉajnʉpijiw, Decápolis tʉajnʉpijiwbej, Jerusalén paklowaxpijiwbej, Judea tʉajnʉpijiwbej, Jordánlajt wesklel duilpibej. ");
INSERT INTO guoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Xabich jiw papat Jesús naewʉajanxot jʉmtaeliajwa japon naewʉajanpoxan. Jesús japi taen wʉt, mʉax kaesʉapich athʉxot ekon japi jiw naewʉajnaliajwa. Pejnachala kaes chiekal mox Jesús ekxot. ");
INSERT INTO guoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Do jawʉt, Jesús naewʉajan pejnachala, xabich asew jiwbej. ");
INSERT INTO guoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jesús naewʉajan wʉt, jʉm-aechon pejnachalaliajwa, xabich asew jiwliajwabej, japamʉaxxot: “Jiw pejnejchaxoelaxtat jʉm-aech wʉt: ‘Dios nakkajachawaes-el wʉt, xatis wajut isaxisal pachaempoxan’ —aech wʉti, nejchaxoel wʉt, japi jiw Dios kajachawaesaxaes. Ja-aech wʉt, japi xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Jiw nejxaejwaspi, nabijat xoti ampathatat, japi jiw Dios kajachawaesaxaes pachaemaliajwa. Ja-aech wʉt, xabich nejchachaemlaxaeli. ");
INSERT INTO guoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Jiw pachaempi pejnejchaxoelaxantat, japi nejchaxoel wʉt, nejchaxoela-el ampox: ‘Xan kaes pejme pachaeman. Me-ama asew jiw jachi-enil’ —chi-eli, nejchaxoel wʉt. Japi jiwlap Dios chaxduiyaxaes pachaempox, chajia jʉmduchpox. Ja-aech wʉt, xabich nejchachaemlaxaeli. ");
INSERT INTO guoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Jiw isasiapi pachaempoxan Diosliajwa, Dios kajachawaesaxaesi isliajwa japoxan. Ja-aech wʉt, japi jiw xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Asew jiw beltaen wʉti asew, japi kajachawaet wʉtbej asew, japi jiwlap Dios kajachawaesaxaes. Dios beltaeyaxaesbejpi. Ja-aech wʉt, japi jiw xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Jiw pejnejchaxoelax pachaempi Diosliajwa, japi jiw taeyaxael Dios, duil wʉti Diosxotse. Ja-aech wʉt, japi jiw xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Wʉajanchaemtpi jiw nabe-elaliajwa, padaelmajiw sʉapich, japi jiwlap Dios paxiyaxael. Ja-aech wʉt, japi jiw xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Jiw nabijatpi asew jiw pijaxtat, naexasisfʉl xoti Dios tato'alpox, japi Dios kajachawaesaxaes. Ja-aech wʉt, japi jiw xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Xan nanaexasitam xot, asew jiw babejjamechan xamal jʉmchiyaxael. Isaxaelbejpi babijaxan xamalliajwa. Japibej jʉmchiyaxael xamalliajwa nejmachkichachajbaxtat. Ja-aech wʉt, Dios isaxael xabich pachaempox xamalliajwa japonxotse. Samata, ¡nejchachaemilde! Chajia xamal wʉajna Dios pejprofetasbej nabijat, asew jiw is wʉt babijaxan japiliajwa” —aech Jesús, naewʉajan wʉt japamʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Do pejme Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Dom pachaem. Dom xakuenka-el wʉt, chiekal chaemil. Ja-aech wʉt, pachaem thokchaliajwa nʉamtat jiw sae'enaliajwa. Xamal ampathatat, me-ama dom pachaem wʉt, ja-am. Ja-am wʉt, xamal pachaemaxaelam asew jiwliajwa ampathatat. Pachaema-emil wʉt asew jiwliajwa, xamal, me-ama dom thokchaxaespi nʉamtat, jachiyaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Xamalbej ampathatat, me-ama itliakam wʉt, ja-am. Itkʉataxxot itliak wʉt, puexa jiw chiekal taen, me-ama paklowax mʉaxmatwʉajtat wʉt, ajil namoechaliajwa. Puexa jiw chiekal taeyaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jiw lámpara tamdut wʉt, cajóntat chamatakasaxil. Jiwlax athʉ cha-esaxael bamʉaxnaetat puexa chiekal taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Samata, ¡xamalbej chiekal duilde asew jiw taeliajwa xamal isampoxan! Asew jiw taen wʉt xamal isampoxan, pachaempoxan, ja-aech wʉt, japi jiw naksiyaxael chimiajamechan nej-ax Diosliajwa, japon athʉxotsepon” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Do pejmebej, Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej mʉaxxot: “Xamal nejchaxoelam wʉt xanliajwa, xamal jʉm-am: ‘Japon pat toesliajwa Moisés chajia lelpox, Dios pejprofetas lelpoxanbej’ —am xamal xanliajwa, nejchaxoelam wʉt. Xan pas-enil toesliajwan japoxan. Xanlax patx chiekal isliajwan profetas lelpoxan xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Diachwʉajnakolax xan jʉm-an. Ampathat, thatbaxobej, toepa-el wʉtfʉk, Dios pejtato'laxan, Moisés chajia lelpox, nakiowaxaelfʉk. Chinax nafo'axil kaelet. Nafo'axilbej kaejame, Dios pejjame. Puexa Dios chajia jʉm-aechpox, japoxan diachwʉajnakolax jachiyaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Samata, nejmachjiw chiekal naexasis-el wʉt puexa Dios pejtato'laxan, japi jiw naewʉajan wʉtbej asew jiw chiekal naexasis-elaliajwa puexa Dios pejtato'laxan, ja-aech wʉt, japi jiw chiekal sitaeyaxisal, Diosxotse wʉt, Dios tato'alxotse. Pe chiekal naexasitpilax puexa Dios pejtato'laxan, japi naewʉajan wʉtbej asew jiw chiekal naexasisliajwa puexa Dios pejtato'laxan, ja-aech wʉt, japi jiw xabich sitaeyaxaes Diosxotse, Dios tato'alxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Diachwʉajnakolax xan jʉm-an. ¡Xamal naexasisfʉlde Dios pejtato'laxan! Me-ama fariseos, judíos chanaekabʉanapibej, ¡nabej ja-aeche' xamal! ¡Xabich kaes naexasisfʉlde Dios! Jachi-emil wʉt, xamalbej pasaximil Diosxotse, Dios jiw tato'alxotse” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox wajwʉajnapijiwliajwa: ‘¡Nabej be' asew jiw! Asew jiw bam wʉt, asew jiw xamal kastika wʉt, xamalbej beyaxaeli’ —aechox. Xamal chajia japox chiekal matabijam. ");
INSERT INTO guoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pe xamal pejme jʉm-an ampox. Nejmach-aton palala wʉt asan atonliajwa, japon aton pejbʉ'wʉajan Diosliajwa. Ja-aech wʉt, japon aton kastikaxaeson Dios. Nejmach-aton jʉm-aech wʉtbej babejjamechan asan atonliajwa, japon aton pejbʉ'wʉajan Junta Supremapijiwliajwa. Samata, japon aton kastikaxaes. Nejmach-aton palala wʉt, jʉm-aech wʉtbejpon asan atonliajwa: ‘Xam atonam nejliaklanam’ —aech wʉton asanliajwa, japon aton Dios kastikaxaes infiernoxotdik. ");
INSERT INTO guoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Xam xafolam wʉt nej-ofrenda Diosliajwa, jawʉt nejchafaetam wʉt aton palalapon xamliajwa, ¡jawʉt nej-ofrenda o'e altarxot Dios pejtemplobatat! ¡Jawʉt xabʉa'de japon aton poxade, palalapon xamliajwa! Faenam wʉt, ¡chiekal chaemde, japon aton sʉapich! Do jawʉx, ¡kaxa fʉlaemen nej-ofrenda Dios chaxdusliajwam! Ja-am wʉt, Dios nejchachaemlaxael nej-ofrendaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Xam babijax isam wʉt asanliajwa, japon xam bʉ'fol wʉt juez poxade jʉmchiliajwapon nejbʉ'wʉajanpoxliajwa, kaes pejme pachaem tamach chaemsliajwam japox wʉajan, japon sʉapich, pas-emil wʉtfʉk juezxot. Japox wʉajan chaems-emil wʉt, japon xam wiasaxael juezxot jʉmchiliajwa nejbʉ'wʉajanpoxliajwa. Do jawʉx, japon xam wiasaxael soldawxot xam jeliajwa jiw jebatat. ");
INSERT INTO guoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Diachwʉajnakolax xan jʉm-an: ‘Japon japox is wʉt, xam nakolsaximil jiw jebaxot, hasta puexa japoxan mos-emil wʉt’ —an xan” —aech Jesús pejnachalaliajwa, xabich asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Moisés chajia lelpox jʉm-aech: ‘¡Nabej bʉ'moejs asew watho', nijwa-elpow!’ —aechox. Xamal chajia japox matabijam. ");
INSERT INTO guoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pe amwʉtjel, xan jʉm-anlax ampox. Xam pawis taenam wʉt, bʉ’ moejsax bʉ'nejchaxoelam wʉt, ja-am wʉt, isam babijax japanejchaxoelaxtat japow pawisliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Isam wʉt babijax, taenampox nej-itfutat, ja-am wʉt, kaes pejme pachaemaxael najut na-itfukusliajwam. Do jawʉx, ¡nej-itfut kutampox atʉaj fo'im xamxot! Ja-am wʉt, kaes pejme pachaemaxaelam nej-itfut kaeyax, nafo'a wʉt, Dios xam fo'asamata infierno poxadik. ");
INSERT INTO guoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Isam wʉt babijax nejpoklake-etat, najut naketariowcham atʉaj fo'aliajwam. Ja-am wʉt, kaes pejme pachaemaxaelam, xam nejke-e nafo'a wʉt, Dios xam fo'asamata infierno poxadik” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Moisés chajia lelpox jʉm-aech: ‘Aton pijow fo'asia wʉt, japon pelfʉt lelaxael pijowliajwa. Japapelfʉtxot lelaxaelon, ma-aech xot fo'axaelon pijow. Do jawʉx, chaxdusaxaelon pijow japapelfʉt’ —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pe amwʉtjel xan jʉm-anlax ampox. Poi asbʉan jʉmch masoxtat pijow fo'axil, japow asan poi bʉ'moejs-el wʉt. Pe nakiowa, japon masoxtat pijow fo'a wʉt, ja-aech wʉt, japon pejbʉ'wʉajan Diosliajwa. Asan aton fit wʉtbej fo'aspow, bʉ'moejtas wʉtbejpow, ja-aech wʉtbej, japowbej pejbʉ'wʉajan Diosliajwa. Japon fo'aspow fit xot, japonbej pejbʉ'wʉajan Diosliajwa, bʉ'moejt xoton fo'aspow, Diosliajwafʉk japow nakiowa pamal” —aech Jesús pejnachalaliajwa, xabich asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Xamal jʉmtaenambej nejwʉajnapijiw tato'laspox Dios. Japox jʉm-aech: ‘Xam jʉmdutam wʉt isaxaelampox Diosliajwa, ¡japox chiekal isde!’ —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pe xan jʉm-an. Jʉmduwam wʉt isaxaelampox, ¡kaes asaxantat nabej jʉmdui'! Jʉmduwampoxan isaxaelam wʉt, ¡chiekal jʉm-amde! ¡Kaes asax nabej jʉm-aeche' asew jiw asbʉan jʉmch xamal naexasisliajwa jʉmduwampoxanliajwa! ¡Nabej jʉm-aeche': ‘Diachwʉajnakolax xan isaxaelen jʉmdutxpox, Dios pijaxtat jʉmdutxxot’ —nabej aeche'! ¡Nabej jʉm-aeche'bej: ‘Diachwʉajnakolax xan isaxaelen jʉmdutxpox, puexa athʉxotse pijaxtat’ —nabej aeche', Dios pajut jaxotse duk xot! ");
INSERT INTO guoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","¡Nabej jʉm-aeche'bej: ‘Diachwʉajnakolax xan isaxaelen jʉmdutxpox, jʉmdutxxot puexa ampathat pijaxtat’ —nabej ja-aeche', Dios is xot ampathat! ¡Nabej jʉm-aeche'bej: ‘Diachwʉajnakolax xan isaxaelen jʉmdutxpox, jʉmdutxxot Jerusalén paklowax pijaxtat’ —nabej aeche'bej, Dios kaen wajpaklokolan japon pejpaklowax xot! ");
INSERT INTO guoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","¡Nabej jʉm-aeche'bej: ‘Diachwʉajnakolax xan isaxaelen jʉmdutxpox, tajnejchaxoelaxtat jʉmdutx xot’ —nabej aeche' asanliajwa, xamal papoeilat kiladofaximil nejmatlat xot! ");
INSERT INTO guoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jʉmdutampox isaxaelam wʉt, ¡chiekal jʉm-amde: ‘Xan japox isaxaelen’ —amde! Is-elasiam wʉt, ¡kamta chiekal jʉm-amde: ‘Xan japox isaxinil’ —amde! Kaes asaxan jʉmchiyaximil. Kaes asaxan jʉm-am wʉt, pelisdo' xam jʉmchiyaxaelam Satanás pijaxtat” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Moisés chajia lelpox jʉm-aech: ‘Aton nej-itfut tabejt wʉt, ¡japon pej-itfutbej xam tabejde! Aton nejbʉa't jala wʉt, ¡japon aton pejbʉa'tbej xam jalim!’ —aech Moisés chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pelax xan jʉm-an. Aton babijax is wʉt xamliajwa, ¡xam nabej is babijax japonliajwa! Asan xam xutula wʉt, ¡tapaem asaxulelbej tulaliajwapon! ");
INSERT INTO guoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Asan xam dewatam xot, japon jʉmchisia juez pejwʉajnalel xam dewatampoxanliajwa. Jawʉt, japon wʉljow wʉt nejkamis, ¡japox chaxdu'e! ¡Chaxdu'ebejpon thʉch naxoelampox! ");
INSERT INTO guoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Soldawan xam xato'a wʉt kaekilómetro xalaeyax, ¡xam xalaem kolekilómetros! ");
INSERT INTO guoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nejmach-aton, xabich wewe'paspon wʉt, japon wʉljow wʉt malech, ¡chaxdu'e wʉljowpox! Asan xam wʉljow wʉt nijax, ¡el nabej aeche'!” —aech Jesús, jiw naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Moisés chajia lelpox jʉm-aech: ‘¡Nejxasinkde nejnachala! ¡Pelax nejweslade nadaelmajiw!’ —aechox. Xamal japox chiekal matabijam. ");
INSERT INTO guoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pelax amwʉtjel xan jʉm-an. ¡Xamal nejxasinkde nadaelmajiw! ¡Japiliajwa Dios kawʉajandebej, japi is wʉt babijaxan xamalliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ja-am wʉt, japi jiw matabijaxael, nej-ax Dios, japon paximpim, athʉxotsepon. Nej-ax Dios to'a masxaeyax jiw babejchowliajwa, pachaempiliajwabej. To'abejpon iam babejchowliajwa, pachaempiliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Xamal nejxasinkam wʉt xamal nejxasinkpikal, ja-am wʉt, xamal is-emil pachaempox asew jiwliajwa. Impuesto kenoti Roma gobiernoliajwa, japibej nakaebabejchow nanejxasink. ");
INSERT INTO guoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kejacham wʉt xamal nejxasinkpikal, ja-am wʉt, xamal kaes pejme pachaempox is-emil asew jiwliajwa. Dios naexasis-elpi, japibej nakaewa nakejacha. ");
INSERT INTO guoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","¡Isfʉlde puexa pachaempoxan! Me-ama nej-ax Dios, athʉxotsepon, isfʉl pachaempoxan, ¡xamalbej ja-amsfʉlde!” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Isaxaelam wʉt pachaempoxan, ¡japoxan isde! Japoxan isaxaelam wʉt, ¡nabej is asbʉan jʉmch asew jiw xamal taeliajwa pachaempoxan isampoxan! Japoxan isaxaelam wʉt asbʉan jʉmch asew jiw taeliajwa, ja-am wʉt, nej-ax Dios, japon athʉxotsepon, chaxduiyaxil jʉmdutpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Samata, kejila kajachawaetam wʉt, ¡asew jiw nabej lae', japi taeliajwa xamal kajachawaetampox! Asew jiw lam wʉt kajachawaetampox taeliajwa, ja-am wʉt, xamal, me-ama naekichachajbapijiw jachiyaxaelam. Naekichachajbapijiw pat wʉt judíos naewʉajnabachanxot, japi kajachawaet kejila, o, paklowaxthialaxanxot wʉtbej, japi japoxan is asew jiw taeliajwas. Diachwʉajnakolax xan jʉm-an. Japi asew jiw sitaens xot, japox, me-ama moch wʉt, jatispi. Samata, Dios mosaxisal japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Xamallax kejila kajachawaetam wʉt, ¡nabej chapae' asan aton! Nejnachalan, kaes nejxasinkamponbej, ¡nabej chapae'! ");
INSERT INTO guoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kejila kajachawaetam wʉt, ¡kajachawae'e maliach! Do jawʉt, nej-ax Dios, taenpon maliach isampoxliajwa, japon xamal mosaxael maliach kajachawaetampoxliajwa kejila” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, chanaekabʉana wʉt mʉaxxot: “Xamal Dios kawʉajnam wʉt, ¡nabej kawʉajne', me-ama naekichachajbapijiw! Japi Dios kawʉajan wʉt, nejxasink nuilaliajwa asew jiw pejwʉajnalel judíos naewʉajnabachanxot, o, paklowaxthialaxanxot wʉt. Diachwʉajnakolax xan jʉm-an. Japi asew jiw sitaens xot, me-ama moch wʉt, jatispi. Samata, Dios mosaxisal japi. ");
INSERT INTO guoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Xamallax Dios kawʉajnam wʉt, ¡fʉlaem nejba poxade, Dios kawʉajnaliajwam wʉt! Ba lowam wʉt, ba faka'tam wʉtbej, do jawʉt, ¡nej-ax Dios kawʉajande! Do jawʉtbej, nej-ax Dios, japon matabijtpon maliach isampoxanliajwa, japoxanliajwa xamal mosaxaelon. ");
INSERT INTO guoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Dios kawʉajnam wʉt, ¡kaeyaxkal nabej kawʉajne'! Me-ama Dios matabija-eli kaeyax kawʉajnak, ¡xamal nabej ja-aeche'! Japi nejchaxoel chiekal matabija-elaxtat: ‘Kaeyax kawʉajnakas wʉt, Dios naknaewesaxael’ —aechi asbʉan jʉmch, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Xamal, me-ama japi, ¡nabej ja-aeche'! Nej-ax Dios chajia chiekal matabijt xamal wewe'ppoxan, japon wʉljoe-emil wʉtfʉk. ");
INSERT INTO guoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Samata, xamal Dios kawʉajnam wʉt, ¡jʉm-amde: ‘Ax Dios, xam athʉpijnam, ¡puexa jiw xam nej sitae'! ");
INSERT INTO guoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","¡Puexa nejjiw tato'laxaelammatkoi nej tʉadus! Amwʉtjel xamxotse puexa nej-ángeles isfʉl, me-ama xam nejxasinkam. Jasoxtatbej puexa jiw, ampathatpijiw, ¡nej is xam nejxasinkampoxan! ");
INSERT INTO guoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","¡Ma amwʉt xanal naxaeyaxan nachaxduim, nawewe'ppoxan! ");
INSERT INTO guoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","¡Xanal nabeltaem babijaxan isxpoxanliajwa! Me-ama asew jiw xanal beltaenx, japi babijaxan is wʉt xanalliajwa, ¡ja-amdebej xanalliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","¡Nabej tapae' Satanás xanal naxapaejaliajwa, babijaxan isasamatan! ¡Xanal nakajachawae'e babijaxan isasamatan! Xam kaenam paklokolnam. Kaenambej kaes pejme xabich mamnikamponam. Xam kaenam xabich pachaemamponambej pomatkoichaliajwa. ¡Nej ja-aechfʉle'bej japox!’ —amde, Dios kawʉajnam wʉt!” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Do kaes pejme Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Asew jiw beltaenam wʉt, japi babijaxan is wʉt xamalliajwa, ja-am wʉt, nej-ax Dios, athʉxotsepon, beltaeyaxael xamal babijaxan isampoxanliajwa japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Xamal asew jiw beltae-emil wʉt, nej-ax Diosbej xamal beltaeyaxil” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Xamal naxae-emil wʉt Dios piach kawʉajnaliajwam, ¡nejxuchantat nabej tampae'! Me-ama naekichachajbapijiw, ¡nabej ja-aeche' xamal! Xan diachwʉajnakolax jʉm-an. Japi asew jiw sitaens xot, me-ama moch wʉt, jatispi. Samata, Dios mosaxisal japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Xamal naxae-emil wʉt, Dios piach kawʉajnaliajwam wʉt, ¡min xukia'e! ¡Chiekal nachaemdebej! ");
INSERT INTO guoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jasox isam wʉt, asew jiw matabijaxil xamal naxae-emilpox, Dios piach kawʉajnaliajwam wʉt. Nej-ax Dios, xamal taeyaximilpon, japonkal taeyaxael. Do jawʉt, nej-ax Dios matabijsaxael maliach isampox. Ja-am wʉt, Dios xamal mosaxael” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “¡Nabej nejchaxoele' owaliajwam ommaenkpoxan ampathatat! Ampathatat owam wʉt ommaenkpoxan, japoxan toepaxael. Xoepaxaelbej. Kethaka nosaxaelbej japoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","¡Chiekal nabichfʉlde Diosliajwa! Ja-amsfʉlam wʉt, pachaempoxan xamalliajwaxael Diosxotse. Jaxotse toepaxil. Xoepaxilbej. Kethaka ajilaxaelbej xamal wenosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Diosxotse, jaxotse Dios xamal chaxduiyaxael pachaempoxan. Samata, nejchaxoelafʉlaxaelam pasliajwam Diosxotse” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Lámparas chiekal itliak wʉt, puexa jiw batu chiekal taen. Ja-aechbej nej-itfutan. Xamal chiekal taenam, nej-itfutan pachaem wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nej-itfutan chaemil wʉt, xamal chiekal taeyaximil. Me-ama itliaklan wʉt, jachiyaxaelam. Jachiyaxaelbej nejnejchaxoelaxan. Dios we-italiafa wʉt nejnejchaxoelaxan, ja-aech wʉt, nejnejchaxoelaxan chiekal pachaemaxael. Ja-am wʉt, Dios tato'alpox nejxasinkaxaelam isfʉlaliajwam. Chiekal duilaxaelambej. Pachaema-el wʉtlax nejnejchaxoelaxan, Dios naexasisaximil. Samata, ¡chiekal taem nejchaxoelampoxanliajwa! Babijaxan nejchaxoelam wʉt, ja-am wʉt, nejnejchaxoelax, me-ama itkʉatax wʉt, jachiyaxael. Do ja-aech wʉt, xamalbej babejchow nadofaxaelam. Ja-am wʉt, xan nanaexasisaximil” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, chanaekabʉana wʉt mʉaxxot: “Nabichan kolenje wʉt pejpaklochow, japiliajwa chiekal najʉpatanbichaxil. Kaen paklonliajwa chiekal tanbichaxaelon. Asan paklonliajwa chiekal tanbichaxilon. Ja-aechlap-is nejxasinki Dios. Japi nejchaxoel wʉt platakal, japi chiekal nabichaxil Diosliajwa” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Xan ampox jʉm-an xamalliajwa, xabich nejchaxoelasamatam xaeliajwampoxan, feliajwampoxanbej. ¡Xabich nabej nejchaxoele'bej naxoeliajwampoxan! Duila-esal naxaeyaxkalliajwa. Duila-esalbej naxoekalliajwa. Dios nakchaxduifʉl nakwewe'ppoxan duilaliajwas japoxantat. Samata, Dios nakchaxduiyaxael naxaeyaxan, naxoebej. ");
INSERT INTO guoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xamal taenam mia, papun wʉt. Japi mʉtha-el naxaeyaxan. Jola-elbejpi cha-owaliajwa naxaeyaxan. Pe nakiowa, nej-ax Dios, athʉpijin, chaxduifʉl naexaeyaxan mia xaeliajwa. Dios xamal kaes pejme nejxasink. Me-ama mia nejxasink wʉt, jachi-elon. Samata, nej-ax Dios xamal chiekal tataeflafʉl. ");
INSERT INTO guoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ja-aech wʉt, ¿ma-aech xotkat xamal nejchaxoelam japoxanliajwa? Japoxan xabich nejchaxoelam wʉt, kaes matkoiyanliajwa laepaximil. ");
INSERT INTO guoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Ma-aech xotkat xabich nejchaxoelam naxoeliajwampoxan? ¡Taem naetalan, chimiatalan, yotat! Japi ti't wʉt, nabich-el chimialiajwa. Pe puexa chimiapi. ");
INSERT INTO guoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Xan jʉm-an. Rey Salomón, japon wajwʉajnapijin, pejew naxoe xabich chimia. Naxoeipon chimia, kemaenk xot. Pe naetalan kaes chimiatalan. Me-ama rey Salomón pejew naxoe, jachi-el. ");
INSERT INTO guoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pola ti't wʉt yotat, Dios pijaxtat natala wʉt, nakola chimiatalan. Pe piachliajwa-el. Kaematkoiyanliajwa asbʉan jʉmch. Do jawʉx, selil wʉt, tʉp. Do jawʉt, tamejas lausliajwas. Pelax Dios xabich kaes tataeflaxael xamal. Me-ama naetalan tataefʉl wʉt, jachiyaxilon. Samata, ¡Dios chiekal xanaboejim naxoeliajwam chimia, kaesʉapich wʉt nejxanaboejaxan Diosliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Samata, ¡xabich nabej nejchaxoele' xaeliajwampox, feliajwampoxbej! ¡Xabich nabej nejchaxoele'bej naxoeliajwampi! ¡Pelax Dioskal xanaboejim! ");
INSERT INTO guoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Jiw matabija-eli Dios, japi xabich nejchaxoelafʉl japoxanliajwa. Nej-ax Dios, athʉpijin, matabijt xamal wewe'ppoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Samata, amwʉtjel kaes pejme pachaem xamal Dios naexasisfʉlaliajwam, japon kaen nejpaklokolan. ¡Isfʉlde Dios jʉm-aechpoxan! Japox isam wʉt, Dios xamal chaxduiyaxael puexa wewe'ppoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Samata, ¡xabich nabej nejchaxoele' asamatkoi jachiyaxaelpoxliajwa! ¡Kofim nejchaxoelampox kandiawaliajwa! Samata, ¡ma amwʉt najutliajwa nejchaxoelde, machiyaxaelam amwʉt! Ja-aech wʉt, Dios chaxduiyaxael xamal wewe'ppoxan” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “¡Xamal asew jiwliajwa nabej jʉm-aeche': ‘Ampi jiw babejchow. Samata, Dios kastikaxaesi’ —nabej aeche'! Jasox jʉm-am wʉt asew jiwliajwa, asamatkoi Dios xamal jʉmchiyaxaelbej: ‘Xamal babejchowambej. Samata, xamalbej kastikaxaelen’ —chiyaxael Dios xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jasoxtat Dios jʉmchiyaxael xamal, asew jiwliajwa jʉm-am xot: ‘Ampi jiw babejchow. Samata, kastikaxaesi’ —am xot. Chaxduwam wʉt asew jiw wewe'paspoxan, ja-am wʉt, Dios xamal chaxduiyaxael wewe'ppoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Xamal najut kaes babijaxan isam wʉt, ¡nabej fias, asan aton babijax is wʉt! Aton, asan kajachawaesasia wʉt, cha-aelaxach ast it-okspon, japon pajutlax kaes pejme pinjiyax naetamat it-oks wʉt, jasoxtat japon aton, asan kajachawaesaxil. ");
INSERT INTO guoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Xamal najut kaes babijaxan isfʉlam wʉt, ¡asan nabej jʉm-aeche': ‘¡Natapaem xam kajachawaesliajwan babijax is-elaliajwam!’ —nabej aeche'! ");
INSERT INTO guoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ja-am wʉt, xamal naekichachajbapijwaxaelam. ¡Matxoela kofim najut babijaxan isampoxan! Do jawʉx, asan kajachawaesaxaelam, japon kofsliajwa babijaxan ispoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Xamal matabijam ampox. Wʉr dʉajsaximil Diosliajwapox. Wʉr, palalapi, dʉajtam wʉt Diosliajwapoxan, wʉr bej liklaxaelbej xam. Maranxotbej owaximil ommaenkpoxan. Maranxot japoxan owam wʉt, maran japoxan asbʉan jʉmch sae-enaxael” —aech Jesús, naewʉajan wʉt mʉaxxot. (Samata, jiw sitae-el wʉt naewʉajnaspoxan Diosliajwa, japi jiw kaes naewʉajnaxisal.) ");
INSERT INTO guoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “¡Dios wʉljoem wewe'ppox! Wʉljowampox japox Dios chaxdusaxael. Wʉlwekam wʉt wewe'ppox, japox faenaxaelam Dios pejkajachawaesaxtat. Xamal Dios kawʉajnam wʉt, me-ama bafafaxot lam wʉt, ja-am xamal Dios kajachawaesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wʉljoefʉlpon wewe'paspox, japon Dios chaxdusaxaes. Wʉlwekafʉlpon japonbej faenaxael Dios pejkajachawaesaxtat. Dios kawʉajnafʉlpon, japonbej Dios kajachawaesaxaes isliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Xamalxot naxi wʉljow wʉt pan, xamalkat xajʉpaxaelam naxʉlan chaxdusliajwam ia't? ");
INSERT INTO guoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naxʉlan baxin wʉljow wʉt, chaxdusaximil jom. ");
INSERT INTO guoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Xamal babejchowam matabijam naxi chaxduiliajwam pachaempoxan. Nej-ax Dios, athʉpijin, kaes pejme pachaem. Samata, nej-ax Dios pachaempoxan xamal chaxduiyaxael, xamal wʉljowam wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Samata, ¡matxoela isfʉlde pachaempoxan asew jiwliajwa! Me-ama xamal nejxasinkam asew jiw isliajwa pachaempoxan xamalliajwa, ¡japoxlap isfʉlde japi jiwliajwa! Jasoxtat naexasisfʉlaxaelam puexa Moisés chajia lelpox, Dios pejprofetas chajia lelpoxbej” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “¡Laleyax cha-aelaxachlel lem pasliajwam Diosxotse! Laleyax pinjiyax, nʉamt pinjitpotbej, japoxan koleyax, pasliajwa infiernoxotdik. Samata, xabich jiw fʉlalaek japoxadik, tʉp wʉti ampathatat, kaes tampa xot fʉlaeliajwadik. ");
INSERT INTO guoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Laleyaxach tampoel jiw leliajwa pasliajwa Diosxotse. Nʉamtbej cha-aelaxach. Samata, tampoel jiw fʉlaeliajwa pasliajwa Diosxotse. Ja-aech xot, kaesʉapich jiw jaxotse pat, tʉp wʉti ampathatat” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “¡Chiekal taem naekichachajbapijiwliajwa! Japi jiw, me-ama Dios pejprofetas wʉt, jachiyaxaeli. Pe japi profetaxil. ¡Nabej tapae' japi jiw xamal naekichachajbaliajwa! Japi jiw, me-ama pachaem wʉt, jachiyaxaeli. Pe pejnejchaxoelaxan xabich chaemil. Puexa japi naewʉajanpoxanbej, xabich chaemil asew jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Xamal matabijaxaelam japi ispoxantat. Japi jiw, me-ama na-e'naechan. Japanaechan naboes-el chimiabaech. Samata, japi jiw wejisal pachaempoxan Diosliajwa, naekichachajbapijiw xot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pachaemnae naboet wʉt, pachaembej pejbaech. Chaemilnae naboet wʉt, chaemil pejbaechbej. ");
INSERT INTO guoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pachaemnae naboesaxil pejmachbaech. Chaemilnae naboesaxilbej pachaembaech. ");
INSERT INTO guoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Samata, puexa naebaechnaechan, pachaema-eli, japanaechan liksaxaes lausliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jachiyaxaesbej jiw, chaemili. Xamal chiekal matabijaxaelam, japi is wʉt babijaxan” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Jiw pasaxael Diosxotse, isfʉl wʉt taj-ax Dios nejxasinkpoxan. Asew jiw asbʉan jʉmch jʉm-aech wʉt xanliajwa: ‘Jesús tajpaklon’ —aech wʉti, japi pasaxil Diosxotse, is-el xoti Dios nejxasinkpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kastikamatkoi pat wʉt, xabich jiw jʉmchiyaxael xanliajwa: ‘Tajpaklon, xanal jiw xabich naewʉajnax xamliajwa. Nijaxtat xabich dep to'ax nakolaliajwa jiw pejmatpʉatanxot. Koechaxanbej isx xam nijaxtat’ —chiyaxael japi jiw xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Xanlax tulaela jʉmchiyaxaelen japi jiwliajwa: ‘¡Chijiamde xanxot, xamal babijaxan isampim! Chinax xamal matabijs-enil’ —chiyaxaelen” —aech Jesús, jiw naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Do pejme kaes Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej, naewʉajan wʉton mʉaxxot: “Jiw chiekal naewet wʉt naewʉajnaxpox, naexasit wʉtbejpi tajtato'laxan, japi jiw chiekal nejchaxoel. Samata, japi jiw, me-ama bachan ispi sat tinkxot wʉt, ja-aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iam thilan wʉt, pinamin wʉtbej, xabich pinajoewa wʉtbej, japabachan taxʉ'palaxil, chiekal isas xot sat tinkxot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Xan naewʉajnaxpox jiw naewet wʉt, pe naexasis-el wʉti xan tato'laxpoxan, japi jiw, me-ama matabijsla wʉt, ja-aechi. Japi, me-ama bachan iapi thaejtat. ");
INSERT INTO guoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iam thilan wʉt, pinamin wʉtbej, xabich pinajoewa wʉtbej, japabachan chiekal jʉwal, japabachan ias xot thaejtat. Chiekal toepaxaelbej japabachan” —aech Jesús, naewʉajan wʉt mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Do jawʉt, Jesús naewʉajnax bʉxtoet wʉt, japi jiw jʉm-aech: “Jesús naewʉajanpoxan xabich pachaem” —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jasox jʉm-aechi, Jesús naewʉajan xot Dios pijaxtat. Jesús naewʉajan wʉt, me-ama judíos chanaekabʉanapi, jachi-elon. ");
INSERT INTO guoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dolisdo', Jesús jiw naewʉajnax bʉxtoet wʉt, bʉloek wʉton mʉaxxot, xabich jiw fʉlafoson. ");
INSERT INTO guoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jawʉt leprawaxaetat bʉ'xaenkpon, fʉlaenon Jesúslel. Pat wʉton Jesúsxot, brixtat nukon Jesús pejwʉajnalel sitaeyax itpaeliajwa Jesúsliajwa. Do jawʉt, jʉm-aechon: —Tajpaklon, xan matabijtax xam xajʉpampox xan naboejthʉsliajwam. Naboejthʉsasiam wʉt, ¡naboejthʉ'e! —aech leprawaxaetat bʉ'xaenkpon. ");
INSERT INTO guoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús pejke-etat jacha wʉt, jawʉt Jesús jʉm-aech bʉ'xaeyanliajwa: —Xam boejthʉsasian. Malis xam boejthʉtx —aech Jesús japonliajwa. Do jawʉt, kamta japon chiekal boejthʉlslison leprawaxae. ");
INSERT INTO guoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Do jawʉt, Jesús pejme jʉm-aech: —¡Asew jiw nabej chapae' xam boejthʉtxpox! ¡Matxoela fʉlaemch sacerdote poxade, japon xam taeliajwa boejthʉlpox leprawaxae! Do jawʉx, ¡Dios chaxdu'e, me-ama Moisés chajia lelpox jʉm-aech, leprawaxae xam chiekal boejthʉl xot! Jasoxtat jiw matabijaxael xam boejthʉlpox leprawaxae —aech Jesús japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jesús pat wʉt Capernaum paklowaxxot, jawʉt soldawcapitán, Roma gobiernoliajwa nabistpon, pat Jesúsxot. Soldawcapitán wʉljow wʉt, jʉm-aechon Jesúsliajwa: —Tajpaklon, tamakan ok camatat tajbatat. Japon nansaxil. Laejaxilbejpon. Xabich nabijaton xaenkpoxantat —aech soldawcapitán Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Do jawʉt, Jesús jʉm-aech soldawcapitánliajwa: —Xam nakfʉlaeyaxaelen nejba poxade namakan boejthʉsliajwan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Do jawʉt, soldawcapitán jʉm-aechon Jesúsliajwa: —Tajpaklon, xan xabich pachaema-enil xam leliajwam tajba, xam kaes pejme paklokolnam xot. Ma amxot waxae to'am wʉt, tamakan chiekal boejthʉlaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Xanbej tajpaklochow. Japi naketo'a wʉt, xan tajut ow-an. Xanbej soldawcapitánan. Kaen soldawan keto'ax wʉt, japon na-ow-aech. Asan lax wʉt, japon fʉlaen. Tamakanbej keto'ax wʉt, keto'axpox japon chiekal jinawe-is. Xambej jiw tato'lanam. Samata, ma amxot waxae to'am wʉt, tamakan chiekal naweboejthʉlaxaes —aech soldawcapitán Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús japox jʉmtaen wʉt, nejchaxoelanukon, capitán xabich xanaboejtaspox. Samata, Jesús jʉm-aech puexa jiw jʉmtaeliajwa: —Diachwʉajnakolax xan jʉm-an. Israel tʉajnʉxot xan xabich naxanaboejtpon, me-ama ampon capitán, jason tae-enil —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Do pejme Jesús jʉm-aech japi jiwliajwa: —Xamal jʉm-an ampox. Xabich jiw, pothatapijiw, japi judíos-eli, pasaxael Diosxotse. Jaxotse chalakaxaeli naxaeliajwa, wajwʉajnapijiw sʉapich. Abraham, Isaac, Jacobbej, japi sʉapich, naxaeyaxaeli. ");
INSERT INTO guoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pelax xabich judíos pelsaxaes itkʉatax poxadik, ‘Infierno’ —tis poxadik. Jaxotdik xabich noeyaxaeli. Bʉa'tatisaxaelbejpi, xabich nabijasaxael xot —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Do jawʉt, Jesús jʉm-aech soldawcapitánliajwa: —¡Nawia'mich nejba poxade! Namakan chiekal boejthʉslison, xam xabich xan naxanaboejtam xot —aech Jesús. Do jawʉt, capitán pamakan chiekal boejthʉlspon. ");
INSERT INTO guoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Do asamatkoi, Jesús fʉlaech wʉt Pedro pejba poxade, jaxotde ba low wʉt, taenpon Simón Pedro paem bʉ'xaenkpox. Japow ok camatat. Xabich bʉ'tʉajnikow. ");
INSERT INTO guoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús kefit wʉt, jawʉt kamta chiekal boejthʉlsow. Do jawʉt, nant wʉt, pajut naxaeyaxan athukow Jesúsliajwa, asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Do tuila wʉt, itkʉatnik wʉtbej Jesúslel xabich jiw bʉflaeni asew jiw, dep webaesi pejmatpʉatanxot. Do jawʉt, Jesús kaejametat dep to'a puexa dep nakolaliajwa jiw pejmatpʉatanxot. Jawʉtbej puexa asewbej, japi bʉ'xaeya, chiekal boejthʉls. ");
INSERT INTO guoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ampox ja-aech, me-ama Dios pejprofeta, Isaías, chajia lelpox jachiliajwa. Jʉm-aechox: “Japon xatis nakkajachawaesaxael, bichilas wʉt. Bʉ'xaenkas wʉt, nakboejthʉsaxaelbejpon” —aech Isaías lelpox, jʉm-aech wʉt Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús taen wʉt xabich jiw masajiachpox, jawʉt jʉm-aechon pejnachalaliajwa: —¡Chijias puka we-enlelde falkamtat! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Do jawʉt, judíos chanaekabʉanan mox soepan wʉt, jʉm-aechon Jesúsliajwa: —Jiw chanaekabʉanan, xanbej xam naknanʉamsasian, nejmachtʉajnʉchan poxade xam nanʉamtam wʉt —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Do jawʉt, Jesús jʉm-aech judíos chanaekabʉananliajwa: —Lam pejmʉthan moejsliajwa. Miabej pejfenan. Xanlax, puexa jiw pakoewkolnan, ajil tajbakolaba xan damlathʉlaliajwan —aech Jesús judíos chanaekabʉananliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Do jawʉt, asan pejnachalan jʉm-aechbej Jesúsliajwa: —Tajpaklon, xan taj-ax xabich pati'in. ¡Xanfʉk natapaem taj-axxot dukaliajwan! Taj-ax tʉp wʉt, do jawʉt, xam naknanʉamsaxaelen —aechon Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Do jawʉtbej, Jesús jʉm-aech japonliajwa: —¡Xamlax xan nakfʉlaem! Xan nanaexasis-elpi, japi jiw, me-ama patʉpa wʉt, kabʉan-aechi Diosliajwa. Japilap nakaewa namʉthaxael, tʉp wʉt —aech Jesús japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Do jawʉx, Jesús falkam jul, pejnachala sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jawʉt, chaflaech wʉti, chalechkal pat iam, pinjiyax, Galilea pukaxot. Xabich pintruxan, pinajoewabej. Xabich falkam min fajabas. Japox ja-aech wʉt, Jesús nejmach moejt. ");
INSERT INTO guoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Do jawʉt, Jesús pejnachala thikalisipon. Jʉm-aechlisipon: —Tajpaklon, ¡xanal nabʉ'wem, chabu'laxaes xot! —aechipon. ");
INSERT INTO guoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¿Ma-aech xotkat xamal nejlewla? ¡Xamal xabicha-el nejxanaboejaxan xanliajwa! —aech Jesús pejnachalaliajwa. Samata, jawʉt, Jesús nant wʉt, fiatlison joewa, truxanbej. Do jawʉt, puka chiekal itnapatan. ");
INSERT INTO guoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Do jawʉt, pejnachala xabich natachaema wʉt, nejchaxoelanuili japoxliajwa. Samata, nakaewa najʉm-aechi: —¿Achankat ampon? Joewa, pukabej, naexasichpon —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús puka we-enlelde wʉt, Gadara tʉajnʉxot chapa'apon, pejnachala sʉapich. Do jawʉt, kolenje poi fʉlaen Jesúslel. Japi fʉlaen patʉpamʉthanxotdin. Japi kolenje xabich chachoel dep pijaxtat. Samata, jiw pejlewla mox xenaliajwa japixot. ");
INSERT INTO guoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Do jawʉt, nejlat wʉt, jʉm-aechi dep pijaxtat: —Jesús, Dios paxʉlan, ¡xanal nabej natalias! ¿Ma-aech xotkat xam fʉlaeman xanallel nataliasliajwam that toepax wʉajna? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jaxotde kaesʉapich atʉaxachlejen xabich maran naxaelp. ");
INSERT INTO guoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Do jawʉt, japi dep jʉm-aech Jesúsliajwa: —Xanal ampi poejiwxot nakolax nato'am wʉt, ¡natapaem leliajwan maranxot! —aech dep. ");
INSERT INTO guoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Do jawʉt Jesús jʉm-aech: —Jaw, ¡xabʉa'de! ¡Lem maranxot! —aech Jesús japi depliajwa. Do jawʉt dep nakola wʉt poejiwxot, lowlisi maranxot. Jawʉt, puexa maran dʉkp chʉatadik. Do jawʉt puexa maran bu'al pukatat. ");
INSERT INTO guoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Maran tataefʉlpi dʉkp pejlewt. Patlisi pejpaklowaxxot. Chapaeilisi puexa maranliajwa ja-aechpoxan, dep low wʉt maranxot. ");
INSERT INTO guoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Do jawʉt, puexa japapaklowaxpijiw fʉlaen Jesúsleldin. Do jawʉt, japi jiw taen wʉti Jesús, to'api Jesús namanasamata japi pejtʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Do jawʉx, Jesús jul falkam, pejnachala sʉapich, chaliknaliajwa puka we-enlelde, pejpaklowax, Capernaum paklowax, poxaliajwade. ");
INSERT INTO guoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Do jaxot Jesús pat wʉt, pejnachala sʉapich, jawʉt asew jiw chaxlaeni kaen nabejkan Jesúslel, japon chinax laejaxilpon. Japon ok camillatat. Jesús chajia matabijt japi pejxanaboejaxan japonliajwa. Samata, Jesús jʉm-aech nabejkanliajwa: —Wʉa, ¡nejchachaemilde! Xam beltaenx, majt pachaemam wʉt babijaxan isampoxanliajwa —aech Jesús laejaxilponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jesús japox jʉm-aech wʉt, jawʉt, asew judíos chanaekabʉanapi japox jʉmtaen wʉt, nakaewa najʉm-aechi: “Kaen Dios xajʉp jiw beltaeliajwa, japi babijaxan is wʉt. Samata, Jesús japox jʉm-aech wʉt, jʉm-aechon chaemilpox Diosliajwa” —aechi nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús chiekal matabijt japi nejchaxoelpox. Samata, jʉm-aechon japiliajwa: —¿Ma-aech xotkat xamal nejchaxoelam babijaxan xanliajwa? ");
INSERT INTO guoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kaes pejme tampa xan jʉmchiliajwan laejaxilponliajwa: ‘Xam beltaenx babijaxan isampoxanliajwa’ —chiliajwan. Pe ja-an wʉt, jiw xan namatabijaxil xan puexa jiw pakoewkolnanponan. Jʉm-an wʉtlax nabejkan jʉmtaeliajwa: ‘¡Nande! ¡Laejim!’ —an wʉt, japox jʉm-an wʉt, jiw diachwʉajnakolax xan namatabijsaxael xan puexa jiw pakoewkolnanponan. ");
INSERT INTO guoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Samata, xamal itpaeyaxaelen xan puexa jiw pakoewkolnanponan. Xan xajʉpx beltaeliajwan jiw babijaxan ispoxanliajwa ampathatat —aech Jesús judíos chanaekabʉanapiliajwa. Samata, Jesús jʉm-aechbej nabejkan jʉmtaeliajwa: —¡Nande! ¡Nejcamilla fi'e! ¡Xalaemch nejba poxade! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Do jawʉt, nabejkan nant wʉt, fʉlaechlison pejba poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Puexa jiw japox taen wʉt, xabich natachaemanuil wʉt, nejchaxoelanuilbejpi. Do jawʉt, nakaewa najʉm-aechi: “¡Dios xabich pachaem! Dios pejpamamax Jesúskalliajwa” —aechi nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús boejthʉt wʉt nabejkan, baxot nakolt wʉt, do jawʉt, xan nataenpon. Xan tajwʉl Mateo. Xan ekx impuesto mat-omwʉljowbatat, mat-omwʉljoeliajwan Roma gobiernoliajwa. Jesús xan nataen wʉt, najʉm-aechon: —¡Xabʉa't! ¡Xan nakfʉlaem tajnachalnamliajwa! —aech Jesús xanliajwa. Do jawʉt, xan nantax wʉt, Jesús nakfolxlison. ");
INSERT INTO guoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Asamatkoi, tajbatat Jesús naxael wʉt, xanal pejnachalwan sʉapich, impuesto mat-omwʉljoew Roma gobiernoliajwa, japibej pat Jesúsxot. Do jawʉt, japibej chalak naxaeliajwa. Asew jiwbej, Moisés chajia lelpox naexasis-elpi, japibej pat jaxot. Japibej jaxot chalak naxaeliajwa, xanal sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseos, japox taen wʉt, jʉm-aechi xanalliajwa, Jesús pejnachalwanpinliajwa: —¿Ma-aech xotkat Jesús, nejchanaekabʉanan, kaeyaxtat naxael, impuesto mat-omwʉljoewpi sʉapich, asew babejchow sʉapichbej, japi naexasis-eli Moisés chajia lelpox? —aechi xanalliajwa, Jesús pejnachalwanpinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús japox jʉmtaen wʉt, jʉm-aechon fariseosliajwa: —Jiw nejchaempi, japi wewe'pa-esal jiw woen, bʉ'xaenka-el xoti. Jiw woen fʉlaen jiw bʉ'xaenkpi woeliajwa. Xanlap-is ja-an. Xan fʉlae-enil kajachawaesliajwan jiw pachaem wʉt, kabʉan-aechpi. Xanlax fʉlaenx kajachawaesliajwan babejchow, japi kofaliajwa padujnejchaxoelaxan naexasisliajwapi Dios —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jesús pejme jʉm-aech fariseosliajwa: —¡Chiekal nejchaxoelde Dios jʉm-aechpox, jʉm-aech wʉt: ‘Xan nejxasinkax xamal asew jiw beltaeliajwam, japi jiw kajachawaesliajwam. Xanlap japox kaes nejxasinkax. Me-ama ofrenda isam wʉt xanliajwa, japoxliajwa xan chiekal nejchachaemla-enillejen’ —aech Dios, chajia jʉm-aech wʉt! Xan tadʉsaxaelen jiw babejchow japi tajnachalaliajwa. Jiw jʉm-aechpilax: ‘Xan kaes pejme pachaeman. Me-ama asew jiw, jachi-enil’ —aechpi, xan japi jiw tadʉsaxinil tajnachalaliajwa —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Do jawʉx, Juan jiw bautisan pejnachala fʉlaeni Jesúslel. Pat wʉti Jesúsxot, japi jʉm-aech Jesúsliajwa: —Xanal piach naxae-enil, Dios piach kawʉajnaliajwan wʉt. Fariseosbej ja-aech. ¿Ma-aech xotkat nejnachala, me-ama xanal jachi-el? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Do jawʉt, Jesús jʉm-aech wʉajantat japi jiwliajwa: —Pawis fitpon, fiesta is wʉt, tadʉchpi naxaeyaxaelfʉk japonxot. Japi xabich nejchachaemlaxael, pajelnakjiyan jaxot duk wʉtfʉk. Asamatkoi asew jiw japon bʉflaeyaxaes. Do jawʉt, tadʉchpi naxaeyaxil kaematkoiyan sʉapich, xabich nejxaejwaxaes xoti. Jachiyaxaelbej asamatkoi tajnachalaliajwa, xan asew jiw nabʉ'fol wʉt. Samata, japi kaematkoiyan sʉapich naxaeyaxil, xan japixot ajilaxaelen xot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesús matabijt, fariseos naewʉajnasiapox padujwʉajan, pajelwʉajan sʉapich. Samata, jawʉt Jesús jʉm-aech wʉajantat japiliajwa: “Kaeow pawis pejyiaf wechachoeps wʉt, xape'tow chachoepxot. Pe yiaf xape's-elow pajelbʉ'chtat, itkias-esal wʉtfʉk. Pajelbʉ'ch, itkias-esalpox, xape't wʉtow, yiaf itkiat wʉt, mamo'al wʉt pejme, pajelbʉ'ch itkialaxael. Yiaf padujax kaes chachoepaxael, xape't xotow pajelbʉ'ch. ");
INSERT INTO guoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jasoxtatbej jiw wʉlui-el pajelvino padujbʉ'choxatat. Wʉlʉ wʉti pajelvino padujchoxatat, japox choxa chathialfalaxael, pajelvino xabich xot pafak. Ja-aech wʉt, vino nafo'axael. Choxabej nafo'axael. Samata, jiw pajelvino wʉlʉ pajelbʉ'choxatat chatinkaliajwa choxa. Ja-aech wʉt, vino nafo'axil. Choxabej nafo'axil” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Do jawʉx, Jesús naksiya wʉtfʉk, kaen aton pat Jesúsxot. Japon judíospaklon. Pat wʉt, brixtat nukon Jesús pejwʉajnalel, xabich sitaen xoton Jesús. Do jawʉt, jʉm-aechon: —Taxʉlow ma jelnawetʉp. Pe xam ke-otam wʉt japowxot, taxʉlow nawemat-esaxaelam pejme dukaliajwa —aech paklon Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Do jawʉt, Jesús nakfol paklon. Xanalbej, Jesús pejnachalwan, nakfolx Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Dolisdo', Jesús fol wʉt, kaeow pawis moxdepow Jesús pejwʉlchakallel. Japow xabich nabijat. Pejlaw wʉt, jal matduka-el. Doce waechanlisox japow bʉ'xaenkpox. Japow mox wʉt Jesús pejwʉchakallel, japow nejchaxoel: “Xan pejsumta-osax jajastax wʉt, Jesús naboejthʉsaxael” —aechow, nejchaxoel wʉt. Samata, jajastow Jesús pejsumta-osaxmatdukax. ");
INSERT INTO guoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Do jawʉt, Jesús wʉltataen wʉt, taenpon japow pawis. Samata, Jesús jʉm-aech japowliajwa: —Pawis, ¡nejchachaemilde! Amwʉtjel xam chiekal boejthʉl waxae, chiekal xan naxanaboejtam xot —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Do jawʉx, Jesús pat wʉt paklon pejbaxot, taenon, asew jiw toela nababa wʉt, patʉpow mʉthsliajwa wʉt. Jʉmtaenbejpon asew jiw wʉnowpoxan japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Samata, jʉm-aechon japiliajwa: —¡Amxot nakolim! Japow tʉpa-el. Japow moejt —aech Jesús japi jiwliajwa. Japi wʉnowpi japox jʉmtaen wʉt, xafafoli Jesúsliajwa. Japi jiw bʉ'wʉajanpaei Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Do jawʉt, Jesús nakolax to'a tathoetade wʉnowpi patʉpow. Japi nakola wʉt, Jesús low patʉpow ochxot. Jesús patʉpow kefit wʉt, mat-eton patʉpow pejme dukaliajwa. Do jawʉt, japow nant. ");
INSERT INTO guoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Puexa japatʉajnʉpijiw wʉltaena Jesús ispox patʉpowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús nakolt wʉt paklon pejbaxot, kolenje itliaklan Jesús pejwʉchakal fol. Japi nejlasfʉl wʉt, jʉm-aechfʉli: —Jesús, David pamon, ¡xanal nabeltaem! —aechfʉli. ");
INSERT INTO guoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Do jawʉx, Jesús asaba low wʉt, kolenje itliaklan mox soepa Jesúsxot. Do jawʉt, Jesús jʉm-aech japi kolenje itliaklanliajwa: —¿Xamalkat xan nanaexasitam xajʉpxpox boejthʉsliajwan nej-itfutan? —aech Jesús. Japi jʉmnot wʉt, jʉm-aechi: —Diasdo' tajpaklon. Xam naexasitx —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Do jawʉt, Jesús japi itfujacha wʉt, jʉm-aechon: —Xamal chiekal naxanaboejam xot, nanaexasitam xotbej, ¡chiekal taem! —aech Jesús japi kolenje itliaklanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Do jawʉt, chiekal taenlisi. Do jawʉt, Jesús jʉm-aech nejthʉ'axtat japi kolenjeliajwa: —¡Xamal asew jiw nabej chapae' xan isxpox xamalliajwa! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pe japi fʉlaech wʉt, nakiowa puexa japatʉajnʉpijiw chapaefʉl Jesús isaspoxliajwa japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Majt itliakalpi Jesúsxot chijia wʉti, do jawʉt, asew jiw bʉflaen bʉxwʉajanjilan Jesúsleldin. Japon naksiyaxil, dep webaes xoton pejmatpʉatat. ");
INSERT INTO guoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Do jawʉt, Jesús to'a dep nakolsliajwa japon pejmatpʉatxot. Dep nakolt wʉt, do jawʉt, bʉxwʉajanjilan tʉadutlison naksiyax. Jawʉt, xabich jiw natachaemanuil wʉt, nejchaxoelanuilbejpi. Jʉm-aechi: —Majt chinax jasox tae-esal ampatʉajnʉtat, Israel tʉajnʉxot —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pelax fariseos jʉm-aech: —Jesús to'a wʉt dep, to'a dep pejpaklon pijaxtat —aech fariseos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús nanʉamt puexa paklowaxanxot, puexa tʉajnʉchanxotbej, jiw naewʉajnafʉlaliajwapon, judíos naewʉajnabachanxot. Jesús naewʉajan chimiawʉajan jiwliajwa, Dios puexa pejjiw tato'laxaelpox. Boejthʉsfʉlbejpon nejmachwaxaetat bʉ'xaenkpi. ");
INSERT INTO guoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesús taen wʉt xabich jiw, pinamʉt, japi jiw beltaenpon, japi nabijat xot, wejisal xotbejpi asan kajachawaesliajwas. Taen wʉton, japi jiw, me-ama ovejas napelti, ja-aech japi jiw Jesúsliajwa, wejisal xot asan tataeflaliajwas japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Do jawʉt, Jesús jʉm-aech xanal pejnachalwanliajwa, asew jiwliajwabej: —Diachwʉajnakolax xan jʉm-an. Ampi jiw, me-ama trigo foel wʉt, ja-aechi, japi wʉajnawesfʉl xot jʉmtaeliajwa chimiawʉajan. Pe jiw xabich kaesʉapich, Dios pejjamechan naewʉajanpi. ");
INSERT INTO guoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Samata, ¡kawʉajande wajpaklokolan Dios, japon asew jiw to'aliajwa, naewʉajanpi Dios pejjamechan! ");
INSERT INTO guoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús xanal nala, dosan pejnachalwan, japonxotaliajwan. Jesús natapaei xanal japon pijaxtat dep to'aliajwan, jiw pejmatpʉatanxot bapi, nejmachwaxaetat bʉ'xaenkibej boejthʉsliajwan. ");
INSERT INTO guoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesús xanal nawʉlduw apóstoles, dosanpin. Xanalxot kaen kolewʉlje. Matxoelawʉl pawʉlon Simón. Wʉlchakalwʉl pejwʉl, pawʉlon Pedro. Asan pawʉl Andrés. Japon Simón Pedro pakoewan. Asan pawʉl Santiago. Asan pawʉl Juan. Japon Santiago pakoewan. Japi kolenje Zebedeo paxi. ");
INSERT INTO guoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Asan pawʉl Felipe. Asan pawʉl Bartolomé. Asan pawʉl Tomás. Xan tawʉl Mateo. Xanlap majt impuesto mat-omwʉljoenan Roma gobiernoliajwa. Asanbej pawʉl Santiago. Japon Alfeo paxʉlan. Asan pawʉl Tadeo. ");
INSERT INTO guoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Asan pawʉl Simón. Japon majt asamʉtpijin, celotemʉtpijin. Asan pawʉl Judas Iscariote. Japonlap Jesús wiasaxael padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús to'a wʉt padoce apóstoles, jʉm-aechon ampox: “¡Nabej fʉlae' judíos-eli pejtʉajnʉchan poxade! ¡Nabej fʉlae'bej Samaria tʉajnʉpijiw poxade! ");
INSERT INTO guoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","¡Xamallax fʉlaem judíoskal duil poxade! Japi, me-ama ovejas, napelti, ja-aechpi. ");
INSERT INTO guoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Fʉlaemch wʉt, japi jiw naewʉajnam wʉt, ¡jʉm-amde: ‘Dios puexa pejjiw tato'laxaelmatkoi malisox mox pawʉajna’ —amdepi! ");
INSERT INTO guoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","¡Bʉ'xaenki boejthʉsfʉlde! ¡Tʉpi mat-embej pejme duilaliajwa! ¡Boejthʉsfʉldebej leprawaxaetat bʉ'xaenki! ¡Dep to'imbej jiw pejmatpʉatanxot nakolaliajwa! Xamal malech kenotam ampapamamax. Samata, ¡xamal nabej mat-omwʉljoem, asew jiw boejthʉtam wʉt! ");
INSERT INTO guoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Folam wʉt, ¡nabej xalae' plata! ");
INSERT INTO guoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","¡Nabej xalae'bej asew choxan! Mado', inaxoelam, ¡do japoxkal bʉ'laflaem! Mado' itʉakxajoelam, ¡do japoxkalbej tʉaklaflaem! ¡Nabej xalae'bej asax naxliaxsliajwampox, tʉakxaliaxsliajwampoxbej! Folam wʉt, ¡masim fʉlaem! ¡Nabej xalae' kelachalanaeyan! Jiw naeweti Dios pejjamechan, japi xamal chaxduiyaxael wewe'ppoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nejmachpaklowax patam wʉt, tʉajnʉxotbej, ¡wʉlwekde kaen aton, japapaklowaxpijiw sitaenspon! Do jawʉt, ¡japon kawʉajande pejbatat duilaliajwam! Japon jaw-aech wʉt, ¡japabatat duilafʉldefʉk! Hasta nakolaliajwam wʉt, ¡japabaxot nakolim asapaklowax poxaliajwam! ");
INSERT INTO guoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nejmach-aton pejba lowam wʉt, ¡jʉm-amde: ‘¡Xamal Dios nej kajachawaes ampabaxot duilampim!’ —amde japabapijiwliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Japabapijiw pachaem wʉt xamalliajwa, ja-aech wʉt, Dios kajachawaesaxaes japabapijiw. Pe asew jiwlax xamal bʉ'kʉla-el wʉt, ja-aech wʉt, Dios kajachawaesaxisal japabaxot duilpi. ");
INSERT INTO guoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Asew jiw xamal bʉ'kʉla-el wʉt, nejnaewʉajnax naewes-el wʉtbejpi, ¡fʉlaem asapaklowaxlel! Fʉlaeliajwam wʉt, ¡nejtʉakxajoe jolde lʉlaliajwam as natacholnaliajwa! Jasoxtat japi jiw pajut chiekal matabijaxael babijax ispox xamalliajwa, Diosliajwabej, xamal bʉ'kʉla-el xoti. ");
INSERT INTO guoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Diachwʉajnakolax xan jʉm-an. Asamatkoi, Dios jiw kastika wʉt, japapaklowaxpijiw xabich kaes pejme kastikaxaes. Me-ama Sodoma paklowaxpijiw, Gomorra paklowaxpijiwbej, kastikas wʉt, jachiyaxil Dios, japi jiw kastika wʉt” —aech Jesús xanal dosanpinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Do pejme Jesús jʉm-aech xanal dosanpinliajwa: “Xamal tajaxtat folam wʉt, ¡chiekal taem, to'ax xot jiw babejchow poxade! Me-ama ovejasliajwa chachachoel pejmachchoefxot wʉt, jachiyaxaelbej xamalliajwa. ¡Chiekal matabijim! Me-ama jom xandadʉs-el chachoelxot, ¡xamalbej ja-amde! ¡Nabej nabe'bej nakaewa! Me-ama a-u, jachiyaxaelam xamal. ");
INSERT INTO guoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","¡Chiekal taem jiw babejchowliajwa! Japi xamal woeyaxaeli judíospaklochow poxade, japapaklowaxpijiwxot. Do jawʉx, judíos naewʉajnabachanxot xamal selsaxaeli. ");
INSERT INTO guoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Xan nanaexasitam xot, xamal bʉflaeyaxaelbejpi gobernadores poxade, reyes poxadebej. Samata, xamal bʉ'fol wʉti, xamal japixotam wʉt, asew judíos-elixotam wʉtbej, ¡jʉm-amde xanliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Xamal japixot woeya wʉti, ¡xabich nabej nejchaxoele' naksiyaxaelampoxliajwa, jʉmnosliajwam wʉt paklochow! Jawʉt Espíritu Santo xamal kajachawaesaxael chiekal jʉmnosliajwam. ");
INSERT INTO guoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Samata, xamal najut nijaxtat jʉmnosaximil. Nej-ax Dios pej-Espíritu Santo kajachawaesaxael xamal chiekal jʉmnosliajwam paklochow pejwʉajnalel. ");
INSERT INTO guoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Japamatkoiyantat asew pakoewkola bʉflaeyaxaes paklochow poxade, jaxotde beliajwas, japi tajnachala xot. Paxjiw, o, penjiwbej, bʉflaeyaxael paxi paklochow poxade jaxotde beliajwas, japi tajnachala xot. Paxibej bʉflaeyaxael pax, o, penbej, paklochow poxade jaxotde japi beliajwas, tajnachala xot. ");
INSERT INTO guoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Puexa ampathatpijiw xamal nejweslaxael, tajnachalwam xot. Pe nakiowa, xan nanaexasisfʉlam wʉt, hasta tʉpam wʉt, Dios xamal bʉ'weyaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Asapaklowaxpijiw babijaxan is wʉt xamalliajwa, xamal tajnachalwam xot, ¡dʉkpaxaelam asapaklowaxlel! Diachwʉajnakolax xan jʉm-an. Xan, puexa jiw pakoewkolnan, nakolsaxaelen ampathatxot. Do jawʉx, naewʉajnafʉlaxaelam Israel tʉajnʉpijiw. Ja-amsfʉlam wʉt, xan chalechkal pasaxoekan wʉt ampathatasik, japamatkoiyantat, xamal toesaximilfʉk tajwʉajna jiw naewʉajnafʉlampoxan potʉajnʉcha, Israel tʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Estudiapon kaes pejme pachaema-el. Me-ama chanaekabʉanapon, jachi-el estudiapon. Nabichanbej kaes pejme pachaema-el. Me-ama pejpaklon, jachi-elon. ");
INSERT INTO guoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Estudiapon, toet wʉt estudiaxpox, japon nejchachaemlaxael, najʉpje wʉton, chanaekabʉanaspon sʉapich. Nabistonbej nejchachaemlaxael, najʉpje wʉton, pejpaklon sʉapich. Jiw xan nanejweslapi, japi jʉm-aech wʉt xanliajwa: ‘Xam depam’ —aech wʉti, ja-aech wʉt, japi jiw xabich kaes pejme xamal bʉ'wʉajanpaeyaxael, tajnachalwam xot” —aech Jesús xanal dosanpinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Do jawʉx, Jesús pejme jʉm-aech xanal dosanpinliajwa: “¡Xamal nabej nejlewle' jiw babejchowliajwa, japi xamal nejwesla wʉt, ajilaxael xot maliachpoxan! Maliachpoxan asamatkoi puexa chiekal tulaelaxaes. Asew jiw maliach jʉm-aechpoxan, japoxanbej asamatkoi puexa asew jiw naekʉanchakowaxil jʉmtaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Xan maliach niajkal jʉm-anox, xamal jʉmchiyaxaelam puexa jiwliajwa. Xan jʉm-anpox nuthaklajametat maliach, nejlatam wʉt, jʉmchiyaxaelam puexa jiw jʉmtaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","¡Nabej nejlewle' jiw babejchowliajwa, xamal boesasia wʉti ampathatxot! Pe kaes japi machiyaxil beliajwa nej-aelan. Xamallax nejlewlaxael Diosliajwa, japon xajʉp xot xamal beliajwa ampathatxot, nej-aelanbej to'aliajwa infierno poxadik, jaxotdik nej-aelan chiekal toepaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Kolenje mian mowas kaekafefliajwa. Ja-aech, japi mia omjil xot. Pe nakiowa, Dios tapae-el wʉt, chinax kaen mian pajut pijaxtat patʉpan jopaxil. ");
INSERT INTO guoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Diosliajwa xamal kaes pejme ommaenkam. Me-ama mia omjil, jachi-emil xamal. Dios matabijt, massʉapich nejmatla kaenanʉla nejmatnaetanxot. ");
INSERT INTO guoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Samata, ¡xamal nabej nejlewle' asew jiwliajwa, xamal xabich kaes ommaenkam xot! Me-ama pin-iat mia, jachi-emil xamal” —aech Jesús xanal dosanpinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Do pejme Jesús jʉm-aech xanal dosanpinliajwa: “Jiw jʉm-aech wʉt, asew jiw pejwʉajnalel: ‘Xan Jesús naexasitx’ —aech wʉti, japi jiw tajnachalaxael. Xanbej jʉmchiyaxaelen taj-ax Diosxotse japiliajwa: ‘Ampi jiw xan tajnachala’ —chiyaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pelax asew jiw, xan nanaexasiti, asew jiw pejwʉajnalel jʉm-aech wʉti: ‘Xanal Jesús pejnachala-enil’ —aech wʉti, xanbej jʉmchiyaxaelen taj-ax Dios pejwʉajnalel: ‘Ampi jiw tajnachala-el’ —chiyaxaelen” —aech Jesús xanal dosanpinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Do pejme Jesús jʉm-aech xanal dosanpinliajwa: “¡Xamal nabej nejchaxoele' xanliajwa: ‘Jesús pat ampathatat puexa jiw kaenejchaxoelaxtat duilaliajwa’ —nabej aeche', nejchaxoelam wʉt! Xan pas-enil japoxliajwa. Xan patx jiw kaenejchaxoelaxa-el(a)liajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Xan patx poejiw, paxjiw sʉapich, watho'bej, penjiw sʉapich, pakalajiw sʉapichbej, paemjiw sʉapichbej, kaenejchaxoelaxa-el(a)liajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jiw xan naxanaboejapi, japi asamatkoi pejjiwkola padaelmajiw dofaxaelpi, japi xan nanaexasit xot. ");
INSERT INTO guoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Xamal kaes nejxasinkam wʉt nej-axjiw, nej-enjiwbej, xanlax xabich kaes nanejxasinka-emil wʉt, ja-am wʉt, xamal tajnachalwaximil. Kaes nejxasinkam xot naxi, xanlax xabich kaes nanejxasinka-emil wʉt, ja-am wʉtbej, xamal tajnachalwaximil. ");
INSERT INTO guoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Xamal nanaexasis-emil wʉt, xan nakfʉlae-emil wʉtbej, nejlewla xot tʉpaliajwam xanliajwa, ja-am wʉt, xamal tajnachalwaximil. ");
INSERT INTO guoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Xamal isfʉlam wʉt najut nejxasinkampoxan ampathatat, asamatkoi tʉpam wʉt, duilaximil Diosxotse. Pelax kofam wʉt najut nejxasinkampoxan isfʉlaliajwam xan tato'laxpoxan, ja-am wʉt, asamatkoi tʉpam wʉt, duilaxaelam pomatkoicha Diosxotse” —aech Jesús xanal dosanpinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Do pejme Jesús jʉm-aech xanal dosanpinliajwa: “Jiw chiekal xamal bʉ'kʉla wʉt, japi me-ama xanbej, chiekal nabʉ'kʉlti. Jawʉt xan nato'apon, bʉ'kʉlabejpi. ");
INSERT INTO guoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jiw chiekal bʉ'kʉla wʉt Dios pejprofeta, naexasit xoton Dios, japi jiw kajachawaesaxaes Dios. Me-ama Dios kajachawaet profeta, japi jiwbej kajachawaesaxaes Dios. Jiw chiekal bʉ'kʉla wʉt asan pachaempon, Dios naexasit xoton, japibej kajachawaesaxaes Dios. Me-ama Dios kajachawaet pachaempon, jasoxtatbej japi kajachawaesaxaes. ");
INSERT INTO guoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nejmachjiw is wʉt pachaempox jelxan nanaexasitponliajwa, o, japi jiw minkal chaxdut wʉti vasotat japon min feliajwa, japon tajnachalan xot, ja-aech wʉt, japi jiw kaenanʉla diachwʉajnakolax Dios chaxduiyaxaes pachaempox, minkal chaxdut xoti tajnachala” —aech Jesús xanal dosanpinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Do jawʉt, Jesús naewʉajnax bʉxtoet wʉt, jaxot chijiapon jiw naewʉajnaliajwa Dios pejjamechan asapaklowaxan poxaliajwade, Galilea tʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan, jiw bautisan, jiw jebatat wʉltaefʉl Jesús isfʉlpoxan. Samata, pejnachalaxot asew to'apon japi wʉajnachaemsliajwa Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Dolisdo', japi Jesúsxot pat wʉt, jʉm-aechi: —Juan xanal nabʉxto'a wʉt, jʉm-aechon xam wʉajnachaemsliajwan: ‘¿Xamkatlap diachwʉajnakolax Cristowam, “Pasaxoekpon” —tisponam, jiw bʉ'weliajwam? Cristowa-emil wʉt, ¿xanalkat wʉajnawesfʉlaxaelenfʉk asan, “Pasaxoekpon” —tispon?’ —aech Juan —aech Juan pejnachala Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Do jawʉt, Jesús jʉm-aech Juan pejnachalaliajwa: —¡Nawemch Juan poxade! Juanxot patam wʉt, ¡chapaempon xamal jʉmtaenampoxan, taenampoxanbej xan isfʉlax wʉt! ");
INSERT INTO guoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Juan chapaeyam wʉt, ¡jʉm-amopon: ‘Majt itliakalpi, japi chiekal taenlisi. Majt nabejkpi, japibej chiekal laelplisi. Majt piach bʉ'xaenki leprawaxaetat, japibej chiekal boejthʉls. Majt naekʉa'nikpi, japibej chiekal jʉmtaen. Tʉpibej, mat-ias pejme duilaliajwa’ —amo, Juan chapaeyam wʉt! ¡Chapaembejpon xan naewʉajnafʉlaxpox kejila, japibej naexasisliajwa, bʉ'weliajwasbejpi Dios! ");
INSERT INTO guoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Juan jʉm-amdebej: ‘Nejmachjiw chiekal naxanaboejafʉl wʉt, naexasisfʉl wʉtbejpon xan Cristowanponan, japi jiw nejchachaemlafʉlaxael’ —amde Juan! —aech Jesús Juan pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan pejnachala nawia wʉt, do jawʉt, Jesús jʉm-aech Juanliajwa jiw chiekal jʉmtaeliajwa: “Juan, jiw bautisan, pajilaxtat wʉt, xamal fʉlaemch wʉt, ¿chiliajwakat fʉlaemch japoxade? Fʉlae-emil taeliajwam muifʉrtʉat joewa jʉ'baspoxkal. ");
INSERT INTO guoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Fʉlae-emilbej taeliajwam xabich chamoeyaxan naxoeipon. Xamal matabijam, chimianaxoeipi duila-el pajilaxtat. Chimianaxoeipi duil paklochow pejbachantat. ");
INSERT INTO guoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Xamallax pajilax poxade fʉlaemch taeliajwam profeta. Diachwʉajnakolax xan jʉm-an. Japon Juan xamal taenam wʉt, taenam poklaprofeta. ");
INSERT INTO guoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dios pejjamechan, chajia lelspox, jʉm-aech Dios jʉm-aechpox xanliajwa Juan to'axaespoxliajwa: ‘Wʉa, xam wʉajna xan to'axaelen tajprofeta, japon jiw naewʉajnafʉlaliajwa tajjamechan jiw naexasisliajwa, xam patam wʉt’ —aech Dios jʉm-aechox xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Diachwʉajnakolax xan jʉm-an. Juan poklaprofetakolan. Poejiw ampathatpijiwxot ajil profeta kaes pejme pachaempi, me-ama Juan, jiw bautisan, jason. Pelax, Diosxotse wʉt, jaxotse puexa jiw chiekal isfʉl Dios nejxasinkpoxan. Japi kaes pejme pachaemaxael, Dios pejwʉajnalel wʉt. Me-ama Juan ampathatat wʉt, jachiyaxili” —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jesús pejme jʉm-aech japi jiwliajwa: “Juan, jiw bautisan, chajia tʉadut wʉt pejnaewʉajnax, japamatkoiyantatbej xabich maenk nabeyaxan. Maenkbej jiw babejchow. Me-ama amwʉtjel, ja-aech. Japamatkoiyantatbej xabich jiw naexasisasia Dios tato'alpox. Pe asew jiw toesasia Dios pejjiw, nejweslas xoti japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan wʉajna puexa asew profetas lelpoxan, Moisés lelpoxbej, jʉm-aech Dios puexa pejjiw tato'laxaelpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Xamal naexasisasiam wʉt ampox, ¡naexasi'e xan jʉm-anpox! Dios pejjamechan chajia jʉm-aech: ‘Elías pejme pasaxael’ —aechox. Japox jʉm-aech wʉt, jʉm-aechox Juan, jiw bautisanliajwa. Me-ama Dios pejprofeta Elías chajiakolaxtat is, ja-aechlap-is Juan. Samata, Juan wʉajna chajia matabijas japon isaxaelpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xamal matabijasiam wʉt Dios pejnejchaxoelaxan, ¡chiekal naewe'e xan jʉm-anpoxan!” —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Jesús pejme jʉm-aech japi jiwliajwa: “Ampamatkoiyantat jiw duili ampathatat, japi, me-ama yamxi wʉt, ja-aechi, kaenejchaxoelaxa-el xot. Me-ama yamxi chalak nakakujsliajwa plazaxot, ja-aech japi jiw. Yamxi chalak, pejnachala sʉapich. Do jawʉt, nakaewa najʉm-aechi: ‘Xanal toela nababax xamal nababoelaliajwam. Pe thiataenam wʉt, nababoela-emil. Xanal jajui jajuwxbej, naebejjajui, xamal noeliajwam. Pe noe-emil’ —aech yamxi, nakaewa nalot wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ja-aechbej, Juan, jiw bautisan, japon fʉlaen wʉt Dios pejjamechan naewʉajnaliajwa. Juan naxae-el, piach Dios kawʉajnaliajwa wʉt. Fe-elbejpon vino. Ja-aech wʉt, xamal japonliajwa jʉm-amsfʉlam: ‘Juan ja-aech, pejmatpʉatat dep webaes xoton’ —amsfʉlam xamal. ");
INSERT INTO guoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Do jawʉx, xan puexa jiw pakoewkolnan, fʉlaenx. Xanlax naxae-ela-enil. Fe-ela-enilbej. Ja-an wʉt, xamal najʉm-am diachwʉajnakolaxa-elpox xanliajwa: ‘Japon xabich litabejnik. Feyax nejxasinkbejpon saxa. Pejnachalabej babejchow. Asewbej, japon pejnachala, impuesto mat-omwʉljoew Roma gobiernoliajwa’ —na-amsfʉlam xanliajwa, babejjamechan jʉm-am wʉt. Me-ama yamxi, babejjamechan jʉm-aech wʉt nakaewaliajwa, ja-ambej xamal xanliajwa. Pe matabijasiapi Dios, japi jiw naexasisfʉlaxael Juan jʉm-aechpoxan, xan jʉm-anpoxanbej. Ja-aech wʉt, japi matabijaxael diachwʉajnakolaxpox Juanliajwa, xanliajwabej” —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Asapaklowaxanxot, Jesús xabich koechaxan isxot, japapaklowaxanpijiw taen wʉt Jesús koechaxan ispoxan, japi jiw nakiowa kofa-el babijaxan isfʉlpoxan. Samata, Jesús japapaklowaxanpijiw lot wʉt, jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Corazín paklowaxpijiw, Betsaida paklowaxpijiwbej, xabich nabijasaxael, xabich kastikas wʉti. Xan koechaxan isx wʉt, japi jiw chiekal taenpi. Chajia japoxan isaxaelen wʉt Tiro paklowaxpijiwliajwa, Sidón paklowaxpijiwliajwabej, japi japoxan taeyaxael wʉt, kofaxaeli padujnejchaxoelaxan isfʉlaliajwa Dios nejxasinkpoxan. Naxoeyaxaelbejpi papopa. Chalakaxaelbejpi jitthumbanxot asew jiw matabijaliajwas xabich nejxaejwaspoxan japi babijaxan ispoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Samata, diachwʉajnakolax xan jʉm-an. Asamatkoi, Dios jiw kastika wʉt, Corazín paklowaxpijiw, Betsaida paklowaxpijiwbej, Dios xabich kaes pejme kastikaxaesi. Me-ama Tiro paklowaxpijiw, Sidón paklowaxpijiwbej, jachiyaxisal, japi jiw kastikas wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum paklowaxpijiw nejchaxoelaxael: ‘Xatis Dios nakbʉ'weyaxael, athʉxotas wʉt’ —aechi, nejchaxoel wʉt. Pe japi Dios to'axaeks infierno poxadik, xan nanaexasis-el xoti. Xan xabich isx koechaxan. Xan japoxan isx wʉt Sodoma paklowaxxot, japi kofaxael chajia babijaxan ispoxan. Ja-aech wʉt, pejpaklowax, Sodoma paklowax, chajiakolaxtat toejafaxisal. ");
INSERT INTO guoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Diachwʉajnakolax xan jʉm-an. Asamatkoi, Dios jiw kastikaxael wʉt, Dios xabich kaes pejme kastikaxael Capernaum paklowaxpijiw. Me-ama Sodoma paklowaxpijiw kastikas wʉt, jachiyaxil Dios, japi jiw kastika wʉt” —aech Jesús japapaklowaxanpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Asamatkoi, Jesús Dios kawʉajan wʉt, jʉm-aechon: “Ax, xam athʉxotse, ampathatlelbej, paklokolnam. Xabich pachaemambej. Estudia-elpi, xam kajachawaetam japi chiekal matabijaliajwa nejjamechan. Asewlax, me-ama xabich matabijs wʉt, kabʉan-aechpi, japilax xam kajachawaes-emil japoxan matabija-elaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jasox xam isam, me-ama xam nejxasinkam” —aech Jesús, pax Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Do jawʉtbej, Jesús pejme xanal pejnachalwan najʉm-aech: “Taj-ax natapaei puexa matabijsliajwan. Pe jiw diachwʉajnakolax xan namatabijs-el, ma-an xan. Taj-ax, kaen, xan chiekal namatabijt. Jiw matabija-elbej, ma-aech taj-ax. Xan kaenan taj-ax chiekal matabijtax. Xan jiw makanotxpi, japikal xan tapaeyaxaelen matabijaliajwapi taj-ax. ");
INSERT INTO guoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Puexa xamal damlampim judíos chanaekabʉanapi tato'laxtat, ¡xabʉa'din xanlel xanxot damlathʉlaliajwam, isfʉlaliajwambej Dios nejxasinkpoxan! ");
INSERT INTO guoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xan nejpaklonan. ¡Tajbichax chiekal isfʉlde! ¡Naexasisfʉldebej xan naewʉajnaxpoxan! Xan xabich pachaeman xamalliajwa. Samata, xamal chiekal damlathʉlaxaelam xanxot. ");
INSERT INTO guoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Xabich tampoela-el xamal isliajwam xan to'axpoxan” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Do baxael, judíos pejnapatamatkoi wʉt, Jesús, xanal japon pejnachalwan sʉapich, xenax trigolulan tuchade. Xanal trigo jolbalax xaelpaliajwan, litaxaelax xot. ");
INSERT INTO guoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseos, xanal sʉapich, folpi, japi taen wʉti xanal trigo jolbalaxpox, jawʉt jʉm-aechi Jesús jʉmtaeliajwa: —Jesús, ¡tae'nik nejnachala! Xatis, judíospis, nabichaxisal napatamatkoitat. Pe nakiowa, nejnachala trigo jolbala xaelpaliajwa —aech fariseos. ");
INSERT INTO guoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Do jawʉt, Jesús jʉm-aech fariseosliajwa: —Xamalkas matabijam wajwʉajnapijin, waj-am rey David, ispox chajiakolaxtat xabich litaxaela wʉton, pejjiw sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jawʉt rey David xananʉamsba, Dios pejba, lechon. Japabatutat wʉajna pan oel mesamatwʉajtat. Japapan Dios pej-ofrenda. Japapan rey David xael wʉt, chaxduwbejpon pejnachala japi xaeliajwa japapan. Moisés chajia lelpox jʉm-aech: ‘Japapan koew xaeliajwa sacerdotes, japi nabisti Dios pejtemplobatat. Sacerdote-elpi xaeyaxil japapan’ —aech Moisés chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Xamalkas xaljowam Moisés chajia lelpox. Japox jʉm-aech: ‘Napatamatkoitat wʉt, sacerdotes nabist Dios pejtemplobaxot. Nabist wʉti napatamatkoitat, do japox babijaxa-el’ —aech Moisés chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Diachwʉajnakolax xan jʉm-an. Ma amxot nukpon kaes pejme pachaem. Me-ama Dios pejtemploba, jachi-elon. ");
INSERT INTO guoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xamalfʉk chiekal matabija-emil, Dios pejprofeta chajia lelox jʉm-aech wʉt Dios jʉm-aechpoxliajwa: “Xan nejxasinkax xamal asew jiw beltaeliajwam. Japox kaes pejme pachaem. Me-ama choef xʉa'sax taj-ofrendaliajwa, jachi-el” —aech Dios jʉm-aechpox. Chil xamal japox chiekal jʉmmatabijaxaelam wʉt, jiw tasalaximil, babijaxan is-elpi. ");
INSERT INTO guoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","¡Xamalbej jʉmmatabijim ampox! Xan, puexa jiw pakoewkolnan, xajʉpx jʉmchiliajwan jiw isaxaelpox napatamatkoitat —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Do jawʉx, Jesús bʉxtoet wʉt, fariseos sʉapich, nospaeyax, jawʉt fʉlaechon judíos naewʉajnaba poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jesús japaba low wʉt, jaxot wʉajna kemamlan ek. Jaxotbej asew judíos. Japi xabich tasalasiapi Jesús, is wʉton asax. Samata, japi Jesús wʉajnachaemt wʉt, jʉm-aechi: —¿Moisés chajia lelpox tapaeikat bʉ'xaeyan boejthʉsliajwas napatamatkoitat? —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús jʉmnot wʉt, jʉm-aechon: —Napatamatkoitat nijan oveja jop wʉt pinamʉthadik, xamal jusaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jiw kaes pejme ommaenk. Me-ama oveja, jachi-el. Samata, naktapaei isliajwa pachaempox napatamatkoitat —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Do jawʉt, Jesús jʉm-aech kemamlanliajwa: —¡Keba'de! —aechon. Keba't wʉt, pejke-e chiekal wepachaemlison. Me-ama asake-elel, wejatislison. ");
INSERT INTO guoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseos jaxot nakola wʉt, pejme natamejapi japi nakaewa najʉmchiliajwa: “¿Machiyaxaeskat Jesús boesaliajwas?” —nachiliajwapi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús matabijt wʉt fariseos boesasiaspox, do jaxot Jesús nakolt, judíos naewʉajnabaxot. Jawʉt xabich jiw fʉlafoson. Jawʉtbej japixot Jesús puexa bʉ'xaeya boejthʉsfʉl. ");
INSERT INTO guoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesús bʉxfiat wʉt boejthʉlspi, jʉm-aechon: “¡Xamal tulaela nabej chapae' asew jiw jʉmtaesamata xamal boejthʉtxpox!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesús japi bʉxfiat wʉt, patlisox Isaías, Dios pejprofeta, chajia jʉm-aechpox. Jaxot jʉm-aechox Dios jʉm-aechpox paxʉlanliajwa: ");
INSERT INTO guoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ama taxʉlan, makafitxpon jiw bʉ'weliajwa. Xabich nejxasinkaxpon. Xabich nejchachaemlaxbej japonliajwa. Xan taj-Espíritu Santo to'axaelen taxʉlanliajwa. Do jawʉx, taxʉlan naewʉajnaxael puexa judíos, judíos-elpibej, japi matabijaliajwa xan jiw bʉ'weyaxaelenpox japon pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Japon, asew jiw sʉapich, bʉ'nalosaxil. Jʉmseyaxilbejpon. Me-ama judíos pinjametat jʉm-aech, natameja wʉt, paklowaxthialaxanxot wʉt, jachiyaxil japon, naewʉajan wʉt jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jiw naexasiti tajjamechan, japi xabicha-el wʉt pejxanaboejaxan xanliajwa, japon japi jiw pelsaxil japonxot. Japi jiw kajachawaesfʉlaxaelon, hasta japon puexa jiw tato'al wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Puexa ampathatpijiw xanaboejaxaeli japon” —aech Dios jʉm-aechpox paxʉlanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Do jawʉx, itliaklan makxalaens Jesúslel. Japon bʉxwʉajanjilbej. Japon dep webaesbej pejmatpʉatxot. Do jawʉt, Jesús japon boejthʉt, dep to'a wʉton nakolsliajwa japon pejmatpʉatxot. Do jawʉtbej, japon chiekal pachaem taeliajwa, naksiyaliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Puexa jiw japox taen wʉt, xabich nejchaxoelanuili. Nakaewa nawʉajnachaemsnapi: “¿Amponkatlap Mesías, David pamon?” —na-aechnapi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseos japox wʉltaen wʉt, jʉm-aechi japi jiw jʉmtaeliajwa: “Jesús dep to'a wʉt, to'afʉl Beelzebú pijaxtat, dep pejpaklon pijaxtat” —aech fariseos. (Satanás asawʉl Beelzebú.) ");
INSERT INTO guoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús matabijt fariseos nejchaxoelox. Samata, Jesús jʉm-aech fariseosliajwa: “Xan dep to'a-enil Satanás pijaxtat. Kaetʉajnʉpijiw nadiajkaxael wʉt nabeliajwa, japatʉajnʉpijiw natoesaxael nabeyaxtat. Kaepaklowaxpijiwbej nadiajk wʉt nabeliajwa, japapaklowaxpijiwbej nabeyaxtat natoesaxael. Kaebapijiwbej nadiajk wʉt nabeliajwa, ja-aech wʉt, japabapijiw natoesaxael nabeyaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jachiyaxaelbej Satanás. Pejjiw sʉapich, nadiajk wʉt nabeliajwa, japi natoesaxael nabeyaxtat. Ja-aech wʉt, Satanás pejpamamax toepaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Xamal jʉm-am xanliajwa: ‘Jesús dep to'a Beelzebú pijaxtat’ —am xamal. Xan jachiyaxaelen wʉt, ¿achan pijaxtat nejnachalabej dep to'a nakolaliajwa jiw pejmatpʉatanxot? Xamal chiekal matabijam. To'a-eli Beelzebú pijaxtat. Samata, xamal jʉm-ampox xanliajwabej japox diachwʉajnakolaxa-el. ");
INSERT INTO guoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Xan dep to'ax Espíritu Santo pijaxtat. Ja-an wʉt, diachwʉajnakolax xamalxot pat Dios tato'almatkoi. ");
INSERT INTO guoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Asew natkowasia wʉt asan pejbaxot, leyaxili bapijin wʉajna wʉt, japon xabich mamnik wʉtbej. Majt bapijin kuiyaxaes tathoetat. Do ja-aech wʉt, bapijin pejew nosaxaeli” —aech Jesús fariseosliajwa. (Jesús japox jʉm-aech fariseos chiekal matabijaliajwa Jesús xajʉppox dep to'aliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jesús pejme jʉm-aech fariseosliajwa: “Jiw xan nanejweslapi, japi tadaelmajiw. Is-elbejpi xan nejxasinkaxpoxan. Japi nawetabejsfʉlbej tajbichax. ");
INSERT INTO guoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Diachwʉajnakolax xan jʉm-an. Jiw xan nanaexasiti, japi jiw Dios beltaeyaxaes puexa babijaxan ispoxanliajwa, babejjamechan naksiyapoxanliajwabej Diosliajwa. Pelax jiw jʉm-aech wʉt babejjamechan Espíritu Santoliajwa, Dios beltaeyaxisal japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jiw babejjamechan jʉm-aech wʉt xan puexa jiw pakoewkolnanliajwa, japi Dios kawʉajan wʉt beltaeliajwas, japi Dios beltaeyaxaes. Jiw jʉm-aech wʉtlax babejjamechan Espíritu Santoliajwa, Dios beltaeyaxisal japi jiw. Bʉ'wʉajan toepaxilbejpi. Pomatkoicha pejbʉ'wʉajnaxaeli” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Do pejme Jesús jʉm-aech fariseosliajwa: “Naebaechnaechan, pachaemnaechan, pejbaechbej pachaem. Naebaechnaechan, chaemilnaechan, pejbaechbej chaemil. Kaenanʉla naebaechnaechan matabijas pejbaechtat. ");
INSERT INTO guoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Xamal fariseos xabich chachoelam. Me-ama jom liklasia wʉt, ja-am xamal. ¿Machiyaxaelamkat, ja-am wʉt jʉmchiliajwam pachaempoxan, xamal babejchowam wʉt? Babejchowam xot, jʉmchiyaximil pachaempoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jiw, pachaempi, jʉm-aech pachaempoxan, pejnejchaxoelaxan pachaem xot. Jiw babejchowlax jʉm-aech pachaema-elpoxan, pejnejchaxoelaxan chaemil xot. ");
INSERT INTO guoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Xan jʉm-an xamalliajwa. Jiw chaemili Dios kastikas wʉt, japamatkoitat japi kaenanʉla kastikaxaes, jʉm-aech xoti pachaema-elpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Xamal jʉm-am wʉt pachaempoxan, Dios kastikaxil. Pelax xamal jʉm-am wʉt pachaema-elpoxan, Dios kastikaxael xamal” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Do jawʉx, kaesʉapich fariseos, judíos chanaekabʉanapibej, jʉm-aechi Jesúsliajwa: —Jiw chanaekabʉanan, xanal taesian koechax chiekal matabijaliajwan, diachwʉajnakolax xam Dios to'akponam wʉt —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús jʉmnot wʉt, jʉm-aechon fariseosliajwa, judíos chanaekabʉanapiliajwabej: —Xamal babejchowam, Dios naexasis-emilpim. Naketo'am isliajwan koechax asbʉan jʉmch taeliajwam. Pe taeyaximil pajelkoechax. Pe taeyaxaelam, me-ama chajia Dios is profeta Jonásliajwa, jiw chiekal matabijaliajwa japon Dios to'aspon. ");
INSERT INTO guoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás tres matkoiyan pinbaxin pejwoejtat. Xanliajwabej, me-ama japox, jachiyaxael, xan puexa jiw pakoewkolnanliajwa. Nacha-osaxaeli mʉaxwʉajtat tres matkoiyanliajwa —aech Jesús pejpatʉpaxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jesús pejme jʉm-aech fariseosliajwa, judíos chanaekabʉanapiliajwabej: “Asamatkoi, puexa jiw babejchow Dios pejwʉajnalel nuilaxael tasalaliajwas japi ispoxanliajwa, kastikaliajwasbej. Jawʉt Nínive paklowaxpijiw nuilaxael Dios pejwʉajnalel xamal tasalaliajwa, xan nanaexasis-emil xot. Chajiakolaxtat Jonás japi jiw naewʉajan wʉt, japi jiw kamta kofa babijaxan ispoxan, japi isfʉlaliajwa Dios nejxasinkpoxan. Xan kaes pejme pachaeman. Me-ama Jonás, jachi-enil. Pelax xan chiekal nanaewes-emil. Xan nanaexasis-emilbej. ");
INSERT INTO guoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jawʉtbej Saba tʉajnʉpijiwpaklokolow, nukaxael Dios pejwʉajnalel xamal tasalaliajwa, xan nanaexasis-emil xot. Japow chajiakolaxtat xabich atʉaj fʉlaen rey Salomón pejmatabijsax pajut chiekal jʉmtaeliajwa. Xan kaes pejme pachaeman. Me-ama rey Salomón, jachi-enil. Xamal naewʉajnax chiekal matabijaliajwam Dios. Pelax xan chiekal nanaewes-emil. Xan nanaexasis-emilbej” —aech Jesús fariseosliajwa, judíos chanaekabʉanapiliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús pejme jʉm-aech fariseosliajwa, judíos chanaekabʉanapiliajwabej: “Dep nakolt wʉt aton pejmatpʉatxot, nanʉamt xabich mamo'alxot. Wʉlwekon asan pejmatpʉatxot jaxot damlathʉlaliajwa. Faena-el wʉt, nejchaxoel wʉt, jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Xan pejme nawiasaxaelen aton pejmatpʉat poxade, majt nakoltaxxot’ —aech dep, nejchaxoel wʉt. Do jawʉt, dep kaxa nawia'an wʉt, faenlison japon aton. Dep nejchaxoel atonliajwa: ‘Asan dep le-elfʉk xan tajwʉlela. Samata, xabich pachaem xan pejme leliajwan japon pejmatpʉatxot’ —aech dep, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Do jawʉt, dep fʉlaech asew dep wʉljaesliajwa. Japon dep tameja asew, siete dep. Japi siete dep kaes chaemil. Me-ama dep matxoelapijin, jachi-eli. Do jawʉt, puexa dep lowlisi japon aton pejmatpʉatxot. Ja-aech wʉt, japon aton kaes pejme xabich nabijat. Me-ama majt nabijat wʉt, jachi-elon. Xamalbej jachiyaxaelam. Kaes pejme babejchowaxaelam” —aech Jesús fariseosliajwa, judíos chanaekabʉanapiliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús xabich jiw naewʉajan wʉt batat, jawʉt japon pen pat, pakoewbej. Japi tathoetat nuil. Japi wʉajnawet nospaeliajwapi, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Samata, jawʉt kaen, jaxotpijin, mox soepan wʉt Jesúsxot, jʉm-aechon: —Jiw chanaekabʉanan, nej-en, nakoew sʉapich, pa'an. Japi ba fʉletlel nuil. Japi nospaesia, xam sʉapich —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon: —¿Achewkat, me-ama taj-en, takoewbej? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Do jawʉt, Jesús xanal japon pejnachalwanlel nataxdoefa wʉt, jʉm-aechon: —Ampi tajnachalapi, me-ama takoewbej. Watho', me-ama taj-en. ");
INSERT INTO guoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Jiw is wʉt taj-ax Dios nejxasinkpoxan, japon athʉxotsepon, ja-aech wʉt, japilap, me-ama takoew, taj-enbej —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Do jawʉt, japamatkoitat wʉt, Jesús nakolt baxot pukababʉ' poxaliajwade. Pat wʉton, eklison jaxot. ");
INSERT INTO guoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jawʉt xabich jiw pat Jesúsxot. Jiw xabich xot, Jesús falkam jul ekaliajwa jaxot. Do jawʉt, jiw pʉtat nama. ");
INSERT INTO guoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Do jawʉtbej, Jesús xabich wʉajantat japi jiw naewʉajan, japi chiekal matabijaliajwa. Jʉm-aechon: “Aton fʉlaech pejlul poxade trigo xasaljabaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Xasaljaba wʉt, asew trigo natacholan nʉamtat. Jawʉx mia pat xaeliajwa japi trigo, oeli nʉamtat. Do jawʉt, japi trigo xaeslisi. ");
INSERT INTO guoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Asew natacholan ia'xot. Jaxot as xanaja'al. Japi trigo kamta naboela, sat kaes tʉajnik xot, sat kaesʉapich xot sat. ");
INSERT INTO guoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Do xabich masxaenk wʉt, selnas wʉt, matkaens japi trigo, tathinkasnika-el xotdik. ");
INSERT INTO guoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Asew trigo natacholanpi na-e'lʉ tasiaptasxot. Japi trigo naboela wʉt, jawʉtbej na-e'lʉ naboela. Na-e'lʉ kaes athʉ. Samata, trigo ti'sax itfi'il. Samatabej, japi trigo naboes-el. ");
INSERT INTO guoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Asew trigo natacholan sat pachaemxot. Japi trigo puexa chiekal naboela. Trigoton chiekal ti'sfʉl wʉt, chiekal naboet. Asew trigoton naboet cien trigofu. Asew trigoton naboet sesenta trigofu. Asew trigoton naboet treinta trigofu. ");
INSERT INTO guoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Xamal chiekal matabijasiam wʉt Dios pejmatabijsax, ¡chiekal naewe'e xan naewʉajnaxpox!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Do jawʉt, xanal pejnachalwan mox soepax Jesúsxot. Jesús wʉajnachaemtax wʉt, jʉm-an: —¿Ma-aech xotkat jiw xabich naewʉajnam wʉajantat? —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús jʉmnot wʉt, jʉm-aechon: “Dios xamal tapaei chiekal matabijaliajwam Dios puexa pejjiw tato'laxaelpox. Asew jiw japox matabijaxil. Japi asbʉan jʉmch naewesaxael. Xamallax naewetam wʉt, chiekal matabijaxaelam, achax chiyaxael japawʉajan. ");
INSERT INTO guoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chiekal tataeflafʉlpon tejew, japon kaes pejme chaxdusaxaelen. Asanlax chiekal nawetataeflafʉla-elpon tejew, japon kaesʉapich nawetataefʉlpox, puexa kefisaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Samata, xan jiw naewʉajnax wʉajantat. Japi taen wʉt xan isxpoxan, japi chiekal matabijaxil, ma-aech xot xan japoxan isx. Japi nanaewet wʉtbej xan jʉm-anpoxan, chiekal jʉmmatabijaxili, achax chiyaxael japoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dios pejprofeta Isaías chajia lelox, jʉm-aech Dios jʉm-aechpox jiw jʉmmatabijaxilox, naewʉajnas wʉti Dios pejjamechan: ‘Jiw xabich naewesaxael. Pe japi jʉmmatabijaxil naewʉajnaspoxan. Jiw taen wʉt ja-aechpoxan, japoxan japi jiw matabijaxil, achax chiyaxaelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Japi matnaetink xot, matabijaxili chimiawʉajan. Japibej, me-ama pajut naecho'takʉka wʉt, ja-aechi jʉmtae-elaliajwa. Japibej, me-ama matseka wʉt, ja-aechi tae-elaliajwa. Samata, japi matabijaxil tajjamechan nanaexasisliajwa. Samata, xan bʉ'weyaxinil japi jiw’ —aech Dios jʉm-aechpox. ");
INSERT INTO guoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Xamal taenampoxan, asew jiw japoxan taen wʉt, japi nejchachaemlaxael. Xamal jʉmtaenampoxan, asew jiw japoxan jʉmtaen wʉt, japibej nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Diachwʉajnakolax xan jʉm-an. Xabich profetas, asew xabich pachaempibej, xabich taesiapi Mesías, xamal amwʉtjel taenampon. Pe japi tae-el, chajia wʉajna tʉp xoti. Japi xabich jʉmtaesiabej chimiawʉajan, xamal jʉmtaenampoxan. Pe japi jʉmtae-el” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Do pejme Jesús jʉm-aech xanal pejnachalwanliajwa: “¡Chiekal nanaewe'e xan naewʉajnaxpox! Chiekal chanaekabʉanaxaelen, achax chiyaxael trigo xasaljabapox. ");
INSERT INTO guoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Trigo natacholanpox nʉamtat, japoxlap, me-ama Dios puexa pejjiw tato'laxaelpox. Jiw naewet wʉt japox, chiekal jʉmmatabija-eli. Samata, Satanás fʉlaen japilel japi kofaliajwa Dios naexasisfʉlpox. ");
INSERT INTO guoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Trigo, ia'xot natacholanpi, kamta naboelapi, japi trigo, me-ama asew jiw Dios pejjamechan jʉmtaen wʉt, kamta naexasiti. Do jawʉt, xabich nejchachaemili. ");
INSERT INTO guoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pe xabicha-el japi jiw pejxanaboejaxan Diosliajwa, chiekal naexasisfʉla-el xotfʉki Dios. Japi jiw, me-ama trigo tathinkasnika-elpi. Chiekal ti'sfʉla-elbejpi. Dios naexasit xoti, asew jiw bʉ'wʉajanpaeis wʉt, o, chaemilpox wepach wʉt, jawʉt japi jiw kaes xanaboejafʉla-eli Dios. Samata, kofapi Dios naexasisfʉlpox. ");
INSERT INTO guoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Trigo, natacholanpi na-e'lʉ tasiaptasxot, matxoelanaboelapi, japi trigo, me-ama asew jiw Dios pejjamechan jʉmtaeni. Japox jʉmtaen wʉt, naexasiti. Do jawʉx, asaxan nejchaxoel xoti, kofapi naexasitpox Dios pejjamechan, kaes nejchaxoelafʉl xoti ampathatpijaxankal. Nejchaxoelafʉlbejpi kemaenkaliajwa. Xabich kaes plata kanasiapi. Samata, japoxan nejchaxoel xoti, kaes naexasisfʉla-eli Dios. Samatabej, xabicha-el japi pejxanaboejaxan Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Trigo, natacholanpi sat pachaemxot, japi, me-ama asew jiw. Dios pejjamechan jʉmtaen wʉti, japi chiekal naexasit, matabija xoti, achax chiyaxaelpox. Japi jiw isfʉl Dios nejxasinkpoxan. Japi jiwlap, me-ama trigo natacholanpi sat pachaemxot. Asew jiw japixot chiekal is Dios nejxasinkpoxan. Japi jiwlap, me-ama trigotonan naboeti cien trigofu. Asew jiw japixot kaesʉapich is Dios nejxasinkpoxan. Japi jiwlap, me-ama trigotonan naboeti sesenta trigofu. Asew jiw japixot chiekal is-el Dios nejxasinkpoxan. Japi jiwlap, me-ama trigotonan naboeti treinta trigofu” —aech Jesús, xanal pejnachalwan nachanaekabʉana wʉt trigowʉajanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Do jawʉx, Jesús jʉm-aech asawʉajan: “Dios puexa pejjiw tato'alpox, me-ama aton xasaljaba trigo pachaempi pejlultat, ja-aechlap-is japox. Japi trigo pachaem naboelaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Japon moejt wʉt, padaelman fʉlaech japon pejlul poxade. Japalulxot japon xasaljaba, me-ama trigo ja-aechpi. Xasaljabax ketoet wʉt, jaxot chijiapon. ");
INSERT INTO guoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Do baxael, trigo naboela wʉt, do jawʉtbej naboela, me-ama trigo ja-aechpi. ");
INSERT INTO guoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Do jawʉt, lulpijin pamakjiw pat japon pejbaxot. Japi jʉm-aech: ‘Tajpaklon, trigo xasaljabampi nejlultat majt, chiekal pachaempi. ¿Pe ma-aechxotkat naboelabej, me-ama trigo ja-aechpi nejlultat?’ —aech pamakjiw. ");
INSERT INTO guoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lulpijin jʉm-aech: ‘Kaen tadaelman xasaljaba, me-ama trigo ja-aechpi tajlulxot’ —aechon pamakjiwliajwa. Do jawʉt, pamakjiw wʉajnachaemt wʉt, jʉm-aechi: ‘¿Pachaemkat xamliajwa xanal tʉsliajwan, me-ama trigo ja-aechpi?’ —aechi lulpijinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Do jawʉt, lulpijin jʉm-aech: ‘El’ —aechon. ‘Me-ama trigo ja-aechpi, tʉtam wʉt, chatʉsaxaelambej trigo. ");
INSERT INTO guoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Samata, ¡tapaem, trigo sʉapich, kaewʉtje ti'sliajwa! Trigo chiekal ti't wʉt, jawʉt, to'axaelen matxoela tasiapsliajwas, me-ama trigo ja-aechpi. Do jawʉx, me-ama trigo ja-aechpi chamatakuiyaxaes. Do jawʉt, chanosaxaes, me-ama trigo ja-aechpi lausliajwas. Do baxael, trigo jola, trigo cha-owabatat nawecha-owaxael’ —aech lulpijin” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Do jawʉx, Jesús naewʉajan wʉt jiw, asawʉajantat jʉm-aechon: “Dios puexa pejjiw tato'alpox, me-ama mostazafut, aton mʉtht pejlultat. Do jawʉx, kamta wenaboeltas. Weti'tasbejpon. ");
INSERT INTO guoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Diachwʉajnakolax japafut kaes pejme cha-aelfut. Kaewaech wʉt, kamta ti't kaes athʉ. Me-ama asew lulxot mʉthasi, jachi-el. Ti't wʉt, chiekal nae. Samata, pachaem mia pejfenan isliajwa japanaedalanxot” —aech Jesús mostazafutliajwa. (Jasoxtat japi jiw naexasit Dios tato'alpox majt kaesʉapich. Kaesʉapich matkoiyan wʉt, kaes pejme xabichaxael jiw.) ");
INSERT INTO guoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Do jawʉx, Jesús pejme jʉm-aech asawʉajantat jiwliajwa: “Dios puexa pejjiw tato'laxaelpox, me-ama levadura. Kaeow pawis pan isliajwa wʉt, trigobelan thonpow, kaesʉapich levadurabej. Tanialtow levadura posapa, puexa pansap puthlaliajwa. Do jawʉt, cha-etow levaduratat japapansap puthlaliajwa, pinasapaliajwabej” —aech Jesús jiwliajwa. (Jachiyaxaelbej, asamatkoi Dios puexa pejjiw tato'laxael wʉt. Pothata jiw xabich xajʉpaxael.) ");
INSERT INTO guoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús naewʉajan wʉt jiw, wʉajantat naewʉajanpon. Masoxtat asbʉan jʉmch naewʉajna-elon. ");
INSERT INTO guoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Japox ja-aech, pat xot Dios pejprofeta chajia jʉm-aechpox, Mesías jʉmchiyaxaelpox: “Naewʉajnaxaelen wʉajantat. Jʉmchiyaxaelen jiw majt matabija-elpoxan. Akaseskolaxtat Dios that is wʉt, amwʉtjelbej, japoxan jiw matabija-el” —chiyaxaelpox Mesías. ");
INSERT INTO guoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús bʉxtoet wʉt, kejachapon japi jiw naweliajwa. Do jawʉx, ba lowpon, xanal pejnachalwan sʉapich. Jaxot wʉton, xanal mox soepax Jesús. Do jawʉt, xanal Jesús wʉajnachaemtax chiekal nachanaekabʉanaliajwa wʉajan, me-ama trigo ja-aechpiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Do jawʉt, Jesús jʉmnot wʉt, najʉm-aechon xanalliajwa: “Trigo pachaempi xasaljabapon, japonlap xan, puexa jiw pakoewkolnanponan. ");
INSERT INTO guoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","‘Lul’ —aech wʉt, jʉmchiliajwa: ‘Jiw ampathatpijiw’. ‘Trigo pachaempi’ —aech wʉt, jʉmchiliajwa: ‘Jiw tato'laspi Dios’. ‘Me-ama trigo ja-aechpi’ —aech wʉt, jʉmchiliajwa: ‘Satanás tato'laspi ampathatat’. ");
INSERT INTO guoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Me-ama trigo ja-aechpi xasaljabapon, japonlap lulpijin padaelman. Japon pawʉl Satanás. ‘Trigo jolax’ —aech wʉt, jʉmchiliajwa: ‘Asamatkoi ampathatpijiw toesaxaes Dios’. ‘Trigo chatsiaps’ —aech wʉt, jʉmchiliajwa: ‘Dios pej-ángeles’ —chiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Japox jachiyaxael, that toepaliajwa wʉt jiw Dios naexasis-elpiliajwa. Japi, me-ama trigo ja-aechpi, jitat lausaxaes. ");
INSERT INTO guoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Xan, puexa jiw pakoewkolnan, to'axaelen Dios pej-ángeles tamejaliajwapi jiw babijaxan ispi, asew jiwbej, japi, itpaeipi asew jiw babijaxan isliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Japi jiw pelsaxaes jit pinjiyax poxadik. Jaxotdik xabich noeyaxaeli, bowaxaes xot jitat. Bʉa'tatisaxaelbejpi, xabich nabijasaxael xot. ");
INSERT INTO guoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dios naexasitilax, japi duilaxael pax Diosxotse. Jaxotse japi jiw xabich nejchachaemlaxael. Me-ama juimt matkoipijin itliak wʉt, jachiyaxael japi jiw. Xamal chiekal matabijasiam wʉt Dios matabijtpox, ¡chiekal naewe'e xan jʉm-anpox!” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús pejme jʉm-aech wʉajantat xanalliajwa: “Dios puexa pejjiw tato'alpox, me-ama xabich ommaeyaxan chamoestaspox lultat. Japox lulpijin chajia maliach chamʉtht pejlultat. Do baxael, asan chafaen chamoestaspox. Chafaen wʉt, do jaxot, kawʉtat pejme chamoeston japox. Japon xabich nejchachaemil. Do jawʉt, fʉlaechlison puexa pejew mowaliajwa, japaplatatat japalul chawʉajsliajwa, ommaeyaxan chamʉthtasxot” —aech Jesús xanalliajwa. (Me-ama xabich ommaeyaxan chafaenpon xabich nejchachaemil, jachiyaxaellap-is, jiw matabija wʉti wajpaklokolan Dios.) ");
INSERT INTO guoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Do pejme Jesús jʉm-aech xanal pejnachalwanliajwa: “Dios puexa pejjiw tato'alpox, me-ama perlas wʉajsan. Japon jalwek perlas, xabich pachaempi, wʉajsliajwa. Faen wʉton kaet perlat, xabich ommaenkpot, jawʉt puexa pejew mowapon, japaplatatat wʉajsliajwapon japot perlat” —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Do jawʉtbej, Jesús jʉm-aech xanal pejnachalwanliajwa: “Dios puexa pejjiw tato'alpox, me-ama chinchorro, pukaxot xawawaels wʉt, ja-aechox. Nejmachbaxi xawawaels. ");
INSERT INTO guoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chinchorro xabich baxi wʉlʉk wʉt, nabaxitpi chajolkafʉlde thaejtade. Jaxotde chalaki baxi itfesliajwa. Pachaempikal jefʉldiki canasta poxadik. Do jawʉt, chaemili pelsfʉli asalel. ");
INSERT INTO guoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jasox jachiyaxaelbej, that toepaliajwa wʉt. Jawʉt Dios pej-ángeles fʉloeyaxoek jiw babejchow pejlel diajkaliajwa pachaempixot. ");
INSERT INTO guoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Do jawʉx, babejchow pelsaxaeks jit pinjiyax poxadik. Jaxotdik xabich noeyaxaeli. Bʉa'tatisaxaelbejpi, xabich nabijasaxael xot” —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús xanal nawʉajnachaemt wʉt, jʉm-aechon xanal pejnachalwanliajwa: —¿Xamalkat jʉmmatabijam xan naewʉajnaxpoxan? —aech Jesús xanalliajwa. Xanal jʉmnotx wʉt, jʉm-an: —Tajpaklon, diachwʉajnakolax xanal puexa chiekal jʉmtaenx japoxan —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Do jawʉt, Jesús jʉm-aech xanalliajwa: —Judíos chanaekabʉanapi matabija Dios puexa pejjiw tato'alpox. Japi xan nanaexasit wʉt, japibej tajnachalaxael. Me-ama aton pejbaxot xabich owa ommaenkpoxan, asew pajel, asew paduj, ja-aechbej judíos chanaekabʉanapi. Japi matabija pajelnaewʉajnaxan, xan naewʉajnaxpoxan tajutliajwa. Japi matabijabej padujnaewʉajnaxan, chajia lelspoxan. Puexa japoxan pachaem japi naewʉajnaliajwa jiw —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Do jawʉt, Jesús bʉxtoet wʉt wʉajan naewʉajanpox, fʉlaechon Nazaret paklowax poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Do jawʉx, patlison Nazaret paklowax, pejtʉajnʉkolaxxot. Jaxot tʉaduton jiw naewʉajnaliajwa judíos naewʉajnabaxot. Japi jʉmtaen wʉt Jesús naewʉajanpox, xabich nejchaxoelanuili. Samata, nakaewa najʉm-aechi: —¿Amxotkat ampon puexa japoxan xabich matabijt? ¿Ma-aechon koechaxan isliajwa? ");
INSERT INTO guoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Diachkat ampon José carpintero nabichan paxʉlna-elkat? Jesús pen pawʉl María. Ampon pakoew ampilape. Kaen pawul Santiago. Asan pawul José. Asan pawul Simón. Asan pawul Judas. ");
INSERT INTO guoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jesús pakoewbej, watho', japi duil xatisxot. ¿Amxotkaton faek puexa matabijsax, pamamaxbej? —na-aechi nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Samata, japi naexasis-el Jesús naewʉajanpox. Do jawʉtbej, Jesús jʉm-aech pajutliajwa: —Profetas sitaens popaklowaxanpijiw. Pelax profeta sitae-esal pejtʉajnʉkolapijiw. Pejbapijiwbej sitae-esal —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Do jawʉtbej, Jesús jaxot xabich koechaxan is-el, naexasis-esal xoton. ");
INSERT INTO guoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Japamatkoiyan rey Herodes, Galilea tʉajnʉpijiw tato'lan, wʉltaen Jesús isfʉlpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Samata, Herodes jʉm-aech pamakjiwliajwa, jʉm-aech wʉton Jesúsliajwa: “Japonlap Juan, jiw bautisan. Tʉp wʉt, mat-echpon. Japonlap pejme duk. Samata, japon isfʉl koechaxan” —aech Herodes Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes chajia keto'a soldaw jaelsliajwapi Juan. Do jawʉt, Juan xawaech cadenamʉatat. Do jawʉx, jiw jebatat jiaspon. Herodes japox is, pijow pejjametat. Japow pawʉl Herodías. Japow majt Felipe pijow. Felipe Herodes pakoewan. Do baxael, Herodes fe'en pakoewan Felipe. ");
INSERT INTO guoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jasox Herodes is wʉt, Juan jʉm-aech Herodesliajwa: —Moisés chajia lelpox jʉm-aech: “¡Xam nakoewan pijow nijow dofaximil! ¡Japox chaemil!” —aechox —aech Juan Herodesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Samata, Herodes japox jʉmtaen wʉt, japon boesasia Juan. Pe Herodes pejlewla judíosliajwa, japi xabich jʉm-aech xot: “Juan, jiw bautisan, japon Dios pejprofeta” —aech xot xabich jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pe baxael, Herodes pejcumpleaños pat. Jawʉt, fiesta wʉt, Herodías paxʉlow nababoela tadʉchpi pejwʉajnalel. Herodes xabich nejxasink japow nababoelapox. ");
INSERT INTO guoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Samata, Herodes jʉmdut chaxdusliajwa japow wʉljoeyaxaelpox. Jʉm-aechbejpon: “Nawʉljowampox chaxdus-ense wʉt, ¡Dios xan nej nakastike'!” —aech Herodes pajiowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Do jawʉx, pen bʉxto'aspox jʉm-aechow Herodesliajwa: —¡Ma amwʉt nachaxdu'e plaftat Juan, jiw bautisan, pejmatnaet! —aechow Herodesliajwa pen bʉxto'aspox. ");
INSERT INTO guoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Do jawʉt, Herodes xabich nejxaejwas Juanliajwa. Pe tadʉchpi jʉmtaen Herodes jʉmdutox. Samata, to'apon soldaw isliajwa japow wʉljowpox. ");
INSERT INTO guoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Do jawʉt, Herodes soldaw keto'a Juan taxtasiapchaliajwas. Do jawʉt, Juan taxtasiapchas jiw jebatat. ");
INSERT INTO guoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jawʉt Juan pejmatnaet chaxlaens plaftat. Do jawʉtbej, japi chaxdut pansiaw Juan pejmatnaet. Do japow pansiaw pen chaxdutow Juan pejmatnaet, japow chiekal matabijsliajwa Juan tʉppox. ");
INSERT INTO guoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Baxael, Juan pejnachala pat chaxlaeliajwa patʉpan Juan. Do jawʉt, chaxfollisipon. Mʉthtlisipon. Do jawʉx, Juan pejnachala fʉlaech Jesús poxade. Jesúsxot pa'a wʉt, chapaeilisi Juan taxtasiapchaspox. ");
INSERT INTO guoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús jʉmtaen wʉt Juan boesaspox, Jesús chijia falkamtat asalel tamachaliajwa, xanal pejnachalwan sʉapich. Pe jawʉt, jiw matabija wʉt, japibej nakola paklowanxot wʉajnade fʉlaeliajwa pʉtlel. ");
INSERT INTO guoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Samata, Jesús chapa'a wʉt falkamtat pukababʉ'tat, xabich jiw taenson pʉtlel. Taen wʉton japi jiw, xabich beltaenpon. Samata, jawʉt Jesús boejthʉt jiw bʉ'xaeya, japi bʉflaenspi. ");
INSERT INTO guoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Do jawʉt, tuila wʉt, xanal pejnachalwan mox soepax Jesús. Jawʉt xanal jʉm-an: —Tuilalisox. Amxot tʉajnʉchan mox ajil. Amxotbej ajil naxaeyaxan wʉajsliajwas. Samata, ¡ampi jiw to'im tʉajnʉchan poxade, pajut pejew naxaeyaxan wʉajsliajwa! —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús jʉmnot wʉt, jʉm-aechon xanalliajwa: —Japi wewe'pa-esal atʉaj fʉlaeyax naxaeyaxan wʉajsliajwa. ¡Xamal najut chaxduim naxaeyaxan japi jiw xaeliajwa! —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xanal jʉmnotx wʉt, jʉm-an: —Xanalxot asbʉan jʉmch cinco pan, kolenje baxinbej. Xajʉpaxil puexa jiwliajwa —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Do jawʉt, Jesús jʉm-aech xanalliajwa: —¡Ampalel xalaemni! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Do jawʉt, Jesús to'a jiw chalakaliajwa polaxot. Jawʉt chafiton cinco pan, kolenje baxinbej. Do jawʉt, athʉ natachaemse wʉt, gracias-aechon, panliajwa, baxiliajwabej, Dios kawʉajnaliajwa wʉt. Jawʉt jalkafʉl panes, baxibej. Jalkafʉl wʉt, pejnachalwan nachaxduifʉlon xanal sasfʉlaliajwan. Jawʉt sasfʉlax puexa jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Puexa jiw chiekal xael. Chiekal nafniabejpi. Kaechatoel wʉt xaeyax, xanal jiax matpirantat jiw mali. Wʉlʉx doce matpiran, baxitoerow, pan malsibej. ");
INSERT INTO guoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jiw xaelpi, japi cinco mil poejiw. Watho' xajui-esal, yamxi sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Do japoxwʉx, Jesús xanal nato'a falkam julaliajwan, wʉajna chaliknaliajwan. Jesús kaweta namanfʉk jiw to'aliajwapon, pejbachan poxade japi jiw naweliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Puexa jiw nawia wʉt, japon jul mʉax matwʉajase, tamach Dios kawʉajnaliajwa. Madoi wʉt, tamachon mʉaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jawʉt xanal falkamtat xabich atʉajan. Truxan pinanʉl jʉjabas falkam, xabich joewa matalech xot falkam. ");
INSERT INTO guoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Do jawʉt, naliana-el wʉtfʉk, Jesús fʉlaen minakaldin xanal poxadin. ");
INSERT INTO guoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Xanal japox taenx wʉt, xabich belwax. Do jawʉt, xanal pota na-oenkax, xabich belwax xot. Xanal jʉm-an: —¡Yee, dep amka! —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Do jawʉt, xanal najʉm-aechon: —¡Nabej nejlewle'! ¡Xanpe'! —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Do jawʉt, Pedro jʉm-aech: —Tajpaklon, xam Jesúsnam wʉt, ¡xanbej nato'im minakal fʉlaeliajwan xam poxade! —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús jʉm-aech: —¡Xabʉa'din! —aechon. Do jawʉt, Pedro falkamxot nandikon minadik. Fʉlaechlison Jesús poxade minakalde. ");
INSERT INTO guoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pe jawʉt, Pedro xabich joewa wikax taen wʉt, xabich beljowpon. Do jawʉt, Pedro matkakiawafʉldik. Do jawʉt, na-ʉalison pejlewt. Jʉm-aechon: —Tajpaklon, ¡xabʉa't! ¡Xan nabʉ'wem bu'la-elaliajwan! —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Do jawʉt, Jesús makafit wʉt Pedro, jʉm-aechon: —Pedro, ¿ma-aech xotkat xam chiekal naxanaboejs-emil? ¿Ma-aech xotbejkat nejchaxoelam: “Xan xajʉpaxinil fʉlaeliajwan minakalde” —amkat, nejchaxoelam wʉt? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Japi kolenje falkam jul wʉt, joewa chiekal toep. ");
INSERT INTO guoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Do jawʉt, xanal brixtat nuilx falkamtat Jesús pejwʉajnalel. Xanal jʉm-an: —¡Diachwʉajnakolax xam Dios paxʉlnam! —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xanal chapatx puka wesklelde, Genesaret tʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Japatʉajnʉpijiw, japi jiw matabijtpi Jesús. Samata, wʉltaen wʉti Jesús chapatpox japatʉajnʉxot, japi jiw bʉflaeni bʉ'xaeya Jesúslel. ");
INSERT INTO guoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Japi wʉljow Jesús tapaeliajwa bʉ'xaeya jachaliajwa Jesús pejsumta-osax matdukafʉlpox. Do jawʉt, puexa japi jiw jacha wʉti, chiekal boejthʉslisi. ");
INSERT INTO guoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kaesʉapich fariseos, judíos chanaekabʉanapibej, fʉlaen Jesúslel. Japi fʉlaen Jerusalén paklowaxxot. Pat wʉti Jesúsxot, jʉm-aechi: ");
INSERT INTO guoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ma-aech xotkat nejnachala kofa wajwʉajnapijiw pejkabʉananpoxan? ¿Ma-aech xotbejkat majt xabich piach kekakias-eli, xaeliajwa wʉt? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús jʉmnot wʉt, jʉm-aechon japiliajwa: —¿Ma-aech xotbejkat xamal naexasisfʉla-emil Dios tato'alpox? Xamal najut naexasisfʉlam naewʉajnampoxankal. ");
INSERT INTO guoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios chajia jʉm-aech: ‘¡Sitaem nej-ax, nej-enbej!’ —aech Dios. Jawʉtbej Dios jʉm-aech: ‘Nej-ax, nej-enbej, sitae-emil wʉt, xam tʉpaxaelam kastikaxtat’ —aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Xamal, fariseospim, judíos chanaekabʉanampimbej jʉm-amlax: ‘Aton jʉm-aech wʉt paxliajwa, penliajwabej: “Xamal kajachawaesaxinil, puexa tejewpi Diosxot jʉmdutx xotlis chaxdusliajwan” —aech wʉton, japon japox jʉm-aech, kajachawaesaxil xoton pax, penbej’ —am xamal asbʉan jʉmch. Jasoxtat xamal fariseospim, judíos chanaekabʉanampimbej, mastaenam Dios tato'alpox, najut xamal naewʉajnampoxankal naexasitam xot. ");
INSERT INTO guoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Xamal naekichachajbapijwam! Isaías, Dios pejprofeta, diachwʉajnakolaxpox chajia lel Dios jʉm-aechpox xamalliajwa. Japox jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ampi jiw, me-ama nasitaen wʉt, ja-aechi. Chimiajamechan naksiyabejpi xanliajwa. Pe pejnejchaxoelaxantat xan nasitae-eli. ");
INSERT INTO guoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Japi nakawʉajnaxtat najʉm-aech wʉti: “Xam nejxasinkax” —na-aech wʉti, japox xanliajwa omjil. Japi kawʉajanpoxan, pajutliajwakal’ —aech Dios jʉm-aechpox xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Do jawʉt, Jesús jiw la kaes moxaliajwadin. Jawʉt jʉm-aechon: —¡Chiekal najʉmtaem matabijaliajwam jʉmchiyaxaelenpox! ");
INSERT INTO guoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jiw naxaeyax xael wʉt, babejchow nadofaxil. ¡El! Pelax jiw jʉm-aechpoxan pejkaechantat, japoxantat japi jiw babejchow nadofaxael —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Do jawʉt, xanal pejnachalwan mox soepax Jesús jʉmchiliajwan. Do jawʉt, xanal japon jʉm-an: —¿Xamkat matabijtam fariseos palalapox, jʉmtaen wʉti xam jʉm-ampox? —an xanal Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Do jawʉt, Jesús jʉm-aech wʉajantat xanalliajwa: —Taj-ax Dios mʉtha-esalpi, japi tʉsaxaes pelsliajwas. Fariseos, me-ama mʉtha-esalpi taj-ax Dios. Ja-aech japi fariseos, jiw naewʉajna-el xoti, me-ama Dios to'as. Samata, asamatkoi fariseos toesaxaes. ");
INSERT INTO guoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Samata, ¡nabej nejchaxoele' xabich fariseosliajwa, japi, me-ama itliakla nakae-itliakla namakxafolpi wʉt, ja-aech xoti! Itliaklan, asan itliaklan makxafol wʉt, japi kolenje natacholnaxaek kaemʉthadik, japi itliakal xot —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Do jawʉt, Pedro jʉm-aech Jesúsliajwa: —¡Xanal chiekal nachanaekabʉanim japawʉajan! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús jʉmnot wʉt, jʉm-aechon xanalliajwa: —¿Xamalkat-is chiekal jʉmmatabija-emil japawʉajan? ");
INSERT INTO guoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Xamal chiekal matabijam. Puexa naxaeyaxan xaelam wʉt, kaweta namana-el nejwoejtat. Baxael, nakoltox xaelampox. ");
INSERT INTO guoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pelax jʉm-am wʉt babejjamechan, japoxan nakola nejnejchaxoelaxanxot. Japoxantatbej xamal babejchow nadofaxaelam Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Jiw pejnejchaxoelaxanxot nakola babejnejchaxoelaxan. Samata, nejchaxoeli, jiw beyaxan, asew watho' bʉ'moejsaxanbej, natkowaxanbej, kichachajbaxanbej, babejjamechan jʉmchiyaxanbej asew jiwliajwa, kaes asaxan babijaxan isaxanbej. ");
INSERT INTO guoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nejmachjiw japoxan isfʉl wʉt, japoxantat japi jiw babejchow nadofaxael. Pelax, jiw xaeliajwa wʉt, majt xabich kekakias-el wʉt, japoxtat jiw babejchow nadofaxil Diosliajwa —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús Genesaret tʉajnʉxot nakolt wʉt, xanalbej, japon pejnachalwan, nakolax, japon sʉapich. Jawʉt xanal fʉlaechx, japon sʉapich, Tiro paklowax poxade, Sidón paklowax poxadebej. ");
INSERT INTO guoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jaxotde xanal pa'ax wʉt, Jesús mox soepnas pawis. Japow Canaán tʉajnʉpijow. Jawʉt nejlasfʉl wʉt, jʉm-aechfʉlow Jesúsliajwa: —Tajpaklon, David pamon, ¡taxʉlow nawebeltaem! Taxʉlow xabich nawenabijat, dep webaes xotow pejmatpʉatxot —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús jʉmnos-el japow. Do jawʉt, xanal pejnachalwan mox soepax Jesúsxot. Jawʉt xanal Jesús bʉxto'ax wʉt, jʉm-an: —To'impow nawiasliajwa pejba poxade, japow xabich nejlasfʉl xot wajwʉchakal —an xanal, Jesús bʉxto'ax wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Do jawʉt, Jesús xanal najʉm-aech: —Judíos, me-ama ovejas napelti, ja-aechi, tataeflaspon wejisal xot. Samata, Dios xan nato'a judíoskal tataeflaliajwan —na-aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Do jawʉt, japow brixtat nuk wʉt Jesús pejwʉajnalel, jʉm-aechow: —Tajpaklon, ¡xan nakajachawae'e! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús jʉmnot wʉt, jʉm-aechon japowliajwa: —Xan matxoela kajachawaesaxaelen wʉt xam, judío-atowa-emilpowam, ja-an wʉt, xan, me-ama kenosaxaelen yamxi xael wʉti pan, japapan wʉr dʉajsliajwan —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Do jawʉt, japow jʉm-aech Jesúsliajwa: —Tajpaklon, diachwʉajnakolax xam jʉm-am. Pe hasta wʉrbej xael panfʉdʉ', natacholani, wʉrpijiw pejmesabʉxfalxot —aechow. (Japox jʉm-aechow, matabijt xot Jesús xajʉppox kajachawaesliajwa judíos-elibej.) ");
INSERT INTO guoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Do jawʉt, Jesús jʉm-aech: —Pawis, xam xabich xan naxanaboejtam. Samata, kajachawaesaxaelen najʉm-ampox —aech Jesús japowliajwa. Do jawʉt, japow paxʉlow pejmatpʉatxot dep wejisallisow. ");
INSERT INTO guoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Do jaxot Jesús chijia wʉt, laejalison Galilea pukababʉ'akal. Jawʉx julon mʉax. Jaxot eklison. ");
INSERT INTO guoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Xabich jiw natamejal Jesúsxot. Japi jiw xabich bʉ'pat nabejka, itliaklabej, pejmʉaxan, pejbechanbej, wenabejkaspibej, bʉxwʉajnajilabej, xabich asew bʉ'xaenkpibej. Bʉ'xaeya bʉflaensi owas Jesús pejwʉajnalel. Jawʉt Jesús puexa bʉ'xaeya chiekal boejthʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Samata, bʉxwʉajnajila chiekal naksiya. Pejmʉaxan, pejbechanbej, wenabejkaspi, japibej chiekal wepachaems. Nabejkabej chiekal laelp. Itliaklabej chiekal taen. Ja-aech wʉt, puexa jiw jʉm-aech: “¡Dios, Israel tʉajnʉpijwas wajDios, xabich pachaem!” —aechi Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Do jawʉx, Jesús xanal pejnachalwan nala kaes mox soepaliajwan. Japonxot xanal chiekal moxan wʉt, najʉm-aechon: —Ampi jiw beltaenx, wejisal xot xaeliajwa. Japi xan nachala tres matkoije. Toellisi naxaeyaxan xafoli. Xan ampi jiw to'axinil naxae-elaxtat. To'ax wʉti naxae-elaxtat pejbachan poxade, japi jiw xabich pejlit nʉamtat boejjilaxaeli —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Xanal jʉmnotx wʉt, jʉm-an: —¿Amxotkat wʉajsaxaes naxaeyaxan puexa ampi jiwliajwa? Amxot mox ajil tʉajnʉchan naxaeyax wʉajsliajwas —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús nawʉajnachaemt wʉt, jʉm-aechon: —¿Xamalxot massʉapichkat pan? —aechon. Xanal jʉmnotx wʉt, jʉm-an: —Siete panes asbʉan jʉmch. Kaesʉapich baxixbej —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Do jawʉt, to'apon jiw chalakaliajwa satat. ");
INSERT INTO guoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jawʉt chafitlison siete panes, baxixbej. Do jawʉtbej, gracias-aechon Diosliajwa panliajwa, baxixliajwabej. Jawʉt jalkafʉlon panes, baxixbej. Jawʉt xanal nachaxduifʉlon sasfʉlaliajwan. Do jawʉt, xanal satx puexa jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Puexa jiw chiekal xael. Chiekal nafniabejpi. Do baxael, xanal pejnachalwan chanotx malsi. Wʉlʉx siete matpiran. ");
INSERT INTO guoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Naxaelpi cuatro mil poejiw. Watho', yamxibej, xajui-esal. ");
INSERT INTO guoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Do jawʉt, Jesús jiw to'a naweliajwa pejbachan poxade. Do jawʉt, Jesús falkam jul, xanal sʉapich. Jawʉt chijian Magadán tʉajnʉ poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseos, saduceosbej, fʉlaen Jesús taeliajwa, Jesús xapaejsliajwapi. Samata, pat wʉti jaxot, japi keto'a Jesús isliajwa koechax, asbʉan jʉmch taeliajwa diachwʉajnakolax Jesús Dios paxʉlan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús jʉm-aech: “Juimt tuila wʉt, thatbaxo pasoeyax taenam wʉt, xamal jʉm-am: ‘Kandiawa itwʉajnaxael’ —am xamal. ");
INSERT INTO guoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kandiawasap, thatbaxo pasoeyax taenam wʉt, itloejen da'ax taenam wʉtbej, xamal jʉm-ambej: ‘Ampamatkoi iamaxael’ —am xamal, matabijam xot. Pelax matabija-emil ampamatkoiyan Dios ispoxan. Samata, asbʉan jʉmch naketo'am koechax xan isliajwan xamal taeliajwam. ");
INSERT INTO guoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xamal babejchowam naketo'am xan koechax isliajwan. Pe xamal taeyaximil asakoechaxan. Xamal kaeyax asbʉan jʉmch taeyaxaelam. Me-ama chajiakolaxtat Dios is profeta Jonásliajwa, jiw pajut chiekal matabijaliajwa Dios xajʉppox mat-eliajwa jiw tʉpi, japi pejme duilaliajwa, jasoxbej Dios isaxael xanliajwa” —aech Jesús fariseosliajwa, saduceosliajwabej. Do jawʉt, Jesús chijia japixot. Japi tamach waelapon. ");
INSERT INTO guoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Do jawʉx, xanal Jesús pejnachalwan, Jesús sʉapich, chaliknax wʉt puka we-enlelde, xanal nejkiowx pan xalaeliajwan. ");
INSERT INTO guoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Do jawʉt, Jesús xanal najʉm-aech: —¡Chiekal taem fariseos pejlevaduraliajwa, saduceos pejlevaduraliajwabej! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jawʉt xanal nakaewa najʉm-an: —Jesús japox bej nakjʉm-aechbej, xatis nejkiows xot pan xalaeliajwas —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús matabijt xanal nakaewa jʉm-anpox. Samata, jʉm-aechon: —Xan matabijtax xamal nakaewa najʉm-ampox, pan nejkiowampoxliajwa. ¿Ma-aech xotkat nejchaxoelam panliajwa? Xamal chiekal xan naxanaboeja-emilfʉk. ");
INSERT INTO guoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Xabich we'pfʉk chiekal matabijaliajwam. Nejchafaeka-emil xan jalkafʉlax wʉt cinco pan, me-ama kaes cinco mil jiw xaeliajwa. Jawʉt xamal wʉlʉm doce matpiran malsi. ");
INSERT INTO guoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nejchafaeka-emilbej xan jalkafʉlaxpox siete panes, me-ama kaes cuatro mil jiwliajwa. Jawʉt xamal wʉlʉm siete matpiran malsi. ");
INSERT INTO guoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ma-aech xotkat nakiowa xamal jʉmmatabija-emil, xan jʉmchi-enil panliajwa? ¡Chiekal taem fariseos pejlevaduraliajwa, saduceos pejlevaduraliajwabej! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Do jawʉt, xanal tajut chiekal matabijax Jesús naksiya-el levaduraliajwa, panliajwabej. Jesús japox jʉm-aech wʉt, jʉm-aechon xanal tajut chiekal natataeflaliajwan fariseos pejnaewʉajnaxan, saduceosbej, japoxan chiekal pachaema-el xot. ");
INSERT INTO guoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús pat wʉt Cesarea de Filipo tʉajnʉxot, japon xanal nawʉajnachaemt wʉt, jʉm-aechon xanalliajwa: —¿Achanan na-aechkat jiw xanliajwa, puexa jiw pakoewkolnanliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xanal jʉmnotx wʉt, jʉm-an: —Asew jiw jʉm-aech xamliajwa: ‘Japonlap, Juan, jiw bautisan. Mat-echpon pejme duk’ —aech asew jiw xamliajwa. Asew jiw jʉm-aechbej xamliajwa: ‘Japonlap Elías, Dios pejprofeta. Mat-echpon pejme duk’ —aech asew jiw xamliajwa. Asew jiw jʉm-aechbej xamliajwa: ‘Japonlap Jeremías, o, asan Dios pejprofetasxot. Mat-echpon pejme duk’ —aech asew jiw xamliajwa —an xanal Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús pejme xanal nawʉajnachaemt wʉt, jʉm-aechon: —Xamallax, ¿achan na-amkat xanliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Do jawʉt, Pedro jʉmnot wʉt, jʉm-aechon: —Xam Cristowam, Dios athʉxotse dukpon paxʉlnam —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Do jawʉt, Jesús jʉm-aech Pedroliajwa: —Simón, Jonás paxʉlan, Dios is pachaempox xamliajwa. Japox xam najut nijaxtat matabijs-emil. Japox matabijtam taj-ax Dios, athʉpijin, pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Xan ampox jʉm-an. Pedro, xam, me-ama ia't mamnikpot, ja-am xanliajwa. Jʉm-ampox xanliajwa, japox diachwʉajnakolax. Samata, puexa xan nanaexasisaxaelpi, me-ama xam, japibej tajjiwaxael. Samatabej, patʉpax malechaxisal tajjiw. ");
INSERT INTO guoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Xam tapaeyaxaelen jiw tato'laliajwam Dios pijaxtat. Paklonaxaelambej japi jiwliajwa. Xam tapaeyaxaelam wʉt jiw japoxan isliajwa, Diosbej athʉxotse tapaeyaxael japi jiw isliajwa japoxan. Xam fiasaxaelampoxan jiw is-elaliajwa, Diosbej athʉxotse japoxan fiasaxael jiw is-elaliajwa —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Do jawʉt, Jesús xanal nabʉxfiat chapaesamatanfʉk asew jiw japon Cristopon. ");
INSERT INTO guoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Do japamatkoitat wʉt, Jesús tʉadut xanal, japon pejnachalwan, chiekal nachanaekabʉanaliajwa japon fʉlaeyaxaelpoxde, Jerusalén paklowax poxade. Jaxotde judíos-ancianos, sacerdotespaklochowbej, judíos chanaekabʉanapibej, japi pijaxtat xabich nabijasaxaelon. Boesaxaesbejpon. Pe tres matkoi wʉt, Dios mat-esaxaeson pejme dukaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Do jawʉt Pedro pejlel bʉflaechon Jesús, bʉxfiasliajwa Jesús jʉm-aechpox. Jawʉt, Pedro jʉm-aech nejthʉ'axtat Jesúsliajwa: —¡El! ¡Japox nej jachi-ele' xamliajwa! Xam jʉm-ampox Dios nejxasinka-el —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús japox jʉmtaen wʉt, natachaemchapon Pedrolel. Do jawʉt, Jesús jʉm-aech Pedroliajwa: —¡Chijiamde xanxot! Xam japox jʉm-am wʉt, jʉm-am Satanás pijaxtat. Xan nakajachawaes-emil, japox jʉm-am wʉt. Xam nejchaxoela-emil Dios pijaxan. Asbʉan jʉmch nejchaxoelam ampathatpijaxankal —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Do jawʉt, Jesús najʉm-aech xanalliajwa: —Xamal tajnachalwasiam wʉt, ¡nejkiowde najut isfʉlasiampoxan! ¡Isfʉlde pomatkoicha xan tato'laxpoxan! ¡Nejchaxoeldebej xamal nabijasaxaelampox, tʉpaxaelampoxbej, tajnachalwam xot! ");
INSERT INTO guoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Najut nejxasinkampoxankal isfʉlam wʉt, asamatkoi tʉpam wʉt, duilaximil Diosxotse. Pelax isfʉla-emil wʉt najut nejxasinkampoxan, isfʉlaliajwa xan tato'laxpoxan, ja-am wʉt, diachwʉajnakolax asamatkoi tʉpam wʉt, pomatkoicha duilaxaelam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Xabich wʉt nejew ampathatat, japoxan omjil duilaliajwam Diosxotse. Dios kastikaxaelbej xamal, xabich xot nejbabijaxan. Xajʉpaximil nejew platatat mosliajwam pasliajwam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Xan, puexa jiw pakoewkolnan, Dios pijaxtat pejme pasaxoekan ampathatasik, Dios pej-ángeles sʉapich. Do jawʉt, xamal mosaxaelen xanliajwa nabistampoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diachwʉajnakolax xamal jʉm-an. Asew jiw xamalxot, laelpifʉk, japi xan nataeyaxael, puexa jiw pakoewkolnan, kaxaxoekan wʉt Dios pijaxtat puexa tajjiw tato'laliajwan —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Do baxael, seis matkoiwʉx, Jesús fʉlaech wʉt, bʉflaechon Pedro, Santiagobej, Santiago pakoewanbej, japon pawʉlpon Juan. Japikal Jesús bʉ'fol pinamʉax, xabich athʉ poxase. ");
INSERT INTO guoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jaxotse Jesús xabich chaponanakthianpon Dios pijaxtat pejnachala pejwʉajnalel. Japon pejxubej xabich xunakthian. Me-ama juimt itliak wʉt, jaxu-aechon. Jawʉt japon pejnaxoelax, xabich papoeikolax. Xabich itliakbejpox. ");
INSERT INTO guoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Do jawʉt, chalechkal natulaelt kolenje. Japi wajwʉajnapijiw. Kaen Moisés. Asan Elías. Japi nospaei, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Do jawʉt, Pedro jʉm-aech Jesúsliajwa: —Tajpaklon, pachaem xanal amxot, xamalxotan wʉt. Nejxasinkam wʉt, tres bʉa-at isaxaelen xamalliajwa. Kaeyax xamliajwa. Asax Moisésliajwa. Asax Elíasliajwabej —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro japox naksiya wʉtfʉk, itloejen fʉloek japi matwʉajasik. Japox itloejen xabich itliak. Japox itloejentutat Dios naksiya wʉt, jʉm-aechon: “Ampon taxʉlan, xabich nejxasinkaxpon. Japonliajwa xan xabich nejchachaemlax. ¡Naewesfʉldepon!” —aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Japox jʉmtaen wʉti, Jesús pejwʉajnalel nukapa-oeljabapi satat, xabich beljow xoti. ");
INSERT INTO guoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Do jawʉt, Jesús mox soepan japixot. Jacha wʉt, jʉm-aechon: —¡Nanim! ¡Nabej belwe'! —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Do jawʉt, japi natachaema wʉt, tae-ellisi asew kolenje, jaxot ajil xotlisi. Jesúskal tamach taeni. ");
INSERT INTO guoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mʉaxxotsik baloek wʉtfʉki, Jesús nejthʉ'axtat bʉxfiat wʉt, jʉm-aechon pejnachalaliajwa: —¡Asew jiw nabej chapae' xamal taenampox! Hasta xan, puexa jiw pakoewkolnan, Dios namat-et wʉt pejme dukaliajwan, ¡jawʉt asew jiw chapaem xamal taenampox! —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Do jawʉt, Jesús wʉajnachaemtas wʉt pejnachala, japi jʉm-aech Jesúsliajwa: —¿Ma-aech xotkat judíos chanaekabʉanapi jʉm-aech: ‘Cristo pasaxilfʉk. Elías matxoela pasaxael. Do jawʉx, Cristo pasaxael’ —aechkat judíos chanaekabʉanapi? —aech Jesús pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon pejnachalaliajwa: —Diachwʉajnakolax Elías matxoela pasaxael. Japon jʉmchiyaxaelbej jiw pajut chiekal chaemsliajwa Cristo wʉajna. ");
INSERT INTO guoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pe xan jʉm-an. Elías patlison. Pe ampathatpijiw japon matabijs-elipon. Naexasis-esalbejpon. Japi jiw pajut isasiapox islisi japonliajwa. Me-ama japox, jasoxbej asew jiw isaxael xanliajwa. Xan, puexa jiw pakoewkolnan, xabich nabijasaxaelen japi pijaxtat —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Do jawʉt, Jesús pejnachala chiekal matabija, Jesús japox jʉm-aech wʉt, jʉm-aechon Juan, jiw bautisanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesús jiwxot pat wʉt, tres pejnachalan sʉapich, aton mox soepan Jesúsxot. Do jawʉt, brixtat nuk wʉt Jesús pejwʉajnalel, japon jʉm-aech Jesúsliajwa: ");
INSERT INTO guoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tajpaklon, ¡taxʉlan nawekajachawae'e! Pomatkoicha xabich nabijaton. Taxʉlan pin-iaveces jitlel jʉwal, pukalelbej, dep ketis wʉton. ");
INSERT INTO guoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Taxʉlan bʉflaenx nejnachalalel, japi boejthʉsliajwa taxʉlan. Pe japi xajʉpa-el taxʉlan boejthʉsliajwa —aech japon Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Do jawʉt, Jesús najʉm-aech xanal pejnachalwanliajwa: —Xamal tajnachalwam, Dios chiekal xanaboeja-emilfʉk. Nejnejchaxoelaxan chiekala-elbej. Xabich pin-iamatkoiyan xamalxotx. Xabich pin-iamatkoiyan naewʉajnafʉlaxbej. Kajachawaetxbej Dios chiekal xanaboejaliajwam. Pe xamal chiekal xanaboeja-emilfʉk Dios. ¡Bʉflaeman yamxʉlan xanlel! —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Do jawʉt, xanal bʉflaenx wʉt yamxʉlan, Jesús to'a nejthʉ'axtat dep nakolsliajwa yamxʉlan pejmatpʉatxot. Do jawʉt, kamta dep nakolt yamxʉlan pejmatpʉatxot. Jawʉtbej yamxʉlan chiekal pachaemlison. ");
INSERT INTO guoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Do jawʉx, xanal pejnachalwan mox soepax Jesús wʉajnachaemsliajwan, japon tamachan wʉt. Do jawʉt, xanal wʉajnachaemtax wʉt, jʉm-an: —¿Ma-aech xotkat xanal xajʉpa-enil dep nakolsax to'aliajwan? —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús xanal najʉmnot wʉt, jʉm-aechon: —Xamal xabicha-el nejxanaboejaxan Diosliajwa. Diachwʉajnakolax xan jʉm-an. Cha-aex Dios xanaboejam wʉt, jʉm-am wʉtbej: ‘Diachwʉajnakolax Dios xajʉp puexa isliajwa’ —am wʉt, nejchaxoelam wʉt, xamalbej xajʉpaxaelam dep to'aliajwam. Me-ama mostazafut cha-aelfut, ja-aechbej nejxanaboejaxan. Xamal to'am wʉt ampamʉax asalelaliajwa, mʉax diach napiasaxaeldo'. Puexa xabich xajʉpaxaelam isliajwam Dios pijaxtat, Dios chiekal xanaboejam wʉt —aech Jesús xanalliajwa.  ");
INSERT INTO guoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Me-ama ampon dep, jason, asbʉan jʉmch nakolsaxil masoxtat. Naxae-elaxtat Dios piach kawʉajnam wʉt, ja-aech wʉt, me-ama ampon dep, jason, nakolsaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús nanʉamt wʉt Galilea tʉajnʉxot, xanal, japon pejnachalwan, naknanʉamtaxbej. Do jawʉt, Jesús xanal najʉm-aech: —Xan, puexa jiw pakoewkolnan, xamalxot kaen nawiasaxael tadaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Japi jiw xan naboesaxael. Do jawʉx, tʉpx wʉt, tres matkoi wʉt, Dios namat-esaxael pomatkoicha pejme dukaliajwan —aech Jesús xanal pejnachalwanliajwa. Jesús japox jʉm-aech wʉt, xanal, japon pejnachalwanpin, xabich nanejxaejow. ");
INSERT INTO guoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dolisdo', Jesús, xanal pejnachalwan sʉapich, patx Capernaum paklowaxxot. Do jawʉt, asew jiw fʉlaen Pedrolel. Japi impuesto mat-omwʉljoew Dios pejtemplobaliajwa. Do jawʉt, japi jʉm-aech Pedroliajwa: —¿Nejpaklonkat-is mosaxael impuesto, mat-omwʉljowspox Dios pejtemplobaliajwa? —aechi Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro jʉmnot wʉt, jʉm-aechon japiliajwa: —Diachwʉajnakolax tajpaklon mosaxael impuesto —aech Pedro japiliajwa. Dolisdo', Pedro ba low wʉt, Jesús matxoelajʉm-aech Simón Pedroliajwa. Jʉm-aechon: —Ampathatat paklochow kenot impuesto, mat-omwʉljowspox gobiernoliajwa. ¿Achewkat mot impuesto? ¿Mosaxaelkat pejjiwkola? O, ¿mosaxaelkat asatʉajnʉchanpijiw? Simón, ¿achaxkat xam nejchaxoelam japoxliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Simón Pedro jʉmnot wʉt, jʉm-aechon: —Asatʉajnʉchanpijiw, japi mosaxael impuesto —aech Pedro. Do jawʉt, Jesús pejme jʉm-aech: —Ja-aech wʉt, paklochow pejjiwkola mosaxil impuesto. ");
INSERT INTO guoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pe jiw palalasamata xatisliajwa, ¡xam xabʉa'dik puka poxadik! ¡Aesamʉat xalaem baxin juiliajwam! ¡Baxin, matxoelawaesapon, japon baxin chiekal juim! Do japon baxin juwam wʉt, japabaxin pejkaechaxot faenaxaelam kaekafef. Japakafef xajʉpaxael mosliajwam nej-impuesto, taj-impuestobej. ¡Japakafef xalaemch mosliajwam japa-impuesto! —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Do jawʉx, xanal mox soepax Jesús wʉajnachaemsliajwan. Wʉajnachaemtax wʉt, jʉm-an: —¿Achankat xanalxot kaes pejme paklonaxael, Diosxotan wʉt? —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Do jawʉt, Jesús yamxʉlan la nukaliajwa japonxot. Do jawʉt, notlison yamxʉlan xanal tajwʉajnalel. ");
INSERT INTO guoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Do jawʉt, Jesús jʉm-aech: —Diachwʉajnakolax xan jʉm-an. ¡Japanejchaxoelax malis kofim! Nejchaxoelam wʉt, ¡nabej nejchaxoele': ‘Xan kaes pejme pachaeman. Me-ama asew jiw, jachi-enil’ —nabej aeche', nejchaxoelam wʉt! Yamxi jasox nejchaxoela-el. Xamallap-is jasox nejchaxoelaximil. Japox nejchaxoelafʉlam wʉt, xamal pasaximil Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaematkoisfʉl nejchaxoelam wʉt: ‘Xan kaes pejme pachaema-enil, me-ama asew jiw’ —am wʉt, nejchaxoelam wʉt, xamal nejchaxoelaxaelam, me-ama ampon yamxʉlan. Ja-am wʉt, asamatkoi paklochwaxaelam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yamxi chiekal bʉ'kʉlam wʉt xan tajaxtat, ja-am wʉt, jawʉt xanbej nabʉ'kʉlsaxaelam —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","7","Do pejme Jesús jʉm-aech xanalliajwa: “Pomatkoicha jiw babijaxan is, asew jiw to'as xoti. Pe jelxan nanaexasiti is wʉt babijaxan, asew jiw to'as xoti, to'api jiw babijaxan isliajwa, japi jiw xabich kastikaxaes Dios. Japiliajwa kaes pejme pachaemaxael ia' pinanʉl, jajaera, kaechariama ke'aliajwas, chakakofaliajwasdik mar poxadik, xabich so'nik poxadik, jaxotdik tʉpaliajwapi. Ja-aech wʉt, japi to'axil kaes asew jiw babijaxan isliajwa, jelxan nanaexasiti. ");
INSERT INTO guoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Samata, nejke-echantat babijaxan isfʉlam wʉt, o, isfʉlam wʉtbej babijaxan nejtʉakantat, ¡najut naketariowcham! ¡Najut natʉaktariowchambej, atʉaj pelsliajwam japoxan! Ja-am wʉt, kofaxaelam babijaxan isfʉlampoxan. Ja-am wʉtbej, pachaemaxaelam pasliajwam Diosxotse. Kofa-emil wʉt babijaxan isfʉlampoxan, ja-am wʉt, napelsaxaemk infierno poxadik. Jaxotdik toepaxil jit pinjiyax. Xabich chaemilaxael xamalliajwa koleke-em wʉt, koletʉakam wʉtbej, kaes babijaxan isfʉlam wʉt japoxantat. ");
INSERT INTO guoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nej-itfutatbej taenampoxtat babijaxan isfʉlam wʉt, ¡kaenanʉla najut na-itfukuim, xamalxot pelsliajwam atʉaj! Ja-am wʉt, kofaxaelam babijaxan isfʉlampoxan. Ja-am wʉtbej, kaes pejme pachaemaxael xamalliajwa, kae-itfutam wʉt pasliajwam Diosxotse. Kofa-emil wʉt babijaxan isfʉlampoxan, jachi-emil wʉt, xamal napelsaxaemk infierno poxadik. Jaxotdik toepa-el jit pinjiyax. Xabich chaemilaxaelbej xamalliajwa, kole-itfutam wʉt, kaes babijaxan isfʉlam wʉt japoxantat” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús pejme jʉm-aech xanalliajwa: “¡Xamal chiekal taem! ¡Nabej nejchaxoele' yamxiliajwa: ‘Ampi yamxi omjil’ —nabej aeche', nejchaxoelam wʉt! Dios pej-ángeles, japi duilpi athʉxotse taj-ax Dios pejwʉajnalel, tataefʉlpi yamxi.  ");
INSERT INTO guoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Xan, puexa jiw pakoewkolnan, fʉloekx ampathatxot jiw napelti bʉ'weliajwan. ");
INSERT INTO guoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Cien ovejaspon, kaen oveja wenafo'as wʉt, diachwʉajnakolax japon noventa y nueve ovejas kaweta waelaxael mʉaxxot, wʉlwekaliajwapon oveja wenafo'aspon. ");
INSERT INTO guoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Japon faen wʉt oveja, wenafo'aspon, kaes pejme xabich nejchachaemlaxael japa-ovejaliajwa. Me-ama noventa y nueve ovejasliajwa nejchachaemil wʉt, jachiyaxilon, japi ovejas napels-el xot. ");
INSERT INTO guoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nej-ax Diosbej, athʉxotse dukpon, nejxasinka-elon aton nafo'aliajwa, naexasitpon Dios” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Do pejme Jesús jʉm-aech xanalliajwa: “Dios naexasitpon babijax is wʉt xamalliajwa, ¡xabʉa'de japon poxade, japon sʉapich, tamach nospaeliajwam! Japon xamal naewet wʉt, ja-aech wʉt, pejme chiekal pachaemaxaelam japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pe japon naewes-elasia wʉt, ja-aech wʉt, ¡japon bʉflaem asew jiw, Dios naexasiti poxade, kaen o, kolenje, Dios naexasiti, japibej chiekal jʉmtaeliajwa nospaeyam wʉt, japon sʉapich, xamalliajwa babijax ispon! ");
INSERT INTO guoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pe japon jaxot naexasis-elasia wʉt Dios naexasiti pejwʉajnalel, ja-aech wʉt, bʉflaempon puexa Dios pejjamechan naexasiti natameja poxade, jaxot naewʉajnaliajwas babijax ispox kofsliajwa. Jaxot naewʉajnas wʉt, naexasis-el wʉton, ja-aech wʉt, nejchaxoelde japonliajwa: ‘Ampon Dios naexasislan. Samata, japon, me-ama impuesto mat-omwʉljoen Roma gobiernoliajwa, ja-aechon’ —amde, nejchaxoelam wʉt japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Diachwʉajnakolax xamal jʉm-an. Ampathatat jiw fiatam wʉt babijaxan isasamata, japoxanbej Diosxotse fiasaxael. Ampathatat tapaeyam wʉt jiw isliajwa pachaempoxan, japoxan Diosxotsebej tapaeyaxael jiw isliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Xan jʉm-an ampox xamalliajwa. Ampathatat xamal kolenam kaenejchaxoelaxam wʉt, kawʉajnaxtat Dios wʉljoeliajwam pachaempox, japox taj-ax Dios, athʉxotsepon, japox isaxael xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kolenje, o, tres, natameja wʉt xan tajaxtat nakawʉajnaliajwa, xan japixotaxaelen” —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Do jawʉt, Pedro mox soepan Jesús kawʉajnachaemsliajwa. Jawʉt Pedro kawʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —Tajpaklon, ¿masveceskat xan beltaeyaxaelen, nawe-isfʉl wʉt babijaxan xanliajwa? ¿Xankat beltaeyaxaelen hasta siete veces? —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon: —Xan jʉmchi-enil: “¡Hasta siete veces xam japon beltaem!” —chi-enil. Asan xabich piach babijaxan isfʉl wʉt xamliajwa, japon beltaeflaxaelam kaematkoisfʉl —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús pejme xanal najʉm-aech wʉajantat: “Dios puexa pejjiw tato'alpox, me-ama kaen rey chaemt pamakjiwliajwa, japi dewatpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Rey to'a pamakjiw kaenanʉla chaemsliajwa dewatpoxan. Japixot kaen xabich dewat pin-iat denarios. Japonbej pat reyxot. ");
INSERT INTO guoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dewatpon xajʉpa-el mosliajwapon rey. Samata, rey to'a asew pamak, dewatpon, mowaliajwas asanxot, jaxot japon esclavoliajwa. Rey to'abej dewatpon pijow mowaliajwas, japon paxibej, japon pejewbej, dewatpoxan mosliajwapon rey. ");
INSERT INTO guoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Do jawʉt, dewatpon brixtat nuk rey pejwʉajnalel wʉljoeliajwapon beltaeyax. Do jawʉt, jʉm-aechon reyliajwa: ‘¡Na'afʉk! ¡Xanfʉk nabeltaem! Mosaxaelen puexa dewataxpoxan’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Do jawʉt, rey beltaen dewataspon. Jawʉt rey jʉm-aech japonliajwa: ‘Xam nadewatampoxan chiekal toep xanliajwa’ —aech rey. Samata, rey tapaei dewatpon nawiasliajwa pejba poxade, beltaens xoton dewatpoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Do jawʉt, rey beltaenspon jaxot nakolt wʉt, xabʉ'kʉlton asan rey pamakan, japon sʉapich, kaeyaxtat nabistponje. Wʉchakalpijin dewat kaesʉapich plata, matxoelapatponliajwa reyxot. Rey beltaenspon xabich palala, taen wʉton asan nabichan, kaeyaxtat nabistjepon. Jawʉt rey beltaenspon kaechariamajaelt wʉt, kaechariamale'apon matkaenjasliajwa asan nabichan, kaeyaxtat nabistjepon. Do jawʉt, jʉm-aechbejpon: ‘¡Nadewatampoxan xam namo'e!’ —aechon asanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Do jawʉt, kaesʉapich dewatpon brixtat nukjaba rey beltaenspon pejwʉajnalel. Xabich jʉm-aechon: ‘¡Na'afʉk! ¡Xan nabeltaem! Xam mosaxaelen puexa dewataxpox’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Pe nakiowa, rey beltaenspon beltae-el asan nabichan. Japon nejwesla wʉajnawesliajwa dewataspox. Samata, kaesʉapich dewatpon wiach soldawxot, japon jeliajwas jiw jebatat. Jaxot namanaxaelon puexa dewatpoxan mosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Do jawʉt, asew rey pamakjiw, japox taen wʉt, xabich palalapi rey beltaensponliajwa. Samata, japi fʉlaech rey poxade japox chapaeliajwapi reyxot. ");
INSERT INTO guoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Do jawʉt, rey to'a pamakjiw wʉljaesliajwas majt rey beltaenspon. Japon pa'an wʉt reyxot, rey jʉm-aech japonliajwa: ‘¡Xam xabich babejnam! Xan beltaenx puexa nadewatampoxanliajwa, nawʉljowam wʉt beltaeyax. ");
INSERT INTO guoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pe xambej beltaeyaxaelam asan tamakan. Me-ama xan beltaenx, jachiyaxaelam asan tamakanliajwa. Pe xam beltae-emil asan tamakan’ —aech rey japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Do jawʉt, rey xabich palala japonliajwa. Samata, rey to'a japonbej kastikaliajwas, puexa mosliajwabejpon majt dewatpoxan” —aech Jesús, xanal nanaewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús pejme xanal najʉm-aech: —Taj-ax, athʉxotsepon, jachiyaxaelbej xamalliajwa, beltae-emil wʉt asan, Dios pejjamechan naexasitpon, babijaxan is wʉt xamalliajwa —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Do jawʉt, Jesús bʉxtoet wʉt naewʉajnax beltaeyaxliajwa, chijialison Galilea tʉajnʉxot. Jawʉx patlison Judea tʉajnʉxot, Jordánlajt weslelde, juimt julanlelsan. ");
INSERT INTO guoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Xabich jiw Jesús fʉlafos. Jaxot Jesús boejthʉt jiw bʉ'xaeya. ");
INSERT INTO guoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Do jawʉt, kaesʉapich fariseos mox soepa Jesús xapaejsliajwapi. Do kawʉajnachaemt wʉt, jʉm-aechi: —¿Poejiwkat tapaeis, nejmach masoxtat pelsliajwa pejwatho'? —aech fariseos. ");
INSERT INTO guoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús jʉmnot wʉt, jʉm-aechon fariseosliajwa: —¿Xamalkat xaljoe-emil Moisés chajia lelpox? Japox jʉm-aech: ‘Dios ampathat is wʉt, isbejpon jiw. Dios is aton, pawisbej’ —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dios jʉm-aechbej: ‘Samata, aton fit wʉt pawis, japi nakolaxael paxxot, penxotbej, japon aton, pijow sʉapich, pejlel dukaliajwa’ —aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Do ja-aech wʉt, japi kolenje, me-ama kaen wʉt, jachiyaxaeli. Ja-aech wʉt, japilis, me-ama majt kolenje wʉt, jachi-ellisi. Amwʉtjel japi, me-ama kaen wʉt, ja-aechlisi. Samata, aton fo'axil pijow, Dios pijaxtat nakjiya xot —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Japi fariseos kaes wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —Moisés chajia jʉm-aech: ‘Poejiw pelsasia wʉt pejwatho', matxoela lelaxael pelfʉt japow chaxdusliajwapon. Japon lelpox jʉmchiyaxael, ma-aech xot fo'axaelon pijow. Ja-aech wʉt, pachaem japon aton fo'aliajwa pijow’ —aech Moisés chajia lelpox. ¿Ma-aech xotkat Moisés japox tapaei? —aech fariseos. ");
INSERT INTO guoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Do jawʉt, Jesús jʉm-aech fariseosliajwa: —Xamal matnaetinkam xot, Moisés tapaei japox. Samata, Moisés xamal tapaei pelsliajwam nejwatho'. Majt, akaseskolaxtat, Dios nejxasink, aton pijow fit wʉt fo'a-elaliajwa, japowxot pomatkoicha laejaliajwapon. ");
INSERT INTO guoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pe xan jʉm-an. Aton pijow fo'a wʉt asbʉan jʉmch masoxtat, asaow fit wʉton, japox xabich chaemil Diosliajwa, bʉ'moejt xoton asaow pawis, pijowkolwa-elpow. Pe pawis pakmolow, asan aton bʉ'moejt wʉt, ja-aech wʉt, Dios tapaei aton fo'aliajwa pijow —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Do jawʉt, xanal pejnachalwan jʉm-an Jesúsliajwa: —Pachaema-el wʉt poejiw pejwatho' pelsliajwa, ja-aech wʉt, kaes pejme pachaemaxael poejiw watho' nos-elaliajwa, tamach laelpaliajwa —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Do jawʉt, Jesús xanal najʉmnot wʉt, jʉm-aechon: —Puexa jiw najʉmmatabijaxil xan jʉm-anpox. Dios tapaeispikal, japikal najʉmmatabijaxael japox. ");
INSERT INTO guoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Poejiwxot asew nakjiyaxil, ʉthjilax chanlaela xoti. Asew poejiw nakjiyaxil, ʉthjuks xoti. Asew poejiwbej nejxasinkaxil nakjiyaliajwa, Dios puexa pejjiw tato'almatkoi mox pawʉajna xot. Xamal xajʉpam wʉt matabijaliajwam xan jʉm-anpox, ¡chiekal matabijim! —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Asamatkoi jiw paxi bʉflaen Jesúslel, Jesús ke-osliajwa yamxi pejta'anxot Dios wekawʉajnaliajwapon japi yamxiliajwa. Xanal pejnachalwan japox taenx wʉt, japi jiw fiatx paxi bʉflaesamatapi Jesúslel. ");
INSERT INTO guoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Do jawʉt, Jesús najʉm-aech xanalliajwa: —¡Tapaem yamxi xanlel bʉflaeliajwadin! ¡Nabej fias! Diosxotse, Dios jiw tato'alxotse, japi jiw, me-ama ampi yamxi, ja-aech, kamta naexasit xoti Dios —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Do jawʉt, Jesús ke-ot japi yamxi pejta'anxot Dios kawʉajnaliajwapon. Dios kawʉajnax bʉxtoet wʉt, jaxot chijialison, xanal pejnachalwan sʉapich, asalel fʉlaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kaen pansian fʉlaen taeliajwapon Jesús. Pat wʉton Jesúsxot, wʉajnachaemt wʉt, jʉm-aechon: —Jiw chanaekabʉanan, xam pachaemamponam, ¿achaxkat xan nawewe'p isliajwan pachaempox, pomatkoicha dukaliajwan Diosxotse? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús jʉmnot wʉt, jʉm-aech: —¿Ma-aech xotkat xan najʉm-am: ‘Xam pachaemamponam’ —na-amkat? Kaen Dios, japon pachaempon. Pasasiam wʉt Diosxotse, ¡naexasisfʉlde Dios tato'alpoxan! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pansian wʉajnachaemt wʉt, jʉm-aechon: —¿Masoxkat, Dios tato'alpoxan, xan naexasisfʉlaliajwan? —aechon. Do jawʉt, Jesús jʉm-aech: —‘¡Asew jiw nabej be'! ¡Asaow pawis, nijwa-elpow, nabej bʉ'moejsbej! ¡Nabej natkowe'bej! ¡Nabej kichachajbe'bej asan aton xam tasalaliajwam, babijax is-el wʉton! ");
INSERT INTO guoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","¡Sitaembej nej-ax, nej-enbej! ¡Nejxasinkdebej asew jiw! Me-ama xam najut nanejxasinkam wʉt, ¡ja-amde asew jiwliajwa!’ —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pansian jʉm-aech: —Xam najʉm-ampoxan, xan chiekal naexasisfʉlax. ¿Pe achaxkat xan kaes nawewe'pfʉk? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús jʉmnot wʉt, jʉm-aechon: —Chiekal pachaemasiam wʉt, ¡xabʉa'de nejba poxade nejew mowaliajwam! Mowam wʉt, ¡japaplata chaxduim kejila! Ja-am wʉt, xabichaxael nejew Diosxotse. Do jawʉx, ¡xam xabʉa'de xan naknanʉamsliajwam, tajnachalnamliajwabej! —aech Jesús pansianliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pansian japox jʉmtaen wʉt, xabich nejxaejwas, xabich kemaenk xoton. Samata, jawʉt Jesúsxot asbʉan jʉmch chijialison. ");
INSERT INTO guoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Do jawʉt, Jesús xanal najʉm-aech: —Diachwʉajnakolax xan jʉm-an. Xabich tampoel kemaeya pasliajwa Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Xamal chiekal matabijam. Camello pinjin xot, xajʉpaxil xensliajwadepon kuthatʉakre'wʉaj poxade. Ja-aechbej kemaeyaliajwa. Xabich tampoel kemaeya pasliajwa Diosxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Xanal Jesús pejnachalwan japox jʉmtaenx wʉt, nejchaxoelanuilx. Do jawʉt, xanal jʉm-an Jesúsliajwa: —¿Achankatlax bʉ'weyaxaes pasliajwa Diosxotse? —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Do jawʉt, Jesús xanal chiekal natachaem wʉt, najʉm-aechon: —Jiw pajut pasaxil Diosxotse. Pelax Dios xajʉp puexa isliajwa. Samata, xajʉpbejpon jiw bʉ'weliajwa. Kajachawaesaxaelbejpon jiw pasliajwa japonxotse —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Do jawʉt, Pedro jʉm-aech: —Xanal puexa tejew waelax xam nakfʉlaeliajwan. ¿Achaxkat Dios xanal nachaxduiyaxael? —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Do jawʉt, Jesús jʉm-aech: —Diachwʉajnakolax xan jʉm-an. Xan, puexa jiw pakoewkolnan, tato'laxaelen wʉt ampathatat, pajelthat wʉt, jawʉt ekaxaelen tajtʉa-ekaxtat, xabich pachaempoxtat. Ja-aech wʉt, chiekal pachaemaxael puexa jiw tato'laliajwan. Xamal tajnachalwam chalakaxaelambej asatʉa-ekaxantat tato'laliajwam docemʉtanpijiw, Israel tʉajnʉpijiw. ");
INSERT INTO guoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Xan tajaxtat xamal waelam wʉt nejew, nejbachan, nakoewbej, nej-enbej, nej-axjiwbej, naxibej, nejsatanbej, ja-am wʉt, Dios kaes cien veces chaxduiyaxael xamal. Asamatkoi tʉpam wʉtbej, pasaxaelam Diosxotse pomatkoicha duilaliajwam jaxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Xabich jiw, paklochowpi, ampathatat. Pe japi Diosxotse wʉt paklochowaxil. Ampathatat xabich jiw, paklochowa-elpi, japilax Diosxotse wʉt, paklochowaxael —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Do pejme Jesús xanal najʉm-aech wʉajantat: “Dios puexa pejjiw tato'laxael wʉt, me-ama uvalulpijin, nabichow mot wʉt, jachiyaxaelpox. Lulpijin chijia foeljow nabichow wʉlwekaliajwa japon pejlulxot nabichliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Japon jʉmdut mosliajwa kaematkoibichax pa-ompoxtat. Jʉm-aechon: ‘Xamal mosaxaelen kaedenario’ —aechon. Jawʉt to'alison japi nabichliajwa pejlulxot. ");
INSERT INTO guoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Do jawʉx, juimt athʉse wʉtlejen, lulpijin fʉlaech plaza poxade. Jaxotde taenlison poejiw, nuilalap wʉt is-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Japon jʉm-aech japiliajwa: ‘¡Xamalbej xabʉa'de tajlul poxade nabichliajwam! Xan mosaxaelen pachaempoxtat’ —aechon. Do jawʉt, japi ow-aech. Fʉlaechlisi nabichliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Juimt matnoch ek wʉt, lulpijin pejme fʉlaech plaza poxade wʉlwekaliajwa nabichow. Japon pejme faek nabichow. Do jawʉtbej, to'apon japi nabichliajwa japon pejlultat. Do kaliax wʉt, lulpijin pejme fʉlaech wʉkwekaliajwa asew jiw. Faek wʉt, japibej to'apon nabichliajwa japon pejlultat. ");
INSERT INTO guoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Juimt dach ek wʉt, lulpijin pejme fʉlaech plaza poxade. Jaxotde asew jiw taenon, japi nuilalap wʉt is-elaxtat. Do jawʉt, japon japi wʉajnachaemt wʉt, jʉm-aechon: ‘¿Ma-aech xotkat xamal pomatkoicha asbʉan jʉmch amxot nuilapam is-elaxtat?’ —aech lulpijin. ");
INSERT INTO guoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Japi jʉmnot wʉt, jʉm-aechi: ‘Xanal amxot nuilapax, kaen aton natadʉs-el xot nabichliajwan’ —aechi. Do jawʉt, lulpijin jʉm-aech japiliajwa: ‘Ja-aech wʉt, ¡xabʉa'de xamalbej tajlul poxade nabichliajwam!’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Juimt tujop wʉt, lulpijin jʉm-aech pamakanliajwa, japon uvalul tataefʉlponliajwa: ‘¡Puexa nabichow laem! ¡Japi puexa kaenanʉla mosfʉlde kaedenariotat! ¡Tʉadu'e mosax wʉchakalkolaxtat patixot! ¡Jasoxtat mosax toesfʉlde, matxoelanabisti sʉapichbej!’ —aech lulpijin. ");
INSERT INTO guoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tadʉchpi nabichliajwa juimt dach ek wʉt, japi kaenanʉla moch kaedenario. ");
INSERT INTO guoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jawʉt matxoelanabisti nejchaxoel: ‘Xatis kaes bej nakmosaxaelbejpon’ —aechi, nejchaxoel wʉt. Pe moch wʉt, japibej kaedenario moch. ");
INSERT INTO guoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Matxoelanabisti kaedenario kenot wʉt, chiekal xanejchachaemla-eli. Do jawʉt, palalapi lulpijinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Samata, japi jʉm-aech lulpijinliajwa: ‘Wʉchakalkolaxtat pati asbʉan jʉmch nabist kaehora. Pe xanal najʉpanamotam, japi sʉapich. Xanal xabich kaes nabistax masxaeyaxtat’ —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lulpijin jʉmnot wʉt, jʉm-aechon kaen nabichanliajwa: ‘Nabichan, xan is-enil babijax xamalliajwa. Xan chajia jʉm-an: “Xam mosaxaelen kaedenario” —an xan xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","¡Xanwia'e motxpox! ¡Chijiamde! Wʉchakalkolaxtat pati motxbej kaedenario. Jasoxtat xan motx, mosasian xot. ");
INSERT INTO guoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Xan tejew platatat isasianpoxan xa-isaxaelen. ¿Xamkat nusasiawlam, xan tasiawla-el xot tejew plata, xamal najʉpamotx xot, asew jiw sʉapich?’ —aech lulpijin. ");
INSERT INTO guoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Xabich jiw, paklochow, ampathatxot. Pe japi Diosxotse wʉt, paklochowaxil. Xabich jiwbej, paklochowa-eli ampathatxot, japilax Diosxotse paklochowaxael” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús fʉlaech Jerusalén paklowax poxade. Xabich jiw fʉlafoson. Do jawʉt, fʉlaech wʉtfʉk, xanal dosan, japon pejnachalwan, nalapon asalelaxachliajwan. Do jawʉt, Jesús jʉm-aech xanalliajwa: ");
INSERT INTO guoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Amwʉt fʉlaeyaxaes Jerusalén paklowax poxade. Jaxotde xan, puexa jiw pakoewkolnan, asan nawiasaxael sacerdotespaklochowxot, judíos chanaekabʉanapixotbej. Japi natasalaxael asew jiw naboesaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Do jawʉx, nawiasaxael judíos-elpixot nabʉ'wʉajanpaeliajwa. Xabich namatwʉajselsaxaeli. Do jawʉxbej, nakematamatlaxaeli cruztat xan tʉpaliajwan. Pe tres matkoi wʉt, Dios namat-esaxael pejme dukaliajwan —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Do jawʉx, Zebedeo pijow, paxi sʉapich, mox soepapi Jesúsxot. Japow brixtat nuk wʉt Jesús pejwʉajnalel, wʉljowpow chamoeyax Jesús we-isliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Do jawʉt, Jesús jʉm-aech: —¿Achaxasiamkat? —aechon. Japow jʉmnot wʉt, jʉm-aechow: —Asamatkoi, xam puexa jiw tato'lam wʉt, ¡kolenje taxʉlan tapaem xamxot naliachalakaliajwa! ¡Tapaem japi puexa jiw tato'laliajwa, xam sʉapich, japi kolenje asew jiw xabich sitaeliajwasbej! —aechow Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús jʉm-aech Santiagoliajwa, Juanliajwabej: —Xamal matabija-emil nawʉljowampox. Xan xabich nabijasaxaelen jiw pijaxtat. ¿Xamalbejkat xajʉpaxaelam nabijasliajwam, me-ama xan nabijasaxaelen, jachiliajwam? —aech Jesús. Japi jʉmnot wʉt, jʉm-aechi: —Diachwʉajnakolax xanalbej xajʉpaxaelen nabijasliajwan, me-ama xam nabijasaxaelam, jachiliajwanbej xanal —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús jʉm-aech: —Diachwʉajnakolax xamalbej nabijasaxaelam xan tajaxtat. Pe chalakaxaelampox, xan sʉapich, tajpoklalel, tajsoenalelbej, puexa jiw tato'laliajwam, japoxliajwa xan tajut jʉmchiliajwan, taj-ax Dios natapae-el. Taj-ax Dios chajia jiw makanot japoxliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Xanal, asewan Jesús pejnachalwan, diezpin, japox wʉljoeyax wʉltaenx wʉt, xabich talala japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Do jawʉx, Jesús xanal nala mox soepaliajwan japonxot. Najʉm-aechon: —Xamal matabijam asatʉajnʉchanpijiwpaklochow, japi Dios naexasis-eli, jiw tato'al wʉt, tato'la-el pachaempoxtat. Japi jiw tato'al pamamaxtat, asew jiw itpaeliajwa japi kaes paklochowpox. ");
INSERT INTO guoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pelax xamal jasoxtat nakaewa natato'laximil. Xamalxot kaen paklonasia wʉt, japon matxoela kajachawaesnaxael xamal. ");
INSERT INTO guoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Xamalxot kaen paklonasia wʉt, japon majt malech nabichaxael puexa xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ja-aechlap-is xanliajwa, puexa jiw pakoewkolnan. Fʉlae-enilsik jiw xan nakajachawaesliajwa ampathatat. Xanlax fʉloekax xabich jiw kajachawaesfʉlaliajwan, wemosliajwanbej japi babijaxan ispoxanliajwa, tʉpx wʉt cruztat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús nakolt wʉt, xanal pejnachalwan sʉapich, Jericó paklowaxxot, xabich jiw Jesús fʉlafos. ");
INSERT INTO guoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jaxot nʉambabʉ'tat kolenje itliaklan chalak. Jʉmtaen wʉti Jesús xensaxaelpox, nejlat wʉt, jʉm-aechi: —Tajpaklon, David pamon, ¡xanal nabeltaem! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Do jawʉt, jiw bʉxfiat japi kolenje itliaklan boejlach chalakaliajwa. Japi jiw jʉm-aech: —¡Nabej talias Jesús! —aech nakfolpi. Ja-aech wʉt, japi kolenje itliaklan kaes pejme nejlasfʉl wʉt, jʉm-aechfʉli: —Tajpaklon, David pamon, ¡xanal nabeltaem! —aechfʉli. ");
INSERT INTO guoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Do jawʉt, Jesús nukjaba wʉt, jʉm-aechon japiliajwa: ¡Xabʉa'din xanlel! —aechon. Itliakla Jesúsxot wʉt, Jesús jʉm-aech, wʉajnachaemt wʉt: —¿Xamal achaxasiamkat xan isliajwan xamalliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Itliakla jʉmnot wʉt, jʉm-aechi: —Tajpaklon, ¡xanal na-itfuboejthʉ'e chiekal taeliajwan! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Do jawʉt, Jesús beltaen itliakla. Jawʉt Jesús itfujacha japi itliakla. Jawʉt itliakla chiekal wepachaemslisi pej-itfu. Chiekal taenbejpi. Dolis japi nakfollisi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Xanal, Jesús sʉapich, moxan wʉt Jerusalén paklowaxxot, patx Betfagé paklowaxach xot. Jaxot xabich olivonaechan nuil mʉaxxot. Do jawʉt, Jesús pejnachalwanxot kolenje wʉajna to'achon. ");
INSERT INTO guoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Fʉlaeliajwa wʉt, jʉm-aechon: —¡Xabʉa'de Betfagé paklowaxach poxade! Jaxotde faenaxaelam bur, ke'tason, paxʉlan sʉapich. Joltam wʉt, bur bʉflaeman xanlel, burxʉlanbej. ");
INSERT INTO guoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jaxotpijiw xamal wʉajnachaemt wʉt burliajwa, ¡japon aton jʉm-amo: “Wajpaklon amwʉt nejsesich bur. Toet wʉt ispox, pejme wiasaxaelon bur” —amo japi! —aech Jesús, bʉxto'a wʉt kolenje pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dolisdo', japox ja-aech, me-ama Dios pejprofeta chajia lelox jachiliajwa burliajwa. Profeta lelox jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jʉmchiyaxaelam jʉmtaeliajwa Jerusalén paklowaxpijiw: ‘¡Taem nejrey, xabich pachaempon, chaflaen wʉt xamallel bur jelti'santat!’ —chiyaxaelam” —aech profeta lelox. ");
INSERT INTO guoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Do jawʉt, Jesús pejnachalan, kolenje, fʉlaechlisi. Islisi Jesús to'aspox. ");
INSERT INTO guoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Do jawʉt, bʉflaenlisi bur, burxʉlan sʉapich, Jesúsleldin. Pejsumta-owa jolpi tam-owaliajwapi burxʉlan. Do jawʉt, Jesús tʉa-ek burxʉlan. ");
INSERT INTO guoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Xabich jiw Jesúsxot. Asew japixot pejsumta-owa jol nʉamtat ba'aliajwa Jesús fʉlaeyaxaen poxadin itpaeliajwa japi pejsitaeyax japonliajwa. Asew japixot wʉajna owa naedalx, pa-ʉafpi. ");
INSERT INTO guoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Xabich jiw wʉlʉk nʉamtat. Asew jiw fol Jesús pejwʉajnalel. Asew fol wʉchakal. Puexa jiw nejlasfʉl wʉt, jʉm-aechbalapi: —¡Aleluya! ¡Pachaempon, wajwʉajnapijin, rey David pamon! ¡Ampon fʉlaenpon Dios pijaxtat, xabich pachaempon! ¡Dios, athʉpijin, japon xabich pachaem! —aechbalapi, nejla'bala wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Do jawʉt, Jesús pat wʉt Jerusalén paklowaxxot, japapaklowaxpijiw xabich taesia ja-aechox. Samata, nakaewa nawʉajnachaemt wʉt, najʉm-aechi: —¿Achankat ampon aton? —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Asew Jesús fʉlafolpixot jʉmnot wʉt, jʉm-aechi: —Ampon Jesús, Dios pejprofeta, Nazaret paklowaxpijin, Galilea tʉajnʉpijin —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús Jerusalén paklowax pat wʉt, Dios pejtemploba low wʉt, jaxot taenpon mowapi, wʉajtibej, plata xanafokibej. Do jawʉt, Jesús japi nakolax to'a tathoetade. Plata xanafoki, pejmesan fʉliaxabapon. Mowapibej a-u, japi pejtʉa-ekaxan wʉlaejabapon. ");
INSERT INTO guoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesús jʉm-aech japi jiwliajwa: —Dios pejjamechan, chajia lelspox, jʉm-aech, Dios jʉm-aech wʉt pejtemplobaliajwa: ‘Tajba kawʉajnaba wʉlxael, jiw xan nakawʉajnaliajwa’ —aech Dios jʉm-aechpox. Pelax xamal Dios pejtemploba kethaka pejba padofam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús Dios pejtemplobatat wʉt, itliakla, nabejkabej, japi mox soepa Jesúsxot. Jesús japi boejthʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sacerdotespaklochow, judíos chanaekabʉanapibej, taen wʉti Jesús ispoxan, jawʉt xabich palalapi Jesúsliajwa. Jʉmtaenbejpi, yamxi nejlasfʉl wʉt jʉm-aechfʉlpox Jesúsliajwa: “¡Wajpaklokolan, David pamon, xabich pachaempon!” —aechfʉl wʉt yamxi Jesúsliajwa. Paklochow japox jʉmtaen wʉt, xabich kaes pejme palalapi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Samata, japi jʉm-aech Jesúsliajwa: —¿Xamkat jʉmtaenam yamxi jʉm-aechfʉlpox xamliajwa? —aechi Jesúsliajwa. Jesús jʉmnot wʉt, jʉm-aechon: —Diasdo'. Xan chiekal jʉmtaenx, japi yamxi jʉm-aechfʉl wʉt xanliajwa. ¿Xamalkat-is xaljoe-emil Dios pejjamechan, chajia lelspox, jʉm-aech wʉt: ‘Yamxi, kaes pajampibej, jʉmchiyaxael pachaempoxan xamliajwa’ —aech wʉt chajia lelspox xanliajwa? —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jawʉt Jesús waelapon japi jiw Dios pejtemplobatat. Nakoltlison Jerusalén paklowaxxot Betania paklowaxach poxaliajwade. Do jaxot chatuil wʉt, kawetapi. ");
INSERT INTO guoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kandiawasap wʉt, xanal, Jesús sʉapich, pejme fʉlaechx Jerusalén paklowax poxade. Do jawʉt, Jesús litaxaela, nʉamtat fol wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Do jawʉt, taenpon higonae nʉambabʉ'tat nuknae. Jawʉt, Jesús mox itfʉlaech wʉt, taenon higonae baechjilpox. Xabich pa-ʉafkalnae jʉmch. Jawʉt Jesús jʉm-aech higonaeliajwa: —¡Xam kaes naboesaximil! —aech Jesús higonaeliajwa. Do jawʉt, kamta higonae selil. ");
INSERT INTO guoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Xanal pejnachalwan japox taenx wʉt, xabich nejchaxoelx. Xanal wʉajnachaemtax wʉt, jʉm-an Jesúsliajwa: —¡Taem! ¿Ma-aech xotkat kamta higonae selil? —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús xanal najʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan jʉm-an. Xamal chiekal Dios xanaboejam wʉt, chinax nejchaxoela-emil wʉt: ‘Dios nakajachawaesaxil’ —chi-emil wʉt, nejchaxoelam wʉt, xamalbej jʉm-am wʉt higonaeliajwa, higonae selilaxael. Jachiyaxaelbej mʉaxliajwa. Samata, jʉmchiyaxaelam wʉt ampamʉaxliajwa: ‘Mʉax, ¡xam amxot napia'e! ¡Xabʉa'mik mar poxamik!’ —chiyaxaelam wʉt, diachwʉajnakolax mʉax napiasaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Samata, xamal Dios kawʉajnam wʉt, nejchaxoelam wʉt ampox: ‘Diachwʉajnakolax Dios nachaxduiyaxael puexa kawʉajnaxpoxtat wʉljowxpox’ —am wʉt, nejchaxoelam wʉt, diachwʉajnakolax xamal Dios chaxduiyaxael puexa kawʉajnampoxan —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Do japoxwʉx, Jesús, xanal sʉapich, pejme patx wʉt, xanal lowx Dios pejtemploba. Jaxot Jesús jiw naewʉajan. Naewʉajan wʉt, sacerdotespaklochow, judíos-ancianosbej, mox soepapi wʉajnachaemsliajwa Jesús. Japi jʉm-aech: —¿Achankat xam to'a choef mowapi nakolax to'aliajwam tathoetade Dios pejtemplobaxot? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Jesús jʉmnot wʉt, jʉm-aechon: —Xanbej kaeyax xamal wʉajnachaemsaxaelen. ¡Majt chiekal najʉmno'e! ¿Achankat Juan to'as jiw bautisafʉlaliajwa? ¿Japoxkat Juan pajut isfʉl? O, ¿Dioskaton to'as? O, ¿japoxkaton isfʉl, jiw to'as xot? Xamal chiekal xan najʉmnotam wʉt, ja-aech wʉt, xanbej chiekal jʉmnosaxaelen xamal nawʉajnachaemtampoxliajwa —aech Jesús. Do jawʉt, japi nakaewa najʉm-aech: “Xatis jʉmnoch wʉt, ‘Juan Dios to'as xot, jiw bautisafʉl’ —tis wʉt, Jesús nakjʉmchiyaxael: ‘¿Ma-aech xotkat xamalbej naexasisfʉla-emil Juan jʉm-aechfʉlpox?’ —nakchiyaxael Jesús xatisliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jʉmtis wʉtlax: ‘Juan jiw to'as jiw bautisafʉlaliajwa’ —tis wʉt, jiw xabich palalaxael xatisliajwa, puexa jiw jʉm-aechfʉlxot Juanliajwa: ‘Diachwʉajnakolax Juan, jiw bautisan, jʉm-aechfʉl Dios pijaxtat’ —aechfʉl xot xabich jiw” —aech paklochow nakaewaliajwa. Samata, japi paklochow xabich pejlewla japox jʉmchiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Do jawʉt, japi jʉm-aech Jesúsliajwa: —Jalape. Xanal matabija-enil, achan Juan to'as jiw bautisafʉlaliajwa —aechi. Do jawʉt, Jesús jʉm-aech japiliajwa: —Xanbej jʉmchiyaxinil xamalliajwa, achan xan nato'a japox isliajwan —aech Jesús sacerdotespaklochowliajwa, judíos-ancianosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Do jawʉx, Jesús wʉajnachaemt sacerdotespaklowchow, judíos-ancianosbej. Jʉm-aechon: —¿Achaxkat xamal nejchaxoelam ampawʉajanliajwa? Kaen aton kolenje paxʉlan. Japon jʉm-aech kaen paxʉlanliajwa: ‘Wʉa, ¡xabʉa'de amwʉt taj-uvalul poxade nabichliajwam!’ —aech pax paxʉlanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Paxʉlan jʉmnot wʉt, jʉm-aechon paxliajwa: ‘Ax, xan fʉlaeyaxinil nabichliajwan’ —aechon paxliajwa. Pe baxael, japon ow-aech. Dolison fʉlaech pax pej-uvalul poxade nabichliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Do jawʉx, japon jʉm-aech asan paxʉlanliajwa: ‘Wʉa, ¡xambej xabʉa'de taj-uvalul poxade nabichliajwam!’ —aech pax asan paxʉlanliajwa. Japon jʉmnot wʉt, jʉm-aechon paxliajwa: ‘Ow, ax. Xan fʉlaeyaxaelen nabichliajwan’ —aechon paxliajwa. Pe japon fʉlae-el. Kawetapon asbʉan jʉmch batat. ");
INSERT INTO guoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Achankat japixot kolenje is pax nejxasinkpox? —aech Jesús. Naeweti jʉmnot wʉt, jʉm-aechi: —Matxoela-ow-aechpon. Japon is pax nejxasinkpox —aechi. Jawʉt Jesús jʉm-aech: —Diachwʉajnakolax xan jʉm-an. Babejchow, impuesto mat-omwʉljoew Roma gobiernoliajwa, watho', poejiw bʉ'moejtibej kanaliajwa plata, japi japoxan kofa wʉt, pasaxaeli Diosxotse, xanaboejafʉl xoti Dios. Pelax xamal pasaximil Diosxotse, xanaboeja-emil xot Dios, kofa-emil xotbej babijaxan isfʉlampoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan, jiw bautisan, naewʉajan jiw chiekal duilafʉlaliajwa Diosliajwa. Pe xamal naexasis-emil japon jʉm-aechpoxan, japon naewʉajanpoxanbej. Me-ama wʉchakalpijin naexasis-el pax to'aspox isliajwapon, xamalbej ja-am. Asewlax, impuesto mat-omwʉljoew, watho'bej, asew poejiw bʉ'moejtpi, japi naexasit Juan naewʉajanpox. Xamal taenam wʉt, japi naexasitpox Juan naewʉajanpox, nejchaxoela-emil xamal kofaliajwam babijaxan isampoxan, Juan jʉm-aechpox naexasisliajwam —aech Jesús sacerdotespaklochowliajwa, judíos-ancianosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús naewʉajan wʉt, sacerdotespaklochow, judíos-ancianosbej, japiliajwa pejme jʉm-aechon wʉajantat: “¡Naewe'e asawʉajan! Kaen aton uva mʉtha. Do jawʉx, uvalul chaxajajialon ia'tat. Isbejpon uva-ufan jukax uvalulxot. Do jawʉx, isbejpon japalultat cha-aelbach, athʉpox, uvalul tataeflaliajwa, uva foi wʉt. Do jawʉt, uvalulpijin asew jiw pamakjiwliajwa wʉljaeton pejlul piach wetataeflaliajwas, japon pejwʉlela. Japi bʉ'pat wʉt, jʉm-aechon japiliajwa: ‘Xan fʉlaeyaxaelen asatʉajnʉlel atʉaj. Xan ajinil wʉt, ¡tajlul xamal chiekal nawetataefʉlde!’ —aech uvalulpijin. Do jawʉx, chijialison. ");
INSERT INTO guoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Do baxael, uva foi wʉt, uvalulpijin asew pamak to'a wewʉljaesliajwas uva, japon pejewpi. ");
INSERT INTO guoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pe fʉlalaenapi uva wʉljaesliajwa, japi jaelas tataefʉlpi uvalul. Fʉlalaenpixot asew baes. Asew tʉp. Asew ia'tat dadaps wʉt, matkaejabas. ");
INSERT INTO guoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ja-aech wʉt, uvalulpijin kaes pejme to'afʉl pamak uvalul tataefʉlpi poxade. Pe japi fʉlalaena wʉt, japibej jaketis. ");
INSERT INTO guoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Do baxael, uvalulpijin to'a paxʉlan. Japon uvalulpijin nejchaxoel: ‘Uvalul tataefʉlpi diachwʉajnakolax bej nawesitaeyaxaelbejpi taxʉlan’ —aechon, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pe uvalul tataefʉlpi taen wʉti uvalulpijin paxʉlan, nakaewa najʉm-aechi: ‘¡Tae'nik uvalulpijin paxʉlan! Asamatkoi pax naetʉp wʉt, uvalul japon pijax wʉlxael. Samata, ma amwʉt xatis ampon boesaxaes, uvalul wajkal chiekal namanaliajwa’ —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Japon pat wʉt uvalul tataefʉlpixot, jawʉt jaeltason. Do jawʉt, juchpon uvalulxot. Do jawʉtbej, boesaspon” —aech Jesús, japawʉajantat naewʉajan wʉt sacerdotespaklochowliajwa, judíos-ancianosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Do pejme Jesús jʉm-aech japiliajwa: —Uvalulpijin fʉlaen wʉt, ¿achaxkaton isaxael uvalul tataefʉlpiliajwa? —aech Jesús japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jʉmnot wʉt, jʉm-aechi: —Uvalulpijin, japon beyaxael beltae-elaxtat uvalul tataefʉlpi, babejchow. Do jawʉx, to'axaelon asew jiw japa-uvalul wetataeflaliajwas. Japilax, uva foei wʉt, kaewaechfʉl wʉt, wewoeyafʉlaxael uvapijin pejewpi —aech japi jiw, jʉmnot wʉti Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Do jawʉt, Jesús jʉm-aech: —Xamal matabijam, Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox xanliajwa: ‘Jiw ia'ba is wʉt, kaet ia'tliajwa nakaewa najʉm-aechi: “Ampot ia't chaemil” —na-aechi nakaewa. Do jawʉx, asan aton japot ia't fit wʉt, jʉm-aechon: “Ampot ia't, puexa ia'xot, kaes pejme pachaem tʉakso'pijtaliajwa, ba chiekal mamnikaliajwa” —aech japon aton. Me-ama ampox, jasox Dios is Mesíasliajwa. Wajpaklon Dios jasox is xatis weliajwas Mesías pijaxtat. Samata, japox xabich pachaem xatisliajwa’ —aech Dios pejjamechan, chajia lels wʉt xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Samata, xamal jʉm-an. Xamal xan nanaexasis-emil xot, Dios tapaeyaxil xamal tato'laliajwam asew jiw. Dioslax tapaeyaxael asew jiw tato'laliajwapi asew jiw, japi jiw isfʉl Dios nejxasinkpoxan.  ");
INSERT INTO guoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jiw fiap wʉt ia't pinjitxot, xabich naxthuya wʉt, xabich naxkolaxaelbejpi. Pelax kaet ia't, pinjit, athʉsik, jiw matwʉajasik jopik wʉt, ja-aech wʉt, japi jiw chiekal matkaeyaxaes. Jasoxtat xamal nabijasaxaelam, xan nanaexasis-emil xot, xan nanejwesla xotbej. Dios xamal kastikaxael infiernoxotdik pomatkoichaliajwa —aech Jesús sacerdotespaklochowliajwa, judíos-ancianosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Do jawʉt, sacerdotespaklochow, fariseosbej, jʉmtaen wʉti uvalulwʉajan, ia'wʉajanbej, japi pajut matabija, Jesús japoxan jʉm-aech wʉt, jʉm-aechon japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Samata, jawʉt jaelsasiapi Jesús jiw jebatat jeliajwa. Pe paklochow xabich pejlewla judíosliajwa, judíos nejchaxoel xot: “Jesús Dios pejprofeta” —aech xoti, nejchaxoel wʉt. Samata, paklochow nejchaxoel: “Jesús jaeltas wʉt, jiw bej nakbeyaxaelbej” —aechi, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús pejme jʉm-aech wʉajantat jiwliajwa: ");
INSERT INTO guoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Dios puexa pejjiw tato'alpox, me-ama rey fiesta is wʉt paxʉlan nakjiyaponliajwa, ja-aechox. ");
INSERT INTO guoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Rey to'a pamak chajia tadʉchpi bʉflaeliajwa fiesta poxadin. Chajia tadʉchpi kaenanʉla jʉm-aechi asbʉan jʉmch: ‘Xan fʉlaeyaxinil’ —aechi kaenanʉla. ");
INSERT INTO guoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Samata, rey pejme asew pamak to'a chajia tadʉchpi jʉmchiliajwa japi fʉlaeliajwa fiesta poxadin. Pamak to'aliajwa wʉt, jʉm-aechon pamakliajwa: ‘¡Chajia tadʉtxpi jʉm-amo: “Naxaeyaxan chiekal ketoetx fiestaliajwa. Keto'ax pak xʉa'asax, jelti'tpi, chiekal dalpi. Puexa chiekal ketoetx. Pe xaeyaxkal we'p. ¡Ma amwʉt nej xabʉata taxʉlan, nakjiyapon, pejfiesta nakxaeliajwapi!” —amo chijia tadʉtxpi!’ —aech rey, pamak to'a wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Rey pamak pat wʉt chajia tadʉchpixot, japi jʉm-aech rey bʉxto'aspox. Pe chajia tadʉchpi owchi-el. Kaen chajia tadʉchpon, japon fʉlaech pejlulan poxade. Asanbej japixot fʉlaech pejew negocios poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Chajia tadʉchpixot, asew jaelapi rey pamak. Do jawʉt, baesbejpi. Asew tʉp japixot, baes wʉti. ");
INSERT INTO guoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Do jawʉt, rey xabich palala. Samata, rey to'a pejsoldaw beliajwas pamak webaespi, pejbachan welausliajwasbejpi. Jasox is rey pejsoldaw. ");
INSERT INTO guoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Do jawʉx, rey jʉm-aech asew pamakliajwa: ‘Puexa chiekal ketoech taxʉlan nakjiyapon pejfiestaliajwa. Matxoelatadʉtxpi wepachaema-esal taxʉlan pejfiesta naktaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Samata, ¡xabʉa'de paklowaxthialaxan poxade! Jaxotde jiw taenam wʉt, ¡tadʉ'e taxʉlan pejfiesta naktaeliajwapi!’ —aech rey, pamak to'a wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Do jawʉt, rey pamak fʉlaechlisi paklowaxthialaxan poxade. Jaxotde xabich jiw faeki. Do jawʉt, bʉflaeni jiw pachaempi, babejchowbej. Do jawʉt, ba jiw xabich wʉlʉk. ");
INSERT INTO guoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Do jawʉt, rey low puexa jiw taeliajwa. Jawʉt rey taen kaen aton, japon naxoela-el tuch sumta-otox, nakjiyapon pejfiesta naktaeliajwa wʉt naxoelox. ");
INSERT INTO guoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rey jʉm-aech japon atonliajwa: ‘Taj-aton, ¿ma-aech xotkat xam naklowam taxʉlan pejfiesta naktaeliajwam, naxoela-emil wʉt tuch sumta-otampox fiesta naktaeliajwam?’ —aech rey japon atonliajwa. Pe japon boejlach nuk. ");
INSERT INTO guoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Do jawʉt, rey jʉm-aech pamakliajwa: ‘¡Ampon aton mʉaxwasikuim! ¡Tʉakwasikuimbejpon! Do jawʉt, ¡fo'impon tathoetade, itkʉatax poxade! Jaxotde xabich jiw noeyaxael. Bʉa'tatisaxaelbejpi, xabich nabijat xot’ —aech rey japon atonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jasoxtat xabich jiw tadʉchpi. Pe kaesʉapich jiw makanoch duilaliajwa Diosxotse” —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Do jawʉx, fariseos natameja wʉt, kaenejchaxoelax wʉajnachaemsliajwapi Jesús, Jesús asaxtat jʉmnot wʉt japi tasalaliajwa japoxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Samata, fariseos bʉxto'a asew japixot, asew jiwbej, Herodes pejmʉtpijiwpi, Jesús poxade. Pat wʉti Jesúsxot, jʉm-aechi: —Jiw chanaekabʉanan, xanal matabijax, xam diachwʉajnakolax chiekal jʉm-am. Naewʉajnambej diachwʉajnakolaxpox jiw chiekal duilaliajwa Dios nejxasinkpoxtat. Xam nejlewla-el paklochow nejchaxoelpoxliajwa jiw naewʉajnampoxliajwa. Samata, puexa jiw chiekal najʉpanaewʉajnam. ");
INSERT INTO guoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Samata, xanal chiekal matabijasian. ¿Pachaemkat xatis mosliajwas impuesto Roma tʉajnʉpijiw tato'lanliajwa? O, ¿mosaxisalkat? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús pajut matabijt xapaejtaspox. Samata, jʉm-aechon: —¡Xamal jiw naekichachajbapijwam! ¿Ma-aech xotkat naxapaejtam? ");
INSERT INTO guoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","¡Na-itpaem kaekafef, japoxantat impuesto motampi! —aech Jesús. Do jawʉt, xalaenlisi kaekafef Jesúslel. ");
INSERT INTO guoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús japi wʉajnachaemt wʉt japakafefliajwa, jʉm-aechon: —¿Achan pejxu-aelkat ampakafeftat? ¿Achan pejwʉlbejkat ama lelspox? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Japi jʉmnot wʉt, jʉm-aechi: —Roma tʉajnʉpijiw tato'lan, japon pejxu-ael, pejwʉlbej —aechi. Samata, Jesús jʉm-aech: —¡Japon pejewpi, japon chaxduim, impuesto motam wʉt! ¡Pe Dios pejewpi, Dios chaxduim! —aech Jesús, fariseosliajwa, Herodes pejmʉtpijiwpiliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Japox jʉmtaen wʉti, xabich nejchaxoelanuili, Jesús chiekal jʉmnot xot. Samata, jawʉt jaxot waeltlisipon. ");
INSERT INTO guoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Do jawʉxbej, kaesʉapich saduceos pat Jesúsxot wʉajnachaemsliajwapi Jesús. Puexa saduceos nejchaxoel: “Jiw tʉp wʉt, kaelel chiekal napelt. Asamatkoi mat-eyaxisal pejme duilaliajwa” —aechi, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Samata, jawʉt saduceos jʉm-aech ampawʉajan Jesúsliajwa: —Jiw chanaekabʉanan, Moisés chajia lelpox jʉm-aech: ‘Aton pijow naxʉwla-elaxtat naetʉp wʉt, patʉpan pakoewan naman wʉt, japon japow fisaxael. Ja-aech wʉt, japon naxʉwlaxael japowtat, pakoewan tʉponliajwa’ —aech Moisés chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Xanalxot majt kaen aton duk. Japon siete pakoew. Matxoelapijin pawis fit. Pe baxael, japon tʉp naxuwla-elaxtat pijowxot. Do jawʉt, wʉchakalpijin japow fit, pakoewan naetʉpow. ");
INSERT INTO guoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pe baxael, japonbej, tʉp naxʉwla-elaxtat japowxot. Do jawʉt, trespijin japow fit. Pe japonbej tʉp naxʉwla-elaxtat japowxot. Jasox ja-aech japi sietepiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chinax kaen japixot naxʉwla-el japowtat. Do jawʉx, taxdukakolaxtat japowbej tʉp. ");
INSERT INTO guoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Puexa japi poejiw nakjiya japowtat. Tʉpi mat-ias wʉt, ¿sietepixot, achankat japow pijwaxael? —aech saduceos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús jʉmnot wʉt, jʉm-aechon saduceosliajwa: —Xamal japox jʉm-am wʉt, nejmach jʉm-amslapam, matabija-emil xot Dios pejjamechan, chajia lelspox. Matabija-emilbej Dios xajʉppox puexa isliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tʉpi mat-ias wʉt pejme duilaliajwa, poejiw, watho' sʉapich, pejme nakjiyaxil. Me-ama Dios pej-ángeles Diosxotse nakjiya-el, jachiyaxael japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tʉpi mat-eyaxaes pejme duilaliajwa. ¿Xamalkat xaljoe-emil, Dios pajut jʉm-aech wʉt chajia lelsxot? ");
INSERT INTO guoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Dios ampox jʉm-aech Moisésliajwa: ‘Xan amwʉtjel Abraham, Isaac, Jacobbej, japi pejDiosnan’ —aech Dios. Samata, xatis chiekal matabijas, asamatkoi tʉps wʉt pejme duilaxaespox. Chiekal matabijasbej, wajwʉajnapijiw, chajia tʉpi, japi napels-el. Samata, Abraham, Isaac, Jacobbej, japi amwʉtjel Diosxotse duilafʉl —aech Jesús saduceosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jiw japox jʉmtaen wʉt, xabich nejchaxoelanuili Jesús jʉm-aechpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Do jawʉt, fariseos natameja, wʉltaen wʉti saduceos boejlach nuilpox, Jesús chiekal jʉmnot xot. ");
INSERT INTO guoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Do jawʉx, fariseos matabija isaxaelpox Jesúsliajwa. Samata, kaen japixot, judíos chanaekabʉanan, to'api Jesús poxaliajwade. Do pat wʉton Jesúsxot, jawʉt wʉajnachaemton xapaejsliajwapon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Jʉm-aechon Jesúsliajwa: —Jiw chanaekabʉanan, Dios xabich tato'al jiw naexasisliajwa. ¿Achatato'laxxotkat kaes pejme pachaem Dios tato'alpox jiw naexasisliajwa? —aech judíos chanaekabʉanan. ");
INSERT INTO guoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús jʉmnot wʉt, jʉm-aechon: —Moisés chajia lelpox jʉm-aech: ‘¡Chiekal nejxasinkde Dios nejpaklokolan! ¡Nejxasinkdebej Dios puexa nejnejchaxoelaxtat, puexa nejmatpʉatatbej!’ —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Japoxlap kaes pejme pachaem jiw naexasisfʉlaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Asawʉajan, wʉchakal pejwʉajan, Dios tato'alpox, japox pachaembej jiw naexasisfʉlaliajwa. Japawʉajan jʉm-aech: ‘¡Chiekal nejxasinkde asew jiw! Me-ama xam najut nanejxasinkam wʉt, jachiyaxaelam asew jiwliajwa’ —aech Moisés chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Japox kolewʉajan, Dios tato'alpoxan, xabich pachaem jiw chiekal naexasisfʉlaliajwa. Puexa Moisés chajia lelpox pachaem, Dios pejprofetas lelpoxanbej. Japawʉajan naknaewʉajan, machiyaxaes Dios nejxasinkaliajwas, asew jiwbej —aech Jesús judíos chanaekabʉananliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Fariseos natameja wʉtfʉk, Jesús wʉajnachaemt wʉt, jʉm-aechon japiliajwa: —¿Xamal achaxkat nejchaxoelam Mesíasliajwa? ¿Achankat Mesías pam? —aechon. Fariseos jʉmnot wʉt, jʉm-aechi Jesúsliajwa: —Rey David, japon Mesías pam —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Do jawʉt, Jesús jʉm-aech: —Ja-aech wʉt, ¿ma-aech xotkat rey David Mesíasliajwa Espíritu Santo pijaxtat jʉm-aechkat: ‘Tajpaklon’ —aechkat rey David Mesíasliajwa? Rey David chajia jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Dios naksiya wʉt tajpaklokolanliajwa, jʉm-aechon: “¡Ekde tajpoklalel jiw tato'laliajwam, xan sʉapich! Ekam wʉtfʉk, xan malechaxaelen nadaelmajiw. Malechax wʉt nadaelmajiw, japi jiw xam naexasisfʉlaxael, xam tato'lampox” —aech Dios tajpaklokolanliajwa’ —aech rey David chajia lelox, jʉm-aech wʉt Mesíasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Rey David chajia jʉm-aechbej Mesíasliajwa: ‘Tajpaklon’ —aech rey David. Samata, Mesías rey David pamonkala-elon. Pebej Mesías paklon rey Davidliajwa —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Do jawʉt, fariseos matabija-el, machiyaxaeli, jʉmnosliajwa wʉti Jesús. Do jawʉxbej, pejlewlalisi kaes wʉajnachaemsliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Do jawʉx, Jesús jʉm-aech jiwliajwa, xanal pejnachalwanliajwabej: ");
INSERT INTO guoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Judíos chanaekabʉanapi, fariseosbej, japi jiw chanaekabʉana Moisés chajia lelpox. Japox japi pejbichax. ");
INSERT INTO guoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Samata, ¡xamal naexasisfʉlde japi naewʉajanpox, naewʉajan wʉti Dios pejjamechan, Moisés chajia lelpoxliajwabej! ¡Isfʉlde puexa japi tato'alpoxan! ¡Pe nabej is japi pajut ispoxan! Japi pajut is-el xamal naewʉajanpoxan. Japi asaxan isfʉllax. ");
INSERT INTO guoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Japi xabich jiw tato'al jiw naexasisliajwa Dios tato'alpoxan. Japoxan xabich tampoel jiwliajwa. Japi paklochow pajut japoxan naexasis-el. ");
INSERT INTO guoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Puexa japi ispoxan is asew jiw asbʉan jʉmch taeliajwas. Japi nejxasink pejmaktat duiliajwa cha-aelcajax, pakbʉ'cajax. Nejxasinkbejpi pejmʉaxanxot kuiliajwa japoxan. Japacajaxtutat jiapi kaesʉapich Moisés chajia lelpox. Nejxasinkbejpi naxoeliajwa pakchowaxan. Pejtʉakji'anxot wewe'pas pejnaxoe. Pejnaxoe makmatduilxot baels, mʉarixan, jasi, puexa jiw chiekal taeliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nejxasinkbejpi chalakaliajwa kaes pejme pachaempoxantat, fiestanxot wʉt. Judíos naewʉajnabachantat wʉtbejpi, japi majt chalak tʉa-ekaxantat, kaes paklochowpi chalakaxaelpoxantat. Japoxantat chalaki puexa jiw sitaeliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nejxasinkbejpi, jiw saludaliajwas xabich sitaeyaxtat, paklowaxthialaxanxot xabʉ'kʉlas wʉti. Nejxasinkbejpi, jiw saludas wʉt jʉmchiliajwas: ‘¡Moi, jiw chanaekabʉanan!’ —chiliajwaspi” —aech Jesús jiwliajwa, xanal pejnachalwanliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jesús kaes jʉm-aech jiwliajwa, xanal pejnachalwanliajwabej: “Pe xamal, xan nanaexasitam xot, me-ama nakoewkolnan wʉt, ja-an xamalliajwa. Xanlap nejchanaekabʉananan kaekolnan. Samata, asew jiw xamalliajwa jʉmchiyaxil: ‘¡Moi, jiw chanaekabʉanan!’ —chiyaxil. ");
INSERT INTO guoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Xamal kaekolan nej-ax, athʉxotsepon. Japon nej-ax Dios. Samata, ampathatat Dios pejjamechan xamal naewʉajan wʉt, xamal jʉmchiyaximil nej-axkolna-elponliajwa: ‘Ax’ —chiyaximil. ");
INSERT INTO guoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Xan kaenan Cristowan, nejpaklokolnan. Samata, asew jiw xamalliajwa jʉmchiyaxil: ‘Tajpaklokolan’ —chiyaxil xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nejxasinkam wʉt asew jiw xamal sitaeliajwa, ¡japi majt kajachawae'e! Ja-aech wʉt, xamal sitaeyaxael jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nejmachjiw nejchaxoel wʉt pajutliajwa: ‘Xanal kaes pejme pachaeman. Me-ama asew jiw, jachi-enil’ —aech wʉti pajutliajwa, asamatkoi Dios jʉmchiyaxaesi: ‘Xamal kaes pejme pachaema-emil’ —chiyaxaesi. Pe asew jiwlax nejchaxoel wʉt pajutliajwa: ‘Xanal kaes pejme pachaema-enil. Me-ama asew jiw, jachi-enil’ —aech wʉti pajutliajwa, asamatkoi Dios japi jiw jʉmchiyaxaes: ‘Xamal pachaemam. Me-ama asew jiw, jachi-emil’ —chiyaxaesi” —aech Jesús jiwliajwa, xanal pejnachalwanliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “Xamal judíos chanaekabʉanapijwam, xamalbej fariseos, jiw naekichachajbam. Samata, Dios xamal xabich kastikaxael. Xabich kaes pejme chaemilaxael xamalliajwa. Xamal naewʉajnampoxantat, me-ama faka'am jiw pas-elaliajwa Diosxotse. Xamalbej najut pasaximil jaxotse. Tapae-emilbej asew jiw pasasiapi pasliajwa Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Xamal naekichachajbam watho', pamaljiw naetʉpspi, wenosliajwam puexa japi pejewpi. Do jawʉx, judíos naewʉajnaba lowam Dios piach kawʉajnaliajwam, asew jiw xamal taen wʉt jʉmchiliajwa xamalliajwa: ‘Diachwʉajnakolax ampi xabich pachaem’ —chiliajwa jiw xamalliajwa. Samata, kaes pejme chaemilaxael xamalliajwa, Dios jiw kastika wʉt” —aech Jesús japox judíos chanaekabʉanapiliajwa, fariseosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “Xamal judíos chanaekabʉanapijwam, xamalbej fariseos, jiw naekichachajbam. Xamalliajwa xabich kaes pejme chaemilaxael, Dios jiw kastika wʉt. Nanʉamtam potʉajnʉcha faekaliajwam judíos-eli japi nejnachalaliajwa. Asew faekam wʉt, naewʉajnam matabijampoxankal. Japanaewʉajnaxtat japi jiw kaes pejme chaemil. Me-ama xamal, jachi-eli. Samata, japi asamatkoi tʉp wʉt, pelsaxaeks infierno poxadik” —aech Jesús japox judíos chanaekabʉanapiliajwa, fariseosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “Xamal judíos chanaekabʉanapijwam, xamalbej fariseos, me-ama itliaklawam wʉt, ja-am. Dios pejjamechan naewʉajnam wʉt, xamal jʉm-am, chiekal matabijslaxtat: ‘Aton jʉmdut wʉt Dios pejtemplobapijaxtat, japajʉmdusax pa-omsa-el. Pe aton jʉmdut wʉtlax orotat, Dios pejtemplobatatpox, japajʉmdusaxlax xabich pa-om’ —am xamal chiekal matabijslaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jasoxtat xamal jiw naewʉajnam wʉt, me-ama nejliaklawam, itliaklawambej, ja-am, matabija-emil xot diachwʉajnakolaxpox. ¿Achaxkat kaes pejme jiw sitaeyaxael? ¿Oro, Dios pejtemplobatatpox? O, ¿Dios pejtemploba? Jiw kaes sitaeyaxael Dios pejtemploba. Jiw sitaen japa-oro, Dios pejtemplobapijax xot. ");
INSERT INTO guoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xamal chiekal matabijslaxtat jʉm-ambej: ‘Aton jʉmdut wʉt altartat, japajʉmdusax omjil. Pelax japon jʉmdut wʉt Dios pej-ofrendatat, okpox altarmatwʉajtat, japajʉmdusaxlax xabich pa-om’ —am xamal chiekal matabijslaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¿Achaxkat jiw kaes pejme sitaeyaxael? ¿Dios pej-ofrenda, altarmatwʉajtat okpox? O, ¿Dios pej-altar, Dios pejtemplobatatpox? Jiw kaes sitaeyaxael Dios pej-altar. Me-ama Dios pej-ofrenda altarmatwʉajtat okpox, sitaen wʉt, jachiyaxil. ");
INSERT INTO guoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aton jʉmdut wʉt altartat, japon jʉmdus-el altartatkal. Jʉmdutbejpon puexa japa-altarmatwʉajtat oelpitatbej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aton jʉmdut wʉt Dios pejtemplobatat, jʉmdus-el Dios pejtemplobatatkal. Jʉmdutbejpon Diostat, Dios duk xot japatemplobatat. ");
INSERT INTO guoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aton jʉmdut wʉt thatbaxotat, japon jʉmdutbej Dios pejtʉa-ekaxtat, Diostatbej, Dios pajut ek xot japatʉa-ekaxtat” —aech Jesús japox judíos chanaekabʉanapiliajwa, fariseosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “Xamal judíos chanaekabʉanapijwam, xamalbej fariseos, jiw naekichachajbam. Samata, Dios xamal xabich kastikaxael. Diajkam Diosliajwa puexa nejew. Nejew diez wʉt, kaeyax diajnam Diosliajwa. Xamal diajkambej xabich cha-aexpi, naxaeyaxan mattholspoxan. Pelax naexasisfʉla-emil asaxan, kaes pejme pachaempoxan xamal isfʉlaliajwam. Japoxan naexasisfʉlaxaelam wʉt, isfʉlaxaelam pachaempoxan asew jiwliajwa. Asew jiw beltaeyaxaelambej. Chiekal duilafʉlaxaelambej kichachajba-emilpoxtat. Japoxan isfʉlam wʉt, kofaximil diajkampox nejew Dios pej-ofrendaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Xamal paklochwam, me-ama itliaklawam wʉt, ja-am, nejchaxoelafʉlam xot kaes pachaema-elpoxan. Xamal nejchaxoelafʉla-emil kaes pejme pachaempoxanlax” —aech Jesús japox judíos chanaekabʉanapiliajwa, fariseosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “Xamal judíos chanaekabʉanapijwam, xamalbej fariseos, jiw naekichachajbam. Samata, Dios xabich xamal kastikaxael. Xamal xaeliajwam wʉt, majt xabich piach fʉletlelan tasfachan, platfachanbej, xabich kiatam. Pelax kias-emil patulelan. Xamal, me-ama japatasfachan, platfachanbej, ja-am, nejnejchaxoelaxan, me-ama xabich asda'nik xot. Xamal asbʉan jʉmch babijaxan isfʉlam. Nejchaxoelafʉlambej kenosliajwam asew jiw pejew. ");
INSERT INTO guoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Xamal fariseos, matabijslaxtat jʉm-am xot, nejnejchaxoelaxantat, me-ama itliaklawam wʉt, ja-am. ¡Majt nejchaxoelde pachaempoxan! Do ja-am wʉt, xamal isfʉlampoxan pachaemaxael Diosliajwa” —aech Jesús japox fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “Xamal judíos chanaekabʉanapijwam, xamalbej fariseos, jiw naekichachajbam. Samata, Dios xamal xabich kastikaxael. Diachwʉajnakolax xamal jiwam pachaema-emil. Xamal, me-ama patʉpamʉthan wʉt, ja-am. Patupamʉthan thʉch matjoelas wʉt papoei, me-ama pachaem wʉt, kabʉan-aech. Pe fʉniachdik xabich chaemil. Japamʉthanxotdik patʉpa xoep pathikal namaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Xamal paklochwam, ja-ambej. Jiw xamal taen wʉt, me-ama pachaemam wʉt, pakabʉan-am. Pe xabich nejchaxoelam jiw naekichachajbaliajwam. Nejchaxoelambej asaxan, chaemilpoxan, isfʉlaliajwam jiwliajwa” —aech japox Jesús judíos chanaekabʉanapiliajwa, fariseosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “Xamal judíos chanaekabʉanapijwam, xamalbej fariseos, jiwlis naekichachajbam. Samata, Dios xamal xabich kastikaxael. Diachwʉajnakolax xamal jiwam pachaema-emilpim. Chajiakolaxtat Dios pejprofetas, baespi, japi pejmʉthanmatwʉajtat, xamal cha-aelbax isam, asew jiw japoxan taen wʉt nejchafaekaliajwa. Chajiakolaxtat jiw tʉpi, japi pachaempi asew jiwliajwa, japi pejmʉthanbej chamʉthachaemtam asew jiw matabijaliajwa, taen wʉti japamʉthan. ");
INSERT INTO guoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Do jawʉx, japoxan, koloeyaxan, isax ketoetam wʉt, xamal jʉm-am: ‘Wajwʉajnapijiw sʉapich, chajiakolaxtat xanal duilaxaelen wʉt, xanal kajachawaesaxinil, japi babejchow ba wʉti Dios pejprofetas’ —am xamal. ");
INSERT INTO guoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Japoxan xamal jʉm-am wʉt, najut chiekal jʉm-am, Dios pejprofetas bapi, japi pamojiwampox. ");
INSERT INTO guoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nejwʉajnapijiw babijax isax tʉadutpox, ¡xamal chiekal toe'e!” —aech Jesús japox judíos chanaekabʉanapiliajwa, fariseosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jesús pejme jʉm-aech judíos chanaekabʉanapiliajwa, fariseosliajwabej: “¡Xamal xabich chachoelam! Me-ama jom, ¡ja-am! Ja-am wʉt, ¿machiyaxaelamkat xamal weliajwam infiernoxotdik kastika-elaliajwa xamal? ");
INSERT INTO guoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Samata, xan to'axaelen Dios pejprofetas xamal poxade, matabijsbej, judíos chanaekabʉanapibej, xamal naewʉajnaliajwapi. Pe xamal asew japixot beyaxaelam. Asew japixot kematamatlaxaelambej cruztat. Asew japixot selsaxaelam nejnaewʉajnabachanxot. Asewbej japixot dʉkp wʉt, nakiowa wʉlwekafʉlaxaelam paklowaxanxot, japi chakifolam wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jasoxtat xamal xabich nejbʉ'wʉajnaxael puexa pachaempi beyaxaespoxantat. Samata, Dios xamal kastikaxael. Chajiakolaxtat nejwʉajnapijin, Caín, boesa Abel. Do jawʉx, asew nejwʉajnapijiw, japibej befʉl asew jiw, pachaempi. Do baxael, asew nejwʉajnapijiw, japibej boesa Zacarías, japon Berequías paxʉlan. Japon Zacarías boesas temploba tathoetat, altar moxxot. ");
INSERT INTO guoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Diachwʉajnakolax xan jʉm-an. Xamal amwʉtjel laelpampim, nejwʉajnapijiw xabich jiw befʉlpoxtat Dios xabich kastikaxael xamal” —aech Jesús japox judíos chanaekabʉanapiliajwa, fariseosliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús xabich nejxaejwas, nejchaxoel wʉt Jerusalén paklowaxpijiwliajwa. Samata, jʉm-aechon: “Xamal, Jerusalén paklowaxpijwam, Dios pejprofetas beflam. Asew xamalxot ia'tat dadapam, Dios bʉxto'aspi xamalxot. Me-ama kawaema paxi pejba'bʉxfaltat tameja, xan jachisian xamal bʉ'weliajwan. Pelax xamal xan nanejwesla. ");
INSERT INTO guoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","¡Chiekal najʉmtaem! Nejpaklowaxxot Dios kaes jaxotaxil. Kaes kajachawaesaxilbejpon xamal. ");
INSERT INTO guoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma amwʉt, xamal kaes nataeyaximil. Xan pejme patx wʉt, jawʉt xamal jʉmchiyaxaelam xanliajwa: ‘¡Dios nej kajachawaesas fʉlaenpon Dios pijaxtat!’ —chiyaxaelam, pejme nataeyaxaelam wʉt” —aech Jesús, nejxaejwas wʉt Jerusalén paklowaxpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús nakolt wʉt Dios pejtemplobaxot, atʉaxach fʉlaech wʉt, xanal, pejnachalwan, mox soepax japonxot. Do jawʉt, xanal Jesús jʉm-an: —¡Taem Dios pejtemploba, asabachan, pinabachanbej, moxchalakbachan! —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Do jawʉt, Jesús jʉm-aech xanalliajwa: —Diachwʉajnakolax xan jʉm-an. Xamal taenambachan, templobabej, puexa japabachan asamatkoi chiekal toesaxaes. Chinax kaet ia't namanaxil nakae-ia'tmatwʉajtat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Do jawʉx, xanal fʉlaechx, Jesús sʉapich, Olivonaechanmʉax poxade. Pa'ax wʉt, Jesús ek mʉaxxot. Xanal tajkalan wʉt, mox soepax Jesús wʉajnachaemsliajwan. Do jawʉt, wʉajnachaemtax wʉt, jʉm-an: —Jiw chanaekabʉanan, ¡xanal nachanaekabʉanim! ¿Maswʉtkat japox jachiyaxael xam jʉm-ampox Dios pejtemploba toesaxaespoxliajwa, asabachanbej? ¿Achaxkat xanal taeyaxaelen, mox pawʉajna wʉt, xam pejme pasliajwam wʉt? ¿Achaxbejkat xanal taeyaxaelen mox pawʉajna wʉt, that toepaliajwa wʉt? —an xanal Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús jʉmnot wʉt, jʉm-aechon: —¡Chiekal taem asew jiw xamal naekichachajabasamata! ");
INSERT INTO guoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Xabich jiw fʉlaeyaxaen. Japi kaenanʉla pajut najʉmchiyaxael: ‘Xan Cristowan’ —nachiyaxaeli. Pe japi Cristowaxil. Jasoxtat xabich jiw naexasisaxaesi, naekichachajba wʉt jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Asamatkoi, xamal wʉltaenam wʉt soldaw xabich asatʉajnʉchanxot nabapox, ¡xamal nabej nejlewle'! Japoxan majt jachiyaxael, mox pawʉajna wʉt that toepaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","That toepax wʉajna, xabichaxael nabewʉajan. Kaetʉajnʉpijiw nabeyaxael, nakaetʉajnʉpijiw sʉapich. Japoxan majt jachisfʉlaxael asatʉajnʉchanlelbej. Jachiyaxaelbej, kaetʉajnʉpijiw nabeyaxael wʉt, asatʉajnʉchanpijiw sʉapich. Japoxan majt jachisfʉlaxael asatʉajnʉchanlel. Asamatkoi asatʉajnʉchanlel naxaeyaxan ajilaxael. Asatʉajnʉchanlelbej sat najaesaxael potʉajnʉcha. ");
INSERT INTO guoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Japoxan majt jachiyaxael, nabijasmatkoi tʉadut wʉt jiw nabijasliajwa. Me-ama pawis pejmatkoi wepach wʉt naxʉwlaliajwa, xabich wexaenkas, jachiyaxaelbej jiwliajwa, tʉadut wʉt nabijasax —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jesús pejme jʉm-aech xanal pejnachalwanliajwa: “Do jawʉtbej, asew jiw xamal woeyaxael xabich nabijasliajwam kastikaxtat. Xamal beyaxaelbejpi tʉpaliajwam. Puexa jiw xamal nejweslaxael, tajnachalwam xot. ");
INSERT INTO guoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Japamatkoiyan xabich jiw kofaxael Dios xanaboejapoxan. Ja-aech wʉt, japi nakaewa nanejweslaxael. Do ja-aech wʉt, japi nakaewaliajwa padaelmajiw nadofaxael. Asew japixot nakaewa nabʉflaeyaxael paklochow poxade, jaxotde beliajwas bʉ'fospi. ");
INSERT INTO guoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Japamatkoiyan xabich jiw, me-ama Dios pejprofetas wʉt, jachiyaxaeli. Pe japi profetaxil. Japi jachiyaxael xabich jiw naekichachajbaliajwa. Xabich jiw naexasisaxaespi japi jʉm-aechpoxantat. ");
INSERT INTO guoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Xabichfʉlaxael babijaxan isfʉlpi ampathatat. Samata, xabich jiw nakaewa nanejxasinkpoxan kofaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Asew jiwlax kofa-eli Dios xanaboejapoxan, hasta japi tʉp wʉt, japikal Dios bʉ'weyaxaes. ");
INSERT INTO guoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Chimiawʉajan, Dios puexa pejjiw tato'alwʉajan, potʉajnʉcha xabich jiw naewʉajnaxael puexa jiw matabijaliajwa. Do jawʉx, pasaxael that toepaxaelpox. ");
INSERT INTO guoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“¡Ampox xaljowpon nej jʉmmatabijs! Xamal xaljowam wʉt, ¡chiekal jʉmmatabijim! Daniel, Dios pejprofeta, chajia lel wʉt, jʉm-aechon: ‘Satanás to'axaeson, xabich babejkolan, japon fʉlaeyaxaen’ —aechon. Samata, xamal japon, xabich babejkolan, taenam wʉt Dios pejtemplobaxot, japon tapaeyaxisalpon jaxotaliajwa, ja-aech wʉt, ¡puexa Judea tʉajnʉpijiw nej dʉkpa pinamʉaxan poxade! ");
INSERT INTO guoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jawʉtbej, jiw pejbachanmatwʉajantat nuili, baloek wʉt, ¡nej le-ele'bej pejbachan poxade, pejew jukbaliajwa, xadʉkpaliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jawʉtbej asew jiw, nabisti pejlulantat, ¡do jaxot kaweta kamta atʉaj nej dʉkpe! ¡Kaxa nej nawe-elepi pejbachan poxadin pejew ponan wʉljaesliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Japamatkoiyan watho', moejowpi, asew watho'bej, yamxi mitan miatifʉk, xabich nabijasaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dios kawʉajanafʉlaxaelam, japox pasasamata iama wʉt, napatamatkoi wʉtbej. ");
INSERT INTO guoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Xamal dʉkpam wʉt, japamatkoiyantat xabich xamal nabijasaxaelam. Hasta amwʉtjel xabicha-ellejen nabijasax ampathatat. Dios that is wʉt, amwʉtjelbej, jachi-elfʉk nabijasax, me-ama ampamatkoiyan pasaxaelpox nabijasax. Jasoxtat jiw pejme xabich nabijasaxil. ");
INSERT INTO guoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nabijasmatkoiyan kaes xabichaxael wʉt, jiw xajʉpaxil boejtaliasliajwa. Samata, Dios tapaeyaxil jiw xabich piach nabijasliajwa. Jachiyaxaes Dios makanochpi, Dios nejxasinkas xoti” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jesús pejme xanal najʉm-aech: “Japamatkoiyan asew jiw xamalxot jʉm-aech wʉt: ‘¡Tae'nik! ¡Ma amxot Cristo!’ —aech wʉti, o, asew jiw jʉm-aech wʉtbej: ‘¡Tae'nik! ¡Ma jaxotde Cristo!’ —aech wʉti, ¡xamal nabej naexasis! ");
INSERT INTO guoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Naekichachajbapijiw matxoela fʉlaeyaxaen. Japi, me-ama Cristo, jachiyaxael. Pe japi Cristowaxil. Asew pasaxaenbej, me-ama Dios pejprofetas jachiyaxaeli. Pe japi Dios pejprofetaxil. Japi isfʉlaxael koechaxan, japoxantat xabich jiw naekichachajbaliajwa. Nejxasinkaxaelbejpi naekichachajbaliajwa jiw naexasiti Dios, japi kofaliajwa Dios xanaboejapoxan. ");
INSERT INTO guoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","¡Chiekal taem! Xamal japox jʉm-an japi pasax wʉajna chiekal najut natataeflaliajwam, japi xamal naekichachajbasamata. ");
INSERT INTO guoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Asew jiw jʉm-aech wʉt xamalliajwa: ‘¡Ma amwʉtjel Cristo pajilaxxotde!’ —aech wʉt asew jiw, ¡xamal nabej naexasis! ¡Nabej fʉlae'ebej japoxade! O, asew jiw jʉm-aech wʉtbej xamalliajwa: ‘¡Ma amxot, batutat, Cristo namoest!’ —aech wʉtbej asew jiw, ¡xamal nabej naexasis! ");
INSERT INTO guoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Xan, puexa jiw pakoewkolnan, pejme pasaxoekan wʉt, me-ama chamax nakliafcha wʉt, puexa jiw kaewʉtje kamta taena. Jachiyaxaelenbej, xan pejme pasaxoekan wʉt. Jasoxtat puexa jiw xan chalechkal kamta nataenaxael kaewʉtje. ");
INSERT INTO guoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Puexa jiw matabija ampox. Choefan tʉp wʉt, jaxot thʉtha pask. Me-ama japox, jachiyaxael asamatkoi, xan pasaxoekan wʉt. Potʉajnʉcha jiw, xan nanaexasitpi, japi matabijaxael, xan paskax wʉt” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús pejme jʉm-aech xanalliajwa: “Nabijasmatkoiyan toep wʉt, juimt matkoipijin itkʉa'nikaxael. Juimt madoipijinbej itliakaxil. Ithaejan natacholnaxaek. Do jawʉt, puexa thatbaxoxotsepi nachoelaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Do jawʉx, puexa jiw taen wʉt asax thatbaxoxot, jawʉt jiw matabijaxaeli, xan, puexa jiw takoewkolnan, fʉloeyaxoekanpox athʉsik. Samata, ampathatpijiw xabich belwaxael. Noeyaxaelbejpi. Do jawʉx, xan, puexa jiw pakoewkolnan, fʉloekx wʉt itloejentat, jiw xan nataeyaxael. Jawʉt puexa jiw tato'laxaelen. Nakthianaxaelenbej Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Do jawʉt, to'axaelen taj-ángeles trompeta nababeliajwa. Japatrompeta thatmatdukaxkal thiajoeyaxaelpox. Do jawʉt, to'axaelen taj-ángeles that xajʉpaliajwa. Do jawʉtbej, taj-ángeles xanlel jiw bʉflaeyaxaen, makanotxpikal, japi jiw tajjiwliajwa” —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesús pejme xanal najʉm-aech: “¡Chiekal nanaewe'e! Higonae pajel-ʉaf nakolax taenam wʉt, xamal matabijam waech mox pawʉajnapoxlis. ");
INSERT INTO guoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jachiyaxaelbej, taenam wʉt xan jʉm-anpoxan. Matabijaxaelam mox tawʉajnapox xan pejme pasliajwansik, puexa jiw tato'laliajwan, taj-ax Dios sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Diachwʉajnakolax xan jʉm-an. Puexa japoxan, xan jʉm-anpoxan, diachwʉajnakolax jachiyaxael. Japoxan asew jiw taeyaxael, jiw laelpifʉk ampathatat. ");
INSERT INTO guoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Thatbaxo, ampathatbej, toepaxael. Pelax tajjamechan toepaxil. Xan jʉm-anpoxan, diachwʉajnakolax japoxan jachiyaxael” —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Do pejme Jesús xanal najʉm-aech: “Puexa jiw matabija-el, maswʉt xan pejme kaxaxoekan. Dios pej-ángeles, Diosxotsepi, japibej matabija-el. Xanbej, Dios paxʉlnan, japox matabijs-enil. Kaen taj-ax Dios japox matabijt. ");
INSERT INTO guoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Chajiakolaxtat, Noé ampathatat laeje wʉt, jiw pomatkoicha nejmach duil. Me-ama japox jachiyaxael, xan puexa jiw pakoewkolnan, pejme pasliajwan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Chajiakolaxtat, that bu'lax wʉajna, jiw xael. Afbejpi. Asew nakjiyabej. Ja-aech wʉt, japamatkoiyan Noé pinjiyax barkam isax ketoet wʉt, lowpon japabarkam. Do jawʉt, chalechkal xabich iam thilnax tʉadut. That puexa chiekal bu'al wʉt, puexa jiw chiekal bu'al. Jachiyaxaelbej japamatkoi, xan, puexa jiw pakoewkolnan, pejme kaxaxoekan wʉt. Jiw duilafʉlaxael nejmach. ");
INSERT INTO guoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kolenje aton nabist wʉt lultat, kaen chalechkal bʉflaeyaxaes athʉ poxase. Asan kaweta namanaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Koliowje kaeyaxtat trigo xatkiana wʉt, kaeow chalechkal bʉflaeyaxaes athʉ poxase. Asaow kaweta namanaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Samata, ¡pomatkoicha nawʉajnawesfʉlde, xamal matabija-emil xot, maswʉt xan, nejpaklokolnan, pejme kaxaxoekan! ");
INSERT INTO guoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","¡Pe xamal ampox matabijim! Bapijin matabijt wʉt, maswʉt kethakan pasaxael, jawʉt bapijin moejchaxilon. Naliasfʉlaxaelon chiekal wesfʉlaliajwa pejba kethakan lesamata. Ja-aech wʉt, kethakan natkowaxil japon pejbatat. ");
INSERT INTO guoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Samata, ¡xamalbej chiekal nawʉajnawesfʉlde! Xan, puexa jiw pakoewkolnan, chalechkal kaxaxoekan, asew jiw, ampathatpijiw, nawʉajnawesfʉla-el wʉt” —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesús pejme jʉm-aech wʉajantat xanal pejnachalwanliajwa: “Pamakan pomatkoicha chiekal nabist pejpaklonliajwa babijax nejchaxoela-elaxtat. Paklon ajil wʉt, japon chiekal tato'al asew nabichow. Naxaeyaxanbej chiekal chaxduwbejpon pomatkoicha, me-ama paklon to'anadoftas japox isfʉlaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Paklon pat wʉt, taen wʉtbejpon pamakan chiekal nabistpox, ja-aech wʉt, pamakan xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Diachwʉajnakolax xan jʉm-an. Paklon matabijt wʉt pamakan chiekal wenabistaspox japon pejwʉlela, ja-aech wʉt, pejpaklon to'axaeson puexa pejew tataeflaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Asan pamakan, chiekal pachaema-elpon pejpaklonliajwa, japon nejchaxoel: ‘Tajpaklon makach pasaxil’ —aechon, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Samata, japon chiekal tataefla-el asew, pejpaklon pamak. Dolison, japi jiw be'bala. Do jawʉtbej, tʉadutlison xaeliajwa, saxsliajwasbej, asew jiw sʉapich. Jasox ispon pomatkoicha. ");
INSERT INTO guoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Do ja-aech wʉt, nejchaxoela-elon paklon pejpasax. Do jawʉt, chalechkal pejpaklon pasaxael. ");
INSERT INTO guoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jawʉtbej, japon xabich kastikaxaes. To'axaesbejpon asew poxadik, naekichachajbapi poxadik, infiernoxotdik. Jaxotdik xabich noeyaxaelon. Bʉa'tatisaxaelbejpon, xabich nabijasaxaek xot” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Do pejme Jesús jʉm-aech xanal pejnachalwanliajwa: “Xan, puexa jiw pakoewkolnan, pejme patx wʉt ampathatasik, taeyaxaelen asew jiw nawʉajnawesfʉlpi. Japi jiwlap leyaxael Dios tato'alxotse. Asew jiw nawʉajnawesfʉla-elpi, japi jiwlax leyaxil Dios tato'alxotse. Jʉmchiyaxaelen wʉajantat xamal chiekal matabijaliajwam. Asamatkoi diez watho', pansiachow, kaenanʉla xafoli lámpara pawis nakjiyaxaelpow pejba poxaliajwade. Dolisi, fʉlaechlisi japaba poxade wʉajnawesliajwa japon aton, nakjiyaxaelpon, japow sʉapich. Japon aton jaxot pat wʉt, japi watho' kaewʉtje nak-fʉlaeyaxael nakleliajwa fiestaxot. ");
INSERT INTO guoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Japi watho'xot, cinco watho', pansiachow, chajia chiekal nejchaxoel isaxaelpoxliajwa. Asew cinco watho' pansiachow chajia chiekal nejchaxoela-el isaxaelpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dolisdo', watho' chajia chiekal nejchaxoela-eli xafoli pejlámpara. Pe xalae-eli olivosimint, lámpara wesiajwas wʉt pejme falaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Asew watho', pansiachow, chajia chiekal nejchaxoeli, japilax kaenanʉla xafol olivosiminan batiajtat, pejlámpara wesiajwas wʉt pejme falaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Japon aton, nakjiyaxaelpon, makach pas-el pʉaxaxaelpon pejbaxot. Samata, japi watho' itmoejslalisi. Do jawʉt, puexa moejtlisi. ");
INSERT INTO guoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pinmadoi wʉt, kaen aton nejlakcha wʉt, jʉm-aechon: ‘¡Aton, nakjiyaxaelpon, fʉlaenlison mox! ¡Xabʉa't bʉ'kʉlaliajwam!’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Puexa japi watho', pansiachow, nathikba wʉt, nanbapi. Kaenanʉla chaemsnapi pejlámpara. ");
INSERT INTO guoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Watho', chajia nejchaxoela-eli, jʉm-aech asew watho', cincopiliajwa: ‘¡Xanal nachaxdu'e cha-aeldoech, olivosimint, xanal tajlámpara falaliajwan, itkakʉawak xot!’ —aechi asew watho'liajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Asew, cinco watho', jʉmnot wʉt, jʉm-aechi: ‘¡El! Xanal nawexajʉpaxil pasimint xamalliajwa, xanalliajwabej. ¡Xabʉa'de olivosiminan mowa poxade kaes wʉajsliajwam!’ —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Do jawʉt, japi watho' fʉlaech wʉt olivosiminan wʉajsliajwa, pasiminan wʉajsax kijil wʉtfʉk, japon aton patlison. Asew, cinco watho', chajia chiekal nejchaxoeli, nakfʉlaechlisi japon aton, nakjiyaxaelpon, pejfiesta poxade. Japi batutat wʉt, bafafa chiekal faka'tlisi. ");
INSERT INTO guoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Do jawʉx, cinco watho', pasiminan wʉajsax kijilpi, japibej pat japabaxot. Japi watho' jʉm-aech nakjiyaxaelponliajwa: ‘¡Tajpaklon, ba fafa'e xanal leliajwan!’ —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Japon jʉmno'an wʉt, jʉm-aechon: ‘Diachwʉajnakolax xan jʉm-an. Chinax xamal matabijs-enil. Samata, ba fafasaxinil xamal leliajwam’ —aech nakjiyaxaelpon cinco watho', pansiachowliajwa” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Do pejme Jesús jʉm-aech xanalliajwa: “Xamal xan nanaewetampim, ¡chiekal nawʉajnawesfʉlde! Me-ama watho' chajia chiekal nejchaxoeli, ¡ja-amsfʉlde xamal, xan nawʉajnawesfʉlam wʉt, matabija-emil xot, achamatkoitat xan pasaxaelen!” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús pejme xanal najʉm-aech wʉajantat: “Dios pejjiw tato'alpox, me-ama kaen aton, lapon tres pamakjiw, fʉlaeyaxael wʉton asatʉajnʉlel. Do jawʉt, japi pat wʉt japonxot, kaenanʉla pamakjiwxot pejew plata waelapon, japi xanbichliajwa japaplata japon pejwʉlela. ");
INSERT INTO guoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pamaktxot plata waela wʉt, nejchaxoelon: ‘Tamakan kaes chiekal xajʉpon nawetataeflaliajwa plata, japon kaes pejme chaxdusaxaelen. Asan xajʉpa-elpon chiekal nawetataeflaliajwa plata, japon kaesʉapich chaxdusaxaelen’ —aechon, nejchaxoel wʉt. Samata, kaen pamakanxot waelton cinco platachoxa. Asan pamakanxot waelton koleplatachoxa. Asan, taxdukapijinxot kaeplatachoxa waelton. Do jawʉx, japon paklon chijialison atʉaj, asatʉajnʉlel. ");
INSERT INTO guoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cinco platachoxa wewaeltaspon, japon chiekal xanbichfʉl japaplata pejpaklon pejwʉlela. Samata, japon kaes pejme cinco platachoxa kana. ");
INSERT INTO guoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Koleplatachoxa wewaeltaspon, japonbej chiekal xanbichfʉl japaplata. Ja-aech wʉt, japonbej kaes koleplatachoxa kana. ");
INSERT INTO guoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kaeplatachoxa wewaeltaspon, japonlax asbʉan jʉmch mʉtht kowpon chamʉthsliajwa japaplatachoxa, chamoesliajwabejpon. ");
INSERT INTO guoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Do baxael, xabich pin-iamatkoiyan wʉt, paklon nawi'anlison pamak poxadin. Pat wʉton pamaktxot, lalison pamak matabijsliajwa, ma-aechi kaenanʉla, plata xanbist wʉti japon pejwʉlela. ");
INSERT INTO guoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Matxoelapatpon, japon cinco platachoxa wewaeltaspon, japon chaxdut pejpaklon diez platachoxa. Japon jʉm-aech: ‘Tajpaklon, xanxot cinco platachoxa waelsnadoftam. Xan pejme cinco platachoxa kanx’ —aechon paklonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Paklon jʉmnot wʉt, jʉm-aechon pamakanliajwa: ‘Xam xabich pachaemam. Chiekal isfʉlambej xan to'axpox. Xam chiekal nawenabistam xot, kaeyaxach wʉt, samata, xam xabich kaes pejme tejew nawetataeflaxaelam. ¡Lemen! ¡Nejchachaemilde, xan sʉapich!’ —aech paklon pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Do jawʉx, koleplatachoxa wewaeltaspon, japonbej pat pejpaklonxot. Japon jʉm-aech: ‘Tajpaklon, xanxot koleplatachoxa waelsnadoftam. Xan pejme kanx koleplatachoxa. Ama cuatro platachoxa’ —aech pamakan. ");
INSERT INTO guoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Paklon jʉmnot wʉt, jʉm-aechon pamakanliajwa: ‘Xam xabich pachaemam. Chiekal isfʉlambej xan to'axpox. Xam chiekal nawenabistam xot, kaeyaxach wʉt, samata, xam xabich kaes pejme tejew nawetataeflaxaelam. ¡Lemen! ¡Nejchachaemilde, xan sʉapich!’ —aech paklon pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Do jawʉt, asan pamakan pat, kaeplatachoxa wewaelsnadoftaspon. Japon jʉm-aech pejpaklonliajwa: ‘Tajpaklon, xan matabijtax, xam namak beltae-emil. Xam kanambej nabich-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Samata, xan tajlewla xamliajwa. Samatabej, chamʉthtax nejplatachoxa chamoesliajwan satat. ¡Ama nejplatachoxa!’ —aech pamakan. ");
INSERT INTO guoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Paklon jʉmnot wʉt, jʉm-aechon: ‘Xam kewechanam. Babejnambej. Xam matabijtam, xan kanxpox nabich-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Ma-aech xotkat tajplata bancopijiw poxade nawexalae-emil japi prestaliajwam kaes nawe-itamaesliajwam prestampoxtat? Chil xam jasox isam wʉt, chil amwʉtjel bancopijiw kaes plata nawewiat xam prestampoxtat’ —aech paklon pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Do jawʉt, japon paklon jʉm-aech asew jaxotpiliajwa: ‘¡Kechafi'epon japaplatachoxa! ¡Japaplatachoxa chaxdu'e xan nachaxdutpon diez platachoxa! ");
INSERT INTO guoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tejew chiekal nawetataefʉlpon, japon kaes chaxdusaxaelen. Japonbej wenamanaxaes. Asanlax, chiekal nawetataefla-elpon tejew, japon kaesʉapich nawetataeflafʉlpox, kefisaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ampon, kewechan nabichliajwa, ¡jaeldepon! ¡Fo'impon tathoetade, itkʉatax poxade, jaxotde kastikaliajwas! Jaxot xabich noeyaxaelon. Bʉa'tatisaxaelbejpon, xabich nabijasaxael xot’ —aech paklon japonliajwa” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Do pejme Jesús jʉm-aech xanal pejnachalwanliajwa: “Xan, puexa jiw pakoewkolnan, pejme pasaxoekan wʉt, Dios pej-itliak namasajiasaxael. Xabich Dios pej-ángelesbej namasajiasaxael, bʉ'pasaxoekan wʉt. Do jawʉt, puexa jiw pejpaklonaxaelen, ekx wʉt tajtʉa-ekaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Puexa ampathatpijiw natamejaxael tajwʉajnalel. Jawʉt xan jiw diajkaxaelen kolemʉtjeliajwa. Me-ama ovejas tataeflan pejlel diajk ovejas cabrasxot, xanbej jachiyaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jiw, xan nanaexasiti, tamejaxaelen tajpoklalel. Japi, me-ama taj-ovejas. Asew jiwlax, xan nanaexasis-elpi, japi tamejaxaelen tajsoenalel. Japi, me-ama cabras. ");
INSERT INTO guoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Xan, paklokolnan, jʉmchiyaxaelen tajpoklalelpijiwliajwa: ‘¡Xamal xabʉa'din xanlel, taj-ax Dios kajachawaetpim! Patlisox Dios xamal tato'laxaelpox. Japoxliajwa taj-ax Dios chajia nejchaxoel, akaseskolaxtat that is wʉton. ");
INSERT INTO guoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Xan litaxaelax wʉt, xamal naxaeyax nachaxdutam xan xaeliajwan. Xan minsila wʉtbej, mint nachaxdutam min feliajwan. Xan atʉajan wʉt tajtʉajnʉxot, nejbatat namanax nato'am. ");
INSERT INTO guoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Xan naxoelaliajwan nawejil wʉtbej, nachaxdutam naxoelaliajwan. Bʉ'xaenkax wʉtbej, nataentam nakajachawaesliajwam. Jiw jebatatax wʉtbej, nataentam’ —chiyaxaelen tajpoklalelpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Do jawʉt, xan nanaexasiti nawʉajnachaemsaxael: ‘Tajpaklon, ¿maswʉtkat xam taenx, litaxaelam wʉt chaxdusliajwan naxaeyax? ¿Maswʉtbejkat xam taenx, minsila wʉt chaxdusliajwan mint? ");
INSERT INTO guoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Maswʉtbejkat xam taenx, nejtʉajnʉxot atʉajam wʉt namanax to'aliajwan tajbatat? ¿Maswʉtbejkat xam kejimil naxoelax xanal chaxdusliajwan? ");
INSERT INTO guoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Maswʉtbejkat xam taenx, bʉ'xaenkam wʉt kajachawaesliajwan? ¿Maswʉtbejkat xam taenx, jiw jebatatam wʉt?’ —chiyaxaeli xan nanaexasiti. ");
INSERT INTO guoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Xan, nejpaklonan jʉmnosaxaelen wʉt, jʉmchiyaxaelen: ‘Diachwʉajnakolax jʉmchiyaxaelen. Puexa xamal isam wʉt pachaempoxan xan nanaexasitiliajwa, japoxan isam wʉt, xan, me-ama nakajachawaetam’ —chiyaxaelen xan nanaexasitiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Do jawʉx, xan, puexa jiw pakoewkolnan, jʉmchiyaxaelen tajsoenalelpijiwliajwa: ‘¡Chijiamde xanxot! Dios xamal kastikaxael, babijaxan isam xot. ¡Xabʉa'de infierno poxadik! Jaxotdik pomatkoicha jit pinjiyax tamdadut. Japox jit itkʉawaxil. Japajitxotdik Dios chaemt Satanás kastikaliajwas, puexa pejdepbej. ");
INSERT INTO guoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Litaxaelax wʉt, nachaxdus-emil naxaeyax xan xaeliajwan. Minsila wʉtbej, nachaxdus-emil mint xan feliajwan. ");
INSERT INTO guoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Atʉajan wʉt tajtʉajnʉxot, xan namanax. Nato'a-emil nejbaxot moejsliajwan. Nawejil wʉtbej xan naxoelaliajwan, nachaxdus-emil naxoelax. Bʉ'xaenkax wʉtbej, xan natae-emil nakajachawaesliajwam. Jiw jebatatax wʉtbej, natae-emil’ —chiyaxaelen tajsoenalelpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Do jawʉt, japi jiw nawʉajnachaemsaxael: ‘Tajpaklon, ¿maswʉtkat xanal xam kajachawaes-enil, xam litaxaelam wʉt, o, xam minsila wʉtbej, o, xam atʉajam wʉtbej nejtʉajnʉxot, o, kejimil wʉtbej naxoelaliajwam, bʉ'xaenkam wʉtbej, o, jiw jebatatam wʉtbej?’ —chiyaxaeli xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Do jawʉt, xan puexa jiw pakoewkolnan, japi jiw jʉmnosaxaelen: ‘Diachwʉajnakolax xan jʉm-an. Xamal is-emil pachaempoxan jiw xan nanaexasitiliajwa. Japox is-emil xot japiliajwa, xamal is-emil pachaempoxan xanliajwa’ —chiyaxaelen tajsoenalelpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Do jawʉt, tajsoenalelpijiw chijiyaxael infierno poxadik, jaxotdik pomatkoicha kastikaliajwas. Xan nanaexasitilax, japi athʉ poxaxoei, pomatkoicha duilaliajwa Diosxotse” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Do jawʉt, Jesús japoxan bʉxtoet wʉt, pejme jʉm-aechon xanal pejnachalwanliajwa: —Xamal matabijam ampox. Kolematkoije we'pfʉk Pascuafiestaliajwa. Jawʉt xan, puexa jiw pakoewkolnan, asan nawiasaxael asajiwxot japi nakematamatlaliajwa cruztat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jawʉt sacerdotespaklochow, judíos-ancianosbej, natameja Caifás pejbaxot. Japon sacerdotespaklokolan. ");
INSERT INTO guoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jaxot nospaeipi Jesús jaelsaxliajwa, jeliajwasbejpon jiw jebatat. Naekichachajbasiapi Jesús maliach bʉflaeliajwas, boesaliajwasbej Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pe nakaewa najʉm-aechi: —Jasox isaxisal fiestatat. Japox isas wʉt, jiw xabich palalaxael. Ja-aech wʉt, jiw bej chamamosaxaelbejpi Jesús —aech paklochow nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Baxael, Jesús Betania paklowaxxot wʉt, Simón pejbaxoton. Japon Simón, majt leprawaxae waechpon. ");
INSERT INTO guoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Japon pejbaxot kaeow pawis mox soepan Jesúsxot. Japow xafolow perjumamint alabastro-ia'batiajtat. Japaperjumamint xabich ommaenk. Jesús ek wʉt mesaxot, japaperjumamintat matnaechafanpow Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Xanal pejnachalwan japox taenx wʉt, xabich talala japowliajwa. Xanal nakaewa najʉm-an: —¿Ma-aech xotkat japow tabejt japot, perjumamint? ");
INSERT INTO guoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Japot, perjumamint, xabich ommaenk. Japaperjumamint tabejs-el wʉtow, chil mowas wʉt, xabich plata kanaxaes. Ja-aech wʉt, pachaemaxael japaplata chaxduiliajwas kejila —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús japox jʉmtaen wʉt, jʉm-aechon xanalliajwa: —¡Nej ja-aeche'! ¿Ma-aech xotkat japox jʉm-am? Japow japox is wʉt xanliajwa, japow is pachaempox xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kejila pomatkoicha xamalxotaxael kajachawaesliajwam. Pelax xan xamalxotaxinil xabich piach. ");
INSERT INTO guoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Japow perjumamint namatnaechafan wʉt, nachawʉajnachaemtow, asamatkoi xan tʉpx wʉt, namʉthsaxael xot. ");
INSERT INTO guoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Diachwʉajnakolax xan jʉm-an. Potʉajnʉcha naewʉajan wʉti chimiawʉajan jiw bʉ'weliajwas, japamatkoiyan wʉt, jʉmchiyaxaelbejpi japow ispox xanliajwa. Jasoxtat nejchafaekafʉlaxaeli japowliajwa —aech Jesús, xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Xanal puexa padosanpinxot, kaen pawʉl Judas Iscariote. Japonlap fʉlaech sacerdotespaklochow poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jaxotde pa'a wʉt, wʉajnachaemt wʉt, jʉm-aechon: —¿Massʉapichkat xamal wʉlnamotam, xan wiasaxaelen wʉt Jesús xamalxot? —aech Judas. Do jawʉt, paklochow jʉmnot wʉt, jʉm-aechi: —Xanal mosaxaelen treinta platafachan, xam wiatam wʉt Jesús xanalxot —aechi. Do jawʉt, Judas kaenejchaxoelax, japi sʉapich, japaplataliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Do jawʉtlejen, Judas tʉadut wʉajnawesliajwa pachaemmatkoi Jesús wiasliajwapon Jesús padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Fiestamatkoi pat wʉt pan puthla-eli xaeliajwa, japafiestatat kolenje, Jesús pejnachalan, mox soepa Jesús wʉajnachaemsliajwapi. Japi jʉm-aech: —¿Amxotkat xanal naxaeyax isaxaelen, Pascuafiesta wʉt xatis xaeliajwas? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús jʉmnot wʉt, jʉm-aechon: —¡Xabʉa'de paklowax poxade! Jaxot pa'mach wʉt, kaen aton, matabijtaspon, taeyaxaelam. ¡Japon jʉm-amo: ‘Wajpaklon jʉm-aech: “Tajmatkoi moxlisox, nabijasaxaelenpox. Nejba poxaxaelen, tajnachala sʉapich, Pascuafiestanaxaeyax xaeliajwan” —aechon’ —amo bapijin! —aech Jesús, bʉxto'a wʉt kolenje pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Do jawʉt, japi fʉlaechlisi. Islisi Jesús to'aspox. Pascuafiestanaxaeyax islisi xanal xaeliajwan. ");
INSERT INTO guoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Do madoi wʉt, xanal dosan chalakx mesaxot, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Xanal naxaelax wʉtfʉk, Jesús najʉm-aech xanalliajwa: —Diachwʉajnakolax xan jʉm-an. Kaen xamalxot xan nawiasaxaelon tadaelmajiwxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Xanal xabich nanejxaejow, japox jʉmtaenx wʉt. Samata, xanal kaenanʉla Jesús wʉajnachaemsfʉlax wʉt, jʉm-ansfʉlax: —Tajpaklon, ¿xankatlap xam wiasaxaelen? —ansfʉlax xanal. ");
INSERT INTO guoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús jʉmnot wʉt, jʉm-aechon: —Xan sʉapich, kaeplaftat panax taxthotpon, japonlap xan nawiasaxael tadaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Xan, puexa jiw pakoewkolnan, tʉpaxaelen, me-ama Dios pejjamechan chajia jʉm-aech japoxliajwa. Pe xan nawiasaxaelpon tadaelmajiwxot, japonliajwa xabich kaes pejme chaemilaxael. Japon nalaelsa-el wʉt ampathatat, kaes pejme pachaemaxael japonliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Do jawʉt, Judas, wiasaxaelpon Jesús padaelmajiwxot, wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —Tajpaklon, ¿xankatlap xam wiasaxaelen? —aech Judas. Jesús jʉmnot wʉt, jʉm-aechon Judasliajwa: —Xamaxaelam, me-ama xam najut jʉm-am —aech Jesús Judasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Do jawʉt, xanal naxaelax wʉtfʉk, Jesús panax fit. Dios kawʉajan wʉt, jʉm-aechon: “Ax, gracias-an xanal nachaxdutam xot ampapan” —aech Jesús. Do jawʉt, Jesús jalkafʉl panax, xanal pejnachalwan nakexadiajsliajwa. Do jawʉt, Jesús najʉm-aech xanalliajwa: —¡Xaem pan! Japapan, me-ama tajwit —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Do jawʉt, Jesús copa chafit puexa xanal kaenanʉla fiaflaliajwan. Do jawʉtbej, Dios kawʉajan wʉt, gracias-aechon vinoliajwa. Do jawʉt, xanal nachaxduton vino copatat. Do jawʉtbej, jʉm-aechon: —¡Ampavino puexa xamal kaenanʉla fiafʉlde! ");
INSERT INTO guoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ampot, me-ama tajjal. Xan tʉpx wʉt, tajjal nakolaxael. Japox jiw naexasit wʉt, beltaeyaxaes babijaxan ispoxanliajwa, tajjal pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Diachwuajnakolax xan jum-an. Pejme feyaxinil vino ampathatat. Dios puexa pejjiw tato'almatkoi pat wʉt, jawʉt pejme japamatkoitat pajelt vino feyaxaelen Diosxotse, xamal sʉapich —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Do jawʉt, kaet jajuit jajuiyax bʉxtoetx wʉt, fʉlaechx mʉax poxade, olivonaechan nuil poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Do jawʉx, Jesús olivonaechan nuilxot nabʉ'pa'a wʉt, jawʉt najʉm-aechon xanalliajwa: —Ampamadoitat puexa xamal kaenanʉla nasalaxaelam nejlel xanxot, xan nejxanaboejampox kofaxaelam xot. Japoxliajwabej Dios pejjamechan, chajia lelspox, jʉm-aech, Dios jʉm-aech wʉt xanliajwa: ‘Boesaxaes ovejas tataeflan. Ja-aech wʉt, puexa pejew ovejas, nasalaxael’ —aech Dios jʉm-aechpox xamalliajwa, xanxot nasalaxaelampox. ");
INSERT INTO guoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Asajiw xan naboesa wʉt, taj-ax Dios namat-esaxael pejme dukaliajwan. Do jawʉt, xan wʉajnaxaelen Galilea tʉajnʉxot xamal wʉajna —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Do jawʉt, Pedro jʉm-aech: —Puexa asew nejnachala kofa wʉt pejxanaboejaxan xamliajwa, xanlax kofsaxinil tajxanaboejsax xamliajwa. Xan nakiowa xam xanaboejsfʉlaxaelen —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan jʉm-an. Ampamadoitat kawaema nejlae-el wʉtfʉk, xam naxanaliyaxaelam. Tres veces jʉmchiyaxaelam: ‘Xan japon aton matabijs-enil’ —chiyaxaelam, xanaliam wʉt xanliajwa —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro nejthʉ'axtat jʉm-aech: —Nejmachjiw najʉm-aech wʉt: ‘Xam boesaxaelen, Jesús pejnachalnam xot’ —na-aech wʉti, xan elchiyaxinil —aech Pedro Jesúsliajwa. Xanal, Jesús pejnachalwan, kaenanʉla japox kaeyax jʉmanbej, Pedro matxoelajʉm-aechpox. ");
INSERT INTO guoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Do jawʉx, Jesús, xanal pejnachalwan sʉapich, pa'ax pawʉlxot, Getsemaní. Jaxot wʉt, xanal najʉm-aechon: —¡Amxot chalakde! Xan wʉajnaxaechan, taj-ax Dios kawʉajnaliajwan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Do jawʉt, Jesús kaesʉapich atʉaxach bʉflaechon Pedro, kaes asan kolenjebej. Kaen japixot pawʉl Santiago. Asan pawʉl Juan. Japi kolenje, Zebedeo paxi. Do jawʉt, Jesús tʉadut xabich nejxaejwaliajwas. Xabich nejchaxoelbejpon tʉpaxaelpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Do jawʉt, jʉm-aechon tres pejnachalanliajwa: —Xan xabich nanejxaejow. Me-ama kaen aton tʉpaxael wʉt, ja-aech nanejxaejowpox. ¡Amxot xamal namaem! ¡Nabej moejs! ¡Naliasfʉlde, xan sʉapich! —aech Jesús tres pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Do jawʉt, Jesús kaes atʉaxach tamach fʉlaechon. Jaxotde wʉt, brixtat nuklison sat makxabijnaliajwadik. Do jawʉt, pax Dios kawʉajan wʉt, jʉm-aechon: —Ax, nabʉ'wesiam wʉt, ¡nabʉ'wem nabijasaxaelenpox! ¡Pe nabej is xan nejxasinkaxpox! ¡Isde xam nejxasinkampox! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jawʉt, kaxadin wʉt pejnachala poxadin, taenlison, japi moejt wʉt. Do jawʉt, Jesús jʉm-aech Pedroliajwa: —¿Xamkat xajʉpa-emil kaehora naliasliajwam, xan sʉapich? ");
INSERT INTO guoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","¡Naliasfʉlde Dios kawʉajnaliajwam! Ja-am wʉt, Dios xam kajachawaesaxael isasamatam babijax. Nejnejchaxoelaxtat isasiam xan jʉm-anpox. Pe nejbʉ't chiekal mamnika-el, xam xabich itmoejsla xot —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús pejme fʉlaech wʉt, pax Dios kawʉajan wʉt, jʉm-aechon: —Ax, nabʉ'we-elasiam wʉt nabijasaxaelenpox, ¡isde xam nejxasinkampox! Nabijasax nataesiam wʉt, xan nabijasaxaelen —aech Jesús pax Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Do jawʉt, Jesús pejme kaxadin wʉt, pejnachala nakiowa asbʉan jʉmch moejtfʉki, xabich itmoejsla xot. ");
INSERT INTO guoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Do pejme Jesús japi waela jaxot. Fʉlaechon pejme pax Dios kawʉajnaliajwa. Matxoelakawʉajanpox, japox pejme jʉm-aechon. Jasoxtat Jesús kawʉajan pax Dios. ");
INSERT INTO guoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Do pejme kaxadin pejnachala poxadin. Pat wʉton japixot, jʉm-aechon: —¿Xamalkat nakiowa moejtamfʉk? ¿Damlathʉlambej? Xan, puexa jiw pakoewkolnan, tajhora nawepat. Nawiasaxaelon babejchowxot. ");
INSERT INTO guoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Nanim! ¡Amxot chijias! Fʉlaenlison mox nawiasaxaelpon tadaelmajiwxot —aech Jesús japi tres pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús naksiya wʉtfʉk xanalliajwa, jawʉt Judas pat. Japon kaen xanalxotpijin. Japontat dosan. Japon xabich jiw bʉ'pat. Japi jiw xafol espada, iwabej. Japibej nakfʉlaen, sacerdotespaklochow to'as xot, judíos-ancianos to'as xotbejpi. ");
INSERT INTO guoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, japon Jesús wiasaxaelpon padaelmajiwxot, chajia chiekal jʉm-aechon japi jiw chiekal matabijaliajwa: “Xan xusuiyaxaelenpon, ¡japonlap xamal jaelsaxaelam!” —aech Judas. ");
INSERT INTO guoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Do jawʉt, Judas mox soepan wʉt Jesúsxot, jʉm-aechon Jesúsliajwa: —Tajchanaekabʉanan, xan patx —aech Judas. Kejacha wʉt, xusuwpon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon Judasliajwa: —Fʉlaemanpox isliajwam, ¡ama japox isde! —aech Jesús Judasliajwa. Do jawʉt, Judas jiw bʉflaenpi, japi mox soepa Jesúsxot. Do jawʉt, Jesús jaeltas bʉflaeliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesús jaeltas wʉt, kaen xanalxot kukcha pej-espada. Do jawʉt, japon asan naecho'chikchapon. Cho'chikchaspon nabist sacerdotespaklokolanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús jʉm-aech pejnachalanliajwa: —¡Espada jem ta-akadik! Puexa jiw nabapi espadatat, tʉpaxaelbejpi espadatat. ");
INSERT INTO guoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Xamal matabija-emil. Xan wʉljowx wʉt taj-ax Dios, japon ma amwʉt to'axoek xabich pin-iakola pej-ángeles xan nabʉ'weliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pe xan japox wʉljoeyaxinil. Dios pejjamechan, chajia lelspox, jʉm-aech najaelsliajwapox. Samata, ja-aechlisox —aech Jesús pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Do jawʉt, Jesús wʉajnachaemt wʉt, jʉm-aechon bʉflaeyaxaespiliajwa: —¿Ma-aech xotkat xamal xafolam espada, iwabej, xan najaelsasiam wʉt? ¿Xankat, me-ama natkowanan wʉt, kabʉan-an xamalliajwa? Kaematkoisfʉl xan ekx Dios pejtemplobaxot, jiw naewʉajnaliajwan. Jaxot xamal xan najaels-emil, Dios xamal tapae-el xotfʉk. ");
INSERT INTO guoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dios pejjamechan profetas chajia lelpox jʉm-aech, japox jachiliajwa. Samata, japox ja-aechlisox —aech Jesús japi jiwliajwa. Do jawʉt, xanal, japon pejnachalwan, Jesús tamach waeltax. Xanal padʉkpax tajlel. ");
INSERT INTO guoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesús jaeltpi, japi bʉflaech Caifás pejba poxade. Caifás sacerdotespaklokolan. Japon pejbaxot judíos chanaekabʉanapi, judíos-ancianosbej, wʉajna natamejapi. ");
INSERT INTO guoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesús bʉ'fos wʉt, Pedro atʉaxach wʉchakal fol. Japi jiw bʉ'pat wʉt sacerdotespaklokolan pejbaxot, jawʉt Pedrobej pat japabafʉlmaktxot. Jaxot nak-ekon, temploba weti sʉapich, ketaeliajwa Jesús padaelmajiw isaxaelpox Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Do jawʉt, sacerdotespaklochow, puexa judíos-ancianosbej, japi nejchaxoel Jesús tasalaspoxtat boesaliajwas. Samata, wʉlweki wʉajan, diachwʉajnakolaxa-elox, Jesús xabich tasalaliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Xabich jiw fʉlaen tasalaliajwapi Jesús kichachajbapoxtat. Pe paklochow wepachaema-esal japoxantat tasalaliajwapi Jesús. Samata, wʉajan faena-eli tasalaliajwapi Jesús. Baxael, asew kolenje fʉlaen paklochow poxadin. ");
INSERT INTO guoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Japi jʉm-aech ampox: —Ampon aton majt jʉm-aech: ‘Xan xajʉpx toesliajwan Dios pejtemploba. Xajʉpxbej pejme mat-esliajwan, tres matkoi wʉt’ —aech ampon aton —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Do jawʉt, sacerdotespaklokolan nant wʉt, jʉm-aechon Jesúsliajwa: —¿Diachwʉajnakolaxkat japi jiw jʉm-aechpox xamliajwa? ¿Xamkat japi jiw jʉmnosaximil? —aech sacerdotespaklokolan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pe Jesús boejlach nuk. Do jawʉt, sacerdotespaklokolan pejme jʉm-aech: —¡Dios athʉpijin pijaxtat najʉm-amde diachwʉajnakolaxpox! ¿Xamkatlap diachwʉajnakolax Cristowam, Dios paxʉlnam? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús jʉmnot wʉt, jʉm-aechon: —Puexa xam jʉm-ampox xanliajwa, diachwʉajnakolax. Xan, puexa jiw pakoewkolnan, ekaxaelen taj-ax Dios poklalel jiw tato'laliajwan. Taj-ax Dios xabich mamnik puexaliajwa. Xamal japox taeyaxaelam, xan fʉloekx wʉt athʉlelsik itloejentat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Do jawʉt, sacerdotespaklokolan japox jʉmtaen wʉt, pajut thiakchapon pijax, naxoelax, xabich palala xot. Do jawʉt, sacerdotespaklokolan kaes jʉm-aech: —Ampon aton jʉm-aech Dios nejxasinka-elpox. Kaes asew jiw nakwewe'pa-el tasalaliajwas japon. Xamal najut chiekal jʉmtaenam, japon jʉm-aech wʉt japox Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Achaxkat xamal nejchaxoelam ampon atonliajwa? —aech sacerdotespaklokolan. Do jawʉt, japi puexa jʉmnot wʉt, jʉm-aechi: —Ampon aton pejbʉ'wʉajan. Samata, kastikaxaeson. Boesaxaesbejpon —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Do jawʉt, Jesús xuloeyaspon. Xutulapasbejpon. Asew japixot ke-etat xuselbalapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Itfumatakʉs wʉt, jʉm-aechipon: —Xam Cristowam wʉt, ¡jʉm-amde! ¿Achankat xam xutulap? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro ekfʉk sacerdotespaklokolan pejbafʉlmaktxot. Jawʉt kaeow pawis, nabistow japabaxot, japow mox soepan Pedroxot. Do jawʉt, japow jʉm-aech Pedroliajwa: —Diachwʉajnakolax xam Jesús pejnachalnam, japon Galilea tʉajnʉpijin —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Do jawʉt, Pedro pajutliajwa naxanalia wʉt puexa jiw pejwʉajnalel, jʉm-aechon: —Xan matabijs-enil najʉm-ampox —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Do jawʉt, Pedro fʉlaech bafafa poxade. Jaxotde Pedro asaow pawis pejme taenspon. Japowbej jʉm-aech asew jaxot nuilpi jʉmtaeliajwas: —Ampon aton, nanʉamt Jesús, Nazaret paklowaxpijin sʉapich —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Do jawʉt, Pedro pejme pajut naxanalia wʉt Jesúsliajwa, jʉm-aechon: —Dios chiekal matabijt, xan japon aton matabijs-enilpox —aech Pedro nejthʉ'axtat. ");
INSERT INTO guoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Do jawʉtlejen, jaxotpijiw Pedro mox soepas. Japi jʉm-aech: —Diachwʉajnakolax xambej Jesús pejnachalnam. Naksiyam wʉt, me-ama Galilea tʉajnʉpijiw naksiya wʉt, jajʉm-am —aech japi Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Do jawʉt, Pedro pejme jʉm-aech: —Diachwʉajnakolax jʉmchi-enil wʉt, ¡Dios xan nej nakastike'! Xan japon aton matabijs-enil —aech Pedro japi jiwliajwa. Do jawʉtlejen, kawaema nejla. ");
INSERT INTO guoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Do jawʉt, Pedro nejchafaet Jesús jʉm-aechpox, chajia jʉm-aech wʉt: “Kawaema nejlae-el wʉtfʉk, xam naxanaliyaxaelam tres veces” —aech Jesús, jʉm-aech wʉt. Do jawʉt, japabafʉlmaktxot Pedro nakolt tathoetade. Jaxotde xabich nowpon, xabich nejxaejwas xot. ");
INSERT INTO guoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nalian wʉt, puexa sacerdotespaklochow, judíos-ancianosbej, natameja kaenejchaxoelaxliajwa boesaliajwas Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Do jawʉx, bʉ'foslison mʉaxmatakʉiyaxtat gobernador Pilato poxade. Jesús wiach Pilatoxot. Pilato Judea tʉajnʉpijiw tato'lan, to'as xoton Roma tʉajnʉpijiw tato'lan. ");
INSERT INTO guoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Do jawʉt, Judas, Jesús wiatpon padaelmajiwxot, taen wʉton Jesús tasalaspox boesaliajwas, jawʉt xabich Judas nejxaejwas Jesúsliajwa, japon ispoxliajwabej. Samata, treinta platafachan pejme xapaton wiasliajwa sacerdotespaklochow natamejaxot, judíos-ancianos sʉapich, Dios pejtemplobatat. ");
INSERT INTO guoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas jaxot pat wʉt, jʉm-aechon japi paklochowliajwa: —Xan babijax isx japon atonliajwa, babijax is-elponliajwa, bʉ'fos xoton boesaliajwas —aech Judas japiliajwa. Japi jʉmnot wʉt, jʉm-aechi: —¿Ma-aech xotkat japox xanal najʉm-am? Japox xam nijax. Xanal japox tajaxa-el —aechi Judasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Do jawʉt, Judas japaplata thokcha Dios pejtemplobatutat. Do jaxot nakoltlison tathoetade. Do jawʉx, pajut nakaechariamake'ton naetat. Jawʉt dukjiklison patʉpan. ");
INSERT INTO guoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judas nakolt wʉt Dios pejtemplobaxot, jawʉt sacerdotespaklochow notlisi japaplatafachan, Judas thokchapi Dios pejtemplobatat. Not wʉt, nakaewa najʉm-aechi: —Ampaplatafachantat moch kaen aton boesaliajwas. Samata, ampaplatafachan kenosaxisal Dios pej-ofrendaliajwa —na-aechi nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Do jawʉt, japi kaenejchaxoelax sat wʉajsliajwa, japasatxot mʉthaliajwapi judíos-eli tʉp wʉt Jerusalén paklowaxxot. Japasat wʉajtxoti, majt pawʉl Baexfa'san Pejsat. ");
INSERT INTO guoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hasta amwʉtjel japasat pawʉlfʉk Jalsat, japaplatafachantat mot xoti kaen aton boesaliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Japox ja-aechlisox, me-ama Jeremías, Dios pejprofeta, chajia jʉm-aechpox, jʉm-aech wʉt: “Japi xalaeyaxael treinta platafachan wʉajsliajwa baexfa'san pejsat. Japaplatafachanliajwa judíospaklochow kaenejchaxoelax mosliajwapi jas-omtat kaen aton boesaliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Do jawʉx, japaplatafachantat wʉajsaxaeli baexfa'san pejsat, me-ama Dios chajia jʉm-aech” —aech Jeremías, chajia jʉm-aech wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús wiach wʉt gobernador Pilatoxot, jawʉt japon wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Xamkatlap puexa judíos pejreynam? —aechon. Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan japonan, xam jʉm-amponan —aech Jesús Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdotespaklochow, judíos-ancianosbej, pejme jaxot Jesús tasala wʉt, jawʉt Jesús kaes jʉmnos-el. Asbʉan jʉmch boejlach nuklison. ");
INSERT INTO guoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Samata, Pilato Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Xamkat jʉmtae-emil japi jiw xam tasalapoxliajwa? —aech Pilato Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pe Jesús boejlach nuk. Chinax kaejame jʉmnos-elon. Samata, Pilato xabich nejchaxoelanik. ");
INSERT INTO guoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pilato pejkabʉan, kaewaechfʉl wʉt, Pascuafiesta wʉt, jitapaeipon kaen aton nakolsliajwa, jiw jebatat jiaspon, japon wʉljowspon judíos. ");
INSERT INTO guoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Japamatkoiyantat kaen jiw jebatat jias. Japon xabich judíos matabijtas. Pawʉlon Barrabás. ");
INSERT INTO guoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Puexa judíos natameja wʉt, Pilato wʉajnachaemt wʉt, jʉm-aechon judíosliajwa: —¿Mason atonkat xamal nejxasinkam jiw jebaxot nakolsax tapaeliajwan? ¿Xamalkat nejxasinkam xan nakolsax tapaeliajwan Barrabás? O, ¿Jesús, japon pawʉlpon Cristo? —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato japox jʉm-aech, pajut matabijt xot, judíospaklochow wiat Jesús japonxot, xabich nusasiawal xoti Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato ek wʉtfʉk pejtʉa-ekaxtat naewesliajwa Jesús tasalaspox, Pilato pijow jʉmxato'an. Jʉmxato'an wʉt, jʉm-aechow: “¡Nabej is babijax japon atonliajwa, chinax is-el xoton babijax! Xan xamoejtax wʉt, xabich nosbejchaeminal, nejchaxoelx wʉt japon atonliajwa” —aechow, jʉmxato'an wʉt Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pe sacerdotespaklochow, judíos-ancianosbej, jʉm-aech xabich judíosliajwa: “¡Pilato wʉljoem Barrabás nakolsax tapaeliajwa jiw jebaxot! ¡Pelax Pilato wʉljoem japon to'aliajwa Jesús kematamatlaliajwa cruztat!” —aech paklochow xabich jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Do pejme Pilato wʉajnachaemt wʉt, jʉm-aechon puexa judíosliajwa: —Japi kolenjexot, ¿masonkat xamal nejxasinkam xan nakolsax tapaeliajwan? —aech Pilato. Do jawʉt, puexa judíos jʉm-aech Pilatoliajwa: —¡Barrabás nakolsax tapaem! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Do pejme Pilato wʉajnachaemt wʉt, jʉm-aechon japiliajwa: —¿Achaxkat isaxaelen Jesúsliajwa, japon pawʉlpon Cristo? —aech Pilato judíosliajwa. Do jawʉt, puexa jʉmnot wʉt, jʉm-aechi: —¡Japonlax cruztat kematamatalde! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Do pejme Pilato jʉm-aech japi judíosliajwa: —¿Achababijaxkat Jesús is xan to'aliajwan japon cruztat kematamatlaliajwas? —aech Pilato. Japi nejlasfʉl wʉt, jʉm-aechfʉli: —¡Cruztat kematamatalde! —aechfʉli. ");
INSERT INTO guoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato matabijt japi judíos kaes naewesfʉla-esalpox. Xabich kaes nejlasfʉlbejpi, xabich palala xot. Samata, Pilato pamakan to'a min wʉljaesliajwa. Jawʉt, xapa'an wʉt, Pilato kekakiat puexa judíos pejwʉajnalel. Jawʉt jʉm-aechon: —Ampon aton boesas wʉt, japox wʉajan xan xalaejaxinil. Japox wʉajan xamal xalaelpaxaelam —aech Pilato judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Puexa judíos jʉmnot wʉt, jʉm-aechi: —Diachwʉajnakolax xanal japox wʉajan xalaelpaxaelen, japon aton boesas wʉt. Taxibej xalaelpaxael japox wʉajan —aech judíos. ");
INSERT INTO guoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Do jawʉt, Pilato tapaei Barrabás nakolsliajwa jiw jebaxot. Do jawʉtbej, Pilato keto'a soldaw selsliajwapi Jesús. Selsax ketoet wʉt, Pilato to'a soldaw Jesús kematamatlaliajwas cruztat. ");
INSERT INTO guoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Do jawʉtbej, Pilato pejsoldaw bʉ'follisi Jesús, Pilato pejba poxade. Jaxotde puexa soldaw masajiatlisi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jawʉx Jesús wejoltas sumta-otox. Do jawʉtbej, xajoellisipon pakchowax, me-ama rey naxoelpox, pasoeyax jasox. ");
INSERT INTO guoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xakoeyapi na-e'lʉ matlʉa'sliajwapi Jesús. Jawʉt matlʉa'tlisipon. Chaxdutipon, me-ama rey kilachalapox poklake-elel. Do jawʉx, soldaw brixtat nanuili Jesús pejwʉajnalel taxaxaelaliajwa. Brixtat nanuil wʉt, bʉ'wʉajanpaeipi Jesús. Taxaxaelaxtat jʉm-aechfʉllisi: —¡Moi, judíos pejrey! —aechfʉllisi. ");
INSERT INTO guoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Loeyasbejpon. Me-ama rey kelachalapox, japoxtat Jesús matnaebe'balas. ");
INSERT INTO guoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Do jawʉx, bʉ'wʉajanpaeyax bʉxtoet wʉt, pejme joltlisipox, me-ama rey pijax, jasox. Pejme Jesús xajoels pejsumta-osax, japox Jesús pijaxkolax. Do jawʉt, bʉ'follisipon cruztat kematamatlaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Do jawʉt, soldow bʉ'fol wʉti Jesús nakolaliajwa Jerusalén paklowaxxot, jawʉt xabʉ'kʉlti kaen aton. Japon pawʉl Simón, Cirene paklowaxpijin. Do jawʉt, japon Simón, xato'ason soldaw Jesús pijax cruz xalaeyax. Jesús kaes japox xalaeyaxil, japon mamnika-el xot kastikaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","34","Jesús bʉ'pach mʉaxxot. Japamʉax pawʉl Gólgota. (Japawʉl jʉmchiliajwa: “Matnaethitmʉax” —chiliajwa. Japamʉax, me-ama aton matnaethit wʉt, kabʉan-aechox.) Jaxotde bʉ'pa'a wʉt, soldaw chaxduti Jesús feliajwa vino, xasaxamint tanialtaspot, xabich boejtae-elaliajwa xaeyax. Pe Jesús xapaejla wʉt japavino, fe-elon. ");
INSERT INTO guoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Do jawʉt, Jesús cruztat kematamatlas wʉt, soldaw nakakujt ia'xix, jasi, matabijaliajwa, achan kanaxael kaenanʉla Jesús pejnaxoe. ");
INSERT INTO guoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Do jawʉx, soldaw chalak wesfʉlaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesús pejmatnaetlelse tawlofach lelspox chaduch. Japatawlofachxot lelspox jʉm-aech, ma-aech xot Jesús kematamatlas cruztat. Lelspox jʉm-aech: “Ampon Jesús, judíos pejrey” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jawʉt, Jesús cruztat kematamatlas wʉt, japamʉaxxot kolenje kethakan kaenanʉla cruztat kematamatlasbej. Kaen Jesús pejpoklalel chanuk. Asan Jesús pejsoenalel chanuk. ");
INSERT INTO guoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Asew jiw, jaxot xaxenapi, babejjamechan jʉm-aechi Jesúsliajwa. Matnaexawilt wʉt, jʉm-aechbejpi Jesúsliajwa: —Xam chajia jʉm-am: ‘Xan Dios pejtemploba toesaxaelen. Do jawʉx, tres matkoi wʉt, pejme mat-esaxaelen’ —am xam. ¿Ma-aech xotkat amwʉtjel xam najut nabʉ'we-emil? Xam diachwʉajnakolax Dios paxʉlnam wʉt, ¡ma amwʉt najut baloemk cruzxotsik! —aech xaxenapi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jawʉt sacerdotespaklochow, judíos chanaekabʉanapibej, judíos-ancianosbej, japibej bʉ'wʉajanpaei Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nakaewa najʉm-aechi Jesúsliajwa: —Asew jiw bʉ'wiapon. Pe pajut nabʉ'we-elon. Diachwʉajnakolax ampon Israel tʉajnʉpijiw pejrey wʉt, ¡ma amwʉt nej baloeskon cruzxotsik! Do ja-aech wʉt, ¡xatis naexasisaxaeson! ");
INSERT INTO guoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dios xanaboejtbejpon. Jʉm-aechbejpon: ‘Xan Dios paxʉlnan’ —aechon pajutliajwa. Samata, ¡japon Dios nej bʉ'wes, Dios nejxasinkas wʉt! —na-aechi nakaewaliajwa Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kolenje kethakan, kematamatlaspi cruztat, Jesús sʉapich, japibej jʉm-aech babejjamechan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesús cruztat wʉt, juimt matnoch ek wʉt, jawʉt xabich itkʉa'nik potʉajnʉcha. Tres horas itkʉa'nik. ");
INSERT INTO guoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Do jawʉt, a las tres wʉt, Jesús nejlacha wʉt, jʉm-aechon: “Elí, Elí, ¿lema sabactani?” —aech Jesús. (Japox jʉm-aech wʉt, jʉmchiliajwa hebreojametat: “TajDios, tajDios, ¿ma-aech xotkat tamach nawaeltam?” —chiliajwapox.) ");
INSERT INTO guoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Asew jiw, jaxoti, japox jʉmtaen wʉt, jʉm-aechi: —Japon wʉllalat Elías, Dios pejprofeta —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jawʉtlejen kaen japixot najaet wʉljaesliajwa esponja, xathosliajwa vino xathʉnkpotat. Esponja faen wʉt, xathoti esponja. Do jawʉt, nae-oeftat matakʉpi Jesús suiliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Asew jiwlax jʉm-aech: —¡Mastaem! Taeyaxaes Elías bej fʉloeyaxoekbej japon bʉ'weliajwas —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús pejme nejlakcha wʉt, jawʉt tʉplison. ");
INSERT INTO guoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jawʉt Dios pejtemplobatutat pinabʉ', duchpox batutat, najʉpathiakchakas athʉsik satleldik. Jawʉtbej sat xabich najaet. Pinanʉl ia' tatʉkbej. ");
INSERT INTO guoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jawʉtbej patʉpamʉthanxot pajut nafafa'bala. Do jawʉtbej, chajia tʉpi, majt laelpi ampathatat, japi Dios naexasiti, japi xabich pin-iat mat-ias pejme duilaliajwa ampathatat. ");
INSERT INTO guoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús tʉp wʉt, jawʉx, tres matkoi wʉt, Jesús mat-ech wʉt pejme dukaliajwa, jawʉt japi jiwbej, mat-iaspi, lowpi Jerusalén paklowaxxot. Xabich japapaklowaxpijiw taensi. ");
INSERT INTO guoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Patʉpan Jesús chanuk wʉt cruztat, soldawcapitán, pejsoldaw sʉapich, jaxot weti Jesús, taen wʉti puexa ja-aechpoxan, sat najaesax taen wʉtbejpi, puexa japi soldaw xabich pejlewla. Samata, jawʉt jʉm-aechi: —¡Diachwʉajnakolax ampon aton Dios paxʉlan! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Do jawʉtbej, patʉpan Jesús chanukxot xabich watho' atʉaxach nuili natachaemaliajwapi patʉpan Jesús. Japi watho' chajia nakfʉlaeni Jesús Galilea tʉajnʉxot. Japi watho' kajachawaetbejpi Jesús, nanʉamt wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Japi watho'xot, jaxotbej María. Japow Magdala paklowaxpijow. Jaxotbej asaow, pawʉlpow María. Japow Santiago pen. Japowbej José pen. Japow Zebedeo pijow. ");
INSERT INTO guoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Jesús tʉp wʉt, tuila wʉtlejen, kaen aton pawʉlpon José, japon pat gobernador Pilatoxot. Japon kemaeyan, Arimatea paklowaxpijin. Japonbej naexasit Jesús naewʉajanpoxan. Dolisdo', José pat wʉt Pilatoxot, wʉljowpon fisliajwa patʉpan Jesús mʉthsliajwa. Do jawʉtbej, Pilato to'a soldaw, japi chaxdusliajwapi patʉpan Jesús Joséliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Do jawʉt, José fʉlaech patʉpan Jesús chanukxotde cruztat. Pa'a wʉton, kuton patʉpan Jesús cruzxotsik. José xakoeya patʉpan sábanatat. Japabʉ' chimiabʉ', pajelbʉ'bej. ");
INSERT INTO guoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","José chajia asan aton wekowson mʉaxwʉaj. Japawʉaj José pajutliajwalach, asamatkoi tʉp wʉt japawʉajxot osliajwas. Samata, José japawʉajxot oton patʉpan Jesús. Do jawʉx, ia't pinjit, jajaerat, matariaman japawʉaj fakasliajwa. Do jawʉx, José japox ketoet wʉt, nawiaton. ");
INSERT INTO guoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pe jaxot María, Magdala paklowaxpijow. Jaxotbej asaow María, japow pejwʉlxoelow. Japi koliowje atʉaxach chalak japawʉaj wʉajnalel taeliajwapi patʉpan Jesús cha-ochxot. ");
INSERT INTO guoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kandiawa wʉt, napatamatkoi wʉt, sacerdotespaklochow, fariseosbej, fʉlaech Pilato poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pat wʉti Pilatoxot, jʉm-aechi: —Tajpaklon, Jesús kichachajbapijin. Xanal nejchaxoelx japon jʉm-aechpoxliajwa, laeja wʉtfʉkon. Jawʉt Jesús jʉm-aech: ‘Tʉpx wʉt, Dios namat-esaxael pejme dukaliajwan, tres matkoi wʉt’ —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Samata, ¡soldaw to'im wesfʉlaliajwa tres matkoi japon ochxot! Jachi-emil wʉt, japon pejnachala bej jusaxaesbejpon. Do jawʉx, japi jiw naewʉajnafʉlaxael wʉt, jʉmchisfʉlaxaeli: ‘Japon mat-ech pejme dukaliajwa’ —chisfʉlaxaeli. Ja-aech wʉt, xanalliajwa kaes pejme xabich chaemilaxael. Me-ama majt, jachiyaxil —aech sacerdotespaklochow, fariseosbej, Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Do jawʉt, Pilato jʉm-aech sacerdotespaklochowliajwa, fariseosliajwabej: —¡Ama soldaw! ¡Bʉflaem chiekal wesfʉlaliajwapi patʉpanwʉaj! —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Do jawʉt, paklochow bʉ'follisi soldaw patʉpanwʉaj poxade. Jaxot pat wʉti, xape'ti sello ia't, pinjitxot. (Jasox ispi matabijaliajwa, asan aton japa-ia't matriaman wʉt taeliajwa.) Do jawʉt, soldaw jaxot waelas chamʉthawesfʉlaliajwapi patʉpanwʉaj. ");
INSERT INTO guoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Napatamatkoi toep wʉt, dominkomatkoi wʉt, juimt julan wʉtbej, María, Magdala paklowaxpijow, asaow Maríabej, kaxa fʉlaechlisi patʉpanwʉaj taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Japi watho' fol wʉt, chalechkal sat xabich najaet. Jawʉt Dios pej-ángel fʉloek. Pask wʉt patʉpanwʉajxotsik, japa-ia't, pinjit, matriamanlison kaelel. Do jawʉt, Dios pej-ángel ek japa-ia'tmatwʉajtat. ");
INSERT INTO guoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dios pej-ángel pona xabich nakthian. Me-ama chamax kaliaf wʉt, jakaliaf-aechon. Sumta-otox xabich papoeikolax. ");
INSERT INTO guoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldaw, wesfʉlpi patʉpanwʉaj, taen wʉti Dios pej-ángel, japi soldaw xabich tathʉlal pejlewt. Do jawʉt, satat oeljabapi. Me-ama tʉp wʉt, ja-aechi. ");
INSERT INTO guoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Do jawʉt, ángel jʉm-aech japi watho'liajwa: —¡Nabej nejlewle'! Xan matabijtax xamal wʉlwekam taeliajwam patʉpan Jesús, kematamatlaspon cruztat tʉpaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amxot ajillison. Japon mat-echlison pejme dukaliajwa, me-ama chajia jʉm-aechon. ¡Xabʉa'din xamal najut taeliajwam ochxoton! ");
INSERT INTO guoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tae-emil wʉt patʉpan, ¡xamal xabʉa'de japon pejnachala poxade japi chapaeliajwam! ¡Jʉm-amo Jesús pejnachala: ‘Cruztat tʉpon mat-echlison. Amwʉtjel pejme duklison. Xamal wʉajna japon wʉajnaxaech Galilea tʉajnʉxotde. Jaxotde Jesús taeyaxaelam’ —amo pejnachala! Japox xan jʉmchiliajwan Dios nabʉxto'a xamalliajwa —aech ángel japi watho'liajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Do jawʉt, japi watho' bichakal fʉlaech Jesús pejnachala poxade, Jesúsliajwa ja-aechpox chapaeliajwapi. Japi watho' xabich beljow. Pe jawʉtbej, xabich nejchachaemili. ");
INSERT INTO guoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","10","Nʉamtat fol wʉtfʉki, Jesús chalechkal natulaelt japi watho' pejwʉajnalel. Jesús moi-aech japi watho'liajwa. Do jawʉt, japi watho' mox soepa Jesúsxot. Brixtat nuili Jesús pejwʉajnalel, xabich sitaen xoti. Jesús thijaeltas wʉt, jʉm-aechon japi watho'liajwa: —¡Xabʉa'de tajnachala poxade chapaeliajwam xan nataenampox! ¡Tajnachala jʉm-amde Galilea tʉajnʉ poxade fʉlaeliajwapi! Jaxotde xan nataeyaxaeli —aech Jesús, japi watho' bʉxto'a wʉton. ");
INSERT INTO guoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Watho' fʉlaech wʉtfʉk, do jawʉtbej, soldaw weti patʉpanwʉaj, asew japixot soldaw, fʉlaechbej Jerusalén paklowax poxade. Jaxotde pa'a wʉt, japi soldaw chapaeilisi sacerdotespaklochowxot puexa japi taenpoxan, jʉmtaenpoxanbej, Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Do jawʉt, paklochow fʉlaech judíos-ancianos poxade nospaeliajwa, japi sʉapich, kaenejchaxoelaxliajwa japoxliajwa. Do jawʉx, japi paklochow moti xabich plata soldaw kichachajbaliajwa jiw. ");
INSERT INTO guoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Paklochow jʉm-aech soldawliajwa: —¡Jʉm-amo jiw: ‘Madoi, xanal moejtax wʉt, Jesús pejnachala fʉlaen patʉpan natkowaliajwa. Japox ja-aech xanalliajwa’ —amo puexa jiwliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilato japox wʉltaen wʉt, xanal nospaeyaxaelen, Pilato sʉapich. Ja-aech wʉt, xamal bʉ'wʉajan jilaxaelam —aech paklochow soldawliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Do jawʉt, soldaw ow-aechlisi japoxliajwa. Samata, kenoti plata. Jawʉt japi soldaw chapaefʉl, me-ama paklochow bʉxto'as. Samata, judíos xabich chapaefʉl japawʉajan potʉajnʉcha. Amwʉtjelbej japawʉajan nakiowa chapaefʉlfʉki. ");
INSERT INTO guoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Do jawʉx, xanal onsan pejnachalwan fʉlaechx Galilea tʉajnʉ poxade. Jaxotde pa'ax wʉt, fʉlaechx pinamʉax poxade, Jesús nato'amʉax poxade. ");
INSERT INTO guoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jaxotde xanal Jesús taenx. Do jawʉt, brixtat nuilx japon pejwʉajnalel, xabich sitaenx xot. Xanalxot asew jiw chiekal naexasis-eli, Jesús tʉp wʉt mat-echpox pejme dukaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Do jawʉtbej, Jesús mox soepan xanalxot. Jʉm-aechon: —Taj-ax Dios natapaei puexa jiw tato'laliajwan, ampathatpijiw, athʉxotsepibej. ");
INSERT INTO guoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Samata, ¡xamal potʉajnʉcha jiw naewʉajnafʉlde! Naexasit wʉti taj-ax Dios, xan tajwʉajan naexasit wʉtbejpi, jawʉt japi jiw bautisaxaelam taj-ax Dios pijaxtat, xan Dios paxʉlnan pijaxtatbej, Espíritu Santo pijaxtatbej. ");
INSERT INTO guoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","¡Xamal naewʉajande asew jiw naexasisliajwa puexa xan tato'laxpoxan xamalliajwa! Xan diachwʉajnakolax xamalxotaxaelen pomatkoicha ampathatxot. Hasta ampathat toep wʉt, xan nakiowa xamalxotaxaelen —aech Jesús xanal pejnachalanliajwa.");
INSERT INTO guoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Chimiawʉajan, Jesucristo pejwʉajan, tʉadut wʉt, ma-aech. Japon pajut Dios paxʉlan. Xan Marcos lelx ampafʉt jiw chiekal matabijaliajwa japawʉajan. ");
INSERT INTO guoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profeta Isaías lel Dios jʉm-aechpox Jesucristoliajwa, jʉm-aech wʉton: “Wʉa, xam wʉajna xan to'axaelen tajprofeta, japon jiw naewʉajnaliajwa tajjamechan, xam naexasisliajwapi, patam wʉt jaxot” —aech Dios, chajia jʉm-aech wʉt Jesucristoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Isaías chajia lelpox jʉm-aech Juan, jiw bautisanliajwa: “Aton pajilaxtat nejlat wʉt, jʉmchiyaxaelon jiwliajwa: ‘¡Thilde wajpaklokolan pasax wʉajna! Samata, ¡kofim babijaxan isampoxan! Me-ama jiw wʉajna nʉamt chiekal chaemt wʉt paklon pasliajwa, ¡xamal ja-amde nejnejchaxoelaxan! ¡Isfʉlde Dios nejxasinkpoxan!’ —chiyaxaelon pajilaxtat, nejlat wʉt jiwliajwa” —aech Isaías chajia lelpox Juan, jiw bautisanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Do baxael, Isaías chajia jʉm-aechpox, ja-aechlisox japon atonliajwa. Japon aton patlison. Japon pawʉl Juan. Do jawʉt, Juan jiw bautisafʉl pajilaxxot. Naewʉajanbejpon. Jaxotde xabich jiw fʉlaen naewesliajwas Juan naewʉajanpox. ");
INSERT INTO guoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Xabich Judea tʉajnʉpijiw fʉlaen, Jerusalén paklowaxpijiwbej. Jawʉt Juan jʉm-aechfʉl japi jiwliajwa: “¡Kofim babijaxan isampoxan! ¡Isfʉlde Dios nejxasinkpoxan! Ja-am wʉt, Dios beltaeyaxael xamal babijaxan isampoxanliajwa. Do ja-aech wʉt, xamal bautisaxaelen” —aech Juan jiwliajwa. Samata, japamatkoiyan jiw jalpaei babijaxan ispoxanliajwa, Dios beltaeliajwas babijaxan ispoxanliajwa. Do jawʉt, Juan japi jiw bautisa Jordánlajtat. ");
INSERT INTO guoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan pijax naxoelax isas camellolatat. Pejcinturónmʉat pabʉ'kal. Pejnaxaeyaxan, me-ama sui'. Afpon miel. ");
INSERT INTO guoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan naewʉajan wʉt, jʉm-aechon: “Mox pawʉajna kaen aton fʉlaeliajwadin. Japon kaes pejme paklonaxael. Me-ama xan, jachiyaxilon. Xan omjinil japon pejkajachawaesnanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Diachwʉajnakolax xan jiw bautisax mintat, japi kofa wʉt babijaxan ispoxan. Pelax pasaxaelpon, japon kaes paklonaxael. Samata, to'axaelon Espíritu Santo jiw kajachawaesfʉlaliajwas” —aech Juan Cristoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Japamatkoiyan Jesús nakolt Nazaret paklowaxxot, Galilea tʉajnʉxot. Fʉlaekon Juan poxadik. Jawʉt Juan bautisa Jesús Jordánlajtat. ");
INSERT INTO guoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús jul wʉt mintat, jawʉt taenon athʉ fafachpox. Jawʉt Espíritu Santo fʉloek a-utat japon pejmatwʉajasik. Me-ama a-ut, kabʉan-aech Espíritu Santo. ");
INSERT INTO guoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Do jawʉt, Jesús jʉmtaenbej athʉsik jʉm-aechsikpox, Dios jʉm-aechsik wʉt ampox: “Xam taxʉlnam, xabich nejxasinkaxponam. Xabich nejchachaemlax xamliajwa” —aech wʉt pax Dios Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Do jawʉx, Jesús bʉ'fos Espíritu Santo pajilax poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pajilaxxot wʉt, namanlison cuarenta matkoiyan. Jaxot pejmachoefkal maenk. Do jawʉt, deppaklon pat. Japon pawʉl Satanás. Japon xapaeja Jesús babijax isliajwa. Do jawʉx, Satanás chijia Jesúsxot. Do jawʉtbej, Dios pej-ángeles fʉloek japi kajachawaesliajwa Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Asamatkoi Herodes, Galilea tʉajnʉpijiw tato'lan, to'apon pejsoldaw Juan jaelsliajwas, jiw jebatat jeliajwasbejpon. Do jawʉx, Jesús fʉlaech Galilea tʉajnʉ poxade. Jaxotde pa'a wʉt, jiw naewʉajanlison chimiawʉajan, Dios tato'laxaelpox pejjiw. ");
INSERT INTO guoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús jʉm-aech ampox jiwliajwa: “Patlisox japamatkoiyan, wʉajnawesfʉlasmatkoiyan Dios tato'laliajwa pejjiw. Samata, ¡kofim babijaxan isampoxan! ¡Dios naexasisfʉlde japon xanaboejaliajwam! Patlisox chimiawʉajan xamal naexasisfʉlaliajwam” —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galilea pukababʉ'tat laeja wʉt, kolenje nabaxisiw taenpon. Kaen pawʉl Simón. Asan pawʉl Andrés. Japon Simón pakoewan. Japi taraya xawaejaba pukatat. ");
INSERT INTO guoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús jʉm-aech: —¡Xan nakfʉlaem! Xamal chiekal matabijam nabaxisaxan. Jasoxtatbej xamal chanaekabʉanaxaelen jiw chiekal naewʉajnaliajwam japi tajnachalaliajwa, Dios pejjiwaliajwabejpi —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Do jawʉt, pejew taraya waelapi asew jiwtat, nakfʉlaeliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús kaes fʉlaech wʉt, asew kolenje, nabaxisiw, taenpon. Kaen pawʉl Santiago. Asan pawʉl Juan. Japon Santiago pakoewan. Falkamtat pejew taraya chaemti. Japi pax pawʉl Zebedeo. ");
INSERT INTO guoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Do jawʉt, Jesús japi la nakfʉlaeliajwas. Do jawʉt, nakfollisi Jesús. Pax Zebedeo waelti falkamtat, kajachawaeti sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Do jawʉx, Jesús, pejnachala sʉapich, pat Capernaum paklowaxxot. Napatamatkoi wʉt, lechi judíos naewʉajnaba poxade. Do jaxot Jesús tʉadut jiw naewʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chiekal naewʉajanpon Dios pejjamechan. Me-ama judíos chanaekabʉanapi naewʉajan wʉt, jachi-elon. Samata, japi jiw xabich nejchaxoelachalak, Jesús naewʉajan xot Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Judíos naewʉajnabaxot, aton nuk. Japon dep webaes pejmatpʉatxot. Do jawʉt, aton pejkaechatat dep nejlat wʉt, jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, Nazaret paklowaxpijnam, ¿xam achaxasiamkat xanalxot? ¿Xamkat fʉlaeman puexa xanal natoesliajwam? Xam matabijtax. Xam Dios paxʉlnam, xabich pachaemamponam —aech dep, nejlat wʉt aton pejkaechatat. ");
INSERT INTO guoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Do jawʉt, Jesús jʉm-aech nejthʉ'axtat depliajwa: —¡Boejlachde! ¡Xam nakolde japon aton pejmatpʉatxot! —aech Jesús depliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Do jawʉt, japon aton xabich tathʉlal dep pijaxtat. Dep nejlakcha wʉt, japon aton pejmatpʉatxot nakoltlison. ");
INSERT INTO guoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jawʉt puexa jiw xabich belwana, taen wʉti japox, Jesús dep to'apox. Nakaewa nawʉajnachaemsnapi: —¿Ma-aech xotkat dep nakolt, to'a wʉton? ¿Achaxkat ampox, pajelnaewʉajnax? Ampon aton, me-ama Dios to'aspon wʉt, ja-aechon. Ja-aech wʉt, dep nakolt —na-aechna jiw nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Do jawʉx, Galilea tʉajnʉpijiw potʉajnʉcha kamtalejen wʉltaenapi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús nakolt wʉt judíos naewʉajnabaxot, Jesús fʉlaech asaba poxade Santiago, Juan sʉapich. Japaba Simón pejba, Andrés sʉapich. Japabaxot pat wʉti, lowpi. ");
INSERT INTO guoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jaxot Simón paem bʉ'xaenk Jesús pejpasax wʉajna. Okow camatat. Xabich bʉ'tʉajnikow. Jawʉt asew japixot chapaeipi Jesús, Simón paem bʉ'xaenkpox. ");
INSERT INTO guoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Samata, Jesús mox soepan japowxot. Kefit wʉt, japow mat-eton. Jawʉt kamta japow chiekal boejthʉls. Bʉ'tʉajax wejisalbejpow. Do jawʉt, japow pajut naxaeyaxan athuk Jesúsliajwa, japon pejnachalaliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Tuila wʉt, itkʉatnik wʉtbej, Capernaum paklowaxpijiw bafafaxot pati, Jesús dukbatatxot. Asew japixot bʉ'pat xabich bʉ'xaeya, dep webaespibej pejmatpʉatantat. ");
INSERT INTO guoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Do jawʉt, Jesús xabich bʉ'xaeya boejthʉt, nejmachwaxaetat bʉ'xaenkpi. Xabich dep nakolax to'abejpon, jiw pejmatpʉatanxot bapi. Ja-aech wʉt, Jesús tapae-el dep naksiyaliajwa, japi chiekal matabija xot japon Cristo, Dios to'aspon. ");
INSERT INTO guoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Do kandiawasap wʉt, nalianawʉajna wʉt, Jesús nathikt wʉt, nakoltlison japabaxot. Fʉlaechon pajilax poxade, tamach pejlel Dios kawʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Do jawʉt, baxael, Simón, pejnachala sʉapich, jalweki Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Faen wʉt, jʉm-aechi Jesúsliajwa: —Puexa jiw xam xabich wʉlwek —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús jʉmnot wʉt, jʉm-aechon: —Chajias asapaklowaxan mox poxade. Japapaklowaxanpijiw naewʉajnaxaelen Dios pejjamechan. Samata, xan fʉloekx —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Do jawʉt, Jesús nanʉamt puexa Galilea tʉajnʉxot. Kaenanʉla judíos pejnaewʉajnabachantat, Jesús naewʉajnafʉl judíos. Jiw dep webaespibej, dep nakolax to'apon japi jiw pejmatpʉatanxot. ");
INSERT INTO guoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kaen, bʉ'xaenkon leprawaxaetat, fʉlaenon Jesúsleldin. Pat wʉton, Jesús pejwʉajnalel brixtat nukon, xabich sitaen xoton. Do jawʉt, jʉm-aechon Jesús jʉmtaeliajwa: —Xan matabijtax xam naboejthʉsaxaelampox. Xan naboejthʉsasiam wʉt, ¡naboejthʉ'e! —aech leprawaxaetat bʉ'xaenkpon. ");
INSERT INTO guoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús xabich beltaen xot, bʉ'xaeyan pejke-etat bʉ'jachapon. Do jawʉt, Jesús jʉm-aech: —Xam boejthʉsaxaelen. Samata, malis chiekal pachaemam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Do jawʉt, kamta chiekal boejthʉlson leprawaxae. Pejbʉ't chiekal wepachaemslison. ");
INSERT INTO guoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesús to'a wʉt, jʉm-aechon nejthʉ'axtat: —¡Asew jiw nabej chapae' xam boejthʉtxpox! ¡Xabʉa'delax sacerdote poxade, japon xam bʉ'taeliajwa boejthʉlpox leprawaxae! Do jawʉx, ¡chaxdu'e, me-ama Moisés chajia lelpox jʉm-aech Dios chaxdusliajwam ofrenda, leprawaxae xam chiekal boejthʉl xot! Jasoxtat xam jiw matabijaxael chiekal boejthʉlpox japawaxae —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Do jawʉt, leprawaxae boejthʉlspon fʉlaechlison. Pe owchi-elon Jesús jʉm-aechpox. Japon aton chapaeflax tʉaduton puexa jiw jʉmtaeliajwa Jesús pejwʉajan. Samata, Jesús tulaela pasaxil japapaklowaxanxot. Do jawʉt, Jesús atʉaj naejiat japapaklowaxan. Ja-aech wʉt, popaklowaxanpijiw fʉlaech Jesús poxade, taeliajwapi japon. ");
INSERT INTO guoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Asamatkoiyanwʉx, Jesús nawiat Capernaum paklowaxxotdin. Jawʉt japapaklowaxpijiw nakaewa najʉm-aech Jesúsliajwa: “Jesús kaweta naman batat” —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Samata, xabich jiw wʉlʉk japabatat. Ba xajʉpa-el, xabich jiw wʉlʉk xotbej japabafafatat. Asew japixot atʉaxach bafafaxot nuilje. Do jawʉt, Jesús naewʉajan Dios pejjamechan puexa japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Do jawʉt, kaen aton, laejaxilon, chaxfoson cuatro poejiw, Jesús jiw naewʉajan poxadin. Japi fʉlaen Jesús taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","5","Cuatro poejiw mox pasaxil Jesúsxot, xabich jiw wʉajna ba wʉlʉk xot. Samata, ba matwʉajase chaxjulachi, me-ama choeranae poxase. Jaxotse bamatwʉaj tʉkapi pinjiyax laejaxilon chakakofnaliajwadik Jesús poxadik. Chakakofan wʉt, nejchaxoeli: “Diachwʉajnakolax Jesús boejthʉsaxaes ampon aton chiekal laejaliajwa” —aech cuatro poejiw, nejchaxoel wʉt. Jesús chajia matabijt japi nejchaxoelox. Samata, jʉm-aechon laejaxilon jʉmtaeliajwas: —Wʉa, xam beltaenx babijaxan chajia isampoxanliajwa, —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kaesʉapich judíos chanaekabʉanapi jaxot chalak. Jʉmtaen wʉti Jesús jʉm-aechpox, japi nejchaxoel: ");
INSERT INTO guoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ma-aech xotkat Jesús Dios sitae-el? Japon naksiya xatis jʉmchiyaxisalpox. Nejmachjiw japox jʉmchiyaxil. Jasox naksiya wʉti, is babijax Diosliajwa. Kaen Dios xajʉp beltaeliajwa jiw babijaxan ispoxanliajwa” —aech judíos chanaekabʉanapi, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Do jawʉt, Jesús chiekal matabijt japi nejchaxoelox. Samata, jʉm-aechon japiliajwa: —¿Ma-aech xotkat xamal jasox nejchaxoelam xanliajwa? ");
INSERT INTO guoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kaes pejme tampa xan jʉmchiliajwan laejaxilponliajwa: ‘Xam beltaenx babijaxan isampoxanliajwa’ —chiliajwan. Pe ja-an wʉt, jiw xan namatabijaxil xan puexa jiw pakoewkolnanponan. Jʉm-an wʉtlax nabejkan jʉmtaeliajwa: ‘¡Nande! ¡Laejim!’ —an wʉt, japox jʉm-an wʉt, jiw diachwʉajnakolax xan namatabijaxael xan puexa jiw pakoewkolnanponan. ");
INSERT INTO guoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Xan ispoxantat xamal matabijaxaelam, diachwʉajnakolax, xan puexa jiw pakoewkolnanponan, xajʉpx athʉxotse, ampathatatbej, jiw beltaeliajwan babijaxan ispoxanliajwa —aech Jesús judíos chanaekabʉanapiliajwa. Do jawʉt, Jesús jʉm-aech laejaxilpon jʉmtaeliajwa: ");
INSERT INTO guoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Xam jʉm-an: ‘¡Nande! ¡Sumta-okampox fi'e! ¡Xalaemchbej nejba poxade!’ —an xan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Do jawʉt, laejaxilon nant wʉt, sumta-okpox fit wʉtbej, chajialison. Jawʉt xabich jiw taenspon, fʉlaech wʉt tathoetade. Samata, puexa jiw natachaemason. Nakaewa najʉm-aechnapi: —Dios, japon kaen, xabich mamnik. Majt chinax jasox tae-esal, me-ama ampox. Amwʉtjel jasox taens —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Do jawʉx, Jesús fʉlaech wʉt pejme pukababʉ' poxade, jawʉt xabich jiw pat Jesúsxot. Do jaxot jiw naewʉajanlison. ");
INSERT INTO guoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Do jawʉx, Jesús naewʉajanpox bʉxtoet wʉt, fʉlaech wʉton, taenon Leví. Japon asawʉl Mateo. Leví pax pawʉl Alfeo. Leví impuesto mat-omwʉljoen Roma gobiernoliajwa. Leví ek impuesto mat-omwʉljoebatat. Jaxot Jesús jʉm-aech: —¡Xan nakfʉlaem tajnachalnamliajwa! —aech Jesús. Do jawʉt, Leví nant wʉt, nakfollison Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Xabich jiw, impuesto mat-omwʉljoew, asewbej naexasis-eli Moisés chajia lelpox, japi jiw nakfoli Jesús. Asamatkoi Jesús, pejnachala sʉapich, xael wʉti Leví pejbatat, xabich impuesto mat-omwʉljoew, asewbej naexasis-eli Moisés chajia lelpox, japibej jaxot naxael. ");
INSERT INTO guoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Judíos chanaekabʉanapixot, japi fariseos. Japi taen, Jesús xael wʉt, impuesto mat-omwʉljoew sʉapich, asew jiw sʉapichbej, japi naexasis-eli Moisés chajia lelpox. Do jawʉt, japi fariseos wʉajnachaemt wʉt, jʉm-aechi Jesús pejnachalaliajwa: —¿Ma-aech xotkat Jesús xael impuesto mat-omwʉljoew sʉapich, asew jiw babejchow sʉapichbej? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús japox jʉmtaen wʉt, jʉm-aechon fariseosliajwa: —Jiw woen woe-el nejchaempi, bʉ'xaenka-el xoti. Fʉlaenpon woeliajwa bʉ'xaeya. Ja-anlap-is xan. Xan fʉlae-enil tadʉsliajwan pachaempi. Xanlax fʉlaenx tadʉsliajwan jiw babejchow, japi kofaliajwabej padujnejchaxoelaxan, naexasisliajwabejpi Dios —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Asamatkoi Juan, jiw bautisan, pejnachala naxae-el, piach Dios kawʉajnaliajwa wʉti. Fariseos pejnachalabej naxae-el, piach Dios kawʉajnaliajwa wʉti. Do jawʉt, asew jiw japixot pat Jesúsxot. Pat wʉt, jʉm-aechi Jesús jʉmtaeliajwa: —Juan pejnachala, fariseos pejnachalabej, naxae-el, piach Dios kawʉajnaliajwa wʉt. ¿Ma-aech xotkat nejnachala naxaelkatlax, piach Dios kawʉajnaliajwa wʉt? —aechi Jesús jʉmtaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús wʉajantat jʉmnot wʉt, jʉm-aechon: —Aton pawis fit wʉt, fiesta is wʉtbejpi, puexa jiw chiekal naxaeyaxael japonxot. Japi xabich nejchachaemlaxael, pajelnakjiyan dukaxael xotfʉk jaxot. ");
INSERT INTO guoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Asamatkoi japon asew jiw fe'naxaes wʉt, do jawʉt, tadʉchpi naxaeyaxil kaematkoiyan sʉapich, xabich nejxaejwaxaes xoti. Asamatkoi japox jachiyaxaesbej tajnachalaliajwa. Samata, tajnachala naxaeyaxil kaematkoiyan sʉapich, nejxaejwaxaes xoti, xan japixot ajilaxaelen xot, asew jiw xan nabʉ'fol wʉt —aech Jesús wʉajantat wʉajnachaemtaspiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesús pejme jʉm-aech wʉajantat jiw nakiowa naexasisfʉlpiliajwa pejwʉajnapijiw pejkabʉananpox: —Pawis pejyiaf wexaxarwas wʉt, xape'tow nakaepadujbʉ'ch. Xape's-elow pajelbʉ'ch. Pajelbʉ'ch xape't wʉt, itkiat wʉtbej, mamo'al wʉt, kaes itkialaxael. Itkial wʉt, padujyiaf kaes pinjiyax thialfalaxael xape'txotow. ");
INSERT INTO guoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jiw wʉlui-elbej pajelvino, padujchoxantat, isaspox choefbʉ'tat choxaliajwa. Jiw wʉlʉ wʉt pajelvino, choxa chathialfalaxael, pajelvino xabich xot pafak. Ja-aech wʉt, nafo'axael vino, choxabej. Samata, jiw wʉlʉ pajelvino pajelchoxantat —aech Jesús, naewʉajan wʉt jiw wʉajantat. ");
INSERT INTO guoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Asamatkoi, napatamatkoi wʉt, Jesús, pejnachala sʉapich, fol trigolulanxot. Pejnachala fol wʉt, trigo jolbalapi xaelpaliajwa, litaxaela xoti. ");
INSERT INTO guoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kaesʉapichbej fariseos jaxot nakfol. Do jawʉt, japi jʉm-aech Jesúsliajwa: —¿Ma-aech xotkat nejnachala japox is, xatis judíos naktapae-elpoxtat, napatamatkoitat wʉt? —aech fariseos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús jʉmnot wʉt, jʉm-aechon: —Xamal matabijam, wajwʉajnapijin, waj-am rey David, ispox chajiakolaxtat, xabich litaxaela wʉton, pejsoldaw sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jawʉt David lech Dios pejba, xananʉamsba. Japabatat wʉajna pan oel mesamatwʉajtat. Japapan Dios pej-ofrenda. Do jawʉt, rey David japapan xael. Do jawʉtbej, chaxduwpon pejsoldaw, japi xaeliajwa japapan. Japamatkoitat Dios pejbatat sacerdotespaklokolan, japon pawʉlpon Abiatar, Dios pejtabernáculobatatpon. Moisés chajia lelpox jʉm-aech: “Japapan koew sacerdotes xaeliajwa, nabisti Dios pejbatat. Asew jiw xaeyaxil japapan” —aech Moisés chajia lelpox —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús pejme jʉm-aech: —Jiw wewe'pas napatamatkoi. Samata, Dios is napatamatkoi jiw damlathʉlaliajwa. Dios is wʉt jiw, is-el asbʉan jʉmch jiw sitaeliajwa napatamatkoi. ");
INSERT INTO guoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Samata, xan puexa jiw pakoewkolnan, xajʉpx jʉmchiliajwan jiw isaxaelpox napatamatkoitat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Asamatkoi Jesús lech judíos naewʉajnaba poxade. Japabatat wʉajna ek kemamlan. ");
INSERT INTO guoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseosbej jaxot, japi natachaema taeliajwapi Jesús, kemamlan boejthʉt wʉt napatamatkoitat. Japi tasalaliajwapi Jesús, japon is wʉt asax. ");
INSERT INTO guoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Do jawʉt, Jesús jʉm-aech kemamlanliajwa: —¡Nande! ¡Jiw pejwʉajnalel nukde! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jawʉt, Jesús jiw wʉajnachaemt wʉt, jʉm-aechon: —¿Achaxkat jʉm-aech Moisés chajia lelpox? ¿Achaxkat Dios naktapaei isliajwas napatamatkoitat? ¿Naktapaeikat isliajwas pachaempox? O, ¿isaxaeskat babijax? ¿Naktapaeikat boejthʉsliajwas bʉ'xaeyan? O, ¿boesaxaeskat japon aton? —aech Jesús. Do jawʉt, puexa jiw boejlach nuil. Jʉmnos-elipon. ");
INSERT INTO guoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús jiw masajiachpi. Ulanatachaemton, japi jiw matnaetink xoti matabijaliajwa. Nejxaejwasbejpon, japi chiekal matabija-el xot. Do jawʉt, Jesús jʉm-aech kemamlanliajwa: —¡Keba'de! —aechon. Keba't wʉt, pejke-e chiekal wepachaemslison. ");
INSERT INTO guoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Do jawʉt, fariseos japox taen wʉt, jaxot nakolapi. Baxael, natamejapi kaeyaxtat nospaeliajwapi, Herodes pejnachala sʉapich, boesaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesús fʉlaech, pejnachala sʉapich, Galilea puka poxade. Xabich jiw, Galilea tʉajnʉpijiw, wʉchakal fʉlaen. Wʉchakal fʉlaenbej Judea tʉajnʉpijiw, Jerusalén paklowaxpijiwbej, Idumea tʉajnʉpijiwbej, Jordánlajt wesklelpijiwbej, Tiro paklowaxpijiwbej, Sidón paklowaxpijiwbej. Puexa japi fʉlaen, wʉltaen wʉti Jesús ispoxanliajwa jiwliajwa Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jaxot Jesús pukababʉ'tat jiw naewʉajan. Puexa jiw, bʉ'xaenki, Jesúslel fijabas, xabich asew japixot boejthʉt xoton. Japi bʉ'xaeya xabich jachasiapi Jesús. Jesús xabich jiw taen wʉt, pejnachala to'apon falkam wʉljaesliajwa, japon puka pamaklel chadukaliajwa falkamtat, xabich jiw tabe'nasamatas. ");
INSERT INTO guoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jiw dep webaesi pejmatpʉatanxot, japi Jesús taen wʉt, brixtat nuili japon pejwʉajnalel. Dep nejla'bala wʉt, jʉm-aechbalapi jiw pejkaechantat: —Xam diachwʉajnakolax Dios paxʉlnam —aechbala dep jiw pejkaechantat. ");
INSERT INTO guoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jawʉt Jesús nejthʉ'axtat jʉm-aechon depliajwa: —¡Nabej jʉm-aeche' xan Cristowanponan! —aech Jesús depliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Do jawʉx, Jesús pinamʉax julach. Jaxot Jesús pejnachala la julaliajwase, makanochpikal. Natameja wʉt japonxot, Jesús wʉlduw asew japixot apóstoles. Japi puexa, docepi, japi chalaliajwa Jesús. Jesús japi tato'al jiw naewʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesús chaxdutbej Dios pejpamamax apóstolesliajwa, dep nakolax to'aliajwapi, jiw pejmatpʉatanxot webaespi. ");
INSERT INTO guoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Doce poejiw makanochpi, japi kaenanʉla pejwʉlan. Kaen pawʉl Simón. Jesús japon wʉlduw Pedrowʉltat. ");
INSERT INTO guoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Asan pawʉl Santiago. Asan pawʉl Juan. Japon Santiago pakoewan. Japi kolenje Zebedeo paxi. Jesús asawʉltat wʉlduw japi kolenje pejnachalan, Boanergeswʉltat. (Japawʉl jʉmchiliajwa: “Chamax Paxi” —chiliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Asan pawʉl Andrés. Asan pawʉl Felipe. Asan pawʉl Bartolomé. Asan pawʉl Mateo. Asan pawʉl Tomás. Asan pawʉl Santiago. Japon Alfeo paxʉlan. Asan pawʉl Tadeo. Asan pawʉl Simón. Japon majt asamʉtpijin, celotemʉtpijin. ");
INSERT INTO guoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Asan pawʉl Judas Iscariote. Japonlap asamatkoi Jesús wiasaxael padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Do jawʉx, Jesús ba lech wʉt, jawʉtbej, xabich jiw papasfʉl japabaxot. Samata, Jesús, pejnachala sʉapich, xaeyaxil. ");
INSERT INTO guoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús pakoew, pen sʉapich, wʉltaen wʉti Jesús ispoxanliajwa, fʉlaeni Jesús poxadin, asalel bʉflaeliajwapi Jesús. Japi nejchaxoel wʉt, jʉm-aechi Jesúsliajwa: “Jesús na-acha” —aechi, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Do jawʉt, judíos chanaekabʉanapi fʉlaen Jerusalén paklowaxxotdin. Japibej jʉm-aech: “Jesús to'a wʉt dep nakolaliajwa jiw pejmatpʉatanxot, to'apon Beelzebú pejpamamaxtat” —aechi Jesúsliajwa. Satanás asawʉl Beelzebú. ");
INSERT INTO guoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús la judíos chanaekabʉanapi jʉmchiliajwapon japi. Do japi pat wʉt, jʉm-aechon: “Satanás, dep pejpaklon, wepachaemaxisal dep to'aliajwapon, dep nakolaliajwa jiw pejmatpʉatanxot. ");
INSERT INTO guoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kaetʉajnʉpijiw nadiajkaxael wʉt nakaewa nabeliajwa, japi natoesaxael nabeyaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaebapijiw nadiajkaxael wʉt nakaewa nabeliajwa, japibej natoesaxael nabeyaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jachiyaxaellap-is Satanás, pejjiw sʉapich, nadiajkaxael wʉt nakaewa nabeliajwa. Japi natoesaxael nabeyaxtat. Ja-aech wʉt, Satanás toepaxael” —aech Jesús judíos chanaekabʉanapiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jesús pejme jʉm-aech: “Kaen natkowasia wʉt asabatat, japon leyaxil, bapijin wʉajna wʉt batat, japon mamnik wʉtbej. Majt bapijin mʉatat kuiyaxaeson. Do ja-aech wʉt, bapijin pejew nosaxael kethakan. ");
INSERT INTO guoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Diachwʉajnakolax xan jʉm-an. Dios xajʉp beltaeliajwa, jiw jʉm-aech wʉt babejjamechan Diosliajwa. Jiw babijaxan ispi, japi Dios beltaeyaxaesbej. ");
INSERT INTO guoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pelax jiw jʉm-aech wʉt babejjamechan Espíritu Santoliajwa, ja-aech wʉt, Dios beltaeyaxil japi jiw. Japi pomatkoicha kaelel pejbʉ'wʉajnaxael Diosliajwa” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús japox jʉm-aech judíos chanaekabʉanapi, jʉm-aech xot: “Jesús webaes dep pejmatpʉatxot” —aech xoti. ");
INSERT INTO guoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Do jawʉx, Jesús pen, japon pakoewbej, pati Jesús jiw naewʉajanxot. Jaxot pat wʉt, nuili tathoetlel. Do jawʉt, kaen aton to'api, jʉmchiliajwapon Jesús, Jesús nakolsliajwa tathoetade. ");
INSERT INTO guoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Xabich jiw Jesús masajiach. Do jawʉt, asew japixot jʉm-aech: —Jiw chanaekabʉanan, nej-en, nakoew sʉapich, ba tathoetlel nuil. Xam wʉlweki —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Do jawʉt, Jesús jʉm-aech: —¿Achewkat, me-ama taj-en, takoewbej? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Do jawʉt, Jesús natachaemt wʉt, jʉm-aechon masajiachpiliajwa: —Xamal tajjiwam, ¡xamallap, me-ama taj-enjiwam, takoewjiwambej! ");
INSERT INTO guoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xamal isfʉlam wʉt Dios nejxasinkpoxan, ja-am wʉt, me-ama takoewam, me-ama taj-enambej —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Asamatkoi Jesús tʉadut jiw naewʉajnaliajwa pukababʉ'tat. Do jawʉt, xabich jiw papasfʉl japonxot. Samata, falkam julon ekaliajwa japafalkamtat. Jasoxtat chadukon jiw naewʉajnaliajwa. Japi jiw pʉtat nuil. ");
INSERT INTO guoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesús xabich wʉajantat naewʉajan jiw chiekal naewʉajnaliajwapon. Do jawʉt, naewʉajan wʉt, jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“¡Chiekal naewe'e ampawʉajan! Kaen aton fʉlaech pejlul poxade, trigo xasaljabaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Xasaljaba wʉt, asew trigo natacholan nʉamtat. Do jawʉx, mia pat japatrigo xaeliajwas. Do jawʉtbej, japi trigo mia xaeslisi, nʉamtat natacholanpi. ");
INSERT INTO guoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Asew trigo natacholan ia'xot, jaxot as xanaja'al. Japi trigo kamta naboela, sat kaesʉapich xot. ");
INSERT INTO guoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xabich masxaenk wʉt, japi trigo selnas, xabich tathinkasnika-el xotdik. Do jawʉt, tʉplisi. ");
INSERT INTO guoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Asew trigo natacholan na-e'lʉ tasiaptasxot. Japi trigo naboela wʉt, do jawʉt, na-e'lʉbej naboela. Na-e'lʉ tapae-el trigo ti'sax, na-e'lʉ kaes athʉ xot. Samata, japi trigo naboesaxil. ");
INSERT INTO guoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Asew trigo natacholan sat pachaemxot. Puexa japi trigo chiekal naboela. Ti't wʉt, trigoton chiekal naboet. Asew trigoton naboet treinta trigofu. Asew trigoton naboet sesenta trigofu. Asew trigoton naboet cien trigofu” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesús pejme jʉm-aech: “Xamal Dios pejnejchaxoelax matabijasiam wʉt, ¡chiekal naewe'e xan jʉm-anpoxan!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Do jawʉx, Jesús tamach wʉt, doce apóstoles sʉapich, kaes asewbej, japon pejnachalapi, jawʉt japi puexa wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —¿Achax jʉmchiyaxaelkat japawʉajan? —aechi, wʉajnachaemt wʉt Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús jʉmnot wʉt, jʉm-aechon: —Dios xamal tapaei matabijaliajwam Dios pejjiw tato'alpox, xan japox naewʉajnax wʉt. Pe asew jiw, xanaboeja-elpi Dios, jʉmtaeyaxael wʉajankal asbʉan jʉmch. ");
INSERT INTO guoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Samata, japi jiw xabich natachaema. Pe japi taeyaxil. Japibej xabich naewet jʉmmatabijaliajwa, pe jʉmmatabijaxili, japi Dios xanaboejasamata, Dios japi babijaxan ispoxanliajwa beltaesamatabej —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Do jawʉt, Jesús pejme jʉm-aech pejnachalaliajwa: “¿Xamalkat matabija-emil trigo xasaljabapon pejwʉajan? ¿Machiyaxaelamkat matabijaliajwam, naewʉajnax wʉt asawʉajan?” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Do jawʉt, trigo pejwʉajan, xasaljabapon, Jesús chiekal chanaekabʉana pejnachala. Jʉm-aechon: “Trigo xasaljabapon, japon, me-ama Dios pejjamechan naewʉajanpon. ");
INSERT INTO guoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Trigo natacholanpi nʉamtat, japox, me-ama Dios pejjamechan jiw naewʉajnaspox. Jʉmtaenpi naewʉajnaspox, asew japixot, matabijaxil, matnaetink xoti. Me-ama sat tink, ja-aech xot japi pejmatnaetan. Do jawʉt, Satanás pasaxael Dios pejjamechan jukaliajwa japi jiw pejmatpʉatanxot. Samata, japi jiw naexasisaxil Dios pejjamechan. ");
INSERT INTO guoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Trigo natacholanpi ia'matwʉajtat, as xanaja'alxot, japi trigo kamta naboela. Japi trigo, me-ama jiw. Japi jiw jʉmtaen wʉt Dios pejjamechan, chiekal naexasiti. Do jawʉtbej, nejchachaemili. ");
INSERT INTO guoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pe jawʉtbej, naexasit xoti Dios, asew jiw bʉ'wʉajanpaeis wʉti, o, chaemilpox wepach wʉtbej, do jawʉt, japi jiw kofa Dios naexasitpox. Kaes naexasis-ellisi, pejnejchaxoelaxan kaes mamnika-el xot, chiekal naexasis-el xoti Dios. Japi jiw, me-ama trigo tathinkasnika-elpi, chiekal ti'sfʉla-el. Ja-aechlap-is japi jiw, kofa xoti Dios naexasitox. ");
INSERT INTO guoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Asew jiw, me-ama trigo, naboelapi na-e'lʉ tasiaptasxot. Japi jiw naexasit Dios pejjamechan, naewʉajnas wʉt. Do jawʉx, kofapi, pejnejchaxoelaxan asaxan matakas xot. ");
INSERT INTO guoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Japi jiw nejchaxoel ampathatpijaxankal. Nejchaxoelbejpi kemaenkaliajwa. Xabich platasiapi. Japanejchaxoelaxantat Dios pejjamechan matakas. Samata, Dios pejjamechan ti'sfʉlaxil japi pejmatpʉatanxot. ");
INSERT INTO guoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Asew jiw, me-ama trigo, natacholanpi sat pachaemxot. Japi jiwlax chiekal naexasisfʉl, Dios pejjamechan naewʉajnas wʉt. Ja-aech wʉt, japi jiw isfʉl Dios nejxasinkpoxan. Samata, asew japixot, me-ama trigoton naboeti treinta trigofu. Asew jiw japixot, me-ama trigoton naboeti sesenta trigofu. Asew jiw japixot, me-ama trigoton naboeti cien trigofu” —aech Jesús, pejnachala chanaekabʉana wʉt trigowʉajanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús pejme jʉm-aech: “Lámpara tamdutam wʉt, asaxtat matakasaximil. Cha-esaximilbej camabʉxfaltat. Athʉ cha-esaxaelam atʉaj itliakaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jachiyaxaelam tajnaewʉajnaxliajwa. Puexa tajnejchaxoelaxan, me-ama moechaspoxan. Pe asamatkoi puexa chiekal matabijaxaeli tajnaewʉajnaxpijaxtat. Puexa jiw tajnaewʉajnax matabija-elpi, japi asamatkoi matabijaxael. ");
INSERT INTO guoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xamal Dios pejnejchaxoelax matabijasiam wʉt, ¡xan jʉm-anpox chiekal naewe'e!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús pejme jʉm-aech: “¡Chiekal nejchaxoelde xan jʉm-anox! Asew jiw wewe'pas wʉt, ¡xamal chaxduim xajʉpampoxtat! Ja-am wʉt, xamalbej Dios chaxduiyaxael wewe'ppoxan. Dios kaes pejme xamal chaxduiyaxael pachaempoxan, chiekal matabijt xoton xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dios pejew chiekal tataefʉlpon, japon kaes pejme chaxdusaxaes. Asanlax, chiekal tataefla-elpon Dios pejew, japon kaesʉapich tataefʉlpoxan, japoxan kefisaxaeson” —aech Jesús, jiw naewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Do jawʉt, Jesús naewʉajan pejnachala. Dios tato'al wʉt pejjiw, japox kaesfʉlaxael. Samata, Jesús jʉm-aech: “Dios pejjiw tato'laxaelpox kaesfʉlaxael ampathatat. Me-ama aton trigo xasaljaba wʉt satat, jachiyaxaellapi-is Dios tato'alpox pejjiw. ");
INSERT INTO guoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dolisdo', japi trigo naboela wʉt, ti'sfʉl matkoi, madoibej. Trigo xasaljabapon moejt wʉt, japi trigo tamach ti'sfʉl. Japon matabijs-el, ma-aech, trigo ti'sfʉl wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Japi trigo naboela satat. Naboela wʉt, ti'ti. Ti't wʉt, trigo naboet. ");
INSERT INTO guoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Trigo chiekal ti't wʉt, pachaem jolaliajwa, pat wʉt pejmatkoi” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús pejme jʉm-aech: “Xamal chiekal matabijaliajwam, naewʉajnaxaelen wʉajan, ma-aech Dios tato'laxaelpox pejjiw kaesfʉlaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dios puexa pejjiw tato'alpox, me-ama mostazafut. Kaen aton japafut mʉtht pejlultat. Kamta weti'tas wʉt, do chiekal naedo'. Diachwʉajnakolax japafut kaes pejme cha-aelfut ampathatat. ");
INSERT INTO guoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Japafut mʉthtas wʉt, kamta ti't. Japanae, boejtachnaechlejen, kaewaech wʉt, ti't. Ti't wʉt, kaes athʉ. Me-ama asaxan jiw pejlulanxot mʉthapi, jachi-el. Samata, pachaem mia chalakaliajwa japadalantat, japanae pejnajelnaxtat” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús naewʉajan wʉt, xabich naewʉajan wʉajantat jiw jʉmtaeliajwa. Jiw kaes xajʉpa-el wʉt japawʉajan matabijaliajwa, Jesús bʉxkoft naewʉajanpox. ");
INSERT INTO guoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pomatkoicha Jesús jiw naewʉajan wʉajantat. Do jawʉx, tamach wʉt, pejnachala sʉapich, Jesús chiekal chanaekabʉana puexa pejnachala chiekal matabijaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Japamatkoitat, chatuil wʉti, Jesús jʉm-aech pejnachalaliajwa: —¡Chijias puka we-enlelde! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jawʉt pejnachala falkam jul. Jesús chajia wʉajna falkamtat ek, jiw naewʉajan xot. Do jawʉt, jaxot asew jiw waelapon pukababʉ'tat. Jawʉt, Jesús, pejnachala sʉapich, chaflaech wʉt, asafalkammochantat asew jiw wʉchakal chafol. ");
INSERT INTO guoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Do jawʉt, chalechkal xabich pinajoewa pat, xabich pintruxanbej. Falkam min wʉlʉkafʉl truxan fajabaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pe falkamta-ulel Jesús nejmach moejt. Taxʉ-oton taxʉ-osax. Do jawʉt, pejnachala thikas wʉt, jʉm-aechi: —¡Jiw chanaekabʉanan! ¿Xamkat nejchaxoela-emil xatis chabu'laxaesox? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Do jawʉt, Jesús nant fiasliajwa joewa, truxanbej. Jawʉt jʉm-aechon pukaliajwa: —¡Kaes nabej pintruxne'! —aech Jesús. Do jawʉt, chalechkal joewa chiekal toep. Puexa chiekal itnapatan. ");
INSERT INTO guoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¿Ma-aech xotkat xamal nejlewla? ¿Chiekal xan naxanaboeja-emilfʉk xamal bʉ'weyaxaelenpox? —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Do jawʉt, japi xabich natachaemanuil. Xabich pejlewlabejpi. Samata, nakaewa najʉm-aechi: —¿Achankat ampon? Joewa, pukabej, chiekal naexasichpon —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús, pejnachala sʉapich, chapa'a Gerasa tʉajnʉ, puka we-enlelde. ");
INSERT INTO guoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Jesús nant wʉt papʉtxot, kaen aton najae'an Jesúsleldin. Japon aton dep webaes pejmatpʉatxot. Japon aton duk patʉpamʉthanxot. Jiw ke'saxilipon. Cadenamʉatatbej piach xawaesaxil. ");
INSERT INTO guoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wʉajna chajia pin-iaveces xawaekson cadenamʉatantat. Tʉakwasixawaekspon. Kewʉsixawaeksbejpon. Japon xawaeks wʉt, cadenamʉa likton. Jiw xajʉpa-el piach xawaesliajwapi, xabich mamnik xoton. ");
INSERT INTO guoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pomatkoicha, pomadoichabej, japon jʉmch nanʉamt mʉaxanxot, patʉpamʉthanxotbej. Nanʉamt wʉt, xabich nejlaton. Ia'tat pajut naxkoljabapon naxbijabaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Japon aton dep webaes pejmatpʉatxot, Jesús atʉaxach fʉlaeyax taen wʉt, najae'non Jesúslel. Pat wʉton Jesús pejwʉajnalel, brixtat nukon. ");
INSERT INTO guoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Brixtat nuk wʉt, Jesús jʉm-aech depliajwa: —Dep, ¡xamal nakolim japon aton pejmatpʉatxot! —aechon. Samata, dep aton pejkaechatat nejlat wʉt, jʉm-aechon: —Jesús, ¡xam Dios athʉpijin paxʉlnam! ¿Achaxasiamkat xanalxot? ¡Xanal jʉm-an Dios pejwʉajnalel natalias-elaliajwam! —aech dep, nejlat wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Do jawʉt, Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Achawʉlamkat xam? —aech Jesús. Japi dep xabich pin-iat. Samata, jʉmnot wʉt, jʉm-aechi: —Xanal tajwʉl Xabich, xabich pin-iatan xot —aech japi dep. ");
INSERT INTO guoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dep jʉm-aech Jesús to'asamata atʉaj asatʉajnʉlel. ");
INSERT INTO guoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jaxot mox mʉaxxot maran pin-iakola naxaelp. ");
INSERT INTO guoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Samata, dep xabich jʉm-aech: —Ampon atonxot xanal nakolax nato'am wʉt, ¡natapaem maranxot leliajwan! —aech japi dep. ");
INSERT INTO guoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Do jawʉt, Jesús ow-aech dep wʉljowpox. Dolisdo', dep nakola wʉt japon aton pejmatpʉatxot, japi dep lowlisi maranxot. Japi maran xabich pin-iat, me-ama dos mil. Jawʉt puexa maran dʉkp chʉatadik. Mintat natacholan wʉt, jaxotdik puexa maran bu'al. ");
INSERT INTO guoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Do jawʉtbej, maran tataefʉlpi pejlewt dʉkp pejpaklowax poxade. Chapaeilisi taenpoxan. Paklowaxxot mox duilibej chapaeipi. Jawʉt jiw fʉlaen pajut chiekal taeliajwa jʉmtaenpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Japi jiw Jesúsxot pat wʉt, taenlisi japon aton. Japon aton dep wejisallison pejmatpʉatxot. Jesúsxot bʉ'la-eklison naxoelax, wepachaemsxot pejnejchaxoelax. Jiw fʉlaeni, taen wʉti japon, xabich pejlewlapi. ");
INSERT INTO guoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Taenpi Jesús ispox japon atonliajwa, maranliajwabej, japi chiekal chapaei taenpoxan asew jiw, pa'anpiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Do jawʉt, japatʉajnʉpijiw to'api Jesús asatʉajnʉlelaliajwa, Gerasa tʉajnʉxot namanasamata. ");
INSERT INTO guoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Do jawʉx, Jesús falkam jul wʉt, japon aton, dep wejisalpon pejmatpʉatxot, xabich kawʉajan nakfʉlaeliajwapon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pe Jesús tapae-el japon aton nakfʉlaeliajwas. Do jawʉt, Jesús to'a japon aton pejjiw poxade nawiasliajwa. Jesús jʉm-aech: —¡Nawia'mich nejba poxade! ¡Nejjiw chapaem puexa Dios ispox xamliajwa, Dios xam beltaen xot! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Do jawʉt, fʉlaechlison Decápolis tʉajnʉ poxade. Chapaefʉllison japapaklowaxanpijiw Jesús ispox japonliajwa. Puexa jiw jʉmtaen wʉt, jʉm-aechnapi: “¡Tae'nik ampon aton! ¡Chiekal pachaemlison!” —na-aechnapi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús, pejnachala sʉapich, kaxa nawen puka we-enleldin falkamtat. Jesús chapa'an wʉt, xabich jiw papasfʉl Jesúsxot pukababʉ'tat. ");
INSERT INTO guoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jawʉt kaen aton pat. Japon pawʉl Jairo. Judíos naewʉajnabapijiwxot, japon japixot paklonpon. Jesús taen wʉton, brixtat nukjabapon Jesús pejwʉajnalel. ");
INSERT INTO guoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jairo xabich tadʉt Jesús nakfʉlaeliajwas japon pejba poxade. Jʉm-aechon: —Taxʉlow xabich nawebʉ'xaenk. Mox pawʉajnapow tʉpaliajwa. ¡Xabʉa't! ¡Xan nakfʉlaem taxʉlowxot ke-osliajwam, boejthʉsliajwampow! —aech Jairo. ");
INSERT INTO guoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Do jawʉt, Jesús nakfol Jairo. Jesús xabich jiw chalas. Japixot xabich jiw Jesús pejwʉajnalel fol. Asew fol Jesús wʉchakallel. Jesús xabich tabe'nafʉlas. ");
INSERT INTO guoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Do jawʉt, kaeow pawis wʉchakal fol. Japow bʉ'xaenk. Xabich nabijatow. Pejlaw wʉt, jal chiekal matduka-el. Doce waechan jal chiekal matduka-elpox. ");
INSERT INTO guoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Xabich jiw woew wʉalachipow. Pe chinax kaen aton japow boejthʉs-esal. Xabich nabijatow wʉaspoxtat. Xadaeptbejpow puexa pejew plata nawoeyaxtat. Pe jal chiekal matduka-el. ");
INSERT INTO guoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Japow wʉltaen Jesús. Samata, Jesús mox wʉt, wʉchakal folow. Jawʉt nejchaxoelow: “Xan Jesús pejnaxoelax jajastaxpoxtat naboejthʉsaxaelon” —aechow, nejchaxoel wʉt. Samata, japow jajast Jesús naxoelax. Do jawʉt, japow chiekal boejthʉls. Jal chiekal ajil. Pajut bʉ'boejtaenpow chiekal boejthʉlsox. ");
INSERT INTO guoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús boejtaen, pejpamamax wenakolsas wʉt. Samata, Jesús kaxa natachaemdik wʉt, jʉm-aechon: —¿Achankat xan tajnaxoelax nawejajast? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Do jawʉt, Jesús pejnachala jʉm-aechi Jesúsliajwa: —Jiw xam tabe'nafʉl. ¿Ma-aech xotkat xam wʉajnachaemtam: ‘¿Achankat xan tajnaxoelax nawejajast?’ —amkat xam? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dolisdo' Jesús natadiajsfʉl jiwlel taeliajwa, achan jajastason. ");
INSERT INTO guoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jawʉt japow tathʉlal pejlewt. Matabijtow wejatisox. Samata, brixtat nukow Jesús pejwʉajnalel. Jawʉt chapaeipow wejatispox. ");
INSERT INTO guoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Do jawʉt, Jesús jʉm-aech japowliajwa: —Taj-atow, amwʉtjel xam pachaemam, chiekal naxanaboejtam xot. ¡Xabʉa'de nejmach! Nejwaxae kaes ajil xamxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús naksiya wʉtfʉk, Jairo pamak pat Jairoxot. Japi jʉm-aech Jairo jʉmtaeliajwa: —Naxʉlow tʉplisow. Samata, ¡nabej tadʉs jiw chanaekabʉanan xam nakfʉlaeliajwa nejba poxade! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús naekʉanjiamt japi jʉm-aechpox, jʉmtaen wʉton. Samata, Jesús jʉm-aech Jairoliajwa: —¡Nabej nejlewle' naxʉlow tʉppoxliajwa! ¡Xanaboejsfʉlde Dios! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Do jawʉt, Jesús nakiowa nakfolon. Jawʉt Jesús bʉ'fol Pedro, Santiagobej, Jairo pejba poxade. Bʉ'folbejpon Juan. Japon Santiago pakoewan. Jesús tapae-el kaes asew jiw nakfʉlaeliajwas Jairo pejba poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pat wʉti Jairo pejbaxot, Jesús jʉmtaen xabich jiw jʉmxan-elpoxan, jiw pinjametat wʉnowpoxanbej Jairo paxʉlow tʉppoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ba lech wʉt, Jesús jʉm-aech: —¿Ma-aech xotkat xamal xabich jʉmxan-elam? ¿Wʉnowambej? Japow tʉpa-el. Japow moejt —aech Jesús wʉnowpiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Japox jʉmtaen wʉti, asbʉan jʉmch xafafoli Jesúsliajwa. Do jawʉt, Jesús nakolax to'a jiw tathoetade. Jawʉt Jesús bʉflaech pejnachala batuchade, patʉpow och poxade. Bʉflaechbejpon patʉpow pax, japow penbej. ");
INSERT INTO guoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jaxot Jesús patʉpow kefit wʉt, jʉm-aechon patʉpowliajwa: —Talita cum —aech Jesús. (Japox jʉmchiliajwa hebreojametat: “Jam, xan jʉm-an: ‘¡Mat-e'e pejme dukaliajwam!’ —an xan” —chiliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Do jawʉt, kamta patʉpow mat-et. Mat-et wʉt, nantow. Jawʉt pajut chiekal laejepow. Japow doce waechan. Jawʉt puexa jiw jʉm-aech: “¡Taem patʉpow! ¡Laejapow pejme!” —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús nejthʉ'axtat jʉm-aech: “¡Nabej chapae' ampox asew jiw, xan isxpox xamalliajwa!” —aech Jesús jaxotpijiwliajwa. Do jawʉt, Jesús pejme jʉm-aech: “¡Chaxduim naxaeyax japow xaeliajwa!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús nakolt wʉt Capernaum paklowaxxot, fʉlaechon pejtʉajnʉkolax poxade, pejnachala sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pat wʉti Nazaret paklowaxxot, do jawʉx, napatamatkoi wʉt, Jesús lech judíos naewʉajnaba poxade. Jaxotde tʉaduton jiw naewʉajnaliajwa. Jaxotbej xabich jiw jʉmtaen wʉt Jesús naewʉajanpox, jawʉt, nakaewa nawʉajnachaemsna wʉt, jʉm-aechi: —¿Amxotkat ampon japoxan xabich matabijt jiw naewʉajnaliajwa? ¿Amxotkat matabijtbejpon matabijsax? ¿Ma-aech xotkat japon xajʉp koechaxan isliajwa? ");
INSERT INTO guoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ampon carpintero nabichan, María paxʉlan. Ampon pakoew ampilape. Kaen pawʉl Santiago. Asan pawʉl José. Asan pawʉl Judas. Asan pawʉl Simón. Jesús pakoewbej, watho', japi duil xatisxot —na-aechi nakaewa. Samata, naexasis-eli Jesús naewʉajanpox. ");
INSERT INTO guoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Do ja-aech wʉt, Jesús jʉm-aech japiliajwa: —Profetas sitaens asapaklowaxanpijiw. Pelax pejpaklowaxkolapijiw sitae-esal. Pejjiwkola, pejbapijiwbej, sitae-esal —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Samata, jaxot Jesús isaxil koechaxan. Kaesʉapich jiw bʉ'xaeya boejthʉton, jacha wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús xabich nejchaxoelanuk japi jiwliajwa, naexasis-el xoti. Do jawʉt, Jesús fʉlaech asatʉajnʉchan mox poxade. Japalelde jiw naewʉajnafʉldepon. ");
INSERT INTO guoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Do jawʉt, Jesús la doce apóstoles. Japi pat wʉt Jesúsxot, jawʉt, Jesús kaenanʉla kolenje to'apon japi paklowaxan poxaliajwa, naewʉajnaliajwapi Dios pejjamechan. To'a wʉt pejnachala, jʉm-aechon: “Jiw xabʉ'kʉlam wʉt, dep webaesi pejmatpʉatanxot, ¡japi dep to'im nakolaliajwa japi jiw pejmatpʉatanxot Dios pijaxtat!” —aech Jesús, to'a wʉt pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Jesús kefiat pejnachala, nanʉamt wʉt xalaesamata. Jʉm-aechon: “¡Nejkilachalanaeyankal xalaem! ¡Nabej xalae' naxaeyaxan, plata, nejchoxanbej! Mado' itʉakxajoelam, ¡do japoxkal tʉaklaflaem! ¡Ja-amdebej naxoelaxliajwa! Mado' inaxoelam, ¡do japoxkal bʉ'laflaem!” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesús pejme jʉm-aech: —Xamal paklowax patam wʉt, ¡kaebaxot duilde, jiw naewʉajnaliajwam japapaklowaxpijiw! Asalel fʉlaeliajwam wʉt, do jawʉt, ¡japabaxot nakolim! ");
INSERT INTO guoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Asew jiw xamal bʉ'kʉla-el wʉt, nejnaewʉajnax naewes-el wʉtbejpi, ¡japapaklowaxxot nakolim, asapaklowax poxaliajwam! Nakolam wʉt, ¡nejtʉakxajoe jolde lʉlaliajwam as natacholnaliajwa! Jasoxtat japi jiw pajut matabijaxael babijax ispox Diosliajwa, xamal bʉ'kʉla-el xoti —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dolisdo', Jesús pejnachala follisi. Pat wʉti, japapaklowaxanpijiw naewʉajanlisi kofaliajwa babijaxan ispoxan, naexasisliajwabejpi Dios. ");
INSERT INTO guoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jesús pejnachala dep to'a jiw pejmatpʉatanxot nakolaliajwa. Samata, xabich dep nakola. Xabich bʉ'xaeyabej boejthʉti, bʉ'xalot wʉti jiw olivosimintat. ");
INSERT INTO guoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Potʉajnʉcha xabich jiw wʉltaena Jesús pejwʉajan. Rey Herodes, Galilea tʉajnʉpijiw tato'lan, japonbej wʉltaen Jesús ispoxan, jiw nakaewa nospaei wʉt Jesúsliajwa. Pe Herodes matabijs-el, achan Jesús. Jʉmtaenpon, jiw nakaewa najʉm-aech wʉt Jesúsliajwa: “Jesús, japonlap Juan, jiw bautisan. Mat-echpon pejme duk. Samata, xajʉpon koechaxan isliajwa” —na-aech wʉt jiw nakaewa Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Asew japixot najʉm-aechbej Jesúsliajwa: “Jesús, japonlap profeta Elías. Mat-echpon pejme duk” —na-aechi nakaewa. Asew japixot najʉm-aechbej: “Jesús, japonlap profeta, me-ama majt duilpi” —na-aechi nakaewa Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes jʉmtaen wʉt jiw najʉm-aechpox Jesúsliajwa, japon jʉm-aech: —Jesús, japonlap Juan. Xan tajsoldaw majt tajut keto'ax Juan taxtasiapchaliajwas. Amwʉtjel japon mat-ech. Samata, japon pejme duk —aech Herodes. ");
INSERT INTO guoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Juan laeja wʉt, Herodes keto'a pejsoldaw Juan jaelsliajwas. Do jawʉt, Juan jaeltas wʉt, jiaspon jiw jebatat. Jaxot cadenamʉatat xawaechpon. Herodes japox is, to'as xoton pijow Herodías. Japow majt Felipe pijow. Japon Herodes pakoewan. Baxael, Herodes pakoewan Felipe fe'enpon. ");
INSERT INTO guoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Herodes pakoewan fe'en wʉt, Juan jʉm-aech Herodesliajwa: “¡Xam nakoewan pijow nijow dofaximil! ¡Japox chaemil isliajwa!” —aech Juan Herodesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Samata, Herodías japox jʉmtaen wʉtow, xabich nejweslapow Juan. Japow to'a pamal, japon keto'aliajwa pejsoldaw Juan boesaliajwas. Pe Herodes owchi-el, sitaen xoton Juan. Herodes matabijt, Juan xabich pachaempon. Samata, Herodes majt tapae-el Juan boesaliajwas. Juan naewʉajanpox Herodes nejxasink. Pe kolenejchaxoelaxan xot, matabijs-elon isaxaelpox. ");
INSERT INTO guoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Do jawʉx, Herodes is wʉt pejcumpleaños, xabich wʉllalapon paklochow, soldawpaklochowbej, kaes kemaenkibej, Galilea tʉajnʉpijiw. Do jawʉt, wʉllalasi puexa chiekal patlisi Herodesxot. Do jawʉtbej, Herodíasliajwa chiekal wepachaemsow pamal keto'aliajwa, japonbej keto'aliajwa pejsoldaw Juan boesaliajwas. Nejchaxoelow japox. ");
INSERT INTO guoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Dolisdo', fiesta wʉt, Herodías paxʉlow pat. Japow tamach nababoela puexa jiw pejwʉajnalel, japi taeliajwa. Nababoela wʉt, Herodes, asew jiwbej, naxaelpi japonxot, xabich nejchachaemili, japow nababoela wʉt. Do jawʉt, Herodes jʉm-aech japowliajwa: —¡Nejxasinkampox xan nawʉljoem! Xan japox chaxdusaxaelen. Diachwʉajnakolax paeix. Nawʉljowampox chaxdusaxaelen. Nejxasinkam wʉt, xan tato'laxtʉajnʉ chiekal najʉpachadusaxaelen xam tato'laliajwam —aech Herodes japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Do jawʉt, japox jʉmtaen wʉt, pen poxadepow wʉajnachaemsliajwapow pen. Penxot pat wʉt, chapaeipow paxon jʉmtispox. Jawʉt jʉm-aechow penliajwa: —En, ¿achaxkat xan taxon wʉljoeyaxaelen? —aechow. Do jawʉt, pen jʉmnot wʉt, jʉm-aech: —Jam, ¡ma amwʉt naxon wʉljoem Juan, jiw bautisan, pejmatnaet! —aechow paxʉlowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Do jawʉt, japow Herodes poxade. Jʉm-aechow rey Herodes jʉmtaeliajwa: —¡Ma amwʉt nachaxdu'e Juan pejmatnaet plaftat! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Do jawʉt, Herodes xabich nejxaejwas, jʉmtaen wʉton japow wʉljowpox. Samata, Herodes elchiyaxil japow wʉljowpoxliajwa, chajia jʉmdut xotlison puexa paklochow pejwʉajnalel japow chaxdusliajwa wʉljoeyaxaespox. Samata, Herodes chaxdusaxael japow wʉljowpox. ");
INSERT INTO guoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Do jawʉt, Herodes pejsoldawan to'a Juan pejmatnaet chaxlaeliajwadin. Jawʉt soldawan fʉlaech jiw jeba poxade. Jaxotde pa'a wʉt, Juan taxtasiapchapon. Plaftat Juan pejmatnaet chaxlaens fiesta poxadin. Soldawan xapat wʉt, Herodías paxʉlow chaxduton Juan pejmatnaet. Do jawʉt, japow pen poxade chaxlaeliajwa Juan pejmatnaet. ");
INSERT INTO guoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan pejnachala jʉmtaen wʉt Juan boesaspox, jawʉt fʉlaeni Juan patʉpan chaxlaeliajwa. Do jawʉt, chaxfollisipon mʉthsliajwa. Do jawʉt, mʉthslisipon. ");
INSERT INTO guoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús pej-apóstoles bʉxtoet wʉti naewʉajanpoxan asapaklowaxanpijiw, kaxa nawenlisi. Pat wʉti, natamejapi Jesúsxot. Jawʉt puexa chapaeilisi ispoxan, naewʉajanpoxanbej. ");
INSERT INTO guoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jaxot xabich jiw fʉlalaena. Samata, Jesús pejnachala xabich it-els xaeliajwa, jiw xabich xot. Samata, Jesús jʉm-aech: —¡Chijias jiwjil poxade, xatis tamach damlathʉlaliajwas! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Do jawʉt, Jesús, pejnachala sʉapich, chaflaech falkamtat jiwjil poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pe nakiowa, jawʉt xabich jiw fʉltaeni Jesús, chaflaech wʉt, pejnachala sʉapich. Matabijapi. Samata, xabich paklowaxanpijiw dʉkpde Jesús itjulaxaech poxade. Japi wʉajna pa'a. ");
INSERT INTO guoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús chapat wʉt falkamtat, Jesús xabich jiw taen papʉtlel. Taen wʉton, japi jiw xabich beltaenon. Jawʉt Jesús nejchaxoel wʉt, jʉm-aechon: “Ampi jiw, me-ama ovejas, wejisal xoti tataeflaspon” —aech Jesús, nejchaxoel wʉt. Samata, tʉadutlison xabich naewʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kaliax wʉt, Jesús pejnachala moxlisi Jesúsxot. Do jawʉt, japi jʉm-aech Jesúsliajwa: —Tuilalisox. Amxot ajil tʉajnʉchan. Ajilbej naxaeyaxan wʉajsliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Samata, ¡ampi jiw to'im tʉajnʉchan poxade, naxaeyaxan wʉajsliajwa! —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús japox jʉmtaen wʉt, jʉm-aechon: —¡Xamal najut chaxduim naxaeyaxan ampi jiw xaeliajwa! —aechon. Do jawʉt, jʉm-aechi: —¿Xamkat nejxasinkam xanal pan wʉajsliajwan doscientos denariostat, puexa ampi jiw xaeliajwa? —aech Jesús pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Massʉapichkat pan xamalxot? ¡Xabʉa'de taeliajwam jiwxot! —aech Jesús. Do jawʉt, japi taen wʉt, jʉm-aechi: —Asbʉan jʉmch cinco pan xanalxot, kolenje baxinbej —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Do jawʉt, Jesús to'a pejnachala puexa jiw kaenanʉla, pejmʉtan sʉapich, polaxot chalakaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Asamʉtan, pinamʉtan. Japamʉatanxot, me-ama cien jiw. Asamʉtan kaesʉapich jiw. Japamʉtanxot, me-ama cincuenta jiw. Puexa jiw chalak, pejmʉtan sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Do jawʉt, Jesús cinco pan chafit, kolenje baxinbej. Athʉlel natachaemsepon Dios kawʉajnaliajwa. Dios kawʉajan wʉt, jʉm-aechon: “Ax, xan gracias-an ampapanliajwa, ampabaxiliajwabej, xanal nachaxduwampi” —aech Jesús, pax Dios kawʉajan wʉt. Do jawʉt, jalkafʉllison pan. Jalkafʉl wʉt, pejnachala chaxduifʉllison japi sasliajwa, puexa jiw xaeliajwa. Ja-aechbejpon baxiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Puexa jiw chiekal xael. Chiekal nafnialisi. ");
INSERT INTO guoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jiw xaeyax kaechatoel wʉt, malpi Jesús pejnachala jia matpirantat. Wʉlʉpi doce matpiran baxitoerow, pan malsibej. ");
INSERT INTO guoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Japi jiw xaelpi, cinco mil poejiw. Watho', yamxi sʉapich, xajui-esal. ");
INSERT INTO guoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Do jawʉx, Jesús to'a pejnachala falkam julaliajwa, puka we-enlelde chalikaliajwa. To'aponi wʉajna chaflaeliajwa, Betsaida paklowaxlelde. Jesús kaweta namanfʉk jiw to'aliajwa naweliajwa pejbachan poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Do jawʉx, jiw to'a wʉt, Jesús julach mʉax poxase tamach Dios kawʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sesa itkʉatnik wʉt, Jesús tamach naman. Pejnachala falkamtat chafolfʉki pukatukolaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Taenon pejnachala xabich faetox. Joewa matalech falkam. Mox pawʉajna wʉt nalianaliajwa, Jesús fʉlaen pukaminakal. Me-ama matnoch xensliajwa wʉt, ja-aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Pejnachala taen wʉti Jesús, pukaminakal fʉlaenox, nejchaxoeli: “¡Tae'nik! ¡Ama dep fʉlaen!” —aech Jesús pejnachala, nejchaxoel wʉt. Samata, puexa japi xabich natachaema. Do jawʉt, pota na-oenklisi, xabich pejlewla xot. Jawʉt Jesús jʉm-aech: —¡Nabej nejlewle'! ¡Xanpe'! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Do jawʉt, Jesús falkam juldik japixot. Jawʉt kaes wika-ellisox. Samata, japi chiekal natachaemachalak falkamtat. ");
INSERT INTO guoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Japi matabija-elfʉk Jesús xajʉppox puexa isliajwa. Taen wʉti koechax, Jesús is wʉt panliajwa, chiekal matabija-eli taenpox, matnaetink xoti matabijaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Do jawʉt, Jesús, pejnachala sʉapich, puka we-enlelde chapa'api, Genesaret tʉajnʉxot. Jaxot itjul wʉt, falkam ke'tlisi pukababʉ'tat. ");
INSERT INTO guoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Japi nana wʉt falkamxot, jiw matabija japon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Do jawʉt, japi jiw kaxa dʉkpich asew jiw chapaeliajwa, japatʉajnʉpijiw. Do jawʉt, bʉ'xaeya chaxlaens camillatat Jesúslel japi boejthʉsliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús tʉajnʉchan poxade wʉt, paklowaxan poxade wʉtbejpon, Jesús fʉlaech poxade, jiw owas wʉajna plazaxot, japi bʉ'xaenki, boejthʉsliajwaspi Jesús. Taen wʉti Jesús, japi jiw jʉm-aech Jesúsliajwa: —Ampi jiw, bʉ'xaeya, ¡tapaem nejsumta-osax jachaliajwapi, matdukafʉlpox! —aechi Jesúsliajwa. Do jawʉx, puexa jachapi japox, japi chiekal boejthʉlslisi. ");
INSERT INTO guoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","(Fariseos, asew judíosbej, japi is pejwʉajnapijiw isfʉlpoxan. Xaeliajwa wʉt, majt xabich piach kekakiati. Naxaeyaxan wʉajt wʉti plazaxot, pejbatat xapat wʉt, xaeliajwa wʉtbej, majt xabich piach kekakiati. Tasos, jarros, maram, camaxanbej, xabich piach kiati. Japi kaes asaxan isbej. Me-ama pejwʉajnapijiw, jachi-eli. Kaes pejme xenapi japoxanliajwa. Japoxan ispi, nejchaxoel xot asbʉan jʉmch: “Japoxan isx wʉt, babijaxan ispoxan xanxot ajilaxael” —aech xoti, nejchaxoel wʉt.) Asamatkoi kaesʉapich fariseos, judíos chanaekabʉanapibej, fʉlaeni Jerusalén paklowaxxotdin, Jesús poxadin. Pat wʉti Jesúsxot, taeni Jesús pejnachala majt piach kekakias-elpox, xaeliajwa wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Samata, japi Jesús wʉajnachaemt wʉt, jʉm-aechi: —¿Ma-aech xotkat nejnachala is-el, me-ama wajwʉajnapijiw? Nejnachala xaeliajwa wʉt, majt xabich piach kekakias-eli —aech fariseos, judíos chanaekabʉanapibej, Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Jesús jʉmnot wʉt, jʉm-aechon: —Xamal, me-ama diachwʉajnakolax Dios naexasitam wʉt, ¡ja-am! Pe diachwʉajnakolax Dios naexasis-emil. Isaías, Dios pejprofeta, diachwʉajnakolax chajia jʉm-aech xamalliajwa, chajia lel wʉton. Jʉm-aechon Dios jʉm-aechpox: ‘Xamal naksiyam xan nasitaenampoxantat. Pelax nejnejchaxoelaxan xabich atʉaj xanxot. Samata, xamal isampoxan xanliajwa, naksiyam wʉtbej chimiajamechan xanliajwa, o, xan nakawʉajnampoxanbej, japoxan omjil xanliajwa. Naewʉajnam wʉtbej, naewʉajnam asew jiw pejnejchaxoelaxankal. Pelax xan tajnejchaxoelaxan, jiw naewʉajna-emil —aech Dios jʉm-aechpox xamalliajwa’ —aech Isaías, chajia lel wʉt —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Jesús pejme jʉm-aech fariseosliajwa: —Xamal naexasis-emil Dios pejtato'lax. Naexasitamlax jiw naewʉajanpoxankal. Asbʉan jʉmch isam nejwʉajnapijiw ispoxankal. ");
INSERT INTO guoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés chajia lelpox jʉm-aech: ‘¡Nej-ax, nej-enbej, sitaem! Babejjamechan jʉm-aechpon paxliajwa, penliajwabej, japon aton tʉpaxael kastikaxtat’ —aech Moisés chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Xamal asbʉan jʉmch naewʉajnam nejwʉajnapijiw isfʉlpoxan, japox pawʉl corbán. Samata, xamal jʉm-am: ‘Nejmach-aton chajia jʉmdut wʉt pejew Dios chaxduiliajwa, japoxan japon aton chaxduiyaxil, pax, penbej, japoxan Diosliajwa xot’ —am xamal. ");
INSERT INTO guoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Xamal japi jiw tapaeyam japox jʉmchiliajwa paxliajwa, penliajwabej: ‘Xan chajia Dios jʉmdutx chaxduiliajwa tejew. Samata, xamal kajachawaesliajwan, ajil’ —chiliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Asew jiw naewʉajnam wʉt nejwʉajnapijiw isfʉlpoxan, japoxantat Dios jʉm-aechpoxan kofam. Kaes asaxan naewʉajnambej, me-ama japox —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Do jawʉx, Jesús jiw la wʉt, jʉm-aechon: —¡Puexa xamal chiekal naewe'e! ¡Jʉmmatabijimbej xan jʉmchiyaxaelenpox! ");
INSERT INTO guoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jiw naxaeyax xael wʉt, babejchow nadofaxil. Jiw babijaxan is, chajia japoxan nejchaxoel xoti isliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Xamal Dios pejnejchaxoelax matabijasiam wʉt, ¡chiekal naewe'e xan jʉm-anpox! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús bʉxtoet wʉt jiw naewʉajanpox, ba lechon, pejnachala sʉapich. Do jawʉt, pejnachala wʉajnachaemtason, japi chiekal matabijaliajwa japawʉajan, Jesús jiw naewʉajanpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús jʉmnot wʉt, jʉm-aechon: —¿Xamalkat-is matabija-emil japawʉajan? ¿Matabija-emil jiw babejchow nadofaxilox, xael wʉt naxaeyax? ");
INSERT INTO guoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Naxaeyaxan jiw xael wʉt, pejnejchaxoelaxan poxa-eldik. Woejt poxadik. Do jawʉx, nakoltox —aech Jesús. Jesús japox jʉm-aech pejnachala chiekal matabijaliajwa, puexa naxaeyaxan pachaempox jiw xaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús pejme jʉm-aech: —Jiw pejnejchaxoelaxanxot nakola babejnejchaxoelaxan. ");
INSERT INTO guoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Samata, jiw babijaxan is. Poejiw, tamach laelpi, nejchaxoel asew watho' bʉ'moejsaxan. Jiw nejchaxoelbej natkowaliajwa asew jiw pejew. Jiw nejchaxoelbej asew jiw beliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Poejiw pakmolapi nejchaxoelbej asew watho' bʉ'moejsliajwa. Jiw taen wʉt asew jiw pejew, japoxansiabejpi pajutliajwa. Jiw nejchaxoelbej isliajwa babijaxan asew jiwliajwa. Jiw nejchaxoelbej naekichachajbaliajwa asew jiw. Jiw nejchaxoelbej babijaxan isliajwa pomatkoicha padala-elpoxan. Jiw nejchaxoelbej nusasiawlaliajwa, asew jiw ketaen wʉt. Jiw nejchaxoelbej bʉxwʉajnamaenkaliajwa asew jiwliajwa. Jiw pajut nejchaxoel wʉt, jʉm-aechbejpi: ‘Xan kaes pejme pachaeman. Me-ama asew jiw, jachi-enil’ —aechi, nejchaxoel wʉt. Jiw nejchaxoelbej nejmach duilaliajwa Dios naexasis-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Puexa japox babijaxan nakola jiw pejnejchaxoelaxanxot. Samata, jiw babejchow nadofa japanejchaxoelaxantat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús fʉlaech, pejnachala sʉapich, Tiro paklowax poxade, asatʉajnʉlelbej. Do jaxotde ba low wʉti, Jesús maliach pasasia. Pe nakiowa, jiw taenson. ");
INSERT INTO guoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Samata, atow wʉltaen Jesús pasaxaelpox. Samata, fʉlaechow Jesús taeliajwa. Japow judíos-atowa-el. Asatʉajnʉpijow. Pejtʉajnʉ pawʉl Sirofenicia. Pat wʉtow Jesúsxot, japow brixtat nuk Jesús pejwʉajnalel, sitaen xotow Jesús. Paxʉlow kaweta batat, dep webaesow pejmatpʉatxot. Samata, jʉm-aechow Jesúsliajwa: —¡Xam dep to'im nakolsliajwa taxʉlow pejmatpʉatxot! —aechow Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Do jawʉt, Jesús jʉm-aech: —Paxipi majt naxaeyaxan chaxduw paxi xaeliajwa. Do jawʉx, pachaem wʉr dʉajsliajwa malsi —aech Jesús japowliajwa. (Jasox Jesús jʉm-aech, matxoela kajachawaesaxael xoton judíos. Do jawʉx, kajachwawaesaxaelon judíos-elpi.) ");
INSERT INTO guoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Do jawʉt, japow jʉmnot wʉt, jʉm-aechow: —Tajpaklon, pe yamxi xael wʉt, mesaxot cha-aex fʉdʉ' natacholan wʉt mesaxot, wʉrbej xael. Samata, ¡nawoesa xan matxoela nakajachawae'e! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Do jawʉt, Jesús jʉm-aech: —Xam kajachawaesaxaelen, chiekal najʉmnotam xot xanliajwa. Naxʉlowlis pachaem. Dep nakoltlis naxʉlow pejmatpʉatxot. ¡Nawia'mich nejba poxade! —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Do jawʉt, chijialisow pejba poxade. Pejba pat wʉt, paxʉlow taenlisow, ok wʉt camatat. Dep wejisallisow pejmatpʉatxot. ");
INSERT INTO guoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Do jawʉt, Jesús nakolt Tiro tʉajnʉxot. Do jawʉx, Sidón tʉajnʉlel xentbejpon. Xenabejpon paklowaxan Decápolis tʉajnʉlel. Do jawʉx, Galilea pukaxot paton. ");
INSERT INTO guoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jaxot asew jiw bʉflaen naetakʉatan Jesúslel. Japon aton bʉxwʉajanjilbej. Japi jiw jʉm-aech Jesúsliajwa: —¡Ampon aton boejthʉ'e jʉmtaeliajwa! ¡Ke-o'ebej japonxot naksiyaliajwapon! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Do jawʉt, Jesús bʉflaech atʉaxach bʉxwʉajanjilan, jiw ajilxot. Jawʉt Jesús nataelanaetakʉanwʉaj jacha pejkothiyatat. Do jawʉt, Jesús loya pejkothiya, japon aton kaech-ia'jachaliajwa japa-almintat. ");
INSERT INTO guoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dolisdo', Jesús athʉlel natachaemse wʉt, xabich fakjolchapon. Jʉm-aechon: “¡Efata!” —aech Jesús. (Japajame jʉmchiliajwa hebreojametat: “¡Nej fafas!” —chiliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Do jawʉt, chalechkal pejnaetakʉanwʉaj chiekal wepachaemslison kolelelje. Pejkaech-ia't pachaembej naksiyaliajwa. Naksiya wʉt, chiekal jʉmtampapon. ");
INSERT INTO guoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Do jawʉt, Jesús jʉm-aech puexa jiwliajwa: —¡Puexa xamal nabej chapae' ampox asew jiw! —aech Jesús japi jiwliajwa. Jesús bʉxfiat wʉt, japi jiw nakiowa chapaefʉl asew jiw. ");
INSERT INTO guoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Japi jiw nejchaxoelanuili. Samata, jʉm-aechnapi: —¡Puexa Jesús ispoxan, chiekal ispon! Jesús boejthʉt wʉt, ¡hasta naetakʉatabej chiekal jʉmtaen! ¡Bʉxwʉajnajilabej chiekal naksiya! —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Asamatkoiyan xabich jiw pejme natamejal Jesúsxot. Japi jiw naxaeyaxan xaeliajwa jaxot ajil. Samata, Jesús pejnachala la moxliajwadin. ");
INSERT INTO guoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Japi pat wʉt, jʉm-aechon: —Ampi jiw beltaenx, wejisal xot xaeliajwa. Japi xan nachala tres matkoi. Toellisi naxaeyaxan xafoli. ");
INSERT INTO guoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","To'ax wʉti naxae-elaxtat pejbachan poxade, japi jiw xabich pejlit nʉamtat mamnikaxil, asew jiw japixot xabich atʉaj fʉlaenxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Do jawʉt, pejnachala jʉmnot wʉt, jʉm-aechi: —Amxot naxaeyaxan faekaxisal, jiw duila-el xot —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dolisdo', Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Massʉapichkat pan xamalxot? —aech Jesús. Jʉmnot wʉt, jʉm-aechi: —Amxot siete panes —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús puexa jiw chalakax to'a satat. Do jawʉt, siete panes Jesús chafit. Dios kawʉajan wʉt, jʉm-aechon: —Gracias-an ampapan nachaxduwampiliajwa —aech Jesús. Jawʉt pan jalkafʉlon. Do jawʉt, Jesús chaxduifʉl pejnachala, japi sasliajwa pan puexa jiwliajwa. Do jawʉt, Jesús pejnachala pan sasfʉllisi. ");
INSERT INTO guoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jesús pejnachalaxot cha-aex baxix. Do jawʉt, Jesús pejme Dios kawʉajan baxixliajwa. Jawʉt jʉm-aechon: —Gracias-anbej ampabaxixliajwa nachaxduwampi —aech Jesús. Do jawʉt, to'abejpon pejnachala baxix sasliajwapi puexa jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Puexa jiw chiekal xael. Chiekal nafniabejpi. Do baxael, pejnachala chanot malsi. Wʉlʉ siete matpiran. ");
INSERT INTO guoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Japi jiw xaelpi, me-ama cuatro mil jiw. Xaeyax kaechatoel wʉt, Jesús japi jiw to'a naweliajwa pejbachan poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Do jawʉx, Jesús falkam jul, pejnachala sʉapich, chaflaeliajwa Dalmanuta tʉajnʉ poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Do asamatkoi, fariseos pat wʉt Jesúsxot, japi chiekal wʉajnachaemt Jesús. Japi fariseos tasalasiapi Jesús, asax is wʉt. Samata, jʉm-aechi: —¡Isde koechax xanal taeliajwan, chiekal matabijaliajwanbej, diachwʉajnakolax xam Dios to'aponam wʉt! —aech fariseos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Do jawʉt, Jesús xabich fakjolcha, nejchachaemla-el xoton fariseosliajwa, naexasis-el xotbejpi. Samata, Jesús jʉm-aech: —Xamal nato'am xan koechax isliajwan asbʉan jʉmch taeliajwam. Pe xamal taeyaximil pajelkoechax —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Do jawʉt, Jesús chijia fariseosxot. Julon falkam chaflaeliajwa puka we-enlelde, pejnachala sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús pejnachala nejkiow naxaeyaxan xalaeliajwa. Japi asbʉan jʉmch kaekolax pan xafoli. ");
INSERT INTO guoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¡Chiekal taem fariseos pejlevaduraliajwa, Herodes pejlevaduraliajwabej! —aechon pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesús pejnachala jʉmtaen Jesús jʉm-aechpox. Pe japi jʉmmatabija-el. Samata, nakaewa nawʉajnachaemt wʉt, najʉm-aechi: —¿Achaxkat jʉm-aech Jesús? Jesús japox bej nakjʉm-aechbej, xatis nejkiows xot pan xalaeliajwas —aechi nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús matabijt pejnachala nakaewa najʉm-aechpox. Samata, Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Ma-aech xotkat xamal nakaewa najʉm-am panliajwa? ¿Xamalkat jʉmmatabija-emil, matnaetinkam xot? ");
INSERT INTO guoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Xamal taenam. Pe chiekal matabija-emil. Jʉmtae-emilbej. ¿Ma-aech xotkat xamal nejchaxoela-emil xan koechax isxpoxliajwa, ajil wʉt naxaeyaxan jiw xaeliajwa? ");
INSERT INTO guoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xan jalkafʉlax wʉt cinco pan cinco mil poejiwliajwa, do jawʉt, ¿masmatpirankat xamal wʉlʉm japi jiw mali? —aech Jesús pejnachalaliajwa. Japi jʉmnot wʉt, jʉm-aechi: —Xanal wʉlʉx doce matpiran —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús pejme jʉm-aech pejnachalaliajwa: —Xan jalkafʉlax wʉt siete panes cuatro mil jiwliajwa, jawʉt, ¿masmatpirankat xamal wʉlʉm japi jiw mali? —aech Jesús. Jesús pejnachala jʉmnot wʉt, jʉm-aechi: —Xanal wʉlʉx siete matpiran —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¿Xamalkat jʉmmatabija-emilfʉk? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús, pejnachala sʉapich, chapa'a Betsaida paklowaxxot. Japapaklowaxxot asew jiw bʉflaeni itliaklan Jesúslel. Japi wʉljow Jesús jachaliajwa itliaklan, japon chiekal taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús makxalaech wʉt itliaklan, bʉflaechon atʉaxach, paklowax tathoetlel. Jesús itfuxalot almintat itliaklan. Do jawʉt, Jesús itfujacha wʉt itliaklan, jawʉt Jesús wʉajnachaemt wʉt, jʉm-aechon itliaklanliajwa: —¿Xamkat taenamlejen? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Do jawʉt, itliaklan chiekal natachaemt wʉt, jʉm-aechon: —Jiw laelp wʉt, me-ama naechan laelp wʉt, ja-itfu-an —aech itliaklan. ");
INSERT INTO guoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Do jawʉt, Jesús pejme itfujacha. Jawʉt chiekal wepachaemslison pej-itfu. Chiekal taenbejpon. ");
INSERT INTO guoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús jʉm-aech: —¡Nabej fʉlae' paklowax poxade! ¡Xabʉa'de nejba poxade! ¡Nawia'mich! —aech Jesús majt itliakalponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús boejthʉt wʉt itliaklan, fʉlaechon, pejnachala sʉapich, asatʉajnʉchan poxade, Cesarea de Filipolel. Fol wʉti nʉamtat, Jesús wʉajnachaemt wʉt pejnachala, jʉm-aechon: —¿Achan na-aechkat jiw xanliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Japi jʉmnot wʉt, jʉm-aechi: —Asew jiw jʉm-aech xamliajwa: ‘Japonlap Juan, jiw bautisan. Mat-echpon pejme duk’ —aech asew jiw xamliajwa. Asew jiw jʉm-aechbej xamliajwa: ‘Japonlap Elías, Dios pejprofeta. Mat-echpon pejme duk’ —aech asew jiw xamliajwa. Asew jiw jʉm-aechbej xamliajwa: ‘Japonlap Dios pejprofetasxot mat-echpon pejme duk’ —aech asew jiw xamliajwa —aech Jesús pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Do jawʉt, Jesús pejme wʉajnachaemt wʉt, jʉm-aechon pejnachalaliajwa: —Xamallax, ¿achan na-amkat xanliajwa? —aech Jesús. Do jawʉt, Pedro jʉmnot wʉt, jʉm-aechon Jesúsliajwa: —Xam Cristowam, Dios to'asponam —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Do jawʉt, Jesús bʉxfiat wʉt, nejthʉ'axtat jʉm-aechon pejnachalaliajwa: —¡Japox asew jiw nabej chapae' xan Cristowanponan! —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús jʉm-aech pejnachalaliajwa, japon tʉpaxaelpoxliajwa: —Xan, puexa jiw pakoewkolnan, xabich nabijasaxaelen. Judíos-ancianos, sacerdotespaklochowbej, judíos chanaekabʉanapibej, japi xan najʉmchiyaxael: ‘Japon Cristowa-el, Dios to'aspona-el’ —chiyaxaeli xanliajwa. Samata, naboesaxael wʉt, tres matkoi wʉt, Dios xan namat-esaxael pejme dukaliajwan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús japox jʉm-aech pejnachala chiekal matabijaliajwa jachiyaxaespox japonliajwa. Jawʉt Pedro bʉflaechon Jesús pejlel nospaeliajwa tamach, Jesús sʉapich. Do jawʉt, Pedro bʉxfiat Jesús jʉm-aechpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pe Jesús natfo'cha asew pejnachalalel taeliajwa. Do jawʉt, Jesús jʉm-aech Pedroliajwa: —¡Chijiamde xanxot! Xam japox jʉm-am, Satanás bʉxto'a xot. Xam nejchaxoela-emil Dios pijaxan. Asbʉan jʉmch nejchaxoelam ampathatpijaxankal —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Do jawʉt, Jesús la pejnachala, jiwbej. Dolisdo', puexa jiw pat wʉt japonxot, Jesús jʉm-aech: —Xamal tajnachalwasiam wʉt, ¡najut babijaxan isampoxan, ma amwʉt kofim! ¡Pomatkoicha isfʉlde xan tato'laxpoxan! Asew jiw pijaxtat nabijatam wʉt, boesasia wʉtbejpi, ¡nakiowa xamal naexasisfʉlde xan tato'laxpoxan! ");
INSERT INTO guoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ampathatat isam wʉt najut nejxasinkampoxankal, asamatkoi tʉpam wʉt, napelsaxaelam Diosliajwa. Ja-am wʉt, duilaximil Diosxotse. Kofam wʉtlax najut isfʉlampoxan, isfʉlam wʉtlax xan tato'laxpoxan, Dios chiekal naexasisfʉlam wʉtbej, asamatkoi xamal tʉpam wʉt, napelsaximil Diosliajwa. Ja-am wʉt, pomatkoicha duilaxaelam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Achaxkat aton kanaxael xabich wʉton pejew ampathatat, asamatkoi tʉp wʉt, Dios kastikaxaes wʉton? ");
INSERT INTO guoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aton mosaxil pejewtat pasliajwapon Diosxotse, japon pejew chiekal omjil xot Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ampathatpijiw xabich is babijaxan. Japi nejchaxoela-elbej Dios. Japi jiw pejwʉajnalel xamal nadala wʉt xanliajwa, tajnaewʉajnaxliajwabej, xanbej, puexa jiw pakoewkolnan, tadalaxaelen xamalliajwa. Xan jachiyaxaelen taj-ax Dios pejwʉajnalel. Tadalaxaelen xamalliajwa, xan kaxa pasaxoekan wʉt ampathatasik taj-ax pijaxtat, taj-ax Dios pej-ángeles sʉapich —aech Jesús pejnachalaliajwa, asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús pejme jʉm-aech pejnachalaliajwa: —Diachwʉajnakolax xan jʉm-an. Asew jiw xamalxot pejpatʉpax wʉajna taeyaxaeli, Dios puexa pejjiw tato'al wʉt ampathatat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Do jawʉx, seis matkoiyan wʉt, Jesús fʉlaech mʉax xabich athʉ poxase julaliajwa. Jawʉt bʉ'folon tres pejnachalan. Kaen pawʉl Pedro. Asan pawʉl Santiago. Asan pawʉl Juan. ");
INSERT INTO guoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Dolisi, pinamʉaxxotse wʉt, Jesús xabich chaponanakthian. Pijax naxoelax xabich papoeikolax. Ampathatat jasox ajil xabich papoeikolax, me-ama japon pijax, jasox. ");
INSERT INTO guoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Do jawʉt, chalechkal kolenje aton natulaelt Jesúsxot. Japi judíos pejwʉajnapijiw. Kaen pawʉl Elías. Asan pawʉl Moisés. Japi nospaei, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Do jawʉt, Pedro jʉm-aech Jesúsliajwa: —Tajpaklon, pachaem, xanal amxotan wʉt. Nejxasinkam wʉt, xanal tres bʉa-at isaxaelen. Kaebʉ-at xamliajwa. Asabʉ-at Moisésliajwa. Asabʉ-at Elíasliajwabej —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jesús pejnachala japox taen wʉt, xabich pejlewlapi. Samata, Pedro matabijs-el jʉmchiyaxaelpox. ");
INSERT INTO guoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jawʉt itloejen fʉloek japi pejmatwʉajasik. Do jawʉt, japa-itloejentat Dios jʉm-aechsik: “Ampon taxʉlan, xabich nejxasinkaxpon, ¡japon naewesfʉlde!” —aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Do jawʉt, Jesús pejnachala natadiajt wʉt, asew kolenje Jesúsxot chiekal ajillisi. Jesús tamach nukafʉl. Jawʉt taeni Jesúskal. ");
INSERT INTO guoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Do jawʉx, mʉaxxot baloek wʉti, Jesús bʉxfiat pejnachala asew jiw chapaesamata japi taenpox. Jʉm-aechon: —Xan, puexa jiw pakoewkolnan, hasta namat-et wʉt, xan pejme dukx wʉtbej, do jawʉt, xamal asew jiw chapaeyaxaelam taenampox —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Japi ow-aech. Chapae-ellisi asew jiw. Nakaewa nawʉajnachaemsnapi: “¿Ma-aech xotkat Jesús jʉm-aech: ‘Hasta namat-et wʉt, xan pejme dukx wʉtbej, do jawʉt, xamal asew jiw chapaeyaxaelam taenampox’ —nak-aechkat Jesús xatisliajwa?” —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dolisdo', japi Jesús pejnachala, trespi, wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —Xam Cristowam wʉt, ¿ma-aech xotkat judíos chanaekabʉanapi jʉm-aech Elíasliajwa: “Wajwʉajnapijin Elías matxoela pasaxael. Do jawʉx, Cristo pasaxael” —aechkat judíos chanaekabʉanapi? —aech Jesús pejnachala Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús jʉmnot wʉt, jʉm-aechon: —Judíos chanaekabʉanapi jʉm-aechpox diachwʉajnakolax. Japi jʉm-aechpox: ‘Matxoela pasaxael kaen, me-ama Elías, jason. Japon puexa jiw chanaekabʉanaxael puexa jiw naexasisliajwa Dios. Jasox matxoela jachiyaxael Cristo pasax wʉajna’ —aechox, japi jʉm-aechpox. Dios chajia jʉm-aechbej: ‘Puexa jiw pakoewkolan xabich nabijasaxael judíos pijaxtat’ —aech Dios. Xanlap japonan, puexa jiw pakoewkolnan —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Do pejme Jesús jʉm-aech pejnachalaliajwa, trespiliajwa: —Diachwʉajnakolax xan jʉm-an. Kaen, Elías jason, patlison. Pe asew jiw babijaxan isasiapi, japi islisi babijax japonliajwa. Dios pejjamechan chajia jʉm-aech japonliajwa jʉmchiyaxaesox —aech Jesús Juan, jiw bautisan, pejpatʉpaxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dolisdo', Jesús, tres pejnachala sʉapich, fʉlaechlisi asew japon pejnachala poxade. Do jaxotde xabich jiw taenlisi, japi jiw matawiat wʉt asew Jesús pejnachala, japi kaweta namapi. Jaxot kaesʉapich judíos chanaekabʉanapi, wʉajna nabʉ'naloti Jesús pejnachala, namapi sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Puexa jiw taen wʉti Jesús, xabich nejchachaemili. Samata, Jesúslel dʉkpdepi kejachaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Do jawʉt, Jesús wʉajnachaemt wʉt pejnachala, jʉm-aechon: —¿Achaxkat xamal nabʉ'nalotam, judíos chanaekabʉanapi sʉapich? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kaen japixot jʉmnot wʉt, jʉm-aechon: —Jiw chanaekabʉanan, taxʉlan bʉflaenx xam dep to'aliajwam nakolsliajwa taxʉlan pejmatpʉatxot. Taxʉlan naksiyaxil, pejmatpʉatxot dep webaes xoton. ");
INSERT INTO guoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Dep pijaxtat chalechkal jʉwalon. Xabich kaechwathʉamabejpon. Xabich bʉa'tatitbejpon. Do jawʉt, xabich satat nadadolan. Xan jʉm-an nejnachala japi to'aliajwa dep nakolsliajwa taxʉlan pejmatpʉatxot. Pe nejnachala xajʉpa-el to'aliajwapi dep —aech yamxʉlan pax. ");
INSERT INTO guoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Tajnachala, xamal Dios chiekal xanaboeja-emil Dios xajʉppox dep to'aliajwa. Xabich pin-iamatkoiyan xamalxotx. Japamatkoiyantatbej xabich naewʉajnafʉlax. Kajachawaetxbej Dios chiekal xanaboejaliajwam. Pe xamal Dios chiekal xanaboeja-emilfʉk. ¡Bʉflaemen yamxʉlan xanlel! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Do jawʉt, yamxʉlan bʉflaenlisi Jesúsleldin. Dep taen wʉt Jesús, jawʉt dep pijaxtat yamxʉlan pejme satat jʉwal. Do jawʉtbej, yamxʉlan satat matariaman. Kaechwathʉamabejpon. ");
INSERT INTO guoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús wʉajnachaemt wʉt yamxʉlan pax, jʉm-aechon: —¿Masmatkoiyankat naxʉlan jasox ja-aech? —aech Jesús. Pax jʉmnot wʉt, jʉm-aech: —Xabich chajia ja-aechon. Japox tʉadut, jam wʉtlejen. ");
INSERT INTO guoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pin-iaveces dep pijaxtat jʉwal jitlel kakamwaliajwas. Minlelbej jʉwal bu'laliajwa. Samata, ¡xanal nabeltaem! Xajʉpam wʉt, ¡xanal nakajachawae'e! —aech yamxʉlan pax. ");
INSERT INTO guoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús jʉm-aech yamxʉlan paxliajwa: —¿Ma-aech xotkat xan najʉm-am: ‘Xajʉpam wʉt, ¡xanal nakajachawae'e!’ —amkat xanliajwa? Xam Dios naexasitam wʉt, Dios kajachawaesaxael dep nakolsliajwa naxʉlanxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Do jawʉt, yamxʉlan pax nejlakcha wʉt, jʉm-aechon: —Xan Dios naexasitx. Samata, ¡nakajachawae'e kaes pejme chiekal Dios naexasisliajwan! —aech yamxʉlan pax. ");
INSERT INTO guoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús taen wʉt xabich jiw papasfʉlpox jaxot, jawʉt Jesús to'a dep nakolsliajwa yamxʉlan pejmatpʉatxot. Jʉm-aechon: —Dep, xam yamxʉlan bʉxwʉajankijtam. Naetakʉatambej. ¡Nakolde japon yamxʉlan pejmatpʉatxot! ¡Kaxa nabej nawias yamxʉlan pejmatpʉat poxadin! —aech Jesús depliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Do jawʉt, dep xabich pinjametat na-ʉa wʉt, yamxʉlan jʉwal dep pijaxtat. Do jawʉt, dep nakolt yamxʉlan pejmatpʉatxot. Yamxʉlan okafʉl satat. Me-ama tʉp wʉt, ja-aechon. Samata, xabich jiw jʉm-aech: “¡Taem! Yamxʉlan chiekal tʉplison” —aech japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Do jawʉt, Jesús mʉaxfit yamxʉlan namat-esliajwa. Do jawʉt, yamxʉlan nant. ");
INSERT INTO guoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Do japoxwʉx, Jesús, pejnachala sʉapich, ba lech wʉt, japi piajkal wʉt, pejnachala wʉajnachaemtas. Jʉm-aechi Jesúsliajwa: —¿Ma-aech xotkat xanal xajʉpa-enil dep nakolsax to'aliajwan yamxʉlan pejmatpʉatxot? Me-ama xam, jachi-enil —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús jʉmnot wʉt, jʉm-aechon: —Me-ama ampon dep, jason, xamal najut nijaxtat xajʉpaximil to'aliajwam, majt Dios kawʉajna-emil wʉt —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jesús, pejnachala sʉapich, japatʉajnʉxot nakola wʉt, fʉlaechlisi Galilea tʉajnʉ poxade. Japi fʉlaech wʉt, Jesús nejxasinka-el asew jiw matabijsliajwas japon jaxotox, pejnachalakal naewʉajnaxael xoton. Do jawʉt, jʉm-aechon: —Xan, puexa jiw pakoewkolnan, asan nawiasaxael tadaelmajiwxot japi naboesaliajwa. Xan tʉpx wʉt, tres matkoi wʉt, Dios namat-esaxael pejme dukaliajwan —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pe japi chiekal jʉmmatabija-elfʉk Jesús jʉm-aechpox. Japi bʉxdalabej kaes wʉajnachaemsliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesús pat, pejnachala sʉapich, Capernaum paklowaxxot. Batutat wʉti, Jesús wʉajnachaemt wʉt pejnachala, jʉm-aechon japiliajwa: —¿Achaxkat xamal jʉm-am, nʉamtat folam wʉt? —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pe japi asbʉan jʉmch boejlach. Jʉmnos-eli, padala xot. Japi majt nʉamtat fol wʉt, nakaewa najʉm-aechi: “¿Achankat xatisxot kaes paklonaxael?” —aechi nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Do jawʉt, Jesús ek. Ek wʉt, lalison doce pejnachala kaes moxliajwadin. Jawʉt jʉm-aechon japiliajwa: —Xamal puexa jiw tato'lasiam wʉt, ¡majt pamaknamde puexa jiw kajachawaesliajwam! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Do jawʉt, Jesús yamxʉlan la moxliajwadin, pejnachala pejwʉajnalel. Do jawʉt, Jesús yamxʉlan islanuk wʉt, jʉm-aechon pejnachalaliajwa: ");
INSERT INTO guoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Yamxʉlan bʉ'kʉltam wʉt xan tajaxtat, ja-am wʉt, jawʉt xanbej chiekal nabʉ'kʉlsaxaelam. Nabʉ'kʉltam wʉt, xan kaenan nabʉ'kʉls-emil. Diosbej bʉ'kʉlsaxaelam, xan nato'apon —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Do jawʉt, Jesús pejnachalan, pawʉlpon Juan, jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, xanal kaen aton taenx, dep to'afʉl wʉt nakolaliajwa jiw pejmatpʉatanxot. Japon aton xam nijaxtat dep to'a nakolaliajwa jiw pejmatpʉatanxot. Pe wajmʉtpijna-el. Samata, xanal japon fiatx bʉxkofsliajwapon japox —aech Juan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús jʉmnot wʉt, jʉm-aechon: —Japon japox is wʉt, ¡nej is! ¡Nabej fias! Japon koechaxan is wʉt xan tajaxtat, ja-aech wʉt, jʉmchiyaxilon babejjamechan xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jiw is-elpi babijaxan xatisliajwa, japi, me-ama nakkajachawaet wʉt, ja-aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Diachwʉajnakolax jʉm-an. Nejmach-aton xamal kajachawaet wʉt, tajjiwam xot, japon aton xamal chaxdut wʉt minkal feliajwam, japon aton Dios kajachawaesaxaes —aech Jesús, Juanliajwa naksiya wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús pejme jʉm-aech pejnachalaliajwa: “Pomatkoicha jiw babijaxan is, asew jiw to'as xoti. Pe jelxan nanaexasiti is wʉt babijaxan, asew jiw to'as xoti, to'api jiw babijaxan isliajwa, japi jiw xabich kastikaxaes Dios. Japiliajwa kaes pejme pachaemaxael ia' pinanʉl, jajaera, kaechariama ke'aliajwas, chakakofaliajwas mar poxadik, xabich so'nik poxadik, jaxotdik tʉpaliajwapi. Ja-aech wʉt, japi to'axil kaes asew jiw babijaxan isliajwa, jelxan nanaexasiti. ");
INSERT INTO guoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nejke-echantat babijaxan isfʉlam wʉtbej, ¡najut naketariowcham, kofaliajwam babijaxan isampoxan! Ja-am wʉt, kaes pachaemaxaelam, kaeke-em wʉt pasliajwam Diosxotse. Kofa-emil wʉt babijaxan isampoxan, ja-am wʉt, napelsaxaelam infierno poxadik. Jaxotdik toepaxil jit pinjiyax. Japajitxotdikbej tafil tʉpa-el. ");
INSERT INTO guoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nejtʉakantat babijaxan isfʉlam wʉtbej, ¡najut natʉaktariowcham kofaliajwam babijaxan isampoxan! Ja-am wʉt, kaes pachaemaxaelam kaetʉakam wʉt pasliajwam Diosxotse. Kofa-emil wʉt babijaxan isampoxan, jachi-elasiam wʉt, xamal napelsaxaelam infierno poxadik. Jaxotdik toepaxil jit pinjiyax. Japajitxotdikbej tafil tʉpa-el. ");
INSERT INTO guoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Babijax isam wʉtbej, taenampox nej-itfutat, ja-am wʉt, ¡najut na-itfukuim xamal kofaliajwam babijaxan isampoxan! Do ja-am wʉt, kaes pachaemaxaelam pasliajwam Diosxotse, kae-itfutam wʉt. Kofa-emil wʉt babijaxan isampoxan, ja-am wʉt, xamal napelsaxaelam infierno poxadik. Jaxotdik toepa-el jit pinjiyax. Japajitxotdikbej tafil tʉpa-el” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Puexa jiw, infiernoxoti, xabich nabijasaxael japajitat” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jesús pejme jʉm-aech: “Dom pachaem. Dom xakuenka-el wʉt, chaemil. Dom chaemil wʉt, pejmeliajwa pachaemaxil. Samata, xamal pachaemaxaelam ampathatat. Me-ama dom pachaem wʉt, jachiyaxaelam. Nejjiw sʉapich, duilam wʉt, ¡chiekal pachaemde!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús nakolt wʉt Capernaum paklowaxxot, do jawʉt fʉlaechlison Judea tʉajnʉ poxade, Jordánlajt orientelel poxade. Jaxotde pejme xabich jiw papasfʉl japonxot. Do ja-aech wʉt, pejme tʉaduton jiw naewʉajnaliajwa, me-ama japon pejkabʉan. ");
INSERT INTO guoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Do jawʉt, fariseos mox soepapi Jesúsxot wʉajnachaemsliajwapi Jesús, Jesús asaxtat jʉm-aech wʉt japi tasalaliajwa japoxtat. Samata, fariseos jʉm-aech: —¿Tapaeiskat poejiw pelsliajwa pejwatho'? O, ¿tapae-esalkat? —aech fariseos. ");
INSERT INTO guoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús jʉmnot wʉt, jʉm-aechon: —¿Achaxkat jʉm-aech Moisés chajia lelpox xamal najʉm-ampoxliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Japi jʉm-aech: —Moisés chajia lelpox jʉm-aech: ‘Aton pijow fo'asia wʉt, japon lelaxael pelfʉt. Japapelfʉtat jʉmchiyaxaelon, ma-aech xot fo'asiapon pijow. Do jawʉx, palelafʉt chaxdusaxaelon pijow. Do ja-aech wʉt, japapelfʉt chaxdut wʉt, pachaemaxael japon aton fo'aliajwa pijow’ —aech Moisés chajia lelpox —aech fariseos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Do jawʉt, Jesús jʉm-aech fariseosliajwa: —Moisés jasox lel, xamal matnaetinkam xot naexasisliajwam Dios. ");
INSERT INTO guoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Majt wajwʉajna, Dios that is wʉt, kaen aton ispon. Kaeow atowbej ispon. ");
INSERT INTO guoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Samata, aton fit wʉt pawis, japi nakolaxael paxxot, penxotbej, japon aton, pijow sʉapich, pejlel dukaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Do ja-aech wʉt, japi kolenje, me-ama kaen wʉt, jachiyaxaeli. Ja-aech wʉt, japilis, me-ama majt kolenje wʉt, jachi-ellisi. Amwʉtjel japi, me-ama kaen wʉt, ja-aechlisi. ");
INSERT INTO guoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Samata, aton fo'axil pijow, Dios pijaxtat nakjiya xot —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Do baxael, Jesús, pejnachala sʉapich, batat wʉt, pejnachala wʉajnachaemtas watho' pelsaxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon pejnachalaliajwa: —Aton fo'a wʉt pijow, japon aton asaow pawis fit wʉt, japon babijax is Diosliajwa, pijowliajwabej, bʉ'moejt xoton asaow, pijowa-elpow. ");
INSERT INTO guoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pawisbej pamal fo'a wʉt, asan poi fit wʉtow, japow babijax is Diosliajwa, pamalliajwabej, bʉ'moejt xotow asan poi, pamala-elpon —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Do baxael, jiw bʉflaen yamxi Jesús poxadin, Jesús ke-osliajwa yamxixot. Jawʉt pejnachala jʉm-aech yamxi bʉflaeniliajwa: —¡Nabej bʉflae' yamxi Jesúsleldin! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús japox jʉmtaen wʉt, palalapon pejnachalaliajwa. Samata, jʉm-aechon: —¡Tapaem yamxi bʉflaeliajwas xanlel! ¡Nabej fias! Dios pejjiw, duilaxaeli Diosxotse, japi, me-ama ampi yamxi, kamta naexasit xoti Dios pejtato'lax. ");
INSERT INTO guoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Diachwʉajnakolax xan jʉm-an. Xamal Dios naexasitam wʉt, me-ama yamxi, ja-am wʉt, pasaxaelam Diosxotse. Dios naexasis-emil wʉt, pasaximil jaxotse —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Do jawʉt, Jesús kaenanʉla yamxi isnot wʉt, jʉm-aechon yamxiliajwa: “Dios puexa xamal nej kajachawaesfʉle” —aech Jesús, ke-ot wʉt yamxixot. ");
INSERT INTO guoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús pejme fʉlaeliajwa wʉt, kaen aton najae-en Jesúslel. Pat wʉt, Jesús pejwʉajnalel brixtat nukon. Jawʉt, wʉajnachaemt wʉt, jʉm-aechon: —Jiw chanaekabʉanan, xam xabich pachaemam. ¿Achaxkat xan nawewe'p isliajwan pomatkoicha dukaliajwan Diosxotse? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús jʉmnot wʉt, jʉm-aechon: —¿Ma-aech xotkat xan najʉm-am: ‘Xam xabich pachaemam’ —na-amkat? Kaen Dios xabich pachaem. ");
INSERT INTO guoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xam matabijtam Dios pejtato'laxan. Moisés chajia lelpox jʉm-aech: ‘¡Nabej boese' asan aton! ¡Nabej bʉ'moejs asaow pawis, nijwa-elpow! ¡Nabej natkowe'! ¡Nabej kechachajbe' asan aton tasalaliajwam, babijax is-elpon! ¡Nabej naekichachajbe'! ¡Nej-ax sitaem, nej-enbej!’ —aech Moisés chajia lelpox —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Do jawʉt, japon kemaeyan jʉm-aech: —Jiw chanaekabʉanan, xam najʉm-ampoxan, puexa japoxan xan tʉadutx naexasisliajwan, pansianan wʉt. Amwʉtjelbej nakiowa japoxan naexasisfʉlax —aech kemaeyan. ");
INSERT INTO guoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Do jawʉt, Jesús natachaemt wʉt kemaeyan, beltaenlison. Do jawʉtbej, Jesús jʉm-aech: —Xamfʉk kaeyax wewe'p isliajwam. ¡Xabʉa'de nejba poxade! ¡Puexa nejew mowim! Mowam wʉt, ¡japaplata chaxduim kejila! Ja-am wʉt, Dios xabich nejchachaemlaxael xamliajwa. Ja-am wʉtbej, Dios xam chaxduiyaxael xabich pachaempoxan japonxotse. Chaxduiyax daeptam wʉt, ¡xabʉa't xan naknanʉamsliajwam, tajnachalnamliajwambej! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kemaeyan jʉmtaen wʉt Jesús jʉm-aechpox, kemaeyan xabich nejxaejwas, xabich kemaenk xot. ");
INSERT INTO guoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús pejnachalalel natfo'cha wʉt, jʉm-aechon japiliajwa: —Xabich tampoel kemaeya pasliajwa Diosxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pejnachala xabich nejchaxoelanuil, jʉmtaen wʉti, Jesús japox jʉm-aech wʉt. Samata, Jesús pejme jʉm-aech pejnachalaliajwa: —Takoew, diachwʉajnakolax xabich tampoel kemaeya pasliajwa Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xamal matabijam camello pinjin xot, xajʉpaxil kuthatʉakre'wʉaj poxade xensliajwa. Kemaeyanliajwabej, tampoel japon pasliajwa Diosxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Japox jʉmtaen wʉt, Jesús pejnachala xabich kaes pejme nejchaxoelanuili. Nakaewa nawʉajnachaemsna wʉt, najʉm-aechi: —¿Achankatlax bʉ'weyaxaes? ¿Achankatlax pasaxael Diosxotse? —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús japi natachaemt wʉt, jʉm-aechon: —Jiw pajut pijaxtat pasaxil Diosxotse. Pelax Dios xajʉp puexa isliajwa. Samata, Dios xajʉp jiw bʉ'weliajwa. Dios kajachawaesaxael jiw pasliajwa japonxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Do jawʉt, Pedro jʉm-aech: —Xanal puexa tejew waelax, xam nakfʉlaeliajwan —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Do jawʉt, Jesús jʉm-aech: —Diachwʉajnakolax xan jʉm-an. Nejmach-aton Dios pejbichax nabichliajwa wʉt, japon waela wʉt pakoew, pen, pax, paxi, pejbabej, pejsatanbej, jasox is wʉton, tajwʉajan, chimiawʉajan, naexasit xoton, ja-aech wʉt, japon aton Dios kaes pejme chaxduiyaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Me-ama kaes cien veces chaxduiyaxaeson ampathatat. Jachiyaxaeson, pakoew, pen, paxi, pejba, pejsatbej, puexa japoxan waela xoton. Japon laeje wʉtfʉk ampathatat, jiw nejweslafʉlaxaeson. Samata, nabijasaxaelon, xan nanaexasit xot. Asamatkoi, japon tʉp wʉt, pasaxaelpon pachaemxotse, Diosxotse, pomatkoicha dukaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Xabich jiw amwʉtjel paklochowpi ampathatat, asamatkoi japi Diosxotse paklochowaxil Dios pejwʉajnalel. Xabich jiwlax amwʉtjel paklochowa-elpi ampathatat, japilax asamatkoi paklochowaxael Diosxotse Dios pejwʉajnalel —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Asamatkoi Jesús, pejnachala sʉapich, asew jiw sʉapichbej, japi fʉlaech Jerusalén paklowax poxade. Jesús matxoela fol. Pejnachala fol wʉt, nejchaxoeli: “¿Ma-aech xotkat Jesús pejlewla-el fʉlaeliajwa Jerusalén paklowax poxade?” —aechi, nejchaxoel wʉt. Asew jiw, wʉchakal folpi, japi pejlewla. Do jawʉt, Jesús bʉflaech doce pejnachala asalel japikal jʉmchiliajwapon. Jʉm-aechon asew jiw isaxaespox japonliajwa Jerusalén paklowaxxot. ");
INSERT INTO guoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesús jʉm-aech: “Amwʉt Jerusalén paklowax poxaxaes. Jaxotde xan, puexa jiw pakoewkolnan, asew jiw nawiasaxael sacerdotespaklochowxot, judíos chanaekabʉanapixotbej. Japi natasalaxael asew jiw xan naboesaliajwa. Do jawʉx, xan nawiasaxaeli judíos-elixot. ");
INSERT INTO guoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Japi nabʉ'wʉajanpaeyaxael. Naloyaxaelbejpi. Xabich namatwʉajselsaxaeli. Do jawʉx, naboesaxaeli. Tʉpx wʉt, tres matkoi wʉt, Dios namat-esaxael pejme dukaliajwan” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Do jawʉx, Santiago, Juan sʉapich, japi Zebedeo paxi, mox soepapi Jesúsxot. Do jawʉt, jʉm-aechi: —Jiw chanaekabʉanan, xanal wʉljowx xam nawe-isliajwam chamoeyax xanalliajwa —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús jʉmnot wʉt, jʉm-aechon japiliajwa: —¿Achaxkat we-isaxaelen, chamoeyax, xamalliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Japi jʉmnot wʉt, jʉm-aechi: —Xam jiw tato'lam wʉt ampathatat, ¡xanal natapaem chalakaliajwan xam nejkolalelje! ¡Natapaembej xanal puexa jiw tato'laliajwan, xam sʉapich, xanalbej jiw nasitaeliajwa! —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús jʉm-aech: —Xamal matabija-emil nawʉljowampox. Xan xabich nabijasaxaelen jiw pijaxtat. ¿Xamalkat-is xajʉpaxaelam nabijasliajwam, me-ama xan, jachiliajwam? Xanbej tʉpaxaelen asajiw pijaxtat. ¿Xamalkat-is xajʉpaxaelam tʉpaliajwam, me-ama xan, jachiliajwam? —aech Jesús japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Japi jʉmnot wʉt, jʉm-aechi: —Diachwʉajnakolax xanalbej xajʉpx nabijasliajwan, me-ama xam, jachiliajwan —aechi Jesúsliajwa. Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xamalbej tajaxtat nabijasaxaelam. Tʉpaxaelambej. Me-ama xan, jachiyaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pe tajkolalelje xamal chalakaliajwampox, puexa jiw tato'laliajwambej, xan sʉapich, japoxliajwa taj-ax Dios xan natapae-el tajut japox jʉmchiliajwan. Taj-ax Dios, japon pajut tapaeyaxael tajkolalelje chalakaxaelpi, xan sʉapich, japiliajwa chajia wechaemtas xotlisi —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Asew Jesús pejnachala, diezpi, japox jʉmtaen wʉt, palalapi Santiagoliajwa, Juanliajwabej, wʉljow xoti japox. ");
INSERT INTO guoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Do jawʉt, Jesús puexa pejnachala la, japi kaes moxliajwa Jesúsxot. Dolisi, japi kaes mox wʉt Jesúsxot, jawʉt Jesús jʉm-aech pejnachalaliajwa: —Xamal matabijam asatʉajnʉchanpijiw, Dios naexasis-eli, paklochow, japi tato'al wʉt, tato'la-el pachaempoxantat. Japi jiw tato'al pamamaxtat asew jiw matabijaliajwas japi kaes pejme paklochowpox. ");
INSERT INTO guoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pelax xamal jasoxtat tato'laximil. Nejmach-aton xamalxot kaes xabich paklonasia wʉt, japon majt xamal kajachawaesfʉlaxael. ");
INSERT INTO guoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nejmach-aton kaes paklonasia wʉt xamalxot, japon majt, me-ama esclavo wʉt, jachiyaxaelon xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ja-aechlap-is xanliajwa. Xan, puexa jiw pakoewkolnan, fʉlae-enil ampathatat jiw xan nakajachawaesfʉlaliajwa. Xanlax fʉlaekx jiw kajachawaesfʉlaliajwan, jiw bʉ'weliajwanbej, wemosliajwan japi babijaxan ispoxan, tʉpx wʉt cruztat —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús, pejnachala sʉapich, pat Jericó paklowaxxot. Do baxael, japapaklowax nakolaxxot nakolaliajwa wʉt, xabich Jerico paklowaxpijiwbej nafʉlchala. Do jaxot kaen itliaklan ek japanʉambabʉ'tat, jiw xaxenapi wʉljoeliajwa platafachan. Japon pawʉl Bartimeo. Japon Timeo paxʉlan. ");
INSERT INTO guoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Do jawʉt, jʉmtaen wʉton Jesús, Nazaret paklowaxpijin, mox xensaxaelpox, jawʉt, japon itliaklan nejlasfʉl wʉt, jʉm-aechfʉlon: —Jesús, David pamon, ¡xan nabeltaem! —aechfʉllison. ");
INSERT INTO guoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Xabich jiw bʉxfiachpon boejlach ekaliajwa. Ja-aech wʉt, itliaklan kaes pejme nejlasfʉl wʉt, jʉm-aechfʉlon: —David pamon, ¡xan nabeltaem! —aechfʉlon, nejlasfʉl wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Do jawʉt, Jesús japox jʉmtaen wʉt, nukjabapon. Jʉm-aechon: —¡Jʉm-amde itliaklan xanlel fʉlaeliajwadin! —aech Jesús. Do jawʉt, itliaklan las wʉt, jʉm-aechipon: —¡Nejchachaemilde! ¡Nande! Jesús xam la moxliajwam japon poxade —aechipon. ");
INSERT INTO guoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Do jawʉt, itliaklan thʉch naxoelax asalelaxach fo'a. Do jawʉt, nancha wʉt, moxdepon Jesús poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús wʉajnachaemt wʉt, jʉm-aechon itliaklanliajwa: —¿Achaxasiamkat xam? ¿Achaxkat isaxaelen xamliajwa? —aech Jesús itliaklanliajwa. Itliaklan jʉmnot wʉt, jʉm-aechon: —Jiw chanaekabʉanan, ¡xan taesian! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús jʉm-aech: —¡Xabʉa'de nejmach! Amwʉtjel xam pachaemam, chiekal naxanaboejtam xot —aech Jesús. Do jawʉt, itliaklan chiekal taenlison. Jawʉtbej, Jesús nakfollison. ");
INSERT INTO guoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús, pejnachala sʉapich, pat mox Jerusalén paklowaxxot. Japi pat Betfagé paklowaxachxot, Betania paklowaxachxotbej. Jaxot olivonaechan nuil mʉaxleltat. Jaxot Jesús kolenje pejnachalan wʉajna to'achon. ");
INSERT INTO guoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","To'a wʉt, jʉm-aechon: —¡Xabʉa'de japapaklowaxach wʉajnadexot! Jaxotde pa'mach wʉt, taeyaxaelam bur jelti'san, wʉke'taspon. Japabur chinax aton tʉa-eka-esalfʉk. ¡Jolde! Do jawʉt, ¡nawebʉflaeman! ");
INSERT INTO guoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jaxotpijin xamal wʉajnachaemt wʉt, jʉm-aech wʉton: ‘¿Ma-aech xotkat bur joltam?’ —aech wʉt, ¡jʉm-amo japon aton: ‘Wajpaklon wewe'pas bur. Toet wʉt, pejme wiasaxaelon’ —amo japon aton! —aech Jesús, bʉxto'a wʉt kolenje pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Do jawʉt, japi kolenje fʉlaechlisi. Patlisi japapaklowaxachxot. Jaxot bafafatabijla bur jelti'san taeni. Bur ke'tas nʉamtat. Do jawʉt, joltipon bʉflaeliajwadin Jesús poxadin. ");
INSERT INTO guoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Do jawʉt, jaxot nuili jʉm-aechi japiliajwa: —Xamal, ¿achaxkat isam? ¿Ma-aech xotkat bur joltam? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús pejnachala jʉmnot wʉt, jʉm-aechi Jesús bʉxto'aspox. Do jawʉt, jaxot nuili, japi tapaei Jesús pejnachala bur bʉflaeliajwa Jesús poxadin. ");
INSERT INTO guoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Do jawʉx, japi bʉ'pat wʉt Jesúsxot, tam-owalisi thʉch naxoeipoxan Jesús tʉa-ekaliajwa. Do jawʉt, Jesús tʉa-eklison bur. ");
INSERT INTO guoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jesús fʉlaeyaxaech poxade, xabich jiw thʉch naxoeipoxan ba'a nʉamtat. Asew japixot cha-aelnaedalan tasiapa, pa-ʉafpi, owaliajwa nʉamtat Jesús pejwʉajnalel, sitaen xoti Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Asew japixot matxoela fol. Asew jiw wʉchakal folbej. Puexa jiw nejlasfʉl, xabich nejchachaemil xoti Jesúsliajwa. Nejlasfʉl wʉt, jʉm-aechfʉlbejpi: —¡Aleluya! ¡Ampon fʉlaenpon Dios pijaxtat! Samata, ¡xabich pachaempon! ");
INSERT INTO guoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Pachaempon, Israel tʉajnʉpijiw pejrey! ¡Ampon rey chiekal tato'laxael! Me-ama wajwʉajnapijin, rey David, chiekal tato'al wʉt, jachiyaxaelon. ¡Dios, athʉpijin, japon xabich pachaem! —aechfʉli. ");
INSERT INTO guoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jasoxtat Jesús pat Jerusalén paklowaxxot. Dios pejtemplobaxot lech wʉt, puexa chiekal taenpon. Do jawʉt, Jesús nawiat, doce pejnachala sʉapich, Betania paklowaxach poxade, xabich tuila xotlisox. ");
INSERT INTO guoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kandiawa wʉt, Jesús, pejnachala sʉapich, nakola Betania paklowaxachxot. Do jawʉt, Jesús litaxaela. ");
INSERT INTO guoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Atʉajxach wʉt, taenon higonae xabich pa-ʉafpox. Samata, mox taechon, pabaech wʉt tʉsliajwa, xaeliajwabej. Pe mox taech wʉt, japanae xabich pa-ʉafkal, naebaech naboesmatkoiya-el xotfʉk. ");
INSERT INTO guoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Do jawʉt, Jesús jʉm-aech higonaeliajwa: —¡Kaes naboesaximil! ¡Jiw kaes nejbaech xaeyaxilbej! —aech Jesús. Pejnachala jʉmtaen Jesús jʉm-aechpox. ");
INSERT INTO guoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Do jawʉt, Jesús, pejnachala sʉapich, pejme pat Jerusalén paklowaxxot. Do jaxotde wʉt, Jesús low Dios pejtemploba. Jaxot Jesús taen jiw mowapi, wʉajtibej. Jesús to'a japi jiw nakolaliajwa tathoetade. Plata xanafokpi pejmesan wefʉliaxabapon. A-u mowapi, japi pejtʉa-ekaxan wewʉlaejababejpon. ");
INSERT INTO guoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesús tapae-elbej jiw xalaeliajwa pejew Dios pejtemplobatathoetlel. ");
INSERT INTO guoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naewʉajan wʉt, jʉm-aechon japi jiwliajwa: —Dios pejjamechan, chajia lelspox, jʉm-aech Dios jʉm-aechpox pejtemplobaliajwa: ‘Tajba kawʉajnaba wʉlxael, pothatapijiw xan nakawʉajnaliajwa’ —aech Dios jʉm-aechpox. Pe xamallax Dios pejtemploba kethaka pejba padofam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sacerdotespaklochow, judíos chanaekabʉanapibej, japi jʉmtaen Jesús jʉm-aechpox. Samata, nakaewa najʉm-aechi: “¿Machiyaxaeskat Jesús boesaliajwas?” —na-aechi nakaewa. Pe paklochow pejlewla Jesúsliajwa, puexa jiw xabich nejxasink xot Jesús naewʉajanpoxan. ");
INSERT INTO guoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tuila wʉt, Jesús Jerusalén paklowaxxot nakolt, pejnachala sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kandiawasap wʉt, Jesús, pejnachala sʉapich, xena wʉt, taenlisi higonae. Japanae chiekal majow. Tathinbej chiekal majow. ");
INSERT INTO guoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro nejchafaet Jesús jʉm-aechpox higonaeliajwa. Samata, jʉm-aechon Jesúsliajwa: —Jiw chanaekabʉanan, ¡natachaemde higonae! Kaeliw xam jʉm-ampox higonaeliajwa, diachwʉajnakolax ja-aechlisox. Amwʉtjel chiekal majow —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¡Dios chiekal xanaboejim japon xamal kajachawaesliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Diachwʉajnakolax xamal Dios chiekal xanaboejam wʉt, jʉm-am wʉt ampamʉaxliajwa: ‘¡Napia'e amxot mar poxamik!’ —am wʉt, japamʉax napiasaxael jaxot. Pelax xamal kolenejchaxoelaxam wʉt Diosliajwa, ja-am wʉt, japamʉax napiasaxil. ");
INSERT INTO guoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Samata, xamal jʉm-an. Dios kawʉajnam wʉt, ¡chiekal xanaboejim japon wʉljowampoxan xamal chaxduiliajwa! Jasoxtat kawʉajnam wʉt, diachwʉajnakolax Dios xamal chaxduiyaxael wʉljowampoxan. ");
INSERT INTO guoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Xamal Dios kawʉajnam wʉt, nalala wʉtfʉk asan aton ispoxliajwa, ¡xamal japon aton beltaem! Ja-am wʉt, waj-ax Dios, athʉpijin, xamal beltaeyaxaelbej babijaxan isampoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Xamal beltae-emil wʉt asew jiw, Diosbej xamal beltaeyaxil babijaxan isampoxanliajwa —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesús, pejnachala sʉapich, pejme pati Jerusalén paklowaxxot. Do jawʉt, Dios pejtemplobaxot laelpi. Jaxot sacerdotespaklochow, judíos chanaekabʉanapibej, ancianosbej, japi mox soepa Jesúsxot. ");
INSERT INTO guoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Do jawʉt, Jesús wʉajnachaemtas wʉt, jʉm-aechi: —¿Achankat xam to'am choef mowapi nakolax to'aliajwam Dios pejtemplobatat? —aech paklochow, wʉajnachaemt wʉti Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús jʉmnot wʉt, jʉm-aechon: —Xan-is xamal wʉajnachaemsaxaelen asax. ¡Majt chiekal najʉmno'e! Chiekal najʉmnotam wʉt, do jawʉx, xamalbej jʉmnosaxaelen xan nawʉajnachaemtampox. ");
INSERT INTO guoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Achankat Juan to'as jiw bautisaliajwa? ¿Dioskaton to'as? O, ¿jiwkaton to'as Juan bautisaliajwa jiw? ¡Najʉmno'e! Chiekal najʉmnotam wʉt, do jawʉt, xamal jʉmchiyaxaelen, achan nato'apoxtat japox xan isx —aech Jesús paklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Do jawʉt, japi nakaewa najʉm-aechi: “Xatis jʉmtis wʉt: ‘Juan Dios to'as jiw bautisafʉlaliajwa’ —tis wʉt, Jesús nakjʉmchiyaxael: ‘¿Ma-aech xotkat xamal naexasis-emil Juan jʉm-aechpox?’ —nakchiyaxael Jesús xatisliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jʉmtis wʉtlax: ‘Juan jiw to'as jiw bautisafʉlaliajwa’ —tis wʉt, japox jʉmtis wʉt, jiw xabich palalaxael, puexa jiw jʉm-aech xot pejnejchaxoelaxantat Juanliajwa: ‘Diachwʉajnakolax Juan, jiw bautisan, jʉm-aech Dios bʉxto'aspoxan’ —aech xoti” —aech paklochow nakaewaliajwa. Samata, japi paklochow xabich pejlewla jʉmchiliajwa japox Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Do jawʉt, paklochow jʉmnot wʉt, jʉm-aechi: —Jalape. Xanal matabija-enil, achan Juan to'as jiw bautisaliajwa —aechi. Do jawʉtbej, Jesús jʉm-aech: —Xan-is xamal jʉmchiyaxinil, achan nato'a xan japox isliajwan —aech Jesús paklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús jiw naewʉajan wʉt, wʉajantat jʉm-aechon: “Kaen aton uva mʉtha. Do jawʉx, uvalul chaxajajial ia'tat. Isbejpon uva-ʉfan jukax uvalulxot. Do jawʉx, isbejpon japalultat cha-aelbach, athʉpox, uvalul tataeflaliajwa, uva foi wʉt. Do jawʉt, uvalulpijin asew pamakjiwliajwa wʉljaet pejlul piach wetataeflaliajwas, japon pejwʉlela. Japi bʉ'pat wʉt, jʉm-aechon: ‘Xan fʉlaeyaxaelen asatʉajnʉlel atʉaj. Xan ajinil wʉt, xamal tajlul chiekal nawetataeflaxaelam’ —aech uvalulpijin. Do jawʉx, chijialison. ");
INSERT INTO guoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Asamatkoi, uva foi wʉt, uvalulpijin kaen pamakan to'a, japon wʉljaesliajwa uva pejpaklonliajwa. Do jawʉt, fʉlaenlison uvalul poxadin. ");
INSERT INTO guoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pe pat wʉton uvalul tataefʉlpixot, japi jaelt fʉlaenpon uva wʉljaesliajwa. Do jawʉt, baespon. Do jawʉtbej, ke-etat nawiasax to'aspon. ");
INSERT INTO guoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Do pejme uvalulpijin asan pamakan to'a. Jawʉt japon fʉlaenlison uvalul poxadin. Pat wʉton uvalul tataefʉlpixot, japi jaelt fʉlaenpon uva wʉljaesliajwa. Jawʉt xabich matnaeboesaspon. Jʉmtisbejpon babejjamechan. Do jawʉt, ke-etat nawiasax to'ason. ");
INSERT INTO guoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Do pejme uvalulpijin asan pamakan to'a japon wʉljaesliajwa uva. Dolison, pat wʉt uvalul tataefʉlpixot, uvalul tataefʉlpi boesa fʉlaenpon uva wʉljaesliajwa. Do jawʉt, uvalulpijin asew pamak to'a. Japi pat wʉt uvalul tataefʉlpixot, japibej baes. Asew japixot tʉp, fʉlaeni uva wʉljaesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Do jawʉt, uvalulpijin kaen wenamans to'aliajwa. Wenamanspon uvalulpijin paxʉlan, xabich nejxasinkpon. Do jawʉt, japon taxdukakolaxtat to'apon paxʉlan. Uvalulpijin nejchaxoel paxʉlanliajwa: ‘Uvalul tataefʉlpi, japi taen wʉt taxʉlan nawesitaeyaxaelipon’ —aechon uvalulpijin, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pe uvalul tataefʉlpi taen wʉti uvalulpijin paxʉlan, nakaewa najʉm-aechi: ‘¡Tae'nik uvalulpijin paxʉlan! Asamatkoi pax naetʉp wʉt, japon pijax wʉlxael, uvalul. Samata, ma amwʉt boesaxaeson uvalul wajaxkal chiekal namanaliajwa’ —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Uvalulpijin paxʉlan pat wʉt japixot, japi jaeltason. Do jawʉtbej, boesaspon. Jawʉt jutipon uvalulxot” —aech Jesús jiw naewetiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Do jawʉt, Jesús wʉajnachaemt jiw naeweti japawʉajan. Jʉm-aechon: “¿Achaxkat xamal nejchaxoelam uvalulpijinliajwa? ¿Achaxkat isaxael uvalulpijin uvalul tataefʉlpiliajwa? Xan tajut jʉm-an. Uvalulpijin chakifʉlaeyaxael uvalul tataefʉlpi kastikaliajwa, beliajwabejpon. Do pejme asew jiw tataeflax to'axaelon uvalul” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jesús pejme jʉm-aech: —Xamal bej xaljowambej Dios pejjamechan, chajia lelspox, jʉm-aech wʉt xanliajwa: ‘Jiw ia'ba is wʉt, kaet ia'tliajwa nakaewa najʉm-aechi: “Ampot ia't chaemil” —na-aechi ia'tliajwa. Do jawʉx, asan aton japot ia't fit. Japon jʉm-aech japot ia'tliajwa: “Ampot ia't, puexa ia'xot, kaes pejme xabich pachaem taxso'tpijtliajwa, ba chiekal mamnikaliajwa” —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Samata, japox xabich pachaem xatisliajwa’ —aech Dios pejjamechan, chajia lelspox, xanliajwa —aech Jesús, jiw naewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Do jawʉt, paklochow pajut matabija, Jesús jiw naewʉajan wʉt uvalul tataefʉlpiliajwa, japox jʉm-aechon paklochowliajwa. Samata, jawʉt Jesús jaelsasias bʉflaeliajwas, Jesús jiw jebatat jeliajwas. Pe paklochow pejlewla jiwliajwa. Samata, Jesús waelti tamach. Do jawʉt, fʉlaechlisi pejlel. ");
INSERT INTO guoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Do jawʉx, paklochow to'a Jesús poxade, kaesʉapich fariseos, Herodes pejmʉtpijiwbej, Jesús asax jʉm-aech wʉt, tasalaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Do jawʉt, pat wʉti Jesúsxot, jʉm-aechi: —Jiw chanaekabʉanan, xanal matabijax xam diachwʉajnakolax chiekal jʉm-am. Xam bʉxdala-elbej diachwʉajnakolaxpox naewʉajnaliajwam puexa jiwliajwa, nejlewla-el xot jiw nejchaxoelpox xamliajwa. Xam naewʉajnam diachwʉajnakolaxpox jiw chiekal duilaliajwa, me-ama Dios nejxasink. Samata, xanal matabijasian. ¿Pachaemkat xatis mosliajwas impuesto Roma tʉajnʉpijiw tato'lan? ¿Mosaxaeskat? O, ¿mosaxilsalkat? —aech paklochow, wʉajnachaemt wʉti Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús pajut matabijt tasalaxaespox, jʉmnot wʉton asaxtat wʉajnachaemtaspoxliajwa. Samata, Jesús jʉm-aech japiliajwa: —¿Ma-aech xotkat xan naxapaejtam? ¡Nawexalaeman kaekafef xan taeliajwan! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Do jawʉt, xalaenlisi kaekafef Jesúslel. Jawʉt Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Achan pejxu-aelkat ampakafeftat? ¿Achan pejwʉlbejkat ama lelspox ampakafeftat? —aech Jesús japiliajwa. Do jawʉt, japi jʉmnot wʉt, jʉm-aechi: —Roma tʉajnʉpijiw tato'lan, japon pejxu-ael, pejwʉlbej —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Do jawʉt, Jesús jʉm-aech: —¡Roma tʉajnʉpijiw tato'lan, japon pejewpi japon chaxduim, motam wʉt impuesto! ¡Pe Dios pejewpi, Dios chaxduim! —aech Jesús. Do jawʉt, japi jiw xabich natachaemana, Jesús chiekal jʉmnot xot. ");
INSERT INTO guoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceos asanejchaxoelax. Japi jʉm-aech: “Jiw tʉp wʉt, kaelel chiekal napelt. Asamatkoi mat-eyaxisalbej pejme duilaliajwa” —aechi asbʉan jʉmch. Do asamatkoi, kaesʉapich saduceos pat Jesús taeliajwa. Pat wʉti, japi wʉajnachaemt Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Jʉm-aechi wʉajantat: —Jiw chanaekabʉanan, Moisés chajia lelpox jʉm-aech: ‘Aton pijow naetʉp wʉt naxʉwla-elaxtat, patʉpan pakoewan naman wʉt, japon japow fisaxael. Ja-aech wʉt, japon naxʉwlaxael japowtat pakoewan tʉponliajwa’ —aech Moisés chajia lelpox —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Do jawʉt, japi kaes jʉm-aech: “Kaen aton seis pakoew. Matxoelapijin pawis fit. Pe baxael japon tʉp naxʉwla-elaxtat pijowxot. ");
INSERT INTO guoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Do jawʉtbej, wʉchakalpijin japow fit. Pe baxael japonbej tʉp naxʉwla-elaxtat japowxot. ");
INSERT INTO guoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Puexa japon pakoew, seispi, nadaepti nakjiyaxtat japowtat. Pe chinax kaen japixot naxʉwla-el japowtat. Do jawʉx, taxdukakolaxtat japowbej tʉp. ");
INSERT INTO guoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tʉpi mat-ias wʉt pejme duilaliajwa, jawʉt sietepixot, ¿achankat pijowaxael japow?” —aech saduceos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús jʉmnot wʉt, jʉm-aechon saduceosliajwa: —Xamal japox jʉm-am wʉt, nejmach jʉm-am, matabija-emil xot Dios pejjamechan, chajia lelspox, jʉm-aechpox. Matabija-emilbej Dios xajʉppox puexa isliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tʉpi mat-ias wʉt japi duilaxael Diosxotse. Jaxotse poejiw, watho'bej, pejme nakjiyaxil. Me-ama Dios pej-ángeles nakjiya-el, jachiyaxaelbej, tʉpi mat-ias wʉt pejme duilaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Xamalkat xaljoe-emil Moisés chajia lelpox, tʉpi mat-eyaxaespoxliajwa pejme duilaliajwa? Japawʉajanxot Dios chajia jʉmdʉt wʉt, jʉm-aechon boejtachnaechxotdin. Jawʉt Dios jʉm-aech tʉpi mat-eyaxaespoxliajwa pejme duilaliajwa. Do jawʉt, Dios jʉm-aech Moisésliajwa: ‘Xanfʉk amwʉtjel Abraham, Isaac, Jacobbej, japi pejDiosnan’ —aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Samata, Dios naexasiti matabija, asamatkoi tʉp wʉti pejme duilaxaelpox. Japi chiekal matabijabej, chajia wʉajna tʉpi, japi napels-elpox. Samata, Abraham, Isaac, Jacobbej, japi amwʉtjel duilafʉl Diosxotse. Xamal saduceos chiekal matabija-emil, jʉm-am wʉt: ‘Jiw tʉp wʉt, chiekal kaelel napelt. Tʉpi mat-eyaxisal pejme duilaliajwa’ —am wʉt, —aech Jesús saduceosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesús chiekal jʉmnot wʉt, saduceos, fariseosbej, jawʉtbej kaen judíos chanaekabʉanapon jʉmtaen. Samata, japonbej mox soepan Jesúsxot wʉajnachaemsliajwa. Do jawʉt, jʉm-aechon: —Jiw chanaekabʉanan, Dios xabich tato'al jiw naexasisliajwa. ¿Achatato'laxxotkat kaes pejme pachaem Dios tato'alpox jiw naexasisliajwa? —aech judíos chanaekabʉanan. ");
INSERT INTO guoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús jʉmnot wʉt, jʉm-aechon: —Ampawʉajan kaes pejme pachaem jiw chiekal naexasisliajwa: ‘Israel pamojiwam, ¡jʉmtaem chiekal! WajDios, japon kaen wajpaklokolan. ");
INSERT INTO guoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Samata, ¡chiekal nejxasinkde Dios wajpaklokolan! ¡Xabich nejxasinkdebej Dios puexa nejnejchaxoelaxtat! ¡Xabich tanbichfʉldebejpon puexa nejpamamaxtat!’ —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Asawʉajan, wʉchakal pejwʉajan, Dios tato'alpox, japox jʉm-aechbej: ‘¡Chiekal nejxasinkde jiw! Me-ama xam najut nanejxasinkam wʉt, ¡ja-amde asew jiwliajwa!’ Kolewʉajan, Dios tato'alpoxan, japawʉajanxot, do kaes asawʉajan ajil, xabich kaes pachaemwʉajan —aech Jesús judíos chanaekabʉananliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Do jawʉt, judíos chanaekabʉanan jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, xam naksiyam diachwʉajnakolaxpox. Dios pejjamechan, chajia lelspox, jʉm-aech: ‘Dios kaen. Kaes asan Dios ajil’ —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Diachwʉajnakolax pachaem xatis Dios chiekal nejxasinkaliajwas puexa wajnejchaxoelaxtat. Pachaembej Dios tanbichliajwas puexa wajpamamaxtat, nejxasinkas xot Dios. Pachaembej asew jiw nejxasinkaliajwas. Me-ama xatis wajut nanejxasinkas wʉt, jachiyaxaes asew jiwliajwa. Japoxanlap xabich pachaem xatis isliajwas. Japoxlap kaes pejme pachaem Diosliajwa, naexasich wʉt japoxan. Me-ama choef chabowaspoxan altarmatwʉajtat Dios pej-ofrendaliajwa, jachi-el japoxan —aech judíos chanaekabʉanan. ");
INSERT INTO guoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús jʉmtaen wʉt judíos chanaekabʉanan chiekal jʉmnotpox, jawʉt Jesús jʉm-aech judíos chanaekabʉananliajwa: —Xamfʉk kaesʉapich wewe'p chiekal naexasisliajwam Dios —aech Jesús. Dolisdo' jawʉt, jiw pejlewla kaes asax wʉajnachaemsaxtat xapaejsliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús jiw naewʉajan wʉt Dios pejtemplobatat, Jesús wʉajnachaemt wʉt, jʉm-aechon japi naewetiliajwa: —¿Ma-aech xotkat judíos chanaekabʉanapi jʉm-aech: ‘Cristo nalaelt wʉt, japon rey David pamonaxael’ —aechkat judíos chanaekabʉanapi? ");
INSERT INTO guoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David pajut jʉm-aech wʉt Espíritu Santo pijaxtat, jʉm-aechon Cristoliajwa: ‘Dios jʉm-aech tajpaklokolanliajwa: “¡Ekde tajpoklalel jiw tato'laliajwam, xan sʉapich! Ekam wʉtfʉk tajpoklalel, xan malechaxaelen nadaelmajiw. Malechax wʉt, japi jiw naexasisfʉlaxael xam tato'lampoxan” —aech Dios tajpaklokolanliajwa’ —aech rey David chajia lelsxot Cristoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David chajia jʉm-aechbej Cristoliajwa: ‘Tajpaklokolan’ —aechon Cristoliajwa. Samata, Cristo, diachwʉajnakolax rey David pejpaklokolanpon. Pe Cristo David pamonbej —aech Jesús pajutliajwa, jʉm-aech wʉt jiw chiekal jʉmmatabijaliajwa japon Dios paxʉlanpon. Xabich jiw nejchachaemil, jʉmtaen wʉti Jesús jʉm-aechpox. ");
INSERT INTO guoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús pejme jiw naewʉajan wʉt, jʉm-aechon: —¡Chiekal taem! Me-ama judíos chanaekabʉanapi, ¡nabej ja-aeche' xamal! Japi nejxasink pakchownaxoeyaxan jiw chiekal sitaeliajwas. Nejxasinkbejpi jiw saludaliajwas xabich sitaeyaxtat, xabʉ'kʉlas wʉt paklowaxthialaxanxot. ");
INSERT INTO guoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Japi judíos naewʉajnabachantat wʉt, wʉajna tʉachalakaxan nuilpi paklochow kaes sitaenspi chalakaliajwapitat, japatʉa-ekaxantat japi chalak puexa jiw taeliajwas. Ja-aechbejpi, fiestanxot wʉt. Japi nejxasink chalakaliajwa kaes pachaempoxantat. ");
INSERT INTO guoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Japi naekichachajba watho', pamaljiw naetʉpspi, wenosliajwa japi watho' pejew. Lowpi judíos naewʉajnaba piach Dios kawʉajnaliajwa, jiw taens wʉt jʉmchiliajwas: ‘Diachwʉajnakolax ampi jiw xabich pachaem’ —chiliajwas. Samata, Dios xabich kastikaxaesi —aech Jesús judíos chanaekabʉanapiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Asamatkoi Jesús mox ek ofrenda jiaxot Diosliajwa, templobatat. Jaxot Jesús taen, jiw jia wʉt plata. Xabich kimaeya plata xabich jiapi. ");
INSERT INTO guoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Do jawʉt, jaxot patbej pamal naetʉpspow. Japowbej jek kolekafef Dios pej-ofrendaliajwa. Japakafefaex, cobrefaex, xabich omjillejen. ");
INSERT INTO guoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús japox taen wʉt, lalison pejnachala kaes moxaliajwadin japonxot. Jaxot wʉti, Jesús jʉm-aech pejnachalaliajwa: —Diachwʉajnakolax xan jʉm-an. Ampow, pamal naetʉpspow, xabich kejil. Pe Dios kaes pejme nejchachaemil japow pej-ofrendaliajwa. Japow, me-ama kaes pejme chaxdut wʉt, ja-aechow Diosliajwa. Me-ama puexa asew jiw, chaxduw wʉt, jachi-elow japow. ");
INSERT INTO guoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Puexa asew jiw chaxduw ofrenda wenamaspoxantat. Japowlax wewe'paspoxanliajwa, puexa chaxdutow Diosliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús nakolt wʉt templobaxot, kaen pejnachalan jʉm-aech: —Jiw chanaekabʉanan, ¡tae'nik Dios pejtemploba, asabachanbej! ¡Japabachan xabich chimiabachan! ¡Japa-ia'bej xabich pinanʉl! —aech Jesús pejnachalan. ");
INSERT INTO guoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús jʉm-aech: —Xamal taenampi, pinabachan, japoxan asamatkoi chiekal toesaxaes. Asatʉajnʉchanpijiw japabachan toesaxael. Dios pejtemplobabej toesaxaeli. Japox ja-aech wʉt, kaet ia't namanaxil nakae-ia'tmatwʉajtat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Do jawʉx, Jesús, pejnachala sʉapich, fʉlaech Olivonaechanmʉax poxade. Japamʉax Dios pejtemplobatabijla ek. Jaxotde pa'a wʉt, Jesús ek, pejnachala sʉapich. Pedro, Santiago, Juan, Andrés, japi piajkal wʉt, wʉajnachaemti Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Jʉm-aechi Jesúsliajwa: —Jiw chanaekabʉanan, ¡xanal chiekal nachanaekabʉanim! ¿Maswʉtkat japox jachiyaxael, xam jʉm-ampox Dios pejtemplobaliajwa? ¿Achaxankat taeyaxaes, mox pawʉajna wʉt, xam jʉm-ampoxan jachiliajwa wʉt? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús jʉmnot wʉt, jʉm-aechon: —¡Chiekal taem asew jiw xamal naekichachajbasamata! ");
INSERT INTO guoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Xabich jiw pasaxael, me-ama xan. Japi pajut najʉmchiyaxael: ‘Xan Cristowan’ —nachiyaxaeli. Pe japi Cristowaxil. Xabich jiw naexasisaxaesi, japi naekichachajba wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Asamatkoi xamal wʉltaenam wʉt soldaw xabich nabapox mox, o, atʉaj, ¡xamal nabej nejlewle'! Japoxan majt jachiyaxael, mox pawʉajna wʉt that toepaliajwa. Ja-aech wʉt, that toepax pasaxilfʉk. ");
INSERT INTO guoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","That toepax wʉajna, xabichaxael nabewʉajan. Nakaetʉajnʉpijiw nabeyaxael, nakaetʉajnʉpijiw sʉapich. Japoxan majt jachiyaxael asatʉajnʉchanlel. Kaetʉajnʉpijiw nabeyaxaelbej, asatʉajnʉpijiw sʉapich. Japox majt jachiyaxael asatʉajnʉlel. Asatʉajnʉlel xabich sat najaesaxaelbej potʉajnʉcha. Naxaeyaxan xabich ajilaxaelbej. Majt japoxan jachiyaxael, nabijasax tʉadusaxael wʉt jiw xabich nabijasliajwa. Me-ama watho' naxʉwlaliajwa wʉt, xabich wexaenkas, jachiyaxaelbej, japox tʉadut wʉt, jiw nabijasaxaelpox. ");
INSERT INTO guoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“¡Xamal najut chiekal natataefʉlde! Asew jiw xamal bʉflaeyaxael paklochow poxade. Japi xamal kastikaxael judíos naewʉajnabachanxot. Nuilaxaelam paklochow pejwʉajnalel, tajnachalwam xot. Jaxotam wʉt, xamal naksiyaxaelam xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Matdukamatkoi wʉajna, potʉajnʉcha xamal naewʉajanaxaelam chimiawʉajan, Dios jiw bʉ'weyaxaelpox. ");
INSERT INTO guoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Xamal bʉflaech wʉti paklochow poxade, ¡xabich nabej nejchaxoele' jaxot naksiyaxaelampoxanliajwa! Jawʉt naksiyaxaelam Dios bʉxto'apoxan xamal naksiyaliajwam. Najut nijaxtat naksiyaximil. Naksiyaxaelam Espíritu Santo pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Japamatkoiyan, xamal tajnachalwam xot, asew jiw xamalxot, pakoewkola bʉflaeyaxaes paklochow poxade, jaxotde beliajwas. Asew jiwbej xamalxot, paxjiw, o, penjiwbej, bʉflaeyaxaes paklochow poxade, jaxotde beliajwas. Asew jiwbej xamalxot, paxi bʉflaeyaxaes paklochow poxade, jaxotde beliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Puexa jiw xamal nejweslaxael, tajnachalwam xot. Pe kofa-emil wʉt Dios xanaboejampox, ja-am wʉt, hasta tʉpam wʉt, Dios xamal bʉ'weyaxael. ");
INSERT INTO guoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“¡Xaljowpon nej matabijs ampox! Xamal xaljowam wʉt, ¡chiekal matabijim! Xamal taenam wʉt xabich babejkolan Dios pejtemplobatutat, jaxot tapaeyaxisalpon leliajwa, jaxot wʉtlison, ja-aech wʉt, ¡puexa Judea tʉajnʉpijiw nej dʉkpe pinamʉaxan poxade! ");
INSERT INTO guoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Do jawʉtbej, jiw nuili bachanmatwʉajtat, baloek wʉt, ¡nej le-ele' pejbachan poxade pejew jukaliajwa, xadʉkpaliajwabejpi! ");
INSERT INTO guoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","“Do jawʉtbej, jiw nabisti pejlulantat, ¡do jaxot kaweta kamta atʉaj nej dʉkpe! ¡Japi kaxa nej nawe-eledin pejbachan poxadin, pejew ponan wʉljaesliajwa! ");
INSERT INTO guoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Do jawʉtbej, watho', moejowpi, yamxi mitan miati, japi watho' xabich nabijasaxael. ");
INSERT INTO guoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dʉkpam wʉt xabich nabijasasamatam, ¡Dios kawʉajnafʉlde japox pasasamata, iama wʉt! ");
INSERT INTO guoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dios that is wʉt, amwʉtjelbej, jachi-ellejen japanabijasax. Japamatkoiyantat xabich kaes nabijasaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nabijasmatkoiyan piachaxael wʉt, jiw xajʉpaxil boejtaliasfʉlaliajwa. Samata, Dios tapaeyaxil piach, pejjiw xabich nabijasliajwa. Jachiyaxael, Dios makanot wʉt Dios nejxasinkaspi. ");
INSERT INTO guoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Asew jiw xamalxot jʉm-aech wʉt: ‘¡Tae'nik Cristo!’ o, asew jiw jʉm-aech wʉtbej: ‘¡Jaxotde Cristo!’ —aech wʉtbej, ¡nabej naexasis! ");
INSERT INTO guoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Matxoela fʉlaeyaxaen naekichachajbapijiw. Japi pasaxaen, me-ama Cristo. Pe japi Cristowaxil. Asew jiw pasfʉlaxael, me-ama Dios pejprofetas. Pe japi Dios pejprofetakolaxil. Japi isaxael koechaxan, japoxantat japi jiw naekichachajbaliajwa. Naekichachajbasiabejpi jiw, Dios naexasiti, japi jiw kofaliajwa Dios xanaboejapoxan. ");
INSERT INTO guoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Chiekal taem! Xan ampox jʉm-an xamal chajia chiekal matabijaliajwam, asamatkoi xamal naekichachajbasamata japi jiw” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús pejme jʉm-aech pejnachalaliajwa: —Nabijasmatkoiyan toep wʉt, juimt matkoipijinn kamta kʉatlaxael. Juimt madoipijinbej itliakaxil. ");
INSERT INTO guoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ithaejanbej natacholnaxael. Puexa thatbaxotatibej xabich nachoelaxael. ");
INSERT INTO guoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Do jawʉt, xan, puexa jiw pakoewkolnan, athʉlelsik fʉloekx wʉt itloejentat, jiw xan nataeyaxael, paskax wʉt, puexa jiw tato'laliajwan. Do jawʉt, itliakaxaelen Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Do jawʉtbej, xan to'axaelen tejew ángeles, pin-iakola, japi pothata xajʉpaliajwa. Japi bʉflaeyaxaen jiw xanlel, xan makanotxpikal. ");
INSERT INTO guoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“¡Chiekal nejchaxoelde, taenam wʉt higonae! Higonae pajel-ʉaf nakola wʉt, ja-aech wʉt, xamal matabijam waech mox pawʉajnapox. ");
INSERT INTO guoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jachiyaxaelbej japoxan taenam wʉt, xan jʉm-anpoxan. Matabijaxaelam xan mox tawʉajnapox pejme pasliajwan puexa jiw tato'laliajwan, taj-ax Dios sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Diachwʉajnakolax xan jʉm-an. Puexa xan jʉm-anpoxan diachwʉajnakolax jachiyaxael. Asew jiw xamalxot japoxan taeyaxael, laelpifʉk ampathatat. ");
INSERT INTO guoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Thatbaxo, ampathatbej, toepaxael. Pelax tajjamechan toepaxil. Xan jʉm-anpoxan, japoxan diachwʉajnakolax jachiyaxael. ");
INSERT INTO guoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Puexa jiw matabija-el xan pasaxoekanmatkoi. Dios pej-ángelesbej matabija-el japox. Xanbej, Dios paxʉlnan, matabijs-enil japox. Kaen taj-ax Dios matabijt. ");
INSERT INTO guoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Samata, ¡xamal najut chiekal natataefʉlde! ¡Pomatkoicha nawʉajnawesfʉldebej, xamal matabija-emil xot xan pasaxoekanmatkoi! ");
INSERT INTO guoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Xan pejme fʉloekx wʉt athʉlelsik, me-ama kaen aton pejba naechijia wʉt, pejme kaxa nawia'an, xanbej jachiyaxaelen. Japon aton tamach waelapon pamak pejbatat. Pamak kaenanʉla bichax chaxduwpon. Jʉm-aechon kaen pamakanliajwa: ‘¡Tajba chiekal nawetataefʉlde, nawʉajnawetam wʉt tajpasax!’ —aech aton pamakanliajwa. Do jawʉx, chijialison atʉaj. ");
INSERT INTO guoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Xamalbej nawʉajnawetam wʉt, ¡me-ama ba tataeflan, ja-amsfʉlde xamal! Japon pomatkoicha ba chiekal tataeflaxael, matabijs-el xoton, maswʉt bapijin pejme pasaxael. Bej pasaxaelbejpon kaliax, o, pinmadoitat, o, nalianawʉajna. O, pasaxaelon kandiawasap. ");
INSERT INTO guoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pamakan matabijs-el, maswʉt pejpaklon pasaxael. Samata, pomatkoicha chiekal wʉajnawesfʉl, pejpaklon pat wʉt nejchachaemlaliajwa japiliajwa. Pejpaklon chamatpasaxisal pamakan chiekal wʉajnawesfʉla-esalpoxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Xamal jʉm-anpox, jʉm-anbej puexa asew jiwliajwa. ¡Chiekal nawʉajnawesfʉlde!” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kaewaechfʉl wʉt, judíos is Pascuafiesta nejkiowasamata pejwʉajnapijiw nakolapox Egipto tʉajnʉxot. Japafiestamatkoiyan wʉt, judíos isbej asafiesta. Pan puthla-elpi xael, japafiesta wʉt. We'p wʉtfʉk kolematkoije judíos tʉadusliajwa Pascuafiesta isax, jawʉt sacerdotespaklochow, judíos chanaekabʉanapibej, natameja piajkal. Japi jaelsasia Jesús naekichachajbapoxtat boesaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Do jawʉt, nakaewa najʉm-aechi: —Japox isaxisal fiestatat. Japox isas wʉt, jiw xabich palalaxael xatisliajwa. Ja-aech wʉt, jiwbej chamamosaxaelbej Jesús —na-aech paklochow nakaepaklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betania paklowaxxot wʉt, paton Simón pejbatat. Japon Simón majt leprawaxae waechpon. Japabatat Jesús xael wʉt, kaeow atow xapat perjumamint batiajtat. Japabatiajt isas ia't, pawʉlpot alabastro. Japaperjumamint xabich ommaenk. Isas nardokal. Do jawʉt, batiajtwathit jalnatow. Do jawʉt, japow ta'chafan Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Asew jiw japixot japox taen wʉti, palalapi japowliajwa. Do jawʉt, nakaewa najʉm-aechi: —¿Ma-aech xotkat japow tabejt perjumamint? ");
INSERT INTO guoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Japaperjumamint xabich ommaenk. Japaperjumamint mowas wʉt, xabich plata kanaxaes, me-ama trescientos denarios. Ja-aech wʉt, japaplata chaxduiyaxaes kejila —na-aechi nakaewa. Jasoxtat jʉm-aechipow, tabejt xotow perjumamint japontat. ");
INSERT INTO guoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Do jawʉt, Jesús japox jʉmtaen wʉt, jʉm-aechon: —¡Nej ja-aeche'! ¿Ma-aech xotkat japox jʉm-am japowliajwa? Japow japox is wʉt, pachaem xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pomatkoicha xamalxotaxael kejila kajachawaesliajwam. Kejila kajachawaesasiam wʉt, kajachawaesaxaelam nejmachmatkoitat. Pelax xan piachaxinil xamalxot. ");
INSERT INTO guoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Japow japox is wʉt, ispow xajʉppoxtat. Japow perjumamintat nata'chafan wʉt, nachawʉajnachaemt xan tajpatʉpaxliajwa namʉthsliajwapox. ");
INSERT INTO guoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Diachwʉajnakolax xan jʉm-an. Tajnachala potʉajnʉcha jiw naewʉajan wʉti chimiawʉajan, tajwʉajan, asew jiw naexasit wʉt bʉ'weliajwas, do jawʉtbej, tajnachala jʉmchiyaxael japow ispoxliajwa xanliajwa. Jasoxtat puexa jiw nejchaxoelaxael japowliajwa —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kaen Jesús pejnachalan, Judas Iscariote, japontat dosanpon, japon fʉlaech sacerdotespaklochow poxade nospaeliajwapon, japi sʉapich, asamatkoi Jesús wiasliajwapon japixot. ");
INSERT INTO guoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Paklochow japox jʉmtaen wʉt, xabich nejchachaemil. Do jawʉt, jʉm-aechi Judasliajwa: —Jesús wiatam wʉt xanalxot, xanal mosaxaelen —aechi. Do jawʉx, Judas wʉajnawet, ma ipachaemdo', japamatkoitat wiasliajwapon Jesús padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Matxoelamatkoi fiesta wʉt, judíos xael wʉt pan puthla-eli, japamatkoi patlisox. Japamatkoi ovejas jelti'tpi xʉa'at xaeliajwa. Jawʉt Jesús wʉajnachaemtas pejnachala. Japi jʉm-aech Jesúsliajwa: —¿Ampalelkat xanal naxaeyax isaxaelen Pascuafiestanaxaeyax xanal nabʉ'xaeliajwam? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Do jawʉt, Jesús to'a wʉt kolenje pejnachalan, jʉm-aechon: —¡Xabʉa'de Jerusalén paklowax poxade! Jaxotde kaen aton faenaxaelam, mint xafolpon. ¡Japon aton fʉlfʉlaem! ");
INSERT INTO guoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Lech wʉt ba, ¡jʉm-amo japabapijin: ‘Jiw chanaekabʉanan jʉm-aech: ¿Ampabatutatkat xan tajnachala bʉ'xaeyaxaelen Pascuafiestanaxaeyax?’ —aech jiw chanaekabʉanan —amo bapijin! ");
INSERT INTO guoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Do jawʉt, bapijin xamal itpaeyaxael athʉ pejpiezax, japabatu pinjiyax. Chajia wʉajna chiekal chaemtas. Jaxot naxaeyax xamal isaxaelam xatisliajwa —aech Jesús, pejnachala to'a wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Do jawʉt, Jesús kolenje pejnachalan fʉlaechlisi Jerusalén paklowax poxade. Jaxotde pa'a wʉti, puexa, me-ama Jesús chajia jʉmtispi, japox ja-aech. Samata, jaxot islisi naxaeyax Pascuafiestaliajwa, Jesúsliajwa, asew pejnachalaliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tuila wʉt, Jesús, pejnachala sʉapich, pat japabaxot. ");
INSERT INTO guoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Do jawʉt, xael wʉt, Jesús jʉm-aech: —Diachwʉajnakolax xan jʉm-an. Kaen xamalxot, xan sʉapich xaelpon, japonlap xan nawiasaxael tadaelmajiwxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pejnachala japox jʉmtaen wʉt, xabich nejxaejwas. Samata, kaenanʉla wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —¿Xankatlap wiasaxaelen xam? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús jʉmnot wʉt, jʉm-aechon pejnachalaliajwa: —Kaen, xamalxot dosampim, japonlap xan nawiasaxael tadaelmajiwxot. Kaeplaftat, xan sʉapich, panax taxthotpon, japonlap xan nawiasaxael tadaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Xan, puexa jiw pakoewkolnan, naboesaxaeli. Me-ama Dios pejjamechan chajia jʉm-aech xanliajwa, diachwʉajnakolax japox jachiyaxael. Pe nawiasaxaelon tadaelmajiwxot, japonliajwa kaes pejme chaemilaxael. Kaes pejme pachaemaxael, japon nalaels-el wʉt ampathatat —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Japi xael wʉt, Jesús panax fit. Do jawʉt, Jesús Dios kawʉajan wʉt, jʉm-aechon: “Ax, gracias-an xanal pan nachaxdutampoxliajwa” —aech Jesús, Dios kawʉajan wʉt. Do jawʉt, Jesús jalkafʉl pan, pejnachala kexadiajsliajwa. Chaxduwpon pejnachala xaeliajwa. Do jawʉt, Jesús jʉm-aech: —¡Xaem ampapan! Japox, me-ama tajwit —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Do jawʉt, Jesús copa chafit puexa pejnachala fiaflaliajwa. Do jawʉt, jʉm-aechon Diosliajwa: “Ax, gracias-an ampotliajwa nachaxdutampot” —aech Jesús pax Diosliajwa. Do jawʉt, japot chaxdutlison japi puexa kaenanʉla fiaflaliajwa. Do jawʉt, japi kaenanʉla puexa fiafʉl. ");
INSERT INTO guoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús jʉm-aech pejnachalaliajwa: —Ampot vino, me-ama tajjal. Xan tʉpx wʉt puexa jiwliajwa, tajjal nakolaxael. Japox jiw naexasit wʉt, beltaeyaxaes babijaxan ispoxanliajwa tajjal pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Diachwʉajnakolax xan jʉm-an. Pejme feyaxinil vino ampathatat. Dios puexa pejjiw tato'almatkoi pat wʉt, japamatkoi pat wʉt, pejme pajelt vino feyaxaelen Diosxotse —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jajuiyax bʉxtoet wʉt salmos, fʉlaechlisi Olivonaechanmʉax poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jaxotde pa'a wʉt, Jesús chajia jʉm-aech pejnachalaliajwa: —Xamal nasalaxaelam nejlel, puexa kofaxaelam xot xan naxanaboejampox. Jasox jʉm-aech Dios pejjamechan, chajia lels wʉt xanliajwa: ‘Boesaxaes ovejas tataefʉlpon. Ja-aech wʉt, pejew ovejas nasalaxael pejlel’ —aech Dios pejjamechan xanxot xamal nasalaliajwampox. ");
INSERT INTO guoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Xan naboesa wʉti, do jawʉx, Dios namat-esaxael pejme dukaliajwan. Do baxael, xamal wʉajna xan pasaxaechan Galilea tʉajnʉxotde —aech Jesús, chajia jʉm-aech wʉt pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Do jawʉt, Pedro jʉm-aech: —Puexa asew nejnachala kofa wʉt pejxanaboejaxan xamliajwa, xanlax kofsaxinil tajxanaboejsax xamliajwa. Xan nakiowa xam xanaboejsfʉlaxaelen —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús jʉmnot wʉt, jʉm-aechon Pedroliajwa: —Diachwʉajnakolax xan jʉm-an. Ampamadoitat kawaema nejlae-el wʉtfʉk koleveces, xan naxanaliyaxaelam wʉt, jʉmchiyaxaelam tres veces: “Xan japon aton matabijs-enil” —chiyaxaelam xanliajwa —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro pejme jʉm-aech nejthʉ'axtat: —Lach nejmachjiw najʉm-aechal wʉt xanliajwa: ‘Xam boesaxaelen, Jesús pejnachalnam xot’ —na-aechal wʉt, xan tajut xanaliyaxinil —aech Pedro. Puexa Jesús pejnachala japox kaeyax jʉm-aechi, Pedro matxoelajʉm-aechpox. ");
INSERT INTO guoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Do jawʉt, Jesús, pejnachala sʉapich, pat Getsemaníxot. Jaxotde pa'a wʉt, jʉm-aechon pejnachalaliajwa: —¡Amxot chalakde! Xan wʉajnaxaechan taj-ax Dios kawʉajnaliajwan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesús bʉflaech Pedro, Santiago, Juanbej. Do jawʉt, Jesús xabich nejxaejwas. Xabich nejchaxoelbejpon japon tʉpaxaelpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jesús jʉm-aech pejnachalaliajwa: —Xan xabich nanejxaejow. Nejxaejwaxtat, me-ama tʉpasian wʉt, ja-an. ¡Amxot chalakde! ¡Naliasfʉldebej! ¡Nabej moejs! —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Do jawʉt, Jesús tamach kaes atʉaxach fʉlaech. Jaxotde brixtat nuk wʉt, sat makxabijindikon. Nejxasinka-elon japanabijasax moxpox japonliajwa. Samata, pax Dios kawʉajan wʉt, jʉm-aechon: “Ax, xam xajʉpam puexa isliajwam. Xanliajwa asax isasiam wʉt, ¡nabʉ'wem nabijasaxaelenpox! ¡Pe nabej is xan nejxasinkaxpox! ¡Isde xam nejxasinkampox!” —aech Jesús, pax Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Do jawʉt, Jesús kaxade pejnachala poxade. Pe Jesús pejnachala nakiowa moejt Jesús wʉajna. Japixot pat wʉt, jʉm-aechon Simón Pedroliajwa: —Simón, ¿ma-aech xotkat nakiowa moejtam? ¿Xamalkat xajʉpa-emil naliasliajwam kaehora? ");
INSERT INTO guoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","¡Naliasfʉlde Dios kawʉajnaliajwam! Ja-am wʉt, Dios xamal kajachawaesaxael babijax isasamatam. Nejnejchaxoelaxantat isasiam pachaempoxan, xan jʉm-anpoxan. Pe nejbʉ'an chiekal mamnika-el japoxan isliajwam —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pejme Jesús kaxade Dios kawʉajnaliajwa. Majt kawʉajanpox, pejme japox jʉm-aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jesús bʉxtoet wʉt, pejme kaxadin wʉt, pejnachala nakiowa moejtfʉki. Asbʉan jʉmch moejti, xabich itmoejsla xot. Matabija-eli jʉmchiliajwa, padala xoti. ");
INSERT INTO guoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesús pejme kaxade Dios kawʉajnaliajwa. Do jawʉx, pejme kaxadin wʉt pejnachala poxadin. Pat wʉton japixot, japi nakiowa moejti. Do jawʉt, jʉm-aechon: —¿Xamalkat moejtam, damlam xot? ¡Nadoklado' moejsax! Amwʉt xan, puexa jiw pakoewkolnan, nawiasaxael babejchowxot. ");
INSERT INTO guoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Nanim! ¡Chijias amxot! Mox fʉlaenlison xan nawiasaxaelon tadaelmajiwxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús naksiya wʉtfʉk, Judas pat. Japon kaen Jesús pejnachalan, japontat doce. Xabich bʉ'paton jiw. Japi xafol espada, iwabej. Japi jiw fʉlaen, to'as xoti sacerdotespaklochow, judíos chanaekabʉanapibej, judíos-ancianosbej. ");
INSERT INTO guoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, wiasaxaelon Jesús padaelmajiwxot, japon chajia chiekal chanaekabʉana japi jiw chiekal matabijaliajwapi Jesús. Jʉm-aechon: “¡Jaelde xan xusuiyaxaelenpon! ¡Chiekal bʉflaem wesamatapon!” —aech Judas, chanaekabʉana wʉt japi jiw chiekal matabijaliajwa, achan Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Do jawʉt, Judas mox soepan wʉton Jesúsxot, kejacha wʉt, jʉm-aechon Jesúsliajwa: —¡Tajpaklon, xan patx! —aech Judas. Do jawʉtbej, xusuwpon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jawʉt Jesús jaeltas bʉflaeliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Do jawʉt, Jesús pejnachalan, mox jaxot nukpon, jukcha pej-espada. Jawʉt nabichan cho'chikchapon. Cho'chikchaspon nabist sacerdotespaklokolanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús jʉm-aech japi jiwliajwa: —¿Ma-aech xotkat espada xafolam, iwabej, xan najaelsasiam wʉt? ¿Xankat, me-ama babejnan wʉt, kabʉan-an xamalliajwa? ");
INSERT INTO guoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaematkoisfʉl xamal naewʉajnax Dios pejtemplobatat. Jaxot najaels-emil, Dios tapae-el xotfʉk xamal. Dios pejjamechan profetas chajia lelpox, jaxot chajia jʉm-aech japox jachiliajwa xanliajwa. Samata, ja-aechlisox —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Do jawʉt, Jesús pejnachala puexa dʉkplisi asalel. Jesús tamach waeltas. ");
INSERT INTO guoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jawʉt kaen pansian atʉaxach wʉlchakal fol, Jesús jaeltas wʉt. Japon, wʉchakalfolpon, naxkiat sábanabʉ'. Japonbej jaeltas. ");
INSERT INTO guoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jaeltas wʉt, pejsábana wejaeltaspon. Jawʉt pejsábana jolchapon. Dolison bʉ'jʉmchawiapon. ");
INSERT INTO guoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Japi bʉflaech Jesús sacerdotespaklokolan pejba poxade. Jaxotde natameja puexa sacerdotespaklochow, judíos-ancianosbej, judíos chanaekabʉanapibej. (Japi paklochow natameja wʉt, japox pawʉl Junta Suprema.) ");
INSERT INTO guoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro atʉaxach wʉchakal fol, Jesús bʉ'fos wʉt. Wʉchakal paton sacerdotespaklokolan pejbafʉlmaktxot. Jaxot jit naksu'cha-ekon, Dios pejtemploba weti sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Do jawʉt, sacerdotespaklochow, puexa judíos-ancianosbej, japi taesia Jesús tʉppox. Samata, japi nakaewa nawʉajnachaemti, Jesús pejbʉ'wʉajan wʉt boesaliajwapi Jesús. Pe faena-eli Jesús pejbʉ'wʉajanpox tasalaliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Xabich jiw kichachajba Jesús tasalaliajwas. Japi wʉajan chapaei wʉt, chiekal kaeyax chapae-eli, kichachajba xoti. ");
INSERT INTO guoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Asew jiw nana wʉt, jʉm-aechi: —Xanal jʉmtaenx, Jesús jʉm-aech wʉt: ‘Xan Dios pejba, jiw ispox, toesaxaelen. Do jawʉx, tres matkoi wʉt, xan asaba isaxaelen, jiw isaxilox’ —aech wʉton —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jesús jʉm-aechpox japi chapaei wʉt, chiekal kaeyax pae-eli. ");
INSERT INTO guoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Do jawʉt, sacerdotespaklokolan nanton puexa jiw pejwʉajnalel, wʉajnachaemsliajwapon Jesús. Do jawʉt, wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Ma-aech xotkat xam jʉmnos-emil? ¿Diachwʉajnakolaxkat japi jʉm-aechpox xamliajwa? —aech sacerdotespaklokolan. ");
INSERT INTO guoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús boejlach nuk. Jʉmnos-elon wʉajnachaemtaspox. Sacerdotespaklokolan pejme wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Xamkat Cristowam, Dios to'asponam jiw bʉ'weliajwa? ¿Xamkatlap Dios paxʉlnambej? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús jʉmnot wʉt, jʉm-aechon: —Diasdo'. Xanlap japonan. Xan, puexa jiw pakoewkolnan, xan ekaxaelen taj-ax Dios pejpoklalel. Japon pamamakolan. Jaxotse xan ekaxaelen, taj-ax sʉapich, jiw tato'laliajwan wʉt. Xamal japox taeyaxaelam, xan fʉloekx wʉt athʉlelsik itloejentat —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Do jawʉt, sacerdotespaklokolan pijax, naxoelax, thiakchapon, xabich palala xot Jesúsliajwa, jʉmtaen xoton Jesús jʉm-aechpox. Do jawʉt, jʉm-aechbejpon: —Kaes asew jiw nakwewe'pa-el ampon aton tasalaliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Xamal najut chiekal jʉmtaenam, ampon aton jʉm-aech wʉt Dios nejweslapox. ¿Xamal achax nejchaxoelam ampon aton jʉm-aechpoxliajwa? —aech sacerdotespaklokolan. Do jawʉt, puexa chiekal kaeyax nejchaxoel wʉt, jʉm-aechi: —Ampon aton xabich pejbʉ'wʉajan Diosliajwa. Wewe'pas kastikaliajwas, boesaliajwasbejpon —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Asew japixot xuloyapi Jesús. Itfumatakʉsbejpon. Do jawʉt, xutulapason kerixtat. Tulapas wʉt, jʉm-aechipon: —Xam Cristowam wʉt, ¡jʉm-amde! ¿Achankat xam xutulap? —aechi. Do jawʉx, asew, Dios pejtemploba weti, japibej tulap Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Do jawʉt, Pedro bafʉlmaktat nuk wʉt, kaeow atow pat Pedro nukxot. Japow sacerdotespaklokolan tanbistow. ");
INSERT INTO guoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Japow taen Pedro jit naksu'chanukpox. Do jawʉt, chiekal natachaemtow Pedro. Jawʉtbej jʉm-aechow: —Xambej nanʉamtam, Jesús Nazaretpijin sʉapich —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro pajut naxanalia wʉt, jʉm-aechon: —Xan matabijs-enil xam najʉm-ampox. Xan japon aton matabijs-enil —aech Pedro. Do jawʉt, fʉlaechlison bafafa poxade. Jaxot atʉaxach nuklison laleyaxxot. Do jawʉt, kawaema nejla. ");
INSERT INTO guoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Japow pejme taen Pedro. Samata, jʉm-aechow asew jiw jʉmtaeliajwas, jaxoti: —¡Ama kaen nuk, Jesús pejnachalan! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Do jawʉt, Pedro pejme pajut naxanalia wʉt, jʉm-aechon: —Diachwʉajnakolax xan japon pejnachalna-enil —aech Pedro. Do jawʉx, jaxot nuili jʉm-aechbej: —Diachwʉajnakolax xam Jesús pejnachalnam. Xambej Galilea tʉajnʉpijnam —aechi Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro jʉm-aech: —Diachwʉajnakolax jʉmchi-enil wʉt, ¡Dios xan nej nakastike'! Xan matabijs-enil japon aton —aech Pedro, pajut naxanalia wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Do jawʉt, kawaema pejme nejla wʉt, jawʉt Pedro nejchafaet Jesús chajia jʉm-aechpox, jʉm-aech wʉton: “Kawaema nejlae-el wʉtfʉk koleveces, xam naxanaliyaxaelam tres veces” —aech Jesús Pedroliajwa. Do jawʉt, Pedro xabich nejxaejwas. Jawʉt xabich nowpon. ");
INSERT INTO guoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nalian wʉt, sacerdotespaklochow, judíos-ancianosbej, judíos chanaekabʉanapibej, puexa judíospaklochowbej, japi puexa natameja kaeyaxtat chiekal nospaeliajwa. Do jawʉx, Jesús bʉ'follisi mʉaxmatakuyaxtat Pilato poxade. Do jawʉt, wiatlisipon Pilatoxot. ");
INSERT INTO guoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Do jawʉt, Pilato wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Xamkatlap diachwʉajnakolax reynam puexa judíosliajwa? —aech Pilato. Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xanlap japonan, xam najʉm-amponan —aech Jesús Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Do jawʉt, sacerdotespaklochow nejmachwʉajantat xabich tasalapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Samata, Pilato pejme wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Xamkat jʉmtae-emil japi jʉm-aechpox nejbʉ'wʉajanpoxliajwa? ¿Ma-aech xotkat xam jʉmnos-emil japi jʉm-aechpoxanliajwa? —aech Pilato Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Do jawʉt, Jesús kaes jʉmnos-el. Boejlach nuklison. Samata, Pilato xabich nejchaxoela-ek Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Powaecha, Pascuafiesta wʉt, Pilato kaen aton nakolsax jitapaei, jiw jebatat jiaspon. Tapaeipon nakolsax judíos wʉljowpon. ");
INSERT INTO guoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jawʉt jiw jebatat jiaspixot, kaen japixot pawʉl Barrabás. Japon, asew sʉapich, jiw ba, japi chajia naba wʉt, Pilato pejsoldaw sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Do jawʉt, xabich judíos pat Pilato pejbaxot. Pat wʉt, jʉm-aechlisi Pilatoliajwa: —¡Kaen jiw jebatat jiason, tapaem nakolsliajwa, me-ama powaecha xam jitapaeyam, Pascuafiesta wʉt! —aechi Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato jʉmnot wʉt, jʉm-aechon: —¿Xamalkat nejxasinkam xan nakolsax tapaeliajwan judíos pejrey? —aech Pilato judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato japox jʉm-aech, nejchaxoel xoton: “Sacerdotespaklochow wiati xanxot Jesús, japi xabich nusasiawal xot Jesúsliajwa” —aech Pilato, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Do jawʉt, sacerdotespaklochow bʉxto'a japi jiw wʉljoeliajwa Barrabás nakolsax tapaeliajwas. Bʉxto'a wʉt, jʉm-aechi: “¡Jʉm-amde Pilato: ‘¡Nawoesa nakolsax tapaem Barrabás!’ —amde!” —aech sacerdotespaklochow. Samata, japi jiw wʉljoefʉl Barrabás nakolsax tapaeliajwas. ");
INSERT INTO guoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato jʉmtaen wʉt japi jiw wʉljoefʉlpox Barrabás, jawʉt Pilato japi jiw wʉajnachaemt wʉt, jʉm-aechon: —¿Machiyaxaelenkat Jesús, japon pawʉlpon Judíos Pejrey? —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Do jawʉt, japi nejlasaxtat jʉmnot wʉt, jʉm-aechi: —¡Japonlax kematamatalde cruztat tʉpaliajwa! —aech japi jiw, nejlasfʉl wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato jʉm-aech: —¿Achababijaxkaton is cruztat kematamatlaliajwas? —aech Pilato. Pe kaes pejme nejlasfʉl wʉt, jʉm-aechfʉllisi: —¡Kematamatalde cruztat! —aechfʉli. ");
INSERT INTO guoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Do jawʉt, Pilato Barrabás nakolsax tapaei jiw jebaxot, japi jiw palalasamata Pilatoliajwa. Do jawʉtbej, Pilato keto'a pejsoldaw Jesús selsliajwas. Selsax ketoech wʉt, Pilato keto'abej pejsoldaw Jesús kematamatlaliajwas cruztat. ");
INSERT INTO guoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Do jawʉt, Jesús bʉ'fos soldaw Pilato pejbafʉlmak poxade. Jaxotde puexa soldaw natameja. ");
INSERT INTO guoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Do jawʉt, xajoeslison pakchowax, me-ama rey pijax, jasox. Japox chikjiana pasoeyaxlejen. Do jawʉt, na-e'lʉ xakoeyax ketoet wʉt, matlʉa'lisipon. ");
INSERT INTO guoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Do jawʉtbej, Jesús pejwʉajnalel jʉmtaxaxaelal wʉt, jʉm-aechi: —¡Moi, judíos pejrey! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Do jawʉt, kaenanʉla soldaw ta'be'balapi naeyatat Jesús. Loyasbejpon. Jesús pejwʉajnalel brixtat nuili. Me-ama sitaen wʉt, ja-aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Dolisi, ketaxaxaelax ketoech wʉt, joltlisi chikjiana pasoeyax. Do jawʉt, xajoeslison pejme pijaxkolax, naxoelax. Do jawʉt, bʉ'folisipon kematamatlaliajwas cruztat. ");
INSERT INTO guoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Do jawʉt, kaen aton fʉlaen paklowax tathoetlel. Japon pawʉl Simón. Japon Cirene paklowaxpijin. Paxi pawʉl Alejandro, asan pawʉl Rufo. Simón xensliajwa wʉt, jawʉt soldaw xato'aspon xalaeliajwa Jesús pijax, cruz, Jesús xafolpox. ");
INSERT INTO guoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Japi soldaw bʉflaech Jesús mʉax poxade. Japamʉax pawʉl Gólgota. (Gólgota jʉmchiliajwa hebreojametat: “Matnaethitmʉax” —chiliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jaxotde Jesús chaxduchlach vino, mirra tanialtaspox, xabich wexaenkasamatas, kematamatlas wʉt. Pe Jesús fe-el. ");
INSERT INTO guoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Do jawʉt, Jesús kematamatlas cruztat. Pejtʉakanbej matamatlas. Do jawʉtbej, soldaw nakakujt ia'xix matabijaliajwa, achan kanaxael kaenanʉla Jesús pejnaxoe. ");
INSERT INTO guoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Juimt atʉajsan wʉt, a las nueve wʉt, Jesús kematamatlas. ");
INSERT INTO guoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesús pejta' tabijla tablafach lelspox chaduch. Japox jʉm-aech, ma-aech xot Jesús kematamatlas cruztat. Japox jʉm-aech: “Ampon judíos pejrey” —aech lelspox. ");
INSERT INTO guoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jaxotde kematamatlasbej kolenje kethakan. Kaen chanuk Jesús pejpoklalel. Asan chanuk Jesús pejsoenalel. ");
INSERT INTO guoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jesús cruztat kematamatlas wʉt, asew kolenje sʉapich, japox ja-aechlisox, me-ama Dios pejjamechan, chajia lelspox, jʉm-aech: “Japon kastikaxaes. Me-ama babejen wʉt, jakechiyaxaeson” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Asew jiw, jaxot xaxenapi, jʉm-aech babejjamechan Jesúsliajwa. Matnaexawiltbejpi. Matnaexawilt wʉt, jʉm-aechi: —Xam chajia jʉm-am: ‘Dios pejtemploba xan toesaxaelen. Do jawʉx, tres matkoi wʉt, xan pejme mat-esaxaelen’ —am xam, chajia jʉm-am wʉt. ");
INSERT INTO guoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Amwʉtjel najut nabʉ'wem! ¡Baloemk cruzxotsik! —aech jiw xaxenapi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Do jawʉt, sacerdotespaklochowbej, judíos chanaekabʉanapibej, bʉ'wʉajanpaeipi Jesús. Nakaewa najʉm-aechi: —Asew jiw bʉ'wiapon. Pe pajut xajʉpa-elon nabʉ'weliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Diachwʉajnakolax Cristo wʉt, Israel tʉajnʉpijiw pejrey wʉtbej, ¡amwʉtjel japon pajut nej baloesk cruzxotsik! Japox xatis taens wʉt, ja-aech wʉt, xatis japon naexasisaxaes diachwʉajnakolax japon Cristo —na-aechi nakaewa Cristoliajwa. Japi kolenjebej, cruztat kematamatlaspi, Jesús sʉapich, japibej bʉ'wʉajanpaei Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Juimt matnoch ek wʉt, xabich itkʉatnik tres horas. Japox ja-aech wʉt, ja-aech potʉajnʉcha. ");
INSERT INTO guoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Do jawʉx, a las tres wʉt, Jesús pinjametat jʉm-aech: “Eloi, Eloi, ¿lema sabactani?” —aechon pejjametat, hebreojametat. (Japox jʉmchiliajwa: “Ax Dios, ax Dios, ¿ma-aech xotkat xan nakajachawaes-elaxtat nawaeltam tamach?” —chiliajwapox.) ");
INSERT INTO guoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Asew jaxoti, japox jʉmtaen wʉt, jʉm-aechi: —¡Jʉmtaem! Japon wʉllalat Elías, Dios pejprofeta —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kaen japixot wʉljaet esponja, paputhkax, xathosliajwa vino, xathuyamint. Do jawʉt, esponja matakupon nae-oeftat Jesús japox suiliajwa. Japon jʉm-aech asew jiw jaxotiliajwa: “Taeyaxaes. Elías bej fʉloeyaxoekbej kusliajwapon Jesús cruzxotsik” —aechi. ");
INSERT INTO guoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Do jawʉt, Jesús nejlakcha wʉt, tʉplison. ");
INSERT INTO guoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesús tʉp wʉt, Dios pejtemplobatat pinabʉ', duchpox batutat, najʉpathiakchakas athʉlelsik satleldik. ");
INSERT INTO guoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldawcapitán Jesús pejwʉajnalel nukpon. Taen wʉton Jesús tʉppox, jawʉt jʉm-aechon: —¡Diachwʉajnakolax ampon Dios paxʉlan! —aech capitán. ");
INSERT INTO guoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jaxotbej watho' atʉaxach nuil. Natachaemapi Jesús. Japixot María. Japow Magdala paklowaxpijow. Asaow pawʉlpowbej, María, japow José pen, Santiago penbej. Japon Santiago kaes pansian. Jaxotbej asaow, pawʉlpow Salomé. ");
INSERT INTO guoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Japi watho' Jesús naknanʉamt, pejnachala sʉapich, Galilea tʉajnʉxot. Japi watho' kajachawaetbejpi Jesús, nanʉamt wʉti Galilea tʉajnʉxot. Xabich asew watho' jaxotbej nuil. Japi watho' fʉlaen, Jesús sʉapich, Jerusalén paklowax poxadin. ");
INSERT INTO guoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","José Arimatea paklowaxpijin. Japon judíospaklochowxot paklonbej, Junta Supremapijin. Japon xabich sitaens. Japon José wʉajnawet Dios puexa pejjiw tato'laxaelpox. Napatamatkoi wʉajna, japamatkoi puexa jiw chiekal chawʉajnachaemt napataliajwa. Japamatkoi pawʉl chawʉajnachaemsmatkoi. Do jawʉt, japamatkoi kaliax wʉtlejen, José fʉlaech Pilato poxade. José pejlewla-el, pat wʉton Pilatoxot. José kawʉajan Pilato fisliajwapon patʉpan Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato nejchaxoel: “Jesúskas kamta tʉp” —aechon, nejchaxoel wʉt. Samata, Pilato wʉllala soldawcapitán. Soldawcapitán pat wʉt, Pilato wʉajnachaemt wʉt, jʉm-aechon soldawcapitánliajwa: —¿Diachwʉajnakolaxkat Jesús tʉp? —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Soldawcapitán jʉmnot wʉt, jʉm-aechon: —Diasdo'. Jesús tʉplison —aechon. Do jawʉt, Pilato to'a pejsoldaw, japi soldaw tapaeliajwapi José xalaeliajwa patʉpan Jesús. ");
INSERT INTO guoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Do jawʉt, José wʉajt chimiabʉ', sábana. Do jawʉx, José fʉlaech patʉpan chanuk poxade. José pat wʉt patʉpan chanukxot, kuwpon Jesús kematamatlaspoxan, tʉakmatamatlaspoxanbej, cruztat. Do jawʉx, José otlison patʉpan Jesús mʉaxwʉajtat. Do jawʉt, ia't pinjit, jajaerat, matariaman mʉaxwʉaj fakasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jawʉt María Magdalena paklowaxpijow, asaow Maríabej, japow José pen, japi watho' taeni patʉpan mʉaxwʉajtat ochxot. ");
INSERT INTO guoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Do jawʉx, napatamatkoi toep wʉt, juimt tujop wʉt, María Magdalena paklowaxpijow, asaow Maríabej, japow Santiago pen, Salomé sʉapich, xabejasapan wʉajti patʉpan Jesús joelaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kandiawasap wʉt, dominkomatkoi wʉt, juimt julan wʉt, japi watho' fʉlaechlisi patʉpan och poxade. ");
INSERT INTO guoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Japi watho' nʉamtat fol wʉt, nakaewa najʉm-aechi: —Patʉpan Jesús ochxot, japawʉaj faka'ch ia't, pinjitat. ¿Achankat japot ia't wʉlnakwematariaman xatis leliajwas patʉpanwʉaj? —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pe pat wʉti patʉpanwʉajxot, japi watho' taen ia't fafatat nuka-elpox. Asalelaxach nukox. ");
INSERT INTO guoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Samata, japi watho' low patʉpan ochxot. Jaxot kaen pansian taeni. Ekon poklalel. Naxoelox xabich papoeyax. Pakchowaxbejpox. Japi watho' beljow, taen wʉti papoeyax naxoelan. ");
INSERT INTO guoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Do jawʉt, japon pansian jʉm-aech: —¡Nabej belwe'! Xan matabijtax, xamal fʉlaeman Jesús Nazaret paklowaxpijin taeliajwam, japon kematamatlaxtat cruztat tʉpon. Pe Jesús mat-echlison. Pejme amwʉtjel duklison. ¡Taem chiekal ochxot! Amxot ajillison. ");
INSERT INTO guoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","¡Xabʉa'de japon pejnachala poxade japi chapaeliajwam! Chapaeyam wʉt, ¡Pedrobej chapaem! ¡Jʉm-amopi: ‘Xamal wʉajna Jesús wʉajnaxael Galilea tʉajnʉ poxade. Jaxotde Jesús taeyaxaelam. Me-ama chajia jʉm-aechon xamalliajwa, jachiyaxaelon’ —amopi, chapaeyaxaelam wʉt! —aech ángel. ");
INSERT INTO guoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Japi watho' japox jʉmtaen wʉt, jaxot nakolapi. Do jawʉt, dʉkplisi. Do jawʉtbej, xabich tathʉlal, beljow xoti. Chapae-eli asew jiw, xabich pejlewla xoti.  ");
INSERT INTO guoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Napatamatkoi toep wʉt, dominkomatkoiliajwa nalian wʉt, Jesús mat-ech pejme dukaliajwa. Mat-ech wʉt, matxoela natulaelton María Magdala paklowaxpijowxot. Jesús, tʉpa-el wʉtfʉk, siete dep nakolax to'apon japow pejmatpʉatxot. ");
INSERT INTO guoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María taen wʉt Jesús, jawʉt fʉlaechow Jesús pejnachala poxade. Japi wʉajna now, nejxaejwas xoti Jesúsliajwa. Jawʉt María chapaei taenpox. ");
INSERT INTO guoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jʉm-aechow: —¡Jesús mat-echlison! ¡Amwʉtjel pejme duklison! ¡Xan tajut chiekal taenx Jesús! —aechow. Pe Jesús pejnachala naexasis-el japow chapaeipox Jesús taenpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Do jawʉx, Jesús natulaelt kolenje pejnachalanxot, japi laelp wʉt paklowax tathoetlel. Jesús natulaelt wʉt, me-ama asan wʉt, jakabʉan-aechon japixot. ");
INSERT INTO guoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Do jawʉx, japi kolenje nawia asew pejnachala poxade chapaeliajwa taenpox. Japibej naexasis-esal, chapaei wʉti Jesús taenpox. ");
INSERT INTO guoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Do baxael, Jesús natulaelt once pejnachalaxot, japi naxael wʉt. Jaxot Jesús lot pejnachala. Lot wʉt, jʉm-aechon japiliajwa: —¿Ma-aech xotkat xamal naexasis-emil? ¿Ma-aech xotbejkat matnaetinkam naexasisliajwam asew jiw, xamalxot nataeni, chapaei wʉti xamal: ‘¡Jesús mat-echlison! ¡Amwʉtjel pejme duklison!’ —aech wʉt japi jiw? —aech Jesús, lot wʉt pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús pejme jʉm-aech pejnachalaliajwa: —¡Xabʉa'de puexa jiw naewʉajnaliajwam chimiawʉajan, potʉajnʉchanpijiw! ");
INSERT INTO guoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xan nanaexasitpi, ¡japi bautisam Dios bʉ'weliajwas! Asew jiw naexasis-elpi, japilax Dios pelsaxaes infierno poxadik. ");
INSERT INTO guoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Xamal naexasisaxaelpi, japi jiw tajaxtat to'axaeli dep nakolaliajwa jiw pejmatpʉatanxot. Naksiyaxaelbejpi asew jiw pejjamechan, majt matabija-eljamechan naksiyaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Japi jom jaela wʉt, liklaxisal. Veneno af wʉtbej, tʉpaxili. Jiw bʉ'xaeya boejthʉsaxael, pejke-etat jacha wʉt —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Do jawʉx, Jesús wajpaklokolan, naksiyax bʉxtoet wʉt pejnachalaliajwa, Dios bʉ'foslison athʉ poxase. Ma amwʉtjel Jesús ek Dios poklalel jiw tato'laliajwa, Dios sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Do jawʉx, Jesús pejnachala follisi potʉajnʉcha jiw naewʉajnaliajwa. Dolis japi naewʉajnalap chimiawʉajan, Jesucristo pejwʉajan. Ja-aech wʉt, Jesús kajachawaesfʉl pejnachala. Naewʉajan wʉti chimiawʉajan, isbejpi koechaxan. Samata, jasoxtat xabich jiw matabija chimiawʉajan diachwʉajnakolaxpox.");
INSERT INTO guoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jesús tʉadut wʉt naewʉajnax ampathatat, xabich jiw taenson. Asew japixot taen, Jesús nabijat wʉt. Taenpi, japi jiw, potʉajnʉcha naewʉajan Jesús pejwʉajan. Asew jiw jʉmtaenpi Jesús pejwʉajan, japi jiwbej lel jʉmtaenpoxan, asew jiwbej matabijaliajwa Jesús pejwʉajan, japon naewʉajanpoxanbej. ");
INSERT INTO guoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Xan Lucas wʉajnachaemtax jiw matabijapi japawʉajan, xanbej chiekal matabijsliajwan. Teófilo, puexa jiw xam sitaenponam, lelx ampawʉajan xam chiekal matabijsliajwam Jesús pejwʉajan. Lelx wʉt ampawʉajan, nejchaxoelx: “Xan lelx Jesús ispoxanliajwa, Teófilo chiekal matabijsliajwa diachwʉajnakolaxpox, asew jiw majt naewʉajanpoxanliajwa, Jesús pejwʉajanliajwa” —an, nejchaxoelx wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Rey Herodes, Judea tʉajnʉpijiw tato'al wʉtfʉk, japamatkoiyan sacerdote duk. Japon pawʉl Zacarías. Sacerdotesxot kaemʉt pawʉl Abías. Zacarías japamʉtpijin. Pijow pawʉl Isabel. Japow Aarón pamow. Zacaríasbej Aarón pamon. Judíosxot Aarón chiekal matxoelasacerdote. ");
INSERT INTO guoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías, pijow sʉapich, chiekal pachaempi Diosliajwa. Chiekal naexasisfʉlbejpi Dios tato'alpox. Samata, chinax kaen aton jʉmchiyaxisal japiliajwa: “Japi chiekal naexasis-el Dios” —chiyaxisal. ");
INSERT INTO guoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pe Isabel xijil, nafoena xot. Japow xabich pati'ow, pamal sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zacarías, pejmʉt sʉapich, naliaxa wʉt nabichliajwa Dios pejtemplobatat, japon fol, pejmʉt sʉapich, nabichliajwa Dios pejbichax. ");
INSERT INTO guoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tʉadusliajwa wʉt nabichliajwa Dios pejtemplobatat, me-ama japi pejkabʉan, majt natamejapi matabijaliajwa, achan Dios makafisaxaes bowaliajwa incienso. Jawʉt Zacarías makafich bowaliajwapon incienso. Do jawʉt, lowpon Dios pejtemploba. ");
INSERT INTO guoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zacarías incienso bowa wʉtfʉk, xabich judíos Dios kawʉajan tathoetlel. ");
INSERT INTO guoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Do jawʉt, Dios pej-ángel chalechkal natulaelt Zacaríasxot. Japon ángel nuk altar poklalel, incienso bowaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías taen wʉt ángel, xabich nejchaxoelon. Xabich beljowbejpon. ");
INSERT INTO guoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Do jawʉt, ángel jʉm-aech: —Zacarías, ¡nabej nejlewle'! Dios xam jʉmtaen nejkawʉajnaxan. Nijow Isabel naxʉwlaxael xam naxʉlanliajwa. Wʉlduiyaxaelampon Juanwʉltat. ");
INSERT INTO guoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Xam xabich nejchachaemlaxaelam naxʉlanliajwa. Asew jiwbej xabich nejchachaemlaxael, xamal sʉapich, xaljamch nalaelt wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Naxʉlan xabich pachaemaxael Diosliajwa. Feyaxilon vino. Feyaxilbejpon saxa. Japoch xaljamch nalaelsaxael wʉt, chanlaelsaxael Espíritu Santo tato'laspox. Samata, japon isfʉlaxael Espíritu Santo tato'laspoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Asamatkoi japon naewʉajan wʉt, xabich judíos kofaxael babijaxan ispoxan, paklokolan Dioskal naexasisfʉlaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Naewʉajnaxaelon wajpaklon wʉajna Dios pejjamechan jiw jʉmtaeliajwa. Me-ama chajiakolaxtat profeta Elías Dios pijaxtat jiw naewʉajnafʉl wʉt, jachiyaxaellap-is Juan. Juan naewʉajanpoxtat poejiw pejme pachaemaxael, paxi sʉapich. Jiw, majt Dios naexasis-eli kaenejchaxoelaxaeli, Dios naexasiti sʉapich. Jasox Juan isfʉl wʉt, jiw chiekal naexasisfʉlaxael, wajpaklokolan pat wʉt —aech ángel, Dios bʉxto'aspox jʉmchiliajwapon Zacarías. ");
INSERT INTO guoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Do jawʉt, Zacarías wʉajnachaemt wʉt ángel, jʉm-aechon: —Xan xabich pati'nan. Tajowbej xabich pati'ow. ¿Machiyaxaelenkat xan matabijsliajwan, najʉm-ampoxan japoch xaljamchliajwa diachwʉajnakolax wʉt? —aech Zacarías. ");
INSERT INTO guoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dios pej-ángel jʉmnot wʉt, jʉm-aech: —Xan Gabriel, Diosliajwa nabistaxponan. Dios nato'ak xam jʉmchiliajwan japox. ");
INSERT INTO guoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Xam naexasis-emil xot xan jʉm-anox, ma amwʉt xam bʉxwʉajnajilaxaelam. Hasta xan jʉm-anox pat wʉt naxʉlanliajwa, jawʉt xam pejme naksiyaxaelam —aech ángel. ");
INSERT INTO guoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zacarías nospaei wʉtfʉk, ángel sʉapich, jiw tathoetlel wʉajnawet. Nakaewa nawʉajnachaemt wʉt, jʉm-aechi: “¿Ma-aech xotkat Zacarías piach kejil nakolsliajwa Dios pejtemplobaxot?” —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Do jawʉt, Zacarías nakolt wʉt, naksiyaxilon. Ja-aech wʉt, wʉajnaweti tathoetat nejchaxoeli: “Zacarías masoxtat bej taenbejpon Dios pej-ángel templobatat” —aechi, nejchaxoel wʉt. Zacarías pejke-etat jiw chanaekabʉanafʉl, naksiyaxil xotlison. Ja-aechfʉlon, bʉxwʉajanjil xoton. ");
INSERT INTO guoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacarías Dios pejbichax toet wʉt templobaxot, fʉlaechon pejba poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Do jawʉx, Zacarías pijow, Isabel, moejow. Cinco juimtje pejbaxot kawetapow. Laeja-elow asalel. Nejchaxoel wʉt, jʉm-aechow: ");
INSERT INTO guoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Dios nakajachawaet. Samata, xan moejwax. Amwʉtjel kaes jiw najʉmchiyaxil: ‘Japow pawis naxʉwlaxil’ —nachiyaxil jiw xanliajwa, naxʉwlaxaelen xot” —aech Isabel, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel naxʉwlaliajwa wʉt, tres juimtje wewe'pas wʉt, Dios to'ak pej-ángel Gabriel Nazaret paklowax poxadik, Galilea tʉajnʉlel. ");
INSERT INTO guoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dios to'ak pej-ángel pawis poxadik, japow pawʉl María, taeliajwaspow. Japow chinax aton bʉ'moejs-esal. Chajia jʉmdutow asamatkoi nakjiyaliajwa, José sʉapich. Japon José, rey David pamon. ");
INSERT INTO guoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ángel pask María dukxot. Pat wʉt, jʉm-aechon: —¡Moi, María! Dios xabich nejchachaemil xamliajwa. Pomatkoicha Dios xam chalafʉl —aech ángel. ");
INSERT INTO guoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María japox jʉmtaen wʉt, xabich nejchaxoelow. Do jawʉt, pajut najʉm-aechow: “¿Achax chiyaxaelkat japox, ángel najʉm-aechpox?” —aechow, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pe Dios pej-ángel jʉm-aech Dios bʉxto'aspox: —María, ¡nabej nejlewle'! Dios xabich nejchachaemil xamliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mox nawʉajna xam moejwaliajwam. Xam naxʉlchaxael. Japoch xaljamch pawʉlaxael Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Japon paklonaxael. Tato'laxaelbejpon Dios pijaxtat. Jʉmchiyaxaeson: “Dios athʉpijin paxʉlan” —chiyaxaeson. Wajpaklon Dios pajut wʉlduiyaxael japon reyliajwa. Me-ama pejwʉajnapijin David, jachiyaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Japon reyaxael, Dios pejjiw pomatkoicha tato'laliajwapon. Japon pejtato'lax toepaxil —aech Dios pej-ángel Maríaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María wʉajnachaemt wʉt, jʉm-aechow: —¿Ma-aech xotkat japox wʉlja-aech xanliajwa, poi fis-enil wʉt? —aechow. ");
INSERT INTO guoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ángel jʉmnot wʉt, jʉm-aechon: —Dios pej-Espíritu Santo fʉloeyaxoek xam poxasik, me-ama itloejen. Do jawʉt, xam moejwaxaelam Dios pejpamamaxtat. Samata, yamxʉch nalaelt wʉt, Dios pijnaxael. ‘Dios paxʉlan’ —chiyaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nejwʉl-atow Isabel, pati'owpow, japow naxʉwlaxael. Jiw jʉmtispow: ‘Japow naxʉwlaxil’ —tispow, naxʉwlaxael. Japow moejowpox seis juimtjelisox. ");
INSERT INTO guoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios xajʉp puexa isliajwa. Ajil Dios xajʉpaxilpox —aech ángel Maríaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María jʉm-aech: —Xan Dios pamakwan. ¡Dios nej is xam najʉm-ampox! —aechow. Do jawʉx, ángel chijia Maríaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dios pej-ángel chijia wʉt Maríaxot, do jawʉt, María thilt. Thilt wʉt, bichakal fʉlaechow Judea tʉajnʉlel, mʉaxan poxade, Isabel dukpaklowax poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jaxotde pa'a wʉt, patow Zacarías pejbaxot. Do jawʉt, María moi-aech Isabelliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabel japox jʉmtaen wʉt, yamxʉch, woejtatpoch, xabich nachoela. Do jawʉt, Isabel jʉm-aech Espíritu Santo pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jʉm-aechow pinjametat Maríaliajwa: —Dios is xabich pachaempox xamliajwa. Me-ama asew watho'liajwa, jachi-el Dios. Dios isaxaelbej xabich pachaempox naxʉlan, nalaelsaxaelponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Xam tajpaklon penaxaelam. Jachiyaxaelam xot, xan kaes pachaempowa-enil xam nataeliajwam. ");
INSERT INTO guoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Xam ‘¡Moi!’ —na-am wʉt, xaljamch, woejtatpoch, xabich nachoela, xabich nejchachaemil xot. ");
INSERT INTO guoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xambej xabich nejchachaemlam, naexasitam xot ángel jʉm-aechpox, Dios pijaxtat jachiyaxaelpox —aech Isabel Maríaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Do jawʉt, María jʉm-aech: “Xan jʉm-an ampox, nejchaxoelx wʉt Diosliajwa. Dios xabich pachaem. ");
INSERT INTO guoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Xan xabich nejchachaemlax, Dios nabʉ'weyaxael xot. ");
INSERT INTO guoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xabich nejchachaemlaxbej, Dios namakafit xot japon pamakwanliajwa. Dios xabich pachaem xanliajwa. Samata, xabich jiw jʉmchisfʉlaxael xanliajwa: ‘Dios is pachaempox Maríaliajwa’ —chisfʉlaxael jiw xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios xabich mamnik puexaliajwa. Ispon xabich pachaempox xanliajwa. Dios kaes pejme pachaem. Me-ama jiw, jachi-el. Kaes ajil, me-ama japon, jason. ");
INSERT INTO guoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dios beltaen jiw, japi sitaenpi Dios. ");
INSERT INTO guoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dios is koechaxan, xabich pachaempoxan. Pe jiw nejchaxoelpi: ‘Xan kaes pejme pachaeman. Me-ama asew jiw, jachi-enil’ —aechi, nejchaxoel wʉt, japi jiw Dios mastaeyaxaes. ");
INSERT INTO guoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dios chiekal toet jiw, tato'alpi ampathatpijiw, japi naexasis-eli Dios. Asew jiwlax nakaewaliajwa jʉm-aechi: ‘Xatis xabich kaes pejme pachaema-esal’ —aech wʉti pajutliajwa, nejchaxoel wʉt, japi Dios wʉlduiyaxaes asew tato'laliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Majt xabich litaxaelapi, japi Dios chaxduwslisi pachaempoxan. Kemaeyalax, Dios to'axaes ke-etat asalelaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dios kajachawaet pejjiw, japi judíospi. Nejkiowa-elon japi beltaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jasoxtat Dios jʉmdut wajwʉajnapijiwliajwa, Abraham, pamojiwbej” —aech María. ");
INSERT INTO guoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María duk tres juimtje Isabel pejbaxot. Do jawʉx, María nawia'a pejba poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isabel wepach pejmatkoi naxʉwlaliajwa. Samata, naxʉwalpow. Faenow poich. ");
INSERT INTO guoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pejjiw, mox duilibej, japox wʉltaena wʉt, taechipow, nejchachaemil xot japowliajwa. Japi jiw matabija, Dios is pachaempox japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kaesemana wʉt yamxʉch nalaeltox, japi jiw fʉlaen xaljamch circuncidaliajwapi, Dios pejmarkaxliajwa. Japox japi pejkabʉan, judíos xot. Jawʉt yamxʉch wʉlduisias pax Zacarías pejwʉltat. ");
INSERT INTO guoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pe Isabel jʉm-aech: —¡El! Pawʉlaxaelon Juan —aechow. ");
INSERT INTO guoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pejjiw jʉmnot wʉt, jʉm-aechi: —Diachwʉajnakolax nejjiwxot chinax kaen pawʉla-el japawʉl —tispow. ");
INSERT INTO guoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Japi taxdoefa wʉajnachaemsliajwa yamxʉlan pax, pax wʉlduiliajwa paxʉlan, me-ama japon nejxasink. ");
INSERT INTO guoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pe jawʉt, Zacarías wʉljow tawlofach, jaxot lelaliajwa. Lelsox jʉm-aech: “Pawʉlaxaelon Juan” —aech Zacarías lelpox. Jawʉt puexa jiw xabich nejchaxoelanuil. ");
INSERT INTO guoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Do jawʉt, chalechkal Zacarías pejme chiekal naksiyapon. Me-ama majt, ja-aechon. Naksiyapon pachaempoxan Diosliajwa. Jʉm-aechon: “Dios, xam xabich pachaemam” —aechon Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Puexa jiw, mox duili, xabich nejchaxoelanuil. Asew jiw Judea tʉajnʉpijiw, mʉaxanlel duili, nachapaefʉl jʉmtaenpox. ");
INSERT INTO guoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Puexa jiw, pajut chiekal jʉmtaenpi, nawʉajnachaemsna wʉt, jʉm-aechi, nejchaxoel wʉt: “Japoch yamxʉch ti't wʉt, ¿machiyaxaelkat?” —aechi, nejchaxoel wʉt, japi chiekal matabija xot Dios kajachawaesfʉlaxaespox. ");
INSERT INTO guoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, japon yamxʉlan paxpon, jʉm-aech Espíritu Santo pijaxtat, jʉm-aech wʉton Dios ispoxliajwa: ");
INSERT INTO guoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Xatis judíos wajDios jʉmchisfʉlaxaes: ‘Xam xabich pachaemam’ —chisfʉlaxaes wajpaklon Diosliajwa. Japox jʉmchisfʉlaxaesbej, to'ak xoton paxʉlan, japon bʉ'weliajwa pejjiw. ");
INSERT INTO guoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dios to'ak pamamakolan xatis nakbʉ'weliajwa. Japon, rey David pamon. David, Dios pamakan. ");
INSERT INTO guoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Japoxliajwa Dios chajia bʉxto'a pejprofetas, jʉmdusliajwa wʉton. Dios jʉmdut to'axaelpox kaen aton, japon nakbʉ'weliajwa wajdaelmajiwxot, puexa xatis jiw naknejweslapixotbej. ");
INSERT INTO guoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dios nakbeltaeyaxael. Me-ama wajwʉajnapijiw jʉmduch, jachiyaxaelbej Dios xatisliajwa. Nejkiowaxilon chajia jʉmdutox wajwʉajnapijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dios jʉmdut japox waj-am Abrahamliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jʉmdutpon nakbʉ'weliajwa wajdaelmajiwxot. Ja-aech wʉt, nakbʉ'weyaxaelon tanbichfʉlaliajwas wajlewla-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Jasoxtat Dios tanbichfʉlas wʉt, chiekal isfʉlaxaes Diosliajwa, xatis babijax is-elaxtat pomatkoicha” —aech Zacarías, jʉm-aech wʉt judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zacarías jʉm-aech paxʉlan Juanliajwa: “Wʉa, jiw jʉmchiyaxael xamliajwa: ‘Dios athʉpijin pejprofeta’ —chiyaxael jiw xamliajwa. Japox jʉmchiyaxaeli, naewʉajnafʉlaxaelam xot wajpaklon wʉajna, asamatkoi pask wʉt, jiw chiekal naexasisliajwa wajpaklon. ");
INSERT INTO guoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jiw naewʉajnafʉlaxaelam matabijaliajwapi Dios bʉ'weyaxaespox, Dios beltaeyaxaes xoti babijaxan ispoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dios nakbeltaen xot, Mesías fʉloeyaxoek Diosxotsik xatisxotaliajwa. Me-ama juimt julan wʉt, jachiyaxoekon. ");
INSERT INTO guoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wajpaklokolan pat wʉt, japon jiw naewʉajnafʉlaxael diachwʉajnakolaxpox. Majt jiw pejnejchaxoelaxtat, me-ama nanʉamti itkʉataxxot. Ja-aechpi, japi asamatkoi chiekal pachaemaxael, naexasit wʉti Mesías naewʉajanpoxan. Jawʉt japi pejnejchaxoelaxan, me-ama itliak wʉt, jachiyaxael. Majt pejlewlapi tʉpaliajwa, japi pejlewlaxil, japon chiekal naewʉajan wʉt. Japi chiekal duilafʉlaxael” —aech Zacarías, jʉm-aech wʉt paxʉlan Juanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Juan chiekal ti'sfʉl wʉt, kajachawaesfʉlas Espíritu Santo. Chiekal ti't wʉton, pajilaxxot dukon. Do jawʉx, tʉaduton jiw naewʉajnaliajwa. Japox ja-aech wʉt, judíos papasfʉl Juan, jiw bautisanxot. ");
INSERT INTO guoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mox pawʉajna wʉt Jesús nalaelsliajwa, japamatkoiyan, Augusto tato'al puexa Roma paklowaxpijiw. Japonbej tato'al asatʉajnʉchanpijiw. Japon to'a pejjiw japi jiwwʉlan lelaliajwa, xajuiliajwabej puexa jiw duili japatʉajnʉchanxot, matabijsliajwapon massʉapich impuesto kaenanʉla mosaxaeli japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Japox matxoela ja-aech, jiwwʉlan lelaliajwa wʉt, japon Cirenio gobernador wʉt Siria tʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Puexa japi jiw to'as kaenanʉla fʉlaeliajwa pejwʉajnapijiw pejpaklowaxan poxade, japapaklowaxxot wʉllelaliajwas, xajuiliajwasbejpi. ");
INSERT INTO guoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Samata, japamatkoi José nakolt Nazaret paklowax, Galilea tʉajnʉxot. Do jawʉt, José fʉlaechlison Belén paklowax poxade Judea tʉajnʉxotaliajwa, pejwʉajnapijin rey David, japapaklowaxxot nalaelt xot. ");
INSERT INTO guoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José bʉ'fol María. Japow José pijowaxael. Japow moejow. ");
INSERT INTO guoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén paklowaxxot wʉt, María pejmatkoi wepach naxʉwlaliajwa. Jawʉt boejpunspow. ");
INSERT INTO guoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Do jaxot paxʉlch nalaelt, matxoelapijin. Yamxʉch xakiach ponbʉ'. Ochpon naxaeyaxan pak xalwʉajtholaxtat. Japi chakow jiw papatbatatliajwa, ba xajʉpa-el xot. ");
INSERT INTO guoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén paklowaxxot mox, yoxot, jaxot ovejas tataefʉlpi chala pejew ovejasmʉtan madoi. ");
INSERT INTO guoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Do jawʉt, japixot chalechkal natulaelt Dios pej-ángel. Dios pijaxtat xabich itliakon japixot. Me-ama itliakax xabich itliak wʉt, ja-aechon. Ovejas tataefʉlpi japox taen wʉt, xabich beljowpi. ");
INSERT INTO guoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Do jawʉt, ángel jʉm-aech: “¡Xamal nabej belwe'! Xan chimiawʉajan xaloekx xamal xabich nejchachaemlaliajwam. Japox xamalliajwa, puexa asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Amwʉtjel Belén paklowaxxot, rey David majt dukxot, nalaelt Cristo. Japon paklokolan, Dios to'aspon, fʉloekon athʉlelsik jiw bʉ'weliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Xamal jalwekam wʉt, japoch yamxʉch faenaxaelam, ponbʉ' xakiachpoch, ochpon pak naxaeyaxan xalwʉajtholspoxtat” —aech ángel ovejas tataefʉlpiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Do jawʉt, Dios pej-ángelxot, xabich kaes ángeles chalechkal natulaelba. Japi jajuw wʉt, jʉm-aechi Diosliajwa: “Dios xabich pachaem” —aechi. Jʉm-aechbejpi: ");
INSERT INTO guoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Puexa ampathatpijiw nej sitaepi Dios, athʉxotse dukpon! ¡Nej pachaemabejpi, duil wʉt ampathatat! ¡Japi nej isfʉle Dios nejxasinkpoxan!” —aechfʉl ángeles jajuiyaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dios pej-ángeles kaxase wʉt athʉ poxase, ovejas tataefʉlpi nakaewa najʉm-aechi: —Chijias Belén paklowax poxade taeliajwas ja-aechpox, ángel nakchapaeipox, Dios bʉxto'aspox —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Do jawʉt, japi bichakal fʉlaech Belén paklowax poxade. Jaxot pa'a wʉt, taeni María, José sʉapich. Taenbejpi narianach, ok wʉt pak xalwʉajtholaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ovejas tataefʉlpi japoch taen wʉt, asew jiw chapaeipi Dios pej-ángel jʉmtisox japochliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Puexa jiw japox jʉmtaen wʉt, xabich nejchaxoelanuili, ovejas tataefʉlpi chapaei wʉt japox. ");
INSERT INTO guoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María pajut boejlach nejchaxoelafʉl ovejas tataefʉlpi jʉm-aechpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Do jawʉt, ovejas tataefʉlpi nawiapi. Fol wʉt, jʉm-aechi: “Dios xabich pachaem. Is pachaempox” —aechi, taen xoti japox, jʉmtaen xotbejpi ángel jʉm-aechpox. Diachwʉajnakolax japi puexa taen, me-ama Dios pej-ángel jʉmtispi japoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yamxʉch nalaeltpox siete matkoiyan xent wʉt, japoch yamxʉch circuncidas Dios pejmarkaxliajwa. Do jawʉt, wʉlduwspon Jesúswʉltat. María moejowa-el wʉtfʉk, Dios pej-ángel chajia jʉmtispow japawʉltat paxʉlan wʉlduiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés chajia lelpox judíos chiekal naexasit japi pachaemaliajwa Diosliajwa. Samata, cuarenta matkoiyan xent wʉt Jesús nalaeltox, José, Maríabej, japi bʉflaech Jesús Jerusalén paklowax poxade, paxʉlan itpaeliajwapi Dios pejtemplobatat. Jasox ispi, asamatkoi japoch xaljamch ti't wʉt Dios tanbichfʉlaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jasox islisi, Moisés chajia lelpox jʉm-aech xot japoxliajwa: “Puexa yamxi poejiw, matxoelanalaelapi, japi Dios tanbichaxael, ti't wʉt” —aech xotox. ");
INSERT INTO guoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Do jawʉx, José, María sʉapich, ofrenda chaxduwpi Diosliajwa, Moisés chajia lelpox jʉm-aech xot japox isliajwa. Japox jʉm-aech: “¡Chaxdu'e kolenje cha-aex a-u, o, kolenje a-utxʉlan, Dios pej-ofrendaliajwa!” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Japamatkoiyan Jerusalén paklowaxxot aton duk, japon pawʉl Simeón. Japon chiekal pachaem Diosliajwa. Pomatkoicha chiekal naexasiton puexa Dios jʉm-aechpoxan. Simeón pejmatpʉatxot Espíritu Santo. Japon wʉajnawet Cristo pasax, judíos bʉ'weyaxaespon. ");
INSERT INTO guoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Santo pijaxtat Simeón chajia matabijt, japon laeja wʉtfʉk japon taeyaxaelpox Cristo, japon Dios jʉmduchpon. ");
INSERT INTO guoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Samata, Espíritu Santo pijaxtat Simeón fʉlaech Dios pejtemploba poxade. Do jawʉt, Simeón taen José, María sʉapich, bʉ'fol wʉti Jesús isliajwa Dios to'aspox, me-ama Moisés chajia lelpox jʉm-aech. ");
INSERT INTO guoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jawʉt Simeón isfit Jesús. Do jawʉt, Dios kawʉajan wʉt, jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Tajpaklon Dios, najʉmdutampon tajut chiekal taenxlison, jiw bʉ'weyaxaelpon, ampon. Samata, amwʉtjel xan, nabistaxponan xamliajwa, ¡natapaem xan tʉpaliajwan, xabich nejchachaemlaxtat! ");
INSERT INTO guoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Xam ampoch to'am jiw bʉ'weliajwa, puexa jiw taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Japon pijaxtat judíos-eli matabijaxael diachwʉajnakolaxpox. Japon pijaxtatbej nejjiw, judíos, asew jiw sitaeyaxaes” —aech Simeón, Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José, Maríabej, xabich nejchaxoelanuil, jʉmtaen wʉti Simeón jʉm-aechpox yamxʉchliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Do jawʉtbej, Simeón Dios kawʉajan Joséliajwa, Maríaliajwabej, yamxʉchliajwabej, Dios isliajwa pachaempox japiliajwa. Do jawʉtbej, Simeón jʉm-aech asamatkoi jachiyaxaesox Maríaliajwa: —Asamatkoi xamliajwa, me-ama espadatat xʉa'la wʉti, xabich xaenkaxael, jachiyaxael xamliajwa, naxʉlan asew jiw pijaxtat nabijasax taenam wʉt. Xabich israelitas japon naexasisaxisal. Japi napelsaxael. Xabich asew jiwlax naexasisaxaes japon. Japilax bʉ'weyaxaes. Xabich jiw babejjamechan jʉmchiyaxaeson. Jasoxtat asew jiw matabijaxael, achax pejnejchaxoelaxanxot. Samata, asamatkoi xam xabich nejxaejwaxael —aech Simeón Maríaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Jawʉt kaeow pawis jaxotbej Dios pejtemplobatat. Japow Dios pejprofeta. Pawʉlow Ana, Fanuel paxʉlow. Japow Aser pamow. Xabich pati'ow. Ochenta y cuatro waechan. Pansiow wʉt, pamal fitow. Pamal fitpox siete waechan wʉt, pamal naetʉpspow. Pamal tʉp wʉt, do kaes nakjiya-elisow. Pin-iawaechan tamach laejepow. Japow chinax nakols-el Dios pejtemplobaxot. Ja-aech japow, Dios pejbichaxan nabist xot. Pomatkoicha japow Dios kawʉajnafʉl. Dios piach kawʉajnaliajwa wʉt, xabich piach naxae-elow. ");
INSERT INTO guoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","José, María sʉapich, Dios pejtemplobatat wʉt, Ana mox soepan japixot. Jawʉt gracias-aechow Diosliajwa, yamxʉchliajwabej. Do jawʉt, jʉm-aechow yamxʉchliajwa puexa Jerusalén paklowaxpijiwliajwa, japi wʉajnaweti bʉ'weyaxaespox japon pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José, María sʉapich, toeti ispox, me-ama Moisés chajia lelpox jʉm-aech. Dolisi, paxʉlch bʉnwiati pejpaklowax poxade, Nazaret paklowax, Galilea tʉajnʉlel. ");
INSERT INTO guoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesús chiekal ti'sfʉl. Mamnikbejpon. Jesús kaes matabijsfʉl, Dios kajachawaesfʉlas xot. ");
INSERT INTO guoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kaewaechfʉl wʉt, José, María sʉapich, Jerusalén paklowax poxade. Fʉlalaecha taeliajwa Pascuafiesta. ");
INSERT INTO guoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús doce waechan wʉt, japon nakfol Jerusalén paklowax poxade, me-ama japi pejkabʉan. ");
INSERT INTO guoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pascuafiesta toep wʉt, japi puexa fiesta taeni nawia wʉt pejbachan poxade, jawʉt Jesús naman Jerusalén paklowaxxot. José, María sʉapich, matabija-el Jesús kaweta namanpox Jerusalén paklowaxxot. ");
INSERT INTO guoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","José, María sʉapich, nʉamtat fol wʉt, nejchaxoeli: “Jesúskas chajia wʉajna nakfʉlaech wajjiwtat” —aechi, nejchaxoel wʉt. Samata, kaematkoi nejmach chiekal foli nʉamtat. Do jawʉx, José, María sʉapich, tae-el wʉti Jesús, jawʉt tuadutlisi wʉajnachaemsliajwa pejjiw. Wʉajnachaemtbejpi asew jiw, japi pejmatabijspipon. ");
INSERT INTO guoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wʉlwek wʉti pejjiwxot, japi faena-el Jesús. Do jawʉt, José, María sʉapich, kaxa nawen Jerusalén paklowax poxadin, jaxot wʉlwekaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tres matkoi wʉt, faenipon Dios pejtemplobaxot. Japon ek judíos chanaekabʉanapixot. Naeweton japi. Jesús wʉajnachaemtbej matabijsaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesús chiekal matabijt judíos chanaekabʉanapi jʉm-aechpox. Chiekal jʉmnotbejpon, wʉajnachaemtas wʉt. Puexa jiw, japox jʉmtaen wʉt, xabich nejchaxoelachalaki, Jesús xabich matabijt xot. ");
INSERT INTO guoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","José, María sʉapich, taen wʉti Jesús ekox, judíos chanaekabʉanapi sʉapich, xabich nejchaxoelanuili. María jʉm-aech Jesúsliajwa: —Wʉa, xam jasox jachiyaximil xanalliajwa. Xan, nej-ax sʉapich, xabich nejchaxoelx, xam wʉlwekx wʉt —aechow. ");
INSERT INTO guoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús jʉmnot wʉt, jʉm-aechon: —¿Ma-aech xotkat xamal xan nawʉlwekam? ¿Xamalkat matabija-emil xan taj-ax Dios pejbaxotaxaelenpox? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Japi jʉmmatabija-el, Jesús japox jʉm-aech wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pe María nejchaxoelafʉl, Jesús jʉm-aech wʉt japox. Nejkiowa-elow. Jawʉx José, María sʉapich, Jesúsbej, nawia Nazaret paklowax poxade. Jesús Nazaret paklowaxxot duk wʉt, naexasisfʉlon José, Maríabej, puexa japi tato'alpoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús chiekal ti'sfʉl. Kaes matabijsfʉlbejpon. Dios nejchachaemlafʉl Jesúsliajwa. Jiwbej nejchachaemlafʉl Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio tato'al, puexa Roma paklowaxpijiw. Japonbej tato'al asapaklowaxanpijiw. Japon quince waechan tato'al wʉt, japamatkoiyan, Poncio Pilato Judea tʉajnʉpijiw tato'al. Jawʉtbej Herodes Galilea tʉajnʉpijiw tato'al. Herodes pakoewan, pawʉl Felipe, japon puexa Iturea tʉajnʉpijiw, Traconite tʉajnʉpijiwbej, tato'al. Asan pawʉlpon Lisanias, japon tato'al Abilinia tʉajnʉpijiw. ");
INSERT INTO guoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jawʉt Anás, Caifás sʉapich, japi kolenje, sacerdotespaklokola. Japamatkoiyan Zacarías paxʉlan, japon pawʉlpon Juan, duk pajilaxxot. Jawʉtbej Juan bʉxto'as Dios, japon jiw naewʉajnafʉlaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Samata, Juan nanʉamt Jordánlajtxot, jaxot naewʉajanpon jiw Dios pejjamechan. Juan naewʉajan wʉt jʉm-aechon: “¡Kofim babijaxan isampoxan! ¡Isfʉlde Dios nejxasinkpoxan! Ja-amsfʉlam wʉt, Dios beltaeyaxael babijaxan isampoxanliajwa. Do jawʉt, xamal bautisaxaelen” —aech Juan, jiw naewʉajnafʉl wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan, jiw bautisan, naewʉajan wʉt jiw, patlisox Dios pejprofeta Isaías chajia lelpox Juanliajwa. Isaías chajia lel wʉt, jʉm-aechon: “Kaen aton pajilaxxot nejlat wʉt, jʉmchisfʉlaxaelon jiwliajwa: ‘¡Kofim babijaxan isampoxan wajpaklonliajwa! Me-ama jiw chiekal nʉamt chaemt wʉt paklon pasliajwa, ¡ja-amde nejnejchaxoelaxan! ¡Isfʉlde Dios nejxasinkpox! ¡Ja-amsfʉlde! ");
INSERT INTO guoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Puexa tufatan as tholaxaes nʉamt chiekal najʉpaliajwa. Puexa mʉaxan koeyaxaesbej sat chiekal najʉpaliajwa. Nʉamanbej, jajiali, matnoch xatathalaxaes. Nʉamanbej mʉthan wʉt, pe'axaes chiekal najʉpaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Puexa jiw matabijaxael Dios to'aspon jiw bʉ'weliajwa’ —chiyaxaelon” —aech Isaías chajia lelpox Juan, jiw bautisanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juan, jiw bautisanxot, xabich jiw papasfʉl japi bautisaliajwas. Japi jiwxot, asew kofa-el wʉt babijaxan ispoxan, japibej nakiowa nakbautisasia. Me-ama asew jiw babijaxan ispoxan kofapi, jachisiapi. Samata, jawʉt, Juan jʉm-aech japi jiwliajwa: “Xamal, me-ama jom dʉkpi weliajwa, jit patʉajax boejtaen wʉt, ja-am xamal. Pe asamatkoi xamal weyaximil, babejkolax kastikaxmatkoi pat wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","¡Kofim babijaxan isfʉlampoxan! ¡Isfʉldelax Dios nejxasinkpoxan! Japox ja-amsfʉlam wʉt, puexa jiw matabijaxael, diachwʉajnakolax xamal babijaxan isampoxan kofampim. ¡Xamal nakaewa nabej najʉm-aeche': ‘¡Xanal Abraham pamojiwan! Samata, diachwʉajnakolax Dios xanal nabʉ'weyaxael’ —nabej aeche' najut! Xamal Abraham pamojiwam. Pe nakiowa babijaxan isam wʉt, Dios xamal bʉ'weyaxil. Dios nejxasink wʉt, xajʉp ia' Abraham pamojiw dofaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Naebaechnaechan, naboesfʉli kaewaechfʉl. Pe japanaechan kaes naboesfʉla-el wʉt, xamal liktam japanaechan. Do jawʉx, majow wʉt, jitat it-owam. Jachiyaxaelbej xamalliajwa, Dios kastika wʉt, naexasis-emil wʉt Dios” —aech Juan, jiw bautisan, babijaxan isfʉlpiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Do jawʉt, japi wʉajnachaemt wʉt, jʉm-aechi: —¿Machiyaxaelenkat xanal isfʉlaliajwan Dios nejxasinkpoxan? —aechi Juanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan jʉmnot wʉt, jʉm-aechon: —Xamal koloeyax wʉt kamis, asan aton xabich kejil wʉt naxoelaliajwa, ¡japon aton chaxdu'e naxoelax! Xamal naxaeyaxan wʉt, asan aton xabich wejisal wʉt xaeliajwa, ¡japon aton chaxduim! —aech Juan. ");
INSERT INTO guoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Do jawʉt, pejme asew jiw pat Juanxot. Japi mox soepa bautisaliajwas. Japi impuesto mat-omwʉljoew Roma gobiernoliajwa. Japi jʉm-aech, wʉajnachaemt wʉti Juan: —¿Xanal machiyaxaelenkat isliajwan Dios nejxasinkpoxan? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan jʉmnot wʉt, jʉm-aechon japiliajwa: —Xamal jiw mat-omwʉljowam wʉt impuesto, ¡mat-omwʉljoem nejpaklon to'apoxantat! ¡Kaes pejme nabej mat-omwʉljoe' jiw naekichachajbaliajwam! —aech Juan impuesto mat-omwʉljoewliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Do jawʉx, soldawbej pat Juanxot. Japibej wʉajnachaemt wʉt, jʉm-aechi Juanliajwa: —¿Machiyaxaelenkat xanal isfʉlaliajwan Dios nejxasinkpox? —aechi Juanliajwa. Do jawʉt, Juan jʉmnot wʉt, jʉm-aech soldawliajwa: —¡Xamal nabej bʉ'athiye' kenosliajwam asew jiw pejew! ¡Nabej tasale'bej asew jiw, nejmachpijiw, japi pejew kenosliajwam! ¡Xanejchachaemilde nejpaklon motpoxantat! —aech Juan soldawliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Xabich jiw wʉajnawesfʉl Cristo pasaxaelpox, japon Dios to'axoekspon jiw bʉ'weliajwa. Samata, jiw jʉmtaen wʉt Juan naewʉajanpox, japi nakaewa najʉm-aech: “Diachwʉajnakolax Juan bej Cristobej” —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pe jawʉt Juan pajut chiekal jʉm-aech puexa jiwliajwa: “Diachwʉajnakolax xan jiw bautisafʉlax mintat, jiw kofa wʉt babijaxan ispoxan. Asamatkoi xanwʉx asan fʉlaeyaxaen. Japonlax to'axael Espíritu Santo jiw kajachawaesfʉlaliajwas. Espíritu Santo pejpamamax, me-ama jit, jiw babijaxan ispoxan toejwaliajwas, jiw pejnejchaxoelaxan pachaemaliajwa. Japon fʉlaeyaxaelpon kaes pejme paklonaxael. Me-ama xan, jachiyaxilon. Xan omjinil japon pejkajachawaesnanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Lulpijin trigo bokchalʉla trigokal namaeliajwa. Do jawʉx, trigo jiapon batat cha-owaliajwa. Trigobok, trigotonanbej, pelton lausliajwa jitat. Jachiyaxaelbej fʉlaeyaxaelon. Japon tamejaxael Diosxotse pachaempikal, japi jiw naexasiti Dios. Asewjiw, babijaxan ispi, naexasis-elbejpi Dios, japi pelsaxaeks jitadik, itkʉawaxil poxadik” —aech Juan jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jasoxtat Juan naewʉajnafʉlbej jiw. Asawʉajantat, pachaemwʉajan, Juan naewʉajnafʉl jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan fiatbej Herodes, Galilea tʉajnʉpijiw tato'lan. Fiat wʉt, jʉm-aechon Herodesliajwa, japon fe'en xot pakoewan Felipe. Japow Felipe pijow. Japow pawʉl Herodías. Juan japox jʉm-aech Herodes nejchaxoelaliajwa, kaes asaxan babijaxan xabich isfʉl xoton. ");
INSERT INTO guoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pe Herodes naexasis-el Juan jʉm-aechpox. Pelax Herodes asax babijax pejme ispon, Juan jia xoton jiw jebatat. ");
INSERT INTO guoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Asamatkoi, Juan jiw bautisa wʉt, jawʉtbej Jesús bautisas. Jesús bautisas wʉt, Dios kawʉajan wʉton, taenon athʉ fafachpox. ");
INSERT INTO guoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jaxotsik Espíritu Santo fʉloek, me-ama a-utlejen Jesús pejmatwʉajasik. Do jawʉt, jʉmtaenbejpon athʉlelsk jʉmtiskaspox. Dios pajut jʉm-aech: —Xam taxʉlnam, xabich nejxasinkaxponam. Xamliajwa xabich nejchachaemlax —aech Dios Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treinta waechan wʉt, tʉadut naewʉajnaliajwa jiw. Jiw nejchaxoel Jesúsliajwa: “Japon José paxʉlan” —aechi asbʉan jʉmch, nejchaxoel wʉt. José pax pawʉl Elí. ");
INSERT INTO guoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí pax pawʉl Matat. Matat pax pawʉl Leví. Leví pax pawʉl Melqui. Melqui pax pawʉl Jana. Jana pax pawʉl José. ");
INSERT INTO guoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José pax pawʉl Matatías. Matatías pax pawʉl Amós. Amós pax pawʉl Nahúm. Nahúm pax pawʉl Esli. Esli pax pawʉl Nagai. ");
INSERT INTO guoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pax pawʉl Maat. Maat pax pawʉl Matatías. Matatías pax pawʉl Semei. Semei pax pawʉl Josec. Josec pax pawʉl Judá. ");
INSERT INTO guoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá pax pawʉl Joanán. Joanán pax pawʉl Resa. Resa pax pawʉl Zorobabel. Zorobabel pax pawʉl Salatiel. Salatiel pax pawʉl Neri. ");
INSERT INTO guoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pax pawʉl Melqui. Melqui pax pawʉl Adi. Adi pax pawʉl Cosam. Cosam pax pawʉl Elmadam. Elmadam pax pawʉl Er. ");
INSERT INTO guoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pax pawʉl Jesús. Jesús pax pawʉl Eliezer. Eliezer pax pawʉl Jorim. Jorim pax pawʉl Matat. ");
INSERT INTO guoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat pax pawʉl Leví. Leví pax pawʉl Simeón. Simeón pax pawʉl Judá. Judá pax pawʉl José. José pax pawʉl Jonam. Jonam pax pawʉl Eliaquim. ");
INSERT INTO guoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim pax pawʉl Melea. Melea pax pawʉl Mena. Mena pax pawʉl Matata. Matata pax pawʉl Natán. ");
INSERT INTO guoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán pax pawʉl David. David pax pawʉl Isaí. Isaí pax pawʉl Obed. Obed pax pawʉl Booz. Booz pax pawʉl Sala. Sala pax pawʉl Naasón. ");
INSERT INTO guoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón pax pawʉl Aminadab. Aminadab pax pawʉl Admin. Admin pax pawʉl Arni. Arni pax pawʉl Esrom. Esrom pax pawʉl Fares. Fares pax pawʉl Judá. ");
INSERT INTO guoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá pax pawʉl Jacob. Jacob pax pawʉl Isaac. Isaac pax pawʉl Abraham. Abraham pax pawʉl Taré. Taré pax pawʉl Nacor. ");
INSERT INTO guoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor pax pawʉl Serug. Serug pax pawʉl Ragau. Ragau pax pawʉl Peleg. Peleg pax pawʉl Heber. Heber pax pawʉl Sala. ");
INSERT INTO guoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala pax pawʉl Cainán. Cainán pax pawʉl Arfaxad. Arfaxad pax pawʉl Sem. Sem pax pawʉl Noé. Noé pax pawʉl Lamec. ");
INSERT INTO guoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec pax pawʉl Matusalén. Matusalén pax pawʉl Enoc. Enoc pax pawʉl Jared. Jared pax pawʉl Mahalaleel. Mahalaleel pax pawʉl Cainán. ");
INSERT INTO guoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán pax pawʉl Enós. Enós pax pawʉl Set. Set pax pawʉl Adán. Adán Dios isaspon atonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús duk wʉt, xabich kajachawaech Espíritu Santo. Samata, nawia'an wʉt Jordánlajtxotdin, Jesús Espíritu Santo bʉ'fos pajilax poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jaxotde cuarenta matkoiyan kaweta wʉt, chinax xae-elon. Cuarenta matkoiyan toep wʉt, do jawʉt, Jesús xabich litaxaela. Jawʉt dep pejpaklon, Satanás, pat Jesúsxot. Paton xapaejaliajwa Jesús, Jesús babijax isliajwa Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Samata, Satanás xapaejt wʉt, jʉm-aechon Jesúsliajwa: —Diachwʉajnakolax xam Dios paxʉlnam wʉt, ¡ampot ia't to'im panax nadofaliajwa! —aech Satanás Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús jʉmnot wʉt, jʉm-aechon: —Dios pejjamechan, chajia lelspox, jʉm-aech: ‘Jiw duilaxil naxaeyaxankalliajwa. Jiw wewe'pasbej Dios pejjamechan naexasisfʉlaliajwapi’ —aech Dios pejjamechan, chajia lelspox —aech Jesús Satanásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Do jawʉt, Satanás pejme xapaejsliajwa wʉt, bʉ'folon Jesús pinamʉax athʉ poxase Jesús itpaeliajwas puexa tʉajnʉchan ampathatat. ");
INSERT INTO guoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Do jawʉt, Satanás jʉm-aech: —Puexa ampatʉajnʉchan, paklowaxanbej, japoxan puexa xan tejew, xan malech nachaxdut xoton. Xanbej paklokolnan ampatʉajnʉchanpijiwliajwa. Puexa japoxan xan malech chaxdusliajwan. Samata, chaxdusasianpon malech chaxdusaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tajwʉajnalel xam brixtat nukam wʉt, najʉm-am wʉtbej: ‘Xam xabich pachaemam. Xam tajpaklokolnam’ —na-am wʉt xanliajwa, puexa malech xam chaxdusaxaelen japatʉajnʉchan, japapaklowaxanbej —aech Satanás Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús jʉmnot wʉt, jʉm-aechon: —Dios pejjamechan, chajia lelspox, jʉm-aech: ‘Kaen Dios jiw pejpaklokolan. Japonkal sitaeyaxaes. Owchiyaxaesbejpon’ —aech chajia lelspox —aech Jesús Satanásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Do jawʉt, Satanás pejme bʉ'folon Jesús Jerusalén paklowax poxade, pejme xapaejsliajwapon Jesús. Jesús bʉ'fos Dios pejtemploba matwʉajase, kaes athʉ poxase. Jaxotse nosaspon. Jawʉt Satanás jʉm-aech: —Diachwʉajnakolax xam Dios paxʉlnam wʉt, ¡amxot diwmik sat poxadik! ");
INSERT INTO guoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Xam sat naxbijaximil. Dios pejjamechan, chajia lelspox jʉm-aech: ‘Dios to'axoek pej-ángel xam chiekal tataeflaliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xam jopam wʉt, jaelsabaxaeli naxbijasamatam ia', najalasamatambej’ —aechox, Dios pejjamechan, chajia lelspox —aech Satanás Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús jʉmnot wʉt, jʉm-aechon: —Xan diwaxinil. Xan chiekal matabijtax Dios natataefʉlpox. Dios pejjamechan, chajia lelspox, jʉm-aechbej: ‘¡Nabej xapaejs Dios, nejpaklokolan, asbʉan jʉmch taeliajwam japon xajʉp wʉt, o, xajʉpa-el wʉton weliajwa!’ —aech chajia lelspox —aech Jesús Satanásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Do jawʉt, Satanás kaes wejisal xot xapaejsliajwa, chijialison Jesúsxot. Jesús tamach waeltas. Pe asamatkoi Satanás pejme pasaxael pejme xapaejsliajwapon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús pejme kaxadin, Galilea tʉajnʉ poxadin. Espíritu Santo kajachaxaesaxtat Jesús dukafʉl. Samata, japatʉajnʉpijiw puexa chiekal naksiya Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús naewʉajan judíos naewʉajnabachanxot. Puexa jiw jʉmtaen wʉti Jesús naewʉajanpoxan, japi jʉm-aech chimiajamechan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús nawia'e Nazaret paklowax poxade, ti't poxade. Napatamatkoi wʉt, lechon judíos naewʉajnaba poxade, pejkabʉan xoton. Jaxot wʉt, nanton chanaexaljoeliajwa Dios pejjamechan, chajia lelspox. ");
INSERT INTO guoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jawʉt Jesús chaxduch xakoeyasfʉt xaljoeliajwa profeta Isaías chajia lelox. Dolison japafʉt ba'nat wʉt, faenon xaljoeyaxaelpox. Do jawʉt, xaljowpox jʉm-aechox: ");
INSERT INTO guoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Dios pej-Espíritu Santo xan nachala, Dios pajut namakafit xot kejila naewʉajnaliajwan chimiawʉajan. Dios nato'abej naewʉajnaliajwan babijaxan ispi, nabijatpibej Satanás pijaxtat. Japi pejnejchaxoelaxan, me-ama jiw jebatat jiaspi, ja-aechpi. Dios nato'abej boejthʉsliajwan itliakla. Dios nato'abej bʉ'weliajwan jiw, jiw nabijati asew jiw pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dios nato'abej naewʉajnaliajwan jiw amwʉtjel Dios bʉ'weyaxaelpox jiw” —aech Jesús pajutliajwa, chanaexaljow wʉton Isaías chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Do jawʉx, Jesús chanaexaljoeyax toet wʉt, xakoeyapon japafʉt. Chaxduton judíos naewʉajnaba kajachawaesan. Do jawʉt, Jesús ek. Puexa jiw, jaxot chalaki, xabich natachaemaspon. ");
INSERT INTO guoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesús pejme jʉm-aech japiliajwa: —Xamal jʉmtaenam xan xaljowx wʉt Isaías chajia lelpoxliajwa, amwʉtjel japox patlisox xamalxot —aech Jesús pajutliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Do jawʉt, puexa japi jiw jʉm-aechi pachaempoxan Jesúsliajwa. Japi xabich nejchaxoelachalak, Jesús jʉm-aech xot chamoeyaxan. Samata, nakaewa najʉm-aechi: —¿Diachwʉajnakolax amponkatlap Jesús, José paxʉlan? —na-aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús matabijt japi jiw nakaewa najʉm-aechpox. Samata, jʉm-aechon: —Xamal nejxasinka-emil naexasisliajwam xan jʉm-anox. Samata, xan najʉm-am asbʉan jʉmch: ‘Xam asew boejthʉsnam wʉt, ¡amxotbej jiw boejthʉ'e!’ —am xamal. Jʉmchiyaxaelambej ampox xanliajwa: ‘Xanal wʉltaenx, Capernaum paklowaxxot koechaxan isam wʉt. Amxot, nejpaklowaxxotbej, koechaxan isam wʉt, ja-aech wʉt, xanal naexasisaxaelen xam naewʉajnampoxan’ —chiyaxaelam xanliajwa —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesús pejme jʉm-aech: —Xan diachwʉajnakolax jʉm-an. Puexa profetas sitae-esal pejtʉajnʉkolaxpijiw. ");
INSERT INTO guoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Wajwʉajnapijin, profeta Elías, Israel tʉajnʉxot laeja wʉt, japamatkoiyan, tres waechan y medio iam thilna-el. Samata, xabich jiw litaxaelafʉl potʉajnʉcha, naxaeyaxan ajil xot. Japamatkoiyan Israel tʉajnʉxot xabich watho' duil, pamaljiw naetʉpspi. Pe Elías to'a-esal Dios kajachawaesliajwapon watho', japatʉajnʉpijiw pamaljiw naetʉpspi. Elías to'aslax asatʉajnʉ poxade, kajachawaesliajwapon Sarepta paklowaxpijow, Sidón tʉajnʉpijow, pamal naetʉpspow. ");
INSERT INTO guoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wajwʉajnapijin, profeta Eliseo, laeja wʉt ampathatat, Israel tʉajnʉxot duil xabich jiw, leprawaxae waeispi. Pe japixot kaen boejthʉs-elon. Japonlax boejthʉt asatʉajnʉpijin, Siria tʉajnʉpijin, pawʉlpon Naamán —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Japox jʉmtaen wʉti, puexa judíos naewʉajnabatatpi xabich palalapi Jesúsliajwa. Japi matabija Jesús kajachawaesaxisalpox. ");
INSERT INTO guoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Samata, xabich palala xoti, nanbapi. Do jawʉt, Jesús jaeltlisi. Bʉ'follisipon paklowax tathoetlel. Japapaklowax chiekal mʉaxmatwʉajtat. Jaxot chʉat xabich athʉ. Samata, jaxot fo'asiapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pe jawʉt, Jesús xent japixot. Do jawʉt, Jesús chajia japatʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús fʉlaech Capernaum paklowax poxade, Galilea tʉajnʉlel. Napatamatkoi wʉt, jaxot judíos naewʉajnabatat Jesús jiw naewʉajan. ");
INSERT INTO guoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Japi jiw japox jʉmtaen wʉt, xabich nejchaxoelachalaki, Jesús naewʉajan xot Dios pejkajachawaesaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Judíos naewʉajnabaxot, jaxot aton ekbej, pejmatpʉatxot webaespon dep. Do jawʉt, japon aton nejlat wʉt, jʉm-aechon dep pijaxtat: ");
INSERT INTO guoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús, Nazaret paklowaxpijnam, ¡xanal tamach natapaem! ¿Achaxasiamkat xanalxot? ¿Xamkat fʉlaeman xanal natoesliajwam? Xanal chiekal matabijax, xam Dios paxʉlnam, xabich pachaemamponam —aech dep, aton pejkaechatat nejlat wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Do jawʉt, Jesús jʉm-aech nejthʉ'axtat depliajwa: —Dep, ¡boejlachde! ¡Xam nakolde japon aton pejmatpʉatxot! —aech Jesús. Do jawʉt, japon aton satat xadapson dep puexa jiw pejwʉajnalel. Do jawʉx, dep nakolt japon aton pejmatpʉatxot tabejs-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Puexa jiw xabich belwana, japox taen wʉt. Nawʉajnachaemsnapi nakaewa. Najʉm-aechi: —¿Ma-aechon pejjametat dep nakolsliajwa, to'a wʉton dep? Me-ama Dios to'ason wʉt, ja-aechon. Ja-aech wʉt, ¡dep nakolt! —na-aech nakaewa japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Do jawʉx, puexa Galilea tʉajnʉpijiw naksiyapi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús nakolt wʉt judíos naewʉajnabaxot, fʉlaechon Simón Pedro pejba poxade. Jesús wʉajna Simón paem bʉ'xaenk. Xabich bʉ'tʉajnikow. Jaxotpijiw jʉm-aechi Jesús boejthʉsliajwa japow. ");
INSERT INTO guoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús najʉlt Simón paem okxot. Jawʉt waxae to'apon japow boejthʉlaliajwas. Do jawʉt, japow kamta chiekal boejthʉs. Jawʉt nantow. Do jawʉtbej, japow pajut naxaeyaxan athukow Jesúsliajwa, asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Juimt dach ek wʉt, jiw bʉ'xaeya bʉflaens Jesúslel. Japi nejmachwaxaetat bʉ'xaenkpi. Do jawʉt, Jesús jachafʉl pejke-etat kaenanʉla jiw bʉ'xaenkpi. Do jawʉtbej, japi jiw chiekal boejthʉls waxae. ");
INSERT INTO guoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Asew bʉ'xaeyaxot, dep webaespi pejmatpʉatanxot, japibej boejthʉton. Dep nakola wʉt japixot, dep nejla'bala. Nejla'bala wʉt, jʉm-aechbalapi: —¡Xam Dios paxʉlnam! —aechbalapi. Dep japox jʉm-aech wʉt, Jesús bʉxfiat. Jesús tapae-el dep kaes naksiyaliajwa, japi chiekal matabija xot japon Cristo, Dios to'aspon jiw bʉ'weliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sesa itliakafʉl wʉt, Jesús nakolt paklowaxxot japon tamachaliajwa. Do jawʉt, jiw wʉlwekson. Faens wʉton, japi jiw jʉm-aechi Jesúsliajwa: —¡Namandefʉk xanalxot! ¡Nabej fʉlae'fʉk asatʉajnʉlel! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pe Jesús jʉm-aech: —Xan naewʉajnaxaelen asapaklowaxanpijiwbej. Japi naewʉajnafʉlaxaelen chimiawʉajan, Dios puexa pejjiw tato'laxaelwʉajan. Dios nato'a japox isfʉlaliajwan —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Samata, Jesús naewʉajnafʉl jiw Dios pejjamechan judíos naewʉajnabachanxot, Galilea tʉajnʉxot, Judea tʉajnʉxotbej. ");
INSERT INTO guoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Asamatkoi Jesús nuk pukababʉ'tat, Genesaret pukaxot. (Japapuka asawʉl, Galilea puka.) Xabich jiw Jesús tabe'nas, xabich jʉmtaesia xoti Jesús naewʉajanpox Dios pejjamechan. ");
INSERT INTO guoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Do jawʉt, Jesús taen kolefalkam, oel wʉt thaejtat. Japafalkam tujil, nana xot nabaxiti, kiasliajwapi pejew chinchorro. ");
INSERT INTO guoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Do jawʉt, Jesús jul Simón pejfalkamtat. Jawʉtbej to'apon Simón thiklaliajwa falkam atʉaxachde chadukaliajwa. Jesús falkamtat ek. Do jawʉt, tʉaduton jiw naewʉajnaliajwa, pʉtat nuili. ");
INSERT INTO guoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dolison, naewʉajnax bʉxtoet wʉt, Jesús jʉm-aech Simónliajwa: —¡Falkam fae'mach so'nik poxade! ¡Jaxotde xamal nejchinchorro pelsfʉlaxaemk baxi xawawaelaliajwam! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Do jawʉt, Simón jʉmnot wʉt, jʉm-aechon: —Tajpaklon, pomadoicha xanal xabich nabaxitx. Xanal chinax kaen baxin xawaesa-enil. Pe xam naketo'am xot, chinchorro pelsaxaekan pejme —aech Simón Pedro. ");
INSERT INTO guoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dolisi, jasox is wʉt, xabich baxi xawawaeli. Chinchorro mox pejxarsas, xabich xot baxi. ");
INSERT INTO guoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Simón, asew jiw sʉapich, itwaeipi asafalkampijiw, japi pejmatabijs kajachawaesliajwas. Japafalkam chapat wʉt Simónxot, xabich baxi wʉlʉti kolefalkam. Do jawʉt, mox pejchabu'lapi. ");
INSERT INTO guoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedro japox taen wʉt, brixtat nukon Jesús pejwʉajnalel. Do jawʉt, jʉm-aechon Jesúsliajwa: —Tajpaklon, ¡napia'e xanxot! Xan babejnan —aech Simón Pedro. ");
INSERT INTO guoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Japox Simón Pedro jʉm-aech, japi puexa nejchaxoelanuil xot, xabich baxi xawawaelpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pedro chalaspi, ampilape. Kaen pawʉl Santiago. Asan pawʉl Juan. Japi Zebedeo paxi. Japibej nejchaxoelanuil pejfalkamtat. Do jawʉt, Jesús jʉm-aech Simónliajwa: —¡Nabej nejlewle'! Amwʉtjel xam jiw tadʉsaxaelam japi Dios pejjiwaliajwa. Me-ama xamal baxi xawawaelam wʉt, notam. Jasoxtatbej xamal itpaeyaxaelen jachiliajwam jiwliajwa, japi jiw tajnachalaliajwa, Dios pejjiwaliajwabejpi —aech Jesús Simónliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Do jawʉt, itjuldepi papʉtade, thaejtade. Do jawʉt, puexa pejew waelalisi Jesús nakfʉlaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Asamatkoi, Jesús asapaklowaxxot wʉt, kaen aton, bʉ'xaeyan, fʉlaen Jesúslel. Japon bʉ'xaenk leprawaxaetat. Taen wʉton Jesús, brixtat nukon Jesús pejwʉajnalel, xabich sitaen xoton. Do jawʉt, natxatdik wʉt, sat makxabijindikon. Jawʉt jʉm-aechon Jesús boejthʉsliajwas: —Tajpaklon, xan matabijtax xam xajʉpam naboejthʉsliajwam. Naboejthʉsasiam wʉt, ¡xan naboejthʉ'e! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús jacha wʉt, jʉm-aechon: —Xam boejthʉsasian. Malis xam chiekal pachaemam —aech Jesús. Do jawʉt, kamta japon aton chiekal boejthʉs leprawaxae. ");
INSERT INTO guoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jawʉt Jesús jʉm-aech nejthʉ'axtat: —¡Asew jiw nabej chapae' xam boejthʉtxpox! ¡Majt xabʉa'de sacerdote poxade, japon xam taeliajwa leprawaxae boejthʉlpox! Do jawʉx, ¡Dios chaxdu'e, me-ama Moisés chajia to'a chaxduiliajwa, xam leprawaxae chiekal boejthʉl xot! Jasoxtat jiw matabijaxael xam chiekal boejthʉlpox leprawaxae —aech Jesús japon atonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Do jawʉt, puexa japatʉajnʉpijiw wʉltaena Jesús ispox. Jiw japox wʉltaena wʉt, xabich jiw papasfʉl Jesúsxot jʉmtaeliajwa Jesús naewʉajanpox. Japi papatbej boejthʉsliajwas bʉ'xaenkpoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús boejthʉsfʉl wʉt bʉ'xaeya, kaematkoisfʉl atʉaxach fʉlalaechpon jiwjilax poxade tamach Dios kawʉajnaliajwa. Jesús jasoxan ja-aech, boejthʉsfʉl wʉton bʉ'xaeya. ");
INSERT INTO guoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Asamatkoi, Jesús jiw naewʉajan wʉt, jaxot fariseos naewet, judíos chanaekabʉanapi sʉapich. Japixot, asew jiw fʉlaen cha-aelpaklowaxanxot, Galilea tʉajnʉleldin, Judea tʉajnʉleldinbej. Asew jiw fʉlaenbej Jerusalén paklowaxxotdin. Jesús boejthʉsfʉl wʉt bʉ'xaeya, puexa japibej taen, Jesús isfʉl wʉt koechaxan Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Do jawʉt, kaesʉapich poejiw chaxpat kaen nabejkan. Japon ok camillatat. Japi poejiw nejchaxoel batuchade chaxleliajwapi nabejkan Jesús pejwʉajnalel cha-osliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pe japi chaxleyaxil nabejkan batuchade, wʉajna xabich jiw batu wʉlʉk xot. Ja-aech wʉt, ba matwʉajase chaxjulachi. Jaxotse bamatwʉaj pinjiyax tʉakapi. Do jawʉx, jaxotsik chakakofanpi nabejkan Jesús pejwʉajnalel. ");
INSERT INTO guoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chakakofan wʉt, nejchaxoeli: “Ampon boejthʉsaxaes Jesús” —aechi, nejchaxoel wʉt. Jesús chiekal matabijt japi nejchaxoelpox. Samata, Jesús jʉm-aech nabejkanliajwa: —Xam babijaxan isampoxanliajwa beltaenx —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Judíos chanaekabʉanapi, fariseos sʉapich, japox jʉmtaen wʉt, nejchaxoeli: “¿Achankat ampon aton, jʉm-aechpon babejjamechan Diosliajwa? Japox jʉm-aech wʉton, japox pachaema-el Diosliajwa. Kaen Dios xajʉp beltaeliajwa, jiw babijaxan ispoxanliajwa” —aechi, nejchaxoel wʉt Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Do jawʉt, Jesús chiekal matabijt japi nejchaxoelox. Samata, wʉajnachaemt wʉt, jʉm-aechon: —¿Ma-aech xotkat xamal japox nejchaxoelam xanliajwa? ");
INSERT INTO guoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kaes pejme tampa xan jʉmchiliajwan laejaxilponliajwa: ‘Xam beltaenx babijaxan isampoxanliajwa’ —chiliajwan. Pe ja-an wʉt, jiw xan namatabijaxil, xan puexa jiw pakoewkolnanponan. Jʉm-an wʉtlax nabejkan jʉmtaeliajwa: ‘¡Nande! ¡Laejim!’ —an wʉt, japox jʉm-an wʉt, jiw diachwʉajnakolax xan namatabijaxael, xan puexa jiw pakoewkolnanponan. ");
INSERT INTO guoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Samata, xamal itpaeyaxaelen, xan puexa jiw pakoewkolnan xajʉpxpox jiw beltaeliajwan babijaxan ispoxanliajwa ampathatat —aech Jesús judíos chanaekabʉanapiliajwa, fariseosliajwabej. Samata, Jesús jʉm-aech nabejkan jʉmtaeliajwa: —¡Nande! ¡Nejcamilla fi'e! ¡Xalaem nejba poxade! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Do jawʉt, nabejkan nantlison puexa jiw pejwʉajnalel. Jawʉt fitlison pejcamilla. Fʉlaechlison pejba poxade. Fʉlaech wʉt, jʉm-aechfʉldepon Diosliajwa: “Dios xam xabich pachaemam, naboejthʉtam xot” —aechfʉldepon. ");
INSERT INTO guoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Puexa jiw chiekal taen. Majt japon nabejkan, pajut laeja-el, japon amwʉtjel pajut chiekal laejalison. Samata, xabich jiw nejchaxoelanuil. Do jawʉt, chimiajamechan jʉm-aechi Diosliajwa. Dios xabich sitaenlisi. Jʉm-aechi: —Amwʉtjel taens, Dios is wʉt koechax —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesús boejthʉt wʉt nabejkan, nakolton jiw natamejaxot. Do jawʉt, fʉlaech wʉt, taenon Leví. Japon impuesto mat-omwʉljoen Roma gobiernoliajwa. Ekon impuesto mat-omwʉljowxot. Jesús taen wʉt Leví, jʉm-aechon Levíliajwa: —¡Xabʉa't! ¡Xan nakfʉlaem tajnachalnamliajwa! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Do jawʉt, Leví nant wʉt, puexa pejew waela wʉt, Jesús nakfollison. ");
INSERT INTO guoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jawʉt Leví fiesta is pejbatat Jesúsliajwa. Xabich asew jiw pat jaxot, impuesto mat-omwʉljoew Roma gobiernoliajwa. Kaes asew jiwbej pat jaxot. Japi puexa chalak xaeliajwa, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Do jawʉt, fariseos, judíos chanaekabʉanapibej, pat. Japi kaemʉt. Japi jʉm-aech Jesús pejnachalaliajwa: —¿Ma-aech xotkat xaelam, afambej, impuesto mat-omwʉljoew sʉapich, asew babejchow sʉapichbej? —aechi Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús japox jʉmtaen wʉt, jʉm-aechon: —Jiw woen woe-el nejchaempi, japi bʉ'xaenka-el xot. Jiw woen fʉlaen bʉ'xaenkpi woeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Xanlap-is, ja-an. Xan pas-enil tadʉsliajwan, jiw pachaem wʉt, kabʉan-aechpi. Xanlax patx babejchow tadʉsliajwan, japi kofaliajwa padujnejchaxoelaxan Dios naexasisliajwapi —aech Jesús japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Fariseos, judíos chanaekabʉanapibej, jʉm-aech Jesúsliajwa: —Juan pejnachala, xanal tajnachalabej, naxae-el piach Dios kawʉajnaliajwa wʉt. Pelax nejnachala, jachi-el. Japi asbʉan jʉmch xael —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Do jawʉt, Jesús jʉm-aech: —Aton pawis fit wʉt, fiesta is wʉt, tadʉchpi xaeyaxaelfʉk japonxot. Nejchachaemlaxaeli, pajelnakjiyan duk wʉtfʉk jaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Do asamatkoi, asew jiw fe'naxaeson. Do jawʉt, tadʉchpi naxaeyaxil kaematkoi sʉapich, xabich nejxaejwaxaes xoti. Jachiyaxaelbej, asamatkoi tajnachala nejxaejwaxaes wʉt, asew jiw xan nabʉ'fol wʉt. Samata, kaematkoi sʉapich naxaeyaxili, xan japixotaxinil xot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús jʉm-aech wʉajantat japi jiwliajwa. Jʉm-aechon: —Pawis pejyiaf, padujax, wexaxarwas wʉt, pejyiaf, pajelax, tasiaplaxilow xape'sliajwa padujax yiafxot. Japox is wʉt, tabejsaxaelow pajelax yiaf. Yiafbʉ'ch, pajelax, najʉpa-el xot, pachaemaxil, padujax yiaf sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aton wʉlʉ wʉtbej pajelvino padujchoxantat, japachoxan chathialfalaxael, pajelvino xabich xot pafak. Ja-aech wʉt, nafo'axael vino, choxan sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Samata, jiw wʉlʉ pajelvino pajelchoxantat, choxan nadadoe'aliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jiw af wʉt vino, piach cha-ekpot, ja-aech wʉt jiw fe-el, vino pajeltpot. Ja-aech, jiw nejchaxoel xot: ‘Vino piach, cha-ekpot, kaes pejme pachaem’ —aech xoti, nejchaxoel wʉt —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Asamatkoi, napatamatkoi wʉt, Jesús, pejnachala sʉapich, trigolulantutat fol wʉti, japon pejnachala trigo jolbala xaelpaliajwa, litaxaela xoti. Kilaninapi boksliajwa trigofukal xaelpaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jaxot kaesʉapich fariseos nakfol. Japi nejchaxoel: “Jesús pejnachala sitae-el napatamatkoi, jolbala wʉti trigo” —aechi, nejchaxoel wʉt. Samata, jʉm-aechi Jesús pejnachalaliajwa: —Japox isaxisal napatamatkoitat. ¿Ma-aech xotkat xamal trigo jolbalam naktapae-elmatkoitat? —aechi Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús japox jʉmtaen wʉt, jʉm-aechon: —Xamal xaljowam matabijaliajwam, wajwʉajnapijin, waj-am rey David, ispox chajiakolaxtat, xabich litaxaela wʉt, pejjiw sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Do jawʉt, David Dios pejba, xananʉamsba, lechon. Japabaxot wʉajna pan oel mesamatwʉajtat. Japapan ofrenda Diosliajwa. Rey David japapan xael wʉt, chaxduwbejpon pejjiw, japibej xaeliajwa japapan. Pe Moisés chajia lelpox jʉm-aech: ‘Japapan koew sacerdoteskal xaeliajwa, japi nabisti Dios pejbatat. Asew jiw xaeyaxil japapan’ —aech Moisés chajia lelpox. Pe rey David Dios kastika-esal, xael wʉton Dios pejew pan —aech Jesús fariseosliajwa. (Jasoxtatbej Jesús pejnachala kastikaxisal, trigo jolbala wʉt xaelpaliajwa napatamatkoitat.) ");
INSERT INTO guoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús pejme jʉm-aech fariseosliajwa: —Xan puexa jiw pakoewkolnan. Xan xajʉpx jʉmchiliajwan jiw isaxaelpox napatamatkoitat —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Asamatkoi, napatamatkoi wʉt, Jesús lech judíos naewʉajnaba poxade. Jaxotde wʉt, tʉaduton naewʉajnaliajwa. Jaxot kaen aton ek, poklake-elel kemamalpon. ");
INSERT INTO guoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Judíos chanaekabʉanapi, fariseosbej, japi natachaema, Jesús boejthʉsaxael wʉt kemamalan napatamatkoitat, jawʉt tasalaliajwas Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús matabijt japi nejchaxoelox japonliajwa. Samata, Jesús jʉm-aech kemamlanliajwa: —¡Nande! ¡Nukde jiw pejwʉajnalel! —aechon. Kemamlan nant wʉt, nuklison jiw pejwʉajnalel. ");
INSERT INTO guoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Do jawʉt, Jesús jʉm-aech japi jiwliajwa: —Xamal wʉajnachaemsaxaelen. ¿Achaxkat jʉm-aech Moisés chajia lelox? ¿Achaxkat Dios naktapaei isliajwas napatamatkoitat? ¿Isaxaeskat pachaempox? O, ¿isaxaeskat pachaema-elpox? O, ¿boejthʉsaxaeskat? O, ¿boesaxaeskat ampon aton? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Do jawʉt, Jesús natachaemt jiw masajiachpi. Jawʉt jʉm-aechon kemamlanliajwa: —¡Kedolde! —aechon. Kedolt wʉt, japon aton pejke-e chiekal wepachaems. ");
INSERT INTO guoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pe judíos chanaekabʉanapi, fariseosbej, japox taen wʉt, xabich palalapi Jesúsliajwa. Samata, nakaewa najʉm-aechi: “¿Machiyaxaeskat Jesús?” —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Asamatkoi Jesús fʉlaech pinamʉax poxade Dios kawʉajnaliajwa. Jaxotse pomadoicha Dios kawʉajan. ");
INSERT INTO guoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Do kandiawasap wʉt, Jesús la pejnachala, japi fʉlaeliajwadin japonlel. Japi pat wʉt japonxot, japixot makanoton doce poejiw japi chalaliajwaspon. Do jawʉt, japi wʉlduwpon apóstoles. ");
INSERT INTO guoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Doce poejiw, makanochpi, kaen pawʉl Simón. Japon asawʉltat wʉlduws. Pawʉlon Pedro. Asan pawʉl Andrés. Japon Simón pakoewan. Asan pawʉl Santiago. Asan pawʉl Juan. Asan pawʉl Felipe. Asan pawʉl Bartolomé. Asan pawʉl Mateo. Asan pawʉl Tomás. Asan pawʉl Santiago. Japon Alfeo paxʉlan. Asan pawʉl Simón. Japon majt asamʉtpijin, celotemʉtpijin. ");
INSERT INTO guoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Asan pawʉl Judas, Santiago paxʉlan. Asan pawʉl Judas Iscariote. Japonlap asamatkoi wiasaxael Jesús, Jesús padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús baloek mʉaxxotsik, pej-apóstoles sʉapich. Baloek wʉt, najapnaxxot nuili. Xabich pejnachala natameja japonxot. Xabich asew jiwbej jaxot natameja. Japixot, asew Judea tʉajnʉpijiw. Asew Jerusalén paklowaxpijiw. Asew Tiro paklowaxpijiw. Asew Sidón paklowaxpijiw. ");
INSERT INTO guoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Japi jiw puexa patlisi Jesús naewʉajanxot jʉmtaeliajwa, boejthʉsliajwasbejpi bʉ'xaenkpoxan. Nabijatpibej dep pijaxantat, japibej pat boejthʉsliajwas. ");
INSERT INTO guoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Samata, puexa japi jiw jachasiapi Jesús, Jesús boejthʉsfʉl xot jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús natachaemt wʉt puexa pejnachalaliajwa, jawʉt jʉm-aechon japiliajwa: “Xamal najut nejchaxoelam wʉt: ‘Dios nakkajachawaes-el wʉt, xajʉpaxinil isliajwan pachaempoxan’ —am wʉt, Dios kajachawaesaxael xamal. Ja-aech wʉt, xamal xabich nejchachaemlaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Xamal isasiam wʉt pachaempoxan Diosliajwa, japon kajachawaesfʉlaxael isfʉlaliajwam japoxan. Ja-am wʉt, xabich nejchachaemlaxaelam. “Amwʉtjel nabijalaelpampim, nabijatam xot ampathatat, Dios xamal kajachawaesaxael pachaemaliajwam. Ja-am wʉt, xabich nejchachaemlaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","“Asew jiw nejweslaxael xamal. Japi isaxael chaemilpoxan xamalliajwa. Jʉmchiyaxaelbejpi xamalliajwa: ‘¡Xamal chijiamde nejlel!’ —chiyaxaelbejpi. Jʉmchiyaxaelbejpi babejjamechan xamalliajwa. Jʉmchiyaxaelbejpi asew jiw jʉmtaeliajwa xamalliajwa: ‘Ampi jiw chaemil, babejchow xot’ —chiyaxaelbejpi. Puexa japoxan jachiyaxael, xamal tajjiwam xot, xan puexa jiw pakoewkolnan. Japoxan ja-aech wʉt, ¡xamal xabich nejchachaemilde! Diosxotse Dios xamal chaxduiyaxael xabich pachaempox. Samata, ¡nejchachaemilde, japamatkoi pasaxael wʉt! Xamal nejweslapi, japi jiw pejwʉajnapijiwbej chajia babijaxan is Dios pejprofetasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Xamal kemaenkampim, xabich nabijasaxaelam, xanejchachaemlam xot ampathatpijaxankal. ");
INSERT INTO guoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Amwʉtjel nejchaxoelam wʉt, jʉm-am: ‘Xan nejchachaemlax, puexa xabich xot tejew’ —am, nejchaxoelam wʉt. Pe asamatkoi xabich nabijasaxaelam. Me-ama asew kaematkoi nafnia wʉt, do jawʉx, pejme xabich litaxaelapi, xamalbej jachiyaxaelam. “Amwʉtjel xafafolampim, asamatkoi xabich noeyaxaelam, nabijasaxaelam xot. Jawʉtbej nejchachaemlaximil. ");
INSERT INTO guoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Chajiakolaxtat Dios pejprofetakola-elpi chiekal duila-el, me-ama Dios nejxasink. Japi jiw chiekal naewʉajna-elbej Dios pejjamechan, japiliajwa jiw nejchachaemlaliajwas. Samata, japamatkoiyantat jiw jʉm-aech chimiajamechan profetakola-elpiliajwa. Samatabej, ampamatkoiyantat jiw jʉm-aech wʉt chimiajamechan xamalliajwa, ¡chiekal taem! Xamal chiekal bej duila-emilbej. Chiekal bej naewʉajna-emilbej Dios pejjamechan. Ja-am wʉt, xamal asamatkoi xabich nabijasaxaelam” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesús pejme jʉm-aech pejnachalaliajwa: “Xamal xan nanaewetampim xan jʉm-anox. ¡Xamal nejxasinkde nadaelmajiw! ¡Isde pachaempoxan xamal nejweslapiliajwa! ");
INSERT INTO guoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nadaelman nejchaxoel wʉt babijaxan xamal chapasliajwa, ¡xamallax nejchaxoelde japon chapasliajwas pachaempoxan! Asew jiw babejjamechan jʉm-aech wʉt xamalliajwa, ¡Dios kawʉajande japi jiw kastikasamatas! ");
INSERT INTO guoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aton, matxoela-ispon babijax xamalliajwa, ¡xamallax nabej is babijax japon atonliajwa! Samata, aton xamal ba'faselcha wʉt, ¡asaba'falel nej selchapon! Aton xamal wenatkowa wʉt sumta-otampox, ¡nej fispanox pijaxliajwa! ¡Nijax kamisbej nej fispon pijaxliajwa! ");
INSERT INTO guoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aton malech xamal wʉljow wʉt, ¡japon chaxdu'e! Asan aton natkowa wʉt nijax, ¡nabej wʉljoe' wiasliajwapon natkowapox! ");
INSERT INTO guoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","¡Amalis isde pachaempoxan asew jiwliajwa, me-ama xamal nejxasinkam japi jiw isfʉlaliajwa xamalliajwa!” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Do jawʉt, Jesús pejme jʉm-aech pejnachalaliajwa: “Xamal nejxasinkam wʉt jiw xamal nejxasinkpikal, ja-am wʉt, ¿ma-aech xotkat nejchaxoelam Dios pachaemaxaelpox xamalliajwa? Jiw babejchowbej nakaebabejchow nanejxasink. ");
INSERT INTO guoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Xamal isfʉlam wʉtbej pachaempox japi jiwliajwa, japi jiw isfʉl xot pachaempox xamalliajwa, ja-aech wʉt, ¿ma-aech xotkat nejchaxoelam: ‘Dios pachaemaxael xanliajwa’ —amkat, nejchaxoelam wʉt? Jiw babejchowbej nakaebabejchowliajwa is pachaempoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Xamal prestam wʉt jiw matabijampikal, ja-am xamal japi jiw pejme wewiasliajwa prestampox, prestampox nafo'asamata. Ja-am wʉtbej, ¿ma-aech xotkat nejchaxoelam Dios pachaemaxaelpox xamalliajwa? Jiw babejchow nakaebabejchow napresta pejme wewiasliajwas naprestapoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","¡Nejxasinkde nadaelmajiw! ¡Isdebej pachaempoxan japiliajwa! Prestam wʉt, ¡prestampoxan nabej wʉajnawes! Ja-am wʉt, Dios isaxael xabich pachaempox japonxotse xamalliajwa prestampoxanliajwa. Ja-am wʉt, me-ama Dios athʉpijin, paxʉlan sʉapich, kaenejchaxoelax, jachiyaxaelambej xamal. Dios isfʉl pachaempoxan jiw babejchowliajwa. Asew jiw Dios kajachawaechpibej, japi nejchaxoela-el Diosliajwa. Japi jiwliajwa, Dios is pachaempoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","¡Beltaem asew jiw! Me-ama nej-ax Dios puexa jiw beltaefʉl, ¡xamalbej ja-amsfʉlde!” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús pejme jʉm-aech pejnachalaliajwa: “¡Xamal asew jiwliajwa nabej jʉm-aeche': ‘Japi jiw babejchow’ —nabej aeche'! Ja-am wʉt, Dios jʉmchiyaxil xamalliajwa: ‘Xamalbej babejchowam’ —chiyaxilon. ¡Nabej jʉm-aeche'bej asew jiwliajwa: ‘Japi wewe'pas Dios kastikaliajwas’ —nabej aeche'bej! Ja-am wʉt, Dios jʉmchiyaxilbej xamalliajwa: ‘Xamal wewe'p xan kastikaliajwan’ —chiyaxil Dios xamalliajwa. Asew jiw babijaxan is wʉt xamalliajwa, ¡beltaem! Ja-am wʉt, Diosbej xamal beltaeyaxael babijaxan isampoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jiw wewe'pas wʉt, ¡chaxduim! Ja-am wʉt, Diosbej xamal chaxduiyaxael wewe'ppoxan. Asew jiw chaxduwam wʉt, Dios kaes pejme xamal chaxduiyaxael” —aech Jesús, pejnachala naewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús pejme jʉm-aech, pejnachala naewʉajan wʉt: “Nakae-itliakla namakxalaeyaxil. Itliaklan asan makxafol wʉt, japi kolenje kaemʉthadik natacholnaxaek. ");
INSERT INTO guoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Estudiapon kaes pejme pachaema-el. Me-ama chanaekabʉanaspon, jachi-elon. Pe asamatkoi, puexa matabijt wʉton, japon najʉpaxael. Me-ama pejchanaekabʉanan wʉt, jachiyaxaelon” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Do pejme Jesús jʉm-aech, naewʉajan wʉt pejnachala: “Xamal najut kaes babijaxan isam wʉt, ¡xamal nabej naewʉajne', asan aton babijax is wʉt! Aton, asan kajachawaesasia wʉt, cha-aelaxach, ast it-okspon, japon pajutlax kaes pejme pinjiyax naetamat it-oks wʉt, jasoxtat japon aton asan aton kajachawaesaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Xamal kaes babijaxan isam wʉt, ¡nabej jʉm-aeche' asanliajwa: ‘Xam naewʉajnaxaelen, babijax is-elaliajwam’ —nabej aeche', naekichachajbapijnam wʉt! ¡Majt xamal kofim babijaxan isfʉlampoxan! Ja-am wʉt, pachaemaxael asan aton naewʉajnaliajwam japon kofsliajwa babijaxan ispoxan” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús pejme naewʉajan wʉt pejnachala, jʉm-aechon: “Pachaemnae naboet wʉt, pejbaechbej pachaem. Chaemilnae naboet wʉt, pejbaechbej chaemil. ");
INSERT INTO guoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kaenanʉla naebaechnaechan matabijas pejbaechtat. Na-e'naexot tus-el higobaech. Ja-aechbej uvadunanliajwa. Uvadunan chajalka-eli na-e'naexot. ");
INSERT INTO guoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ja-aechbej jiwliajwa. Aton, wepachaemspon pejnejchaxoelax, japon aton naksiya pachaempoxan. Aton, wepachaema-esalpon pejnejchaxoelax, japonlax naksiya babejjamechan. Japi kolenje japoxan naksiya, pejnejchaxoelaxanxot nakolapoxan” —aech Jesús, naewʉajan wʉt pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Do jawʉt, Jesús pejme jʉm-aech, naewʉajan wʉton doce pejnachalaliajwa, asew jiwliajwabej: “Xamal naexasis-emil wʉt xan jʉm-anpox, ¿ma-aech xotkat najʉm-am: ‘Tajpaklon, tajpaklon’ —na-amkat? ");
INSERT INTO guoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Xanlel fʉlaenpon, japon xan nanaewet. Nanaexasitbejpon xan jʉm-anpoxan. Xamal jʉmchiyaxaelen, achan kabʉan-aech xanlel fʉlaenpon. ");
INSERT INTO guoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Japon aton ba isan, kabʉan-aech. Kowpon sat tinkxot ba isliajwa. Nosnaechan mʉthapon. Do jawʉx, pejba toet wʉt, pinamin pat wʉt, japaba taxʉ'palaxil, chiekal isas xot sat tinkxot. ");
INSERT INTO guoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Xan jʉm-anpox jʉmtaenpon, pe naexasis-el wʉton, japon aton, me-ama thaejtat ba ispon, kabʉan-aechon. Nosnaechan mʉthapon thaejtat. Dolison pejba isax ketoet wʉt, pinamin wʉt, japaba chiekal jʉwʉl, jaxot thaejtkal xot. Samata, japaba chiekal toep” —aech Jesús, naewʉajan wʉt doce pejnachalaliajwa, asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús bʉxtoet wʉt naewʉajnax, fʉlaechon Capernaum paklowax poxade, doce pejnachala sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Capernaum paklowaxxot duk soldawcapitán, Roma gobiernoliajwa nabistpon. Japon capitán xabich nejxasink pamakan. Japon pamakan xabich bʉ'xaenk. Mox pawʉajnapon tʉpaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Japon capitán wʉltaen Jesús jiw boejthʉsfʉlpox. Samata, capitán to'a kaesʉapich judíos-ancianos japi bʉflaeliajwadin Jesús, boejthʉsliajwapon capitán pamakan. ");
INSERT INTO guoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dolisi, Jesúsxot pa'a wʉt, xabich tadʉti Jesús. Jʉm-aechi Jesúsliajwa: —Tajpaklon, kijʉm-amse, capitán xabich pachaempon. Samata, ¡xam nakfʉlaem xanal japon pejba poxade, japon pamakan boejthʉsliajwam! ");
INSERT INTO guoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Japon capitán naknejxasink xatis judíos. Japonbej nawemot asew jiw isliajwa xanal tajnaewʉajnabaliajwa —aech judíos-ancianos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Do jawʉt, Jesús nakfol japi. Dolison, mox wʉtlejen capitán pejba pasliajwa, capitán to'a pejnachala japi bʉ'kakʉlnaliajwa Jesús. Do jawʉt, bʉxto'abejpon pejnachala japi jʉmchiliajwa Jesús: “Tajpaklon, xam kaes mox pasaximil tajcapitán pejba. Japon jʉm-aech: ‘Xan kaes pachaema-enil Jesús pasliajwa tajba, japon kaes pejme paklon xot. ");
INSERT INTO guoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Samata, xan tajut fʉlae-enil wʉljaesliajwan Jesús. ¡Jaxotde nej nawiaspon! ¡Nej jʉm-aechapon tamakanliajwa, japon boejthʉlaliajwas! Ja-aech wʉt, tamakan naweboejthʉlaxaes. ");
INSERT INTO guoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Xanbej tajpaklochow. Japi naketo'a wʉt, xan ow-an. Xanbej soldawcapitánan. Kaen to'ax wʉt, japon na-ow-aech. Asan lax wʉt, japon fʉlaen. Tamakan keto'ax wʉt, japox chiekal jinawe-ispon. Jesúsbej tato'lan. Jʉm-aech wʉton tamakanliajwa, tamakan chiekal boejthʉlaxaes’ —aech soldawcapitán, xanal nabʉxto'a wʉt xam jʉmchiliajwan” —aech soldawcapitán pejnachala Jesús jʉmtaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús japox jʉmtaen wʉt, capitán jʉmxato'apox, japonliajwa xabich nejchaxoelanukon, xabich xanaboejtas xot. Do jawʉt, Jesús natfo'cha wʉt, natachaemton jiw fʉlafospilel. Do jawʉt, jʉm-aechon japiliajwa: —Diachwʉajnakolax xamal jʉm-an. Israel tʉajnʉxot aton tae-enil, xan xabich naxanaboejtpon, me-ama japon aton, jason —aech Jesús soldawcapitánliajwa, jʉmtaeliajwa fʉlafospipon. ");
INSERT INTO guoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jawʉt capitán to'asi nawia capitán pejba poxade. Pa'a wʉt, taenlisi capitán pamakan chiekal boejthʉlspox. ");
INSERT INTO guoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Asamatkoi Jesús fʉlaech wʉt Naín paklowax poxade, pejnachala nakfolspon. ");
INSERT INTO guoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Paklowax mox itwefol wʉti, Jesús taen, asew jiw patʉpan mʉthsliajwa chaxfol wʉti paklowax tathoetlel. Patʉpan pen, pamal naetʉpspow. Japow kaen paxʉlan tʉpon. Xabich jiw, Naín paklowaxpijiw, fʉlchalas. ");
INSERT INTO guoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús japow taen wʉt, beltaenpon. Do jawʉt, jʉm-aechon japowliajwa: —¡Nabej wʉnoe'! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Japox jʉm-aech wʉt, Jesús mox soepan patʉpanxot. Do jawʉt, Jesús camilla takʉksaba wʉt, patʉpan chaxfoli chaxnuiljaba. Do jawʉt, Jesús jʉm-aech patʉpanliajwa: —Pansian, xan jʉm-an xamliajwa: ‘¡Mat-e'e pejme dukaliajwam!’ —an xan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Do jawʉt, patʉpan chalechkal mat-et. Mat-et wʉt, naksiyalison. Do jawʉt, Jesús jʉm-aech japon penliajwa: —Ma naxʉlan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jiw japox taen wʉt, puexa xabich belwanapi. Jʉm-aechnapi: —Dios xabich mamnik. Xajʉp puexa isliajwa. Poklaprofetakolan patlison xatisxot. Dios fʉloek kajachawaesliajwa pejjiw —aechnapi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Xabich jiw, Judea tʉajnʉpijiw, mox duilibej Judea tʉajnʉxot, japi wʉltaena Jesús patʉpan mat-etpox. ");
INSERT INTO guoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan, jiw bautisan, jiw jebatat jias wʉt, pejnachala chapaeflas Jesús isfʉlpoxanliajwa. Asamatkoi Juan wʉllala kolenje pejnachalan, japi to'aliajwapon Jesús poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Juan japi bʉxto'aliajwa wʉt, jʉm-aechon: “Jesús wʉajnachaemtam wʉt, ¡jʉm-amopon: ‘¿Xamkatlap diachwʉajnakolax Cristowam, jʉmduchponam puexa jiw bʉ'weliajwam? Xam Cristowa-emil wʉt, ¿xanalkat kaes wʉajnawesaxaelen asan pasaxaelpon?’ —amo Jesús!” —aech Juan, bʉxto'a wʉt kolenje pejnachalan. ");
INSERT INTO guoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juan pejnachala pat wʉt Jesúsxot, jʉm-aechi ampox: —Juan, jiw bautisan, xanal nabʉxto'a xam wʉajnachaemsliajwan. ¿Xamkatlap diachwʉajnakolax Cristowam, Dios jʉmduchponam puexa jiw bʉ'weliajwam? Xam Cristowa-emil wʉt, ¿xanalkat kaes asan wʉajnawesaxaelen, pasaxaelpon? —aech Juan pejnachala Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Do jawʉt, japi pejwʉajnalel Jesús xabich jiw bʉ'xaeya boejthʉt, bʉ'xaenki nejmachwaxaetat. Jiw, pejmatpʉatanxot dep webaespi, to'apon dep nakolaliajwa jaxot. Boejthʉtbejpon xabich itliakla japi taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Do jawʉt, Jesús jʉm-aech Juan pejnachalaliajwa: —¡Xabʉa'de! ¡Nawem Juan poxade! Juanxot patam wʉt, ¡Juan chapaem koechaxan taenampoxan, wʉltaenampoxanbej! Juan chapaeyam wʉt, ¡jʉm-amo: ‘Itliakla chiekal taen. Nabejkabej chiekal laelp. Piach leprawaxaetat bʉ'xaenkpibej, japi chiekal boejthʉls. Naetakʉatabej chiekal jʉmtaen. Patʉpabej mat-ias pejme duilaliajwa’ —amo Juan, chapaeyam wʉt! ¡Chapaembejpon naewʉajnaxpoxan kejila, japibej naexasisliajwa, Dios bʉ'weliajwasbejpi babijaxan ispoxanliajwa! ");
INSERT INTO guoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Juan chapaeyam wʉtbej, ¡jʉm-amopon: ‘Nejmach-aton chiekal naxanaboejsfʉl wʉt, nanaexasisfʉl wʉtbejpon xan Cristowanponan, japon aton nejchachaemlafʉlaxael’ —amo Juan, chapaeyam wʉt! —aech Jesús Juan pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Do jawʉx, Juan pejnachala nawia Juan poxade. Nawia wʉti, jawʉt, Jesús tʉadut jiw jʉmchiliajwa Juanliajwa. Jʉm-aechon: “Juan, jiw bautisan, pajilaxxot duk wʉt, xamal fʉlaemch japoxade. Fʉlae-emil taeliajwam muifʉrtʉat joewa jʉ'baspox. ");
INSERT INTO guoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Xamal fʉlae-emildebej taeliajwam kaen aton chamoeyaxan naxoelpon. Xamal chiekal matabijam, chimianaxoeipi duila-el pajilaxtat. Jiw chimianaxoeipi duil chimiabachantat. Japi duil paklochow pejbachantat. ");
INSERT INTO guoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Xamallax fʉlaemch taeliajwam profeta. Diachwʉajnakolax jʉm-an. Xamal Juan taenam wʉt, taenam poklaprofetakolan. ");
INSERT INTO guoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dios pejjamechan, chajia lelsxot, jʉm-aech Dios najʉm-aechpox xanliajwa, Juan isaxaelpoxliajwa: ‘Wʉa, xam wʉajna tajprofeta to'axaelen japon jiw naewʉajnafʉlaliajwa tajjamechan, xam patam wʉt jiw chiekal naexasisliajwa xam’ —aech chajia lelsxot Dios najʉm-aechpox xanliajwa, Juan isaxaelpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kaes pejme pachaempi, profetas, ajil, me-ama Juan, jiw bautisan, jasi. Pe nakiowa, Diosxotse wʉt, jaxotse japi jiw puexa chiekal isfʉl Dios nejxasinkpoxan. Japi kaes pejme pachaemaxael Dios pejwʉajnalel. Me-ama Juan ampathatat, jachiyaxili” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Xabich jiw jʉmtaen Juan naewʉajanpox. Impuesto mat-omwʉljoewbej jʉmtaen. Japi naexasit wʉt, Juan japi jiw bautisa, japi matabija xot Dios xabich pachaempon. ");
INSERT INTO guoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseos, judíos chanaekabʉanapibej, naekʉanjiamt Juan naewʉajanpox. Isfʉla-eli Dios nejxasinkpox. Samata, Juan japi jiw bautisa-el. ");
INSERT INTO guoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Do pejme Jesús jʉm-aech jiwliajwa: “Ampamatkoiyantat jiw duilpi ampathatat, japi jiw, me-ama yamxi wʉt, ja-aechi, kaenejchaxoelaxa-el xot. Me-ama yamxi chalak paklowaxplazaxot nakakujsliajwa, ja-aech japi jiw. Yamxi chalak wʉt, pejnachala sʉapich, nakaewa najʉm-aechi: ‘Xanal toela nababax xamal nababoelaliajwam. Pe xamal nababoela-emil, jʉmtaenam wʉt toela. Xanal jajui jajuwxbej xamal noeliajwam. Pe xamal noe-emil, jʉmtaenam wʉt’ —na-aech nakaewa yamxi, nalot wʉt plazaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan, jiw bautisan, japon ampathatat wʉt, Dios pejjamechan naewʉajnafʉlon. Xabich piach naxae-elon, Dios kawʉajnaliajwa wʉt. Vino fe-elbejpon. Ja-aech wʉt, xamal jʉm-am: ‘Juan dep webaes pejmatpʉatxot’ —amsfʉlam. ");
INSERT INTO guoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Do jawʉx, xan, puexa jiw pakoewkolnan, fʉlaenx. Xanlax puexa xaelx. Puexa afxbej. Ja-an wʉt, xamal jʉm-ambej xanliajwa: ‘Japon xabich xaemaenk. Femaenkbejpon vino. Pejnachala babejchowbej. Pejnachalabej impuesto mat-omwʉljoew Roma gobiernoliajwa’ —am xamal xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pelax jiw matabijasiapi Dios, japi naexasisfʉl Juan jʉm-aechpoxan, xan jʉm-anpoxanbej. Japi matabijaxael diachwʉajnakolaxpox Juanliajwa, xanliajwabej” —aech Jesús jiw naewetiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo-aton, pawʉlpon Simón, japon tadʉt Jesús xaeliajwa japon pejbatat. Samata, Jesús fʉlaech japon pejba poxade xaeliajwa, japon sʉapich. Jesús pat wʉt, ekon mesaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Japapaklowaxxot pawis duk. Japow asew poejiw bʉ'moejtpow plata kanaliajwa. Japow wʉltaen Jesús xaeyaxaelpox Simón pejbatat. Samata, japow fʉlaech japaba poxade Jesús taeliajwa. Japow xapat perjumamint alabastro-ia' batiajtat, chiekal wʉlʉkat. ");
INSERT INTO guoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dolisow, brixtat nuk Jesús pejtʉaktabijla, Jesús chafanaliajwas perjumamint. Japox isliajwa wʉt, chalechkal noeyax tʉadutow, xabich nejxaejwas xot babijaxan ispoxanliajwa. Pej-itmin natacholan Jesús pejtʉaktametat. Do jawʉt, pejmatlatat Jesús tʉaktamejoeipow. Tʉaktamesuwpow Jesús. Japaperjumamintat chafanpow Jesús pejtʉaktame. ");
INSERT INTO guoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simón, japon tadʉtpon Jesús xaeliajwa, taen wʉton japox, nejchaxoelon Jesúsliajwa: “Diachwʉajnakolax ampon profeta wʉt, matabijsaxaelon, achaow japow pawis. Matabijsaxaelbejpon japow babejowpow” —aech Simón, nejchaxoel wʉt Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Simón japox nejchaxoel wʉt, Jesús jʉm-aech: —Simón, xam asax jʉmchisian —aech Jesús. Simón jʉmnot wʉt, jʉm-aechon: —Jiw chanaekabʉanan, ¡jʉm-amde najʉmchisiampox! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Do jawʉt, Jesús jʉm-aech: —Plata prestapijin, kolenje aton plata dewataspon. Kaen dewatas quinientos denarios. Asan dewataspon cincuenta denarios. ");
INSERT INTO guoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Japi kolenje plata kejil wewiasliajwapi prestaspon. Samata, prestapijin jʉm-aech japiliajwa: ‘Xamal nadewatampoxan xan kaes mat-omwʉljoeyaxinil’ —aechon. Japox jʉm-aech wʉt, ¿achankat japi kolenjexot kaes pejme nejxasinkaxaes? —aech Jesús Simónliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón jʉmnot wʉt, jʉm-aechon: —Kaes dewatpon, japon kaes nejxasinkaxaes —aech Simón Jesúsliajwa. Do jawʉt, Jesús jʉm-aech: —Diachwʉajnakolax xam chiekal xatbijam —aech Jesús Simónliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Do jawʉt, Jesús natachaemt wʉt pawis, pejme jʉm-aechon Simónliajwa: —Xam taenam pawis ispox. Nejba lowx wʉt, nachaxdus-emil min xan tajtʉak kiasliajwan, me-ama xatis wajkabʉan. Ampow pawislax natʉakkiat pej-itmintat. Natʉakmo'tbejpow pejmatlatat. ");
INSERT INTO guoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nejba patx wʉt, naxusui-emil chiekal nabʉ'kʉlsliajwam. Ampow pawislax, xan ba lowx wʉt, natʉaksuw, nasitaen xotow. ");
INSERT INTO guoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Chiekal nabʉ'kʉlsliajwam, xan namatnaechafana-emil olivosimint. Ampowlax perjumamint natʉakchafan. ");
INSERT INTO guoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Samata, jʉm-an: “Japow babijaxan ispoxanliajwa, wexabichaspoxan, beltaens, xabich xan nanejxasink xotow” —an xan. Jiw kaesʉapich babijaxan ispoxanliajwa beltaens wʉt, japi kaesʉapich itpaeyaxael pejnejxasiyax Diosliajwa —aech Jesús Simónliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Do jawʉt, Jesús jʉm-aech japowliajwa: —Xam babijaxan isampoxanliajwa xan beltaenx —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Asew jiw tadʉtaspi xaeliajwa Simón pejbatat, japi nakaewa nakawʉajnachaemt wʉt, jʉm-aechi: —¿Achankat ampon hasta jiw babijaxan ispoxan beltaeliajwa? —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús jʉm-aech pawisliajwa: —Xabich naxanaboejtam xot, Dios xam bʉ'wia nejbabijaxan. Samata, ¡xabʉa'de nejmach! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jesús Simón pejbaxot wʉt, japoxwʉx, mathʉnlison xabich paklowaxan, cha-aelpaklowaxanbej. Jesús japapaklowaxanpijiw naewʉajnafʉl chimiawʉajan, Dios puexa pejjiw tato'laxaelwʉajan. Doce apóstolespi, japi chala Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Chalasbejpon asew watho'. Japi watho' majt pejmatpʉatantat dep webaesi. Jesús chajia dep to'a nakolaliajwa japi watho'xot. Japi watho'xot, Jesús boejthʉtbej, chajia majt bʉ'xaenk wʉti. Japixot, kaeow pawʉl María. Japow Magdala paklowaxpijow. Japow majt pejmatpʉatat siete dep webaes. Jesús dep to'a nakolaliajwa japow pejmatpʉatxot. ");
INSERT INTO guoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jaxotbej asaow. Japow pawʉl Juana. Japow Cuza pijow. Japon Cuza, rey Herodes pejba tataeflan. Jaxotbej asaow. Japow pawʉl Susana. Jaxotbej kaes asew watho'. Japi watho' pejewtat kajachawaeti Jesús, pejnachalabej. ");
INSERT INTO guoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Xabich paklowaxanpijiw fʉlaen Jesús taeliajwa. Samata, xabich jiw natameja Jesúsxot. Jesús naewʉajan wʉt, wʉajantat jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kaen aton fʉlaech pejlul poxade, trigo xasaljabaliajwa. Xasaljaba wʉt, kaesʉapich natacholan nʉamtat. Dolisdo', jiw xaxena wʉt, japi trigo sae'enas. Do jawʉx, japafu mia xaes. ");
INSERT INTO guoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kaesʉapich trigo natacholan ia'xot. Jaxot as xanaja'al. Do jawʉx, japi trigo naboela wʉt, xabich masxaenk wʉtbej, japi trigo masxae selnas, sat chiekal pesnika-el xotdik. ");
INSERT INTO guoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kaesʉapich trigo natacholan na-e'lʉ tasiaptasxot. Japi trigo naboela wʉt, jawʉtbej, na-e'lʉ naboela. Na-e'lʉ tapae-el trigo ti'sax, na-e'lʉ kaes athʉ xot. ");
INSERT INTO guoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Asew trigo natacholan sat pachaemxot. Japi trigo chiekal naboela. Ti't wʉt, trigoton chiekal naboet. Trigoton naboet wʉt, kaenanʉla hasta cien trigo naboet” —aech Jesús. Jesús japox jʉm-aech wʉt, pinjametat jʉm-aechon: “Xamal matabijasiam wʉt Dios pejnejchaxoelax, ¡chiekal nanaewe'e xan jʉm-anpox!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pejnachala, japi wʉajnachaemt Jesús, chiekal matabijasia xoti, achax chiyaxael japox wʉajan, Jesús naewʉajanpox. ");
INSERT INTO guoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Do jawʉt, Jesús jʉm-aech chiekal chanaekabʉanaliajwapon pejnachala: “Dios xamal tapaei matabijaliajwam Dios tato'laxaelpox pejjiw. Asew jiw naewʉajnax wʉt wʉajantat, jʉmtaeni. Pe japi matabijaxil, achax chiyaxael japox wʉajan. Taen wʉti koechaxan isxpoxan, japi matabijaxil, ma-aech xot xan japoxan isx” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Amwʉt xamal chiekal chanaekabʉanaxaelen trigo xasaljabapon pejwʉajan. Japon aton, trigo xasaljaba satat. Japawʉajantat ‘Trigo’ —aech wʉt, japox jʉmchiliajwa: ‘Dios pejjamechan jiw naewʉajnaspox jʉmtaeliajwa, naexasisliajwabejpi pejnejchaxoelaxantat’ —chiliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","‘Trigo, natacholanpi nʉamtat’ —aech wʉt, japox jʉmchiliajwa: ‘Dios pejjamechan jiw naewʉajnas wʉt, japajamechan jʉmtaeni, do jawʉt, kamta nejkiowbejpi jʉmtaenpoxan. Do jawʉtbej, Satanás pat japi jiwxot, japon, me-ama mia, Dios pejjamechan wenosliajwas jiw pejnejchaxoelaxanxot. Samata, japi jiw Dios pejjamechan chiekal naexasisaxil Dios bʉ'weliajwas’ —chiliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","‘Trigo, natacholanpi ia'xot’ —aech wʉt, japox jʉmchiliajwa: ‘Jiw Dios pejjamechan jʉmtaen wʉt, japi jiw kamta naexasiti. Ja-aech wʉt, japi jiw nejchachaemil kaematkoiliajwa. Do jawʉx, Dios naexasit xoti, asew jiw bʉ'wʉajanpaeispi. O, chaemilpox wetapachpi. Do jawʉt, japi kaes Dios xanaboeja-el. Samata, me-ama trigotathin kasnika-el wʉt, naboes-el, ja-aechlap-is japi jiw. Do jawʉt, Dios pejjamechan naexasitpox kofapi’ —chiliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","‘Trigo, natacholanpi na-e'lʉ tasiaptasxot’ —aech wʉt, japox jʉmchiliajwa: ‘Jiw Dios pejjamechan jʉmtaen wʉt, kamta naexasiti. Do jawʉx, kofalisi, asaxan matakas xot pejnejchaxoelaxan, xabich nejchaxoel xotbej ampathatpijaxankal. Nejchaxoelbejpi xabich kemaenkaliajwa. Nejchaxoelbejpi isfʉlaliajwa pajut nejxasinkpoxan. Samata, pejxanaboejaxan Diosliajwa kaesfʉlaxil’ —chiliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","‘Trigo, natacholanpi sat pachaemxot’ —aech wʉt, japox jʉmchiliajwa: ‘Jiw jʉmtaen wʉt Dios pejjamechan, japi jiw chiekal naexasisfʉl naewʉajnaspox. Kofa-eli naexasisfʉlpox. Ja-aech wʉt, japi chiekal Dios xanaboejafʉl wʉt, me-ama trigoton xabich naboeti, ja-aech japi jiw’ —chiliajwa japox” —aech Jesús, chiekal chanaekabʉana wʉt pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Jiw lámpara tamdut wʉt, asaxtat matakasaxil. Cha-esaxilbej camabʉxfaltat. Jiwlax athʉ cha-esaxael bamʉaxnaetat, batu chiekal itliakaliajwa, lalenapi chiekal taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ja-aechbej tajnaewʉajnaxliajwa. Puexa japoxan, moechaspoxan, asamatkoi tulaelaxaesi. Puexa tajnaewʉajnax, amwʉtjel matabija-esalpoxfʉk, asamatkoi japoxan chiekal matabijaxaes” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Do pejme Jesús jʉm-aech pejnachalaliajwa: “¡Chiekal naewe'e xan jʉm-anpox! Tejew chiekal nawetataefʉlpon, japon aton kaes pejme chaxdusaxaelen. Asanlax chiekal nawetataefla-elpon tejew, kaesʉapich nawetataefʉlpox, kefisaxaeson” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Do jawʉt, Jesús pen, japon pakoewbej, mox pa'an Jesús naewʉajanxot jiw. Pe japi leyaxil kaes mox pasliajwadin Jesúsxot, xabich wʉajna jiw ba wʉlʉk xot. ");
INSERT INTO guoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Do jawʉt, batutat aton jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, nej-en, nakoewbej, pa'an. Japi nuil tathoetat. Xam taesiapi —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Do jawʉt, Jesús jʉm-aech jaxotiliajwa: —Jiw jʉmtaenpi Dios pejjamechan, naexasit wʉtbejpi, japi jiw, me-ama taj-en, takoewbej, ja-aechi —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Asamatkoi Jesús jʉm-aech: —¡Chijias puka we-enlelde! —aechon. Do jawʉt, Jesús jul falkam, pejnachala sʉapich. Jawʉt chaflaechlisi. ");
INSERT INTO guoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pukatutat chafol wʉti, Jesús nejmach moejt. Ja-aech wʉt, chalechkal xabich pinajoewa, pintruxanbej, pat. Falkamtu xabich min fajabas. Samata, xabich chachoel, chabʉ'laxael xoti. ");
INSERT INTO guoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jawʉt japi thikapi Jesús. Jʉm-aechipon: —Tajpaklon, ¡nathikde! —aechi. Do jawʉt, Jesús nant wʉt, fiatlison joewa, truxanbej. Fiat wʉt, joewa chiekal toep, truxanbej. Jawʉt puka chiekal itnapatan. ");
INSERT INTO guoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¿Amekat xamal xan naxanaboejampox? —aech Jesús. Do jawʉt, puexa xabich belwanapi. Xabich nejchaxoelanuilbejpi. Samata, nakaewa najʉm-aechi: —¿Achankat ampon aton? Joewa, pukabej, fiat wʉt, ¡naexasichpon! —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesús, pejnachala sʉapich, puka we-enlelde chapa'a Gerasa tʉajnʉxotde. Gerasa tʉajnʉ Galilea tʉajnʉtabijla. ");
INSERT INTO guoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Itjul wʉti, Jesús pʉtat nant wʉt, kaen aton japatʉajnʉpijin fʉlaen Jesúsleldin. Japon aton pejmatpʉatxot dep webaes. Piach bʉ'jʉmchalaejapon. Duka-el batat. Japon duk tʉpi mʉthasxot. ");
INSERT INTO guoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesúsxot pat wʉton, japon nuk brixtat Jesús pejwʉajnalel. Nejlat wʉt, jʉm-aechon: —Jesús, ¡Dios athʉpijin paxʉlan! ¿Achaxasiamkat xanxot? ¡Xam jʉm-an natalias-elaliajwam! —aech japon aton pejmatpʉatxot webaespon dep. ");
INSERT INTO guoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Dep webaespon japox jʉm-aech, Jesús to'a xot dep nakolaliajwa japon aton pejmatpʉatxot. Japon aton xabich mamnik dep pijaxtat. Jesús pas-el wʉtfʉk, pin-iaveces japon aton dep pijaxtat xabich chachoel jiwliajwa. Chalechkal japon aton, me-ama na-achanat wʉt, ja-aech xoton. Samata, jiw mʉaxwasixawaekson cadenamʉatat. Tʉakwasixawaeksbejpon, asew jiw chiekal tataeflaliajwas. Jasoxtat japon xawaeks wʉt, cadenamʉa likton. Ja-aech wʉt, dep pijaxtat najaeton pajilax poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús wʉajnachaemt wʉt dep webaeson, jʉm-aechon: —¿Achawʉlamkat xam? —aech Jesús. Japon jʉmnot wʉt, jʉm-aechon: —Xan tawʉl Xabich —aechon. Jasox japon aton jʉm-aech, pin-iat dep webaes xoton pejmatpʉatxot. ");
INSERT INTO guoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dep xabich jʉm-aech Jesús to'asamatas infierno poxadik. ");
INSERT INTO guoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mʉaxleltat pin-iat maran naxaelp. Samata, dep jʉm-aech Jesúsliajwa: —Ampon atonxot nakolax nato'asiam wʉt, ¡natapaem xanal leliajwan maranxot! —aech dep Jesúsliajwa. Do jawʉt, Jesús tapaei dep leliajwa maran pejmatpʉatanxot. ");
INSERT INTO guoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dolisdo', Jesús to'a dep nakolaliajwa japon aton pejmatpʉatxot. Jawʉt dep low maranxot. Do jawʉt, japi maran dʉkp chʉatadik, puka poxadik. Jaxotdik puexa maran chiekal bu'al. ");
INSERT INTO guoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Do jawʉtbej, maran tataefʉlpi japox taen wʉt, pejlewt dʉkpi pejpaklowax poxade chapaeliajwapi taenpox. Do jawʉt, chapaeilisi japapaklowaxpijiw, mox duilpibej. ");
INSERT INTO guoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Do jawʉt, jiw fʉlaen pajut chiekal taeliajwa jʉmtaenpox. Pat wʉt Jesúsxot, taenlisi japon aton, ek wʉton Jesús pejwʉajnalel, dep wejisal xotlison. Bʉ'la-eklison naxoelax. Chiekal pachaemlison. Fʉlaenpi japox taen wʉt, xabich beljowpi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Taenpi Jesús ispox japon aton chiekal pachaemaliajwa, japi chapaei taenpox fʉlaeniliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Do jawʉx, puexa Gerasa tʉajnʉpijiw xabich jʉm-aechi Jesús chijiyaliajwa japixot, xabich pejlewla xoti Jesúsliajwa. Samata, Jesús falkam jul chijiyaliajwa japatʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Do jawʉt, majt dep webaeson, xabich kawʉajan nakfʉlaeliajwapon Jesús. Pe Jesús tapae-el japon aton nakfʉlaeliajwas. Jesús to'a japon aton namanaliajwa pejtʉajnʉxot. Jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—¡Nawiamach nejba poxade! ¡Nejjiw chapaem puexa Dios ispox xamliajwa! —aech Jesús. Dolisdo', majt dep webaeson, fʉlaechlison pejba poxade. Puexa paklowaxpijiw chapaefʉllison Jesús ispox japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús Gerasa tʉajnʉlel nawian wʉt puka we-enleldin, xabich jiw wʉajnawechpon. Xabich nejchachaemili, Jesús taen wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jawʉt Jairo pat Jesúsxot. Japon judíos naewʉajnabaxot tato'lan. Jairo taen wʉt Jesús, brixtat nukon Jesús pejwʉajnalel. Sat makxabijindikbejpon. Jawʉt Jairo jʉm-aech Jesúsliajwa: —Xam tadʉtx nakfʉlaeliajwam tajba poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Taxʉlow, kaekolowpow, doce waechanpow, mox pawʉajna tʉpaliajwa —aech Jairo Jesúsliajwa. Do jawʉt, Jesús nakfol wʉt Jairo, jiw xabich pin-iat nakfolbej. Jiw xabichfʉl Jesús pejwʉajnalel, wʉchakallelbej. Natabe'nafʉli. ");
INSERT INTO guoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Japi jiwxot kaeow pawis wʉchakal fol. Japow bʉ'xaenk. Pejlaw wʉt, jal chiekal wematduka-esal. Doce waechan japow jasoxtat bʉ'xaenkpox. Xabich jiw woew wʉalachipow. Pe chinax kaen boejthʉs-esal japow. Xadaeptow puexa pejew plata nawoeyaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Japow Jesús wʉchakallel moxdepow. Do jawʉt, Jesús sumta-otox matdukafʉlpox jajastow. Jawʉt japow kamta chiekal boejthʉls. Jalbej chiekal matduk. ");
INSERT INTO guoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Do jawʉt, Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Achankat xan najajast? —aechon. Jawʉt puexa jiw jʉm-aechna: —¡Xanalxot xam jacha-enil! —aechi. Jawʉt Pedro jʉm-aech: —Tajpaklon, xam jiw xabich tabe'nafʉl, nakfol xoti —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Do pejme Jesús jʉm-aech: —Kaendo' najajast. Xan chiekal matabijtax kaen boejthʉtxpox —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Japow nejchaxoel: “Jesús matabijt xan naboejthʉtox. Samata, xan nawoesa tulaela jʉmchiyaxaelen” —aechow, nejchaxoel wʉt. Do jawʉt, japow tathʉlal pejlewt. Jawʉt brixtat nukow Jesús pejwʉajnalel. Jawʉtbej puexa jiw pejwʉajnalel chapaeipow, ma-aech xot jajastow Jesús. Chapaeibejpow chiekal boejthʉlsox, jajast wʉtow Jesús naxoelpox. ");
INSERT INTO guoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús jʉm-aech japowliajwa: —Jam, amwʉtjel xam chiekal pachaemam, xan chiekal naxanaboejtam xot. ¡Xabʉa'de nejmach! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús naksiya wʉtfʉk, Jairo pamakan pat Jesúsxot. Japon jʉm-aech Jairo jʉmtaeliajwa: —Naxʉlow tʉplisow. Samata, ¡nabej talias jiw chanaekabʉanan, nejba poxade nakfʉlaesamata! —aech Jairo pamakan. ");
INSERT INTO guoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús jʉmtaen wʉt Jairo pamakan jʉm-aechpox, naekʉanjiamton. Samata, Jesús jʉm-aech Jairoliajwa: —¡Nabej nejlewle' naxʉlow tʉppoxliajwa! ¡Dioskal xanaboejde! Naxʉlow Dios mat-esaxaes pejme dukaliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesús nakpat wʉt Jairo pejbaxot, tapae-elon asew jiw leliajwa. Jawʉt tapaeipon leliajwa Pedro, Santiago, Juan, Jairo, japon pijowbej. Japikal tapaeis leliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wʉajna tathoetlel puexa jiw xabich wʉnow. Do jawʉt, Jesús jʉm-aech wʉnowpiliajwa: —¡Kaes nabej wʉnoe'! Japow tʉpa-el. Japow moejt —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Japi japox jʉmtaen wʉt, xafafoli. Jawʉt Jesús bʉ'wʉajanpaeis. Japi chiekal matabija, japow diachwʉajnakolax chiekal tʉp. ");
INSERT INTO guoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Batutat wʉt, Jesús patʉpow kefit. Do jawʉt, pinjametat jʉm-aechon patʉpowliajwa: —Jam, ¡mat-e'e pejme dukaliajwam! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jesús japox jʉm-aech wʉt, patʉpow mat-et pejme dukaliajwa. Jawʉtlejen mat-ekchapow. Do jawʉt, nantlisow. Jesús to'a naxaeyax chaxdusliajwaspow. ");
INSERT INTO guoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Japow pax, penbej, japox taen wʉt, xabich nejchaxoelanuili. Jesús jʉm-aech japiliajwa: —¡Ampox asew jiw xamal nabej chapae', xan isxpox! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús la doce pejnachala, japi fʉlaeliajwadin japonlel. Pejnachala japonxot wʉt, Jesús jʉm-aech: —Xamal xabʉ'kʉlam wʉt jiw, dep webaespi pejmatpʉatantat, xan tajaxtat xajʉpaxaelam dep nakolax to'aliajwam. Xajʉpaxaelambej boejthʉsliajwam jiw bʉ'xaeya. ");
INSERT INTO guoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Samata, xamal to'ax jiw naewʉajnaliajwam Dios puexa pejjiw tato'laxaelpox. Boejthʉsaxaelambej bʉ'xaeya. ");
INSERT INTO guoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Folam wʉt jiw naewʉajnaliajwam, ¡nabej xalae' nejkilachalanaeyan! ¡Nabej xalae'bej choxan, naxaeyaxan, platabej! Mado' itʉakxajoelam, ¡do japoxkal tʉaklafʉlaem! Jachiyaxaelambej naxoelaxliajwa. Mado' inaxoelam, ¡do japoxkal bʉ'lafʉlaem! ");
INSERT INTO guoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Xamal paklowax patam wʉt, ¡kaebaxot duilde, jiw naewʉajnaliajwam japapaklowaxpijiw! Asapaklowaxlel fʉlaeliajwam wʉt, do jawʉt, ¡japabaxot nakolim! ");
INSERT INTO guoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Asapaklowaxpijiw xamal bʉ'kʉla-elasia wʉt, ¡japapaklowaxxot chijiamde fʉlaeliajwam asapaklowax poxade! Jawʉt, ¡nejtʉakxajoe jolde lʉlaliajwam as natacholnaliajwa! Jasoxtat japi jiw pajut matabijaxael babijax ispox Diosliajwa, xamal bʉ'kʉla-el xoti —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Do jawʉt, Jesús pejnachala follisi asatʉajnʉchan poxade. Naewʉajnafʉllisi Dios pejjamechan japatʉajnʉchanpijiw bʉ'weliajwas Dios. Boejthʉsfʉlbejpi bʉ'xaeya. ");
INSERT INTO guoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rey Herodes, Galilea tʉajnʉpijiw tato'lan, wʉltaen Jesús isfʉlpoxan. Pe matabijs-elon, achan Jesús. Wʉltaenbejpon, asew jiw jʉm-aech wʉt Jesúsliajwa: “Japon Juan, jiw bautisan, mat-echpon pejme dukaliajwa” —aech wʉt jiw Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Herodes wʉltaenbej, asew jiw jʉm-aech wʉt Jesúsliajwa: “Japon profeta Elías, majt laejapon. Amwʉtjel japon mat-ech pejme dukaliajwa” —aech wʉt jiw Jesúsliajwa. Wʉltaenbejpon, asew jiw jʉm-aech wʉt Jesúsliajwa: “Profetas, majt laelpi, japixot kaen mat-echpon pejme duk” —aech wʉt jiw Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ja-aech wʉt, Herodes Juanliajwa jʉm-aech: —Xan tajut tajsoldaw majt keto'ax Juan taxtasiapchaliajwas tʉpaliajwapon. Samata, ¿achankat japon aton, jʉmtaeflaxpon, jiw jʉm-aechfʉl wʉt japon xabich ispoxanliajwa? —aech Herodes. Samata, Herodes xabich taesiapon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús pejnachala, japi apóstolespi, naewʉajnafʉlpox bʉxtoet wʉt, nawenlisi Jesúslel. Japi natameja, pat wʉt Jesúsxot. Japi chapaei Jesús puexa ispoxanliajwa. Do jawʉt, Jesús bʉ'fol pejnachala Betsaida paklowax poxade, japikal tamachaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jesús bʉ'fol wʉt pejnachala, xabich jiw fʉltaenson. Samata, japi jiw wʉchakal fol. Pat wʉti Jesúsxot, Jesús japi jiw chiekal bʉ'kʉla. Naewʉajanbejpon Dios puexa pejjiw tato'laxaelpox. Boejthʉtbejpon jiw bʉ'xaeya. ");
INSERT INTO guoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tuila wʉt, Jesús mox soepas pejnachala, japi docepi. Jawʉt jʉm-aechi Jesúsliajwa: —Amxot tʉajnʉchan ajil. Amxotbej ajil naxaeyaxan. Samata, ¡ampi jiw jʉm-amde mox tʉajnʉchan poxade naxaeyaxan wʉajsliajwa, moejsliajwabejpi! —aech apóstoles Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús jʉmnot wʉt, jʉm-aechon: —¡Xamal najut chaxduim naxaeyaxan ampi jiw! —aechon. Japi jʉmnot wʉt, jʉm-aechi: —Xanalxot asbʉan jʉmch cinco pan, kolenje baxinbej. ¿Xamkat xanal nato'asiam naxaeyaxan wʉajsliajwan puexa ampi jiw xaelliajwa? —aech Jesús pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jesúsxot patpi, me-ama cinco mil poejiw. (Watho', yamxi sʉapich, xajui-esal.) Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¡Kaenanʉla pejmʉtan sʉapich, nej chalake cincuenta jiw! —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesús pejnachala jasox is. Jiw chalakax to'a wʉti, puexa jiw chiekal chalak. ");
INSERT INTO guoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Do jawʉt, Jesús chafit cinco pan, kolenje baxinbej. Athʉ natachaemse wʉt, Jesús Dios kawʉajan wʉt, gracias-aechon japapanesliajwa, kolenje baxinliajwabej. Jawʉt jalkafʉlon panes, baxibej. Jalkafʉl wʉt, chaxduifʉlon pejnachala sasliajwa, puexa jiw xaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Do jawʉt, puexa jiw chiekal xael. Chiekal nafniapi. Xaeyax chiekal kaechatoel wʉt, Jesús pejnachala matpirantat jia namapi. Jawʉt wʉlʉpi doce matpiran namapi, baxitoerow, pan malsibej. ");
INSERT INTO guoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Asamatkoi, Jesús Dios kawʉajan wʉt, jaxotbej pejnachala. Jawʉt wʉajnachaemt wʉt, jʉm-aechon pejnachalaliajwa: —¿Achan na-aechkat jiw xanliajwa? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Japi jʉmnot wʉt, jʉm-aechi: —Asew jiw jʉm-aech xamliajwa: ‘Juan, jiw bautisan, mat-echpon pejme duk’ —aech jiw. Asew jiw jʉm-aechbej xamliajwa: ‘Japon Elías, Dios pejprofeta, mat-echpon pejme duk’ —aech asew jiw. Asew jiw jʉm-aechbej xamliajwa: ‘Dios pejprofetas tʉpi, japixot kaen mat-echpon pejme duk’ —aech asew jiw —aech Jesús pejnachala Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Do jawʉt, Jesús pejme wʉajnachaemt wʉt, jʉm-aechon pejnachalaliajwa: —¿Xamallax, achan na-amkat? —aech Jesús. Do jawʉt, Pedro jʉmnot wʉt, jʉm-aechon: —Xam Cristowam, Dios to'asponam jiw bʉ'weliajwam —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús nejthʉ'axtat bʉxfiat wʉt pejnachala, jʉm-aechon: —¡Nabej chapae' asew jiw xan Cristowanponan! ");
INSERT INTO guoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Xan puexa jiw pakoewkolnan xabich nabijasaxaelen. Japamatkoi judíos-ancianos, sacerdotespaklochowbej, judíos chanaekabʉanapibej, najʉmchiyaxael xanliajwa: ‘Japon Cristowa-el, Dios to'aspona-el’ —nachiyaxaeli. Samata, japi naboesaxael. Xan naboesa wʉti, tres matkoi wʉt, Dios namat-esaxael pejme dukaliajwan —aech Jesús, jʉm-aech wʉt pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Do jawʉt, Jesús puexa jiwliajwa jʉm-aech: —Xamal tajnachalwasiam wʉt, ¡najut isaxaelampoxan nejkiowde! ¡Isfʉldelax kaematkoisfʉl xan tato'laxpoxan! Bej nabijasaxaelambej asew jiw pijaxtat. Xamal bej beyaxaelbejpi, tajnachalwam xot. Japoxan ja-aech wʉt, ¡xamal nakiowa naxanaboejafʉlde! ");
INSERT INTO guoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Xamal isfʉlam wʉt ampathatat najut nejxasinkampoxan, asamatkoi tʉpam wʉt, duilaximil Diosxotse. Kofam wʉtlax najut isfʉlampoxan ampathatat, isfʉlam wʉtlax xan tato'laxpoxan, asamatkoi tʉpam wʉt, ja-am wʉt, pomatkoicha Diosxotse duilaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Xamal isfʉlam wʉt najut nejxasinkpoxan, xamal napelsaxaelam Diosxot. Xamal xabich wʉtbej nejew ampathatat, japoxan omjil xamal duilaliajwam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Xamal nadala wʉt xanliajwa, tajnaewʉajnaxanliajwabej, xanbej, puexa jiw pakoewkolnan, tadalaxael xamalliajwa. Xanbej jachiyaxaelen xamalliajwa, pejme fʉloekx wʉt, kaxaxoekan wʉt ampathatlelsik taj-ax Dios pej-itliakaxtat, taj-ax Dios pej-ángeles pej-itliakaxtatbej. ");
INSERT INTO guoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Diachwʉajnakolax jʉm-an. Asew xamalxot, pejpatʉpax wʉajna, japi jiw taeyaxael Dios puexa pejjiw tato'laxaelpox —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Do jawʉx, ocho matkoiyan xent wʉt Jesús jʉm-aechpox, jawʉt Jesús bʉ'julach Pedro, Santiago, Juan, pinamʉax poxase, Jesús Dios kawʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús kawʉajan wʉt Dios, pejxu xabich itliak Dios pijaxtat. Naxoelox xabich papoeikolax nadofapox. Xabich itliakbejpox. ");
INSERT INTO guoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Do jawʉt, chalechkal natulaela kolenje aton. Japi, Jesús sʉapich, nospaei. Chalechkal kolenje natulaelapi, kaen Moisés, asan Elías. ");
INSERT INTO guoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Natulaelapi masajiach Dios pej-itliakax. Japi nospaei wʉt, Jesús sʉapich, naksiyapi Jesús nabijasaxaelpox Jerusalén paklowaxxot, japon tʉpaxaelpoxliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, asew Jesús pejnachala sʉapich, xabich itmoejslapi. Pe moejs-eli. Do jawʉt, taenlisi, Jesús xabich itliak wʉt Dios pijaxtat. Taenbejpi kolenje aton, nuil wʉt Jesúsxot. ");
INSERT INTO guoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kolenje natulaelapi chijiyaliajwa wʉt, Pedro jʉm-aech Jesúsliajwa: —Tajpaklon, pachaem, xanal amxotan wʉt. Xam nejxasinkam wʉt, xanal isaxaelen tres bʉa-at xamalliajwa. Kaeyax xamliajwa. Asabʉa-at Moisésliajwa. Asabʉa-at Elíasliajwabej —aech Pedro. Pedro japox jʉm-aech matabijs-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro naksiya wʉtfʉk, itloejen fʉloek japi matwʉajasik. Do ja-aech wʉt, Jesús pejnachala xabich pejlewla. ");
INSERT INTO guoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Do jawʉt, itloejentutat Dios jʉm-aechsik: “Amponlap taxʉlan, makafitxpon. ¡Japon chiekal naewesfʉlde!” —aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dios bʉxtoet wʉt naksiyapox, Jesús pejnachala taenpi jaxotse Jesús tamachpox. Jesús pejnachala chinax kaen aton japamatkoiyantat chapae-eli taenpox mʉaxxotse. ");
INSERT INTO guoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Do jawʉx, kandiawa wʉt, Jesús pejnachala sʉapich, baloek mʉaxxotsik, Dios naksiyaxot. Jawʉt xabich jiw fʉlaen bu'kakʉlnaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Japi jiwxot, kaen aton jʉm-aech pinjametat Jesúsliajwa: —Tajpaklon, ¡nabeltaem! ¡Taem taxʉlan! Japon xabich kaekolan. ");
INSERT INTO guoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Taxʉlan dep pijaxtat nejlaton. Chalechkal xabich wawʉa'tason. Wawʉa'tas wʉt, satat jixadapson. Do jawʉt, kaechwathʉamapon. Xabich nabijaton dep pijaxtat. Dep nasiownik taxʉlan pejmatpʉatxot. ");
INSERT INTO guoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xan jʉm-an nejnachala, namapi amxot, japi to'aliajwa dep nakolsax. Pe japi xajʉpa-el dep nakolsax to'aliajwapi dep —aech japon aton. ");
INSERT INTO guoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Xamal tajnachala, Dios chiekal xanaboeja-emilfʉk. Nejnejchaxoelaxan chiekla-elbej. Xabich pin-iamatkoiyan xamalxotx. Xabich pin-iamatkoiyan naewʉajnafʉlaxbej. Kajachawaetxbej Dios chiekal xanaboejaliajwam. Pe xamalfʉk Dios chiekal xanaboeja-emil —aech Jesús pejnachalaliajwa. Do jawʉt, Jesús jʉm-aech yamxʉlan paxliajwa: —¡Bʉflaemen naxʉlan xanlel! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Paxʉlan bʉ'pat wʉton Jesúsxot, japon yamxʉlan pejme xadapson dep satat. Xabich wawʉa'tasbejpon. Jawʉt Jesús dep nakolsax to'a. Dep nakolt wʉt, yamxʉlan chiekal pachaemlison. Jawʉt Jesús bʉflaech yamxʉlan pax poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Do jawʉt, puexa jiw nejchaxoelanuili, taen wʉti Jesús ispox Dios pijaxtat. Puexa jiw nejchaxoelanuil wʉtfʉk Jesús ispoxliajwa Dios pijaxtat, Jesús jʉm-aech pejnachalaliajwa: ");
INSERT INTO guoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—¡Chiekal najʉmtaem jʉmchiyaxaelenpox! ¡Nabej nejkiowe'! Xan, puexa jiw pakoewkolnan, asan nawiasaxael tadaelmajiwxot —aech Jesús, jʉm-aech wʉt japoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesús pejnachala matabija-el Jesús jʉm-aechpox, Dios tapae-esal xoti matabijaliajwa. Jesús pejnachala bʉxdala kaes wʉajnachaemsliajwapi Jesús, chanaekabʉanaliajwasbejpi. ");
INSERT INTO guoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Asamatkoi Jesús pejnachala najʉm-aechi: “¿Achankat xatisxot kaes pejme paklonaxael?” —na-aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús matabijt pejnachala nakaewa najʉm-aechpox. Samata, Jesús yamxʉlan la fʉlaeliajwadin. Do jawʉt, yamxʉlan notlison pejfʉletlel, pejnachala pejwʉajnalelbej. ");
INSERT INTO guoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Xamal bʉ'kʉlam wʉt yamxi xan tajaxtat, me-ama ampon yamxʉlan, ja-am wʉt, xanbej nabʉ'kʉltam. Xan nabʉ'kʉltam wʉt, Diosbej bʉ'kʉltam, xan nato'apon. Xamalxot kaen jʉm-aech wʉt: ‘Xan pejme kaes omjinil. Me-ama asew jiw, jachi-enil’ —aech wʉton, japon aton Diosxotse kaes pejme paklonaxael —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jesús pejnachalan, pawʉlpon Juan, japon jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, xanal aton taenx, xam nijaxtat to'a wʉt dep nakolaliajwa jiw pejmatpʉatanxot. Samata, xanal japon aton fiatx japox kofsliajwa. Japon wajmʉtpijna-el —aech Juan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús jʉmnot wʉt, jʉm-aechon: —Japon japox is wʉt, ¡nej ispon japox! ¡Nabej fias! Jiw babijaxan is-elpi xatisliajwa, japi, me-ama xatis kajachawaet wajnaewʉajnax —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús pejmatkoi mox pawʉajna wʉt athʉ poxaliajwase, fʉlaechon Jerusalén paklowax poxade, pejnachala sʉapich. Jesús pejlewla-el Jerusalén paklowax pasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samata, kolenje pejnachalan to'apon wʉajnade, asatʉajnʉ poxade, Samaria tʉajnʉlel, jaxotde bapijin kawʉajnaliajwapi Jesús jaxot namanaliajwa kaematkoiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaria tʉajnʉpijiw chiekal matabija Jesús fʉlaeyaxaechpox Jerusalén paklowax poxade. Samata, Samaria tʉajnʉpijiw nejxasinka-el Jesús pasliajwa japi pejtʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kolenje Jesús pejnachalan, japon Santiago, Juan sʉapich, japox jʉmtaen wʉt, jʉm-aechi Jesúsliajwa: —Tajpaklon, ¿xamkat nejxasinkam, xanal Dios kawʉajnax wʉt wʉljoeliajwan, Dios to'aliajwa jit athʉlelsik, japatʉajnʉpijiw toejwaliajwas? —aech Santiago, Juan sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús japox jʉmtaen wʉt, japi jʉm-aechpox, kaxa kawʉlel natfo'chapon. Jawʉt pejnachala bʉxfiaton kaes japox jʉmchisamatapi. ");
INSERT INTO guoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Do jawʉx Jesús fʉlaech, pejnachala sʉapich, asatʉajnʉ poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesús, pejnachala sʉapich, asew jiw sʉapichbej, nʉamtat fol wʉt, kaen aton jʉm-aech japixot: —Jiw chanaekabʉanan, xan nakfʉlaesian xam, nanʉamtam wʉt nejmachtʉajnʉchan poxade —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Do jawʉt, Jesús jʉm-aech: —Lam pejmʉthan moejsliajwa. Miabej pejfenan. Xanlax, puexa jiw pakoewkolnan, tajbakolax ajil damlathʉlaliajwan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús jʉm-aechbej asan atonliajwa: —¡Xan nakfʉlaem! —aechon. Japon aton jʉmnot wʉt, jʉm-aechon: —Tajpaklon, taj-ax xabich pati'in. Taj-ax tʉp wʉt, do jawʉt, xam nakfʉlaeyaxaelen naknanʉamsliajwan —aech japon aton Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús jʉm-aech: —Xan nanaexasis-elpi, japi jiw Diosliajwa, me-ama patʉpa wʉt, ja-aechi. Japi mʉthaxael patʉpa. Nej-ax tʉp wʉt, japi mʉthsaxael. ¡Xamlax xan nakfʉlaem jiw naewʉajnaliajwam Dios puexa pejjiw tato'laxaelpox! —aech Jesús japon atonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Asan aton jʉm-aechbej Jesúsliajwa: —Tajpaklon, xan-is xam nakfʉlaesian. ¡Pe majt natapaem tajjiw kawʉajnaliajwan! Do jawʉx, xam nakfʉlaeyaxaelen —aechon Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús jʉmnot wʉt, jʉm-aechon japon atonliajwa: —Aton nabist wʉt Diosliajwa, kaeyax nejchaxoelafʉla-el wʉton, japon aton kaenejchaxoelaxa-el, Dios sʉapich. Samata, japon aton pachaema-el naewʉajnaliajwapon Dios puexa pejjiw tato'laxaelpox —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Do jawʉx, Jesús kaes jiw makanot pejnachalaliajwa, setenta y dos poejiw. Jawʉt Jesús japi poejiwxot, kaenanʉla kolenje wʉajna to'apon. To'apon japi wʉajna jiw naewʉajnaliajwa, puexa paklowaxanpijiw, puexa tʉajnʉchanpijiwbej, Jesús pasaxaelxot. ");
INSERT INTO guoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Japi fʉlaeliajwa wʉt, jʉm-aechon: “Diachwʉajnakolax jʉm-an. Xabich jiw wʉajnawet chimiawʉajan jʉmtaeliajwa. Me-ama trigo foel wʉt, xabich pachaemlisi jolaliajwa, ja-aechbej amwʉtjel xabich jiw. Xamal kaesʉapicham, Dios pejjamechan naewʉajnampim. Samata, ¡wajpaklokolan Dios kawʉajande japon to'aliajwa asew jiw, japibej Dios pejjamechan naewʉajnafʉlaliajwa asew jiw! ");
INSERT INTO guoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Xabʉa'de xamal! Xamal folam wʉt xan tajaxtat, ¡chiekal taem, babejchow poxade to'ax xot! Me-ama pejmachoef ovejaliajwa chachoel, jachiyaxaelbej xamalliajwa, babejchowxotam wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Folam wʉt, ¡nabej xalae' choxan, plata, asew tʉakxajoebej! Jiw xabʉ'kʉlam wʉt nʉamtat, ¡piach nabej nuile' nospaeliajwam, japi sʉapich! Ma ifʉlaemchdo', ¡do japapaklowax poxade fʉlaemch! ");
INSERT INTO guoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ba leliajwam wʉt, ¡majt jʉm-amde japabapijiwliajwa: ‘¡Dios xamal nej kajachawaes chiekal duilaliajwam!’ —amde japabapijiw! ");
INSERT INTO guoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Japi jiw chiekal duilasia wʉt, me-ama xamal jʉmchiyaxaelam, japi Dios kajachawaesaxaes chiekal duilaliajwa. Pelax japi jiw nejwesla wʉt chiekal duilaliajwa, japi chiekal duilaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tadʉt wʉti xamal duilaliajwam japi pejbaxot, ¡xamalfʉk duilde japabaxot! ¡Nabej laliaxle' asabachan poxade! Naxaeyaxan chaxduw wʉt, ¡xamal nejmach xaem! ¡Fembej! ¡Nabej nadale', naxaeyaxan chaxduw wʉti! Aton nabist wʉt asanliajwa, japon moch. (Xamalbej Dios pejjamechan naewʉajnafʉlam xot, jiw chaxduiyaxael naxaeyaxan xaeliajwam xamal, nabistam xot Diosliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Paklowax patam wʉt, xamal chiekal jiw bʉ'kʉla wʉt, japi jiw xamal naxaeyaxan chaxduw wʉtbej, ¡xamal xaem! ");
INSERT INTO guoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Japaklowaxxot bʉ'xaenki, ¡boejthʉ'e! ¡Jʉm-amdebejpi: ‘Dios puexa pejjiw tato'laxaelmatkoi mox pawʉajna’ —amde japi jiwliajwa! ");
INSERT INTO guoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Asapaklowax patam wʉt, japapaklowaxpijiw xamal bʉ'kʉla-el wʉt, ¡nuilde japapaklowaxthialaxxot! Do jawʉt, ¡japapaklowaxpijiw jʉm-amde: ");
INSERT INTO guoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Xanal tajtʉakxajoe jolx lʉlaliajwan as natacholnaliajwa. Jasox isx xamal najut chiekal matabijaliajwam babijax isampox Diosliajwa, xanal nabʉ'kʉla-emil xot naewʉajnaliajwan Dios pejjamechan. ¡Chiekal nanaewe'e jʉmchiyaxaelenpox! Dios puexa pejjiw tato'laxaelmatkoi mox pawʉajna’ —amde japapaklowaxpijiwliajwa! ");
INSERT INTO guoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Diachwʉajnakolax xamal jʉm-an. Asamatkoi, kastikamatkoi wʉt, japapaklowaxpijiw xabich kaes pejme Dios kastikaxaespi. Me-ama Sodoma paklowaxpijiw kastikas wʉt, jachiyaxilon” —aech Jesús pejnachalaliajwa, setenta y dospiliajwa, wʉajna to'aliajwa wʉton japi. ");
INSERT INTO guoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús jʉm-aech Corazín paklowaxpijiwliajwa, Betsaida paklowaxpijiwliajwabej: “Corazín paklowaxpijwam, Betsaida paklowaxpijwambej, xamal xabich nabijasaxaelam, Dios xabich kastikaxael wʉt. Xan koechaxan isx wʉt xamalxot, xamal taenam, pe xamal naexasis-emil naewʉajnax wʉt Dios pejjamechan. Japakoechaxan chajia isaxaelen wʉt Tiro paklowaxpijiwliajwa, Sidón paklowaxpijiwliajwabej, japoxan taeyaxael wʉti, japi jiw naexasisaxael Dios pejjamechan. Ja-aech wʉt, kofaxaeli padujnejchaxoelaxan isfʉlaliajwa Dios nejxasinkpoxan. Ja-aech wʉtbej, naxoeyaxaeli papopa. Chalakaxaelbejpi jitthumbaxot asew jiw matabijaliajwas xabich nejxaejwaspox babijaxan ispoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Samata, Corazín paklowaxpijwam, Betsaida paklowaxpijwambej, Dios xabich kastikaxael xamal. Me-ama Tiro paklowaxpijiw, Sidón paklowaxpijiwbej, jachiyaxil, japapaklowaxanpijiw kastikas wʉti Dios” —aech Jesús Corazín paklowaxpijiwliajwa, Betsaida paklowaxpijiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jesús jʉm-aechbej Capernaum paklowaxpijiwliajwa: “Capernaum paklowaxpijwam, xamal nejchaxoelam wʉt, jʉm-am: ‘Dios nakbʉflaeyaxael xatis athʉ poxase’ —am xamal, nejchaxoelam wʉt. Pelax Dios xamal to'axael infierno poxadik, xan nanaexasis-emil xot” —aech Jesús Capernaum paklowaxpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús jʉm-aech pejnachalaliajwa: “Xamal jiw naewʉajnafʉlam wʉt, japi jiw xamal chiekal naewet wʉt, jawʉt xan nejchaxoelaxaelen japi jiwliajwa: ‘Japi jiw xanbej chiekal nanaewet’ —chiyaxaelen, nejchaxoelx wʉt japiliajwa. Asew jiw xamal naexasis-el wʉt, jawʉtbej xan nejchaxoelaxaelen japi jiwliajwa: ‘Japi jiw xanbej nanaexasis-el’ —chiyaxaelen, nejchaxoelx wʉt japiliajwa. Japi jiw xan nanaexasis-el wʉt, jawʉtbej taj-ax Dios nejchaxoelaxael japiliajwa: ‘Japi jiw xanbej nanaexasis-el’ —chiyaxael taj-ax Dios, nejchaxoel wʉt japi jiwliajwa” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesús pejnachala, setenta y dospi, naewʉajanpoxan bʉxtoet wʉti puexa paklowaxanpijiw, puexa tʉajnʉchanpijiwbej, do ja-aech wʉt, kaxa nawenlisi Jesúslel. Xabich nejchachaemali. Pat wʉti Jesúsxot, puexa chiekal chapaeipi Jesús jʉmtaeliajwas: —¡Tajpaklon, xam nijaxtat xanal dep to'ax wʉt, kamta dep nakola jiw pejmatpʉatanxot! —aechi, Jesús chapaei wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Do jawʉt, Jesús jʉm-aech pejnachala, setenta y dospiliajwa: —Diachwʉajnakolax xan taenx, Satanás jopik wʉt athʉxotsik Dios pijaxtat. Me-ama chamax nakliafcha wʉt, ja-aechon, jopik wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xan chaxdutx tajpamamax malechaliajwam Satanás. Samata, xamal nanʉamtam wʉt jom, afʉbej. Xamal malecham wʉt Satanás, japon xajʉpaxil xamal tabejsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","¡Pe nabej nejchachaemle' dep kamta jiw pejmatpʉatanxot nakolapoxliajwa, to'am wʉt! ¡Nejchachaemildelax nejwʉlan Diosxotse lelspoxliajwa! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Do jawʉt, Jesús xabich nejchachaemil Espíritu Santo pijaxtat. Samata, Jesús jʉm-aech pax Diosliajwa: “Ax, xamlap kaenam paklonam athʉxotse, ampathatlelbej. Xam xabich pachaemam. Xam kajachawaetam estudia-elpi, japi chiekal matabijaliajwa nejjamechan. Jasoxtat xam kajachawaetam jiw, nejxasinkam xot. Asew jiwlax, xabich matabijapi, japi jiw japoxan matabijaxil. Diachwʉajnakolax jasox ja-am, xam nejxasinkam xot” —aech Jesús pax Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Xan taj-ax natapaei puexa matabijsliajwan. Pe jiw diachwʉajnakolax xan namatabija-el, achanan xan. Taj-ax, Dios, japon kaen chiekal xan namatabijt. Jiwbej matabija-el, achan taj-ax. Xan kaenan taj-ax chiekal matabijtax. Xan makanotxpikal, japikallax matabijaxael taj-ax. Japikal tapaeix matabijaliajwapi taj-ax Dios” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Do jawʉt, Jesús natfo'cha wʉt, jʉm-aechon pejnachalakal: “Asew jiw, taenpi xamal amwʉtjel taenampoxan, japi jiwbej xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Diachwʉajnakolax xan jʉm-an. Xabich profetas, reyesbej, taesiapi xamal amwʉtjel taenampon, japon Mesías. Xanlap japonan. Profetas, reyesbej, xan natae-el, tʉp xotlisi ampathatat xan pasax wʉajna. Xabich jʉmtaesiabejpi tajjamechan, amwʉtjel xamal jʉmtaenampoxan. Pe jʉmtae-eli, tʉp xotlisi” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Judíos chanaekabʉanan fʉlaen nospaeliajwa, Jesús sʉapich, xapaejsliajwabejpon Jesús. Xapaejsliajwa wʉt, jʉm-aechon: —Jiw chanaekabʉanan, ¿xan machiyaxaelenkat Dios nabʉ'weliajwa, Diosxotse pomatkoicha dukaliajwan? —aech, Jesús xapaejsliajwa wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús jʉmnot wʉt, jʉm-aechon: —¿Achaxkat jʉm-aech Moisés chajia lelpox japoxliajwa? ¿Xaljowampox achax-aechbejkat? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Judíos chanaekabʉanan jʉmnot wʉt, jʉm-aechon: —Moisés chajia lelpox jʉm-aech: ‘¡Nejxasinkde Dios, nejpaklokolan, puexa nejmatpʉatat, puexa nejnejchaxoelaxtatbej! ¡Puexa nejpamamaxtatbej tanbichfʉlde, Dios nejxasinkam xot! ¡Nejxasinkdebej asew jiw! Me-ama xam najut nejxasinkam wʉt, ¡ja-amde asew jiwliajwa!’ —aech Moisés chajia lelpox —aech judíos chanaekabʉanan. ");
INSERT INTO guoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Do pejme Jesús jʉm-aech judíos chanaekabʉananliajwa: —Pomatkoicha japoxan ja-am wʉt, pomatkoicha xam dukaxaelam Diosxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pe judíos chanaekabʉanan nejxasink Jesús nejchaxoelaliajwa japonliajwa japon pachaempoxliajwa. Samata, jʉm-aechon: —¿Masikat xan jiw nejxasinkaxaelen? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús jʉmnot wʉt, ampawʉajantat jʉm-aechon: —Kaen aton Jerusalén paklowaxxot nakolt fʉlaeliajwa Jericó paklowax poxade. Nʉamtat fol wʉt, kethaka jaeltason. Puexa pejew wenochpon. Bʉ'jolsbejpon. Do jawʉt, baeson. Jaxot bʉ'jʉmchawaelsnadoftipon paboejlan. ");
INSERT INTO guoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Do jawʉx, kaen sacerdote-aton fʉlaen japanʉamtadin. Taen wʉton wʉajna aton paboejlan okpox, asbʉan jʉmch mox naejiaton xensliajwa. Do jawʉt, xenton. ");
INSERT INTO guoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Do jawʉx, sacerdotes kajachawaesan jaxot pat. Taen wʉton wʉajna aton nʉamtat okpox, japonbej mox jiat xensliajwa. Do jawʉt, japon xent. ");
INSERT INTO guoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Do jawʉx, Samaria tʉajnʉpijin fʉlaen japanʉamtadin. Fʉlaen wʉt, taenpon aton wʉajna nʉamtat okpox. Japonlax beltaen japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Do jawʉt, mox soepandepon okpon poxade. Do jawʉtbej, itfachan wʉapon olivosimintat, vinotatbej. Itfachan xape'abejpon. Do jawʉt, pejburtat ossepon. Jasoxtat bʉ'folon baespon kethaka. Do jawʉx, bʉ'paton nanʉamtpi papatbatat. Jaxot chiekal tataefʉlpon japon aton. ");
INSERT INTO guoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Do kandiawa wʉt, Samaria tʉajnʉpijin jut kolefachan mosliajwapon bapijin. Jawʉt jʉm-aechon bapijinliajwa: ‘¡Ampon aton chiekal nawetataefʉlde xan tajwʉlela! Japon asaxan wewe'pas wʉt, ¡xam wʉajde japon atonliajwa! Jelow xan pejme kaxanax wʉt, xam mosaxaelen wʉajtampoxan japonliajwa’ —aech Samaria tʉajnʉpijin bapijinliajwa. Ma amxot toep, ampawʉajan, xam naewʉajnaxwʉajan. ");
INSERT INTO guoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tres poejiw taen kethaka baespon. ¿Masonkat tres poejiwxot nejxasink baespon? —aech Jesús judíos chanaekabʉananliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Judíos chanaekabʉanan jʉmnot wʉt, jʉm-aechon: —Beltaenpon kethaka baespon —aechon Jesúsliajwa. Jesús jʉmnot wʉt, jʉm-aechon: —¡Xamlap-is ja-amde! ¡Nejmachjiw beltaem!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús nʉamtat fol wʉt, pejnachala sʉapich, jawʉt paton cha-aelpaklowaxachxot. Japapaklowaxachxot Marta pejba ek. Jawʉt chiekal bʉ'kʉltow Jesús, japon pejnachalabej. ");
INSERT INTO guoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta pakoewow pawʉl María. María mox ek Jesús pejwʉajnalel chiekal naewesliajwa Jesús naewʉajanpox. ");
INSERT INTO guoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pelax Marta xabich xatsalt. Samata, Jesúsxot mox wʉt, jʉm-aechow: —Tajpaklon, ¿xamkat xanliajwa nejchaxoela-emil takoewow tamach nakixanchachaempox? ¡Takoewow to'im xan nakajachawaesliajwa! —aech Marta. ");
INSERT INTO guoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús jʉmnot wʉt, jʉm-aechon: —Marta, xam xabich nejchaxoelam isampoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xan naewʉajnaxpox kaes pejme pachaem xamal naewesliajwam. María xan naewesfʉl xot, kaes pachaempox naewesfʉlpow. Chinax kaen aton wefisaxisal japox —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesús kaematkoisfʉl Dios kawʉajan. Asamatkoi, Dios kawʉajnax bʉxtoet wʉt, kaen pejnachalan jʉm-aech Jesúsliajwa: —Tajpaklon, ¡xanal nachanaekabʉanim Dios kawʉajnax! Me-ama Juan, jiw bautisan, chanaekabʉana pejnachala Dios kawʉajnaliajwa, ¡xambej xanal nachanaekabʉanim Dios kawʉajnax! —aech Jesús pejnachalan. ");
INSERT INTO guoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Xamal Dios kawʉajnam wʉt, ¡jʉm-amde: ‘Ax Dios, ¡puexa jiw xam nej sitae'! Puexa nejjiw tato'laxaelammatkoi, ¡japamatkoi nej tʉadus! ");
INSERT INTO guoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","¡Kaematkoisfʉl nachaxduim naxaeyaxan, xanal nawewe'ppoxanliajwa! ");
INSERT INTO guoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","¡Xanal nabeltaem babijaxan isxpoxanliajwa! Me-ama xanal beltaenx, asew jiw babijaxan is wʉt xanalliajwa, ¡ja-amdebej xanalliajwa! ¡Nabej tapae'bej Satanás xanal naxapaejaliajwa, xanal babijaxan isasamatan!’ —amde, Dios kawʉajnam wʉt! —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","Jesús pejme jʉm-aech: —Xam nejnachalan pinmadoitat pat wʉt nejbaxot, jʉm-aech wʉton: ‘¡Xan nachaxdu'e tres panes! Amwʉtjel tajnachalan pat tajbaxot. Tajbaxot ajil naxaeyax tajnachalan chaxdusliajwan’ —aech wʉton xamliajwa, jawʉt jʉmchiyaxaelam batuxotdin: ‘¡Nabej natalias! Xanlis okx. Ba chiekal xatbe'tax. Tejew yamxi bʉ'okx. Samata, nansaxinil chaxdusliajwan nawʉljowampox’ —chiyaxaelam batuxotdin. ");
INSERT INTO guoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pe nejnachalan nakiowa wʉljoefʉl wʉt, wʉljoefʉlpox xam chaxdusaxaelam nejnachalan. ");
INSERT INTO guoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Samata, xamal jʉm-an ampox: ‘¡Wewe'ppoxan piach wʉljoefʉlde Dios! Ja-amsfʉlam wʉt, Dios chaxdusaxaelbej xamal wʉljoeflampox. Wʉlwekampoxbej faenaxaelam Dios pejkajachawaesaxtat. Dios kawʉajnam wʉt kaematkoisfʉl, japon xamal kajachawaesfʉlaxael. Ja-aech wʉt, me-ama Dios fafasaxael xamal leliajwam’ —an xan. ");
INSERT INTO guoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Piach wʉljoefʉlpon wewe'paspoxan, japon aton Dios chaxdusaxaes. Piach wʉlwekafʉlponbej, japon aton faenaxael Dios pejkajachawaesaxtat. Bafafatat piach laefʉlpon, japon aton Dios wefafasaxaes —aech Jesús, pejnachala naewʉajan wʉt Dios kawʉajnaliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Jesús pejme jʉm-aech pejnachalaliajwa: —Naxʉlan baxin wʉljow wʉt, xamal naxi chaxduiyaximil jom. ");
INSERT INTO guoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naxʉlan kawaematabʉt wʉljow wʉt, xamal naxi chaxduiyaximil afʉ. ");
INSERT INTO guoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Xamal babejchowam matabijam naxi chaxduiliajwam chamoeyaxan. Nej-ax Dios, athʉpijin, kaes pejme pachaem. Me-ama xamal jachi-elon. Samata, nej-ax Dios to'axoek Espíritu Santo xamal nejmatpʉatanxotaliajwa, Dios kawʉajnam wʉt —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aton naksiyaxilpon dep pijaxtat. Dolisdo', Jesús to'a dep nakolsliajwa japon aton pejmatpʉatxot. Dep nakolt wʉt, do jawʉt japon aton naksiyax tʉadutlison. Jiw japox taen wʉt, xabich nejchaxoelanuili. ");
INSERT INTO guoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Asew japixot, fariseos, jʉm-aechi Jesúsliajwa: “Jesús to'a wʉt dep nakolsliajwa aton pejmatpʉatxot, Jesús to'a Satanás, dep pejpaklon pejpamamaxtat” —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Asew jiw jʉm-aechbej xapaejsliajwapi Jesús: —¡Isde koechax xanal taeliajwan! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús matabijt japi nejchaxoelox. Samata, jʉm-aechon: —Xan to'a-enil dep nakolaliajwa Satanás pejpamamaxtat. Kaetʉajnʉpijiw nadiajkaxael wʉt nakaewa nabeliajwa, japi natoesaxael nabeyaxtat. Kaebapijiwbej nadiajkaxael wʉt nakaewa nabeliajwa, japi natoesaxael nabeyaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jachiyaxaelbej Satanás. Satanás, pejjiw nadiajkaxael wʉt nakaewa nabeliajwa, japi dep natoesaxael nabeyaxtat. Ja-aech wʉt, Satanás pejtato'lax toepaxael nabeyaxtat. Xamal japox jʉm-an, najʉm-am xot xanliajwa: ‘Jesús to'a dep nakolaliajwa jiw pejmatpʉatanxot Satanás pejpamamaxtat’ —na-am xot xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ja-aech wʉt, ¿achan pejpamamaxtatkat nejnachalabej dep to'a nakolaliajwa jiw pejmatpʉatanxot? Xamal matabijam japi to'a-el Satanás pejpamamaxtat. Samata, xamal jʉm-ampox xanliajwa, japox diachwʉajnakolaxa-el. ");
INSERT INTO guoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Xan to'ax Dios pejpamamaxtat dep nakolaliajwa jiw pejmatpʉatanxot. Ja-aech wʉt, diachwʉajnakolax xamalxot patlisox, Dios puexa pejjiw tato'laliajwapox —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Do pejme Jesús jʉm-aech: —Pamaman xawawet wʉton kapetat pejbatat, asan aton wenosaxisal japon aton pejew. ");
INSERT INTO guoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pe asan, kaes pamaman, fʉlaen wʉt, wʉajnapijin malechas wʉt, ja-aech wʉt, xawawetpox kefe'naxaeson. Ja-aech wʉtbej, japon pejew wenosaxaes wesasliajwas, asew jiw sʉapich —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Do pejme Jesús jʉm-aech: —Xan nanejweslapi, japi jiw tadaelmajiw. Japi is-el xan nejxasinkaxpox. Japilax nawetabejt tajbichax —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Do pejme Jesús jʉm-aech: —Dep nakolt wʉt aton pejmatpʉatxot, dep nanʉamt pajilaxxot. Wʉlwekon asan aton pejmatpʉat, jaxot low wʉt damlathʉlaliajwa. Faena-el wʉt, dep nejchaxoel wʉt, jʉm-aechon: ‘Xan pejme nawiasaxaelen aton pejmatpʉatxot, nakoltaxxot’ —aech dep, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dolisdo', dep kaxadin wʉt, faenlison japon aton, majt nakoltxoton. Do jawʉt, dep pajut najʉm-aech japon atonliajwa: ‘Asan dep le-elfʉk tajwʉlela. Samata, pachaem xan pejme leliajwan japon aton pejmatpʉatxot’ —aech dep, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Do jawʉt, japon dep fʉlaechlison asew dep wʉljaesliajwa. Faenon siete dep, japi dep kaes pejme chaemil. Me-ama dep matxoelapijin, jachi-el siete dep. Do jawʉt, puexa japi dep lowlisi japon aton pejmatpʉatxot. Ja-aech wʉt, japon aton kaes pejme xabich nabijat. Me-ama majt, jachi-elon —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús naksiya wʉtfʉk depliajwa, naewetixot kaeow pawis nejlakcha wʉt, jʉm-aechow Jesús jʉmtaeliajwa: —Pawis, xam faenpow, chaxti'apowbej xam ti'sliajwam, ¡japow nej nejchachaemle' xamliajwa! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pe jawʉt Jesús jʉm-aech: —Xabich kaes pejme nejchachaemlaxael xan nanaeweti, japibej naexasiti wʉti Dios pejjamechan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Xabich jiw masajiati Jesús naewʉajanpox jʉmtaeliajwa. Samata, Jesús jʉm-aech japi jiw jʉmtaeliajwa: “Xamal laelpampim, babejchowam. Nato'am xan koechax isliajwan asbʉan jʉmch xamal taeliajwam. Pe xamal pajelkoechax taeyaximil. Me-ama chajia Dios is profeta Jonásliajwa jiw pajut matabijaliajwa japon Dios to'aspon, jasoxtatbej xamal matabijaxaelam, xan Dios nato'aponanpox. ");
INSERT INTO guoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dios chajia koechax is wʉt Jonásliajwa, Nínive paklowaxpijiw matabija. Jasoxtatbej xamal matabijaxaelam, Dios is wʉt koechax xanliajwa, jiw matabijaliajwa diachwʉajnakolax xan Dios nato'aponan puexa jiw pakoewkolnanliajwa, jiw bʉ'weliajwan. ");
INSERT INTO guoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Asamatkoi Dios puexa jiw kastikaxael, babijaxan ispi. Xamalbej Dios pejwʉajnalel nuilaxaelam kastikaliajwa. Japamatkoi Saba tʉajnʉpijiwpaklokolow nukaxael Dios pejwʉajnalel japow xamal jʉmchiliajwa nejbʉ'wʉajanpoxanliajwa, xan nanaexasis-emil xot. Japow chajiakolaxtat xabich atʉaj fʉlaen rey Salomón pejmatabijsax pajut chiekal matabijsliajwapow. Xan kaes pejme pachaeman. Me-ama Salomón, jachi-enil. Xan naewʉajnax xamal matabijaliajwam Dios. Pe xamal naexasis-emil. ");
INSERT INTO guoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Japamatkoi Nínive paklowaxpijiw nuilaxaelbej Dios pejwʉajnalel xamal jʉmchiliajwa babijaxan isampoxanliajwa, o, is-emil wʉt. Chajiakolaxtat japi naewʉajnas wʉt Jonás, japi kamta kofa babijaxan ispoxan isfʉlaliajwa Dios nejxasinkpoxan. Xan kaes pejme pachaeman. Me-ama Jonás, jachi-enil. Pelax xamal xan chiekal nanaewes-emil” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús jʉm-aech: “Jiw tamdut wʉt lámpara, asaxtat matakasaxil. Cha-esaxilbej cajónbʉxfaltat. Jiwlax athʉ cha-esaxael lámpara bamʉaxnaetat, batu chiekal itliakaliajwa, batu lalenapi chiekal taeliajwa. Jasoxtat xanbej moech-enil diachwʉajnakolaxpox Diosliajwa. Puexa chiekal tulaela itpaeix. ");
INSERT INTO guoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lámpara itliak batu puexa jiw chiekal taeliajwa. Ja-aechbej nej-itfutan. Xamal chiekal taenam, nej-itfutan chiekal pachaem xot. Nej-itfʉtan chaemil wʉt, chiekal taeyaximil. Me-ama itliaklan, jachiyaxaelam. Jachiyaxaelbej nejnejchaxoelaxan. Dios italiafa wʉt nejchaxoelaxan, chiekal pachaemaxael. Ja-am wʉt, naexasisaxaelam Dios tato'alpox isfʉlaliajwam. Duilaxaelambej chiekal. Nejchaxoelaxan chiekal pachaema-el wʉt, naexasisaximil Dios. ");
INSERT INTO guoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","¡Chiekal taem babijaxan isaxan nejchaxoelasamatam! Xamal nejchaxoelam wʉt babijaxan isaxan, ja-am wʉt, nejnejchaxoelaxan, me-ama itkʉatnik wʉt, jachiyaxael. Ja-am wʉt, xamal naexasisaximil xan naewʉajnaxpoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dios italiafa wʉt nejnejchaxoelaxan, xamal isfʉlaxaelam Dios tato'alpoxan. Ja-am wʉt, nejnejchaxoelaxan chinax chaemilaxil. Me-ama lámpara itliak batutat, jachiyaxael nejnejchaxoelaxan” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús bʉxtoet wʉt, kaen fariseo tadʉton Jesús xaeliajwa japon pejbaxot. Do jawʉt, Jesús lech japon pejba poxade. Eklison mesaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesús xaeliajwa wʉt, majt xabich piach kekakias-elon. Fariseo japox taen wʉt, nejchachaemla-elon Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesús matabijt japon nejchaxoelox. Samata, Jesús jʉm-aech: —Xamal fariseos xaeliajwam wʉt, majt xabich piach fʉletlelan xabich kiatam taso, platfachanbej. Pelax patulelan kias-emil. Xamal fariseos, me-ama tasfachan, platfachanbej, xabich kiachpi, ja-am xamal. Xabich piach kekakiatam. Pelax nejnejchaxoelaxan, me-ama xabich as da'nik wʉt, ja-aech. Nejchaxoelambej nosliajwam asew jiw pejew. Isfʉlambej babijaxan. ");
INSERT INTO guoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Xamal nejliaklawam! ¿Matabija-emilkat Dios puexa ispox nejbʉ'anxot, isbejpon tathoetlel, fʉniachlelbej? ");
INSERT INTO guoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Samata, ¡isfʉlde pachaempoxan asew jiwliajwa! Ja-am wʉt, puexa jiw xamal matabijaxael nejnejchaxoelaxan, diachwʉajnakolax pachaempox —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Do pejme Jesús jʉm-aech fariseosliajwa: “¡Puexa xamal, fariseos, Dios kastikaxael! Xamal xafolam ofrenda Dios chaxduiliajwam. Mʉthampi ti't wʉt, diajnam diezmʉaxtjeliajwa. Kaemʉaxt diajnam Dios chaxduiliajwam. Ja-ambej, menta-ʉafliajwa. Asew mʉthampibej Dios chaxduwam kaesʉapich. Japoxan isfʉlam wʉt, pachaem. Pe kaeyax wewe'pfʉk xamal isliajwam. Is-emil pachaempoxan asew jiwliajwa. Dios chiekal nejxasinka-emilbej. Japox koloeyax xamalliajwa we'pfʉk” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Do pejme Jesús jʉm-aech: “Puexa xamal fariseos, Dios kastikaxael, xabich nejxasinkam xot jiw jʉmchiliajwa: ‘Fariseos diachwʉajnakolax paklochow’ —chiliajwa jiw xamalliajwa. Xamal judíos naewʉajnaba poxamich wʉt, tʉa-ekaxan itfetambej chalakaliajwam japoxantat, kaes paklochow chalakaliajwapoxan puexa jiw pejwʉajnalel. Xamal jiw moi-aech wʉt paklowaxthialaxanxot, nejxasinkam jiw moichiliajwa sitaeyaxtat. Samata, Dios kastikaxael xamal” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Do pejme Jesús jʉm-aech fariseosliajwa: “¡Puexa xamal fariseos Dios kastikaxael! Xamal, me-ama patʉpamʉthan, marka-esalpi, jaxot jiw nejmach sae'an, matabija-el xot, xamallap-is ja-am. Jiw xamal taen wʉt, me-ama pachaemam wʉt, jakabʉan-am. Pelax nejnejchaxoelaxan xabich chaemil” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Judíos chanaekabʉanapixot kaen jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, xam japox jʉm-am wʉt, jʉm-am xanalliajwa —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús jʉm-aech judíos chanaekabʉanapiliajwa: —¡Puexa xamal judíos chanaekabʉanapijwam, Dios kastikaxael xamal! Jiw naewʉajnam wʉt, xabich naewʉajnam japi jiw xabich kaes naexasisliajwa xamal naewʉajnampoxan. Pe japi jiw xajʉpa-el puexa japoxan naexasisliajwa. Chinax kajachawaes-emilbej japi jiw naexasisliajwa naewʉajnampoxan —aech Jesús judíos chanaekabʉanapiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Do pejme Jesús jʉm-aech judíos chanaekabʉanapiliajwa: “Judíos chanaekabʉanapijwam, ¡puexa xamal Dios kastikaxael! Nejwʉajnapijiw ampathatat laelp wʉt, japi ba Dios pejprofetas. Japi profetas pejmʉthanmatwʉajtat xamal ampamatkoiyan isam cha-aelbax itpaeliajwam nejsitaeyax japi profetasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pe japabax isam wʉt, itpaeyam xamal kaenejchaxoelaxampox, nejwʉajnapijiw sʉapich. Nejwʉajnapijiw ba Dios pejprofetas. Xamal amwʉtjel cha-aelbax isam japi profetas pejmʉthanxot. ");
INSERT INTO guoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Japoxliajwa Dios chajia jʉm-aech matabijsaxtat: ‘Xan to'axaelen profetas, apóstolesbej, judíosliajwa. Xan japi to'ax wʉt, asew japixot beyaxaes. Asew japixot dʉkp wʉt, nakiowa chakifʉlaeyaxaes’ —aech Dios, jʉm-aech wʉt japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Puexa profetas, baespi nejwʉajnapijiw pijaxtat, puexa japoxan pijaxtat, xamal, amwʉtjel laelpampimfʉk, Dios kastikaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel matxoela boesas pakoewan. Do baxael, xabich asew profetasbej beflas kaenanʉla nejwʉajnapijiw pijaxtat. Do baxael, Zacaríasbej boesas. Nejwʉajnapijiw boesa wʉti Zacarías, Dios pejtemplobafʉlmaktutat boesaspon, mox altar nukxot. Puexa profetas, baespi nejwʉajnapijiw pijaxtat, japoxliajwa ampamatkoiyantat xamal laelpampimfʉk, Dios kastikaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Puexa xamal, judíos chanaekabʉanapijwam, Dios kastikaxael! Xamal nejchaxoelam wʉt, nejchaxoelam: ‘Xatis chiekal matabijas Dios pejjamechan’ —am xamal, nejchaxoelam wʉt. Pe nakiowa, chiekal matabija-emil. Jiw naewʉajnam wʉt, naewʉajnam asawʉajantat, Dios pejjamechana-elpoxantat. Samata, me-ama jiw bafafa xawaet wʉt, asew jiw lesamata, ja-ambej xamal Dios pejjamechanliajwa jiw naexasisasamata. Ja-am xot, jiw pasasiapi Diosxotse, xamal tapae-emil, naewʉajnam xot asawʉajantat. Xamalbej najut nejxasinka-emil pasliajwam Diosxotse” —aech Jesús judíos chanaekabʉanapiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Japoxan Jesús jʉm-aech wʉt, judíos chanaekabʉanapi, fariseosbej, xabich palalapi Jesúsliajwa. Samata, xabich wʉajnachaemsfʉllisi taliasliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ja-aechi, wʉajnachaemsfʉl wʉt. Japi asbʉan jʉmch wʉajnawet jʉmtaeliajwa Jesús jʉm-aech wʉt babejjamechan Diosliajwa, japoxtat japi tasalaliajwa Jesús pejbʉ'wʉajanpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Xabich jiw pin-iakola natameja Jesúsxot. Samata, nakaewa natabe'nafʉl. Natʉaksae'anbejpi. Jesús matxoelajʉm-aech pejnachalaliajwa: “¡Xamal chiekal taem fariseos chanaekabʉanapoxanliajwa, xamal naekichachajbasamatapi! Fariseos asew jiw fiat japi pajut ispoxan, jiw isasamata. ");
INSERT INTO guoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Moechaspoxan asamatkoi tulaelaxaes. Maliach jʉm-aechpoxanbej, asamatkoi puexa jiw tulaela jʉmtaeyaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Madoi jʉm-ampoxan maliach, o, batutat nuthaklajametat jum-ampoxan, japoxanbej asamatkoi asew jiw tulaela chiekal jʉmtaeyaxael” —aech Jesús, pejnachala naewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesús pejme jʉm-aech pejnachalaliajwa: “Xamal tajnachala, jʉm-an ampox. ¡Xamal nabej nejlewle' beyaxaelpi xamal! Xamal ba wʉti, japi kaes machiyaxil xamalliajwa, isliajwa kaes wejisal xot. ");
INSERT INTO guoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pelax xamal sitaeyaxaelam Dios, japon to'axael xot nej-aelan infierno poxadik” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Cinco mia mowas kolekafefliajwa. Ja-aech, japi mia omjil xotlejen. Pe ja-aech wʉt, Dios chinax kaen mianxot nejkiowaxil chiekal tataeflaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dios kaes pejme nejxasink xamal. Me-ama mia nejxasink wʉt, jachi-el, Dios nejxasink wʉt xamalliajwa. Dios matabijtbej massʉapich nejmatla kaenanʉla xamalxot. Samata, ¡xamal nabej nejlewle'! Xamal xabich kaes pejme ommaenkam. Me-ama mia pin-iat, jachi-emil” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Xamal jʉm-an ampox. Japi jʉm-aechpi jiw pejwʉajnalel: ‘Xanal Jesús pejnachalwan’ —aech wʉti, japi tajnachalaxael. Xanbej, puexa jiw pakoewkolnan, jʉmchiyaxaelen japi jiwliajwa: ‘Ampi tajnachala’ —chiyaxaelen Dios pej-ángeles pejwʉajnalel Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Asew jiwlax jʉm-aechpi asew jiw pejwʉajnalel: ‘Xanal Jesús pejnachala-enil’ —aech wʉti, xanbej jʉmchiyaxaelen japiliajwa: ‘Ampi jiw tajnachala-el’ —chiyaxaelen Dios pej-ángeles pejwʉajnalel Diosxotse” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Jiw jʉm-aech wʉt babejjamechan xanliajwa, xan puexa jiw pakoewkolnanliajwa, japi Dios kawʉajan wʉt beltaeyaxaesi japoxliajwa. Pelax jiw jʉm-aech wʉt babejjamechan Espíritu Santoliajwa, japi jiw beltaeyaxisal Dios” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Xamal bʉflaeyaxaeli judíos naewʉajnabachan poxade, paklochow poxadebej. Ja-aech wʉt, ¡nabej nejchaxoele' jʉmchiyaxaelampoxan, jʉmnosliajwam wʉt paklochow! ");
INSERT INTO guoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Xamal paklochowxotam wʉt, jawʉt chiekal matabijaxaelam Espíritu Santo pijaxtat jʉmnosliajwam japi paklochow” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jiw natamejaxot, kaen aton jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, taj-ax tʉp wʉt, takoewan, matxoelapijin, puexa taj-ax pejew xabich nosaxael. ¡Takoewan jʉm-amde xan tejwaxaelpi nachaxdusliajwapon! —aechon Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús jʉmnot wʉt, jʉm-aechon: —Kaen aton xan nawʉldui-el juezliajwan, xamal nejew wediajkaliajwan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Do jawʉt, Jesús jʉm-aech jiw natamejapi jʉmtaeliajwa: —¡Chiekal taem! ¡Nabej nejchaxoele' nejew xabichaliajwa! Xamal xabich wʉt nejew, japoxantat kaes chiekal nejchaxoelaximil Diosliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Do jawʉt, Jesús naewʉajan ampawʉajan jiw natamejapiliajwa. Jʉm-aechon: “Kaen aton kemaeyan duk. Xabich wepachaemspon pejlulan. Jol wʉt, xabich jolpon. ");
INSERT INTO guoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kemaeyan nejchaxoel wʉt, nejchaxoelpon ampox: ‘¿Xan achaxkat isaxaelen? Xan ajil bachan tejew cha-owaliajwan’ —aechon, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Do jawʉt, kemaeyan kaes jʉm-aech, nejchaxoel wʉt: ‘Xan matabijtax isaxaelenpox. Cha-aelbax puexa chiekal tʉsaxaelen. Dolisdo', japabawajeltat isaxaelen kaes pinabachan puexa tejew naxaeyaxan cha-owaliajwan. ");
INSERT INTO guoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Do jawʉx, pinabachantat tejew naxaeyaxan cha-owax wʉt, nejchaxoelaxaelen: “Xan xabich tejew naxaeyaxan cha-owax pin-iawaechan xaeliajwan. Samata, piach nabichaxinil. Damlathʉlaxaelen. Xaeyaxaelen. Feyaxaelenbej. Xabich nejchachaemlaxaelen” —chiyaxaelen, nejchaxoelx wʉt’ —aech kemaeyan, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pe jawʉt, Dios jʉm-aech kemaeyanliajwa: ‘¡Xam nejliaklanam! Matabijs-emil ampamadoitat xam tʉpaxaelampox. Samata, ¿achanliajwakat naxaeyaxan cha-owam?’ —aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jasox jatis japon atonliajwa xabich tamejapon pejew pajutliajwa. Dios nejchaxoel wʉt, jʉm-aechon japon kimaeyanliajwa: ‘Xanliajwa ampon aton, me-ama xabich kejil wʉt, ja-aechon’ —aech Dios, nejchaxoel wʉt japonliajwa” —aech Jesús jiw natamejapi jʉmtaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús jʉm-aech pejnachalaliajwa: “Xan jʉm-an ampox. ¡Nabej nejchaxoele' xaeliajwampoxan, naxoeliajwampoxanbej! ");
INSERT INTO guoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Xatis duila-esal naxaeyaxkalliajwa, naxoekalliajwabej. Dios nakchaxduw nakwewe'ppoxan japoxantat xatis duilaliajwas. Samata, Dios nakchaxduiyaxael naxaeyaxan, naxoeyaxaespoxanbej. ");
INSERT INTO guoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nejchaxoelam wʉt, ¡nejchaxoelde mialiajwa! Mia naxaeyaxan mʉtha-el. Jola-elbejpi cha-owaliajwa. Pe nakiowa, Dios chaxduw mia xaeliajwa. Dios xamal kaes pejme nejxasink. Me-ama mia nejxasink wʉt, jachi-elon. Samata, nej-ax Dios xamal chiekal tataeflafʉlaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ja-aech wʉt, ¿ma-aech xotkat xamal xabich nejchaxoelam? Xabich nejchaxoelam wʉt, ja-am wʉt, kaes kaematkoiliajwa laelpaximil, xabich nejchaxoelam xot. ");
INSERT INTO guoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Xajʉpa-emil wʉt japox isliajwam, ¿ma-aech xotkat xabich nejchaxoelam japoxliajwa, asaxanliajwabej?” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Nejchaxoelam wʉt, ¡nejchaxoelde naetalan, chimiatalanpox! Ti't wʉt, nabich-el chimialiajwa. Pe puexa chiekal chimia. Xanlax jʉm-an. Rey Salomón majt laeja wʉt, japon xabich chimia naxoeipon. Pe kaes pejme chimia, naetalan. ");
INSERT INTO guoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cha-aelnaex, yotat nuili, Dios pijaxtat natala wʉt, xabich chimiatalan. Pe piachliajwa-el. Asbʉan jʉmch kaematkoiyan sʉapichliajwa. Do jawʉx, tʉp. Do jawʉxbej, tamejas lausliajwas. Pe Dios xamal xabich kaes tataefʉl. Me-ama naetalan tataefʉl wʉt, jachi-el Dios. Samata, ¡Dios chiekal xanaboejim chimia xamal xajoeliajwapon! Xamal wewe'pfʉk Dios chiekal xanaboejaliajwam. ");
INSERT INTO guoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Samata, ¡xabich nabej nejchaxoele' xaeliajwampoxan, feliajwampoxanbej! ¡Dioskal xanaboejim! ");
INSERT INTO guoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dios naexasis-eli xabich nejchaxoel xaeliajwapoxan, naxoeliajwapoxanbej. Xamallax nej-ax Dios. Japon matabijt xamal wewe'ppoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","¡Xamal chiekal naexasisfʉlde Dios puexa pejjiw tato'laxaelpox! Ja-amsfʉlam wʉt, Dios chaxduiyaxael xamal wewe'ppoxan” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Do pejme Jesús jʉm-aech pejnachalaliajwa: “¡Xamal nabej nejlewle', kaesʉapicham wʉt! Dios xamal nejxasink xot, makanot asamatkoi xamal duilaliajwam Diosxotse, jiw tato'laliajwambej jaxotse. ");
INSERT INTO guoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","¡Nejew mowim! Mowam wʉt, ¡japaplata chaxduim xabich wewe'paspi! Ja-am wʉt, Dios xabich nejchachaemlaxael xamalliajwa. Dios isaxaelbej pachaempox xamalliajwa Diosxotse. Jaxotse pasaxil kethaka nejew nosliajwa. Ajilaxaelbej itxaeyaxaeli. Jaxotsebej toepaxil nejew. ");
INSERT INTO guoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Diosxotse, japon xamal chaxduiyaxael pachaempoxan. Samata, ¡nejchaxoelafʉlde pasliajwam japonxotse!” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús jʉm-aech pejme pasaxoekpoxliajwa: “Chalechkal xan pasaxoekan ampathatat. Xamal laelpampimfʉk, ¡chiekal thilsfʉlde, wʉajnawesfʉlam wʉt tajpasax! ");
INSERT INTO guoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xamal matabijam. Kaen paklon fiesta poxaliajwade wʉt, to'apon pamak kawetaliajwa, japi wesfʉlaliajwa paklon pejba. Do jawʉx, paklon fiesta poxade. Do baxael, chalechkal paklon pa'an wʉt, bafafa daka wʉton, kamta pamak wefafasaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pamak naliasfʉlpoxtat pejpaklon pat wʉt, ja-aech wʉt, japi nejchachaemlaxael paklonliajwa. Diachwʉajnakolax xan jʉm-an xamalliajwa. Paklon to'axaesi chalakaliajwa paklon pejmesaxot. Do jawʉx, paklon pajut naxaeyax chaxduiyaxael japi pamak xaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pinmadoitat, o, nalianax mox pawʉajna wʉt, paklon pat wʉt, japahoratat pamak nakiowa naliasfʉl wʉt, japi nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","¡Matabijimbej jʉmchiyaxaelenpox! Bapijin matabijt wʉt kethakan pasaxaelhoratat japon wenatkowaliajwas, japon aton naliasfʉlaxael pejbatat, wʉajnawesfʉlaliajwabejpon kethakan. Ja-aech wʉt, kethakan natkowaxil japon pejbatat. ");
INSERT INTO guoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","¡Xamallap-is ja-amsfʉlde, xan nawʉajnawesfʉlam wʉt! Xanbej, puexa jiw pakoewkolnan, jachiyaxaelen. Chalechkal pasaxoekan, ampathatpijiw nawʉajnawesfʉla-el wʉt” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —Tajpaklon, xam jʉm-ampox, wʉajan, ¿japoxkat xanalkalliajwa, o, puexa jiwliajwabej? —aech Pedro, wʉajnachaemt wʉt Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús jʉm-aech Pedroliajwa: “Xan jʉmchiyaxaelen wʉajan, kaen nabichan, pachaemponliajwa. Japon pomatkoicha chiekal nabist paklonliajwa. Babijax nejchaxoela-elon. Paklon ajil wʉt, japon chiekal tato'lafʉl asew nabichow. Naxaeyaxanbej chiekal chaxduwbejpon pomatkoicha, me-ama paklon to'ason japox isliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Paklon pat wʉt, taen wʉtbejpon nabichan chiekal nabistpox, ja-aech wʉt, japon nabichan xabich nejchachaemlaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Diachwʉajnakolax xan jʉm-an. Paklon matabijt wʉt nabichan chiekal nabistpox japon pejwʉlela, ja-aech wʉt, paklon to'axaeson puexa paklon pejew tataeflaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Pe nabichan chiekal nabich-el wʉt paklon pejwʉlela, japon nabichan nejchaxoelaxael: ‘Tajpaklon xabich pin-iamatkoiyan pasaxil’ —chiyaxaelon, nejchaxoel wʉt. Samata, chiekal tataeflaxilon asew nabichow. Be'balaxaelon poejiw, watho'bej. Do jawʉx, tʉadusaxaelon xaeliajwa, saxsliajwasbej. Jasox isfʉlaxaelon pomatkoicha. ");
INSERT INTO guoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ja-aech wʉt, nejchaxoelaxilon paklon pasaxaelpox. Do jawʉt, chalechkal paklon pasaxael. Do jawʉtbej, nabichan xabich kastikaxaes. Jawʉx to'axaeson asew jiw poxade, Dios naexasis-eli poxade” —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jesús pejme jʉm-aech pejnachalaliajwa: “Nabichan matabijt wʉt paklon to'asox isliajwa, pe is-el wʉton, ja-aech wʉt, nabichan xabich selsaxaes. ");
INSERT INTO guoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Asew nabichow chiekal jʉmmatabija-el wʉt paklon to'aspox, ja-aech wʉt, japi is paklon nejxasinka-elpox. Do ja-aech wʉt, japi kastikaxaes. Pe selsaxaes wʉt, xabich selsaxisal. Puexa paklochow chiekal isaxael pejbichaxan pachaempoxantat. Diosxotse wʉt, asamatkoi chapaeyaxaeli pejbichaxan ispoxanliajwa. Samata, kaes pejme pachaem isliajwa pejbichaxan pachaempoxantat, kastika-elaliajwaspi Dios” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Xan fʉloekx ampathatasik puexa jiw babijaxan ispoxan wemosliajwan, xan tʉpx wʉt. Asew jiwxot xan nanaexasisaxael. Pe asew jiw xan nanaexasisaxil. Asamatkoi japi Dios xabich kastikaxaes. Tajnabijasax, tajtʉpaxbej, toep wʉt, jawʉt xan xabich nejchachaemlaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xabich babejkolax, nabijasax, nawewe'pfʉk japox xan naxapaejsliawa. Xan xabich nabijasaxaelen, naboesa wʉti. Samata, xabich nejchaxoelx tajpatʉpaxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nejchaxoelam wʉt, ¡nabej nejchaxoele': ‘Jesús fʉloek potʉajnʉcha jiw chiekal kaenejchaxoelaxliajwa, chiekal duilaliajwabej nabe-elaxtat’ —nabej aeche', nejchaxoelam wʉt! Xan pas-enil japoxliajwa. Xan tajaxtat xabich jiw kaenejchaxoelaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kaebatat cinco jiw duil wʉt, japixot kaenejchaxoelaxil. Tres xan nanaexasisaxael. Kolenje nanaexasisaxil. El wʉt, kolenje xan nanaexasisaxael. Tres nanaexasisaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kaebaxot pax, paxʉlan sʉapich, kaenejchaxoelaxil xan tajaxtat. Japixot kaen xan nanaexasisaxil. Asan nanaexasisaxael. Pen, paxʉlow sʉapich, jachiyaxaelbej. Japixot kaeow xan nanaexasisaxil. Asaow nanaexasisaxael. Paem, pakala sʉapich, jachiyaxaelbej. Japixot kaeow xan nanaexasisaxil. Asaow nanaexasisaxael” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús jʉm-aech jiwliajwa: “Amxot, Israel tʉajnʉxot, itloejen fʉlaen wʉt juimt tujoplel, xamal japox taenam wʉt, jʉm-am: ‘Amwʉt iam thilnaxael’ —am xamal. Do jawʉx, japamatkoitat diachwʉajnakolax iam thilan, me-ama xamal jʉm-am. ");
INSERT INTO guoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Surlel, wik wʉt, xamal jʉm-am: ‘Amwʉt xabich masxaenkaxael’ —am xamal. Do jawʉx, japamatkoitat diachwʉajnakolax xabich masxaenk, me-ama xamal jʉm-am. ");
INSERT INTO guoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Xamal naekichachajbapijwam! Matabijam, xabich masxaenkaliajwa wʉt, iam thilnaliajwa wʉtbej. ¿Pe ma-aech xotkatlax xamal matabija-emil Dios ispoxan ampamatkoiyantat?” —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Do pejme Jesús jʉm-aech jiwliajwa: “Nejchaxoelam wʉt, ¡najut chiekal nejchaxoelde isfʉlaliajwam pachaempoxan! ");
INSERT INTO guoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Xamal isam wʉt babijax asan atonliajwa, japon aton xamal bʉ'fol wʉt juez poxade xamal kastikaliajwa, ¡chiekal jʉm-amde bʉ'folponliajwa, chaemsliajwam japox babijax, japon aton sʉapich! ¡Ja-amde juez kastikasamata xam! Jasox jachi-emil wʉt, xamal wiasaxaelon jiw jebatat jeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Xan chiekal jʉm-an. Xamal jiw jebatat jia wʉti, xamal kamta nakolaximil. Jaxot nakolaximil, mos-emil wʉt babijax isampoxanliajwa. Xam mosaxaelam puexa dewatampoxan jaxot nakolaliajwam” —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jiw patpi Jesúsxot, japi jʉm-aech Jesúsliajwa: —Galilea tʉajnʉpijiw pat Jerusalén paklowaxxot. Japi choef xʉa'at Dios pejtemplobatat Dios chaxduiliajwapi ofrenda. Do jawʉt, Pilato to'a pejsoldaw japi jiw beliajwas. Baes wʉt, japi pejjal, choefjal sʉapich, matanialas —aechi Jesúsxot pati, chapaei wʉti Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús jʉm-aech japi jiwliajwa: —Xamal bej nejchaxoelambej: ‘Japi japox wejatis, kaes babijaxan is xot. Me-ama asew jiw pejtʉajnʉpijiw, jachi-el xoti’ —bej ambej, nejchaxoelam wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Xan jʉm-an: ‘Japi japox wejatis xamal najut kofaliajwam babijaxan isfʉlampoxan. Kofa-emil wʉt, asamatkoi tʉpam wʉt, xamalbej Dios kastikaxael. Diosxotaximilbej’ —an xan. ");
INSERT INTO guoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ba, xabich athʉpox, Torre de Siloé pawʉlpox, chalechkal chajia jʉwal Jerusalén paklowaxxot. Japox jʉwal wʉt, dieciocho jiw matkaeyas. Xamal nejchaxoelam wʉt, bej jʉm-ambej matkaeyaspiliajwa: ‘Japi japox wejatis, kaes babijaxan is xot. Me-ama asew jiw, Jerusalén paklowaxpijiw, jachi-el xoti’ —bej ambej, nejchaxoelam wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Xan jʉm-an: ‘¡El! Japi jasox wejachi-esal. Xamallax kofa-emil wʉt babijaxan isfʉlampoxan, asamatkoi tʉpam wʉt, Dios xamalbej kastikaxael. Diosxotaximilbej’ —an xan —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús naewʉajan wʉt jiw, higonaeliajwa jʉm-aechon: “Kaen aton pejlul. Pejlultutat higonae nuk, chajia mʉthtasnae. Lulpijin mox soepan japanae taeliajwa, pabaech wʉt tʉsliajwa. Pe japanae baechjil. ");
INSERT INTO guoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Samata, lulpijin jʉm-aech pejlul wetataeflasponliajwa: ‘¡Taem ampanae! Ampoxtat tres waechan fʉlaenxpox, pabaech wʉt tʉsliajwan. Pe chinax naboes-el. Samata, ¡likde nae! ¡Kaes nabej tapaetis ampanae sat it-elaliajwa’! —aech lulpijin. ");
INSERT INTO guoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lul tataeflan jʉmnot wʉt, jʉm-aechon paklonliajwa: ‘Tajpaklon, ¡ma ampawaechtatfʉk tapaem! Xan chabakasaeyaxaelen. Do jawʉt, abono chabakatholaxaelenbej. ");
INSERT INTO guoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ja-an wʉt, japanae bej naboesaxaelbej asawaestat. Pe japawaestat naboes-el wʉt, do jawʉt, japanae liksaxaelen’ —aech lul tataeflan” —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Asamatkoi, napatamatkoi wʉt, Jesús naewʉajan judíos naewʉajnabaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Japabaxot kaeow pawis ek, bʉ'xaenkpow. Pomatkoicha jajʉlwax chalaejapow. Chinax nadolsaxilow. Japow dieciocho waechan, ja-aech dep ketispoxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús taen wʉt japow, lapon. Japow pat wʉt Jesúsxot, jʉm-aechon japowliajwa: —Xam boejthʉtx bʉ'xaenkampox —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús ke-ot japow pejta'tat. Jawʉt japow chiekal nadolt. Kaes jajʉlwa-elow. Do jawʉt, japow jʉm-aechfʉl Diosliajwa: “Dios, xam isam xabich pachaempox xanliajwa. Xam xabich pachaemam” —aechow Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jawʉt judíos naewʉajnaba tataeflan palala Jesúsliajwa, Jesús boejthʉt xot japow napatamatkoitat. Samata, judíos naewʉajnaba tataeflan jʉm-aech jiwliajwa: —Kaesemana seis matkoiyan nabichliajwas. Japamatkoiyan wʉt, xamal fʉlaeyaxaelam ampaleldin. ¡Nabej fʉlae' napatamatkoi wʉt Jesús boejthʉsliajwa xamal! —aech judíos naewʉajnaba tataeflan. ");
INSERT INTO guoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Do jawʉt, Jesús jʉm-aech judíos naewʉajnaba tataeflanliajwa, asew jiwliajwabej: —¡Xamal naekichachajbapijwam! Chaemilam wʉt, me-ama pachaemam wʉt, pakabʉan-am. Xamalbej najut nabistam napatamatkoitat. Xamal najut sitae-emil napatamatkoi. Nijan woei joltam bʉflaeliajwam japon woei min feliajwa. Woei-el wʉt, nijan bur joltam napatamatkoitat bʉflaeliajwam, japon bur min feliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ampow, Abraham pamow, kaes pejme pachaem. Me-ama choefan, jachi-el. Dep ketispoxtat dieciocho waechan japow bʉ'xaenk. Samata, napatamatkoitat japow boejthʉtx —aech Jesús judíos naewʉajnaba tataeflanliajwa, asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús japox jʉm-aech wʉt, Jesús padaelmajiw padala. Samata, asbʉan jʉmch boejlach chalaki, padala xoti Jesúsliajwa. Asew judíoslax nejchachaemil, jʉmtaen wʉti Jesús jʉm-aechpoxliajwa, taen wʉtbejpi koechax, Jesús ispox. ");
INSERT INTO guoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús jʉm-aech: “Jʉmchiyaxaelen wʉajan xamal chiekal matabijaliajwam, achax kabʉanchiyaxael, Dios puexa pejjiw tato'laxael wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dios puexa pejjiw tato'laxaelpox, me-ama mostazafut, ja-aechox. Kaen aton mʉtht japafut pejlultat. Kamta wenaboeltas. Chiekal weti'tasbejpon. Ti't wʉt, naelisdo'. Samata, japadalantat mia is pejfenan tabʉ-owaliajwa” —aech Jesús. (Jasoxtat japi jiw naexasit Dios tato'alpox majt kaesʉapich. Kaesʉapich matkoiyan wʉt, kaes pejme xabichaxael jiw.) ");
INSERT INTO guoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Do pejme Jesús jʉm-aech: “¿Masoxkat wʉajan chiekal pachaem xamal naewʉajnaliajwan, matabijaliajwambej Dios tato'alpox puexa pejjiw? ");
INSERT INTO guoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dios puexa pejjiw tato'laxaelpox me-ama levadura pan isas wʉt, jachiyaxael japox. Kaeow pawis pan is wʉt, taniala tres taso trigobelan, levadura sʉapich. Do jawʉx, cha-etfʉk posapa puthlaliajwa levaduratat kaes pinasapaliajwa” —aech Jesús. (Jachiyaxaelbej, asamatkoi Dios puexa pejjiw tato'laxael wʉt. Pothata jiw xabich xajʉpaxael.) ");
INSERT INTO guoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús Jerusalén paklowax poxade wʉt, asapaklowaxanxot, tʉajnʉchanxotbej, jiw naewʉajnafʉlon. ");
INSERT INTO guoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Do jawʉt, kaen aton wʉajnachaemtas wʉt, jʉmtispon: —Tajpaklon, ¿diachwʉajnakolaxkat Dios kaesʉapich jiw bʉ'weyaxael? —tispon. Jesús jʉmnot wʉt, jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Diosxotse pasliajwa, me-ama cha-aelaxach laleyax, ja-aechox. Xabich jiw nejxasink pajut pasliajwa. Pe jiw pajut pijaxtat pasaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bapijin ba faka't wʉt, xamal namaeyaxaelam tathoetat. Lam wʉt, jʉmchiyaxaelam: ‘Tajpaklon, ¡ba fafa'e xanal leliajwan!’ —chiyaxaelam bapijin. Pe japon jʉmno'an wʉt, jʉmchiyaxaenon xamalliajwa: ‘Xan matabijs-enil xamal. ¿Amxotpijwamkat xamal?’ —chiyaxaen bapijin. ");
INSERT INTO guoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Xamal jʉmchiyaxaelam: ‘Xanallape, xam sʉapich, kaeyaxtat naxaelaxpin, afxpinbej. Tajpaklowaxxot xam naewʉajnamponam’ —chiyaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bapijin pejme xamal jʉmnosaxaen: ‘Xamal matabijs-enil. Matabijs-enilbej amxotpijwam. Xamal babejchowam. ¡Chijiamde!’ —chiyaxaelon. ");
INSERT INTO guoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Xamal atʉaj taeyaxaelam Abraham, Isaac, Jacob sʉapich, puexa asew profetasbej. Japi Diosxotse amwʉtjel duil. Pe xamal pelsaxaekon infierno poxadik. Jaxotdik xamal xabich noeyaxaelam. Bʉa'tatisaxaelambej, xabich nabijasaxaelam xot. ");
INSERT INTO guoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Xabich jiw, potʉajnʉchanpijiw, pasaxael Diosxotse. Japi jiw chalakaxael Diosxot. Naxaeyaxaelbejpi. ");
INSERT INTO guoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jiw amwʉtjel kaes paklochowpi, japi Diosxotse paklochowaxil. Asew amwʉtjel paklochowa-elpi, japi kaes paklochowaxael Diosxotse —aech Jesús aton, wʉajnachaemtasponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesús bʉxtoet wʉt wʉajnachaemtasponliajwa, jawʉt kaesʉapich jaxot fariseos pat, Jesúsxot. Do jawʉt, fariseos jʉm-aech Jesúsliajwa: —¡Ma amxot xam asalel chijiamde, rey Herodes fʉlaeyaxaen xot xam boesaliajwa! —aech fariseos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús jʉmnot wʉt, jʉm-aechon: —¡Xamal xabʉa'de Herodes poxade! Japon aton, me-ama lam wʉt, ja-aechon, jiw tabejsan xot. ¡Chapaempon xan isfʉlaxpoxan, nanʉamtax wʉt! ¡Jʉm-amopon, chapaeyam wʉt: ‘Jesús jʉm-aech: “Amwʉtjel, kandiawabej, to'axaelen dep nakolaliajwa, jiw pejmatpʉatanxot webaespi. Bʉ'xaenkpibej boejthʉsaxaelen. Asakandiawa wʉt, toesaxaelen tajbichax’ —aech Jesús’ —amo Herodes! ");
INSERT INTO guoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amwʉt fʉlaeyaxaelen Jerusalén paklowax poxade. Jasoxtat pasaxaelen Jerusalén paklowax, jaxotde naboesaliajwapi, Dios pejprofetas jibaes xot Jerusalén paklowaxxot —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesús xabich nejxaejwas, nejchaxoel wʉt Jerusalén paklowaxpijiwliajwa. Samata, jʉm-aechon: “Xamal Jerusalén paklowaxpijwam, Dios pejprofetas pabam. Asew profetasbej ia'tat dadapam, Dios bʉxto'aspi xamal naewʉajnaliajwa. Me-ama kawaema paxi tameja pejba'bʉxfaltat, xan jachisian xamal bʉ'weliajwan. Pe xamal xan nanejwesla. ");
INSERT INTO guoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Chiekal najʉmtaem! Nejpaklowaxxotaxil Dios. Kaes kajachawaesfʉlaxilbejpon xamal. Piach nataeyaximil. Xan pejme patx wʉt, jawʉt xamal jʉmchiyaxaelam xanliajwa: ‘Dios nej kajachawaesas fʉlaenpon Dios pijaxtat’ —chiyaxaelam, pejme nataeyaxaelam wʉt” —aech Jesús, nejxaejwas wʉt Jerusalén paklowaxpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Napatamatkoi wʉt, Jesús fʉlaech xaeliajwa kaen fariseospaklon pejba poxade. Jaxotdebej asew fariseos, japi Jesús padaelmajiw. Japi tataefʉl Jesús taeliajwapi, Jesús is wʉt babijax. ");
INSERT INTO guoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Do jaxotde wʉt, kaen aton, pobʉ'ta xabich bʉ'pʉthalpon, japon nuk Jesús pejwʉajnalel. ");
INSERT INTO guoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Do jawʉt, Jesús wʉajnachaemt judíos chanaekabʉanapi, fariseosbej. Jʉm-aechon: —¿Naktapaeikat bʉ'xaeyan boejthʉsliajwas napatamatkoitat? O, ¿ja-elkat? —aech Jesús japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Japi jʉmnos-el. Do jawʉt, Jesús bʉ'xaeyan mʉaxfit wʉt, Jesús chiekal boejthʉt bʉ'xaeyan. Do jawʉx, Jesús to'a japon nawiasliajwa pejba poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Do jawʉt, Jesús jʉm-aech fariseosliajwa: —Naxʉlan jop wʉt mʉthadik napatamatkoitat, o, nijan woei jop wʉtbej napatamatkoitat, xamal jusaxaelampon. ¿Diachwʉajnakolaxkat japox? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Japi wejisal jʉmnosliajwapi Jesús. Asbʉan jʉmch boejlach chalaki. ");
INSERT INTO guoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseospaklon pejbatat wʉt, Jesús taen, asew fariseos chalak wʉt tʉa-ekaxan, kaes paklochowpiliajwapi chalak wʉti. Jesús japox taen wʉt, jʉm-aechon japi fariseosliajwa japoxan kofaliajwapi. Jesús naewʉajan wʉt, jʉm-aechon japiliajwa: ");
INSERT INTO guoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Kaen aton xamal tadʉt wʉt nakjiyafiesta poxade, jaxotde xaeliajwam, ¡nabej chalake' paklochow chalakaxaelpoxantat! Ja-am wʉt, asew bej pasaxaelbej tadʉchpi, japi kaes paklochowpi. Japi, me-ama xamal, jachi-eli. ");
INSERT INTO guoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ja-aech wʉt, xamal tadʉtpon pasaxael xamalxot jʉmchiliajwa: ‘¡Ampatʉa-ekaxanxot xamal nanim, asew chalakaliajwa!’ —chiyaxaelon xamalliajwa. Japatʉa-ekaxanxot xamal nanam wʉt, nanaxaelam xabich nadalaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kaes pachaem xamal chalakaliajwam taxdukatʉa-ekaxantat, tadʉt wʉti xamal xaeliajwam, fiestamatkoi wʉt. Do jawʉt, xamal tadʉtpon xamalxot pat wʉt, jʉmchiyaxaelon: ‘¡Amxot xamal nanim! ¡Chalakde kaes paklochow chalakpoxantat!’ —chiyaxaelon xamalliajwa. Do jawʉt, xamal chalakaxaelam japatʉa-ekaxantat. Jaxot chalakam wʉt, puexa jiw, chalaki mesaxot, japox taeyaxael. Ja-aech wʉt, xamal kaes sitaeyaxael jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nejmach-aton nejchaxoel wʉt pajutliajwa, nejchaxoelon ampox: ‘Xan kaes pejme pachaeman. Me-ama asew jiw, jachi-enil’ —aech wʉton pajutliajwa, japon aton Dios jʉmchiyaxaes: ‘Xam kaes pejme pachaema-emil’ —chiyaxaeson. Asan atonlax nejchaxoel wʉt pajutliajwa: ‘Xan pejme kaes pachaema-enil. Me-ama asew jiw, jachi-enil’ —aech wʉton pajutliajwa, asamatkoi japon aton jʉmchiyaxaes Dios: ‘Xam kaes pejme pachaemam’ —chiyaxaeson Dios —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Do jawʉtbej, Jesús jʉm-aech fariseospaklonliajwa, japon tadʉchpon Jesús: —Xam asew jiw tadʉtam wʉt xaeliajwapi nejbatat, matnochpijax, o, kaliaxpijax, ¡nabej tadʉs xam matabijtampikal! ¡Nabej tadʉsbej nejnachala, nakoew, nejjiwbej, kemaeyabej, mox duilibej nejbaxot, asamatkoi japi xam tadʉsaxael xot xaeliajwam japi pejbatat! Jachiyaxaelam wʉt, xamal, me-ama xanafokam, xam matxoelatadʉtpi, japi xam tadʉtam wʉt xaeliajwa nejbatat. ");
INSERT INTO guoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Xam fiesta isam wʉt, ¡tadʉ'elax kejila, laelpaxilpibej, nabejkabej, itliaklabej! ");
INSERT INTO guoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jasox isam wʉt, xam xabich nejchachaemlaxaelam, japi tadʉsaxil xot xam xanafonaliajwa tadʉtampoxliajwa. Jiw, pachaempi Dios pijaxtat, mata-eyamatkoi wʉt jiw pejme duilaliajwa, jawʉt Dios xam mosaxael japafiestaliajwa —aech Jesús tadʉchponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kaen aton japixot jʉmtaen wʉt Jesús jʉm-aechpox, japon jʉm-aech Jesúsliajwa: —Jiw xabich nejchachaemlaxael, Dios pejfiestaxot xael wʉti Diosxotse —aech japon aton Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Do jawʉt, Jesús wʉajantat jʉmnot wʉt, jʉm-aechon: —Kaen aton pamakjiw keto'a pinjiyax fiesta isliajwa. Do jawʉx, asan pamakan to'apon xabich jiw tadʉsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jawʉt, naxaeyaxan chiekal isax ketoet wʉt, pamakan pejme to'apon jiw jʉmchiliajwa: ‘¡Xabʉa't, puexa chiekal toetx xotlis!’ —chiliajwapon jiw. Do jawʉt, fʉlaechon japox jʉmchiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pe tadʉtaspixot chinax kaen pas-el. Puexa kaenanʉla jʉmxato'a wʉt, jʉm-aechi, ma-aech xot fʉlaeyaxili. Kaen japixot jʉmxato'a wʉt, jʉm-aechon: ‘Amwʉtjel xan sat wʉajtax. Samata, xan japoxade fʉlaeyaxaechan japasat taeliajwan. ¡Nabej nalale' xanliajwa, fʉlaeyaxinil xot nejfiesta poxade!’ —aechon, jʉmxato'a wʉt fiestapijinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Asanbej jʉm-aech, jʉmxato'a wʉt: ‘Xan diez woei wʉajtax. Xan japi xapaejaxaelen. ¡Nabej nalale' xanliajwa, fʉlaeyaxinil xot nejfiesta poxade!’ —aechon, jʉmxato'a wʉton fiestapijinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Asanbej jʉm-aech, jʉmxato'a wʉt: ‘Xan amwʉtjel nakjiyax. Samata, xan fʉlaeyaxinil’ —aechon, jʉmxato'a wʉt fiestapijinliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pamakan to'aspon kaxa nawia'an wʉt, puexa chapaeipon pejpaklonxot. Do jawʉt, pejpaklon xabich palala. Jʉm-aechon pamakanliajwa: ‘¡Xabʉa'de bichakal paklowax poxade! ¡Jaxotde paklowaxthialaxanxot wʉlwekde jiw tadʉsliajwam kejila, laelpaxilpi, itliakla, nabejkabej! ¡Japi jiw bʉflaeman amxot xaeliajwapi!’ —aech fiestapijin pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Dolisdo', pamakan japox is. Jawʉt jʉm-aechon pejpaklonliajwa: ‘Tajpaklon, isxlis nato'ampox. We'pfʉk jiw xajʉpaliajwa puexa tʉa-ekaxan’ —aechon pejpaklonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Do jawʉt, paklon pejme jʉm-aech pamakanliajwa: ‘¡Xabʉa'de! ¡Jiw pejme wʉlwekde nʉamantat, lulnʉamantatbej! Jiw tadʉtam wʉt, ¡jʉmbisnikde japi fʉlaeliajwadin tajba poxadin, tajba chiekal wʉlʉkaliajwapi! ");
INSERT INTO guoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Diachwʉajnakolax xan jʉm-an. Matxoelatadʉtxpi, chinax kaen japixot tajfiesta nakxaeyaxil’ —aech fiestapijin —aech Jesús, ampawʉajan naewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesús xabich jiw fʉlafos wʉt, kaxa natachaemdik wʉt, jʉm-aechon japi jiwliajwa: ");
INSERT INTO guoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nejmach-aton fʉlaen wʉt xanlel tajnachalanliajwa, japon xan nanejxasinkaxael. Me-ama pax nejxasink wʉt, penbej, pijowbej, paxibej, pakoewbej, jachiyaxaelon, xan kaes nanejxasink wʉt japon aton. Me-ama pajut nanejxasink wʉt, jachiyaxaelbejpon xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nejxasinka-elpi xan tajaxtat nabijasliajwa, japi jiw tajnachalwaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kaen aton xamalxot ba isliajwa wʉt, xabich athʉpox, japon majt chiekal nejchaxoelaxael, machiyaxaelon isliajwa japaba. Nejchaxoel wʉt, jʉmchiyaxaelon: ‘¿Xankat tajplatatat xajʉpaxaelen, ampaba isx wʉt chiekal toesliajwan?’ —chiyaxaelon, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Japon aton majt chiekal nejchaxoela-el wʉt ba isliajwa, ba isax tʉadut wʉt, pejplata wexajʉpa-esal wʉt, japon aton pejba chiekal toesaxil. Ja-aech wʉt, jiw bʉ'wʉajanpaeyaxaeson. Xafafolaxaesbejpon jiw, pejba chiekal toes-el xoton. ");
INSERT INTO guoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Japi jiw jʉmchiyaxael: ‘Japon aton tʉadut ba isliajwa. Pe nakiowa, wexajʉpa-esal pejew plata pejba chiekal toesliajwa’ —chiyaxaeson jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Rey nabeliajwa wʉt, asatʉajnʉpijiw sʉapich, japon rey majt chiekal nejchaxoelaxael, machiyaxaelon. Nejchaxoel wʉt, jʉmchiyaxaelon: ‘Xan tajsoldaw asbʉan jʉmch diez mil. Tadaelman veinte mil soldaw. ¿Xankat, tajsoldaw sʉapich, malechaxaelen nachakifʉlaeyaxaenpi?’ —chiyaxael rey, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Dolisdo', rey chiekal matabijt wʉt, jʉmchiyaxaelon: ‘Xan malechaxinil tadaelman’ —chiyaxael rey, nejchaxoel wʉt. Ja-aech wʉt, rey jʉmxato'axael wʉajan xananʉampitat, japox wʉajan wechaemsliajwas, padaelman atʉaj wʉtfʉk. ");
INSERT INTO guoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","¡Xamalbej majt chiekal nejchaxoelde, tajnachalwasiam wʉt! Nejew puexa waela-emil wʉt, ja-aech wʉt, tajnachalwaximil” —aech Jesús nakfʉlaesiaspiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Do pejme Jesús jʉm-aech pejnachalaliajwa, xabich asew jiwliajwabej: “Dom xakuenk wʉt, pachaem. Dom xakuenka-el wʉt, chaemil. Pejmeliajwa pachaemaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Abonoliajwabej chaemil. Ja-aech wʉt, asbʉan jʉmch pachaem thokchaliajwa. Xamal Dios pejnejchaxoelax matabijasiam wʉt, ¡chiekal naewe'e xan jʉm-anpoxan!” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impuesto mat-omwʉljoew gobiernoliajwa, asew jiw, babijaxan ispibej, japi pat Jesúsxot jʉmtaeliajwa Jesús naewʉajanpox. ");
INSERT INTO guoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseos, judíos chanaekabʉanapibej, japi taen, asew jiw pat wʉt Jesúsxot. Jawʉt japi jʉm-aech babejjamechan Jesúsliajwa. Nakaewa najʉm-aechi: —Jesús bʉ'kʉla jiw babejchow. Japi sʉapich, xaelbejpon —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Samata, Jesús japox jʉmtaen wʉt, jʉm-aechon ampawʉajan fariseosliajwa, judíos chanaekabʉanapiliajwabej: ");
INSERT INTO guoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Xamalxot kaen aton cien ovejas wʉt, kaen oveja wenafo'as wʉton, asew noventa y nueve ovejas waelaxaelon jalwekaliajwa wenafo'aspon. ");
INSERT INTO guoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Do faen wʉton oveja, wenafo'aspon, xabich nejchachaemlaxaelon. Taka-osfʉlaxaenon oveja wenafo'aspon. ");
INSERT INTO guoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Dolison, ba pat wʉt, laeyaxaelon pejnachala, mox duilibej, chapaeliajwa wenafo'asponliajwa. Jawʉt jʉmchiyaxaelon: ‘¡Nejchachaemilde, xan sʉapich, xan pejme faenx xot tajan oveja, nawenafo'apon!’ —chiyaxaelon pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Diachwʉajnakolax xan jʉm-an. Jachiyaxaelbej, Dios pej-ángeles nejchachaemil wʉti Diosxotse, kaen aton koft wʉt babijaxan ispoxan ampathatat, japon naexasisfʉlaliajwa Dios. Dios pej-ángeles kaes pejme nejchachaemlaxael japon atonliajwa. Me-ama noventa y nueve jiw, pachaempiliajwa, Dios pej-ángeles nejchachaemil wʉt, jachiyaxili, japon atonliajwa” —aech Jesús fariseosliajwa, judíos chanaekabʉanapiliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesús naewʉajan asawʉajan fariseosliajwa, judíos chanaekabʉanapiliajwabej. Jʉm-aechon: “Pawis diez kafefachan wʉt, kaekafef wenafo'as wʉtow, japow tamdusaxael lámpara japa-itliakaxtat batu athoesliajwa chiekal jalwekaliajwa pejkafef. ");
INSERT INTO guoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dolisow, faen wʉt, laeyaxaelow pejnachala, mox duilibej, chapaeliajwa. Do jawʉt, jʉmchiyaxaelow: ‘¡Nejchachaemilde, xan sʉapich, pejme faenx xot tajkafef, nawenafo'a wʉt!’ —chiyaxaelow. ");
INSERT INTO guoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Diachwʉajnakolax xan jʉm-an. Jachiyaxaellap-is Dios pej-ángeles, nejchachaemil wʉt, kaen aton koft wʉt babijaxan ispoxan japon naexasisfʉlaliajwa Dios” —aech Jesús fariseosliajwa, judíos chanaekabʉanapiliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús naewʉajan asawʉajan, fariseosliajwa, judíos chanaekabʉanapiliajwabej. Jʉm-aechon: “Kaen aton kolenje paxʉlan. ");
INSERT INTO guoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wʉchakalpijin jʉm-aech paxliajwa: ‘Ax, ¡amalis xan nachaxdu'e tejwaxaelpi!’ —aech wʉchakalpijin. Do jawʉt, pax diajan wʉchakalpijin pejewpi. ");
INSERT INTO guoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jawʉx, kaematkoi sʉapich wʉt, wʉchakalpijin puexa pejew mowa. Japaplata xafolon, chijia wʉt atʉaj, asatʉajnʉlel. Jaxotde babijaxan isfʉldepon. Jasoxtat puexa pejew, plata, chiekal xatoeton. ");
INSERT INTO guoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Puexa pejew plata chiekal xatoet wʉt, japamatkoiyan piach naxaeyaxan ajil japatʉajnʉxot, xabich piach iam thilna-el xot. Samata, japon litaxaelafʉl. ");
INSERT INTO guoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Do jawʉt, fʉlaechon japatʉajnʉpijin bichax wʉljoeliajwa. Bichax faen wʉt, paklon to'ason maran tataeflax, chaxajialspi. ");
INSERT INTO guoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Do jawʉt, japon aton maran xaelpoxan, japonbej xaesia, xabich litaxaela xoton. Pe chinax chaxdus-esal japon xaeliajwa maran xaelpoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Do jawʉt, japon pajut chiekal nejchaxoel wʉt, jʉm-aechon: ‘Pomatkoicha taj-ax pejbaxot xabich naxaeyaxan pamakjiw chaxduiliajwa. Taj-axxot naxaeyaxan nama. Xanlax amxot tajlit tʉpaxaelen’ —aechon, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Do jawʉt, japon nejchaxoel wʉt, jʉm-aechon: ‘Xan nawoesa nawiasaxaelen taj-ax poxade. Patx wʉt taj-axxot, xan jʉmchiyaxaelen: “Ax, xan xabich babijaxan isx Diosliajwa, xamliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Xan babejnan. Samata, xan tadala kaes naxʉlnan napaeliajwam. Me-ama namakan tato'lam wʉt, ¡ja-amde xanliajwa!” —chiyaxaelen, taj-axxot patx wʉt’ —aechon, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dolison, japox nejchaxoel wʉt, chijialison pax poxade nawiasliajwa. “Do baxael, atʉaxach fʉlaen wʉtlejen, pax taenson. Jawʉt pax xabich beltaen paxʉlan. Do jawʉt, najae'epon paxʉlan bʉ'kakʉlnaliajwa. Jawʉt wʉjaelton paxʉlan. Wʉjaelt wʉt, xusuwpon paxʉlan. ");
INSERT INTO guoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jawʉt paxʉlan jʉm-aech paxliajwa: ‘Ax, xan xabich babijaxan isx Diosliajwa, xamliajwabej. Xan babejnan. Tadala kaes naxʉlnan napaeliajwam’ —aech paxʉlan paxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pe jawʉt, pax jʉm-aech, pamakjiw to'a wʉt: ‘¡Xabʉa'de! ¡Wʉljae'e naxoelax kaes chamoeyaxpox! ¡Xajoembejpon! ¡Anillo kothiyaxajoeldebejpon! ¡Tʉakxajoeldebejpon tʉakxajoelax! ");
INSERT INTO guoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Do jawʉx, ¡bʉflaeman pak jelti'san, kaes dalpon! ¡Japon xʉa'alde! Amwʉt fiesta isaxaes xaeliajwas. ");
INSERT INTO guoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Taxʉlanliajwa nejchaxoelx wʉt, jʉm-an: “Diachwʉajnakolax taxʉlan asatʉajnʉtat bej nawetʉpbej” —an, nejchaxoelx wʉt. Pe laejapon. Nejchaxoelxbej: “Bej nafo'abejpon” —an, nejchaxoelx wʉt. Pe nawepaton’ —aech pax pamakjiwliajwa. Do jawʉx, fiesta isax tʉadutlisi. ");
INSERT INTO guoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Pakoewan pat wʉt pax pejbatat, matxoelapijin lultat nabistpon. Pejbichax kekoft wʉt, ba mox itwefʉlaen wʉt, thiataenpon jajuiyax. Thiataenbejpon nababoelax. ");
INSERT INTO guoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jawʉt matxoelapijin lapon pamakan. Wʉajnachaemt wʉt, jʉm-aechon: ‘¿Ma-aech xotkat amwʉtjel fiesta isam?’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pamakan jʉmnot wʉt, jʉm-aechon: ‘Nakoewan pat. Samata, nej-ax xanal naketo'a pak jelti'san, kaes dalpon, xʉa'laliajwan’ —aech pamakan. ");
INSERT INTO guoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Matxoelapijin japox jʉmtaen wʉt, xabich palalapon. Palala xot, ba le-elon. Samata, pax nakolde. Paxʉlan leyax to'aliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Matxoelapijin jʉm-aech paxliajwa: ‘Xabich pin-iawaechan xam tanbistax. Chinax owchila-ela-enil, nato'am wʉt. Xanlax chinax kaen cabra, jelti'san, nachaxdus-emil, xan fiesta isliajwan, tajnachala sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amwʉtjel naxʉlan pat, nejew plata xatoetpon watho'tat, poejiw bʉ'moejtpitat plata kanaliajwa. Japonliajwalax xam fiesta isam. Japonliajwabej namakjiw keto'am pak jelti'san xʉa'laliajwa, kaes dalpon’ —aech matxoelapijin paxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Pax jʉmnot wʉt, jʉm-aechon paxʉlanliajwa: ‘Wʉa, xam pomatkoicha xanxotam. Puexa xan tejewpi, japoxan xam nejwaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amwʉtjel pachaem fiesta isliajwas, puexa nejchachaemlaliajwas. Nakoewanliajwa nejchaxoelx wʉt, jʉm-an: “Diachwʉajnakolax asatʉajnʉtat taxʉlan bej nawetʉpbej” —an, nejchaxoelx wʉt. Pe laejapon. Nejchaxoelx wʉt, jʉm-anbej: “Bej nafo'abejpon” —an, nejchaxoelx wʉt. Pe nawepaton amwʉtjel’ —aech pax matxoelapijinliajwa” —aech Jesús fariseosliajwa, judíos chanaekabʉanapiliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús naewʉajan wʉt pejnachala, asawʉajantat jʉm-aechon: “Kaen paklon xabich kemaenk. Japon paklon kaen pamakan, puexa wetataeflaspon. Pe pamakan maliach wexatoesfʉl paklon pejew plata. Do ja-aech wʉt, asew jiw maliach chapaeipi paklonxot, pamakan maliach wexatoesfʉlpox pejpaklon. ");
INSERT INTO guoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Samata, paklon pamakan la wʉt, jʉm-aechon: ‘Xampil tejew maliach nawexatoesfʉlam. ¡Xalaeman cuenta lelamfʉt, pomatkoicha tejew mowam wʉt, wʉajtam wʉtbej xanliajwa! Ma amwʉt xam kaes puexa tejew nawetataeflaximil’ —aech paklon pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Do jawʉt, japon, paklon pamakan, nejchaxoel wʉt, jʉm-aechon: ‘¿Xan machiyaxaelenkat amwʉt? Tajpaklon najusaxael tajbichaxxot. Xan mamnika-enil sat nabichliajwan. Xan tadalabej asew jiw malech plata wʉljoeliajwan. ");
INSERT INTO guoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aa, xan matabijtax isaxaelenpox! Japox isx wʉt, nabich-enil wʉt tajpaklonliajwa, asew jiw pejbaxot patx wʉt, chiekal nabʉ'kʉlaxaeli’ —aech pamakan, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Do jawʉx, japon kaenanʉla wʉllala pejpaklon dewati japi fʉlaeliajwadin. Wʉllala wʉt, matxoelapatponliajwa jʉm-aechon: ‘¿Massʉapichkat xam dewatam tajpaklon?’ —aechon matxoelapatponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Matxoelapatpon jʉm-aech: ‘Xan dewatax nejpaklon ochocientos galones olivosiminan’ —aech matxoelapatpon. Do jawʉt, jusaxaespon pejpaklon pejbichaxxot, japon jʉm-aech: ‘Ama pelfʉt majt xam lelampox jasʉapich dewatampox. ¡Asafʉtat lelde dewatampox asbʉan jʉmch cuatrocientos galones olivosiminan!’ —aech jusaxaespon. Jawʉt dewatpon japox is. ");
INSERT INTO guoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Do jawʉx, asan pat wʉt, jusaxaespon pejpaklon, japon jʉm-aech patponliajwa: ‘¿Massʉapichkat xam dewatam tajpaklon?’ —aech jusaxaespon. Dewatpon jʉmnot wʉt, jʉm-aechon: ‘Xan dewatax nejpaklon cien trigobulan’ —aech dewatpon. Jusaxaespon pejpaklon jʉm-aech: ‘Ama pelfʉt majt xam lelampox jasʉapich dewatampox. ¡Asafʉtat lelde dewatampox asbʉan jʉmch ochenta trigobulan!’ —aech jusaxaespon pejpaklon. Do jawʉt, dewatpon japox is. Jasox isfʉl pejpaklon jusaxaespon asew jiwliajwabej, dewatpiliajwa japon pejpaklon. ");
INSERT INTO guoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Do japox isax ketoet wʉt, jusaxaespon pejpaklon xalaechon japi pel-ʉaf pejpaklon chaxdusliajwa. Do jawʉt, paklon matabijt wʉt japox ispoxliajwa, jʉm-aechon pamakanliajwa, chijiyaxaelponliajwa: ‘Xam babijax isam xanliajwa, xabich matabijtam xot. Japox isam asamatkoi xamliajwa pachaemaliajwa’ —aech paklon pamakan chijiyaxaelponliajwa. Dios naexasis-eli, kaes pejme matabija wʉajsliajwa, mowaliajwabej. Me-ama Dios naexasiti, jachi-eli” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Diachwʉajnakolax xan jʉm-an. ¡Nejplatatat, nejewtatbej, asew jiw kajachawae'e ampathatat, japi nabist wʉt Dios pejbichaxan! Japoxan xatoetam wʉt, asamatkoi, xamal tʉpam wʉtbej, Diosxotse xamal chiekal bʉ'kʉlaxaeli” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Aton asan pejew chiekal tataeflafʉl wʉt, kaeyaxachpoxan, chinax maliach xatoes-el wʉton, japon aton xajʉp asan pejew chiekal tataeflaliajwa, xabich wʉtbej. Asan chiekal tataefla-el wʉt asan pejew, kaeyaxachpoxan, japon xajʉpaxilbej asan pejew chiekal tataeflaliajwa, xabich wʉt asan pejew. ");
INSERT INTO guoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Xamal xajʉpa-emil wʉt chiekal tataeflaliajwam asan pejew plata, ja-am wʉt, Dios to'axil xamal tataeflaliajwam xabich kaes ommaenkpi, Dios pijaxan. ");
INSERT INTO guoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Xamal xajʉpa-emil wʉt chiekal tataeflaliajwam asan pejew, ja-am wʉt, chinax kaen aton xam chaxdusaxil nejewkolaliajwa” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Pamakan, kolenje wʉt paklon, japiliajwa chiekal najʉpatanbichaxilon. Kaen paklonliajwa chiekal tanbichaxaelon. Asan paklonliajwa chiekal nabichaxilon. Ja-aechlap-is Dios nejxasinkpi. Japi nejchaxoel wʉt platakal, chiekal nabichaxili Diosliajwa” —aech Jesús, naewʉajan wʉt pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseos, japi xabich nejxasink plata, japi jʉmtaen Jesús, jʉm-aech wʉt pejnachalaliajwa. Samata, japi bʉ'wʉajanpaeipi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Do jawʉt, Jesús jʉm-aech fariseosliajwa: “Jiw jʉm-aech wʉt xamalliajwa: ‘Fariseos xabich pachaem’ —aech wʉti, xamal xabich nejxasinkam japoxliajwa. Pelax Dios chiekal matabijt, xamal nejnejchaxoelaxan chiekal pachaema-elpox. Jiwliajwa pachaempox, japoxlax Diosliajwa chaemil” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesús pejme jʉm-aech fariseosliajwa: “Juan, jiw bautisan, pas-el wʉtfʉk, jiw naewʉajnas Moisés chajia lelpox, japox jiw naexasisfʉlaliajwa. Japi jiw naewʉajnasbej profetas chajia lelpox. Do jawʉx, Juan, jiw bautisan, pat wʉt, japon naewʉajan chimiawʉajan. Xan patx wʉtbej, naewʉajnax chimiawʉajan, Dios puexa pejjiw tato'laxaelpoxliajwa. Samata, amwʉtjel puexa jiw xabich pasasia Diosxotse” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jesús pejme jʉm-aech fariseosliajwa: “Ampathat, thatbaxobej, japoxan xabich tampoel toepaliajwa. Pe kaes pejme xabich tampoel toepaliajwa Moisés chajia lelpox, Dios pejjamechan xot. Puexa Moisés chajia lelpox, diachwʉajnakolax puexa japoxan jachiyaxael” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús pejme jʉm-aech fariseosliajwa: “Aton pijow fo'a wʉt, fit wʉton asaow, japon aton babijax is Diosliajwa, bʉ'moejt xot asaow pawis, pijwa-elpow. Dios nejchaxoelafʉl japon aton matxoelafitpowliajwa, japon aton nakiowa pijowfʉk. Kaen aton, fo'aspow fit wʉt, japon aton babijax is Diosliajwa, japowfʉk nakiowa pamal xot Diosliajwa” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús naewʉajan wʉt, ampawʉajan jʉm-aechon fariseosliajwa: “Kaen aton xabich kemaenk. Pomatkoicha naxoeipon chimia. Pomatkoichabej fiesta ispon pejbatat. Kemaeyan chimianaxaeyaxan pejjiw bʉ'xael. ");
INSERT INTO guoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jaxotbej kejilan, nabijatpon. Japon pawʉl Lázaro. Japon pobʉ'ta xabich sa'las. Pomatkoicha satat ekon kemaeyan pejbafafaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro xaesia natacholanpi kemaeyan pejmesaxot. Pomatkoicha wʉr fʉlalaena Lázaro bʉ'daeliajwas sa'la-itfachan. ");
INSERT INTO guoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Do asamatkoi wʉt, Lázaro tʉp. Japon Dios pej-ángeles bʉ'fos patʉpa papatxotse, Abrahamxotaliajwabejpon. Do jawʉx, asamatkoi, kemaeyan tʉpbej. Japon mʉthtas. ");
INSERT INTO guoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Kemaeyan tʉp wʉt, patʉpa papatxotbej japon pat, kastikaxaes xoton. Jaxotdik kemaeyan xabich nabijat. Kemaeyan natachaemse wʉt, taenpon atʉaj Abraham. Taenbejpon Lázaro, Abraham sʉapich, wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Samata, kemaeyan pinjametat jʉm-aech Abrahamliajwa: ‘Am Abraham, ¡xan nabeltaem, xabich nabijatax xot jitat! ¡Lázaro to'im min kothiyaxathosliajwa, xanlel fʉlaeliajwasik, nakaech-ia'thʉsliajwa!’ —aech kemaeyan. ");
INSERT INTO guoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham jʉmnot wʉt, jʉm-aechon: ‘Tamon, ¡xam chiekal nejchaxoelde! Xam laejam wʉt thatat, xabich nejmach nejew. Lázarolax laeja wʉt thatat, japon xabich nabijat, kejil wʉt. Pe amwʉtjel, japon xabich pachaem amxot. Xamlax amwʉtjel nabijatam. ");
INSERT INTO guoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lázaro fʉlaeyaxil xam poxadik, chʉat xabich athʉ xot, matnoch nukjik xotox. Samata, xambej ampalel julaximil’ —aech Abraham kemaeyanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Do jawʉt, kemaeyan jʉm-aech: ‘Am Abraham, xam jʉm-an. ¡To'im Lázaro taj-ax pejba poxadik japon naewʉajnaliajwa cinco takoew! Ja-aech wʉt, japibej ampalelsik fʉlaeyaxil nabijasliajwa’ —aech kemaeyan. ");
INSERT INTO guoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jawʉtbej Abraham jʉm-aech: ‘¡Japi nej naexasis Moisés chajia lelpox, puexa profetas chajia lelpoxanbej!’ —aech Abraham kemaeyanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kemaeyan jʉmnot wʉt, jʉm-aechon: ‘Am Abraham, japi naexasisaxil japoxan. Pe patʉpan, mat-echpon, pejme duk wʉt, japon natulaelt wʉt japixot, ja-aech wʉt, japi babijaxan ispoxan kofaxael. Do jawʉt, japi Dioskal naexasisaxael’ —aech kemaeyan Abrahamliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Do pejme Abraham jʉm-aech: ‘Japi naexasis-el wʉt Moisés chajia lelpox, puexa profetas chajia lelpoxanbej, japibej naexasisaxil patʉpan, mat-echpon, natulaelt wʉt japi naewʉajnaliajwas’ —aech Abraham kemaeyanliajwa” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús jʉm-aech pejnachalaliajwa: “Asan aton pijaxtat asew jiw babijaxan is wʉt, japon aton xabich kastikaxaes Dios. ");
INSERT INTO guoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jiw babijaxan isasamata japon aton pijaxtat, kaes pejme pachaemaxael japon aton pinjit ia't, jajaerat, kaechariamake'sliajwas, chafo'aliajwas mar poxadik, xabich so'nik poxadik. Ja-aech wʉt, asew jiw babijaxan isaxil japon aton pijaxtat, jelxan nanaexasiti. ");
INSERT INTO guoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Samata, ¡chiekal taem xamal nijaxtat asew jiw babijaxan isasamata! “Nejmach-aton, Dios pejjamechan naexasitpon, is wʉt babijax xamalliajwa, ¡japon aton xamal fia'e kofsliajwapon babijax ispox! Dolison, japox babijax isax koft wʉt, ¡japon aton beltaem! ");
INSERT INTO guoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Japon aton pomatkoicha babijax isfʉl wʉt xamalliajwa, asamatkoi jʉm-aech wʉton xamalliajwa: ‘Xan pejme isaxinil babijax xamalliajwa’ —aech wʉton, ¡japon aton xamal beltaem!” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apóstoles jʉm-aech Jesúsliajwa: —¡Xanal nakajachawae'e kaes Dios xanaboejaliajwan! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús jʉmnot wʉt, jʉm-aechon apóstolesliajwa: —Xamal cha-aex xanaboejam wʉt Dios, jʉm-am wʉt: ‘Diachwʉajnakolax Dios xajʉp puexa isliajwa’ —am wʉt, nejchaxoelam wʉt, xamalbej xajʉpaxaelam isliajwam xabich Dios pijaxtat. Nejxanaboejaxan xabicha-el wʉt Diosliajwa, me-ama mostazafut cha-aelfut, ja-aech wʉt, xamal jʉm-am wʉt ampanaeliajwa: ‘¡Dios ampanae nej tathinchakusas pukatutat nukaliajwa!’ —am wʉt, diachwʉajnakolax japanae, jachiyaxael —aech Jesús apóstolesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Do pejme Jesús jʉm-aech apóstolesliajwa: “Xamalxot kaen nabichan wʉt, japon to'axaelam nabichliajwa. Lulbichax kekoft wʉt, o, pak tataeflax koft wʉton, xamal jʉmchiyaximil: ‘¡Lemen! ¡Ekde tajmesaxot, xanal sʉapich xaeliajwam!’ —chiyaximil. ");
INSERT INTO guoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jʉmchiyaxaelamlax: ‘¡Naxaeyax isde xanal xaeliajwan! Xaelx wʉt, wʉajnawesaxaelam, xanal asax nawewe'p wʉt kamta nawe-isliajwam. Kaechatoelx wʉt, xamwich xaeyaxaelam’ —chiyaxaelam nabichanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Xamal graciaschiyaximil namakanliajwa, japon chiekal is wʉt to'ampoxliajwa. Japon japox chiekal isaxael, nabichan xot. ");
INSERT INTO guoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","¡Xamallap-is jachiyaxaelam! ¡Isfʉlde Dios tato'alpoxan! Isax toetam wʉt, ¡nakaewa najʉm-amde: ‘Xatis nabichwas wajpaklonliajwa. Samata, chiekal isaxaes wajpaklon naktato'alpoxan’ —chiyaxaelam nakaewaliajwa! ¡Nakaewa najʉmchiyaximil: ‘Asan aton bej nakjʉmchiyaxaelbej: “Xamal gracias-an, chiekal nabistam xot Diosliajwa” —bej nakchiyaxaelbejpon’ —nabej aeche' najutliajwa!” —aech Jesús apóstolesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús Jerusalén paklowax poxade wʉt, Galilea tʉajnʉlelbabʉ'akal folon, Samaria tʉajnʉlel. ");
INSERT INTO guoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Do jawʉt, Jesús paklowaxach pasliajwa wʉt, jaxot diez poejiw fʉlaen bʉ'kakʉlnaliajwapi Jesús. Japi puexa bʉ'xaenk leprawaxaetat. Japi mox pasaxil Jesúsxot. Samata, atʉaxach nuili. ");
INSERT INTO guoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Japi nejlat wʉt, jʉm-aechi: —Jesús, jiw chanaekabʉanan, ¡xanal nabeltaem! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Do jawʉt, Jesús japi taen wʉt, jʉm-aechon: —¡Xabʉa'de sacerdotes poxade japi taeliajwa xamal leprawaxae boejthʉlpox! —aech Jesús. Do jawʉt, japi fʉlaech wʉt sacerdotes poxade, fʉlaeyaxtat chalechkal japi puexa chiekal boejthʉls leprawaxae. Do jawʉt, chiekal pachaemlisi. ");
INSERT INTO guoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kaen japixot taen wʉt pejbʉ't chiekal wepachaemspox, jawʉt tamach kaxadinpon Jesús poxadin. Dolison Jesúslel fʉlaen wʉt, pinjametat jʉm-aechfʉldinpon Diosliajwa: “Dios, xam diachwʉajnakolax xabich pachaemam” —aechfʉldinpon. ");
INSERT INTO guoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dolison pat wʉt Jesúsxot, brixtat nuk wʉt Jesús pejwʉajnalel, sat makxabijindikon graciaschiliajwa. Japon aton, Samaria tʉajnʉpijin. ");
INSERT INTO guoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Do jawʉt, Jesús jʉm-aech asew jiwliajwa: —¿Boejthʉlspikat, bej diezbejji? ¿Amxotkat asew nueve? ");
INSERT INTO guoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ampon aton asatʉajnʉpijin. Tamach kaxadinpon Dios jʉmchiliajwa: ‘Dios, xam diachwʉajnakolax xabich pachaemam’ —chiliajwa —aech Jesús jaxot nuilpiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Do jawʉt, Jesús jʉm-aech boejthʉlsponliajwa: —¡Nande! ¡Xabʉa'de nejmach! Xam chiekal boejthʉllis, chiekal naxanaboejtam xot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Asamatkoi fariseos wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —¿Maswʉtkat tʉadusaxael Dios puexa pejjiw tato'laxaelpox? —aechi. Do jawʉt, Jesús jʉm-aech fariseosliajwa: —Dios tʉadut wʉt puexa pejjiw tato'alpox, japox xamal taeyaximil. ");
INSERT INTO guoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Samata, jiw jʉmchiyaxil: ‘Ma amxot Dios puexa pejjiw tato'al’ —chiyaxil. Jʉmchiyaxilbejpi: ‘Ma jaxotde Dios puexa pejjiw tato'al’ —chiyaxil jiw. Dios puexa pejjiw tato'alpox ma xamalxot tʉadutlisox. Pe japox tae-emil —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Xan, puexa jiw pakoewkolnan, asamatkoi puexa jiw tato'laxaelen ampathatat. Xamal xabich nejxasinkaxaelam xan nataeliajwam, xan puexa jiw tato'lax wʉt. Pe nataeyaximil, nawepas-el xotfʉk tajmatkoi jiw tato'laliajwan. ");
INSERT INTO guoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Asew jiw xamal kichachajbaxael. Jʉmchiyaxaeli: ‘¡Ma amxot Cristo!’ —chiyaxaeli. El wʉt, asew jiw xamal jʉmchiyaxael: ‘¡Ma jaxotde Cristo!’ —chiyaxaeli. Jasox jʉm-aech wʉti, ¡xamal nabej naexasis! ¡Nabej fʉlae'ebej japoxade! ");
INSERT INTO guoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chamx nakliafcha wʉt, potʉajnʉcha puexa jiw kaewʉtje taena. Xanlap-is jachiyaxaelen asamatkoi, xan, puexa jiw pakoewkolnan, pejme paskax wʉt. Kamta kaewʉtje puexa jiw nataenaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pe matxoela xan xabich nabijasaxaelen. Ampathatpijiw, amwʉtjel laelpi, japi xan nanejweslaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Noé laeja wʉt ampathatat, xabich jiw nejmamach. Samata, xaeli. Afbejpi. Nakjiyabejpi. Japamatkoiyan, ja-aech wʉt, Noé pinjiyax barkam low wʉt, chalechkal xabich iam thilnax tʉadut. Do jawʉt, sat bu'al. Puexa jiw chiekal tʉp. Jachiyaxaelbej asamatkoi, xan, puexa jiw pakoewkolnan, pasaxoekan wʉt. Jiw pomatkoicha nejmach duilafʉlaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ja-aechlap-is Lot chajia laeja wʉt. Jiw xael. Afbejpi. Wʉajtbejpi. Mowabejpi. Mʉthabejpi naxaeyaxan. Bachan iabejpi. Japi jiw pomatkoicha chiekal nejmach duilafʉl. ");
INSERT INTO guoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ja-aech wʉt, japamatkoiyan, Lot nakolt wʉt Sodoma paklowaxxot, chalechkal athʉlelsik natacholan azufre, me-ama ia'an. Pe japi jitan tamdadutpi. Japoxan ja-aech wʉt, puexa Sodoma paklowaxpijiw chiekal toejwas. ");
INSERT INTO guoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jachiyaxaelbej xan, puexa jiw pakoewkolnan, pejme chalechkal pasaxoekan wʉt. Jasoxtat jiw nejmach duilafʉlaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Japamatkoitat jiw nejchaxoelaxil pejew. Xan chalechkal paskax wʉt, jiw, pejbachanmatwʉajtat nuili, baloek wʉt, nejchaxoelaxili pejbachan leliajwa pejew jukaliajwa. Japamatkoiyantat asew jiwbej, pejlulanxot nabisti, do jawʉt, jaxot kamta japi dʉkpaxael. Kaxa naweyaxildini pejbachan poxadin pejew wʉljaesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Nejchaxoelde Lot pijow wejatispoxliajwa! (Naexasis-el wʉtow Dios jʉm-aechpox, japow domt nadofa.) ");
INSERT INTO guoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jiw isfʉl wʉt pajut nejxasinkpoxan ampathatat, japi asamatkoi tʉp wʉt, duilaxili Diosxotse. Jiw tajaxtat kofa wʉtlax pajut isasiapoxan, japi jiw asamatkoi tʉp wʉt, pomatkoicha duilaxaeli Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Diachwʉajnakolax xan jʉm-an. Chalechkal paskax wʉt, japamadoitat kolenje moejt wʉt kaecamatat, kaen bʉflaeyaxaes. Asan waelsaxaes. ");
INSERT INTO guoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Koliowje kaeyaxtat xatkiana wʉt, kaeow bʉflaeyaxaes. Asaow waelsaxaes. ");
INSERT INTO guoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kolenje aton kaelultat nabist wʉt kaeyaxtat, kaen bʉflaeyaxaes. Asan waelsaxaes.” —aech Jesús, pejnachala naewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesús pejnachala japox jʉmtaen wʉt, jawʉt wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —Tajpaklon, ¿amxotkat japox jachiyaxael? —aechi. Jesús jʉmnot wʉt, jʉm-aechon pejnachalaliajwa: —Puexa jiw chiekal matabija ampox. Choefan, tʉpon, okxot, jaxot thʉtha pasliajwa piachaxil. Xan pasaxoekan wʉt, me-ama japox, jachiyaxael —aech Jesús, naewʉajan wʉt pejnachala. Jesús japox jʉm-aech wʉt, japox jʉmchiliajwa: “Potʉajnʉcha jiw taeyaxael, Cristo fʉloek wʉt, Dios markamatkoi pat wʉt” —chiliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dolisdo', Jesús naewʉajan pejnachala kofa-elaliajwa Dios kawʉajanpox. Do jawʉt, asawʉajantat naewʉajanbejpon. ");
INSERT INTO guoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jʉm-aechon: “Paklowaxxot juez duk. Japon juez chinax Dios naexasis-el. Sitae-elbejpon Dios. Sitae-elbejpon jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Japapaklowaxxot pawis duk, pamal naetʉpspow. Asamatkoi japow fʉlaech juez poxade jʉmchiliajwa ampox. Do jawʉt, jʉm-aechow: ‘Tadaelman babijax is xanliajwa. Samata, ¡to'im soldaw japon aton kastikaliajwas!’ —aechow juezliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Japow pin-iaveces papat juezxot majt jʉm-aechpox, japox pejme jʉmchiliajwa. Pe japon juez piach is-el japow jʉm-aechpoxliajwa. Do baxael, juez nejchaxoel: ‘Xan diachwʉajnakolax Dios sitae-enil. Sitae-enilbej jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pe japow japoxtat xan nataliasfʉl. Samata, xan isaxaelen japow najʉm-aechpox kaxa pejme fʉlae-elaliajwadin xanlel, japoxtat kaes nataliasfʉla-elaliajwa’ —aech juez, nejchaxoel wʉt” —aech Jesús, naewʉajan wʉt pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Do pejme Jesús jʉm-aech, naewʉajan wʉt pejnachala: “Japon juez pachaema-el kajachawaesliajwapon japow. ");
INSERT INTO guoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dioslax jachiyaxil. Japon isaxael pachaempox kajachawaesfʉlaliajwapon pejjiw, asew babijaxan is wʉt japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Diachwʉajnakolax xan jʉm-an. Dios piachaxil kajachawaesliajwa pejjiw, asew jiw babijaxan is wʉt japiliajwa. Xan, puexa jiw pakoewkolnan, fʉloekx wʉt pejme, ¿faenaxaelenkat jiw xan nawʉajnawesfʉlpi?” —aech Jesús, naewʉajan wʉt pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Asew jiw nejchaxoelafʉl: “Xatis kaes pejme pachaems. Me-ama asew jiw, jachi-esal” —aechfʉli pajutliajwa, nejchaxoel wʉt. Jesús naewʉajan wʉt jʉm-aechon ampawʉajantat japi jiwliajwa. Do jawʉt, jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kolenje fʉlaech Dios pejtemploba poxade Dios kawʉajnaliajwa. Kaen fariseo-aton. Asan impuesto mat-omwʉljoen Roma gobiernoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo-aton nukaxtat Dios kawʉajan. Pe japon jʉm-aechpoxan Diosliajwa pachaema-el, jʉm-aech xoton: ‘Dios, xan kaes pejme pachaeman. Me-ama asew jiw, jachi-enil. Samata, xan gracias-an xamliajwa. Asew jiw is pachaema-elpoxan. Asew jiwbej kethaknik. Asew jiwbej bʉ'moejt asew watho', pijowa-elpi. Me-ama japi jiw, xan jachi-enil. Me-ama amponbej, impuesto mat-omwʉljoen gobiernoliajwa, xan jachi-enilbej. ");
INSERT INTO guoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Xanlax koleveces posemana naxae-enil xam piach kawʉajnaliajwan. Kanxpi nabistax wʉt, xan diajnax diezmʉaxtjeliajwa. Kaemʉaxt diajnax xam chaxdusliajwan. Jasox isx pomatkoicha’ —aech fariseo-aton, Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Impuesto mat-omwʉljoen gobiernoliajwa, japon atʉaxach tamach nuk jiwxot, Dios kawʉajan wʉt. Jawʉt natachaems-elbejpon athʉlelse. Natxaton. Jawʉt najut namatiafdaka wʉt, jʉm-aechon Diosliajwa: ‘Dios, xan tajut matabijtax babejnanponan. Samata, ¡xan nabeltaem!’ —aechon, Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Diachwʉajnakolax jʉm-an. Japon, impuesto mat-omwʉljoen gobiernoliajwa, japon beltaens Dios babijaxan ispoxanliajwa. Pelax fariseo-aton Dios beltae-esal, japon babijaxan ispoxanliajwa. Nejmach-aton nejchaxoel wʉt pajutliajwa: ‘Xan kaes pejme pachaeman. Me-ama asew jiw, jachi-enil’ —aech wʉton pajutliajwa, asamatkoi Dios jʉmchiyaxaeson: ‘Xam nejnejchaxoelax pachaema-el’ —chiyaxaeson Dios. Asanlax nejchaxoelpon pajutliajwa: ‘Xan kaes pejme pachaema-enil. Me-ama asew jiw, jachi-enil’ —aech wʉton pajutliajwa, japon aton asamatkoi Dios jʉmchiyaxaeson: ‘Xam nejnejchaxoelax pachaem’ —chiyaxaeson Dios” —aech Jesús naewetiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pajam yamxi bʉflaens Jesúslel, Jesús ke-osliajwa yamxi pejta'anxot. Jesús pejnachala japox taen wʉt, fiati yamxi bʉflaeni bʉflae-elaliajwa Jesúslel. Jawʉt jʉm-aechi: —¡Xamal nabej bʉflae' yamxi Jesúslel! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús japox jʉmtaen wʉt, jawʉt lapon yamxi bʉflaenpi bʉflaeliajwapi japonlel. Jawʉt jʉm-aechon pejnachalaliajwa: —¡Tapaem yamxi xanlel bʉflaeliajwas! ¡Nabej fias! Diosxotse duilpi, japi, me-ama ampi yamxi, ja-aech, kamta naexasit xoti Dios pejtato'lax. ");
INSERT INTO guoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Diachwʉajnakolax xan jʉm-an. Xamal Dios naexasitam wʉt, me-ama yamxʉlan pax naexasit, ja-am wʉt xamal, Diosxotse pasaxaelam. Naexasis-emil wʉt, pasaximil Diosxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kaen judíospaklochowxot, japon wʉajnachaemt Jesús. Jʉm-aechon: —Jiw chanaekabʉanan, xam xabich pachaemam. ¿Achaxkat xan nawewe'p isliajwan, Diosxotse dukaliajwan pomatkoicha? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús jʉmnot wʉt, jʉm-aechon: —¿Ma-aech xotkat najʉm-am: ‘Xam xabich pachaemam’ —na-amkat? Jiw xabich pachaempi ajil. Kaen Dios, japon xabich pachaem. ");
INSERT INTO guoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xam matabijtam Dios pejtato'laxan. Moisés chajia lelpox jʉm-aech: ‘¡Nabej bʉ'moejs asaow pawis, nijwa-elpow! ¡Nabej be'bej asew jiw! ¡Nabej natkowe'bej asew jiw pejew! ¡Pajilax nabej jʉm-aeche'bej asan aton tasalaliajwam, babijax is-elpon! ¡Sitaembej nej-ax, nej-en sʉapich!’ —aech Moisés chajia lelpox —aech Jesús japon atonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Do jawʉt, kemaeyan jʉm-aech: —Xam najʉm-ampox, tʉadutx naexasisliajwan, yamxʉchan wʉt. Amwʉtjel nakiowa chiekal naexasisfʉlax —aech kemaeyan. ");
INSERT INTO guoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús japox jʉmtaen wʉt, jʉm-aechon: —Xamfʉk kaeyax wewe'p isliajwam. ¡Puexa nejew mowam! Mowam wʉt, ¡japaplata chaxduim kejila! Ja-am wʉt, Dios xam chaxduiyaxael xabich pachaempoxan japonxotse. Toetam wʉt chaxduiyax kejila, do jawʉt, ¡xabʉa't xan naknanʉamsliajwam, tajnachalnaliajwambej! —aech Jesús kemaeyanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kemaeyan japox jʉmtaen wʉt, xabich nejxaejwas, xabich kemaenk xoton. Samata, owchi-elon Jesús jʉm-aechpox. ");
INSERT INTO guoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kemaeyan chijia wʉt Jesúsxot, Jesús jʉm-aech naewetiliajwa: —Xabich tampoel kemaeya pasliajwa Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Xamal chiekal matabijam camello pinjin xot, xajʉpaxil kuthatʉakre'wʉaj poxade xensliajwa. Kemaeyanliajwabej, ja-aech. Tampoel japon pasliajwa Diosxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesús jʉm-aechpox jʉmtaenpi, japi jʉm-aech Jesúsliajwa: —¿Achankatlax bʉ'weyaxaes pasliajwa Diosxotse? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús jʉm-aech: —Jiw pajut pijaxtat pasaxil Diosxotse. Pelax Dios xajʉp puexa isliajwa. Samata, Dios xajʉp jiw bʉ'weliajwa. Dios kajachawaesaxael jiw pasliajwa japonxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Do jawʉt, Pedro jʉm-aech Jesúsliajwa: —Tajpaklon, xanal puexa tejew waelax xam nakfʉlaeliajwan —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Do jawʉtbej, Jesús jʉm-aech pejnachalaliajwa: —Diachwʉajnakolax xan jʉm-an. Nejmach-aton naexasit wʉt Dios pejtato'lax, japon waelt wʉt pejba, pijow, pakoew, paxi, pax, penbej, ja-aech wʉt, japon aton Dios xabich kajachawaesaxaeson ampathatat. Asamatkoi tʉp wʉt, pasaxaelbejpon Diosxotse pomatkoicha dukaliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús la doce pejnachala, japikal tamachaliajwa. Do jawʉx, japikal wʉt, Jesús jʉm-aech: “Amwʉt Jerusalén paklowax poxaxaes. Chajia profetas lelpoxan jʉm-aech xan, puexa jiw pakoewkolnanliajwa, jachiyaxaelpox jaxotde. ");
INSERT INTO guoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Do jawʉx, xan, puexa jiw pakoewkolnan, nawiasaxael judíos-elpixot. Jawʉt nabʉ'wʉajanpaeyaxaeli. Babejjamechan najʉmchiyaxaelbejpi. Naloyaxaelbejpi. ");
INSERT INTO guoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xabich namatwʉajselsaxaelbejpi. Do jawʉx, tʉpaxaelen. Tʉpx wʉt, tres matkoi wʉt, Dios namat-esaxael pejme dukaliajwan” —aech Jesús, pajʉtliajwa jʉm-aech wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesús pejnachala japox jʉmtaen wʉt, chiekal jʉmmatabija-eli, tampoel xot japi jʉmmatabijaliajwa. Jʉmmatabija-elbejpi, ma-aech xot Jesús japox jʉm-aech. ");
INSERT INTO guoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Asamatkoi Jesús Jericó paklowax mox itwefol wʉt, wʉajna ek itliaklan nʉambabʉ'tat, jiw xaxenapi plata malech wʉljoeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Itliaklan jʉmtaen wʉt jiw pinamʉt xenaxaesox, jawʉt wʉajnachaemt wʉt, jʉm-aechon: —¿Ma-aechkat? —aech itliaklan. ");
INSERT INTO guoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Do jawʉt, xaxenapi jʉm-aechi itliaklanliajwa: —¡Malis fʉlaeyaxaen ampaleldin Jesús, Nazaret paklowaxpijin! —aechipon. ");
INSERT INTO guoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Itliaklan japox jʉmtaen wʉt, nejlat wʉt, jʉm-aechfʉllison: —Jesús, David pamon, ¡xan nabeltaem! —aechfʉlon. ");
INSERT INTO guoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jiw, matxoelafoli, bʉxfiatipon boejlach ekaliajwa. Ja-aech wʉt, japon itliaklan kaes pejme nejlasfʉl wʉt, jʉm-aechfʉlon: —David pamon, ¡xan nabeltaem! —aechfʉlon. ");
INSERT INTO guoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Do jawʉt, Jesús japox jʉmtaen wʉt, nukjaba. Jawʉt to'apon itliaklan bʉflaeliajwas japonleldin. Dolisdo', Jesús wʉajnachaemt wʉt, jʉm-aechon itliaklanliajwa: ");
INSERT INTO guoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Xam, ¿achaxasiamkat xan isliajwan xamliajwa? —aech Jesús. Itliaklan jʉmnot wʉt, jʉm-aechon: —Tajpaklon, xan pejme taesian —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús jʉm-aech: —¡Pejme taem! Xam chiekal xan naxanaboejtam xot, pejme chiekal taeyaxaelam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Do jawʉt, itliaklan chiekal wepachaems pej-itfʉt. Chiekal taenbejpon. Do jawʉt, Jesús nakfollison. Nakfol wʉt, jʉm-aechfʉlon Diosliajwa: “Dios, xam xabich pachaemam” —aechfʉlon. Puexa jiw, japox taen wʉt, japibej Diosliajwa jʉm-aechfʉl: “Dios, xam diachwʉajnakolax xabich pachaemam” —aechfʉli. ");
INSERT INTO guoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Do jawʉx, Jesús pat wʉt Jericó paklowax, follison japapaklowax xensliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Japapaklowaxxot aton duk, kemaeyan. Japon pawʉl Zaqueo. Japonbej paklon impuesto mat-omwʉljoewliajwa, Roma gobiernoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaqueo xabich taesia Jesús. Pe Zaqueo itfuxajʉpaxil taeliajwapon Jesús, japon mʉramatan xot. Taeyaxilon Jesús, xabich jiw Jesús masajiasfʉlas xot. ");
INSERT INTO guoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Samata, Zaqueo najae'a wʉajnade, Jesús fʉlaeyaxaech poxade. Jaxotde Zaqueo jul naetat taeliajwapon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús japalel fʉlaen wʉt, Jesús taen Zaqueo, athʉ naetat wʉt. Do jawʉt, Jesús jʉm-aech: —Zaqueo, ¡baloemk! Amwʉt nejbaxotaxaelen —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Do jawʉt, Zaqueo bichakal kamta balaelik. Xabich nejchachaemlaxtat Jesús chiekal bʉ'kʉlton Jesús namanaliajwa japon pejbatat. ");
INSERT INTO guoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Japi jiw japox taen wʉt, puexa nakaewa najʉm-aechi Jesúsliajwa: ‘Jesús namanaxil Zaqueo pejbatat, japon babejen xot’ —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Do jawʉx, Jesús Zaqueo pejbaxot wʉt, mesaxot ek wʉt, Zaqueo chalechkal nant. Jawʉt jʉm-aechon Jesúsliajwa: —Tajpaklon, ¡xan chiekal najʉmtaem! Puexa xan tejewpi, ma amwʉt najʉpadiajnaxaelen kejila chaxduiliajwan. Xan impuesto mat-omwʉljowx wʉt, kaes mat-omwʉljowxpi, japi pejplata pejme wewoeyaxaelen. Pe kaes cuatro veces japi wewoeyaxaelen —aech Zaqueo Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Do jawʉt, Jesús jʉm-aech: —Diachwʉajnakolax xam amwʉtjellis Abraham pamonkolnam, Dios chiekal naexasitam xot, me-ama Abraham, ja-am xot. Samata, nejbapijiw Dios beltaeyaxaes japi babijaxan ispoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Xan puexa jiw pakoewkolnan, fʉlaenx jiw wʉlwekaliajwan, bʉ'weliajwanbej, japi napelti Diosliajwa —aech Jesús Zaqueoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús Zaqueo pejbatat wʉt, jiw jʉmtaen Jesús jʉm-aechpox. Mox xotlison Jerusalén paklowaxxot, jawʉt xabich jiw nejchaxoel Jesúsliajwa: “Jesús Jerusalén paklowaxxot pa'a wʉt, Dios tato'almatkoi pasaxael. Jawʉt Jesús paklokolan nadofaxael puexa jiw tato'laliajwa ampatʉajnʉpijiw” —aech jiw, nejchaxoel wʉt Jesúsliajwa. Pefʉk Jesús paklokolan dofaxil. Samata, Jesús naewʉajan ampawʉajantat japi jiw chiekal matabijaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Do jawʉt, jʉm-aechon: “Paklowaxxot kemaeyan duk. Japon wʉllalas asatʉajnʉlel wʉlduiliajwas reyliajwapon, nawia'an wʉt puexa jiw pejtʉajnʉpijiw tato'laliajwapon. ");
INSERT INTO guoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dolison, fʉlaeliajwa wʉt asatʉajnʉ poxade, lalison diez pamakjiw fʉlaeliajwadin japonlel. Pat wʉti japonxot, kemaeyan waela kaenanʉla plata japixot. Jʉm-aechon: ‘Tajwʉlela ampaplata nawexawʉajsfʉlam wʉt, ¡mowafʉldebej kaes plata nawekanaliajwam xanliajwa! Samata, xan pejme patx wʉt, tajplata kaes pejme nawewoeyaxaelam’ —aech kemaeyan diez pamakjiwliajwa. Do jawʉt, fʉlaechlison, wʉllalas poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pe pejtʉajnʉpijiw nejweslas kemaeyan. Nejweslasbejpon japon japi pejreyliajwa. Samata, japixot asew jiw to'api kemaeyan wʉlduiyaxaes poxade, japi jʉmchiliajwa, jaxot pa'a wʉt: ‘Japon xanal nejwesla tajreyliajwa’ —chiliajwapi kemaeyanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pe nakiowa kemaeyan wʉlduws reyliajwa. Do jawʉx, japon pejme nawian pejtʉajnʉ poxadin. Pat wʉton pejbatat, to'apon pamakan wʉllalaeliajwas diez pamakjiw, japixot plata waelapipon, matabijsliajwa massʉapich plata kaenanʉla japi kana. ");
INSERT INTO guoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Do jawʉt, matxoelapatpon jʉm-aechon kemaeyanliajwa: ‘Tajpaklon, xan diez veces kaes plata kanx, xanbistax wʉt nejew plata’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kemaeyan jʉmnot wʉt, jʉm-aechon: ‘Xabich pachaem. Xam chiekal nabistam xanliajwa. Chiekal nawetataeflam kaeyaxachpox. Samata, amwʉt diez paklowaxanpijiw tato'laxaelam’ —aech kemaeyan pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Do jawʉt, asan pamakan pat wʉt, japon jʉm-aech: ‘Tajpaklon, xan cinco veces kaes plata kanx, xanbistax wʉt nejew plata’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kemaeyan jʉm-aech pamakanliajwa: ‘Amwʉt xam cinco paklowaxanpijiw tato'laxaelam’ —aech kemaeyan pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Do jawʉt, asan pamakan pat wʉt, japon jʉm-aech: ‘Tajpaklon, ama nejplata. Xan chabaentax panyoelbʉ'tat, tajlewla xot xamliajwa, nejthʉ'nikam xot, xam beltae-emil xotbej namak. Namak nabistpoxantat xam kanam’ —aech pamakan kemaeyanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kemaeyan jʉmnot wʉt, jʉm-aechon: ‘Xam xabich babejnam. Chiekal natanbich-emil. Xam najʉm-ampoxtat xam kastikaxaelen. Xam najʉm-am: “Xam nejthʉ'nikam. Xam beltae-emilbej namak. Namak nabistpoxantat xam kanam” —na-am xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Xam matabijtam wʉt xan tajkabʉanpoxan, ¿ma-aech xotkat tejew plata presta-emil bancopijiw? Xam prestam wʉt plata, amwʉtjel bancopijiw kaes plata xam tawiasaxael. Prestampoxliajwa xam kaes mosaxaelbejpi. Samata, amwʉtjel plata nawewiatam wʉt, kaes nawewiasaxaelam’ —aech kemaeyan pamakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Do jawʉt, kemaeyan jʉm-aech jaxotpiliajwa: ‘¡Kechafi'e ampon aton, plata nawechabaentpon panyoelbʉ'tat! ¡Japaplata chaxdu'e diez veces kaes plata kanpon!’ —aech kemaeyan. ");
INSERT INTO guoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jaxot nuili jʉm-aech: ‘Tajpaklon, japon xabich pin-iat. ¿Ma-aech xotkat pejme kaes chaxdusaxaelam japon?’ —aechi kemaeyanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kemaeyan jʉmnot wʉt, jʉm-aechon: ‘Diachwʉajnakolax xan jʉm-an. Tejew chiekal nawetataefʉlpon, japon kaes pejme chaxdusaxaelen. Asanlax chiekal nawetataefla-elpon tejew, kaesʉapich nawetataefʉlpox, kekusaxaeson. ");
INSERT INTO guoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pe tadaelmajiw, xan nanejweslapi japi pejreynanliajwa, ¡japi bʉflaeman ampalel xan tajwʉajnalel beliajwaspi!’ —aech rey” —aech Jesús, ampawʉajan naewʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús japox bʉxtoet wʉt Zaqueo pejbaxot, do jawʉt, Jesús fʉlaech Jerusalén paklowax poxade, pejnachala sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mox Jerusalén paklowaxxot wʉt, jaxot mʉax. Japamʉaxlelxot xabich olivonaechan nuil. Samata, japamʉax pawʉl Olivonaechanmʉax. Mox japamʉaxxot kolepaklowaxach. Kaepaklowaxach pawʉl Betfagé. Asapaklowaxach pawʉl Betania. Jesús japapaklowaxxot mox fol wʉt, wʉajna to'achon kolenje pejnachalan. ");
INSERT INTO guoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jesús japi to'aliajwa wʉt, jʉm-aechon: —¡Xabʉa'de japapaklowaxach poxade! Jaxotde pa'mach wʉt, bur jelti'san, wʉke'taspon, taeyaxaelam. Japabur chinax kaen aton tʉa-eka-esalfʉk. ¡Jolde! Joltam wʉt, ¡nawebʉflaeman japabur! ");
INSERT INTO guoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jaxotpijin xamal wʉajnachaemt wʉt, jʉm-aech wʉton: ‘¿Ma-aech xotkat xamal bur joltam?’ —aech wʉton, ¡xamal jʉm-amde japon: ‘Wajpaklon wewe'pas bur’ —amde japon aton! —aech Jesús kolenje pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Do jawʉt, japi ow-aech wʉt, fʉlaechlisi japapaklowaxach poxade. Ja-aech japox, me-ama Jesús chajia jʉm-aech. ");
INSERT INTO guoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Japi bur jolt wʉt, burpijiw wʉajnachaemtasi. Jʉmtispi: —¿Ma-aech xotkat xamal bur joltam? —tispi. ");
INSERT INTO guoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Japi jʉmnot wʉt, jʉm-aechi: —Wajpaklon wewe'pas bur —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Do jawʉt, Jesús pejnachala bur bʉflaen Jesúsleldin. Jesúsxot bʉ'pat wʉti, bur tam-owapi pejew, thʉch pejsumta-owapi. Do jawʉt, Jesús tʉa-ek. ");
INSERT INTO guoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús burtat chaflaen wʉt, wʉajna jiw pejsumta-owa jollisi nʉamtat ba'aliajwa Jesús chaflaeyaxaenlel. (Jasox isi Jesús chiekal bʉ'kʉlaliajwapi, xabich sitaen xoti Jesús.) ");
INSERT INTO guoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jesús mox fol Olivonaechanmʉaxxot. Jaxot nʉamsik mʉaxlelasik, fʉlaeliajwa Jerusalén paklowax poxade. Jesús chaflae-el wʉt japoxadik, puexa jiw tʉadut nejlasfʉlaliajwa, nejchachaemil xoti. Nejlasfʉl wʉt, jʉm-aechfʉli Diosliajwa: “¡Xam xabich pachaemam!” —aechfʉlisi. Jasox xabich jiw jʉm-aechfʉl, majt chajia taen xoti, Jesús koechaxan is wʉt Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jiw jʉm-aechfʉlbej Jesúsliajwa: —Ampon, fʉlaenpon Dios pijaxtat, xabich pachaempon. Japon fʉlaen reyliajwa, xatis naktato'laliajwa. Wʉajanjilaxtat puexa jiw duilaxael athʉxotse Dios pijaxtat. Dios, athʉpijin, japon xabich pachaem —aechfʉl xabich jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jiwxot, jaxot kaesʉapich fariseos. Japi fariseos palala xot, jʉm-aechi Jesúsliajwa: —Jiw chanaekabʉanan, ¡ampi jiw, nejnachala, bʉxfia'e jʉm-aechfʉlpoxan! —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan jʉm-an. Japi jiw bʉxfiatx wʉt boejlachliajwa, ia'lax nejlasfʉlaxael japi jiw jʉm-aechfʉlpoxanliajwa —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús Jerusalén paklowaxxot mox pat wʉt, paklowax taen wʉt, nowpon Jerusalén paklowaxpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jesús now wʉt, jʉm-aechon: “Xan xabich nejxasinkax Jerusalén paklowaxpijiw tajpasax matabijaliajwa. Xan paskax japi jiw bʉ'weliajwan xan tajaxtat, chiekal pachaemaliajwapi Diosliajwa. Pe japi chiekal matabija-el. Xan nabʉ'kula-elbejpi. Samata, amwʉtjel japox chiekal toeplisox japi xan namatabijsliajwapox. ");
INSERT INTO guoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Babejmatkoiyan tapasfʉlaxaesi. Padaelmajiw chakipasaxaesi. Chamasajoeyaxaesbejpi. Chinax kaen aton japapaklowaxxot weyaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ja-aech wʉt, Jerusalén paklowaxpijiw puexa chiekal toesaxaes. Pejbachan wetʉkaxaesbejpi. Chinax kaet ia't namanaxil nakae-ia'tmatwʉajtat. Jasox wejachiyaxaesi, xan namatabijs-el xoti, xan patxponan jiw bʉ'weliajwan” —aech Jesús, now wʉt Jerusalén paklowaxpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús Jerusalén paklowax pat wʉt, lowpon Dios pejtemploba. Jaxot Jesús taen mowapi. Taen wʉton japi Dios pejtemplobatat, nejthʉ'axtat to'apon choef mowapi nakolaliajwa Dios pejtemplobatat. ");
INSERT INTO guoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús jʉm-aech japiliajwa: —Dios pejjamechan, chajia lelspox, jʉm-aech Dios jʉm-aechpox pejtemplobaliajwa: ‘Tajba kawʉajnaba wʉlxael, jiw xan nakawʉajnaliajwa’ —aech Dios jʉm-aechpox pejtemplobaliajwa. Xamallax Dios pejtemploba kethaka pejba padofam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kaematkoisfʉl Jesús naewʉajan Dios pejtemplobatat. Pe sacerdotespaklochow, judíos chanaekabʉanapibej, asew judíospaklochowbej, japi nakaewa najʉm-aech: “¿Machiyaxaeskat Jesús boesaliajwas?” —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pelax japi matabija-el, achaxtat pachaem Jesús boesaliajwas, puexa jiw chiekal naewet xot Jesús naewʉajanpoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Asamatkoi Dios pejtemplobaxot Jesús jiw naewʉajan chimiawʉajan, jiw bʉ'weyaxaesox. Ja-aech wʉt, sacerdotespaklochow, judíos chanaekabʉanapi, ancianosbej, mox soepapi Jesúsxot. ");
INSERT INTO guoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Do jawʉt, jʉm-aechi: —¡Xanal najʉm-amde ampox! ¿Achan pijaxtatkat xam to'am choef mowapi nakolaliajwa Dios pejtemplobaxot? ¿Achankat xam to'a japox isliajwam? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús jʉmnot wʉt, jʉm-aechon japiliajwa: —Xan-is xamal asax wʉajnachaemsaxaelen. ¡Pe xamal majt najʉmno'e! ");
INSERT INTO guoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Achankat Juan to'as jiw bautisaliajwa? ¿Dioskaton to'as? O, ¿jiwkaton to'as? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jesús japox jʉm-aech wʉt, japi nakaewa najʉm-aechna: “Jʉmnoch wʉt, ‘Juan Dios to'as jiw bautisafʉlaliajwa’ —tis wʉt, Jesús nakjʉmchiyaxael: ‘¿Ma-aech xotkat xamal Juan jʉm-aechpoxan naexasis-emil?’ —nakchiyaxael xatis Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jʉmtis wʉtlax: ‘Juan jiwkal to'as jiw bautisafʉlaliajwa’ —tis wʉt, puexa jiw xatis ia'tat nakdadaepaxael nakmatkaejabaliajwa, palalaxael xoti xatisliajwa. Jasox isaxaeli xatisliajwa, puexa jiw jʉm-aech xot Juanliajwa: ‘Diachwʉajnakolax Juan, jiw bautisan, jʉm-aech Dios pijaxtat’ —aech xot jiw Juanliajwa” —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Samata, japi jʉmnot wʉt, jʉm-aechi Jesúsliajwa: —Jalape. Xanal matabija-enil, achan Juan to'as jiw bautisaliajwa —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Do jawʉt, Jesús jʉm-aech japiliajwa: —Xan-is xamal jʉmchiyaxinil, achan pijaxtat xan japox isx —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús pejme jʉm-aech, jiw naewʉajan wʉt ampawʉajan: “Aton mʉtha uva. Do jawʉx, uvalulpijin asew jiw wʉljaet, japi jiw piach tataeflaliajwa japon pej-uvalul, japon ajil wʉt. Japi bʉ'pat wʉt, jʉm-aechon: ‘Xan piach kijlaxaelen asatʉajnʉlel atʉaj. Xan tajwʉlela tajlul chiekal xamal nawetataeflaxaelam’ —aech uvalulpijin. Do jawʉx, chijialison japatʉajnʉ poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Do baxael, uva foi wʉt, uvalulpijin kaen pamakan to'a pej-uvalul wetataeflaspi poxadin, wewʉljaesliajwaspon uva. Uvalul tataefʉlpi jaelti uvalulpijin pamakan. Jawʉt baeson. Do jawʉt, to'ason ke-etat nawiasliajwa pejpaklon poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Do jawʉx, uvalulpijin to'a asan pamakan. Uvalul tataefʉlpi babejjamechan jʉm-aech japonliajwa. Do jawʉt, japonbej baes. Ke-etat nawiasax to'ason pejpaklon poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Do pejme jawʉt, uvalulpijin asan pamakan pejme to'a. Japonbej baes wʉt, xakolbalas. Do jawʉt, uvalul tathoetlel fo'ason. ");
INSERT INTO guoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Dolisdo', uvalulpijin nejchaxoel wʉt, jʉm-aechon: ‘¿Machiyaxaelenkat xan? ¡Aa, xan matabijtax isaxaelenpox! Taxʉlan to'axaelen, xabich nejxasinkaxpon. Japi bej nawesitaeyaxaelbejpi taxʉlan’ —aech uvalulpijin, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Do jawʉt, paxʉlan to'alison japi poxade. Uvalul tataefʉlpi taen wʉti, japon atʉaj fʉlaen wʉt, nakaewa najʉm-aechi: ‘¡Tae'nik uvalulpijin paxʉlan! Asamatkoi pax tʉp wʉt, japon pijax wʉlxael ampa-uvalul. Samata, xatis amwʉt ampon boesaxaes, uvalul wajaxkal namanaliajwa’ —na-aechi nakaewa uvalul tataefʉlpi. ");
INSERT INTO guoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Do jawʉt, paxʉlan pat wʉt uvalulxot, jaeltason. Jawʉt juchpon uvalulxot. Do jawʉx, boesaspon” —aech Jesús jiw naewetiliajwa. Do jawʉt, Jesús wʉajnachaemt jiw naeweti japawʉajan. Jʉm-aechon: “¿Achaxkat xamal nejchaxoelam uvalulpijinliajwa? ¿Achaxkat japon isaxael uvalul wetataeflaspiliajwa? ");
INSERT INTO guoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Uvalulpijin chakifʉlaeyaxael beliajwapon uvalul wetataeflaspi. Do pejme asew tataeflax to'axaelon” —aech Jesús. Naeweti matabija wʉt Jesús jʉm-aechpox, japi jʉm-aech Jesúsliajwa: —¡Dios jasox nej is-ele' xanalliajwa! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús chiekal natachaemt wʉt, jʉm-aechon japi jiwliajwa: —Xamal chiekal matabijam, Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox xanliajwa: ‘Jiw ia'ba is wʉt, kaet ia'tliajwa nakaewa najʉm-aechi: “Ampot ia't chaemil” —na-aechi nakaewa. Samata, mastaenipot. Do jawʉx, asan aton japot ia' fit wʉt, jʉm-aechon: “Ampot ia't, puexa ia'xot kaes pejme pachaem tʉakso'pijtaliajwa, ba chiekal mamnikaliajwa” —aechon’ —aech Dios pejjamechan xanliajwa, chajia lelspox. ");
INSERT INTO guoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jiw fiap wʉt kaet ia't pinjitxot, xabich naxthuya wʉt, naxkolaxaelbejpi. Pelax kaet ia't, pinjit, athʉlelsik jiw matwʉajasik jopik wʉt, japi jiw matkaeyaxaes ia't. Jasoxtat xamal xan nanaexasis-emilpim xabich nabijasaxaelam, xan nanejwesla xot. That toep wʉt, Dios xamal pomatkoicha kastikaxael infiernoxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesús japox jʉm-aech wʉt, sacerdotespaklochow, judíos chanaekabʉanapibej, nejchaxoel: “Jesús japawʉajan jʉm-aech wʉt, nakjʉm-aechon xatisliajwa” —aechi, nejchaxoel wʉt. Samata, jawʉt japi jaelsasiapi Jesús. Pe jaels-eli Jesús, pejlewla xoti jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Asamatkoi sacerdotespaklochow, judíos chanaekabʉanapibej, to'api jiw maliach tataeflaliajwapi Jesús. Japi pat wʉt Jesúsxot, me-ama pachaem wʉt, kabʉan-aechi. Samata, japi chiekal naewet, Jesús jʉm-aech wʉt babejjamechan gobiernoliajwa, jawʉt tasalaliajwapi Jesús gobernador pejwʉajnalel, Jesús kastikaliajwasbej. ");
INSERT INTO guoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Samata, japi xapaejsliajwa wʉt, jʉm-aechi Jesúsliajwa: —Jiw chanaekabʉanan, xanal matabijtax xam jiw naewʉajnampox diachwʉajnakolax. Kejila naewʉajnam wʉt, chiekal naewʉajnam. Najʉpanaewʉajnam kejila, kemaenkpibej. Xam naewʉajnam japi jiw chiekal duilaliajwa, me-ama Dios nejxasink. ");
INSERT INTO guoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Samata, xanal chiekal matabijasian. ¿Pachaemkat xanal mosliajwan impuesto Roma tʉajnʉpijiw tato'lan? —aechi, xapaejt wʉt Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pe Jesús matabijt japi xapaejtaspox. Samata, jʉm-aechon: ");
INSERT INTO guoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—¡Kaekafef nawexalaeman na-itpaeliajwam! —aech Jesús. Jawʉt kaekafef, pawʉlox denario, xalaenlisi Jesúslel. Jawʉt Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Achan pejxu-aelkat ampakafeftat? ¿Achan pejwʉlbejkat ama lelspox ampakafeftat? —aech Jesús japiliajwa. Japi jʉmnot wʉt, jʉm-aechi: —Roma tʉajnʉpijiw tato'lan, japon pejxu-ael, japon pejwʉlbej —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Do jawʉt, Jesús jʉm-aech: —¡Roma tʉajnʉpijiw tato'lan, japon pejewpi mo'e, impuesto motam wʉt! Pe Dios pejewpi, japox xatis Dios xanaboejaspoxan, wajnejxasiyaxbej, japoxanlap xatis Dios chaxduiyaxaes —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesús chiekal jʉmnot xot, Jesús bʉ'wʉajanjil jiw pejwʉajnalel tasalaliajwas. Samata, maliach tataeflaspi asbʉan jʉmch boejlach nejchaxoelanuili. ");
INSERT INTO guoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduceos asanejchaxoelaxan. Japi jʉm-aech: “Jiw tʉp wʉt, kaelel chiekal napelt. Asamatkoi mat-eyaxisal pejme duilaliajwa” —aechi asbʉan jʉmch. Do asamatkoi wʉt, asew saduceos pati Jesús taeliajwa. Jesúsxot wʉt, kaen japixot ampawʉajan jʉm-aech Jesús jʉmtaeliajwa: ");
INSERT INTO guoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Jiw chanaekabʉanan, Moisés chajia lelpox jʉm-aech: ‘Aton, pijowpon, japon aton tʉp wʉt naxʉwla-elaxtat pijowxot, tʉpon pakoewan naman wʉt, japon japow fisaxael naxʉwlaliajwapon japowxot, pakoewan tʉponliajwa’ —aech Moisés chajia lelpox. ");
INSERT INTO guoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kaen aton seis pakoew. Matxoelapijin pawis fit. Pe baxael, japon tʉp xijilaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Do jawʉt, wʉchakalpijin, japow fit, pakoewan naetʉpow. Pe baxael, japonbej tʉp xijilaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Do jawʉtbej, trespijin, japow fit. Japow fit wʉton, japonbej baxael tʉp xijilaxtat. Do jawʉx, cuatro namapi, japibej jasoxtat natoet nakjiyaxtat japowtat. Pe chinax kaen japowxot naxʉwla-el. ");
INSERT INTO guoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Do baxaelbej, japowbej taxdukakolaxtat tʉp. ");
INSERT INTO guoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Puexa japi poejiw nakjiya japowtat. Baxael, tʉpi mat-eyaxaes wʉt, sietepixot, ¿achankat pijowaxael japow? —aech saduceos. ");
INSERT INTO guoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús jʉmnot wʉt, jʉm-aechon: —Ampathatat poejiw watho' not. ");
INSERT INTO guoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dios makanochpi pasliajwa japonxotse, jaxotse pomatkoicha duilaxaeli. Japi tʉp wʉt ampathatat, asamatkoi mat-eyaxaesi pejme duilaliajwa Diosxotse. Mat-eyaxaes poejiw, watho'bej. Pe japi pejme nakjiyaxil. ");
INSERT INTO guoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Diosxotse wʉt, japi pejme tʉpaxil. Me-ama Dios pej-ángeles, jachiyaxaeli. Dios taen wʉt japi jiw, me-ama paxi wʉt, jachiyaxaelon, mat-ia xoton japi pejme duilaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés chajia lel Dios jʉm-aechpox tamdadusaxtat boejtachnaechxot. Samata, Moisés lelpoxtat matabijas tʉpi mat-esaxaespox pejme duilaliajwa. Moisés lelpoxtat jʉm-aech Dios jʉm-aechpox: ‘Xanfʉk Abraham, Isaac, Jacobbej, japi pejDiosnan’ —aech Dios. Samata, xatis chiekal matabijas, baxael tʉps wʉt pejme duilaxaespox. ");
INSERT INTO guoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Xatis chiekal matabijas chajia tʉpi, japi napels-el. Samata, Abraham, Isaac, Jacobbej, japi amwʉtjel nakiowa duilafʉl Diosxotse. Puexa Dios pejjiwspis tʉps wʉt ampathatat, duilafʉlaxaes Diosxotse —aech Jesús saduceosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Asew, judíos chanaekabʉanapi, jʉm-aechi Jesúsliajwa: —Jiw chanaekabʉanan, xam chiekal jʉmnotam saduceos —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Do jawʉt, saduceos padala pejme wʉajnachaemsliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús wʉajnachaemt wʉt, jʉm-aechon judíos chanaekabʉanapiliajwa: —¿Ma-aech xotkat jiw matabija-el Cristo Dios paxʉlan? Diachwʉajnakolax jiw jʉm-aech wʉt, jʉm-aechi Cristoliajwa: ‘Cristo nalaelt wʉt, japon rey David pamonaxael’ —aechi. Pe Cristo rey David pamonkala-el. Pe Cristo asanbej. ");
INSERT INTO guoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David chajia lel wʉt Salmosfʉtat, jawʉt pajut jʉm-aechon Cristoliajwa: ‘Dios jʉm-aech wʉt tajpaklonliajwa, jʉm-aechon: “¡Ekde tajpoklalel jiw tato'laliajwam, xan sʉapich! ");
INSERT INTO guoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","¡Ekde jaxot, hasta xan malechaxaelen wʉt nadaelmajiw! Malechax wʉt, japi jiw xam namakjiwaxael tato'laliajwam” —aech Dios tajpaklonliajwa’ —aech rey David, chajia lel wʉt Cristoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David chajia jʉm-aech Cristoliajwa: ‘Tajpaklon’ —aechon. Samata, Cristo diachwʉajnakolax David pamonkala-elon. Pe pejpaklonbejpon —aech Jesús, pajut najʉm-aech wʉt, jiw chiekal matabijaliajwa japon Dios paxʉlanpon. ");
INSERT INTO guoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Puexa jiw jaxot naewet wʉt, Jesús jʉm-aech pejnachalaliajwa: ");
INSERT INTO guoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“¡Chiekal taem! Me-ama judíos chanaekabʉanapi, ¡xamal nabej ja-aeche'! Japi nejxasink pakchowaxan, naxoeyaxan, jiw chiekal sitaeliajwas. Nejxasinkbejpi jiw moichiliajwas xabich sitaeyaxtat, paklowaxthialaxanxot xabʉ'kʉlas wʉt. Judíos naewʉajnabachanxot wʉt, wʉajna tʉachalakaxan nuili paklochow kaes sitaenspiliajwa, japoxantat japi chalak puexa jiw taeliajwas. Ja-aechbejpi, fiestaxot wʉt. Nejxasink chalakaliajwa kaes pachaempoxantat. ");
INSERT INTO guoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Japibej naekichachajba watho', pamaljiw naetʉpspi, natkowaliajwa japi watho' pejew. Do jawʉx, judíos naewʉajnaba lowpi Dios piach kawʉajnaliajwa, asew jiw jʉmchiliajwasi: ‘Diachwʉajnakolax ampi xabich pachaem’ —chiliajwasi. Samata, Dios xabich kastikaxaesi” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús asamatkoi Dios pejtemplobaxot wʉt, jawʉt taenpon kemaeya, plata jeyaxxot jia wʉti plata Dios pej-ofrendaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jaxot taenbejpon pamal naetʉpspow, japow jek wʉt kolekafefaex. Japakafefaex, cobrefaex, xabich omjillejen. Japow xabich kejil. ");
INSERT INTO guoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Diachwʉajnakolax xan jʉm-an. Ampow pawis, pamal naetʉpspow, kejilpow. Pe Dios kaes pejme nejchachaemil japow pej-ofrendaliajwa. Japow, me-ama kaes pejme chaxdut wʉt, ja-aechow Diosliajwa. Me-ama puexa asew jiw, chaxduw wʉt ofrenda, jachi-el japow. ");
INSERT INTO guoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Puexa asew jiw chaxduw ofrenda wenamaspoxantat. Japowlax wewe'paspoxanliajwa, puexa chaxdutow Diosliajwa —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dios pejtemplobaxot tathoetlel wʉt, asew Jesús pejnachala jʉm-aechi Dios pejtemplobaliajwa: “¡Tae'nik ia', xabich chimiatan, japitat Dios pejtemploba chapachaemaliajwa! ¡Tae'nikbej asaxan asew judíos chajia chaxduwpi Dios pej-ofrendaliajwa, chiekal chapachaemaliajwa Dios pejtemploba!” —aech Jesús pejnachala. Do jawʉt, Jesús jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Asamatkoi asatʉajnʉpijiw Dios pejtemploba tʉkaxaeli. Puexa taenampi, puexa japoxan chiekal toesaxaes. Chinax kaet, ia't, namanaxil nakae-ia'tmatwʉajtat —aech Jesús, jʉm-aech wʉt pejnachalaliajwa japoxan jachiyaxaelpox. ");
INSERT INTO guoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesús wʉajnachaemtas wʉt pejnachala, jʉm-aechi: —Jiw chanaekabʉanan, ¿maswʉtkat japox jachiyaxael, xam jʉm-ampox Dios pejtemplobaliajwa? Mox pawʉajna wʉt, ¿achaxkat taeyaxaes? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús jʉmnot wʉt, jʉm-aechon: —¡Chiekal taem, asamatkoi asew jiw xamal naekichachajbasamata! Xabich jiw fʉlaeyaxaen. Japi pajut kaenanʉla najʉmchiyaxael: ‘Xan Cristowan. Mox pawʉajnalisox ampathat toepaliajwa’ —chiyaxaeli. Japi japoxan jʉm-aech wʉt, xamal nakfʉlaeyaximil japi jiw. ");
INSERT INTO guoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Asamatkoi xamal wʉltaenam wʉtbej nabewʉajan asatʉajnʉchanxot, ¡xamal nabej nejlewle'! Japoxan majt jachiyaxael, ampathat toepax mox pawʉajna wʉt. Japoxan ja-aech wʉt, that toepaxilfʉk —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Do jawʉt, pejme jʉm-aechon: “That toepaliajwa wʉt, xabichaxael nabewʉajan. Nakaetʉajnʉpijiw nabeyaxael. Japoxan majt xabich jachisfʉlaxael asatʉajnʉchanlel. Kaetʉajnʉpijiw nabeyaxaelbej, asatʉajnʉpijiw sʉapich. Japoxan majt xabich jachisfʉlaxael asatʉajnʉchanlel. ");
INSERT INTO guoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Asatʉajnʉchanlel xabich sat najaesaxael. Najaesaxael wʉt, xabich chaemilaxael. Asatʉajnʉchanlel naxaeyaxan piach ajilaxaelbej. Xabichaxaelbej waxae. Jiw taeyaxaelbej, thatbaxo xabich nachoela wʉt. Do jawʉt, xabich jiw belwaxael” —aech Jesús, japoxanliajwa jʉm-aech wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Do pejme Jesús jʉm-aech pejnachalaliajwa: “Japoxan wʉajna, asew jiw xamal jaelaxael, tajnachalwam xot. Japi babijaxan is wʉt xamalliajwa, xamal nabijasaxaelam. Xamal bʉflaeyaxaelbejpi judíos naewʉajnabachan poxade, jaxotde tasalaliajwapi xamal. Xamal jeyaxaelbejpi jiw jebatat. Asew jiw xamal bʉflaeyaxaelbej paklochow poxade. Samata, asatʉajnʉchanpijiw tato'alpi, gobernadoresbej, japi pejwʉajnalel xamal nuilaxaelam, tajnachalwam xot. ");
INSERT INTO guoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Japoxan ja-aech wʉt, xamalliajwa pachaemaxael japi jiw chapaeliajwam tajwʉajan. ");
INSERT INTO guoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Xamal jaxota-emil wʉtfʉk, ¡xabich nabej nejchaxoele' jʉmchiyaxaelampoxan, jʉmnosliajwam wʉt japi tasalapoxan, japi pejwʉajnalelam wʉt! ");
INSERT INTO guoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Do jawʉt, Dios kajachawaesaxael xamal chiekal jʉmnosliajwam. Ja-aech wʉt, kaen aton japixot matabijaxil xamal jʉmnosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nej-axjiw xamal woeyaxael paklochowxot. Nej-axjiwa-el wʉt, nej-enjiwaxael. Nej-enjiwa-el wʉt, nakoewaxael. Nakoewa-el wʉt, asewaxael nejjiwpi. Nejjiwa-el wʉt, nejnachalaxael. Ja-aech wʉt, asew xamalxot beyaxaes. ");
INSERT INTO guoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Puexa jiw, Dios naexasis-elpi, japi xamal nejweslaxael, tajnachalwam xot. ");
INSERT INTO guoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pe chinax xamalxot kaen tabejsaxisal, Dios tapae-el wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Xamal kofa-emil wʉt nejxanaboejaxan Diosliajwa, ja-am wʉt, Dios xamal bʉ'weyaxael duilaliajwam pomatkoicha Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Asatʉajnʉchanpijiw, soldaw, chakipach wʉt judíos, Jerusalén paklowax masajoeya wʉtbejpi, jawʉt matabijaxaelam mox pawʉajnapox japapaklowax toesliajwas. ");
INSERT INTO guoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Judea tʉajnʉpijiw japox taen wʉt, ¡japi puexa nej dʉkpe pinamʉaxan poxade! Asew jiw, Jerusalén paklowaxpijiw, japox taen wʉt, ¡paklowaxxot nej nakole dʉkpaliajwa atʉaj! Asew jiw, pejlulanxot nabisti, ¡kaxa paklowaxlel nej nawe-elepi! Do jaxot, ¡japi kaelel atʉaj nej dʉkpe! ");
INSERT INTO guoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Japamatkoiyan japox jachiyaxael, kastikamatkoiyan wʉt. Me-ama Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox, diachwʉajnakolax japox jachiyaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Japamatkoiyan watho', moejowpi, watho'bej, paxi mitan miati, xabich nabijasaxael. Jiwbej, ampatʉajnʉpijiw, xabich nabijasaxael, kastikaxaes xoti Dios. ");
INSERT INTO guoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Asew japixot beyaxaes espadatat. Asew mʉaxmatakuiyaxaes. Do jawʉx, bʉflaeyaxaes asatʉajnʉchanlel. Ja-aech wʉt, asatʉajnʉchanpijiw pasaxael Jerusalén paklowaxxotdin. Do jawʉt, Jerusalén paklowaxpijiw tato'laxaes asatʉajnʉpijiw. Japox jachiyaxael, hasta Dios markamatkoi pat wʉt. Japamatkoitat Jerusalén paklowaxpijiw kofaxaes tato'laspox asatʉajnʉpijiw” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús pejme jʉm-aech pejnachalaliajwa: “Xan pasliajwan wʉt, xabich chaemilaxael thatbaxo, juimt matkoipijin, juimt madoipijinbej, ithaejbej. Mar xabich thiachoenkaxael, truxan xabich pinjiyaxan wʉt. Samata, jiw matabijaxil, achax nejchaxoelaxael, xabich belwaxael xoti. ");
INSERT INTO guoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jiw tʉpbalaxael pejlewt, nejchaxoel wʉti ampathatliajwa, jachiyaxaelpoxliajwa. Do pejme nejlialaxaeli. Puexa thatbaxotatpi, me-ama thatbaxo choelas wʉt, jasox jiw taeyaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Do jawʉt, xan, puexa jiw pakoewkolnan, itloejentat pasaxoekan wʉt, puexa jiw nataeyaxael, fʉloekx wʉt. Jawʉt puexa jiw tato'laxaelen. Itliakaxaelenbej tajut Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Japoxan taenam wʉt, xan chajia jʉm-anpoxan, ¡xamal xabich nejchachaemilde! ¡Xan nanaexasisfʉlde, mox xotlisox matkoi xamal bʉ'weliajwan!” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús pejme jʉm-aech wʉajantat pejnachalaliajwa: “¡Chiekal nejchaxoelde, taenam wʉt higonae, o, nejmachnaechanbej! ");
INSERT INTO guoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Waech mox pawʉajna wʉt, japanaechan pajel-ʉaf nakola. Xamal japoxan taenam wʉt, jʉm-am: ‘Waechlis mox pawʉajna’ —am xamal. ");
INSERT INTO guoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jasoxtatbej, xamal matabijaxaelam mox pawʉajnapox Dios puexa pejjiw tato'laxaelpox ampathatat. ");
INSERT INTO guoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Diachwʉajnakolax xan jʉm-an. Puexa ampoxan xan jʉm-anpoxan, diachwʉajnakolax japoxan jachiyaxael. Japoxan asew jiw taeyaxaelfʉk, ampathatat laelpi. ");
INSERT INTO guoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Thatbaxo, ampathatbej, toepaxael. Pelax tajjamechan toepaxil. Chajia jʉm-anpoxan, diachwʉajnakolax japoxan jachiyaxael. ");
INSERT INTO guoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“¡Chiekal taem! ¡Nabej nejchaxoele' babijaxan isaxan, saxa feyaxanbej! ¡Nabej nejchaxoele'bej ampathatpijaxan! Japoxan nejchaxoelafʉlam wʉt, xan chalechkal paskax wʉt, xamal laepaxaelam Dios naexasis-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chalechkal paskax wʉt, xabich jiw nejmamachaxaeli nawʉajnawes-elaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Samata, ¡xamal duilafʉlde xan naxanaboejampoxtat! ¡Pomatkoicha Dios kawʉajnafʉldebej nejnejchaxoelaxantat mamnikaliajwam Diosliajwa, boejtaliasfʉlaliajwam nabijasmatkoi pat wʉt! Japoxan boejtaliatam wʉt, xamal napelsaximil, tajwʉajnalel nuilam wʉt, xan, puexa jiw pakoewkolnan, pejme patx wʉt” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kaematkoisfʉl Jesús naewʉajan Dios pejtemplobaxot. Madoi wʉt, Olivonaechanmʉaxxot moejton. ");
INSERT INTO guoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pomatkoicha, kandiawasap, puexa jiw fʉlalaecha Dios pejtemploba poxade jʉmtaeliajwapi Jesús naewʉajanpoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mox pawʉajna Pascuafiestaliajwa. Japamatkoiyan jiw xael pan levadurajila. ");
INSERT INTO guoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Japamatkoiyan sacerdotespaklochow, judíos chanaekabʉanapibej, natameja wʉt, nakaewa najʉm-aechi: “¿Machiyaxaeskat Jesús boesaliajwas?” —na-aechi nakaewa. Pe Jesús boesaxisalfʉk, japi pejlewla xoti jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Do jawʉt, Satanás low Judas pejmatpʉatxot. Japon Judas Iscariote, kaen Jesús pejnachalan. Japontat doce. ");
INSERT INTO guoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Do jawʉt, Judas fʉlaech sacerdotespaklochow poxade, Dios pejtemploba wetipaklochow poxadebej. Jaxotde pa'a wʉt, jʉm-aechon: —Xamal nejxasinkam wʉt, xan wiasaxaelen Jesús xamalxot —aech Judas. ");
INSERT INTO guoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Paklochow japox jʉmtaen wʉt, xabich nejchachaemili. Do jawʉt, jʉm-aechi Judasliajwa: —Xanalxot Jesús wiatam wʉt, xanal mosaxaelen plata —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Do jawʉt, Judas ow-aech. Samata, wʉajnawetlison pachaemmatkoi, jiw ajil wʉt Jesúsxot, japamatkoitat wiasliajwapon Jesús paklochowxot. ");
INSERT INTO guoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dolisdo', pascuafiestalisox. Japafiestatat judíos xael pan levadurajila. Japapascuafiesta wʉt, jiw xʉa'at ovejas jelti's. ");
INSERT INTO guoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Do jawʉt, Jesús to'a wʉt Pedro, Juan sʉapich, jʉm-aechon: —¡Xabʉa'de naxaeyax isliajwam, ovejawi xaeliajwas Pascuafiestatat! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Japi wʉajnachaemt wʉt, jʉm-aechi: —¿Amxotkat xanal naxaeyax isaxaelen Pascuafiesta nabʉ'xaeliajwam? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús jʉmnot wʉt, jʉm-aechon: —Jerusalén paklowax patam wʉt, kaen aton taeyaxaelam, mint xafol wʉton kʉarnatat. ¡Japon aton fʉlfʉlaem, ba lech poxade! ");
INSERT INTO guoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","¡Japabapijin jʉm-amo: ‘Jiw chanaekabʉanan jʉm-aech: “¿Ampabatutatkat xan tajnachala bʉ'xaeyaxaelen Pascuafiestanaxaeyax?” —aech jiw chanaekabʉanan’ —amo bapijin! ");
INSERT INTO guoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Japon bapijin xamal itpaeyaxael athʉ pejbatupijax, pinjiyax. Wʉajna chajia chiekal chaemtas. Jaxotse naxaeyax isaxaelam xatisliajwa —aech Jesús, pejnachala to'a wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Do jawʉt, pejnachala fʉlaechlisi Jerusalén paklowax poxade. Pat wʉti, puexa, me-ama Jesús chajia jʉm-aech, ja-aechlisox. Samata, jaxotse naxaeyax ispi Pascuafiestanaxaeyax xaeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Xaeliajwa wʉt, Jesús, pejnachala sʉapich, japi apóstolespi, chalaklisi mesaxot. ");
INSERT INTO guoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Xan xabich nejxasinkax, xamal sʉapich, xaeliajwan ampafiestanaxaeyax xan tʉpax wʉajna. ");
INSERT INTO guoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Diachwʉajnakolax xan jʉm-an. Xan pejme xaeyaxinil Pascuafiestanaxaeyax ampathatat. Asamatkoi, Dios xamal bʉ'wia wʉt, jawʉt pejme xaeyaxaelen, xamal sʉapich, Pascuafiestanaxaeyax Diosxotse —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Do jawʉt, Jesús copa chafit puexa pejnachala fiaflaliajwa. Jawʉt Jesús gracias-aech wʉt Diosliajwa, jʉm-aechon: —¡Maj ampot! ¡Kaenanʉla xamal fiafʉlde! ");
INSERT INTO guoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Diachwʉajnakolax xan jʉm-an. Pejme feyaxinil vino ampathatat. Hasta Dios puexa pejjiw tato'al wʉt, jawʉt pejme vino feyaxaelen —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Do jawʉt, Jesús panax fit wʉt, Dios gracias-aech wʉton Diosliajwa, panax jalkafʉl pejnachala kexadiajsliajwa. Chaxduw wʉt pejnachala xaeliajwa, Jesús jʉm-aech: —Ampapan itpaei, me-ama tajwit, xan tʉpaxaelen xot xamalliajwa. Asamatkoi, pan xaelam wʉt, xan nanejchafaekaliajwam —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Xaeyax kaechatoel wʉt, Jesús pejme copa chafit wʉt, jʉm-aechon: —Ampavino itpaei, me-ama tajjal. Xan tʉpx wʉt, tajjal nakola wʉt, jiw xan nanaexasitpi, japi beltaeyaxaes babijaxan ispoxanliajwa, tajjal pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nawiasaxaelpon tadaelmajiwxot, ma amxot nak-ekondo'. ");
INSERT INTO guoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Xan, puexa jiw pakoewkolnan, tʉpaxaelen, me-ama Dios pejjamechan chajia jʉm-aech. Pe nawiasaxaelpon tadaelmajiwxot, japon kaes pejme xabich nabijasaxael —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesús pejnachala japox jʉmtaen wʉt, nakaewa najʉm-aechnapi: —¿Achankat xatisxot Jesús wiasaxael japon padaelmajiwxot? —na-aechnapi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Do jawʉx, Jesús pejnachala nakaewa najʉm-aechi: “¿Achankat xatisxot kaes pejme paklonaxael?” —na-aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús japox jʉmtaen wʉt, jʉm-aechon japiliajwa: “Asatʉajnʉpijiw, Dios naexasis-elpi, paklochow tato'las wʉt, tato'la-esal chamoeyaxtat. Ja-aech wʉt, paklochow nakiowa jiw nejxasinkas jʉmchiliajwas: ‘Wajpaklochow xabich pachaem’ —chiliajwas. ");
INSERT INTO guoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pelax xamal jasoxtat tato'laximil. Wʉljoeyaximilbej pamamax najutliajwa. Xamalxot kaen paklonasia wʉt, japon majt xamal malech tanbichaxael, me-ama pamakan wʉt, jachiliajwapon. Me-ama yamxʉlan pakoew pakdiachowxot wʉt, jachiyaxael japon aton. ");
INSERT INTO guoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Paklon ek wʉt xaeliajwa mesaxot, pamakan chiekal tataeflison, kamta isliajwa pejpaklon to'aspox. Ja-aechon, paklon kaes tato'lan xot. Xanlax jachi-enil. Xamalxotx wʉt, puexa kajachawaesfʉlax xamal. Me-ama namaknan wʉt, ja-an xan xamalliajwa” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jesús pejme jʉm-aech pejnachalaliajwa: “Xamal nachalafʉlam, Satanás piach xan naxapaejkafʉl wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Samata, tapaeyaxaelen xamal tato'laliajwam jiw. Me-ama taj-ax Dios xan natapaei puexa jiw tato'laliajwan, xamalbej jachiyaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Xan tajmatkoi pat wʉt jiw tato'laliajwan, jawʉt kaeyaxtat, xamal sʉapich, xaeyaxaelen. Feyaxaelenbej. Jawʉt chalakaxaelam asatʉa-ekaxanxot, paklochow pejtʉa-ekaxanxot, tato'laliajwambej docemʉtanpijiw, Israel tʉajnʉpijiw” —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús jʉm-aech Pedroliajwa: —Simón, ¡chiekal najʉmtaem! Satanás wʉljow Dios tapaeliajwas xam xapaejsliajwapon. Xabich xapaejsasiapon xam xan nakofsliajwam. ");
INSERT INTO guoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pe xan Dios kawʉajnax xam nanaexasisfʉlaliajwam. Pejme xam xan chiekal nanaexasitam wʉt, xam kajachawaesfʉlaxaelam asew tajnachala, japi kaes xan nanaexasisfʉlaliajwa —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón Pedro jʉm-aech: —Tajpaklon, asew jiw, jiw jebatat xam jia wʉti, ¡japibej xan nej naje! Xam boesa wʉtbejpi, ¡japibej xan nej naboesa! —aech Simón Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús jʉmnot wʉt, jʉm-aechon: —Pedro, xan chiekal jʉm-an xamliajwa. Amwʉt, kawaema nejlae-el wʉtfʉk, tres veces xan naxanaliyaxaelam. Jʉmchiyaxaelam: “Xan japon aton matabijs-enil” —chiyaxaelam xanliajwa —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —Xamal to'ax wʉt Dios pejjamechan naewʉajnaliajwam asapaklowaxanpijiw, xamal kefiatx xalaesamatam nejchoxan, plata, asatʉakxajoebej. Xamal masim folam wʉt, ¿pawewe'pkat asaxan? —aech Jesús, wʉajnachaemt wʉt pejnachala. Japi jʉmnot wʉt, jʉm-aechi: —Xanal nawewe'pa-el —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Do pejme Jesús jʉm-aech: —Xamal pejme folam wʉt, xamalxot pejchoxanpi, ¡japi nej xalae pejchoxan! Xamalxot pejplatapi, ¡japibej nej xalae pejplata! Xamalxot espada kejilpi, ¡thʉch naxoelpox nej mowapi! Mot wʉti, ¡japaplatatat nej wʉajspi pej-espada! ");
INSERT INTO guoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Diachwʉajnakolax xan jʉm-an. Dios pejjamechan chajia jʉm-aech, japox diachwʉajnakolax jachiyaxael xanliajwa. Jʉm-aechox Dios pejjamechan xanliajwa: ‘Japon kastikaxaes. Me-ama babejen wʉt, jakechiyaxaeson’ —aechox xanliajwa. Puexa chajia lelspox, diachwʉajnakolax japox jachiyaxael xanliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Do jawʉt, pejnachala jʉm-aech: —Tajpaklon, ama kole-espada —aechi. Jesús jʉmnot wʉt, jʉm-aechon: —Ma ampoxtat do mado' —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús nakolt wʉt Jerusalén paklowaxxot, Olivonaechanmʉax poxade, me-ama japon pejkabʉan. Pejnachala wʉchakal fol. ");
INSERT INTO guoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jesús pa'a wʉt jaxotde, jʉm-aechon pejnachalaliajwa: —Satanás xamal xapaejaxael. Samata, ¡Dios kawʉajande! Ja-am wʉt, Dios xamal kajachawaesaxael babijax is-elaliajwam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Do jawʉt, Jesús atʉaxachon pejnachalaxot tamachaliajwa. Me-ama ia't xadaps wʉt, jas-isdepon. Jaxotde brixtat nukon Dios kawʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Dios kawʉajan wʉt, jʉm-aechon: “Ax, nejxasinkam wʉt, ¡nabʉ'wem nabijasaxaelenpox! ¡Pe nabej is xan nejxasinkaxpox! ¡Isde xam nejxasinkampox!” —aech Jesús, pax Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Do jawʉt, chalechkal athʉlelsik Dios pej-ángel natulaelt Jesús mamnikaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús xabich nejchaxoel tʉpaxaelpoxliajwa. Samata, kaes pejme Jesús Dios kawʉajnafʉl. Jawʉt xabich pasislanaton. Pejsis satat natacholan. Me-ama jal, ja-aech pejsis. ");
INSERT INTO guoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesús nant wʉt Dios kawʉajanxot, kaxadin pejnachala poxadin. Jaxot japi taenpon, moejt wʉt. Japi xabich damal, nejxaejwas xoti. ");
INSERT INTO guoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Do jawʉt, Jesús jʉm-aech pejnachalaliajwa: —¿Ma-aech xotkat xamal moejtam? ¡Nanim! ¡Dios kawʉajande babijax isasamatam, Satanás xamal xapaeja wʉt! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús naksiya wʉtfʉk, Judas xabich jiw bʉ'pat Jesúsxot. Japon Jesús pejnachalan, japontat doce. Do jawʉt, mox soepanlison Jesús xusuiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pe jawʉt, Jesús jʉm-aech: —Judas, ¿xamkat nawiasaxaelam tadaelmajiwxot naxusuyaxtat, xan, puexa jiw pakoewkolnan? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Taen wʉti ja-aechpox, Jesús pejnachala jʉm-aech: —Tajpaklon, ¿xanalkat ampi jiw beyaxaelen espadatat, xam chamamosliajwan? —aech Jesús pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Do jawʉt, chalechkal kaen Jesús pejnachalan pej-espadatat boesa wʉt, kaen aton cho'chikchapon poklalel pejcho't. Japon aton nabist sacerdotespaklokolanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pe jawʉt Jesús jʉm-aech pejnachalanliajwa: —¡Nadokal! —aechon. Do jawʉt, cho'chikchaspon Jesús cho'jacha wʉt, jawʉt chiekal cho'koelon. ");
INSERT INTO guoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pati Jesús jaelsliajwa, japi sacerdotespaklochow, temploba wetipaklochowbej, judíos-ancianosbej. Jawʉt Jesús jʉm-aech japiliajwa: —¿Ma-aech xotkat xamal xafolam espada, iwabej, xan najaelsasiam wʉt? ¿Xankat xamalliajwa, me-ama babejnan wʉt, kabʉan-an? ");
INSERT INTO guoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kaematkoisfʉl Dios pejtemplobatat xan naewʉajnafʉlax jiw xamalxot. Pe jaxot najaels-emil, Dios patapae-el xot xamal. Pe amwʉtjel, patlisox, me-ama Dios pejjamechan chajia jʉm-aech xanliajwa, japox jachiliajwa. Samata, amwʉtjel Satanás, tato'alpon itkʉataxxot, xamal to'a xan najaelsliajwam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Do jawʉtlisdo', Jesús jaeltas japi. Jesús bʉflaech sacerdotespaklokolan pejba poxade. Jawʉt Pedro atʉaxach fol wʉchakal. ");
INSERT INTO guoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sacerdotespaklokolan, japon pejbafʉlmaktxot, temploba weti jit itfoti. Jaxot jit su'chalakax masajiati. Pedrobej jaxot naksu'cha-ek. ");
INSERT INTO guoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Do jawʉt, kaeow pawis, japabatat nabistpow, chiekal natachaemtow Pedro, jit naksu'cha-ek wʉton. Do jawʉt, jʉm-aechow jaxotpijiw jʉmtaeliajwas: —Ama kaen, jaeltaspon pejnachalan —aechow Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro xanalia wʉt, jʉm-aechon: —Pawis, xan chinax japon aton matabijs-enil —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Do jawʉx, asanbej pejme taenson. Japonbej jʉm-aech: —Diachwʉajnakolax xambej, japon pejmʉtpijnam —aechon Pedroliajwa. Pedro jʉmnot wʉt, jʉm-aechon: —¡El! ¡Xan japon pejmʉtpijna-enil! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Do jawʉx, kaehora wʉtlejen, asanbej pejme jʉm-aech: —Diachwʉajnakolax ampon, jaeltaspon pejnachalan. Amponbej Galilea tʉajnʉpijin —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pe Pedro pejme jʉm-aech: —Xan matabijs-enil jʉm-ampox —aech Pedro. Pedro jʉm-aech wʉtfʉk, jawʉt kawaema nejla. ");
INSERT INTO guoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kawaema nejla wʉt, Jesús wʉltataen wʉt, taenon Pedro. Do jawʉt, Pedro nejchafaet Jesús chajia jʉm-aechpox: “Amwʉt, kawaema nejlae-el wʉtfʉk, xam tres veces xanliajwa naxanaliyaxaelam. Jʉmchiyaxaelam xanliajwa: ‘Xan japon aton matabijs-enil’ —chiyaxaelam” —aech Jesús, chajia jʉm-aech wʉt Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Do jawʉt, japabafʉlmaktxot Pedro nakolt tathoet poxaliajwade. Jaxotde xabich nowpon, xabich nejxaejwas xot. ");
INSERT INTO guoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Poejiw, weti Jesús, japi bʉ'wʉajanpaeipi Jesús. Baesbejpon. ");
INSERT INTO guoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Itfumatakʉsbejpon. Jawʉt pejme xutulapas. Kaenanʉla xutulapi jʉm-aechi Jesúsliajwa: —¡Jʉm-amde, achan xam xutulap! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Japibej jʉm-aechi babejjamechan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kandiawasap wʉt, juimt julan wʉt, natameja judíos-ancianos, sacerdotespaklochow, judíos chanaekabʉanapibej. (Japi puexa natameja wʉt, japox pawʉl Junta Suprema.) Jesús bʉ'fos wʉt, bʉ'pachpon Junta Suprema natamejaxot. Japi pejwʉajnalel wʉt Jesús jʉmtis: ");
INSERT INTO guoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¡Xanal jʉmtaeliajwan xam jʉm-amde! ¿Xamkat diachwʉajnakolax Cristowam, Dios to'asponam jiw bʉ'weliajwam? —aechi. Jesús jʉmnot wʉt, jʉm-aechon: —Xan jʉm-an wʉt: ‘Diasdo'’ —an wʉt, xamal naexasisaximil. ");
INSERT INTO guoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Xamal wʉajnachaemtax wʉtbej, najʉmnosaximil. ");
INSERT INTO guoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pe xan, puexa jiw pakoewkolnan, ekaxaelen taj-ax Dios poklalel jiw tato'laliajwan, taj-ax sʉapich. Dios pamamakolan, japon xajʉp puexa isliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jawʉt Jesús wʉajnachaemtas wʉt, jʉmtispon: —¿Xamkatlap Dios paxʉlnam? —tispon. Jesús jʉmnot wʉt, jʉm-aechon: —¡Diasdo'! ¡Xanlap japonan, najʉm-amponan! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Do jawʉt, japi nakaewa najʉm-aech: —Xatis nakwewe'pa-el asew jiw nakjʉmchiliajwa Jesús pejbʉ'wʉajanpoxliajwa. Xatis wajut chiekal jʉmtaens, jʉm-aech wʉton: ‘Xan Dios paxʉlnan’ —aech wʉton. Japox jʉm-aech wʉt, jʉm-aechon Dios nejweslapox. Samata, kastikaxaeson —na-aech nakaewa Junta Supremapijiw. ");
INSERT INTO guoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Do jawʉt, japi jiw, Junta Supremapijiw, nana. Bʉ'follisi Jesús Pilato poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jesús Pilato pejwʉajnalel wʉt, tʉaduti Jesús tasalaliajwa. Jʉm-aechi: —Xanal tajut chiekal jʉmtaenx. Ampon aton pejnaewʉajnaxtat jiw potʉajnʉchanpijiw xabich palala. Jʉm-aechbejpon: ‘¡Nabej mos impuesto Roma gobiernoliajwa!’ —aechon. Jʉm-aechbejpon: ‘Xan Cristowan, Israel tʉajnʉpijiw tato'laliajwan’ —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Do jawʉt, Pilato wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Xamkatlap diachwʉajnakolax judíos pejreynam? —aech Pilato. Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax, xan japonan, me-ama xam jʉm-am —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Do jawʉt, Pilato jʉm-aech sacerdotespaklochowliajwa, puexa jiwliajwabej: —Xanliajwa ampon aton bʉ'wʉajanjil kastikaliajwan —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pe nakiowa, japi xabich jʉmbisnik Jesús kastikaliajwas. Samata, kaes xabich jʉm-aechfʉli: —Ampon aton pejnaewʉajnaxtat potʉajnʉchanpijiw xabich palala. Japox naewʉajnax tʉaduton Galilea tʉajnʉxot. Amwʉtjel japox naewʉajnafʉl amxotbej, Judea tʉajnʉxot —aech paklochow Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato jʉmtaen wʉt Jesús majt naewʉajanpox Galilea tʉajnʉxot, jawʉt, wʉajnachaemton judíospaklochow. Jʉm-aechon Jesúsliajwa: —¿Japonkat Galilea tʉajnʉpijin? —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Paklochow jʉm-aech wʉt: “Amponlap Galilea tʉajnʉpijin” —aech wʉti, Pilato to'a soldaw bʉflaeliajwas Jesús gobernador Herodes poxade, japon Herodes puexa Galilea tʉajnʉpijiw tato'lan xot. Japamatkoiyan Herodes Jerusalén paklowaxxot. ");
INSERT INTO guoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes taen wʉt Jesús bʉ'fospox japonlel, xabich nejchachaemilon. Herodes majt chajia taesiapon Jesús, wʉltaefʉl xot Jesús koechaxan isfʉlpoxan. Samata, japonbej pajut chiekal taesia Jesús koechax ispox. ");
INSERT INTO guoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes xabich wʉajnachaemsfʉl Jesús. Pe Jesús kaes jʉmnos-el wʉajnachaemsfʉlaspoxan. ");
INSERT INTO guoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jaxot nuil sacerdotespaklochow, judíos chanaekabʉanapibej. Japi tasala Jesús xabich jʉmbisnikpoxtat. ");
INSERT INTO guoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Do jawʉt, Herodes, pejsoldaw sʉapich, bʉ'wʉajanpaeipi Jesús. Xajoellisipon chamoeyax, me-ama rey pijax, jasox, japoxtat taxaxaelaliajwas. Me-ama judíos pejrey wʉt, ketison. Do jawʉx, Herodes pejsoldaw to'a Jesús pejme bʉflaeliajwas Pilato poxade. ");
INSERT INTO guoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Majt Pilato, Herodes sʉapich, nadaelmataen. Pe japamatkoitat japi pejme najʉmchachaemil. ");
INSERT INTO guoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Do jawʉx, Pilato wʉllala natamejlaliajwa sacerdotespaklochow, judíospaklochowbej, asew judíosbej. ");
INSERT INTO guoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Dolisi, natameja wʉt, Pilato jʉm-aech japiliajwa: —Xamal ampon aton bʉflaeman xanlel. Xan najʉm-am: ‘Ampon aton pejnaewʉajnaxtat potʉajnʉchanpijiw xabich palalafʉl’ —na-am xamal. Xamal nejwʉajnalel ampon chiekal wʉajnachaemtax bʉ'atasalampoxanliajwa. Ampon aton chinax babijax is-el kastikaliajwas. ");
INSERT INTO guoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes nejchaxoelbej: ‘Ampon aton babijax is-el’ —aech Herodes, nejchaxoel wʉt Jesúsliajwa. Samata, Herodes kastika-el Jesús. Asbʉan jʉmch kaxa to'anpon Jesús xanlel. Amwʉtjel xamal chiekal matabijam. Ampon aton babijax is-el japoxtat tʉpaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Samata, tajsoldaw keto'axaelen asbʉan jʉmch selsliajwas. Do jawʉx, nakolsax tapaeyaxaelen —aech Pilato japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kaewaechfʉl wʉt, Pascuafiesta wʉt, Pilato jitapaei kaen jiw jebatat jiaspon nakolsliajwa, jiw wʉljowspon. Pilato jasox is, jiw nejchachaemlaliajwa japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilato japox jʉm-aech wʉt: “Jesús nakolsax tapaeyaxaelen” —aech wʉton, judíos nejlasfʉl wʉt, jʉm-aechfʉli: —¡Japon kematamatalde cruztat! ¡Barrabáslax nakolsax tapaem! —aechfʉli. ");
INSERT INTO guoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Japon Barrabás majt naba, Pilato pejsoldaw sʉapich, Jerusalén paklowaxxot. Jiw babejpon. Samata, jiaspon jiw jebatat. ");
INSERT INTO guoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato tapaesia Jesús nakolsliajwa. Samata, pejme jʉm-aechon japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pe Pilato naksiya wʉt, japi jiw kaes nejlasfʉl wʉt, jʉm-aechfʉli: —¡Japonlax kematamatalde cruztat tʉpaliajwapon! —aechfʉli, nejlasfʉl wʉt Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato pejme jʉm-aech japiliajwa: —¿Ma-aech xotkat xamal jʉm-am: ‘¡Japon nej tʉpe!’ —amkat? ¿Achababijaxkaton is? Xanliajwa japon aton bʉ'wʉajanjil japoxtat tʉpaliajwa. Samata, tajsoldaw keto'axaelen asbʉan jʉmch selsliajwas. Do jawʉx, nakolsax tapaeyaxaelen japon —aech Pilato judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Pe japi xabich jʉmbisnik wʉt, nejlasfʉl. Jawʉt jʉm-aechfʉli: —¡Japon kematamatalde cruztat tʉpaliajwa! —aechfʉli. Japi xabich jʉmbisnik xot, Pilato baxael ow-aechlison. ");
INSERT INTO guoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Samata, Pilato pejsoldaw to'a tapaeliajwapi nakosax Barrabás jiw jebaxot, japi wʉljowpon nakolsliajwa. Barrabás jiw jebatat majt jias, naba xoton, soldaw sʉapich, asew jiw ba xotbejpon. Do jawʉtbej, Pilato to'a Jesús kematamatlaliajwas cruztat, me-ama japi jiw wʉljow japon isliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Do jawʉx, soldaw, japi bʉ'fol Jesús kematamatlaliajwas cruztat. Do jawʉtbej, paklowaxlel Simón fʉlaen. Japon Cirene paklowaxpijin. Xensliajwa wʉt, soldaw jaeltason. Do jawʉt, to'ason Jesús pijax cruz xalaeliajwa, Jesús xafolox. Jesús kaes xalaeyaxil, xabich boejil xotlison kastikaxtat. Dolisdo', japon Simón xafolon cruz Jesús pejwʉchakal. ");
INSERT INTO guoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Do jawʉt, xabich jiw Jesús pejwʉchakal fol. Japixot xabich watho' wʉnow. Nowpi pinjametat, xabich nejxaejwas xoti Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús wʉltataen wʉt japi watho'lel, jʉm-aechon: —Watho', Jerusalén paklowaxpijwam, ¡xan nabej nawʉnoe'! ¡Nawʉnoem najutliajwa, naxiliajwabej! ");
INSERT INTO guoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nabijasmatkoi pat wʉt, jiw xabich nabijasaxael. Japamatkoitat jiw jʉmchiyaxael: ‘Amwʉtjel wepachaems nafoenapi, asew xijilpibej, paxi ajil xot nabijasliajwa’ —chiyaxaeli. ");
INSERT INTO guoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Japamatkoitat jiw jʉmchiyaxaelbej pinamʉaxanliajwa, cha-aelmʉaxanliajwabej: ‘Natacholnamik xanallelsik nakʉlaliajwam, jasoxtat namoechaliajwambej’ —chiyaxaeli, kaes nabijasfʉla-elaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xan, babijax is-enilponan, nakematamatlaxaeli cruztat. Pe xabich babijaxan ispi, xabich kaes pejme nabijasaxael, wetapach wʉt nabijasmatkoi —aech Jesús japi watho'liajwa, wʉnowspiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dolisdo', soldaw bʉ'fol wʉti Jesús, jawʉtbej bʉ'foli kolenje kethakan, japibej kaenanʉla kematamatlaliajwas pejcruztat, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bʉ'pach wʉti kaemʉax pawʉlxot, Matnaethitmʉaxxot, jaxot Jesús kematamatlas cruztat. Jaxotbej kolenje kethakan kematamatlas cruztat. Asan chanuk Jesús pejpoklalel. Asan chanuk Jesús pejsoenalel. ");
INSERT INTO guoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús cruztat wʉt, jʉm-aechon: —Ax, ¡ampi jiw beltaem! Matabija-eli ispoxliajwa —aech Jesús soldawliajwa. Jesús kematamatali, japi soldaw nakakujti ia'xix matabijaliajwa, achan kanaxael kaenanʉla Jesús pejnaxoe. ");
INSERT INTO guoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jiw jaxoti natachaema puexa ja-aechox. Jaxotbej judíospaklochow. Jawʉt japi bʉ'wʉajanpaei Jesús. Nakaewa najʉm-aechi: —Asew jiw bʉ'wiapon. Diachwʉajnakolax ampon Cristo wʉt, Dios to'aspon wʉt jiw bʉ'weliajwa, ¡ma amwʉt pajut nej nabʉ'wepon! —aechi Jesúsliajwa, bʉ'wʉajanpaei wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldawbej bʉ'wʉajanpaeipi Jesús. Kaesʉapich soldaw mox soepa Jesúsxot. Dʉajsasiapi vino, xathuyamint, Jesús suiliajwa xabich wexaenkasamatas. ");
INSERT INTO guoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jawʉt jʉm-aechi Jesúsliajwa: —Xam judíospaklokolnam wʉt, ¡najut nabʉ'wem! —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús pejta'tabijla lelspox chaduch. Japox lelspox jʉm-aech: “Ampon judíos pejrey” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Asan kethakan cruztat kematamatlaspon, japonbej jʉm-aech bʉ'wʉajanpaei Jesús: —Xam Cristowam wʉt, Dios to'aponam wʉt jiw bʉ'weliajwam, ¡ma amwʉt najut nabʉ'wem! Do ja-aech wʉt, ¡xanalbej nabʉ'wem! —aech kethakan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Asan kethakan bʉxfiat pejnachalan bʉ'wʉajanpaeipox. Do jawʉt, jʉm-aechon: —¡Xam japox nabej jʉm-aeche' Jesúsliajwa! ¿Xamkat nejlewla-el Diosliajwa, xatisbej tʉpaxaes xot? ");
INSERT INTO guoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Xatis nabijatas nakkastikapoxtat, babijaxan isas xot. Amponlax chinax babijax is-el —aech kethakan pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kethakan japox jʉm-aech wʉt, jʉm-aechon Jesúsliajwa: —Jesús, xam puexa jiw tato'lax tʉadutam wʉt, ¡jawʉtbej xan nanejchadʉ'e! —aech kethakan. ");
INSERT INTO guoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús jʉmnot wʉt, jʉm-aechon kethakanliajwa: —Diachwʉajnakolax xan jʉm-an. Ma amwʉt, xam Diosxotaxaelam, xan sʉapich —aech Jesús kethakanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jesús tʉpaliajwa wʉt, juimt matnoch ek wʉt, xabich itkʉatnik tres hora potʉajnʉcha. ");
INSERT INTO guoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Itkʉatnik xabich, juimt chiekal itliaka-el xot. Do jawʉt, Dios pejtemplobatutat pinabʉ', duchpox batutat, najʉpathiakchakas. ");
INSERT INTO guoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Do jawʉt, Jesús nejlakcha wʉt, jʉm-aechon pax Diosliajwa: —Ax, ¡ma amwʉt xan tʉpaxaelen! ¡Xam xanaboejtax taj-espíritu chiekal nawetataeflaxaelampox! —aech Jesús. Jesús japox jʉm-aech wʉt, tʉplison. ");
INSERT INTO guoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldawcapitán taen wʉton Jesús tʉpax, do jawʉt, jʉm-aechon Diosliajwa: “Dios, xam xabich pachaemam” —aechon. Jʉm-aechbejpon jaxoti jʉmtaeliajwa: “Diachwʉajnakolax ampon aton chinax babijax is-el tʉpaliajwa jasoxtat” —aech soldawcapitán. ");
INSERT INTO guoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Puexa japox taenpi, nawia wʉt pejbachan poxade, kaenanʉla pajut namatiafdakapi, xabich nejxaejwas xot. ");
INSERT INTO guoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Asew jiw, matabijapi Jesús, japi atʉaxach natachaemanuil. Jaxotbej watho' nuil, fʉlaenpi Galilea tʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Jerusalén paklowaxxot aton duk. Japon pawʉl José. Japon Arimatea paklowaxpijin, Judea tʉajnʉxot. Japon pachaem. Chiekal dukbejpon Diosliajwa. Japon judíospaklochowxot, Junta Supremapijin. Pe japon kaenejchaxoelaxa-elon Junta Supremapijiw ispoxliajwa Jesúsliajwa. Japon wʉajnawet Dios pejmatkoi tʉadusliajwapox, Dios pejjiw tato'laxaelmatkoi. ");
INSERT INTO guoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jesús tʉp wʉt, José fʉlaech Pilato poxade wʉljoeliajwapon patʉpan Jesús mʉthsliajwabejpon. José wʉljow wʉt, Pilato ow-aech. ");
INSERT INTO guoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Do jawʉx, José pat wʉt patʉpan Jesúsxot, kusklison Jesús cruzxotsik. Jawʉt José xakoeya patʉpan sábanabʉ'tat, pabʉjabʉ'tat, osliajwa mʉaxwʉajxot. Japamʉaxwʉaj pajelwʉaj. Patʉpan os-esalfʉk. ");
INSERT INTO guoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","José japox is napatamatkoi wʉajna, japamatkoi chawʉajnachaemsliajwa. Jawʉt, José japox isax ketoet wʉt, cha-aex we'pfʉk nadusliajwa napatamatkoi. ");
INSERT INTO guoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Japi watho', majt Jesús naknanʉamti Galilea tʉajnʉxot. Japi watho' wʉchakal fol, José fʉlaech wʉt mʉaxwʉaj poxade. Samata, taeni Jesús ochpox. ");
INSERT INTO guoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Do jawʉt, japi watho' kaxa nawen wʉt pejba poxade, chaemtlisi perjumamin, xabejasapanbej, patʉpan joelaliajwa. Do jawʉt, japi napata, napatamatkoi xot. Me-ama Moisés chajia lelpox jʉm-aech, ja-aechlisi. ");
INSERT INTO guoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dominkomatkoi, kandiawasap wʉt, watho' fʉlaech patʉpanwʉaj poxade. Japi xafol chajia chaemtpi, perjumaminan, xabejasapanbej. ");
INSERT INTO guoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jaxotde pa'a wʉt, taeni ia't pinjit, jajaerat, asalelaxach nukpox, patʉpanwʉajfafa xat-elspot. ");
INSERT INTO guoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pe japi watho' japawʉaj low wʉt, tae-eli patʉpan. ");
INSERT INTO guoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jawʉt xabich beljowpi. Matabija-eli isaxaelpox. Do jawʉt, chalechkal japi watho' taen kolenje Dios pej-ángeles, jaxot nuil wʉti. Japi kolenje ángeles pejnaxoe xabich nakliafan. Me-ama chamx, jakaliaf-aech japi pejnaxoe. ");
INSERT INTO guoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Watho' pejlewla xot, brixtat nuili. Sat makxabijindikbejpi. Jawʉt Dios pej-ángeles jʉm-aech watho'liajwa: —¿Ma-aech xotkat xamal wʉlwekam patʉpan? ¡Jesús mat-echlison pejme dukaliajwa! ");
INSERT INTO guoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Amxot ajil patʉpan. Ma amwʉtjel dukpon, mat-ech xot. ¡Nejchafae'e, xamalliajwa chajia jʉm-aech wʉton, Galilea tʉajnʉxot wʉton! ");
INSERT INTO guoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Japon chajia jʉm-aech: “Xan puexa jiw pakoewkolnan, asew jiw nawiasaxael asajiwxot tʉpaliajwan, cruztat nakematamatlaliajwa. Tres matkoi wʉt, Dios namat-eyaxael pejme dukaliajwan” —aechon, chajia jʉm-aech wʉt —aech Dios pej-ángeles japi watho'liajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Do jawʉt, japi watho' nejchafaet Jesús chajia jʉm-aechpox japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Watho' kaxa nawen wʉt Jesús ochxotdin, puexa japoxan chapaeipi once apóstolesxot, asew jiwliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Japi watho'xot, kaeow pawʉl María. Japow Magdala paklowaxpijow. Asaow pawʉl Juana. Asaow pawʉl María. Japow Santiago pen. Kaes asew watho'bej japixot. ");
INSERT INTO guoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apóstoles jʉmtaen wʉt watho' jʉm-aechpox, jʉm-aechi, nejchaxoel wʉt: “Watho' pajut pejkaechantat faekalap” —aech apóstoles, nejchaxoel wʉt. Samata, naexasis-eli watho' chapaeispox. ");
INSERT INTO guoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Asew naexasis-el wʉt, Pedro najae'e Jesús mʉthtas poxade. Pat wʉton, patʉpanwʉaj natachaemsepon. Jawʉt taenon sábanabʉ'ankal. Do jawʉt, Pedro kaxadin wʉt, xabich nejchaxoelafʉl taenpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dominkomatkoi wʉt, kolenje Jesús pejnachalan Jerusalén paklowaxxot nakola Emaús paklowax poxaliajwade. Emaús paklowax pasliajwa, me-ama once kilómetros. ");
INSERT INTO guoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nʉamtat fol wʉt, nospaefʉli Jesús cruztat kematamatlaspoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nospaefʉl wʉtfʉki, Jesús pajut mox soepan japixot. Do jawʉt, Jesús nakfol japi. ");
INSERT INTO guoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Japi taen Jesús. Pe japi matabija-el japon Jesúspon, Dios tapae-esal xoti japi matabijsliajwa Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Do jawʉt, Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Achaxkat xamal nospaelpam, nʉamtat folam wʉt? —aech Jesús. Japi nuiljaba. Xutampapi nejxaejwaspox. ");
INSERT INTO guoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kaen japixot pawʉl Cleofas. Japon jʉm-aech: —¿Xamkat fʉlaeman Jerusalén paklowaxxot? ¿Xamkatlap kaenam matabijs-emilponam ja-aechox ampamatkoiyan Jerusalén paklowaxxot? —aech Cleofas Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Achaxkat ja-aech Jerusalén paklowaxxot? —aech Jesús. Do jawʉt, japi jʉm-aech: —Jesús Nazaretpijin, Dios pejprofeta, japon xabich koechaxan is Dios pejpamamaxtat. Jiw chiekal naewʉajnafʉlbejpon Dios pijaxtat. Jasox isfʉlon xabich jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sacerdotespaklochow, wajpaklochowbej, asajiwxot wiatipon tʉpaliajwa. Samata, cruztat kematamatlas. ");
INSERT INTO guoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Xanal nejchaxoelx japonliajwa: ‘Xatis judíos japon nakbʉ'weyaxael asatʉajnʉpijiw naktato'alpox’ —an xanal, nejchaxoelx wʉt japonliajwa. Pelisox tres matkoije japon tʉppox. ");
INSERT INTO guoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Asew watho' xanalxot ampakandiawasap fʉlaech patʉpanwʉaj poxade. Pe patʉpan Jesús ajil wʉt, kaxa naweni bachadin. Japi watho' xanal nachapaei, Dios pej-ángeles natulaela wʉt japixot jʉmtispox. Jʉmtis japi watho': ‘¡Jesús mat-echlison! ¡Ma amwʉtjel pejme duklison!’ —tis japi watho'. Japox xanal jʉmtaenx wʉt, xabich nejchaxoelx japoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Do jawʉx, asew xanalxotpijiw fʉlaech patʉpanwʉaj poxade pajut chiekal taeliajwa. Do jawʉt, taeni puexa, me-ama watho' jʉm-aech. Pe tae-eli patʉpan Jesús —aechi Jesúsliajwa, japi kolenje, Emaus paklowax poxade fʉlaechpi. ");
INSERT INTO guoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Do jawʉt, Jesús jʉm-aech japiliajwa: —Xamal xabich matnaetinkam. Naexasis-emil profetas chajia lelpox Cristoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Matabija-emilbej Dios pejjamechan. Cristo, Dios to'aspon jiw bʉ'weliajwa, japon majt xabich nabijasaxael. Do jawʉx, mat-eyaxaeson pejme dukaliajwa. Jiw tato'laxaelbejpon Diosxotse —aech Jesús pajutliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Do jawʉt, Jesús chiekal chanaekabʉana Dios pejjamechan chajia jʉm-aechox japonliajwa. Jawʉtbej chiekal chanaekabʉanapon Moisés chajia lelpoxliajwa. Do jawʉtbej, Jesús chiekal chanaekabʉana Dios pejprofetas chajia lelpox, jachiyaxaespox japonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús paklowax pasliajwa wʉti, jawʉt Jesús, me-ama matnoch xensliajwa wʉt, ja-aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pe japi kolenje xabich jʉmbisnik japon namanaliajwa japixot. Jʉm-aechi: —¡Namande xanalxot moejsliajwam! Tuilalisox. Itkʉa'nikafʉlbejlisox —aechi. Do jawʉt, Jesús ow-aech. Lowlison namanaliajwa, japi sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chalak wʉtlisi mesaxot naxaeliajwa, jawʉt Jesús panax fit wʉt, gracias-aechon Diosliajwa. Do jawʉt, panax jalnat wʉt, chaxduwpon japi kolenje. ");
INSERT INTO guoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Do jawʉtbej, japi chiekal matabija japon diachwʉajnakolax Jesúspon. Jawʉt chalechkal Jesús naxaelcha. ");
INSERT INTO guoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naxaelcha wʉton, nakaewa japi kolenje najʉm-aechna: —Diachwʉajnakolax xabich nejchachaemlas, nakfol wʉton xatis, chiekal nakchanaekabʉana wʉtbejpon Dios pejjamechan, chajia lelspox —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Do jawʉt, kamta nanapi kaxaliajwade, Jerusalén paklowax poxade. Jaxotde pa'a wʉt, wʉajna natamejal once apóstoles, asewbej. ");
INSERT INTO guoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Japi apóstoles jʉm-aech kolenje, jelpatiliajwa: —Diachwʉajnakolax wajpaklon Jesús mat-ech. Pejme duklison. Jesús natulaelt Simónxot —aechi. ");
INSERT INTO guoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Do jawʉt, japi kolenje, jelpati, chapaei, nʉamtat fol wʉt japiliajwa ja-aechpox. Chapaeibejpi, Jesús panax jalnat wʉt japi xaeliajwa. Do jawʉtbej, pajut chiekal matabijapi, diachwʉajnakolax japon Jesúspon. ");
INSERT INTO guoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Japi kolenje japox chapaei wʉtfʉk, jawʉt chalechkal Jesús natulaelt japixot. Do jawʉt, Jesús japi kejacha wʉt, jʉm-aechon: —¡Dios nej kajachawaes xamal chiekal duilaliajwam! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Xabich belwanapi, nejchaxoel wʉt, jʉm-aech xoti: “Ampon Jesús-el. Pej-ael” —aech xoti, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús jʉm-aech: —¿Ma-aech xotkat xamal puexa belwam? ¿Ma-aech xotbejkat naexasis-emil xan namat-etpoxliajwa pejme dukaliajwan? ");
INSERT INTO guoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","¡Taem tajke-e, tajtʉakanbej! Xanlap japonan. ¡Najacham! ¡Nataem chiekal! Espíritu wejisal pawi, pathibej. Me-ama xan, jachi-el —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bʉxtoet wʉt, itpaeilison pejke-e, pejtʉakanbej. ");
INSERT INTO guoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jesús pejnachala xabich nejchachaemil, pejme taen wʉti Jesús. Pe chiekal naexasis-elfʉki, diachwʉajnakolax japon Jesúskolan wʉt, xabich nejchaxoelanuil xoti. Do jawʉt, Jesús pejme jʉm-aech japiliajwa: —¿Xamalkat naxaeyax xan xaeliajwan? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jawʉt chaxdutipon baxin chabosan, jalnaspox. ");
INSERT INTO guoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Do jawʉt, Jesús baxin fit. Jawʉt puexa pejnachala pejwʉajnalel xaelon. ");
INSERT INTO guoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Do jawʉtbej, Jesús jʉm-aech japiliajwa: —Japoxanliajwa xamal chajia jʉm-an, tʉpaxaelenpoxliajwa tʉpa-enil wʉtfʉk, namat-esaxaelpoxliajwabej pejme dukaliajwan. Japoxanliajwa Moisés chajia lel, profetasbej. Salmosfʉtat lels japoxanliajwa. Samata, japoxan ja-aechlisox xanliajwa —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Do jawʉt, Jesús chiekal chanaekabʉana pejnachala, japi chiekal matabijaliajwa Dios pejjamechan, chajia lelspoxan, jʉm-aech wʉt Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","47","Jesús pejnachala chiekal chanaekabʉana wʉt, jʉm-aechon: —Dios pejjamechan chajia jʉm-aech xanliajwa: ‘Cristo, Dios to'aspon jiw bʉ'weliajwa, japon tʉpaxael. Tʉppox tres matkoi wʉt, japon mat-esaxaes pejme dukaliajwa. Do jawʉx, pejjiw tʉadusaxael japon pejwʉajan naewʉajnaliajwa Jerusalén paklowaxxot. Do baxael, japi naewʉajnaxael asew jiw, asatʉajnʉchanpijiw. Japox Cristo pejjiw isfʉlaxael jiw kofaliajwa babijaxan ispoxan beltaeliajwasi Dios’ —aech Dios pejjamechan, chajia jʉm-aech wʉt xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Diachwʉajnakolax japoxan chiekal ja-aechlisox. Amwʉtjel xamal najut chiekal taenam. ¡Japoxan xamal chapaefʉlde asew jiw! ");
INSERT INTO guoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Xan to'axoekan Espíritu Santo xamalliajwa, Dios chajia jʉmdutpon xamal kajachawaesfʉlaliajwapon. ¡Xamalfʉk kawetaxaelam Jerusalén paklowaxxot wʉajnawesliajwam Espíritu Santo xamal nejmatpʉatanxot pasliajwasik! Dolisdo', Espíritu Santo pask wʉt, mamnikaxaelam Dios pijaxtat —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Do jawʉx, Jesús pejnachala bʉ'fol Jerusalén paklowaxxot, Betania paklowaxlel poxade. Pa'a wʉti mox Betania paklowaxxot, Jesús mʉaxxachot Dios kawʉajnaliajwa pejnachalaliajwa, Dios kajachawaesfʉlaliajwas japon pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jesús kawʉajan wʉtfʉk Dios pejnachalaxot, jawʉt Dios bʉ'foslison athʉ poxase. ");
INSERT INTO guoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jesús pejnachala japox taen wʉt, brixtat nuili itpaeliajwa sitaeyax Jesúsliajwa. Do jawʉx, kaxa nawen wʉt Jerusalén paklowax poxadin, japi xabich nejchachaemil. ");
INSERT INTO guoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kaematkoisfʉl, Dios pejtemplobatat Dios kawʉajan wʉt, jʉm-aechi Diosliajwa: “Dios, xam xabich pachaemam” —aechfʉli.");
INSERT INTO guoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Majt akaseskolaxtat, ampathat is-esal wʉtfʉk, Cristo wʉajna chajia duk, pax Dios sʉapich. Pe japonbej Dios. Samata, itpaeipon Dios pejmatabijsax jiw matabijaliajwa japoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Diachwʉajnakolax dukon, pax Dios sʉapich, akaseskolaxtat. Amwʉtjel japon nakiowa duk. ");
INSERT INTO guoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dios pijaxtat Cristo is ampathat, thatbaxobej. Isbejpon puexa ampathatatpi, thatbaxotatpibej. Japoxan Cristo is-el wʉt Dios pijaxtat, puexa chiekal ajilaxael. Ajilaxael ampathat, thatbaxobej. ");
INSERT INTO guoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo pijaxtat jiw laelp ampathatat. Japon tapae-el wʉt, jiw ampathatat laelpaxil. Tapaeibejpon jiw matabijaliajwa diachwʉajnakolaxpox Diosliajwa. Samata, Cristo, me-ama itliakax. Itliakon jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Me-ama itliakax itkʉataxxot itliak wʉt, ja-aechbej Cristo. Itkʉatax itkʉasaxil itliakax. Satanás, me-ama itkʉatax. Satanás xajʉpaxil toesliajwa Cristo. ");
INSERT INTO guoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios pejprofeta, majt ampathatat laejapon, pawʉl Juan. Japon naewʉajan jiw Dios bʉxto'aspoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Samata, japon jiw naewʉajan matabijtpoxan Cristoliajwa, japi jiw naexasisliajwabej Cristo. ");
INSERT INTO guoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan Cristowa-el. Japon to'as jiw naewʉajnaliajwa Cristo wʉajna. ");
INSERT INTO guoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Diachwʉajnakolax Cristo fʉloek ampathatasik jiw matabijaliajwa, achan Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo chajiakolaxtat ampathat is Dios pijaxtat. Do jawʉx, Cristo pajut duk ampathatat. Pe ampathatpijiw matabija-el japon Cristopon, Dios paxʉlanpon. ");
INSERT INTO guoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Paskon pejjiwxotsik. Pe judíos naexasis-el japon Dios paxʉlanpon. ");
INSERT INTO guoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pe asew jiwlax, naexasiti Cristo, japon Dios paxʉlanpon, japi jiw Dios tapaeis Dios paxi nadofaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Japi penjiwxot nalaelapoxtat, Dios paxi nadofa-el. Dios tapaei is xoti, japi Dios paxi nadofa Cristo pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cristo nalaelt ampathatat, me-ama yamxi ampathatat nalaela wʉt, ja-aechon. Dukon xatisxot ampathatat. Cristo xabich nejxasink puexa jiw. Diach paeibejpon. Xanal taenx pejpamamax, pax Dios chaxduchpox japon kaekolan paxʉlanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan, jiw bautisan, chajia jʉm-aech jiw matabijaliajwa Cristo fʉlaeyaxoekpox. Samata, Juan pinjametat jʉm-aechon: “Xan chajia jʉm-an Cristoliajwa: ‘Xan fʉlaenx japon wʉajna. Fʉlaeyaxaelpon, japon kaes pejme paklonaxael. Me-ama xan, jachiyaxilon, japon wʉajna chajia duk xot Diosxotse’ —an xan” —aech Juan, jiw bautisan, Cristo pejpasaxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cristo xabich nejxasink puexa jiw. Samata, isfʉl pomatkoicha pachaempoxan xatisliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés, judíos pejwʉajnapijin, chajiakolaxtat japon naewʉajan judíos Dios tato'alpoxan. Baxael, Cristo pat japon chiekal jiw naewʉajnaliajwa Dios pejnejxasiyax jiwliajwa. Naewʉajanbejpon diachwʉajnakolaxpox. ");
INSERT INTO guoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kaen aton tae-el Dios. Pe Dios paxʉlan, dukpon paxxotse, japonlax chiekal matabijt pax Dios. Samata, japon pijaxtat matabijas, ma-aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Asamatkoi wʉt, judíospaklochow, Jerusalén paklowaxpijiw, japi to'a sacerdotes Juan poxade. To'abej kajachawaetpi sacerdotes. Japi to'as wʉajnachaemsliajwapi Juan. Pat wʉti Juanxot, japi jʉm-aech: —¿Xamkat achanam? ¿Xamkatlap Dios to'asponam? —aechi Juanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan diachwʉajnakolax chiekal paei. Samata, jʉmnot wʉt, jʉm-aechon japi jiw chiekal jʉmtaeliajwa: —Xan Cristowa-enil. Dios to'aspona-enil puexa jiw bʉ'weliajwan —aech Juan. ");
INSERT INTO guoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Japi pejme wʉajnachaemt wʉt, jʉm-aechi: —¿Xamkat achanam? ¿Xamkatlap Elías, Dios pejprofetam? —aechi Juanliajwa. Juan jʉmnot wʉt, jʉm-aechon japiliajwa: —Xan japona-enilbej —aechon. Do jawʉt, pejme wʉajnachaemt wʉt, jʉm-aechi: —¿Xamkatlap asanam ‘Dios pejprofeta, fʉlaeyaxaelpon’ —tisponam? —aechi Juanliajwa. Jawʉt, Juan jʉmnot wʉt, jʉm-aechon: —Xan japona-enilbej —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Japi pejme jʉm-aech: —Xam Dios pejprofeta-emil wʉt, ¿achanamkat xam? Xanal xalaesian wʉajan nato'apiliajwa. ¿Achaxkat xanal najʉmchiyaxaelam xam najutliajwa? —aechi Juanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Do jawʉt, Juan jʉmnot wʉt, jʉm-aechon wʉajnachaemtaspiliajwa: —Xan patx, pajilaxtat nejlasfʉlax wʉt jʉmchiliajwan: ‘¡Kofim babijaxan isfʉlampoxan! ¡Ja-amde japox wajpaklonliajwa! Ja-am wʉt, me-ama jiw wʉajna nʉamt chiekal chaemt paklon pasliajwa, jachiyaxaelam nejnejchaxoelaxantat’ —ansfʉlax, me-ama Isaías, Dios pejprofeta chajia jʉm-aech —aech Juan, jiw bautisan, wʉajnachaemtaspiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseos to'aspibej, japi wʉajnachaemt wʉt, jʉm-aechi Juanliajwa: ");
INSERT INTO guoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Xam Cristowa-emil wʉt, Elías-emil wʉtbej, asan Dios pejprofeta-emil wʉtbej, ¿ma-aech xotkat xam jiw bautisam? —aechi Juanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan jʉmnot wʉt, jʉm-aechon fariseos to'aspiliajwa: —Xan jiw bautisax mintat, japi jiw babijaxan ispoxan kofapi. Pe asan xatisxotpon, japon xamal matabija-emilfʉk. ");
INSERT INTO guoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Japon wʉajna xan fʉlaenx. Fʉlaeyaxaelponliajwa xan pachaema-enil japon pejkajachawaesnanliajwa, japon kaes pejme paklon xot. Samata, xan pachaema-enil jolsliajwan japon pejtʉakxajoelax —aech Juan fariseos to'aspiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jasoxtat Juan wʉajnachaemtas Betania paklowaxxot, Jordánlajt we-enlelde, juimt julanlelsan, Juan jiw bautisafʉlxot. ");
INSERT INTO guoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kandiawa wʉt, Juan taen Jesús, mox fʉlaen wʉt japonlel. Jawʉt Juan jʉm-aech jiwliajwa: “¡Tae'nik! Amponlap, me-ama Dios pejcordero, ja-aechpon. Japon asamatkoi tʉp wʉt, mosaxael puexa jiw babijaxan ispoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Japonliajwa xan chajia jʉm-an: ‘Xan fʉlaenx japon wʉajna. Fʉlaeyaxaelpon, japon kaes pejme paklonaxael. Me-ama xan jachiyaxilon, japon chajia wʉajna duk xot Diosxotse’ —an xan. ");
INSERT INTO guoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Majt japon xan chiekal matabijs-enil. Pe xan fʉlaenx jiw bautisaliajwan mintat, Israel tʉajnʉpijiw matabijaliajwapi japon” —aech Juan jiwliajwa, jʉm-aech wʉton Cristoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Do pejme Juan jʉm-aech jiwliajwa: “Xan taenx, Espíritu Santo athʉsik fʉloek wʉt a-utat Jesús pejmatwʉajasik. Fʉloek wʉt, na-eton japonxot. ");
INSERT INTO guoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Majt xan chiekal matabijs-enilfʉk, achan Cristo. Ja-an wʉt, Dios, xan nato'apon jiw bautisaliajwan mintat, chajia najʉm-aechon: ‘Taenam wʉt Espíritu Santo, fʉloek wʉt aton matwʉajasik na-esliajwa japonxot, japonlap Cristowaxael. Do jawʉx, japon to'axael Espíritu Santo xamal nejmatpʉatanxotaliajwa’ —na-aech Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Xan japox taenx. Samata, Jesúsliajwa jʉm-an: ‘Diachwʉajnakolax japon Dios paxʉlan’ —an xan” —aech Juan, jiw bautisan, jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Do kandiawa wʉt, Juan, jiw bautisan, pejme jaxoton, kolenje pejnachalan sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan taen wʉt Jesús xensax, jawʉt jʉm-aechon japi kolenjeliajwa: —¡Tae'nik ampon, me-ama Dios pejcordero, ja-aechpon! —aech Juan kolenje pejnachalanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Japi kolenje, Juan pejnachalan, jʉmtaen wʉti Juan jʉm-aechpox, japi fʉlafol Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Do jawʉt, Jesús wʉltataen wʉt, taenon fʉlafospi. Jawʉt wʉajnachaemt wʉt, jʉm-aechon japiliajwa: —¿Achaxkat xamal wʉlwekam? —aech Jesús japiliajwa. Japi jʉmnot wʉt, jʉm-aechi: —Jiw chanaekabʉanan, ¿amxotkat xam dukam? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús jʉmnot wʉt, jʉm-aechon japiliajwa: —¡Xabʉa't xan dukxxot taeliajwam! —aech Jesús japiliajwa. Do jawʉt, japi nakfol Jesús. Do jawʉtbej, japi taen Jesús dukxot. Jawʉt japi nama japonxot, xabich tuila xotlisox. ");
INSERT INTO guoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan, jiw bautisan, jʉm-aechpox jʉmtaenpi, japixot kaen pawʉl Andrés. Japon Simón Pedro pakoewan. ");
INSERT INTO guoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Do bʉxtoet wʉt nospaeyax, Jesús sʉapich, jawʉt Andrés wʉlwek pakoewan, japon pawʉlpon Simón. Faen wʉt, jʉm-aechon pakoewanliajwa: —Xanal taenx Mesías —aechon. (‘Mesías’ —aech wʉt, japajame jʉmchiliajwa: ‘Cristo, Dios to'aspon jiw bʉ'weliajwa’ —chiliajwapox.) ");
INSERT INTO guoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Do jawʉt, Andrés bʉflaechon Simón Jesús poxade. Jesús taen wʉt, jʉm-aechon Simónliajwa: —Xam nejwʉl Simón, Jonás paxʉlnam. Pe amwʉtjel xam nawʉlaxael Cefas —aech Jesús. (Japawʉl jʉmchiliajwa: ‘Pedro’ —chiliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kandiawa wʉt, Jesús nejchaxoel Galilea tʉajnʉ poxade fʉlaeliajwade. Jawʉt Jesús taen Felipe. Samata, Jesús jʉm-aech Felipeliajwa: —¡Xan nakfʉlaem tajnachalnamliajwa! —aech Jesús Felipeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe Betsaida paklowaxpijin. Andrésbej, Pedro sʉapich, japibej Betsaida paklowaxpijiw. ");
INSERT INTO guoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jawʉt Felipe fʉlaech Natanael wʉlwekaliajwa. Faen wʉt, jʉm-aechon: —Xan taenx Mesías. Me-ama Moisés chajia lelpox jʉm-aech, ja-aechlisox. Japon patlison. Me-ama Dios pejprofetas chajia lelpoxan jʉm-aech japon pasaxaelpox, japox ja-aechlisox. Japon Jesús, José paxʉlan. Japonbej Nazaret paklowaxpijin —aech Felipe Natanaelliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael jʉm-aech Felipeliajwa: —Nazaret paklowaxpijiw pachaema-el. Samata, japixot kaen aton ajil xabich pachaempon —aech Natanael. Felipe jʉmnot wʉt, jʉm-aechon Natanaelliajwa: —¡Xabʉa't xam taeliajwam Jesús! —aech Felipe Natanaelliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús taen wʉt Natanael fʉlaenox, do jawʉt, Jesús jʉm-aech Natanaelliajwa: —¡Taem! Ama fʉlaen Israel tʉajnʉpijin, japon chinax jiw naekichachajba-el —aech Jesús Natanaelliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Do jawʉt, Natanael wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Ma-aech xotkat namatabijtam? —aech Natanael Jesúsliajwa. Jesús jʉmnot wʉt, jʉm-aechon: —Xan taenx, xam ekam wʉt atʉaj higonaebʉxfaltat, nakoewan Felipe jʉmchi-el wʉtfʉk xanliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Do jawʉt, Natanael jʉm-aech: —Jiw chanaekabʉanan, xam diachwʉajnakolax Dios paxʉlnam, jasoxtat chajia atʉaj namatabijtam xot. Xam judíos pejreynam —aech Natanael Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús jʉm-aech Natanaelliajwa: —Xam chiekal nanaexasitam, jʉm-an wʉt: ‘Xan taenx, xam ekam wʉt higonaebʉxfaltat’ —an wʉt. Xam taeyaxaelam, kaes pejme pachaempoxan xan isx wʉt. Me-ama ampox, jachiyaxil —aech Jesús Natanaelliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús pejme jʉm-aech: —Diachwʉajnakolax xan jʉm-an. Xamal taeyaxaelam, athʉ fafa'ch wʉt xan tajmatwʉajasik. Do jawʉtbej, taeyaxaelam xabich Dios pej-ángeles fafa'chxotsik, jajulaxoei wʉt, xanxot, puexa jiw pakoewkolnanxot. Do jawʉtbej, taeyaxaelam asew ángeles balaloeyaxoek wʉt xanxotsik —aech Jesús Natanaelliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Do jawʉx, tres matkoi wʉt, kaen aton nakjiya Caná paklowaxtat, Galilea tʉajnʉxot. Jesús pen jaxotbej. ");
INSERT INTO guoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesúsbej tadʉch taeliajwa nakjiyafiesta, xanal pejnachalwan sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dolis, baxael, vino wetoepslisi. Do jawʉt, Jesús pen jʉm-aech Jesúsliajwa: —Japi vino wetoeps. ¿Achaxkat xam isaxaelam? —aechow paxʉlanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús jʉmnot wʉt, jʉm-aechon penliajwa: —En, ¿ma-aech xotkat xan japox najʉm-am? Xan tajmatkoi nawepas-elfʉk jiw itpaeliajwan, achanan xan —aech Jesús penliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","(Jesús pen matabijt japon xajʉppox isliajwa koechaxan.) Samata, jʉm-aechow naxaeyaxan cha-efʉlpiliajwa mesaxot: —¡Isde puexa Jesús to'apox! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jaxot seis ia'kʉanar chalak. Japakʉanar xabich pinanʉl minliajwa, judíos xabich kekakiasliajwa xaeliajwa wʉt. Jasox pejkabʉanan japi judíos. Kaenanʉla kʉanar xajʉp, me-ama setenta litros. ");
INSERT INTO guoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús jʉm-aech naxaeyaxan cha-efʉlpiliajwa: —¡Puexa ampi kʉanar min wʉluim! —aechon. Do jawʉt, chiekal min wʉlʉlisi japakʉanar. ");
INSERT INTO guoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jawʉt Jesús jʉm-aech: —¡Min powim! ¡Kaesʉapich ampamin xalaemch nejpaklon poxade! —aech Jesús. Do jawʉt, japi ow-aechlisi. Jawʉt xalaechlisi naxaeyaxan cha-efʉlpi pejpaklon poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pejpaklon vino xapaejla wʉt, matabijs-elon min vino nadofapot. Naxaeyaxan cha-efʉlpilax matabija japox, japi pajut min powa xot. Do jawʉt, pejpaklon la, pajelnakjiyan. Jʉm-aechon japonliajwa: ");
INSERT INTO guoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Asew jiw fiesta is wʉt, vino pachaempot matxoela dʉajti jiw. Do jawʉx, tadʉchpi xabich af wʉt, vino omjilpot dʉajti. Xamlax vino, kaes pachaempot, xanal nadʉajtam amwʉtjel —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Japox Jesús is wʉt Caná paklowaxxot, japoxlap matxoelapijax, koechax. Jesús japox is wʉt, itpaei pejpamamax. Samata, xanal, japon pejnachalwan, naexasitx diachwʉajnakolax Jesús Dios to'aspon. ");
INSERT INTO guoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Do baxael, Jesús, pen sʉapich, japon pakoewbej, xanal pejnachalwanbej, fʉlaechx Capernaum paklowax poxade. Jaxotde kaematkoiyan sʉapich xanal namax. ");
INSERT INTO guoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Moxsfʉl Pascuafiesta, judíos pejfiesta. Samata, Jesús fʉlaech Jerusalén paklowax poxade, xanal japon pejnachalwan sʉapichbej. ");
INSERT INTO guoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dios pejtemplobafʉlmaktxot, Jesús taen jiw mowapi pak, oveja, a-ubej. Jaxot taenbejpon, chalak wʉt plata xanafokpi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús japox taen wʉt, mʉat fa'ton japi jiw selsliajwa. To'apon puexa japi jiw nakolaliajwa, puexa pej-ovejas sʉapich, pejew pak sʉapichbej. Plata xanafoki japi pejmesaxan wefʉliaxabapon. Japi pejplata wenatacholnas satadik. ");
INSERT INTO guoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jʉm-aechon a-u mowapiliajwa: —¡Ampi a-u jukde ampabafʉlmaktxot! ¡Taj-ax pejba mowaba nabej padofa! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Do jawʉt, xanal japon pejnachalwan, nejchafaetx Dios pejjamechan chajia jʉm-aechpox Mesías jʉmchiyaxaelpoxliajwa. Japox jʉm-aech: “Ax, xanbej xabich nejxasinkax jiw sitaeliajwa nejba. Pe ampi jiw sitae-el nejba. Samata, xan xabich talala japi jiwliajwa” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Do jawʉt, judíospaklochow palaeyajametat jʉm-aechi Jesúsliajwa: —¡Najʉm-amde, ma-aech xotkat xam japox isam! ¿Achankat xam to'a? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús jʉmnot wʉt, jʉm-aechon: —Xamal toetam wʉt ampatemploba, xan pejme mat-esaxaelen, tres matkoi wʉt —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Do jawʉt, judíospaklochow jʉm-aech: —Ampatemploba isas wʉt, isas cuarenta y seis waechan. Xam xajʉpaximil pejme isliajwam ampatemploba tres matkoitat —aech judíospaklochow. ");
INSERT INTO guoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús japox jʉm-aech wʉt, jʉmchi-elon templobaliajwa. Japon japox jʉm-aech wʉt, jʉm-aechon pajut pejbʉ'tliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Samata, xanal, japon pejnachalwan, baxael, Jesús tʉp wʉt, mat-ech wʉtbejpon, pejme duk wʉton, jawʉt, xanal nejchafaetx Jesús chajia jʉm-aechpox japon pajut pejbʉ'tliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús Jerusalén paklowaxxot wʉt, Pascuafiesta wʉt, xabich jiw naexasiti japon Cristopon, Dios to'aspon, taen wʉti koechaxan, Jesús ispoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pelax Jesús xanaboejs-el japi jiw, matabijt xoton puexa jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Samata, Jesús wewe'pa-esal asew jiw chapaeliajwas jiwliajwa, pajut chiekal matabijt xoton jiw pejnejchaxoelaxan. ");
INSERT INTO guoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nicodemo, japon fariseos-aton. Japonbej paklon judíosxot. ");
INSERT INTO guoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Do madoi wʉt, Nicodemo fʉlaech nospaeliajwa, Jesús sʉapich. Jesúsxot pat wʉt, jʉm-aechon: —Jiw chanaekabʉanan, xanal chiekal xam matabijtax xam Dios to'aponam xanal nanaewʉajnaliajwam. Taenx, xam koechaxan isam wʉt Dios pejpamamaxtat. Xanal matabijaxbej ampox. Dios chaxdusaxil wʉt pamamax, xam koechaxan isaximil —aech Nicodemo. ");
INSERT INTO guoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Do jawʉt, Jesús jʉm-aech: —Diachwʉajnakolax xan jʉm-an. Aton nalaels-el wʉt pejme, japon Diosxotse pasaxil —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo pejme wʉajnachaemt wʉt, jʉm-aechon: —¿Machiyaxaelkat aton pati'in wʉt, pejme nalaelsliajwa penxot? Aton pejme leyaxil pen pejwoejtat pejme nalaelsliajwa —aech Nicodemo. ");
INSERT INTO guoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan jʉm-an. Aton matxoela nalaelt penxot. Do jawʉx, nalaelsaxaelon Espíritu Santo pijaxtat. Aton nalaels-el wʉt Espíritu Santo pijaxtat, japon aton pasaxil Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Paxjiw isaspoxantat nalaelapi, japi jiwkal. Pe Espíritu Santo pijaxtat nalaelapi, japi jiw duilafʉlaxael Dios pijaxtat. ");
INSERT INTO guoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","¡Xam xabich nabej nejchaxoele', japox jʉm-an wʉt xamliajwa: ‘Puexa jiw wewe'pas pejme nalaelaliajwa. Pejme nalaela-el wʉti, japi Diosxotaxil’ —an wʉt xamliajwa! ");
INSERT INTO guoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Joewa nejmach wik. Joewa nejmet wʉt, thiataens. Pe tae-esal joewa. Tae-esal amxot fʉlaen. Tae-esalbej ampoxade fʉlaech. Ja-aechlap-is Espíritu Santo, japon pijaxtat jiw pejme nalaela wʉt. Japi taeyaxisal waj-itfutat nalaela wʉti Espíritu Santo pijaxtat —aech Jesús Nicodemoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Do pejme Nicodemo wʉajnachaemt wʉt, jʉm-aechon: —¿Achax chiyaxaelkat xam jʉm-ampox? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús jʉmnot wʉt, jʉm-aechon: —Xam judíos chanaekabʉanamponam. Pe xam japoxan matabijs-emilfʉk. ");
INSERT INTO guoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Diachwʉajnakolax xan jʉm-an. Xanal jʉm-an matabijaxpoxan. Xanal jʉm-anbej taenxpoxan. Pe xamal naexasis-emil xanal jʉm-anpoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Naexasis-emil wʉt xan jʉm-anpox ampathatpijaxanliajwa, ¿machiyaxaelamkatlax matabijsliajwam, xan jʉm-an wʉt Diosxotsepoxanliajwa? —aech Jesús Nicodemoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Jesús pejme jʉm-aech: “Nejmach-aton pajut pijaxtat pasaxil Diosxotse. Xanlax kaenan, puexa jiw pakoewkolnan, Diosxotsik fʉloekxponan. Chiekal matabijtax, ma-aech Diosxotse. Xanlap tajut pejme japoxaxoeyan. ");
INSERT INTO guoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","(Chajiakolaxtat xabich jiw tʉp pajilaxtat, xabich jom liklas wʉti.) Asew jom liklaspoxtat chatʉpasia wʉt, Moisés jom-ael is broncetat. Japox naetat athʉ chanoton israelitas tʉpax natoenasamata. Israelitas japox natachaema wʉt, kaes tʉpafʉla-eli. Asamatkoi xanliajwabej, me-ama japox jachiyaxael, xan, puexa jiw pakoewkolnanliajwa, asew jiw nachanosaxael wʉt. Nejmachjiw xan nanaexasit wʉt, japi jiw xan bʉ'weyaxaelen pomatkoicha duilaliajwa Diosxotse” —aech Jesús Nicodemoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Jesús pejme jʉm-aech Nicodemoliajwa: “Dios ampathatpijiw xabich nejxasink. Samata, xan kaekolnan, japon paxʉlnan, nato'akon ampathatasik xan tʉpaliajwan, mosliajwan ampathatpijiw babijaxan ispoxanliajwa. Xan nanaexasitpi, japi jiw asamatkoi tʉp wʉt, napelsaxili. Japi jiw pomatkoicha duilaxael Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios xan nato'a jiw bʉ'weliajwan ampathatat. Dios xan nato'a-el jiw jʉmchiliajwan: ‘Ampi jiw kastikaxaes, babijaxan is xot’ —chiliajwan. ");
INSERT INTO guoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Xan nanaexasiti Dios paxʉlnanponan, japi infierno poxaxildiki. Pelax xan nanaexasis-elpi, japi infierno poxaxaek jaxotdik kastikaliajwas, chajia jʉmtis xoti japi kastikaliajwas, xan nanaexasis-el xoti, xan kaenan, Dios paxʉlnanponan. ");
INSERT INTO guoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Xan nanaexasis-elpiliajwa, japi jiwliajwa, chajia jʉmtis kastikaxaespox, babijaxan is xoti. Xan fʉloekx ampathatasik jiw matabijaliajwa Dios. Xan, me-ama itliakax jiw chiekal matabijaliajwa Dios. Pe jiw nejxasinka-el japi matabijaliajwa Dios. Xan, me-ama itliakaxponan. Pe nakiowa, jiw namastaen. Japi jiw, babijaxan isasiapi, japox islisi. Samata, japi jiw kaes nejxasink itkʉatax, isfʉl xot babijaxan. Samata, xan namastaen xot, japi jiw kastikaxaes. ");
INSERT INTO guoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Puexa jiw, babijaxan ispi, japi jiw xan nanejwesla, me-ama itliakaxponan xot, itpaeyaxaelen xot japi babijaxan ispoxan. Japi jiw mox pas-el xanxot taesamatan, japi babijaxan is wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pelax Dios naexasiti, japi isfʉl pachaempoxan, me-ama Dios to'a. Ja-aech wʉt, japi jiw moxa xanxot. Isfʉlbejpi pachaempoxan, Dios nejxasinkpoxan, puexa jiw taeliajwas” —aech Jesús Nicodemoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jesús japox bʉxtoet wʉt, fʉlaechon, xanal pejnachalwan sʉapich, Judea tʉajnʉlel. Do jaxotde kaematkoiyan sʉapich xanal bautisax asew jiw. ");
INSERT INTO guoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Juan, jiw bautisan, jiw jebaxot je-esal wʉtfʉk, japonbej bautisafʉl jiw Enón tʉajnʉxot, mox Salim tʉajnʉxot. Jaxot xabich minxot, Juan jiw bautisafʉl. ");
INSERT INTO guoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Do jawʉx, Juan pejnachala nalot, asan judíos-aton sʉapich. Japi nabʉnlot bautisax. Jawʉt najʉm-aechi nakaewaliajwa: “Nakbautisa wʉt, ¿achan pejbautisaxkat kaes pejme pachaem, xatis chiekal pachaemaliajwas Diosliajwa?” na-aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Do jawʉx, Juan pejnachala mox soepa Juanxot nospaeliajwa japoxliajwa. Jʉm-aechi Juanliajwa: —Jiw chanaekabʉanan, xatis Jordánlajt weskleldas wʉt, xam chajia jʉm-amponliajwa xanalliajwa, amwʉtjel japon jiw bautisafʉl. Xabich jiw fʉlafosbejpon —aech Juan pejnachala Juanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Do jawʉt, Juan jʉmnot wʉt, jʉm-aechon pejnachala chiekal jʉmtaeliajwapi Jesúsliajwa: —Dios pajut nejchaxoel kaenanʉla jiwliajwa, achan pejme pachaemaxael. ");
INSERT INTO guoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xamal najut chiekal xan najʉmtaenam, chajia jʉm-an wʉt: ‘Xan Cristowa-enil. Xan asbʉan jʉmch atonan, matxoelanato'aponan Cristo wʉajna’ —an wʉt, xan. ");
INSERT INTO guoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aton pawis fit wʉt pijowliajwa, pejnachala xabich nejchachaemil japon atonliajwa. Pejnachala wʉajnawet nakjiyaxaelpon pasaxaelxot. Japon aton pat wʉt, nospaei wʉtbejpon, pejbabijnow sʉapich, japon pejnachala xabich nejchachaemlaxael. Xanbej ja-an. Xabich nejchachaemlax, xabich jiw Jesús fʉlafos wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Samata, Jesús kaes pejme xabich jiw fʉlnanʉamsaxaeson. Xan ja-enil —aech Juan, pajutliajwa jʉm-aech wʉton pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aton ampathatpijin, japon diachwʉajnakolax ampathatpijinkal. Samata, jʉm-aechon ampathatpijaxankal. Pelax Jesús, fʉloekpon athʉlelsik, japon kaes pejme paklon. Me-ama asew jiw, jachi-elon. ");
INSERT INTO guoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Japonbej jʉm-aech taenpoxan, jʉmtaenpoxanbej, Diosxotse. Pe jiw naexasis-el japon jʉm-aechpoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Asew naexasit wʉt japon jʉm-aechpoxan, ja-aech wʉt, asew jiw matabijaxael Dios jʉm-aechpox diachwʉajnakolax. ");
INSERT INTO guoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jesús, Dios to'aspon, jʉm-aechfʉl Dios jʉm-aechpoxan, Espíritu Santo kajachawaesfʉlas xot. ");
INSERT INTO guoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios xabich nejxasink paxʉlan. Samata, chaxduton pejpamamax paxʉlanliajwa, puexa tato'laliajwapon. ");
INSERT INTO guoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dios paxʉlan naexasiti, japi jiw pomatkoicha duilaxael Diosxotse. Pe naexasis-eli Dios paxʉlan, japi duilaxil Diosxotse. Japilax Dios xabich kastikaxaes. ");
INSERT INTO guoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseos wʉltaen Jesús kaes pejme xabich pejnachalapox. Wʉltaenbejpi Jesús kaes pejme jiw bautisapox. Me-ama Juan, jachi-elpon. ");
INSERT INTO guoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesús pajut jiw bautisa-el. Pe xanal, japon pejnachalwan, jiw bautisax. ");
INSERT INTO guoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Samata, Jesús matabijt wʉt fariseos wʉltaenspox japonliajwa, do jawʉt, nakolt wʉt Judea tʉajnʉxot, xanalbej nakolax, Jesús sʉapich. Nawiax kaxade, Galilea tʉajnʉ poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Xanal fʉlaechx Samaria tʉajnʉ poxade, pasliajwa Galilea tʉajnʉ. ");
INSERT INTO guoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ja-an wʉt, xanal patx Sicar paklowax, Samaria tʉajnʉxot. Jaxot mox, Jacob chajia paxʉlan José chaxdutsat. Japasatbej José pamowjiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jaxot minmʉth, Jacob chajia kowpox. Do jawʉt, Jesús xabich damal, atʉaj fol xoton. Samata, minmʉthxot ekon, mox pawʉajna wʉt juimt matnoch ekaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Dolisdo', xanal, Jesús pejnachalwan, fʉlaechxlis paklowax poxade wʉajsliajwan naxaeyaxan. Do jawʉt, Jesús tamach ekafʉl wʉt minmʉthxot, kaeow pawis pa'an mint posliajwa. Japow Samaria tʉajnʉpijow. Do jawʉt, Jesús jʉm-aech japowliajwa: —¡Mint xan nachaxdu'e feliajwan! —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria tʉajnʉpijow jʉm-aech Jesúsliajwa: —¿Ma-aech xotkat mint nawʉljowam, xam judíos-atonam wʉt? ¿Xamkat matabijs-emil xan Samaria tʉajnʉpijwanpox? —aechow. (Judíos pachaemaxil. Nospaeyaxilbejpi, Samaria tʉajnʉpijiw sʉapich, japi pejkabʉan xot japox. Samata, japow jʉm-aech japox Jesúsliajwa.) ");
INSERT INTO guoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon japowliajwa: —Xam matabijs-emilfʉk Dios chaxdusaxaelpox. Matabijs-emilbej, mint wʉljowpon. Chil xam xan namatabijtam wʉt, chil ja-aech wʉt, xam nawʉljoeyaxaelam mint pachaempot. Ja-am wʉt, xam chaxdusaxaelen mint, me-ama Dios pejmint. Japot mint pomatkoichaliajwa —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Do jawʉt, japow jʉm-aech: —Tajpaklon, minmʉth xabich fʉniachdik. Xam kejimil posliajwam mint. ¿Amxotkat xam mint posaxaelam xan nachaxdusliajwam, Dios pejmint, pomatkoichaxaelpot? ");
INSERT INTO guoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Xanal tajwʉajnapijin, Jacob, ampaminmʉth nawewaelsnadoft xanalliajwa. Japon pajut ampamin af, paxi sʉapich, pejchoefbej. ¿Xamkat kaes pejme paklonam, me-ama Jacob jachi-emil? —aechow Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús jʉmnot wʉt, jʉm-aechon japowliajwa: —Puexa jiw, ampamin afpi, pejme minsila. ");
INSERT INTO guoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pe xan jiw chaxduwx wʉt Dios pejmint, japamint af wʉti, japi jiw kaes minsilaxil. Japamint xan chaxduiyaxaelen, me-ama min, nakolanmin satxotsin. Japamint, Dios pejmint. Japamint toepaxil. Japamin jiw af wʉt, pomatkoicha duilaxael —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Do jawʉt, japow jʉm-aech: —¡Japamint nachaxdu'e, xan pejme minsilasamatan, xan pejme fʉlaesamatanbej ampaminmʉthlel, kaes mint pos-elaliajwanbej! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús pejme jʉm-aech japowliajwa: —¡Xabʉa'de! ¡Wʉljae'mich nejmol! ¡Do pejme kaxamin, nejmol sʉapich! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Japow jʉmnot wʉt, jʉm-aechow: —Xan tamachpijwan —aechow. Do jawʉt, Jesús jʉm-aech: —Xam chiekal jʉm-am, ‘Xan tamachpijwan’ —am wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pe xam cinco nejmol. Ampamatkoiyan xam nakmoejtpon, japon nejmola-el. Diachwʉajnakolax xam chiekal jʉm-am, ‘Xan tamachpijwan’ —am wʉt —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Japox jʉmtaen wʉt, jʉm-aechow: —Tajpaklon, xamkas Dios pejprofetam. ");
INSERT INTO guoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xanal tajwʉajnapijiw, Samaria tʉajnʉpijiw, Dios kawʉajan ampamʉaxxot, pejsitaeyax itpaeliajwapi Diosliajwa. Xamal judíos jʉm-am: “Dios kawʉajnaxaes Jerusalén paklowaxxot, wajsitaeyax itpaeliajwas Dios” —am xamal —aechow Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús jʉmnot wʉt, jʉm-aechon japowliajwa: —¡Xan nanaexasi'e! Kaematkoiyan wʉt, puexa xamal fʉlaeyaximil ampamʉax poxadin nejsitaeyax itpaeliajwam Dios. Fʉlaeyaximilbej Jerusalén paklowax poxade Dios kawʉajnaliajwam. ");
INSERT INTO guoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Xamal, Samaria tʉajnʉpijwam, nejsitaeyax itpaeyam Dios. Pe xamal chiekal matabija-emilfʉk Dios. Xanal judíos chiekal matabijtax Dios, xanal Dios namakanot xot japon pejjiwaliajwan. Samata, Mesías, judíos-aton, japon nakbʉ'weyaxael ampathatpijwas. ");
INSERT INTO guoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amwʉtjel, baxaelbej, jiw pejsitaeyax itpaeyaxael xabich nejthʉ'axtat Diosliajwa, Dios xabich nejxasink xoti. ");
INSERT INTO guoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios, japon espíritu. Samata, jiw pajut taeyaxil japon. Samatabej, Dios naexasiti, japi chiekal sitaeyaxael Dios —aech Jesús Samaria tʉajnʉpijwaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Do jawʉt, jʉm-aechow: —Xan matabijtax Mesías fʉloeyaxoekpox, japon pawʉl Cristo. Japon fʉloek wʉt, puexa chiekal nakchanaekabʉanaxaelon —aechow. ");
INSERT INTO guoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Do jawʉt, Jesús jʉm-aech: —Xanlap japonan, nospaeipon, xam sʉapich —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Do jawʉt, xanal, japon pejnachalwan, patx japonxot. Natachaemax wʉt, nejchaxoelanuilxbej, Jesús nospaei xot, pawis sʉapich. Pe xanal wʉajnachaems-enil, ma-aech xot Jesús nospaei, japow sʉapich. Wʉajnachaems-enilbej achaxliajwa nospaeipon, japow sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Do jawʉt, jaxot pejkʉarnat waelsnadoftow. Fʉlaechlisow paklowax poxade. Jaxotde pa'a wʉt, jʉm-aechow pejjiwliajwa: ");
INSERT INTO guoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Xabʉa't taeliajwam kaen aton, xan najʉm-aechpon puexa chajia isxpoxanliajwa! Japon bej Mesíasbej —aechow. ");
INSERT INTO guoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Do jawʉt, puexa japi jiw nakola paklowaxxot. Fʉlaenlisi Jesúslel. ");
INSERT INTO guoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jawʉtlejen, japi fʉlaen wʉtfʉk, xanal Jesús kaechato'ax naxaeyax xaeliajwapon. Jʉm-an japonliajwa: —Jiw chanaekabʉanan, ¡naxaeyax xaem! —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Do jawʉt, Jesús xanal najʉmnot wʉt, jʉm-aechon: —Amxot xabich tajnaxaeyax. Japanaxaeyax xamal matabija-emil —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jawʉt xanalkal nawʉajnachaemtax wʉt, jʉm-an: —Asan chajia bej xalwʉajxafosbejpon naxaeyax —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pe jawʉt, Jesús xanal najʉm-aech: —Jiw xael wʉt, chawʉlanejchachaemil. Xanlax nejchachaemlax, isx wʉt Dios nejxasinkpoxan, toetx xotbej isxpoxan, japon nato'apoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Xamal jʉm-am: ‘Naboela wʉt, we'p cuatro juimt jolaliajwa’ —am xamal. Pelax xan jʉm-an: ‘¡Tae'nik jiw fʉlaenpi! Puexa japi thiltlisi naewesliajwa Dios pejjamechan. Me-ama mʉthaspi jolaliajwa malisi pachaem, ja-aech japi jiw’ —an xan —na-aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jesús pejme xanal najʉm-aech: —Trigo jolpi moch wʉt, nejchachaemili, toet wʉti trigo jolax. Ja-aechlap-is Dios pejjamechan naewʉajanpi, asew jiw naexasit wʉt. Asamatkoi japibej xabich nejchachaemlaxael Diosxotse. Matxoelanaewʉajanpi Dios pejjamechan, japibej xabich nejchachaemlaxael. Puexa japi kaeyaxtat nejchachaemlaxael Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chajia jʉm-aechpox diachwʉajnakolax, jʉm-aech wʉtox: ‘Asew jiw matxoela pela. Do jawʉx, asew jiw wachakal pat jolaliajwa’ —aech wʉtox. (Japox jʉmchiliajwa: ‘Asew jiw matxoela naewʉajan Dios pejjamechan. Pe jawʉt, naeweti naexasis-el Dios pejjamechan. Do jawʉx, asew jiw pejme naewʉajnas wʉti, jawʉt japi jiw naexasitlisi chiekal Dios pejjamechan’ —chiliajwa japox.) ");
INSERT INTO guoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Xamal keto'ax jolaliajwam pela-emilxot. Asew jiw jaxot xabich matxoela nabist. Amwʉtjel pachaem xamal jolaliajwam, japi chiekal ti't xotlisi. Japox jʉmchiliajwa: ‘Xamal jiw naewʉajnam wʉt Dios pejjamechan, japi naexasisasia Dios pejjamechan. Majt japi jiw asew jiw naewʉajnas Dios pejjamechan. Amwʉtjel pachaem, xamal wʉajna asew jiw chajia naewʉajan xot Dios pejjamechan japatʉajnʉpijiwxot’ —chiliajwa japox —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Xabich Sicar paklowaxpijiw, Samaria tʉajnʉpijiw, naexasiti Jesús, japow chapaei xot Jesúsliajwa. Chajia jʉm-aechow: “Japon aton jʉm-aech xan puexa chajia isxpoxanliajwa” —aech xotow japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Do jawʉt, Samaria tʉajnʉpijiw fʉlaen Jesúslel. Jawʉt fiatipon namanaliajwa japixot. Samata, Jesús jaxot naman kolematkoije. ");
INSERT INTO guoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesús pajut jiw naewʉajan wʉt, xabich kaes jiw naeweti naexasichbejpon. ");
INSERT INTO guoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Do jawʉt, japatʉajnʉpijiw jʉm-aechi japowliajwa: —Amwʉtjel xanal naexasitx wʉt Jesús, xanal naexasis-enil xam nachapaeyampoxkalliajwa japonliajwa. Pe amwʉtjel, xanal tajut chiekal jʉmtaenx xot, Jesús pajut jʉm-aech wʉt, japon naexasitx. Samata, chiekal matabijtax japon Jesús diachwʉajnakolax Cristo, bʉ'weliajwapon ampathatpijiw —aech japi jiw japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kolematkoije xent wʉt, Jesús chijia wʉt Sicar paklowaxxot, xanalbej, japon pejnachalwan, chijian, japon sʉapich. Fʉlaechx Galilea tʉajnʉ poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Galilea tʉajnʉ poxandax wʉt, xanal nejchaxoelx Jesús chajia jʉm-aechpoxanliajwa, pajutliajwa chajia jʉm-aech wʉt xanalliajwa: “Profetas sitaens popaklowaxanpijiw. Pelax pejtʉajnʉkolaxpijiw sitae-esal” —aech Jesús, jʉm-aech wʉt xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Xanal patx wʉt Galilea tʉajnʉxot, japatʉajnʉpijiw xabich nejchachaemil, taen wʉti Jesús. Samata, chiekal bʉ'kʉltipon, chajia taenxotipon, Pascuafiesta wʉt Jerusalén paklowaxxot. Japi taen, Jesús koechaxan is wʉt jaxotde. Samata, xabich nejchachaemili. ");
INSERT INTO guoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Do jawʉx, Jesús, xanal sʉapich, kaxa nawenx Caná paklowax poxadin, Galilea tʉajnʉxot. Jaxot majt Jesús mint vino dofapon. Xanal jaxotan wʉt, kaen aton pat. Japon reyliajwa nabistpon. Japonbej paklon. Japon paxʉlan xabich bʉ'xaenk Capernaum paklowaxxot. ");
INSERT INTO guoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Japon aton jʉmtaen wʉt Jesús patpox Galilea tʉajnʉxot, do jawʉt japon, fʉlaen Jesús taeliajwa. Japon aton faen wʉton Jesús, tadʉton Jesús nakfʉlaeliajwas japon pejba poxade, paxʉlan weboejthʉsliajwas, paxʉlan mox pawʉajna xot tʉpaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Do jawʉt, Jesús jʉm-aech: —Xamal nanaexasisaximil, xan is-enil wʉt koechaxan xamal taeliajwam —aech Jesús japon atonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Do jawʉt, reyliajwa nabistpon jʉm-aechon Jesúsliajwa: —Tajpaklon, ¡xabʉa't xan nakfʉlaeliajwam, taxʉlan tʉpax wʉajna pasliajwam! —aech japon aton, reyliajwa nabistpon. ");
INSERT INTO guoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Do jawʉt, Jesús jʉm-aech: —¡Nawia'mich nejba poxade! Naxʉlan chiekal boejthʉslison —aech Jesús japonliajwa. Japon aton naexasit Jesús jʉm-aechpox. Samata, nawia'apon pejba poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Reyliajwa nabistpon fol wʉtfʉk, jawʉt pamak fʉlaen japon pejbaxot bʉ'kakʉlnaliajwapi nʉamtat. Do jawʉt, nʉamtat xabʉ'kakʉlt, jʉm-aechi pejpaklonliajwa: —Naxʉlan chiekal boejthʉslison —aechi pejpaklonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Japon wʉajnachaemt wʉt, jʉm-aechon: —¿Achahora wʉtkat wʉajach naweboejthʉs? —aechon. Japi jʉmnot wʉt, jʉm-aechi: —Boejthʉson kaeliw, juimt matnoch ek wʉt —aechi pejpaklonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Do jawʉt, japon nejchaxoel. “Kaeliw, juimt matnoch ek wʉt, Jesús xan najʉm-aech: ‘Naxʉlan chiekal boejthʉslison’ —na-aech Jesús xanliajwa” —aechon, nejchaxoel wʉt. Samata, japon, puexa pejjiw sʉapich, bʉ'naexasiton Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Japox Jesús is Galilea tʉajnʉxot, wʉchakalkoechax, nawia'an wʉt Judea tʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baxael, asamatkoi, judíos fiesta is wʉt, Jesús fʉlaech Jerusalén paklowax poxade, japafiesta naktaeliajwapon. ");
INSERT INTO guoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén paklowaxxot, jaxot cha-aelpukach. Japox poejiw ispox, pawʉlox Betzata hebreojametat. Jaxot mox leliajwa paklowax poxadin, ovejas laleyaxxot. Japapukachjʉmbʉ'tat cinco bachan, cha-aelbax, chalak. ");
INSERT INTO guoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Japabachantat xabich jiw, bʉ'xaeya, oel. Itliakla, laelpaxilpibej, mamalpibej, japi cha-aelbachantat oel. ");
INSERT INTO guoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Dios pej-ángel papaska cha-aelpukach poxasik. Pat wʉt, min itjuiyapon pukach truxnaliajwa. Min truxan wʉt, matxoelafʉlaekpon minadik, japon chiekal nejmachwaxae boejthʉs. Samata, japi jiw wʉajnawet pukach truxnax. ");
INSERT INTO guoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jiw bʉ'xaeyaxot, japixotbej kaen aton. Japon laejaxil. Japon laeja-elpoxlis, treinta y ocho waechanlisox. ");
INSERT INTO guoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús jaxot pat wʉt, taenon japon nabejkan, laeja-elpon. Jesús matabijt wʉt japon aton nabijatox, laeja-el xoton pin-iawaechan, jawʉt Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Xamkat laejasiam? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Laeja-elpon jʉmnot wʉt, jʉm-aechon Jesúsliajwa: —Jiw chanaekabʉanan, xan chiekal tamachpijnan. Ajil taj-aton minadik nabʉflaeliajwa, pukach truxan wʉt. Xan fʉlaesian wʉt minadik, asan aton matxoela jifʉlaek minadik —aech japon aton. ");
INSERT INTO guoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús jʉm-aech laeja-elponliajwa: —¡Nande! ¡Sumta-okampox fi'e! ¡Laejimbej! —aech Jesús laeja-elponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Do jawʉt, japon aton chalechkal chiekal pachaempon. Sumta-okpox fit wʉt, xalaechlison. Japamatkoi napatamatkoi. ");
INSERT INTO guoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Samata, judíospaklochow japox taen wʉt, jʉm-aechi boejthʉchponliajwa: —Ampamatkoi, napatamatkoi, Moisés chajia lelpox tapae-el sumta-okampox xalaejaliajwam, napatamatkoi xot —aech judíospaklochow boejthʉchponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Japon aton jʉmnot wʉt, jʉm-aechon: —Naboejthʉtpon najʉm-aech: ‘¡Sumta-okampox fi'e! ¡Laejimbej!’ —na-aechon —aech boejthʉchpon. ");
INSERT INTO guoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Samata, japi wʉajnachaemt wʉt, jʉm-aechi: —¿Achankat xam jʉm-aech: ‘¡Sumta-okampox fi'e! ¡Laejimbej!’ —aechkat? —aech paklochow boejthʉchponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pe japon matabijs-el, achan boejthʉchpon, jaxot xabich xot jiw. Jesúsbej jaxot chijialison. ");
INSERT INTO guoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Baxael, Jesús pejme faen japon aton Dios pejtemplobaxot. Jawʉt Jesús jʉm-aech: —Amwʉtjel xam chiekal pachaemam. ¡Chiekal taem! ¡Kaes nabej is babijaxan, kaes xabich pejme nabijasasamatam! —aech Jesús japon atonliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Do jawʉx, japon aton fʉlaech wʉt, faenpon judíospaklochow. Jawʉt jʉm-aechon japiliajwa: —Xan naboejthʉtpon chiekal laejaliajwan, pesal japon Jesús —aech japon aton judíospaklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Samata, judíospaklochow japox jʉmtaen wʉt, xabich palalapi Jesúsliajwa. Do jawʉx, japi judíospaklochow faen wʉti Jesús, japi tasala Jesús, boejthʉt xoton napatamatkoitat. ");
INSERT INTO guoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pe Jesús jʉm-aech japiliajwa: —Dios, taj-ax, japon jiw kajachawaet pomatkoicha. Me-ama taj-ax, ja-anbej xan. Samata, xanbej jiw kajachawaetx pomatkoicha —aech Jesús japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesús japox jʉm-aech wʉt, judíospaklochow xabich kaes pejme palalapi Jesúsliajwa. Samata, jawʉt boesasiapi Jesús, boejthʉt xoton napatamatkoitat. Jawʉt xabich boesasiabejpi Jesús, Jesús jʉm-aech xot: “Dios, taj-ax” —aech xoton. Japox jʉm-aech wʉt, jʉmchiliajwa pajut: “Xan chiekal najʉpx, Dios sʉapich” —chiliajwapox. ");
INSERT INTO guoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús jʉm-aech judíospaklochowliajwa: “Diachwʉajnakolax xan jʉm-an. Xan, Dios paxʉlnan, tajut isasianpoxan xan isaxinil. Taenxpoxan, taj-ax ispoxan, japoxankal xan isfʉlax. ");
INSERT INTO guoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taj-ax Dios xan nanejxasink, xan japon paxʉlnan xot. Taj-ax puexa na-itpaei japon ispoxan. Na-itpaeyaxaelbejpon koechaxan kaes pejme pachaempoxan. Japoxan isx wʉt, xamal xabich nejchaxoelanuilaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Taj-ax xajʉp patʉpa mat-eliajwa, pejme japi jiw duilaliajwa. Xanbej, japon paxʉlnan, xajʉpx patʉpa mat-eliajwan pejme duilaliajwapi. Patʉpa mat-esian wʉt, japi mat-eyaxaelen pejme duilaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taj-ax Dios jʉmchi-elbej kaen atonliajwa: ‘Japon aton pejbʉ'wʉajan. Samata, japon kastikaxaes’ —chi-el taj-ax Dios. Xanlax taj-ax Dios nachaxdut pejpamamax jʉmchiliajwan puexa jiw pejbʉ'wʉajanpiliajwa: ‘Japi kastikaxaes, pejbʉ'wʉajan xot’ —chiliajwan, japon paxʉlnan xot. ");
INSERT INTO guoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Taj-ax Dios nachaxdut pejpamamax, xan Dios paxʉlnan xot, jiw nasitaeliajwa. Me-ama taj-ax Dios jiw sitaens, xanbej najachiyaxael, jiw nasitaen wʉt. Xan nasitae-elpi, japi jiwbej sitae-el taj-ax Dios, japon xan nato'apon ampathatasik. ");
INSERT INTO guoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Diachwʉajnakolax xan jʉm-an. Xan jʉm-anpoxan naewetpon, naexasit wʉtbejpon, xan Dios nato'akponan ampathatasik, japon aton pomatkoicha dukaxael Diosxotse. Japon aton tʉp wʉt, to'axisal kastikaliajwas infiernoxotdik. Japonlax pomatkoicha dukaxael Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Diachwʉajnakolax xan jʉm-an. Patlisox babijaxan ispi jʉmtaeliajwa tajjamechan, xan Dios paxʉlnanponan. Xan tajjamechan jʉmtaen wʉti, naexasit wʉtbejpi, xan kajachawaesaxaelen japi jiw pomatkoicha duilaliajwapi Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Taj-ax Dios duk pomatkoichaliajwa. Xanbej, Dios paxʉlnan, dukx pomatkoichaliajwa, taj-ax Diosxotse. Samata, xan xajʉpx jiw kajachawaesliajwan japi pomatkoicha duilaliajwa Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Xanbej puexa jiw pakoewkolnan. Samata, taj-ax nachaxdut pejpamamax, xan jiw jʉmchiliajwan pejbʉ'wʉajan wʉt, kastikaliajwas wʉtbej, babijaxan is wʉti. ");
INSERT INTO guoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amwʉtjel, jʉmtaenam wʉt xan jʉm-anpox, ¡xamal xabich nabej nejchaxoelanuile'! Asamatkoi pasaxael pejmatkoi puexa tʉpi jʉmtaeliajwa tajjame. ");
INSERT INTO guoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Samata, japi mat-eyaxaes pejmʉthanxot pejme duilaliajwa. Japi ispi pachaempoxan, ampathatat laelp wʉti, japilap duilaxael Diosxotse. Pelax babijaxan ispi, ampathatat laelp wʉt, japi kastikaxaes infiernoxotdik” —aech Jesús judíospaklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesús pejme jʉm-aech judíospaklochowliajwa: “Xan is-enil tajut isasianpoxan. Jiwliajwa jʉm-an wʉt: ‘Japi pejbʉ'wʉajan’ —an wʉt, japox jʉmchiyaxaelen taj-ax Dios pijaxtat. Samata, chiekal jʉm-an, xan jʉm-an wʉt jiw pejbʉ'wʉajanpoxanliajwa. Tajut jʉmchiyaxinil nejxasinkaxpoxan. Xan jʉm-an taj-ax Dios, nato'apon, nejxasinkpoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Xan tajutliajwa tajaxtat jʉm-ansax wʉt, japoxan omjilaxael asew jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pe asanlax jʉm-aech wʉt pachaempox xanliajwa, japon jʉm-aech diachwʉajnakolaxpox. ");
INSERT INTO guoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Xamal asew jiw to'am, japi Juan wʉajnachaemsliajwa xanliajwa. Juan jʉmnotpox xanliajwa, japox diachwʉajnakolax. ");
INSERT INTO guoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Xan nawewe'pa-el aton, japon jʉmchiliajwa xan jʉm-anpoxan: ‘Japon jʉm-aechpoxan diachwʉajnakolax’ —chiliajwapon xanliajwa. Xan japox jʉm-an xamal naexasisliajwam Juan jʉm-aechpox xanliajwa, xamal bʉ'weliajwan babijaxan isampoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan, jiw bautisan, me-ama lámpara itliakaliajwa. Japon pejnaewʉajnax, me-ama itliak xot xamalliajwa. Samata, japon xamal naewʉajan wʉt, xamal nejchachaemlam, jʉmtaenam wʉt japon naewʉajanpox asbʉan jʉmch kaejuimanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan jʉm-aechpox xanliajwa, japox pachaem. Pelax xan isxpoxan, japoxan kaes pejme pachaem jiw xan namatabijaliajwa. Xan amwʉtjel isxpoxan, japoxan taj-ax naketo'a isliajwan, jiw matabijaliajwa diachwʉajnakolax xan Dios nato'aponan. ");
INSERT INTO guoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taj-ax, xan nato'apon, japon pajut jʉm-aech xanliajwa: ‘Xam isampoxan xabich pachaem’ —aech taj-ax Dios. Xamal najut taj-ax pejjame jʉmtae-emil. Xamal najut tae-emilbej taj-ax. ");
INSERT INTO guoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dios pejjamechan namana-elbej nejnejchaxoelaxantat, xan nanaexasis-emil xot, xan taj-ax nato'aponan. ");
INSERT INTO guoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Xamal chiekal estudiam Dios pejjamechan, nejchaxoelam xot: ‘Dios pejjamechan chiekal estudiyax wʉt, matabijsaxaelen, machiyaxaelen Dios natapaeliajwa dukaliajwan pomatkoicha japonxotse’ —am, nejchaxoelam wʉt. Dios pejjamechan jʉm-aech xanliajwa. Xan tajaxtat jiw pomatkoicha duilaxael Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pe xamal nejxasinka-emil xanlel fʉlaeliajwam tajjiwaliajwam. Samata, xamal duilaximil pomatkoicha Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Xan nejxasinka-enil jiw najʉmchiliajwa: ‘Xam pachaemamponam’ —nachiliajwa xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Xan matabijtaxbej, ma-aech xamal nejnejchaxoelaxan. Xamal Dios nejxasinka-emil. ");
INSERT INTO guoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Fʉloekx taj-ax pijaxtat. Pe xamal xan nanaexasis-emil. Asamatkoi, asan aton pat wʉt pajut pijaxtat naewʉajnaliajwa, japon atonlax xamal naexasisaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Xamal nejxasinkam asew jiw jʉmchiliajwa xamalliajwa: ‘Xamal pachaemampim’ —chiliajwa. Pe xamal nejxasinka-emil kaen Dios jʉmchiliajwa xamalliajwa. ‘Xamal pachaemampim’ —chiliajwapon xamalliajwa. Samata, xan nanaexasis-emil. Dios naexasis-emilbej. ");
INSERT INTO guoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Xamalkas nejchaxoelam xan tasalaxaelenpox xamal taj-ax Dios pejwʉajnalel. Xan tajut xamal tasalaxinil. Xamal tasalaxaelpon, japon Moisés, xamal xanaboejampon. ");
INSERT INTO guoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Xamal chiekal naexasitam wʉt Moisés chajia lelpox, ja-aech wʉt, xanbej chiekal nanaexasisaxaelam, Moisés chajia lelpox jʉm-aech xot xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pe xamal naexasis-emil wʉt Moisés chajia lelpox, xamalbej nanaexasisaximil xan jʉm-anpoxan” —aech Jesús judíospaklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Do asamatkoi wʉt, xanal, Jesús pejnachalwan, Jesús sʉapich, chaflaechx Galilea puka we-enlelde. Japowa puka asawʉl, Tiberias puka. ");
INSERT INTO guoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Xabich jiw Jesús fʉlafos, taen xoti koechaxan, bʉ'xaeya boejthʉt wʉton. ");
INSERT INTO guoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Do jawʉt, Pascuafiesta isliajwa mox pawʉajna, judíos pejfiesta. Japamatkoitat, Jesús julach wʉt mʉax poxase, xanalbej, japon pejnachalwan, julachax japamʉaxase. Jaxotse ek wʉt, xanalbej jaxotse chalakx. ");
INSERT INTO guoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús taen wʉt xabich jiw fʉlafospox, jawʉt jʉm-aechon pejnachalan Felipeliajwa: —¿Amxotkat naxaeyaxan wʉajsaxaes ampi jiwliajwa? —aech Jesús Felipeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jasoxtat Jesús wʉajnachaemt Felipeliajwa Jesús matabijsliajwa, achax jʉmchiyaxael Felipe, jʉmnot wʉt. Jesúslax chajia matabijt isaxaelpox jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Do jawʉt, Felipe jʉmnot wʉt, jʉm-aechon Jesúsliajwa: —Jalape. Doscientos denarios xajʉpaxil pan wʉajsliajwas, ampi jiw kaenanʉla cha-aex xaeliajwa —aech Felipe Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Do jawʉt, Andrés, Jesús pejnachalan, japon Simón Pedro pakoewan, jʉm-aechon Jesúsliajwa: ");
INSERT INTO guoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ma amxot yamxʉlan cinco pan, cebadapanes, kolenje baxichbej. Japanaxaeyax kaechxajʉpaxil puexa jiw xaeliajwa —aech Andrés. ");
INSERT INTO guoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Do jawʉt, Jesús xanal, pejnachalwan, najʉm-aech: —¡Puexa jiw to'im chalakaliajwa! —aechon. Jaxot xabich pola pachaem chalakaliajwa. Samata, jaxot puexa jiw chiekal chalak. Chalakpi, me-ama kaes cinco mil poejiw. Watho' xajui-esal, yamxi sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Do jawʉt, Jesús panes not wʉt, Dios kawʉajan wʉt, jʉm-aechon: “Ax, gracias-an ampanaxaeyax xanal nachaxdutampox” —aech Jesús. Kawʉajnax bʉxtoet wʉt, xanal nachaxduwpon panes sasliajwan. Jawʉt xanal satx puexa chalakpiliajwa. Ja-aechbejpon baxichliajwa. Do jawʉt, xanal chaxduwx puexa jiw xaeliajwa, puexa xaesiapox. ");
INSERT INTO guoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Do jawʉt, puexa jiw chiekal nafnia wʉt, Jesús xanal najʉm-aech: —¡Naxaeyaxan namapi no'e napelsasamata! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Do jawʉt, xanal notx namapi. Wʉlʉx doce matpiran. Majt asbʉan jʉmch cinco pan. ");
INSERT INTO guoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Japi jiw taen wʉt koechax, Jesús ispox naxaeyaxanliajwa, nakaewa najʉm-aechi: —Diachwʉajnakolax ampon Dios pejprofeta. ‘Pasaxoekpon ampathatasik’ —tispon, japon patlison. Me-ama chajia lelspox jʉm-aech japonliajwa, diachwʉajnakolax ja-aechlisox —na-aechi nakaewa Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Do jawʉt, Jesús pajut matabijt japi jiw bʉflaesiaspox japon japi pejreyliajwa. Samata, jawʉt chijiapon japixot. Asalelaxach julpon mʉaxxot tamachaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tuila wʉt, xanal, Jesús pejnachalwan, fʉlaekx puka poxadik. ");
INSERT INTO guoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesús pas-el wʉtfʉk, xanal falkam julx, xabich tuila xot. Samata, tʉadutx chaliknaliajwan puka we-enlelde, pasliajwan Capernaum paklowax. ");
INSERT INTO guoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Do baxael, puka xabich pintruxan, xabich wik xot. ");
INSERT INTO guoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Xanal xabich faetx. Puka pafatatan wʉt, me-ama cinco kilómetros, do jawʉt, kaen aton taenx atʉaxach, fʉlaen wʉt minakal. Japon fʉlaen xanalleldin, falkamleldin. Xanal japon taenx wʉt, xabich belwax, matabija-enil xot japon Jesúspon, fʉlaen wʉton minakal. ");
INSERT INTO guoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Do jawʉt, Jesús najʉm-aech xanalliajwa: —¡Nabej nejlewle'! ¡Xanpe'! —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Do jawʉt, xanal nejchachaemlax, Jesús juldik wʉt xanal poxadik. Do jawʉtbej, kamta chapa'ax Capernaum paklowax. ");
INSERT INTO guoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Do kandiawa wʉt, jiw, namapi puka we-enlelde, japi jiw wʉlweklisi Jesús. Japi jiw taen xanalkal tamach, Jesús pejnachalwan, chaflaechpox kaeyax falkamtat. Do jaxot kaes asafalkam ajil. ");
INSERT INTO guoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Do jawʉt, asew jiw chapat falkammochantat. Japi chaflaen Tiberias paklowaxxotdin. Mox itjuli, Jesús panes chaxduwxot jiw xaeliajwa, Jesús Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Japi jiw matabija wʉt jaxot ajilpox Jesús, xanalbej ajinilpox jaxot, japi jiwbej jul falkammochan, Capernaum paklowax poxaliajwadin Jesús wʉlwekaliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Puka we-enleldin itjuldin wʉt, japi jiw taenlisi Jesús. Do jawʉt, japi jiw wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —Jiw chanaekabʉanan, ¿maswʉtkat xam amxot patam? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan jʉm-an. Xamal nawʉlwekam, chiekal nafniam xot, pan xaelam wʉt. Pe xamal matabija-emil, ma-aech xot xan koechaxan isx. Xan nanaexasis-emilbej. ");
INSERT INTO guoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","¡Nabej nabich naxaeyaxankalliajwa, japoxan asamatkoi toepaxael xot! ¡Nabisdelax naxaeyaxan toepaxilpoxanliajwa! Japoxanlap kaes pejme pachaem xamalliajwa, pomatkoicha duilaliajwam. Japoxanlap xamal chaxduiyaxaelen, xan, puexa jiw pakoewkolnan. Taj-ax Dios chajia nachaxdut pejpamamax puexa jiw chaxduiliajwan, naxaeyaxan toepaxilpoxan —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Japi jiw Jesús wʉajnachaemt wʉt, jʉm-aechi: —¿Achaxkat xanal nawewe'p isliajwan Dios nejxasinkpox? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús jʉmnot wʉt, jʉm-aechon: —Dios nejxasink xamal xan nanaexasisliajwam, xan Dios nato'aponan —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Do jawʉt, japi jiw pejme wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —¿Masox koechaxkat pejme isaxaelam xanal taeliajwan? Koechax isam wʉt, ja-aech wʉt, xam naexasisaxaelen diachwʉajnakolax xam Dios to'aponam. ");
INSERT INTO guoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wajwʉajnapijiw pajilaxtat wʉti, Moisés pijaxtat xaeli maná, me-ama Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox: ‘Pan athʉpijiw, pawʉli maná, chaxduws wajwʉajnapijiw, japi xaeliajwa’ —aechox. ¿Xamkat-is xajʉpam koechax isliajwam, me-ama Moisés is? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan jʉm-an. Moisés pajut chaxdui-el maná wajwʉajnapijiw xaeliajwa. Pe taj-ax Dios chaxduifʉl athʉpijiw, maná. Wajwʉajnapijiw maná xael wʉt, japi pomatkoicha duilaliajwa-el. Amwʉtjellax taj-ax to'ak athʉlelsik pan, diachwʉajnakolax athʉpijax. ");
INSERT INTO guoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Japapan Dios chaxdut, fʉloekpox athʉxotsik, ampathatpijiw japapan xael wʉt pomatkoicha duilaliajwa Diosxotse —aech Jesús pajutliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Japi jiw wʉljow wʉt, jʉm-aechi Jesúsliajwa: —Jiw chanaekabʉanan, ¡xanal nachaxduim japapan pomatkoicha duilaliajwan! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Do jawʉt, Jesús jʉm-aech: —Xanlap Dios pejpanan jiw bʉ'weliajwan pomatkoicha duilaliajwa Diosxotse. Xaelam wʉt naxaeyaxkal, asamatkoi xamal pejme litaxaelaxael. Minkal afam wʉtbej, xamal pejme minsilaxael. Xamallax xan nanaexasitam wʉt, pomatkoicha duilaxaelam pachaempoxtat. Ja-am wʉt, xamal, pejme litaxaelaxil. Minsilaxilbej. ");
INSERT INTO guoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pe xan jʉm-an xamalliajwa: ‘Xan koechax isx wʉt, xamal taenam. Pefʉk xamal xan nanaexasis-emil’ —an xan xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Puexa jiw, taj-ax nachaxduwpi, japikal koew xanlel fʉlaeyaxaen. Xan japi jiw mastaelaxinil. Japi jiw xanxotaxael tajnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Xan pas-enil ampathat poxasik tajut nejxasinkaxpoxan isliajwan. Xan paskax taj-ax Dios, nato'apon, nejxasinkpoxan isliajwan. ");
INSERT INTO guoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Taj-ax nejxasink chiekal tataeflaliajwan, nachaxduwpixot kaen wenafo'a-elaliajwas. Taj-ax nejxasinkbej japi jiw mat-eliajwan japi pejme duilaliajwa, that toep wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Taj-ax Dios nejxasink puexa jiw xan naxanaboejaliajwa, xan Dios paxʉlnan, japi jiw xan nanaexasit wʉtbej, japi pomatkoicha duilaliajwa Diosxotse. Taj-ax Dios nejxasinkbej xan japi mat-eliajwan pejme duilaliajwa, that toep wʉt —aech Jesús japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Do jawʉt, asew judíos nejweslapi Jesús. Jawʉt jʉm-aechi babejjamechan Jesúsliajwa, jʉm-aech xoton: “Xanlap Dios pejpanan, fʉloekxponan athʉxotsik” —aech xot Jesús pajutliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Japi nakaewa najʉm-aech Jesúsliajwa: —¿Amponkat Jesús, José paxʉlana-el? Xatis chiekal matabijas japon pax, penbej. ¿Ma-aech xotkaton pajutliajwa najʉm-aech: ‘Xan fʉloekxponan Diosxotsik?’ —na-aechkaton —aech japi jiw nakaewaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Do jawʉt, Jesús jʉm-aech judíosliajwa: —¡Bʉxkofim babejjamechan nakaewa najʉm-ampoxan xan jʉm-anpoxanliajwa! ");
INSERT INTO guoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xamal xanlel fʉlaeyaximil tajnachalwamliajwa, taj-ax Dios, japon nato'apon, xamal makanos-el wʉt. Taj-ax Dios xamal makanot wʉt, xamal mat-eyaxaelen pejme duilaliajwam, that toep wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios pejprofetasxot, japixot kaen chajia lelpox jʉm-aech: ‘Dios naewʉajnaxael xabich jiwliajwa’ —aech chajia lelspox. Samata, xamal naewetam wʉt, naexasitam wʉtbej taj-ax Dios jʉm-aechpox, ja-am wʉt, xamal fʉlaeyaxaemen xanlel tajnachalwamliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ampathatpijiw tae-eli taj-ax Dios. Xanlax kaenan taj-ax taenxponan, xan fʉloekx xot Diosxotsik. ");
INSERT INTO guoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Diachwʉajnakolax xan jʉm-an. Xamal chiekal xan nanaexasitam wʉt, pomatkoicha duilaxaelam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Xanlap, me-ama Dios pejpanan jiw bʉ'weliajwan, jiw pomatkoicha duilaliajwa Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chajiakolaxtat nejwʉajnapijiw xael maná, duilalap wʉt pajilaxtat. Xael wʉti maná, pomatkoicha ampathatat laelpaliajwa-el. Xabich pakdiachow wʉt, japi tʉp. ");
INSERT INTO guoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pe amwʉtjel, xan naksiyaxpan, fʉloekpox athʉxotsik. Aton, japapan xaelpon, japon Diosliajwa pomatkoicha laejaxaelon. ");
INSERT INTO guoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Xan fʉloekxponan athʉxotsik, xan japapanan. Jiw xan nanaexasit wʉt, japi pomatkoicha duilafʉlaxael Diosxotse. Chaxduiyaxaelenpan, japapan tajbʉ'tkolax. Xan tajut natapaeyaxaelen asajiw naboesaliajwa, ampathatpijiw bʉ'weliajwan” —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Do jawʉt, nakaejudíos najʉm-aechi, jʉmtaen wʉti Jesús jʉm-aechpox: —¿Machiyaxaelkat, nakchaxduiyaxael wʉton pejwit xatis xaeliajwas? —na-aechi nakaewa judíos. ");
INSERT INTO guoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús pejme jʉm-aech japi judíosliajwa: —Diachwʉajnakolax xan jʉm-an. Xae-emil wʉt tajwit, xan, puexa jiw pakoewkolnan, tajjal fe-emil wʉtbej, xamal pomatkoicha duilaximil Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tajwit xaeyaxaelpi, tajjalbej feyaxaelpi, japi jiw duilaxael pomatkoicha. Asamatkoi tʉp wʉti, japi jiw xan mat-eyaxaelen pejme duilaliajwa, that toep wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tajwitlap, me-ama poklanaxaeyaxkolax. Tajjalbej, me-ama poklamintkolat. ");
INSERT INTO guoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Japi jiw xael wʉt tajwit, af wʉtbejpi tajjal, japi duilaxael, xan sʉapich. Xanbej dukaxaelen pomatkoicha, japi sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Taj-ax Dios, nato'apon ampathatasik, japon duk pomatkoichaliajwa. Xanbej dukx pomatkoichaliajwa taj-ax pijaxtat. Jachiyaxaelbej tajwit xaelpi. Japibej pomatkoicha duilaxael xan tajaxtat Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Pan fʉloekpox Diosxotsik, me-ama maná, jachi-el. Chajiakolaxtat nejwʉajnapijiw maná xael pajilaxtat. Do baxael, japi xabich pakdiachow wʉt, tʉpafʉl. Maná xael wʉti ampathatat, pomatkoicha laelpaliajwa-el. Xan naksiyaxpox panliajwa, japapan xamal xaelam wʉt, pomatkoicha duilaxaelam Diosxotse —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús japoxan naewʉajan, judíos naewʉajnabatat wʉton, Capernaum paklowaxxot wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Do jawʉt, xabich jiw, fʉlnanʉamti Jesús, japox jʉmtaen wʉt, nakaewa najʉm-aechi: —Ampawʉajan xabich tampoel xatis jʉmmatabijaliajwas. Tampoelbej xatis naexasisliajwas. ¿Achankatlax xatisxot naexasisaxael Jesús naewʉajanpoxan? —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Do jawʉt, Jesús matabijt japi jʉm-aechpox babejjamechan japon naewʉajanpoxanliajwa. Samata, wʉajnachaemt wʉt, jʉm-aechon: —¿Japoxkat xamalliajwa chaemil, xan naewʉajnaxpox? ¿Xamalkat nejxasinka-emil japox? ");
INSERT INTO guoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Achaxkat xamal nejchaxoelaxaelam, taenam wʉt xan, puexa jiw pakoewkolnan, kaxa nawiasax wʉt Dios poxase? ");
INSERT INTO guoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu Santo pijaxtat jiw pomatkoicha duilaxael Diosxotse. Jiw pajut pijaxtat xajʉpaxil pomatkoicha duilaliajwa. Samata, ampathatat laelpam wʉtfʉk, xan jʉm-anpoxan naexasitam wʉt, Espíritu Santo kajachawaesaxael xamal pomatkoicha duilaliajwam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pe asew jiw xamalxot xan nanaexasis-elfʉk —aech Jesús fʉlafospiliajwa. Jesús chajia matabijt asew japixot naexasisaxisalpox. Matabijtbejpon, japixot achan wiasaxaeson asamatkoi padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús pejme jʉm-aechon fʉlafospiliajwa: —Xan chajia jʉm-an: ‘Jiw fʉlaeyaxildin xanlel tajnachalaliajwa, japi taj-ax Dios makanos-esal wʉt’ —an xan —aech Jesús fʉlafospiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Japox Jesús jʉm-aech wʉt, xabich jiw, Jesús fʉlafospi, waeltaslison. Do jawʉt, japi jiw kaes fʉlnanʉams-ellisi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Do jawʉt, Jesús wʉajnachaemt wʉt, jʉm-aechon doce pejnachalaliajwa: —¿Xamalkat-is xanxot chijiyasiam? ¿Me-ama asew jiw, jachisiamkat-is xamal? —aech Jesús pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Do jawʉt, Simón Pedro jʉmnot wʉt, jʉm-aechon Jesúsliajwa: —Jiw chanaekabʉanan, xamxot chijian wʉt, ¿achankat xanal naknanʉamsaxaelen? Xam kaenam, naewʉajnamponam, jiw pomatkoicha duilaxaelpox Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Xanal naexasitx xam Cristowamponam, Dios to'asponambej. Xanal chiekal matabijaxbej xam Dios paxʉlnampox, babijax is-emilponam —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Do jawʉt, Jesús jʉm-aech xanalliajwa: —Diachwʉajnakolax xamal makanotx, doce poejwam. Pe nakiowa, kaen xamalxot dep tato'las —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús japox jʉm-aech wʉt, jʉm-aechon Judasliajwa. Japon Simón Iscariote paxʉlan. Judastat, japontat, xanal dosan. Pe japon asamatkoi wiasaxaelon Jesús, Jesús padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Do jawʉx, Jesús nanʉamt Galilea tʉajnʉxot. Jesús wepachaema-esal nanʉamsliajwa Judea tʉajnʉxot, judíospaklochow wʉlweks xoton boesaliajwas. ");
INSERT INTO guoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pelis fiesta moxsfʉl, judíos pejfiesta. Japafiesta wʉt, judíos bʉa-antat duilalap. Japox ja-aechlap japi judíos nejkiowa-elaliajwa chajiakolaxtat pejwʉajnapijiw ispoxan, duil wʉt pajilaxtat. ");
INSERT INTO guoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Do jawʉt, Jesús pakoew jʉm-aechi Jesúsliajwa: —¡Xam amxot kaweta nabej namane'! ¡Xambej xabʉa'de Judea tʉajnʉ poxade, jaxotpijiw, xam nejnachalapi, taeliajwa koechaxan isam wʉt jaxotde! ");
INSERT INTO guoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Xam nejxasinkam wʉt xabich jiw matabijaliajwa, achanam xam, ja-aech wʉt, ¡maliach nabej is koechaxan! ¡Japoxan isde tulaela jiw pejwʉajnalel, puexa jiw chiekal taeliajwa! —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesús pakoew naexasis-esal japon Cristopon. Samata, japi japox asbʉan jʉmch jʉm-aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Do jawʉt, Jesús jʉm-aech pakoewliajwa: —Xanfʉk nawepas-el tajmatkoi fʉlaeliajwan Judea tʉajnʉ poxade. Xamalliajwa nejmachmatkoiyan pachaem nanʉamsliajwam. ");
INSERT INTO guoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ampathatpijiw xamal nejweslaxil. Xanlax japi jiw nanejwesla, tulaela itpaeix xot babijaxan ispoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","¡Xabʉa'de xamal fiesta poxade! Xanfʉk fʉlaeyaxinil japoxade, nawepas-el xotfʉk tajmatkoi fʉlaeliajwan japoxade —aech Jesús pakoewliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesús japox jʉm-aech wʉt, kaweta namanfʉkon Galilea tʉajnʉxot. ");
INSERT INTO guoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesús pakoew fʉlaech wʉt fiesta taeliajwa, do jawʉxbej, Jesús wachakal fʉlaech fiesta taeliajwa. Jesús maliach pat fiestaxot. Maliach paton jiw matabijsamatas japon patpox. ");
INSERT INTO guoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiesta wʉt, judíospaklochow wʉlweki Jesús. Japi jʉm-aech asew jiwliajwa: —¿Amxotkat japon aton, pawʉlpon Jesús? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dolisdo', fiesta wʉt, xabich jiw nakaewa najʉm-aech Jesúsliajwa. Asew japixot jʉm-aech: “Jesús xabich pachaem” —aechi. Asewlax japixot jʉm-aech: “Japon pachaema-el. Jiw naekichachajban pedo'” —aech asew Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pe japi jiw naksiya wʉt Jesúsliajwa, tulaela jʉmchi-eli, asew jiw jaxotpijiw jʉmtaesamatas, pejlewla xoti judíospaklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Do jawʉx, cuatro matkoi wʉt fiestapox, Jesús Dios pejtemploba low. Do jawʉt, jaxot tʉaduton jiw naewʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jawʉt judíos xabich natachaema, jʉmtaen wʉti Jesús naewʉajanpoxan. Nakaewa najʉm-aechi: —¿Ma-aech xotkat xabich matabijton Dios pejjamechan, japon pinjiyax estudia-el wʉt? —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús matabijt japi jʉm-aechpox. Samata, jʉm-aechon: —Tajnaewʉajnaxan tajut tajax-el. Dios nato'apon, japon nabʉxto'apoxan, japoxan xan naewʉajnax jiw. ");
INSERT INTO guoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xamal nejchaxoelam wʉt isliajwam Dios nejxasinkpoxan, najut matabijaxaelam, xan naewʉajnaxpoxan Dios pijaxan wʉt, o, xan tajut tajaxkal wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aton jʉm-aech wʉt pajut pijaxtat, japon xabichasia asew jiw sitaeliajwas. Xanlax jʉm-an diachwʉajnakolax taj-ax pijaxtat, asew jiw jʉmchiliajwa: ‘Dios xabich pachaem’ —chiliajwapi taj-axliajwa. Xan naekichachajba-enil, jʉm-an wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Chajiakolaxtat Moisés chaxduch Dios pejtato'laxan, wajwʉajnapijiwliajwa Moisés lelaliajwa japatato'laxan. Pe xamal amwʉtjel naexasis-emilfʉk japox. Japatato'laxanxot Dios tapae-el asan aton boesaliajwam. ¿Ma-aech xotkat amwʉtjel xamal xan nawʉlwekam naboesaliajwam?” —aech Jesús judíospaklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Do jawʉt, judíos jʉm-aech: —Xam na-acham, nejmatpʉatat dep ba xot. Samata, jasox xam jʉm-am. Xanal xam wʉlweka-enil boesaliajwan —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Do pejme Jesús jʉm-aech japi judíosliajwa: —Xamal xabich natachaemanuilam, xan isx wʉt kaeyax koechax napatamatkoitat. ");
INSERT INTO guoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés keto'a wajwʉajnapijiw circuncidaliajwa japi Dios pejmarkaxliajwa. Samata, xamal circuncidam puexa yamxi, poejiw, ocho matkoiyan wʉt nalaelapoxan. Japox Moisés pajut tʉadus-el. Waj-amjiw japox is Moisés wʉajna. Amwʉtjelfʉk xamal nakiowa yamxi circuncidam, ocho matkoiyan wʉt nalaelapoxan. Yamxʉlan nalaeltox ocho matkoi wʉt, japamatkoi napatamatkoi wʉt, xamal nakiowa yamxʉlan circuncidam japamatkoitat. ");
INSERT INTO guoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lach napatamatkoitat xamal nakiowa circuncidam yamxʉlan. Japox isam xamal naexasisliajwam Moisés chajia lelpox. Ja-am wʉt, ¿ma-aech xotkat xan nalala xanliajwa, kaen aton boejthʉtx wʉt napatamatkoitat? ");
INSERT INTO guoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Xamal taenam wʉt aton ispoxliajwa, ¡nejmach nabej jʉm-aeche': ‘Japon babijax is’ —nabej aeche', majt chiekal matabija-emil wʉtfʉk japon aton pejbʉ'wʉajanpoxliajwa! ¡Majt chiekal taemfʉk! Do jawʉx, diachwʉajnakolax japon aton pejbʉ'wʉajan wʉt, ¡jʉm-amde japon pejbʉ'wʉajanpoxliajwa! —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalén paklowaxxot duili, asew japixot nakaewa najʉm-aech Jesúsliajwa: —Ampon atonlap paklochow wʉlwekspon boesaliajwas. ");
INSERT INTO guoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pe Jesús tulaela jiw naewʉajan wʉt, chinax kaen aton jʉmchi-esal japon bʉ'wʉajanpoxliajwa. Jaels-esalbejpon. Paklochow bej jʉm-aechbej pejnejchaxoelaxantat: ‘Japon diachwʉajnakolax Cristo’ —bej aechbejpi. Samata, jaels-esal Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pe Cristo fʉlaen wʉt, xatis matabijaxisal amxot fʉlaeyaxaenon. Xatislax matabijas, amxot Jesús fʉlaen. Samata, Jesús Cristowa-el —aech asew judíos. ");
INSERT INTO guoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús japox jʉmtaen wʉt, Dios pejtemplobaxot naewʉajan wʉt, pinjametat jʉm-aechon: —¡Diachwʉajnakolax xamal namatabijtam xan! ¡Xamal chiekal namatabijambej, amxot xan fʉlaenx! Xan tajut tajaxtat fʉlae-enil. Xan fʉlaenx, taj-ax Dios nato'a xot. Dios naekichachajba-el. Dios jʉm-aech wʉt, diachwʉajnakolaxpox jʉm-aechon. Pe xamal matabija-emil Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Xanlax matabijtax Dios, fʉloekx xot Diosxotsik. Japon xan nato'a ampathatasik fʉlaeliajwansik —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesús japox jʉm-aech wʉt, judíos jaelsasiapi Jesús, jiw jebatat jeliajwaspon. Pe japi judíos jaelsaxilfʉk, Jesús wepas-esal xot pejmatkoi. ");
INSERT INTO guoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pe xabich jiw jaxot naexasiti Jesús naewʉajanpox. Samata, japi jiw jʉm-aech Jesúsliajwa: —Ampon Cristo, Dios to'aspon. Kaes asan aton ajil koechaxan ispon, me-ama ampon aton, jason —aech xabich jiw Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Do jawʉt, fariseos jʉmtaen wʉti jiw jʉm-aechpox Jesúsliajwa, jawʉt fariseos, sacerdotespaklochowbej, to'api Dios pejtemploba weti, japi jaelsliajwa Jesús. Pe japi jaels-el Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Dolisdo', Jesús jʉm-aech judíosliajwa: —Xamalxotaxaelen asbʉan jʉmch kaematkoiyanliajwa. Do jawʉx, xan kaxaxoeyan nato'apon poxase. ");
INSERT INTO guoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jawʉt, xan ajinil wʉt, xamal nawʉlwekaxaelam. Pe nafaenaximil, fʉlaeyaximil xot xan dukaxaelenxotse —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Do jawʉt, judíos nakaewa nawʉajnachaemt wʉt, najʉm-aechi: —¿Ampoxade Jesús fʉlaeyaxaechkat xatis japon faena-elaliajwas, wʉlweks wʉt? Jesús bej fʉlaeyaxaechbej asew judíos poxade, asatʉajnʉchanlel duili poxade. Jesús bej naewʉajnaxaelbej asatʉajnʉchanpijiw, japi judíos-eli. ");
INSERT INTO guoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Achaxkat jʉmchiyaxael, Jesús jʉm-aech wʉt: ‘Jawʉt, xan ajinil wʉt, xamal nawʉlwekaxaelam. Pe nafaenaximil, fʉlaeyaximil xot xan dukaxaelenxotse’ —aech wʉtkat Jesús? —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","We'p wʉt kaematkoi fiesta toepaliajwa, japamatkoi judíosliajwa kaes pejme pachaem. Samata, japamatkoi jiw kaes pejme sitaen. Do jawʉt, Jesús nant wʉt, pinjametat jʉm-aechon: —Xamal xabich minsila wʉt, kaes Dios matabijasiam wʉtbej, ¡xabʉa'din xanlel! ");
INSERT INTO guoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dios pejjamechan, chajia lelspox, jʉm-aech Dios jʉm-aechpox: ‘Xan naexasiti, japi pejnejchaxoelaxan, me-ama min nakakolsanpox satxotsin, ja-aech’ —aechox —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús jʉm-aech wʉt min nakakolsanpoxliajwa satxotsin, japox jʉm-aechon Espíritu Santoliajwa. Japon pejwʉajan naexasisaxaelpi, japi pejmatpʉatanxot pasaxoek Espíritu Santo. Jawʉt, Jesús japox jʉm-aech wʉt, Espíritu Santo fʉlae-elsikfʉk Jesús naexasitixotsik, Jesús athʉ poxa-else xotfʉk to'aliajwapon Espíritu Santo. ");
INSERT INTO guoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Asew jiw japixot jʉmtaen wʉt Jesús jʉm-aechpox, nakaewa najʉm-aechi: —Diachwʉajnakolax Jesús, ‘Dios pejprofeta, fʉlaeyaxaelpon’ —tispon —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Asew jiwbej nakaewa najʉm-aech: —Ampon Cristo, Dios to'aspon —na-aechi nakaewa. Asew jiwlax Jesúsliajwa jʉm-aech: —¡El! ¡Japon Cristowa-el! Cristo Galilea tʉajnʉpijnaxil. ");
INSERT INTO guoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox: ‘Cristo rey David pamonaxael. Nalaelsaxaelbejpon Belén paklowaxxot, David majt dukxot’ —aech chajia lelspox —aech asew jiw. ");
INSERT INTO guoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Samata, jiw kaenejchaxoelaxa-el Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Asew japixot jaelsasiapi Jesús jeliajwa jiw jebaxot. Pe japi jaels-eli Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Do jawʉx, Dios pejtemploba weti nawia fariseos poxade, sacerdotespaklochow poxadebej. Dios pejtemploba weti pat wʉt, jʉmtispi, wʉajnachaemtas wʉt: —¿Amekat bʉ'patam Jesús? —tispi. ");
INSERT INTO guoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dios pejtemploba weti jʉmnot wʉt, jʉm-aechi: —Japon jʉm-aech chimiajamechan. Me-ama asew jiw jʉm-aech wʉt, jachi-elon. Samata, xanal japon jaels-enil xamallel bʉflaeliajwan —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Do jawʉt, fariseos jʉm-aech: —¿Xamalkat-is naexasitam naekichachajbapijin jʉm-aechpoxan? ");
INSERT INTO guoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Paklochowxot ajil, Jesús jʉm-aechpoxan naexasiti. Fariseosxotbej ajil. ");
INSERT INTO guoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jesús naexasiti, japi jiw matabija-el Moisés chajia lelpox. Samata, Dios kastikaxaesi —aech fariseos Dios pejtemploba wetiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, japon fariseo-aton, majt madoi fʉlaechpon Jesús taeliajwa, jawʉt jʉm-aechon fariseosliajwa: ");
INSERT INTO guoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Moisés chajia lelpox nakjʉm-aech: ‘Kamta to'aximil aton kastikaliajwas, majt chiekal matabija-emil wʉtfʉk japon aton bʉ'wʉajanpoxliajwa. Majt chiekal jʉmtaeyaxaelamfʉk babijax ispon, naksiya wʉt xamalliajwa japon ispoxliajwa’ —aechox —aech Nicodemo nakaefariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Fariseos jʉmnot wʉt, jʉm-aechi Nicodemoliajwa: —¿Xamkat-is Galilea tʉajnʉpijnam? ¡Xam xabich estudiam Dios pejjamechan, chajia lelspox! Ja-am wʉt, xam matabijsaxaelam, Galilea tʉajnʉpijiwxot Dios pejprofetas chiekal ajil —aech fariseos Nicodemoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Do jawʉt, kaenanʉla fariseos nawia pejbachan poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jawʉt, Jesús Olivonaechanmʉax poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kandiawa wʉt, itliakafʉl wʉt, Jesús kaxadin Dios pejtemploba poxadin. Do xabich jiw mox soepa Jesúsxot. Jesús ek wʉt, tʉaduton jiw naewʉajnaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Do jawʉt, judíos chanaekabʉanapi, fariseosbej, bʉflaeni kaeow pakmolow Jesúsleldin. Japow faens, asan aton nakmoejt wʉt. Japon aton japow pamla-el. Do jawʉt, notipow puexa jiw pejwʉajnalel, Jesús wʉajnalelbej. ");
INSERT INTO guoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Japi jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, ampow, pakmolow, faens, asan aton bʉ'moejt wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés chajia lelpox jʉm-aech: ‘Watho', jasox ispi, ia'tat dadaepaxtat matkaejabaxaesi’ —aechox. ¿Achaxkat xam jʉmchiyaxaelam japoxliajwa? —aechi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jasoxtat japi xapaejt Jesús, asax jʉm-aech wʉt tasalaliajwapi Jesús. Pe Jesús natxatdik wʉt, pejkothiyatat sat lelon. ");
INSERT INTO guoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Japi nakiowa japox kaeyax wʉajnachaemsfʉl. Do jawʉt, Jesús mat-et wʉt, jʉm-aechon: —Xamalxot kaen aton chinax babijax is-el wʉt, ¡japon aton ia'tat nej matxoeladaeppon japow! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Do jawʉt, Jesús pejme natxatdik pejkothiyatat sat lelaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Japi jʉmtaen wʉt Jesús jʉm-aechpox, kaenanʉla chijiasfʉllisi japowxot. Kaes chiekal pakdiachowpi matxoela chijiasfʉl. Do jawʉx, wachakal chijiasfʉl pansiachowpi. Do jawʉt, tamach waelti japow, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús mat-et wʉt, wʉajnachaemt wʉt, jʉm-aechon japowliajwa: —Pawis, ¿amxotkat xam jʉm-aechpi nejbʉ'wʉajanpoxliajwa? ¿Japixotkat kaen xam daep-el ia'tat? —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Japow jʉmnot wʉt, jʉm-aechow: —Tajpaklon, amxot japi jiw ajillisi —aechow. Do jawʉt, Jesús jʉm-aech japowliajwa: —Xanbej to'axinil xam kastikaliajwa nejbʉ'wʉajanpoxliajwa. ¡Xabʉa'de nejmach! ¡Kaes nabej is babijaxan! —aech Jesús japowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Do jawʉx, Jesús pejme naewʉajan wʉt, jʉm-aechon jiwliajwa: —Xan ampathatpijiw kajachawaetx japi matabijaliajwa Dios. Samata, xan, me-ama itliakax jiwliajwa. Xan nanaexasiti, japi jiw kaes nej is-ele' babijaxan. Jasoxtat xan kajachawaesaxaelen jiw matabijaliajwa diachwʉajnakolaxpox, japi chiekal duilaliajwa ampathatxot —aech Jesús jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Do jawʉt, fariseos jʉm-aechi Jesúsliajwa: —Xam najut japox naksiyam. Samata, xanal matabija-enil, xam diachwʉajnakolax paeyam wʉt —aech fariseos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús jʉmnot wʉt, jʉm-aechon fariseosliajwa: —Xan tajut japox naksiyax wʉt, diachwʉajnakolaxpox jʉm-an. Xan tajut matabijtax amxot fʉlaenx. Pejme japoxaxaelen. Xamallax matabija-emil japox. ");
INSERT INTO guoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Xamal nijaxtat xanliajwa jʉm-am: ‘Japon nej kastikas, is xoton babijaxan’ —am xamal xanliajwa, chiekal matabija-emil wʉt. Xanlax jasoxtat jʉmchi-enil jiw pejbʉ'wʉajanpoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pe jʉm-an wʉt jiw pejbʉ'wʉajanpoxanliajwa, xan jʉmchiyaxaelen diachwʉajnakolaxtat. Tajut japox jʉmchi-enil jiw pejbʉ'wʉajanpoxanliajwa. Nato'apon, japon taj-ax, nakajachawaesaxael, xan jiw jʉmchiliajwan wʉt japi pejbʉ'wʉajanpoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisés chajia lelpox jʉm-aech xamal chiekal matabijaliajwam: “Kolenje kaeyax chiekal jʉm-aech wʉt asan aton ispoxliajwa, ja-aech wʉt, japox diachwʉajnakolax” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Xan tajut tajaxtat jʉm-an wʉt isxpoxanliajwa, taj-ax, japon xan nato'apon, japonbej japox kaeyax jʉm-aech xan isxpoxanliajwa —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Do jawʉt, fariseos wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —¿Amxotkat nej-ax? —aechi. Jesús jʉmnot wʉt, jʉm-aechon: —Xamal xan namatabija-emil. Matabija-emilbej taj-ax. Xan namatabijaxaelam wʉt, ja-am wʉt, matabijaxaelambej taj-ax —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús japoxan jʉm-aech wʉt, nukon ofrenda jiaxot, Dios pejtemplobatat. Pe Jesús jaels-esal paklochow, jiw jebaxot jeliajwas, pejmatkoi wepas-esal xotfʉkon. ");
INSERT INTO guoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús pejme jʉm-aech judíosliajwa: —Xan pejme nawiasaxaelen wʉt fʉlaenxot, xamal nawʉlwekaxaelam. Pe xamal tʉpaxaelam babijaxan isampoxantat Dios beltae-el wʉt. Samata, pasaximil xan jaxotaxaelenxot —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Do jawʉt, judíos nakaewa najʉm-aech: —¿Jesúskat pajut bej nakijsaxaelbej? Samata, jʉm-aechon japox: ‘Pasaximil xan jaxotaxaelenxot’ —aechon —aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús pejme jʉm-aech: —Xamal ampathatpijwamkal. Xan ampathatpijna-enil. Xan athʉpijnan. ");
INSERT INTO guoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Samata, jʉm-an: ‘Xamal tʉpaxaelam babijaxan isampoxantat, Dios beltae-el wʉt’ —an xan, naexasis-emil xot, xan jʉm-an wʉt tajutliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Do jawʉt, japi wʉajnachaemt wʉt, jʉm-aechi: —¿Achanamkat xam? —aechi. Jesús jʉmnot wʉt, jʉm-aechon: —Xan naewʉajnax wʉt, chajia jʉm-an, achanan xan. ");
INSERT INTO guoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Xan xabich xamal jʉmchiliajwan nejbʉ'wʉajanpoxanliajwa. Pe xan jʉmchiyaxinil. Jʉmchiyaxaelenlax ampathatpijiwliajwa taj-ax Diosxot jʉmtaenxpoxankal. Kaes pejme asaxan jʉmchiyaxinil. Dios, xan nato'apon, jʉm-aech diachwʉajnakolax —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Japi jiw jʉmtaen Jesús jʉm-aechpox. Pe japi jʉmmatabija-el, Jesús jʉm-aechpox pax Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Samata, Jesús pejme jʉm-aech judíosliajwa: —Xan, puexa jiw pakoewkolnan, asajiw cruztat nakematamatal wʉt, jawʉt xamal chiekal matabijaxaelam xan diachwʉajnakolax Cristowanponan. Matabijaxaelambej puexa xan isxpoxan, japoxan tajut tajaxtat is-enil. Xamalbej matabijaxaelam puexa xan jʉm-anpoxan, japoxan jʉm-an, taj-ax Dios nabʉxto'apoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Taj-ax, xan nato'apon, japon pomatkoicha xanxot. Tamach nawaels-elon, isfʉlax xot japon nejxasinkpoxan —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Japox Jesús jʉm-aech wʉt, xabich jiw chiekal naexasiti japon Cristopon. Japi jiw chiekal xanaboejabejpi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús jʉm-aech asew judíosliajwa, japi cha-aex naexasiti japon Cristopon: —Naexasisfʉlam wʉt xan naewʉajnaxpox, ja-am wʉt, diachwʉajnakolax tajnachalwaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xamal chiekal matabijam wʉt diachwʉajnakolaxpox, xan jʉm-anpox, ja-am wʉt, xamal kaes esclavosximil —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Judíos japox jʉmtaen wʉt, jʉm-aechi Jesúsliajwa: —Xanal Abraham pamojiwan. Chinax xanal esclavos-enil. ¿Ma-aech xotkat xanal najʉm-am: ‘Xamal kaes esclavosximil’ —na-amkat xanalliajwa? —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús jʉmnot wʉt, jʉm-aechon japi judíosliajwa: —Diachwʉajnakolax xan jʉm-an. Puexa jiw, babijaxan ispi, japi jiw, me-ama esclavos wʉt, ja-aechi, kofa-el xoti babijaxan ispoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Esclavo-aton pomatkoicha dukaxil paklon pejbatat, japon paklon paxʉlna-el xot. Paklon paxʉlanlax dukaxael pomatkoicha pax pejbatat, japon paklon paxʉlan xot. ");
INSERT INTO guoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Samata, xan Dios paxʉlnan jiw bʉ'weyaxaelen, japi xan nanaexasit wʉt. Beltaeyaxaelenbej japi babijaxan ispoxanliajwa. Ja-aech wʉt, japi diachwʉajnakolax bʉ'wʉajanjilaxael babijaxan ispoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Xan matabijtax diachwʉajnakolax xamal Abraham pamojiwam. Pe xamal nejchaxoelam xan naboesaliajwam, naexasis-emil xot tajnaewʉajnax. ");
INSERT INTO guoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Xan jʉm-ansfʉlax taj-ax na-itpaeipoxan. Pelax xamal isfʉlam nej-ax tato'alpoxan —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Do jawʉt, japi judíos jʉm-aech Jesúsliajwa: —Xanal Abraham pamojiwan. Japon, me-ama taj-ax xanalliajwa —aech judíos. Jesús pejme jʉmnot wʉt, jʉm-aechon judíosliajwa: —Diachwʉajnakolax xamal Abraham pamojiwam wʉt, xamal isaxaelam pachaempoxan Diosliajwa. Me-ama nej-am Abraham chajiakolaxtat is Dios nejxasinkpoxan, xamalbej jachiyaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Xan jʉm-an diachwʉajnakolaxpox xamalliajwa, Dios na-itpaeipox. Pe nakiowa, xamal nejchaxoelam xan naboesaliajwam. ¡Wajwʉajnapijin Abraham chinax jasox nejchaxoela-el, xamal nejchaxoelampox! ");
INSERT INTO guoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Xamalbej isam, me-ama nej-ax is —aech Jesús judíosliajwa. Jawʉt judíos jʉm-aech Jesúsliajwa: —Xanal pafliachxiya-enil. Xanal kaen taj-ax. Japon Dios. Diachwʉajnakolax xanal Dios paxin —aech judíos. ");
INSERT INTO guoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús jʉmnot wʉt, jʉm-aechon judíosliajwa: —Diachwʉajnakolax Dios nej-ax wʉt, xan nanejxasinkaxaelam, xan fʉloekx xot Diosxotsik. Amwʉtjel xamalxotx, Dios nato'a xot. Tajut tajaxtat fʉlae-enil. ");
INSERT INTO guoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ma-aech xotkat tampoel tajjamechan xamal jʉmmatabijaliajwam? Tampoel tajnaewʉajnaxan, nejxasinka-emil xot chiekal nanaewesliajwam. ");
INSERT INTO guoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Pe xamal nej-axpon, japon Satanás. Japon pejjiwambej. Isasiam nej-ax nejxasinkpoxan. Akaseskolaxtat Satanás bapon jiw. Amwʉtjel nakiowa ja-aechfʉlon. Nejxasinka-elbejpon diachwʉajnakolaxpox. Jʉmchi-elbejpon diachwʉajnakolaxpox. Japon jʉm-aech wʉt, jʉm-aechon naekichachajbaliajwa, naekichachajbapijin xot. Satanáslap matxoelanaekichachajbapijin. ");
INSERT INTO guoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pelax xan jʉm-an xot diachwʉajnakolaxpox, xamal xan nanaexasis-emil. ");
INSERT INTO guoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Xamalxot, ¿achankat nataen xan tajbʉ'wʉajanpox? Xan jʉm-an wʉtlax diachwʉajnakolaxpox, ¿ma-aech xotkat xamal xan nanaexasis-emil? ");
INSERT INTO guoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios pejjiwpi, japi jiw chiekal naewet Dios pejjamechan naexasisliajwa. Pe xamal Dios pejjiwa-emil xot, nejxasinka-emil naewesliajwam Dios pejjamechan —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Do jawʉt, judíos jʉm-aech Jesúsliajwa: —Xanal jʉm-an wʉt xamliajwa: ‘Xam Samaria tʉajnʉpijnam. Xambej nejmatpʉatat dep webaponam’ —an wʉt, diachwʉajnakolax xanal jʉm-an —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon judíosliajwa: —Xan tajmatpʉatat dep chiekal ajil. Xan sitaenx taj-ax Dios. Pe xamallax xan nasitae-emil. ");
INSERT INTO guoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Xan wʉlweka-enil sitaeyax tajutliajwa. Pelax taj-ax, Dios, nejxasink jiw xan nasitaeliajwa. Dios jʉmchiyaxaelbej pachaempoxan xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Diachwʉajnakolax xan jʉm-an. Xan jʉm-anpoxan naexasiti, japi tʉpaxil —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judíos japox jʉmtaen wʉt, jʉm-aechi: —Amwʉtjel xanal chiekal matabijax, diachwʉajnakolax xam nejmatpʉatat dep weba. Abraham, asew Dios pejprofetaspibej, puexa japi chajia tʉp. Xamlax jʉm-am: ‘Xan jʉm-anpoxan naexasiti, japi tʉpaxil’ —am xam. ");
INSERT INTO guoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Xamkat kaes pejme paklonam? ¿Me-ama wajwʉajnapijin Abraham, jachi-emilkat xam? Japonbej chajia tʉp. Puexa Dios pejprofetaspi, japibej chajia tʉp. Xam najutliajwa nejchaxoelam wʉt, ¿achanamponam xam? —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús jʉmnot wʉt, jʉm-aechon: —Xan tajutliajwa jʉm-an wʉt pachaempox, japox xanliajwa pachaemaxil. Pe taj-ax pajut xan nasitaen. Japonliajwa xamal najut jʉm-am: ‘Japon tajDios’ —am xamal. Pebej japon xan taj-ax. ");
INSERT INTO guoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pe xamal matabija-emil Dios. Xanlax chiekal matabijtax Dios. Xan jʉm-an wʉt: “Xan matabijs-enil Dios” —an wʉt, ja-an wʉt, xan naekichachajbaxaelen xamal. Me-ama xamal, jachiyaxaelen. Diachwʉajnakolax xan chiekal matabijtax taj-ax Dios. Japon pejjamechan chiekal naexasisfʉlaxbej. ");
INSERT INTO guoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham, nejwʉajnapijin, nejchachaemil, matabijt wʉton xan fʉlaeyaxaelenpox ampathatasik. Amwʉtjel, nataekon. Samata, Abraham xabich nejchachaemil xanliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Do jawʉt, judíos jʉm-aechi Jesúsliajwa: —Xamfʉk pati'na-emil. Xambejfʉk pas-emil cincuenta waechan jʉmchiliajwam: ‘Xan taenx Abraham’ —chiliajwam —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xan jʉm-an. Xan Abraham wʉajna chajia dukx —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Do jawʉt, judíos ia' not dadaepliajwapi Jesús. Pe faena-eli, Jesús namoest xot jiwtat. Do jawʉx, nakoltlison Dios pejtemplobaxot. ");
INSERT INTO guoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dolisdo', Jesús fol wʉt, xanal, japon pejnachalwan sʉapich, Jesús taen kaen itliaklan. Japon aton taeyaxil, jasox chanlaelt xoton. ");
INSERT INTO guoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Do jawʉt, xanal wʉajnachaemtax wʉt, jʉm-an Jesúsliajwa: —Jiw chanaekabʉanan, ¿ma-aech xotkat japon aton jasox chanlaelt itliaklax? ¿Pax, pen sʉapichkat, babijaxan ispoxantat, japon aton ja-aech? O, ¿japonkat pajut babijaxan ispoxantat ja-aechon? —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús najʉmnot wʉt, najʉm-aechon xanalliajwa: —¡El! Japon pajut babijaxan ispoxantata-el. Pax, penbej, japi ispoxantata-elbej. Japon aton itliakal amwʉtjel Dios itpaeliajwa pejpamamax, boejthʉch wʉton. ");
INSERT INTO guoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Matkoi wʉt, xatis nabichaxaesfʉk. Pe madoi wʉt, nabichaxisal. Ja-aechbej xatisliajwa. Amwʉtjel pachaem nabichliajwas Dios pejbichax. Pe asamatkoi tʉpaxaes. Japamatkoitat, kaes nabichaxisal. ");
INSERT INTO guoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Xan ampathatatax wʉt, xan, me-ama itliakax ampathatpijiwliajwa. Xan jiw kajachawaesaxaelen japi chiekal matabijaliajwapi Dios —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús japox jʉm-aech wʉt, jawʉt sat loeyapon. Pej-almintat ju'apon sat assap isliajwa. Dolison, japa-assap mojton pejkothiyatat itliaklan itfujoelaliajwa. Jawʉt itfujoelapon itliaklan. ");
INSERT INTO guoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Do jawʉt, Jesús jʉm-aech itliaklanliajwa: —¡Xabʉa'de asew nawaen poxade, jaxotde itfukiasliajwam! Jaxotde cha-aelpukach, poejiw pajut ispox, pawʉlox Siloé —aech Jesús itliaklanliajwa. (Siloé jʉmchiliajwa: “To'aspon” —chiliajwa.) Do jawʉt, itliaklan fʉlaechlison itfukiasliajwa. Itfukiat wʉt, kaxadin wʉton, jawʉt chiekal taenlison. ");
INSERT INTO guoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Asew jiw, mox duili japon dukxot, asew jiwbej, japi taenpi, japon plata wʉljow wʉt nʉambabʉ'tat, japi puexa pejme taen wʉt japon, japi nakaewa najʉm-aech: —¿Amponkatlap majt plata wʉljowpon, nʉambabʉ'tat ek wʉt? —aech japi jiw nakaewaliajwa majt itliakalponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Asew japixot jʉm-aech: —Diachwʉajnakolax chiekal japon. Asana-el —aechi. Pe asew japixot jʉm-aechlax: —¡Japona-elkatdo! Pe asan, me-ama japon, jakabʉan-aechpon —aechi. Do jawʉt, japon pajut chiekal jʉm-aech nejthʉ'axtat japi jiwliajwa: —Diachwʉajnakolax xan chiekal japonan. ¿Ma-aech xotkat xamal xan chiekal namatabija-emil? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Do jawʉt, wʉajnachaemtas wʉt, jʉmtispon: —¿Ma-aech xotkat xam chiekal amwʉtjel taenam? —tispon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Majt itliakalpon jʉmnot wʉt, jʉm-aechon: —Aton, pawʉlpon Jesús, japon xan nataen wʉt, pej-almintat assap ispon. Japa-assaptat tajkole-itfulelje na-itfujoelapon. Do jawʉt, najʉm-aechon: ‘¡Xabʉa'de asew nawaen poxade, jaxotde cha-aelpukach, poejiw pajut ispox, pawʉlox Siloé! ¡Jaxotde itfukia'e!’ —na-aech japon aton. Do jawʉt, xan fʉlaechx itfukiasliajwan. Jaxotde itfukiatx wʉt, tajkole-itfutje chiekal nawepachaem. Do jawʉt, chiekal taenxbej —aech majt itliakalpon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Do jawʉt, asew jaxotpijiw wʉajnachaemt wʉt, jʉm-aechi: —¿Amxotkat japon aton? —aechi, Jesúsliajwa wʉajnachaemt wʉt. Majt itliakalpon jʉmnot wʉt, jʉm-aechon: —Jalape. Xan matabijs-enil amxoton amwʉtjel —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesús ju'a wʉt assap itliaklanliajwa japon taeliajwa, japamatkoi napatamatkoi. Samata, asew jiw bʉ'foli majt itliakalpon fariseos poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bʉ'pat wʉtipon fariseosxot, japi wʉajnachaemtaspon. Do jawʉt, jʉmtispon: —¿Ma-aech xotkat xam amwʉtjel chiekal taenam? —tispon. Japon jʉmnot wʉt, jʉm-aechon: —Kaen aton assap na-itfujoela. Xan itfukiatx wʉt, jawʉt taj-itfut chiekal nawepachaem —aech majt itliakalpon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Asew fariseosxot jʉm-aechi: —Japon aton japox is wʉt, sitae-el napatamatkoi. Samata, Dios to'aspona-el —aechi. Asewlax japixot jʉm-aech: —Japon babejen wʉt, isaxilon koechaxan —aechi. Samata, fariseos kaenejchaxoelaxa-el Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ja-aech wʉt, majt itliakalpon pejme wʉajnachaemtas. Jʉmtispon: —Xamlax, ¿achaxkat jʉm-am nej-itfut boejthʉtponliajwa? —tispon. Majt itliakalpon jʉmnot wʉt, jʉm-aechon: —Japon Dios pejprofeta —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judíos naexasis-el japon majt itliakalpox. Samata, judíos wʉllalapi japon pax, penbej, fʉlaeliajwadin. ");
INSERT INTO guoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Do jawʉt, pax, pen sʉapich, pat wʉt, wʉajnachaemtas wʉt, jʉmtispi: —¿Diachwʉajnakolaxkat ampon naxʉlan, itliaklax chanlaeltpon? ¿Ma-aech xotkaton amwʉtjel chiekal taen? —tispi, wʉajnachaemtas wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Japon pax, pen sʉapich, jʉmnot wʉt, jʉm-aechi: —Xanal chiekal japon matabijtax xamalxot nukpon, japon taxʉlan. Matabijtaxbej japon itliaklax chanlaeltpox. ");
INSERT INTO guoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pe xanal matabija-enil, ma-aech xot amwʉtjel chiekal taenpon. Matabija-enilbej, achan itfuboejthʉchpon. Taxʉlan pati'in. Samata, ¡xamal najut wʉajnachaemdepon! Japon pajut xamal jʉmchiyaxael —aech pax, pen sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Japi jasox jʉm-aech, pejlewla xoti judíosliajwa, judíos jʉm-aech xot: “Nejmach-aton jʉm-aech wʉt: ‘Jesús, japon Cristo, Dios to'aspon’ —aech wʉt, japon aton xanal tapaeyaxinil leliajwa wajnaewʉajnabaxot” —aech xot chajia judíos. ");
INSERT INTO guoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Samata, japon pax, japon penbej, jʉm-aechi: “Taxʉlan pati'in. Samata, ¡xamal najut chiekal wʉajnachaemde japon!” —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Do jawʉt, judíos pejme la majt itliakalpon fʉlaeliajwadin. Pat wʉton japixot, jʉm-aechi japonliajwa: —¡Diachwʉajnakolax najʉm-amde Dios jʉmtaeliajwa! ¿Achankat japon aton? Xanal matabijtax, japon aton babejenpon —aech judíos. ");
INSERT INTO guoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Japon jʉmnot wʉt, jʉm-aechon: —Xan matabijs-enil japon aton babejen wʉt, o, babejna-el wʉt. Xanlax matabijtax ampox. Majt chinax xan tae-enil. Amwʉtjel chiekal taenx —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pejme wʉajnachaemt wʉt, jʉm-aechipon: —¿Achaxkat japon aton is xamliajwa? ¿Achaxkat isbejpon xam chiekal taeliajwam? —aech judíos majt itliakalponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Majt itliakalpon jʉmnot wʉt, jʉm-aechon: —Xamal chiekal jʉm-an. Pe chiekal xan nanaexasis-emil. ¿Ma-aech xotkat kaes xabich jʉmtaesiam? ¿Xamalbejkat japon pejnachalwasiam? —aechon judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Do jawʉt, babejjamechan jʉmtis wʉt, jʉm-aechipon: —Xam japon babejen pej-atonam. Xanallax Moisés pejjiwan. ");
INSERT INTO guoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xanal chiekal matabijax chajiakolaxtat Dios nospaeipox, Moisés sʉapich. Pe xanal matabija-enil, achan to'as Jesús —aech judíos. ");
INSERT INTO guoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Majt itliakalpon pejme jʉmnot wʉt, jʉm-aechon: —Japon xan na-itfuboejthʉt. Pe xamal matabija-emil, achan to'ason. ");
INSERT INTO guoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xatis judíos chiekal matabijas Dios kajachawaesaxaelpox naexasiti Dios, nejxasinkpibej Dios. Dios kajachawaes-el jiw babejchow, japi naexasis-eli Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ampathatat aton ajil, xajʉpon boejthʉsliajwa itliakla chanlaelapi. Majt jason aton tae-esal, me-ama japon, aton. ");
INSERT INTO guoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Japon aton Diosxotsik fʉlae-el wʉt, xan naboejthʉsaxilon —aech majt itliakalpon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Do jawʉt, judíos palaeyajametat jʉm-aechi japonliajwa: —Xam itliaklax chanlaeltam, nej-ax, nej-en sʉapich, xabich babijaxan is xot. Ja-am wʉt, ¿xamkat xanal nanaewʉajnasiam? —aechi. Do jawʉtbej, judíos nakolsax to'api japon aton judíos pejnaewʉajnabaxot. ");
INSERT INTO guoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús wʉltaen majt itliakalpon nakolsax to'aspox judíos pejnaewʉajnabaxot. Jesús japon aton faen wʉt, wʉajnachaemt wʉt, Jesús jʉm-aech japon atonliajwa: —¿Xamkat puexa jiw pakoewkolan naexasitam? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Majt itliakalpon jʉmnot wʉt, jʉm-aechon: —Jiw chanaekabʉanan, ¡najʉm-amde! ¿Achankat puexa jiw pakoewkolan, xan naexasisliajwan japon? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon japonliajwa: —Xam najut japon taenam. Xanlap japonan, puexa jiw pakoewkolnan, xam sʉapich, nospaeipon —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Do jawʉt, majt itliakalpon brixtat nuk Jesús pejwʉajnalel, xabich sitaen xoton. Japon jʉm-aech Jesúsliajwa: —Jiw chanaekabʉanan, xam naexasitx —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Do jawʉt, Jesús jʉm-aech: —Xan fʉlaenx ampathatasik jiw diajkaliajwan kolemʉtje. Kaemʉt xan nanaexasisaxael. Japi majt, me-ama itliakla wʉt, ja-aechpi pejnejchaxoelaxantat, amwʉtjel japi jiw chiekal taeyaxael. Matabijaxaelbejpi diachwʉajnakolaxpoxan. Asamʉt xan nanaexasisaxil. Japi, me-ama itliakla wʉt, jachiyaxael pejnejchaxoelaxantat, xan nanaexasis-el xoti. Matabijaxilbejpi diachwʉajnakolaxpoxan —aech Jesús majt itliakalponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Asew fariseos, japox jʉmtaen wʉt, jʉm-aechi: —¿Xanalkat-is, me-ama itliaklawan Diosliajwa? —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax xamal nejnejchaxoelaxantat, me-ama itliaklawam wʉt, ja-am. Dios chapaeyam wʉtbej babijaxan isampoxanliajwa, ja-am wʉt, xamal bʉ'wʉajanjilaxaelam Diosliajwa. Pe xamal jʉm-am: ‘Xanal chiekal taenx. Itliaklawa-enilbej tajnejchaxoelaxantat’ —am xot, xamal nejbʉ'wʉajan. Asamatkoi, tʉpam wʉt, nabijasaxaelam babijaxan isampoxantat —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Do jawʉt, Jesús jʉm-aech fariseosliajwa: “Diachwʉajnakolax xan jʉm-an. Le-elpon fafalel ovejas jiasxot, pe asalel julpon leliajwa, japon aton natkowan. ");
INSERT INTO guoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Fafalel lowpon, japonlax ovejas tataeflan. ");
INSERT INTO guoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Fafa wesan wefafach japon leliajwa. Do jawʉt, kaenanʉla pejew ovejas laefʉlon pejwʉltat. Pejew ovejas jʉmmatabijtas japon aton pejjame. Jasoxtat japon aton pejew ovejas juk jiasxot pola xaelpaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ovejas tataeflan puexa pejew ovejas bʉ'fol wʉt, japon matxoela fol. Pejew ovejas wʉchakal fol, pejjame jʉmmatabijtas xoton. ");
INSERT INTO guoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ovejas asew jiw fʉlfʉlae-el, japi pejjamechan jʉmmatabija-esal xot. Japi jiwxot dʉkpaxael ovejas, xabich pejlewla xoti” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús japawʉajantat naewʉajan wʉt, japi fariseos jʉmmatabija-el Jesús jʉm-aechpox. ");
INSERT INTO guoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Do jawʉt, Jesús pejme jʉm-aech fariseosliajwa: “Diachwʉajnakolax xan jʉm-an. Xan, me-ama laleyax, ovejas leliajwa jiasxot. ");
INSERT INTO guoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Puexa kichachajbapi, pati tajwʉajna, me-ama Dios to'as wʉt, ja-aechi, japi jiw me-ama kethaka. Japi nawenatkowasia tajjiw. Pe tajjiw naexasis-el japi kethaka naewʉajanpoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Xan, me-ama laleyax Diosxotse jiw pasliajwa. Xanlel lelpi, japi xan tataeflaxaelen. Japi, me-ama tejew ovejas. Jiasxot nakola wʉt, chimiapola faekaxaeli xaeliajwa. Do jawʉx, pejme jiasxot leyaxaeli. ");
INSERT INTO guoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Kethaka fʉlaen ovejas natkowaliajwa, beliajwabejpi ovejas. Xan fʉlae-enil isliajwan, me-ama japox. Xan fʉlaenx jiw chiekal nejchachaemlaliajwa pejnejchaxoelaxantat, pomatkoicha chiekal duilaliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Xan chiekal pachaeman jiw tataeflaliajwan. Me-ama ovejas tataeflan, pachaempon, pejew ovejas chiekal tataeflaliajwa, xanbej ja-an. Ovejas tataeflan nejchaxoel: ‘Asan aton tejew ovejas nawebeyaxael wʉt, xan tapaeyaxinil. Xanlax jʉmchiyaxaelen: “¡Xan naboesim!” —chiyaxaelen, tejew ovejas bʉ'weliajwan’ —aech ovejas tataeflan, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pe nabiston plata kanaliajwa, japon aton pejmachoefan fʉlaeyax taen wʉt, ovejas tamach waelchaxaelon. Dolison, pejlel najaesaxael. Jasox isaxaelon, japon poklatataeflana-el xot ovejas. Jawʉt, pejmachoefan ovejas bʉ'ajil wʉt, ovejas kaenanʉla pejlel nasalaxael. ");
INSERT INTO guoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Do jawʉt, japon aton pejlel najaet, asbʉan jʉmch nabichankal xot plataliajwa. Japonliajwa ovejas omjil, pejwa-el xoton ovejas. ");
INSERT INTO guoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Xan chiekal pachaeman jiw tataeflaliajwan. Me-ama ovejas tataeflan chiekal tataefʉl pejew ovejas, xanbej ja-an. Taj-ax Dios chiekal namatabijt. Xanbej taj-ax Dios chiekal matabijtax. Jasoxtat chiekal xan matabijtax, tajjiw, xan nanaexasiti. Japibej chiekal xan namatabijt. Xan tajut tapaeyaxaelen asew jiw xan naboesaliajwa, tajjiw bʉ'weliajwan. Me-ama ovejas tataeflan, tʉpaxael pejew ovejasliajwa chachoel wʉt japon atonliajwa, xanbej jachiyaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Asew tajjiwpi, japibej xanliajwa, me-ama tejew ovejas, duilpi asatʉajnʉchanlel. Japi wʉljaesaxaelen, xanxot kaeyaxtat duilaliajwa. Japi xan nanaexasisfʉlaxael. Bʉflaenx wʉt, puexa japi kaemʉtaxael. Xan, kaenan, japi jiw tataeflaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taj-ax Dios xabich xan nanejxasink, tʉpaxaelen xot tajjiwliajwa, japi bʉ'weliajwan. Do jawʉx, taj-ax namat-esaxael pejme dukaliajwan. ");
INSERT INTO guoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Asew jiw xan naboesaxilfʉk, xan tajut tapae-enil wʉtfʉk. Xan tajut tapaeyaxaelen, maswʉt naboesaxaeli. Do jawʉx, Dios xan namat-esaxael pejme dukaliajwan. Japoxlap taj-ax Dios xan nato'a isliajwan” —aech Jesús fariseosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Do jawʉt, judíos jʉmtaen wʉt Jesús jʉm-aechpox, pejme kaenejchaxoelaxa-eli. ");
INSERT INTO guoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xabich japixot jʉm-aech: —Ampon aton na-acha. ¿Ma-aech xotkat xatis kaes wʉlnaewesfʉlas, dep tato'lanas? —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pe asew japixot jʉm-aech: —Aton, pejmatpʉatat dep webaespon, jasox jʉmchiyaxil, naksiya wʉt. Dep xajʉpaxilbej itliaklan boejthʉsliajwa, chiekal taeliajwa aton —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Asamatkoi, iama wʉt, judíos fiesta is Jerusalén paklowaxxot. Japafiesta judíos nejchaxoelaliajwa pejwʉajnapijiw Dios pejtemploba chaemsax ketoetpox. ");
INSERT INTO guoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jawʉt Jesús Dios pejtemplobaxot laeja, pawʉlxot Pórtico de Salomón. ");
INSERT INTO guoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jaxot judíos, japi masajiat Jesús. Wʉajnachaemtipon chiekal matabijaliajwa. Do jawʉt, japi jʉm-aech Jesúsliajwa: —¿Masmatkoiyankat xanal wʉajnawesaxaelen matabijaliajwan, achanamkat xam? Xam diachwʉajnakolax Cristowam wʉt, ¡ama najʉm-amde xanal chiekal matabijaliajwan! —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon japi judíosliajwa: —Xan chajia chiekal xamal jʉm-an: ‘Xan Cristowan’ —an. Pe xamal naexasis-emil. Xan koechaxan isx wʉt, japoxan isx taj-ax Dios pijaxtat. Japoxan isx matabijaliajwam, achanan xan xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pe nakiowa, xamal xan nanaexasis-emil, xamal tajjiwa-emil xot. Me-ama tejew ovejas, jachi-emil. ");
INSERT INTO guoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tejew ovejas xan tajjame najʉmmatabijt, xan naksiyax wʉt. Xanbej japi matabijtax. Samata, japi xan nafʉlafol. ");
INSERT INTO guoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jiw, xan nanaexasiti, kajachawaesaxaelen pomatkoicha duilaliajwa Diosxotse. Samata, japi jiw napelsaxil. Chinax kaen aton japi jiw nawenosaxil, xan nanaexasiti. ");
INSERT INTO guoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taj-ax Dios woeyapi jiw xanxot. Taj-axbej xabich pejpamamax. Me-ama jiw, jachi-elon. Samata, chinax kaen aton xajʉpaxil japi jiw taj-axxot wemakanosliajwas. ");
INSERT INTO guoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Xan, taj-ax sʉapich, chiekal koewan —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Do jawʉt, judíos pejme noti ia' dadaepliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jawʉt Jesús jʉm-aech japi judíosliajwa: —Taj-ax Dios pijaxtat xabich chamoeyaxan isx nejwʉajnalel. ¿Achax chamoeyaxliajwakat xan ia'tat wʉlnabʉ'dadapam? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judíos jʉmnot wʉt, jʉm-aechi: —¡El! Xanal ia'tat xam dadaepaxinil, chamoeyaxan isam xot. Xanal ia'tat dadaepxpoxtat xam matkaejabaxaelen, Dios sitae-emil xot. Xam naksiyam, me-ama waj-ax Dios, xam atonamkal wʉt —aech judíos Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Do jawʉt, Jesús jʉm-aech: —Dios pejjamechan, chajia lelspox, jʉm-aech Dios jʉm-aechpox Dios makanochpi paklochowliajwa: ‘Xan jʉm-an: “Xamal, me-ama dioses” —an xan’ —aech Dios jʉm-aechpox japi Dios makanochpiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Xatis chiekal matabijas Dios pejjamechan diachwʉajnakolax pomatkoichaliajwa. Samata, chajiakolaxtat Dios jʉm-aech wʉt paklochowliajwa: ‘Xamal, me-ama dioses’ —aech wʉt, diachwʉajnakolax Dios jʉm-aech japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Xanbej, Dios namakafitponan, japon xan nato'a ampathatpijiw bʉ'weliajwan. Jʉm-an wʉt: ‘Xan Dios paxʉlnan’ —an wʉt, ¿ma-aech xotkat xamal najʉm-am: ‘Xam sitae-emil Dios’ —na-amkat? ");
INSERT INTO guoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Xan is-enil wʉt taj-ax nato'apoxan, ja-an wʉt, ¡xan nabej nanaexasis! ");
INSERT INTO guoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pelis xan isfʉlax wʉt taj-ax nato'apoxan, ¡xan nanaexasi' e isfʉlaxpoxantat, xamal xan nanaexasi-elasiam wʉt xan jʉm-anpox taj-ax Dios nato'aponliajwa! Xan koechaxan isxpoxan, taenam wʉt, ¡xamal najut chiekal matabijim xan Dios nato'aponanpox! Ja-aech wʉt, xamal chiekal matabijaxaelambej xan koewanpox, taj-ax Dios sʉapich —aech Jesús judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Do jawʉt, judíos pejme jaelsasiapi Jesús. Pe japixot wiapon. ");
INSERT INTO guoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Do jawʉx, Jesús nawiat wʉt Jordánlajt we-enlelde, Juan majt jiw bautisafʉlxot, xanalbej Jesús pejnachalwan, Jesús sʉapich, nawiax. Do jaxot Jesús naman wʉt, xanalbej namax jaxot. ");
INSERT INTO guoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Do jaxot xabich jiw fʉlaen Jesús taeliajwa. Japi jiw Jesúsxot pat wʉt, nakaewa najʉm-aechi: —Juan, jiw bautisan, chinax koechax is-el. Pe Juan puexa jʉm-aechpox amponliajwa, japoxan diachwʉajnakolax, chiekal ja-aechlisox —na-aechi nakaewa Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Do jawʉt, xabich jiw jaxot naexasiti Jesús, japon Dios to'asponpox. ");
INSERT INTO guoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aton bʉ'xaeyan, pawʉlpon Lázaro, koliowje pakoewow sʉapich, dukon Betania paklowaxxot. Kaeow pawʉl María. Asaow pawʉl Marta. ");
INSERT INTO guoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Martalap majt Jesús tʉakchafan perjumamint, xabich sitaen xotow Jesús. Do jawʉtbej, japow pejmatlatat tʉakjoeipow Jesús pejtʉak. ");
INSERT INTO guoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Japi koliowje asan aton to'a japon wʉljaesliajwa Jesús. Bʉxto'a wʉt, jʉm-aechipon: —Jesús faenam wʉt, ¡jʉm-amopon: ‘Tajpaklon, nejnachalan Lázaro, nejxasinkampon, xabich bʉ'xaenk’ —amo Jesús! —aechi, aton to'a wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Do jawʉx, Jesús japox jʉmtaen wʉt, jʉm-aechon xanal pejnachalwanliajwa: —Lázaro ampawaxaetat chiekal tʉpaxael. Pe kaelel tʉpaxilon. Japon bʉ'xaenk puexa jiw taeliajwa Dios xabich mamnikpon, jiw taeliajwabej xan, Dios paxʉlnan, tajpamamaxbej —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús kamta kajachawaesasia Marta, Maríabej, Lázaro bʉ'xaenkpoxliajwa, Jesús japi xabich nejxasink xot. ");
INSERT INTO guoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wʉltaen wʉton Lázaro bʉ'xaenkpox, Jesús nakiowa kaweta namanfʉkon kolematkoije Jordánlajt we-enlelde. ");
INSERT INTO guoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Do baxael, Jesús jʉm-aech xanal pejnachalwanliajwa: —Chijias pejme Judea tʉajnʉ poxade —aechon xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Xanal jʉm-an: —Jiw chanaekabʉanan, kaematkoiyan sʉapichlisox Judea tʉajnʉpijiw xam ia'tat dadaepsiapox matkaejabaliajwapi xam. Japi jiwfʉk xam bej wʉajnawesfʉlbej boesaliajwa. ¿Ma-aech xotkat xam pejme japoxade fʉlaesiam? —an xanal Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús pejme jʉm-aech xanalliajwa: —Diachwʉajnakolax matkoi itliak doce horas. Samata, aton fia'paxil, nanʉamt wʉt, puexa chiekal taen xoton. ");
INSERT INTO guoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pe aton madoi nanʉamt wʉt, japon fia'paxael, itkʉa'nik xot, puexa chiekal taeyaxil xotbejpon —aech Jesús, wʉajantat jʉm-aech wʉton xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Japox jʉm-aech wʉt, pejme jʉm-aechon: —Wajnachalan Lázaro moejt. Xan japoxaxaechan thikaliajwanpon —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xanal jʉm-an: —Jiw chanaekabʉanan, Lázaro moejt wʉt, japon waxae boejthʉlaxaes —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús jʉm-aech wʉt: “Lázaro moejt” —aech wʉt, japox jʉmchiliajwa: “Lázaro chiekal tʉp” —chiliajwapox. Xanallax, Jesús pejnachalwan, japox jʉmtaenx wʉt, asbʉan jʉmch nejchaxoelx: “Lázaro moejt wʉt, moejton. Me-ama madoi moejt wʉt, ja-aechon” —an xanal, nejchaxoelx wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Samata, Jesús xanal najʉm-aech chiekal matabijaliajwan: —Lázaro chiekal tʉp. ");
INSERT INTO guoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lázaro tʉp wʉt, xan jaxota-enil. Japon tʉp xamal kaes pejme xan nanaexasisliajwam. Samata, nejchachaemlax xamalliajwa. Amwʉt fʉlaeyaxaes patʉpan Lázaro poxade japon taeliajwas —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Do jawʉt, Tomás, japon asawʉl Na-o'an, japon jʉm-aech xanalliajwa: —Xatisbej chijias tʉpaliajwas, japon sʉapich, asew jiw boesas wʉton —aech Tomás xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús, xanal nabʉ'pat mox Betania paklowaxxot. Jaxot asew jiw Jesús chapaei Lázaro tʉppox. Patʉpan Lázaro, ochpox mʉaxwʉajtat cuatro matkoijelisox. ");
INSERT INTO guoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania paklowax mox Jerusalén paklowaxxot, me-ama tres kilómetros. ");
INSERT INTO guoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jesús wʉajna xabich judíos, Judea tʉajnʉpijiw, Jerusalén paklowaxxot fʉlaeni. Japi fʉlaen naknoeliajwapi Marta, Maríabej, Lázaro tʉp xot. ");
INSERT INTO guoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta jʉmtaen wʉt Jesús fʉlaeyax, nakoltow baxot, xanal nabʉ'kakʉnaliajwa nʉamtat. Maríalax kaweta batat naman. ");
INSERT INTO guoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta pat wʉt xanalxot, japow jʉm-aech Jesúsliajwa: —Tajpaklon, takoewan bʉ'xaenk wʉtfʉk, xam amxotam wʉt, ja-aech wʉt, takoewan nawetʉpaxil. ");
INSERT INTO guoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pe xan matabijtax. Dios puexa xam chaxdusaxael wʉljowampox —aech Marta Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús jʉmnot wʉt, jʉm-aechon: —Marta, nakoewan mat-esaxaes pejme dukaliajwa —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta jʉm-aech: —Diasdo'. Xan matabijtax. Tʉpi mat-ias wʉt pejme duilaxael, that toep wʉt. Jawʉtbej takoewan mat-esaxaes pejme dukaliajwa —aech Marta. ");
INSERT INTO guoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Do jawʉt, Jesús jʉm-aech: —Xanlap mat-eyaxaelen tʉpi, japi pejme duilaliajwa. Xanbej kaenan jiw kajachawaesnan pomatkoicha pejme duilaliajwa. Xan nanaexasiti, asamatkoi tʉp wʉt, japi mat-eyaxaes pejme duilaliajwa pomatkoicha. ");
INSERT INTO guoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ampathatat laelpi, xan nanaexasit wʉt, japi asamatkoi napelsaxil, tʉp wʉti. Duilaxaeli pomatkoicha. Marta, ¿xamkat xan nanaexasitam jʉm-anpox? —aech Jesús Martaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Do jawʉt, jʉm-aechow: —Diasdo' tajpaklon. Xan naexasitx xamlap diachwʉajnakolax Cristowam. Xambej Dios paxʉlnam, Dios to'aponam ampathatasik fʉlaeliajwam —aechow Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Do jawʉt, Marta bʉxtoet wʉt, kaxadepow pejba poxade laeliajwa pakoewow María. Jawʉt Marta maliach jʉm-aech pakoewow Maríaliajwa: —Jiw chanaekabʉanan ma amxotlison. Xam xabʉa't-aechon taeliajwam —aech Marta Maríaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María japox jʉmtaen wʉt, nanchapow. Jawʉt fʉlaechlisow Jesús taeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús pas-elfʉk paklowax. Kawetafʉkon Marta bʉ'kakʉltasxot. ");
INSERT INTO guoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Do jawʉt, judíos batatpi, María sʉapich, taen wʉti María bichakal nanchapox nakolsliajwa tathoetade, japi judíosbej wʉchakal nakola. Nejchaxoeli: ‘María patʉpanwʉaj poxaxaech jaxotde noeliajwapow’ —aechi, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María pat wʉt Jesúsxot, Jesús pejwʉajnalel brixtat nukow, xabich sitaen xotow Jesús. Do jawʉt, jʉm-aechow: —Tajpaklon, takoewan bʉ'xaenk wʉtfʉk, xam amxotam wʉt, ja-am wʉt, takoewan tʉpaxil —aech María. ");
INSERT INTO guoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús taen wʉt María nowpox, taen wʉtbejpon judíos nowpox, japi chalapi María, Jesús jʉmbeltaen. Do jawʉt, Jesús xabich nejxaejwas. ");
INSERT INTO guoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jawʉt Jesús wʉajnachaemt wʉt, jʉm-aechon: —¿Amxotkat patʉpan Lázaro otam? —aech Jesús. Jawʉt japi jʉm-aech Jesúsliajwa: —Tajpaklon, ¡xabʉa't taeliajwam! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Do jawʉtbej, Jesús now. ");
INSERT INTO guoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Samata, Judea tʉajnʉpijiw, jaxoti, nakaewa najʉm-aechi: —¡Taem! Jesúsbej now, xabich nejxasink xoton Lázaro —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Asew japixot jʉm-aech Jesúsliajwa: —Japon majt itliakla boejthʉt chiekal taeliajwa. ¿Pe ma-aech xotkat kamta pas-elon boejthʉsliajwa Lázaro, tʉpasamatabejpon? —aech japi jiw Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Do jawʉt, Jesús xabich nejxaejwas wʉt, mox soepanpon Lázaro ochwʉajxot, ia't pinjit fafa xat-elspot. ");
INSERT INTO guoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Do jawʉt, Jesús jʉm-aech: —¡Ia't matariamande! —aechon. Pe Marta, Lázaro pakoewow, jʉm-aech Jesúsliajwa: —Tajpaklon, xasaeibejlison, cuatro matkoije xotlisox ochpox —aechow Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús jʉmnot wʉt, jʉm-aechon: —Xam chajia chiekal jʉm-an: ‘Xan nanaexasitam wʉt, taeyaxaelam Dios pejpamamax’ —an xan chajia —aech Jesús Martaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jawʉt asew japixot ia't pinjit matariaman, wʉajfafa xat-elspot. Do jawʉt, Jesús athʉ natachaemse wʉt, Dios kawʉajan wʉt, jʉm-aechon: —Ax Dios, xan gracias-an, xam najʉmtaenam xot. ");
INSERT INTO guoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Xan chiekal matabijtax, xam pomatkoicha xan nanaewetam, xam kawʉajnax wʉt. Pe ampox xan jʉm-an ampi jiw matabijaliajwa, naexasisliajwabejpi xam nato'amponanpox ampathatasik —aech Jesús, Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kawʉajnax bʉxtoet wʉton pax Dios, Jesús nejlakcha wʉt, jʉm-aechon: —Lázaro, ¡xabʉa't! ¡Nakolmen jaxot! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Do jawʉt, patʉpan Lázaro wʉajxot nakoldin. Puexa pejbʉ't, pejmatnaetbej, sábanabʉ'antat xakoeyaspoxan, chankoldinpon. Do jawʉt, Jesús jʉm-aech: —¡Wejolde xakoeyaspoxan! ¡Tapaem laejaliajwa! —aech Jesús. Do jawʉt, Lázaro wejols sábanabʉ'an, xakoeyaspoxanpon. ");
INSERT INTO guoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judíos, chalapi María, taen wʉti Jesús ispox koechax Lázaroliajwa, japixot xabich naexasiti Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pe asew japixot fʉlaech fariseos poxade. Pat wʉti Jerusalénxot, chapaeipi fariseosxot Jesús ispox Lázaroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Do jawʉt, fariseos, sacerdotespaklochowbej, tamejapi Junta Supremapijiw. Natameja wʉt, nakaewa najʉm-aechi: —¿Achaxkat isaxaes Jesúsliajwa? Japon xabich koechaxan isfʉl. ");
INSERT INTO guoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Japon tapaeis wʉt isfʉlpoxan, puexa jiw naexasisaxaeson. Ja-aech wʉt, Roma tʉajnʉpijiwpaklochow to'axaeli soldaw, japi soldaw toesliajwa Dios pejtemploba, wajjiwbej —aech paklochow, nakaewa nospaei wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kaen japixot pawʉl Caifás. Japon sacerdotespaklokolan japawaechtat. Jawʉt japon jʉm-aech: —Xamal matnaenejtinkam xot, matabija-emil. ");
INSERT INTO guoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kaes pejme pachaem kaen tamach tʉpaliajwa. Ja-aech wʉt, xabich jiw tʉpaxil. Toesaxisalbej wajjiw —aech Caifás. ");
INSERT INTO guoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pe Caifás pajut pijaxtat japox jʉmchi-el. Japox jʉm-aechon Dios pijaxtat. Caifás japox jʉm-aech Jesúsliajwa, Jesús tʉpaxael xot puexa Israel tʉajnʉpijiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Japikalliajwa Jesús tʉpaxil. Tʉpaxaelbejpon asajiwliajwabej, puexa ampathatpijiwliajwa, Dios naexasiti kaemʉtaliajwa. Japoxlap Dios nejxasink. ");
INSERT INTO guoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifás japox jʉm-aech Jesús pejpatʉpaxliajwa. Do jawʉt, judíospaklochow nejchaxoelafʉl boesaliajwapi Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Samata, Jesús kaes nanʉams-el tulaela Judea tʉajnʉxot. Do jawʉt, xanal nabʉflaechon paklowax, pawʉl poxade Efraín, mox pajilaxxot. Jaxot puexa xanal namax, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kaematkoiyan sʉapich we'p Pascuafiestaliajwa, judíosliajwa. Samata, xabich judíos fʉlaech Jerusalén paklowax poxade fiesta wʉajna, japi chiekal ketoesliajwa, puexa we'ppoxan isliajwa. Japox judíos pejkabʉan, Moisés chajia lelpox jʉm-aech xot. Japafiesta wʉajna japox ja-aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Fʉlaenpi Jerusalén paklowaxlel, japi wʉlwek Jesús. Pat wʉti Dios pejtemplobaxot, japi nakaewa nawʉajnachaemt wʉt, jʉm-aechi: —¿Jesúskat naktaeyaxael fiesta? O, ¿naktaeyaxilkaton? ¿Achaxkat xamal nejchaxoelam? —na-aechi nakaewa. ");
INSERT INTO guoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseos, sacerdotespaklochowbej, puexa jiw chajia bʉxto'a wʉt, jʉm-aechi: “Kaenam xamalxot Jesús taenam wʉt, ¡kamta xanal nachapaem!” —aech paklochow jiwliajwa. Japi japox jʉm-aech, jaelsasia xoti Jesús jeliajwapi jiw jebaxot. ");
INSERT INTO guoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","We'p wʉt seis matkoiyan Pascualiajwa, Jesús fʉlaech wʉt Betania paklowax poxade, xanal, japon pejnachalwan, nakfolxbej. Jaxotde Lázaro majt tʉp. Pe Jesús mat-et Lázaro pejme dukaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jaxotde xanal pa'ax wʉt, asew jiw naxaeyaxan is pejsitaeyax itpaeliajwa Jesúsliajwa. Marta kajachawaet naxaeyaxan cha-eyaxan, Lázaro, asew jiwbej, tadʉchpi, xaeliajwa, Jesús sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Do jawʉt, María xapat perjumamint tʉakchafanaliajwapow Jesús. Japamint xabich ommaenk. Japot, me-ama medio litro. Isas nardokal. Jawʉt tʉakchafanpow Jesús, xabich sitaen xotow. Do jawʉt, pejmatlatat tʉakjoeipow Jesús pejtʉak. Samata, jawʉt japaba xabich xabejxat-ialnanik. ");
INSERT INTO guoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Do jawʉt, Judas Iscariote, Jesús pejnachalan, japon jʉm-aech: —¿Ma-aech xotkat japaperjumamint mowa-esal plata chaxduiliajwas kejila? Bej pa-ombej trescientos denarios —aech Judas. Judaslap wiasaxael Jesús padaelmajiwxot. ");
INSERT INTO guoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas japox jʉm-aech wʉt, nejchaxoela-elon jiw kejila kajachawaesliajwa. Japox jʉm-aechon, kethakan xot. Japon kaen platachoxa tataefʉl puexa xanal, Jesús pejnachalwanliajwapi. Japaplata japon pajut maliach jinatkowa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Do jawʉt, Jesús jʉm-aech: —¡Nej ja-aeche'! Xan tajpatʉpaxliajwa japow cha-et perjumamint. ");
INSERT INTO guoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kejila pomatkoicha xamalxotaxael kajachawaesliajwam. Pelax xan piachaxinil xamalxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Xabich jiw fʉlaen xanallel taeliajwapi Jesús, taeliajwabejpi Lázaro, japon tʉp wʉt, Jesús mat-echpon pejme dukaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jesús koechax is xot Lázaroliajwa, xabich jiw, Judea tʉajnʉpijiw, naexasisfʉl Jesús. Kaes naexasis-ellisi sacerdotes naewʉajanpoxan. Japi naexasisfʉl Jesúskal. Samata, sacerdotespaklochow nejchaxoel boesaliajwapi Jesús, Lázarobej. ");
INSERT INTO guoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Do kandiawa wʉt, xabich jiw Jerusalén paklowax poxade taeliajwapi Pascuafiesta. Japi matabija wʉt Jesús pasaxaenpox Jerusalén paklowaxxot, jawʉt, me-ama chia'ʉaflejen tasiapapi xawisliajwa, owaliajwabej nʉamtat Jesús pejwʉajnalel, chiekal bʉ'kʉlsliajwapi, pejsitaeyax itpaeliajwabejpi. Fʉlaeyax taen wʉti nʉamtat, nejlasfʉl wʉt, jʉm-aechfʉli: —¡Aleluya! ¡Ampon, fʉlaenpon Dios pijaxtat, japon xabich pachaem! ¡Pachaembejpon Israel tʉajnʉpijwas wajreyliajwa! —aechfʉl xabich jiw Jesúsliajwa, nejlasfʉl wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús jelti'san bur faen. Do jawʉt, tʉa-eklison chaflaeliajwa Jerusalén paklowax poxade. Japoxliajwa Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, jʉm-aechox: ");
INSERT INTO guoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Xamal, Jerusalén paklowaxpijwam, ¡nabej nejlewle'! ¡Taem nejrey chaflaenpon bur jelti'santat!” —aechox chajia lelspox. ");
INSERT INTO guoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Xanal, Jesús pejnachalwan, chiekal matabija-enilfʉk, achax chiyaxael japamatkoi. Do jawʉx, Jesús mat-ech wʉt, pejme duk wʉt, athʉ poxase wʉtbejpon, jawʉt xanal chiekal nejchafaetx chajia lelspox, jʉm-aech wʉt jʉm-aechox japonliajwa. Do jawʉtbej, xanal chiekal matabijax, ma-aech xot japoxan ispi Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Japi jiw taen, Jesús la wʉt Lázaro mʉaxwʉajxotdin Lázaro mat-esliajwa pejme dukaliajwa. Japi chapaefʉl taenpox, asew jiwbej matabijaliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Samata, xabich jiw nakola pejbachanxot bʉ'kakʉlnaliajwapi Jesús, wʉltaen xoti Jesús ispox, koechax. ");
INSERT INTO guoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pe fariseos najʉm-aechi nakaewa: —Xatisliajwa japox pachaema-el. ¡Tae'nik! ¡Puexa jiw Jesús xabich nakfos! —na-aech nakaewa fariseos. ");
INSERT INTO guoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalén paklowaxxot asew griegos pat pejsitaeyax itpaeliajwa Diosliajwa. Patbejpi taeliajwa Pascuafiesta. ");
INSERT INTO guoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Japi jiw pat wʉt Jerusalén paklowaxxot, mox soepapi Felipexot, japon kaen xanalxotpijin. Japon Betsaida paklowaxpijin, Galilea tʉajnʉxot. Do jawʉt, japi jʉm-aechi Felipeliajwa: —Taj-aton, xanal Jesús taesian nospaeliajwan, japon sʉapich —aechi Felipeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Do jawʉt, Felipe fʉlaech chapaeliajwapon Andrés griegos wʉlwekspox Jesús. Do jawʉtbej, Felipe, Andrés sʉapich, fʉlaechlisi Jesús poxade chapaeliajwapi japox. Jesúsxot pat wʉt, chapaeilisi japox. ");
INSERT INTO guoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Do jawʉt, Jesús jʉm-aech: —Tajmatkoi patlis xan, puexa jiw pakoewkolnan, tʉpaliajwan, Dios namat-esliajwabej pejme dukaliajwan. ");
INSERT INTO guoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Diachwʉajnakolax xan jʉm-an. Kaefut, me-ama trigofut, satat mʉths-esal wʉt, japafut naboelaxil. Japafut namanaxael kaefutliajwa. Asafutlax mʉthtas wʉt satat, pejbokt xoep wʉt, itxit namanpox naboelsaxael. Naboeltpox naboesaxael. Naboet wʉt, xabichaxael pafu. Xanlap-is, jachiyaxaelen. Xan kaenan tʉpaxaelen xabich jiwliajwa, japi pomatkoicha duilaliajwa Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Najut nejxasinkampoxan isfʉlam wʉt ampathatat, ja-am wʉt, duilaximil pomatkoicha Diosxotse. Pe ampathatat babijaxan isampoxan kofam wʉt, ja-am wʉt, pomatkoicha duilaxaelam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xamal nabichasiam wʉt xanliajwa, ¡xan chiekal nanaewe'e! Jasox xamal ja-am wʉt, duilaxaelam, xan sʉapich, Diosxotse. Nabistam wʉt xanliajwa, taj-ax Dios pachaemaxael xamalliajwa —aech Jesús Felipeliajwa, Andrésliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesús pajutliajwa najʉm-aech: “Amwʉtjel xan xabich nejchaemilax, matabijtax xot xabich nabijasaxaelenpox. ¿Achaxkat xan jʉmchiyaxaelen taj-axliajwa? Xan wʉljoeyaxinil taj-ax nabʉ'weliajwa japanabijasaxliajwa. Japanabijasaxliajwa xan fʉloekx. ");
INSERT INTO guoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Samata, xan jʉmchiyaxaelen taj-axliajwa: ‘Ax, ¡isde pachaempox puexa jiw xam sitaeliajwa!’ —chiyaxaelen xan taj-axliajwa” —aech Jesús pajutliajwa. Do jawʉt, Jesús jʉmtaen athʉsik, Dios pajut jʉm-aech wʉt ampox: “Isxlis japox. Kaes isaxaelenbej puexa jiw itpaeliajwan xabich tajpamamax” —aech Dios athʉsik. ");
INSERT INTO guoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jaxot jiw naeweti, japi chiekal jʉmmatabija-el, Dios naksiyak wʉt. Asew japixot japox jʉmtaenpi, japi jʉm-aechi ampox: —Me-ama iam najuw wʉt, jathia-aechox —aechi. Jawʉt asewbej japixot jʉm-aech: —Dios pej-ángel naksiya Jesúsliajwa —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús jʉm-aech japiliajwa: —Dios japox jʉm-aechsik wʉt, xan kaenanliajwa Dios japox naksiya-el. Xamalliajwabej Dios naksiya matabijaliajwam xan Dios nato'aponanpox. ");
INSERT INTO guoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Asamatkoi Dios kastikaxael puexa jiw, xan nanaexasis-elpi. Satanásbej kastikaxaes. Do jawʉt, Satanás kaes tato'laxil ampathatpijiw, Dios kefe'naxaes xoton tato'lax. ");
INSERT INTO guoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Xan nakematamatal wʉti cruztat, do jawʉx, xabich jiw, ampathatpijiw, tajwʉajan naexasisaxaeli —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesús japox jʉm-aech xanal chiekal matabijaliajwan japon tʉpaxaelpox cruztat. ");
INSERT INTO guoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Asew jaxot naewetpi, japi jʉm-aech Jesúsliajwa: —Moisés chajia lelpox jʉm-aech: ‘Cristo pomatkoicha dukaxael. Japon toepaxil’ —aechox. Cristo pomatkoicha dukaxael wʉt, ¿ma-aech xotkat xam jʉm-am: ‘Puexa jiw pakoewkolan tʉpaxael cruztat’ —amkat xam? ¿Achankat puexa jiw pakoewkolan? —aech japi jiw Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús jʉm-aech: —Xanfʉk kaematkoiyan xamal naewʉajnaxaelen. Tajnaewʉajnax, me-ama itliakax, ja-aechox. Naewʉajnax wʉt, ¡chiekal matabijim tajnaewʉajnax! Ja-am wʉt, xamal, me-ama nanʉamsaxaelam itliakaxxot. Tajnaewʉajnax jʉmmatabija-elpi, japi, me-ama nanʉamsaxaeli itkʉataxxot. ");
INSERT INTO guoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xanlap, me-ama itliakaxponan. ¡Xamal xan nanaexasi'e, amxotx wʉtfʉk! Ja-am wʉt, xamal tajjiwaxaelam —aech Jesús. Jesús japox bʉxtoet wʉt, fʉlaechon asalel. Do jawʉtbej, Jesús namoest japi jiw faen-elaliajwaspon. ");
INSERT INTO guoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús koechaxan is judíos taeliajwa, naexasisliajwabejpi japon Dios to'asponpox. Pe japi japoxan taen wʉt, nakiowa naexasis-eli Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isaías, Dios pejprofeta, chajia jʉm-aechpox Cristoliajwa, amwʉtjel japox ja-aechlisox. Japoxliajwa Isaías chajia jʉm-aech Diosliajwa: “Tajpaklon Dios, jiw naexasisaxil xanal tajnaewʉajnaxpox xamliajwa. Naexasisaxilbejpi, taen wʉt nejpamamax” —aech Isaías Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Isaías lelpox jʉm-aechbej, ma-aech xot judíos naexasisaxil Jesús, Dios to'asponpox. Isaías jʉm-aech: ");
INSERT INTO guoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Japi jiw Dios itfumatakas, pejnejchaxoelaxanbej. Samata, pajut pej-itfutat, me-ama taeyaxili. Pajut pejnejchaxoelaxantat jʉmmatabijaxilbejpi. Samatabej, japi Dios pejjamechan naexasisaxil kofaliajwa pejbabijaxan ispoxan” —aech Isaías, chajia jʉm-aech wʉt judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías japox chajia jʉm-aech, masoxtat taen xot Jesús pejpamamax. Isaías japox jʉm-aechbej Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pe nakiowa, xabich judíos naexasiti Jesús. Kaesʉapichbej judíospaklochow, naexasiti Jesús. Pe japi tulaela naksiya-el jiw jʉmtaesamatas, pejlewla xoti fariseosliajwa, fiasasamatas leliajwa judíos naewʉajnabachanxot. ");
INSERT INTO guoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Japi judíos kaes nejxasinki jiw nejchachaemlaliajwas japiliajwa. Japi nejxasinka-el Dios nejchachaemilpoxliajwa japiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús pinjametat jʉm-aech jiwliajwa: “Xamal xan nanaexasitam wʉt, xankal nanaexasis-emil. Naexasitambej taj-ax, japon xan nato'apon. ");
INSERT INTO guoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Xamal xan namatabijam wʉt, matabijambej xan nato'apon. ");
INSERT INTO guoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Xan, me-ama itliakax. Fʉloekx ampathatasik xan nanaexasiti namaesamata itkʉataxxot. ");
INSERT INTO guoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Tajnaewʉajnax jʉmtaenpi, naexasis-el wʉt, xan tajut japi tasalaxinil pejbʉ'wʉajanpoxanliajwa. Xan fʉlae-enilsik ampathatpijiw tajut tasalaliajwan japi pejbʉ'wʉajanpoxanliajwa. Xanlax fʉloekx ampathatpijiw bʉ'weliajwan. ");
INSERT INTO guoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xan namastaenpi, japi naexasis-el wʉtbej tajnaewʉajnax, xan tajut tasalaxinil japi jiw pejbʉ'wʉajanpoxanliajwa. Japi tasalaxaes xan tajnaewʉajnaxantat japi pejbʉ'wʉajanpoxanliajwa, that toep wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Xan tajut tajaxtat japox jʉmchi-enil. Taj-ax Dios, japon xan nato'apon, nabʉxto'apoxan xan jʉm-an, naewʉajnax wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Xan matabijtax, taj-ax Dios pejtato'lax xabich pachaem. Japox jiw naexasit wʉt, pomatkoicha duilaxaeli Diosxotse. Samata, xan jʉm-anpoxan, japox jʉm-an, me-ama taj-ax Dios nabʉxto'a” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","We'p wʉtfʉk kaematkoi Pascuafiestaliajwa, do jawʉt, Jesús matabijt pejmatkoi wemoxspox pax Dios poxaliajwase. Xanal pejnachalwan, japon xabich nanejxasink ampathatat. Samata, pax Dios poxaliajwa wʉt, jawʉtbej nakiowa Jesús nanejxasinkafʉl xanal pejnachalwan. Hasta japon tʉp wʉt, nakiowa nanejxasinkafʉlon xanal. ");
INSERT INTO guoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Pascuafiesta mox wʉt, Satanás pijaxtat Judas nejchaxoel wiasliajwapon Jesús padaelmajiwxot. Judas, Simón Iscariote paxʉlan, Jesús padaelman nadofapon. Jesús pajut matabijt fʉloekpox Diosxotsik. Matabijtbejpon pejme japoxaxoeipox. Matabijtbejpon pax Dios chaxduchpox pamamax puexa tato'laliajwa. Do jawʉt, xanal naxaelax wʉt madoipijax, Jesús mesaxot nant wʉt, jawʉt jolton pejsumta-osax. Do jawʉtbej, fatkakʉton toalla. ");
INSERT INTO guoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Do jawʉt, kʉanarxot mint fandikon platónadik. Do jawʉt, xanal natʉakkiaton. Me-ama nabichan wʉt, ja-aechon xanalliajwa. Toalla, fatkakʉtpoxtat, xanal natʉakjoeipon. ");
INSERT INTO guoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jesús kiasliajwa wʉt Simón Pedro pejtʉak, jawʉt Pedro jʉm-aech: —Tajpaklon, ¿xamkat xan natʉakkiasaxaelam? —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús jʉmnot wʉt, jʉm-aech: —Amwʉtjel xam matabijs-emilfʉk xan isxpox. Baxael, matabijsaxaelam, ma-aech xot xan japox isx —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro pejme jʉm-aech Jesúsliajwa: —¡El! Xan ketapaeyaxinil xam natʉakkiasliajwam —aech Pedro. Do jawʉt, Jesús jʉm-aech: —Xam tʉakkias-enil wʉt, xam tajnachalnaximil —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Do jawʉt, Simón Pedro pejme jʉm-aech: —Tajpaklon, ¡xam tajtʉakkal nabej kias! ¡Kia'ebej tajke-e, tajmatnaetbej! —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús jʉmnot wʉt, jʉm-aechon Pedroliajwa: —Jelnawaen pat wʉt asabatat, japon wewe'pa-esal pobʉ'ta kiasliajwas, jelnawaen xoton. Pachaem tʉakkal kiasliajwas, tʉak-asda'nik xot, sat sae'enas wʉt. Xamalbej ja-am, ajil babijaxan nejnejchaxoelaxanxot, chiekal xan nanaexasitam xot. Pe nakiowa, kaen xamalxot pachaema-el pejnejchaxoelax —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús matabijt, achan wiasaxaeson padaelmajiwxot. Samata, Jesús japox jʉm-aech. ");
INSERT INTO guoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Dolisdo', Jesús ketoet wʉt xanal pejnachalwan natʉakkiatpoxan, pejme naxoelon pejsumta-osax. Do jawʉt, pejme ek wʉton mesaxot, xanal najʉm-aechon: —¿Xamalkat matabijam xan isxpox xamalliajwa? ");
INSERT INTO guoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Xamal najʉm-am: ‘Jiw chanaekabʉanan’ —na-am. ‘Tajpaklon’ —na-ambej. Diachwʉajnakolax xan nejpaklonan xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Xan nejpaklonan wʉt, jiw chanaekabʉanan wʉtbej, nakiowa patʉakkiatx. Xan japox isx xamalbej jachiliajwam. ");
INSERT INTO guoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Japoxan xamal itpaeix chiekal matabijaliajwam, nakaewam nakajachawaesfʉlaliajwam. ");
INSERT INTO guoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Diachwʉajnakolax xan jʉm-an. Nabichan kaes pejme sitae-esal asew jiw. Me-ama pejpaklon xabich jiw sitaens, jachi-esal nabichan. To'asponbej kaes pejme sitae-esal. Me-ama to'apon xabich jiw sitaens wʉt, jachi-esal japon aton. Xamal nabichwam xanliajwa. Samata, xamal kaes paklochowa-emil. Me-ama xan kaes paklonan, jachi-emil xamal. Kaes pejme pachaem xamal matabijaliajwam xan itpaeixpoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xamal patʉakkiatxpox matabijam wʉt, xamalbej, me-ama japox isaxaelam wʉt nakaewaliajwa, ja-am wʉt, xabich nejchachaemlaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Xan matabijtax xamal, makanotxpim. Pe japox jʉm-an wʉt, jʉmchi-enil puexa xamalliajwa. Matabijtax, kaen xamalxot tadaelman nadofapox. Me-ama Dios pejjamechan, chajia lelspox, jʉm-aech wʉt, japox ja-aechlisox. Jʉm-aechox: ‘Xan sʉapich, xaeyaxaelpon, japonlap tadaelman nadofaxael’ —aech chajia lelspox. ");
INSERT INTO guoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Japoxliajwa ma amwʉtjel jʉm-an, jachi-el wʉtfʉk japox. Do japox, ja-aech wʉt, xamal xan nanaexasisaxaelam, xan Cristoponanpox, Dios nato'aponan. ");
INSERT INTO guoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Diachwʉajnakolax xan jʉm-an. Xamal sitaenam wʉt xan to'axpon, ja-am wʉt, xanbej nasitaenam. Xan nasitaenam wʉt, taj-ax Diosbej, sitaenam, japon xan nato'apon” —aech Jesús, xanal nachanaekabʉana wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Do jawʉt, Jesús japox jʉm-aech wʉt xanalliajwa, xabich nejxaejwason. Jawʉt Jesús jʉm-aech xanal, pejnachalwanliajwa, chiekal matabijaliajwan: —Diachwʉajnakolax xan jʉm-an. Kaen xamalxot nawiasaxael tadaelmajiwxot —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Do jawʉt, xanal nakaewan nawʉajnachaemsnax, xanal matabija-enil xot, achanliajwa Jesús japox jʉm-aech. ");
INSERT INTO guoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Dolisdo', naxaelx wʉt, xan Juan, Jesús xabich nanejxasinkponan, mox ekx Jesúsxot. ");
INSERT INTO guoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Samata, Simón Pedro xan nato'a wʉajnachaemsliajwan, achanliajwa Jesús japox jʉm-aech. ");
INSERT INTO guoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Do jawʉt, xan kaes mox chiekal soepnax Jesús wʉajnachaemsliajwan. Jawʉt xan wʉajnachaemtax wʉt, jʉm-an Jesúsliajwa: —Tajpaklon, ¿achanliajwakat xam japox jʉm-am? —an xan Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús najʉmnot wʉt, jʉm-aechon: —Xan panax, taxthotxpox, kaen xamalxot chaxdusaxaelenpon, japonlap xan nawiasaxael tadaelmajiwxot —aech Jesús xanliajwa. Dolisdo', Jesús taxthot wʉt panax, jawʉt chaxduton Judas Iscariote, japon Simón Iscariote paxʉlan. ");
INSERT INTO guoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Do jawʉt, Judas panax, taxthosax, kefit wʉt, jawʉt Satanás low Judas pejmatpʉatxot. Jawʉt Jesús jʉm-aech Judasliajwa: —¡Isaxaelampox isde kamtalejen! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","30","Jesús japox jʉm-aech wʉt, Judas kamta chijiapon xanalxot. Judas chijia wʉt, madoilisox. Puexa xanal, naxaelaxpin, matabija-enil, ma-aech xot Jesús japox jʉm-aech Judasliajwa. Asew xanalxot nejchaxoel: “Jesús bej to'abej Judas wʉajsliajwa naxaeyaxan Pascuafiestaliajwa. Japoxa-el wʉt, Jesús bej to'abej Judas chaxduiliajwa plata jiw kejila” —aechi, nejchaxoel wʉt. Japox nejchaxoeli, kaen Judas platachoxa xalaeja xot puexa xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas chijia wʉt, Jesús jʉm-aech xanalliajwa: —Tajmatkoi pat. Amwʉt xamal taeyaxaelam tajpamamax xan, puexa jiw pakoewkolnanponanpox. Xan isxpoxantat taeyaxaelambej taj-ax Dios, xabich mamnikpon. ");
INSERT INTO guoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xan isxpoxantat xamal taeyaxaelam taj-ax Dios, japon xabich mamnikpon. Dios ispoxantatbej xamal taeyaxaelam, xan Dios paxʉlnan, xabich mamnikaxponan. Dios japox isaxael kamtalejen. ");
INSERT INTO guoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tajnachala, xamalxotaxaelen kaehora sʉapichliajwa asbʉan jʉmch. Xan ajinil wʉt, xamal nawʉlwekaxaelam. Me-ama judíospaklochow chajia jʉm-an: ‘Xamal fʉlaeyaximil xan fʉlaeyaxaelen poxade’ —anpox, japox amwʉtjel xamalbej jʉm-an. ");
INSERT INTO guoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pajeltato'lax namanaxael xamalxot naexasisfʉlaliajwam. ¡Nakaewa nanejxasinkde! Me-ama xan xamal nejxasinkax, ¡xamalbej ja-amsfʉlde nakaewaliajwa! ");
INSERT INTO guoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nakaewa nanejxasinkafʉlam wʉt, ja-amsfʉlam wʉt, potʉajnʉchapijiw matabijaxael xamal tajnachalwampim —aech Jesús xanalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —Tajpaklon, ¿ampoxaxaelamkat xam? —aech Pedro. Jesús jʉmnot wʉt, jʉm-aechon: —Xan fʉlaeyaxaelen poxade, xamfʉk amwʉt fʉlaeyaximil. Pe baxael, fʉlaeyaxaelam —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Do jawʉt, Pedro jʉm-aech: —Tajpaklon, ¿ma-aech xotkat amwʉt xam nakfʉlaeyaxinilfʉk? Xan nejchaxoelx tʉpaliajwam xamliajwa —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús jʉmnot wʉt, jʉm-aechon: —¿Diachwʉajnakolaxkat xam nejchaxoelam tʉpaliajwam xanliajwa? Diachwʉajnakolax xan jʉm-an. Kawaema nejlaewʉajna, xan naxanaliyaxaelam tres veces. Jʉmchiyaxaelam: “Xan japon aton matabijs-enil” —chiyaxaelam xanliajwa —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús pejme jʉm-aech xanalliajwa: “¡Xamal xabich nabej nejchaxoele'! ¡Dios xanaboejim! ¡Xan naxanaboejimbej, xan Dios paxʉlnan! ");
INSERT INTO guoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taj-ax Dios pejbaxot xabich batuchan jiw duilaliajwa. Ajil wʉt, xan japox jʉmchiyaxinil. Xanlap japoxaxoeyan xamal wʉajnachaemsliajwan, jaxotse nejmach pomatkoicha xamal duilaliajwam. ");
INSERT INTO guoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Toetx wʉt chaemsaxan, xan pejme kaxaxoekan xamal bʉflaeliajwanse. Samata, xamal xanxotaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Xamal matabijam, xan fʉloeyaxoeyan poxase, japot, nʉamt, pase xan dukx jaxotse” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás jʉm-aech Jesúsliajwa: —Tajpaklon, xanal matabija-enil, xam fʉlaeyaxaelam poxade. ¿Machiyaxaelenkat xanal japot nʉamt fʉlaeliajwan? —aech Tomás. ");
INSERT INTO guoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús jʉmnot wʉt, jʉm-aechon: —Xanlap kaenan, nʉamtan, jiw pasliajwa taj-ax Diosxotse, jaxotse japi jiw duilaliajwa. Jʉm-anbej diachwʉajnakolaxpox Diosliajwa. Xan kaenan xajʉpx kajachawaesliajwan jiw pomatkoicha duilaliajwa. Jiw pajut pijaxtat pasaxil taj-ax Diosxotse. Xan kaenan tajaxtatkal jiw pasaxael taj-ax Diosxotse, xan, me-ama nʉamtan wʉt, ja-an xot. ");
INSERT INTO guoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xamal chiekal xan namatabijam wʉt, chiekal pamatabijaxaelambej taj-ax Dios. Xanlap Dios paxʉlnan. Amwʉtjel xamal matabijam taj-ax Dios. Ja-am wʉt, me-ama najut taj-ax Dios pataenam, xan chiekal namatabijam xot —aech Jesús Tomásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Do jawʉt, Felipe jʉm-aech: —Tajpaklon, ¡xanal natapaem nej-ax taeyax! Ja-am wʉt, xanal kaes asax wʉljoeyaxinil —aech Felipe Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon: —Felipe, pin-iamatkoiyan xamalxotx. Pe nakiowa, chiekal namatabijs-emilfʉk. Xan nataenpi, japi taenbej taj-ax Dios. Ja-aech wʉt, ¿ma-aech xotkat xan nawʉljowam taj-ax taeliajwam? ");
INSERT INTO guoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Xamkat naexasis-emil taj-ax xanxotpox, xanbej taj-axxotaxpox? Xan kaenejchaxoelax, taj-ax sʉapich. Jʉm-an wʉt xamalliajwa japoxan, xan tajut tajaxtat jʉmchi-enil. Taj-ax, pijaxtat jʉm-ansfʉlax. Taj-ax xanxot dukpon, japon isfʉl pejbichax xanxot. ");
INSERT INTO guoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","¡Ampoxlap xamal chiekal naexasi'e! Xan taj-axxotx. Taj-axbej xanxot. Japox naexasis-emil wʉt, ¡japox naexasi'e, xan koechaxan isfʉlax xot! ");
INSERT INTO guoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Xan jʉm-an diachwʉajnakolax. Xan nanaexasiti, japibej isaxael koechaxan, me-ama xan. Do baxael, xan to'axaelen Espíritu Santo, taj-ax poxasax xot. Samata, xan nanaexasitpi kaes xabich koechaxan isaxael Espíritu Santo pijaxtat. Me-ama xan, jachiyaxili. ");
INSERT INTO guoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Puexa xan tajaxtat Dios wʉljowam wʉt, xan japoxan isaxaelen, xamal matabijaliajwam, xan japoxan isx taj-ax Dios pijaxtat —aech Jesús Felipeliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesús pejme jʉm-aech xanal pejnachalwanliajwa: “Xamal xan nanejxasinkam wʉt, ¡tajtato'lax chiekal naexasisfʉlde! ");
INSERT INTO guoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Xan taj-ax Dios wʉljoeyaxaelen asan to'aliajwapon, japon xamal kajachawaesfʉlaliajwa. Samata, taj-ax Dios to'axoek Espíritu Santo. Japon asawʉl Kajachawaesan. Japon pomatkoicha xamalxotaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espíritu Santo diachwʉajnakolax jʉm-aech. Ampathatpijiw, xan nanaexasis-elpi, japi sitae-el Espíritu Santo, tae-el xoti, matabija-el xotbejpi. Pelax Espíritu Santo pomatkoicha xamal nejmatpʉatanxotaxael kajachawaesfʉlaliajwa. Samata, chiekal matabijaxaelam Espíritu Santo. ");
INSERT INTO guoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Xan amxot chijian wʉt taj-ax poxase, xamal tamach waelaxinil. Xan pejme kaxaxoekan xamal poxasik. ");
INSERT INTO guoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kaesʉapich matkoiyan wʉt, ampathatpijiw pejme xan nataeyaxil. Xamallax pejme nataeyaxaelam. Xan tʉpx wʉt, Dios namat-et wʉt, pejme dukaxaelen. Samata, asamatkoi xamal xan tajaxtat pomatkoicha duilaxaelam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Espíritu Santo pask wʉt xamalxot, xamal matabijaxaelam xan taj-ax Diosxotaxpox. Ja-aech wʉt, xamal chiekal matabijaxaelambej xanxotampox. Do jawʉt, xanbej xamalxotaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Matabijapi tajtato'laxan, japoxan naexasit wʉtbejpi, diachwʉajnakolax japi jiw xan nanejxasink. Taj-ax Diosbej japi nejxasinkaxaes, xan nanejxasinkpi. Xanbej japi nejxasinkaxaelen. Ja-an wʉt, japi matabijaxael, achanan xan” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Asan Judas, japon Judas Iscariote-el. Japon wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —Tajpaklon, ¿ma-aech xotkat xanalkal koewan amwʉt natapaeyaxaelam matabijaliajwan, achanamkat xam? ¿Ma-aech xotkatlax xam tapaeyaximil ampathatpijiwbej matabijaliajwa, achanam xam? —aech Judas Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús jʉmnot wʉt, jʉm-aechon Judasliajwa: —Xan nanejxasinkpi, japi naexasisfʉlaxael tajtato'lax. Ja-aech wʉt, japi nejxasinkaxaes taj-ax Dios. Xan, taj-ax Dios sʉapich, fʉlaeyaxaelen duilaliajwan, japi sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jiw nanejxasinka-el wʉt, japi naexasis-el tajtato'laxan, tajnaewʉajnaxanbej. Xan tajut tajaxtat naewʉajna-enil. Japox taj-ax Dios pejnaewʉajnaxan, japon nato'apon ampathatasik —aech Jesús Judasliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Do jawʉx, Jesús jʉm-aech xanal, pejnachalwanliajwa: “Amwʉtjel xamal japoxan jʉm-an, xamalxotx wʉtfʉk. ");
INSERT INTO guoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pe Espíritu Santo xan tajaxtat taj-ax Dios to'axoek xamal nejmatpʉatan poxasik, japon, Espíritu Santo, xamal chanaekabʉanaxael puexa Dios pijaxan. Kajachawaesfʉlaxaelbejpon nejchafaekaliajwam puexa chajia xan jʉm-anpoxan xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Athʉ poxasax wʉt, xamal chiekal pachaemsfʉlaxaelam Diosliajwa. Samata, me-ama xan nejchachaemlax tajnejchaxoelaxtat, xamalbej jachisfʉlaxaelam. Me-ama ampathatpijiw, xan nanaexasis-elpi japi pejnejchachaemlax, jachi-el tajnejchachaemlax. Samata, ¡xamal xabich nabej nejchaxoele'! ¡Xamal nabej nejlewle' bej! ");
INSERT INTO guoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xamallis najʉmtaenam xan athʉ poxaxoeyanpox. Jʉmtaenambej pejme kaxaxoekanpox xamalxotaliajwan. Taj-ax kaes pejme paklon. Me-ama xan jachi-elon. Diachwʉajnakolax xamal xan nanejxasinkam wʉt, xamal nejchachaemlaxaelam xanliajwa, xan jʉm-an wʉt: ‘Xan taj-ax poxaxoeyan’ —an wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Xan japox jʉm-an xamalliajwa. Do baxael, japox ja-aech wʉt, jawʉt xamal xan nanaexasisaxaelam, xan chajia jʉm-an xot. ");
INSERT INTO guoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Kaes piach naksiyaxinil xamalliajwa, fʉlaeyaxael xot Satanás, ampathatpijiw tato'lan. Pe Satanás xan natato'laxil. ");
INSERT INTO guoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ampathatpijiw matabijaxael, taj-ax xabich xan nanejxasinkpox. Samata, xan isfʉlax taj-ax Dios nato'apoxan. “¡Nanim! ¡Chijias amxot!” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Do jawʉt, xanal nʉamtat folx wʉt, Jesús jʉm-aech: “Xan, me-ama uvanaech wʉt, ja-an. Taj-ax, me-ama uvalul tataeflan wʉt, ja-aech. ");
INSERT INTO guoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uvanaedalan, naboes-elpi, tataefʉlpon japadalan pi'a pelsliajwa. Asadalan naboet wʉt, tataefʉlpon japadalan chiekal chaemsaxael, kaes pejme naboesliajwa. Xamal, me-ama japadalan wʉt, ja-am, tajjiwam xot, xan nanaexasitam xotbej. ");
INSERT INTO guoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Xamal naexasitam xan naewʉajnaxpoxan. Samata, amwʉtjel taj-ax Dios beltaen babijaxan isampoxanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ampathatatam wʉt, ¡xan naxanaboejafʉlde! Xanbej xamal chalafʉlaxaelen. Uvanaedalt tasiapchas wʉt, japadalt poklanaexota-el wʉt, uvadalt pajut tamach naboesaxil. Naboesliajwa wʉt, poklanaechantataxael. Xamalbej, me-ama japadalan wʉt, ¡ja-amde! ¡Isfʉlde pachaempoxan, xan naxanaboejam wʉt! Xan naxanaboeja-emil wʉt, isaximil pachaempoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Xan, me-ama uvanaech wʉt, ja-an. Xamal, me-ama japadalan wʉt, ja-am. Xamal xanxochfʉlam wʉt, isfʉlxaelam Dios nejxasinkpoxan. Me-ama uvanaedalan xabich naboesaxael, jachiyaxaelambej xamal. Xan naxanaboeja-emil wʉt kajachawaesliajwan, ja-am wʉt, xamal najut nijaxtat isaximil pachaempoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xan naxanaboeja-elpi, japi isaxil pachaempoxan. Me-ama padalan pi'aspi, jachiyaxaesbej japi jiw. Japadalan majow wʉt, nosaxaes jitat it-owaliajwas jaxot jitat chiekal toejwaliajwaspi. ");
INSERT INTO guoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Xan naxanaboejam wʉt, naexasisfʉlam wʉtbej xan naewʉajnaxpoxan, ja-amsfʉlam wʉt, ¡wʉljoesiampox taj-ax Dios, wʉljoem! Japon japoxan xamal chaxduiyaxael, wʉljowampoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Isfʉlam wʉt pachaempoxan, Dios nejxasinkpoxan, ja-amsfʉlam wʉt, jiw matabijaxael diachwʉajnakolax xamal tajnachalwampim. Jasox ja-amsfʉlam wʉt, taj-ax sitaeyaxaes asew jiw. ");
INSERT INTO guoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Xamal nejxasinkax. Me-ama taj-ax xan nanejxasink wʉt, ja-an xan xamalliajwa. Samata, ¡xan naxanaboejim xamal nejxasinkaliajwan! ");
INSERT INTO guoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Xan naexasisfʉlax taj-ax tato'alpoxan. Samata, taj-ax xabich nanejxasinkafʉl. Xamalbej naexasisfʉlam wʉt xan tato'laxpoxan, ja-am wʉt, xamalbej nejxasinkafʉlaxaelen. ");
INSERT INTO guoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Xan ampoxan jʉm-an xamal nejchachaemlaliajwam. Me-ama xan nejchachaemlax xamalliajwa, xamalbej ja-amsfʉlde xanliajwa. Ja-amsfʉlam wʉt, kaematkoisfʉl xabich nejchachaemlafʉlaxaelam. ");
INSERT INTO guoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Japox jʉm-am wʉt, xamal to'ax nakaewa nanejxasinkaliajwam. Me-ama xamal nejxasinkax, ¡Ja-amdebej xamal, nakaewa nanejxasinkam wʉt! ");
INSERT INTO guoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nejxasinkpon pejnachala, pejnachala beyaxaes wʉt asew jiw, japon pejnachalaliajwa jʉmchiyaxael: ‘¡Tajnachala nabej nawebe'! ¡Xankal naboesim!’ —chiyaxaelon. Japon jasox jachiyaxael, kaes pachaempox isliajwa ajilxot pejnachalaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Isfʉlam wʉt xan tato'laxpox, ja-am wʉt, itpaeyam xamal xan tajnachalwampimpox. ");
INSERT INTO guoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Samata, amwʉtjel xamal jʉmchiyaxinil: ‘Xamal tamakjiwam xanliajwa’ —chiyaxinil, xamal tajnachalwam xot. Pamak matabija-el pejpaklon puexa isaxaelpoxan. Pelax xamal tajnachalwam xot, naewʉajnax puexa taj-ax Dios xan najʉm-aechpoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Xamal nejchaxoelam wʉt, ¡chiekal nejchaxoelde, xamal makanotx xot! Xamal xan namakafis-emil. Samata, to'ax asapaklowaxanpijiw naewʉajnafʉlaliajwam tajwʉajan, isfʉlaliajwambej pachaempoxan Diosliajwa. Japoxan isfʉlam wʉt, japox toepaxil. Ja-amsfʉlam wʉt, taj-ax Dios chaxdusaxael wʉljowampoxan xan tajaxtat. ");
INSERT INTO guoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","¡Xamal to'ax nakaewa nanejxasinkafʉlaliajwam!” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús pejme jʉm-aech xanalliajwa: “Ampathatpijiw, xan nanaexasis-elpi, japi xamal nejweslaxael. Ja-aech wʉt, xamal nejchaxoelaxaelam japi xan matxoela nanejweslapox. ");
INSERT INTO guoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xamal ampathatpijwamkal wʉt, jiw nejweslaxil xamal. Japi nejxasinkaxael xamal. Me-ama pejjiw nejxasink wʉt, jachiyaxaeli xamalliajwa. Pe xamal makanotx, japixotam wʉt. Samata, ampathatpijiw nejwesla xamal, kaes japixota-emil xot. ");
INSERT INTO guoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","¡Nejchaxoelde chajia jʉm-anpox, jʉm-an wʉt: ‘Pamakan kaes paklona-el. Me-ama pejpaklon, jachi-el pamakan’ —an wʉt! Xamalliajwa jachiyaxaelbej. Ampathatpijiw babijaxan is wʉt xanliajwa, japibej isaxael babijaxan xamalliajwa. Asew jiwlax naexasit wʉt tajnaewʉajnax, ja-aech wʉt, xamal naewʉajnampox japi naexasisaxaelbej. ");
INSERT INTO guoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ampathatpijiw babijaxan isaxael xamalliajwa, tajnachalwam xot, japi matabija-el xot taj-ax Dios, xan nato'apon. ");
INSERT INTO guoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Xan fʉlae-enil wʉt japi jiw naewʉajnaliajwan, ja-an wʉt, japi jiw bʉ'wʉajanjilaxael. Pe xan fʉlaenx wʉt, japi naewʉajnaxbej. Japi naexasis-el tajnaewʉajnax. Samata, amwʉtjel jʉmchiyaxili: ‘Xan bʉ'wʉajanjinil’ —chiyaxili. ");
INSERT INTO guoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Xan nanejweslapi, japi nejweslabej taj-ax Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Xan japixot koechaxan is-enil wʉt, japi jiw bʉ'wʉajanjilaxael. Pelis xan koechaxan isx japixot. Pe nakiowa, japi jiw xan nanejwesla. Nejweslabejpi taj-ax Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chajia lelspox jʉm-aech: ‘Masoxtat xan jiw nanejweslaxael’ —aechox. Samata, ampathatpijiw xan nanejwesla. ");
INSERT INTO guoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Xan Espíritu Santo to'axaelen xamal nejmatpʉatanxotaliajwa. Japon asawʉl Kajachawaesan. Espíritu Santo jʉm-aech diachwʉajnakolaxpoxkal. Espíritu Santo fʉloek wʉt taj-axxotsik, jʉmchiyaxaelon pachaempoxan xanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Xan tʉadutx wʉt jiw naewʉajnax, xamal xanxotam. Do jawʉx, hasta amwʉtjel, xan sʉapich, nanʉamtam. Samata, xamalbej jʉmchiyaxaelam pachaempoxan xanliajwa” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús pejme jʉm-aech xanal pejnachalwanliajwa: “Xan jʉmchiyaxaelen ampoxan, xamal tajnachalwam xot, nabijatam wʉt kofasamatam xan naxanaboejampox. ");
INSERT INTO guoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Xan naexasis-elpi, japi xamal jukaxael judíos naewʉajnabachanxot. Ja-aech wʉt, xamal tapaeyaxili pejme leliajwam. Japi ba wʉti xamal, japi nejchaxoelaxael: ‘Xatis baes wʉt Jesús naexasiti, xatis isas Dios nejxasinkpox’ —chiyaxaeli, nejchaxoel wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Japi isaxael babijaxan xamalliajwa, matabija-el xoti taj-ax Dios, xanbej. ");
INSERT INTO guoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Japox xamal jʉm-an nejnejchaxoelaxan mamnikaliajwa. Japamatkoi pat wʉt xamalliajwa, xamal nejchaxoelaxaelam chajia jʉm-anpoxliajwa” —aech Jesús xanal pejnachalwanliajwa. Do pejme Jesús jʉm-aech xanal pejnachalwanliajwa: “Xamal majt ampox jʉmchi-enil, tajut chiekal xamalxotx xot. ");
INSERT INTO guoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pe amwʉt, xan taj-ax Dios, xan nato'apon, poxaxoeyan. Pe kaen xamalxot chinax nawʉajnachaemt wʉt, najʉmchi-el: ‘¿Xam ampoxaxaelamkat?’ —nachi-el. ");
INSERT INTO guoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Xamallax asbʉan jʉmch nejchaemilam, japoxan jʉm-an wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Diachwʉajnakolax xan jʉm-an. Kaes pejme pachaem xamalliajwa xan taj-ax poxaliajwanse. Xan taj-ax poxa-enil wʉt, Kajachawaesan pasaxil xamalxotsik, japon kajachawaesliajwa xamal. Xanlax athʉ poxasax wʉt, ja-an wʉt, to'axoekan Kajachawaesan xamal nejmatpʉatanxotaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Espíritu Santo pask wʉt, ampathatpijiw chiekal pajut matabijaxael japi babijaxan ispoxanliajwa, pachaempoxanliajwabej. Espíritu Santo pijaxtat jiw matabijaxael Dios kastikaxaespox babijaxan ispi. ");
INSERT INTO guoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Espíritu Santo pijaxtatbej jiw matabijaxael japi babijaxan ispox, xan nanaexasis-el xoti Dios bʉ'weliajwas. ");
INSERT INTO guoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Espíritu Santo pijaxtatbej jiw matabijaxael pachaempoxan isliajwa, xan taj-ax Dios poxaxoeyan xot. Xamal kaes nataeyaximil. ");
INSERT INTO guoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Xan nanaexasis-elpi, japi matabijaxael Espíritu Santo pijaxtat kastikaxaespox, babijaxan is xoti. Satanásbej, ampathatpijiw tato'lan, japon asamatkoi kastikaxaes. ");
INSERT INTO guoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Xan xabich kaes xamal jʉmchiliajwan. Pe xamal chiekal jʉmmatabijaximil japoxan. Samata, kaes jʉmchiyaxinil amwʉtjel. ");
INSERT INTO guoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pe Espíritu Santo fʉloek wʉt, japon pijaxtat xamal chiekal matabijaxaelam puexa diachwʉajnakolaxpoxan. Pajut pijaxtat naksiyaxilon. Japon jʉmchiyaxael taj-ax Dios jʉm-aechpoxan, tajnaewʉajnaxanbej. Jʉmchiyaxaelbejpon asamatkoi jachiyaxaelpoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Espíritu Santo kajachawaesaxael jiw xan nasitaeliajwa. Japon puexa taen, xan isxpoxan. Jʉmtaenbejpon puexa tajnaewʉajnaxan. Puexa japoxan xamal chiekal chanaekabʉanaxaelon. ");
INSERT INTO guoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Puexa taj-ax matabijtpoxan, japoxan xanbej matabijtax. Samata, jʉm-an: ‘Puexa matabijtaxpoxan, Espíritu Santobej japoxan matabijt. Do jawʉt, Espíritu Santo xamal chapaeyaxael, japoxan chiekal matabijaliajwam’ —an xan. ");
INSERT INTO guoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kaematkoi wʉtlejen, pejme xan nataeyaximil. Do jawʉx, kaesʉapich matkoiyan wʉt xan pejme nataeyaxaelam” —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Do jawʉt, xanal pejnachalwanpinxot, asew nakaewa najʉm-aech: —¿Achax chiyaxaelkat Jesús jʉm-aech wʉt: ‘Kaematkoi wʉtlejen, kaes xan nataeyaximil. Do jawʉx, kaesʉapich matkoiyan wʉt, xan pejme nataeyaxaelam’ —aech wʉtkat Jesús? ¿Achax chiyaxaelkat japox, pajutliajwa najʉm-aech wʉton: ‘Xan taj-ax Dios poxaxoeyan’ —aech wʉtkaton? ");
INSERT INTO guoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Achax chiyaxaelkat, Jesús jʉm-aech wʉt: ‘Kaematkoi wʉtlejen’ —aech wʉtkat Jesús? Xanal chiekal matabija-enilfʉk achaxliajwa Jesús naksiya —aech asew xanalxot. ");
INSERT INTO guoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús matabijt asew xanalxot wʉajnachaemsasiaspox. Samata, jʉm-aechon japiliajwa: —Xamalliajwa chajia jʉm-an: “Kaematkoi wʉtlejen, kaes xan nataeyaximil. Do jawʉx, kaesʉapich matkoiyan wʉt, xan pejme nataeyaxaelam” —an wʉt, ¿ma-aech xotkat xamal nakaewa nawʉajnachaemtam japoxliajwa? ");
INSERT INTO guoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Diachwʉajnakolax xan jʉm-an. Xamal nejxaejwaxael, xan tʉpx wʉt. Nawʉnoeyaxaelambej. Do jawʉt, ampathatpijiwlax, xan nanaexasis-eli, japilax nejchachaemlaxael, xan tʉpx wʉt. Diachwʉajnakolax xamal nejxaejwaxael xanliajwa. Pe nejnejxaejwax chalechkal toepaxael. Jawʉt nejchachaemilaxkal naliasaxael. ");
INSERT INTO guoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pawis boejpuns wʉt naxʉwlaliajwa, wexaenkas. Jawʉt nabijatpow, wepach wʉt pejmatkoi. Pe paxʉch nalaelt wʉt, japow nabijatpox, xaeyax, nejkiowpow. Japow chiekal nejchachaemil, paxʉch nalaelt xot. ");
INSERT INTO guoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Xamal amwʉtjel ja-am, nejxaejow xot xanliajwa. Xamalfʉk nejxaejwaxael ampamatkoiyantat. Pe pejme xamal taeyaxaelen wʉt, japamatkoitat pejme xamal nejchachaemlaxaelam. Asew jiw toesaxil nejnejchachaemlax. ");
INSERT INTO guoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Japamatkoitat kaes xan nawʉajnachaemsaximil matabijaliajwam, Espíritu Santo pajut xamal chanaekabʉanafʉlaxael xot. Diachwʉajnakolax xan jʉm-an. Taj-axbej chaxduiyaxael puexa xamal wʉljowampoxan xan tajaxtat. ");
INSERT INTO guoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta amwʉtjel, xamal taj-ax Dios chinax wʉljoe-emil xan tajaxtat. Pe amwʉtjel xan tajaxtat taj-ax Dios wʉljoeflaxaelam. Taj-ax Dios chaxduiyaxael xamal wʉljowampoxan xan tajaxtat. Ja-am wʉt, xabich nejchachaemlaxaelam nejnejchaxoelaxantat” —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesús pejme jʉm-aech xanal pejnachalwanliajwa: “Me-ama majt wʉajantat jʉm-an xamal naewʉajnax wʉt, jasoxtat pejme naewʉajnaxinil. Pe asamatkoi jʉmchiyaxaelen xabich tampoela-elaxtat taj-ax Diosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Japamatkoitat xamal najut xan tajaxtat taj-ax Dios wʉljoeyaxaelam, kawʉajnam wʉt wewe'ppoxanliajwa. Xamalliajwa xan wewʉljoeyaxinil taj-ax Dios, taj-ax tapaei xot xamal najut wʉljoeliajwam, nejxasink xoton. Taj-ax Dios nejxasink xamal, xan nanejxasinkam xot, naexasitam xotbej xan fʉloekponanpox Diosxotsik. ");
INSERT INTO guoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xan fʉloekx taj-axxot pasliajwan ampathatat. Amwʉt athʉ poxaxoeyan taj-ax poxase” —aech Jesús xanal, pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Do jawʉt, xanal japon pejnachalwan jʉm-an: —Amwʉtjel xam jʉm-am chiekal tampapoxtat. Kaes naewʉajna-emil wʉajantat. ");
INSERT INTO guoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Amwʉtjel xanal matabijax xam puexa matabijtamponam. Xam chajia chiekal matabijtam xanal wʉajnachaemsasianpoxan xam. Samata, chiekal xanal chanaekabʉanam wʉt, kaes nawewe'pa-el xam wʉajnachaemsliajwan. Samatabej, xanal chiekal naexasitx xam Diosxotsik fʉloemkponampox —an xanal Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús jʉmnot wʉt, jʉm-aechon xanalliajwa: —Xamal amwʉtjel xan chiekal nanaexasitam. ");
INSERT INTO guoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pelis tajhora nawepat. Amwʉt xamal nasalaxaelam nejlel, asew jiw babijax isaxael xot xanliajwa. Tamach nawaelsaxaelam, nejlewla xot. Pelax xan tamachaxinil, taj-ax nachala xot. ");
INSERT INTO guoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Xan japoxan jʉm-an xamal nejlewlasamata, xamal xan naxanaboejam xot. Ampathatatam wʉt, nabijasaxaelam. Pe nabijatam wʉt, ¡xamal nabej nejlewle'! ¡Xanlis malechax chaemilpoxan ampathatat! —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús bʉxtoet wʉt jʉm-aechpox xanalliajwa, do jawʉt, athʉ natachaemsepon. Pax Dios kawʉajan wʉt, jʉm-aechon: “Ax, tajmatkoi nawepat. ¡Jiw itpaem xan mamnikaxponanpox, naxʉlnan xot! Ja-aech wʉt, xanbej itpaeyaxaelen xam xabich mamnikamponampox. ");
INSERT INTO guoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Xam natapaeyam puexa jiw tato'laliajwan. Samata, xan naxʉlnan kajachawaesaxaelen xan nanaexasiti, japi pomatkoicha duilaliajwa xamxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ax, xam kaenam Diosnam. Do kaes asan, Dios, chiekal jil. Xanbej Cristowan, xam nato'amponan ampathatasik. Jiw xatis naknaexasit wʉt, japi jiw duilaxael pomatkoicha xatisxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Toetx tajbichax, xam nato'ampox isliajwan. Jiw, ampathatpijiw, itpaeix xam xabich mamnikamponampox, xam chiekal sitaeliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ax, chajiakolaxtat, ampathat ajil wʉtfʉk, jawʉt xanbej xamxotx. Jaxotse, xam sʉapich, puexa tato'lax xam nijaxtat. ¡Amwʉtjel pejme jasox isde xanliajwa, xamxotaxaelen wʉt! ");
INSERT INTO guoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ampathatpijiwxot, asew xam makanotam, japi jiw xan nanaexasisfʉlaliajwa. Xan tajaxtat japi matabijafʉl, achanam xam. Majt japi jiw xam nejjiw. Pe amwʉtjel, japibej xan tajjiw. Japi jiw naexasisfʉlbej nejjamechan. ");
INSERT INTO guoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Japi jiw amwʉtjel matabija xam nijaxtat xan puexa isfʉlaxpox. ");
INSERT INTO guoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Majt najʉm-ampoxan, japoxan xan japi jiw naewʉajnax. Amwʉtjel japi naexasisfʉl japanaewʉajnaxan. Amwʉtjel japi pajut matabijabej diachwʉajnakolax xan fʉloekxponan xamxotsik. Matabijabejpi xam nato'amponanpox. ");
INSERT INTO guoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Xan nanaexasitpi, japi jiwliajwa xam kawʉajnax. Xan kawʉajna-enil ampathatpijiwliajwa, japi xam naexasis-elpiliajwa. Xanlax kawʉajnax xam makanotampiliajwa, japi xan nanaexasisfʉl, xam nejjiw xot. ");
INSERT INTO guoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Xan tajjiwpi, japibej puexa xam nejjiw. Puexa xam nejjiwpi, japibej xan tajjiw. Japi jiw ispoxantat asew jiw, xan nanaexasis-elpi, nasitaen. ");
INSERT INTO guoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Xan kaes namanaxinil ampathatat, xam poxaxoeyan xot. Pelax tajjiw namaeyaxael ampathatat. Ax, pomatkoicha pachaemamponam, tajjiw chiekal nawetataeflaxaelam, asew jiw babijaxan isasamata japiliajwa. Xam kawʉajnax japi nakaewaliajwa kaenejchaxoelaxliajwa. Me-ama xatis kaenejchaxoelax, japibej jachisfʉlaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Xan, japi sʉapich, dukx wʉt, chiekal tataeflax xam nijaxtat. Nawenafo'a-el, xan nanaexasiti xot. Kaenlax japixot nafo'a, fʉlaeyaxaelpon infierno poxade. Me-ama nejjamechan chajia lelspox jʉm-aech japonliajwa, japox ja-aechlisox. ");
INSERT INTO guoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Amwʉt xam poxaxoeyan. Ampox xam jʉm-an, ampathatxotx wʉtfʉk, xan nanaexasitpi chiekal nejchachaemlaliajwapi, me-ama xan nejchachaemlax wʉt, jachiliajwapi. ");
INSERT INTO guoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Xan japi naewʉajnax nejjamechan. Samata, ampathatpijiw nejweslaspi, ampathatpijwa-el xoti. Xanbej ampathatpijna-enil. ");
INSERT INTO guoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Xan wʉljoe-enil xam jukaliajwam xan nanaexasiti ampathatxot. Xanlax wʉljowx japi nawetataeflaliajwam, Satanás naekichachajbasamatasbejpi. ");
INSERT INTO guoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Amwʉtjel japi ampathatpijwa-el. Me-ama xan ampathatpijna-enil, ja-aechbej japi. ");
INSERT INTO guoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","¡Kajachawaesfʉlde isfʉlaliajwapi xam nejxasinkampoxan, diachwʉajnakolaxpoxan! Nejjamechan diachwʉajnakolax. ");
INSERT INTO guoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Xan to'ax japi naewʉajnaliajwapi ampathatpijiw, me-ama xam xan nato'am ampathatpijiw naewʉajnafʉlaliajwan. ");
INSERT INTO guoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Xan thiltax isfʉlaliajwan xam nejxasinkampoxan. Japoxan xan isfʉlax xan nanaexasitiliajwa. Do jawʉx, japi isfʉlaxael xam nejxasinkampoxan. Jasox isfʉl wʉt, isfʉlaxael pachaempoxan, matabija xoti nejjamechan, diachwʉajnakolaxpox. ");
INSERT INTO guoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Xam kawʉajnax wʉt, kawʉajna-enil xan nanaexasitpikalliajwa. Kawʉajnaxbej asew jiwliajwa, japi asamatkoi naexasisaxaelpi tajwʉajan, naewʉajan wʉt xan nanaexasiti. ");
INSERT INTO guoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ax, xam kawʉajnax xan nanaexasitiliajwa, puexa japi kaenejchaxoelaxliajwa. Xatis kaeyax chiekal nejchaxoes. Kawʉajnax japibej kaenejchaxoelaxliajwa, xatis sʉapich, ampathatpijiw matabijaliajwa xam nato'amponanpox ampathatasik. ");
INSERT INTO guoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Xan tajpamamax chaxdutx japi. Japox najʉp, me-ama xam nachaxdutampox. Jasox isx japi kaenejchaxoelaxliajwa. Me-ama xatis kaeyax chiekal nejchaxoes, japibej jachiliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Do jawʉt, japi chalaxaelen, me-ama xam xan nachalam chiekal kaenejchaxoelaxliajwan, xam sʉapich. Do ja-aech wʉt, ampathatpijiw chiekal xan namatabijaxael xan nato'amponanpox. Do jawʉt, ampathatpijiw pajut matabijaxaelbejpi xam jiw nejxasinkampox, me-ama xan nanejxasinkam wʉt, ja-ampox jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ax, xan nejxasinkax jiw xanxotaliajwa, xam makanotampi xan nanaexasisliajwa. Nejxasinkaxbej puexa japi jiw matabijaliajwa xan xabich tajpamamaxpox, xam nachaxdutampox, xam chajia xan nanejxasinkam xot, that is-esal wʉtfʉk. ");
INSERT INTO guoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ax, xam xabich pachaemam. Ampathatpijiw xam matabija-el. Pe xan matabijtax xam. Xan nanaexasiti matabija diachwʉajnakolax xan nato'amponanpox. ");
INSERT INTO guoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xan jʉm-an nanaexasitiliajwa, ma-am xam. Japoxlap jʉmchisfʉlaxaelen. Do ja-aech wʉt, japi jiw nakaewa nanejxasinkafʉlaxael. Me-ama xam xan nanejxasinkafʉlam wʉt, jachiyaxaelbej japi jiw. Xanbej pomatkoicha japixotaxaelen” —aech Jesús, pax Dios kawʉajan wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús bʉxtoet wʉt pax Dios kawʉajanpox, fʉlaech wʉton, xanalbej, japon pejnachalwan, nakfʉlaechx. Minlajt pʉtkalpox xenax. Japaminlajt, pʉtkalpox, pawʉl Cedrón. Xenaxxot olivonaechan nuil. Olivonaechan nuilxot Jesús xanal nabʉ'pat. ");
INSERT INTO guoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, wiasaxaelpon Jesús padaelmajiwxot, japon chiekal matabijt xanal jaxotaxaelenpox, jaxot chajia Jesús pin-iaveces jinatameja xot, xanal sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Samata, Judas kaemʉt soldaw bʉ'pa'an jaxot. Bʉ'pa'anbejpon Dios pejtemploba weti. Japi to'as sacerdotespaklochow, fariseosbej. Xafoli iwa, espadas, lanzasbej. Kelafolbejpi baenthnaechan, xape'asi naetat italiafaliajwa, fol xoti madoi. Kelafolbejpi lámparas. ");
INSERT INTO guoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús chajia matabijt japonliajwa jachiyaxaespox. Samata, Jesús jaxot fʉlaech bʉ'kakʉlnaliajwapon fʉlaeni. Do jawʉt, jʉm-aechon japi jiwliajwa: —¿Achankat xamal wʉlwekam? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kaen japixot jʉmnot wʉt, jʉm-aechon Jesúsliajwa: —Xanal wʉlwekx Jesús, Nazaret paklowaxpijin —aechon. Jesús jʉm-aech: —Xanlap nawʉlwekamponan —aechon. Judas, wiasaxaelpon Jesús, japixot nukon. ");
INSERT INTO guoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús jʉm-aech wʉt: ‘Xanlap nawʉlwekamponan’ —aech wʉt, japi soldaw, asew jiwbej, chalechkal tʉakre'xalaenki. Jawʉt satat oeljabapi. ");
INSERT INTO guoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jawʉt, Jesús pejme wʉajnachaemt wʉt, jʉm-aechon: —¿Achankat xamal wʉlwekam? —aech Jesús. Japi pejme jʉm-aech: —Xanal wʉlwekx Jesús, Nazaret paklowaxpijin —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jawʉt Jesús pejme jʉm-aech japiliajwa: —Xan jʉm-an: ‘Xanlap nawʉlwekamponan’ —an xan. Xan nawʉlwekam wʉt, ampi, tajnachala, ¡chijiyax tapaem! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Japox ja-aechlisox, Jesús pajut jʉm-aechpox jachiliajwa: “Ax, nachaxdutampi, chinax kaen nawenafo'a-el” —aech Jesús, majt chajia kawʉajan wʉt pax Dios. ");
INSERT INTO guoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Do jawʉt, Simón Pedro chalechkal pej-espada kukchapon. Jawʉt kaen aton, cho'chikchapon, poklalel pejcho't. Japon pawʉl Malco. Japon nabist sacerdotespaklokolanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Do jawʉt, Jesús jʉm-aech Pedroliajwa: —¡Nej-espada jemk ta-akadik! Diachwʉajnakolax xan jʉm-an. Xan nabijasaxaelen. Me-ama taj-ax Dios chajia jʉm-aech nabijasliajwan, japox ma amwʉt jachiyaxael —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Do jawʉt, soldawcapitán, pejsoldaw sʉapich, malis Dios pejtemploba wetibej, japi judíospi, japi jaelt Jesús. Do jawʉt, Jesús mʉatat kʉs. ");
INSERT INTO guoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Matxoela bʉflaechipon Anás pejba poxade. Japon Anás, Caifás pʉax. Caifás sacerdotespaklokolan japawaestat. (Anásbej majt sacerdotespaklokolan asawaestat.) ");
INSERT INTO guoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás chajia jʉm-aech judíospaklochowliajwa: “Kaes pejme pachaem, kaen aton tamach tʉpliajwa. Jasoxtat xabich jiw tʉpaxil” —aech Caifás, chajia jʉm-aech wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesús bʉ'fos wʉt, Simón Pedro wʉchakal atʉaxach fol. Xan, tawʉlponan Juan, wʉchakal atʉaxach folxbej. Sacerdotespaklokolan xan namatabijt. Samata, xan tamach lowx bafʉlmaktxot Jesús pejwʉchakal. ");
INSERT INTO guoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pe Pedro naman tathoetat, bafafaxot. Do jawʉt, xan kaxandax. Sacerdotespaklokolan xan namatabijt xot, bafafa wetpow kawʉajnax, Pedrobej leliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedro bafʉlmaktxot low wʉt, japow wʉajnachaemtason. Japow jʉm-aech: —¿Xamkatlap jaeltaspon pejnachalnam? —aechow. Pedro jʉmnot wʉt, jʉm-aech: —¡El! ¡Xan japon pejnachalna-enil! —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Xabich thʉnk xot, Caifás pamak, Dios pejtemploba wetibej, jit itfoti. Jaxot japi jiw jit su'chanuil. Pedrobej jaxot jit naksu'chanuk. ");
INSERT INTO guoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Do jawʉt, sacerdotespaklokolan tʉadutlison wʉajnachaemsliajwapon Jesús pejnachalapiliajwa, naewʉajanpoxliajwabej. ");
INSERT INTO guoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Japon bʉxtoet wʉt wʉajnachaemsax, Jesús jʉm-aech: —Xan tulaela jʉm-an jiw pejwʉajnalel. Naewʉajnaxbej judíos naewʉajnabachanxot, Dios pejtemplobaxotbej, judíos natameja wʉt. Xan maliach naewʉajna-enil. ");
INSERT INTO guoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ma-aech xotkat nawʉajnachaemtam japoxan? ¡Wʉajnachaemde najʉmtaenpi! Japi chiekal matabija xan jʉm-anpoxan. Japi jʉmchiyaxael, achax xan jʉm-an, jiw naewʉajnax wʉt —aech Jesús sacerdotespaklokolanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús japox jʉm-aech wʉt, kaen Dios pejtemploba wetpon ke-etat xuselchapon Jesús. Do jawʉt, jʉm-aechon: —¿Ma-aech xotkat xam japox jʉm-am sacerdotespaklokolanliajwa? —aechon, palala xot. ");
INSERT INTO guoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús jʉmnot wʉt, jʉm-aechon: —Babejjamechan jʉm-an wʉt, ¡najʉm-amde, achaxkat chaemil xamliajwa! Xan jʉm-anpox diachwʉajnakolax wʉt, ¿ma-aech xotkat naxuselcham? —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Do jawʉt, japi wʉajnachaemsax bʉxtoet wʉt, Jesús kʉs wʉtfʉk, Anás to'a soldaw Jesús bʉflaeliajwas Caifás poxade, jaxotde kaes pejme wʉajnachaemsliajwas Jesús, japon sacerdotespaklokolan xot. ");
INSERT INTO guoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro nakiowa jaxot jit naksu'chanuk. Jawʉt jaxot su'chanuili, japibej jʉm-aech Pedroliajwa: —¿Xamkatlap jaeltaspon pejnachalnam? —aechi. Pedro jʉmnot wʉt, jʉm-aechon: —¡Xan jaeltaspon pejnachalna-enil! —aech Pedro. ");
INSERT INTO guoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sacerdotespaklokolan pamakan jaxot nuk. Japon cho'chikchaspon pejwʉl-aton. Japonbej wʉajnachaemt wʉt, jʉm-aechon Pedroliajwa: —¿Xamkat bej taenxbej, nukam wʉt, Jesús sʉapich, olivonaechanxot? —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro pejme xanalia wʉt Jesúsliajwa, jawʉt kawaema nejla. Me-ama Jesús chajia jʉm-aech, ja-aechlisox. ");
INSERT INTO guoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Do kandiawasap wʉt, juimt jula-el wʉtfʉk, judíos bʉflaeni Jesús Caifásxotdin, asaba poxade. Japaba, Pilato pejba, xabich pinaba. Japon gobernador Judea tʉajnʉxot, to'as xoton Roma gobierno. Japabaxot pat wʉt, judíos le-el gobernador pejba, xaeyaxael xoti Pascuafiestanaxaeyax. Judíos leyaxael wʉt judíos-atona-el pejba, judíos xaeyaxil Pascuafiestanaxaeyax. Ja-aech judíos pejkabʉanpox. ");
INSERT INTO guoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Samata, Pilato nakolde pejbaxot nospaeliajwa, judíos sʉapich. Do jawʉt, jʉm-aechon japiliajwa: —¿Achaxkat Jesús is xamal tasalaliajwam japon? —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Do jawʉt, judíos chiekal jʉmnos-el wʉt, jʉm-aechi asbʉan jʉmch: —Japon aton babejna-el wʉt, xanal japon bʉflaeyaxinil xamlel —aech judíos Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Do jawʉt, Pilato jʉm-aech judíosliajwa: —¡Xamal najut japon aton bʉflaem kastikaliajwam, me-ama xamal nejkabʉan! —aech Pilato judíosliajwa. Judíos japox jʉmtaen wʉt, jʉm-aechi: —Xam tapae-emil, xanal judíos tajut kastikaliajwan, boesaliajwanbej aton —aech judíos Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Japox ja-aechlisox, me-ama Jesús chajia jʉm-aech, achaxtat tʉpaxaelon. ");
INSERT INTO guoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Do jawʉt, Pilato lechlison batuchade. Jawʉt jʉmxato'apon Jesús fʉlaeliajwa Pilatolel. Do jawʉt, Pilato jʉm-aech, Jesús wʉajnachaemt wʉt: —¿Xamkatlap diachwʉajnakolax puexa judíos pejreynam? —aech Pilato Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús jʉmnot wʉt, jʉm-aech: —¿Xamkat najut nijaxtat japox xan nawʉajnachaemtam? O, ¿asew jiw jʉm-aech wʉt, jʉmtaenam xot, xan japox nawʉajnachaemtam? —aech Jesús Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato jʉmnot wʉt, jʉm-aechon Jesúsliajwa: —Xan judíos-atona-enil. Nejjiw, judíos, sacerdotespaklochowbej, japi xam bʉflaen xanlel jʉmchiliajwa xam nejbʉ'wʉajnampoxliajwa. ¿Achababijaxkat isam japi palalaliajwapi xamliajwa? —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús jʉmnot wʉt, jʉm-aechon: —Xan jiw tato'la-enil ampathatat. Xan jiw tato'lax wʉt ampathatat, tajjiw nabeyaxael judíospaklochow, pejjiw sʉapich, akanajaels xan nawias-elaliajwapi judíospaklochowxot. Xan jiw tato'la-enil ampathatat —aech Jesús Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Do jawʉt, Pilato pejme wʉajnachaemt wʉt, jʉm-aechon: —¿Xamkatlap diachwʉajnakolax reyponam? —aech Pilato. Jesús jʉmnot wʉt, jʉm-aechon: —Diachwʉajnakolax, me-ama xam jʉm-am. Xanlap jiw reyponan. Samata, xan nalaeltax pawistat. Jasoxtat fʉloekx ampathat poxasik jiw naewʉajnaliajwan diachwʉajnakolaxpox. Puexa jiw matabijasiapi diachwʉajnakolaxpox, japi jiw xan najʉmtaen. Japi jiwbej xan nanaexasit —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Do jawʉt, Pilato jʉm-aech: —¿Achaxkat diachwʉajnakolaxpox? —aechon. Dolisdo', Pilato wʉajnachaemsax bʉxtoet wʉt, nakoldepon jʉmchiliajwa judíos. Do jawʉt, Pilato jʉm-aech judíosliajwa: —Xan faena-enil babijax japon ispox. Kastikaxisalbejpon. ");
INSERT INTO guoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Xamal nejkabʉan. Pascuafiesta isam wʉt, xamal xan nawʉljowam kaen aton jiw jebaxot jiaspon nakolsax tapaeliajwan. ¿Xamalkat nejxasinkam xan nakolsax tapaeliajwan jʉmtispon: ‘Judíos pejrey’ —tispon? —aech Pilato judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Judíospaklochow, asew jiw sʉapichbej, pinjametat jʉm-aechfʉli Pilatoliajwa: —¡Japona-el! ¡Barrabás nakolsax tapaem! —aech xabich jiw. Barrabás jiw jebaxot jias, kethakan xot. Japon majt nababej, Pilato pejsoldaw sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Do jawʉt, Pilato keto'a soldaw Jesús selsliajwas. Samata, jawʉt, Jesús bʉflaech wʉt, jaxotde Jesús seltas pakmʉat kabʉanchiyaxtat. ");
INSERT INTO guoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ketoech wʉt selsax, xakoeyapi na-e'lʉ Jesús matlʉa'sliajwas. Do jawʉt, matlʉa'tas wʉt, xajoelsbejpon, me-ama rey pijax, jasox. Japox chikjiana pasoeyaxlejen. ");
INSERT INTO guoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Do jawʉt, me-ama jiw tato'lan wʉt, ketispon. Japi soldaw ketaxaxaelali Jesús. Do jawʉt, moxdepi Jesúsxot. Jawʉt jʉm-aechi Jesús pejwʉajnalel: —¡Moi, judíos pejrey! —aechi. Jawʉt xuselbalas Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato pejme nakolt pejbaxot. Do jawʉt, jʉm-aechon judíos pejwʉajnalel: —¡Xan chiekal nanaewe'e! Jesús bʉflaenx xamal chiekal matabijaliajwam, chinax xan babijax faena-enil, japon ispox —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Do jawʉt, Jesús xajoels pakchowax. Japox chikjiana pasoeyaxlejen. Xakoeyaspox, na-e'lʉ, matlʉa'tas Jesús. Jawʉt Pilato jʉm-aech: —¡Taem! ¡Ama xamal tasalampon! —aechon judíosliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Do jawʉt, sacerdotespaklochow, Dios pejtemploba wetibej, Jesús taen wʉti, nejlasfʉl wʉt, jʉm-aechi Jesúsliajwa: —¡Kematamatalde cruztat! ¡Kematamatalde cruztat tʉpaliajwa! —aechfʉli. Pe Pilato jʉm-aech: —¡Xamal najut bʉflaem cruztat kematamatlaliajwam! Xan chinax faena-enil babijax japon ispoxan kematamatlaliajwan cruztat —aech Pilato japi jiwliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judíospaklochow jʉmnot wʉt, jʉm-aechi Pilatoliajwa: —Moisés chajia lelpox xanal naexasisfʉlax. Japawʉajanxot to'a, me-ama ampon aton, jason kastikaliajwas, boesaliajwasbejpon, japon pajut najʉm-aech xot: ‘Xan Dios paxʉlnan’ —na-aech xoton —aech judíospaklochow Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato jʉmtaen wʉt japi jʉm-aechpox Jesúsliajwa, jawʉt kaes pejme pejlewlapon Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Samata, pejme pejba lechon, Jesús sʉapich. Jaxotde pejme Pilato wʉajnachaemt wʉt, jʉm-aechon Jesúsliajwa: —¿Amxotpijnamkat xam? —aech Pilato Jesúsliajwa. Pilato japox wʉajnachaemt wʉt, Jesús kaes jʉmnos-el. ");
INSERT INTO guoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Do jawʉt, Pilato jʉm-aech: —¿Xamkat kaes najʉmnosaximil wʉajnachaemtaxpox? ¿Xamkat matabijs-emil xan xajʉpxpox xam nakolsax tapaeliajwan, o, to'aliajwanlax soldaw cruztat xam kematamatlaliajwa, tʉpaliajwambej? —aech Pilato. ");
INSERT INTO guoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Do jawʉt, Jesús jʉmnot wʉt, jʉm-aechon Pilatoliajwa: —Dios tapaei xam tato'laliajwam ampatʉajnʉpijiw. Dios tapae-el wʉt jiw tato'laliajwam, xam najut nijaxtat ampatʉajnʉpijiw tato'laximil. Aton nawiatpon xamxot, japon aton kaes pejme pejbʉ'wʉajan Diosliajwa. Me-ama xam, jachiyaxilon —aech Jesús Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Do jawʉt, Pilato nakolsax tapaesiapon Jesús. Pe judíos nejlasfʉl wʉt, jʉm-aechfʉli: —Japon nakolsax tapaeyam wʉt, xam kaenejchaxoelaxa-emil, nejrey sʉapich, dukpon Roma paklowaxxot. Nejmach-aton rey nadofasia wʉt, japon aton Roma tʉajnʉpijiw tato'lan padaelmanaxael —aech judíos Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato, japox jʉmtaen wʉt, lapon soldaw, japi bʉflaeliajwa Jesús japonlel. Do jawʉt, Pilato ek pejtʉa-ekaxtat. Jaxot pawʉl Gabata hebreojametat. Japox jʉmchiliajwa: “Ia' dadapopox, me-ama pisolejen” —chiliajwa japox. ");
INSERT INTO guoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kaematkoi we'pfʉk Pascuafiestaliajwa. Matnoch juimt ek wʉt, Pilato jʉm-aech judíosliajwa: —¡Amponlap nejrey! —aech Pilato Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pelisdo', judíos nejlasfʉl wʉt, jʉm-aechfʉli: —¡Kematamatalde cruztat tʉpaliajwa! —aechfʉl, judíos nejlasfʉl wʉt. Pilato wʉajnachaemt wʉt, jʉm-aechon: —¿Xamalkat nejxasinkam nejrey kematamatlaliajwas cruztat? —aech Pilato judíosliajwa. Sacerdotespaklochow jʉmnot wʉt, jʉm-aechi: —¡Japon xanal tajreya-el! ¡Xanal kaen tajrey! ¡Japon Roma tʉajnʉpijiw tato'lan! —aechi. ");
INSERT INTO guoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Do jawʉt, Pilato to'a soldaw Jesús bʉflaeliajwas, kematamatlaliajwas cruztat, tʉpaliajwabejpon. Do jawʉt, soldaw Jesús bʉ'fos kematamatlaliajwas cruztat. ");
INSERT INTO guoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Do jawʉtbej, soldaw bʉ'follisi Jesús mʉax poxade. Japamʉax pawʉl Matnaethitmʉax. Jesús pajut xafol cruz. (Hebreojametat japamʉaxliajwa jʉm-aechi: “Gólgota” —aechi.) ");
INSERT INTO guoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Japamʉaxxot Jesús kematamatlas cruztat, kolenje kethakan sʉapich. Japi kaenanʉla kematamatlas pejcruztat. Jesús pejkolelelje chanuili. ");
INSERT INTO guoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato to'a lelaliajwapi tawlaf chadusliajwa Jesús pejcruztat, jiw matabijaliajwa, ma-aech xot Jesús tʉpaxael cruztat. Samata, lelspox jʉm-aech: “Jesús, Nazaret paklowaxpijin, japon judíos pejrey” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesús kematamatlasxot mox Jerusalén paklowax. Samata, xabich judíos xaljow pale, tawlaftat chaduchpox. Japatawlaftat lels tresjamechantat. Kaejame lels hebreojametat. Segundojame lels latínjametat. Tercerojame lels griegojametat. ");
INSERT INTO guoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Do jawʉt, sacerdotespaklochow fʉlaech Pilato poxade. Pat wʉti Pilatoxot, jʉm-aechi nejthʉ'axtat: —¿Ma-aech xotkat lelampox jʉm-aech: ‘Judíos pejrey’ —aechkatox, lelampox? ¡Japox chaku'e! ¡Asax lelde! ¡Nej jʉm-aechepox: ‘Jiw naewʉajan wʉt, jʉm-aechon pajutliajwa: “Xan judíos pejreynan” —aechon’ —nej ja-aeche' lelampox! —aech paklochow Pilatoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato jʉmnot wʉt, jʉm-aechon: —Ma xan iketo'ax, do japoxtat lelslisox —aech Pilato judíospaklochowliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesús kematamatla-esal wʉtfʉk, japi cuatro soldaw Jesús naxoeipoxan wejoltipon. Cruztat kematamatal wʉti, Jesús naxoeipoxan japi soldaw not kaenanʉla xadadiajpaliajwa. Matxoelapijax, pakchowax, naxoeldikpox, japoxbej wefitipon. Japox popbʉ'kal, ithoe-esal, chiekal baelspoxkal. ");
INSERT INTO guoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Soldaw nakaewa najʉm-aech japoxliajwa: —¡Xatis ampox nabej thiastis! Nakakujsaxaes ia'xix matabijaliajwas, achan kanaxael japox —na-aechi nakaewa. Do jawʉt, nakakujtlisi ia'xix. Islisi japox, me-ama Dios pejjamechan, chajia lelspox, jʉm-aech Jesúsliajwa. Jʉm-aechox: “Diajkaxaeli xan naxoeixpoxan nakaewaliajwa. Asbʉan jʉmch nakakujsaxaeli matabijaliajwa, achan kanaxael matxoelapijax, naxoelax” —aech chajia lelspox japoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús cruztat chanukxot, japon pen jaxot mox. Jaxotbej Jesús penow. Japow pawʉl María, Cleofas pijow. Jaxotbej asaow María. Japow Magdala paklowaxpijow. ");
INSERT INTO guoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús pen taen wʉt moxpox, xanbej, Jesús nanejxasinkponan, mox nukx japowxot. Jawʉt Jesús jʉm-aech penliajwa: —En, amwʉtjel xamliajwa Juan, me-ama naxʉlan wʉt, ja-aechon —aech Jesús penliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jawʉt Jesús jʉm-aechbej xanliajwa: —Juan, xam amwʉtjel taj-en, me-ama nej-en wʉt, ja-aechow. Samata, chiekal nawetataeflaxaelam —aech Jesús xanliajwa. Japamatkoitat, Jesús tʉpaxwʉx, xan tajba poxadax wʉt, japow bʉflaechx tataeflaliajwan. ");
INSERT INTO guoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Do jawʉt, Jesús matabijt puexa chiekal toepox japonliajwa, me-ama Dios pejjamechan, chajia lelspox, jʉm-aech, jachiliajwapox. Jesús jʉm-aech: —Xan minsila —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jaxot vino, xathunkpot, cha-ek jarrotat. Kaen aton esponja, paputhkax, xathot japavino poxadik. Xathot wʉt, esponja xakoeya nae-oeftat Jesús suiliajwa. Japanaeya pawʉl hisopo. Do jawʉt, xachosapon Jesús pejkaecha poxase. ");
INSERT INTO guoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Do jawʉt, japox Jesús suw wʉt, vino, jʉm-aechon: —Puexa, xan isxpoxan, toetx —aechon. Jawʉt, Jesús natxatdik wʉt, tʉplison. ");
INSERT INTO guoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kaematkoi we'p wʉt Pascuafiestaliajwa, napatamatkoiyaxael xotbej, judíospaklochowliajwa wepachaema-esal Jesús kaes chanukaliajwa cruztat, asewbej. Japamatkoi, napatamatkoi, judíos kaes pejme sitaen, Pascuafiestamatkoiyaxael xot. Samata, jawʉt, chawʉajnachaemsmatkoi wʉt, judíospaklochow Pilato poxade wʉljoeliajwa, japon keto'aliajwa soldaw bejalbalaliajwas cruztat kematamatlaspi, kamta japi tʉpaliajwalejen, jawʉx kuiliajwas cruzxotsik, mʉthaliajwasbejpi. ");
INSERT INTO guoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Do jawʉt, Pilato to'a wʉt soldaw, japi fʉlaech kematamatlaspi poxade. Pat wʉti jaxot, matxoelapijin bejalchapi, japon tʉpa-el xotfʉk. Asan, asalel chanukpon, bejalchasbej. ");
INSERT INTO guoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Soldaw mox wʉt Jesúsxot, taeni Jesús tʉppox. Samata, Jesús bejalcha-esal. ");
INSERT INTO guoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Do jawʉt, kaen soldawan Jesús chenaxʉa'la lanzatat, chiekal matabijsliajwa diachwʉajnakolax Jesús tʉp wʉt, o, ja-el wʉt. Jawʉt chalechkal jal nakola. Nakolabej min. ");
INSERT INTO guoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Xan Juan lelx japoxan. Taenxpoxan diachwʉajnakolax. Samata, jʉm-an diachwʉajnakolaxpox, xamalbej chiekal naexasisliajwam xan jʉm-anpoxan Cristoliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Japoxan ja-aech, me-ama Dios pejjamechan, chajia lelspox, jʉm-aech japox jachiliajwa. Chajia jʉm-aechox: “Japon chinax kaethit wejalchaxisal” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chajia asafʉt jʉm-aechbejpox lelspox: “Taeyaxaeli kaen aton, chenaxʉa'laspon” —aechox. ");
INSERT INTO guoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jesús tʉp wʉt, José, Arimatea paklowaxpijin, fʉlaechon Pilato poxade. Pat wʉton Pilatoxot, José kawʉajan Pilato, patʉpan Jesús xalaeliajwapon, osliajwabejpon mʉaxwʉajxot. Japon José maliach naexasit Jesús, pejlewla xoton judíospaklochowliajwa. Do jawʉt, Pilato najaw-aech José xalaeliajwa patʉpan Jesús. Samata, fʉlaechon patʉpan poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo, japon majt fʉlaechpon madoi nospaeliajwa, Jesús sʉapich, japon xapat treinta kilos xabejasapan Jesús kematamatlasxot. Japasapan, tanialas mirrasapan, áloebelenbej, patʉpan joelaliajwapoxan. ");
INSERT INTO guoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Do jawʉtbej, José, Nicodemo sʉapich, chaxfoli patʉpan Jesús. Mamochbʉ'antat, pokchobʉ'an, matxakoeyapi patʉpan, xabejasapan joelapi patʉpan. Ja-aech, judíos is wʉt pejwʉajnapijiw pijax, patʉpan mʉthsliajwa wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús cruztat kematamatlasxot, jaxot mox papijax, olivonaechan nuil. Jaxot pajelmʉaxwʉaj patʉpanliajwa. Chinax kaen patʉpan japawʉajtat os-esalfʉk. ");
INSERT INTO guoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Japawʉaj mox. Samata, jaxot patʉpan Jesús oti, chawʉajnachaemsmatkoi xot, napatamatkoi judíosliajwa xabich mox pawʉajna xotbej. ");
INSERT INTO guoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Napatamatkoi toep wʉt, kandiawasap, itkʉa'nik wʉtfʉk, María, Magdala paklowaxpijow, fʉlaech patʉpan Jesús och poxade. Mox fol wʉt, taenow ia't, pinjit, fafaxot matariamnaspox. Japot, ia't, majt faka'ch, patʉpan Jesús ochxot. ");
INSERT INTO guoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Samata, najaetow Simón Pedro poxade. Jawʉtbej xan, Jesús xabich nanejxasinkponan, Simón Pedroxotx. Xanalxot pat wʉt, nachapaei wʉt, najʉm-aechow: —Wajpaklon juch, wʉajxot ochpon. Xanal matabija-enil amxot pejme otipon —na-aechow, nachapaei wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Xanal japox jʉmtaenx wʉt, Pedro sʉapich, fʉlaechx patʉpan Jesús och poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Xanal dʉkpax. Xan kaes tabisla. Samata, xan matxoela patx patʉpan Jesús ochxot. ");
INSERT INTO guoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Do jawʉt, najʉlchax wʉajfafaxot taeliajwan wʉajtu. Jaxot wʉajtutat taenx mamochbʉ'ankal, pokchobʉ'an. Pe xan le-enilde wʉajtu. ");
INSERT INTO guoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pedro pat wʉt wʉchakal, japonlax low wʉajtu. Jaxot Pedrobej taen mamochbʉ'ankal. ");
INSERT INTO guoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jaxot taenbejpon asabʉ', Jesús matnaexakoeyasbʉ', papijaxtat okafʉlpox, xakoeyaspox. ");
INSERT INTO guoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Xan matxoelapatxponan, wʉchakal lowx. Xanbej taenx mamochbʉ'ankal, oel wʉt. Japox taenx wʉt, xan naexasitx Jesús diachwʉajnakolax mat-echpox pejme dukaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Japamatkoiyan xanal chiekal jʉmmatabija-enilfʉk Dios pejjamechan, chajia lelspox, jʉm-aech wʉt: “Mesías mat-esaxaes pejme dukaliajwa” —aech wʉtox. ");
INSERT INTO guoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Do jawʉx, xanal nawiax bachade, Pedro sʉapich. ");
INSERT INTO guoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Xanalwʉx María Magdala paklowaxpijow pat patʉpan Jesús ochwʉajxot. Wʉajfafaxot japow now. Now wʉt, natachaemsepow wʉajtuchade. ");
INSERT INTO guoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jawʉt taenow kolenje Dios pej-ángeles. Japi naxoeipox xabich papoei. Chalaki patʉpan Jesús majt ochxot. Kaen ek matnaetlel. Asan ek thitlel. ");
INSERT INTO guoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Japow wʉajnachaemtas wʉt Dios pej-ángeles, jʉmtispow: —¿Ma-aech xotkat nowam? —tispow. Japow jʉmnot wʉt, jʉm-aechow: —Tajpaklon, patʉpan, amxot och. Pe asew jiw juchpon. Matabijs-enil amxot pejme otipon —aechow Dios pej-ángelesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Japox jʉm-aech wʉt, natfo'cha wʉt, taenow kaen aton. Pe matabijs-elow japon Jesúspox. ");
INSERT INTO guoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Do jawʉt, japon wʉajnachaemt wʉt, jʉm-aechon japowliajwa: —¿Ma-aech xotkat xam nowam? ¿Achankat wʉlwekam? —aechon japowliajwa. Japow nejchaxoel: “Ampon olivonaechan tataeflan” —aechow, nejchaxoel wʉt. Samata, jʉm-aechow: —Patʉpan Jesús xam jutam wʉt, ¡najʉm-amde amxot otampon, xan japoxaliajwan patʉpan wʉlwekaliajwan! —aechow. ");
INSERT INTO guoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Do jawʉt, japon jʉm-aech: —¡María! —aechon. Japow natfo'cha japonlel. Do jawʉt, japow chiekal matabijt japon Jesúspon. Do jawʉt, brixtat nukjaba wʉt, jʉm-aechow hebreojametat: —¡Rabuni! —aechow pejjametat. (Japajame jʉmchiliajwa: “Jiw chanaekabʉanan” —chiliajwapox.) ");
INSERT INTO guoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús pejme jʉm-aech: —¡Nakikofde nathitakʉktampox! Xanfʉk taj-ax poxa-enilse. ¡Xabʉa'de tajnachala poxade! ¡Japi jʉm-amo ampox: ‘Xan waj-ax Dios poxaxoeyan’ —amo japi, chapaeyam wʉt! —aech Jesús Maríaliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Do jawʉx, María, Magdala paklowaxpijow, fʉlaen xanallel, Jesús pejnachalwan poxadin. Pat wʉtow xanalxot, najʉm-aechow: “¡Xan wajpaklon taenx! ¡Japon pejme duk!” —aechow. Nachapaeibejpow Jesús bʉxto'aspox. ");
INSERT INTO guoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Do madoi wʉt, japamatkoi, dominko wʉt, xanal, Jesús pejnachalwan, natamejlax batutat. Bafafachan chiekal xatbe'ax, tajlewla xot judíospaklochowliajwa. Jawʉt chalechkal Jesús natulaelt batutat. Nuk wʉt xanal tajwʉajnalel, jʉm-aechon: —Xan patx. ¡Puexa nej pachaema xamalxot! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Japox jʉm-aech wʉt, xanal na-itpaeipon pejke-e kematamatlaspoxan, chenaxʉa'laspoxbej. Jawʉt xanal xabich nejchachaemlax, pejme taenx wʉt wajpaklon Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús pejme xanal najʉm-aech: —¡Puexa nej pachaema xamalxot! Me-ama taj-ax nato'a ampathatasik, xamalbej to'axaelen asew jiw naewʉajnaliajwam —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Do jawʉt, xanallel fʉl wʉt, jʉm-aechon: —Espíritu Santo amwʉtjel xamalxot. ");
INSERT INTO guoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Xamal jiw beltaenam wʉt, babijaxan ispi, japi kofa xot babijaxan ispoxan, ja-am wʉt, Diosbej beltaeyaxael japi jiw. Xamal beltae-emil wʉt jiw babijaxan ispi, japi kofa-el xot, ja-am wʉt, Diosbej beltaeyaxil japi jiw —aech Jesús xanal pejnachalwanliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás xanalxotpijin, Jesús pejnachalan. Japontat puexa xanal dosan. Japon Tomás asawʉl Na-o'an. Jesús natulaelt wʉt xanalxot, jawʉt Tomás xanalxota-el. ");
INSERT INTO guoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Do baxael, Tomás xanalxot wʉt, xanal jʉm-an Tomásliajwa: —¡Xanal taenx wajpaklon Jesús! —an xanal Tomásliajwa. Pe japon Tomás xanal najʉmnot wʉt, jʉm-aechon: —Xan tajut tae-enil wʉt wajelan, kematamatlaspoxan, xan naexasisaxinil xamal. Naexasisaxinilbej, tajut tae-enil wʉt chenaxʉa'laspox. Xan xadonasian tajkothiyatat japon pejke-ewajelan. Jachasianbej tajke-etat japon chenaxʉa'laspox —aech jʉmch Tomás, asax paei wʉt. ");
INSERT INTO guoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Do jawʉx, ocho matkoiyan xent wʉt, xanal, Jesús pejnachalwan, pejme natamejlax batutat. Bafafachan chiekal xatbe'ax. Jawʉt Tomás xanalxot. Do jawʉt, chalechkal Jesús natulaelt xanalxot batutatan wʉt. Nuk wʉt xanal tajwʉajnalel, jʉm-aechon: —Xan patx. ¡Puexa nej pachaema xamalxot! —aech Jesús. ");
INSERT INTO guoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Do jawʉt, Jesús jʉm-aech Tomásliajwa: —Tomás, ¡taem tajke-e! ¡Xadonde nejkothiyatat! ¡Xabʉa'din jachaliajwam nachenaxʉa'lapox! ¡Nabej jʉm-aeche': ‘Xan naexasisaxinil, tajut tae-enil wʉt Jesús mat-echpox, pejme duk wʉtlison’ —nabej aeche'! ¡Nanaexasi'e xan namat-etxponanpox, pejme dukxponanpoxbej! —aech Jesús Tomásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Do jawʉt, Tomás nejthʉ'axtat jʉm-aechon: —¡Xam tajpaklonam, tajDiosnambej! —aech Tomás Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús jʉm-aech Tomásliajwa: —Xamlis chiekal xan nanaexasitam, najut chiekal nataenam xot. Asew jiw xan nanaexasisaxael natae-elaxtat. Japibej xabich nejchachaemlaxael —aech Jesús Tomásliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Xanal, Jesús pejnachalwan, taenx, Jesús xabich kaes koechaxan is wʉt. Ampapelfʉtat puexa japoxan lela-enil. ");
INSERT INTO guoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Xan lelx koechaxanliajwa xamal chiekal matabijaliajwam, naexasisliajwambej Jesucristo, Dios to'aspon, japon Dios paxʉlan. Xamal japon naexasisfʉlam wʉt, pomatkoicha duilaxaelam Diosxotse. ");
INSERT INTO guoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Do jawʉx, Jesús natulaelt wʉt Jerusalén paklowaxxot, pejme natulaelton, xanal Galilea pukaxotan wʉt. Japapuka asawʉl, Tiberias puka. Amwʉt japoxliajwa jʉmchiyaxaelen, ma-aech, Jesús natulaelt wʉt xanal pejnachalwanxot. ");
INSERT INTO guoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jesús natulaelt wʉt sietepinxot, kaen xanalxot pawʉl Simón Pedro. Asan pawʉl Tomás. Japon asawʉl Na-o'an. Asan pawʉl Natanael. Japon Caná paklowaxpijin Galilea tʉajnʉxot. Asan pawʉl Santiago. Japon xan takoewan. Xan, tawʉlpon Juan, jawʉt japixotanbej. Xanal kolenan Zebedeo paxin. Kaes asew kolenjebej jaxot. Japibej Jesús pejnachala. ");
INSERT INTO guoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Natamejlax wʉt, Jesús natulaels-el wʉtfʉk xanalxot, Simón Pedro xanal najʉm-aech: —Xan nabaxisaxaelen —na-aechon. Xanal jʉm-an: —Bajal. Xanalbej fʉlaeyaxaelen —an xanal. Do jawʉt, falkam pajulx. Nabaxitx wʉt, japamadoitat, chinaxkatdo' kaen baxin xawaeslax chiekal pama-an. ");
INSERT INTO guoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nalian wʉt, Jesús natulaelt pukababʉ'tat. Pelax xanal, japon pejnachalwan, matabija-enil, achan japon. ");
INSERT INTO guoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús pinjametat xanal nawʉajnachaemt wʉt, jʉm-aechon: —¡Moi! ¿Massʉapichkat xamal baxi xawawaelam? —aechon. Xanal jʉmnotx wʉt, jʉm-an: —Ajil. Chinax kaen baxin xawaes-enil —an xanal. ");
INSERT INTO guoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús xanal najʉm-aech: —¡Chinchorro fo'amik falkam poklalel! Jaxot baxi xawawaelaxaelam —aech Jesús. Jawʉt xanal ow-an. Jasox isx. Do jawʉt, chinchorro jusliajwan wʉt osliajwan falkamtat, xajʉpa-enil, chinchorro xabich chadewnik xot, baxi wʉlʉk xotbej. ");
INSERT INTO guoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Xan, xabich Jesús nanejxasinkponan, jʉm-an Pedroliajwa: —¡Japon wajpaklon! —an xan. Simón Pedro xan jʉm-anpox jʉmtaen wʉt, jawʉt sumta-otox naxoelchapon, jolt xoton nabaxisliajwa. Do jawʉt, Pedro naxoelcha wʉt, diwk minadik. Joechlison Jesús poxade. ");
INSERT INTO guoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Xanal, Jesús pejnachalwan, namaxpin falkamtat, wʉchakal chapatx thaejtade, xabich xot baxi chinchorrotat. Pukapamakt pasliajwan xabich atʉaja-el. Me-ama cien metros. ");
INSERT INTO guoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Xanal chapatx wʉt, nanax falkamtat. Jawʉt taenxbej jit, baxin ok wʉt jitmatwʉajtat, chabochpon. Okbej pan. ");
INSERT INTO guoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Do jawʉt, Jesús xanal najʉm-aech: —¡Xalaemen kaesʉapich baxi, xawawaelampi, chabowaliajwam! —aechon. ");
INSERT INTO guoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Do jawʉt, Simón Pedro falkam juldik baxi chadado'naliajwa chinchorrotat, thaejtat jusliajwapon. Japachinchorro xabich baxi, pinanʉl, wʉlʉk. Japi baxi ciento cincuenta y tres. Baxi pin-iat wʉt, chinchorro nakiowa liks-esal. ");
INSERT INTO guoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Do jawʉt, Jesús jʉm-aech xanalliajwa: —¡Xabʉa't, kandiawasappijax xaeliajwam! —aech Jesús xanalliajwa. Chinax kaen xanalxot pawʉajnachaems-enil, achankat japon, xanal tajut chiekal matabijax xot japon wajpaklonpox. ");
INSERT INTO guoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Do jawʉt, Jesús mox soepan xanallel. Jawʉt fiton pan xanal nachaxduiliajwa. Ja-aechbejpon baxin chabochponliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesús natulaelt wʉt xanalxot, japoxtat tres veces natulaelton xanal pejnachalwanxot, pejpatʉpaxwʉx, pejmat-esaxwʉxbej. ");
INSERT INTO guoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Xanal kaechatoelx wʉt, Jesús wʉajnachaemt wʉt Simón Pedro, jʉm-aechon Simón Pedroliajwa: —Simón, Jonás paxʉlan, ¿xamkat xan kaes nanejxasinkam? Me-ama tajnachala asew nejxasinkam wʉt ¿jachi-emilkat xam xanliajwa? —aech Jesús. Pedro jʉmnot wʉt, jʉm-aechon: —Diasdo', tajpaklon. Xam chiekal matabijtam xam nejxasinkaxpox —aechon. Jesús pejme jʉm-aech Pedroliajwa: —Jelxan nanaexasiti, ¡japi chiekal xam nawetataefʉlde! Me-ama ovejas tataeflan chiekal tataefʉl pejew corderos, ¡xambej ja-amde jelxan nanaexasitiliajwa! —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Do pejme Jesús wʉajnachaemt wʉt, jʉm-aechon Pedroliajwa: —Simón, Jonás paxʉlan, ¿xamkat xan kaes pejme nanejxasinkam? —aech Jesús Pedroliajwa. Pedro pejme jʉmnot wʉt, jʉm-aechon: —Diasdo', tajpaklon. Xam chiekal matabijtam xam nejxasinkaxpox —aech Pedro Jesúsliajwa. Jesús pejme jʉm-aech Pedroliajwa: —¡Chiekal nawetataefʉlde jelxan nanaexasiti! Me-ama ovejas tataeflan chiekal tataeflafʉl pejew ovejas, ¡xambej ja-amde jelxan nanaexasitiliajwa! —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Do pejme kaes Jesús wʉajnachaemt wʉt, jʉm-aechon Pedroliajwa: —Simón, Jonás paxʉlan, ¿xamkat xan nanejxasinkam? —aech Jesús. Do jawʉt, Jesús kaes wʉajnachaemt xot, jʉm-aech xoton: “¿Xamkat nanejxasinkam?” —aech xot Jesús Pedroliajwa, Pedro jʉmnot wʉt, jʉm-aechon: —Tajpaklon, xam puexa chiekal matabijtam. Matabijtambej xam nejxasinkaxpox —aech Pedro Jesúsliajwa. Do jawʉt, Jesús jʉm-aech Pedroliajwa: —¡Chiekal nawetataefʉlde jelxan nanaexasiti! Me-ama ovejas tataeflan chiekal tataeflafʉl pejew ovejas, ¡xambej ja-amde jelxan nanaexasitiliajwa! ");
INSERT INTO guoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Diachwʉajnakolax jʉm-an. Xam pansianam wʉt, najut naxoelam. Ma fʉlaesiam poxade fʉlaemch. Pe pati'nam wʉt, asamatkoi mʉaxxachosaxaelam asew jiw xam xajoelaliajwa. Do jawʉt, xam bʉflaeyaxaeli nejxasinka-emil poxade —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Japox Jesús chajia jʉm-aech matabijsliajwa, achaxtat Pedro tʉpaxael, Cristo naexasit xoton. Do jawʉt, Jesús pejme jʉm-aech Pedroliajwa: —¡Xan nakfʉlaem! —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Do jawʉt, Jesús, Pedro sʉapich, laelp wʉt, Pedro kaxadik wʉltataek wʉt, xan nataenpon, wʉchakal laejax wʉt. Jesús kaes xan nanejxasinkponan. Jesús xanal nabʉ'xael wʉt Pascuafiestanaxaeyax, jawʉt xan mox ekx Jesúsxot. Xan japon wʉajnachaemtax wʉt, jʉm-an: “Tajpaklon, ¿achankat xam wiasaxael nadaelmajiwxot?” —an xan japamadoitat. ");
INSERT INTO guoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Do jawʉt, Pedro xan nataen wʉt, jawʉt wʉajnachaemton Jesús. Jʉm-aechon xanliajwa: —Tajpaklon, ¿machiyaxaeskatlax Juan asamatkoi? —aech Pedro Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús jʉmnot wʉt, jʉm-aechon: —Xan nejxasinkax wʉt japon ampathatat laejaliajwa, hasta xan paskax wʉt pejme, ¡xam nabej nejchaxoele' japoxliajwa! ¡Xamlax pomatkoicha xan nanaexasisfʉlde! —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Samata, asew jiw, Jesús naexasiti, nakaewa najʉm-aech xanliajwa: “Juan tʉpaxil” —na-aechfʉl jiw nakaewa. Pe Jesús japox jʉm-aech wʉt, jʉmchi-elon xan tʉpaxinilpoxliajwa. Jesúslax jʉm-aech xanliajwa: “Xan nejxasinkax wʉt japon ampathatat laejaliajwa, hasta xan paskax wʉt pejme, ¡xam nabej nejchaxoele' japoxliajwa!” —aech Jesús Pedroliajwa. ");
INSERT INTO guoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Xan, Juan, tajut taenxpoxan, tajut jʉmtaenaxbej, japoxan ampapelfʉtat lelx. Xan chiekal matabijtax puexa japoxan diachwʉajnakolax. ");
INSERT INTO guoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús ampathatat wʉt, xabich asaxan pachaempoxan ispon. Puexa japoxan kaenanʉla lelax toetx wʉt, xabichaxael japapel-ʉafan. Samata, japapel-ʉafan bej xajʉpaxilbej ampathatat.");
INSERT INTO guoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Xan Lucas, lelx ampapelfʉt xamliajwa, Teófilo, xabich sitaenxponam. Asafʉt chajia xato'ax xamliajwa, matxoelalelxfʉt. Japafʉtat lelx Jesús ispoxan, naewʉajnafʉlpoxanbej, tʉadut wʉton isfʉlpoxan. Hasta Jesús bʉ'fos wʉt athʉ poxase, do jawʉt, kekoftax lelxpoxan japon isfʉlpoxanliajwa, naewʉajnafʉlpoxanliajwabej. Chajia xato'ax japafʉt xamliajwa. Jesús Dios bʉflae-esal wʉtfʉk athʉ poxase, Jesús pej-apóstoles, japi makanotpipon, japi to'as Espíritu Santo pijaxtat naewʉajnafʉlaliajwa Cristo pejwʉajan potʉajnʉcha. ");
INSERT INTO guoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús tʉp wʉt, mat-ech wʉt pejme dukaliajwa, jawʉt kamtalejen natulaelafʉl apóstolesxot. Samata, japi apóstoles chiekal matabija diachwʉajnakolax Jesús mat-echpox pejme dukaliajwa. Jesús cuarenta matkoiyan natulaelafʉl apóstolesxot. Jesús naewʉajnafʉl Dios puexa pejjiw tato'laxaelpoxliajwa. ");
INSERT INTO guoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bʉflae-esal wʉtfʉkon athʉ poxase, Jerusalén paklowaxxot wʉtfʉkon, apóstoles sʉapich, jawʉt jʉm-aechon: “Xan xamalxota-enil wʉt, ¡nabej pankole'fʉk ampapaklowaxxot! ¡Wʉajnawe'e Espíritu Santo pasliajwa xamalxotsik! Taj-ax Dios japox chajia jʉmdut xamalliajwa. Xanbej chajia japox jʉm-an xamalliajwa. ");
INSERT INTO guoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Diachwʉajnakolax Juan jiw bautisa mintat. Kaematkoiyan sʉapich wʉt, Espíritu Santo pasaxael xamalxotsik. Ja-aech wʉt, Dios xamal bautisaxael Espíritu Santotat” —aech Jesús apóstolesliajwa. ");
INSERT INTO guoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apóstoles natameja wʉt, Jesús sʉapich, jawʉt japi wʉajnachaemt wʉt, jʉm-aechi Jesúsliajwa: —Paklon, ¿xamkat amwʉt tato'laxaelam xanalkal, judíos? Me-ama wajwʉajnapijin, rey David, Israel tʉajnʉpijiwkal tato'al, ¿xamkatlap-is jachiyaxaelam ma amwʉt? —aech apóstoles Jesúsliajwa. ");
INSERT INTO guoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús jʉmnot wʉt, jʉm-aechon: —Kaen, taj-ax Dios, matabijt maswʉt japox jachiyaxael. Dios tapae-el xamal matabijaliajwam. Kaen, taj-ax Dios, jʉmchiyaxael, maswʉt japox jachiyaxael. ");
INSERT INTO guoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pe Espíritu Santo pask wʉt xamalxotsik, ja-aech wʉt, Espíritu Santo pejpamamaxtat xamal naewʉajnafʉlaxaelam tajwʉajan potʉajnʉchanpijiw. Naewʉajnafʉlaxaelam Jerusalén paklowaxpijiw, Judea tʉajnʉpijiwbej, Samaria tʉajnʉpijiwbej. Atʉaj asatʉajnʉchanpijiwbej naewʉajnaf