﻿USE sofia;
DROP TABLE IF EXISTS sofia.gum_vpl;
CREATE TABLE gum_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gum_vpl WRITE;
INSERT INTO gum_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ke srøtø chigucha chigaaben, Tiusbe srømbalameranba, pirøwanba marig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pirøbe mumay kuinguen asamgaig chiguchagaig pasrøben, pimerabe purø trømbø løstiig pinøgasraig pasrabig køn. Inchen Tiuswei Espíritube pi palawan llirabig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tiusbe trenchibig køn: “Tør kønrrain” cha. Inchen tørbe misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Incha Tiusbe tørwane tab kui asha, tørwane løstøyugurri nuingui mendamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tiusbe tørwane “kwaløm” cha wamappe, løstiigwane “yem” cha wamabig køn. Inchen maabenba løtsøba købig køn, tru srøsrø kwaløm. ");
INSERT INTO gum_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Katø Tiusbe trenchibig køn: “Larrø lendiig chiguchagaig kønrrain cha, tru pimeran nuingui, nuingui tarømartrabig tøbøtag pasrønrrai.” ");
INSERT INTO gum_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Incha Tiusbe tru larrø lendiig chiguchagaigwan marøbig køn, tru pimeran tarømarøbigwan. Tru pimera pala købelanba, umbu købelanba nuingui tarømarig kørrømisrtrai. ");
INSERT INTO gum_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Incha Tiusbe tru larrø lendiig chiguchagaigwane “srømbala” cha wamabig køn. Inchen maabenba, løtsøba køben, pa kwaløm købig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Katø Tiusbe trenchibig køn: “Srømbalamerai umbu pimera købeløbe kanbalatø misrtrain cha, pur kenamisrtrai.” Inchen treeg kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Incha purwane Tiusbe “pirø” cha wamappe, pimera kanbalatø misrigwane “marmera” cha wamig køn. Incha Tiusbe tabig kui asig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Incha Tiusbe trenchibig køn: “Pirøbe misringarubash cha, pilli puzheelø chi kaumera køppe, treeg yellzheelø tøgar, mamig nigab tusrmera, chi tusr køppe, treeg yell truyu tøgar pirau treeg kønrrai. Inchen treeg kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Inchen pirøbe pilli puzheelø chi kaumera køppe, treeg yellzhig nigar, mamig nigab tusrmera yellzheelø truyu nigar misrøbig køn, nø chi tusr køppe, treekke. Inchen Tiusbe tabig kui asig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Inchen maaben misra, løtsøgualmaben, pøn kwaløm købig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Tiusbe katø trenchibig køn: “Tru srømbala larrø lendiig chiguchagaigube pilabelø kønrrain cha, kwalømwanba, yemwanba tarømartrabelø, iiløbe chi utømera køben amrrubelan ashib kømig kønrrai, kwalømmerawan, pilamerawan.” ");
INSERT INTO gum_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Incha truiløbe srømbalasrø larrø lendiig chiguchagaigu pilabelø kønrrain cha, pirøwan pilønrrabelø.” Inchen treeg kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tiusbe pagatø pilabelø nørreelan marig køn: tru pilabig larrø tøriibe kwaløm piløben, pilabig tre tør kømíibe yem piløben inchai, katø nøbe kønchabiimeragucha marig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Tiusbe tru srømbalamera larrø lendiig chiguchagaigu iilan pønsrøppe, pirøwan pilønrrai pønsraig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Kwalømwan lata, yemwan lata pilamburab pilabeløbe nøm pønrrønrrai marig køn, tørwanba, løstiigwanba tarømartrabelø. Incha Tiusbe tabig kui asig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Inchen maaben misra, løtsøgualmaben pib kwaløm købig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Incha Tiusbe trenchibig køn: “Pimerabe chigurrimbunø øsiguelø tøgagøbash cha, katø illimera tru pirøbalawan llirabeløgucha kønrrain cha, tru larrø lendiig chiguchagaigu srømbalamerawan amøñibelø.” ");
INSERT INTO gum_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Incha Tiusbe piyu ushamera kwaaramdø nørreelø marig køn. Chigurrimbunø øsiguelø kønab purrønrrabelanba, chitøgucha nøm chimera køppe, treelø kønrrai pimerabe treeg misringaruig køn, katø chigurrimbunø kwaldzariimera tøgargucha nøm chi køppe, treeløtøwein kønrrai. Incha Tiusbe tabig kui asig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Incha Tiusbe truilane mayanguen tabig kønrrai marabe, trenchibig køn: “Larrø nørrø tøgagøb, larrø nørrø larrøbitchigay cha, marmerayu netsab, katø illimeragucha larrø nørrø larrøbitchigay” cha. ");
INSERT INTO gum_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Inchen maaben misra, løtsøgualmaben, truibe trattrø kwaløm købig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Incha Tiusbe trenchibig køn: “Pirøbe øsiguelø misringarubash cha, kusreeg ushamera køben, namig ushamera køben, srala ambubelø køben, nøm chimera køppe, treelø kønraingue.” Inchen treeg kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Tiusbe namig ushamera nøm chimera køppe, treelø kønrrai marøb, katø kusreeg ushamera nøm chimera køppe, treelø kønrrai marøb, maya ushamera pirau sralig ambubelø nøm chimera køppe, treelø kønrrai marøbig køn. Incha Tiusbe tabig kui asig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Incha Tiusbe trenchibig køn: “Møg misag margun cha, nam mailø køben ke tre lataitøwein køb, katø nam lataitøwei isub, marøbelø kønrrai. Incha maryu piyaumeran, srømbala amøñib illimeran, kusreeg ushameran, namig ushameran, pirau sralig ambub ushameran, truilø nun chinchaingaig, nø ashib tøga pasrønrrain” cha. ");
INSERT INTO gum_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Incha Tiusbe møwan marøppe nø maig køben ke tre lataitøwein kønrrai marig køn. Pøs nøbe tre lataitøwein kønrrai marig køn. Møg misag, ishug misag treeg marig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Incha Tiusbe mayanguen tabig nebuilø kønrrigay chib, trenchibig køn: “Srøig larrøbitchabig yellmera tøgagøb, srøitø srøitø larrø nørrø nemisrtrigay cha. Ñimbe pirøwan netsøgana, pirøwane ñim ashib tøga pønrramisra, chinchaingaig ñim ashib karunrrigay cha, maryu piyaumeran, pala amøñib illimeran, katø maya ushamera pirau srala ambubelan købengue.” ");
INSERT INTO gum_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Incha Tiusbe trenchibig køn: “Asay cha, nabe ñimune pirau mamig nigab kauzheelø yellmera tøgartø kønrrai tranar cha. Katø maya tusrmera mamig nigabelø, yell tøgarmera tranar cha, iibe kerriguba ñim mab kømig kønrrai.” ");
INSERT INTO gum_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Inchen pirau namig ushameranba, pala amøñib illimeranba, katø maya ushamera pirau srala ambubelanba, truilane pilli puzhigwan mab kømig tranar cha. Inchen treeg kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Incha kerrigu Tius nø mariilan ashabe, truba truba tabig kui ashibig køn. Inchen maaben misra, løtsøgualmaben, trattrø y kan kwaløm købig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Inchen srømbalameranba, pirøwanba truyu kerriguh chi købelanba chab marig kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Incha Tiusbe kerrigu nui maramigwan yandø patsøga, trattrø y pa kwalømyube isrig køn nø kerrigu chi marigwan. ");
INSERT INTO gum_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Incha Tiusbe tru trattrø y pa kwaløm kønrrabyuigwane mayanguen tabig kønrrai mara, nuyasig kønrrai tarømara pasrøbig køn, kaguende nø chigurrimbunø mara pønsra tru kwalømbe nø isrig kua. ");
INSERT INTO gum_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Srømbalawan køben, pirøwan køben mara pønsrailan øyeeg købig køn cha wamindig iig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","piraube ka nøtø kal-lab tusrmera chigucha kawei, chigucha kaumera kal-laig kawein købig køn, kaguende Jehová Tiusbe piraumay srewan pungarumø srø køben. Inchagucha kwallchabig mu møg mugawein køben. ");
INSERT INTO gum_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pibe piraugurri webarrub, pirø palawan kerrigu sømarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Inchen Jehová Tiusbe pirøyu usrøtøga møg misag mara, trugurrimbe øsiguig kønrrai kimyu urrøben, møøbe øsiguig misrig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Incha Jehová Tiusbe Eden taisrø kan ellmarin tul mara pasrøbig køn, tru pørr neeshibgatømaysrø. Incha tru nø mari møwan truyu kørrømarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Incha Jehová Tiusbe chi tusrkurrimbunø chull asamdø tab tusrmera pirau kal-langarubig køn, chull mamdø mamiimera nigabelø. Inchen tru tul tøbøtabe tru kwamø øsig køm tusrwanba, katø tru tabigwanba, kaigwanba nebua asam tusrwanba kal-langarubig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Inchen tru Edenyugurrimbe pi webarrubig køn tru tulwan sømarøb lulrrabig. Incha truyugurrimbe katø pippaløh pirisha webibig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Tru srøsrø pibe Pisón munchi købig køn, truibe tru Havila pirø muba kuimburab pøtøgatanwan pureb ibig køben, trusrømbe oro tøgaikke. ");
INSERT INTO gum_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Incha pirø muba kuimburab tru pirau orobe larrø tabig købig køn, katø truyube mayzhig irrabig bedelio køben, ónice køben tøgaikke.) ");
INSERT INTO gum_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Inchen tru wendau pibe Kihón taig, truibe tru Cus pirø muba kuimburab pureb ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Inchen tru pøn kønrrabyu pibe Tigris taig køn, Asiria pirau pørr neeshibgatøwansrø pureb ibig. Inchen tru pib kønrrabyu pibe Eufrates køn. ");
INSERT INTO gum_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Incha Jehová Tiusbe møwan pera arrua, tru Edén ellmarin tulyu kørrømarøbig køn, pirøwan kwallib ashib tsunrrai. ");
INSERT INTO gum_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Incha Jehová Tiusbe tru møwane trencha karua pasrøbig køn: —Tru tulyu chi tusryu mamiimerandøgucha ka manrrig cha. ");
INSERT INTO gum_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Inchendø tru tabigwanba, kaigwanba nebua asamburab asam tusryu mamigwane manrrab kømø cha, kaguende tru tusryuigwan ñi mab kwalømbe isa kømø, ñibe kwanrrabguen— cha. ");
INSERT INTO gum_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Incha trugurrimbe Jehová Tiusbe trenchibig køn: —Møg nøtø unamiibe chi tab kømøn cha, nun purugunrrabig nø maig palain køben, treegwan martrab— cha. ");
INSERT INTO gum_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Incha Jehová Tiusbe maya ushameranba, illimeranba pirøwandøwei mara pønsra, møwei merrab pønsrøbig køn, chi munchi pønsramigwan nø asha pønsrønrrai. Inchen møg tru øsiguelan treeg munchi pønsra wamiiløbe tru munchin tøgar kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Inchen møøbe maya ushamera namiguelan, pala amøñibelø maya illimeran, katø tru kusreeg ushameran mayamba munchi pønsrøbig køn. Inchen køben møwan nø maig palain køben, treegwan purugunrrabiibe mugaabig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Inchen Jehová Tiusbe møwan purø mur kingarua, nø kib tsumnebe kan tømbul tsutsigwan wesrawa, tru tsutsig wesrub kurigwane katøle treetøweih kasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Inchen Jehová Tiusbe tru tømbul tsutsig wesraigwane ishug misag mara, møweimay pera arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Inchen møøbe trenchibig køn: —Iibe sí, nain tsutsigugurrin tsutsig køb, katø nai asryugurri asr køb indan cha. “Ishug misag” cha wamig kønrrun chibig køn, kaguende nøbe møweinukkurri wesraig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Treekkurri møøbe møskawan, usran tarømisra, sraimba kandø misra, kan asrtø kønrrun. ");
INSERT INTO gum_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Møøba, ishuubabe pailøba køsaateelø købig køn. Inchendø chi kørig kui inchimeeløgue. ");
INSERT INTO gum_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Inchen tru ulbe maya ushamera lataguen kømø, chigøben maramigwane purø may isua marøbig købig køn, Jehová Tius nø mariiløyu. Incha tru ulbe ishuwane trenchibig køn: —¿Kabe Tiusbe ñimungan tru ellmarin tulyuigwan ni mø tusryuigwanguen kerriguwan mamønrrain taig kuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Inchen ishuube ulwane trenchibig køn: —“Tulyu pønrrab tusryu mamiimerane ka manrrigay” taig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Inchendø tru ellmarin tul tøbøtag pasrab tusryu mamigwane Tiusbe øyeeg taig køn cha: “Mamønrrigay cha, ni katøramøwei inchigay taig køn cha, kwamig kømønrrai”.— ");
INSERT INTO gum_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Inchene ulbe ishuwane trenchibig køn: —Ñimbe kwamønrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tiusbe asha køn cha, ñim tru tusryuigwan mab kwalømbe, ¡katø! chinetø nebua asamigwan ñimui isubig kuren, ñimbe Tius lataitøwein kønrrabguen cha, kaigwanba, tabigwanba nebua ashibelø.— ");
INSERT INTO gum_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Inchen ishuube tru tusryuigwan larrø chull mamdiig kui ashib, trurrigu tru tusryu mamiibe larrø mayzhig kønraptiig kui ashib, katø chiwandøgucha larrø kusrebig kuinrrabna isumig purø chull kønrraptø tusr kui ashib inchibig køn. Incha tru tusryu mamigwan nemørøb, maptinchibig køn. Inchabe kewangucha srørren, truikkucha mabig køn. ");
INSERT INTO gum_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Inchen møimbe tru pailanba, ¡katø! chinetø nebua asamigwan nømui isubiibe kurøptinchen, nømbe køsaateelø købrain kui wetøgørra, nømbe higuera ishiimeran tsusha, søtøgasrailø marøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Inchen yandø mawab misrøb pishi isig ichibig webarruben, tru ellmarin tulyu Jehová Tiusbe llirab arri møra, møøbe nui sraimba tusr utumerawansrø trubabelø køn Tius nø pasrainukkurri. ");
INSERT INTO gum_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Treendingucha Jehová Tiusbe møwan wamabe, payibig køn: —¿Ñibe chu pasrøgu?— cha ");
INSERT INTO gum_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Inchene møøbe trenchibig køn: —Tru ellmarin tulyu ñi llirab arri nabe mørøptindinaben, nane truba kørig køtan cha, kaguende nabe køsaatiig købrain købtinchen, treekkurri nabe trubar— cha. ");
INSERT INTO gum_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Inchene Tiusbe trencha payibig køn: —¿Ñune køsaatiig køn chabe, mu eshkata? cha. ¿Na mamønrrain taig tusryu mamigwan ñibe mappeendi?— cha. ");
INSERT INTO gum_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Inchen møøbe trenchibig køn: —Tru ñi nan lincha pera uñchai trani ishug tru tusryu mamigwan nan srørren, nabe mar— cha. ");
INSERT INTO gum_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Inchene Jehová Tiusbe ishuwane trenchibig køn: —¿Øyeebe chi margu?— cha —Tru ul nan purø may wamincha isøben, nabe mar cha— trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Inchen Jehová Tiusbe tru ulwane trenchibig køn: —Ñi øyeeg marikkurrindø maya ushamerai utu ñibe larrø trømbøig nebuig kønrrig cha, kusreeg ushamerai utu lata, namig ushamerai utu lata. Patsøtøgatø sraløb uña, ñi chugatig øsig tsuingatiibe pirøyu usrøwan manrrig cha. ");
INSERT INTO gum_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Incha ishuuba ñibabe larrø ashig kømuindiyabelø kønrrai maramønrrun cha, ñuinukkurri amrrubeløba, katø ishuweinukkurri amrrubeløba. Incha tru ishug misagweinukkurri srøig srøig kurrab arrubiguig ñune turwan pusøbunøben, ñibe nune talunyu tsatchun— cha. ");
INSERT INTO gum_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Incha ishuwane trenchibig køn: —Ñune unø tøgamisrøbyu pusrkwabigwan masken trømbøig pusrkwanrrai nemaramønrrun cha. Purø trømbøig pusrkwai incha, ñui ureemeran tøgamisrtrabguen cha. Inchen ñi ureg tøgagukkøb chull isuibe ñui kewein køben, ñui keebe ñune nø karub nø ashchabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Incha møwane trenchibig køn: —Ñi ñui srawei wamwan manchitanmaptø mørøb pasrøwa, na mamønrrig tain tusryu mamigwan ñibe main køn cha. Ñigurrindø pirøbe larrø trømbøig nebuig pasrønrrun cha. Ñi chugatig øsig tsumnegatiibe ñibe ¡katø! isua møra marøb megawabe, truyugurri manrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Inchen pirøbe tsøshambah, kaldusrmerabatø misren, mappe, kau umbu tusrmerandø manrrigay cha. ");
INSERT INTO gum_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ñibe pøsra, pøsra mara mamig tøgagønrrig cha, ñi katøle pirøtøwei misramnegatikke, kaguendø ñibe pirøtøga mara pasrig køn cha. Ñibe pirø usrø kuig køppe, katø ñibe usrøtøwei misrtrabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Inchen Adánbe nui srawane Eva munchi pasrøbig køn, kaguende Evabe maya misagwei usrin kønrrabig kuimba. ");
INSERT INTO gum_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Jehová Tiusbe møweimba, nui sraweimba kemelø ushamerai kalusmeran mara, kennøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Incha Jehová Tiusbe trenchibig køn: “Møøbe møimbe kan møig køben nam lataitøwei misra pasramisrin køn cha, tabigwanba, kaigwanba nebua ashibig. Pøs, nui tasigwan larrøbitchain kømøn, chibig køn, tru øsig køm tusryu mamigwangucha nemøra, truigwan ma, managatig øsig kønrrab.” ");
INSERT INTO gum_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Incha Jehovábe tru Edén tulyugurri nømun webusrøbig køn. Incha pirøwan kwallchain pasrig køn, tru nun mara pasrin pirøwan. ");
INSERT INTO gum_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Incha møwan wambig wegucha, Edén tru tulyu pørr kal labgatømay querubinmera pønsra, katø kan espada naarabig amburab, iburab llirabig pasrøbig køn, managatig tru øsig køm tusryumay ambam maywan pumønrrai martrab. ");
INSERT INTO gum_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adanbe nui srai Evaba unø tøgagønrrab pailø waramisrøbelø køn. Incha Evabe kwanrriig kørrømisra, Cain kal labene, trenchibig køn: “Na unø tøgagømig Jehová treeg kønrrain køben, kan møg-unø tøgaguinatan” cha. ");
INSERT INTO gum_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Incha katø wendøbe Cainwei nuneg Abelwan tøgamisrig køn. Abelbe ubisha ashibig køben, Cainbe pirøwan kwallibig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Inchen kan maya yana køsrøn puraiben, Cainbe Jehováwan ketamig nui kwaliiløyugurri srua arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Inchen Abelgucha nui ubishamera ke srøsrø lluilan srua arrubig køn, sebowanba. Inchen Jehovábe Abelwanba tru nui kettrab srua arrigwanba truba tab kui ashibig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Trune Cainwane tab kui ashmuig køn, tru nø keta tranigwan chigucha. Inchen Cainbe truba trømbøig namuben, nui maløbe ke minchiptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Treenchene, Cainwane Jehovábe trenchibig køn: —¿Chindimbarre namøgu? cha. ¿Chindimbarre ñui maløbe ke peg misrøptinnda? cha. ");
INSERT INTO gum_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ñi sølwan isua marig kuimbe, ñibe utsøbasrmø kurraasha pasrabsruinrrun cha. Inchendø ñi sølwan isua marmuikkurrimbeh, kaigwan matrai inchabiibe ñun megambunrrab ¡katø! muniitø pasran cha. Inchen køben ñibe tru kaig marmumigwane ñi kananrrabguen— cha. ");
INSERT INTO gum_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cainbe nui nuneg Abelwane trenchibig køn: —Chugøben lliranrrab amun— cha. Indig yandø tru llirab amønaisrømbe Cainbe nui nuneg Abelwan namappe, kweechibig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Inchene Jehovábe Cainwane trencha payibig køn: —¿Ñui nuneg Abelbe chu unah?— cha. Inchen nøbe trencha løtabig køn: —Chindindøbeh cha. ¿Nagan nai nunewan ke tru ashib wendautø pasrabig kuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Inchene Jehovábe trenchibig køn: —¿Chi margu? cha. Ñui nunewei animbe piraugurri trashib nan wamøtan cha. ");
INSERT INTO gum_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ñibe larrø trømbøig nebuinanrrabig kørrømisrøb, tru ñui nuneg Abelwan ñi kweechen ani lusigwan muchib piraugurri ñune webya inrrai wegutsig kørrømisrøb inchabguen cha. ");
INSERT INTO gum_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pirøwan kwallib megaingucha, yandø mamig misrmønrrabig køn cha. Inchen ñibe piraube punø panrrø, punø panrrø ka lliraitø, lliraitø chuguen tsub tsumibe chigaig kønrrabguen— cha. ");
INSERT INTO gum_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Inchene Cainbe Jehováwan trenchibig køn: —Nan øyeeg møra pasrønrrai mariibe purø nuig køtan cha, pasramguengaikke. ");
INSERT INTO gum_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Møi na tsuinukkurri yandø nan weguchen; ñui merrabgurrimbe møimbe trubatø unamønrrun cha, pirø muba kuimburab lliraitø, lliraitø chuguen tsub tsumig chigaikke. Inchen mugøben nan ashibiibe nane kwetchautan— cha. ");
INSERT INTO gum_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Inchene Jehovábe trenchibig køn: —Møikkøben Cainwan kweechibiibe siete pijisken purab trømbøig nebuin pasrønrrun— cha. Incha Jehovábe Cainwane kan siñal asamdiig tøgaig kønrrai marøbig køn, mugøben ashagucha, nune kweechimønrrai. ");
INSERT INTO gum_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Incha Cainbe Jehováwei merrabgurri yandø tarømisra ya, Nod tain pirau Edén pørr kalabgatømaysrø tsubig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cainbe nui sraimba unø tøgagønrrab pailøba waramisrøbelø køn. Inchen sraimbe kwanrriig kørrømisra, unø tøgamisrig køn, tru Enocwan. Incha Cainbe kan ciuda mara pasrabe, truigwane tru nui nusrkai Enocwei munchin pasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Incha Enocbe kan nusrkai Irad taig tøgaguig køn. Inchen tru Iradbe Mehujaelwei møskain køben, Mehujaelbe Metusaelwei møskain køben, Metusaelbe Lamecwei møskain kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Incha Lamecbe nuyasig pagatø ishumburmera tøgaguig køn. Kan ishuwei munchibe Ada købene, katøgan ishuwei munchibe Zila købig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adabe kan unø tøgamisrig køn, tru Jabalwan. Tru merrabsrø kølli misag Jabalweinukkurri pølbasra amrrub mendig kuig køn, carpa lasrua pønsraiIøyu warab, katø nømbe ushamera karrøgøb inchibelø. ");
INSERT INTO gum_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabalbe kan nuneg Jubal taig tøgaig køben, tru merrabsrø kølli misag Jubalweinukkurri pølbasra amrrub mendig kuig køn, mayeelø arpa kønabeløba, lus urrabeløba. ");
INSERT INTO gum_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Inchen Zilagucha Tubal-Cainwan tøgaguig køn. Truibe chigurrimbunø bronce tsandzøntøgaba, hierro tsandzøntøgaba larrø tabelø marøbig kuig køn. Katø Tubal-Cainwei nuchaabe Naama købig køn. ");
INSERT INTO gum_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kan piji Lamecbe nui sralan trenchibig køn: —Adaba, Zilaba, nai wamwan mørtray cha. Lamecwei sralø, nai wamwan tab mørtray cha. Nan kørriinchen, nabe kan møwan kweechib, nan mur kebachen, nabe kan matsinan kweechar cha. ");
INSERT INTO gum_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Cainwanma siete pijisken purab trømbøig nebunrrai pasrig kuibe, Lamecbe sietebatø setenta pijisken treetø treetø purab trømbøig nebuin pasrønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adánbe nui sraimba unø tøgagønrrab pailøba waramisrøbelø køn. Incha Evabe kan nusrkai tøgagua, trunune Set munchi pasrig køn. “Tiusbe nane katøgan nusrkai trandan cha, Cain Abelwan kweetsig købene truburø tøgagønrrai.” ");
INSERT INTO gum_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Incha Setgucha kan nusrkai tøgagua, truigwane Enós munchi pasrig køn. Indig truyugurrimbunø yandø møgueløbe Jehováwei munchiwan wamab miabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iig køn tru Adánweinukkurri amrrub misaameran munchin merrarrailø, Tius møwan nø mara pasrøb kwalømbe, møwane Tius lataitøwein kønrrai marig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Incha møøba ishuuba kønrrai Tiusbe treeg mara pønsra, katø mayanguen tabig nebuilø kønrrai mara, tru nø mara pønsrøb kwaløm “Adan” cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adanbe pilamera ciento treinta tøgagua kan nusrkai tøgaguig køn chiyutøgucha nø lataitøwei, treeg unø. Incha truigwane Set munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adanbe Setwan tøgaguinukkurrimbunø pilamera ochocientos tøgaig kua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Inchawei Adanbe pilamera novecientos treinta tøgagua, yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Setbe pilamera ciento cinco tøgagua, nusrkai Enóswan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Setbe Enóswan tøgaguinukkurrimbunø pilamera ochocientos siete tøgaig kua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Inchawei Set kerrigu øsig tsuin kwalømmerabe pilamera novecientos doce kuig køn. Inchen yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enósbe pilamera noventa tøgaig kua, kan nusrkai tøgaguig køn, Cainán taig. ");
INSERT INTO gum_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enósbe Cainánwan tøgaguikkurrimbunø pilamera ochocientos quince tøgaig kua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Inchawei kerrigu Enós øsig tsuin kwalømmerabe pilamera novecientos cinco køben, yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainánbe pilamera setenta tøgaig kua, nusrkai Mahalaleelwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Cainánbe Mahalaleelwan tøgaguikkurrimbunø pilamera ochocientos cuarenta tøgaig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Inchawei Cainán kerrigu øsig tsuin kwalømmerabe pilamera novecientos diez køben, yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleelbe pilamera setenta y cinco tøgaig kua, nusrkai Jaredwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Incha Mahalaleelbe Jaredwan tøgaguikkurrimbunø pilamera ochocientos treinta tøgaig kua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Inchawei Mahalaleelbe kerrigu øsig tsuin kwalømmerabe pilamera ochocientos noventa y cinco køben, yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaredbe pilamera ciento sesenta y dos tøgaig kua, nusrkai Enócwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared Enocwan tøgaguinukkurrimbunø pilamera ochocientos tøgaig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Inchawei Jared kerrigu øsig tsuin kwalømmerabe pilamera novecientos sesenta y dos køben, yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enocbe pilamera sesenta y cinco tøgaig kua, nusrkai Matusalénwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusalénwan tøgaguinukkurrimbunø Enocbe Tiusba maig unamig køben, treeg uñibig kuig køn, pilamera trescientos tøgaig. Incha nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Inchawei Enoc kerrigu øsig tsuin kwalømmerabe pilamera trescientos sesenta y cinco tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enocbe Tiusba maig unamigwan unig køn. Incha chindinguen asiimíig pinaptindig kuig køn, kaguende Tius nune øsiibatø pera iben. ");
INSERT INTO gum_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalénbe pilamera ciento ochenta y siete øsig tsua, nusrkai Lamecwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Incha Matusalénbe nusrkai Lamecwan tøgaguinukkurrimbunø pilamera setecientos ochenta y dos tøgaig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Inchawei Matusalén kerrigu øsig tsuin kwalømmerabe pilamera novecientos sesenta y nueve køben, yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamecbe pilamera ciento ochenta y dos øsig tsua, kan nusrkai tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Incha truigwane Noé cha wamig køn, kaguende nøbe trenchibig køn: “Jehová pirøwan larrø trømbøig nebunrrai mara pasrim pirau, nam chi mariiløyu purø trømbøig murig pui melaigugurri namun i unøbe chairannrrun” chib. ");
INSERT INTO gum_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Incha Lamecbe nusrkai Noéwan tøgaguinukkurrimbunø pilamera quinientos noventa y cinco tøgaig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Inchawei Lamec kerrigu øsig tsuin kwalømmerabe pilamera setecientos setenta y siete køben, yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noébe pilamera quinientos tøgaig kua, pøngatø nusrkalø tøgaguig køn: Semwanba, Camwanba, Jafetwanba. ");
INSERT INTO gum_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Inchen yandø møguelø pirau truørø larrøbichib menda, nømbe nimbasrmera tøgagøb mendig køn. ");
INSERT INTO gum_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Inchen Tiuswei nusrkaløbe, tru Tiuswan ashmø misaamerai nimbasrmerabe truba truba tabzheelø kua asha, tru utu mas tab ishumburmeran lawa, nømuyasig sralø marøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Inchene Jehovábe trenchibig køn: “Nai Espiritube misag øsig kønrrai nuinuube managatikkucha pasrønrraamøn cha, kaguende møøbe patsønrrabig ka treetø køn cha. Inchawei nøbe øsig tsumibe pilamera ciento veintebe tøgagønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tru kwalømmerawane purø nørrø møguelø warabig køn, larrø nørreelø. Inchen katø tru Tiuswei nusrkaløbe tru møguelai nimbasrmeraba kasharawa, ureg tøgaguig køn. Inchen tru i møgueløbe chish møguelø chiyugucha kørmeelø købig køn, truiløbe merrabsrøngurri mumera kuilan nebua asi misaamera. ");
INSERT INTO gum_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Inchen Jehovábe ashibig køn pirau misaamera larrø trømbøig marøb amrruibe chi lamøtiig kømø, purø nuig kui, nømui manrraube chu uragucha kerrigu chi isuiløbe kaigwandø, kaigwandø isubelø kuikkurri. ");
INSERT INTO gum_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Inchen Jehovábe yeekkucha kuitamab isubig køn, pirau misagwan tsunrrai marigwan. Nui manrraube purø kørrø isub pusrkwabig køn. ");
INSERT INTO gum_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Incha Jehovábe trenchibig køn: “Misagwan mara pønsrailan chigucha kaanrrai patsøgønrrab cha, misagwan lata, ushameran lata, srala amøñibelan lata, pala amøñib illimeran lata. Karrenguitamab isur cha, øsig kønrrai na mariilan.” ");
INSERT INTO gum_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Inchen køben Noébe Jehováwein kabyu nøbe tabig kui asig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iig køn, Noéwan maig pureb arrigwan waminchibig: Noébe sølgandø maig maramigwan marøb, nøbaguetøtø nørrørawarmerai utu nøbe sølgandø maig maramigwan marøb, katø Noébe Tiusba maig unamig køben treeg uñibig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noébe pøngatø nusrkalø tøgaguig køn: Semwanba, Camwanba, Jafetwanba. ");
INSERT INTO gum_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Inchen piraube larrø trømbøig minchib, katø melambuyab kalø marig truitø netsain pasrabig køn Tiuswei merrab. ");
INSERT INTO gum_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tiusbe pirøwan ashene, truyube larrø trømbøig mincha pasrabig køn, kaguende maya misaamerabe larrø trømbøig mincha pasrøben tru nømui amønainug. ");
INSERT INTO gum_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Inchen Tiusbe Noéwane trenchibig køn: —Maya misagwan øyandø kønrrai nabe treeg isur cha. Kaguende nømgurrindø pirøbe larrø trømbøitø netsaim pasran cha. Incha nømune pirøwanbañau pinishinrrab cha. ");
INSERT INTO gum_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Incha ñibe gofer tsiitøga kan arca mar chibig køn. Incha truyube cuartomera mara, umbuwan lata, wambigwan lata, pi larraimønrrai brea srølrrig cha. ");
INSERT INTO gum_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Incha marøppe, øyeeg martrig chibig køn: Yammaybe ciento cuarenta metrosig, lendømaybe veintitrés metros tøgaig køben, palamaybe catorce metros tøgaikke. ");
INSERT INTO gum_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Incha arcane pøn itøniisraig mara, pala patsabsrøngurri pinag cincuenta centimetrosyuh pendanarrab pasrtrig cha. Incha mumay malømay køben kan yaskab pasrtrig cha. ");
INSERT INTO gum_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kaguende nabe pirau pi pulab arrubig ørtrab kur cha, tru srømbala umbuwan chigurrimbunø øsig warabelan pinishinrrai. Inchawei pirau chigurrimbunø købiibe chishtø pinønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Inchendø nabe ñune øyamay pasramønrrun cha, ñibe ñui sraimba, ñui nøsrkaløba ñui nusrkalai sraløba tru arcayu kebamrrigay cha. ");
INSERT INTO gum_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Incha chigurrimbunø øsig købigwan trumørig truilan parchig, parchig kebambingarunrrig cha, chi ushamerandøgucha, kan ishuuba, kan møøba, ñiba øsig kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Chi illimerandøgucha, chi ushamerandøgucha, sraløb amøñibelangucha trumørig parbatø øsig kønrrab ñiba kebamrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Incha nøm chi mabelø køben, chi mamikkurrimbunø ñi tulisha, esegau cha, truilaimba, ñuimba mab kømig kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Inchen Noébe Tius maig karuigwan kerriguh treeg marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Incha Jehovábe Noéwan trenchibig køn: —Ñiba ñui yaueløba arcayu kebinrrø cha, kaguendø nai merrab ñundøwei sølgandø tabigwan marøbig kui ashar cha, møi misaamerai utu. ");
INSERT INTO gum_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Inchen chi ushameratøgucha tabig chishelane trattrø y pagatøbatø møg ushameraba, trattrø y pagatøbatø ishug ushameraba kertrig cha møøba ishuuba, møøba ishuuba. Inchen chi ushameratøgucha chishig kømeelane, kan møøba, kan ishuuba, pagatø, pagatø kertrig cha. ");
INSERT INTO gum_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Katø treetøwei pala illimerangucha, trattrø y pagatøbatø kertrig cha, møøba, ishuuba, pirau tru illimeran piniimíig tøgagønrrab. ");
INSERT INTO gum_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kaguendø trattrø y pa kwalømyube yu pirau kwalømmera cuarenta, yemmera cuarenta purayamne sre pungarumønrrun cha. Na mariilø chigurrimbunø øsig købigwane kerrigu chish paluuncha pinisamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Inchen Noébe Jehová maig karuigwan kerriguh treeg marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tru uras Noébe pilamera seiscientos tøgaig købig køn, tru pi pulab arrubig pirøwan chishtø kasrøb arrub uras. ");
INSERT INTO gum_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Inchen Noébe nui srain køben, nusrkalø køben, yernamera køben arcayu kebibig køn, tru pi pulab arrubigugurri kwamø, øsig webinrrab. ");
INSERT INTO gum_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Inchen chi ushameratøgucha tabig chishelø lata, chishig kømeelø lata, pala amøñib illimera lata, katø pirau srala amøñibelø lata ");
INSERT INTO gum_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Noéba arcayu kebambubelø køn, parbatø, parbatø, møøba ishuuba, møøba ishuuba, Noéwan Tius mandø karuig, treekke. ");
INSERT INTO gum_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Indig tru trattrø y pa kwalømyu tru pi pulab arrubiibe pirau chishtø kasrøb netsab arrub mendabig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Inchen Noéwei øsig tsuin pilamera seiscientos køben, tru pila kebyaig pa pølyu diecisiete kwalømh, tru marmera mas purø nørreelø umbusrøngurri chab wesrurrøben, tru srømbalasrø pimeran katab pønrrabelan truilangucha kuren, ");
INSERT INTO gum_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","piraube yemmera cuarenta, kwalømmera cuarenta purayamne sre arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Inchen tru kwalømh arcayu kebambig køn Noé køben, nui nusrkalø Sem køben, Cam køben, Jafet køben, Noéwei srain køben, nusrkalai pøngatø sralø købengue. ");
INSERT INTO gum_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Incha nømba kebambubelø køn, tru kau umbu namig usahamera trumørig, kusreeg ushamera trumørig, pirau srala ambub ushamera trumørig, katø illimera trumørikke, katø kwaldzariibarmera købendø pala ammeelø købengue. ");
INSERT INTO gum_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Øyeeg kebambig køn arcayu Noéba, chigurrimbunø øsig købeløbe parbatø, parbatøgue. ");
INSERT INTO gum_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Inchen tru kebambubeløbe trumørig ishuuba, møøba kebambig køn, Tius maig karuig, treekke. Inchen Jehovábe yaskabwan yandø kasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Inchen pirau tru pi pulab arrubiibe kwalømmera cuarenta nemisramnegatig pulab iben; pimera pulab menda, tru pimerabe arcane piraugurri pala kusruig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Inchen pimerabe pirau nurabig nurab arruben, arcabe pi palawan uñibig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Inchen pimerabe piraube truba truba pulab nebib iben, maya srømbalamerai umbu tunmera purø paleelø pønrrabeløguen chishtøh pinøgasraig kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Inchen tru purø pala tunmerawan pimera chab pinøgasrainukkurri katøgucha pimerabe palabunø siete metros purab neguchib pulabig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Inchen chigurrimbunø pirau øsig warabeløbe kerriguh chab kwabig køn, illimera lata, ushamera kusreeg ushamera lata, namig ushamera patsøtøga srala ambubelø lata, trugurri maya misaamera lata. ");
INSERT INTO gum_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Inchen chitøgucha kimrrabmay israbig øsiguelø pirau warabeløbe mayambah chishtø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Øyamay chimeratøgucha pirau øsiguig warabeløbe chab pinisailø kuig køn. Misag lata, ushamera lata, patsøtøga srala ambubelø lata, katø pala amøñib illimera lata pinisaig kørrømisrig køn. Øsig kørrømisrøppe, Noébah tru arcayu tru nøba kebambubeløtøwei øsig kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Inchen pimerabe tru pirø palawan kwalømmera ciento cincuenta nemisramnegatig pi netsaig kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tiusbe Noéwanba, truyu kusreeg ushameranba, namig ushameranba kerriguba tru arcayu Noéba purrabelan isubig køn. Incha Tiusbe pirau kan isig ichibig arringaruben, pimerabe kørreb mendabig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pimera pirø umbusrøngurri wesrurrabeløbe kasrøben, tru srømbalasrø pimeran katab pønrrabelan kuriiløgucha kasrøben, srømbalasrøngurri sre arrubiibe yandø mas pumøben inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Inchen pimerabe pirau lamøh, lamø kørreb ib mendøben, kwalømmera ciento cincuenta puraiben pimerabe chab lamørabig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Inchen trattrø y pa pøl misren, diecisiete kwalømh arcabe Ararat tunmerasrø pasramisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Inchen pimerabe pa trattrø pølgatig kørreibig kørreb arruben, tru pa trattrø pøl ke srøsrø kwalømyuh tru nørrø tunmerain pala yuumerabe kenamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Indig truyugurrimbunø kwalømmera cuarenta nemisren, Noébe tru nø mari arcayu pendanawan kura, ");
INSERT INTO gum_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kan yalø illiwan øren, truibe yaitø, arriitø inchib uñibig køn pimera pirau kølamnegatig. ");
INSERT INTO gum_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Incha katø kan palomangucha inrrai ørøbig køn pirau pimera køliitashchab ashchab. ");
INSERT INTO gum_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Inchen palomabe arcayumay katø arrubig køn, kaguende ni chugucha punamig chi kaaben. Pimerabe katøgucha pirø palawan kasraig srø køben. Inchen Noébe nui kwalwan yuula, paloman kemøra, katø umbu kesrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Incha kan trune muniirawa, paloman arcayugurri katø inrrai ørøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Indig tru palomabe maaben misrøb køben arruppe, kan olivo ishiizhig kimtsigu mutaig arruptinchen, Noébe pimera pirau yandø chab kølin kui wetøbeñibig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Incha trugurrimbunø katøgan trune muniirawa, katø paloman øriibe, yandø katøle truibe nuimay arrumøtø, pinab pinabig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noé øsig tsuin pilamerabe seiscientosba kan pilaba køben, tru srøsrø pølyu ke pølbasrøb kwalømyuh pimerabe pirau chishtø chab kølabig køn. Inchen Noébe tru arcayu pala kasraigwan kusrua ashene, møimbe pirøbe yandø pur køptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Inchen katø tru wendø pølyu tru veintisiete kwalømyube pirøbe yandø kerrigu pur købig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Inchen Tiusbe Noéwane trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","—Arcayugurri ñiba, ñui sraimba, ñui nusrkaløba ñui nusrkalai sraløba webambay cha. ");
INSERT INTO gum_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Incha ushamera tru ñiba purrabelangucha mayamba chishtøh wer chibig køn; maya illimeran køben, ushameran køben, katø pirau srala amøñibelan køben, pirau ørøba truørø amrrain cha; pirau yellmera purø nørrø misrøb purø nu larrøbichib amrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Inchen Noébe nui nusrkaløba, nui sraimba, nusrkalai sraløba webarrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Inchen kerrigu ushamera køben, srala amøñib ushamera køben, illimera køben, pirau chimera køben øsig købeløbe trumørig, trumørig arcayugurri webambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Incha trugurrimbe Noébe Jehováweyasig kan altar mara, tabig chish ushameran møigwanguen palab kømø, kerriguba, katø chish illimeran møigwanguen palab kømø, kerriguba, altarbala chishtø parrøb Jehováwan keta tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Inchen larrø mayzhig irrabig nuinug puben, Jehovábe trenchibig køn: “Misakkurrindø pirøwane managuen katølebe larrø trømbøig nebuim pasrønrrai marmumønrrun cha, kaguende møwei manrrøbe shushkurrimbunø kaigwandø, kaigwandø martrab isubelø køn cha. Katø chigurrimbunø øsig købigwane katølebe kerriguba pinishimumønrrun cha, møi lataibe. ");
INSERT INTO gum_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Pirøbe ka pasraingatiibe ellmariilø køb, ellmariilan tulisamelø køb, chu urastøgucha pachig købig køb, pishin købig køb inchun cha. Chu urastøgucha sre pølmera køb, kwarø pølmera køb, katø yemmera køb, kwalømmera køb inchun” cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Tiusbe Noéwanba nui nusrkalanba mayanguen tabig nebuilø kønrrai trana, nømune trenchibig køn: —Ureemera nørrø tøgagøb pirøwan netsøganrrigay cha. ");
INSERT INTO gum_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Pirau chi ushameratøgucha ñimune larrø kørig kuinchib kwartrun cha. Pala illimeran lata, pirau chigurrimbunø øsig warabelan lata, maryu piyaumeran lata, ñim ashib tøgagønrrai nabe ñimui tasku pønsrar cha. ");
INSERT INTO gum_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Chigurrimbunø kønabig øsiguelø købiiba, katø mamig tusrcheeløbabe ñim mab kømig kønrrun cha. Iigwan kerrigu na ñimun tranar chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Inchendø yau animbaigwan aniwan lusøskaimíigwane mamønrrigay cha, kaguende øsig kømibe aniyuweim pasran cha. ");
INSERT INTO gum_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Inchawei nabe tru ñimui øsig kui aniwane nabe ulø payamønrrun chibig køn. Ushamera pinisaig kui lata, kabe møguelai tasku pinisaig kui lata truigwane ulø payamønrrun cha. Nui mendaigwei øsig kuigwan pinishibigwane mu møwandøgucha ulø payamønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Inchawei møikkøben misag aniwan lushibigwane nui aniwangucha katøgan møg lusig kønrrain køn cha, kaguende møøbe Tius maig køppe, treetøwein kønrrai marig kuig kua. ");
INSERT INTO gum_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Trune ñimbe ureg nørrø tøgagøb, larrø nørrø larrøbitsay chibig køn, pirau purø nørrø misag karrab, pirau netsøganøb.— ");
INSERT INTO gum_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Incha Tiusbe Noéwanba nui nusrkalanba katø treekkucha taig køn: ");
INSERT INTO gum_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","—Nabe ñimba, katø ñuikkurri amrrub misaameraba øyamay kønrrai martrab cha kørrømaramønrrun cha, ");
INSERT INTO gum_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","katø tru chigurrimbunø øsig købelø ñimba pønrrabelø, kerrigu tru arcayugurri werrubelø: tru illimeraba, kusreeg ushameraba, namig ushameraba, pirau maya ushameraba. ");
INSERT INTO gum_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nabe ñimba øyamay kønrrai martrab cha pasramønrrun cha, nabe kerrigu øsig warabelan pi pulab arrubiitøgabe katølebe chishtø pinishinrrab kømur cha. Ni katø pirøwan pinishinrrab pi pulab attrabig katølebe chigaanrrabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Incha katø trenchibig køn: —Tru ñimba, katø trugurri tru chigurrimbunø chi øsig købeløba tru managatig na øyamay kønrrai martrab cha pasrigwan isunanøb eshkab pasrønrrabiibe iig køn cha: ");
INSERT INTO gum_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nai køshømbøtøn nabe wañiyu pasrar cha, iibe pirøba na øyamay kønrrai martrab cha pasrigwan treeg kuitamab ashib kømig kønrrai pasrønrrabig. ");
INSERT INTO gum_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Inchawei wañiwan na pirau pibøndøzhiibaig arringarubene, tru køshømbøtøbe wañiyu kenamisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Inchen nabe ñimba katø chigurrimbunø øsig købeløba tru na øyamay kønrrai martrab cha pasrigwan isumønrrun cha. Chigøben øsig købelan pinishinrrabig pi pulab arrubiibe katølebe kaanrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Inchawei køshømbøtø wañiyu kenamisrimørig maya misaameraba, katø i pirau kerrigu øsig købeløba tru na managatig øyamay kønrrai martrab cha pasrigwan isumønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Incha Noéwan trendaig køn: —Maya misaameraba, pirau chigøben øsig købeløba tru na øyamay kønrrai martrab cha pasrigwan treeg kuitamab asamiibe, iig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noéwei nusrkalø arcayugurri webambubeløbe Semba, Camba, Jafetba køn. Inchen Cambe Canaánwei møskain kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","I tru pøngatøbe Noéwei nusrkalø kuig køn. I tru pønelainukkurri amrrub misaamerayugurri pirau muba kuimburab misag netsaig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Incha Noébe pirau kwallib menda kan uvas ellguain tra marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Indiibe kan piji Noébe vino mucha mutsiirawa, tru nui carpa yau kebya, peña tsumisrøppe, køsaatiig tsuben, ");
INSERT INTO gum_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","tru Canaánwei møskai Cambe, møskai køsaatiig tsui ashabe, nui pa nunelan wambiisrø eshkanrrab webyain købig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Inchen Semba, Jafetbabe kan itøtsinsramig pamisra, nømui kildunyu pinøgucha, wendømaytø amba, møskai køsaatiig tsuben, trutøga kasra trarrøbelø køn. Incha ashmønrrab wendømaytø amba, treeg køsaatiig tsuben nui asr køsagwan ashmuig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Incha Noébe tru mutsiguig kib tsua kiagasra, tru mas unø nusrkai treeg indigwan wammørabe, ");
INSERT INTO gum_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","trenchibig køn: Canaánbe larrø trømbøig nebuinanrrabig kønrrun cha. “Nunelø ka karuindiig megabig mas chigucha kømíig købash” cha. ");
INSERT INTO gum_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Incha katø trenchibig køn: “Jehová, Semwei Tiuswane maya nuguen tab indig kønrrain cha. Inchen Canaánbe Sem manchiben, ka karuindiig megabig kønrrain cha. ");
INSERT INTO gum_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Inchen Jafetwane purø nuig kønrrai Tius kusrua pasrig kønrrain cha. Incha Jafetbe Semwei carpa yamerayu tsubig kønrrain cha. Inchen Canaánbe Jafet manchiben, ka karuindiig megabig købash” cha. ");
INSERT INTO gum_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Indig Noébe tru pirau pi pulab arrubig arrinukkurrimbunø pilamera trescientos cincuentagatig tsuig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Inchen Noé kerrigu øsig tsuim pilamerabe novecientos cincuenta kuig køn. Inchen yandø kwaig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iiløbe tru Noéwei nusrkalø Semweimba, Camweimba, Jafetweimba truilø nøm tøgagui nusrkalø køn, tru pirau pimera pulabig arrua puraiben tøgaguilø. ");
INSERT INTO gum_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafetwei nusrkaløbe iilø køn: Gomer køben, Magog køben, Maday køben, Javan køben, Tubal køben, Mesec køben, Tiras købengue. ");
INSERT INTO gum_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Inchen tru Gomerwei nusrkaløbe iilø køn: Askenaz køben, Rifat køben, Togarma købengue. ");
INSERT INTO gum_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Inchen Javanwei nusrkaløbe: Elisa køben, Tarsis køben, Kitim køben, Rodanim købengue. ");
INSERT INTO gum_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Inchen truilainukkurri amrrub misaamerabe mar puluwan pirømerawansrø warabelø kuig køn. Truiløbe misag nørrø søtømeramørig, katø mu møskalø køben, yau misaamera trumørig nømuin kui, nømuin kui pirømera waramig tøgartø købig køn, katø nømbe trumørig nømuin trigwan waminchibeløgue. ");
INSERT INTO gum_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Inchen Camwei nusrkaløbe iilø køn: Cus køben, Mizraim køben, Fut køben, Canaán købengue. ");
INSERT INTO gum_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Inchen Cuswei nusrkaløbe: Seba køben, Havila køben, Sabta køben, Raama køben, Sabteca købengue. Inchen tru Raamawei nusrkaløbe: Sebaba, Dedánba kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Inchen Cusbe Nimrodwei møskain kuig køn. Tru Nimrodbe pirau mugucha chinchaingaig ke nø karub pølbasrig køn, yu pirau ke srøsrøzhiitø. ");
INSERT INTO gum_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Truibe Jehováwei merrab kaambu ushameran pasraarøb kemøramibe ke piaig lataig købig køn. Inchawei misaabe treeg taig tøgar købig køn: “Jehováwei merrab kaambu ushameran pasraarøb kemøramigwan larrø may kemørammaybe, Nimrod lataig køn” cha. ");
INSERT INTO gum_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Inchen nø karub tøgagui ciudamera mas nørreeløbe iilø køn: Babel køben, Erec køben, Acad køben, Calne købengue, tru Sinar pirau. ");
INSERT INTO gum_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Incha Sinargurrimbe Nimrodbe Asursrømay webya, truyube Ninive ciudameran mara pønsrøbig køn, tru Rehobot ciudawanba, Cala ciudawanba. ");
INSERT INTO gum_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Trugurrimbe tru Niniveba tru Calaba tru i pa ciudamerai tøbøtag pasrabig tru Resen purø nu ciudawan mara pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Inchen Mizraimweinukkurrimbe ludeos misaamera køben, anameos køben, lehabitasmera køben, naftuhitasmera køben, ");
INSERT INTO gum_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patruseosmera køben, casluitas misaamera køben, caftoritasmera køben købig køn. Tru i caftoritasmerai misaamerayugurri tru filisteos misaamera amrruig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Inchen Canaánbe tru nui mayur nusrkai Sidonweimba, Hetweimba møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Inchen tru i Canaánweinukkurri amrrub misaamerabe jebuseosmera køben, amorreosmera køben, gergeseosmera køben, ");
INSERT INTO gum_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveosmera køben, araceosmera køben, sineosmera køben, ");
INSERT INTO gum_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeosmera køben, zemareosmera køben, hamateosmera køben købig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Inchen tru Canaánweinukkurri amrrub misaamerabe chu pirausrøn køben tru ørø, tru ørø chab ambubelø køn. Inchawei tru Canaán pirø muba kuimburab luløbiibe Sidongurri Gazasrøngatig larrøbichib luløbig køn, tru Gerarguebsrø. Incha trugurrimbe Lesasrøngatig luløbig køn, tru Sodomaba, Gomorraba, Admaba, Zeboimba truguebsrø. ");
INSERT INTO gum_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Iilø kuig køn, tru Camweinukkurri amrrub misaamera, truiløbe misag nørrø søtømeramørig, katø mu møskalø køben, yau misaamera trumørig nømuin kui, nømuin kui pirømera waramig tøgartø, katø nømbe trumørig nømuin trigwane waminchibeløgue. ");
INSERT INTO gum_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Inchen tru Sem Jafetwei mayur nuneg truikkucha nusrkalø tøgaguig køn. Semweinukkurri amrrub misaamera kuig køn tru Heberwei maya nusrkaløbe. ");
INSERT INTO gum_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semwei nusrkaløbe iilø køn: Elam køben, Asur køben, Arfaxad køben, Lud køben, Aram købengue. ");
INSERT INTO gum_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Inchen Aramwei nusrkaløbe: Uz køben, Hul køben, Geter køben, Mash køben kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Inchen Arfaxadbe Selajwei møskain køben, Selajbe Eberwei møskain kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Indig katø wendø Eberbe pagatø nusrkalø tøgaguig køn: tru srøsriibe Peleg munchi købig køn, kaguende nø tsuin kwalømmerawan pirøwan pirisaig købig kua. Inchen kan nuneebe Joctán taig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Inchen Joctánbe Almodadwan køben, Shelefwan køben, Hazarmavetwan køben, Jeran køben, ");
INSERT INTO gum_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramwan køben, Uzalwan køben, Diklan køben, ");
INSERT INTO gum_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obalwan køben, Abimaelwan køben, Sheban køben, ");
INSERT INTO gum_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofirwan køben, Havilan køben, Jobabwan køben tøgaguig købig køn. Iiløbe kerriguba tru Joctánwei nusrkalø kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Inchen tru nøm waraig pirømerabe Mesagurri ibiibe, Sefarburabsrø puraya, trugurrimbe tru nørrø tunmera tøga pirømera tru pørr neeshibgatøwansrøngatig ibig køn, ");
INSERT INTO gum_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Iilø kuig køn, tru Semweinukkurri amrrub misaamera, truiløbe misag nørrø søtømeramørig, katø mu møskalø køben, yau misaamera trumørig nømuin kui, nømuin kui pirømera waramig tøgartø, katø nømbe trumørig nømuin trigwan waminchibelø. ");
INSERT INTO gum_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Iilø køn tru Noéwei nusrkalainukkurri mu møskalø køben, yau misaamera mumeratø købig kuig, katø møigweinukkurri amrrub misaamera købig kuig, misag nørrø søtømera møyuelø købig kuig, treekke. Inchawei tru pi pulabig chab pinisha puraiben, truiløbe ambuurab, iburab larrøbichib amba, yu pirø muba kuimburab misaamera nørrø søtø misrig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tru urassrømbe misaamerabe pirø muba kuimburab kan wamdø waminchibelø købig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Incha tru pørr neeshibgatøsrøngurri webamba ambub kuabe, tru Sinar pirausrømbe kan purø tab chag pirø wetørrawa, yandø nømbe truyu waramisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Incha kan kwaløm nømbe kangurri, kangurri trenchibelø køn: “Naarillusmera margun cha. Incha nagu partrab” cha. Incha øyamay sruumeratøga marøbgunrriibe naarillutøga marig køben, chilliitøga marøbgunrriibe asfaltotøga maramig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Incha trugurrimbe trenchibelø køn: “Kan ciuda margun cha, kan purø palaig marig tøgaig, truibe pala patsabsrømbe srømbalasrøngatig kachibikke. Treekkurrimbe mugui nebua asiilø nørreelø misra, pirø muba kuimburab ke tru ørøtø amba waramig kaanrrun” cha. ");
INSERT INTO gum_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Inchen Jehovábe kørraarrubig køn, tru ciudawanba tru torrenba tru møguelai nusrkalø marigwanba ashchab. ");
INSERT INTO gum_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Incha Jehovábe trenchibig køn: “I misaamerabe kandø køb, wamgucha kandø waminchib, katø tru maramigwangucha yandø martrab pølbasra køn cha, trurrigu nøm martrab indigwane muguin katiasamørra cha. ");
INSERT INTO gum_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Inchawei kørraamun chibig køn, nømui wamindi wamwan ni chiwan wamindi møramgaig misrtrai martrab cha, møikkurrindøgucha nømasiitø ni chi tainguen mørtrab kaimanrrai.” ");
INSERT INTO gum_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Incha øyamay Jehovábe pirø muba kuimburab tru ørø larrøbichib amrrai maren, yandø tru ciudawan marmøtø, yandø lelachibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Incha treekkurri Babel cha wamig køn, kaguende pirau muba kuimburab wamindi wamwan Jehová truyuh nøm mandø kuinguen mørmønrrai marig købig kua. Incha trusrøngurri nømune pirau muba kuimburab tru ørø amba warønrrai marig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iilø køn tru Semweinukkurri amrrub misaamera: Sembe pilamera cien tøgaig kua, Arfaxadwan tøgaguig køn, tru pirau pi pulab arrubig purayaig pa pila køben. ");
INSERT INTO gum_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Incha Sembe tru Arfaxadwan tøgaguikkurrimbunø pilamera quinientos øsig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxadbe pilamera treinta y cinco tøgagua, Salan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaxadbe Salan tøgaguikkurrimbunø pilamera cuatrocientos treskatig øsig tsua, nusrkalø køben nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salabe pilamera treinta tøgagua, Eberwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Incha Salabe Eberwan tøgaguinukkurrimbunø, pilamera cuatrocientos tres øsig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberbe pilamera treinta y cuatro tøgagua, Pelegwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Incha Eberbe Pelegwan tøgaguinukkurrimbunø pilamera cuatrocientos treinta tøgaig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Inchen Pelegbe pilamera treinta tøgagua, Reuwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Incha Pelegbe Reuwan tøgaguinukkurrimbunø, pilamera doscientos nueve øsig tøgaig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reube pilamera treinta y dos tøgagua, Serugwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Inchen Reube Serugwan tøgaguinukkurrimbunø pilamera doscientos siete øsig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugbe pilamera treinta tøgaig tsua, Nacorwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Incha Serugbe Nacorwan tøgaguinukkurrimbunø pilamera doscientos tøgaig tsua, nusrkalø køben, nimbasrmera køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacorbe pilamera veintinueve tøgagua Térajwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nacorbe Térajwan tøgaguinukkurrimbunø pilamera ciento diecinueve tøgagua nusrkalø køben, nimbasrmera køben, tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térajbe pilamera setenta tøgagua, Abramwan køben, Nacorwan køben, Haranwan køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Iilø køn tru Térajweinukkurri amrrub misaamera: Térajbe Abramwan køben, Nacorwan køben, Haránwan køben tøgaguig køn. Inchen Haránbe tru Lotwan tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Inchen nui møskai Téraj kwamøwatø, tru Haránbe Caldeosmeraim pirausrø, tru nø kal-laim pirau kwaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Inchen Abramba, Nacorbabe nømuyasig sralø laig køn. Tru Abramwei sraimbe Sarai købene, Nacorwei sraimbe Milca taig købig køn, tru Haránwei nimbasr. Tru Haránbe Milcaimba, Iscaimba møskain kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Inchen Saraibe chi ureg tøgagønrrabig kømíig kua, chi urekkaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Inchen tru Tarébe tru nui nusrkai Abramwanba, katø Haránwei nusrkai nui awelu Lotwanba, nui yerna tru Abramwei srai Saraiwanba, pera webibig køn, caldeosmerai pirau Ur tainukkurri tru Canaán pirausrømay inrrab. Inchendø tru Harán taig pirausrø puabe, truyu kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Inchen tru Téraj øsig tsuin kwalømmerabe pilamera doscientos cinco kuig køn. Incha Térajbe Harán pirausrø kwaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Jehovábe Abramwane trenchibig køn: —Ñuim piraugurrimba, ñui yau misaamerainukkurrimba, trugurri ñui møskawei yaugurrimba inrrø cha, na ñun eshkam pirausrømay. ");
INSERT INTO gum_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nabe ñigurri purø nørrø misag søtømera kønrrai marøb, katø mayanguen tabig nebuig kønrrai mara, ñui munchiwane mayeelø nebua asig kønrrai maramønrrun cha, ñibe katøganelayasig maya nuguen tabig kønrrai, ñibe treeg kønrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nabe ñun mayanguen tabig nebuig kønrrai marøbelane, nømungucha mayanguen tabig nebuilø kønrrai maramønrrun cha. Ñun trømbøig nebunrrai marøbelane, nømungucha trømbøig nebuilø kønrrai maramønrrun cha. Incha pirau chi misaamera køben pirø muba kuimburab warabeløbe ñuinug mayanguen tabig nebuilø kønrrai mariilø kønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Inchen Abrambe Jehová maig chiben ibig køn. Inchen nøbabe Lotgucha ibig køn. Tru Harán piraugurri Abram webib urasbe nøbe pilamera setenta y cinco tøgaig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Incha Abrambe nui srai Saraiwan køben, nui nunewei nusrkai Lotwan køben pera ibig køn, katø chigurrimbunø nø chi tøgaguilan køben, katø tru Harán pirau nui karuig mendig melab misaameran købengue. Nøbe Canaán pirausrø truiløba pubig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Incha Abrambe Canaánsrø puabe, tru pirau kerrigu pureb ya, tru Siquénsrø pubig køn, tru Moré Tusr taig pasramnug. Inchen tru urassrø tru cananeo misaamerabe Canaan pirau warabelø købig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Inchen Jehovábe Abramwan kenamisrabe trenchibig køn: —Ñuinukkurri amrrub misaameran nabe truilan i pirøwan trananmønrrun— cha. Inchen Abrambe kan altar kusrabig køn tru Jehová nun kenamisrøbigweyasig. ");
INSERT INTO gum_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Incha trugurrimbe tunmeragøba tøga pirømerasrømay ibig køn, tru Betel pørr neeshibgatømaysrø. Incha tru nui carpa yawan truyuh lasrua pasrøbig køn. Inchen Betelbe pørr pinebgatømay kørrømisrene, Haibe pørr neeshibgatømaysrø kørrømisrøbig køn. Incha nøbe Jehováweyasig kan altar kusrua, nui munchiwan isub wamabig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Incha Abrambe truyugurri webya, ibig køn, kørrømisrøb, kørrømisrøb tru Neguev pirausrøngatig. ");
INSERT INTO gum_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tru Neguev pirausrømbe parø arrum mendøben, Abrambe Egipto pirausrømay kørraarrubig køn truyu tsunrrab, kaguendø tru Neguev piraube purø trømbøig parø pasrøben. ");
INSERT INTO gum_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Incha Abrambe ke Egiptosrø chab pub ib pasrøwabe, nui srai Saraiwane trenchibig køn: —Na ashen ñibe purø tab ishug køn cha. ");
INSERT INTO gum_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Egipto misaamera ñun ashippe, trenchinrrun cha: “Ñui srain køn” cha. Incha nane kweecha kuchippe, ñune øsig kønrrai ka uñbashchun cha. ");
INSERT INTO gum_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Inchawei tiusmanda ñibe naimbe nuchag kur chinrrig cha, ñigurri nan chigucha kømø, tab kønrraimba, katø nan kweechimønrraimba.— ");
INSERT INTO gum_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Indiibe yandø Abram Egiptosrø kebibene, tru egipciomerabe tru ishuube larrø tabzhig kui ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Inchen tru Faraonwei merrab nørreelø pønrrabelø ashabe, truiløgucha Faraónwei merrab purø tab waminchib køben, tru ishuwane Faraón nø waig yaumay pera ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Incha tru Saraigurri tru Faraónbe Abramwan larrø tab inchib, ubishamera køben, waaramera køben, burrumera køben, karuindiig mendig melabelø møguelø køben ishumburmera køben, camellomera køben keta, tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Inchendø tru Abramwei srai Saraigurri Jehovábe tru Faraónwanba nui yau misaameranba murba kebatig køn, purø trømbø kwanrrømeratøga. ");
INSERT INTO gum_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Inchen Faraónbe Abramwan wama, trenchibig køn: —¿Nan øyeebe chi margu? cha. ¿Chindimbarre ñui srain køn cha eshkamugu? cha. ");
INSERT INTO gum_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Chindimba trenchigu cha: “Nai nuchag køn” chabe. Nai srain kønrrai na treeg marig kuimasr cha. Møimbe ñui sraimbe yu pasran cha. ¡Pereptsu!— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Incha Faraónbe nui karuig pønrrab møguelan ørøbig køn ¡katø! webambi ashib pønrrønrraingue, Abramwanba nui srawanba nui chigurrimbunø købigwanbañau sruaamrrai. ");
INSERT INTO gum_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Incha Abrambe Egiptogurri nui sraimba katø nui chine tøgaguiløbañau Neguev pirausrømay katø arruben, nui kuchiunø Lotgucha nøba arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abrambe ushamera tøga kuiløyu lata, an tøgaguiyu lata, oro tøgaguiyu lata purø pua møg købig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Incha Abrambe Neguevsrøngurri katøle arruppe kørrømisrøb, kørrømisrøb arrub tsubig køn tru Betel misag søtømera waraisrøngatig, tru merrabwansrø nø tru carpa yawan lasrua tsuig købiisrø, tru Betelba, Haiba misaamera warabnug tru tøbøtag. ");
INSERT INTO gum_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Truyu kuig køn tru merrabsrø nø kan altar mara kusruinug. Incha truyu Abrambe Jehováwei munchiwan isub wamabig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot tru Abramba lincha ibikkucha ubishamera køben, waaramera køben, carpa yamera køben tøgaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Incha pirøbe kanbalatø lincha waramibe truburab tre lendø kømíig køn, kaguende nøm tøgaguiløbe purø nørrø kua, trubalatøbe waramgaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Indiibe kan kwaløm Abramwei ushameran ashibeløba, Lotwei ushameran ashibeløba aleguiab kurrabelø køn. Inchagucha tru urasbe cananeosmeraba ferezeosmeraba truiløgucha truyu warabelø købig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Inchen Abrambe Lotwane trenchibig køn: —Nam pailainug lata, katø nai ubisha ashibeløba, ñui ubishameran ashibeløba truiløgucha chi kwayab kømig chi kaanrrain cha, kaguende nambe nunelø ker cha. ");
INSERT INTO gum_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","¿Pirøbe asimburab kerriguba ñui merrab pasrømuitarru? cha. Tiusmanda nainukkurri tarømisrtra cha, ñi atsimay ibene, nabe kursmay yamønrrun cha, ñi kusrmay ibene, nabe atsimay inrrur— cha. ");
INSERT INTO gum_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Inchen Lotbe ashib pasrøwabe, tru Jordan chaabe kerriguba Zoarsrøngatig pizheelø purø tøga pirømera kui ashibig køn. Jehováwei ellmarin tul lata tabzhikke; kabe tru Egipto pirømera lataikke. Tru Jordanbe treeg kuig køn, Jehová Sodoma ciudawanba Gomorra ciudawanba pinishimøwatøbe. ");
INSERT INTO gum_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Incha Lotbe kerrigu Jordan chagwan nø merrarrawa, Lotbe tru pørr neeshibguebwansrø ibig køn. Incha øyamay Abramba, Lotba nøørø misrig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrambe Canaán pirau kørrømisra tsuben, trune Lotbe tru Jordan chag pirø ciudamerasrø tsunrrab ibig køn. Incha tru nui carpa yamerane Sodomasrøngatig lasrua pønsrøb ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Inchen tru Sodoma warab misaamerabe larrø kailø kua, larrø trømbøgølig marøbelø købig køn, Jehováwan kalø marøb. ");
INSERT INTO gum_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Inchen yandø Lotbe Abramwan tarømisringuen køben, Jehovábe Abramwane trenchibig køn: —Abram, kurrasha cha, ñi pasrainukkurri tab ash cha, waguebwansrø, walliguebwansrø, pørr neeshibgatøwansrø, pørr pinebgatøwansrø, ");
INSERT INTO gum_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","pirøwan muba kuimburab mayamba ñi nebua asigwan ñunba, ñuinukkurri amrrub misaameranba managatigweyasig na ñun tranamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ñuinukkurri amrrub misaamerabe nørrø køptø kan pirau usrøtui lataig kønrrai maramønrrun cha. Usrøwanma muguen mundamgaig kuig køppe, ñuinukkurri amrrub misaameragucha mundamgaig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kurra, tru pirø yammay maya yab kuigwanba, lendømay mayan kuigwanba llirab inrrø chibig køn, kaguende nabe ñun tranamig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Incha Abrambe tru nui carpa yameran picha kusrua, Manre tainug nørrø parøndzig encinas tusrmera pønrrabnug tsunrrab ibig køn, tru Hebrónsrø. Incha truyube Jehováweyasig kan altar kusrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tru kwalømmerawan tru Amrafelbe Sinarsrø rey køben, Ariocbe Eleasarsrø rey køben, Quedorlaomerbe Elamsrø rey køben, Tidalbe Goyimsrø rey købig køn. ");
INSERT INTO gum_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Incha truiløbe kwayabrren købig køn, Sodomasrø rey Beraba køben, Gomorrasrø rey Birsaba køben, Admasrø rey Sinabpa køben, Zeboimsrø rey Semeberba køben, katø tru Belasrø reyba købengue, truibe Zoargucha taig. ");
INSERT INTO gum_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Incha tru i trattrøgatø reymerabe nømui suldaumeraba tru Sidim chagu kanbalatø misrig køn kwayanrrab, tru Mar Trebi taisrø. ");
INSERT INTO gum_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tru rey Quedorlaomerbe nømune pa trattrø y pa pila nø karub tøgagøben, pa trattrø y pøn pilayube tru trattrøgatø reymerabe tru Quedorlaomerwan mas karuig mørøb melømønrrab mur pønrramisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Incha tru pa tratrø y pib pilayube Quedorlaomerbe tru reymera nuingatø pønrrabeløba Astarot Karnaim pirausrømay amba, truyube refaitasmeran kanawa kørrømarøppe, Ham taisrømbe zuzitasmeran, Save Quiriataimsrømbe emitasmeran, ");
INSERT INTO gum_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Seir tunmerawansrømbe horeosmeran kanawa kørrømara, tru Paran chaamerasrøngatig ambubelø køn, tru misag waraimíig chi misrmø pirø puluwansrø. ");
INSERT INTO gum_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Incha truiløbe katøle amrruabe, tru Gadessrø Enmispat taisrø pua, amalecitasmerai pirømerasrømbe kerriguh chi købigwan chishtø pinisha, katø tru Hazezon Tamar pirau amorreosmera warabelan treetøweih mara kørrømarøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Inchen Sodoma rey køben, Gomorra rey køben, Adma rey køben, Zeboim rey køben, Bela rey køben, Zoarsrø rey køben werrua, Sidim chaasrø tru reymeraba kwayab mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Tru Quedorlaomer Elamsrø reyba, Tidal Goyimsrø reyba, Amrafel Sinarsrø reyba, Arioc Eleasarsrø reyba truilø nøm pib reymera tru trattrøgatø reymeraba kwayabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Inchen tru Sidim chaasrømbe asfaltos pisumera truba, truba tøganug kuig køppe, tru Sodoma reyba Gomorra reyba tru kwayabyugurri nui suldaumeraba wegørra lulen, møiløbe truyu chab kegørrøben, kan reymerabe tunmerasrømay trubab chab luløbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Inchen tru pib reymera kanabeløbe Sodomaba, Gomorraba ciudayu chigurrimbunø købigwan, mamiimeran nømui mara wesrawabe, yandø truyugurri ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Inchen tru Abramwei nunewei nusrkai Lotgucha sodomasrø tsubig kuig køppe, nungucha merrarrawa, tøga srua ambuptinchibelø køn, nui chi tøgamisrigwanbañaungue. ");
INSERT INTO gum_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Inchen møikkøsrøn truyugurri welula arrubiibe, tru hebreo Abramwan ígwan kerriguh eshkabig køn. Inchen Abrambe amorreo tru Mamre taigwei tru nørrø parøndzig encinas tusrmera pønrrab puluwan tsubig kuig køn. Tru Mamrebe Escolweimba, Anerweimba nuneg køben, truiløbe Abramwanweingatø pønrrabelø treelø købig køn. ");
INSERT INTO gum_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Incha Abrambe tru nui yautøwei kal-lawarmeran trescientos dieciocho tru kwayamigweyasig kusrenani møgueløba tulaamba, truiløba webya, tru pibgatø reymeran wetøgønrrab Dansrøngatig pasra ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Incha yandø yem køben, Abrambe tru kwayamig kusrenni møgueløba, pesan københ kwayanrrab kegørra, Hoba taisrøngatig pasra ambubelø køn, Damasco tru waguebgatømay pasrab ciudasrø. ");
INSERT INTO gum_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Treencha chigurrimbunø wesra srua ambiilan katøle chab kerrab, katø nui kasugunø Lotwan nui chigurrimbunø tøgamisriilanbañau kerriguh chab kerrabig køn, katø ishumburmeranba, katøganelanba. ");
INSERT INTO gum_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abrambe Quedorlaomerwanba truigweingatø pønrrab reymeranba kanawa arruben, Sodoma reybe, tru Save taig chaasrø katønrrab webibig køn, truibe tru Reywein Chagu. ");
INSERT INTO gum_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Inchen tru Salemsrø rey Melquisedecbe, Tius Mayeelain Pala Pasrabigwei sacerdotebe pirrimba, vinoba wesrua, ");
INSERT INTO gum_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Abramwan mayanguen tabig nebuig kønrrai marøbig køn, øyeeg wammeratøga: “Tius Mayeelain Pala Pasrabig Srømbalameranba, Pirøwanba Marøbig ");
INSERT INTO gum_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tius Mayeelain Pala Pasrabig Purø Nuigwan maya nuguen tabig wamindig kønrrain cha, tru ñun ashig kømui inchibelan ñui tasku tranøbigwan. Inchen Abrambe chigurrimbunø katøle wetørrawa srua arrigwan cienyugurri diezwane wesrawa, Melquisedecwan tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Inchene tru Sodomasrø reybe Abramwane trenchibig køn: —Misaamerane nan trannrra cha, chigurrimbunø købigwane ñi tøga kørrømisrtrig— cha. ");
INSERT INTO gum_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Inchene Abrambe tru Sodomasrø reywane trencha løtabig køn: —Tius Mayeelain Pala Pasrabig Srømbalameranba Pirøwanba Marøbig Jehováwan ¡katø! nabe treebe marmumønrrun cha, nabe trendaig kuig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ni kan train pititøguen—, kabe nai alpargatis tsi-unøtøguen nabe ñuiwane chiwangucha nai marmumønrrun chibig køn, ñi managuen øyeeg chimønrrai: “Abrambe nagurrinrre pua misrig køn” cha. ");
INSERT INTO gum_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tru na pera pasraig møguelø mab mutsigwandø srørri maig kørrømistrain cha. Inchen tru naba amrrub møguelø Anerba, Escolba, Mamreba truiløbe si, nømuimburappe ka utønrrun— chibig kø n. ");
INSERT INTO gum_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Inchen øyeelø chab puraiben, kan piab lataigu Jehováweinukkurri wam Abramwan trenchibig køn: —Abram, chi kørig kui inchimøta cha. Nabe ñun chi kømønrrai ashib tøga pasrabig truig kur cha. Ñun tranamibe purø nuig kønrrabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Inchendø Abrambe trenchibig køn: —Jehová Tius ¿Ñi nan keta traniibe chi puruguimøriasamørra cha, na chi urekkaigwane? Inchen tru na chine tøgamisriilan merrarranrrabiibe tru Damascosrø Eliezer kømuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Incha katø Abrambe trenchibig køn: —Ñi nan kan nusrkai tranmuig købene, kan nai yautøwei kal-lawei nai kan karuindiig mendig megabig, truig nai chi tøgaguilan ketig utønrrabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Inchen katø Jehovaweinukkurri wam trenchibig køn: —Ñui chi købigwane truig ashchabig kømøtø, truilane ñui nusrkai utønrrabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Incha wambiisrø pera yabe, trenchibig køn: —¡Au! srømbalaneb nesh cha, kønchabiimeran mundamdø køtamørtrig— cha. Incha katø trenchibig køn: —Ñuinukkurri katøburø ureemerabe øyeetøwein kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Inchen Abrambe Jehováwan køreben, treekkurri nune Tiusbe chi kaig marmíig lataig, tabig treeg asha pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Inchene nøbe trenchibig køn: —Nabe Jehová kur cha, caldeosmeraim pirau tru Ur taisrøngurri wesrabig i Canáan pirøwan na ñun keta trannrab.— ");
INSERT INTO gum_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Inchendø Abrambe trenchibig køn: —Jehová Tius, ¿tru na truigwan nain kønrraitamappe nabe mandø incha asamerah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Inchene Jehovábe trenchibig køn: —Kan ishug waara-unøzhig pøn pilaiba, kan cabra pøn pilaiba, kan carnero pøn pilaiba, katø kan palomaba, kan paloma-unøzhiiba srua amø— cha. ");
INSERT INTO gum_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Inchen Abrambe tru ushameran kerriguh srua arrua, truilan sølgørrab tab tøbøtag para, tru pariilan tru pinrrøgue, tru pinrrøgue warøbig køn. Inchendø tru illimerane tøbøtag parmuig køn. ");
INSERT INTO gum_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Inchen yau mab illimerabe tru usha kweetsiilø warabelaimbalawan kørrørrub amrruben, Abrambe kwaarøsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Inchen yandø chab pilliraben, Abrambe truba mur kib tsubenba ¡møimbe ke yalø løstøgølig nun itøgasrøptinchen! nøbe truba kørig kui inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Inchene Jehovábe trenchibig køn: —Isa kømøtø, ñuinukkurri amrrub misaamerabe, ka peguelaim pirautø warønrrabelø køn cha, nømbe truilø karub sruaguindeelø meløwa, pilamera cuatrocientos nebumne larrø kaig indinab melønrrabelø køn cha. ");
INSERT INTO gum_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Inchendø tru nu søtø misaamera pasrabig nømun ka karuptø srua kønrrabelangucha numune møra melønrrai maramønrrun cha. Inchen trugurrimbunø tru ñuinukkurri amrrub misaamerabe yandø treeg melainukkurri wegørra ambuppe, purø tøga misaamera webamba amrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Trune ñibe ñui møskaløba pishindø tab israb tsumisrtrabguen cha, larrø køllizhig misra kwaben, sørøben. ");
INSERT INTO gum_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Inchen tru pimmaygatig srøig srøig misag kurrab amrrubeløbe katøle i pirautøweih amrrunrrab køn cha, kaguende truilø pumuatøbe tru amorreosmera larrø kaig marøb amrruibe ke awentamgaikkatiibe pumø srø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Inchen yandø pørr pinaiben, chab pilliraben, kan horno naguish kuchibiiba kan nag tulun pilabiiba kenamisrøbig køn. Incha truiløbe tru ushameran kweecha tab tøbøtag pirisha ambumay, imay wari utøwan puraambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tru kwaløm Jehovábe Abramba øyamay kønrrai martrab cha kørrømarabe, trenchibig køn: —Ñuinukkurri amrrub misaamerane i pirøwan na tranamig køn cha, Egipto pirau piyugurrimbunø, Eufrates tru nu pisrøngatikke: ");
INSERT INTO gum_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ceneosmeraim pirømeran køben, cenezeosmeraim pirømeran køben, cadmoneosmeraim pirømeran køben, ");
INSERT INTO gum_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","heteosmeraim pirømeran køben, ferezeosmeraim pirømeran køben, refaítasmeraim pirømeran køben, ");
INSERT INTO gum_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreosmeraim pirømeran køben, cananeosmeraim pirømeran køben, gergeseosmeraim pirømeran køben, jebuseosmeraim pirømeran købengue. ");
INSERT INTO gum_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abramwei srai Saraibe ureg tøgagønrrab kaimabig kuig køn. Inchende kan nui karuindiig megabig egipcia ishug Agar taig tøgaig kua, ");
INSERT INTO gum_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraibe Abramwane trenchibig køn: —Nane Jehovábe ureg chigaig kønrrai treeg martan cha. Inchendø tiusmanda tru namui karuindiig megabig tru Agarwan pera, ki chibig køn. Inchippa truikkurri na ureg tøgaguinabgun— cha. Inchen Abrambe Sarai taigwan mørøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Inchen Saraibe tru karuindiig megabig Egiptosrø Agarwan pera arrua, Abramwan srai lataig kønrrai tranøbig køn. Abram Canaán pirau pa trattrø pila tsuben, øyeeg purayaig køn. ");
INSERT INTO gum_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Inchen Abrambe tru Agarba kib waramisren, tru ishuube kwanrriig misra, yandø unø tøgamisrarmab isua, nun karub pera købig Saraiwane namig ashib kebibig køn. ");
INSERT INTO gum_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Incha Saraibe Abramwane trenchibig køn: —Ñigurrindø køn cha, nan mandøguen kømui isui uñchai marøbiibe. Ñune ñui srai lataig kønrrai nai karuindiig megabigwan na tranig køn cha. Incha møimbe nøbe unø tøga kønrrab køppe, nane namig ashib kebitan cha. Incha Jehová nø ashchun chibig køn, na kalø marig kuin kui, ñi kalø marig kuin kui.— ");
INSERT INTO gum_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Inchen Abrambe Saraiwane trenchibig køn: —Ñui ka karuindiig megabiibe ñuin tasku køn cha. Ñun maig marøg køben, treeg mar— chibig køn. Inchen Saraibe kaig inchib mendøben, Agarbe welula yam nebuig køn. ");
INSERT INTO gum_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Indig Jehováwei ángelbe tru mu misag waraimø pirømerasrø kan pigab menda Agarwane wetørrabig køn, Shursrømay ambi maywansrø. ");
INSERT INTO gum_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Inchabe payibig køn: —Agar, Saraiwei ka karuindiig megabig, ¿Chugurri arrugu? cha. ¿Chumay inrrab inchigu?— cha. Inchene nøbe trenchibig køn: —Nan karub pera købig Saraiwan nabe trubab welula arrur— cha. ");
INSERT INTO gum_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Inchen ángelbe trenchibig køn: —Ñui karub pera købigweimay katøle llirawa ya, tammay mur kurrashmø, nø maig chiben nui tasku treeg mørøb megau— cha. ");
INSERT INTO gum_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Incha katø ángelbe trenchibig køn: —Ñuinukkurri amrrub misaameran purø nørrø kønrrai maramønrrun cha, purø nørrø køptø mundamguengaikke.— ");
INSERT INTO gum_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Incha ángelbe katø trenchibig køn: —Ñibe kwanrriig køn cha. Ñibe kan nusrkai tøgagønrrun cha. Incha Ismael munchi pasrtrig chibig køn, kaguendø ñi larrø isui miaben, Jehovábe mørig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nøbe muguen kemalamgaig kønrrabig køn cha, kan kaambu mula-unø lataig. Incha nøbe mayeelan kwayam lanrrabig køben, katø nungurringucha mayeelø kwayam lanrrun chibig køn. Inchen nøbe nunelan, ka kwayam laptø, kwayam laptø tsunrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Incha Agarbe Jehovába wamindig køppe, nøbe nune trencha wamabig køn: —Ñibe tru nan ashib wab Tius køn— cha. Kaguen Agarbe trenchibig køn: “Øsig Wab, katø Nan Ashibigwan nabe ashar” cha. ");
INSERT INTO gum_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Incha tru pisuwane treeg wamig købig køn: “Øsig Wab, Nan Ashib Inchibigwein Pisu” cha. Inchen tru i pisube Gadesba, Beredba tøbøtagu kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Indig Agarbe Abramwei kan møg-unø tammisren, Abrambe Ismael munchi pasrøbig køn, tru unan. ");
INSERT INTO gum_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Inchen tru Agar Ismaelwan tammisrøb uras Abrambe pilamera ochenta y seis tøgaguig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram pilamera noventa y nueve tøgagøben Jehovábe kenamisra trenchibig køn: —Nabe Maramburab Marøbig Purø Nuig tru Tius kur cha. Ñibe nai merrab sølgandø, mu mandamgaig uñ cha. ");
INSERT INTO gum_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nabe ñiba øyamay kønrrai martrab cha kørrømarøb, katø ñui misaamera larrø nørrø larrøbitchai marøb indamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Inchen Abrambe maløwan pirau kebatamne utsøbasren, Tiusbe nune trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Iig køn cha, tru na ñiba øyeeg maramønrrun cha kørrømariibe, ñibe tru purø nørrø chi misag søtømeraindøgucha ñi møskain kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ñibe mas Abram munchi kømøtø, ñibe Abraham cha wamig kønrrun cha. Kaguende nabe ñune tru purø nørrø chi misag søtømeraindøgucha ñibe nømui møskain kønrrai pasrar cha. ");
INSERT INTO gum_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ñuinukkurrimbe purø nørrø misag nemisrtrai maramønrrun cha. Ñuinukkurrimbe misag søtømera nørrø køb, ñuinukkurri katø reymera køb inchun cha. ");
INSERT INTO gum_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Katø nabe, ñiba ñuinukkurri amrrub misaameraba øyeeg martrab cha kørrømaramønrrun cha, katøle srøig, srøig misag kurrab amrruimørig katø øyeeg martrab cha mara pasramønrrun chibig køn, managatig pasrønrrabig, nabe ñuimba, ñuinukkurri amrrub misaameraimba nabe pasrabig pasrøwa, managatig nømuyasig Tius kømønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ñunba, ñuinukkurri amrrub misaameranba tru ñi ka arruatiig tsuin pirøwan tranamønrrun cha, Canaán pirøwan muba kuimburab managatig tøgagønrrai. Inchen nabe pasrabig pasrøwa, managatig nømuyasig Tius kømønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Incha katø Tiusbe Abrahamwane trenchibig køn: —Tru na ñun øyeeg martrab cha kørrømarigwane ñibe, maramig køn cha, ñiba, ñuinukkurri katøle srøig, srøig kurrab amrrub misaameraba. ");
INSERT INTO gum_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Iig køn cha, tru na ñiba øyeeg martrab cha kørrømarig, katø ñiba tru wendø ñuinukkurri amrrub misaameraba. Inchen trunun maramig køben, ñimui utube mu møøtøgucha circuncidaig kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ñimbe circuncidanrrigay cha, naba, ñimba tru øyeeg martrab cha kørrømarigwan treeg marigu asamig pasrønrrai. ");
INSERT INTO gum_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Trune kwalømyube mu møguelandøgucha circuncidanrrigay cha, katøle katøle ureemera kurrab amrruimørig, ñui yau kal-laweig kui lata, kabe amrrub misaameran peniilø kui lata. ");
INSERT INTO gum_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Inchawei ñui yau kal-laweig kui lata, kabe kan anwei penig kui lata nømbe circuncidaig kønrrabelø køn cha. Inchen, tru asru siñalbe tru treeg martrab cha kørrømarigwan managatigwein køn cha eshkabig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Inchen tru circuncidamíigwane ñimui misag utugurrimbe wegutsig kønrrun chibig køn, kaguende na øyeeg martrab cha kørrømarigwan itøbunikkurri.— ");
INSERT INTO gum_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Incha katø Tiusbe Abrahamwane trenchibig køn: —Ñui sraimbe Sarai cha wamig kømøtø, yandø Sara cha wamig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nabe nune mayanguen tabig nebuig kønrrai maren, nøbe ñui kan nusrkai tøgagønrrun cha. Nabe mayanguen tabig nebuig kønrrai maren, nøbe nørrø søtø misaamerai usrin kønrrabig køben, katø nuinukkurrimbe misag søtømerai reymera werrunrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Inchen Abrahambe nui maløwan pirau kebatamne utsøbasrabe, nui manrrø umbutø intsab trenchibig køn: “¿Kan møg pilamera cien tøgaig kua, unø tøga kønrrautah? cha. ¿Katø Saragucha pilamera noventa tøgaig kua, unø tøgagømdø kønrrautah?” cha. ");
INSERT INTO gum_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Inchene Abrahambe Tiuswan trenchibig køn: —Ñi treeg martrab cha kørrømisrigu Ismael truigwane nø tøga pasrønrrai tranø— cha. ");
INSERT INTO gum_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Inchene Tiusbe trenchibig køn: —Isa kømø, Sara ñui sraimbe kan nusrkai tøgagønrrab køn cha, truigwane Isaac munchi pasrtrig cha. Nabe tru øyeeg martrab cha kørrømarigwan Isaacweinukkucha katøle treetøwei marig kørrømisrtrai indamønrrun cha. Inchawei na treeg marigwane wendø nuinukkurri amrrub misaameraba managatig tøga pasramønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Inchen Ismaelweimburabgucha nabe ñun mørar cha, nungucha mayanguen tabig nebuig kønrrai maramønrrun chibig køn. Nøgucha ureemera larrø nørrø tøgagønrrai marøb, purø nørrø misag søtø larrøbitchai marøb indamønrrun chibig køn. Ismaelbe karub ashib pønrrønrrabelø doce nørreelai møskain kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Inchendø na tru øyeeg martrab cha kørrømarigwane Isaacba kønrrai mara pasramønrrun cha, tru Sara katø pila øyan kwalømmerawan tru tøgagønrrab kui unøyu.— ");
INSERT INTO gum_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Incha Tiusbe Abrahamba chab waminchabe, nuinukkurri tarømisra ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Inchen Abrahambe nui nusrkai Ismaelwan køben, tru nui karuig mendig melabelø nui yau kal-lawarmeran køben, anwei pena tøgaguilan køben, Abrahamwei yau mu møguelø purrabelane kerriguba wama, tru kwalømdøwei circuncidabig køn, Tius maig karuig køben, treekke. ");
INSERT INTO gum_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham tru circuncidab urasbe pilamera noventa y nueve tøgaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Inchen nusrkai Ismaelbe tru circuncidab urasbe pilamera pa trattrø y pøn pilaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Inchawei tru kwalømdø Abraham køben, nui nusrkai Ismael køben, ");
INSERT INTO gum_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","mayeelø tru nui yau purrab møguelø køben, katø nui yau kal-lawar kui lata, katø amrrub misaameran peniilø kui lata, mayeeløbah circuncidaig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Incha Jehovábe Abrahamwan kenamisrøbig køn tru Mamre tainug nørrø parøndzig encinas tusrmera pønrrab pulu, tru nui carpa yau yaskabu waben kwaløm tru mas purø mur pørr asentab pasrøben. ");
INSERT INTO gum_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Incha møimbe nø kurraashene, pøngatø møguelø nuin pinrrøgue pønrraptinchen, nøbe tru møguelan amrruy chinrrab yaskabugurri luløb ya, maløwan pirau kebatamne utsøbasrabe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","—Nai kasuku, na ñui karui megabigwan ñi nan tab indamdiig kui asønaig købene, trube, ib imøtø, lincha kørrømisrtra cha. ");
INSERT INTO gum_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nabe pi srua amrrungarumønrrun cha, ñimui katsiimeran kwalamig. Trugurrimbe tusr umbu isrønrrigay cha. ");
INSERT INTO gum_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Na ñi maig chiben purugunrraptøwei wabigwei yaburab puramrrab amrruig købene, nabe lamø mamig manrrai sruaarrumønrrun chibig køn, ñimui ambamigwan chishtø ambamdø kønrrai.— Inchen nømbe trenchibelø køn: —Ñi maig taigwan mar— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Inchen Abrahambe tru Sara waig carpa yausrømay kørinatø lulabe, trenchibig køn: —Petøzhiitø purø tab harinawan arroba y media menrra, nemøra, harinawan masawa, trutøga pirrimera naarrøsryu kar— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Incha Abrahambe tru waara purrabsrømay luløb ya, kan truba tab waara-unøzhigwanh merrarrawa, nui karuig mendig megabigwan tranen, truibe mamigweyasig ¡katø! petøzhiitø tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Incha queso køben, pitsø køben, tru waara kweecha tamarigwan køben, nømun manrrai pønsrøbig køn. Incha Abrahambe nøm mab kømne tru tusr umbu ashib pasrøben, ");
INSERT INTO gum_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","truiløbe payibelø køn: —¿Ñui srai Sarabe chu wah?— cha. Inchen Abrahambe: —Yu carpa yau wainrrun— chiben, ");
INSERT INTO gum_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","kan møig køsrønbe trenchibig køn: Nabe katø pila katø øyan kwalømmerawandøwei arrumønrrun cha. ¡Au! Tru urasbe Sara ñui sraimbe kan nusrkai tøgagønrrun— chibig køn. Inchen Sarabe, nømui wendau, tru carpa yau kebambi yaskabu tru wamindigwan mørøb pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Inchen Abrahamba Sarababe yandø mur køllireelø, Sarabe yandø pabøguen pinig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Inchen Sarabe intsaptinchibig køn, nui umbutø treeg isub: “¡Paare! kan na yan kølliibe, ke trengatikkucha kønrrai indamdiig kønrraitarru cha katø nai kekkucha yan kølligwein køben.” ");
INSERT INTO gum_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Inchene Jehovábe Abrahamwane trenchibig køn: —Sarabe trenchib intsan cha, ¿Kan isa kømø, treeg kønrrab kø chinder? chib. ‘Na yan køllig købendø, kan unø tøgagømig.’ ");
INSERT INTO gum_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Kabe Jehováweingan kaimamdiig chi købig kuitarru? cha. Inchawei katø pila arrubigu tru chu ura treeg kønrrun taiguh, na katø ashchab arrubene, tru urasbe Sarabe kan nusrkai tøgaguen wanrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Inchen Sarabe kwaarøppa, trenchib isabig køn: —Nabe intsømuig køn— cha. Inchene Jehovábe trenchibig køn: —Ñibe intsabwei indig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Incha tru møgueløbe kurra, Sodomaguebsrø ashabe yandø truguebsrø ambub mendøben, Abrahambe ungua chinrrab nømba lincha ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Inchen Jehovábe nuinøtø treeg isubig køn: “¿Na chi martrab indigwan nagan Abrahamwan eshkamø maramuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Nøbe purø nørrø misag søtømera, trurrigu mu chindamgaig murig, katø nøgurri chi misaameratøgucha pirø muba kuimburab warabeløbe mayanguen tabig nebuilø treeg kønrrab køben. ");
INSERT INTO gum_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nabe nui ureemeranba nuinukkurri amrrub misaameranba kusrennrrai wesrawa pasrar cha, tru nø martrai karua pønsraillan møra marøppe, tru tabig sølgandø mariguba, nø tabig kui asamig mariguba kønrrain cha, tru øyeeg mariiløgurri Abrahamwan Jehova maig martrab cha kørrømariibe kerrigu treeg nebunrrai”. ");
INSERT INTO gum_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Incha Jehovábe Abrahamwan trenchibig køn: —Sodomaimburappa, Gomorraimburappa, truyu misaamera yeeg kaig martan chib trashib eshkab melaibe masken, masken køben, nømui kaig mariiløgucha masken, masken nuraben, purø trømbøig mindin køn cha. ");
INSERT INTO gum_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Møimbe na kørraarrumønrrun cha, tru nøm øyeeg, øyeeg køtan chib trashib melaig nainug pubig isa kømøtø, treeg købwei indiitashchab. Treeg kuin kuisruandøbe, trube, na asamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Inchen tru pailø møgueløbe nøørø misra, Sodomaguebsrø amben, trune Abrahambe Jehovába pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Inchen Abrahambe Jehováwan kemallabe, trencha payibig køn: —¿Sølgandø tabig marøbigwanba, kaig marøbigwanba tøgatø pinishinrrapteh?— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Inchippa tru ciudayu sølgandø tabigwan marøbelø cincuenta købene, ¿tru ciudawan ka pinishinrrapteh? cha, tru ciudayu sølgandø tabigwan marøbelø tru cincuenteeløgurri ciudawan pinishimø, ¿ka købasamdiig kømuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Treekkatig maramibe chigaaguinrrun cha, tabigwanba, kaigwanba kanbalatø kwanrrai indamig, kan pailøba treetø kalø marig kui lataig. ¡Ñibe mana treeg martrab kø! cha. Pirau muba kuimburab kerriguba maig kønrrabigwan ñi asha marøbig køppe, ¿ñibe maig maramigwan sølgandø tab asha marmønrraitirru?— cha ");
INSERT INTO gum_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Inchene Jehovábe trencha løtabig køn: —Sodoma ciudayu cincuenta sølgandø tabigwan marøbelø wetørrappe, truilan isua, truyube chinchimø, kagøbasamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Inchene Abrahambe trenchibig køn: —Nabe nai Señorwan ke menrra inchib lata indinatan cha, nabe ka usrø tuindø kuinabendø. ");
INSERT INTO gum_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Inchen cuarenta y cincotø købene, trube cincuenta kømuikkurrindø ciudawan kerrigu pinishinrrapteh?— cha. Inchene Jehovábe trenchibig køn: —Pinishimumønrrun cha, truyu na cuarenta y cinco sølgandø tabigwan marøbelø wetørrappe.— ");
INSERT INTO gum_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Inchen Abrahambe katøgucha: —¿Inchippa cuarenta wetørrappe?— chiben, Jehovábe trenchibig køn: —Tru cuarenteelan isua, chinchimumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Inchen Abrahambe katøgucha payibig køn: —Nai Señor, na øyeeg chiben namømørrunrrig cha. ¿Inchippa truyu treinta wetørrabeneh?— cha. —Tru treinteelan isua, kagøbasamønrrun— chibig køn Jehovábe. ");
INSERT INTO gum_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Inchen Abrahambe katøgucha: —Nabe nai Señorwan ke menrra indinatan cha, ¿truyu veinte wetørraimbe maig købsruerah?— chiben, —Veinteelan isua, nabe pinishimumønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Incha katøle Abrahambe trenchibig køn: —¡Nai Señor, nan namømørrunrrig cha, i piejindøh na ñun katølø trenchibashibsrumuguh cha: ¿Inchippa truyu pa trattrø wetørraimbeh?— cha. Inchene Jehovábe trenchibig køn: —Tru pa trattrøn isuptø, pinishimumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Incha Jehovábe Abrahamba øyeegwan chab waminchabe, yandø truyugurri iben, Abrahambe nui carpa yaumay katø arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Incha tru pagatø angelesmerabe tru Sodomasrømbe nøsig pineb iben, pubene, Lotbe tru Sodoma ciudayu kebambi yaskabsrø wabig køn. Incha Lotbe truilan ashippe, amrruy chinrrab pasramisrøptincha, maløwan pirausrø kebatamnegatig utsøbasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Inchabe trenchibig køn: —Nai kasukumera, na ñui karui megabigwei yausrø kørrømisrtrab amrrurray cha. Incha ñimui katsiimeran kwallchigay cha. Incha srønabe løtsø kurra ñimui ambamigwan amrrigay— cha. Inchen nømbe trenchibelø køn: —Kah cha, møi yembe nambe yu umbu puinuutø, ka kørrømisrtrab ker— cha. ");
INSERT INTO gum_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Inchen Lotbe truba truba inchen, nømbe nøba amba, nui yau kebamben, nøbe tab mamiimera tamarøb, pirri chi levaduragailø karøb inchen, nømbe mabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Inchen nømbe kinrrabguen waramisrmøwatø, tru ciudayu møgueløbe yawan kerrigu chab tulsrubelø køn, maya misag matsøreløgurrimbunø kølleeløgatikke. ");
INSERT INTO gum_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Incha Lotwane trenchib trashibelø køn: —Tru ñui yau kinrrab amrrub møgueløbe chu purra? chib. ¡Wambig webetay! chib. Nambe nømba ishumburmeraba lataitøwei marøg kuin pønrrer— chib. ");
INSERT INTO gum_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Inchen Lotbe wambig webya, yaskabwan kasrøb trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","—Nai misaamera, tiusmanda øyeekkatig trømbøgøliibe martrab inchimøtay cha. ");
INSERT INTO gum_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nabe pagatø nimbasrmera tøgaig kur cha, managuen kan mu møøba kimeelø. Nabe truilane wertrur chibig køn, ñim truilan maig marøg køben martrigay cha. I møguelane chigucha treebe marmørrunrrigay chibig køn. Kaguende truiløbe nai yaambu mugøben kaig martrab inchib kønrrain kømøtø, na ashib tøgaguilø purran— cha. ");
INSERT INTO gum_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Inchene nømbe trenchib løtabelø køn: —¡Yugurrimbe mendatsu!— cha. Inchabe treekkucha chibelø køn: —Ya peesriig namui utu ka tsunrrab arruatiig købendø, ¡paare! ¿namune maig maramigwan ke ñi asha karunrrab indirru? cha. Møimbe truilan lataguen kømø, ñune purø trømbøikken martrumøn— chibelø køn. Inchabe Lotwan melambua, yaskabsrø kemalla, yaskabwan wesra kutchab inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Inchen tru pailø møgueløbe yaambugurri taska kemørøppa Lotwane yaambumay kesrub, trugurrimbe yaskabwan kasrøptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Incha tru møgueløbe tru yau yaskabu melambub amrrubelane kammeran ashmeelø misrtrai marøptinchibelø køn, mas unøtiigwangurrimbunø kølliwangatikke. Inchen nømbe yaskab lab ke mandøguen kømui inchib købig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Incha tru møguelø kørrømisrøbeløbe Lotwan trenchibelø køn: —¿Ñigan ñui yauelø mas tøgagøtirru? cha. Ñui yernomeran køben, ñui nusrkalan køben, ñui nimbasrmeran køben, yugurri wesru chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Kaguende nambe i ciudawan kerrigu pinisamig køn cha. Tru katøgan misaamera yeeg kaig martan chib trashib eshkab melaibe Jehová nø waisrø puin køn cha. Inchagurri Jehovábe namune ciudawan pinishinrrai ørig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Inchen Lotbe tru nui yerno kønrrabeløba waminchab webibig køn, tru nui nimbasrmeran kasharanrrab misrarmera købeløba. Incha trenchibig køn: —¡Mallatø webambay! cha, kaguen Jehovábe i ciudawan pinishinrrab køn— cha. Trune nui yerno kønrrabeløbe ka intsab trendaitamaptøh isubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Inchen yandø tør— rrab arruben, ángelesmerabe Lotwan mallatø indingarub, trenchibelø køn: —¡Mallatø inchi chiben! cha. Ñui srawanba, ñui pagatø nimbasrmeranba yu purrabelan pera inrrø chibig køn, ciudayu trømbøig nebunrrai marigu ñim pinømønrrappe.— ");
INSERT INTO gum_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Inchen Lotbe ke peguen inchimuben, tru pagatø møgueløbe nunba, nui srawanba, nui pagatø nimbasrmeranba tasku kemøra, nømune ciudayugurri wambiisrø wesrubelø køn, Jehováwei lastima asiitøga. ");
INSERT INTO gum_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Incha yandø ciudayugurri wambiisrø wesrawa pasrabe, kane trenchibig køn: —¡Ñui øsig kuigwan ñi tøgønrrappe, welula inrrø! cha, wendømay keshmøwei, i chagu chu pasramisrmøweingue. Ñui øsig kuigwan tøgagønrrab tunsrømay lul cha, pinømønrrappe.— ");
INSERT INTO gum_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Inchene Lotbe trenchibig køn: —Kah, cha nai kasuku na ñim maig taigwan megabig tiusmanda, treebe kaimamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nabe ñimuin kabyu tab kui asig kuinaig købene, nai øsig kuigwan na tøgagømig kønrrai ñimbe nane purø nu lastima asig køn cha. Inchendø nabe tunsrømaybe lulrrab kaimamønrrun chibig køn, inchippa na trusrø pumuatø kaig attrabig nan wetøgøben, kwamig kømønrrai. ");
INSERT INTO gum_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yu puluwandø kan lamø ciudagøllig køn cha, trusrømaybe lulamønrrun chibig køn nabe. Trusrømay ibashcha cha, pøs, truibe lamø ciudagøllig kømuitarru cha— truyu na øsig kømigwan ka tøgagømig kønrrai.— ");
INSERT INTO gum_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Inchen trenchibig køn: —Ñi øyeeg miaigwangucha nabe mørar cha. Tru ñi wamindi ciudawane nabe pinishimumønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Trube, øsig kug købene, mallatø trusrømay lul chibig køn. Kaguende ñi trusrø pumuatøbe, nabe chigucha martrab kaimamønrrun— cha. (Inchagurri tru ciudawane Zoar cha wamig kuig køn.) ");
INSERT INTO gum_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Inchen Lotbe Zoarsrø pubene, yandø pørrbe neeshib arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Inchen yandø Jehovábe srømbalasrøngurri azufreba, naaba sre pubig ørøbig køn Sodomaimbalaba, Gomorraimbalaba. ");
INSERT INTO gum_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Incha tru ciudameranba, katø truyu warab misaameranba, tru chaameranba, katø tru pirau chi kal-lawa pønrrabelanbañau chishtøh pinisaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Inchen Lotwei sraimbe møimbe wendømay keeshenba, nøbe maig kuimaytiig tre srug misra pasrambuig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Katø kwaløm Abrahambe løtsø kurra Jehovába tru nø waminchib pasraisrømay ya, ");
INSERT INTO gum_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodomaba, Gomorraba katø trusrø muba chag kuimburab truguebsrø ashene, naguishbe kan nu tra pachib lataig piraugurrimbe kurrab pasraptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Øyamay tru muba chag kuimburab ciudameran Tiusbe pinisaig køn. Inchendø Tiusbe Abrahamwane isua tøga pasrøwa, tru Lot tsuig ciudameran purø trømbøig pinishib arrubigugurri Lotwane wesraig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Inchen Lotwane Zoarsrø kørrømisra tsumibe kørig køben, nui pagatø nimbasrmeraba tunmera tøga pirømerasrø tsunrrab ya, nømbe pøneløba kan peña trab pasrabyu warønrrab kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Indiibe kan kwaløm køli nimbasrbe tru wendø numøsrawane trenchibig køn: —Namui møskaimbe yandø kølliizhig køben, yu nam warainuube namba kasharanrrabelø muguen møgueløbe kaagøn cha, yu piraube mutøgucha trendø treeg kasharamig købig købene. ");
INSERT INTO gum_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Namui møskawan vino mutsøsra mutsiirana, nøba kigun cha, trumay namui møskaweinukkurri amrrub misaamera tøgagømig kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Incha tru yem møskawan mutsiirana, køli nimbasrbe kebya, møskaimba kibig køn. Inchen møskaimbe nune kinrrab tsumisren, mørmøwei, ni katø kurra iben mørmøwei indin købig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Incha katø kwalømbe tru køli numøsraimbe wendø numøsrawane trenchibig køn: —Nabe marig yem nai møskaimba kiaig køn cha, katø møi yemgucha mutsiirana, møimbe ñi kebya kinrrig cha, trumay nam namui møskaweinukkurri amrrub misaamera tøgagømig kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Incha tru yem katø møskawan vino mutsøsra mutsiirana, wendiibe kurra, katø møskaimba kibig køn. Inchen møskaimbe chu uras nøba kinrrab tsumisri mørmøwei, ni chu uras kurra, yai mørmøwei inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Incha Lotwei pa mimbasrmerabe pailøba møskawei kwanrreelø kørrømisra, ");
INSERT INTO gum_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","køli nimbasrbe kan nusrkai tøgamisra, truigwane Moab munchi pasrig køn. Treekkurri truibe møi ya moabitasmerai møskain køn. ");
INSERT INTO gum_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Inchen wendiikkucha kan nusrkai tøgamisra, truigwane Ben-ammi munchi pasrøbig køn. Inchen truibe tru møi ya amonitasmerai møskain køn. ");
INSERT INTO gum_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Incha Abrahambe tru nø tsuinukkurri Neguev pirausrømay ya, truibe Gadesba tru Shur ciudameraba pønrrabnug tru utu kørrømisrøbig køn. Incha tru Gerarsrømbe ka purainrrab arrubig lataitø tsuabe, ");
INSERT INTO gum_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","trusrømbe tru nui srai Sarane, “naimbe nøbe nuchag køn” chibig køn. Inchen Abimélec tru Gerarsrø reybe Sarane wamønrrab øra, nui srain kønrrai isua kørrømarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Inchen tru yem Abimélecbe kan piaig tøgaguiyu Tiusbe arrua, nune trenchibig køn: —Ñibe kwanrrabguen cha, kaguende ñi ñui srain kønrrai ñi kørrømari ishuube kasharaweig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Inchendø tru Abimélecbe tru ishuwane pera kib chi marmuig kua, nøbe trenchibig køn: —Señor, ¿chi kalø marmíigwangucha ñigan kwetchab indirru? cha. ");
INSERT INTO gum_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Yamba Abraham nøtøwei ¿øyah chimuig kuitarru? cha: “Naimbe nøbe nuchag køn” cha. Inchen katø ishug misakkucha: “Naimbe nuchagwein køn” cha trendaig køn cha. Nabe nai manrrø umbugurri chi kaig isua kømøtø, nai tasiimeran chishig tøga pasrab, iigwan øyeeg marig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Inchen Tiusbe piaigu trenchibig køn: —Nagucha asha pasrar cha, ñui manrrø umbugurri tabig isua marigwan. Incha nabe ñi nan kalø marmønrrai na ñun kebachibashmuig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Inchawei ñi katøle nui keeba inrrai ibashmuisruandøbe ñibe isa kømø, kwanrrabguen cha, ñui yau mutø purrabelø køben truiløbañau. Kaguendø nøbe Tius maig karuigwan eshkabig køn cha. Incha ñi øsig kønrrai ñuimburø purøwaminchun cha— ");
INSERT INTO gum_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Indig katø løtsøbe Abimélecbe løtsø kurra, nui tru karub peraguilan wama, truilan mayeelan nun chi purayaigwan kerriguh eshkabig køn. Inchen tru møgueløbe purø kørrø kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Inchen Abimélecbe Abrahamwan wama, trenchibig køn: —¿Ñibe namune chi mara pasrøgu? cha. ¿Pøs, nabe ñune chiyu kalø marta? cha. Ñibe naimbalaba, na misagwan karub tøga waimbalaba purø trømbøig kalø maringarubsrutan cha. Ñibe nane chi maraamíig mara pasrtan cha.— ");
INSERT INTO gum_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Incha katø Abimélecbe Abrahamwane trenchibig køn: —¿Chi isuarre ñibe øyeeg marig kø?— cha. ");
INSERT INTO gum_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Inchen Abrahambe trenchibig køn: —Nabe nainetø treeg isuig køn cha: “Yusrømbe Tiuswan kørig tøgar muguen kaagua, nai srawan nømui mara kørrømarøkkøptø nane kwetchaitamab”. ");
INSERT INTO gum_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Inchendø chiwei isamø chibig køn: “nøbe naimbe nuchagwein køn” cha. Nai møskaweimbe nøbe nimbasrwein køn cha, usrimbe katøgan usrin kuindøgucha. Inchagurri nabe nune nai srain kønrrai marig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Nai møskawei yaugurri nan Tius ka truørøtø, truørøtø uñchai nan webingarub uras nabe Sarane trendaig køn cha: Na ñui keg kuitamab isua ñi tøga pasrøwabe trube, øyeeg chirrunrrig cha. Nam chu pub ambiisrøndøgucha ñibe øyah chirrunrrig cha, ‘ñibe nai nuchag kur’”— cha. ");
INSERT INTO gum_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Inchen Abimelecbe Abrahamwane ubishamera køben, waaramera køben, katø nui karuig mendig melab møguelan køben, ishumburmeran køben tranøbig køn. Incha katøle nui srai Sarangucha tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Incha Abimelecbe trenchibig køn: —Nai pirømerabe kerriguba ñui merrab pasran cha, ñun katøguchi tab tsumdønug, truyu kørrømisra tsu— cha. ");
INSERT INTO gum_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Incha Sarane trenchibig køn: —Nabe ñui nuchawane tsantsøn anmera mil tranar cha, tru anbe øyeeg purayaigwan truburø trani an køn cha, truibe ñi chi kalø marmíig kuin kui ashchai maya misagwei malau kenamarig kønrrain cha. Trumaybe ñune mugucha kaig waminchippe kønrraamøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Inchen Abrahambe Tiusba waminchen, Tiusbe Abimelecwanba, nui srawanba trugurri nui karuig mendig melab ishumburmeranba ureg tøgagønrrai tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kaguende Jehovábe Abrahamwei srai tru Saran øyeeg puraiben Abimelecwei yauelane ureg chigaanrrai mayeelai matrizwan kasraig kua. ");
INSERT INTO gum_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nø maig taig købigwan trumay martrab Jehovábe Saran ashchab arrua, nune tru maig trannrrab kørømisrigwan treeg marig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Inchen Sarabe kwanrriig kørrømisra, Abraham kølli misagwei kan nusrkai tøgaguig køn. Tius tru mana tøgagønrrun taig tru uraske. ");
INSERT INTO gum_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Inchen tru Sara tøgaguig unø tru møg-unø kal-labigwane Abrahambe Isaac munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Incha Abrahambe tru nui nusrkai Isaacwan trattrø y pøn kwalømyu circuncidaig køn, Tius maig karuig køben, treekke. ");
INSERT INTO gum_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nui nusrkai Isaac kal-laben, Abrahambe pilamera cien tøgaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Incha Sarabe trenchibig køn: “Tiusbe nane ka intsøg kønrrai marig køn cha. Møikkøben na unø tøgaguin kui wammørøbeløbe naba ketøtø intsønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Abrahamwane mugui trenchinrrautah cha, Sara ureg mutsøsrønrrun? chabe. Inchen køben, Abraham ya køllig køben nabe kan nusrkai tranar” chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Inchen Isaacbe nurab iben, yandø pitsø kuchen, tru pitsø kuchib kwalømbe Abrahambe larrø tab mamiimera tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Inchen Sara ashene, møimbe tru Egiptosrø Agarwei nusrkai tru Abrahamba tøgaguig unø Ismaelbe, nui nusrkai Isaacwane ke ka intsatø ashen, ");
INSERT INTO gum_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sarabe Abrahamwane trenchibig køn: —Ñui tru karuindiig megab ishuwane nui nusrkawanba yugurri weguchi cha, kaguende tru ka karuindiig megab ishuwei nusrkaimbe nai nusrkai Isaacbabe chi tøgaguigwan keta tranamigube tøgatø ashchabig kømøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Inchen øyeeg wammerabe Abrahamwane purø murig pubig køn, kaguen nui trag unan øyeeg nebuben. ");
INSERT INTO gum_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Treeg kuindøgucha Tiusbe Abrahamwane trenchibig køn: —Ñui karuindiig megab ishuweimburab lata unaimburab lata chi isumøta cha. Sara nø maig taigwan kerriguba ka møra, trunun treeg ka mar cha, kaguende ñuinukkurri amrrunrrab misaamerabe Isaackurri kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Inchen tru ñui karuindiig megabigwei nusrkaweinukkurringucha truba truba nørrø søtø misaamera kønrrai nabe treeg maramønrrun cha, kaguende ñuinukkurri arrubig kuimba.— ");
INSERT INTO gum_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Indig katø kwalømbe Abrahambe løtsøzhig kurra, Agarwane pirrin køben, pi niguin kalusyu pi køben trana, kildunyu mutøsra, Ismaelwane yandø ñi ashchig cha nun tranabe, ka amrrigay chibig køn. Inchen nøbe webya ya, Beerseba tru mu misag warab waraimøsrø chu pumikkaig llirab uñibig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Inchen tru kalusyu niguin pibe patsaptinchen, unane kan lamø tusr umbusrø wanna, ");
INSERT INTO gum_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","usrimbe truyugurri kan maya yabgøsrøn ashib wanrrab tarømisrøbig køn. Kaguende nøbe treeg isubig køn: “Nai unan kwai ashig kømøtan” cha. Inchen usri wamisren, unøbe trashib kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Inchen Tiusbe unø trashib kisigwan møren, Tiuswei ángelbe Agarwan srømbalasrøngurri wama trenchibig køn: —¿Agar, chinnda? cha. Chi kørig isumøta cha. Kaguende unø nø wainukkurri kisigwan Tiusbe mørin køn cha. ");
INSERT INTO gum_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kurra ya, unan tasku kemøra, srua pasramisr cha, kaguende nabe nuinukkurri misaamera purø nørrø søtø kønrrai maramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Inchen tru uras Tiusbe Agarwan kammeran kurøptinchen, nøbe kan pisu waig ashiptinchibig køn. Inchen Agarbe tru pi niguin kalusyu pi netsøgana, unan pizhig srørrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Inchen Tiusbe unan lincha pasrøben, unøbe nurab ya, mu misag warab waraimøsrø tsua, nøbe arcotøga søl øramibe kan piaig lataig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Incha nøbe Paran tru mu misag warab waraimø pirausrø tsubig kuig køn. Inchen usrimbe nune kan Egipto pirausrø ishuuba kasharanig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Tru kwalømmerawandøwei Abimelecba katø tru nui suldaumeran nø asha karubig Ficolba Abrahamwan trenchibelø køn: —Ñi chi marøb arrigutøgucha Tiusbe ñiba pasran cha. ");
INSERT INTO gum_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Incha møi yutøwei ñibe Tiusken ashen ¡katø! nabe treeg marmø kømø, maramønrrun taitøga kalø marmørrumøn chirra chibelø køn, tru nan lata, nai nusrkawan lata, nainukkurri amrrub misaameran lata. Incha ¡katø! treeg maramønrrun chirra chibig køn nanba, møi ñi yu tsuim pirau misaameranba tru purainrrab arruatiigwan utabelan tab inchib tøgagørrunrrig cha, tru ñun mandø tab indig køben tru tab indiitøga treetøwei tab inchib.— ");
INSERT INTO gum_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Inchen Abrahambe trenchibig køn: —¡Katø! nabe treeg marmø kømø, maramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Inchendø Abrahambe Abimelecwane ‘ñibe nane øyeeg kalø marig køn’ cha trunun wesrabig køn, tru Abimelecwei karuig mendig melabelø Abraham tru pirø umbugurri pi wesraizhig købigwan nun kerraigwan. ");
INSERT INTO gum_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Inchen Abimelecbe trenchibig køn: —Nabe øyeegwane murreendi mørmur cha. Katø ñigucha nan wammørøsrømøwei inchene, nabe møinguen wammørøb pasrar— cha. ");
INSERT INTO gum_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Inchen Abrahambe ubishamera køben waaramera køben srua arrua, Abimelecwan tranøbig køn. Incha ambugurri, igurri øyamay kønrrab cha wamincha kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Inchen Abrahambe nui ubisha søtømerayugurri ishug ubisha-ureezheelø trattrø y par, nuingui tarømarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Inchene Abimelecbe trencha payibig køn: —Iig tru ishug ubisha-ureezheelø trattrø y par tru ñi nuingui tarømariiløbe ¿maig punrrabigwan eshkabig køh?— cha. ");
INSERT INTO gum_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Inchen Abrahambe trenchibig køn: —Tru iig ishug ubisha-ureezheelø trattrø y par iilan na ñun tranen, ñi utiibe tru pirø umbugurri pizhigwane na lalla wesraig købigwan trunun eshkab pasrønrrabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Incha treekkurri trusrømbe Beerseba cha wamig køn, kaguende tru pa møguelø truyu ambugurri, igurri øyamay kønrrab cha wamincha kørrømisrig kua. ");
INSERT INTO gum_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Incha øyamay kønrrab cha kørrømisrøbelø køn tru Beersebasrø. Incha Abimelecba katø tru suldaumeran nø asha karubig Ficolba katø filisteosmerai pirøsrømay katø ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Incha Abrahambe tru Beersebasrø kan tamarisco tusr ellguawa pasrabe, Jehová, tru Managurri Managatig Wabigwei munchiwan isub wamabig køn. ");
INSERT INTO gum_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Incha Abrahambe filisteosmeraim pirausrø purø yana tsuig køn. ");
INSERT INTO gum_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Inchen kan maya yanagøsrøn puraiben, Tiusbe Abrahamwane nui isubigwan Tiusweinug tøga pasraibe maig køtashchab ashchab marøbig køn. Incha Abrahamwan trenchibig køn: —Abraham— cha. Inchen nøbe: —Yu pasrar— chiben, ");
INSERT INTO gum_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tiusbe trenchibig køn: —Møimbe ñui kandø nusrkai ñi truba undaaraigwan pera, Moriah pirausrømay ya, truyu kweecha, nan keta trannrra chibig køn. Kan tunyu maramigwan na eshkarrumøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Inchen Abrahambe katø kwalømbe løtsøzhig kurra, nui burrun tsølig pasra, trugurrimbe tru kweecha parramigweyasig trar para, nui karuig mendig melabelø pailanba nui nusrkai Isaacwanba pera, Tius chumay inrrain taisrømay ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Incha pøn kwalømyube Abrahambe kurraashabe yabgurrindø trusrø nebua ashibig køn. ");
INSERT INTO gum_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Inchabe tru nui karub pera kuilane trenchibig køn: —Ñimbe yutø burrun srua muniiranrrigay cha. Nabe unøbatø trusrøngatig amba, Tiuswan tabig waminchib kua, katøle ñimuimay amrrumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Incha Abrahambe tru kweetsigwan kerrigu parram trarwan tamara, nui nusrkai Isaacwan niisra, nøbe nagwanba, kuchillunba nemøra srua, pailøba ambub mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Inchabe Isaacbe nui møskai Abrahamwane: —Papá— chiben, møskaimbe: —Nai nusrkai ¿chi chinrrab inchigu?— chiben, Isaacbe trenchibig køn: —Nambe nagwanba, trarwanbabe tøgaguer cha. Inchendø tru kweecha keta tranam ubisha unøbe ¿chu pasrah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Inchene Abrahambe trenchibig køn: —Nai nusrkainzhig, tru keta tranam ubisha unane Tius nø ashchab kuinrrun— cha. Incha pailøba ambub købelø køn. ");
INSERT INTO gum_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Incha Tius tru chu taisrø puabe, Abrahambe kan altar kusrua, tru pala trarwan tamara wara, nui nusrkawan lusra, tru pala trarrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Incha Abrahambe nui nusrkawan kwetchab kuchillun srua kwalwan kusrubene, ");
INSERT INTO gum_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","møimbe Jehováwei kan ángel srømbalasrøngurri wamaptinchibig køn: —¡Abraham! ¡Abraham!— chib. Inchen nøbe: —Yu pasrar— chiben, ");
INSERT INTO gum_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ángelbe trenchibig køn: —Ñui tasigwan ñui nusrkaweimbala kusramøta cha. Chigucha marmøta cha. Ñibe Tiuswane kørig tøgaig maig købash inchimíig kui ashar cha, kaguende ñui nusrkai kandiigwan treebe marøg kømøtan chimøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Incha Abraham ashene, nui wendaube kan carnero srar kwaliimerayu iløsrka megaptinchibig køn. Inchen Abrahambe tru carneron kemøra nui nusrkawaimburø, kweecha, kerrigu parrøb Tiuswan keta tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Incha Abrahambe truyube “Jehová Chi Palabigwane Nø Ashibig Køn” cha munchi pasra wamig køn. Incha møin kwalømgatig trenchibelø køn: “Tru tunyube chi palabigwane Tius nø ashchun” cha. ");
INSERT INTO gum_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Incha Jehováwei ángel srømbalasrøngurri Abrahamwan katøle wama, ");
INSERT INTO gum_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","trenchibig køn: —Na Jehovábe mui katøganwei merrab kømø, nabe naasiitø marig kørrømisrtrai maramønrrun chib pasrar cha. Kaguende ñibe øyeeg maran cha, ñui kandø nusrkawan øyeebe marøkkømøtan chib, nan trenchib pasrømøtø. ");
INSERT INTO gum_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Inchawei nabe ñune mayanguen tabig nebuig kønrrai tranamønrrun cha. Ñuinukkurri amrrub misaamerane purø nørrø kønrrai maramønrrun cha, srømbalasrø kønchabiimera pønrrabig lataig, mar menda pisrum lataig kønrrai nørrø køptø. Ñuinukkurri amrrub misaamerabe nømun ashig kømui inchibelai ciudameran nøm merrarrawa tøga pønrramisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ñui yellyu misaameragurri chu pirausrøn køben misaamera nørrø søtø warabeløbe mayanguen tabig nebuig kønrrun chibig køn, nai wamwan ñi mørikkurri.— ");
INSERT INTO gum_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Incha Abrahambe tru pailø nui karui melabelø munig kørrømisrøbelaisrømay katø ibig køn. Incha trugurrimbe ketøtø lincha Beersebasrømay ambubelø køn. Incha Abrahambe yandø trusrø tsumisrig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Indig wendøsrø Abrahamwane treeg wam pubig køn: “Tru nui nuneg Nacorwei srai Milcabe nusrkalø tøgagøn cha. ");
INSERT INTO gum_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ke srøsrø tøgagui nusrkaimbe Uz køben, tru wendaube Buz køben, trugurrimbe Kemuel køben købig køn. ");
INSERT INTO gum_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Tru wendau kal-labeløbe Hazo køben, Pildas køben, Jidlaf køben, Betuel købengue. ");
INSERT INTO gum_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Inchen tru Betuelbe Rebecai møskain købig køn. Iilø køn Abrahamwei nuneg tru Nacorwei srai Milca tøgaguig nusrkalø trattrø y pøngatøba. ");
INSERT INTO gum_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Katø Nacorbe nui linchaig Reumába nusrkalø tøgaguig købig køn. Truiløbe Teba taig køben, Gaham taig køben, Tahas taig køben, Maaca taig køben kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarabe pilamera cientoveintisiete tøgaig tsua, ");
INSERT INTO gum_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Canaan pirau Hebrón ciudayu Quiriat Arbasrø kwaig købig køn. Incha nøbe Sara kwaben kisha, truba isuin kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Incha Abrahambe tru kwabig tsunukkurri webya ya, truyu hititasmeran trenchib waminchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Nabe ñimui utube ka peesrøngurri arruatiig kuinaindøgucha, nai srawan søramigweyasig yanrra— chib. ");
INSERT INTO gum_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Inchen hititasmerabe trenchibelø køn: ");
INSERT INTO gum_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—Tiusmanda namui kølli misag namun mørtra cha: Ñibe namui utube chi maramigwan ñi asha karubig kønrrai Tius wesra pasrig møg køn cha. Ñui srawane namuyasig purø tabig tamarig pønrrabigu sørø chibelø køn. Namui utube møikkucha ñui srawan tru søra tramigwane ka chimønrrun— cha ");
INSERT INTO gum_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Inchen Abrahambe kurra pasramisra, hititasmerai merrab utsøbasrøptinchabe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","—Nai kwabigwan na yu sørønrrai ñimun tabig asønabene, Zoharwei nusrkai Efrónwan tiusmanda naimburø wamincha kettray cha, ");
INSERT INTO gum_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","tru Macpela tain pirau linderomerayu søramig srug trab lalig pasrabigwan nan yanrrai. Mayaweyig kønrraptiig køben treezhigwan ñim mayeelø ashen anwan na wartrab tan chirrunrrigay cha, trumay nai yau misaameran søramig tøgagønrrab— cha. ");
INSERT INTO gum_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Inchen tru Efrón hititabe nui misag utu wawabe, truilø mørøb, katø tru nui ciudayu yaskabwan mayeelø kebambubelø mørøb inchai Abrahamwane trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—Nai kølli misag, tiusmanda, pirøwane ka kettrumøn cha, katø tru søramig srug trab lalig tru pirau pasrabigwanba. Nai misaamerabe nømbe asha kørrømisran cha. Na pirøwane ñune ketig køben, ñui srawane ka sørø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Inchen Abrahambe tru pirau maya misagwei merrab utsøbasra, ");
INSERT INTO gum_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","truyu warab misaamerai merrab tru Efronwan Abrahambe trenchibig køn: —Ñi pirøwan nan yanrrab isuppe, tiusmanda mørtra cha. Tru pirø mayaweyig køn, chiben, nabe treegwan anwan wartrumøn cha. Trumay kørrømisrtra cha, treebe si, nai srawan na truyu søramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Inchene Efrónbe Abrahamwane trenchibig køn: —Nai kølli--misag tiusmanda mørtra cha. ");
INSERT INTO gum_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Pirøbe tsandzøn an cuatrocientosweyig køn cha. Inchendø anwan isumøtø tru kwabigwan ka sørø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Inchen Abrahambe tru Efrón trendaigwan trumay kørrømisra, Efrón mayaweyig køn cha eshkaigwan tru hititasmerai merrab Abrahambe cuatrocientos tsantsøn anwan møi, møi unaashibig køn, tru penab, yanøb inchibelø maig marøbelø køben treetøweingue. ");
INSERT INTO gum_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Inchawei tru Efrónweim pirø tru Mamre taisrø pørr neeshibgatømay Macpela taisrø pasrab pirøbe, tru søramig tru srug trab lalig lata, tru pirau pønrrab tusrmera lata, ");
INSERT INTO gum_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","yandø Abrahamwei kørrømisrig køn, tru hititasmeraba, katø tru ciudayu yaskabwan kebambubeløba ashen. ");
INSERT INTO gum_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Incha trugurri Abrahambe nui srai Saran tru Mamre pørr neeshibgatømay Macpela tain pirau søramig tru srug trab lalig pasrabigu sørabig køn, tru Hebron Canaán pirausrø. ");
INSERT INTO gum_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Inchawei tru pirøba tru sørig srug trab laliibabe yandø Abrahamweyasig yandø mu kønøgamgaig kørrømisrig køn, truibe tru hititasmera Abrahamwan yanig sørab tøgagønrrai. ");
INSERT INTO gum_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Yandø Abrahambe kølliizhig pilameragucha tsabøtø tøgaig, chiyutøgucha Jehová mayanguen tabig nebuig kønrrai tranigwan tøgaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Incha kan piji Abrahambe tru nui karuig mendig megabig ke managurri peraguig nui chi købigwan nø asha marøb pasrabigwan wamabe, trenchibig køn: —Ñui tasigwan nai srøptsim umbu estsartra cha. ");
INSERT INTO gum_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Incha tru srømbalameranba, pirøwanba nø ashib pasrab Tiuswei merrab ¡katø! treegwan marmø kømø, nabe maramønrrun chirra chibig køn. Yu Canaán pirau na tsuinug ishuwan nai nusrkaweyasig srain kønrrai lab pasramig kømønrrain cha. ");
INSERT INTO gum_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Treeg kømøtø, naim pirausrømay nai yau misaameraimay irrunrrig cha, nai nusrkai Isaácweyasig srain kønrrabigwan lanrrab.— ");
INSERT INTO gum_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Inchen tru karub peraguibe trenchibig køn: —¿Inchippa ishug unø i pirausrømay naba arrumønrrab misrene, trube, maig punrrerrah? cha. ¿Trube, ñui nusrkawan tru ñi webarrua arri pirausrømay nabe pera yam punrrautah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Inchen Abrahambe trenchibig køn: —Nai nusrkawane chiweinguen trusrømaybe pera imørrunrrig cha, ");
INSERT INTO gum_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehová srømbalamerai nø Tius, nai møskawei yaugurrimba, nai yau misaamerai piraugurrimba nan wesrabiibe, ¡katø! treegwan marmø kømø, nabe maramønrrun taitøga nan øyah chib wamindig køn cha: “Ñuinukkurri amrrub misaameran i pirøwan tranrrumøn” cha. Inchawei nøbe nui ángelwan ñui merrab ørtrun cha, nai nusrkaweyasig srain kønrrabigwan trusrøngurri ñi pera attrai. ");
INSERT INTO gum_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Inchene ishug-unø yandø arrumubene, trube, tru ¡katø! nabe treegwan maramønrrun cha, ñi kørrømisriibe ñuimburappe yandø ñibe chi isumikkaig kørrømisrabguen chibig køn. Inchendø nai nusrkawanesi trusrømayguimbe pera imørrunrrig— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Inchen tru nui karub pera kuibe tru nui karubig Abrahamwei srøptsim umbu nui tasigwan estsarøbig køn, tru chi martrab taigwan ¡katø! nabe treeg maramønrrun chib. ");
INSERT INTO gum_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Incha nøbe tru nun karub pera købig Abrahamwei pa trattrø camellosmeran nemøra, tru nui karub pera købigwei purø tabelan chine ketamig srua, Nacorwei ciudasrømay ibig køn, tru Mesopotamiasrømay. ");
INSERT INTO gum_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Incha ciudayu kømøtø, wambiisrø camellosmeran kan pisu pulu tømbønsrøngarubig køn isrønrrai, yandø maaben køben, tru srusralmera pi kalrrab werrum uras. ");
INSERT INTO gum_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Inchabe trenchib Tiusba waminchibig køn: —Nan karub peragøbig Abrahamwei Tius, møin kwaløm na purø tab purayamig kønrrai martra cha. Nan karub peragøbig Abrahamwan ñi purø tab indigwan nun kenamar cha. ");
INSERT INTO gum_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nabe yu pisu pulu pasrar cha, tru i ciudayu srusralmera pi wesranrrab amrrumne. ");
INSERT INTO gum_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Incha na tru srusran øyah taig truig kønrrain cha: “Na lamø pi mutsamig kønrrai tiusmanda ñui køtsøn pinøsru” chiben, nøbe løtappe: “Muchi cha. Katø ñui camellosmeran chigucha na pi mutsøsramønrrun” cha trenchibig, truig kønrrain cha, tru ñi lawa wesruig, ñui karuig megabig Isaacweyasig. Øyamay nabe wetøbenamønrrun cha, ñi nan karub peragøbigwan purø tab indigwan.— ");
INSERT INTO gum_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Inchen nø Tiusba chab waminchimøwatø, møimbe kan srusrø nui køtsøn kildunyu mutaig arruptinchibig køn, truibe Rebeca, Betuelwei nimbasr. Tru Betuelbe Milcaimba, Nacorweimba nusrkain købig køn, Abrahamwei nunewei. ");
INSERT INTO gum_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Inchen tru srusrøbe truba tab ishug købig køn, mu møøbagucha kia kømíig købig køn. Tru srusrøbe pisuyu kørraarrub, nui køtsøn pi netsøganøb katø inrrab iben, ");
INSERT INTO gum_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","tru Abrahamwei karuig mendig megabiibe truigweimay lulabe, trenchibig køn: —Ñui køtsøyu piwan kuchi srørrøbsrumuguh— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Inchene nøbe: —Nai kasuku, muchi— chibig køn. Incha mallatø køtsøn pinøsrub, køtsøn tasku muta pasramisra srørrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Incha: —Ñui camellosmeraingucha pi wesranrrab chibig køn, mutsamburab mutchai.— ");
INSERT INTO gum_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Incha mallazhiitø tru køtsøyu piwan tru pi kwarainug kwara treetø, treetø yambiji pi wesrawa, mam camellos kuimba mutsamne kwarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Inchen tru Abrahamwei karuig mendig megabiibe chigucha chimøtø, asig pasrabig køn, kaguende nøbe ke tab wetøbeñchab inchib pasraig kua, tru nø arriibe ka kauløtø kømø arrig kønrrai Jehová nun puruguig køtashig køb. ");
INSERT INTO gum_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Inchen tru camellosmera piwan chab muchen, tru Abrahamwei karuig mendig megabiibe kan oro surtigas seis gramos tøgaigwan kimyu mesrønrrai tranøb, katø kwalmerayu pagatø orotøga mariilan treetøwei pønsrøb inchibig køn, kwatsiimaybe cien gramos menrraikke. Inchabe trencha payibig køn: ");
INSERT INTO gum_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","—¿Ñibe mui nimbasr kugu? cha. Tiusmanda eshkarra cha. Katø ¿ñui møskawei yaube naba, nan lincha amrrub møgueløba chu kørrømisramdiig kø chinderah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Inchene nøbe trenchibig køn: —Nabe Betelwei nimbasr kur cha, tru Milcaimba, Nacorweimba nusrkawei.— ");
INSERT INTO gum_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Incha katø trenchibig køn: —Namui yaube ñim kørrømisra kiamiitø kømø, katø camellosmerai pu køben, para kebusriilø menrraguen tøgaguer cha, katø ñimuyasig chigucha.— ");
INSERT INTO gum_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Inchen tru møøbe tømbønsra utsøbasrabe, Tiuswan trenchib tabig waminchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Jehovábe maya nugucha, tabig køn cha, nan karub peragøbig Abrahamwei Tius. Nøbe nan karub peragøbigwan, purø nu tab indigwanba managuen elachimumigwanba kenamarøb pasrain køn cha. Incha nan karub peragøbigwei nømmisaamerai yausrø punrrai mariitan” cha. ");
INSERT INTO gum_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Inchen tru srusrøbe luløbig køn, tru chi purayaigwan nui yauelan eshkanrrab. ");
INSERT INTO gum_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Inchen tru Rebeca kan nuchag Laban taig tøgaguibe, truibe tru møwan lanrrab pisusrøngatig luløbig køn, ");
INSERT INTO gum_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","kaguende Labanbe nuchawei tru surtigaswan køben, katø tru kwalyu pønsraigwan køben ashib, katø ‘tru møg øyah, øyah chitan’ chib eshkaigwan mørøb indig kua. Incha Labanbe tru Abrahamwei karuig mendig megabigwein pulusrø kemallibig køn, truibe nui camellosmeraba pisu pulusrø srø pasramne. ");
INSERT INTO gum_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Incha Labanbe trusrø pua: —Jehová maya nuguen tabig nebuig kønrrai indi møg, amø chibig køn. ¿Ñibe wambiitøbe chinchib pasrønrragu? cha. Nabe yawane ñuyasig chab tamarar cha, katø ñui camellosmerain chigucha.— ");
INSERT INTO gum_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Inchen tru Abrahamwei karuig mendig megabiibe yamay arruben, nømbe camellosmeran niisrailan chab picha warabe, manrrai pønsrøbig køn. Incha trugurrimbe pi srua arrubig køn, tru Abrahamwei karuig mendig megabiiba, tru nui lincha amrrubeløba nømui srømmeran kwallchai. ");
INSERT INTO gum_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Incha manrrai mamiimera pønsrøben, Abrahamwei mendig megabiibe trenchibig køn: —Nabe na chi wamindamigwan wammørøsrømøwatøbe uta manrrab kaimamønrrun— cha. Inchen Labanbe: —Trube, wammørøsrørra— chibene, ");
INSERT INTO gum_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tru Abrahamwei mendig megabiibe trenchibig køn: —Nabe tru Abrahamwei mendig megab møg kur cha. ");
INSERT INTO gum_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Nan karub peragøbig Abrahamwane Jehovábe mayanguen tabig nebuig kønrrai marig køn cha. Nøbe larrø pua møg køn cha. Nune ubishamera køben, waaramera køben, an køben, oro køben, karuindiig melab møguelø køben, ishumburmera køben, camellosmera køben, burrusmera køben tranig, treeg tøgagøn cha. ");
INSERT INTO gum_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Inchen, nan karub pera købigwei srai Sarabe, køllimbala nui kan nusrkai tøgamisrig køn cha. Inchen nan karub peragøbiibe nui chi tøgaguilan kerriguba nui nusrkaweyasig kørrømaran cha. ");
INSERT INTO gum_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nane nan karub peragøbiibe, ¡katø! nane øyeegwan marmø kømø, maramønrrun tingaru tan cha, øyah chib: “Nai nusrkaweimbe yu Canaán pirau tru na tsuinug ishumburmerai utu ishuwan srai lanrrain kømøn” cha. ");
INSERT INTO gum_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","“Treeg kømøtø, nai møskawei yau misaameraimay ya, nai misagugurri amrrub ishumburmerai utu ishuwan nai nusrkawei srain kønrrai larrunrrig” cha. ");
INSERT INTO gum_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Inchene nabe nun trenchibig kur cha: “¿Inchippa ishug-unø nai mendig arrumønrrab incheneh?” cha. ");
INSERT INTO gum_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Inchen nøbe nane trenchibig køn cha: “Jehova maig chiben nabe trumay uninabig køben, truig ñune nui ángelwan ñiba inrrai ørtrun cha, ñi webya yaibe mayanguen tab punrrai, tru nai yau misaamerai yau ishug-unan nai nusrkawei srain kønrai lanrrai, tru nai møskawei yauelainug. ");
INSERT INTO gum_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Inchen nai yauelø ishug unan tranøg kømuincheneguende ñi nan ¡katø! nabe treeg marmø kømø, maramønrrun taigwane trube, yandø ñibe chi isumikkaig kørrømisrabguen chibig køn.” cha. ");
INSERT INTO gum_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Inchen na møi pisuyu puabe, nabe Jehováwan øyah chib miaig køn cha: “Nan karub pera tøgagøbig Abrahamwei ñi Tius, ñi na arrigwan nan tab webyamig kønrrain kuabe trube, ");
INSERT INTO gum_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","na møi pisu pulu pasrøben, øyeeg purainrrain cha, tru pi wesrawa srua inrrab arrub srusran: ‘Tiusmanda, ñui køtsøyu piwan nan kuchi srørrøbsrumugu’ chiben, ");
INSERT INTO gum_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","nan øyah cha løtabig truig kønrrain cha: nan ‘muchi’ cha srørrøb, ‘katø ñui camellosmeraingucha pi wesrunrrur’ chibig, truig kønrrain cha, tru nan karub peragøbigwei nusrkawei srain kønrrai Jehová lawa wesruig ishug unø.” ");
INSERT INTO gum_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Inchen nabe nai umbutø Tiusba chab waminchimøwatø, møimbe Rebecabe pi mutin køtsøn kildunyu mutaig, arruptindi ashibig kur cha. Incha pisuyu pi wesranrrab kørraiben, nabe trenchibig kur cha: “Tiusmanda, nan pi srøttra” cha. ");
INSERT INTO gum_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Inchen nøbe tru urastø køtsøn pinøsrub, nan “muchi” cha srørrøb, “katø ñui camellosmerangucha pi mutsøsrønrrur” chiptinchibig køn cha. Na muchib pasramne nøbe camellosmeran pi mutsøsrøbig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Inchen nabe “¿Ñibe mui nimbasr kugu?” cha payene, nøbe nane trenchibig køn: “Nabe Betuelwei nimbasr kur cha, tru Nacorweimba Milcaimba nusrkawei.” Inchen nabe nune kan surtigas kimyu mesrøb, kualmerayu pønsraigwan pønsrøb inchibig kur. ");
INSERT INTO gum_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Incha nabe Jehováwan tabig waminchab tømbønsrøbig kur. Jehováwan mayanguen, tabig køn chib, nan karub tøga pasrabig Abrahamwei Tiuswan, nan tru muba arrum maywan pera arrimburø; tru nø nan karub peragøbig Abrahamwei nusrkawan nui trag yau misagwan srain kønrrai tranen. ");
INSERT INTO gum_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Inchawei nai karub tøga pasrabigwan ñim yauelø kermab pesannameelø køb, larrø tammayelø køb treelø kuabe, nan eshkarray cha. Inchen treeg kønrrab kømubene, trube, trunungucha eshkarray cha. Trumaybe na mandø indamigwan na isumig kønrrautan— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Inchene Labánba, Betuelbabe trenchibelø køn: —Pøs, øyeebe chiguen kømøtø, Jehováweinukkurri arriinrrun cha. Nambe søl køn cha løtamig kømøwei, kabe kalø køn cha løtamig kømøwein køtan cha. ");
INSERT INTO gum_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebecabe yu wan cha. Ñun karub peragøbigwei nusrkawei srain kønrrai trube pera inrrø chibig køn, Jehová nø maig kønrrai isuig, trumay.— ");
INSERT INTO gum_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Inchen Abrahamwei karuig mendig megabiibe øyeeg taigwan mørøppe, Jehováwei merrab tømbønsra pirausrøngatig utsøbasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Incha tabzheelø orotøga mariilø køben, andøga mariilø køben, kemelø køben, wesrawa Rebecan ketøbig køn, Incha nuchawanba usranba truilangucha, chigøben ketøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Incha tru Abrahamwei karuig mendig megabiibe tru nui lincha pera yailøba uta mab, uta muchib incha, truyu kørrømisra kibelø køn. Incha katø løtsø kurrabe, tru Abrahamwei karuig mendig megabiibe trenchibig køn: —Nan karub peragøbig Abrahamwei yausrømay ambashchay— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Treeg kuingucha Rebecai nuchaaba, usrimbabe trenchibelø køn: —Ishug unøbe kan pa trattrø kwalømdøguen namba ka kørrømisrtrain cha. Trugurrimbeguendø ka ibwei inchun— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Inchen tru Abrahamwei mendig megabiibe trenchibig køn: —Nan kørrømisrtrai inchumørrunrrigay cha, na arrigwan Tiusbe yangucha tab punrrai marig købene, trube, tru nan karub pera købigwei yamay katø ibashchunrrigay— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Inchen nømbe trenchibelø køn: —Trube, ishug unan wamønrrab cha, nø manchitashchab— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Incha nømbe Rebecan wama, payibelø køn: —¿I møøba inrraguh?— cha. Inchene nøbe: —Øø, na lincha inrrur— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Inchen nømbe nuchag Rebecan ibashibelø køn, katø Rebecan lamíikkurri ashib tøgagøb ishuwanba. Abraham karub peraguiba, katø tru nø lincha pera arriiløba inrrai. ");
INSERT INTO gum_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Incha Rebecane mayanguen tabig nebuig kønrrai nømbe øyeeg chibelø køn: —Ñi, namui nuchag, misaamera purø nørrø katøyug katøyug amrrubelai usrin kønrrai isuer cha. Tru ñuinukkurri amrrub misaamerabe nømun ashig kømuinchibelai ciudameran nøm merrarrawa tøga pønrramisrtrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Incha Rebecabe tru nui karub tøgagui srusralmeraba, yandø camellosmeran itøguana, tru Abrahamwei mendig megabigwei tru mendig ambubelø køn. Øyamay tru Abrahamwei mendig megabiibe Rebecan pera ibig køn, truyugurri. ");
INSERT INTO gum_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Inchen Isaacbe tru “Øsig Wab, katø Nan Ashibig” cha wamim pisuyugurri katø arrin købig køn, kaguende nøbe Néguev pirau tsubig kua. ");
INSERT INTO gum_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaacbe kan maaben wambigwansrø lliranrrab webarrin købig køn. Incha møimbe kurraashene, camellosmera pulu lutaurab amrruptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Inchen Rebecagucha kurraasha, Isaacwan ashabe, camelloyugurri pinaarrua, ");
INSERT INTO gum_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","tru Abrahamwei mendig megabigwan payibig køn: —¿Mugøh? cha, ø møg namun katønrrab øsrø arrubiibe.— Inchene nøbe: —Øibe nan karub pera købig truig køn— chiben, Rebecabe tru malø kasraitøga pinab kasrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Inchen tru karuig mendig megabiibe nø maitø marigwan kerriguh Isaacwan waminchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Incha Isaacbe tru nui usri Sara tsui carpa ya købiisrømay Rebecan pera arrua, Rebecane nui srain kønrrai marøbig køn. Isaacbe Rebecane truba truba undaarawa, øyamay Isaacbe nui usrin kwabigwan truba pesrøgui uniibe yandø tabgui ");
INSERT INTO gum_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahambe katøgan srai tøgaguig købig køn, truigwei munchibe Cetura taig. ");
INSERT INTO gum_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Truibe Zimramwan køben, Jocsánwan køben, Medánwan køben, Madiánwan køben, Isbacwan køben, Súajwan køben tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Inchen Jocsanbe Sebanba, Dedánwanba tøgaguig køn. Inchen tru Dedánweinukkurri amrrub misaamerabe: asureosmera køben, letuseosmera køben, leomeusmera køben kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Inchen tru Madiánwei nusrkaløbe: Efa køben, Efer køben, Janoc køben, Abida køben, Elda køben kuig køn, truiløbe mayamba Ceturainukkurri amrrub misaamera. ");
INSERT INTO gum_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahambe nø kerrigu chi tøgaguilane Isaacwan chishtøh kørrømarig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Inchen nui linchatø ishumburmeraba tøgagui ureemerane chigøben ketiilø trana, incha nø øsig wappatø nusrkai Isaacweinukkurri tarømara, truilane pørr neeshibgatømay pirømerasrø warønrrai ørig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham øsig tsuibe pilamera ciento setenta y cinco kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Larrø kølliizhig misra, kwaig købig køn, larrø yam pilamera øsig tsua. Incha nui kølli misaameraba tsunrrab yaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Inchen nui nusrkalø Isaacba, Ismaelba misra kusra sørabelø køn, tru Macpela tainug, søramig peñayu trab lalig pasrabigu tru Mamre taig pinrrøguewansrø, tru Zohar hititai nusrkai Efrónweim pirau. ");
INSERT INTO gum_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Iibe tru Abraham hititasmeran penin pirø købig kuig køn. Truyu Abrahamwan sørig købig køn, Sara sraweim pulutøwei. ");
INSERT INTO gum_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Inchen yandø Abraham kwaben, Tiusbe Isaac nui nusrkawane mayanguen tabig nebuig kønrrai inchen, Isaacbe tru ‘Øsig Wab, katø Nan Ashibig’ taisrø pisu puluwan kørrømisra, tsubig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Abrahamwei nusrkai Ismaelweinukkurri amrrub misaamerabe iilø køn, tru Sarai karuindiig megab ishug egipcia tru Agar Abrahamba tøgagui unai. ");
INSERT INTO gum_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Iilø køn tru Ismaelwei nusrkalai munchimera, tru kerrigu mayur kal-labigwei wendautø trumørig kal-lawa amrrubelai. Ismaelwei kerrigu mayur nusrkaimbe Nebayot køben, trugurrimbe Cedar køben, trugurrimbe Adbel køben, Mibsan køben, ");
INSERT INTO gum_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","trugurrimbe Misma køben, Duma køben, Masa køben, ");
INSERT INTO gum_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar køben, Tema køben, Jetur køben, Nafis køben, Cedema køben kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Iilø køn tru Ismaelwei doce nusrkalø, tru nømui nørrø misag søtømørig ashib pønrrabelai munchimera. Nømui pirømeraba nøm chu kørrømisra warailøbabe tru munchimeratøgatøwei pønsra wamiilø. ");
INSERT INTO gum_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Inchen Ismaelwei øsig kuin pilamerabe ciento treinta y siete kuig køn. Inchen nui israbig luchen, yandø kwaig køn. Incha nui kølli misaameraba tsunrrab yaig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Incha ismaelitasmerabe Havilasrøngurri Shur taisrøngatig waraig købig køn, Egipto pinrrøguewansrø, tru Asiriamay ambi maywansrø. Inchen nøbe nunelan, ka kwayam laptø, kwayam laptø tsubig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iig køn tru Isaacweimburab chi pureb arrigwan wamindig, tru Abrahamwei nusrkawan. ");
INSERT INTO gum_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaacbe Rebecaba kasharab uras pilamera cuarenta tøgaig kuig køn, tru Rebecabe Betuelwei nimbasr Labanwei nuchag købig køn. Inchen Betuelba Labanbabe arameosmera Padan-aramsrø warabelø kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebecabe trendø ureg chigagønrrabig køben, Isaacbe nui sraweyasig Jehováwan miabig køn. Inchen Jehovábe nø miaigwan møren, Rebecabe kwanrriig kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Inchen tru pa ureemerabe nui patsautø kwayab purrøben, Rebecabe treeg isubig køn: “Øyeeg købene, ¿chiwein kui øsig uñibig unamøtah?” cha. Incha Jehováwan payrrab ibene, ");
INSERT INTO gum_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jehovábe trenchibig køn: —Ñui patsaube misaamera purø nørrøbatø pa søtø køn cha. Misagwan ashib karub pønrrønrrabelø pailø nørreelø ñui patsau purraisrøngurri nøørømisrøbguen purran cha. Kane katøgan lataguen kømø, mu chindamgaig kønrrabig køn cha. Inchen mayur kal-labiibe wendiig nø karuig meganrrabig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Indig yandø kal-lamig ura pubene, nui patsaube møg ureezheelø par kuin køptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Inchen tru srøsrø kal-labzhiibe ke pigø isig nabzhig købig køn, trurrigu asr ørøba isikuzhikke. Treekkurri Esau munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Inchen tru wendau nuneebe Esauwei talunwan merrarraweig kal-laben, treekkurri Jacob munchi pasrig køn. Inchen Isaacbe tru parcheelø kal-labene, pilamera sesenta tøgaig kuig køn.Nø Mayur Kal-laig Nusrkain Kuimburø Nø Uta Tøgagømigwan Yanøb ");
INSERT INTO gum_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Inchen ureemerabe nørrørab amba, Esaube ushameran pasraara kemøramiibe ke kan kaisab lataig inchibig købig køn, kaambumerawansrø unamig chull møg kua. Trune Jacobpe treeg maramigwane chi isumø ka nuimburab uñibig køn, carpa yau kørrømisra chigøben maramigwan chullig. ");
INSERT INTO gum_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Incha Isaacbe Esaúwan mas undaarabig køn, kaguen nø chi kemøra srua arriilan srørrig mabig kua. Trune Rebecabe Jacobwanrre mas undaarabig køn. ");
INSERT INTO gum_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Indiibe kan kwaløm Jacobpe pigø mamig may tamariizhig nenøb wabene, Esaube wabigwansrø llirab uña, larrø muraaraig puabe, ");
INSERT INTO gum_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Jacobwane trenchibig køn: —Ø pigø mamig may tamara ñi neniizhigwan tiusmanda srøttra cha, kaguende nabe larrø muraaraig war— cha. (Inchagurri Edom cha wamig kuig køn.) ");
INSERT INTO gum_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Inchene Jacobpe trencha løtaptinchibig køn: —Ñi mayur nusrkain kuimburø uta tøgagømigwan møin kwaløm, trube, yunømariyagun— cha. ");
INSERT INTO gum_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Inchen Esaube: —Pøs, nane parøgwabiitø ke kwamdø køtan cha. ¿Na mayur nusrkain kuimburø uta tøgaguatøbe chigui indamøtah?— chiben, ");
INSERT INTO gum_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacobpe trenchiptinchibig køn: —Møin kwaløm ¡katø! treegwan marmø kømø, maramønrrun chirra— cha. Inchen nøbe: —¡Katø! treegwan maramønrrun— cha kørrømisra, nø mayur nusrkain kuimburø uta tøgaguigwan Jacobpa yunømariyabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Inchen Jacobpe nuimburappe, pirrin køben, tru lentejas tamari mamiizhigwan køben tranen; truigwan uta mab muchib inchabe, truyugurri kurrab ibig køn. Øyeeg mara, Esaube nø mayur nusrkain kuimburø uta tøgagømigwan chiguen tabig kømui lataig indig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Tru kwalømmerawan tru pirau parø purø trømbøig arrubig køn, tru Abraham tsub urassrø parø arrub lataitøwei. Inchen Isaacbe Gerarsrømay ibig køn, tru filisteosmerai rey Abimelec tsuisrømay. ");
INSERT INTO gum_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Incha truyu Jehovábe Isaacwan kenamisra, trenchibig køn: —Egiptosrømaybe imøta cha. Na chu tsunrrain chiben tru pirau kørrømisr cha. ");
INSERT INTO gum_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","I pirautø ka tsu cha, ka petø purainrrab arruatiig lataitøweingue. Nabe ñiba pasramønrrun cha. Incha nabe ñun mayanguen tabig nebuig kønrrai maramønrrun cha; kaguen ñuinukkurri amrrub misaamerane i pirømeran kerriguh tranamønrrun cha. Øyamay ñui møskai Abrahamwan ¡katø! nabe tru treegwan marmø kømø, martrab taigwane maramønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ñuinukkurri amrrub misaamerane kan srømbalasrø kønchabiimera lataig nørrø kønrrai mara, i pirømeran kerriguh tranamønrrun. Incha chu pirausrøn køben misaamera nørrø søtø warabeløbe mayanguen tabig nebuig kønrrai marig kønrrun cha tru ñui misaamera amrrubeløyugurri. ");
INSERT INTO gum_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kaguende Abrahambe tru na maig taig wamwan nan møra, treeg kørrømisrtrai marig køn cha, tru øyeeg kømig køn cha na wamindigwanba, martrai na karua pønsrailanba, mandø kømigwan eshkawa pønsrailanba, katø mu chindamgaig martrai karua pønsrailanba.— ");
INSERT INTO gum_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Incha Isaacbe Gerar pirau kørrømisra tsuig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Inchen trusrø warab møguelø nui sraweimburab payene, nøbe trenchibig køn: —Naimbe nuchag køn— cha, kaguende nøbe kørig kui inchibig køn ‘nai srain køn’ tamiibe. Nui srai Rebecan nømui marøg køptø trusrø møgueløbe nun kwetchaitamab isubig køn, kaguende nøbe purø tab ishug køben. ");
INSERT INTO gum_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Incha kan maya yana køsrøn Isaacbe trusrø tsuben, tru Abimelec filisteosmerai reybe kan pendanayu ashib pasrøbene, møimbe Isaacbe nui srai Rebecane truba tabzhig undaarab pasrai ashiptinchabe. ");
INSERT INTO gum_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelecbe Isaacwan wamabe, trenchibig køn: —Chima øibe ñui srain kuirreh cha. Inchendø nane ¿chindimbarre, “naimbe nuchag køn” chigu?— cha. Inchene Isaacbe trenchibig køn: —Kaguende nun nømui marøg køptø nabe pinisaig kømuitamab isua trendaig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Inchene Abimelecbe trenchibig køn: —Ñibe namune ¿chindimbarre øyeeg margu? cha. Katøguchimbe namui misagu møig køben, ñui sraimba kaig marøb waramisrig kuimasrtø cha. Incha treeg kaig mariitøga kangurrindø ñibe namune mayeelan kegørrøsrka pønsrøbsrutan— cha!. ");
INSERT INTO gum_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Incha Abimelecbe maya misagwan trencha karua pasrøbig køn: —Møikkøben i møwan kui, kabe nui srawan kui chigøben inchib kalø marøbiibe kwamig kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Indiibe Isaac tru pirau ellmara, tru pilawan kan yellzhikkurrindø cien menrrabatø purø nørrø tulishibig køn, kaguende Jehová nun mayanguen tabig nebuig kønrrai inchen. ");
INSERT INTO gum_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Incha nøbe maskken maskken pua misrøb, larrø nui misrøb ya, muguen treeg tøgagømuinrrunig puaig misrig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Incha Isaacbe ubisha søtømera køben, waara søtømera køben, nun mara tranøbelø trurrigu nørrø tøgagøben filisteosmerabe pusrkwai ashib mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Incha nui møskai Abraham øsig wab urassrø, Abrahamwei karuig mendig melabeløbe aljibesmera lalla, pi wesruilan, truilan filisteosmerabe pirøtøga netsø kasra pønsrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Inchen Abimelecbe Isaacwane trenchibig køn: —Ñibe namuinukkurrimbe tarømisra, inrrø cha, kaguende ñibe nam lataguen kømø mu chindamga nuig misrin køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Inchen Isaacbe truyugurri ya, Gerar chag pirømerasrø tsumisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Møskai øsig wab urassrø pisumera lalla, wesruilø købigwan, katøle kura wesrubig køn; møskai kwaimbala tru filisteosmera kasra pønsraig købelan. Incha tru pisumerane møskai chi munchi pønsraig købelan tru munchimeratøgatøwein pønsra wamabig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Indig kan kwaløm Isaacwei karuig mendig melabeløbe tru chaasrø lallib kuabe, luløb pizheelø wetørrabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Inchen tru Gerar pirau ubisha ashib warabeløbe Isaacwei ubisha ashibeløba ‘i pibe namuin køn’ chib larrø mur aleguiyabelø køn. Incha treekkurri Isaabe tru pisuwane ‘Esek’, (‘Aleguiyaim Pi’) cha munchi pasrig køn, kaguendø nømbe tru pigurri aleguiyaig kua. ");
INSERT INTO gum_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Inchen katøgan pisu lalla wesruben, katø truikkurri treetøwei mur aleguiyabelø køn. Incha truigwane “Sitna” (‘Ashig Kømui Indiyab Kørrømisrin Pi’) cha munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Inchen Isaacbe truyugurri nøørømisra ya, katøgan pisu lalla wesraben, yandø tru pisuwane “Rehobot” cha munchi pasrig køn (‘Pishindø Tab Waramdiig Køn’ chib). “Møimbe chigømø llirab waramig kønrrai Jehovábe trandan cha nam i pirau merraptø webambamig kønrrai” ");
INSERT INTO gum_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Inchen Isaacbe truyugurri Beersebamay ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Inchen tru yem Jehovábe Isaacwan kenamisra, trenchibig køn: —Nabe ñui møskai Abrahamwei Tius kur cha. Chi kørig kui inchimøta cha. Nabe ñiba pasrar cha. Nai karuigwan marøb megabig Abrahamwan undag køptø nabe ñune mayanguen tabig nebuig kønrrai marøb, ñuinukkurri amrrub misaamerane purø nørrø kønrrai marøb indamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Inchen Isaacbe truyu kan altar kusrua, Jehováwei munchiwan wamab tabig waminchibig køn. Incha tru nui tsumig carpa yawan truyu tamara, pasrøbig køn. Inchen Isaacwei karuig mendig melabeløbe katø truyu lalla, pi wesrubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Inchen Abimelecbe Gerarsrøngurri Isaac tsuisrømay arrubig køn. Inchen tru Ajuzat tru nun trag linchib wam purugubiiba, tru nui suldaumeran nø karub pera pasrabig Ficolba lincha amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Inchen Isaacbe trenchibig køn: —¿Ñimbe naimaybe chinchab amrrugue? cha. Ñimbe nane tsalø køptø, ñimui piraugurringuen nan wegucha pønrrøbendøbe?— ");
INSERT INTO gum_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Inchene nømbe trenchibelø køn: —Nambe asha ker cha, Jehovábe ñiba pasrain kui. Pøs nambe treeg isuer cha: “Ñiba namba øyamay martrab kandø isua kørrømisram kønrrab kui. Inchen treeg isuigwane ¡katø! marmø kømø nabe øyamay maramønrrun taitøga maramig kønrrain cha. Inchen tru øyamay kønrrai martrab cha kørrømariibe møimbe øyeeg kønrrun cha” ");
INSERT INTO gum_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Pøs ñibe namun chigucha kaig marmumig kønrrain cha. Pøs namma ñune chigucha chi kaig incha ashmøtø, nambe ñune tab tøgagua, ñune chigucha kømø tab webya inrrai marig kuig køn cha. Pøs møimbe ¡Jehová mayanguen tabig nebuig kønrrai indiibe ñi køn!— cha ");
INSERT INTO gum_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Inchen Isaacbe truilayasig truba truba tab mamiimera tamaren, nømbe mab, muchib inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Incha katø kwalømbe løtsøzhig kurra møingurrimbunøbe ambugurri igurri kwayab kømønrrab cha nømbe treeg kørrømisrøbelø køn, Inchen Isaacbe yandø ungua chiben, nømbe chi isumø, tab webamba ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Inchen tru kwalømdøwei Isaacwei mendig melabeløbe tru nøm pi wesranrrab lallib kuigwan: —¡Nambe pi wetørrer!— chib eshkab amrruptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Inchen Isaacbe i pisuwane “Seba” cha munchi pasrig køn trenchippe: ¡Katø! marmøgømø maramønrrun tain pisu cha. Inchawei tru ciudawane møin kwalømgatig “Beerseba” cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Inchen Esaube pilamera cuarenta tøgagua, Judit taigwan nui srai marig køn, tru hitita Beeri taigwei nimbasrwan. Katø trugurri tru Basematwan srai marig køn, tru hitita Elónwei nimbasrwan. ");
INSERT INTO gum_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Inchen Isaacweimba, Rebecaimbabe tru i pagatø ishumburmerabe larrø trømbøig isuindø, isuindø melønrrai marøbelø købig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Indig Isaac yandø larrø kølliizhig misren, nui kammerabe yandø pilømuben, yandø ashchab kaimabig købig køn. Kan kwaløm nui mayur nusrkai Esauwan wamabe, trenchibig køn: —Nai nusrkain— cha. Inchen nøbe: —Nabe yu war— chiben, ");
INSERT INTO gum_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaacbe trenchibig køn: —Nabe yandø køllig kur cha. Nabe chi kwaløm kwam kui mørmur cha. ");
INSERT INTO gum_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Pøs, ñibe tru ñui usha kemørøb srua uniilan: tru ñui arconba ñui flechaswanba nemøra srua, wambigwansrø kan usha ørtrab inrrø chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Trugurrimbe, na maig chullig kuaasha, kan mamig larrø mayzhig tamara, srua attra chibig køn, na manrrur cha. Trugurrimbe na kwamøwatø mayanguen tabig nebuig kønrrai ñuyasig na Tiuswan mianrrab— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Inchen Rebecabe Isaac tru nui nusrkai Esaúwan waminchen, mørøb wabig køn. Inchen Esaúbe wambigwansrø ibig køn, møskaweyasig kan ushawan pasraara, kweecha, sruattrab. ");
INSERT INTO gum_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Inchen Rebecabe nui nusrkai Jacobwane trenchiptinchibig køn: —¡Au! nabe ñui møskai Isaacbe ñui nuneg Esaúba: “Kan usha kemøra larrø may mamiizhig tamara, srua attrig” chib øyeeg waminchen trunun mørar cha. ");
INSERT INTO gum_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Incha nø mamigwan ma, Jehováwei merrab mayanguen tabig nebuig kønrrai ñuyasig na Tiuswan mianrrab chitan cha, nø kwamøwatø.” ");
INSERT INTO gum_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Inchawei nai nusrkai na mandø cha karuben, trunun tab mørtra chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Møimbe ubishameraba cabrameraba purrabsrømay ya, pagatø purø tab cabro ureemeran sruattra cha. Pøs, nabe ñui møskai maig mabig kui asha truilan larrø may mamiizhig tamaramønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Inchen ñibe nø manrrai srua inrrig cha, nø kwamøwatø, mayanguen tabig nebuig kønrrabigwan Tiuswan nuyasig miaben, trunun ñi utønrrig— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Inchene Jacobpe usri Rebecane trenchibig køn: —Nai nuneg Esaúbe ya isiitø møg køben, nabe ya chigucha isikkaibe cha. ");
INSERT INTO gum_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Inchippa nai møskaimbe nan katørawa, nan mugui mørabe, nane isa purø may kebenøsrkøptiig kui martrautan cha. Trubeguende nane mayanguen tabig nebuig kønrrai nayasig Tiuswan miai urasbe nane masken larrø kaig nebuig pasramigwanguen miawa pasrtrautan— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Inchene usrimbe trenchiptinchibig køn: —Nai nusrkai, ñun trømbøig nebunrrabiibe nan nebunrrain cha. Na maig taigwan mørøptø møra, srua amø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Inchen nøbe ya srua arrua, usran tranen, usrimbe møskai maig chullig kuaasha, treeg tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Incha trugurrimbe usrimbe mayur nusrkai Esaú kewa uniilø purø tabig yau purrabelan Jacob wendø nusrkawan kenanøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Incha trugurrimbe tru usrimbe Jacobwane tasiguba, katø nukaburab chi isikkayube tru cabro ureezhelai kalusmeratøga pinøbula, ");
INSERT INTO gum_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","trugurrimbe tru may mamiizhig tamarigwanba, tru pirrin tamarigwanba Jacobwan tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Inchen Jacobpe møskaweimbulu puabe, trenchibig køn: —¡Nai Papá!— cha. Inchene Isaacbe trenchibig køn: —Nabe yu war cha, nai nusrkai. ¿Ñibe mø nusrkain kugu?— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Inchene Jacobpe trenchiptinchibig køn: —Nabe Esaú, ñui mayur nusrkain kur cha. Nabe ñi maig taigwan marar cha. Kurra, wamisra na kemøra srua arrigwan ma chibig køn. Tru mayanguen tabig nebuig kømigwan nayasig Tiuswan miaben na utønrrab— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Inchen Isaacbe nui nusrkawan trenchibig køn: —Nai nusrkai, ¿Mandø incharre malla wetørragu?— cha. Inchene Jacobpe trenchibig køn: —Jehová ñui Tiusbe nan petø wetørramig purugutan— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Inchen Isaacbe Jacobwan trenchibig køn: —Nai nusrkai møimbe kemall cha, na katøranrrumøn cha, isa kømø, nai nusrkai Esaú køtamørtrab cha kabe peg kuin kui.— ");
INSERT INTO gum_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Inchen møskai Isaacwan Jacobpe kemallen, nøbe katørawabe, trenchibig køn: —Wambe Jacobwein købendø, tasiimerabe Esaúwein købwain inndan— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Pøs nøbe møig kui mørtrab kaimabig køn, kaguende tasiimerabe Esaúwei tasiimera lataig isiiteelø køben. Incha mayanguen tabig nebuig kømigwan yandø ke tranntrab inchabe, ");
INSERT INTO gum_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaacbe katøle payibig køn: —¿Ñigan isa kømø, nai nusrkai Esaú køtirru?— cha. Inchen Jacobpe: —Nabe truwein kur— chiben, ");
INSERT INTO gum_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaacbe trenchibig køn: —Ñi kemøra srua arrigwan na manrrab srua attra cha, na ñun mayanguen tabig nebuig kømigwan tranrrumøn— cha. Inchen Jacobpe mamigwan srua kemallen, Isaacbe mabig køn. Incha katø vinogucha srua arruben, trunungucha muchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Inchen Isaacbe nusrkawan trenchibig køn: —Nai nusrkai, møimbe kemalla, nan mucharra— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Inchen Jacobpe kemalla, muchaben, Isaacbe tru nui nusrkai kewa pasrailan irrømørabe, mayanguen tabig nebuig kømigwan tranøb trenchibig køn: —Nai nusrkaimbe wambigwansrø chi købigwan Jehová mayanguen tabig kønrrai mari lataig irrabig køtan cha. ");
INSERT INTO gum_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tiusbe tru ellmariiløyu srømbalasrøngurri serenu peñibzhigwan tranrrun cha. Inchen pirøbe misramburab misren, tirigumera misrøb, vinomeragucha nørrø weguchib inchun cha. ");
INSERT INTO gum_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tru misag søtømera nørrø pønrrabeløbe ñun utsøbasrtrun cha. Inchen ñibe ñui nunelane ñi karubig kønrrig cha. Inchen truiløbe ñui merrab utsøbasrtrun cha. Ñun ‘trømbøig nebunrrain’ chib pønrrabeløbe, nøm trømbøig nebuilø kønrrun cha. Inchen ñun ‘tabig nebunrrain’ chib pønrrabeløbe, nøm tabig nebuilø kønrrun— chib. ");
INSERT INTO gum_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Inchen Isaac tru mayanguen tabig nebuig kømigwan Jacobwan chab tranen, Jacobpe møskaweinukkurri webiben latatø, nuneg Esaúbe wambigwansrø usha kemørøb uña puptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Incha nøgucha kan mamig mayzhig tamara, nui møskaweimay srua arruabe, trenchibig køn: —Nai papá, wamisr cha. Na ñui nusrkai kemøra srua arrigwan manrrig cha, ñi nan mayanguen tabig nebuig kømigwan nayasig Tius nan trannrrai miarrunrrig— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Inchene Isaac møskaimbe trenchiptinchibig køn: —¿Trube, ñibe mugugu?— cha. Inchen nøbe: —Nabe tru Esaú ñui mayur nusrkain kur— chiben, ");
INSERT INTO gum_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaacbe itønab menda, purø kørrø kwaarig, trenchibig køn: —¡Paare! ¿Trube muguig køh? cha, tru usha kemøra srua arrubiibe. Pøs, ñi arrumøwatø, srua arruben, nabe kerrigu chab maig køn cha. Incha nabe mayanguen tabig nebuig kømigwan nun chab tranig køn cha. Pøs, tru mayanguen tabig nebuig kømigwan tranigwane nøbe tøga kørrømisrtrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Inchen Esaúbe møskai trendaig wamwan mørabe, truba mur wamab trashib, purø kørrø isui inchib ¡karren kønrrab! chib kishibig køn, trenchib: —Nai møskai, tiusmanda nangucha tru mayanguen tabig nebuig kømigwan trannrra— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Inchen Isaacbe trenchibig køn: —Ñui nuneebe arrua, nane purø may isa, tru mayanguen tabig nebuig kømig ñuin kønrrabigwan nø uta, tøga, yan— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Inchene Esaube trenchiptinchibig køn: —Nune Jacob cha wamappe, trendambuawei trendaig kuin køn cha. Pamayguen køn cha, nan øyeeg isa kebenøsrkøb arrig, srøtøbe na mayur nusrkain kuimburø na uta tøgagømigwan nø kerraig køn cha. Møimbe tru mayanguen tabig nebuig kømig naiwan katø nøtøwei uta tøga yain køn— cha. Inchabe katø trenchibig køn: —¿Nayasikkan tru mayanguen tabig nebuig kømigwan tranamig maitøguen tøgagømøtirru?— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Inchen Isaacbe trencha løtabig køn: —Nabe ñune Jacob karub tøgagønrrai Tiuswan miar cha. Incha katø nui misaamerabe Jacob manchiben marøb melabelø kønrrai miar cha. Trurrigu nøbe tirigumera nørrø tøgagøb, vinomera tøgagøb inchai miar cha. Nai nusrkai, ¡Møimbe yandø ñuyasiibe chi maramig kaatan!— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Inchen Esaúbe møskawan trenchibig køn: —Nai møskai, tru mayanguen tabig nebuig kømigwan tranamiibe kabe ke kanzhiitø kuig kuitarru cha. Nai møskai, nangucha tru tabig nebuig kømigwan trannrra— cha. Incha srawa, srawaa kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Inchene Isaacbe trenchibig køn: —Ñibe misrøb pirømerasrøngurri purø yabsrø tsunrrabguen cha, katø srømbalasrøngurri serenu peñibig nebumøsrø. ");
INSERT INTO gum_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ñibe ñui espadatøga kwayawatøwei øsig tsunrrabguen cha. Incha ñibe ñui nuneg karuindiig megamig nebunrrun cha. Inchendø ñun megamgaig misrøb arruben, ñibe truyugurri welulrrabguen— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Indig truyugurrimbunø Esaúbe Jacobwan purø trømbøig ashig kømui inchibig køn, nui møskai tru mayanguen tabig nebuig kømigwan nun tranikkurri. Incha nøasiitøwei trenchibig køn: “Maya yanayutø namui møskai pinøben, larrø isuin pønrram kwalømmeragucha attrun cha. Yandø trugurrimbe si, pinisamønrrun cha, nai nuneg Jacobwan.” ");
INSERT INTO gum_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Inchen Rebecabe tru Esaú øyeeg martrab isub unigwan wammørabe, Jacobwan wamønrrab øra, trenchibig køn: —Ñui nuneg Esaúbe ñun nøgucha lata martrab ñune kwetchab tan cha. ");
INSERT INTO gum_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Inchawei nai nusrkai na maig taigwan møra mar cha. Nai nuchag Laban Haran pirau tsuisrømay trubab inrrø chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Trusrø kan maya yana køsrøn tsunrrig cha, ñui nunewan namig købig purayamne. ");
INSERT INTO gum_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ñui nunewei namig købig yandø patsab, tru ñi nun chi mariilan nø pesannabene, ñibe katøle attrai, trube, eshkawa øramønrrun chibig køn. Nai pagatø nusrkalan ke kan kwalømyutø parba pini asha wag kømøtan— cha. ");
INSERT INTO gum_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Incha Rebecabe Isaacwan trenchibig køn: —Nabe nai øsig unigu larrø trømbøig kui uñar cha, tru hititas ishumburmeragurrindø. Jacob yu Canaán pirau hititasmeraba kasharabene, chinchib øsig tsumuinguen kønrrautan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaacbe Jacobwan wama, mayanguen tabig nebuig kønrrai tranabe, trencha karubig køn: —Nui srain kønrrai yu Canaán pirau ishumburmeran lanrrab kømø cha. ");
INSERT INTO gum_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kurra, Padan-Aram pirausrømay inrrø cha, tru Betuel ñui usrai møskai waisrømay. Incha ñui kuchimøskai Labanwei kan nimbasrwan ñui srain kønrrai lanrrig cha. ");
INSERT INTO gum_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Inchen Maramburab Marøb Tiusbe ñune mayanguen tabig nebuig kønrrai mara, ñune ureg larrø nørrø tøgagønrrai tranøb, ñuinukkurri purø nørrø misag søtømera nemisramnegatig martrun cha. ");
INSERT INTO gum_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Katø Abrahamwan tru mayanguen tabig nebuig kønrrai trannrrab misrig købigwan ñunba, ñuinukkurri amrrub misaameranba ñun trannrrain cha. Tru møiya ñi peesrøngurri ka arruatø lataig tsuin pirøwan ñimui mara waramig kønrrai, tru pirøwan Abrahamwein kønrai Tius nun keta trannrrabmisra kørrømisrig købigwan.— ");
INSERT INTO gum_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Øyamay Isaacbe Jacobwan Padan-Aramsrømay inrrai ørig købig køn, tru Betuel arameowei nusrkai tru Labanwei yausrømay. Truibe Rebecaimbe nuchag købig køn, Jacobweimba Esaúweimbabe usrin køben. ");
INSERT INTO gum_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Inchen Esaúbe wammørøbig køn, møskai Isaacbe tru mayanguen tabig nebuig kønrrai tranøb, sraingucha lappe, Padan-aramsrø lanrrai chiben. Incha tru mayanguen tabig nebuig kømigwan møskai tranabe, øyeeg karua pasri ashibig køn: “Yu Canaán ishumburmeran ñui srain kønrrai marøb pasrønrrab kømø” cha. ");
INSERT INTO gum_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Inchen Jacobpe møskawanba usranba møra, Padan-Aramsrømay yai ashibig køn Esaúbe. ");
INSERT INTO gum_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Incha treekkurri nui møskai Isaacbe tru Canaánsrø ishumburmerane chigucha tab kømui ashibig kuin kui wetøbeña, ");
INSERT INTO gum_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esaúbe Abrahamwei nusrkai Ismael tsuisrømay ya, tru katøgan sralø kømnetø, trusrø Mahalatwan nui srain kønrrai marøbig køn, tru Abrahamwei nusrkai Ismaelwei nimbasrwan, tru Nebaiotwei nuchawan. ");
INSERT INTO gum_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Inchen Jacobpe Beersebagurri webya, Haran pirausrømay ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Inchen yandø kanbalø puabe, pørr pinaiben, truyu yem kørrømisrøbig køn. Incha truyu kan srug tsubigwan kuña mara trarra, truyu kinrrab tsumisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Inchen truyu nun piappe treeg piabig køn: Kan escalera, srømbalasrøngurri pirausrø punøsrkain pasrappe, tru kappe srømbalasrø kebacha pasrøben, møimbe truwane angelesmera nebambamba, kørrørrumba inchib køben, ");
INSERT INTO gum_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Jehovábe palasrø pasrøwabe, trenchibashib: —Nabe Jehová kur cha, Abraham ñui aweluwei Tius, Isaac ñui møskawei Tius, ñi uyu kib tsuig pirøwane ñunba, ñuinukkurri amrrub misaameranba tranamønrrun chib. ");
INSERT INTO gum_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ñuinukkurri amrrub misaamerabe purø nørrø køptø, pirau kan usrø tui lataig kønrrun cha, pørr pinebgatømaywansrø, pørr neeshibgatømaywansrø, walliguebwansrø, waguebwansrø, misag larrøbicha warønrrun cha. Ñui yellyugurri pirau muba kuimburab maya misaabe, ñigurri mayanguen tabig nebuilø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nabe ñiba pasrar cha. Ñi chu yaindøgucha nabe ñun chi kømønrrai ashib tøga pasrøwa, katøle i piraumay nabe ñune pera arrumønrrun cha. Na ñun maig martrab taigwan na trunun maramnegatig nabe ñune elachimumønrrun— taig køn tru piabyube. ");
INSERT INTO gum_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Inchen Jacob tru piab tsuigugurri kiagasrabe, trenchibig køn: “Isa kømø, Jehovábe yu pasrøben, nabe treeg kuitamappe isumubrain køn” cha. ");
INSERT INTO gum_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Incha truba kørig kui inchabe, trenchibig køn: “Yube si, purø kørig kømdiig køtan cha. Chi peg kømøtø, Tiuswei yaba, srømbalasrø yaskappa køn” cha. ");
INSERT INTO gum_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Inchen Jacobpe løtsøzhig kurrabe, tru nø kuña mari srugwan kusrua, kan pilar lataig ølneb pasra, truyu øyeeg puigwan aschai trubala aceite itølushibig køn. ");
INSERT INTO gum_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Incha truyube Betel cha wamabig køn, merrabsrømbe tru ciudawane Luz cha wamig købig kuindøgucha. ");
INSERT INTO gum_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Incha Jacobpe nuinetø øyeeg martrab cha kørrømisrøbig køn: “Tius naba lincha pasrab, na møi øyeeg inrrab yaigu nan chigucha kømønrrai ashib, nan mamig, mutsamig tranøb, pula pasramig tranøb, ");
INSERT INTO gum_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","katø na nai møskawei yausrø chigucha kømø, katøle pishindø tab ka puinabene, Jehovábe nai Tius kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Inchen i srugwan kan pilar lataig ølgandø na kusrua pasriibe, Tiuswei ya kønrrun cha. Inchen Tius nan chigurrimbunø tranigugurri nabe cienyu diezbatø, diezbatø nun tranamønrrun” chibig køn, Jacobpe. ");
INSERT INTO gum_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacobpe nø chu yamsrømay ib ya, pørr kal-labgatømaywan misaamerain pirausrø pubig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Incha trusrø pua ashene, tru wambigwansrømbe kan pisu wabig køn. Inchen tru pisu pulube ubishamera pøn søtø israb warabelø køn, kaguen truiløbe tru piwan muchibelø kua. Inchen tru pisube larrø nu sruutøga kasraig pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Inchen tru ubisha søtømera truyu mayamba tuluntsunøbene, ubishameran pi mutsøsrønrrab tru srugwan malsra, katø chab muchene, srugwan katøle kemalsra pisuwan kasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Inchen Jacobpe tru ubisha ashibelan: —¡Nai nunelø! ¿Ñimbe chuelø køgue?— cha payene: —Nambe Haransreelø ker— chiben, ");
INSERT INTO gum_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jacobpe katøle trencha payibig køn: —¿Nacorwei awelu Labanwan ñimbe ashibelø kømøgueh?— cha. Inchen nømbe: —Truigwane nambe ashibeløwein ker— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Inchen Jacobpe: —¿Kwanrrø kømø, tab ka tsubig kuitarru?— cha katøyug payibig køn. Inchen tru ubisha ashibeløbe trenchibelø køn: —Nøbe tab ka tsubig køn cha. Au, ñiguen ash cha, møskawei ubishameran merrana nimbasr Raquelbe uyu arrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Inchene Jacobpe trenchibig køn: —Kwalømdø srø køn cha. Ubishameran kanbalatø mara keramibe menrra tørbatø køn cha. Pi mutsøsra, pu manrrai katø merranamdiig kømuita— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Inchen truiløbe trenchibelø køn: —Treeg maramgaig køn cha, maya ubisha søtømera kerrigu kanbalatø misramne, tru ubisha ashibelø, tru pisu pala srug trarrig tsubigwan malsramne. Malsrøbendøwei ubishameran nambe pi mutsøsramig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Inchen Jacob truiløba waminchib pasramne, Raquelbe møskawei ubishameran merrana, arruptinchibig køn, kaguende ubishameran nø ashibig kua. ");
INSERT INTO gum_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Inchen Jacobpe tru nui usraimbe nuchag Labanwei nimbasr Raquelwanba, katø tru Labanwei ubishameraba arri ashabe, kemalla, tru pisuyu srug kasraig tsubigwan malsra, nui kuchimøskai Labanwei ubishameran pi mutsøsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Incha trugurrimbe Raquelwan muchawabe, truba truba kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Incha nøbe: —Rebecai nusrkain kur’ cha. Labanweimbe kuchiunø kur— chib waminchen, Raquelbe nui møskawan eshkanrrab luløbig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Inchen Labanbe tru nui nuchawei nusrkai Jacobweimburab wamindi mørøppe, katønrrab luløb ya, ira, muchawa, nui yamay pera ibig køn. Inchen Jacobpe nun chitø purayaigwan kerriguh eshkabig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Inchen Labanbe trenchibig køn: —Ñibeguende nai anindøwein køn— cha. Inchen Jacobpe yandø Labanba pølguen tsuben, ");
INSERT INTO gum_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labanbe nune trenchibig køn: —Ñi nai yauig kuimburøtø chi pagaraimíig ka mara tranøptø megamig kømøn cha. ¿Mayanzhig pagaramø?— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Inchen tru Labanbe nimbasrmera pagatø tøgaig købig køn, mayurbe Lea købene, wendiibe Raquel. ");
INSERT INTO gum_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leabe kammera larrø tabzhig ashibig købene, trune Raquelbe larrø tab malø pasraig, larrø tab ishuuzhig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Incha Jacobpe Raquelwan purø chull asha, nui kuchimøskawane trenchibig køn: —Ñui wendø nimbasr Raquelwan nai srain kønrrai ñi tranamwei trattrø y pa pila ñuyasig mara tranøb megarrumøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Inchene Labanbe trenchiptinchibig køn: —Asiimíigwan tranøbgunrriibe ñi yauigwan tranrrumøn cha. Trube, naba kørrømisr— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Øyamay Jacobpe trattrø y pabila Raquelwan tranamwei mara tranøb megabig køn. Nøbe Raquelwane purø chull asha, megaig køppe, nune ni kan maya yanaguen kømub lata inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yandø Jacobpe pilamera trattrø y par nemisrene, Labanwane trenchibig køn: —Maya yana mara tranøb meganrrain taigwan yandø nemaran cha. Møimbe nai srai kønrrai trannrra— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Inchene Labanbe truyu maya misaameran tulamrrai wama larrø tab fiesta marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Indiibe yandø yem misren Labanbe nui nimbasr Lean pera arrua, Jacobwane truigwan tranøptinchen, Jacobpe pera kibig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Inchagucha Labanbe kan karuig mendig megabig Zilpa taigwane Lean purugub meganrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Indiibe løtsøbe, Jacoppe Leaba kib tsuptinchibrain kui ashibig køn. Incha Jacobpe Labanwane trenchibig køn: —¿Øyeebe nane ñibe chi margu? cha. ¿Yamba Raquelwan tranamwei nabe ñuyasig marøb megaig kømuitarru? cha. ¿Nane chindimbarre øyeeg isa kebenøsrkugu?— cha. ");
INSERT INTO gum_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Inchene Labanbe trenchibig køn: —Nam waraim piraube kasharanrrai wendiigwanmerrig tranamig kømøn cha, mayurguen ka tsumnetøbe. ");
INSERT INTO gum_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Leaba tru kasharabyu tabig mab kasrag waramigwan trune neigwan patsøgø chibig køn Labanbe. Trugurrimbe Raquelwangucha tranrrumøn cha, trattrø y pa pila ñi nayasig katøle srøig marøb meganrrab købene.— ");
INSERT INTO gum_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Inchen Jacobpe treeg marøbig køn. Incha tru Leaba tru kasharabyu tabig mab kasrag waramigwan tru trune neig maramigwan chab nemarene, Labanbe Raquel nui nimbasrwan srain kønrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Inchen Labanbe kan karuig mendig megabig Bilha taigwangucha Raquelwan purugub meganrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Inchen Jacobpe Raquelbagucha kibig køn. Incha truigwane Lean lataguen kømø, masken undaarabig køn. Incha Labanweyasig katøgucha srøig trattrø y pa pila mara tranøb megaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jehovábe Leane Jacobpe ke palabinø indi ashabe, truigwane ureg tøgagønrrai tranøbig køn. Trune Raquelbe urekkaig kønrrabig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Incha Leabe kwanrriig kørrømisra, kan nusrkai tøgagua, truigwane Rubén munchi pasrøbig køn, kaguende nøbe trenchibig køn: “Na yeekkucha isui megaben, Jehová nan isua ashtan cha. Møimbeguende nai keebe nan undaaranrrautan” cha. ");
INSERT INTO gum_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Incha katøle kwanrriig kørrømisra, katø kan møg unø tøgaguig køn. Inchabe trenchibig køn: “Jehovábe mørin køn cha, nan øyeeg undaaramuinab megaigwan. Inchagurri i nusrkawangucha nan trandan” cha. Treekkurri truigwane Simeón munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Incha katøle kwanrriig kørrømisra, katø kan nusrkai tøgagua trenchibig køn: “Møimbe nai keebe naba mas trakkandø linchautan cha, kaguen nabe nune chabguen pøn nusrkaløguen tranar” cha. Inchagurri truigwane Leví munchi pasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Incha Leabe katø kwanrriig kørrømisra, katø kan nusrkai tøgaguig køn. Inchabe trenchibig køn: “Møi iyube Jehováwan mayanguen tabig wamindamønrrun” cha. Inchagurri truigwane Judá munchi pasrøbig køn. Incha trugurrimbe yandø kan maya yana køsrøn mas ureg chigaa guig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquelbe Jacobwei ureg tøgagønrrab kaimappe, numøsrawane truba pusrkwai asha, Jacobwane trenchibig køn: —Ureg tøgagønrrab trannrra cha, tren kømuisruandø nabe kwamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Inchen Jacobpe truba nama, trenchibig køn: —¿Nagan Tius kuitarru cha, ñun chi ureg chigaig kønrrai marøbiibe?— ");
INSERT INTO gum_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Inchene nøbe trenchibig køn: —Bilha, nai karuig mendig megabigwan na ñun tranar cha. Truiba ki, chibig køn. Inchen truig ureg tøgamisren kal-laben, nai srøbchagu mutikkurrimbe na tøga misri lataitøweih køben, nabe nøgurri ureg tøgaig kømønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Øyamay Raquelbe tru nui karui megabig Bilhan Jacobwan srai lataig kønrrai tranøbig køn. Inchen Jacobpe tru Bilhaba kibig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Inchen Bilhabe kwanrriig kørrømisra, Jacobwei kan nusrkai tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Incha Raquelbe trenchibig køn: “Tiusbe naimburab maig maramigwan sølgandø martan cha. Incha nai miaigwan møra, kan nusrkai trandan cha. Treekkurri Incha Raquelbe tru unane Dan munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tru Bilha Raquel karui mørøb megabiibe, katø kwanrriig kørrømisra, Jacobwei katøgan nusrkai tøgamisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Incha Raquelbe trenchibig køn: “Tius namun øyeeg kønrrain kuikkurri nabe nai numøsraimba purø murtø melambuyab megawa, na kanar” cha. Treekkurri Raquelbe tru unane Neftalí munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Inchen Leagucha yandø mas ureg tøgagønrrab kaimappe, nui karuig mendig megabig Zilpan pera arrua, Jacobwan tranøbig køn, nui srain kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Inchen tru Zilpa Leai karuig megab ishuube, Jacobwei kan unø tøgamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Inchen Leabe trenchibig køn: “Yangucha tabig pub attrabigwan tøgaguinatan” cha. Incha treekkurri Gad munchi pasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Inchen Leai karuig mendig megabig tru Zilpabe Jacobwei katøgan nusrkai tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Incha katø Leabe trenchibig køn: “Nane larrø kasrag køtan cha. Ishumburmerabe: ¡kan yangucha tabgui unamigwan tøgaguita!” chinrrautan cha. Treekkurri tru unane Aser munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Tirigu parøb kwalømmerawan Rubenbe wambigwansrø llirab yabe, mamig trulmera mandrágoras tailø wetørrawa usri Leayasig lurra, srua arrubig køn. Inchen Raquelbe Leane trenchibig køn: —Tiusmanda, ñui nusrkai tru mandrágoras tailø srua arriilan srøttra— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Inchene Leabe trencha løtabig køn: —¿Ñibe nai kewan yeeg kerrawa pasraptøga ñungan chigucha kømui lataig mørøraitarru? cha. ¿Møimbe nai nusrkai mandrágoras srua arriilangucha nan kerranrrab indirru?— cha. Inchene Raquelbe trenchiptinchibig køn: —Tru ñui nusrkai mandrágoras srua arriilan na merrarranrrur cha, truburø møi yem Jacobpa ñi ki pøs— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Inchen yandø maaben køben, Jacob wambigwansrø uña katø arruben, Leabe katønrrab webyabe, trenchibig køn: —Møi yembe ñibe naba kiamig kønrrab køn cha, kaguen nai nusrkai mandrágoras srua arriitøga nabe Raquelwan pagarawa, truburø møi yembe nabe ñiba kiamig køn— cha. Inchen tru yembe Jacobpe Leaba kibig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Inchen tru Lea miab megaigwan Tius møren, Leabe kwanrriig kørrømisra, trattrøgatø kønrrabyu nusrkawan Jacobwei tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Incha Leabe trenchibig køn: “Tiusbe tru na pagaraikkurri nan keta trandan cha, kaguende nabe nai karuig mendig megabigwan nai kewan tranig kua” Incha treekkurri unane Isacar munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Incha Leabe katø kwanrriig kørrømisra, Jacobwei katøgan nusrkai tøgaguig køn, truibe tru trattrø y kanba kønrrabyu nusrkawan. ");
INSERT INTO gum_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Incha Leabe trenchibig køn: “Tiusbe nane purø tabigwan keta trandan cha. Møimbe nai keebe naba kørrømisra uñchun cha, kaguende nabe trattrø y kanba Jacobwan nusrkalø tranar” cha. Incha tru nusrkawane Zabulón munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Incha trugurrimbe Leabe kan nimbasr tøgagua, truigwane Dina munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Inchendø Tiusbe Raquelwan isub tøga wawa, nø miab megaigwan møra, ureg kønrrai tranig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Incha nøbe kwanrriig kørrømisra, tru srøsrø nusrkawan tøgamisrabe trenchibig køn: “Na chi urekkaig tsaløbala indinab unig købigwan trunun møimbe kerratan” cha. ");
INSERT INTO gum_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Incha treekkurri trunune José munchi pasrabe, trenchibig køn: “Jehová nan katøgan nusrkai trannrra chimubraita” cha. ");
INSERT INTO gum_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yandø Raquel Joséwan tøgamisren, Jacobpe Labanwan trenchibig køn: —Na tsuig købig tru pirausrømay inrrab, ibashcha cha. ");
INSERT INTO gum_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nai sralan trannrra cha, na truilaimburab mara tranøb megailan, nai nusrkalanba, nan yandø ibashcha chibig køn, kaguende nabe ñuyasig yeeg marøb megaigwan ñibe asha køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Inchen Labanbe trenchibig køn: —Ñuin kabyu na tabig asønainabene tiusmanda naba ka kørrømisr cha. Pøs Jehová nan øyeeg tabig nebub attrai mariibe ñigurri øyeeg kuin kui nabe tørgandø wetøbeña pasrar cha. ");
INSERT INTO gum_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Incha eshkarra chibig køn: ñi maya pagar utønrrab isuigwan, nabe treegwan pagaramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Inchene Jacobpe trenchibig køn: —Ñibe ashibig køn cha, nabe ñuyasig yeeg marøb megaigwan. Incha ñui ushameran nabe yeeg tab ashib tøgaguigwan. ");
INSERT INTO gum_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kaguendø na yu marøb meganrrab arrumøwatøbe ñibe trengatig nørrø tøga kømuig købig, møimbe yeeg nørrø nemisran cha, na yu puikkurri Jehovábe ñune mayanguen tabiitø nebuig kønrrai maran cha. ¿Inchendø nai ureemeraimbe nabe mana marøb pølbasramø?— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Inchene Labanbe trencha payibig køn: —¿Ñun chi tranamø?— cha. Inchen Jacobpe trenchibig køn: —Chigucha tranmørrunrrig cha. Na ñun øyeeg martra taigwan ñi tregwan martrab misrene si, nabe ñui ubishameran ashibig asamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nan møi ñui maya ubisha søtø utuwan pureb arruben, tsurø ubishameranba, rayas tøga ubishameranba, yalø ubisha— ureemeranba, katø maya cabra— ureezheelø tsureelanba rayas tøgarmeranba, ñi tarømarømarøb inrrig cha, Nai pagarbe truilø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Pøs Srøna trumarsrø tru na kanab megaigwan ñi ashchab arruben, tab marigwan kenamartrabibe truig kønrrun cha. Kabe kan ubisha kui, kabe kan cabra-unø kui rayas tøgar kømøwei, tsureelø kømøwei, kabe kan ubisha-unø yalig kømøwei, tru utu ñi treelø wetørrappe, trube, nabe ñuyelan nilab megaig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Inchene Labanbe trenchibig køn: —Ñi trendaig tab køn— cha. Labanbe treeg kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Inchen Labanbe tru kwalømdøwei møg cabramera sinda tøgarmeranba, tsureelanba, ishug cabramera sinda tøgarmeranba, tsureelanba, katø puliig tøgarmeranba chishtø, katø yalø ubisha-ureemeran kerriguba tarømara, nusrkalai tasku ashchai pønsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Incha tru ubisha søtømerane Jacob tsuisrøngurri pøn kwaløm ambiisrø srua ambubelø køn, nøm waraisrø. Trune Jacobpe nuimburappe Labanwei katøgan ubisha søtømeran ashib tsubig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Incha Jacobpe alamo srarmeranba, almendro srarmeranba, palanda tusrwanba para, trugurrimbe kaluswan karrøbig køn, pulø sindazhig kena kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Inchabe tru tsig karriilane tru ubishamera pi muchig kemalinug pønsrøbig køn. Incha ubishamera wambiimisrar tru pi mutsinug pubene, ");
INSERT INTO gum_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","tru carneromerabe ubishameran truyu nesraløbelø købig køn. Incha tru tsig karra pønsrainug nesralig kuig køppe, ubishamera lluiløbe rayas tøgarmera køben, tsureelø køben, pulig tøgar køben, llubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Incha Jacobpe tru ubisha-ureemerane nørømara, Labanwei ubishamerayu rayas tøgarmeranba yaleelanba Jacobpe nui ubisha søtømerayu keerøb ibig køn. Incha yandø nuyasig ubisha søtømera kønrrai marøb ibig køn. Labanweimba kanbalatø kømøtø. ");
INSERT INTO gum_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Incha tru mas werus asr tøga ubishamera wambiimisra pønrraimørig, Jacobpe tru tsig karriilan ubishamera pi muchib kemalinug pønsrøbig køn, tru ushamerain pinrøgue. Tru tsig karrig pønsrailan ashib nesraliilø kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Inchen tru tre asrka ushamera wambiimisra amrrubene, tru tsiimeran pønsrømíig køn. Inchagurri tru Labanweimbe tre asrkazheelø køben, tru mas werus asr tøgarmera larrø chisheløbe Jacobwein købig køn. ");
INSERT INTO gum_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Incha Jacobpe larrø puaig misrig køn, ubisha søtømera lata, karuig mendig melab møguelø lata, ishumburmera lata, camellosmera lata, burrusmera lata purø nørrø tøgaikke ");
INSERT INTO gum_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacobpe Labanwei nusrkalø øyeeg chib amønaigwan wam mørøbig køn: “Jacobpe namui møskaweiwan kerriguba nø tøgamisrøb kebya, truitøga møimbe larrø puaig misrin køn” chib kui. ");
INSERT INTO gum_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Inchagucha Jacob Labanwei maløwan ashene, maløbe ke mindiitø uñibig køn, merrabwan lataig kømøtøgue. ");
INSERT INTO gum_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Inchene Jehovábe Jacobwane trenchiptinchibig køn: —Merrabsrø ñui kølli misamerai pirausrømay katø inrrø cha. Ñui nammisaamera waraisrømay, nabe ñiba pasramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Inchen Jacobpe Raquelwanba, Leanba wamabig køn, tru nø ubishameran ashib tsuisrømay amrrunrrai. ");
INSERT INTO gum_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Inchabe nømune trenchibig køn: —Ñui møskaimbe nan merrabwan lataig kømøtø, maløbe ke mindindø, mindindø uni ashar cha. Inchendø nai møskawei Tiusbe naba pasraig køn chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ñimbe ashibelø køn cha, nabe ñimui møskawan na maya chish kuimburab chish kuitøga nabe mara tranøb megaig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Inchen køben ñui møskaimbe, treeg martrab chib treeg martrab chib marmuig køn cha nai pagarwan ke pa tratrø piejes yunømarøb. Inchen køben Tiusbe na chi tøgaguigwan Laban kaig marmønrrai nan søtø pasraig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nøbe, “Ñui pagarbe tsurø ubishamera kønrrun” chibeneh, trube, ubishamera lata, cabramera lata mayamba tsurø ureezheelø llubelø køn cha. Inchen: “Ñui pagarbe sindaba ubishamera kønrrun” chibeneh, trube, ubishamera lata, cabramera lata truiløgucha mayamba sindaba ureezheelø llubelø køn cha. ");
INSERT INTO gum_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Øyamay Tiusbe ñimui møskawei ubishameran lata cabrameran lata nørrø kerrawa, nan tranig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Indiibe kan pijibe ubishamera lata cabramera lata wambiimisra pønrrøben, nan piappe, treeg piatan cha: tru møg cabrazheelø cabrameran nesraløbeløbe sindabar køben, tsureelø køben kagømønrraindø tsurøzheelø køben treelø købashib. ");
INSERT INTO gum_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Inchen tru piabyube Tiuswei ángelbe nane trenchitan cha: “Jacob” cha. Inchen nabe trendainatan cha: “Nabe yu war” cha. ");
INSERT INTO gum_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Inchen nøbe nane trenchitan cha: “Ñiguen tab ash cha, tru møg cabrazheelø cabrameran nesraløbeløbe, sindabar køben tsureelø køben, kagømønrraindø tsurøzheelø køben, treelø køn cha. Nabe ashibig kur cha, Labanbe ñune maitø marøb arrigwan. ");
INSERT INTO gum_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nabe ñi tru srugwan aceite itølusha katø ñi ñuinetø øyeeg martrab cha kørrømisrinug tru Betelsrø kenamisrøb Tius kur cha. Møimbe kurra, i piraugurrimbe webya, ñi kal-lain pirausrømay katø inrrø” cha, nane trenchitan— cha. ");
INSERT INTO gum_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Inchene Raquelba, Leababe trencha løtabelø køn: —Nambe yandø namui møskaweinuube chi ketig utamibe chiga ker cha. ");
INSERT INTO gum_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","¿Pøs, namune ka mendailø kui lataig indig kømuitarru? cha. ¿Namune nøbe yana, truburø mara tranøb megaigwane nø chishtø maig kømuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Inchawei nø purø nørrø tøgaguilan Tius namui møskawan kerrawa ñun traniiløbe, kerriguba namuimba, namui nusrkalaimba kuig købene, møimbeTius nø maig mar taigwane ñibe kerrigu treeg mar— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Inchen Jacobpe tamarøb menda, nui nusrkalanba, nui sralanba camellosmerayu itøguanøsra, ");
INSERT INTO gum_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","nui ushameran kerrigu merranøbig køn, katø tru nø Padan Aramsrø chigurrimbunø tøgamisriilanbañau. Incha Canaán pirausrømay ibig køn, katøle nui møskai Isaac tsui pirausrømay. ");
INSERT INTO gum_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Inchen tru Labanbe nøørøsrø ubisha isig partrab yaig mugaabenbatø Raquelbe tru yau yau tøgagui tiusmeran søra wesrain købig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Øyamay Jacobpe tru Laban arameowane tru webya yamigwane chigucha mørø waminchimøtø, nilø purø may welula ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Incha Jacobpe nø kerrigu chi tøgaguilan srua, ashmøwatø welula ya, Eufrates nu piyu chab larrayabe, trugurrimbe Galaad tun ureemeragøba pirømerawansrø inrrab ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Indiibe pøn kwalømyube Labanwane eshkaptinchibelø køn: “Jacobpe welula, yain køn” cha. ");
INSERT INTO gum_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Indig Labanbe nui nammisaameran lincha pera, Jacobwan wetøgønrrab pasreb mendabig køn. Indigbe trattrø y pa kwaløm puraiben tru Gaalad pirau tunmerasrø chab wetøgøb ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Inchen tru yem tru Laban arameowane Tiusbe kan piabyu kenamisra, trenchibig køn: “Isuptø mar cha. Chigøben martrumøn chib tsag, tsag waminchab kømø.” ");
INSERT INTO gum_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Indig Labanbe Galaad tunmerasrø wetøgøbig køn, tru Jacob nui yaueløba kørrømisriisrø. Incha Labangucha trusrøndøwei nui nam misaameraba kørrømisrabe, ");
INSERT INTO gum_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Jacobwane trenchibig køn: —¿Chi mara pasrøgu? cha. ¿Nane chindimbarre øyeeg may kebenøsrkøgu? cha. Kan ñigui nai nimbasrmerane kwayabyu kemøri ishumburmeran kui lataig srua yaitan cha. ");
INSERT INTO gum_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Chindimbarre nane øyeeg kebenøsrkøb, trubatø nilø welula igu? cha. Nane chigucha eshkamøtøbe. Nan eshkaig kuimbeh, tab amrrigay cha, kantab, palø ichib, arpa kønab kasraatø ñimun treeg ungua cha ørøbsrubraig kuinrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ñibe nai awelu ureemeran nai nimbasrmeran ungua cha muchanrrainguengaig maritan cha. Ñibe møimbe ni kan chuguinguen mørmíig lataig marin køn cha. ");
INSERT INTO gum_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Pøs nabe ñun chi marøg køben maramigwan tøga pasrar cha. Inchendø ñui møskawei Tiusbe mira yem øyah chitan cha: “Jacobwane isuptø mar cha. Chigøben martrumøn chib tsag, tsag waminchab kømø”. ");
INSERT INTO gum_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ñui møskawei yauwan truba isub pesrøgøben inrrab yabe, trube, ¿nai tiusmerane chinchab nila sruaigu?— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Inchene Jacobpe Labanwane trenchibig køn: —Kaguen nane kørig kuig køn cha, inchippa ñi ñui nimbasrmeran nan namiimay kebya kerraptinchaitamab. ");
INSERT INTO gum_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pøs tru ñui tiusmeran møig køben yu tøga wabiibe kwanrrain chibig køn. Nai yauelø testigos kønrrai cha nai chi tøgaguigu, chitø ñuyelø køtashchab ñiashib lau,— chibig køn. Inchendø Jacobpe Raquel nemøra srua arritamappe chiguen isumuig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Inchen Labanbe Jacobwei carpa yasrø kebya, trugurrimbe Leain carpa yasrø, katø tru pailø karui mørøb melab ishumburmeraisrø lab kebya, kalawa, tru Leai carpayugurri webarruabe, yandø Raquel waisrø lab kebig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Inchen Raquelbe tru tiusmeran nemøra kan camelloi tsølig umbu warøppa, trubala wamisrøppa wabig køn. Inchen Labanbe tru carpa yau kerriguh lawa, kalaben, ");
INSERT INTO gum_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raquelbe møskawane trenchibig køn: —Nai møskai, na ñui merrab kurrømubene, ñi nan namømørrunrrig cha, kaguen nabe chillig misraig war cha. Inchen Labanbe tru taska marig tiusmeran wetørranrrab kaima lab uñen, ");
INSERT INTO gum_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacobpe truba nama, øyeeg chib namab mendabig køn: —¿Nabe ñune chi kalø marta? cha. ¿Naimbe chi kalø mari pasra? cha, ñi nan ke chinchimmørø inchib nan wendautø pasra attraimbe. ");
INSERT INTO gum_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ñibe nai chi købeløyu chishtø lawa, ¿ñui yau pønrrabelan chi wetørragu? cha. Inchawei ñi chi wetørrawabe, yu nai yauelai merrappa, ñui yauelai merrappa pønsrø chibig køn, nam pailainug møig søl pasrai kui nøm ashchai. ");
INSERT INTO gum_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Na møi ya pib trattrø pilamera na ñuyasig marøb megaben, mana ñui ubishamera, ñui cabramera lutø llumuig køn cha. Katø nabe ni managuen ñui ubisha søtømerayugurri carnero kandøguen ma kømøwein kur cha. ");
INSERT INTO gum_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nabe managuen kan kaambu namig usha kwabasiilanguen ñune srua arrumíig kur cha. Treeg kømøtø, truburøbe naguen ñun pagaramig købig køn cha. Kan trutø kønrrab kuindø ¿kwaløm niligwan lata, yem niligwan lata ñibe nan, nan ulø payibig kømøtirru? cha. ");
INSERT INTO gum_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kwalømbe nabe pachig købiitø kwamdiig kui megab, yemmerawane kørrag købiitø kwamdø kui megainaben, kiguen pumíig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Pilamera pib trattrøh nabe ñui yau megaig køn cha. Ñui pa nimbasrmeran nan tranamweimbe pilamera pa trattrø y pib pilaba mara tranøb megaig køn cha. Inchen trattrø y kanbabe ñui ushameraimburø megaig købig køn cha. Inchen nan pagaramigwane katø, katø peemayh, peemayh ñibe yunømarøbig køn cha, pa trattrø piejes yunømarig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nai møskai Abrahamwei Tius, nai møskai Isaac truba kørig tøga pasrai Tius naba pasrømuig kuimbeh isa kømøtø, ñibe nane chigucha chigaig inrrai ørøbsruig kuitan cha. Inchen ñi nan yeeg kaig inchen isui megaig købigwanba, na mandø mara tranøb megaiwan købigwanba, Tiusbe trunun ashib wawa, ñune mira yem øyeebe kalø marmøta chib mur wamindiinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Inchen Labanbe Jacobwan trenchibig køn: —I ishumburmerabe nai nimbasrmera køben, nøm tøgaguig ureemerabe nai awelumera køben, ubishamerabe nai ubishamera køben, cabramerabe, nain cabramera køben chigurrimbunø yu kena købiibe nayelø køn cha. Treeg kuindøgucha nabe nai nimbasrmeranba, katø nøm tøgagui nusrkalanbabe nabe katøle nayelø kønrraimbe yandø chi maramgaig køtan chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Incha møimbe amø chibig køn, naba ñiba øyamay kønrrai mara kørrømartrab cha. Tru treeg mariibe nainuuba, ñuinuuba øyah kørrømarigwan isunanøb pasrønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Inchabe Jacobpe kan nu srugwan malsra, ølneb kusrua pasrabe, ");
INSERT INTO gum_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","tru nui yau misaamerane trenchibig køn: —Sruumera tulisay— cha. Inchen truiløbe sruumera tulisha, tun pasrabe, tru tun pasrim puluh kanbalatø purramisra mabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Inchen Labanbe truyu nuin triimaybe ‘Jegar Sahaduta’ cha wamøbene, Jacobpe nui triimaybe ‘Galaad’ cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Inchene Labanbe trenchibig køn: —I srug tun pasriibe møi naimba, ñuimba treeg kørrømisrigwan eshkab pasrønrrabig kørrømisran— cha. Inchagurri truyube Galaad taig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Incha katø Mizpagucha taig købig køn, kaguen Labanbe trendaig købig køn: —Nam ñiba kanikkurri, kanikkurri yandø katøbe asiyamig nebumuben, nam maig inchibelø køtashchab Jehová nø ashib pasrønrrain cha. ");
INSERT INTO gum_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Inchippa nai nimbasrmeran ñi kaig inchib, maig købash inchib, kabe nai nimbasrmera kømnetø ñi katøgan ishumburmeran pera arrin kui inchen, namune mu katøgan ashib pasrømuingucha, ñuimba, naimba øyah marig køn chib, Tius nø eshkab pasrønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Incha katøgucha Labanbe Jacobwan trenchibig køn: —Ash cha, i tru srug tun pasrigwanba, katø tru srug ølneb pasrigwanba, na tru naimba, ñuimba tøbøtag pasrigwan. ");
INSERT INTO gum_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Iig tru srug tunbasriiba, srugwan ølneb kusrua pasriibabe øyah marig køn chib isunanøb pønrrønrrabelø køn cha, nagurri ñuimay purøbunamig kømønwei, katø ñigurri naimay purøbunamig kømøwei kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Inchen ñui awelu Abrahamwei Tiusba, katø ñui awelu Nacorwei Tiusba maig maramigwan namun nø asha martrain— chibig køn. Inchen Jacobpe tru nui møskai Isaac kørig tøga pasraig Tiuswei merrab: “¡Katø! marmø kømø, nabe treeg maramønrrun” chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Incha Jacobpe tru tunbalasrø Tiuswan keta, trannrrai ushamera kweecha, tru nui yau misaameran mamiimeraba manrrab amrrunrrai wamabig køn. Inchen truyu mayeeløba ma, tru tunyu kibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Incha katø løtsø Labanbe kia kurra, nui awelu ureemeran, nui nimbasrmeran muchawa, trugurrimbe mayanguen tabig nebuilø kønrrigay cha. Yandø nui pirausrømay katøle inrrab ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Inchen Jacobpe nui yamigwan legucha iben, nune Tiuswei kan angelesmera katønrrab werruben, ");
INSERT INTO gum_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacobpe truilan ashabe, trenchibig køn: “Yube Tius nui angeles søtømeraba kørrømisra pasrainug køn” cha. Incha treekkurri truyube Mahanaim cha wamabig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Incha Jacobpe tru Edom pirau tru Seirsrømay wan sruar merrab amrrai ørøbig køn, Esaúwan katønrrabelø tru nabe punrrab arrumønrrun cha, nui nuneg eshkanrrabelø. ");
INSERT INTO gum_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Incha øyeeg chinrrai karua ørøbig køn: —“Ñi nai mayur nuneg Esaúwan Jacob na ñi maig chiben megabiibe, trendan cha: ‘Nabe møi øyangatig Labanba kørrømisra tsua, ");
INSERT INTO gum_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","møimbe waaramera køben, burrumera køben, ubishamera køben, cabramera køben, karuig melabelø møguelø køben ishumburmera køben, tøgaig kur’ tan chinrrai. Pøs ñi nai mayur nunewan nabe ñun øyeeg eshkawa ørar cha, ñi nan truba tabig utig pasramig kønrrai.”— ");
INSERT INTO gum_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Inchen tru wam srua ambubeløbe Jacobweimay katøle amrrua, trenchibelø køn: —Ñui nuneg Esaú waisrø ashchab amber cha. Nøgucha ñun katønrrab arrun cha, møguelø cuatrocientos lincha peraig.— ");
INSERT INTO gum_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Inchen Jacob øyeeg taigwan mørabe, truba kørig kui inchib, truba isuin kørrømisra, nøbe tru nui misag lincha perayailan pa søtø pirishibig køn, tru ubishameran, cabramera køben, waarameran, camellomeran chigucha. ");
INSERT INTO gum_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Pøs nøbe treeg isubig køn: “Inchippa Esaú kan søtøwan kwayanrrab megambuingucha, katøgan søtøbe lulrrain” cha. ");
INSERT INTO gum_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Incha Jacobpe Tiuswan trenchib miabig køn: —Nai møskai Abrahamwei Tius, nai møskai Isaacwei Tius: “Tru nai pirausrømay, nai yau misaameraisrømay katøle nan inrrø cha. Ñune truba truba tøgaig misrøb inrrai maramønrrun” cha, ñi nan trendaig kuig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Na ñi karuigwan marøb megabiibe ñi larrø tab indigwanba, ñi trendø treeg tabig køppe treeg mariilanba na truigwan utab pasramibe nabe trengatig truburab kømuinatan cha. Pøs, nabe i Jordan nu piyu larreb urasbe i pøtønain tsiizhiitø srua pasraig køben, trune møimbe nuingui, nuingui pa søtø tarømara pasramig tøga pasrar cha. ");
INSERT INTO gum_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nai nuneg Esaúwei taskugurri chi kømønrrai marøbsrumuguh cha. Nane kørig køtan cha, inchippa nanba, usralmeranba, ureemeranba kweecha petønrraitamab. ");
INSERT INTO gum_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ñitøwei nane trendaig køn cha: “Nane maya nuguen tabig nebuig kønrrai mara, nainukkurri amrrub misaamerabe purø nørrø køptø, mar menda kan pisrum lataig kønrrun cha, mundamguengaikke.”— ");
INSERT INTO gum_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Incha tru yembe Jacobpe truyu kia, nø truyu chi tøgaguigwan nui nuneg Esaúwan ketamig lawa wesrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Cabramera doscientas, pib trattrø turmøg cabramera, ubishamera doscientas, turmøg ubishamera pib trattrø, ");
INSERT INTO gum_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Camellasmera ureg perarcheelø treinta, waaramera cuarenta, toro-ureemera pa trattrø, asnasmera pib trattrø, pa trattrø burrusmera. ");
INSERT INTO gum_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Incha tru nui karuig mendig melabelai tasku tru ushameran nuingui kan søtø, kan søtø pønsra, tru nui mendig melabelane trenchibig køn: —Nai merrab ambay cha. Incha tru tarømarig søtømerane kanguetøtø kømøtø, yabsrø, yabsrø merranrrigay— cha. ");
INSERT INTO gum_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Incha Jacobpe tru ke srøsrø merrana ibigwane trencha karua ørøbig køn: —Nai nuneg Esaú ñun kata: “¿Ñibe muinukkurriig kugu chib, chumay inrrab arrugu? chib. ¿Ñi merrana yaig ushamerabe muielø kø?” chib payene, ");
INSERT INTO gum_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ñibe øyah chib løtønrrig cha: “Ñun ketamig ñi nai ashib karubig ñi Esaúwein køn cha, iilane ñi maig chiben marøb megabig, tru Jacob, keta trana øran cha, nui ushamerayugurri. Inchagucha nøbe namui wendau arrun” chinrrig— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Incha tru srøsriigwei wendau ibigwan lata, pøn kønrrabyu ibigwan lata, tru wendau ambubelan møilandøgucha treetø, treetø chinrrai karua pasrig køn. Esaúwan katabe, øyeetøh chinrrigay cha. ");
INSERT INTO gum_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Incha katø trenchinrrigay cha: “Ñui karuig megabig Jacobpe namui wendau arrun” cha. Kaguen Jacobpe treeg isubig køn: ‘Tru na keta trana øriilanmerrig nun pungaruabe, tru nø namig kørrømisrig købig yandø kuchi tammisren, trugurrimbe nui maløwan asamønrrun’ cha. ");
INSERT INTO gum_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Inchen tru keta tranameløbe merrab chab amben, Jacobpe tru nui misaameraba, nui ushamerabañau kørrømisra tsuinug kinrrab kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Incha tru yemdøwei Jacobpe kurra, nui pagatø sralanba, nui pagatø linchatø melab ishumburmeranba, pa trattrø y kan tru nui nusrkalanba, Jaboc taig nu piyu larraambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Incha yandø truilan chab larrøørabe, katø chine købigwan kerrigu larrøørøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Incha Jacobpe tru misaameraba, nui ushameraba kørrømisra tsuinug nøtø kørrømisra, kan møøba tør-rramnegatig kwayab tranrriyabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Inchen tru møøbe Jacobwane chinchaguen kullaaranamgaig kui ashabe, srøptsim merrarrab srølwan kebachen safabig køn, tru kemøriyab tranrriyabyu. ");
INSERT INTO gum_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Inchen tru møøbe trenchibig køn: —Yandø chab tør-rrab køn cha. ¡Elatcha!— cha. Inchene Jacobpe trenchibig køn: —Ñi nan maya nuguen tabig nebunrrabigwan tranmubene, nabe lelachimumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Inchene tru møøbe: —¿Ñibe chi munchi kugu?— cha payen, Nøbe: —Jacob munchi kur— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Inchene tru møøbe trenchibig køn: —Ñibe yandø Jacob cha wamig kønrrabig kømøtø, Israel cha wamig kønrrabig køn cha. Kaguende ñibe Tiusba, møgueløba truba melambuyab tranrriyaigu, ñibe kullaaramøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Inchene Jacobpe trencha payibig køn: —¿Ñibe chi munchi kugu?— cha. Inchene tru møøbe trenchibig køn: —¿Nai munchiwane nane chinchab paygu?— cha. Inchen tru møøbe truyutøwei tru mayanguen tabig nebuig kønrrabigwan nune tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Incha Jacobpe truyube Peniel cha wamabig køn; kaguen nøbe trendaig køn: “Nabe Tiuswan malaugue ashendø, katøgucha ka øsig pasrainatan” cha. ");
INSERT INTO gum_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Inchen Jacob Penielsrøngurri puraiben, pørrbe neeshib arrubig køn. Inchen nui pøytañig safaig pusrkwaben, Jacobpe kebeñiptø, kebeñib arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Incha treekkurri Israelweinukkurri amrrub misaamerabe møingatig tru ushamerayu pøytañig kemørøb srølwane mameelø køn, kaguen Jacobwane tru srølyu kebatig kuig kua. ");
INSERT INTO gum_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Møimbe Jacob kurraashene, Esaúbe arruptinchibig køn, tru cuatrocientos møguelan pera. Inchen Jacobpe nui ureezheelan kanelane Leai merrab, kanelane Raquelwei merrab, kanelane pagatø nui tru karuig mendig melab ishumburmerai merrab øyamay pirisha merranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Incha tru nui pagatø karub tøgagui ishumburmeran tru nømui ureemeran ke merrabsrø pønsra, tru wendaube Lean tru nui ureemeranba, tru wendaube Raquelwan tru nui Joséwanba pønsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Incha Jacobpe kerrigu mayeelai merrabsrø puraya, pirausrøngatig trattrø y pagatøgatig utsøbasrøbig køn, nuneg waisrø pumnegatig. ");
INSERT INTO gum_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Trune Esaúbe nunewan katønrrab luløb ya, naashiburab ira, muchabig køn. Incha pailøba kishibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Incha møimbe Esaú kurraashabe ishumburmeranba, ureezheelanba ashabe, trenchibig køn: —Iilø ñiba pønrrabeløbe ¿mumeragøh?— cha. Inchene Jacobpe trenchibig køn: —Na, ñi maig chiben marøb megabigwan, iiløbe Tius nan trani ureezheelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Inchen tru pagatø karuig melab ishumburmera nømui ureezheeløba amrrua, utsøbasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Trugurrimbe Lea nui ureezheeløba utsøbasren, tru wendaube Raquel nui Joséba arrua, utsøbasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Inchen Esaúbe trencha payibig køn: —¿Tru na katab arrigu øyeeg nørrø søtø, merrana amrruiløtøgabe nan chi chinrrab treenchigu?— cha. Inchen Jacobpe trenchibig køn: —Ñi nane kan chigucha inchimø, ñuin kabyu tab kui asig kønrrab øyeeg marar— cha. ");
INSERT INTO gum_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Inchene Esaúbe trenchibig køn: —Nai nuneg, nabe tsabøtø tøgaig kur cha. Ñuimbe ñuin kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Inchene Jacobpe trenchibig køn: —Ñuin kabyu na tab kui asig kuinabene, tiusmanda na kettrab srua arrigwan utørra chibig køn. Na ñui maløwan asiibe Tiuswan asi lataig køtan cha. Ñibe nane kan yangucha tabig utøtan cha. ");
INSERT INTO gum_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Na ñun ketamig srua arrigwan ka utørra cha. Tiusbe nane øyeeg nørrø tøgaig kønrrai maren, nabe menrrazhikken tøgagur— cha. Incha Jacobpe utønrrai truba inchen, Esaúbe tru ketiilan ka utabig køn. ");
INSERT INTO gum_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Incha Esaúbe trenchibig køn: —Ambamigwan amun cha. Trube, naba lincha amun— cha. ");
INSERT INTO gum_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Inchene Jacobpe trenchibig køn: —Nai nuneg, ñibe asiinrrabguen cha, nai ureemerabe kullaguelø srø køn cha. Katø ubishamera køben, waaramera køben, ureezheelø perartø køn cha. Na menrra trømbøig malla merranene, nai ubishamerabe kan kwalømyutø kerriguba chab kwanrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ñi, nai ashib karubiibe, ñi karuigwan marøb megabigwei merrabmisra ka ashirrunrraguh cha. Nabe nai ubishameran køben, cabrameran køben, waarameran køben, merraniilø maig amben, nabe tsøndatø treeg arrumønrrun cha. Katø ureezheeløgucha nøm maig ambub meløben, tsøndatø treetø arrumønrrun cha, Seirsrø ñun wetøgamsrøngatig.— ");
INSERT INTO gum_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Inchen Esaúbe trenchibig køn: —Trube, treeg ka amrrab cha. Inchendø tru naba lincha amrrub møguelan møilan køsrøn ñiba lincha amrrunrrai kørrømartrab— chibig køn. Inchene Jacobpe trenchibig køn: —Truburappe chi isumøta cha. Ñuin kabyu na tab kui asig kuinaig købene, truig mas purø nuig køtan— cha. ");
INSERT INTO gum_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Incha tru kwaløm Esaúbe Seirsrømay inrrab ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Inchen Jacobpe Sucotsrømay ya, trusrømbe nuyasig kan ya marøb, nui ushamerai ranchu-ureemera marøb inchibig køn. Incha treekkurri trusrømbe Sucot cha wamig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacobpe Padan-Aramsrøngurri chigucha kømø, katø tab ka pubig køn, Canaán pirau Siquén ciudasrø. Incha tru ciuda pinrrøguesrø kørrømisra warøwa, ");
INSERT INTO gum_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","kan tul penabig køn, tru Hamorwei nusrkalan. Incha truibe Siquénwei møskawan, tsantsøn andøga mari monedasmera sulu cien pagaraig køn. Incha truyu nui carpa yawan lasrua tsumisra, ");
INSERT INTO gum_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","truyube kan altar mara, truigwane El Elohe Israel cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jacob Leaba kan nimbasr Dina taig tøgaguibe tru pirau ishumburmeran ashib pub inrrab webya ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Inchen tru heveo truyu ashib karubig Hamorwei nusrkai Siquém ashabe, Dinane kemøra, kaig mara mindisha kørrømarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Incha nøbe Dinan purø chull ashipptø, tabzhib waminchibig køn, Dina undaaraig kønrrab. ");
INSERT INTO gum_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Incha Siquémbe nui møskai Hamorwan trenchibig køn: —I srusran nai srain kønrrai møskaløba waminchay— cha. ");
INSERT INTO gum_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Inchen Jacobpe tru nui nimbasr Dinan Siquémbe kemøra, kaig mara mindisha kørrømarin kui wammørøbig køn. Inchen nui nusrkaløbe tru purugubeløba trausrø ushamera ashib warøben, tru nusrkalø katøle pumne chigucha waminchimíig køn. ");
INSERT INTO gum_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Incha pumøwatø, tru Siquémwei møskai Hamorbe nui nusrkai pa misrtrab isuigwan Jacobpa waminchab arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Inchen tru Jacobwei nusrkaløbe traugurri chab pua, tru treeg purayaigwan wammørabe, karre øyeeg maritamab isub, larrø namig kuig mørøbelø køn, kaguende Siquénbe Israelwei yau misagwan purø trømbøig mara pasren tru Jacobwei nimbsrwan kemøra, øyeeg mindishib. Pøs øyeebe ni managuen maramig kømíigwan. ");
INSERT INTO gum_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Inchen Hamorbe tru møskawanba nusrkalanba trenchib waminchib køn: —Nai nusrkai Siquémbe ñui nimbasrwan purø chull asan cha, ishug-unø nøba kasharanrrai treegwan isubsrumøgue chinrrab inchar cha. ");
INSERT INTO gum_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Yau misaamera misrkun chibig køn, ñimbe namui nimbasrmeran sralø maren, namuieløbe ñimui nimbasrmeran sralø martrain cha. ");
INSERT INTO gum_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Trumaybe ñimbe namui utu warøben, yu nam waraig pirøbe ñim chu warag køben waramig pasrønrrun cha. Ñimbe truyu warab, penab, yanøb, katø pirømera penab inchigay— cha. ");
INSERT INTO gum_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Inchen Siquémbe nuimburappe tru Dinai møskawanba, nuchalanba trenchibig køn: —Na ñimuin kabyu tab asønainabene, ñim maig miabendø, nabe tranamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tru srusran srain kønrai tranamwei maya nu kuindøgucha, ñim maya miamigwan eshkab, maya ketig tranamelan eshkab inchay chibig køn. Inchendø tru srusrane naba ka kasharabashchunrrigay— cha. ");
INSERT INTO gum_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Inchen Jacobwei nusrkaløbe tru møskai Hamorwanba Siquémwanba purø may kegørrøsrkønrrab isua løtabelø køn, kaguen nømui nuchag Dinan kaig kui lataig purø trømbøig marøb mindisha kørrømarikkurri. ");
INSERT INTO gum_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Incha nømbe trenchibelø køn: —Nambe namui nuchawane kan møg circuncidamíigwane trannrrab kaimamønrrun cha. Kaguen namuiwan purø trømbøig mindishib kørig marinab pønrramig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Pøs, nambe treeg punrrai martrab cha ñim øyamay martrab kørrømisrene, ñimui utu maya møgueløba circuncidawabe kønrrun cha, nam latailøwein kønrrab. ");
INSERT INTO gum_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Trumaybe si namui nimbasrmerabe ñimba kasharab, ñimui nimbasrmerabe namba kasharab, nambe ñimui utu warab, kan søtø misaameratø kønrrab cha. ");
INSERT INTO gum_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Inchen tru circuncidamigwan ‘ka’ taingatiibe nambe namui nuchawane perøb, yu ñimui piraugurri ambuptindamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Inchene Hamorwanba Siquémwanba tru øyeeg margun taigwane truba tabig mørørai inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Inchen tru matsinube mallatø circuncidabig køn, kaguen nøbe Jacobwei nimbasrwane purø chull asha kuig kua. Inchagucha Siquembe nui yaube mas nuig kuig asig møg købig køn. ");
INSERT INTO gum_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Incha Hamorba Siquémba nømui ciudayu kebambi yaskabumay amba, truyu warab misaameran trenchibelø køn: ");
INSERT INTO gum_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—Tru møgueløbe kwa tammayelø køn cha, nømbe yu namuim pirau warønrrab amrrua warab, namuin pirau penab, yanøb inchib kønrrain cha, kaguen pirømerabe nøm kørrømisra waramig tsabøtø lendø køn cha. Nambe nømui nimbasrmeran sralø maren, nømbe namui nimbasrmeran sralø martrun cha. ");
INSERT INTO gum_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Inchendø namui utu nøm kørrømisra, kan misag søtøtø misra waramibe nam øyamay kønrrab købendøwein kønrrun cha, namui utu møgueløbe mayeeløba circuncidawar kønrrai, nøm mailø køben, nam treeløtøweingue. ");
INSERT INTO gum_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Inchawei nøm maig tailan ka løtøgun chibig køn, nøm namui utu warønrrab kørrømisrtrain cha, kaguende nøm chi tøgaguiløba, nømui ushamerababe, namuin kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Inchen tru chi maramigwan nøm ashibelø maya møguelø tru ciudayu kebambi yaskabu tuluntsunabeløbe tru Hamorba, tru nusrkai Siquémba treegwan martrab pønrramisrøbelø køn. Incha tru maya møgueløbe circuncidailø kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Indiibe pøn kwalømyu tru circuncidailøbe pusrkwailø purrøbenh, Jacobwei pagatø nusrkalø tru Dinai nuchaløbe Simeónba, Levíba nømbe espadan srua ambubelø køn, tru ciudayumay, truiløbe ni chigucha chi isumø køben, maya møguelan chishtø kweecha petabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Incha Hamorwanba nui nusrkai Siquémwanba espadatøga kweecha peta, Dinane Siquémwei yaugurri wesrawa, pera ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Incha tru Jacobwei katøgan nusrkaløbe amrrua, kwabelaim palawan itøbunab puraamba, ciudayu kegørra chi købigwan chishtø wesrabelø køn, tru nui nuchawan øyeeg trømbøig mara mindisha kørrømarigwan trunun ulø payib. ");
INSERT INTO gum_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Incha ubishameran køben, cabrameran køben, waarameran køben, burrumeran køben, srua ambubelø køn, ciudayuigwan lata, wambigwan chi købigwan lata. ");
INSERT INTO gum_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Incha yaambumerayu chi købelane chishtø wesrawa, katø chigurrimbunø chi tøgaguilan køben, møg-uregwan køben, ishumburmeran køben merrarrawa, srua ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Inchen Jacobpe Simeónwanba, Levíwanba trenchibig køn: —Ñimbe nane purø nuigu mumayguen kømíig meganrrai martan cha, cananeomeraba, ferezeomeraba i pirau misaamera namun larrø tsalø asiilø pønrramig kønrrai ñimbe treeg marøb. Nabe ya mamdø møguelø tøgagøben, nømbe kanbalatø lincha, namune kwayanrrab melambua, nanba nai yau misaameranba pinisha petønrrautan— cha. ");
INSERT INTO gum_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Inchene nømbe trencha løtabelø køn: —¿Nø isuppe, kabe namui nuchawane trømbøig martrab nui asrwan anwei yanøb ishug kui lataig mara kutchain kuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Tiusbe Jacobwane trenchibig køn: —Kurrab, Betelsrø tsunrrab inrrø cha. Trusrømbe, tru ñui nuneg Esaúwan ñi trubab arruben kenamisrøb Tiuswan kan altar kusrunrrig— cha. ");
INSERT INTO gum_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Inchen Jacobpe tru nui yaambuelanba, nun lincha amrrubelanba trenchibig køn: —Tru katøgan peg tiusmera ñim tøgaguilan ñimbe chishtø webetab, ñimui kalø mariilan chish misrøb, ñimui kewaguilan yunømarøb inday cha. ");
INSERT INTO gum_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Betelsrømay amun cha, tru nan chine kaig nebuinab arrubengurri purugub Tiusweyasig trusrø kan altar kusrunrrab cha, tru na chu unindøgucha nan lincha pasrabigwan.— ");
INSERT INTO gum_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Inchen nømbe tru taska marig peg tiusmera nøm tøgaguilan kerriguba Jacobwan tranøbelø køn, katø kaluyu kandunga melsraguilan chigucha. Inchen Jacobpe kan encina tusr keta truilan sørabig køn, tru Siquém pulu. ");
INSERT INTO gum_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Inchen nøm truyugurri webamba ambene, tru puluwan warab misaamerabe mayeeløba purø trømbøig kørig kui inchai Tiusbe treeg marøbig køn. Inchagurri Jacobwei misaamerane nømbe chi kaig martrab inchimeelø køn. ");
INSERT INTO gum_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Incha Jacobpe maya misaameraba Luz cha wamiisrø pubig køn, tru Betelsrø Canaán pirau. ");
INSERT INTO gum_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Incha nøbe trusrø kan altar kusrua, El Betel cha wamig køn truyube, kaguende Tius trusrø kenamisrig kuig kua, tru nui nunewan trubab welula ib uras. ");
INSERT INTO gum_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Inchen katø truyuh kwaig købig køn, Debora tru Rebeca lamíig køben asam purugubig købig. Truigwane kan encina tusr katsiizhigu sørig køn, Betel pulu. Incha Jacobpe truyube Elon Bacut cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Incha Jacob Padan Aramsrøngurri katøle arrubene, Tiusbe nune katøle kenamisra, maya nuguen tabig nebuig kønrrai trannrrab misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Incha Tiusbe trenchibig køn: —Ñibe Jacob munchi køn cha. Inchendø møimbe Jacob cha wamig kømøtø, ñui munchibe Israel cha wamig kønrrabig køn— cha. Incha Israel cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Incha katø Tiusbe trenchibig køn: —Nabe tru Maramburab Marøb Tius kur cha. Misag purø nørrø karrab, larrø nørrø larrøbichig cha. Ñuinug kan larrø nu misag søtømera kal-lawa, ñuinukkurri misag larrø nørrø søtømerabatø kurrab amrrunrrun cha. Incha ñuinukkurri amrrub misaamerayugurrimbe reymera kurrønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Incha Abrahamwanba, Isaacwanba tranin pirøwane ñun tranamønrrun cha. Incha ñuinukkurri amrrub misaameran tranamønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Incha Tiusbe nuimbulugurri ibig køn, tru nøba waminchib pasrainukkurri. ");
INSERT INTO gum_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Inchen Jacobpe kan srug nemøra, ølneb pasrøbig køn, Tius tru nun wamindinug. Incha trubalabe pi lusha, aceitetøga itølushibig køn Tiuswan keta tranøb. ");
INSERT INTO gum_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Incha Tius tru nun wamindinuube Betel cha wamabig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Incha Betelgurri amba, katøgucha Efratasrø pumibe yab paløben, møimbe Raquelbe unøzhigwan ke tammisrtrab kaimabsrua tammisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Inchen ke purø lastimazhig pusrkwai inchib megaben, tru patsø kørrøørøbiibe trenchibig køn: —Chi kørig isumøta cha, ñibe katø møg-unøzhig tøgagønrrab køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Inchen nøbe yandø ke kwanrrab inchib ke srabe israb megawa, unøzhigwane Ben-Oni cha wamabig køn. Inchendø møskai Jacobpe Benjamin munchi pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Incha Raquelbe øyeeg kwamig nebuig kwaben, Efratamay amrrab ambi maysrø sørig køn, tru Belén. ");
INSERT INTO gum_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tru kwabigwan sørimbalabe kan srug nemøra ølneb pasrig køn. Incha tru treeg tamara kusrua pasrig købiibe tru Raquelwan sørig købig kui ashchai pasran møingatig. ");
INSERT INTO gum_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Incha Israelbe tru nø yamigwane ibig ya, Migdal Edargurri mas yab yaisrø nui carpa yawan lasrua kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Indiibe Israelbe tru pirausrø kørrømisra tsubene, Rubénbe ya, Bilhaba kiain købig køn, tru nui møskawan lincha tsub ishuuba. Inchen Israelbe øyeeg marigwan wammørøbig køn. Israelwei nuskaløbe pa trattrø y par købig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leai nusrkaløbe iilø køn: Jacobwei mayur nusrkai Ruben, Simeón, Leví, Judá, Isacar, Zabulón. ");
INSERT INTO gum_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raquelwei nusrkaløbe: Joséba, Benjaminba. ");
INSERT INTO gum_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Inchen Raquelwei tru karuig mendig megabig Bilhai nusrkaløbe iilø køn: Danba, Neftaliba. ");
INSERT INTO gum_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Inchen Leai tru karuig mendig megabig Zilpai nusrkaløbe: Gadba, Azerba. Iilø køn tru Jacobwei nusrkalø Padan Aramsrø kal-lawar. ");
INSERT INTO gum_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Incha Jacobpe Isaac nui møskawei yausrømay ibig køn, Mamre taisrømay Kiriat Arba pulusrø, tru Hebrón cha wamiisrømay, Abrahamba, Isaacba tsuig købiisrømay. ");
INSERT INTO gum_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaacbe tru nø kwab uras pilamera ciento ochenta tøgaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Inchen Isaacbe yandø larrø kølliizhig, larrø yana øsig tsua, yandø nui israbig luchen, nui nusrkalø Esaúba Jacobpa misra kusra sørøben, nui kølli misaameraba isrønrrab tsumisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iilø køn tru Esaúweinukkurri amrrub misaamera, tru Edomwei. ");
INSERT INTO gum_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaúbe Canaán ishumburmeraba kasharaig køn. Tru Elon hititai nimbasr tru Adaba katø Aholibamababe Anai nimbasr køben, truibe Zibeón heveowei awela kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Katø Basematwangucha nui srain kønrrai marig køn, truibe Ismaelwei nimbasr Nebaiotwei nuchawan ");
INSERT INTO gum_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esaúbe i ureemeran tøgaguig køn: Adababe Elifazwan Basematbabe Reuelwan; ");
INSERT INTO gum_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aholibamababe Jeúswan køben, Jalánwan køben, Coréwan køben tøgaguig køn. Iilø kuig køn tru Esaú Canaán pirau tsub uras tøgagui ureemera. ");
INSERT INTO gum_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Incha Esaúbe nui sralan køben, nusrkalan køben, nui nimbasrmeran køben katø tru nøba lincha warab misaameran køben pera, tru Jacob nui nuneeba tarømisrtrab katøgan paløsrømay ibig køn. Incha ushameran kerriguba katø Canaán pirau nø chi tøgamisriilane chishtøh srua ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Jacobpa Esaúbabe purø nørrø tøgamisrøptø, pailøba kanbalatøbe waramgaig købig køn. Inchagucha tru nøm waraig pirøbe ushameran mannamig truburab tranmíig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Treekkurri Esaú tru Edom taibe Seir pirau tunmeragøba tøgasrø tsunrrab yaig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iilø køn tru Esaúweinukkurri amrrub misaamera: edomitasmerai møskai tru Seir tunmeragøba tøga pirømerasrø warab misaamera. ");
INSERT INTO gum_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Inchen tru nui nusrkalai munchimerabe iilø køn: Esaúwei srai Adai nusrkai Elifaz køben Esaúwei srai Basematwei nusrkai Reuel købengue. ");
INSERT INTO gum_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Inchen Elifazwei nusrkaløbe Temán køben, Omar køben, Zefo køben, Gatan køben, Kenaz køben købig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Inchen Timná ka linchatø ishug tru Esaúwei nusrkai Elifazwei kan nusrkai tøgaguig køn, tru Amalecwan. Iiløbe kerriguba Esaúwei srai Adai awelumera kuin køn. ");
INSERT INTO gum_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Inchen Reuelwei nusrkaløbe iilø kuig køn: Najat køben, Zera køben, Sama køben, Mizá købengue, truiløbe tru Esaúwei srai Basematwei awelumera købig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Inchen tru Esaúwei katøgan srai Anai nimbasr tru Sibeónweimbe awela tru Aholibamai nusrkaløbe iilø kuig køn: Jeús køben, Jalán køben, Coré købengue tru Esaúwei nusrkalø. ");
INSERT INTO gum_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iilø kuig køn tru Esaúweinukkurri amrrub misaamera, nørreelø nøm asha karubelø, tru Esaúwei mayur nusrkai Elifazwei nusrkalø: Temán køben, Omar køben, Zefo køben, Kenaz køben, ");
INSERT INTO gum_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré køben, Gatán køben, Amalec købengue. Iilø kuig køn tru Edom pirau Elifazweinukkurri amrrub misaamera nørreelø nøm asha karubelø, truiløbe kerriguba Adai awelumera. ");
INSERT INTO gum_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Inchen Esaúwei nusrkai tru Reuelwei nusrkaløyu nørreelø nøm asha karubeløbe iilø kuig køn: Najat køben, Zera køben, Sama køben, Mizá købengue. Iilø kuig køn tru Edom pirau Reuelweinukkurri amrrub misaamera nørreelø nøm asha karubelø truiløbe kerriguba, Esaúwei srawei Basematwei awelumera. ");
INSERT INTO gum_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Inchen tru Anai nimbasr tru Esaúwei srai Aholibamai nusrkalø nørreelø nøm asha karubeløbe iilø kuig køn: Jeús køben, Jalán køben, Coré købengue. ");
INSERT INTO gum_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Iilø kuig køn tru Esaúweinukkurri amrrub misaamera, katø nune Edomgucha taigwei. Trumørig nømui nørrø misag søtømera købelan nøm asha karubelø. ");
INSERT INTO gum_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Inchen tru horeo Seirweinukkurri amrrub misaamera tru pirausrø warabeløbe iilø kuig køn: Lotán køben, Sobal køben, Zibeón køben, Aná køben, ");
INSERT INTO gum_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón køben, Ezer køben, Disán købengue. Iig tru Seirweinukkurri amrrub misaamera, Edom pirau horeosmeran nøm asha karubelø nørreelø købig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Inchen Lotánwei nusrkaløbe iilø kuig køn: Horiba, Hománba. Inchen Timnabe Lotánwei nuchag købig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Inchen Sobalwei nusrkaløbe Alván køben, Manajat køben, Ebal køben, Sefó køben, Onam køben kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Inchen Zibeónwei nusrkaløbe iilø køn: Ayába, Anába. Tru Aná kuig køn, tru misag warab waraimø pirømerasrø kuaalab pigammeran wetørrabig nui møskai Zibeónwei burrumeran ashib uña. ");
INSERT INTO gum_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Inchen Anábe kan nusrkai Disón taig tøgaig købig køn, katø kan nimbasr Aholibama taikkucha. ");
INSERT INTO gum_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Inchen Disónwei nusrkaløbe iilø kuig køn: Hemdán køben, Esbán køben, Itrán køben, Kerán købengue. ");
INSERT INTO gum_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Inchen Ezerwei nusrkaløbe iilø køn: Bilán køben, Zaván køben, Acán købengue ");
INSERT INTO gum_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Inchen Disánwei nusrkaløbe iilø kuig køn: Uzba, Aránba. ");
INSERT INTO gum_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Inchen horeosmeran nøm asha karubeløbe iilø køn: Lotán køben, Sobal køben, Zibeón køben, Aná køben, ");
INSERT INTO gum_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón køben, Ezer køben, Disán købengue. Truiløbe nøm møitøgucha nømui nørrø søtø misaameran nøm ashib karubelø treelø købig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israelitasmera rey tøgagømøwatø, tru Edom pirau reymera nebamba karub purrabeløbe iilø kuig køn: ");
INSERT INTO gum_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beorwei nusrkai Belabe Edomsrø rey kuig køn, nøbe tru Dinába taig ciudayugurri arrubig. ");
INSERT INTO gum_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Inchen Bela kwabene, tru nuimburøbe Zerai nusrkai Jobab karunrrab nebyaig køn, Bosra pirausriig. ");
INSERT INTO gum_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Inchen Jobab kwabene, tru nuimburøbe Jusán karunrrab nebyaig køn, Temán pirausriig. ");
INSERT INTO gum_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Inchen Jusán kwabene, tru nuimburøbe Bedadwei nusrkai Hadad karub wanrrab nebyaig køn, truibe tru Moab pirau madianitasmeran kanawa kørrømarøbig. Tru nø tsuig ciudabe Avit taig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Inchen Hadad kwabene, tru nuimburøbe Masreca misag søtømera waraisriig Samla karub wanrrab nebyaig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Inchen Samla kwabene, tru nuimburøbe Rejobotsrø Saúl karunrrab nebyaig køn, tru Eufrates pi menda. ");
INSERT INTO gum_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Inchen Saúl kwabene, tru nuimburøbe Acoborwei nusrkai Baal-Janán karunrrab nebyaig køn. ");
INSERT INTO gum_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Inchen Acborwei nusrkai Baal-Janán kwabene, tru nuimburøbe nusrkai Hadad karunrrab nebyaig køn, tru nø tsuig ciudabe Pau taig køben. Inchen tru Hadadwei sraimbe Mehitabel taig købig køn, Matredwei nimbasr, Mezabweimbe awela. ");
INSERT INTO gum_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Iilø køn tru Esaúwei karub pønrrab møguelai munchimera, mu møskalø køben, trumørig truilainukkurri amrrubelø, nøm waraigwan nømui munchitøgatøwei wamiilø: Timná køben, Alvá køben, Jetet køben, ");
INSERT INTO gum_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama køben, Elá køben, Pinón køben, ");
INSERT INTO gum_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz køben, Temán køben, Mibzar køben, ");
INSERT INTO gum_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel køben, Iram købengue. Iilø kuig køn tru Edom pirau nørreelø nøm asha karubelø, nøm chu waraig pirømerayu, nømui pønrrabigu. Edombe Esaútøwein køn, tru edomitasmerai møskai. ");
INSERT INTO gum_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacobpe nui møskai kørrømisra tsui pirau truyu kørrømisra tsuig købig køn, tru Canaán pirau. ");
INSERT INTO gum_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iibe Jacobwanba nui yaambu misaameranba maig pureb arrigwan waminchibig truig køn: Josébe pilamera diecisiete tøgaig kua, ubishameranba, cabrameranba nui nuneløba ashib tøgagøbig køn, tru møskawei ishumburmera Bilhaimba Zilpaimba truiløbe nusrkalø køben. Incha Josébe tru nuneløbe søl kømøtiig marøbelø køn chib møskawane eshkabig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Incha kerrigu maya nusrkalan lataguen kømøtø, tru Israel Jacob taig købiibe Joséwane truba undaguig købig køn, kaguende nø køllimbala tøgagui unø kuimba. Inchagurri pala itø kemig larrø tab tsurøzhig maringarubig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Inchen nømbe nøm kerriguelan lataguen kømø, Joséwane mas undaarai ashabe, yandø tsalø ashib menda ni kan wamzhikken tammaybe wamømeelø køn. ");
INSERT INTO gum_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Indiibe Josébe kan piji kan piaig tøgagua, nunelan waminchen, trugurrimbe nuneløbe masken tsalø ashibelø køn; ");
INSERT INTO gum_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","kaguen nøbe trenchib eshkabig køn: —Nan piaigwan ñimun eshkanrrab inchar cha, mørtray cha: ");
INSERT INTO gum_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Møimbe nam trausrø warøwa, tirigu lusrømera lusrøb købene, møimbe nai tirigu lusrøbe pasramisrøppe, ke ølgandøzhig pasramisrøptindan cha. Inchen ñimui tirigu lusrømerabe tru nai tirigu lusrø pøtøgatan pønrramisrøppa, purø tab inchib ke nai tirigu lusrømaygøba utsøbasrøptinchimøh— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Inchene nuneløbe trencha kusrua løtabelø køn: —¿Treekkan namui rey misra, namune ke ñi karub tøga pasrønrrab inchib pasrøtirru?— cha. Incha masken ashig kømui inchibelø køn, tru piailan, nø waminchen. ");
INSERT INTO gum_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Incha Josébe katøgan piaig tøgagua nunelan katø treeg eshkabig køn: —Møimbe katø nan piappe, pørrba, pølba pa trattrø y kan kønchabiimeraba nan tab inchib utsøbasrøb piatan— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Incha møskawanba, nunelanba treeg eshkabene, møskaimbe øyeebe chisun waminchab arrugu trenchiptinchibig køn: —¿Tru ñi øyeeg piaig tøgaguitøgabe namune manchibrre inchigu? cha. ¿Ñui usrimba, ñui nuneløba, naba, kabe ñun piraugatig utsøbasrtrain kønrrab kø chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Inchen nuneløbe larrø pusrkwai inchibelø køn. Trune møskaimbe øyeeg piaibe chiguermab wetøbeñimmørø chu uragucha isub sulu uñibig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Indiibe yandø treeg purayai wendø Siquémsrø nui nuneløbe møskawei ubishameranba, cabrameranba pu lawa mannrrab amben, ");
INSERT INTO gum_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israelbe Joséwane trenchibig køn: —Ñui nuneløbe Siquémsrø ubisha ashib waran cha. Amø cha, trusrømay inrrig— cha. Inchen Josébe: —Øø, inrrur— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Inchen Israelbe trenchibig køn: —Ashchab ya, tru ubishameraba cabrameraba, ñui nuneløba maig warai ashabe, wam srua attrunrrig— cha. Incha Hebrón chaasrøngurri inrrai ørøbig køn. Inchen Josébe ya, Siquémsrø pubig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Indiibe Josébe trusrø pua, truba lab llirab uña, pella pasrøbene, kan møg katabe, payibig køn: —¿Chi lagu?— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Inchene Josébe: —Nabe nai nunelan lab uñar cha. Chu ubisha ashib warai ñibe tiusmanda eshkabsrumuguh— chiben, ");
INSERT INTO gum_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","tru møøbe trenchibig køn: —Yugurrimbe chab ambubguen indig køn cha. Inchendø: “Dotánsrømay amrrab” taig nabe mørig køn— cha. Inchen Josébe nunelan lab ya, Dotán tru misag søtømera warainug kømøtø, wambig nøørøsrø wetørrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Inchen nømbe yabsrø arri ashabe, nømuimbulu pumøwatø, nømbe kwetchab waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Incha kangurri kangurri trenchibelø køn: —Ñimguen asay cha, tru piainabiibe øsrø arrun cha. ");
INSERT INTO gum_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Møimbe amrrui chibelø køn, kweecha, kan aljibe laligu kegutchab cha. Incha: “kan namig usha kweecha, main køn chinrrab” cha. Er nui piailøbe maig indashchab— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Inchen Ruben iigwan mørabe, nømui taskabe chi marmønrrai isua: —Kweechimugun chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ñimbe ani lushmøtø, mu misag warab waraimønug aljibe lalig pasrabnug kegutsay chibig køn. Inchendø ñimui taskabe chi marmøtay— cha. Rubénbe øyeeg chippe, Joséwane katøle wesrawa, møskaweisrø pegutchab isuig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Inchen José nunelaimbulusrø pubene, nømbe Joséwane tru nø pala itøguewa pasraig tab tsurøzhigwane kerrawa, ");
INSERT INTO gum_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","nune kemøra, tru pi wesramig trab lalig pasrabigu keguchibelø køn. Inchendø tru trab laliibe chi pigaig pur pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Inchabe yandø nømbe manrrab purramisrøbelø køn. Inchen nøm ashene, Galaadsrøngurri kan søtø ismaelitasmera amrruptinchibelø køn, camellosmerayu niisrar larrø may irrabzheelø, balsamo køben, mirra køben tru Egiptosrømay. ");
INSERT INTO gum_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Inchen Judábe nui nunelan trenchibig køn: —Namui nunewan kweechabe, chi mariasamø cha, kweecha tre marigwan søratø tøgaguabe. ");
INSERT INTO gum_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Trembe ismaelitasmeran yangun chibelø køn. Namui taskabe chi kaig marmønrrab cha, kaguendø nøbe namui yaundøwei namui nuneg køn— cha. Inchen nuneløbe trumay kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Inchen tru madianitasmera chine penab, yanøb inchibelø amrruben, Joséwei nuneløbe tru aljibe trab lalig pasrabigugurri wesrawa, pib tratrø an pitiswei yanøbelø køn. Øyamay Joséwane Egiptosrømay srua ambig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Indig yanayu Rubénbe tru aljibe trabsrømay arrubene, møimbe Josébe yandø mugaagøptinchen, nøbe isuptø nui kewa pasraigwan kølsrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Incha nunelan trenchinrrab ibig køn: —Yandø matsinube mugaagøn cha. ¿Nabe møimbe chindamer?— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Incha nømbe kan cabro unø kweecha, José pala itøguewa unigwane tru aniyu kebisha, ");
INSERT INTO gum_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","tru Joséwei kewaguig tab tsurøzhigwane møskaweimay trana ørøppe, øyeeg cha ørøbelø køn: —Nambe øyeeg wetørrer cha, ñui nusrkawein kui, ñui nusrkawein kømui muingøtashchab tab ashchig— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Inchen Jacobpe trunun nebua ashippe: —Nuiwein køn chibig køn. Kan namig usha webarrua kemøra, pitis mara, mainrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Incha Jacobpe nui kewa kuigwan kølsra, trøsrkølig kewa, nui unø pinigwan purø yanasrøngatig isub kørrømisrig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Inchen nusrkaløba, nimbasrmeraba isumønrrai maya, maya inchib melaingucha, nøbe trunune mørøg kømui inchibig køn. Incha nusrkawan isub, kishib trenchibig køn: —Kwabelø israb waraisrø na nøba tsunrrab yamnegatig nai nusrkawane isub tøga kømønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Inchen Egiptosrømbe tru madianitasmerabe tru Josewane Potifarwan yanøbelø køn, tru Faraon lutø tranigwan marøb pasrabig, tru suldaumera reywan chigøben kømønrrai ashib pønrrabelan nø asha karub pasrabigwan. ");
INSERT INTO gum_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Tru urassrø Judábe nui nunelan mendamisra, kan Adulamsrø møwei yausrø tsunrrab ibig køn, Hira taigweisrø. ");
INSERT INTO gum_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Incha trusrømbe kan cananeo Súa taigwei nimbasrwan srain kønrrai kabgucha, truigwan nui srain mara, pailø kibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Inchen tru ishuube kwanrriig kørrømisra, truigwei kan nusrkai tøgagua, truigwane Er cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Incha katø wendø kwanrriig kørrømisra, katøgan nusrkai tøgamisra, truigwane Onán cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Incha katø maya yanayu køsrøn katøgan nusrkai tøgamisra, truigwane Sela cha wamig køn. Truibe tru unan tøgagøb urasbe Kezibsrø tsuig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Indiibe Judábe tru nui mayur nusrkai Erweimbe srai labig køn, tru Tamar taigwan. ");
INSERT INTO gum_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Inchendø tru Er Judáwei mayur nusrkaimbe Jehováwein kabyu larrø kaig kuig køn. Inchen Jehovábe nui øsig unigwan kerraptindig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Inchene Judábe tru Onánwane trenchibig køn: —Ñui nuneg kwabigwei srawan kasharamø kømø, kasharau cha, ñui nuneg kwabig ñigurri ureg tøgaig kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Inchen Onánbe tru ureg kal-labeløbe nuin kuentailø kømønrrab kui asha kua, nui nuneg kwabigwei sraimba kib waramisri mørig, kwanrriig kørrømisrmønrrai pirautø, pirautø lushibig køn, nuneg kwabigweyasig chi ureg kaanrrai. ");
INSERT INTO gum_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Inchen Jehováwane treebe chigucha tabig asønamuben, truigwangucha øsig kuigwan kerraptindig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Inchen Judábe tru nui yerna Tamarwane trenchibig køn: —Ñui møskawei yau kasharamø, ka tsunrrig cha, nai nusrkai Sela kølig misramne.— Inchendø Judabe treeg isubig køn: ‘Inchippa Selagucha nuneg kwabelø lataitøwei kwanrraitamab.’ Incha treekkurri Tamarbe nui møskawei yausrø tsunrrab ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Indig yandø yana puraiben, tru Súai nimbasr tru Judáwei sraimbe kwabig køn. Inchen nøbe yandø tru isubig puraiben, Timnat pueblosrømay ibig køn, tru nui ubisha isig parøbelø waraisrømay. Inchen tru adulamita Hira taig tru nun linchibiibe nune lincha ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Inchen Tamarbe tru nui sueeru Timnatsrø nui ubishameran isig partrab yan taig wammørabe, ");
INSERT INTO gum_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","tru piuda kørrømisra pala keegwan wesrawa, incha muguinguen ashmønrrai maløwan pinøgasraitøga nøbe pinøgasra, Enaim kebambi yaskabu wamisrøbig køn, tru Timnatsrømay amrrab ambi mayuhke. Inchen nøbe øyeeg marøppe, tru Selabe yandø kølig kui asha, treeg marig køn, inchen køben, nune tru Judábe nune tru nusrkaimba kasharanmuben. ");
INSERT INTO gum_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Inchen Judá truigwan ashabe, nøbe kaig maramig asrwan anwei yanøb ishug kuitamab isubig køn, kaguen nøbe maløwan pinab kasraig waben. ");
INSERT INTO gum_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Inchen nøbe tru nui yerna kuitamab isumøtø, may menda waben kemallabe, trenchibig køn: —Ñiba kigun— cha. Inchen nøbe: —Ñiba, naba treeg maramig, na, øn tamibe ¿chi tranrrunrragu?— chibig køn. Inchene nøbe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","—Nai ubisha søtømerayugurri kan cabro-unøzhig trana øramønrrun— cha. Inchene nøbe trenchibig køn: —Kan chigøsrøn ñuiwan kørrømartra cha, ñi tru trannrrab misrigwan na utamnegatig.— ");
INSERT INTO gum_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Inchene Judábe trencha payibig køn: —¿Chi kørrømaramø?— cha. Inchene nøbe trenchibig køn: —Ñui sellon tru ilin tsiwanbañau, tru pøtønain tsig ñui tasku srua pasraigwanba kørrømartra— cha. Inchen Judábe truilan tranabe, tru Tamarba kib waramisra treeg maren, nøbe kwanrriig kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Incha nøbe kurra, truyugurri yabe, tru malø kasraigwane pinøsrua, tru keg kaig kørrømisra kewa unigwan katø kebig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Incha mas wendø tru Judábe tru nui tab linchibig adulamitan tru cabro unan trana ørøbig køn, tru ishuwan tru nuyelan trana kørrømariilan katøle utønrrai. Inchen nøbe tru ishuwane wetørranrrab kaimaptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Inchen nøbe truyu warab misaameran trencha payibig køn: —¿Peg møgueløba kaig marøb ishug tru Enaim may menda wabiibe chu wah?— cha Inchen nømbe trenchibelø køn: —Peg møgueløba kaig marøb ishuuma yube mumaganug køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Inchen tru møøbe katøle Judá waisrømay yabe, trenchibig køn: —Nabe truigwane wetørranrrab kaimar cha. Inchagucha truyu warab møgueløbe nane trenchitan cha: “Yube peg møgueløba kaig marøb ishuube mugaaguig køppeh”— cha. ");
INSERT INTO gum_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Inchen Judábe trenchibig køn: —Kerriguba ka tøga kørrømisrbashshu cha, namun ke chinetø chib indza asiinab pønrramig kømønrraimbe. Inchendø tør kønrrain cha, nabe cabro unane tru ishuwan trana øren, tru ishuwane ñibe wetørramuigwan— cha. ");
INSERT INTO gum_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Indiibe yandø pøn pøl puraibene, Judáwane trencha eshkaptinchibelø køn: —Tamar ñui yernabe kaig marøb uña, treeg marøb unigu kwanrriig misrin køn cha, nui asrwan anwei yanøbig lataig misra waikkurrindø.— Inchene Judábe trenchiptinchibig køn: —Nune wesrawa, parray— cha. ");
INSERT INTO gum_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Inchen yandø tru møgueløbe nun pattrab wesranrrab amben, nøbe nui sueerune trencha ørøbig køn: “Nabe kwanrriig misra pasrappe, tru na i srua pasrailan nan tranøbigwei kwanrriig misra pasrar” cha. Inchabe katø trenchibig køn: “I sellon tru ilintsiwanbañau, i tsigwanba, muin køtashchab ash” cha. ");
INSERT INTO gum_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Inchene Judábe nuin kui ashabe, trenchibig køn: —Nøbe sølgandø tabigwan maren, naguen kalø marøbrain køn cha, nai nusrkai Selaba nabe nun kasharanmub.— Incha nøbe tru ishuuba katøløbe kimuig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Indiibe yandø Tamarwan unø tøgamisramig puben, møimbe parchig tøgaig købrain kui wetøbeñibig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Inchen tru yandø kal-lanrrab inchen tru parcheeløyu kane tasiizhiimerrig kal-laptinchen, patsø kørrøørøbiibe unai tasiizhigu pigø tsizhig lichiptinchibig køn trenchib: ‘Iimerrig webarrig køn’ chib. ");
INSERT INTO gum_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Inchen unøbe tasiizhigwan katø kesruben, kanzhiimerrig kal-laptinchibig køn. Inchen tru patsø kørrøørøbiibe trenchibig køn: ‘¡Mandø incharre puraarruh!’ cha. Inchagurri unane Fares cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Inchen trugurrimbe tru nui nuneg tru tasiizhigu pigø tsi litsig kal-labig køn. Incha truigwane Zera cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joséwane Egiptosrømay srua amben, kan egipcio Potifar taig ismaelitasmeran Joséwane penabig køn, trusrømay truilø srua amrruin køben. Inchen Potifarbe tru Faraon lutø tranigwan marøb pasrabig nuig, tru suldaumera reywan chigøben kømønrrai ashib pønrrabelan nø asha karub pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jehovábe Joséwane tarømisrmø nøba pasrøben, chi mariiløtøgucha tabiitø, tabiitø pub iben, nøbe tru egipcio tru nun penabigwei yau wabig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Incha tru nun karub pera pasrabiibe Jehová Joséwane chi mariiløyutøgucha merraptø webinrrai mari ashibig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Øyamay tru Potifarbe Joséwane chi isumgaig larrø tabikkui asha, Putifar nø chi palai waben trunun ashib pasrønrraimba, katø nui yau chigurrimbunø tøgaguilan nø ashib pasrønrraimba treeg kørrømara pasra, nø chigurrimbunø tøgaguilan kerriguba nø asha martrai kørrømarøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Inchen yawanba nø chigurrimbunø tøgaguilanba Joséwan ashchai pasrikkurrimbunø, Jehovábe tru egipcione Joségurri mayanguen tab inchen, Jehováwei maya nuguen tabiitø nebunrrai indiibe tru egipcio kerrigu chi tøgaguimbala pasrabig køn, yau lata, wambigwansrø chi købigu lata. ");
INSERT INTO gum_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Inchagurri Potifarbe kerriguba Joséwei tasku ashchaim pasra, nune chi isumig chigaabig køn. Isumig køppe, nø mab mutsamigwan trunundøh isumig købig køn. Inchen Josébe larrø tab asr tøgaig trurrigu larrø tab møg købig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Indiibe kan maya yanayu køsrøn, tru nun pena karub tøgagøbig tru Potifarwei sraimbe Joséwane chull ashib menda, trenchibig køn: —Naba waramisrkun— cha. ");
INSERT INTO gum_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Inchen nøbe treegwane marmøtø, tru nun karub tøgagøbigwei srawane trenchibig køn: —Pøs, nai karubiibe yu yau chi købigwane nababe chi isumikkaig pasrøwa, treekkurri chi købigwan kerriguba nai tasku ashchai pønsraig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","I yaube natøwei mas nuig kur cha, chiwanguen ashmønrrai nane meriibe chigaagøn cha, ñundøh na chi asamig kømønrrai nøørø køn taig køn cha, kaguende ñibe nui srain kuimba. ¿Nabe nune øyeeg kaig marøb mandø pasramø cha, Tiuswan purø trømbøig marøb?— ");
INSERT INTO gum_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Inchen ishuube kwalømmørig, kwalømmørig Joséwane ‘naba waramisrkun’ chib, nuimbulu lincha wanrrai inchib maya, maya treendingucha, Josébe treegwane kandø, kandø ka chib, webib, webig ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Indiibe José kan kwaløm yau nui chi maramigwan martrab kebibenba, truyube mugucha kaaben, ");
INSERT INTO gum_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ishuube nui kewa pasraigu kemørøppa trenchiptinchibig køn: —Naba waramisrkun— cha. Inchene Josébe tru nui kewa pasraigwane nui tasku srua pasrønrraindø yaugurri weluløppa iptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Inchen Josébe tru nui kewa pasraigwane nui tasku kørrømisrtraindø welula yai ashippe, ");
INSERT INTO gum_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yau tru karuig mendig melabelan wamabe, trenchibig køn: —Au, ñimguen asay cha, tru nai keg kan hebreo pera arriibe namune ke kan chigucha kømeelø kui lataig mara kørrømartrab ka treetø arrin køn cha. Nainug kebarrua, nan kemørtrab inndan cha. Inchen nabe truba truba mur trashiben, ");
INSERT INTO gum_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","na truba mur trasai ashippe, nui kewaguigwan naimbulu tsumnetø, luløptindan— cha. ");
INSERT INTO gum_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Incha tru ishuube tru José kewaguigwane nui keg yau pumnegatig trarra wawa, ");
INSERT INTO gum_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","kewangucha treetøweih chib eshkabig køn: —Tru hebreo ñi karub tøgagømig pera arriibe nane kan larrø kaig kui lataig kemøra ka kaig martraptø arrin køn chib. ");
INSERT INTO gum_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Inchen nabe truba mur trashiben, nui kewaguigwan naimbulu tsumnetø weluløptindan— cha. ");
INSERT INTO gum_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tru “ñi karub tøgagømig peniibe nan øyeeg martan” chib, sraimbe Potifarwan øyeeg chib eshkaben, nøbe truba trømbøig namabig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Inchen tru Joséwan penabiibe reyweimburab kalø marøbelan kemøra keeriilø purramnug, Joséwan truyu keera wannøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Jehovábe Joséba pasrøwa, nui lastima asigwane kenamarøbig kenamara, tru keerin pønrrabelan ashib pasrabikken nune chi isumgaig larrø tabikkui ashchai, Jehovábe treeg marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Inchen tru keeri pønrrabelan nø karubiibe, tru mayeelø keeriilø pønrrabelan José nø ashchai pasren, katø truyu chi asha maramelane kerriguba José nø asha marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Inchen tru keerin pønrrabelan nø karubiibe chi isua asamikken palømíig køn, José nø asha marøb pasraigwane. Kaguende Jehovábe Joséba pasrøwa, nø chi mariilane merraptø, merraptø webinrrai marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Indig øyeeg chab purayaig yandø yana køben, reywan mutchai srørrøb pasrabiiba, reywei pirri marøbiiba, nømui karubig Egipcio reywane namishibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Inchen Faraónbe tru i pagatø nørreelan nø lutø tranigwan marøb pønrrabelan namabig køn, tru vino srørrøb pønrrabelan nø asha karubigwanba, tru pirri marøbelan nø asha karubigwanba. ");
INSERT INTO gum_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Incha tru suldaumera reywan chigøben kømønrrai ashib pønrrabelan nø asha karubigwei yau nømune keera purrønnøbig køn, tru Joséwan keera wanninuutøwei. ");
INSERT INTO gum_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Inchen Faraónwan chigøben kømønrrrai ashib suldaumerai nø karubiibe tru pagatø nørreelan keerilane José nø asha purugub pasrøbig køn. Inchen truiløbe kan maya yanagøsrøn truyu keeriilø purrøwabe, ");
INSERT INTO gum_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","tru pailø nørreelø tru lutø tranigwan marøb, katø tru reywan vino srørrøb pasrabiiba, tru pirri mara srørrøbiiba tru keerin purrabeløbe kan yem nøm kan kan piaig tøgagøbelø køn, tru piailøbe møitøgucha peg, peg eshkabig. ");
INSERT INTO gum_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Inchen Josébe løtsø nømun ashchab ibene, nømbe truba truba isuilø purraptinchen, ");
INSERT INTO gum_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","nøbe trencha payibig køn: —¿Ñimbe møimbe chindimbarre ke peg misriilø purrøgue?— cha. ");
INSERT INTO gum_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Inchene nømbe trenchibelø køn: —Nambe pailøba piailø tøgagøbendø, muguen kan øyeeg køn cha eshkanrrabiibe mugaagøn— cha. Inchene Josébe trenchibig køn: —¿Piailan ‘øyeeg køn’ chinrrabiibe Tius nø kømuitarru? cha. Er eshkarra pøs— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Inchen copamerayu srørrøbelan nø asha karubiibe trenchib eshkabig køn: —Møimbe nane piappe, kan uvas tusr naim pinrrøgue pasrabiibe, ");
INSERT INTO gum_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","srarmera pøn kwaliimera tøgaig pasraptindan cha. ");
INSERT INTO gum_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Incha truibe ishiizheelø wegucha, uzheelø niga tru lusrømerayube uvasmera srønan cha. Inchen nabe Faráonwei copan nai tasku muta, tru uvasmerane tru copayu sunna, trugurrimbe natøwei Faraónwei tasku tranøb piatan— cha. ");
INSERT INTO gum_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Inchene Josébe trenchibig køn: —Tru pøngatø srarmerabe pøn kwaløm køben, ");
INSERT INTO gum_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","pøn kwalømyube Faráonbe ñi chi kalø marigwan ulø paymøtø, katøle ñune ñui lutøyutøwei pasren, ñibe Faraónwan katøle vinon srøttrabguen cha, maramigwan maig marøbig købig kuig treetøwei. ");
INSERT INTO gum_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Inchen ñun treeg tab kørrømarene, trube, nan isurrunrrig chibig køn. Tiusmanda nan lastima tøgagua, Faraónwan waminchunrrig cha, nan yugurri wesranrrai. ");
INSERT INTO gum_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kaguende nane hebreosmerai pirausrøngurri nane namiimay merrarrawa, srua amrruig køn cha. Nabe yu Egipto pirau chigøben kalø mara kømur cha, na yu merrarrawa keerig wamig.— ");
INSERT INTO gum_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Inchen tru pirri marøbelan asha karub pasrabiibe tru piaigwan ke chi isumgaig tabig øya kønrrun chib eshkain kui ashabe, trenchibig køn: —Naimburappe nane treeg piatan cha: Nai turbalabe pøngatø tasin-ureemera chi pirrimera køben tøgar pønrrøbashib. ");
INSERT INTO gum_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Inchen ke pala srabesrø pasrab tasinyube, Faraónweyasig chine larrø may pirrimera sulu tøgaig pasrøbendø, illimera tru nai turbala tasin pasrabiguigwan mabashib.— ");
INSERT INTO gum_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Inchene Josébe trenchiptinchibig køn: —Iibe øyeeg cha eshkabig køn cha: Pøngatø tasin ureemerabe pøn kwaløm køn cha. ");
INSERT INTO gum_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Inchen pøn kwalømyube Faraónbe ñui turwan paringarua, kan tusryu mesringaruben, ñui asrwane illimera amrrua, ñune manrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Indiibe pøn kwalømyu Faraónbe nui tru kal-lain kwalømgurri mam pila nemisrigwan trunun isunrrab marøbig køn. Incha nø lutø tranigwan marøb pønrrabelayasig truba truba kasrag waramig mara, truilai merrab tru copasyu vino srørrøb pønrrabelan nø karub pasrabigwanba, tru pirri marøbelan nø karub pasrabigwanba tru keera purrønninukkurri wesrangarubig køn. ");
INSERT INTO gum_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Inchen tru copayu srørrøb pønrrabelan asha karub pasrabigwane katøle nui lutøwan tøga pasrønrrai tranen, nøbe srøsrø maig marøbig kuig katø treetøwei copan Faraónwan mutchai yuuløb pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Inchen tru pirri marøbelan asha karub pasrabigwane José maig purainrrun taimbala naashigu tsibasra mesrøngaruig køn. ");
INSERT INTO gum_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Inchen køben, tru copayu srørrøb pønrrabelan ashibiibe Joséwane isumø, kerrigu pesannaptindig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Indig yandø katøle srørrøb pønrrønrrai pønsrai pa ila puraiben, Faraónbe kan piaig tøgagøbig køn: Nune Nilo nu pi menda papsrøbashib. ");
INSERT INTO gum_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Møimbe tru piugurrimbe trattrø y parba larrø tabelø, tsal waaramera werruptincha, junco utuwan pu mab mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Inchen møimbe katø tru wendaube trattrø y par treetøwei waaramera larrø trømbøilø, kalargøleelø piugurri werruabe, Nilo pi menda tru srøsrø werrub waarameraim pulu pønrramisrøptincha, ");
INSERT INTO gum_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","tru larrø trømbøilø, kalar waaramerabe katø tru trattrø y par larrø tab waaramera tsalelane mabashibgue. Inchen tru treeg piab tsuppa, Faraónbe kasraptindinabig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Incha nøbe katø kibene, katøgan piaig mørøbig køn: Møimbe tirigu turmera larrø tabelø, larrø may nigar, kan tsutsiizhigutø trattrø y par weguchar, treeg nørrørailø pønrrøbashibgue. ");
INSERT INTO gum_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Inchen tru wendaube tru tsutsigutøwei katøgan trattrø y par weguchibelø køn, larrø pøndøzhig, tru kurag isig arrubig tustam itsiilø. ");
INSERT INTO gum_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Inchen tru trattrø y par larrø pøndøzheeløbe tru trattrø y par larrø may nigazheelø, larrø tabelan piñiptinchibelø køn. Inchen Faraónbe kia kasraptindinaben, nøbe piabrre tsubrain kui wetøbeñibig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Inchen nøbe løtsø kia kasrappe, larrø isuig kia kurra, tru Egiptosrø mayeelø magia kusrebelø mu mana mariimíigwan marøbelanba, larrø kusrebelanba amrrunrrai wamabe nui piagwan eshkabig køn. Inchendø truiløbe tru piaigwane ni møikken ‘øyeeg køn’ cha Faraonwane eshkanrrab kaimabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Inchen tru copayu vino srørrøb pønrrabelan nø karub pasrabiibe Faraonwane trenchibig køn: —Møimbe si, na chigøsrøn eshkamig tøgaguigwan eshakamubrain kuin isuptinndan cha. ");
INSERT INTO gum_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pøs yanaguen køn cha nam ñui karui melabelan ñi namun nama, nanba tru pirri marøbelan ashib karub pasrabigwanba, tru suldaumeran nø karub ashibigwei yau, nø ashib tøgaguilø purrønrrai namune keeringaruig købig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Indiibe wendø kan piaig tøgaguig køn cha, truigwanba nanba tru yemdøwei. Inchen tru piaibe kane peg peg eshkabig kuig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Inchen truyube kan hebreo matsinan merrarrawa keerig namba waig købig køn cha, tru suldaumeran nø karub tøga pasrabigwei karuig megabig. Inchen nambe namui piailan nun eshkabene, nøbe namui piailan øyeeg kønrrabig køn cha eshkabig køn mø piaitøgucha maig kønrrabigwan. ");
INSERT INTO gum_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Incha nø maig kønrrun cha eshkaig købiibe trubalawei purayaig købig køn cha: nabe nai lutøyu katøle puinabene, kanune naashigu tsibasra mesraig kuig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Inchen Faraónbe Josewan attrai wamønrrab øren, tru urastø Joséwane kalø marøbelan merrarrawa keeriinukkurri wesraben, Josébe milisigwan mullib, kewaguilan yunømarøb, Faraónweimay arrubig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Incha Faraónbe Joséwane trenchibig køn: —Nabe kan piaig tøgagøbendø, ‘øyeeg køn’ cha kelarrab eshkanrrabiibe muguen kaagøn cha. Inchendø nabe wammørar cha, ñibe piaigwan wamindi mørabe, ‘øyeeg kønrrab’ køn cha eshkabig kuin kui.— ");
INSERT INTO gum_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Inchene Josébe Faraónwane trenchibig køn: —Tru treeg maramibe nainug pasrømøn cha. Faraón chi isumø pishindø tab wanrrai wam tranøb løtønrrabiibe Tius nø køn cha.— ");
INSERT INTO gum_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Inchen Faraónbe Joséwane trenchibig køn: —Nan piappe, nabe Nilo nu pi menda pasrøbene, ");
INSERT INTO gum_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","tru piugurrimbe waaramera trattrø y par larrø tabelø, tsalelø werruptincha, tru juncos utu pu mab køben, ");
INSERT INTO gum_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","møimbe katø tru wendaube trattrø y par treetøwei waaramera larrø trømbøgøleelø, ke tsutsiiba, kalusbateelø, ¡katø! itapteelø piugurri werrubelø køn cha. Kan managuen Egipto pirau nabe øyeeg kalargølig trømbøgøleeløbe ashmuig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Inchen tru waaramera larrø trømbøgøleelø kalargøleeløbe tru srøtø trattrø y par tsal waaramera pønrrabelan maptinchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Inchendø truilan mappe, mabendø, kan chigucha mamøwa lataitøweih pønrrabelø køn cha. Kaguende maig købeløbe treeg trømbøig kalargøleetøweih pønrrabelø køn. Inchen nabe kasraptindinabig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Inchen nan katø piappe: Møimbe tirigu turmera larrø tabelø, larrø may nigar, kan tsutsiizhigutø trattrø y par weguchar, treeg nørrøwar pønrrøbashib piabig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Inchen tru wendaube tru tsutsigutøwei katøgan trattrø y par weguchibelø køn, larrø pøndøzhig, tru kurag isig arrubig tustam itsiilø. ");
INSERT INTO gum_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Inchen tru larrø pøndø tirigube tru larrø tab tirigu turmeran kebinab, kebinab piñbashib piabig køn cha. Inchen nabe tru magia kusrebelø mu mana mariimíigwan marøbelan payen, muguen truiløbe tru piaibe øyeeg chibig køn chabe eshkamøtan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Inchen Josébe Faraónwane trenchibig køn: —Faraónwei tru pagatø piailøbe parba trunundøwei eshkabig køn cha. Tiusbe nø maig martrab pasraigwan tru piabyu kenamarin køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tru truba tab waaramera trattrø y par, katø tru larrø tab tirigu turmera tru trattrø y parbabe pilamera trattrø y parwan eshkan cha. Tru piaibe trutøwei kandø eshkabig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Inchen tru waaramera larrø trømbøgøleelø kalargøleelø tru tab waaramerai wendau nerrubeløba, katø tru tirigu turmera larrø pøndøzhig tru kurag isig arrubig tustam itsiiløba, truiløbe pilamera trattrø y par køn cha. Inchendø truibe pilamera trattrø y par larrø trømbøig parø attrabigwan eshkabig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Nabe ñi Faraónwan øyeeg eshkar cha, Tiusbe nø maig maramigwan ñune kenamarøb pasran cha. ");
INSERT INTO gum_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Pilamera trattrø y par Egipto pirau muba kuimburab mamig purø misrøb pilamera kønrrab køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Inchen katø tru wendaube pilamera trattrø y par purø trømbøig parø attrabig køn cha, truba truba mamiimera misrig købelanguen chi misrmuig kui lataig pesannawa kømgue, kaguende tru parø arrubiibe tru Egipto pirøwane purø lastimaig mara kørrømartrun cha. ");
INSERT INTO gum_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Inchawei parø purø trømbøig arruptø, tru merrabwan truba truba mamiimera misrig købeløbe ni kan kenaguen kønrraamøn cha, purø trømbøig køptø. ");
INSERT INTO gum_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Pøs, ñi Faraónbe pamay treetø, treetø piaig mørig køn cha, kaguen Tiusbe iigwan ñi asha kønrrai ¡katø! martrab pasran cha, trurrigu chi srarrømøtø. ");
INSERT INTO gum_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Incha treekkurri ñi Faraónbe kan larrø kusreb møg, chigui asha tab marøb møg lanrrain cha, Egipto pirau kerrigu chi maramigwan nø karub ashib tøga pasramisrtrai. ");
INSERT INTO gum_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Incha nabe trendamønrrun cha, ñi faraónbe Egipto muba kuimburab tru ellmarig tulisailan ashib amrrabelø wesrawa pønsrø cha, Egipto pirau ellmarig tulisailan cien cargasyu veintene eseganrraingue tru trattrøba parba truba truba misrøb pilamerawan. ");
INSERT INTO gum_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tru mamig misrøbig larrø tab pilamera amrruben, tru Faraón maig chiben trumay tru ellmarig misrigwan ashibeløbe mamigwan kanbalatø tulisha, ciudamørig esegamig kønrrun, misaamerayasig mamig kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Inchawei tru i esegawa pønsrai mamiimerabe, tru Egipto pirau pilamera trattrø y par larrø trømbøig parø arrubigu purugunrrun cha, trumay misaamera parøgwab kwamønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Inchen tru øyeebe Faraónwanba tru nø karuigwan marøbelanbabe truba tabig mørøraben, ");
INSERT INTO gum_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faraónbe tru nui karuilane trenchibig køn: —¿Tiuswei espíritu nuinug arrua pasrainabig, katøgan øyeeg møg wetørranrrautah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Incha Faraónbe Joséwane trenchibig køn: —Ñi lataig kusrebig chigui asha tab martrabiibe mugucha katøgane kaagøn cha. Kaguende Tiusbe ñune kerrigu iigwan nebua asingaruin køn cha. ");
INSERT INTO gum_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ñi kønrrabig køn cha, nai purø tab yau na mubøraptø nebua karub tøgaguigwan ashib karub wanrrabiibe, nai maya misaamerabe ñi maig chiben møramig kønrrun cha; ñuimbalabe natøh mas nuig kømønrrun cha, kaguende nabe rey kuikkurri.— ");
INSERT INTO gum_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Incha Faraónbe Joséwane trenchibig køn: —Nabe ñune Egipto pirau kerriguba ñi asha karub wanrrai neera wannar cha, naimburø ashib wanrrai.— ");
INSERT INTO gum_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Incha Faraónbe surtigas sellobañauigwan nui taskugurri wesrawa, Joséwan pasrøbig køn. Incha trugurrimbe keilø linotøga marig purø tabig kenanøb, katø kan oro naashigu iløsrøb inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Incha trugurrimbe tru Faraónwei wendau katøgan tru ashib karub wabig unin karruyu Joséwane nebingarua misagwan øyah chib trashinrrai karubig køn: “¡Tømbønsray! ¡Tømbønsray!” chib. Øyamay Josébe Egipto pirau kerriguwan nø karub wanrrab nebyaig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Incha Faraónbe Josewane trenchibig køn: —Nabe Faraón kur cha. Inchendø kerriguba Egipto piraube chi maramigwan ñi treeg martrig chimuingatiibe, mugucha kønønrraamøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Incha Faraónbe Joséwane munchin yunømara Zafenat Panea cha wamababig køn. Incha Asenatwan nui srain kønrrai tranøbig køn, truibe On ciudasrø sacerdote lataig Potifera taigwei nimbasrwan. Øyamay Josébe Egipto pirøwan ashchab pasramisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josébe pilamera treinta tøgaig købig køn, Egipto rey Faraónwei merrab pera ambub uras. Incha Josebe rey Faraonwei merrabgurri webya, tru Egipto pirau pirø muba kuimburab ashib llirabig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tru trattrø y par misrøb pilamerawane pirøbe truba truba misren, ");
INSERT INTO gum_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","tru trattrø y pa pilamerawan Egipto pirau truba truba misriilan Josébe tulisingarua, ciudamerasrø kan mayangøsrøn esegawa pønsrøbig køn, tru ciudamørig tru pøtøgatanwan tirigu trameran tulisailan truyu truyu esegab. ");
INSERT INTO gum_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josébe tirigumera nørrø køptø kan maryu pisrum lataig nørrø tulishibig køn. Tirigu purø nørrø køptø yandø mayan køn tamgaig køben, ka kørrømarøbig køn, nørrø køptø øyan køn chib eshkab tøgagømgaig kuikkurri. ");
INSERT INTO gum_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tru parø attrab pila ke srøsrø pila pølbasrmøwatø Josébe nui srai Asenat, tru Onsrø sacerdote Potiferai nimbasrba, pagatø ureezheelø tøgaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Incha mayur nusrkawane Manasés munchi pasrig køn, kaguende nøbe trenchibig køn: “Nai møskawei yaugurri webya iben, chine chine nebuinab unig købigwan Tiusbe trunun isubguengaig pishindø unamig kønrrai martan” cha. ");
INSERT INTO gum_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Incha tru wendau katøgan unane Efrain munchi pasrig køn;. kaguendø i munchibe: “Na yeeg isuig tsuim pirausrø Tiusbe nane ureg tøgagønrrai marig køn” chibikkurri. ");
INSERT INTO gum_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Inchen tru Egipto pirau mamig larrø misrøb pilamera trattrø y par chab puraiben, ");
INSERT INTO gum_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","José maig eshkaimbala tru purø trømbøig parø attrabig tru trattrø y pa pilamerabe yandø kebibig køn. Inchen chu pirausrøndøgucha parø arrub mendøben, trune Egipto piraube muba kuimburab mamig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Inchen Egipto pirau kerrigu misaabe parø arrub mendi mørabe, misaamerabe Faraónwan mamig kaatan cha, miab mendaptinchen, Faraónbe maya egipciosmeran trenchibig køn: —Joséweimay amba, nø maig taigwan maray— cha. ");
INSERT INTO gum_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Inchen parøbe tru pirau muba kuimburab puim pasrøben, Josébe tirigu esegaig pønrrabelømørig kura, egipciosmeran yanøbig køn. Kaguende mamig kaagøb arrubiibe chu pirausrøndøgucha, masken, maskenig trømbøig misrøb arruben. ");
INSERT INTO gum_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Inchen chu pirausrø misaameratøgucha Joséwan tirigu penønrrab amrrubelø køn, kaguen tru parø arrubiibe yandø munaørøba arrub pasrøben. ");
INSERT INTO gum_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Inchen Jacobpe Egiptosrømbe mamiimera køn tai wammørabe, nui nusrkalane trenchibig køn: —Mailø køh cha, kangurri kangurri asiyab purrønrrappe. ");
INSERT INTO gum_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Egiptosrømbe mamig køn tai wammørar cha. Trusrømay kørraamba, namuyasig mamig penay cha, kwamø, øsig waramig kønrraimbe.— ");
INSERT INTO gum_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Inchen tru Joséwei nunelø tru pa trattrøeløbe Egiptosrø mamig penønrrab kørraambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Inchendø Jacobpe tru Joséwei nuneg Benjaminwane ørmíig køn, tru nui nuneløba: “Inchippa mayu chigøbendø nebubgun” cha. ");
INSERT INTO gum_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Inchen Israelwei nusrkaløbe mamig penønrrab ambubelø køn, tru katøganelø penønrrab ambubeløba, kaguende Canaán piraube parø purø trømbøig pasrøben. ");
INSERT INTO gum_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Inchen Josébe tru pirau nø ashib karubig købig køn, katø chu pirausreelan køben maya misaameran tirigu yanøbig. Inchen Joséwei nunelø trusrø puabe, nømui kappalømeran pirausrøngatig kebachib utsøbasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Inchen Josébe tru urastø nømune nui nunelø kui møi møi nebua ashibig køn. Inchendøgucha ashmíig misrøppa, nømune purø tsag waminchib trencha payibig køn: —¿Ñimbe chugurri amrrugue?— cha. Inchen nømbe: —Canaán pirausrøngurri tirigu penønrrab amrruer— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Inchen Josébe nui nunelø kui ashen, nømgurrimbe ashmeelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Inchen Josébe nun tru nømuimburab piaig købigwan isuptinchibig køn. Inchabe trenchibig køn: —Ñimbe i pirau kwayanrrab mubørab mas may kegørramdiig køtashib ka larønrraptørre amrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Inchen nømbe trenchibelø køn: —Ñi, namui karubig, chi treeg kømøn cha, nam ñui karuig melabeløbe tirigu penønrrab amrruig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nambe mayeeløba kan møskaweindø nusrkalø ker cha, nambe chigøben kalø marøb pønrrømø misaamera, nam ñi karuig melabeløbe maisrøn køtashib kalø martrab larab amøñimø misaamera ker— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Inchene Josébe trenchibig køn: —Kah cha, ñimbe i pirau kwayanrrab mubørab mas may kegørramdiig køtashib trunun ashchaptøwei amrruin køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Inchen nømbe trenchibelø køn: —Nam ñi maig chiben pønrrabelø pa trattrø y par købelø kuig køn cha, nambe søteeløba kan møskaweindø nusrkalø Canaán pirau tsubigwei. Inchen mas unøbe namui møskaimba kørrømisren, kane yandø pinig mugaagøn— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Inchen Josébe katøle trenchibig køn: —Na maig taig ñimbe maisrøn køtashchab nilø ka larønrraptørre amrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Incha isa kømø, ñimui wamindig cierto kuitashchab Faraónwei merrab, ¡katø! nabe øyeeg maramønrrun cha, trendamønrrun chibig køn, ñimui wendø nuneg-unan yumay pera amrrumuingatiibe ñimbe yugurrimbe webamrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ñim møigwan køben øray chibig køn, tru ñimui wendø nunewan pera attrai. Inchen katøganelane keera purrønniilø purrønrrain cha, trumaybe asamdiig kønrrun cha ñim sølwan waminchibelø kuin kui. Inchen ka isatø indin kuisruandøbe, ñimbe maisrøngøtashchab ka larønrraptørre amrruar køn cha, nabe Faraónwei munchiyu trendamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Incha tru nøm pa trattreelane Josébe pøn kwaløm ørøba keerig purrønrrai marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Inchabe pøn kwaløm puraibene, trenchibig køn: —Nabe Tiuswane larrø køriibala pasrabig kur cha. Øyamay maray chibig køn, ñim øsig webamrrappe: ");
INSERT INTO gum_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ñim isa kømø, chigøben kalø marøb pønrrømø misaamera kuabe, møikkøben ñimui kan nunewan keera awannig kørrømisra wanrrain cha. Inchen kaneløbe ñim ñimui yau misaameran parø purørmønrrab mamiimera srua ambay cha. ");
INSERT INTO gum_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Incha ñimui wendø nuneg-unan pera amrrurrunrrigay cha. Trumaybe isa kømø ñimbe sølwan waminchibelø kui asha, ñimbe kwamig kømønrrun— cha. Inchen nømbe treegwan martrab kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Inchabe kangurri kangurri trenchibelø køn: —Isa kømø, nambe namui nuneweimburab larrø trømbøig kalø marig køn cha. Pøs øyeekkatiibe marmørrunrrigay chib nø namun truba truba trenchib megaben, nambe trendaigwane ni mørøkkuinguen kømuin pønrraig købig køn cha, yeeg lastima isui indi ashatøgucha. Truburø møimbe øyeeg isuin pønrramig namuimbala itøarrin pønrrer— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Inchene Rubénbe trenchibig køn: —Unane chi kaig marmøtay chiben, ñimwei nan mørmuig køn cha. Møimbeguende namune nui animbe ulø payinab pønrramig kønrrab køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Inchen Josébe nø wamindi wamwan nui nunelan katøburø lliska waminchabig katøgan pera pasrabig køn. Inchagurri nuneløbe nøm chi chib pønrrailane Josébe mørøb pasraitamappe isumeelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Inchen Jøsebe nømuim pulugurri tarømisra ya, truba kishababe, trugurri katøle nømuimay arrua, nømba wamincha, Simeónwane nøørø mara, nøm ashib pønrramne lusringarubig køn. ");
INSERT INTO gum_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Incha trugurrimbe Josébe nømui kustalmerayu tirigu netsøganingarua, katøle tru nømui tiriguburø pagarai anmerane kanun, kanun tru nømui tirigu kustalyu pusringarub, katø mayuwei ishin tamara traningarub inchibig køn. Inchen treeg marig køn. ");
INSERT INTO gum_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Inchen nømbe nømui tirigumeran burrumerayu niisra truyugurri ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Incha nømbe tru kørrømisra kiamsrø puabe, møikkøsrøn nui burrun tirigu mannrrab kustalwan pichene, møimbe nui anbe kustalrrigu ka wai ashiptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Inchen nøbe nui nunelan trenchibig køn: —Nai anwane nane katøle pusrin kømøh cha. Yu nai kustalyu ka purran— cha. Inchene nømbe larrø kørrø kwariilø, nømui manrrøbe ke webørsrab lata inchen, kangurri, kangurri trendiyabelø køn: —¿Namun øyeeg nebuinab pønrramig kønrrai kabe Tius treeg mara chinderah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Inchen nømbe Canaán pirausrø møskai Jacob waisrø chab puabe, nømun kerrigu chi purayaigwan eshkab trenchibelø køn: ");
INSERT INTO gum_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Tru pirausrø karub wab møøbe namune purø tsag wamincha, nui pirøwan maig køtashib namune larab amrruig treeg kemesrøtan cha. ");
INSERT INTO gum_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Inchen: “Nambe chigøben kalø marøb pønrrømø misaamera, managuen maig køtashib larab amøñimeelø ker cha, nambe trender cha. ");
INSERT INTO gum_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Incha katø nambe nune trenchibelø ker cha: “Nambe pa trattrø y pa nunelø, katø søteeløba kan møskaweindø nusrkalø, kane yandø pinig mugaaben, srabeibe ñiba Canaánsrø kørrømisran” cha. ");
INSERT INTO gum_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Inchene tru pirausrø karub wab møøbe namune trenchitan cha: “Nabe ñimune øyamay marigu asamønrrun cha, ñim chigøben kalø marøb pønrrømø misaamera kuitashchab ashchab, møigwan køben, ñimui nunewan yu naba kørrømaray cha, kaneløbe nømui yauelan parø purammønrrai tirigu niisra amrrai. ");
INSERT INTO gum_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Inchendø katø amrruppe, wendø nunewan pera amrrunrrigay chitan cha. Trumaybe ñim isa kømø chigøben kalø marøb pønrrømø misaamera, ka maig køtashchab ashib ka larønrraptø amrrumuin kui asamønrrun cha. Trugurrimbe ñui katøgan nunewan elachen, ñimbe i pirau mu chi taimíig yanøb, penab amønamig kønrrun” chitan— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Inchen tru Joséwei nunelø tru kustalmeran kwarøb mendøbene, nømui kustalmørig kan talegu-unøzhigu nømui tru tiriguburø pagarai anbe ka purraptinchen, nøm lata, nui møskai lata tru an pusri talegu-unøzhigwan kura ashabe, purø kørig isubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Inchene møskai Jacobpe nømune trenchibig køn: —Ñimbe nane yandø chi nusrkaløgaig kørrømarøb amrrutan cha. Josébe yandø pinig mugaaben, Simeóngucha mugaaben, møimbe Benjaminwan pera amrrab indan cha. Iibe kerriguba naimbalatø pureb attan— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Inchen Rubénbe møskawan trenchibig køn: —Benjaminwane na ashchur cha. Na Benjaminwan ñuimay katøle pera pumubene, nai pagatø nusrkalan kwetchig— cha. ");
INSERT INTO gum_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Inchene Jacobpe trenchibig køn: —Nai nusrkaimbe ñimba inrraamøn cha. José nuneebe yandø kwaig mugaaben, møimbe nøtøwein kørrømisra megan cha. Mayu chigøben kaig nebubene, chi martrague cha, trube, ñimgurrindø kønrrun cha, køllig waacha isubigutø kuabene.— ");
INSERT INTO gum_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Inchen tru piraube parøbe masken trømbøig misrøb arruben, ");
INSERT INTO gum_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","tru Egiptogurri srua amrruin tirigube yandø chab patsøbene, møskaimbe trenchibig køn: —Egiptomay katøle amba, namuyasig tirigu nubah penønrrigay— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Inchene Judábe trenchibig køn: —Tru møøbe namune ¡katø! ke kandø cha pasrig kuig køn cha: “Tru ñimui wendø nunewan ñim pera amrrumuingatiibe trube, nan kuimbe kenamisrmørrunrrigay” cha. ");
INSERT INTO gum_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ñí namui nunewan ka pera ambasheneh, trube, nambe ñuyasig mamig penønrrab kørraambamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Inchen ñi namun nun pera ambashmubene, trube, nambe ambamig kømønrrun cha. Kaguende tru møøbe namune trendaig kuig køn cha: “Ñimui nunewan ñim pera amrrumuingatiibe trube, kenamisrmørrunrrigay”— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Inchene Israelbe trenchibig køn: —Ñimgui nane purø trømbøig kalø mariitan cha. ¿Tru møwane katøgan nuneg tøgaguer chabe, chinchabrre eshkainguaasamørra?— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Inchene nømbe trenchibelø køn: —Kaguende tru møøbe namuimburappa, namui yauelaimburappa ke chine tab, tab payibig køn cha. Inchabe trenchibig køn cha: “¿Ñimui møskaimbe ka øsig wabig køh? cha ¿Ñimbe katøgan nuneg tøgagøgueh?” cha. Pøs nambe, nø mancha payiilan ka løtamiitøwein kuig køn cha. “Ñimui nunewan pera amrrunrrigay” chinrraitamappe, ¿kan nambe mu isua pønrraig køtah?— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Inchene Judábe møskai Israelwane trenchibig køn: —Matsinane na asamønrrun cha. Matsinane naba ka ingaru cha, nambe yandø ambamønrrun cha, ñi lata, nam lata, namui ureemera lata kwamønrrappe. ");
INSERT INTO gum_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Chi kømønrrai nune na asamønrrun cha. Na yumay nun katøle pera arrumuinabene, trube, nagurrindø kønrrun cha, na chu uraskatig nai øsig tsuigu. ");
INSERT INTO gum_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Inchawei namun øya srarrøbashmuig kuinguen, katøguen amba pubsruinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Inchen møskai Israelbe trenchibig køn: —Pøs mumay katøgan peemay maramdiig chigaaguig købene, trube øyamay ka maray cha: Ñimui kustalmerayu tru møwei ketamelø i pirau chigøben tabig misriilan srua ambay cha, kan lamø bálsamo køben, lamø miel køben, mayzhig irrabelø køben, mirra køben, nueces køben, almendras købengue. ");
INSERT INTO gum_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Angucha srua ambuppe, maya srua ambig kømnetø katø treetøweih srua ambay cha. Ñimui tirigu kustalyu tru anmeran katøle pusrig købigwane trannrrab katøle srua ambay cha. Inchippa pella treenchib kuin købgun cha. ");
INSERT INTO gum_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Incha ñimui wendø nunewan pera, tru Egipto pirau nø karub wabigweimay katø ambay chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Maramburab Marøb Tiusbe tru møg ñimun lastima tøgagønrrai martrain cha. Inchen ñimui katøgan nunewan lelachen, Benjamíngucha katø ñimba attrain cha. Inchen nan nai nusrkalan trubisamig nebubene, chinchibig kui ¡ka treeg nebunrraita!— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Inchen nømbe tru ketamelanba, katø angucha maya srua ambig kømnetø katø treetøweih srua, Benjamínwan pera, Egiptosrømay kørraamba, Joséwei merrab pubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Inchen Josébe Benjamín nømba arrin kui ashabe, tru nui yau ashibigwane trenchibig køn: —I møguelan nai yamay pera ya, kan waara kweecha tamaray cha, kaguen i møgueløbe kwaløm tøbøtaabe naba manrrab køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Inchen tru møøbe José maig taigwan mara, Joséwei yamay nømune pera ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Inchen nømbe Joséwei yausrømay pera ambi mørabe, kørrø køriimata trenchibelø køn: —Marig merrabwan namui kustalmerayu tru anwan katøle pusrikkurri namune pera ambiinrrun cha. Møimbe namune merrarrawa, chigøben maramba, namune øyeeg, øyeeg mara pønrran tamba, katø namune nømui karua srua kuilø kønrrai maramba inchautan cha, namui burrumeranbañau.— ");
INSERT INTO gum_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Incha yandø kebambi yaskabu puabe, tru Joséwei yawan ashibigwan nømbe waminchab kemallabe, ");
INSERT INTO gum_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","trenchibelø køn: —Tiusmanda, namui karubig, nambe tru srøtø kørrørruppe tirigu penønrraptø kørrørruig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Indiibe tru nam werrua amrrua, tru yem kørrømisramsrø puabe, namui kustalmeran kura ashene, møimbe tru tirigu kustalmerayube møilaindøgucha namui anmerabe kerriguba ka purraptindin køn cha, maya unaasiibe, treekke. Møimbe nambe tru anwan trannrrab katøle srua amrruer cha. ");
INSERT INTO gum_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Incha tirigu penamig anbe katø srøig sruamrruer cha. Inchendø nambe tru srøsrø srua amrrui anwane kustalmerayu mu kebusri mørmer— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Inchen tru Josewei yau chi købigwan nø ashibiibe trenchiptinchibig køn: —Chi isumøtay cha. Chi kørig isumøtay cha. Ñimui Tius, katø ñimui møskawei Tius nøbe ñimui kustalmerayu tru anwan pusriinrrun cha. Nabe ñim pagarai anwane utig kuig køn— cha. Incha tru Joséwei yau chitø tøgaguilan ashibiibe Simeónwan wesrawa, nøm purraisrømay pera arrua, ");
INSERT INTO gum_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","trugurrimbe José waisrømay pera ya, nømui srømmeran kwalamig pi tranøb, burrumeran mannamig pønsrøb inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Inchen nømbe ketamelan tamara, José israyu pumnegatig muniirabelø køn, kaguen mamiibe truyu kønrrabig kui nømbe wammøra purrøwa. ");
INSERT INTO gum_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Inchen yandø José yau pubene, nømbe tru ketamelø srua amrruilan keta, nømbe Joséwei merrab pirausrøngatig maløwan trarrøb utsøbasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Inchen Josébe payibig køn: —¿Maig meløgue? cha, ¿Tru ñim wamindig ñimui møskai kølli misaazhikkan katøgucha ka øsig wabig kuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Inchene nømbe trenchibelø køn: —Tru namui møskai, ñi maig chiben martrabiibe, chigucha kømø, tab ka wan cha. Ka øsig wabig køn— chabe, nune tab indig kønrrai utsøbasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Inchen Josébe nuin pøtøgatan ashabe, tru kan møskaindø, kan usrindø kuikkurri nuimbe trag nuneg Benjamín pasrai ashabe, trenchibig køn: —¿I tru ñimui wendø nuneg kuitarru cha, tru ñim nan wamindig?— Inchabe trenchibig køn: —Tius maya nuguen ñun tab indig kønrrain cha, nai nusrkai.— ");
INSERT INTO gum_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Inchen nui nunewan ashene, kishig købiibe yandø pasramgaig køben, Josébe mallatø webya, nui kwartuyu kebya, kisamburab kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Incha yandø awentawa, nui maløwan kwalla, webarruabe, trenchibig køn: —Mamiimera nøm manrrai pønsray— cha. ");
INSERT INTO gum_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Inchen José mab wamisramibe nøørø køben, katø nunelane nøørø tamara purrønana, egipciosmera tru Joséba mabelane katø nøørø mab purramig tamarøbelø køn, kaguende egipciosmerabe nøm kørewa tøgaguigube hebreosmerababe trubalatø purramisra mamig kømíig kua, kaguen nømuimbe treebe larrø trømbøig købig køben. ");
INSERT INTO gum_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Inchen Joséwei nuneløbe nui merrab purrabelø køn, José maig purramisringaruben, treekke. Kerrigu mayurmerrig, trugurrimbe tru wendauig treetø, treetø nøm maya yanailø køben, trumay treeg purrønnøbig køn. Inchen nømbe truba kwaariilø purrabelø køn, nømbe ¡katø! kangurri, kangurri asiyab. ");
INSERT INTO gum_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Incha Josébe tru nui mishatsigu chi mamiimera pønsraigwan tru mamiimeran nømun pirishibig køn. Inchen Benjamínweyasiibe trattreelaimburabigwan nuyasiitø pasrøbig køn, kanelan lataitøguen kømø. Incha nømbe Joséba kanbalatø mab, muchib truba truba kasraarabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Incha mas yanayu Josébe nui yawan ashibigwan trencha karubig køn: —Tru møguelai kustalmerayu maya kemnegatig tirigun netsøganay cha. Incha nømui pagarai anmeran tirigu kustalmerayu trumørig pusrtrig cha. ");
INSERT INTO gum_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Incha tru wendø nunewei tirigu kustal trigube nai copa andøga marigwan wayrrig cha tru tiriguburø nø an pagaraigwanba kanbalatø.— Inchen tru yau ashib wabiibe José maig karuigwan marøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Inchen yandø ke chab tør-rrabendø tru møguelane Josebe ambasingarubig køn, nømui burrumeranba. ");
INSERT INTO gum_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Inchen tru møgueløbe tru ciudayugurrimbe ke tre yab ammø, srø køben, Josébe nui yau ashib wab møwane trenchiptinchibig køn: —Tru møguelan wetøgønrrab møi møi malla inrrø cha. Incha wetøgabe, trenchinrrig cha: “Namgurrimbe yeeg tab inchen, ñimbe chindimbarre kaig mara amgue? cha. ¿Andøga marin copan chindimbarre nila srua amgue? cha. ");
INSERT INTO gum_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nan karub pera pasrabig truyu muchib, chi purainrrabigwan truyu nebua ashib indin copan. Ñimgui purø kalø marin køn”— cha. ");
INSERT INTO gum_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Inchen tru yau ashib wab møøbe wetøgabe, José maig taigwan treetøweih chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Inchene nømbe trencha løtabelø køn: —¿Tru namun ashib karubiibe namune chindimbarre øyeeg chinetø tah? cha. ¡Kan! nambe managuen treekkøliibe mara kømer cha. ");
INSERT INTO gum_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Yamba nambe Canaán pirausrøngurringuen tru namui tirigu kustalmerayu an wetørrailanguen katøle trannrrab srua amrruig køn cha. Ñui karubigwei yaugurrimbe mas mandø incha tru oro køben, an køben, nila srua amrrunrraitamah? cha. ");
INSERT INTO gum_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Inchen nam ñui karuig melabelainug møigweinug køben, tru copan wetørrainabiibe, truibe kwamig kønrrain cha. Inchen namguen ñui karuindiig melabelø kønrrab kørrømisramønrrun— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Inchen tru yau chiwan køben nø ashib wabiibe trenchibig køn: —Ñim maig taig treeg kønrrain cha. Tru copan wetørrainabiitøh na karub tøgagømig meganrrab kørrømisrtrun cha. Inchen ñim kaneløbe chi kalø mara pønrran tamiibe chigar kørrømisrtrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Inchen nømbe mallazhiitø niisraigwan chab pinøsrua, møitøgucha kustalmeran pirau pønsra tsusaigwan pichibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Inchen tru ya ashibiibe tru mayur nunewei kustalyugurri lab pølbasra, tru srabe nuneg Benjamínweisrøngatig lam mendøbene, møimbe tru copane truigwein kustalyuh wetørraptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Inchen nuneløbe nømui kewa pønrraigwan larrø isuin pønrrai ashchai kenamartrab kølsrøptinchibelø køn. Incha nøm møitøgucha nømui burrumeran katø niisra, ciudasrømay katøle chab llirabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Inchen Judábe nui nuneløba Joséwei yausrø pubig køn, nøbe yau srø wamnetø. Inchen nømbe nui merrab maløwan pirausrø kebatamnegatig utsøbasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Inchene Josébe trenchibig køn: —¿Ñimbe øyeebe mumay marøb pønrrøngue? cha. Kan møg chi chippe treegwan kønrrai inchibig na lataibe ñim chi kalø martrab indigwan kabe wetøbeñmønrraitamagueh— cha. ");
INSERT INTO gum_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Inchene Judábe trenchibig køn: —Namui karubigwan, ñune ni chitamguen kømøtan cha. Mumaygucha kan treeg marmuig køn chib pønrramibe kaatan cha. Nam ñui karuig melabelainug trømbøig kalø marigwan Tiusbe kenamaran cha. Møimbe nambe namui karubigwei karuindiig melabelø misramønrrun cha, katø tru copan wetørrainabig chigucha.— ");
INSERT INTO gum_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Inchene Josébe trenchibig køn: —Kan nabe treebe mana marøb pasramø cha. Tru copan nuinug wetørrainabiitøh nai karuindiig meganrrab kørrømisrtrun cha. Ñimbe chi isumø, ñimui møskaweisrømay ka ambay— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Inchen Judábe Joséweimay kemallabe, trenchibig køn: —Nai karubig, nan namumørrunrrig cha. Ñundø na kan chigøsrøn chinrrab, nan tiusmanda utø ketøbsrumuguh cha, kaguende ñibe Faraón køb lataitøwei chi maramigwane martrain karubig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ñi namui karubiibe namune øyeeg chib payig købig køn cha: “¿Ñimbe katøgucha møskawan ka wannar køgueh, kabe katøgan nuneg kui tøgar køgueh?” chib. ");
INSERT INTO gum_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Inchen nambe ñi namui karubigwane øyeeg cha løtab pønrraig kuig køn cha: “Nambe namui møskai kølli misazhiiba, kan matsinø nuneg-unøba tøgar ker cha, truibe namui møskai kølli misag køben kal-lawaig. Inchagurri tru i srabeigwane møskaimbe purø undaguig køn” cha; kaguendø kan usraindø nusrkain kuikkurri kan nuneebe yandø kwain kaaben, nøtø kørrømisra pasran cha. ");
INSERT INTO gum_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Inchene ñi maig chiben nam treeg pønrrabelane ñibe trendaig kømøh cha: “Na ashchab tru wendø nunewane pera amrrunrrigay” cha. ");
INSERT INTO gum_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Inchen nambe namui karubigwan yamba trendaig køppeh cha: “Matsinøbe møskawane chincha elatchaamøn cha, kaguende nø elachene, møskaimbe kwanrrun” cha. ");
INSERT INTO gum_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Inchene nam ñui karuig melabelane ñibe trendaig køn cha: “Ñimui wendø nuneg ñimba arrumuingatiibe, trube, kenamisrmørrunrrigay” cha. ");
INSERT INTO gum_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Incha nambe namui møskai tru ñi maig chiben marøbigwei yausrø puabe, ñi namui karubig ñi maig taigwan nambe kerrigu eshkabelø ker cha. ");
INSERT INTO gum_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Inchene namui møskaimbe namune trenchibig køn: “Katøle amba, namuyasig tirigu nubah penønrrigay” cha. ");
INSERT INTO gum_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Inchen nambe namui møskawane trendaig køn cha: “Namui wendø nuneg arrumuingatiibe nambe chincha ambamgaig køn cha. Namun nø linchimubene, tru karubigwane asamig kaagøn” cha. ");
INSERT INTO gum_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Inchen nai møskai ñui karuig megabiibe trendaig køn cha: “Ñimbe ashibelø køn cha, nai sraimbe pagatø nai nusrkalø tøga misrigwan. ");
INSERT INTO gum_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Indig kane nainukkurri ya yandø pinøben, katøbe managuen ashmur cha. Namig ushamera pitis marig kuitamab isur tan cha. ");
INSERT INTO gum_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Katø iigwangucha pera amben, katø chigøben køptinchene, na køllig waachawan isubiitøgatø kwamig kønrrai marøbeløbe ñim kønrrabguen” cha, nane trendaig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Nai møskaimbe matsinø-unøbabe purø trag pønrrabelø kuig køppe, nambe katøle amben, matsinø-unø namba arrumubene, ");
INSERT INTO gum_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","namui møskaimbe nun ashmuppe, kwanrrun cha. Inchen nam kømønrrun cha, namui møskai kølli misagwan isubiitøgatø kwamig kønrrai marøbeløbe. ");
INSERT INTO gum_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Incha na ñui karuig megabiibe matsinan na purøbasramisrøb na ashchab misrig køn cha, nai møskawei merrab. Incha nabe nai møskawane trendaig køn cha: “Na katøle ñuimay pera arrumuinabene, trube, nagurrindø kønrrun cha, na chu uraskatig nai øsig tsuigu” cha. ");
INSERT INTO gum_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Inchawei tiusmanda, nabe ñun treeg marøbsrumu chinrrab cha, matsinaimburø na purøbasramisrtrur cha, na ñui karuindiig meganrrab, matsinø-unøbe nui nuneløba katø inrrai. ");
INSERT INTO gum_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Nabe mandø yamø cha, matsinø-unø naba arrumubene? Trube, nane nai møskawane larrø lastimazhig isui indi ashig kømøtan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Inchen Josébe nuim pøtøgatan pønrrabelai merrab yandø mas awentanrrab kaima, mur wamabig køn: —¡Mayeelanba yu nai merrabgurri webambingaruy!— chib. José nui nunelan nøbe ñimui nuneg kur cha eshkabene, nuim pulube ni mugucha mugaaguig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Incha nøbe trasha, trasha kishen, egipciosmerabe wammøren, katø Faraónwei yau misaameragucha wammøren inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Incha Josébe nui nunelane trenchiptinchibig køn: —Nabe José kur cha. ¿Nai møskaingan tab ka wabig kuitarru?— cha. Inchen nuneløbe larrø kørrø kwaara, ni chigucha løtønrrab kaimaptinchibelø køn, nømbe nui merrab ni mumayguen kømuilø pønrrøwa. ");
INSERT INTO gum_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Inchen Josébe: —Naimay kemalay— chiben, nømbe kemallen, nøbe trenchiptinchibig køn: —Nabe tru ñimui nuneg José kur cha, tru ñim nan Egiptosrømay yana ørig købig. ");
INSERT INTO gum_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Inchendø ñimbe chi kullaarab isui inchimøtay cha. Ñim nan yusrømay yanig købigwan karrengucha øyeeg marøbraitamab isumøtay cha. Nane Tius ørig køn cha, manawei nanmerrig inrrai, misaameran kwamø ka øsig puramrrai martrab. ");
INSERT INTO gum_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kaguende pirau pa pilaguen parø arrub pasrøben, katøgucha trattrø pila palan cha, tru pilamerawane ellmartrab aramelø kønrrab kømøwei, ellmarig tulisamig kønrrab kømøwein kønrrabig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Incha Tiusbe manawei nanmerrig ørig købig køn cha, ñim pirau ka øsig warøwa, larrø tab webamba pønrramig puben, trumay misaamera larrøbichibig larrøbichib kønrrai. ");
INSERT INTO gum_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Inchawei nane yusrømay ørøppe, Tius nø ørig køn cha, ñim kømøtø.Tru Faraónwan chi maramigu na isum purugubig kønrraimba, nui yau kerriguwan na ashib tøga wanrraimba, katø kerrigu Egipto pirau na karub wamig kønrraimba nø pasrig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Inchawei ñimbe mallatø incha, nai møskawei yamay amba, trenchinrrigay cha: “Ñui nusrkai Josébe øyah tan cha: ‘Tiusbe nane Egipto pirau kerriguba na karub wanrrai wandan’ cha. Incha ‘nan ashchab ‘pebatø’ amø’ tan chinrrigay cha. ");
INSERT INTO gum_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","‘Ñibe nai puluwandø Gosén pirau tsunrrig tan cha, ñui nusrkaløba, ñui awelu ureemeraba, katø ñui ubishamera køben, cabrasmera køben, ñui waaramera køben, katø ñui chigurrimbunø tøgaguiløbañau. ");
INSERT INTO gum_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nabe ñun truyu ashib tøgagørrumøn cha, kaguen katøgucha trattrø pila ørøba tru parøbe arrubig attrab køn cha. Trengømuisruandøbe ñiba, ñui ureemeraba, ñui kerrigu chi tøgaguiløbañau larrø lastimailø misra kørrømisrtrabguen’ cha. ");
INSERT INTO gum_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Inchagucha ñim lata, nai nuneg Benjamin lata, ñimashib asha pønrran’ cha, waminchippe na waminchib pasrai. ");
INSERT INTO gum_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Nai papáwan eshkanrrigay cha Egipto pirau kerriguwan ashib na karub waigube chigurrimbunø køn cha katø ñim kerrigu chi asiilanba. ¡Ñimbe mallatø amba!, yusrømay nai papáwan pera amrrunrrigay— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Incha Josébe nui nuneg Benjamínwan ira pasramisra, kishen, katø Benjamíngucha treetøwei nuneg Joséwan ira pasramisra, kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Incha Josébe nunelan muchawa, truba truba kishib irabig køn. Inchen nunelane wamindamig wam larraibig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Inchen Faraón nø waig yausrømbe wam pubig køn: “Josewei nunelø chab puin køn” tan chib. Inchen Faraónba tru nui maramigwan marøb purrabelø nørreeløbabe kasraarabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Incha Faraónbe Joséwane trenchibig køn: —Ñui nunelan Canaán pirausrømay nømui ushamerayu niisra amrrai karu cha. ");
INSERT INTO gum_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Incha ñui møskawanba ñui yau misaameranba naimay pera amrrunrrai. Nabe yu Egipto purø tab pirøwan tranamønrrun cha. Inchen nømbe i pirau purø tab mamiimera misriilan manrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Katø ñibe nømune treeg karunrrig cha: “Yu Egipto pirau carretillas nørreelø weytøga sruilan srua ambingaru cha, nømui sralan køben, ureemeran køben ñui møskawan køben pera amrrumig. ");
INSERT INTO gum_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Incha nømui chi tøgaguilan lelacha, amrrumig chi isumønrray cha, kaguende yu Egipto pirau purø tabiibe nømuin kønrrun”— cha. ");
INSERT INTO gum_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Inchen Israelwei nusrkaløbe treeg marøbelø køn. Pøs Faraón maig karuben Josébe carretillas nørreelø weytøga sruilan pønsrøb, mayuwei ishiimera tranøb inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Incha nømun kanun, kanun kemelø srøizhig kan, kan keta trana, Benjamínwane tsantsøn anmera trescientosba, katø yunømarøb kemelø trattrøgatøba keta tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Incha nui møskaweyasiibe iilan trana ørøbig køn: Egipto pirau purø tabelø tøgaguilan pa trattrø burrusmerayu niisra øriiløba, katø pa trattrø cargas burramerayu tirigu niisra øriiløba, katø pirrimera køben, mamiimera køben niisra ørøbig køn, møskai maywan mab arrumig. ");
INSERT INTO gum_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Incha yandø amrrai ørøbig køn. Incha yandø webamba ambene, Josébe trenchibig køn: —Mayube chinetø, chinetø tiyab, kwayab amrrab kømø— cha. ");
INSERT INTO gum_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Inchen nømbe Egipto piraugurri nebambub amba, Canaán pirausrø pubelø køn, nømui møskai Jacob waisrø. ");
INSERT INTO gum_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Incha trusrø puabe, trenchiptinchibelø køn: —Josébe ka øsig wan cha. Egipto pirau muba kuimburab nø karub ashib wabig kuin kømøh— cha. Inchen Jacobwei manrrøbe pasram kwarøptinchibig køn, kaguen nøbe køremuig kua. ");
INSERT INTO gum_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Inchen nømbe José mandø tailan, mandø tailan chishtøh eshkaben, katø nømun pera ambamig carretillas nørreelø weytøga sruilan trana øriilan ashib inchene, nune asrchiibe katøle chish misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Incha Israelbe trenchibig køn: —Nai nusrkai José katøgucha øsig wabig kuin kui yandø tsabø ashar cha. Na kwamøwatø nabe ashchab yamønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Incha Jacobpe mayeelø nøba warabeløba nui chi tøgaguiløbañau webya, yandø Beersebasrø puabe, truyu Jacobpe ushamera kweecha Isaac nui møskawei Tiuswan tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Inchen Tiusbe yem kan piab lataigu Israelwane trenchib waminchibig køn: —Jacob, Jacob— cha —Inchene nøbe: —Yu pasrar— chiben, ");
INSERT INTO gum_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Tiusbe trenchibig køn: —Nabe Tius kur cha, tru ñui møskawei. Tius. Egipto pirausrømay kørrayamig chi kørig isumøta cha. Nabe ñune ñigurri purø nørrø misag søtømera kønrrai maramønrrun cha trusrø. ");
INSERT INTO gum_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nabe ñiba Egiptosrømay kørraarrua, katø natøwei Egiptogurri werrunrrai maramønrrun cha. Incha ñi kwabene, Josebe nøashib nui taska ñui kammeran kasrønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Incha yandø Jacob Beersebagurri webibene, Israelwei nusrkaløbe nømui møskai Jacobwan køben, nømui ureemeran køben, nømui sralan køben, tru Faraón amrrunrrai carretillas nørreelø weytøga sruilø trana øriiløyu amrrab nebambingarubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Incha katø Canaán pirau tøgamisriilø nømui ushameran køben, chine købelan køben, tøga srua ambig købig køn. Øyamay Jacob kerrigu nui yaueløba Egipto pirausrømay yaig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Nui nusrkalø køben, nui nimbasrmera køben, nui awelu ureemera køben, nui awela ureemera køben mayeelø nuinukkurri amrrub misaamera nøba ambig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Tru israelitasmera Egipto pirau kebambubelai munchimerabe iilø køn, tru Jacob nuinukkurri amrrub misameraba: Rubén Jacobwei mayur nusrkai. ");
INSERT INTO gum_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Katø trugurri Rubenwei nusrkaløbe iilø køn: Hanoc køben, Falu køben, Hezrón køben, Carmí købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Inchen Simeónwei nusrkaløbe Jemuel køben, Jamin køben, Ohad køben, Jaquin køben, Zohar køben, katø kan Canaánsrø ishuwei nusrkai Saúl købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Inchen Leviwei nusrkaløbe iilø køn: Gersón køben, Coat køben, Merari købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Inchen Judáwei nusrkaløbe iilø køn: Er køben, Onán køben, Sela køben, Fares køben, Zera købengue. (Inchendø Erbaba Onánbabe Canaán pirausrøndø kwaig købig køn). Inchen Fareswei nusrkaløbe Ezrónba Hamulba kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Inchen Isacarwei nusrkaløbe iilø kuig køn: Tola køben Fúva køben Job køben, Simrón købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Inchen Zabulónwei nusrkaløbe iilø køn: Sered køben, Elón køben, Jahleel købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Truilø kuig køn tru Padan-aramsrø warab uras Lea Jacobwei tøgagui nusrkalø, katø tru Dina nui nimbasrba. Inchawei truyugurri amrrub misaamera møguelan køben, ishumburmeran køben munchene kerrigube treinta y tres kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Inchen Gadwei nusrkaløbe iilø køn: Zifión køben, Hagui køben, Ezbón køben, Suni køben, Eri køben, Arodi køben, Areli købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Inchen Aserwei nusrkaløbe iilø køn: Imna køben, Isva køben, Isvi køben, Beria køben, katø nømui nuchag Sera taikkuchague. Inchen tru Beriai nusrkaløbe iilø køn: Heber køben, Malquiel købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Iilø kuig køn tru Zilpa Jacobwei tøgagui nusrkalø. Tru Zilpabe karuindiig mendig megabig kuig køn, tru Laban nui nimbasr Lean keta trani ishug. Tru Zilpainukkurri amrrub ureemerabe kerrigube dieciséis kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Inchen Jacobwei srai Raquelwei nusrkaløbe iilø køn: Joséba, Benjamínba. ");
INSERT INTO gum_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Inchen Joséwei nusrkalø Azenatba tøgagui ureemerabe iilø køn: Manasésba, Efrainba Egipto pirau kal-lawar. Tru Azenatbe Onsrø sacerdote Potiferai nimbasr kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Inchen Benjamínwei nusrkaløbe iilø køn: Bela køben, Bequer køben, Asbel køben, Gera køben, Naamán køben, Ehi køben, Ros køben, Mupim køben, Hupim køben, Ard købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Iilø køn tru Jacobweimba Raquelweinukkurrimba amrrub ureemera kerrigube catorcegue. ");
INSERT INTO gum_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Inchen Danwei nusrkaimbe Husin taig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Inchen Neftaliwei nusrkaløbe iilø køn: Jahzeel køben, Guni køben, Jezer køben, Silem købengue. ");
INSERT INTO gum_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Iilø køn tru Bilha Jacobpa tøgagui ureemera. Tru Bilhabe karuindiig mendig megabig kuig køn, tru Laban nui nimbasr Raquelwan keta trani ishug. Inchen tru Bilhainukkurri amrrub ureemerabe kerrigu trattrø y par kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Inchen mayeelø Jacobpa Egipto pirau nuikkurri amrrub misaamerabe pubeløbe sesenta y seis kuig køn, nui aniyugurri ureemera nusrkalai sralan munchimuben. ");
INSERT INTO gum_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Inchen Joséwei ureemerabe pagatø kuig køn, Egipto pirau kal-lawar. Inchawei Jacobwei yau misaamerabe Egiptosrømbe setenta puig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Incha Jacobpe Judámerrig Joséweisrø merrab punrrai ørøbig køn, Joséwan eshkaben Gosénsrø nun katønrrab attrai. Incha Gosén pirausrø chab pubelø køn. ");
INSERT INTO gum_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Inchen Josébe nui møskawan utønrrab yamig niga luløb kaullimera sruigwan tamara, Israel nui møskawan Gosénsrø utønrrab webibig køn. Incha møskawan ashippe, naashiburab ira, pasramisra, truba truba yana kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Inchen Israelbe Joséwane trenchibig køn: —Møimbe ñun na ashib asha, ñi øsig ka wabig kuin kui wetørrawabe, nabe chi isumø, ka kwamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Incha Josébe nui nunelanba nui møskawei yau misaameranba trenchibig køn: —Na Faraónwan ashchab inrrab inchar cha, nun wammørøsrkønrrab: “Nai nuneløba, nai møskawei yau misaameraba Canaán pirausrø warabeløbe naba kørrømisra warønrrab amrrun chinrrab”. ");
INSERT INTO gum_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Pøs nømbe ubisha ashibelø waara karrøgøbelø treelø køn chinrrab. Incha nømui ubishameran køben, waarameran køben chigurrimbunø nøm tøgaguilan køben srua amrrun” cha. ");
INSERT INTO gum_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Inchawei Faraón ñimun wama: “¿Ñimbe chi marøbelø køgue?” cha payene, ");
INSERT INTO gum_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ñimbe øya løtønrrigay chibig køn: “Nam ñui karuiløbe matsøreg ureemera kurri møingatig nam lata, namui kølli misaamera lata waara karrøgøbelø ker” cha. Trumaybe ñimbe Gosén pirau warønrrabguen chibig køn. kaguende egipciomerabe ubisha ashibelane purø trømbøig kui inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Inchen Josébe Faraónwan wammørøsrkønrrab yabe, trenchibig køn: —Nai møskaimba, nai nuneløba Canaán pirausrøngurri amrruin køn cha, nømui ubishamera køben, cabrasmera køben, nømui waaramera køben, nømui chi tøgaguilø kerriguba. Incha yandø Gosén pirausrøn chab puaguen køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Incha Goséngurri attraptø trattrøgatø nui nunelan lawa wesrua, Faraónwei merrab pera arrubig køn, ‘nai nunelø køn’ cha eshkanrrab. ");
INSERT INTO gum_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Inchen Faraónbe trencha payibig køn: —¿Ñimbe chi marøbelø køgue?— cha. Inchen nømbe Faraónwan trenchibelø køn: —Nam ñui karuig melabeløbe ubishamera køben cabrasmera køben karrøgøbelø treelø ker cha, namui merrabsrø møskalø lataitøwei.— ");
INSERT INTO gum_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Incha katø trenchibelø køn: —Nambe i pirau kan maya yanatø warønrrab amrruer cha, kaguende nam ñui karuig melabelai ubishameraimbe Canaán pirau nam waraisrømbe chi pu kaagøn cha. Trusrømbe parøbe ni chindamguchagaig pasran cha. Inchagurri nam ñui karuig melabelan tiusmanda Gosén pirau namun warøbashibsrumøgue chinrrab inder— cha. ");
INSERT INTO gum_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Inchene Faraónbe Joséwan trenchibig køn: —Ñui møskaimba, ñui nuneløba ñiba warønrrab amrruin køn cha. ");
INSERT INTO gum_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egipto pirøbe ñi asha maramig ñuin tasku pasran cha. Mas purø tab pirau warønrrai war chibig køn, tru Gosén pirau. Egipto pirau truibe purø tab pirø køn cha. Truyu warønrrab kørrømisrtrain cha. Truilai utu purø tab asha martraptø møguelø købene, truilan nai ushameran nøm ashib tøgagønrrai nømun pønsrø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Trugurri Josébe nui møskai Jacobwangucha pera ya, Faraónwan, ‘iibe nai møskain køn’ cha eshkabig køn. Inchen Jacobpe Faraónwan ‘mayanguen tabig nebuig kønrrig’ chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Inchen Faraónbe Jacobwan trencha payibig køn: —¿Mam pila tøgaig kugu?— cha. ");
INSERT INTO gum_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Inchen Jacobpe Faraónwan trenchibig køn: —Na amburab, iburab llirab uniibe pilamera ciento treinta køn cha. Na øsig uniibe menrra yam pilamera kømøwei, katø murig kuig køn cha. Tru nai kølli misaamera nøm llirab amønain pilamerababe trugatig nebumum køtan. —cha. ");
INSERT INTO gum_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Incha Jacobpe Faraónwan mayanguen tabig nebuig kønrrig chib, truyugurri ungua cha ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Inchen Josébe Egipto pirau purø tab pirømeran tranøbig køn, truyu warønrrai, Faraón maig karuig, treekke. Treekkurri nui møskaimba nui nuneløba Ramesés pirau, pirømera tøgaguig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Incha katø Josébe nui møskawanba, nui nunelanba, nui møskawei yau misaameranba nui karuig peraguilanba mamiimera mab kømig pønsrøbig køn, nømun kanun, kanun maig paløben, treekke. ");
INSERT INTO gum_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Yandø muba pirø kuimburab chigucha mamig chigaaben, trune parøbe chindamdiig køben, Egipto pirau lata, Canaán pirau lata parø arrubigu yandø misaamerabe kwamitø palabig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Inchen Josébe tru Egipto pirau misaameraba, Canaánsreeløba tirigu penab pagarai anmeran kerrigu tulisha, tru anwane Faraónwei tab yau esegabig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Inchen yandø Egipto pirau lata, Canaán pirau lata chigucha anga patsøben, maya egipciomerabe Joséweimay amrrua trenchibelø køn: —Namun ñi mamiimera pønsrørra cha. ¿Namgan ñui merrab kwamig kuitarru? cha, namun kerrigu an patsinukkurrindø. ");
INSERT INTO gum_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Inchen Josébe trenchibig køn: —Ñimun an chab patsøbene, ñimui ushameran tranay cha. Nabe tru ushameraba yunømarøb ñimune tirigu tranamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Inchen egipciosmerabe nømui ushameran srua amrrubelø køn; kaullimera køben, ubishamera køben, cabrasmera køben, burrumera køben, waramera køben. Incha tru ushameraba yunømara, tru pilawan mamiimera tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Inchen tru pila puraiben, wendø pilayu nømbe amrruabe, trenchibelø køn: —Namune an patsøben, namune ni chinchaguen søramgaatan cha, kørrømisrmøtø, an patsøtan cha, ñun eshkaig køn cha. Yandø namui ushameragucha ñuindø misren, nambe chigøben tranamibe chigar misrer cha, namui pirømerabah, katø nambe ka pønrraiteelø pønrrer cha. ");
INSERT INTO gum_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Namui pirømerabañau ¿ñigan nam kwanrrai kønrraindeh? cha. Ñi namunba, namui pirømeranba penørray cha, mamiiba yunømariilø kønrrai. Trumaybe nambe namui pirømerabañau nambe Faraónwei misra karuindeelø melamønrrun cha. Inchendø yellmera nam mamig køben, ellguamelø køben, trannrra cha, nam øsig waramig kønrraimbe, katø pirømeragucha lelatsiilø pønrrømønrrai.— ");
INSERT INTO gum_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Inchen Josébe Egipto pirømeran kerrigu Faraónweyasig penabig køn, kaguende egipciomerabe tru parø arrubikkurri nømui pirømeran yanen. Inchagurri pirømerabe kerriguba Faraónwei tasku purayaig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Incha egipciosmerabe Egipto pirau muba kuimburab nømbe ka karuindeelø melønrrab melamisrig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Inchen pirømera peniimeelø kørrømisrøppe, sacerdotemeraindøh peniimeelø, ka kørrømisrig køn, kaguende nømbe Faraónweinukkurri mamig traniilø utabelø kuig kua. Inchagurri nømbe nømui pirømeran yanmuig købig køn, nømbe Faraón pønsraigwan mabelø kua. ");
INSERT INTO gum_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Incha Josébe misaameran trenchibig køn: —Møimbe ñimba ñimui pirømerababe Faraónweyelø køn cha, nabe nuyasig penig køn cha. Ñimbe yu yellmera tøgagøn cha, pirømeran ellmaray chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Incha yandø ellmarig tulisamig pubene, tru cienyugurri veinte tarømarøb tulisaigwane Faraónwan tranrrigay cha. Inchen truyugurri kørrømisrøbigwane tramerayu tsuramiba, katø ñimba, ñimui ureemeraba, ñimui yau misaameraba, katø mayeelø ñimba warabeløba mab kømig kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Inchen nømbe trenchibelø køn: —Ñibe nam øsig warønrrai martan cha. Nø yangucha tab indigwan nambe uta tøga pønrrer cha. Nambe Faraón karuindø melabelø kømønrrun— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Incha Josebe øyeeg marøb kømig wesrawa pasrig køn, ellmarigu misriilan tru cien cargasyugurri veintebatø wesruigwane Faráonwein kønrrai treeg marig køn, tru møi kwalømgaatig. Inchen Sacerdotesmerai pirømeratøh Faraónwei kørrømisrmuig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Øyamay israelitasmerabe Egipto pirau warønrrab kørrømisrig kuig køn, Gosén pirau. Incha nømbe truyu pirømera merrarrawa waramisra, nømbe truyube wereg nørrø tøgagua, larrø nu misrig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Incha Jacobpe Egipto pirau pilamera diecisiete tsuig køn. Inchen kerrigu Jacob nø øsig tsuin kwalømmerabe pilamera ciento cuarenta y siete kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israel øsig tsum kwalømmera yandø patsønrrab køben, nui nusrkai Joséwan wamønrrab ørabe, trenchibig køn: —Na ñuin kabyu tabig asønaig kuinabene, tiusmanda ñui tasigwan nai srøptsim umbu estsar cha. Treeg marøppe na maig miaigwane trunune martrunrrig cha undaatøga. Incha nan purø nu lastima ashib, martrab kørrømisrigwane martrunrrig chibig køn. Tiusmanda nane Egiptosrømbe sørømørrunrrig chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Incha na nai møskaløba israb tsumisrene, Egiptogurrimbe srua ya, nømun esegawa wariinuutøwei wairrunrrig— chibig køn. Inchen Josébe trenchibig køn: —Ñi maig taigwan nabe treeg maramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Inchen Israelbe trenchibig køn: —‘¡Katø! Marmø kømø, maramønrrun’ chirra— cha. Inchen Josébe: —¡Katø! Marmø kømø, maramønrrun— chibig køn. Inchen Israelbe nui pøtønaig tsig pala utsøbasrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Indig kan maya yanayugøsrøn Joséwane trenchibelø køn: —Ñui møskaimbe kwanrrø tsun— cha. Inchen Josébe nui møskawan ashchab ippe, nui pagatø nuskalø Manaseswanba, Efraínwanba pera ibig køn. ");
INSERT INTO gum_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Inchen Jacobwane eshkabelø køn: —Ñui nusrkai José ñun ashchab pun— cha. Inchen nøbe ke kaimatøzhig købendø, truba tranrra, camayu kurra, wamisra, ");
INSERT INTO gum_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Joséwan trenchibig køn: —Maramburab Marøb Tiusbe Canaán pirau Luz ciudayu kenamisra, nane mayanguen tabigwan trana, ");
INSERT INTO gum_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","øyeeg cha kørrømisrig køn cha: “Nabe ñune ureg purø nørrø tøgagønrrai marøb, misag søtømera purø nørrø kønrrai maramønrrun cha. Incha nabe ñuinukkurri amrrub misaamerane i pirøwan tranen, managatig i pirøbe nømuin kønrrun” taig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na ñiba tsunrrab arrumøwatø, ñui pagatø nusrkalø yu Egipto pirau kal-lawa ureemera tru Efraínba, Manasesbabe nai ureemera misran cha, Rubénba, Simeónba naielø køb lataitøwei. ");
INSERT INTO gum_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Inchen ñi tru wendau ureemera tøgagui nusrkaløbe ñuielø kønrrun cha. Incha nømbe Efraínweimba, Manasesweimba nunelø kuig køppe, truilai munchiyu pirø ketig utønrrun cha ");
INSERT INTO gum_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nabe Padan Aramgurri katøle arrub megaben, ñui usri Raquelbe kwaig købig køn cha, Efrata ciudayu pumig ke lamøtø paløben. Inchen nabe Efrata may menda sørig køn cha. Truibe tru Belén kuinrre.— ");
INSERT INTO gum_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Incha Israelbe Joséwei nusrkalan ashiptinchabe, payibig køn: —¿Iiløbe mumera køh?— cha. ");
INSERT INTO gum_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Inchene Josebe trenchibig køn: —Iiløbe nai nusrkalø køn cha, nan yu Egipto pirau Tius keta traniilø.— Inchen Israelbe trenchibig køn: —Naimay kemalingaru cha, na purø tab indigwan trannrrab— cha. ");
INSERT INTO gum_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israelbe yandø purø kølliizhig kuig kua, yandø nui kabzheeløbe tør pilømuben, tab ashchab kaimabig købig køn. Inchen Josebe nui ureemeran nui møskaweim pulu kemalsrøben, nøbe muchab, irab inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Inchabe Israelbe Joséwan trenchibig køn: —Nabe ñun asamuitamappe isumuig køn cha. Inchendø Tiusbe nane ñui ureemeranbaguen asamig kønrrai martan— cha. ");
INSERT INTO gum_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Inchen Josébe uregwan nui møskawei srøb utøyugurri tarømarøppa, kappaløwan pirausrø kebatamnegatig utsøbasrøbig køn ");
INSERT INTO gum_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Incha Josébe nui pa nusrkalan Efraínwane nui kusrmay tasiitøga, Manaseswane nui atsitøga kemøra møskawei pulu pønsrøbig køn. Tru øyamay Efraínbe Israelwei atsimaygatømay pasramisren, Manasesbe kusrmaygatømay pasramisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Treeg pønsraindøgucha Israelbe nui kwalmeran ambumay imay yunømarøppa nui kusrmay tasigwane Efrainwei turbala estsarøbig køn, wendø nusrkain kuindøgucha. Nui atsimay tasigwane Manaseswei turbala estsarøbig køn, truibe mayur nusrkain kuindøgucha. ");
INSERT INTO gum_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Incha Joséwane i wammeratøga maya nuguen tabiitø, tabiitø nebuig kønrrai øyeeg chib tranøbig køn: —Nai møskalø Abrahamba, Isaacba nui merrab amønai Tius, tru nan kal-lainukkurri møingatig nan chi kømønrrai ashib tøga pasrab, katø na muba yamigwan eshkab pasrab Tius, ");
INSERT INTO gum_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","tru nan chine kaig pubigugurri wesrub Ángel i pagatø matsøreg-ureemeran maya nuguen tabiitø nebuig kønrrai martrunrrig chib. Incha iiløgurri nai munchiba, nai møskalø Abrahamweimba Isaacweimba munchimerabe pønrrabig pønrrønrrun cha. Nømbe pirau nørrø karrab purø nørrø larrøbitchai. ");
INSERT INTO gum_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Inchen Josebe nui møskaimbe nui kusrmay tasigwan Efraínwei turbala estsari ashabe, tab kømui inchibig køn. Incha møskawei tasigwan Efraínwei turbalagurrimba Manaseswei turbalagurrimba yunømara, estsartrai inchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Incha Josébe møskawane trenchibig køn: —Øyan kømøtø cha, iig køn cha, mayurbe iigweimbala ñui kusrmay tasigwan estsar— cha. ");
INSERT INTO gum_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Inchen møskaimbe treeg marmønrrab trenchibig køn: —Ashar cha, nai nusrkai, ashar cha. Manaseskucha misag nørrø larrøbitchabiitøwein køn cha, katø nøgucha larrø nuitøwein kønrrabig kua. Inchendø wendø nuneebe nø lataikken søtømera kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Incha tru kwaløm Jacobpe mayanguen tabiitø nebuig kømigwan øyah chib tranøbig køn: —Israel misaamera mayanguen tabig nebuig kømigwan nøm tranøppe, ñimui munchiwan wamab tøga pønrrønrrun cha: “Efraínwanba, Manaséswanba lataitøwei, Tius ñimun treeg martrain”— chib. Incha Manaséswan wendau pasra, Efraínwan merrab pasrig køn. ");
INSERT INTO gum_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Incha trugurri Israelbe Joséwan trenchibig køn: —Nabe yandø kwanrrainchar cha. Inchendø Tiusbe ñimba pasrøwa, nøbe ñimune ñimui møskalai pirømerasrømay katøle amrrai martrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Incha nabe ñui nunelan lataguen kømø, ñibe purab nuig kuikkurri Siquén pirøwan, amorreosmeraba na truba truba nai espadatøgaba, nai arcotøgaba kwayawa tøgaguim pirøwan tranar— cha. ");
INSERT INTO gum_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacobpe nui nusrkalan wama trenchibig køn: —Tulaambay cha. Nabe wendø kwalømmerawansrø ñimun maig purainrrabigwan eshkanrrab inchar cha. ");
INSERT INTO gum_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kemalay cha, mørtrab, Jacobwei nusrkalø. Møray cha, ñimui møskai Israel wamindigwan. ");
INSERT INTO gum_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ñi, Ruben, nai mayur nusrkai, na unøtø misag larrø chishig kua ke srøtø tøgaguig unø, tabig kui asig kømiguba, katø chi maramig nuig kømiguba ñimerrig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ñibe kan pimera køramdiig latøgushib amrrubig lataig, møimbe yandø ñi mayurbe maskucha nuibe kømønrrabguen cha. Kaguende nai kamayu nai sraimba trømbøig mara, ñui trag møskawei kamawan, kaig kuig lataig mara kørrømarig køn cha. ");
INSERT INTO gum_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeónba Levíbabe nunelø køben, nømui espadamerabe ka kwayab misag kweechib tøgagømiitø køn cha. ");
INSERT INTO gum_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nøm chigøben kaig martrab waminchib kuigu na truyu pasrønrrab kømøwei, nøm nørrø tuliambinug na linchab kømøwein kur, nai isubigwan na chishig tøgaguigwan mindisaig kømønrrab. Kaguende nømbe larrø namikkøleelø pønrrøwa, misagwan kweecha petab, mørøkkømubiitø ke kagatø, toromerai chambesrølmeran para petig køn. ");
INSERT INTO gum_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Larrø tsag inchib namig kurriiba, nømui namikkøbigu lastimagaig trømbøig mariibabe larrø trømbøig nebuig købash cha.Nabe Jacobwei piraugurrimbe ke nuinguindø misrtrai mara, Israel pirau ke truørø amba warønrrai maramønrrun. ");
INSERT INTO gum_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ñi Judábe ñui nunelø chi tamgaig, katø tabig wamindig kønrrabguen. Ñui ashig kømui inchibelane ñi kanawa tøgagønrrun. Inchen ñui trag nuneløguen ñui merrappe utsøbasrtrun. ");
INSERT INTO gum_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Inchen ñi, nai nusrkai Judábe, kan matsinø leon lataig, nø kemørigwan chab mabe, kan køli leon lataig pirau purø møg ashib tsumisrøptinchibig lataig køn. ¿Nune mugui kebacha ashchautah? ");
INSERT INTO gum_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judáwane nui karub sraua wain Pørøtsigwane kerraig kønrramøn, katø nui karub tøgaguin pørøtsigwan lata tru nui srøb utøyugurri, tru cierton rey arrumnegatig. Truiwane yu pirau pirø muba kuimnburab maya misaaba nune mørig kønrrabig køn. ");
INSERT INTO gum_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Judabe nui burrune uvas tusryu lichippe, lluig lamø burru unøzhigwane purø tab tusr srølyu licha pasran. Nui kewa kuigwane vinotøga tsarøppe, nui pala itø kewa kuigwane uvas anim piyu tsaran. ");
INSERT INTO gum_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Nui kammerabe vino lataguen kømø, mas yaløbigøzheelø køn. Inchen nui trugulmerabe pitsø lataguen kømø, mas puløzheelø køn. ");
INSERT INTO gum_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Inchen Zabulónweinukkurri amrrub misaamerabe mar mendawan warønrrabelø køben, truyube barcosmera chi isumgaig pub lliramig kønrrabig køn. Inchen nui linderosmerabe Sidonsrøngatig lulrrabelø køn. ");
INSERT INTO gum_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isacarbe kan burru larrø murig lataig køn, kan muba webya yamga tul— unøyu keerig pigaya tsub lataig. ");
INSERT INTO gum_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tru muba webya yamga tul-unøbe larrø tabig, pirøbe larrø chull asamdø pirø køb, katø pishindø tab tsumdiig køb køben, nøbe karga niga inrrab lligwan kegucha, ka karuindø megabig misrig køn. ");
INSERT INTO gum_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Inchen Danbe nui misaameran maig kønrrabigwan asha martrabig køn. Israelwei tru doce nusrkalai misag søtømerayu kan møikkøsrøn lataitøwei. ");
INSERT INTO gum_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Danbe kan may menda tsub ul lataig køn, tsachippe kwetchab tsachib ul may menda tsubig lataig, kaullin chiñimerayu tsacha, itøguana wabigwan wendømay palasig kebinab kutsingarubig.” ");
INSERT INTO gum_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“¡Jehová, ñi kaiyugurri wesraig kømigwan muniirar!” ");
INSERT INTO gum_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadwane kaig marøb misag søtømera amrrua melambub kwayaindøgucha, nøbe wendautø pasraørøb ya, kwayanrrun. ");
INSERT INTO gum_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aserbe larrø may mamiimera mabig kønrrun. Incha nøbe reywei mamiimera lataig manrrai pønsrønrrun. ");
INSERT INTO gum_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalíbe kan ishug panzhig chi iløsrkaimíig uñibig lataig køn, larrø tab pan-ureezheelø peraig. ");
INSERT INTO gum_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Inchen Josébe kan larrø may utiguitsin tusr lataig køn, may utiguichib pi menda pasrab lataig. Tsiurøzheelø nebib ibiibe tru pirøbanrrimerasrø nebib ib lataig. ");
INSERT INTO gum_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nune arcostøga kwayabeløbe, lastimaguengaig flechasmeratøga søl ørøb, kwayam laben, ");
INSERT INTO gum_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","nø srua pasrai arcone chigucha kullaaramø srua pasraig køn, tru Jacobwei maramburab marøb kwalmeragurri. ¡Mayanguen ungua ungua tru Jacobwei Mugucha Chindamga Tiuswan. Truikkurrin køn, tru Ubisha Ashibig, tru Israelwei kan peña lataig. ");
INSERT INTO gum_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","¡Mayanguen ungua ungua ñui møskawei Tius ñun purugubigwan! ¡Mayanguen ungua ungua Maramburab Marøb Tius ñun mayanguen tabig nebuig kønrrai marøbigwan! ¡Mayanguen tabig nebuig kønrrai Srømbalasrøngurri arrubiitøga! ¡Mayanguen tabig nebuig kønrrai maryu purø umbusrøngurri arrubiitøga! Pitsø mutsøsrøb tøgagøb katø usrai patsau tøgagøb indingurri mayanguen tabig nebuig kønrrai arrubiitøgaba. ");
INSERT INTO gum_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ñui møskaimbe tru maya nuguen tabig nebuig kømigwan ñun tranøppe, nai møskalø tru maya nuguen tabig nebuig kømigwan nan trani lataitøguen kømø tranig køn; managatig tru pønrrab tunmerasrøngatig. Tru iig mayanguen tabig nebuig kønrrai traniiløbe, Joséwei turbala kønrrain køn, nui nunelai utugurri tru lawa wesruigweinug. ");
INSERT INTO gum_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Inchen Benjamínbe kan larrø namig lobo lataig køn, løtsøbe nui kemøra mamigwan ma, maabene unchibelan pirishibig.” ");
INSERT INTO gum_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Iilø køn tru Jacobwei doce nusrkaløgurri misag nørrø søtø amrrubelø, tru nømunba, katø nuikkurri amrrub misaameranba wendøsrø nømun kanun kanun maig pub attrabigwan eshkawa pasrig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Incha katø Jacobpe øya eshkawa pasrøbig køn: —Nabe nai misaameraba tsunrrab yamig yandø lutau køtan cha, nai kølli misaameraimbulu sørørrunrrig chibig cha, tru heteo Efronwein pirau peña trab pasrabigu, ");
INSERT INTO gum_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","tru Mamre pinrrøguesø Macpela pirau peña trab lalig pasrabigu Canaán pirausrø, Abraham tru Efron hititan peninug nui yau misaameran kwaben, sørab kømig nømui pasrønrrai. ");
INSERT INTO gum_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Truyube Abrahamwanba, nui srai Saranba sørab, katø Isaacwanba nui srai Rebecanba sørab indig køn. Katø nagucha Lean truyu sørig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Pøs tru pirøwanba tru peña trab lalig pasrabigwanbabe, Hititasmeran penig kuig køn.— ");
INSERT INTO gum_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Incha Jacob mandø marøb kømigwan chab waminchabe, katøle kamayu tsumisra, neesrappe, kwaptinchibig køn. Incha merrabsrø nømui møskaløba isrønrrab t sumisrig køn. ");
INSERT INTO gum_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Inchen Josébe nui møskawei asrwan ira, kishib muchabig køn. ");
INSERT INTO gum_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Incha Josébe tru mø marøbelø nun purugub pønrrabelan nui møskawei asrwan minchib irrøramønrrai mø marøb tamarøngarubig køn. Inchen tru mø marøbeløbe treeg marøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Tru treeg tamarøb kømibe kwalømmera cuarenta nemisramne købig køn. Inchen egipciosmerabe kwalømmera setenta nemisramne isub kishibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Inchen yandø tru isub kisam kwalømmera patsøben, Josébe Faraon karub wainug purrab misaameran trenchibig køn: —Ñim truyu purrabelai merrab ñim nan tab indamdiig kuinabene, tiusmanda Faráonwan trenchirrunrrigay cha: ");
INSERT INTO gum_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Nai møskaimbe nø kwamøwatø, øyeegwan marmø kømø, ¡katø! nane maramønrrun tingaruig køn cha: ‘Canaan pirausrø søramig nø ashib tamarig pasrabigu, nun trusrø søramig kønrrai.’ Inchawei nai møskawan trusrø sørønrrab ibashcha” tan chinrrigay cha, nabe katø arrumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Inchene Faraónbe trenchibig køn: —Ñui møskai øyeegwan marmø kømø, ¡Katø! Martrurrunrrig cha trendaigwan ñi treeg martrab misrig købene, trube, sørønrrab inrrø— cha. ");
INSERT INTO gum_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Inchen Josébe møskawan sørønrrab nebiben, Faraonwan tru nø karub waigu purugub purabelø nørrø kølli misaameraba, katø Egipto pirau nørrø kølli misaameraba, nune linchibelø køn. ");
INSERT INTO gum_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Katø Joséwei yau misaamera mayamba, katø nui nunelø køben, møskawei yau misaamera køben, nebambubelø køn. Gosén piraube nømui ureemeranbah, ubishameranbah, cabrameranba, waarameranbahtø kørrømara. ");
INSERT INTO gum_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Incha nøbabe kaulli sruin karretillamerayu suldaumera køben, suldaumera kaulli palar køben tsimaytø lincha nebambubelø køn, misag purø nørrøgue. ");
INSERT INTO gum_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Incha Atat taigwei tirigu itsiisrø, tru Jordan pi pulusrø puabe, tsusrømbe mayangucha nu isub kishib treeg marøbelø køn. Trusrømbe Josébe møskainzhig yandø muga misren, trattrø y pa kwaløm isuin inchib kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Inchen truigwan tru Canaán pirau warab misaamera ashabe, tru Atadwei tirigu chish marin tulyu truba truba isuig kishib kui ashabe, trenchibelø køn: —Egipciosmera øyeekkatig kishib kuibe purø nuig kørren— cha. Inchagurri tru Jordan pi ambøgatømaysrømbe Abel Mizraim cha wamig køn. (Trenchippe: “Egipciosmera purø isui inchib puraambinug køn” chib.) ");
INSERT INTO gum_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Inchen Jacobwei nusrkaløbe nømun maig martrai nø miaigwan treeg marøbelø køn. ");
INSERT INTO gum_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nui nusrkaløbe Canaán pirausrømay srua amba, Macpela pirau peñayu trab lalig pasrabigu sørabelø køn, tru Efron hititan Abraham pirøwanbañau peninug, nui yau misaameran sørab tøgagømig, tru Mamre pulusrø. ");
INSERT INTO gum_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yandø møskawan chab sørabe, Josébe Egiptomay katø nebarrubig køn, nui nuneløba, katø maya misamera sørønrrab lincha amrrubeløba. ");
INSERT INTO gum_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Inchen Joséwei nuneløbe møskai kwaig yandø mugaabene, trunun isub mendabe, trenchibelø køn: —¿Josébe namune katøgucha namig isub srø unin kønrrab kø chinderah cha, nam nun øyeeg kalø marigwan trunun isua?— ");
INSERT INTO gum_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Inchabe José waisrømay trencha karua ørøbelø køn: “Ñui møskaimbe nø kwamøwatø, namune trencha karua pasrig køn cha: ");
INSERT INTO gum_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Ñimbe Joséwan øyeeg chinrrigay cha: Ñui nunelø yeeg kaig marøb, ñun kalø marigwan Tiusmanda ulø paymø pesannarrunrrig cha’ Inchawei møimbe tiusmanda, nam ñui møskawei Tius karuigwan marøb melabeløtøwein kuinaig købene tru trømbøig kalø mariilane pesannarrunrrig” cha. Inchen øyeeg wamindigwan mørabe, Josébe kishibig køn. ");
INSERT INTO gum_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Inchen nuneløgucha Joséwei merrab chab pua, utsøbasrabe, trenchibelø køn: —Nambe ñi ka karuindiig melabelø kønrrer— cha. ");
INSERT INTO gum_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Inchene Josébe trenchibig køn: —Chi kørig kui inchimøtay cha. ¿Nagan Tius nø marigwan na pasramisra marøb pasramuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ñimbe nane kaig martrab isua maren, trune Tiusbe tru kaig marigwane tabig punrrai yunømaran cha, tru møi nam ashib pønrraigwan martrab, misag nørrø pasrabigwan øsig tøgagønrrab. ");
INSERT INTO gum_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Inchawei ñimbe chi kørig kui inchimøtay cha, nabe ñimunba, ñimui ureemeranba ashib tøgagømønrrun— cha. Øyamay nui manrraugurri undaatøga, chi isui inchimønrrai waminchibig køn. ");
INSERT INTO gum_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josébe nui møskawei yau misaameraba Egipto pirau tsuig købig køn. Nøbe pilamera ciento diezkatig øsig tsuig købig køn. ");
INSERT INTO gum_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Incha Josébe Efrainwei katøburø awelu ureemeranguen nebua ashib, katø Manaséswei nusrkai tru Maquirwei ureemeranguen nai ureemeratøwein misran chib, srøbchagu mutab indig kuig køn. ");
INSERT INTO gum_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Incha Josébe wendøsrø nui nunelan trenchibig køn: —Nane yandø kwamig lutau køtan cha. Inchendø Tiusbe ñimune ashchab arrua, purugunrrun cha, Abrahamwanba, Isaacwanba Jacobwanba, ¡Katø! nabe tranmø kømø, tranamønrrun cha kørrømisrin pirausrømay ñimune i piraugurri pera inrrab køn cha.— ");
INSERT INTO gum_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Incha Josébe Israelwei nusrkalan, ‘¡Katø! nambe treeg maramønrrun’ tingarubig køn. Incha Josébe nømun trenchibig køn: —Isa kømø, Tiusbe ñimun ashchab arrua, purugunrrun cha. Treeg pubene, ñimbe nai tsutsiimerane yugurri srua ambamig køn— cha. ");
INSERT INTO gum_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Incha Josébe kwaig køn pilamera ciento diez nemisren. Inchen nui asrwane minchib irrømønrrai mø marøb tamara, kan taulyu wayig køn Egipto pirau. Fin");
INSERT INTO gum_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iibe Jesucristoi merrabsrø misaamerai munchimera køn, tru Davidweinukkurrimba, Abrahamweinukkurrimba amrrub misag. ");
INSERT INTO gum_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahambe Isaacwei møskain køben; Isaacbe Jacobwei møskain køben; Jacobpe Judába, nui nunelaimba møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judábe Faresweimba, Zaraimba møskain køben, tru uregwei usrimbe Tamar købig køn. Faresbe Esromwei møskain køben; Esrombe Aramwei møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arambe Aminadabwei møskain køben; Aminadabpe Naasónwei møskain købig køn. Inchen Naasónbe Salmónwei møskaingue. ");
INSERT INTO gum_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónbe Boozwei møskain køben, nui usrimbe Rahab købig køn. Boozbe Obedwei møskain køben, nui usrimbe Rut købig køn. Obedbe Isaíwei møskain køben; ");
INSERT INTO gum_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíbe Davidwei møskain købig køn. Inchen rey Davidba, Uríaswei srain købiibabe Salomónwei møskalø købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónbe Roboamwei møskain køben; Roboambe Abíaswei møskain køben; Abíasbe Asaiwei møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Inchen Asabe Josafatwei møskain køben; Josafatbe Joramwei møskain køben; Jorambe Uzíaswei møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasbe Jotamwei møskain køben; Jotambe Acazwei møskain køben; Acazbe Ezequíaswei møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasbe Manaséswei møskain køben; Manasésbe Amonwei møskain køben; Amonbe Josíaswei møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Inchen Josíasbe Jeconíasweimba, nunelaimba møskain købig køn, tru israelitasmeran Babiloniamay merrarrawa srua ambub uras. ");
INSERT INTO gum_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Øyeeg chab srua amben, Jeconíasbe Salatielwei møskain køben; Salatielbe Zorobabelwei møskain køben; ");
INSERT INTO gum_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelbe Abiudwei møskain køben; Abiudbe Eliaquimwei møskain køben; Eliaquimbe Azorwei møskain købig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorbe Sadocwei møskain køben; Sadocbe Aquimwei møskain købig køn. Inchen Aquimbe Eliudwei møskaingue. ");
INSERT INTO gum_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Inchen Eliudbe Eleazarwei møskain køben; Eleazarbe Matánwei møskain køben; Matánbe Jacobwei møskain køben; ");
INSERT INTO gum_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpe Joséwei møskain købig køn. Inchen tru Josébe Maríai keg køben, tru Maríagurri Jesús kal-laig købig køn, tru Cristo taig. ");
INSERT INTO gum_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Inchawei Abraham køb uraskurri merrabsrø kølli misaamerai ureemera katøle srøig, srøig kurrab arrubig David køb uraskatiibe catorce købig køn. Inchen David køb uraskurri tru israelitasmeran Babiloniamay merrarrawa srua ambub uraskatig katøgan catorce treetøwei katøle srøig, srøig misaamera kurrab arrig købig køn. Incha tru israelitasmeran Babiloniamay srua ambub uraskurri tru Cristo kal-lamnegatiibe misaamera katøgan catorce treetøwei kurrab arrig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo kal-laibe øyeeg kuig køn: María nui usrimbe Joséba kasharanrrab misra uñen, Josébe kasharanrrab permøwatø Maríabe Espíritu Santogurri kwanrriig kenamisrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Inchen José tru nui keg kønrrabiibe sølgandø tabig kua, Maríane maya misagwei malau ‘øyeeg kuin køn’ chib kenamarmønrrab, nuinetø niløtø tarømisrøptinchab isubig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nøbe treeg martrab chab isubguen inchen, Señorwei kan ángel piabyu kenamisrabe trenchibig køn: —José, ñi Davidwei misagugurri arrubig, Marían ñui srain kønrrai utamigwan kørig kui inchimøta cha. Kaguende tru unø tøgagømibe Espíritu Santoin køn cha. ");
INSERT INTO gum_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nøbe kan møg-unø tøgagøben, truigwane Jesús munchi pasrtrig chibig køn. Nøbe øyeeg wamig kønrrun chibig køn, kaguende nui misagwan kaig mariiløyugurri wesranrrabig kuimba.— ");
INSERT INTO gum_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kerrigu øyeeg pureppe, Tius maig karuigwan eshkabigwan Señor truigwan øyah taig nebunrrai treeg kuig køn: ");
INSERT INTO gum_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kan srusrø mu møøbagucha kimíig kwanrriig kørrømisra, kan unø tøgagønrrun taig. Truibe Emanuel cha wamig kønrrun” cha, trenchibig køn. (Tru Emanuel munchibe “Tiusbe namba pasran” taig.) ");
INSERT INTO gum_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Incha José tru piabyugurri kiagasrabe, Señorwei ángel maig karuig køben treeg mara, Maríane nui srain kønrrai kørrømarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Incha Josébe Marían nui nusrkawan tøgagømnegatig keeba, sraimba lataig nømui asrtøga chi marmuig køn. Incha Josébe unane Jesús munchi pasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesúsbe Judea pirau Belén puebloyu kal-labig køn, Herodes tru pirau rey køb uras. Inchen tru uras pørr kal-labgatøsrø kusreb møguelø tru estrellameran ashib kusrebelø Jerusalén puabe, ");
INSERT INTO gum_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","trenchib payibelø køn: —¿Judíosmerai tru rey kal-labiibe chu tsuh? cha. Kaguende nambe nui estrellan webarri asha, køriibala nune tabig waminchab amrruer— cha. ");
INSERT INTO gum_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Inchen rey Herodesbe trendaigwan mørabe, ni mumaygucha kømui inchibig køn. Inchen katø Jerusalén misaamerangucha treetøweim pubig køn. ");
INSERT INTO gum_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Inchen reybe sacerdotesmeran karubelanba, tru Moisés pørigwan kusrenanøbelanba wama, payibig køn: —¿Cristobe chu kal-lanrrabig kø?— cha. ");
INSERT INTO gum_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Inchen nømbe trenchibelø køn: —Judea pirau Belén cha. Kaguende Tius maig karuigwan eshkabig øyah pørig køn cha: ");
INSERT INTO gum_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea pirau, ñi Belén pueblo-unøbe, tru pirau purø wamindig ciudamerai utu ñibe chigucha kømøzhig lataig kønrrab kømø, purø nuig køn cha. Kaguende ñuinukkurrimbe misagwan ashib karunrrabig kan webattrun cha, nai Israel misagwan nø pera marøb ashib pasrønrrabig.— ");
INSERT INTO gum_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Inchen Herodesbe tru srømbalasrø estrellameran ashib kusrebelan mu ashmøwatø wama, estrellabe tappe chu uras kenamisrigwan payibig køn. ");
INSERT INTO gum_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Incha nømune Belénmay ørabe, trenchibig køn: —Trusrømay amba, tru unaimburab tab payrrigay cha. Incha wetørrawabe, eshkarrunrrigay cha, nagucha køriibala tabig waminchab inrrab— cha. ");
INSERT INTO gum_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tru kusrebeløbe rey øyeeg eshkailø ambubelø køn. Inchen estrella tru pørr kal-labgatøsrø asiibe nømui merraptø ya, yandø tru unø tsuim pala pasramisren, ");
INSERT INTO gum_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tru kusreb møguelø estrellan ashabe, truba truba kasraarabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Incha yau kebambabe, unamba, usri Maríanba ashabe, tømbønsra, køriibala tabig wamincha, nømui ketamelan kura, oro køben, incienso køben, mirra køben ketøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Incha yandø nømune piabyu Herodesweimburab ammønrrain cha, eshkailø kua, nømui pirausrømaybe peg maywan ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yandø tru kusreb møguelø chab amben, Señorwei kan ángel Joséwan piabyu kenamisrabe, trenchibig køn: —Kurra, unan usranba perøb Egiptosrømay trubab inrrø cha. Incha trusrø na eshkamnegatig kørrømisrtrig cha. Kaguende Herodesbe unan kwetchab lanrrab køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Inchen Josébe kurra, unan usranba pera, yem Egiptosrømay webya, ya, ");
INSERT INTO gum_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","trusrø tru Herodes kwamnegatig waraig købig køn. Øyeeg nebuppe, Tius maig karuigwan eshkabikkurri øyah taig, truig nebunrrain kuig køn: “Nai Nusrkawan Egiptogurri wamar” taig. ");
INSERT INTO gum_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Inchen Herodes nun tru kusreb møguelø isin kui mørabe, truba truba nama, tru kusreb møguelø tru ureg chu uras kal-laigwan eshkaigwan, trunun cuenta mara kal-laingurrimbunø pa pilagatiguelø Belén pøtøgatan warabelan kerriguba kwetchain karubig køn. ");
INSERT INTO gum_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Øyamay nebuig køn Tius maig karuigwan eshkabig Jeremías øyah pørig: ");
INSERT INTO gum_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá pueblosrø kan wam mørig køn cha. Truibe kan truba truba isuig wamab kishib, tru Raquel nui uregweimburab isua, kishibig køn. Incha ‘kishmø, ka awentau’ taingucha, awentanrrab kaimabig køn cha, kaguende yandø ureemera chab kwaikken køben. ");
INSERT INTO gum_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Inchen yandø Herodes kwaben, Señorwei kan ángel Joséwan Egiptosrø piabyu kenamisra, trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Kurra, unanba usranba pera, Israel pirausrømay katø inrrø cha. Kaguende unan kwetchab inchibeløbe yandø chab kwan— cha. ");
INSERT INTO gum_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Inchen Josébe kurra, unanba usranba Israel pirausrømay pera, ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Inchen Herodeswein cuentabe nui nusrkai Arquelau Judea pirau truig karub wan taig mørøppe, Josébe trusrømay yamig køriimatøben, Tius piabyu Judeasrømay imønrrai eshkaben, Galileasrømay ambig køn. ");
INSERT INTO gum_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Incha Josébe trusrø puabe, Nazaret pueblosrø tsunrrab ibig køn. Iig øyeeg nebuppe, Tius maig karuigwan eshkab møguelø øyah taig nebunrrain kuig køn: “Jesúsbe nazaretsriig cha wamig kønrrun” taig. ");
INSERT INTO gum_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tru kwalømmerawan Juan Bautista Judea pirau mu misag warab waraimønug ");
INSERT INTO gum_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","trenchib eshkab kusrenanøb arrubig køn: —Kaig mariilan isua møra, Tiusweimay lliray chib. Kaguende srømbalasrø Tius nø ashib karub waibe lutau pasran— cha. ");
INSERT INTO gum_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tru Tius maig karuigwan eshkabig Isaías øyah pørig Juanbe truig kuig køn: Kan wam mu misag warab waraimønug trenchib trasan, taig: “Señorwei maywan tamarøb, nuyasig maymerane ølmarøb inday,” chib. ");
INSERT INTO gum_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan kewagúibe camello isiitøga marig købig køn. Inchen nui pørønaibe kaluswan marig køben, nui mamibe nørrø chapullba kaambu mielba købig køn. ");
INSERT INTO gum_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén misaameraba, mayeelø Judea pirau misaameraba, Jordán pi puluwaneløba nun mørtrab werrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Incha nømui kaig mariilan ‘kaig marig køn’ chib eshkaben, Juanbe truilan Jordán piyu piu umbu ulsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Inchen Juanbe fariseosmera køben, saduceosmera køben, truba nørrø nø piu umbu ulsrailø kønrrab amrrui ashabe, trenchibig køn: —¡Ñimbe ul lataig inchib misaamera! ¿Ñimune mu eshkata cha, Tiuswei purø kørig kømdiig ñimuim pala attrabig pub pasrabigugurri wegørrønrraimbe? ");
INSERT INTO gum_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ñimui kaig mariilan isua møra, Tiusweimay llirawar kuy, chibig køn, tørgandø asamdiig kønrrain cha. ");
INSERT INTO gum_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Incha ñimbe ñimasiitø øyeeg chib mendømøtay cha: “Nambe Abrahamwei misaamera ker” chib. Kaguende nabe trendamønrrun cha: Tiusbe i sruumeranguen Abrahamwei misaamera kønrrai marøg købene, martrun cha. ");
INSERT INTO gum_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Katø walømbe tusrmeran srølba para øramig chabguen srølyu pasringuen pasran cha. Chi tusrwandøgucha tab mamig niimíigwane para, nagu kegutsan cha. ");
INSERT INTO gum_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nabe ñimune ciertonwei pi pinøbulrrai piu umbu ulsrar cha, kaig mariilan isua møra, Tiusweimay llirain kønmab asamdiig kønrrai. Trune nai wendau arrubiibe si, Espíritu Santotøgaba, naatøgaba pinøbulrrun cha. Truibe si, na lataguen kømø, maramburab marøbig køben, nabe truburab kømíig kua, nui alpargatiswanguen srua inrrabgaig kur cha. ");
INSERT INTO gum_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nøbe tirigun isig øra tarømartrab tru kala kutsamig tsig utigwan sruaguen pasran cha. Incha truyu tru tirigu chishmari yabaløwan kerrigu chab chishmarabe, tirigune tirigu esegainug esegappe, shauwane mana kwamø nagu pattrun— chibig køn Juanbe. ");
INSERT INTO gum_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesúsbe Galileasrøngurri Jordán piyumay arrubig køn, tru Juan uninuumay nun piu umbu ulsrønrrai. ");
INSERT INTO gum_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Srøtøbe Juanbe nune piu umbu ulsrøg kømui incha, trenchibig køn: —Nane ñiguen treeg marig kømdiig købendø, ¿ñiguen nan attirru?— cha. ");
INSERT INTO gum_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Inchen Jesúsbe trenchiptinchibig køn: —Møimbatøbe øyamay ka mar cha. Tius tru sølgandø tabig maramigwane nambe kutøgue øyamay maramig køn— cha. Inchen Juanbe ka treeg marøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Incha Juanbe Jesúswan piu umbu ulsrøben, piyugurri webibig køn. Inchen møimbe srømbalabe kurøptinchen, Jesúsbe Tiuswei Espíritu nuim pala kan paloma lataig kørraarri ashibig køn. ");
INSERT INTO gum_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Inchen srømbalasrøngurri kan wam trenchib waminchibig køn: —Iibe nai Nusrkai undaaraig køn cha. Nabe nuimburab truba tab kui war— cha. ");
INSERT INTO gum_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Inchen Espíritu Santobe mu misag warab waraimøsrømay Jesúswan pera yaig køn, nugwaimandzig nun kebenøsrkønrrab inchai. ");
INSERT INTO gum_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Inchen cuarenta días yem kwaløm chigucha mamøwa, yandø parøgwai mørøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Inchen tru kebenøsrkønrrab inchibiibe Jesúswan kemallabe, trenchibig køn: —Isa kømø, tru ñi Tiuswei Nusrkain kuabe, i sruumeran pirri misringaru— cha. ");
INSERT INTO gum_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Inchen Jesúsbe trencha løtabig køn: —Tiuswei wamwan pørigube trenchibig køn cha: “Møøbe pirrindøgatø øsig tsumøtø, kerrigu Tiuswei wamdøgagucha tsumig køn”— cha. ");
INSERT INTO gum_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Incha nugwaimandziibe Jesúswan Jerusalén tru Tiusweindø tarømari ciudasrømay srua ya, tru Tiuswei yau purø palasrø pasrabe, ");
INSERT INTO gum_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","trenchibig køn: —Isa kømø, tru ñi Tiuswei Nusrkain kuabe, pirausrø pørsrau cha. Kaguende Tiuswei wamyube trenchibig pørig pasran cha: Tiusbe nui ángelesmeran ñun ashchai ørtrun chibig. Incha ñui srøbwan srugu srurrengwamønrrai nømui tasiimeratøga ñun kusranrrun— chibig. ");
INSERT INTO gum_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Inchen Jesúsbe trenchibig køn: —Katø Tiuswei wamwan pørigube treekkucha chibig køn cha: “Ñui Señor Tiuswane ke chinchibig køtashchab lataikkucha maramig kømøn”— cha. ");
INSERT INTO gum_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Katøbe nugwaimandziibe kan truba pala tunsrømay srua yabe, yu pirau chutøgucha nørreelø tru nøm ashib karub purrailanba, katø nømui chigurrimbunø tabig tørig tøgagúigwanba kenamarabe, ");
INSERT INTO gum_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","trenchibig køn: —Iigwan nabe kerriguba tranrrumøn cha, ñi nan srala, køriibala tabig waminchene.— ");
INSERT INTO gum_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Inchene Jesúsbe trencha løtabig køn: —¡Satanás, møi møi iptsu! cha. Kaguende Tiuswei wamwan pørigube trenchibig køn cha: “Señor ñui Tiuswandø køriibala tabig waminchib, nuyasiitø marøb megamig køn”— cha. ");
INSERT INTO gum_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Inchen nugwaimandziibe nuinukkurri tarømisren, ángelesmera amrrua, purugubelø køn Jesúswan. ");
INSERT INTO gum_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautistan kailan keeri yau keerin køn taig Jesús wammørabe, Galileamay ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Incha Nazaret puebloyugurri webyabe, Capernaum pueblosrø pisu menda, Zabulónwei misag warainuuba, Neftalíwei misag warainuuba tru pirau tsunrrab ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Øyeeg nebuppe, Tius maig karuigwan eshkabig Isaías øyah taig nebunrrain kuig køn: ");
INSERT INTO gum_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulónwei misag warainuuba, Neftalíwei misag warainuuba tru pirau, Jordán pi ambøgatø tru nu pisugatømaysrø, Galilea tru judío kømeelø warainug, ");
INSERT INTO gum_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","misaamera løstøyu warabeløbe kan truba tørig asan chib. Kwamig nømuim pala itøgasraig lataig warabelø købelane kan tørig kebilin køn, chib pørig. ");
INSERT INTO gum_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Trugurrimbunø Jesúsbe eshkab kusrenanøb trenchibig køn: —Kaig mariilan isua møra, Tiusweimay lliray cha. Srømbalasrø Tius nø ashib karub waibe lutau pasran— cha. ");
INSERT INTO gum_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea nu pisu mendawan ib pasrøwabe, pa nunelan ashibig køn, kane Simón, truigwane katø Pedrogucha taig, kane Andrés taig. Truiløbe peskabelø kua, nømui atarrayameran piyu keguchib warøben, ");
INSERT INTO gum_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesúsbe trenchiptinchibig køn: —Nai mendig amrruy cha. Nabe ñimune misaameran peskabelø kønrrai maramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Inchen tru urastø nømbe nømui atarrayasmeran warøb, nøba ambuptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Incha Jesúsbe katøguchi mas ambuurø yabe, katøgan pa nunelø warai ashibig køn, truiløbe Zebedeowei nusrkalø, Santiagoba, Juanba. Nømbe nui møskaimba barcoyu atarrayamera kølsrailan tamarøb purrøbene, Jesúsbe tru nusrkalan wamabig køn. ");
INSERT INTO gum_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Inchen nømbe tru urastø barconba, nømui møskawanba kørrømarøppa, Jesúswei mendig ambuptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesúsbe Galilea pirau ørøba llirab ibig køn, judíosmera tulundzuni yamørig Tius nø ashib karub pasrainuguig tabig srø wamwan eshkab kusrenanøb. Incha misaameran chi kwanrreelan køben, chi pusrkwailan køben tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesúswane Siria pirausrø kerrigu wammøra kua, mayan kwanrreelan srua amrrubelø køn. Tru chi kwanrrø køben tøgarmeran, katø ni mumayguen tab kømui mørøb inchibelan, tru kwaimandziimera tøgarmeran køben, itønab pesannabig tøgarmeran køben, kønønrrab kaimabelan køben srua amrrubelø køn. Inchen Jesúsbe tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Inchen misaamera galileasreelø køben, decápolissreelø køben, jerusalénsreelø køben, judeasreelø køben, Jordán pi tru pørr kal-labgatøsreelø køben Jesúswei mendig truba nu ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Incha Jesúsbe misag truba truba nuwan ashabe, kan tun pala nebya wamisren, nui kusrenanøb pera uniilø kemallen, ");
INSERT INTO gum_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nøbe øyeeg chib kusrenanøb mendabig køn: ");
INSERT INTO gum_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Mayanguen tab kuilø køn cha, tru Tiusweimburabigwan ke kagømønrraindøzhig tøgaguermab isua palai mørøbelaimbe. Kaguende srømbalasrø Tius nø ashib karub waibe nømuiwein køn cha. ");
INSERT INTO gum_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mayanguen tab kuilø køn cha, tru truba isuig kishibelaimbe. Kaguende Tiusbe nømun chi isui inchimønrrai tab købigwan tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mayanguen tab kuilø køn cha, tru larrø tammayelø lata lata inchimeelaimbe. Kaguende nømbe tru pirøwan Tius trannrrab misrigwan ketig utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mayanguen tab kuilø køn cha, tru sølgandø tabigwan kan parøgwaig mørøb lataig, pi mulgwaig mørøb lataig inchibelaimbe. Kaguende maig isua palai melaigwan Tiusbe nømun nørrø traniilø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mayanguen tab kuilø køn cha, katøganelan lastima ashibelaimbe. Kaguende nømungucha Tiusbe treetøwei lastima ashib tøgagønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mayanguen tab kuilø køn cha, chi kaig isumø manrrømera chishig tøgarweimbe. Kaguende nømbe Tiuswan ashchun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mayanguen tab kuilø køn cha, tru ambugurri igurri tab kømigwan lab marøbelaimbe. Kaguende truilane Tiusbe ‘nai ureg køn’ chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mayanguen tab kuilø køn cha, tru Tius mandø martrai miaigwan marikkurri kaig martraindinab kaig nebui melabelaimbe. Kaguende srømbalasrø Tius nø ashib karub waibe nømuin køn cha. ");
INSERT INTO gum_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ñimbe mayanguen tab kuilø køn cha, nagurrindø misaamera tsalø waminab, kaig marinab, katø ñimun chine, chine isa wamindinab melabelaimbe. ");
INSERT INTO gum_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pøs truba kasraarab tab kui møray cha. Kaguende srømbalasrømbe truba truba nuig ketig utamig tøgagønrrun cha. Ñimguen kømøwatøsrøwei tru Tius maig karuigwan eshkabelan øyeetøwei kaig marig købig køn cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Ñimbe yu pirau tre latailø køn. Inchendø yandø tre larrmíig misrabe, ¿katøbe chincha kui larrøbig misriasamø? Yandø mas chiweingucha larrmíig misrene, wambig petøben, misaamerabe itøbunan, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ñimbe yu pirauelayasig tør latailø køn. Kan ciudama tun palasrø pasrabiibe trubønrrab kaiman cha. ");
INSERT INTO gum_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Katø kan aceite lámparan chigucha piløgøppe, køtsø umbu pasrtrab piløgømøn cha. Treeg kømøtø, masken pala pasrene, mayeelan yau purrabelan pilan chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Øyeetøwei ñimgucha misaamerai merrab ñimui tør pilønrrai inday chibig køn, ñimui tabig mariilan asha, nømbe ñimui Møskai srømbalasrø wabigwan truba tabig waminchain cha. ");
INSERT INTO gum_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Nabe arruppe, maig maramigwan martrai Moisés pørigwanba, Tius maig karuigwan eshkabelø kusrenaniilanba na patsøgønrrab arritamab isumøtay chibig køn. Nabe treeg kømøtø, arruppe, tru Moisés pørigu maig chibig køben, trunun newan mara kørrømartrab arrig køn. ");
INSERT INTO gum_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pøs nabe ñimun cierton trendamønrrun: Srømbalaba, pirøba pønrrøbenbatøbe, tru maig maramigwan martrai Moisés pørigu maya lamøzhig pørig pønrrabeløguen pinappe, purainrraamøn cha, kerrigu tru pørigu maig taig nebumnegatig. ");
INSERT INTO gum_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Inchawei møikkøben tru maig maramigwan martrai Moisés pøriiløyu karua pønsrailan møigu køben maya lamøzhigwandøguen kalø marøb, katø misagwan treetøwei kalø martrai kusrenanøbiibe srømbalasrø Tius nø ashib karub waisrømbe truibe purø lamíig kui asig køn taig kønrrun. Trune møikkøben martrai karua pønsrailan marøb, katø treetøwei martrai kusrenanøbiibe, truibe si, srømbalasrø Tius nø ashib karub waisrømbe nuig kui asig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","’Inchawei nabe ñimune eshkar: Ñimui sølgandø marigwan tru Moisés pørigwan kusrenanøbeløba, fariseosmeraba marøb pønrrai lataitøguen kømø, katøguchi tabig marmuisruandøbe, srømbalasrø Tius nø ashib karub waisrømbe managuen kebamrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ñimbe mørøbelø kuinrrun ñimui merrabsreelane trendaigwan: “Kweechimøta cha. Møikkøben kweechibiibe kaigyu pasrønrrai pasrig kønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Trune nabe trendamønrrun: Møikkøben nui nunewan namig kørrømisrøbiibe kaigyu pasrønrrai pasrig kønrrun cha. Nunewan tsalø wamabigwane tru Setenteelø maig maramigwan asha marøbelø asha marig kønrrun cha. Inchen møikkøben nunewan trømbøig inchib: “Larrø kaig chugúi mørmíig køn” chib wamabiibe, tru kwamø nagu møra melamnug kegutsig kømigwan lab pasran cha. ");
INSERT INTO gum_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Inchawei ñi Tiuswei tranamigwan altaryumay srua arrua, ñui nunewan ñi chigøben kaig mara tøgagúigwan ñi isuptinchabe, ");
INSERT INTO gum_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tru ñi Tiuswan tranamigwan altaryu pasrøppa, ñui nuneeba tab kørrømisramigwanmerrig lanrrab yamig køn. Trugurrimbe si, altaryumay arrua, ñui tranamigwan tranø. ");
INSERT INTO gum_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Møikkøben ñun kejawa, juezweimay merranene, tru kejabiiba mayu ib pasrappatø, tammay kørrømisrkun cha, petø wamindam lau, tru juezwei tasku tranmønrraimbe. Inchippa juezbe policíameran tranen, truiløbe ñun kailan keeri yau kegutsinamønrrappe. ");
INSERT INTO gum_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pøs nabe ñimun cierton trendamønrrun: Truyugurri webinrrappe, maig pagaramigwan chishtø pagarawatøwei webinrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Merrabsrø øyah taigwan ñimbe mørøbelø kuinrrun: “Møikkøben kasharawaig købendø, peg ishuuba itølulamig kømøn”, taigwan. ");
INSERT INTO gum_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Trune nabe trendamønrrun: Møikkøben kan ishuwan trømbøig martrab isub chull ashibiibe nui manrraube yandø chabguen itølulig lataig kørrømisran cha. ");
INSERT INTO gum_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Inchawei treekkurri ñui kusrmay kab kaig maringarua, kaigu ñun kebenøsrkøbene, wesrua, kuchi chibig køn. Trembe ñui asru kanbaløtø palab misrikken chi kømønrrun cha, tru møra melamnug asr ørøba kegutsig købgunrriibe. ");
INSERT INTO gum_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ñui kusrmay tasig kaig maringarua, kaigu ñun kebenøsrkøbene, tasigwane para, kuchi, chibig køn. Trembe ñui asru kanbaløtø palabikken chi kømønrrun cha, tru møra melamnug asr ørøba kegutsig købgunrriibe. ");
INSERT INTO gum_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Katø merrabsrømbe trendaig købig køn: “Møikkøben nui srawan kucha, tarømisrtrappe, kan kilga tarømisrtrab chibig mara, nun purøøramig køn” cha. ");
INSERT INTO gum_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Trune nabe trendamønrrun: Mu møøtøgucha nui srai, itølulmubendø, srawan kucha, tarømisrøbiibe, nui srawane itøluløb uñchai maran cha. Inchen mu møøtøgucha kan tarømisra ishuuba kasharabiibe nøgucha treetøwei itølulan cha. ");
INSERT INTO gum_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Katø ñimbe møriinrrun ñimui merrabsreelan øyah tailan ‘Señorwei merrab, ¡katø! marmø kømø, nabe maramønrrun’ cha kørrømisrigwane wamindiitø kømø, maramig køn taigwan. ");
INSERT INTO gum_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Inchendø nabe ñimun trendamønrrun: ‘¡katø! marmø kømø, nabe maramønrrun’ chib mumaygucha ke treeg chimøtay cha. Srømbalawei merrab pasramisra ‘¡katø! marmø kømø, nabe maramønrrun’ chimøtay cha. Kaguende srømbalabe Tius nø wamisra waig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Katø ñimbe pirøwei merrab pasramisra, ‘¡katø! marmø kømø, nabe maramønrrun’ chimøtay cha. Kaguende pirøbe Tius itøbuna waig køn cha. Ni katø Jerusalénwei merrab chigucha treeg maramig kømøn. Kaguende truibe Tius, tru purø nu Reywei ciuda køn. ");
INSERT INTO gum_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni katø ñimui turwan ‘¡katø! marmø kømø, nabe maramønrrun’ chimøtay chibig køn. Kaguende ñimbe pusrugwan ni kandøguen puliig martrab kaimabwei, ni kandøguen yaliig martrab kaimabwei inchun cha. ");
INSERT INTO gum_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Inchen ñimbe martrappe: “Øø” tamig køn. Inchen marmønrrappe: “Ka” tamig køn. Pøs yandø i trendaigugurri mas nemarøb, ‘¡katø! marmø kømø, nabe maramønrrun’ taibe nugwaimandzigweinukkurri arrubig køn. ");
INSERT INTO gum_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Katø ñimbe merrabsrø trendaigwan mørøbelø kuinrrun: “Katøganui kabwan mindishibigwane nuin kabwangucha mindisamig køn”, taigwan. “Katøganui trugulwan lanchibigwane nuin trugulwangucha landamig køn”, taigwan. ");
INSERT INTO gum_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Trune nabe trendamønrrun: Møikkøben ñun kaig marene, lata inchimøta cha. Treeg kømøtø, møikkøben ñun kusrmay maløbøtø pashene, kandarømayigwangucha yul cha. ");
INSERT INTO gum_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Møikkøben kejawa kewagúigwan kerranrrab inchene, turiwangucha srua ibasingaru cha. ");
INSERT INTO gum_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Møikkøben ñun nama, kan kilómetro chigøben niguingarubene, trube, pa kilómetro nig cha. ");
INSERT INTO gum_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Inchen møikkøben ñun chi miabigwane tranø cha. Møikkøben ‘pebrra’ cha, miabene, ‘ka’ chimø, peb cha. ");
INSERT INTO gum_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ñimbe katø merrabsrø trendaigwan mørig kuinrrun: “Ñui tab linchibigwane isua, undaaramig køn chippe. Ñun tsaliigwane ashig kømui indamig køn”, taigwan. ");
INSERT INTO gum_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Trune nabe ñimun trendamønrrun: Ñimun ashig kømui inchibelane undaaray cha. Inchen ñimun kaig martrabgøba inchibelaimbe nømuyasig Tiusba wamindamig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Treeg marabe, ñimbe Møskai srømbalasrø wabigwei ureg kønrrabguen. Kaguende nøma nui nøsigwan kailaim pala lata, tabelaim pala lata pørr patingarub, katø sølgandø tabig marøbelaim pala lata, chi sølgandø tabig marmeelaim pala lata sre punrrai ørøb inchibig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kaguende ñimun undaarabelandø undaarawabe, ¿truburøbe chigúi utønrrague? ¿Romasreelayasig an utabeløguen treetøweimbe marøbelø kømuitarru? ");
INSERT INTO gum_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Inchen ñimui nunelandø tab wamabiibe, ¿chigúi srøig peg marig kønrrautah? Kaguende ¿Tiuswan ashmeelø tru judíos kømø misaameraguen treetøweimbe marøbelø kømuitarru? ");
INSERT INTO gum_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ñimbe sølgandø newan tabelø kuy, ñimui Møskai srømbalasrø wabig newan tabig køb lataitøweingue. ");
INSERT INTO gum_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ñimui tabig mariilan misaamerai malau marmøtay, misaamera ka ashchaindø lataig. Ñim treeg marene, ñimui Møskai srømbalasrø wabiibe chigucha truburøbe tranrraamøn. ");
INSERT INTO gum_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Inchawei palai inchibelan ñi puruguppe, mayeelø wammørtrai waminchib kenamarmøta. Tru palatø tab inchibelø latawei judíosmera tulundzuni yamerayu, callesmerayu misaamera nømun tabig waminchai marøbelø lataig marmøta. Kaguende nabe ñimun cierton trendamønrrun: Yandø treeg marøbeløbe nømui truburø ketig utamigwane utabguen indan cha. ");
INSERT INTO gum_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Inchen palai inchibelan ñi puruguppe, ñui kusrmay tasig marigwane atsimay tasig asha kønrrai marmøta. ");
INSERT INTO gum_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Inchen ñi mun kenamarmøtø mariilan Tius ñui Møskai ashibiibe ñun truburø ketamigwan kettrun. ");
INSERT INTO gum_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ñim Tiusba waminchib pønrrappe, tru palatø tab inchibelø lataig kømøtay. Truiløma judíosmera tulundzuni yamerayu køben, plazayu ya tsøbmerasrøn køben pønrramisra, Tiusba wamindamig chullelø køn, misaamera ashchai. Nabe ñimun cierton trendamønrrun: Nømun misaamera tabig wamindiibe, truibe truburø ketig chabguen utabguen indan cha. ");
INSERT INTO gum_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Trune ñibe Tiusba waminchappe, ñui kwartuyu kebya, yaskabwan kasra, ñui Møskai Tiusba waminchi cha, mu asiimíig truyu ñibatø pasrabigwan. Inchen ñi mun kenamarmøtø marigwan Tius ñui Møskai ashibiibe ñun truburø ketamigwan kettrun. ");
INSERT INTO gum_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Tiusba waminchib pasrappe, trunundø katøle, katøle ka yandø wama mørmøta, judíos kømeelø latawei. Kaguende truiløbe truba truba waminchene, Tiusbe katøguchinguen mørtraitamab isubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ñimbe nøm latailøwein kømøtay. Kaguende ñimui Møskai Tiusbe ñim miamøwatø ñimui chi palai indigwane chab ashaguen wan. ");
INSERT INTO gum_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ñimbe Tiusba waminchib pønrrappe, øyah chinrrigay: Namui Møskai srømbalasrø wabig, ñui munchibe tabigweindø tarømara, newan tab indig kønrrun. ");
INSERT INTO gum_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ñi ashib karub pasraibe pirau larrøbitchab amø, srømbalasrø latawei yu piraugucha, ñi maig maramdiig køben, treegwei marig kønrrai. ");
INSERT INTO gum_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kwalømmørig nam mamig maig palabigwan møi tranøb, ");
INSERT INTO gum_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","namui kaig mariilan ulø paymø, pesannarrunrrig chib, nam namun kaig marøbelan ulø paymø, pesannawa kørrømisrøb lataitøwei. ");
INSERT INTO gum_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Chigøben namun kegørrøsrkønrraptiig pønrrøbene, truwane namun ambashmørrunrrig. Masken tru kaigweinukkurrimbe tarømartra. Kaguende, tru ashib karub waiba, maramburab mariiba, purø nuig, purø tabiibabe managatig ñuin køn chib. ");
INSERT INTO gum_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Kaguende katøganelø ñimun kaig maren, truilan ñim ulø paymø, ñim pesannabene, ñimui Møskai srømbalasrø wabikkucha ñimun ulø payamigwan paymønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Inchen katøganelan ñim pesannamø, ulø payene, ñimui Møskai srømbalasrø wabikkucha pesannamø, ñimui kaig mariilan ulø payrrun chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ñim ayunappe, malømera kwa isuig lataig misrmøtay. Tru palatø tab inchibeløma malømerabe kwa isuig latailø kenamarøbelø køn, misaamera nømbe ayunab kui ashchai. Treeløwein kønrrab kømø. Pøs nabe ñimun cierton trendamønrrun: Yandø nømun misaamera tabig wamindiibe, truibe truburø keti lataig chabguen utabguen indan cha. ");
INSERT INTO gum_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Inchen ñibe ayunappe, maløwan kwalla, pusrugwan tabig tamar cha, ");
INSERT INTO gum_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","misaamerabe ñun ayunab wain kønmab ashmønrrai. Ñuinetø marigwan ñui Møskai ashib pasrabiibe trunun asha, nøbe ñune truburø tranamigwan tranrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Yu pirau chine, chine tulishimøtay, pullillamera mab, trerawa pinab, nileelø kebamba nilab indinug. ");
INSERT INTO gum_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Trembe srømbalasrøwei tøgamisrøb tulisay, pullilla mamøwei, trerawa pinømøwei, nileelø nilønrrab kebammøwei indinug. ");
INSERT INTO gum_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kaguende ñimui chi tøgagúilø chu esegaig pønrrøbene, ñimui manrrøgucha ke truyutø isub pasrønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Asru kappe kan lámpara køn cha. Inchawei ñui kab tabig købene, ñui asrube kerriguba tørsulu kønrrun. ");
INSERT INTO gum_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Inchen ñui kab kaig købene, ñui asrube kerriguba løstiig kønrrun. Inchawei tru tør ñuinug pasrabikken løstiig købene, tru løstiibe mas maig løstøgølig kerah chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Nun karunrrabelø muguen pagatøbe tøgagønrrab kaimanrrun. Kaguende kanune tsalø ashippe, kanune undaaranrrun cha. Kanune chiyugucha truba tab mørøb megappe, kanune kaashib webinrrun cha. Inchawei Tiusweimburabigu marøb pasrønrrab isumba, anweimburabigu marøb pasrønrrab isumba inchibiibe martrab kaimanrrun cha, pabaløbabe. ");
INSERT INTO gum_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Inchawei nabe ñimun trendamønrrun: Øsig amønamig, ñim mamigwanba, mutsamigwanba, asru chi kemermab isumigwanba menrra isumøtay cha. Øsig amønamikkan kan mamig lataitø kuitarru cha. Kabe asrkan kan asru keelø lataitø kuitarru cha. ");
INSERT INTO gum_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pala amøñibelø illimeran asay chibig køn. Ellguamøwei, ellmarig tulishimøwei, ellmarig tulisaigwan esegainug esegamøwei inchibelanguen, truilanma ñimui Møskai srømbalasrø wabiibe manrrai mannøbig køn cha. ¿Ñimbe illimera lataguen kømø, maselø kømøtirru? chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ñim møiløgøben maya, maya incha katøgan tøbø metrotøguen nurabsruguh? cha. ");
INSERT INTO gum_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Chindimbarre ñimbe asru keegwan truba truba isubelø køgue? cha. Wambig umeranma asay chibig køn. Kwallmøwei, kumøwei inchibelø købendø, tabig nørrøran cha. ");
INSERT INTO gum_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Inchendø nabe trendamønrrun: Rey Salomónguen nui chine purø tabzhig tøgagua, umera lata tabzhiibe kemuig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wambig kaumera, møi ka pønrrøwa, srønabe nagu parrig kønrrabigwanguen Tiusbe øyeeg tabzhig kenanøb lataig marøbiibe, ñimune treetøguen kømøtø, masken marmønrraitarru cha, ñim ya ñimui isubigwan Tiusweinug pasra ke kagømønrraindøzhig tøgarwan. ");
INSERT INTO gum_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Inchawei øyeeg chib chi isumøtay chibig køn: “¿Chi mamer?” chib; “¿Chi mutsamer?” chib; “¿Chi kemer?” chib. ");
INSERT INTO gum_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kaguende tru Tiuswan ashmeelø judíos kømø misaamerabe iigwandø isub labelø køn. Inchen ñimui Møskai srømbalasrø wabiibe ñimui chi palabelan ashaguen wabig køn. ");
INSERT INTO gum_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Inchawei Tius nø ashib karub wainuguigwanba, katø tru sølgandø tabigwanba, truilanmerrig lab maramig køn. Trumaybe tru katøgan chi palabelangucha ñimbe nemarig kerrigu utønrrun. ");
INSERT INTO gum_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Inchawei srøna kwalømweyigwane chi isumøtay. Kaguende srøna kwalømweyigwane srøna isumig nøørø køn. Kaguende kwalømmørig chi pub arrubiitø tsabø køn isumibe. ");
INSERT INTO gum_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ñimbe katøganelan ‘øyeeg, øyeeg marøbelø køn’ chib waminchimøtay, ñimungucha ‘øyeelø køn’ tainamønrrappe. ");
INSERT INTO gum_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ñim katøganelan ‘øyeelø, øyeelø køn’ chib wamindiibe, ñimungucha treetøwei martrun. Ñim kanelan maig unaasha traniibe, ñimungucha treetøwei unaasha tranrrun. ");
INSERT INTO gum_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chindimbarre ñui nunewan kabyu shauzhig wabigwangøba ashku cha, tru ñuin kabyu nu tsig wabigwanguen ashmubendøbe? ");
INSERT INTO gum_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Inchawei ñitøweinguen ñuin kabyu nu tsigwan ashmubendøbe, ñui nunewane chincha øyeeg chinrragu: “Nai nuneg, ¿ñuin kabyu shauzhig wabigwan wesrarruah?” cha. ");
INSERT INTO gum_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ñi, palatø tabig, ñuin kabyu nu tsig wabigwanmerrig wesru chibig køn. Treenchabe si, ñui nunewein kabyu shauzhig wabigwan wesrumig tab ashchabguen cha. ");
INSERT INTO gum_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Chigøben Tiusweindø tarømarigwane werameran tranmøtay. Katø ñimui perlasmerane kuchimeran kebusrmøtay, inchippa truilan itølula, llirawa, amrrua, kurmillustøga kwanaguchib ñimun pitis marinamønrrappe. ");
INSERT INTO gum_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Miabene, Tiusbe ñimune tranrrun. Lawabe, wetørranrrun. Yaskabu wamubene, ñimune kurtrun. ");
INSERT INTO gum_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaguende mugucha miabiibe utøben, labiibe wetørraben, yaskabu wamabigwane kurtrun. ");
INSERT INTO gum_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Kabe ñimma møikkøben ñui nusrkai pirri miabene, kabe, ¿kan pillisrugwan tranøbsruguh? ");
INSERT INTO gum_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kabe kan peskau miabene, ¿kan ulwan tranøbsruguh? ");
INSERT INTO gum_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pøs ñimma ya kailø købenguen ñimui uregwane tabig keta tranøbelø køben, kan mas ñimui Møskai srømbalasrø wabiibe nun miabelane, maig tabig tranrrer chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Inchawei ñimma katøganelø ñimuyasig tabig maramig palai inchibeløbe, ñimgucha katøganelan treetøwei maray chibig køn. Kaguende maig maramigwan martrai Moisés pørigu lata, Tius maig karuigwan eshkabelø pøriiløyu lata iigwanwei martrai karubig køn. ");
INSERT INTO gum_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Trag yaskabwan kebambay chibig køn. Kaguende tru kan lendø yaskappa, tru lendø maybabe managuen werrumikkaig kegørra pønrramsrømay pera ibig køben, truwane si, møiløgøben truba nu kebamban cha. ");
INSERT INTO gum_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Inchen tru trag yaskappa, trag mayba managuen patsømø øsig purramsrømay pera ibiibe, truiløbe traguelø, trurrigu murelø køben, trunun wetørrabeløbe mamdø køn chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Tab asha kuy, chibig køn, ‘Tius maig karuigwan eshkabelø ker’ chibelø isa waminchibelan, ñimuimay kan ubisha lataig amrrubendø, nømui umbube kan namig lobosmera latailø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Trune ñimbe nømui maig mariiløyutøguen tsabø ashchun, tusryu mamig niguigwan latawei. Kaguende kal tusryugurrima uvas lurrmøwei, katø kaldø misrøb tusryugurri yashig lurrmøwei indan. ");
INSERT INTO gum_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Inchawei kan tab tusrbe tab mamig niguen. Trune kan kaig tusrbe kaig mamitøwei nigan cha. ");
INSERT INTO gum_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Inchawei kan tab tusrbe kaig mamig niirrab kaimabwei, katø kan kaig tusrbe tab mamig niirrab kaimabwei indan cha. ");
INSERT INTO gum_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Inchawei chi tusrwandøgucha tab mamig niimíigwane para, nagu kegutsan. ");
INSERT INTO gum_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Inchawei nømui mariiløyu ñimbe ashchabguen chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Nan: “Señor, Señor” chibelø srømbalasrø Tius nø ashib karub waisrømbe mayeeløba kømøtø kebamrrun. Treeg kømøtø, nai Møskai srømbalasrø wabig maig maringaruben, trunun marøbeløtøwei kebamrrun. ");
INSERT INTO gum_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tru srabe kwalømbe nane møiløgøben truba nu trenchinrrun: “Señor, Señor, yamba nambe ñui munchiyu ñi maig karuigwan eshkab, ñui munchiyu kwaimandziimeran webetab, ñui munchiyu maramburab mariilan marig købig køn” cha. ");
INSERT INTO gum_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Inchene nabe trendamønrrun: “Managuen nabe ñimune ashmíig kur cha. Ñim larrø kaig marøbeløbe, nainukkurri tarømisray” cha. ");
INSERT INTO gum_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Møikkøben na wamindigwan mørøb, na maig taigwan møra marøbigwane kan møg tab isua marøbig lataig køn chinrrab. Nui yawan srug pala marøbig lataikke. ");
INSERT INTO gum_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sre pub, pimera nurab, yawan isig megambub itsingucha, yabe peñmøn cha, kaguen srug pala marig pasrøwa. ");
INSERT INTO gum_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Inchen nan mørøppe, mørendø, na maig taigwan marmíigwane, kan møg tab isua marmíig lataig køn tamønrrun cha, nui yawan pisrum palatø marøbig lataikke. ");
INSERT INTO gum_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sre puben, pimera nuraben, yawan isig megambub ichen, yabe peña, purø isumdiig mindisaig kørrømisran— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Inchen Jesús iilan kerrigu chab waminchen, maya misaaba kwaara asha kørrømisrøbelø køn øyeeg kusrenaniilan. ");
INSERT INTO gum_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kaguende nøbe kusrenanøppe, nuinukkurrindøwei mu mandamgaig kusrenanøbig køn, tru Moisés pørigwan nømui kusrenanøbelø lata kømø. ");
INSERT INTO gum_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yandø Jesús tun palasrøngurri kørraarruben, misag truba nu mendig amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Inchene kan møg asr trerab kwanrrø, lepra taig, tøgaig kemallippa, Jesúswei merrab tømbønsrabe trenchibig køn: —Señor, nan ñi tamaramdiig købene, tamartra— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Inchen Jesúsbe tasigwan larrøbicha estsarabe, trenchibig køn: —Tamarøg køtan cha. Tamarig kørrømisr— cha. Inchen tru urastø nui trerab kwanrrøbe chishig kørrømisren, ");
INSERT INTO gum_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesúsbe trenchibig køn: —Au, mungøben eshkawabesin cha. Inchendø ya, ñui asrwan sacerdotendø kenamara, katø Tiusweyasig tru Moisés tranrrig taigwane srua ya, tranrrig cha, mayeeløba ñui kwanrrøwan chishig kørrømisrin kui ashchain— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yandø Jesús Capernaumsrø kebibene, romanosmerai suldau cienelan ashibig, kan centurión taig, nuimay arruabe, nun purugurra chib, ");
INSERT INTO gum_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","trenchibig køn: —Señor, nai mendig megabiibe yau kwanrrø tsun cha, truba truba pusrkwai inchib, kerrigu kønønrrab kaimaig.— ");
INSERT INTO gum_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Inchene Jesúsbe trenchibig køn: —Nabe arrua, tamaramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Inchen tru centuriónbe trenchibig køn: —Señor, ñi nai yau kebattraimbe, nabe trengatig kømuinatan cha. Tammisr cha, treetø chirra cha. Nai karuindiig megabiibe tammisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kaguende nagucha mas nørreelø karuig kur cha. Katø treeg køben na karub tøgagúilø suldaumera tøgagur cha. Truilanma na møigwan køben: “Inrrø” chibene, ib; katø na møigwan køben: “Amø” chibene, arrub; katø nai karuindiig megabigwan chigøben: “Mar” chibene, marøb inchibig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús iigwan møra, kwaara asha kørrømisrabe, nui mendig amrrubelan trenchibig køn: —Nabe ñimun cierton trendamønrrun: Israelsrø møigweinukken isubigwan nainug pasra tøgagúig øyangatig nuig wetørramur cha, i møwei lataig. ");
INSERT INTO gum_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Incha nabe ñimune trendamønrrun chibig køn: Pørr kal-labgatøsrøngurrin køben, pørr kebibgatøsrøngurrin køben truba nu amrrua, Abrahamba, Isaacba, Jacobpa manrrab purramisrtrun cha, srømbalasrø Tius nø ashib karub waisrø. ");
INSERT INTO gum_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Trune Tius nø ashib karub waisrø purrønrrab ureemerabe wambig purø trømbø løstøyu webusriilø kønrrun cha. Truyube kishib, trugulmeran tsatsamig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Incha Jesúsbe tru centuriónwan trenchibig køn: —Yamay inrrø cha. Ñi maig køreig treeg kønrrun— cha. Inchen tru urastø tru mendig megabiibe tammisrig køn. ");
INSERT INTO gum_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús Pedroi yamay arrua, kebyabe, Pedroi sueerabe camayu pachiiba tsui ashibig køn. ");
INSERT INTO gum_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Incha Jesúsbe tru ishuwei tasigwan katørabene, pachiibe weetaptinchen, nøbe kurra, tru pubelayasig chi maramigwan marøb mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yandø yem misren Jesúsweimay truba yamelan kwaimandzig tøgarwan misaabe srua amrruben, kan wamitøgatø tru kwaimandziimeran webetab, katø chi kwanrrø køben tøgarwan mayeelan tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Øyeeg pureppe, Tius maig karuigwan eshkabig Isaías øyah taig nebunrrain kuig køn: Nøtøwei namui pusrkwabelanba, namui kwanrrømeranba kerran, taig. ");
INSERT INTO gum_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesúsbe nuin pøtøgatan misaamera truba nu tulsrua kui ashabe, nui kusrenanøb pera uniilane pisu ambøgatømaysrø larramrrai karubig køn. ");
INSERT INTO gum_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Inchen tru maig maramigwan martrai Moisés pørigwan kan kusrenanøbig kemallabe trenchibig køn: —Kusrennøbig, ñi chu ibendø, nabe mendig arrumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Inchene Jesúsbe trencha løtabig køn: —Zorramerabe waramig trab tøgagøben, katø pala amøñib illimeragucha nømui lemera tøgar køn cha. Trune na, Møg Misra Arrubiibe ni nai turwan chu nerrarramikken chigaig kur— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inchen katøgan møikkøsrøn, Jesúswan mendig uñibiibe, trenchibig køn: —Señor, nai møskawan sørønrrabmerrig ibashcha— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Inchene Jesúsbe trenchibig køn: —Ñibe nai wendau amø cha. Tiusweimburabigu kwaig latailøbe nømui kwailan sørøbash— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús yandø barcoyu nebiben, nui kusrenanøb pera uniiløbe nun lincha ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Inchene møimbe maryube truba trømbøig mur isig ichib kurra, pi welarmera barcoyu mas, mas negutsingucha, Jesúsbe kib tsubig køn. ");
INSERT INTO gum_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Inchen nui kusrenanøb pera uniiløbe kasrønanrrab amba, trenchibelø køn: —¡Señor, namun wesrurra chib, chab asentab meler!— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Inchen nøbe trenchibig køn: —¿Chindimbarre kørig køta? cha. Ñim kui ñimui isubigwan nainug ke kagømønrraindøzhig pasra tøgar— cha. Incha kurrabe, isigwanba, marwanba kønømønrrai kandø wamuben, ¡katø! yandø kerrigu wasrønzhig kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Inchen nømbe kwaara asha kørrømisra, trenchibelø køn: —¿Øyeebe chi møg kerah? cha. ¡Isig ichibig lata, mar lata, iiløguen nun mørtrappe!— ");
INSERT INTO gum_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús pisu ambøgatø Gadara pirausrø larraibene, pailø kwaimandzig tøgarmera sørin trabmerayugurri werrua, Jesúswan kemallibelø køn. Truiløbe truba namiguelø køptø, tru maywane mugucha puramrrab kaimabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Inchabe trenchib trashibelø køn: —Tiuswei Nusrkai, ¿namune chi martrab inchigu? cha. ¿Namun ¡katø! purø trømbøig møra melønrrai martrab attirru cha, tru treeg maramig pumøwatøbe?— ");
INSERT INTO gum_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Truyugurri maya yab køsrøn kuchimera truba nu lawa mab amøñibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Inchen tru kwaimandziimerabe Jesúswan trenchib rugabelø køn: —Namun webetappe, trube, tru kuchimerayu kebambingarurrunrrig— cha. ");
INSERT INTO gum_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Inchene Jesúsbe trenchibig køn: —Ambay pøs— cha. Inchen tru kwaimandziimerabe møguelainukkurri webamba, kuchimerayu kebamben, tru urastø kuchimerabe luløb mendappe, truba trømbø lendeyu lula, chab pinøgørraptincha, larrø nu pisuyu kegørra, pi keesra, chab kwabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Inchen tru kuchi ashibeløbe chab lula, pueblosrø puabe, tru kwaimandzig tøgar købelan maig purayaigwan kerriguh waminchib mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Inchen puebloyu maya misaabe Jesúswan katønrrab webamba, nun ashabe, tru piraugurri ‘irra’ cha, truba rugabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Inchen Jesúsbe kan barcoyu nebya, pisu ambøgatøsrø larraya, nui puebloyu pubig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Inchen truyube kan møg kønønrrab kaimabigwan kan tsigalyu muta amrruben, Jesúsbe nømui isubigwan ke nuinuutø pasra pønrrai ashabe, kwanrriigwane trenchibig køn: —Nai nusrkai, kullaaramøta cha. Ñui kaig mariilan ulø payamig kømíig, pesannaig kørrømisran— cha. ");
INSERT INTO gum_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Inchen møiløgøsrøn tru Moisés pørigwan kusrenanøbeløbe treeg isubelø køn: “Nøbe Tiusweimburab purø trømbøig waman” chib. ");
INSERT INTO gum_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Inchen Jesúsbe nøm chi isub kuilan ashabe, trencha payibig køn: —¿Ñimbe ñimui manrraube chindimbarre øyeeg kaig isub køgue? cha. ");
INSERT INTO gum_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Møigwan mas kørmø trendamdiig købsruerah? cha. Kabe: “Ñui kaig mariilan ulø payamig kømíig pesannaig kørrømisran”, ¿tamiteh? Kabe: “Kurrab, inrrø”, ¿tamiteh? cha. ");
INSERT INTO gum_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pøs, na, Møg Misra Arrubiibe yu pirau kaig mariilan ulø payamig kømíig pesannaig kønrrai mu mandamgaig marøbig kui møimbe ñim ashchai kenamaramønrrun— chibig køn. Inchabe tru kønønrrab kaimabigwane trenchiptinchibig køn: —¡Kurrø! cha. ¡Ñui tsigalwan mutab, ñui yamay inrrø!— cha. ");
INSERT INTO gum_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Inchen kwanrriibe kurra, nui yamay ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Inchen misaamera iigwan ashabe, truba kørig kui inchibelø køn, Tiusbe møguelan øyeeg mu mandamgaig maramig tranitamab isua. Incha øyeeg marikkurri Tiuswan truba tabig waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús truyugurri yabe, kan Mateo taig møwan romasreelayasig an utabelø purrainug wai ashabe, trenchibig køn: —Nai mendig amø— cha. Inchen nøbe kurrab, nui mendig ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Indiibe Jesúsbe tru Mateowei yau mab wabene, truba yamelø romasreelayasig an utabelø køben, katøganelø kaig marøb misaamera køben puabe, Jesúsba, nui kusrenanøb pera uniiløba mishatsigu trubalatø purrøben, ");
INSERT INTO gum_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","møiløgøsrøn fariseosmera trunun ashabe, nui kusrenanøb pera uniilan trencha payibelø køn: —¿Ñimui kusrennøbiibe an utabeløba, kaig marøbeløba mab, muchib wappe, øyeebe maig marøb wah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Inchene Jesús trunun mørabe, trenchibig køn: —Tabelø kwanrrøgarbe mø marøbig palain kømøn cha. Kwanrreeløbeguende palain køn cha. ");
INSERT INTO gum_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Amba, i pørigu chi chibig kuigwan kusrey cha, tru Tiuswei wamyu øyah chibigwan: “Animal kweecha, nan tranøb kømøtø, ñimbe lastima ashibelø kønrrai inchar” taigwan. Kaguende nabe sølgandø amøñibelan wamønrrab arrumøtø, kaig marøbelan wamønrrab arrig køn— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan Bautistai mendig amøñibelø Jesúswan kemallabe, trencha payibelø køn: —Namba, fariseosmerababe ayunamigwan katø katø marer cha. ¿Inchen ñui kusrenanøb pera uniiløbe chindimbarre trunun marmeelø køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Inchene Jesúsbe trenchibig køn: —¿Kan novios yaumay linchai eshkailanma novio nømba wabengan isuin purrønrraitarru? cha. Inchendø yandø novion srua ambam kwalømmera punrrun cha. Inchen ayunabwei inchun cha. ");
INSERT INTO gum_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Muguen kan køllin camisanma kølsraigu srø llensu søtiimíigwan waya, tsushimøn cha. Kaguende tru srø llensube kesruppa, kølli llensune kølsrøben, mas trømbøikken kølsraig kørrømisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Katø srø vinonma køllin kalusmerayu usrmøwei inchibelø køn cha. Kaguende treeg marene, kalusmerabe srurrøben, vinobe lushen, yandø kalusmerabe ka pinønrrun cha. Inchawei srø vinone srø kalusmeran marigu usramig køn cha. Trumaybe møigwandøgucha chi mindisaig kømønrrun— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús waminchib pasramne, judíosmeran chi maramigwan kan karubig puabe, nui merrab tømbønsra, trenchibig køn: —Nai nimbasr ke møindø kwan cha. Øyeeg kuindøgucha, ñi arrua, tasigwan nuim pala estsarene, katø øsiiranrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Inchen Jesúsbe kurra iben, nui kusrenanøb pera uniilø nun lincha amben, nøbe tru møøba ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Indiibe kan ishug doce años ørøba ani ib kwanrrø tøgaig chiguen tab kømui megawa, Jesúswan wendaugurri kemallippa, Jesús nø kewagúig urøzhigwandø katørabig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kaguende nøbe treeg isubig køn: “Nui kewagúigwan ka katøraitø tammisrig kørrømisramønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Inchen Jesúsbe keesha asha, tru ishuwan ashabe, trenchibig køn: —Chi isumøta cha. Nimbasr, ñui isubigwan nainuutø pasra tøgagúikkurri tamarig kørrømisran— cha. Indiibe tru uraskurri yandø tammisrig kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Incha Jesús tru judíosmeran karubigwei yau pubene, lus urrabelø køben, katø misaamera truba trashib kishib kui ashibig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Inchabe trenchibig køn: —Yugurri webambay cha. Ishug-unøbe kwaig kømøtø, ka kiptø tsun— cha. Inchen misaamerabe Jesúswane ka indzatø mørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Incha nømun webambingaruben, Jesúsbe kebya, ishug-unan tasigu kemørene, unøbe kurraptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Inchen tru piraube muba kuimburab treeg purayaigwan wammørig kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús truyugurri webya ibene, pailø kabgailø trenchib trashib wendautø amrrubelø køn: —¡Namun lastima ashcha chib, merrabsrø Davidwei Nusrkai!— ");
INSERT INTO gum_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Inchen Jesúsbe yau kebiben, tru kabgailø kemallene, nøbe trencha payibig køn: —¿Ñimbe na øyeegwan martraitamab køregueh?— cha. Inchen nømbe: —Señor, øø— cha, løtabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Inchene Jesúsbe nømui kabmeran katørawabe, trenchibig køn: —Ñim ñimui isubigwan nainug maig tøgagúig treeg kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Inchen nømui kabmerabe ashibelø misren, Jesúsbe trenchib karubig køn: —Mun køben eshkab kønrrab kømø cha, i marigwan.— ");
INSERT INTO gum_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Trendaingucha nømbe webambuptø, Jesús nø chi marigwan tru pirau mayeelan waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Inchen tru kabgailø købeløbe webambub kømnetø, møiløgøsrøn Jesúsweimay kan wamgaig kwaimandzig tøgaigwan srua amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Inchen Jesús tru kwaimandzigwan weguchen latatø, tru wamgaibe waminchiptinchen, misaabe kwaara asha kørrømisra, trenchibelø køn: —¡Managuen nam Israel misaamerai utube øyeekkatiibe ashmer!— cha. ");
INSERT INTO gum_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Inchen fariseosmerabe trenchibelø køn: —Kwaimandziimeran ke nøasha karub pasrabikkurri kwaimandziimeran nøbe webusrøbig køn cha.— ");
INSERT INTO gum_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús maya pueblomerasrø, yamera tsitsø pønrrabsrø, judíosmera tulundzuni yamørig kusrenanøb, tabig srø wam Tius nø ashib karub wainuguigwan eshkab waminchib, chi kwanrrømeragurrimbunø tøgarwan pusrkwabelan tamarøb llirab ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Incha truba nu søtø misagwan ashabe, lastima isui inchibig køn. Kaguende nømbe truba isuilø, chinchabguen kaimar, kan ubishamera mu ashchabig chigar latailø køben. ");
INSERT INTO gum_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Incha nui kusrenanøb pera uniilan trenchibig køn: —Ellmarig tulisamibe truba nørrø køben, trune tulishinrrabeløbe mamdø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Inchawei tru ellmarig puaig Tiuswan miay chibig køn, nui ellmarigwan tulishinrrabelø ørtrai.— ");
INSERT INTO gum_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús nui doce kusrenanøb pera uniilan wamabe, mu mandamgaig maramig tøgagønrrai tranøbig køn, trømbøig maringarub kwaimandziimeran webusrøb, katø chine kwanrrømeranba, pusrkwabelanba tamartrai. ");
INSERT INTO gum_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iilø køn tru doce nøashib karua øriilai munchimera: Srøsriibe Simón truigwane katø Pedrogucha taig, nui nuneg Andrésba, Zebedeowei nusrkai Santiagoba, nui nuneg Juanba, ");
INSERT INTO gum_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe køben, Bartolomé køben, Tomás køben, Mateo tru romasreelayasig an utabig køben, Alfeowei nusrkai Santiago køben, Tadeo køben, ");
INSERT INTO gum_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón tru Cananistameraingatiig køben, Judas Iscariote tru wendø Jesúswan ashig kømui inchibelaingatø misra tranøbig købengue. ");
INSERT INTO gum_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús i doceelan øyah martrigay chib karua ørøbig køn: —Judíos kømeelø waraisrø ammøwei, samaritanosmerai pueblomerasrø kebammøwei inchigay cha. ");
INSERT INTO gum_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Trembe tru Israel misaamerai utu tru ubisha trubiilø latailaimaytø amrrigay cha. ");
INSERT INTO gum_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Trusrø ambabe, srømbalasrø Tius nø ashib karub waibe lutau pasran chib eshkab kusrenanrrigay cha. ");
INSERT INTO gum_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kwanrreelane tamarøb, kwailan øsiiranøb, asr trerab kwanrrø tøgarwan tamarøb, kwaimandziimeran webetab inchigay cha ñimbe. Ñimun øyeeg martrai tranigwan ñimma ka ketig utig køn cha, ñimgucha katø treegwei marøppe, anwei marmøtay cha. ");
INSERT INTO gum_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Oro køben, an køben, cobre køben ñimui pørønailøyu pusra ammøwei, ");
INSERT INTO gum_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","katø mayuwei murral ila ammøwei, turingucha yunømaramiba kømøtø, kandø tøga; alpargatiskucha keeta kømøwei; ni pøtønain tsikkucha srua ammøwei inday cha. Kaguende chigøben marøbiibe nui marimburøbe mu chi chinrrainga mamigwane utamig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ñim kan puebloyu kui, ya tsitsø pønrrabyu kui puabe, kan misag chi isumgaig tabigwan lawa, truigwei yau kørrømisrtrigay ñim truyugurri ambamnegatig. ");
INSERT INTO gum_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yau kebambuppe, ‘ñimun chi isumgaig tab køn’ chib wamønrrigay. ");
INSERT INTO gum_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tru yau misaamera truburab tabelø købene, tru ñimui tab købiibe nømuim pala treeg kønrrun. Inchen trengatig kønrrabgailø købene, ñimui tab købiibe ñimuinuutøwein kønrrun. ");
INSERT INTO gum_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Inchen ñimun wamømøwei, ñim wamindigwan mørmøwei inchene, nømui yaugurrin kui, nømui puebloyugurrin kui webambuppe, srøbyu usrøwan chishtø kørrøga webamrrigay chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Inchawei nabe ñimun cierton trendamønrrun: Srabe kwalømbe tru puebloimbe Sodomaimba, Gomorraimba pirau lataitøguen kømø, Tiuswei tru maig kønrrabigwan asha maram kwaløm attrabiibe mas purø trømbøig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Au, nabe ñim ubishamera latailan lobosmerai utu ørar. Chiyugøben kegørrømønrrab ñimbe ul latailø kuy. Inchen chi kaig inchimeelømaybe palomamera latailø kømig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ashiptø kønrrigay misaameran. Kaguende nømbe ñimune karubelai tasku tranøb, katø judíosmera tulundzuni yamerayu ñimune ichabetab inchun. ");
INSERT INTO gum_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Katø karubelø nørreelai merrab, reymerai merrab nagurrindø srua amrrun, trumay ñimbe nømunba, judío kømeelanba naimburabigwan wamindamig kønrrai. ");
INSERT INTO gum_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Inchen tru karubelan ñimun tranene, ñimbe mandø løtamigwan chi isumøwei, mandamermab chi isumøwei inchigay. Kaguende tru wamindamig pubene, wamindamig tøgagønrrai Tius tranrrun, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kaguende ñim waminchain kømøtø, Tius ñimui Møskawei Espíritu ñimgurri waminchun. ");
INSERT INTO gum_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Inchen nuneebe nømui nunewandøwei kwetchai tranen, møskaimbe nusrkawan tranen, ureemerabe møskalan namig kurra, kwetchai tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Maya misaabe ñimune nagurrindø tsalø indiilø kønrrabguen cha. Inchen srabe kwalømgatig chigúingucha megabig megabiibe kebeñchabig kømíig kaigyugurri wesraig kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ñimun kan ciudayu chigøben kaig martrab inchene, katøgansrømay wegørra ambay. Pøs nabe ñimun cierton trendamønrrun: Møg Misra Arrubiibe Israel pirau ciudamerayu ñim kerrigu naimburab eshkab lliramøwatø attrun cha. ");
INSERT INTO gum_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Kan kusreb mendig megabiibe nui kusrenanøbigwan purab nuig kømøn. Katø kan karuindiig megabiibe nui ya puaigwan purab nuig kømøn. ");
INSERT INTO gum_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kan kusreb mendig megabiibe nui kusrenanøbig lataitøwei misrabe, trutø tsabø kui møramig køn. Inchen tru karuindiig megabiibe tru ya puaig lataitøwei misrabe, trutø tsabø kui møramig køn. Yau møskai ashib wabigwanguen kwaimandzig Beelzebú cha wamibe, mas nui yau purrabelane chitø tai asamø chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Inchawei misaameran kørig kui inchimøtay. Pøs chitøgucha søriibe søriitø kørrømisrmø, kenamisrtrun. Katø kan søratø tøgagúibe søratø kørrømarig kømø, wammørig kørrømisrtrun. ");
INSERT INTO gum_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na ñimun løstøyu wamindigwane ñimbe kwaløm tøryu waminday. Katø na ñimun nilø wamindigwane ñimbe yabalasrøngurri trasay. ");
INSERT INTO gum_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Asrwandø kweechibelane kørig kui inchimøtay. Kaguende ñui møsigwane kwetchab kaimanrrun. Treeg kømøtø, asrwanba, møsigwanba managatig tru møra melamnug pinishinrrabigwan, tru Tiuswane si, kørig tøgaguy, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Pagatø illinzheelan kan centavozhigweindø yanøbelø kømuitarru? Treweindøzhigwanguen ñimui Møskai pirau kørrøbashmubene, ni kanzhikken kørrømøn. ");
INSERT INTO gum_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pøs, ñimuimburappe ñimui turyu pusruumeranguen kan kan mundziizheelø køn. ");
INSERT INTO gum_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Inchawei ñimbe chi kørig kui inchimøtay. Truba yam illimera lataitøguen kømø, ñimbe mas purø nuweyelø køn. ");
INSERT INTO gum_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Møikkøben misaamerai merrab ‘Jesúsweingatiig kur’ chibigwane nagucha nai Møskai srømbalasrø wabigwei merrab treetøwei truigwane ‘nuingatiig kur’ tamønrrun. ");
INSERT INTO gum_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Inchen misaamerai malau ‘Jesúsweingatiig kømur’ chibigwane nagucha nune nai Møskai srømbalasrø wabigwei merrab ‘nuingatiig kømur’ cha, trendamønrrun chibig køn, Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Nabe piraumay arruppe, ambumay imay tab købigwan srua arritamab isumøtay. Nabe truigwan srua arrumøtø, kwayab kømigwan srua arrur cha. ");
INSERT INTO gum_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nabe arruppe, møøbe møskaimba namig kurrøben, nimbasrbe usrimba namig kurrøben, yernabe sueeraba namig kurrønrrai martrab arrur. ");
INSERT INTO gum_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Inchawei møigwandøgucha ashig kømui inchibeløbe yaueløtøwein kønrrun. ");
INSERT INTO gum_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Møikkøben møskawan kui, kabe usran kui, nan lataguen kømø, mas undaarabiibe truburab chincha nain kønrrabgaig køn. Nui nusrkawan, kabe nui nimbasrwan, nan lataguen kømø, mas undaarabiibe truburab chincha nain kønrrabgaig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Inchen møikkøben kuruswan mutab nai mendig arrumíibe truburab chincha nain kønrrabgaig køn. ");
INSERT INTO gum_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Inchen møikkøben øsig kømigwan wetørrabiibe yandø pinab pinamig nebunrrun cha. Inchen nagurrindø kwabiibe managatig øsig kømigwan wetørrawa tøgagønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Møikkøben ñimun tab wamab utabiibe nan utan. Inchen nan utabiibe nan karua ørøbigwan utan. ");
INSERT INTO gum_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Inchen møikkøben Tius maig karuigwan eshkabig kui ashiptø nun tab wamab utabiibe, tru Tius maig karuigwan eshkabigwan ketigwandøwei nøbe Tius tranig utønrrun chibig køn. Katø møikkøben kan sølgandø tabig marøbigwan, sølgandø tabig marøbig kuimburø utabiibe, sølgandø tabig marøb møwan ketigwandøwei Tius tranig utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Inchen møikkøben nai mendig amøñibelø kui ashiptø trengatig kømøzheelan kan pi pishi pasuzhiitøguen srørrøbiibe, truburø nui ketig utamigwane utømø kømø, utønrrun cha, ñimun trendamønrrun.— ");
INSERT INTO gum_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús yandø nui doce kusrenanøb pera uniilan øyeeg, øyeeg marøb amøñinrrigay cha, chab kusrenanabe, truyugurri ibig køn, tru pirau katøgan pueblomerasrø nui srø wam tabigwan kusrenanøb katø eshkab waminchib inchab. ");
INSERT INTO gum_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Bautista kailan keeri yau keerig pasrøwa, Cristo chi marøb uniilan wammørøbig køn. Inchabe møilan køsrøn nui mendig amøñibelan Jesúswan trencha payrrai ørøbig køn: ");
INSERT INTO gum_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—¿Tru Cristo attrabig købiibe ñi kuin kui, kabe nambe katøganun muniiramøh? chinrrai.— ");
INSERT INTO gum_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Inchene Jesúsbe nømun løtappe trenchibig køn: —Amba, ñim chi mørigwan, ñim chi asigwan Juanwan eshkanrrigay cha. ");
INSERT INTO gum_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kabgailøbe ashen, cojosmerabe amben, asr trerab kwanrrø tøgarmerane nømui kwanrrøwan tamara chishmariilø køben, kalu mørmeeløbe mørøbelø misren, kwailøbe øsiiraben, waachamerane Tiuswei tabig srø wamwan eshkab kusrenaniilø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mayanguen tab kuig køn chibig køn, nan peg kuitamab isumøtø, na kuitamab isubigweimbe.— ");
INSERT INTO gum_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Inchen yandø nøm amben, Jesúsbe Juanweimburab misagwan trenchib waminchib pølbasrøbig køn: —¿Mu misag warab waraimøsrømbe ñimbe chi ashchab webamgue? cha. ¿Kan caña ambumay imay ka isig srua yainaptiigwandeh? cha. ");
INSERT INTO gum_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Trube, ¿chi ashchab webamgue? cha. Kabe, ¿kan møg truba tabig keweigwandeh? cha. Ñimbe ashibelø køn, truba tabig kebeløbe reymerai yau purrabelø kui. ");
INSERT INTO gum_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Trube, treeg købene, ¿chi ashchab webambig kø? Kabe, ¿Tius maig karuigwan kan eshkabigwandeh? Øø, nabe ñimun trendamønrrun cha: Treegwanwei ashchab webambig køn cha, katø treetøguen kømø, trurrigu Tius maig karuigwan eshkabigwan lataguen kømø, mas purø nuigwan. ");
INSERT INTO gum_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanbe tru Tiuswei wamwan pørigu øyah taig truig køn: Au, nabe nai wam srua inrrabigwan ñui merrab ørar cha, truibe ñui maywan tamartrai ñui merrab. ");
INSERT INTO gum_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Nabe ñimun cierton trendamønrrun: Maya møguelø kal-laelai utu Juan Bautista lata nuibe muguen kurrømuig køn cha. Inchendø treeg kuindøgucha, srømbalasrø Tius nø ashib karub wainuube chigucha kømíikken mas nuig køn cha, Juan lataguen kømø. ");
INSERT INTO gum_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan Bautista marøb pølbasrøb uraskurri møingatig srømbalasrø Tius nø ashib karub waibe truba kaig indinab pasran. Inchen tru treeg kaig marøbeløbe treeg mara, trunun nøm kanammørø indan. ");
INSERT INTO gum_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mayeelø Tius maig karuigwan eshkabeløba, tru maig maramigwan martrai Moisés pøriibabe Juan arrumnegatig Tius maig karuigwan eshkaig købig køn. ");
INSERT INTO gum_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ñim iigwan kørewa utønrrappe; Juanbe Tius maig karuigwan eshkabig Elías attrabig købig, truigwein køn. ");
INSERT INTO gum_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Møramig kalu pønsraibe mør! ");
INSERT INTO gum_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Møin kwaløm misaamerane chi latailø køn chinrrab køh? chibig køn. Kan plazayu ureemera esheerrab purramisra, nømui linchibelan øyah chib trashib purrabelø latailø køn cha: ");
INSERT INTO gum_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nambe ñimuyasig luswan urringucha, ñimbe pailamuig køn chib. Cantailø isumdeelø cantaben, ñimbe miirab kishmuig køn, chib. ");
INSERT INTO gum_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pøs Juan mamøwei, muchimøwei inchibig arrubene, nømbe: “Kwaimandzig tøgaig køn” chibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Inchen Møg Misra Arrubig mab, muchib inchibig arrubene, trube, nømbe: “Menrra maptiig køn”, tamba: “Menrra muchiptiig køn”, tamba: “Romasreelayasig an utabeløba, kaig marøb misaameraba linchibig køn”, tamba inchibelø køn nømbe. Inchendø mu møkken nebua isumgaig Tius marøb pasraibe nui mariiløtøga treeg kuitamab ashchai tørgandø kenamaran— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Incha Jesúsbe maramburab mariilan nø truba mari pueblomerasrø namig waminchibig køn, kaguende tru pueblomerayu warab misaamerabe nømui kaig mariilan isua møra, Tiusweimay lliramuikkurri. Incha Jesúsbe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ay, ñi Corazín pueblo waacha! ¡Ay, ñi Betsaida pueblo waacha! Kaguende Tirosrø Sidónsrø tru maramburab mariilan na ñimui utu lataitøwei marig kuimbe, manawei truiløbe nømui kaig mariilan isua møra, Tiusweimay llirabsruig kuinrrun cha. Incha kaig marmønrrab yandø isua mører chib kenamartrab, trøsrkøleelø keb, nagusrøwan itøbusrøb inchibsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pøs nabe trendamønrrun: Tiuswei tru maig kønrrabigwan asha maram kwalømbe Tiroba, Sidónba misaamera lataitøguen kømø, ñimbe mas purø trømbøigwan utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¿Inchen ñi Capernaum pueblogan, purø tab incha srømbalasrøngatig kusruig kønrrurmab isutirru? Treeg kømøtø, tru møra melamnug kegutsig kønrrabguen ñibe. Kaguende ñimui utu maramburab mariilan Sodomasrø na marig købig kuimbe, møingatig tru ciudabe pinømubsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Inchawei nabe ñimun trendamønrrun: Tiuswei tru maig kønrrabigwan asha maram kwaløm attrabiibe tru Sodoma pirausrø misaamerai lataitøguen kømø, ñimuimbe mas purø trømbøig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tru uras Jesús trenchibig køn: —Nai Møskai, srømbalawanba, pirøwanba ashib karubig, ñun tabig waminchar cha, kaguende ñibe kusrebelø chigúi mørøbelan ashmønrrai tru sørig pønrrabelane tru chigucha kømeelø kusremeelan kenamarikkurri. ");
INSERT INTO gum_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Treegwein køn, nai Møskai, ñi treeg kønrrai maramig tab kuig kua. ");
INSERT INTO gum_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Nai Møskaimbe chiwandøgucha nan trandan. Mugucha na Nusrkawane mu ashmuben, Møskaindøwei asan. Mugucha Møskawane mu ashmuben, na Nusrkaimbah, møiløgøben na kenamariilø truiløbatø asan. ");
INSERT INTO gum_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ñim mayeeløba ñimui amønailøyu chine chine nebuig truba muraarailø, trurrigu kwatsig nigarbe naimay amrruy, nabe ñimun isramig tranrrumøn. ");
INSERT INTO gum_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Arau merrarrabig tru nai nukabala trarrigwan kashmø, uta, naba latatø srua amun chibig køn. Incha na maig køben nan treeg asha kusrey cha. Nama purø tammayig, manrraugurri newan tabig chish inchimíig, nabe treeg kur cha. Øyamaybe ñimui møsiimerayasig isramig wetørranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaguende nuka pala trarrig arau merrarrab tsig naimbe kwatsiguig kømø, ka niga ambamdiig køn— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Inchen tru uras kan isrin kwaløm Jesús tirigu ellmari utuwan pureb ibene, nui kusrenanøb pera uniiløbe parøgwaben, tirigu turwan lurra, trulwan mab mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Inchen fariseosmerabe asha, Jesúswan trenchibelø køn: —Au, ñui kusrenanøb pera uniiløbe isrin kwaløm chigøben marmønrrai merigwan marøb køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Inchene nøbe trencha løtabig køn: —¿Ñimgan lemeelø køtirru cha, mana køsrøn Davidwanba nui linchibelanba parøgwaben mandø indigwan? ");
INSERT INTO gum_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pøs truima Tiuswei carpa ya tabzhigu kebya, nøba nui linchibeløba Tiusweyasiitø tarømarig pirrimeran maig købig køn tan cha, ni nun lata, nui linchibelan lata mamønrrai merigwan, tru sacerdotesmeratø mamigwan. ");
INSERT INTO gum_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Kabe ñimgan tru maig maramigwan martrai Moisés pørigu lemeelø køtirru cha, isrin kwaløm kuindøgucha sacerdotesmera Tiuswei yau marøb purrappe, isrin kwaløm kømui lataig, isrømø, marøb purrøben, truigwanma Tiusbe kalø kui asig kuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","’Inchen køben nabe ñimune trenchar: Tiuswei ya lataitøguen kømøtø, mas purø nuikken kur cha, na yu pasrabiibe. ");
INSERT INTO gum_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ñimbe ni chi tainguen mørmuin køn: “Animal kweecha, Tiuswan tranøb kømøtø, ñimbe lastima ashibelø kønrrai inchar” taigwan. Tru trendaigwan ñim mandø kui mørig kuimbe, kaig mara kømeelane ‘øyeeg kaig marøbelø køn’ chimubsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Inchawei na, Møg Misra Arrubiibe isrin kwaløm nan nø karunrrain kømøtø, maramdiigwane marøb, maramgaigwane marmub, nabe na asha karubig kur— chibig køn, Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Incha Jesúsbe truyugurri ya, judíosmera tulundzuni yau kebibene, ");
INSERT INTO gum_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","truyube kan møg tasig mul-laig wabig køn. Inchen kaguen møiløgøsrøn Jesúswan chigøben chi køptø, Jesúswane trencha payibelø køn: —¿Isrin kwaløm kan kwanrriigwan ka tamartrain kø chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Inchene Jesúsbe trenchibig køn: —¿Ñimma møikkøben kan ubisha tøgagua, isrin kwaløm trabyu kebeñene, ya, kemøra, wesramønrraguh? cha. ");
INSERT INTO gum_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pøs kan møøbe kan ubisha lataitøguen kømø, purab nuikken køn cha. Inchawei treeg købene, isrin kwalømmerawangucha tabig maramigwane merømø, ka marbasamig køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Incha tru møwane trenchibig køn: —Kwalwan larrøbichi— cha. Inchen nøbe larrøbichene, kandarø kwal latawei tabig kørrømisrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Inchen fariseosmerabe webamba, Jesúswan namig kurra, mandø incha pinisamigwan waminchib mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Inchen Jesús iigwan wammørabe, truyugurri iben, misag truba nu mendig ambubelø køn. Inchen Jesúsbe mayan kwanrreelan tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Incha nune mu køn cha, mun køben misaameran mørø waminchimønrrain karubig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iibe tru Tius maig karuigwan eshkabig Isaíaskurri øyeeg taig nebunrrain kuig køn: ");
INSERT INTO gum_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Iibe tru nai karuig marøb megabig køn cha, tru na lawa wesruig, na undaaraig, truigweimburappe nabe truba tab kui mørøb kasrag war taig. Nabe nai Espíritun nuim pala pasren, chu pirausreelø køben maya misaameran tru sølgandø tabigwan nø eshkab kusrenanrrun taig. ");
INSERT INTO gum_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nøbe kwayam lamøwei, trashimøwei, callesmerayu nui wamwan wamindi mørmøwei indig kønrrun taig. ");
INSERT INTO gum_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kan caña kegurisaigwan nøbe kebinab lanchimøwei, katø mecha ke chab kwab pilab pasrabigwan kweechimøwei inchun taig, tru sølgandø tabigwan kerrigu kanawa wesrawa pasramnegatig. ");
INSERT INTO gum_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Inchen judíos kømø misaamerabe nui munchiyutø isua muniirab kønrrun, taig. ");
INSERT INTO gum_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Inchen Jesúsweimay kan møg kabgaig, wamgaig kwaimandzig tøgaigwan srua amben, nøbe nun tamarene, tru wamgaibe waminchib, ashib inchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Inchene mayeeløba kwaara ashib trenchib payiyabelø køn: —¿Iibe tru merrabsrø Davidwei Nusrkain køppeendi?— cha. ");
INSERT INTO gum_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Inchen fariseosmera iigwan mørabe, trenchibelø køn: —Nugwaimandzig, Beelzebú, tru kwaimandziimeran ke nøasha karubig treeg martrai tranig kua, truikkurri kwaimandziimeran weeran— cha. ");
INSERT INTO gum_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Inchen Jesúsbe nøm chi isub pønrraigwan ashabe, trenchibig køn: —Kan rey karub tøgaweim pirauma misag nømasiitø nøørøtø misrøb kurrabe, pinønrrun cha. Katø kan ciuda lata, katø kan yauelø lata nømasiitø nøørøtø misrøb kurrabe, warønrrab kaimanrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Øyeetøwei Satanáskucha Satanáswandøwei weguchabe, nøasiitø nøørøtø misran cha. Inchen nø ashib karub waibe, trube, ¿chincha pasrabig pasrønrrab kø? cha. ");
INSERT INTO gum_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tru kwaimandziimeran na webetappe, Beelzebúgurri webetig købene, trube, ¿ñimui mendig amøñibeløbe kwaimandziimerane mu webetingaruitøgarre webetah? cha. Inchawei, treeg købene, maig kuigwan ñimun uyube nøm kusrenrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Trune na Tiuswei Espíritutøga kwaimandziimeran webetøbene, Tius nø ashib karub pasraibe ñimui utube puaguen pasran cha. ");
INSERT INTO gum_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Kabe kan møikkøben kan mur møwei yauma kebya, tru mur møwan lusrøbmerrig lusrmøwatøbe, ¿nui chi tøgagúigwan chincha kerranrrab kø? cha. Lusra trarratøwei nui chi tøgagúilan kerranrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Naingatø pasrømíibe, nan tsaleelaingatø maran. Inchen naba tulishimíibe truørøtø wiitan. ");
INSERT INTO gum_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Inchawei nabe ñimun trendamønrrun: Misaamera kaig mariilan lata, chigøben Tiuswan purø trømbøig wamab wamindiilan lata Tiusbe kerriguh pesannawa ulø paymønrrun cha. Trune Espíritu Santon purø trømbøig wamab wamindiilane si, Tiusbe pesannamø, ulø payrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Møikkøben na, Møg Misra Arrubigwan chigøben kaig waminchibigwane Tiusbe ulø paymønrrab pesannanrrun. Trune møikkøben Espíritu Santon kaig waminchibigwaneguende ni møi yu lata, ni kansrø lata pesannamø, ulø payrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Pøs kan tab tusrbe, tab mamitøwei niirrun. Inchen kan kaig tusrbe kaig mamitøwei niirrun. Kaguende kan tusrwane mamig niguinug asan. ");
INSERT INTO gum_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ul lataig inchib misaamera! ¿Ñim chincha tabig waminchague, trendø kailøbe? Kaguende nui manrrau chine isua tøgagúilø pinøguchen, nui triibe treeg wamindan. ");
INSERT INTO gum_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kan møg tabiibe tabig isuilan nui manrrau esegabig kua, truyugurrimbe tabig wesrub wamindan. Inchen kan møg kaibe kaig isuilan nui manrrau esegabig kua, truyugurrimbe kaig wesrub wamindan. ");
INSERT INTO gum_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Inchawei nabe trendamønrrun: Chigøben wamindamgailan misag ke ka wamincha møriilan Tiuswei tru maig kønrrabigwan asha maram kwaløm mayeeløba tru urasbe kerriguh maig kuigwan eshkamig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pøs ñui wamindiitøgatøwei ‘tabig køn’ tain kui, kabe ‘kaig køn’ tain kui Tius treeg marig kørrømisrtrabguen.— ");
INSERT INTO gum_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Inchen møiløgøsrøn Moisés pørigwan kusrenanøbeløba, fariseosmeraba Jesúswan trenchibelø køn: —Kusrennøbig, Tius ñiba pasrain kui nam asha kønrrab mar— cha. ");
INSERT INTO gum_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Inchene Jesúsbe trencha løtabig køn: —Møin kwaløm kaig misaamera, kan kasharawar peeba itøluløpteelø lataitøwei Tiusbatø pønrrømø misaamera kailø, Tius naba pasrain kui ashchab maramig miatan cha. Inchendø asha kønrrai katøgan chigøben peg kenamara tranmøtø, Tius maig karuigwan eshkabig Jonásweiwandø eshkamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tru Jonás truba nu peskau umbu pøn kwaløm, pøn yem wab lataitøwei Møg Misra Arrubikkucha pøn kwaløm, pøn yem pirø umbu wanrrab køn cha. ");
INSERT INTO gum_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tru Nínive ciudasrø misaamerabe Tiuswei tru maig kønrrabigwan asha maram kwalømbe kenamisrtrun cha, tru møin kwaløm misaameran kaiyu pønsrønrrab. Kaguende nínivesreeløbe Jonás eshkaigwan møra, nømui kaig mariilan isua møra, Tiusweimay lliraig køn cha. Inchen yu pasrabiibe Jonás lataitø kømø, mas nuig kur cha. ");
INSERT INTO gum_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","’Tru ambø umbu pirausrø reinagucha Tiuswei tru maig kønrrabigwan asha maram kwalømbe kurrønrrun cha. Incha nøbe tru møin kwaløm misaamera ñimun møra melønrrai maringarunrrun. Kaguende nøma purø yabsrøngurringuen pirau arrig købig køn, Salomón, tru purø kusrebig wamindigwan mørtrab. Inchen yu pasrabiibe Salomón lataitø kømø, mas nuikken kur chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Kan trømbøig maringarub kwaimandzig møweinukkurri webippe, chugøben purmerasrø isramig lab uña, yandø wetørranrrab kaimappe, treeg isun: ");
INSERT INTO gum_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Katø nai yamay inrrab cha, na chugurri webarrua arrinuumaytøwei”. Incha katø arruabe, tru møwane kan yawan chiguchagaig chishtø paluuncha tamara pasrig lataig wetørranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Incha ippe, katøgan kwaimandziimera, nø lataguen kømø, mas larrø trømbøig marøbelan sieteba tulundzuna, søteeløba trubalatø tru møweinug purrønrrab kebamrrun cha. Inchen tru møøbe yandø srabebe mas purø kaikken kørrømisrtrun cha, tru srøsrø lataitøguen kømø. Inchawei i møin kwaløm misaameran kailan treetøwei purainrrun— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús misaameran waminchib srø pasramne nui usrimba, nui nuneløba pua, nøba waminchig kui wambiitø pønrrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Inchen møikkøsrøn Jesúswan eshkabig køn: —Ñui usrimba, ñui nuneløba wambig pønrran cha, ñiba waminchab ñun payib.— ");
INSERT INTO gum_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Inchene Jesúsbe tru eshkabigwane trenchibig køn: —¿Nai usri, nai nuneløbe mumera køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Inchabe nui kusrenanøb pera uniilan kwaneshkab trenchibig køn: —Nai usri, nai nuneløbe iilø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kaguende møikkøben nai Møskai srømbalasrø wabig maig martrai karuben, treeg marøbig, truibe sí, nai nuneg, nai nuchag, nai usrin køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tru kwalømdøwei Jesús yaugurri webya, nu pisu menda wamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Inchen misag truba nu tulundzunikkurri, Jesúsbe kan barcoyu kebya wamisren, maya misaabe tru pisu mendatø pønrrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Inchen nøbe waminchib pølbasrøbig køn ‘øyeeg lataitøwein køn’ chib wamindiiløtøga chineh kemesra kusrenanøb. Incha trenchibig køn: —Kan kwallibiima tsurøb kwallchab webyan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Incha tsurøb ibene, kanbalø yellbe mayu kørrøben, illimera amrrua, man cha. ");
INSERT INTO gum_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Katøganbaløbe sruurrøldø pirau pirø tre chiganug kørra, pirø palatiikkurri tru yellbe kal-lappe, petø kal-labendø, ");
INSERT INTO gum_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pørr webarruabe, mergurangaruben, srøl tre chigaig kua, mul-laptindan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Katøganbalø yellbe kal shau utu kørrøben, kalmera nørrørab mendappe, chab kasrøb tsibisan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Inchen katøganbalø tab pirau kørrabiibe si, tabig ellmarig misra, møiløbe kan yellgurrindø mamig trulzheelø cien niguen, møiløbe sesenta niguen, katøganeløbe kan trulzhikkurrindø treinta nigan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Kalu pønsraibe, mør!— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Inchen nui kusrenanøb pera uniiløbe Jesúswan kemalla, trenchib payibelø køn: —‘Øyeeg lataitøwein køn’ chib, ¿misaamerane chindimba øyamay waminchigu?— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Inchene Jesúsbe trencha løtabig køn: —Srømbalasrø Tiusbe nø ashib karub wainug mu asiimíig tøgagúilan ñimun ashchai tranan cha. Trune katøganelane treeg kømøn cha. ");
INSERT INTO gum_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kaguende tøgaigwane masken tranen, uñchaguen tøgagønrrun cha. Trune chigaigwane nui lamøtiig tøgagúigwanguen kerranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Inchawei nabe ‘øyeeg lataitøwein køn’ chib wamindiiløtøga chineh kemesra waminchar chibig køn. Kaguende: nømbe ashendø, ashmøn cha, mørendø mørmøwei, ni katø chigúinguen mørmøwei indan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Inchawei nømune øyeeg køben, Tius maig karuigwan eshkabig Isaías øyah wamindig ciertonwei nebun cha: Maya, maya mørendø, ni chi tainguen mørmønrrun cha. Ashippe, ashendø, chigúi ashmønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kaguende i misaamerai manrrøbe larrø tranrreelø srug lataig misrin køn cha. Kalumera, kabmera kasrailø tøgar køn cha, ashmøwei, mørmøwei, ni chi tainguen mørmøwei, nuimay amrrumøwei inchai, katø na tamariilø kømøwein kønrrain taig. ");
INSERT INTO gum_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Trune ñimbe mayanguen tab kuilø køn, kaguende ñimui kabmera Tiusweimburabigwan ashib, kalumera nuimburabigwan chigúi mørøb inchibelø tøgarbe. ");
INSERT INTO gum_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Inchawei nabe ñimun cierton trenchar: Tius maig karuigwan eshkabelø køben, sølgandø tabig marøb misaamera køben, truilø truba nu, i ñim asigwan asinrrabna kui inchendø, ashmuig køn cha. I ñim mørigwan mørinrrabna kui inchendø, mørmuig køn cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Au, ñim møray, tru kwallibigwan ‘øyeeg lataitøwein køn’ cha, kemesra wamincha pasrigwan na eshkanrrab. ");
INSERT INTO gum_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tiuswei tru srø wam srømbalasrø karub waisriigwan mørendø, chigúinguen mørmeelane tru nugwaimandziibe arrua, tru manrrau ellgwaigwane kerran cha. Inchen truiløbe tru yell mayu kørrabelø latailø køn. ");
INSERT INTO gum_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Inchen tru sruurrøldø pirau pirø tre chiganug kørrab yellbe tru misag Tiuswei wamwan tru urastøbe truba tab kui mørøb utabelan trunun eshkabig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Inchendø srøl tre umbu keetiimíig kua, maya yanaguen amøñimøn. Incha tru Tiuswei wamgurrindø chigøben puben, katø chigøben kaig nebub arruben, møi møin kørran. ");
INSERT INTO gum_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Inchen tsuren, tru kal shau utu kørrab yellbe øyeeg misagwan eshkabig køn: Tiuswei wamwan mørøppe, mørendø, i pirau chine købigwan menrra isubiibah, nømui chine palømø tøgagúilø purø tabig lataig asønaikkurrimbatø, tru Tiuswei wamwan mørigwane kerrigu truitø kasrøben, chigucha nømbe ellmarig misrmøn cha. ");
INSERT INTO gum_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Inchen tru yell tab pirau tsuriiløbe tru misag Tiuswei wamwan møra, katø tab chigúi møra, truibe sí, tab ellmarig misrigwan eshkabig køn. Truiløbe tru kan yellgurrindø mamig trulzheelø cien, kaneløbe sesenta, kaneløbe treinta nigabelø latailø køn— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Incha Jesús katøgan ‘øyeeg lataitøwein køn’ cha eshkawa pasrøb trenchibig køn: —Srømbalasrø Tius nø ashib karub waibe kan møg nui trau tab yellwan tsuri lataig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Inchen søteeløba kib waramne nun kan ashig kømui inchibig arrua, tirigu tsuri utu kaig yellwan wiitappa, yan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Inchen tirigu nørrørawa, urø weetøbene, tru kaig kau arrucillugucha kenamisrøptindan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Inchen tru tra puaigwei marøb melabeløbe nune trenchinrrab ambubelø køn: “Señor, ñi trau tru tsurig yellbe tabig købendøbe, ¿tru kaig kaube chugurrin kal-lah?” cha. ");
INSERT INTO gum_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Inchene tru ellmarig puaibe trenchibig køn: “Mutø tsaliig øyeeg mariinrrun” cha. Inchen truyu marøb melabeløbe trencha payibelø køn: “¿Kabe tru kaig kauwan nam kitønrrab ambamøh?” cha. ");
INSERT INTO gum_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Inchene nøbe trenchibig køn: “Kagøbasay cha. Inchippa kaig kauwan kitønrrab incha, tirigungucha tøga kitabgun cha. ");
INSERT INTO gum_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Trembe paramnegatig trubalatø ka nørrørabasay chibig køn. Tru uras tru tulishinrrabelan øra, tru kaig kauwanmerrig tulisha, lusrø mara, pattrai karumønrrun cha. Incha tirigune nai tirigu esegainug keeringarumønrrun”, tan— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús katøgan ‘øyeeg lataitøwein køn’ cha, kemesra waminchibig køn: —Srømbalasrø Tius nø ashib karub waibe kan murtasa yell lataig køn cha, kan møg nui trau tsurig. ");
INSERT INTO gum_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maya yellmerai utu purø lamø yellzhig købendø, nurappe, tru ellmarig shush tusrmerai utu mas nuibe murtasa køn cha. Yandø kan tusrburabig misren, nuig køptø, illimera pala amøñibeløguen amrrua, tru srarmerayu le marøbelø køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Katø Jesúsbe katøgan ‘øyeeg lataitøwein køn’ cha, kemesra waminchibig køn: —Srømbalasrø Tius nø ashib karub waibe levadura lataig køn cha, kan ishuuma pa arruba harina sømara, levaduran pusren, maya sømarigwan trunun ørøba pulingarub lataig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesúsbe misaamera nørrø pasrabigwan kerrigu iigwan kusrenanøppe, ‘øyeeg lataitøwein køn’ chib wamindiitøga eshkabsulu waminchibig køn. ‘Øyeeg lataitøwein køn’ cha, eshkawa pønsra kømuppe, waminchimíig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Øyeeg nebuppe, tru Tius maig karuigwan eshkabig maig taig nebunrrain kuig køn, tru øyah taig: Waminchib kusrenanøppe, ‘øyeeg lataitøwein køn’ chibgøba eshkab wamindamønrrun cha. Tius pirøwan marøb uraskurri sørig pønrrabelan tørgandø eshkab wamindamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Incha Jesús tru nu søtø misagwan ungwa cha, yau kebibene, nui kusrenanøb pera uniiløbe kemallabe trenchibelø køn: —Tru ellmarinug kaig kauwan ‘øyeeg lataitøwein køn’ cha, namun eshkab wamindigwan tab eshkarra— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Inchene Jesúsbe trenchibig køn: —Tru tab yellwan ellmarøbiibe Møg Misra Arrubigwan eshkabig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Inchen tru ellmarig trabe yu pirau maya misagwan eshkabig køben, tru tab yellbe Tius nø ashib karub waigwei ureemeran eshkabig køn cha. Inchen tru kaig kaube nugwaimandzigwei ureg køn cha, eshkabig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Inchen tru ashig kømui inchib tsaliig tru kaig kauwan ellguawa pasrøbiibe nugwaimandzigwan eshkabig køn cha. Inchen tru ellmarig srønøbe srabe kwaløm patsønrrabigwan eshkabig køben, tru ellmarigwan tulishibeløbe ángelesmeran eshkabig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tru kaig kauwan tulisha, nagu pattrai kebetab lataitøwei srabe kwaløm patsab uraskucha øyeeg punrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tru Møg Misra Arrubiibe tru katøganelan kaig maringarub pønrrabelanba, ke kaigwandø marøb pønrrabelanba nø ashib karub wainukkurri truilane mayamba nui ángelesmeran tulishinrrai ørtrun cha. ");
INSERT INTO gum_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Inchen nu nag naarabigu kebusren, truyube kishib, trugulmeran tsatsamig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Inchen tru sølgandø tabig marøbeløbe nømui Møskai ashib karub waisrømbe kan nøsig pilab latailø pilønrrun cha. ¡Kalu pønsraibe, mør! chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Srømbalasrø Tius nø ashib karub wainuguiibe kan chigøben truba tabzhigwan pirø umbu søra pasrig lataig køn. Kan møg tru tabig sørig pasrabigwan wetørrawa, katøle truyutøwei søra pasran. Incha truba kasrag ya, nui chi tøgagúilan kerrigu yanabe, tru pirøwan penaptindan. ");
INSERT INTO gum_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Katø tru srømbalasrø Tius nø ashib karub wainuguiibe kan tørbilab sruuzheelan lawa, penab, yanøb inchibig lataig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Incha kan tørbilab sruuzhig truba truba tabzhig nuweyig wetørrappe, ya, nui chi tøgagúigwan kerriguh yana, tru purø tab sruuzhigwan penan, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Katø tru srømbalasrø Tius nø ashib karub wainuguiibe kan atarrayan maryu keguchen, chi peskaugurrimbunø kemørøb lataig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Incha atarrayayu peskau netsabene, tru peskabeløbe pi menda wesrua, peskaumeran lawa tarømartrab purramisran cha, tabelane tasinyu pusrøppe, kailane petaptø petan cha. ");
INSERT INTO gum_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Srabe kwaløm patsab uraskucha øyeetøweih purainrrun, chibig køn. Inchen ángelesmera webamrrun cha, kailanba, sølgandø tabig marøbelanba nøørø tarømartrab. ");
INSERT INTO gum_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Incha kailane nu nag naarabigu kebetønrrun cha, truyube kishib, trugulmeran tsatsamig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Incha Jesúsbe trencha payibig køn: —¿Ñimbe iilan kerriguba chigúi mørgueh?— cha. Inchene nømbe: —Señor, øø— cha, løtabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Inchene Jesúsbe trenchibig køn: —Mutøgucha Moisés pørigwan kan kusrenanøbig srømbalasrø Tius nø ashib karub wainuguigweimburab kusrebig misrabe, kan ya puaig møskai latawei nui tabzheelø esegaig tøgagúinukkurri srøilø køben, kølleelø køben wesrub lataitøwei maran— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yandø Jesús tru ‘øyeeg lataitøwein køn’ chib iilan eshkab chab waminchabe, truyugurri webya ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Incha nuim pirausrøndøwei puabe, tru judíosmera tulundzuni yau kusrenanøb mendøbene, misaamerabe truba kwaara ashib trenchibelø køn: —¿I møøbe øyeeløbe churre øyeeg kusreh? cha. ¿Katø tru maramburab mariilan chincharre marerah? cha. ");
INSERT INTO gum_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Iibe tru tsiimeratøga chine marøbigwei nusrkai, katø nui usrimbe María taig kømuitarru? cha. ¿Santiagoin køben, Joséwein køben, Simónwein køben, Judaswein køben nuneg kømuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Yamba nui nuchaløgucha kerriguba namui ututøwei warabelø kømuitarru? cha. ¿Trube, kerrigu iigwane i møøbe chugurrinrre øyeelø tøgaguerah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Treeg isua nune kaashibelø køn. Inchen Jesúsbe trenchibig køn: —Chutøgucha Tius maig karuigwan kan eshkabigwane tab indan cha. Inchendø nui piraueløba, nui yaueløba, truiløbe chi tab inchimøn— cha. ");
INSERT INTO gum_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Incha truyube maramburab mariilø tre marmíig køn, kaguende truyu misaamerabe nømui isubigwan nuinug pasrmuikkurri. ");
INSERT INTO gum_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tru kwalømmerawan Galilea pirau karubig Herodesbe Jesúsweimburabgøba wamindi mørabe, ");
INSERT INTO gum_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nui karuindiig melabelane trenchibig køn: —Truibe tru Juan Bautista kuinrrun cha, kwailai utugurri katø kurriinrrun cha. Incharre øyeeg maramburab maramig tøgaig kuinrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kaguende Herodesbe tru Juanwan kemøringarua, lusra, kailan keeri yaumay kertrai srua ambingaruig købig køn, tru nui nuneg Felipei srai Herodíaskurrindø. ");
INSERT INTO gum_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kaguende Juan Bautistabe Herodeswane trendaig købig køn: —Tru Herodíaswan ñui srai mara tøgagømibe merig pasran— cha, ");
INSERT INTO gum_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodesbe Juanwan kwetchab inchendø, misagwan køriimatabig køn, kaguende mayeeløba Juanbe Tius maig karuigwan eshkabig kui kørewa køben. ");
INSERT INTO gum_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Inchen tru Herodeswei kal-lain kwalømwan isub kasrag waram kwaløm, tru Herodíaswei nimbasrbe tru linchai eshkailø mayeelø purrabelai merrab pailaben, Herodeswane truba tabig asønaptø, tru srusrane: ");
INSERT INTO gum_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","—¡Katø, tranmø kømø! chi miabendø tranrrumøn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Inchen tru srusrøbe usri øyeeg chinrrig cha eshkaig køppe, Herodeswane trenchiptinchibig køn: —Juan Bautistai turwan kan platilloyu trannrra— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Inchen reybe truba isui inchendø, tru mayeelø lincha purrabelai malau, treeg tranrrumøn cha, trannrrab misrig køppe, traningarubig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Incha Juanbe kailan keeri yau waben, Herodesbe turwan paringarubig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Inchen tunwan para, kan platilloyu srua ya, srusran tranen, nøbe usran tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Inchen Juanwei mendig amøñibeløbe amrrua, Juanwei asrwan srua amba, sørabelø køn. Incha Jesúswan trunun eshkanrrab ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Inchen Jesús Juanwan kweetsin kui wammørabe, truyugurri nøtø kan barcoyu nøørø mu misag warab waraimøsrømay ibig køn. Inchen misaamerabe truba nu wammørøppe, pueblomerayugurri webamba, nuimay katsikkatø ambub mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Inchen Jesús barcoyugurri pinaya, truba nu misag pasrai ashabe, nømun lastima køben, nømui utu kwanrreelan tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Inchen yandø mawabrab købene, nui kusrenanøb pera uniiløbe Jesúswan kemallabe, trenchibelø køn: —Yube mu misakkanug køn cha. Inchagucha yandø maabenwein køn cha, misagwan amrrai ‘ungwa’ chi cha, yamera pønrrabsrø amba, nømuyasig mamig pena manrrain— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Inchene Jesúsbe trenchiptinchibig køn: —Chi ambamibe palømøn cha. Manrrai ñim mannay— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Inchene nømbe trenchibelø køn: —Nambe trattrøgatø pirrimbah, pagatø peskaubatø tøgaguer— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Inchene Jesúsbe trenchibig køn: —Yu srua amrrurray— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Incha tru nu misagwan pubilayu purramisringarua, tru trattrøgatø pirrimeranba, pagatø peskaumeranba, tasku muta, srømbalaneb neesha, Tiuswan ‘mayanguen pay’ chibig køn. Incha pirrimeran pirisha, nui kusrenanøb pera uniilan tranen, nømbe misagwan pirishibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Inchen mayeeløba øska ma kørrømisren, katøgucha pitis undailan tasinmerayu netsøbatø doce tulishibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Inchen tru mabeløbe ishumburwan, uregwan munchimuben, møgueløtø trattrø mil købig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Incha yandø Jesúsbe nui kusrenanøb pera uniilan pisu ambøgatøsrømay merrab amrrai barcoyu nebambingarubig køn, tru nu misagwan ‘ungwa’ chib pasrappatø. ");
INSERT INTO gum_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Incha yandø misagwan chab ‘ungwa’ chabe, nøbe nøtø kan tunbalasrø Tiusba waminchab ya, yem køben nøtø trusrø wabig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Trune yandø barcobe pisuyu yabsrønguen iben, pi welarmerabe barcongøba megambubig køn, kaguende isiibe nømui malaugøba megambub ichen. ");
INSERT INTO gum_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Inchen løtsøzhig yemdø Jesús pi palawan katsikka nømuimay kemallib ibene, ");
INSERT INTO gum_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","nui kusrenanøb pera uniilø pi palawan arri ashippe, truba kwaarøb kørig købiitø trenchib trashibelø køn: —Kan møsig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Inchen Jesúsbe møi møi nømune waminchib trenchibig køn: —¡Kørmø, mur isua purray! cha. Na kur cha. Kørig kui inchimøtay— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Inchene Pedrobe trenchiptinchibig køn: —Señor, trube, ñi kuabe, nan ñuimay pi palawan: “Amø” chirra— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Inchene Jesúsbe trenchibig køn: —Amø pøs— cha. Inchen Pedrobe barcoyugurri pinaya, pi palawan Jesúsweimay ib mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Incha tru mur isig ichibigwan tab ashippe, køriimataptinchibig køn. Inchen nune asentab mendaptinchen trashibig køn: —¡Señor, wesrurra!— chib. ");
INSERT INTO gum_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Inchene Jesúsbe møi møi tasigu kemørabe, trenchibig køn: —Ñi kui ñui isubigwane nainug ke ka kømønrraindiitø pasra tøgaig cha. ¿Chindimbarre kaimamuitamab isugu?— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Incha barcoyu nebamben latatø, isiibe wasrøngandø pasramisrøptinchen, ");
INSERT INTO gum_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","barcoyu purrabeløbe nune køriibala tabig waminchib trenchibelø køn: —Isa kømø, ñibe Tiuswei Nusrkain køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Incha yandø tru pisuyu chab larraamba, Genesaret pirausrø pubene, ");
INSERT INTO gum_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","misaamera Jesús kui nebua ashabe, wammørøsrøngarubelø køn tru pirau ørøba. Inchen nuimay maya kwanrreelan srua amrrua: ");
INSERT INTO gum_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Ñi pala itøguewa kuig urøzhigwan namun katørabashcha— chib, rugabelø køn. Incha mayeeløba katørabeløbe tabig kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Møiløgøsrøn Jerusalénsrøngurri amrrubelø fariseosmeraba, Moisés pørigwan kusrenanøbeløba Jesúswan kemallabe, trencha payibelø køn: ");
INSERT INTO gum_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ñui kusrenanøb pera uniiløbe namui merrabsreelø trendø treeg marøb tøgagúigwane chindimbarre itøbunabelø køh? cha; pøs mappe, nømbe tasigwan kinømø mabelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Inchene Jesúsbe trencha payibig køn: —Trube, ¿ñimgucha Tius maig maramigwan martrai pønsrailane chindimbarre marmeelø køgue cha, ñim ñimuimburab trendø treeg marigwan marøg købiitø? ");
INSERT INTO gum_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaguende Tiusbe trendaig køn: “Ñui møskai, ñui usrane maig købash inchimø, tab indamig køn” cha. Katø: “Møskawan kui, kabe usran kui trømbøig nebunrrai wamabigwane trunune kwanrrai pasrig kønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Trune ñimbe trenchibelø køn: “Kan møøbe møskawan kui, kabe usran kui trenchinrrun cha: ‘Na ñimun purugumig tøgagúigwan Tiuswan tranar cha. Ñimune purugunrrab kaimamønrrun’ chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Incha møikkøben øyeeg taikkurrimbe, yandø møskawan, usrane lastima ashib purugumibe chi palømøn” cha, ñimbe trenchibelø køn cha. Øyeeg marøppe, ñimbe Tius martrai karua pasrigwane chigucha kømíig kui lataig mara srua køn cha, ñimui trendø treeg marøb tøgagúilan marøg køptø. ");
INSERT INTO gum_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Palatø tabelø! Tius maig karuigwan eshkabig Isaías ñimuimburab sølwein tain køn øyah chippe: ");
INSERT INTO gum_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","I misaamerabe nan ka triitøgatø tab inndan cha. Inchendø nømui manrrøbe nainukkurrimbe yab pønrran cha. ");
INSERT INTO gum_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nan køriibala tabig waminchib taibe chiweingucha chi tabig marig kømøn cha, møguelø martrai karua pønsrailan øyeeg maramig køn chib kusrenanøb.— ");
INSERT INTO gum_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Incha Jesús misagwan nuimay wama trenchibig køn: —Kalutøga mørøb, katø chigúi mørøb inday cha. ");
INSERT INTO gum_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Møwan trigu kebibiibe nune chi kaig trømbøig marmøn cha. Treeg kømøtø, møwan kaig trømbøig marøbiibe trigugurri webibig, truibe si, nune trømbøig maran— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Inchene nui kusrenanøb pera uniiløbe Jesúswan kemallabe trenchibelø køn: —¿Ñi øyeeg tailan fariseosmera mørabe, namig mørigwan ashtirru?— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Inchene nøbe trenchibig køn: —Chi tusr køben nai Møskai srømbalasrø wabig ellgwaimíigwane srølbañau kitig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nømune kagøbasay cha. Kaguen nømbe kabgailø katøgan kabgailandøwei srua ambubelø køn cha. Kan kabgaima katøgan kabgaigwan srua yabe, trabyu pailøba kegørrønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Inchene Pedrobe Jesúswan trenchibig køn: —Tru ‘øyeeg lataitøwein køn’ cha, kemesra wamindigwan namun tab eshkarra— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Inchene Jesúsbe trenchibig køn: —¿Ñimgucha chigúinguen mørmøwa pønrrøtirru cha? ");
INSERT INTO gum_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Chitøgucha trigu kebibiibe patsau kørraibig kui ashmeelø køtirru? cha, katø asrugurri webinrrab. ");
INSERT INTO gum_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Trune trigugurri webarrubiibe si, møwei manrraugurri arrubig kua, truibe nune trømbøig marøb mindisan cha. ");
INSERT INTO gum_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaguende møwei manrrø umbugurrimbe kaig isuilø køben, kweetsamelø køben, kasharawarmera itølulamig køben, kasharameelø købendø ishumburba, møgueløba trømbøig maramelø køben, nilamelø køben, isa wamindiilø køben, tsalø wamiilø køben, øyeelø kerriguh werrun cha. ");
INSERT INTO gum_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iiløbe si, møwan kaig trømbøig maran cha. Inchen manrraptø tasigwan kinømuitøbe møwane chi trømbøig marøb mindishimøn— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Incha Jesúsbe truyugurri tarømisra, Tiroba, Sidónba tru ciudamera pønrrab piraumay ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Inchen kan ishug canaansriig tru pirau tsubiibe arrua, Jesúswan trenchib wamab kemallibig køn: —Señor, merrabsrø Davidwei Nusrkai, nan lastima ashcha chib. Nai nimbasrbe kan kwaimandzig ni mumayguen tab uñchaingaig indinab megan— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Inchen Jesúsbe chigucha løtømuben, nui kusrenanøb pera uniiløbe kemallabe, trenchibelø køn: —Tiusmanda, ishuwane ‘inrrø’ chi cha, namui wendautø trashib arrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Inchene Jesúsbe trenchibig køn: —Nane Israel misaamerai utu tru ubisha trubiilø latailaimaytø ørig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Inchene tru ishuube nui merrab arrua, tømbønsrøb trenchibig køn: —¡Señor, purugurra!— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Inchene Jesúsbe trenchibig køn: —Pirriwan uregwan kerrawa, wera-ureezheelan kebusramibe søl kømøn— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Inchene ishuube trenchibig køn: —Øø, Señor, treebe treegwein købendø, wera-ureezheeløguen nømui puarwei mishatsigugurri kørrabzhigwan man— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Inchene Jesúsbe trenchibig køn: —¡Ishug, ñui isubigwan nainug pasra tøgagúibe purø nuig køn! cha. Ñi maig palain pasraig, treeg kønrrun— cha. Inchen tru uraskurri nui nimbasrbe tabig kørrømisrig køn. ");
INSERT INTO gum_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús truyugurri webya, Galilea pisu puluwan purayabe, kan tunbalasrø nebya, truyu wamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Misag truba truba nørrø nø wainug tulundzuna, cojosmera køben, kabgailø køben, asru chiyu køben kesruilø køben, waminchab kaimabelø køben, katøgan chi kwanrrø køben tøgarmera truba nu treelan køben Jesúswei merrab srua amrrua, pønsrøben, nøbe tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Treekkurri tru nu misaabe ashippe, ke kwaara asha kørrømisrøbelø køn, waminchab kaimabeløbe wamindamba, asru chiyu køben kesruiløbe tabig kørrømisramba, cojosmerabe ambamba, kabgailøbe asamba indi ashabe, nømbe Israel misaamerai Tiuswan truba tabig waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Incha Jesús nui kusrenanøb pera uniilan wamabe, trenchibig køn: —Misaameran lastima køtan cha. Chabguen yu pøn kwalømguen naba warøwa, yandø chi mamig chigar køn cha. Nømui yamay chi mameeløbe ambashig kømøtan cha. Kaguende mayutø pesannabgun— cha. ");
INSERT INTO gum_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Inchene nui kusrenanøb pera uniiløbe trenchibelø køn: —Ya nu misagweimbe ¿nambe chincha mamig wetørrayasamø? cha, ya yu mu misag warab warømøsrømbe.— ");
INSERT INTO gum_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Inchene Jesúsbe payibig køn: —¿Ñimbe pirri mam tøgagøgue?— cha. Inchene nømbe: —Pirri sietebah, katø mamdø peskau-ureebatø tøgaguer— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Inchen nøbe misagwan pirau purramisringarua, ");
INSERT INTO gum_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","nui tasigu tru pirri sietenba, peskaumeranba muta, Tiuswan ‘mayanguen pay’ chabe, pirisha, nui kusrenanøb pera uniilan tranen, nømbe misagwan pirishibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Inchen mayeeløba øska ma kørrømisren, katøgucha tru pirisaig undailan tasinmerayu siete netsøbateelø tulishibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Inchen tru mabeløbe ishumburwan, uregwan munchimuben, møgueløtø pib mil købig køn. ");
INSERT INTO gum_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Incha Jesúsbe yandø misagwan chab ungwa chabe, barcoyu kebya, Magadan pirausrømay ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseosmera køben, saduceosmera køben Jesúswan ashchab ambabe, nun chiyugøben kebenøsrkøg køptø, mana asiimíig miabelø køn Tius nøba pasrain kui ashchab. ");
INSERT INTO gum_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Inchene Jesúsbe trencha løtabig køn: —Yandø maaben misrene, ñimbe øyah chibelø køn cha: “Tab kwaløm kønrrab asønan cha. Kaguende srømbalabe ke pigøzhig pasran” cha. ");
INSERT INTO gum_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Inchene løtsøbe ñimbe trenchibelø køn cha: “Møimbe kaig kwaløm kønrrab asønan cha. Kaguende srømbalabe ke wañindø kasraim pasran” cha. Pøs pala wañi maig pasrai asha, ñim ‘øyeeg kønrrun’ chib, ‘øyeeg kønrrun’ chib waminchibeløbe, ¡Møin kwaløm chi pureb arrubigwane, trube, ‘øyeeg kønrrun’ chinrrab wetøgørrønrrab kaimabeløbe mailø køgue! cha. ");
INSERT INTO gum_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Møin kwaløm kaig misaamera, kan kasharawar peeba itøluløpteelø lataitøwei Tiusbatø pønrrømø misaamera kailø, Tius naba pasrain kui ashchab marig miatan cha. Inchendø asha kønrrai katøgan chigøben peg kenamara tranmøtø, tru Jonásweiwandø eshkamønrrun— cha. Incha nømune pønrramnetø, iptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nui kusrenanøb pera uniilø pisu ambøgatøsrø chab larraambabe, pirri srua amrrumigwan pesan amrrubrain kui isuptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Inchen Jesúsbe trenchibig køn: —Au, ñimbe levadura fariseosmeraiwanba, saduceosmeraiwanba ashiptø kuy— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Inchene nui kusrenanøb pera uniiløbe kangurrin kangurri trenchibelø køn: —Nam pirriwan srua amrrumuimbarre trenda chindah— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Inchene Jesúsbe nøm trenchib purrai ashabe trenchibig køn: —¿Chindimbarre kangurrin kangurri ‘pirringar ker’ chib purrøgue? cha. Ñim kui ñimui isubigwan nainug ke kagømønrraindøzhig pasra tøgar cha. ");
INSERT INTO gum_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Katøgucha ni chigúinguen mørmeelø kø chindah? cha. ¿Tru na trattrøgatø pirriwan trattrø mil møguelan pirishiben, undailø mam tasin tulisaigwan ni trunundøguen ke isumeelø kø chindah? cha. ");
INSERT INTO gum_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Katø tru siete pirriwan tru pib milwan pirishiben, ¿tru unchibigwan mam tasin tulisaigwan isumeelø kø chindah? cha. ");
INSERT INTO gum_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ñimbe mandeelø køh cha, chigúinguen mørmønrrappe, na pirriwan waminchib wamubendøbe, nabe tru levaduran fariseosmeraiwanba, saduceosmeraiwanba ashiptø kuy cha, nabe trunun waminche?— ");
INSERT INTO gum_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Inchen nømune ‘tru pirriyu pusri levaduran ashiptø kønrrigay’ chimøtø, ‘tru fariseosmeraba, saduceosmeraba kusrenaniilan ashiptø kønrrigay’ tain kui yandø wetøgørrabelø køn nømbe. ");
INSERT INTO gum_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús Filipo pirau Cesareasrø puabe, nui kusrenanøb pera uniilan payibig køn: —¿Misaamerabe Møg Misra Arrubigwane mu køn tah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Inchene nømbe trencha løtabelø køn: —Møiløbe ‘Juan Bautista køn’ chiben; møiløbe ‘Elías køn’ chiben; møiløbe ‘Jeremías kuinrrun’ tan cha, kabe møikkøben ‘Tius maig karuigwan eshkabig kui’.— ");
INSERT INTO gum_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Inchene nøbe trencha payibig køn: —¿Trune ñimbe nane mu køn chinrrague?— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Inchen Simón Pedrobe trencha løtabig køn: —Ñibe tru Cristo, Øsig wab Tiuswei Nusrkain køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Inchene Jesúsbe trenchibig køn: —Ñibe mayanguen tab kuig køn cha, Simón Jonáswei nusrkai. Kaguende ñune iigwane yaumbaig, animbaig, ka møg kenamarøb eshkamøtø, nai Møskai srømbalasrø wabig eshkan cha. ");
INSERT INTO gum_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Inchen nagucha ñune, ñibe Pedro køn char cha. Nai iglesian i srug pala mara pasramønrrun cha. Inchen kwamig kønrrai marøb pasrabigwei maramburab marøbikken tru iglesiane ni chinchaguen kananrrab kaimanrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Srømbalasrø Tius nø ashib karub wainug llavimeran ñun tranamønrrun cha. Ñi yu pirau lusrøb lataig marene, srømbalasrøngucha lusrøb lataitøwei martrun cha. Ñi yu pirau pichib lataig marene, srømbalasrøngucha pichib lataitøwei martrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Incha Jesúsbe nui kusrenanøb pera uniilan mungøben eshkab kønrrain kømø karua pasrøbig køn, nøbe tru Cristo kui. ");
INSERT INTO gum_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Incha tru uraskurrimbunø Jesúsbe nui kusrenanøb pera uniilan ‘øyeeg kønrrabig køn’ cha, eshkab mendabig køn. Nune Jerusalénsrømay yamig nebuben, misagwan karubelø kølli misaamera, sacerdotesmeran karubelø køben, Moisés pørigwan kusrenanøbelø køben, truba truba kaig indinab megawa, kweetsig kømig nebunrrun cha. Inchendø pøn kwalømyube katø øsiiranrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Inchen Pedrobe nun nøørøsrø pera ya, murtø waminchib mendabig køn: —Tius ashib wawa, Señor, ñun øyeeg puraimuimbe— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Inchen Jesúsbe keeshabe Pedrone trenchibig køn: —Satanás, nainukkurri tarømisr cha. Ñibe nane peñchai ke ka srurrengwangarub attan cha. Kaguende ñibe isuppe, Tius lataig isumøtø, møguelø isuimay isun— cha. ");
INSERT INTO gum_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Inchabe Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: —Møikkøben nai mendig uñig købene, nøasiitø nuimburabigwangøba isumøtø, nui kuruswan mutab, nai mendig arrum nebunrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Inchen møikkøben øsig kømigwangøba isubiibe yandø pinab pinamig nebunrrun cha. Inchen nagurrindø kwabiibe managatig øsig kømigwan wetørrawa, tøgagønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Kan møg yu pirau chine købigwan kerrigu nuindø maringucha, nui øsig kømigwan trubisaibe, chiwein kui tabig kønrrab kø? cha. Kabe ¿kan møøbe kwamønrrappe, chi tranøbsruerah? cha. ");
INSERT INTO gum_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kaguende tru Møg Misra Arrubiibe Møskawei purø nuig tørguegwalmabigu nui ángelesmeraba arrua, møilandøgucha nøm maig marig køben treeg tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pøs nabe ñimun cierton trendamønrrun: Møiløgøben yu purrabelø tru Møg Misra Arrubig nø ashib karunrrab attrab kenamisren, trunun nebua ashmøwatøbe, kwanrraamøn— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Øyeeg taig yandø trunewei kan kwalømdø paløben, Jesúsbe Pedronba, Santiagonba, nui nuneg Juanwanba nøørø kan pala tunsrømay pera ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Incha trusrø nømui merrab Jesúsbe ke peg lataig misrøbig køn. Inchen nui maløbe nøsig lataig tørbilabig misren, nui kewagúiløbe puløzhig pilabig lataig misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Inchene møimbe Moisésba, Elíasba, Jesúsba waminchib pønrrai ashiptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Inchen Pedrobe Jesúswane trenchibig køn: —Señor, nam yu pønrramibe purø tab køtan cha. Ñi martrain købene, pøngatø ya-ureg na maramøh cha, kan ñui, kan Moiséswei, kan Elíasweingue.— ");
INSERT INTO gum_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Inchen Pedro waminchib pasramnetø, kan wañi tørbilabig nømun pinøbulen, wañi umbugurri kan wam trenchibig køn: —Iibe nai Nusrkai undaaraig køn cha. Nabe nuimburab truba tab kui war cha. Nune møray— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Inchen iigwan mørøppe, nui kusrenanøb pera uniiløbe truba truba kørig kuilø, maløwan pirau kebatamnegatig utsøbasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Inchen Jesúsbe nømun kemalla katørab trenchibig køn: —Chi køriimatømøtø, kurray— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inchen nøm kurraashene, mugucha kenamuben, Jesúswane nøtø pasrai ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Incha tru tunsrøngurri kørrørrub amrruabe, Jesúsbe trenchib karubig køn: —Mungucha waminchib kønrrab kømø cha, tru asigwan, tru Møg Misra Arrubig kwailai utugurri øsiirawa katø kurramnegatig.— ");
INSERT INTO gum_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Inchen nui kusrenanøb pera uniiløbe Jesúswan payibelø køn: —Trube, treeg købene, Moisés pørigwan kusrenanøbeløbe ¿chindimba Elíasmerrig arrumig køn tah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Inchene Jesúsbe trenchibig køn: —Elíasbe arrubwei inchun cha. Incha nøbe kerrigu katøyug tamara pønsrønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Inchendø nabe trendamønrrun: Elíasbe arrubguen inchen, nune mu kui nebua ashmøtø, nømun maig marøg købendø, marig køn cha. Møg Misra Arrubikkucha treetøwei nømui tasku kaig marinab meganrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Inchen nui kusrenanøb pera uniiløbe Jesúsbe tru Juan Bautistan wamindin kui wetøgørrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Misag truba nu pasrainug nøm chab pubene, kan møg pua, nui merrab tømbønsrabe, trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Au, nai nusrkawan lastima ashcha cha. Kaguende pesannabig tøgaig kua, truba trømbøig nebuinab megabig køn cha. Katø katø nagu kebeñib, piyu kebeñib inchibig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na ñui kusrenanøb pera uniilaimay pera arrubendø, tamartrab kaiman— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Inchene Jesúsbe trencha løtabig køn: —¡Kan ñim møi misaamera kørenrrab inchimeelø larrø kailø! cha, ¿nabe managatig ñimba unamig kønrrerah? cha. ¿Kan øyeeg ashiptø managatig ñimba unamerah? cha. Unan yusrø naimay srua amrruy— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Inchen Jesúsbe tru kwaimandzigwan nama, unainukkurri wambig weguchen latatø, unøbe tabig kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Inchen nui kusrenanøb pera uniiløbe nømdø nøørø Jesúswan kemalla, trencha payibelø køn: —¿Nambe kwaimandzigwan wambig weguchappe, chindimba kaimah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Inchene Jesúsbe trenchibig køn: —Kaguende ñimbe ñimui isubigwan nainug ke ka kømønrraindiig pasra tøgar køn cha. Pøs nabe ñimun cierton trendamønrrun: Ñim kan murtasa yellburaptiitøguen ñimui isubigwan nainug pasra tøgar kuimbe, ñim i tunwan: “Yugurri mendamisra, katøgansrø purainrrø” chibene, tru tunbe purainrrun cha. Pøs ñimuimbe chitøgucha kaimamdiibe chi kaagøn cha. ");
INSERT INTO gum_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kaguende øyeeg kwaimandziibe Tiuswan purugurra chib miaitøgaba, ayunab indiitøgaba treeg marendøwei webibig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea pirausrø ketøtø amøñippatø Jesúsbe trenchibig køn: —Tru Møg Misra Arrubigwane møguelai tasku tranig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Inchen kweechen, pøn kwalømyube katø øsiirawa kurrønrrun— cha. Iigwan wammørabe, nømbe truba isui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesúsba nui kusrenanøb pera uniiløba Capernaumsrø pubene, Tiuswei yaburø trendø an pagaranrrain taigwan an utabelø Pedroimay ambabe trenchibelø køn: —¿Ñimui kusrennøbikkan Tiuswei yaburø trendø truburø an pagarab kømigwan pagaramíig kuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Inchen Pedrobe: —Øø, pagarabwei inchibig køn— cha løtabig køn. Incha Pedro yau kebibene, Jesúsbe øyeemerrig trenchib waminchibig køn: —¿Simón, ñibe maig isuguh? cha. ¿Yu pirau reymerabe trendø pagaramigwan pagaraig utappe, mumeran utah? cha: ¿Nømui misaamerandøweindeh? Kabe: ¿Peesrøngurri amrrub misaamerandeh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Inchene Pedrobe trenchibig køn: —Peesrøngurri amrrub misaameran utabelø køn— cha. Inchene Jesúsbe trenchibig køn: —Trube, treeg købene, tru pirau misaameratøweimbe chi pagaramikken palømuinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Treeg kuingucha, nambe mungucha namishimønrrab, nu pisuyumay ya, anzuelun ke keguchendø, megamisrøb peskauwan wesrunrrig, chibig køn. Incha peskauwei trigwan kurabe, kan an wetørranrrabguen cha, maya tranamigwan neikke. Incha naimburøba, ñuimburøba srua ya, pagarau— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Inchen tru urastøwei nui kusrenanøb pera uniilø Jesúswan kemallabe, trencha payibelø køn: —¿Srømbalasrø Tius nø ashib karub waisrømbe mas nuibe mu køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Inchene Jesúsbe kan unan wama, nømuin tøbøtag pasrabe, ");
INSERT INTO gum_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","trenchibig køn: —Pøs nabe ñimun cierton trendamønrrun cha: Ñim peemayelø misrøb, ureg lataig misrmuisruandøbe, srømbalasrø Tius nø ashib karub wainuube managuen kebamrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nøasiitø ‘nuig kurmab’ isumíig, i unø lataig misrøbiibe, srømbalasrø Tius nø ashib karub waigu mas nuig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Inchen møikkøben kan i unø lataigwan nai munchiyu tab wamab utabiibe, nan utan chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Møigwan køben i shushmera latailan nan kørebelan kaig mara kebenøsrkøbigweimbe, trembe tru tirigu kitsig nu srugwan naashigu mesra, mar umbusrø kegucha, pi keesra kwangaruinguen søl købsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yu nam waraig pirøwaimburappe kan yeekkucha kuita, chine pønrrabelø misagwan kaig martrai inchib pønrrøben, trune kaigwan nø pera mara kebenøsrkøb møwaimbe ¿maig kønrrerah? ");
INSERT INTO gum_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Inchawei ñui tasig kui, ñui srøb kui kaig maringarua kaigu ñun kebenøsrkøbene, para, kuchi. Managatig øsig wamsrø tasig palabig kui, cojo kui kebyamikken søl kønrrun, pa tasig tøgaig, pa srøb tøgaig tru managuen kwamø nagu kegutsig købgunrriibe. ");
INSERT INTO gum_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Inchen ñui kab kaig maringarua kaigu ñun kebenøsrkøbene, wesrua, kuchi chibig køn, managatig øsig wamsrø kan kaptø tøgaig kebyamikken søl kønrrun cha, pa kab pusraig møra melamnug kwamø nagu kegutsig købgunrriibe. ");
INSERT INTO gum_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Au, i shushmeran møilandøgucha kashmøtay. Kaguende srømbalasrø nømui ángelesmerabe nai Møskai srømbalasrø wabigwei maløwan chu urastøgucha ashib pønrran char nabe. ");
INSERT INTO gum_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kaguende Møg Misra Arrubiibe tru trubig købigwan kaigyugurri wesranrrab arrig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Ñimune maig asønata? chibig køn. Kan møg cien ubishamera tøgagua, kan pella ya, trubøbenma, noventa y nueven tunbalawan waramnetø, tru pella trubabigwan kabe ¿chugøben lanrrab imønrraitarru? cha. ");
INSERT INTO gum_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Incha nabe ñimun cierton trendamønrrun: Wetørrappe, tru trubabigweimburab mas purø kasraaranrrun cha, tru noventa y nueve ka amøñibelaimburab lataguen kømø. ");
INSERT INTO gum_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Øyeetøwei ñimui Møskai srømbalasrø wabiibe i shushmeran ni kanguen trubømuimbemab indan chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Inchawei ñui nuneg ñun chigøben kaig marene, ya, ñibe nundø mara, waminchi. Incha nui kalø marigwan kalø marig kui ashchai nebua isungaru. Inchen ñun mørene, ñibe ñui nunewane tab kørrømisrtrai kusrawa pasran. ");
INSERT INTO gum_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Inchen ñundø mørøg kømui inchene, trube, kandø kui, pagatø kui wamø, chi pub arrubigwandøgucha pailø kui, pønelø kui maig kuigwan nøm wamindigu treeg kørrømarig kønrrai. ");
INSERT INTO gum_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Inchen truilangucha mørøg kømui inchene, trube, iglesiayuelan eshkau chibig køn. Inchen katø iglesiayuelan mørøg kømui inchene, trubeguende, yandø Tiuswan ashmíig judío kømíig lataig, kabe kan romasreelayasig an utaptø wabig lataig mara kørrømaray cha. ");
INSERT INTO gum_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Pøs nabe ñimun cierton trendamønrrun: Ñim yu pirau lusrøb lataig marene, srømbalasrøngucha lusrøb lataitøwei martrun cha. Inchen ñim yu pirau pichib lataig marene, srømbalasrøngucha pichib lataitøwei martrun cha. ");
INSERT INTO gum_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Nabe katø ñimun trendamønrrun: Ñim møikkøben pailø yu pirau chigøben Tiuswan mianrrab lata kandø isua purramisra, miabene, nai Møskai srømbalasrø wabiibe ñim miaigwan tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kaguende pailø kui, pønelø kui nai munchiyu tulundzuna purrainuube nabe nømui utu pasrar— cha. ");
INSERT INTO gum_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Inchen Pedrobe Jesúswan kemalla, trencha payibig køn: —Señor, nai nuneg nan chigøben kaig marøbig marene, nabe ¿mam piejegatig pesannab ulø paymumig kønrrab kø? cha. ¿Kabe sietegatiitøteh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Inchene Jesúsbe trenchibig køn: —Nabe siete nebumnegatiitø chimur cha. Treeg kømøtø, sietebatø setenta piejeskatig char— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Srømbalasrø Tius nø ashib karub waibe kan rey nui karuindiig melabelø nømui ulø misriilan mayambatø ulø køtashchab ashchab wamisrøb lataig køn. ");
INSERT INTO gum_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Incha truigwan ashib mendøbene, kan truba truba nu an ulø misraigwan pera amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Inchen tru i møøbe katøburø anwan ungwa chinrrab kaimaptinchene, nui reybe nunba, nui srawanba, nui uregwanba nui chi tøgagúigwanbañau yanrrai karubig køn, tru ulømisri anwan wartrai. ");
INSERT INTO gum_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Inchen nui karuindiig megabiibe reywei merrab tømbønsra trenchibig køn: “Au, nai rey, tiusmanda, nan øyeeg nebui megaben lastima ashibsrumugu cha, kerrigu nai uløwan wartrumøn” cha. ");
INSERT INTO gum_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Inchene reybe waachawan yeeg nebuitamab isua, nui ulø misrigwan paymønrrab kaabasha, ka inrrai, ka elachibig køn. ");
INSERT INTO gum_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Inchen tru karuindiig megabiibe webya ya, katøgan nøba lincha karuindiig megabig nun lamøtiig ulø misraigwan katappe, naashigu merrarrawa, ke chab isrømbuløsrkøb trenchibig køn: “Nai uløwan trannrra” chib. ");
INSERT INTO gum_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Inchene tru nøba lincha karuindiig megabiibe nui merrab tømbasra trenchibig køn: “Tiusmanda, nan lastima ashcha chib. Uløwan tranrrumøn” cha. ");
INSERT INTO gum_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Inchen kane kagøbashig kømuptø, kailan keeri yau keeringarubig køn nui uløwan tranamnegatikke. ");
INSERT INTO gum_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","’Inchen katøganelø tru karuindiig lincha melabeløbe øyeeg inchen trunun asha, nømune truba pusrkwaben, chi purayaigwan kerriguh reywan eshkanrrab ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Inchen reybe tru kagøbashmø ulø payiptiigwan wamønrrab øra trenchibig køn: “¡Karuindiig megabig, larrø kaig! cha. Ñi nan ulø kuigwan nagurrima ñun ulø paymø, pesannar cha, ñi kaabashcha chib truba truba rugaben. ");
INSERT INTO gum_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pøs ñigucha tru karuindiig ñui lincha megabigwane maindi lastima asambala chibig køn, na ñun lastima ashib lataitøwei.” ");
INSERT INTO gum_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Incha reybe truba namaptø, maya ulø kuigwan kerrigu anwan waramnegatig kaigyu møra meganrrai marøbelan tranøbig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Inchabe Jesúsbe trenchibig køn: ’Nai Møskai srømbalasrø wabikkucha ñimune øyeetøwei martrun cha, ñim møitøgucha ñimui nunewan manrraugurri kerrigu newan pesannab, kagøbashmuisruandøbe.— ");
INSERT INTO gum_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús øyeelan chab waminchabe, Galileasrøngurri ya, Judea pirausrø pubig køn, Jordán pi ambøgatø pørr kal-labgatøsrø. ");
INSERT INTO gum_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Inchen misag truba nu mendig amben, truyu kwanrreelan tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Inchen fariseosmera Jesúswan kemallabe, chincha køben kebenøsrkønrrab isua, trencha payibelø køn: —¿Ka chigurrin køben srawan kutsamig chi merømíig kø chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Inchene Jesúsbe trenchibig køn: —¿Ñimgan Tiuswei wamwan pørigu lemeelø køtirru cha, tru srøsrø marøb uras marøbig Tiusbe: “Møwanba, ishuwanba ellmarigwan”? ");
INSERT INTO gum_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Incha Tiusbe trendaig køn: “Øyeekkurri møøbe møskawanba, usranba elatchun cha, nui sraimba kandø kønrrab. Incha tru pailøbe kan asrtø kønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Inchawei yandø pailø kømø, kan asrtø køn. Inchawei treeg købene, Tius kandø mara lindisaigwane møøbe tarømaramig kømøn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Inchene nømbe trencha payibelø køn: —¿Trube treeg købene, Moisésbe chindimba kilga mara, purørtrain karuig køh? cha, srawan tarømisrtrab— cha eshkabig. ");
INSERT INTO gum_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Inchen Jesúsbe trenchibig køn: —Ñimui manrrømera isumíig larrø mureløgurri Moisésbe ñimui sralan ka treeg marbasig køn cha. Inchendø srøsrøbe øyeeg kømuig købig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Trune nabe trendamønrrun: Kan møg, nui sraimbe katøgan møøba trømbøig marøb itølulmubendø, nui srawan kucha, katøgan ishuuba kasharabiibe, itølulan— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Inchen nui kusrenanøb pera uniiløbe trenchibelø køn: —Srawanba, kewanba øyeeg pubig købene, trembe kasharamuinguen— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Inchene Jesúsbe trenchibig køn: —Kasharamønrrab tamibe mayeelain kømøn cha. Tius truburab kønrrai traniilaindøwein køn cha. ");
INSERT INTO gum_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Møguelane kasharamumig chigurrin køben øyeeg katabelø lataig pønrran cha. Kan utueløbe kasharamigwane chi palai mørtrabgailø usrai patsaugurri treeg kal-lawar køn cha. Inchen kan utuelane sralø palai mørmønrrai kapawa kørrømariilø køben, kan utueløbe srømbalasrø Tius nø ashib karubweimburabikkurri ka trendø nømuinetø tre latailøtøwei misran cha. Møikkøben Tiusweimburabeløyu marøb uñchab treeg kørrømisramdiig kui mørabe, treeg kørrømisr— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Inchen Jesúsweimay ureemeran srua amrrubelø køn, nømuim pala tasigwan estsara, nømuimburab Tiuswan mianrrai. Inchen nui kusrenanøb pera uniiløbe tru srua amrrubelan namaptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Inchene Jesúsbe trenchibig køn: —Uregwane merømø, naimay ka amrrubasay cha. Kaguende srømbalasrø Tius nø ashib karub waibe nøm latailaiwein køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Incha tasigwan uregweim pala estsarabe, nøbe truyugurri ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kan møg Jesúswan ashchab yabe, trencha payibig køn: —Kusrennøbig, managatig øsig kømigwan na tøgagønrrappe, ¿chigøben tabiibe chi maramø?— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Inchene Jesúsbe trencha løtabig køn: —¿Ñibe nane tru tabigweimburappe chindimba paygu? cha. Mugucha tabiibe kaaben, Tiustøwein køn cha, tabiibe. Inchawei managatig øsig kømigwan tøga pasrønrrappe, Tius maig maramigwan martrai pønsraigwan møra, mar— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Inchen matsinøbe: —¿Møilø køh?— chibene, Jesúsbe trenchibig køn: —Kweechimøwei, itølulmøwei, nilømøwei, katøganuimburab isa waminchimøwei, ");
INSERT INTO gum_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","usri møskawan maig købash inchimø, tab inchib, katø ñima ñiasiitøwei maig undaguig køppe, ñui mendaigwangucha treetøwei undaarab inchi— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Inchene matsinøbe trenchibig køn: —Nabe iilane kerriguh marøbig kur cha. Masbe ¿chitø palerah?— chiben, ");
INSERT INTO gum_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesúsbe trenchibig køn: —Chigucha palømíig newan tabig kønrrappe, ya, ñui chi tøgagúigwan yana, waachameran tranø cha. Treeg marabe, srømbalasrømbe chigurrimbunø tøgagønrrabguen cha. Trugurrimbe arrua, nai mendig amø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Inchen tru matsinøbe iigwan mørøppe, truba isui ibig køn, kaguende truba puaig kua. ");
INSERT INTO gum_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Incha Jesúsbe trenchibig køn nui kusrenanøb pera uniilan: —Nabe ñimun cierton trendamønrrun cha: Srømbalasrø Tius nø ashib karub wainug kan puaig kebyamibe truba murig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kan camelloguen tsusain kal trabyu illmø larrayandiig køben, kan puaibe Tius nø ashib karub waisrø kebinrrab kaimanrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Inchen nui kusrenanøb pera uniiløbe iigwan mørabe, truba kwaarøb trenchibelø køn: —Treeg købene, ¿kaigyugurrimbe mu kui wesraig kønrrautah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Inchen Jesúsbe nømun ashabe, trenchibig køn: —Møgueløbe iigwan martrab kaimanrrun cha. Trune Tiusweimbe si, chitøgucha maramdiitø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Inchen Pedrobe trenchibig køn: —Au, nambe chi tøgagúigwan kerrigu elacha, ñui mendig amrruig køn cha. ¿Nambe, trube, chi utamig kønrrerah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Inchene Jesúsbe trencha løtabig køn: —Pøs nabe ñimun cierton trendamønrrun cha: Katøyug chi købigwan srøig tamarøb uras tru Møg Misra Arrubig nø wamisrig tørguegwalmabigu nø wamisrøb uras, ñim nai mendig amøñibeløbe tru purramisra karub purraig doce pønrrabeløyu purramisra, tru doce nusrkalø Israelwainukkurri karrab misaameran ñim ashib karub purramisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Inchen mayeeløba yameran, nunelan, nuchalan, usri møskawan, uregwan, pirømeran nai munchigurrindø elachibeløbe cien piejes menrraguen utab, katø managatig øsig kømigwangucha Tius tranig utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Inchen møiløgøben møi ya yu pirau nømmerrig pønrrabeløbe trusrømbe srabe melønrrun cha. Inchen yu pirau srabe melabeløbe, trusrømbe nømmerrig pønrrønrrun— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Srømbalasrø Tius nø ashib karub waibe øyeeg lataig køn, kan pirø puaig truba løtsøzhig nui uvas ellguailøyu kwallchabelø lanrrab webibig lataikke. ");
INSERT INTO gum_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Incha tru piunmeran mawawan mayan pagaramig køben treeg pagaranrrab misra, incha nui uvas ellgwainug kwallchay øran cha. ");
INSERT INTO gum_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Incha tru løtsø las nueve katøyug webarruabe, katøganelø plazayu chi maramikkar purrai ashabe, ");
INSERT INTO gum_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","trenchibig køn cha: “Ñimgucha nai uvas ellgwainug kwallchab ambay cha, maig pagaramigwan treeg pagararrumøn” cha. Inchen nømbe ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Incha puaibe katøyug kwaløm tøbøtag webya, katø maaben las treskucha webya, treetøwei marøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Incha maaben las cinco køsrøn katøyug plazayumay yabe, katø møiløgøsrøn chigucha maramikkar purrai ashabe, trencha payibig køn: “¿Ñimbe mawa ørøba chi marmøbe yube chinchib purrøgue?” cha. ");
INSERT INTO gum_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Inchene nømbe trencha løtabelø køn: “Namune muguen chi maramig tranmøtan” cha. Inchen nøbe trenchibig køn: “Ñimgucha ambay cha, nai uvas ellgwainug kwallchab.” ");
INSERT INTO gum_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Inchen yandø yem misren, tru ellmarig puaibe nui kwallibelan ashibigwane trenchibig køn: “Kwallib melabelan wama, pagarau cha. Tru srabe kerrubelanmerrig pølbasra, srøsrø kerrubelane srabe pagaranrrig” cha. ");
INSERT INTO gum_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tru maaben las cinco lutau køben kebambubelømerrig kemalla, møitøgucha mawa ørøba marøb meløwa lataitøwei neig utabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Inchen yandø merrab kebambubeløbe mas utamuitamab isua meløbenba, nøm møitøgucha mawa ørøba marøb melaigwandøwei utabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Incha tru marøb melaimburø anwan utabe, tru ellmarig puaigwane nømdø truba namig waminchib mendabe, ");
INSERT INTO gum_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","tru puaigwane trenchibelø køn: “I tru srabe kerrubelø kan urazhiitø marendø, ñibe truilangucha nam pørryu mawa mawa marøb melabelan lataitøwei lata pagaran” cha. ");
INSERT INTO gum_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Inchen tru tra puaibe nømun møigwan køsrøn trenchibig køn: “Kasuku, nabe ñune chigucha chi kalø marmur cha. ¿Yamba mawa marigwan ñune øyah pagararrumøn chiben, ñibe treeg kørrømisrømmørgøppeh? cha. ");
INSERT INTO gum_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ñui an kanaigwan cha, chibig køn. Møimbe inrrø cha. I srabe martrab kebarrubigwan ñun lataitøwei pagarag køben treeg pagarar cha. ");
INSERT INTO gum_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Nan maig maramdiig køben, naiwane nabe na asha maramig kømuitarru? cha. ¿Kabe na merøgømíig menrra tabig kui ashiptø ñibe pusrkwai ashkuh?” cha. ");
INSERT INTO gum_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Inchawei møi ya srabe melabeløbe nømmerrig pønrrøben, møi ya nømmerrig pønrrabeløbe srabe melønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús yandø Jerusalénsrømay nebib yabe, nui doce kusrenanøb pera uniilan nøørø wama, trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Au, nambe Jerusalénmay nebambub amber cha. Trusrømbe Møg Misra Arrubigwane sacerdotesmeran karubelanba, tru Moisés pørigwan kusrenanøbelanba tranen, truiløbe nune kwanrrai pasrtrun cha. ");
INSERT INTO gum_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Incha nømbe nun indzatø ashib, kurraguchib, kurusyu mesrøb inchai judíos kømeelan tranrrun cha. Inchen pøn kwalømyube katø øsiirawa kurrønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeowei nusrkalai usrimbe nui nusrkaløba Jesúswei merrab chigøsrøn mianrrab, nøbe tømbasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Inchene Jesúsbe payibig køn: —¿Chi paløta?— cha. Inchene nøbe trenchibig køn: —Ñi ashib karub wainug nai nusrkalan, kanun kusrmay, kanun ñui atsimay purramisringarurra— cha. ");
INSERT INTO gum_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Inchene Jesúsbe trencha løtabig køn: —Ñimbe chi miab pønrrermabguen mørmøn cha. ¿Na tru copayu mutsam piwan, kabe ñim muchibsrugueh?— cha. Inchene nømbe trenchibelø køn: —Øø, mutsamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Inchen Jesúsbe trenchibig køn: —Na mutsim piwane si, ñimbe muchibwei inchun cha. Inchendø tru kusrmayba, atsimayba purrønnamigwane na tranamig kømøn cha. Tru purramibe nai Møskai tru purrønrrabelayasig tamariilaindøwein køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Inchen tru nui kusrenanøb pera uniilø diezeløbe trunun mørabe, tru pa nunelane namabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Inchen Jesúsbe nømun wamabe trenchibig køn: —Ñimguen ashen, judíos kømø misaameran karub purrabeløbe nøm karub tøgagúilane maig købash inchib ke nøm karub purran cha. Inchen truyu møguelø nørreelø nøm karub purrabeløbe mungucha manchinrraingaig karub purrabelø kui ashchai nømbe kenamaran cha. ");
INSERT INTO gum_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Trune ñimui utube ñimbe øyeelø kømumig køn cha. Treeg købgunrriibe, ñimui utu mas nuikkug købene, katøganelø karuindiig megamig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Inchen ñimui utu møikkøben ñimmerrig melag købene, katøganelø karuindiig megamig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kaguende øyeetøwei tru Møg Misra Arrubikken katøganelø nuyasig marøb melønrrai arrumøtø, nøguen katøganelayasig marøb meganrrappa, nø kwaitøga truba nu misagwan purøbagarawa, kaigyugurri wesranrrappa arrig køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nøm Jericógurri webamba ambene, misaamerabe truba nu wendautø ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Inchen pailø kabgailø may menda purrøwabe, Jesús purayai mørøppe, trenchib trashibelø køn: —¡Namun lastima ashcha chib, merrabsrø Davidwei Nusrkai!— ");
INSERT INTO gum_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Inchen misaamerabe niløtø purrønrrai namingucha, nømbe mas mur trashib trenchibelø køn: —¡Señor, namun lastima ashcha chib, Davidwei Nusrkai!— ");
INSERT INTO gum_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Inchen Jesúsbe pasramisra, kabgailan wamabe, trencha payibig køn: —¿Ñimuyasig na chi maramig paløta?— cha. ");
INSERT INTO gum_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Inchene nømbe trenchibelø køn: —Señor, namune namui kabmera ashibig misrimbe køtan— cha. ");
INSERT INTO gum_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Inchen Jesúsbe nømun lastima asha, nømui kabmeran katørabene, tru urastø kabgailøbe ashibelø misra, Jesúswei mendig ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yandø Jerusalénsrø chab pub amba, Betfagé pueblo tru Olivos Tunsrø chab puabe, Jesúsbe nui kusrenanøb pera uniilø pailan ");
INSERT INTO gum_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","trenchib karua ørøbig køn: —Ø pinrrøguesrø yamera tsitsø pønrrabsrømay ambay cha. Trusrømbe pubyutø kan burra, burro-unøzhig peraig, litsig wetørranrrun cha. Incha picha, srua amrrunrrigay cha naimay. ");
INSERT INTO gum_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Inchippa møikkøben chigøben chibene, øyah chinrrigay chibig køn: “Señor palai indan” cha. Inchen truibe pebrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Øyeeg pureppe, Tius maig karuigwan eshkabig maig taig treeg nebunrrain kuig køn, tru øyah chib pørig: ");
INSERT INTO gum_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sion ciudayuelan øyah chib eshkau cha: “Asay chib, ñimui Rey ñimuimay arruppe, chigucha chi nuig kømíig lataig kan burroyu, burro-unøyu itøguana arrun taig, kan carga nigab animal lluig unøyu.” ");
INSERT INTO gum_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Inchen nui kusrenanøb pera uniiløbe Jesús maig karuigwan treeg mara, ");
INSERT INTO gum_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","burran unanbañau srua amrrua, nømbe nømui kewagúilan burranba, unanba kayen, Jesúsbe itøguanabig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Inchen misag truba nu pasrabiibe møiløbe nømui kewagúilandøwei maywan kayen, møiløbe kullag srarcheelø lutiicha kayibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Inchen merrab amrrubelø lata, wendau amrrubelø lata, øyah chib trashib amrrubelø køn: “¡Rey Davidwei Nusrkai Hosanna! chib. ¡Señor Tiuswei munchiyu nø ørig arrubiibe mayanguen tab kuig køn! chib. ¡Srømbalasrømbe Hosanna!” chib. ");
INSERT INTO gum_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalénsrø kebibene, maya misaamera ke chi indi asamgaig inchib, møiløgøben trenchib payibelø køn: —¿Iibe mu køh?— chib. ");
INSERT INTO gum_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Inchen tru nu misag søtøbe trenchibelø køn: —Iibe Tius maig karuigwan eshkabig Jesús Galilea pirau nazaretsriig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús Tiuswei yau kebya, truyu mayeelø yanøb, penab inchib warabelan søtøba wambig webetabig køn. Katø misagwan an yunømarøbelai mishatsiimeran utsøbetab, palomamera yanøbelø purraigwan utsøbetab inchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Incha trenchibig køn: —Tiuswei wamwan pørigube trenchibig køn cha: “Nai tab yabe Tiuswan wamindi ya køn cha, trencha wamig kønrrun” cha. Trune ñimbe nileelø warain trab marin køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Inchen tru Tiuswei yau kabgailø køben, cojosmera køben Jesúswan kemallen, nøbe tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Inchen sacerdotesmeran karubeløba, Moisés pørigwan kusrenanøbeløba Jesúswei tru purø nørreelø mariilan ashib katø Tiuswei yau shush ureemera: “¡Rey Davidwei Nusrkai Hosanna!” chib trasai mørabe, truba namabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Incha Jesúswan trenchibelø køn: —¿Iilø øyeeg chib køben mørtirru?— cha. Inchene Jesúsbe trenchibig køn: —Øø, mørar cha. ¿Ñimgan Tiuswei wamwan pørigu iig øyeeg chibigwan managuen lemeelø køtirru? cha: Pitsø muchib shush ureemeran køben, katø nørrø ureemeran køben ñun newan tabzhig waminchai, ñi Tius treeg marin køn taigwan.— ");
INSERT INTO gum_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Incha nømun pønrramnetø, ciudayugurri webya, Betaniasrømay yabe, trusrø kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Incha løtsø katø ciudayumay arruabe, Jesúsbe parøgwai mørøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Incha kan higuera tusr may pulu pasrai asha, kemallabe, tru higuera tusrbe ka ishiitø tøgaig kui ashabe, Jesúsbe tru higuerane trenchibig køn: —¡Møingurrimbe yandø managucha mas mamig niimubash!— cha. Inchen tru urastø higuerabe mul-laptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Inchen tru chi purayaigwan nui kusrenanøb pera uniiløbe ashabe, truba kwaarøb, Jesúswan trenchib payibelø køn: —Higuerabe møi møi mul-lanrrappe ¿mandø indah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Inchene Jesúsbe trenchibig køn: —Pøs nabe ñimun cierton trendamønrrun cha: Ñim ñimui isubigwan Tiusweinuutø pasra tøgagua treeg kømuptinchaitamab isumubene, na higueran øyeeg mari lataitøguen kømøtø, ñim i tunwanma: “Yugurri mendamisra, maryu kebeñ” chibene, treeg purainrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Inchawei ñim Tiusba waminchib miappe, chiwandøgucha nø martraitamab kørewa, miawabe, ñimbe utønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús Tiuswei yau kebya, kusrenanøb wamnetø, sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba Jesúswan kemallabe, trencha payibelø køn: —¿Ñi mariilane mu karua pasriitøgarre margu? cha. ¿Ñi øyeeg maramigwane mu karua pasrta?— cha. ");
INSERT INTO gum_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Inchen Jesúsbe løtappe, trenchibig køn: —Nagucha ñimun kan chigøsrøn payrrab inchar cha. Ñim iigwan løtøbene, trube, nagucha eshkarrumøn chibig køn, iilan mu karuitøga marar cha. ");
INSERT INTO gum_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Misagwan Juan piu umbu ulsraibe chugurri arrig køh? cha: ¿Srømbalasrøngurrin kønrrab køh? Kabe: ¿Møgueløgurrin kønrrab kø chindah?— cha. Inchen kangurrin kangurri payiyab mendabelø køn: “ ‘Srømbalasrøngurrin kuig køn’ chibene, nøbe namune trenchinrrun cha: Trube, ‘¿chindimba nune køremøgue?’ cha. ");
INSERT INTO gum_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Katø: ‘Møgueløgurrin kuig køn’, tamgawein køn cha. Kaguende misagwan namune kørig køtan cha. Kaguen ya mayeeløba Juanbe Tius maig karuigwan eshkabig købig kui asha tøgar køn” cha. ");
INSERT INTO gum_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Treekkurri Jesúswane trencha løtabelø køn: —Maig kuindøbeh— cha. Inchene Jesúsbe trenchibig køn: —Trube, nagucha eshkamumønrrun cha, iilan na mu karuitøga marigwan.— ");
INSERT INTO gum_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesúsbe payibig køn: —¿Ñimbe iigwan maig isugue? cha. Kan møg pagatø nusrkalø tøgagua, kanunmerrig trendan cha: “Nai nusrkai, nai uvas ellgwain trau møi kwallchab inrrø” cha. ");
INSERT INTO gum_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Inchene nøbe trencha løtabig køn cha: “Ig kømøtan” cha. Inchendø nøbe yanayube treeg marmønrrurmab isua møra, ka yan cha. ");
INSERT INTO gum_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Inchen møskaimbe katøgan nusrkaweimay yabe, katø treetøwein chiben, nusrkaimbe: “Øø, Papa, na inrrur” chibendø, imøn cha. ");
INSERT INTO gum_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Trube, tru i pa nusrkaløyu møskai maig maringaruigwan ¿møig marerah?— chiben, nømbe: —Tru srøsrø karuinab nusrkai— chibelø køn. Inchen Jesúsbe trenchibig køn: —Pøs nabe ñimun cierton trendamønrrun cha: Romasreelayasig an utabeløba, ishumburmera asrwan anwei yanøbeløba Tius nø ashib karub waisrømbe nømmerrikken kebamrrun cha, ñimguen kebammøwatø. ");
INSERT INTO gum_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kaguende Juan Bautistabe sølgandø tabig mandø amønamigwan kusrenanrrab arruben, ñimbe køremuig køn cha. Trune tru an utabeløba, tru ishumbur an pagarwei trømbøig marøptø warabeløba, truiløguen køreig køn cha. Trune ñimbe iilan kerrigu ashendø, kørenrrab isua mørmuig køn chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Incha møray, chibig køn, katøgan ‘øyeeg lataitøwein køn’ cha, kemesra wamindigwan. Kan møg pirø puaig uvas tra mara, trugurrimbe panig pasra, uvas piwan chu wesrumigwan truyu tamara pasra, incha tru ellmarigwan ashib laramig kan ya-unø palaig mara pasran chibig køn. Incha nui pirøwan katøganelan misrigwan pirishinrraptø kwallchai tranabe, yabsrømay yan cha. ");
INSERT INTO gum_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Incha yandø tru mamig misrigwan lurramig lutauraben, møilan køsrøn nui karuindiig melabelan tru nuimburabigwan tru kwallchab utabelan mianrrab øriibe, ");
INSERT INTO gum_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","tru kwallibeløbe karua øriilan merrarrawa, kanune kurraguchib, kanune kweechib, kanune sruutøga petab inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Inchen tru pirø puaibe srøsrø lataguen kømø, katøbe karuindiig melabelan mas yam øren, tru kwallibeløbe søteelanba treetøweih maran cha. ");
INSERT INTO gum_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Incha yandø trugurrimbe nui trag nusrkawan ørøbig køn cha, treeg isub: “Nai nusrkawane chinchimønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Treendingucha tru kwallibeløbe nusrkawan ashippe, nømdø trenchibelø køn: “Pirøwan ketig utønrrabiibe iigwein køn cha. Kwetchab amun chibelø køn, nuimburab nø utamigwan nam tøga kørrømisrtrab” cha. ");
INSERT INTO gum_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Incha merrarrawa, uvas traugurri wegucha, nune kweechibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Møimbe, trube, ¿tru uvas tra puaig arruabe, tru kwallibelane chi martrerah?— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Inchene nømbe trenchibelø køn: —Tru larrø kailane treetøwei kaig mara kwetchun cha. Incha tru uvas trawane katøgan mendailan tranrrun cha, lurrimørig nuimburabigwan trannrrai.— ");
INSERT INTO gum_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Inchene Jesúsbe trenchibig køn: —¿Ñimgan Tiuswei wamwan pørigu øyeeg chibigwan managuen lemeelø køtirru? cha: Ya marøbelø kaasig sruube katsiisrø pølbasra wayamig mas purø tab srukken misrin køn taigwan. Señor Tius øyeeg marene, namuin kabyube truba tabig asønatan cha. ");
INSERT INTO gum_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Inchawei nabe ñimune trenchar: Tius nø ashib karub waigwane ñimune kerrawa, katøgan peg misaameran Tius tranrrun cha, ellmarig maig misrtrabig køben, treeg ellmarig misrtrabelan. ");
INSERT INTO gum_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Inchen møikkøben tru srug pala peñippe, pitis misrtrun cha. Inchen tru srug muim pala køben peñippe, nune usrø tuindø martrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Inchen tru sacerdotesmeran karubeløba, fariseosmeraba tru ‘øyeeg lataitøwein køn’ chib Jesús eshkab wamindiilan mørabe, nømun kemesra wamindin kui wetøgørrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Incha Jesúswan merrarranrrab inchendø, misag søtøwan køriimatabelø køn, kaguende misaamerabe Jesúswane Tius maig karuigwan eshkabig kui treeg tøgagøben. ");
INSERT INTO gum_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Katø Jesúsbe nømun ‘øyeeg lataitøwein køn’ cha, kemesra kusrenaniilan waminchib mendappe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Srømbalasrø Tius nø ashib karub waibe øyeeg lataig køn cha. Kan rey nui nusrkai kasharaben fiesta marøbig lataikke. ");
INSERT INTO gum_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Incha nui karuindiig melabelan novios yaumay linchunrrigay cha eshkailan wamønrrab øriibe, tru linchab amrrunrrai eshkailøbe amrrug kømui indin køn cha. ");
INSERT INTO gum_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Inchen nui karuindiig melabelan katøganelan katøyug trencha karua ørøbig køn: “Nai tsal-lanin toromeran kweetsingarua mamigwane yandø chab tamaraguen war cha, møimbe si yandø kerrigu ke chab tamarikken pønrran cha, novios yaumay linchubash tan” chinrrai. ");
INSERT INTO gum_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Trune tru linchai eshkailøbe cuentaguen marmø, møikkøsrønbe nui trausrømay iben, katøgane penab, yanøb inchab ibig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Inchen katøganeløbe tru reywei karua øriilan merrarrawa, truba kaig marøb kurrabetab køptø kweechibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Inchen reybe truba namaptø, tru kweechibelane nui suldaumeran truilane kweetsingarua, nømui pueblone parringarun cha. ");
INSERT INTO gum_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","’Incha nui karuindiig melabelane trendan cha: “Isa kømø, tru noviosmerai fiesta maramibe chab tamarig pønrrøben, tru linchab amrrunrrai eshkailøbe treegube linchabgailø kuig kua, amrrumuig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Incha mas nørrø callesmerawan amba, mun wetørrabashtø novios yaumay linchab amrrunrrai eshkanrrigay” tan cha. ");
INSERT INTO gum_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Inchen tru karuindiig melabeløbe callesmerawan webamba, mun wetørrabashtø tulundzunabelø køn, tabelan køben, kailan købengue. Inchen kasharabelø purrai salayube ¡katø! misaatø netsaptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Inchen reybe tru linchab amrrunrrai eshkailan ashchab kebyabe, kan møg noviosyu linchab keegwan keweig pasrømui ashabe, trenchiptinchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Au, kasuku, kasharabyu keegwan keweig kømubendøbe, ñibe ¿chincha kebarrugu?” cha. Inchen nøbe ke wamguen pinim pasramisrøbig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Inchen reybe tru mishatsigu ashib pønrrabelane trenchiptindan cha: “Srøbwanba, tasiimeranba lusra, wambig purø trømbø løstøyu wegutsay cha. Truyube kishib, trugulmeran tsatsamig kønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kaguende wamiiløbe truba nu køben, lawa wesruiløbe mamdø køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Øyeelø chab puraiben, fariseosmerabe nøørø mendamisra, nømdø waminchibelø køn, Jesúswan chigøben payen, kalø løtøbene, kebenøsrkønrrab cha. ");
INSERT INTO gum_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Inchabe møilan køsrøn nømui mendig amøñibelanba, Herodesweingateelanba øyah chinrrai ørøbelø køn: —Kusrennøbig, ñibe ciertonigwan waminchib møg, Tius maig amøñinrrai karuigwan, isa kømø, trunun treeg kusrenanøb, katø misag maig chitanmaptø mørøb pasrømíig kui ashibelø ker cha. Kaguende ñibe mundøgucha nømun mailø køtasha kandarøtø imøwei inchibig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Ñune maig købsruerah? cha, namun eshkarra chibelø køn. ¿Tru Romasrø maya misagwan karub wabigwan nam an pagaramig merig køh, kabe merømuig køh, chinderah?— chinrrai. ");
INSERT INTO gum_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Inchen Jesúsbe nømun ka kaig martraptø isua inchib pønrrain kui ashabe, trenchibig køn: —Ñim palatø tabelø, ¿nane chindimbarre kebenøsrkønrrab inchigue? cha. ");
INSERT INTO gum_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tru pagaram anwan eshkarra— chibig køn. Inchen nømbe kan an srua amrruben, ");
INSERT INTO gum_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesúsbe trencha payibig køn: —¿I anyu maløba, i munchi pøriibabe muin køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Inchene nømbe trenchibelø køn: —Tru Césarwein køn— cha. Inchene Jesúsbe trenchiptinchibig køn: —Inchawei Césarwein købene, Césarwan tranay cha. Inchen Tiuswein købene, Tiuswan tranay— cha. ");
INSERT INTO gum_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Inchen iigwan mørabe, kwaara asha kørrømisra, nømbe nune pasramnetø, ambuptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tru kwalømdøwei kan møiløgøsrøn saduceosmera Jesúswan ashchab ambubelø køn, truiløbe tru kwabeløbe øsiiramønrrun chibelø kuabe, Jesúswane øyeeg payibelø køn: ");
INSERT INTO gum_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Kusrennøbig, Moisésbe trendaig køn cha: “Møikkøben kan møg urekkaig kwabene, nuneebe tru piudan kasharam nebunrrun cha, tru nuneg kwabigweimburab ureg kørrømartrab.” ");
INSERT INTO gum_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pøs yu namui utuma sieteelø nunelø købig køn cha. Indiibe srøsriibe kasharawa, urekkaig kwawa, srawane nunewan kørrømaran cha. ");
INSERT INTO gum_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Katø tru wendø nunewan treetøweim puraiben, katø tru wendau nunewan treetøweim puraiben, sieteelanba treetø treetø puraibig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yandø srabebe tru ishukkucha kwan cha. ");
INSERT INTO gum_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Pøs treeg købene, tru kwabelø katø øsiirabene, tru maya nunelø tru ishuwan kasharaig kuig køppe, nøbe sieteelai utu møigwei srain kønrrerah?— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Inchen Jesúsbe trencha løtabig køn: —Ñimbe mandø kuinguen mørmøwa, pella pønrran cha, kaguende Tiuswei wamwan pørigwan lata, Tiuswei maramburab marøbigwan lata nebua ashmeelø kua. ");
INSERT INTO gum_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kaguende kwailø katøyug øsiirappe, kasharamøwei, kasharanrrab kømøwein kønrrun cha. Treeg kømøtø, srømbalasrø ángelesmera latailøtøwein kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Inchen tru kwailø øsiiranrrun taigweimburappe, ¿ñimgan lemeelø køtirru? cha, Tius nøtøwei øyah taigwan: ");
INSERT INTO gum_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nabe Abrahamwei Tius, Isaacwei Tius, Jacobwei Tius kur” cha, trendaigwan. Inchawei Tiusbe kwailai Tius kømøtø, øsiguelai Tius køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Inchen misag truba nu pasrabiibe iigwan mørabe, Jesús kusrenanigwan ke kwaara asha kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseosmera tru saduceosmeran Jesús niløtø pønrram wamindin kui wammørabe, tulundzuna, ");
INSERT INTO gum_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","kan møikkøsrøn tru maig maramigwan martrai Moisés pørigwan kusrenanøbiibe Jesús kalø løtøbene kebenøsrkønrrab isua, trencha payibig køn: ");
INSERT INTO gum_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Kusrennøbig, ¿maig maramigwan martrai Moisés pørigu karua pønsrailø, mas nuibe møig køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Inchen Jesúsbe trenchibig køn: —“Señor ñui Tiuswane ñui manrraugurri kerrigu newan undaaraitøgaba, kerrigu ñui øsig pasraitøgaba, kerrigu ñui turtøga isumburab isuitøgaba undaaramig køn, chibig køn” cha. ");
INSERT INTO gum_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tru maig maramigwan martrai pønsrailøyu, iimerrig køn cha, trurrigu mas nuibe. ");
INSERT INTO gum_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Inchen tru wendauikkucha treeg lataitøwei chibig køn: “Ñima ñiasiitøwei maig undaguig køppe, ñui mendaigwangucha treetøwei undaaramig køn” cha. ");
INSERT INTO gum_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tru maig maramigwan martrai Moisés pørigu kerrigu pønrrabig lata, Tius maig karuigwan eshkabelø kerrigu kusrenaniilø lata i pagatø maig maramigwan martrai pønsrailøyugurri pølbasra amrrubig køn— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Inchen fariseosmera tulaamba srø purramnetø, ");
INSERT INTO gum_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesúsbe trencha payibig køn: —¿Ñimbe Cristoimburab maig isugue? cha. ¿Mui misagugurri arritamague?— cha. Inchen nømbe trenchibelø køn: —Davidwei misagugurri arrub nusrkain køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Inchen Jesúsbe trenchibig køn: —¿Trube, treeg købene, Davidbe Cristone chindimba Señor tah? cha, nun Espíritu trendingaruben. Kaguende Davidbe trendaig køn: ");
INSERT INTO gum_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Señor Tiusbe tru nai Señorwane trendan cha: “Nai kusrmaygatø wamisr cha, ñui ashig kømui inchib tsalø inchibelan ñi itøbunønrrai ñui srøb umbu na pønsramnegatig.” ");
INSERT INTO gum_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Cristone Davidbe: “Señor” cha, øyeeg wamøbene, trube, ¿mandøgurri Cristobe Davidwei nusrkain kønrrab køh?— chiben, ");
INSERT INTO gum_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","muguen mancha kusrua løtønrrab kaimabelø køn. Incha tru kwalømgurri mugucha chigøben mas payrrab inchimeelø køn. ");
INSERT INTO gum_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Øyeelø chab puraiben, Jesúsbe misaameranba, nui kusrenanøb pera uniilanba trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisés pørigwan kusrenanøbeløba, fariseosmerababe tru Moisés pørigwan øyeeg chibig køn cha eshkab nømui marøb purramibe truig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Inchawei nøm ñimun chi maringaruben, kerrigu møra marøb esegay cha. Inchendø nøm maig marigwane, trunun asha marmønrrigay chibig køn. Kaguende nømbe chigøben tabig martrappe chibendø, peemaytø marøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Incha nømbe tru pørigu mas nemarøb, mutamguenga kwatsiguelø latailø mara, katøganelane kildunyu muta ambub lataitøwei inchai marendø, nømgurrimbe ni tasig-unøtøgaguen kebachig kømui inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Chiwandøgucha marøppe, misaamera ka ashchaindø marøbelø køn, cha. Tiuswei wamwan pørigwan kappaløyu køben, kwalmerayu køben nørriig kena melsra amønamig tab kui inchibelø køn cha, katø u tulurmera yab srølmera melsra amønamiba. ");
INSERT INTO gum_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lincha tabig mabyugucha nørreelø purrainug purø tabigu purrag kui indamba, judíosmera tulundzuni yamerayube purø tab purramdønug purrag kui indamba inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Incha misaamerabe penab yanøb indinug nømune purø tabzhig wamønrrai inchibelø køn cha, trurrigu nømune “Kusrennøbig” cha, wamønrraingue. ");
INSERT INTO gum_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Trune ñimbe “Kusrennøbig” cha, wamønrrai inchimumig køn. Kaguende ñimbe søteeløba nunelø latailø køn. Incha ñimbe kusrennøbiibe kandø tøgar køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Katø ñimbe yu piraube mungucha, “Møskain” chimøtay. Kaguende ñimbe Møskaimbe kandø tøgar køn, truibe srømbalasrø wabig. ");
INSERT INTO gum_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Katø ñimune “Kusrennøbig” cha, wamønrrain kømøwein kui, kaguende ñimuimbe ashibig mas nuibe Cristo, nøtø køn. ");
INSERT INTO gum_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ñimui utu mas nuibe katøganelø karuindiig megamig køn. ");
INSERT INTO gum_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kaguende nøasiitø ‘nuig kurmab’ isubigwane, ka kørig martrun cha. Inchen chigucha kømíig ‘nuig kurmab’ isumíigwane ‘i møøbe si, nuig køn’ taig kønrrun, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ay, ñim waachamera Moisés pørigwan kusrenanøbeløba, fariseosmeraba, palatø tabelø! Srømbalasrø Tius nø ashib karub wainug kebambam yaskabwan katøganelø kebammønrrai kasrøb, ni ñimdøweinguen kebammøwei, ni katøganelø kebambug kui inchen kebambashmøwei inchibelø køn cha ñimbe. ");
INSERT INTO gum_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ay, ñim waachamera Moisés pørigwan kusrenanøbeløba, fariseosmeraba, palatø tabelø! Pøs ñimbe piudasmeran nømui yameran kerrawabe, tabelø misrøb ke ka yandø truba yana Tiuswan waminchibelø køn cha. Øyeekkurri ñimbe møra melamig mas nuigwan utanrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ay, ñim waachamera Moisés pørigwan kusrenanøbeløba, fariseosmeraba, palatø tabelø! Pirau lata, maryu lata munabatsø ambubelø køn cha, kandøguen ñimuingatø purøsrunrrab. Incha yandø ñimuingatø purøsruabe, ñim lataitøguen kømø, purab tabelø chibelø kønrrai mara, truigwane tru managuen kwamø nagu kegutsam unø kønrrai marøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ay, ñim waachamera chigúinguen ashmeelø købendø, katøganelan pera ambubelø! “Møikkøben Tiuswei yawei merrab pasramisra, ‘¡katø! marmø kømø, nabe maramønrrun’ taigwan treeg marmuingucha, ñimbe chigucha kømøn chibelø køn. Inchendø tru Tiuswei yau oro pasrabigwei merrab pasramisra, ‘¡katø! marmø kømø, nabe maramønrrun’ taigwan trenchibig, trube, martrab taigwane nune maramig nebunrrun” cha, trenchibelø køn, ñimbe. ");
INSERT INTO gum_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tontos, chigúinguen ashmeelø! ¿Møimerrig mas nuig kerah? cha. ¿Oroteh? Kabe ¿tru oron Tiusweyasig tabig kønrrai nøørø tarømarøbig, Tiuswei yateh? ");
INSERT INTO gum_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","’Katø ñimbe trenchibelø køn: “Møikkøben, chigøben martrab cha altarwei merrab pasramisra, ‘¡katø! marmø kømø, nabe maramønrrun’ taigwan, marmuingucha, chigønrraamøn cha. Inchendø tru altar pala Tiusweyasig trana pasrigwan truigwei merrab pasramisra, ‘¡katø! marmø kømø, nabe maramønrrun’ taigwane, nune maramitøwei nebunrrun” cha, trenchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Chigúinguen ashmeelø! ¿Mas nuibe chigø? ¿Tiuswan traniiteh? Kabe ¿tru Tiusweyasig tranigwan tabig kønrrai nøørø tarømarøbig, tru altarteh? ");
INSERT INTO gum_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Altar merrab pasramisra, ‘¡katø! marmø kømø, nabe maramønrrun’ chibiibe, altarwandø ke treeg maramønrrun chimøtø, tru pala chi pønrrabigwangucha kerriguba treeg maramønrrun cha, tøga trendan cha. ");
INSERT INTO gum_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tiuswei yawei munchiyu ‘¡katø! marmø kømø, nabe maramønrrun’ chibiibe, tru yawandø kømøtø, Tius truyu pasrabigwangucha tøga trenchib pasran cha. ");
INSERT INTO gum_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Inchen srømbalawei munchiyu ‘¡katø! marmø kømø, nabe maramønrrun’ chibiibe, purø tabzhig Tius wamisra waigwanba, katø tru tabzhigu wamisra wabigwanba tøga trencha pasran chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ay, ñim waachamera, Moisés pørigwan kusrenanøbeløba, fariseosmeraba, palatø tabelø! Ñimbe erbabunanba, aniswanba, cominoswanba, truilane Tiusweyasig diezmørig kanzhig, kanzhig wesrawa tranøbelø køn cha. Inchendø tru maig maramigwan martrai Moisés pørigu kusrennøbig mas nørreelø pønrrabigwane marmø, pinab amban cha, tru sølgandø tabig maramigwanba, lastima ashibelø kømigwanba, isubigwan Tiusweinug pasra tøgagømigwanba. Ñimbe marøppe, iilanwei maramig kuig køn cha, tru diezmørig kan kan wesrawa Tiuswan tranamigwangucha pesannamø, tøgatø marøb. ");
INSERT INTO gum_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ñim chigúinguen ashmeelø købendø, katøganelan pera ambubelø! Pøløm-unøzhigwane tøga muchimønrrab larruusra muchendø, camellone kebinab pinan cha. ");
INSERT INTO gum_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ay, ñim waachamera Moisés pørigwan kusrenanøbeløba, fariseosmeraba, palatø tabelø! Pasunba, platillonba wambiimaybe pillmabendø, ñimui umbube ñimbe misagwan kwaarøsra kerranrrab isuiløba, chigurrimbunø tøgagønrrab parø isuiløba, trutø netsailø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo chigúinguen ashmíig! Pasun umbumaymerrig chish mar cha, wambiimaygucha chishig kørrømisrtrai. ");
INSERT INTO gum_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ay, ñim waachamera Moisés pørigwan kusrenanøbeløba, fariseosmeraba, palatø tabelø! Kwaig sørin trabmera wambiimaybe puløzhig pisig latailø tabzhig latailø købendø, umbumaybe kwabelain tsutsiimerabah, chigøben køsøngønrraptiibatø netsailø, ñimbe tre latailø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ñimbe øyeeg latailø køn: Misaamerai merrappe sølgandø tabelø lataig asønabendø, wambiimay maig køben treegwein kømøtø, umbumaybe isatø tabig lataig indiiløbah, larrø kaibatø netsailø køn cha ñimbe. ");
INSERT INTO gum_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ay, ñim waachamera Moisés pørigwan kusrenanøbeløba, fariseosmeraba, palatø tabelø! Tius maig karuigwan eshkabelai søriiløyu ñimbe tamara pønsrøb, sølgandø tabig amøñibelan sørim pala tabzhig tamarøb inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Inchabe ñimbe trenchibelø køn: “Namui merrabsreelø warab uras nam warabelø kuig kuimbe, Tius maig karuigwan eshkabelan kweechib ani lushib nømba tøgatø marøb pønrrømubsrubrainrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pøs øyeeg taikkurri ñimbe Tius maig karuigwan eshkabelan kweechibelainukkurri amrrub misaamera ker cha ñimdøweinguen wamindan cha. ");
INSERT INTO gum_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inchawei ñimui merrabsreelø pølbasra marig købigwane, trube, ñimbe patsøga pasray chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Ulmera latailø, ñim namig ulmera latailainukkurri karrab misaamera! Inchawei ñimbe tru møra melamnug kebusriilø kømønrrab ¿chincha wegørrønrrague? cha. ");
INSERT INTO gum_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Inchawei asay chibig køn. Nabe Tius maig karuigwan eshkabelø køben, nørrø kusrebelø køben, Moisés pørigwan kusrennøbelø køben ñimuimay øren, møilan køben ñimbe truilane kweechib, kurusyu melsrøb inchun cha. Katø judíosmera tulundzuni yamerayu maig købash marøb ichabetab, pueblosmørig chu amben, chu amben, ñimbe pasraørøb wendautø amrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Øyeekkurri tru sølgandø tabig amøñibelan kweetsiilai ani mayamba pirau lusiibe ñimuim pala kønrrun cha, tru Abel sølgandø tabigwei ani lusikkurrimbunø, Berequíaswei nusrkai Zacarías tru altarba, santuarioba pønrrabnug, tru tøbøtag pasrøben, ñim kweecha, truigwei ani lusigwangatig. ");
INSERT INTO gum_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pøs nabe ñimun cierton trendamønrrun: Kerrigu øyeeg marikkurri Tiusbe møi ya misagwan ulø payrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén! ¡Jerusalén! ¡Tius maig karuigwan eshkabelan kweechibig, katø ñimuyasig Tius karua øriilan sruutøga petabig! ¡Nabe yamba, kan piejetø kømø, kan atøwall nui pullichu-uregwan kwaldzarig umbu kanbalatø mara, maatanab lataitøwei ñui uregwan tulundzunønrrab inchen, ñibe nane kaasig køn! cha. ");
INSERT INTO gum_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Au, ñim waraig yamerabe elatsig muguchagaig kørrømisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kaguende nabe trendamønrrun chibig køn: Nane katøbe mas ashchaamøn cha, øya tamnegatig: “¡Señorwei munchiyu nø ørig arrubiibe mayanguen tab kuig køn!” cha.— ");
INSERT INTO gum_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Tiuswei yaugurri webya iben, nui kusrenanøb pera uniiløbe nun kemallibelø køn, tru Tiuswei yau yameran eshkanrrab. ");
INSERT INTO gum_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Inchene Jesúsbe nømune trenchibig køn: —¿Iilan kerrigu ashke? cha. Pøs nabe ñimun cierton trendamønrrun cha: Yube ni kan srukken katøgan srug palabe kørrømisrmønrrun cha. Kerriguba pøtiitsig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Incha Jesús Olivos Tunsrø wabene, nui kusrenanøb pera uniiløbe nundø nøørø trencha payrrab kemallabe trenchibelø køn: —Øyeebe mana purainrrab kui namun eshkarra cha. Katø ñi katøle arrumigwanba, yandø srabe kwaløm punrrabigwanba asamibe ¿chitø kenamisrtrerah?— cha. ");
INSERT INTO gum_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Inchene Jesúsbe trencha løtabig køn: —Ashiptø kuy cha, mugøben ñimun peløsrkønrrain kømø. ");
INSERT INTO gum_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kaguende møiløgøben nai munchiyu truba nu amrrua trenchinrrun cha: “Nabe Cristo kur” chib. Trumay misaameran isa wamincha, truba nu peløsrkønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Incha ‘misaamera katøgan peesrø misaameraba purø trømbøig kørig kømdiig kwayab kweetsiyab køn’ chib, katø ‘purø trømbøig kørig kømdiig kwayanrrab køn’ chib ñim wamindi mørabe, mandøguen kømui inchib kwarmøtay cha. Kaguende øyeebe trendø treeg purainrrabigwein køn cha. Inchendø katøgucha patsamibe pumø srø kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Peg misaamerabe katøgan peg misaameraba kwayaben, katø rey karumburab ashib karuim piraueløbe katøgan reywei misaameraba kwayanrrun cha. Trune parø arruben, chusrøn køben pirø trømbøig kønønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Inchendø kerrigu øyeeg pureb arrubiibe kan ishuwan unø tammisrtrab pusrkwab pølbasri lataitø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Inchen ñimune maig købash inchib kaig marøb srua kønrrai tranen, ñimune kwetchun. Katø chu pirauelø køben maya misaamerabe nagurrindø ñimun tsalø asiilø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Inchen tru kwalømmerawane møiløgøben truba nu nan tarømisra, kangurrin kangurri tsalø inchibelai tasku pønsrøb, kangurrin kangurri ashig kømui indiyab inchun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","‘Tius maig karuigwan eshkabelø ker’ chib isatø eshkabelø truba truba kurra, isatø misagwan truba nu peløsrkønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kaibe purø trømbøig larrøbichib arruptø, misaamerabe kerrigu lutau kangurrin kangurri katøganelan isua undaaramigwane yandø isumønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Inchen srabe kwalømgatig chigúingucha megabig megabiibe kebeñchabig kømíig kaigyugurri wesraig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tius nø ashib karub waigwei tabig srø wambe yu pirau pirø muba kuimburab chi misaamerandøgucha eshkab kusrenanig kønrrun, chigúi nebua ashchai misaamera. Inchen yandø srabe kwaløm punrrun chibig køn ");
INSERT INTO gum_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Inchawei Tius maig karuigwan eshkabig Daniel wamindig tru pinishinrrabig trømbøig køsøngønrraptiig Tiusweyasiitø marinug marøb pasramisrin kui ashabe, (lebiibe iigwan tab chigúi mør), ");
INSERT INTO gum_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","yandø treeg pubene, Judea pirau warabeløbe tunmerasrømay wegørra lulay. ");
INSERT INTO gum_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Katø nui ya pala wambig wabiibe kørraarrua chigucha wesranrrab kebimumig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Katø chugøben trausrø uñibiibe nui itøtsinigwan tranrrab arrumumig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ishumbur waachamera, tru kwalømmerawan patsø kwanrreelø, kabe muchib ureg tøgarmeraimbe maig kønrrer! chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ñimbe Tiuswan miay cha, pishin kwalømmerawan wegørra lulamig nebumøwei, katø isrin kwaløm nebumøwei inchain cha. ");
INSERT INTO gum_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kaguende tru kwalømmerawane purø trømbøig nebuinab melamig attrun. Pirøwan pølbasra marøb uraskurri møingatig øyeebe kaagúig, katøbe managuen øyeebe kaanrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tius tru kwalømmerawan landøranmuisruandøbe, mugucha øsig waramgaig kønrrun cha. Inchendø tru nuyasiitø tarømariiløgurri landøranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Incha møikkøben ñimun: “Au, Cristo yu pasran” chib, kabe: “Au, Cristo uyu pasran”, taingucha, køremøtay. ");
INSERT INTO gum_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaguende møiløgøben ‘Cristo ker’ chib isatø inchibeløba, katø, ‘Tius maig karuigwan eshkabelø ker’ chib isatø inchibeløba amrrunrrun cha. Incha nømui maramburab mariilø truba nørreelø asha kømig kenamariiløba, kwaara asha kønrrai nørreelø mariiløba martrun cha, misagwan treeg incha peløsrkønrrab. Incha Tius nuyasiitø tarømariilanguen kegørrøsrkamdiig kuimbe, kegørrøskønrrab inchun. ");
INSERT INTO gum_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Au, nabe ñimune øyeelø puraimøwatø chab eshkar. ");
INSERT INTO gum_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Inchawei ñimun møikkøben: “Au, øsrø mu misag warab waraimønug pasran” chibene, ashchab webammøtay cha. Kabe: “Yu yaambusrø wan”, taingucha, køremøtay cha. ");
INSERT INTO gum_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kaguende kan palaig pilabig wagurri walli umbusrø kebilab lataitøwei, tru Møg Misra Arrubig arruppe, treeg attrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kwaig chu tsubene, truyube kallinasumera tulundzunønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Inchen tru treeg isumdø kwalømmera chab puraiben latatø, nøsiibe yandø kwaben, pølbe yandø pilømuben, estrellamerabe srømbalasrøngurri kørrøben, katø srømbalasrø purø nørreelø pønrrabelane kønøgøb sruagutsiilø kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","’Inchen Møg Misra Arrubig tru arrumigwan eshkabig srømbalasrø kenamisren, chu pirausrøn køben misag nørrø pønrrabelø truba truba isub kishchun cha. Inchen Møg Misra Arrubiibe maramburab maramig tøgaig srømbalasrøngurri purø nuig tørguegwalmabig wañiyu arruben ashchab køn, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Inchen trompetan truba mur urrøben, nøbe nui ángelesmeran amrrai ørtrun chibig køn, ambugurri, igurri, walligurri, wagurri, srømbalasrø kandarømaysrøngurri katøgandarømaysrøngatig nui lawa wesruilan kanbalatø tulishinrrai. ");
INSERT INTO gum_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Kan higuera tusrwanma asha kusrey. Nui srarmera uturcheelø misrøb, ishiimera weguchene, ñimbe pachig kwalømmera arrumig yandø lutau kui ashibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Øyeetøwei ñim kerrigu iilan ashabe, attrabiibe attrab yaskabuguen pasraitamab isua kuy, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pøs nabe ñimun cierton trendamønrrun: Møin kwaløm misaamera pinømøwatø, øyeeløbe kerrigu purainrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Srømbalaba, pirøbabe patsøben, na wamindiibe ka wamindiitøbe purainrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Inchen tru treeg punrrab kwalømwanba, uranbabe mugucha ashmøn cha. Srømbalasrø ángelesmeraguen ashmøwei, ni Tiuswei Nusrkai ashmøwei indan cha. Trunun ashippe, Møskaindøwei asan chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noé tsub kwalømmerawan maig purayaibe tru Møg Misra Arrubig katø arrum kwalømgucha treetøwei purainrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kaguende tru kwalømmerawan sre puben pi pulabig attrab srø købenbatø, tru urasma misaamerabe mab, muchib, kasharab, kasharanøb waraig købig køn cha, Noé nui truba nu barcoyu kebyam kwalømgatikke. ");
INSERT INTO gum_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Incha treeg pumnegatig øyeeg kønrraitamab isumø warøbenba tru pi pulab arrubiibe maya misagwan patsø srua yaig købig køn cha. Øyeetøwei purainrrun chibig køn, tru Møg Misra Arrubikkucha katøle arruben. ");
INSERT INTO gum_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Incha tru uras pailø møguelø trau warøben, kanune srua iben, kanune kørrømarig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pailø ishumburmera kitsøsrugu kichib køben, kanune srua iben, kanune kørrømarig kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ñimbe pesannamø, isua, ashiptø kuy. Kaguende ñimui Señor chi kwaløm attrab kui ashmøwa køn. ");
INSERT INTO gum_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Trube, treeg købene, iigwan isua kuy, kan ya puaima niliig yem chu uras attrab kui mørimbe, ashib megawa, yau nilønrrab kebibashmubsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Inchawei ñimgucha tamara melay chibig køn. Kaguende tru Møg Misra Arrubiibe chi isumø købenba arruptinchun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Kan karuindiig megabig maig taigwan møra marøb, katø chi maramelan nøtø tsabø asha marøbigwan, ya puaig nui yau warabelan mannam ura puin kuindø nømui mamigwan srøttrab muniitø wabig kønrrai ashai wanninabiibe ¿møig kerah? cha. ");
INSERT INTO gum_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Truibe mayanguen tab kuig køn nun karua pasrigwan marøb megabenh ya puaig puptindinabigweimbe. ");
INSERT INTO gum_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pøs nabe ñimun cierton trendamønrrun: Ya puaibe nui chi tøgagúigwan kerrigu nø asha marøb pasrønrrai tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Inchen karuindiig megabig larrø kaibe nuinetø treeg isubig køn: “Nai ashib karubiibe peguen attraamøn” cha. ");
INSERT INTO gum_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Katøgan karuindiig melabelan kurrabetab menda, katø mutsigueløba mab, muchib, tsubenba, ");
INSERT INTO gum_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nui ya puaibe ni attraitamab isuinguen kømø kwaløm, ni ø uras punrraitamab isumø tsubenba, puptincha, ");
INSERT INTO gum_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","purø trømbøig ichagucha, palatø tabelø pønrrainug kertrun cha. Truyube kishib, trugulwan tsatsamig kønrrun chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Srømbalasrø Tius nø ashib karub waibe øyeeg lataig kønrrun: Diez srusralmera mu møøba kimeelø aceite lámparameran piløga muta, tru keg misrtrabigwan linchab katønrrab webambubelø lataikke. ");
INSERT INTO gum_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Truilø tru trattrøgatøbe ni chiguen tre isumeelø køben, katøgan trattrøgatøbe tamara isuatø muniitø melabeløgue. ");
INSERT INTO gum_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tru trattrøgatø chi tre isumeeløbe lámparamerane srua ambendø, aceitebe srua ammuin købig køn, tru patsøben katø usramig. ");
INSERT INTO gum_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Trune tru isuptø melabeløbe lámparamerayu usriilø kømnetø, katø usramig nøørø køtsø-ureezhigu srua ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Inchen tru keg misrtrabig peguen arrumubene, nømune søteelanba yandø ki kanaben, søteeløba kiptindin købig køn. ");
INSERT INTO gum_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Inchen yem tøbøtasrømbe trenchib trasay møran: “¡Keg misrtrabiibe yu arrun cha. Katønrrab amrrab werruy!” chib. ");
INSERT INTO gum_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Inchen søteeløba tru srusralmerabe kurra, nømui lámparameran tamarøb mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Inchen tru trattrøgatø tre isumeeløbe, tru trattrøgatø isuatø melabelane trenchibelø køn cha: “Ñimui aceiten kuchi namun ketøbsrumugu cha, namui lámparamerabe ke chab kwab amrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Inchen tru srusralmera tamara isuatø melabeløbe trencha løtabelø køn: “Kaimaysruandøbe cha. Kaguende ñimui lata namui lata nebunrraamøn cha. Trembe yanøbelaisrø penønrrab ambay chibelø køn, ñimuyasiitøwei.” ");
INSERT INTO gum_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Inchen tru trattrøgatø srusralmera aceiten penønrrab ambamnetø tru keg misrtrabiibe puptinchen, tru trattrøgatø isuatø melabeløbe keg misrtrabiiba kasharab fiestayumay kebamben, yandø yaskabwan kasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","’Inchen yana wendau tru kan srusralmeragucha trenchib pubelø køn: “¡Señor, Señor, namun yaskabwan kurtra!” chib. ");
INSERT INTO gum_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Inchen nøbe trencha løtabig køn: “Pøs nabe isa kømø, ñimune mumera kui ashmíig kur” cha. ");
INSERT INTO gum_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Inchawei ñimbe pesannamø, ashiptø melay chibig køn Jesúsbe. Kaguende tru Møg Misra Arrubig arrumigwane ñimbe chi kwaløm attrab kui mørmøwei, ni chu uras attrab kui mørmøwei indan cha. ");
INSERT INTO gum_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Tius nø ashib karub waibe øyeeg lataig køn cha: Kan møg yabsrømay inrrab, nui karuindiig melabelan wama, nui chi tøgagúilan asha marøb kønrrai trana ib lataikke. ");
INSERT INTO gum_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kan møigwan køsrønbe an trattrø mil tranøppe, møigwan køsrønbe pa mil, møigwan køsrømbe milgue, møigwandøgucha nøm maig martrapteelø køben treeg trana, yandø inrrab yan cha. ");
INSERT INTO gum_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tru karuindiig megabig an trattrø mil utabiibe trutøga penab, yanøb incha, katøgan trattrø mil nemaran cha. ");
INSERT INTO gum_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Inchen katø tru pa milwan utabikkucha katøgan pa mil nemaran cha. ");
INSERT INTO gum_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Inchen tru milwan utabiibe pirau kan trab lalla, tru an tranøbigwei anwane truyu søraptindan cha. ");
INSERT INTO gum_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Indiibe yandø truba yana misrøb iben, tru karuindiig melabelan treeg marøb melønrrai karua pasrøbiibe katø arrua, nøm chitø maritashchab wamisra ashib mendan cha. ");
INSERT INTO gum_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Inchen tru an trattrø mil utabig puabe, trendan cha: “Nai ashib karubig, ñibe nan trattrø mil tranig kømøh cha. Møimbe tru kømnetø nabe katøgan trattrø mil nemara, yu srua arrur” tan cha. ");
INSERT INTO gum_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Inchen truibe trendan cha: “Øyambesin cha, ñi nai karuindiig megabig tabig, chi isumgaig maig maramigwan marøbig. Ñi lamøtiigwanma chi isumgaig øya søl mariibe, mas nuwan martrai pasrtrumøn tan chibig køn. Incha kebarrua, naba truba kasraarau” tan cha. ");
INSERT INTO gum_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Inchen tru karuindiig megabig pa mil utabiibe trendan cha: “Nai ashib karubig, ñi nan pa mil tranig kømøh cha. Møimbe katøgan pa mil nemara, yu tøgagur” tan cha. ");
INSERT INTO gum_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Inchen tru an tranøbiibe trendan cha: “Øyambesin cha, ñi nai karuindiig megabig tabig, chi isumgaig maig maramigwan marøbig. Ñi lamøtiigwanma chi isumgaig øya søl mariibe, mas nuwan martrai pasramønrrun cha, trendan cha. Kebarrua, incha naba truba kasraarau” tan chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Inchen tru mendig megabig tru milwan utabiibe trendan cha: “Nai ashib karubig, ñibe ñiashib ellgwaig kømubendø, ellmarigwan tulishib, ñiashib tsurig kømubendø, parøb, katø ñibe chiwandøgucha chi chippe, ke kandø chibig kui nabe ashibig kuabe, treekkurri nane kørig køben, ");
INSERT INTO gum_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ñui anwan srua ya, pirau sørig køn cha. Inchendø ñui anwan utørra” tan chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Inchene nui ashib karubiibe trendan cha: “Karuindiig megabig larrø kaig, trurrigu pøig køn cha. Pøs naashib ellgwainug kømubendø, ellmarigwan tulishib, naashib tsurinug kømubendø, parøb inchibig kui ashabe, ");
INSERT INTO gum_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","trube, maindi nai anwan bancoyu an utabelan pastrai tranamdiigwan tan chibig køn, na katøle arrua, nai anwan nemisrigwanbañau utamig kønrrain cha. ");
INSERT INTO gum_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Inchawei, nai anwan kerrawa, tru an diez mil tøgaigwan tranay tan. ");
INSERT INTO gum_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kaguende tøgaigwane masken tranen, uñchaguen tøgagønrrun cha. Inchen chigaigwane nui lamøtiig tøgagúigwanguen kerranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Incha i karuindiig megabig chigucha chi marmíigwane wambig purø trømbø løstøyu wegutsay tan chibig køn. Truyube kishib, trugulwan tsatsamig kønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Møg Misra Arrubig nui tørguegwalmabigu tru maya ángelesmeraba arrua, wamisra nui ashib karub waig tørguegwalmabigu wamisrtrun. ");
INSERT INTO gum_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Inchen yu pirau chi misaameratøgucha nui merrab tulundzunøben, nøbe nøørø, nøørø tarømartrun cha, kan ubisha ashibig ubishameranba, kabrameranba nøørø, nøørø tarømarøb lataitøweingue. ");
INSERT INTO gum_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Incha ubishamerane kusrmay pønsrøppe, kabramerane atsimay pønsrønrrun. ");
INSERT INTO gum_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Incha Reybe tru kusrmay pønrrabelane trenchinrrun: “Nai Møskai ñimun mayanguen tab indiiløbe naimay amrruy cha. Incha Tius pirøwan marøb uraskurri ñimuyasig tamarig pasrabig tru ashib karub wainuguigwan ñimuyasig utay chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kaguende na parøgwai uñen, ñimbe na manrrai nan srørrig køn cha. Na pi mulgwai inchen, ñimbe pi mutchai srørrig køn cha. Na arruatiig chugucha pumikkaig uñen, ñimbe tab wamab, ya pebøb indig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Asru chi kemig chigaig uñen, ñimbe nan tranig køn cha. Na kwanrrø tsuben, nan ñimbe ashchab amrruig køn cha. Kailan keeri yau na pasrøben, nan ñimbe neshchab amrruig køn” chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Inchen tru sølgandø tabig marøbeløbe trenchib løtab pønrrønrrun cha: “Señor, ¿ñi parøgwai uñen, nambe mana mamig srørrøb, katø ñi pi mulgwai indi ashabe, nambe pi mutchai mana srørrig køh? cha. ");
INSERT INTO gum_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Arruatiig chugucha pumikkaig uñen, nambe ñune tab wamab mana ya pebig køh? cha. ¿Asru kemig palai uñene, nambe mana tranig køh? cha. ");
INSERT INTO gum_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kabe ¿kwanrrø tsuben kui, kailan keeri yau keerig pasrøben kui, nambe mana neshchab amrrubrah?” chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Inchen Reybe trencha løtønrrun cha: “Pøs nabe ñimun cierton trendamønrrun cha: I nai nunelan chigucha kømøzheelø latailan mariibe, nan marig køn” cha. ");
INSERT INTO gum_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Incha katø atsimay pønrrabelangucha Reybe trenchinrrun cha: “Ñimbe nainukkurri tarømisray cha; kaigyu pønrrønrrai pønsrailøbe, nugwaimandzigweimba, nui ángelesweimba tru managuen kwamø nag tamarig pasrabigumay ambay cha. ");
INSERT INTO gum_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na parøgwai uñen, ñimbe mamig srørrmuig køn cha. Pi mulgwai inchen, pi mutchai srørrmøwei indig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na arruatiig chugucha pumikkaig uñen, tab wamab nan ya pebmuig køn cha. Asru chi kemikkaig uñen, ñimbe nan tranmuig køn cha. Na kwanrrø tsub, katø kailan keeri yau na pasrab inchen, ashchab amrrumuig køn” chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Inchen nømbe trenchib pønrrønrrun cha: “Señor, ñune parøgwai uni ashib, pi mulgwai uni ashib, kabe chugucha pumikkaig uni ashib, asru chi kemikkaig uni ashib, kabe kwanrrø tsui ashib, kailan keeri yau pasrai ashib inchendø, ¿namgan ñun purugumuig kuitarru?” chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Inchen Reybe trencha løtønrrun chibig køn: “Pøs, nabe ñimun cierton trendamønrrun cha: I nai nunelan chigucha kømøzheelø latailan ñim chigucha marmuibe, nan treeg marmuig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iiløbe managatig purø trømbøig møra melamnuumay tarømisra amrrun cha. Inchen tru sølgandø tabeløbe managatig øsig purramsrømay amrrun” chinrrun— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús iilan kerrigu chab waminchabe nui kusrenanøb pera uniilan trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ñimguen ashen pa kwalømyube Pascua Fiestan martrab køn cha. Inchen tru Møg Misra Arrubiibe kurusyu mesraig kønrrai tranig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Inchen tru urastøwei sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba Caifás, tru maya sacerdotesmeran nø karub sacerdotei palacioyu tulundzunabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Incha Jesúswan chinchagøben tammaytø chi isa køben kemøra, kwetchab waminchendø, ");
INSERT INTO gum_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","trenchibelø køn: —Fiesta utu marmønrrab cha, misaamera ke chindi asamgaig inchimønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betaniasrø tru Simón leproso taigwei yau Jesús wabene, ");
INSERT INTO gum_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kan ishug alabastro limetayu truba may irrabig netsiig truba nuweyigwan srua, kemalla, Jesús mishatsigu wamnetø, tru may irrabigwan tur pala itølushibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Inchen nui kusrenanøb pera uniiløbe ashabe, ishuwan trenchib namabelø køn: —¿Ke ka yandøbe iigwane chinchabrre lushibig køh? cha. ");
INSERT INTO gum_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Waachameran purugumig purø nuwei yanøbsruinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Inchen Jesús wetøbeñabe, trenchibig køn: —¿Ishuwane chi chibrren purrøgue? cha. Pøs iig nan mariibe truba tabig maran chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kaguende waachamerane chu uragucha ñimui utu tøgagønrrun cha. Trune nane treeg kønrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ishug tru may irrabigwan nan asru itølusiibe nan søramigweyasig tamaran cha. ");
INSERT INTO gum_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pøs nabe ñimun cierton trendamønrrun: Yu pirau chutøgucha Tiuswei tabig srø wam kaigyugurri wesrabigwan eshkab kusrenaniisrømbe tru nø marigwangucha tøga waminchun cha, nun pesannamø, isuig kønrrain— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas, tru Iscariote taig, Jesús doce kusrenanøb pera uniilai utuig, sacerdotesmeran karubelan ashchab yabe, ");
INSERT INTO gum_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","trenchibig køn: —¿Jesúswan ñimui tasku tranene, nane chi tranrrunrrague?— cha. Inchen nømbe an treinta tranøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Inchen tru uraskurri Judasbe Jesúswan mandø incha tranamigwan yandø lab mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tru Pirri Levaduragaig Maig Fiesta pølbasrøb kwaløm Jesúswei kusrenanøb pera uniilø nun kemallabe, trencha payibelø køn: —¿Pascua mamigwan ñuimbe nambe chu tamaramø?— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Inchene nøbe trenchibig køn: —Ciudayu kan møweimay ambabe trenchinrrigay cha: “Kusrennøbiibe trendan cha: ‘Nai urabe yandø puin køn’ cha. ‘Pascua maramigwan nai kusrenanøb pera uniiløba ñui yau martrab’ tan”— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Inchen nui kusrenanøb pera uniiløbe Jesús maig karuigwan mara, tru Pascuan tamarøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Inchen yandø yem køben, nui kusrenanøb pera uniiløba mishatsigu wawa, ");
INSERT INTO gum_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","mab wappe, trenchibig køn: —Pøs nabe ñimun trendamønrrun cha: Ñim møikkøsrøn nan ashig kømui inchibelaingatø misra, nan trannrrab køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Inchen nømbe truba truba isui incha, kan kan nun payib mendabelø køn: —¿Señor, kabe na købra chinderah?— chib. ");
INSERT INTO gum_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Inchen Jesúsbe trencha løtabig køn: —Kan møikkøsrøn pirriwan i nindagutøwei naba kebishibig, truig nan ashig kømui inchibelaingatø misra, trannrrautan cha. ");
INSERT INTO gum_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tru Møg Misra Arrubiibe Tiuswei wamwan pørigu maig pørig pasrøben, truwan pureb iben, trune ¡tru møg waacha! tru Møg Misra Arrubigwan ashig kømui inchibelan trannrrabigweimburappe, yeekkucha kuita chibig køn, trembe truibe kal-lamuig kuinguen søl købsruinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Inchen tru Judas, tru ashig kømui inchibelaingatø misra trannrrabiibe: —¿Kusrennøbig, kabe na købra chinderah?— cha payene, Jesúsbe: —Ñibe sølwein tan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Incha mab purrappatø, Jesúsbe pirriwan muta, Tiuswan ‘mayanguen pay’ cha, pirisha, nui kusrenanøb pera uniilan trenchib srørrøbig køn: —Cha, may cha. Iibe nai asr køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Incha katø copan muta, Tiuswan ‘mayanguen pay’ cha, nømun trenchib purøørøbig køn: —Søteeløba i copayuigwan mutsay cha. ");
INSERT INTO gum_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kaguende iig, nai animbe, Tius tru misagweyasig srø acuerdon mari anin køn cha. Tru animbe truba nu misagweyasig kaig mariilan ulø paymø pesannaig kønrrai lusig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Incha nabe ñimun trendamønrrun chibig køn: Uvas piwane mas muchimumønrrun cha, nai Møskai nø ashib karub waisrø katøyug ñimba mutsam kwalømgatig.— ");
INSERT INTO gum_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Incha yandø kan himnon chab cantawabe, Olivos Tunsrømay amba, ");
INSERT INTO gum_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesúsbe trenchibig køn: —Ñimbe mayeeløba nagurrindø møi yembe nainug isua pønrraigwan trubishinrrun cha. Kaguende Tiuswei wamwan pørigu øyeeg chibig pørig pasran cha: Ubisha ashibigwan na kweechen, ubishamerabe nøørøtø chab lulrrun, chibig. ");
INSERT INTO gum_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Inchendø nabe katøyug øsiirappe, ñimguen ammøwatø, nabe Galileasrømay yamønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Inchen Pedrobe trenchibig køn: —Mayeeløba ñuinug isua pønrraigwan trubisaingucha, na kuimbe managuen tarømisrmumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Inchen Jesúsbe nune trenchibig køn: —Pøs nabe cierton ñun trendamønrrun cha: Møi yemdøweinguen kallu wamømøwatø, ñibe pønmayguen nan ‘ashmíig kur’ chinrrautan— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Inchen Pedrobe trenchibig køn: —Ñiba nan kwamig nebuinguen, nabe managuen ñun ‘ashmíig kur’ chimumønrrun— cha. Inchen mayeeløba nui kusrenanøb pera uniiløgucha treetøwein chibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Incha Jesúsbe nui kusrenanøb pera uniiløba, kanbalø Getsemaní taisrømay ambabe, trenchibig køn: —Yu purramisray cha, na øsrø nai Møskaimba waminchab yamne.— ");
INSERT INTO gum_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Incha Pedronba, Zebedeowei nusrkalan pailanba pera yabe, truba isui, ni mumayguen tab kømui inchib menda, ");
INSERT INTO gum_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","trenchibig køn: —Nai manrraube isubiitø kwabguen ka kwamdiig køtan cha. Ñimbe yutø kørrømisra, naba ñimgucha kimø, purray— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Incha Jesúsbe katøguchi ambuurø ya, nui maløwan piraugatig kebachib sraløptinchabe, trenchib Tius Møskaimba waminchibig køn: —Nai Møskai, i copan nan tarømartra cha. Inchendø na maig isuig køben, treeg kønrrain kømøtø, ñun maig maramdiig køben, treeg kønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Incha katø nui kusrenanøb pera uniilaimay arrua, kib purrai wetørrawabe, Pedrone trenchibig køn: —¿Kan uratøguen kimø, naba kasrig purrønrrab kaimatirru? cha. ");
INSERT INTO gum_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kimø, Tiusba waminchib purray chibig køn, chiyugøben kaigyu kegørrømønrrappe. Ñimbe tabigwan martrabwei isuingucha, ñimui asrbe kullaguig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Incha katøle Jesús Tius Møskaimba waminchab ya, trenchibig køn: —Nai Møskai, i copan na muchimønrrai tarømaramgaig købene, trube, ñun maig maramdiig køben treeg martra— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Incha katø arruabe, katøguen nui kusrenanøb pera uniilane kiptøweim purrain kui wetørrabig køn, kaguende nømui kabmerabe kigøbiitø ke kanain purrøwa. ");
INSERT INTO gum_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Incha nømun purramnetø katø pønmay kønrrabyu Tius Møskaimba waminchab ya, srøsrø mandø wamindig treetøwein chib waminchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Incha nui kusrenanøb pera uniilaimay arruabe, trenchibig køn: —¿Katøgucha ñimgan israb, kib srø warøtirru? cha. Yandø ura pun cha, tru Møg Misra Arrubigwan kaig marøbelai tasku tranamig. ");
INSERT INTO gum_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Kurray, chibig køn, amrrab! cha. Nan ashig kømui inchibelaingatø pasramisrøbig nan trannrrab arrubguen indan cha. ¡Asay!— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús waminchib pasramne, Judas, tru doce kusrenanøb pera uniilai utuibe truba truba nu misaaba arrubig køn, nømbe espadamera køben, tsiimera køben sruargue. Truiløbe sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba misra, karua øriilø købig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tru Judas Jesúswan ashig kømui inchibelaingatø pasramisrøbiibe nømune: “Merrarramig kuitamab ñim ashchai, na chi siñal køsrøn maren, ashib pønrrønrrigay cha, eshkain købig køn. Tru na muchaig, truig kønrrun cha. Kemørtrigay” cha. ");
INSERT INTO gum_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Incha Judasbe møi møi Jesúsweim pulu kemallib trenchibig køn: —¡Kusrennøbig, yandø yem køn!— cha. Incha muchabene, ");
INSERT INTO gum_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesúsbe trenchibig køn: —Nai trendø lincha uñibig, chi martrab arruabe, mar— cha. Inchen kaneløbe kemalla, Jesúswan kemøra, sruamrrab merrarrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Inchen møikkøsrøn Jesúsba pasrabiibe espadan wesrub, maya sacerdotesmeran nø karub sacerdotei karuindiig megabigwan kaluwan kelarrab lutiichiptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Inchen Jesúsbe trenchibig køn: —Ñui espadane wayinug way cha. Kaguende mutøgucha espadatøga kwayabiibe, espadatøgatøwei kweetsig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ñi isubgan nai Møskawan miamønrraitamatirru cha. Na miabene, nøbe møindøweinguen ángelesmera muguen nebua mundzamgaig ørøbsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pøs treeg købene, Tiuswei wamwan pørigu øyeeg purainrrun taibe, trube, ¿chincha purainrrab kø?— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Incha tru urastø Jesúsbe misaameran payibig køn: —¿Chindimbarre ñimbe espadamera køben, tsiimera køben sruar werrugue cha, nan kemørtrab, nabe kan niliig kui lata? Nabe kwalømmørig Tiuswei yau kusrennøb waben, ñimbe managuen nane kemørmuig køn chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Inchendø iig kerrigu øyeeg nebuppe, Tius maig karuigwan eshkabelø Tiuswei wamwan pørigu maig taig treeg nebunrrain kuig køn— cha. Inchen nui kusrenanøb pera uniiløbe nundø elachippa, mayeeløba chab luløptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Incha Jesúswan merrarrabeløbe tru maya sacerdotesmeran nø karub sacerdote Caifáswei yamay nune srua ambubelø køn, tru Moisés pørigwan kusrenanøbeløba, misagwan karubelø kølli misaameraba tulundzuna pasrainuumay. ");
INSERT INTO gum_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Inchen Pedrobe Jesúswei wendau yaptø, yaptø tru maya sacerdotesmeran nø karub sacerdotei ya wambiisrøngatig ya, umbu kebyabe, tru ashchay pønsraig pønrrabeløba wabig køn maig kørrømisrtashchab ashchab. ");
INSERT INTO gum_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Inchen sacerdotesmeran karubeløba, tru Setenteelø maig maramigwan asha marøbelø mayeeløbabe Jesúswan kwanrrai pasrtrab møilan køben ‘Jesúsbe kaig maren, nambe ashibwei indig køn’ chib isa waminchabelø labendø, ");
INSERT INTO gum_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","wetørranrrab kaimabelø køn, møiløgøben ‘øyeeg køn’ chib, ‘øyeeg marøbig køn’ chib isa waminchibelø, truba werruppe werrubendø. Yandø truinchib køptø, pailø werrua, ");
INSERT INTO gum_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","trenchibelø køn: —I møøbe øyah taig køn cha: “Nabe Tiuswei yawan pøtiicha, pøn kwalømyutø katø mara pasramønrrun”— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Inchen tru maya sacerdotesmeran nø karub sacerdote Caifásbe kurra, Jesúswan payibig køn: —¿Chigucha løtømønrrapteh? cha. ¿Ñune øyeebe chi kalø maran charre inchib køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Inchen trendaingucha, Jesúsbe chigucha løtømuben, tru maya sacerdotesmeran nø karub sacerdotebe trenchibig køn: —Øsig wab Tiuswei munchiyu nabe ñun, ñi Cristo Tiuswei Nusrkain kuabe, ‘truig kur’ cha, namun eshkau tamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Inchene Jesúsbe trencha løtabig køn: —Ñitøweinguen chab trendan cha. Katø nabe ñimune trendamønrrun cha: Møg Misra Arrubiibe tru maramburab marøb Tiuswei kusrmay waben ñim ashib, katø srømbalasrøngurri wañiyu arruben ashib inchun— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Inchen tru maya sacerdotesmeran nø karub sacerdotebe nui kewagúigwandøwei kølsrøb, trenchibig køn: —I møøbe Tiuswane purø trømbøig waman cha. ¿Namun nuimburab waminchabelø mas chiwein kui palønrrab kø? cha. Ñimdøweinguen Tiuswan tru purø trømbøig wamab wamindigwan møran chibig køn. ");
INSERT INTO gum_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Incha ¿ñimune maig asønata?— chiben, nømbe trencha løtabelø køn: —Kaigwein køn cha. Kwabash— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Inchen nømbe malau illimbi itøtutamba, kurramba inchen, katøganeløbe pashaguchib ");
INSERT INTO gum_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","trenchibelø køn: —¡Cristo, mu kurragutsin kui, namun kelarrab eshkau pøs!— chib. ");
INSERT INTO gum_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Inchen Pedrobe ya wambig wabene, kan mendig megabig srusrø kemallabe, trenchibig køn: —Ñigucha galileasriig Jesúsba uñibig kuig kømøh— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Inchen Pedrobe mayeelai merrab ‘ashmíig kur’ chib trenchibig køn: —Ñibe ni chi waminchib pasrainguen mørmur— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Incha yaskabyu Pedro webibene, katøgan srusrø nun ashabe, katøganelan trenchibig køn: —Øikkucha Nazaretsrø Jesúsba uñibig kuig kømøh— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Inchene Pedrobe katøyug: —‘Tiusken ashen, katø nabe isa waminchibgucha pasrømur’ chib, trenchibig køn. Nabe tru møwane ashmíig kur— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Inchen yanayu truyu purrabeløbe Pedron kemallabe, trenchibelø køn: —Isa kømø, ñigucha truilai utuigwein køn cha. Waminchibyutøguen møramdiig waminchibig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Inchen Pedrobe: —‘Na isab pasraig købene, trube, nan chigøben nebunrrappe nebubash chib, Tiusken ashen katø nabe isa waminchibgucha pasrømur chibig køn’. Tru møwane nabe ashmíig kur— chib. Inchen tru urastø kan kallu wamaptinchen, ");
INSERT INTO gum_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedrobe Jesús øyah taig kømørramab isuptinchibig køn: “Kalluguen wamømøwatø, ñibe nan pønmayguen ashmíig kur chinrrun”, taigwan. Incha Pedrobe truyugurri webya, truba truba isuig kishibig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yandø tør-rraben, sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba mayeelø Jesúswan kwetchab treeg martrab kandø isua pønrramisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Inchen nun lusra, srua amba, kubenadur Pilaton tranøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, tru Jesúswan ashig kømui inchibelaingatø pasramisrøbiibe, Jesúswan kwanrrai pasrig kui ashabe, treeg marmumøtømab, truba truba isua, sacerdotesmeran karubelanba, misagwan karubelø kølli misaameranba tru an treintan ");
INSERT INTO gum_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","trenchib katø kebusrøbig køn: —Nabe kaig marar cha, chi kaig marmø møwan kwanrrai tranøb.— Inchene nømbe trencha løtabelø køn: —Øibe ñuimburab køn cha, namune trunune manguaasamø— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Inchene Judasbe anwan Tiuswei yau kebetappa, truyugurri webya yabe, naashigu tsi pasra, megamisrøppa, kwaptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Inchen tru sacerdotesmeran karubeløbe tru anwan tulishabe, trenchibelø køn: —I anbe yandø ani lushaig kaig an køn cha, Tiusweyasig an pusrinuube pusrmønrrai, merig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Incha nømbe tru andøga køtsø marøbigwei tulwan penønrrab cha, treeg martrab kandø isua kørrømisrøbelø køn, tru peesrøngurri amrrub misaameran søramig tøgagønrrab cha. ");
INSERT INTO gum_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Inchawei tru pirøbe møin kwalømgatig “Ani Lusra Tul” cha wamig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Øyamay tru Tius maig karuigwan eshkabig Jeremías øyah taig treeg nebuig køn: “Tru an treinta, tru israelitasmera nune an øya pagaranrrab taig anwan nøm srua pønrramisra, ");
INSERT INTO gum_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","trutøgabe køtsø marøbigwei tulwan penan taig, Señor nan maig karuig køben treeg” taig. ");
INSERT INTO gum_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Incha Jesúsbe yandø kubenadurwei merrab pasrøben, nøbe trencha payibig køn: —¿Ñigan judíosmerai rey køtirru?— cha. Inchen Jesúsbe trenchibig køn: —Ñitøweinguen chab trendan— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Inchen sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba ‘øyeeg køn’ chib, ‘øyeeg marøbig køn’ chib kømne, Jesúsbe chigucha løtømíig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Inchene Pilatobe trencha payibig køn: —¿Ñun chigøben yeeg chib kømne mørmøtirru?— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Inchen Jesúsbe ni chi chib kuingucha manchagucha løtømuben, tru kubenadurbe ‘øyeebe maig kermab’ ke kwaara asha kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tru fiesta kwalømmerawane kubenadurbe kailan keeri yau pønrrabelan misag møigwan elatchai miaben, trendø treeg marøb elachibig købig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Inchen truyu Barrabás taig mayeelø mu kui asig kailan keerig yau pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Inchen tru nøm tulundzuna kømne, Pilatobe trencha payibig køn: —¿Ñimbe møigwan na elatsamig palain køgue cha, Barrabáswandeh, kabe Jesús tru Cristo taigwandeh?— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kaguende Pilatobe Jesúswane uni ashig kømuptø nun tranin kui ashibig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Inchen Pilatobe nø wamisra karub waigu srø wamnetø, nui sraimbe trenchinrrai eshkawa ørøbig køn: “Ñibe ñuimburappe chigucha marmøta cha, ø møwan sølgandø tabigwane. Kaguende mira yem purø trømbøig nan piaig køn cha, ø møkkurrindø.” ");
INSERT INTO gum_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Inchen sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba misaamerane miamne indingarubelø køn, Barrabáswane elatchai miappe, Jesúswane kweetsingarunrrai. ");
INSERT INTO gum_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Incha kubenadurbe katøle payibig køn: —¿Ñimbe i pailan møigwan elatsamig palain køgue?— cha. Inchene nømbe trenchibelø køn: —¡Barrabáswan!— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Inchen Pilatobe trencha payibig køn: —¿Jesús, tru Cristo køn taigwane, nabe mandø indamø?— cha. Inchene mayeeløba: —¡Kurusyu mesraig kønrrain!— chiben, ");
INSERT INTO gum_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatobe trenchibig køn: —¿Chindimba øyeeg martreenchigue? cha. ¿Nøbe chi kalø marig kø?— cha. Inchen nømbe masken mur trashibelø køn: —¡Kurusyu mesraig kønrrain!— chib. ");
INSERT INTO gum_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Inchen Pilatobe mumaygucha yandø chi maramgaig kui asha, trune mas mas trømbøig inchen, pi tranrrab øra, mayeelai malau trenchib tasigwan kinabig køn: —Nabe naimburappe i kwanrrabigweimburappe, chi marig kaagøn cha. Iibe ñimuimburab kønrrun— chib. ");
INSERT INTO gum_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Inchen maya misaabe trencha løtabelø køn: —Nø kwawa ani lusiibe namuimburappa, namui uregweimburappa kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Inchen yandø Pilatobe Barrabáswan ka inrrai elacha, Jesúswane chab ichagutsingaruabe, kurusyu mesrønrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Incha tru kubenadurwei suldaumerabe tru palacioyu Jesúswan mas umbusrø srua amba, maya suldau søtø nuim pøtøgatan tulundzunøben, ");
INSERT INTO gum_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesúswan nui kewagúigwan wesrua, kan keeg kørrabig piguiig kørrabig itøguenanøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Incha kan kaldiig corona mara, petsøsra, kusrmay taskube kan caña tsig trana, nui merrab tømbønsrabe, ka indzatø ashib trenchibelø køn: —¡Judíosmerai Rey, viva!— chib. ");
INSERT INTO gum_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Katø illimbi tutamba, tru cañatøga turbøtø itsamba inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nun øyeeg marøb ka indzatø ashib srua køptø, tru kørrabig kenanigwan wesrawa, nuiwan kenanabe, kurusyu mesrønrrab srua ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Incha truyugurri webamba amben, kan møg Simón taig cirenesriig arrub pasrain køben, tru møwane Jesúswei kuruswan ke mutamne incha mutøsrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Incha kanbalø Gólgota tainug pubelø køn (tru trenchippe, “Calaverasrøn” tainug). ");
INSERT INTO gum_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Incha truyu Jesúswan vinoba, purø trømbø møb piba lindisaigwan mutchai yuuløbelø køn. Inchen Jesúsbe kaizhig muchamørabe, muchimuptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Incha yandø kurusyu chab mesrabe, suldaumerabe Jesúswei kewagúilan mu merrarramig køtashchab suerte kuchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Inchabe truyu chindashchab ashib purrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Inchen nui tur palabe kan pørig mesrøbelø køn, chigurrin kwanrrai mesraig køn cha eshkabig. Truibe trenchibig pørig købig køn: IIBE JUDIOSMERAI TRU REY JESUS KØN chibig. ");
INSERT INTO gum_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Katø pagatø nileelangucha nøba kurusyu melsrøbelø køn, kanun kusrmay, kanune atsimaygue. ");
INSERT INTO gum_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Inchen truwan puraambubeløbe tsalø wamab, turwandø kønøgøb, ");
INSERT INTO gum_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","trenchibelø køn: —¡Ñi tru Tiuswei yawan pøtiicha, katø pøn kwalømyutø kusranrrabiibe ñi kwamønrrab ñitøwei chigøben mar! cha. ¡Tiuswei Nusrkain kuabe, kurusyugurri pinaamø!— chib. ");
INSERT INTO gum_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Incha sacerdotesmeran karubeløba, Moisés pørigwan kusrenanøbeløba, misagwan karubelø kølli misaameraba misra, ka indzatø ashib trenchibelø køn: ");
INSERT INTO gum_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Kanelane kaigyugurri wesrubendø, nøasiitøweimbe kaiman cha. Israel misagwei rey kuabe, møimbe kurusyugurri kørraarrubash cha, treenchene, nambe nun køremønrrun chibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nøbe ¡katø! Tiuswandø isun cha. Trube, Tius nun undaguig kuabe, møimbe nun kwamønrrai marbash cha. Kaguende nøbe: “Tiuswei Nusrkain kur” taig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Inchen nileelø nøba kurusyu melsraig melabeløguen treetøwei nun tøga tsalø wamabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Inchen kwaløm tøbøtakkurri maaben las treskatig pirø ørø kerrigu løstiig kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tre uras Jesúsbe truba mur trashib trenchibig køn: —Elí, Elí ¿lama sabactani?— cha. (Trenchippe, “Nai Tius, nai Tius ¿chindimba nandø elachigu?” chib.) ");
INSERT INTO gum_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Inchen møiløgøsrøn truyu pønrrabelø mørabe, trenchibelø køn: —Øibe Elíaswan wamøtan— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Inchen møi møi nømui utu møikkøsrøn kan ñab esponja lataigwan tranrrab lula, trunun køchiibiyu kebisha, kan caña tsigu pucha, trunun mutchai trig pulusrøngatig nun yuuløbig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Inchene kaneløbe trenchibelø køn: —Kagøbasay cha. Inchippa kwamønrrai pinøsranrrab Elías attashchab— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Inchen Jesús katøle mur trashabe, kwaptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Inchen tru urastø Tiuswei yau tru purø tab llensuzhig kelarrab søtø mesraibe pabaliig misrøb palasrøngurri kørrab kølsrøbig køn. Inchen pirøbe mur kønøben, nørrø sruumerabe pushen, ");
INSERT INTO gum_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","kwabelan sørin trabmerabe kuren inchibig køn. Inchen Tiuswei tarømari misaamera truba nørrø kwabelai asrmeraguen øsiiraig købig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Inchen Jesús kwawa, yandø katø øsiirabene, nømbe tru sørin trabmerayugurri webamba, tru Tiuswei tarømari ciuda Jerusalénsrø kebambubelø køn. Incha misaameran mamdeelandø kømø, kenamisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Inchen tru Roma suldau cienelan nø karubiiba, truyu Jesúswan chindashchab ashib pønrrabelø katøganeløba pirø kønabigwan køben, chine purayaigwan køben ashabe, ¡katø kørig købiitø! ke chinchimmørø inchib trenchibelø køn: —¡Isa kømø, iibe Tiuswei Nusrkain købwei indin køn!— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Inchen truyube ishumburmera truba nu yabsrøngurrindø ashib pønrrabelø køn. Truiløbe Galileasrøngurri Jesúswei mendig amrruar, katø nømbe nun purugub linchibelø købig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Inchen tru ishumburwei utube María Magdalena køben, katø Santiagoimba, Joséweimba usri María køben, katø Zebedeowei nusrkalai usrin køben pønrrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yandø yem misren, kan truba pua møg Arimatea pirausriig José taig pubig køn, truikkucha Jesúswei mendig uñibig købig. ");
INSERT INTO gum_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Truibe Pilatoimay yabe, Jesúswei asrwan miaben, Pilatobe truigwan traningarubig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Inchen Josébe asrwan srua ya, kan lino llensu chishchiitøga kirra, ");
INSERT INTO gum_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kan peñayu José tru nuyasig søramig trab lalig srøig pasrabigu wayibig køn. Incha tru trabyu truba nu srugwan merrana, kebambinug kasra pasrabe, yandø ibig køn. ");
INSERT INTO gum_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Inchen María Magdalenaba, katøgan Maríaba sørinug pinrrøgue purrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Inchen katø kwaløm tru isram kwalømweyasig tamarøb kuin kwaløm chab puraiben, katø kwaløm, tru sábado isrin kwalømbe, tru sacerdotesmeran karubeløba, fariseosmeraba kanbalatø misra Pilaton ashchab ambabe, ");
INSERT INTO gum_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","trenchibelø køn: —Au, namui kubenadur, nambe isua ker cha; tru isa waminchiptiibe øsig uñippatø trendaig køn cha: “Kwawa, pøn kwalømyube katø øsiiramønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Inchawei treeg købene, ñibe pøn kwalømgatig sørigwan tab ashib tøgagønrrai karu, chibelø køn. Inchippa nui kusrenanøb pera uniilø yem amrrua, nui asrwan nilabgun cha. Incha misaameran ‘katø øsiirain køn’ chimønrrai. Treeg purayaisruandøbe si, trube, srøsrø isa wamindi lataikken kømø, katøbe purø trømbøig isa wamindig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Inchen Pilatobe trenchibig køn: —Suldaumera pønrrabelan pera ambay, cha. Ñim maig tamaramdiig køben, treeg tamartrigay— cha. ");
INSERT INTO gum_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Incha ambabe, tru sørin trabwan mu chinchimønrrai may tamarøbelø køn. Tru kasrøb srugwane kan sello mesrøb, katø truyu suldaumera ashib pønrrønrrai pønsrøb, treeg inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Indiibe yandø isrin kwaløm puraiben, tru srø trune pølbasrøb kwaløm ullarbatø, María Magdalenaba, katøgan Maríaba tru sørinug ashchab ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Inchen møimbe pirø truba mur kønaptinchibig køn, kaguende Señorwei ángel srømbalasrøngurri kørraarruben. Inchabe sørin trabyu kemalla, tru srug truyu kasrøbigwan wemalsra, tru srug pala wamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tru ángelbe kan sre pilabig lataig tørbilabzhig købig køn, nui kewagúibe puløzhig kan pulø wañi latazhikke. ");
INSERT INTO gum_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Inchen suldaumerabe trunun ashabe, kørig købiitø itønab, ke kwailø latailø warambuben, ");
INSERT INTO gum_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ángelbe tru ishumburmerane trenchibig køn: —Kørig kui inchimøtay cha. Ñimbe tru Jesús kurusyu mesraigwan lab kui, nabe ashar cha. ");
INSERT INTO gum_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yube mu kaagøn cha. Nøbe kwailai utugurri katø øsiirain køn cha, nø maig taig. Nun wayinug ashchab amrruy cha. ");
INSERT INTO gum_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Incha møimbe malla ambay chibig køn, nui kusrenanøb pera uniilan øyah chinrrab: “Jesúsbe øsiirawa, Galileasrømay ñimguen ammøwatø, nømerrig inrrun tan chinrrigay cha. Trusrø ñimbe nun ashchun tan” chinrrab. Nabe ñimune yandø chab eshkar— cha, ángelbe trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Inchen ishumburmerabe tru sørinukkurri truba kwaariilø webambuppe, webambendø, truba kasrag luløb ambubelø køn, nui kusrenanøb pera uniilan eshkanrrab. ");
INSERT INTO gum_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Inchen trunetø Jesúsbe nømun kenamisra, wamaptinchibig køn. Inchen nømbe Jesúswan kemalla, nui srøbmeran ira, køriibala tabig waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Inchen nøbe trenchibig køn: —Chi kørig kui inchimøtay cha. Nai nunelan Galileasrømay amrrai eshkanrrab ambay chibig køn. Nømbe trusrø nan ashchun— cha. ");
INSERT INTO gum_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Incha ishumburmera ambub kømne, suldaumera møiløgøsrøn tru ashib pønrrabelø ciudayumay ambabe, tru chi purayaigwan sacerdotesmeran karubelan kerriguh eshkabene, ");
INSERT INTO gum_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","truiløbe tru misagwan karubelø kølli misaameraba maig maramigwan wamincha kørrømisrtrab tulundzunabe, suldaumerane an truba nørrø pagarabelø køn. ");
INSERT INTO gum_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Incha: —Ñimbe øya chinrrigay chibelø køn: “Nam kib waramnetø, nui kusrenanøb pera uniilø amrrua, Jesúswei asrwane nilin køn” cha. ");
INSERT INTO gum_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Inchippa kubenadur wammørøb chinchene, trube, trunune nam asamønrrun chibelø køn. Ñimun chi puraimønrrai.— ");
INSERT INTO gum_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Inchen suldaumerabe anwan uta, maig karuben treeg marøbelø køn. Incha øyeeg purayaig køn chib wamindiibe judíosmerai utube møin kwalømgatig wambe larrøbitsig pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inchen tru once kusrenanøb pera uniiløbe Galilea pirau tunsrø Jesús eshkainuumay ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Incha Jesúswan ashippe, køriibala tabig waminchibelø køn, møiløbe ‘¿truig køh? kabe, ¿peg køh? chindermab’ isuatøgucha. ");
INSERT INTO gum_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Inchen Jesúsbe nømun kemallabe, trenchibig køn: —Tiusbe srømbalasrø lata, pirau lata chiwandøgucha mu mandamgaig marøb karumigwane nan tranig køn cha. ");
INSERT INTO gum_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Treeg købene, yu pirau maya misaameran mundøgucha na kusrenanigwan marøb melabelø kønrrai martrab amrrigay cha, Møskaweimba, Nusrkaweimba, Espíritu Santoi munchiyuba misaameran piu umbu ulsrøb. ");
INSERT INTO gum_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Incha na ñimun maig karuigwan kerriguh trunun møra martrai kusrenrrigay chibig køn. Inchen nabe naimburappe kwalømmørig srabe kwalømgatig ñimba pasramønrrun— cha, trenchibig køn Jesúsbe.");
INSERT INTO gum_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tiuswei Nusrkai Jesucristoimburab tru tabig srø wambe øyamay pølbasrig køn: ");
INSERT INTO gum_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tru Isaías Tius maig karuigwan eshkabig maig pørimbala: Au, nabe nai wam srua inrrabigwan ñui merrab ørar cha, truibe ñui maywan tamartrai. ");
INSERT INTO gum_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mu misag warab waraimøsrø kan wam trenchib trasan chib: “Señorwei maywan tamarøb, nuyasig maymerane ølmarøb inday” tan, chib. ");
INSERT INTO gum_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Treekkurri Juan Bautistabe mu misag warab waraimønug kenamisra, misaameran mas kaig marmønrrab isua møra, Tiusweimay llirain kønmab asamig piu umbu ulsrailø kømigwan eshkab kusrenanøbig køn, kaig mariilan ulø payamig kømíig pesannailø kønrrai. ");
INSERT INTO gum_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Inchen maya misag Judea pirausreelø køben, Jerusalén ciudasreelø køben nuimay mørtrab amrruabe, nømui kaig mariilan ‘øyeeg marig køn’ chib eshkabene, truilan Juanbe Jordán piyu piu umbu ulsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan kewagúibe camello isiitøga marig købig køn. Inchen nui pørønaibe kaluswan marig køben, nui mamibe nørrø chapullba, kaambu mielba købig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Incha misagwan eshkab waminchibig køn: —Nai wendaube katøgan na lataguen kømø, maramburab marøbig maskenig attrun cha. Trunune nabe nui alpargatisyu tsiwan utsøbasra, pichibguen pitchabgaig kur chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nabe ñimune pi pinøbulrrai piu umbu ulsrar cha. Trune nøbe ñimun Espíritu Santotøga pinøbulrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Inchen tru kwalømmerawan Galilea pirau, Nazaret puebloyugurri Jesús webiben, nune Jordán piyu Juan piu umbu ulsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Inchen piu umbugurri webarrub latatø, Jesúsbe srømbala kuri ashib, Espíritu Santo nuim pala kan paloma lataig kørraarri ashib inchen, ");
INSERT INTO gum_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Srømbalasrøngurrimbe kan wam treeg mørø waminchib trenchibig køn: —Ñibe nai Nusrkai undaaraig køn cha. Nabe ñuimburab truba tab kui war— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Inchen tru urastø Espíritu Santobe Jesúswan mu misag warab waraimøsrø møi møi ingarubig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Inchen Jesúsbe truyu kwalømmera cuarenta nemisramne tsuben, Satanásbe kebenøsrkønrrab ke chinetø maringarunrrab inchibig køn. Inchen ángelesmera purugubelø køn, Jesúsbe namig animalmerai utu tsuben. ");
INSERT INTO gum_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juanwan kailan keeri yau keeri wendø, Jesúsbe Tiusweimburab tabig srø wamwan Galilea pirausrø eshkab kusrenanøb ya, ");
INSERT INTO gum_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","trenchibig køn: —Yandø øyeeg kønrrabig puben, Tius nø ashib karub pasraibe lutau pasran cha. Ñimui kaig mariilan isua møra, Tiusweimay llirab, tabig srø wamwan kørey— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galilea nu pisu mendawan ib pasrøwabe, Simónwanba, nuneg Andréswanba, truiløbe peskabelø kua, nømui atarrayameran pisuyu keguchib warai ashibig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Inchabe Jesúsbe trenchibig køn: —Nai mendig amrruy cha. Nabe ñimune misaameran peskabelø kønrrai maramønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Inchen nømbe møi møi nømui atarrayameran waramnetø Jesúswei mendig ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Inchen Jesúsbe katøguchi ambuurø yabe, Zebedeowei nusrkalø Santiagonba, nuneg Juanwanba ashibig køn. Truiløbe kan barcoyu nømui atarrayameran tamara tsushib purrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Inchabe tru urastø wamøben, nømbe nømui møskai Zebedeowanba, purugubelanba barcoyu purramnetø, Jesúswei mendig ambuptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Incha Capernaum puebloyu pua, tru isrin kwalømbe Jesúsbe judíosmera tulundzuni yau kebya, kusrenanøb mendøben, ");
INSERT INTO gum_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","nø wamindiilan møra, misaamerabe kwaara ashibelø køn. Kaguende kusrenanøppe, nuinukkurrindøwei mu mandamgaig kusrenanøbig køn, tru Moisés pørigwan kusrenanøbelø lata kømø. ");
INSERT INTO gum_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Inchen tru puebloyu judíosmera tulundzuni yaube kan møg trømbøig maringarub kwaimandzigwan tøgaig wawa, trenchib trashibig køn: ");
INSERT INTO gum_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Nambabe ñibe chi asamig tøgagugu cha, Nazaretsrø Jesús? ¿Namun pinishinrrab attirru? cha. Nabe ñune mu kui ashar chibig køn. Ñibe tru Tiuswei Newan Tabig, truig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Inchen Jesúsbe kwaimandzigwan namab trenchibig køn: —¡Ñibe trashimøtø, møweinukkurrimbe webinrrø!— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Inchen trømbøig marøngarub kwaimandziibe møwan truba mur sruagucha, tru møweinukkurri mur trashib webibig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Inchen mayeeløba kwaara asha, nømasiyaitø trenchib payiyabelø køn: —¿Øyeebe chi kerah? cha. ¡Kusrenanig iibe ke srøig, trurrigu nø maig chippe ke treeg kønrrai maran! cha. I møøbe trømbøig maringarub kwaimandziimeranguen mu chindamgaig wamøben, nune møran— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Inchen petø Galilea pirau ørøba misaamerabe Jesús nø chi marigwan wammørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Incha tru urastø judíosmera tulundzuni yaugurri webambabe, Jesúsbe Jacoboba, Juanba, Simónweimba, Andrésweimba yamay amben, ");
INSERT INTO gum_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simónwei sueerabe camayu pachiiba tsuben: “Kwanrrø tsun” cha, tru urastø Jesúswan eshkaben, ");
INSERT INTO gum_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesúsbe kemalla, tasigu kemørøb kusrabene, pachiibe weetaptinchen, nøbe tru pubelayasig chi maramigwan marøb mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yandø pørr pinaiben, chab pilliraben, Jesúsweimay mayeelø kwanrrø tøgarmeranba, kwaimandziimera tøgarwanba srua amrruben, ");
INSERT INTO gum_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","puebloyu maya misaaba yaskabugøba tulundzuna pasrøben, ");
INSERT INTO gum_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesúsbe truba yamelø chi kwanrrø køben tøgarmeran tamarøb, katø truba yam kwaimandziimeran misaamerainukkurri webusrøbig køn. Incha kwaimandziimerane waminchibashmíig køn, kaguende truiløbe nune mu kui ashibelø køben. ");
INSERT INTO gum_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Incha løtsøzhig ullarbatø, Jesúsbe kurra, ciudayugurri wambig mu misakkasrø, trusrø Tius Møskaimba waminchib wabig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Inchen Simónba, nui linchibeløba lanrrab webamba, ");
INSERT INTO gum_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","wetørrawabe, trenchibelø køn: —Mayeeløba ñune lab køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Inchen nøbe trencha løtabig køn: —Misaamera puluwandø katøganbalømera warabsrømay amrrab cha. Trusrøngucha srø wam tabelan eshkab kusrennrrab, kaguende nabe truweiwei arrur— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Incha Jesúsbe Galilea pirau ørøba judíosmera tulundzuni yamerayu chutøgucha eshkab kusrenanøb, katø kwaimandziimeran misaamerainukkurri webusrøb inchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kan møg asr trerab kwanrrø, lepra taig, tøgaig Jesúswan kemalla, tømbønsrabe trenchibig køn: —Ñi nan tamaramdiig købene, tamartra— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Inchen Jesúsbe lastima asha, tasigwan larrøbicha estsarabe, trenchibig køn: —Tamarøg køtan cha. Tamarig kørrømisr— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Inchen møi møi nui trerab kwanrrøbe pinøben, nøbe chishig kørrømisren, ");
INSERT INTO gum_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesúsbe yandø ‘inrrø’ cha, nune kuchi murtø waminchib trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Au, mungøben eshkawabesin cha. Inchendø ya, ñui asrwan sacerdotendø kenamara, tru ñi yandø chishig kørrømisrimburø tru Moisés trannrrig taigwane srua ya, trannrrig cha, mayeeløba ñui kwanrrøwan chishig kørrømisrin kui ashchain— cha. ");
INSERT INTO gum_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Trendaingucha møøbe ya, chi purayaigwan mayeelan waminchib mendøben, treekkurri Jesúsbe chu puebloyutøgucha misag ashene, yandø kebinrrab kaima, mendawansrø misakkanug uñibig køn. Inchen chugurrielø køben nun ashchab amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mam kwaløm wendau køsrøn, Jesús katø Capernaum puebloyu kebiben, nø yau wan taig wammørøppe, ");
INSERT INTO gum_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","misaabe petø truba nu tulundzuna, ni yaskabuguen kemuben, nøbe Tiuswei srø wam tabelan waminchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Inchen pibgatø møguelø kan møg kønønrrab kaimabigwan muta, puben, ");
INSERT INTO gum_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","menrra misag køptø, Jesúsweim pulugatig kemallchab kaimappe, tru nø pasraim pala yawan picha, trugurrimbe tru trabyu kwanrriigwane kan tsigalyu kørrøørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Inchen Jesúsbe nømui isubigwan ke nuinuutø pasra pønrrai ashabe, Jesúsbe kwanrriigwane trenchibig køn: —Nai nusrkai, ñui kaig mariilan ulø payamig kømíig, pesannaig kørrømisran— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Inchen møiløgøsrøn tru Moisés pørigwan kusrenanøbeløbe nømui manrrautø truba isub purrabelø køn: ");
INSERT INTO gum_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nøbe øyeebe chi waminchib pasrarmah? cha. Øyeeg chib pasrappe, Tiusweimburab purø trømbøig wamab pasran cha. Kaig mariilane ulø payamig kømíig pesannaig kønrraimbe ¿mu kuin treeg mariasamø? cha. Tiustøwei øyeeg martrun” chib. ");
INSERT INTO gum_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Inchen tru urastø Jesúsbe nømuinetø øyeeg isub pønrrailan kelarrab ashabe, trencha payibig køn: —¿Ñimbe ñimui manrraube chindimbarre øyeeg isugue? cha. ");
INSERT INTO gum_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Møigwan mas kørmø trendamdiig købsruerah? cha, tru kønønrrab kaimabigwan: “Ñui kaig mariilan ulø payamig kømíig pesannaig kørrømisran” ¿tamiteh? Kabe: “Kurrab, ñui tsigalwan muta, inrrø” ¿tamiteh? cha. ");
INSERT INTO gum_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pøs, na, Møg Misra Arrubiibe yu pirau kaig mariilan ulø payamig kømíig pesannaig kønrrai mu mandamgaig marøbig kui møimbe ñim ashchai kenamaramønrrun— chibig køn. Inchabe tru kønønrrab kaimabigwane trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Nabe ñun trenchar cha: Kurrab, ñui tsigalwan mutab, yamay inrrø— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Inchen truibe kurrappa, nui tsigalwan muta, mayeelø ashen, truyugurri webibig køn. Inchen trugurrimbe mayeeløba truba kwaara ashib, Tiuswan truba tabig waminchib trenchibelø køn: —Managuen nambe kan øyeekkatiibe ashmuig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Incha katø Jesús nu pisu mendasrømay iben, maya misag nuim pulu kemallen, nøbe kusrenanøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Incha pureb ya, Alfeowei nusrkai Leví, romasreelayasig an utabelø purrainug wai ashabe, trenchibig køn: —Nai mendig amø— cha. Inchen nøbe kurrab, nui mendig ibig køn. ");
INSERT INTO gum_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Indiibe Jesúsbe Levíwei yau mab wabene, truba yamelø romasreelayasig an utabelø køben, katøganelø kaig marøb misaamera køben Jesúsba, nui kusrenanøb pera uniiløba mishatsigu trubalatø purrøben, kaguende truba nu købig køn nui mendig amøñibeløbe. ");
INSERT INTO gum_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Inchen fariseosmerai utu tru Moisés pørigwan kusrenanøbeløbe Jesúswane mayeelø tru kaig marøbeløba, an utab purrabeløba mishatsigu mab wai ashabe, nui kusrenanøb pera uniilane trencha payibelø køn: —¿Nøbe an utaptø purrabeløba, kaig marøbeløba mab, muchib wappe, øyeebe maig marøb wah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Inchene Jesúsbe trunun mørabe, nømun trenchibig køn: —Tabelø, kwanrrøgarbe mø marøbig palain kømøn cha. Kwanrreeløbeguende palain køn cha. Nabe tru sølgandø amøñibelan wamønrrab arrumøtø, kaig marøbelan wamønrrab arrig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juanwei mendig amøñibeløba, fariseosmerai mendig amøñibeløbabe ayunab køben, møiløgøsrøn amrrua, Jesúswan payibelø køn: —Juanwei mendig amøñibeløba, fariseosmerai mendig amøñibeløbabe tru ayunamigwan katø katø maren, ¿ñui kusrenanøb pera uniiløbe chindimbarre trunune marmeelø køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Inchene Jesúsbe trenchibig køn: —¿Kan novios yaumay linchai eshkailanma keg mistrabig nømba wabengan, mamø purrønrraitarru? cha. Keg misrtrabig nømba wabene, manrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Inchendø keg misrtrabigwan srua ambam kwalømmera punrrun cha. Tru kwalømbeguende, trube, nømbe ayunabwei inchun cha. ");
INSERT INTO gum_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Muguen kan køllin camisanma kølsraigu srø llensu søtiimíigwan waya tsushimøn chibig køn. Treeg marene, srø llensube kesruppa, kølli llensune kølsrøben, mas trømbøikken kølsraig kørrømisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Katø muguen srø vinonma køllin kalusmerayu usrmøwei indan cha. Kaguende treeg marene, srø vinobe køllin kalusmeran srurrøgøben, vinobe lushen, kalusmerabe ka kølsrønrrun cha. Inchawei srø vinone srø kalusmeran marigu usrøbelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kan isrin kwaløm Jesús tirigu ellmari utuwan pureb ibene, nui kusrenanøb pera uniiløbe puraambub ambuppe, tirigu tur lurrøb mendøben, ");
INSERT INTO gum_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","fariseosmerabe Jesúswan trenchibelø køn: —Au, ¿ñui kusrenanøb pera uniiløbe isrin kwalømbe chigøben marmønrrai merigwan chindimba øyeeg marøb køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Inchen Jesúsbe trenchibig køn: —¿Ñimgan managuen lemeelø køtirru cha, mana køsrøn Davidwanba, nui linchibelanba chindamgaig palabig arruben, parøgwaben, mandø indigwan? ");
INSERT INTO gum_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar, tru maya sacerdotesmeran nø karub sacerdote køben, Davidbe Tiuswei carpa ya tabzhigu kebya, Tiusweyasiitø tarømarig pirrimera, tru sacerdotesmeratø maim pirrimeran mendaibe mu mamønrrai merigwan nø mab, katø nøba purrab misagwangucha srørrøb indigwan.— ");
INSERT INTO gum_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Incha Jesúsbe katø trenchibig køn: —Isrin kwalømwane møweyasig marig køn cha, møwan isrin kwalømweyasig kømøtø. ");
INSERT INTO gum_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Inchawei na, Møg Misra Arrubiibe isrin kwaløm nan nø karunrrain kømøtø, maramdiigwane marøb, maramgaigwane marmub, isrin kwalømwanguen nabe na asha karubig kur— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús katø judíosmera tulundzuni yau kebibene, truyu kan møg tasig mul-laig tøgaig waben, ");
INSERT INTO gum_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesúswan larab købelø køn, isrin kwaløm tamarøbig køtashchab, chigøben chi køptø. ");
INSERT INTO gum_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Inchen Jesúsbe tru tasig mul-laig tøga møwane trenchibig køn: —Kurra, yu tøbøtag pasramisr— cha. ");
INSERT INTO gum_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Inchabe katøganelan trenchibig køn: —¿Tru maig maramigwan martrai Moisés pøriiløyube isrin kwalømbe chiwan martrain taig køh cha, tabiiteh, kabe kaiteh? cha. ¿Kwamønrrai indamig køh, kabe kweetsamig kø, chindah?— cha. Inchen nømbe chigucha chimuben, ");
INSERT INTO gum_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesúsbe nuingatan pønrrabelan namig ashib, truba isui inchibig køn, kaguende nømui manrrømerabe purø murelø kuimba. Incha tru møwan trenchibig køn: —Kwalwan larrøbichi— cha. Inchen nøbe larrøbichene, nui kwalbe tabig kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Inchen fariseosmerabe webamba, tru urastø Herodesweingateeløba Jesúswan namig kurra, mandø incha pinisamigwan waminchib mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Inchen Jesúsbe nui kusrenanøb pera uniiløba tarømisra, nu pisu mendasrømay iben, misag truba nu Galilea pirausreelø nui mendig ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Inchen nø chinetø nørreelø marigwan wammørabe, judeasreelø køben, jerusalénsreelø køben, idumeasreelø køben, Jordán pi tru pørr kal-labgatøsreelø køben, tirosreelø køben, sidónsreelø køben, truba nu ashchab amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Incha tru treeg nu misakkurri Jesúsbe nui kusrenanøb pera uniilan kan barco ke tamara tøgagønrrai eshkabig køn, tru nu misag nun menrra trag marmønrrai. ");
INSERT INTO gum_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kaguende Jesúsbe kwanrreelan truba truba tamarin køben, mayan kwanrreeløba katøranrrab nuimaygøba kemallchab tranrrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Inchen trømbøig maringarub kwaimandziimera nun ashippe, nui merrab tømbønsra, trenchib trashibelø køn: —Ñibe Tiuswei Nusrkain køn— chib. ");
INSERT INTO gum_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Inchen Jesúsbe nune mu køn cha, mun køben misaameran mørø waminchimønrrain karubig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Incha Jesúsbe kan tunsrø nebya, nø wamønrrab asiilan wamøben, nømbe nuimay amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Incha doce wesrawa pønsra treeg kørrømara, iilane nøashib karua øriilø køn cha, wamabig køn, nøba amøñibelø kønrraimba, katø eshkab kusrenanrrab amrrai øramigweyasiiba, ");
INSERT INTO gum_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","katø kwaimandziimeran webusramig mu chindamgaig marøbelø kønrraimba. ");
INSERT INTO gum_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tru doce wesrawa pønsrailøbe iilø køn: Simón, nundøwei katø Pedro cha, munchi pasrig køben, ");
INSERT INTO gum_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeowei nusrkai Santiagoba, nui nuneg Juanba, truilane Boanerges cha, munchi pasriilø, tru treeg munchibe: “palaig trashibig taigwei nusrkalø”, ");
INSERT INTO gum_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","katø Andrés køben, Felipe køben, Bartolomé køben, Mateo køben, Tomás køben, Alfeowei nusrkai Santiago køben, Tadeo køben, Simón Cananistameraingatiig køben, ");
INSERT INTO gum_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","katø Judas Iscariote, tru wendø Jesúswan ashig kømui inchibelaingatø pasramisra, trannrrabig købengue. ");
INSERT INTO gum_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Inchen Jesús katø nui kusrenanøb pera uniiløba kan yau kebiben, katø misag menrra tinmarøb tulundzunaptø, manrrabguen kaima købig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Inchen Jesúswei yaueløbe treeg inchib køn taig wammørabe, nune merrarrawa, sruamrrunrrab ambubelø køn. Kaguende lukiain køn chib køben. ");
INSERT INTO gum_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Inchen tru Moisés pørigwan kusrenanøbelø Jerusalénsrøngurri amrrubeløgucha trenchibelø køn: —Nugwaimandzig, tru Beelzebúwan tøgaig køn cha. Treekkurri, tru kwaimandziimeran nøasha karubigwan tøgaig kua, i møøbe kwaimandziimeran weeran— cha. ");
INSERT INTO gum_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Inchen Jesúsbe nømun wama, ‘øyeeg lataitøwein køn’ chib, kemesra wamindiiløtøga trenchib waminchibig køn: —¿Satanásbe Satanáswandøweimbe chincha wegutchaitamague? cha. ");
INSERT INTO gum_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kan rey karub tøgaweim pirau misaama nømasiitø nøørøtø misrøb kurrabe, warabig warønrrab kaimanrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Katø kan yauelø nømasiitø nøørøtø misrøb kurrabe, chab pinønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Inchawei Satanás nøasiitøwei nøørø, nøørø misrøb kurrabe, treegu yandø pasrønrrab kaimaben, truyu patsønrrun, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Kabe kan møikkøben kan mur møwei yauma kebya, tru mur møwan lusrøbmerrig lusrmøwatøbe, nui chi tøgagúigwan kerranrrab kaimanrrun cha. Lusra trarratøwei nui chi tøgagúilan kerranrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nabe ñimun cierton trendamønrrun cha: Misaamera chi kaig mariilan lata, chigøben Tiuswan purø trømbøig wamindiilan lata Tiusbe kerriguh pesannawa, ulø paymønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Trune Espíritu Santon purø trømbøig wamab waminchibigwane ulø payamigwane managuen pesannaimíig kønrrun cha. Treeg kømøtø, nui kaig marigwan managatig tøga kørrømisrtrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesúsbe øyah chippe, kaguende nømbe nun trømbøig marøngarub kwaimandzigwan tøgaig køn chib køben, trendaig køn. ");
INSERT INTO gum_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Inchen Jesúswei usrimba, nuneløba pua, wambiitø pønrramisra, wamønrrab øren, ");
INSERT INTO gum_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesúsweim pøtøgatan truba nu purrabeløbe trenchibelø køn: —Au, ñui usrimba, ñui nuneløba wambig pønrran cha, ñun payib.— ");
INSERT INTO gum_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Inchen nøbe trencha løtabig køn: —¿Nai usri nai nuneløbe mumera køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Incha nuim pøtøgatan purrabelan ashabe, trenchibig køn: —Nai usri nai nuneløbe iilø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kaguende møikkøben Tius maig martrai karuben, treeg marøbig, truibe sí, nai nuneg, nai nuchag, nai usrin køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús katø nu pisu menda kusrenanøb mendøben, nø wainug misag truba nu tulundzunøben, treekkurri Jesúsbe pisuyu kan barcoyu kebya wamisren, maya misaabe tru pisu mendatø kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Inchen nøbe nømun ‘øyeeg lataitøwein køn’ chib wamindiiløtøga chineh kemesra, kusrenanøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Inchabe nui kusrenanigube trenchibig køn: —Iigwan møray cha. Kan kwallibiima tsurøb kwallchab webyan cha. ");
INSERT INTO gum_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Incha tsurøb ibene, kanbalø yellbe mayu kørrøben, illimera amrrua, man cha. ");
INSERT INTO gum_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Inchen katøganbaløbe srug trøldø pirau pirø tre chiganug kørrøben, pirø palatiig kua, tru yellbe kal-lappe, petø kal-labendø, ");
INSERT INTO gum_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","pørr webarrua, mergurangaruben, srøl tre chigaig kua, mul-laptindan cha. ");
INSERT INTO gum_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Katøganbalø yellbe kal shau utu kørrøben, kalmera nørrørab mendappe, chab kasrøb tsibishiben, truibe chigucha misrmøn cha. ");
INSERT INTO gum_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Inchen katøganbalø tab pirau kørrabiibe sí, kal-lawa, tabig nørrørawa, truba nu nigan cha. Møiløbe kan yellgurrindø mamig trulzheelø treinta niguen, møiløbe sesenta niguen, møiløbe cien nigan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Incha trenchibig køn: —¡Møramig kalu pønsraibe, mør!— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesús yandø nøtø kørrømisren, tru doce kusrenanøb pera uniiløba kanbalatø Jesúsweim pulu pønrrabeløbe trenchibelø køn: —¿Tru ‘øyeeg lataitøwein køn’ chib kemesra wamindiiløbe chi chibig køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Inchen nøbe trenchibig køn: —Tiusbe nø ashib karub wainug mu asiimíig tøgagúilan ñimune ashchai tranan cha. Inchendø misaamera nøøreelø truyuilø kømeelane ‘øyeeg lataitøwein køn’ chib kemesragøba wamindiiløtøga wamindig køn cha, ");
INSERT INTO gum_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nømbe ashippe ashendø, ashmøwa lataig kørrømisrøb; mørøppe mørendø, chi tainguen mørmøwa lataig kørrømisrøb inchain cha. Incha isua møra Tiusweimay lliramøwei, nømui kaig mariilan Tius ulø payamigwan pesannamø, ulø payamig kønrrain kuig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Incha katø trenchibig køn: —Ñimgan ‘øyeeg lataitøwein køn’ cha, tru kemesra wamincha pasrigwane ¿chigúi wetøgørrøtirru? cha. Katøgan ‘øyeeg lataitøwein køn’ cha, kemesra tru wamindiilangucha kerriguba ¿chincha wetøgørrønrrague? cha. ");
INSERT INTO gum_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tiuswei wamwan waminchibiibe yellwan tsurøbig lataig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Inchen tru mayu kørrab yellmerabe iilø latailø køn cha. Nømbe Tiuswei wamwan møren latatø, Satanásbe arrub, tru tab wamwan nømuinug ellmarigwane kerran cha. ");
INSERT INTO gum_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Inchen tru srug trøldø pirau pirø tre chiganug tsuri yellmera latailøbe iilø køn cha: Tiuswei wamwan møra, tru urastøbe truba tab kui utøbendø, ");
INSERT INTO gum_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","nømasiitø srøl tre umbu keetiimeelø kua, maya yanaguen amøñimøn cha. Incha tru Tiuswei wamgurrindø chigøben puben, katø chigøben kaig nebub arruben, nømbe møi møin elachiptindan cha. ");
INSERT INTO gum_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Inchen katøganeløbe tsuren, tru kal shau utu kørrab yell latailø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tiuswei wamwam mørøppe mørendø, i pirau chine købigwan menrra isubiibah, nømui chine palømø tøgagúilø purø tabig lataig asønaikkurrimba, trugurri chine tøgagømmørø chull inchib isuiløbatø Tiuswei wamwan mørigwane kerrigu truitø kasrøben, chigucha nømbe ellmarig misrmøn cha. ");
INSERT INTO gum_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Inchen tru tab pirau tsuriiløbe tru Tiuswei wamwam møra, ellmarig misrøbelø, truilø køn: kan trulzhikkurrindø treinta, kabe sesenta, kabe kan trulzhikkurrindø cien nigabelø latailøgue.— ");
INSERT INTO gum_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Katø Jesúsbe trenchibig køn: —¿Kabe kan lámparanma køtsø umbu pasrtrab, kabe cama umbu pasrtrab srua kerrubelø kuitarru? cha. Treeg kømøtø, ¿tør kønrraimbe, pala pasramig kømuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chigøben sørig pasrabiibe søriitø pasrømøtø, kenamaramig kønrrun cha. Katø chinchaguen asamgaig kasra pasrigwane ashchai tøryu wesraig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Møikkøben møramig kalu pønsraig kuabe, mør— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Incha katø trenchibig køn: —Ñim chi mørigwane tab isua kuy cha. Ñim kanelan maig unaasha traniibe, ñimungucha treetøwei unaasha trana, ñimune nemariibaguen tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kaguende tøgaigwane masken tranen, trune chigaigwane nui lamøtiig tøgagúigwanguen kerranrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesúsbe katø trenchibig køn: —Tius nø ashib karub pasraibe kan møg pirau yellwan tsuri lataig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Incha kib tsui lata, kurra uni lata, yem kui lata, kwaløm kui lata, yellbe kal-lawa nuran cha, møøbe mandø indinguen ashmøwatø. ");
INSERT INTO gum_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kaguende pirøbe nøasiitø mamig niguingarubig køn cha. Srøsrøbe ishiimerrig kal-laben, trugurrimbe urø weetøben, urøyube trulmera netsan cha. ");
INSERT INTO gum_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Inchen yandø trul srønøben latatø, usestøga paran cha, kaguende yandø param kwaløm puin køben.— ");
INSERT INTO gum_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Katø Jesúsbe trenchibig køn: —¿Tius nø ashib karub pasraibe chi lataig asøna cha, kabe chiwan kemesra, ‘øyeeg lataitøwein køn’ chinrrab køh? cha. ");
INSERT INTO gum_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kan murtasa yell lataig køn cha. Tsurøb uras truibe yu pirau maya yellmerai utu purø lamøzhig købendø, ");
INSERT INTO gum_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tsurinukkurrimbe shush mamig tusrmerai utu katøguchinguen palaig nu tusr-unø srarmerabaig nuraben, illimera pala amøñibeløguen truyu le martrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesúsbe Tiuswei wamwan øyamay kusrennøbig køn, ‘øyeeg lataitøwein køn’ chib, truba yambalø kemesra eshkab. Møi eshkaig latailø, nøm mayangatig chigúi nebua mørtrapteelø køben, treetøh marøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","‘Øyeeg lataitøwein køn’ chib kemesrømøbe, waminchimíig køn. Inchendø nui kusrenanøb pera uniilane nømundø nøørø kerrigu tør marøb eshkabig køn. ");
INSERT INTO gum_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Incha tru kwalømdøwei yandø pilliraben, nui kusrenanøb pera uniilan trenchibig køn: —Pisu ambøgatøsrømay larraamun— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Inchen nømbe misagwan ‘ungwa’ cha, Jesúswan tru nø waig barcoyutøwei pera amben, katøgan barcomeragucha lincha ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Inchen truba mur isig ichibig webarruben, pi welarmerabe barcoyu keguchen, yandø ke pitø netsab arruben, ");
INSERT INTO gum_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsbe wendau kan labzhigu ne kib waben, nømbe kasrønanabe trenchibelø køn: —¡Au, Kusrennøbig! ¿nam asentanrreenchib melamne, ñigan isubguengaig watirru?— cha, ");
INSERT INTO gum_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Inchen Jesúsbe kurra, isigwan kønømønrrai kandø wama, piwane trenchibig køn: —¡Wanrrømø, møi møi wasrørau!— cha. Inchene isiibe pasramisren, yandø kerrigu wasrønzhig kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Inchen Jesúsbe nui kusrenanøb pera uniilan: —¿Chindimbarre kørig køta? chibig køn. ¿Ñimui isubigwan nainuutø pasra kømeelø kø chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Inchen nømbe truba kwaariilø kørrømisra, kangurrin kangurri trenchibelø køn: —¿Iibe mu kerah cha, isig ichibig lata, mar lata, nun mørtrappe?— ");
INSERT INTO gum_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pisu ambøgatømaysrø larraamba, Gerasa pirausrø puben, ");
INSERT INTO gum_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús barcoyugurri webiben latatø, kan møg trømbøig maringarub kwaimandzig tøgaig sørin trabmerayugurri webarrua, Jesúswan kemallibig køn. ");
INSERT INTO gum_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tru møøbe sørin tulyutø tsubig, muguen lusrtrab kaimaig købig køn, ni cadenastøgaguen. ");
INSERT INTO gum_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kanmaybe srøbmeran tasiimeran cadenastøga køben, katø chitøga køben lusrendø, lusrimørig pitischig marøb lurren, muguen kaimabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Incha yem kwaløm chu uragucha tunmerasrø, sørin tulmerasrø trashib, sruutøga nøasiitø kørriinchib uñibig køn. ");
INSERT INTO gum_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Incha Jesúswane yabgurrindø asha, lula, nui merrab tømbønsra, ");
INSERT INTO gum_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","trenchib trashibig køn: —¿Ñibe nane chi martrab inchigu? cha, Jesús, Tius Mayeelaim Pala Pasrabigwei Nusrkai. Purø trømbøig møra megamig kømønrrai Tiuswei munchiyu ka købash cha, chib miarrumøn— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Pøs øyeeg chippe, kaguende Jesúsbe: —¡Ñi, trømbøig maringarub kwaimandzig, i møweinukkurri webinrrø!— chib pasrøben, trendaig køn. ");
INSERT INTO gum_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Inchene Jesúsbe nun trencha payibig køn: —¿Chi munchi kugu?— cha Inchen nøbe: —Legión munchi kur, chibig køn. Kaguende nambe purø nu ker— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Inchabe tru piraugurri nøørø peesrømay ørmørrunrrig chib, Jesúswan truba truba rugabig køn. ");
INSERT INTO gum_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Inchen tru tun puluwan kuchimera lawa mab truba nu amøñibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Inchen tru kwaimandziimerabe rugab trenchibelø køn: —Kuchimeraimay ambingarurra cha, nam truilainug kebamrrab— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Inchen Jesúsbe ka kebambashen, trømbøig maringarub kwaimandziimerabe møweinukkurri webamba, kuchimerayu kebambene, truyu kuchimerabe pa milburab warabeløbe truba trømbø lendeyu lula, chab pinøgørraptincha, larrø nu pisuyu kegørra, pi keesra, chab kwabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Inchene kuchi ashibeløbe kwaariilø lula, puebloyu køben, wambig nøørøwansrøn køben eshkab ambubelø køn. Inchen misaamerabe chi purayaigwan ashchab amrrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Incha Jesús waisrø pubene, tru kwaimandzig tøgaig købiibe møimbe køsaatiig kømø, keweig, tabig wai ashabe, truiløbe kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Inchen tru kwaimandzig tøgaig købigwanba, kuchimeranba maig purayaigwan ashibeløbe nømun eshkaben, ");
INSERT INTO gum_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","nømbe Jesúswan nømuim piraugurri ‘irra’ chib truba rugabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Inchen Jesús barcoyu kebibene, tru kwaimandzig tøgaig købiibe: —¿Ñui mendig arruah?— cha, truba inchen, ");
INSERT INTO gum_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesúsbe arrubashmøtø, trenchibig køn: —Ñui yamay inrrø cha, ñui yau misaameraimay Señor ñun yeeg nørriig mara, mandø lastima asigwan nømun eshkanrrab.— ");
INSERT INTO gum_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Inchen tru møøbe ya, Decápolis pueblosrø Jesús nun yeeg nørriig marigwan truba eshkab mendøbene, mayeeløba kwaara ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús barcoyu katø pisu ambøgatømay larraibene, nuim pøtøgatan misag truba truba nu tulundzunøben, nøbe pisu mendatø kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Inchen judíosmera tulundzuni yau ashib karubig, Jairo taig, puabe, Jesúswan ashippe, nui srøb pulu tømbønsra, ");
INSERT INTO gum_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","arrubsrumugu chib truba inchib, trenchibig køn: —Nai nimbasr-unø kwanrrab inchib tsun cha. Kwanrrø tammisren, katø øsig uñchai ñui tasigwan nuim pala estsartrab attra— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Inchen Jesúsbe nøba iben, menrra misag mendig ambuptø nun trag maren, ");
INSERT INTO gum_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","tru misag utube kan ishug doce años ørøba ani ib kwanrrø tøgaig kua, ");
INSERT INTO gum_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","chu uraskucha purø trømbøig kui uña, mø marøbelai yam tasku pureb megawa, nui chi tøgagúigwan kerrigu patsøgøben, chiweingucha puraimø, kwanrrøbe masken inchib iben, ");
INSERT INTO gum_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesúswan wamindi mørøppe, tru ishuube misag utu wendaugurri Jesúsweim pulu kemallippa, nø kewagúigwan katørabig køn. ");
INSERT INTO gum_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kaguende nøbe treeg isubig køn: “Kewagúilandøguen katøraitø, tammisrig kørrømisramønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Inchen tru ani ibiibe møi møi pasramisrøptinchen, asru nui kwanrrøbe yandø purayai møren, ");
INSERT INTO gum_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesúsbe nø mun køsrøn nui maramburab mariitøga tamarøbrain kui mørabe, nu misag søtøwan keeshabe, payibig køn: —¿Na kewagúigwane mu katørah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Inchene nui kusrenanøb pera uniiløbe trenchibelø køn: —Misag søtø yeeg trag mari ashatø, ñibe: “¿Mu katørah?” taibe— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Inchen Jesúsbe mu katøraitashchab ambumay, imay ashene, ");
INSERT INTO gum_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tru ishuube kørig købiitø itønab, nun maig purayaigwan møra, ya, Jesúswei merrab tømbønsrøb srala, isømø, kerriguwan eshkaben, ");
INSERT INTO gum_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesúsbe trenchibig køn: —Nimbasr, ñui isubigwan nainuutø pasra tøgagúikkurri tamarig kørrømisran cha. Chi isumø, inrrø cha. Ñui kwanrrøbe yandø purayaig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Trune Jesús waminchib pasramnetø, tru judíosmera tulundzuni yau ashib karubigwei yaugurri møiløgøsrøn amrruppe, unai møskawane trenchibelø køn: —Ñui nimbasrbe kwabguen indan cha. ¿Kusrennøbigwan mas chinrrabrre øyeeg chigu?— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Inchen nøm trenchib kuingucha Jesúsbe trunun mørøb pasrømøtø, tru tulundzuni yau ashibigwane trenchibig køn: —Chi kørig kui inchimøtø, køreptø køreu— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Incha mas mungucha amrrubashmøwa, Pedronbah, Jacobonbah, Jacoboi nuneg Juanwanbatø amrrungarubig køn. ");
INSERT INTO gum_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Incha tru judíosmera tulundzuni yau ashibigwei yau puabe, ke chindi asamgaig misaabe kishib, miirab, trashib inchib kui ashabe, ");
INSERT INTO gum_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesúsbe kebya, trenchibig køn: —¿Chindimbarre øyeeg inchib, kishib køh? cha. Unøbe kwaig kømøtø, ka kiptø tsun— cha. ");
INSERT INTO gum_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Inchen misaamerabe Jesúswane ka indzatø mørøbelø køn. Inchen Jesúsbe mayeelan møi møi webambingarua, møskawanbah, usranbah, tru nøba ambubelanbatø pera ya, tru ishug-unø tsuinug kebya, ");
INSERT INTO gum_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","tasigu kemørabe, trenchibig køn: —Talita, cumi— cha. (Trenchippe: “Ishug-unø, ñun kurrø char” chib.) ");
INSERT INTO gum_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Inchene tru doce años tøga ishug-unøbe møi møi kurrappa, llirab mendøben, misaamerabe truba truba kwaara asha kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Inchen Jesúsbe mun køben eshkab kønrrab kømø cha, unan mamig srøttrai karubig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesúsbe truyugurri webya, katø nui pirausrømay iben, nui kusrenanøb pera uniiløbe nøba ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Incha isrin kwaløm pubene, Jesúsbe judíosmera tulundzuni yau kusrenanøb mendøben, møiløgøben mørøbeløbe truba kwaara asha, trenchibelø køn: —¿I møøbe kerrigube churre øyeeg kusreh? cha. ¿Iig nui øyeeg truba truba kusreibe chiguerah? cha. ¡Kan i møg nui tasiimeratøga maramburab mariilø yeekkucha kuita! cha. ");
INSERT INTO gum_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Iibe tru tsiimeratøga chine marøbig kømuitarru? cha, tru Maríai nusrkai. Katø ¿Santiagoimba, Joséweimba, Judasweimba, Simónweimba nøbe nuneg kømuitarru? cha. ¿Yamba nui nuchaløgucha yu namui ututøwei warabelø kømuitarru?— cha. Treekkurri nømbe nune chinetø cha mørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Inchen Jesúsbe trenchibig køn: —Chutøgucha peesrømbe Tius maig karuigwan eshkabigwane tab indan cha. Trune nui piraueløba, nømmisaameraba, nui yaueløbabe chi tab inchimøn— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Incha truyube maramburab marig chi martrab kaima, mamdø kwanrreelan nui tasiitøga estsara, trutøh tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Inchen Jesúsbe yeekkucha køremø misaamera kønrrabmab ke kwaara ashibig køn. Incha Jesúsbe tru puluwan yamera tsitsø pønrrabwan kusrenanøb uñibig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Incha nøbe nui doce kusrenanøb pera uniilan wama, pagatø, pagatø ørøb menda, trømbøig maringarub kwaimandziimeran mu chindamgaig marøb amrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Incha treeg karubig køn: —Mayuweimbe chigucha sruammønrrain cha. Kan pøtønain tsiitø srua amrrain cha. Pirri srua ammøwei, wasr ila ammøwei, pørønailøyu an pusra ammøwei inchain cha. ");
INSERT INTO gum_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Alpargatistø keeta amrrain cha. Pala itøgueikkucha yunømaramiba kømøtø, kandø kewa amrrain— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Incha Jesúsbe katø trenchibig køn: —Ñim kan yau kebambuppe, tru puebloyugurri ambamnegatig kørrømisrtrigay cha. ");
INSERT INTO gum_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Inchen ñimun wamømøwei, ñimun mørøg kømui indinuube, trube, tru puebloyugurri webamrrappe, ñimui srøbyu usrøwan chishtø kørrøgønrrigay cha. Treeg marøppe, trube: “Ñim kaasig købene, møimbe ñim kusrenrrigay” chib eshkab.— ");
INSERT INTO gum_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Inchen nømbe webamba, misagwan: —Ñim kaig mariilan isua mørøb, Tiusweimay lliray— chib eshkab kusrenanøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Incha misagweinukkurri kwaimandziimeran truba yam webetab, truba yam kwanrreelan aceite srøla, tamarøb inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rey Herodesbe Jesúswan wamindi mørøbig køn, kaguende Jesúswei munchiwane misaamerabe nun, nun waminchib køben. Inchen møiløbe trenchibelø køn: —Juan Bautista kwailai utugurri katø kurriinrrun cha. Incharre tru maramburab øyeeg maramig tøgaig kuinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inchen katøganeløbe trenchibelø køn: —Tius maig karuigwan eshkabig Elías kuinrrun— cha. Inchen kaneløbe: —Nøbe Tius maig karuigwan eshkabig kuinrrun, chibelø køn, tru møikkøben merrabsreelø lataitøwei.— ");
INSERT INTO gum_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Inchen Herodes trunun mørabe, trenchibig køn: —Iibe Juan, na tru turwan paringaruig kuinrrun cha. Møimbe kwailai utugurri katø kurriinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kaguende Herodesbe tru Juanwane kemøringarua, kailan keeri yau lusra wanningaruig købig køn, tru nui nuneg Felipei srai Herodíaskurrindø. Tru Herodíasbe Herodeswei nuneg Felipei srain købig køn. Inchen Herodesbe truigwane nui srai marin køben, ");
INSERT INTO gum_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juanbe Herodeswane trenchibig køn: —Ñi ñui nunewei srawan ñui srai mara tøgagømibe merig pasran— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Inchen tru ishug Herodíasbe Juanwan tsalø køptø kwetchab inchendø, kaimabig købig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kaguende Herodesbe Juanwane sølgandø tabig, katø Tiusweindø tarømari møg kwaasha, køriimata, trugurri nune mu chinchimønrrai ashib tøgagøbig køn. Incha Herodesbe Juan wamindigwane mandøguen kømui inchendø, tammay ka mørøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Indiibe Herodíasbe Juanwan maig maramigwan yandø treeg maramdiig puin kui ashibig køn. Kaguende Herodesbe tru chiwangucha nøm asha karubelaimba, suldaumeran karubelø nørreelaimba, Galilea mas kusreb møguelaimba nui kal-lain kwalømwan isub kasrag waram kwaløm tabig maren, ");
INSERT INTO gum_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","møimbe Herodíaswei nimbasrbe truyu kebya, pailaben, Herodeswanba, truyu mab purrabelanba tru pailaibe truba tabig asønaben, reybe tru srusrane trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","—Ñun chi miag købendø, miarra cha. Na tranrrumøn cha. ¡Katø! ñune tranmø kømø, nabe trunun tranamønrrun chib. Ñi chi miaben, tranrrumøn cha. Na muburab ashib karub waigwan tøbøtakkatikken tranrrumøn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Inchen nimbasrbe webya, usran: —¿Chi miamø?— cha payen, usri Herodíasbe trenchibig køn: —Juan Bautistai turwan miau— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Inchen tru srusrøbe tru urastø tru rey waisrø petøzhiitø kebyabe, trenchib miabig køn: —Møindøwei Juan Bautistai turwan kan platilloyu trannrra— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Inchen reybe truba truba isui inchendø, tru mayeelø lincha purrabelai malau ‘treeg tranrrumøn’ cha, trannrrab misrig køppe, tru miaigwan ka chimø, ka tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Incha tru urastø reybe kan suldauwan Juanwei turwan para, srua arringaruben, ");
INSERT INTO gum_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","truibe tru kailan keeri yaumay ya, Juanwei turwan para, kan platilloyu srua arruabe, srusran tranen, nøbe usran tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Inchen Juanwei mendig amøñibelø iigwan wammørabe, amrrua, nui asrwan kusrua, srua amba sørabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Inchen Jesús nøashib karua øriilø katø amrrua, nøba tulundzuna, nøm chi marigwanba, kusrenanigwanba kerriguh eshkaben, ");
INSERT INTO gum_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesúsbe trenchibig køn: —Nøørøsrø mu misakkasrø kuchi isrønrrab ñimbe amrruy— cha. Kaguende menrra misag køptø amben, amrruben inchen, nømune mab purramikken nebumíig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Incha Jesúsba, nui nøashib karua øriiløba nømdø kan barcoyu mu misakkasrømay ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Inchen møiløgøben nøm amben asha, Jesúswan mu kui nebua asha, chu puebloyuelø køben trusrømay lula, nømmerrig pubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Incha Jesús barcoyugurri pinaya, truba nu misag pasrai ashabe, lastima isui inchibig køn, kaguende nømbe ubishamera mu ashchabig chigar latailø køben. Incha chine truba kusrenanøb mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Inchen yandø menrra maaben køben, nui kusrenanøb pera uniiløbe Jesúswan kemallabe, trenchibelø køn: —Yube mu misakkanug køn cha. Inchagucha yandø kwa maaben køn cha. ");
INSERT INTO gum_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Misagwan amrrai, ‘ungwa’ chi cha, chugøben nøørøsrøn køben, puluwandø yamera pønrrabsrøn køben amba, nømuyasig chigøben pena manrrain— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Inchen Jesús løtappe trenchibig køn: —Manrrai ñim mannay— cha. Inchene nømbe trenchibelø køn: —¿Manrrai mannamig kan møg doscientos días ørøba marøb megawa an pagaraig utiitøga pirrim penønrrab ambam nebunrrautah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Inchen Jesúsbe trenchibig køn: —¿Ñimbe mam pirrin tøgagøgue? cha. Ashchab ambay— cha. Inchen nømbe ashabe, trenchibelø køn: —Trattrøgatø pirrimbah, pagatø peskaubatø tøgaguer— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Inchen Jesúsbe misaameran kan søtø, kan søtø pillim pubilayu purramisringarubig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Inchen kan søtømørig cienbatø, cienbatø purramisren; kan søtømerabe cincuentabatø, cincuentabatø purramisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inchen Jesúsbe tru trattrøgatø pirriwanba, pagatø peskaumeranba nui tasku muta, srømbalaneb neesha, Tiuswan ‘mayanguen pay’ chabe, pirrimeran pirisha, nui kusrenanøb pera uniilan misagwan pirishinrrai trana, katø tru pagatø peskaumerangucha mayeelan pirishinrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Inchen mayeeløba øska ma kørrømisren, ");
INSERT INTO gum_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","tru pirrim pitis, peskau pitis pirisaig undailan tasinmerayu tulishiben, tasinmera doce netsabig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Inchen tru pirriwan mabeløbe møgueløtø trattrø mil købig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Incha tru urastø Jesúsbe nui kusrenanøb pera uniilan pisu ambøgatø Betsaidasrømay merrab amrrai barcoyu nebambingarubig køn, nø tru nu søtø misagwan ‘ungwa’ chib pasrappatø. ");
INSERT INTO gum_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Incha yandø misagwan chab ‘ungwa’ chabe, tunsrø Tius Møskaimba waminchab ibig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Incha yem køben, barcobe chabguen pisu tøbøtaasrønguen iben, Jesúsbe nøtø pirau kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Inchen kaguen isiibe nømui malaugøba megambub ichen, nømbe barcoyu amrrab kaima, muraaraig remab melai ashib pasrabig køn Jesúsbe. Incha løtsøzhig yemdø nøbe pi palawan katsikka nømuimay kemallib ya, purab inrrab lataig inchen, ");
INSERT INTO gum_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","pi palawan arri ashippe, nømbe møsig kønmab isua, trashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kaguende mayeeløba ashagurri purø trømbøig kørig kui inchen, Jesúsbe møi møi nømune waminchib trenchibig køn: —¡Kørmø, mur isua purray! cha. Na kur cha. Kørig kui inchimøtay— cha. ");
INSERT INTO gum_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Incha nø barcoyu nebibene, isiibe wasrøngandø pasramisrøptinchen, kan øyeebe chi maig kermab nømbe truba kwaarøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kaguende tru pirriwan øyeeg marigwanma katøgucha nømbe tab chigúi mørmøwa kørrømisrin købig køn, larrø mur manrrømera tøgar srø kua. ");
INSERT INTO gum_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Incha yandø tru pisuyu chab larraamba, Genesaret pirausrø pua, truyu barcon pi menda licha pasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Incha barcoyugurri nøm webamben latatø, misaamerabe Jesús kui nebua asha, ");
INSERT INTO gum_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","nømbe tru pirau truørø lula, Jesús chu wan taig mørøppe, trusrømay kwanrreelan tsigalyu muta, amrrub mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Inchen Jesúsbe yamera tsitsø pønrrabsrø, pueblomerasrø, wambig nøørøsrø chugøben kebibene, penab, yanøb indiisrø kwanrreelan wara: —Ñi pala itøguewa kuig urøzhigwandøguen namun katørabashcha— chib, Jesúswan rugabelø køn. Incha mayeeløba katørabeløbe yandø tamariilø kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Inchen fariseosmeraba, Jerusaléngurri amrrubelø møiløgøsrøn tru Moisés pørigwan kusrenanøbeløbabe Jesúsweim pulu kemallibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Incha truiløbe Jesúswei kusrenanøb pera uniilø møiløgøsrøn nømui tasigwan kinømø mai ashibelø køn, tru kaigwan chish misrøb chib, tasig kinigwan. ");
INSERT INTO gum_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kaguende fariseosmeraba, maya judíosmeraba merrabsreelø maig marøb, amrruilane ke tindøga pønrrabelø kua, maig taigwan tasigwanmerrig kinømuppe, mameelø køn. ");
INSERT INTO gum_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Katø penab, yanøb indiisrøngurri amrrua chigucha, tru tasig kinønrrain taigwan kinømuppe, mameelø køn. Katø nømbe chigøben katøgan trendø treeg mariilan pesannamø marøb tøgagøbelø kuabe, mutsim pasumeran pillmab, katø køtsømeran, tsandzøn nindaameran pillmab, manrrab purramisriilan chishmarøb inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Incha fariseosmeraba, katø tru Moisés pørigwan kusrenanøbeløbabe Jesúswan trencha payibelø køn: —¿Ñui kusrenanøb pera uniiløbe namui merrabsrø kølleeløgurrimbunø trendø treeg marøb amrruig købigwan treegwan marøb amøñimøtø, kaigwan chish misrøb tasigwan kinømø, maptø manrrappe, chindimba treelø køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Inchene Jesúsbe trencha løtabig køn: —Tru Tius maig karuigwan eshkabig Isaíasbe ñim palatø tabelaimburab maig kønrrabigwan kanmaytø trenchippe, sølwein tain køn cha, øyah chib pørøppe: I misaamerabe nane ka triitøgatø tab inndan cha. Inchendø nømui manrrøbe nainukkurrimbe yab pønrran cha. ");
INSERT INTO gum_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nan køriibala tabig waminchib taibe chiweingucha chi tabig marig kømøn cha, møguelø martrai karua pønsrailan øyeeg maramig køn chib kusrenanøb. ");
INSERT INTO gum_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kaguende ñimbe Tius maig maramigwan martrai pønsraigwan elacha, møguelø ka trendø treeg marøb tøgagúilangøba kebasrøbelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Incha katø Jesúsbe trenchibig køn: —Ñimbe ñim trendø treeg marøb kuilan tøgagøbig tøgagug køptø, Tius maig maramigwan martrai pønsraigwane elachippa, møguelø marøb amrruigwangøba marøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","’Kaguende Moisésbe trendaig køn: “Ñui møskai, ñui usrane maig købash inchimø, tab indamig køn” cha. Katø: “Møskawan kui, kabe usran kui trømbøig nebunrrai wamabigwane trunune kwanrrai pasrig kønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Trune ñimbe trenchibelø køn: “Kan møøbe møskawan kui, kabe usran kui trenchinrrun cha: ‘Na ñimun purugumig tøgagúibe Korban køn cha, (trenchippe, “Tiuswan keta, tranig køn” chib) ñimune purugunrrab kaymamønrrun’ chinrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Treeg chippe, yandø ñimbe usri møskawane isua ashib purugumibe chi palømøn tan cha. ");
INSERT INTO gum_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Treekkurri Tius martrai karua pønsraigwane chigucha kømíig kui lataig mara srua køn cha, ñimui kusrenaniilø kanun kanun puraarrub arrubiitøga. Incha ñimbe katøgan øyeelø latailøtøwei truba marøbelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Incha katø Jesúsbe misagwan nuimay wama, trenchibig køn: —Ñim mayeeløba nan mørøb, katø chigúi mørøb inday cha. ");
INSERT INTO gum_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Chitøgucha møwan wambikkurri kebibiibe truigwane kaig trømbøig marøb mindishinrraamøn cha. Møwei manrrøyugurri webarrubiibe sí, nun trømbøig marøb mindishibwei indan cha. ");
INSERT INTO gum_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Møikkøben møramig kalu pønsraig kuabe, mør!— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Incha Jesús misagwan tarømisra, kan yau kebiben, nui kusrenanøb pera uniiløbe: —¿Tru ‘øyeeg lataitøwein køn’ chib kemesra kusrenanigwan chi chibig køh?— cha payene, ");
INSERT INTO gum_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","nøbe trenchibig køn: —¿Ñimgucha chigúinguen mørmøwa pønrrøtirru? cha. ¿Møwan chitøgucha wambikkurri kebibiibe kaig trømbøig marøb mindishimíig kui ashmeelø køtirru? cha. ");
INSERT INTO gum_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kaguende manrrau kebimøtø, patsau kørraya, katø asrugurri webinrrun— cha. Iigwan øyah chippe, chi mamitøgucha kaig marmíig ‘chishelø’ køn, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Incha katø Jesúsbe trenchibig køn: —Møweinukkurri webarrubiibe sí, nune kaig trømbøig marøb mindishibwei indan cha. ");
INSERT INTO gum_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kaguende umbu manrraugurri webarrubiibe sí, kaig isuilø køben, ishumburba, møgueløba trømbøig maramelø køben, nilamelø køben, kweetsamelø køben, kasharawarmera peeba itølulamelø køben, ");
INSERT INTO gum_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","katøganuiwan tøgagønrrab isumelø køben, trømbøig kaig maramelø køben, may wamincha isamelø køben, chine kaig marøg købiitø srua yaig kømig køben, chigurrin køben pusrkwai asamelø køben, chi purayailan trømbøig wam kusramelø køben, ke purø nuig kømmørø indamelø køben, chugúi mørmíig lataig unamelø køben werrun cha. ");
INSERT INTO gum_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iiløbe si, kerriguba umbugurri webarrubig kua, møwan kaig trømbøig marøb mindisha kørrømaran— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Incha Jesúsbe kurra, truyugurri Tiroba, Sidónba, tru ciudamera pønrrab piraumayba yabe, kan yau kebya, mugucha wammørmønrraimab isubig køn. Inchendø trubønrrab kaimabig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Inchen trømbøig maringarub kwaimandzig kebyainab ishug-unai usri, tru urastø wammørabe, arrua, Jesúsweim pulu tømbønsrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tru ishuube griega Sirofenicia pirausriig købig køn. Truibe arrua, nui nimbasrweinukkurri kwaimandzigwan wegutcha chib, Jesúswan miab megaben, ");
INSERT INTO gum_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesúsbe trenchibig køn: —Nusrkalømerrig pirriwan mamne mabash cha. Kaguende pirriwan uregwan kerrawa, wera-ureezheelan kebusramibe søl kømøn— cha. Inchene ishuube trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Øø, Señor, pøs treebe treegwein køn cha. Inchendø tru mishatsig umbu wera-ureezheeløguen pitischigwan man cha, nusrkalø kørrøgaigwan.— ");
INSERT INTO gum_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Inchen Jesúsbe trenchibig køn: —Ñi ya may isua tab løtiitøgabe, møimbe inrrø cha. Tru kwaimandziibe ñui nimbasrweinukkurri webyainguen køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Inchen nøbe yau pubene, kwaimandziibe unainukkurri webyainguen køben, nui nimbasr-unøbe camayu tsuin købig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús katø Tiro piraugurri webya, Sidónwansrø pureb ya, trugurrimbe Decápolis pirau pueblomerawan puraarrub arrua, Galilea nu pisuyu pubig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Inchen truyube kan møg kalu mørmøwei, tør waminchimøwei inchibigwan srua amrrua, truba inchibelø køn: —Ñui tasigwan nuim pala estsarøbsrumuguh— chib. ");
INSERT INTO gum_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Inchen Jesúsbe menda nøørøsrø pera ya, tasig-uregwan kalumerayu keera, illimbi tucha, niløwangucha katørawabe, ");
INSERT INTO gum_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","srømbalaneb neesha, nu israbe, trenchibig køn: —¡Efata!— cha, (trenchippe, “¡Kur!” chib). ");
INSERT INTO gum_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Inchene tru mørtrab kaimabigwein kalumerabe møi møi kuren, nilø kemendikkucha kønab tammisren, yandø tab waminchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Inchen Jesúsbe nømune mungucha waminchimønrrain karua, maya eshkamønrrain taingucha, nømbe masken wam larrøbichibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Incha misaamerabe truba kwaara ashib trenchibelø køn: —Chiwandøgucha nøbe tab maran cha. Kalugarwanguen møringarub, waminchimeelanguen wamindingarub indan— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tru kwalømmerawan misag truba nu tulundzuna pasrøben, mamibe chigucha kaaben, Jesúsbe nui kusrenanøb pera uniilan nuimay wamabe, trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Misaameran lastima køtan cha. Chabguen yu pøn kwalømguen naba warøwa, yandø chi mamig chigar køn cha. ");
INSERT INTO gum_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Chi mameelan na nømui yamay ka ambashendøbe, mayu parøgwab chab pesannanrrun cha. Kaguende kan utueløbe yabsrøngurri amrruar køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Inchen nui kusrenanøb pera uniiløbe trencha løtabelø køn: —¿Yu ya mu misag warømønuube pirri manrrai nømun chincha srøttrab?— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Inchen Jesúsbe trencha payibig køn: —¿Ñimbe mam pirrin tøgagøgue?— cha. Inchen nømbe løtappe: —Siete tøgaguer— chiben, ");
INSERT INTO gum_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesúsbe misagwan pirau purramisringarua, nui tasku tru pirri sieten muta, Tiuswan ‘mayanguen pay’ chabe, pirisha, nui kusrenanøb pera uniilan tranen, nømbe misagwan pirishibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Katø peskau-urekkucha mamdø tøgagøben, Jesúsbe trunun Tiuswan ‘mayanguen pay’ chabe, katø trunungucha misagwan pirishinrrai karubig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Inchen mayeeløba øska ma kørrømisren, katøgucha pitis undailan tasinmerayu netsøbateelø siete tulishibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Inchen tru mabeløbe pib milburab købig køn. Incha Jesúsbe misagwan ‘ungwa’ chabe, ");
INSERT INTO gum_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","nui kusrenanøb pera uniiløba barcoyu kebya, Dalmanuta pirausrømay ibig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Inchen fariseosmera amrruabe, Jesúswan ‘¿øyeebe maig køh?’ chib payib menda, nune srømbalasrøngurriigwan asamig martrai miabelø køn, Tius nøba pasrain kui ashchab, ke chinchibig køtashchab ashig køptø. ");
INSERT INTO gum_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Inchen Jesúsbe truba isui inchib, nu israbe, trenchibig køn: —¿Møin kwaløm misaamerabe Tius naba pasrain kui ashchab chindimba maramig miah? cha. Nabe ñimun cierton trendamønrrun cha: Møin kwaløm misaameran ashig kui indigwane chigucha marig kømønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Incha nøbe nømun pønrramnetø, katø barcoyu kebya, pisu ambøgatøsrømay ibig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Inchen nui kusrenanøb pera uniiløbe pirri srua amrrumigwan pesan amba, barcoyube pirri kandø tøgar purrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Inchen Jesúsbe nømune trenchib eshkabig køn: —Au, ñimbe levadura fariseosmeraiwanba, saduceosmeraiwanba ashiptø kuy— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Inchen nui kusrenanøb pera uniiløbe kangurrin kangurri trenchibelø køn: —Kaguen nam pirrin chigar kuimba, nøbe trendan— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Inchen Jesúsbe nøm trenchib purrai ashabe, trenchibig køn: —¿Chindimbarre ñimasiyaitø ‘pirringar ker’ chib purrøgue? cha. ¿Katøgucha ni chigúinguen mørmøwei, chiwan wamindinguen mørmøwei inchigueh? cha. ¿Katøgucha ñimui manrrømerane mur mara tøga pønrrøtirru? cha. ");
INSERT INTO gum_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ñimbe kabmera tøgar købendø ashmøwei, kalumera tøgar købendø mørmøwei inchigue? cha. ¿Yamba isumuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tru na trattrøgatø pirriwan trattrø mil møguelan pirishib urasma tasinyu netsøbatø ñimbe ¿mam tasin tulisaig køh?— cha. Inchen nømbe løtappe: —Doce— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Inchen Jesúsbe trenchibig køn: —¿Tru na siete pirriwan pib mil misagwan pirishib uras chigucha netseelø mam tasin tulisaig køh?— cha payene: —Siete— chibelø køn: ");
INSERT INTO gum_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Inchen nømune Jesúsbe trenchibig køn: —¿Inchendø katøgucha chigúi mørmøwa køtirru?— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Incha Betsaida pueblosrø pubene, Jesúsweimay kan kab ashmíigwan srua amrrua, kabyu katørabsrumugu chib, meløben, ");
INSERT INTO gum_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","nøbe nun tasku kemøra, puebloyugurri wambiisrø srua ya, kabyu illimbitøga srøla, nui tasigwan kabgaigweim pala estsarabe: —¿Maytøguen ashkuh?— cha payibig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Inchen tru møøbe ashabe, trenchibig køn: —Møguelan ashar cha. Tusrmera latailø købendø, amønan— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inchen Jesúsbe katøyug nui tasiimeran kab pala estsarabe, nune asingaruben, yandø tabig ashibig kørrømisra, chiwandøgucha tørgandø nebua ashibig misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Inchen Jesúsbe nui yamay ørøppe, trencha ørøbig køn: —Puebloyu kebimøwei, truyu mungucha eshkamøwei inchig— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Incha Jesúsbe nui kusrenanøb pera uniiløba Filipo pirau Cesareasrø yamera tsitsø pønrrabsrømay webamba ambabe, mayu nømun trencha payibig køn: —¿Misaamerabe nane mu køn tah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Inchen nømbe trencha løtabelø køn: —Møiløbe Juan Bautista køn chiben; katøganeløbe Elías køn chiben; møiløbe møikkøben Tius maig karuigwan eshkabig kuinrrun tan— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Inchen Jesúsbe trencha payibig køn: —¿Trune ñimbe nane mu køn chinrrague?— cha. Inchene Pedrobe trencha løtabig køn: —Ñibe Cristo køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Inchen Jesúsbe nømun mungucha eshkamønrrain karubig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Incha nø tru Møg Misra Arrubiibe truba truba kaig indinab megamig nebunrrun chib, kusrennøb mendabig køn. Misagwan karubelø kølli misaamera køben, sacerdotesmeran karubelø køben, tru Moisés pørigwan kusrenanøbelø køben nune kaasig kømig nebunrrain køn chib. Nune kweechen, pøn kwalømyube øsiiranrrun chib. ");
INSERT INTO gum_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iigwane Jesúsbe nømune tørgandø eshkabig køn. Inchen Pedrobe nun nøørøsrø pera ya, murtø waminchib mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Inchen Jesúsbe keesha asha, nui kusrenanøb pera uniilan ashabe, Pedrone trenchib namabig køn: —Satanás, ¡nainukkurri tarømisr! cha. Kaguende ñibe isuppe, Tius lataig isumøtø, møguelø isuimay isun— cha. ");
INSERT INTO gum_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Incha Jesúsbe nui kusrenanøb pera uniilanba, misagwanba wama, trenchibig køn: —Møikkøben nai mendig uñig købene, nøasiitø nuimburabigwangøba isumøtø, nui kuruswan mutab, nai mendig arrum nebunrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Inchen møikkøben øsig kømigwangøba esegabiibe yandø pinab pinamig nebunrrun cha. Inchen nagurrimba, Tiuswei tabig srø wamgurrimba kwabiibe, managatig øsig kømigwan esegawa tøgagønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Kan møg yu pirau chine købigwan kerrigu nuindø maringucha, nui øsig kømigwan trubisaibe, chiwein kui tabig kønrrab kø? cha. ");
INSERT INTO gum_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Kabe kan møøbe kwamønrrappe, chi tranøbsruerah? chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Inchawei møikkøben i møin kwaløm misaamera itøluløpteelø, kaig marøb misaamerai merrab naimburappa, na wamindiilaimburappa kørig isub kørig kui inchibigwane, nungucha kørig purørtrun, chibig køn, Møg Misra Arrubig tru nui Møskawei tørguegwalmabigu Tiusweindø tarømari ángelesmeraba arrua.— ");
INSERT INTO gum_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Incha Jesúsbe katø trendaig køn: —Nabe ñimun cierton trendamønrrun cha: Møiløgøben yu purrabelø Tius nø ashib karub waig maramburab marøb arri ashmøwatøbe kwanrraamøn— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Øyeeg taig yandø trunewei kan kwalømdø paløben, Jesúsbe Pedronba, Santiagonba, Juanwanba nømundø kan pala tunsrømay pera ibig køn. Incha trusrø nømui merrab Jesúsbe ke peg lataig misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Inchen nui kewagúiløbe pulø tørchig tør pilabig misrøbig køn, muguen i pirau kewagúigwan tsara, øyeeg puløzhig mariinrraamønikke. ");
INSERT INTO gum_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Inchen Elíasba, Moisésba kenamisra, truiløbe Jesúsba waminchib pønrrai nømbe ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Inchen Pedrobe Jesúswane trenchibig køn: —¡Kusrennøbig, nam yu pønrramibe purø tab køtan! cha. Pøngatø ya-ureg margun, chibig køn, kan ñui, kan Moiséswei, kan Elíasweingue.— ");
INSERT INTO gum_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kaguende nømbe kwariilø pønrrøwa, Pedrobe ni chi chib pasrarmabguen isumíig køn. ");
INSERT INTO gum_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Inchene kan wañi nømun pinøbulen, wañi umbugurrimbe kan wam trenchibig køn: —Iibe nai Nusrkai undaaraig køn cha. Nune møray— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Inchen møimbe nømuim pøtøgatan ashene, mu katøgan peebe nømba kenamuptinchen, Jesústø pasrai ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Incha tru tunsrøngurri kørrørrub amrruabe, Jesúsbe trencha karubig køn: —Mungucha waminchib kønrrab kømø cha, tru ñim asigwane, Møg Misra Arrubig kwailai utugurri katøle øsiiramnegatig.— ");
INSERT INTO gum_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Inchen nømbe truigwane nømuinetø isub esegabendø, tru kwailai utugurri øsiiramnegatig taigwane, treebe mandø cha trendermab nømdø payiyabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Inchabe Jesúswane trencha payibelø køn: —Tru Moisés pørigwan kusrenanøbeløbe ¿chindimba Elíasmerrig arrumig køn tah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Inchen Jesúsbe nømun trencha løtabig køn: —Elíasmerrig arrubwei inchun cha, kerrigu katøyug tamara kørrømartrab. Katø Tiuswei wamwan pørigube tru Møg Misra Arrubiibe truba kaig indinab, kaasinab indig kønrrun chippe, ¿mandøgurrin trendah? cha. ");
INSERT INTO gum_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Inchendø nabe ñimune trendamønrrun, chibig køn: Elíasbe manawei arrubguen inchen, nømbe maig marøg købendø nun kerrigu treeg marig køn cha, Tiuswei wamyu Elíasweimburab maig taig treekke.— ");
INSERT INTO gum_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Incha nømbe katøle nui kusrenanøb pera uniilø purrainuumay amrrubene, nømune misag truba nu pøtøgatan tulundzuna kuin købig køn. Inchen truyube katø møiløgøsrøn tru Moisés pørigwan kusrenanøbeløgucha Jesúswei kusrennøb pera unielane øyeebe maig kø chib kuin købig køn. ");
INSERT INTO gum_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Incha Jesúswan ashippe, maya misaaba truba kwaara ashib ‘manguen attirru’ chinrrab luløbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Inchen Jesúsbe trencha payibig køn: —¿Nømbabe chi køn chibrren køgue?— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Inchen møikkøsrøn tru nu misag utu pasrabiibe trenchibig køn: —Kusrennøbig, yu nai nusrkawan kan kwaimandzig waminchimíig marig srua arrur cha. ");
INSERT INTO gum_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chugøben pasrøben, kwaimandziibe kemøra, pirausrøn kuchen, nøbe triimay chall kuchib, trugulwan tsachib ¡katø! tinrranrrig misrøbig køn cha. Inchen nabe ñui kusrenanøb pera uniilan kwaimandzigwan wegutcha chiben, nømbe kaiman— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Inchene Jesúsbe trencha løtabig køn: —¡Kan møi misaamera øyeebe mailø kwaasamø cha, chigucha køremeeløbe! ¿Nabe managatig ñimba unamig kønrrerah? cha. ¿Kan øyeeg ashiptø managatig ñimba unamerah? cha. Unan naimay srua amrruy— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Inchen srua amrruben, kwaimandziibe Jesúswan ashippe, unan møi møi purø trømbøig sruaguchen, unøbe pirau peña, latøgushib triimay chall kuchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Inchen Jesúsbe møskawan trencha payibig køn: —¿Øyeeg indiibe maya yana køh?— cha. Inchen møskaimbe trenchibig køn: —Unøgurri treeg kuig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Katø katø kwaimandziibe kwetchab nagu kui, piyu kui keguchibig køn cha. Ñi chi maramdiig købene, namun øyeeg kui meløben lastima asha, purugurra— chiben, ");
INSERT INTO gum_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesúsbe trenchibig køn: —Ñibe: “Chi maramdiig købene, martra” taibe cha, pøs, ke treeg martraitamab kørebigweimbe chitøgucha maramdiitø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Inchen tru urastø unai møskaimbe øyah chib trashibig køn: —¡Treeg martraitamab kører cha. Kørenrrab inchimíig kømønrrab purugurra!— chib. ");
INSERT INTO gum_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Inchen Jesúsbe misag ke kanbalatø tulundzunab amrrui ashabe, trømbøig maringarub kwaimandzigwan trenchib namabig køn: —Kwaimandzig wamgaig, kalugaig, na ñun i unainukkurri møi møi webinrrø tamønrrun cha. Katøbe yandø nuinug kebarrumønrrabgue.— ");
INSERT INTO gum_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Inchene kwaimandziibe trashib, unan purø trømbøig sruagucha, webiben, unøbe kwaig lataig kørrømisren, møiløgøben trenchibelø køn: “Kwain tsun” cha. ");
INSERT INTO gum_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Inchen Jesúsbe kwalyu kemørøb kusrabene, unøbe pasramisrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Incha Jesúsbe yau kebibene, nui kusrenanøb pera uniiløbe nundø trencha payibelø køn: —Nambe kwaimandzigwan wambig weguchappe, ¿chindimba kaimah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Inchen Jesúsbe trenchibig køn: —Øyeeg kwaimandzigwane Tiusba waminchib miawatøwei weeramig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Incha truyugurri ambabe, Galileawan puraambub amba, Jesúsbe mugucha wammørmønrrai inchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kaguende nui kusrenanøb pera uniilan trenchib kusrenanøb arrig køn: —Tru Møg Misra Arrubigwane møguelai tasku tranen, nømbe kwetchun cha. Inchendø kwaig pøn kwalømyube katø øsiiranrrun— chib. ");
INSERT INTO gum_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Inchen nømun treeg wamindigwane nømbe chi tainguen mørmøwa, payamibe kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Incha Capernaumsrø pua, Jesúsbe yau kebyabe, nui kusrenanøb pera uniilan trencha payibig køn: —¿Mayube chi charre payiyab amrrub køgue?— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Inchen nømbe chigucha løtømeelø køn, kaguende mayube nømui utube møig mas nuig kønrrerah charre payiyab kuig kua. ");
INSERT INTO gum_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Incha Jesúsbe wamisra, tru doceelan wamabe, trenchibig køn: —Møikkøben nømerrig merrab pasrag købene, mayeelai wendau pasramisra, mayeelø karuindiig megamig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Incha kan unan srua ya, nømui tøbøtag pasra, nui kwalyu mutabe, trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Møikkøben i unø lataigwan nai munchiyu tab wamab utabiibe, nan utan cha. Inchen nan utabiibe, nan utømø, nan karua ørøbigwan utan— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Inchene Juanbe trenchibig køn: —Kusrennøbig, kan møikkøsrøn ñui munchiyu kwaimandziimeran webusri aser cha. Inchendø namba uñibig kømubene, nambe truigwane merer— cha. ");
INSERT INTO gum_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Inchene Jesúsbe trenchibig køn: —Merømøtay cha. Kaguende mugøben kan maramburab marig nai munchiyu mara, katøburøbe nan trømbøig waminchaamøn cha. ");
INSERT INTO gum_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Namun namig kurrømíibe namuingatiig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nabe ñimun cierton trendamønrrun cha: Møikkøben ñimun Cristoielø kua asha, kan pi pasutøguen nai muchiyu ñimun srørrøbiibe, truburø nui ketigwane utømø kømø, utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Møigwan køben i shushmera latailan nan kørebelan kaig mara kebenøsrkøbigweimbe trembe tru tirigu kitsig nu srugwan naashigu iløsrka, mar umbusrø kegutsig kuinguen søl købsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pøs ñui tasig kaig maringarua kaigu ñun kebenøsrkøbene, par, chibig køn. Trembe managatig øsig wamsrø kan tasiitø tøgaig kebyamikken søl kønrrun cha, pa tasig tøgaig tru møra melamnug tru managuen kwamø naasrø kebibgunrriibe; ");
INSERT INTO gum_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","truyube nømui yau mab kushimera kwamøwei, katø nag managuen kwamøwei inchibsrø. ");
INSERT INTO gum_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","’Katø ñui srøb kaig maringarua kaigu ñun kebenøsrkøbene, trunungucha par, chibig køn. Trembe managatig øsig wamsrø kandarø srøbgaig kebyamikken søl kønrrun cha, tru møra melamnug pa srøppaig kegutsig købgunrriibe, ");
INSERT INTO gum_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","truyube nømui yau mab kushimera kwamøwei, katø nag managuen kwamøwei inchibsrø. ");
INSERT INTO gum_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","’Kabe ñui kab kaig maringarua kaigu ñun kebenøsrkøbene, trunun wesru, chibig køn. Trembe Tius nø ashib karub wainug kan kaptø tøgaig kebyamikken søl køn cha, pa kab pusraig tru møra melamnug kegutsig købgunrriibe; ");
INSERT INTO gum_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nømui yau mab kushimera kwamøwei, nag managuen kwamøwei inchibsrø. ");
INSERT INTO gum_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Kaguende mayeeløba tretøga larrøsrkøb lataitøwei naatøga larrøsrkailø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Trebe tabig køn. Inchendø yandø tre larrmíig misrene, ¿katøbe ñimbe chincha larrøbig martrague? Incha ñimbe ñimasiitø tre may larrig latailø kuy. Inchawei ñimbe ambugurri igurri lata tab waramig køn— cha, Jesúsbe trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesúsbe truyugurri webya, Judea pirausrømayba, Jordán pi ambøgatø pørr kal-labgatøsrømayba iben, katø trusrøngucha misaamera tulundzunab mendøben, nøbe trendø treeg marøbig kua, katø nømun kusrenanøb mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Inchen møiløgøsrøn fariseosmera Jesúswan kemallabe, trencha payibelø køn, maig inchibig køtashchab: —¿Keebe srawan kutsamig chi meriimíig kø, chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Inchen nømune trencha løtabig køn: —¿Moisésbe ñimune maig karuig køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Inchen nømbe trenchibelø køn: —Moisésbe ka tarømisriyabasig køn cha. Srawan treeg martrab cha, eshkabig kilga marabe, ka tarømisramig køn taig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Inchene Jesúsbe trenchibig køn: —Moisés treeg marbashippe, ñimui manrrømera isumíig larrø mureløgurri ka treeg martrai ñimun pørig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Inchendø srøsrø kwaløm chiwandøgucha marøb uras: “Tiusbe møwanba, ishuwanba ellmarig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Øyeekkurri møøbe møskawanba, usranba elatchun cha, nui sraimba kandø kønrrab. ");
INSERT INTO gum_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Incha tru pailøbe kan asrtø kønrrun” cha. Inchawei yandø pailø kømø, kan asrtø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Inchawei treeg købene, Tius kandø mara lindisaigwane møøbe tarømaramig kømøn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Incha yausrø purrøwabe, nui kusrenanøb pera uniiløbe trunun katøyug payen, ");
INSERT INTO gum_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesúsbe trencha løtabig køn: —Møikkøben srawan kucha, tarømisra, katøganba kasharabiibe nune itølula kørrømaran cha. ");
INSERT INTO gum_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kabe sraingurringucha kewan kucha, tarømisra, katøganba katø kasharawabe, treetøwei itølulan— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Inchen ureemeran Jesúsweimay srua amrrubelø køn, nø estsartrai. Inchen kusrenanøb pera uniiløbe tru srua amrrubelane namaptinchen, ");
INSERT INTO gum_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesúsbe trunun ashabe, nama, trenchibig køn: —Ureemerane merømø, naimay ka amrrubasay cha. Kaguende Tius nø ashib karub waibe nøm latailaiwein køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nabe ñimun cierton trendamønrrun cha: Møikkøben Tius nø ashib karub wainuguigwan kan unø lataitøwei utaptinchimíibe managuen truyube kebinrraamøn— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Incha nui kwalyu muta, tasigwan uregweim pala estsarabe, ‘mayanguen tabelø kønrrigay’ chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús nui maywan inrrab ibene, kan møg luløb arrua, nui merrab tømbønsrabe, trencha payibig køn: —Kusrennøbig tabig, ¿managatig øsig kømigwan Tius tranig tøgagønrrappe nabe chi maramerah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Inchen Jesúsbe nune trencha løtabig køn: —¿Chindimba nane: “tabig” cha wamøgu? cha. Tabiibe kandø køben, truibe Tiustø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ñibe Tius maig maramigwan martrai pønsrailane yandø ashibig køn cha: “Kweechimøwei, itølulømøwei, nilømøwei, katøganelaimburab isa waminchimøwei, may wamincha chiyugøben kebenøsrkømøwei, ñui usri møskawane maig købash inchimø, tab indamig køn” tailan.— ");
INSERT INTO gum_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Inchen tru møøbe trencha løtabig køn: —Kusrennøbig, nabe iilane kerriguh matsinø-unøgurri marøbig kur— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Inchen Jesúsbe tru matsinan tab ashabe, nun undag køptinchen, nøbe trenchibig køn: —Kan chigøsrøndø palan cha. Ya, ñui chi tøgagúigwan yana, waachameran tranø cha. Treeg marabe, ñibe srømbalasrømbe chigurrimbunø tøgagønrrun cha. Trugurrimbe arrua, nai mendig amø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Inchen tru møøbe øyeeg taigwan mørøppe, nui maløbe minchiptinchibig køn. Incha truba isui ibig køn, kaguen truba puaig kua. ");
INSERT INTO gum_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Inchen Jesúsbe pøtøburab ashabe, nui kusrenanøb pera uniilan trenchibig køn: —¡Tius nø ashib karub wainug puarmera kebambamibe truba murig kønrrun!— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Inchen nui kusrenanøb pera uniilø trunun mørabe, truba kwaaren, Jesúsbe katøyug nømun trenchibig køn: —Ñim nai ureezheelø, Tius nø ashib karub wainug kebambamibe truba murig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kan camelloguen tsusain kal trabyu illmø larrayandiig køben, kan puaibe Tius nø ashib karub waisrø kebinrrab kaimanrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Inchen iigwan mørabe, nømbe masken kwaara, nømasiyaitø trenchib payiyabelø køn: —Treeg købene, ¿kaigyugurrimbe mu kui wesraig kønrrautah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Inchen Jesúsbe nømun ashabe, trenchibig køn: —Møgueløbe iigwan martrab kaimanrrun cha. Trune Tiusweimbe, chi treeg kømøn cha. Kaguen Tiusweimbe chitøgucha maramdiitø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Inchen Pedrobe trenchib mendabig køn: —Au, nambe chi tøgagúigwan kerrigu elacha, ñui mendig amrruig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Inchen Jesúsbe trencha løtabig køn: —Nabe ñimun cierton trendamønrrun cha: Møikkøben nui yawan, nunelan, nuchalan, kabe usri møskawan, ureemeran, pirømeran nagurrimba, Tiuswei tabig srø wamgurrimba elachibiibe, ");
INSERT INTO gum_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","møi yu piraube cien piejes menrraguen yamera, nunelø, nuchalø, usral, nusrkalø, pirømera utønrrun cha, chigøbendø indinab melamig kuindøgucha. Inchen kansrømbe managatig øsig kømigwan utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Inchen møiløgøben møi ya yu pirau nømmerrig pønrrabeløbe trusrømbe srabe melønrrun cha. Inchen yu pirau srabe melabeløbe trusrømbe nømmerrig pønrrønrrun— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Katø Jerusalénmay nebambub amba, Jesúsbe nui kusrenanøb pera uniilai merrab ib pasrøbene, nømbe truba kwaariilø ambub køben, kaneløbe wendau kørig kuilø ambubelø køn. Inchen Jesúsbe katø tru doceelan nøørø wama, nun chi purainrrabigwan eshkab menda trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Au, nambe Jerusalénmay nebambub amber cha. Trusrømbe tru Møg Misra Arrubigwane sacerdotesmeran karubelanba, tru Moisés pørigwan kusrenanøbelanba tranen, truiløbe nune kwanrrai pasra, judíos kømeelan tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Inchen nune indzaashib, illimbi tuchib, ichib srua kua, kweechen, pøn kwalømyube katøle øsiiranrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Inchen Zebedeowei nusrkalø Santiagoba, Juanba, Jesúswan kemallabe, trenchibelø køn: —Kusrennøbig, namuyasig nam kan chigøsrøn mianrreender cha. Kan treeg marøbsrumuguh— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Inchen Jesúsbe trencha payibig køn: —¿Ñimuyasig chi maramig palain køgue?— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Inchen nømbe løtappe: —Ñi wainug tørguegwalmabiisrø namun kanun ñui kusrmay, kanun atsimay purrønnøbsrumuguh— cha trenchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Inchen Jesúsbe nømune trenchibig køn: —Ñimbe chi miab pønrrermabguen mørmøn cha. ¿Na tru copayu mutsam piwan kabe ñim muchib, katø nan treeg chine trømbøig nebub pinøbuløb arrubig na utamigwan ñim trunun utab inchague?— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Inchen nømbe løtappe: —Øø, maramønrrundø— chibelø køn. Inchene Jesúsbe trenchibig køn: —Na mutsim piwane ñimbe muchibwei inchun cha. Katø tru nan purø trømbøig nebub pinøbuløb arrubig na utamigwangucha ñimbe utabwei inchun cha. ");
INSERT INTO gum_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Inchendø tru kusrmayba, atsimayba purramigwane, na tranamig kømøn cha. Tru purramibe nøm purrønrrabelayasig tamariilaindø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Inchen tru nui kusrenanøb pera uniilø diezeløbe trunun mørabe, Juanwanba, Jacobonba namab mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Inchen Jesúsbe nømun wamabe, trenchibig køn: —Ñimguen ashen judíos kømø misaameran karub purrabeløbe nøm karub tøgagúilane maig købash inchib, ke nøm karub purran cha. Inchen truyu møguelø nørreelø nøm karub purrabeløbe mungucha manchinrraingaig karub purrabelø kui ashchai nømbe kenamaran cha. ");
INSERT INTO gum_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Trune ñimui utube ñimbe øyeelø kømumig køn cha. Treeg købgunrriibe, ñimui utu mas nuig kukkøbene, katøganelø karuindiig megamig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Inchen ñimui utu møikkøben ñimmerrig melag købene, mayeelø karuindiig megamig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pøs tru Møg Misra Arrubikken katøganelø nuyasig marøb melønrrai arrumøtø, nøguen katøganelayasig marøb meganrrappa, nø kwaitøga truba nu misagwan purøbagarawa, kaigyugurri wesranrrappa arrig køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Incha Jericósrø pua, Jesúsbe tru ciudayugurri nui kusrenanøb pera uniiløba misag truba nu peraig webya iben, kan kabgaig Bartimeo taig Timeowei nusrkai, ‘anzhig kettra’ chib, miab may menda wawabe, ");
INSERT INTO gum_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús nazaretsriig kemallib arri mørøppe, trashib mendabig køn: —¡Jesús, merrabsrø Davidwei Nusrkai, nan lastima ashcha!— chib. ");
INSERT INTO gum_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Inchen ke møiløgøben niløtø wanrrai namingucha, nøbe trenchib mas mur trashibig køn: —¡Merrabsrø Davidwei Nusrkai, nan lastima ashcha!— chib. ");
INSERT INTO gum_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Inchen Jesúsbe pasramisrabe: —Wamay— chiben, nømbe kabgaigwane trenchibelø køn: —¡Chi isumø, kurraptinchi! cha. Kaguende ñune wamab pasran— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Inchene nøbe nui tsina waigwan kuchib, pørtrappe, pasrambua, Jesúsweim pulusrø pubig køn. ");
INSERT INTO gum_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Inchen Jesúsbe trencha payibig køn: —¿Ñuyasig na chi maramig paløta?— cha. Inchen tru kabgaibe trencha løtabig køn: —Kusrennøbig, nai kabmera ashibig misrimbe køtan— cha. ");
INSERT INTO gum_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Inchen Jesúsbe trenchibig køn: —Inrrø cha, ñui isubigwan nainug pasriitøgatø, tabig kørrømisran— cha. Inchen tru urastø tru kabgaibe ashibig misra, Jesúswei mendig ibig køn maywan. ");
INSERT INTO gum_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yandø Jerusalénsrø chab pub amba, Betfagéba, Betaniaba pueblomerayu tru Olivos Tunsrø chab puabe, Jesúsbe nui kusrenanøb pera uniilø pailan trenchib karua ørøbig køn: ");
INSERT INTO gum_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Ø pinrrøguesrø yamera tsitsø pønrrabsrømay ambay cha. Trusrømbe pubyutø kan burro-unø muguen itøguaniimíig litsig wetørranrrabguen cha. Picha, srua amrrunrrigay cha. ");
INSERT INTO gum_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Inchippa møikkøben: “¿Chinchainchigue?” cha payene: “Señor palai indan cha. Katø petø pegutchun” chinrrigay— cha. ");
INSERT INTO gum_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Inchen nømbe ambene, burrobe mayu kan yaskab pulu litsig pasrain købene, nømbe pichen, ");
INSERT INTO gum_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","møiløgøsrøn truyu pønrrabeløbe trenchibelø køn: —¿Burrone chinchab pichigue?— cha. ");
INSERT INTO gum_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Inchen nømbe Jesús maig taigwan treeg løtøben, truiløbe ka sruambashen, ");
INSERT INTO gum_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","nømbe Jesúsweimay burro-unane srua amba, nømuim pala kewagúilan burron kayen, Jesúsbe itøguanabig køn. ");
INSERT INTO gum_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Inchen truba yamelø nømui pala kewagúilan maywan kayen, kaneløbe chugøben nøørøsrø kullag srarcheelø lutiicha, maywan kayen, ");
INSERT INTO gum_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","merrab amrrubelø lata, wendau amrrubelø lata trenchib trashibelø køn: —¡Hosanna! chib; ¡Señor Tiuswei munchiyu nø ørig arrubiibe mayanguen tab kuig køn! chib. ");
INSERT INTO gum_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Namui merrabsrø møskai David nø ashib karub waig købig arrubiibe mayanguen tab indig køn! chib. ¡Srømbalasrømbe Hosanna!— chib, trashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Inchen Jesúsbe Jerusalén pua, Tiuswei yau kebyabe, truyu chiwan køben ambumay imay tab ashabe, yandø maaben køben, Betaniasrømay nui doce kusrenanøb pera uniiløba ibig køn. ");
INSERT INTO gum_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Katø kwaløm Betaniagurri webamba, Jesúsbe parøgwai møra, ");
INSERT INTO gum_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","yabgurri kan higuera tusr ishiibaig pasrai ashabe, mamig niga tusr køtashchab ibene, tru higos nigam pølmera kømuben, ka ishiitø tøgaig wetørrabig køn. ");
INSERT INTO gum_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Incha Jesúsbe tru higuerane trenchibig køn: —Managuen ñuinukkurri mamig niguigwan muguen manrrab tamibe chi kaanrrun— cha. Inchen nui kusrenanøb pera uniiløbe nø trendaigwan mørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Incha nømbe Jerusalénsrø pua, Jesúsbe Tiuswei yau kebyabe, truyu yanøb, penab inchib warabelan wambig webetab mendaptinchibig køn. Katø misagwan an yunømarøb purraig mishatsiimeran utsøbetab, palomamera yanøbelø purraigwan utsøbetab incha, ");
INSERT INTO gum_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","katø mungucha truyube chigøben srua puramrramamíig køn. ");
INSERT INTO gum_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Incha trenchib kusrenanøbig køn: —Tiuswei wamwan pørigube trenchibig kømuitarru cha: “Nai tab yabe mayeelø chu pirausrø misaameraindøgucha Tiuswan wamindi ya køn cha wamig kønrrun” taig. Trune ñimbe nileelø warain trab marin køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Inchen sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløba mørabe, mandø incha kweetsamdiig køtashchab lab mendabelø køn, nun køriimata, kaguende maya misaamera Jesús kusrenanigwan ke kwaara asha køben. ");
INSERT INTO gum_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Inchen yandø yem køben, Jesúsbe nui kusrenanøb pera uniiløba ciudayugurri webya ibig køn. ");
INSERT INTO gum_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Incha katø løtsø truwan puraamben, tru higuerabe kutøgue srølbañau mul-lain kui ashabe, ");
INSERT INTO gum_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedrobe Jesús trendaigwan isua, nune trenchibig køn: —Au, Kusrennøbig, tru ñi kaig nebubash cha trendaig higuerabe chab mul-labguen indin køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Inchen Jesúsbe trenchibig køn: —Ñimui isubigwan ke Tiusweinuutø pasra pønrray cha. ");
INSERT INTO gum_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nabe ñimun cierton trendamønrrun cha: Møikkøben i tunwanma øyah taimbe: “Yugurri mendamisra, maryu kebeñ” cha. Incha nui manrrøyu treeg kømuptinchaitamab isumøtø, maig taig ke treeg marig kønrraitamab kørebene, treeg marig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Inchawei nabe ñimun trendamønrrun chibig køn: Ñim chiwandøgucha Tiusba waminchib miappe, chabguen trunun utabguen indermab kørewabe, ñimbe utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Incha ñim Tiusba waminchib pønrrappe, møigwan køben namig isuig tøgaguabe, nø kaig marigwan ulø paymønrrab, pesannamig køn cha, srømbalasrø wabig ñimui Møskaingucha ñimui kaig mariilan treetøwei ulø paymø, pesannaig kønrraimbe. ");
INSERT INTO gum_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kaguende katøgan ñimun kaig maren, ñimma pesannamø, ulø payene, ñimui Møskai srømbalasrø wabikkucha pesannamø, ñimui kaig mariilan ulø payrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Incha katøle Jerusalénmay amrrua, Jesúsbe Tiuswei yau llirab uñene, sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløba, misagwan karubelø kølli misaameraba nun kemallabe, trencha payibelø køn: ");
INSERT INTO gum_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Ñi mariilane mu karua pasriitøgarre margu? cha. Kabe ¿øyeeg maramelane mu karua pasrta?— cha. ");
INSERT INTO gum_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Inchen Jesúsbe trencha løtabig køn: —Na ñimun kan chigøsrøn payrrab inchar cha. Nan løtøbene, øyeelan martraimbe nan i mu mandamgaig marig chugurriig kuig na ñimun eshkarrumøn cha. ");
INSERT INTO gum_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juan misagwan piu umbu ulsrøb uniibe ¿srømbalasrøngurrin kuig kø chindah, kabe møgueløgurrin kuig kø chindah? cha. Løtørray— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Inchene nømdø trenchib payiyab mendabelø køn: —Trube, nam: “Srømbalasrøngurrin kuig køn” chibene, nøbe namune trenchinrrun cha: “¿Chindimba nune køremøgue?” cha. ");
INSERT INTO gum_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kabe: “Møgueløgurrin kuig køn chinrrab ashendø, ¿maig købsruerah?”— cha. Øyan chippe, kaguende nømbe misagwan kørig isuarre inchibelø køn, kaguende mayeeløba Juanwane cierton Tius maig karuigwan eshkabig kui asha tøgagøbelø køben. ");
INSERT INTO gum_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Treekkurri Jesúswane trenchibelø køn: —Maig kuindøbeh— cha. Inchen Jesúsbe trenchibig køn —Trube, nagucha eshkamumønrrun cha, iilan na mu karuitøga marigwan.— ");
INSERT INTO gum_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Incha Jesúsbe ‘øyeeg lataitøwein køn’ chib kemesra wamindiiløtøga eshkab menda, trenchibig køn: —Kan møg nuim pirau uvas tra mara, trugurrimbe panig pasra, uvas piwan wesrumikkucha pirau tamara pasra, katø tru ellmarigwan ashib laramig kan ya-unø palaig mara pasran cha. Incha nui pirøwan katøganelan misrigwan pirishinrraptø kwallchai tranabe, yabsrømay yan cha. ");
INSERT INTO gum_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Incha yandø lurramig puben, nui kan karuindiig megabigwan tru kwallchab utabelan tru kanbalø lurrigwan utønrrai karua øriibe, ");
INSERT INTO gum_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","nømbe nun kemøra, kurragucha, chiguchagaig ørøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Inchen tru puaibe katøgan karuindiig megabigwan øren, truigwane turyu larrøgucha, nømbe tsalø wamabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Inchen tru ellmarig puaibe katøgucha katøgan karua øren, truigwane kweetsin køben, katøbe mas yam øren, kanelane kurrabetab, kanelane kweechib inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Inchen srabe yandø katøgucha kandø kørrømisrøbig køn, truibe nui trag nusrkai, undaaraig. Incha yandø srabebe truigwan ørøbig køn, trenchib: “Nai nusrkawane chinchimønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Treendingucha tru kwallibeløbe kangurrin kangurri nømasiyaitø trenchibelø køn: “Pirøwan ketig utønrrabiibe iigwein køn cha. Kwetchab amun cha. Pirøbe namuin kørrømisrtrun” cha. ");
INSERT INTO gum_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Incha nusrkawane kemøra, kweecha, asrwane tru uvas traugurri weguchibelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Incha Jesúsbe trenchibig køn: —¿Tru uvas tra puaibe chi martrerah? cha. Arrua, tru kwallibelane kweecha, tru uvas trawane katøganelan tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Ñimgan Tiuswei wamwan pørigu iigwan mana lemeelø køtirru? cha: Tru ya marøbelø kaasig sruube katsiisrø pølbasra wayamig mas purø tab srukken misrin køn taigwan. ");
INSERT INTO gum_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Señor Tius øyeeg marene, namuin kabyube truba tabig asønatan cha.— ");
INSERT INTO gum_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Inchen Jesúswan merrarrawa sruamrrab kemørtrab inchibelø køn, kaguende tru ‘øyeeg lataitøwein køn’ cha waminchippe, nømun kemesra wamindi møra. Inchendø nømbe misag truba nuwan køriimata, kagøbasha, pasramnetø ambuptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Incha Jesúsweimay mø fariseosmeran køsrønba, Herodesweingateelanba ørøbelø køn, chigøben wamindingarua, nø kalø løtøbene, truyu kebenøsrkønrrab isua. ");
INSERT INTO gum_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inchen truiløbe amrrua, trenchibelø køn: —Kusrennøbig, ñibe ciertonigwan waminchib møg kui aser cha. Katø misag maig chitanmaptø mørøb pasrømíig køn cha. Kaguende ñibe mundøgucha nømun mailø køtasha kandarøtø imøtø, Tiuswei maywan ñibe maig kusrenanamigwan cierton sølwan kusrenanøbig køn cha. Trube, ¿tru Roma maya misagwan karub wabigwan nam an pagaramig merømuig køh? Kabe, ¿merig køh, chinderah? cha. ¿Tranrrautah? Kabe ¿tranmønrrautah?— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Inchen Jesúsbe nømune ka isatø, palatø tab inchib chib pønrrai ashabe, trenchibig køn: —¿Nane chindimbarre kebenøsrkønrrab inchigue? cha. Kan pagaram anwan srua amrruy cha, na ashchab.— ");
INSERT INTO gum_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inchen srua amrruben, Jesúsbe trenchibig køn: —¿I anyu maløba, i munchi pøriibabe muin køh?— cha. Inchen nømbe: —Tru Césarwein køn— chiben, ");
INSERT INTO gum_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesúsbe trencha løtabig køn: —Césarwein købene, trube, Césarwan tranay cha. Inchen Tiuswein købene, Tiuswan tranay— cha. Inchen nune ke kwaara ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Inchen mø saduceosmera køsrøn Jesúswan ashchab ambubelø køn. Truiløbe tru kwabeløbe øsiiramønrrun chibelø kuabe, Jesúswane øyeeg payibelø køn: ");
INSERT INTO gum_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Kusrennøbig, Moisésbe namun treeg pøra kørrømarig køn cha: “Møigwei nuneg køben kwawa, srawan urekkaig kørrømarene, trube, tru nuneebe piudaba kasharawa, nuneg kwabigweimburab ureg tøgagømig køn” chibig. ");
INSERT INTO gum_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Trube, siete nunelø købig køn cha. Indiibe srøsriibe kasharawa, chi urekkaig kwaben, ");
INSERT INTO gum_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tru wendauikkucha tru piudaba kasharawa, katø chi urekkaitøwei kwaben, katø tru pøn kønrrabyuigwangucha treetøwei nebuben, ");
INSERT INTO gum_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","yandø søteeløba tru ishuuba kasharawa, møikkucha ureg kørrømarmøn cha. Inchen yandø srabebe ishukkucha kwan cha. ");
INSERT INTO gum_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Trube, tru kwabelø katø øsiirabene, ¿nøbe møigwei srain kønrrerah? cha payibelø køn, tru sieteeløba nune srai mara tøgagúig købene.— ");
INSERT INTO gum_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Inchene Jesúsbe trencha løtabig køn: —Ñimbe mandø kuinguen mørmøwa pella pønrrappe, ¿Tiuswei wamwan pørigwanba, katø Tiuswei maramburab marigwanba tab nebua ashmeelø kuarre pella pønrrømøtirru? cha. ");
INSERT INTO gum_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kaguende kwailø katøyug øsiirappe, kasharamøwei, kasharanmøwei inchun cha. Treeg kømøtø, srømbalasrø ángelesmera latailøtøwein kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Inchen tru kwailø katø øsiiramigweimburappe ¿ñimgan Moisés pørigu lemeelø køtirru? cha, tru tusr-unø naarabigugurri Tius nun øyah taigwan: “Nabe Abrahamwei Tius, Isaacwei Tius, Jacobwei Tius kur” cha trendaigwan. ");
INSERT INTO gum_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tiusbe kwailai Tius kømøtø, øsiguelai Tius køn cha. Inchawei ñimbe purø nu pella pønrran— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Inchen tru Moisés pørigwan kan kusrenanøbig tru ‘maig køh’ cha, payiyab køben mørøb pasrabiibe, Jesúsbe søl løti møra, nun kemallabe, trencha payibig køn: —¿Tius martrai karua pønsrailai utuig mas nuibe møig køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Inchen Jesúsbe trencha løtabig køn: —Tru martrai karua pasrig mas nuibe iig køn cha: “Au, Israel misag, møray cha. Namui Señor Tiusbe, Señor nøtø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Señor ñui Tiuswane ñui manrraugurri kerrigu newan undaaraitøgaba, kerrigu ñui øsig pasraitøgaba, kerrigu ñui turtøga isumburab isuitøgaba, katø kerrigu ñui asru chishkømburab chish kuitøgaba undaaramig køn” tan cha. ");
INSERT INTO gum_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Inchen tru wendauibe iig køn cha: “Ñima ñiasiitøwei maig undaguig køppe, ñui mendaigwangucha treetøwei undaaramig køn” cha. Tru maig maramigwan martrai pønsrailø i pagatø lataig nørreeløbe katøgane chi kaagøn— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Inchen tru Moisés pørigwan kusrenanøbiibe trenchibig køn: —Kusrennøbig, ñibe sølwein tan cha. Tiusbe kandø køn chib, katøgane mu kaagøn chib, ");
INSERT INTO gum_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tiuswan kerrigu ñui manrrøtøgaba, kerrigu ñui isumburab isuitøgaba, kerrigu ñui asru chish kømburab chish kuitøgaba undaarab, katø mendaigwangucha nøasiitø lataitøwei undaarab indamig køn cha trenchippe. Iilan mariibe Tiusweyasig traniiba, katø animalmeran kweecha Tiusweyasig parriiløba lataitøguen kømøtø, mas nuig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Inchen Jesúsbe truibe ke tab isua løti ashabe, nune trenchibig køn: —Tius nø ashib karub pasrainug pumibe ñibe ke tre yab pasrømøn— cha. Inchen yandø katøbe Jesúswane mugucha chi payrrab inchimeelø køn. ");
INSERT INTO gum_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Tiuswei yau kusrenanøb pasrøwabe, trencha payibig køn: —¿Tru Moisés pørigwan kusrenanøbeløbe chindimba tru Cristone Davidwei misagugurri arrubig køn tah? cha. ");
INSERT INTO gum_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kaguende Davidtøweinguen Espíritu Santo eshkaig trendaig køn cha: Señor Tiusbe tru nai Señorwane trendan cha: “Nai kusrmaygatø wamisr cha, ñui ashig kømui inchib tsalø inchibelan ñi itøbunønrrai ñui srøb umbu na pønsramnegatig.” ");
INSERT INTO gum_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pøs Cristone David nøtøweinguen: “Señor” cha wamøbene, trube, ¿mandøgurri Cristobe Davidwei nusrkain kønrrab køh?— chibig køn. Inchen misaamera truba nu pasrabiibe truba chull mørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús kusrenanøb pasrøwabe trenchibig køn: —Tru Moisés pørigwan kusrenanøbelane ashiptø kuy cha. Truiløbe kørrabelø kewa llirab amønamig chullelø køn cha, katø penab, yanøb indiisrø nømune maig købash kømø, truba tab wamønrrai inchib, ");
INSERT INTO gum_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","katø judíosmera tulundzuni yamerayube purø tab purramdønug purrag kui indamba, katø lincha tabig mabyugucha nørreelø purrainug purø tabigu purrag kui indamba inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Incha katø piudasmeran nømui yameran kerrawabe, tabelø misrøb ke ka yandø truba yana Tiuswan waminchibelø køn cha. Truiløbe møra melamig mas nuigwan utønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mana køsrøn Jesús Tiuswei yau Tiusweyasig an kebusrinug tru pinrrøgue wabene, truba nu misaabe truyu an kebusrøb køben, truba yamelø puarmerabe truba nørrøweyig an kebusri ashibig køn. ");
INSERT INTO gum_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Inchen truyu kan waacha piuda arruabe, truyu pagatø øskø andø purø lamøzhig kebusren, ");
INSERT INTO gum_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesúsbe nui kusrenanøb pera uniilan wamabe, trenchibig køn: —Nabe ñimun cierton trendamønrrun cha: I waacha piudabe cajayu pusrøbelø kanelø lataguen kømø, mas nu kebusran cha. ");
INSERT INTO gum_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kaguen mayeeløba nømbe undaigwandø tranen, trune nøbe waacha køptø, nui kerrigu tøgagúigwan tranan cha, tru nui øsig tsumig kerrigu tøgagúigwan.— ");
INSERT INTO gum_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Tiuswei yaugurri webibene, møikkøsrøn nui kusrenanøb pera uniilai utuibe, trenchibig køn: —¡Kusrennøbig, ñiguen ash cha, kan yeeg nørrø sruumera, yeeg nørrø yamera kuita!— cha. ");
INSERT INTO gum_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Inchen Jesúsbe trencha løtabig køn: —¿Yeeg nørrø yamera mariilan ñigan ashkuh? cha. Yube ni kan srukken katøgan srug palabe kørrømisrmønrrun cha. Kerriguba pøtiitsig kønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Incha Jesús Olivos Tunsrø Tiuswei ya pasrab pinrrøguesrø wabene, Pedroba, Jacoboba, Juanba, Andrésbabe nundø nøørø trencha payibelø køn: ");
INSERT INTO gum_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Øyeebe mana purainrrab kui namun eshkarra cha. ¿Tru kerrigu treeg nebunrrabigwan asamibe chitø kenamisrtrerah?— cha. ");
INSERT INTO gum_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Inchen Jesúsbe trenchibig køn: —Ashiptø kuy cha, mugøben ñimun peløsrkønrrain kømø. ");
INSERT INTO gum_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kaguende møiløgøben nai munchiyu truba nu amrrua trenchinrrun cha: “Nabe truig kur” chib. Trumay misaameran isa wamincha truba nu peløsrkønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Incha, ‘misaamera katøgan peesrø misaameraba purø trømbøig kørig kømdiig kwayab kweetsiyab køn’ chib, katø, ‘purø trømbøig kørig kømdiig kwayanrrab køn’ chib ñim wamindi mørabe, mandøguen kømui inchib kwarmøtay cha. Kaguende øyeebe trendø treeg purainrrabigwein køn cha. Inchendø katøgucha patsamibe pumø srø kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Peg misaamerabe katøgan peg misaameraba kwayaben, katø rey karumburab ashib karuim piraueløbe katøgan reywei misaameraba kwayanrrun cha. Trune chusrøn køben pirø trømbøig kønøben, parø arruben, iiløbe kan ishuwan unø tammisrtrab pusrkwab pølbasri lataitø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Inchawei ñimasiyaitø tab ashiptø kuy cha. Kaguende ñimune karubelai tasku tranen, katø judíosmera tulundzuni yamerayu ichabetab inchun cha. Katø ñimune karubelø nørreelai merrab, reymerai merrab nagurrindø pønrramig kønrrai martrun cha, trumay ñimbe naimburabigwan wamindamig kønrrain cha. ");
INSERT INTO gum_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Srabe kwaløm pumøwatø Tiuswei tabig srø wamwan yu pirau maya misaameran eshkab kusrenanamig nebunrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Inchen ñimun merrarrawa, tru misagwan ashib karub purrabelaimay trannrrab srua ambene, chi tamermab merrabwei isumønrrigay cha. Tru uras wamincheenchen Tius maig waminchai tranen, treeg waminchigay cha. Kaguende ñim kømøtø, Espíritu Santo waminchun, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Inchen nuneebe nømui nunewandøwei kwetchai tranen, møskaimbe nusrkawan tranen, ureemerabe møskalan namig kurra, kwetchai tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Maya misaabe ñimune nagurrindø tsalø indiilø kønrrabguen cha. Inchendø srabe kwalømgatig chigúingucha megabig megabiibe kebeñchabig kømíig kaigyugurri wesraig kønrrun, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Tru pinishinrrabig trømbøig køsøngønrraptiig truig nø pasramnug kømubendø, ñim truyu pasrai ashabe (lebiibe iigwan tab chigúi mør), trube, Judea pirau warabeløbe tun palasrømay wegørra lulay cha. ");
INSERT INTO gum_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inchen tru kwaløm nui ya pala wambig wabiibe chigøben wesrunrrab kørraarrua, umbu kelulmumig køn cha. ");
INSERT INTO gum_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Katø chugøben trausrø uñibiibe nui itøtsinigwan tranrrab arrumumig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ishumbur waachamera, tru kwalømmerawan patsø kwanrreelø, kabe muchib ureg tøgarmeraimbe maig kønrrer! chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Inchawei ñimbe Tiusba waminchib miay cha, trømbøig pishin kwalømmerawan lulamig nebumønrrai. ");
INSERT INTO gum_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kaguende tru kwalømmerawane purø trømbøig nebuinab melamig attrun cha. Tius chigurrimbunø købigwan marøb uraskurri møingatig øyeebe kaagúig, katøbe managuen øyeebe kaanrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Señor tru kwalømmerawan landøranmuisruandøbe, mugucha øsig waramgaig kønrrun cha. Inchendø nuyasiitø kønrrai tarømariilø, tru nø lawa wesruiløgurri landøranin køn cha. ");
INSERT INTO gum_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Inchawei tru kwalømmerawan møikkøben ñimun: “Asay, yu Cristo pasran” chib, kabe: “Asay, uyu pasran” taingucha, køremøtay cha. ");
INSERT INTO gum_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kaguende møiløgøben ‘Cristo ker’ chib, isatø inchibeløba, katø ‘Tius maig karuigwan eshkabelø ker’ chib isatø inchibeløba amrrunrrun cha. Incha nømui maramburab marøb mariilø, nørreelø asha kømig kenamariiløba, nørreelø kwaara asha kønrrai mariiløba martrun cha, misagwan treeg incha peløsrkønrrab. Incha Tius nuyasiitø tarømariilanguen kegørrøsrkamdiig kuimbe, kegørrøskønrrab inchun, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Inchawei ñimbe tab isua ashiptø kuy cha. Nabe ñimune iigwan kerriguba puraimøwatø chab eshkar cha. ");
INSERT INTO gum_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Inchen tru kwalømmerawan, tru treeg isumdø kwalømmera chab puraibene, nøsiibe yandø kwaben, pølbe yandø pilømuben, ");
INSERT INTO gum_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","estrellamerabe srømbalasrøngurri kørrab amrruben, katø srømbalasrø purø nørreelø pønrrabelan kønøgøb sruagutsiilø kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Inchen tru Møg Misra Arrubiibe purø nuig maramburab maramig tøgaig tørguegwalmabig wañiyu arruben, misaamerabe ashchun chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Incha nøbe nui ángelesmeran øra, ambugurri, igurri, walligurri, wagurri pirau maya yabsrøngurri kandarø srømbalasrøngatig nui lawa wesruilan kanbalatø tulishinrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Kan higuera tusrwanma asha kusrey. Nui srarmera uturcheelø misrøb, ishiimera weguchene, ñimbe pachig kwalømmera arrumig yandø lutau kui ashibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Øyeetøwei ñim iilan purayai ashabe, attrabiibe attrab yaskabuguen pasraitamab isua kuy, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pøs nabe ñimun cierton trendamønrrun cha: Møin kwaløm misaamera pinømøwatø, øyeeløbe kerrigu purainrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Srømbalaba, pirøbabe patsøben, na wamindiibe ka wamindiitøbe purainrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Inchendø tru treeg punrrab kwalømwanba, uranbabe mugucha ashmøn cha. Srømbalasrø ángelesmeraguen ashmøwei, ni Tiuswei Nusrkai ashmøwei indan cha. Trunun ashippe, Møskaindøwei asan, chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Inchawei ñimbe pesannamø, tab ashiptø kuy cha, kaguende ñimbe øyeebe mana purainrrabig kui ashmøwabe. ");
INSERT INTO gum_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kaguende iibe kan møg nui yaugurri yabsrømay webya inrraptø, nui karuindiig melabelane nui yawan ashib kønrrai kørrømara, kanun kanun nømui maramigwan marøb kønrrai karua pønsra, tru yaskabu ashib pasrabigwane chigøben kømønrrai ashib pasrønrrai karua pasra ibig lataitøwein køn cha. ");
INSERT INTO gum_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Inchawei ñimbe ashiptø kuy, chibig køn. Ya puaig pilliraben kui, kabe yem tøbøtag kui, kabe kallu wamøben kui, kabe løtsø kui, mana attrab kui mørmøwabe. ");
INSERT INTO gum_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Inchippa møi møi arrua, kib warøben wetørrainanrrab kømø cha. ");
INSERT INTO gum_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Inchawei na ñimun maig taibe, mayeelan katø treetøwein tamønrrun: ¡Munig, kasriitø kuy!— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua fiestan maramiba, tru Pirri Levaduragaig maig Fiestan maramiba yandø pa kwalømdø paløben, sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløbabe Jesúswan kwetchab chigøben isa mandø incha kemøramdiig køtashchab inchib kuabe, ");
INSERT INTO gum_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","trenchibelø køn: —Fiesta utu marmønrrab cha, misaamera ke chindi asamgaig inchimønrrain— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betaniasrø tru Simón Leproso taigwei yau Jesús wabene, kan ishug alabastro limetayu nardotøzhig chi undisaimíig, netsiig, truba may irrabig, purø nuweyigwan srua, kemalla, Jesús mishatsigu wamnetø, limetan pushippa, tru may irrabigwan tur pala itølushibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Inchen møiløgøsrøn truyu purrabeløbe nama, nømdø trenchibelø køn: —¿Purø may irrabzhigwan ke ka yandøbe chinchabrre lusah? cha. ");
INSERT INTO gum_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Waachameran purugumig kan trescientos denarios menrraweinguen yanøbsruinrrun— cha. Nømbe tru ishuwane truba namig waminchib købelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Inchen Jesúsbe trenchibig køn: —¡Kagøbasay! cha. ¿Chinchabrre inchigue? cha. Nøbe nayasig truba tabzhig maran cha. ");
INSERT INTO gum_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Waachamerane chu uragucha ñimui utu tøgagua, ñim nømun tabig maramdiig købene, tabig martrun cha. Trune nane yube chu uragucha tøgagønrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I ishuube nun maig maramdiig nebuben treeg maran cha. Nai asrwan manawei kanmaytø may irrabzhigwan srølan cha, nan søramigweyasig. ");
INSERT INTO gum_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nabe ñimune cierton trendamønrrun chibig køn: Yu pirau chutøgucha Tiuswei tabig srø wam kaigyugurri wesrabigwan eshkab kusrenaniisrømbe, tru nø marigwangucha tøga waminchun cha, nun pesannamø, isuig kønrrai.— ");
INSERT INTO gum_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Inchen Judas Iscariote, tru doce Jesús kusrenanøb pera uniilai utuig, sacerdotesmeran karubelan Jesúswan nømui tasku trannrrab waminchab ibene, ");
INSERT INTO gum_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","nømbe trunun mørøppe, truba kasraarawa, an trannrrab misrøbelø køn. Inchen Judasbe Jesúswan mandø incha tranamigwan yandø lab mendabig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tru Pirri Levaduragaig maig Fiesta pølbasrøb kwaløm, tru Pascuayasig ubisha-unan kweechib kwaløm, Jesúswei kusrenanøb pera uniiløbe nun trencha payibelø køn: —¿Pascua mamigwan ñuimbe chu tamartrab ambamø?— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Inchen nøbe nui kusrenanøb pera uniilan pailan trencha karua ørøbig køn: —Ciudayumay ambay cha. Truyube kan møg pigøtsø mutaig ñimun katøben, truigwei wendautø amrrigay cha. ");
INSERT INTO gum_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Incha truig kebyainug kebambabe, ya puaigwane ñimbe trenchinrrigay cha: “Kusrennøbiibe ñun trendan cha: ‘¿Nai kusrenanøb pera uniiløba pascua mamigwan mab purram salabe chu køh?’ ” cha. ");
INSERT INTO gum_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Inchene ya puaibe pala pisusrø kan nu sala chiguen palømíig yandø ke chab tamarikken ñimun eshkanrrun cha. Inchen ñimbe namuyasig truyu tamartrigay— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Inchen nømbe amba, ciudayu puabe, Jesús nømun maig taig treeg wetørrawa, tru Pascuan tamarøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Inchen yandø yem køben Jesúsbe nui doce kusrenanøb pera uniiløba pua, ");
INSERT INTO gum_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","mishatsigu mab purrøwabe, Jesúsbe trenchibig køn: —Nabe ñimun cierton trendamønrrun cha: Ñim møikkøsrøn naba mab wabig nan ashig kømui inchibelaingatø misra, nan trannrrab køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Inchen nømbe truba isui inchib menda, Jesúswan kan kan payibelø køn: —¿Kabe na købra, chinderah?— chib. ");
INSERT INTO gum_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Inchen Jesúsbe trencha løtabig køn: —Ñim doceelai utuig køn cha, naba i nindagutøwei pirriwan kebishibig. ");
INSERT INTO gum_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pøs, tru Møg Misra Arrubiibe Tiuswei wamwan pørigu maig pørig pasrøben, truwan pureb iben, trune ¡tru møg waacha! tru Møg Misra Arrubigwan ashig kømui inchibelan trannrrabigweimburappe, yeekkucha kuita, chibig køn. Trembe truibe kal-lamuig kuinguen søl købsruinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Incha mab purrappatø, Jesúsbe pirriwan muta, Tiuswan ‘mayanguen pay’ cha, pirishabe, nømun trenchib srørrøbig køn: —Cha, may cha. Iibe nai asr køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Incha katø copan muta, Tiuswan ‘mayanguen pay’ chabe, nømun purøørøbig køn. Inchen tru copayuigwan søteeløba muchibelø køn. Inchen nøbe nømun trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Iig, nai animbe, Tius tru misagweyasig srø acuerdon mari anin køn cha. Tru animbe truba nu misagweyasig lusig køn cha ");
INSERT INTO gum_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nabe ñimun cierton trendamønrrun cha: Uvas piwane mas muchimumønrrun cha, nai Møskai nø ashib karub waisrø katøyug ñimba mutsam kwalømgatig.— ");
INSERT INTO gum_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Incha kan himnon chab cantawabe, Olivos Tunsrømay amba, ");
INSERT INTO gum_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesúsbe trenchibig køn: —Ñimbe mayeeløba nainug isua pønrraigwan trubishinrrun cha. Kaguende Tiuswei wamwan pørigu øyah chibig pørig pasran cha: “Ubisha ashibigwan na kweechen, ubishamerabe nøørøtø chab lulrrun” chibig. ");
INSERT INTO gum_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Inchendø nabe katøyug øsiirappe, ñimguen ammøwatø, nabe Galileasrømay yamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Inchen Pedrobe trenchibig køn: —Mayeeløba ñuinug isua pønrraigwan trubisaingucha, na kuimbe tarømisrmumønrrun— cha. Inchen Jesúsbe trencha løtabig køn: ");
INSERT INTO gum_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Nabe ñun cierton trendamønrrun cha: Møi yemdøweinguen kallu pamay wamømøwatø, ñibe pønmayguen nan ‘ashmíig kur’ chinrrautan— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Inchen Pedrobe truba inchib trenchibig køn: —Ñiba nan kwamig nebuinguen, nabe managuen ñun ‘ashmíig kur’ chimumønrrun— cha. Inchen søteeløba treetøwein chibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Incha nømbe kanbalø Getsemaní taisrø puabe, Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: —Yu purramisray cha, nai Møskaimba na wamindamne.— ");
INSERT INTO gum_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Incha Pedronba, Jacobonba, Juanwanba pera yabe, truba truba isui, ni mumayguen tab kømui inchib menda, ");
INSERT INTO gum_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","trenchibig køn: —Nai manrraube isubiitø kwabguen ka kwamdiig køtan cha. Ñimbe yutø kørrømisra, kimø purray— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Incha Jesúsbe katøguchi ambuurø ya, pirau sraløptincha, Møskaimba waminchib miabig køn: —Tru purø trømbøig attrabig nan treeg punrrain kømubene, treeg pumugasam— chib. ");
INSERT INTO gum_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Katø Tiuswan trenchib miabig køn: —Abba, nai Møskain chib, ñuimbe chitøgucha kaimamø, maramdiitø køn cha. I copan nan tarømartra cha. Inchendø na maig isuig køben, treeg kønrrain kømøtø, ñun maig maramdiig køben, treeg kønrrain— chib. ");
INSERT INTO gum_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Incha nui kusrenanøb pera uniilaimay arrua, kib purrai wetørrawabe, Pedrone trenchibig køn: —Simón, ¿kib watirru? cha. ¿Kan uratøguen kimø, kasriibe wanrrab kaimatirru? cha. ");
INSERT INTO gum_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kimø, Tiusba waminchib purray, chibig køn, chiyugøben kaigyu kegørrømønrrappe. Ñimbe tabigwan martrabwei isuingucha, ñimui asrbe kullaguig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Incha katøle Jesúsbe ya, treetøwein chib Møskaimba waminchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Incha katø arruabe, katøguen nui kusrenanøb pera uniilane kiptøwei purrain kui wetørrabig køn, kaguende nømui kabmerabe kigøbiitø ke kanaim purrøwa. Incha nømbe mancha løtønrrab kaimabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Inchen Jesúsbe pønmay kønrrabyu arruabe, trenchibig køn: —¿Katøgucha ñimgan israb, kib srø warøtirru? cha. Yandø tsabø køn cha. Ura pun cha. Yandø tranan, chibig køn, tru Møg Misra Arrubigwan kaig marøbelai tasku. ");
INSERT INTO gum_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Kurray, chibig køn. Amrrab! cha. Nan ashig kømui inchibelaingatø pasramisrøbig nan trannrrab arrubguen indan cha. ¡Asay!— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Incha Jesús waminchib pasramne, tru Judas, tru doce kusrenanøb pera uniilai utuibe truba nu misaaba arrubig køn, nømbe espadamera køben, tsiimera køben sruargue. Truiløbe sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløba, misagwan karubelø kølli misaameraba misra, karua øriilø købig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tru Judas Jesúswan ashig kømui inchibelaingatø pasramisrøbiibe nømune: “Merrarramig kuitamab ñim ashchai, na chi siñal køsrøn maren, ashib pønrrønrrigay” cha, eshkain købig køn. “Tru na muchaig, truig kønrrun cha. Truigwan kemøra, suldaumeraba sruamrrigay” cha. ");
INSERT INTO gum_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Inchen Judas puabe, møi møi Jesúsweim pulu kemallib trenchibig køn: —¡Nai Kusrennøbig!— cha. Inchabe muchabig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Inchene nømbe Jesúswan kemøra, sruamrrab merrarrabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Inchen møikkøsrøn truyu pasrabiibe nui espadan wesrub, maya sacerdotesmeran nø karub sacerdotei karuindiig megabigwan kaluwan kelarrab lutiichiptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Inchen Jesúsbe misaameran trenchibig køn: —¿Chindimbarre ñimbe espadamera køben, tsiimera køben sruar werrugue cha, nan kemørtrab, nabe kan niliig kui lata? ");
INSERT INTO gum_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nabe ñimba kwalømmørig Tiuswei yau kusrennøb waben, ñimbe managuen nane kemørmuig køn cha. Inchendø Tiuswei wamwan pørigu maig taig treeg nebunrrain kuig køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Inchene nui kusrenanøb pera uniiløbe nundø pasramnetø, mayeeløba chab luløptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Inchen kan matsinube køsaatiig llensutø tsinaig tru wendautø iben, nune kemørøptinchen, ");
INSERT INTO gum_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nøbe llensun wesølønnøb, køsaatiig ¡katø! pinaptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Incha Jesúswan tru maya sacerdotesmeran nø karub sacerdoteimay srua ambubelø køn. Inchen mayeelø sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba, tru Moisés pørigwan kusrenanøbeløba kerriguh tulundzunabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Inchen Pedrobe Jesúswei wendau yaptø, yaptø tru maya sacerdotesmeran nø karub sacerdotei ya wambiisrøngatig ya, tru ashchai pønsraig pønrrabeløba pachiirab naabulu wamisra wabig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Inchen sacerdotesmeran karubeløba, tru Setenteelø maig maramigwan asha marøbelø mayeeløba misra Jesúswan kwanrrai pasrtrab, møilan køben ‘Jesúsbe kaig maren, nambe ashibwei indig køn’ chib, waminchabelø labendø, treeg waminchabelø wetørranrrab kaimabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Inchen møiløgøben nuimburab chigøben isa waminchendø, nøm wamindiibe ka peetø, peetø webibig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Inchen møiløgøben kurra, isatø Jesúswan trenchibelø køn: ");
INSERT INTO gum_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nambe nø trendai mørig køn cha: “Nabe i Tiuswei yawan møguelø marigwan pinisha, pøn kwalømyube Tiuswei ya katøgan, møguelø marig kømøtø, mara pasramønrrun” tan— chib. ");
INSERT INTO gum_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Inchen treendingucha, katøgucha nømui wamindiibe peetø, peetø webiben, ");
INSERT INTO gum_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","tru maya sacerdotesmeran nø karub sacerdotebe mayeelai utu kurra pasramisra, Jesúswane payibig køn: —¿Chigucha løtømønrrapteh? cha. ¿Ñune øyeebe chi kalø maran charre inchib køh?— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Inchen Jesúsbe niløtø pasrøwa, chigucha løtømuben, tru maya sacerdotesmeran nø karub sacerdotebe katøyug trencha payibig køn: —¿Ñigan tru Cristo køtirru cha, tru Tius mayanguen Tab Indigwei Nusrkai?— ");
INSERT INTO gum_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Inchen Jesúsbe trenchibig køn: —Nabe truigwein kur cha. Inchagucha tru Møg Misra Arrubig tru maramburab marøb Tiuswei kusrmay waben ñim ashib, katø srømbalasrøngurri wañiyu arruben ashib inchun— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Inchen tru maya sacerdotesmeran nø karub sacerdotebe nø kewagúigwandøwei kølsrøb, trenchibig køn: —¿Namun nuimburab waminchabelø mas chiwein kui palønrrab kø? cha. ");
INSERT INTO gum_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ñimdøweinguen Tiuswan purø trømbøig wamab wamindigwan møran cha. ¿Ñimune maig asønata?— chibig køn. Inchen nømbe mayeeløba treeg kaig kuin kui mara, kwanrrai kørrømara pasrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Inchen møiløgøben nun illimbi tuchib, maløwan kasra, nun kurraguchib mendabe trenchibelø køn: —¡Namun kelarrab eshkau pøs, chib, mu kurragutsin kui!— Inchen tru Tiuswei yau ashchay pønsraig pønrrabeløbe Jesúswan merrarrawa, pashaguchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Inchen Pedrobe pinaamay yawambig waben, trunetø tru maya sacerdotesmeran nø karub sacerdotei mendig megabig kan srusrø puabe, ");
INSERT INTO gum_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro nag pulu pachiirab waben, nun tab ashabe, trenchibig køn: —Ñigucha tru nazaretsriig Jesúsba uñibig kuig kømøh— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Inchen Pedrobe trenchib isabig køn: —Ashmíig kur cha. Ni chi wamindinguen mørmur— cha. Incha wambig kerruisrø webibene, kan kallu wamabig køn. ");
INSERT INTO gum_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Inchen tru srusrøbe katøle Pedron ashabe, truyu purrabelan katø eshkab mendappe: —Iibe truilai utuigwein køn— chiben, ");
INSERT INTO gum_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedrobe katøguen ‘ashmíig kur’ chib isabig køn. Inchen truyu purrabeløbe yanayutø katøguen Pedrone trenchibelø køn: —Isa kømø, ñigucha truilai utuigwein køn cha; kaguende ñibe galileasriig køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Inchen Pedrobe: —Na isab pasraig købene, trube, nan chigøben nebunrrappe nebubash chib. Tiusken ashen, katø nabe isa waminchibgucha pasrømur, chibig køn. Ñim waminchib kui møwane ni ashibguen ashmíig kur— cha. ");
INSERT INTO gum_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Inchen trenchiben latatø kallube katøganguen wamaptinchibig køn. Inchene Pedrobe Jesús øyah taig kømørramab isuptinchibig køn: “Kallu pamayguen wamømøwatø, ñibe nan pønmayguen ‘ashmíig kur’ chinrrautan” taigwan. Incha trunun isuabe, truba truba isuig kishibig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Inchen yandø chab tør-rrabendø sacerdotesmeran karubeløba, misagwan karubelø kølli misaameraba, katø tru Moisés pørigwan kusrenanøbeløba, tru Setenteelø maig maramigwan asha marøbelø kerrigueløba tulundzunabelø køn. Incha nømbe Jesúswane lusra, srua amba, Pilaton tranøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Inchen Pilatobe Jesúswan trenchibig køn: —¿Ñigan judíosmerai rey køtirru?— cha. Inchen Jesúsbe trencha løtabig køn: —Ñitøweinguen chab trendan— cha. ");
INSERT INTO gum_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Inchen sacerdotesmeran karubeløbe nune chine, chine ‘øyeeg marøbig kuig køn’ chiben, ");
INSERT INTO gum_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatobe katøyug trenchibig køn: —¿Chigucha løtømønrrapteh? cha. Ñiguen ash cha, ñune chigøben yeeg waminchib køn cha, nømbe.— ");
INSERT INTO gum_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Inchen Jesúsbe treeg indingucha løtømuben, Pilatobe ‘kan øyeebe maig kermab’ isub kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Fiesta kwalømmerawane kubernadurbe kailan keeri yau pønrrabelan misag møigwan elatchai miaben, trendø treeg marøb elachibig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Inchen tru keeri yaube kan møg Barrabás taibe keerig pasrabig køn, nøbe larrø kailøba søtømisra, ashib karubelan namig kurrabyu misag kweechaig. ");
INSERT INTO gum_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Inchen misaamerabe amrrua: —Ñi trendø treeg marøbiibe, treeg mar— chib, Pilatone miab mendøben, ");
INSERT INTO gum_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatobe trencha løtabig køn: —¿Ñimbe judíosmerai reywan na elatsamig palain køgue?— cha. ");
INSERT INTO gum_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kaguende Pilatobe tru sacerdotesmeran karubeløbe Jesúswane uni ashig kømuptø nun tranin kui ashibig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Inchen sacerdotesmeran karubeløbe Jesúswan kømøtø, nømbe Barrabáswane elatchai inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Inchen Pilatobe katøyug payippe, trenchibig køn: —Trube, ¿ñim tru judíosmerai rey køn taigwane nabe mandø indamø?— cha. ");
INSERT INTO gum_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Inchen nømbe katø trenchib trashib løtabelø køn: —¡Kurusyu mesrø!— chib. ");
INSERT INTO gum_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Inchen Pilatobe trenchibig køn: —¿Nøbe chi kalø marindørre øyeeg martrainchigue?— cha. Inchen nømbe masken mur trashibelø køn: —¡Kurusyu mesrø! ¡Kurusyu mesrø!— chib. ");
INSERT INTO gum_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Inchen Pilatobe tru nu misagwan ka tab kønrrai inchig køptø Barrabáswan ka inrrai elacha, Jesúswane ichagutsingaruabe, kurusyu mesrønrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Inchen suldaumerabe palacioyu mas umbusrø srua amba, maya suldau søtøwan tulundzuningarua, ");
INSERT INTO gum_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","kan yalø piguiig itøguenana, kaldiigwan corona mara, petsøsrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Incha trugurrimbe trenchib trashib mendabelø køn: —¡Judíosmerai Rey, viva!— chib. ");
INSERT INTO gum_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Incha cañatøga turbøtø itsamba, illimbi tutamba, tab inchib chib, nui merrab tømbønsramba inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Incha øyeeg marøb ka indzatø ashib srua køptø, tru yalø piguiig itøguenanigwan wesrawa, nuiwan katøle kenana, kurusyu mesrønrrab nune wesrubelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kan møg cirenesriig Simón taig, Alejandroimba, Rufoimba møskai wambig nøørøsrøngurri purainrrab arruben, nune Jesúswei kuruswan ke mutamne incha mutøsrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Incha kanbalø Gólgota taisrømay nune srua ambubelø køn, (tru trenchippe, “Calaverasrø” tainug). ");
INSERT INTO gum_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jesúswane vinoba, mirraba lindisaig yuulingucha, Jesúsbe muchimíig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Inchen kurusyu mesra, suldaumerabe Jesúswei kewagúilan mu merrarramig nebutashchab suerte kuchibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Inchen løtsø las nuevetø købig køn, tru Jesúswan kurusyu mesrøben. ");
INSERT INTO gum_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Incha kan pørig mesrøbelø køn, chigurrin kwanrrai mesraig køn cha eshkabig: JUDIOSMERAI TRU REY KØN chibig. ");
INSERT INTO gum_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Incha katø pagatø nileelangucha kanun kusrmay, kanun atsimay nunba kurusyu melsrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Inchen tru Tiuswei wamwan øyah chib pøriibe nebuig køn: “Tru kailai utu nune tøga pasrig kønrrun” taig. ");
INSERT INTO gum_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Inchen truwan puraambubeløbe tsalø wamab, turwandø kønøgøb trenchibelø køn: —¡Au, ñi Tiuswei yawan pøtiicha, katø tru pøn kwalømyutø kusranrrabiibe, ");
INSERT INTO gum_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kwamønrrab ñitøwei chigøben mar! cha. ¡Kurusyugurri pinaamø!— cha. ");
INSERT INTO gum_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Inchen tru sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløba treetøweih nun indzatø ashib kangurrin kangurri trenchibelø køn: —Kanelane kaigyugurri wesrabendø, nøasiitøweimbe kaiman cha. ");
INSERT INTO gum_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tru Cristo, Israel misagwei reybe, møi kurusyugurri pinaarrubash cha, nam asha, nø kuitamab kørenrrab— cha. Inchen nøba kurusyu melsraig melabeløgucha Jesúswan tsalø wamabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yandø kwaløm tøbøtag misrene, maaben las treskatig pirau ørøba løstiig kørrømisren, ");
INSERT INTO gum_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tre uras Jesúsbe truba mur trashibig køn: —¡Eloi, Eloi! ¿Lama sabactani?— cha. (Trenchippe: “¡Nai Tius, nai Tius! ¿Chindimba nandø elachigu?” chib.) ");
INSERT INTO gum_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Inchen møiløgøsrøn truyu pønrrabelø mørabe, trenchibelø køn: —Møray cha. Elíaswan wamøtan— cha. ");
INSERT INTO gum_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Inchen møikkøsrøn lulabe, ñab esponjan køchiibiyu kebisha, kan caña tsigu pucha, mutchai pulusrø yuuløb trenchibig køn: —Kagøbasay cha. Inchippa kwamønrrai pinøsranrrab Elías attashchab— cha. ");
INSERT INTO gum_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Inchene Jesúsbe mur trashippe, yandø isrømuptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Inchen Tiuswei yau tru purø tab llensuzhig kelarrab søtø mesraibe palasrøngurri kørrab kølsra, yandø paig misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Inchen tru Roma suldau cienelan nø karubiibe Jesúsweim pinrrøgue pasrøwa, øyeeg trasaigwan mørøb, mandø kwaigwan ashib inchabe, trenchibig køn: —Isa kømø, i møøbe Tiuswei Nusrkaiwein kuin køn— cha. ");
INSERT INTO gum_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Inchen ishumburmera møiløgøsrøn yabsrøngurrindø ashib pønrrabelø køn. Tru utube María Magdalena køben, tru Wendiig Santiagoimba, Joséweimba usri María køben, katø Salomé købengue. ");
INSERT INTO gum_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Inchen tru ishumburmerabe Jesús Galileasrø uñen, nui mendig amøñib, purugub inchibelø købig køn. Inchen truyube truiløtø kømøtø, katøgan ishumburmera Jerusalénmay Jesúsba nebamba yam pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Inchen yandø yem misrøb køben, tru isram kwalømweyasig tamarøb kuin kwaløm købig køn, kaguende katø kwalømbe isram kwaløm kønrrab køben. ");
INSERT INTO gum_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Inchen José arimateasriig, tru Setenteelø maig maramigwan asha marøbelai utuig truba nuig tabig kui asig møg, nøgucha Tius nø ashib karub wainuguigwan muniirabig arrua, Pilato wainug kørmø kebinrrab isua, nøbe kebya, Jesúswei asrwan miabig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Inchen Pilatobe, trube, kwabguen inditamab isua, nøbe truba kwaara, kan suldau cienelan nø karubigwan wama, kwabguen inditarru cha, payibig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Inchen truibe nun eshkaben, Pilatobe Jesúswei asrwan Joséwan pinøsrungarubig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Inchen Josébe kan lino llensutøga kirra, Jesúswei asrwan pinøsrua, truyu pulabe, kan peñayu søramig trab lalig pasrabigu waya, trugurrimbe kan nu srugwan merrana, kebambinug kasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Inchen María Magdalenaba, María Joséwei usrimbabe chu sørøben ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Inchen sábado kwaløm puraiben, María Magdalenaba, katø Jacobwei usri Maríaba, Saloméba Jesúswei asrwan srølrrab ambamig may irrabzheelø penabelø køn. ");
INSERT INTO gum_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Incha tru srø trune pølbasrøb kwalømbe, ullarbatø ambubelø køn søriisrømay. ");
INSERT INTO gum_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Inchendø nømbe kangurrin kangurri trenchibelø køn: —¿Sørin trabyu kebambamnug srugwane namune mu tarømara traniasamø?— cha. ");
INSERT INTO gum_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Incha møimbe ashene, tru sørinug truba nu srug kasraibe truyu kømøtø, manawei malsrainguen tsuptinchen, ");
INSERT INTO gum_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","umbu sørinug kebambabe, kan matsinø puliig kørrabig keweig truyu kusrmay wai ashiptinchibelø køn. Inchen nømbe kwaaren, ");
INSERT INTO gum_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","truibe trenchibig køn: —Kwarmøtay cha. Ñimbe Jesús nazaretsriig tru kurusyu mesraigwan lan cha. Øsiirain køn cha. Yube mu kaagøn cha. Ñimguen asay, chibig køn, yu nun wayinug. ");
INSERT INTO gum_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Møimbe ambay, chibig køn, nui kusrenanøb pera uniilanba, katø Pedrongucha øyah chinrrab: “Galileasrømay ñimguen ammøwatø, nømerrig inrrun tan chinrrigay cha. Trusrø ñimbe nun ashchun tan cha, ñimun nø maig taig.”— ");
INSERT INTO gum_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Inchene tru ishumburmerabe sørinukkurri wegørra ambuppe, kwaarøptø ke itønab chab luløbelø køn. Incha mungucha chigucha eshkameelø køn, kaguende kwaariilø kua. ");
INSERT INTO gum_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tru truaaløm ullarbatø Jesúsbe katøyug øsiirawabe, María Magdalena tru siete kwaimandziimeran webusrinabigwanmerrig kenamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Inchen nøbe ya, Jesúsba amøñibelan eshkabig køn, truiløbe isuilø kishib køben. ");
INSERT INTO gum_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Inchen nømbe ‘Jesús øsiirain køn’ taigwanba, katø María ‘nø ashar’ taigwanba mørabe, nømbe køremeelø køn. ");
INSERT INTO gum_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Indiibe iilø chab puraiben, kusrenanøb pera uniilø pailø wambig nøørøsrømay ambub pønrrøbene, Jesúsbe, nø kømø, peg lataig kenamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Inchen nømbe amba, katøganelan eshkaben, truiløgucha nømune køremeelø køn. ");
INSERT INTO gum_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Indiibe mas wendøbe tru once pera uniilø mishatsigu mab purramnetø Jesúsbe truyu nømun kenamisrabe, namabig køn, tru ‘nø katøle øsiirawa uni aser’ cha eshkabelan nømui manrrømera murelø kuikkurrimbah, katø kørenrrab inchimeelø kuikkurrimbatø. ");
INSERT INTO gum_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Inchabe trenchibig køn: —Ñimbe yu pirau truørø amba, Tiuswei tabig srø wamwan mu misagwandøgucha eshkab kusrenanrrigay cha. ");
INSERT INTO gum_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inchen møikkøben køreb, katø piu umbu ulsraig køb inchibiibe kaigyugurri wesraig kønrrun cha. Inchen møikkøben køremíigwane kaigyu pasrønrrai pasrig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Inchen nan kørebelane, nabe nømba pasrain kui asamig iig tru øyeeg asha kønrrai mariiløbe nømba pønrrabig pønrrønrrun cha: nai munchiyube kwaimandziimeran webusrøb, srøig peg wammera waminchib, ");
INSERT INTO gum_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nømui taska ulmeran kemørinaingucha, chinchimub, katø inchippa chigøben kwetchaptiig tøga mutsinaingucha, chi kømub, katø nømui tasiimeran kwanrreelaim pala estsarene, truiløbe tabelø kørrømisrøb inchun— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Incha Señor Jesúsbe nømun chab waminchene, nune srømbalasrømay kusraben, Tiusweim pulu kusrmay wamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Inchen nømbe webamba, Jesucristoimburabelan chutøgucha truørø eshkab kusrenanøbelø køn. Inchen Señorbe nømba marøb pasrabig køn, nøm wamindigwane nui wam kui asig kønrrai maramburab mariiløtøga kenamarøb.");
INSERT INTO gum_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Pøs møiløgøben maig purayaigwan eshkabig kan pørig tamara kørrømartrab indig købig køn lutøgurri, namui utu isa kømøtø, cierton treeg purayeelan. ");
INSERT INTO gum_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tru srøsrøgurri nømui kaptøga nømashib ashibelø, katø Tiuswei wamwan nøm waminchib pønrrabelø namun maig eshkaig køben, treeg. ");
INSERT INTO gum_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Inchen nagucha kerriguba chitø purayailø maig kuigwan srøsrøgurriigwan tab nebua ashene, nangucha tabig asønaben, lutøgurri tamara ñun pørtrab inchar, ñi nai purø tab Teófilon, ");
INSERT INTO gum_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tru ñun maig kusrenanig købigwan, tru ciertonigwan ñi tab nebua asamig kønrrai. ");
INSERT INTO gum_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes Judea rey køben, judíosmerai kan sacerdote Zacarías taig merrabsrø Abíaswei sacerdotesmerai utuig tsubig køn. Sraimbe Aarónwei misagugurri arrubig købig køn, Elizabet taig. ");
INSERT INTO gum_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tiuswei merrab pailøba sølgandø amøñibelø kua, Señor chi martrain taigwanba, katø chi maramigwan martrai karua pønsrailanba muguen chi tamgaig marøbelø købig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Inchendø chi urekkar købig køn, kaguende Elisabetbe trendø ureg chigaig, pailøba yandø kølleelø kua. ");
INSERT INTO gum_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Indiibe kan kwaløm Zacaríaswei sacerdotes søtøwan Tiuswei merrab Tiusweiwan maramig nømun nebuben, ");
INSERT INTO gum_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","sacerdotesmerai utu trendø treeg marøbelø kua, suerte kucha ashene, Zacaríaswan Tiuswei yau incienso pattrab kebyamig nun nebubig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Inchen incienso parrøb pasramne, maya misaabe wambig Tiusba waminchib købig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Inchen møimbe incienso parri altar pulu kusrmaygatømay Señorwei ángel Zacaríaswan kenamisrøptinchen, ");
INSERT INTO gum_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacaríasbe ángelwan ashabe, ¡katø! mandøguen kømuptinchen, ke chinchimmørø inchib kørig kui inchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Inchen ángelbe trenchibig køn: —Zacarías, kørig kui inchimøta cha. Kaguende Tiusbe ñi nun miaigwan mørig kua, ñui srai Elisabetbe kan nusrkai tøgagønrrun cha, truigwane ñibe Juan munchi pasrtrig chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Inchen ñibe truba tab kui mørøb kasraaraben, nø kal-labene, katøganelø møiløgøben tab kui mørtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kaguende ñui nusrkaimbe Tiuswei merrab truba nuig kønrrun cha, managuen vino muchimøwei, mutsiiranrraptiig kørap pi muchimøwei inchabig. Incha usrai patsau wappatøwei Espíritu Santotø netsaig kua, ");
INSERT INTO gum_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","møilan køben, Israelwei misaameran nømui Señor Tiusweimay truba nu llirangarunrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tru Juanbe Señorwei merrab ippe, tru merrabsrø Tius maig karuigwan eshkabig Elías maig isubig køben treetøwei isubig, katø truigwei maramburab marigwan tøgaig inrrun cha. Møskaløbe nusrkaløba katøle tabig waramig kønrrai marøb, katø kailø mørmeeløbe sølgandø amøñibelø misaasun marigu amøñinrrab lliranrrai inchun cha. Kan nu søtø misaamera Señorwan utønrrab ke muniitø melønrrabelø kønrrai tamarøb.— ");
INSERT INTO gum_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Inchen Zacaríasbe ángelwan payippe: —¿Iigwane mandø incha treeg kønrraitamab isumø? cha, trencha payibig køn. Kaguende nabe yandø køllig køben, nai sraingucha treetøwein køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Inchen ángelbe trencha løtabig køn: —Na, Gabrielbe Tiuswei merrab pasrabig kur cha. Incha nane i tabig srøigwan ñun wammørøsrkønrrai ørtan cha. ");
INSERT INTO gum_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Incha møimbe tru treeg nebum kwalømgatig ñibe wamgaig, chigucha waminchab kaimabig kørrømisrtrabguen cha, na maig taigwan køremikkurri. Tru na trendailøbe treeg pum kwaløm punrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Trune misaabe wambig munig kua, Zacarías Tiuswei yaugurri ke peguen webarrumuben, chindermab isub købene, ");
INSERT INTO gum_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías webarruppe, waminchab kaimabig webarruptinchen, Tiuswei yau chitø kenamisren, asiitamab isubelø køn. Inchen nøbe wamgaig kørrømisra, nømune ka señas maratø eshkabig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Inchen Zacaríasbe Tiuswei yau Tiusweiwan maram kwalømmera chab patsøben, nøbe nui yamay iben, ");
INSERT INTO gum_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","tru kwalømmera puraiben, Elisabetbe kwanrriig kørrømisra, nui yaugurri trattrø pøl webimíig køn, øyeeg isub: ");
INSERT INTO gum_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Møi i kwalømmerawan Señor nayasig øyeeg tabig martan cha, misaamera kaasiinab megamig kømønrrai martrab.” ");
INSERT INTO gum_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Indiibe tøbø pilayu ángel Gabrielwan Galilea, kan pueblo Nazaret tainuumay Tiusbe ørøbig køn, ");
INSERT INTO gum_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kan managuen mu møøba kimø srusrø, María taigwan ashchai. Truibe kan møg, José taig, merrabsrø rey Davidweinukkurrin karrab misaaba kasharanrrab misraig købig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Inchen ángelbe María wainug kebyabe, trenchibig køn: —¡Ka watirru! cha. ¡Tius mayanguen tab indig! Señorbe ñiba pasran cha. Katøgan ishumburmeran lata kømø, ñundø purø tab indig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Inchen Maríabe ángel wamindiilan mørabe, kan øyeeg chib tab wamibe maig kermab isubig køn. Katø ángel øyeeg chib tab wamibe chi chibig kermab isubig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Inchen ángelbe trenchibig køn: —María kørig kui inchimøta cha. Kaguende ñibe Tiuswei merrab mayanguen tabig asønaig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Møimbe kwanrriig kørrømisra, kan nusrkai kal-labene, Jesús munchi pasrtrig chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nøbe purø nuig, Tius Mayeelaim Pala Pasrabigwei Nusrkain cha wamig kønrrun cha. Inchen Señor Tiusbe tru møskai David wamisra ashib karub waigwan tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Inchen nøbe Jacobwei misaameran managatig ashib karub wanrrun cha. Inchen tru nø ashib karub wamibe managuen patsønrraamøn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Inchene Maríabe: —¿Na mu møøbagucha kimíigwane øyeebe chincha purainrrab kø?— cha, payene, ");
INSERT INTO gum_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ángelbe trenchibig køn: —Espíritu Santo ñuim pala kørraarruben, Tius Mayeelaim Pala Pasrabigwei maramburab marøbig kan wañi lataig ñun pinøbulen, treekkurri tru newan tabig kal-lanrrabiibe, Tiuswei Nusrkain cha wamig kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Katø ñimui Elisabetgucha ya køllim palasrø kan nusrkai tøgagønrrab køn cha. Chi ureg tøgagønrrab kaimabig køn taikken seis mesesken kwanrriig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kaguende Tiusweimbe chitøgucha kaimamdiibe kaabig køn— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Inchene Maríabe trenchibig køn: —Nabe Señor maig karuigwan marøb megabig kur cha. Ñi nan maig taig treeg kønrrain— chiben, yandø ángelbe truyugurri ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tru kwalømmerawan Maríabe tamara, Judea pirau tunmeragøba tøga pirømerasrø kan puebloyumay petø ya, ");
INSERT INTO gum_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacaríaswei yau kebyabe, Elisabetwan ‘ka undirru’ chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Inchen Elisabet María ‘ka undirru’ taigwan mørene, unøbe patsø umbu kønaptinchen, Elisabetbe Espíritu Santo netsaig kørrømisra, ");
INSERT INTO gum_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nøbe truba mur wamab trenchibig køn: —Tiusbe maya ishumburmerai utu ñune mayanguen tab kuig kønrrai indig køben, katø ñui patsau tøgagúig unangucha mayanguen tab kuig kønrrai indig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Nan øyeeg lastima asiibe chugurri arrerah? cha, ¿Nai Señorwei usri nan ashchab punrraimbe? ");
INSERT INTO gum_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kaguende ñi nan ‘ka undirru’ cha wamigwan møren latatø, nai unøbe kasrag køptø nai patsø umbu kønaptinndan cha. ");
INSERT INTO gum_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kørebigweimbe mayanguen tab køn cha. Kaguende Señor maig kønrrun cha, chi taibe, nøbe treeg nebunrrai martrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Inchen Maríabe trenchibig køn: “Nai møsiibe Señorwan maya nuguen tabig wamindan cha. ");
INSERT INTO gum_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Katø nai espíritube Tius nai Kaigyugurri Wesrabigweinug truba kasraaran cha. ");
INSERT INTO gum_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kaguende Tiusbe na nø karuigwan marøb megabig, na chigucha kømø waachawan isua asin køn cha. Pøs møingurrimbunøbe misaamera srøig srøig kurrab amrrubeløbe nane mayanguen tab kuig køn chinrrautan cha. ");
INSERT INTO gum_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kaguende Tius maramburab marøbiibe nan purø nørriig tabelø marin køn cha, nui munchibe newan tabig køben. ");
INSERT INTO gum_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Inchen nui lastima asiibe, nun køriibala melabelaimbe, srøig srøig misag kurrab arrimørig truilain kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nui taska chigøben purø nørreelø mara, tru nørreelø truba møg inchib, chigøben martrab isuilane chindinguen møriimíig ka isuitø purainrrai kørrømarin køn cha. ");
INSERT INTO gum_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Karumburab karub purrabelane nøm purramisra karub purraigwan kerrawa, chigucha kømeelan tabigu neerin køn cha. ");
INSERT INTO gum_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Parøgúilane tabig tøgagønrrai unchaguen tranøppe, puarmerane chiguchagar ambasan cha. ");
INSERT INTO gum_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Katø nø karuigwan marøb megabig Israelwan purugun cha, nø lastima asigwan isub, ");
INSERT INTO gum_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tru merrabsrø namui kølli misag Abrahamwanba, nuinukkurri karrab misaameranba maig wamindig managatig treeg kønrrai.” ");
INSERT INTO gum_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Incha Maríabe Elisabetba pøn pølburab kørrømisra, nui yamay katø ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yandø Elisabetwan unø kal-lam kwaløm puben, kan nusrkai tøgagøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Inchen nui ya pulueløba, nui yaueløba Señor nun truba lastima asin kui ashabe, nømbe Elisabetba truba kasraarabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Indiibe ke trune kwalømyube unan circuncidanrrab srua amba, unane munchi pasrøppe, møskawei munchi Zacarías pasrtrab inchen, ");
INSERT INTO gum_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","usrimbe trenchibig køn: —Kah, treeg kømøtø, unøbe Juan munchi kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Inchen nømbe trenchibelø køn: —Mugucha ñimui yaueløbe treeg munchi tøgarbe kaagøn— cha. ");
INSERT INTO gum_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Incha møskawan: “¿Chi munchi pasrtrab?” cha, señas maratø payene, ");
INSERT INTO gum_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Møskaimbe pøramig kan tabla-unø miawabe: “Nui munchibe Juan køn” chib, pørøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Inchen tru urastø Zacaríaswane nilø kemendikkucha kurrøben, wam larraiben, Tiuswan tabig waminchib mendabig køn. ");
INSERT INTO gum_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Treekkurri mayeeløba nui ya pulueløbe truba truba kwaariilø kørrømisren, tru Judea pirau tunmeragøba tøga pirømerasrø warab misaamerabe, øyeelø purayaigwangøba waminchib købelø køn. ");
INSERT INTO gum_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Inchen mayeelø wammørøbeløbe nømui manrrautø esegab trenchibelø køn: —¿I unøbe chi maig kønrrabig kerah?— cha. Kaguende Señorwei tasiibe nøba pasrøben. ");
INSERT INTO gum_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías tru unai møskawane Espíritu Santo netsaben, maig pub attrabigwan øyah chib waminchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israelwei Señor Tiusbe mayanguen tabig wamindig kønrrain cha. Kaguende namun ashchab arrua, nui misagwane katøle nuielø kønrrai wesrun cha. ");
INSERT INTO gum_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Maramburab Marøbig Kaigyugurri Wesranrrabig kusrain køn cha, tru karuigwan marøb megabig Davidwei yaugurri. ");
INSERT INTO gum_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tru merrab manasrøngurri tru Tiusweindø tarømariilø Tius maig karuigwan eshkabeløgurri nø maig taig: ");
INSERT INTO gum_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Namun tru ashikken kømui inchibelainukkurrimba, katø mayeelø namun tsalø inchibelainukkurrimbe wesranrrab cha trendaigwan. ");
INSERT INTO gum_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Merrabsrø namui kølli misaameran truba lastima asigwanba, katø Tius tru misaaba øyeeg martrab cha, tru newan tabig nuinukkurri nø lata kandø isua martrab pasrigwan isumig kønrraimba, ");
INSERT INTO gum_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","tru namui kølli misag Abrahamwan treeg marmø kømø ¡katø! treeg marig kønrrun cha kørrømarig købigwan. ");
INSERT INTO gum_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tru namun ashig kømui inchibelai taskugurri namun wesraikkurrimbe, chigucha chi kørig kuin kømø, nuiwan marøb, ");
INSERT INTO gum_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","katø nam amønain kwalømmerawan kwalømmørig chu urastøgucha nui merrab kerrigu newan tabig, sølgandø marøb kømig kønrrai. ");
INSERT INTO gum_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Inchen ñi nai unøzhiibe, Tius maig karuigwan eshkabig tru Mayeelaim Pala Pasrabigweimburab waminchibig køn taig kønrrun cha. Kaguende ñibe Señorwei merrab inrrabig køn cha, nui maymeran tamarøb, ");
INSERT INTO gum_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","katø kaigyugurri wesrailø kømigwan misaameran nebua ashchai kenamarøb inchab, tru nømui kaig mariilan ulø paymø pesannab indikkurri. ");
INSERT INTO gum_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Namui Tius purø nu lastima asikkurri, kan srø kwaløm pørr tørguegwalmabig neeshibig lataig kal-lanrrun cha, ");
INSERT INTO gum_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","purø løstøyu warabelanba, katø kwamitø itøgasraig warabelanba kebilønrrab. Incha ambumay imay tabig amønam maywan ambamig kønrrai martrab.” ");
INSERT INTO gum_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Inchen unøbe nurab ippe, Tiusweimburabeløyu treetøwei mur pasrabig nurab ya, Israel misaameran kenamisram kwalømgatig mu misag warab waraimøsrø tsubig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tru kwalømmerawan Roma maya misagwan ashib karub wabig César Augustobe treeg maramig kønrrai kan kilga treeg pøra weerig købig køn, chutøgucha misaamera maya nu køtashchab munchimeran tulisamig. ");
INSERT INTO gum_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iig køn, tru srøsrøwan munchimeran tulisingaruig, Cirenio Siria pirausrø kubenadur køb uras. ");
INSERT INTO gum_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Inchen mayeeløba tru trendø nømuim pirau pueblomerasrø munchiwan pøra kørrømartrab ambamig nebubig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Treekkurri Josébe Galilea pirau Nazaret puebloyugurri webya, Judea pirau Belén tru Davidweim pueblo tainuumay ibig køn, kaguende nøbe merrabsrø Davidwei misagugurri arrubig kua. ");
INSERT INTO gum_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Incha Maríaba Belénsrø nømui munchiwan pøra kørrømartrab ibig køn. Maríabe Joséba kasharanrrab misraig kwanrriig købig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Indiibe Belén waramnetø, Maríane unan tammisramig ura puben, ");
INSERT INTO gum_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","nui mayor nusrkawan tøgamisra, may pula, animal maig kan patiayu wayibig køn, kaguende nømuimbe ya pebøbelainuube chu kørrømisramig kaaben. ");
INSERT INTO gum_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Inchen tru pirau Belén pulu møiløgøsrøn ubisha ashibelø ubisha ashib yem warøbene, ");
INSERT INTO gum_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","møimbe Señorwei ángel nømun kenamisren, Señorwei tørguegwalmabig nømuim pøtøgatan kebiløben, nømbe truba truba kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Inchen ángelbe trenchibig køn: —Kørig kui inchimøtay cha. Kaguende ñimun wammørøsrkønrrab kan tabig srøig wam srua arrur cha, mayeelø kasraaramig kønrrai. ");
INSERT INTO gum_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Møi Davidwei puebloyu ñimuyasig kan Kaigyugurri Wesrabig kal-lain køn cha, Cristo tru Señor. ");
INSERT INTO gum_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Incha truig kuitamab asamibe, unane pula, animal maig kan patiayu wayig wetørranrrabguen— cha, trenchibig køn ángelbe. ");
INSERT INTO gum_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Inchen møimbe tru urastø ángelweim pulube katøgan ángelesmera srømbalasreelø kenamisra, Tiuswan tabig waminchib trenchibelø køn: ");
INSERT INTO gum_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Srømbalasrømbe Tiusweimbe purø tabig køn chib kasraarab, katø piraube misaamera Señor nø mayanguen tab kui wamig kønrrai, treeg pønrrabelaimbe ambumay imay mayanguen tab køn!” chib. ");
INSERT INTO gum_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Inchen ángelesmera katø srømbalasrømay amben, ubisha ashibeløbe kangurrin kangurri trenchibelø køn: —Chi purayaitashchab, Señor namun chi taitashchab, møindøwei Belénsrø ashchab amun— cha. ");
INSERT INTO gum_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Incha malla amba, Maríanba, Joséwanba wetørrabelø køn, unane animal main patiayu wayig. ");
INSERT INTO gum_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Incha ashabe, ángel tru unaimburab chi taigwan tru ubisha ashibeløbe eshkaben, ");
INSERT INTO gum_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","mayeeløba chi eshkaigwan mørabe, truba kwaarøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Inchen Maríabe chi tailane treebe maig kermab isub, nuinetø esegabig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Inchen ubisha ashibeløbe katøle ambuppe: —Tiusbe maya nuguen tabig køn chib— truba tabig waminchib ambubelø køn, nøm chi mørigwan nøm chi asigwan, tru ángelesmera maig taig treeg purayaigwan asha. ");
INSERT INTO gum_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Inchen trune kwalømyube unan circuncidamig puben, treeg mara, Jesús munchi pasrøbelø køn. María kwanrriig kømøwatø ángel chi munchi pasringaruig, treeg pasrig købig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Inchen tru maig maramigwan martrai Moisés pørigu maig chibig køben, tru chilliguig kørrømisrigwan chish maram kwalømmera puben, unan Jerusalén ciudayu Señorwan ‘nuin kønrrai tranrrumøn’ chinrrab srua ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tru maig maramigwan martrai Señor pasrigu maig chibig køben treeg: “Mutøgucha srøsrø kal-lab nusrkawane Señorweindø tarømarig kønrrain” taigwan. ");
INSERT INTO gum_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tru maig maramigwan martrai Señor pasrigu maig chibig køben, pagatø nushin kui, kabe pagatø paloma-ureezheelø kui Tiusweyasig trannrrab ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Inchen tru kwalømmerawan kan møg Jerusalén Simeón taig tsubig køn, sølgandø tabig, Tiuswan chu uragucha pesannamíig, Israel misaamera tab kømui melaigugurri webambamigwan muniirabig. Inchen Espíritu Santobe Simeónba pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Incha nune Espíritu Santobe maig kønrrabigwan eshkain købig køn, Criston tru Señorwan ashmøwatøbe ñibe kwanrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Inchen tru møøbe Espíritu Santo inrrai inchen Tiuswei yaumay ya, tru Jesús-unai møskalø tru maig maramigwan martrai Moisés pørigu maig chibig køben, nuimburab martrab Tiuswei yaumay srua amrrubene, ");
INSERT INTO gum_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeónbe Jesús-unan nui kwalyu muta, Tiuswan tabig waminchib, trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Señor, Mayeelaim Pala Pasrabig, na ñi karuig megabigwan chi isumø pishindø tabig kwabashcha chib, ñi nan maig eshkaig købiibe yandø treeg nebui ashar cha. ");
INSERT INTO gum_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kaguende nai kaptøga kaigyugurri ñi wesraig kømigwan ashar cha. ");
INSERT INTO gum_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Truigwane maya misaamera ashen, ñi tamara pasrin køn cha. ");
INSERT INTO gum_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iibe tru maya misag judíos kømeelaimbe ñun kenamaramig tør køben, katø ñui misag israelitasmeraimbe maya nuguen tabig køn” cha. ");
INSERT INTO gum_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Inchen Joséba, Jesúswei usrimba unaimburab tru Simeón maig taigwan mørabe, kan øyeebe maig kermab isub kwaara ashen, ");
INSERT INTO gum_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeónbe mayanguen tab kuilø kønrrain chabe, Jesúswei usri Maríane trenchibig køn: —Au, i unøbe Israel misagwan truba nuwan møilane nørreelø kuigwan chigucha kømeelø kønrrai marøb, møilane nørreelø kønrrai marøb inchabig, treeg køn cha. Tiusweimburabigwan nø kenamaren, misaamera nun kashchab kui asamig, nøbe truig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Truba nu møilaiwan køben, nømui manrrømerayu maig isubelø kuigwan kenamarig kønrrain cha. Inchen ñibe ñui manrrau isubigube kan espadatøga kelarrab kwani lataig isub pusrkwaig kørrømisramig kønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Inchen truyu kan ishug, Tius maig karuigwan eshkabig, Fenuelwei nimbasr, Aserwei misagugurri arrubig, Ana taikkucha wabig køn. Truibe yandø truba køllig købig køn. Truba unø kasharawa, siete años keeba tsua, ");
INSERT INTO gum_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yandø keg kwaben nøtiig kørrømisra, yandø ochenta y cuatro años tøgaig købig køn. Tiuswei yaugurri managucha tarømisrmíig købig køn, Tiuswan køriibala tabig waminchib, ayunab, katø Tiusba waminchib yem, kwaløm Tiusweyasig treeg marøb. ");
INSERT INTO gum_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Inchen Anabe tru urastøwei arrua, Tiuswan ‘mayanguen ungwa, ungwa’ chibig køn. Incha nøbe tru unaimburab waminchib mendabig køn tru mayeelø Jerusalén misag Tiusweilø kønrrai kaigyugurri wesrailø kømigwan isub muniirabelane. ");
INSERT INTO gum_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Incha tru maig maramigwan martrai Señor pasrigu maig karuilan kerrigu chab marabe, Galilea pirau Nazaretsrømay ambubelø køn, tru nømuim puebloyumay. ");
INSERT INTO gum_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Inchen unøbe nurab ippe, murig chishig, purø kusrebig misrøb iben, Tiuswei tru ka yandø tab indiibe nuim pala pasrabig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Inchen nui møskaløbe Jerusalén pascua fiestayumay pilamørig ambubelø købig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Incha Jesúsbe doce años tøgaig misren, fiestayumay ambubelø køn, trendø maig marøbelø køben, treeg martrab. ");
INSERT INTO gum_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Inchen fiesta chab patsøben, nømbe yamay katø amrruben, Jesús-unøbe Jerusalén kørrømisrin køben, møskaløbe ashmuin købig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nømbe tru misag utu unøbe arritamab isua, mawa ambiisrø amba, nømui nømmisaamerai utuba, asiilai utuba lab menda, ");
INSERT INTO gum_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kalawabe, Jerusalénmay katø llirabelø køn, trusrø lanrrab. ");
INSERT INTO gum_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Incha pøn kwalømyube Tiuswei yau tru Moisés pørigwan kusrenanøbelai utu mørøb, nøgurri payib wabyu wetørrabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Inchen mayeeløba mørøbeløbe truba truba kusrebig kui ashib, katø nø maig løtiilan mørøb inchabe, ke kwaara ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Inchen møskalø ashabe, ke kwaara asha, Jesúswei usrimbe trenchibig køn: —¿Nai nusrkai, namun chindimbarre øyeeg margu? cha. Ñui møskaimba, nababe truba truba isuilø lab ker— cha. ");
INSERT INTO gum_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Inchene Jesúsbe trenchibig køn: —¿Nane chinchabrre lague? cha. ¿Nabe nai Møskawei chi maramelan na marøb wamigwan ñimgan ashmeelø køtirru?— cha. ");
INSERT INTO gum_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Inchen nømbe ni chi tainguen mørmeelø køn. ");
INSERT INTO gum_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Inchabe nui møskaløba Nazaretsrømay katø mendig ya, maig karuben treeg mørøb megabig køn. Inchen nui usrimbe kutøgue iilan nui manrrautø isua esegabig køn. ");
INSERT INTO gum_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Inchen Jesúsbe trurrigu kusrebig misrøb, nurab ibig køn, Tius lata, misaamera lata mayanguen tab indinab. ");
INSERT INTO gum_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roma maya misagwan ashib karub wabig Tiberio chabguen quince años karub waben, Pilatobe Judea pirau kubenadur køben, Herodesbe Galilea pirau ashib karub wabig køn. Inchen Herodeswei nuneg Felipebe Iturea pirøwanba, Traconite pirøwanba karub waben, Lisaníasbe Abilinia pirau ashib karub wabig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Inchen Anásba, Caifásbabe maya sacerdotesmeran tru uras nøm karubelø køben, Zacaríaswei nusrkai Juanwan Tius wamindig køn, mu misag warab waraimønug tsuben. ");
INSERT INTO gum_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Inchen Juanbe Jordán pi puluwan chuguen palømø pureb ippe, misaameran mas kaig marmønrrab isua møra, Tiusweimay llirain kønmab asamig piu umbu ulsrailø kømigwan eshkab kusrenanøbig køn, kaig mariilan ulø paymø pesannailø kønrrai. ");
INSERT INTO gum_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Truibe merrabsrø Tius maig karuigwan eshkabig Isaías pørigu maig taig øyeeg: “Kan wam mu misag warab waraimønug trenchib trasan cha: ‘Señorwei maywan tamarøb, nuyasig maymerane ølmarøb inday tan chib. ");
INSERT INTO gum_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kullimera købeløbe netsøganiilø køben, nørrø tunmeraba, shush tunmerababe kanguelarrøtø chag mariilø køben, andul maymerabe ølmariilø køben, mitør maymerabe min mariilø kønrrun chib. ");
INSERT INTO gum_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Inchen maya misaabe Tius misagwan kaigyugurri wesranrrai ørigwan ashchun’ ” taig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Inchen misaamera Juan piu umbu ulsrailø kønrrab webambene, trenchibig køn: —¡Ñimbe ul lataig inchib misaamera! ¿Ñimune mu eshkata cha, Tiuswei purø kørig kømdiig ñimuim pala attrabig pub pasrabigugurri wegørrønrraimbe? ");
INSERT INTO gum_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ñimui kaig mariilan isua møra, Tiusweimay llirawar kuy tørgandø asamdiig kønrrai treelø kua, ñimbe ñimasiitø øyeeg chib mendømøtay cha: “Nambe, Abrahamwei misaamera ker” chib. Kaguende nabe trendamønrrun cha: Tiusbe i sruumeranguen Abrahamwei misaamera kønrrai marøg købene, martrun cha. ");
INSERT INTO gum_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Katø walømbe tusrmeran srølba para øramig chabguen srølyu pasringuen pasran cha. Chi tusrwandøgucha tab mamig niimíigwane para, nagu kegutsan— cha. ");
INSERT INTO gum_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Inchene misaamerabe truba nu pasrabiibe trencha payibelø køn: —¿Nambe chi maramø?— cha. ");
INSERT INTO gum_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Inchen Juanbe trencha løtabig køn: —Møikkøben pa turin tøgaibe chiguchagaigwan kan tranø cha. Inchen møikkøben mamig tøgaibe, chigaigwan pirishi— cha. ");
INSERT INTO gum_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Inchen katø møiløgøsrøn tru romasreelayasig an utabelø piu umbu ulsrailø kønrrab amrruabe, Juanwane trencha payibelø køn: —Kusrennøbig, ¿nambe chi maramø?— cha. ");
INSERT INTO gum_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Inchen Juanbe trenchibig køn: —Anwan maya utønrrai karua pasrigwan menrra utønrrab kømø, maig utamigwandø utønrrigay— cha. ");
INSERT INTO gum_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Inchen katø mø suldaumera køsrøn trencha payibelø køn: —¿Nambe chi maramig kønrrerah?— cha. Inchene nøbe trenchibig køn: —Mun køben ‘chigøben martrumøn’ cha kwaarøsra chigøben kerramøwei, katø mun køben ka isatø chigøben kemesra kebenøsrkømøwei inday cha. Ñim chigøben marøb kuimburø ñimun maig pagaraitøgatø kasraaray— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Inchen misaamerabe ke nungøba isua ashib kuig køppe, Juanwane nømuinetøbe Cristo køppeendimab isub købelø køn. ");
INSERT INTO gum_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Inchen Juanbe mayeelan trenchibig køn: —Nabe ñimune pi pinøbulrrai piu umbu ulsrar cha. Trune nai wendau arrubiibe si, Espíritu Santotøgaba, naatøgaba pinøbulrrun cha. Truibeguende, na lataguen kømø, maramburab marøbig køben, nabe truburab kømíig kua, nui alpargatisyu tsiwanguen pitchabgaig kur chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nøbe tirigun isig øra tarømartrab tru kalagutsamig tsig utigwane sruaguen pasran cha. Incha truyu tru tirigu chishmari yabaløwan kerrigu chab chishmarabe, tirigune tru esegainug esegappe, shauwane mana kwamø nagu pattrab.— ");
INSERT INTO gum_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Incha maig melamigwan treeg marøb melay chib, katøgan øyeelø latailøba misaameran waminchibig køn, Tiuswei tabig srø wamwan. ");
INSERT INTO gum_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Inchen tru Galilea pirau ashib karub wabig Herodesbe nui nuneg Felipei srai Herodíaswan nø pera tsumba, katø chigurrimbunø kaig mariiløgurrimba Juanbe Herodeswane ‘øyeebe kalø køn’ chib namuben, ");
INSERT INTO gum_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodesbe møri urasbe, trubalatø mas kaig marøb, Juanwane merrarrawa, kailan keeri yau pasrøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Inchen Juan maya misagwan piu umbu ulsrøb uñib uras, Jesúswangucha piu umbu ulsraig kuig køn. Inchen Jesús Tius Møskaimba waminchib pasramne, srømbalabe kuren, ");
INSERT INTO gum_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Espíritu Santobe nuim pala kan paloma lataig kørraarruben, srømbalasrøngurrimbe kan wam treeg mørø waminchib trenchibig køn: —Ñibe nai Nusrkai undaaraig køn cha. Nabe ñuimburab truba tab kui war— cha. ");
INSERT INTO gum_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesúsbe nui maramigwan pølbasrøppe chabguen treinta años køsrøn tøgaig købig køn. Jesúsbe Joséwei nusrkain kuitamab isubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Joséwei møskaimbe Elí køben, Elíwei møskaimbe Matat købig køn. Matatwei møskaimbe Leví køben, Levíwei møskaimbe Melqui køben, Melquiwei møskaimbe Jana køben, Janai møskaimbe José købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joséwei møskaimbe Matatías køben, Matatíaswei møskaimbe Amós køben, Amóswei møskaimbe Nahum køben, Nahumwei møskaimbe Esli køben, Esliwei møskaimbe Nagai købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiwei møskaimbe Maat køben, Maatwei møskaimbe Matatías køben, Matatíaswei møskaimbe Semei køben, Semeiwei møskaimbe José køben, Joséwei møskaimbe Judá købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judáwei møskaimbe Joanan køben, Joananwei møskaimbe Resa køben, Resai møskaimbe Zorobabel køben, Zorobabelwei møskaimbe Salatiel køben, Salatielwei møskaimbe Neri købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerii møskaimbe Melqui køben, Melquiwei møskaimbe Adi køben, Adii møskaimbe Cosam køben, Cosamwei møskaimbe Elmodam køben, Elmodamwei møskaimbe Er købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erwei møskaimbe Josué køben, Josuéwei møskaimbe Eliezer køben, Eliezerwei møskaimbe Jorim køben, Jorimwei møskaimbe Matat købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatwei møskaimbe Leví køben, Levíwei møskaimbe Simeón køben, Simeónwei møskaimbe Judá køben, Judáwei møskaimbe José køben, Joséwei møskaimbe Jonám køben, Jonámwei møskaimbe Eliaquim køben, Eliaquimwei møskaimbe Melea købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleai møskaimbe Mena køben, Menai møskaimbe Matata køben, Matatai møskaimbe Natán købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánwei møskaimbe David køben, Davidwei møskaimbe Isaí køben, Isaíwei møskaimbe Obed køben, Obedwei møskaimbe Booz køben, Boozwei møskaimbe Salomón køben, Salomónwei møskaimbe Naasón købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasónwei møskaimbe Aminadab køben, Aminadabwei møskaimbe Admin køben, Adminwei møskaimbe Arni køben, Arnii møskaimbe Esrom køben, Esromwei møskaimbe Fares køben, Fareswei møskaimbe Judá købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judáwei møskaimbe Jacob køben, Jacobwei møskaimbe Isaac køben, Isaacwei møskaimbe Abraham køben, Abrahamwei møskaimbe Taré køben, Taréwei møskaimbe Nacor køben, Nacorwei møskaimbe Serug købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serugwei møskaimbe Ragau køben, Ragauwei møskaimbe Peleg køben, Pelegwei møskaimbe Heber køben, Heberwei møskaimbe Sélaj køben, Sélajwei møskaimbe Cainán købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainánwei møskaimbe Arfaxad køben, Arfaxadwei møskaimbe Sem køben, Semwei møskaimbe Noé køben, Noéwei møskaimbe Lamec købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecwei møskaimbe Matusalén køben, Matusalénwei møskaimbe Enoc køben, Enocwei møskaimbe Jared køben, Jaredwei møskaimbe Mahalaleel køben, Mahalaleelwei møskaimbe Cainán købig køn. ");
INSERT INTO gum_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánwei møskaimbe Enós køben Enóswei møskaimbe Set køben, Setwei møskaimbe Adán køben, Adánwei Møskaimbe Tius køn. ");
INSERT INTO gum_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús Espíritu Santotø netsaig Jordán piyugurri katø arruben, Espíritu Santobe mu misag warab waraimøsrømay pera iben, ");
INSERT INTO gum_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","truyu kwalømmera cuarenta nemisramne tsuben, nugwaimandziibe ke kebenøsrkønrrab marøbig køn. Tru kwalømmerawan chigucha mamøwa, yandø parøgwai møren, ");
INSERT INTO gum_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","nugwaimandziibe: —Ñi isa kømø, Tiuswei nusrkain kuabe, i srugwan ‘pirri misr’ cha, trenchi— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Inchene Jesúsbe trencha løtabig køn: —Tiuswei wamwan pørigube trenchibig pørig pasran cha: “Møøbe pirrindøgatø øsig tsumig kømøn” chibig.— ");
INSERT INTO gum_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Inchen nugwaimandziibe kan tun palasrømay pera ya, yu pirau chutøgucha nørreelø nøm ashib karub purrailan kerriguba ke pestø Jesúswan eshkab kenamarabe, ");
INSERT INTO gum_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","trenchibig køn: —Nabe ñi karumburab karumigwan kerrigu ñun tranøb, katø nømui chigurrimbunø purø tabig tørigwan tranøb inchumøn cha. Kaguende nane iilan kerrigu tranig køn cha. Incha nabe mun tranøg køben, tranamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Inchawei ñi nan tømbasra, køriibala tabig waminchene, iibe kerriguba ñuin kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Inchene Jesúsbe trencha løtabig køn: —Trenchibig pørig pasran cha: “Señor ñui Tiuswandø køriibala tabig waminchib, nuyasiitø marøb megamig køn” chibig.— ");
INSERT INTO gum_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Inchen trugurrimbe nugwaimandziibe Jerusalén ciudasrømay pera ya, tru Tiuswei yau purø palasrø pasrabe, trenchibig køn: —Isa kømø, ñi Tiuswei Nusrkain kuabe, yugurri pirausrø pørsrau cha, ");
INSERT INTO gum_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kaguende Tiuswei wamyube trenchibig pørig pasran cha: “Tiusbe nui ángelesmeran ñun chinchimønrrai ashchai ørtrun chibig. ");
INSERT INTO gum_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Incha ñui srøbwan srugu srurrengwamønrrai nømui tasiimeratøga ñune kusranrrun” chibig.— ");
INSERT INTO gum_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Inchen Jesúsbe trencha løtabig køn: —Øyeeg chibig pasran cha: “Ñui Señor Tiuswane ke chinchibig køtashchab lataikkucha maramig kømøn” chibig.— ");
INSERT INTO gum_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Inchen nugwaimandziibe øyeeg chiyutø kebenøsrkønrrab indamigwan kerrigu chab marabe, Jesúsweim pulugurri maya yana køsrøn tarømisrøbig køn, katøle treeg maramdiig pumnegatig. ");
INSERT INTO gum_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús Espíritu Santoi maramburab maramigwan tøgaig Galileamay katø arruben, tru pirau tru pøtøgatanbe chutøgucha nungøba, nungøba waminchib købelø køn. ");
INSERT INTO gum_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Inchen judíosmera tulundzuni yamørig nøbe kusrenanen, mayeeløba nun truba tabig waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Incha Jesúsbe nø nurainuumay Nazaretsrømay ya, nø trendø treeg marøbig køppe, isrin kwalømbe judíosmera tulundzuni yau kebya, lenrrab pasramisren, ");
INSERT INTO gum_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tius maig karuigwan eshkabig Isaíaswei pørigwan lenrrai tranen, larrøbicha kurøppe, øyeeg pørig pasrabigu kurøbig køn: ");
INSERT INTO gum_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Señor Tiuswei Espíritube naim pala pasran cha. Kaguende nane waachameran tabig srøigwan eshkanrrai aceite itølusha tarømarig køn cha; merrarraig pønrrabelan ‘Elatsiilø kønrrun’ chinrraimba, katø kabgarwan ashibelø kønrrai martraimba, katø kaig indinab melabelane, amrrai wesrab inchaimba, ");
INSERT INTO gum_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","katø Señorwei truba tab pila attrabigwangucha eshkanrraimba nane ørig køn” chibigwan. ");
INSERT INTO gum_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Incha Jesúsbe tru pørig tøgaigwan judíosmera tulundzuni yau purugubigwan katøle kirra tranabe, wamisrøbig køn. Inchen mayeeløba judíosmera tulundzuni yau purrabeløbe ke nungøba ashib purrabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Inchen nøbe trenchib eshkab mendabig køn: —Na leben ñim mørig, i Tiuswei wam pøriibe, ñimui merrab møi yandø treeg nebun— cha. ");
INSERT INTO gum_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Inchen misaabe mayeeløba nuimburab tabig waminchib, katø nui trigugurri purø tabzhig wamindi wammeran ke kwaara ashib trenchibelø køn: —¿Iibe Joséwei nusrkain kømmørgøppeh?— cha. ");
INSERT INTO gum_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Inchen Jesúsbe trenchibig køn: —Ñimbe nane indzabelø chibgunrrig øyeeg chinrrautan cha: “Ñi mø marøbiibe ñiasiitøwei mø mar” cha. Katø nane: “Ñi Capernaumsrø chine, chine mariilan nam tru wammørigwan, yu ñuim piraugucha treegwei mar”,— cha. ");
INSERT INTO gum_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Inchabe katø trenchibig køn: —Nabe ñimun cierton trendamønrrun cha: Tius maig karuigwan eshkabigwane møigwanguen nui piraueløtøweimbe chi tab indiimíig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Isa kømø, Tius maig karuigwan eshkabig Elías uñib uras tru pøn pila y tøbø pila sre pumubenma, tru pirau ørøba truba truba parø pasrøben, Israel misaamerai utube piudamera truba yam waraingucha, ");
INSERT INTO gum_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tiusbe Elíaswane Israel pirau warabelan purugunrrab ørmøtø, Sidón ciuda pulu Sareptasrø tsub piudan purugunrrab ørig købig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Katø Tius maig karuigwan eshkabig Eliseo uñib uras chigucha, Israel misaamerai utube lepra kwanrreelø truba nu kuig køn cha. Inchendø truiløbe ni kanguen kwanrrøwan chishmariimeelø køben, Siria pirausriig Naamánwane kwanrrøwan chishmarig købig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Inchen iigwan mørøppe, judíosmera tulundzuni yau purrabeløbe namig købiitø ke chinchimmørø incha, ");
INSERT INTO gum_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","kurra pønrramisra, puebloyugurri weera, tru nøm waramig ciuda marim pasrab tunyu pala trømbøsrømay pera ambubelø køn, trusrø pinørtrab. ");
INSERT INTO gum_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Inchen Jesúsbe nømuin tøbøtagwan pureppa, iptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Incha Jesúsbe Galilea pirau Capernaum puebloyumay ya, isrin kwalømmerawan misagwan kusrenanøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Inchen nø kusrenanigwane kwaara ashibelø køn, kaguende nø wamindiiløbe mu mandamgaig wamindig køben. ");
INSERT INTO gum_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Inchen judíosmera tulundzuni yau kan trømbøig maringarub kwaimandzig tøgaig wawabe, mur trashib trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Au! ¿Nambabe ñibe chi asamig tøgagugu cha, Nazaretsrø Jesús? ¿Namun pinishinrrab attirru? cha. Nabe ñune mu kui ashar chibig køn. Ñibe tru Tiuswei Newan Tabig, truig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Inchen Jesúsbe kwaimandzigwan namab trenchibig køn: —¡Ñibe trashimøtø, møweinukkurrimbe webinrrø!— cha. Inchen kwaimandziibe nøm mayeelai merrab møwane pirau penøsrka, tru møweinukkurri webibig køn, chigucha chi kørriinchimøtø. ");
INSERT INTO gum_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Inchen mayeeløba kwaara, kangurrin kangurri: —¿Kan øyeeg wamindi wammerabe chi køh? chibelø køn. ¡I møøbe mu mandamgaig karuitøgaba, maramburab mariitøgaba trømbøig maringarub kwaimandziimeranguen webingaruben, truilø webamrrappe!— ");
INSERT INTO gum_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Inchen nune tru pirau ørøba chutøgucha nun, nun waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Incha Jesús judíosmera tulundzuni yaugurri webya, Simónwei yau kebibene, Simónwei sueerabe mur pachiiba kwanrrø tsuben, nømbe kwanrriigweyasig Jesúswan: —Purugurra— cha, rugaben, ");
INSERT INTO gum_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesúsbe kwanrriigweimbala utsøbasrabe, pachigwan webinrrai kandø wamøben, pachiibe weetaptinchen, nøbe tru urastø kurra, tru pubelayasig chi maramigwan marøb mendabig køn. ");
INSERT INTO gum_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yandø nøsig pinaiben mayeeløba chi kwanrrø køben tøgarmeran misaamerabe Jesúsweimay srua amrruben, kwanrreelømørig nøbe nui tasiimeran nømuim pala estsara, tamarøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Inchen katø truyu møilan køben truba yamelainukkurri kwaimandziimerabe trenchib trashib webambubelø køn: —Ñibe Tiuswei Nusrkain køn— chib. Inchen Jesúsbe kwaimandziimerane kandø wamab, waminchibashmíig køn, kaguende nømbe Cristo kui ashibelø køben. ");
INSERT INTO gum_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yandø chab tør-rraben Jesúsbe ciudayugurri webya, katøganbalø mu misakkasrø tarømisra iben, misaamerabe lab kua, nø waisrø puabe, ibashmønrrab inchen, ");
INSERT INTO gum_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesúsbe trenchibig køn: —Misag søtømera katøganbaløsrø warabelangucha nabe Tius nø ashib karub pasrainuguigwei tabig srøigwan eshkab kusrenanamig køn cha. Kaguende truweiwei ørig kur— cha. ");
INSERT INTO gum_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Incha Judeasrø judíosmera tulundzuni yamerayu Jesúsbe eshkab kusrenanøb uñibig køn Tiuswei wamwan. ");
INSERT INTO gum_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kan kwaløm Jesús Genesaret nu pisu menda pasrøbene, misaamerabe Tiuswei wamwan mørtrab nuingatan ke nømdø trawaguchib tulundzunøben, ");
INSERT INTO gum_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","nøbe tru pisu mendabe pagatø barcomera mu misakkar pønrrai ashibig køn, kaguende peskabeløbe truyugurri webamba, nømui atarrayameran chishmarøb warøben. ");
INSERT INTO gum_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Inchen Jesúsbe tru pagatø barcomera pønrrabyu tru Simónwei barcoyu kebyabe, pi mendagurri katøguchi amburøsrø ørtra cha, nøbe tru barcoyu wamisra, truyugurri misagwan kusrenanøb mendabig køn. ");
INSERT INTO gum_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Incha yandø chab waminchabe, Simónwane trenchibig køn: —Barcon amburø mas umbu pisrø øra, peskanrrab ñimui atarrayameran kebetay— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Inchen Simónbe trencha løtabig køn: —Kusrennøbig, nambe kwalma kwalma peskab meløbendø, kanguen wesranrrab kaymer cha. Inchendø ke ñi trendaig køptø, atarrayan kegutchab— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Incha keguchene, peskaube nu kegørraptø atarrayabe kølsrøb mendøben, ");
INSERT INTO gum_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","nømbe nømui lincha amøñibelø katøgan barcoyu purrabelan, purugunrrab amrrunrrai keberen, nømbe amrrua, pa barcomeran peskautø netsøganen, barcomerabe piu ke asentanrraptiig inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Inchen trunun ashabe, Simón Pedrobe Jesúswei srøb pulu tømbønsrøb trenchibig køn: —Señor, naim pulugurri tarømisrtra cha. Kaguen nabe kaig marøb møg kur— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Peskau treeg nørrø wesraikkurri Simónbe truyu mayeelø nøba pønrrabeløba kwaarøbiitø ke chindamdiig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Katø tru Zebedeowei nusrkalø Jacoboba, Juanba, tru Simónwei trendø lincha peskab amøñibeløgucha treetøwein kørig kui inchibelø køn. Inchene Jesúsbe Simónwan trenchibig køn: —Chi kørig kui inchimøta cha, møingurrimbunøbe misaameran peskabig kønrrig— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Inchen nømbe barcomeran pisu mendasrø wesrawabe, kerrigu pønrramnetø, Jesúswei mendig ambuptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús mø pueblomerayu køsrøn tsubene, kan møg asr trerab kwanrrø, lepra taig, tøgaig pua, Jesúswan ashabe, tømbønsra, maløwanguen pirau kebatamnegatig utsøbasrabe, trenchib miabig køn: —Señor, nan ñi tamaramdiig købene, tamartra— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Inchen Jesúsbe tasigwan larrøbicha estsarabe, trenchibig køn: —Tamarøg køtan cha. Tamarig kørrømisr— cha. Inchen tru urastø nui trerab kwanrrøbe chishig kørrømisren, ");
INSERT INTO gum_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesúsbe trencha karubig køn: —Au, mungøben eshkawabesin cha. Inchendø ya, ñui asrwan sacerdotendø kenamara, tru ñi yandø chishig kørrømisrimburø tru Moisés trannrrig taigwane srua ya, tranrrig cha, mayeeløba ñui kwanrrøwan chishig kørrømisrin kui ashchain— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Treendingucha Jesúswane ke nun, nun waminchen, nune mas wammørig kørrømisren, misaamerabe truba nørrø nun mørtrappa, katø nømui kwanrrømeran tamariilø kønrrappa tulundzunabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Inchendø Jesúsbe chugøben mu misakkasrø ya, truyu Tius Møskaimba waminchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kan kwaløm Jesús kusrenanøb wabene, møiløgøsrøn fariseosmeraba, tru maig maramigwan martrai Moisés pørigwan kusrenanøbeløba truyu purrabelø køn. Truiløbe Galilea pirau maya pueblosrøngurrimba, Judea pirausrøngurrimba, Jerusaléngurrimba amrruar. Inchen Tiuswei maramburab maramibe Jesúsba pasrabig køn kwanrreelan tamarøb. ");
INSERT INTO gum_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Inchen mø møguelø køsrøn katøgan møg kønønrrab kaimabigwan tsigalyu muta pua, yau keera, Jesúswei merrab pasrtrab inchendø, ");
INSERT INTO gum_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","mumayguen kebambamig wetørranrrab kaimabelø køn. Kaguende menrra misag pasrøben, trugurri ya pala nebamba, tejameran picha, trab kura, kwanrriigwan tsigalbañau misag utu Jesúswei merrab kørrøørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Inchen Jesúsbe nømui isubigwan ke nuinuutø pasra ashabe, kwanrriigwane trenchibig køn: —Au, kasuku, ñui kaig mariilane yandø ulø payamig kømíig pesannaig kørrømisran— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Inchene tru Moisés pørigwan kusrenanøbeløba fariseosmerababe treeg isub mendabelø køn: “I møg Tiusweimburab purø trømbøig wamab waminchibiibe, ¿mu køh? cha. Kaguende kaig mariilan ulø payamig kømíig pesannaig kønrraimbe ¿mu kuin treeg mariasamø? cha, Tiustøweimbe treeg martrun” chib, isubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Inchen Jesúsbe nøm chi isub pønrrailan kelarrab ashabe, trenchibig køn: —¿Ñimbe ñimui manrraube chindimba øyeeg isugue? cha. ");
INSERT INTO gum_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Møigwan mas kørmø trendamdiig købsruerah? cha. Kabe: “Ñui kaig mariilan ulø payamig kømíig pesannaig kørrømisran” ¿tamiteh? Kabe: “Kurrab, inrrø” ¿tamiteh? cha. ");
INSERT INTO gum_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pøs, na, Møg Misra Arrubiibe yu pirau kaig mariilan ulø payamig kømíig pesannaig kønrrai mu mandamgaig marøbig kui møimbe ñim ashchai kenamaramønrrun— chibig køn. Inchabe tru kønønrrab kaimabigwane trenchibig køn: —Nabe ñun trenchar cha: Kurrab, ñui tsigalwan mutab, ñui yamay inrrø— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Inchen tru urastø tru kwanrriibe nømui merrabgurri kurra, nø tsuig tsigalwan muta, Tiuswan truba tabig waminchib nui yamay ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Inchene mayeeløba kwaara asha kørrømisra, Tiuswan truba tabig waminchib, truba kwaariilø: —Møin kwaløm kan yeekkucha tabelø mari aser— cha trenchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Øyeeg purayaig wendø Jesús webyabe, kan møg Leví taig, romasreelayasig an utabelø purrainug wai ashabe, trenchibig køn: —Nai mendig amø— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Inchen Levíbe chi tøgagúigwan kerrigu kørrømarabe, kurrappa, Jesúswei mendig ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Incha trugurrimbe Levíbe Jesúsweyasig nui yau truba nu fiesta maren, tru romasreelayasig an utabelø truba yameløba, katøganeløba mishatsigu nømba truba nu purrabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Inchen fariseosmeraba, tru Moisés pørigwan kusrenanøbeløbabe nui kusrenanøb pera uniilane namig, Jesúsweimburab chinetø chib, trenchibelø køn: —¿An utabeløba, kaig marøbeløba ñimbe truiløbabe chindimba lincha mab, muchigue?— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Inchene Jesúsbe nømune trencha løtabig køn: —Tabelø, kwanrrøgarbe mø marøbig palain kømøn cha. Kwanrreeløbeguende palain køn cha. ");
INSERT INTO gum_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nabe tru sølgandø amøñibelan wamønrrab arrumøtø, kaig marøbelan wamønrrab arrig køn cha, yandø nømui kaig mariilan isua mørøb, Tiusweimay lliranrrai.— ");
INSERT INTO gum_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Inchen kaneløbe Jesúswan trencha payibelø køn: —Juanwei mendig amøñibeløbe katø katø truba ayunab, katø Tiusba waminchib indamigwan marøbelø køn cha. Katø fariseosmerai mendig amøñibelø treetøwei maren, trune ñuieløbe ka mab, ka muchib inchibelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Inchene Jesúsbe trencha løtabig køn: —¿Kan novios yaumay linchai eshkailanma keg mistrabig nømba wabengan, mamø purrønrrai inchaitarru? cha. ");
INSERT INTO gum_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Inchendø yandø keg mistrabigwan srua ambam kwalømmera punrrun cha. Inchen tru kwalømmerawane ayunabwei inchun— cha. ");
INSERT INTO gum_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Incha katø Jesúsbe ‘øyeeg lataitøwein køn’ cha, kemesra trenchibig køn: —Mugucha kan srø camisanma para wesrumøn cha, køllin camisayu waya tsushinrrab. Treeg marene, srø camisabe ka minchen, inchagucha srøigwan waya tsusaibe køllin camisayube chi tab punrraamøn chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Katø muguen srø vinonma køllin kalusmerayu usrmøwei indan cha. Kaguende treeg marene, srø vinobe kalusmeran srurrøgøben, vinobe lushen, kalusmerabe ka kølsran cha. ");
INSERT INTO gum_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Inchawei srø vinone srø kalusmeran marigu usramig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Katø mugucha øl-laig vinon muchibiima srø vinone mugucha muchig kømui indan cha. Kaguende: “Øl-laibe mas mayig køn” chibelø køn— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kan isrin kwaløm Jesús tirigu ellmarig utuwan pureb ibene, nui kusrenanøb pera uniiløbe tirigu turmeran lurrøb ambabe, tirigu turwan tasiitøga katsøsra, mabene, ");
INSERT INTO gum_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","mø fariseosmera køsrøn nømune trenchibelø køn: —Ya isrin kwaløm chigøben marmønrrai merigwan ¿ñimbe chindimba øyeeg margue?— cha. ");
INSERT INTO gum_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Inchene Jesús trencha løtabig køn: —¿Ñimgan lemeelø køtirru cha, tru mana køsrøn Davidwan parøgwab, nui linchibelan parøgwab inchen, nø mandø indigwan? ");
INSERT INTO gum_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nøbe Tiuswei carpa ya tabzhigu kebya, Tiusweyasiitø tarømarig pirrimera, tru sacerdotesmeratø maim pirrimeran mendaibe mu mamønrrai meriilan nø mab, katø nøba purrab misagwangucha srørrøb indigwan.— ");
INSERT INTO gum_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Incha katø trenchibig køn: —Møg Misra Arrubiibe tru isrin kwaløm nan nø karunrrain kømøtø, maramdiigwane marøb, maramgaigwane marmub, nabe na asha karubig kur— cha. ");
INSERT INTO gum_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Indiibe katøgan kwaløm isrin kwalømdøwei Jesúsbe judíosmera tulundzuni yau kebya, kusrenanøb pasrøbene, truyube kan møg nui kusrmay tasig mul-laig tøgaig waben, ");
INSERT INTO gum_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","tru Moisés pørigwan kusrenanøbeløba, fariseosmerababe Jesúswan larab købelø køn, isrin kwaløm tamarøbig køtashchab, chigøben chi køptø. ");
INSERT INTO gum_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Inchen nøbe chi isub pønrrailan asha, tru tasig mul-laig tøga møwane: —Kurra, uyu tøbøtag pasramisr— cha trenchibig køn. Inchen tru møøbe nømuin tøbøtag kurra pasramisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Inchen Jesúsbe katøganelan trenchibig køn: —Na ñimun payrrab inchar cha: ¿Maig maramigwan martrai Moisés pøriibe isrin kwalømbe chiwan martrain taig køh cha, tabiiteh, kabe kaiteh cha; kwamønrrai indamig køh, kabe kweetsamig kø, chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Incha Jesúsbe mayeelø nuim pøtøgatan pønrrabelan ashabe, tru møwan trenchibig køn: —Kwalwan larrøbichi— cha. Inchen møøbe treeg inchen, nui kwalbe tabig kørrømisrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Inchen treekkurri kaneløbe truba nama, kangurrin kangurri Jesúswan chi kaig maramdiig køtashchab payib mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tru kwalømmerawan Jesús kan tun palasrø Tius Møskaimba waminchab ya, kwalma ørøba treeg marøb wawa, ");
INSERT INTO gum_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","tør-rrabene, nui kusrenanøb pera uniilan wama, truilai utu doce lawa, wesrawa, truilane nøashib karua øriilø køn cha, wamabig køn. ");
INSERT INTO gum_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Truiløbe iilø køn: Simón, nundøwei katø Pedro cha munchi pasrig køben, Simónwei nuneg Andrés køben, Santiago køben, Juan køben, Felipe køben, Bartolomé køben, ");
INSERT INTO gum_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo køben, Tomás køben, Alfeowei nusrkai Santiago køben, Simón Zelote cha wamig køben, ");
INSERT INTO gum_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Santiagoi nusrkain køben, Judas Iscariote, tru wendø Jesúswan ashig kømui inchibelaingatø pasramisra, trannrrabig købengue. ");
INSERT INTO gum_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Incha Jesús tun palasrøngurri nømba kørraarrua, kan chagu pasramisrøbig køn. Inchen truyu nui mendig amøñibeløbe truba nu tulundzuna, pasrabig køn, Judea pirauelø kerrigu, jerusalénsreelø køben, Tiroba, Sidónba tru mar pulusreelø køben, ");
INSERT INTO gum_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","truiløbe Jesúswan mørtrab amrruin købig køn, nømui kwanrrømeran tamartraimba. Inchen tru kwanrreelø trømbøig maringarub kwaimandziimera larrø trømbøig kuig melønrrai marinabeløbe tamariilø køben, ");
INSERT INTO gum_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","maya misaabe nun katøranrrab inchibelø køn, kaguende Jesúswei maramburab marøbig nuinukkurri webarrua, mayeelanba tamaren. ");
INSERT INTO gum_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Incha Jesús nui kusrenanøb pera uniilan ashabe trenchibig køn: —Mayanguen tab kuilø køn cha, ñim waachamerabe. Kaguende Tius nø ashib karub waibe ñimuiwein køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mayanguen tab kuilø køn cha, ñim møi ya parøgwailøbe. Kaguende maig palai melaigwan Tiusbe nømun unchaguen traniilø kønrrun cha. Mayanguen tab kuilø køn cha, ñim møi ya kishibeløbe. Kaguende wendøbe indzønrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mayanguen tab kuilø køn cha, ñimun misaamera tsalø ashib, ñimune nøørø kønrrai tarømarøb, ñimun tsalø waminab, ñimui munchiwan ke kaigwan lataig indinab, tru na, Møg Misra Arrubikkurrindø ñimun treeg marene. ");
INSERT INTO gum_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","’Treeg pureb kwalømbe ñimbe truba truba tab kui mørøb, truba kasraarab pørtray chibig køn. Kaguende truburø ñimbe srømbalasrømbe truba nuig ketig utamig tøgagønrrun cha. Kaguende merrabsrø nømui kølli misaamerama Tius maig karuigwan eshkabelan øyeegwei kaig marøbelø kuig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","¡Ay, ñim waacha, puarmeraimbe! Kaguende yandø tsabøtø utarguen køn cha, kasrag købigwan. ");
INSERT INTO gum_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Ay, ñim waacha, møi ya chi palømø tøgarbe! Parøgwai mørtrun cha. ¡Ay, ñim waacha, møi ya indzabeløbe! Ñimbe wamamøra isub kishchun cha. ");
INSERT INTO gum_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Ay, ñim waacha, ñimun mayeelø tabig wamindinabelaimbe! Kaguende ñimui merrabsrø kølli misaamerama treetøwei tabig waminchibelø købig køn cha, tru ‘Tius maig karuigwan eshkabelø ker’ chib isabelan. ");
INSERT INTO gum_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Inchendø ñim nan mørøbelane nabe trendamønrrun: Ñimun ashig kømui inchibelane undaarab, ñimun tsalø kui inchibelane tabig marøb inday cha. ");
INSERT INTO gum_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ñimun ‘trømbøig nebubash’ chib wamabelaimbe ñimbe nømune ‘mayanguen tabig nebunrray’ chib trenday cha. Ñimun kaig marøbelaimbe, nømuyasig Tiusba wamindamig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Møikkøben ñun kandarø maløbøtø pashene, kandariigwangucha yul cha. Møikkøben ñui turiwan kerrabene, ñui camisangucha ka srua ibasingaru cha. ");
INSERT INTO gum_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ñun mu chi miabigwane tranøb, chiwan køben ñuiwan kerrabene, miamøta cha. ");
INSERT INTO gum_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ñimgurrima katøganelø ñimuyasig tabig maramig palai inchibeløbe, ñimgucha katøganelan treetøwei tab inday chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ñim ñimun undaarabelandø undaarawabe, ¿ñimbe chigúin tabig martrague? cha. Kaguende kaig marøbeløguen nømun undaguelane nømgucha undaarabelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ñim ñimun tab inchibelandøwei tab inchabe, ¿ñimbe chigúin tabig martrague? cha. Kaguende kaig marøbeløgucha treetøweimbe marøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Peba tranøppe, katø utamdeelandø pebøbeløbe, ¿ñimbe chigúin tabig martrague? cha. Kaguende kaig marøbeløgucha katøganelø kaig marøbelandøweimbe, katø kerriguwan treetøwei utønrrab pebøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Trune ñimbe ñimui ashig kømui inchibelan undaarab, tabig marøb, pebøb indamig køn, katøyug utønrrab isua kømøtø. Treeg marene, ñimui utamibe truba nuig køben, ñimbe Tius Mayeelaim Pala Pasrabigwei ureemera kønrrun chibig køn. Kaguende nøma chiweinguen ungwaguengarwan, larrø kailan, tab inchibig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ñimui Tius Møskaima lastima ashibig købene, ñimgucha treetøwei lastima ashibelø kuy cha. ");
INSERT INTO gum_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ñimbe katøganelan ‘øyeeg køn, øyeeg marøbelø køn’ chib waminchimøtay, ñimungucha ‘øyeelø, øyeelø køn’ chimønrraimbe. Katøganelan kaigyu pønrrønrrai pønsrømøtay, ñimun treetøwei kaigyu pønrrønrrai pønsrømønrraimbe. Ñimun kaig maren, ulø paymø pesannay, ñimungucha Tius ulø paymø pesannailø kønrrappe. ");
INSERT INTO gum_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Katøganelan tranay; ñimungucha tranrrun, talegayu tab unaasig tingandø kørrøguana, pinølusam netsøganig. Kaguende ñim kanelan maig unaasha traniibe, ñimungucha treetøwei unaasha tranrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Incha katø Jesúsbe ‘øyeeg lataitøwein køn’ cha, kemesra trenchibig køn: —¿Kan ashchab kaimabiima katøgan ashchab kaimabigwandøwei srua inrrautah? cha. ¿Pailøba treeløtøbe trabyu kegørrømønrraitarru? chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kan kusreb mendig megabiibe nui kusrenanøbigwan purab nuig kømøn. Inchendø chi kusremigwan ne kusrewabeguende, nun kusrenanøbig lataitøwein kønrrun. ");
INSERT INTO gum_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Chindimbarre ñui nunewan kabyu shauzhig wabigwangøba ashku cha, tru ñuin kabyu nu tsig wabigwanguen ashmubendøbe? ");
INSERT INTO gum_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Inchawei ñitøweinguen ñuin kabyu nu tsigwan ashmubendøbe, ñui nunewane chincha øyeeg chinrragu: “Nai nuneg, ¿ñuin kabyu shauzhig wabigwan wesrarruah?” cha. ¡Ñi, palatø tabig! Ñuin kabyu nu tsig wabigwanmerrig wesru chibig køn. Treenchabe si, ñui nunewein kabyu shauzhig wabigwan wesrumig tab ashchabguen cha. ");
INSERT INTO gum_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Kan tab tusrbe kaig mamig niimíig køben, katø kan kaig tusrbe tab mamig niimíig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kaguende tusrmørig chi mamig niguen tabig kui, kaig kui truyu asan cha. Kal tusrmerayugurri yashig lurrmøwei, kaldø misrøb tusryugurri uvas lurrmøwei inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Inchawei kan møg tabiibe tabig isuilan nui manrrau esegabig kua, truyugurrimbe tabig wesrub wamindan. Inchen kan møg kaibe kaig isuilan nui manrrau esegabig kua, truyugurrimbe kaig wesrub wamindan. Inchawei nui manrrau chine isua tøgagúilø pinøguchen, nui triibe treeg wamindan chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Ñimbe nane chindimba: “Señor, Señor” chib wamøgue cha, na maig karuigwane møra marmeelø købendøbe? ");
INSERT INTO gum_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mugucha naimay arrua, nan møra, na maig taigwan marøbigwane, øyeeg møg lataig køn tamønrrun cha: ");
INSERT INTO gum_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Truibe kan møg yawan martraptø pirøwanmerrig srugu larrayamnegatig umbu lalla, trugurrimbe tru srug pala yawan niga pasrønrrabigwan marøbig lataig køn cha. Inchen pibe nurawa, arrua, tru yawan purø trømbøig neguchib megambuagucha, kønøgønrrab kaiman cha, kaguende purø may mara pasrig kua. ");
INSERT INTO gum_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Inchen kan møg nan mørendø, na maig karuigwan marmíibe, nui yawan niga pasrønrrabig srug pusrmøtø, ka pirø palatø kusrubig lataig køn cha. Pi nurawa arrubig, tru yawan mur megambub neguchene, tru yabe kebeñen, kerrigu pinisaig kørrømisran— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yandø misagwan Jesúsbe chab waminchabe, Capernaumsrø kebibene, ");
INSERT INTO gum_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","truyu kan romanosmerai suldau, cienelan ashibig, centurión taig, kan karuindiig megabig truba undaaraig tøgagúibe, truibe kwanrrøtøga yandø ke pinamdø palabig tsubig køn. ");
INSERT INTO gum_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Inchen tru cien suldaumeran ashibiibe, Jesúswan wamindi mørabe, judío misaameran karubelø kølli misaameran karua ørøbig køn, nui kwanrriigwan tamartrab attrai. ");
INSERT INTO gum_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inchen nømbe amba, Jesúsweim pulu kemallabe, ke tiusmanda chib truba inchib trenchibelø køn: —Tru møwane ñi treeg ka purugumdiig treeg møg køn cha. ");
INSERT INTO gum_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kaguende yu nam warain pirau maya misagwan undaguig kua, nøashib nam judíosmera tulundzuni yawan maringaruig køn— chib. ");
INSERT INTO gum_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Inchen Jesúsbe nømba iben, yandø yau pub lutau ambene, tru suldaumeran ashibiibe nui trendø linchibelan møilan køsrøn trenchinrrai karua ørøbig køn: —Señor, øyangatiizhiitø attra tan chinrrai. Kaguende ñi nai yau kebattraimbe, nabe trengatig kømuinatan cha. ");
INSERT INTO gum_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Incha treekkurri ni naashibguen ñun lanrrab arrumur cha. Tammisr cha, treetø chirra chibig køn. Nai karuindiig megabig tammisrig kønrrai. ");
INSERT INTO gum_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kaguende nagucha mas nørreelø karua pasrig kur cha. Katø treeg køben na karub tøgagúilø suldaumera tøgaig kur cha. Truilanma na møigwan køben: “Inrrø” chibene, ib; katø na møigwan køben: “Amø” chibene, arrub; katø nai karuindiig megabigwan: “Chigøben mar” chibene, marøb inchibig køn cha. Nøbe trendan— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Inchen Jesús iigwan mørabe, tru møwan nøguen kwaara asha, nui mendig truba nu misag amøñibelan keesha ashabe, trenchibig køn: —Nabe ñimun trendamønrrun cha: israelitasmerai utuguen isubigwan nainug pasrig øya nuig wetørramur cha, i møwei lataig.— ");
INSERT INTO gum_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Indiibe tru karua øriilø katøle yau pubene, tru karuindiig megabiibe tabikken waptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yandø øyeeg chab puraiben, Jesúsbe kan pueblo Naín taisrømay iben, nui kusrenanøb pera uniiløba, truba nu misaaba linchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Inchen tru puebloyu kebambam yaskab pulu pubene, kan kwaigwan sørønrrab muta, amrrubelø køn, tru kwabiibe kandø nusrkain køben, usrimbe piuda. ");
INSERT INTO gum_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Inchen Señorbe tru ishuwan lastima ashabe, trenchibig køn: —Kishmøta— cha. ");
INSERT INTO gum_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Incha Jesúsbe kemalla, taulwan katøraben, muta ambubeløbe pønrramisren, Jesúsbe kwaigwane trenchiptinchibig køn: —Matsinø, na ñun ¡kurrø! char— cha. ");
INSERT INTO gum_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Inchen tru kwabiibe kurra, wamisra, waminchib mendøben, Jesúsbe usran tranøbig køn, pera inrrai. ");
INSERT INTO gum_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Inchen iigwan ashene, nømune mayeelanba kørig købiitø ke chindamdiig køben, Tiuswan truba tabig waminchib trenchibelø køn: —¡Tius maig karuigwan eshkabig purø nuig namui utu kurrin køn! chib. ¡Tiusbe nui misagwan purugunrrab arrin køn!— chib. ");
INSERT INTO gum_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Inchen Judea pirau kerriguba, katø tru pirau tru pøtøgatanwan kerriguba Jesús chi marigwan wammørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Inchen Juanwei kusrenanøb pera uniiløbe øyeeg purayailan kerrigu nun eshkaben, Juanbe nui mendig amøñibelan pailan wama, ");
INSERT INTO gum_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesúswan trencha payrrai ørøbig køn: ¿Tru Cristo attrabig købiibe ñi kuin kui, kabe nambe katøganun muniiram kuin kui? ");
INSERT INTO gum_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Inchen tru Juanwei kusrenanøb pera uniiløbe amrrua, Jesúswan kemallabe, trenchibelø køn: —Juan Bautistabe, ñun payrrai, namun karua ørtan cha. ¿Tru attrabig købiibe ñi kuin kui, kabe nambe katøganun muniiramig kuin chindi?— ");
INSERT INTO gum_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Inchen tru uras, Jesúsbe kwanrreelø truba yamelan tamarøbig køn, chigurrimbunø kaig kwanrrø tøgarmeran køben, kwaimandzig tøgarmeran købengue. Katø truba yam kabgailan ashchai tamarøb inchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Inchabe Jesúsbe Juan karua øriilan trenchibig køn: —Amba, ñim chi mørigwan, ñim chi asigwan Juanwan eshkanrrigay cha. Kabgailøbe ashen, cojosmerabe amben, asr trerab kwanrrø tøgarmerane nømui kwanrrøwan tamara chishmariilø køben, kalu mørmeeløbe mørøbelø misren, kwailøbe øsiiraben, waachamerane Tiuswei tabig srø wamwan eshkab kusrenaniilø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mayanguen tab kuig køn chibig køn, nan peg kuitamab isumøtø, na kuitamab isubigweimbe.— ");
INSERT INTO gum_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Incha Juanwei kusrenanøb pera uniilø ambene, Jesúsbe Juanweimburab truba nu misagwan trenchib waminchib pølbasrøbig køn: —¿Misag warab waraimøsrømbe ñimbe chi ashchab webamgue? cha. ¿Kan caña ambumay, imay isig srua yainaptiigwandeh? cha. ");
INSERT INTO gum_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Trube, ¿chi ashchab webamgue? cha. ¿Kabe kan møg truba tabig keweigwandeh? cha. Ñimbe ashibelø køn cha, truba tabig kebeløbe nømun maig marøg købendø marøb, reymerai yau purrabelø kui cha. ");
INSERT INTO gum_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Trube, treeg købene, chi ashchab webambig kø? chibig køn. ¿Kabe Tius maig karuigwan kan eshkabigwandeh? cha. Øø, nabe ñimun trendamønrrun cha: Treegwanwei ashchab webambig køn cha, trurrigu Tius maig karuigwan eshkabigwan lataitøguen kømø, mas nuigwan. ");
INSERT INTO gum_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanbe tru Tiuswei wamwan pørigu øyah taig truig køn cha: “Au, nabe nai wam srua inrrabigwan ñui merrab ørar taig, ñui maywan ñui merrab tamartrai.” ");
INSERT INTO gum_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nabe ñimun trendamønrrun chibig køn: Maya møguelø kal-labelai utu tru Juan lata nuibe muguen kaagúig køn cha. Inchendø treeg kuindøgucha, Tius nø ashib karub wainuube kan møg chigucha kømíikken mas nuig køn cha, Juan lataguen kømø.— ");
INSERT INTO gum_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Inchen maya misaameraba, tru romasreelayasig an utabeløba Jesús wamindigwan mørabe, Tiusbe maig kønrrabigwan tabig sølgandø marøbig kuin køn chibelø køn, tru Juan piu umbu ulsrainabeløbe. ");
INSERT INTO gum_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Trune tru fariseosmeraba, tru maig maramigwan martrai Moisés pørigwan treeg maramig køn chib kusrenanøbeløbabe nømuimburab Tius maig martrab isua indigwan kaashibelø køn, kaguende truiløbe Juan piu umbu ulsraimeelø kua. ");
INSERT INTO gum_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Katø Señorbe trenchibig køn: —¿Møin kwaløm møguelane chi latailø køn chinrrab køh? cha. ¿Chi lataig asønan chinrrab køh? cha. ");
INSERT INTO gum_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kan plazayu ureemera esheerrab purramisra, kangurrin kangurri øyeeg chib trashib purrabelø latailø køn cha: “Nambe ñimuyasig luswan urringucha, ñimbe pailamøwei; cantailø isumdeelø cantaben, ñimbe miirab kishmøwei indan” chibelø latailø. ");
INSERT INTO gum_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pøs Juan Bautista pirri mamøwei, vino muchimøwei inchibig arrubene, ñimbe nune, kwaimandzig tøgaig køn, chibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Inchen tru Møg Misra Arrubig mab, muchib inchibig arrubene, trube, ñimbe menrra maptiig køn tamba, menrra muchiptiig køn tamba, romasreelayasig an utabeløba, kaig marøb misaameraba linchibig køn tamba inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Inchendø mu møkken nebua isumgaig tru Tius marøb pasraigwane nui ureemerainug ashchai kenamaran— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kan møikkøsrøn fariseo Jesúswan nøba lincha manrrab attrai eshkaben, Jesúsbe truigwei yau kebyabe, mishatsigu wamisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Inchen tru puebloyutøwei kan kaig marøb ishug tsubig, tru fariseowei yau Jesús mab wan tai wammørøppe, kan alabastro limetayu truba may irrab aceite srua puabe, ");
INSERT INTO gum_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","kishib Jesúswei wendau srøb pulu wamisra, nui kappinwan Jesúswei katsig tambal pala kørrøgøb sømara, trugurrimbe nui pusruutøga pinømøra, katsigu muchawa, yandø tru may irrab aceiten nui srøb pala itølushibig køn. ");
INSERT INTO gum_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Inchen tru fariseo Jesúswan manrrab attrai eshkabig ashabe, nuinetø treeg isubig køn: “I møg Tius maig karuigwan eshkabig kuimbe, nun katørabiibe mu ishug kui, kaig marøb ishug kui asin kømbala” cha. ");
INSERT INTO gum_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Inchen Jesúsbe fariseowan trenchibig køn: —Simón, ñun chigøsrøn tamig tøga war— cha. Inchen fariseobe: —Kusrennøbig, eshkarra— chiben, ");
INSERT INTO gum_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesúsbe trenchibig køn: —Kan an pebigwan pailø møguelø nun ulømisrar købig køn cha, kane quinientos denarios ulø købene, kane cincuenta ulø købig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Indiibe truiløbe chugurringuen trannrrabgailø køben, tru an pebøbiibe pailanba paymønrrab kagøbashiptindig køn cha. Treeg købene, ¿i pailøbe tru an pebøbigwan møig mas undaarerah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Inchen Simónbe trenchibig køn: —Tru mas nu anwan ulø paymø, kagøbasinabig, na møren truig kømmørgøtan— cha. Inchen Jesúsbe trenchibig køn: —Søl isua trendan— cha. ");
INSERT INTO gum_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Inchen Jesúsbe ishuwan keesha ashabe, Simónwane trenchibig køn: —¿I ishuwan ashkuh? cha. Nabe ñui yau kebarruben, nai katsigwan kwalamig ñibe nan pi tranmuben, trune i ishuube nui kappinwan kørrøga sømara, nui pusruutøga pinømørtan cha. ");
INSERT INTO gum_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ñibe nan muchamuben, trune nøbe na kebarrinukkurri nai srøbmeran muchab wan cha. ");
INSERT INTO gum_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ñibe nai tur pala aceite srølmuben, nøbe may irrab aceiten nai srøb pala itø lushtan cha. ");
INSERT INTO gum_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Inchawei ñun trendamønrrun chibig køn: I ishuwei truba nørrø kalø mariilan nun ulø paymø pesannaikkurri nøbe truba truba undaaran cha. Inchen møikkøben tre nu kømíigwan ulø paymø pesannainabiibe, tru ulø paymø kagøbashibigwane tre undaaramøn— cha. ");
INSERT INTO gum_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Inchabe tru ishuwane trenchibig køn: —Ñui kaig mariiløbe payamig kømíig, pesannaig kørrømisran— cha. ");
INSERT INTO gum_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Inchen truyu lincha mab nøba purrabeløbe, nømasiyaitø trenchib mendabelø køn: —¿Chigøben kaig mariilanguen ulø paymø pesannamig kønrrai marøbiibe, iibe mu møg køh?— cha. ");
INSERT INTO gum_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Inchen Jesúsbe ishuwan trenchibig køn: —Ñi ñui isubigwan nainuutø pasra tøgagúikkurri, kaigyugurri wesraig kørrømisran cha, møimbe chi isumø, inrrø— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yandø iig chab puraiben, Jesúsbe tru tabig srø wam Tius nø ashib karub wainuguigwan eshkab kusrenanøb pueblomerasrø yamera tsitsø pønrrabsrø uñibig køn, nui doce kusrenanøb pera uniiløba. ");
INSERT INTO gum_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Inchen katø mø ishumburmera køsrøn nø kwaimandziimeran webusriiløba, kwanrrømeran tamariiløba linchibelø køn. Inchen truilai utube tru siete kwaimandziimera webambinabig, María Magdalena køben, ");
INSERT INTO gum_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herodeswei yau ya ashib tsubig Cuzai srai Joana køben, Susana køben, katøgan ishumburmera køben linchibelø køn. Iiløbe nømui chi tøgagúiløtøga Jesúswanba, nui kusrenanøb pera uniilanba purugubelø købig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Misag truba nørrø tulundzuna, chu puebloyuelø køben, Jesúswan itømaytø ashchab webamben, nøbe ‘øyeeg lataitøwein køn’ cha, kemesra waminchib trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Kan kwallibiibe nui yellwan tsurøb kwallchab webyan cha. Incha tsurøb ibene, kanbalø yellbe mayu kørrøben, itøbunøben, illimera amrrua, man cha. ");
INSERT INTO gum_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Inchen katøganbaløbe srug trølyu kørra, kal-lappe, kal-labendø, pirø søig kømøwagurri mul-lan cha. ");
INSERT INTO gum_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kan utu yellmerabe kalshau utu kørra, kal-laben, kalbe kanbalatø nørrørawa, chab tsibisan cha. ");
INSERT INTO gum_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Inchen kanbaløbe yell tab pirau kørra, nørrørawa, tabig misra, kan yellgurrindø trulzheelø ciengatig nigan— cha. Iigwan trenchabe, Jesúsbe truba mur waminchib trenchibig køn: —¡Møramig kalu pønsraibe, mør!— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Inchen nui kusrenanøb pera uniiløbe: —¿Tru ‘øyeeg lataitøwein køn’ cha wamindiibe tappe, mandø køh?— cha payen, ");
INSERT INTO gum_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesúsbe trenchibig køn: —Tiusbe nø ashib karub wainug mu asiimíig tøgagúilan ñimun ashchai tranan cha. Trune katøganelane ‘øyeeg lataitøwein køn’ chib wamindiiløtøga eshkab waminchar cha, “nømbe ashippe ashendø, ashmøwa lataig kørrømisrøb; mørøppe mørendø, chigúi mørmøwa kørrømisrøb inchain” cha. ");
INSERT INTO gum_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Tru ‘øyeeg lataitøwein køn’ cha, kemesra wamindiibe øyeeg chibig køn cha: Tru yellbe Tiuswei wamwan eshkabig køben, ");
INSERT INTO gum_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","tru may pulu kørrab yellmerabe, tru Tiuswei wamwan mørøbelan truilan eshkabig køn cha. Inchen nugwaimandziibe arruppa, nømui manrrau tru wam ellmarigwan kerran cha, nøm Tiuswan køreben, kaigyugurri wesrailø kømønrrai. ");
INSERT INTO gum_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Inchen srug trølyu kørrab yellbe tru Tiuswei wamwan møra, truba truba tab kui mørøb utabelan, truilan eshkabig køn cha. Inchendø truiløbe chi srølgar kua, maya yanagatiitø kørewa amøña, chigøben maig inchibelø køtashchab pubene, tarømisrøptinchibelø, truilø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Inchen tru kal shau utu kørrab yellbe tru wamindigwan mørøbelan eshkabig køn cha. Inchendø truiløbe nømui ambam maywan ambub køben, tru chine, chine menrra isubiibah, puamisrøg købiibah, chigurrimbunø marøb kasrag amøñinrrab treeg marøg købiibatø kasran cha. Incha tru ellmarigwane nørrørabashmøn cha. ");
INSERT INTO gum_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Inchen tru tab pirau kørrabiibe tru nømui manrrau purø tabig isub, trurrigu sølwan isub, Tiuswei wamwan møra, truigwan elachimø, tøgagua, melabig meløwa, ellmarig misrøbelan eshkabig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Mugucha kan aceite lámparan piløgøppe, chitøgagøben kasrømøwei, kabe cama umbu pasrtrab kømøweim piløgøbelø køn cha. Treeg kømøtø, kerrubelan tør kønrrai, pala pasrøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Inchawei chitøgucha søriibe søriitø kørrømisrmø, kenamisrtrun cha. Katø chigøben ashmønrrai kasra pasriibe, nebua asiimíig kørrømisrmøtø, tøryu webattrun cha. ");
INSERT INTO gum_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Inchawei ñim mørigwane tab isua asha kuy cha. Kaguen tøgaigwane masken tranen, trune chigaigwane nui lamøtiig tøgagurmab isuigwanguen kerraig kønrrun— chibig køn, Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inchen Jesúswei usrimba, nuneløba nø wainug pubendø, menrra nu misag pasrøwa, nuim pulugatig kemallchab kaima køben, ");
INSERT INTO gum_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","møikkøsrøn Jesúswan trencha eshkabig køn: —Ñui usrimba, ñui nuneløba wambig pønrran cha, ñun ashchab isua amrrua.— ");
INSERT INTO gum_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Inchene Jesúsbe løtappe trenchibig køn: —Tiuswei wamwan møra, trunun marøbeløbe, nai usri, nai nunelø køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kan kwaløm Jesús nui kusrenanøb pera uniiløba barcoyu kebyabe, trenchibig køn: —Pisu ambøgatøsrømay larraamun— cha. Inchabe ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Incha larraambub ambub købene, Jesúsbe barcoyu kiptinchen, møimbe tru nu pisuyube isig ichibig purø trømbøig namab webarruben, pibe barcoyu michab mendøben, yandø ke asentanrraptiig inchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Inchen Jesúswan kasrønanabe trenchibelø køn: —¡Kusrennøbig! ¡Kusrennøbig! ¡Nambe piu ke chab asentab meler!— cha. Inchen Jesúsbe kurra, isig ichibigwanba, pi welar trømbøig latøgushib kurrabelanba pasrambunrrai kandø wamabig køn. Inchen truiløbe pønrrambuben, yandø kerrigu wasrønzhig kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Inchen Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: —¿Ñimui isubigwan nainuutø pasra tøgagúigwane chinchigue?— cha. Inchen nømbe truba kwaariilø, kan øyeebe mandø kermab isub kangurrin kangurri trenchibelø køn: —¿Iibe mu kerah cha, isig ichibig lata, pi latøgushib kurrabig lata, nø pasrambungarubene, iiløguen nun mørtrappe?— ");
INSERT INTO gum_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Incha yandø gadarenosmeraim pirausrø larraambubelø køn, tru Galilea nu pisu ambøgatømaysrø. ");
INSERT INTO gum_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Incha Jesús barcoyugurri pirau pinaiben latatø, tru puebloyuig kan møg kwaimandziimera tøgaig katønrrab webibig køn, truibe manasrøngurri chigucha kemøwei, yau tsumøwei inchibig, sørin trabmerayutø tsubig. ");
INSERT INTO gum_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Incha Jesúswan ashippe, nui merrab mur trashib tømbasrøb peñabe, trenchibig køn: —¿Ñibe nane chi martrab inchigu cha, Jesús, Mayeelaim Pala Pasrabigwei Nusrkai? ¡Ñi nan purø trømbøig møra megamig kømønrrai marmørrunrrig!— chib. ");
INSERT INTO gum_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kaguende Jesúsbe tru trømbøig maringarub kwaimandzigwane: “Møweinukkurri webinrrø” chibguen indin køben nøbe trendaig køn, kaguende truigwane kwaimandziibe katø katø nø merrarrawa sruaig købig kua. Inchen chu imønrrai, misaamerabe tasiimeran srøbmeran cadenastøga lusra tøgagúingucha, nøbe cadenasmeran lurren, kwaimandziibe mu misag warab waraimøsrø ingarubig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Inchen nune Jesúsbe payibig køn: —¿Chi munchi kugu?— cha. Inchen nøbe løtappe: —Nabe: “Legión”, munchi kur— chibig køn, kaguende tru møweinuube kwaimandziimera purø nu kebamba kua. ");
INSERT INTO gum_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Incha tru kwaimandziimerabe ‘tru purø trømbø umbu trabyumay ørmørrunrrig’ chib truba rugabelø køn, Jesúswane. ");
INSERT INTO gum_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Inchen tru tunyube kuchimera truba nu søtø mab llirab amøñiben, tru kwaimandziimerabe ‘tru kuchimerayu kebambingarurra’ chiben, Jesúsbe ka kebambashibig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Inchen kwaimandziimerabe møweinukkurri webamba, kuchimerayu kebambene, tru kuchi søtøbe truba trømbø lendeyu lula, chab pinøgørraptincha, pisuyu kegørra, pi keesra chab kwabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Inchen tru kuchi ashibelø treeg purayaigwan ashabe, kwaariilø lula, puebloyu køben, wambig nøørøwansrøn køben eshkab ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Inchen misaamerabe chi purayaigwan ashchab werrua, Jesús waisrø pubene, tru kwaimandzig tøga møg købiibe Jesúswei srøb pulu, yandø asru keweig ke yandø tabig wai ashibelø køn. Inchabe truba kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Inchen tru treeg purayaigwan ashibeløbe tru kwaimandzig tøga møwan Jesús mandø incha tamarigwan katøganelan eshkaben, ");
INSERT INTO gum_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","tru Gadara pirau maya misaamerabe Jesúswan nømuinukkurri ‘irra’ chib truba rugabelø køn, kaguende nømbe truba truba kørig kuilø kua. Inchen Jesúsbe barcoyu kebya ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Inchen tru kwaimandziimera webambinab møøbe: —¿Ñui mendig arruah?— chib truba inchen, Jesúsbe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ñui yamay katø inrrø cha, ñun Tius chigøben yeeg nørriig mariilan kerriguh eshkanrrab.— Inchen tru møøbe, Jesús nun øyeeg nørreelø marigwan kerrigu eshkab ibig køn tru pueblo ørøba. ");
INSERT INTO gum_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Incha katø Jesús pisu ambøgatøsrømay larraibene, mayeeløba munig kuig køppe, misaabe nune truba kasrag utabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Inchen kan møg judíosmera tulundzuni yau chi maramigwan ashibig, Jairo taig, puabe, Jesúswei katsig pulu tømbønsra, nui yamay tiusmanda arrubsrumugu chibig køn, ");
INSERT INTO gum_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kaguende nui kandø nimbasr doce añosig tøgagúibe ke kwanrrab inchib tsuben. Inchen Jesús ibene, nu misag søtøbe nui mendig trag marøb ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Inchen tru ututø kan ishug doce años ørøba ani ib kwanrrø tøgaig kua, nui chi tøgagúigwan kerrigu patsøgøben, mugucha tamartrab kaimaig købig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tru ishuube Jesúswan wendaugurri kemallippa, Jesús nø kewagúig urøzhigwandø katørabene, tru urastø tru ani ibiibe pasramisrøptinchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Inchen Jesúsbe trenchibig køn: —¿Nane mu katørah?— cha. Inchen mayeeløba: “Ñune mu katøramer” chiben, Pedrobe trenchibig køn: —Kusrennøbig, misag søtøbe ñun yeeg tinmarøb ambumay imay trawagutsan— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Inchen Jesúsbe trenchibig køn: —Møikkøben nan katørainrrun cha. Kaguende nai maramburab marig nainukkurri webrain kui mørar— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Inchen ishuube nø treeg marigwan chi søramgaig kuin kui ashabe, itønab arrua, Jesúswei merrab tømbønsrøb srala, maya misagwei merrab chindimba katøraigwanba, katø tru urastø mandø tabig kørrømisrigwanba eshkabene, ");
INSERT INTO gum_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesúsbe trenchibig køn: —Nimbasr, ñui isubigwan nainuutø pasra tøgagúikkurri tamarig kørrømisran cha. Chi isumø, inrrø— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Inchen Jesús waminchib pasramnetø, tru judíosmera tulundzuni yau ashib karubigwei yaugurri møikkøsrøn puabe, unai møskawane trenchibig køn: —Ñui nimbasrbe kwabguen indan cha. Kusrennøbigwan mas chi chimøta— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Inchen Jesúsbe mørabe trenchibig køn: —Kørig kui inchimøtø, køreptø køreu cha, ñui nimbasrbe tammisrtrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Incha yau puabe, Jesúsbe mungucha kerrubashmøtø Pedronbah, Jacobonbah, Juanwanbah unai møskalanbatø kerrubashibig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Inchen mayeeløba unan isub waminchib truba kishib køben, Jesúsbe trenchibig køn: —Kishmøtay cha, unøbe kwaig kømøtø, ka kiptø tsun— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inchen nømbe kwain tsui asha kua, Jesúswane ka indzatø mørøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Inchen unan Jesúsbe tasigu kemøra, mur wamab trenchibig køn: —Ishug-unø, ¡kurrø!— cha. ");
INSERT INTO gum_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Inchen espíritube katø nuinug puben, øsiirawa tru urastø kurraptinchen, Jesúsbe manrrai manningarubig køn. ");
INSERT INTO gum_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Inchen møskaløbe ke kwaara asha kørrømisren, Jesúsbe chi purayaigwan nømune mungucha eshkamønrrain karubig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús nui doce kusrenanøb pera uniilan wama, tulundzunabe, mayan kwaimandziimeran wambig webusrøb, kwanrrømeran tamarøb inchai, maramburab maramigwanba, mu chindamgaig karumigwanba tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Incha Tius nø ashib karub wainuguigwan eshkab kusrenanrraimba, kwanrreelan tamartraimba karua ørabe, ");
INSERT INTO gum_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","nømune trenchibig køn: —Mayuweimbe chigøben srua ammønrrigay cha. Pøtønain tsig srua ammøwei, wasr ila ammøwei, pirri srua ammøwei, an srua ammøwei, turingucha pagatø kømø, kandø kewa ambay cha. ");
INSERT INTO gum_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chugøben puebloyu yau puppe, webamba ambamnegatig truyutø kørrømisrtrigay cha. ");
INSERT INTO gum_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Inchen ñimun wamab utag kømui indinuube, trube, tru puebloyugurri webamrrappe, ñimui srøbyu usrøwan chishtø kørrøgønrrigay cha. Treeg marøppe, trube ‘ñim kaasig købene, møimbe ñim kusrenrrigay’ chib eshkab.— ");
INSERT INTO gum_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Inchen nømbe webamba, pueblomørig puraambub ambuppe, Tiuswei tabig srø wamwan eshkab kusrenanøb, chutøgucha kwanrreelan tamarøb ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Inchen Galilea pirau ashib karub wabig Herodesbe Jesúsweimburab wamindi mørøb nø chi mariilan kerrigu wammørabe, chi isum kuinguen mørmíig køn, kaguen møiløgøsrøn: “Juan Bautista kwailai utugurri katø kurriinrrun” chiben. ");
INSERT INTO gum_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Inchen kan utueløbe: “Tius maig karuigwan eshkabig Elías kenamisrin køn” chiben, kan utueløbe: “Tius maig karuigwan eshkabig merrabsriig møikkøben katø øsiirain køn” chiben, inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Inchen Herodesbe trenchibig køn: —Juanwane natøwei turwan paringaruig køn cha. ¿Trube, chigøben na yeeg wamindig wammøriiløbe mu kønrrab køh?— cha. Incha Herodesbe Jesúswan ashig kui inchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús nøashib karua øriilø katø amrruabe, nøm chi marigwan nun eshkaben, nømune Jesúsbe Betsaida pueblosrømay nømundø nøørø pera ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Inchendø tru nu misag søtøbe wammørøppe, wendautø amben, Jesúsbe tabig wamab uta, nømun Tius nø ashib karub wainuguigwan waminchib, kwanrrøwan tamaramig palai melabelane tamarøb inchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Inchen yandø mawab misrøb arruben, nui doce kusrenanøb pera uniiløbe Jesúswan kemallabe, trenchibelø køn: —Misaameran yandø amrrai, ungwa chi cha, puluwandø yamera pønrrabsrøn køben, chugøben nøørøsrøn køben, ya peba kørrømisrtrappa, mamig penønrrappa amrrain cha. Kaguende yube nambe mugucha warømønug pønrrer— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Inchene Jesúsbe trenchiptinchibig køn: —Manrrai ñim mannay— cha. Inchen nømbe trenchibelø køn: —Nambe trattrøgatø pirrimbah pagatø peskaubatø tøgaguer cha. Ya nu misagweimbe srøig penønrrab ambatøwein kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kaguende møgueløtø trattrø milburab købig køn. Inchen Jesúsbe nui doce kusrenanøb pera uniilan trenchibig køn: —Kan søtø, cincuentabatø, cincuentabatø purramisringaruy— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Inchen treeg maren, misaabe mayeeløba chab purramisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Inchen Jesúsbe tru trattrøgatø pirriwanba, pagatø peskaumeranba nui tasku muta, srømbalaneb neesha, Tiuswan ‘mayanguen pay’ cha, pirrimeran pirishabe, nui kusrenanøb pera uniilan misagwan pirishinrrai tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Inchen mayeeløba øska ma kørrømisren, pitis undailan tasinmerayu netsøbatø doce tulishibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kan kwaløm Jesús nøørøsrø Tius Møskaimba waminchib wabene, nui kusrenanøb pera uniiløbe nøba purrøben, Jesúsbe trencha payibig køn: —¿Misaamerabe nane mu køn tah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Inchen nømbe trencha løtabelø køn: —Møiløbe: “Juan Bautista køn” chiben, møiløbe: “Elías køn” chiben, møiløbe: “Tius maig karuigwan kan eshkabig merrabsriig katø øsiirainrrun” chiben indan— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Inchen Jesúsbe trencha payibig køn: —¿Trune ñimbe nane mu køn chinrrague?— cha. Inchene Pedrobe trencha løtabig køn: —Ñibe Tiuswei tru Cristo køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Inchen Jesúsbe iigwane mungøben eshkamønrrain karubig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Inchabe trenchibig køn: —Møg Misra Arrubiibe chinetø kaig indinab megamig nebunrrun cha. Katø misagwan karubelø kølli misaamera køben, sacerdotemeran karubelø køben, Moisés pørigwan kusrenanøbelø køben nune kaasig kømig kønrrab køn cha. Incha kweechen, pøn kwalømyube kusraig kønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Incha mayeelan trenchibig køn: —Møikkøben nai mendig uñig købene, nøasiitø nuimburabigwangøba isumøtø, kwalømmørig nui kuruswan muta, nai mendig arrum nebunrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Inchen møikkøben øsig kømigwangøba esegabiibe yandø pinab pinamig nebunrrun cha. Inchen nagurrindø kwabiibe managatig øsig kømigwan esegawa tøgagønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Kan møg yu pirau chine købigwan kerrigu nuindø maringucha, nøasiitø minchib, nøasiitø pinamigwei marøb indiibe, chiwein kui tabig kønrrab kø? ");
INSERT INTO gum_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pøs møikkøben naimburappa, na wamindiilaimburappa kørig isub kørig kui inchibigwane, nune kørig purørtrun chibig køn, tru Møg Misra Arrubig tru nui tørguegwalmabiiba, nui Møskawei tørguegwalmabiiba, Tiusweindø tarømari ángelesmerai tør pilabiiba arrua. ");
INSERT INTO gum_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nabe ñimun cierton trendamønrrun chibig køn: Møiløgøben yu purrabelø Tius nø ashib karub pasraigwan ashmøwatøbe kwanrraamøn— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Øyeeg taig trune wendau køsrøn Jesúsbe Pedronba, Juanwanba, Santiagonba pera, kan tun palasrø Tius Møskaimba waminchab nebibig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Inchen Jesúsbe Tiusba waminchib pasramnetø, nui maløbe ke peg lataig misrøptinchen, nui kewagúiløbe truba puløzhig tørgwalmabelø misrøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Inchen møimbe pailø møguelø nøba waminchib kenamisrøptinchibelø køn. Truiløbe Moisésba, Elíasba, ");
INSERT INTO gum_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","nømbe tørguegwalmabig pinøgasrailø, Jesús Jerusalénsrø mandø kaig indinab megawa, kwamigwan waminchib pønrrabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Inchen Pedroba, nui linchibeløba kigøbiitø ke chindamdø kuim purrøwagucha, kimø kasrig ka purrøwa, Jesúswei tørguegwalmabigwanba, tru pagatø møguelø nøba pønrrabelanba ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Inchen tru møguelø yandø Jesúsweim pulugurri tarømisra ambene, Pedrobe nøtøwei chi chib pasrarmabguen mørmubendø, trenchibig køn: —Kusrennøbig, ¡nam yu pønrramibe purø tab køtan! cha. Pøngatø ya-ureg margun cha, kan ñui, kan Moiséswei, kan Elíaswei.— ");
INSERT INTO gum_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Inchen tru waminchib pasramnetø kan wañi arrua, nømun kasrøben, nømbe wañi umbu kørrømisra, Pedroba, Juanba, Santiagobabe truba truba kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Inchen wañi umbugurrimbe kan wam trenchibig køn: —Iibe nai Nusrkai, nai lawa wesruig køn cha. Nune møray— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tru wambe yandø mas mørø waminchimuptinchen, Jesúsbe katø nøtø pasrai ashibelø køn. Incha nømbe tru chi asigwane tru kwalømmerawane mungucha maizhikken mørø waminchimeelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Katø kwaløm tunbalasrøngurri kørrørrubene, Jesúswan katønrrab truba nu misag werruben, ");
INSERT INTO gum_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","møimbe kan møg tru misaamerai utugurri truba mur wamab trenchibig køn: —Au, Kusrennøbig, kabe tiusmanda nai nusrkawan ashibsrumuguh cha, nai kandø nusrkain køn cha. ");
INSERT INTO gum_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nune kwaimandziibe merrarraben, nøbe møi møin trashibig køn cha. Inchen kwaimandziibe pirausrø kucha, itønangarub, triimay chall kutsingarub, purø trømbøig lastimaig marøb, ¡katø! elachimøsraatø inchibig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Inchen ñui kusrenanøb pera uniilan kwaimandzigwan webusrtrai na rugaben, kaiman— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Inchen Jesúsbe trenchibig køn: —¡Kan ñim møi misaamera kørenrrab inchimeelø larrø kailø! cha, ¿Nabe managatig ñimba unamig kønrrerah cha, ñimun øyeeg ashiptø? Ñui nusrkawan yu srua amø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Inchen unøbe kemallib iben, kwaimandziibe unan pirausrø kucha, sruaguchen, Jesúsbe trømbøig maringarub kwaimandzigwan nama, webingarua, unane tamara, møskawan tranøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Inchen Tiuswei purø nuig tabigwan mayeeløba kwaara ashibelø køn. Inchen mayeeløba Jesús øyeeg marigwan kwaarøb kømne Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Pesannanrrab kømø, iigwan tab møray cha, tru Møg Misra Arrubigwane møguelai tasku tranig kønrrabigwan.— ");
INSERT INTO gum_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Inchen nømun øyeeg taigwane nømbe chi tainguen mørmeelø køn, kaguende Tius chigúinguen mørmønrrai indiilø kua. Incha nø øyeeg taigwan chi chibig kø cha payamibe nømbe kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Inchen nui kusrenanøb pera uniiløbe nømui utu nømbe møig mas nuig kønrraptiig kuin kui waminchib payiyab mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Inchen nøm chi isub purraigwan Jesúsbe wetøbeña, kan unan srua ya, nuim pulu pasrabe, ");
INSERT INTO gum_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","trenchibig køn: —Møikkøben i unan nai munchiyu tab wamab utabiibe, nan utan cha. Inchen nan utabiibe, nan karua ørøbigwangucha utan cha. Inchawei ñimui utu mas chigucha kømíig lataig kui asiibe, truibe si, mas nuig køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Inchene Juanbe trenchibig køn: —Kusrennøbig, kan møikkøsrøn ñui munchiyu kwaimandziimeran webusri aser cha. Inchendø namba uñmíig købene, nambe truigwane merer— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Inchen Jesúsbe nun løtappe trenchibig køn: —Merømøtay cha. Kaguende ñimun namig kurrømíibe ñimuingatiig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yandø Jesús srømbalasrø utig kømig lutau køben, Jerusalénmay ke punrrab isua ib menda, ");
INSERT INTO gum_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","eshkanrrabelø wam sruar merrab øren, nømbe Samaria pirau kan pueblosrø chigøben nuyasig tamartrab ambene, ");
INSERT INTO gum_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","samaritanosmerabe Jesúswane utømeelø køn, kaguende nøbe Jerusalénsrømay inrrab arri asha. ");
INSERT INTO gum_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Inchen nui kusrenanøb pera uniilø Jacoboba, Juanba øyeeg indi ashabe, trenchibelø køn: —¿Señor, nømun pinishinrrab srømbalasrøngurri nam nag kørraarringaruah cha, Tius maig karuigwan eshkab møg Elías latawei?— ");
INSERT INTO gum_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Inchen Jesúsbe nømun keesha ashabe, namabig køn. ");
INSERT INTO gum_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Incha katøganbalø yamera tsitsø pønrrabsrømay ambubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nøm maywan ambub købene, kan møg Jesúswan trenchibig køn: —Señor, ñi chu ibendø, nabe mendig arrumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Inchen Jesúsbe trencha løtabig køn: —Zorramerabe waramig trabmera tøgar køben, katø pala amøñib illimeragucha nømui lemera tøgar køn cha. Trune na, Møg Misra Arrubiibe ni nai turwan chu nerrarramikken chigaig kur— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Incha Jesúsbe katøganun trenchibig køn: —Nai mendig amø— cha. Inchen nøbe: —Señor, nai møskawan sørønrrabmerrig ibashcha— chiben, ");
INSERT INTO gum_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesúsbe trenchibig køn: —Ñibe nai wendautø amø cha. Tiusweimburabigu kwaig latailøbe nømui kwailan sørøbash cha. Inchen ñibe ya, Tius nø ashib karub wainuguigwan katøganelan eshkab kusrenan— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Inchen katøgangucha trenchibig køn: —Señor, ñui mendig arrug køtan cha. Inchendø nai yauelanmerrig ungwa chinrrab ibashcha— cha. ");
INSERT INTO gum_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Inchen Jesúsbe trencha løtabig køn: —Mutøgucha arauwan kemøra arab pasrøbendø, wendømaygøba keeshibiibe, Tius nø ashib karub wainuguigwane chi tab martrabgaig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Øyeeg chab puraiben, Señor katø setenta lawa wesrua, pagatø pagatø pueblosmørig katøganbalømerasrø nø yamsrømay nui merrab ørøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Incha nømun trenchibig køn: —Ellmarig tulisamibe truba nørrø køben, trune tulishinrrabeløbe mamdø køn cha. Inchawei tru ellmarig puaig Tiuswan miay chibig køn, nui ellmarigwan tulishinrrabelø ørtrai. ");
INSERT INTO gum_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ñimbe ambay cha. Au, nabe ñim ubishamera latailan lobosmerai utu ørar cha. ");
INSERT INTO gum_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","An pusramig urasr ila ammøwei, wasr ila ammøwei, alpargatis katø nøørø srua ammøwei, ñim maywan ambuppe, mun køben wamab waminchib pønrrømøwei inchigay cha. ");
INSERT INTO gum_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","’Incha kan yau kebambuppe, øyeemerrig chinrrigay cha: “I yaube chi isumgaig mayanguen tab kønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Inchen truyu chi isumgaig tab købigwan tøga møg wabene, tru: “Chi isumgaig tab kønrrun” cha ñim trendaibe nuinug kørrømisrtrun chibig køn. Inchen treeg møg kaabene, tru ñim trendaibe ñimuinuutøwei kørrømisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Inchen ñimbe tru yautøwei kørrømisra, nøm chi srørrendø mab, mutchigay cha. Kaguen chi marøbiibe nui marimburøbe mu chi chinrrainga, utamig køn cha. Yamørig, yamørig ammønrrigay cha. ");
INSERT INTO gum_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ñim kan puebloyu kebamben, ñimun wamab utøbene, chi srørrendø manrrigay cha. ");
INSERT INTO gum_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Incha truyu kwanreelan tamarøb, tru misaameran: “Tius nø ashib karub wainuguiibe ñimuinuube lutaurab pasran” chinrrigay cha. ");
INSERT INTO gum_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","’Inchen ñim kan puebloyu puben, ñimun wamømubene, trube, callesmerayu webamba, misagwan øyeeg chinrrigay cha: ");
INSERT INTO gum_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ñimui puebloyu usrø namui srøbmerayu mendigwan møimbe trube, ñim kusrenrrigay chib pabørrguer chib. Inchendø møimbe yandø ñimbe isua kuy cha, Tius nø ashib karub wainuguiibe ñimuinuube lutaurain køn” chib. ");
INSERT INTO gum_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Inchawei nabe ñimun trendamønrrun: Srabe kwalømbe tru puebloimbe Sodomai lataitøguen kømø, Tiuswei tru maig kønrrabigwan asha maram kwaløm attrabiibe mas purø trømbøig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ay, ñi Corazín pueblo, waacha! ¡Ay, ñi Betsaida pueblo, waacha! Kaguende Tirosrø, Sidónsrø tru maramburab mariilan na ñimui utu lataitøwei marig kuimbe, manawei truiløbe nømui kaig mariilan isua møra, Tiusweimay llirabsruig kuinrrun cha. Incha kaig marmønrrab yandø isua mører chib kenamartrab, trøsrkøleelø keb, nagusrøyu purramisrøb inchibsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pøs Tiuswei tru maig kønrrabigwan asha maram kwalømbe Tiroba, Sidónba misaamera lataitøguen kømø, ñimbe mas purø trømbøigwan utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Inchen ñi Capernaum pueblogan, ¿purø tab incha srømbalasrøngatig kusruig kønrrurmab isutirru? cha. Treeg kømøtø, ñibe tru møra melamnug kegutsig kønrrabguen— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Incha nui pera uniilan trenchibig køn: —Ñimun mørøbiibe, nan møran cha. Inchen ñimun kaashibiibe, nan kaasan cha. Inchen tru nan kaashibiibe, nan karua ørøbigwan kaasan— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Inchen tru setenteeløbe truba kasrag katø amrruabe, trenchibelø køn: —Señor, ñui munchiyube kwaimandziimeraguen namune mørtan— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Inchene Jesúsbe trenchibig køn: —Satanásbe srømbalasrøngurri kan palaig peñib lataig peñen, nabe asig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nabe mu mandamgaig maramburab maramigwan ñimun tranamønrrun cha, ulmeran, alacránmeran itøbunønrrai, katø tru ashig kømui inchibig, Satanás, nø kanawa, chi martrab kaimanrraimba. Inchen ñimbe chi indiimeelø puramrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inchen ñimbe, kwaimandziimera ñimun mørimba kasraaramøtø, ñimui munchimera srømbalasrø pørig pønrraimba kasraaray— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Incha tru uras Jesúsbe Espíritu Santogurri truba kasraarawa, trenchibig køn: —Nai Møskai, srømbalawanba, pirøwanba ashib karubig, ñun tabig waminchar cha, kaguende ñibe kusrebelø chigúi mørøbelan ashmønrrai tru sørig pønrrabelane tru chigucha kømeelø kusremeelan kenamarikkurri. Treewein køn, nai Møskai, ñi treeg kønrrai maramig tab kuig kua. ");
INSERT INTO gum_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Nai Møskaimbe chiwandøgucha nan trandan cha. Mugucha na Nusrkawane mu kui ashmuben, Møskaindøwei asan cha. Mugucha Møskawane mu kui ashmuben, na Nusrkaimba, møiløgøben na asingaruilø truiløbatø asan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Incha nui kusrenanøb pera uniilan ashabe, nømundø trenchibig køn: —Tru ñimui kabmera nebua asigwan ñim ashibeløbe mayanguen tab kuilø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kaguende nabe ñimun trendamønrrun cha: Truba nørrø Tius maig karuigwan eshkabelø køben, reymera køben, i ñim asigwan asinrrabna kui inchendø, ashmuig køn cha; i ñim mørigwan mørinrrabna kui inchendø, mørmuig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Inchen tru maig maramigwan martrai Moisés pørigwan kan kusrenanøbig Jesúswan mandø inchibig køtashchab nøba waminchab kurra yabe, trencha payibig køn: —Kusrennøbig, ¿managatig øsig kømigwan Tius tranig tøgagønrappe, nabe chi maramerah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Inchen Jesúsbe trencha løtabig køn: —Maig maramigwan martrai Moisés pørigube ¿chi pørig pasrah? cha. ¿Ñibe truigwane mandø taitamab isugu?— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Inchen nøbe trenchibig køn: —“Señor ñui Tiuswane ñui manrraugurri kerrigu newan undaaraitøgaba, kerrigu ñui øsig pasraitøgaba, katø kerrigu ñui asru chishkømburab chish kuitøgaba, kerrigu ñui turtøga isumburab isuitøgaba undaaramig køn cha. Katø ñima ñiasiitøwei maig undaguig køppe, ñui mendaigwangucha treetøwei undaaramig køn” cha, trenchibig pørig pasran— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Inchen Jesúsbe trenchibig køn: —Ñibe sølwei løtan cha. Iigwan mar cha. Treeg marabe si, ñibe managatig øsig kømigwan Tius tranig tøgagønrrabguen— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Inchen tru møøbe nø payigwan tab webig køb, Jesúswane trencha payibig køn: —¿Naimbe mendaibe mu kerah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Inchene Jesúsbe trencha løtabig køn: —Kan møg Jerusalénmay ambi maywan Jericómay kørraarrub arrubene, nileelø merrarrawa, kerrigu nui kewagúigwanbañau nila, kurragucha, kwaig lataig mara trarra ambubelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Inchen kan judíosmerai sacerdote tru maywandøwei chi isumø purainrrab arrub pasrøwa, tsui ashippe, yabwansrøndø purayan cha. ");
INSERT INTO gum_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Katø treetøwei kan levitagucha truyu pubendø, ashabe, mendawansrøndø pureppa ib ibig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Trune kan Samariasrø møg tru maywandøwei purainrrab arrua, nun ashabe, lastima isua, ");
INSERT INTO gum_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","møwan kemallabe, nui pisrøwan aceiteba, vinoba srøla, llensutøga lusra, trugurrimbe nui burroyutøwei itøguanøsra, kan ya pebøbelainuumay srua ya, truyu ashib tøgagúig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Incha katø kwaløm samaritanobe inrrappe, tru ya puaigwan pagatø an wesrawa, trana: “I møwan ashchunrrig tan cha. Ñi mas kastain købene, katø arruabe, pagararrumøn” tan— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Incha Jesúsbe tru Moisés pørigwan kusrenanøbigwane trenchibig køn: —¿Tru nileelø kemørinab møwan, tru i pønelø nøasi lataitøwei isua ashibiibe, ñune møig truig kønrraptiig køta?— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Inchen nøbe løtappe trenchibig køn: —Tru møwan lastima ashibig, truig kømmørgøtan— cha. Inchen Jesúsbe trenchibig køn: —Ñigucha ya, treetøwei mar— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Incha Jesúsba, nui kusrenanøb pera uniiløba nui maywan amba, yamera tsitsø pønrrabsrø pubene, truyube kan ishug, Marta taig, nui yaumay amø cha, utabig køn. ");
INSERT INTO gum_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martabe kan numøsrai María taig tøgaig købig køn. Inchen truibe Jesúswei srøb pulu nø chi taigwan mørtrab wamisren, ");
INSERT INTO gum_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","trune Martabe, ke chi maram kuinguen mørmíig wawa, Jesúswan kemallabe, trenchibig køn: —Señor, chi maramelan nai numøsrai ke nandø keguchen, ñungan isumuitarru cha, nan puruguptøguen wau taindø— cha. ");
INSERT INTO gum_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Inchen Jesúsbe trenchibig køn: —Marta, Marta, ñi kui ke chinsraatø inchib, ñui chigurrimbunø maramelangøba isun cha. ");
INSERT INTO gum_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Inchendø kanbaløtø mas isumig pasran cha. Inchen Maríabe tru mas tabigwan trunun lawa wan cha. Truigwane kerraig kømønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kan pieje kanbaløsrø Jesúsbe Tius Møskaimba waminchib wawa, chab patsøgøbene, møikkøsrøn kan nui kusrenanøb pera uniibe trenchibig køn: —Señor, tru Juan nui kusrenanøb pera uniilan kusrennøb lataitøwei, namungucha Tiusba wamindam kusrenanrra— cha. ");
INSERT INTO gum_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Inchen Jesúsbe trenchibig køn: —Ñim Tiusba waminchib pønrrappe, øyah chinrrigay cha: “Namui Møskai, ñui munchibe tabigweindø tarømara, newan tab indig kønrrun. Ñi ashib karub pasraibe pirau larrøbitchab amø. ");
INSERT INTO gum_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kwalømmørig nam mamig maig palabigwan namun møi tranøb, ");
INSERT INTO gum_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","namui kaig mariilan ulø paymø, pesannarrunrrig chib. Kaguende namma namun kaig marøbelan mayeelan ulø paymø, pesannabelø ker chib. Chiyugøben namun kegørrøsrkønrraptiig pønrrøbene, truwane ambashmørrunrrig chib. Masken tru kaigweinukkurrimbe tarømartra”— chib. ");
INSERT INTO gum_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Incha Jesúsbe katø trenchibig køn: —Ñimma møikkøben kan trendø asig tøgagua, yem tøbøtag truigwei yamay ya: “Au, nai kasuku, pøngatø pirrim pebøbsrumugu chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Pøs nai trendø asig inrrab arrua, nai yau puben, chigucha srørramig chi kaagur” cha. ");
INSERT INTO gum_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Inchen kane yaambugurri trencha løtimbeh: “Yaskappe yandø kasraig pasran cha. Mas wamab fregamørrunrrig chib. Nabe nai ureemeraba camayuguen warøwa, chigucha pebrrab kurrønrrab kaimamønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pøs nabe ñimun trendamønrrun: Pebrrab kurrappe, nui trendø asig kuimbatø pebrrab kurrømøtø, ke wamabig wamab tsuikkurri kurra, chi palabigwan nøbe kerriguh tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Inchawei nabe ñimune trendamønrrun: Miabene, Tiusbe ñimune tranrrun cha. Lawabe, ñimbe wetørranrrun cha. Yaskabu wamubene, ñimune kurtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaguende mugucha miabiibe utøben, labiibe wetørraben, yaskabyu wamabigwane kurtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Ñimma møikkøben, møskain kua, ñui nusrkai pirri miaben, pisrugwan tranrraitirru? ¿Kabe peskau miabene, ulwan tranøbsruguh? ");
INSERT INTO gum_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Kabe kan atøwall srug miabene, alacránwan tranøbsruguh? ");
INSERT INTO gum_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pøs ñimma ya kailø købenguen ñimui uregwane tabig keta tranøbelø køben, ¿kan mas ñimui Møskai srømbalasrø wabiibe nun miabelane Espíritu Santon tranmønrraitarru?— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kan møwan kan kwaimandzig wamgaig marigwan Jesúsbe wambig weguchen, kwaimandzig webibene, tru wamgaibe waminchiptinchen, misaamerabe truba kwaara ashen, ");
INSERT INTO gum_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kan utueløbe trenchibelø køn: —Kwaimandziimeran ke nøasha karub pasrabig, tru Beelzebúgurri kwaimandziimeran nøbe webusrøbig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Inchen kaneløbe Jesúswan maig inchibig køtashchab ashig køptø, nune srømbalasrøngurriig asamig martrai miabelø køn, Tius nøba pasrain kui ashchab. ");
INSERT INTO gum_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Inchen Jesúsbe nøm chi isub pønrraigwan ashabe, trenchibig køn: —Kan rey karub tøgaweim pirauma misag nømasiitø nøørøtø misrøb kurrabe, pinønrrun cha. Katø kan yauelø nømasiitø nøørøtø misrøb kurrabe, chab pinønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Inchawei Satanáskucha nøasiitø nøørøtø misrene, nui ashib karub waibe ¿chincha pasrabig pasrønrrab kø? cha. Kaguende ñimbe nane trendan, chibig køn, Beelzebú martrai tranikkurri kwaimandziimeran webetan cha. ");
INSERT INTO gum_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tru kwaimandziimeran na webetappe, Beelzebúgurri webetig købene, trube, ¿ñimui mendig amøñibeløbe kwaimandziimerane mu webetingaruitøgarre webetah? cha. Inchawei, treeg købene, maig kuigwan ñimun uyube nøm chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Trune na Tiuswei tasig-unøtøga kwaimandziimeran webetøbene, Tius nø ashib karub pasraibe ñimui utube puaguen pasran cha. ");
INSERT INTO gum_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Kan mur møøma iitøgabe chinchamamønrrurmab may tamara, nui tab yawan tab ashib tøgagøbene, truyu nui chigurrimbunø tøgagúibe chi isumgaig pasran cha. ");
INSERT INTO gum_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Inchen katøgan møg, nø lataguen kømø, mas murig arrua, nun merrarrawa kanawa, tru chinchamamumig, iiløtøgabesimab isua tøgagúilan kerrawa, tru nø chi tøgagúilane katøganeløba pirisan cha. ");
INSERT INTO gum_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Naingatø pasrømíibe, nan tsaleelaingatø maran. Naba tulishimíibe truørøtø wiitan cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Kan trømbøig maringarub kwaimandzig møweinukkurri webippe, chugøben purmerasrø isramig lab uña, yandø wetørranrrab kaimappe, trenchibig køn: “Katø nai yamay inrrab cha, na chugurri webarrua arrinuumaytøwei.” ");
INSERT INTO gum_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Incha katø arruabe, tru møwane kan yawan chishtø paluuncha, tamara pasrig lataig wetørranrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Incha ippe, katøgan kwaimandziimera, nø lataguen kømø, mas larrø trømbøig marøbelan sieteba tulundzuna, søteeløba trubalatø tru møweinug purrønrrab kebamrrun cha. Inchen tru møøbe yandø srabebe mas purø kaikken kørrømisrtrun cha, tru srøsrø lataitøguen kømø.— ");
INSERT INTO gum_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús iilan waminchib pasramne, misag utu kan ishug øyeeg chib trashibig køn: —¡Ñun tøgagøb, mutsøsrøb ishuube mayanguen tab kuig køn!— cha. ");
INSERT INTO gum_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Inchen Jesúsbe trenchibig køn: —Tius maig taigwan mørøb, maig karuilan mørøbelø, truiløbeguende mayanguen tab kuilø køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Misaamera Jesúsweim pøtøgatan mas mas tulundzunøben, nøbe trenchib waminchib pølbasrøbig køn: —Møin kwaløm larrø kaig misaamera, Tius naba pasrain kui ashchab marig miatan cha. Inchendø asha kønrrai katøgan chigøben peg kenamara tranmøtø, tru Jonásweiwandø eshkamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonásma Nínivesrø warab misaameraimbe chigøben kønrrab kuitamab isua asha kømig kønrrai nune treeg pasrig køn cha. Treetøwei na, Møg Misra Arrubikkucha møin kwaløm misaameraimbe isua asha kømig kønrrai pasrig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tru ambø umbu pirausrø reinagucha Tiuswei tru maig kønrrabigwan asha maram kwalømbe kurrønrrun cha. Incha nøbe tru møin kwaløm møguelø ñimun møra melønrrai maringarunrrun. Kaguende nøma purø yabsrøngurringuen arrig købig køn, Salomón, tru purø kusrebig wamindigwan mørtrab. Inchen yu pasrabiibe Salomón lataitø kømø, mas nuikken kur chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tru Nínive ciudasrø misaamerabe Tiuswei tru maig kønrrabigwan asha maram kwalømbe kenamisrtrun cha, tru møin kwaløm misaameran kaiyu pønsrønrrab. Kaguende Nínivesrø misaamerabe Jonás eshkaigwan møra, nømui kaig mariilan isua møra, Tiusweimay lliraig køn cha. Inchen yu pasrabiibe Jonás lataitø kømø, mas nuig køn— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Muguen kan aceite lámparan piløga srørrøyu pasrmøwei, ni køtsø umbu pasrmøwei indan, masken kerrubelan tør kønrraimbe, pala pasran. ");
INSERT INTO gum_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Asru kappe kan lámpara lataig køn. Inchawei ñui kab tabig købene, ñui asrube kerriguba tør kebilig kønrrun. Inchen ñui kab kaig købene, ñui asrube kerriguba løstiig kønrrun. ");
INSERT INTO gum_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Inchawei ashiptø kuy, ñim tør tøgagúibe løstiig købgunmab. ");
INSERT INTO gum_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kaguen asru kerriguba tør køben, katø truyu chigucha løstiig kaabene, ñibe kerriguba tørgandø ashchun chibig køn, kan lámpara purø tørig, ñun piløben lataitøwei.— ");
INSERT INTO gum_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yandø Jesús chab waminchene, kan fariseo nui yau lincha manrrab attrai eshkaben, Jesúsbe kebya, mishatsigu wamisrene, ");
INSERT INTO gum_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","fariseobe Jesús mamigwan mamøwatø, tasig kinømø mai ashabe, truba kwaaren, ");
INSERT INTO gum_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Señorbe trenchibig køn: —Trube, ñim fariseosmerabe pasunba, platillonba wambiimaybe pillmabendø, ñimui umbube ñimbe misagwan kwaarøsra kerranrrab isuiløba, chigurrimbunø tøgagønrrab parø isuiløba, trutø netsailø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ñim chugúinguen mørmeelø! Tiusbe palamay asrwanma marig køppe, ¿katø umbuigwangucha nøtøwei marig kømuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Treeg inchibgunrriibe, tru umbu tøgagúigwan waachameran lastima asha, srørray chibig køn, treenchene, ñimune kerriguba chishig kørrømisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ay, ñim fariseos waachamera! Ñimbe erbabunan, rudan, chigurrimbunø katøgan shush tusrmeran Tiusweyasig diezmørig kanzhig, kanzhig wesrawa, tranendø, tru sølgandø tabig maramigwanba, katø Tiuswei tru undag købigwanbabe, ñimbe pinab marøbelø køn cha. Ñimbe marøppe, iilanwei maramig kuig køn cha, tru diezmørig kan kan wesrawa, Tiuswan tranamigwangucha pesannamø, tøgatø marøb. ");
INSERT INTO gum_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ay, ñim fariseos waachamera! Judíosmera tulundzuni yamerayu purø tab misaamera purrainug purramig chullelø, katø penab, yanøb indinug ñimune maig købash kømø, purø tabzhig wamønrrai inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ay, ñim waachamera, kwaig sørin trabmera latailø, chi kenameelø! Misaamera tru sørim palawan chigúinguen ashmø llirab kuilø latailø køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Inchen tru maig maramigwan martrai Moisés pørigwan kusrennøbiibe trencha løtabig køn: —Kusrennøbig, ñi øyeeg chippe, namungucha tøga wamøtan— cha. ");
INSERT INTO gum_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Inchen Jesúsbe trencha løtabig køn: —¡Ay, ñim waachamera, tru maig maramigwan martrai Moisés pørigwan kusrennøbelø chigucha! Ñimbe katøganelane niga ambamga kwatsiguelø neguanendø, ñimbe ñimdøweinguen ni kan tasig-unøtøgaguen kuñab kebachig kømui indan cha. ");
INSERT INTO gum_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ay, ñim waachamera! Tius maig karuigwan eshkabelan ñimui merrabsrø misaameratøwei kweecha, søriilø købelan ñimbe tamara pønsrøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Treeg mariitøga ñimbe ñimui merrabsreelø treeg marigwane lata kandø isubelø kui kenamaran cha. Kaguende nømuimburappe kweechen, ñimuimburappe tru sørin trabmeran tamaran cha. ");
INSERT INTO gum_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Inchawei Tius nø kusremburab kusrebig kuigu, trendaig køn: “Na maig karuigwan eshkabelanba, katø naashib karua øriilanba nabe øren, truilan kan utuelane kweechen, kanelane kaig martrun” cha. ");
INSERT INTO gum_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Inchawei pirøwan marøb uraskurri Tius maig karuigwan eshkabelan mayeelan kweetsiilai ani lusigwan Tiusbe møin kwaløm misaameran ulø payrrun cha, ");
INSERT INTO gum_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tru Abelwan kweecha ani lusigwangurrimbunø, tru Zacarías altarba, santuarioba pønrrabnug, tru tøbøtag pasrøben kweetsig, tru Zacaríaswei ani lusigwangatig. Inchawei nabe ñimun trendamønrrun chibig køn: Tru misaameran kweetsiilan Tiusbe møi ya misagwan ulø payrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ay, ñim waachamera, tru maig maramigwan martrai Moisés pørigwan kusrennøbelø! Kaguen tru nebua ashib kusreb kømig kan llavi lataig tøgagúigwan ñim kerrawa tøgagua, ñimdøweinguen kebammøwei, ni kebambug kui inchibelan chigucha kebambashmøwei indan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús truyugurri webibene, tru Moisés pørigwan kusrenanøbeløba, fariseosmeraba Jesúswan truba nama, ke chine payib mendabelø køn, ");
INSERT INTO gum_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kebenøsrkøg køptø, nø chi kusrua løtøbene, chigøben tamig tøgagønrrab. ");
INSERT INTO gum_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Trune misaabe truba truba nørrø tulundzuna, nu køptø ke nømdø melambub itøbuniyaben, Jesúsbe nui kusrenanøb pera uniilan nømunmerrig trenchib pølbasrøbig køn: —Au, fariseosmerai levaduran ashiptø kuy cha, tru palatøbe truba tab indigwan. ");
INSERT INTO gum_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pøs chitøgucha søra pasriibe søriitø kørrømisrmø, ashchai kenamarig køben, katø wammørmønrrai søra tøgagúibe wammøriimíibe kørrømisrtraamøn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Inchawei ñim løstøyu wamindigwane tøryu wammørøbguen inchen, ñim yaskabwan kasra nilø wamindigwane yabalasrøngurri trasaig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Na ñim nai linchibelane trenchar: Asrwandø kweechibelane kørig kui inchimøtay cha. Kaguen asrwane kweechendø, mas trømbøibe chi martrab kaiman cha. ");
INSERT INTO gum_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Inchendø nabe ñim møigwan kørig tøgagømigwan eshkarrumøn cha. Kweecha, mu manchinrrainga tru møra melamnug kegutchabig, truigwane kørig tøgaguy cha. Nabe katøle trendamønrrun: Trunune si, kørig tøgaguy cha. ");
INSERT INTO gum_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Trattrøgatø illinzheelan pa centavozhigweindø yanøbelø kømuitarru? chibig køn. Inchendø Tiusbe treelanguen pesannamø, ashibig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pøs ñimuimburappe ñimui turyu pusruumeranguen kan kan mundziizheelø køn cha. Inchawei chi kørig kui inchimøtay chibig køn. Truba yam illimera lataitøguen kømø, ñimbe mas purø nuweyelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Katø nabe ñimun trendamønrrun: Møikkøben misaamerai merrab ‘Jesúsweingatiig kur’ chibigwane na, tru Møg Misra Arrubikkucha Tiuswei ángelesmerai merrab treetøwei truigwane ‘nuingatiig kur’ cha, nabe trendamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Inchen misaamerai malau ‘Jesúsweingatiig kømur’ chibigwane Tiuswei ángelesmerai merrab nabe nungucha ‘nuingatiig kømur’ tamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Møikkøben na, Møg Misra Arrubigwan chigøben kaig waminchibigwane Tiusbe uløwan paymønrrab pesannanrrun. Trune møikkøben Espíritu Santon purø trømbøig waminchibigwaneguende pesannamø, ulø payrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ñimun payrrab judíosmera tulundzuni yamerayumay, kabe juezmeraimay, kabe karubelaimay srua ambene, mandø cha løtamermab, mancha løtamermab, chi tamermab chi isumøtay chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kaguende yandø wamindamig puben, Espíritu Santobe maig tamigwan ñimun kusrenanrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kan møikkøsrøn misag utu Jesúswan trenchibig køn: —Kusrennøbig, nai nunewan naimburabig kønrrabigwan pirisha, nan tranø chirra— cha. Inchen Jesúsbe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Au, kasuku, ¿nan kan juez lataig, kabe kan pirø pirishibig lataig kønrraimbe nane mu pasrah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Incha katø trenchibig køn: —Parø indamigwane treenchimønrrab ashiptø kuy cha. Kaguende kan møg øsig kømibe chi nørrø tøgagúinug pasrømíig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Incha katø ‘øyeeg lataitøwein køn’ cha, kemesra waminchib trenchibig køn: —Kan truba pua møwan nui pirømerayu truba truba ellmarig misren, ");
INSERT INTO gum_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tru puaibe nuinetø isub mendabe trendan cha: “¿Chindamer? cha. Nai ellmarig tulisailan yandø chu esegamig chigagur” cha. ");
INSERT INTO gum_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Inchabe treeg isubig køn cha: “Møimbe sí chi maram kui ashar cha. Nai mamig keerøb esegailan picha, mas nørreelø mara, truyu nai ellmarig tulisailanba, chi tøgagúilanba kerrigu esegamønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Incha nabe naasiitøwei trendamønrrun tan cha: ‘Møimbe si, chigøben truba nørrø esegailø yam pilawei pønsra war cha. Møimbe israb, mab, muchib kasraarau’ tamønrrun” cha. ");
INSERT INTO gum_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Inchene Tiusbe trendan: “Chugúinguen mørmø møg, møi yemdøwei ñui møsigwan miaben, kwamig nebuben, ñi esegawa tøgagúibe, ¿muin kørrømisrtrerah?” cha. ");
INSERT INTO gum_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","’Kan møøbe nuyasiitø chine palømø, tun pønsraindøgucha, Tiusweimburabigwan chiguchaga waachawane øyeeg purainrrun— chibig køn, Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Incha Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: —Ñimune trendamønrrun cha: Øsig amønamig, ñim mamigwanba, asru chi kemermab isumigwanba menrra isumøtay cha. ");
INSERT INTO gum_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pøs øsig amønamikkan kan mamig lataitø kuitarru cha. Kabe asrkan kan asru keelø lataitø kuitarru cha. ");
INSERT INTO gum_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pøñiimeranma asay cha, chi ellguamøwei, ellmarig tulishimøwei, mamig esegamig chi kawei, mamig nørrø keera tun pønsra esegamig chi kaweyelanguen Tiusbe manrrai mannøbig køn cha. Ñimbe illimera lataguen kømø, maseløguen køn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ñim møiløgøben, maya maya incha, katøgan tøbø metrotøguen nurabsruguh? cha. ");
INSERT INTO gum_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ñim yandøzhigwanguen martrab kaimabeløbe, ¿katøgan peg maramelane chinchabrre isugue? cha. ");
INSERT INTO gum_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Umeranma asay chibig køn, kwallmøwei, kumøwei inchibelø købendø, tabig nørrøran cha. Inchendø nabe ñimune trendamønrrun: Rey Salomónguen nui chine purø tabzhig tøgagua, umera lata tabzhiibe kemuig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wambig kaumera, møi ka pønrrøwa, srønabe nagu parrig kønrrabigwanguen Tiusbe øyeeg tabzhig kenanøb lataig marøbiibe, ñimune treetøguen kømøtø, masken marmønrraitarru cha, ñim isubigwan Tiusweinug pasra tøgagúigwan ke kagømønrraindøzhig tøgarwan. ");
INSERT INTO gum_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Inchawei chindamermab isuptø menrra isui inchib lamøtay chibig køn, chi mamermab, chi mutsamermab. ");
INSERT INTO gum_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kaguende yu pirau misaamerabe mutøgucha iilan isua labelø køn cha. Trune ñimui Møskaimbe ñimui chi palabelan ashaguen wabig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Treeg kømøtø, ñimbe Tius nø ashib karub wainuguigwan isua lay chibig køn. Trumaybe tru katøgan chi palabelangucha ñimbe nemarig utønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Nai mamdø ubishazheelø, chi kørig kui inchimøtay. Kaguende ñimui Møskaimbe nui karub wainuguigwan tranamig tab kui indin køn. ");
INSERT INTO gum_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chi tøgagúilan yana, chigarwan tranay, treeg marabeguende, an pusrig urasrmera, pinønrrabig kømeelø tøgagønrrabguen, chi tøgagúilø managuen pinønrrabgailan srømbalasrø eseganrrab. Truyube niliig kebinrrab kaimabwei, ni pullilla parmøwei inchibnug. ");
INSERT INTO gum_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kaguende ñimui chi tøgagúilø chu esegaig pønrrøbene, ñimui manrrøgucha ke truyutø isub pasrønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ñimbe kewa, tamara, pørønawa, martrab ke muniitø kuy; katø ñimui aceite usri lámparamerangucha piløga kuy; ");
INSERT INTO gum_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ñimbe kan mendig melabelø latailø kønrrigay ya puaig novios yaugurri attrab køben muniirabelø latawei. Incha pua, nø yaskabwan pinrrøgøbene, kurtrab muniitø melabelø latailø kømig køn. ");
INSERT INTO gum_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mayanguen tab kuilø køn tru karuindiig melabelø ya puaig nømun kib køben kømø, kasrig purrabyuh puinabeløbe. Nabe ñimun cierton trendamønrrun: Ya puaig nøashib tamara pørønawa, mishatsigu nømun purramisringarua, mamigwan nøashib pirishinrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yem tøbøtag pui lata, løtsø pui lata nømun kib kømø, kasrig purrøben puinabeløbe mayanguen tab kuilø kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kan ya puaima niliig chu uras attrab kui mørimbe, yau nilønrrab kebibashmubsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ñimgucha tamara melay chibig køn. Kaguende tru Møg Misra Arrubiibe chi isumø købenba arruptinchun— cha. ");
INSERT INTO gum_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Inchene Pedrobe trencha payibig køn: —Señor, ¿iig ‘øyeeg lataitøwein køn’ cha, kemesra wamindigwangan namuyasiitø waminchitirru? cha, kabe ¿mayeelain kuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Inchen Señorbe trenchibig køn: —Kan karuindiig megabig maig taigwan møra marøb, katø chi maramelan nøtø tsabø asha marøbigwan, ya puaig nui yau warabelan mannam ura puin kuindø nømui mamigwan srøttrab muniitø wabig kønrrai ashai wanninabiibe ¿møig kerah? cha. ");
INSERT INTO gum_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Truibe mayanguen tab kuig køn cha, nun karua pasrigwan marøb megabenh ya puaig puptindinabigweimbe. ");
INSERT INTO gum_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pøs nabe ñimun cierton trendamønrrun: Ya puaibe nui chi tøgagúigwan kerrigu nø asha marøb pasrønrrai tranrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Inchen tru karuindiig megabig nuinetø ya puaibe peguen arrumønrraitamab isua, katøgan karuindiig melabelan møguelan lata, ishumburmeran lata kurrabetab menda, katø mab, muchib, mutsiirab tsubenba, ");
INSERT INTO gum_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nui ya puaibe ni attraitamab isuinguen kømø kwaløm, ni ø uras punrraitamab isumø tsubenba, puptincha, purø trømbøig ichagucha, maig taigwan marmeelø pønrrainug kertrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Inchen tru karuindiig megabig nun karua pasrøbig ya puaig maig maramig palai indi ashibig købendø, tamarmøwei maig chiben mørmøwei inchibigwane truba yam ichagutsig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Inchen tru karuindiig megabig nun karua pasrøbig ya puaig maig maramig palai indi mørmøwa, kørrø ichagutsamdiig marøbigwane trengatig yam ichagutsig kømønrrun cha. Inchen møigwan køben maramigwan mas nu tranøppe, treetøwei nu ulø payrrun cha. Inchen møigwan køben mas purø nørrø maramig traninabigwane, trunune masken nu ulø payrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Nabe yu pirau nag lataig kegutchab arrig køn. ¡Nabe yambe manawei pilabguen pasrømønrrammab truba isur! ");
INSERT INTO gum_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nane purø trømbøig pinøbuløb arrubigu pureb yamig nebunrrautan. ¡Nane purø isutan treeg nebumnegatiibe! ");
INSERT INTO gum_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ñim isubgan nabe piraumay arruppe, ambumay imay tab købigwan srua arritamab isugueh? Nabe treeg kømøtø, nøørøtø, nøørøtø inchib kønrrai arrur cha trendamønrrun. ");
INSERT INTO gum_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kaguen møingurrimbunøbe kan yau trattrøgatø purramnuube nøørøtø inchib kønrrun cha, pøneløbe pailan namig kurra tarømisren, pailøbe pønelan namig kurra tarømisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Møskaimbe nusrkawan namig kurrøben, nusrkaingurrimbe møskawan namig kurrøben, usrimbe nimbasrwan namig kurrøben, nimbasrkurrimbe usran namig kurrøben, sueeragurrimbe yernan, katø yernagurrimbe sueeran namig kurrønrrun— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Incha katø Jesúsbe misagwan trenchibig køn: —Wañimera pørr kebibsrø kurrab arrubene, ñimbe trenchibelø køn cha: “Sre punrrun” cha. Inchen pubwei inchibig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Inchen isig ambø umbusrøngurri webarrubene: “Pachig kønrrun” chiben, treegwein købig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Palatø tabelø! Pala wañi maig pasrai asha, pirau maig kui asha ñim øyeeg kønrrun chib, øyeeg kønrrun chib waminchibelø købendø, ¿møin kwaløm chi pureb arrubigwane, trube, øyeeg kønrrun chinrrab wetøgørrønrrab kaimabeløbe mailø køgue? cha. ");
INSERT INTO gum_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Sølgandø tabig maig kønrrabigwan ñimasiyaitøwei chindimba asha tamarmøgue? ");
INSERT INTO gum_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ñun maig maramigwan asha marig kønrrai tru kejabiiba, tru maig maramigwan asha marøbigweinuumay ambub pønrrappatø, mallatø trunun mayutø nøba tamara kørrømisrtrab inchi. Inchippa ñun juezweimay srua amben, juezbe policíameran trana øren, truiløbe ñun merrarrawa kailan keeri yau keera pasrmønrraimbe. ");
INSERT INTO gum_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pøs nabe ñimun trendamønrrun: Truyugurri webinrrappe, maya ulø misrigwan ke chishtø pagarawatøwei webinrrabguen— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Inchen tru urastøwei møiløgøsrøn truyu pønrrøwabe Jesúswan trenchibelø køn: —Pilatobe mø møguelan køsrøn galileasreelan kweecha, truilai aniwane tru nøm Tiuswan tranamig animal kweetsiilai animba lindisain køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Inchen Jesúsbe trenchibig køn: —¿Ñim isuppe, Galilea møguelø treeg nebuinabeløbe, tru nømui pirau katøganelø lataguen kømø, purab kailø kuimbarre treeg nebuitamab isugueh? cha. ");
INSERT INTO gum_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nabe ñimune treeg kømøn tamønrrun. Ñimdøweinguen ñimui kaig mariilan isua møra, Tiusweimay lliramuisruandøbe, ñimgucha mayeeløba truilø lataitøwei kwanrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Kabe ñim isubgan Siloésrø tru purøbala ya itøguebeñen kwabelø tru dieciochoeløgan Jerusalénsrø maya misag warabelan purab kailø kuitamatirru? chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nabe ñimune chi treeg kømøn tamønrrun. Ñimdøweinguen ñimui kaig mariilan isua møra, Tiusweimay lliramuisruandøbe, truilø lataitøwei ñimgucha mayeeløba kwanrrabguen— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Incha Jesús katø ‘øyeeg lataitøwein køn’ chib, iigwan kemesra waminchibig køn: —Kan møg nui pirau kan higuera tusr ellguawa, tøgagua, higos niguitashchab ashchab ya, chigucha wetørramíig lataig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Inchabe tru pirø ashib møwane trendan cha: “Au, na pøn pilawan mamig lanrrab i tusryu arrua, managuen wetørramur cha. ¡Lutiichi! tan cha. ¿Tusrwan pirøyu ke ka yandøbe chinchib pasrøbashchab?” tan cha. ");
INSERT INTO gum_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Inchen tru pirø ashibiibe trenchibig køn cha: “Au, nai ashib karubig, møim pilatøbe ka pasrøbashchab cha. Na pirøwan alaaranøb, animal pøy pusrtrab cha. ");
INSERT INTO gum_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Inchippa, treenchene mamig misrøbgun cha. Inchendø katøgucha misrmubene, trube, lutitchig” tan cha, trendan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kan isrin kwaløm Jesús judíosmera tulundzuni yau kusrenanøb pasrøbene, ");
INSERT INTO gum_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","truyube kan ishug dieciocho años ørøba kwanrrø uñibig wabig køn, kwaimandzig utsømay kesrungaruig, ni chinchagucha kurrashchab kaimabig. ");
INSERT INTO gum_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Inchen Jesúsbe nun asha, wamabe trenchibig køn: —Au, ishug, yandø ñibe kwanrrø kømø, tabig kørrømisran— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Incha nui tasigwan tru ishuweim pala estsarene, ishuube møi møi ølmisrøb, kurraashibig køn. Incha Tiuswan truba tabig waminchib mendabig køn. ");
INSERT INTO gum_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Inchen tru tulundzuni yau ashib karubiibe, Jesús isrin kwaløm treeg tamarikkurri truba nama, misaamerane trenchibig køn: —Chigøben maramigwan maram kwalømmerabe seis días køn cha. Ñimui kwanrrømeran tamariilø kønrrappe, tru kwalømmerawan tamartrai amrrumbala cha, isrin kwaløm kømøtø.— ");
INSERT INTO gum_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Inchen Señorbe kusrub trenchibig køn: —¡Palatø tabelø! ¿Ñimma møikkøben ñimui weywan, kabe ñimui burron isrin kwaløm pi mutsøsrønrrab sruamrrab pichimeelø køtirru? cha. ");
INSERT INTO gum_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","I ishug Abrahamwei misagwan Satanás kwanrrøtøga dieciocho años ørøba lusra lataig tøgagúigwan, ¿Kabe isrin kwaløm køn chiptø i kwanrriigwane øyeeg iløsrkaig megaigugurri elatsamig kømø, chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús nø øyeelan waminchene, nui ashig kømui inchibeløbe søteeløba køriimisra kørrømisren, trune katøganeløbe Jesús tabig mana asiimíig mari ashabe, truba kasraarabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Incha katø Jesúsbe trenchibig køn: —¿Tius nø ashib karub pasraibe chi lataig asønan chinrrab køh? cha. Kabe ¿møig lataig køn chinrrab køh? cha. ");
INSERT INTO gum_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pøs kan murtasa yellwan kan møg nui trau tsurøb lataig køn cha, nurawa, kan tusr-unøburabig misren, pala amøñibelø illimeraguen tru srarmerayu le maran— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Katø Jesúsbe trenchibig køn: —¿Tius nø ashib karub pasraigwane chi lataig køn chinrrab køh? cha. ");
INSERT INTO gum_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pøs levadura lataig køn cha. Kan ishug pa arruba harina sømara, levaduran pusren, maya sømarigwan trunun ørøba pulingarub lataig.— ");
INSERT INTO gum_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pueblomerasrømba, yamera tsitsø pønrrabsrømba Jesúsbe kusrenanøb Jerusalénsrømay pureb ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Inchen møikkøsrøn trencha payibig køn: —¿Señor, kaigyugurri wesrainanrrabeløgan mamdeelø kønrrab kuitarru?— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Inchene nøbe trenchibig køn: —Trag yaskabwan kebambamigwan ñimbe kebamrrab tranrray cha. Kaguende nabe ñimun trendamønrrun: Mayamba kebamrrab inchendø, kaimanrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ya puaig kurra, yaskabwan kasrøbene, ñim wambig kørrømisrøbeløbe yaskabwan pinrrøgøb trenchinrrun cha: “Señor yaskabwan kurtra” cha. Inchen nøbe ñimune trencha løtønrrun cha: “Nabe ñimune chuelø kui ashmíig kur” cha. ");
INSERT INTO gum_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Inchen ñimbe trenchinrrun cha: “Nambe ñiba mab, muchib inchen, katø ñibe namui callesmerayu kusrenanøb indig kømøh” cha. ");
INSERT INTO gum_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Inchene nøbe ñimune trencha løtønrrun: “Nabe ñimune chuelø kui ashmur cha. Kaig marøbeløbe mayeeløba nainukkurrimbe tarømisray” cha. ");
INSERT INTO gum_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Inchen ñimbe truyube kishib, trugulmeran tsatsamig kønrrun cha, Abrahamwan, Isaacwan, Jacobwan, katø mayeelø Tius maig karuigwan eshkabelan, Tius nø ashib karub waisrø nøm trusrø purrøben ñim asha, ñimbe wambig webetiilø kua. ");
INSERT INTO gum_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kaguen pørr kal-labgatøsrøngurrielø køben, pørr kebibgatøsrøngurrielø køben, ambøgurrielø køben, igurrielø køben, yu pirau chugurrieløtøgucha amrrunrrun, Tius nø ashib karub wainug purramisra manrrab. ");
INSERT INTO gum_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Inchen møiløgøben møi ya yu pirau srabe melabeløbe srømbalasrømbe nømmerrig pønrrønrrun. Inchen møi ya yu pirau nømmerrig pønrrabeløbe srømbalasrømbe srabe melønrrun— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Inchen tru kwalømdøwei mø fariseosmera køsrøn puabe, Jesúswan trenchibelø køn: —Ñiguen yugurri webya, inrrø cha. Kaguende Herodesbe ñune kweechig kuin køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Inchen Jesúsbe trencha løtabig køn: —Ø zorra lataigwan trenchinrrab ambay cha: “Au, møimba, srønaba nabe kwaimandziimeran webetab, kwanrreelan tamarøb, trumarbe nai maramigwan patsøgamønrrun” tan chinrrab. ");
INSERT INTO gum_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Inchendø nabe møimba, srønaba, trumarba nai maywan ib yamig køn cha. Kaguen Tius maig karuigwan kan eshkabiibe nøørøsrøn kømø, Jerusalénsrø kwamig nebunrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jerusalén! ¡Jerusalén! ¡Tius maig karuigwan eshkabelan kweechib, katø ñimuyasig Tius karua øriilan sruutøga petabig! ¡Nabe yamba, kan piejetø kømø, kan atøwall nui pullichu-uregwan kwaldzarig umbu kanbalatø mara, maatanab lataitøwei ñui uregwan tulundzunønrrab inchen, ñibe nane kaasig køn! cha. ");
INSERT INTO gum_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Au, ñim waraig yamerabe elatsig kørrømisrtrun cha. Inchawei nabe trendamønrrun chibig køn: Nane mas ashchaamøn cha, øyah tamnegatig: “¡Señorwei munchiyu nø ørig arrubiibe mayanguen tab kuig køn!”— cha. ");
INSERT INTO gum_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kan isrin kwaløm Jesúsbe kan fariseo chi maramigwan nø ashibigwei yausrø manrrab kebya wabene, kaneløbe ke chindashchab ashibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Inchene truyube kan møg Jesúswei merrab parab kwanrrø tøgaig wabene, ");
INSERT INTO gum_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesúsbe tru maig maramigwan martrai Moisés pørigwan kusrenanøbelanba, fariseosmeranba trencha payibig køn: —¿Isrin kwaløm kan kwanrriigwan tamarmønrrai merig kø, chindah, kabe merømuig kø, chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Inchen nømbe chigucha løtømeelø køn. Inchene nøbe kwanrriigwan srua arrua, tamarabe, yandø inrrai ‘ungwa’ chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Incha nømune trenchibig køn: —¿Ñimma møikkøben, ñui nusrkain kui, kabe ñui wey kui pisuyu kebeñenma, isrin kwaløm kuingucha, tru urastø wesramønrraitirru?— cha. ");
INSERT INTO gum_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Inchen nømbe øyeelan chigucha løtønrrab kaimabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Linchab amrrunrrai eshkaig misaamera mishatsigu mas tab purramdønug, tab purramdønug laben, Jesúsbe treeg indi ashabe, øyeeg kømig køn chib eshkab waminchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Møikkøben ñun kan novios yaumay linchab attrai eshkabene, mas tab wamdønug merrarramøta cha. Inchippa ñi lataguen kømø, mas nuigwan linchab attrai eshkaig kua, truig puben, ");
INSERT INTO gum_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tru ñunba, truigwanba linchai eshkabiibe arruppa: “Ñi waigwan ønun tranø” chibene, ñibe køriimisra wendausrø wanrrab purainrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Treeg inchimøtø, masken ñun lincha cha eshkabene, wendausrø wamisr cha, tru ñun lincha chibig arrua: “Ñi, kasukube, yu merrabsrø wanrrab puraamø” cha, ñun trenchinrrai. Inchen ñibe tru mishatsigu ñiba purrabelai merrab truba tab indig kønrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kaguen møikkøben nøasiitø ‘nuig kurmab’ isubigwane, ka kørig martrun cha. Inchen nøasiitø ‘nuig kurmab’ isumíigwane ‘i møøbe si, nuig køn’ taig kønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Incha katø Jesúsbe tru lincha cha eshkab møwangucha trenchibig køn: —Ñi kan mamig srørrøppe, ñui asiilandø kømøwei, ñui nunelandø kømøwei, ñui misagwandø kømøwei, ñui ya pulu puarmerandø kømøwei wama srøsr cha. Kaguen truiløbe ñungucha treetøwei linchai wama, nømgurringucha treetøwei marene, truburø ñibe utamigwan uta kørrømisrtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Treeg kømøtø, ñi kan fiesta marøppe, waachameran køben, kønønrrab kaimabelan køben, cojosmeran køben, kabgarmeran køben linchab amrrunrrai eshkawabe, ");
INSERT INTO gum_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ñibe mayanguen tab indig kønrrabguen cha. Kaguende truiløbe ñune katøburø treetøwei marmuindøgucha, sølgandø tabigwan marøbelø katø øsiirab kwalømbe, tru ututø ñungucha Señorbe truburø tranamigwan tøgatø tranig kønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Inchen iigwan mørabe, tru kan mishatsigu wabiibe Jesúswan trenchibig køn: —Tius nø ashib karub waisrø mamigwan mabiibe mayanguen tab kuig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Inchen Jesúsbe nun trenchibig køn: —Kan møg truba nørrø mamimera mannamig tamara, misaamera truba nu linchab amrrunrrai eshkawa, ");
INSERT INTO gum_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","yandø mam urasbe nui karuindiig megabigwane tru lincha tailan trenchinrrab ørøbig køn cha: “Yandø ke chab pønsrainguen pønrran cha, amrruy” chinrrai. ");
INSERT INTO gum_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Inchene møitøgucha ke chine kemesrøb mendabelø køn cha. Srøtiibe: “Kanbalø pirø ke møindø chab pena, trunun ashchab inrrab war tan cha. Treekkurri kaimamønrrun tan chirrunrrig cha”, trendan cha. ");
INSERT INTO gum_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Inchen kane: “Weymera diez arabelø pena, maig marøbelø køtashchab ashchab inrrab war tan cha. Treekkurri attrab kaimamønrrun tan chirrunrrig” tan cha. ");
INSERT INTO gum_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Inchen katøgane: “Ke srø kasharawa kua, trugurri attrab kaimamønrrun tan, chirrunrrig” tan cha. ");
INSERT INTO gum_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Inchen karuindiig megabiibe ya, tru nun karub pera wabig ya puaigwan kerrigu eshkaben, nøbe namappe, karuig megabigwane trenchibig køn cha: “Malla inrrø cha, ciudayu calleswanba, maywanba ya, waachameran køben, kønønrrab kaimabelan køben, cojosmeran køben, kabgarwan køben yu pera attrig” cha. ");
INSERT INTO gum_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Inchen mas yanasrø tru karuindiig megabiibe trenchibig køn cha: “Ñi nan karub pera wabig, ñi maig karuigwan maren, katøgucha aldø pasran” cha. ");
INSERT INTO gum_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Inchen nøbe tru karuindiig megabigwane: “Ciudayu wambiisrø nørrø maymerawan køben, shush maywan køben ya, nai ya netsanrrai katøganelan amrrumø kømø, ke amrrumne wamønrrig cha, trendan cha. ");
INSERT INTO gum_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kaguende nabe trendamønrrun: Tru srøsreelø na lincha cha wamiiløbe møikkucha nai mamigwane maig mamig kuinguen mørtraamøn” cha trendan— chibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Misag truba nørrø Jesúswei mendig amben, nøbe keesha ashabe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Møikkøben naimay arrua, nui møskawan, nui usran, nui srawan, nui uregwan, nui nunelan, nui nuchalan lataitøguen kømø, nan mas undaarab, katø nui øsig kømigwan lataitøguen kømø, nan mas isub undaaramíibe nai mendig uñibig kønrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inchen katø møikkøben nui kuruswan nø muta arrumigwan muta, nai mendig arrumíibe, nai mendig uñibig kønrraamøn chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ñimma møikkøben, kan truba pala ya martrab inchabe, ¿patsøgamdiig køtashchab anwanmerrig ashchab wamisrmønrraitirru? cha. ");
INSERT INTO gum_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Treenchimøtø, pøtøburab pølsrugwandø pølbasra, patsøgønrrab kaimabene, mayeelø ashibeløbe ñune indzatø ashib trenchinrrun cha: ");
INSERT INTO gum_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ø møøbe yawan martrab pølbasra, patsøgønrrab kaiman” cha. ");
INSERT INTO gum_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kabe kan reyma katøgan reyba kwayanrrab webinrraptø, ¿suldaumera diez mil nø tøgagúitøgaba, katø tru nøba kwayanrrabig suldaumera veinte mil pera arrubiiba, ka kwayamdiig køtashchab trununmerrig isunrrab wamisrmønrraitarru? cha. ");
INSERT INTO gum_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pøs kaimappe, tru katøgan rey yabsrø srø pasrøbenbatø, kwayamø, tammay kørrømisrkun chinrrai karuilø ørtrun cha. ");
INSERT INTO gum_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Inchawei ñim møikkøben chi tøgagúigwan kerrigu elachimíibe, nai mendig uñibig kønrraamøn chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Trebe tabig køn. Inchendø yandø tru trebe larrmíig misrabe, ¿katøbe chincha kui larrøbig misriasamø? ");
INSERT INTO gum_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pirø tamisrtrai pirøyu wiitamdiig kømøwei, animal pøywan abono marigu pusramdiig kømøwein køben, yandø petig kønrrun cha. ¡Møramig kalu pønsraibe mør!— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Romasreelayasig an utabeløba, kaig marøbeløba Jesúswan mørtrab mayeelø kemallen, ");
INSERT INTO gum_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","fariseosmeraba, tru Moisés pørigwan kusrenanøbeløbabe yeeg marøbig køn chib, trenchibelø køn: —I møøbe kaig marøbelan wamab, truiløba mab inchibig køn— chib. ");
INSERT INTO gum_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Inchen Jesúsbe ‘øyeeg lataitøwein køn’ cha, kemesra waminchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Ñimma møikkøben ubishamera cien tøgagua, truilø kan palab misrene, noventa y nueven wambig nøørøsrø nømdø warønrrai warøbashippa, wetørramnegatig tru ubisha trubabigwan lanrrab imønrraitirru? cha. ");
INSERT INTO gum_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Incha wetørrappe, kasrag købiitø, ñui kildunyu muta, arrua, ");
INSERT INTO gum_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","yandø yau puabe, ñui ya puluelanba, ñui trendø asielanba tulundzuna, trenchinrrun cha: “Naba kasraaragun cha. Kaguende nai ubisha trubabigwan wetørrar” cha. ");
INSERT INTO gum_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Inchawei nabe trendamønrrun chibig køn: Srømbalasrøngucha treetøwei kasraaran køn cha, kan kaig marøbig nui kaig mariilan isua møra, Tiusweimay llirabene, tru noventa y nueve sølgandeelø tabelø isua møramig chi palømeelaimburab lataguen kømø. ");
INSERT INTO gum_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Kabe ¿kan ishuuma anzheelø diez tøgagua, truyu kan trubøbene, kan lámpara piløga, yawan paluunchib wetørramnegatig, tab lamønrraitarru? cha, ");
INSERT INTO gum_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Incha wetørrappe, nui trendø asielanba, nui ya puluelanba tulundzuna, trenchinrrun cha: “Kaguen nai an trubigwan wetørrar cha, naba kasraaragun” cha. ");
INSERT INTO gum_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Inchawei kan kaig marøbig nui kaig mariilan isua møra, Tiusweimay llirabene, Tiuswei ángelesmerai utugucha treetøwei kasraaranrrun— cha trendamønrrun. ");
INSERT INTO gum_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesúsbe katø trenchibig køn: —Kan møg pagatø nusrkalø tøgagúibe, ");
INSERT INTO gum_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","wendiibe møskawane trenchibig køn cha: “Nai møskai, nan keta tranig naimburab kønrrabigwan pirishirra” cha. Inchen møskaimbe chi tøgagúilan nømun pirisha, tranen, ");
INSERT INTO gum_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","mam kwalømyutø tru wendø nusrkaimbe nuimburabigwan kerrigu tulisha, yabsrø katøgan pirausrømay ya, trusrø chigøben kaig marøbyutø patsø pinishibig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Inchen nui anwan yandø chab patsøgøbenba, tru pirausrømbe chutøgucha parøbe truba nuig arruben, nune yandø palabig arrub mendabig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Inchen tru pirausrø kan møweinug maramig lanrrab ibene, truibe nui kuchimera waraisrø, kuchi ashib meganrrai ørøbig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Inchen nøbe tru kuchi maig mamimeran øska mainrrabna isuben, nune muguen chi srørrmeelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Inchen nøbe katøle isua mørabe trenchibig køn cha: “¡Kan nai møskawei yau marøb melabeløbe mamig yeeg nørrø uncha tøgagøben, trune nabe yu parøgwab kwamønrrun! cha. ");
INSERT INTO gum_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Trembe nai møskawei yamay katø kurrab ya, nune trendamønrrun cha: ‘Nai møskai, Tiusweimburappa, ñuimburappa kalø mara pasrar cha. ");
INSERT INTO gum_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Møimbe yandø kan ñui nusrkain kui lataig tøgagømgaig kur cha, ñui marøb melabelan lataitøwei tøgagørra’ chinrrab tan” cha. ");
INSERT INTO gum_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Incha møskawei yamay ib mendabig køn cha. ’Inchen møskaimbe yab arrubendø, nebua asha, kan nai unan yeekkucha nebuitamab lastima ashabe, katønrrab lula, irab, muchab indan cha. ");
INSERT INTO gum_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Inchen nusrkaimbe møskawane trendan cha: “Nai møskai, Tiusweimburappa, ñuimburappa kalø mara pasrar cha. Møimbe yandø nai nusrkain køn cha wamig kønrrabgaig kur” cha. ");
INSERT INTO gum_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Inchen nui møskaimbe nui karuig mendig melabelan wama, trendan cha: “Kenanamelan mas tabelan petø wesrua kenanøb, tasigu surtigas pasrøb, alpargatis keetøsrøb inday cha. ");
INSERT INTO gum_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Incha tru ø tsal-lanin toron srua amrrua, kweetsay tan cha. Incha fiesta marøb, mab kasraaragun cha. ");
INSERT INTO gum_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kaguen i nai nusrkaimbe kwaig lataig kua, katø øsiirain køn cha, trubig lataig kuigwan katø wetørrar” tan cha. Incha fiesta marøb mendabelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Inchen tru mayor nusrkai tru trau uñibiibe arrua, ya pulu pub kuabe, truba may wanrrøb, palø ichib, katø pailab kui mørabe, ");
INSERT INTO gum_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","truyu kan møigwan køsrøn karuindiig megabigwan wama payibig køn cha: “¿Chinchibrren køh?” cha. ");
INSERT INTO gum_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Inchen truibe trenchibig køn cha: “Ñui nuneg puben, ñui møskaimbe tru tsal-lanin toron kweetsingarun cha, kaguen chigucha kømø, tabig ka øsig puben.” ");
INSERT INTO gum_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Inchene mayor nuneebe namaptø, kebarrumønrrab inchen, møskaimbe webya, kebattrai truba inchibig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Inchen nøbe møskawane trendan cha: “Yamba nabe ñun yeeg yam pila chu uragucha ñi maig karuigwan møra marøb megaben, trune nane managuen kan cabro-unøtøguen ketømíig køn cha, nai linchibeløba fiesta maramig. ");
INSERT INTO gum_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Trune møimbe ñui nusrkai ñui anwan kaig ishumburmeraba chab patsøga pubene, ñibe tru tsal-lanin toron kweetsin køn” cha. ");
INSERT INTO gum_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Inchene møskaimbe trendan chibig køn: “Nai nusrkai, ñibe chu uragucha naba waben, na chigurrimbunø chi tøgagúibe ñuiwein køn cha. ");
INSERT INTO gum_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Trune ñui nuneebe kwaig lataig kua, katø øsiirain køn cha; trubig lataig kuigwan, katø wetørrar cha. Treekkurri møimbe fiesta marøb, kasraaramibe søl køn” tan— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Incha katø Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: —Kan pua møg nui chi købigwan ashib tsunrrai trarrig tøgagøbig køn cha. Indiibe møiløgøsrøn tru pua møwan trencha eshkanrrab ambubelø køn cha: “Tru ñui chi købigwan ashib tsunrrai trarriibe ñi chi tøgagúigwan ke ka yandø chine marøb ka patsøgøb tsun” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Inchen tru pua møøbe tru ashib tsunrrai trarrigwan wamabe, trenchibig køn: “¿Chigúindørre ñune øyeeg waminchib køh? cha. Trube møimbe, ñi nai chi købigwan ashib tøgagúigwan nan lutøgurri eshkarra tan cha. Kaguen yandø nai chi købigwan ñibe ashib tsumibe mas kaanrrab køn” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Inchen tru ashib tsunrrai trarrinabiibe nuinetø treeg isubig køn cha: “¿Nan øyeegwan martrai tranøbig tru maramelan yandø nan kerrabene, trube, møimbe chi maramerah? cha. Yandø kwallchabgaig kur cha. ‘Chigøben kettra’ cha, miab unamibe kørig køtan cha. ");
INSERT INTO gum_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nan yandø ashib tsumønrrai weguchene, mugøben nømui yamerayu nan wamab utønrrai, møimbe si, nabe chi maram kui asha pasrar” tan cha. ");
INSERT INTO gum_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Inchabe nui ashib karubigwan ulø misrarwan kan kan wama, srøsriigwane trencha payibig køn cha: “¿Nai ashib karubigwan ñibe maya ulø kugu?” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Inchen nøbe: “Olivo aceite cien galones ulø kur” chiben, tru chi maramigwan ashib tsubiibe: “Ñui ulø misrig pørin kilgawan cha chiptinchibig køn. Petøzhiitø wamisrøb møimbe cincuentaindiig kørrøørøb pørøptinchi” tan cha. ");
INSERT INTO gum_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Incha katøganune: “¿Ñibe maya ulø kugu?” chiben, nøbe: “Tirigu cien cargas ulø kur” chiben, tru maramigwan ashib tsubiibe: “Ñui ulø misrig pørin kilgawan utørra chibig køn. Møimbe ochentaindiig truyu pør” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Inchen nui ashib karubiibe tru chi købigwan ashib tsunrrai trarrig maig maramigwan marmíigwane ke chi maramdiig køtasha ashib megawa marin kui ashabe, kan trengucha møg isua marøbig kønrrab tan cha. Pøs yu pirauigwandø isum misaamerabe nøm treeløtø misrøppe, purø møg isua marøbelø køn chibig køn, tøryuelai ureemera lata kømøtø. ");
INSERT INTO gum_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Nabe ñimune trendamønrrun cha: Yu tabig kømø pirau ñim an tøgamisriiløtøga misaamera asiimeelan asiilø mara tøgagønrrab inday cha. Treeg maren, ñimui tru chi tøgagúilø chab patsindøgucha, ñim managatig purramnug srømbalasrømbe nøm ñimun utønrrabelø purrønrrain cha. ");
INSERT INTO gum_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Inchen lamøtiigu søl marøbiibe nuwangucha treetøwei søl martrun chibig køn. Inchen lamøtiigu søl marmíibe nuwangucha treetøwei søl marmønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Inchawei yu pirau chi købig tabig kømíigwanguen ñim maig maramigwan søl asha marmeelane, ¿mas tru newan tabigwane ashib tøgagønrraimbe ñimune mu traniaasamø? cha. ");
INSERT INTO gum_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ñimuin kømíig pegwanguen ñim chi tab asha marmeelane, ¿mas ke ñimuyasig tøgagønrraimbe mu traniaasamørra? cha. ");
INSERT INTO gum_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Kan karuindiig megabiima muguen pailanbabe tab mara tranrrab kaimanrrun cha. Kaguende kanune tsalø ashippe, kanune undaaranrrun cha. Kanune chiyugucha truba tab mørøb megappe, kanune kaashib webinrrun cha. Inchawei Tiusweimburabigu marøb pasrønrrab isumba, anweimburabigu marøb pasrønrrab isumba inchibiibe martrab kaimanrrun cha, pabaløbabe.— ");
INSERT INTO gum_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Inchen fariseosmera anwane ke chinchimmørø inchib undaarabelø iigwan kerrigu mørøb pønrrøwabe, Jesúswan indzatø ashen, ");
INSERT INTO gum_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesúsbe trenchibig køn: —Ñimwein køn cha, misag malaube ñim ñimasiitøwei sølgandø amøñibelø tabelø misrøb pønrrabeløbe. Trune Tiusbe ñimui manrrømerayu chi isuilan asan cha. Kaguen møguelø purø tabig asønai indigwane, Tiuswein kabyube ashikken kønrrabgaig trømbøig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Maig maramigwan martrai Moisés pørigwanba, Tius maig karuigwan eshkabelø kusrenaniilanbabe Juan arrub kwalømgatig møra maramig købig køn cha. Inchen tru uraskurrimbunøbe Tius nø ashib karub waigwan tabig srø wamwan eshkab kusrenanen, mayeeløba kebamrrab tranrrabelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Srømbalaba, pirøba pønrrabelø pinamikken chigucha kømuben, trune tru maig maramigwan martrai Moisés pørigu maya lamøzhig pønrrabikken ka yandøbe, purainrraamøn chibig køn, Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Mu møøtøgucha nui srawan kucha, tarømisra, katøganba kasharabiibe, itølulan cha. Inchen katø tru keg kucha ishuuba kasharabiibe, katø treetøwei itølulan— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Katø Jesúsbe trenchibig køn: —Kan truba pua møg købig køn cha, larrø tab yalø pigøzheelø kemba, linotøga mariilø nuweyelø kemba, kwalømmørig purø tab fiestamera maramba inchibig. ");
INSERT INTO gum_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Inchen katø kan truba waacha møg Lázaro taibe, asru pisrøtø netsaig chu uragucha puaigwei yau wambig kerruinug yaskabu wamisra, ");
INSERT INTO gum_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","tru waachabe tru puaigwei mishatsigugurri kørriitøga øska mainrrabna isuben, trune pisrømerane werameratøø kemalla, nerab købelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Indiibe kan kwaløm tru waachabe kwaben, purø tabzhiisrø Abrahamba wanrrai ángelesmera pera ambubelø køn cha. Inchen tru puaikkucha kwaben, sørabelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Inchen tru puaibe tru kwabelø amba møra melainug purø trømbøig kui megawa, kurraasha, yabgurri Abrahamwanba, Lázaronba purrai ashabe, ");
INSERT INTO gum_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","trashibig køn cha: “Abraham, merrabsrø nai møskai, nan lastima asha, Lázaron ørtra chib, nui tasig-unandøguen piyu keguana, nai niløwan sømartrab attrai. Kaguende nabe yu i nag naarabigu mumaygucha kømui purø trømbøig kui megar” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Trendaingucha Abrahambe trenchibig køn: “Nusrkai, ñiguen isu cha. Ñi pirau øsig tsub urasbe ñibe tabiitø, tabiitø utøben, Lázarobe treetøwei kaitø, kaitø utig køn cha. Møimbe Lázarobe yube chi isumgaig tabig wamig utøben, ñibe mumaygucha kømui purø trømbøig kui megan cha. ");
INSERT INTO gum_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Treeg køben katøgucha, namuimba, ñimuimba tøbøtag kan purø trømbø umbu kulli pasran cha. Yugurri ñimuimay ambug kui inchibelø puramrrab kaimabwei, katø ñimuinukkurri namuimay purørrug kui inchibelø kaimabwei inchai.” ");
INSERT INTO gum_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Inchen tru puaibe trenchibig køn: “Treeg købene, trube, Lázaron nai møskawei yamay inrrai ørtra cha. ");
INSERT INTO gum_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Trusrø nunelø trattrøgatø tøgagur cha, nøm isua kønrrai truilan waminchai, nømgucha yusrø mumaygucha kømíig purø trømbøigumay amrrumønrrain” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Inchen Abrahambe trenchibig køn: “Nømbe Tius maig karuigwan eshkabelø pøriilan køben, Moisés pørigwan køben tøgar køn cha. ¡Truilan mørbash!” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Inchen tru pua møøbe trenchibig køn: “Nai møskai Abraham, kah, treeg kømøtø, møikkøben nømuimay kwailai utugurri kurra ibenesi, nømbe nømui kaig mariilan isua møra, Tiusweimay lliranrrun” cha. ");
INSERT INTO gum_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Inchen Abrahambe trenchibig køn: “Moiséswanba, Tius maig karuigwan eshkabelanba, truilanma mørmuibe, kwailai utugurri møikkøben katø øsiiraingucha mana kørenrrab kø” tan— cha, Jesúsbe trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: —Chine chinetø iløsrkøb kegørrøsrkøb attrabigwane arrumønrrai chincha katamgaig køn cha. Inchendø ¡møg waacha! tru kaigwan nø pera mara kebenøsrkøbigweimbe ¡kan maig kuaasamørra! cha. ");
INSERT INTO gum_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Trembe kan tirigu kitsig nu srugwan naashigu iløsrka, mar umbusrø kegutsig kuinguen søl købsruinrrun cha, i shushmeran kaig mara kegørrøsrkøbgunrriibe. ");
INSERT INTO gum_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Inchawei ñimdøwei ashiptø kuy cha. Ñui nuneg ñun chigøben kaig marene: “Ñi øyeeg marmumbala” cha, alegau, chibig køn. Inchen nø nui kaig mariilan isua møra, Tiusweimay llirabene, ñibe trunun yandø mas ulø paymønrrab, pesannau cha. ");
INSERT INTO gum_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mawawan nøbe katøle, katøle siete nebumnegatig ñun kaig mara, tru kaig marimørig ñun: “Øyeeg maramgaigwan marar” chib arrubene, ñibe trunun mas ulø paymønrrab, yandø pesannamig køn— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesús nøashib karua øriiløbe nun trenchibelø køn: —Namui isubigwan ñuinug mas tøga melaigwan nemartra— cha. ");
INSERT INTO gum_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Inchen Señorbe trencha løtabig køn: —Ñim kan murtasa yellburaptiitøguen isubigwan nainug pasra tøgar kuimbe, i sicomoro tusrwan: “Yugurri ucha, maryu ellgwawa pasrambu” chibene, tusrbe maig chiben mørøbsruinrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ñimma møikkøben, kan karuindiig megabig tøgagua arab uña, traugurrin kui, kabe ubisha ashib uña kui pubene: “¿Puraarrua, kabe yusrø manrrab wamisr” chinrraitirru? cha. ");
INSERT INTO gum_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Treeg chimøtø: “Nai mamigwanmerrig nena, pala itøgueigwan kewa, pørønawa, na chab mab, chab mutsamnegatig chi palain kuindø purørtrab ashib pasrau cha, treebe chinrrun cha. Incha trugurrimbe si, ñigucha mab, muchib inchig” chinrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kabe nui karuindiig megabigwanma nø maig karuigwan maren, ¿truburø ‘ungwa’ chibelø kuitarru? cha. ");
INSERT INTO gum_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ñimgucha treetøwei Tius maig karuigwan kerrigu marabe, trenchinrrigay chibig køn: “Nambe mendig melabelø chiguen trengatig marmeelø ker cha. Kaguende ke maig karuizhigwandø nebua marer”— cha. ");
INSERT INTO gum_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús Jerusalénsrømay ippe, Samaria pirøwanba, Galilea pirøwanba pureb maywan pureb ya, ");
INSERT INTO gum_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","kan yamera tsitsø pønrrabnug pubene, møguelø diezelø lepra kwanrrø asr ørø trerabig tøgar katønrrab werruppe, werrubendø, yaptø pønrramisra, ");
INSERT INTO gum_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","trashibelø køn: —¡Jesús, ñi Kusrennøbig, namun lastima ashcha!— chib. ");
INSERT INTO gum_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Inchen Jesús ashabe, trenchibig køn: —Judíosmerai sacerdotesmeran eshkanrrab ambay— cha. Inchen nøm ambub pønrramnetø nømui kwanrrøbe tammisra, chishmisrikken kørrømisrøbig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Inchen møikkøsrøn nun chishmisrin kui ashabe, truba mur trashib Tiuswan truba tabig waminchib katø arruabe, ");
INSERT INTO gum_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesúswei merrab tømbønsra ‘ungwa, ungwa’ chib maløwan piraugatig utsøbasrøbig køn. Tru møøbe judíoguen kømøtø, samariasriig købig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Inchene Jesúsbe trenchibig køn: —¿Kwanrrøwan chishmariilø kørrømisrøbeløbe yamba diez kømmørgøppeh? cha. ¿Nueveeløbe chu ambah? cha. ");
INSERT INTO gum_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Mu katøgan møikken Tiuswan maya nuguen tabig køn chib waminchab arrumuben, i peg pirausriitø Tiuswan ‘ungwa’ chinrrab arru chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Incha tru møwane trenchibig køn: —Kurra, inrrø cha. Kaguende ñui isubigwan nainuutø pasra tøgagúikkurri tabig kørrømisran— cha. ");
INSERT INTO gum_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseosmera Jesúswan Tius nø ashib karub wainuguiibe chu ura punrrerah cha, payen, Jesúsbe trencha løtabig køn: —Tius nø ashib karub wainuguig pubiibe kaptøga ke asha kønrrai attrabikkucha kømøn cha. ");
INSERT INTO gum_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kabe: “Yu pasran” chimøwei: “Uyu pasran” chimøwei inchun cha. Kaguen Tius nø ashib karub wainuguiibe ñimui umbuguen pasran— cha. ");
INSERT INTO gum_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Incha nui kusrenanøb pera uniilane trenchibig køn: —Na, Møg Misra Arrubig ñimui utu unin kwalømmera, katø kan kwalømzhiitøguen pumønrrabmab, ñim isum kwaløm attrun cha. Inchendø treebe asamig kaanrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ñimun: “Yu pasran” tantø: “Uyu pasran” tantø indingucha, ashchab ammøwei, mendig ammøwei inchigay cha. ");
INSERT INTO gum_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kaguen kan palaig pilabig kandarø srømbalasrøngurri katøgandarøsrø kebilab lataitøwei, tru Møg Misra Arrubig arrub kwalømbe treeg kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Inchen treeg pumøwatøbe, nabe chigøben marinab, kaashib indig kømig nebunrrun cha, møi misaamera. ");
INSERT INTO gum_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé tsub kwalømmerawan maig purayaibe tru Møg Misra Arrubigwein kwalømmerawangucha treetøwei purainrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Misaamerabe chi isumø mab, muchib, kasharab, kasharanøb inchib kuig køn cha, Noé nui nu barcoyu kebib kwalømgatig. Inchen sre kwarømíig pub menda, mayeelanba chab pinisaig købig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Katø Lot tsub uras chigucha treetøweim purayaig køn cha. Misaamerabe chi isumø mab, muchib, penab, yanøb, ellmarøb yamera marøb inchib købenba, ");
INSERT INTO gum_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot Sodoma ciudayugurri yandø webibene, srømbalasrøngurri naaba, azufreba sre pua, mayeelan patsø pinisaig købig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na, Møg Misra Arrubig kenamisrøb kwalømgucha treetøwein kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Tru kwalømbe ya pala wambig wabiibe, yaambu chigøben tøgaguabe, wesranrrab kørraarrumøta cha. Inchen møikkøben trau uñibiibe, yamay arrumøta cha. ");
INSERT INTO gum_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotwei srawanma ñimguen isuy chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Inchen møikkøben chigøben køben kwamønrrab inchibiibe pinab pinamig nebunrrun cha. Trune tru kwawa pinabiibe nui øsig kømigwan esegawa tøgagønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Inchawei nabe trendamønrrun: Tru arrub yembe pailø kan camayutø kib warøben, kane pera yaig køben, kane kørrømarig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Katø ishumburmera pailø kitsøsrugu kichib køben, kanune srua iben, kane kørrømarig kønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Møguelø pailø trau warøben, kane pera yaig køben, kanune kørrømarig kønrrun— cha, trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Inchen iigwan mørabe, nømbe payibelø køn: —¿Señor, øyeebe churre purainrrerah?— cha. Inchene Jesúsbe trencha løtabig køn: —Kwaig chu tsubene, truyu kallinasumera tulundzunønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chu urastøgucha Tiusba wamindamigwane elachib kullaaramø melamig truba palabig køn chinrrab, Jesúsbe nui kusrenanøb pera uniilan ‘øyeeg lataitøwein køn’ cha, kemesra waminchib ");
INSERT INTO gum_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","trenchibig køn: —Kan puebloyu kan juez wabig køn cha, truibe: “Tiuswan kørmøwei, ni møguelan naimburab kømøbashtømab” isubig. ");
INSERT INTO gum_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Inchen tru puebloyutøwei kan piudagucha wabig køn cha. Truibe tru juezweimay trenchinrrab arruptø arrubig: “Nan kalø marøbigwan maig maramigwan tamara kettra” chib. ");
INSERT INTO gum_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Inchen tru juezbe kan maya yana køsrøngatig ke mørøg kømui inchibig køn cha. Inchabe yandø truibe treeg isubig køn cha: “Nabe Tiuswan kørmøwei, ni møguelan naimburab kømøbashtømab isubig kuagucha, ");
INSERT INTO gum_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","i piudabe ke menrra pub llirab, ke pesrøølig inchib ke katø katø arrumønrrai, ka tamara tranrrab isur” tan— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Inchabe Señorbe trenchibig køn: —Tru sølgandø tabigwan marmø juezken, nø øyeeg taigwan møray cha. ");
INSERT INTO gum_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Inchawei Tiusbe nuindø kønrrai lawa wesruilø yem kwaløm nun miabelane, nømuyasig sølgandø maig kønrrabigwan marøb purømisrmønrraitarru? cha. Kabe ¿muniitø, muniitø melønrrai inchautah? cha. ");
INSERT INTO gum_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pøs nabe trendamønrrun cha: Tiusbe sølgandø maig kønrrabigwan petø tamara kettrun cha. Inchen treeg køben, na, tru Møg Misra Arrubig yu piraumay katø arrub kwalømbe ¿isubigwan nainuutø tøga misag pirau katøgucha wetørranrrautah?— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Møiløgøben nømdø sølgandiig tabelø kermab isua, katøganelane kaashibelaimburab Jesúsbe ‘øyeeg lataitøwein køn’ chib kemesra waminchib trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Pailø møguelø Tiuswei yau Tiusba waminchab ambubelø køn cha, kane fariseo køben, kane romasreelayasig an utabig. ");
INSERT INTO gum_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tru fariseobe pasramisra, øyah chib Tiusba waminchibig køn cha: “Nai Tius, ungwa, ungwa chib, kaguen nabe kanelø lata niliig kømøwei, kalø marøptiig søl marmíig kømøwei, itøluløptiig kømøwei, ni i an utabig lataig kømøwein kur cha. ");
INSERT INTO gum_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nabe truneyu pa kwaløm ayunab, na chi tøgagúigugurri diezmørig kan kan tranøb inchibig kur” chib. ");
INSERT INTO gum_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Trune tru an utabiibe wendausrøndø pasramisra, ni nui kabmeranguen srømbalaneb neeshig kømui inchib, nui pechondø kurrøb, trenchibig køn cha: “Tius, nan lastima ashcha chib. Nabe kaig marøbig kur” cha. ");
INSERT INTO gum_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Inchawei nabe trendamønrrun chibig køn: Tru an utabiibe nui yamay katø ippe, Tiusba chi kaig kømíig lataig Tius tabig kørrømarig yan cha. Trune fariseobe treeg kømø yan cha. Kaguen møikkøben nøasiitø ‘nuig kurmab’ isubigwane ka kørig martrun cha. Inchen nøasiitø ‘nuig kurmab’ isumíigwane ‘i møøbe si, nuig køn’ taig kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ureezheelan chigucha Jesúsweimay srua amrrubelø køn, nø estsartrai. Inchen nui kusrenanøb pera uniilø trunun ashabe, srua amrrubelan namøben, ");
INSERT INTO gum_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","trune Jesúsbe ureemerane nuimay wama, trenchibig køn: —Ureemerane merømø, naimay ka amrrubasay cha. Kaguende Tius nø ashib karub waibe nøm latailaiwein køn cha. ");
INSERT INTO gum_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Inchawei nabe ñimun cierton trendamønrrun chibig køn: Møikkøben Tius nø ashib karub wainuguigwan kan unø lataitøwei utaptinchimíibe managuen truyube kebinrraamøn— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kan møikkøsrøn chi maramigwan nø ashibiibe Jesúswan trencha payibig køn: —Kusrennøbig tabig, ¿managatig øsig kømigwan Tius tranig tøgagønrrappe, nabe chi maramerah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Inchen Jesúsbe trenchibig køn: —¿Chindimba nane tabig cha wamøgu? cha. Tabiibe kandø køben, truibe Tiustø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tius maig maramigwan martrai pønsrailane ñibe yandø ashibig køn cha: “Itølulmøwei, kweechimøwei, nilømøwei, katøganelaimburab isa waminchimøwei, ñui usri møskawan maig købash inchimø, tab indamig køn” tailan.— ");
INSERT INTO gum_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Inchen tru møøbe: —Nabe iilane kerriguh matsinø-unøgurri marøbig kur— chiben, ");
INSERT INTO gum_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús iigwan mørabe trenchibig køn: —Katøgucha kan chigøsrøndø palan cha. Ñui chi tøgagúigwan kerrigu yana, waachameran pirishi cha. Treeg marabe, srømbalasrømbe chigurrimbunø tøgagønrrabguen cha. Trugurrimbe arrua, nai mendig amø— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Inchen tru møøbe iigwan mørabe, truba isui inchibig køn, kaguen truba puaig kua. ");
INSERT INTO gum_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Inchen Jesúsbe nun ashabe, trenchibig køn: —¡Tius nø ashib karub wainug puarmera kebambamibe purø murig køn! cha. ");
INSERT INTO gum_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kan camelloguen tsusain kal trabyu illmø larrayamdiig køben, kan puaibe Tius nø ashib karub waisrø kebinrrab kaimanrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Inchen mørøbeløbe trenchibelø køn: —Trube, treeg købene, ¿kaigyugurrimbe mu kui wesraig kønrrautah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Inchen Jesúsbe løtappe: —Møguelø martrab kaimaigwane Tiusbe sí, martrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Inchen Pedrobe trenchibig køn: —Au, nambe namui chi tøgagúilan elacha, ñui mendig amrruig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Inchen Jesúsbe trenchibig køn: —Pøs nabe ñimun cierton trendamønrrun cha: Møikkøben nui yawan, srawan, nunelan, møskalan, uregwan Tius nø ashib karub waigweimburabigwan isua elachibiibe, ");
INSERT INTO gum_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","møi yu piraube øyeetøguen kømø, mas purø nu uta tøgagua, kansrømbe managatig øsig kømigwan utønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús nui doce kusrenanøb pera uniilan nøørø wamabe, trenchibig køn: —Au, nambe Jerusalénmay nebambub amber cha. Trusrømbe tru Møg Misra Arrubigweimburab Tius maig karuigwan eshkabig pøriibe kerrigu maig taig punrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kaguende nune judíos kømeelan tranen, indzaashib, tsalø wamab, illimbi tuchaashib, ");
INSERT INTO gum_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ichaguchib srua kua, yandø kwetchun cha. Inchendø pøn kwalømyube katø øsiiranrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Inchen nømbe trunun mandø kuinguen mørmøwei, ni wamindigwan chi tainguen mørmøwei inchibelø køn. Kaguende iig wamindiiløbe nømune sørin pasrøben, nømbe ni chiwan tainguen mørmeelø køn. ");
INSERT INTO gum_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús yandø Jericó ciuda pub lutau ibene, may menda kan kabgaig ‘anzhig kettra’ chib, miab wawabe, ");
INSERT INTO gum_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","misag truba nu puraambi mørabe, kabgaibe: —¿Chindah?— cha, payene: ");
INSERT INTO gum_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Nazaretsrø Jesús pureb yan— cha, trenchiptinchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Inchen kabgaibe trenchib trashibig køn: —¡Jesús, merrabsrø Davidwei Nusrkai, nan lastima ashcha!— chib. ");
INSERT INTO gum_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Inchen tru merrab ambubeløbe niløtø wanrrai namingucha, nøbe trenchib mas mur trashibig køn: —¡Merrabsrø Davidwei nusrkai, nan lastima ashcha!— chib. ");
INSERT INTO gum_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Inchen Jesúsbe pasramisra, srua amrrungaruben, nuim pulu pubene, trencha payibig køn: ");
INSERT INTO gum_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Na ñuyasig chi maramig paløta?— cha. Inchen kabgaibe trencha løtabig køn: —Señor, nai kabmera ashibig misrimbe køtan— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Inchen Jesúsbe nun trenchibig køn: —¡Ashibig misr! cha. Ñui isubigwan nainug pasriitøga tabig kørrømisran— cha. ");
INSERT INTO gum_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Inchen tru urastø kabgaibe ashibig misra, Jesúswei mendig Tiuswan truba tabig waminchib iben, mayeelø iigwan ashibeløbe nømgucha Tiuswan tabig waminchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Incha Jesús Jericó ciudayu kebya, truyu pureb ibene, ");
INSERT INTO gum_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kan truba pua møg romasreelayasig an utabelan nø asha karubig, kan Zaqueo taig, ");
INSERT INTO gum_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesúswan truba ashig kui inchibig wabig køn. Inchendø menrra misag køben ashchab kaimabig køn, Zaqueobe lamøtø møg kua. ");
INSERT INTO gum_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Incha merrab lula, Jesús purayam puluwan, kan sicomoro tusryu ashchab nebiben, ");
INSERT INTO gum_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesúsbe tru puluwan puraya, palabunø neeshabe, trenchibig køn: —Zaqueo, mallatø pinaamø cha. Kaguen møi ñui yau kørrømisram kønrrab køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Inchen Zaqueobe mallatø pinaarrua, Jesúswan truba tab kui inchib wamab utabig køn. ");
INSERT INTO gum_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Inchen iigwan ashabe, mayeeløba Jesúswan trenchib nømdø namig mullib mendabelø køn: —Kan kaig marøbigwei yau kørrømisrtrab yan— chib. ");
INSERT INTO gum_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Inchen Zaqueobe pasramisra, Señorwan trenchibig køn: —Au Señor, waachameran na kerrigu chi tøgagúigwan tøbøtagwan trannrrab cha. Inchippa na møigwan køben isatø menrra utab, na kalø marig købene, trube, katøburø pibmaybatø menrra tranamønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Inchen Jesúsbe nun trenchibig køn: —Kaigyugurri wesrailø kømig møi yu yau puin køn cha. Kaguende i møkkucha Abrahamwei misagugurrindøwein kal-laweig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kaguende tru Møg Misra Arrubiibe trubigwan lanrrappa, kaigyugurri wesranrrappa arrig køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús øyeeg tailan misaamera mørøb pønrramne, nøbe ‘øyeeg lataitøwein køn’ cha, kemesra waminchibig køn. Kaguen nøbe Jerusalén pub lutau iben, nømbe Tius nø ashib karub wainuguiibe møi møi punrraitamab isubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Inchen treekkurri Jesúsbe trenchibig køn: —Kan møg, truba tab misagugurri arrubig, yabsrø katøgan peg pirausrø ‘rey kønrrai mara kørrømarig kønrrab ibig køn’ cha, katø nuim piraumaytøwei attraptø. ");
INSERT INTO gum_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","’Incha inrraptø nui karuindiig melabelan diezelan wama, kanun kanun kan kan an truba nuweyelø tranabe, trenchibig køn cha: “I anwan nemisrøb larrøbitchai marøb kønrrigay” cha, na arrumnegatiibe. ");
INSERT INTO gum_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Inchendø nuim pirau misaamerabe tsaleelø kua, møilan køsrøn nui wendautø amrrai wesrawa ørøbelø køn cha, øyah chinrrigay chib: “Nambe i møwane namui rey kønrraimbe palain kømer” cha. ");
INSERT INTO gum_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Inchen treeg indingucha, nøbe Rey kønrrai mara kørrømarig, katøle nuimbiraumay arruabe, tru nui karuindiig melabelan tru nø an traniilan, nuimay amrrungarubig køn cha, tru anwan kan kan utabelø mayambatø mariitashchab ashchab. ");
INSERT INTO gum_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Inchen srøsriig arruabe trendan cha: “Nai ashib karubig, ñi nan kan anzhig traniitøgatø møimbe diez nemarar” cha. ");
INSERT INTO gum_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Inchen reybe: “Øyambesin tan cha, nai karuindiig megabig tabig. Ñi lamøtiiguma ñi øya søl mariibe, møimbe pueblomera diezwan karubig kønrrai martrumøn” cha, trendan cha. ");
INSERT INTO gum_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Inchen katøgan karuindiig megabig arrubiibe trenchibig køn cha: “Nai rey, ñi nan kan anzhig traniitøgatø møimbe trattrøgatø nemarar” cha. ");
INSERT INTO gum_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Inchen trunungucha trenchibig køn cha: “Trube, ñigucha trattrø pueblomeran karubig kønrrabguen” cha. ");
INSERT INTO gum_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Inchen katøgan karuindiig megabig arruppe, trenchibig køn cha: “Ñi, nai ashib karubig, ñiguen ash cha, ñui anwane kan pañeluyu pula ka esegawa tøgagur cha, ");
INSERT INTO gum_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","pøs ñun kørig køben, kaguende ñibe chiwandøgucha chi chippe kandø chibig kuimba; pøs ñi pønsrømubendø, ñi merrarrab; ñibe ñiashib ellgwaig kømubendø, ellmarigwan tulishib, treeg inchibig kuimba.” ");
INSERT INTO gum_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Inchen nøbe trenchibig køn cha: “Karuindiig megabig larrø kaig, pøs ñi nan øyeeg køn chib, treeg køn taig kuig købene, trube, ñui trig maig wamindiitøgatøwei møimbe ñun trubalawei nebunrrai maig kønrrabigwan marar cha. Nabe chiwandøgucha chi chippe kandø chibig kui ashib, na pønsrømubendø, na merrarrab; na ellgwaig kømubendø, tulishib inchibig kui ashabe, ");
INSERT INTO gum_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","trube, maindi nai anwan bancoyumay srua ya, pasrambala tan cha, na katøle arrua, nai anwan nemisrigwanbañau utabsrubrainrrun” cha. ");
INSERT INTO gum_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Incha truyu purrabelan trenchibig køn cha: “Nune anwan kerrawa, tru diez tøgaigwan tranø” cha. ");
INSERT INTO gum_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Inchen nømbe trendan cha: “Namui ashib karubig, truibe diezken tøgagøn” cha. ");
INSERT INTO gum_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Inchen tru an tranøbiibe trencha løtabig køn cha: “Nabe trendamønrrun cha: Tøgaigwane masken tranen, trune chigaigwane nui lamøtiig tøgagúigwanguen kerranrrun tan cha. ");
INSERT INTO gum_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Incha tru nan tsaleelø nømui rey kømønrrai inchibelane yu nai merrab srua amrrua, kweetsay” tan— cha, trenchibig køn Jesúsbe. ");
INSERT INTO gum_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iigwan chab waminchabe, Jesúsbe Jerusalénmay ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Incha yandø Betfagéba, Betaniaba pueblomerayu tru Olivos Tun taisrø, trusrø pub ambabe, nøbe nui kusrenanøb pera uniilø pailan ");
INSERT INTO gum_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","trenchib karua ørøbig køn: —Ø pinrrøguesrø yamera tsitsø pønrrabsrømay ambay cha. Truyu puabe, kan burro muguen itøguaniimíig litsig wetørranrrabguen cha. Picha, yumay srua amrrunrrigay cha. ");
INSERT INTO gum_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Inchippa møikkøben: “¿Chinchab pichigue?” cha payene: “Señor palai indan” chinrrigay— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Inchen nui kusrenanøb pera uniiløbe amba, Jesús nømun maig taig treeg wetørrawa, ");
INSERT INTO gum_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","burron pichib pønrrøbenba, puarbe trenchibelø køn: —¿Chinchab pichigue?— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Inchen nømbe: —Señor palai indan— cha løtabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Incha Jesúsweimay srua amba, nømui kewagúilan burro-unøyu kaya, itøguanøsrøben, ");
INSERT INTO gum_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús pureb ibene, misaamerabe nømui kewagúilan maywan kayibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Incha yandø Olivos Tun lendesrø misrøb ambuppe, mayeelø tru nu søtø nui mendig amøñibeløbe tru maramburab mariilan kerrigu asikkurri Tiuswan truba tabig wamab kasraarab trashib mendappe, trenchibelø køn: ");
INSERT INTO gum_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—¡Señor Tiuswei munchiyu Rey arrubiibe mayanguen tab kuig køn! cha. ¡Srømbalasrømbe mayanguen tab kuinrrun! chib. ¡Srømbalasrømbe tørguegwalmabig kuinrrun!— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Inchen mø fariseosmera køsrøn, tru misag utu pønrrabeløbe trenchibelø køn: —Kusrennøbig, ñui mendig amøñibelan niløtø pønrrønrrai namø— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Inchen Jesúsbe trenchibig køn: —Nabe trendamønrrun cha: Iilø chi chimø, niløtø pønrrøbene, sruumeraguen trashinrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Incha Jesús Jerusalén pulusrø pua, ciudawan ashabe, trunun isua, kishib ");
INSERT INTO gum_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","trenchibig køn: —¡Chi isumgaig tab købig tøgagømigwan kan møin kwalømdøguen ñigucha nebua isuimbe køn! cha. Inchendø truigwane møimbe ñi ashmønrrai sørin pasran cha. ");
INSERT INTO gum_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kaguende larrø kaig kwalømmera ñun puben, ñui ashig kømui inchibeløbe ñuim pøtøgatan chamba mara, ambumay imay ñun kata kønøbashmønrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Incha ñune pirau pøtiicha, tru ñui umbu warab misaameran kweechen, ni kan sruutøguen katøgan srug palabe kørrømisrmønrrun chibig køn, kaguen ñi, Jerusalénbe, Tius kaigyugurri wesranrrab arrub uras ke ka arrua uni lataitø indikkurri.— ");
INSERT INTO gum_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Incha Jesúsbe Tiuswei yau kebya, truyu yanøb warabelan wambig webetab mendabe, ");
INSERT INTO gum_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nømun trenchibig køn: —Tiuswei wamwan pørigube trenchibig køn cha: “Nai yabe Tiuswan wamindi ya køn” cha. Trune ñimbe nileelø warain trab marin køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Incha Jesúsbe kwalømmørig Tiuswei yau kusrenanøbig køn. Inchen tru sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløba, katø maya misagwan karubeløbabe Jesúswan mandø incha kwetsamdiig køtashchab labendø, ");
INSERT INTO gum_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","chinchaguen martrab kaimabelø køn, kaguende misaabe mayeeløba Jesús wamindigwane purø tab møren. ");
INSERT INTO gum_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kan kwaløm Jesús misaameran Tiuswei yau kusrenanøb, tabig srø wamwan eshkab pasrøbene, sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløba, misagwan karubelø kølli misaameraba kemallabe, ");
INSERT INTO gum_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nune trenchibelø køn: —Namun eshkarra cha: ¿Ñi mariilane mu karua pasriitøgarre margu? cha. ¿Ñi øyeeg maramigwane mu karua pashta?— cha. ");
INSERT INTO gum_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Inchene Jesúsbe løtappe, trenchibig køn: —Nagucha ñimun kan chigøsrøn payrrab cha. Løtørray pøs cha. ");
INSERT INTO gum_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Misagwan Juan piu umbu ulsrøb uniibe srømbalasrøngurrin kuig kø chindah, kabe møguelainukkurrin kuig kø chindah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Inchen nømbe nømasiyaitø trenchib payiyab mendabelø køn: “Nam: ‘Srømbalasrøngurrin kuig køn’ chibene, nøbe namune trenchinrrun cha: ‘¿Chindimba nune køremøgue?’ cha. ");
INSERT INTO gum_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kabe: ‘Møguelainukkurrin kuig køn’ chibene, misaamerabe mayeeløba namune sruutøga petønrrun cha. Kaguen misaabe Juanwane Tius maig karuigwan eshkabig kui ke yandø tsabø asha tøgar køn” cha. ");
INSERT INTO gum_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Incha nømbe trencha løtabelø køn: —Maig kuindøbeh— cha. ");
INSERT INTO gum_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Inchen Jesúsbe trenchibig køn: —Trube, nagucha eshkamumønrrun cha, iilan na mu karuitøga marigwan.— ");
INSERT INTO gum_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Incha Jesúsbe misaameran pølbasra waminchib mendappe ‘øyeeg lataitøwein køn’ chib kemesra iigwan waminchibig køn: —Kan møg uvas tra mara, trugurrimbe nui misrigwan pirishinrraptø pirøwan katøganelan kwallchai tranabe, yabsrømay truba yana yan cha. ");
INSERT INTO gum_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Incha yandø lurramig puben, nui kan karuindiig megabigwan tru kwallchab utabelan tru kanbalø lurrigwan nøm trannrai karua ørøbig køn. Inchen treeg øringucha, nømbe nun kurragucha, chiguchagaig ørøbelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Inchen puaibe katøgan karuindiig megabigwan øren, truigwangucha tsalø wama, kurragucha, chiguchagaig inrrai øran chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Inchen puaibe pønmay kønrrabyu katøgan øren, tru kwallibeløbe trunungucha kørriincha, truyugurri wambig weguchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Inchen yandø tru pirø puaibe trendan cha: “¿Chindamer? cha. Nai undaaraig nusrkawan ørtrab tan cha. Nune inchippa chinchimubgun” cha. ");
INSERT INTO gum_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Inchen tru kwallibelø nun ashabe, nømdø trenchibelø køn cha: “Pirøwan ketig utønrrabiibe iigwein køn cha. Pirøwan namui martrab nune kweechigun” tan cha. ");
INSERT INTO gum_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Inchabe uvas traugurri wegucha, nune kweechibelø køn cha. ’¿Trube tru uvas tra puaibe tru kwallibelane chi martrerah? cha. ");
INSERT INTO gum_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Arrua, tru kwallibelane kweecha, tru uvas trawane katøganelan tranrrun— chibig køn Jesúsbe. Inchene misaamera iigwan mørabe: —¡Managuen kan trengatikkucha puraimuimbe!— chibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Inchene Jesúsbe nømun ashabe trenchibig køn: —Trube, treeg købene, ¿Tiuswei wamwan pørigu øyah chibiibe mandø cha trendah? cha: “Tru ya marøbelø kaasig sruube katsiisrø pølbasra wayamig mas purø tab srukken misrin køn” chippe. ");
INSERT INTO gum_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Inchawei møikkøben tru srug pala peñippe, pitis misrtrun cha. Inchen tru srug muim pala køben peñippe, nune usrø tuindø martrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Inchen tru uras tru Moisés pørigwan kusrenanøbeløba, sacerdotesmeran karubeløba tru ‘øyeeg lataitøwein køn’ cha waminchippe nømun kemesra wamindi møra, Jesúswan ¡katø! møi møi kemørtrab inchendø, misaameran kørig kui inchibelø køn. ");
INSERT INTO gum_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Inchabe kan møilan køsrøn larønrrai ørøbelø køn, sølgandø amøñibelø misrøb, Jesús chigøben wamindigu kebenøsrka trumay kubenadurwei tasku purørtrab, nui mu mandamgaig mariitøga nø asha martrai. ");
INSERT INTO gum_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Inchabe nømbe payibelø køn: —Kusrennøbig, ñibe søl waminchib, søl kusrenanøb indi nambe ashibelø ker cha. Ñibe misaameran mumera køtasha asha kusrenmø, Tiuswei maywan ñibe maig kusrenanamigwan cierton sølwan kusrenanøbig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Trube, ¿tru Roma maya misagwan karub wabigwan nam an pagaramig merig køh, kabe merømuig køh, chinderah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Inchen Jesúsbe nømune ka kaig isuatørre inchib pønrrai ashabe, trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Kan anwan eshkarra cha. ¿I anyu maløba, i munchi pøriibabe muin køh?— cha. Inchen nømbe trencha løtabelø køn: —Tru Césarwein køn— cha. ");
INSERT INTO gum_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Inchen Jesúsbe trenchiptinchibig køn: —Césarwein købene, Césarwan tranay cha. Inchen Tiuswein købene, Tiuswan tranay— cha. ");
INSERT INTO gum_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Inchen misagwei malau nø chi tailøyu chiyugucha kebenøsrkønrrab kaimabelø køn. Tru nø løtiilan nømguen kwaara asha, niløtø kørrømisrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Inchen møiløgøsrøn saduceosmera Jesúswan ashchab amrrubelø køn. Tru saduceosmerabe kwailøbe katøbe øsiiramønrrun chibelø kua, Jesúswane øyeeg chib payibelø køn: ");
INSERT INTO gum_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Kusrennøbig, Moisésbe namune øyeeg pøra kørrømarig køn cha: “Møigwei nuneg køben kwawa, srawan urekkaig kørrømarene, trube tru nuneebe piudaba kasharawa, nuneg kwabigweimburab ureg tøgagømig køn” chibig. ");
INSERT INTO gum_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","’Trube, siete nunelø købig køn cha. Indiibe srøsriibe kasharawa, chi urekkaig kwaben, ");
INSERT INTO gum_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","tru wendauikkucha tru piudaba kasharawa, katø chi urekkaitøwei kwaben, ");
INSERT INTO gum_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","katø tru pøn kønrrabyuigwangucha treetøwei nebuben, yandø søteeløba tru ishuuba kasharawa, møikkucha urekkar kwabelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Inchen yandø srabebe tru ishukkucha kwan cha. ");
INSERT INTO gum_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pøs treeg købene, trube, tru kwabelø katø øsiirabene, ¿nøbe møigwei srain kønrrerah? cha, payibelø køn, tru sieteeløba nune srai mara tøgagúig købene.— ");
INSERT INTO gum_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Inchen Jesúsbe trencha løtabig køn: —Møi yu piraube kasharab, katø kasharanøb inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Trune tru kansrø kanmaytø kebamrrai tøgagúinabeløbe trunun nebub, katø kwabelai utugurri øsiiramigwan nebub incha, truiløbe kasharanrrab kømøwei, kasharanøb kønrrabelø kømøwein køn cha, ");
INSERT INTO gum_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","kaguende nømbe katøle kwanrrabelø kømøwa. Pøs nømbe ángelesmera latailø, katø Tiuswei ureemera køn cha, kwabelai utugurri øsiirab ureg kua. ");
INSERT INTO gum_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Inchen tru tusr-unø naaraigu maig purayaigwan pøra pasriguma, tru kwabeløbe katø øsiiranrrab kuigwan Moisésken kenamarig køn, tru Señorwan øyah cha wamappe: “Tiusbe Abrahamwei Tius, Isaacwei Tius, Jacobwei Tius køn” cha. ");
INSERT INTO gum_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pøs Tiusbe kwailai Tius kømøtø, øsiguelai Tius køn cha. Inchawei mayeeløba nuimbe øsigueløtø køn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Inchen møiløgøsrøn tru Moisés pørigwan kusrenanøbeløbe trenchibelø køn: —Kusrennøbig, ñibe sølwein tan— cha. ");
INSERT INTO gum_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Trugurrimbe yandø mas payrrab inchimeelø køn. ");
INSERT INTO gum_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesúsbe trencha payibig køn: —¿Misaabe chincha Cristone Davidwei misagugurri arrub nusrkain køn tamig kønrrab køh? cha. ");
INSERT INTO gum_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kaguende Davidbe nøtøweinguen Salmoswan pørigu trenchibig køn cha: “Señor Tiusbe tru nai Señorwane trendan cha: ");
INSERT INTO gum_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‘Nai kusrmaygatø wamisr cha, ñui ashig kømui inchibelan ñi nebuna wamig na pønsramnegatig.’ ” ");
INSERT INTO gum_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Cristone Davidbe: “Señor” cha, øyeeg wamubene, trube, ¿mandøgurri Cristobe Davidwei nusrkain kønrrab køh?— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maya misaamera mørøb pønrrøben, Jesúsbe nui kusrenanøb pera uniilan trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Tru Moisés pørigwan kusrenanøbelan ashiptø kuy cha. Kaguen nømbe kørrabelø kewa llirab amønamig chullelø, penab yanøb indiisrø maig købash kømø, truba tab wamønrrai indamigwan chullelø køn cha. Katø judíosmera tulundzuni yamerayube purø tab purramdønug purrag kui indamba, katø lincha tabig mabyugucha nørreelø purrainug purø tabigu purrag kui indamba inchibelø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Katø piudasmeran nømui yameran kerrawabe, tabelø misrøb ke ka yandø truba yana Tiusba waminchibelø køn cha. Truiløbe møra melamig mas nuigwan utønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tiuswei yau an kebusrinug, puarmera an kebusrøb køben Jesúsbe ashib wabig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Inchen katø kan waacha piudagucha, øskø an pagatøtøh kebusri ashabe, ");
INSERT INTO gum_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesúsbe trenchibig køn: —Nabe ñimun cierton trendamønrrun cha: I waacha piudabe mayeelø lataitøguen kømø, menrraguen tranan cha. ");
INSERT INTO gum_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kaguen mayeeløba nømbe undaigwandø tranen, trune nøbe waacha køptø, tru nui øsig tsumig tøgagúigwanguen kerrigu tranan— cha. ");
INSERT INTO gum_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Møiløgøsrøn Tiuswei yau tru tab sruuzheelanba, chigøben tabzheelø Tiusweyasig tranig pønrrabelanba, truilan waminchib køben, Jesúsbe trenchibig køn: ");
INSERT INTO gum_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Iig ñim ashib kuigwan pinisam kwaløm attrun cha. Yube ni kan srukken katøgan srug palabe kørrømisrmønrrun cha. Kerriguba pøtiitsig kønrrun— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Inchene nømbe trencha payibelø køn: —Kusrennøbig, ¿øyeebe mana purainrrerah? cha. ¿Truilø ke yandø treeg purainrrabigwan asamibe chitø kenamisrtrerah?— cha. ");
INSERT INTO gum_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Inchen Jesúsbe trenchibig køn: —Ashiptø kuy cha, ñimun peløsrkønrrain kømø. Kaguende møiløgøben nai munchiyu truba nu amrrua trenchinrrun cha: “Nabe truig kur” chib, katø: “Møi ya srabe kwaløm punrrabiibe lutau køn” chib amrrubene, truilan mendig ammøtay, chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Incha ‘misaamera katøgan peesrø misaameraba purø trømbøig kørig kømdiig kwayab kweetsiyab køn’ chib; ‘misaamera tru piraueløtøwei trømbøig namig kurra kwayab køn’ taig ñim wamindi mørabe, ñimbe kwarmøtay cha. Kaguende iilømerrigwei trendø treeg purainrrabigwein køn cha. Inchendø katøgucha patsamibe ke møi møin kønrraamøn— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Inchabe katø trenchibig køn: —Peg misaamerabe katøgan peg misaameraba kwayaben, katø rey karumburab ashib karuim piraueløbe katøgan reywei misaameraba kwayanrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Trune pirø purø trømbøig kønabelø arrumba, chu pirausrøn køben parø amrrumba, kaig kwanrrømera amrrumba inchen, kørig kømdiig chigøben arrumba, katø srømbalasrøngurrimbe chigøben truba nørreelø kenamisrøb inchun cha. ");
INSERT INTO gum_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Inchendø øyeelø arrumøwatø, ñimune kemørøb, larrø kaig marøb inchun cha. Katø ñimune judíosmera tulundzuni yamerayumay payib sruagønrrab srua ambamba, kailan keeri yau keera pønsramba inchun cha. Incha nagurrindø reymerai merrab køben, karubelai merrab køben srua amben, ");
INSERT INTO gum_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","naimburab ñim wamindamig kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ñimui manrrøyube øyeegwan isua pønrrønrrigay chibig køn, mandø løtamigwan ke kanmaytø isua tøga pønrrønrrab inchimønrrab. ");
INSERT INTO gum_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kaguen ñimun ashig kømui inchibelø mayeelø, nøm manchaguen løtønrrain kømøwei, nøm ñimun purab waminchib kasrønrrain kømøwei, nabe ñimun muguen øyeeg waminchimuinrrunig wamindamig tranamønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Inchen ñimui møskalø køben, nunelø køben, ñimui ñimmisaamera køben, ñimui trendø linchibelø køben, ñimun ashig kømui inchibelan tranen, ñimun møilane kwetchun cha. ");
INSERT INTO gum_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Maya misaabe ñimune nagurrindø tsalø indiilø kønrrabguen cha. ");
INSERT INTO gum_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Inchendø ñimui turyu kan pusruuzhikken chi indiimíig kønrrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ñim chi arringucha melabig meløwabe, ñimasiitøwei ñimui møsiimerane øsiguig wesranrrabguen cha trenchibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Jerusalén ciudawan pøtøburab suldautø tulsruig kui ashabe, petø pinisaig kønrraitamab isua, ");
INSERT INTO gum_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Judea pirau warabeløbe tunmerasrømay wegørra lulay. Inchen ciudayu warabeløbe truyugurri webambamig køn. Inchen ciudayugurri yabsrø warabeløbe ciudayumay katø ammøtay. ");
INSERT INTO gum_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kaguende trømbøig møra melønrrai maram kwalømmera kønrrun, Tiuswei wamwan pørigu maig taig kerrigu treeg nebunrrai. ");
INSERT INTO gum_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ishumbur waachamera, tru kwalømmerawan patsø kwanrreelø, kabe muchib ureg tøgarmeraimbe maig kønrrer! chibig køn. Kaguen yu pirau purø isumdiig arruben, katø i misaameraimburab namig købig purø kørig kømdiig attrab køn. ");
INSERT INTO gum_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Møiløbe espadatøga kweetsiilø køben, møiløbe chugøben asiimø pirausrømay kemøra srua ambiilø kønrrun chibig køn. Inchen tru judíos kømeelø Jerusalén ciudawan mindishib itølulrrun, tru nømui treeg maram kwalømmera patsamnegatiitø. ");
INSERT INTO gum_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Inchen chigøben truba nørreelø kenamisrtrun nøsigu køben, pølyu køben, estrellamerayu køben. Inchen pirau misaamera nørrø pønrrabiibe purø trømbøig isui inchun, mar purø trømbøig wanrrab mullib, trømbøig latøgushib kurrøben. ");
INSERT INTO gum_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Katø misaamerabe yu pirau maig purainrrabelan isubiibah kørig købiibatø pesannanrrun, kaguende srømbalasrø purø nørreelø pønrrabelan kønøgøb sruagutsiilø køben. ");
INSERT INTO gum_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Inchen tru Møg Misra Arrubiibe maramburab maramig tøgaig purø nuig tørguegwalmabig wañiyu arruben ashchun, chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Inchawei iilø pureb arrub mendøbene, ølgandø pønrramisra, kurraasay chibig køn. Kaguen yandø ñim kaigyugurri wesruilø kømig lutau kønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Incha katø ‘øyeeg lataitøwein køn’ cha, kemesra trenchibig køn: —Higueranma asay cha, katø mayan tusrmeranba, ");
INSERT INTO gum_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ishiimera weguchib mendøbene, ñimbe pachig kwalømmera arrumig lutau kui asan cha. ");
INSERT INTO gum_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Øyeetøwei ñim iilan purayai ashabe, Tius nø ashib karub pasraibe yandø lutau kuitamab isua kuy cha. ");
INSERT INTO gum_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Pøs nabe ñimun cierton trendamønrrun chibig køn: Møin kwaløm misaamera pinømøwatø, kerriguh purainrrun cha. ");
INSERT INTO gum_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Srømbalaba, pirøbabe patsøben, na wamindiibe ka wamindiitøbe purainrraamøn cha. ");
INSERT INTO gum_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ñimbe ñimdøwei ashiptø kuy cha, ñimui manrrømerayu øyeeløtø netsailø kømønrrab, mamburab mab, mutsiirab, yu pirau øsig waramig chigøben tøgagømigwangøba isub indiilø, tru Señor arrin kwalømbe ñimun kan ilagu kegørrøsrka merrarrab lataig arrindø mørmønrrappe. ");
INSERT INTO gum_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kaguen tru kwalømbe yu pirau muba kuimburab mayeelaim pala treeg attrun chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Inchawei ñimbe ashiptø melay chibig køn, chu uragucha Tiuswan purugurra chib, øyeelø kerrigu pureb arrubigu kullaaramø, mur pønrramig kønrraimba, tru Møg Misra Arrubigwei merrab kemalla, pønrramig kønrraimba.— ");
INSERT INTO gum_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Incha Jesúsbe kwalømmerawane Tiuswei yau kusrenana, yembe Olivos taig tunsrø kørrømisrtrab ibig køn. ");
INSERT INTO gum_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Inchen kwalømmørig ke løtsøzhig, løtsøzhig maya misaamerabe Tiuswei yau nun mørtrab pubelø køn. ");
INSERT INTO gum_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pirri Levaduragaig maig Fiesta, tru Pascua Fiesta taig, lutau køben, ");
INSERT INTO gum_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","sacerdotesmeran karubeløba, tru Moisés pørigwan kusrenanøbeløbabe Jesúswan mandø kweetsamigwan labendø, misagwan køriimatabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Inchen Jesús tru doce kusrenanøb pera uniilai utuig, Judas, tru Iscariote cha wamigwan, Satanásbe kebiben, ");
INSERT INTO gum_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judasbe webya, sacerdotesmeran karubelanba, tru Tiuswei yau ashib pønrrab suldaumeran karubelanba ashchab ya, Jesúswan mandø incha nømui tasku tranamigwan waminchene, ");
INSERT INTO gum_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","nømbe truba kasraarawa, an trannrrab misrøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Inchen nøbe treeg martrab misra, misag tre nu kaaben Jesúswan mandø incha tranamigwan yandø lab mendabig køn. ");
INSERT INTO gum_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yandø Pirri Levaduragaig main kwaløm puben, tru Pascua ubisha-unan kweecha tranamig købig køn. ");
INSERT INTO gum_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Inchen Jesúsbe Pedronba, Juanwanba trencha karua ørøbig køn: —Pascua Fiesta mamigwan manrrab tamartrab ambay— cha. ");
INSERT INTO gum_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Inchen nømbe: —¿Nambe chu tamaramø?— cha payen, ");
INSERT INTO gum_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesúsbe trenchibig køn: —Ñim ciudayu kebambene, kan møg pigøtsø mutaig ñimun katøben, truigwei wendautø amrrigay cha, nø kebyam yaugatig. ");
INSERT INTO gum_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Incha tru ya puaigwane trenchinrrigay chibig køn: “Kusrennøbiibe ñun trendan cha: ¿Nai kusrenanøb pera uniiløba pascua mamigwan mab purram salabe chu køh?” cha. ");
INSERT INTO gum_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Inchen ya puaibe pala pisusrø kan nu sala chab tamarikken ñimun eshkaben, truyu tamartrigay— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Inchen nømbe amba, Jesús maig taig treeg wetørrawa, tru Pascuan tamarøbelø køn. ");
INSERT INTO gum_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Incha yandø ura puben, Jesúsbe nui karua øriiløba mishatsigu wamisrabe, ");
INSERT INTO gum_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","trenchibig køn: —¡Nan øyeeg kaig nebuig megamig pumøwatø, Pascua Fiesta mamigwan ñimba manrrab truba truba isuig køn! cha. ");
INSERT INTO gum_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kaguende ñimun trendamønrrun chibig køn: Tius nø ashib karub wainug katøle ñimba manrrab wamisramnegatig nabe i mamigwane mamumønrrun— cha. ");
INSERT INTO gum_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Incha copan muta Tiuswan ‘mayanguen pay’ chabe, trenchibig køn: —Cha iigwan, larrabelø mutsay cha. ");
INSERT INTO gum_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kaguende ñimun trendamønrrun cha: Møingurrimbunøbe uvas piwane mas muchimumønrrun cha, nai Møskai nø ashib karub waisrø katøyug ñimba mutsam kwalømgatig.— ");
INSERT INTO gum_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Incha pirriwan muta, Tiuswan ‘mayanguen pay’ cha, pirisha, nømun trenchib srørrøbig køn: —Iibe nai asr køn cha, ñimuyasig tranig. Iigwan øyeeg marøppe, nan isunrrab maray— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Inchen chab ma, katø treetøwei copan mutabe, trenchibig køn: —Iibe tru nai anindøga Tius tru misagweyasig srø acuerdon marig, tru copa køn cha, tru ñimuyasig na ani lusig. ");
INSERT INTO gum_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Inchendø asay chibig køn. Nan ashig kømui inchibelan trannrrabigwei tasiibe i mishatsigutøwei nain tasiiba trubalatø trarra wan cha. ");
INSERT INTO gum_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tru Møg Misra Arrubiibe muwan inrrai pasrig, truwan iben, trune ¡tru nun ashig kømui inchibelan trannrrab møg waachaweimbe, kan maig kønrrer!— chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Inchen nømasiyaitø: —¿Treeg martrabiibe mu kerah?— cha payiyab mendabelø køn. ");
INSERT INTO gum_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Inchabe nømbe nømui utu møig mas nuig kønrraptiig kerah cha, payib aleguiyab købelø køn. ");
INSERT INTO gum_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Inchen Jesúsbe kusrub trencha løtabig køn: —Tru reymera judíos kømeeløbe nøm karub tøgagúilane maig købash inchib purran cha. Inchen tru nømun ashib karub purrabelane ‘misaamerayasig tabig marøb møguelø køn’ chib wamiilø køn cha. ");
INSERT INTO gum_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Trune ñimbe øyamay kømøtø kømig køn chibig køn. Masken ñimui utu tru mas nuibe matsinø-unø lataitø misramig køn cha. Inchen tru chi maramigwan nø ashibiibe kan karuig marøb megabig lataitø misramig køn cha. ");
INSERT INTO gum_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pøs trube, øyeeg købene, ¿møig mas nuig kønrrab køh? cha. ¿Mishatsigu manrrab wamisrøbiiteh? Kabe ¿tru mishatsigu mamigwan pønsrøbiiteh? cha. ¿Pøs mishatsigu manrrab wamisrøbig, truig mas nuig kømuitarru? cha. Øyeeg kuingucha, nabe ñimui utube tru mishatsigu manrrai pønsrøb megabig lataig kur chibig køn. ");
INSERT INTO gum_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ñim køn chu uragucha nan elachimø, chigøben murig pub arringucha tre