﻿USE sofia;
DROP TABLE IF EXISTS sofia.guj2017_vpl;
CREATE TABLE guj2017_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guj2017_vpl WRITE;
INSERT INTO guj2017_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","પ્રારંભે ઈશ્વરે આકાશ તથા પૃથ્વી ઉત્પન્ન કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","પૃથ્વી અસ્તવ્યસ્ત તથા ખાલી હતી. પાણી પર અંધારું હતું. ઈશ્વરનો આત્મા પાણી પર ફરતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ઈશ્વરે કહ્યું, “ત્યાં અજવાળું થાઓ” અને અજવાળું થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ઈશ્વરે અજવાળું જોયું કે તે સારું છે. તેમણે અજવાળું તથા અંધારું અલગ કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ઈશ્વરે અજવાળાંને “દિવસ” અને અંધારાને “રાત” કહ્યું. આમ સાંજ થઈ તથા સવાર થઈ, પ્રથમ દિવસ. ");
INSERT INTO guj2017_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ઈશ્વરે કહ્યું, “પાણીની વચ્ચે અંતરિક્ષ થાઓ અને પાણીને પાણીથી અલગ કરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ઈશ્વરે અંતરિક્ષ બનાવ્યું અને અંતરિક્ષની નીચેના પાણીને અંતરિક્ષની ઉપરના પાણીથી અલગ કર્યાં. એ પ્રમાણે થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ઈશ્વરે અંતરિક્ષને “આકાશ” કહ્યું. સાંજ થઈ તથા સવાર થઈ, બીજો દિવસ. ");
INSERT INTO guj2017_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ઈશ્વરે કહ્યું, “આકાશ નીચેનાં પાણી એક જગ્યામાં એકત્ર થાઓ અને કોરી ભૂમિ દેખાઓ.” એ પ્રમાણે થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ઈશ્વરે કોરી જગ્યાને “ભૂમિ” કહી અને એકત્ર થયેલા પાણીને “સમુદ્રો” કહ્યા. તેમણે જોયું કે તે સારું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ઈશ્વરે કહ્યું, “પૃથ્વી પર બીજદાયક શાક તથા ફળવૃક્ષ પોતપોતાની જાત પ્રમાણે, જેનાં બીજ પોતામાં છે તેઓને પૃથ્વી ઉગાવે.” એ પ્રમાણે થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ઘાસ તથા પોતપોતાની જાત પ્રમાણે બીજદાયક શાક, પોતપોતાની જાત પ્રમાણે ફળદાયક વૃક્ષ, જેનાં બીજ પોતામાં છે તેઓને પૃથ્વીએ ઉગાવ્યાં. ઈશ્વરે જોયું કે તે સારું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","સાંજ થઈ તથા સવાર થઈ, ત્રીજો દિવસ. ");
INSERT INTO guj2017_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ઈશ્વરે કહ્યું, “રાત અને દિવસ જુદાં પાડવા સારુ આકાશમાં જ્યોતિઓ થાઓ અને તેઓ ચિહ્નો, ઋતુઓ, દિવસો તથા વર્ષોને અર્થે થાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","પૃથ્વી પર અજવાળું આપવા માટે આકાશના અંતરિક્ષમાં જ્યોતિઓ થાઓ.” એ પ્રમાણે થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ઈશ્વરે જ્યોતિ આપવા માટે બે મોટી પ્રકાશ બનાવી. દિવસ પર અમલ ચલાવનારી એક મોટી પ્રકાશ અને રાત પર અમલ ચલાવનારી તેનાથી નાની એક પ્રકાશ બનાવી. તેમણે તારાઓ પણ બનાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ઈશ્વરે પૃથ્વી પર અજવાળું આપવાને, ");
INSERT INTO guj2017_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","દિવસ અને રાત પર અમલ ચલાવવાને, અને અંધારામાંથી અજવાળાંને જુદાં કરવાને આકાશમાં તેઓને સ્થિર કર્યાં. ઈશ્વરે જોયું કે તે સારું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","સાંજ થઈ તથા સવાર થઈ, ચોથો દિવસ. ");
INSERT INTO guj2017_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ઈશ્વરે કહ્યું, “પાણી પુષ્કળ જીવજંતુઓને ઉપજાવો અને આકાશમાં પક્ષીઓ ઉડો.” ");
INSERT INTO guj2017_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ઈશ્વરે સમુદ્રમાંના મોટા જીવો બનાવ્યા, દરેક પ્રકારનાં જીવજંતુઓ, જે પોતપોતાની જાત પ્રમાણે પાણીએ પુષ્કળ ઉપજાવ્યાં અને પોતપોતાની જાત પ્રમાણે દરેક જાતનાં પક્ષીને ઉત્પન્ન કર્યાં. ઈશ્વરે જોયું કે તે સારું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ઈશ્વરે તેઓને આશીર્વાદ આપતા કહ્યું, “સફળ થાઓ, વધો અને સમુદ્રોમાંના પાણીને ભરપૂર કરો. પૃથ્વી પર પક્ષીઓ વધો.” ");
INSERT INTO guj2017_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","સાંજ થઈ તથા સવાર થઈ, પાંચમો દિવસ. ");
INSERT INTO guj2017_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ઈશ્વરે કહ્યું કે, “પ્રાણીઓને પોતપોતાની જાત પ્રમાણે, એટલે ગ્રામ્યપશુઓ, પેટે ચાલનારાં તથા વનપશુઓ પોતપોતાની જાત પ્રમાણે તેઓને પૃથ્વી ઉપજાવો.” એ પ્રમાણે થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ઈશ્વરે પોતપોતાની જાત પ્રમાણે વનપશુઓને, ગ્રામ્યપશુઓ, અને પૃથ્વી પરનાં બધાં પેટે ચાલનારાંને બનાવ્યાં. તેમણે જોયું કે તે સારું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ઈશ્વરે કહ્યું કે, “આપણે આપણા સ્વરૂપ તથા પ્રતિમા પ્રમાણે માણસને બનાવીએ. તેઓ સમુદ્રનાં માછલાં પર, આકાશના પક્ષીઓ પર, પશુઓ પર, આખી પૃથ્વી પર તથા પૃથ્વી પર પેટે ચાલનારાં પર શાસન કરે.” ");
INSERT INTO guj2017_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ઈશ્વરે પોતાના સ્વરૂપ પ્રમાણે માણસને ઉત્પન્ન કર્યું. તેમણે ઈશ્વરના સ્વરૂપમાં તેને ઉત્પન્ન કર્યું. તેમણે પુરુષ અને સ્ત્રીને ઉત્પન્ન કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ઈશ્વરે તેઓને આશીર્વાદ આપ્યો અને તેઓને કહ્યું કે, “સફળ થાઓ અને વધતાં જાઓ. પૃથ્વીને ભરપૂર કરો અને તેને વશ કરો. સમુદ્રનાં માછલાં પર, આકાશના પક્ષીઓ પર, પૃથ્વી પર ચાલનારાં સઘળાં પ્રાણીઓ પર અમલ ચલાવો.” ");
INSERT INTO guj2017_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ઈશ્વરે કહ્યું કે, “જુઓ, દરેક બીજદાયક શાક જે આખી પૃથ્વી પર છે અને દરેક વૃક્ષ જેમાં વૃક્ષનાં બીજદાયક ફળ છે તેઓને મેં તમને આપ્યાં છે. તેઓ તમારા ખોરાકને સારુ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","“પૃથ્વીનું દરેક પશુ, આકાશમાંનું દરેક પક્ષી, પૃથ્વી પર પેટે ચાલનારું દરેક પ્રાણી જેમાં જીવનનો શ્વાસ છે, તેઓના ખોરાકને સારુ મેં સર્વ લીલોતરી આપી છે.” એ પ્રમાણે થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ઈશ્વરે જે સર્વ ઉત્પન્ન કર્યું તે તેમણે જોયું. તે સર્વોત્તમ હતું. સાંજ થઈ તથા સવાર થઈ, છઠ્ઠો દિવસ. ");
INSERT INTO guj2017_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","આમ આકાશ, પૃથ્વી તથા તેમાનાં સર્વ સેનાઓનું સર્જન પૂર્ણ થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ઈશ્વરે પોતાનું જે કામ હતું તે પૂર્ણ કર્યું અને પોતાનાં કરેલાં સર્વ કામોથી પરવારીને સાતમા દિવસે આરામ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ઈશ્વરે સાતમા દિવસને આશીર્વાદ આપ્યો અને તેને પવિત્ર ઠરાવ્યો, કેમ કે તેમણે જે સર્વ ઉત્પન્ન કર્યું તે સઘળાં કામ પછી તે દિવસે તેમણે આરામ લીધો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","આ આકાશ તથા પૃથ્વીના સર્જન સંબંધિત વૃત્તાંત છે; જયારે યહોવાહ ઈશ્વરે પૃથ્વી તથા આકાશ ઉત્પન્ન કર્યાં, ");
INSERT INTO guj2017_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ત્યારે ખેતરની કોઈપણ વનસ્પતિ હજુ પૃથ્વીમાં ઊગી ન હતી અને ખેતરમાં અનાજ ઊગ્યું ન હતું, કેમ કે યહોવાહ ઈશ્વરે પૃથ્વી પર વરસાદ વરસાવ્યો નહોતો અને જમીનને ખેડવા માટે કોઈ માણસ ન હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","પણ પૃથ્વી પર ઝરણું પડ્યું અને જમીનની આખી સપાટી ભીંજાઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","યહોવાહ ઈશ્વરે ભૂમિમાંથી માટીનું માણસ બનાવ્યું, તેના નસકોરામાં જીવનનો શ્વાસ ફૂંક્યો અને માણસ સજીવ થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","યહોવાહ ઈશ્વરે પૂર્વ તરફ એદનમાં એક વાડી બનાવી અને તેમાં તેમણે પોતાના સર્જેલ માણસને મૂક્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","યહોવાહ ઈશ્વરે ભૂમિમાંથી સર્વ પ્રકારનાં વૃક્ષ જે જોવામાં સુંદર તથા ખાવામાં સારાં તેઓને બનાવ્યાં. વળી વાડીની વચમાં જીવનનું વૃક્ષ તથા ભલુંભૂંડું જાણવાનું વૃક્ષ પણ ઉગાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","વાડીને પાણી પાવા સારુ એક નદી એદનમાંથી વહેતી થઈ. ત્યાંથી તેના ભાગ પડ્યા અને ચાર નદીઓ થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","પહેલીનું નામ પીશોન છે; જેનો પ્રવાહ આખા હવીલા દેશને ઘેરે છે, જ્યાં સોનું મળે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","તે દેશનું સોનું સારું છે. ત્યાં મૂલ્યવાન મોતી તથા અકીક પાષાણ પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","બીજી નદીનું નામ ગીહોન છે. જેનો પ્રવાહ આખા કૂશ દેશને ઘેરે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ત્રીજી નદીનું નામ હીદ્દેકેલ છે. તેનો પ્રવાહ આશ્શૂર દેશની પૂર્વ તરફ વહે છે. ચોથી નદીનું નામ ફ્રાત છે. ");
INSERT INTO guj2017_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","યહોવાહ ઈશ્વરે તે માણસને એદનવાડીને ખેડવાને તથા તેની સંભાળ રાખવાને તેમાં રાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","યહોવાહ ઈશ્વરે તેને આજ્ઞા આપી અને કહ્યું, “વાડીના દરેક વૃક્ષનું ફળ ખાવાને તું સ્વતંત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","પણ સારું અને નરસું જાણવાના વૃક્ષનું ફળ તું ખાઈશ નહિ, કેમ કે જે દિવસે તું તે ખાશે, તે જ દિવસે નિશ્ચે તારું મરણ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","પછી યહોવાહ ઈશ્વરે કહ્યું કે, “માણસ એકલો રહે તે સારું નથી. હું તેને માટે યોગ્ય એવી સહાયકારી બનાવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","યહોવાહ ઈશ્વરે ભૂમિમાંથી ખેતરના દરેક પશુને અને આકાશના દરેક પક્ષીને બનાવ્યાં. પછી તેઓને માણસની પાસે લાવ્યા. માણસે દરેક સજીવને જે નામ આપ્યું તે તેનું નામ પડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","તે માણસે સર્વ ગ્રામ્યપશુનાં, આકાશના પક્ષીઓનાં તથા સર્વ વનપશુઓનાં નામ પાડ્યાં, પણ તે માણસ આદમને પોતાના માટે અનુરૂપ એવી યોગ્ય સહાયકારી ન મળી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","યહોવાહ ઈશ્વરે તે માણસને ભર ઊંઘમાં નાખ્યો. તે ઊંઘી ગયો, ત્યારે ઈશ્વરે તેની પાંસળીઓમાંની એક પાંસળી લીધી અને ખાલી પડેલી જગ્યાએ માંસ ભર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","યહોવાહ ઈશ્વરે માણસમાંથી જે પાંસળી લીધી હતી, તેની તેમણે એક સ્ત્રી બનાવી. તેને તે માણસ પાસે લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","તે માણસ બોલી ઊઠ્યો કે, “આ મારા હાડકામાંનું હાડકું અને મારા માંસમાનું માંસ છે. તે ‘નારી’ કહેવાશે, કેમ કે તે નરમાંથી લેવાયેલી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","તેથી માણસ તેનાં માતા અને પિતાને છોડીને, તેની પત્ની સાથે જોડાયેલો રહેશે અને તેઓ એક દેહ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","તે માણસ તથા તેની પત્ની બન્ને વસ્ત્રહીન હતાં, પણ તેને લીધે તેઓ શરમાતાં ન હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","હવે યહોવાહ ઈશ્વરે ઉત્પન્ન કરેલાં સર્વ પ્રાણીઓમાં સાપ સૌથી વધારે ધૂર્ત હતો. તેણે સ્ત્રીને કહ્યું કે, “શું ઈશ્વરે ખરેખર તમને એવું કહ્યું છે કે, ‘વાડીના કોઈપણ વૃક્ષનું ફળ તમારે ન ખાવું?’ ");
INSERT INTO guj2017_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","સ્ત્રીએ સાપને કહ્યું કે, “વાડીના વૃક્ષોનાં ફળ અમે ખાઈ શકીએ છીએ, ");
INSERT INTO guj2017_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","પણ ઈશ્વરે કહેલું છે કે, જે વૃક્ષ વાડીની મધ્યમાં છે તેનું ફળ ‘તમારે ખાવું નહિ કે અડકવું નહિ. જો ખાશો તો તમે મૃત્યુ પામશો.”” ");
INSERT INTO guj2017_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","સાપે સ્ત્રીને કહ્યું કે, “તમે મૃત્યુ નહિ પામો. ");
INSERT INTO guj2017_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","કેમ કે ઈશ્વર જાણે છે કે જે દિવસે તમે તેને ખાશો તે જ દિવસે તમારી આંખો ઉઘડી જશે અને તમે ઈશ્વરો સમાન સારું શું અને નરસું શું છે તે સમજનારાં થશો.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","તે વૃક્ષનું ફળ ખાવામાં સ્વાદિષ્ટ, જોવામાં સુંદર અને તે જ્ઞાન આપવાને ઇચ્છવાજોગ છે, એવું જાણીને સ્ત્રીએ તે ફળ તોડીને ખાધું અને તેની સાથે તેનો પતિ હતો તેને પણ આપ્યું. તેણે પણ ફળ ખાધું. ");
INSERT INTO guj2017_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ત્યારે તેઓ બન્નેની આંખો ઉઘડી ગઈ અને તેઓ સમજ્યા કે અમે વસ્ત્રહીન છીએ. તેથી તેઓએ અંજીરનાં પાંદડાં જોડીને પોતાને માટે આવરણ બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","દિવસના ઠંડા પહોરે વાડીમાં પ્રભુ ઈશ્વરનો ચાલવાનો અવાજ તેઓના સાંભળવામાં આવ્યો, તેથી તે માણસ તથા તેની પત્ની પોતાને પ્રભુ ઈશ્વરના સાનિધ્યથી દૂર રાખવા માટે વાડીના વૃક્ષોની વચમાં સંતાયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","યહોવાહ ઈશ્વરે આદમને હાંક મારી કે, “તું ક્યાં છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","આદમે કહ્યું કે, “મેં વાડીમાં તમારો અવાજ સાંભળ્યો અને હું ગભરાયો. કેમ કે હું વસ્ત્રહીન છું. તેથી હું સંતાઈ ગયો.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ઈશ્વરે કહ્યું, “તને કોણે કહ્યું કે, તું નિવસ્ત્ર છે? જે ફળ ન ખાવાની મેં તને આજ્ઞા આપી હતી, તે ફળ તેં ખાધું છે શું?” ");
INSERT INTO guj2017_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","તે માણસે કહ્યું કે, “મારી સહાયકારી તરીકે જે સ્ત્રી તમે મને આપી હતી તેણે મને ફળ આપ્યું અને મેં ખાધું.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","યહોવાહ ઈશ્વરે તે સ્ત્રીને કહ્યું, “આ તેં શું કર્યું?” સ્ત્રીએ કહ્યું કે, “સાપે મને છેતરી. તેથી મેં ફળ ખાધું.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","યહોવાહ ઈશ્વરે સાપને કહ્યું કે, “તેં આ કૃત્ય કર્યું છે, તેથી તું સર્વ ગ્રામ્યપશુઓ તથા વનપશુઓની વચ્ચે હવે શાપિત છે. તું પેટે ચાલશે અને પોતાના જીવનના સર્વ દિવસો સુધી તારે ધૂળ ખાવી પડશે. ");
INSERT INTO guj2017_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","તારી અને સ્ત્રીની વચ્ચે તથા તારા સંતાનની અને તેના સંતાનની વચ્ચે હું વૈર કરાવીશ. તે તારું માથું છૂંદશે અને તું તેની એડીએ ડંખ મારશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","વળી યહોવાહ ઈશ્વરે સ્ત્રીને કહ્યું કે, “હું તારી ગર્ભવસ્થાનું દુઃખ ઘણું જ વધારીશ અને તું દુઃખે બાળકને જન્મ આપીશ. તું તારા પતિને માટે ઝંખીશ, પણ તે તારા પર અધિકાર ચલાવશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","તેમણે આદમને કહ્યું, “કેમ કે તેં તારી પત્નીની વાત માની લીધી છે અને જે સંબંધી મેં તને આજ્ઞા આપી હતી, ‘તારે તે ન ખાવું’ તે વૃક્ષનું ફળ તેં ખાધું. તેથી તારા એ કૃત્યથી ભૂમિ શાપિત થઈ છે. તેમાંથી તું તારા આયુષ્યનાં સર્વ દિવસોમાં પરિશ્રમ કરીને ખોરાક મેળવશે. ");
INSERT INTO guj2017_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ભૂમિ તારે માટે કાંટા તથા ઝાંખરાં ઉગાવશે અને તું ખેતરનું શાક ખાશે. ");
INSERT INTO guj2017_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","તું ભૂમિમાં પાછો જશે ત્યાં સુધી તું તારા મોંના પરસેવાથી રોટલી ખાશે કેમ કે તું તેમાંથી લેવાયો હતો. કેમ કે તું ધૂળ છે અને પાછો ધૂળમાં ભળી જશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","તે માણસે તેની પત્નીનું નામ હવા પાડ્યું કેમ કે તે સમગ્ર માનવોની માતા થવાની હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","યહોવાહ ઈશ્વરે આદમ તથા તેની પત્ની માટે પશુઓનાં ચર્મનાં વસ્ત્ર બનાવ્યાં અને તેઓને પહેરાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","પ્રભુ ઈશ્વરે કહ્યું કે, “હવે તે માણસ આપણામાંના એકના જેવો સારું અને નરસું જાણનાર થયો છે. તેથી હવે રખેને તે હાથ લાંબો કરીને જીવનના વૃક્ષનું ફળ ખાય અને અમર થઈ જાય.” ");
INSERT INTO guj2017_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","તે માટે જે જમીનમાંથી તેનું સર્જન કરાયું હતું, તે ખેડવાને, પ્રભુ ઈશ્વરે તેને એદન વાડીમાંથી બહાર કાઢી મૂક્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ઈશ્વરે તે માણસને વાડીમાંથી દૂર કર્યો અને જીવનના વૃક્ષની સીમાને સાચવવા તેમણે એદન વાડીની પૂર્વગમ અગ્નિરૂપી તલવાર સાથે કરુબોને ચોકીદાર તરીકે ગોઠવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","આદમે પોતાની પત્ની હવાને જાણી અને તે ગર્ભવતી થઈ અને તેણે પુત્ર કાઈનને જન્મ આપ્યો. તેણે કહ્યું, “ઈશ્વરની કૃપાથી મને દીકરો જન્મ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","પછી તેણે બીજા પુત્ર હાબેલને જન્મ આપ્યો. બન્ને ભાઈઓમાંનો હાબેલ ઘેટાંપાળક હતો અને કાઈન ખેડૂત હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","આગળ જતા એમ થયું કે કાઈન ઈશ્વરને માટે ભૂમિનાં ફળમાંથી કંઈક અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","હાબેલ પોતાનાં ઘેટાંબકરાંમાંનાં પ્રથમ જન્મેલાં તથા ઉત્તમ અર્પણો લાવ્યો. ઈશ્વરે હાબેલને તથા તેના અર્પણને માન્ય કર્યાં, ");
INSERT INTO guj2017_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","પણ કાઈનને તથા તેના અર્પણને અમાન્ય કર્યાં. તેથી કાઈન ઘણો ગુસ્સે થયો અને તેનું મોં ઊતરી ગયું. ");
INSERT INTO guj2017_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","યહોવાહે કાઈનને કહ્યું કે, “તને શા માટે ગુસ્સો આવ્યો છે અને તારું મોં ઊતરી ગયું છે? ");
INSERT INTO guj2017_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","જે સારું છે તે તું કરે, તો શું તું માન્ય નહિ થશે? પણ જે સારું છે તે તું નહિ કરે, તો પાપ તારે દ્વારે રહે છે અને તે તેની તરફ તારું આકર્ષણ કરશે, પણ તું તેના પર જીત મેળવી શકીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","કાઈને પોતાના ભાઈ હાબેલ સાથે વાત કર્યો જયારે તેઓ ખેતરમાં હતા, ત્યારે ત્યાં કાઈને પોતાના ભાઈ હાબેલ વિરુદ્ધ ઊઠીને તેને મારી નાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","પછી ઈશ્વરે કાઈનને કહ્યું, “તારો ભાઈ હાબેલ ક્યાં છે? “તેણે કહ્યું, “હું જાણતો નથી? શું હું મારા ભાઈનો રખેવાળ છું?” ");
INSERT INTO guj2017_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ઈશ્વરે કહ્યું, “આ તેં શું કર્યું છે? તારા ભાઈનું લોહી ભૂમિમાંથી બદલો લેવા માટે મને હાંક મારે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","હવે તારા ભાઈનું લોહી તારા હાથથી લેવાને જે ભૂમિએ પોતાનું મુખ ઉઘાડ્યું છે, તેથી તું શાપિત થયો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","તું ગમે તેટલી મહેનતથી ભૂમિને ખેડશે, પણ તે પોતાનાં બળ તને આપશે નહિ. તું પૃથ્વી પર નિરાશ્રિતની માફક અહીંતહીં ભટકતો રહેશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","કાઈને ઈશ્વરને કહ્યું કે, “હું સહન કરું તે કરતાં તમે મને વધારે સજા કરી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","તમે મને આજે અહીંથી હાંકી કાઢ્યો છે અને હવે તમારી આગળથી મારે સંતાવાનું, પૃથ્વી પર ભટકવાનું તથા નાસતા ફરવાનું થશે. હવે જે કોઈ મને જોશે તે મને મારી નાખશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ઈશ્વરે તેને કહ્યું કે, “જે કોઈ તને મારી નાખશે, તેને સાત ગણી સજા થશે.” પછી ઈશ્વરે કાઈનને ઓળખવા સારુ તેના શરીર પર ચિહ્ન મૂક્યું કે જે કોઈ તેને જુએ, તે તેને મારી નાખે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","કાઈન ઈશ્વરની સમક્ષતામાંથી ચાલ્યો ગયો. અને જઈને એદનની પૂર્વના નોદ દેશમાં રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","કાઈને તેની પત્ની સાથે વૈવાહિક સંબંધ બાંધ્યો અને તે ગર્ભવતી થઈ. તેણે હનોખને જન્મ આપ્યો. કાઈને એક નગર બાંધ્યું અને તેનું નામ પોતાના દીકરાના નામ પરથી હનોખ નગર રાખ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","હનોખથી ઇરાદ જન્મ્યો. ઇરાદ મહૂયાએલનો પિતા હતો. મહૂયાએલ મથૂશાએલનો પિતા હતો. મથૂશાએલ લામેખનો પિતા હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","લામેખે બે સ્ત્રીઓ સાથે લગ્ન કર્યાં: એકનું નામ આદા અને બીજીનું નામ સિલ્લાહ હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","આદાએ યાબાલને જન્મ આપ્યો. તે તંબુઓમાં રહેનારાઓનો તથા ગોવાળિયાનો આદિપિતા હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","તેના ભાઈનું નામ યૂબાલ હતું. તે તાર તથા પવનથી વાગતાં વાંજિત્રો વગાડનારાઓનો આદિપિતા હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","સિલ્લાહએ પણ તૂબાલ-કાઈનને જન્મ આપ્યો. જે સર્વ તાંબાના તથા લોખંડનાં હથિયાર બનાવનાર હતો. તૂબાલ-કાઈનની બહેન નાઅમાહ હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","લામેખે પોતાની પત્નીઓને કહ્યું કે, “આદા તથા સિલ્લાહ, હું જે કહું તે સાંભળો, હે લામેખની પત્નીઓ માંરે જે કહેવું પડે છે તે કાળજીપૂર્વક સાંભળો. મને ઘાયલ કરનાર એક માણસને, મેં મારી નાખ્યો છે, મને જખમી કરનાર એક જુવાનને મેં મારી નાખ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","જો કાઈનને મારવાનો બદલો સાત ગણો લેવાય, તો લામેખનો સિત્તોતેર ગણો લેવાશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","પછી આદમથી સગર્ભા થયેલી તેની પત્ની હવાએ બીજા એક દીકરાને જન્મ આપ્યો. તેનું નામ શેથ રાખવામાં આવ્યું. ત્યારે હવાના ઉદ્દગાર આ હતા: “કાઈને હાબેલને મારી નાખ્યો હતો. એ હાબેલના બદલામાં ઈશ્વરે મને બીજો દીકરો આપ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","શેથની પત્નીએ પણ દીકરાને જન્મ આપ્યો. તેણે તેનું નામ અનોશ રાખ્યું. અનોશના જન્મ પછી લોકોમાં ઈશ્વરની ઉપાસના કરવાની શરૂઆત થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","આદમની વંશાવળીની વિગતો આ પ્રમાણે છે. ઈશ્વરે પોતાની પ્રતિમા પ્રમાણે માણસનું સર્જન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","પુરુષ તથા સ્ત્રીને તેમણે સર્જ્યા, તેઓને આશીર્વાદ આપ્યો અને તેઓની ઉત્પત્તિના દિવસે તેઓનું નામ માનવજાત પાડવામાં આવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","જયારે આદમ એકસો ત્રીસ વર્ષનો થયો, ત્યારે તેને તેની પ્રતિમા તથા સ્વરૂપ પ્રમાણે તેની પત્નીએ દીકરાને જન્મ આપ્યો. તેણે તેનું નામ શેથ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","શેથના જન્મ પછી આદમ આઠસો વર્ષ જીવ્યો અને તે ઘણાં દીકરા અને દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","આદમ નવસો ત્રીસ વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","જયારે તેના પુત્ર અનોશનો જન્મ થયો ત્યારે શેથ એકસો પાંચ વર્ષનો થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","અનોશનો જન્મ થયા પછી, શેથ આઠસો સાત વર્ષ જીવ્યો, તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","શેથ નવસો બાર વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","જયારે તેના પુત્ર કેનાનનો જન્મ થયો ત્યારે અનોશ નેવું વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","કેનાનના જન્મ પછી અનોશ આઠસો પંદર વર્ષ જીવ્યો. તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","અનોશ નવસો પાંચ વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","જયારે તેના પુત્ર માહલાલેલનો જન્મ થયો ત્યારે કેનાન સિત્તેર વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","માહલાલેલનો જન્મ થયા પછી કેનાન આઠસો ચાળીસ વર્ષ સુધી જીવ્યો. તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","કેનાન નવસો દસ વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","જ્યારે તેના પુત્ર યારેદનો જન્મ થયો ત્યારે માહલાલેલ પાંસઠ વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","યારેદનો જન્મ થયા પછી માહલાલેલ આઠસો ત્રીસ વર્ષ જીવ્યો. તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","માહલાલેલ આઠસો પંચાણું વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","જયારે તેના પુત્ર હનોખનો જન્મ થયો ત્યારે યારેદ એકસો બાસઠ વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","હનોખનો જન્મ થયા પછી યારેદ આઠસો વર્ષ જીવ્યો. તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","યારેદ નવસો બાસઠ વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","તેના પુત્ર મથૂશેલાહનો જન્મ થયો ત્યારે હનોખ પાંસઠ વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","મથૂશેલાહનો જન્મ થયાં પછી હનોખ ત્રણસો વર્ષ ઈશ્વરની સંઘાતે ચાલ્યો અને તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","હનોખનું પૃથ્વી પરનું આયુષ્ય ત્રણસો પાંસઠ વર્ષનું હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","હનોખ ઈશ્વરની સંઘાતે ચાલતો હતો. પછી તે અદ્રશ્ય થઈ ગયો, કેમ કે ઈશ્વરે તેને લઈ લીધો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","જયારે તેના પુત્ર લામેખનો જન્મ થયો ત્યારે મથૂશેલાહ એકસો સિત્યાસી વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","લામેખનો જન્મ થયા પછી મથૂશેલાહ સાતસો બ્યાસી વર્ષ જીવ્યો. તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","મથૂશેલાહ નવસો અગણોસિત્તેર વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","જયારે લામેખ એકસો બ્યાસી વર્ષનો થયો ત્યારે તે એક દીકરાનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","તેણે તેનું નામ નૂહ રાખ્યું અને કહ્યું કે, “આ ઈશ્વરે શાપિત કરેલી ભૂમિ પર અમારા સખત કામ અને અમારા હાથોના સખત પરિશ્રમથી અમને વિસામો આપશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","નૂહનો જન્મ થયા પછી લામેખ પાંચસો પંચાણું વર્ષ જીવ્યો. તે ઘણાં દીકરા તથા દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","લામેખ સાતસો સિત્તોતેર વર્ષની ઉંમરે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","નૂહ પાંચસો વર્ષનો થયો પછી તે શેમ, હામ તથા યાફેથનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","પૃથ્વી પર માણસો વધવા લાગ્યાં. તેમાં દીકરીઓના પણ જન્મ થયા, ત્યારે એમ થયું કે, ");
INSERT INTO guj2017_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ઈશ્વરના દીકરાઓએ જોયું કે માણસોની દીકરીઓ મનમોહક છે. તેઓમાંથી તેઓએ પોતાને માટે તેમને પત્નીઓ તરીકે પસંદ કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ઈશ્વરે કહ્યું કે, “મારો આત્મા માનવજાતમાં સદા રહેશે નહિ, કેમ કે તેઓ શરીર છે. તેઓનું આયુષ્ય એકસો વીસ વર્ષનું રહેશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ઈશ્વરના દીકરાઓએ માણસોની દીકરીઓ સાથે લગ્ન કર્યાં અને તેઓથી તેમને બાળકો થયાં. તેઓમાં પૃથ્વી પર પુરાતનકાળના સશક્ત અને નામાંકિત મહાકાય પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ઈશ્વરે જોયું કે, પૃથ્વી પર માનવજાતના દુરાચાર ઘણાં વધી ગયા છે અને તેઓના હૃદયના વિચારોની દરેક કલ્પના દુષ્ટ જ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","તેથી ઈશ્વરને પૃથ્વી પર માણસને ઉત્પન્ન કરવા બદલ દુઃખ થયું અને તે નિરાશ થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ઈશ્વરે કહ્યું કે, “જે માનવજાતને મેં ઉત્પન્ન કરી છે, તેનો હવે હું પૃથ્વી પરથી સમૂળગો નાશ કરીશ; તે સાથે પશુઓને, પેટે ચાલનારાં અને આકાશના પક્ષીઓને પણ નષ્ટ કરીશ. કેમ કે તેઓને ઉત્પન્ન કર્યાથી હું હૃદયભંગ થયો છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","પણ નૂહના આચરણથી ઈશ્વર સંતુષ્ટ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","નૂહ અને તેના કુટુંબ વિશેનું આ વૃત્તાંત છે: નૂહ ન્યાયી માણસ હતો અને તેના સમયના લોકોમાં તે નિર્દોષ હતો. તે ઈશ્વરની સાથે પ્રમાણિકપણે ચાલ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","નૂહને ત્રણ દીકરાઓ હતા: શેમ, હામ તથા યાફેથ. ");
INSERT INTO guj2017_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ઈશ્વર આગળ પૃથ્વી ભ્રષ્ટ થઈ હતી અને હિંસાથી ભરપૂર થઈ હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ઈશ્વરે પૃથ્વીમાં નજર કરી; તો જુઓ, ત્યાં પૃથ્વી પર સર્વ માણસો ભ્રષ્ટ અને દુરાચારી થઈ ગયા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ઈશ્વરે નૂહને કહ્યું કે, “હું જોઉં છું કે સર્વ માનવજાત નષ્ટ થવાની છે, કેમ કે પૃથ્વીમાં તેઓની હિંસા અને દુરાચાર વ્યાપી ગયો છે. નિશ્ચે, હું તેઓનો પૃથ્વી પરથી સમૂળગો નાશ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","તું પોતાને સારુ એરેજનાં લાકડાંનું વહાણ બનાવ. તે વહાણમાં રૂમો બનાવ. વહાણની અંદર તથા બહાર ડામર લગાવીને તેનું આવરણ કર. ");
INSERT INTO guj2017_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","તું તેને આ પ્રમાણે બનાવ: એટલે વહાણની લંબાઈ ત્રણસો હાથ, પહોળાઈ પચાસ હાથ અને તેની ઊંચાઈ ત્રીસ હાથ હોય. ");
INSERT INTO guj2017_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","વહાણમાં છતથી એક હાથ નીચે બારી બનાવ. અને તું તેમાં નીચેનો, વચ્ચેનો તથા ઉપરનો એવા ત્રણ ખંડો બનાવ. ");
INSERT INTO guj2017_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","સાંભળ, આકાશ નીચેના સર્વ સજીવો કે જેઓમાં જીવનનો શ્વાસ છે તે બધાનો સંપૂર્ણ નાશ કરવા માટે હું પૃથ્વી પર જળપ્રલય લાવવાનો છું. તેનાથી પૃથ્વી પરનાં સર્વ જીવ મરણ પામશે. ");
INSERT INTO guj2017_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","પણ હું તારી સાથે મારો કરાર કરું છું. તું, તારી સાથે તારા દીકરા, તારી પત્ની અને તારી પુત્રવધુઓને હું વહાણમાં સલામત રાખીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","સર્વ પ્રકારના જાનવરોમાંથી બબ્બે સજીવો, એટલે એક નર તથા એક નારી બચાવવા માટે તારી સાથે તું વહાણમાં લાવ. ");
INSERT INTO guj2017_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","દરેક જાતનાં પક્ષીઓ, પશુઓ તથા પેટે ચાલનારાંઓમાંથી નર અને નારીની એક એક જોડને વહાણમાં લાવ. ");
INSERT INTO guj2017_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","સર્વ પ્રકારની ખાદ્ય સામગ્રી ભેગી કરીને તારી પાસે વહાણમાં તેનો સંગ્રહ કરી રાખ. તે તારે માટે તથા તેઓને માટે ખોરાક થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ઈશ્વરની આજ્ઞા અનુસાર નૂહે બધાં કામ પૂરાં કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ઈશ્વરે નૂહને કહ્યું, “તું, તારા કુટુંબ સાથે, વહાણમાં આવ, કેમ કે આ પેઢીમાં મારી સમક્ષ તું એકલો જ ન્યાયી માલૂમ પડ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","દરેક શુદ્ધ પશુઓમાંથી સાત નર અને સાત નારીને લાવ અને અશુદ્ધ પશુઓમાંથી બે નર અને બે નારીને વહાણમાં લે. ");
INSERT INTO guj2017_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","તેની સાથે આકાશના પક્ષીઓમાંનાં સાત નર અને સાત નારીને પણ તારી સાથે લે, કે જેથી જળપ્રલય પછી તેઓની પ્રજોત્પત્તિ વધતી રહે. ");
INSERT INTO guj2017_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","સાત દિવસ પછી હું પૃથ્વી પર ચાળીસ દિવસ અને ચાળીસ રાત સુધી વરસાદ વરસાવીશ. મેં ઉત્પન્ન કર્યાં છે એ સર્વ સજીવોનો હું પૃથ્વી પરથી નાશ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ઈશ્વરે જે સર્વ આજ્ઞા નૂહને આપી હતી તે પ્રમાણે તેણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","જળપ્રલયના સમયે નૂહની ઉંમર છસો વર્ષની હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","જળપ્રલય થવાનો હોવાને કારણે નૂહ, તેના દીકરા, તેની પત્ની અને તેની પુત્રવધૂઓ એકસાથે વહાણમાં ગયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","શુદ્ધ તથા અશુદ્ધ પશુઓ, પક્ષીઓ તથા પૃથ્વી પર પેટે ચાલનારાં સર્વ સજીવો હતા, ");
INSERT INTO guj2017_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","તેઓમાંના દરેક નર તથા નારીની જોડી ઈશ્વરની આજ્ઞા અનુસાર નૂહ પાસે આવ્યાં અને વહાણમાં ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","સાત દિવસ પછી પૃથ્વી પર જળપ્રલય થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","નૂહના આયુષ્યનાં છસોમા વર્ષના બીજા મહિનાને સત્તરમે દિવસે જળનિધિના મોટા ઝરા ફૂટી નીકળ્યા અને આકાશમાંથી મુશળધાર વરસાદ વરસ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ચાળીસ દિવસ તથા ચાળીસ રાત સુધી પૃથ્વી પર સતત વરસાદ વરસ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","તે જ દિવસે નૂહ, તેના દીકરાઓ શેમ, હામ, યાફેથ તથા તેની પત્ની અને પુત્રવધૂઓ સહિત વહાણમાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","તેઓની સાથે પોતપોતાની જાત પ્રમાણે સર્વ વન્ય પશુ, પોતપોતાની જાત પ્રમાણે સર્વ પાલતુ પશુ, પોતપોતાની જાત પ્રમાણે સર્વ પેટે ચાલનારાં અને પોતપોતાની જાત પ્રમાણે દરેક જાતનાં મોટાં તથા નાનાં સર્વ પક્ષીઓ વહાણમાં ગયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","સર્વ દેહધારી જાત જેમાં જીવનનો શ્વાસ છે તેમાંથી બબ્બે નૂહ પાસે વહાણમાં ગયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","જેઓ વહાણમાં ગયાં તે સર્વ પ્રાણીઓમાં નર તથા નારી હતાં; ઈશ્વરે નૂહને એ માટેની આજ્ઞા આપી હતી. પછી ઈશ્વરે વહાણનું દ્વાર બંધ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","પછી પૃથ્વી પર ચાળીસ રાત દિવસો સુધી જળપ્રલય થયો અને પાણી વધવાથી વહાણ પૃથ્વીની સપાટી પરથી ઊંચકાઈને તરતું થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","પાણીનો પુરવઠો વધ્યો અને પૃથ્વી પર તે ઘણું ઊંચે ચઢ્યું અને વહાણ પાણી પર તરવા લાગ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","પૃથ્વી પર પાણી એટલું બધું વધ્યું કે પૃથ્વી પરના સર્વ ઊંચા પહાડો પાણીથી ઢંકાઈ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","પર્વતોનાં સૌથી ઊંચા શિખર કરતાં પણ પાણીની સપાટી પંદર હાથ જેટલી ઊંચી વધી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","પૃથ્વી પર ફરનારાં સર્વ પશુઓ, પક્ષીઓ, જાનવરો, વન્ય પ્રાણીઓ, જીવજંતુઓ તથા સર્વ માણસો મરણ પામ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","કોરી ભૂમિ પરનાં સર્વ, જેઓનાં નસકોરાંમાં જીવનનો શ્વાસ હતો, તેઓ સર્વનો નાશ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","આમ પૃથ્વીના સર્વ જીવો, એટલે માણસો, પશુઓ, પેટે ચાલનારાં તથા આકાશના પક્ષીઓ પૃથ્વી પરથી નષ્ટ થયાં. માત્ર નૂહ તથા તેની સાથે જેઓ વહાણમાં હતાં તેઓ જ જીવતાં રહ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","પૃથ્વી પર એકસો પચાસ દિવસો સુધી પાણી છવાયેલું રહ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ઈશ્વરે નૂહના કુટુંબની તથા તેની સાથે જે સર્વ પશુ, પક્ષી તથા સજીવો વહાણમાં હતા તેઓની સંભાળ લીધી. તેમણે પૃથ્વી પર પવન ફૂંકાવ્યો અને પાણીનું પ્રમાણ ઓછું થવા લાગ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","જળનિધિના ઝરા, આકાશના દ્વારો બંધ થયાં અને વરસાદ વરસતો અટકી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","જળપ્રલય શરૂ થયાના એકસો પચાસ દિવસો પછી પૃથ્વી પરથી ધીરે ધીરે પાણી ઓસરવા લાગ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","સાતમા મહિનાને સત્તરમે દિવસે વહાણ અરારાટ પર્વત પર આવીને થંભ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","પાણી ઓસરતાં ગયાં અને ત્રીજા મહિના પછી અન્ય ઊંચા પહાડોનાં શિખર દેખાયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ચાળીસ દિવસ પછી નૂહે વહાણની બારી ઉઘાડી. ");
INSERT INTO guj2017_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","તેણે એક કાગડાને બહાર મોકલ્યો. પૃથ્વી પરનાં પાણી સુકાયાં નહિ ત્યાં સુધી કાગડો આમતેમ ઊડતો ફર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","પછી જમીનની સપાટી પર પાણી ઓસર્યાં છે કે નહિ તે જોવા સારુ નૂહે એક કબૂતરને મોકલ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","પણ આખી પૃથ્વી પર પાણી હોવાને લીધે કબૂતરને પોતાના પગ મૂકવાની જગ્યા મળી નહિ, તેથી તે તેની પાસે વહાણમાં પાછું આવ્યું. નૂહે પોતાનો હાથ લંબાવીને તેને પોતાની પાસે વહાણમાં લઈ લીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","બીજા સાત દિવસ રાહ જોયા પછી નૂહે ફરીથી વહાણમાંથી કબૂતરને મોકલ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","કબૂતર ફરીને સાંજે તેની પાસે પાછું આવ્યું. તેની ચાંચમાં જૈતૂનવૃક્ષનું એક પાંદડું હતું. તેથી નૂહને સમજાયું કે પૃથ્વી પરથી પાણી ઓસર્યાં છે. ");
INSERT INTO guj2017_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","તેણે બીજા સાત દિવસો સુધી રાહ જોઈ અને ફરીથી કબૂતરને બહાર મોકલ્યું. પણ તે તેની પાસે ફરી પાછું આવ્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","નૂહની ઉંમર છસો એક વર્ષની થઈ ત્યારે તે વર્ષના પ્રથમ દિવસે પૃથ્વી પરથી પાણી સુકાઈ ગયાં. નૂહે વહાણની છત ઉઘાડીને બહાર જોયું, તો ભૂમિની સપાટી કોરી થયેલી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","બીજા મહિનાને સત્તાવીસમે દિવસે પૃથ્વી પરની ભૂમિ કોરી થઈ ગઈ હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","પછી ઈશ્વરે નૂહને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“તું, તારી પત્ની, તારા દીકરાઓ તથા તારી પુત્રવધૂઓ વહાણમાંથી બહાર આવો. ");
INSERT INTO guj2017_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","વળી દરેક જાતનાં પ્રાણીઓને, એટલે પક્ષીઓ, પશુઓ તથા પૃથ્વી પર પેટે ચાલનારાં સર્વને તારી સાથે બહાર લાવ, કે જેથી તેઓ પૃથ્વી પર સફળ થાય અને વૃદ્ધિ પામે.” ");
INSERT INTO guj2017_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","તેથી નૂહ તેની સાથે તેના દીકરા, તેની પત્ની અને તેની પુત્રવધૂઓ સહિત બહાર આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","દરેક સજીવ પ્રાણી, દરેક પેટે ચાલનારાં, દરેક પક્ષી તથા દરેક જે પૃથ્વી પર ચાલે છે તે પોતપોતાની જાત પ્રમાણે સર્વ વહાણમાંથી બહાર આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","નૂહે ઈશ્વરને અર્પણ કરવા માટે એક વેદી બાંધી. એ વેદી પર તેણે શુદ્ધ પશુઓમાંથી તથા શુદ્ધ પક્ષીઓમાંથી કેટલાંકના દહનીયાર્પણ કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","યહોવાહે સુગંધીઓથી પ્રસન્ન થઈને પોતાના હૃદયમાં કહ્યું કે, “બાળપણથી જ માણસના હૃદયનું વલણ દુષ્ટ હોય છે તે છતાં પણ હવે પછી માનવજાતને નષ્ટ કરીને હું ભૂમિને ફરી શાપિત નહિ કરું. જેમ મેં સર્વ સજીવોનો નાશ કર્યો છે એવું ફરીથી કદી હું નહિ કરું. ");
INSERT INTO guj2017_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","પૃથ્વી રહેશે ત્યાં સુધી વાવણી તથા કાપણીની મોસમ, ઠંડી તથા ગરમી, ઉનાળો તથા શિયાળો અને દિવસ તથા રાત થયા વગર રહેશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","પછી ઈશ્વરે નૂહને તથા તેના દીકરાઓને આશીર્વાદ આપ્યો અને તેઓને કહ્યું કે, “સફળ થાઓ, વધો અને પૃથ્વીને ભરપૂર કરો. ");
INSERT INTO guj2017_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","પૃથ્વીના દરેક પશુ પર, આકાશના દરેક પક્ષી પર, પૃથ્વી પર પેટે ચાલનારાં દરેક અને સમુદ્રનાં દરેક માછલાં તમારાથી બીશે અને ડરશે. તેઓને તમારા હાથમાં આપવામાં આવેલા છે. ");
INSERT INTO guj2017_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","પૃથ્વી પર ચાલનારાં બધા પશુ તમારે સારુ ખોરાક થશે. જે પ્રમાણે મેં તમને લીલાં શાક આપ્યાં છે તે પ્રમાણે હવે હું તમને સઘળું બક્ષુ છું. ");
INSERT INTO guj2017_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","પણ તેનું માંસ તમારે જીવ એટલે લોહી સહિત ન ખાવું. ");
INSERT INTO guj2017_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","હું નિશ્ચે તમારા લોહીનો બદલો માગીશ. દરેક પશુ પાસેથી હું બદલો લઈશ. કોઈપણ માણસના હાથ પાસેથી, એટલે કે, જે હાથે તેણે પોતાના ભાઈની હત્યા કરી છે, તેના જીવનો બદલો હું માંગીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","જે કોઈ માણસનું લોહી વહેવડાવે, તેનું લોહી પણ માણસથી વહેવડાવાશે, કેમ કે ઈશ્વરે પોતાની પ્રતિમા પ્રમાણે માણસને ઉત્પન્ન કર્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","તમે સફળ થાઓ, આખી પૃથ્વી પર વંશવૃદ્ધિ કરો અને વધતા જાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","પછી ઈશ્વરે નૂહ સાથે તથા તેના દીકરાઓ સાથે વાત કરતા કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“હું જે કહું છું તે સાંભળો! હું તારી સાથે તથા તારી પાછળ આવનાર સંતાનો સાથે મારો કરાર સ્થાપન કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","અને તમારી સાથે પક્ષી, પશુ અને પૃથ્વી પરનાં સર્વ જાનવર તે સર્વની સાથે હું મારો કરાર સ્થાપન કરું છું. ");
INSERT INTO guj2017_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","તમારી સાથે હું મારો કરાર સ્થાપન કરું છું કે, હવે પછી ફરી જળપ્રલયથી સર્વ માનવજાતનો નાશ થશે નહિ. પૃથ્વીનો નાશ કરવાને ફરી કદી જળપ્રલય થશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ઈશ્વરે કહ્યું, “મારી તથા તમારી વચ્ચે તથા તમારી સાથે જે દરેક સજીવ પ્રાણી છે તેની સાથે તથા ભાવિ પેઢીને સારુ કર્યો છે તે કરારનું આ ચિહ્ન છે: ");
INSERT INTO guj2017_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","મેં મારું મેઘધનુષ્ય વાદળમાં મૂક્યું છે અને તે મારા તથા પૃથ્વી વચ્ચેના કરારની ચિહ્નરૂપ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","જયારે પૃથ્વી પર હું વરસાદ વરસાવીશ ત્યારે એમ થશે કે વાદળમાં મેઘધનુષ્ય દેખાશે, ");
INSERT INTO guj2017_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ત્યારે મારી અને તમારી તથા સર્વ સાથે કરેલો કરારનું હું સ્મરણ કરીશ. સર્વ સજીવોનો નાશ કરવાને માટે ફરી કદી જળપ્રલય થશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","મેઘધનુષ્ય વાદળમાં દેખાશે અને ઈશ્વર પૃથ્વીનાં સર્વ સજીવ પ્રાણીની વચ્ચે, જે સર્વકાળનો કરાર છે તે યાદ રાખવાને હું ધનુષ્યની સામે જોઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","પછી ઈશ્વરે નૂહને કહ્યું, “મારી તથા પૃથ્વી પરના સર્વ સજીવોની વચ્ચે જે કરાર મેં સ્થાપિત કર્યો છે તેનું આ ચિહ્ન છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","નૂહના દીકરા જેઓ વહાણમાંથી બહાર આવ્યા તે શેમ, હામ તથા યાફેથ હતા. હામ કનાનનો પિતા હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","નૂહના આ ત્રણ દીકરાઓ હતા. તેઓથી આખી પૃથ્વી પર વસ્તી થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","નૂહ ખેતી કરવા લાગ્યો અને તેણે દ્રાક્ષવાડી રોપી. ");
INSERT INTO guj2017_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","તેણે દ્રાક્ષાસવ પીધો અને તેને નશો ચઢ્યો હોવાથી તે તેના તંબુમાં નિર્વસ્ત્ર સ્થિતિમાં જ સૂઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","કનાનના પિતા હામે તેના પિતાને નિર્વસ્ત્ર અવસ્થામાં જોયા અને બહાર જઈને તેના બન્ને ભાઈઓને તે વિષે કહ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","તેથી શેમ તથા યાફેથે એક વસ્ત્ર લીધું, તેને તેમના બન્ને ખભા પર નાખ્યું અને તેઓએ પાછા પગલે ચાલીને તેમના પિતાના શરીરને ઓઢાડ્યું. તેઓનાં મુખ બીજી તરફ ફેરવેલાં હતાં તેથી તેઓને પિતાની નિર્વસ્ત્ર અવસ્થા દેખાઈ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","જયારે નૂહ નશામાંથી જાગ્યો ત્યારે તેના નાના દીકરાએ તેની સાથે જે કર્યું હતું તે તેણે જાણ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","તેથી તેણે કહ્યું કે, “કનાન શાપિત થાય. દાસોનો દાસ તે તેના ભાઈઓને સારુ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","તેણે કહ્યું કે, “ઈશ્વર, શેમના પ્રભુની સ્તુતિ થાઓ. કનાન તેનો દાસ થાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","યાફેથને યહોવાહ વૃદ્ધિ આપો, અને તે શેમના તંબુમાં તેનું ઘર બનાવે. કનાન તેનો દાસ થાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","જળપ્રલય પછી નૂહ ત્રણસો પચાસ વર્ષ જીવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","નૂહનો સર્વ દિવસ નવસો પચાસ વર્ષનો હતો અને તે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","નૂહના દીકરા, શેમ, હામ અને યાફેથની વંશાવળી આ પ્રમાણે છે. જળપ્રલય પછી તેઓને જે દીકરાઓ થયા તે આ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ગોમેર, માગોગ, માદાય, યાવાન, તુબાલ, મેશેખ તથા તીરાસ, યાફેથના દીકરાઓ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","આશ્કનાઝ, રીફાથ તથા તોગાર્મા, ગોમેરના દીકરાઓ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","એલીશા, તાર્શીશ, કિત્તીમ અને દોદાનીમ, યાવાનના દીકરાઓ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","તેઓના વંશના લોકો પોતપોતાની ભાષા, કુળો અને તેઓના પ્રદેશો પ્રમાણે દરિયા કિનારાના વિભાગોમાં અલગ અલગ સ્થળે વિસ્તર્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","કૂશ, મિસરાઈમ, પૂટ અને કનાન, હામના દીકરાઓ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","કૂશના દીકરાઓ સબા, હવીલા, સાબ્તા, રામા તથા સાબ્તેકા હતા. રામાના દીકરા શેબા તથા દેદાન હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","કૂશનો દીકરો નિમ્રોદ, પૃથ્વી પરનો પહેલો શક્તિશાળી યોદ્ધો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","તે યહોવાહની આગળ બળવાન શિકારી હતો. એ માટે કહેવાય છે કે, “નિમ્રોદ યહોવાહની આગળ બળવાન શિકારી જેવો હતો.” ");
INSERT INTO guj2017_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","તેણે શિનઆર દેશના બાબિલ, એરેખ, આક્કાદ તથા કાલનેહ પર સૌ પ્રથમ પોતાના રાજ્યની સ્થાપના શરૂઆત કરી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ત્યાંથી તે આશ્શૂરમાં ગયો અને નિનવે, રહોબોથ ઈર, કાલા, ");
INSERT INTO guj2017_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","રેસેન, જે નિનવે તથા કાલાની વચમાં હતું, તે સર્વ નગરો તેણે બાંધ્યાં. તેમાં રેસેન એક મોટું નગર હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","મિસરાઈમ તે લૂદીમ, અનામીમ લહાબીમ, નાફતુહીમ, ");
INSERT INTO guj2017_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","પાથરુસીમ, કાસ્લુહીમ તેનામાંથી પલિસ્તીઓનો ઉદ્દભવ થયો હતો તથા કાફતોરીમ એ સર્વનો પિતા હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","કનાનનો પ્રથમ દીકરો સિદોન હતો અને પછી હેથ, ");
INSERT INTO guj2017_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","વળી યબૂસી, અમોરી, ગિર્ગાશી, ");
INSERT INTO guj2017_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","હિવ્વી, આર્કી, સિની, ");
INSERT INTO guj2017_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","આર્વાદી, સમારી તથા હમાથીનો પણ તે પિતા હતો. ત્યાર પછી કનાનીઓનાં કુટુંબો વિસ્તાર પામ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","કનાનીઓની સરહદ સિદોનથી ગેરાર જતા ગાઝા, સદોમ, ગમોરા, આદમા તથા સબોઈમ જતા લાશા સુધી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","આ પ્રમાણે હામના દીકરા, પોતાનાં કુટુંબો પ્રમાણે, પોતાની ભાષા પ્રમાણે, તેઓના દેશોમાં તથા પોતપોતાના લોકોમાં વસેલા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","શેમને પણ દીકરાઓ થયા. તેનો મોટો ભાઈ યાફેથ હતો. શેમ એબેરના બધા લોકોનો પૂર્વજ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","શેમના દીકરાઓ, એલામ, આશ્શૂર, આર્પાકશાદ, લૂદ તથા અરામ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","અરામના દીકરાઓ ઉસ, હૂલ, ગેથેર અને માશ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","આર્પાકશાદ શેલાનો પિતા અને શેલા એબેરનો પિતા હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","એબેરને બે દીકરા થયા. એકનું નામ પેલેગ, કેમ કે તેના દિવસોમાં પૃથ્વીના વિભાગ થયાં. તેના ભાઈનું નામ યોકટાન હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","યોકટાન તે આલ્મોદાદ, શેલેફ, હસાર્માવેથ, યેરાહ; ");
INSERT INTO guj2017_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","હદોરામ, ઉઝાલ, દિકલાહ; ");
INSERT INTO guj2017_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ઓબાલ, અબિમાએલ, શેબા; ");
INSERT INTO guj2017_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ઓફીર, હવીલા અને યોબાબનો પિતા હતો. એ સર્વ યોકટાનના દીકરા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","મેશાથી આગળ જતા પૂર્વનો પહાડ સફાર આવેલો છે. ત્યાં સુધી તેઓનો વસવાટ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","પોતાના કુટુંબો પ્રમાણે, પોતાની બોલી પ્રમાણે, પોતાના દેશો તથા પોતાના લોકો પ્રમાણે આ શેમના દીકરાઓ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","તેઓની વંશાવળી પ્રમાણે અને તેઓના પ્રદેશો પ્રમાણે એ બધા નૂહના દીકરાઓનાં કુટુંબો છે. જળપ્રલય પછી પૃથ્વી પરના લોકોના વિવિધ વિભાગો થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","હવે આખી પૃથ્વીમાં એક જ ભાષા તથા એક જ બોલી વપરાતી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","તેઓ પૂર્વ તરફ ગયા, તેઓએ શિનઆર દેશમાં એક સપાટ જગ્યા શોધી ત્યાં તેઓ રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","તેઓએ એકબીજાને કહ્યું કે, “ચાલો, આપણે ઈંટો બનાવીએ અને તેને સારી રીતે પકવીએ.” પથ્થરની જગ્યાએ તેઓની પાસે ઈંટો અને ચૂનાની જગ્યાએ ડામર હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","તેઓએ કહ્યું, “આપણે એક શહેર બનાવીએ જેનો બુરજ આકાશો સુધી પહોંચે. એનાથી આપણે આપણું નામ પ્રતિષ્ઠિત કરીએ અને આપણે પૃથ્વી પર વિખેરાઈ જઈએ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","તેથી આદમના વંશજો જે નગરનો બુરજ બાંધતા હતા તે જોવાને ઈશ્વર નીચે ઊતર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ઈશ્વરે કહ્યું, “જુઓ, આ લોકો એક છે અને તેઓ સર્વની ભાષા એક છે, તેઓએ આવું કરવા માંડ્યું છે! તો હવે જે કંઈ તેઓ કરવા ધારે તેમાં તેઓને કશો અવરોધ નડશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","આવો, આપણે ત્યાં નીચે ઉતરીએ અને તેઓની ભાષાને ગૂંચવી નાખીએ, કે જેથી તેઓ એકબીજાની બોલી સમજી શકે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","તેથી ઈશ્વરે તેઓને ત્યાંથી આખી પૃથ્વીની સપાટી પર વિખેરી નાખ્યા અને તેઓ નગરનો બુરજ બાંધી શક્યા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","તેથી તે નગરને બાબિલ એટલે ગૂંચવણ કહેવામાં આવે છે. કેમ કે ઈશ્વરે પૃથ્વી પરની ભાષામાં ગૂંચવણ કરી અને ઈશ્વરે તેઓને ત્યાંથી પૃથ્વી પર ચોતરફ વિખેરી નાખ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","શેમની વંશાવળી આ પ્રમાણે છે. શેમ સો વર્ષનો હતો અને જળપ્રલયના બે વર્ષ પછી તેના પુત્ર આર્પાકશાદનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","આર્પાકશાદના જન્મ થયા પછી શેમ પાંચસો વર્ષ જીવ્યો. તે બીજા ઘણાં દીકરા અને દીકરીઓનો પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","જયારે આર્પાકશાદ પાંત્રીસ વર્ષનો થયો, ત્યારે તેના પુત્ર શેલાનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","શેલાના જન્મ થયા પછી આર્પાકશાદ ચારસો ત્રણ વર્ષ જીવ્યો અને તે બીજા ઘણાં દીકરા અને દીકરીઓનો પણ પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","જયારે શેલા ત્રીસ વર્ષનો થયો, ત્યારે તેના પુત્ર એબેરનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","એબેરનો જન્મ થયા પછી શેલા ચારસો ત્રણ વર્ષ જીવ્યો અને તે બીજા ઘણાં દીકરા તથા દીકરીઓનો પણ પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","એબેર ચોત્રીસ વર્ષનો થયો ત્યારે તેના પુત્ર પેલેગનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","પેલેગનો પિતા થયા પછી એબેર ચારસો ત્રીસ વર્ષ જીવ્યો અને તે બીજા દીકરા તથા દીકરીઓનો પણ પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","પેલેગ ત્રીસ વર્ષનો થયો ત્યારે તેના પુત્ર રેઉનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","રેઉનો જન્મ થયા પછી પેલેગ બસો નવ વર્ષ જીવ્યો અને તે બીજા દીકરા તથા દીકરીઓનો પણ પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","રેઉ બત્રીસ વર્ષનો થયો ત્યારે તેના પુત્ર સરૂગનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","સરૂગનો જન્મ થયા પછી રેઉ બસો સાત વર્ષ જીવ્યો અને તે બીજા દીકરા તથા દીકરીઓનો પણ પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","સરૂગ ત્રીસ વર્ષનો થયો ત્યારે તેના પુત્ર નાહોરનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","નાહોરનો જન્મ થયા પછી સરૂગ બસો વર્ષ જીવ્યો અને તે બીજા દીકરા તથા દીકરીઓનો પણ પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","નાહોર ઓગણત્રીસ વર્ષનો થયો ત્યારે તેના પુત્ર તેરાહનો જન્મ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","તેરાહનો જન્મ થયા પછી નાહોર એકસો ઓગણીસ વર્ષ જીવ્યો અને તે બીજા દીકરા તથા દીકરીઓનો પણ પિતા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","તેરાહ સિત્તેર વર્ષનો થયા પછી તેના પુત્ર ઇબ્રામ, નાહોર તથા હારાનના જન્મ થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","હવે તેરાહની વંશાવળી આ છે. તેરાના પુત્રો ઇબ્રામ, નાહોર તથા હારાન હતા. હારાને લોતને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","હારાન તેના પિતા તેરાહની હાજરીમાં, તેના જન્મના દેશમાં, ખાલદીઓના ઉરમાં મૃત્યુ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ઇબ્રામે તથા નાહોરે લગ્ન કર્યાં. ઇબ્રામની પત્નીનું નામ સારાય અને નાહોરની પત્નીનું નામ મિલ્કાહ હતું. તે હારાનની દીકરી હતી, મિલ્કા તથા યિસ્કા હારાનના સંતાનો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","હવે સારાય નિ:સંતાન હતી; તેને કોઈ સંતાન નહોતું. ");
INSERT INTO guj2017_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","તેરાહ તેના દીકરા ઇબ્રામને તથા દીકરા હારાનના પુત્ર લોતને અને સારાય તેની પુત્રવધૂ લઈને ઉર જે ખાલદીઓનો પ્રદેશ છે તે છોડીને, કનાન દેશમાં જવા નીકળ્યા. પણ તેઓ હારાનમાં આવીને રહ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","તેરાહ બસો પાંચ વર્ષની ઉંમરે હારાનમાં મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","હવે ઈશ્વરે ઇબ્રામને કહ્યું, “તું તારો દેશ, તારા સગાંઓ અને તારા પિતાના કુટુંબને છોડીને, જે દેશ હું તને બતાવું ત્યાં જા. ");
INSERT INTO guj2017_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","હું તારાથી એક મોટી જાતિ ઉત્પન્ન કરીશ, હું તને આશીર્વાદ દઈશ, તારું નામ મોટું કરીશ અને તું આશીર્વાદરૂપ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","જેઓ તને આશીર્વાદ આપશે, તેઓને હું આશીર્વાદ આપીશ અને જેઓ તને શાપ આપશે, તેઓને હું શાપ આપીશ. પૃથ્વીના સર્વ કુટુંબો તારી મારફતે આશીર્વાદિત થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","તેથી ઈશ્વરે તેને જે પ્રમાણે કરવાનું કહ્યું હતું તે પ્રમાણે, ઇબ્રામ અને તેની સાથે તેનો ભત્રીજો લોત પણ ગયો. જયારે ઇબ્રામ હારાન દેશથી રવાના થયો ત્યારે તે પંચોતેર વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ઇબ્રામે તેની પત્ની સારાયને તથા તેના ભત્રીજા લોતને તેઓએ મેળવેલી સર્વ સંપત્તિ, જાનવરો તથા જે દાસદાસીઓ તેમને હારાનમાં પ્રાપ્ત થયાં હતા તેઓને સાથે લીધાં. તેઓ કનાન દેશમાં પહોંચ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ઇબ્રામ કનાન દેશમાં શખેમથી મુસાફરી કરતાં મોરેના એલોન વૃક્ષ પાસે આવ્યો. તે વખતે કનાનીઓ તે દેશમાં રહેતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ઈશ્વરે ઇબ્રામને દર્શન આપીને કહ્યું, “હું તારા વંશજોને આ દેશ આપીશ.” તેથી જેમણે તેને દર્શન આપ્યું હતું તે ઈશ્વરના સ્મરણમાં ઇબ્રામે ત્યાં વેદી બાંધી. ");
INSERT INTO guj2017_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ઇબ્રામે ત્યાંથી નીકળીને બેથેલની પૂર્વ તરફ જે પર્વતીય પ્રદેશ છે ત્યાં સ્થળાંતર કર્યું અને ત્યાં તંબુ ઊભો કર્યો. તેની પશ્ચિમે બેથેલ તથા પૂર્વે આય હતું. ત્યાં તેણે ઈશ્વરને નામે વેદી બાંધી અને ઈશ્વરને પ્રાર્થના કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","પછી ઇબ્રામે નેગેબ તરફ જવા માટે મુસાફરી ચાલુ રાખી. ");
INSERT INTO guj2017_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","તે દેશમાં દુકાળ પડ્યો હતો. ભારે દુકાળ હોવાના કારણે ઇબ્રામ મિસરમાં રહેવા ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","જયારે તે મિસરમાં પ્રવેશ્યો ત્યારે તેણે તેની પત્ની સારાયને કહ્યું કે, “હું જાણું છું કે તું દેખાવે સુંદર સ્ત્રી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","મિસરીઓ જયારે તને જોશે અને તેઓ કહેશે, ‘આ તેની પત્ની છે’ તેથી તેઓ મને મારી નાખશે, પણ તેઓ તને જીવતી રાખશે. ");
INSERT INTO guj2017_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","તેથી તું કહેજે કે, હું તેની બહેન છું. એ માટે કે તારે લીધે મારું ભલું થાય અને મારો જીવ બચી જાય.” ");
INSERT INTO guj2017_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ઇબ્રામ જયારે મિસરમાં પ્રવેશ્યો ત્યારે મિસરીઓએ જોયું કે સારાય ઘણી સુંદર છે. ");
INSERT INTO guj2017_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ફારુનના સરદારોએ તેને જોઈ, તેઓએ ફારુનની આગળ તેની પ્રશંસા કરી અને સારાયને ફારુનના જનાનખાનામાં લઈ જવામાં આવી. ");
INSERT INTO guj2017_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ફારુને તેને લીધે ઇબ્રામ સાથે સારો વ્યવહાર કર્યો અને તેને ઘેટાં, બળદો, ગધેડાંઓ, દાસો, દાસીઓ તથા ઊંટોની ભેટ આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","પણ ઈશ્વર દ્વારા ઇબ્રામની પત્ની સારાયને લીધે ફારુન તથા તેના ઘર પર મહામરકી સહિત આફત આવી. ");
INSERT INTO guj2017_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ફારુને ઇબ્રામને બોલાવ્યો અને કહ્યું કે, “આ તેં મારી સાથે શું કર્યું છે? તેં મને કેમ ન કહ્યું કે, તે તારી પત્ની છે? ");
INSERT INTO guj2017_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","તેં શા માટે કહ્યું કે, ‘તે મારી બહેન છે?’ તેં એવું કર્યું એટલે મેં તેને મારી પત્ની કરી લીધી હતી. તો હવે, આ રહી તારી પત્ની. તેને લઈને તું તારે માર્ગે ચાલ્યો જા.” ");
INSERT INTO guj2017_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","પછી ફારુને તેના સરદારોને તેઓ સંબંધી આજ્ઞા આપી. તેથી તેઓએ ઇબ્રામને, તેની પત્નીને અને તેઓની સાથે સર્વ સંપત્તિને દેશની બહાર મોકલી આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","તેથી ઇબ્રામ તેની સ્ત્રી અને તેની સર્વ સંપત્તિને લઈને મિસરથી નેગેબમાં ગયો. લોત પણ તેઓની સાથે ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ઇબ્રામ પાસે જાનવરો, ચાંદી તથા સોનું પુષ્કળ પ્રમાણમાં હોવાથી તે ઘણો ધનવાન હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","નેગેબથી મુસાફરી કરીને જ્યાં તેણે અગાઉ છાવણી કરી હતી ત્યાં તે આવી પહોંચ્યો. આ જગ્યા બેથેલ તથા આયની વચ્ચે આવેલી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","અહીં તેણે અગાઉ વેદી બાંધી હતી. એ વેદી આગળ તેણે ઈશ્વરના નામે પ્રાર્થના કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","હવે લોત, જે ઇબ્રામની સાથે મુસાફરી કરી રહ્યો હતો, તેની પાસે પણ ઘેટાં, અન્ય જાનવરો તથા કુટુંબો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","તે દેશ એટલો બધો ફળદ્રુપ ન હતો કે તેઓ બન્ને એકસાથે રહી શકે, કેમ કે તેઓના પાલતું પશુઓની સંખ્યા ઘણી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","એવામાં ઇબ્રામના ગોવાળિયાઓ અને લોતના ગોવાળિયાઓની વચ્ચે ઝઘડો થયો. તે સમયે કનાનીઓ તથા પરિઝીઓ તે દેશમાં રહેતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","તેથી ઇબ્રામે લોતને કહ્યું, “તારી તથા મારી વચ્ચે અને તારા તથા મારા ગોવાળિયાઓની વચ્ચે તકરાર થવી ન જોઈએ; કારણ કે આપણે ભાઈઓ છીએ. ");
INSERT INTO guj2017_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","શું તારી આગળ આખો દેશ નથી? તું આગળ જા અને પોતાને મારાથી જુદો કર. જો તું ડાબી બાજુ જશે, તો હું જમણી બાજુ જઈશ. અથવા જો તું જમણી બાજુ જશે, તો પછી હું ડાબી બાજુ જઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","તેથી લોતે પોતાની આંખો ઊંચી કરીને યર્દનનો આખો પ્રદેશ સોઆર સુધી જોયો કે તેમાં બધે પુષ્કળ પાણી છે. ઈશ્વરે સદોમ તથા ગમોરાનો નાશ કર્યા અગાઉ તે દેશ ઈશ્વરની વાડીના જેવો તથા મિસર દેશના જેવો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","તેથી લોતે પોતાને સારુ યર્દનનો આખો પ્રદેશ પસંદ કર્યો. તે પૂર્વ તરફ ગયો. આમ ભાઈઓ એકબીજાથી અલગ થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ઇબ્રામ કનાન દેશમાં રહ્યો અને લોત તે સપાટ પ્રદેશવાળા નગરોમાં ગયો. તેણે સદોમ નગરમાં સ્થાયી વસવાટ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","હવે સદોમના માણસો ઈશ્વરની વિરુદ્ધ અતિ ભ્રષ્ટ તથા દુરાચારી હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ઇબ્રામથી લોત જુદો થયા પછી ઈશ્વરે ઇબ્રામને કહ્યું, “તું જ્યાં ઊભો છે ત્યાંથી પોતાની આંખો ઊંચી કરીને ઉત્તર, દક્ષિણ, પૂર્વ તથા પશ્ચિમ તરફ જો. ");
INSERT INTO guj2017_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","જે સર્વ પ્રદેશ તું જુએ છે, તે હું તને તથા તારા વંશજોને સદાને માટે આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","અને હું તારો વંશ પૃથ્વીની ધૂળની રજકણો જેટલો કરીશ. જો કોઈ માણસ ધૂળની રજકણોને ગણી શકે તો તે તારો વંશ ગણી શકે. ");
INSERT INTO guj2017_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ઊઠ, આ દેશની લંબાઈ તથા પહોળાઈની સરહદ સુધી ફર, કારણ કે તે દેશ હું તને આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","તેથી ઇબ્રામે પોતાનો તંબુ ઉઠાવીને મામરેનાં એલોન વૃક્ષો જે હેબ્રોનમાં છે ત્યાં સ્થાપિત કર્યો, ત્યાં તે રહ્યો અને ઈશ્વરને નામે એક વેદી બાંધી. ");
INSERT INTO guj2017_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","શિનઆરના રાજા આમ્રાફેલે, એલ્લાસારના રાજા આર્યોખે, એલામના રાજા કદોરલાઓમેરે અને ગોઈમના રાજા તિદાલે પોતાની કારકિર્દી દરમિયાન, ");
INSERT INTO guj2017_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","સદોમના રાજા બેરા, ગમોરાના રાજા બિર્શા, આદમાના રાજા શિનાબ, સબોઈમના રાજા શેમેબેર અને બેલા એટલે સોઆરના રાજાની સામે લડાઈ કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","એ પાંચ રાજાઓ સિદ્દીમની ખીણ જે હાલમાં ખારો સમુદ્ર છે તેમાં એકત્ર થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","બાર વર્ષ સુધી તેઓ કદોરલાઓમેરના તાબે રહ્યા હતા, પણ તેરમા વર્ષે તેઓએ બળવો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","પછી ચૌદમા વર્ષે કદોરલાઓમેર તથા જે રાજાઓ તેની સાથે હતા, તેઓએ આવીને આશ્તારોથ-કારનાઈમ દેશના રફાઈઓને, હામ દેશના ઝૂઝીઓને, શાવેહ કિર્યાથાઈમ દેશના એમીઓને, ");
INSERT INTO guj2017_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","હોરીઓ જે પોતાના સેઈર નામના પર્વતમાં રહેતા હતા તેઓના પર અરણ્ય પાસેના એલપારાન સુધી હુમલા કરીને મારતા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","પછી તેઓ પાછા ફર્યા અને એન-મિશ્પાટ એટલે કાદેશમાં આવ્યા અને અમાલેકીઓના આખા દેશને તથા હાસસોન-તામારમાં રહેનારા અમોરીઓને પણ તેઓએ હરાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","પછી સદોમનો રાજા, ગમોરાનો રાજા, આદમાનો રાજા, સબોઈમનો રાજા, બેલા એટલે સોઆરના રાજાએ યુદ્ધની તૈયારી કરીને, ");
INSERT INTO guj2017_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","એલામના રાજા કદોરલાઓમેર, ગોઈમના રાજા તિદાલ, શિનઆરના રાજા આમ્રાફેલ તથા એલ્લાસારના રાજા આર્યોખ, એ ચાર રાજાઓએ પેલા પાંચ રાજાઓની વિરુદ્ધ લડાઈ કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","હવે સિદ્દીમની ખીણોમાં ડામરના ઘણાં ખાડા હતા અને સદોમ તથા ગમોરાના રાજાઓ નાસી જઈને તેમાં પડ્યા. જે બાકી રહ્યા હતા તેઓ પહાડ તરફ નાસી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","પછી સદોમ તથા ગમોરામાંની ચીજવસ્તુઓ અને તેઓની સંપત્તિ લઈને પોતાને રસ્તે ચાલ્યા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","જયારે તેઓ ગયા, ત્યારે તેઓએ ઇબ્રામનો ભત્રીજો લોત, જે સદોમમાં રહેતો હતો, તેને પણ પકડીને તેની સર્વ સંપત્તિ લઈને તેઓ ચાલ્યા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","જે એક જણ બચી ગયો હતો તેણે આવીને હિબ્રૂ ઇબ્રામને ખબર આપી. તે વખતે ઇબ્રામ અમોરી મામરેનાં એલોન વૃક્ષ પાસે રહેતો હતો. મામરે ઇબ્રામના મિત્રો એશ્કોલ અને આનેરનો ભાઈ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","જયારે ઇબ્રામે સાંભળ્યું કે દુશ્મનોએ તેના સગાં સંબંધીઓને તાબે કર્યાં છે, ત્યારે તેણે પોતાના ઘરમાં જન્મેલા અને તાલીમ પામેલા ત્રણસો અઢાર પુરુષોને લઈને દાન સુધી સૈન્યનો પીછો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","તે રાત્રે તેણે તેઓની વિરુદ્ધ પોતાના માણસોના બે ભાગ પાડીને તેઓ પર હુમલો કર્યો અને દમસ્કસની ડાબી બાજુના હોબા સુધી તેઓનો પીછો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","પછી તે પોતાના સંબંધી લોતને, તેની સંપત્તિને, સ્ત્રીઓને તથા બીજા દાસોને પાછા લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","કદોરલાઓમેર તથા તેની સાથે જે રાજાઓ હતા, તેઓને હરાવીને ઇબ્રામ પાછો આવતો હતો ત્યારે તેને મળવા સારુ સદોમનો રાજા શાવેહની ખીણમાં એટલે રાજાની ખીણમાં આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","સાલેમનો રાજા મલ્ખીસદેક, રોટલી તથા દ્રાક્ષારસ લઈને આવ્યો. તે પરાત્પર ઈશ્વરનો યાજક હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","તેણે ઇબ્રામ આશીર્વાદ આપીને કહ્યું, “પરાત્પર ઈશ્વર, જે આકાશ તથા પૃથ્વીના ઉત્પન્નકર્તા છે તેમનાંથી ઇબ્રામ આશીર્વાદિત થાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","જે સર્વશ્રેષ્ઠ ઈશ્વરે તારા શત્રુઓને તારા હાથમાં સોંપ્યા છે, પરાત્પર ઈશ્વરની સ્તુતિ થાઓ.” પછી ઇબ્રામે સર્વ સંપત્તિમાંથી તેને દસમો ભાગ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","સદોમના રાજાએ ઇબ્રામને કહ્યું, “મને માણસો આપ અને પોતાને સારુ સંપત્તિ લઈ લે.” ");
INSERT INTO guj2017_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ઇબ્રામે સદોમના રાજાને કહ્યું, “પરાત્પર ઈશ્વર યહોવાહ કે, જેમણે આકાશ તથા પૃથ્વીને ઉત્પન્ન કર્યાં, તેમને મેં ગંભીરતાપૂર્વક વચન આપ્યું છે કે, ");
INSERT INTO guj2017_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","હું તારી પાસે સૂતળી કે ચંપલની દોરીનો ટુકડોય અથવા તારી અન્ય કોઈપણ વસ્તુ લઈશ નહિ, રખેને તું કહે કે, ‘મેં ઇબ્રામને આપ્યું તેથી તે ધનવાન થયો છે” ");
INSERT INTO guj2017_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","જુવાનોએ જે ખાધું છે તે હું સ્વીકારું છું, મારી સાથે જે ભાઈઓ આવ્યા તેઓને એટલે કે આનેર, એશ્કોલ તથા મામરેને તે મેળવેલી સંપત્તિમાંથી હિસ્સો આપજે.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","પછી ઈશ્વરના વચન દર્શનમાં ઇબ્રામ પાસે આવ્યું અને કહ્યું, “ઇબ્રામ, તું બીશ નહિ! હું તારી રક્ષા કરીશ તથા મોટું પ્રતિફળ આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ઇબ્રામે કહ્યું, “પ્રભુ ઈશ્વર, તમે મને શું આપશો? કેમ કે હું નિ:સંતાન છું અને મારા ઘરનો વારસ આ દમસ્કસનો એલીએઝેર બનશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ઇબ્રામે કહ્યું, “તમે મને હજી સુધી સંતાન આપ્યું નથી, માટે મારા ઘરનો કારભારી મારો વારસ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","પછી ઈશ્વરના વચન તેની પાસે આવ્યું અને કહ્યું, “એ તારો વારસ થશે નહિ, પણ તેના બદલે તારો જે પુત્ર જન્મશે તે જ તારો વારસ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","પછી ઈશ્વર ઇબ્રામને રાત્રે ઘરની બહાર આકાશ નીચે લઈ ગયા અને કહ્યું, “તું ઊંચે આકાશ તરફ જો અને ગણી શકે તો તારાઓ ગણ,” પછી તેમણે તેને કહ્યું, “એ તારાઓ જેટલાં તારા સંતાન થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","તેણે ઈશ્વર પર વિશ્વાસ કર્યો અને તેમણે તે તેના ન્યાયીપણાના અર્થે માન્ય રાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ઈશ્વરે તેને કહ્યું, “આ દેશ વતન તરીકે તને આપવા માટે ખાલદીઓના નગર ઉરમાંથી તને અહીં લઈ આવનાર ઈશ્વર હું છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","તેણે કહ્યું, “પ્રભુ ઈશ્વર, હું તેનો વારસો પામીશ, એની ખાતરી મને કેવી રીતે થાય?” ");
INSERT INTO guj2017_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","પછી તેમણે તેને કહ્યું, “મારે માટે ત્રણ વર્ષની એક વાછરડી, ત્રણ વર્ષની બકરી, ત્રણ વર્ષનું ઘેટું, એક હોલું અને કબૂતરનું બચ્ચું લે.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","તેણે એ સર્વ લીધાં, તેઓને વચ્ચેથી બે ભાગમાં કાપ્યા અને દરેકના અડધા ભાગને સામસામા મૂક્યા, પણ તેણે પક્ષીઓને કાપ્યાં નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","જયારે શિકારી પક્ષી તે મૃત દેહ ઉપર ધસી આવ્યાં ત્યારે ઇબ્રામે તેઓને ઉડાડી દીધાં. ");
INSERT INTO guj2017_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","પછી સૂર્ય આથમતો હતો ત્યારે ઇબ્રામ ભરનિદ્રામાં પડ્યો અને તેના પર ભયંકર અંધકાર આવી પડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","પછી ઈશ્વરે ઇબ્રામને કહ્યું, “તું નિશ્ચે જાણી લે કે, તારા વંશજો વિદેશમાં ભટકશે, ગુલામ બનશે અને તેઓ પર ચારસો વર્ષ સુધી જુલમ ગુજારવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","તેઓ જે લોકોની સેવા કરશે, તે લોકોનો ન્યાય હું કરીશ અને ત્યાર પછી તેઓ ઘણી સંપત્તિ લઈને ત્યાંથી મુક્ત થઈને બહાર આવશે. ");
INSERT INTO guj2017_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","પણ તું પોતાના પૂર્વજોની પાસે શાંતિએ જશે અને તું ઘણી વૃદ્ધ ઉંમરે મૃત્યુ પામશે અને દફનાવાશે. ");
INSERT INTO guj2017_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","તારા વંશજો ત્યાંથી ચોથી પેઢીમાં અહીં પાછા આવશે, કેમ કે અત્યારે અહીં રહેતા અમોરીઓના પાપનો ઘડો ત્યારે ભરાઈ જશે અથવા તેઓ શિક્ષાને પાત્ર થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","સૂર્ય આથમતાં અંધારું થયું, ત્યારે જુઓ, એક સળગતી સગડી તથા બળતી મશાલ એ ટુકડાંઓની વચ્ચેથી પસાર થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","તે જ દિવસે ઈશ્વરે ઇબ્રામ સાથે કરાર કરીને કહ્યું, “મિસરની નદીથી તે મોટી નદી ફ્રાત સુધી આ દેશ મેં તારા વંશજોને આપ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","કેનીઓનો, કનિઝીઓનો, કાદમોનીઓનો; ");
INSERT INTO guj2017_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","હિત્તીઓનો, પરિઝીઓનો, રફાઈઓનો; ");
INSERT INTO guj2017_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","અમોરીઓનો, કનાનીઓનો, ગિર્ગાશીઓનો તથા યબૂસીઓનો દેશ તેઓને આપ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","હવે ઇબ્રામની પત્ની સારાયને બાળકો થતાં ન હતાં. તેની એક મિસરી દાસી હતી. તેનું નામ હાગાર હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","તેથી સારાયે ઇબ્રામને કહ્યું, “જો, ઈશ્વરે મને બાળકો થવા દીધાં નથી. માટે તું મારી દાસી સાથે સૂઈ જા, કદાપિ તેનાથી હું બાળક પ્રાપ્ત કરું.” ઇબ્રામે સારાયનું કહ્યું માન્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ઇબ્રામ કનાન દેશમાં દસ વર્ષ રહ્યો પછી તેની પત્ની સારાયે તેની મિસરી દાસી હાગારને તેના પતિ ઇબ્રામને પત્ની તરીકે આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ઇબ્રામના હાગાર સાથેના સંબંધથી તે ગર્ભવતી થઈ. જયારે તેણે જાણ્યું કે હું ગર્ભવતી થઈ છું ત્યારે તેણે તેની શેઠાણીનો તિરસ્કાર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","પછી સારાયે ઇબ્રામને કહ્યું, “મારી સાથે આ ખોટું થયું છે. મેં મારી દાસી તને આપી અને જયારે ખાતરી થઈ કે તે ગર્ભવતી થઈ છે ત્યારે તેની દ્રષ્ટિમાં હું તુચ્છ થઈ છું. મારી અને તારી વચ્ચે ઈશ્વર ન્યાય કરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","“પણ ઇબ્રામે સારાયને કહ્યું, “તારી દાસી તારા અધિકારમાં છે, જે તને સારું લાગે તે તેને કર.” તેથી સારાયે તેની સાથે કઠોર વર્તાવ કર્યો. એટલે તેની પાસેથી હાગાર ભાગી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","અરણ્યમાં શૂરના માર્ગે પાણીનો જે ઝરો હતો તેની પાસે ઈશ્વરના દૂતે તેને જોઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","દૂતે તેને કહ્યું, “સારાયની દાસી હાગાર, તું ક્યાંથી આવી અને ક્યાં જઈ રહી છે?” અને તેણે કહ્યું, “મારી શેઠાણી સારાયની પાસેથી હું નાસી જઈ રહી છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ઈશ્વરના દૂતે તેને કહ્યું, “તું તારી શેઠાણી પાસે પાછી જા. અને તેની આધીનતામાં રહે.” ");
INSERT INTO guj2017_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","વળી ઈશ્વરના દૂતે તેને કહ્યું, “હું તારો વંશ ઘણો વધારીશ. તારા વંશમાં અસંખ્ય સંતાનો થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","દૂતે તેને એ પણ કહ્યું, “તું ગર્ભવતી છે. તું દીકરાને જન્મ આપશે. તેને તું ઇશ્માએલ નામ આપજે. કેમ કે ઈશ્વરે તારું દુઃખ સાંભળ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","તે માણસો મધ્યે જંગલના ગર્દભ જેવો થશે. તેનો હાથ દરેકની વિરુદ્ધ તથા દરેકનો હાથ તેની વિરુદ્ધ થશે અને તે પોતાના સર્વ ભાઈઓની વચ્ચે દુશ્મનાવટથી રહેશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","“પછી તેણે ઈશ્વર; જેઓ તેની સાથે વાત કરતા હતા તેમનું નામ “એલ-રોઈ” પાડ્યું, કેમ કે તેણે કહ્યું, “ઈશ્વરે મારા પર દ્રષ્ટિ કરી છે શું?” ");
INSERT INTO guj2017_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","તે માટે તે ઝરાનું નામ બેર-લાહાય-રોઈ રાખવામાં આવ્યું; તે કાદેશ તથા બેરેદની વચ્ચે આવેલો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","હાગારે ઇબ્રામના દીકરાને જન્મ આપ્યો અને ઇબ્રામે હાગારથી જન્મેલા તેના દીકરાનું નામ ઇશ્માએલ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","જયારે હાગારે ઇશ્માએલને જન્મ આપ્યો ત્યારે ઇબ્રામ છ્યાસી વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ઇબ્રામ નવાણું વર્ષનો થયો ત્યારે ઈશ્વરે તેને દર્શન આપીને કહ્યું, “હું સર્વસમર્થ ઈશ્વર છું, તું મારી આગળ ચાલ અને પ્રામાણિક થા. ");
INSERT INTO guj2017_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","પછી હું મારો કરાર મારી તથા તારી વચ્ચે કરીશ અને તારા વંશને ઘણો જ વધારીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ઇબ્રામ ભૂમિ સુધી નીચો નમ્યો. ઈશ્વરે તેની સાથે વાત કરતાં કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“જો, તારી સાથે મારો આ કરાર છે. તું ઘણી દેશજાતિઓનો પિતા થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","હવે તારું નામ ઇબ્રામ નહિ રહે, પણ તારું નામ ઇબ્રાહિમ થશે - કેમ કે ઘણી દેશજાતિઓના પિતા તરીકે મેં તારી પસંદગી કરી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","હું તને અતિશય સફળ કરીશ અને તારા વંશમાં ઘણી પ્રજા અને દેશજાતીઓ ઉત્પન્ન થશે. તેમાંથી રાજાઓ પણ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","તારો તથા તારા પછીના તારા વંશજોનો ઈશ્વર થવા સારુ, હું મારો કરાર સનાતન કરાર તરીકે મારી તથા તારી વચ્ચે અને પેઢી દર પેઢી તારાં વંશજોની વચ્ચે કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","જે દેશમાં તું રહે છે, તે આખો કનાન દેશ, હું તને અને તારા પછીના તારા વંશજોને કાયમી વતન તરીકે આપીશ. અને હું તેઓનો ઈશ્વર થઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ઈશ્વરે તેને કહ્યું, “તારે તથા તારા પછીના તારા વંશજોએ પેઢી દરપેઢી મારા એ કરારનું પાલન કરવાનું રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","મારી તથા તારી વચ્ચે અને તારા પછી તારા વંશજો વચ્ચે, મારો જે કરાર તમારે પાળવો, તે એ જ કે તમારામાંના દરેક પુરુષે પોતાની સુન્નત કરવી. ");
INSERT INTO guj2017_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","તમારે તમારી ચામડીની સુન્નત કરાવવી અને એ મારી અને તમારી વચ્ચેના કરારની નિશાની થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","તમારામાંના દરેક છોકરાંની તેના જન્મ પછી આઠમે દિવસે સુન્નત કરવી. એટલે તમારી સમગ્ર પેઢીમાંથી, જે દરેક નર બાળક તમારા ઘરમાં જન્મ્યો હોય તેની અને વિદેશી પાસેથી નાણાં આપી વેચાતો લીધો હોય પછી ભલે તે તમારા વંશનો ન હોય, તેની પણ સુન્નત કરવી. ");
INSERT INTO guj2017_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","જે તારા ઘરમાં જન્મેલો હોય અને જે તારા પૈસાથી વેચાતો લીધેલો હોય તેની સુન્નત જરૂર કરવી. આમ તો મારો કરાર તમારા શરીરમાં સનાતન કરાર તરીકે રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","દરેક પુરુષ જેના શરીરમાં સુન્નત કરવામાં આવી નહિ હોય તેને પોતાના લોકોમાંથી અલગ કરાશે. તેણે મારો કરાર તોડ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ઈશ્વરે ઇબ્રાહિમને કહ્યું, “તારી પત્ની સારાયને હવે પછી સારાય ન કહે. તેના બદલે, તેનું નામ સારા થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","હું તેને આશીર્વાદ આપીશ અને હું તેના દ્વારા તને દીકરો આપીશ. હું તેને આશીર્વાદ આપીશ અને તે દેશજાતિઓની માતા થશે. તેનાં સંતાનોમાંથી દેશજાતિઓના રાજાઓ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","પછી ઇબ્રાહિમ જમીન સુધી નમી પડીને હસ્યો અને પોતાના મનમાં બોલ્યો, “જે સો વર્ષનો છે તેને શું દીકરો થાય ખરો? નેવું વર્ષની સારાને શું દીકરો જન્મે ખરો?” ");
INSERT INTO guj2017_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ઇબ્રાહિમે ઈશ્વરને કહ્યું કે, “પ્રભુ ઇશ્માએલ તમારી સંમુખ જીવતો રહે એ જ અમારે માટે બસ છે!” ");
INSERT INTO guj2017_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ઈશ્વરે કહ્યું, “ના, પણ તારી પત્ની સારા તારા માટે એક દીકરાને જન્મ આપશે અને તું તેનું નામ ઇસહાક પાડશે. તેની સાથે તેના પછીના તેના વંશજોને માટે હું મારો કરાર સદાના કરાર તરીકે સ્થાપીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ઇશ્માએલ માટે, મેં તારું સાંભળ્યું છે. જો, મેં તેને આશીર્વાદ આપ્યો છે, હું તેને સફળ કરીશ અને તેને અતિ ઘણો વધારીશ. તે બાર કુળોના આગેવાનોનો પિતા થશે અને હું તેનાં સંતાનોની એક મોટી કોમ બનાવીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","વળી ઇસહાક કે જેને આવતા વર્ષે નિયુક્ત કરેલા સમયે સારા તારે સારુ જન્મ આપશે, ત્યારે હું તેની સાથે મારો કરાર સ્થાપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ઈશ્વરે ઇબ્રાહિમની સાથે વાત કરવાનું પૂરું કર્યું અને ઈશ્વર તેની પાસેથી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","પછી ઇબ્રાહિમે પોતાના દીકરા ઇશ્માએલને, પોતાના ઘરમાં જે સર્વ જન્મેલાં તેઓને તથા પોતાને પૈસે જે સર્વ વેચાતા લીધેલા, એવા ઇબ્રાહિમના કુટુંબોમાંના દરેક પુરુષને લઈને, જેમ તેને ઈશ્વરે કહ્યું હતું તેમ, તે જ દિવસે તેઓની સુન્નત કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","જયારે ઇબ્રાહિમની સુન્નત કરવામાં આવી ત્યારે તે નવસો નવાણું વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","અને તેના દીકરા ઇશ્માએલની સુન્નત કરવામાં આવી ત્યારે તે તેર વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ઇબ્રાહિમની તથા તેના દીકરા ઇશ્માએલની સુન્નત એક જ દિવસે થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","તેના ઘરના સર્વ પુરુષો જેઓ તેના ઘરમાં જન્મ્યા હતા તથા વિદેશીઓ પાસેથી પૈસે વેચાતા લીધેલા હતા તેઓની સુન્નત તેની સાથે થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","બપોરના સમયે જયારે ઇબ્રાહિમ તંબુના બારણામાં બેઠો હતો, ત્યારે ઈશ્વરે મામરેનાં એલોન વૃક્ષની પાસે તેને દર્શન આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","તેણે આંખો ઊંચી કરીને જોયું, તો ત્રણ પુરુષો તેની નજીક ઊભા હતા. જયારે તેણે તેઓને જોયા, ત્યારે તે તેઓને મળવાને તંબુના બારણામાંથી દોડ્યો અને જમીન સુધી નમીને તેઓને પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","તેણે કહ્યું, “હે મારા પ્રભુ, જો હવે હું તમારી દ્રષ્ટિમાં કૃપા પામ્યો હોઉં, તો તમે તમારા દાસ પાસેથી જતા રહેશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","હું થોડું પાણી લાવું છું તેથી તમે તમારા પગ ધુઓ અને આ વૃક્ષ નીચે તમે આરામ કરો. ");
INSERT INTO guj2017_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","હવે મને થોડું ભોજન લાવવા દો, કે જેથી તમે સ્ફૂર્તિ પામો. ત્યાર પછી તમે આગળ જજો, સારું તો હું તમારે માટે રોટલી લાવું.” અને તેઓએ કહ્યું, “તું કહે છે તે પ્રમાણે કર.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","પછી ઇબ્રાહિમ ઉતાવળે સારાની પાસે તંબુમાં ગયો અને કહ્યું, “જલ્દી કર. ત્રણ માપ મેંદો મસળ અને રોટલી તૈયાર કર.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","પછી ઇબ્રાહિમ દોડીને જ્યાં તેના જાનવર હતાં ત્યાં ગયો અને એક પુષ્ટ તથા કુમળું વાછરડું લાવીને નોકરને આપ્યું, જે તેને ઉતાવળે તૈયાર કરવા લાગ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","તેણે માખણ, દૂધ તથા ભોજન માટે જે રોટલી તથા વાછરડું તૈયાર કર્યું હતું તે લઈને તેઓની આગળ પીરસ્યાં. તેઓ જમતા હતા તે દરમિયાન તે તેઓની પાસે વૃક્ષ નીચે ઊભો રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","તેઓએ તેને કહ્યું, “તારી પત્ની સારા ક્યાં છે?” તેણે જવાબ આપ્યો, “ત્યાં, તંબુમાં છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","યહોવાહે તેને કહ્યું, “હું ચોક્કસ વસંતમાં તારી પાસે પાછો આવીશ અને જો, તારી પત્ની સારાને દીકરો થશે.” તેની પાછળ જે તંબુનું બારણું હતું, ત્યાંથી સારાએ તે વાત સાંભળી. ");
INSERT INTO guj2017_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","હવે ઇબ્રાહિમ તથા સારા વૃદ્ધ હતાં અને તેઓને ઘણાં વર્ષ થયાં હતાં. જે ઉંમરમાં સ્ત્રીઓ બાળકોને જન્મ આપે છે, તે ઉંમર, સારા વટાવી ચૂકી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","તેથી સારા મનોમન હસી પડી. તેણે ખુદને કહ્યું, “હું વૃદ્ધ થઈ ગઈ છું અને મારો પતિ પણ વૃદ્ધ છે, તો પછી કેવી રીતે પુત્ર જન્મે અને હર્ષ થાય?” ");
INSERT INTO guj2017_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ઈશ્વરે ઇબ્રાહિમને કહ્યું, “શા માટે સારા એમ કહેતાં હસી કે, ‘શું હું ખરેખર મારી વૃદ્ધાવસ્થામાં બાળકને જન્મ આપી શકીશ?’ ");
INSERT INTO guj2017_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ઈશ્વરને શું કંઈ અશક્ય છે? મેં નિયુક્ત કરેલા સમયે, વસંતમાં, હું તારી પાસે પાછો આવીશ. આવતા વર્ષના આ સમયે સારાને દીકરો થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","પછી સારાએ તે બાબતનો ઇનકાર કરીને કહ્યું, “હું તો હસી નથી, “કેમ કે તે ગભરાઈ હતી. તેમણે જવાબ આપ્યો, “ના, તું નિશ્ચે હસી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","પછી તે પુરુષો ત્યાંથી જવાને ઊઠ્યા અને સદોમ તરફ જોયું. ઇબ્રાહિમ તેઓને તેઓના રસ્તા સુધી વળાવવા તેઓની સાથે ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","પણ ઈશ્વરે કહ્યું, “જે હું કરવાનો છું તે શું હું ઇબ્રાહિમથી સંતાડું? ");
INSERT INTO guj2017_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","કેમ કે ઇબ્રાહિમથી નિશ્ચે એક મોટી તથા સમર્થ દેશજાતિ થશે અને તેના વંશમાં પૃથ્વીના સર્વ લોકો આશીર્વાદિત થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","મેં તેને પસંદ કર્યો છે તેથી તે તેના દીકરાઓને તથા તેના પછી થનાર તેના પરિવારને એવું સૂચન કરશે કે, તેઓ ન્યાયી થવા તથા ન્યાય કરવાને યહોવાહનો માર્ગ અપનાવે, તે માટે કે ઇબ્રાહિમ સંબંધી મેં જે કહ્યું છે, તે તેઓ પાળે.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","પછી ઈશ્વરે કહ્યું, “કેમ કે સદોમ તથા ગમોરાની ફરિયાદો ઘણી છે અને ત્યાં લોકોના પાપ ઘણાં ગંભીર છે, ");
INSERT INTO guj2017_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","માટે હું હવે, ત્યાં નીચે ઊતરીશ અને જોઈશ કે જે ફરિયાદ મારા સુધી પહોંચી છે તે પ્રમાણે તેઓ ભ્રષ્ટ થયા છે કે નહિ. જો એવું નહિ હોય તો મને માલૂમ પડશે. ");
INSERT INTO guj2017_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","તેથી તે પુરુષો ત્યાંથી વળીને સદોમ તરફ ગયા, પણ ઇબ્રાહિમ ઈશ્વરની સમક્ષ ઊભો રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","પછી ઇબ્રાહિમે પાસે આવીને કહ્યું, “શું તમે દુષ્ટોની સાથે ન્યાયીઓનો પણ નાશ કરશો? ");
INSERT INTO guj2017_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","કદાચ તે નગરમાં પચાસ ન્યાયી લોકો હોય, તો શું તમે તેનો નાશ કરશો અને ત્યાં એ પચાસ ન્યાયી છે તેને લીધે તેને નહિ બચાવો? ");
INSERT INTO guj2017_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","એવું કરવાનું તમે ટાળો. એટલે ભ્રષ્ટ લોકોની સાથે ન્યાયીઓને મારી નાખવા. અને દુષ્ટો જેવો જ વ્યવહાર ન્યાયીઓની સાથે થાય એવું તો તમે નહિ જ કરો! આખી પૃથ્વીના ન્યાયાધીશ શું ન્યાય નહિ કરશે?” ");
INSERT INTO guj2017_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ઈશ્વરે કહ્યું, “જો સદોમ નગરમાં મને પચાસ ન્યાયી મળશે, તો તેઓને સારુ હું નગરને બચાવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ઇબ્રાહિમે ઉત્તર આપ્યો અને કહ્યું, “મેં શું કર્યું છે? હું ધૂળ તથા રાખ હોવા છતાં મેં પ્રભુ ઈશ્વરની આગળ બોલવાની હિંમત કરી છે! ");
INSERT INTO guj2017_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","જો ત્યાં પચાસ ન્યાયીમાં પાંચ ઓછા હોય તો પાંચ ઓછા હોવાના લીધે શું તમે તે નગરનો નાશ કરશો?” અને તેમણે કહ્યું, “જો મને ત્યાં પિસ્તાળીસ ન્યાયી મળશે, તો પણ હું તેનો નાશ નહિ કરું.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","તેણે ફરી તેમની સાથે વાત કરી અને કહ્યું, “કદાચ ત્યાં ચાળીસ ન્યાયી મળે તો?” તેમણે ઉત્તર આપ્યો, “ચાળીસને લીધે પણ હું એમ નહિ કરું.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","તેણે કહ્યું, “કૃપા કરીને પ્રભુ, ગુસ્સે ના થાઓ તો હું બોલું. કદાચ ત્યાં ત્રીસ ન્યાયી મળે તો?” તેમણે ઉત્તર આપ્યો, “જો ત્યાં ત્રીસ ન્યાયી મળે તો પણ હું નગરને એવું કરીશ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","તેણે કહ્યું, “મેં પ્રભુ આગળ બોલવાની હિંમત કરી છે! કદાચ ત્યાં વીસ મળે તો. “તેમણે ઉત્તર આપ્યો, “વીસ ન્યાયીને લીધે પણ હું તેનો નાશ નહિ કરું.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","અંતે તેણે કહ્યું, “પ્રભુ, કૃપા કરીને ગુસ્સે ન થાઓ તો આ છેલ્લી વાર હું બોલું. કદાચ ત્યાં દસ ન્યાયી માણસો મળે તો?” તેમણે કહ્યું, “દસને લીધે પણ હું તેનો નાશ નહિ કરું.” ");
INSERT INTO guj2017_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ઇબ્રાહિમ સાથે વાત પૂરી કરી થઈ. તે સાથે જ ઈશ્વર તેમના માર્ગે ચાલ્યા ગયા અને ઇબ્રાહિમ તેના ઘરે પાછો ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","સદોમમાં સાંજે બે દૂત આવ્યા. ત્યારે લોત સદોમના પ્રવેશદ્વારે બેઠો હતો. લોત તેઓને જોઈને મળવા ઊઠ્યો અને સાષ્ટાંગ પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","તેણે કહ્યું, “મારા પ્રભુ, કૃપા કરો, હું તમને વિનંતી કરું છું કે તમારા દાસને ઘરે આવો, રાતવાસો કરો અને મારા મહેમાન થાઓ. પછી વહેલા ઊઠીને તમારા માર્ગે જજો.” અને તેઓએ કહ્યું, “ના, અમે તો આખી રાત નગરના ચોકમાં વિતાવીશુ.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","પણ તેણે તેઓને ઘણો આગ્રહ કર્યો તેથી તેઓ તેની સાથે ગયા અને તેના ઘરમાં પ્રવેશ કર્યો. તેણે ભોજન અને બેખમીરી રોટલી તૈયાર કરી અને તેઓ જમ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","પરંતુ તેઓના સૂઈ ગયા અગાઉ નગરના માણસોએ, એટલે સદોમ નગરના દરેક ભાગથી ધસી આવેલા વૃદ્ધો અને જુવાનો લોકોએ ઘરને ઘેરી લીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","તેઓએ લોતને બોલાવ્યો અને તેને કહ્યું, “જે માણસો આજ રાત્રે તારી પાસે આવ્યા તેઓ ક્યાં છે? તેઓને અમારી પાસે બહાર લાવ, કે અમે તેઓ પર બળાત્કાર કરીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","તેથી લોત બારણા બહાર તેઓની પાસે ગયો અને પછી તેણે પોતે તે બારણું બંધ કરી દીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","તેણે કહ્યું, “મારા ભાઈઓ, હું તમને વિનંતી કરું છું કે તમે એવું ખરાબ કામ કરશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","મારી બે દીકરીઓ છે. તેઓનો કોઈ પુરુષ સાથે સંબંધ થયેલો નથી. હું વિનંતી કરું છું કે મને તેઓને તમારી પાસે બહાર લાવવા દો અને તમારી દ્રષ્ટિમાં જે તમને સારું લાગે, તે તેઓને કરો, પણ જે માણસો મારા ઘરે મહેમાન તરીકે આવ્યા છે તેઓને કંઈ ન કરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","તેઓએ કહ્યું, “પાછો હટ!” તેઓએ એ પણ કહ્યું, “આ અહીં વિદેશીની જેમ રહેવાને આવ્યો હતો અને હવે તે આપણો ન્યાયાધીશ થવા બેઠો છે! હવે તેઓના કરતા અમે તારી સાથે વધારે ખરાબ વ્યવહાર કરીશું.” તેઓએ લોતને, ધક્કાધક્કી કરી અને દરવાજો તોડી નાખવા માટે નજીક આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","પણ અંદર રહેલા પુરુષોએ પોતાના હાથ લંબાવીને તેઓની પાસેથી લોતને ઘરમાં ખેંચી લીધો અને બારણું બંધ કરી દીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","અને ઘરના બારણા પાસે જે હતા, તે સર્વને અંધ બનાવી દીધા. તેઓ ઘરનું બારણું શોધતાં શોધતાં થાકી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","પછી તેઓએ લોતને કહ્યું, “અહીં તારી પાસે બીજા કોઈ છે? તારો જમાઈ, તારા દીકરાઓ, તારી દીકરીઓ તથા નગરમાં જે સર્વ તારાં હોય તેઓને, અહીંથી બહાર મોકલી દે. ");
INSERT INTO guj2017_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","અમે આ જગ્યાનો નાશ કરવાના છીએ, કારણ કે આ લોકોનાં ખરાબ કૃત્યો તેઓની વિરુદ્ધ ઈશ્વરની આગળ પુષ્કળ પ્રમાણમાં થયાં છે. તેથી તેઓનો નાશ કરવાને ઈશ્વરે અમને મોકલ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","લોત બહાર આવ્યો, એટલે તેની દીકરીઓ સાથે લગ્ન કરવાનું વચન આપનારા તેના જમાઈઓને કહ્યું, “જલ્દી, આ જગ્યાથી બહાર જતા રહો, કેમ કે ઈશ્વર આ નગરનો નાશ કરવાના છે.” પણ તેના જમાઈઓને એમ લાગ્યું કે તે મજાક કરે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","વહેલી સવારે દૂતોએ લોતને તાકીદ કરીને કહ્યું, “ઊઠ, તારી પત્નીને તથા તારી બે દીકરીઓ જે અહીં છે તેઓને લઈને નીકળી જા, જેથી નગરને થનારી સજામાં તું નાશ ન પામે.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","પણ તે વિલંબ કરતો હતો. તેથી તે દૂતોએ તેના, તેની પત્નીના અને તેની બે દીકરીઓના હાથ પકડ્યા, કેમ કે ઈશ્વર તેની પર દયાળુ હતા. તેઓ તેમને બહાર લાવ્યા અને તેઓને નગરની બહાર પહોંચાડ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","તેઓ તેમને બહાર લાવ્યા ત્યારે તે દૂતોમાંના એકે લોતને કહ્યું, “તું પોતાનો જીવ બચાવવા નાસી જા! પાછળ જોતો નહિ અને મેદાનમાં કોઈ જગ્યાએ રોકાતો નહિ. તારો નાશ ન થાય માટે પર્વત પર નાસી જજે.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","લોતે તેઓને કહ્યું, “ઓ, મારા પ્રભુ, એમ નહિ! ");
INSERT INTO guj2017_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","તમારો દાસ તમારી દ્રષ્ટિમાં કૃપા પામ્યો છે અને મારો જીવ બચાવવા માટે તમે મોટી કૃપા બતાવી છે. પરંતુ હું પર્વત પર પણ બચી શકતો નથી, કેમ કે મારા પર આફત આવશે અને હું મરણ પામીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","હવે જુઓ, નાસી જવાને માટે પેલું નાનું નગર પાસે છે. કૃપા કરીને મને ત્યાં નાસી જવા દો, કે જેથી મારો જીવ બચી જાય. ");
INSERT INTO guj2017_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","તેમણે તેને કહ્યું, “ઠીક છે, તારી આ વિનંતી હું માન્ય રાખું છું, તેં જે નગરનો ઉલ્લેખ કર્યો છે, તેનો નાશ હું નહિ કરું. ");
INSERT INTO guj2017_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ઉતાવળ કર! ત્યાં નાસી જા, કેમ કે તારા ત્યાં પહોંચ્યા સુધી હું કંઈ જ કરી શકતો નથી.” તે માટે તે નગરનું નામ સોઆર પડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","લોત સોઆર પહોંચ્યો ત્યારે પૃથ્વી પર સૂર્ય ઊગ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","પછી પ્રભુ ઈશ્વરે આકાશમાંથી સદોમ તથા ગમોરા પર ગંધક તથા આગ વરસાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","તેમણે તે નગરનો, સર્વ નીચાણનો, નગરમાં રહેનારાં સર્વનો તથા ભૂમિ પર ઊગેલી વનસ્પતિ નાશ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","પણ લોતની પત્ની જે તેની પાછળ હતી, તેણે પાછળ ફરીને જોયું અને તે જ ક્ષણે તે ક્ષારનો થાંભલો થઈ ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ઇબ્રાહિમ વહેલી સવારે ઊઠ્યો અને જે સ્થળે તે ઈશ્વરની આગળ ઊભો રહ્યો હતો ત્યાં તે આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","તેણે સદોમ તથા ગમોરાની તરફ અને આખા નીચાણના પ્રદેશ તરફ નજર કરી. તેણે જોયું, તો જુઓ, ભઠ્ઠીના ધુમાડાની પેઠે તે દેશનો ધુમાડો ઊંચે ફેલાતો જતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","આમ જ્યારે ઈશ્વરે તે મેદાનોના નગરોનો નાશ કર્યો, ત્યારે ઈશ્વરે ઇબ્રાહિમને યાદ કર્યો. જ્યાં લોત રહેતો હતો, તે નગરોનો નાશ તેમણે કર્યો, ત્યારે એવા નાશમાંથી તેમણે લોતને બહાર લાવીને બચાવી લીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","પણ લોત સોઆરમાંથી નીકળીને પોતાની બે દીકરીઓ સાથે પહાડમાં જઈને રહ્યો, કેમ કે સોઆરમાં રહેતાં તે બીતો હતો. તેથી તેણે પોતાની બે દીકરીઓ સાથે ગુફામાં વસવાટ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","મોટી દીકરીએ નાનીને કહ્યું, “આપણા પિતા વૃદ્ધ થયા છે અને દુનિયાની રીત પ્રમાણે આપણી સાથે સંબંધ બાંધવાને અહીં આ જગ્યા પર કોઈ પુરુષ નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ચાલ, આપણે આપણા પિતાને દ્રાક્ષાસવ પીવડાવીએ અને આપણે તેમની સાથે સૂઈ જઈએ, કે જેથી આપણે આપણા પિતાનો વંશ વધારીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","તેથી તેઓએ તે રાત્રે પોતાના પિતાને દ્રાક્ષાસવ પીવડાવ્યો. પછી મોટી દીકરી અંદર જઈને પોતાના પિતાની સોડમાં સૂઈ ગઈ; તે ક્યારે સૂઈ ગઈ અને તે ક્યારે ઊઠી, એની ખબર લોતને પડી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","બીજા દિવસે મોટી દીકરીએ નાનીને કહ્યું, “સાંભળ, ગઈ કાલે રાત્રે હું આપણા પિતાની સાથે સૂઈ ગઈ હતી. ચાલ આજે રાત્રે પણ આપણે તેમને દ્રાક્ષાસવ પીવડાવીએ અને તું પણ અંદર જઈને તેમની સોડમાં સૂઈ જા, કે જેથી આપણે આપણા પિતાનો વંશ વધારીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","તેઓએ તે રાત્રે પણ પિતાને દ્રાક્ષાસવ પીવડાવ્યો. પછી નાની દીકરી ઊઠીને તેની સોડમાં સૂઈ ગઈ. તે ક્યારે સૂઈ ગઈ અને ક્યારે ઊઠી, એની કશી ખબર લોતને પડી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","લોતની બન્ને દીકરીઓ પોતાના પિતા દ્વારા ગર્ભવતી થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","મોટી દીકરીએ એક દીકરાને જન્મ આપ્યો અને તેનું નામ મોઆબ રાખ્યું. તે આજ સુધીના મોઆબીઓનો પૂર્વજ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","એ જ પ્રમાણે નાનીએ પણ એક દીકરાને જન્મ આપ્યો અને તેનું નામ તેણે બેન-આમ્મી રાખ્યું. તે આજ સુધીના આમ્મોનીઓનો પૂર્વજ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ઇબ્રાહિમ મુસાફરી કરતા નેગેબ દેશ તરફ જઈને કાદેશ તથા શૂરની વચ્ચે રહ્યો. તેણે ગેરારમાં વિદેશી તરીકે વસવાટ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ઇબ્રાહિમે પોતાની પત્ની સારા વિષે કહ્યું, “તે મારી બહેન છે.” તેથી ગેરારના રાજા અબીમેલેખે માણસો મોકલીને સારાને બોલાવી લીધી. ");
INSERT INTO guj2017_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","પણ રાત્રે સ્વપ્નમાં ઈશ્વરે અબીમેલેખને કહ્યું, “તું પોતાને મરણ પામેલો જાણજે, કેમ કે જે સ્ત્રીને તેં પચાવી પાડી છે, તે એક પુરુષની પત્ની છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","હવે અબીમેલેખ તેની પાસે ગયો ન હતો અને તેણે કહ્યું, “પ્રભુ, શું તમે ન્યાયી લોકોનો પણ નાશ કરશો? ");
INSERT INTO guj2017_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","શું ઇબ્રાહિમે પોતે જ મને કહ્યું ન હતું કે, ‘તે મારી બહેન છે?’ વળી તે સ્ત્રીએ પોતે પણ કહ્યું હતું કે, ‘તે મારો ભાઈ છે.’ મેં મારા સાચા હૃદયથી તથા નિર્દોષ હાથથી આ કામ કર્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","પછી ઈશ્વરે સ્વપ્નમાં તેને કહ્યું, “હા, હું જાણું છું કે તેં તારા સાચા હૃદયથી આ કામ કર્યું છે અને મેં પણ તને મારી વિરુદ્ધ અપરાધ કરવાથી અટકાવ્યો છે. તેથી મેં તને તેને સ્પર્શવા માટે પરવાનગી આપી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","તેથી, તે માણસની પત્નીને તું પાછી આપ. કેમ કે તે પ્રબોધક છે. તે તારા માટે પ્રાર્થના કરશે અને તું જીવશે. પણ જો તું તેને પાછી નહિ આપે, તો જાણજે કે તું તથા તારા સર્વ લોકો નિશ્ચે મરણ પામશો.” ");
INSERT INTO guj2017_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","અબીમેલેખે વહેલી સવારે ઊઠીને પોતાના સર્વ ચાકરોને બોલાવ્યા. તેણે તેઓને આ સર્વ બાબતો કહી સંભળાવી અને તે માણસો ઘણાં ગભરાયા. ");
INSERT INTO guj2017_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","પછી અબીમેલેખે ઇબ્રાહિમને બોલાવીને કહ્યું, “આ તેં અમને શું કર્યું છે? મેં તારો શો અપરાધ કર્યો છે કે, તું મારા પર તથા મારા રાજ્ય પર મોટું પાપ લાવ્યો છે? જે કામ કરવા યોગ્ય ન હતું તે તેં મારા પ્રત્યે કર્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","અબીમેલેખે ઇબ્રાહિમને કહ્યું, “તને આવું કરવા કોણે પ્રેરણા આપી?” ");
INSERT INTO guj2017_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ઇબ્રાહિમે કહ્યું, “કેમ કે મને લાગ્યું, ‘નિશ્ચે આ જગ્યાએ ઈશ્વરનો ભય રખાતો નથી અને તેઓ મારી પત્નીના લીધે મને મારી નાખશે, એવું સમજીને મેં એમ કર્યું” ");
INSERT INTO guj2017_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","એક રીતે, તે મારી બહેન છે, એ સાચું છે, એટલે તે મારા પિતાની દીકરી છે, પણ મારી માતાની દીકરી નથી; અને તે મારી પત્ની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","જયારે ઈશ્વરે મને મારા પિતાનું ઘર છોડવાનું અને એક જગ્યાએથી બીજી જગ્યાએ મુસાફરી કરવાનું જણાવ્યું, ત્યારે મેં તેને કહ્યું, ‘મારી પત્ની તરીકે તું મને વિશ્વાસુ રહેજે: જે સ્થળે આપણે જઈએ ત્યાં તું મારા વિષે કહેજે, “આ મારો ભાઈ છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","પછી અબીમેલેખે ઇબ્રાહિમને ઘેટાં, બળદો, દાસો તથા દાસીઓ આપ્યાં અને તેણે તેની પત્ની સારા પણ તેને પાછી આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","અબીમેલેખે કહ્યું, “જો, મારો દેશ તારી આગળ છે. જ્યાં તને યોગ્ય લાગે ત્યાં રહે.” ");
INSERT INTO guj2017_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","સારાને પણ તેણે કહ્યું, “જો, મેં તારા ભાઈને હજાર ચાંદીના સિક્કા આપ્યાં છે. તે તારી સાથેના સર્વની આંખો આગળ તારે માટે પડદારૂપ છે અને દરેક વ્યક્તિની આગળ, તું સંપૂર્ણપણે સાચી ઠરી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","પછી ઇબ્રાહિમે ઈશ્વરને પ્રાર્થના કરી કે તેઓ અબીમેલેખને, તેની પત્નીને તથા તેની દાસીઓને સાજા કરે કે જેથી તેઓ બાળકોને જન્મ આપી શકે. ");
INSERT INTO guj2017_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","કેમ કે ઇબ્રાહિમની પત્ની સારાને કારણે ઈશ્વરે અબીમેલેખના ઘરમાંની તમામ સ્ત્રીઓનાં ગર્ભસ્થાન બંધ કર્યાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ઈશ્વરે જેમ કહ્યું હતું તેમ સારા પર તેમણે કૃપાદ્રષ્ટિ કરી અને ઈશ્વરે જે વચન સારાને આપ્યું હતું તે પ્રમાણે તેમણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","સારા ગર્ભવતી થઈ અને ઇબ્રાહિમને સારુ તેની વૃદ્ધાવસ્થામાં, જેમ ઈશ્વરે તેને કહ્યું હતું, તેમ નક્કી કરેલ સમયે તેણે દીકરાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ઇબ્રાહિમે સારાથી જન્મેલા દીકરાનું નામ ઇસહાક રાખ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ઈશ્વરે ઇબ્રાહિમને આપેલી આજ્ઞા અનુસાર તેણે પોતાનો દીકરો ઇસહાક આઠ દિવસનો થયો, ત્યારે તેની સુન્નત કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","જયારે તેનો દીકરો ઇસહાક જન્મ્યો ત્યારે ઇબ્રાહિમ સો વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","સારાએ કહ્યું, “ઈશ્વરે મને પ્રફુલ્લિત કર્યો છે; દરેક જે આ વાત સાંભળશે તેઓ મારી સાથે હસશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","તેણે એમ પણ કહ્યું, “ઇબ્રાહિમને કોણ કહેશે કે સારા છોકરાંને પોતાનું દૂધ પીવડાવશે? તેની વૃદ્ધાવસ્થામાં પણ મેં તેના માટે એક દીકરાને જન્મ આપ્યો છે!” ");
INSERT INTO guj2017_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","તે બાળક મોટો થયો અને તેને દૂધ છોડાવવામાં આવ્યું. ઇસહાકે જયારે દૂધ છોડ્યું તે દિવસે ઇબ્રાહિમે મોટી મિજબાની કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","પણ હાગાર મિસરીના દ્વારા ઇબ્રાહિમને જે દીકરો થયો હતો તેને સારાએ મશ્કરી કરતો જોયો. ");
INSERT INTO guj2017_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","તેથી તેણે ઇબ્રાહિમને કહ્યું, “આ દાસી તથા તેના દીકરાને કાઢી મૂક: કેમ કે આ દાસીનો દીકરો મારા દીકરા ઇસહાકની સાથે વારસનો ભાગીદાર થશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","આ વાત ઇબ્રાહિમને પોતાના દીકરાને લીધે ઘણી દુઃખદાયક લાગી. ");
INSERT INTO guj2017_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","પણ ઈશ્વરે ઇબ્રાહિમને કહ્યું, “આ બાળક તથા તારી દાસીને લીધે તું ઉદાસ થઈશ નહિ. આ બાબત વિશે જે સર્વ સારાએ તને કહ્યું છે, તે સાંભળ, કેમ કે તારો વંશ ઇસહાકથી ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","વળી તારી દાસીના દીકરાથી પણ હું એક દેશજાતિ ઉત્પન્ન કરીશ. કેમ કે તે પણ તારું સંતાન છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ઇબ્રાહિમ વહેલી સવારે ઊઠ્યો. તેણે રોટલી તથા પાણી ભરેલું એક પાત્ર લઈને હાગારના ખભા પર મૂક્યું. છોકરો તેને સોંપીને તેઓને વિદાય કર્યાં. હાગાર ત્યાંથી નીકળીને બેરશેબાના અરણ્યમાં ભટકતી ફરી. ");
INSERT INTO guj2017_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","રસ્તામાં પાત્રમાંનુ પાણી પૂરું થઈ ગયું ત્યારે તેણે છોકરાંને એક ઝાડ નીચે મૂક્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","પછી તે મીટર જેટલે અંતરે દૂર જઈને બેઠી, કેમ કે તેણે કહ્યું, “છોકરાનું મરણ હું કેવી રીતે જોઈ શકું?” બાળકની સામે બેસીને હાગારે ઊંચા અવાજે રુદન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ઈશ્વરે છોકરાનો અવાજ સાંભળ્યો. ઈશ્વરના દૂતે આકાશમાંથી હાગારને હાંક મારીને કહ્યું, “હાગાર, તને શું થયું છે? ગભરાઈશ નહિ, કેમ કે છોકરો જ્યાં છે ત્યાંથી ઈશ્વરે તેનો અવાજ સાંભળ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ઊઠ, છોકરાંને તારા હાથમાં ઊંચકી લે; કેમ કે ઈશ્વર તેનાથી એક મોટી દેશજાતિ ઉત્પન્ન કરવાનો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","પછી ઈશ્વરે તેની આંખો ઊઘાડી અને તેણે પાણીનો એક કૂવો જોયો. ત્યાં જઈને તેણે પાણીનું પાત્ર ભર્યું અને છોકરાંને પાણી પીવાને આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ઈશ્વર તે છોકરા સાથે હતા અને તે મોટો થયો. અરણ્યમાં રહીને તે ધનુર્ધારી થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","તે પારાનના અરણ્યમાં રહ્યો અને તેની માતાએ મિસર દેશની એક કન્યા સાથે તેનાં લગ્ન કરાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","અબીમેલેખ અને તેના સેનાપતિ ફીકોલે ઇબ્રાહિમને કહ્યું, “જે સર્વ તું કરે છે તેમાં ઈશ્વર તારી સાથે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","તે માટે હવે અહીં મારી આગળ ઈશ્વરની હજૂરમાં કહે કે, મારી સાથે, મારા દીકરા સાથે અને મારા વંશજો સાથે, તું દગો નહિ કરે. વળી તારી સાથે જ વિશ્વસનીય કરાર કર્યો છે તે પ્રમાણે મારી સાથે આ દેશ કે જેમાં તું રહે છે તેમાં વર્તજે.” ");
INSERT INTO guj2017_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","અને ઇબ્રાહિમે કહ્યું, “હું ઈશ્વરની હજૂરમાં સમ લઈને કહું છું કે એમ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","પછી અબીમેલેખના દાસોએ તેની પાસેથી પાણીનો જે કૂવો બળજબરીથી લઈ લીધો હતો તેના વિષે ઇબ્રાહિમે અબીમેલેખને ફરિયાદ કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","અબીમેલેખે કહ્યું, “એ કામ કોણે કર્યું છે, તે હું જાણતો નથી. આ પહેલાં તેં મને વાત કરી નથી અને આજ સુધી મેં તે વિષે સાંભળ્યું નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","તેથી ઇબ્રાહિમે ઘેટાં તથા અન્ય જાનવરો લાવીને અબીમેલેખને આપ્યાં અને તે બન્નેએ કરાર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","પછી ઇબ્રાહિમે ટોળાંમાંથી સાત ઘેટીઓ લઈને અલગ રાખી. ");
INSERT INTO guj2017_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","અબીમેલેખે ઇબ્રાહિમને પૂછ્યું, “તેં આ સાત ઘેટીઓ લઈને અલગ રાખી તેનો અર્થ શો છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","તેણે જવાબ આપ્યો, “આ સાત ઘેટીઓ મારા હાથથી તું લે કે જેથી આ કૂવો મેં ખોદ્યો છે તેના વિષે તેઓ મારે માટે સાક્ષી થાય.” ");
INSERT INTO guj2017_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","તે માટે તે જગ્યાનું નામ તેણે બેરશેબા આપ્યું, કેમ કે ત્યાં તે બન્નેએ ઈશ્વરની હજૂરમાં કરાર કર્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","આમ તેઓએ બેરશેબામાં કરાર કર્યો અને પછી અબીમેલેખ અને તેનો સેનાપતિ ફીકોલ પલિસ્તીઓના દેશમાં પાછા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ઇબ્રાહિમે બેરશેબામાં એક એશેલ વૃક્ષ રોપ્યું. ત્યાં તેણે સનાતન પ્રભુ ઈશ્વરની સ્તુતિ કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ઇબ્રાહિમ પલિસ્તીઓના દેશમાં ઘણાં દિવસો સુધી વિદેશીની જેમ રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ત્યાર બાદ ઈશ્વરે ઇબ્રાહિમની આધીનતાની કસોટી કરી. તેમણે તેને કહ્યું, “ઇબ્રાહિમ!” ઇબ્રાહિમે કહ્યું, “હું આ રહ્યો.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","પછી ઈશ્વરે કહ્યું, “તારો એકનો એક દીકરો, ઇસહાક, જેના પર તું ખૂબ પ્રેમ કરે છે, તેને લઈને મોરિયા દેશમાં જા. અને ત્યાંના પર્વતોમાંના હું તને બતાવું તે પર તું તેનું દહનીયાર્પણ કર.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","તેથી ઇબ્રાહિમ વહેલી સવારે ઊઠ્યો અને તેણે ગધેડા પર જીન બાંધ્યું. તેના બે યુવાન ચાકરોને તથા દીકરા ઇસહાકને તેની સાથે લીધા. દહનીયાર્પણને સારુ લાકડાં પણ લીધાં. ઈશ્વરે જે જગ્યા બતાવી હતી ત્યાં તેઓ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ત્રીજા દિવસે ઇબ્રાહિમે દૂરથી તે જગ્યાને નિહાળી. ");
INSERT INTO guj2017_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ઇબ્રાહિમે તેના જુવાનોને કહ્યું, “તમે અહીં ગધેડા પાસે રહો, હું તથા ઇસહાક ત્યાં ઉપર જઈશું. અમે અર્પણ કરીને તમારી પાસે પાછા આવીશું.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","પછી ઇબ્રાહિમે દહનીયાર્પણ માટેનાં લાકડાં ઊંચકી લેવા માટે પોતાના દીકરા ઇસહાકને આપ્યાં. તેણે પોતાના હાથમાં અગ્નિ તથા છરો લીધાં અને તેઓ બન્ને સાથે પર્વત પર ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ઇસહાકે તેના પિતા ઇબ્રાહિમને કહ્યું, “મારા પિતા” અને તેણે કહ્યું, “બોલ, મારા દીકરા, હું આ રહ્યો.” તેણે કહ્યું, “જુઓ, અહીં અગ્નિ તથા લાકડાં તો છે, પણ દહનીયાર્પણને માટે ઘેટું ક્યાં છે? ");
INSERT INTO guj2017_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ઇબ્રાહિમે કહ્યું, “મારા દીકરા, દહનીયાર્પણને સારુ ઈશ્વર પોતે ઘેટું પૂરું પાડશે.” અને તેઓ આગળ ચાલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","જે જગ્યા વિશે ઈશ્વરે તેમને કહ્યું હતું, ત્યાં તેઓ પહોંચ્યા ત્યારે ઇબ્રાહિમે ત્યાં વેદી બનાવી અને તેના પર લાકડાં ગોઠવ્યાં. પછી તેના દીકરા ઇસહાકને બાંધીને તેને વેદી પરનાં લાકડાં પર મૂક્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ઇબ્રાહિમે તેના દીકરાને મારવાને માટે હાથમાં છરો લીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","પછી તેણે છરો ઉગામ્યો એવામાં ઈશ્વરના દૂતે આકાશમાંથી તેને હાંક મારીને કહ્યું, “ઇબ્રાહિમ, ઇબ્રાહિમ!” અને તેણે કહ્યું, “બોલો, હું અહીં છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","દૂતે તેને કહ્યું, “તારા દીકરા પર તારો હાથ ઉગામીશ નહિ અને તેને કશી ઈજા કરીશ નહિ, કેમ કે મને ખાતરી થઈ છે કે તેં તારા એકનાએક દીકરાને, મારાથી પાછો રાખ્યો નથી. તું ઈશ્વરની બીક રાખે છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ઇબ્રાહિમે ઉપર જોયું અને ત્યાં એક ઘેટો જોયો. તેનાં શિંગડાં ઝાડીમાં ભરાયેલાં હતા. ઇબ્રાહિમે તેના દીકરાને બદલે એ ઘેટાંનું દહનીયાર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","પછી તેણે દહનીયાર્પણની એ જગ્યાનું નામ “યહોવાહ-યિરેહ “પાડ્યું.” તે આજ સુધી એ નામે ઓળખાય છે તેનો અર્થ એ છે કે, “ઈશ્વરના પર્વત પર ઈશ્વર પૂરું પાડે છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ઈશ્વરના દૂતે આકાશમાંથી ઇબ્રાહિમ સાથે ફરીથી વાત કરી, ");
INSERT INTO guj2017_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","અને કહ્યું કે, “આ ઈશ્વરની વાણી છે, “મેં પોતાના સમ ખાધા છે, તેં એ કામ કર્યું છે અને તારા એકનાએક દીકરાને તેં પાછો રાખ્યો નથી, ");
INSERT INTO guj2017_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","તેથી નિશ્ચે હું તને આશીર્વાદ આપીશ અને આકાશના તારા તથા સમુદ્ર કિનારાની રેતી જેટલાં તારાં સંતાન વધારીશ; અને તારાં સંતાન તેમના શત્રુઓના નગરના પ્રવેશદ્વારને કબજે કરશે. ");
INSERT INTO guj2017_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","તારા વંશજોથી પૃથ્વીના સર્વ લોક આશીર્વાદિત થશે, કેમ કે તેં મારું કહ્યું માન્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","પછી ઇબ્રાહિમ તથા ઇસહાક પોતાના જુવાન ચાકરો પાસે પાછા આવ્યા, ત્યાંથી તેઓ બેરશેબા આવ્યા અને ત્યાં રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","પછી ઇબ્રાહિમને જણાવવામાં આવ્યું કે, “તારા ભાઈ નાહોરની પત્ની મિલ્કાએ દીકરાઓને જન્મ આપ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","તેઓનાં નામ આ પ્રમાણે છે: તેનો મોટો દીકરો ઉસ, તેનો ભાઈ બૂઝ, પછી કમુએલ અરામનો પિતા, ");
INSERT INTO guj2017_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","કેસેદ, હઝો, પિલ્દાશ, યિદલાફ અને બથુએલ. ");
INSERT INTO guj2017_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","રિબકા બથુએલની દીકરી હતી. ઇબ્રાહિમના ભાઈ નાહોરને માટે મિલ્કાએ આ આઠ દીકરાઓને જન્મ આપ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","બથુએલની ઉપપત્ની, રઉમાએ પણ ચાર બાળકો ટેબા, ગાહામ, તાહાશ તથા માકાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","સારાના આયુષ્યનાં વર્ષો એકસો સત્તાવીસ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","તે કનાન દેશના હેબ્રોનમાં આવેલા કિર્યાથ-આર્બામાં મરણ પામી. ઇબ્રાહિમે સારાને માટે શોક પાળ્યો અને રુદન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","પછી ઇબ્રાહિમે સારાના મૃતદેહ પાસે ઊભા રહીને હેથના દીકરાઓને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“હું તમારી મધ્યે વિદેશી છું. કૃપા કરી મને મારી મૃત પત્નીને દફનાવવા માટે તમારા લોકોમાં જગ્યા આપો.” ");
INSERT INTO guj2017_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","હેથના દીકરાઓએ ઇબ્રાહિમને ઉત્તર આપ્યો, ");
INSERT INTO guj2017_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“મારા માલિક, અમારું સાંભળ. અમારી મધ્યે તો તું ઈશ્વરના રાજકુમાર જેવો છે. જે જગ્યા તને પસંદ પડે ત્યાં અમારી કોઈપણ કબરમાં તારી મૃત પત્નીને દફનાવ. તેને દફનાવવાને માટે અમારામાંથી કોઈપણ પોતાની કબર આપવાની ના નહિ પાડે.” ");
INSERT INTO guj2017_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ઇબ્રાહિમે ઊઠીને તે દેશના લોકોને, એટલે હેથના દીકરાઓને પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","તેણે તેઓની સાથે વાતચીત કરીને કહ્યું, “હું અહીં મારી મૃત પત્નીને દફનાવું, એવી જો તમારી સંમતિ હોય, તો મારું સાંભળો. મારે માટે સોહારના દીકરા એફ્રોનને વિનંતી કરો. ");
INSERT INTO guj2017_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","તેને પૂછો કે માખ્પેલાની ગુફા જે તેની પોતાની માલિકીની છે અને જે તેના ખેતરની સરહદ પર છે, તે પૂરતી કિંમતે તમારી મધ્યે કબરને માટે મને સુપ્રત કરે.” ");
INSERT INTO guj2017_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","હવે એફ્રોન હેથના દીકરાઓ સાથે જ બેઠેલો હતો. અને પોતાના નગરના દરવાજામાં પેસનારા હેથના સર્વ દીકરાઓના સાંભળતાં એફ્રોન હિત્તીએ ઇબ્રાહિમને ઉત્તર આપ્યો, ");
INSERT INTO guj2017_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“એવું નહિ, મારા માલિક. મારું સાંભળ. હું ખેતર અને તેમાં ગુફા છે તે પણ તને હું આપું છું. મારા લોકોના દીકરાઓના દેખતાં તે હું તને તારી મૃત પત્નીને દફનાવવા માટે આપું છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","પછી દેશના લોકોની આગળ ઇબ્રાહિમે પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","તેણે તે દેશના લોકોના સાંભળતાં એફ્રોનને કહ્યું, “પણ જો તારી મરજી હોય તો કૃપા કરી મારું સંભાળ. હું ખેતરને માટે કિંમત ચૂકવીશ. મારી પાસેથી રૂપિયા લે. ત્યાં હું મારી મૃત પત્નીને દફનાવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","એફ્રોને ઇબ્રાહિમને ઉત્તર આપ્યો, ");
INSERT INTO guj2017_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“કૃપા કરી, મારા માલિક, મારું સાંભળ. ચારસો શેકેલ ચાંદીના સિક્કાની જમીન, તે મારી અને તારી વચ્ચે શા લેખામાં છે? જા તારી મૃત પત્નીને ત્યાં દફનાવ.” ");
INSERT INTO guj2017_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ઇબ્રાહિમે એફ્રોનનું સાંભળ્યું અને તેણે હેથના દીકરાઓના સંભાળતાં કહ્યું હતું એટલા પ્રમાણમાં ચારસો શેકેલ ચાંદીના સિક્કા અંદાજે સાતસો એંસી રૂપિયા એફ્રોનને ચૂકવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","તેથી માખ્પેલામાં મામરેની આગળ એફ્રોનનું જે ખેતર, જે ગુફા તથા ખેતરની ચારે બાજુની સરહદની અંદર જે સર્વ વૃક્ષો તે, ");
INSERT INTO guj2017_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","તેના નગરના દરવાજામાં સર્વ જનારાંની આગળ હેથના દીકરાઓની હાજરીમાં ઇબ્રાહિમને વતનને માટે સોંપવામાં આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","તે પછી, ઇબ્રાહિમે કનાન દેશનું મામરે જે હેબ્રોન છે, તેની આગળ, માખ્પેલાના ખેતરની ગુફામાં પોતાની મૃત પત્ની સારાને દફનાવી. ");
INSERT INTO guj2017_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","હેથના દીકરાઓએ ઇબ્રાહિમને કબ્રસ્તાનને માટે, તે ખેતરનો તથા તેમાંની ગુફાનો કબજો આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ઇબ્રાહિમ વૃદ્ધ અને ઘણાં વર્ષનો થયો હતો અને ઈશ્વરે તેને સર્વ બાબતે પુષ્કળ આશીર્વાદ આપ્યાં હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","તેણે પોતાના ઘરના સર્વસ્વના કારભારી વરિષ્ઠ ચાકરને કહ્યું, “મારી જાંઘ નીચે તારો હાથ મૂક ");
INSERT INTO guj2017_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","અને પ્રભુ જે આકાશના તથા પૃથ્વીના ઈશ્વર છે, તેમના સોગન આપીને હું તને કહું છું કે, કનાનીઓ કે, જેઓમાં હું રહું છે તેઓની દીકરીઓમાંથી મારા દીકરાને સારુ તું પત્ની લાવીશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","પણ તું મારા દેશમાં મારા કુટુંબીઓ પાસે જા અને મારા દીકરા ઇસહાકને માટે કન્યા શોધી લાવ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ચાકરે તેને કહ્યું, “કદાચ તે કન્યા મારી સાથે આ દેશમાં આવવા રાજી ન હોય તો? તો શું જ્યાંથી તું આવ્યો છું તે દેશમાં તારા દીકરાને વસવા માટે હું લઈ જાઉં?” ");
INSERT INTO guj2017_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ઇબ્રાહિમે તેને કહ્યું, “ધ્યાન રાખ કે તું મારા દીકરાને ત્યાં લઈ જઈશ નહિ! ");
INSERT INTO guj2017_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","આકાશના પ્રભુ ઈશ્વર, જે મને મારા પિતાના ઘરમાંથી અને મારા સંબંધીઓના દેશમાંથી બહાર લાવ્યા અને જેમણે મને સોગન સાથે ખાતરીદાયક આપ્યું છે કે, ‘આ દેશ હું તારા સંતાનને આપીશ,’ તેઓ તારી આગળ પોતાના દૂતને મોકલશે અને ત્યાંથી તેઓ મારા દીકરાને માટે કન્યા મળે એવું કરશે. ");
INSERT INTO guj2017_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","તોપણ જો તે કન્યા તારી સાથે આવવાને રાજી ન હોય, તો તું મારા આ સમથી મુક્ત થશે. કેવળ મારા દીકરાને તું અહીંથી ત્યાં લઈ જઈશ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","તેથી ચાકરે પોતાના માલિક ઇબ્રાહિમને વચન આપ્યું અને તે વાત સંબંધી સમ ખાધા. ");
INSERT INTO guj2017_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","તે ચાકરે તેના માલિકનાં ઊંટોમાંથી દસ ઊંટ લીધાં અને તેના માલિક તરફથી વિવિધ પ્રકારની ઘણી ભેટો પણ પોતાની સાથે લીધી. તે લઈને તે રવાના થયો અને મુસાફરી કરીને અરામ-નાહરાઈમના નાહોરના શહેરમાં આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","સ્ત્રીઓના પાણી ભરવાના સમયે સંધ્યાકાળે તેણે ઊંટોને નગરની બહાર કૂવા પાસે બેસાડ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","પછી તેણે પ્રાર્થના કરી, “પ્રભુ, મારા માલિક ઇબ્રાહિમના ઈશ્વર, આજે મારું કામ સફળ કરો. મારા માલિક ઇબ્રાહિમ પર દયા કરો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","હું અહીં પાણીના ઝરા પાસે ઊભો છું અને નગરના માણસોની દીકરીઓ પાણી ભરવાને બહાર આવશે. ");
INSERT INTO guj2017_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ત્યારે એમ થવા દેજો કે જે યુવતીને હું એમ કહું કે, ‘કૃપા કરીને તારી ગાગર ઉતાર કે હું તેમાંથી પાણી પીઉં,’ ત્યારે તે મને એમ કહે કે, ‘પીઓ અને તમારા ઊંટોને પણ હું પાણી પીવડાવીશ,’ તે એ જ યુવતી હોય કે જેને તમે તમારા દાસ ઇસહાકને સારુ પસંદ કરેલી હોય. એનાથી મને ખાતરી થશે કે તમે મારા માલિક સાથે કરેલા કરાર અનુસાર વિશ્વાસુ વચનબદ્ધ રહેલા છો.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","તેની આ પ્રાર્થના પૂરી થયા અગાઉ રિબકા ખભા પર ગાગર સાથે ત્યાં આવી. રિબકા, ઇબ્રાહિમના ભાઈ નાહોરની પત્ની મિલ્કાના દીકરા બથુએલની દીકરી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","તે ઘણી સુંદર અને યુવાન હતી. કોઈ પુરુષ સાથે તેણે સંબંધ બાંધ્યો ન હતો. તે કૂવા પાસે આવી અને પોતાની ગાગર ભરીને નીચે ઊતરી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","તેને જોઈને ચાકર દોડીને તેની પાસે ગયો અને કહ્યું, “કૃપા કરીને તારી ગાગરમાંથી થોડું પાણી મને પીવા માટે આપ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","તેણે કહ્યું, “મારા માલિક, પીઓ,” અને તેણે ઉતાવળ કરીને પોતાની ગાગર હાથ પરથી ઉતારીને તેને પાણી પાયું. ");
INSERT INTO guj2017_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","તેને પાણી પીવડાવ્યા પછી તેણે કહ્યું, “તારાં ઊંટો પણ પાણી પી રહે ત્યાં સુધી હું તેમને સારું પાણી ભરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","પછી તેણે ઝડપથી પોતાની ગાગર હવાડામાં ખાલી કરી અને પાણી ભરવાને ફરીથી કૂવા તરફ દોડી. તેણે તેનાં સર્વ ઊંટોને માટે પાણી ભર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ઇબ્રાહિમના ચાકરે તેને જોઈ. ઈશ્વરે તેની મુસાફરી સફળ કરી છે કે નહિ, તે સમજવા માટે તે શાંત રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ઊંટો પાણી પી રહ્યાં પછી એમ થયું કે તે માણસે અડધા તોલાની સોનાની એક નથની અને તેના હાથને સારુ દસ તોલા સોનાની બે બંગડી બહાર કાઢી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","તેણે તેને પૂછ્યું, “તું કોની દીકરી છે? કૃપા કરી મને કહે કે શું અમારે માટે તારા પિતાના ઘરમાં ઉતારો મળી રહેશે?” ");
INSERT INTO guj2017_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","રિબકાએ તેને કહ્યું, “મિલ્કાનો દીકરો બથુએલ, જે નાહોરનો દીકરો છે, તેની હું દીકરી છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","વળી તેણે એ પણ કહ્યું, “અમારી પાસે ઘણો ઘાસચારો છે અને ઉતારાની જગ્યા પણ છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","પછી તે માણસે માથું નમાવીને ઈશ્વરની સ્તુતિ કરી, ");
INSERT INTO guj2017_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","અને કહ્યું, “મારા માલિક ઇબ્રાહિમના ઈશ્વર, જેમણે મારા માલિક સાથે કરેલા કરાર અનુસાર પોતાના વિશ્વાસુપણાનો તથા સત્યતાનો ત્યાગ કર્યો નથી, તેમની સ્તુતિ થાઓ. ઈશ્વર મારા માલિકના સગાંઓના ઘરે મને દોરી લાવ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","પછી તે યુવતી દોડીને ઘરે ગઈ અને તેની માતાને અને તેના કુટુંબીઓને એ વાત જણાવી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","રિબકાને એક ભાઈ હતો. તેનું નામ લાબાન હતું. લાબાન રસ્તાની બાજુ પરના પાણીના ઝરા પાસે ઊભેલા ઇબ્રાહિમના ચાકરની પાસે દોડી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","તેણે નથની તથા પોતાની બહેનના હાથમાં બંગડીઓ જોઈ. જયારે તેણે તેની બહેન રિબકાએ કહેલી વાત સાંભળી કે, “તે માણસે મને એમ કહ્યું છે,” ત્યારે તે તે માણસની પાસે ગયો. તે કૂવા પાસે ઊંટો સાથે ઊભો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","લાબાને કહ્યું, “તું ઈશ્વરથી આશીર્વાદિત છે, આવ, બહાર કેમ ઊભો છે? મેં તારા માટે ઉતારો તથા ઊંટોને સારુ જગ્યા તૈયાર કરી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","તેથી તે માણસ ઘરમાં આવ્યો અને તેણે ઊંટો પરનો સામાન ઉતાર્યો. લાબાને ઊંટોને ઘાસચારો અને તેને તથા તેના સાથી માણસોનો અતિથિ સત્કાર કર્યો અને પાણી આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","તેઓએ તેની આગળ જમવાનું પીરસ્યું, પરંતુ તેણે કહ્યું, “મારે જે કહેવાનું છે એ જણાવ્યાં અગાઉ હું જમીશ નહિ.” તેથી લાબાને કહ્યું, “બોલ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","તેણે કહ્યું, “હું ઇબ્રાહિમનો ચાકર છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ઈશ્વરે મારા માલિકને ઘણો આશીર્વાદ આપ્યો છે અને તે મહાન થયો છે. તેમણે તેને ઘેટાં, ઊંટો, ગધેડાં તથા અન્ય જાનવરો, ચાંદી, સોનું, દાસો અને દાસીઓ આપ્યાં છે. ");
INSERT INTO guj2017_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","મારા માલિકની પત્ની સારાએ તેની વૃદ્ધાવસ્થામાં દીકરાને જન્મ આપ્યો છે અને તેની પાસે જે છે તે બધું મારા માલિકે તેને આપ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","મારા માલિકે ઈશ્વરની સમક્ષતામાં મને એવું કહ્યું, ‘જે કનાનીઓના દેશમાં હું રહું છું તેઓની દીકરીઓમાંથી મારા દીકરાને સારુ તું પત્ની ન લાવ. ");
INSERT INTO guj2017_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","પણ મારા પિતાના ઘરે તથા મારા સગાંઓની પાસે તું જા અને મારા દીકરાને સારુ તું પત્ની લાવ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","મેં મારા માલિકને કહ્યું, ‘કદાચ તે કન્યા મારી સાથે આવે નહિ તો?’ ");
INSERT INTO guj2017_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","પણ તેણે મને કહ્યું, ‘જે ઈશ્વરની આગળ હું ચાલુ છું તેઓ તેમના દૂતને તારી સાથે મોકલશે અને તારો માર્ગ સફળ કરશે, કે જેથી મારાં સગાંઓમાંથી તથા મારા પિતાના ઘરમાંથી મારા દીકરાને સારુ તું કન્યા લાવી શકે. ");
INSERT INTO guj2017_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","પણ જો તું મારા કુટુંબીઓ પાસે જાય અને તેઓ ત્યાંથી તને કન્યા આપે નહિ, તો તું મારા સોગનથી છૂટો થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","તેથી આજે જયારે હું કૂવાની પાસે આવી પહોંચ્યો ત્યારે મેં પ્રાર્થના કરી, ‘મારા માલિક ઇબ્રાહિમના ઈશ્વર, કૃપા કરો, નિશ્ચે મારી મુસાફરીમાં જો તમે મને સફળતા આપવાના જ હોય, ");
INSERT INTO guj2017_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","તો હું અહીં કૂવા પાસે ઊભો છું. ત્યારે એવું થવા દો કે જે યુવતી અહીં પાણી ભરવા આવે અને તેને હું કહું, “કૃપા કરીને તારી ગાગરમાંથી થોડું પાણી મને પીવડાવ,” ");
INSERT INTO guj2017_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","અને તે યુવતી મને કહે, “પીઓ અને તમારા ઊંટોને સારુ પણ હું પાણી ભરીશ.” તે જ મારા માલિકના દીકરાને સારુ ઈશ્વરથી પસંદ કરાયેલી યુવતી હોય.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","હું પ્રાર્થના કરી રહ્યો તે પહેલાં, રિબકા ખભા પર ગાગર લઈને ત્યાં આવી અને તેણે કૂવા પાસે આવીને પાણી ભર્યું. તેથી મેં તેને કહ્યું, ‘કૃપા કરીને મને પાણી પીવડાવ” ");
INSERT INTO guj2017_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","તેણે ઉતાવળ કરીને ખભા પરથી ગાગર ઉતારીને કહ્યું, ‘પીઓ અને તમારા ઊંટોને પણ હું પાણી પીવડાવીશ.’ મેં પાણી પીધું અને તેણે ઊંટોને પણ પીવડાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","મેં તેને પૂછ્યું, ‘તું કોની દીકરી છે?’ તેણે કહ્યું, ‘હું મારા દાદાદાદી નાહોર અને મિલ્કાના દીકરા બથુએલની દીકરી છું.’ પછી મેં તેના નાકમાં નથની અને તેના બન્ને હાથમાં બંગડી પહેરાવી, ");
INSERT INTO guj2017_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","અને મેં સાષ્ટાંગ દંડવત પ્રણામ કરીને ઈશ્વરની આરાધના કરી અને મારા માલિક ઇબ્રાહિમના ઈશ્વર, જેમણે તેના દીકરાને સારુ મારા માલિકનાં સ્વજનોમાંથી કન્યા લેવા માટે મને સાચા માર્ગે દોરી લાવ્યા હતા તેમની સ્તુતિ કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","તે માટે, હવે, જો તમે મારા માલિકની સાથે વિશ્વાસ તથા કૃપાથી વર્તવાના હોય તો મને સંમતિ દર્શાવો, જો સંમત ના હો તો પણ મને જણાવો, કે જેથી હું પાછો વળું.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","પછી લાબાને તથા બથુએલે ઉત્તર આપ્યો, “એ વાત તો ઈશ્વરથી નક્કી થયેલી છે; અમે તને આમ કે તેમ કહી શકતા નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","હવે જો, રિબકા તારી સમક્ષ છે, તેને લગ્ન માટે લઈ જા, જેથી ઈશ્વરના કહ્યા પ્રમાણે તે તારા માલિકના દીકરાની પત્ની થાય.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ઇબ્રાહિમના ચાકરે તેઓની વાત સાંભળી ત્યારે તેણે સાષ્ટાંગ દંડવત પ્રણામ કરીને ઈશ્વરની સ્તુતિ કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","તે ચાકરે વસ્ત્રો અને ચાંદીના તથા સોનાના દાગીના રિબકાને આપ્યાં, તેના ભાઈને તથા તેની માતાને પણ કિંમતી ભેટો આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","પછી તેણે અને તેની સાથે જે માણસો હતા તેઓએ ખાધું પીધું. રાત્રે મુકામ કર્યો. તેઓ સવારે ઊઠ્યા, ત્યારે તેણે કહ્યું, “મને મારા માલિકને ત્યાં જવાને વિદાય કરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","રિબકાના ભાઈ તથા માતાએ કહ્યું, “રિબકાને અમારી સાથે ઓછામાં ઓછા દસેક દિવસ રહેવા દે. ત્યાર પછી તે આવશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","પણ તેણે તેઓને કહ્યું, “ઈશ્વરે મારો માર્ગ સફળ કર્યો છે, માટે તમે મને રોકશો નહિ. મને વિદાય કરો કે હું મારા માલિક પાસે જાઉં.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","તેઓએ કહ્યું, “અમે દીકરીને બોલાવીને તેને પૂછીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","તેથી તેઓએ રિબકાને બોલાવીને તેને પૂછ્યું, “શું તું આ માણસ સાથે જવા તૈયાર છે?” તેણે જવાબ આપ્યો, “હા હું જઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","તેથી તેઓએ પોતાની બહેન રિબકાને, તેની દાઈને, ઇબ્રાહિમના દાસને તથા તેના માણસોને વિદાય કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","તેઓએ રિબકાને આશીર્વાદ આપતા તેને કહ્યું, “અમારી બહેન, તું કરોડોની માતા થજે અને તારા વંશજો પોતાના વેરીઓના પ્રવેશદ્વારને કબજે કરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","પછી રિબકા તથા તેની દાઈઓ ઊઠીને ઊંટો પર બેઠી અને ઊંટો તે માણસની પાછળ ચાલ્યા. ચાકર રિબકાને લઈને પોતાને માર્ગે વળ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","હવે ઇસહાક બેર-લાહાય-રોઈને માર્ગે ચાલતો આવ્યો, કેમ કે તે નેગેબ દેશમાં રહેતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ઇસહાક સાંજે મનન કરવા માટે ખેતરમાં ગયો. ત્યારે તેણે પોતાની આંખો ઊંચી કરી તો તેણે ઊંટોને આવતાં જોયાં! ");
INSERT INTO guj2017_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","રિબકાએ નજર મિલાવીને જયારે ઇસહાકને જોયો, ત્યારે તે ઊંટ પરથી નીચે ઊતરી. ");
INSERT INTO guj2017_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","તેણે ચાકરને કહ્યું, “આ માણસ કોણ છે કે જે આપણને મળવાને ખેતરમાં આવે છે?” ચાકરે કહ્યું, “તે મારો માલિક છે.” તેથી તેણે પોતાના દુપટ્ટાથી મુખ પર આવરણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ચાકરે જે કર્યું હતું તે બધું તેણે ઇસહાકને કહી સંભળાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","પછી ઇસહાક તેને પોતાની માતા સારાના તંબુમાં લાવ્યો અને તેણે રિબકાનો ઓવારણાં લીધા. રિબકા ઇસહાકની પત્ની થઈ. ઇસહાકે તેના પર પ્રેમ દર્શાવ્યો. માતાના મરણ પછી રિબકાએ ઇસહાકને ખૂબ દિલાસો આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ઇબ્રાહિમે બીજી પત્ની સાથે લગ્ન કર્યા હતા. તેનું નામ કટૂરા હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","કટૂરાએ ઝિમ્રાન, યોકશાન, મદાન, મિદ્યાન, યિશ્બાક તથા શૂઆને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","શેબા તથા દેદાન એ યોકશાનના પુત્રો હતા. આશ્શૂરિમના લોકો, લટુશીમના લોકો તથા લઉમીમના લોકો દેદાનના વંશજો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","એફા, એફેર, હનોખ, અબીદા તથા એલ્દાહ એ મિદ્યાનના પુત્રો હતા. એ બધા કટૂરાના વંશજો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ઇબ્રાહિમે પોતાના વારસાની મિલકત ઇસહાકને આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","પણ પોતાની ઉપપત્નીના દીકરાઓને તેણે કેટલીક ચીજવસ્તુની બક્ષિસો આપીને તેઓને પોતાની તથા પોતાના દીકરા ઇસહાક પાસેથી પૂર્વ તરફના દેશમાં મોકલી દીધા. ");
INSERT INTO guj2017_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ઇબ્રાહિમે એકસો પંચોતેર વર્ષનું આયુષ્ય પૂરું કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","પછી ઘણી વૃદ્ધા ઉંમરે તે મરણ પામ્યો અને તે પોતાના પૂર્વજો સાથે મળી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","તેના દીકરા ઇસહાકે તથા ઇશ્માએલે માખ્પેલાની ગુફામાં, એટલે મામરેની નજીક સોહાર હિત્તીના દીકરા એફ્રોનના ખેતરમાં, તેને દફનાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","હેથના દીકરાઓ પાસેથી આ ખેતર ઇબ્રાહિમે વેચાતું લીધું હતું. તેમાં ઇબ્રાહિમને તેની પત્ની સારાની કબર પાસે દફનાવવામાં આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ઇબ્રાહિમના મરણ પછી, તેના દીકરા ઇસહાકને ઈશ્વરે આશીર્વાદ આપ્યો અને ઇસહાક બેર-લાહાય-રોઈ પાસે રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","હવે ઇબ્રાહિમનો દીકરો ઇશ્માએલ, જેને સારાની દાસી હાગાર મિસરીએ જન્મ આપ્યો હતો, તેની વંશાવળી આ પ્રમાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ઇશ્માએલના દીકરાઓનાં નામ તેઓની પેઢીઓ પ્રમાણે આ છે: ઇશ્માએલનો પ્રથમજનિત નબાયોથ, ત્યાર પછી કેદાર, આદબએલ, મિબ્સામ, ");
INSERT INTO guj2017_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","મિશમા, દુમા, માસ્સા, ");
INSERT INTO guj2017_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","હદાદ, તેમાં, યટુર, નાફીશ તથા કેદમા ઇશ્માએલના દીકરા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","તેઓનાં ગામો તથા મુકામો પ્રમાણે તેઓનાં નામ એ હતાં; તેઓના કુળોના બાર સરદારો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ઇશ્માએલનું આયુષ્ય એકસો સાડત્રીસ વર્ષનું હતું. પછી તે મરણ પામ્યો અને તેના પૂર્વજોની સાથે વિલીન થઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","હવીલાથી આશ્શૂર જતા મિસર દેશની સામેના શૂર સુધી તેઓ વસ્યા હતા. તેઓ તેમના ભાઈઓના વિરોધી હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ઇબ્રાહિમના દીકરા ઇસહાકની વંશાવળી આ છે: ઇબ્રાહિમ ઇસહાકનો પિતા હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ઇસહાકે અરામી લાબાનની બહેન પાદ્દાનારામના અરામી બથુએલની દીકરી રિબકા સાથે લગ્ન કર્યાં ત્યારે તે ચાળીસ વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ઇસહાકની પત્ની નિઃસંતાન હતી માટે તેણે તેને સારુ ઈશ્વરને પ્રાર્થના કરી. ઈશ્વરે તેની પ્રાર્થનાનો જવાબ આપ્યો અને તેની પત્ની રિબકા ગર્ભવતી થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","તેના પેટમાં છોકરાઓ ધક્કામુક્કી કરતા હતા. એટલે તેને થયું કે, “મારી સાથે આમ કેમ બન્યું?” તે વિષે તેણે ઈશ્વરને પૃચ્છા કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ઈશ્વરે તેને કહ્યું, “તારા પેટમાં બે કુળ છે અત્યારથી જ બે પ્રજાઓ અલગ થશે. એક પ્રજા બીજી પ્રજા કરતાં બળવાન થશે અને મોટો દીકરો નાનાનો દાસ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","જયારે તેની ગર્ભવસ્થાના દિવસો પૂરા થયા, ત્યારે તેના પેટમાં જોડિયા નર બાળકો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","જે પ્રથમ જન્મ્યો તેનો વર્ણ લાલ રુંવાટીવાળા વસ્ત્ર જેવો હતો. તેમણે તેનું નામ એસાવ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ત્યાર પછી એસાવની એડી હાથમાં પકડીને તેનો ભાઈ જન્મ્યો. તેનું નામ યાકૂબ પાડવામાં આવ્યું. તેણે તેઓને જન્મ આપ્યો ત્યારે ઇસહાક સાઠ વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","તે છોકરાઓ મોટા થયા. એસાવ કુશળ શિકારી તથા જંગલમાં ફરનાર માણસ હતો; પણ યાકૂબ શાંત પ્રકૃતિનો હતો. તે પોતાનો સમય તંબુમાં વિતાવતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","હવે ઇસહાક એસાવ પર પ્રેમ રાખતો હતો કેમ કે જે પશુઓનો તે શિકાર કરતો તે ઇસહાક ખાતો હતો. પણ રિબકા યાકૂબ પર પ્રેમ રાખતી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","એક દિવસે યાકૂબે શાક રાંધ્યું હતું, ત્યારે એસાવ ખેતરમાંથી આવ્યો. તે થાકેલો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","એસાવે યાકૂબને કહ્યું, “પેલા લાલ શાકમાંથી મને ખાવાને આપ કેમ કે હું થાકી ગયો છું!” તે માટે તેનું નામ અદોમ કહેવાયું. ");
INSERT INTO guj2017_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","યાકૂબે કહ્યું, “પહેલાં તું મને તારું જ્યેષ્ઠપણું વેચાતું આપ.” ");
INSERT INTO guj2017_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","એસાવે કહ્યું, “જો, હું મરવાની અણી પર છું. આ વરિષ્ઠપદ મારે કશા કામમાં આવવાનું નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","યાકૂબે કહ્યું, “પહેલા તું મારી આગળ સોગન લે.” એસાવે સોગન લીધા અને પોતાનું જ્યેષ્ઠપણું યાકૂબને વેચી દીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","યાકૂબે એસાવને રોટલી તથા મસૂરનું બનાવેલું શાક આપ્યાં. તેણે ખાધું, પીધું અને પછી તે ઊઠીને પોતાને રસ્તે ચાલ્યો ગયો. આ રીતે એસાવે પોતાની વરિષ્ઠતાને તુચ્છ ગણી. ");
INSERT INTO guj2017_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","હવે ઇબ્રાહિમના સમયમાં પહેલો દુકાળ પડ્યો હતો, તે ઉપરાંત તે દેશમાં બીજો દુકાળ પડ્યો, ત્યારે ઇસહાક પલિસ્તીઓના રાજા અબીમેલેખની પાસે ગેરારમાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ઈશ્વરે તેને દર્શન આપીને કહ્યું, “તું મિસરમાં ન જતો; જે દેશ વિશે હું તને કહીશ ત્યાં રહે. ");
INSERT INTO guj2017_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","આ દેશમાં તું પ્રવાસી થઈને રહે, હું તારી સાથે રહીશ અને તને આશીર્વાદ આપીશ; કેમ કે તને તથા તારા વંશજોને હું આ આખો દેશ આપીશ અને તારા પિતા ઇબ્રાહિમની આગળ મેં જે સોગન લીધા છે તે હું પૂરા કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","હું તારા વંશજોને વધારીને આકાશના તારાઓ જેટલા કરીશ અને આ સર્વ પ્રદેશો હું તારા વંશજોને આપીશ. પૃથ્વીનાં સર્વ કુળ તારાં સંતાનમાં આશીર્વાદ પામશે. ");
INSERT INTO guj2017_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","હું એમ કરીશ કેમ કે ઇબ્રાહિમે મારી વાણી માનીને મારું ફરમાન, મારી આજ્ઞાઓ, મારા વિધિઓ તથા મારા નિયમો પાળ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","તેથી ઇસહાક ગેરારમાં રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","જયારે ત્યાંના માણસોએ તેની પત્ની વિષે પૂછ્યું, ત્યારે તેણે કહ્યું, “તે મારી બહેન છે.” કેમ કે તે મારી પત્ની છે, એવું કહેતાં તે ગભરાતો હતો, રખેને ત્યાંના માણસો રિબકાને લીધે તેને મારી નાખે, કારણ કે તે રૂપાળી હતી.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","પછી ઇસહાક ત્યાં ઘણો સમય રહ્યો અને પલિસ્તીઓના રાજા અબીમેલેખે બારીએથી જોયું તો જુઓ, ઇસહાક અને તેની પત્ની રિબકાને લાડ કરતો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","અબીમેલેખે ઇસહાકને બોલાવીને કહ્યું, “જો, તે નિશ્ચે તારી પત્ની છે. તો પછી તું એમ કેમ બોલ્યો કે, ‘તે મારી બહેન છે?’ ઇસહાકે તેને કહ્યું, “મેં એવું વિચારેલું કે તેને પડાવી લેવા માટે કદાચ મને કોઈ મારી નાખે.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","અબીમેલેખે કહ્યું, “તેં આ અમને શું કર્યું છે? લોકોમાંથી કોઈપણ એક જણે તારી પત્ની સાથે સંબંધ બાંધ્યો હોત અને એવું કર્યાને લીધે તેં અમારી પાસે અપરાધ કરાવ્યો હોત.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","તેથી અબીમેલેખે સર્વ લોકોને ચેતવીને કહ્યું, “આ માણસને અથવા તેની પત્નીને નુકશાન કરનાર તે નિશ્ચે માર્યો જશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ઇસહાકે તે દેશમાં વાવણી કરી અને તે જ વર્ષે સો ગણી કાપણી કરી, કેમ કે ઈશ્વરે તેને આશીર્વાદ આપ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","તે ધનવાન થયો અને વૃદ્ધિ પામતાં ઘણો પ્રતિષ્ઠિત થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","તેની પાસે ઘણાં ઘેટાં તથા અન્ય જાનવર થયાં અને તેનું કુટુંબ પણ મોટું થયું. તેથી પલિસ્તીઓને તેના પ્રત્યે અદેખાઈ થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","તેથી તેના પિતા ઇબ્રાહિમના દિવસોમાં જે સર્વ કૂવા તેના પિતાના દાસોએ ખોદ્યા હતા તે પલિસ્તીઓએ માટીથી પૂરી દીધા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","અબીમેલેખે ઇસહાકને કહ્યું, “તું અમારી પાસેથી દૂર જા, કેમ કે તું અમારા કરતાં ઘણો બળવાન થયો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","તેથી ઇસહાક ત્યાંથી નીકળીને ગેરારના નીચાણમાં જઈને વસ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","તેના પિતા ઇબ્રાહિમના દિવસોમાં પાણીના જે કૂવા હતા જે તેના મરણ પછી પલિસ્તીઓએ પૂરી દીધા હતા, તે કૂવાઓ ઇસહાકે ફરીથી ખોદાવ્યા. તે કૂવાઓનાં જે નામ તેના પિતાએ રાખ્યા હતાં, તે જ નામ ઇસહાકે રાખ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","જયારે ઇસહાકના દાસોએ ખીણમાં ખોદ્યું ત્યારે તેઓને ત્યાં વહેતા પાણીનો એક કૂવો મળ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","“એ પાણી અમારું છે” એમ કહેતાં ગેરારના ઘેટાંપાળકો ઇસહાકના ઘેટાંપાળકો સાથે ઝઘડયા અને તેથી તે કૂવાનું નામ ઇસહાકે “એસેક” રાખ્યું, કેમ કે તેઓ તેની સાથે ઝઘડ્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","પછી તેઓએ બીજો કૂવો ખોદ્યો અને તે વિષે પણ તેઓ ઝઘડ્યા, તેથી તેણે તેનું નામ “સિટના” એટલે ગુસ્સાનો કૂવો રાખ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ત્યાંથી નીકળી જઈને તેણે બીજો કૂવો ખોદ્યો પણ તેને સારુ તેઓ ઝઘડયા નહિ. તેથી તેણે તેનું નામ રહોબોથ રાખ્યું જેનો અર્થ એ છે કે, ‘હવે ઈશ્વરે અમારા માટે જગ્યા કરી છે તેથી આ દેશમાં અમે સમૃદ્ધ થઈશું.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","પછી ઇસહાક ત્યાંથી બેરશેબા ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","તે જ રાત્રે તેને દર્શન આપીને ઈશ્વરે કહ્યું, “હું તારા પિતા ઇબ્રાહિમનો ઈશ્વર છું. બીશ નહિ, કેમ કે હું તારી સાથે છું, મારા સેવક ઇબ્રાહિમને લીધે હું તને આશીર્વાદ આપીશ અને તારો વંશ વધારીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ઇસહાકે ત્યાં વેદી બાંધી અને ઈશ્વર સાથે વાત કરી. ત્યાં તેણે તેનો તંબુ બાંધ્યો અને તેના દાસોએ એક કૂવો ખોદ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","પછી અબીમેલેખ ગેરારથી તેના મિત્ર અહુઝઝાથ તથા તેના સેનાપતિ ફીકોલ સાથે ઇસહાકની પાસે આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ઇસહાકે તેઓને કહ્યું, “તમે મને નફરત કરો છો અને તમારી પાસેથી મને દૂર મોકલી દીધો છે છતાં તમે મારી પાસે કેમ આવ્યા છો?” ");
INSERT INTO guj2017_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","તેઓએ કહ્યું, “અમે સ્પષ્ટ રીતે જોયું છે કે ઈશ્વર તારી સાથે છે. તેથી અમે નક્કી કર્યું કે, આપણી વચ્ચે, હા, તારી તથા અમારી વચ્ચે પ્રતિજ્ઞા કરવામાં આવે અને અમે તારી સાથે કરાર કરીએ, ");
INSERT INTO guj2017_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","જેમ અમે તારું નુકસાન કર્યું નથી, તારી સાથે સારો વ્યવહાર કર્યો છે અને શાંતિથી તને વિદાય કર્યો, તેમ તું અમારું નુકસાન ન કર. નિશ્ચે, તું ઈશ્વરથી આશીર્વાદિત છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","તેથી ઇસહાકે તેઓને સારુ મિજબાની કરી, તેઓ જમ્યા અને દ્રાક્ષાસવ પીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","તેઓએ વહેલી સવારે ઊઠીને એકબીજા સાથે પ્રતિજ્ઞા કરી. પછી ઇસહાકે તેઓને વિદાય કર્યા અને તેઓ તેની પાસેથી શાંતિએ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","તે જ દિવસે ઇસહાકના દાસોએ જે કૂવો ખોદ્યો હતો, તે વિષે તેઓએ આવીને કહ્યું, “અમને પાણી મળ્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","તેણે કૂવાનું નામ શિબા રાખ્યુ, તેથી આજ સુધી તે નગરનું નામ બેરશેબા છે. ");
INSERT INTO guj2017_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","જયારે એસાવ ચાળીસ વર્ષનો થયો ત્યારે તેણે હિત્તી બેરીની દીકરી યહૂદીથ તથા હિત્તી એલોનની દીકરી બાસમાથ સાથે લગ્ન કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","પણ આ સ્ત્રીઓએ ઇસહાક તથા રિબકાને દુઃખી કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","જયારે ઇસહાક વૃદ્ધ થયો અને તેની આંખોનું તેજ એટલું બધું ઘટ્યું કે તે નિહાળી શકતો ન હતો. ત્યારે તેણે પોતાના મોટા દીકરા એસાવને બોલાવીને કહ્યું, “મારા દીકરા.” તેણે તેને કહ્યું, “બોલો પિતાજી.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","તેણે કહ્યું, “અહીં જો, હું વૃદ્ધ થયો છું. મારા મરણનો દિવસ હું જાણતો નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","તે માટે તારાં હથિયાર, એટલે તારા બાણનો ભાથો અને તારું ધનુષ્ય લઈને જંગલમાં જા. મારા માટે શિકાર કર. ");
INSERT INTO guj2017_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","મને પસંદ છે તેવું સ્વાદિષ્ટ ભોજન મારે માટે તૈયાર કર અને મારી પાસે લાવ કે, તે હું ખાઉં અને હું મરણ પામું તે પહેલાં તને આશીર્વાદ આપું.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","હવે જયારે ઇસહાક તેના દીકરા એસાવની સાથે વાત કરતો હતો ત્યારે રિબકાએ તે સાંભળ્યું હતું. એસાવ શિકાર કરી લાવવા માટે જંગલમાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ત્યારે રિબકાએ તેના નાના દીકરા યાકૂબને કહ્યું, “જો, તારા ભાઈ એસાવની સાથે તારા પિતાને મેં વાત કરતા સાંભળ્યા છે. તેમણે કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘તું શિકાર લાવીને મારે સારુ સ્વાદિષ્ટ ભોજન તૈયાર કર, કે હું તે ખાઉં અને હું મરણ પામું તે અગાઉ ઈશ્વરની હજૂરમાં તને આશીર્વાદ આપું” ");
INSERT INTO guj2017_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","માટે, મારા દીકરા, હું તને જે આજ્ઞા કરું તે પ્રમાણે મારું કહેવું માન. ");
INSERT INTO guj2017_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","તું આપણાં ટોળાંમાંથી ઘેટાંબકરાંનાં બે સારાં લવારાં મારી પાસે લઈ આવ. તેનું હું તારા પિતાને ભાવતું સ્વાદિષ્ટ ભોજન તેમને માટે બનાવી આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","તે તું તારા પિતા આગળ લઈ જજે, કે જેથી તે ખાઈને તેમના મરણ અગાઉ તને આશીર્વાદ આપે.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","યાકૂબે તેની માતા રિબકાને કહ્યું, “મારો ભાઈ એસાવ રુંવાટીવાળો માણસ છે અને હું સુંવાળો છું. ");
INSERT INTO guj2017_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","કદાચ મારો પિતા મને સ્પર્શ કરે અને હું પકડાઈને તેમને છેતરનાર જેવો માલૂમ પડું તો મારા પર આશીર્વાદને બદલે શાપ નહિ આવી પડે? ");
INSERT INTO guj2017_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","તેની માતાએ તેને કહ્યું, “મારા દીકરા, તે શાપ મારા પર આવો. માત્ર મારું કહેવું માન અને જઈને લવારાં લઈ આવ.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","તેથી યાકૂબ ગયો અને લવારાં લઈને તેની માતાની પાસે આવ્યો; તેની માતાએ તેના પિતાને ભાવતું હતું તેવું સ્વાદિષ્ટ ભોજન બનાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","રિબકાએ તેના જયેષ્ઠ દીકરા એસાવનાં સારાં વસ્ત્ર જે તેની પાસે ઘરમાં હતાં તે લઈને તેના નાના દીકરા યાકૂબને પહેરાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","તેણે તેના બન્ને હાથ પર તથા તેના ગળાના સુંવાળા ભાગ પર લવારાનાં ચર્મ વીંટાળી દીધાં. ");
INSERT INTO guj2017_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","વળી તેણે તૈયાર કરેલું સ્વાદિષ્ટ ભોજન રોટલી તથા શાક તેના દીકરા યાકૂબના હાથમાં આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","યાકૂબે તેના પિતા પાસે જઈને કહ્યું, “મારા પિતા.” તેણે કહ્યું, “મારા દીકરા, હું આ રહ્યો, તું કોણ છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","યાકૂબે તેના પિતાને કહ્યું, “હું એસાવ તમારો જયેષ્ઠ દીકરો છું; તમારું કહ્યા પ્રમાણે મેં કર્યું છે. હવે, બેઠા થઈને મારો શિકાર ખાઓ અને મને આશીર્વાદ આપો.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ઇસહાકે તેના દીકરાને કહ્યું, “મારા દીકરા, તને આટલો જલ્દી શિકાર કેવી રીતે મળ્યો?” તેણે કહ્યું, “કેમ કે ઈશ્વર તારા પ્રભુ, તેને મારી પાસે લાવ્યા.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ઇસહાકે યાકૂબને કહ્યું, “મારા દીકરા, મારી નજીક આવ જેથી હું તને સ્પર્શ કરું અને જાણું કે તું જ મારો સાચો દીકરો એસાવ છે કે નહિ? ");
INSERT INTO guj2017_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","યાકૂબ તેના પિતા ઇસહાકની પાસે આવ્યો; ઇસહાકે તેને સ્પર્શીને કહ્યું, “આ અવાજ તો યાકૂબનો અવાજ છે પણ હાથ તો એસાવના છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","તેના હાથ તેના ભાઈ એસાવના જેવા રુંવાટીવાળા હતા માટે ઇસહાક તેને ઓળખી શક્યો નહિ, તેથી તેણે તેને આશીર્વાદ આપવાનું નક્કી કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","તેણે કહ્યું, “શું તું નિશ્ચે મારો દીકરો એસાવ જ છે?” અને તેણે કહ્યું, “હા, હું એ જ છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ઇસહાકે કહ્યું, “એ ભોજન મારી પાસે લાવ એટલે હું તારો શિકાર ખાઉં અને તને આશીર્વાદ આપું.” યાકૂબ તેની પાસે ભોજન લાવ્યો. ઇસહાકે ખાધું અને યાકૂબ તેના માટે જે દ્રાક્ષાસવ લાવ્યો હતો તે પણ તેણે પીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","પછી તેના પિતા ઇસહાકે તેને કહ્યું, “મારા દીકરા, હવે પાસે આવ અને મને ચુંબન કર. ");
INSERT INTO guj2017_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","યાકૂબે તેની પાસે આવીને તેને ચુંબન કર્યું. તેણે તેનાં વસ્ત્રોની સુગંધ લીધી અને તેને આશીર્વાદ આપીને કહ્યું, “જો, ઈશ્વરથી આશીર્વાદ પામેલા ખેતરની સુગંધ જેવી મારા દીકરાની સુગંધ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","માટે ઈશ્વર તને આકાશનું ઝાકળ. પૃથ્વીની રસાળ જગ્યા, પુષ્કળ ધાન્ય તથા નવો દ્રાક્ષારસ આપો. ");
INSERT INTO guj2017_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","લોકો તારી સેવા કરે અને દેશજાતિઓ તારી આગળ નમે. તું તારા ભાઈઓનો માલિક થા અને તારી માતાના દીકરા તારી આગળ નમો. જે દરેક તને શાપ આપે, તે શાપિત થાય. જે તને આશીર્વાદ આપે, તે આશીર્વાદ પામે.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ઇસહાક યાકૂબને આશીર્વાદ આપી રહ્યો પછી યાકૂબ પોતાના પિતા ઇસહાકની આગળથી છાનોમાનો બહાર ગયો અને એ જ સમયે તેનો ભાઈ એસાવ શિકાર કરીને પાછો આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","પણ સ્વાદિષ્ટ ભોજન તૈયાર કરીને તેના પિતાની પાસે લાવ્યો અને તેના પિતાને કહ્યું, “મારા પિતા ઊઠીને તારા દીકરાનો શિકાર ખાઓ, કે જેથી તમે મને આશીર્વાદ આપો.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","તેના પિતા ઇસહાકે તેને કહ્યું, “તું કોણ છે?” તેણે કહ્યું, “હું તારો જ્યેષ્ઠ દીકરો એસાવ છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ઇસહાક બહુ ધ્રૂજી ઊઠ્યો અને બોલ્યો, “ત્યારે જે શિકાર મારીને મારી પાસે લાવ્યો હતો તે કોણ હતો? તારા આવ્યા અગાઉ તે સર્વમાંથી મેં ખાધું અને મેં તેને આશીર્વાદ આપ્યો. તે આશીર્વાદિત થશે પણ ખરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","જયારે એસાવે પોતાના પિતાની વાત સાંભળી, ત્યારે તે મોટી તથા બહુ કારમી બૂમ પાડીને રડ્યો અને પોતાના પિતાને કહ્યું, “મારા પિતા, મને હા મને પણ, આશીર્વાદ આપ.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ઇસહાકે કહ્યું, “તારા ભાઈએ કપટ કર્યું છે. તેણે આવીને તારો આશીર્વાદ લઈ લીધો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","એસાવે તેને કહ્યું, “શું તેનું નામ યાકૂબ ઠીક નથી પાડ્યું? તેણે મને બે વાર છેતર્યો છે. તેણે મારું જ્યેષ્ઠપણું લઈ લીધું. અને જો, હવે તેણે મારો આશીર્વાદ પણ લઈ લીધો છે.” અને તેણે પૂછ્યું, “શું તેં મારા માટે આશીર્વાદ રાખ્યો નથી?” ");
INSERT INTO guj2017_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ઇસહાકે ઉત્તર આપીને એસાવને કહ્યું, “જો, મેં તેને તારો માલિક બનાવ્યો છે અને તેના સર્વ ભાઈઓ તેના દાસો થવાને માટે મેં તેને આપ્યાં છે. અને મેં તેને પોષણને માટે ધાન્ય તથા દ્રાક્ષારસ આપ્યાં છે. મારા દીકરા, હું તારે સારુ શું કરું?” ");
INSERT INTO guj2017_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","એસાવે પોતાના પિતાને કહ્યું, “મારા પિતા, મને આપવા માટે શું તારી પાસે એકપણ આશીર્વાદ બાકી રહ્યો નથી? મારા પિતા, મને, હા મને પણ આશીર્વાદ આપ.” અને એસાવ પોક મૂકીને રડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","તેના પિતા ઇસહાકે તેને ઉત્તર આપતા કહ્યું, “જો, જ્યાં તું રહે છે તે પૃથ્વીના ભરપૂરીપણાથી તથા ઉપરના આકાશના ઝાકળથી તારે દૂર રહેવાનું થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","તું તારી તલવારથી જીવશે. તારે તારા ભાઈની સેવા કરવી પડશે. પણ જયારે તું તેની સામે થશે, ત્યારે તું તારી ગરદન પરથી તેની ઝૂંસરી ફગાવી દઈ શકશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","યાકૂબને તેના પિતાએ આશીર્વાદ આપ્યો હતો તેને લીધે એસાવે યાકૂબનો દ્વેષ કર્યો. એસાવે પોતાના મનમાં કહ્યું, “મારા પિતાને માટે શોકના દિવસો પાસે છે; એ પૂરા થયા પછી હું મારા ભાઈ યાકૂબને મારી નાખીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","રિબકાને તેના જ્યેષ્ઠ દીકરા એસાવની એ વાત જણાવવામાં આવી. તેથી તેણે પોતાના નાના દીકરા યાકૂબને બોલાવડાવ્યો અને તેને કહ્યું, “જો, તારો ભાઈ એસાવ તને મારી નાખે એવું જોખમ તારે માથે છે. તેના મનમાં એવા વિચારો ચાલે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","માટે હવે, મારા દીકરા, મારી વાત માન અને ઊઠીને મારા ભાઈ લાબાનની પાસે હારાનમાં નાસી જા. ");
INSERT INTO guj2017_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","તારા ભાઈનો ક્રોધ તારા પરથી ઊતરે નહિ ત્યાં સુધી થોડા દિવસ તેની પાસે રહેજે. ");
INSERT INTO guj2017_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","તારા ભાઈનો ક્રોધ તારા પરથી ઊતરે અને તેને તેં જે કર્યું છે તે ભૂલી જાય, ત્યારે હું તને ત્યાંથી બોલાવીશ. શા માટે હું તમને બન્નેને એક જ દિવસે ગુમાવું?” ");
INSERT INTO guj2017_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","રિબકાએ ઇસહાકને કહ્યું, “હેથની દીકરીઓના કારણથી હું જીવવાથી કંટાળી ગઈ છું. હેથની દીકરીઓ જેવી જ પત્ની જો યાકૂબ આ દેશની દીકરીઓમાંથી લાવે, તો મારે જીવવું શા કામનું?” ");
INSERT INTO guj2017_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ઇસહાકે યાકૂબને બોલાવીને તેને આશીર્વાદ આપ્યો અને તેને આજ્ઞા આપી, “કનાન દેશની કન્યાઓમાંથી તું કોઈની સાથે લગ્ન કરીશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ઊઠ, પાદ્દાનારામમાં તારી માતાના પિતા બથુએલને ઘરે જા અને ત્યાંથી તારી માતાના ભાઈ એટલે તારા મામા લાબાનની દીકરીઓમાંથી એકની સાથે તું લગ્ન કર. ");
INSERT INTO guj2017_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","સર્વસમર્થ ઈશ્વર તને આશીર્વાદ આપે, ફળવંત કરે અને વૃદ્ધિ આપે કે જેથી તારા સંતાનો અસંખ્ય થાય. ");
INSERT INTO guj2017_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ઇબ્રાહિમને આપેલો આશીર્વાદ ઈશ્વર તને તથા તારા પછીના તારાં સંતાનને પણ આપે અને જે દેશ ઈશ્વરે ઇબ્રાહિમને આપેલો છે જેમાં તું પ્રવાસી છે તેનો વારસો તને મળે.” ");
INSERT INTO guj2017_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ઇસહાકે યાકૂબને વિદાય કર્યો. યાકૂબ પાદ્દાનારામમાં બથુએલ અરામીના દીકરા અને યાકૂબ તથા એસાવની માતા રિબકાના ભાઈ લાબાનને ત્યાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","હવે, એસાવે જોયું કે ઇસહાકે યાકૂબને આશીર્વાદ આપ્યો છે અને તેને પાદ્દાનારામમાંથી કન્યા મેળવીને લગ્ન કરવા માટે ત્યાં મોકલ્યો છે. એસાવે એ પણ જોયું કે ઇસહાકે તેને આશીર્વાદ આપતાં આજ્ઞા કરી કે, “કનાન દેશની કન્યાઓમાંથી તું કોઈની સાથે લગ્ન કરીશ નહિ,” ");
INSERT INTO guj2017_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","અને યાકૂબ તેના માતાપિતાની આજ્ઞા માનીને પાદ્દાનારામમાં ગયો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","એસાવે જોયું કે મારા પિતા ઇસહાકને કનાન દેશની કન્યાઓ પસંદ નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","તેથી તે તેના કાકા ઇશ્માએલના કુટુંબમાં ગયો અને પોતાની પત્નીઓ હોવા ઉપરાંત ત્યાંની સ્ત્રી સાથે લગ્ન કર્યું. તે ઇબ્રાહિમના દીકરા, ઇશ્માએલની દીકરી, નબાયોથની બહેન માહાલાથ હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","યાકૂબ બેરશેબાથી નીકળીને હારાન તરફ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","તે એક નિશ્ચિત જગ્યાએ આવ્યો અને સૂર્ય આથમી જવાથી ત્યાં મુકામ કર્યો. તેણે તે જગ્યાએથી એક પથ્થર લીધો અને પોતાના માથા નીચે મૂકીને તે ત્યાં સૂઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","તેને સ્વપ્ન આવ્યું. સ્વપ્નમાં પૃથ્વી પર ઊભી કરેલી એક સીડી તેના જોવામાં આવી. તેનો ઉપરનો ભાગ આકાશ સુધી પહોંચતો હતો અને ઈશ્વરના દૂતો તેની પર ચઢતા ઊતરતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","તેના ઉપર ઈશ્વર ઊભા હતા અને તેમણે કહ્યું, “હું તારા પિતા ઇબ્રાહિમ તથા ઇસહાકનો ઈશ્વર છું. જે ભૂમિ પર તું ઊંઘે છે, તે હું તને તથા તારા સંતાનને આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","પૃથ્વીની રજ જેટલાં તારા સંતાન થશે અને એ સંતાનો પૂર્વ, પશ્ચિમ, ઉત્તર તથા દક્ષિણ તરફ દૂર સુધી ફેલાશે. તારામાં તથા તારા સંતાનમાં પૃથ્વીનાં સર્વ કુળો આશીર્વાદ પામશે. ");
INSERT INTO guj2017_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","જો, હું તારી સાથે છું, જ્યાં કંઈ તું જશે ત્યાં હું તને સંભાળીશ. આ દેશમાં હું તને પાછો લાવીશ; હું તને ત્યાગી દઈશ નહિ. જે વચન મેં તને આપ્યું છે તે હું પૂરું કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","યાકૂબ ઊંઘમાંથી જાગી ગયો અને તેણે કહ્યું, “નિશ્ચે ઈશ્વર આ જગ્યાએ છે તે મેં જાણ્યું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","તે ગભરાયો અને બોલ્યો, “આ જગ્યા કેવી ભયાનક છે! આ ઈશ્વરના ઘર સિવાય બીજું કંઈ નથી. આ સ્વર્ગનું દ્વાર છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","યાકૂબ વહેલી સવારે ઊઠ્યો અને જે પથ્થર તેણે તેના માથા નીચે મૂક્યો હતો તે તેણે લીધો. તેણે તેને સ્તંભની જેમ ઊભો કર્યો અને તેના ઉપરના ભાગ પર જૈત તેલ રેડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","તેણે તે જગ્યાનું નામ બેથેલ પાડ્યું, જો કે તે નગરનું મૂળ નામ લૂઝ હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","યાકૂબે પ્રતિજ્ઞા કરી કે, “જો ઈશ્વર મારી સાથે રહેશે અને આ માર્ગ કે જેમાં હું ચાલું છું તેમાં મારું રક્ષણ કરશે, મને ખાવાને અન્ન અને પહેરવાને વસ્ત્ર આપશે, ");
INSERT INTO guj2017_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","અને મને મારા પિતાના ઘરે સુરક્ષિત લાવશે, તો તેમને હું મારા પ્રભુ, ઈશ્વર માનીશ; ");
INSERT INTO guj2017_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","અને આ પથ્થર જે મેં સ્તંભની જેમ ઊભો કર્યો છે તે યાદગીરીનું પવિત્ર સ્થાનક થશે અને ઈશ્વર જે કંઈ મને આપશે તેમાંથી હું નિશ્ચે તેમને દશાંશ પાછું આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","પછી યાકૂબ ત્યાંથી આગળ મુસાફરી કરીને પૂર્વના લોકોના દેશમાં આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","તેણે જોયું કે, ખેતરમાં એક કૂવો હતો. ત્યાં તેની નજીક ઘેટાંનાં ત્રણ ટોળાં હતાં. તે કૂવામાંથી તેઓ ટોળાંને પાણી પીવડાવતા હતા. કૂવા પર મોટો પથ્થર ઢાંકવામાં આવેલો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","જયારે ત્યાં સર્વ ટોળાં ભેગાં થતાં ત્યારે ઘેટાંપાળકો કૂવાના પથ્થરને ગબડાવી દેતા અને ઘેટાંને પાણી પીવડાવતા હતા પછી તે પથ્થરને પાછો તેની જગ્યાએ કૂવા પર મૂકી દેતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","યાકૂબે તેઓને પૂછ્યું, “મારા ભાઈઓ, તમે ક્યાંના છો?” તેઓએ કહ્યું, “અમે હારાનના છીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","તેણે તેઓને પૂછ્યું, “શું તમે નાહોરના દીકરા લાબાનને ઓળખો છો?” તેઓએ કહ્યું, “હા, અમે તેને ઓળખીએ છીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","તેણે તેઓને પૂછ્યું, “શું તે ક્ષેમકુશળ છે?” તેઓએ કહ્યું, “તે ક્ષેમકુશળ છે. તું સામે જો, તેની દીકરી રાહેલ ઘેટાંને લઈને આવી રહી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","યાકૂબે કહ્યું, “હજી તો સાંજ પડી નથી. ઘેટાંને ભેગા કરવાનો સમય થયો નથી. માટે તમે ઘેટાંને પાણી પીવડાવો, પછી તેઓને લઈ જાઓ અને ચરવા દો.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","તેઓએ કહ્યું, “ઘેટાંનાં બધાં ટોળાં અને ભરવાડો એકઠાં નહિ થાય ત્યાં સુધી અમે તેઓને પાણી પીવડાવી શકતા નથી. કૂવા પરથી પથ્થર ખસેડાય તે પછી અમે ઘેટાંને પાણી પીવડાવી શકીએ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","તે તેઓની સાથે વાત કરતો હતો એટલામાં રાહેલ તેના પિતાનાં ઘેટાં લઈને આવી. તે તેઓને ચરાવતી અને સાચવતી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","યાકૂબે તેના મામા લાબાનની દીકરી રાહેલને તથા તેમનાં ઘેટાંને જોયાં ત્યારે યાકૂબે પાસે આવીને કૂવાના મોં પરથી પથ્થર ખસેડ્યો અને તેના મામા લાબાનના ઘેટાંને પાણી પાયું. ");
INSERT INTO guj2017_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","યાકૂબે રાહેલને ચુંબન કર્યું અને રડી પડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","યાકૂબે રાહેલને જણાવ્યું કે, “હું તારા પિતાનો સંબંધી એટલે તેની બહેન રિબકાનો દીકરો છું.” એ જાણીને રાહેલે દોડી જઈને તેના પિતાને ખબર આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","જયારે લાબાને તેની બહેનના દીકરા યાકૂબની ખબર સાંભળી ત્યારે તે તેને મળવા દોડી આવ્યો અને ભેટીને તેને ચૂમ્યો અને તેને પોતાના ઘરે લાવ્યો. યાકૂબે લાબાનને પોતાના આવવા વિષેની વાત કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","લાબાને તેને કહ્યું, “વાસ્તવમાં, આપણે એક જ લોહી તથા માંસના છીએ.” પછી યાકૂબ તેની સાથે લગભગ એક મહિના સુધી રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","પછી લાબાને યાકૂબને કહ્યું, “તું મારો સંબંધી છે, તે માટે તારે મારા કામ કાજ મફત કરવા જોઈએ નહિ. મને કહે, તું કેટલું વેતન લઈશ?” ");
INSERT INTO guj2017_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","હવે, લાબાનને બે દીકરીઓ હતી. મોટી દીકરીનું નામ લેઆ અને નાનીનું નામ રાહેલ હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","લેઆની આંખો નબળી હતી. રાહેલ દેખાવમાં સુંદર તથા ઘાટીલી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","યાકૂબ રાહેલને પ્રેમ કરતો હતો તેથી તેણે કહ્યું, “તારી નાની દીકરી, રાહેલને સારું સાત વર્ષ હું તારી ચાકરી કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","લાબાને કહ્યું, “બીજા કોઈને હું મારી દીકરી આપું તેના કરતાં હું તેને આપું તે સારું છે. મારી સાથે રહે.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","યાકૂબે રાહેલને સારુ સાત વર્ષ સુધી લાબાનની સેવા કરી; તે સાત વર્ષ તેને બહુ ઓછા દિવસો જેવા લાગ્યાં, કેમ કે તે રાહેલને પ્રેમ કરતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","પછી યાકૂબે લાબાનને કહ્યું, “હવે મારી પત્ની મને આપ કેમ કે મારી ચાકરીનાં વર્ષોની મુદ્દત પૂરી થઈ છે, જેથી હું તેની સાથે સુખ ભોગવું.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","તેથી લાબાને ત્યાંના સર્વ માણસોને નિમંત્રિત કરીને મિજબાની કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","રાત્રે અંધારામાં, લાબાન તેની દીકરી લેઆને યાકૂબની પાસે લાવ્યો અને યાકૂબે તેની સાથે શરીરસુખ માણ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","લાબાને તેની દીકરી લેઆને સેવા ચાકરી માટે ઝિલ્પા નામે દાસી પણ આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","સવારે યાકૂબના જોવામાં આવ્યું કે, તે તો લેઆ હતી! યાકૂબે લાબાનને પૂછ્યું, “આ તેં મને શું કર્યું છે? શું રાહેલને સારુ મેં તારી સેવા ચાકરી કરી નહોતી? તેં મને શા માટે છેતર્યો?” ");
INSERT INTO guj2017_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","લાબાને કહ્યું, “મોટી દીકરીના લગ્ન અગાઉ નાની દીકરીનું લગ્ન કરવું એવો રિવાજ અમારા દેશમાં નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","આ દીકરી સાથે નવવધુ તરીકેનું અઠવાડિયું પૂરું કર પછી બીજાં સાત વર્ષ તું મારી ચાકરી કરજે અને તેના બદલામાં અમે રાહેલને પણ તને આપીશું.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","યાકૂબે તે પ્રમાણે કર્યું અને લેઆ સાથે અઠવાડિયું પૂરું કર્યું. પછી લાબાને તેની દીકરી રાહેલ પણ યાકૂબને પત્ની તરીકે આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","વળી લાબાને રાહેલની સેવા માટે બિલ્હા નામે દાસી પણ આપી ");
INSERT INTO guj2017_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","યાકૂબે રાહેલ સાથે પણ લગ્ન કર્યું. તે લેઆ કરતાં રાહેલ પર વધારે પ્રેમ રાખતો હતો. તેથી યાકૂબે બીજાં સાત વર્ષ લાબાનની ચાકરી કરી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ઈશ્વરે જોયું કે લેઆને પ્રેમ કરવામાં આવતો નથી, તે માટે તેમણે તેનું ગર્ભસ્થાન ઉઘાડ્યું, પણ રાહેલ નિ:સંતાન હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","લેઆ ગર્ભવતી થઈ અને તેણે દીકરાને જન્મ આપ્યો. તેનું નામ રુબેન પાડવામાં આવ્યું. કેમ કે તેણે કહ્યું, “ઈશ્વરે મારું દુઃખ જોયું છે માટે હવે મારો પતિ મને પ્રેમ કરશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","પછી તે ફરીથી ગર્ભવતી થઈ અને દીકરાને જન્મ આપ્યો. તેણે કહ્યું, “હું નાપસંદ છું તે ઈશ્વરે સાંભળ્યું છે, માટે તેમણે આ દીકરો પણ મને આપ્યો છે” તેણે તેનું નામ શિમયોન પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","પછી તે ત્રીજીવાર ફરી ગર્ભવતી થઈ અને દીકરાને જન્મ આપ્યો. તેણે કહ્યું, “હવે આ સમયે મારો પતિ મારી સાથે પ્રેમથી બંધાશે. કેમ કે મેં તેના ત્રણ દીકરાને જન્મ આપ્યો છે.” તે માટે તેનું નામ લેવી રાખવામાં આવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","તે ચોથી વખત ગર્ભવતી થઈ અને દીકરાને જન્મ આપ્યો. તેણે કહ્યું, “હવે આ સમયે હું ઈશ્વરની સ્તુતિ કરીશ.” તેથી તેણે તેનું નામ યહૂદા પાડ્યું. ત્યાર પછી તેને સંતાન જનમવાનું બંધ થયું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","જયારે રાહેલે જોયું કે તે પોતે બાળકોને જન્મ આપી શકતી નથી ત્યારે તેણે તેની બહેન પર અદેખાઈ રાખી અને યાકૂબને કહ્યું, “મને બાળકો આપ નહિ તો હું મરી જઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","યાકૂબે રાહેલ પર ગુસ્સે થઈને કહ્યું, “ઈશ્વર જેમણે તને બાળકોનો જન્મ આપતા અટકાવી છે, શું હું તેમને સ્થાને છું?” ");
INSERT INTO guj2017_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","તેણે કહ્યું, “તું, મારી દાસી બિલ્હાની પાસે જા કે જેથી તે તારા સંબંધથી બાળકોને જન્મ આપે અને તેનાથી હું બાળકો મેળવી શકું.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","તેણે પત્ની તરીકે તેની દાસી બિલ્હા યાકૂબને આપી અને યાકૂબે તેની સાથે પત્ની તરીકેનો સંબંધ રાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","બિલ્હા ગર્ભવતી થઈ. તેણે યાકૂબના દીકરાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","પછી રાહેલે કહ્યું, “ઈશ્વરે મારું સાંભળ્યું છે. તેમણે નિશ્ચે મારી વિનંતી સાંભળીને મને દીકરો આપ્યો છે.” તે માટે તેણે તેનું નામ ‘દાન’ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","રાહેલની દાસી બિલ્હા ફરી ગર્ભવતી થઈ અને તેણે યાકૂબના બીજા દીકરાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","રાહેલે કહ્યું, “મેં મારી બહેન સાથે જબરદસ્ત લડાઈ લડી છે અને હું જીતી છું.” તેણે તેનું નામ ‘નફતાલી’ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","જયારે લેઆએ જોયું કે તેને પોતાને સંતાન જનમવાનું બંધ થયું છે, ત્યારે તેણે તેની દાસી ઝિલ્પાને યાકૂબની પત્ની થવા સારુ આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","લેઆની દાસી ઝિલ્પાએ યાકૂબના દીકરાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","લેઆએ કહ્યું, “આના પર ઈશ્વરની દયા છે!” તેથી તેણે તેનું નામ ‘ગાદ’ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","પછી લેઆની દાસી ઝિલ્પાને યાકૂબથી બીજો દીકરો જન્મ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","લેઆએ કહ્યું, “હું આશિષીત છું! કેમ કે અન્ય સ્ત્રીઓ મને આશીર્વાદિત માનશે.” તેથી તેણે તેનું નામ ‘આશેર’ એટલે આશિષીત પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","રુબેન ઘઉંની કાપણીના દિવસોમાં ખેતરમાં ગયો હતો ત્યાં એક છોડ પર રીંગણાં હતા. તેમાંથી કેટલાંક રીંગણાં તે લેઆની પાસે લઈ આવ્યો. તે જોઈને રાહેલે લેઆને કહ્યું, “તારા દીકરાના રીંગણાંમાંથી થોડાં મને આપ.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","લેઆએ તેને કહ્યું, “તેં મારા પતિને લઈ લીધો છે, એ શું ઓછું છે? તો હવે મારા દીકરાનાં રીંગણાં પણ તારે લેવાં છે? “રાહેલે કહ્યું, “તારા દીકરાનાં રીંગણાં બદલે આજ રાત્રે યાકૂબ તારી સાથે સહશયન કરશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","સાંજે યાકૂબ ખેતરમાંથી આવ્યો. લેઆ તેને મળવાને બહાર ગઈ અને કહ્યું, “આજે રાત્રે તારે મારી સાથે સહશયન કરવાનું છે. કેમ કે મારા દીકરાનાં રીંગણાં આપીને મેં આ શરત કરી છે.” માટે તે રાત્રે યાકૂબ તેની સાથે સૂઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ઈશ્વરે લેઆનું સાંભળ્યું અને તે ગર્ભવતી થઈ. તેણે યાકૂબના પાંચમા દીકરાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","લેઆએ કહ્યું, “ઈશ્વરે મને બદલો આપ્યો છે, કેમ કે મેં મારા પતિને મારી દાસી આપી હતી.” તેણે તેનું નામ ‘ઇસ્સાખાર’ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","લેઆ ફરી ગર્ભવતી થઈ અને તેણે યાકૂબના છઠ્ઠા દીકરાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","લેઆએ કહ્યું, “ઈશ્વરે મને સારી ભેટ આપી છે. હવે મારો પતિ મને માન આપશે, કેમ કે મેં તેના છ દીકરાને જન્મ આપ્યો છે. “માટે તેણે તેનું નામ ઝબુલોન પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ત્યાર પછી તેણે એક દીકરીને જન્મ આપ્યો અને તેણીએ તેનું નામ દીના પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ઈશ્વરે રાહેલને યાદ કરીને તેની પ્રાર્થના સાંભળી. તેને સંતાન પ્રાપ્તિનો આશીર્વાદ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","તે ગર્ભવતી થઈ અને તેણે દીકરાને જન્મ આપ્યો. તેણે કહ્યું, “ઈશ્વરે મારી શરમ દૂર કરી છે” ");
INSERT INTO guj2017_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","તેણે તેનું નામ ‘યૂસફ’ પાડીને કહ્યું, “ઈશ્વર એક બીજો દીકરો પણ મને આપો.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","રાહેલે યૂસફને જન્મ આપ્યો ત્યાર પછી યાકૂબે લાબાનને કહ્યું, “મને વિદાય કર, કે જેથી હું મારો દેશ, એટલે મારા પોતાના ઘરે જાઉં. ");
INSERT INTO guj2017_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","મારી પત્નીઓ તથા મારાં બાળકો જેઓને સારુ મેં તારી સેવા ચાકરી કરી છે, તે મને આપ. મને જવા દે, કેમ કે મેં તારી જે ચાકરી કરી છે, તે તું જાણે છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","લાબાને તેને કહ્યું, “જો, હવે તારી દ્રષ્ટિમાં મેં કૃપા પ્રાપ્ત કરી હોય તો રહે, કેમ કે ઈશ્વર દ્વારા મને જણાયું છે કે તારે લીધે ઈશ્વરે મને ઘણો આશીર્વાદ આપ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","પછી તેણે કહ્યું, “તારી ઇચ્છા અનુસાર તું જેટલું માંગીશ તેટલું હું તને આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","યાકૂબે તેને કહ્યું, “તું જાણે છે કે મેં તારી કેવી ચાકરી કરી છે અને તારાં જાનવરોમાં કેટલો બધો વધારો થયો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","હું અહીં આવ્યો તે પહેલાં તારી પાસે થોડું હતું અને હવે તે ઘણું વધી ગયું છે. જ્યાં મેં કામ કર્યું છે ત્યાં ઈશ્વરે તને આશીર્વાદ આપ્યો છે. હવે મારા પોતાના ઘર કુટુંબ માટે પણ મારે ઘણું કરવાનું છે. તે હું ક્યારે પૂરું કરીશ?” ");
INSERT INTO guj2017_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","લાબાને કહ્યું, “તને હું શું વેતન આપું?” યાકૂબે કહ્યું, “તું મને કશું જ ન આપીશ. જો તું મારા માટે આટલું કરે તો હું ફરી તારાં ઘેટાંબકરાંને ચારીશ અને તેમને સંભાળીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","આજે મને તારાં બધાં ઘેટાંબકરાંના ટોળાંમાં જવા દે કે તેમાંથી છાંટવાળાં, ટપકાંવાળાં તથા કાળાં ઘેટાંને અને ટપકાંવાળાં તથા છાંટવાળાં બકરાંને હું અલગ કરું. મારા વેતન તરીકે તું તે મને આપ. ");
INSERT INTO guj2017_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","જયારે મારા વેતન તરીકે આપેલાં ઘેટાંબકરાં તું તપાસશે ત્યારે પાછળથી મારી પ્રામાણિકતા માટે તેઓ સાક્ષીરૂપ થશે કે બકરાંમાં જે છાંટવાળા કે ટપકાંવાળા નથી અને ઘેટાંમાં પણ જે કાળાં નથી એવાં જો મારી પાસે મળે તો તે સર્વ ચોરીનાં ગણાશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","લાબાને કહ્યું, “તારી માંગણી પ્રમાણે હું સંમત છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","તે દિવસે લાબાને પટ્ટાવાળાં તથા ટપકાંવાળાં બકરાં અને છાંટવાળી તથા સફેદ ટપકાંવાળી બધી બકરીઓને અને ઘેટાંઓમાંથી પણ જે કાળાં હતા તેઓને અલગ કર્યા અને એ ઘેટાંબકરાં યાકૂબના દીકરાઓને સુપ્રત કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","અને ત્રણ દિવસનો પ્રવાસ થાય એટલા અંતર દૂર તેઓને લઈ જવા જણાવ્યું. યાકૂબે લાબાનનાં બાકી રહેલા ઘેટાંબકરાંને ત્યાં જ રહીને સાચવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","યાકૂબે લીમડાની, બદામની તથા આર્મોન ઝાડની લીલીછમ ડાળીઓ કાપી અને તેની છાલ એવી રીતે ઉખાડી કે તેમાં સફેદ પટ્ટા દેખાય. ");
INSERT INTO guj2017_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","પછી તેણે જાનવરો પાણી પીવા આવે ત્યાં ખાડામાં જે ડાળીઓ છોલી હતી તે તેઓની આગળ ઊભી કરી. જયારે તેઓ પાણી પીતા ત્યારે તેઓ ગર્ભ ધારણ કરવા માટે આશક્ત થતાં હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ડાળીઓ આગળ ઘેટાંબકરાં ગર્ભધારણ કરતાં હતાં પછી તેઓએ પટ્ટાદાર, છાંટવાળાં તથા ટપકાંવાળાં બચ્ચાંઓને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","યાકૂબે ઘેટીને અલગ કરી અને લાબાનનાં જાનવરોમાં જે પટાદાર તથા સર્વ કાળાં હતાં તેઓની તરફ તેઓના મોં રાખ્યાં. પછી તેણે પોતાના ટોળાંને જુદાં પાડ્યાં અને લાબાનનાં ટોળાંની પાસે તેમને રાખ્યાં નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","જયારે ટોળાંમાંના સશક્ત પ્રાણી સંવનન કરતાં ત્યારે યાકૂબ તે ડાળીઓ ટોળાંની નજરો આગળ ખાડામાં મૂકતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","પણ ટોળાંમાંના નબળા પશુ આવતાં ત્યારે તે તેઓની આગળ ડાળીઓ મૂકતો નહોતો. તેથી નબળા ઘેટાંબકરાં લાબાનનાં અને સશક્ત યાકૂબનાં થયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","પરિણામે યાકૂબના ઘેટાંબકરાંમાં ઘણો વધારો થયો. તેની પાસે દાસો તથા દાસીઓ, ઊંટો તથા ગધેડાં ઉપરાંત વિશાળ પ્રમાણમાં અન્ય જાનવરોની સંપત્તિ હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","હવે યાકૂબે લાબાનના દીકરાઓને એવી વાતો કહેતા સાંભળ્યાં કે, “જે સઘળું આપણા પિતાનું હતું તે યાકૂબે લઈ લીધું છે. આપણા પિતાની સર્વ સંપત્તિ તેણે મેળવી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","યાકૂબે લાબાનના મુખ પર જોતાં તેને જણાયું કે તેના પ્રત્યેનું લાબાનનું વલણ બદલાયેલું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","પછી ઈશ્વરે યાકૂબને કહ્યું, “તું તારા પિતૃઓના દેશમાં તથા તારા કુટુંબીજનો પાસે પાછો જા અને હું તારી સાથે હોઈશ. ");
INSERT INTO guj2017_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","યાકૂબે માણસ મોકલીને રાહેલને તથા લેઆને ખેતરમાં તેના ટોળાં પાસે બોલાવી લીધાં. ");
INSERT INTO guj2017_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","અને તેઓને કહ્યું, “તમારા પિતાનું મારા પ્રત્યેનું વલણ બદલાઈ ગયું છે પણ મારા પિતાના ઈશ્વર મારી સાથે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","તમે જાણો છો કે મેં મારા પૂરા સામર્થ્ય સહિત તમારા પિતાની ચાકરી કરી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","તમારા પિતાએ મને ઠગ્યો છે અને મારા વેતનનો કરાર દસ વાર ભંગ કરેલો છે. પણ ઈશ્વરે તેનાથી મારું નુકસાન થવા દીધું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","તેણે કહ્યું હતું કે, ‘છાંટવાળાં પશુઓ તારું વેતન થશે,’ પછી સર્વ પ્રાણીઓને છાંટવાળાં બચ્ચાં થયાં. વળી તેણે કહ્યું, પટ્ટાવાળાં પશુઓ તારું વેતન થશે અને પછી સર્વ પશુઓને પટ્ટાવાળાં બચ્ચાં જન્મ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","એ રીતે ઈશ્વરે તમારા પિતાના જાનવરોને લઈને મને આપ્યાં છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","એક વાર મેં સ્વપ્નમાં જોયું કે ગર્ભધારણ કરવાની ઋતુમાં જે બકરાં ટોળાં સાથે મળીને આવતાં હતાં તેઓ પટ્ટાદાર, છાંટવાળાં તથા કાબરચીતરાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ઈશ્વરના દૂતે મને સ્વપ્નમાં કહ્યું, ‘યાકૂબ.’ મેં કહ્યું, ‘હું આ રહ્યો” ");
INSERT INTO guj2017_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","તેણે કહ્યું, ‘તારી આંખો ઊંચી કરીને જો કે ટોળાં સાથે જે બકરાં સંબંધ બાંધે છે તેઓ સર્વ પટ્ટાદાર, છાંટવાળા તથા કાબરચીતરા છે. કેમ કે લાબાન તને જે કરે છે તે સર્વ મેં જોયું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","જ્યાં તેં સ્તંભને અભિષિક્ત કર્યો હતો અને જ્યાં તેં મારી પ્રતિજ્ઞા લીધી હતી, તે બેથેલનો ઈશ્વર હું છું. હવે આ દેશમાંથી તું તારી જન્મભૂમિના દેશમાં પાછો જા.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","રાહેલે તથા લેઆએ તેને ઉત્તર આપ્યો, “શું અમારા પિતાના ઘરમાં અમારે સારુ કંઈ હિસ્સો કે વારસો છે? ");
INSERT INTO guj2017_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","શું તેમણે અમારી સાથે વિદેશી જેવો વ્યવહાર કર્યો નથી? કેમ કે તેણે અમને વેચી દીધી છે અને અમારા તમામ પૈસા પણ ખાઈ ગયા છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","કેમ કે ઈશ્વરે અમારા પિતા પાસેથી જે સંપત્તિ લઈ લીધી, તે સર્વ અમારી તથા અમારા બાળકોની છે. તો પછી હવે, ઈશ્વરે તમને જે કંઈ કહ્યું છે તે પ્રમાણે કરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","પછી યાકૂબે ઊઠીને તેના દીકરાઓને તથા તેની પત્નીઓને ઊંટો પર બેસાડ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","તેના પિતા ઇસહાકના દેશ કનાન તરફ જવાને તેણે તેનાં સર્વ ઘેટાંબકરાં તથા જે બધી સંપત્તિ તેણે મેળવી હતી, એટલે જે અન્ય જાનવરોની સંપત્તિ તેણે પાદ્દાનારામમાં પ્રાપ્ત કરી હતી તે બધાની સાથે ત્યાં રવાના થવાની શરૂઆત કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","પછી લાબાન પોતાનાં ઘેટાંને કાતરવા ગયો હતો અને રાહેલે તેના પિતાના ઘરની મૂર્તિઓ ચોરી લીધી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","યાકૂબે પોતાના જવાની ખબર તેને આપી નહિ અને લાબાન અરામીને છેતર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","તેની પાસે જે હતું તે સર્વ લઈને તે વિદાય થયો અને ઝડપથી નદી પાર ઊતરી ગયો અને ગિલ્યાદ પર્વત તરફ આગળ વધ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ત્રીજે દિવસે લાબાનને કહેવામાં આવ્યું કે યાકૂબ નાસી ગયો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","તેથી તે તેની સાથે તેના સગાંઓને લઈને સાત દિવસની મુસાફરી જેટલા અંતર સુધી તેની પાછળ પડ્યો. તે ગિલ્યાદ પર્વત પર તેની આગળ નીકળી આવ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","હવે રાત્રે લાબાન અરામીના સ્વપ્નમાં ઈશ્વરે કહ્યું હતું, “તું યાકૂબને ખરું અથવા ખોટું કહેવા વિષે સાવચેત રહેજે.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","લાબાન યાકૂબની આગળ પહોંચી ગયો હતો. હવે યાકૂબે પહાડ પર તેનો તંબુ બાંધ્યો હતો. લાબાને પણ તેના સગાંઓ સાથે ગિલ્યાદ પહાડ પર તંબુ બાંધ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","લાબાને યાકૂબને કહ્યું, “આ તેં શું કર્યું છે, તેં મને છેતર્યો અને લડાઈમાં પકડેલા કેદીઓની જેમ મારી દીકરીઓને તું લઈ જાય છે? ");
INSERT INTO guj2017_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","શા માટે છાનોમાનો નાસી જાય છે? તેં કુયુક્તિથી મને અજાણ રાખ્યો છે. હું ગીતોથી, ખંજરીથી તથા વીણા વગાડીને ઊજવણી કરીને તને વિદાય આપત. ");
INSERT INTO guj2017_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","તેં મને મારા પૌત્રોને ચુંબન કરવા દીધું નહિ અને મારી દીકરીઓને ‘આવજો’ કહેવા પણ ન દીધુ. તેં ભારે મૂર્ખાઈ કરી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","તને નુકસાન કરવાની તાકાત મારા હાથમાં છે પણ તારા પિતાના ઈશ્વરે ગતરાત્રે મારી સાથે વાત કરતા કહ્યું, ‘તું યાકૂબને ખરુંખોટું કહેવા વિષે સાવચેત રહેજે” ");
INSERT INTO guj2017_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","અને હવે તારે જવું જોઈએ, કેમ કે તારા પિતાના ઘર માટે તું ઘણો આતુર થયો છે. પણ તેં મારી મૂર્તિઓને કેમ ચોરી લીધી છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","યાકૂબે ઉત્તર આપીને લાબાનને કહ્યું, “હું તારાથી ગભરાઈ ગયો હતો અને મેં વિચાર્યું કે કદાચ તું તારી દીકરીઓ મારી પાસેથી બળજબરીથી લઈ લેશે તેથી હું છાની રીતે નાસી આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","જેણે તારા દેવો ચોર્યા હશે તે જીવતો રહેશે નહિ. મારી પાસે જે કંઈ છે તારું છે. જો મૂર્તિઓ હોય તો તે આપણા સગાઓની હાજરીમાં તું લઈ લે.” કેમ કે યાકૂબ જાણતો નહોતો કે રાહેલે તેઓને ચોરી લીધી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","લાબાન યાકૂબના તંબુમાં, લેઆના તંબુમાં અને બે દાસીઓના તંબુમાં ગયો, પણ તેને તે મૂર્તિઓ મળી નહિ. તે લેઆના તંબુમાંથી બહાર નીકળીને રાહેલના તંબુમાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","હવે રાહેલ ઘરની મૂર્તિઓને લઈને ઊંટોના જીન ઉપર તેઓને મૂકીને તે પર બેઠી હતી માટે લાબાનને તે મળી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","તેણે તેના પિતાને કહ્યું, “મારા પિતા, ગુસ્સે ન થાઓ, કેમ કે સ્ત્રીઓની રીત પ્રમાણે મને થયું હોવાથી હું તમારી આગળ ઊઠી શકતી નથી.” આમ લાબાને શોધ કરી પણ ઘરની મૂર્તિઓ તેને મળી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","યાકૂબ ગુસ્સે થયો અને લાબાન સાથે વિવાદ કર્યો. યાકૂબે લાબાનને કહ્યું, “મારો અપરાધ શો છે? મારું પાપ શું છે કે તું આટલી ઉગ્ર રીતે મારી પાછળ પડ્યો છે? ");
INSERT INTO guj2017_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","કેમ કે તેં મારો સર્વ સામાન તપાસ્યો છે. પણ તારા ઘરનું કશું મળી આવ્યું નથી. જો ચોરેલું કશું પકડાયું હોય તો તે અહીં આપણા સંબંધીઓની આગળ મૂક, કે જેથી તેઓ આપણા બન્નેનો ન્યાય કરે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","વીસ વર્ષથી હું તારી સાથે રહ્યો છું. તારી ઘેટીઓ તથા તારી બકરીઓ જન્મ આપવામાં અસફળ ગઈ નથી, ના તો હું તારા ટોળાંનાં ઘેટાંઓને ખાઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ફાડી નાખેલું હું તારી પાસે લાવ્યો ન હતો. તેનું નુકસાન હું પોતે ભોગવી લેતો હતો. દિવસે અથવા રાત્રે ચોરાઈ ગયેલું તે તું મારી પાસેથી માગતો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","દિવસે તાપથી તથા રાત્રે હિમથી મારો ક્ષય થયો; અને મારી આંખની ઊંઘ જતી રહી; એવી મારી હાલત હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","આ વીસ વર્ષ સુધી હું એ પ્રમાણે તારા ઘરમાં રહ્યો. તારી બે દીકરીઓને સારુ ચૌદ વર્ષ તથા તારાં જાનવરોને સારુ છ વર્ષ મેં તારી ચાકરી કરી છે. તેં દસ વાર મારા વેતનનો કરાર ભંગ કર્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","જો મારા દાદા ઇબ્રાહિમ તથા પિતા ઇસહાક જે ઈશ્વરના ભયમાં ચાલતા હતા, તે ઈશ્વર મારી સાથે ન હોત, તો નિશ્ચે આ વખતે તું મને ખાલી હાથે વિદાય કરત. ઈશ્વરે તારો અત્યાચાર તથા મારી સખત મહેનત જોયાં છે અને તેથી તેમણે ગતરાત્રે તને ઠપકો આપ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","લાબાને ઉત્તર આપીને યાકૂબને કહ્યું, “આ દીકરીઓ મારી દીકરીઓ છે, આ છોકરાઓ મારા છોકરા છે અને આ ટોળાં મારાં ટોળાં છે. જે સર્વ તું જુએ છે તે મારું છે. પણ હવે આ મારી દીકરીઓને તથા તેઓએ જે બાળકોને જન્મ આપ્યો છે, તેઓને લીધે તને હું શું કરું? ");
INSERT INTO guj2017_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","તેથી હવે ચાલ, આપણે બન્ને કરાર કરીએ અને તે મારી તથા તારી વચ્ચે સાક્ષી થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","તેથી યાકૂબે પથ્થર લીધો અને સ્તંભ તરીકે તેને ઊભો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","યાકૂબે તેના સંબંધીઓને કહ્યું, “પથ્થર એકઠા કરો.” તેથી તેઓએ પથ્થર લાવીને ઢગલો કર્યો. પછી તેઓએ તે ઢગલા પાસે ખાધું. ");
INSERT INTO guj2017_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","લાબાને તે ઢગલાને યગાર-સાહદૂથા કહ્યો અને યાકૂબે તેને ગાલેદ કહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","લાબાને કહ્યું, “મારી તથા તારી વચ્ચે આ પથ્થરનાં ગંજ આજે સાક્ષી છે.” તે માટે તેનું નામ ગાલેદ કહેવાશે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","તેનું નામ મિસ્પાહ પણ પાડવામાં આવ્યું, કેમ કે લાબાને કહ્યું, “જયારે આપણે એકબીજાથી જુદા પડીએ, ત્યારે ઈશ્વર મારી અને તારી પર નજર રાખે. ");
INSERT INTO guj2017_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","જો તું મારી દીકરીઓ સાથે ખરાબ વર્તન કરે અથવા મારી દીકરીઓ સિવાય બીજી પત્નીઓ કરે, તો આપણી વચ્ચે કોઈ માણસ નહિ પણ ઈશ્વર સાક્ષી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","લાબાને યાકૂબને કહ્યું, “આ પથ્થરનાં ગંજને એટલે તારી તથા મારી વચ્ચે મેં જે સ્તંભ ઊભો કર્યો છે તે જો. ");
INSERT INTO guj2017_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","આ ગંજ અને આ સ્તંભ સાક્ષીને અર્થે થાય. તારું અહિત કરવાને આ ગંજ ઓળંગીને હું તારી પાસે આવવાનો નથી અને આ ગંજ તથા સ્તંભ ઓળંગીને મારું અહિત કરવાને તું મારી પાસે આવીશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ઇબ્રાહિમના ઈશ્વર તથા નાહોરના ઈશ્વર, એટલે તેઓના પિતાના ઈશ્વર આપણી વચમાં ન્યાય કરો.” યાકૂબે પોતાના પિતા ઇસહાક જે ઈશ્વરનો ભય રાખતા હતા તેમના સમ ખાધા. ");
INSERT INTO guj2017_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","યાકૂબે પહાડ પર બલિદાન આપ્યું અને ભોજન કરવાને તેના સંબંધીઓને બોલાવ્યા. તેઓએ ભોજન કર્યું અને આખી રાત પહાડ પર વિતાવી. ");
INSERT INTO guj2017_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","વહેલી સવારે લાબાન ઊઠ્યો અને પોતાના પૌત્રો-પૌત્રીઓને તથા પોતાની દીકરીઓને ચુંબન કરીને તેઓને આશીર્વાદ આપ્યો. પછી લાબાન ત્યાંથી પાછો વળીને પોતાને ઘરે પાછો ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","યાકૂબ પણ પોતાના રસ્તે ચાલતો થયો અને રસ્તામાં ઈશ્વરના દૂતો તેને મળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","જયારે યાકૂબે તેઓને જોયા ત્યારે તે બોલ્યો, “આ તો ઈશ્વરની છાવણી છે,” તેથી તેણે તે જગ્યાનું નામ ‘માહનાઇમ’ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","યાકૂબે પોતાની આગળ અદોમના દેશમાંના સેઈર પ્રદેશમાં તેના ભાઈ એસાવની પાસે સંદેશાવાહકો મોકલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","તેણે તેઓને આજ્ઞા આપીને કહ્યું, “મારા માલિક એસાવને તમે એમ કહેજો: તારો સેવક યાકૂબ કહે છે કે: ‘આજ સુધી મામા લાબાનને ત્યાં હું રહ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","મારી પાસે બળદ, ગધેડાં, ઘેટાંબકરાં, દાસ તથા દાસીઓ છે. મેં મારા માણસોને આ ખબર આપવાને મારા ઘણી પાસે મોકલ્યા છે, જેથી તું મારા પ્રત્યે ભલાઈ અને સહાનુભૂતિ દર્શાવે.” ");
INSERT INTO guj2017_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","એસાવને મળીને પાછા આવ્યા પછી સંદેશાવાહકોએ યાકૂબને કહ્યું, “અમે તારા ભાઈ એસાવની પાસે ગયા હતા. તે તને મળવાને આવી રહ્યો છે અને તેની સાથે ચારસો માણસો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","તેથી યાકૂબ ઘણો ગભરાઈને ચિંતાતુર થયો. તેણે પોતાની સાથેના લોકોના, ઘેટાંબકરાંના, ઊંટોના તથા અન્ય જાનવરોના ભાગ પાડીને બે છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","તેણે કહ્યું, “જો એસાવ એક છાવણી પાસે આવીને તેની પર હુમલો કરે, તો બાકી રહેલી છાવણી બચી જશે. ");
INSERT INTO guj2017_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","યાકૂબે કહ્યું, “પ્રભુ, મારા પિતા ઇબ્રાહિમ તથા પિતા ઇસહાકના ઈશ્વર, જેમણે મને કહ્યું હતું, ‘તું તારા દેશ તથા તારા સંબંધીઓની પાસે પાછો જા અને હું તને સમૃદ્ધ કરીશ,’ ");
INSERT INTO guj2017_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","તમે કરેલા કરાર સંબંધી તમે મારા પર જે કૃપા કરી છે તેને તથા તમારી સત્યનિષ્ઠાને હું લાયક જ નથી. કેમ કે હું કેવળ મારી લાકડી લઈને યર્દન પાર ગયો હતો અને હવે મારી પાસે જાનવરોના ટોળાંની બે છાવણી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","કૃપા કરીને મારા ભાઈના હાથથી એટલે એસાવના હાથથી મને બચાવો, કેમ કે હું તેનાથી ગભરાઉં છું કે તે આવીને મારા પર, મારા દીકરાઓ પર તથા તેઓની માતાઓ પર હુમલો કરે. ");
INSERT INTO guj2017_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","પણ તમે તો કહેલું છે કે, ‘નિશ્ચે હું તને સમૃદ્ધ કરીશ અને સમુદ્રના કાંઠાની રેતી જેની સંખ્યા ગણી શકાય નહિ, તેના જેટલો તારો વંશ કરીશ.’” ");
INSERT INTO guj2017_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","યાકૂબ તે રાત્રે ત્યાં જ રહ્યો. તેના ભાઈ એસાવને ભેટ આપવા સારુ તેની પાસે જે હતું તેમાંથી તેણે થોડું લીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","એટલે બસો બકરીઓ, વીસ બકરાં, બસો ઘેટીઓ તથા વીસ ઘેટાં, ");
INSERT INTO guj2017_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ત્રીસ દુઝણી ઊંટડી તેઓનાં બચ્ચાં સહિત, ચાળીસ ગાય, દસ બળદ, વીસ ગધેડીઓ તથા દસ ગધેડાં લીધાં. ");
INSERT INTO guj2017_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","એ સર્વના જુદાં જુદાં ટોળાં કરીને તેણે તેના દાસોના હાથમાં સોંપ્યાં અને તેના દાસોને કહ્યું, “તમે મારી આગળ જાઓ અને દરેક ટોળાંઓની વચ્ચે અંતર રાખો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","તેણે પહેલાને આજ્ઞા આપી, “મારો ભાઈ એસાવ તને મળે અને તને પૂછે, ‘તું ક્યાંનો છે? તું ક્યાં જાય છે? તારી આગળ આ જે પ્રાણીઓ ચાલે છે તે કોનાં છે?’ ");
INSERT INTO guj2017_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ત્યારે તું કહેજે, ‘તેઓ તારા દાસ યાકૂબનાં છે. તેઓ મારા મોટા ભાઈ અને માલિક એસાવને મોકલેલી ભેટ છે. અને જો, તે પણ અમારી પાછળ આવે છે.’” ");
INSERT INTO guj2017_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","યાકૂબે બીજાને, ત્રીજાને તથા જે માણસો ટોળાંની પાછળ જતા હતા તે સર્વને પણ સૂચનો આપ્યાં કે, “જયારે તમે એસાવને મળો ત્યારે એ જ પ્રમાણે કહેજો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","તમે એમ પણ કહેજો, ‘તારો દાસ યાકૂબ અમારી પાછળ આવે છે.’ કેમ કે તેણે વિચાર્યું, “જે ભેટો મારી આગળ જાય છે, તેથી હું તેને શાંત કરીશ. જયારે પાછળથી હું તેને મળીશ ત્યારે કદાચ તે મારો સ્વીકાર કરે.” ");
INSERT INTO guj2017_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","તેથી સર્વ ભેટો તેની આગળ ગઈ. તે રાત્રે તે પોતાની છાવણીમાં રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","યાકૂબ રાત્રે ઊઠ્યો અને તેણે તેની બે પત્નીઓ, તેઓની બે દાસીઓ તથા તેના અગિયાર દીકરાઓને લીધા અને યાબ્બોકના નદીની પાર મોકલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","આ રીતે તેણે તેઓને તેની સઘળી સંપત્તિ સાથે નદીની પાર પહોંચાડી દીધા. ");
INSERT INTO guj2017_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","યાકૂબ એકલો રહી ગયો અને સવાર થતાં સુધી એક પુરુષે તેની સાથે મલયુદ્ધ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","જયારે તે માણસે જોયું કે તે તેને હરાવી શક્યો નથી ત્યારે તેણે તેની જાંઘના સાંધા પર પ્રહાર કર્યો અને તેની સાથે મલયુદ્ધ કરતાં કરતાં યાકૂબની જાંઘનો સાંધો ખસી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","તે માણસે કહ્યું, “સવાર થઈ છે માટે મને જવા દે.” યાકૂબે કહ્યું, “તું મને આશીર્વાદ નહિ આપે ત્યાં સુધી હું તને જવા દઈશ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","તે માણસે તેને પૂછ્યું, “તારું નામ શું છે? “યાકૂબે કહ્યું, “યાકૂબ.” ");
INSERT INTO guj2017_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","તે માણસે કહ્યું, “હવેથી તારું નામ યાકૂબ નહિ, પણ ઇઝરાયલ કહેવાશે. કેમ કે ઈશ્વરની તથા માણસોની સાથે તેં સંઘર્ષ કર્યો છે અને તું જય પામ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","યાકૂબે તેને પૂછ્યું, “કૃપા કરી તું તારું નામ મને કહે.” તેણે કહ્યું, “મારું નામ તું શા માટે પૂછે છે?” પછી તેણે તેને આશીર્વાદ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","યાકૂબે તે જગ્યાનું નામ પનીએલ પાડ્યું, કેમ કે તેણે કહ્યું, “મેં ઈશ્વરને મુખોમુખ જોયા છે તોપણ મારો જીવ બચી ગયો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","યાકૂબ પનુએલની પાર જતો હતો ત્યારે સૂર્યોદય થયો. તે જાંઘના કારણે લંગડાતો ચાલતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","તે માટે ઇઝરાયલના લોકો આજ સુધી જાંઘના સાંધા પરનું માંસ ખાતા નથી. કેમ કે તે માણસે યાકૂબની જાંઘના સાંધા પરના સ્નાયુને ઈજા કરી હતી. તેનાથી યાકૂબની જાંઘનો સાંધો ખસી ગયો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","યાકૂબે સામે દૂર સુધી નજર કરી તો જોવામાં આવ્યું કે, એસાવ તથા તેની સાથે ચારસો માણસો આવી રહ્યા હતા. યાકૂબે લેઆને, રાહેલને તથા તેઓની બે દાસીઓને બાળકો વહેંચી આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","પછી તેણે દાસીઓને તથા તેઓનાં સંતાનોને આગળ રાખ્યાં, તે પછી લેઆ તથા તેના પુત્રો અને તે પછી છેલ્લે રાહેલ તથા યૂસફને રાખ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","તે પોતે સૌની આગળ ચાલતો રહ્યો. તેના ભાઈની પાસે તે આવ્યો ત્યાં સુધીમાં તેણે સાત વાર નમીને તેને દંડવત પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","એસાવ તેને મળવાને ઉતાવળે આવ્યો. તે તેને ગળે ભેટીને ચૂમ્યો. પછી તેઓ ભાવુક થઈને રડી પડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","જયારે એસાવે સામે જોયું તો તેણે સ્ત્રીઓ તથા છોકરાંને જોયા. તેણે કહ્યું, “તારી સાથે આ કોણ છે?” યાકૂબે કહ્યું, તેઓ તો ઈશ્વરે કૃપા કરીને તારા દાસને આપેલાં સંતાનો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","પછી દાસીઓ તેઓનાં સંતાનો સાથે આગળ આવી અને તેઓએ સાષ્ટાંગ દંડવત પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","પછી લેઆ પણ તેનાં સંતાનો સાથે આવી અને તેઓએ પણ સાષ્ટાંગ દંડવત પ્રણામ કર્યા. છેલ્લે યૂસફ તથા રાહેલ આવ્યાં અને તેઓએ પણ સાષ્ટાંગ દંડવત પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","એસાવે કહ્યું, “આ જે સર્વ જાનવરોના ટોળાં મને મળ્યાં તેનો મતલબ શું છે?” યાકૂબે કહ્યું, “મારા માલિકની નજરમાં કૃપા પામવા માટેની એ ભેટ છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","એસાવ બોલ્યો, “મારા ભાઈ, મારી પાસે પૂરતું છે. તારું સઘળું તું તારી પાસે રાખ.” ");
INSERT INTO guj2017_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","યાકૂબે કહ્યું, “એમ નહિ, જો હું તારી નજરમાં કૃપા પામ્યો હોઉં તો કૃપા કરી મારા હાથથી મારી ભેટ સ્વીકાર, કેમ કે જાણે ઈશ્વરનું મુખ જોયું હોય તેમ મેં તારું મુખ જોયું છે અને તેં મને સ્વીકાર્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","મારી જે ભેંટ તારી પાસે લાવવામાં આવી છે તે કૃપા કરી સ્વીકાર, કેમ કે ઈશ્વરે મારા ઉપર કૃપા કરી છે તેથી મારી પાસે પુષ્કળ છે.” યાકૂબે તેને આગ્રહ કર્યો અને એસાવે તેનો સ્વીકાર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","પછી એસાવે કહ્યું, “ચાલો, આપણે આપણા રસ્તે જઈએ. હું તારી આગળ ચાલીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","યાકૂબે તેને કહ્યું, “મારા માલિક તું જાણે છે કે સંતાનો કિશોર છે અને બકરીઓનાં તથા અન્ય જાનવરોના બચ્ચાં મારી સાથે છે. જો તેઓને એક દિવસ પણ વધારે લાંબા અંતરે હાંકવામાં આવે તો સર્વ ટોળાં મરી જાય એવું થાય. ");
INSERT INTO guj2017_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","માટે મારા માલિક તારા દાસની આગળ જા. હું સેઈરમાં તારી પાસે આવી પહોંચીશ, ત્યાં સુધી જે જાનવરો મારી આગળ છે તેઓ તથા સંતાનો ચાલી શકે તે પ્રમાણે હું ધીમે ધીમે ચાલતો આવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","એસાવે કહ્યું, “મારી સાથેના લોકોમાંથી હું થોડા તારી પાસે રહેવા દઉં છું.” પણ યાકૂબે કહ્યું, “શા માટે? હું મારા માલિકની નજરમાં કૃપા પામું એટલું પૂરતું છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","તેથી તે દિવસે એસાવ સેઈર જવાને પાછો ફર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","સુક્કોથમાં યાકૂબ ચાલતો આવ્યો, તેણે પોતાને માટે ઘર બાંધ્યું અને તેનાં ઢોરને માટે આશ્રયસ્થાનો બનાવ્યા. એ માટે તે જગ્યાનું નામ સુક્કોથ પડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","જયારે યાકૂબ પાદ્દાનારામમાંથી આવ્યો, ત્યારે તે કનાન દેશના શખેમ સુધી સહીસલામત આવ્યો. તેણે શહેરની નજીક મુકામ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","પછી જે જમીનના ટુકડામાં તેણે પોતાનો મુકામ કર્યો હતો, તે જમીન તેણે શખેમના પિતા હમોરના દીકરાઓની પાસેથી સો ચાંદીના સિક્કાથી વેચાતી લીધી. ");
INSERT INTO guj2017_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ત્યાં તેણે વેદી બાંધી અને તેનું નામ એલ-એલોહે ઇઝરાયલ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","હવે લેઆથી જન્મેલી યાકૂબની દીકરી દીના તે દેશની સ્ત્રીઓને મળવા બહાર ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","હમોર હિવ્વી જે દેશનો હાકેમ હતો, તેના દીકરા શખેમે તેને જોઈને તેને પકડી અને બળાત્કાર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","યાકૂબની દીકરી દીના પર તેનું દિલ મોહી પડ્યું. તેણે તે જુવાન દીના પર પ્રેમ કર્યો અને તેણે તેની સાથે વાત કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","શખેમે પોતાના પિતા હમોરને કહ્યું, “આ યુવાન કન્યા સાથે મારું લગ્ન કરાવી આપ.” ");
INSERT INTO guj2017_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","હવે યાકૂબે સાંભળ્યું કે મારી દીકરી દીનાની સાથે તેણે બળાત્કાર કર્યો છે. તેના દીકરા ખેતરમાં જાનવરોની પાસે હતા, તેથી તેઓ આવ્યા ત્યાં સુધી યાકૂબ ચૂપ રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","શખેમનો પિતા હમોર યાકૂબની સાથે વાતચીત કરવાને તેની પાસે બહાર ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","જયારે યાકૂબના દીકરાઓએ એ સાંભળ્યું ત્યારે તેઓ ગુસ્સે ભરાયા અને ખેતરમાંથી આવ્યા. તેઓ ક્રોધિત થયા, કેમ કે શખેમે યાકૂબની દીકરી સાથે બળાત્કાર કરીને ઇઝરાયલને બદનામ કર્યું હતું આ બનાવ અણઘટતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","હમોર તેઓની સાથે વાતચીત કરીને બોલ્યો, “મારો દીકરો શખેમ તમારી દીકરીને પ્રેમ કરે છે. કૃપા કરી તેને તેની સાથે લગ્ન કરાવી આપો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","આપણે અરસપરસ વિવાહ કરીએ, એટલે તમારી દીકરીઓ અમને આપો અને અમારી દીકરીઓ તમે પોતાને માટે લો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","તમે અમારી સાથે રહો અને દેશ તમારી આગળ છે, તેમાં તમે રહો અને વેપાર કરીને માલમિલકત મેળવો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","શખેમે તેના પિતા તથા ભાઈઓને કહ્યું, “મહેરબાની કરીને મારી પર કૃપા દર્શાવો, તો તમે મને જે કહેશો તે હું આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","તમે મારી પાસે ગમે તેટલું મૂલ્ય તથા ભેટ માગો અને જે તમે મને કહેશો, તે પ્રમાણે આપીશ, પણ આ યુવાન કન્યા દીનાના લગ્ન મારી સાથે કરાવો.” ");
INSERT INTO guj2017_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","તેઓની બહેન દીના પર તેણે બળાત્કાર કર્યો હતો, માટે યાકૂબના દીકરાઓએ શખેમ તથા તેના પિતા હમોરને કપટથી ઉત્તર આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","તેઓએ તેઓને કહ્યું, “જે માણસની સુન્નત ન થઈ હોય તેને અમારી બહેન આપવી એ કામ અમે કરી શકતા નથી, કેમ કે તેથી અમારી બદનામી થાય. ");
INSERT INTO guj2017_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","કેવળ આ શરતે અમે તમારું માનીએ કે: જેમ અમે સુન્નત પામેલા છીએ, તેમ તમારાં સર્વ પુરુષોની સુન્નત કરાય. ");
INSERT INTO guj2017_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","પછી અમે અમારી દીકરીઓનાં લગ્ન તમારી સાથે કરાવીએ, તમારી દીકરીઓ સાથે અમે લગ્ન કરીએ અને તમારી સાથે રહીએ. આપણે પરસ્પર એકતામાં આવીએ. ");
INSERT INTO guj2017_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","પણ જો સુન્નત કરવા વિષે તમે અમારું ન સાંભળો, તો અમે અમારી બહેનને લઈને ચાલ્યા જઈશું.” ");
INSERT INTO guj2017_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","તેઓની વાત હમોર તથા તેના દીકરા શખેમને સારી લાગી. ");
INSERT INTO guj2017_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","તે જુવાન માણસે તે પ્રમાણે કરવામાં વાર ન લગાડી, કેમ કે તે યાકૂબની દીકરી માટે આશક્ત થયેલો હતો. તે પોતાના પિતાના ઘરમાં સર્વ કરતાં માનવંત માણસ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","હમોર તથા તેનો દીકરો શખેમ પોતાના નગરના દરવાજે આવ્યા અને પોતાના નગરના માણસો સાથે વાતચીત કરીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“આ માણસો આપણી સાથે શાંતિથી રહે છે, તે માટે તેઓને દેશમાં રહેવા દો; અને તેમાં વેપાર કરવા દો કેમ કે નિશ્ચે, આ દેશ તેઓ માટે પૂરતો છે. આપણે તેઓની દીકરીઓ સાથે લગ્ન કરીએ અને તેઓ આપણી દીકરીઓ સાથે લગ્ન કરે. ");
INSERT INTO guj2017_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","તેથી જેમ તેઓમાંના દરેક પુરુષની સુન્નત કરવામાં આવે છે, તેમ આપણા પણ દરેક પુરુષની સુન્નત કરવામાં આવે, કેવળ આ એક શરતે તેઓ આપણી સાથે રહેવા અને એકતામાં જોડાવાને સંમત થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","તેઓના ટોળાં, તેઓની સંપત્તિ તથા તેઓનાં ઢોરઢાંક, શું આપણાં નહિ થશે? તેથી આપણે તેઓની વાત માનીએ. તેઓ આપણી મધ્યે રહેશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","શહેરના સર્વ પુરુષોએ હમોર તથા તેના દીકરા શખેમનો પ્રસ્તાવ સ્વીકારી લીધો અને સર્વ પુરુષોની સુન્નત કરવામાં આવી. ");
INSERT INTO guj2017_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ત્રીજા દિવસે, સુન્નતના કારણે જયારે તેઓ પીડાતા હતા, ત્યારે યાકૂબના બે દીકરા, દીનાના ભાઈઓ, શિમયોન તથા લેવીએ તેમની તલવાર લીધી અને ઓચિંતા નગરમાં ધસી જઈને સર્વ પુરુષોને મારી નાખ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","તેઓએ હમોરને તથા તેના દીકરા શખેમને તલવારની ધારથી માર્યા અને શખેમના ઘરેથી દીનાને લઈને ચાલ્યા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","યાકૂબના બાકીના દીકરાઓએ મૃત્યુ પામેલાઓના એ નગરમાં આવીને તેને લૂટ્યું, કેમ કે તે લોકોએ તેઓની બહેનને ભ્રષ્ટ કરી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","તેઓએ તેઓનાં ઘેટાંબકરાં, ગધેડાં અને અન્ય જાનવરો તથા નગરમાં તથા ખેતરમાં જે હતું તે સર્વ તેઓની સંપત્તિ સહિત લૂંટી લીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","તેઓનાં સર્વ બાળકો તથા તેઓની પત્નીઓને તેઓએ કબજે કરી. વળી તેઓએ તેઓના ઘરોમાં જે હતું તે બધું પણ લઈ લીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","યાકૂબે શિમયોનને તથા લેવીને કહ્યું, “તમે મારા પર મુશ્કેલી લાવ્યા છો, આ દેશના રહેવાસીઓ એટલે કનાનીઓ તથા પરિઝીઓમાં તમે મને તિરસ્કારપાત્ર કર્યો છે. સંખ્યામાં મારા માણસો થોડા છે. જો તેઓ મારી વિરુદ્ધ એકઠા થઈને હુમલો કરે તો પછી મારો અને મારા પરિવારનો નાશ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","પણ શિમયોન તથા લેવીએ કહ્યું, “શખેમ ગણિકાની સાથે જેવું વર્તન કરે તેવું જ વર્તન અમારી બહેન સાથે કરે એ શું બરાબર છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ઈશ્વરે યાકૂબને કહ્યું, “હવે તું બેથેલમાં જા અને ત્યાં રહે. જયારે તું તારા ભાઈ એસાવથી ડરીને નાસી ગયો હતો ત્યારે જેમણે તને દર્શન આપ્યું હતું, તે ઈશ્વરને સારુ તું ત્યાં વેદી બાંધ.” ");
INSERT INTO guj2017_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","પછી યાકૂબે તેના ઘરનાંને તથા જે સર્વ તેની સાથે હતાં તેઓને કહ્યું, “તમારી વચ્ચે જે અન્ય દેવો છે તેઓને દૂર કરો, પોતપોતાને શુદ્ધ કરો અને તમારાં વસ્ત્ર બદલો. ");
INSERT INTO guj2017_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","પછી આપણે બેથેલમાં જઈએ. જે ઈશ્વરે મારી આપત્તિના દિવસે મને સાંભળ્યો હતો અને જ્યાં કંઈ હું ગયો ત્યાં જેઓ મારી સાથે રહ્યા, તેમને સારુ ત્યાં વેદી બાંધવાની છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","તેથી તેઓએ તેમની પાસે જે અન્ય દેવો હતા, તથા તેમના કાનમાં જે કુંડળો હતાં તે સર્વ યાકૂબને આપ્યાં. યાકૂબે શખેમની પાસે એલોન વૃક્ષ નીચે તેઓને દાટી દીધાં. ");
INSERT INTO guj2017_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","જેમ જેમ તેઓ આગળ વધતાં ગયાં, તેમ તેમ ઈશ્વરે તેઓની ચારેગમનાં નગરોને ભયભીત કર્યા. તેથી ત્યાંના લોકોએ યાકૂબના દીકરાઓનો પીછો કર્યો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","યાકૂબ તથા તેની સાથેના સર્વ લોકો કનાન દેશમાં આવેલા લૂઝ એટલે બેથેલમાં પહોંચ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","તેણે ત્યાં વેદી બાંધી અને તે જગ્યાનું નામ એલ બેથેલ પાડ્યું, કેમ કે જયારે તે તેના ભાઈથી નાસી જતો હતો, ત્યારે ત્યાં ઈશ્વરે તેને દર્શન આપ્યું હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","રિબકાની સંભાળ રાખનારી દાઈ દબોરા મૃત્યુ પામી. તેને બેથેલ પાસે એલોન વૃક્ષ નીચે દફનાવામાં આવી તેથી તે વૃક્ષનું નામ એલોન-બાખૂથ રાખવામાં આવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","જયારે પાદ્દાનારામથી યાકૂબ આવ્યો ત્યારે ઈશ્વરે તેને ફરી દર્શન આપ્યું અને આશીર્વાદ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ઈશ્વરે તેને કહ્યું, “તારું નામ યાકૂબ છે પણ હવેથી તારું નામ યાકૂબ કહેવાશે નહિ. તારું નામ ઇઝરાયલ થશે.” તેમણે તેનું નામ ઇઝરાયલ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ઈશ્વરે તેને કહ્યું, “હું સર્વસમર્થ ઈશ્વર છું. તું સફળ થા અને વૃદ્ધિ પામ. તારા વંશમાં પ્રજાઓ અને પ્રજાઓના સમુદાયો પેદા થશે અને તારાં સંતાનોમાંથી કેટલાંક રાજાઓ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","મેં જે દેશ ઇબ્રાહિમને તથા ઇસહાકને આપ્યો છે, તે હું તને આપીશ અને તારા પછી તારા સંતાનોને પણ હું તે દેશ આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","જે જગ્યાએ ઈશ્વરે તેની સાથે વાત કરી હતી ત્યાંથી તેઓ ચાલ્યા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","જ્યાં ઈશ્વરે તેની સાથે વાત કરી હતી તે જગ્યાએ યાકૂબે પથ્થરનું એક સ્મારક એટલે સ્તંભ ઊભો કર્યો. તેણે તેના પર પેયાર્પણ કર્યું તથા તેલ રેડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","જ્યાં ઈશ્વરે તેની સાથે વાત કરી હતી તે જગ્યાનું નામ યાકૂબે બેથેલ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","તેઓ બેથેલથી આગળ વધ્યા. એફ્રાથ પહોંચવાને હજી થોડું અંતર બાકી રહ્યું હતું ત્યારે રાહેલને પ્રસૂતિપીડા થઈ. તેને સખત દુઃખાવો ઊપડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","જયારે તે સખત પીડાતી હતી ત્યારે તેને તેની દાઈએ કહ્યું, “બીશ નહિ, કેમ કે હવે તને બીજો દીકરો જન્મ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","જયારે તેનો જીવ જવા જેવો થયો ત્યારે તેના છેલ્લાં શ્વાસે તેણે તેનું નામ બેનોની પાડ્યું પણ તેના પિતાએ તેનું નામ બિન્યામીન પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","રાહેલ મૃત્યુ પામી. તેને એફ્રાથ એટલે બેથલેહેમને રસ્તે દફનાવવામાં આવી. ");
INSERT INTO guj2017_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","યાકૂબે તેની કબર પર સ્તંભ ઊભો કર્યો, તે આજ સુધી રાહેલની કબરનો સ્તંભ કહેવાય છે. ");
INSERT INTO guj2017_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ઇઝરાયલ મુસાફરી કરતાં આગળ વધ્યો અને મિગ્દાલ એદેરના બુરજની પેલી બાજુએ મુકામ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","જયારે ઇઝરાયલ તે દેશમાં હતો, ત્યારે રુબેન તેના પિતાની ઉપપત્ની બિલ્હાની પાસે જઈને તેની સાથે સૂઈ ગયો. તે ઘટના ઇઝરાયલના સાંભળવામાં આવી. યાકૂબના બાર દીકરા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","લેઆના દીકરા: યાકૂબનો જ્યેષ્ઠ દીકરો રુબેન તથા શિમયોન, લેવી, યહૂદા, ઇસ્સાખાર તથા ઝબુલોન. ");
INSERT INTO guj2017_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","રાહેલના દીકરા: યૂસફ તથા બિન્યામીન. ");
INSERT INTO guj2017_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","રાહેલની દાસી બિલ્હાના દીકરા: દાન તથા નફતાલી. ");
INSERT INTO guj2017_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","લેઆની દાસી ઝિલ્પાના દીકરા: ગાદ તથા આશેર. યાકૂબના દીકરા જે તેને પાદ્દાનારામમાં થયા તેઓ એ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","મામરે, એટલે કિર્યાથ-આર્બા જે હેબ્રોન કહેવાય છે, જ્યાં ઇબ્રાહિમ તથા ઇસહાક રહ્યાં હતા, ત્યાં યાકૂબ તેના પિતા ઇસહાકની પાસે આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ઇસહાકનું આયુષ્ય એકસો એંસી વર્ષનું હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ઇસહાક ઘણી વૃદ્ધ ઉંમરે મરણ પામ્યો અને તેના પૂર્વજો સાથે મળી ગયો. તેના દીકરા એસાવે તથા યાકૂબે તેને દફનાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","એસાવ એટલે અદોમની વંશાવળી આ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","એસાવે કનાનીઓની દીકરીઓ સાથે લગ્ન કર્યા. આ તેની પત્નીઓ હતી: આદા જે એલોન હિત્તીની દીકરી; ઓહોલીબામાહ જે સિબયોન હિવ્વીની દીકરી અનાની દીકરી હતી, ");
INSERT INTO guj2017_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","અને બાસમાથ જે ઇશ્માએલની દીકરી, નબાયોથની બહેન. ");
INSERT INTO guj2017_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","આદાએ એસાવને માટે અલિફાઝને જન્મ આપ્યો અને બાસમાથે રેઉએલને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ઓહોલીબામાહએ યેઉશ, યાલામ તથા કોરાને જન્મ આપ્યાં. એસાવને કનાન દેશમાં જે દીકરા જન્મ્યા હતા તેઓ એ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","એસાવ તેની પત્નીઓ, તેના દીકરા, તેની દીકરીઓ, તેના ઘરના સર્વ લોકો, તેનાં સર્વ જાનવરો, તથા તેની સર્વ માલમિલકત જે તેણે કનાન દેશમાં મેળવી હતી, તે સર્વ લઈને તેના ભાઈ યાકૂબની પાસેથી બીજા દેશમાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","તેણે આમ કર્યું કેમ કે તેઓની સંપત્તિ એટલી બધી હતી કે તેઓ એકસાથે રહી શકે તેમ ન હતું. જે દેશમાં તેઓ રહેતા હતા ત્યાં તેઓનાં જાનવરોને લીધે તેઓને કોઈ આશરો ન મળ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","તેથી એસાવ એટલે જે અદોમ કહેવાય છે તેણે સેઈર પહાડ પર જઈને વસવાટ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","સેઈર પહાડ પરના અદોમી લોકના પૂર્વજ, એસાવની વંશાવળી આ પ્રમાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","એસાવના દીકરાઓ: એસાવની પત્ની આદાનો દીકરો અલિફાઝ; અને એસાવની પત્ની બાસમાથનો દીકરો રેઉએલ. ");
INSERT INTO guj2017_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","તેમાન, ઓમાર, સફો, ગાતામ તથા કનાઝ એ અલિફાઝના દીકરા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","એસાવના દીકરા અલિફાઝની ઉપપત્ની તિમ્ના હતી, તેણે અલિફાઝને માટે અમાલેકને જન્મ આપ્યો. એસાવની પત્ની આદાના દીકરા એ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","રેઉએલના દીકરા આ છે: નાહાથ, ઝેરાહ, શામ્મા તથા મિઝઝા. આ એસાવની પત્ની બાસમાથના દીકરા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","સિબયોનની દીકરી અનાની દીકરી ઓહોલીબામાહ જે એસાવની પત્ની હતી તેના દીકરા આ છે: તેણે યેઉશ, યાલામ તથા કોરાને જન્મ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","એસાવના વંશજોનાં સરદારો આ હતાં: એસાવના જ્યેષ્ઠ દીકરા અલિફાઝના દીકરા: તેમાન, ઓમાર, સફો, કનાઝ, ");
INSERT INTO guj2017_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","કોરા, ગાતામ તથા અમાલેક હતા. જે સરદારો અલિફાઝથી અદોમ દેશમાં થયા તેઓ એ છે. તેઓ આદાના પૌત્રો હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","એસાવના દીકરા રેઉએલના કુટુંબો આ છે: નાહાથ, ઝેરાહ, શામ્મા, મિઝઝા. એ વંશજો રેઉએલથી અદોમ દેશમાં થયા. એ એસાવની પત્ની બાસમાથના દીકરા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","એસાવની પત્ની ઓહોલીબામાહના દીકરા આ છે: યેઉશ, યાલામ, કોરા. એ સરદારોને એસાવની પત્ની ઓહોલીબામાહ જે અનાની દીકરી હતી તેણે જન્મ આપ્યાં હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","એસાવના દીકરા અને તેઓના સરદારો આ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","સેઈર હોરીના દીકરા જે દેશના રહેવાસીઓ હતા તેઓ આ છે: લોટાન, શોબાલ, સિબયોન, અના, ");
INSERT INTO guj2017_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","દિશોન, એસેર તથા દિશાન. તે સેઈર હોરીઓના કુટુંબનાં સરદારો જે અદોમ દેશમાં થયા એ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","લોટાનના દીકરા હોરી તથા હોમામ હતા. તિમ્ના લોટાનની બહેન હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","શોબાલના દીકરા આ છે, એટલે આલ્વાન, માનાહાથ, એબાલ, શફો તથા ઓનામ. ");
INSERT INTO guj2017_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","સિબયોનના દીકરા આ છે, એટલે એયાહ તથા અના, જેને તેના પિતા સિબોનનાં ગધેડાં ચરાવતાં અરણ્યમાં ગરમ પાણીનાં ઝરા મળ્યા હતા તે એ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","અનાનાં સંતાનો આ છે: દિશોન તથા અનાની દીકરી ઓહોલીબામાહ. ");
INSERT INTO guj2017_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","દિશોનના દીકરા આ છે; હેમ્દાન, એશ્બાન, યિથ્રાન તથા ખરાન. ");
INSERT INTO guj2017_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","એસેરના દીકરા આ છે; બિલ્હાન, ઝાવાન, તથા અકાન. ");
INSERT INTO guj2017_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","દિશાનના દીકરા આ છે; ઉસ તથા આરાન. ");
INSERT INTO guj2017_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","હોરીઓના સરદારો આ છે; લોટાન, શોબાલ, સિબયોન તથા અના. ");
INSERT INTO guj2017_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","દિશોન, એસેર, દિશાન; સેઈર દેશમાં સરદારોની યાદી પ્રમાણે હોરીઓનું કુટુંબ એ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ઇઝરાયલીઓ પર કોઈ રાજાએ રાજ્ય કર્યા પહેલા અદોમ દેશમાં જે રાજાઓ રાજ્ય કરતા હતા તે આ છે: ");
INSERT INTO guj2017_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","બેઓરનો દીકરો બેલા અદોમમાં રાજ્ય કરતો હતો અને તેના શહેરનું નામ દિનહાબા હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","જયારે બેલા મૃત્યુ પામ્યો, ત્યારે તેની જગ્યાએ બોસરામાંના ઝેરાહનો દીકરો યોબાબ રાજા થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","જયારે યોબાબ મૃત્યુ પામ્યો ત્યારે તેની જગ્યાએ તેમાન દેશના હુશામે રાજ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","જયારે હુશામ મૃત્યુ પામ્યો ત્યારે તેની જગ્યાએ બદાદના દીકરા હદાદે રાજ કર્યું. તેણે મોઆબના પ્રદેશમાં મિદ્યાનીઓને હરાવ્યા હતા. તેના શહેરનું નામ અવીથ હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","જ્યારે હદાદ મૃત્યુ પામ્યો ત્યારે તેની જગ્યાએ માસરેકામાંના સામ્લાએ રાજ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","જયારે સામ્લા મૃત્યુ પામ્યો ત્યારે તેની જગ્યાએ નદી પાસેના રહોબોથના શાઉલે રાજ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","જયારે શાઉલ મૃત્યુ પામ્યો ત્યારે તેની જગ્યાએ આખ્બોરના દીકરા બાલ-હનાને રાજ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","જયારે આખ્બોરનો દીકરો બાલ-હનાન મૃત્યુ પામ્યો ત્યારે તેની જગ્યાએ હદારે રાજ કર્યું. તેના શહેરનું નામ પાઉ હતું. તેની પત્નીનું નામ મહેટાબેલ હતું, તે માટ્રેદની દીકરી, મેઝાહાબની પૌત્રી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","એસાવના વંશજોના, તેમના કુટુંબનાં આગેવાનોના નામ તેમના પ્રદેશ પ્રમાણે આ છે: તિમ્ના, આલ્વાહ, યથેથ, ");
INSERT INTO guj2017_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ઓહોલીબામાહ, એલા, પીનોન, ");
INSERT INTO guj2017_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","કનાઝ, તેમાન, મિબ્સાર, ");
INSERT INTO guj2017_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","માગ્દીએલ તથા ઇરામ; તેઓએ કબજે કરેલ દેશમાં તેમના વતન પ્રમાણે અદોમના કુટુંબોના વડા એ છે. અદોમીઓનો પિતા એસાવ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","યાકૂબ તેનો પિતા જે દેશમાં રહેતો હતો તેમાં, એટલે કનાન દેશમાં રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","યાકૂબના વંશ સંબંધિત આ વૃતાંત છે. યૂસફ સત્તર વર્ષનો જુવાન થયો, ત્યારે તે તેના ભાઈઓની સાથે ઘેટાંબકરાં સાચવતો હતો. તે તેના પિતાની પત્નીઓ બિલ્હા તથા ઝિલ્પાના દીકરાઓની સાથે હતો. યૂસફ તેઓના દુરાચારની જાણ તેના પિતાને કરતો રહેતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","હવે ઇઝરાયલ તેના સર્વ દીકરાઓ કરતાં યૂસફ પર વિશેષ પ્રેમ રાખતો હતો, કેમ કે તે તેના વૃદ્ધાવસ્થાનો દીકરો હતો. તેણે તેને સારુ રંગબેરંગી ઝભ્ભો સીવડાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","તેના ભાઈઓએ જાણ્યું કે તેઓનો પિતા તેના તમામ દીકરાઓમાંથી યૂસફ પર વિશેષ પ્રેમ કરે છે. તેથી તેઓ તેને નફરત કરતા હતા અને તેની સાથે શુદ્ધ હૃદયથી વાત કરતા નહોતા. ");
INSERT INTO guj2017_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","યૂસફને સ્વપ્ન આવ્યું અને તેણે તેના ભાઈઓને તેના વિષે કહી સંભળાવ્યું. તેથી તેઓ તેને વધારે નફરત કરવા લાગ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","તેણે તેઓને કહ્યું, “મેં જે સ્વપ્નમાં જોયું છે તે મહેરબાની કરી સાંભળો.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","આપણે ખેતરમાં અનાજની પૂળીઓ બાંધતા હતા. ત્યારે મારી પૂળી ઊભી થઈ. તેની સામે તમારી પૂળીઓ ચારેતરફ ઊભી રહી. તેઓ મારી પૂળીની આગળ નમી.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","તેના ભાઈઓએ તેને કહ્યું, “શું તું ખરેખર અમારા પર રાજ કરશે? શું તું ખરેખર અમારા પર અધિકાર ચલાવશે? “તેઓ તેના સ્વપ્નને લીધે તથા તેની વાતને લીધે તેના પર વધારે નફરત કરવા લાગ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","તેને ફરી બીજું સ્વપ્ન આવ્યું. તે વિષે તેણે તેના ભાઈઓને કહ્યું, “જુઓ, મને બીજું એક સ્વપ્ન આવ્યું: સૂર્ય, ચંદ્ર તથા અગિયાર તારાઓ મારી આગળ નમ્યાં.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","જેવું તેણે તેના ભાઈઓને કહ્યું તેવું તેણે તેના પિતાને પણ કહ્યું અને તેના પિતાએ તેને ધમકાવ્યો. તેણે તેને કહ્યું, “જે સ્વપ્ન તને આવ્યું તે શું છે? તારી આગળ જમીન સુધી નમવાને હું, તારી માતા તથા તારા ભાઈઓ શું ખરેખર આવીશું?” ");
INSERT INTO guj2017_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","તેના ભાઈઓને તેના પર અદેખાઈ આવી, પણ તેના પિતાએ તે વાત મનમાં રાખી. ");
INSERT INTO guj2017_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","તેના ભાઈઓ તેઓના પિતાના ટોળાં ચરાવવાને શખેમમાં ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ઇઝરાયલે યૂસફને કહ્યું, “શું તારા ભાઈઓ શખેમમાં ઘેટાંબકરાં ચરાવતા નથી? હું તને તેઓની પાસે મોકલું છું.” યૂસફે તેને કહ્યું, “હું તૈયાર છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","તેણે તેને કહ્યું, “હવે જા, તારા ભાઈઓ તથા ટોળાં સારાં છે કે નહિ તે જો અને મારી પાસે ખબર લઈ આવ.” પછી યાકૂબે તેને હેબ્રોનની ખીણમાંથી રવાના કર્યો અને યૂસફ શખેમમાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","જુઓ, યૂસફ ખેતરમાં ભટકતો હતો એટલામાં એક માણસ તેને મળ્યો. તે માણસે તેને પૂછ્યું, “તું કોને શોધે છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","યૂસફે કહ્યું, “હું મારા ભાઈઓને શોધું છું. કૃપા કરી, મને કહે કે, તેઓ અમારા પશુઓનાં ટોળાંને ક્યાં ચરાવે છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","તે માણસે કહ્યું, “તેઓ દોથાન તરફ ગયા છે, કેમ કે મેં તેઓને એવું કહેતાં સાંભળ્યાં હતા કે, “ચાલો આપણે દોથાન જઈએ.” યૂસફે પોતાના ભાઈઓની પાછળ જઈને દોથાનમાં તેઓને શોધી કાઢ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","તેઓએ તેને દૂરથી જોયો અને તેઓની પાસે તે આવી પહોંચે તે અગાઉ તેને મારી નાખવાને પેંતરો રચ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","તેના ભાઈઓએ એકબીજાને કહ્યું, “જુઓ, આ સ્વપ્નપતિ આવી રહ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","હવે ચાલો, આપણે તેને મારી નાખીને કોઈએક ખાડામાં નાખી દઈએ. પછી આપણે જાહેર કરીશું કે, ‘કોઈ જંગલી પશુ તેને ખાઈ ગયું છે.’ પછી તેના સ્વપ્નનું શું થાય છે તે આપણે જોઈશું.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","રુબેને તે સાંભળ્યું અને ભાઈઓના હાથમાંથી તેણે તેને છોડાવ્યો. તેણે કહ્યું, “આપણે તેનો જીવ લેવો નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","તેઓના હાથમાંથી તેને છોડાવીને તેના પિતાને સોંપવા માટે રુબેને તેઓને કહ્યું, “તેનું લોહી ન વહેવડાવીએ. પણ આ અરણ્યમાં જે ખાડો છે તેમાં તેને નાખી દઈએ; પણ તેને કશી ઈજા કરીએ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","યૂસફ જયારે તેના ભાઈઓની પાસે પહોંચ્યો, ત્યારે તેઓએ તેના અંગ પરનો ઝભ્ભો ઝૂંટવી લીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","તેઓએ તેને પકડીને ખાડામાં નાખી દીધો. પણ તે ખાડો ખાલી હતો અને તેમાં પાણી ન હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","પછી તેઓ ભોજન કરવા માટે નીચે બેઠા. તેઓએ તેમની આંખો ઊંચી કરીને જોયું, તો, ઇશ્માએલીઓનો સંઘ ગિલ્યાદથી આવતો હતો. પોતાની સાથે સુગંધીઓ, ઔષધ તથા બોળથી લાદેલાં ઊંટોને લઈને તેઓ મિસર દેશમાં જતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","યહૂદાએ તેના ભાઈઓને કહ્યું, “જો આપણે આપણા ભાઈને મારી નાખીને તેનું લોહી સંતાડી દઈએ તો તેથી આપણને શું મળે? ");
INSERT INTO guj2017_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ચાલો, આપણે તેને ઇશ્માએલીઓને વેચી દઈએ અને આપણે તેને કશું નુકસાન કરીએ નહિ. કેમ કે તે આપણો ભાઈ તથા આપણા કુટુંબનો છે.” તેના ભાઈઓએ તેનું કહેવું સ્વીકાર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","મિદ્યાની વેપારીઓ તેઓની પાસેથી પસાર થઈને જતા હતા ત્યારે યૂસફના ભાઈઓએ તેને ખાડામાંથી બહાર લાવીને વીસ ચાંદીના સિક્કામાં યૂસફને ઇશ્માએલીઓને વેચી દીધો. ઇશ્માએલીઓ મિસરમાં લઈ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","રુબેન પાછો ખાડાની પાસે આવ્યો અને જુઓ, યૂસફ તો ખાડામાં નહોતો. તેણે તેનાં વસ્ત્રો ફાડીને શોક પ્રદર્શિત કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","તેણે તેના ભાઈઓની પાસે પાછા આવીને કહ્યું, “યુસફ ક્યાં છે? અને હું ક્યાં જાઉં?” ");
INSERT INTO guj2017_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","પછી તેઓએ એક બકરું કાપ્યું અને યૂસફના ઝભ્ભાને લઈને તેના લોહીમાં પલાળ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","પછી તેઓ તે ઝભ્ભાને તેના પિતાની પાસે લાવ્યા અને તે બતાવીને કહ્યું, “આ ઝભ્ભો અમને મળ્યો છે. કૃપા કરી ઓળખ, તે તારા દીકરાનો ઝભ્ભો છે કે નહિ?” ");
INSERT INTO guj2017_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","યાકૂબે તે ઓળખીને કહ્યું, “તે મારા દીકરાનો ઝભ્ભો છે. કોઈ જંગલી પશુએ તેને ફાડી ખાધો છે. ચોક્કસ યૂસફને ફાડી ખાવામાં આવ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","યાકૂબે તેનાં વસ્ત્રો ફાડયાં અને તેની કમરે ટાટ બાંધ્યું. તેણે તેના દીકરાને માટે ઘણાં દિવસો સુધી શોક કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","તેના સર્વ દીકરાઓ તથા તેની સર્વ દીકરીઓ તેને દિલાસો આપવા માટે આવીને ઊભા રહ્યાં. પણ તેણે દિલાસો પામવાની ના પાડી. તેણે કહ્યું, “હું નિશ્ચે શોક કરતો શેઓલમાં મારા દીકરાની પાસે જઈશ.” તેનો પિતા તેને સારુ રડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","પેલા મિદ્યાનીઓએ યૂસફને મિસરમાં ફારુનના રક્ષકોના સરદાર પોટીફારને વેચી દીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","તે સમયે યહૂદા તેના ભાઈઓની પાસેથી જઈને હીરા નામે એક અદુલ્લામીને ત્યાં રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ત્યાં યહૂદા એક કનાની માણસની દીકરી જેનું નામ શૂઆ હતું તેને મળ્યો. તેણે તેની સાથે લગ્ન કર્યું અને તેની સાથે સંબંધ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","શૂઆ સગર્ભા થઈ અને તેણે દીકરાને જન્મ આપ્યો. તેણે તેનું નામ એર પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","તે ફરીથી ગર્ભવતી થઈ અને દીકરાને જન્મ આપ્યો. તેણે તેનું નામ ઓનાન પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","તેણે ત્રીજા દીકરાને જન્મ આપ્યો અને તેનું નામ શેલા પાડ્યું. ત્યારે યહૂદા ખઝીબમાં રહેતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","યહૂદાએ તેના જયેષ્ઠ દીકરા એરનાં લગ્ન કરાવ્યાં. તેની પત્નીનું નામ તામાર હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","યહૂદાનો જયેષ્ઠ દીકરો એર ઈશ્વરની દ્રષ્ટિએ દુષ્ટ હતો. તેથી ઈશ્વરે તેને મરણાધીન કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","યહૂદાએ ઓનાનને કહ્યું, “તું તારા ભાઈની પત્ની પર પ્રેમ કર. તેના પ્રત્યે ભાઈની ફરજ બજાવ અને તારા ભાઈને સારુ સંતાન નિપજાવ.” ");
INSERT INTO guj2017_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ઓનાને વિચાર્યું કે એ સંતાન તેનું નહિ ગણાય. તેથી, જયારે પણ તે તેના ભાઈની પત્નીની પાસે જતો, ત્યારે તેના ભાઈના નામે સંતાન ન અપાય તે માટે તે પોતાનું વીર્ય તેના ભાભીના અંગમાં જવા દેવાને બદલે બહાર વેડફી દેતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","તેનું આ કૃત્ય ઈશ્વરની નજરમાં ખરાબ હતું. તેથી ઈશ્વરે તેને પણ મરણાધીન કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","પછી યહૂદાએ તેની પુત્રવધૂ તામારને કહ્યું કે, “મારો દીકરો શેલા પુખ્ત વયનો થાય, ત્યાં સુધી તું તારા પિતાના ઘરમાં વિધવા તરીકે રહે.” કેમ કે તેણે વિચાર્યું કે, “કદાચ તે પણ તેના ભાઈઓની જેમ મૃત્યુ પામે.” પછી તામાર જઈને તેના પિતાના ઘરમાં રહી. ");
INSERT INTO guj2017_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ઘણાં દિવસો પછી, યહૂદાની પત્ની શૂઆ મૃત્યુ પામી. યહૂદા દિલાસો પામ્યા પછી તે તેના મિત્ર હીરા અદુલ્લામી સાથે તેના ઘેટાં કાતરનારાઓની પાસે તિમ્ના ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","તામારને ખબર મળી, “જો, તારાં સસરા તેના ઘેટાં કાતરવાને તિમ્ના જઈ રહ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","તેણે તેની વૈધવ્ય અવસ્થાનાં વસ્ત્ર તેના શરીર પરથી ઉતાર્યા અને ઘૂંઘટથી પોતાને આચ્છાદિત કરીને એનાઈમના દરવાજા પાસે, તિમ્નાના માર્ગની બાજુએ જઈને બેઠી. કેમ કે તેણે જાણ્યું કે શેલા મોટો થયો છે, પણ તેને તેની પત્ની થવા માટે આપવામાં આવી નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","જયારે યહૂદાએ તેને જોઈ, ત્યારે તેણે વિચાર્યું કે તે ગણિકા હશે, કેમ કે તેણે તેનું મુખ ઢાંક્યું હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","તે માર્ગની બાજુએ તેની પાસે ગયો અને કહ્યું, “ચાલ, મને તારી સાથે સંબંધ બાંધવા દે.” કેમ કે તે તેની પુત્રવધૂ છે એ તે જાણતો નહોતો. તેણે કહ્યું, “મારી સાથે સંબંધ બાંધવાના બદલામાં તું મને શું આપીશ? ");
INSERT INTO guj2017_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","તેણે કહ્યું, “ટોળાંમાંથી એક લવારું હું તને મોકલી આપું છું.” તેણીએ કહ્યું, જ્યાં સુધી તું તે ના મોકલે ત્યાં સુધી તું મને કશું ગીરવે આપું? ");
INSERT INTO guj2017_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","તેણે કહ્યું, હું તને શું ગીરવે આપી શકું? તેણે કહ્યું, “તારી મુદ્રા, તારો અછોડો તથા તારા હાથમાંની લાકડી.” તેણે તેને તે આપ્યાં. પછી તે તેની પાસે ગયો. તેના સંસર્ગથી તે ગર્ભવતી થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","તે ઊઠીને ચાલી. પછી તેણે તેનો ઘુંઘટ ઉતાર્યો અને તેનાં વૈધવ્યનાં વસ્ત્ર પહેર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","તે સ્ત્રીના હાથમાંથી ગીરવે મૂકેલી વસ્તુ લેવા માટે યહૂદાએ તેના મિત્ર અદુલ્લામીની સાથે લવારું મોકલ્યું, પણ તે તેને મળી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","પછી અદુલ્લામીએ તે જગ્યાના માણસોને પૂછ્યું, “જે ગણિકા એનાઈમ પાસેના માર્ગ પર હતી તે ક્યાં છે?” તેઓએ કહ્યું, “અહીં તો કોઈ ગણિકા નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","તે યહૂદાની પાસે પાછો આવ્યો અને કહ્યું, “મને તે મળી નથી. ત્યાંના માણસોએ પણ કહ્યું કે, ‘અહીં કોઈ ગણિકા ન હતી.’” ");
INSERT INTO guj2017_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","યહૂદાએ કહ્યું, “તે ભલે તેની પાસે વસ્તુઓ રાખે, રખેને આપણે શરમજનક સ્થિતિમાં મુકાઈએ. તેને લીધે, મેં આ લવારું મોકલ્યું, પણ તને તે મળી નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","પછી આશરે ત્રણેક મહિના પછી યહૂદાને ખબર મળી કે, “તેની પુત્રવધૂ તામારે વ્યભિચાર કર્યો છે અને તે ગર્ભવતી થઈ છે.” યહૂદાએ કહ્યું, “તેને અહીં લાવો અને સળગાવી દો.” ");
INSERT INTO guj2017_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","જયારે તેને ત્યાં લાવવામાં આવી ત્યારે તેણે પેલા પુરાવા સાથે તેના સસરાને સંદેશ કહેવડાવ્યો કે, “આ વસ્તુઓ જેની છે, તેનાથી હું ગર્ભવતી થયેલી છું” તેણે કહ્યું, “આ મુદ્રા, અછોડો તથા લાકડી કોનાં છે, તે મહેરબાની કરીને તું ઓળખી લે.” ");
INSERT INTO guj2017_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","યહૂદાએ એ વસ્તુઓને ઓળખી અને કહ્યું, “તે મારા કરતાં ન્યાયી છે, કારણ કે મેં તેને મારા દીકરા શેલાને પત્ની તરીકે ન આપી. તે પછી તેણે તેની સાથે સંબંધ બાંધ્યો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","તેની પ્રસૂતિના સમયે એમ થયું કે, તેના પેટમાં જોડિયાં બાળકો હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","જન્મ આપતી વખતે પ્રથમના એક બાળકે તેનો હાથ બહાર કાઢ્યો તેથી દાસીએ તેનો હાથ પકડ્યો અને તેના હાથ પર લાલ દોરો બાંધ્યો. તેણે કહ્યું, “આનો જન્મ પ્રથમ થયો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","પછી તેણે તેનો હાથ પાછો ખેંચ્યો ત્યારે, તેના ભાઈનો જન્મ થયો અને દાસીએ કહ્યું, તું કેમ કરીને જન્મ પામ્યો? તેણે તેનું નામ પેરેસ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","પછી તેનો ભાઈ, જેને હાથે લાલ દોરો હતો તે જન્મ પામયો. તેનું નામ ઝેરાહ પડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","યૂસફને મિસરમાં લાવવામાં આવ્યો. ત્યાં જે ઇશ્માએલીઓ તેને લઈને આવ્યા હતા, તેઓની પાસેથી પોટીફાર નામનો એક મિસરી, જે ફારુનનો એક અમલદાર તથા રક્ષકોનો સરદાર હતો, તેણે યૂસફને વેચાતો લીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ઈશ્વર યૂસફની સાથે હતા. પોટીફાર ઘણા સંપત્તિવાન માણસ હતો. યૂસફે તેના માલિક, મિસરી પોટીફારના ઘરમાં વસવાટ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","તેના માલિકે જોયું કે ઈશ્વર યૂસફની સાથે છે અને તે જે કંઈ કરે છે તેમાં ઈશ્વર તેને સફળ કરે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","તેથી યૂસફ તેની દ્રષ્ટિમાં કૃપાપાત્ર થયો અને તેણે પોટીફારની સેવા કરી. પોટીફારે તેને તેના ઘરનો કારભારી ઠરાવીને તેનું જે સર્વ હતું તે તેનો વહીવટ તેના હાથમાં સોંપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","તેણે તેના ઘરનો તથા તેની સર્વ મિલકતનો કારભારી તેને ઠરાવ્યો, ત્યાર પછીથી ઈશ્વરે યૂસફને લીધે મિસરીના ઘરને આશીર્વાદ આપ્યો. ઘરમાં તથા ખેતરમાં જે સર્વ તેનું હતું તે પર ઈશ્વરનો આશીર્વાદ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","પોટીફારનું જે હતું તે સર્વ તેણે યૂસફના હાથમાં સોંપ્યું. તે જે અન્ન ખાતો તે સિવાય તેનું પોતાનું શું શું છે, એ કંઈપણ તે જાણતો નહોતો. યૂસફ સુંદર તથા આકર્ષક હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","પછી એવું થયું કે તેના માલિક પોટીફારની પત્નીએ યૂસફ પર કુદ્રષ્ટિ કરીને કહ્યું, “મારી સાથે સૂઈ જા.” ");
INSERT INTO guj2017_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","પણ તેણે ઇનકાર નકાર કરીને તેના માલિકની પત્નીને કહ્યું, “જો, ઘરમાં શું શું મારા હવાલામાં છે તે મારો માલિક જાણતો નથી અને તેણે તેનું જે સર્વ છે તે મારા હાથમાં સોંપ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","આ ઘરમાં મારા કરતાં કોઈ મોટો નથી. તેણે તારા વિના બીજા કશા જ પર મારા માટે રોક લગાવી નથી, કેમ કે તું તેની પત્ની છે. તો પછી આવું મોટું દુષ્કર્મ કરીને હું શા માટે ઈશ્વરનો અપરાધી થાઉં?” ");
INSERT INTO guj2017_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","દરરોજ તે યૂસફને મોહપાશમાં આકર્ષતી હતી, પણ તેણે તેના પર મોહિત થવાનો તથા તેની સાથે રહેવાનો ઇનકાર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","એક દિવસે એમ થયું કે યૂસફ પોતાનું કામ કરવા માટે ઘરમાં ગયો. ઘરનું અન્ય કોઈ માણસ અંદર ન હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ત્યારે પોટીફારની સ્ત્રીએ યૂસફના વસ્ત્રો પકડીને કહ્યું, “મારી સાથે સૂઈ જા.” પણ તે તેનું વસ્ત્ર તેના હાથમાં રહેવા દઈને નાસીને બહાર જતો રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","જયારે સ્ત્રીએ જોયું કે તે તેનું વસ્ત્ર તેના હાથમાં મૂકીને બહાર નાસી ગયો છે, ");
INSERT INTO guj2017_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ત્યારે તેણે તેના ઘરમાંનાં માણસોને બોલાવીને તેઓને કહ્યું, “જુઓ, મારો પતિ પોટીફાર આપણું અપમાન કરવાને આ હિબ્રૂ માણસને આપણી પાસે લાવ્યો છે. તે મારી સાથે સુવા માટે મારી પાસે આવ્યો એટલે મેં બૂમ પાડી. ");
INSERT INTO guj2017_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","અને મેં જયારે બૂમ પાડી, ત્યારે તે સાંભળીને તે તેનું વસ્ત્ર મારા હાથમાં રહેવા દઈને નાસી ગયો અને બહાર જતો રહ્યો.” ");
INSERT INTO guj2017_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","તેનો પતિ ઘરે આવ્યો ત્યાં સુધી તેણે તેનું વસ્ત્ર પોતાની પાસે રાખી મૂક્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","તેણે તેના પતિ સમક્ષ ખુલાસો કર્યો કે, “આ હિબ્રૂ દાસ કે જેને તું આપણા ઘરમાં લાવ્યો છે, તે મારી આબરુ લેવા માટે મારી પાસે આવ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","પણ જયારે મેં બૂમ પાડી, ત્યારે તે તેનું વસ્ત્ર મારી પાસે રહેવા દઈને નાસી છૂટ્યો.” ");
INSERT INTO guj2017_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","જયારે તેના માલિકે તેની પત્નીની કહેલી વાત સાંભળી કે, “તારા દાસે મને આમ કર્યું,” ત્યારે તે ઘણો ગુસ્સે થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","તેણે યૂસફને જે જગ્યાએ રાજાના કેદીઓ કેદ કરાતા હતા, તે કેદખાનામાં પુરાવી દીધો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","પણ ઈશ્વર યૂસફની સાથે હતા અને તેમણે તેના પર દયા કરી. તેને કેદખાનાના અમલદારની દ્રષ્ટિમાં કૃપા પમાડી. ");
INSERT INTO guj2017_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","જે કેદીઓ કેદખાનામાં હતા તેઓ સર્વને અમલદારે યૂસફના હાથમાં સોપ્યા. ત્યાં જે કામ તેઓ કરતા તેની દેખરેખ યૂસફ રાખતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","તે કેદખાનાનો અમલદાર યૂસફનાં કોઈપણ કામમાં માથું મારતો ન હતો કે તેની ચિંતા કરતો ન હતો. કેમ કે ઈશ્વર યૂસફની સાથે હતા. તેણે જે કંઈ કામ કર્યું તેમાં ઈશ્વરે તેને સફળતા બક્ષી. ");
INSERT INTO guj2017_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","એ બીનાઓ પછી એમ થયું કે મિસરના રાજાના પાત્રવાહકે તથા રસોઈયાએ તેમના માલિક મિસરના રાજાનો ગુન્હો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ફારુન તેના બન્ને સેવકો પર, એટલે મુખ્ય પાત્રવાહક તથા મુખ્ય રસોઈયા પર ક્રોધિત થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","જ્યાં યૂસફ બંદીવાન હતો તે કેદખાનામાં એટલે અંગરક્ષકોના ઉપરી અમલદારને ત્યાં તેણે તે બન્નેને કેદ કરાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","અંગરક્ષકોના ઉપરી અમલદારે યૂસફને તેઓના ઉત્તરદાયી તરીકે નીમ્યો. તેણે તેઓની દેખભાળ રાખી. તેઓ કેટલીક મુદત સુધી કેદમાં રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","અને મિસરના રાજાનો પાત્રવાહકને તથા રસોઈયાને એક જ રાત્રે, સ્વપ્નના જુદા જુદા અર્થ પ્રમાણે, સ્વપ્ન આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","યૂસફે સવારે તેઓની પાસે અંદર આવીને તેઓને જોયા ત્યારે તેઓ ઉદાસ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ફારુનના એ અમલદારો કે જેઓ તેની સાથે તેના માલિકના ઘરમાં કેદી હતા તેઓને યૂસફે પૂછ્યું, “તમે આજે ઉદાસ કેમ દેખાઓ છો?” ");
INSERT INTO guj2017_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","તેઓએ તેને કહ્યું, “અમને બન્નેને સ્વપ્ન આવ્યું છે અને તેનો અર્થ બતાવે એવો કોઈ મળી શકે તેમ નથી.” યૂસફે તેઓને કહ્યું, “અર્થ બતાવવો એ શું ઈશ્વરનું કામ નથી? તમારા સ્વપ્ન વિષે મને જણાવો તો ખરા!” ");
INSERT INTO guj2017_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","મુખ્ય પાત્રવાહકે તેનું સ્વપ્ન યૂસફને જણાવ્યું, “જુઓ, મારા સ્વપ્નમાં મારી સામે એક દ્રાક્ષવેલો દેખાયો. ");
INSERT INTO guj2017_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","તે દ્રાક્ષવેલાને ત્રણ ડાળીઓ હતી. તેઓને જાણે કળીઓ આવી, મોર ખીલ્યો અને તેના ગુચ્છામાં દ્રાક્ષો પાકી. ");
INSERT INTO guj2017_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ફારુનનો પ્યાલો મારા હાથમાં હતો. મેં દ્રાક્ષો લઈને ફારુનના પ્યાલામાં તેનો રસ નિચોવીને એ પ્યાલો ફારુનના હાથમાં આપ્યો.” ");
INSERT INTO guj2017_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","યૂસફે તેને કહ્યું, “એનો અર્થ આ છે: ત્રણ ડાળી તે ત્રણ દિવસ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ત્રણ દિવસમાં ફારુન તને પ્રતિષ્ઠિત કરશે અને તને પાછો તારી અસલ ફરજ પર પુનઃનિયુક્ત કરશે. તું તેનો પાત્રવાહક હતો ત્યારની પ્રણાલી પ્રમાણે તું ફારુનને તેનો પ્યાલો તેના હાથમાં આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","પણ તારું સારું થાય ત્યારે કૃપા કરીને મને યાદ કરીને મારા પર દયા કરજે. મારા વિષે ફારુનને જણાવીને આ કેદમાંથી હું બહાર આવું એવું કરજે. ");
INSERT INTO guj2017_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","કેમ કે હિબ્રૂઓના દેશમાંથી હું ખરેખર ફેંકાઈ ગયેલો છું. અહીં પણ કેદમાં નંખાવા જેવો કોઈ અપરાધ મેં કરેલો નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","જયારે મુખ્ય રસોઈયાએ જોયું કે ખુલાસાનો અર્થ સારો છે, ત્યારે તેણે યૂસફને કહ્યું, “મને પણ સ્વપ્ન આવ્યું હતું. રોટલી ભરેલી ત્રણ ટોપલીઓ મારા માથા પર હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ઉપલી ટોપલીમાં ફારુનને માટે સર્વ પ્રકારનાં પકવાન હતાં, પણ મારા માથા પરની એ ટોપલીઓમાંથી પક્ષીઓ ખાઈ જતા હતાં.” ");
INSERT INTO guj2017_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","યૂસફે ઉત્તર આપીને કહ્યું, “એનો અર્થ આ છે. તે ત્રણ ટોપલી ત્રણ દિવસ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ત્રણ દિવસમાં ફારુન તારું માથું તારા ધડ પરથી દૂર કરશે અને તને ઝાડ પર લટકાવવામાં આવશે. પક્ષીઓ તારું માંસ ખાશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ત્રીજે દિવસે, એટલે ફારુનના જન્મ દિવસે એમ થયું કે તેણે તેના સર્વ સેવકોને મિજબાની આપી. તેણે તેના બીજા અધિકારીઓ સમક્ષ કરતાં મુખ્ય પાત્રવાહક તથા મુખ્ય રસોઈયા પર ધ્યાન આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","તેણે મુખ્ય પાત્રવાહકને તેની અસલની પદવી પર પાછો નિયુક્ત કર્યો અને તેણે પ્યાલો ફારુનના હાથમાં ફરીથી મુક્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","યૂસફે મુખ્ય રસોઈયાને અર્થ સમજાવ્યો હતો તે પ્રમાણે ફારુને તેને ફાંસી આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","પણ મુખ્ય પાત્રવાહકે યૂસફને યાદ કર્યો નહિ. તે તેને ભૂલી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","બે વર્ષ પછી ફારુનને સ્વપ્ન આવ્યું. તેમાં તે નીલ નદીની પાસે ઊભો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ત્યાં સુંદર તથા પુષ્ટ એવી સાત ગાયો નદીમાંથી બહાર આવીને સરકટના બીડમાં ચરવા લાગી. ");
INSERT INTO guj2017_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","અચાનક તેઓની પાછળ કદરૂપી તથા સૂકાઈ ગયેલી એવી બીજી સાત ગાયો નીલ નદીમાંથી બહાર આવી. તેઓ નદીને કિનારે અન્ય ગાયોની પાસે ઊભી રહી. ");
INSERT INTO guj2017_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","પછી કદરૂપી તથા સૂકાઈ ગયેલી ગાયો પેલી સાત સુંદર તથા પુષ્ટ ગાયોને ગળી ગઈ. એટલામાં ફારુનની ઊંઘ ઊડી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","પછી તે પાછો ઊંઘી ગયો અને તેને બીજું સ્વપ્ન આવ્યું. એક સાંઠા પર દાણા ભરેલાં તથા સારાં એવાં સાત કણસલાં આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","તેઓની પછી સુકાઈ ગયેલાં તથા પૂર્વના પવનથી ચીમળાયેલાં એવાં સાત કણસલાં આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","અને સુકાઈ ગયેલાં કણસલાં પેલા સાત પાકાં તથા દાણા ભરેલાં કણસલાંને ગળી ગયાં. ફારુન જાગી ગયો. તેને થયું કે, તે તો સ્વપ્ન હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","સવારે તે ઊઠ્યો ત્યારે તેનું મન ગભરાયું. તેણે મિસરના સર્વ શાસ્ત્રીઓને તથા જ્ઞાનીઓને બોલાવ્યા; અને પોતે જોયેલાં સ્વપ્ન વિષે તેઓને જણાવ્યું; પણ તેઓમાં એવો કોઈ ન હતો કે જે ફારુનનાં સ્વપ્નનો અર્થ જણાવી શકે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","એટલામાં મુખ્ય પાત્રવાહકે ફારુનને કહ્યું, “આજે મને મારો અપરાધ યાદ આવે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","જયારે ફારુનને પોતાના દાસો પર ગુસ્સો આવ્યો હતો અને મને તથા મુખ્ય રસોઈયાને અંગરક્ષકોના ઉપરી અમલદારના ઘરમાં નજરકેદ કર્યા હતા, ");
INSERT INTO guj2017_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ત્યારે મને અને તેને એક જ રાત્રે સ્વપ્ન આવ્યાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ત્યાં એક હિબ્રૂ જુવાન જે અંગરક્ષકોના ઉપરી અમલદારનો દાસ હતો, તે અમારી સાથે કેદમાં હતો. અમે તેને અમારા સ્વપ્નો જણાવ્યાં અને તેણે અમારા સ્વપ્નના અર્થ કહી બતાવ્યા હતા. તેણે અમને બન્નેને અમારા સ્વપ્ન પ્રમાણે ખુલાસા કરી બતાવ્યાં હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","તેણે અમને સ્વપ્નના જે ખુલાસા કરી બતાવ્યા હતા, તે જ પ્રમાણે થયું. મને મારી પદવી પર પાછો નિયુક્ત કરવામાં આવ્યો અને રસોઈયાને ફાંસી આપવામાં આવી હતી.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ફારુને માણસો મોકલીને યૂસફને બોલાવી મંગાવ્યો. તેઓ તેને અંધારી કોટડીમાંથી ઉતાવળે બહાર લાવ્યા. તેની હજામત કરાવી. તેને નવાં વસ્ત્રો પહેરાવ્યાં અને ફારુનની સમક્ષ હાજર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ફારુને યૂસફને કહ્યું, “મને સ્વપ્ન આવ્યું હતું, પણ તેનો અર્થ જણાવનાર કોઈ નથી. પણ મેં તારા વિષે સાંભળ્યું છે કે, તું સ્વપ્ન સાંભળીને તેનો અર્થ કહી જણાવે છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","યૂસફે ફારુનને ઉત્તર આપ્યો, “હું નહિ, પણ ઈશ્વર આપને શાંતિ થાય એવો ઉત્તર આપશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ફારુને યૂસફને કહ્યું, “હું મારા સ્વપ્નમાં નીલ નદીને કિનારે ઊભો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ત્યાં પુષ્ટ તથા સુંદર એવી સાત ગાયો નીલ નદીમાંથી બહાર આવીને સરકટના બીડમાં ચરવા લાગી. ");
INSERT INTO guj2017_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","તેઓની પાછળ નબળી, બહુ કદરૂપી તથા સુકાઈ ગયેલી એવી બીજી સાત ગાયો નદીમાંથી બહાર આવી. તે એટલી બધી કદરૂપી હતી કે તેમના જેવી કદરૂપી ગાયો મેં આખા મિસર દેશમાં કદી જોઈ નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","તે કદરૂપી તથા દુબળી ગાયો બીજી સાત પુષ્ટ ગાયોને ગળી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","જ્યારે તેઓ તેને ખાઈ ગઈ, તો પણ તેઓ તેને ખાઈ ગઈ હોય એવું માલૂમ પડ્યું નહિ, પણ તેઓ અગાઉની જેમ જ કદરૂપી અને નબળી રહી. પછી હું જાગી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ફરીથી હું ઊંધી ગયો ત્યારે મેં મારા સ્વપ્નમાં જોયું કે, એક સાંઠા પર દાણાએ ભરેલાં તથા પાકાં એવાં સાત કણસલાં આવ્યાં, ");
INSERT INTO guj2017_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","અને તેઓની પાછળ સુકાઈ ગયેલાં તથા પૂર્વના પવનથી ચીમળાઈ ગયેલાં એવાં સાત કણસલાં આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","સુકાઈ ગયેલાં કણસલાં પેલા સાત સારાં કણસલાંને ગળી ગયાં. આ સ્વપ્ન મેં જ્ઞાનીઓને કહ્યા, પણ કોઈ એવો મળ્યો નહિ કે જે મને તેનો અર્થ જણાવી શકે.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","યૂસફે ફારુનને કહ્યું, “આપનાં સ્વપ્નો એક જેવા જ છે. ઈશ્વર જે કરવાના છે તે તેમણે આપને જણાવ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","જે સાત સારી ગાયો તે સાત વર્ષો છે અને સાત સારાં કણસલાં તે પણ સાત વર્ષો છે. સ્વપ્નો તો એકસમાન જ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","તેઓની પાછળ જે સુકાઈ ગયેલી તથા કદરૂપી ગાયો આવી તે સાત વર્ષ છે અને દાણા વગરના તથા પૂર્વના વાયુથી ચીમળાયેલાં જે સાત કણસલાં તે દુકાળનાં સાત વર્ષ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","જે વાત મેં ફારુનને કહી તે આ છે. ઈશ્વર જે કરવાના છે તે તેમણે આપને બતાવ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","જુઓ, આખા મિસર દેશમાં ઘણી પુષ્કળતાનાં સાત વર્ષ આવશે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","પછી દુકાળના સાત વર્ષ આવશે અને મિસર દેશમાં સર્વ પુષ્કળતા ભૂલી જવાશે અને દુકાળ દેશનો નાશ કરશે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","તે આવનાર દુકાળને કારણે દેશમાં પુષ્કળતા જણાશે નહિ કેમ કે તે દુકાળ બહુ કપરો હશે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ફારુનને બે વાર સ્વપ્ન આવ્યાં તે એ માટે કે એ વાત ઈશ્વરે નક્કી ઠરાવી છે અને ઈશ્વર તે થોડી જ વારમાં પૂરી કરવાના છે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","હવે ફારુને બુદ્ધિવંત તથા જ્ઞાની એવા માણસને શોધી કાઢીને તેને મિસર દેશ પર ઠરાવવો જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","વળી ફારુને આમ કરવું: મિસર દેશ પર ઉપરીઓ ઠરાવવા અને પુષ્કળતાનાં સાત વર્ષ દરમિયાન પેદાશનો પાંચમો ભાગ લઈને રાજ્યભંડારમાં ભરે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","જે સારાં વર્ષ આવશે, તેઓમાં તેઓ સઘળો ખોરાક એકઠો કરે અને ફારુનના હાથ નીચે સઘળું અનાજ નગરેનગર ખોરાકને માટે એકઠું કરીને તેને રાખી મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","પછી દુકાળનાં જે સાત વર્ષ મિસર દેશમાં આવશે તે માટે તે અન્ન દેશને માટે સંગ્રહ થશે. આ રીતે દુકાળથી દેશનો નાશ નહિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","આ વાત ફારુનને તથા તેના સર્વ દાસોને સારી લાગી. ");
INSERT INTO guj2017_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ફારુને પોતાના દાસોને કહ્યું, “જેનામાં ઈશ્વરનો આત્મા હોય, એવો આના જેવો અન્ય કોઈ માણસ આપણને મળે ખરો?” ");
INSERT INTO guj2017_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","તેથી ફારુને યૂસફને કહ્યું, “ઈશ્વરે આ સર્વ તને બતાવ્યું છે, તે જોતાં તારા જેવો બુદ્ધિમાન તથા જ્ઞાની બીજો કોઈ જણાતો નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","તું મારા રાજ્યનો ઉપરી થા. મારા સર્વ લોકો તારી આજ્ઞા પ્રમાણે ચાલશે. રાજ્યાસન પર હું એકલો જ તારા કરતાં મોટો હોઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ફારુને યૂસફને કહ્યું, “આજથી હું તને આખા મિસર દેશના મુખ્ય અધિકારી તરીકે નિયુક્ત કરું છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ફારુને પોતાની મુદ્રાવાળી વીંટી અધિકારના પ્રતિક તરીકે યૂસફની આંગળીએ પહેરાવી. તેને શણનાં વસ્ત્રો અને સોનાનો હાર પહેરાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","તેને બીજા દરજ્જાના રથમાં બેસાડ્યો અને લોકો તેની આગળ “ઘૂંટણ ટેકવો” એમ પોકારો પાડતા. ફારુને તેને આખા મિસર દેશનો ઉપરી નિયુક્ત કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ફારુને યૂસફને કહ્યું, “હું ફારુન છું અને મિસરના આખા દેશમાં તારો સંપૂર્ણ અધિકાર રહેશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ફારુને યૂસફનું નામ “સાફનાથ-પાનેઆ” પાડ્યું. ઓનના યાજક પોટીફારની પુત્રી આસનાથ સાથે તેનાં લગ્ન કરાવ્યાં. યૂસફ આખા મિસર દેશમાં સન્માન પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","યૂસફ મિસરના રાજા ફારુનની સમક્ષ દેશનો અધિપતિ થયો, ત્યારે તે ત્રીસ વર્ષનો હતો. તેણે આખા મિસર દેશમાં ફરીને માહિતી મેળવી. ");
INSERT INTO guj2017_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","પુષ્કળતાનાં સાત વર્ષમાં જમીનમાંથી પુષ્કળ અનાજ પાક્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","મિસર દેશમાં એ સાત વર્ષ દરમિયાન ઉપજેલું સઘળું અનાજ તેણે એકઠું કર્યું. તે અનાજ નગરોમાં ભરી રાખ્યું. દરેક નગરની આસપાસ જે ખેતરો હતાં તેઓનું અનાજ તેણે તે જ નગરમાં ભેગું કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","યૂસફે સમુદ્રની રેતી જેટલાં અનાજનો સંગ્રહ કર્યો. એટલું બધું અનાજ એકત્ર થયું કે તેનો તેણે હિસાબ રાખવાનું પણ મૂકી દીધું. ");
INSERT INTO guj2017_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","દુકાળનાં વર્ષો આવ્યાં તે અગાઉ યૂસફને બે દીકરા થયા, જે આસનાથ, ઓનના યાજક પોટીફારની દીકરીથી જન્મ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","યૂસફે પોતાના જ્યેષ્ઠ દીકરાનું નામ મનાશ્શા પાડ્યું, કેમ કે તેણે કહ્યું, “ઈશ્વરે મારાં સર્વ કષ્ટ તથા મારા પિતાના ઘરનું સર્વ મને વીસરાવી દીધું છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","બીજા દીકરાનું નામ તેણે એફ્રાઇમ પાડ્યું, કેમ કે તેણે કહ્યું, “મારા દુઃખના દેશમાં ઈશ્વરે મને સફળ કર્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","મિસર દેશમાં ભરપૂરીપણાનાં જે સાત વર્ષ આવ્યાં હતાં તે વિતી ગયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","યૂસફના કહ્યા પ્રમાણે, દુકાળનાં સાત વર્ષ શરૂ થયાં. દુકાળ સર્વ દેશોમાં વ્યાપેલો હતો, પણ આખા મિસર દેશમાં અન્નના ભંડાર ભરેલા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","જયારે આખો મિસર દેશ ભૂખે મરવા લાગ્યો, ત્યારે લોકોએ ફારુનની આગળ અનાજને માટે કાલાવાલા કર્યા. ફારુને સર્વ મિસરીઓને કહ્યું, “યૂસફની પાસે જાઓ અને તે તમને જે કહે તે કરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","પછી યૂસફે સર્વ કોઠારો ઉઘાડીને મિસરીઓને અનાજ વેચાતું આપ્યું. જો કે મિસર દેશમાં તે દુકાળ બહુ વિકટ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","સર્વ દેશોના લોકો મિસર દેશમાં યૂસફની પાસે અનાજ વેચાતું લેવાને આવ્યા, કેમ કે આખી પૃથ્વી પર સખત દુકાળ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","હવે યાકૂબના જાણવામાં આવ્યું કે મિસરમાં અનાજ મળે છે. તેથી તેણે તેના દીકરાઓને કહ્યું, “તમે એકબીજા સામે જોતા કેમ ઊભા છો?” ");
INSERT INTO guj2017_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","મારા સાંભળવામાં આવ્યું છે કે, “મિસરમાં અનાજ ઉપલબ્ધ છે. ત્યાં જાઓ અને ત્યાંથી આપણે સારુ અનાજ વેચાતું લાવો કે આપણે ખાઈને મરણથી બચીએ અને જીવતા રહીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","યૂસફના દસ ભાઈઓ અનાજ ખરીદવાને મિસરમાં ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","પણ તેઓની સાથે યૂસફના ભાઈ બિન્યામીનને યાકૂબે મોકલ્યો નહિ, કેમ કે તેણે કહ્યું, “કદાચને તેના પર કંઈ વિઘ્ન આવી પડે.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","બીજા લોકો કે જેઓ અનાજ વેચાતું લેવા આવેલા હતા તેઓની સાથે ઇઝરાયલના દીકરા પણ અનાજ માટે આવ્યા હતા. કેમ કે કનાન દેશમાં પણ દુકાળ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","અહીં મિસર દેશનો અધિપતિ યૂસફ હતો. દેશના સર્વ લોકોને અનાજ વેચાતું આપનાર તે જ હતો. યૂસફના ભાઈઓ આવ્યા અને તેઓએ જમીન સુધી માથાં નમાવીને તેને સાષ્ટાંગ દંડવત પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","યૂસફે પોતાના ભાઈઓને જોયાં. તેઓને ઓળખ્યા, પણ તે જાણે તેઓને ઓળખતો ન હોય તેમ તેઓની સાથે વર્ત્યો. તેણે તેઓની સાથે કઠોરતાથી વાત કરીને પૂછ્યું, “તમે ક્યાંથી આવ્યા છો? “તેઓએ કહ્યું, “અમે કનાન દેશથી અનાજ વેચાતું લેવાને આવ્યા છીએ. ");
INSERT INTO guj2017_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","યૂસફે તેના ભાઈઓને ઓળખ્યા પણ તેઓએ તેને ઓળખ્યો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","યૂસફને તેઓ વિષે જે સ્વપ્ન આવ્યાં હતાં તે યાદ આવ્યાં. તેણે તેઓને કહ્યું, “તમે જાસૂસ છે. અનાજને બહાને જાસૂસી કરવા આવ્યા છો.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","તેઓએ તેને કહ્યું, “ના, મારા માલિક, તારા દાસો અનાજ વેચાતું લેવાને આવ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","અમે સર્વ એક માણસના દીકરાઓ છીએ. અમે પ્રમાણિક પુરુષો છીએ. જાસૂસો નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","પણ યૂસફે તેઓને કહ્યું, “ના, તમે તો દેશની જાસૂસી માટે આવ્યા છો.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","તેઓ બોલ્યા, “અમે તારા દાસો બાર ભાઈઓ છીએ, કનાન દેશના એક માણસના દીકરા છીએ. જુઓ, નાનો ભાઈ અમારા પિતાની પાસે છે અને એક ભાઈનો તો પત્તો નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","યૂસફે તેઓને કહ્યું, “જેમ મેં તમને કહ્યું કે તમે જાસૂસ છો, એ વાત ખરી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","તેથી તમારી તપાસ કરવામાં આવશે. ફારુનના જીવના સમ કે તમારો નાનો ભાઈ અહીં આવ્યા વિના તમને અહીંથી જવા દેવામાં આવશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","તમે તમારામાંથી એકને મોકલો. તે તમારા ભાઈને લઈને અહીં આવે. તમને કેદમાં રાખવામાં આવશે. તમારી વાતની ખાતરી કરાશે કે તમે સાચું બોલો છો કે નહિ. હું તો ફારુનના સમ ખાઈને કહું છું કે તમે જાસૂસ જ છો.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","તેણે તેઓને ત્રણ દિવસ સુધી કેદમાં પૂરી રાખ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ત્રીજે દિવસે યૂસફે તેઓને કહ્યું, “તમે એક કામ કરો અને જીવતા રહો. કેમ કે હું ઈશ્વરથી ડરું છું. ");
INSERT INTO guj2017_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","જો તમે પ્રમાણિક અને સાચા પુરુષો હો, તો તમારામાંનો એક ભાઈ કેદખાનામાં રહે અને બાકીના જાઓ અને દુકાળને લીધે તમારા ઘર માટે અનાજ લઈ જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","તમારા નાના ભાઈને મારી પાસે લાવો. જેથી તમારી વાત સાચી ઠરશે અને તમે મરણને પાત્ર થશો નહિ.” તેથી તેઓએ એમ જ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","તેઓએ એકબીજાને કહ્યું, “નિશ્ચે આપણે આપણા ભાઈ સંબંધી અપરાધી છીએ, કેમ કે જયારે તેણે કાલાવાલા કર્યા ત્યારે આપણે તેની પીડા જોઈ, પણ તેનું સાંભળ્યું નહિ. તેથી આ સંકટ આપણા પર આવી પડ્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","રુબેને તેઓને ઉત્તર આપ્યો, “શું મેં તમને કહ્યું ન હતું, ‘આ છોકરા સંબંધી તમે પાપ ન કરો?’ પણ તમે માન્યું નહિ. હવે તેના લોહીનો બદલો લેવામાં આવે છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","તેઓ જાણતા ન હતા કે યૂસફ તેમની વાત સમજે છે, કેમ કે તેઓની અને યૂસફની વચ્ચે દુભાષિયા મારફતે વાતચીત થતી હતી. ");
INSERT INTO guj2017_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","યૂસફ તેના ભાઈઓની પાસેથી દૂર જઈને રડી પડ્યો. તેણે તેઓની પાસે પાછા આવીને વાત કરી. તેઓમાંથી શિમયોનને લઈને તેઓના દેખતાં તેને બાંધ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","પછી યૂસફે તેના ચાકરોને આજ્ઞા આપી કે તેઓની ગૂણોમાં અનાજ ભરો, દરેક માણસે ચૂકવેલાં નાણાં તેમની ગૂણમાં પાછાં મૂકો તથા તેઓની મુસાફરીને માટે ખાધસામગ્રી આપો. ચાકરોએ યૂસફની સૂચના પ્રમાણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","તેઓ તેમનાં ગધેડાં પર અનાજ લાદીને ત્યાંથી ઘરે જવા રવાના થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","રસ્તામાં રાતવાસો કર્યો ત્યારે એક ભાઈએ પોતાનાં ગધેડાંને દાણા ખવડાવવાને તેની ગૂણ છોડી, ત્યારે તેણે તેમાં પોતાનાં નાણાં જોયાં. તે તેની ગૂણમાં મૂકેલા હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","તેણે તેના ભાઈઓને કહ્યું, “મારાં નાણાં મને પાછાં મળ્યાં છે. તે મારી ગૂણમાં હતાં.” તેઓનાં મન ગભરાયા અને તેઓ ભયભીત થયા. તેઓએ કહ્યું, “ઈશ્વરે આપણને આ શું કર્યું છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","તેઓ કનાન દેશમાં તેઓના પિતા યાકૂબ પાસે આવ્યા. તેઓની સાથે જે બન્યું હતું તે બધી બાબતની વાત પિતા સમક્ષ કરતાં તેઓએ કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“જે માણસ તે દેશનો માલિક છે તે અમારી સાથે કઠોરતાથી વર્ત્યો અને અમને દેશના જાસૂસ ગણ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","અમે તેને કહ્યું, ‘અમે પ્રામાણિક માણસો છીએ. અમે જાસૂસ નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","અમે બાર ભાઈઓ, અમારા પિતાના દીકરા છીએ. એકનો તો પત્તો નથી અને નાનો અમારા પિતાની પાસે હમણાં કનાન દેશમાં છે” ");
INSERT INTO guj2017_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","તે માણસે એટલે દેશના માલિકે અમને કહ્યું, ‘તમે પ્રામાણિક માણસો છો એની ખાતરી માટે તમારા એક ભાઈને મારી પાસે રહેવા દો. તમે તમારા ભૂખે મરતા કુટુંબને માટે અનાજ લઈને જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","તમે તમારા નાના ભાઈને મારી પાસે લઈ આવો. તેથી હું જાણીશ કે તમે જાસૂસ નથી, પણ પ્રામાણિક માણસો છો. પછી હું તમારા ભાઈને મુક્ત કરીને તમને પાછો આપીશ અને તમને આ દેશમાં વેપાર કરવા દઈશ એટલે શિમયોનને ત્યાં રહેવા દેવો પડ્યો છે.’” ");
INSERT INTO guj2017_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","તેઓ પોતાની ગૂણો ખાલી કરતા હતા ત્યારે, દરેક માણસના નાણાંની થેલી તેની ગૂણમાં હતી. જયારે તેઓએ તથા તેઓના પિતાએ તેઓનાં નાણાંની થેલીઓ જોઈ ત્યારે તેઓ ખૂબ ગભરાયા. ");
INSERT INTO guj2017_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","તેઓના પિતા યાકૂબે તેઓને કહ્યું, “ઓ મારા દીકરાઓ, તમે મને પુત્રહીન કર્યો છે. યૂસફ રહ્યો નથી, શિમયોન મિસરમાં છે અને તમે બિન્યામીનને લઈ જવા બધું જ મારી વિરુદ્ધ થાય છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","રુબેને તેના પિતાને કહ્યું, “જો હું બિન્યામીનને તારી પાસે પાછો ન લાવું તો તું મારા બે દીકરાને મારી નાખજે. તેને મારા હાથમાં સોંપ અને હું તેને તારી પાસે પાછો લાવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","યાકૂબે કહ્યું, “મારો દીકરો તમારી સાથે નહિ આવે. કેમ કે તેનો ભાઈ મરી ગયો છે અને તે એકલો રહ્યો છે. જે માર્ગે તમે જાઓ છો ત્યાં જો તેના પર વિઘ્ન આવી પડે, તો તમારાથી મારી આ વૃદ્ધાવસ્થામાં મારું મરણ થાય, તમે એવું કરવા ઇચ્છો છો.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","કનાન દેશમાં ભયંકર દુકાળ તો વ્યાપેલો જ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","તેઓ મિસરમાંથી જે અનાજ લાવ્યા હતા, તે પૂરું થવા આવ્યું હતું ત્યારે તેઓના પિતાએ તેઓને કહ્યું, “તમે ફરીથી જઈને આપણે માટે અન્ન વેચાતું લઈ આવો.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","યહૂદાએ તેને કહ્યું, “તે માણસે અમને ગંભીરતાથી ચેતવણી આપેલી છે, ‘જો તમારો ભાઈ તમારી સાથે નહિ આવે, તો તમે મારી આગળ આવી શકશો નહિ.’ ");
INSERT INTO guj2017_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","જો તું અમારા ભાઈને અમારી સાથે મોકલે તો જ અમે જઈને આપણે માટે અનાજ લાવી શકીએ એવું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","પણ જો તું તેને નહિ મોકલે તો અમે જઈશું નહિ. કેમ કે તે માણસે અમને કહ્યું છે, ‘તમારો ભાઈ તમારી સાથે નહિ આવે, તો તમે મારી આગળ આવી શકશો નહિ.’” ");
INSERT INTO guj2017_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ઇઝરાયલે કહ્યું, “અમારો બીજો ભાઈ છે, એમ તે માણસને કહીને તમે મારી સાથે આવું વર્તન કેમ કર્યું?” ");
INSERT INTO guj2017_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","તેઓએ કહ્યું, “આપણા વિષે તથા આપણા કુટુંબ વિષે તે માણસે પૂછપરછ કરીને કહ્યું, ‘શું તમારો પિતા હજુ હયાત છે? શું તમારો બીજો કોઈ ભાઈ છે?’ અમે તેના પ્રશ્નો પ્રમાણે તેને ઉત્તર આપ્યો. અમને શું ખબર કે તે એમ કહેશે, ‘તમારા ભાઈને અહીં લાવો?’” ");
INSERT INTO guj2017_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","યહૂદાએ તેના પિતા ઇઝરાયલને કહ્યું, “અમારી સાથે બિન્યામીનને મોકલ કે, અમે રવાના થઈએ અને મિસરમાંથી અનાજ લાવીએ કે જેથી આપણે જીવતા રહીએ અને મરી જઈએ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","હું તેની ખાતરી આપું છું કે તું તેને મારી પાસેથી માગજે. જો હું તેને તારી પાસે ન લાવું અને તેને તારી આગળ રજૂ ન કરું, તો તેનો દોષ સદા મારા પર રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","કેમ કે જો આપણે વિલંબ કર્યો ન હોત, તો ચોક્કસ અમે અત્યાર સુધીમાં બીજીવાર જઈને પાછા આવ્યા હોત.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ઇઝરાયલે તેઓને કહ્યું, “હવે જો એમ જ હોય, તો આ દેશની કેટલીક ઉત્તમ ચીજ વસ્તુઓ તે માણસને ભેટ તરીકે આપવા માટે તમારી સાથે લઈ જાઓ: ખાસ કરીને દેશની ઔષધ, મધ, મસાલા, બોળ, પિસ્તા તથા બદામ લઈ જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","તમારી મોટી ગૂણોમાં મૂકીને પાછું અપાયેલું નાણું પણ લઈ જાઓ. કદાચ એ ભૂલથી આવી ગયું હશે. ");
INSERT INTO guj2017_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","તમારા ભાઈ બિન્યામીનને પણ સાથે લઈ જાઓ. તૈયાર થાઓ અને મિસરમાં તે માણસ પાસે ફરીથી જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","સર્વસમર્થ ઈશ્વર તમને તે માણસ દ્વારા કૃપા દર્શાવે કે જેથી તે તમારી સાથે તમારા બીજા ભાઈને તથા બિન્યામીનને મુક્ત કરે. જો મારે મારા દીકરાથી વંચિત થવાનું થાય તો તે સહન કરવું જ પડશે. ");
INSERT INTO guj2017_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","તેઓએ ભેટ લીધી, બમણાં નાણાં લીધાં અને બિન્યામીનને સાથે લઈને તેઓ મિસરમાં ગયા; અને યૂસફની સમક્ષ આવીને ઊભા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","જયારે યૂસફે તેઓની સાથે બિન્યામીનને જોયો, ત્યારે તેણે તેના ઘરના કારભારીને કહ્યું, “આ માણસોને ઘરમાં લઈ આવ, પશુને કાપીને તેને રાંધીને તે માણસોને માટે તૈયાર કર; કે જેથી તેઓ બપોરે મારી સાથે જમે.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","જે પ્રમાણે યૂસફે કહ્યું હતું તે પ્રમાણે કારભારીએ કર્યું. તે તેઓને યૂસફના ઘરે લઈ આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","તેઓને યૂસફના ઘરમાં લાવવામાં આવ્યા તેથી તેઓને બીક લાગી. તેઓ બોલ્યા, “આપણે પ્રથમ વાર આવ્યા ત્યારે આપણા થેલાઓ સાથે જે નાણું પાછું આપવામાં આવ્યું હતું, તેને કારણે તે આપણી વિરુદ્ધ તક શોધતો હોય એવું શક્ય છે. તે કદાચ આપણી અટકાયત કરે, આપણને ગુલામ બનાવે અને આપણા ગધેડાં પણ જપ્ત કરી લે ખરો.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","તેઓ યૂસફના ઘરના કારભારી પાસે ગયા, ઘરના દરવાજા આગળ તેઓએ વાતચીત કરતાં તેને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ઓ અમારા માલિક, અમે પ્રથમવાર અનાજ ખરીદવાને આવ્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ત્યારે એવું બન્યું હતું કે, અમે જયારે અમારા ઉતારાના સ્થાને પહોંચ્યા અને અમે અમારા થેલાઓ છોડ્યા, ત્યારે અમારામાંના દરેકની ગૂણોમાં અમે ચૂકવેલાં નાણાં અમારા જોવામાં આવ્યાં. અમે તે નાણાં પાછાં લાવ્યા છીએ. ");
INSERT INTO guj2017_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","તે ઉપરાંત વધારાનાં નાણાં પણ અમે અનાજ ખરીદવા લાવ્યા છીએ. અમારા થેલાઓમાં નાણાં કોણે મૂકેલાં હતાં એ અમે જાણતા નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","કારભારીએ કહ્યું, “તમને શાંતિ થાઓ, ગભરાશો નહિ. તમારા તથા તમારા પિતાના ઈશ્વરે જ એ નાણું તમારા થેલાઓમાં મૂક્યું હશે. મને તમારા નાણાં મળ્યા હતા.” ત્યાર પછી કારભારી શિમયોનને તેઓની પાસે લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","પછી કારભારી બધા ભાઈઓને યૂસફના ઘરમાં લઈ ગયો. તેણે તેઓને પાણી આપ્યું અને તેઓએ પગ ધોયા. તેણે તેઓનાં ગધેડાંને ચારો આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","તેઓએ જાણ્યું કે અમારે યૂસફના ઘરે જમવાનું છે, માટે યૂસફ ઘરે આવે તે પહેલા તેઓએ ભેટો તૈયાર કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","જયારે યૂસફ ઘરમાં આવ્યો, ત્યારે તેઓના હાથમાં જે ભેટો હતી તે તેની પાસે ઘરમાં લઈ આવીને જમીન સુધી નમીને પ્રણામ કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","યૂસફે તેઓની ખબરઅંતર પૂછીને કહ્યું, “જે વૃદ્ધ પિતા વિષે તમે મને કહ્યું હતું તે શું ક્ષેમકુશળ છે? તે શું હજી હયાત છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","તેઓએ કહ્યું, “તારો દાસ અમારો પિતા ક્ષેમકુશળ છે. તે હજી હયાત છે.” ફરીથી તેઓએ નમીને યૂસફને પ્રણામ કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","યૂસફે તેના ભાઈ બિન્યામીનને એટલે તેની માતાના દીકરાને જોયો અને બોલ્યો, “શું આ તમારો સૌથી નાનો ભાઈ છે કે જેના વિષે તમે મને કહ્યું હતું? “તેણે પૂછ્યું, “મારા દીકરા, તું કેમ છે? ઈશ્વરની કૃપા તારા પર થાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","યૂસફ ઉતાવળથી ઓરડાની બહાર ચાલ્યો ગયો, કારણ કે તેના ભાઈને લીધે તેનું હૃદય ભરાઈ આવ્યું. ત્યાં જઈને તે રડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","તેણે પોતાનો ચહેરો ધોયો અને બહાર આવ્યો. તેની લાગણીઓ દબાવી રાખીને બોલ્યો, “ચાલો, આપણે જમીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","દાસોએ યૂસફને માટે, તેના ભાઈઓને માટે તથા જે મિસરીઓ તેની સાથે જમવાના હતા તેઓને માટે અલગ અલગ ટેબલ પર ભોજન પીરસ્યું. કેમ કે મિસરીઓ હિબ્રૂઓ સાથે જમતા ન હતા, કેમ કે મિસરીઓ તેઓ સાથે અમંગળપણું લાગે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","યૂસફે ભાઈઓને તેઓની ઉંમર પ્રમાણે પ્રથમજનિતથી માંડીને મોટાથી નાના સુધી દરેકને ક્રમાનુસાર બેસાડ્યા હતા. તેથી તેઓ અંદરોઅંદર વિસ્મિત થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","યૂસફના ટેબલ પરના ખોરાકમાંથી ભાઈઓને પીરસવામાં આવ્યું. બિન્યામીનને બધાના કરતાં પાંચગણું વધારે પીરસાયું. તેઓ સંતોષથી જમ્યા અને યૂસફની સાથે આનંદ કર્યો. પછી પુષ્કળ પ્રમાણમાં દ્રાક્ષારસ પણ આપવામાં આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","યૂસફે તેના ઘરના કારભારીને આજ્ઞા આપી કે, “આ માણસોની ગૂણોમાં અનાજ ભરી દો. તેઓ ઊંચકી શકે તેટલું અનાજ ભરો અને દરેકની ગૂણોમાં અનાજની ઉપર તેઓએ ચૂકવેલા નાણાં પાછા મૂકીને ગૂણો બંધ કરો. ");
INSERT INTO guj2017_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","મારો પ્યાલો જે ચાંદીનો છે તે તથા અનાજના નાણાં સૌથી નાના ભાઈની ગૂણમાં ઉપર મૂકો.” યૂસફે કારભારીને જેવું કહ્યું હતું તેમ તેણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","સવાર થતાં જ તે માણસો તેમનાં ગધેડાં સાથે રવાના થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","તેઓ શહેરની બહાર પહોંચ્યા એટલામાં તો યૂસફે પોતાના કારભારીને કહ્યું, “ઊઠ, તે માણસોનો પીછો કર. જયારે તું તેઓની પાસે પહોંચે ત્યારે તેઓને કહેજે, ‘તમે ભલાઈનો બદલો દુષ્ટતાથી શા માટે વાળ્યો છે? ");
INSERT INTO guj2017_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","મારા માલિકનો પાણી પીવાનો ચાંદીનો પ્યાલો તમે કેમ ચોરી લીધો છે? એ પ્યાલાનો ઉપયોગ તો તે શુકન જોવા માટે પણ કરે છે. આ તમે જે કર્યું છે તે તો દુષ્કૃત્ય છે.’” ");
INSERT INTO guj2017_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","કારભારીએ તેમની પાસે પહોંચીને તેઓને આ શબ્દો કહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","તેઓએ તેને કહ્યું, “શા માટે મારો માલિક આ શબ્દો અમને કહે છે? આવું કંઈ પણ તારા સેવકો કદાપિ ન કરો! ");
INSERT INTO guj2017_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","અગાઉ અમારી ગૂણોમાંથી અમને પાછાં મળેલા નાણાં જયારે અમે કનાનથી પાછા આવ્યા ત્યારે અમે તે પરત લાવ્યા હતા. તો પછી અમે તારા માલિકના ઘરમાંથી સોના અથવા ચાંદીની ચોરી શા માટે કરીએ? ");
INSERT INTO guj2017_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","હવે તપાસી લે. અમારામાંથી જેની ગૂણોમાંથી પ્યાલો મળે તે માર્યો જાય. બાકીના અમે પણ મારા માલિકના ગુલામ થઈ જઈશું.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","કારભારીએ કહ્યું, “હવે તમારા કહ્યા પ્રમાણે થશે. જેની પાસેથી તે પ્યાલો મળશે તે ગુલામ થશે અને બીજા બધા નિર્દોષ ઠરશો.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","પછી દરેકે પોતાની ગૂણો ઝડપથી ઉતારીને જમીન પર મૂકી અને તેને ખોલી. ");
INSERT INTO guj2017_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","કારભારીએ શોધ કરી. તેણે મોટાથી માંડીને નાના સુધીના સર્વની ગૂણો તપાસી. ત્યારે પ્યાલો બિન્યામીનની ગૂણમાંથી પકડાયો. ");
INSERT INTO guj2017_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","તેઓએ પોતાનાં વસ્ત્રો ફાડ્યાં અને રડ્યા. તેઓ ગૂણો પાછી ગધેડાં પર મૂકીને પાછા શહેરમાં આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","યહૂદા તથા તેના ભાઈઓ યૂસફના ઘરે આવ્યા. તે હજુ પણ ત્યાં જ હતો. તેઓએ તેની આગળ જમીન સુધી પડીને નમન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","યૂસફે તેઓને કહ્યું, “તમે આ શું કર્યું છે? શું તમે જાણતા નથી કે હું શુકન જોઉં છું?” ");
INSERT INTO guj2017_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","યહૂદા બોલ્યો, “અમે અમારા માલિકને શું કહીએ? શું મોં બતાવીએ? અમે અમારી જાતને કેવી રીતે ન્યાયી ઠરાવીએ? ઈશ્વરે અમારો અન્યાય ધ્યાનમાં લીધો છે. હવે અમે તથા જેની ગૂણમાંથી પ્યાલો મળ્યો તે તમારા ગુલામો છીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","યૂસફે કહ્યું, “એવું નહિ. બધા નહિ પણ માત્ર જેની પાસેથી પ્યાલો મળ્યો છે તે જ મારા ગુલામ તરીકે અહીં રહે. બાકીના તમે બધા શાંતિથી તમારા પિતાની પાસે પાછા જાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","પછી યહૂદાએ તેની પાસે આવીને કહ્યું, “ઓ મારા માલિક, કૃપા કરીને તારા આ દાસને તારા કાનમાં એક વાત કહેવા દે જો કે તું ફારુન સમાન છે તો પણ તારા આ સેવક પર ક્રોધિત ન થઈશ. ");
INSERT INTO guj2017_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","જયારે મારા ઘણીએ અમોને પૂછ્યું હતું કે, “શું તમારે પિતા અથવા ભાઈ છે? ");
INSERT INTO guj2017_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","અમે અમારા ઘણીને કહ્યું હતું કે, ‘અમારે વૃદ્ધ પિતા છે અને પિતાને મોટી ઉંમરે મળેલ પુત્ર એટલે અમારો નાનો ભાઈ છે. તેનો ભાઈ મૃત્યુ પામ્યો છે અને તેની માતાને તે એકલો જ પુત્ર બાકી રહ્યો છે તેથી તેના પિતા તેના પર ખૂબ પ્રેમ કરે છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","પછી તેં તારા ચાકરોને કહ્યું, ‘તેને અહીં મારી પાસે લાવો કે હું તેને જોઈ શકું.’ ");
INSERT INTO guj2017_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","અને અમે અમારા ઘણીને કહ્યું, ‘તે છોકરો તેના પિતાથી અલગ થઈ શકે તેમ નથી. કેમ કે જો તે પોતાના પિતાને છોડીને આવે તો તેના પિતાનું મૃત્યુ થવાનો સંભવ છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","અને તેં અમને કહ્યું, ‘જ્યાં સુધી તમારો નાનો ભાઈ તમારી સાથે નહિ આવે ત્યાં સુધી હું તમારી સાથે રૂબરૂ વાત નહિ કરું.’ ");
INSERT INTO guj2017_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","પછી જયારે અમે અમારા પિતાની પાસે ગયા, ત્યારે અમે તેને અમારા ઘણીએ કહેલા શબ્દો સંભળાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","પછી અમારા પિતાએ કહ્યું, ‘ફરીથી જાઓ; અને કેટલુંક અનાજ ખરીદી લાવો.’ ");
INSERT INTO guj2017_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","પણ અમે કહ્યું, ‘અમારાથી નહિ જવાય. જો અમારો નાનો ભાઈ અમારી સાથે આવે, તો જ અમે જઈએ, કેમ કે અમારા નાના ભાઈને અમારી સાથે લઈ ગયા વગર અમે તે માણસની મુલાકાત કરી શકીશું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","એટલે અમારા પિતાએ અમને કહ્યું, ‘તમે જાણો છો કે મારી પત્નીએ બે દીકરાઓને જન્મ આપ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","તેઓમાંનો એક મારાથી દૂર થઈ ગયો છે અને મેં કહ્યું, “ચોક્કસ તેના ટુકડાં થઈ ગયા છે. મેં તેને અત્યાર સુધી જોયો નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","પછી પિતાએ કહ્યું કે તમે આને પણ મારી પાસેથી લઈ જશો અને એને કોઈ નુકસાન થશે, તો આ ઉંમરે મારે મરવાનું થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","તેથી હવે, જયારે હું મારા પિતાની પાસે પાછો જઈશ ત્યારે જે દીકરામાં તેનો જીવ છે, તે અમારી સાથે ન હોય, ");
INSERT INTO guj2017_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","અને તેના જાણવામાં આવે કે તેનો દીકરો અમારી સાથે પાછો આવ્યો નથી તો તે આ વાતથી મૃત્યુ પામશે અને અમારે અમારા પિતાને દુઃખ સહિત દફનાવવાનાં થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","કેમ કે હું યહૂદા મારા પિતાની પાસે બિન્યામીનનો જામીન થયો હતો અને મેં કહ્યું હતું, ‘જો હું તેને તારી પાસે પાછો ન લાવું, તો હું સર્વકાળ તારો અપરાધી થઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","હવે કૃપા કરીને આ દીકરા બિન્યામીનના બદલે તારા સેવકને એટલે મને મારા ઘણીના ગુલામ તરીકે રાખ અને બિન્યામીનને તેના ભાઈઓની સાથે પાછો ઘરે જવા દે. ");
INSERT INTO guj2017_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","કેમ કે જો તે મારી સાથે ન હોય, તો હું મારા પિતાની પાસે કેવી રીતે જાઉં? મારા પિતા પર જે આપત્તિ આવે તે મારાથી જોઈ શકાશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","પછી યૂસફ તેની આસપાસ ઊભા રહેલા સર્વ દાસોની ઉપસ્થિતિમાં તેની સંવેદના સમાવી રાખી શક્યો નહિ. તેણે મોટેથી હુકમ કર્યો, “દરેક વ્યક્તિ મારી પાસેથી દૂર જાય.” તેઓ ગયા ત્યારે યૂસફે તેના ભાઈઓ આગળ પોતાની ઓળખ આપી. તે વખતે કોઈપણ ચાકર ત્યાં હતો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","પછી યૂસફ મોટેથી રડ્યો. તેનું રુદન મિસરીઓએ તથા ફારુનના મહેલમાંના સૌએ સાંભળ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","યૂસફે પોતાના ભાઈઓને કહ્યું, “હું યૂસફ છું. શું આપણા પિતા હજુ હયાત છે? “તેના ભાઈઓ તેને ઉત્તર આપી શક્યા નહિ. તેઓ યૂસફને ઓળખીને સખત ગભરાઈ ગયા હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","પછી યૂસફે ભાઈઓને કહ્યું, “કૃપા કરી મારી પાસે આવો.” તેઓ પાસે આવ્યા અને તેણે કહ્યું, “હું તમારો ભાઈ યૂસફ છું, જેને તમે મિસરમાં વેચી દીધો હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","પરંતુ તમે મને અહીં વેચી દીધો હોવાને કારણે હવે કશો અપરાધ કે ઉચાટ અનુભવશો નહિ, કેમ કે એ ઈશ્વરની યોજના હતી. જીવનો બચાવવા માટે તેમણે મને તમારી અગાઉ અહીં મોકલ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","કેમ કે બે વર્ષથી દેશમાં દુકાળ છે અને હજી બીજા પાંચ વર્ષ સુધી વાવણી તથા કાપણી થશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","પૃથ્વીમાં તમારાં સંતાનો જીવંત રાખવાને તથા તમારા જીવનો બચાવવાને ઈશ્વરે તમારી આગળ મને મોકલ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","તેથી હવે તમે નહિ, પણ ઈશ્વર મને અહીં લાવ્યા હતા. તેમણે જ મને ફારુનનો સલાહકાર, તેના સમગ્ર રાજ્યનો પ્રભુ તથા આખા મિસરનો અધિપતિ બનાવ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","તમે જેમ બને તેમ જલ્દી આપણા પિતા પાસે પાછા જાઓ અને તેને કહો, ‘તારો દીકરો યૂસફ આ પ્રમાણે કહે છે, ઈશ્વરે મને સમગ્ર મિસરનો અધિપતિ બનાવ્યો છે. તું મારી પાસે આવ અને વિલંબ કરીશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ગોશેન દેશમાં તારો મુકામ થશે. તું, તારાં સંતાનો, તારા સંતાનોનાં સંતાનો, તારા જાનવરો તથા તારું સર્વસ્વ અહીં મારી નજીક રહેશો. ");
INSERT INTO guj2017_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","તું, તારું કુટુંબ તથા જેઓ પણ તારી સાથે છે તેઓ સર્વ ગરીબાઈમાં ન આવી પડે તે માટે હું સર્વનું પાલનપોષણ કરીશ, હજુ દુકાળનાં બીજા પાંચ વર્ષ બાકી છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ભાઈઓ, જુઓ, તમારી આંખો તથા મારા ભાઈ બિન્યામીનની આંખો જોઈ રહી છે કે મારું મુખ તમારી સાથે બોલી રહ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","મિસરમાં મારો સર્વ મહિમા તથા જે સર્વ તમે જોયું તે મારા પિતાને જણાવો. જલ્દી જઈને મારા પિતાને અહીં લઈ આવો.” ");
INSERT INTO guj2017_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","પછી યૂસફ તેના નાના ભાઈ બિન્યામીનને ભેટીને રડ્યો અને બિન્યામીન પણ તેને ભેટીને રડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","તેણે સર્વ ભાઈઓને ચુંબન કર્યું અને તેઓને ભેટીને ગળગળો થયો. તે પછી તેના ભાઈઓએ હૃદય ખોલીને તેની સાથે વાતચીત કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ફારુનના કુટુંબમાં આ સમાચાર જણાવાયા કે, “યૂસફના ભાઈઓ આવ્યા છે.” ત્યારે ફારુનને તથા તેના દાસોને તે વાત સારી લાગી. ");
INSERT INTO guj2017_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ફારુને યૂસફને કહ્યું, “તું તારા ભાઈઓને કહે, ‘તમે આમ કરો, તમારાં પશુઓ પર અનાજ લાદીને કનાન દેશમાં જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","પછી તમારા પિતાને તથા તમારા સમગ્ર કુટુંબને અહીં મિસરમાં મારી પાસે લઈ આવો. હું તેઓને મિસર દેશનો ઉત્તમ પ્રદેશ રહેવા માટે આપીશ અને દેશની ઉત્તમ પેદાશો તેઓ ખાશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","હવે હું તને તારા ભાઈઓને આ પ્રમાણે કહેવાની આજ્ઞા આપું છું, ‘આ પ્રમાણે કરો. તમારાં બાળકોને માટે તથા તમારી પત્નીઓને માટે મિસર દેશમાંથી ગાડાં લઈ જાઓ અને તેમાં બેસાડીને તમારા પિતા સહિત બધાને અહીં લઈ આવો. ");
INSERT INTO guj2017_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","તમારી માલમિલકતની ચિંતા ન કરો, કેમ કે આખા મિસર દેશમાં જે ઉત્તમ છે તે તમારું છે.’” ");
INSERT INTO guj2017_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ઇઝરાયલના પુત્રોએ તે માન્ય રાખ્યું. યૂસફે ફારુનની આજ્ઞા પ્રમાણે તેઓને ગાડાં આપ્યાં અને તેઓની મુસાફરીને માટે સર્વ વ્યવસ્થા પણ કરી આપી. ");
INSERT INTO guj2017_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","તેઓમાંના દરેકને યૂસફે એક જોડી વસ્ત્રો આપ્યાં, પણ બિન્યામીનને તેણે ત્રણસો ચાંદીના સિક્કા અને પાંચ જોડ વસ્ત્રો આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","તેણે તેના પિતાને માટે આ પ્રમાણે ભેટસોગાદો મોકલી: મિસર દેશની ઉત્તમ વસ્તુઓથી લાદેલા દસ ગધેડાં; અને મુસાફરીને માટે તેના પિતાને સારુ અનાજ, રોટલી તથા અન્ય ખોરાકથી લાદેલી દસ ગધેડીઓ. ");
INSERT INTO guj2017_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","આ રીતે તેણે તેના ભાઈઓને વિદાય કર્યાં અને તેઓના જતા અગાઉ તેણે તેઓને કહ્યું, “જુઓ, માર્ગમાં મુસાફરી દરમિયાન લડી પડતાં નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","તેઓ મિસરમાંથી નીકળીને કનાન દેશમાં તેના પિતા યાકૂબની પાસે આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","તેઓએ તેને કહ્યું, “યૂસફ હજી સુધી જીવે છે અને તે આખા મિસર દેશનો અધિપતિ થયેલો છે.” તે સાંભળીને યાકૂબ સ્તબ્ધ થઈ ગયો, તેણે તેઓની વાત પર વિશ્વાસ કર્યો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","પણ જ્યારે યૂસફે તેઓને જે જે વાત કરી હતી તે સર્વ તેઓએ પિતાને જણાવી અને યૂસફે તેને લેવા માટે જે ગાડાં મોકલ્યા હતાં તે જયારે તેના પિતા યાકૂબે જોયાં, ત્યારે તે સ્વસ્થ થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ઇઝરાયલે કહ્યું, “આટલું પૂરતું છે. મારો દીકરો યૂસફ હજુ જીવે છે. મારા મૃત્યુ પહેલા હું મિસરમાં જઈશ અને તેને જોઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ઇઝરાયલ પોતાના કુટુંબકબીલા અને સર્વ સહિત બેરશેબા આવ્યો. અહીં તેણે પોતાના પિતા ઇસહાકના ઈશ્વરને અર્પણો ચઢાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ઈશ્વરે ઇઝરાયલને રાત્રે સ્વપ્નમાં સંદર્શન આપીને કહ્યું, “યાકૂબ, યાકૂબ.” તેણે કહ્યું, “હું અહીં છું.” ");
INSERT INTO guj2017_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","તેમણે કહ્યું, “હું પ્રભુ, તારા પિતાનો ઈશ્વર છું. મિસરમાં જતા બીશ નહિ, કેમ કે ત્યાં હું તારાથી વિશાળ પ્રજા ઉત્પન્ન કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","હું તારી સાથે મિસરમાં આવીશ અને હું ત્યાંથી નિશ્ચે તારા વંશજોને પાછા લાવીશ. મિસરમાં તારા મૃત્યુસમયે યૂસફ તારી પાસે હશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","યાકૂબ બેરશેબાથી રવાના થયો. તેને લઈ જવાને જે ગાડાં ફારુને મોકલ્યાં હતાં તેમાં ઇઝરાયલના પુત્રોએ પોતાના પિતા યાકૂબને, પોતાના બાળકોને તથા પોતાની પત્નીઓને બેસાડ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","તેમનાં જાનવરો તથા જે સંપત્તિ તેઓએ કનાન દેશમાં મેળવી હતી તે લઈને યાકૂબ તથા તેની સાથે તેના વંશજો મિસરમાં આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","તેના દીકરા તથા તેની સાથે તેના દીકરાના દીકરા, તેની દીકરીઓ તથા તેના દીકરાઓની દીકરીઓને તથા તેના સર્વ સંતાનને તે તેની સાથે મિસરમાં લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","જે ઇઝરાયલપુત્રો મિસરમાં આવ્યા તેઓનાં નામ આ છે: યાકૂબ તથા તેના દીકરા: યાકૂબનો જ્યેષ્ઠ દીકરો રુબેન; ");
INSERT INTO guj2017_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","રુબેનના દીકરા: હનોખ, પાલ્લૂ, હેસ્રોન તથા કાર્મી; ");
INSERT INTO guj2017_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","શિમયોન તથા તેના દીકરા: યમુએલ, યામીન, ઓહાદ, યાખીન, સોહાર તથા કનાની પત્નીનો દીકરો શાઉલ; ");
INSERT INTO guj2017_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","લેવી તથા તેના દીકરા: ગેર્શોન, કહાથ તથા મરારી. ");
INSERT INTO guj2017_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","યહૂદા તથા તેના દીકરા: એર, ઓનાન, શેલા, પેરેસ તથા ઝેરાહ, પણ એર તથા ઓનાન કનાન દેશમાં મરણ પામ્યા. પેરેસના દીકરા હેસ્રોન તથા હામૂલ હતા; ");
INSERT INTO guj2017_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ઇસ્સાખાર તથા તેના દીકરા: તોલા, પુવાહ, લોબ તથા શિમ્રોન; ");
INSERT INTO guj2017_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ઝબુલોન તથા તેના દીકરા: સેરેદ, એલોન તથા યાહલેલ. ");
INSERT INTO guj2017_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","યાકૂબને લેઆથી પાદ્દાનારામમાં જન્મેલા દીકરા તથા તેની દીકરી દીના. તેઓ સર્વ મળીને તેત્રીસ જણ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ગાદ તથા તેના દીકરા: સિફયોન, હાગ્ગી, શૂની, એસ્બોન, એરી, અરોદી તથા આરએલી; ");
INSERT INTO guj2017_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","આશેર તથા તેના દીકરા: યિમ્ના, યિશ્વા, યિશ્વી, બરિયા તથા તેઓની બહેન સેરાહ; અને બરિયાના દીકરા: હેબેર તથા માલ્કીએલ. ");
INSERT INTO guj2017_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","લાબાને તેની દીકરી લેઆને જે દાસી ઝિલ્પા આપી હતી તેનાં સંતાનો એ છે. તેઓ તેને યાકૂબ દ્વારા થયાં, તેઓ સર્વ મળીને સોળ જણ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","યાકૂબની પત્ની રાહેલના દીકરા: યૂસફ તથા બિન્યામીન; ");
INSERT INTO guj2017_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","યૂસફના મિસર દેશમાં જન્મેલા દીકરાઓ મનાશ્શા તથા એફ્રાઇમ. તેઓને ઓનના યાજક પોટીફારની દીકરી આસનાથે જન્મ આપ્યો હતો; ");
INSERT INTO guj2017_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","બિન્યામીનના દીકરા: બેલા, બેખેર, આશ્બેલ, ગેરા, નામાન, એહી, રોશ, મુપ્પીમ, હુપ્પીમ તથા આર્દ. ");
INSERT INTO guj2017_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","તેઓ રાહેલના દીકરા, જે યાકૂબ દ્વારા થયા. તેઓ સર્વ મળીને ચૌદ જણ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","દાન તથા તેનો દીકરો હુશીમ; ");
INSERT INTO guj2017_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","નફતાલી તથા તેના દીકરા: યાહસએલ, ગૂની, યેસેર તથા શિલ્લેમ. ");
INSERT INTO guj2017_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","લાબાને તેની દીકરી રાહેલને જે દાસી બિલ્હા આપી તેના દીકરા એ છે જેઓ યાકૂબ દ્વારા તેને થયા. તે સર્વ મળીને સાત જણ હતા. ");
INSERT INTO guj2017_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","યાકૂબના દીકરાઓની પત્નીઓ સિવાય કનાનમાં જન્મેલાં જે સર્વ માણસ યાકૂબ સાથે મિસરમાં આવ્યાં તેઓ છાસઠ જણ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","યૂસફના દીકરા જે મિસર દેશમાં તેને જન્મ્યા હતા, તે બે હતા. યાકૂબના ઘરનાં સર્વ માણસો જે મિસરમાં આવ્યાં તેઓ સિત્તેર હતાં. ");
INSERT INTO guj2017_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","યાકૂબે તેની આગળ યહૂદાને યૂસફની પાસે મોકલ્યો કે તે આગળ જઈને ગોશેનનો માર્ગ બતાવે અને તેઓ ગોશેન દેશમાં આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","યૂસફે તેના રથ તૈયાર કર્યા અને તેના પિતા ઇઝરાયલને મળવાને તે ગોશેનમાં આવ્યો. પિતાને જોઈને યૂસફ ભેટીને ઘણી વાર સુધી રડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ઇઝરાયલે યૂસફને કહ્યું, “મેં તારું મુખ જોયું અને તું હજી હયાત છે. હવે મારું મરણ ભલે આવે.” ");
INSERT INTO guj2017_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","યૂસફે તેના ભાઈઓને તથા તેના પિતાના ઘરનાંને કહ્યું, “હું જઈને ફારુનને જણાવીને કહીશ કે, ‘મારા ભાઈઓ તથા મારા પિતાના ઘરનાં જે કનાન દેશમાં હતાં તેઓ મારી પાસે આવ્યાં છે. ");
INSERT INTO guj2017_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","તેઓ ભરવાડ છે અને જાનવરો પાળનારા છે. તેઓ તેમનાં બકરાં, અન્ય જાનવરો તથા તેઓનું જે સર્વ છે તે બધું લાવ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","અને એમ થશે કે, જયારે ફારુન તમને બોલાવે અને તમને પૂછે, તમારો વ્યવસાય શો છે?’ ");
INSERT INTO guj2017_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ત્યારે તમારે આ પ્રમાણે કહેવું, ‘તારા ચાકરોનો એટલે અમારો તથા અમારા પિતૃઓનો વ્યવસાય નાનપણથી તે અત્યાર સુધી જાનવરો પાળવાનો છે.’ આ પ્રમાણે કહેશો એટલે તમને ગોશેન દેશમાં રહેવાની પરવાનગી મળશે. કેમ કે મિસરીઓ ભરવાડોને ધિક્કારે છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","પછી યૂસફ ફારુનને મળવા ગયો. તેણે ફારુનને કહ્યું, “મારા પિતા, મારા ભાઈઓ તથા તેઓનાં બકરાં, અન્ય જાનવરો તથા જે સર્વ તેઓનું છે તે સહિત તેઓ કનાન દેશથી આવ્યા છે. તેઓ ગોશેન દેશમાં છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","તેણે પોતાના ભાઈઓમાંના પાંચનો પરિચય ફારુન સાથે કરાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ફારુને તેના ભાઈઓને પૂછ્યું, “તમારો વ્યવસાય શો છે? “અમે તારા દાસો અમારા પૂર્વજોની જેમ ભરવાડો છીએ. ");
INSERT INTO guj2017_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","પછી તેઓએ ફારુનને કહ્યું, “અમે આ દેશમાં પ્રવાસી તરીકે આવ્યા છીએ. કેમ કે કનાન દેશમાં દુકાળ ભારે હોવાને લીધે અમારા ટોળાંને સારુ ચારો નથી. માટે હવે અમને કૃપા કરીને ગોશેન દેશમાં રહેવા દે.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","પછી ફારુને યૂસફને કહ્યું, “તારા પિતા તથા તારા ભાઈઓ તારી પાસે આવ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","આખો મિસર દેશ તારી આગળ છે. દેશમાં ઉત્તમ સ્થળે તારા પિતાને તથા તારા ભાઈઓને રહેવા દે. તેઓ ગોશેન દેશમાં રહે. જો તું જાણતો હોય કે તેઓમાં કોઈ માણસો હોશિયાર છે, તો મારાં જાનવરો પણ તેઓના હવાલામાં સોંપ.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","પછી યૂસફે તેના પિતા યાકૂબને ફારુનની સમક્ષ બોલાવ્યો. યાકૂબે ફારુનને આશીર્વાદ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ફારુને યાકૂબને કહ્યું, “તમારી ઉંમર કેટલી થઈ છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","યાકૂબે ફારુનને કહ્યું, “મારા જીવનપ્રવાસના એકસો ત્રીસ વર્ષ થયાં છે. એ અતિ પરિશ્રમવાળા રહ્યાં છે. હજી મારા પિતૃઓના પ્રવાસમાં તેઓની ઉંમરના જેટલાં મારા વર્ષો થયાં નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","પછી યાકૂબ ફારુનને આશીર્વાદ આપીને તેની હજૂરમાંથી બહાર ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","યૂસફે તેના પિતાને તથા તેના ભાઈઓને રહેવાને જગ્યા આપી. તેણે તેઓને મિસર દેશની ઉત્તમ જગ્યામાં એટલે રામસેસમાં ફારુનની આજ્ઞા પ્રમાણે વસવાનો પ્રદેશ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","યૂસફે તેના પિતાને, ભાઈઓને તથા તેના પિતાના ઘરનાં સર્વને તેઓની સંખ્યા પ્રમાણે અન્ન પૂરું પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","હવે તે આખા દેશમાં અન્ન ન હતું; કેમ કે દુકાળ વધતો જતો હતો. મિસર દેશ તથા કનાન દેશના લોકો દુકાળને કારણે વેદનાગ્રસ્ત થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","લોકોએ જે અન્ન વેચાતું લીધું તેને બદલે જે નાણાં મિસર દેશમાંથી તથા કનાન દેશમાંથી મળ્યા, તે સર્વ યૂસફે એકઠા કર્યાં. પછી યૂસફે તે નાણાં ફારુનના રાજ્યભંડારમાં જમા કરાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","જયારે મિસર દેશમાં તથા કનાન દેશમાં નાણાંની અછત થઈ, ત્યારે સર્વ મિસરીઓ યૂસફની પાસે આવીને બોલ્યા, “અમને ખાવાનું આપ! શા માટે અમે તારી આગળ મરીએ? અમારી પાસે હવે નાણાં રહ્યાં નથી.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","યૂસફે કહ્યું, “જો તમારાં નાણાં પતી ગયાં હોય, તો તમારાં જાનવરો આપો અને તમારાં જાનવરોના બદલે હું તમને અનાજ આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","તેથી તેઓ પોતાના જાનવરો યૂસફ પાસે લાવ્યાં. યૂસફે ઘોડા, બકરાં, અન્ય જાનવરો તથા ગધેડાંના બદલામાં તેઓને અનાજ આપ્યું. તેણે પશુઓના બદલામાં તે વર્ષે તેઓનું ભરણપોષણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","જયારે તે વર્ષ પૂરું થયું, ત્યારે તેઓએ બીજા વર્ષે યૂસફની પાસે આવીને તેને કહ્યું, “નાણાંની અછત છે એ અમે અમારા ઘણીથી છુપાવી રાખતાં નથી. વળી અમારા જાનવરો પણ તારી પાસે છે. અમારા શરીરો તથા અમારી જમીન સિવાય અમારી પાસે બીજું કંઈ બાકી રહ્યું નથી. ");
INSERT INTO guj2017_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","તારા દેખતાં અમે, અમારા ખેતરો સહિત શા માટે મરણ પામીએ? અનાજને બદલે અમને તથા અમારી જમીનને વેચાતાં લે અને અમે તથા અમારા ખેતર ફારુનને હવાલે કરીશું. અમને અનાજ આપ કે અમે જીવતા રહીએ, મરીએ નહિ. અમે મજૂરી કરીશું અને જમીન પડતર નહિ રહે.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","તેથી યૂસફે મિસરીઓની સર્વ જમીન ફારુનને સારુ વેચાતી લીધી. દરેક મિસરીએ પોતાની જમીન ફારુનને વેચી દીધી હતી, કેમ કે દુકાળ તેઓને માથે સખત હતો. આ રીતે તે દેશની જમીન ફારુનની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","તેણે મિસરની સીમાના એક છેડાથી તે બીજા છેડા સુધી લોકોને નગરોમાં મોકલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ફક્ત યાજકોની જમીન તેણે વેચાતી લીધી નહિ, કેમ કે યાજકોને ફારુનની પાસેથી ભાગ મળતો હતો. તેઓનો જે ભાગ ફારુને તેઓને આપ્યો હતો તેનાથી તેઓ ગુજરાન ચલાવતા હતા. તેથી તેઓએ તેમની જમીન વેચવી પડી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","પછી યૂસફે લોકોને કહ્યું, “જુઓ, મેં તમને તથા તમારી જમીનને ફારુનને માટે આજે વેચાતાં લીધાં છે. હવે અહીં તમારા માટે બિયારણ છે. તે હું તમને આપું છું. જમીનમાં તેની વાવણી કરજો. ");
INSERT INTO guj2017_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","તેમાંથી જે ઊપજ થાય તેનો પાંચમો ભાગ ફારુનને આપજો અને બાકીના ચાર ભાગ ખેતરના બીજ માટે, તમારા પોતાના, તમારાં ઘરનાં તથા તમારાં છોકરાંનાં ખોરાકને માટે તમે રાખજો.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","તેઓએ કહ્યું, “તેં અમારા જીવ બચાવ્યા છે. અમારા પર તારી કૃપાદ્રષ્ટિ રાખજે અને અમે ફારુનના દાસ થઈને રહીશું.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","મિસર દેશમાં યૂસફે એવો કાનૂન બનાવ્યો કે બધી જમીનનો પાંચમો ભાગ ફારુનને મળે અને એ કાનૂન આજ સુધી ચાલે છે. ફક્ત યાજકોની જમીન ફારુનના તાબામાં ન આવી. ");
INSERT INTO guj2017_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ઇઝરાયલ અને તેનાં સંતાનો મિસર દેશના ગોશેનમાં રહ્યા. તેના લોકોએ ત્યાં માલમિલકત વસાવી. તેઓ સફળ થઈને બહુ વધ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","યાકૂબને મિસર દેશમાં આવ્યે સત્તર વર્ષ થયાં, તેની ઉંમરના વર્ષો એકસો સુડતાળીસ થયાં. ");
INSERT INTO guj2017_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","જયારે ઇઝરાયલના મરણનો સમય પાસે આવ્યો, ત્યારે તેણે તેના દીકરા યૂસફને બોલાવીને કહ્યું, “હવે જો તને મારા પર વહાલ હોય તો મને વચન આપ. તું ખરા હૃદયથી મારી સાથે વર્તજે અને મહેરબાની કરીને મૃત્યુ પછી મને મિસરમાં દફનાવીશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","જયારે મારું મરણ થાય ત્યારે તું મને મિસરમાંથી કનાન લઈ જજે અને મારા પિતૃઓની સાથે તેઓના કબરસ્થાનમાં દફનાવજે.” યૂસફે કહ્યું, “હું તારા કહ્યા પ્રમાણે કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ઇઝરાયલ બોલ્યો, “મારી આગળ પ્રતિજ્ઞા લે,” યૂસફે તેની આગળ પ્રતિજ્ઞા લીધી. પછી ઇઝરાયલ ઓશીકા પર માથું ટેકવીને પથારીમાં સૂઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","એ બાબતો થયા પછી કોઈએ યૂસફને કહ્યું, “જો, તારો પિતા બીમાર પડ્યો છે.” તેથી તે પોતાના બે દીકરા મનાશ્શાને તથા એફ્રાઇમને સાથે લઈને પિતાની પાસે ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","યાકૂબને કોઈએ ખબર આપી, “જો, તારો દીકરો યૂસફ તારી પાસે આવી પહોંચ્યો છે,” ત્યારે ઇઝરાયલ બળ કરીને પલંગ પર બેઠો થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","યાકૂબે યૂસફને કહ્યું, “કનાન દેશના લૂઝમાં સર્વસમર્થ ઈશ્વરે મને દર્શન આપ્યું હતું. તેમણે મને આશીર્વાદ આપીને, ");
INSERT INTO guj2017_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","કહ્યું હતું, ‘ધ્યાન આપ, હું તને સફળ કરીશ અને તને વધારીશ. હું તારાથી મોટો સમુદાય ઉત્પન્ન કરીશ. તારા પછી હું તારા વંશજોને આ દેશ સદાકાળના વતનને માટે આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","હવે મિસર દેશમાં તારી પાસે મારા આવ્યા અગાઉ તારા બે દીકરા મિસર દેશમાં જન્મ્યા છે તેઓ એટલે એફ્રાઇમ તથા મનાશ્શા મારા છે. રુબેન તથા શિમયોનની જેમ તેઓ મારા થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","તેઓ પછી તારાં જે સંતાનો થશે તેઓ તારાં થશે; અને તારા તરફથી એફ્રાઇમ તથા મનાશ્શાને મળનારા ભાગના વારસ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","જયારે અમે પાદ્દાનથી આવતા હતા ત્યારે એફ્રાથ પહોંચવાને થોડો રસ્તો બાકી હતો એટલામાં રાહેલ મારા દેખતાં માર્ગમાં કનાન દેશમાં મૃત્યુ પામી. ત્યાં એફ્રાથના એટલે બેથલેહેમના માર્ગમાં મેં તેને દફનાવી.” ");
INSERT INTO guj2017_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ઇઝરાયલે યૂસફના દીકરાઓને જોઈને પૂછ્યું કે, “આ કોણ છે?” ");
INSERT INTO guj2017_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","યૂસફે તેના પિતાને કહ્યું, “તેઓ મારા દીકરા છે, જેમને ઈશ્વરે મને અહીં આપ્યાં છે.” ઇઝરાયલે કહ્યું, “તેઓને મારી પાસે લાવ કે હું તેઓને આશીર્વાદ આપું.” ");
INSERT INTO guj2017_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","હવે ઇઝરાયલની આંખો તેની વૃદ્ધાવસ્થાને કારણે ઝાંખી પડી હતી, તે બરાબર જોઈ શકતો ન હતો. તેથી યૂસફ તેઓને તેની એકદમ નજીક લાવ્યો અને તેણે તેઓને ચુંબન કરીને તેઓને બાથમાં લીધા. ");
INSERT INTO guj2017_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ઇઝરાયલે યૂસફને કહ્યું, “મને જરા પણ આશા નહોતી કે હું તારું મુખ જોઈ શકીશ. પણ ઈશ્વરે તો તારા સંતાન પણ મને બતાવ્યાં છે.” ");
INSERT INTO guj2017_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","યૂસફે તેઓને ઇઝરાયલ પાસેથી થોડા દૂર કર્યા અને પોતે જમીન સુધી નમીને તેને પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","પછી યૂસફે તે બન્નેને લઈને પોતાને જમણે હાથે એફ્રાઇમને ઇઝરાયલના ડાબા હાથની સામે અને પોતાને ડાબે હાથે મનાશ્શાને ઇઝરાયલના જમણા હાથની સામે રાખ્યા અને એમ તેઓને તેની પાસે લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ઇઝરાયલે તેનો જમણો હાથ લાંબો કરીને એફ્રાઇમ જે નાનો હતો તેના માથા પર મૂક્યો અને તેનો ડાબો હાથ મનાશ્શાના માથા પર મૂક્યો. તેણે સમજપૂર્વક તેના હાથ એ રીતે મૂક્યા હતા. આમ તો મનાશ્શા જ્યેષ્ઠ હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ઇઝરાયલે યૂસફને આશીર્વાદ આપીને કહ્યું, “જે ઈશ્વરની આગળ મારા પિતૃઓ ઇબ્રાહિમ તથા ઇસહાક ચાલ્યા, જે ઈશ્વરે મને આજ સુધી સંભાળ્યો અને ");
INSERT INTO guj2017_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","દૂત સ્વરૂપે મને સર્વ દુષ્ટતાથી બચાવ્યો છે, તે આ દીકરાઓને આશીર્વાદ આપો. તેઓ મારું, મારા દાદા ઇબ્રાહિમનું તથા પિતા ઇસહાકનું નામ પ્રતિષ્ઠિત કરનારા થાઓ. તેઓ પૃથ્વીમાં વધીને વિશાળ સમુદાય થાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","જયારે યૂસફે જોયું કે તેના પિતાએ તેનો જમણો હાથ એફ્રાઇમના માથા પર મૂક્યો, ત્યારે તે નાખુશ થયો. એફ્રાઇમના માથા પરથી મનાશ્શાના માથા પર મૂકવાને તેણે તેના પિતાનો હાથ ઊંચો કર્યો, ");
INSERT INTO guj2017_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","યૂસફે પિતાને કહ્યું, “મારા પિતા, એમ નહિ; કેમ કે મનાશ્શા જ્યેષ્ઠ છે. તેના માથા પર તારો જમણો હાથ મૂક.” ");
INSERT INTO guj2017_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","તેનો પિતાએ ઇનકાર કરતા કહ્યું, “હું જાણું છું, મારા દીકરા, હું જાણું છું. તે પણ એક પ્રજા થશે અને તે પણ મહાન થશે. પણ તેનો નાનો ભાઈ તો તેના કરતાં વધારે મહાન થશે અને તેનાં વંશજોની બેશુમાર વૃદ્ધિ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ઇઝરાયલે તે દિવસે તેઓને આ રીતે આશીર્વાદ આપ્યો, “ઇઝરાયલ લોકો તમારું નામ લઈને એકબીજાને આશીર્વાદ આપીને કહેશે, ‘ઈશ્વર એફ્રાઇમ તથા મનાશ્શા જેવો તને બનાવે.’ આ રીતે તેણે એફ્રાઇમને મનાશ્શા કરતાં અગ્રસ્થાન આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ઇઝરાયલે યૂસફને કહ્યું, “હું મરણ પામી રહ્યો છું, પણ ઈશ્વર તમારી સાથે રહેશે અને તમને આપણા પિતૃઓના કનાન દેશમાં પાછા લઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","મેં શખેમનો પ્રદેશ તારા ભાઈઓને નહિ પણ તને આપ્યો છે. એ પ્રદેશ મેં મારી તલવારથી તથા ધનુષ્યથી અમોરીઓના હાથમાંથી જીતી લીધો હતો.” ");
INSERT INTO guj2017_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","યાકૂબે તેના દીકરાઓને બોલાવીને કહ્યું, “તમે ભેગા થાઓ કે ભવિષ્યમાં તમારું શું થશે તે હું તમને કહી જણાવું. ");
INSERT INTO guj2017_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“યાકૂબના પુત્રો, તમે એકઠા થાઓ અને સાંભળો. તમારા પિતા ઇઝરાયલને સાંભળો. ");
INSERT INTO guj2017_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","રુબેન, તું મારો જયેષ્ઠ પુત્ર, મારું બળ તથા મારા સામર્થ્યમાં પ્રથમ છે, ગૌરવમાં તથા તાકાતમાં તું ઉત્કૃષ્ટ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","તું વહેતા પાણી જેવો અસ્થિર હોવાથી અગ્રીમસ્થાનની પ્રતિષ્ઠા પામશે નહિ, તું તારા પિતાની પથારીએ ગયો અને તેને ભ્રષ્ટ કરી; તેં આવું દુરાચરણ કર્યું તેથી સૌ કરતાં તારું સ્થાન ઊતરતું રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","શિમયોન તથા લેવી ભાઈઓ છે. હિંસાખોરીના હથિયારો તેઓની તલવારો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","તેથી હે મારા આત્મા તું અલગ રહે, તેઓની બેઠકોમાં સામેલ ન થા. જો કે મારા હૃદયમાં તેઓને માટે ગર્વ તો છે. તેઓએ ક્રોધમાં માણસની હત્યા કરી છે. ઉન્મત્તાઈથી બળદની નસ કાપી નાખીને તેને લંગડો કર્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","તેઓનો ક્રોધ શાપિત થાઓ, કેમ કે તે ઉગ્ર હતો - તેઓનો રોષ શાપિત થાઓ - કેમ કે તેઓ નિર્દય હતા. હું તેઓને યાકૂબના સંતાનોમાંથી અલગ કરીશ અને ઇઝરાયલમાં તેઓને વિખેરી નાખીશ. ");
INSERT INTO guj2017_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","યહૂદા, તારા ભાઈઓ તારી પ્રશંસા કરશે. તારો હાથ તારા શત્રુઓનો નાશ કરશે. તારા ભાઈના પુત્રો તને નમન કરશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","યહૂદા એક મોટું સિંહનું બચ્ચું છે. મારા દીકરા, તું શિકારનું ભોજન પતાવીને આવ્યો છે. તે સિંહ તથા સિંહણની જેમ શાંતિથી નીચે બેઠો છે. તેને ઉઠાડવાની હિંમત કોણ કરશે? ");
INSERT INTO guj2017_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","જ્યાં સુધી શીલો આવશે નહિ ત્યાં સુધી યહૂદાથી રાજદંડ અલગ થશે નહિ, લોકો તેની આધીનતામાં રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","તેણે તેના વછેરાને દ્રાક્ષવેલાએ બાંધ્યો છે, અને તેના ગધેડાને શ્રેષ્ઠ દ્રાક્ષવેલાઓમાં બાંધ્યા છે. તેણે તેના વસ્ત્ર દ્રાક્ષારસમાં ધોયાં છે અને તેનો ઝભ્ભો દ્રાક્ષોના રસરૂપી રક્તમાં ધોયો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","દ્રાક્ષારસને લીધે તેની આંખો લાલ અને દૂધને લીધે તેના દાંત શ્વેત થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ઝબુલોન સમુદ્રના કાંઠાની પાસે રહેશે. તે વહાણોને સારુ બંદરરૂપ થશે અને તેની સરહદ સિદોન સુધી વિસ્તારવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ઇસ્સાખાર બળવાન ગધેડો, બે ઘેટાંવાડાઓના વચ્ચે સૂતેલો છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","તેણે સારી આરામદાયક જગ્યા અને અને સુખપ્રદ પ્રદેશ જોયો છે. તે બોજો ઊંચકવાને તેનો ખભો નમાવશે; અને તે વૈતરું કરનારો ગુલામ થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ઇઝરાયલનાં અન્ય કુળોની માફક, દાન તેના લોકોનો ન્યાય કરશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","દાન માર્ગની બાજુમાંના સાપ જેવો, અને સીમમાં ઊડતા ઝેરી સાપ જેવો થશે, તે ઘોડાની એડીને એવો ડંખ મારશે, કે તેનો સવાર લથડી પડશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","હે ઈશ્વર, મેં તમારા ઉદ્ધારની રાહ જોઈ છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ગાદ પર હુમલાખોરો હુમલો કરશે, પણ ગાદ પ્રતિકાર કરીને તેમને પછાડશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","આશેરનું અન્ન પુષ્ટિકારક થશે; અને તે રાજવી મિષ્ટાન પૂરા પાડશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","નફતાલી છૂટી મૂકેલી હરણી છે, તે ઉત્તમ વચનો ઉચ્ચારે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","યૂસફ ફળદ્રુપ ડાળી છે; તે ઝરા પાસેના વૃક્ષ પરની ફળવંત ડાળી છે, આ ડાળી દીવાલ પર વિકસે છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ધનુર્ધારીઓએ તેના પર હુમલો કર્યા, અને તેના પર તીરંદાજી કરી, તેને ત્રાસ આપ્યો અને તેને સતાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","પણ તેનું ધનુષ્ય સ્થિર રહેશે, પણ યાકૂબના સામર્થ્યવાન ઈશ્વરના હાથે એ તીરો નાકામયાબ કર્યા. અને તે ઘેટાંપાળક તથા ઇઝરાયલનો ખડક થયો. ");
INSERT INTO guj2017_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","તારા પિતાના ઈશ્વર જે તારી સહાય કરશે તેમનાંથી, એટલે સર્વશક્તિમાન ઈશ્વર જે ઉપર આકાશના આશીર્વાદોથી તથા નીચે ઊંડાણના આશીર્વાદોથી, જાનવરો તથા સંતાનોના આશીર્વાદોથી તને વેષ્ટિત કરશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","તારા પિતાના આશીર્વાદ મારા પૂર્વજોના આશીર્વાદો કરતાં અતિ વિશેષ થયેલા છે, તે અનંતકાળિક પર્વતોની અતિ દૂરની સીમા સુધી વિસ્તરેલા છે; તેઓ યૂસફના શિર પર રહેશે, આ આશીર્વાદો પોતાના ભાઈથી જુદા કરાયેલા યૂસફના માથા પર મુગટ સમાન થશે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","બિન્યામીન પશુને ફાડી ખાનાર ભૂખ્યા વરુ જેવો છે: સવારે તે શત્રુઓનો શિકાર કરશે; અને સંધ્યાકાળે લૂંટ વહેંચશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","એ સર્વ ઇઝરાયલનાં બાર કુળ છે; તેઓના પિતાએ તેઓને જે કહ્યું અને તેઓને જે આશીર્વાદો આપ્યાં તે એ છે. તેણે પ્રત્યેકને તેઓની યોગ્યતા પ્રમાણેના આશીર્વાદ આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","પછી તેણે તેઓને સૂચનો આપીને કહ્યું, “હું મારા પૂર્વજો પાસે જવાનો છું; એફ્રોન હિત્તીના ખેતરમાંની ગુફામાં મારા પિતૃઓની પાસે, ");
INSERT INTO guj2017_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","એટલે કનાન દેશમાં મામરેની સામેના માખ્પેલા ખેતરમાં જે ગુફા એફ્રોન હિત્તીના ખેતર સહિત ઇબ્રાહિમે કબરસ્તાનને માટે વેચાતી લીધી હતી તેમાં મને દફનાવજો. ");
INSERT INTO guj2017_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ત્યાં મારા દાદા ઇબ્રાહિમને તથા દાદી સારાને દફનાવવામાં આવેલા છે. વળી મારા પિતા ઇસહાક તથા માતા રિબકાને દફનાવેલા છે. ત્યાં મેં લેઆને પણ દફનાવી છે. ");
INSERT INTO guj2017_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","એ ખેતર તથા તેમાંની ગુફા હેથના લોકો પાસેથી ખરીદવામાં આવ્યા હતાં.” ");
INSERT INTO guj2017_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","જયારે યાકૂબે તેના દીકરાઓને સૂચનો તથા અંતિમ વાતો કહેવાનું પૂરું કર્યું ત્યારે તેણે પોતાના પલંગ પર લંબાવીને પ્રાણ છોડ્યો અને પોતાના પૂર્વજોની સાથે ભળી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","પછી યૂસફ તેના પિતાના દેહને ભેટીને રડ્યો અને તેને ચુંબન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","યૂસફે તેના દાસોમાં જે વૈદો હતા તેઓને તેના પિતાના દેહમાં સુગંધીઓ ભરવાની આજ્ઞા આપી. તેથી વૈદોએ ઇઝરાયલના દેહમાં સુગંધીઓ ભરી. ");
INSERT INTO guj2017_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","સુગંધીઓ ભરવાનું કામ ચાલીસ દિવસ પછી પૂરું થયું. યાકૂબના મરણ નિમિત્તે મિસરીઓએ સિત્તેર દિવસ શોક પાળ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","જયારે તેના શોકના દિવસો પૂરા થયા ત્યારે યૂસફે ફારુનની રાજસભાને કહ્યું, “તમે મારા પર સહાનુભૂતિ દર્શાવેલી છે. તો હવે મારા વતી ફારુનને એમ કહો, ");
INSERT INTO guj2017_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘મારા પિતાએ મને સમ આપીને કહ્યું હતું કે, “હું મૃત્યુ પામવાનો છું. મેં મારા માટે કનાન દેશમાં કબર ખોદાવેલી છે, ત્યાં મને દફનાવજો.” તો હવે ફારુન મારા પિતાને દફનાવવા માટે મને જવા દે. એ વિધિ પૂરી કર્યા પછી હું પાછો આવીશ.’ ");
INSERT INTO guj2017_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ફારુને જવાબ આપ્યો, “તારા પિતાએ તને સમ આપ્યાં છે તે મુજબ તારા પિતાને દફનાવવા માટે જા.” ");
INSERT INTO guj2017_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","યૂસફ તેના પિતાને દફનાવવા માટે ગયો. ફારુનના સર્વ અધિકારીઓ, તેના ઘરના સભ્યો, મિસર દેશના સર્વ ઉચ્ચ અધિકારીઓ પણ તેની સાથે ગયા. ");
INSERT INTO guj2017_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","યૂસફના ઘરનાં સર્વ, તેના ભાઈઓ અને તેના પિતાના ઘરનાં સર્વ પણ ગયાં. તેઓએ તેમનાં નાનાં બાળકો, તેમના ટોળાં તથા તેમનાં અન્ય જાનવરોને ગોશેન દેશમાં રહેવા દીધાં. ");
INSERT INTO guj2017_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","તેની સાથે રથો તથા ઘોડેસવારો સહિત લોકોનો વિશાળ સમુદાય હતો. ");
INSERT INTO guj2017_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","જયારે તેઓ યર્દનની સામે પાર આટાદની ખળી છે ત્યાં પહોંચ્યા ત્યારે તેઓએ આક્રંદ કર્યું. પિતાને માટે સાત દિવસ સુધી શોક કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","આટાદની ખળીમાં તે દેશના કનાનીઓએ તે શોકનું વાતાવરણ જોયું, ત્યારે તેઓ બોલ્યા, “મિસરીઓના માટે આ એક શોકની મોટી જગ્યા છે.” તે માટે તે જગ્યાનું નામ આબેલ-મિસરાઈમ કહેવાય છે, જે યર્દન પાર છે. ");
INSERT INTO guj2017_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","પોતાના દીકરાઓને જેવા સલાહસૂચનો યાકૂબે આપ્યાં હતાં તે પ્રમાણે તેઓએ પિતાને સારુ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","તેના દીકરાઓ તેને કનાન દેશમાં લાવ્યા અને મામરે નજીક, માખ્પેલાના ખેતરમાંની ગુફામાં તેને દફ્નાવ્યો. ઇબ્રાહિમે કબરસ્તાન માટે તે ખેતર ગુફા સહિત એફ્રોન હિત્તી પાસેથી વેચાતું લીધું હતું. ");
INSERT INTO guj2017_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","તેના પિતાને દફનાવ્યા પછી યૂસફ તથા તેના ભાઈઓ અને જેઓ તેના પિતાને દફનાવવા માટે તેની સાથે ગયા હતા, તે સર્વ મિસરમાં પાછા આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","પિતાના મૃત્યુને લીધે યૂસફના ભાઈઓ ગભરાઈ ગયા. તેઓને મનમાં થયું કે, “જો યૂસફ આપણો દ્વેષ કરશે અને આપણે તેની સાથે જે દુર્વ્યવહાર કર્યો હતો તેનું વેર વાળવાનું તે ઇચ્છશે તો આપણું શું થશે?” ");
INSERT INTO guj2017_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","તેથી તેઓએ યૂસફને સંદેશ કહેવડાવી મોકલ્યો, “તારા પિતાએ મૃત્યુ પામ્યા અગાઉ સૂચન આપીને અમને કહ્યું હતું, ");
INSERT INTO guj2017_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘તમે આ પ્રમાણે યૂસફને કહેજો, “તેઓએ તારી સાથે જે ખરાબ વર્તન કર્યું અને તારો અપરાધ કર્યો તે માટે કૃપા કરીને તારા પિતાના ઈશ્વરના ભાઈઓને માફ કરજે.’ જયારે તે સંદેશ તેને મળ્યો ત્યારે યૂસફ ગળગળો થઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","તેના ભાઈઓએ જઈને તેને સાષ્ટાંગ પ્રણામ કર્યા. તેઓએ કહ્યું, “જો, અમે તારા દાસો છીએ.” ");
INSERT INTO guj2017_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","પણ યૂસફે તેઓને જવાબ આપ્યો, “બીશો નહિ. શું હું ઈશ્વરના સ્થાને છું? ");
INSERT INTO guj2017_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","તમે તો મારું ખરાબ કરવા ઇચ્છ્યું હતું પણ તમે આજે જેમ જોયું તેમ ઘણાં લોકોના જીવ બચાવવા ઈશ્વરે તેમાં સારું કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","તે માટે હવે ગભરાશો નહિ. હું પોતે તમારી તથા તમારાં બાળકોની સંભાળ રાખીશ.” એમ તેણે તેઓને દિલાસો આપ્યો અને તેઓની સાથે હેતથી વાત કરી. ");
INSERT INTO guj2017_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","યૂસફ પોતાના ભાઈઓ અને સંતાનો સાથે મિસરમાં રહ્યો. તે એકસો દસ વર્ષની વયે મરણ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","યૂસફે ત્રીજી પેઢી સુધી એફ્રાઇમનાં બાળકો જોયાં. તેણે મનાશ્શાના દીકરા માખીરના દીકરાઓ પણ જોયા. તેઓ યૂસફના ખોળામાં મોટા થયા. ");
INSERT INTO guj2017_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","જ્યારે મૃત્યુ થવાનું હતું ત્યારે યૂસફે તેના ભાઈઓ અને પરિવારને કહ્યું, “હું તો મૃત્યુ પામી રહ્યો છું પણ ઈશ્વર નિશ્ચે તમારી ખબર લેશે અને તેમણે જે દેશ સંબંધી આપણા પિતૃઓ ઇબ્રાહિમ, ઇસહાક તથા યાકૂબની આગળ પ્રતિજ્ઞા લીધી હતી, તે મુજબ ઈશ્વર આ દેશમાંથી આપણા દેશમાં તમને લઈ જશે.” ");
INSERT INTO guj2017_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","પછી યૂસફે ઇઝરાયલપુત્રોને પ્રતિજ્ઞા લેવડાવીને કહ્યું, “ઈશ્વર તમારી પાસે નિશ્ચે આવશે; તમે અહીંથી જાઓ તે સમયે તમે મારાં અસ્થિ અહીંથી લઈ જજો.” ");
INSERT INTO guj2017_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","યૂસફ એકસો દસ વર્ષનો થઈને મૃત્યુ પામ્યો અને તેઓએ તેના દેહમાં સુગંધીઓ ભરીને તેને મિસરમાં શબપેટીમાં સાચવી રાખ્યો.");
INSERT INTO guj2017_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ઇઝરાયલના જે પુત્રો પોતાના કુટુંબકબીલા સહિત તેઓના પિતા યાકૂબ સાથે મિસર દેશમાં આવ્યા તેઓનાં નામ આ છે: ");
INSERT INTO guj2017_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","રુબેન, શિમયોન, લેવી અને યહૂદા, ");
INSERT INTO guj2017_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ઇસ્સાખાર, ઝબુલોન અને બિન્યામીન, ");
INSERT INTO guj2017_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","દાન, નફતાલી, ગાદ અને આશેર. ");
INSERT INTO guj2017_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","યાકૂબ અને તેનાં સંતાનો મળીને કુલ સિત્તેર જણા હતા. યૂસફ તો અગાઉથી જ મિસરમાં આવ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","કેટલાક સમય બાદ યૂસફ, તેના બધા ભાઈઓ અને તે પેઢીનાં સર્વ માણસો મૃત્યુ પામ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","પછીની પેઢીના ઇઝરાયલીઓ સફળ થયા અને સંખ્યામાં ઘણા પ્રમાણમાં વધ્યા અને બળવાન થયા; તેઓની વસ્તીથી દેશ ભરચક થઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","પછી મિસરમાં એક નવો રાજા સત્તા પર આવ્યો, તેને યૂસફ વિષે કશી જાણકારી ન હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","તે રાજાએ પોતાની પ્રજાને કહ્યું, “આ ઇઝરાયલીઓને જુઓ; તેઓ આપણા કરતાં સંખ્યામાં વધારે અને ખૂબ બળવાન છે. ");
INSERT INTO guj2017_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","માટે આપણે તેઓ સાથે ચાલાકીથી વર્તીએ, નહિ તો તેઓ વધી જશે અને સંજોગોવશાત આપણને કોઈની સાથે લડાઈ થાય તો સંભવ છે કે તેઓ આપણા દુશ્મનો સાથે ભળી જાય, આપણી સામે લડે અને દેશમાંથી જતા રહે.” ");
INSERT INTO guj2017_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","તેથી મિસરીઓએ ઇઝરાયલીઓ પાસે સખત મજૂરી કરાવીને તેઓને પીડા આપવા માટે તેઓના ઉપર મુકાદમો નીમ્યા. તેઓની જબરજસ્તી વેઠીને ઇઝરાયલીઓએ ફારુનને માટે પીથોમ અને રામસેસ નગરો તથા પુરવઠા કેન્દ્રો બાંધ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","પણ જેમ જેમ તેઓ ઇઝરાયલીઓને પીડા આપતા ગયા તેમ તેમ તેઓ સંખ્યામાં વૃદ્ધિ પામતા ગયા. તેથી મિસરના લોકો ઇઝરાયલના લોકોથી ઘણા ભયભીત થયા. ");
INSERT INTO guj2017_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","મિસરના લોકોએ ઇઝરાયલીઓ પાસે સખત વેઠ કરાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","તેઓની પાસે જાતજાતની મજૂરી કરાવવા માંડી. ઈંટ અને ચૂનો તૈયાર કરવાની તથા ખેતરોમાં ખેડવાથી માંડીને લણણી સુધીની મહેનતનાં કામો કરાવીને તેઓનું જીવન અસહ્ય બનાવી દીઘું. ");
INSERT INTO guj2017_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","મિસરમાં શિફ્રાહ અને પૂઆહ નામની બે હિબ્રૂ દાયણો હતી. તેઓને મિસરના રાજાએ કડક આદેશ આપ્યો, ");
INSERT INTO guj2017_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“જ્યારે તમે હિબ્રૂ સ્ત્રીઓની પ્રસૂતિ કરાવવા માટે ખાટલા પાસે જાઓ ત્યારે જો તેઓને છોકરા જન્મે તો તેઓને મારી નાખવા. પણ જો છોકરી જન્મે તો તમારે તેઓને જીવતી રહેવા દેવી.” ");
INSERT INTO guj2017_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","પરંતુ આ દાયણો ઈશ્વરની બીક રાખનારી અને વિશ્વાસુ હતી, એટલે તેઓએ મિસરના રાજાની આજ્ઞા માની નહિ અને છોકરાઓને જીવતા રહેવા દીધા. ");
INSERT INTO guj2017_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","એ જાણીને મિસરના રાજાએ દાયણોને બોલાવીને કહ્યું, “તમે આવું શા માટે કર્યું? મારી આજ્ઞા કેમ ઉથાપી? નરબાળકોને કેમ જીવતા રહેવા દીધા?” ");
INSERT INTO guj2017_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ત્યારે દાયણોએ ફારુનને કહ્યું, “હે રાજા, હિબ્રૂ સ્ત્રીઓ મિસરી સ્ત્રીઓ જેવી નબળી હોતી નથી. તેઓ સશક્ત અને ખડતલ હોય છે; અમે પહોંચીએ તે પહેલાં જ તેઓ જલદીથી સંતાનોને જન્મ આપી દે છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","તેથી ઈશ્વરે એ દાયણો પર કૃપા દર્શાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","આમ ઇઝરાયલ પ્રજા પણ સંખ્યામાં અને શક્તિમાં વૃદ્ધિ પામતી રહી. દાયણો ઈશ્વરથી ડરીને ચાલતી હતી એટલે ઈશ્વરે તેઓને સંતાનોનાં કૃપાદાન આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","પછી ફારુને પોતાના બધા લોકોને ફરમાન કર્યું કે, “નવા જન્મેલા બધા જ હિબ્રૂ છોકરાને નીલ નદીમાં ફેંકી દેવા, પણ છોકરીઓ ભલે જીવતી રહે.” ");
INSERT INTO guj2017_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","એ સમયમાં ઇઝરાયલના લેવી કુળના એક જુવાને પોતાના જ કુળની કન્યા સાથે લગ્ન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","તેઓના સંસારમાં એક દીકરાનો જન્મ થયો. તે ખૂબ સુંદર હતો. તેની માએ તે દીકરાને ત્રણ માસ સુધી સંતાડી રાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","પરંતુ તેનાથી વધારે સમય સુધી તેને સંતાડી રાખવાનું શક્ય ન હતું, તેથી તેણે ગોમતૃણની એક પેટી બનાવી, તેને ચીકણી માટી અને ડામરથી લીંપીને છોકરાને તેમાં સુવાડ્યો. પછી પેટીને તે નીલ નદી કિનારે બરુઓના છોડ વચ્ચે મૂકી આવી. ");
INSERT INTO guj2017_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","પછી તે છોકરાનું શું થાય છે, તે જોવા માટે થોડેક દૂર તે છોકરાની બહેનને ઊભી રાખી. ");
INSERT INTO guj2017_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","એટલામાં ફારુનની રાજકુંવરી નદીમાં સ્નાન કરવા માટે ત્યાં આવી. તેની સાથે તેની દાસીઓ પણ હતી. તેઓ નદી કિનારે આમતેમ ફરવા લાગી. કુંવરીની નજર બરુઓની વચ્ચે પડેલી પેલી પેટી પર પડી. તેણે પોતાની દાસીને મોકલીને તે પેટી મંગાવી લીધી. ");
INSERT INTO guj2017_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","કુંવરીએ પેટી ઉઘાડીને જોયું, તો તેમાં એક છોકરો હતો. તે રડતો હતો. તેના હૃદયમાં બાળક પ્રત્યે લાગણી થઈ. તે સમજી ગઈ કે, આ કોઈ હિબ્રૂનો જ છોકરો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","પછી તે છોકરાની બહેન ફારુનની દીકરીની પાસે આવી. તેને કહ્યું, “હું જઈને કોઈ હિબ્રૂ સ્ત્રીને બોલાવી લાવું? તે આ છોકરાને સાચવે અને તેના લાલનપાલનમાં તમારી મદદ કરે?” ");
INSERT INTO guj2017_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ફારુનની દીકરીએ તેને કહ્યું, “હા, જઈને બોલાવી લાવ.” એટલે તે છોકરી જઈને તે બાળકની માતાને જ બોલાવી લાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ફારુનની દીકરીએ તેને કહ્યું, “આ નાના છોકરાને લઈ જા અને મારા વતી તેને સંભાળીને સ્તનપાન કરાવજે. તે બદલ હું તને સારું વેતન આપીશ.” તેથી સ્ત્રી તેના છોકરાને લઈ ગઈ અને તેનું લાલનપાલન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","પછી તે છોકરો મોટો થયો. એટલે તે તેને ફારુનની કુંવરી પાસે લઈ ગઈ અને તેને સોંપ્યો. કુંવરીએ તેને પોતાના પુત્રની જેમ ઉછેર્યો. “મેં એને પાણીમાંથી બહાર કાઢ્યો હતો, એમ કહીને કુંવરીએ તેનું નામ ‘મૂસા’ એટલે પાણીમાંથી બહાર કાઢેલો રાખ્યું.” ");
INSERT INTO guj2017_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","સમય વીતતાં મૂસા મોટો થયો. એક દિવસ તે પોતાના સાથી હિબ્રૂ લોકો પાસે ગયો, ત્યાં તેણે જોયું કે પોતાના માણસો પર સખત કામ કરાવવા માટે બળજબરી થાય છે. વળી તેના જોવામાં આવ્યું કે એક મિસરી એક હિબ્રૂને મારતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","મૂસાએ આમતેમ નજર કરી તો તેને ખાતરી થઈ કે પોતાને કોઈ જોતું નથી, એટલે તેણે મિસરીને મારી નાખ્યો અને તેના શબને રેતીમાં દફનાવી દીધું. ");
INSERT INTO guj2017_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","બીજે દિવસે તે ફરીથી બહાર ફરવા નીકળ્યો, ત્યારે તેણે બે હિબ્રૂઓને અંદરોઅંદર લડતા જોયા. જેનો વાંક હતો તે માણસને તેણે કહ્યું, “તું શા માટે તારા પોતાના જ હિબ્રૂ ભાઈને મારે છે?” ");
INSERT INTO guj2017_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","એટલે તેણે મૂસાને કહ્યું, “તને અમારા પર ઉપરી અને ન્યાયાધીશ કોણે બનાવ્યો છે? તેં ગઈકાલે પેલા મિસરીની હત્યા કરી તેમ તું મારી હત્યા કરવા માગે છે?” તે સાંભળીને મૂસા ડરી ગયો, કારણ કે તેણે જાણ્યું કે તેણે કરેલી હત્યાની બધાંને ખબર પડી ગઈ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","આ વાતની જાણ ફારુનને થઈ, તેણે મૂસાને પકડીને મારી નાખવાનો હુકમ કર્યો. પણ મૂસા મિસરમાંથી મિદ્યાન દેશમાં નાસી ગયો. એક વખત તે ત્યાં એક કૂવા પાસે બેઠો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ત્યારે મિદ્યાનના યાજકની સાત દીકરીઓ ત્યાં આવી. અને પોતાના પિતાનાં ઘેટાંબકરાંને પાણી પીવડાવવા માટે કૂવામાંથી પાણી ખેંચીને હોજ ભરવા લાગી. ");
INSERT INTO guj2017_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","પણ ત્યાં કેટલાક ભરવાડો આવ્યા, તેઓ આ યુવતીઓને નસાડવા લાગ્યા, પણ મૂસા તેઓની મદદે આવ્યો અને તેઓને ભરવાડોથી છોડાવીને તેઓનાં ઘેટાંબકરાંને પાણી પાયું. ");
INSERT INTO guj2017_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","પછી આ દીકરીઓ તેઓના પિતા રેઉએલ પાસે ગઈ ત્યારે તેણે પૂછ્યું, “આજે તમે ટોળાંને પાણી પાવાનું કામ આટલું બધું વહેલું કેવી રીતે પૂરું કર્યું?” ");
INSERT INTO guj2017_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","તેઓએ જવાબ આપ્યો, “એક મિસરીએ ભરવાડોથી અમારું રક્ષણ કરીને અમારે માટે તેણે પાણી પણ કાઢી આપ્યું અને ઘેટાંબકરાંને પાયું.” ");
INSERT INTO guj2017_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","પછી રેઉએલે પોતાની દીકરીઓને પૂછ્યું, “બેટા, એ મિસરી કયાં છે? તમે તેને ત્યાં જ રહેવા દઈને કેમ આવ્યાં? જાઓ, જમવા માટે તેને આપણા ઘરે બોલાવી લાવો.” ");
INSERT INTO guj2017_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","નિમંત્રણ મળવાથી મૂસા આવ્યો. અને તેઓના ઘરે રહેવા સંમત થયો. રેઉએલે પોતાની દીકરીઓમાંની એક સિપ્પોરાહનાં લગ્ન મૂસા સાથે કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","તેઓના કુટુંબમાં એક દીકરો જનમ્યો. મૂસાએ તેનું નામ ગેર્શોમ એટલે વિદેશી પાડ્યું. કેમ કે તે વખતે મૂસા વિદેશમાં મુસાફર હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","કેટલાંક વર્ષો વીતી ગયા પછી મિસરનો રાજા મૃત્યુ પામ્યો. ઇઝરાયલીઓ ગુલામીમાં પિડાતા હતા. તેઓ આક્રંદ કરીને મદદ માટે પ્રભુને પોકાર કરતા હતા. તેઓનો વિલાપ અને પ્રાર્થના ઈશ્વરે સાંભળી. ");
INSERT INTO guj2017_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","આ રુદન અને આર્તનાદ સાંભળીને ઈશ્વરને ઇબ્રાહિમ, ઇસહાક અને યાકૂબ સાથે કરેલા કરારનું સ્મરણ થયું. ");
INSERT INTO guj2017_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ઈશ્વરે ઇઝરાયલીઓ પર કરુણાભરી દ્રષ્ટિ કરી. અને તેઓના ઉદ્ધારનો સમય આવી પહોંચ્યો હોવાથી તેઓની મુલાકાત લીધી. ");
INSERT INTO guj2017_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","હવે મૂસા પોતાના સસરાના એટલે મિદ્યાનના યાજક યિથ્રોનાં ઘેટાંબકરાં સાચવતો હતો; એક દિવસ તે ઘેટાંબકરાંને ચરાવવા અરણ્યની પશ્ચિમ દિશામાં ઈશ્વરના પર્વત હોરેબ પર ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ત્યાં યહોવાહના દૂતે ઝાડવાં વચ્ચે આગના ભડકામાં તેને દર્શન દીધું. તેણે જોયું ઝાડવું સળગતું હતું. પણ બળીને ભસ્મ થતું ન હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","તેથી મૂસાએ વિચાર્યું કે, “હું નજીક જઈને આ મહાન દ્રશ્ય જોઉં. આ ઝાડવું બળે છે પણ ભસ્મ કેમ થતું નથી?” ");
INSERT INTO guj2017_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","યહોવાહે જોયું કે મૂસા અહીં ઝાડવું જોવા આવી રહ્યો છે, તેથી તેમણે ઝાડવામાંથી તેને બૂમ પાડી, “મૂસા, મૂસા!” અને મૂસાએ કહ્યું, “હા, હું અહીં જ છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ત્યારે યહોવાહે કહ્યું, “નજીક આવીશ નહિ, તારાં પગરખાં ઉતાર. કારણ કે જ્યાં તું ઊભો છે તે ભૂમિ પવિત્ર છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","“હું તારા પિતૃઓ ઇબ્રાહિમ, ઇસહાક અને યાકૂબનો ઈશ્વર છું.” તે સાંભળીને મૂસાએ પોતાનું મુખ ઢાંકી દીઘું. કેમ કે ઈશ્વર તરફ જોતાં તેને બીક લાગી. ");
INSERT INTO guj2017_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","પછી યહોવાહે કહ્યું, “મેં મિસરમાં મારા લોકોને દુઃખી હાલતમાં જોયા છે. તેઓના મુકાદમો તેમને પીડા આપે છે તેથી તેઓનો વિલાપ મેં સાંભળ્યો છે. તેઓની મુશ્કેલીઓ મેં જાણી છે. ");
INSERT INTO guj2017_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","હું તેઓને મિસરીઓના સકંજામાંથી મુક્ત કરાવવા અને તેઓને એ દેશમાંથી બહાર લાવીને એક સારા, વિશાળ અને દૂધ તથા મધથી રેલછેલવાળો દેશમાં લઈ જવા માટે આવ્યો છું. ત્યાં હાલમાં કનાનીઓ, હિત્તીઓ, અમોરીઓ, પરીઝીઓ, હિવ્વીઓ અને યબૂસીઓ રહે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","મેં ઇઝરાયલીઓનું રુદન સાંભળ્યું છે અને મિસરીઓ તેઓના ઉપર જે અત્યાચાર ગુજારે છે તે મેં નિહાળ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","માટે હવે, મારા ઇઝરાયલી લોકોને મિસરમાંથી બહાર લઈ આવવા હું તને ફારુન પાસે મોકલું છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","પરંતુ મૂસાએ ઈશ્વરને કહ્યું, “હું તે કોણ કે ફારુનની પાસે જઈને ઇઝરાયલીઓને મિસરમાંથી બહાર કાઢી લાવું?” ");
INSERT INTO guj2017_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","પણ ઈશ્વરે કહ્યું, “હું અવશ્ય તારી સાથે જ હોઈશ. અને મેં જ તને મોકલ્યો છે, એની નિશાની તારા માટે એ થશે કે જ્યારે તું એ લોકોને મિસરમાંથી બહાર લઈ આવશે પછી તમે સૌ આ પર્વત પર મારી ભક્તિ કરશો.” ");
INSERT INTO guj2017_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","મૂસાએ ઈશ્વરને કહ્યું, “હું ઇઝરાયલ લોકો પાસે જાઉં અને તેઓને કહું કે, ‘તમારા પિતૃઓના પ્રભુએ મને તમારી પાસે મોકલ્યો છે.’ અને તેઓ મને પૂછે કે, ‘તેમનું નામ શું છે?’ તો હું તેઓને શો જવાબ આપું?” ");
INSERT INTO guj2017_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ત્યારે ઈશ્વરે મૂસાને કહ્યું, “હું જે છું તે છું.” તું ઇઝરાયલીઓને કહેજે કે ‘હું છું એ મને તમારી પાસે મોકલ્યો છે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","વળી ઈશ્વરે મૂસાને એવું પણ કહ્યું, “તું ઇઝરાયલીઓને કહેજે કે, ‘તમારા પિતૃઓના ઈશ્વર યહોવાહે એટલે કે ઇબ્રાહિમ, ઇસહાક અને યાકૂબના ઈશ્વરે મને તમારી પાસે મોકલ્યો છે. મારું નામ સદાને માટે એ જ છે અને પેઢી દરપેઢી લોકો મને એ નામે જ યાદ રાખશે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","વળી ઈશ્વરે કહ્યું, “તું જા અને ઇઝરાયલના વડીલોને ભેગા કરીને તેઓને કહેજે કે, ‘તમારા પિતૃઓના ઈશ્વર, ઇબ્રાહિમ, ઇસહાક અને યાકૂબના પ્રભુએ, મને દર્શન આપીને કહ્યું છે મેં નિશ્ચે તમારી ખબર લીધી છે અને મિસરમાં તમે જે મુશ્કેલીઓ સહન કરી રહ્યા છો તે મેં જોઈ છે; ");
INSERT INTO guj2017_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","અને મેં નિર્ણય કર્યો છે કે હું તમને મિસરના આ દુર્દશામાંથી મુક્ત કરાવીને કનાનીઓ, હિત્તીઓ, અમોરીઓ, પરીઝીઓ, હિવ્વીઓ અને યબૂસીઓના દેશમાં લઈ જઈશ. એ દૂધ તથા મધથી રેલછેલવાળો દેશ છે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","લોકો તારી વાણી સાંભળશે, પછી તું અને ઇઝરાયલના વડીલો મિસરના રાજા પાસે જઈને તેને કહેજો કે, ‘હિબ્રૂઓના ઈશ્વર યહોવાહ અમને મળ્યા છે. એ અમારા ઈશ્વર યહોવાહની આગળ યજ્ઞાર્પણ કરવા માટે અમે ત્રણ દિવસની મુસાફરી કરીને જઈ શકીએ એટલે દૂર અરણ્યમાં અમને જવા દે.” ");
INSERT INTO guj2017_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","જો કે મને ખબર તો છે જ કે મિસરનો રાજા તમને ત્યાં નહિ જવા દે. હા, કોઈ સામર્થ્યવાન હાથ જ તમને ત્યાં લઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","આથી હું મારા સામર્થ્ય દ્વારા તેઓની વચ્ચે ચમત્કાર બતાવીશ અને મિસરના લોકોને મારીશ. ત્યાર પછી તે તમને જવા દેશે. ");
INSERT INTO guj2017_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","અને મિસરીઓની નજરમાં ઇઝરાયલી લોકો પર દયા દર્શાવાય તેવું હું કરીશ. તેને પરિણામે જ્યારે તમે મિસરમાંથી બહાર જવા રવાના થશો ત્યારે ખાલી હાથે બહાર નહિ આવો. ");
INSERT INTO guj2017_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","પણ દરેક સ્ત્રી પોતાની મિસરી પડોશણ પાસેથી અને પોતાના ઘરમાં રહેનારી મિસરી સ્ત્રી પાસેથી સોનાચાંદીનાં ઘરેણાં અને સુંદર કિંમતી વસ્ત્રો માગી લેશે અને તમે પોતાના દીકરાદીકરીઓને તે પહેરાવશો. આમ તમે મિસરીઓનું ધન લૂંટી લેશો.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ત્યારે મૂસાએ ઈશ્વરને જણાવ્યું, “પ્રભુ હું ઇઝરાયલના લોકોને કહીશ કે યહોવાહે મને મોકલ્યો છે, ત્યારે તેઓ મારા કહેવા પર વિશ્વાસ નહિ કરે અને કહેશે કે, “યહોવાહે તને દર્શન દીધું નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","પરંતુ યહોવાહે મૂસાને કહ્યું, “તારા હાથમાં શું છે?” મૂસાએ જવાબ આપ્યો, “લાકડી.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ત્યારે યહોવાહે કહ્યું, “તારી લાકડીને જમીન પર નાખ.” એટલે મૂસાએ લાકડી જમીન પર નાખી, ત્યારે તે બદલાઈને સાપ બની ગઈ. તે જોઈને મૂસા બી ગયો અને ત્યાંથી ખસી ગયો.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","પરંતુ યહોવાહે મૂસાને કહ્યું, “તું સાપની આગળ જા અને તારા હાથથી તેને પૂંછડીથી પકડી લે.” એટલે મૂસાએ સાપને પકડ્યો ત્યારે તેના હાથમાં સાપની લાકડી બની ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","તેથી યહોવાહે કહ્યું, “તારી લાકડીનો આ પ્રમાણે ઉપયોગ કરજે, એટલે લોકોને વિશ્વાસ બેસશે કે તેઓના પિતૃઓના ઈશ્વર પ્રભુએ એટલે ઇબ્રાહિમ, ઇસહાક અને યાકૂબના ઈશ્વરે તને દર્શન દીધું છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","વિશેષમાં યહોવાહે તેને કહ્યું, “હું તને બીજો ચમત્કાર બતાવું છું. તારો હાથ તેં પહેરેલા ઝભ્ભા નીચે છાતી પાસે મૂક.” તેમ કર્યા પછી મૂસાએ જ્યારે હાથ પાછો બહાર કાઢયો ત્યારે તેનો હાથ કુષ્ટરોગથી બરફ જેવો સફેદ થઈ ગયો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","પછી યહોવાહે મૂસાને કહ્યું, “તારો હાથ પાછો ઝભ્ભા નીચે છાતી પર મૂક.” એટલે તેણે તે પ્રમાણે કર્યું, પછી જયારે તેણે હાથ બહાર કાઢયો ત્યારે તે હાથ અગાઉના જેવો દુરસ્ત થઈ ગયો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","પછી યહોવાહે કહ્યું, “જો લોકો લાકડીના ચમત્કારની નિશાની પછી પણ તારું કહેવું નહિ માને તો આ બીજા ચમત્કારની નિશાનીથી તેઓ તારા પર ભરોસો કરશે. ");
INSERT INTO guj2017_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","વળી જો આ બે ચમત્કારો બતાવ્યા પછી પણ તેઓ તારી વાત ના સાંભળે, તો તું નીલ નદીમાંથી થોડું પાણી લઈને જમીન પર ઢોળજે, ત્યાં તે પાણી રક્ત થઈ જશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","પરંતુ મૂસાએ યહોવાહને કહ્યું, “હે પ્રભુ યહોવાહ, હું સાચું કહું છું કે, હું કોઈ સારો વક્તા નથી. હું લોકો સાથે કુશળતાપૂર્વક વાત કરવાની ક્ષમતા ધરાવતો નથી. તમારી સાથે વાતચીત થઈ તે પછી પણ હું બોલવામાં મંદ છું. મારી જીભ બરાબર ચાલતી નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ત્યારે યહોવાહે તેને કહ્યું, “માણસનું મુખ કોણે બનાવ્યું છે? તેને મૂક કે બધિર અને તેને અંધ કે નિહાળી શકતો કોણ બનાવે છે? અને માણસને દેખતો કે અંધ કોણ બનાવે છે? આ બધું હું જ કરી શકું છું. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","માટે હવે જા, તારા મુખમાં હું શબ્દો મૂકીશ અને તારે શું કહેવું તે હું તને શીખવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","છતાં મૂસાએ કહ્યું, “હે પ્રભુ યહોવાહ, કૃપા કરીને મારા સિવાય બીજા કોઈને મોકલો, મને નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","આવા અનાદરને લીધે યહોવાહ મૂસા પર ખૂબ ગુસ્સે થયા અને કહ્યું, “તારી સાથે હું તારા ભાઈ હારુન લેવીને મોકલીશ. તે કુશળ વક્તા છે. વળી જો, તે તને મળવા આવી રહ્યો છે, તને જોઈને તેનું હૃદય આનંદ પામશે. ");
INSERT INTO guj2017_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","તું તેની સાથે વાત કરજે અને શું કહેવાનું છે તે તેને શીખવજે. હું તમારા બન્નેના મુખમાં વાણી મૂકીશ અને તમો બન્નેએ શું કરવાનું છે તે તમને શીખવીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","તે તારા વતી લોકોની સાથે વાત કરશે. તે તારું મુખ બનશે અને તું તેને માટે ઈશ્વરને ઠેકાણે થશે. ");
INSERT INTO guj2017_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","માટે હવે આ તારી લાકડી સાથે લઈ જા. એના વડે તું ચમત્કારો કરી બતાવજે.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","પછી ત્યાંથી મૂસા પોતાના સસરા યિથ્રો પાસે પાછો આવ્યો અને તેને કહ્યું, “કૃપા કરીને મને મારા લોકો પાસે મિસરમાં પાછો જવા દે.” હું જોવા માગું છું કે તેઓ હજી હયાત છે કે નહિ! યિથ્રોએ તેને કહ્યું, “શાંતિથી જા.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","મૂસા મિદ્યાનમાં હતો, ત્યારે ઈશ્વરે તેને કહ્યું, “તું મિસરમાં જા. હવે ત્યાં તારે માટે કશું જોખમ નથી. કેમ કે જે લોકો તને મારી નાખવા માટે શોધતા હતા તેઓ બધા મૃત્યુ પામ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","આથી મૂસા પોતાની પત્ની અને પુત્રોને ગધેડા પર બેસાડીને પાછો મિસર જવા રવાના થયો. તેણે ઈશ્વરની લાકડી પોતાની સાથે રાખી. ");
INSERT INTO guj2017_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","રસ્તામાં યહોવાહે મૂસાને કહ્યું, “મિસરમાં પહોંચ્યા પછી મેં જે ચમત્કારો તને નિશાની તરીકે બતાવ્યા છે તે તું ફારુન સમક્ષ કરી બતાવજે. પણ હું તેને હઠાગ્રહી બનાવી દઈશ એટલે તે તારા લોકોને જવા દેશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","તે વખતે તું ફારુનને કહેજે: ‘યહોવાહ કહે છે કે: ઇઝરાયલ મારો જયેષ્ઠ પુત્ર છે ");
INSERT INTO guj2017_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","અને મેં તને કહ્યું છે કે, “મારા પુત્રને મારી ભક્તિ કરવા માટે જવા દે.” અને જો તું તેને જવા દેવાની ના પાડશે, તો હું તારા જયેષ્ઠ પુત્રને મારી નાખીશ.’” ");
INSERT INTO guj2017_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","મૂસા મિસર તરફ મુસાફરી કરી રહ્યો હતો ત્યારે એક સ્થળે તેણે મુકામ કર્યો, ત્યાં યહોવાહ તેને મળ્યા અને તેને મારી નાખવાનું ઇચ્છા કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","પણ સિપ્પોરાહએ ચકમકનો એક ધારદાર પથ્થર લઈને તેના વડે પોતાના પુત્રની સુન્નત કરી. તેની ચામડી મૂસાના પગે અડકાડીને તેણે કહ્યું, “ખરેખર તું તો મારા લોહીનો વર છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","તેથી યહોવાહે મૂસાને જતો કર્યો. ત્યારે સિપ્પોરાહએ કહ્યું, “સુન્નતના કારણથી તું મારે માટે લોહીનો વર છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","યહોવાહે હારુન સાથે વાત કરી હતી અને તેને કહ્યું હતું, “અરણ્યમાં જા અને તારા ભાઈ મૂસાને મળ.” તેથી હારુન ઈશ્વરના પર્વત પર જઈને તેને મળ્યો અને ભેટ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","મૂસાએ પોતાને યહોવાહે જે બાબત કહી હતી અને જે ચમત્કારો બતાવવાનું જણાવ્યું હતું તેની માહિતી તેને આપી. ");
INSERT INTO guj2017_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","મૂસા અને હારુન મિસરમાં ગયા અને ત્યાં ઇઝરાયલીઓના લોકોના બધા વડીલોને એકત્રિત કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","અને યહોવાહે મૂસાને કહેલી સર્વ વાતો હારુને તેઓને કહી સંભળાવી તથા મૂસાએ તેઓની સમક્ષ ચમત્કાર કરી બતાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","લોકોએ વિશ્વાસ કર્યો કે યહોવાહે જ તેઓને મોકલ્યા છે. વડીલોએ સાંભળ્યું અને તેઓ સમજ્યા કે ઈશ્વરે પોતાના લોક ઇઝરાયલની ખબર લીધી છે અને તેઓનાં દુઃખ જોયાં છે, ત્યારે તેઓએ શિર ઝુકાવીને યહોવાહની સ્તુતિ કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","લોકોની સાથે વાત કર્યા પછી મૂસા અને હારુને મિસરના રાજા ફારુન પાસે આવીને તેને કહ્યું, “ઇઝરાયલના ઈશ્વર યહોવાહ કહે છે, ‘મારા લોકોને મારે માટે પર્વ પાળવા સારુ અરણ્યમાં જવા દે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","પરંતુ ફારુને કહ્યું, “યહોવાહ તે વળી કોણ છે કે હું તેની સૂચના માનીને ઇઝરાયલીઓને જવા દઉં? તમે જેને ઈશ્વર માનો છો, તેને હું ઓળખતો નથી, વળી હું ઇઝરાયલીઓને જવા દેવાની પણ ના પાડું છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ત્યારે હારુન અને મૂસાએ કહ્યું, “હિબ્રૂઓના ઈશ્વરે અમને લોકોને દર્શન આપ્યું છે. અમારા ઈશ્વરનું ભજન કરવા માટે તું અમને અરણ્યમાં ત્રણ દિવસનો પ્રવાસ કરવા જવા દે, ત્યાં અમે યહોવાહને યજ્ઞાર્પણ કરીશું. જો અમને નહિ જવા દે તો ઈશ્વર તરફથી દેશ પર મરકી અને તલવારરૂપી આફત આવી પડશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","પરંતુ મિસરના રાજાએ તેઓને કહ્યું કે, “હે મૂસા અને હારુન, તમે લોકોના કામમાં કેમ અડચણરૂપ થાઓ છો? તમે તમારું કામ કરો અને લોકોને તેમનું કામ કરવા દો.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","વળી તેણે કહ્યું, “હમણાં આપણા દેશમાં હિબ્રૂ લોકોની સંખ્યા વધી ગઈ છે અને તમે તે લોકોને કામ કરતાં અટકાવવા માગો છો.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","તે જ દિવસે ફારુને ઇઝરાયલી લોકો પાસે સખત કામ કરાવવા માટે મુકાદમોને આદેશ આપ્યો કે, ");
INSERT INTO guj2017_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“હવે તમારે ઈંટો પાડવા માટે લોકોને પરાળ આપવું નહિ; તેઓ જાતે પરાળ લઈ આવે. ");
INSERT INTO guj2017_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","વળી ધ્યાન રાખજો કે, અત્યાર સુધી તેઓ જેટલી ઈંટો બનાવતા આવ્યા છે એમાં ઘટાડો થવો જોઈએ નહિ. હવે એ લોકો આળસુ થઈ ગયા છે. તેથી બૂમો પાડે છે કે, અમને અમારા ઈશ્વરને યજ્ઞો કરવા જવા દો. ");
INSERT INTO guj2017_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","તેઓને સતત એટલા બધા કામમાં રોકી રાખો કે પછી તેઓની પાસે મૂસાની જૂઠી વાતો સાંભળવાનો સમય જ રહે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","તેથી એ લોકોના મુકાદમોએ તેઓને જણાવ્યું કે, “ફારુને નિર્ણય કર્યો છે કે, તે ઈંટો પાડવા માટે તે તમને પરાળ નહિ આપે. ");
INSERT INTO guj2017_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","તમારે જાતે જ તમારા કામ માટે પરાળ ભેગું કરી લાવવું પડશે. તેથી જાઓ, પરાળ ભેગું કરો. તોપણ તમારે બનાવવાની ઈંટોની સંખ્યાનું પ્રમાણ તો એટલું જ રહેશે. તે ઓછું કરવામાં નહિ આવે.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","આથી લોકો પરાળ ભેગું કરવા માટે આખા મિસરમાં ફરી વળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","મુકાદમો ધમકી આપતા જ રહ્યા કે, “અગાઉ પરાળ મળતું હતું ત્યારે રોજનું જેટલું કામ કરતા હતા તેટલું જ કામ તમારે પૂરું કરવું પડશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ફારુનના મુકાદમોએ ઇઝરાયલીઓ પર દેખરેખ માટે જે ઉપરીઓને નિયુક્ત કર્યા હતા તેઓને ખૂબ માર મારીને પૂછવામાં આવતું હતું કે, “જેટલી ઈંટો અત્યાર સુધી તમે પાડતા હતા તેટલાં પ્રમાણમાં અગાઉની માફક કેમ પૂરી કરતા નથી?” ");
INSERT INTO guj2017_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","એટલે ઇઝરાયલીઓના ઉપરીઓ ફારુનની સમક્ષ આવીને આર્તનાદ કરવા લાગ્યા, “તમે તમારા સેવકો સાથે આવો વર્તાવ કેમ રાખો છો? ");
INSERT INTO guj2017_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","હવે અમને પરાળ આપવામાં આવતું નથી તેમ છતાં અમને કહેવામાં આવે છે કે પૂરતી ઈંટો પાડો; જરા જુઓ તો ખરા, અમને કેવો ત્રાસ આપવામાં આવે છે! ખરેખર, વાંક તો તમારા ઉપરીઓનો જ છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ત્યારે ફારુને તેઓને ધમકાવ્યા, “તમે લોકો આળસુ થઈ ગયા છો, તેથી કહો છો કે અમને યહોવાહના યજ્ઞો કરવા જવા દો. ");
INSERT INTO guj2017_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","હવે જાઓ, કામે લાગી જાઓ, તમને પરાળ પૂરું પાડવામાં નહિ આવે; અને ઈંટોની સંખ્યા તો નક્કી કરેલ પ્રમાણે તમારે પૂરી કરવી જ પડશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ઇઝરાયલી ઉપરીઓના ધ્યાનમાં આવ્યું કે હવે તેઓની સ્થિતિ કફોડી થવાની છે. કારણ કે તેઓ હવે અગાઉના જેટલી ઈંટો તૈયાર કરાવી શકતા નથી. ");
INSERT INTO guj2017_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","અને પછી ફારુનની પાસેથી તેઓ પાછા આવ્યા ત્યારે રસ્તામાં ઊભેલા મૂસા અને હારુન તેઓને સામા મળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","તેઓએ મૂસા અને હારુનને કહ્યું, “તમે શું કર્યુ છે એ યહોવાહ ધ્યાનમાં લે અને તમને શિક્ષા કરે. કારણ તમે અમને ફારુનની અને તેના સેવકોની નજરમાં તિરસ્કૃત બનાવી દીઘા છે; અને તેઓ અમને મારી નાખે તે માટે જાણે તમે તેઓના હાથમાં તલવાર આપી છે!” ");
INSERT INTO guj2017_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ત્યારે મૂસાએ યહોવાહને પ્રાર્થના કરી, “હે પ્રભુ યહોવાહ, તમે આ લોકોની આવી ખરાબ હાલત શા માટે કરી? વળી તમે મને શા માટે મોકલ્યો છે? ");
INSERT INTO guj2017_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","હે પ્રભુ, હું તમારા નામે ફારુન સાથે વાત કરવા ગયો ત્યારથી તેણે આ લોકોનું અહિત કરવા માંડ્યું છે અને તમે તમારા લોકોને બચાવવા માટે કશું કરતા નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","પછી યહોવાહે મૂસાને કહ્યું, “હવે, તને જોવા મળશે કે હું ફારુનની શી હાલત કરું છું. મારા સામર્થ્યને કારણે ફારુન તેઓને જવા દેશે. અને મારા બળવાન હાથનાં પરાક્રમને કારણે તે ઇઝરાયલ લોકોને દેશમાંથી મુક્ત કરશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","અને ઈશ્વરે મૂસાને કહ્યું, “હું યહોવાહ છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","અને ‘સર્વસમર્થ ઈશ્વર’ એ નામે મેં ઇબ્રાહિમ, ઇસહાક અને યાકૂબને દર્શન આપ્યું હતું. ઈશ્વર, યહોવાહ એ મારા નામની જાણકારી તેઓને ન હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","મેં તેઓની સાથે કરાર કર્યો હતો. તેઓ જે દેશમાં જઈને વસ્યા હતા તે કનાન દેશ તેઓને આપવાનું મેં વચન આપ્યું હતું. તેઓ ત્યાં રહેતા હતા, પણ તે તેઓનો પોતાનો પ્રદેશ ન હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","મેં ઇઝરાયલી લોકોની રડારોળ સાંભળી છે. તેઓ મિસરમાં ગુલામ છે અને મેં મારો કરાર યાદ કર્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","તેથી ઇઝરાયલીઓને કહે કે, ‘હું યહોવાહ છું.’ હું તેઓનું રક્ષણ કરીશ. મારા સામર્થ્ય વડે મિસરીઓની ગુલામીમાંથી તેઓને મુક્ત કરીશ. હું મિસરીઓને ભયંકર શિક્ષા કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","“હું તેઓને મારા લોક તરીકે સ્વીકારીશ. ત્યારે તેઓને ખબર પડશે કે મિસરની ગુલામીમાંથી તેઓને મુક્ત કરનાર તેઓનો ઈશ્વર હું છું. ");
INSERT INTO guj2017_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","હું યહોવાહ છું, મેં ઇબ્રાહિમ, ઇસહાક અને યાકૂબને જે દેશ આપવાનો કરાર કર્યો છે, તે દેશમાં હું ઇઝરાયલ લોકોને લઈ જઈશ. વતન તરીકે એ દેશ તેઓને આપીશ અને વારસ બનાવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","મૂસાએ ઈશ્વરની એ વાત ઇઝરાયલીઓને કહી. પણ તે વખતે તેઓ આકરી ગુલામીથી હતાશ થઈ ગયેલા તેથી તેઓએ ઈશ્વરની વાત કાને ધરી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ત્યારે યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“તું જઈને મિસરના રાજા ફારુનને કહે કે, તે ઇઝરાયલીઓને તારા દેશમાંથી જવા દે.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","પરંતુ મૂસાએ યહોવાહને કહ્યું, “ઇઝરાયલી લોકો જ મારું સાંભળતાં નથી; તો પછી ફારુન તો શાનો સાંભળે? વળી મને તો છટાપૂર્વક બોલતાં પણ આવડતું નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","પરંતુ યહોવાહે મૂસા અને હારુન સાથે વાતચીત કરી. તેઓને આજ્ઞા કરી કે, “તમે મિસરના રાજા ફારુન પાસે જાઓ. અને તેને તાકીદ આપો કે ઇઝરાયલી લોકોને મિસરમાંથી મુક્ત કરે.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ઇઝરાયલીઓના પિતૃઓનાં કુળોના આગેવાનો આ છે: ઇઝરાયલના જયેષ્ઠ રુબેનના ચાર પુત્રો: હનોખ, પાલ્લૂ, હેસ્રોન અને કાર્મી. ");
INSERT INTO guj2017_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","શિમયોનના પુત્રો; યમુએલ, યામીન, ઓહાદ, યાખીન, સોહાર તથા કનાની પત્નીથી જન્મેલો શાઉલ. ");
INSERT INTO guj2017_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","લેવીના પુત્રો: ગેર્શોન, કહાથ અને મરારી. લેવીનું આયુષ્ય એકસો સાડત્રીસ વર્ષનું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ગેર્શોનના પુત્રો: લિબ્ની અને શિમઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","કહાથના પુત્રો: આમ્રામ, યિસ્હાર, હેબ્રોન અને ઉઝિયેલ. કહાથનું આયુષ્ય એકસો તેત્રીસ વર્ષનું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","મરારીના પુત્રો: માહલી અને મુશી. આ બધા ઇઝરાયલના પુત્ર લેવીના વંશજો હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","આમ્રામે પોતાની ફોઈ યોખેબેદ સાથે લગ્ન કર્યું. તેઓના કુટુંબમાં હારુન અને મૂસાના જન્મ થયા. આમ્રામનું આયુષ્ય એકસો સાડત્રીસ વર્ષનું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","યિસ્હારના પુત્રો: કોરાહ, નેફેગ અને ઝિખ્રી. ");
INSERT INTO guj2017_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ઉઝિયેલના પુત્રો: મીશાએલ, એલ્સાફાન અને સિથ્રી. ");
INSERT INTO guj2017_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","હારુનનું લગ્ન આમ્મીનાદાબની પુત્રી અને નાહશોનની બહેન અલીશેબા સાથે થયું. તેઓના પુત્રો: નાદાબ, અબીહૂ, એલાઝાર અને ઈથામાર. ");
INSERT INTO guj2017_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","કોરાહના પુત્રો: આસ્સીર, એલ્કાના અને અબિઆસાફ. ");
INSERT INTO guj2017_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","હારુનના પુત્ર એલાઝારે પૂટીએલની પુત્રી સાથે લગ્ન કર્યું. તેઓનો પુત્ર: ફીનહાસ. તેઓ બધા લેવીના વંશજો હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","આ રીતે હારુન અને મૂસા લેવી કુળના વંશજો હતા. તેઓની સાથે ઈશ્વરે વાત કરી હતી કે, “ઇઝરાયલીઓને તેઓનાં કુળોના સમૂહ પ્રમાણે મિસરમાંથી બહાર લઈ આવો.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","એ જ હારુન અને મૂસાએ મિસરના રાજા ફારુન સાથે વાત કરીને તેને કહ્યું કે, “તે ઇઝરાયલી લોકોને મિસરની બહાર જવા દે.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ઈશ્વરે મિસર દેશમાં મૂસા સાથે વાત કરી તે દિવસે; ");
INSERT INTO guj2017_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","તેમણે મૂસાને કહ્યું, “હું યહોવાહ છું, હું તને કહું છું, તે બધું જ તું મિસરના રાજા ફારુનને કહેજે.” ");
INSERT INTO guj2017_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","અને મૂસાએ ઈશ્વરની સમક્ષ કહ્યું કે, “હું સ્પષ્ટ રીતે બોલી શકતો નથી તો પછી ફારુન મારી વાત કેવી રીતે સાંભળશે?” ");
INSERT INTO guj2017_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","યહોવાહે મૂસાને કહ્યું, “જો, મેં તને ફારુનની આગળ ઈશ્વરને ઠેકાણે ઠરાવ્યો છે. તારો ભાઈ હારુન તારો પ્રબોધક થશે. ");
INSERT INTO guj2017_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","હું તને જે આદેશ આપું છું તે બધા તું હારુનને જણાવજે. તારો ભાઈ હારુન એ વિગત ફારુનને જણાવશે કે ફારુન ઇઝરાયલી લોકોને મિસર દેશમાંથી જવા દે. ");
INSERT INTO guj2017_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","પણ હું ફારુનને હઠાગ્રહી બનાવી દઈશ, જેથી તું જે કંઈ કહેશે, તેને તે માનશે નહિ. તેથી હું મિસર દેશમાં અનેક ચમત્કારો કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","પણ ફારુન તમારું સાંભળશે નહિ, એટલે હું મિસર દેશ પર મારો હાથ ઉગામીશ, કઠોર શિક્ષા કરીશ. અને મારાં સૈન્યોને, મારી ઇઝરાયલી પ્રજાને, મિસરમાંથી બહાર લાવીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ત્યારે મિસરના લોકોને ખબર પડશે કે, “હું યહોવાહ છું, તેઓ જોતા રહેશે અને હું મારા લોકો ઇઝરાયલીઓને મુક્ત કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","મૂસાએ અને હારુને યહોવાહના આદેશોનું પાલન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","તેઓએ દરબારમાં ફારુનની સમક્ષ રજૂઆત કરી. ત્યારે મૂસાની ઉંમર એંસી વર્ષની અને હારુનની ઉંમર ત્યાસી વર્ષની હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","યહોવાહે મૂસા અને હારુનને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“જ્યારે ફારુન તમને એવું કહે કે, તમારા પરાક્રમના પુરાવા માટે ‘કોઈ ચમત્કાર બતાવો.’ ત્યારે તું હારુનને કહેજે કે, ‘તારી લાકડી લઈને ફારુનની આગળ જમીન પર નાખી દે’ એ નાખશે ત્યારે લાકડી સાપ બની જશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","પછી મૂસા અને હારુન મિસરના રાજા ફારુન પાસે ગયા. અને યહોવાહની આજ્ઞા પ્રમાણે તેમણે કર્યુ. હારુને ફારુન અને તેના અમલદારો સમક્ષ પોતાની લાકડી જમીન પર નાખી અને તે સાપ બની ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ત્યારે ફારુને જ્ઞાની પંડિતોને અને જાદુગરોને બોલાવ્યા. મિસરના જાદુગરોએ પણ મંત્રતંત્ર દ્વારા હારુનના જેવો જ ચમત્કાર કરી બતાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","તેઓએ પોતાની લાકડીઓ જમીન પર નાખી. એ લાકડીઓના સાપ બની ગઈ. પણ હારુનની લાકડી તેઓની લાકડીઓને ગળી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","તેમ છતાં ફારુને હઠાગ્રહ છોડ્યો નહિ. લોકોને જવા દેવાની ના પાડી. અને યહોવાહના કહ્યા મુજબ મૂસા અને હારુનની કહેલી વાત ફારુને લક્ષમાં લીધી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","પછી યહોવાહે મૂસાને કહ્યું, “ફારુન હઠીલો થયો છે, એ મારા લોકોને જવા દેવાનો ઇનકાર કરે છે; ");
INSERT INTO guj2017_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","જો ફારુન સવારે નીલ નદીના કિનારા પર આવશે. તું તેને મળવા ને ઘાટ પર ઊભો રહેજે, અને જે લાકડી સાપ થઈ ગઈ હતી, તે સાથે લઈને જજે. ");
INSERT INTO guj2017_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","“ફારુન આવે ત્યારે કહેજે કે, હિબ્રૂઓના ઈશ્વર યહોવાહે મને તારી પાસે મોકલ્યો છે અને કહેવડાવ્યું છે કે, મારા લોકોને મારું ભજન કરવા માટે અરણ્યમાં જવા દે; ‘જો અત્યાર સુધી તેં યહોવાહની વાત કાને ધરી નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","હવે યહોવાહ કહે છે કે, ‘હું યહોવાહ છું. એની તમને ખબર પડી જશે. હવે હું મારા હાથમાંની લાકડી નીલ નદીના પાણી પર પછાડીશ એટલે સમગ્ર પાણી રક્ત થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","નીલ નદીની માછલીઓ મરી જશે. નદીમાંથી દુર્ગંધ ફેલાશે અને મિસરવાસીઓને માટે એનું પાણી પીવાલાયક પણ રહેશે નહિ.’” ");
INSERT INTO guj2017_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","પછી યહોવાહે મૂસાને કહ્યું, “તું હારુનને કહે કે, તારી લાકડી હાથમાં લઈને મિસરનાં તમામ જળાશયો, નદીઓ, નહેરો અને તળાવો પર તારો હાથ ફેરવ એટલે તેમાંનુ બધું જ પાણી રક્ત બની જશે. અને સમગ્ર મિસર દેશમાં લાકડાંનાં અને પથ્થરનાં બધાં વાસણોમાંના પાણીનું પણ રક્ત થઈ જશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","તેથી મૂસા અને હારુને યહોવાહે આપેલી આજ્ઞાનું પાલન કર્યું. હારુને ફારુન અને તેના અમલદારોના દેખતાં લાકડી વડે નીલના પાણી પર પ્રહાર કર્યો. તેથી તેમાંનું બધું જ પાણી રક્ત થઈ ગયું. ");
INSERT INTO guj2017_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","નદીમાંની બધી માછલીઓ મરી ગઈ. અને નદીમાંથી દુર્ગંધ પ્રસરવા લાગી. અને મિસરના લોકો માટે નીલ નદીનું પાણી પીવા લાયક રહ્યું નહિ. સમગ્ર મિસરમાંનું તમામ પાણી રક્ત થઈ ગયું. ");
INSERT INTO guj2017_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","તો સામે પક્ષે મિસરના જાદુગરોએ પણ પોતાના તંત્રમંત્રથી તે પ્રમાણે કર્યું. ફારુને મૂસા અને હારુનની વાત કાને ન ધરી. યહોવાહના જણાવ્યા મુજબ ફારુન હઠીલો થઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","તેણે કશું ગણકાર્યું નહિ. ફારુન પોતાના મહેલમાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","નીલ નદીનું પાણી મિસરવાસીઓથી પિવાય એવું રહ્યું ન હતું. તેથી તેઓએ નદીની આજુબાજુ કૂવાઓ ખોદ્યા અને વીરડા ગાળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","યહોવાહે નીલ નદી પર પ્રહાર કર્યા પછી સાત દિવસ પસાર થઈ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","પછી યહોવાહે મૂસાને કહ્યું, “ફારુન પાસે જઈને તેને જણાવ કે યહોવાહ એવું કહે છે: ‘મારા લોકોને મારી સેવા કરવા જવા દે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","પણ જો તું તેઓને જવા દેવાની ના પાડશે તો, હું મિસર દેશમાં દેડકાંઓ દ્વારા ઉપદ્રવ કરાવીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","નીલ નદી દેડકાંઓથી ભરાઈ જશે. વળી એ દેડકાં નદીમાંથી બહાર આવીને તારા મહેલમાં, ઘરોમાં, શયનખંડમાં તથા પલંગમાં અને તારા અમલદારોના તથા પ્રજાનાં ઘરોમાં, રસોડામાં અને પાણીનાં પાત્રોમાં ભરાઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","તું તારી પ્રજા અને તારા અમલદારો ઠેરઠેર દેડકાંના ઉપદ્રવથી હેરાન થઈ જશો.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","પછી યહોવાહે મૂસાને કહ્યું, “હારુનને કહે કે, તે પોતાના હાથની લાકડીને નહેરો, નદીઓ અને સરોવરો તરફ ઊંચી કરે. જેથી મિસર દેશ પર દેડકાંઓ ચઢી આવે.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ત્યારે હારુને મિસર દેશમાં આવેલા પાણીનાં સ્થળો તરફ તેના હાથ ઊંચા કર્યા અને પાણીમાંથી દેડકાંઓ બહાર આવીને સમગ્ર મિસર દેશમાં છવાઈ ગયાં. ");
INSERT INTO guj2017_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","મિસરના જાદુગરોએ પણ એવું જ કર્યું. તેઓ પણ મિસર દેશમાં દેડકાંઓ લઈ આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","પછી ફારુને મૂસા અને હારુનને બોલાવીને કહ્યું, “તમે યહોવાહને પ્રાર્થના કરો કે તે મને અને મારી પ્રજાને દેડકાંના ઉપદ્રવથી છોડાવે, એ દેડકાંને દૂર કરે. પછી હું તમારા લોકોને યહોવાહને યજ્ઞો અર્પવા જવા દઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","મૂસાએ ફારુનને કહ્યું, “સારું, તું કૃપા કરીને મને કહે કે મારે તારા માટે, તારા અમલદારો માટે અને તારી પ્રજા માટે યહોવાહને ક્યારે પ્રાર્થના કરવી, જેથી દેડકાં તમારી પાસેથી અને તમારા ઘરોમાંથી પાણીનાં સ્થળોમાં જતા રહે અને ત્યાં જ રહે.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ફારુને કહ્યું, “આવતી કાલે.” મૂસાએ કહ્યું, “તું કહે છે તે પ્રમાણે થશે.” જેથી તને માલૂમ પડશે કે અમારા ઈશ્વર યહોવાહ સમાન અન્ય કોઈ ઈશ્વર નથી. ");
INSERT INTO guj2017_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","દેડકાં તારી આગળથી અને ઘરોમાંથી અને તારા મહેલમાંથી અને તારા અમલદારો તેમ જ પ્રજાની આગળથી જતાં રહેશે. અને તેઓ પાણીનાં સ્થળોમાં અને નીલ નદીમાં જ રહેશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","પછી મૂસા અને હારુન ફારુન પાસેથી વિદાય થયા. મૂસાએ દેડકાંઓ વિષે યહોવાહને વિનંતી કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","અને યહોવાહે મૂસાની વિનંતી પ્રમાણે કર્યું. ઘરોમાંનાં, ઘરના ચોકમાંનાં તથા ખેતરોમાંનાં દેડકાં મરી ગયાં. ");
INSERT INTO guj2017_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","મરેલાં દેડકાંઓના ઢગલા ભેગા થયા. તેથી દેશભરમાં દુર્ગંધ પ્રસરી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","પણ જ્યારે ફારુને જોયું કે છૂટકો મળ્યો છે, ત્યારે યહોવાહના કહ્યા પ્રમાણે ફારુને પોતાનું હૃદય હઠીલું કરીને તેઓનું માન્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","પછી યહોવાહે મૂસાને કહ્યું, “હારુનને કહે કે, તે પોતાની લાકડી જમીન પરની ધૂળ પર મારે. કે જેથી આખા મિસર દેશમાં સર્વત્ર ધૂળની જૂ થઈ જાય.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","મૂસાએ હારુનને કહ્યું, હારુને હાથમાં લાકડી લઈને જમીનની ધૂળ પર પ્રહાર કર્યો, એટલે સર્વત્ર ધૂળની જૂ થઈ ગઈ. અને તે જુઓ મિસરના સર્વ માણસો અને જાનવરો પર છવાઈ ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","મિસરના જાદુગરોએ પોતાના જંતરમંતરનો ઉપયોગ દ્વારા જૂઓ લાવવા પ્રયત્ન કર્યો, પરંતુ તેઓને નિષ્ફળતા મળી. ");
INSERT INTO guj2017_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","હવે જાદુગરોએ ફારુનની આગળ કબૂલ કર્યું કે, આ તો ઈશ્વરની શક્તિથી જ બનેલું છે. પરંતુ ફારુને તેઓને સાંભળ્યા નહિ, તે હઠીલો જ રહ્યો. યહોવાહે કહ્યું હતું એ જ પ્રમાણે ફારુન વર્ત્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","યહોવાહે મૂસાને કહ્યું, “તું ફારુન પાસે જજે. ફારુન સવારે નદી કિનારે ફરવા નીકળે ત્યારે સવારે વહેલો ઊઠીને તેની રાહ જોઈ ત્યાં ઊભો રહેજે. અને તે આવે ત્યારે કહેજે કે, યહોવાહ એવું કહે છે કે, ‘મારા લોકોને મારું ભજન કરવા જવા દે. ");
INSERT INTO guj2017_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","જો તું મારા લોકોને નહિ જવા દે તો હું તારા પર, તારા અમલદારો પર તથા તારી પ્રજા પર તથા ઘરોમાં માખીઓ મોકલીશ. અને મિસરના લોકોનાં ઘરો માખીઓથી ભરાઈ જશે; ઠેરઠેર માખીઓ જ હશે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","પણ તે દિવસે હું મારા ઇઝરાયલી લોકોને સંભાળી લઈશ. જે ગોશેન પ્રાંતમાં તેઓ વસે છે ત્યાં માખીનું નામનિશાન હશે નહિ, એટલે તને ખાતરી થશે કે સમગ્ર પૃથ્વીમાં હું એકલો જ યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","આમ હું મારા લોક અને તારા લોક વચ્ચે ભેદભાવ રાખીશ; તને મારા ચમત્કાર જોવા મળશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","પછી યહોવાહે તે મુજબ કર્યું. તેમના કહ્યા પ્રમાણે ફારુનના મહેલમાં, તેના અમલદારોનાં ઘરોમાં તથા આખા મિસર દેશમાં માખીઓનાં ઝુંડેઝુંડ ધસી આવ્યાં અને સમગ્ર દેશ માખીઓથી પરેશાન થઈ ગયો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","એટલે ફારુને મૂસા અને હારુનને બોલાવ્યા. તેઓને કહ્યું, “તમે લોકો તમારા ઈશ્વરને આ દેશમાં યજ્ઞાર્પણ ચઢાવો.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","પરંતુ મૂસાએ કહ્યું, “એ પ્રમાણે કરવું ઉચિત નથી, કારણ કે અમે અમારા ઈશ્વર યહોવાહને અર્પણ ચઢાવીએ તેને મિસરના લોકો અપવિત્ર ગણે છે. તેથી મિસરના લોકો જેને પવિત્ર ગણે છે તેવી આહુતિ જો અમે આપીએ તો તેઓ અમને પથ્થરો મારીને મારી નાખે નહિ? ");
INSERT INTO guj2017_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","અમને ત્રણ દિવસ સુધી અરણ્યમાં જવા દે અને અમારા ઈશ્વર યહોવાહને યજ્ઞો અર્પવા દે. યહોવાહે અમને એવું કરવા ફરમાવેલું છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","એટલે ફારુને કહ્યું, “હું તમને લોકોને તમારા ઈશ્વર યહોવાહને યજ્ઞો અર્પવા માટે અરણ્યમાં જવા દઈશ, પરંતુ તમારે ઘણે દૂર જવું નહિ અને મારા માટે પણ પ્રાર્થના કરવી.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","મૂસાએ કહ્યું, “સારું, હું અહીંથી તારી આગળથી જઈને તરત જ યહોવાહને વિનંતી કરીશ કે, ફારુન અને તારા અમલદારોને તથા તારી પ્રજાને આવતી કાલે સવારે માખીઓના ત્રાસથી મુક્ત કરે. પણ તમે અમને મૂર્ખ ન બનાવતા, યહોવાહને યજ્ઞો અર્પવા અમને અરણ્યમાં જવા દેવાના છે; અમને ના પાડવાનું નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","એટલે મૂસા ફારુન પાસેથી વિદાય થઈને યહોવાહ પાસે ગયો અને પ્રાર્થના કરી, ");
INSERT INTO guj2017_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","અને યહોવાહે મૂસાની વિનંતી અનુસાર કર્યું. ત્યારે ફારુન, તેના અમલદારો અને તેની પ્રજા માખીઓના ત્રાસથી મુક્ત થયા. દેશમાં એક પણ માખી રહી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","પરંતુ ફારુન તો ફરી પાછો હઠાગ્રહી થઈ ગયો અને તેણે ઇઝરાયલી લોકોને જવા દીધા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ત્યારે યહોવાહે મૂસાને કહ્યું, “ફારુનની પાસે જા અને તેને કહે કે, હિબ્રૂઓના ઈશ્વર યહોવાહ એમ કહે છે કે, ‘મારા લોકોને મારું ભજન કરવા જવા દે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","હજુ પણ જો તું ના પાડશે અને તેઓને રોકી રાખશે તો ધ્યાનથી સાંભળી લે, ");
INSERT INTO guj2017_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","હું યહોવાહ, ખેતરનાં તારાં જાનવરો એટલે ઘોડાઓમાં, ગધેડાંઓમાં, ઊંટોમાં, ગાયબળદોમાં અને ઘેટાંબકરાંઓમાં ભારે રોગચાળો ફેલાવીશ અને તને સજા કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","પરંતુ હું યહોવાહ ઇઝરાયલીઓના અને મિસરનાં જાનવરો વચ્ચે ભેદભાવ રાખીશ. જેથી ઇઝરાયલીઓનું એક પણ જાનવર મરશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","“હું યહોવાહ આવતી કાલે આ દેશમાં એનો અમલ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","અને બીજે દિવસે સવારે મિસરમાં ઈશ્વરે પોતાના કહ્યા પ્રમાણે કર્યું, મિસરીઓનાં બધાં જાનવર મરી ગયાં પરંતુ ઇઝરાયલીઓનું એક પણ જાનવર મર્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ફારુને પોતાના માણસોને તપાસ કરવા મોકલ્યા કે ઇઝરાયલના લોકોનું એકે જાનવર મર્યું છે કે નહિ. તપાસ દ્વારા તેને જણાવવામાં આવ્યું કે ઇઝરાયલીઓનું એક પણ જાનવર મર્યું નથી. આટલું થયા છતાં ફારુને હઠાગ્રહ ચાલુ રાખ્યો. તેણે લોકોને જવા દીધા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","યહોવાહે મૂસા અને હારુનને કહ્યું, “તમારા હાથમાં ભઠ્ઠીમાંથી મુઠ્ઠીઓ ભરીને રાખ લો અને મૂસા ફારુનના દેખતાં તેને હવામાં ઊંચે ઉડાડે. ");
INSERT INTO guj2017_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","એ રાખની ઝીણી રજકણો આખા મિસર દેશમાં ફેલાઈ જશે. તેની અસરથી સમગ્ર મિસરના માણસો અને જાનવરોને શરીરે ગૂમડાં ફૂટી નીકળશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","એટલે મૂસા અને હારુને ભઠ્ઠીમાંથી રાખ લીધી. પછી ફારુનની આગળ ઊભા રહીને મૂસાએ આકાશ તરફ રાખ ઉડાડી. તેના ફેલાવાથી માણસોને અને જાનવરોને ગૂમડાં થયાં. ");
INSERT INTO guj2017_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","મિસરના જાદુગરો મૂસાને આવું કરતાં રોકી શક્યા નહિ, કારણ કે જાદુગરોને તથા બધા જ મિસરના લોકોને ગૂમડાં ફૂટી નીકળ્યાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","પરંતુ યહોવાહે ફારુનનું હૃદય હઠીલું બનાવ્યું. અને તેમણે કહ્યું હતું તે પ્રમાણે ફારુને મૂસાની અને હારુનની વાત સાંભળી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","પછી યહોવાહે મૂસાને કહ્યું, “સવારમાં વહેલો ઊઠીને ફારુન પાસે જજે. અને તેને કહેજે કે, હિબ્રૂઓના ઈશ્વર યહોવાહ એવું કહે છે કે, ‘મારા લોકોને મારું ભજન કરવા જવા દે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","જો તું નહિ જવા દે તો હું મારી બધી મરકીઓ તારા પર, તારા સરદારો પર અને તારા લોકો પર મોકલીશ. ત્યારે તને ખબર પડશે કે જગતમાં મારા જેવો અન્ય કોઈ ઈશ્વર નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","જો અત્યાર સુધીમાં મેં, તારા પર અને તારી પ્રજા પર મરકી મોકલીને તને સજા કરી હોત તો તું ભૂમિ ઉપરથી નષ્ટ થઈ ગયો હોત. ");
INSERT INTO guj2017_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","પણ મેં તને એટલા માટે જીવતો રાખ્યો છે કે હું તને મારું પરાક્રમ બતાવું. અને સમગ્ર પૃથ્વી પર મારું નામ પ્રગટ થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","શું તું હજુ પણ મારા લોકોની વિરુદ્ધ છે? તું મારા લોકો સાથે પોતાને ઊંચો રાખીને તેઓને જવા દેતો નથી? ");
INSERT INTO guj2017_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","યાદ રાખજે, આવતી કાલે આ જ સમયે હું ભારે કરાનો એવો વરસાદ વરસાવીશ કે મિસરની સ્થાપનાથી આજ સુધી એવા કરા મિસરમાં કદીય વરસ્યા નથી. ");
INSERT INTO guj2017_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","એટલે અત્યારે જ માણસો મોકલીને તારાં જાનવરોને તથા ખેતરમાં જે કોઈ હોય તે બધાંને સુરક્ષિત જગ્યાએ મંગાવી લેજે. કારણ જે કોઈ માણસ કે જાનવર ખેતરમાં હશે અને તેઓને ઘરમાં લાવવામાં આવ્યાં નહિ હોય, તેઓના પર કરા વરસશે અને તેઓ મરણ પામશે. ");
INSERT INTO guj2017_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ફારુનના કેટલાક અમલદારો યહોવાહની આ વાણી સાંભળીને ગભરાઈ ગયા. તેઓએ જલ્દીથી પોતાના ચાકરોને અને જાનવરોને ઘરમાં લાવી દીધાં. ");
INSERT INTO guj2017_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","પણ જેઓએ યહોવાહની વાણીને ધ્યાનમાં લીધી નહિ તેઓએ પોતાના ગુલામોને અને જાનવરોને ખેતરમાં જ રહેવા દીઘાં. ");
INSERT INTO guj2017_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","યહોવાહે મૂસાને કહ્યું, “તારા હાથ આકાશ તરફ લંબાવ, જેથી આખા મિસર દેશમાં માણસો, જાનવરો અને ખેતરની બધી વનસ્પતિ પર કરા પડે.” ");
INSERT INTO guj2017_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","પછી મૂસાએ પોતાની લાકડી આકાશ ભણી ઊંચી કરી એટલે યહોવાહે ભારે ગર્જના સાથે જમીન પર કરા વરસાવ્યા. તે સાથે પૃથ્વી પર અગ્નિ ધસી આવ્યો અને આખા મિસર દેશ પર કર તૂટી પડયા. ");
INSERT INTO guj2017_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","વરસતા કરાની સાથે વીજળી ઝબકારા મારતી હતી. મિસર દેશ સ્થપાયો ત્યારથી આજસુધી કદી ન પડયો હોય એવો ભારે કરાનો વરસાદ આખા દેશમાં પડયો. ");
INSERT INTO guj2017_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","તેને લીધે મિસરના ખેતરોમાંની તમામ વનસ્પતિ અને પાકનો નાશ થઈ ગયો. અને કરાના કારણે આખા મિસર દેશમાં જે માણસો, જાનવરો, તથા ખેતરોમાં જે કાંઈ હતું તે બધાનો નાશ થયો. કરાએ ખેતરોમાંના દરેક છોડને તેમ જ ઝાડને નષ્ટ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ફક્ત ગોશેન પ્રાંતમાં કે જ્યાં ઇઝરાયલીઓ રહેતા હતા ત્યાં કરા પડયા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","પછી ફારુને મૂસા અને હારુનને બોલાવીને તેઓને કહ્યું, “આ વખતે મેં પાપ કર્યુ છે, યહોવાહ ન્યાયી છે. હું તથા મારી પ્રજા અપરાધી છીએ. ");
INSERT INTO guj2017_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","તમે યહોવાહને અરજ કરો, કારણ કે આ કરા અને ભયંકર ગર્જનાથી અમે ત્રાસી ગયા છીએ. હું તમને જવા દઈશ, હવે તમારે અહીં રોકાવું નહિ પડે.” ");
INSERT INTO guj2017_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","મૂસાએ ફારુનને કહ્યું, “હું નગરમાંથી બહાર જઈશ. ત્યારે હું પ્રાર્થના માટે યહોવાહની આગળ મારા હાથ લંબાવીશ. એટલે તરત વીજળીના કડાકા બંધ થઈ જશે. અને કરા પડવાનું પણ અટકી જશે. આ પરથી તને ખબર પડશે કે આખી પૃથ્વી પ્રભુની છે. ");
INSERT INTO guj2017_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","પણ હું જાણું છું કે તું અને તારા અમલદારો તથા લોકો હજુ પણ યહોવાહથી ડરવાના નથી. અને તેમનું સન્માન પણ કરવાના નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","શણ અને જવનો ઘાણ વળી ગયો. કારણ કે જવ ઊગી નીકળ્યા હતા અને શણને ફૂલ બેઠાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","પરંતુ ઘઉં અને કઠોળ નષ્ટ થયા નહિ કારણ કે તેને પાકવાની વાર હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","મૂસા ફારુનને છોડીને નગર બહાર આવ્યો. અને તેણે યહોવાહ સમક્ષ પોતાના હાથ લંબાવીને પ્રાર્થના કરી. એટલે કડાકા અને કરા બંધ થઈ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","પછી જ્યારે ફારુને જોયું કે વર્ષા, કરા અને કડાકા બંધ થઈ ગયા એટલે ફરીથી તેણે અને તેના સરદારોએ પોતાના હૃદય હઠીલાં કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ફારુને ઇઝરાયલ લોકોને મુક્ત રીતે જવા દેવાની ના પાડી દીધી. યહોવાહે મૂસાને કહ્યું હતું તે પ્રમાણે જ થયું. ફારુન પાછો હઠે ભરાયો. ");
INSERT INTO guj2017_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","પછી યહોવાહે મૂસાને કહ્યું, “તું ફારુન પાસે જા. મેં તેને અને તેના સરદારોને એટલા માટે હઠાગ્રહી બનાવ્યા છે કે જેથી હું મારું ચમત્કારિક સામર્થ્ય તેઓની સમક્ષ પ્રગટ કરું. ");
INSERT INTO guj2017_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","અને તું તારા પુત્રને અને પૌત્રોને કહી શકે કે મેં આ મિસરના લોકોને કેવી સખત શિક્ષા કરી હતી, અને મેં તેઓને કેવા ચમત્કાર બતાવ્યા હતા. આથી તમને ખબર પડશે કે હું જ યહોવાહ છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","મૂસા અને હારુન ફારુન પાસે ગયા અને કહ્યું, “હિબ્રૂઓના યહોવાહ કહે છે; ‘તું કયાં સુધી મારી આજ્ઞા ઉથાપ્યા કરીશ? મારા લોકોને મારું ભજન કરવા જવા દે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","સાંભળી લે, જો તું મારા લોકોને મારું ભજન ઉપાસના કરવા જવા દેવાની ના પાડશે તો ખાતરી રાખજે આવતી કાલે હું તારા દેશમાં તીડોનો ઉપદ્રવ મોકલીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","એ તીડો જમીન પર એવાં છવાઈ જશે કે જમીન દેખાશે જ નહિ. અને કરાની વર્ષા પછી તારી પાસે જે કાંઈ બચેલું છે, તે તેઓ ખાઈ જશે; તેઓ તારા ખેતરમાંના તમામે છોડ ખાઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","તેઓ તારા મહેલોને તથા તારા અમલદારોના અને તમામ મિસરવાસીઓનાં ઘરોને ભરી દેશે. તારા પિતૃઓએ મિસરમાં વસવાટ શરૂ કર્યો ત્યારથી આજસુધી જોયાં ના હોય એટલાં બધાં જથ્થાબંધ તીડો છવાઈ જશે.” પછી મૂસા ફારુન પાસેથી ચાલ્યો ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ફારુનના સરદારોએ તેને કહ્યું, “અમે ક્યાં સુધી આ લોકો તરફથી ત્રાસ ભોગવતા રહીશું? એ લોકોને તેઓના ઈશ્વર યહોવાહ નું ભજન કરવા જવા દે. શું તું નથી જાણતો કે હવે મિસરનો સર્વનાશ થવા બેઠો છે?” ");
INSERT INTO guj2017_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","એટલે મૂસાને અને હારુનને ફારુન પાસે બોલાવવામાં આવ્યા. ફારુને તેઓને કહ્યું, “ભલે, તમે જાઓ અને તમારા ઈશ્વર યહોવાહનું ભજન કરો. પણ મને જણાવો કે તમે કોણ કોણ જશો?” ");
INSERT INTO guj2017_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","મૂસાએ જવાબ આપ્યો, “અમે અમારા યુવાનોને, વયસ્કોને, દીકરાદીકરીઓને, ઘેટાંબકરાંઓને તથા અન્ય જાનવરોને લઈ જઈશું. અમે બધાં જ જઈશું. કારણ એ અમારા માટે અમારા યહોવાહનું પર્વ છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ફારુને તેઓને કહ્યું, “જેમ હું તમને અને તમારાં સર્વ બાળકોને મિસરમાંથી જવા દઈશ. ઈશ્વર તમારી સાથે રહો. જો કે મને તો એવું લાગે છે કે તમે કપટ વિચારી રહ્યા છો. ");
INSERT INTO guj2017_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ના, બધાં જ નહિ, પણ તમારામાંથી માત્ર પુખ્ત પુરુષો જ યહોવાહનું ભજન કરવા જાઓ. બાકીનાં જઈ શકશે નહિ.” પછી ફારુને મૂસા અને હારુનને ત્યાંથી કાઢી મૂક્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","પછી યહોવાહે મૂસાને કહ્યું, “મિસર દેશ પર તારો હાથ ઊંચો કર એટલે તમામ ભૂમિ પર તીડો છવાઈ જશે. એ તીડો કરાથી બચી ગયેલાં તમામ વૃક્ષો અને છોડવાઓને અને અન્ય વનસ્પતિને ખાઈ જશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","મૂસાએ પોતાની લાકડીને મિસર દેશ પર ઊંચી કરી. યહોવાહે તે આખો દિવસ અને આખી રાત દરમ્યાન પૂર્વ તરફથી પવનનો મારો ચલાવ્યો અને સવાર થતાં સુધીમાં તો પૂર્વથી આવતો તોફાની પવન તીડોનાં ટોળેટોળાં લઈ આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","સમગ્ર મિસર પર તીડો પથરાઈ ગયાં અને આખા દેશની ભૂમિ પર બેસી ગયાં. આવાં તીડોનાં ટોળાં અગાઉ કદી આવ્યાં નહોતાં અને ભવિષ્યમાં કદાપિ આવશે પણ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ઢગલાબંધ તીડો ભૂમિ પર છવાઈ ગયાં. તેઓથી ભૂમિ ઢંકાઈ ગઈ. કરાથી સમગ્ર મિસર દેશના જે વૃક્ષો અને વનસ્પતિ બચી ગયાં હતાં તેના પરનાં બધાં જ ફળ તીડો ખાઈ ગયાં. સમગ્ર મિસર દેશનાં લીલાં વૃક્ષો અને અન્ય વનસ્પતિ નામશેષ થઈ ગયાં. ખેતરમાંનાં વૃક્ષો કે વનસ્પતિ પર એકે પાંદડું રહ્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","પછી ફારુને ઉતાવળ કરીને મૂસા અને હારુનને બોલાવીને કહ્યું, “મેં તમારા ઈશ્વર પ્રભુ અને તમારી વિરુદ્ધ પાપ કર્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","આટલી વખત આ મારો અપરાધ માફ કરો અને તમારા ઈશ્વર યહોવાહને વિનંતી કરો તે મને તીડોના ત્રાસમાંથી અને મોત જેવી હાલતમાંથી બચાવે. ");
INSERT INTO guj2017_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","મૂસા ફારુનની પાસેથી વિદાય થયો. અને તેણે યહોવાહને પ્રાર્થના કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","એટલે યહોવાહે પવનની દિશા બદલી નાખી; અને પશ્ચિમમાંથી ભારે તોફાની પવન ફુંકાવા લાગ્યો. એ પવને તીડોને ઉડાડીને રાતા સમુદ્રમાં નાખી દીધાં. સમગ્ર મિસરમાં એક પણ તીડ રહ્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","પરંતુ યહોવાહે ફારુનને વળી પાછો હઠાગ્રહી બનાવ્યો. અને તેણે ઇઝરાયલીઓને જવા ન દીધા. ");
INSERT INTO guj2017_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","પછી યહોવાહે મૂસાને કહ્યું, “તારા હાથ આકાશ તરફ ઊંચા કર. મિસર દેશમાં ગાઢ અંધકાર વ્યાપી જશે. માણસોએ અંધારામાં અટવાવું પડશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","એટલે મૂસાએ આકાશ તરફ હાથ ઊંચો કર્યો. ત્યારે પ્રગાઢ અંધકારને લીધે મિસર દેશમાં ઘોર અંધારું છવાઈ ગયું. મિસરમાં ત્રણ દિવસ સુધી અંધકાર છવાયેલો રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","કોઈ પણ વ્યક્તિ બીજા કોઈને જોઈ શકતી ન હતી. અને ત્રણ દિવસ સુધી કોઈ પોતાની જગ્યાએથી ઊઠી શક્યું નહિ. પરંતુ આશ્ચર્યની વાત એ હતી કે જ્યાં ઇઝરાયલીઓના વસવાટ હતો તે સર્વ ઘરોમાં તો પ્રકાશ ઝગમગી રહ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ફારુને ફરીથી મૂસાને બોલાવ્યો અને કહ્યું, “તમે લોકો જાઓ, યહોવાહનું ભજન કરો. તમે તમારી સાથે તમારાં બાળકોને પણ લઈ જઈ શકો છો. ફક્ત તમારાં ઘેટાંબકરાં અને અન્ય જાનવરોને અહીં રહેવા દેજો.” ");
INSERT INTO guj2017_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","પણ મૂસાએ કહ્યું, “અમે અમારાં ઘેટાંબકરાં સહિત જાનવરોને અમારી સાથે લઈ જઈશું; એટલું જ નહિ પરંતુ જ્યારે અમે લોકો જઈશું ત્યારે તારે અમને દહનીયાર્પણો માટેનાં અર્પણો પણ આપવાં પડશે. અને અમે લોકો એ અર્પણો ઈશ્વર યહોવાહને ચઢાવીશું. ");
INSERT INTO guj2017_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","અમે લોકો અમારાં જાનવરો અમારી સાથે અમારા ઈશ્વર યહોવાહનું ભજન કરવા માટે લઈ જઈશું. ખરીવાળું એક પણ પશુ અહીં રહેશે નહિ. અમારાં પશુઓમાંથી અમે અમારા ઈશ્વર યહોવાહને યજ્ઞ ચઢાવવાના છીએ અને જ્યાં સુધી અમે નિયત જગ્યાએ પહોંચીએ નહિ ત્યાં સુધી અમને કેવી રીતે ખબર પડે કે અમારે યહોવાહને શું અર્પણ કરવાનું છે?” તેથી બધાં જ જાનવરોને અમે અમારી સાથે લઈ જઈશું.” ");
INSERT INTO guj2017_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","યહોવાહે વળી પાછાં ફારુનને હઠાગ્રહી બનાવ્યો, તેથી ફારુને તેઓને જવા દેવા માટે ના પાડી દીધી. ");
INSERT INTO guj2017_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","અને ફારુને મૂસાને કહ્યું, “મારી પાસેથી જતો રહે, મારું મુખ હવે પછી ફરીથી તું જોવા આવીશ નહિ. એમ છતાં જો તું મને મળવા આવીશ તો તે દિવસે તું માર્યો જશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","પછી મૂસાએ ફારુનને કહ્યું, “તું જે કહે છે તે સાચું છે. હું ફરીથી કદી તને રૂબરૂ મળવા આવવાનો નથી અને તારું મુખ જોવાનો નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ત્યારે યહોવાહે મૂસાને કહ્યું, “ફારુન અને મિસર પર હું બીજી એક આફત લાવીશ. ત્યાર પછી તે તમને અહીંથી જવા દેશે; તે કોઈને અહીં રહેવા નહિ દે; બધાને મોકલી દેશે. ");
INSERT INTO guj2017_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","તમે ઇઝરાયલીઓને કહેજો કે; ‘પ્રત્યેક પુરુષ પોતાના પડોશી પાસેથી અને પ્રત્યેક સ્ત્રી પોતાની પડોશણ પાસેથી સોનાચાંદીના ઘરેણાં માગી લે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","પછી યહોવાહે મિસરવાસીઓના હૃદયમાં ઇઝરાયલીઓ પ્રત્યે સદભાવ ઉપજાવ્યો. ફારુનના ચાકરો અને લોકોની નજરમાં મૂસા મહાન અને આદરપાત્ર મનાયો.” ");
INSERT INTO guj2017_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","મૂસાએ લોકોને કહ્યું, “યહોવાહ એવું કહે છે કે, ‘આજે મધ્યરાત્રિએ હું મિસરમાં ફરીશ.’ ");
INSERT INTO guj2017_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","અને મિસર દેશમાંના સર્વ પ્રથમજનિત પછી તે રાજ્યાસન પર બિરાજનાર ફારુનનો પ્રથમજનિત હોય કે ઘંટીએ દળણાં દળનારી દાસીનો પ્રથમજનિત હોય તે સર્વ મૃત્યુ પામશે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","અને સમગ્ર મિસર દેશમાં અગાઉ કદી પણ થઈ ના હોય એવી ભારે રડારોળ સર્જાશે. એવું આક્રંદ ભવિષ્યમાં ફરીથી કદી થશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","પરંતુ ઇઝરાયલના કોઈ પણ મનુષ્ય કે જાનવરનું કોઈ નામ લઈ શકશે નહિ. તેઓની સામે કૂતરા પણ જીભ હલાવશે નહિ. એના પરથી તમે જાણી શકશો કે યહોવાહ મિસરીઓ તથા ઇઝરાયલપુત્રો વચ્ચે ભેદ રાખે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","પછી તમારા આ બધા જ ચાકરો મારી પાસે આવશે. મને પગે લાગશે. અને કહેશે કે, તમે તથા તમારા બધા લોકો જતા રહો. અને ત્યારપછી જ હું તો અહીંથી જવાનો છું. પછી મૂસા કોપાયમાન થઈને ફારુનની પાસેથી જતો રહ્યો.” ");
INSERT INTO guj2017_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","પછી યહોવાહે મૂસાને કહ્યું, “ફારુને તમારી વાત કેમ સાંભળી નહિ? એ માટે કે હું મિસર દેશમાં વધારે ચમત્કારો બતાવી શકું.” ");
INSERT INTO guj2017_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","તેથી મૂસાએ અને હારુને ફારુનના દેખતાં જ આ બધા ચમત્કારો કરી બતાવ્યા. અને યહોવાહે ફારુનને હઠાગ્રહી બનાવ્યો અને તેણે ઇઝરાયલીઓને પોતાના દેશની બહાર જવા દીઘા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","મૂસા અને હારુન જ્યારે મિસરમાં હતા ત્યારે યહોવાહે તેઓને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“તમારા લોકો માટે આ માસ વર્ષનો પ્રથમ માસ ગણાશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","સમગ્ર ઇઝરાયલીઓ માટે આદેશ છે કે: “આ માસના દસમા દિવસે પ્રત્યેક પુરુષે પોતાના પિતાના કુટુંબ દીઠ એક હલવાન લેવું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","અને જો કુટુંબમાં આખું એક હલવાન પૂરેપૂરું ખાઈ શકે તેટલાં માણસો ના હોય તો તેઓએ પોતાના પડોશીઓને નિમંત્રણ આપવું. અને તેઓની તથા કુટુંબની સંખ્યા પ્રમાણે હલવાન લેવું. પુરુષના આહાર પ્રમાણે હલવાન વિષે વિચારીને નક્કી કરવું.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","પસંદ કરેલ હલવાન ખોડખાંપણ વગરનો પ્રથમ વર્ષનો ઘેટો અથવા બકરો જ હોવો જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","તમારે આ હલવાનને એ જ માસના ચૌદમા દિવસ સુધી સાચવી રાખવો. તે દિવસે સંધ્યાકાળે તમામ ઇઝરાયલીઓ પોતપોતાની પાસે રાખેલા હલવાનને કાપે. ");
INSERT INTO guj2017_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","તમારે તે હલવાનોનું રક્ત લઈને જે ઘરમાં તે ખાવાનું હોય તે ઘરની બન્ને બારસાખ પર અને ઓતરંગ પર છાંટવું જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“તે જ રાત્રે તમારે હલવાનના માંસને શેકવું અને તેને બેખમીર રોટલી તથા કડવી ભાજી સાથે ખાવું.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","એ માંસ કાચું કે પાણીમાં બાફીને ન ખાવું. પગ, માથું અને આંતરડાં સાથે શેકીને ખાવું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","તે રાત્રે જ બધું માંસ ખાઈ લેવું. અને જો એમાંનું કંઈ વધે અને સવાર સુધી રહે તો તેને તમારે આગમાં બાળી મૂકવું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","તમારે તે આ રીતે જ ખાવું; તમારે પ્રવાસનાં વસ્ત્રો પહેરવાં, પગમાં પગરખાં પહેરવાં, હાથમાં લાકડી લેવી અને ઉતાવળ કરીને ખાવું. કેમ કે આ યહોવાહનું પાસ્ખા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“કેમ કે રાત્રે હું મિસરમાં ફરીશ અને આખા મિસર દેશના બધા મનુષ્યના અને પશુઓના પ્રથમજનિતોને મારી નાખીશ. મિસરના બધા દેવોને પણ હું સજા કરીશ. અને હું તેઓને બતાવીશ કે હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","પરંતુ તમારા ઘર પર છાંટવામાં આવેલું રક્ત એ ચિહ્ન રહેશે જેને હું જોઈશ એટલે તમારા ઘરને ટાળીને હું આગળ જઈશ. મિસરના લોકો પર મરકી આવશે. પણ તમારા ઘરોમાં વિનાશક મરકી આવશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","તેથી તમે લોકો આજની આ રાતનું સદા સ્મરણ કરજો અને એને યહોવાહના પાસ્ખાપર્વ તરીકે પાળજો. અને નિત્ય નિયમાનુસાર તમારા વંશજોએ પણ યહોવાહના માનમાં તેની ઊજવણી કરવી.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“આ પવિત્ર પર્વના સાત દિવસો દરમ્યાન તમારે બેખમીરી રોટલી ખાવી. પર્વના પહેલે દિવસે પોતપોતાના ઘરોમાંથી બધું જ ખમીર દૂર કરવું. અને જો કોઈ માણસ આ સાત દિવસ સુધી ખમીરવાળી રોટલી ખાય તો તેને ઇઝરાયલથી જુદો કરવામાં આવે. ");
INSERT INTO guj2017_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","આ પવિત્ર પર્વના પ્રથમ દિવસે અને અંતિમ સાતમા દિવસે પવિત્ર મેળાવડા ભરવા. એ દિવસો દરમ્યાન બીજું કોઈ કામ કરવું નહિ. માત્ર પ્રત્યેકે જરૂરિયાત મુજબ જમવાનું તૈયાર કરવાનું કામ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","તમારે બેખમીર રોટલીનું પર્વ પાળવું, કારણ કે એ જ દિવસે હું તમારા લોકોને મિસર દેશમાંથી બહાર લાવ્યો હતો. તેથી એ દિવસે તમારા વંશજોએ પરંપરા મુજબ આ વિધિ પાળવો. ");
INSERT INTO guj2017_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","પ્રથમ માસના ચૌદમા દિવસની સાંજથી માંડીને તે માસના એકવીસમા દિવસની સાંજ સુધી તમારે ખમીર વગરની રોટલી ખાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","સાત દિવસ સુધી તમારાં ઘરોમાં ખમીર હોવું જોઈએ નહિ. જો કોઈ માણસ ખમીરવાળી વાનગી ખાશે તો તેનો ઇઝરાયલની જમાતમાંથી બહિષ્કાર કરવામાં આવશે. પછી તે દેશનો વતની હોય કે પરદેશી હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ખમીરવાળી કોઈ પણ વાનગી તમારે ખાવી નહિ અને તમારાં બધાં જ ઘરોમાં તમારે ખમીર વગરની રોટલી જ ખાવી.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","તેથી મૂસાએ ઇઝરાયલના બધા જ વડીલોને એક જગ્યાએ બોલાવ્યા. અને તેઓને કહ્યું, “જાઓ, તમારા પરિવાર પ્રમાણે હલવાન લઈ આવો અને પાસ્ખાના એ બલિને કાપો. ");
INSERT INTO guj2017_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","પછી ઝુફા ડાળી લઈને તેને હલવાનના રક્તના પાત્રમાં બોળીને ઓતરંગ પર અને બન્ને બારસાખ પર તે પાત્રમાંનું રક્ત લગાડજો. અને સવાર સુધી તમારામાંથી કોઈએ ઘરમાંથી બહાર નીકળવું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","કારણ કે મિસરવાસીઓના બધા પ્રથમજનિતોનો સંહાર કરવા યહોવાહ દેશમાં ઘરેઘરે ફરશે. અને તે સમયે તેઓ તમારા ઘરની બન્ને બારસાખ પર અને ઓતરંગ પર રક્ત જોશે એટલે તે તમારું ઘર ટાળીને આગળ જશે. અને મરણના દૂતને તમારા ઘરમાં પ્રવેશીને કોઈનો સંહાર કરવા દેશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","તમે લોકો આ વિધિને સદા યાદ રાખજો. અને તમે તથા તમારા દીકરાઓ કાયમના વિધિ તરીકે પાળજો. ");
INSERT INTO guj2017_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","વળી યહોવાહે તમને જે દેશ આપવાનું વચન આપેલું છે તે દેશમાં તમે પહોંચો ત્યારે પણ તમારે આ નિયમનું પાલન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","જ્યારે તમને તમારાં સંતાનો તરફથી પૂછવામાં આવે કે, ‘આપણે આ પર્વ શા માટે પાળીએ છીએ?’ ");
INSERT INTO guj2017_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ત્યારે તમે સમજાવજો કે, ‘એ તો યહોવાહના માનમાં પાળવાનો પાસ્ખા યજ્ઞ છે,’ કારણ કે જ્યારે યહોવાહે મિસરવાસીઓનો સંહાર કર્યો, ત્યારે આપણાં ઘરોને તેમણે ઉગારી લીધાં હતાં. ત્યારે આપણા ઇઝરાયલીઓએ મસ્તક નમાવીને ભજન કર્યું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","યહોવાહે જે આદેશ મૂસાને અને હારુનને આપ્યો હતો, તે પ્રમાણે ઇઝરાયલી લોકોએ તેનો અમલ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","અને મધ્યરાત્રિએ યહોવાહે મિસર દેશના ફારુનના રાજકુંવર, જે તેના સિંહાસન પર બેસતો હતો, કેદીઓના તથા મિસર દેશમાંના સર્વ પ્રથમજનિતોનો તથા મિસરનાં સર્વ જાનવરોના પ્રથમજનિતોનો સંહાર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ત્યારે ફારુન અને તેના બધા જ સરદારો તથા બધા મિસરવાસીઓ મધરાતે જાગી ઊઠ્યા અને હચમચી ગયા. સમગ્ર મિસરમાં હાહાકાર અને વિલાપ થયો. કેમ કે જે ઘરમાં કોઈ પ્રથમજનિત માર્યો ગયો ના હોય એવું એક પણ ઘર બાકાત ન હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","તે રાત્રે ફારુને મૂસાને અને હારુનને તાકીદે બોલાવ્યા. અને તેઓને કહ્યું, “તમે અને સમગ્ર ઇઝરાયલ લોકો અમારા મિસરી લોકોમાંથી અહીંથી તાત્કાલિક વિદાય થઈ જાઓ. અને તમે જે કહ્યું હતું તે પ્રમાણે જઈને યહોવાહનું ભજન કરો. ");
INSERT INTO guj2017_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","અને તમારા કહ્યા પ્રમાણે તમે તમારાં ઘેટાંબકરાં અને અન્ય જાનવરોને પણ લઈ જાઓ. અને મને આશીર્વાદ આપો.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","વળી મિસરવાસીઓએ પણ તેઓને જલદીથી આ દેશમાંથી ચાલ્યા જવાનો આગ્રહ કર્યો. અને કહ્યું કે “અમે તો મરી ગયા!” ");
INSERT INTO guj2017_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ઇઝરાયલીઓ પાસે રોટલીના લોટમાં ખમીર નાખવાનો સમય રહ્યો નહિ તેથી તેઓએ ખમીર મેળવ્યા વિનાનો લોટ જે કથરોટોમાં હતો તેને ચાદરમાં બાંધીને ખભા પર મૂકી દીધી. ");
INSERT INTO guj2017_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","પછી જતાં પૂર્વે ઇઝરાયલીઓએ મૂસાના કહ્યા પ્રમાણે “પોતાના મિસરી પડોશીઓ પાસેથી વસ્ત્રો તથા સોનાચાંદીનાં ઘરેણાં માગી લીધાં. ");
INSERT INTO guj2017_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","યહોવાહે મિસરવાસીઓના હૃદયમાં ઇઝરાયલીઓ પ્રત્યે સદભાવ પેદા કર્યો, તેથી ઇઝરાયલીઓએ જે જે માગ્યું તે તેઓએ તેઓને આપ્યું. આમ તેઓને મિસરીઓની સંપત્તિ પ્રાપ્ત થઈ.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ઇઝરાયલીઓ મિસરના રામસેસથી સુક્કોથ આવ્યા. તેઓમાં છે લાખ પુખ્ત વયના પુરુષો હતા. તે ઉપરાંત સગીરો અને સ્ત્રીઓ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","અન્ય જાતના લોકો પણ મોટી સંખ્યામાં તેઓની સાથે હતા. વળી પુષ્કળ ઘેટાંબકરાં અને અન્ય જાનવરો પણ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","મિસરમાંથી પ્રયાણ કરતી વખતે લોટમાં ખમીર નાખવાનો સમય ન હોવાથી મિસરથી લોટની જે કણક તેઓ સાથે લાવ્યા હતા તેની બેખમીરી રોટલી બનાવી. તેઓને મિસરમાંથી ઝટપટ વિદાય થઈ જવાનું થયેલું હોવાથી તેઓથી ભાથું તૈયાર કરી શકાયું ન હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ઇઝરાયલી લોકો મિસરમાં ચારસો ત્રીસ વર્ષ સુધી રહ્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","અને ચારસો ત્રીસ વર્ષ પૂરાં થયાં તે જ દિવસે યહોવાહના આ લોકોનાં તમામ કુળો મિસરમાંથી વિદાય થયાં. ");
INSERT INTO guj2017_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","આ એક બહુ જ ખાસ રાતને લોકોએ યાદ રાખવી કે મિસર દેશમાંથી યહોવાહ તેઓને બહાર લાવ્યા તે કારણે તે રાત તેમના માનાર્થે ઇઝરાયલના સર્વ લોકોએ વંશપરંપરાગત તેને એક રાત તરીકે ઊજવવાની છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","પછી યહોવાહે મૂસાને અને હારુનને કહ્યું, “આ પાસ્ખાનો વિધિ છે. કોઈ પણ બિનઇઝરાયલી વિદેશી પાસ્ખા ખાય નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","પરંતુ ઇઝરાયલી વ્યક્તિએ મૂલ્ય ચૂકવીને ખરીદેલ અને સુન્નત કરેલ હશે તે પાસ્ખા ખાઈ શકશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","પરંતુ પરદેશમાંથી આવીને અહીં વસેલો કોઈ માણસ, પગારીદાર નોકર અથવા મજૂર તે ખાઈ શકે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“દરેક પરિવારે પાસ્ખાનું આ ભોજન પોતાના ઘરમાં જ કરવાનું છે. તેમાંનું જરાય માંસ બહાર લઈ જવું નહિ. તમારે હલવાનનું એકેય હાડકું ભાગવું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","સમગ્ર ઇઝરાયલી લોક આ પર્વને અવશ્ય પાળે અને ઊજવે. ");
INSERT INTO guj2017_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","પણ કોઈ વિદેશી તમારી સાથે રહેતો હોય, તે જો યહોવાહનું પાસ્ખાપર્વ પાળવા ઇચ્છતો હોય તો તે અને તેના ઘરના બધા પુરુષો સુન્નત કરાવે ત્યારપછી તે પાસ્ખાપર્વ પાળી શકે. તેને દેશના વતની જેવો માનવામાં આવે. પરંતુ સુન્નત કરાવ્યા વિનાના કોઈ પણ માણસે તે ખાવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","“દેશમાં વતનીઓ માટે અને તમારી સાથેના પ્રવાસી પરદેશીઓ માટેના નિયમો એક સરખા જ હોય.” ");
INSERT INTO guj2017_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ઇઝરાયલના બધા લોકોએ એમ જ કર્યુ. યહોવાહે મૂસાને અને હારુનને આજ્ઞા કરી હતી તે પ્રમાણે તેઓએ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","તે જ દિવસે યહોવાહ ઇઝરાયલી લોકોને તેઓનાં કુળો સહિત મિસર દેશમાંથી બહાર લઈ આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“તમામ ઇઝરાયલીઓએ પોતાના બધા જ પ્રથમજનિતને પવિત્ર કરવા. પરિવારમાં પ્રથમ જન્મેલા પુરુષને તથા પશુને મારે માટે પવિત્ર કરવા; તેઓ મારા છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","મૂસાએ લોકોને કહ્યું, “જે દિવસે તમે મિસરમાંથી એટલે ગુલામીના ઘરમાંથી બહાર આવ્યા તે દિવસને તમે યાદ રાખજો, યહોવાહ પોતાના પરાક્રમ વડે તમને બહાર લાવ્યા છે. તેથી તમારે ખમીરવાળી રોટલી ખાવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","આબીબ માસના આ દિવસે તમે બહાર આવ્યા છો. ");
INSERT INTO guj2017_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","અને તમારા પિતૃઓને આપેલા વચન પ્રમાણે યહોવાહ તમને દૂધ તથા મધથી રેલછેલવાળો એવા કનાનીઓ, હિત્તીઓ, અમોરીઓ, હિવ્વીઓ અને યબૂસીઓના દેશમાં લઈ જાય ત્યારે તમારે આ પ્રમાણે ભજન કરવું.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“સાત દિવસ સુધી તમારે ખમીર વગરની રોટલી ખાવી. સાતમે દિવસે ઈશ્વરનું આ પર્વ પાળવું.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","એ સાત દિવસ સુધી બેખમીરી રોટલી ખાવી. તમારા આખા પ્રદેશમાં ક્યાંય પણ ખમીરવાળી રોટલી હોવી જોઈએ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","તે દિવસે તમારે તમારાં બાળકોને કહેવું કે, ‘ઈશ્વર અમને મિસરમાંથી બહાર લાવ્યા ત્યારે યહોવાહે અમારા માટે જે કર્યુ હતું, તે માટે આ પર્વ પાળવામાં આવે છે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“આ પર્વનું પાલન તમારા હાથ પર અને તમારી આંખો વચ્ચે કપાળ પર યાદગીરીના સૂચક ચિહ્ન જેવું રહેશે. તે તમને યાદ રખાવશે તમારા મુખમાં યહોવાહનાં વચનો રહે. કેમ કે યહોવાહ તમને સામર્થ્યવાન હાથથી મિસરમાંથી બહાર લઈ આવ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","એટલા માટે તમારે આ પર્વ દર વર્ષે નિયત સમયે પાળવું અને ઊજવવું.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“યહોવાહ તમને અને તમારા પૂર્વજોને આપેલા વચન પ્રમાણે તમને કનાનીઓના દેશમાં લઈ જાય અને તે દેશ તમને આપે, ");
INSERT INTO guj2017_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ત્યારે તમારા સર્વ પ્રથમજનિતોને તથા સર્વ પશુઓનાં પ્રથમજનિતોને તમારે યહોવાહ ને માટે સમર્પિત કરવા જેથી તમામ નર પ્રથમજનિતો યહોવાહના થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","પ્રત્યેક ગધેડાના પ્રથમ બચ્ચાંને તેને બદલે એક હલવાન અર્પણ કરીને, યહોવાહ પાસેથી તે પાછું મેળવવું. અને જો તેને મેળવવાની કે છોડાવવાની તમારી મરજી ના હોય તો તેની ગરદન તમારે ભાંગી નાખવી. વળી તમારા પુત્રોમાંના સર્વ પ્રથમજનિતોને પણ તારે મૂલ્ય આપીને છોડાવવા.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ભવિષ્યમાં તમારાં બાળકો તમને પૂછે કે, ‘આનો અર્થ શો છે?’ ત્યારે તમે કહેજો કે, ‘યહોવાહ પોતાના હાથનાં સામર્થ્ય વડે અમને મિસરમાંથી, ગુલામીના દેશમાંથી બહાર લાવ્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ફારુન હઠે ચડયો હતો, તેથી તે અમને બહાર જવા દેતો ન હતો. ત્યારે યહોવાહે મિસર દેશના બધા પ્રથમજનિતને એટલે પ્રથમજનિત પુરુષોનો તથા પ્રથમજનિત નર જાનવરોનો સંહાર કર્યો હતો. તેથી પ્રથમજનિત સર્વ નર પશુઓને અમે યહોવાહને અર્પણ કરીએ છીએ, પણ અમારા પુત્રોમાંના અર્પણ કરેલા સર્વ પ્રથમજનિતોને અમે મૂલ્ય ચૂકવીને છોડાવીએ છીએ.’ ");
INSERT INTO guj2017_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","અને એ વિધિ તમારા હાથ પર ચિહ્નરૂપ તથા તમારી આંખોની વચ્ચે કપાળ પર ચાંદરૂપ બની રહેશે; કારણ કે યહોવાહ આપણને પોતાના પરાક્રમી હાથથી મિસરની બહાર લઈ આવ્યા હતા. એની આ સ્મૃતિ બની છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","જ્યારે ફારુને લોકોને જવા દીઘા ત્યારે એમ બન્યું કે પલિસ્તીઓના દેશમાં થઈને જવાનો રસ્તો ટૂંકો હોવા છતાં પણ તે રસ્તે તેઓને લઈ ગયા નહિ. કેમ કે યહોવાહે વિચાર્યું કે, “રખેને યુદ્ધ થાય અને લોકો પોતાનો વિચાર બદલી પાછા મિસર ચાલ્યા જાય.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","એટલે યહોવાહ તેઓને બીજે રસ્તે થઈને એટલે રાતા સમુદ્ર પાસેના અરણ્યના રસ્તે તેઓને લઈ ગયા. ઇઝરાયલપુત્રો શસ્ત્રસજજ થઈને મિસરમાંથી બહાર આવ્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","મૂસાએ યૂસફનાં અસ્થિ સાથે લઈ લીધાં હતાં. કેમ કે યૂસફે ઇઝરાયલપુત્રોને સોગન દઈને કહ્યું હતું કે, “યહોવાહ જરૂર તમારી મદદે આવશે, તમને અહીંથી છોડાવશે. ત્યારે તમે વિદાય થાઓ તે વખતે તમે મારાં અસ્થિ અહીંથી લઈ જજો.” ");
INSERT INTO guj2017_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","પછી ઇઝરાયલીઓએ સુક્કોથથી પ્રયાણ કરીને અને એથામમાં અરણ્યની સરહદ પર મુકામ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","દિવસે તેઓને રસ્તો બતાવવા માટે યહોવાહ મેઘસ્તંભમાં તેમ જ રાત્રે તેમને પ્રકાશ મળે તેથી અગ્નિસ્તંભમાં તેઓની આગળ ચાલતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","દિવસે મેઘસ્તંભ અને રાત્રે અગ્નિસ્તંભ તેઓની આગળથી જરા પણ ખસતા ન હતા, યહોવાહ સતત તેઓની સાથે રહેતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ઇઝરાયલી લોકોને કહે કે, પાછા ફરીને પીહાહીરોથની આગળ, મિગ્દોલ અને લાલસમુદ્રની વચ્ચે બઆલ-સફોનની આગળ સમુદ્રને કિનારે છાવણી કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","એટલે ફારુનને એવું લાગશે કે, “ઇઝરાયલીઓ અરણ્યમાં ભૂલા પડ્યા છે અને અટવાઈ ગયા છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","હું ફારુનનું હૃદય હઠીલું કરીશ, એટલે તે તમારો પીછો કરશે. પણ હું તેના લશ્કરનો પરાજય કરીને મારો મહિમા વધારીશ. ત્યારે મિસરવાસીઓ જાણશે કે, હું ઈશ્વર છું.” અને ઇઝરાયલીઓએ ઈશ્વરના કહ્યા પ્રમાણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","જ્યારે મિસરના રાજાને ખબર આપવામાં આવી કે, ઇઝરાયલી લોકો જતા રહ્યા છે. ત્યારે ફારુનનું અને તેના સરદારોનું વલણ બદલાઈ ગયું. તેઓને થયું કે, “આપણે શું કર્યુ? આપણે તેઓને કેમ જવા દીધા? આપણે આપણા ગુલામોને ગુમાવ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","એટલે ફારુને પોતાનો રથ અને લશ્કરને તૈયાર કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ફારુને પોતાના રથદળમાંથી મિસરના સૌથી શ્રેષ્ઠ છસો સરદારોને અને અન્ય રથો સહિત તેઓના સરદારોને સાથે લીધા. ");
INSERT INTO guj2017_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","યહોવાહે મિસરના રાજા ફારુનને હઠીલો બનાવ્યો, તે પોતાનું સૈન્ય લઈને નીડર ઇઝરાયલીઓની પાછળ પડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","મિસરના લશ્કરના અસંખ્ય ઘોડેસવારો તથા રથસવારો તથા અન્ય સૈનિકોએ ઇઝરાયલીઓનો પીછો કર્યો. અને તેઓ બઆલ-સફોનની આગળ પીહાહીરોથની પાસે સમુદ્ર કિનારે છાવણીમાં તેઓની નજીક આવી પહોંચ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ફારુન તેઓની નજીક આવી પહોંચ્યો, તે જોઈને ઇઝરાયલીઓને ખબર પડી કે મિસરીઓ તેઓની પાછળ પડ્યા છે! તેથી તેઓ ખૂબ ભયભીત થયા અને તેઓએ સહાય માટે યહોવાહને પોકાર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","તેઓએ મૂસાને કહ્યું, “તું અમને શા માટે મિસરમાંથી બહાર લાવ્યો છે? શું મિસરમાં કબરો નહોતી? તું તો અમને આ રણપ્રદેશમાં મરવા માટે લાવ્યો છે. શાંતિપૂર્વક મૃત્યુ પામવા અમારે માટે મિસરમાં ઘણી કબરો હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","અમે મિસરમાં જ તને નહોતું કહ્યું કે, ‘અમને લોકોને અમે જેમ છીએ તેમ રહેવા દે, મિસરવાસીઓની સેવા કરવા દે? અમારે માટે અહીં અરણ્યમાં મરવા કરતાં મિસરવાસીઓની ગુલામી કરવી એ વધારે સારું હતું.” ");
INSERT INTO guj2017_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","પરંતુ મૂસાએ લોકોને આશ્વાસન આપ્યું, “ગભરાશો નહિ. જ્યાં છો ત્યાં જ મક્કમતાપૂર્વક ઊભા રહો અને જુઓ કે આજે યહોવાહ તમારો કેવી અજાયબ રીતે બચાવ કરે છે! જે મિસરવાસીઓને તમે અત્યારે જુઓ છો તેઓ હવે પછી ક્યારેય તમને દેખાશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","તમારે તો આંગળી પણ અડાડવાની નથી; માત્ર જોયા કરવાનું છે. યહોવાહ તમારે માટે યુદ્ધ કરશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","પછી યહોવાહે મૂસાને કહ્યું, “મને પોકારો કરવાની શી જરૂર છે? ઇઝરાયલી લોકોને કહે કે આગળ કૂચ કરે, પ્રવાસ ચાલુ રાખે. ");
INSERT INTO guj2017_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","તું તારી લાકડીને રાતા સમુદ્ર પર ઊંચી કર. તારો હાથ સમુદ્ર ઉપર લંબાવ અને સમુદ્ર બે ભાગ થઈ જશે. ઇઝરાયલ લોકો સમુદ્રની કોરી જમીન પર થઈને સમુદ્ર પાર કરશે. ");
INSERT INTO guj2017_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","પછી હું મિસરવાસીઓને હઠીલા અને આવેશી બનાવીશ. એટલે તેઓ તમારા પર સમુદ્ર તરફ ધસી આવશે. ફારુનને, તેના રથસવારો, ઘોડેસવારો અને સમગ્ર સૈન્યને હું નષ્ટ કરીશ. તેઓ મારું ગૌરવ નિહાળશે. ");
INSERT INTO guj2017_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ત્યારે ફારુન અને તેના સૈન્ય સહિત સમગ્ર મિસરવાસીઓને ખબર પડશે કે હું યહોવાહ છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","પછી ઇઝરાયલી સૈન્યની આગળ ચાલતો યહોવાહનો જે દૂત હતો તે ત્યાંથી ખસીને તેઓની પાછળ ગયો, તેથી મેઘસ્તંભ પણ તેઓની આગળથી ખસીને તેઓની પાછળ થંભ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","આ રીતે મેઘસ્તંભ મિસરીઓના સૈન્ય અને ઇઝરાયલીઓના સૈન્યની વચ્ચે આવીને થંભ્યો. ત્યારે વાદળો અને અંધકાર હોવા છતાં મેઘસ્તંભ પણ રાત્રે ઇઝરાયલીઓને પ્રકાશ આપતો હતો. મિસરની સેના માટે સમગ્ર રાત્રી દરમિયાન અંધકાર હોવાને લીધે તે ઇઝરાયલીઓ પાસે આવી શકી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","મૂસાએ પોતાનો હાથ લાલ સમુદ્ર પર ઊંચો કરીને લંબાવ્યો, એટલે યહોવાહે આખી રાત પૂર્વ તરફથી ભારે પવન ફૂંકાવીને સમુદ્રને પાછો હઠાવ્યો, તેથી તેના પાણીના બે ભાગ પડી ગયા. અને સમુદ્રની જગ્યાએ કોરી જમીન બનાવી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ઇઝરાયલી લોકો કોરી જમીન પર ચાલીને સમુદ્રમાં થઈને પાર ગયા. તેઓની ડાબી અને જમણી બાજુએ પાણીની દીવાલો બની ગઈ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","મિસરીઓ તેઓની પાછળ પડયા. ફારુનના બધા જ રથસવારો, ઘોડેસવારો તથા અન્ય સૈનિકો તેઓની પાછળ સમુદ્રની વચ્ચે પહોંચી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","પછી પ્રભાતના પ્રથમ પહોરમાં અગ્નિસ્તંભ તથા મેઘસ્તંભમાંથી યહોવાહે મિસરીઓના સૈન્ય પર નજર કરી. તેઓના પર હુમલો કર્યો. તેઓનો પરાજય કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","યહોવાહે તેઓના રથનાં પૈડાં જમીનમાં એવા ખુંપાવી દીધાં કે તે ફરી શકતાં ન હતાં. આથી મિસરના સૈનિકો બૂમ પાડવા લાગ્યા, “આ તો યહોવાહ પોતે ઇઝરાયલીઓને પક્ષે આપણી સામે લડી રહ્યા છે. ચાલો, આપણે પાછા જતા રહીએ.” ");
INSERT INTO guj2017_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","પછી યહોવાહે મૂસાને કહ્યું, “હવે તું તારો હાથ સમુદ્ર પર ઊંચો કરીને લંબાવ. જેથી મિસરવાસીઓ પર, તેમના રથસવારો પર અને તેઓના ઘોડેસવારો પર પાણી ફરી વળે.” ");
INSERT INTO guj2017_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","એટલે તે પરોઢ થવાના સમયે મૂસાએ સમુદ્ર પર હાથ લંબાવ્યો ત્યારે સમુદ્ર પોતાની અસલ સ્થિતિમાં પાછો આવી ગયો. મિસરના સૈન્યએ સમુદ્રમાં નાસભાગ કરવા માંડી પણ યહોવાહે તેઓને સમુદ્રમાં વચ્ચોવચ્ચ ડુબાવી માર્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","સમુદ્રના પાણીએ પાછાં વળીને રથસવારોને, ઘોડેસવારોને અને ફારુનના સમગ્ર સૈન્યને ડુબાડી દીધું. તેઓમાંથી કોઈ બચી શક્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","પરંતુ ઇઝરાયલના લોકો તો સમુદ્રની વચ્ચેથી કોરી ભૂમિ પર થઈને પસાર થઈ ગયા. તેઓની ડાબી અને જમણી બાજુએ પાણીની ભીંતો થઈ ગઈ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","આ રીતે તે દિવસે યહોવાહે ઇઝરાયલીઓને મિસરીઓના હાથમાંથી બચાવી લીધા. અને ઇઝરાયલીઓએ સમુદ્ર કિનારે મિસરીઓના મૃતદેહો પડેલા જોયા. ");
INSERT INTO guj2017_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","અને યહોવાહે મિસરીઓ વિરુદ્ધ જે પરાક્રમ કર્યું હતું તે જોઈને ઇઝરાયલીઓ ગભરાઈ ગયા અને યહોવાહ પર અને તેના સેવક મૂસા પર તેઓએ વિશ્વાસ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","પછી મૂસાએ અને ઇઝરાયલના લોકોએ યહોવાહની સમક્ષ આ સ્તુતિગાન ગાયું: “હું યહોવાહની સમક્ષ ગાયન કરીશ, તેમણે મહાન વિજય પ્રાપ્ત કર્યો છે. તેમણે ઘોડા અને સવારોને સમુદ્રમાં ડુબાડી દીધા છે; ");
INSERT INTO guj2017_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","યહોવાહ મારું સામર્થ્ય અને ગીત છે; તે મારો ઉદ્ધાર થયા છે. આ મારા ઈશ્વર છે અને હું તેમની સ્તુતિ કરીશ. મારા પૂર્વજોના ઈશ્વર, હું તેમને મહાન માનું છું. ");
INSERT INTO guj2017_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","યહોવાહ તો યોદ્ધા છે, તેમનું નામ યહોવાહ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","તેમણે ફારુનનાં રથદળોને સમુદ્રમાં ડુબાડી દીધા; અને તેના માનીતા સરદારોને પણ સૂફ સમુદ્રમાં ડુબાડી દીઘા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","પાણીના પ્રવાહો તેઓના પર ફરી વળ્યા છે. તેઓ પથ્થરની માફક છેક તળિયે ડૂબી ગયા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","હે યહોવાહ! તમારો જમણો હાથ, પરાક્રમે મહિમાવાન છે. હે યહોવાહ! તમારો જમણો હાથ શત્રુઓને પછાડીને તેમના ચૂરા કરે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","તમારી સામે થનારને તમે તમારી શ્રેષ્ઠતાના માહાત્મ્યથી પાયમાલ કરો છો. તમે તમારા ભયાનક કોપથી તેઓને ઘાસના પૂળાની જેમ બાળી નાખો છો. ");
INSERT INTO guj2017_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","હે યહોવાહ, તમારા ઉચ્છવાસથી પાણીના; અને મોજાંઓ અટકીને તેમના જાણે ઊંચા ટેકરા બની ગયા. અને દરિયાના ઊંડાણમાં જળના પ્રવાહો ઠરી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","શત્રુએ સંકલ્પ કર્યો કે, ‘હું પાછળ પડીશ, અને હું તેઓનું ધન લૂંટી લઈશ. હું મારી તલવાર ઉગામીશ. અને મારે હાથે તેઓનો નાશ કરીશ.’ ");
INSERT INTO guj2017_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","પરંતુ હે યહોવાહ! તમે તમારો પવન ફૂંક્યો. અને સમુદ્રના પાણી તેઓ પર ફરી વળ્યાં. તેઓ સીસાની માફક સમુદ્રના મહાજળમાં ડૂબી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","હે યહોવાહ, તમારા જેવા અન્ય કોઈ ઈશ્વર નથી? તમારા જેવા પરમપવિત્ર, મહિમાવાન; સ્તોત્રોમાં ભયજનક અને પરાક્રમી બીજા કોણ છે? ");
INSERT INTO guj2017_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","અને પૃથ્વી તેઓને તત્કાળ ગળી ગઈ, તમે કેવળ જમણો હાથ ઊંચો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","તમે તમારા લોકોને છોડાવ્યા. તમારા પ્રેમ અને કરુણાથી તમારા સામર્થ્ય વડે તમે તેઓને; તમારા પવિત્ર નિવાસમાં દોરી લાવ્યા છો. ");
INSERT INTO guj2017_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","પ્રજા આ સાંભળીને કંપે છે, સર્વ પલિસ્તી વાસીઓ પીડા પામ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","તે સમયે અદોમના સરદારો આશ્ચર્યચકિત થયા, મોઆબના શક્તિશાળી અને પરાક્રમી પુરુષોને ધ્રૂજારી થઈ; અને બધા કનાનવાસીઓનાં ગાત્રો શિથિલ થઈ ગયાં; ");
INSERT INTO guj2017_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","તેઓ ઉપર ભય અને ત્રાસ આવી પડયા, અને તમે મુક્ત કરેલા લોકો જ્યાં સુધી નિશ્ચિત સ્થાને ન પહોંચો;, અને તેઓની મુસાફરી પૂરી ન થાય ત્યાં સુધી યહોવાહ, તમારા ભુજના સામર્થ્યથી તેઓ પથ્થર જેવા સ્તબ્ધ થઈ ગયા, ");
INSERT INTO guj2017_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","હે પ્રભુ જયાં તમારો આવાસ છે અને જે પવિત્રસ્થાન તમે સ્થાપિત કર્યું છે; એટલે તમારા પવિત્ર પર્વતમાં તેઓને લાવીને તમે તેઓને ત્યાં સ્થાયી વસાવવાના છો. ત્યાં તમે તમારું ભક્તિસ્થાન બાંધશો. ");
INSERT INTO guj2017_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","હે યહોવાહ, તમે સદાસર્વકાળ સુધી રાજ્ય કરવાના છો.” ");
INSERT INTO guj2017_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ખરેખર એવું બન્યું કે, જ્યારે ફારુનના ઘોડેસવારો, રથો અને તેઓના સવારોએ સમુદ્રમાં પ્રવેશ કર્યો, ત્યારે યહોવાહે સમુદ્રનાં પાણી પાછાં વાળીને તેઓ પર ફેરવી વાળ્યાં; પરંતુ ઇઝરાયલી લોકો તો સમુદ્ર મધ્યે થઈને કોરી જમીન પર ચાલીને પસાર થઈ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","પછી હારુનની બહેન મરિયમ પ્રબોધિકાએ ખંજરી હાથમાં લીધી અને તમામ સ્ત્રીઓ તેની પાછળ પાછળ ખંજરીઓ વગાડતાં અને નાચતાં નાચતાં તેની પાછળ ચાલી. મરિયમે અને સ્ત્રીઓએ નાચગાન શરૂ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","મરિયમે તેઓને ગવડાવ્યું, “ઈશ્વરની આગળ ગાયન કરો, કેમ કે તેમણે ગૌરવી વિજય પ્રાપ્ત કર્યો છે, તેમણે ઘોડા અને તેના સવારોને સમુદ્રના ઊંડાણમાં ડુબાડી દીધા છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","પછી મૂસા ઇઝરાયલી લોકોને રાતા સમુદ્રથી આગળ લઈ ગયો. અને તેઓ ત્યાંથી નીકળીને શૂરના અરણ્યમાં આવ્યા; તેઓ ત્યાં ત્રણ દિવસ એ અરણ્યમાં આગળ ચાલતા રહ્યા. ત્યાં તેઓને પાણી મળ્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","પછી તેઓ ‘મારાહ’ નામની જગ્યાએ આવી પહોંચ્યા. પણ ત્યાંનાં પાણી પી શક્યા નહિ, કેમ કે તે કડવાં હતાં. તેથી એ જગ્યાનું નામ ‘મારાહ’ પડયું. ");
INSERT INTO guj2017_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","તેથી બધા લોકોએ મૂસાની વિરુદ્ધ બબડાટ કર્યો કે, “અમે શું પીઈએ?” ");
INSERT INTO guj2017_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","એટલે મૂસાએ યહોવાહને પ્રાર્થના કરી, એટલે યહોવાહે તેને એક વૃક્ષનું થડ બતાવ્યું. મૂસાએ તેને પાણીમાં નાખ્યું અને પાણી મીઠાં થઈ ગયાં. ત્યાં યહોવાહે તેઓની કસોટી કરી. તેઓને માટે વિધિ તથા એક નિયમ ઠરાવ્યો. અને ત્યાં જ તેમની કસોટી કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","યહોવાહે કહ્યું, “જો તમે તમારા ઈશ્વર યહોવાહની વાણી કાળજીથી સાંભળશો અને જે સત્ય છે તેને પાળશો તો મેં મિસરીઓ પર જે રોગચાળો ફેલાવ્યો હતો તેમાંનો કોઈ હું તમારા પર મોકલીશ નહિ. કેમ કે તમારા રોગ મટાડનાર હું તમારો ઈશ્વર યહોવાહ છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","પછી તેઓ એલીમ આવી પહોંચ્યા, ત્યાં પાણીના બાર ઝરા હતા અને સિત્તેર ખજૂરીઓ હતી, અહીં જ્યાં પાણી હતું તે જગ્યાએ તેઓએ છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ઇઝરાયલીઓએ એલીમથી પોતાની મુસાફરી શરૂ કરી. તેઓ મિસરમાંથી બહાર આવ્યા પછી બીજા માસને પંદરમે દિવસે એલીમ અને સિનાઈની વચ્ચે આવેલા સીનના અરણ્યમાં આવી પહોંચ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","અહીં બધા ઇઝરાયલી લોકોએ આખા અરણ્યમાં મૂસા અને હારુનની વિરુદ્ધ બબડાટ કર્યે રાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ઇઝરાયલીઓએ મૂસા અને હારુનને કહ્યું, “જ્યારે અમે માંસથી ભરેલાં વાસણ પાસે બેસીને ધરાતાં સુધી ખાતા હતા, ત્યારે જ જો યહોવાહે પોતાને હાથે અમને મિસરમાં મારી નાખ્યા હોત તો સારું થાત. એવું થયું હોત તો આ અરણ્યમાં અમને બધાને ભૂખે મરવાનો વારો આવ્યો હોત નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ત્યારે યહોવાહે મૂસાને કહ્યું, “હું તમારે માટે રોટલીનો વરસાદ વરસાવીશ. આ બધા લોકોએ દરરોજ બહાર આવીને તેમાંથી તે દિવસ પૂરતી રોટલી પોતાને માટે ભેગી કરી લે; જેથી તેઓ મારા કાનૂન અનુસાર ચાલશે કે નહિ તે વિષે હું તેઓની પરીક્ષા કરું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","લોકો દરરોજ તે દિવસ પૂરતી જ રોટલીનો સંગ્રહ કરે, પરંતુ છઠ્ઠા દિવસે રોજ કરતાં બમણી રોટલી ભેગી કરે અને પોતાના સ્થળે રાંધે.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","અને મૂસા અને હારુને ઇઝરાયલી લોકોને કહ્યું, “આજે રાત્રે તમે યહોવાહની શક્તિ જોશો, અને તમને ખબર પડશે કે મિસર દેશમાંથી તમને બચાવીને બહાર લાવનાર તે ઈશ્વર તો યહોવાહ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","કાલે સવારે તમે લોકો યહોવાહનું ગૌરવ જોશો કારણ કે તેમણે તેઓની વિરુદ્ધની તમારી ફરિયાદ કાને ધરી છે, તમે હમેશાં અમને ફરિયાદ કરો છો, પણ અમે એમાં શું કરી શકીએ?” ");
INSERT INTO guj2017_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","પછી મૂસાએ કહ્યું, “યહોવાહ, સાંજે તમને ખાવા માટે માંસ આપશે અને સવારે ઘરાઈને ખાઓ એટલી રોટલી આપશે. કારણ કે તમે તેમની વિરુદ્ધ જે ફરિયાદો કરો છો તે તેમણે સાંભળી છે. તમારી ફરિયાદ અમારી વિરુદ્ધ નથી, પણ યહોવાહની વિરુદ્ધ છે. અમે તે વળી કોણ?” ");
INSERT INTO guj2017_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","પછી મૂસાએ હારુનને કહ્યું, તું ઇઝરાયલી લોકોને કહે કે, ‘તમે યહોવાહની સમક્ષ આવો. કારણ કે તેમણે તમારી ફરિયાદો સાંભળી છે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ઇઝરાયલનો સમગ્ર સમુદાય એક જ સ્થાને ભેગો થયો હતો. ત્યારે હારુન તેઓની સાથે વાત કરતો હતો. તે દરમિયાન તેઓએ અરણ્ય તરફ જોયું, તો વાદળમાં યહોવાહના ગૌરવનું દર્શન થયું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“મેં ઇઝરાયલના લોકોની ફરિયાદ સાંભળી છે; તેઓને કહે કે, ‘સાંજે તમે માંસ ખાશો અને સવારે તમે ઘરાઈને રોટલી ખાશો;’ અને તમને ખાતરી થશે કે હું તમારો ઈશ્વર યહોવાહ છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","તે રાત્રે એવું બન્યું કે લાવરીઓએ ઊડી આવીને છાવણીને ભરી દીધી; સવારમાં છાવણીની આસપાસ ઝાકળ પડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","સૂરજ ઊગતાં ઝાકળ ઊડી ગયું અને હિમના જેવો બારીક નાનો પદાર્થ અરણ્યની સપાટી પર પડેલો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ઇઝરાયલી લોકો એ જોઈને પરસ્પર પૂછવા લાગ્યા, “એ શું છે?” કેમ કે તેઓ આ પદાર્થ વિષે જાણતા નહોતા. ત્યારે મૂસાએ તેઓને કહ્યું, “એ તો યહોવાહે તમને ખાવા માટે આપેલો ખોરાક છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","યહોવાહની એવી આજ્ઞા છે કે, ‘તમે પ્રત્યેક જણ પોતાના આહાર જેટલું ભેગું કરી લો. તમારે તમારા કુટુંબના માણસોની સંખ્યા પ્રમાણે તમારા તંબુમાં રહેનારા માટે વ્યક્તિ દીઠ એક ઓમેર જેટલું તે લેવું.’ ");
INSERT INTO guj2017_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","અને ઇઝરાયલી લોકોએ એ પ્રમાણે કર્યું. પણ તેમાંના કેટલાકે વધારે તો કેટલાકે ઓછું ભેગું કરી લીધું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","અને પછી તેઓએ ઓમેરના માપિયાથી માપ્યું ત્યારે જેણે વધુ લીધું હતું તેને વધી પડ્યું નહિ અને જેણે ઓછું ભેગું કર્યુ હતું તેને ખૂટ્યું નહિ. પ્રત્યેક માણસથી પોતાના આહાર પૂરતું જ એકઠું કરાયું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","મૂસાએ તેઓને કહ્યું, “તમારામાંથી કોઈએ તેમાંથી સવારને માટે રાખી મૂકવું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","પરંતુ કેટલાકે મૂસાનું કહ્યું માન્યું નહિ. તેઓએ તેમાંથી થોડુંઘણું સવારને માટે રાખ્યું તો સવારે તેમાં કીડા પડેલા હતા. અને તે ગંધાઈ ઊઠયું. તેથી મૂસા તેમના પર ગુસ્સે થયો. ");
INSERT INTO guj2017_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","રોજ સવારે પ્રત્યેક જણ પોતાના આહાર જેટલો ખોરાક ભેગો કરતો હતો અને સૂર્ય તપતો ત્યારે જે વધ્યું હોય તે બધું ઓગળી જતું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","અઠવાડિયાનાં છઠ્ઠે દિવસે તેઓએ બમણો એટલે વ્યક્તિ પ્રમાણે બે ઓમેર જેટલો ખોરાક ભેગો કર્યો. પછી સમુદાયના બધા આગેવાનોએ આવીને મૂસાને તે વિષે જણાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","મૂસાએ તેઓને કહ્યું, યહોવાહની એ આજ્ઞા છે કે, “આવતી કાલે વિશ્રામ એટલે યહોવાહનો પવિત્ર વિશ્રામવારનો દિવસ છે; તેથી તમારે જે રાંધવું હોય તે રાંધી લો, અને જે વધે તે તમારા માટે સવાર સુધી રાખી મૂકો.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","આથી મૂસાની આજ્ઞા પ્રમાણે તેઓએ તેમાંથી સવારને માટે રાખી મૂકયું, પણ તેમાં કીડા પડયા નહિ અને તે ગંધાઈ ઊઠ્યું પણ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","અને મૂસાએ કહ્યું, “આજે તે ખાઓ, કારણ કે આજે વિશ્રામવાર છે, યહોવાહનો દિવસ છે; આજે તે તમને ખેતરમાં મળશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","સપ્તાહના છે દિવસ તમે એ ભેગું કરો; પણ સાતમો દિવસ વિશ્રામવારનો છે, તેમાં તમને કંઈ મળશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","સાતમા દિવસે કેટલાક લોકો તે ભેગું કરવા માટે બહાર ગયા, પણ તેમને કંઈ મળ્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ત્યારે યહોવાહે મૂસાને કહ્યું, “કયાં સુધી તમે મારી આજ્ઞાઓ અને નિયમોનું પાલન કરવાનો ઇનકાર કરશો?” ");
INSERT INTO guj2017_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","જુઓ, યહોવાહે તમને વિશ્રામવાર આપ્યો છે, તેથી છઠ્ઠે દિવસે તે તમને બે દિવસ ચાલે તેટલો ખોરાક આપશે, એટલે સાતમે દિવસે તેઓએ દરેકે પોતપોતાના નિવાસમાં જ રહેવું અને બહાર નીકળવું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","તેથી તે લોકોએ સાતમે દિવસે વિશ્રામ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ઇઝરાયલી લોકોએ તે વિશિષ્ટ ખોરાકનું નામ “માન્ના” પાડ્યું. માન્ના ધાણાના દાણા જેવું સફેદ હતું. તેનો સ્વાદ મધ ચોપડેલી પાતળી પૂરીના જેવો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ત્યારે મૂસાએ કહ્યું, “યહોવાહે તમને આદેશ આપ્યો છે કે, ‘તમારા વંશજોને માટે તેમાંથી એક ઓમેર જેટલું માન્ના રાખી મૂકો; જેથી હું તમને મિસરમાંથી બહાર લઈ આવ્યો ત્યારે મેં તમને લોકોને જે ભોજન ખવડાવ્યું હતું તે તેઓ જોઈ શકે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","પછી મૂસાએ હારુનને કહ્યું કે, “એક વાસણ લઈને તેમાં એક ઓમેર માન્ના ભરીને તમારા વંશજોને માટે સાચવી રાખવા સારુ તેને યહોવાહની સમક્ષ મૂકો.” ");
INSERT INTO guj2017_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","યહોવાહે મૂસાને આજ્ઞા આપ્યા મુજબ હારુને તેને સાચવી રાખવા માટે કરારકોશ આગળ તેને મૂક્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","પછી ત્યાંથી ઇઝરાયલી લોકો વસવાટ કરવા યોગ્ય પ્રદેશમાં આવ્યા, એ દરમિયાન તેઓએ તે માન્ના ખાધું. તેઓ કનાન દેશની સરહદમાં પહોંચ્યા ત્યાં સુધી તેઓએ માન્ના ખાધું. ");
INSERT INTO guj2017_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","માન્નાના માપ માટે વપરાતા પાત્રમાં એક ઓમેર માન્ના સમાતું હતું. એક ઓમેર એટલે એફાહનો દસમો ભાગ. ");
INSERT INTO guj2017_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ઇઝરાયલના લોકોની સમગ્ર જમાતે સીનના રણમાંથી છાવણી ઉઠાવીને યહોવાહની આજ્ઞા મુજબ આગળ પ્રયાણ કરીને રફીદીમમાં મુકામ કર્યો. પરંતુ ત્યાં લોકોને પીવા માટે પાણી દુર્લભ હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","તેથી લોકોએ મૂસા સાથે તકરાર કરી અને કહ્યું, “અમને પીવા માટે પાણી આપ.” એટલે મૂસાએ તેઓને કહ્યું, “તમે લોકો મારી સાથે શા માટે તકરાર કરો છો? તમે યહોવાહની કસોટી શા માટે કરો છો?” તમે એમ સમજો છો કે ઈશ્વર આપણી સાથે નથી?” ");
INSERT INTO guj2017_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","પરંતુ લોકો બહુ તરસ્યા હતા. તેથી તેઓએ મૂસા વિરુદ્ધ બડબડાટ કરતાં કહ્યું કે, “તું અમને, અમારાં સ્ત્રી, બાળકોને અને જાનવરોને તરસે મારવા શા માટે મિસર દેશમાંથી અહીં લઈ આવ્યો?” ");
INSERT INTO guj2017_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","આથી મૂસાએ યહોવાહને યાચના કરી, “આ લોકોને માટે હું શું કરું? તેઓ મને પથ્થરે મારી નાખવા તૈયાર થયા છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","યહોવાહે મૂસાને કહ્યું, “જા, ઇઝરાયલના કેટલાક વડીલોને સાથે લઈને તું લોકોની આગળ ચાલતો થા. જે લાકડીથી તેં નીલ નદી પર પ્રહાર કર્યો હતો તે તારા હાથમાં રાખજે. ");
INSERT INTO guj2017_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","જો, હોરેબ પર્વતના એક ખડક ઉપર હું તારી સામે ઊભો રહીશ, પછી તું તે ખડક પર પ્રહાર કરજે, એટલે તે ખડકમાંથી પાણી નીકળશે, જેથી લોકોને પીવા પાણી મળશે.” ઇઝરાયલના વડીલોના દેખતાં મૂસાએ તે મુજબ કર્યુ. એટલે ત્યાં પાણીનું વહેણ થયું. ");
INSERT INTO guj2017_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","મૂસાએ તે જગ્યાનું નામ માસ્સાહ અને મરીબાહ રાખ્યું. કારણ કે આ એ જ જગ્યા હતી જ્યાં ઇઝરાયલના લોકો એની વિરુદ્ધ થયા હતા. અને તેઓએ યહોવાહની કસોટી કરી હતી, તે લોકો જાણવા માગતા હતા કે યહોવાહ અમારી વચ્ચે છે કે નહિ? ");
INSERT INTO guj2017_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","અમાલેકીઓએ રફીદીમ આગળ આવીને ઇઝરાયલીઓ પર હુમલો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","પછી મૂસાએ યહોશુઆને કહ્યું કે, “તું આપણામાંથી જોઈતા માણસો પસંદ કરી લે. આવતી કાલે અમાલેકીઓ સામે યુદ્ધ કર. હું ઈશ્વરની લાકડી મારા હાથમાં લઈને પર્વતના શિખર પર ઊભો રહીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","યહોશુઆએ મૂસાની આજ્ઞાનો સ્વીકાર કર્યો. તે અમાલેકીઓ સામે જંગે ચડયો. મૂસા તથા હારુન અને હૂર પર્વતના શિખર પર પહોંચી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ત્યાં મૂસા જ્યારે પોતાના હાથ ઊંચા કરતો, ત્યારે ઇઝરાયલનો વિજય થતો; પરંતુ જ્યારે તે પોતાના હાથ નીચા કરતો, ત્યારે અમાલેકીઓ જીતતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","પણ મૂસાના હાથ થાક્યા એટલે તે લોકોએ એક પથ્થર લાવીને ત્યાં મૂક્યો. મૂસા તેના પર બેઠો. અને એક બાજુથી હારુને તથા બીજી બાજુથી હૂરે ટેકો દઈને મૂસાના હાથોને સ્થિર રાખ્યા, આમ સૂર્યાસ્ત થતાં સુધી તેના હાથ ઊંચા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","યહોશુઆ અને તેના લોકોએ અમાલેકીઓને તલવારથી યુદ્ધમાં પરાજિત કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","પછી યહોવાહે મૂસાને કહ્યું, “આ બાબતની યાદગીરી રાખવા માટે તેને પુસ્તકમાં લખ. અને યહોશુઆને કહે કે, હું અમાલેકનું નામનિશાન આકાશ તથા પૃથ્વી પરથી સદાયને માટે નાબૂદ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ત્યાર બાદ મૂસાએ એક વેદી બંધાવી અને તેને “યહોવાહ નિસ્સી” એવું નામ આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","તેણે કહ્યું કે, “અમાલેકીઓ તેમના હાથ યહોવાહના સિંહાસન તરફ લંબાવ્યા હતા અને યહોવાહે પ્રતિજ્ઞા કરી છે કે, તે વંશપરંપરાગત અમાલેક સાથે યુદ્ધ કરશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","યહોવાહે મૂસા અને ઇઝરાયલી લોકોને જે અનેક પ્રકારે સહાય કરી હતી, તે બાબતમાં તથા જે રીતે તે ઇઝરાયલના લોકોને માટે જે કંઈ કર્યું હતું તે વિષે તથા યહોવાહે ઇઝરાયલીઓને કેવીરીતે મિસરમાંથી મુક્ત કર્યા હતા તે વિષે મૂસાના સસરાએ એટલે મિદ્યાનના યાજક યિથ્રોએ સાંભળ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","મૂસાએ પોતાની પત્ની સિપ્પોરાહને તેના બે પુત્રો સહિત મોકલી દીધી હતી ત્યારે તેના સસરા યિથ્રોએ તેઓને પોતાને ઘરે રાખ્યાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","મૂસાના બે પુત્રોમાંના પ્રથમ પુત્રનું નામ ‘ગેર્શોમ’ પાડવામાં આવ્યું હતું; તેનો અર્થ થાય છે કે ‘હું પરદેશમાં પ્રવાસી થયેલો છું.’ ");
INSERT INTO guj2017_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","બીજા પુત્રનું નામ ‘એલિએઝેર’ હતું. તેનો અર્થ થાય છે કે ‘ઈશ્વરે મારી સહાય કરીને મને ફારુનની તલવારથી બચાવ્યો છે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","એટલા માટે યિથ્રો મૂસાની પત્ની અને પુત્રોને લઈને અરણ્યમાં ઈશ્વરના પર્વત આગળ જયાં મૂસાએ છાવણી કરીને મુકામ કર્યો હતો ત્યાં તેની પાસે આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","તેણે મૂસાને સંદેશો મોકલ્યો કે, “હું તારો સસરો યિથ્રો અહીં આવ્યો છું અને તારી પત્ની અને બે પુત્રોને તારી પાસે લાવ્યો છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","તેથી મૂસા તેના સસરાને મળવા સામો ગયો. અને પ્રણામ કરીને તેણે તેને ચુંબન કર્યુ. બન્નેએ પરસ્પર ક્ષેમકુશળતાની ખબર પૂછી. પછી તેઓ મૂસાની છાવણીમાં તેના તંબુમાં ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ત્યાં મૂસાએ પોતાના સસરા યિથ્રોને યહોવાહે ઇઝરાયલના લોકો માટે ફારુન અને મિસરના લોકોના જે હાલહવાલ કર્યા હતા તથા ઇઝરાયલના લોકોને માર્ગમાં જે જે વિટંબણાઓનો સામનો કરવો પડયો હતો અને યહોવાહે તેઓને કેવી રીતે બચાવ્યા હતા, તે વિષે બધું કહી સંભળાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","યહોવાહે ઇઝરાયલના લોકોને મિસરના લોકોના હાથમાંથી છોડાવીને તેઓના પર જે ઉપકાર કર્યો હતો તે જાણીને યિથ્રો ખૂબ પ્રસન્ન થયો. ");
INSERT INTO guj2017_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","અને યિથ્રોએ કહ્યું, “યહોવાહની સ્તુતિ કરો કે જેમણે ઇઝરાયલી લોકોને મિસરવાસીઓના અને ફારુનના હાથમાંથી છોડાવ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","હવે મને ખાતરી થઈ છે કે, સર્વ દેવો કરતાં યહોવાહ મહાન છે; મિસરવાસીઓએ તમારી સાથે ગેરવર્તાવ રાખ્યો ત્યારે તમને સૌને યહોવાહે તેઓના પંજામાંથી મુક્ત કર્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","પછી મૂસાના સસરા યિથ્રો યાજકે ઈશ્વરને યજ્ઞો અને દહનીયાર્પણો ચઢાવ્યાં. અને હારુન ઇઝરાયલના સર્વ વડીલોને સાથે લઈને ઈશ્વર સમક્ષ મૂસાના સસરા સાથે રોટલી ખાવાને માટે આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","બીજે દિવસે સવારે મૂસાએ ઘણા લોકોનો ન્યાય કરવાનું શરૂ કર્યું. તેઓ ન્યાય મેળવવા માટે સવારથી સાંજ સુધી આવતા રહેતા હતા અને પોતાનો વારો આવે એની રાહ જોતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","મૂસા લોકો માટે જે કંઈ કરતો હતો તે સઘળું મૂસાના સસરાએ જોયું, તેથી તેણે મૂસાને કહ્યું, “લોકોના માટે તું આ શું કરે છે? ન્યાયાધીશ તરીકે તું એકલો બેસે છે અને આટલા બધા લોકો તારી પાસે સવારથી સાંજ સુધી આવીને ઊભા રહે છે! તેનું શું કારણ છે?” ");
INSERT INTO guj2017_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ત્યારે મૂસાએ કહ્યું, “લોકો મારી પાસે તેઓની સમસ્યાઓના સંબંધમાં યહોવાહની ઇચ્છા વિષે પૂછવા માટે આવે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","વળી એ લોકોમાં કોઈ વિવાદ થયો હોય, તેના ન્યાયચુકાદા માટે મારી પાસે આવે છે. તેઓમાં કોણ સાચું છે તે હું નક્કી કરું છું. આ રીતે હું તેઓને યહોવાહના નિયમો અને વિધિઓ વિષે શીખવું છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","પરંતુ મૂસાને તેના સસરાએ કહ્યું, “તું જે રીતે આ કરી રહ્યો છે તે પધ્ધતિ યોગ્ય નથી. ");
INSERT INTO guj2017_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","તું તંગ આવી જશે. તારા એકલાથી આ કામનો બોજો ઉપાડી શકાય એવો નથી. તું એકલો એ નહિ કરી શકે.” ");
INSERT INTO guj2017_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","હું તને સલાહ આપું છું અને તારે શું કરવું જોઈએ, એ તને બતાવું છું. “હું ઈશ્વરને પ્રાર્થના કરું છું કે તે તને મદદ કરે. તારે યહોવાહ સમક્ષ એ લોકોના પ્રતિનિધિ થવું જોઈએ અને તે લોકોના પ્રશ્નો યહોવાહની સમક્ષ રજૂ કરવા જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","અને તારે લોકોને યહોવાહના નિયમો તથા વિધિઓ તેઓ પાળે અને તોડે નહિ તે માટે ચેતવવાના છે અને તેઓને શીખવવાનું છે. તેઓને જીવનનો સાચો માર્ગ કયો છે અને શું કરવું તે સમજાવવાનું છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","“વિશેષમાં તું યહોવાહની બીક રાખનાર તથા સર્વ લોકોમાંથી હોશિયાર અને વિશ્વાસપાત્ર હોય, લાંચરુશવતને ધિક્કારનાર તથા નિસ્વાર્થ હોય એવા માણસોને પસંદ કરીને તેઓને હજાર હજાર, સો સો, પચાસ પચાસ અને દશ દશ માણસોના ઉપરીઓ તરીકે નિયુક્ત કર. ");
INSERT INTO guj2017_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","પછી એ ઉપરી પ્રતિનિધિઓને લોકોનો ન્યાય કરવા દે. જો કોઈ બહુ જ ગંભીર સમસ્યા હોય તો ઉપરી પ્રતિનિધિ નિર્ણય કરશે અને પછી તેઓ તારી પાસે આવી શકશે. પરંતુ સામાન્ય પ્રકારના પ્રશ્નોનો નિર્ણય તો તેઓ જ કરશે. આમ તારા કાર્યમાં તેઓ સહભાગી થશે અને તારું કામ સરળ થશે. ");
INSERT INTO guj2017_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","હવે જો તું આ બધું કરીશ, તો યહોવાહની ઇચ્છા પૂર્ણ થશે. તને થાક લાગશે નહિ. અને આવનારા લોકો પણ સંપૂર્ણપણે સંતોષી થઈ પોતાના ઘરે પાછા ફરશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","મૂસાએ પોતાના સસરાની સલાહ સ્વીકારી અને તેણે તે પ્રમાણે અમલ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","મૂસાએ સર્વ ઇઝરાયલના લોકોમાંથી ચુનંદા માણસો પસંદ કર્યા અને તેઓમાંથી હજારના, સોના, પચાસના, તથા દશ માણસોના ઉપરી તરીકે નિયુક્ત કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ત્યાર બાદ તેઓ જ બધો સમય લોકોનો ન્યાય કરવા લાગ્યા. ફક્ત મુશ્કેલ પ્રશ્નો હોય તો જ તેઓ મૂસા આગળ લાવતા અને નાના સામાન્ય પ્રશ્નો તેઓ જાતે હલ કરતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","પછી મૂસાએ પોતાના સસરા યિથ્રોને વિદાય આપી. યિથ્રો તેના વતનમાં પાછો ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","મિસર દેશમાંથી પ્રયાણ કર્યા પછી ત્રીજા માસના પ્રથમ દિવસે જ ઇઝરાયલીઓ સિનાઈના અરણ્યમાં આવી પહોંચ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ઇઝરાયલીઓ રફીદીમથી સિનાઈના અરણ્યમાં આવ્યા ત્યારે સિનાઈ પર્વતની આગળ છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","એ પર્વત પર જઈને મૂસા યહોવાહ સમક્ષ ઊભો રહ્યો. અને યહોવાહે તેને પર્વત પર કહ્યું, “ઇઝરાયલી લોકોને અને યાકૂબનાં સંતાનોને આ કહેજે કે, ");
INSERT INTO guj2017_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘તમે તમારી નજરે જોયું કે મેં મિસરવાસીઓને શું શું કર્યું છે. અને તમને મિસરમાંથી ગરુડની જેમ પાંખો પર ઊંચકીને હું મારી પાસે કેવી રીતે લાવ્યો.’ ");
INSERT INTO guj2017_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","તેથી હવે જો તમે મારા કહ્યા પ્રમાણે કરશો અને મારા કરારને પાળશો, તો સર્વ પ્રજાઓમાં માત્ર તમે જ ખાસ પ્રજા થશો. સમગ્ર પૃથ્વી મારી છે. તેમાં હું તમને જ મારા ખાસ લોકો તરીકે પસંદ કરું છું. ");
INSERT INTO guj2017_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","તમે મારે સારુ ખાસ યાજકોનું રાજ્ય બનશો તથા પવિત્ર દેશજાતિ થશો.’ આ બધું તારે ઇઝરાયલના લોકોને કહેવાનું છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","આથી મૂસાએ આવીને લોકોના વડીલોને બોલાવડાવ્યા. અને યહોવાહે તેને જણાવેલાં બધાં વચનો તેઓની સમક્ષ કહી સંભળાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","તે સાંભળીને સર્વ લોકોએ એકસાથે જવાબ આપ્યો, “યહોવાહે જે ફરમાવ્યું છે તે બધાનું અમે પાલન કરીશું.” લોકોનો આ પ્રતિભાવ મૂસાએ ઈશ્વરની સમક્ષ જાહેર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","પછી યહોવાહે મૂસાને કહ્યું, “જો હું ઘાડાં વાદળમાં તારી પાસે આવું છું, જેથી હું તારી સાથે બોલું ત્યારે લોકો સાંભળી શકે અને તારા પર સદાસર્વદા વિશ્વાસ રાખે.” અને મૂસાએ લોકોએ જે કર્યું હતું તે યહોવાહને કહી સંભળાવ્યું.” ");
INSERT INTO guj2017_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","પછી યહોવાહે મૂસાને કહ્યું, “તું લોકો પાસે જા અને તેઓને કહે કે, આજે અને આવતીકાલે તેઓ પોતાનાં શરીરો શુદ્ધ કરે અને પોતાનાં વસ્ત્રો ધુએ, ");
INSERT INTO guj2017_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","અને ત્રીજા દિવસને માટે તૈયાર થઈ જાય; કારણ કે, ત્રીજે દિવસે હું યહોવાહ સર્વ લોકોના દેખતાં સિનાઈના પર્વત પર ઊતરવાનો છું. ");
INSERT INTO guj2017_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","તે વેળાએ તું પર્વતની ચારેબાજુ લોકોને માટે હદ નક્કી કરજે અને તેઓને કહેજે કે, ‘સાવચેત રહેજો, પર્વત પર ચઢશો નહિ અને તેની તળેટીને પણ અડકશો નહિ. અને જે કોઈ તેને અડકશે તે નિશ્ચે માર્યો જશે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","જો કોઈ વ્યક્તિ તેને હાથ અડકાડે, તો તેને પથ્થરે મારવો અથવા તીરથી વીંધી નાખવો. તે પશુ હોય કે માણસ હોય પણ તે બચશે નહિ, જયારે રણશિંગડું લાંબા અવાજે વાગે ત્યારે જ લોકો ઢોળાવ ચઢીને પર્વત પાસે આવે.” ");
INSERT INTO guj2017_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","આથી મૂસા પર્વત પરથી નીચે ઊતરીને લોકો પાસે ગયો. અને તેણે તેઓને શુદ્ધ કર્યા. અને તેઓએ પોતાનાં વસ્ત્રો ધોઈ નાખ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","પછી મૂસાએ તે લોકોને કહ્યું, “ત્રીજા દિવસને માટે તૈયાર થઈ જજો. ત્યાં સુધી સ્ત્રી સંગ કરશો નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","પછી ત્રીજે દિવસે સવારમાં આકાશમાં મેઘગર્જનાઓ અને વીજળીઓ થવા લાગ્યાં. પર્વત ઉપર કાળું ઘાડું વાદળ છવાઈ ગયું, અને રણશિંગડાનો બહુ મોટો અવાજ થયો, જેથી છાવણીમાં સર્વ લોકો ધ્રૂજી ઊઠયા. ");
INSERT INTO guj2017_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","એટલે મૂસા યહોવાહને મળવા માટે સર્વ લોકોને છાવણીમાંથી બહાર લાવ્યો; અને તેઓ પર્વતની તળેટીમાં ઊભા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","અગ્નિ દ્વારા યહોવાહ સિનાઈ પર્વત પર ઊતર્યા, એટલે આખા પર્વત પર ધુમાડો વ્યાપ્યો. અગ્નિનો એ ધુમાડો ભઠ્ઠીના ધુમાડાની જેમ ઉપર ચઢવા લાગ્યો. અને આખો પર્વત જોરથી કંપવા લાગ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","અને પછી જ્યારે રણશિંગડાના અવાજની તીવ્રતા વધવા લાગી ત્યારે મૂસા યહોવાહ સમક્ષ વાત કરવા લાગ્યો અને યહોવાહ ગડગડાટ જેવા અવાજથી તેને જવાબ આપતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","યહોવાહ સિનાઈ પર્વતના શિખર ઉપર ઊતર્યા; તેમણે મૂસાને પર્વતના શિખર પર બોલાવ્યો; તેથી મૂસા પર્વત પર ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ત્યાં યહોવાહ એ મૂસાને કહ્યું, “નીચે જા, અને લોકોને સાવધાન કર કે, તેઓ મારા દર્શનાર્થે નિયત હદ ઓળંગીને ઘસી આવે નહિ. જો તેઓ એવું કરશે તો તેઓ માર્યા જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","વળી જે યાજકો મારી નજીક આવે, તેઓએ પોતાને શુદ્ધ કર્યા નહિ હોય તો હું તેઓને સખત સજા કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","એટલે મૂસાએ યહોવાહને કહ્યું, “લોકો સિનાઈ પર્વત પાસે આવી શકશે નહિ, કારણ કે તમે પોતે અમને આજ્ઞા કરી છે કે, પર્વતની ચારેબાજુ હદ નિયત કરજો કે લોકો તેને ઓળંગીને પવિત્ર મેદાનમાં આવે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","એટલે યહોવાહે તેને કહ્યું, “જા, નીચે ઊતર; અને હારુનને ઉપર લઈ આવ, પરંતુ યાજકો કે લોકો હદ ઓળંગીને મારી પાસે ઘસી આવે નહિ એનું ધ્યાન રાખજે, નહિ તો હું તે લોકોને નષ્ટ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","પછી મૂસાએ નીચે ઊતરીને યહોવાહે જણાવેલી વાત લોકોને કહી સંભળાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","પછી યહોવાહે આ સર્વ વચનો ઉચ્ચારતાં કહ્યું: ");
INSERT INTO guj2017_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“હું તમારો ઈશ્વર યહોવાહ છું. હું તમને મિસર દેશમાં જ્યાં તમે ગુલામ હતા ત્યાંથી બહાર લઈ આવ્યો છું. તેથી તમારે આ આદેશો માનવા પડશે. ");
INSERT INTO guj2017_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“તમારે કોઈ દેવોની પૂજા કરવી નહિ, માત્ર મારી જ ભક્તિ કરવી.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“તમારે આકાશમાંની કે પૃથ્વી પરની કે પૃથ્વી નીચેના પાણીમાંની કોઈ પણ વસ્તુની મૂર્તિ કે પ્રતિમા બનાવવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","તમારે તેઓને સાષ્ટાંગ પ્રણામ કરવા નહિ કે તેઓની પૂજા કરવી નહિ. કારણ કે હું જ તમારો ઈશ્વર યહોવાહ છું અને આવેશ રાખનાર છું. મારા લોકો જગતના દેવોની પૂજા કરે એ મને પસંદ નથી. જે મારી વિરુદ્ધ પાપ કરે છે, તેઓ મારા દુશ્મન બને છે અને હું તેઓને અને તેઓના સંતાનોને ત્રીજી તથા ચોથી પેઢી સુધી સજા કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","પરંતુ મારા પર પ્રેમ રાખનાર અને મારી આજ્ઞાનું પાલન કરનારની હજારો પેઢી પર હું દયાભાવ દર્શાવીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“તમારે તમારા ઈશ્વર યહોવાહનું નામ વ્યર્થપણે ન લેવું. કારણ કે તે માણસોને હું નિર્દોષ ગણીશ નહિ. જેઓ મારું નામ વ્યર્થપણે લેશે તેને સજા કર્યા વિના હું રહેવાનો નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“વિશ્રામવારની પવિત્રતા જાળવવાનું યાદ રાખજો.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","છ દિવસ તમારે તમારાં બધાં કામકાજ કરવાં, પરંતુ સાતમો દિવસ વિશ્રામવાર તો તમારા ઈશ્વર યહોવાહનો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","તેથી વિશ્રામવારના દિવસે તમારે કે તમારા પુત્રોએ કે તમારી પુત્રીઓએ, તમારા દાસ-દાસીઓએ કે તમારાં જાનવરોએ કે તમારા ગામમાં રહેતા વિદેશીએ કોઈ કામ કરવું નહિ, કારણ કે, ");
INSERT INTO guj2017_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","છ દિવસમાં મેં યહોવાહે આકાશ, પૃથ્વી, સમુદ્ર તથા તેમાંની તમામ વસ્તુઓ ઉત્પન્ન કરી હતી અને સાતમે દિવસે મેં વિશ્રામ કર્યો હતો, તેથી મેં યહોવાહે વિશ્રામવારને આશીર્વાદ આપીને તેને પવિત્ર ઠરાવ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“તમારાં માતાપિતાનું સન્માન કરો, જેથી હું યહોવાહ તમારો ઈશ્વર તમને જે દેશ આપનાર છું તેમાં તમે લાંબુ આયુષ્ય પામો. ");
INSERT INTO guj2017_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","તમારે ખૂન કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","તમારે વ્યભિચાર કરવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","તમારે ચોરી કરવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","તમારે પડોશી કે માનવબંધુ વિરુદ્ધ જૂઠી સાક્ષી પૂરવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","તમારા પડોશીના ઘરની લાલસા રાખવી નહિ; તમારા પડોશીની પત્ની કે તેના દાસ કે તેની દાસી કે તેનો બળદ કે તેનું ગધેડું કે તમારા પડોશીની કોઈ પણ વસ્તુની લાલસા-લોભ, લાલચ, ઉત્કટ ઇચ્છા રાખવી નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","બધા લોકો ગર્જના, અને રણશિંગડાનો નાદ સાંભળીને તથા વીજળીના ચમકારા અને પર્વતમાંથી નીકળતો ધુમાડો જોઈને ભયભીત થઈને થરથર ધ્રૂજતા દૂર જ ઊભા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","પછી તેઓએ મૂસાને કહ્યું, “અમારી સાથે તું જ બોલ, તો અમે સાંભળીશું, પણ યહોવાહ અમારી સાથે બોલે નહિ. જો તે બોલશે તો અમે બધા મરી જઈશું.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","એટલે મૂસાએ તે લોકોને કહ્યું, “ગભરાશો નહિ, કારણ કે યહોવાહ તો તમારી કસોટી કરવા આવ્યા છે કે, જેથી તમે બધા તેમનો ડર રાખો અને પાપ ન કરો.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","“પરંતુ તેમ છતાં લોકો તો દૂર જ ઊભા રહ્યા અને મૂસા ઘનઘોર વાદળ નજીક જ્યાં યહોવાહ હતા ત્યાં ગયો.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","પછી યહોવાહે મૂસાને કહ્યું, “તું ઇઝરાયલના લોકોને એમ કહે કે, મેં તમારી સાથે આકાશમાંથી વાત કરી છે એ તમે જાતે જોયું છે. ");
INSERT INTO guj2017_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","તેથી મારી આગળ તમારે કોઈ સોનાચાંદીની મૂર્તિઓ ન બનાવવી. તમારે આવા ખોટા દેવો બનાવવા નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“મારા માટે તમે લોકો એક માટીની વેદી બનાવજો, અને તેના પર તમારાં ઘેટાંબકરાં અને અન્ય જાનવરોમાંથી મને દહનીયાર્પણ અને શાંત્યર્પણ ચઢાવજો. જે સર્વ જગાએ હું મારું નામ સ્થાપીશ, ત્યાં હું તમારી પાસે આવીશ અને તમને આશીર્વાદ આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","જો તમે મારા માટે પથ્થરની વેદી બાંધો, તો ઘડેલા પથ્થરની નહિ પણ અસલ પથ્થરની બાંધશો. કારણ કે તમે જો તેના પર કોઈ પણ ઓજાર વાપરો તો તે અશુદ્ધ બની જાય. ");
INSERT INTO guj2017_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","તેમ જ તમારે પગથિયાં પર થઈને મારી વેદી ઉપર ચઢવું નહિ, રખેને તમે ઉઘાડા દેખાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","પછી યહોવાહે મૂસાને કહ્યું, હવે તારે જે કાનૂનો લોકોની આગળ રજૂ કરવાના છે તે આ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“જો તમે કોઈ હિબ્રૂ ગુલામ ખરીદો, તો તે છ વરસ પર્યંત તમારી સેવા કરે અને સાતમે વર્ષે તે છૂટો થઈ જાય અને કશું ચૂકવ્યા વિના છૂટો થઈ શકે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ગુલામ થતાં અગાઉ જો તે કુંવારો હોય, તો તે એવી જ અવસ્થામાં એકલો છૂટો થઈ જાય. પરંતુ જો ગુલામ થતાં અગાઉ જો તેનાં લગ્ન થયેલાં હોય, તો છૂટો થતી વખતે તેની સાથે તેની પત્ની પણ મુક્ત થશે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","જો કદાચ અગાઉ તેનાં લગ્ન થયેલાં ના હોય અને ગુલામી અવસ્થા દરમિયાન જો તેનો માલિક તેનાં લગ્ન કરાવી આપે અને તેની સાથે પત્ની, પુત્ર અને પુત્રીઓનો વધારો થાય તો પણ તે એકલો જ છૂટો થાય. પરંતુ સ્ત્રી તથા બાળકો તો માલિકનાં થાય.” ");
INSERT INTO guj2017_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“પરંતુ જો તે ગુલામ સ્પષ્ટ રીતે એવું કહે કે; ‘હું તો મારા માલિકને તથા મારી પત્નીને તથા મારાં બાળકોને પ્રેમ કરું છું; મારે છૂટવું નથી.’ ");
INSERT INTO guj2017_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","જો આવું બને તો ગુલામના માલિકે તેને ઈશ્વરના સમક્ષ લાવવો અને બારસાખ આગળ ઊભો રાખીને સોયથી તેનો કાન વીંધવો; એટલે તે કાયમને માટે તેના માલિકનો ગુલામ બની રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“અને જો કોઈ માણસ પોતાની દીકરીને દાસી થવા માટે વેચે, તો ગુલામ પુરુષોની માફક તે છૂટે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","જેણે તેને ખરીદી હોય તેને જો તે ન ગમે, તો તે તેના પિતાને પાછી વેચી શકે, જો માલિકે તેની સાથે લગ્ન કરવાનું વચન આપ્યું હોય, તો પારકા લોકોને તેને વેચવાની તેની સત્તા રહેતી નથી, કેમ કે તેણે તેની પ્રત્યે ઠગાઈ કરી છે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","પરંતુ જો તેણે તેના પોતાના પુત્ર માટે તેને રાખવી હોય તો તેની સાથે તેણે પુત્રી જેવો વ્યવહાર રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“જો તે બીજી પત્ની સાથે લગ્ન કરે, તો તેણે તેની પ્રથમ પત્નીના અન્ન, વસ્ત્ર અને તેના પત્ની તરીકેના હક્કમાં કશો ઘટાડો કરવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","અને જો તે તેની પત્ની પ્રત્યે આ ત્રણ ફરજો અદા કરે નહિ તો તે વિના મૂલ્યે છૂટી થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“જે કોઈ અન્ય માણસને મારીને તેની હત્યા કરે તો તેને મોતની સજા થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","પરંતુ જો કોઈ માણસ ખૂન કરવાના ઇરાદાથી છુપાઈ રહ્યો ના હોય પણ ઈશ્વર તેના હાથમાં કોઈને સોંપે અને હત્યા કરાય તો તેને નાસી જવા માટે હું આશ્રયસ્થાન નિયત કરીશ, ત્યાં તે નાસી જશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","“પરંતુ જો કોઈ ક્રોધે ભરાઈને જાણી જોઈને બીજાની હત્યા કરે, પોતાના પડોશી પર ઘસી જઈને તેને દગાથી મારી નાખે; તો તેને મારી વેદી આગળથી લઈ જઈને પણ શિક્ષારૂપે તેને મારી નાખવો.” ");
INSERT INTO guj2017_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","અને જો કોઈ પોતાના પિતાને કે માતાને મારે, તો તેને નક્કી મૃત્યુની સજા થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","જો કોઈ ચોરીછૂપીથી માનવહરણ કરે અને તેને વેચે, અથવા તો તેને પોતાના તાબામાં રાખે, તો તેને નક્કી મૃત્યુની સજા થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","અને જો કોઈ પોતાના પિતાને કે માતાને શાપ આપે તો પણ તેને મૃત્યુની સજા થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","અને જો કોઈ બે માણસો એક બીજા સાથે ઝઘડો કરતા હોય, અને તેમાંનો એક જણ બીજાને પથ્થરથી કે મુઠ્ઠીથી એવો મારે કે તે મરી ન જાય પરંતુ પથારીવશ થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","પછી જ્યારે તે સાજો થઈને લાકડી લઈને હરતો-ફરતો થઈ જાય, તો જે માણસે તેને માર્યો હોય તે છૂટી જાય ખરો, પરંતુ તેણે પેલા માણસને સમય અને કામની નુકસાની ભરપાઈ કરવી અને સંપૂર્ણ સાજો થાય ત્યાં સુધીની સારવારની તથા અન્ય જવાબદારી મારનારની રહે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","અને જો કોઈ માણસ પોતાના ગુલામ કે દાસીને લાકડી વડે મારે અને તેનું મૃત્યુ થાય, તો મારનાર ગુનેગાર ગણાય અને સજાપાત્ર બને. ");
INSERT INTO guj2017_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","પરંતુ જો તે ગુલામ કે દાસી એક કે બે દિવસ જીવતું રહે, તો તેના માલિકને સજા થાય નહિ. કારણ એ ગુલામ કે દાસી તેની પોતાની સંપત છે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","જો કોઈ માણસો લડતા-ઝઘડતા હોય ત્યારે તેમાંનો કોઈ ગર્ભવતી સ્ત્રીને ઈજા પહોંચાડે અને તે સ્ત્રી તેના બાળકને પૂરા સમય પહેલાં જન્મ આપે પણ ગંભીર ઈજા ના થાય તો તે સ્ત્રીનો પતિ માગે તેટલો દંડ ન્યાયાધીશના ચુકાદા પ્રમાણે ઈજા પહોંચાડનારે આપવો. ");
INSERT INTO guj2017_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","પણ જો ઈજા પછી બીજું કંઈ નુકસાન થાય, તો તેની શિક્ષા જીવને બદલે જીવ. ");
INSERT INTO guj2017_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","આંખને બદલે આંખ, દાંતને બદલે દાંત, હાથને બદલે હાથ, પગને બદલે પગ. ");
INSERT INTO guj2017_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","દઝાડવાને બદલે દઝાડવું, ઘાને બદલે ઘા, ચીરાના બદલે ચીરો એ પ્રમાણે બદલો લેવો. ");
INSERT INTO guj2017_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","અને જો કોઈ માણસ પોતાના ગુલામ કે દાસીને આંખ પર મારીને તેને ફોડી નાખે, તો તેણે આંખની નુકસાનીના બદલામાં તેઓને છૂટાં કરી દેવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","અને જો તે પોતાના ગુલામનો કે દાસીનો દાંત તોડી નાખે, તો તેના દાંતની નુકસાનીના બદલામાં તેઓને મુક્ત કરી દેવા. ");
INSERT INTO guj2017_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","વળી જો કોઈ બળદ સ્ત્રી કે પુરુષને શિંગડું મારે, તેથી તેનું મૃત્યુ થાય, તો તે બળદને પથ્થરા મારીને મારી નાખવો. અને તેનું માંસ ખાવું નહિ, બળદનો માલિક ગુનેગાર ગણાય નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","પણ જો તે બળદને પહેલેથી જ શિંગડું મારવાની ટેવ હોય અને તે વિષે તેનો માલિક જાણતો હોય, તેમ છતાં તેણે તેને કાબૂમાં રાખ્યો ના હોય અને તે બળદ કોઈ પુરુષ કે સ્ત્રીને મારી નાખે, તો તે બળદને પથ્થરો મારીને મારી નાખવો અને તેના માલિકને પણ મોતની સજા કરવી. ");
INSERT INTO guj2017_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","પરંતુ મૃત્યુની સજાને બદલે જો તેનો દંડ કરવામાં આવ્યો હોય, તો બળદના જીવના બદલામાં જે કાંઈ મૂલ્ય ઠરાવવામાં આવે તે તેણે ચૂકવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","અને જો બળદે કોઈના પુત્ર કે પુત્રીને શિંગડું માર્યું હોય, તો પણ આ જ કાનૂન લાગુ પડે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","જો એ બળદ કોઈ ગુલામ કે દાસીને શિંગડું મારે તો તેના માલિકે ગુલામ કે દાસીને ત્રીસ તોલા ચાંદી આપવી અને બળદને પથ્થરો મારીને મારી નાખવો. ");
INSERT INTO guj2017_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","જો કોઈ માણસ ખાડો ખોદે અને તેને ઢાંકે નહિ અને જો તેમાં કોઈનો બળદ કે કોઈનું ગધેડું પડે, ");
INSERT INTO guj2017_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","તો ખાડાના ખોદનારે નુકસાન ભરપાઈ કરવું. તેણે એ પશુના માલિકને તેની કિંમત જેટલાં નાણાં ભરપાઈ કરવાં. અને મરેલું પશુ પોતે લઈ જવું. ");
INSERT INTO guj2017_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","અને જો કોઈ માણસનો બળદ બીજાના બળદને શિંગડું મારે અને તે મરી જાય, તો તે બન્ને જીવતા બળદને વેચી નાખે અને તેની કિંમત વહેંચી લે તથા મરેલું પશુ પણ વહેંચી લે. ");
INSERT INTO guj2017_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","અથવા બળદના માલિકને જો પહેલેથી જ ખબર હોય કે એ બળદને કેટલાક સમયથી મારવાની ટેવ છે અને એના માલિકે એને કાબૂમાં રાખ્યો ન હોય, તો તેનું નુકસાન ભરપાઈ કરી આપવું. બળદને બદલે બળદ આપવો, અને એ મૃત પશુ પણ તેનું થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","જો કોઈ માણસ બળદ કે ઘેટું ચોરે અને તેને કાપે અથવા વેચી નાખે, તો તેણે એક બળદને બદલે પાંચ બળદ અને એક ઘેટાંને બદલે ચાર ઘેટાં આપવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","જો કોઈ ચોરી કરતાં પકડાયા અને તેની હત્યા થાય તો એ ખૂન ન ગણાય, પણ ");
INSERT INTO guj2017_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","જો તે સૂર્યોદય પછી ચોરી કરવાના ઇરાદાથી ઘરમાં ઘૂસે અને પકડાઈ જતાં તેને મારી નાખવામાં આવે તો એ ખૂન ગણાય. ચોરેલા માલની નુકસાની ચોરી કરનાર ભરી આપે; અને જો તે કંગાલ હોય તો તેની ચોરીનો દંડ ભરવા માટે તે પોતે વેચાઈ જાય. ");
INSERT INTO guj2017_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","પરંતુ જો ચોરેલું જાનવર તેની પાસે જીવતું મળી આવે, પછી તે બળદ હોય, ગધેડું હોય કે ઘેટું હોય; તો તે બમણું ભરપાઈ કરી આપે. ");
INSERT INTO guj2017_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","જો કોઈ માણસ પોતાનાં જાનવર ખેતરમાં કે દ્રાક્ષવાડીમાં છૂટાં મૂકે અને તેઓ બીજાના ખેતરોમાં ભેલાણ કરે, તો તેણે પોતાના ખેતરની અથવા દ્રાક્ષની વાડીની સર્વોત્તમ ઊપજમાંથી નુકસાની ભરપાઈ કરી આપવી. ");
INSERT INTO guj2017_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","જો કોઈ માણસ પોતાના ખેતરમાં કાંટા-ઝાંખરાં સળગાવવા આગ પેટાવે અને આગ પડોશીના ખેતરમાં ફેલાઈ જાય અને તેનો પાક અથવા અનાજ બળી જાય; તો જેણે આગ લગાડી હોય તેણે પૂરેપૂરું નુકસાન ભરપાઈ કરી આપવું. ");
INSERT INTO guj2017_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","જો કોઈ માણસ પોતાના પડોશીને નાણાં કે મિલકત સાચવવા માટે સોંપે અને તે પેલા માણસના ઘરમાંથી ચોરાઈ જાય; અને જો ચોર પકડાય, તો તેણે બમણું ભરપાઈ કરી આપવું. ");
INSERT INTO guj2017_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","પરંતુ જો ચોર પકડાઈ ના જાય તો તે ઘરધણીએ પોતાને ન્યાયધીશો આગળ રજૂ કરવો અને ન્યાયધીશ તેની ચોરી સંબંધી યોગ્ય નિર્ણય કરશે. ");
INSERT INTO guj2017_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","જો કોઈ બે માણસો બળદ વિષે, ગધેડા વિષે, ઘેટાં વિષે, વસ્ત્ર વિષે કે કોઈ ખોવાયેલી વસ્તુ વિષે અસહમત હોય અને તેમાંનો એક કહે: ‘આ મારું છે.’ પણ બીજો કહે: ‘ના, આ મારું છે.’ તો બન્નેએ તકરાર માટે ન્યાયાધીશ પાસે જવું અને ન્યાયાધીશ સાચો ન્યાય આપશે. ન્યાયાધીશ જેને ગુનેગાર ગણાવે તેણે બીજા માણસને બમણું ભરપાઈ કરી આપવું. ");
INSERT INTO guj2017_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","જો કોઈ માણસ પોતાના પડોશીને ગધેડું, બળદ, ઘેટું કે બીજું કોઈ પશુ સાચવવા સોંપે; અને તે મરી જાય, અથવા તેને કોઈ ઈજા થાય, અથવા કોઈ ઉપાડી જાય, અને કોઈ સાક્ષી હોય નહિ, ");
INSERT INTO guj2017_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","તો પછી તે માણસે સમજાવવું કે તેણે ચોરી નથી કરી અથવા પ્રાણીને ઈજા પહોંચાડી નથી. તેણે યહોવાહના સમ સાથે કહેવાનું કે તેણે ચોરી નથી કરી; અને તેના માલિકે એ કબૂલ રાખવું; અને પછી પડોશીએ નુકસાન ભરપાઈ કરવાનું રહેતું નથી. ");
INSERT INTO guj2017_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","પરંતુ જો પડોશીએ તે પશુની ચોરી કરી હોય, તો તેણે માલિકને નુકસાન ભરપાઈ કરી આપવું. ");
INSERT INTO guj2017_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","જો કોઈ વનચર પશુએ તેને ફાડી ખાધું હોય, તો તેનો વધેલો ભાગ પુરાવા તરીકે રજૂ કરવો. પછી ફાડી ખાધેલા પશુનું નુકસાન ભરપાઈ કરવાનું રહેતું નથી. ");
INSERT INTO guj2017_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","અને જો કોઈ માણસ પોતાના પડોશી પાસેથી કોઈ પશુ ઉછીનું માગી લે અને તેનો માલિક તેની સાથે ના હોય એવા સંજોગોમાં તેને કશી ઈજા થાય અથવા તે મરી જાય, તો ઉછીનું લેનારે તેનો પૂરેપૂરો બદલો ભરપાઈ કરી આપવો. ");
INSERT INTO guj2017_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","માલિક તેની સાથે હોય, તો ઉછીનું લેનારે નુકસાન ભરપાઈ કરવાનું રહેતું નથી. અને જો ભાડે લીધું હોય તો ફક્ત ભાડું ચૂકવવાનું રહે. ");
INSERT INTO guj2017_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","જો કોઈ માણસ અપરિણીત કુમારિકાને લલચાવીને તેની સાથે સંબંધ બાંધે, તો તેનું પારંપારિક મૂલ્ય ચૂકવીને તે તેની સાથે લગ્ન કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","જો તેનો બાપ તેની સાથે લગ્ન કરાવવાની ના પાડે, તો કુમારિકાના પારંપારિક મૂલ્ય જેટલું નાણું આપવાનું રહે. ");
INSERT INTO guj2017_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","મંત્રતંત્રનો ઉપયોગ કરનાર સ્ત્રીને જીવતી રહેવા દેવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","જાનવરની સાથે કુકર્મ કરનારને મૃત્યુદંડની સજા કરવી. ");
INSERT INTO guj2017_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","મારા સિવાય એટલે કે યહોવાહ સિવાય બીજા કોઈ પણ દેવને યજ્ઞ કરનાર અને આહુતિ આપનાર માણસનું નામનિશાન રહેવા દેવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","તમારે વિદેશીઓને હેરાન કરવા નહિ, તેઓના પર ત્રાસ ગુજારવો નહિ, કારણ કે, તમે પોતે મિસર દેશમાં વિદેશી હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","કોઈ વિધવા કે અનાથ બાળકને રંજાડશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","જો તમે કોઈ પણ પ્રકારે તેઓને ત્રાસ આપશો અથવા દુઃખી કરશો તો તેઓ મને પોકારશે અને હું તેઓનો પોકાર સાંભળીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","પછી મારો કોપ ભભૂકી ઊઠશે. અને હું તમને તલવારથી મારી નાખીશ; તો તમારી પત્ની વિધવા થશે અને તમારાં પોતાનાં બાળકો અનાથ થશે. ");
INSERT INTO guj2017_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","તમે મારા લોકોમાંના કોઈ ગરીબ માણસને નાણાં ધીરો, તો તેના પ્રત્યે લેણદાર જેવો વ્યવહાર ન રાખશો અને તેની પાસે વ્યાજ લેશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","જો તમે તમારા પડોશીનું વસ્ત્ર ગીરે રાખો, તો સૂર્યાસ્ત થતાં અગાઉ તમારે તે તેને પાછું આપવું. ");
INSERT INTO guj2017_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","કારણ કે એ એનું એકમાત્ર ઓઢવા-પાથરવાનું છે. તે બીજું શું ઓઢીને સૂએ? જો તે મને પોકારશે, તો હું તેને સાંભળીશ, કારણ કે હું કૃપાળુ છું. ");
INSERT INTO guj2017_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","તમારા ઈશ્વરની નિંદા ન કરો તથા તમારા પોતાના લોકોના કોઈ આગેવાનને શાપ આપવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","તમારે તમારા ખેતરની ઊપજ તથા તમારા દ્રાક્ષારસના ભરપૂરીપણામાંથી અર્પણ કરવામાં ઢીલ કરવી નહિ અને તમારો જયેષ્ઠ પુત્ર મને અર્પિત કરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","તમારાં બળદો અને ઘેટાંના પ્રથમજનિત મને આપવાં. સાત દિવસ સુધી તે ભલે પોતાની માતાની સાથે રહે. આઠમે દિવસે તમારે તે મને આપી દેવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","અને તમે લોકો મારા પવિત્ર લોક થાઓ; તમારે જંગલી પશુએ મારેલા કોઈ પશુનું માંસ ન ખાવું, તે કૂતરાંને સારુ નાખી દેવું. ");
INSERT INTO guj2017_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“તમારે જૂઠી અફવા માનવી નહિ, કે ફેલાવવી નહિ. દુર્જનને સાથ આપીને ખોટી સાક્ષી પૂરવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","બહુમતીથી દોરવાઈને તમારે ખોટું કામ કરવું નહિ, તેમ જ ન્યાયલયમાં સાક્ષી આપતી વખતે ન્યાયના ભોગે બહુમતીનો પક્ષ લેવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","માણસ ગરીબ હોય તો તેની ગરીબીના કારણે ન્યાયાલયમાં તેના પ્રત્યે પક્ષપાત ન રાખવો. જો તે સાચો હોય તો એનો જ પક્ષ લેવો.” ");
INSERT INTO guj2017_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","તમારા શત્રુનો બળદ કે ગધેડો નાસી જતો નજરે પડે તો તમારે તેના માલિકને ત્યાં પાછો પહોંચાડવો. ");
INSERT INTO guj2017_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","જો તમે તમારા દુશ્મનના ગધેડાને ભારથી ચગદાઈને પડેલો જુઓ, તો તેને એ જ હાલતમાં છોડીને ચાલ્યા જશો નહિ, તમારે સહાય આપીને તેને બેઠો કરવો પછી જ તેને છૂટો કરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","તમારે ગરીબ માણસને તેની ન્યાયપ્રક્રિયામાં અન્યાય ન કરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","જૂઠા આક્ષેપો કરવા નહિ, નિર્દોષ અને ન્યાયીને મૃત્યુની સજા કરવી નહિ. નિર્દોષ માણસને મારી નાખનાર ખરાબ માણસને હું નિર્દોષ નહિ માનું. ");
INSERT INTO guj2017_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","તમારે કદીય લાંચ લેવી નહિ. કારણ કે લાંચ દેખતાને અંધ બનાવે છે. તેથી તેઓ સત્ય જોઈ શકતા નથી. તે સારા માણસને ખોટું બોલતા કરે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","તમારે વિદેશી લોકો પર ત્રાસ ગુજારવો નહિ, તમે લોકો મિસરમાં વિદેશી હતા, એટલે તમે વિદેશીઓની લાગણીને સમજો છો. ");
INSERT INTO guj2017_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","છ વર્ષ પર્યંત તમારે ખેતરમાં વાવેતર કરવું અને તેની ઊપજ એકત્રિત કરવી. ");
INSERT INTO guj2017_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","પણ સાતમે વર્ષે તમારે કશુંય વાવવું નહિ અને જમીન પડતર રહેવા દેવી. જમીનને એક વર્ષ આરામ કરવા દેવો. વાવ્યા વગર જે કંઈ ઊગે તેને તે વર્ષે ગરીબોને લેવા દેવું અને તેમાં વધેલું વનના પશુઓને ખાઈ જવા દેવું. વળી તમારે તમારી દ્રાક્ષવાડી અને જૈતૂનની વાડીમાં પણ આ પ્રમાણે કરવું. ");
INSERT INTO guj2017_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","તમારે છ દિવસ કામ કરવું પણ સાતમે દિવસે વિશ્રામ કરવો, જેથી તમારા બળદને અને ગધેડાને પણ આરામ મળે. અને તમારા ઘરમાં કામ કરતા દાસ-દાસી અને પરદેશી પણ વિશ્રામ પામીને તાજગી અનુભવે. ");
INSERT INTO guj2017_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","મેં તમને જે બધું કહ્યું છે તેનું ધ્યાન રાખજો. અન્ય દેવોની પૂજા કરશો નહિ. તથા તમારા મુખથી તેઓનું નામ સાંભળવા મળવું જોઈએ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“પ્રતિવર્ષ તમારે મારાં ત્રણ પર્વો પાળવાં અને ઊજવવાં. અને મારી ઉપાસના કરવી. ");
INSERT INTO guj2017_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","આબીબ મહિનામાં બેખમીરી રોટલીનું પર્વ પાળવું. તે વખતે સાત દિવસ સુધી મારી આજ્ઞા મુજબ તમારે બેખમીરી રોટલી ખાવી. કારણ કે, એ માસમાં તમે મિસરમાંથી બહાર આવ્યા હતા અને કોઈએ ખાલી હાથે મારી પાસે આવવું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","બીજું કાપણીનું પર્વ છે. તે પાળવું. ઉનાળાંમાં તમે ખેતરમાં જે વાવેતર કર્યુ હોય તેની પ્રથમ ઊપજ પ્રાપ્ત થાય ત્યારે ખેતરમાંથી ઉપજ ભેગી કરો એ સમયે તે પર્વ પાળવું. ");
INSERT INTO guj2017_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","પ્રતિવર્ષ ત્રણ વખત તમારામાંના પ્રત્યેક પુરુષે મારી ખાસ જગ્યાએ, મારી સાથે તમારા માલિક સાથે હાજર રહેવું. ");
INSERT INTO guj2017_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","તમારે મારા બલિદાનનું રક્ત ખમીરવાળી રોટલી સાથે ધરાવવું નહિ તેમ જ પર્વની ચરબી સવાર સુધી રાખી મૂકવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","તમારી જમીનની પ્રથમ ઊપજનો ઉત્તમોત્તમ ભાગ તમારે તમારા યહોવાહના ભક્તિસ્થાનમાં લાવવો. વળી લવારાને તેની માતાના દૂધમાં રાંધવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","અને તમારા માટે મેં જે જગ્યા તૈયાર કરી છે ત્યાં તમને લઈ જવા માટે હવે હું તમારી આગળ એક દૂત મોકલું છું તે રસ્તામાં તમારું રક્ષણ કરશે. ");
INSERT INTO guj2017_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","તમે લોકો તેનાથી જાળવીને રહેજો અને તેનું કહ્યું કરજો. તેની વિરુદ્ધ બળવો કરશો નહિ, તે તમારો ગુનો માફ કરશે નહિ. કારણ કે મારું નામ તેનામાં છે. ");
INSERT INTO guj2017_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","પરંતુ જો તમે તેની આજ્ઞાઓનું પાલન કરશો અને હું જે કહું તે બધું કરશો, તો હું તમારી સાથે રહીશ અને તમારા શત્રુઓ સાથે લડીશ. અને તમને હેરાન અને ત્રાસ કરનારને હું સજા આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","કારણ કે, મારો દૂત તમારી આગળ આગળ ચાલશે. અને તમને અમોરીઓ, હિત્તીઓ, પરીઝીઓ, કનાનીઓ, હિવ્વીઓ અને યબૂસીઓના પ્રદેશમાં લઈ જશે. અને હું તેઓનો સર્વનાશ કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","તમારે તે લોકોના દેવોની પૂજા કરવી નહિ, તેમની આગળ નમવું નહિ. તમારે તે લોકોની જેમ રહેવાનું નથી; તમારે તેઓની મૂર્તિઓને નષ્ટ કરવાની છે. અને તે લોકોના સ્તંભોને ભાગીને ભુક્કા કરી નાખવાના છે. ");
INSERT INTO guj2017_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","વળી તમારે તમારા ઈશ્વર યહોવાહની જ સેવા કરવાની છે અને હું તમારાં અન્ન-જળ પર આશીર્વાદ વરસાવીશ. અને તમારા તમામ રોગો હું દૂર કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","તમારા દેશમાં કોઈ પણ સ્ત્રીને ગર્ભપાત થશે નહિ તથા કોઈ સ્ત્રી નિ:સંતાન પણ હશે નહિ; હું તમને લોકોને પૂરેપૂરું આયુષ્ય આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","તમે જ્યારે દુશ્મનો સાથે લડતા હશો, ત્યારે હું મારું સામર્થ્ય તમારી સામે મોકલીશ અને તે બધાને હું થથરાવી દઈશ. તથા તમારા બધા જ દુશ્મનો તમારાથી ગભરાઈને જતા રહે એવું હું કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","તદુપરાંત હું તમારી આગળ ભમરીઓને મોકલીશ, તે હિવ્વી, કનાની તથા હિત્તી લોકોને તમારી આગળથી નસાડી મૂકશે. ");
INSERT INTO guj2017_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","હું એક જ વર્ષમાં એ બધાને કાઢી મૂકીશ નહિ, રખેને બધી જમીન વેરાન થઈ જાય અને જગંલમાં વનચર જાનવરોની સંખ્યા વધી જતાં તમે બધા મુશ્કેલીમાં મુકાઈ જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","તમારી સંખ્યાનો એટલો બધો વધારો થાય અને તમે સમગ્ર દેશનો કબજો લઈ શકો ત્યાં સુધીમાં તો હું તેમને ધીરે ધીરે નસાડી મૂકીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","હું રાતા સમુદ્રથી પલિસ્તીઓના સમુદ્ર સુધી તમારી સરહદ નક્કી કરી આપીશ. એ દેશના વતનીઓને હું તમારા હાથમાં સોંપી દઈશ અને તમે તેઓને તમારી આગળથી નસાડી મૂકશો. ");
INSERT INTO guj2017_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","તમે તેઓની સાથે કે તેઓના દેવો સાથે કોઈ સંબંધ બાંધશો નહિ, કે કરારો કરશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","તેઓ તમારા દેશમાં વસે નહિ, રખેને તેઓ તમારી પાસે મારી વિરુદ્ધ પાપ કરાવે. કેમ કે જો તમે તેઓના દેવોની સેવા કરશો તો તેઓ તમારે માટે ફાંદારૂપ થઈ પડશે. ");
INSERT INTO guj2017_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","યહોવાહે મૂસાને કહ્યું, “તું અને હારુન, નાદાબ તથા અબીહૂ તેમ જ ઇઝરાયલના વડીલોમાંના સિત્તેર મારી સમક્ષ આવો; અને થોડે દૂર રહીને મારું ભજન કરો. ");
INSERT INTO guj2017_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","પછી મૂસા તું એકલો મારી પાસે આવજે, અન્ય કોઈ ન આવે. અને લોકો તો તારી સાથે ઉપર આવે જ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ત્યારબાદ મૂસાએ આવીને લોકોને યહોવાહના બધા વચનો અને બધી આજ્ઞાઓ કહી સંભળાવી. પછી બધા લોકો એકી અવાજે બોલી ઊઠયા, “યહોવાહ એ જે બધી વાતો કહી છે તે બધાનું પાલન અમે કરીશું. ");
INSERT INTO guj2017_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","પછી મૂસાએ યહોવાહનાં બધા આદેશો લખી નાખ્યા અને સવારમાં વહેલા ઊઠીને તેણે પર્વતની તળેટીમાં એક વેદી બાંધી અને ઇઝરાયલના બાર કુળસમૂહ પ્રમાણે બાર સ્તંભ બાંધ્યા.” ");
INSERT INTO guj2017_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","પછી તેણે કેટલાક ઇઝરાયલી નવયુવાનોને યજ્ઞો અર્પવા મોકલ્યા. અને તેઓએ યહોવાહને દહનીયાર્પણ અને શાંત્યર્પણ તરીકે બળદોનું અર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","અને મૂસાએ યજ્ઞનું અડધું રક્ત એક વાસણમાં રાખ્યું અને અડધું રક્ત તેણે વેદી પર છાંટ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","પછી તેણે કરારનું પુસ્તક લીધું અને બધા લોકોને મોટેથી વાંચી સંભળાવ્યું એટલે તેઓ બોલી ઊઠયા, “યહોવાહે જે જે કહ્યું છે તે બધું અમે માથે ચઢાવીશું અને તે પ્રમાણે કરીશું.” ");
INSERT INTO guj2017_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","પછી મૂસાએ વાસણમાંથી રક્ત લઈને લોકો પર છાંટ્યું અને કહ્યું, “આ પુસ્તકમાં લખેલાં વચનો પ્રમાણે યહોવાહે તમારી સાથે જે કરાર કર્યો છે, તેને પાકો કરનાર આ રક્ત છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","તે પછી મૂસા, હારુન, નાદાબ, અબીહૂ અને ઇઝરાયલીઓના સિત્તેર વડીલોને સાથે લઈને તે ઉપર ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ત્યાં તેઓએ ઇઝરાયલના ઈશ્વરનું દર્શન કર્યું અને ઈશ્વરના પગ નીચે જાણે નીલમના જેવી ફરસબંધી હતી. તે સ્વચ્છ આકાશના જેવી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ઇઝરાયલના બધા આગેવાનોએ યહોવાહને જોયાં. પણ યહોવાહે તેઓનો નાશ ન કર્યો. તેઓ બધાએ સાથે ખાધું અને પીધું. ");
INSERT INTO guj2017_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","યહોવાહે મૂસાને કહ્યું, “તું મારી પાસે પર્વત પર આવ અને ત્યાં રહે; અને મેં જે શિલાપાટીઓ ઉપર નિયમો અને આજ્ઞાઓ લખ્યાં છે, તે હું તને આપીશ જેથી તું લોકોને સમજાવી શકે.” ");
INSERT INTO guj2017_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","આથી મૂસા તથા તેનો સેવક યહોશુઆ ઊઠ્યા. અને મૂસા યહોવાહના પર્વત પર ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","જતાં જતાં તેણે વડીલોને કહ્યું, “અમે તમારી પાસે પાછા આવીએ, ત્યાં સુધી તમે અહી અમારી રાહ જોજો. અને જુઓ, હારુન અને હૂર તમારી સાથે છે; જો કોઈને કંઈ તકરાર હોય તો તેઓની પાસે જાય.” ");
INSERT INTO guj2017_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","પછી મૂસા પર્વત પર ચઢયો અને વાદળોએ પર્વતને ઢાંકી દીધો. ");
INSERT INTO guj2017_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","યહોવાહનું ગૌરવ સિનાઈ પર્વત પર ઊતર્યુ. અને છ દિવસ સુધી વાદળોએ પર્વતને ઢાંકી રાખ્યો. અને સાતમે દિવસે યહોવાહે વાદળમાંથી હાંક મારીને મૂસાને બોલાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","અને યહોવાહનું ગૌરવ ઇઝરાયલીઓને પર્વતની ટોચે પ્રચંડ અગ્નિ જેવું દેખાયું. ");
INSERT INTO guj2017_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","અને મૂસા વાદળમાં પ્રવેશ કરીને પર્વત પર ગયો; અને તે ચાળીસ દિવસ અને ચાળીસ રાત પર્યંત એ પર્વત પર રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ઇઝરાયલી લોકોને કહે કે, તેઓ મારા માટે જે અર્પણ આપવા ઇચ્છે છે તે રાજીખુશીથી આપે. તે તમારે મારે માટે અર્પણ તરીકે સ્વીકારવું. ");
INSERT INTO guj2017_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","તમારે તેઓની પાસેથી આટલી વસ્તુઓ અર્પણ તરીકે સ્વીકારવી; સોનું, ચાંદી, તાંબું ");
INSERT INTO guj2017_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","અને ભૂરા, જાંબુડિયા તથા કિરમજી રંગનું કિંમતી ઊન; શણનું ઝીણું કાપડ તથા બકરાંના વાળ, ");
INSERT INTO guj2017_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ઘેટાંનાં ચામડાં જે પકવેલાં અને લાલ રંગમાં રંગેલાં હોય તથા ચામડાં અને બાવળનાં લાકડાં. ");
INSERT INTO guj2017_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","વળી દીવા માટે તેલ, અભિષેકના તેલને માટે તથા સુવાસિત ધૂપને માટે સુગંધીઓ, ");
INSERT INTO guj2017_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ઉરપત્રક અને એફોદમાં જડવા માટે ગોમેદ પાષાણો અને અન્ય પાષાણો. ");
INSERT INTO guj2017_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","અને તેઓ મારા માટે એક પવિત્રસ્થાન બનાવે, જેથી હું તેઓની વચ્ચે રહી શકું. ");
INSERT INTO guj2017_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","હું મંડપનો નમૂનો તથા તેના સર્વ સામાનનો નમૂનો બતાવું તે પ્રમાણે તમારે તે બનાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","બાવળના લાકડાનો અઢી હાથ લાંબો, દોઢ હાથ પહોળો અને દોઢ હાથ ઊંચો એક પવિત્રકરારકોશ બનાવવો. ");
INSERT INTO guj2017_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","તેને અંદરથી તથા બહારથી ચોખ્ખા સોનાથી મઢવો અને તેની ફરતે સોનાની પટ્ટી જડવી. ");
INSERT INTO guj2017_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","પછી તેને ઊંચકવા માટે સોનાનાં ચાર કડાં બનાવવાં અને તેમને તેના ચાર ખૂણે જડી દેવાં; એક બાજુએ બે કડાં અને બીજી બાજુએ બે કડાં. ");
INSERT INTO guj2017_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","બાવળના દાંડા બનાવીને પછી તું તેમને સોનાથી મઢજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","અને કરારકોશને ઉપાડવા માટે એ દાંડા દરેક બાજુના કડામાં ભરવી દેવા. ");
INSERT INTO guj2017_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","દાંડા કરારકોશનાં કડામાં રહેવા દેવા, બહાર કાઢવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","અને હું તને કરારકોશના ચિહ્ન તરીકે જે બે પાટીઓ આપું તે તું તેમાં મૂકજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","વળી ચોખ્ખા સોનાનું અઢી હાથ લાંબું અને દોઢ હાથ પહોળું દયાસન તમારે બનાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","અને તમારે સોનાના બે કરુબો ટીપેલા સોનામાંથી ઘડીને દયાસનના બે છેડા માટે બનાવવા. ");
INSERT INTO guj2017_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","અને એક કરુબ એક છેડા પર અને બીજો દયાસનના બીજા છેડા પર બેસાડવો, એ કરુબ દયાસનની સાથે એવી રીતે જોડી દેવા કે દયાસન અને કરુબો એક થઈ જાય. ");
INSERT INTO guj2017_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","એ કરુબોની પાંખો ઊંચે આકાશ તરફ ફેલાયેલી રાખવી. તેઓનાં મુખ એકબીજાની સામે હોય અને દયાસન તરફ વળેલાં હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","એ દયાસન ઉપર મૂકવું અને કરારકોશમાં હું તને આપું તે કરારની બે પાટીઓ મૂકવી. ");
INSERT INTO guj2017_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","અને ત્યાં હું તને મળીશ. ઇઝરાયલી લોકો માટે જે આજ્ઞાઓ હું તને આપીશ તે સર્વ વિષે, કરારલેખના કરારકોશ પરના દયાસન ઉપરથી તથા બે કરુબોની વચમાંથી, હું તારી સાથે વાત કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","વળી તું બાવળના લાકડાંનું બે હાથ લાંબું, એક હાથ પહોળું અને દોઢ હાથ ઊંચું એવું એક મેજ બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","તું તેને શુદ્ધ સોનાથી મઢજે અને તેને ફરતી સોનાની કિનારી લગાડજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","તું તેને ફરતી ચાર આંગળની કોર બનાવજે અને કોરની આસપાસ સોનાની કિનારી બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","તેને માટે સોનાનાં ચાર કડાં બનાવીને તું તેમને તેના ચાર પાયાના ચાર ખૂણામાં જડી દેજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","મેજ ઊંચકવાના દાંડાની જગ્યા થાય માટે કડાં કિનારની પાસે મૂકવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","મેજ ઊંચકવા માટે બાવળના દાંડા બનાવજે અને તેને સોનાથી મઢજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","મેજ માટે વાસણો બનાવજે; એટલે થાળીઓ, ચમચીઓ, કડછીઓ અને પેયાર્પણને માટે વાટકા બનાવ. તું તેમને ચોખ્ખા સોનાનાં બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","તું સદા મારી આગળ મેજ પર અર્પેલી રોટલી રાખજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","વળી શુદ્ધ સોનાનું એક દીપવૃક્ષ બનાવ. તે ઘડતર કામનું હોય અને તેની બેઠક, તેનો દાંડો, તેનાં ચાડાં, તેની કળીઓ તથા તેનાં ફૂલો, તે સર્વ એક જ ટુકડામાંથી ઘડી કાઢેલાં હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","તેની બાજુઓમાંથી છ શાખાઓ નીકળે; એક બાજુમાંથી દીપવૃક્ષની ત્રણ શાખાઓ અને બીજી બાજુમાંથી દીપવૃક્ષની ત્રણ શાખાઓ. ");
INSERT INTO guj2017_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","એક શાખામાં બદામફૂલના આકારના ત્રણ પ્યાલા, એક કળી તથા એક ફૂલ અને બીજી શાખામાં બદામફૂલના આકારના ત્રણ પ્યાલા, એક કળી તથા એક ફૂલ; તે પ્રમાણે દીપવૃક્ષમાંથી નીકળતી છ શાખાઓ હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","દીપવૃક્ષમાં બદામફૂલના આકારના ચાર પ્યાલા, તેઓની કળીઓ તથા તેઓનાં ફૂલો સહિત હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","દીવીને છ ડાળી હોવી જોઈએ, દાંડીની બન્ને બાજુથી ત્રણ શાખા નીકળવી જોઈએ. શાખાની દરેક જોડીની નીચે એક એક કળી હોય. એ કળીઓ અને ડાળીઓ દીવીની સાથે જડી દીધેલી હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","અને બધું જ શુદ્ધ સોનાની એક જ પાટલીમાંથી ઘડીને બનાવેલું હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","દીવી માટે સાત કોડિયાં બનાવવાં અને તે એવી રીતે ગોઠવવાં કે તેઓનો પ્રકાશ સામેની બાજુએ પડે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","એના ચીપિયા અને તાસક શુદ્ધ સોનાનાં હોવાં જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","આ બધાં સાધનો બનાવવા માટે એક તાલંત શુદ્ધ સોનું વાપરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","તેં પર્વત પર જોયેલા નમૂના પ્રમાણે આ બધું બનાવવાની કાળજી રાખજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","વળી તું દશ પડદાનો મંડપ બનાવજે. આ પડદા ઝીણા કાંતેલા શણના અને નિપુણ વણકરોના વણેલા વસ્ત્રના અને ભૂરા, કિરમજી તથા જાંબલી પડદા તૈયાર કરજે. એ પડદાઓ ઉપર જરીથી કળામય રીતે કરુબો ભરાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","પ્રત્યેક પડદો અઠ્ઠાવીસ હાથ લાંબો અને ચાર હાથ પહોળો હોય; બધા જ પડદા એક સરખા માપના હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","પાંચ પડદા એકબીજા સાથે જોડાય અને બીજા પાંચ પડદા પણ એકબીજા સાથે જોડાય. ");
INSERT INTO guj2017_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","પહેલા સમૂહના પડદા પર જાંબુડિયા રંગના વસ્ત્રનાં નાકાં મૂકાવજે. બીજા સમૂહના છેલ્લા પડદા પર પણ એવું જ કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","પહેલા સમૂહના પડદામાં તું પચાસ નાકાં બનાવજે અને બીજા સમૂહના પડદામાં પચાસ નાકાં બનાવજે તે નાકાં એકબીજાની સામસામાં આવવાં જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","પછી સોનાની પચાસ કડીઓ બનાવજે અને તેઓ વડે તું પડદાને એકબીજા સાથે જોડી દેજે. એટલે એક આખો મંડપ બનશે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","આ પવિત્ર મંડપ ઉપર તંબુ બનાવવા માટે તું બકરાંના વાળના વસ્ત્રના અગિયાર પડદા તૈયાર કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","એ અગિયાર પડદા એક સરખા માપના હોવા જોઈએ. દરેક પડદો ત્રીસ હાથ લાંબો અને ચાર હાથ પહોળો હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","એમાંના પાંચ પડદાને એક સાથે સીવીને સળંગ એક પડદો બનાવજે. બાકીના છ પડદાને ભેગા સીવીને બીજો પડદો બનાવજે. એમાંનો છઠ્ઠો પડદો તંબુના પ્રવેશદ્વાર ઉપર બેવડો વાળજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","અને સમૂહનો જે છેલ્લો પડદો છે તેની બાજુએ પચાસ નાકાં અને બીજા પડદાની બાજુએ પચાસ નાકાં બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","અને પિત્તળની પચાસ કડીઓ બનાવજે અને તેને પેલા નાકાંમાં પરોવી બન્ને પડદાને જોડી દઈને એક સળંગ તંબુ બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","અને તંબુ પરથી વધારાનો લટકતો રહેતો ભાગ મંડપના પાછલા ભાગ પર લટકતો રાખજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","તંબુની બન્ને બાજુએ પડદાઓ તંબુના છેડેથી એક હાથ નીચા રહેશે. આથી આ તંબુ પવિત્ર મંડપને સંપૂર્ણ રીતે આચ્છાદન કરશે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","તંબુ માટે ઘેટાંના લાલ રંગેલાં ચામડાંનું બીજું આચ્છાદન બનાવજે અને તેના પર ઢાંકવા માટે મુલાયમ ચામડાનું આચ્છાદન બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","પવિત્રમંડપના ટેકા માટે તું બાવળનાં પાટિયાં બનાવીને ઊભા મૂકજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","પ્રત્યેક પાટિયું દસ હાથ લાંબું અને દોઢ હાથ પહોળું હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","પ્રત્યેક પાટિયામાં એકબીજાની સાથે જોડાયેલાં બે સાલ હોય; પવિત્ર મંડપની બધી જ બારસાખો સરખી હોવી જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","પવિત્ર મંડપની દક્ષિણની બાજુ માટે વીસ પાટિયાં બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","અને પ્રત્યેક પાટિયાનાં બે સાલને બેસાડવા માટે તેની નીચે બે કૂંભી એમ ચાંદીની કુલ ચાલીસ કૂંભીઓ બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","એ જ પ્રમાણે મંડપની ઉત્તરની બાજુ માટે પણ વીસ પાટિયાં, ");
INSERT INTO guj2017_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ચાંદીની ચાળીસ કૂંભીઓ બનાવજે, જેથી દરેક પાટિયાં નીચે બબ્બે કૂંભી આવે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","મુલાકાતમંડપની પશ્ચિમ તરફના પાછળના ભાગ માટે છ પાટિયાં બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","અને મંડપના પાછળના ભાગના બે ખૂણાને માટે તું બે પાટિયાં બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","આ ખૂણા પરનાં પાટિયાં નીચેથી એકબીજા સાથે બંધ બેસતાં હોય અને છેક ઉપર એક કડી બધાં પાટિયાંને સાથે રાખે. બન્ને ખૂણાઓમાં એમ કરવું. બે ખૂણા માટેનાં બે પાટિયાં આ રીતે બનાવજે એટલે બે ખૂણા બની જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","આમ, આઠ પાટિયાં અને ચાંદીની સોળ કૂંભી થશે. પ્રત્યેક પાટિયાં નીચે બબ્બે કૂંભીઓ રાખજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","વળી તું બાવળના લાકડાની આડી વળીઓ બનાવજે. પવિત્ર મંડપની એક બાજુનાં પાટિયાને માટે પાંચ ભૂંગળો બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","પવિત્ર મંડપની બીજી બાજુનાં પાટિયાં માટે પાંચ ભૂંગળો, તેમ જ પશ્ચિમ તરફથી પાછલી બાજુ માટે પાંચ ભૂંગળો. ");
INSERT INTO guj2017_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","વચલી વળી પાટિયાની વચ્ચે તંબુના એક છેડાથી બીજા છેડા સુધી આવે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","વળી પાટિયાંને સોનાથી મઢાવજે અને રીંગને ભેરવવા માટે તેમાં સોનાનાં કડાં બેસાડવાં અને રીંગને પણ તું સોનાથી મઢાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","તને પવિત્ર મંડપનો જે નમૂનો મેં પર્વત પર બતાવ્યો છે તે પ્રમાણે તું પવિત્ર મંડપ ઊભો કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","તું ભૂરા, કિરમજી અને લાલ ઊનનો અને ઝીણા કાંતેલા શણનો એક ખાસ પડદો તંબુમાં ભાગ પાડવા માટે બનાવજે. એના ઉપર જરી વડે કલામય રીતે કરુબોની આકૃતિઓ ભરાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","અને તું તેને સોનાથી મઢેલા બાવળના ચાર સ્તંભ પર લટકાવજે, તેઓને સોનાની આંકડીઓ અને તેઓની કૂંભીઓ ચાંદીની હોઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","એ આંકડીઓ નીચે તું પડદો લટકાવજે. અને કરારનો તકતીઓવાળો કરારકોશ એ પડદા પાછળ મૂકજે. એ પડદો પવિત્રસ્થાનને પરમ પવિત્રસ્થાનથી જુદું પાડશે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","પરમ પવિત્રસ્થાનમાં કરારકોશ પર આચ્છાદન કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","પવિત્ર જગ્યાની અંદર પડદાની પેલી બાજુએ જે ખાસ મેજ બનાવ્યું છે તે મૂકજે અને તેને તંબુની ઉત્તર બાજુએ ગોઠવજે. પછી દીવીને દક્ષિણ તરફ બાજઠની સામે મૂકજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","વળી, તું પવિત્ર મંડપના પ્રવેશદ્વાર માટે ભૂરા, કિરમજી અને લાલ ઊનનો અને ઝીણા કાંતેલા શણનો જરી વડે સુંદર ભરતકામ કરેલો પડદો બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","અને એ પડદા માટે બાવળના લાકડાની સોનાથી મઢેલી અને સોનાની કડીવાળી પાંચ થાંભલી બનાવજે અને એ થાંભલીઓ માટે પિત્તળની ઢાળેલી પાંચ કૂંભીઓ બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","વેદી બાવળના લાકડાની બનાવજે, તે ચોરસ હોય અને પાંચ હાથ લાંબી, પાંચ હાથ પહોળી અને ત્રણ હાથ ઊંચી હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ચારે ખૂણે ચાર શિંગ બનાવજે અને તે વેદીના લાકડામાંથી જ બનાવજે અને તેની ચારે બાજુથી ખૂણા જોડી દેજે, જેથી તે એક બની જાય ત્યારબાદ વેદીને પિત્તળથી ઢાંકી દેજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","અને તેનાં ભસ્મપાત્રો, પાવડાઓ, તપેલાં ત્રિપાંખી સાધનો તથા સગડીઓ બનાવજે અને તેનાં સઘળાં પાત્રો પિત્તળનાં બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","વળી વેદી માટે તું પિત્તળની જાળી બનાવજે; તથા જાળીના ચાર ખૂણામાં તું પિત્તળનાં ચાર કડાં બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","પછી તું એ જાળી વેદીની છાજલી નીચે એવી રીતે મૂકજે કે જેથી તે વેદીની ઊંચાઈને અડધે સુધી પહોંચે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","અને વેદીને માટે તું બાવળના દાંડા બનાવજે અને તેને પિત્તળથી મઢી દેજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","વળી વેદીને ઊંચકતી વખતે એ દાંડા વેદીની દરેક બાજુએ આવેલા કડામાં ભેરવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","વેદી પાટિયાના ખોખા જેવી પોલી બનાવજે. પર્વત પર મેં જેમ તને બતાવ્યું હતું તેમ તેઓ તેને બનાવે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","મંડપની આજુબાજુ ચોક બનાવજે. તેની દક્ષિણ બાજુએ કાંતેલા ઝીણા શણનો સો હાથ લાંબો પડદો બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","પડદાઓ લટકાવવા માટે પિત્તળના વીસ સ્તંભો બેસાડવા અને એ સ્તંભોના સળિયા અને આંકડા ચાંદીના બનાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ચોકની ઉત્તર બાજુએ પણ એ જ પ્રમાણે કરવાનું છે. પિત્તળની કૂંભીઓમાં બેસાડેલા વીસ સ્તંભો સાથે જોડેલા ચાંદીના સળિયાઓ ઉપર ચાંદીના આંકડાઓ વડે સો હાથ લાંબા પડદાઓ લટકાવવાના છે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","એ ચોકની પશ્ચિમ બાજુને ઢાંકવા માટે પચાસ હાથ લાંબા પડદા હોય અને તેને માટે દશ સ્તંભો અને દશ કૂંભીઓ હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","પૂર્વ દિશામાં પણ તે જ રીતે પચાસ હાથ લાંબા પડદાઓ લટકાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","પ્રવેશદ્વારની એક બાજુએ પંદર હાથના પડદા હોય અને તેને માટે ત્રણ સ્તંભો અને ત્રણ કૂંભી હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","અને બીજી બાજુએ પણ પંદર હાથના પડદા અને ત્રણ સ્તંભો અને ત્રણ કૂંભી હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","પ્રવેશદ્વારને માટે વીસ હાથ લાંબો પડદો બનાવજે, તે પડદો ઝીણા કાંતેલા શણનો, ભૂરા, જાંબુડા અને કિરમજી રંગનો, સુંદર ભરતકામવાળો બનાવજે, ચાર કૂંભીઓમાં બેસાડેલા ચાર સ્તંભો પર તેને લટકાવવાનો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ચોકની આજુબાજુના બધા સ્તંભો ચાંદીના સળિયાથી જોડાયેલા હોય, તેમના આંકડા ચાંદીના હોય અને તેમની કૂંભીઓ પિત્તળની હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","આ પ્રમાણે ચોક ઝીણા કાંતેલા શણના કાપડનો બનશે અને સો હાથ લાંબો અને પચાસ હાથ પહોળો થશે. ચોકને ફરતા પડદાની દીવાલો પાંચ હાથ ઊંચી થશે. પડદાઓ ઝીણા કાંતેલા શણના હોય. તેનાં તળિયાં પિત્તળનાં હોવાં જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","પવિત્ર મંડપમાં વપરાતાં તમામ ઓજારો, તંબુના ખીલાઓ અને બીજી વસ્તુઓ પિત્તળની હોવી જોઈએ. ચોકને ફરતા પડદાઓની ખીલીઓ પિત્તળની બનેલી હોવી જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","દીવી ઉપર મૂકવાના અખંડ દીવા માટે ઘાણીએ પીલેલું જૈતૂનનું ઉત્તમ તેલ લાવી આપવા ઇઝરાયલીઓને આજ્ઞા કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","મુલાકાતમંડપમાં સાક્ષ્યકોશ આગળના પડદાની બહારની બાજુએ હારુન તથા તેના પુત્રો સાંજથી તે સવાર સુધી યહોવાહ આગળ તેની વ્યવસ્થા કરે. આ વિધિનું ઇઝરાયલીઓએ અને તેઓના વંશજોએ પેઢી દર પેઢી પાલન કરવાનું છે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ઇઝરાયલીઓમાંથી તું તારા ભાઈ હારુનને અને તેના પુત્રો નાદાબ, અબીહૂ, એલાઝાર, અને ઈથામારને અલગ કરીને મારી સેવા માટે યાજકો તરીકે સમર્પિત કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","તારા ભાઈ હારુનને માટે પવિત્ર પોષાક તૈયાર કરાવજે, જેથી તેનો મોભો અને ગૌરવ જળવાય. ");
INSERT INTO guj2017_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","મેં જે વસ્ત્ર કલાકારોને કૌશલ્ય બક્ષ્યું છે, તેઓને સૂચના આપ કે હારુન માટે પોષાક તૈયાર કરે કે જે પરિધાન કરીને યાજક તરીકે તે મારી સમક્ષ સેવા કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","તેઓ આ પોષાક બનાવે: ઉરપત્રક, એફોદ, ઝભ્ભો, સફેદ ગૂંથેલો લાંબો જામો, પાઘડી તથા કમરબંધ; તેઓએ તારા ભાઈ હારુન તથા તેના પુત્રો માટે મારા યાજકો તરીકે સેવા બજાવે ત્યારે ગણવેશ તરીકે પહેરવાના અલગ પવિત્ર વસ્ત્રો બનાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","એ વસ્ત્રો સોનેરી દોરા તથા ભૂરા, જાંબુડા અને કિરમજી રંગનાં ઊનનાં અને ઝીણા કાંતેલા શણના કાપડમાંથી જ બનાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","તેઓ સોનેરી દોરા તથા ભૂરા, જાંબુડિયા અને કિરમજી રંગનાં ઝીણાં કાંતેલા શણનાં કાપડનો એફોદ બનાવે; આ એફોદ સૌથી વધુ નિષ્ણાત કલાકારો જ તૈયાર કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","એના બે છેડા જોડવા માટે એને ખભા પાસે બે સ્કંધપટી હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","કમરબંધ પણ એવી જ બનાવટનો હોય; સોનેરી દોરો, ભૂરા, જાંબુડા અને કિરમજી રંગના ઊન અને ઝીણા કાંતેલા શણના દોરાઓમાંથી ગૂંથીને બનાવેલો હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","વળી ગોમેદના બે પાષાણો લેવા અને પછી તેના પર ઇઝરાયલ પુત્રોનાં નામ કોતરવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","પ્રત્યેક પાષાણ પર ઉંમરના ઊતરતા ક્રમે છ નામ કોતરવામાં આવે. આમ, તેઓના જન્મ દિવસના ક્રમમાં બારે કુળનાં નામો કોતરવામાં આવે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","આ મુદ્રા બનાવનાર કલાકાર પાસે તારે બે પાષાણ પર ઇઝરાયલ પુત્રોનાં નામ કોતરાવવાં અને તેમને સોનાના ચોકઠામાં જડવાં. અને ઇઝરાયલ પુત્રોના સ્મારક તરીકે ઉરાવરણની સ્કંધપટી સાથે જડી દેવા. ");
INSERT INTO guj2017_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","હારુને આ નામો પોતાના બે ખભા પર કિંમતી પથ્થર ધારણ કરીને યહોવાહ પાસે જવું જેથી તેને ઇઝરાયલીઓનું સ્મરણ રહે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","એફોદ પર પાષાણને બેસાડવા માટે શુદ્ધ સોનાનો ઉપયોગ કરવો. ઉપર તારે સોનાનાં ચોકઠાં લગાડવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","અને દોરીની જેમ વણેલી શુદ્ધ સોનાની બે સાંકળી બનાવવી અને તે ચોકઠાં સાથે જોડી દેવી. ");
INSERT INTO guj2017_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","પછી ખૂબ કાળજીપૂર્વક એફોદ બનાવવામાં ઉપયોગી એવી કલાકૃતિવાળું ન્યાયકરણનું ઉરપત્રક બનાવવું, એ સોનેરી દોરો તથા ભૂરા, જાંબુડિયા અને લાલ રંગના ઊનનું તેમ જ ઝીણા કાંતેલા શણનું હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","તે સમચોરસ તથા બેવડું વાળેલું હોય, તે એક વેંત લાંબુ અને એક વેંત પહોળું હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","વળી તેમાં ચાર હારમાં નંગ જડવાં. પહેલી હારમાં માણેક, પોખરાજ અને લાલ, ");
INSERT INTO guj2017_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","બીજી હારમાં લીલમ, નીલમ તથા હીરો, ");
INSERT INTO guj2017_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ત્રીજી હારમાં શનિ, અકીક અને યાકૂત, ");
INSERT INTO guj2017_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ચોથી હારમાં પીરોજ, ગોમેદ તથા યાસપિસ હોય. આ બધાને સોનામાં જ જડવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","પ્રત્યેક પાષાણ પર ઇઝરાયલના બાર પુત્રોમાંના એક પુત્રનું નામ કોતરાવવું. પ્રત્યેક પાષાણ ઇઝરાયલના એક કુળસમૂહનું પ્રતીક બનશે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ઉરપત્રક માટે દોરીની જેમ વણેલી શુદ્ધ સોનાની સાંકળીઓ કરાવવી, તે સાંકળીઓ વડે ઉરપત્રકનો ઉપરનો છેડો એફોદ સાથે જોડવાનો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","વળી સોનાની બે કડીઓ બનાવવી અને તે ઉરપત્રકને ઉપરને છેડે જોડી દેવી. ");
INSERT INTO guj2017_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","અને એ બે કડીઓ સાથે પેલી સોનાની બે સાંકળી જોડી દેવી. ");
INSERT INTO guj2017_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","સાંકળીના બીજા બે છેડા બે ચોકઠાં સાથે જોડી દેવાં અને એ રીતે એફોદની સ્કંધપટીઓના આગલા ભાગ ઉપર તેમને જોડી દેવી. ");
INSERT INTO guj2017_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","પછી સોનાની બીજી બે કડીઓ બનાવવી અને ઉરપત્રકમાં અંદરની બાજુએ નીચેના છેડે લગાવવી. ");
INSERT INTO guj2017_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","કમરબંધ પર આવતા એફોદના આગળના ભાગના નીચેના છેડા ઉપર સોનાની બીજી બે કડીઓ લગાવવી. ");
INSERT INTO guj2017_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ઉરપત્રકનો નીચેનો ભાગ ભૂરા રંગની પટ્ટીઓ વડે એફોદના નીચેના છેડા પર આવેલી કડીઓ સાથે જોડવો. આમ કરવાથી ઉરપત્રક એફોદથી છૂટું પડી જશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","જ્યારે હારુન પવિત્ર સ્થાનમાં પ્રવેશે, ત્યારે તેની પાસે ન્યાયકરણના ઉરાવરણ પર ઇઝરાયલના બાર પુત્રોનાં નામ ધારણ કરેલાં હોવાં જોઈએ. હંમેશા તેઓ યહોવાહના સ્મરણ અર્થે રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ઉરીમ અને તુમ્મીમને ન્યાયકરણના ઉરપત્રકમાં મૂકવાં. હારુન જ્યારે યહોવાહ સમક્ષ જાય, ત્યારે તે તેની છાતી પર રહે. જ્યારે હારુન યહોવાહ સમક્ષ ઉપસ્થિત હોય ત્યારે અને ઇઝરાયલીઓનો ન્યાય કરતી વખતે હંમેશા આ ઉરપત્રક તેના અંગ પર રાખશે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","એફોદનો જામો આખો ભૂરા રંગના કાપડનો બનાવવો અને તેની વચમાં માથા માટે ચીરો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","એ ચીરાની કિનાર ચામડાના જામાના ગળાની જેમ ફરતેથી ગૂંથીને સીવી લેવી, જેથી તે ફાટી જાય નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","અને જામાની નીચેની કિનારીએ ભૂરા, જાંબુડા અને કિરમજી રંગના દાડમનું ભરતકામ કરાવવું. અને બે દાડમોની વચમાં સોનાની ઘૂઘરીઓ મૂકવી, ");
INSERT INTO guj2017_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","જેને લીધે નીચલી કિનાર પર ફરતે પહેલાં સોનાની ઘૂઘરી, પછી દાડમ, ફરી ઘૂઘરી, પછી દાડમ એ રીતે હાર થઈ જાય. હારુન જ્યારે યાજક તરીકે સેવા કરે ત્યારે એ પહેરે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","જ્યારે તે પવિત્રસ્થાનમાં યહોવાહના સાન્નિધ્યમાં જાય અથવા ત્યાંથી બહાર આવે, ત્યારે એ ઘૂઘરીઓનો અવાજ સંભળાશે, જેથી તે મૃત્યુ પામશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","પછી શુદ્ધ સોનાનું એક પાત્ર બનાવજે અને તેના પર ‘યહોવાહને પવિત્ર’ એમ કોતરાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","એ પાત્ર પાઘડીના આગળના ભાગમાં ભૂરી દોરી વડે બાંધવું. ");
INSERT INTO guj2017_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","હારુને એ પોતાના કપાળ પર ધારણ કરવું જેથી ઇઝરાયલીઓ જે પવિત્ર અર્પણો આપે તેમાં કોઈ દોષ હોય તો તે દોષ હારુન પોતાને માથે લઈ લે અને હારુને તે કાયમ પોતાના કપાળ પર પહેરી રાખવું જેથી યહોવાહ પવિત્ર અર્પણથી પ્રસન્ન રહે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","હારુનનો ઝભ્ભો ઝીણા કાંતેલા શણનો બનાવવો અને પાઘડી પણ ઝીણા કાંતેલા શણની જ બનાવવી અને તેના કમરપટા પર સુંદર જરીકામ કરાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","હારુનના પ્રત્યેક પુત્રને માટે તેને માન અને આદર આપવા સારુ જામો, કમરબંધ અને પાઘડી બનાવવાં જેથી તેનો આદર અને ગૌરવ જળવાય. ");
INSERT INTO guj2017_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","હારુન અને તેના પુત્રોને આ પોષાક પહેરાવ અને તેઓને સેવા માટે અર્પણ કર અને તેઓને માથા ઉપર જૈત તેલનો અભિષેક કરીને યાજકપદ માટે પવિત્ર કર. તેઓ યાજકો તરીકે મારી સેવા કરશે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","તેઓને માટે કમરથી તે સાથળ સુધી પહોંચે એવા અંતઃવસ્ત્ર બનાવવાં, જેથી તેઓની નિર્વસ્ત્રવસ્થા નગ્નપણું કોઈની નજરે ન પડે. ");
INSERT INTO guj2017_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","હારુન અને તેના પુત્રો જ્યારે પણ મુલાકાતમંડપમાં અથવા પવિત્રસ્થાનમાંની વેદી પાસે જાય, ત્યારે તેઓ હંમેશા અંતઃવસ્ત્ર પહેરે, જેથી તેઓ દોષમાં ન પડે અને તેઓ મૃત્યુ ન પામે. હારુન અને તેના વંશજો માટે આ કાયમી કાનૂન સદાને માટે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","યાજકો તરીકે હારુન અને તેના પુત્રોને શુદ્ધ કરવા માટેની વિધિ આ પ્રમાણે છે. ખોડખાંપણ વગરનાં બે ઘેટાં અને એક વાછરડો લેવો ");
INSERT INTO guj2017_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","બેખમીરી રોટલી, તેલથી મોહેલી બેખમીરી ભાખરી અને તેલ ચોપડેલી બેખમીરી રોટલી લેવી. આ બધું ઘઉંના મેંદાનું બનાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","તેઓને ટોપલીમાં મૂકવાં અને વાછરડો તથા બે ઘેટાં સાથે તે લાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ત્યારબાદ હારુન અને તેના પુત્રોને મુલાકાતમંડપનાં દ્વાર પાસે લાવીને તેઓને સ્નાન કરાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","પછી હારુનને જામો, ભરતકામવાળો ઝભ્ભો, એફોદ, ઉરાવરણ અને કમરબંધ પહેરાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","અને તેના માથા પર પાઘડી પહેરાવીને તેની સાથે દીક્ષાનો પવિત્ર મુગટ મૂકજે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","પછી અભિષેકનું તેલ લઈ તે તું તેના માથા પર રેડી, તેનો અભિષેક કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ત્યારબાદ તું તેના પુત્રોને લાવજે, તેઓને જામા પહેરાવવા, કમરે કમરબંધ તથા માથે ફેંટા બાંધવા. ");
INSERT INTO guj2017_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","મારા શાશ્વત કાનૂન અનુસાર તેઓ યાજકપદે કાયમ રહેશે. આ રીતે હારુનની અને તેના પુત્રોની યાજકપદે પ્રતિષ્ઠા કરવાની છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ત્યારબાદ વાછરડાને મુલાકાતમંડપની આગળ લઈ આવવો અને હારુન અને તેના પુત્રોએ તેના માથા ઉપર હાથ મૂકવા. ");
INSERT INTO guj2017_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","પછી યહોવાહની સંમુખ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ વાછરડાનો વધ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","વાછરડાનું થોડું રક્ત લઈને આંગળી વડે વેદીનાં શિંગોને લગાડવું, પછી બાકીનું બધું રક્ત વેદીના પાયા આગળ રેડી દેવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","પછી અંદરના ભાગો પર આવેલી બધી જ ચરબી લેવી. પિત્તાશય અને બે મૂત્રપિંડની ઉપર આવેલી ચરબી પણ લઈ લેવી અને વેદી પર તેનું દહન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","પરંતુ વાછરડાના માંસને, ચામડીને અને તેના અંદરના અવયવોને છાવણીની બહાર અગ્નિથી બાળી મૂકવાં. તે પાપાર્થાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ત્યારબાદ એક ઘેટો લઈને હારુને અને તેના પુત્રોએ તેના માથા પર હાથ મૂકવા. ");
INSERT INTO guj2017_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","પછી એ ઘેટાંનો વધ કરીને, તેનું રક્ત લઈને વેદીની ચારે બાજુએ છાંટવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","પછી તે ઘેટાંને કાપીને કકડા કરવા અને તેનાં આંતરડાં તથા પગ ધોઈ નાખવા, પછી તેઓને માથા અને શરીરના બીજા અવયવો સાથે મૂકવા. ");
INSERT INTO guj2017_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","પછી આખા ઘેટાંનું વેદી પર દહન કરવું એ યહોવાહના માનમાં દહનીયાર્પણ છે. એની સુવાસથી હું પ્રસન્ન થાઉં છું, એ મારા માનમાં કરેલો હોમયજ્ઞ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","હવે પછી બીજો ઘેટો લેવો. હારુને અને તેના પુત્રોએ તેના માથા પર હાથ મૂકવા. ");
INSERT INTO guj2017_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","પછી તે ઘેટાંનો વધ કરીને તેનું થોડું રક્ત લઈને હારુન અને તેના પુત્રોના જમણા કાનની બૂટીને, જમણા હાથનાં અંગૂઠાને તથા જમણા પગના અંગૂઠાને લગાડવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ત્યારબાદ બાકીનું રક્ત વેદીની ચારે બાજુ છાંટી દેવું. વેદી ઉપરના રક્તમાંથી થોડું રક્ત અને અભિષેકનું તેલ લઈ હારુન અને તેનાં વસ્ત્રો પર તથા તેના પુત્રો પર અને તેઓનાં વસ્ત્રો પર છાંટવું એટલે તેઓ તથા તેઓનાં વસ્ત્રો યહોવાહને અર્થે પવિત્ર ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","પછી ઘેટાંના ચરબીવાળા ભાગ લેવા; તેની પૂંછડી, અંદરના અવયવો પરની ચરબી, કાળજા પરની ચરબી અને ચરબી સાથે જ મૂત્રપિંડો અને જમણી જાંધ લેવી કારણ કે હારુન અને તેના દીકરાઓની દીક્ષા માટેનો આ ઘેટો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","યહોવાહ આગળના બેખમીર રોટલીના ટોપલામાંથી એક રોટલી, એક મોવણવાળી ભાખરી અને એક તેલ ચોપડેલી રોટલી લેવી. ");
INSERT INTO guj2017_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","એ બધું હારુનના અને તેના પુત્રોના હાથ પર મૂકવું અને એના વડે યહોવાહની આરાધના કરવી. ");
INSERT INTO guj2017_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","પછી તેઓના હાથમાંથી તું તે લઈ લે અને યહોવાહ સમક્ષ દહનીયાર્પણ તરીકે વેદી પર તેનું દહન કરજે. એની સુવાસથી હું પ્રસન્ન છું. એ મારા માનમાં કરેલું દહનીયાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","પછી હારુનની દીક્ષા માટે વપરાયેલા ઘેટાંની છાતી લઈને તેના વડે યહોવાહની ઉપાસના કરવી પછી એ તારો હિસ્સો ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","હારુન અને તેના પુત્રોની દીક્ષા માટે વપરાયેલાં અને જેના વડે ઉપાસના કરાઈ છે તે અને ભેટ ધરાવેલી ઘેટાંની છાતી અને જાંઘ તારે યાજકો માટે પવિત્ર કરીને અલગ રાખવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","તે હારુનનો તથા તેના પુત્રોનો ઇઝરાયલ પુત્રો પાસેથી સદાનો નિયમ થશે. કેમ કે તે ઉચ્છાલીયાર્પણ છે; અને તે ઇઝરાયલપુત્રો તરફથી તેઓનાં શાંત્યર્પણના યજ્ઞોનું ઉચ્છાલીયાર્પણ થાય, એટલે યહોવાહને સારુ તેઓનું ઉચ્છાલીયાર્પણ થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","હારુનનાં આ પવિત્ર વસ્ત્રો સાચવી રાખવાં અને હારુનના મૃત્યુ બાદ તેના પુત્રોને તે વારસામાં આપવાં. પેઢી દર પેઢી તેઓ પોતાની અભિષેકની દીક્ષાવિધિ વખતે તે પહેરે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","હારુન પછી જે કોઈ મુખ્ય યાજક થાય તે મુલાકાતમંડપમાં અને પવિત્રસ્થાનમાં સેવા શરૂ કરે તે અગાઉ સાત દિવસ સુધી આ વસ્ત્રો ધારણ કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","દીક્ષા માટે અર્પણ કરાયેલ ઘેટાંનું માંસ લઈને કોઈ શુદ્ધ જગ્યાએ તેને બાફવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ત્યારબાદ હારુન અને તેના પુત્રોએ મુલાકાતમંડપમાં પ્રવેશદ્વાર આગળ એ ઘેટાંનું માંસ અને ટોપલામાંની રોટલીનું ભોજન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","તેમની દીક્ષાવિધિ વખતે તેમની પ્રાયશ્ચિત વિધિ માટે ઉપયોગમાં લેવાયેલ પદાર્થો જ ખાવા; યાજકો સિવાય અન્ય કોઈ પણ અજાણ્યા વ્યક્તિએ તે ખાવા નહિ કારણ એ પવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","સવાર સુધી જો માંસ કે રોટલીમાંથી કાંઈ વધે તો તેને અગ્નિમાં બાળી મૂકવું પણ ખાવું નહિ, કારણ એ પવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","હારુન અને તેના પુત્રોને મેં જે આજ્ઞા કરી છે તે મુજબ જ કરવું. એમની દીક્ષાની વિધિ સાત દિવસ ચલાવવી. ");
INSERT INTO guj2017_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","દરરોજ પાપાર્થાર્પણ માટે એક વાછરડાનું બલિદાન આપવું. વેદી ઉપર પ્રાયશ્ચિત વિધિ કરવાથી તું એને પાપમુક્ત કરશે. ત્યાર પછી તારે વેદી પર તેલનો અભિષેક કરીને વેદીને પવિત્ર બનાવવી. ");
INSERT INTO guj2017_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","સાત દિવસ સુધી વેદીને શુદ્ધ અને પવિત્ર બનાવવી. ત્યાર બાદ વેદી સંપૂર્ણપણે અત્યંત પવિત્ર બનશે. પછી જો કોઈ તેના સંપર્કમાં આવશે તે પવિત્ર બની જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","તારે વેદી પર આટલા બલિ ચઢાવવા, કાયમને માટે પ્રતિદિન એક વર્ષની ઉંમરના બે હલવાન અર્પણ કરવા. ");
INSERT INTO guj2017_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","એક હલવાન તારે સવારમાં અને બીજું હલવાન તારે સાંજે ચઢાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","પ્રથમ ઘેટાં સાથે તમારે એક કિલો શુદ્ધ તેલમાં મોહેલો એક કિલો મેંદાનો ઝીણો લોટ તેમ જ પેયાર્પણ તરીકે એક લીટર દ્રાક્ષારસ અર્પણ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","સાંજે અર્પણ થતાં હલવાનની સાથે સવારની જેમ મેંદાના ઝીણા લોટનું અને દ્રાક્ષારસનું પેયાર્પણ કરજે. ઈશ્વરની સમક્ષ તે સુવાસિત અર્પણ અને અગ્નિમાં થયેલ અર્પણ ધ્યાનમાં લેવાશે. એ યજ્ઞની સુવાસથી હું પ્રસન્ન થાઉં છું. ");
INSERT INTO guj2017_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","આ દહનીયાર્પણ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ મારી નજર સમક્ષ નિયમિત પેઢી દર પેઢી કરવાના છે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","હું ત્યાં જ તમને મળીશ અને ઇઝરાયલીઓને પણ મળીશ. મારા મહિમાથી એ સ્થાન પવિત્ર થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","હા, હું મુલાકાતમંડપને, વેદીને અને યાજકો તરીકે મારા સેવકો હારુન તથા તેના પુત્રોને પવિત્ર કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","અને હું ઇઝરાયલના લોકો મધ્યે નિવાસ કરીશ અને તેઓનો ઈશ્વર થઈશ. ");
INSERT INTO guj2017_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","તેઓને ખાતરી થશે કે તેઓની વચ્ચે રહેવા માટે તેઓને મિસરમાંથી બહાર લાવનાર હું યહોવાહ તેઓનો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ધૂપ બાળવા માટે તારે બાવળના લાકડાની એક વેદી બનાવવી. ");
INSERT INTO guj2017_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","આ વેદી એક હાથ લાંબી, એક હાથ પહોળી અને બે હાથ ઊંચી હોય. તેનાં લાકડામાંથી જ કોતરીને તેના શિંગ બનાવવાં. શિંગ જુદાં બનાવીને વેદી પર જોડવાં નહિ. તે શિંગ વેદી સાથે સળંગ હોય. ");
INSERT INTO guj2017_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","વેદીનો ઉપરનો ભાગ, બાજુઓ અને શિંગ શુદ્ધ સોનાથી મઢી લેવાં અને આખી વેદીની ચારે બાજુ સોનાની કિનારી બનાવવી. ");
INSERT INTO guj2017_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","એની બે સામસામી બાજુઓએ કિનારીની નીચે ઉપાડવાના દાંડા ભેરવવા માટે સોનાનાં બબ્બે કડાં મૂકવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","એ બે દાંડા બાવળના લાકડાના બનાવવા અને સોનાથી મઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","દશ આજ્ઞાઓ જેમાં મૂકી છે તે કરારકોશ આગળના પડદા સામે એ વેદી મૂકવી. ત્યાં હું તેઓને દર્શન આપીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","એ વેદી પર પ્રતિદિન સવારે બત્તી તૈયાર કરતી વખતે હારુને સુગંધી ધૂપ બાળવો. ");
INSERT INTO guj2017_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","અને રોજ સાંજે તે બત્તીઓ પ્રગટાવે ત્યારે યહોવાહની સંમુખ ધૂપ બાળવો. તારે પેઢી દર પેઢી કાયમ યહોવાહ સમક્ષ ધૂપ બાળવો. ");
INSERT INTO guj2017_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","તારે એ વેદી પર અન્ય ધૂપ બાળવો નહિ કે દહનીયાર્પણ, ખાદ્યાર્પણ કે પેયાર્પણ ચઢાવવાં નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","વર્ષમાં એક વાર હારુને પ્રાયશ્ચિતને માટે પાપાર્થાર્પણનું રક્ત લઈને શિંગ ઉપર લગાડી વેદીને પવિત્ર કરવાની છે. પેઢી દર પેઢી નિયમિત રીતે આ વાર્ષિક વિધિનું પાલન કરવું, કારણ કે આ વેદી યહોવાહની પરમપવિત્ર વેદી છે. ");
INSERT INTO guj2017_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“તું જ્યારે ઇઝરાયલીઓની વસ્તીગણતરી કરે ત્યારે જે પુરુષોનું નામ નોંધાય તેણે જ પોતાના જીવનાં બદલામાં યહોવાહ સમક્ષ ખંડણી ભરવી, જેથી તું ગણતરી કરે ત્યારે લોકો પર કોઈ આફત ન આવે. ");
INSERT INTO guj2017_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","વસ્તીગણતરીમાં નોંધાયેલા બધા માણસોએ યહોવાહને અડધો શેકેલ (શેકેલનો માપ વીસ ગેરહ હોય છે) અર્પણ તરીકે આપવો. ");
INSERT INTO guj2017_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","વસ્તીગણતરીમાં નોંધાયેલા વીસ વર્ષના કે તેથી વધુ ઉંમરના દરેક માણસે આ પ્રમાણે અર્પણ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","મને તમારા જીવનના બદલામાં આ અર્પણ આપતી વખતે ધનવાને વધારે કે ગરીબે ઓછું આપવાનું નથી. ");
INSERT INTO guj2017_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ઇઝરાયલીઓ પાસેથી મળેલાં જીવના બદલામાં અર્પણ કરેલાં પ્રાયશ્ચિતનાં નાણાં મુલાકાતમંડપની સેવામાં ખર્ચવાં. આ અર્પણ ઇઝરાયલી લોકોને માટે યહોવાહની સમક્ષતામાં સ્મરણરૂપ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“હાથપગ ધોવા તારે પિત્તળના તળિયાવાળી પિત્તળની કૂડી બનાવવી. અને તેને વેદી અને મુલાકાતમંડપની વચ્ચે મૂકીને તેમાં પાણી ભરવું. ");
INSERT INTO guj2017_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","હારુને અને તેના પુત્રોએ હાથપગ ધોવામાં એ પાણીનો ઉપયોગ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","જો તેમણે એ પાણીથી હાથપગ ધોયા હશે તો તેઓ મુલાકાતમંડપમાં સેવા કરવા જશે અથવા અર્પણ ચઢાવવા વેદી પાસે જશે ત્યારે તેઓ મૃત્યુ પામશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","તેઓ મૃત્યુ ન પામે તેટલાં માટે તેઓએ અચૂક હાથપગ ધોવા. આ કાનૂન તેમણે અને તેમના વંશજોએ પેઢી દર પેઢી પાળવાનો રહેશે. હારુન અને તેના પુત્રો માટે આ સૂચનાઓ છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“તારે શ્રેષ્ઠ ગુણવત્તાવાળી સુગંધીઓ લેવી, એટલે પાંચસો શેકેલ ચોખ્ખો બોળ, અઢીસો શેકેલ સુગંધીદાર તજ, અઢીસો સુગંધીદાર બરુ, ");
INSERT INTO guj2017_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","પાંચસો શેકેલ દાલચીની એ બધું પવિત્રસ્થાનના શેકેલ પ્રમાણે લેવું. વળી જૈતૂનનું એક કેન તેલ લેવું. ");
INSERT INTO guj2017_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","નિષ્ણાત સુગંધીઓ બનાવનારાઓ પાસે આ સર્વ પદાર્થોનું મિશ્રણ કરીને અભિષેકનું તેલ તૈયાર કરાવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","અભિષેકના તેલથી તું મુલાકાતમંડપને, કરારકોશને, ");
INSERT INTO guj2017_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","બાજઠ તથા તેની બધી સામગ્રીઓને, દીવીને અને તેનાં સાધનોને, ધૂપની વેદીને, ");
INSERT INTO guj2017_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","દહનીયાર્પણની વેદીને અને તેનાં સાધનોને તથા ઘોડી સહિત હાથપગ ધોવાની કૂંડીને અભિષેક કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","આ પ્રમાણે આ બધી વસ્તુઓ પવિત્ર કર એટલે તે બધી પરમપવિત્ર બની જશે. અને જે કોઈ તેમને સ્પર્શ કરશે તે પવિત્ર થશે. ");
INSERT INTO guj2017_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ત્યાર પછી તારે હારુનને અને તેના પુત્રોનો અભિષેક કરીને મારા યાજકો તરીકે તેઓને પવિત્ર કર. ");
INSERT INTO guj2017_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","તારે ઇઝરાયલીઓને કહેવું, ‘તમારે પેઢી દર પેઢી આ મારે માટે અભિષેકનું તેલ થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","તે માણસોના શરીરે ન લગાડાય અને તેના જેવું બીજું તેલ તમારે બનાવવું નહિ, કેમ કે એ પવિત્ર તેલ છે અને તમારે માટે એ પવિત્ર ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","જે કોઈ આ સુગંધીઓનું મિશ્રણ કરી આવું તેલ બનાવે અથવા જે યાજક નથી તેવી કોઈ વ્યક્તિ ઉપર તે રેડે, તેને તેના સમાજમાંથી જુદો કરવામાં આવે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","યહોવાહે મૂસાને કહ્યું, “તારે મિષ્ટ સુગંધીઓ વાપરવી નાટાફ, શહેલેથ, હેલ્બના અને શુદ્ધ લોબાન પ્રત્યેકને સરખે ભાગે લેવાં. ");
INSERT INTO guj2017_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","તેના મિશ્રણમાંથી સુગંધી ધૂપ બનાવવો. આ ધૂપ નિષ્ણાત કારીગર બનાવતો હોય તે રીતે બનાવવો. એ ધૂપને શુદ્ધ અને પવિત્ર રાખવા તેમાં મીઠું મેળવવું. ");
INSERT INTO guj2017_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","એમાંથી થોડો ભાગ ઝીણો ખાંડીને તેનો ઉપયોગ મુલાકાતમંડપમાં કરારકોશ આગળ, જયાં હું તને દર્શન આપવાનો છું ત્યાં કરવો. તમારે આ ધૂપને અત્યંત પવિત્ર માનવો. ");
INSERT INTO guj2017_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","આ વિધિ પ્રમાણેનો જ ધૂપ બને તેવી બનાવટનો ધૂપ તમે તમારા પોતાના ઉપયોગ માટે બનાવશો નહિ. તમારે તો તેને પવિત્રવસ્તુ જ ગણવી. ");
INSERT INTO guj2017_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","તેના જેવો ધૂપ જે કોઈ સૂંઘવાને માટે બનાવે, તેને તેના સમાજમાંથી અલગ કરવામાં આવે.” ");
INSERT INTO guj2017_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","વળી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“જુઓ, મેં યહૂદાના કુળના હૂરના દીકરા ઉરીના દીકરા બસાલેલને નામ લઈને બોલાવ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","બુદ્ધિ, સમજણ, ડહાપણ તથા સર્વ પ્રકારના કળાકૌશલ્યની બાબતમાં મેં તેને ઈશ્વરના આત્માથી ભરપૂર કર્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","એ માટે કે તે હોશિયારીથી નમૂનો તૈયાર કરે અને સોનામાં, ચાંદીમાં, પિત્તળમાં, ");
INSERT INTO guj2017_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","જડવાને માટે પાષાણ કોતરવામાં તથા લાકડામાં નકશી કોતરવામાં અને સર્વ પ્રકારની કારીગરીમાં તે કામ કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","વળી તેની સાથે કામ કરવા માટે મેં દાનના કુળના અહીસામાખના દીકરા આહોલીઆબને પસંદ કર્યો છે. જે બુદ્ધિમાન છે તે સર્વનાં હૃદયોમાં મેં બુદ્ધિ મૂકી છે, એ માટે કે મેં તને જે આજ્ઞા આપી છે તે પ્રમાણે તે સર્વ તેઓ બનાવે. ");
INSERT INTO guj2017_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","આ સાથે મુલાકાતમંડપ, કરારકોશ, તે પરનું દયાસન, મંડપનો સરસામાન; ");
INSERT INTO guj2017_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","બાજઠ અને તેનાં પરની સામગ્રી, શુદ્ધ સોનાની દીવી અને તેનાં સાધનો, ધૂપ કરવાની વેદી, ");
INSERT INTO guj2017_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","દહનીયાર્પણની વેદી અને તેનાં બધાં સાધનો, હાથપગ ધોવાની કુંડી અને તેનું તળિયું. ");
INSERT INTO guj2017_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","યાજક હારુન અને તેના પુત્રો માટે સેવા સમયે પહેરવાનાં પવિત્ર પોષાક, ");
INSERT INTO guj2017_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","અભિષેક માટેનું તેલ અને પવિત્રસ્થાનને માટે સુગંધીદાર ધૂપ; તે સર્વ સંબંધી મેં તને જે આજ્ઞાઓ આપી છે તે પ્રમાણે તેઓ કરે.” ");
INSERT INTO guj2017_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ઇઝરાયલી લોકોને કહે: ‘તમે જરૂર મારા વિશ્રામવારો પાળો, કેમ કે તમારી પેઢી દરપેઢી મારી અને તમારી વચ્ચે તે ચિહ્નરૂપ છે; એ માટે કે તમે જાણો કે તમને પવિત્ર કરનાર તે હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","આથી તમારે વિશ્રામવારનું પાલન કરવાનું છે, કારણ કે તમારા માટે એ પવિત્ર દિવસ છે. જે કોઈ તેની પવિત્રતાનો ભંગ કરે, તેને મોતની સજા કરવી. જે કોઈ વિશ્રામવારે કામ કરે તેનો સમાજમાંથી બહિષ્કાર કરજો. ");
INSERT INTO guj2017_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","તમને છ દિવસ કામ કરવાની છૂટ છે, પણ સાતમે દિવસે યહોવાહને માટે પવિત્ર એવો સંપૂર્ણ વિશ્રામનો સાબ્બાથ છે. જે કોઈ વિશ્રામવારે કોઈ પણ કામ કરે તેને મોતની સજા કરવી. ");
INSERT INTO guj2017_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","માટે ઇઝરાયલના લોકોએ મારી અને તેઓની વચ્ચેના કરાર તરીકે વિશ્રામવાર પેઢી દર પેઢી પાળવાનો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","સાબ્બાથ યહોવાહ અને ઇઝરાયલી લોકોની વચ્ચે હંમેશના ચિહ્નરૂપ છે, કેમ કે યહોવાહે છ દિવસ સુધી આકાશ અને પૃથ્વીની રચના કરી અને સાતમે દિવસે તેમણે કામ બંધ રાખીને વિસામો લીધો.’” ");
INSERT INTO guj2017_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","તેમણે સિનાઈ પર્વત ઉપર મૂસાની સાથે વાતચીત પૂરી કરીને તેને બે કરારપાટી, એટલે ઈશ્વરની આંગળીથી લખેલી બે શિલાપાટીઓ આપી. ");
INSERT INTO guj2017_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","જ્યારે લોકોએ જોયું કે મૂસાને પર્વત પરથી ઊતરતાં વિલંબ થાય છે, ત્યારે તેઓ હારુનની પાસે એકઠા થયા અને તેને કહ્યું, “ચાલ, અમને દોરવણી આપવા માટે અમારે માટે દેવ બનાવ. કારણ કે જે માણસ અમને મિસર દેશમાંથી કાઢી લાવ્યો તે મૂસાનું શું થયું, તે અમે જાણતા નથી.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","એટલે હારુને તેમને કહ્યું, “તમારી પત્નીઓના, તમારા દીકરાઓના તથા તમારી દીકરીઓના કાનોમાં જે સોનાની કડીઓ છે, તે કાઢીને મારી પાસે લાવો.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","તેથી સર્વ લોકો પોતાના કાનોમાં સોનાની જે કડીઓ હતી તે કાઢીને હારુન પાસે લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","હારુને કડીઓ લઈને તે ઓગાળી અને ધાતુના બીબામાં ઢાળીને વાછરડાની એક મૂર્તિ બનાવી એટલે લોકો બોલી ઊઠ્યા, “હે ઇઝરાયલ, મિસર દેશમાંથી તને કાઢી લાવનાર ઈશ્વર તે આ છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","હારુને જોયું કે લોકો બહુ આનંદમાં આવી ગયા છે, તેથી તેની આગળ હારુને વેદી બાંધી અને એવી જાહેરાત કરી કે, “આવતી કાલે યહોવાહના માનમાં ઉત્સવ પાળવામાં આવશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","બીજે દિવસે સવારમાં વહેલા ઊઠીને લોકોએ દહનીયાર્પણ અને શાંત્યર્પણો ચઢાવ્યાં અને ત્યાર પછી તેઓએ ખાધું પીધું અને મોજમજા કરવા લાગ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","પછી યહોવાહે મૂસાને કહ્યું, “જા જલ્દીથી નીચે જા, કારણ કે તારા જે લોકોને તું મિસરમાંથી બહાર લઈ આવ્યો છે, તેઓ ભ્રષ્ટ થઈ ગયા છે. ");
INSERT INTO guj2017_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","મેં તેઓને જે માર્ગે ચાલવાની આજ્ઞા કરી હતી તેનાથી આટલા વહેલા તેઓ ફરી ગયા છે. તેઓએ પોતાના માટે વાછરડાની એક મૂર્તિ બનાવી છે, તેની પૂજા કરી છે અને તેને અર્પણ ચઢાવ્યા. તેઓએ કહ્યું, ‘હે ઇઝરાયલ, તને મિસરમાંથી બહાર લઈ આવનાર દેવ તે આ છે.’” ");
INSERT INTO guj2017_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","પછી યહોવાહે મૂસાને કહ્યું, “મેં આ લોકોને જોયા છે અને જો, તે તો હઠીલા લોકો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","હવે પછી તું મને અટકાવીશ નહિ. મારો ક્રોધ તેઓ પર તપી ઊઠે અને હું તેઓનો નાશ કરીશ. પછી હું તારાથી એક મોટી દેશજાતિ ઉત્પન્ન કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","પરંતુ મૂસાએ ઈશ્વર યહોવાહને વિનંતી કરીને કહ્યું કે, “હે યહોવાહ, તમારા જે લોકોને તમે મોટા પરાક્રમ વડે તથા બળવાન હાથે મિસર દેશમાંથી કાઢી લાવ્યા છો, તેઓની વિરુદ્ધ તમારો કોપ કેમ તપી ઊઠે છે? ");
INSERT INTO guj2017_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","મિસરીઓ શા માટે આ પ્રમાણે બોલે કે, ‘તમે તેઓનું નુકસાન કરવાને માટે, એટલે પર્વતોમાં મારી નાખવા તથા પૃથ્વીની પીઠ પરથી તેઓનો સંહાર કરવા કાઢી લાવ્યા?’ તમારા બળતા કોપથી ફરો અને તમારા લોકો પર આફત લાવવાનો ઇરાદો ફેરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","તમારા સેવકો, ઇબ્રાહિમ, ઇસહાક તથા ઇઝરાયલને આપેલું તમારું વચન યાદ કરો. તમે જે વચન કહ્યું હતું, ‘આકાશના તારાઓના જેટલા હું તારા સંતાન વધારીશ. અને તારા વંશજોને જે દેશ આપવાનું મેં વચન આપ્યું છે તે સમગ્ર દેશ હું તેઓને આપીશ. તેઓ સદાસર્વદા તેના વારસદાર બનશે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","પછી જે આફત યહોવાહે પોતાના લોકો પર લાવવાનું કહ્યું હતું તે વિષે તેમણે પોતાનું મન ફેરવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","પછી મૂસા પાછો ફરીને પર્વત પરથી નીચે ઊતર્યો અને કરારના બે શિલાપાટી તેના હાથમાં હતી. તે પાટીઓની બન્ને બાજુએ, એટલે આગળ પાછળ એમ બન્ને બાજુએ દશ આજ્ઞાઓ લખેલી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","તે શિલાપાટીઓ ઈશ્વરની કૃતિ હતી અને પાટી પર કોતરેલો લેખ, તે ઈશ્વરનો લેખ હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","જયારે યહોશુઆએ લોકોની બૂમાબૂમનો અવાજ સાંભળ્યો, ત્યારે તેણે મૂસાને કહ્યું, “છાવણીમાં લડાઈનો ઘોંઘાટ થાય છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","પણ મૂસાએ કહ્યું, “આ કોઈ વિજયનો નાદ નથી, તેમ પરાજયનો પોકાર પણ નથી, પણ આ તો ગાવાનો અવાજ સંભળાય છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","જ્યારે મૂસા છાવણી પાસે પહોંચ્યો, ત્યારે વાછરડું અને નાચગાન જોયાં. મૂસાનો ક્રોધ ભભૂકી ઊઠ્યો. તેણે પોતાના હાથમાંથી શિલાપાટીઓ ફેંકી દીધી તેથી તે પર્વતની નીચે ભાંગી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","તે લોકોએ જે વાછરડું બનાવ્યું હતું તે લઈને તેણે અગ્નિમાં ઓગળી નંખાવ્યું અને તેને વાટીને ભૂકો કર્યો અને પાણીમાં ભભરાવીને ઇઝરાયલી લોકોને તે પાણી પીવડાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","પછી મૂસાએ હારુનને કહ્યું, “આ લોકોએ તારું શું બગાડ્યું છે કે તું તેઓના પર આવું મોટું પાપ લાવ્યો છે?” ");
INSERT INTO guj2017_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","હારુને કહ્યું, “મારા માલિકનો ક્રોધ ન સળગે; તું લોકોને જાણે છે કે તેઓનું વલણ તો દુષ્ટતા તરફ છે. ");
INSERT INTO guj2017_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","એ લોકોએ મને કહ્યું, ‘અમને દોરવણી આપવા માટે દેવ બનાવી આપ. કારણ કે અમને મિસર દેશમાંથી બહાર લાવનાર મૂસાનું શું થયું તે અમે જાણતા નથી.’ ");
INSERT INTO guj2017_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","એટલે મેં તેઓને કહ્યું, ‘તમારામાંથી જેમની પાસે સોનાનાં ઘરેણાં હોય તે ઉતારી નાખો. તેઓએ મને સોનાનાં ઘરેણાં આપ્યા અને મેં તે અગ્નિમાં નાખ્યાં એટલે તેમાંથી આ વાછરડું નીકળી આવ્યું.’” ");
INSERT INTO guj2017_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","મૂસાએ જોયું કે હારુને લોકો પરનો પોતાનો કાબૂ જવા દીધો અને પરિણામે તેઓને હાસ્યપાત્ર થવા દીધા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","પછી મૂસાએ છાવણીના પ્રવેશદ્વાર આગળ ઊભા રહીને મોટા અવાજે પોકાર કર્યો. “યહોવાહના પક્ષમાં હોય તે મારી પાસે આવે.” એટલે સર્વ લેવીઓ તેની પાસે ભેગા થઈ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","તેણે તેઓને કહ્યું, “ઇઝરાયલનો ઈશ્વર યહોવાહ એમ કહે છે: ‘તમે બધા પોતપોતાની તલવાર લઈને સજ્જ થઈ જાઓ, છાવણીમાં બધે ફરી વળો અને તમારા ભાઈઓ, મિત્રો અને પડોશીઓને મારી નાખો.’” ");
INSERT INTO guj2017_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","લેવીઓએ મૂસાના કહ્યા પ્રમાણે કર્યું. તે દિવસે લોકોમાંથી લગભગ ત્રણ હજાર પુરુષો માર્યા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","મૂસાએ લેવીઓને કહ્યું, “આજે પ્રત્યેક માણસ પોતાના દીકરાની વિરુદ્ધ તથા પોતાના ભાઈની વિરુદ્ધ યહોવાહને અર્પિત થઈ જાઓ, જેથી યહોવાહ આજે તમને આશીર્વાદ આપે.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","બીજે દિવસે મૂસાએ લોકોને કહ્યું, “તમે મહાપાપ કર્યું છે. હવે હું યહોવાહ પાસે જાઉં છું. કદાચ હું તમારા પાપની માફી મેળવી શકું.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","આમ કહીને મૂસાએ ફરી યહોવાહ પાસે જઈને કહ્યું, “અરે આ લોકોએ મોટું પાપ કર્યું છે અને પોતાને માટે સોનાનો દેવ બનાવ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","પણ તમે તેઓના પાપને માફ કરો તો સારું; પણ જો નહિ તો તમારા લખેલા પુસ્તકમાંથી મારું નામ ભૂંસી નાખો.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","યહોવાહે મૂસાને કહ્યું, “જેણે મારી વિરુદ્ધ પાપ કર્યું હશે, તેનું નામ હું મારા પુસ્તકમાંથી ભૂંસી નાખીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","હવે ચાલ જે જગ્યા વિષે મેં તને કહ્યું છે, ત્યાં આ લોકોને દોરી જા. જો, મારો દૂત તારી આગળ ચાલશે. પણ જે દિવસે હું તેઓને જોઈ લઈશ, તે દિવસે હું તેઓના પાપને લીધે તેઓને શિક્ષા કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","પછી હારુને બનાવેલા વાછરડાની પૂજા કરવા બદલ યહોવાહે લોકોને આકરી સજા કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","યહોવાહે મૂસાને કહ્યું, “તું અહીંથી જા અને જે લોકોને તું મિસર દેશમાંથી બહાર લઈ આવ્યો છે, તેઓને લઈને જે દેશ વિષે મેં ઇબ્રાહિમ, ઇસહાક તથા યાકૂબને સમ ખાઈને કહ્યું, ‘તારા સંતાનને હું તે આપીશ,’ તે દેશમાં જા. ");
INSERT INTO guj2017_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","હું તારી આગળ મારા એક દૂતને મોકલીશ અને કનાનીઓ, અમોરીઓ, હિત્તીઓ, પરિઝીઓ, હિવ્વીઓ તથા યબૂસીઓને હાંકી કાઢીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","એટલે દૂધ તથા મધથી રેલછેલવાળો દેશમાં જા. તું તો હઠીલી પ્રજા છે, માટે હું તારી મધ્યે ચાલીશ નહિ, રખેને હું રસ્તામાં તારો સંહાર કરું.” ");
INSERT INTO guj2017_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","જ્યારે લોકોએ આ કઠોર શબ્દો સાંભળ્યા ત્યારે તેઓએ શોક કર્યો અને કોઈએ પોતાના શરીર ઉપર દાગીના પહેર્યાં નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","યહોવાહે મૂસાને કહ્યું, “ઇઝરાયલી લોકોને કહે કે, ‘તમે લોકો હઠીલા છો. જો હું તમારી સાથે એ પળવાર પણ આવું તો તમારો સંહાર કરી નાખું. એટલે તમે તમારાં ઘરેણાં ઉતારી નાખો કે, મારે તને શું કરવું તે હું જાણું.’ ");
INSERT INTO guj2017_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","તેથી હોરેબ પર્વતથી માંડીને ઇઝરાયલી લોકોએ પોતાનાં ઘરેણાં ઉતારી મૂક્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","મૂસા મંડપ લઈને છાવણી બહાર દૂર તે માંડવો ઊભો કરતો હતો અને તેણે તેનું નામ મુલાકાતમંડપ પાડ્યું. યહોવાહને શોધનાર પ્રત્યેક માણસ નીકળીને છાવણી બહારના મુલાકાતમંડપમાં જતો. ");
INSERT INTO guj2017_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","મૂસા જ્યારે જ્યારે મૂલાકાતમંડપમાં જતો ત્યારે ત્યારે બધા લોકો ઊઠીને પોતપોતાના તંબુના દરવાજા આગળ ઊભા રહીને, મૂસા મૂલાકાતમંડપમાં દાખલ થાય ત્યાં સુધી તેને જોઈ રહેતા. ");
INSERT INTO guj2017_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","મૂસા જ્યારે મંડપમાં પ્રવેશ કરતો ત્યારે વાદળનો સ્તંભ નીચે ઊતરી માંડવાના દરવાજા આગળ ઊભો રહેતો અને યહોવાહ મૂસા સાથે વાત કરતા. ");
INSERT INTO guj2017_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","વાદળના સ્તંભને દરવાજા આગળ જોતાં જ દરેક માણસ પોતપોતાના માંડવાના દરવાજા આગળ ભજન કરતા. ");
INSERT INTO guj2017_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","યહોવાહ મૂસા સાથે એક માણસ બીજા માણસ સાથે વાત કરે એ રીતે મુખોપમુખ વાત કરતા. ત્યાર પછી મૂસા પાછો છાવણીમાં આવતો, પણ તેનો નવયુવાન સેવક નૂનનો દીકરો યહોશુઆ કદી મંડપમાંથી બહાર નીકળતો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","મૂસાએ યહોવાહને કહ્યું, “તમે મને કહો છો, ‘આ લોકોને દોરી લઈ જાઓ,’ પણ મારી સાથે તમે કોને મોકલશો તે તમે મને જણાવ્યું નથી. પણ તમે કહ્યું, ‘હું તને નામથી ઓળખું છું અને મારી દ્રષ્ટિમાં તું કૃપા પામ્યો છે.’ ");
INSERT INTO guj2017_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","હવે જો તમારી દ્રષ્ટિમાં હું કૃપા પામ્યો હોઉં, તો કૃપા કરીને મને તમારા માર્ગ જણાવજો કે, હું તમને ઓળખું, એ માટે તે તમારા લોકો છે એ તમે લક્ષમાં લો.” ");
INSERT INTO guj2017_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","યહોવાહે જવાબ આપ્યો, “મારી સમક્ષતા તારી સાથે આવશે અને હું તને વિસામો આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","મૂસાએ તેને કહ્યું હતું, “જો તમારી સમક્ષતા મારી સાથે ન આવે તો અહીંથી આમને લઈ ન જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","કેમ કે હવે કેમ જણાય કે હું તથા તમારા લોકો તમારી દ્રષ્ટિમાં કૃપા પામ્યા છીએ? શું એથી નહિ કે તમે અમારી સાથે આવો છો, એથી હું તથા તમારા લોકો પૃથ્વી ઉપરના સર્વ લોકોથી જુદા છીએ?” ");
INSERT INTO guj2017_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","યહોવાહે મૂસાને કહ્યું, “હા, તેં જે માંગ્યું છે તે હું ચોક્કસ આપીશ, કારણ કે તું મારી દ્રષ્ટિમાં કૃપા પામ્યો છે અને હું તને નામથી ઓળખું છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","મૂસાએ કહ્યું, “કૃપા કરીને તમારું ગૌરવ મને દેખાડો.” ");
INSERT INTO guj2017_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","યહોવાહે કહ્યું, “હું મારી સંપૂર્ણ ભલાઈ તારા મુખ આગળથી પસાર કરીશ અને તારી સમક્ષ મારું નામ ‘યહોવાહ’ તરીકે જાહેર કરીશ. હું જેના પર કૃપા કરવા ચાહું તેના પર હું કૃપા કરીશ અને જેના પર રહેમ કરવા ચાહું તેના પર રહેમ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","પણ યહોવાહે કહ્યું, “તું મારું મુખ જોઈ શકીશ નહિ, કારણ કે, કોઈ પણ માણસ મને જોઈને જીવતો રહી શકે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","યહોવાહે કહ્યું, “જો મારી પાસે એક જગ્યા છે અને તું ખડક પર ઊભો રહે. ");
INSERT INTO guj2017_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","મારું ગૌરવ તારી નજર આગળથી પસાર થાય ત્યારે હું તને આ ખડકની ફાટમાં રાખીશ અને હું પોતે પસાર થઈ જાઉં ત્યાં સુધી મારા હાથ વડે તને હું ઢાંકી દઈશ. ");
INSERT INTO guj2017_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","પછી હું મારો હાથ લઈ લઈશ અને તું મારી પીઠ જોવા પામીશ, પણ મારું મુખ તને દેખાશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","યહોવાહે મૂસાને કહ્યું, “પ્રથમના જેવી જ પથ્થરની બે શિલાપાટીઓ બનાવ. અને તારાથી ભાંગી ગયેલી પાટીઓ પર જે શબ્દો લખેલા હતા, તે હું આ પાટીઓ પર લખીશ. ");
INSERT INTO guj2017_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","સવારમાં સિનાઈ પર્વત ઉપર આવવા માટે તું તૈયાર રહેજે અને સિનાઈ પર્વતના શિખર પર ચઢી શિખર પર મારી રાહ જોતો ઊભો રહેજે. ");
INSERT INTO guj2017_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","તારી સાથે કોઈ ઉપર ના આવે. તેમ જ પર્વત પર કોઈ માણસ દેખાય નહિ. તેમ જ પર્વતની આસપાસ ઘેટાંબકરાં કે જાનવરો પણ ચરતાં હોવા જોઈએ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","મૂસાએ પ્રથમની પાટીઓના જેવી જ પથ્થરની બે શિલાપાટીઓ બનાવી અને સવારમાં તે વહેલો ઊઠ્યો અને યહોવાહે તેને જેમ કહ્યું હતું તે પ્રમાણે તેના હાથમાં શિલાપાટીઓ લઈને તે સિનાઈ પર્વત પર ચઢી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","યહોવાહ મેઘસ્તંભના રૂપમાં નીચે ઊતરી આવ્યા અને તેની સાથે ત્યાં ઊભા રહ્યા અને તેમણે પોતાનું નામ “યહોવાહ” જાહેર કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","યહોવાહ તેની આગળથી જાહેર કરતા પસાર થયા કે, “યહોવાહ, યહોવાહ દયાળુ તથા કૃપાળુ ઈશ્વર, ક્રોધ કરવામાં ધીમા અને કરૂણાથી ભરપૂર તથા વિશ્વાસપાત્ર છું. ");
INSERT INTO guj2017_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","હું યહોવાહ હજારો પેઢી સુધી કરૂણા રાખનાર, અન્યાય, ઉલ્લંઘન તથા પાપની ક્ષમા કરનાર અને દોષિતને નિર્દોષ નહિ જ ઠરાવનાર; પિતાના અધર્મની સજા ત્રીજી અને ચોથી પેઢી સુધી છોકરાંના છોકરાં પર બદલો વાળનાર છું.” ");
INSERT INTO guj2017_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","મૂસાએ એકદમ જમીન પર લાંબા થઈને સાષ્ટાંગ નમસ્કાર કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","પછી તેણે કહ્યું, “હે પ્રભુ યહોવાહ, જો હું તમારી દ્રષ્ટિમાં કૃપા પામ્યો હોઉં તો કૃપા કરીને યહોવાહ અમારી મધ્યે ચાલે, કેમ કે આ લોકો તો હઠીલા છે. અમારો અધર્મ અને અમારાં પાપ માફ કરો અને અમોને તમારો વારસો કરી લો.” ");
INSERT INTO guj2017_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","યહોવાહે કહ્યું, “જો, હું કરાર કરું છું. આખી પૃથ્વી પર તથા કોઈ પણ પ્રજામાં કદી કરાયાં ન હોય એવાં આશ્ચર્યકૃત્યો તારા સર્વ લોકોની આગળ હું કરીશ. જે લોકોમાં તું રહે છે તે બધા યહોવાહનું કામ જોશે, કેમ કે તારા સંબંધી જે કામ હું કરવાનો છું તે ભયંકર છે. ");
INSERT INTO guj2017_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","હું આજે તને જે આજ્ઞા આપું છું તે તું પાળ. જો હું અમોરીઓને, કનાનીઓને, હિત્તીઓને, પરિઝીઓને, હિવ્વીઓને તથા યબૂસીઓને તારી આગળથી કાઢી મૂકું છું. ");
INSERT INTO guj2017_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","જો, જે દેશમાં તું જાય તેના રહેવાસીઓ સાથે તું કરાર ન કરતો, રખેને તારી મધ્યે તે ફાંદારૂપ થઈ પડે. ");
INSERT INTO guj2017_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","તેના બદલે, તમારે તેઓની વેદીઓ તોડી પાડવી, તેના સ્તંભોને ભાંગી નાખવા અને તેમની અશેરા મૂર્તિઓને કાપી નાખવી. ");
INSERT INTO guj2017_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","કેમ કે તારે કોઈ અન્ય દેવની પૂજા કરવી નહિ, કેમ કે હું યહોવાહ છું, મારું નામ ‘ઈર્ષ્યાળુ’ છે. હું મારા માન કોઈ બીજાને આપવા ન દઉં એવો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","તારે દેશના રહેવાસીઓની સાથે કરાર કરવો નહિ. તેઓ વ્યભિચાર કરે છે તથા તેમના દેવોની પાછળ ભટકી જઈને તેમના દેવોને યજ્ઞ ચઢાવે છે અને કોઈના આમંત્રણથી તું તેના અર્પણમાંથી ખાય. ");
INSERT INTO guj2017_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","રખેને તું તેઓની દીકરીઓ સાથે તારા દીકરાઓના લગ્ન કરાવે અને તેમની દીકરીઓ વ્યભિચાર કરશે અને તેઓના દેવોની પાછળ ભટકી જઈને તારા દીકરાઓને તેઓના દેવોની પાછળ ભટકાવી દે. ");
INSERT INTO guj2017_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","તું પોતાને માટે કોઈ દેવની ઢાળેલી મૂર્તિ ન બનાવ. ");
INSERT INTO guj2017_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","તું બેખમીરી રોટલીનું પર્વ પાળ. જેમ મેં તને આજ્ઞા આપી છે તે પ્રમાણે આબીબ માસમાં નિયુક્ત કરેલ સમયના સાત દિવસો સુધી તું બેખમીરી રોટલી ખા, કેમ કે તુ આબીબ માસમાં મિસર દેશમાંથી નીકળ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","સર્વ પ્રથમજનિત મારા છે, એટલે તારા સર્વ નર પશુઓ, બળદો તથા ઘેટાંબકરાંનાં પ્રથમજનિત. ");
INSERT INTO guj2017_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ગધેડાના પહેલા વાછરડાને તું હલવાન વડે ખંડી લે, પણ જો તેને ખંડી લેવો ન હોય તો તું તેની ગરદન ભાંગી નાખ. તારા સર્વ પ્રથમજનિત દીકરાઓને તું ખંડી લે. અને મારી આગળ કોઈ ખાલી હાથે હાજર ન થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","છ દિવસ તારે કામ કરવું, પણ સાતમાં દિવસે તારે આરામ કરવો. ખેડવાના અને કાપણીના સમયે પણ તારે આરામ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","તું અઠવાડિયાનું પર્વ, એટલે ઘઉંની કાપણીના પ્રથમ ફળનું તથા વર્ષના છેલ્લાં સંગ્રહનું પર્વ પાળ. ");
INSERT INTO guj2017_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","દર વર્ષે તારા સઘળા પુરુષો ઇઝરાયલના ઈશ્વર યહોવાહની આગળ ત્રણવાર હાજર થાય. ");
INSERT INTO guj2017_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","કેમ કે હું તારી આગળથી દેશ જાતિઓને હાંકી કાઢીશ અને તારી સીમાઓ વધારીશ. જ્યારે તું ત્રણવાર ઈશ્વર તારા યહોવાહની આગળ હાજર થવાને જશે, ત્યારે કોઈ પણ માણસ તારી જમીનનો લોભ કરશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","ખમીર સાથે તું મારા યજ્ઞનું રક્ત ન ચઢાવીશ, તેમ જ પાસ્ખા પર્વનો યજ્ઞ સવાર સુધી પડ્યો ન રહે. ");
INSERT INTO guj2017_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","તારી જમીનનું પ્રથમ ફળ તું ઈશ્વર તારા યહોવાહના ઘરમાં લાવ. તું બકરીનું બચ્ચું તેની માતાના દૂધમાં બાફીશ નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","યહોવાહે મૂસાને કહ્યું, “તું આ વચનો લખ, કેમ કે આ વચનો પ્રમાણે મેં તારી સાથે વાત કરી છે અને તારી તથા ઇઝરાયલીઓની સાથે કરાર કર્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","મૂસા ત્યાં યહોવાહ ની સાથે ચાળીસ દિવસ તથા ચાળીસ રાત હતો; તેણે રોટલી ખાધી ન હતી, તેમ જ પાણી પણ પીધું ન હતું. તેણે શિલાપાટીઓ ઉપર કરારના શબ્દો, એટલે દશ આજ્ઞાઓ લખી. ");
INSERT INTO guj2017_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","જયારે મૂસા સિનાઈ પર્વત પરથી ઊતર્યો, ત્યારે તેના હાથમાં કરારના બે શિલાપાટીઓ હતી, મૂસા જાણતો ન હતો કે તેનો પોતાનો ચહેરો ઈશ્વર સાથે વાત કર્યાને લીધે પ્રકાશતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","જયારે હારુન તથા સર્વ ઇઝરાયલીઓએ મૂસાને જોયો, ત્યારે તેનો ચહેરો પ્રકાશતો હતો અને તેઓ તેની પાસે આવતાં ગભરાતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","પણ મૂસાએ તેઓને બોલાવ્યા અને હારુન તથા સભાના સર્વ અધિકારીઓ તેની પાસે આવ્યા. પછી મૂસાએ તેઓની સાથે વાત કરી. ");
INSERT INTO guj2017_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","તે પછી સર્વ ઇઝરાયલીઓ મૂસાની પાસે આવ્યા અને તેને સિનાઈ પર્વત ઉપર યહોવાહે જે બધી આજ્ઞાઓ આપી હતી, તે સર્વ તેણે તેઓને ફરમાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","જયારે મૂસાએ તેઓની સાથે બોલવાનું પૂરું કર્યું, ત્યારે તેણે પોતાના મુખ ઉપર મુખપટ નાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","જ્યારે જ્યારે મૂસા યહોવાહ સમક્ષ વાત કરવા માટે તેમની સમક્ષ જતો, ત્યારે ત્યારે તે ત્યાંથી બહાર આવે ત્યાં સુધી તે મુખપટને રાખતો નહોતો. તે તંબુમાંથી બહાર આવીને પોતાને જે જે આજ્ઞાઓ મળી હતી તે તે ઇઝરાયલીઓને કહી સંભળાવતો. ");
INSERT INTO guj2017_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ઇઝરાયલીઓએ મૂસાનો ચહેરો જોયો, તો તેનો ચહેરો પ્રકાશતો હતો. પણ તે યહોવાહની સાથે વાત કરવાને અંદર જતો ત્યાં સુધી તે પોતાના મુખ ઉપર ફરીથી મુખપટ રાખતો. ");
INSERT INTO guj2017_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","મૂસાએ સર્વ ઇઝરાયલીઓની એક સભા ભેગી કરીને તેઓને કહ્યું, “આ બાબતો એ છે કે યહોવાહે તમને પાળવા માટે આજ્ઞા આપી છે. ");
INSERT INTO guj2017_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","છ દિવસ કામ કરવું, પણ સાતમો દિવસ તે તમારે માટે પવિત્ર દિવસ થાય, યહોવાહને માટે તે વિશ્રામવાર થાય. તે દિવસે જે કોઈ કામ કરે તે મારી નંખાય. ");
INSERT INTO guj2017_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","વિશ્રામવારના દિવસે તમે જ્યાં પણ રહેતા હોય ત્યાં આગ સળગાવવી નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","મૂસાએ ઇઝરાયલીઓની આખી સભાને કહ્યું, “જે આજ્ઞા યહોવાહે આપી છે તે આ પ્રમાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","યહોવાહને માટે તમારામાંથી અર્પણ લો, જે કોઈના મનમાં આપવાની ઇચ્છા હોય તે યહોવાહને સારુ અર્પણ લાવે: એટલે સોનું, ચાંદી, પિત્તળ, ");
INSERT INTO guj2017_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ભૂરા, જાંબુડિયા, કિરમજી રંગનું ઊન, શણનું ઝીણું કાપડ, બકરાંના વાળ; ");
INSERT INTO guj2017_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ઘેટાંનું લાલ રંગેલુ ચામડું, સીલ માછલાંના ચામડાં, બાવળનાં લાકડાં; ");
INSERT INTO guj2017_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","દીવાને માટે તેલ, અભિષેકના તેલ માટે, સુંગધીદાર ધૂપ માટે સુગંધી દ્રવ્યો, ");
INSERT INTO guj2017_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ગોમેદ પાષાણો, એફોદમાં અને ઉરાવરણમાં જડવાના પાષાણો. ");
INSERT INTO guj2017_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","તમારામાંથી જેઓ ખાસ કુશળ કારીગરો છે તેઓ આવે અને યહોવાહે જે બનાવવાની આજ્ઞા કરી છે તે બનાવે; ");
INSERT INTO guj2017_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","પવિત્રમંડપનો તંબુ, તેનું આચ્છાદન, તેની કડીઓ, તેનાં પાટિયાં, તેની ભૂંગળો, તેના સ્તંભો તથા તેની કૂંભીઓ; ");
INSERT INTO guj2017_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","કરારકોશ તથા તેના દાંડા, દયાસન તથા ઓથાનો પડદો. ");
INSERT INTO guj2017_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","મેજ તથા તેને ઊંચકવાની દાંડીઓ, તેનાં બધાં પાત્રો તથા અર્પેલી રોટલી; ");
INSERT INTO guj2017_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","દીપવૃક્ષ તથા તેનાં સાધનો, દીવાઓ તથા દીવાને માટે તેલ; ");
INSERT INTO guj2017_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ધૂપની વેદી અને તેની દાંડીઓ, અભિષેક માટેનું તેલ, સુગંધીદાર ધૂપ તથા મૂલાકાતમંડપનો પ્રવેશદ્વાર માટેનો પડદો; ");
INSERT INTO guj2017_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","દહનીયાર્પણની વેદી તથા તેની પિત્તળની જાળી, તેના દાંડા તથા તેના પાત્રો, કુંડી તથા તેનું તળિયું. ");
INSERT INTO guj2017_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","આંગણાની ભીંતો માટેના પડદાઓ, સ્તંભો તથા તેઓની કૂંભીઓ અને આંગણાનાં પ્રવેશદ્વાર માટેના પડદાઓ; ");
INSERT INTO guj2017_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","મુલાકાતમંડપના અને તેના આંગણા માટેના સ્તંભો, આંગણાની દોરીઓ; ");
INSERT INTO guj2017_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","પવિત્રસ્થાનમાં સેવા કરવાના માટે ઝીણાં વણેલાં વસ્ત્રો, એટલે યાજકપદ બજાવવાને માટે હારુન યાજકનાં પવિત્ર વસ્ત્રો અને તેના દીકરાઓના વસ્ત્રો.” ");
INSERT INTO guj2017_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","પછી ઇઝરાયલીઓની સમગ્ર સભા મૂસાની હજૂરમાંથી રવાના થઈ. ");
INSERT INTO guj2017_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","જેઓને હોંશ હતી અને જેઓના હૃદયોમાં આપવાની ઇચ્છા હતી તે સર્વ આવ્યા અને મુલાકાતમંડપના કામને સારુ તથા તેની સર્વ સેવાને સારુ તથા પવિત્ર વસ્ત્રોને સારુ યહોવાહને માટે અર્પણ લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","જેટલાં પુરુષો તથા સ્ત્રીઓ રાજી હતાં, તેઓ આવ્યા. તેઓ નથનીઓ, કડીઓ, વીંટીઓ, બંગડીઓ તથા સોનાનાં ઘરેણાં લઈને આવ્યાં. યહોવાહને સોનાનું અર્પણ ચઢાવનાર પ્રત્યેક માણસે એમ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","પ્રત્યેક માણસ જેની પાસે ભૂરા, જાંબુડા, કિરમજી રંગનાં ઊન, ઝીણું શણ, બકરાંના વાળ, ઘેટાંના રાતા રંગેલા ચામડાં તથા શીલ માછલાંનાં ચામડાં મળી આવ્યાં તે પણ તે લઈ આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","જે કોઈએ પણ યહોવાહને ચાંદી કે પિત્તળનું અર્પણ ચઢાવ્યું તે સૌ તે લાવ્યા અને પ્રત્યેક માણસ જેની પાસે સેવાના કોઈ પણ કામને માટે બાવળનું લાકડું મળી આવ્યું તે તે લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","સર્વ બુદ્ધિમાન સ્ત્રીઓ પોતે કાંતેલું, એટલે ભૂરા, જાંબુડા, કિરમજી રંગનું ઊન તથા ઝીણું શણ લાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","જે સર્વ સ્ત્રીઓના હૃદયમાં પ્રેરણા થઈ, તેઓએ બકરાંના વાળ કાંત્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","અધિકારીઓ ગોમેદ પાષાણ, એફોદ તથા ઉરાવરણમાં જડવા માટે પાષાણો લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","તેમ જ દીવા, અભિષેકના તેલ, સુગંધીદાર ધૂપને માટે સુગંધી દ્રવ્યો અને તેલ લઈ આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","આ પ્રમાણે ઇઝરાયલી લોકો પોતાની રાજીખુશીથી યહોવાહને માટે ઐચ્છિકાર્પણ લાવ્યા; એટલે જે સર્વ કામ મૂસાની હસ્તક કરવાની આજ્ઞા યહોવાહે કરી હતી તેને માટે લાવવાની ઇચ્છા જે પ્રત્યેક પુરુષ તથા સ્ત્રીના મનમાં હતી તેણે એ પ્રમાણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","મૂસાએ ઇઝરાયલી લોકોને કહ્યું, “જુઓ, યહોવાહે યહૂદાના કુળના હૂરના દીકરા ઉરીના દીકરા, બસાલેલને નામ લઈને બોલાવ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","બુદ્ધિ, સમજણ, ડહાપણ તથા સર્વ પ્રકારના કળાકૌશલ્યની બાબતે યહોવાહે તેને ઈશ્વરના આત્માથી ભરપૂર કર્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","એ માટે કે તે હોશિયારીથી નમૂના તૈયાર કરે અને સોનામાં, ચાંદીમાં, પિત્તળમાં, ");
INSERT INTO guj2017_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","જડવાને માટે પાષાણ કોતરવામાં, લાકડામાં નકશી કોતરવામાં તથા સર્વ પ્રકારની ઉત્તમ કારીગરીમાં તે કામ કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","યહોવાહે તેને તથા દાનના કુળના અહીસામાખના દીકરા આહોલીઆબને તેણે શીખવવાનું મન આપ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","તેણે તેઓને સર્વ પ્રકારનું કામ કરવાનું કૌશલ્ય આપ્યું છે કે તેઓ કોતરણીનું, સીવણનું, ભરતકામના કિરમજી રંગના વસ્ત્રના પડદાઓના ભરતકામ તૈયાર કરવાનું, ભૂરા, જાંબુડિયા તથા કિરમજી ઊનના અને ઝીણા શણના ભરત ભરનારની અને વણકરની સર્વ પ્રકારની કારીગરી એટલે હરકોઈ પ્રકારની કારીગરી કરનારની તથા નિપુણ કાર્યો યોજનારાઓની કારીગરી કરે. ");
INSERT INTO guj2017_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","બસાલેલ, આહોલીઆબ તથા જે બુદ્ધિમાન માણસોના હૃદયમાં યહોવાહે પવિત્રસ્થાનની સેવાનું બધું કામ કરવાની બુદ્ધિ, અક્કલ મૂકેલી છે, તેઓ સર્વ યહોવાહે આપેલી સર્વ આજ્ઞા પ્રમાણે કામ કરે.” ");
INSERT INTO guj2017_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","પછી મૂસાએ બસાલેલ, આહોલીઆબ તથા જે કારીગરોને યહોવાહે કૌશલ્ય આપ્યું હતું અને જેઓ કામ કરવાને તૈયાર હતા તે સર્વને બોલાવ્યા અને કામ શરૂ કરવા જણાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","જે બધું અર્પણ ઇઝરાયલી લોકો પવિત્રસ્થાનની સેવાના કામને માટે તેના સાધન તરીકે લાવ્યા હતા તે મૂસાએ તેમને સ્વાધીન કર્યું. હજી પણ લોકો દર સવારે રાજીખુશીથી ઐચ્છિકાર્પણ લાવતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","તેથી પવિત્રસ્થાનનું કામ કરનારા બધા જ કારીગરો પોતપોતાનું કામ છોડીને આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","તેઓએ મૂસાને કહ્યું, “યહોવાહે જે કામ કરવાની આજ્ઞા કરી છે તે પૂરું કરવા માટે જરૂરી હોય તેના કરતાં ઘણું વધારે લોકો લાવ્યા કરે છે.” ");
INSERT INTO guj2017_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","તેથી મૂસાએ આખી છાવણીમાં એવી સૂચનાઓ આપી કે પવિત્રસ્થાનના અર્પણને માટે કોઈએ હવે કંઈ કાર્ય ન કરવું. પછી લોકો ભેટો લાવતા અટક્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","અત્યાર સુધીમાં જે કાંઈ આવ્યું હતું તે બધું કામ પૂરું કરવા માટે જોઈએ તેના કરતાં વધારે હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","તેઓમાંના પ્રત્યેક બુદ્ધિમાન માણસ જે તે કામ કરતો હતો તેણે કરુબના આકૃતિ સાથે ભૂરા, જાંબુડા, કિરમજી રંગના, ઝીણા કાંતેલા શણના તથા લાલ ઊનના દશ પડદાઓનો મંડપ બનાવ્યો. આ કામ બસાલેલનું હતું, જે હોશિયાર કારીગર હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","પ્રત્યેક પડદાની લંબાઈ અઠ્ઠાવીસ હાથ તથા પ્રત્યેક પડદાની પહોળાઈ ચાર હાથ હતી. સર્વ પડદા એક જ માપના હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","બસાલેલે પાંચ પડદા એકબીજાની સાથે જોડ્યા અને બીજા પાંચ પડદા એકબીજાની સાથે જોડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","તેણે દરેક મોટા પડદાની બહારની બાજુએ ભૂરા વસ્ત્રની પટ્ટીથી પચાસ નાકાં બનાવ્યાં અને બીજા સમૂહના છેલ્લાં પડદાની કિનારે પણ તેણે એ જ પ્રમાણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","એક પડદામાં તેણે પચાસ નાકાં બનાવ્યાં અને બીજા પડદામાં કિનારે તેણે પચાસ નાકાં બનાવ્યાં. આમ નાકાં એકબીજાની સામસામે હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","આ નાકાંઓને જોડવા માટે તેણે પચાસ સોનાની કડીઓ બનાવી અને તેના વડે આ બે પડદાઓને જોડી દીઘા એટલે પવિત્રમંડપનો એક સળંગ મંડપ બન્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","એ પવિત્રમંડપ ઉપર તંબુ બનાવવા માટે બસાલેલે બકરાંના વાળના વસ્ત્રના અગિયાર પડદાઓ બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","પ્રત્યેક પડદાની લંબાઈ ત્રીસ હાથ અને પહોળાઈ ચાર હાથ હતી. તે અગિયાર પડદા એક જ માપના હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","તેણે પાંચ પડદા એકબીજા સાથે જોડ્યા અને બીજા છ પડદાને એકબીજા સાથે જોડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","તેણે પહેલા મોટા પડદાના છેલ્લાં પડદાની કિનારે પચાસ નાકાં બનાવ્યાં અને બીજા મોટા પડદાની બાજુએ બીજા પચાસ નાકાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","તેમને જોડીને આખો તંબુ બનાવવા માટે બસાલેલે પિત્તળની પચાસ કડીઓ બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","તેણે તંબુને માટે ઘેટાંના લાલ રંગેલાં ચામડાંનું આચ્છાદન બનાવ્યું અને તે પર ચામડાંનું આચ્છાદન બનાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","બસાલેલે પવિત્રમંડપને માટે બાવળના લાકડાંનાં ઊભાં પાટિયાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","પ્રત્યેક પાટિયાની લંબાઈ દશ હાથ અને દરેક પાટિયાની પહોળાઈ દોઢ હાથ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","પ્રત્યેક પાટિયાને એકબીજા સાથે જોડવા માટે દરેકને બે સાલ હતાં. મંડપના સર્વ પાટિયાને તેણે એ જ પ્રમાણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","તેણે મંડપને માટે પાટિયાં બનાવ્યાં. તેણે દક્ષિણ બાજુને માટે વીસ પાટિયાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","બસાલેલે તે વીસ પાટિયાંની નીચે ચાંદીની ચાળીસ કૂંભીઓ બનાવી. એક પાટિયાં નીચે તેનાં બે સાલને માટે બે કૂંભીઓ અને બીજા પાટીયા નીચે તેનાં બે સાલને માટે બે કૂંભીઓ પણ બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ઉત્તર તરફ મંડપની બીજી બાજુને માટે વીસ પાટિયાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","અને તે વીસ પાટિયાંની ચાંદીની ચાળીસ કૂંભીઓ બનાવી. એક પાટીયા નીચે બે કૂંભીઓ અને બીજા પાટીયા નીચે બે કૂંભીઓ બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","મુલાકાતમંડપનો પાછળનો ભાગ પશ્ચિમ દિશામાં હતો અને તેની પછી તેને માટે તેણે છે પાટિયાં બનાવ્યાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","તેની પછીના છેડાઓને માટે તેણે બે પાટિયાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","તેઓ નીચેથી જોડેલાં હતાં અને એ જ પ્રમાણે સળંગ ટોચ સુધી જઈને તેઓ એક કડામાં જોડાયેલાં હતાં. તેણે બે ખૂણામાં બન્નેને તે જ પ્રમાણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","આમ આઠ પાટિયાં હતાં, તેઓની ચાંદીની સોળ કૂંભીઓ હતી. એટલે દરેક પાટીયા નીચે બબ્બે કૂંભીઓ બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","તેણે બાવળના લાકડાની ભૂંગળો બનાવી. મંડપની એક બાજુનાં પાટિયાને સારુ પાંચ, ");
INSERT INTO guj2017_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","મંડપની બીજી બાજુનાં પાટિયાને સારુ પાંચ ભૂંગળો અને પશ્ચિમ તરફ મંડપની પછીના પાટિયાંને માટે પાંચ ભૂંગળો. ");
INSERT INTO guj2017_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","તેણે વચલી ભૂંગળને પાટિયાંને મધ્ય ભાગે એક છેડાથી તે બીજા છેડા સુધીની અડધી ઊંચાઈને એક છેડાથી તે બીજા છેડા સુધી ખોસી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","તેણે આ પાટિયાઓ સોનાથી મઢ્યાં. તેણે ભૂંગળોને રાખવાની જગ્યાને માટે સોનાનાં કડાં બનાવ્યાં અને ભૂંગળોને સોનાથી મઢી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","તેણે ભૂરા, જાંબુડા અને કિરમજી ઊનનો તથા ઝીણા કાંતેલા શણનો પડદો બનાવ્યો. નિપુણ કારીગરે કરુબોવાળો તે બનાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","તેણે તેને સારુ બાવળના લાકડાના ચાર સ્તંભ બનાવ્યાં અને તેઓને સોનાથી મઢ્યા. તેઓના આંકડા સોનાના હતા અને તેણે તેઓને સારુ ચાંદીની ચાર કૂંભીઓ બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","તેણે મંડપના પ્રવેશદ્વાર માટે ભૂરા, જાંબુડા તથા કિરમજી રંગનો ભરત ભરનારના હાથે બનેલા ઝીણા કાંતેલા શણનો પડદો બનાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","તેના પાંચ સ્તંભ તેઓના આંકડા સુદ્ધાં અને તેણે તેઓના મથાળાં તથા ચીપો સોનાથી મઢ્યા અને તેઓની પાંચ કૂંભીઓ પિત્તળની હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","બસાલેલે બાવળના લાકડામાંથી કરારકોશ બનાવ્યો. જેની લંબાઈ અઢી હાથ, પહોળાઈ દોઢ હાથ તથા ઊંચાઈ દોઢ હાથ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","તેણે તેને અંદર તથા બહારથી શુદ્ધ સોનાથી મઢીને તેની આસપાસ સોનાની કિનારી બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","તેણે તેના ચાર પાયામાં સોનાનાં ચાર કડાં જોડ્યાં, એટલે તેની એક બાજુએ બે કડાં અને તેની બીજી બાજુએ બે કડાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","તેણે બાવળના લાકડાના દાંડા બનાવ્યાં અને તેને સોનાથી મઢી લીધાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","તેણે કરારકોશને ઊંચકવા માટે તેની બાજુ પરનાં કડાંમાં તે દાંડા પરોવી દીઘા. ");
INSERT INTO guj2017_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","તેણે શુદ્ધ સોનામાંથી અઢી હાથ લાંબુ અને દોઢ હાથ પહોળું દયાસન બનાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","તેણે સોનાના બે કરુબો બનાવ્યાં. તેણે તેમને દયાસનને બન્ને છેડે ઘડતર કામના બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","એક છેડે એક કરુબ અને બીજે છેડે એક કરુબ. તેના બે છેડા પરના કરુબો તેણે દયાસનની સાથે સળંગ બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","કરુબોની પાંખો ઊંચે ફેલાવીને પોતાની પાંખો વડે દયાસન પર આચ્છાદન કર્યું. તેઓના મુખ સામસામાં હતા અને દયાસનની તરફ કરુબોનાં મુખ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","બસાલેલે બાવળના લાકડામાંથી બે હાથ લાંબી, એક હાથ પહોળી અને દોઢ હાથ ઊંચી મેજ બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","આખી મેજને શુદ્ધ સોનાથી મઢી લઈને મેજની ચારે તરફની ધાર પર સોનાની કિનારી બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","તેણે તેની ફરતે ચાર ઈંચની કિનાર બનાવી અને તેની ફરતે સોનાની કોર મૂકી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","તેણે તેને ઊંચકવા માટે સોનાનાં ચાર કડાં બનાવ્યાં અને ચાર ખૂણે ચાર પાયામાં જડી દીધાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","મેજ ઊંચકવાની દાંડીની જગ્યાઓ એટલે કડાં એ કિનારીની નજીક હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","તેણે મેજ ઊંચકવા માટે બાવળના લાકડાની દાંડીઓ બનાવી અને તેને સોનાથી મઢી લીધી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","તેણે મેજ માટેનાં વાસણો, એટલે થાળીઓ, ચમચીઓ, વાટકા, બરણીઓ અને પેયાર્પણ માટેના પ્યાલા શુદ્ધ સોનાનાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","તેણે શુદ્ધ સોનાનું દીપવૃક્ષ બનાવ્યું. ઘડતર કામનું દીપવૃક્ષ તેણે બનાવ્યું. એટલે તેની બેઠક તથા તેનો દાંડો, તેનાં ચાડાં, તેની કળીઓ તથા તેનાં ફૂલ તે તેની સાથે સળંગ જોડેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","દીપવૃક્ષની બન્ને બાજુએ ત્રણ ત્રણ એમ કુલ છ શાખાઓ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","એક શાખામાં બદામફૂલના આકારનાં બનાવેલાં ત્રણ ચાડાં, એક કળી તથા એક ફૂલ અને બીજી શાખામાં બદામફૂલના આકારનાં બનાવેલાં ત્રણ ચાડાં, એક કળી તથા એક ફૂલ, આમ દીપવૃક્ષમાંથી નીકળતી કુલ છ શાખાઓ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","દીપવૃક્ષમાં બદામફૂલના આકારના બનાવેલા ચાર ચાડાં, તેઓની કળીઓ તથા તેઓના ફૂલ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","દીપવૃક્ષનાં સ્તંભ ઉપર બબ્બે શાખાઓની દરેક જોડી નીચે એક એક ફૂલ હતું. વળી ટોચની શાખાની જોડીના ઉપરના ભાગમાં પણ એક ફૂલ હતું અને નીચેની શાખાઓની જોડીના નીચેના ભાગમાં એક ફૂલ હતું, આમ ચાર ફૂલ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","દીવીની થાંભલી સાથે શાખાઓ અને કળીઓ જોડી દેવામાં આવ્યા હતાં અને એ બધું શુદ્ધ સોનાનાં ઘડતર કામનું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","બસાલેલે તેના સાત દીવા, દીવી માટે સાત કોડિયાં બનાવ્યાં. દિવેટની વાટ સમારવાની કાતર અને રાખદાનીઓ શુદ્ધ સોનામાંથી બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","તેણે દીપવૃક્ષ અને તેનો સાજ બનાવવામાં એક તાલંત શુદ્ધ સોનું વાપર્યું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","બસાલેલે ધૂપ માટેની વેદી બાવળના લાકડામાંથી બનાવી. તેની લંબાઈ એક હાથ, પહોળાઈ એક હાથ તથા ઊંચાઈ બે હાથ અને સમચોરસ હતી. તેના શિંગ તેની સાથે સળંગ જોડેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","આખી વેદીને તેણે શુદ્ધ સોનાથી મઢી હતી, એટલે તેની ચારે તરફની બાજુઓ તથા તેના શિંગ અને તેની આસપાસ તેણે સોનાની કિનારી બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","તેણે તેને માટે બે સોનાનાં કડાં બનાવીને બન્ને બાજુએ કિનારીની નીચે જડી દીધાં. જેથી તેને ઊંચકતી વખતે દાંડા પરોવી શકાય. ");
INSERT INTO guj2017_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","તેણે બાવળનાં લાકડાના દાંડા બનાવીને સોનાથી મઢ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","તેણે અભિષેક માટેનું પવિત્ર તેલ તથા શુદ્ધ ખુશબુદાર સુગંધીઓનો ધૂપ બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","તેણે બાવળના લાકડામાંથી દહનીયાર્પણની વેદી બનાવી. તેની લંબાઈ પાંચ હાથ, તેની પહોળાઈ પાંચ હાથ તથા તેની ઊંચાઈ ત્રણ હાથ હતી અને તે ચોરસ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","તેના ચાર ખૂણા પર ચાર શિંગ હતાં, તે વેદીના લાકડામાંથી જ બનાવેલાં હતાં. આ વેદી ઉપર પિત્તળનું આવરણ ચઢાવવામાં આવ્યું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","તેણે વેદીનાં બધાં જ પાત્રો એટલે ભસ્મપાત્રો, તાવડીઓ, તપેલાં, ત્રિપાંખિયાં અને સગડીઓને પિત્તળનાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","તેણે વેદીની માટે તેની ધારની નીચે આસપાસ પિત્તળની ગૂંથેલી જાળી તેની અડધી ઊંચાઈએ પહોંચે તેવી બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","તેણે પિત્તળની જાળીના ચાર છેડાને સારુ દાંડા રાખવાને માટે ચાર કડાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","બસાલેલે બાવળના લાકડાના દાંડા બનાવીને તેને પિત્તળથી મઢી લીધા. ");
INSERT INTO guj2017_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","વેદી ઊંચકવા માટે તેણે તેની બાજુ પરનાં કડાંઓમાં પરોવી દીધા. તેણે તે વેદી ખોખા જેવી પોલી રાખી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","તેણે મુલાકાતમંડપના પ્રવેશદ્વાર પાસે સેવા કરનારી સ્ત્રીઓની આરસીઓનો પિત્તળનો હોજ તથા તેનું પિત્તળનું તળિયું બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","તેણે આંગણું બનાવ્યું. તેની દક્ષિણ બાજુના પડદાની ભીંત સો હાથ લાંબી હતી અને તે ઝીણા કાંતેલા શણના પડદાઓની બનાવેલી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","આ પડદાને પકડી રાખવા માટે વીસ સ્તંભો અને વીસ કૂંભીઓ પિત્તળની હતી. સ્તંભોના આંકડા તથા તેમના સળિયા ચાંદીના બનાવેલા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ઉત્તરની બાજુએ સો હાથ લાંબા પડદા હતા અને તેને માટે પિત્તળના વીસ સ્તંભો અને વીસ કૂંભીઓ હતી તથા આંકડા અને સળિયા ચાંદીના હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","આંગણાની પશ્ચિમ બાજુએ પચાસ હાથ લાંબા પડદા, દસ સ્તંભો તથા દસ કૂંભીઓ હતી અને આંકડા અને સળિયા ચાંદીના હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","આંગણાની પૂર્વ તરફ પચાસ હાથ લાંબા પડદા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","પ્રવેશદ્વારની એક બાજુને માટે પડદા પંદર હાથનાં હતા. તેમના સ્તંભો ત્રણ તથા તેઓની કૂંભીઓ ત્રણ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","બીજી બાજુને માટે પણ તેમ જ હતું. આંગણાના પ્રવેશદ્વારની બીજી બાજુએ તથા પેલી બાજુએ પંદર હાથનાં પડદા હતા. તેમના સ્તંભો ત્રણ તથા તેમની કૂંભીઓ ત્રણ હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","આગણાંની આસપાસના સર્વ પડદા ઝીણા કાંતેલા શણના હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","સ્તંભોને માટે કૂંભીઓ પિત્તળની હતી. સ્તંભના આંકડા તથા દાંડીઓ ચાંદીના હતાં અને તેઓના મથાળાં ચાંદીથી મઢેલાં હતા. આંગણાના સર્વ સ્તંભ ચાંદીથી મઢેલા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","આંગણાના પ્રવેશદ્વારનો પડદો ભરત ભરનારે બનાવેલો, ભૂરા, જાંબુડા, કિરમજી રંગનો તથા ઝીણા કાંતેલા શણનો હતો. તેની લંબાઈ વીસ હાથ, પહોળાઈ પાંચ હાથ, એટલે આંગણાના પડદાઓના માપનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","તેઓના ચાર સ્તંભ તથા તેઓની પિત્તળની ચાર કૂંભીઓ હતાં. તેઓના આંકડા ચાંદીના તથા તેઓના મથાળાં તથા સળિયા ચાંદીથી મઢેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","પવિત્રમંડપ તથા આંગણાના બાંધકામમાં વપરાયેલી બધી ખીલીઓ પિત્તળની બનાવેલી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","મંડપનો એટલે કે સાક્ષ્યમંડપનો સામાન કે જે સર્વની ગણતરી લેવીઓની સેવાને માટે મૂસાના હુકમ પ્રમાણે હારુન યાજકના દીકરા ઈથામારની હસ્તક કરવામાં આવી, તેની કુલ સંખ્યા એ પ્રમાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","જે વિષે યહોવાહે મૂસાને આજ્ઞા આપી હતી તે સર્વ યહૂદાના કુળના હૂરના દીકરા ઉરીના દીકરા બસાલેલે બનાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","તેને મદદ કરનાર દાનના કુળના અહીસામાખનો દીકરો આહોલીઆબ કોતરકામ કરનાર, નકશી કોતરનાર તથા બાહોશ કારીગર અને ભૂરા, જાંબુડા, કિરમજી ઊન તેમ જ ઝીણા કાંતેલા શણનું ભરત ભરનાર હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","જે સોનું પવિત્રસ્થાનના સર્વ કામને માટે વાપરવામાં આવ્યું, એટલે અર્પણનું સોનું, તે સઘળું ઓગણત્રીસ તાલંત સાતસો ત્રીસ શેકેલ પવિત્રસ્થાનના શેકેલ પ્રમાણે હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","વસ્તીગણતરીની નોંધણી વખતે સમુદાય પાસેથી મળેલ ચાંદીનું વજન એકસો તાલંત અને એક હજાર સાતસો પંચોતેર તથા પવિત્રસ્થાનના શેકેલ પ્રમાણે હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","વસ્તીગણતરીમાં વીસ વર્ષની અને તેની ઉપરની ઉંમરના જેટલા પુરુષો હતા તેઓની સંખ્યા છે લાખ ત્રણ હજાર પાંચસો પચાસ હતી, તેઓમાંથી પ્રત્યેક પુરુષ એક બેકા ચાંદી એટલે પવિત્રસ્થાનના શેકેલ પ્રમાણે અર્ધો શેકેલ ચાંદી આપી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","પવિત્રસ્થાન માટેની અને પડદા માટેની કૂંભીઓ બનાવવામાં સો તાલંત ચાંદી વપરાઈ હતી: તેમાંથી સો કૂંભીઓ સો તાલંતની, એટલે દરેક કૂંભી એક તાલંતની હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","બાકીની એક હજાર સાતસો પંચોતેર શેકેલ ચાંદીમાંથી તેણે સ્તંભોના આંકડા બનાવ્યાં તથા તેમનાં મથાળાં મઢ્યાં તથા તેઓને સારુ સળિયા બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","અર્પેલું પિત્તળ સિત્તેર તાલંત તથા બે હજાર ચારસો શેકેલ હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","આ પિત્તળનો ઉપયોગ મુલાકાતમંડપના પ્રવેશદ્વારની કૂંભીઓ, પિત્તળની વેદી, તેની પિત્તળની જાળી, વેદીના સર્વ સાધનો, ");
INSERT INTO guj2017_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","આસપાસના આંગણાની કૂંભીઓ, મંડપની સર્વ મેખો તથા આસપાસના આંગણાની સર્વ મેખો બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","પવિત્રસ્થાનમાં સેવા કરતી વખતે લોકોએ ભૂરા, જાંબુડા અને કિરમજી રંગના ઝીણાં વસ્ત્રો બનાવ્યાં. યહોવાહે મૂસાને આજ્ઞા કરી હતી તે મુજબ તેમણે હારુનને માટે પવિત્ર વસ્ત્રો બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","તેણે સોનાનો, ભૂરા, જાંબુડા, કિરમજી અને લાલ ઊન તથા ઝીણા કાંતેલા શણનો એફોદ બનાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","સોનાને ટીપીને બસાલેલે સોનાના પાતળાં પટ્ટીઓ બનાવ્યાં અને તેને કાપીને તેના તાર બનાવ્યાં. આ તાર ભૂરા, જાંબુડા, કિરમજી રંગના ઊન, અને બારીક શણથી બનાવવામાં આવ્યા. આ કાર્ય એક બહુ જ કુશળ કારીગરનું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","તેઓએ એફોદને ખભે બાંધવાના પટા બનાવીને તેની બે બાજુએ જોડી દીધા, જેથી તે બાંધી શકાય. ");
INSERT INTO guj2017_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","એફોદનો ચતુરાઈથી વણેલો જે પટકો તેને બાંધવા સારુ તેના પર હતો, તે તેની સાથે સળંગ હતો તથા તેવી જ બનાવટનો હતો; એટલે સોનાનો ભૂરા, જાંબુડા, કિરમજી રંગનું ઊન તથા ઝીણા કાંતેલા શણ સાથે ગૂંથીને બનાવેલો હતો અને તેની સાથે જોડી દીધેલો હતો; જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ. ");
INSERT INTO guj2017_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","તેઓએ ગોમેદ પાષાણો તૈયાર કરીને તેમના પર ઇઝરાયલના બાર પુત્રોનાં નામ મુદ્રાની કોતરણીથી કોતરીને, તેમને સોનાના ચોકઠામાં બેસાડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","યહોવાહે મૂસાને આજ્ઞા આપી હતી તે પ્રમાણે તેણે તેઓને ઇઝરાયલના બાર પુત્રોને સારુ સ્મરણ પાષાણો થવા માટે એફોદના ખભાના પટ્ટા પર લગાડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","તેણે ન્યાયકરણ ઉરપત્રક એફોદની જેમ સુંદર કારીગરીથી બનાવ્યું હતું. તેને બનાવવા માટે તેણે સોનાનું, ભૂરા, જાંબુડા, કિરમજીનું ઉન તથા ઝીણા કાંતેલા શણનું બનાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","તે ચોરસ હતું. તેણે ઉરપત્રને બેવડું બનાવ્યું. બેવડાની લંબાઈ એક વેંત અને પહોળાઈ એક વેંત હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","તેઓએ તેમાં પાષાણની ચાર હારો બેસાડેલી હતી. પ્રથમ હારમાં માણેક, પોખરાજ તથા લાલ રત્ન હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","બીજી હાર લીલમ, નીલમ અને હીરાની હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ત્રીજી હાર શનિ, અકીક તથા યાકૂતની હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ચોથી હાર ગોમેદ, પીરોજ તથા યાસપિસની હતી. એ બધાં સોનાનાં નકશીકામવાળા ચોકઠામાં જડેલા હતા. ");
INSERT INTO guj2017_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","આ રીતે પાષાણો તેઓના નામ પ્રમાણે એટલે ઇઝરાયલનાપુત્રોના નામ પ્રમાણે બાર નંગો હતા. તેના પર ઇઝરાયલના પુત્રોનાં નામ કોતરેલાં હતાં. બારે કુળોમાંના દરેકનું નામ એકેક પાષાણ પર મુદ્રાના જેવી કોતરણીથી કોતરેલું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","તેણે ન્યાયકરણ ઉરપત્રક માટે શુદ્ધ સોનાની ગૂંથેલી દોરી જેવી સાંકળીઓ બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","તેણે સોનાની બે કળીઓ બનાવી અને ન્યાયકરણ ઉરપત્રના બે ખૂણાઓમાં બેસાડી દીધી. તેઓએ ખભાના ટુકડાઓ માટે બે સોનાની નકશી બનાવી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","તેઓએ ઉરપત્રના છેડા પર મૂકેલી કડીઓમાં સોનાની સાંકળીઓ જોડી દીધી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","એ સાંકળીના બીજા બે છેડા બે ચોકઠાં સાથે જોડી દીધાં અને તેઓએ તેમને એફોદના આગલા ભાગમાં તેની સ્કંધપટીઓ પર લગાડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","તેઓએ સોનાની બીજી બે કડીઓ બનાવી અને તેઓને એફોદની નજીકના ઉરપત્રની અંદરની બાજુના નીચલા ખૂણાએ મૂકી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","તેઓએ બીજી બે સોનાની કડીઓ બનાવીને એફોદના ખભાના બે પટાના સામેના નીચેના છેડે સાંધા નજીક અને સુંદર ગૂંથેલા કમરપટાની ઉપરના ભાગમાં લગાવી દીધી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ઉરપત્રના નીચલા છેડાને ભૂરી દોરી વડે એફોદની કડીઓ સાથે બાંધી દીધો, જેથી યહોવાહે મૂસાને આજ્ઞા કરી હતી તે મુજબ ન્યાયકરણ ઉરપત્રક કરમપટા ઉપર રહે અને છુટ્ટું ન પડી જાય. ");
INSERT INTO guj2017_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","બસાલેલે એફોદ પરનો જામો આખો ભૂરા રંગના કાપડનો બનાવ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","તેણે જામાની વચ્ચે એક કાણું પાડ્યું અને તેની કિનાર સીવી લીધી. કિનાર ફાટી ન જાય તે માટે સીવવામાં આવી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","જામાની નીચેની બાજુએ દાડમ ભરેલાં હતાં. તે કાંતેલા શણના, ભૂરા, જાંબુડા તથા કિરમજી રંગના ભરતકામથી બનાવેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","તેમ જ તેઓએ શુદ્ધ સોનાની ઘૂઘરીઓ બનાવીને તેને દાડમો વચ્ચે નીચલી બાજુએ મૂકી હતી. ");
INSERT INTO guj2017_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","એ જ રીતે ઝભ્ભાની નીચેની બાજુએ વારાફરતી દાડમ અને ઘૂઘરી આવતાં હતાં. યહોવાહે મૂસાને આજ્ઞા કરી હતી તે પ્રમાણે હારુન યહોવાહની સેવા કરતી વખતે આ ઝભ્ભો પહેરતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","તેઓએ હારુન અને તેના પુત્રો માટે ઝીણા કાંતેલા શણના અંગરખાં બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","વળી તેઓએ ઝીણા કાંતેલા શણમાંથી પાઘડીઓ, ફાળિયાં તથા ઝીણા કાંતેલા શણની ઈજારો બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","યહોવાહની આજ્ઞા મુજબ મૂસાએ ભૂરા, કિરમજી, લાલ ઊનનો ભરત ભરેલો તથા ઝીણા કાંતેલા શણનો કમરપટો બનાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","તેઓએ શુદ્ધ સોનાનું પવિત્ર મુગટનું પતરું બનાવ્યું; તેઓએ તેના પર પવિત્ર શબ્દો કોતરેલા હતા, યહોવાહને સારુ પવિત્ર. ");
INSERT INTO guj2017_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","તેને પાઘડીની ટોચે બાંધવા સારુ તેઓએ તેને ભૂરા રંગની પટ્ટી સાથે બાંધેલી હતી. જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ. ");
INSERT INTO guj2017_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","આ રીતે યહોવાહે મૂસાને આપેલી આજ્ઞા અનુસાર મુલાકાતમંડપનું કામ પૂર્ણ થયું. આ બધું જ ઇઝરાયલીઓએ આજ્ઞા મુજબ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","તેઓએ પવિત્રમંડપ, તેનો તંબુ અને તેનું બધું રાચરચીલું, તેની કડીઓ, પાટિયાં, વળીઓ, સ્તંભો અને કૂંભીઓ મૂસા પાસે લાવ્યા; ");
INSERT INTO guj2017_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","તેઓએ તેને ઘેટાંના સૂકવેલા રાતા રંગેલા ચામડાંમાંથી બનાવેલા મંડપના આચ્છાદન અને ઝીણા ચામડામાંથી બનાવેલા આચ્છાદન તથા અંતરપટ, ");
INSERT INTO guj2017_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","કરારકોશ, તેના દાંડા તથા તેનું આચ્છાદન બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","તેઓ મેજ અને તેનાં બધાં સાધનો તથા સમક્ષતાની રોટલી; ");
INSERT INTO guj2017_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","શુદ્ધ સોનાનું દીપવૃક્ષ તથા તેનાં કોડિયા, જે હારબંધ ગોઠવવાનાં હતાં, તેનાં બધાં સાધનો અને પૂરવાનું તેલ; ");
INSERT INTO guj2017_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","સોનાની વેદી, અભિષેક માટેનું તેલ, સુગંધીદાર ધૂપ, મુલાકાતમંડપના પ્રવેશદ્વારનો પડદો; ");
INSERT INTO guj2017_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","પિત્તળની વેદી, તેની પિત્તળની બનાવેલી જાળી, તેના દાંડા અને તેનાં બધાં સાધનો, હોજ તથા તેનું તળિયું બનાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","આંગણાની ભીંતો માટેના પડદાઓ અને તેને લટકાવવા માટેનાં સ્તંભો તથા કૂંભીઓ, તેમ જ આંગણાના પ્રવેશદ્વાર માટેના પડદાઓ અને તેના સ્તંભો, દોરી અને ખીલાઓ, મુલાકાતમંડપમાં સેવા માટે વાપરવાનાં બધાં સાધનો લાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","પવિત્રસ્થાનમાં સેવા કરવાના સમયે પહેરવાનાં સુંદર વસ્ત્રો તથા યાજક તરીકે ફરજ બજાવતી વખતે હારુન અને તેના પુત્રોએ પહેરવાનાં પવિત્ર વસ્ત્રો મૂસાને બતાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","યહોવાહે મૂસાને જણાવ્યા મુજબ બધું જ કામ ઇઝરાયલીઓએ પૂર્ણ કર્યું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","મૂસાએ બધું જ તપાસી લીધું અને યહોવાહના જણાવ્યા મુજબ બનાવ્યું છે એની ખાતરી કરી લીધી અને પછી મૂસાએ તેઓને આશીર્વાદ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“પ્રથમ માસના પ્રથમ દિવસે તું મુલાકાતમંડપ ઊભો કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","તેની અંદર દશ આજ્ઞાઓ મૂકેલી છે, તે કરારકોશ મંડપમાં મૂકજે; અને કરારકોશને પડદાથી ઢાંકી દેજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","મેજને અંદર લાવીને તેના પર પાત્રો ગોઠવજે અને દીવી લાવીને તેના પર દીવાઓ સળગાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","તું સોનાની ધૂપવેદી કરારકોશની સામે મૂકજે અને મંડપના દ્વારને પડદો લગાડજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","તું દહનીયાર્પણની વેદીને મુલાકાતમંડપના માંડવાના દરવાજાની સામે મૂક. ");
INSERT INTO guj2017_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","તું હોજને મુલાકાતમંડપની તથા વેદીની વચ્ચે મૂકજે અને તેમાં પાણી ભરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","તું મુલાકાતમંડપના બહારના ભાગમાં ચારે બાજુ આંગણું તૈયાર કરીને આંગણાના પ્રવેશદ્વારે પડદો લટકાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","તું અભિષેકનું તેલ લઈ પવિત્રમંડપનો તથા તેમાંની સર્વ વસ્તુઓનો અભિષેક કરીને તેની તથા તેમાંના બધાં સાધનોની શુદ્ધિ કરજે તેથી એ પવિત્ર થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","તું દહનીયાર્પણની વેદીનો અને તેનાં સર્વ સાધનોનો પણ અભિષેક કરીને તેમને શુદ્ધ કરજે તેથી તે પણ અત્યંત પવિત્ર થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","તું હોજનો અને તેના તળિયાંનો અભિષેક કરીને તેને પવિત્ર કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","તું હારુનને તથા તેના પુત્રોને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લાવજે અને તેઓને પાણીથી સ્નાન કરાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","તું હારુનને પવિત્ર વસ્ત્રો પહેરાવીને તેનો અભિષેક કરજે અને યાજક તરીકે મારી સેવા કરવા માટે તેને પવિત્ર કરજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","તું તેના પુત્રોને લાવીને અંગરખાં પહેરાવજે. ");
INSERT INTO guj2017_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","જેમ તેં તેઓના પિતાનો અભિષેક કર્યો હતો તેમ તેઓનો અભિષેક કર. તેઓનો અભિષેક કરવાથી તેઓ અને તેમના વંશજો કાયમ માટે યાજકો બનશે.” ");
INSERT INTO guj2017_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","યહોવાહે મૂસાને જે આજ્ઞા આપી હતી તે પ્રમાણે મૂસાએ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","બીજા વર્ષના પ્રથમ માસના પ્રથમ દિવસે પવિત્રમંડપ ઊભો કરવામાં આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","મૂસાએ કૂંભીઓ ગોઠવી, પાટિયાં બેસાડ્યાં, વળીઓ જડી દીધી, ભૂંગળો નાખી તથા તેના સ્તંભો રોપ્યા. ");
INSERT INTO guj2017_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","યહોવાહે મૂસાને આજ્ઞા કરી હતી તે પ્રમાણે પવિત્રમંડપ ઉપર આવરણ પાથરી દીધું અને તેની ઉપર તંબુનું આચ્છાદન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","તેણે સાક્ષ્યલેખ લઈને કરારકોશમાં મૂક્યો અને કોશ પર દાંડા ગોઠવ્યા અને કોશ પર દયાસન મૂક્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","કરારકોશને મૂસાએ પવિત્રમંડપમાં લાવ્યો અને યહોવાહની આજ્ઞા અનુસાર તેને ઢાંકવા પડદો લટકાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","મુલાકાતમંડપમાં ઉત્તર બાજુએ તેણે પડદાની બહાર મેજ મૂક્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","તેના ઉપર મૂસાએ યહોવાહની આજ્ઞા અનુસાર યહોવાહને અર્પેલી રોટલી મૂકી. ");
INSERT INTO guj2017_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","મુલાકાતમંડપની અંદર મેજની સામે દક્ષિણ બાજુએ તેણે દીવી મૂકી. ");
INSERT INTO guj2017_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","યહોવાહની આજ્ઞા મુજબ મૂસાએ તેના ઉપર યહોવાહ સમક્ષ દીવા સળગાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","મુલાકાતમંડપમાં પડદાની આગળ તેણે સોનાની વેદી મૂકી. ");
INSERT INTO guj2017_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","મૂસાએ યહોવાહની આજ્ઞા અનુસાર તેમાં સુંગધી ધૂપ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","પવિત્રમંડપના પ્રવેશદ્વારે તેણે પડદો લટકાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","મૂસાએ મુલાકાતમંડપના પ્રવેશદ્વાર પર અર્પણોને બાળવા માટે દહનીયાર્પણની વેદી ગોઠવી અને તેના ઉપર બળેલાં દહનીયાર્પણ અને ખાદ્યાર્પણ અર્પણ કરવા આ બધું તેણે યહોવાહની આજ્ઞા મુજબ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","તેણે મુલાકાતમંડપ અને વેદીની વચ્ચે હોજ ગોઠવી અને તેમાં હાથપગ ધોવા માટે પાણી રેડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","મૂસા, હારુન અને તેના પુત્રો મુલાકાતમંડપમાં પ્રવેશ કરવા માટે ત્યાં હાથ પગ ધોતા. ");
INSERT INTO guj2017_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","જયારે તેઓ મુલાકાતમંડપમાં જતા અને જ્યારે તેઓ વેદીની પાસે આવતા, ત્યારે તેઓ સ્નાન કરતા, જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ. ");
INSERT INTO guj2017_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","મૂસાએ પવિત્રમંડપ અને વેદીની ચારેબાજુ આંગણું ઊભુ કર્યું. તેણે આંગણાના પ્રવેશદ્વારે પડદા વડે દરવાજો બનાવ્યો. આ પ્રમાણે મૂસાએ કાર્ય પરિપૂર્ણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","પછી મુલાકાતમંડપને વાદળે ઘેરી લીધો. અને યહોવાહનું ગૌરવ મંડપમાં વ્યાપી ગયું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","મૂસા મુલાકાતમંડપમાં પ્રવેશી શકયો નહિ, કેમ કે વાદળ તેના પર સ્થિર થયું હતું અને યહોવાહનું ગૌરવ મંડપમાં પ્રસરી ગયું હતું. ");
INSERT INTO guj2017_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","જયારે મેઘને મંડપ ઉપરથી ઊઠાવી લેવામાં આવતો, ત્યારે ઇઝરાયલીઓ પોતાની મુસાફરીમાં આગળ આવતા. ");
INSERT INTO guj2017_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","પણ જો વાદળ પવિત્રમંડપ ઉપર સ્થિર થતું તો વાદળ હઠે નહિ ત્યાં સુધી તેઓ મુકામ પામતા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","યહોવાહ દિવસ દરમિયાન મુલાકાતમંડપ પર વાદળ આચ્છાદન કરે અને રાતે વાદળ અગ્નિમય બની જાય, એટલે ઇઝરાયલી લોકો સમગ્ર પ્રવાસ દરમિયાન પ્રત્યેક મુકામને જોઈ શકતા.");
INSERT INTO guj2017_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","યહોવાહે મૂસાને બોલાવીને મુલાકાતમંડપમાંથી તેની સાથે વાત કરી કે, ");
INSERT INTO guj2017_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“તું ઇઝરાયલી લોકોને એમ કહે કે, ‘જ્યારે તમારામાંનો કોઈ માણસ યહોવાહને અર્પણ ચઢાવે ત્યારે તે અર્પણ તમારે પશુમાંનું, એટલે જાનવરમાંનું ખાસ કરીને ઘેટાંબકરાંમાંનું ચઢાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","જો કોઈનું અર્પણ જાનવરના દહનીયાર્પણનું હોય, તો તે નર હોવું જોઈએ અને તે ખોડખાંપણ વગરનું હોવું જોઈએ. તેણે જાનવરને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ ચઢાવવું, જેથી તે પોતે યહોવાહની આગળ માન્ય થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","જે વ્યક્તિ તે જાનવરને લઈને આવે તેણે પોતાનો હાથ તે દહનીયાર્પણના માથા પર મૂકવો એટલે પ્રાયશ્ચિત્ત કરવા તેનો સ્વીકાર કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","પછી તે બળદને યહોવાહની સમક્ષ કાપે. યાજકો, એટલે હારુનના પુત્રો, તેના રક્તને લાવીને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ આવેલી વેદીની ચારે બાજુએ છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","પછી દહનીયાર્પણનું ચામડું તે ઉતારે અને કાપીને તેના ટુકડા કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","હારુન યાજકના પુત્રો વેદી પર અગ્નિ મૂકીને અગ્નિ પર લાકડાં ગોઠવે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","યાજકો, એટલે હારુનના પુત્રો, તે ટુકડા, માથું તથા ચરબી, વેદી પરના બળતા લાકડાંનાં અગ્નિ પર ગોઠવે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","પણ જાનવરના આંતરિક ભાગો તથા પગ પાણીથી ધોઈ નાખે. પછી યાજક વેદી પર તે બધાનું અર્પણ કરે. તે દહનીયાર્પણ તરીકે વેદી પર મૂકવું અને એ યહોવાહને માટે સુવાસિત છે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","જો દહનીયાર્પણને માટે તેનું અર્પણ ટોળામાંથી એટલે કે ઘેટાંબકરાંમાંથી હોય, તો તે ખોડખાંપણ વગરનો નર પશુ જ હોવો જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","તે તેને વેદીની ઉત્તર બાજુએ યહોવાહની સમક્ષ કાપે. યાજકો, એટલે હારુનના પુત્રો, તેનું રક્ત વેદીની આગળ પાછળ અને ચારે બાજુએ છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","તે તેને માથું તથા ચરબી સહિત કાપીને તેના ટુકડા કરે અને યાજક તેઓને વેદી પરના અગ્નિ પરનાં લાકડાં પર ગોઠવે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","પણ આંતરિક ભાગો તથા પગને તે પાણીથી ધોઈ નાખે. પછી યાજક તે બધું અર્પીને વેદી પર તેનું અર્પણ કરે. તે યહોવાહને માટે સુવાસિત દહનીયાર્પણ એટલે હોમયજ્ઞ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","જો યહોવાહને માટે તેનું દહનીયાર્પણ પક્ષીઓનું હોય, તો તે હોલાનું કે કબૂતરનાં બચ્ચાંનું અર્પણ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","યાજક તેને વેદી આગળ લાવીને તેનું માથું મરડી નાખે અને વેદી પર તેનું દહન કરે. પછી તેનું રક્ત વેદીની એક બાજુએ રેડી દે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","તે તેની અન્નની કોથળી તેના મેલ સહિત કાઢી લઈને વેદીની પૂર્વ બાજુએ રાખ નાખવાની જગ્યાએ ફેંકી દે. ");
INSERT INTO guj2017_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","યાજક તે પક્ષીને બે પાંખો વચ્ચેથી ચીરે, પરંતુ તેના બે ભાગ જુદા થવા ન દે. પછી યાજક વેદી પરના અગ્નિ પરનાં લાકડાં પર તેનું દહન કરે. તે યહોવાહને માટે સુવાસિત દહનીયાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","જ્યારે કોઈ વ્યક્તિ યહોવાહને ખાદ્યાર્પણ ચઢાવે ત્યારે તેનું અર્પણ મેંદાનું હોય અને તે તેના પર તેલ રેડે અને તેના પર ધૂપ મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","તે હારુનના પુત્રોની પાસે એટલે યાજકોની પાસે તે લાવે અને તે તેમાંથી એક મુઠ્ઠીભર મેંદાનો લોટ, તેલ અને ધૂપ લે. પછી યાજક યહોવાહની કરુણાની યાદગીરી માટે સુવાસિત ખાદ્યાર્પણ તરીકે વેદી પર તેનું દહન કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ખાદ્યાર્પણમાંથી જે બાકી રહે તે હારુનનું તથા તેના પુત્રોનું થાય. તે યહોવાહના હોમયજ્ઞોમાં સૌથી પરમપવિત્ર વસ્તુ ઈશ્વરને માટે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","જ્યારે તું ભઠ્ઠીમાં પકાવેલું ખાદ્યાર્પણ ચઢાવે, ત્યારે તે મેંદાનું જ હોય અને તે તેલથી મોહેલા લોટની બેખમીર રોટલીઓ અથવા તેલ ચોપડેલા બેખમીરી ખાખરા જ હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","જો તારું અર્પણ તવામાં પકાવેલું ખાદ્યાર્પણ હોય, તો તે પણ તેલથી મોહેલા મેંદાનું જ બનાવેલું અને બેખમીરી હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","તારે તેના ભાગ કરીને ટુકડા કરવા અને તેના પર તેલ રેડવું. આ ખાદ્યાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","જો તારું ખાદ્યાર્પણ કઢાઈમાં પકાવેલું હોય, તો તે તેલમાં તળીને મેંદાનું બનાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","આ રીતે શેકેલું, તળેલું ખાદ્યાર્પણ તારે યહોવાહની આગળ લાવવું અને તે યાજક આગળ રજૂ કરવું અને તે તેને વેદી પાસે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","પછી યાજક તે ખાદ્યાર્પણમાંથી કેટલુંક યાદગીરી માટે કાઢીને વેદી પર તેનું દહન કરે. તે યહોવાહને માટે સુવાસિત હોમયજ્ઞ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ખાદ્યાર્પણમાંથી જે બાકી રહે તે હારુનનું તથા તેના પુત્રોનું થાય. તે યહોવાહને અર્પિત કરેલું યહોવાહના હોમયજ્ઞમાં પરમપવિત્ર વસ્તુ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","જે ખાદ્યાર્પણ તમે યહોવાહ પ્રત્યે ચઢાવો તેઓમાંનું કોઈ પણ ખમીરવાળું બનાવેલું ન હોય, કેમ કે તમારે યહોવાહના હોમયજ્ઞ તરીકે કંઈ પણ ખમીરનું અથવા કંઈ પણ મધનું દહન કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","પ્રથમ ફળના અર્પણ તરીકે તેઓને તમારે યહોવાહ પ્રત્યે ચઢાવવા, પણ સુવાસને માટે વેદી પર તેઓ ચઢે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","તમારે તમારાં ખાદ્યાર્પણના પ્રત્યેક અર્પણમાં મીઠું નાખવું. તમારા ખાદ્યાર્પણમાં ઈશ્વરના કરારના મીઠાની ખામી રહેવા ન દો. તમારા પ્રત્યેક અર્પણ સાથે તમે તમારે મીઠું ચઢાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","જો તમે યહોવાહ પ્રત્યે પ્રથમ ફળનું ખાદ્યાર્પણ ચઢાવો, તો તમારા પ્રથમ ફળના ખાદ્યાર્પણને માટે ભરેલાં કણસલાં અંગારા પર શેકીને તાજાં કણસલાંનો પોંક પાડીને તમારે ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","તે પર તમારે તેલ રેડવું અને તે પર લોબાન મૂકવો. એ ખાદ્યાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","પછી યાજક પ્રતીકરૂપે તે પોંકમાંથી થોડો પોંક, તેલમાંથી થોડું તેલ તથા તે પરનો બધો લોબાન લઈને યહોવાહને ખાદ્યાર્પણ તરીકે વેદીની અગ્નિમાં દહન કરે. તે યહોવાહને માટે હોમયજ્ઞ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","જો કોઈનું અર્પણ શાંત્યર્પણનો યજ્ઞ હોય અને જો તે જાનવર ચઢાવે, પછી તે નર હોય કે નારી હોય, તો યહોવાહ પ્રત્યે તે ખોડખાંપણ વગરનું ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","તે પોતાના અર્પણના માથા પર પોતાનો હાથ મૂકે અને મુલાકાતમંડપના દ્વાર પાસે તેને કાપે. પછી યાજકો, એટલે હારુનના પુત્રો તેનું રક્ત વેદીની ચારે બાજુએ છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","તે શાંત્યર્પણના યજ્ઞમાંથી યહોવાહ પ્રત્યે હોમયજ્ઞ ચઢાવે. આંતરડાની આસપાસની ચરબી તથા આંતરડાં પરની બધી ચરબી, ");
INSERT INTO guj2017_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","બન્ને મૂત્રપિંડ તથા તે પરની ચરબી જાંઘો પાસે હોય છે તે તથા મૂત્રપિંડ સાથે કલેજા પરનું ચરબીનું પડ તે કાઢી લે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","હારુનના પુત્રો વેદી પરના અગ્નિ પર લાકડા ઉપરના દહનીયાર્પણ પર તેનું દહન કરે. તે યહોવાહને માટે સુવાસિત હોમયજ્ઞ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","જો કોઈ માણસ શાંત્યર્પણ તરીકે ઘેટાંબકરાંને યહોવાહ સમક્ષ લાવે, પછી તે નર હોય કે નારી હોય, તો તે શાંત્યર્પણ ખોડખાંપણ વગરનું ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","જો તે હલવાનનું અર્પણ ચઢાવે, તો તે તેને યહોવાહની આગળ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","તે પોતાના અર્પણના માથા પર પોતાનો હાથ મૂકે અને મુલાકાતમંડપની આગળ તેને કાપે. પછી હારુનના પુત્રોએ તેનું રક્ત વેદીની ચારે બાજુએ છાંટવું. ");
INSERT INTO guj2017_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","શાંત્યર્પણના યજ્ઞમાંથી તે યહોવાહને સારુ હોમયજ્ઞ ચઢાવે. તેની ચરબી, તેની પુષ્ટ પૂછડી આખી અને આખી કરોડના હાડકાની લગોલગથી તે કાપી લે અને આંતરડાની આસપાસની ચરબી તથા આંતરડા પરની સઘળી ચરબી, ");
INSERT INTO guj2017_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","બન્ને મૂત્રપિંડો તથા તેની પરની કમર પાસેની ચરબી અને મૂત્રપિંડ સાથે કલેજા પરનું અંતરપડ તે કાઢી લે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","અને યાજક વેદી પર તેનું દહન કરે; તે યહોવાહને માટે હોમયજ્ઞરૂપ ખાદ્ય પદાર્થ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","જો માણસનું અર્પણ બકરાનું હોય, તો તે યહોવાહની આગળ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","તે બકરાના માથા પર પોતાનો હાથ મૂકે અને મુલાકાતમંડપની આગળ તેને કાપે. પછી હારુનના પુત્રોએ તેનું રક્ત વેદીની ચારે બાજુએ છાંટવું. ");
INSERT INTO guj2017_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","તે માણસ અગ્નિથી પોતાનું અર્પણ યહોવાહને માટે ચઢાવે. તે આંતરડાની આસપાસની ચરબી તથા આંતરડા પરની સઘળી ચરબી કાઢી લે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","બન્ને મૂત્રપિંડો અને તેની પરની કમર પાસેની ચરબી, મૂત્રપિંડો પાસે કલેજા પરનું અંતરપડ તે કાઢી લે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","આ તમામનું યાજકે શાંત્યર્પણ તરીકે દહન કરવું, તે સુવાસને સારુ હોમયજ્ઞરૂપ ખાદ્ય પદાર્થ છે. સઘળી ચરબી યહોવાહની છે. ");
INSERT INTO guj2017_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","તમારી વંશપરંપરા તમારાં સઘળાં રહેઠાણોમાં એ હંમેશને માટે તમારો વિધિ થાય, એટલે ચરબી કે રક્ત તમારે ખાવાં જ નહિ.’” ");
INSERT INTO guj2017_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ઇઝરાયલના લોકોને કહે, ‘જે કૃત્યો કરવાની યહોવાહે મના કરી છે તે ન કરવા તેનું પાલન કરે, જો કોઈ વ્યક્તિ અજાણતા મારી આજ્ઞાઓનું ઉલ્લંઘન કરે તેને માટે આ નિયમો છે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","જો પ્રમુખ યાજક પાપ કરીને લોકો પર દોષ મૂકે, તો જે પાપ તેણે કર્યું હોય તેને લીધે પાપાર્થાર્પણને સારુ તે યહોવાહ પ્રત્યે ખોડખાંપણ વગરનો એક જુવાન બળદ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","તે બળદને મુલાકાતમંડપના પ્રવેશદ્વાર પાસે યહોવાહની આગળ લાવે અને બળદના માથા પર પોતાનો હાથ મૂકીને તેને યહોવાહની સમક્ષ કાપે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","અભિષિક્ત યાજક તે બળદના રક્તમાંથી કેટલુંક લઈને મુલાકાતમંડપમાં લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","યાજક પોતાની આંગળી તે રક્તમાં બોળીને તેમાંથી યહોવાહની આગળ પરમપવિત્રસ્થાનના પડદાની સામે સાત વાર છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","સુવાસિત દહનીયાર્પણની વેદી મુલાકાતમંડપમાં યહોવાહની આગળ છે તેનાં શિંગ પર યાજક તે રક્તમાંથી ચોપડે અને જે યજ્ઞવેદી મુલાકાતમંડપના પ્રવેશદ્વાર પાસે છે તેના થડમાં બળદનું સઘળું રક્ત તે રેડી દે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","તેણે પાપાર્થાર્પણના બળદની બધી ચરબી કાઢી લેવી; આંતરડાં પરની અને તેની આસપાસની ચરબી, ");
INSERT INTO guj2017_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","બે મૂત્રપિંડો તથા તેની પરની કમર પાસેની ચરબી અને કલેજા પરનું અંતરપડ મૂત્રપિંડો સુદ્ધાં તેણે કાઢી લેવું. ");
INSERT INTO guj2017_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","જેમ તે શાંત્યર્પણના યજ્ઞના બળદમાંથી કાઢી લેવાય છે તેમ, યાજક દહનીયાર્પણની વેદી પર તેઓનું દહન કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","બળદનું ચામડું, તેનું બાકીનું માંસ, તેનું માથું, તેના પગ, તેનાં આંતરડા તથા તેનું છાણ, ");
INSERT INTO guj2017_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","બળદનો બાકીનો ભાગ, તે છાવણીની બહાર કોઈ સ્વચ્છ જગ્યાએ, એટલે રાખ નાખવાની જગ્યાએ લાકડાં સળગાવીને તેને બાળી મૂકે. જ્યાં રાખ નાખવામાં આવે છે ત્યાં તેને બાળી નાખવામાં આવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","જો સમગ્ર ઇઝરાયલની પ્રજા અજાણતાં પાપ કરીને, તે બાબત સમુદાયની નજરથી ગુપ્ત રહેલી હોય અને જે કૃત્યો કરવાની યહોવાહે મના કરેલી છે તેમાંનું કોઈ કૃત્ય કરીને તેઓ દોષિત થયા હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","તો જ્યારે જે પાપ તેઓએ કર્યુ હોય તેની જાણ પડે ત્યારે સમુદાય પાપાર્થાર્પણને માટે એક જુવાન બળદ ચઢાવે અને તેને મુલાકાતમંડપની આગળ લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","સભાના વડીલો યહોવાહની આગળ તે બળદના માથા પર પોતાના હાથ મૂકે અને યહોવાહની સમક્ષ તે બળદ કપાય. ");
INSERT INTO guj2017_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","અભિષિક્ત યાજક તે બળદનું થોડું રક્ત મુલાકાતમંડપમાં લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","યાજક પોતાની આંગળી તે રક્તમાં બોળીને યહોવાહની સમક્ષ સાત વાર પડદા પર છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","જે વેદી યહોવાહની સમક્ષ મુલાકાતમંડપમાં છે તેના શિંગ પર તે રક્તમાંથી થોડું રક્ત રેડે અને બાકીનું બધું રક્ત મુલાકાતમંડપના પ્રવેશદ્વાર આગળની દહનીયાર્પણની વેદીનાં પાયામાં રેડી દેવું. ");
INSERT INTO guj2017_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","તેણે બળદની બધી ચરબી કાઢી લઈને વેદી પર બાળી મૂકવી. ");
INSERT INTO guj2017_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","એ બળદને તે આ પ્રમાણે કરે. પાપાર્થાર્પણના બળદની જેમ જ તેણે એ બળદનું પણ કરવું અને યાજક લોકોને માટે પ્રાયશ્ચિત કરે અને તેઓને માફ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","તે બળદને છાવણીની બહાર લઈ જાય અને જેમ તેણે પહેલા બળદને બાળી નાખ્યો હતો તેમ એને પણ બાળી દે. તે આખી પ્રજાને માટે પાપાર્થાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","જ્યારે કોઈ અધિકારી પાપ કરીને જે બધાં કૃત્યો કરવાની તેના ઈશ્વર યહોવાહે મના કરીને આજ્ઞા આપી છે તેમાંનું કોઈ પાપ અજાણે કરીને દોષિત ઠરે, ");
INSERT INTO guj2017_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ત્યારે જો જે પાપ વિષે તે દોષિત થયો હોય તેની તેને જાણ કરવામાં આવે, તો તે એક બકરાનું એટલે એક ખોડખાંપણ વગર વગરના નરનું અર્પણ લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","બકરાના માથા પર તે પોતાનો હાથ મૂકીને જ્યાં યહોવાહની સમક્ષ દહનીયાર્પણ કપાય છે ત્યાં તે તેને કાપે. આ પાપાર્થાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","યાજક પોતાની આંગળી વડે પાપાર્થાર્પણના રક્તમાંનું લઈને દહનીયાર્પણની વેદીનાં શિંગ પર તે લગાડે અને બાકીનું રક્ત યજ્ઞવેદીના પાયામાં રેડી દે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","શાંત્યર્પણના યજ્ઞની ચરબીની જેમ તેની બધી ચરબીનું દહન કરે. તેના પાપને લીધે યાજક તેને માટે પ્રાયશ્ચિત કરે, એટલે તેને ક્ષમા કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","જે કૃત્યો કરવાની યહોવાહે મના કરી છે તેમાંનું કોઈ પણ પાપ કરીને કોઈ સામાન્ય માણસ અજાણતા પાપ કરે અને જો તે દોષમાં પડે, ");
INSERT INTO guj2017_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","તો જો, જે પાપ વિષે તે દોષિત થયો હોય તેની તેને જાણ કરવામાં આવે, તો તે એક ખોડખાંપણ વગરની બકરીનું અર્પણ લાવે, જે પાપ વિષે તે દોષિત થયો હોય તેને લીધે તે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","તે પોતાના હાથ પાપાર્થાર્પણના માથા પર મૂકે અને દહનીયાર્પણની જગ્યાએ પાપાર્થાર્પણને કાપે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","યાજક પોતાની આંગળી વડે તેના રક્તમાંનું થોડું રક્ત લઈને દહનીયાર્પણની વેદીનાં શિંગ પર તે લગાડે અને બાકીનું બધું જ રક્ત વેદીના પાયામાં રેડી દે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","જેમ શાંત્યર્પણના યજ્ઞની ચરબી કાઢી લેવામાં આવે છે તેમ તેની બધી ચરબી તે કાઢી લે. યાજક યહોવાહ પ્રત્યે સુવાસને માટે વેદી પર તેનું દહન કરે. યાજક તેને માટે પ્રાયશ્ચિત કરે, એટલે તેને ક્ષમા કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","જો કોઈ માણસ પાપાર્થાર્પણને માટે હલવાનનું અર્પણ લાવે તો તે ખોડખાંપણ વગરની નારી લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","તે પોતાનો હાથ પાપાર્થાર્પણના માથા પર મૂકે અને જ્યાં દહનીયાર્પણ કપાય છે, ત્યાં તે જગ્યાએ પાપાર્થાર્પણને માટે તેને કાપે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","યાજક પોતાની આંગળી વડે પાપાર્થાર્પણના રક્તમાંનું થોડું રક્ત લઈને દહનીયાર્પણની વેદીનાં શિંગ પર લગાડે અને બાકીનું બધું રક્ત વેદીના પાયામાં રેડી દે. ");
INSERT INTO guj2017_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","જેમ શાંત્યર્પણના યજ્ઞમાંથી હલવાનની ચરબી કાઢી લેવામાં આવે છે તેમ તેની બધી ચરબી તે કાઢી લે અને યાજક યહોવાહના હોમયજ્ઞોની રીત પ્રમાણે વેદી પર તેઓનું દહન કરે. જે પાપ વિષે તે દોષિત થયો હોય તેને લીધે યાજક તેને માટે પ્રાયશ્ચિત કરે અને તે માણસને માફ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","જો કોઈ પણ વ્યક્તિ સાક્ષી હોવા છતાં તેને શપથ આપવામાં આવે, તો તેણે પોતે જ જોયેલું કે જાણેલું હોય તે ન જણાવે તો તે પાપમાં પડે અને તેને માટે તે પોતે જવાબદાર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","અથવા જે બાબત ઈશ્વરે અશુદ્ધ તરીકે ઠરાવેલી છે તેનો જો કોઈ માણસ સ્પર્શ કરે, એટલે અશુદ્ધ પશુનો મૃતદેહ, જાનવરનો મૃતદેહ, અશુદ્ધ સર્પટિયાના મૃતદેહનો સ્પર્શ કરે અને તે વ્યક્તિના જાણવામાં ન આવતાં તેણે તેનો સ્પર્શ કર્યો હોય તો તે અશુદ્ધ અને દોષિત ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","અથવા જો કોઈ માણસ કોઈપણ અશુદ્ધતાથી અશુદ્ધ થયો હોય અને તેની અશુદ્ધતાનો જો કોઈ સ્પર્શ કરે અને તે તેના જાણવામાં આવ્યું ન હોય, તો જ્યારે તે તેના જાણવામાં આવે ત્યારે તે દોષિત ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","અથવા જો કોઈ માણસ દુષ્ટતા કરવાના અથવા સારું કરવાના સોગન પોતાના હોઠોથી વગર વિચારે ખાઈને ગમે તેમ તે કહે અને જો તે તેના જાણવામાં આવ્યું ન હોય, તો જ્યારે તે તેના જાણવામાં આવે ત્યારે તે તેઓમાંથી એક વિષે દોષિત ઠરે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","જ્યારે તે તેઓમાંથી એક વિષે દોષિત ઠરે ત્યારે એમ થાય કે જે વિષે તેણે પાપ કર્યું હોય તે તે કબૂલ કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","પછી જે પાપ તેણે કર્યું હોય તેને લીધે યહોવાહને માટે તે પોતાનું દોષાર્થાર્પણ લાવે, એટલે પાપાર્થાર્પણને માટે ટોળામાંથી નારી જાતનું એક જાનવર, એટલે ઘેટું કે બકરી અને યાજક તેના પાપને લીધે તેને માટે પ્રાયશ્ચિત કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","જો તે હલવાનને ખરીદી ના શકતો હોય, તો જે પાપ તેણે કર્યું હોય તેને લીધે દોષાર્થાર્પણને સારુ તે યહોવાહને માટે બે હોલા અથવા કબૂતરનાં બે બચ્ચાં લાવે, એક પાપાર્થાર્પણને માટે અને બીજું દહનીયાર્પણને માટે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","તે તેઓને યાજક પાસે લાવે, પાપાર્થાર્પણને માટે જે હોય તેને તે પ્રથમ ચઢાવે અને તે તેની ગરદન પરથી તેનું માથું મરડી નાખે, પણ તેના શરીર પરથી તેની ગરદન જુદી ન કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","પછી તેણે પાપાર્થાર્પણના રક્તમાંનું થોડું રક્ત વેદીની બાજુ પર છાંટવું અને બાકીનું રક્ત વેદીના પાયામાં રેડી દેવું. એ પાપાર્થાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","પછી બીજું પક્ષી તે વિધિપૂર્વક દહનીયાર્પણ તરીકે ચઢાવે, તેણે જે પાપ કર્યું હોય તેને લીધે યાજક તેને માટે પ્રાયશ્ચિત કરે અને તેને માફ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","પણ જો કોઈ તે બે હોલા કે કબૂતરનાં બે બચ્ચાં ખરીદીને ચઢાવી ના શકે, તો જે પાપ તેણે કર્યું હોય તેને લીધે પાપાર્થાર્પણને માટે એક દશાંશ એફાહ મેંદાનો લોટ તે પોતાને માટે અર્પણ લાવે. તેણે તેમાં તેલ કે લોબાન ન મૂકવાં, કારણ કે તે તો પાપાર્થાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","તે તેને યાજક પાસે લાવે અને યાજક પ્રતીક તરીકે તેમાંથી મુઠ્ઠી ભરીને લોટ લઈ વેદી પર યહોવાહને ચઢાવેલાં ખાદ્યાર્પણ સાથે દહન કરે. એ પાપાર્થાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","આ કૃત્યોમાંના જે કોઈ વિષે તેણે પાપ કર્યું હોય તો યાજક તેને માટે પ્રાયશ્ચિત કરે અને તે વ્યક્તિને માફ કરવામાં આવશે. ખાદ્યાર્પણની જેમ બાકીનું અર્પણ યાજકનું થાય.’” ");
INSERT INTO guj2017_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“જો કોઈ વ્યક્તિ આજ્ઞાનું ઉલ્લંઘન કરીને યહોવાહની પવિત્ર વસ્તુઓ વિષે અજાણતાં પાપ કરે, તો તે યહોવાહ પ્રત્યે પોતાનું દોષાર્થાર્પણ લાવે. ટોળાંમાંથી ખોડખાંપણ વગરનો એક ઘેટો, શેકેલ ચાંદી, પવિત્રસ્થાનના શેકેલ પ્રમાણે, દોષાર્થાર્પણને માટે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","જે પવિત્ર વસ્તુ વિષે તેણે પાપ કર્યું હોય તેનો બદલો તે ભરી આપે અને વળી તેનો એક પંચમાંશ તેમાં ઉમેરીને યાજકને તે આપે. પછી યાજક તેને માટે દોષાર્થાર્પણના ઘેટા વડે પ્રાયશ્ચિત કરે અને તેને માફ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","યહોવાહે આપેલી કોઈ પણ આજ્ઞાનું ઉલ્લંઘન જો કોઈ વ્યક્તિ અજાણતાથી કરીને પાપ કરે, તો તે દોષિત ઠરે અને તેના પાપની જવાબદારી તેને માથે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","તે દોષાર્થાર્પણને માટે ટોળાંમાંનો ખોડખાંપણ વગરનો ઘેટો યાજક પાસે લાવે અને જે પાપ તેણે અજાણતાં કર્યું હોય, તો તે વિષે યાજક તેને માટે પ્રાયશ્ચિત કરે, એટલે તેને ક્ષમા કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","આ દોષાર્થાર્પણ છે અને તે નિશ્ચે યહોવાહની આગળ દોષિત છે.” ");
INSERT INTO guj2017_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“જો કોઈ વ્યક્તિ પાપ કરીને યહોવાહની આજ્ઞાનો ઉલ્લંઘન કરે, એટલે ખોટા વ્યવહારમાં, ગીરવે મૂકવાની બાબતમાં, લૂંટફાટની બાબતમાં પોતાના પડોશીને દગો કરે અથવા તેણે પોતાના પડોશી પર જુલમ ગુજાર્યો હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","અથવા કોઈની ખોવાયેલી વસ્તુ તેને મળી હોય તે વિષે તે દગો કરે અને જૂઠા સોગન ખાય અથવા જો કોઈ માણસ આ બધામાંથી કંઈપણ કરીને પાપ કરે, ");
INSERT INTO guj2017_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","જો તે પાપ કરીને દોષિત થયો હોય, તો એમ થાય કે, જે તેણે પડાવી લીધું હોય અથવા જે વસ્તુ તેણે જુલમથી મેળવી હોય અથવા જે અનામત તેને સોંપાયેલી હોય અથવા જે ખોવાયેલી વસ્તુ તેને મળી હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","અથવા જે કોઈ ચીજ વિષે તેણે જૂઠા સોગન ખાધા હોય, તે તે પાછી આપે, તે ભરીપૂરીને પાછું આપે એટલું જ નહિ, પણ તેમાં એક પંચમાંશ ઉમેરે, તે દોષિત ઠરે તે જ દિવસે તેણે જેનું તે હોય તેને તે આપવું ");
INSERT INTO guj2017_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","પછી તે યહોવાહની આગળ પોતાનું દોષાર્થાર્પણ લાવે: ટોળાંમાંનો એક ખોડખાંપણ વગરનો ઘેટો યાજક પાસે દોષાર્થાર્પણને માટે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","યાજક યહોવાહ સમક્ષ તેને માટે પ્રાયશ્ચિત કરે અને જે કોઈ કૃત્યથી તે દોષિત થયો હશે, તેની તેને ક્ષમા કરવામાં આવશે.” ");
INSERT INTO guj2017_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“હારુન તથા તેના પુત્રોને આજ્ઞા કર કે, ‘આ દહનીયાર્પણના નિયમો છે: દહનીયાર્પણો આખી રાત સવાર સુધી વેદી પરની કઢાઈ ઉપર રહે અને વેદીના અગ્નિને તેની ઉપર સળગતો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","અને યાજક અંદર તથા બહાર શણનાં વસ્ત્રો પહેરે. અગ્નિએ ભસ્મ કરેલા વેદી પરના દહનીયાર્પણની રાખ લઈને તે વેદીની બાજુમાં ભેગી કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","તે પોતાના વસ્ત્રો બદલે અને બીજા વસ્ત્રો પહેરીને તે રાખને છાવણી બહાર સ્વચ્છ જગ્યાએ લઈ જાય. ");
INSERT INTO guj2017_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","વેદી પરનો અગ્નિ સતત સળગતો રાખવો. તેને હોલવાઈ જવા ન દેવો અને પ્રતિદિન સવારે યાજક તે પર લાકડાં બાળે. તે તેના ઉપર દહનીયાર્પણ ગોઠવે અને તેના ઉપર શાંત્યર્પણની ચરબીનું દહન કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","વેદીનો અગ્નિ સતત સળગતો રાખવો. તેને હોલવાઈ જવા ન દેવો. ");
INSERT INTO guj2017_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ખાદ્યાર્પણનો નિયમ આ છે: હારુનના પુત્રો ખાદ્યાર્પણને યહોવાહની સમક્ષ વેદી સામે ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","યાજક ખાદ્યાર્પણોમાંથી એક મુઠ્ઠી ભરીને મેંદો, તેલ અને બધું જ લોબાન પ્રતીક તરીકે લઈને યહોવાહને માટે સુવાસને અર્થે વેદી પર તેનું દહન કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","તેમાંથી જે બાકી રહે તે હારુન તથા તેના પુત્રો ખાય. તેને પવિત્ર જગ્યામાં ખમીર વગર ખાવું. મુલાકાતમંડપનાં આંગણામાં તેઓ તે ખાય. ");
INSERT INTO guj2017_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","તેને ખમીર સહિત શેકવું નહિ. મેં અગ્નિ દ્વારા મળેલ ખાદ્યાર્પણના તેમના ભાગરૂપે તેમને આપેલા છે. પાપાર્થાર્પણની જેમ તથા દોષાર્થાર્પણની જેમ તે પરમપવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","હારુનના વંશજોમાંની કોઈ પણ વ્યક્તિ તે ખાઈ શકશે, યહોવાહને અગ્નિથી ચઢાવેલા ખાદ્યાર્પણના અર્પણનો તેમને પેઢી દર પેઢી કાયમનો ભાગ મળશે. જે કોઈ તેનો સ્પર્શ કરશે તે શુદ્ધ બની જશે.’” ");
INSERT INTO guj2017_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","તેથી યહોવાહે મૂસાને ફરીથી કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“હારુનનો અભિષેક થાય તે દિવસે તેણે તથા તેના પુત્રોએ યહોવાહને માટે આ અર્પણ કરવું: એટલે ખાદ્યાર્પણને માટે નિયમિત એક દશાંશ એફાહ મેંદાનો લોટ, તેમાંથી અર્ધો સવારે તથા અર્ધો સાંજે અર્પણ કરવામાં આવે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","તેને ભઠ્ઠીમાં તવી ઉપર તેલથી તળવામાં આવે. જ્યારે તે તળાઈ જાય ત્યારે તેને અંદર લાવવો. તળેલા મેંદાના ચોસલાં પાડીને યહોવાહ સમક્ષ સુવાસને અર્થે તારે ખાદ્યાર્પણ ચઢાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","તેના પુત્રોમાંનો જે અભિષિક્ત યાજક તેની પદવીએ આવે તે તે ચઢાવે. હંમેશના વિધિથી તેનું યહોવાહને માટે પૂરેપૂરું દહન કરાય. ");
INSERT INTO guj2017_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","યાજકના પ્રત્યેક ખાદ્યાર્પણનું પૂરેપૂરું દહન કરવું. તે ખાવું નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","યહોવાહે ફરીથી મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“હારુન તથા તેના પુત્રોને એમ કહે કે, ‘પાપાર્થાર્પણનો નિયમ આ છે: જ્યાં દહનીયાર્પણ કપાય છે, ત્યાં યહોવાહની આગળ પાપાર્થાર્પણ પણ કપાય છે. તે પરમપવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","જે યાજક પાપને માટે તેનું અર્પણ કરે, તે એ ખાય. મુલાકાતમંડપના આંગણામાં, એટલે પવિત્રસ્થાને જમવું. ");
INSERT INTO guj2017_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","જે કોઈ તેના માંસનો સ્પર્શ કરે તે પવિત્ર ગણાય અને જો તેનું રક્ત કોઈપણના વસ્ત્ર પર પડે, તો જેના પર તે પડ્યું હોય, તેને તારે પવિત્રસ્થાને ધોઈ નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","પણ માટીનાં જે વાસણમાં માંસને બાફ્યું હોય તે માટીના વાસણને ભાંગી નાખવું. જો માંસ પિત્તળના વાસણમાં બાફ્યું હોય, તો તેને ઘસીને ચોખ્ખા પાણીથી ધોઈ નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","યાજકમાંનો કોઈ પણ પુરુષ તેમાંથી થોડું ખાય કેમ કે તે પરમપવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","અને જેના રક્તમાંનું પવિત્રસ્થાનમાં પ્રાયશ્ચિત કરવા માટે મુલાકાતમંડપમાં કંઈ લાવવામાં આવ્યું હોય, તેવું કોઈ પાપાર્થાર્પણ ખવાય નહિ. તેને અગ્નિમાં બાળી નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","દોષાર્થાર્પણનો નિયમ આ છે. તે પરમપવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","જે જગ્યાએ દહનીયાર્પણ કપાય છે, ત્યાં તેઓ દોષાર્થાર્પણ કાપે અને તેનું રક્ત તેઓ વેદીની ચારે બાજુએ છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","તેણે તેમાંની બધી ચરબી કાઢી લઈ વેદી પર ચઢાવવી: પુષ્ટ પૂંછડી, આંતરડાં પરની ચરબી, ");
INSERT INTO guj2017_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","બન્ને મૂત્રપિંડો અને કમરના નીચલા ભાગના સ્નાયુ પરની ચરબી તથા કલેજા પરનો ચરબીવાળો ભાગ મૂત્રપિંડો સહિત કાઢી લેવાં. ");
INSERT INTO guj2017_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","યાજક યહોવાહ પ્રત્યે હોમયજ્ઞને માટે વેદી પર તેમનું દહન કરે. આ દોષાર્થાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","યાજકોમાંનો દરેક પુરુષ તે ખાઈ શકે. તેને પવિત્રસ્થાને જ ખાવું કેમ કે તે પરમપવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","પાપાર્થાર્પણ દોષાર્થાર્પણ જેવું જ છે. તે બન્નેને માટે એક સરખા જ નિયમો લાગુ પડે છે. જે યાજક તે વડે પ્રાયશ્ચિત કરે, તેને તે મળે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","જે યાજક કોઈ માણસ વતી દહનીયાર્પણ ચઢાવે, તે જ યાજક પોતે ચઢાવેલા દહનીયાર્પણનું ચામડું પોતાને માટે લે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ભઠ્ઠીમાં શેકેલું, કડાઈમાં કે તવામાં તળેલું સર્વ ખાદ્યાર્પણ તે ચઢાવનાર યાજકનું થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","સર્વ તેલવાળું કે તેલ વગરનું ખાદ્યાર્પણ હારુનના સર્વ વંશજોના સરખે ભાગે ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","આ શાંત્યર્પણોના યજ્ઞો યહોવાહ પ્રત્યે જે લોકો ચઢાવે, તેનો નિયમ આ પ્રમાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","જો કોઈ વ્યક્તિ આભારસ્તુતિ માટે અર્પણ ચઢાવતી હોય, તો તે આભારર્થાર્પણની સાથે ખમીર વગરની રોટલી, પણ તે તેલ સાથે મિશ્ર કરેલી હોય, પૂરીને ખમીર વગર બનાવવી, પણ તેના પર તેલ લગાવવું અને કેકને મોહેલા મેંદાના લોટથી બનાવવી. ");
INSERT INTO guj2017_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","આભારસ્તુતિને અર્થે પોતાના શાંત્યર્પણના અર્પણ સાથે ખમીરવાળી રોટલીનું તે અર્પણ કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","તેમાંના પ્રત્યેક અર્પણમાંથી દરેક વસ્તુ યહોવાહને માટે ઉચ્છાલીયાર્પણ તરીકે તે ચઢાવે. શાંત્યર્પણોનું રક્ત વેદી પર છાંટનાર યાજકનું તે ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","આભારસ્તુતિને માટેનાં શાંત્યર્પણોના યજ્ઞનું માંસ અર્પણને દિવસે જ તે ખાઈ જાય. તે તેમાંથી કંઈ પણ બીજા દિવસની સવાર સુધી રહેવા ન દે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","પણ જો તેનું યજ્ઞાર્પણ એ કોઈ માનતા કે ઐચ્છિકાર્પણ હોય, તો જે દિવસે તે પોતાનું અર્પણ ચઢાવે તે દિવસે તે એ ખાય, પણ બાકી રહેલું માંસ તે બીજે દિવસે ખાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","પણ યજ્ઞના માંસમાંનું જે કંઈ ત્રીજા દિવસ સુધી રહે તેને અગ્નિમાં બાળી નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","જો તેનાં શાંત્યર્પણના યજ્ઞના માંસમાંનું કંઈ પણ ત્રીજે દિવસે ખાવામાં આવે તો તે માન્ય થશે નહિ, તેમ જ અર્પણ કરનારનાં લાભમાં તે ગણાશે પણ નહિ. તે વસ્તુ અમંગળ ગણાશે અને જે માણસ તેમાંનું ખાશે તેનો દોષ તેને માથે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","જે માંસને કોઈ અપવિત્ર વસ્તુનો સ્પર્શ થાય તે ખાવું નહિ. તેને અગ્નિમાં બાળી મૂકવું. જે વ્યક્તિ શુદ્ધ હોય, તે તે માંસ ખાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","પણ જે કોઈ માણસ અશુદ્ધ હોવા છતાં શાંત્યર્પણમાંથી, એટલે જે યહોવાહનું છે, તે ખાય તો તેને તેના લોકોથી જુદો કરવો, કારણ કે તેણે જે પવિત્ર છે તેને અશુદ્ધ કર્યુ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","જો કોઈ માણસ અશુદ્ધ વસ્તુનો, એટલે મનુષ્યના અશુદ્ધપણાનો, અશુદ્ધ પશુનો અથવા કોઈપણ અશુદ્ધ કે અમંગળ વસ્તુનો સ્પર્શ કરે અને યહોવાહને માટેનાં શાંત્યર્પણના યજ્ઞનું માંસ ખાય, તે વ્યક્તિ પોતાના લોકોમાંથી અલગ કરાય.’” ");
INSERT INTO guj2017_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ઇઝરાયલી લોકોને બોલાવીને કહે કે, ‘તમારે કોઈ બળદ, ઘેટાં અથવા બકરાની ચરબી ખાવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","કુદરતી રીતે મૃત્યુ પામેલ અથવા કોઈ જંગલી પ્રાણીએ મારી નાખેલા પશુની ચરબીનો બીજી કોઈપણ રીતે તેનો ઉપયોગ કરવો પણ તમારે તે ખાવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","જો કોઈ માણસ યહોવાહને પ્રત્યે જે પશુનો હોમયજ્ઞ ચઢાવે છે તેની ચરબી જે કોઈ ખાય, તે ખાનાર માણસ પોતાના લોકોમાંથી અલગ કરાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","તમે કોઈપણ પ્રકારનું રક્ત, પછી તે પક્ષીનું હોય કે પશુનું હોય, તે તમારા કોઈપણ ઘરોમાં ન ખાઓ. ");
INSERT INTO guj2017_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","જે વ્યક્તિ કોઈપણનું રક્ત ખાય તો તે માણસ તેના લોકોમાંથી અલગ કરાય.’” ");
INSERT INTO guj2017_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","તેથી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ઇઝરાયલી લોકોને આમ કહે કે, ‘જે કોઈ વ્યક્તિ યહોવાહને શાંત્યર્પણ ચઢાવવા લાવે તો તેણે તેનો અમુક ભાગ યહોવાહને વિશેષ ભેટ તરીકે અર્પણ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","તે પોતાના હાથે યહોવાહના હોમયજ્ઞો લાવે. તેણે ચરબી સહિત પ્રાણીની છાતી લાવવી, કે જેથી તેણે છાતીને, આરત્યર્પણને સારુ યહોવાહની આગળ અર્પણ કરાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","યાજકે ચરબીનું વેદીમાં દહન કરવું, પણ છાતીનો ભાગ હારુન તથા તેના વંશજોનો થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","તમારાં શાંત્યર્પણોના યજ્ઞોમાંથી જમણી જાંઘ ઉચ્છાલીયાર્પણને સારુ તમારે યાજકને આપવી. ");
INSERT INTO guj2017_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","જમણી જાંઘ, હારુનના વંશજોમાંનો, યાજક, જે શાંત્યર્પણોનું રક્ત તથા તેની ચરબી ચઢાવે તેના ભાગમાં જાય. ");
INSERT INTO guj2017_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","કેમ કે ઇઝરાયલી લોકોએ ચઢાવેલા શાંત્યર્પણના પશુઓની છાતીનો ભાગ અને જાંઘ હું રાખી લઉં છું અને મેં તે હારુન, પ્રમુખ યાજકને તથા તેના વંશજોને તેઓના હંમેશના બાના તરીકે આપ્યાં છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","જે દિવસે મૂસાએ હારુન તથા તેના પુત્રોને યાજક તરીકે રજૂ કર્યા તે દિવસથી યહોવાહને અગ્નિથી કરેલ અર્પણનો હિસ્સો તે આ પ્રમાણે છે: ");
INSERT INTO guj2017_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","જે દિવસે યાજકનો અભિષેક કરવામાં આવ્યો તે દિવસે યહોવાહે આ ભાગો તેમને આપવાની ઇઝરાયલીઓને આજ્ઞા કરી હતી. આ નિયમ સદા માટે તેમના બધા વંશજોને માટે બંધનકર્તા છે. વંશપરંપરા આ તેઓનો અધિકાર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","દહનીયાર્પણનો, ખાદ્યાર્પણનો, પાપાર્થાર્પણનો, દોષાર્થાર્પણનો, પ્રતિષ્ઠાક્રિયાનો તથા શાંત્યર્પણના યજ્ઞના નિયમો આ પ્રમાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","સિનાઈના અરણ્યમાં યહોવાહને સારુ અર્પણ ચઢાવવાની ઇઝરાયલી લોકોને તેણે આજ્ઞા કરી હતી, તે દિવસે યહોવાહે સિનાઈ પર્વત પર મૂસાને આ પ્રમાણે આજ્ઞા કરી હતી.” ");
INSERT INTO guj2017_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","યહોવાહે મૂસાને કહ્યું હતું, ");
INSERT INTO guj2017_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“હારુન તથા તેની સાથે તેના પુત્રો વસ્ત્રો, અભિષેકનું તેલ, પાપાર્થાર્પણનો બળદ, બે ઘેટા તથા બેખમીર રોટલીઓની ટોપલી લે. ");
INSERT INTO guj2017_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","મુલાકાતમંડપના પ્રવેશદ્વાર આગળ આખી સભાને ભેગી કરે.” ");
INSERT INTO guj2017_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","તેથી મૂસાએ યહોવાહના કહેવા પ્રમાણે કર્યું, સમગ્ર સભા મુલાકાતમંડપના પ્રવેશદ્વાર આગળ ભેગી થઈ. ");
INSERT INTO guj2017_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","પછી મૂસાએ તે સભાને જણાવ્યું કે, “યહોવાહે જે ક્રિયા કરવાની આજ્ઞા આપી હતી તે આ છે.” ");
INSERT INTO guj2017_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","મૂસાએ હારુન તથા તેના પુત્રોને લાવીને પાણીથી સ્નાન કરાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","તેણે હારુનને ઉપવસ્ત્રો પહેરાવ્યાં અને તેની કમરે કમરબંધ બાંધીને જામો પહેરાવ્યો અને તેને એફોદ પહેરાવીને તેણે એફોદનો કારીગરીથી વણેલો પટકો તેની કમરે બાંધ્યો અને એ વડે તેણે તેના શરીર સાથે તે બાંધ્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","તેણે તેને ઉરપત્રક પહેરાવીને ઉરપત્રકમાં તેણે ઉરીમ તથા તુમ્મીમ જોડી દીધા. ");
INSERT INTO guj2017_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ, તેણે તેને માથે પાઘડી પહેરાવી અને પાઘડીના આગળના ભાગમાં તેણે સોનાનું પતરું એટલે પવિત્ર મુગટ લગાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","મૂસાએ અભિષેકનું તેલ લઈને મુલાકાતમંડપ ઉપર અને તેમાંની બધી જ વસ્તુઓ પર છાંટીને તે સર્વને પવિત્ર કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","તેણે વેદી પર સાત વખત તેલ છાંટીને વેદીને તથા તેના સર્વ વાસણોને, હોજને તથા તેના તળિયાને પવિત્ર કરવા સારુ તેઓનો અભિષેક કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","તેણે હારુનના માથા પર અભિષેકનું તેલ રેડ્યું અને તેને પવિત્ર કરવા સારુ તેનો અભિષેક કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","જેમ યહોવાહે મૂસાને આજ્ઞા કરી હતી તેમ, તેણે હારુનના પુત્રોને ઝભ્ભાઓ પહેરાવ્યાં અને તેની કમરે કમરબંધ બાંધ્યા અને માથે પાઘડી બાંધી. ");
INSERT INTO guj2017_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","મૂસા પાપાથાર્પણને માટે બળદને આગળ લાવ્યો અને હારુને તથા તેના પુત્રોએ પાપાર્થાર્પણના બળદના માથા પર તેઓના હાથ મૂક્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","તેણે તે કાપ્યો અને મૂસાએ રક્ત લઈને પોતાની આંગળીથી વેદીનાં શિંગની આસપાસ તે ચોપડ્યું અને વેદીને શુદ્ધ કરીને બાકીનું રક્ત વેદીના પાયામાં તેને માટે રેડી દીધું અને ઈશ્વરને માટે તેને અલગ કરીને પવિત્ર કરી. ");
INSERT INTO guj2017_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","તેણે આંતરડાં પરની બધી જ ચરબી, કલેજા પરની ચરબી અને બન્ને મૂત્રપિંડો તથા તે પરની ચરબી લીધી અને મૂસાએ વેદી પર તેનું દહન કર્યુ. ");
INSERT INTO guj2017_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","પણ જેમ યહોવાહે મૂસાને આજ્ઞા કરી હતી તેમ, તેણે બળદનું ચામડું, તેનું માંસ અને છાણ છાવણી બહાર અગ્નિમાં બાળી નાખ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","મૂસાએ દહનીયાર્પણનો ઘેટો રજૂ કર્યો અને હારુને તથા તેના પુત્રોએ તે ઘેટાના માથા પર પોતાના હાથ મૂક્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","મૂસાએ તેને મારી નાખીને તેનું રક્ત વેદીની આસપાસ છાંટ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","મૂસાએ તે ઘેટાંને કાપીને તેના ટુકડા કર્યા અને તેનું માથું, ચરબી તથા બધા ટુકડાનું દહન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","તેણે આંતરડાં તથા પગ પાણીથી ધોયા અને વેદી પર આખા ઘેટાંનું દહન કર્યું. જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તે મુજબનું એ દહનીયાર્પણ હતું. તે યહોવાહને સારુ હોમયજ્ઞ હતું. ");
INSERT INTO guj2017_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","પછી મૂસાએ બીજા ઘેટાંને, એટલે કે પ્રતિષ્ઠાના ઘેટાંને રજૂ કર્યો અને હારુન તથા તેના પુત્રોએ તે ઘેટાના માથા પર હાથ મૂક્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","હારુને તે કાપ્યો અને મૂસાએ તેનું થોડું રક્ત લઈને હારુનના જમણા કાનની ટીશી પર, તેના જમણા હાથના અંગૂઠા પર તથા તેના જમણા પગના અંગૂઠા પર તે લગાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","તે હારુનના પુત્રોને લાવીને તેમના જમણા કાનની ટીશી પર, તેમના જમણા હાથના અંગૂઠા પર તથા તેમના જમણા પગના અંગૂઠા પર થોડું રક્ત લગાડ્યું. પછી મૂસાએ વેદીની ચારે બાજુએ રક્ત છાંટ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","તેણે ચરબી, જાડી પૂંછડી, આંતરડાં પરની સઘળી ચરબી, કલેજા પરની ચરબી, બન્ને મૂત્રપિંડો અને તેની ચરબી તેમ જ જમણી જાંઘ લીધી. ");
INSERT INTO guj2017_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","જે બેખમીર રોટલીની ટોપલી યહોવાહની સમક્ષ હતી, તેમાંથી તેણે એક બેખમીરી ટુકડો તથા તેલમાં મોહેલી એક નાની રોટલી તથા એક ખાખરો લઈને તેઓને ચરબી ઉપર તથા જમણી જાંઘ ઉપર મૂક્યાં. ");
INSERT INTO guj2017_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","તેણે આ બધું હારુન તથા તેના પુત્રોના હાથમાં મૂકીને યહોવાહ સમક્ષ અર્પણો કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","પછી મૂસાએ તે બધું તેમના હાથમાંથી પાછું લઈને દહનીયાર્પણને માટે વેદી પર તેઓનું દહન કર્યું. તેઓ સુવાસને અર્થે પ્રતિષ્ઠાને માટે હતા. તે યહોવાહને માટે એક અર્પણની ભેટ હતી. ");
INSERT INTO guj2017_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","મૂસાએ પશુની છાતી લઈને યહોવાહની સમક્ષ તેનું અર્પણ કર્યું. જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ, એ તો યાજકના સંકલનના ઘેટામાંથી મૂસાનો હિસ્સો હતો. ");
INSERT INTO guj2017_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","મૂસાએ થોડું અભિષેકનું તેલ અને થોડું વેદી પરનું રક્ત લઈને હારુન તથા તેનાં વસ્ત્રો પર, તેના પુત્રો પર તથા તેની સાથે તેના પુત્રોનાં વસ્ત્રો પર છાંટ્યું. આ રીતે તેણે હારુનને તથા તેના વસ્ત્રોને અને તેના પુત્રોને તથા તેઓના વસ્ત્રોને પવિત્ર કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","તેથી મૂસાએ હારુનને તથા તેના પુત્રોને કહ્યું, “મુલાકાતમંડપના પ્રવેશદ્વાર આગળ તે માંસ બાફો અને જેમ મેં આજ્ઞા કરીને કહ્યું, ‘હારુન તથા તેના પુત્રો તે ખાય,’ તે પ્રમાણે તમે પ્રતિષ્ઠાની ટોપલીમાં જે રોટલી છે તેની સાથે તે ત્યાં ખાઓ. ");
INSERT INTO guj2017_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","તે માંસ તથા રોટલીમાંથી જે બાકી રહે તે અગ્નિમાં બાળી નાખજો. ");
INSERT INTO guj2017_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","સાત દિવસ સુધી એટલે તમારી પ્રતિષ્ઠાના દિવસો પૂર્ણ ન થાય ત્યાં સુધી તમારે મુલાકાતમંડપનું પ્રવેશદ્વાર છોડી બહાર જવું નહિ. કેમ કે સાત દિવસ સુધી યહોવાહ તમારી પ્રતિષ્ઠા કરશે. ");
INSERT INTO guj2017_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","તમારે માટે પ્રાયશ્ચિત કરવા માટે, જેમ આજે કરવામાં આવ્યું છે તેમ કરવાની યહોવાહે આજ્ઞા કરી છે. ");
INSERT INTO guj2017_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","તમારે સાત દિવસ સુધી રાતદિવસ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યહોવાહની આજ્ઞા પાળવી, જેથી તમે માર્યા ન જાઓ, કેમ કે મને એવી આજ્ઞા મળેલી છે.” ");
INSERT INTO guj2017_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","તેથી હારુન તથા તેના પુત્રોએ યહોવાહે મૂસાને આપેલી આજ્ઞાઓ મુજબ બધું જ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","આઠમા દિવસે મૂસાએ હારુનને, તેના પુત્રોને તથા ઇઝરાયલના વડીલોને બોલાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","તેણે હારુનને કહ્યું, “તું પશુઓના ટોળામાંથી ખામી વગરનો એક બળદ પાપાર્થાર્પણને માટે તથા દહનીયાર્પણને માટે ખામી વગરનો એક ઘેટો લઈને યહોવાહની સમક્ષ તેઓનું અર્પણ કર. ");
INSERT INTO guj2017_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","તું ઇઝરાયલી લોકોને કહે કે, ‘તમે પાપાર્થાર્પણને માટે એક બકરો અને દહનીયાર્પણને માટે એક વાછરડો તથા ઘેટો, બન્ને એક વર્ષના તથા ખામી વગરના લેવા. ");
INSERT INTO guj2017_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","આ ઉપરાંત શાંત્યર્પણોને માટે યહોવાહની સમક્ષ યજ્ઞ કરવા માટે એક બળદ, એક ઘેટો તથા તેલથી મોહેલું ખાદ્યાર્પણ લો, કેમ કે યહોવાહ આજે તમને દર્શન આપશે.’ ");
INSERT INTO guj2017_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","આથી જે વિષે મૂસાએ તેઓને આજ્ઞા કરી હતી તે તેઓ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લાવ્યા અને ઇઝરાયલની સમગ્ર પ્રજા યહોવાહની સમક્ષ આવીને ઊભી રહી. ");
INSERT INTO guj2017_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","પછી મૂસાએ કહ્યું, “યહોવાહે તમને જે કરવાની આજ્ઞા આપી તે આ છે, તમને યહોવાહના ગૌરવનું દર્શન થશે.” ");
INSERT INTO guj2017_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","મૂસાએ હારુનને કહ્યું, “વેદી પાસે જઈને તારું પાપાર્થાર્પણ તથા દહનીયાર્પણ ચઢાવ અને તારે પોતાને માટે તથા લોકોને માટે પ્રાયશ્ચિત કર અને લોકોનું અર્પણ ચઢાવ અને તેઓને માટે પ્રાયશ્ચિત કર. જેમ યહોવાહે આજ્ઞા આપી તેમ.” ");
INSERT INTO guj2017_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","માટે હારુન વેદી પાસે ગયો અને પાપાર્થાર્પણનો જે વાછરડો તેને પોતાને માટે હતો, તે તેણે કાપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","હારુનના પુત્રોએ તેનું રક્ત તેની આગળ પ્રસ્તુત કર્યું અને તેણે પોતાની આંગળી બોળીને થોડું રક્ત વેદીનાં શિંગ ઉપર લગાડ્યું; પછી તેણે બાકીનું રક્ત વેદીના પાયામાં રેડી દીધું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","પણ પાપાર્થાર્પણની ચરબી, મૂત્રપિંડો અને કલેજા પરની ચરબી એનું તેણે વેદી પર દહન કર્યું, જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ. ");
INSERT INTO guj2017_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","અને માંસને બાળીને તેણે તે છાવણી બહાર મૂક્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","હારુને દહનીયાર્પણને કાપ્યું અને તેના પુત્રોએ તેને રક્ત આપ્યું, જે તેણે વેદીની ચારે બાજુએ છાંટ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","પછી તેઓએ તેને એક પછી એક, દહનીયાર્પણના ટુકડા તથા માથું આપ્યા અને તેણે વેદી પર તેમનું દહન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","તેણે આંતરડાં અને પગો ધોઈ નાખ્યાં અને વેદી પરના દહનીયાર્પણ ઉપર તેઓનું દહન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","હારુને લોકોનું અર્પણ રજૂ કર્યું, લોકોના પાપાર્થાર્પણના બકરાંને લઈને પહેલાં બકરાની જેમ તેને કાપીને પાપને લીધે તેનું અર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","તેણે દહનીયાર્પણ રજૂ કર્યું અને યહોવાહની આજ્ઞા પ્રમાણે તેનું અર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","તેણે ખાદ્યાર્પણ રજૂ કર્યું; તેમાંથી એક મુઠ્ઠી લઈ સવારના દહનીયાર્પણ સાથે વેદી પર તેનું દહન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","તેણે લોકોના શાંત્યર્પણ માટે બળદ અને ઘેટાંને કાપીને તેઓનું અર્પણ કર્યું. હારુનના પુત્રોએ તેને રક્ત આપ્યું, જેને તેણે વેદીની ચારે બાજુએ છાંટ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","બળદના ચરબીવાળા ભાગો, ઘેટાંની ચરબીવાળી પૂંછડી, આંતરડા પરની ચરબી, બે મૂત્રપિંડો અને તેના પરની ચરબી તથા કલેજા પરની ચરબીવાળો ભાગ લીધા. ");
INSERT INTO guj2017_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","તેઓએ છાતી પર ચરબી મૂકી અને તે ચરબીનું તેણે વેદી ઉપર દહન કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","મૂસાની આજ્ઞા પ્રમાણે હારુને પશુઓની છાતીના ભાગો અને જમણી જાંઘ ઊંચી કરીને યહોવાહને બલિદાન તરીકે અર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","પછી હારુને પોતાના હાથ ઊંચા કરીને લોકોને આશીર્વાદ આપ્યો; પછી પાપાર્થાર્પણ, દહનીયાર્પણ તથા શાંત્યર્પણના અર્પણ કરીને તે નીચે ઊતર્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","મૂસા અને હારુન મુલાકાતમંડપમાં ગયા, પછી ફરીથી બહાર આવ્યા અને લોકોને આશીર્વાદ આપ્યો અને બધા લોકોને યહોવાહના ગૌરવના દર્શન થયા. ");
INSERT INTO guj2017_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","યહોવાહની સંમુખથી અગ્નિ આવ્યો અને વેદી પરના દહનીયાર્પણને તથા ચરબીવાળા ભાગોને ભસ્મ કર્યાં. જ્યારે સર્વ લોકોએ આ જોયું, ત્યારે તેઓ પોકાર કરવા લાગ્યા અને જમીન પર ઊંધા પડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","હારુનના પુત્રો નાદાબ તથા અબીહૂએ પોતપોતાની ધૂપદાની લઈને તેમાં અગ્નિ મૂક્યો અને તે અગ્નિ પર ધૂપ નાખ્યો. પછી તેઓએ યહોવાહની આગળ અસ્વીકૃત અગ્નિ ચઢાવ્યો, જે વિષે યહોવાહે તેઓને ચઢાવવાની આજ્ઞા કરી નહોતી. ");
INSERT INTO guj2017_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","તેથી યહોવાહની આગળથી અગ્નિ આવ્યો અને તેઓને ભસ્મ કર્યા અને તેઓ યહોવાહ સમક્ષ મૃત્યુ પામ્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","પછી મૂસાએ હારુનને કહ્યું, “આ એ જ વાત છે કે જે વિષે યહોવાહે કહ્યું હતું, ‘હું એવા લોકો પર મારી પવિત્રતાને પ્રગટ કરીશ કે જેઓ મારી પાસે આવે છે. હું સર્વ લોકો આગળ મહિમા પામીશ.’ હારુન કંઈ પણ બોલ્યો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","મૂસાએ હારુનના કાકા ઉઝિયેલના દીકરા મીશાએલને તથા એલ્સાફાનને બોલાવીને તેઓને કહ્યું, “અહીં આવો અને તમારા ભાઈઓને તંબુમાંથી છાવણી બહાર લઈ જાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","આથી તેઓ પાસે આવ્યા અને તેઓને મૂસાની સૂચના પ્રમાણે યાજકના ઝભ્ભા સહિત તેઓને છાવણી બહાર લઈ જવામાં આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","પછી મૂસાએ હારુન તથા તેના પુત્રો એલાઝારને તથા ઈથામારને કહ્યું, “તમારા માથાના વાળ છૂટા ન રાખો અને તમારાં વસ્ત્રો ન ફાડો, જેથી તમે માર્યા ન જાઓ અને જેથી યહોવાહ આખી સભા પર ગુસ્સે ન થાય. પરંતુ બીજા બધા ઇઝરાયલીઓ ભલે યહોવાહે મોકલેલા અગ્નિનો ભોગ બનેલા એ લોકોને માટે વિલાપ કરે ને શોક પાળે. ");
INSERT INTO guj2017_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","તમે મુલાકાતમંડપના પ્રવેશદ્વારની બહાર ન જશો, નહિ તો તમે માર્યા જશો, કેમ કે યહોવાહના તેલથી તમારો અભિષેક કરવામાં આવેલો છે.” તેથી તેઓ મૂસાની સૂચના પ્રમાણે કરવા લાગ્યા. ");
INSERT INTO guj2017_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","યહોવાહે હારુનને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“જ્યારે તું તથા તારી સાથે તારા પુત્રો મુલાકાતમંડપમાં પ્રવેશ કરો ત્યારે દારૂ, દ્રાક્ષારસ કે મદ્યપાન પીઓ નહિ, જેથી તમે મૃત્યુ ન પામો. તમારાં લોકોની વંશપરંપરાને માટે આ નિયમ સદાને માટે રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","તમે પવિત્ર તથા સામાન્ય બાબતની વચ્ચે અને શુદ્ધ તથા અશુદ્ધની વચ્ચે ભેદ રાખો. ");
INSERT INTO guj2017_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","જેથી યહોવાહે જે આજ્ઞાઓ મૂસા મારફતે ફરમાવી છે તે બધા નિયમો ઇઝરાયલી લોકોને શીખવો.” ");
INSERT INTO guj2017_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","મૂસાએ હારુનને તથા તેના બાકી રહેલા દીકરા એલાઝારને તથા ઈથામારને કહ્યું, “યહોવાહને ચઢાવેલા ખાદ્યાર્પણમાંથી બાકી રહેલું અર્પણ લઈને તેની બેખમીર રોટલી બનાવીને વેદી પાસે ખાવી, કારણ કે તે અત્યંત પવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","તે તમારે પવિત્ર જગ્યામાં ખાવી, કેમ કે યહોવાહને અગ્નિથી કરેલા અર્પણોમાંથી તે તારો ભાગ તથા તારા પુત્રોનો ભાગ છે, કેમ કે મને એ પ્રમાણે આજ્ઞા કરવામાં આવી છે. ");
INSERT INTO guj2017_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","યહોવાહની સમક્ષ રજૂ કરવામાં આવેલા અર્પણનાં પશુની છાતીનો ભાગ તથા જાંઘનો ભાગ ઈશ્વરના સ્વીકાર્ય સ્વચ્છ સ્થળે તારે તે ખાવા. તારે અને તારા પુત્રોએ તથા પુત્રીઓએ આ ભાગો ખાવા, કેમ કે ઇઝરાયલી લોકોનાં શાંત્યર્પણના અર્પણોમાંથી તેઓ તારા ભાગ તરીકે તથા તારા પુત્રોના ભાગ તરીકે તમને અપાયેલા છે. ");
INSERT INTO guj2017_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ચરબીનું દહન કરતી વખતે અર્પણનો છાતીનો ભાગ અને જાંઘનો ભાગ પણ યહોવાહને ચઢાવવા લોકોએ સાથે લાવવો. જેમ યહોવાહે આજ્ઞા કરી છે તેમ તે તારો તથા તારા પુત્રોનો સદાનો ભાગ થાય.” ");
INSERT INTO guj2017_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","પછી મૂસાએ પાપાર્થાર્પણના અર્પણના બકરાની માંગ કરી અને ખબર પડી કે તેને બાળી દેવામાં આવ્યો હતો. તેથી તેણે હારુનના બાકીના પુત્રો એલાઝાર તથા ઈથામાર પર ગુસ્સે થઈને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“તમે એ પાપાર્થાર્પણ તંબુમાં શા માટે ન ખાધું? કેમ કે તે અત્યંત પવિત્ર છે અને પ્રજાનું પાપ દૂર કરવા માટે તેમને માટે યહોવાહની સમક્ષ લોકોનું પ્રાયશ્ચિત કરવાને તે તેમણે તમને આપ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","જો તેનું રક્ત તંબુમાં લાવવામાં આવ્યું ન હતું, તેથી જેમ મેં આજ્ઞા કરી હતી તેમ, તમારે તે ચોક્કસપણે તંબુની અંદર ખાવું જોઈતું હતું.” ");
INSERT INTO guj2017_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","પછી હારુને મૂસાને જવાબ આપ્યો, “જુઓ, આજે તેઓએ પોતાના પાપાર્થાર્પણ અને દહનીયાર્પણ યહોવાહ સમક્ષ ચઢાવ્યા છે. જો મેં આજે પાપાર્થાર્પણ ખાધું હોત, તો શું તેથી યહોવાહ પ્રસન્ન થયા હોત?” ");
INSERT INTO guj2017_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","જ્યારે મૂસાએ આ સાંભળ્યું ત્યારે તે સંતોષ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","યહોવાહે મૂસા તથા હારુનને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ઇઝરાયલી લોકોને કહે, ‘પૃથ્વી પરનાં સર્વ પશુઓમાંથી જે પશુઓ તમારે ખાવા માટે ઉપયોગમાં લેવા તે આ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","જે પશુઓની ખરી ફાટવાળી હોય અને જે વાગોળતું હોય તે પશુ તું ખાઈ શકે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","તોપણ, કેટલાક પશુઓની માત્ર ખરી ફાટવાળી હોય અથવા જે માત્ર વાગોળતાં હોય તે પશુઓ તમારે ખાવાં જોઈએ નહિ, જેમ કે ઊંટ, કેમ કે તે વાગોળે છે પણ તેની ખરી ફાટેલી નથી. તેથી ઊંટ તમારે માટે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","સાફાન સસલું પણ: કેમ કે તે વાગોળે છે પણ તેની ખરી ફાટેલી નથી, તે પણ તમારે માટે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","અને સસલું: કેમ કે તે વાગોળે છે, પણ તેની ખરી ફાટેલી નથી, તે તમારે માટે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","અને ડુક્કર: જોકે તેની ખરી ફાટેલી છે, પણ તે વાગોળતું નથી, તેથી તે તમારે માટે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","તમારે તેઓમાંના કોઈનું માંસ ખાવું નહિ કે તેઓના મૃતદેહનો સ્પર્શ કરવો નહિ. તેઓ તમારે માટે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","જળચરોમાંથી તમે આટલાં ખાઈ શકો: પાણીમાં જે બધાંને પંખ તથા ભિંગડાં હોય તેઓને તમારે ખાવા, પછી તે સમુદ્રોમાંનાં હોય કે નદીઓમાંનાં હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","પણ સમુદ્રોમાંનાં કે નદીઓમાંનાં જે બધાં જળચરો પાણીમાં તરે છે તેમાંના તથા સર્વ જળચરોમાંનાં જે સર્વને પંખ તથા ભિંગડાં હોતા નથી, તેઓ તમને નિષેધાત્મક છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","કારણ કે તેઓ ઘૃણાપાત્ર છે માટે, તમારે તેઓનું માંસ ખાવું જોઈએ નહિ; તેમના મૃત દેહ પણ ઘૃણાપાત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","પાણીમાંનાં જેઓને પંખ કે ભિંગડાં નથી હોતા તેઓ તમને નિષેધાત્મક છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","પક્ષીઓમાંથી તમારે આને નિષેધાત્મક ગણવા અને તમારે જે ન ખાવા જોઈએ તે આ છે: ગરુડ, ગીધ, ");
INSERT INTO guj2017_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","સમડી, દરેક પ્રકારના બાજ, ");
INSERT INTO guj2017_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","દરેક પ્રકારના કાગડા, ");
INSERT INTO guj2017_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","શાહમૃગ, ચીબરી, સીગલ અને કોઈ પણ પ્રકારનો શકરો. ");
INSERT INTO guj2017_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ચીબરી, કરઢોક, ઘુવડ, ");
INSERT INTO guj2017_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","રાજહંસ, ઢીંચ, ગીધ, ");
INSERT INTO guj2017_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","બગલો, દરેક પ્રકારના હંસ, લક્કડખોદ તથા વાગોળ એમને પણ તમારે નિષેધાત્મક ગણવા. ");
INSERT INTO guj2017_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","સર્વ પાંખવાળાં જંતુઓ જેઓ પગ વડે ચાલતા હોય, તેઓ તારે માટે અમંગળ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","તોપણ પગે ચાલનાર પાંખવાળાં જંતુઓ, જેઓને પગ ઉપરાંત જમીન ઉપર કૂદવાને પગ હોય છે, તેઓમાંથી આ તમે ખાઈ શકો છો. ");
INSERT INTO guj2017_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","અને તમે કોઈ પણ પ્રકારના તીડ, બોડમથો તીડ, તમરી અથવા તીતીઘોડો ખાઈ શકો. ");
INSERT INTO guj2017_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","પણ સર્વ પાંખવાળાં જંતુઓ જેઓને ચાર પગ હોય તેઓ તમને અમંગળ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","તેઓના શબને પણ જો કોઈ સ્પર્શ કરે તો તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","અને જે કોઈ તેઓના મૃતદેહને ઉપાડી લે તેણે પોતાના વસ્ત્રો ધોઈ નાખવા અને તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","જે પશુઓની ખરી ફાટેલી હોય પણ તેના બરાબર બે સરખા ભાગ થતા ન હોય અથવા જે પશુઓ વાગોળતાં ના હોય, તે તમને અશુદ્ધ છે. જે કોઈ તેમનો સ્પર્શ કરે તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ચાર પગવાળાં જાનવરોમાંનું જે જે પંજા વડે ચાલતું હોય તે તમારે માટે અશુદ્ધ છે. જે કોઈ તેઓના મૃતદેહનો સ્પર્શ કરે તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","અને જે કોઈ તેમના મૃતદેહને ઉપાડે, તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં અને તે સાંજ સુધી અશુદ્ધ ગણાય. આ પશુઓ તમારે માટે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","જમીન પર પેટે ચાલનારા પ્રાણીઓમાંથી આ તમારા માટે અશુદ્ધ છે: નોળિયો, ઉંદર, દરેક પ્રકારની ગરોળી, ");
INSERT INTO guj2017_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ચંદન ઘો, પાટલા ઘો, ગરોળી, સરડો તથા કાચીંડો. ");
INSERT INTO guj2017_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","સર્વ પેટે ચાલનારાં સર્પટિયાંઓમાં આટલાં તમારે માટે અશુદ્ધ છે. જે કોઈ તેઓના મૃતદેહનો સ્પર્શ કરે તો તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","અને જો તેઓમાંથી કોઈ પણ મરી જાય અને કોઈપણ વસ્તુ ઉપર તેમનું શબ પડે તો તે વસ્તુ અશુદ્ધ ગણાય, તે કોઈ પણ લાકડાની, વસ્ત્રોની, ચામડાની અથવા તાટની બનેલી હોય, કોઈપણ કામમાં વપરાતું વાસણ હોય, તો તેને પાણીમાં નાખવું; તે સાંજ સુધી અશુદ્ધ ગણાય. પછી તે શુદ્ધ ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","જો આમાંનું કોઈ પણ સર્પટિયું કોઈપણ માટીનાં વાસણમાં પડે, તો તેમાં જે કંઈ ભરેલું હોય તે અશુદ્ધ ગણાય અને તેને તમારે ભાંગી નાંખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","જે કોઈએ ખાવાનાં પદાર્થ પર એવાં માટલામાંથી પાણી રેડ્યું હોય તો તે અશુદ્ધ ગણાય. અશુદ્ધ થયેલાં વાસણોમાં કોઈ પણ પીણું હોય તો તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","જે કોઈ વસ્તુ પર તેઓનો મૃતદેહ પડે તો તે અશુદ્ધ ગણાય. તે ભઠ્ઠી કે ખાવા બનાવવાનું વાસણ હોય તો તેને ભાંગી નાખવું. તે અશુદ્ધ છે અને તે તમારે માટે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","જો તેઓ પાણીના ટાંકામાં, ઝરણાંમાં કે જ્યાં પીવાના પાણીનો સંગ્રહ થાય છે તેમાં પડે તો તે પાણી શુદ્ધ ગણાય. પણ જો કોઈ પાણીની અંદરના શબનો સ્પર્શ કરે તો તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","જો તેઓના શબનો કોઈ ભાગ કોઈપણ વાવવાના બિયારણ પર પડે તો તે બિયારણ શુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","પણ જો તે બિયારણ પર પાણી છાટેલું હોય અને તેમના શબનો કોઈ ભાગ તેના પર પડે, તો તે તમારે માટે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","જે પશુઓ ખાવાની તમને છૂટ આપવામાં આવી છે એવું પશુ જો મરી જાય, તો તેના મૃતદેહનો જે કોઈ સ્પર્શ કરે તો તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","અને જે કોઈ એ મૃતદેહમાંથી તેનું માંસ ખાય તો તે પોતાના વસ્ત્રોને ધોઈ નાખે અને તે સાંજ સુધી અશુદ્ધ ગણાય. અને જે કોઈ તેના મૃતદેહને ઊંચકે તો તે પોતાના વસ્ત્રો ધોઈ નાખે અને તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","જમીન પર પેટે ચાલતાં તમામ સર્પટિયાં નિષેધાત્મક છે; તે ખાવાં નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","સર્વ પેટે ચાલનારાં અને ચાર પગે ચાલનારાં અથવા વધારે પગોવાળાં, જમીન પર પેટે ચાલનારાં સર્વ પણ તમારે ખાવા નહિ, કારણ કે તે નિષેધાત્મક છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","કોઈ પણ પેટે ચાલનારાં સર્પટિયાંઓથી તમે પોતાને અશુદ્ધ ન કરો; તેઓથી પોતાને અશુદ્ધ કરીને અભડાઓ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","કેમ કે હું યહોવાહ તમારો ઈશ્વર છું. એ માટે તમે પોતાને શુદ્ધ કરો અને તમે પવિત્ર થાઓ કેમ કે હું પવિત્ર છું. જમીન પર પેટે ચાલનારાં કોઈ પણ સર્પટિયાંથી પોતાને અશુદ્ધ ન કરો. ");
INSERT INTO guj2017_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","કેમ કે હું યહોવાહ છું, તમારો ઈશ્વર થવા માટે જે તમને મિસર દેશમાંથી બહાર કાઢી લાવ્યો. માટે તમે પવિત્ર થાઓ, કેમ કે હું પવિત્ર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","આ પશુઓ, પક્ષીઓ, દરેક જીવજંતુઓ જે પાણીમાં તરે છે અને દરેક જે પેટે ચાલે છે, તેઓ સંબંધી આ નિયમ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","એ માટે કે શુદ્ધ તથા અશુદ્ધની વચ્ચે અને ખાવાનાં તથા નહિ ખાવાનાં વચ્ચે ભેદ રખાય.’” ");
INSERT INTO guj2017_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ઇઝરાયલી લોકોને કહે, ‘જો કોઈ સ્ત્રી પુત્રને જન્મ આપે, તો તે સાત દિવસ સુધી અશુદ્ધ ગણાય, જેમ તે દર માસમાં માસિક સમયે અશુદ્ધ ગણાય છે તેમ. ");
INSERT INTO guj2017_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","આઠમાં દિવસે તે પુત્રની સુન્નત કરવી. ");
INSERT INTO guj2017_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","પછી તે માતાનું શુદ્ધિકરણ થતાં સુધી તેત્રીસ દિવસ સુધી તે અશુદ્ધ ગણાય. તેના શુદ્ધિકરણ થવાના દિવસો પૂરા ન થાય ત્યાં સુધી તે કોઈ પવિત્ર વસ્તુનો સ્પર્શ ન કરે, તેમ જ તંબુમાં પણ ન આવે. ");
INSERT INTO guj2017_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","પણ જો તે પુત્રીને જન્મ આપે, તો તે જેમ માસિક દરમિયાન અશુદ્ધ ગણાય છે તેમ તે બે અઠવાડિયાં સુધી અશુદ્ધ ગણાય. તેનું શુદ્ધિકરણ થતાં સુધી છાસઠ દિવસ તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","જ્યારે તેને શુદ્ધ કરવાનો સમય પૂરો થાય ત્યારે પુત્રી અથવા પુત્રની માતાએ દહનીયાર્પણ માટે એક વર્ષનું ઘેટાંનું બચ્ચું અને પાપાર્થાર્પણ માટે કબૂતરનું એક બચ્ચું કે હોલો મુલાકાતમંડપમાં લઈ જવું અને પ્રવેશદ્વારે યાજકની પાસે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","પછી તે તેને માટે યહોવાહ સમક્ષ ચઢાવે અને તેના માટે પ્રાયશ્ચિત કરે અને તે તેના રક્તસ્ત્રાવમાંથી શુદ્ધ થશે. જેને પુત્ર કે પુત્રીનો જન્મ થાય, તે સ્ત્રીને માટે આ નિયમ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","જો તે ઘેટાંના બચ્ચાનું અર્પણ ન કરી શકે, તો તે બે હોલા કે બે કબૂતરનાં બચ્ચાં લાવે, એક દહનીયાર્પણ માટે અને બીજું પાપાર્થાર્પણને માટે અને યાજક તેને માટે પ્રાયશ્ચિતની વિધિ કરે; એટલે તે શુદ્ધ થશે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","યહોવાહે મૂસા તથા હારુનને જણાવ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“જ્યારે કોઈ માણસના શરીર પરની ચામડી પર સોજો આવે અથવા ચાંદું કે ગૂમડું થાય અને એ કુષ્ટરોગમાં પરિણમે એમ લાગતું હોય, તો તેને હારુન યાજકની પાસે અથવા તેના કોઈ યાજક દીકરા પાસે લઈ જવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","પછી યાજક તેના શરીરના ચામડી પરનો રોગ તપાસે. જો તે જગ્યા ઉપરના વાળ સફેદ થઈ ગયા હોય અને તે ભાગ ચામડી કરતાં ઊંડે ઊતરેલો લાગે, તો તે કુષ્ટરોગ છે. યાજક તે માણસને તપાસ્યા પછી, તેને અશુદ્ધ જાહેર કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","જો ચામડી પરનો સફેદ ડાઘ ચામડીની નીચે ઊંડે ઊતરેલો ના લાગતો હોય, વળી તેમાંના વાળ સફેદ થઈ ગયા ના હોય, તો પછી યાજકે તે રોગીને સાત દિવસ સુધી જુદો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","સાતમે દિવસે યાજકે તેને ફરીથી તપાસવો અને જો તે સફેદ ડાઘ જેવો હતો તેવો જ રહ્યો હોય અને ચામડીના બીજા ભાગમાં પ્રસર્યો ના હોય, તો યાજકે તેને બીજા સાત દિવસ સુધી જુદો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","યાજક ફરીથી સાતમાં દિવસે તપાસે અને તે સફેદ ડાઘ ઝાંખો થઈ ગયો હોય અને તે પ્રસર્યો ના હોય, તો યાજકે તેને શુદ્ધ જાહેર કરવો. તે ફક્ત ચાંદું જ છે, એમ માનવું. પછી તે વ્યક્તિ વસ્ત્રો ધોઈ નાખે એટલે તે શુદ્ધ થઈ જાય. ");
INSERT INTO guj2017_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","પરંતુ શુદ્ધ જાહેર કર્યા પછી ફરી તે ડાઘ ફેલાયેલો લાગે તો તે વ્યક્તિએ ફરીથી તપાસ માટે યાજક પાસે આવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","યાજકે તેને ફરીથી તપાસવો અને જો સફેદ ડાઘ કે ચાંદું ફેલાતું જતું લાગે, તો યાજકે તે માણસને એક અશુદ્ધ કુષ્ટરોગી જાહેર કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","જો કોઈ વ્યક્તિને કુષ્ટરોગનું ચાંદું હોય અને રોગ હોવાની શંકા જાય, તો તેને યાજક આગળ લઈ જવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","યાજક તેને તપાસે અને જો ચામડી પર સફેદ ચાંઠું પડ્યું હોય અને વાળ ધોળા થઈ ગયા હોય અને સોજા પરની ચામડી પાકેલી તથા દુખાતું હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","તો એ કુષ્ટરોગની શરૂઆત થઈ ચૂકી છે અને યાજકે તે વ્યક્તિને અશુદ્ધ જાહેર કરવો. તેને જુદો રાખવો નહિ, કારણ કે તે અશુદ્ધ જાહેર થઈ જ ચૂક્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","જો યાજકને ખબર પડે કે કુષ્ટરોગ ફાટી નીકળ્યો છે અને તેના સમગ્ર શરીર પર માથાથી તે પગ સુધી, જ્યાં જ્યાં યાજક તપાસે ત્યાં ત્યાં આખી ત્વચામાં રોગ ફેલાઈ ગયો હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","એટલે યાજકે તેને તપાસવો અને જો સમગ્ર શરીર પર રોગ પ્રસરી ગયેલો ખબર પડે તો તેને યાજકે શુદ્ધ જાહેર કરવો. જો તેનું આખું શરીર સફેદ થઈ ગયું છે, તો તે શુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","પણ જ્યારે તેમાં દુખાતું માંસ દેખાય તો તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","યાજક તે દુખતા માંસને જોઈને તેને અશુદ્ધ ઠરાવે કેમ કે તે દુખાતું માંસ અશુદ્ધ છે. તે તો કુષ્ટરોગ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","પરંતુ જો દુખાતું માંસ બદલાઈને ફરીથી સફેદ થઈ જાય, તો તે યાજક પાસે આવે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","યાજકે ફરીથી તેને તપાસવો અને જો તે ચાંદા સંપૂર્ણ સફેદ થઈ ગયાં હોય, તો તેને શુદ્ધ જાહેર કરવો; તે શુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","જો કોઈ વ્યક્તિના શરીર પર ગૂમડું થઈને રુઝાઈ ગયું હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ગૂમડાંની જગ્યાએ સફેદ ડાઘ કે રતાશ પડતો સફેદ સોજો ખબર પડે, તો તે યાજકને બતાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","યાજક તેને તપાસે અને જુઓ તે ત્વચા કરતાં ઊંડું લાગે અને તે ચાઠા પરના વાળ સફેદ થઈ ગયા છે, તો યાજક તેને અશુદ્ધ જાહેર કરે. તો તેને કુષ્ટરોગનો રોગ સમજવો, તે ગૂમડાંમાં ફાટી નીકળ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","પણ જો તપાસતાં યાજકને એમ ખબર પડે કે એમાંના વાળ સફેદ થયેલા નથી, તે ચામડી કરતાં ઊંડે ઊતરેલું નથી તથા ઝાખું પડી ગયું છે, તો તેણે તે વ્યક્તિને સાત દિવસ સુધી જુદો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","જો રોગ ચામડીમાં ફેલાયો હોય, તો યાજકે તેને અશુદ્ધ જાહેર કરવો. તે કુષ્ટરોગનો રોગ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","પરંતુ જો ચાઠું એવું ને એવું રહે અને પ્રસરે નહિ, તો તે ગૂમડાંનું ચાઠું છે અને યાજકે તે વ્યક્તિને શુદ્ધ જાહેર કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","જો કોઈ વ્યક્તિની ચામડી બળી જાય અને દાઝેલી જગ્યાએ ચમકતું લાલાશ પડતું સફેદ ચાઠું થઈ જાય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","તો યાજકે તે ચાંઠાની તપાસ કરવી જોઈએ, જો ચાઠાનાં વાળ સફેદ થઈ ગયા હોય અને રોગ ચામડીની નીચેના ભાગ સુધી ફેલાઈ ગયો હોય, તો દાઝવાના ઘામાંથી રોગ ફેલાયો છે અને યાજકે તે વ્યક્તિને અશુદ્ધ કુષ્ટરોગી જાહેર કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","પરંતુ જો યાજક તે તપાસી જુએ કે ચાઠાંમાં સફેદ વાળ નથી અને તે ચામડીની નીચે સુધી પ્રસરેલ નથી તથા ચાઠું ઝાખું પડતું જાય છે, તો યાજકે તે વ્યક્તિને સાત દિવસ માટે જુદો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","પછી સાતમે દિવસે યાજક તેને તપાસે. જો ચાઠું ચામડીમાં ફેલાયું હોય, તો યાજકે તેને અશુદ્ધ જાહેર કરવો. તે તો કુષ્ટરોગ રોગ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","જો ચાઠું ચામડી પર ફેલાયું ના હોય અને ઝાંખું થઈ ગયું હોય, તો તે દાઝેલા ઘાનું ચાઠું છે માટે યાજકે તેને શુદ્ધ જાહેર કરવો, કેમ કે તે દાઝ્યાનું ચાઠું છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","જો કોઈ પુરુષ કે સ્ત્રીના માથા પર કે દાઢી પર એ રોગ હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","તો યાજકે તેની તપાસ કરવી અને જો તે ચામડી કરતાં ઊંડું ખબર પડે અને વાળ પીળા તથા આછા થઈ ગયા હોય, તો યાજકે તે વ્યક્તિને અશુદ્ધ જાહેર કરવો. તે ઉંદરી પ્રકારનો માથાનો કે દાઢીનો કુષ્ટરોગ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","જો યાજક ઉંદરીની બીમારીને તપાસે અને જો તે જુએ કે તે ચામડી કરતાં ઊંડું ન હોય તથા ત્યાંના વાળ હજી પણ કાળાં હોય, તો યાજકે તે વ્યક્તિને સાત દિવસ જુદો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","યાજકે સાતમાં દિવસે ફરીથી તેની તપાસ કરવી, જો ચાઠું ફેલાયું ન હોય અને વાળ પણ પીળા થયા ન હોય, તેમ જ તે ચામડી કરતાં ઊંડી માલૂમ ના પડે, ");
INSERT INTO guj2017_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","તો તે માણસે ઉંદરીવાળાં ભાગ સિવાય ચાઠાની આજુબાજુના વાળ કપાવી નાખવા અને યાજકે તેને બીજા સાત દિવસ માટે જુદો રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","યાજકે સાતમાં દિવસે ફરીથી તેને તપાસવો અને જો ઉંદરી ચામડીમાં ફેલાઈ ન હોય તથા ચામડી કરતાં ઊંડી માલૂમ ન પડે, તો યાજકે તે વ્યક્તિને શુદ્ધ જાહેર કરવો. પછી તે વ્યક્તિએ વસ્ત્રો ધોઈ નાખવાં એટલે તે શુદ્ધ થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","પણ તે વ્યક્તિને યાજકે શુદ્ધ જાહેર કર્યા પછી જો ઉંદરી ચામડીમાં ફેલાય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","તો યાજકે તેને ફરીથી તપાસવો અને જો ઉંદરી ચામડીમાં ફેલાઈ હોય, તો યાજકે તેના વાળ પીળા છે કે નહિ એ પણ જોવાની જરૂર નથી. તેને અશુદ્ધ કુષ્ટરોગી જાહેર કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","પણ જો ઉંદરી ત્યાં અને ત્યાં જ રહે અને તેમાં કાળાં વાળ ઊગવા માંડે તો તે કુષ્ટરોગ નથી. તે શુદ્ધ છે અને યાજકે તેને શુદ્ધ જાહેર કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","જો કોઈ પુરુષ કે સ્ત્રીને ચામડીમાં સફેદ રંગના ચાઠાં પડ્યા હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","તો યાજક તેને તપાસે અને જો તે ડાઘ ફિક્કાં સફેદ રંગના હોય અને ઝાંખા પડતા જતા હોય, તો તે કુષ્ટરોગ નથી, એમ સમજવું કે ચામડી પર કરોળિયા થયા છે અને એ માણસ શુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","જો કોઈ વ્યક્તિના માથાના વાળ ખરી પડ્યા હોય અને માથાના પાછળના ભાગમાં તેને ટાલ પડી હોય તો પણ તે શુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","અને જો માથાના આગળના ભાગમાંથી વાળ ખરી ગયા હોય, તો આગળના ભાગમાં માથા પર ટાલ પડે છતાં તે શુદ્ધ છે તેને કુષ્ટરોગ નથી એમ કહેવાય. ");
INSERT INTO guj2017_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","પરંતુ માથા પરની આગળ કે પાછળની ટાલમાં રતાશ પડતા સફેદ ડાઘ હોય, તો કુષ્ટરોગની શરૂઆત થઈ છે એમ મનાય. ");
INSERT INTO guj2017_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","પછી યાજકે તેને તપાસવો અને પાછળની કે કપાળ પરની ટાલમાંનો ડાઘ રતાશ પડતો સફેદ હોય, તો તેને રોગ થયો છે અને તે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","તો તે કુષ્ટરોગી માણસ છે, તે અશુદ્ધ છે. યાજકે તેને માથામાં થયેલા રોગને કારણે અચૂક અશુદ્ધ જાહેર કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","જે વ્યક્તિને કુષ્ટરોગ થયો હોય તેણે પોતાના વસ્ત્રો ફાડવાં, પોતાના વાળ વિખેરાયેલા રહેવા દેવા અને ઉપરના હોઠ સુધીનો ભાગ ઢાંકી દેવો અને બૂમો પાડવી, ‘અશુદ્ધ, અશુદ્ધ.’ ");
INSERT INTO guj2017_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","જેટલા દિવસો સુધી તે વ્યક્તિમાં રોગ રહે તેટલાં દિવસો સુધી તે અશુદ્ધ ગણાય. કેમ કે તે અશુદ્ધ છે, તે એકલો રહે. છાવણીની બહાર તેનું રહેઠાણ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","જો તે વસ્ત્ર કુષ્ટરોગના રોગના ચેપવાળું હોય, પછી તે ઊનના કે શણના વસ્ત્રનું હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","તે શણના કે ઊનના તાણામાં કે વાણામાં અથવા ચામડામાં કે ચામડાની બનાવેલી કોઈ વસ્તુમાં ફુગનો ડાઘ હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","તે વસ્ત્રમાં અથવા ચામડામાં અથવા તાણામાં અથવા વાણામાં અથવા ચામડાની બનાવેલી કોઈપણ વસ્તુમાં તે રોગનો ચેપ લીલાશ કે રતાશવાળો હોય, તો તેને કુષ્ટરોગનો રોગ સમજવો અને તપાસ માટે યાજક પાસે લઈ જવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","યાજક તે રોગ તપાસે અને રોગવાળી વસ્તુને સાત દિવસ બંધ કરી રાખે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","સાતમે દિવસે તેણે ફરીથી તે તપાસવી. જો તે રોગ તે વસ્ત્રમાં, એટલે તાણામાં કે વાણામાં કે ગમે તે કામને માટે ચામડું વપરાયું હોય તે ચામડામાં પ્રસર્યો હોય, તો તે રોગ કોહવાડતો કુષ્ટરોગ સમજવો અને તે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","તે રોગવાળા વસ્ત્રને બાળી નાખે અથવા તે ચેપ તાણાને કે વાણાને, શણના વસ્ત્રને, ઊનના, ચામડાની કોઈપણ વસ્તુને લાગેલો હોય તોપણ, કેમ કે તે કોહવાડતો રોગ છે. તેને સંપૂર્ણપણે આગમાં બાળી નાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","જો યાજક તપાસે અને તે વસ્ત્રમાં, એટલે તાણામાં કે વાણામાં અથવા ચામડાની કોઈ વસ્તુમાં તે રોગ પ્રસર્યો હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","તો યાજકે તે વસ્તુને ધોઈ નાખવા માટે આજ્ઞા કરવી જોઈએ અને તેને બીજા સાત દિવસ જુદી રાખવી. ");
INSERT INTO guj2017_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","પછી તે સમય બાદ યાજકે ફરી જોવું, જો ડાઘનો રંગ ન બદલાય કે તે ના ફેલાય તો પણ તે ફૂગ છે, અને તેથી તે અશુદ્ધ છે. તે વસ્તુને ચેપ લાગેલો હોવાથી તેને બાળી નાખીને નાશ કરવો જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","જો યાજક તપાસે અને ધોયા પછી ડાઘ ઝાંખો થયો છે, તો તેણે તે વસ્તુનો ડાઘવાળો, ભાગ તે વસ્ત્ર હોય કે પછી ચામડાની બનાવેલી વસ્તુ હોય કે બીજી કોઈ વસ્તુ હોય, તેને તાણા કે વાણામાંથી ફાડી નાખવી. ");
INSERT INTO guj2017_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","છતાં જો વસ્ત્રમાં તાણા કે વાણામાં કે ચામડાની વસ્તુમાં ફરીથી ડાઘ દેખાય તો ચેપ નવેસરથી ફેલાય છે એમ માનવું અને જેને ચેપ લાગ્યો હોય તે વસ્તુને અગ્નિમાં બાળી મૂકવી. ");
INSERT INTO guj2017_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","જો વસ્ત્ર, તાણા, વાણા કે ચામડાની કોઈ પણ વસ્તુ ધોવાથી ડાઘ જતો રહે તો તેને બીજી વખત ધોઈ નાખવી, એટલે તે શુદ્ધ થઈ જશે અને ફરી એક વાર તેને ઉપયોગમાં લઈ શકાશે. ");
INSERT INTO guj2017_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ઊનના કે શણનાં વસ્ત્રો પર તાણા કે વાણામાંના કે ચામડાની કોઈ પણ વસ્તુ ઉપર ફૂગનો ડાઘ પડ્યો હોય તો તેને માટે આ નિયમ છે, એને અનુસરીને વસ્તુને શુદ્ધ કે અશુદ્ધ જાહેર કરવી, વળી ક્યારે જાહેર કરવી અને ક્યારે નહિ, તે આ નિયમને આધારે નક્કી કરવું.” ");
INSERT INTO guj2017_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“જે કોઈ કુષ્ટરોગથી મુક્ત થયો હોય તેની શુદ્ધિકરણનો નિયમ આ પ્રમાણે છે. તેને યાજક પાસે લાવવો. ");
INSERT INTO guj2017_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","યાજકે છાવણીની બહાર જઈને તેની તપાસ કરવી કે જો રોગ મટી ગયો હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","તો યાજકે જેની શુદ્ધિ કરવાની છે તે માણસને શુદ્ધ એવાં બે જીવતાં પક્ષીઓ, દેવદારનું થોડું લાકડું, કિરમજી રંગનું કાપડ તથા ઝુફા લાવવાને આજ્ઞા આપવી. ");
INSERT INTO guj2017_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","યાજકે એક પક્ષીને વહેતાં પાણીની ઉપર રાખેલા માટીના વાસણમાં કાપવાની આજ્ઞા કરવી. ");
INSERT INTO guj2017_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","પછી યાજકે જીવતા રહેલા બીજા પક્ષીને, દેવદારનું લાકડું, કિરમજી કાપડ તથા ઝુફો લઈને ઝરાના પાણી ઉપર કાપેલા પક્ષીના રક્તમાં બોળવાં. ");
INSERT INTO guj2017_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","જે કુષ્ટરોગમાંથી માણસની શુદ્ધિ કરવાની હોય તેના પર તેણે સાત વાર રક્ત છાંટી તેને શુદ્ધ કરવો. પછી પેલા જીવતા પક્ષીને યાજકે ખુલ્લાં ખેતરમાં છોડી મૂકવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","જે માણસનું શુદ્ધિકરણ કરવાનું હોય તે પોતાના વસ્ત્રો ધોઈ નાખે, પોતાના સર્વ વાળ મૂંડાવે તથા પાણીમાં સ્નાન કરે અને પછી તે શુદ્ધ થયો ગણાય. પછી તે છાવણીમાં રહેવા માટે પાછો ફરે, પરંતુ સાત દિવસ પર્યંત તેણે પોતાના તંબુની બહાર રહેવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","સાતમે દિવસે તેણે પોતાના માથાના સર્વ વાળ, દાઢીના તથા પોતાના ભમરના તેમ જ શરીર પરના બીજા બધા વાળ મૂંડાવી નાખવા. તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં અને પાણીમાં સ્નાન કરવું, પછી તે રોગથી સંપૂર્ણ રીતે શુદ્ધ થયો એવું જાહેર થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","આઠમે દિવસે તેણે એક વર્ષની ઉંમરના ખામી વગરનાં બે નરઘેટાં, એક વર્ષની ખામી વગરની ઘેટી, ખાદ્યાર્પણને માટે તેલમાં મોહેલો ત્રણ દશાંશ એફાહ મેંદાનો લોટ તથા એક માપ તેલ લેવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","શુદ્ધિની વિધિ કરાવનાર યાજકે જેની શુદ્ધિ કરવાની છે તે વ્યક્તિને તેના અર્પણો સાથે મુલાકાતમંડપના પ્રવેશદ્વારે યહોવાહ સમક્ષ રજૂ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","પછી યાજક નર હલવાનોમાંથી એકને લઈને દોષાર્થાર્પણને માટે તેને તથા પેલા માપ તેલને ચઢાવે અને યહોવાહની સમક્ષ તેઓનું અર્પણ કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","તેણે એ ઘેટાના બચ્ચાંને જે પવિત્ર સ્થળે પાપાર્થાર્પણને તથા દહનીયાર્પણના હલવાનને કાપવામાં આવે છે ત્યાં કાપવો. પાપાર્થાર્પણની માફક દોષાર્થાર્પણ યાજકને આપી દેવું, કેમ કે તે પરમપવિત્ર અર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","પછી યાજકે આ દોષાર્થાર્પણનું રક્ત લઈને જે માણસ શુદ્ધ થયો છે તેના જમણા કાનની બુટ્ટી પર, જમણા હાથના અંગૂઠા પર તથા જમણા પગના અંગૂઠા પર લગાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","પછી યાજકે સાથે લાવેલા તેલમાંથી થોડું પોતાના ડાબા હાથના પંજા પર રેડવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","તેણે જમણા હાથની આંગળી તેમાં બોળવી અને યહોવાહની સમક્ષ સાત વખત તે તેલનો છંટકાવ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","યાજક હથેળીમાં રહેલા તેલમાંથી થોડું લઈને જેની શુદ્ધિ કરવાની હોય તે માણસના જમણા કાનની બુટ્ટી, જમણા હાથ તથા જમણા પગના અંગૂઠા પર જ્યાં પહેલાં દોષાર્થાર્પણનું રક્ત લગાડ્યું હતું ત્યાં લગાડવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","યાજકના હાથમાંનું બાકીનું તેલ તેણે જે વ્યક્તિની શુદ્ધિ કરવી હોય તેના માથા પર લગાડીને યહોવાહ સમક્ષ તેને માટે પ્રાયશ્ચિત કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","પછી યાજકે પાપાર્થાર્પણ ચઢાવવું અને જેની અશુદ્ધતામાંથી શુદ્ધિ કરવાની હોય, તે માણસની પ્રાયશ્ચિત વિધિ કરવી અને ત્યાર પછી તે દહનીયાર્પણના પશુને મારી નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","પછી યાજકે વેદીની અગ્નિ પર દહનીયાર્પણ તથા ખાદ્યાર્પણ બાળવા અને તે વ્યક્તિ માટે પ્રાયશ્ચિત કરવું અને ત્યારે તે વ્યક્તિ શુદ્ધ થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","તેમ છતાં, જો તે માણસ ગરીબ હોય અને આ બધું ચઢાવી શકે એમ ના હોય, તો તેણે માત્ર એક જ ઘેટો દોષાર્થાર્પણ તરીકે લાવવો અને યહોવાહની સમક્ષ રજૂ કરવો. યાજકે તેને તે માણસના પ્રાયશ્ચિત માટે અર્પણ ચઢાવવું અને તે તેને શુદ્ધ કરશે. તેણે ખાદ્યાર્પણ તરીકે ફક્ત તેલથી મોહેલો એક દશાંશ એફોદ મેંદાનો લોટ તથા એક માપ તેલ લેવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","તથા બે હોલા કે કબૂતરનાં બે બચ્ચાં, તે લાવી શકે તેમ હોય તે લાવવાં, તેઓમાંનું એક પાપાર્થાર્પણ માટે અને બીજું દહનીયાર્પણ માટે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","આઠમે દિવસે યાજક પાસે મુલાકાતમંડપના પ્રવેશદ્વાર આગળ તે યહોવાહની સમક્ષ પોતાના શુદ્ધિકરણની વિધિને માટે આ પક્ષીઓને સાથે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","પછી યાજક ઘેટાનાં બચ્ચાંને દોષાર્થાર્પણ તરીકે લે તથા તેલ પણ લે અને વેદી આગળ યહોવાહની સમક્ષ તે તેઓનું અર્પણ કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","તે દોષાર્થાર્પણ માટેના ઘેટાંને કાપી નાખે અને તેનું થોડું રક્ત લઈ જેનું શુદ્ધિકરણ કરવાનું હોય તે વ્યક્તિના જમણા કાનની બુટ્ટી તથા તેના જમણા હાથના અને જમણા પગના અંગૂઠા પર લગાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","પછી યાજકે થોડું તેલ પોતાની ડાબી હથેળીમાં રેડવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","અને જે થોડું રક્ત તેના ડાબા હાથની હથેળીમાં છે તેમાંથી થોડું તેણે પોતાના જમણા હાથની આંગળી વડે લઈને સાત વાર યહોવાહની સમક્ષ છાંટવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","તે પછી દોષાર્થાર્પણનું રક્ત લગાડ્યું હતું તે જ જગ્યાએ યાજકે જેનું શુદ્ધિકરણ કરવાનું હોય તે વ્યક્તિના જમણા કાનની બુટ્ટી પર, જમણા હાથના અંગૂઠા પર તથા જમણા પગના અંગૂઠા પર તેલ લગાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","તેના હાથમાં બાકી રહેલું તેલ જે માણસની શુદ્ધિ કરવાની હોય તેના માથા પર રેડવું અને યહોવાહ સમક્ષ તેણે પ્રાયશ્ચિત કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","અને તે મેળવી શકે એવો એક હોલો કે કબૂતરનું બચ્ચું તેણે ચઢાવવું, ");
INSERT INTO guj2017_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","જેવું તે મેળવી શકે એવું, પાપાર્થાર્પણ તરીકે અને બીજું દહનીયાર્પણ તરીકે ખાદ્યાર્પણની સાથે વેદી પર ચઢાવવું. પછી યાજક યહોવાહની સમક્ષ તે માણસને માટે પ્રાયશ્ચિત કરે અને તે શુદ્ધ બની જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","કુષ્ટ રોગમાંથી સાજા થયેલા જે માણસના શુદ્ધિકરણ માટે જરૂરી અર્પણો લાવવા જો તે અશક્ત હોય, તેને માટે આ નિયમ છે.” ");
INSERT INTO guj2017_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","યહોવાહે મૂસા તથા હારુનને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“મેં તમને આપેલા કનાન દેશમાં જ્યારે તમે આવી પહોંચો અને હું ત્યાં કોઈ ઘરમાં કુષ્ટ રોગ મૂકું, ");
INSERT INTO guj2017_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","તો તે ઘરના માલિકે યાજક પાસે આવીને માહિતી આપવી. તેણે કહેવું, ‘મારા ઘરમાં કુષ્ટરોગ હોય એવું મને લાગે છે.’” ");
INSERT INTO guj2017_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","યાજકે તપાસ કરવા જતાં પહેલાં ઘર ખાલી કરવા આજ્ઞા કરવી, એ માટે કે ઘરની બધી વસ્તુઓ અશુદ્ધ ન થાય. ત્યારપછી યાજક ઘરની તપાસ માટે ઘરની અંદર જાય. ");
INSERT INTO guj2017_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","રોગની તે તપાસ કરે અને જો તે રોગ ઘરની દીવાલોમાં હોવાથી તેમાં કોઈ લીલી કે રાતી તિરાડ પડી હોય અને તે દીવાલની સપાટીથી ઊંડી દેખાતી હોય તો, ");
INSERT INTO guj2017_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","પછી યાજક ઘરમાંથી બહાર નીકળી સાત દિવસ માટે ઘરને બંધ કરી દેવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","પછી સાતમે દિવસે યાજકે પાછા આવીને ફરી તપાસ કરવી, જો તે કાણાઓ ભીંતમાં વધારે પ્રસર્યા હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","તો યાજકે રોગવાળા પથ્થરોને કાઢી નાખવાની તથા તેમને નગર બહાર ગંદકીની જગ્યાએ ફેંકી દેવાની આજ્ઞા તેઓને આપવી. ");
INSERT INTO guj2017_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ઘરની અંદરની ભીંતોને ખોતરી નાખવાની આજ્ઞા તેણે આપવી અને ખોતરી કાઢેલું બધું જ શહેરની બહાર કોઈ અશુદ્ધ જગ્યાએ ઠાલવી આવવા જણાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","જે જગ્યા ખાલી પડી હોય ત્યાં બીજા પથ્થરો લાવીને ગોઠવવા અને ચૂનાનો કોલ પણ નવો જ વાપરવો તથા ઘરનું નવેસરથી ચણતર કરાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","પથ્થરો કાઢી નાખ્યા પછી અને ઘરનું નવેસરથી ચણતર કર્યા પછી જો ફરીથી ફૂગ દેખાય, ");
INSERT INTO guj2017_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","તો યાજકે ફરીથી આવીને ઘરની તપાસ કરવી અને તેને ખબર પડે કે ફૂગ પ્રસરી છે તો તે જલદી પ્રસરે તેવો ચેપ છે અને તે ઘર અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","તે ઘરને તોડી પાડવું. એ ઘરના પથ્થરો, લાકડાં અને ગારો બધું શહેરની બહાર કોઈ અશુદ્ધ જગ્યાએ લઈ જવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","એ ઘર બંધ રહ્યું હોય તે દરમિયાન કોઈ ઘરમાં પ્રવેશે તો તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","જે કોઈ વ્યક્તિ તે ઘરમાં સૂઈ જાય અથવા જમે તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં. ");
INSERT INTO guj2017_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","પરંતુ યાજક ઘરમાં જઈને તપાસે અને જો તેને ખબર પડે કે નવેસરથી ચણતર કર્યા પછી ફૂગ ફેલાયેલી નથી, તો તે ઘરને તે શુદ્ધ જાહેર કરે કે હવે ફૂગનો ચેપ ઘરમાં નથી. ");
INSERT INTO guj2017_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","પછી ઘરની શુદ્ધિ માટે યાજક બે નાનાં પક્ષીઓ, દેવદારનું લાકડું, લાલ રંગના કાપડનો ટુકડો અને ઝુફો લે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","એક પક્ષીને તેણે ઝરાના વહેતા પાણી ઉપર માટલી ઉપર કાપવું. ");
INSERT INTO guj2017_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","તેણે દેવદારનું લાકડું, ઝુફો અને કિરમજી રંગનું કાપડ લઈ જીવતા પક્ષી સાથે ચઢાવેલા પક્ષીના રક્તમાં તથા ઝરાના વહેતાં પાણીમાં બોળવા અને સાત વખત ઘર ઉપર છંટકાવ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","આ પ્રમાણે તેણે પક્ષીનું રક્ત, ઝરાનું પાણી, જીવતું પક્ષી, દેવદારનું લાકડું, ઝુફો અને કિરમજી કાપડ, તેનાથી ઘરની શુદ્ધિ કરવી. ");
INSERT INTO guj2017_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","પણ યાજકે શહેરની બહાર ખુલ્લાં મેદાનમાં બીજા પક્ષીને છોડી દેવું. આ રીતે યાજક ઘરને શુદ્ધ કરશે અને ઘર સાફ થશે. ");
INSERT INTO guj2017_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","બધી જ જાતના કુષ્ટ રોગ, એટલે સોજા, ચાંદાં, ગૂમડાં માટે, ");
INSERT INTO guj2017_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","વસ્ત્રના તથા ઘરના કુષ્ટ રોગને માટે, ");
INSERT INTO guj2017_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","કોઈની ચામડીના સોજામાં કે દાઝવાથી થયેલા ઘામાં કે ચાંદાને માટે, ");
INSERT INTO guj2017_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","કુષ્ટ રોગની બાબતમાં કોઈ અશુદ્ધ ક્યારે કહેવાય અને શુદ્ધ ક્યારે કહેવાય, તે શીખવવા માટે એ નિયમ છે.” ");
INSERT INTO guj2017_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","યહોવાહે મૂસા તથા હારુનને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ઇઝરાયલી લોકોને એમ કહે કે, ‘જ્યારે કોઈ માણસને તેના શરીરમાં સ્રાવનો રોગ હોય, ત્યારે તે માણસ અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","તેના સ્રાવમાં તેની અશુદ્ધતા આ પ્રમાણે ગણાય. તેના સ્રાવ સાથે તેનું માંસ વહેતું હોય અથવા તેના સ્રાવમાંથી તેનું માંસ વહેતું બંધ પડે, તો તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","સ્રાવવાળો માણસ જે પથારીમાં સૂએ અને જે કોઈ વસ્તુ પર તે બેસે તે પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","જે કોઈ વ્યક્તિ તે માણસની પથારીનો સ્પર્શ કરે તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં તથા તેણે પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","જે વસ્તુ પર સ્રાવવાળો બેઠો હોય તે પર જે કોઈ બેસે, તે વ્યક્તિએ પોતાના વસ્ત્રો ધોઈ નાખવાં તથા તેણે સ્નાન કરવું અને તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","અને સ્રાવવાળા પુરુષના શરીરનો જે કોઈ સ્પર્શ કરે તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં તથા તેણે પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","જો સ્રાવવાળો માણસ કોઈ સ્વચ્છ માણસ પર થૂંકે, તો તે માણસે પોતાના વસ્ત્રો ધોઈ નાખવાં તથા તેણે પાણીથી સ્નાન કરવું અને તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","સ્રાવવાળો માણસ જે જીન પર બેસીને સવારી કરે તે પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","જે કંઈ પણ તેની નીચે આવેલું હોય, તેને સ્પર્શ કરનાર વ્યક્તિ સાંજ સુધી અશુદ્ધ ગણાય; જે કોઈ તે વસ્તુને ઉપાડે તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં અને પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","સ્રાવવાળો માણસ પોતાના હાથ ધોયા વિના જો કોઈ વ્યક્તિને સ્પર્શ કરે તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવા, પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","અશુદ્ધ વ્યક્તિ માટીના વાસણને સ્પર્શ કરે તો તે વાસણને ફોડી નાખવું અને લાકડાના પ્રત્યેક વાસણને પાણીમાં ધોઈ નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","જ્યારે તે વ્યક્તિ તેના સ્રાવથી શુદ્ધ થાય ત્યારે તે પોતાના શુદ્ધિકરણ માટે સાત દિવસ ગણે અને પોતાના વસ્ત્રો ધોઈ નાખે; અને ઝરણાનાં પાણીમાં સ્નાન કરે. ત્યાર પછી તે શુદ્ધ ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","તે માણસે આઠમે દિવસે બે હોલા અથવા કબૂતરનાં બે બચ્ચાં લાવીને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યહોવાહ સમક્ષ આવીને યાજકને આપવા. ");
INSERT INTO guj2017_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","યાજક તેઓમાંના એકને પાપાર્થાર્પણને માટે અને બીજાને દહનીયાર્પણને માટે અર્પણ કરીને સ્રાવવાળા માણસની શુદ્ધિ માટે યહોવાહ સમક્ષ પ્રાયશ્ચિત કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","જો કોઈ પુરુષને વીર્યસ્રાવ થાય, તો તેણે પાણીથી સ્નાન કરવું; સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","જે પ્રત્યેક વસ્ત્ર કે ચામડા પર વીર્ય પડ્યું હોય તેને પાણીથી ધોઈ નાખવું. સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","અને જો કોઈ સ્ત્રીપુરુષનો સંયોગ થયો હોય અને પુરુષને વીર્યસ્રાવ થયો હોય તો તે બન્નેએ પાણીથી સ્નાન કરવું; તેઓ સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","જો કે સ્ત્રીને માસિકસ્રાવ થયો હોય તો તે સાત દિવસ સુધી અશુદ્ધ ગણાય અને તે દિવસો દરમ્યાન જે કોઈ તેને સ્પર્શ કરે તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","તે અશુદ્ધ હોય ત્યારે તે જેના પર સૂતી હોય કે બેઠી હોય તે પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","જે કોઈ માણસ તેની પથારીને સ્પર્શ કરે તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં અને પાણીથી સ્નાન કરવું; તે માણસ સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","તે સ્ત્રી જેના પર બેઠી હોય તેને જો કોઈ સ્પર્શ કરે તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં, પાણીથી સ્નાન કરવું; તે વ્યક્તિ સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","તે સ્ત્રી જેના પર બેઠી હોય તે આસન અથવા પથારી પરની કોઈ વસ્તુને જો કોઈ સ્પર્શે તો તે પોતાના વસ્ત્રો ધોઈ નાખે અને સ્નાન કરે. તે માણસ સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","અને જો કોઈ પુરુષ તેની સાથે શારીરિક સંબંધ કરે અને જો તેની અશુદ્ધતા તેને લાગે તો તે સાત દિવસ સુધી અશુદ્ધ ગણાય. તે જે પથારીમાં સૂએ તે પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","જો કોઈ સ્ત્રીને ઋતુકાળ સિવાય ઘણા દિવસો સુધી રક્તસ્રાવ થાય અથવા તેના ઋતુકાળ ઉપરાંત લાંબા સમય સુધી તેનો સ્રાવ ચાલુ રહે, તો તેના સ્રાવના સર્વ દિવસો સુધી તે ઋતુકાળની જેમ અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","એ સમય દરમિયાન પણ તે જે પથારીમાં સૂએ તે તેના ઋતુકાળના સામાન્ય દિવસોની જેમ અશુદ્ધ ગણાય. અને તે જયાં બેસે તે જગ્યા પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","જે કોઈ તે પથારી કે આસનને સ્પર્શ કરે તે અશુદ્ધ ગણાય. તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં, પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","પણ જો તે પોતાના સ્રાવથી શુદ્ધ થાય તો પછી તે પોતાને માટે સાત દિવસ ગણે અને ત્યારબાદ તે શુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","આઠમે દિવસે તેણે બે હોલાં અથવા કબૂતરનાં બે બચ્ચાં લાવીને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યાજકને આપવાં. ");
INSERT INTO guj2017_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","યાજક તેઓમાંના એકને પાપાર્થાર્પણ માટે અને બીજાને દહનીયાર્પણ માટે અર્પિત કરે અને યાજક તેના સ્રાવની અશુદ્ધતા માટે યહોવાહની સમક્ષ પ્રાયશ્ચિત કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","આ રીતે ઇઝરાયલના લોકોને તેઓની અશુદ્ધતાથી અલગ કરવા કે જેથી મારો જે મંડપ તેઓની મધ્યે છે, તેને અશુદ્ધ કર્યાથી તેઓ માર્યા જાય નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","જે કોઈ પુરુષને સ્રાવ હોય તો તે અશુદ્ધ છે. સ્રાવ અથવા વીર્યપાત તે પુરુષને અશુદ્ધ કરે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ઋતુસ્રાવમાં સ્ત્રી અશુદ્ધ હોય છે તેવી સ્ત્રી સાથે શારીરિક સંબંધ કરનાર પુરુષ પણ અશુદ્ધ છે. શરીરના સ્રાવવાળા લોકો માટેના નિયમો ઉપર પ્રમાણે છે.’” ");
INSERT INTO guj2017_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","હારુનના બે દીકરા જ્યારે યહોવાહની સમક્ષ ગયા ત્યારે મૃત્યુ પામ્યા અને તેઓના મૃત્યુ પછી યહોવાહે મૂસાની સાથે વાત કરી. ");
INSERT INTO guj2017_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","પછી યહોવાહે મૂસાને કહ્યું, “તારા ભાઈ હારુનને કહે, પરમપવિત્ર સ્થાનમાં એટલે કે તંબુના પડદાની અંદરની બાજુએ પવિત્ર કોશ પરના દયાસન સમક્ષ કોઈ પણ સમયે આવે નહિ. જો તે તેમ કરશે તો તે મૃત્યુ પામશે. કારણ કે તે દયાસન પર વાદળરૂપે હું દેખાઈશ. ");
INSERT INTO guj2017_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","તેથી અહીં હારુન આ રીતે પરમપવિત્ર સ્થાનમાં પ્રવેશ કરે. પાપાર્થાર્પણ માટે એક બળદ તથા દહનીયાર્પણ માટે એક ઘેટો લઈને તે પરમપવિત્ર સ્થાનમાં પ્રવેશ કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","તે શણનું પવિત્ર ઉપવસ્ત્ર અને શણની ઈજાર પહેરે. કમરે શણનો કમરપટો અને માથે શણની પાઘડી બાંધે. આ પવિત્ર વસ્ત્રો છે. એ પહેરતાં પહેલાં તેણે પાણીથી સ્નાન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","તે ઇઝરાયલી પ્રજા પાસેથી પાપાર્થાર્પણ માટે બે બકરા તથા દહનીયાર્પણ માટે એક ઘેટો લે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","પછી હારુન પોતાને માટે પાપાર્થાર્પણના બળદને રજૂ કરે અને પોતાના માટે તેમ જ પોતાના પરિવાર માટે પ્રાયશ્ચિત કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ત્યારપછી તે બે બકરાઓ લઈને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યહોવાહ સમક્ષ લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","પછી હારુન તે બે બકરા માટે ચિઠ્ઠીઓ નાખે, એટલે એક ચિઠ્ઠી યહોવાહને માટે અને બીજી અઝાઝેલને માટે નક્કી કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","જે બકરા પર યહોવાહના નામની ચિઠ્ઠી પડે, તેને હારુન પાપાર્થાર્પણને માટે અર્પણ કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","પરંતુ જે બકરા પર અઝાઝેલના નામની ચિઠ્ઠી પડે તેને અઝાઝેલને માટે અરણ્યમાં મોકલી દેવા માટે તેને માટે પ્રાયશ્ચિત કરવાને યહોવાહ સમક્ષ તેને જીવતો રજૂ કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","પછી હારુન પોતાના અને પોતાના પરિવાર માટે પાપાર્થાર્પણને સારુ બળદ રજૂ કરે. પોતાને માટે તથા પોતાના પરિવાર માટે પ્રાયશ્ચિત કરે અને પાપાર્થાર્પણનો જે બળદ પોતાના માટે હોય તેને કાપે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","પછી હારુન એક ધૂપદાનીમાં યહોવાહ આગળની વેદીમાંથી સળગતા અંગારા અને બે મુઠ્ઠી બારીક દળેલો ધૂપ લઈને તેને પડદાની અંદરની બાજુએ લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","પછી યહોવાહ સમક્ષ અંગારા ઉપર તે ધૂપ તે નાખે જેથી કરારકોશ પરના દયાસન ઉપરનું વાદળ ધુમાડાથી ઢંકાઈ જાય. અને આમ કરવાથી તે મૃત્યુ પામશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ત્યારપછી તે બળદના રક્તમાંથી થોડું રક્ત પૂર્વ તરફ પોતાની આંગળી વડે દયાસન પર છાંટે. અને તેમાંનુ થોડું રક્ત દયાસનની સામે આંગળી વડે સાત વાર છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ત્યારપછી તે લોકોના પાપાર્થાર્પણનો બકરો કાપે અને તેનું રક્ત પડદાની અંદરની બાજુ લાવે. બળદના રક્તની જેમ તે તેના રક્તનું પણ કરે; તે દયાસન પર તેને છાંટે ત્યારપછી દયાસનની સામે તેને છાંટે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","તે ઇઝરાયલના લોકોની અશુદ્ધતાના લીધે, તેઓના પાપો અને વિદ્રોહના કારણે પવિત્રસ્થાનને માટે પ્રાયશ્ચિત કરે. એ જ રીતે તેઓની અશુદ્ધતા મધ્યે તેઓની સાથે રહેનાર મુલાકાતમંડપને સારુ કરે, જેમાં યહોવાહ વસે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","હારુન પ્રાયશ્ચિત કરવા માટે પરમપવિત્ર સ્થાનમાં દાખલ થાય ત્યારથી તે પોતાને સારુ, પોતાના પરિવારને સારુ તથા સર્વ ઇઝરાયલીઓને સારું પ્રાયશ્ચિત કરીને બહાર ન આવે, ત્યાં સુધી કોઈને મુલાકાતમંડપમાં રહેવા ન દેવો. ");
INSERT INTO guj2017_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","બહાર આવીને યહોવાહની સમક્ષ વેદી પાસે જઈને તેને સારુ તે પ્રાયશ્ચિત કરે. તેણે બળદના અને બકરાના રક્તમાંથી થોડું થોડું લઈને વેદીનાં શિંગો પર ચોપડવું. ");
INSERT INTO guj2017_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","એ રક્તમાંથી આંગળી વડે તે વેદી ઉપર સાત વખત છાંટીને તેને શુદ્ધ કરે અને ઇઝરાયલીઓની અશુદ્ધતામાંથી તેને પવિત્ર કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","પરમ પવિત્રસ્થાન, મુલાકાતમંડપ અને વેદીને માટે પ્રાયશ્ચિત કરી રહે ત્યારે જીવિત બકરાંને તે હાજર કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","અને પછી હારુન તે જીવતા બકરાના માથા પર બન્ને હાથ મૂકીને ઇઝરાયલીઓની સર્વ દુષ્ટતા, સર્વ પાપો અને તેઓનો વિદ્રોહ કબૂલ કરીને તે સર્વ એ બકરાના શિર પર મૂકે. તે પછી તેણે આ કામ માટે નક્કી કરેલા માણસ સાથે તે બકરાંને રણમાં મોકલી આપવો. ");
INSERT INTO guj2017_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","પછી તે બકરો લોકોની સર્વ દુષ્ટતા જે જગ્યાએ કોઈ રહેતું ના હોય તેવી નિર્જન જગ્યાએ લઈ જશે. અને આ માણસ તેને નિર્જન અરણ્યમાં છોડી દેશે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ત્યારપછી હારુન મુલાકાતમંડપમાં પાછો આવે. પવિત્રસ્થાનમાં દાખલ થતી વખતે પહેરેલા શણનાં વસ્ત્રો ઉતારીને ત્યાં રાખી મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","પવિત્રસ્થાનમાં સ્નાન કરીને તે પોતાના વસ્ત્રો પહેરે અને બહાર જઈને પોતાનું અને લોકોનું દહનીયાર્પણ અર્પણ કરે અને આ રીતે પોતાને સારુ અને લોકોને સારુ પ્રાયશ્ચિત કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","પાપાર્થાર્પણની ચરબીનું દહન તે વેદી પર કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","અઝાઝેલ માટેના બકરાંને લઈ જનાર માણસે પોતાના વસ્ત્ર ધોઈ નાખવા અને સ્નાન કરવું; ત્યારપછી જ તે છાવણીમાં પાછો આવે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","પછી પાપાર્થાર્પણને સારુ ચઢાવેલા બળદ અને બકરાંને એટલે જેઓનું રક્ત પ્રાયશ્ચિતને માટે પવિત્રસ્થાનમાં લઈ જવામાં આવ્યું હતું તેઓને છાવણી બહાર લઈ જવા અને ચામડાં, માંસ અને આંતરડાં સહિત બાળી નાખવા. ");
INSERT INTO guj2017_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","આ બધું બાળનાર માણસે પોતાના વસ્ત્રો ધોઈ નાખવાં, સ્નાન કરવું અને પછી છાવણીમાં પાછા ફરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","એ સદાને માટે તમારો વિધિ થાય; દેશનાં વતનીઓ તથા તમારી મધ્યે વસતા વિદેશીઓએ સાતમા મહિનાના દશમા દિવસે ઉપવાસ કરવો અને કોઈ કામ કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","કેમ કે તે દિવસે તમને શુદ્ધ કરવા માટે તમારા માટે પ્રાયશ્ચિત કરવામાં આવશે; તમે તમારા પાપોથી યહોવાહની આગળ શુદ્ધ થશો. ");
INSERT INTO guj2017_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","તમારા માટે તે પવિત્ર વિશ્રામવારનો દિવસ છે. તમારે ઉપવાસ કરવો અને કંઈ કામ કરવું નહિ. આ સદાને માટેનો નિયમ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","આ પ્રાયશ્ચિત મુખ્ય યાજકે એટલે જે તેના પિતાના સ્થાને યાજકપદને સારુ અભિષિક્ત અને પવિત્ર કરવામાં આવ્યો હોય તેણે કરવું. તે પ્રાયશ્ચિત કરે, તે યાજકે શણના પવિત્ર વસ્ત્ર પહેરવા. ");
INSERT INTO guj2017_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","અને પરમ પવિત્રસ્થાનને માટે, મુલાકાતમંડપને માટે, વેદીને માટે, યાજકોને માટે તથા સભાના સમગ્ર લોકોને માટે તેણે પ્રાયશ્ચિત કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","આ તમારે સારુ સદાનો વિધિ થાય; આ રીતે પ્રતિવર્ષ એક વાર ઇઝરાયલીઓના પાપો માટે પ્રાયશ્ચિત કરવું. યહોવાહે મૂસાને આપેલી સર્વ આજ્ઞા પ્રમાણે તેણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“તું હારુનને, તેના પુત્રોને તેમ જ બધા ઇઝરાયલીઓને આ પ્રમાણે કહે, યહોવાહે જે આજ્ઞા આપી છે તે તેઓને કહે, ");
INSERT INTO guj2017_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","‘જો કોઈ ઇઝરાયલી છાવણીમાં અથવા છાવણીની બહાર બળદ, હલવાન કે બકરાંને કાપે, ");
INSERT INTO guj2017_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","પરંતુ યહોવાહના મંડપની સામે યહોવાહને સારુ અર્પણ ચઢાવવા માટે મુલાકાતમંડપના દ્વારની પાસે તેને ન લાવે, તે પુરુષને માથે રક્તનો દોષ બેસે; તેણે તો રક્ત વહેવડાવ્યું છે; તે પુરુષ પોતાના લોકો મધ્યેથી અલગ કરાય. ");
INSERT INTO guj2017_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","આ આજ્ઞા એ ઉદ્દેશથી આપવામાં આવી છે કે જેથી ઇઝરાયલી લોકો એક ખુલ્લાં મેદાનમાં બલિદાન કરવાના બદલે તે યહોવાહને માટે મુલાકાતમંડપના દ્વાર આગળ યાજક પાસે લાવે અને તે વડે તેઓ યહોવાહને માટે શાંત્યર્પણો કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","યાજકે અર્પણનું રક્ત મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યહોવાહની વેદી પર છાંટવું. તેણે ચરબીનું દહન કરવું કેમ કે તે યહોવાહને માટે સુવાસ ઉત્પન્ન કરે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","લોકો બકરાનો મૂર્તિઓને તેઓના અર્પણ ચઢાવવાની ઇચ્છા રાખે નહિ, કેમ કે આ રીતે તેઓ ગણિકાઓ માફક વર્ત્યા છે. ઇઝરાયલીઓ અને તેઓના વંશજો માટે આ હંમેશનો વિધિ થાય.’” ");
INSERT INTO guj2017_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","તારે તેઓને કહેવું કે, જો કોઈ ઇઝરાયલી અથવા તેઓની વચ્ચે રહેતો પરદેશી દહનીયાર્પણ કે યજ્ઞ ચઢાવે, ");
INSERT INTO guj2017_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","અને યહોવાહ સમક્ષ તેનો યજ્ઞ કરવાને તેને મુલાકાતમંડપના દ્વાર પાસે ના લાવે તો તે માણસ તેના લોકો મધ્યેથી અલગ કરાય. ");
INSERT INTO guj2017_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","અને કોઈ ઇઝરાયલી અથવા ઇઝરાયલીઓ વચ્ચે વસતો કોઈપણ પરદેશી માણસ જો રક્ત ખાય તો હું તે માણસની વિમુખ થઈશ અને હું તેને તેના લોકોથી અલગ કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","કારણ કે શરીરનો જીવ રક્તમાં છે. અને વેદી પર તે રક્ત તમારા માટે પ્રાયશ્ચિત કરે તે માટે મેં તમને આપ્યું છે. કેમ કે રક્તથી જ પ્રાયશ્ચિત થાય છે, કારણ કે તેમાં જીવ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","તે માટે મેં ઇઝરાયલના લોકોને કહ્યું કે, તમારામાંનો કોઈપણ માણસ તેમ જ તમારી મધ્યે વસતો કોઈપણ પરદેશી રક્ત ના ખાય. ");
INSERT INTO guj2017_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","અને કોઈપણ ઇઝરાયલી કે તેઓની વચ્ચે વસતો પરદેશી ખાદ્ય પક્ષીનો કે પશુનો શિકાર કરે ત્યારે તેણે તેનું બધું રક્ત વહી જવા દેવું અને તેના પર માટી ઢાંકી દેવી. ");
INSERT INTO guj2017_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","કેમ કે સર્વ દેહધારીઓના જીવ વિષે એવું જાણવું કે રક્તમાં તેઓનો જીવ છે, તેથી જ મેં ઇઝરાયલના લોકોને કહ્યું છે કે, “તમારે કોઈપણ દેહધારીનું રક્ત પીવું નહિ, કેમ કે સર્વ દેહધારીઓનો જીવ તેઓના રક્તમાં છે. જે કોઈ તે ખાય તે અલગ કરાય.” ");
INSERT INTO guj2017_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","દરેક વ્યક્તિ દેશનાં વતનીઓ કે પરદેશી કુદરતી રીતે મૃત્યુ પામેલુ અથવા જંગલી પશુઓએ ફાડી નાખેલું પશુ ખાય તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવા, પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ત્યારપછી તે શુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","પરંતુ જો તે પોતાના વસ્ત્રો ન ધુએ કે સ્નાન ન કરે, તો પછી તેનો દોષ તેને માથે.’” ");
INSERT INTO guj2017_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ઇઝરાયલના લોકોને કહે કે, ‘હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","મિસર દેશ જેમાં તમે અગાઉ રહેતા હતા, તે લોકોનું અનુકરણ તમે ન કરો. અને કનાન દેશ કે જેમાં હું તમને લઈ જાઉં છું, તે દેશના લોકોનું અનુકરણ તમે ન કરો. તેઓના રીતરિવાજો ન પાળો. ");
INSERT INTO guj2017_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","તમારે ફક્ત મારા જ વિધિઓ પાળવા, તમારે તેનો સંપૂર્ણ રીતે અમલ કરવો અને તે અનુસાર ચાલવું કેમ કે હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","માટે તમારે મારા વિધિઓ અને નિયમો પાળવા. જો કોઈ માણસ તેનું પાલન કરશે તો તે વડે તે જીવશે. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","તમારામાંના કોઈએ પણ નજીકની સગી સાથે શારીરિક સંબંધ ન બાંધવો. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","તારી માતા સાથે શારીરિક સંબંધ કરીને તારા પિતાનું અપમાન ન કર. તે તારી માતા છે, તેને તારે કલંકિત કરવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","તારા પિતાની પત્નીઓમાંથી કોઈની સાથે શારીરિક સંબંધ ન કર; તે તારા પિતાના અપમાન જેવું છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","તારી બહેનોમાંની કોઈની સાથે શારીરિક સંબંધ ન કર. તે તમારા પિતાની પુત્રી હોય કે માતાની પુત્રી હોય; પછી તે ઘરમાં જન્મેલી હોય કે તારાથી દૂર બહાર જન્મેલી હોય. તારે તારી બહેન સાથે શારીરિક સંબંધ બાંધવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","તારે તારા પુત્રની પુત્રી કે પુત્રીની પુત્રી સાથે શારીરિક સંબંધ ન બાંધવો, તે તમારી પોતાની જાતને કલંકિત કરવા બરાબર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","તારે તારા પિતાની પત્નીની પુત્રી સાથે શારીરિક સંબંધ ન બાંધવો. તે તારી બહેન છે અને તારે તેની સાથે શારીરિક સંબંધ ન બાંધવો. ");
INSERT INTO guj2017_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","તારે તારા પિતાની બહેન સાથે શારીરિક સંબંધ ન બાંધવો, કેમ કે તારા પિતાની તે નજીકની સગી છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","તારે તારી માતાની બહેન સાથે શારીરિક સંબંધ ન બાંધવો, કેમ કે તારી માતાની તે નજીકની સગી છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","તારે તારા પિતાના ભાઈની પત્ની સાથે શારીરિક સંબંધ ન બાંધવો. કે એવા ઇરાદા સાથે તેની નજીક ન જવું. કેમ કે તે તારી કાકી છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","તારે તારી પુત્રવધૂ સાથે શારીરિક સંબંધ ન બાંધવો, તે તારા પુત્રની પત્ની છે. તેની સાથે શારીરિક સંબંધ ન બાંધ. ");
INSERT INTO guj2017_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","તારે તારા ભાઈની પત્ની સાથે શારીરિક સંબંધ ન બાંધવો, આવું કરીને તારા ભાઈનું અપમાન ન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","કોઈ સ્ત્રી તેમ જ તેની પુત્રી કે પૌત્રી કે દોહિત્રી સાથે શારીરિક સંબંધ ન કર. તેઓ નજીકની સગી છે અને તેઓની સાથે એવું કરવું એ અતિશય દુષ્ટ કર્મ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","તારી પત્નીના જીવતા સુધી તેની બહેન સાથે લગ્ન કરીને અને તેને બીજી પત્ની કરીને તેની સાથે શારીરિક સંબંધ ન બાંધ. ");
INSERT INTO guj2017_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","સ્ત્રીના માસિકસ્રાવ દરમિયાન તેની સાથે શારીરિક સંબંધ ન બાંધ. કેમ કે એ સમયમાં તે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","તારે તારા પડોશીની પત્ની સાથે શારીરિક સંબંધ ન કરવો અને આ રીતે પોતાને જાતને ભ્રષ્ટ ન કરવી. ");
INSERT INTO guj2017_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","તારે તારા કોઈ બાળકને અગ્નિમાં ચલાવીને મોલેખને ચઢાવવા ન આપ. આ રીતે તારા ઈશ્વરનો અનાદર ન કરવો. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","સ્ત્રીની જેમ બીજા પુરુષની સાથે શારીરિક સંબંધ ન બાંધ. એ દુષ્ટતા છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","તમારે કોઈ પશુ સાથે સ્ત્રીની જેમ શારીરિક સંબંધ ન કરીને પોતાને અશુદ્ધ ન કરવો. કોઈ સ્ત્રીએ કોઈ પશુ સાથે શારીરિક સંબંધ ન કરવો, એ વિકૃતિ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","આમાંની કોઈ પણ રીતે તારે તારી જાતને અશુદ્ધ ન કરવી. હું જે દેશજાતિઓને તમારી સામેથી હાંકી કાઢવાનો છું તેઓ આવી રીતે અશુદ્ધ થયેલ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","એ આખો દેશ અશુદ્ધ થયો છે. તેથી હું તેઓના પર તેઓના પાપની સજા કરું છું અને એ દેશ ત્યાંના રહેવાસીઓને ઓકી કાઢે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","તમારે મારા વિધિઓ અને આજ્ઞાઓનું પાલન કરવું. તમારે આ બધામાંનું કોઈ ઘૃણાજનક કાર્ય કરવું નહિ, પછી ભલે તમે ઇઝરાયલ પ્રજાનાં વતની હોય કે પરદેશથી આવીને વસ્યા હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","કેમ કે તમારા પહેલા જે દેશજાતિ આ દેશમાં રહેતી હતી, તે આ બધા ઘૃણાજનક કાર્યો કરતી હતી અને તેથી દેશ અશુદ્ધ થયો છે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","એ માટે સાવચેત રહો, કે જેથી દેશને અશુદ્ધ કર્યાથી જેમ તમારી અગાઉની દેશજાતિને તેણે ઓકી કાઢી તેમ તમને પણ તે ઓકી કાઢે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","જે કોઈ એમાંનું કોઈપણ ઘૃણાજનક કાર્ય કરશે તેને પોતાના લોકોમાંથી અલગ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","માટે તમે મારી આજ્ઞાઓનું પાલન કરો. તમારા અગાઉના લોકો ઘૃણાપાત્ર રિવાજો પાળતા હતા, તેનું પાલન કરીને તમારી જાતને અશુદ્ધ ન બનાવશો. હું તમારો ઈશ્વર યહોવાહ છું.’” ");
INSERT INTO guj2017_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ઇઝરાયલના સર્વ લોકોને કહે કે, ‘તમે પવિત્ર થાઓ, કેમ કે હું યહોવાહ તમારો ઈશ્વર પવિત્ર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","તમારામાંના પ્રત્યેક વ્યક્તિએ પોતાના માતાપિતાને માન આપવું અને મારા વિશ્રામવારોનું પાલન કરવું. હું તમારો ઈશ્વર યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","મૂર્તિઓ તરફ ન ફરો અને તમારા માટે ધાતુની મૂર્તિઓ બનાવશો નહિ. હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","તમે જ્યારે યહોવાહની આગળ શાંત્યર્પણો ચઢાવો ત્યારે એવી રીતે ચઢાવો કે તમે તેમની આગળ માન્ય થાઓ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","જે દિવસે તમે તે અર્પણ કરો તે જ દિવસે તથા તેના બીજે દિવસે તે ખાવું. પરંતુ જો ત્રીજા દિવસ સુધી એમાંનું કંઈ બાકી રહ્યું હોય તો તેને અગ્નિમાં બાળી નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","જો તે ત્રીજે દિવસે સહેજ પણ ખાવામાં આવે તો તે અપવિત્ર છે. અને તે માન્ય થશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","પણ જે કોઈ તે ખાય તેનો દોષ તેના માથે રહે. કેમ કે તેણે યહોવાહનું પવિત્ર અર્પણ અપવિત્ર કર્યુ છે. તેથી તે માણસ પોતાના લોકોમાંથી અલગ કરાય. ");
INSERT INTO guj2017_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","જ્યારે તમે તમારા ખેતરમાંની ફસલની કાપણી કરો ત્યારે સમગ્ર ખેતર પૂરેપૂરું લણવું નહિ અને કાપણીનો પડી રહેલો ભાગ વીણી લેવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","એ જ પ્રમાણે દ્રાક્ષવાડીના દ્રાક્ષોને પૂરેપૂરા વીણવા નહિ, તેમ જ નીચે પડેલી દ્રાક્ષ પણ વીણવી નહિ. ગરીબો તેમ જ મુસાફરોને માટે તે રહેવા દેવી. હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","ચોરી કરવી નહિ. જુઠ્ઠું બોલવું નહિ. એકબીજાને છેતરવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","મારે નામે જૂઠ્ઠા સોગન ખાવા નહિ અને તારા ઈશ્વરના નામનો અનાદર કરવો નહિ. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","તારા પડોશી પર જુલમ કરવો નહિ અને તેને લૂંટવો નહિ, મજૂરીએ રાખેલા માણસનું મહેનતાણું આખી રાત એટલે સવાર થતાં સુધી તારી પાસે રાખવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","બધિર માણસને શાપ ન આપ અને અંધજનના માર્ગમાં ઠોકર ન મૂક. પણ તેને બદલે મારું ભય રાખજો. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","ન્યાયધીશોએ પોતાના ન્યાયમાં સદા પ્રામાણિક રહેવું, ગરીબો પ્રત્યે દયા દર્શાવીને એનો પક્ષ ન લેવો કે કોઈ માણસ મહત્વનો છે એવું વિચારીને એનો પક્ષ ન લેવો. પણ તેના બદલે હંમેશા ઉચિત ન્યાય કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","તમારા લોકો મધ્યે તમારે કોઈએ કૂથલી કે ચાડી કરવી નહિ, પણ તમારા પડોશીના જીવનની સલામતી શોધવી. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","તમારે તમારા હૃદયમાં તમારા ભાઈનો દ્વેષ ન કરવો. તમારા પડોશીને પ્રામાણિકપણે ઠપકો આપ અને તેને કારણે પાપને ચલાવી ન લો. ");
INSERT INTO guj2017_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","કોઈના પર વૈર વાળીને બદલો લેવાની ભાવના રાખવી નહિ, પરંતુ જેમ તમે પોતાના પર પ્રેમ રાખો છો તેમ પડોશીઓ પર પણ પ્રેમ રાખવો. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","મારા નિયમો પાળજો. તમારા પશુઓને જુદી જાતના પશુ સાથે ગર્ભાધાન કરાવશો નહિ. તમારા ખેતરમાં એક સાથે બે જાતના બી વાવશો નહિ. તેમ જ જુદી જુદી બે જાતના તારનુ વણેલુ કાપડ પણ પહેરશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","અને કોઈ સ્ત્રી દાસી હોય અને કોઈ પુરુષની સાથે તેનું લગ્ન થયું હોય અને કોઈએ તેને સ્વતંત્ર કરી જ ના હોય અથવા તો સ્વતંત્ર થઈ જ ના હોય તેની સાથે જે કોઈ શારીરિક સંબંધ રાખે તેઓને સજા કરવી, જો કે તેઓને મૃત્યુદંડ કરવો નહિ કેમ કે તે સ્ત્રી સ્વતંત્ર ન હતી. ");
INSERT INTO guj2017_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","તે વ્યક્તિએ દોષાર્થાર્પણ માટે મુલાકાતમંડપના દ્વાર આગળ યહોવાહ સમક્ષ ઘેટો લઈને આવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","પછી તેણે જે પાપ કર્યું હોય તેને લીધે યાજકે તે વ્યક્તિના દોષાર્થાર્પણ માટે તે ઘેટા વડે યહોવાહ સમક્ષ પ્રાયશ્ચિત કરવું, એટલે તેને માફ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","કનાન દેશમાં તમે જ્યારે પ્રવેશ કરો અને કોઈ પણ ફળનું વૃક્ષ રોપો તો તેઓનાં ફળને ત્રણ વર્ષ સુધી તમારે અનુચિત ગણવા. તેમને ખાવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","પરંતુ ચોથે વર્ષે તેના બધા જ ફળ પવિત્ર ગણાશે અને તેને યહોવાહનું સ્તવન કરવા માટે અર્પણ કરી દેવા. ");
INSERT INTO guj2017_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","પાંચમે વર્ષે તમે તેનાં ફળ ખાઈ શકો છો. એમ કરવાથી તે તમને વધારે ફળ આપશે. હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","તમારે રક્તવાળું માંસ ખાવું નહિ. ભવિષ્ય જોવા માટે તાંત્રિક પાસે જવું નહિ તેમ જ દૈવી શક્તિઓનો ઉપયોગ કરવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","તમારા માથાની બાજુના વાળ મૂર્તિપૂજકોની જેમ કાપો નહિ કે તમારી દાઢીના ખૂણા કાપવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","મૃત્યુ પામેલાઓના લીધે તમારા શરીર પર ઘા કરવા નહિ તથા તમારા શરીર પર છાપ મરાવવી નહિ, હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","તારી પુત્રીને ગણિકા બનાવીને ભ્રષ્ટ કરવી નહિ; રખેને દેશ વેશ્યાવૃતિમાં પડે અને આખો દેશ દુષ્ટતાથી ભરપૂર થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","તમે મારા વિશ્રામવારો પાળજો અને મારા મુલાકાતમંડપના પવિત્રસ્થાનનું માન જાળવજો. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ભૂવા કે જાદુગરો પાસે જઈને તેમને પ્રશ્નો પૂછીને તેમની સલાહ લઈને તમારી જાતને અશુદ્ધ કરશો નહિ, કારણ કે હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","તું પળિયાવાળા માણસની સમક્ષ ઊભો રહે, વડીલોનું સન્માન કર અને ઈશ્વરનું ભય રાખ. હું તમારો ઈશ્વર યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","જો કોઈ પરદેશી તમારા દેશમાં તમારી મધ્યે આવે, ત્યારે તમારે તેનું ખોટું કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","તમારી સાથે રહેતા પરદેશીને ઇઝરાયલમાં જન્મેલા વતની જેવો જ ગણવો. અને તમારા જેવો જ પ્રેમ તેને કરવો કેમ કે તમે પણ મિસર દેશમાં પરદેશી હતા. હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","તમે ન્યાય કરો ત્યારે લંબાઈના માપમાં અને વજનના માપમાં ખોટા માપનો ઉપયોગ કરવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","તમારે અદલ ત્રાજવાં, અદલ માપ, અદલ એફાહ અને અદલ હિનનો ઉપયોગ કરવો. હું તમને મિસર દેશમાંથી બહાર લઈ આવનાર તમારો ઈશ્વર યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","તમારે મારા બધા જ નિયમો, આજ્ઞાઓ અને વિધિઓનું પાલન કરવું. તેને અમલમાં લાવવા. હું યહોવાહ છું.’” ");
INSERT INTO guj2017_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“તું ઇઝરાયલના લોકોને કહે કે, ‘જો કોઈ ઇઝરાયલી કે તેઓની મધ્યે રહેતો પરદેશી પોતાના કોઈપણ બાળકને મોલેખને ચઢાવે તો તેને મૃત્યુદંડ કરવો. દેશના લોકો તેને પથ્થરે મારે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","હું પોતે પણ તે માણસની વિરુદ્ધ મારું મુખ કરીશ અને તેના લોકોમાંથી તેને અલગ કરીશ, કારણ તેણે મોલેખને પોતાનું બાળક ચઢાવીને મારા પવિત્રસ્થાનને અશુદ્ધ કર્યુ છે અને મારા પવિત્ર નામને ભ્રષ્ટ કર્યુ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","જો કોઈ માણસ પોતાનું બાળક મોલેખને ચઢાવે અને તે દેશના લોકો જો આંખ આડા કાન કરે અને તેને મૃત્યુદંડ આપવાની ના પાડે, ");
INSERT INTO guj2017_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","તો હું પોતે તેની અને તેના કુટુંબની વિમુખ થઈ જઈશ અને તેને અને તેની સાથે મોલેખની પાછળ જઈને તેની સાથે વ્યભિચાર કરનારાઓને હું નાબૂદ કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","જે વ્યક્તિ ભૂવાઓ અથવા દુષ્ટ આત્માઓ સાથે વાત કરનારા તથા તેમની સાથે વ્યભિચાર કરે અને સલાહ લે તેની વિરુદ્ધ હું મારું મુખ રાખીશ; હું તેનો તેના લોકમાંથી નાશ કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","તે માટે તમે પોતાને શુદ્ધ અને પવિત્ર કરો, કારણ કે, હું યહોવાહ તમારો પવિત્ર ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","તમારે કાળજીપૂર્વક મારા સર્વ વિધિઓનું પાલન કરવું, કેમ કે તમને શુદ્ધ કરનાર યહોવાહ હું છું. ");
INSERT INTO guj2017_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","જે કોઈ પોતાના પિતાને અને માતાને શાપ આપે તો તેને નિશ્ચે મૃત્યુદંડ આપવો. તેણે પોતાના પિતાને અથવા માતાને શાપ આપ્યો છે તેથી તે પોતાના મૃત્યુ માટે પોતે જ જવાબદાર ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","જે કોઈ પુરુષ બીજા પુરુષની પત્ની સાથે વ્યભિચાર કરે અથવા પડોશીની પત્ની સાથે વ્યભિચાર કરે તેઓ બન્નેને નિશ્ચે મૃત્યુદંડ આપવો. ");
INSERT INTO guj2017_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","જે કોઈ પુરુષ પોતાના પિતાની પત્ની સાથે શારીરિક સંબંધ બાંધે, તેણે પોતાના પિતાને કલંક લગાડે છે, તે બન્ને મૃત્યુદંડને પાત્ર થાય. તેઓનો દોષ મૃત્યુને પાત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","કોઈ પુરુષ જો પોતાની પુત્રવધૂ સાથે શારીરિક સંબંધ બાંધે, તો તે બન્નેને મૃત્યુદંડ આપવો. તેઓએ અસ્વાભાવિક કાર્ય કર્યું છે. તેઓનો દોષ મૃત્યુને પાત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","કોઈ પુરુષ જો અન્ય પુરુષ સાથે સ્ત્રીની જેમ શારીરિક સંબંધ બાંધે તો તે બન્નેએ ધિક્કારપાત્ર કાર્ય કર્યુ છે, તેઓને મૃત્યુદંડ આપવો. તેઓનો દોષ મૃત્યુને લાયક છે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","કોઈ પુરુષ જો કોઈ સ્ત્રીને અને તેની માતાને એમ બન્નેની સાથે લગ્ન કરે તો તે દુષ્ટતા છે. તે પુરુષને અને તે બન્ને સ્ત્રીઓને અગ્નિમાં બાળી મૂકવાં. એ માટે કે તમારી મધ્યે કોઈ દુષ્ટતા રહે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","કોઈ પુરુષ જો કોઈ પશુ સાથે શારીરિક સંબંધ બાંધે, તો તેને મૃત્યુદંડ આપવો અને તે પશુને મારી નાખવું. ");
INSERT INTO guj2017_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","અને જો કોઈ સ્ત્રી કોઈ પશુ સાથે શારીરિક સંબંધ કરે, તો તે સ્ત્રીને અને પશુને બન્નેને મારી નાખવાં કારણ, તેઓનો દોષ એ સજાને લાયક છે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","જો કોઈ પુરુષ પોતાના પિતાની કે માતાની પુત્રી સાથે લગ્ન કરે અને તેની સાથે શારીરિક સંબંધ બાંધે તો એ શરમજનક કાર્ય છે. તેઓને તેઓના લોકોની વચ્ચેથી અલગ કરવા. કેમ કે એ વ્યક્તિએ પોતાની બહેન સાથે શારીરિક સંબંધ બાંધ્યો છે. તેનો દોષ તે પુરુષને માથે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","જો કોઈ પુરુષ કોઈ સ્ત્રી સાથે તેના માસિકસ્રાવ દરમિયાન શારીરિક સંબંધ બાંધે તો તેણે તેનો લોહીકૂપ ખુલ્લો કર્યો છે અને તેણે પોતાનો લોહીકૂપ ખુલ્લો કર્યો છે. પુરુષ અને સ્ત્રી એ બન્નેને તેઓના લોકોમાંથી અલગ કરવા. ");
INSERT INTO guj2017_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","તારે તારી માતાની બહેન કે પિતાની બહેન સાથે શારીરિક સંબંધ ન બાંધવો કેમ કે એમ કરવાથી તું તેમને કલંકિત કરે છે. તેઓને તેઓના પાપની સજા થવી જ જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","જો કોઈ માણસ પોતાના કાકાની પત્ની સાથે સૂઈ જાય, તો તે પોતાના કાકાને કલંક લગાડે છે. એ બન્નેને તેઓના પાપની સજા થવી જોઈએ. તેઓ નિઃસંતાન અવસાન પામશે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","જો કોઈ પુરુષ પોતાના ભાઈની સ્ત્રી સાથે લગ્ન કરે તો તે અપવિત્ર ગણાય; કેમ કે તેણે એના ભાઈને કલંક લગાડયું છે. એ બન્ને નિઃસંતાન અવસાન પામશે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","તમારે મારા તમામ વિધિઓ અને નિયમોનું પાલન કરવું અને તેને અનુસરવા; જેથી એમ ન થાય કે હું તમને જે દેશમાં લઈ જાઉં તે દેશ તમને ઓકી કાઢે. ");
INSERT INTO guj2017_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","અને જે દેશજાતિને હું તમારી આગળથી હાંકી કાઢી મૂકું છું તે દેશના લોકોના રિવાજો પાળવા નહિ. કેમ કે આ બધા કાર્યો તેઓ કરતા હતા અને હું તે કાર્યોને ધિક્કારું છું. ");
INSERT INTO guj2017_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","મેં તમને કહ્યું છે, તમે તે દેશનો વારસો પામશો; હું તમને દૂધ તથા મધથી રેલછેલવાળો દેશ આપીને તેનું વતન આપીશ. તમને બીજી દેશજાતિઓથી અલગ કરનાર તમારો ઈશ્વર યહોવાહ હું છું. ");
INSERT INTO guj2017_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","તમારે શુદ્ધ અને અશુદ્ધ પશુઓ અને પક્ષીઓ વચ્ચેનો ભેદ સમજવો. અને તે અશુદ્ધ પશુ કે પક્ષી અથવા ભૂમિ પર ચાલનારા જીવો કે જેમને મેં તમારાથી અલગ કર્યા છે તે વડે પોતાને અશુદ્ધ ન કરવા. ");
INSERT INTO guj2017_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","તમે પવિત્ર બનો, કેમ કે હું, યહોવાહ, પવિત્ર છું. અને મેં તમને બીજા લોકોથી અલગ કર્યા છે એ માટે કે તમે મારા થાઓ. ");
INSERT INTO guj2017_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","તમારામાંથી જે કોઈ પુરુષ કે સ્ત્રી ભૂવા કે જાદુગર હોય તેને મૃત્યુદંડ આપવો. લોકોએ તેઓને પથ્થરો વડે મારી નાખવાં. તેઓ દોષી છે અને તેઓ મૃત્યુને લાયક છે. ");
INSERT INTO guj2017_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","યહોવાહે મૂસાને કહ્યું, “યાજકોને, હારુનના પુત્રોને કહે કે, ‘પોતાના લોકોમાંથી કોઈપણ મૃત્યુ પામે તો તેને લીધે કોઈપણ યાજકે પોતે અભડાવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","પોતાના નજીકના સગાંઓને લીધે એટલે પોતાની માતાને લીધે, પોતાના પિતાને લીધે પોતાના પુત્ર, પુત્રી કે પોતાના ભાઈને લીધે તે અભડાય, ");
INSERT INTO guj2017_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","અથવા પોતાની સગી બહેન જે કુંવારી એટલે જેના લગ્ન ન થયા હોય તેને લીધે તે અભડાય. ");
INSERT INTO guj2017_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","પણ તેણે જે લોકો તેના નજીકના સગા નથી, તેઓના મૃતદેહને અડીને પોતાની જાતને અશુદ્ધ કરવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","યાજકોએ શોક કરવા માટે પોતાના માથાના વાળ મૂંડાવવા નહિ, તેમ જ દાઢીની કિનાર પણ મૂંડાવવી નહિ અને પોતાના શરીર પર કોઈ ઘા પણ કરવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","તેઓ પોતાના ઈશ્વરના પવિત્ર લોક થાય અને તેઓના ઈશ્વરના નામને અપમાનિત ન કરે, કેમ કે યાજકો યહોવાહના હોમયજ્ઞો એટલે પોતાના ઈશ્વરની રોટલી અર્પણ કરે છે. એ માટે તેઓ પવિત્ર થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","તેઓ ગણિકા કે કોઈ અશુદ્ધ સ્ત્રીની સાથે અને જે સ્ત્રીના તેના પતિથી છૂટાછેડા થયા હોય તેની સાથે લગ્ન ન કરે. કેમ કે તેઓ ઈશ્વર માટે અલગ કરાયેલા છે. ");
INSERT INTO guj2017_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","તમારે યાજકને પવિત્ર ગણવો જોઈએ, કારણ કે તે મને અર્પણ ચઢાવે છે. તમારે તેને પવિત્ર ગણવો જોઈએ, કારણ તમને પવિત્ર કરનાર યહોવાહ હું પવિત્ર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","જો કોઈ યાજકની પુત્રી ગણિકા થઈને પોતાને અશુદ્ધ કરે તો તે પોતાના પિતાને કલંકિત કરે છે, તેથી તેને આગથી બાળી નાખવી. ");
INSERT INTO guj2017_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","જે પોતાના ભાઈઓ વચ્ચે પ્રમુખ યાજક હોય, જેને તેલથી અભિષેક કરાયો હોય અને વસ્ત્રો પહેરવા માટે શુદ્ધિકરણ કરાયું હોય તેણે પોતાના વાળ છૂટા મૂકવા નહિ તથા પોતાના વસ્ત્રો ફાડવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","જે જગ્યાએ માણસનો મૃતદેહ પડ્યો હોય ત્યાં તેણે જવું નહિ અને અશુદ્ધ થવું નહિ, પછી ભલે તે મૃતદેહ પોતાના પિતા કે માતાનો હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","તે પવિત્રસ્થાનની બહાર જાય નહિ અને પોતાના ઈશ્વરના પવિત્રસ્થાનને અશુદ્ધ કરે નહિ. કેમ કે પોતાના ઈશ્વરના અભિષેકના તેલ વડે તેને પ્રમુખ યાજક તરીકે પવિત્ર કરાયો છે. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","પ્રમુખ યાજકે કુંવારી સ્ત્રી સાથે લગ્ન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","તેણે કોઈ વિધવા, ગણિકા કે છૂટાછેડા લીધેલી સ્ત્રીની સાથે લગ્ન કરવું નહિ. તેણે આ બધામાંથી કોઈ સાથે લગ્ન ન કરવું. પણ પોતાના લોકમાંની જ કોઈ કુમારિકા સાથે લગ્ન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","તેણે બધા નિયમોનું પાલન કરવું, કે જેથી પોતાના લોકો મધ્યે પોતાના સંતાનને અશુદ્ધ ન કરે. કેમ કે તેને શુદ્ધ કરનાર યહોવાહ હું છું.’” ");
INSERT INTO guj2017_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“તું હારુનને કહે કે, શારીરિક ખામી ધરાવનાર તારા કોઈપણ વંશજે ઈશ્વરને અર્પણ ચઢાવવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","શારીરિક ખામી ધરાવનાર કોઈ પણ માણસ પછી તે અંધ હોય, અપંગ હોય કે જેના અંગ વિકૃતિ વાળા હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","અથવા સુકાઈ ગયેલા હાથ વાળો હોય કે પગ વાળો હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ખૂંધો હોય કે ઠીંગણો હોય, નેત્રનો રોગ કે ચામડીનો રોગ થયેલો હોય કે વ્યંઢળ હોય તેઓએ અર્પણ ચઢાવવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","હારુન યાજકના શારીરિક ખામી વાળા કોઈ પણ વંશજ મને હોમયજ્ઞો ચઢાવવા મારી પાસે આવે નહિ, જો તેનામાં કોઈ ખોડ હોય તો તેણે ઈશ્વરની ‘રોટલી’ ચઢાવવા પાસે જવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","તેમ છતાં ઈશ્વર સમક્ષ ચઢાવેલ પવિત્ર તેમ જ પરમપવિત્ર અર્પણોમાંથી યાજકોનો જે ભાગ છે તેમાંથી તે જમી શકે. ");
INSERT INTO guj2017_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","પરંતુ તેણે પડદાની નજીક કે પડદાની પાછળ અગ્નિની વેદીની નજીક જવું નહિ કારણ તેનામાં શારીરિક ખોડ છે અને તેણે મારી પવિત્ર જગ્યાઓને અશુદ્ધ કરવી નહિ. કેમ કે મેં યહોવાહે તેને પવિત્ર કરેલી છે.’ ");
INSERT INTO guj2017_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","અને મૂસાએ હારુનને અને તેના પુત્રોને અને સર્વ ઇઝરાયલીઓને આ પ્રમાણે કહી સંભળાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“હારુનને તથા તેના પુત્રોને આ કહે: ઇઝરાયલી લોકો જે પવિત્ર વસ્તુઓને તેઓ મારે સારુ અલગ કરે છે તેઓથી તેઓ દૂર રહે અને મારા પવિત્ર નામને અશુદ્ધ ન કરે. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","તું તેઓને કહે કે, ‘તમારો કોઈપણ વંશજ પોતે અશુદ્ધ હોય ત્યારે જે પવિત્ર વસ્તુઓ ઇઝરાયલીઓ યહોવાહને માટે અલગ કરે છે તેઓની પાસે જાય, તે માણસ મારી સંમુખથી અલગ કરાશે. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","હારુનના વંશના જે કોઈને કુષ્ઠ રોગ થયો હોય અથવા સ્રાવ થયો હોય; તેણે શુદ્ધ થતાં સુધી યહોવાહના પવિત્ર અર્પણમાંથી કશું ખાવું નહિ, જો કોઈ અશુદ્ધ મૃતદેહને અડે અથવા જે પુરુષને વીર્ય સ્રવતું હોય તેને અડકે, ");
INSERT INTO guj2017_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","સર્પટિયાંનો કે મનાઈ કરેલી વસ્તુઓનો સ્પર્શ કરે અથવા કોઈ કારણસર અશુદ્ધ થયેલી વ્યક્તિને અડકે; ");
INSERT INTO guj2017_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","તો યાજક જે કંઈ અશુદ્ધ અડકે તો તે સાંજ સુધી અશુદ્ધ ગણાય અને તે સ્નાન કરીને શુદ્ધ ન થાય ત્યાં સુધી તેણે પવિત્ર અર્પણમાંથી કશું ખાવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","સૂર્યાસ્ત થયા પછી તે શુદ્ધ ગણાય અને ત્યારે તે પવિત્ર ખોરાક ખાઈ શકે, કારણ તે તેનો ખોરાક છે. ");
INSERT INTO guj2017_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","તેણે કુદરતી રીતે મૃત્યુ પામેલું કે જંગલી જાનવરે ફાડી નાખેલું પશુ ખાવું નહિ. જો તે ખાય તો અશુદ્ધ ગણાય. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","તું યાજકોને કહે કે યાજકોએ મારા નિયમોનું પાલન કરવું: નહિ તો તેઓને પાપ લાગશે અને મારા નિયમોની અવગણના કરવા બદલ તેમણે મરવું પડશે. તેઓને પવિત્ર કરનાર યહોવાહ હું છું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","તે પવિત્ર વસ્તુઓમાંથી કોઈ યાજકના પરિવારના બહારના માણસે ખાવું નહિ. પછી ભલે તે યાજકનો મહેમાન હોય કે તેણે રાખેલો ચાકર હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","પણ જો કોઈ યાજક તેના પોતાના પૈસાથી ચાકરને ખરીદે તો તે તેમાંથી ખાય. યાજકનું કુટુંબ અને તેના ઘરમાં જન્મેલા પણ તે ખોરાકમાંથી ખાય. ");
INSERT INTO guj2017_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","જો યાજકની દીકરીના લગ્ન જે પુરુષ યાજક ન હોય તેની સાથે થયા હોય, તો તેણે પણ પવિત્ર અર્પણોમાંથી ખાવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","પણ જો યાજકની દીકરી વિધવા હોય અથવા છૂટાછેડા આપેલી હોય, તેનું ભરણપોષણ કરવાને કોઈ પુત્ર ન હોય અને તે પોતાના પિતાના કુટુંબમાં પાછી આવી હોય, તો તે પોતાના પિતાના પવિત્ર અર્પણોમાંથી ખાવાનું ખાઈ શકે છે. આ સિવાય જેઓ યાજકોના કુટુંબમાં નથી તેઓએ આ અર્પણોમાંથી ખાવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","જો કોઈ વ્યક્તિ અજાણતા આ પવિત્ર અર્પણોમાંથી ખાય તો, તેની કિંમતના વીસ ટકા ઉમેરીને યાજકને તે મૂલ્ય ભરપાઈ કરી આપે. ");
INSERT INTO guj2017_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","યાજકો ઇઝરાયલીઓની પવિત્ર વસ્તુઓ કે જે યહોવાહને તેઓ અર્પણ કરે છે, તેઓને અશુદ્ધ ન કરે. ");
INSERT INTO guj2017_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","અને એમ તેઓએ પવિત્ર અર્પણોને ખાઈને પોતાના પાપમાં વધારો ન કરવો અને તેને અપવિત્ર ન કરવું. તેઓને શુદ્ધ કરનાર યહોવાહ હું છું.’” ");
INSERT INTO guj2017_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“તું હારુનને અને તેના પુત્રોને તથા સર્વ ઇઝરાયલના લોકોને કહે કે જો કોઈ ઇઝરાયલી અથવા તેઓની વચ્ચે રહેતો વિદેશી પોતે લીધેલા સંકલ્પો પૂરા કરવા માટે કે ઐચ્છિકાર્પણ માટે યહોવાહની આગળ દહનીયાર્પણ ચઢાવે, ");
INSERT INTO guj2017_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","તો તેઓએ પશુઓમાંનાં, ઘેટાંમાંથી, બકરામાંથી કે અન્યમાંથી એબરહિત ખોડખાંપણ વગરના નર ચઢાવવો એ માટે કે તેઓ માન્ય થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","પણ તમારે ખામીવાળું કોઈ પણ પશુ ચઢાવવું નહિ. તેને હું તમારા લાભમાં સ્વીકારીશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","જો કોઈ વ્યક્તિ સંકલ્પો પૂરા કરવા અથવા ઐચ્છિકાર્પણ તરીકે યહોવાહ સમક્ષ શાંત્યર્પણ કરે તો તે પશુ બળદ અથવા ઘેટો હોય અને તે ખોડખાંપણ વગર હોય તો જ તે માન્ય થશે. ");
INSERT INTO guj2017_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","તમારે યહોવાહને અંધ, અપંગ, ઈજા પામેલ અંગવાળું, ખૂજલી કે ખરજવાવાળું કોઈ પશુ યહોવાહને ચઢાવવું નહિ, તેમ જ વેદી પર યહોવાહને સારુ હોમયજ્ઞ પણ કરવો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","જો કોઈ બળદ અથવા ઘેટું યહોવાહને અર્પણ કરવામાં આવે અને જો તેને વધારાના અંગો કે ઓછા અંગો હોય તેવાને ઐચ્છિકાર્પણ તરીકે અર્પણ કરવાની છૂટ છે પણ માનતાને સારુ તે માન્ય નહિ કરાય. ");
INSERT INTO guj2017_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","જે પશુના અંડકોશ છૂંદી, કચડી, ચીરી કે કાપી નાખવામાં આવ્યા હોય તેને તમારે યહોવાહને ચઢાવવું નહિ. તમારા દેશમાં એવાઓને ચઢાવવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","અને જે પરદેશીઓ એવાં પશુઓને યહોવાહને માટે અર્પણ તરીકે લાવે, તો તમારે તેનો સ્વીકાર કરવો નહિ. કેમ કે તેઓની અંદર ખામી અને બગાડ છે. હું તેને તમારા લાભમાં માન્ય કરીશ નહિ.’” ");
INSERT INTO guj2017_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“જ્યારે કોઈ વાછરડું, લવારું કે ઘેટું જન્મે ત્યારે સાત દિવસ સુધી તેને તેની મા પાસેથી કોઈએ લઈ લેવું નહિ. આઠમા દિવસે અને તે પછી તે યહોવાહને સારુ હોમયજ્ઞના અર્પણ તરીકે માન્ય થશે. ");
INSERT INTO guj2017_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","તે પશુ ગાય હોય કે ઘેટી તેને તથા તેના બચ્ચાંને બન્નેને એક જ દિવસે કાપવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","જયારે તમે ઉપકારાર્થાર્પણનો યજ્ઞ યહોવાહને ચઢાવો ત્યારે તે એવી રીતે ચઢાવો કે તે માન્ય થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","તમારે તે જ દિવસે તે જમી લેવું. બીજા દિવસ સવાર સુધી તેમાંથી કંઈ રહેવા દેવું નહિ. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","તમારે મારી સર્વ આજ્ઞાઓનું પાલન કરવું અને તેનો અમલ કરવો, કેમ કે હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","તમારે મારા પવિત્ર નામને ભ્રષ્ટ કરવું નહિ; બધા ઇઝરાયલીઓ મધ્યે હું પવિત્ર મનાઉં. તમને પવિત્ર કરનાર યહોવાહ હું છું. ");
INSERT INTO guj2017_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","હું તમને મિસરમાંથી તમારો ઈશ્વર થવા માટે લઈ આવ્યો. હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ઇઝરાયલીઓને તું કહે કે યહોવાહના પર્વો નીચે મુજબ છે, તમારે યહોવાહના પસંદ કરેલા ઉત્સવોએ પવિત્ર મેળાવડા કરવાનો ઢંઢેરો પિટાવવો. ");
INSERT INTO guj2017_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","છ દિવસ કામ કરવું, પણ સાતમો દિવસ સંપૂર્ણ વિશ્રામનો અને પવિત્ર મેળાવડાનો દિવસ છે. એ દિવસે કામ ન કરવું. તમારા સર્વ રહેઠાણોમાં તે યહોવાહનો વિશ્રામવાર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","પ્રતિવર્ષ યહોવાહના જે ઉત્સવો ઊજવવાના, મેળાવડા કરવા માટે ઢંઢેરો પિટાવવાના આ પવિત્ર ઉત્સવો છે તે આ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","પહેલા માસમાં, એટલે પહેલા માસના ચૌદમા દિવસે સાંજે યહોવાહનું પાસ્ખાપર્વ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","એ માસના પંદરમાં દિવસે યહોવાહનું બેખમીરી રોટલીનું પર્વ છે. તમારે સાત દિવસ સુધી બેખમીરી રોટલી ખાવી. ");
INSERT INTO guj2017_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","પહેલા દિવસે તમારે પવિત્ર મેળાવડો કરવો. તેમાં કોઈ દૈનિક સાંસારિક કાર્ય કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","પણ સાત દિવસ તમારે યહોવાહને હોમયજ્ઞ ચઢાવવો. સાતમા દિવસે પણ તમારે મેળાવડો કરવો. અને રોજના કામ કરવા નહિ.’” ");
INSERT INTO guj2017_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ઇઝરાયલીઓને કહે કે, ‘જે દેશ હું તમને આપવાનો છું તેમાં તમે જાઓ અને પાક લણો ત્યારે તમારે પહેલા પાકની પ્રથમ ફળની પૂળી તમારે યાજક પાસે લાવવી. ");
INSERT INTO guj2017_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","યાજક વિશ્રામવારના બીજા દિવસે તે પૂળીને યહોવાહની આગળ ઉપર કરે કે જેથી તે તમારે સારુ માન્ય થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","જે દિવસે તમે પૂળી મને ચઢાવો તે દિવસે તમારે એક વર્ષનો ખોડખાંપણ વગરનો ઘેટો યહોવાહને દહનીયાર્પણ તરીકે ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","અને તેને માટે ખાદ્યાર્પણ તરીકે તેલમાં મોહેલા સોળ વાટકા મેંદાનો લોટ લઈને સુવાસિત હોમયજ્ઞ યહોવાહને ચઢાવવો તથા પેયાર્પણ તરીકે એક લિટર દ્રાક્ષારસ લાવવો. ");
INSERT INTO guj2017_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","તમે આ પ્રમાણે તમે ઈશ્વરને અર્પણો ચઢાવો નહિ ત્યાં સુધી એટલે કે તે અગાઉ તમારે નવા પાકમાંથી કશું ખાવું નહિ. તાજો પોંક, રોટલી કે લીલાં કણસલાં, આમાંનું કશું જ ખાવું નહિ. તમારી વંશપરંપરા તમારા સર્વ રહેઠાણોમાં એ સદાનો વિધિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","વિશ્રામવાર પછીના દિવસથી તમે જે દિવસે પૂળીની ભેટ ચઢાવો તે દિવસથી પૂરા સાત અઠવાડિયાં ગણવાં. ");
INSERT INTO guj2017_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","સાતમા અઠવાડિયાં પછીના વિશ્રામવારે એટલે કે પચાસમા દિવસે, તમારે યહોવાહને નવા પાકમાંથી ખાદ્યાર્પણ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","તમારે તમારાં ઘરમાંથી ખમીર નાખીને બનાવેલી બે દશાંશ એફાહની સોળ વાટકા મેંદાની બે રોટલી લાવવી. એ યહોવાહને તમારા પાકના પ્રથમ ફળનું અર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","રોટલી ઉપરાંત યહોવાહને દહનીયાર્પણરૂપે તમારે એક વર્ષના ખામી વગરનાં ઘેટાંનાં સાત બચ્ચા, એક વાછરડું અને બે ઘેટાં અર્પણ કરવા. આ સર્વને અનુરૂપ ખાદ્યાર્પણ અને પેયાર્પણથી યહોવાહને સારુ સુવાસિત હોમયજ્ઞ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","તમારે એક બકરો પાપાર્થાર્પણ તરીકે અને શાંત્યર્પણ તરીકે એક વર્ષના બે નર ઘેટાં પણ ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","અને યાજક પ્રથમ ફળની રોટલી સાથે તેઓને તથા પેલા બે ઘેટાંને યહોવાહની સંમુખ અર્પણ કરે. તે પવિત્ર અર્પણ યાજકને સારુ યહોવાહને અર્પિત થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","એ જ દિવસે તમારે પવિત્ર મેળાવડાનો ઢંઢેરો પીટવો. તે દિવસે કોઈ સાંસારિક કામ કરવાં નહિ, તમે ગમે ત્યાં રહેતા હોય છતાં તમારા વંશજોને માટે એ સદાનો વિધિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","તમે જયારે પાક લણો, ત્યારે તમારે છેક ખેતરના ખૂણા સુધી પૂરેપૂરું કાપવું નહિ. તેમ જ તેમાંથી પડી રહેલો પાક વીણી લેવો નહિ. તમારે તેને ગરીબો તથા પરદેશીઓ માટે રહેવા દેવો. હું તમારો ઈશ્વર યહોવાહ છું.’” ");
INSERT INTO guj2017_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ઇઝરાયલના લોકોને કહે કે સાતમા માસના પહેલા દિવસે તમારે પવિત્ર વિશ્રામ, રણશિંગસાદની યાદગીરી અને પવિત્ર મેળાવડો કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","એ દિવસે તમારે રણશિંગડા વગાડવા અને પવિત્ર મેળાવડો કરવો. તમારે રોજનું કોઈ કામ કરવું નહિ, પરંતુ યહોવાહને હોમયજ્ઞ ચઢાવવો.’” ");
INSERT INTO guj2017_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“સાતમા માસનો દશમો દિવસ પ્રાયશ્ચિતનો દિવસ છે. એ દિવસે પવિત્ર મેળાવડો રાખવો. ઉપવાસ કરવો અને યહોવાહને હોમયજ્ઞ ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","એ દિવસે તમારે કોઈ કામ કરવું નહિ, કેમ કે તે પ્રાયશ્ચિતનો દિવસ છે. તે દિવસે તમારા ઈશ્વર યહોવાહ સમક્ષ તમારે પ્રાયશ્ચિત કરવું. ");
INSERT INTO guj2017_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","જે કોઈ તે દિવસે ઉપવાસ નહિ કરે તો તેને તેના લોકોમાંથી અલગ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","જે કોઈ આ દિવસે કોઈ પણ કામ કરશે તો હું યહોવાહ તેના લોકોમાંથી તેનો નાશ કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","તે દિવસે તમારે કોઈપણ પ્રકારનું કામ કરવું નહિ, તમારા રહેઠાણોમાં તમારા લોકોના વંશજો માટે એ સદાનો વિધિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","આ તો પવિત્ર વિશ્રામવારનો દિવસ છે, માટે તમે ઉપવાસ કરો અને આત્મકષ્ટ કરો. નવમા દિવસની સાંજથી પછીના દિવસની સાંજ સુધી તમારે વિશ્રામ પાળવો.” ");
INSERT INTO guj2017_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ઇઝરાયલના લોકોને એમ કહે કે, આ સાતમા મહિનાના પંદરમા દિવસે યહોવાહનું માંડવાપર્વ છે અને તે સાત દિવસ સુધી ચાલશે. ");
INSERT INTO guj2017_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","પ્રથમ દિવસે તમારે પવિત્ર મેળાવડો કરવો. તમારે એ દિવસે કોઈ કાર્ય કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","પર્વના સાતેય દિવસ તમારે યહોવાહ સમક્ષ હોમયજ્ઞો અર્પણ કરવા. આઠમા દિવસે ફરીથી પવિત્ર મેળાવડો કરવો અને ફરીથી હોમયજ્ઞો અર્પણ કરવા. આ પછી પર્વની ઊજવણી પૂરી કરવી, આ દિવસે પણ તમારે કોઈ પણ સાંસારિક કામ કરવાં નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","આ બધા યહોવાહના વાર્ષિક પર્વો છે. આ પર્વો પર પવિત્ર મેળાવડા યોજવા, એ દિવસો દરમ્યાન નક્કી કરેલા નિયમ મુજબ દહનીયાર્પણ, ખાદ્યાર્પણ અને પેયાર્પણ યહોવાહને અર્પણ કરવા. ");
INSERT INTO guj2017_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","યહોવાહના વિશ્રામવારો, તમારા દાન તથા તમારી સર્વ માનતાઓ તથા તમારા સર્વ ઐચ્છિકાર્પણો જે તમે યહોવાહને અર્પણ કરો છો તે ઉપરાંત એ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","તેમ છતાં સાતમા માસના પંદરમા દિવસે જમીનની ઊપજનો સંગ્રહ કરી રહ્યા બાદ તમારે યહોવાહને સારુ સાત દિવસ સુધી આ પર્વ ઊજવવું. પહેલો દિવસ અને આઠમો દિવસ પવિત્ર વિશ્રામ પાળવો. ");
INSERT INTO guj2017_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","પ્રથમ દિવસે તમારે વૃક્ષોના ઉત્તમ ફળ, ખજૂરીની ડાળીઓ, તથા ઘટાદાર વૃક્ષોના ડાળખાં અને નાળાંના વેલાઓ લઈને તમારે યહોવાહ તમારા ઈશ્વરની સંમુખ સાત દિવસ સુધી ઉત્સવ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","તમારે પ્રતિવર્ષ યહોવાહના માનમાં સાત દિવસ આ ઉત્સવ ઊજવવો. તમારા વંશજો માટે એ સદાનો વિધિ થાય. સાતમા માસમાં તમારે આ પર્વ પાળવું. ");
INSERT INTO guj2017_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","એ સાત દિવસો દરમિયાન તમારે માંડવાઓમાં રહેવું. ઇઝરાયલના સર્વ વતનીઓએ સાત દિવસ સુધી માંડવાઓમાં રહેવું. ");
INSERT INTO guj2017_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","જેથી તમારા વંશજોને, પેઢી દર પેઢી યાદ રહે કે હું તમને ઇઝરાયલીઓને મિસરમાંથી બહાર લઈ આવ્યો ત્યારે મેં તમને માંડવાઓમાં વસાવ્યા હતા. હું યહોવાહ તમારો ઈશ્વર છું.’” ");
INSERT INTO guj2017_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","મૂસાએ યહોવાહે મુકરર કરેલા પર્વો વિષે ઇઝરાયલીઓને કહી જણાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ઇઝરાયલના લોકોને કહે કે, દીવીમાં અખંડ દીપ પ્રગટતો રાખવા માટે જૈતૂનનું શુદ્ધ તેલ લાવે. ");
INSERT INTO guj2017_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","સાક્ષ્યપેટીના પડદાની બહાર બાજુ મુલાકાતમંડપમાં યહોવાહની સંમુખ સાંજથી સવાર સુધી તે દીપ યહોવાહ સમક્ષ પ્રગટતો રહે તેની કાળજી હારુન રાખે. તે વંશપરંપરા તમારા માટે સદાનો વિધિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","મુખ્ય યાજકે હંમેશા શુદ્ધ સોનાની દીવી ઉપરના દીવા યહોવાહ સમક્ષ અંખડ પ્રગટતા રહે તે માટે કાળજી રાખવી. ");
INSERT INTO guj2017_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","તમારે મેંદો લેવો અને તેની બાર રોટલી કરવી. દરેક રોટલી બે દશાંશ એફાહની હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","તમારે તે બાર રોટલી શુદ્ધ સોનાના બાજઠ ઉપર યહોવાહની સમક્ષ છ છની બે થપ્પીમાં ગોઠવવી. ");
INSERT INTO guj2017_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","તે બન્ને થપ્પી પર તમારે શુદ્ધ લોબાન મૂકવો, એ સારુ કે રોટલીને સારુ તે યાદગીરીરૂપ થાય. અને યહોવાહને સારુ હોમયજ્ઞ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","પ્રતિ વિશ્રામવારે તે યહોવાહ સમક્ષ નિયમિત રાખે. અને ઇઝરાયલીઓ તરફથી એ સદાનો કરાર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","અને આ અર્પણ હારુન તથા તેના પુત્રોનું થાય. આ રોટલી તેઓ પવિત્ર જગ્યાએ ખાય. કેમ કે તે યહોવાહને ચઢાવાતા હોમયજ્ઞોમાંનો યાજકને મળતો પવિત્ર ભાગ છે.” ");
INSERT INTO guj2017_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","હવે એમ થયું કે, એક દિવસ ઇઝરાયલી સ્ત્રીનો દીકરો જેનો પિતા મિસરી હતો તે ઇઝરાયલના લોકો મધ્યે ફરવા નીકળ્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ઇઝરાયલી સ્ત્રીના દીકરાએ યહોવાહના નામનું દુર્ભાષણ કરીને તેમને શાપ દીધો. તેથી લોકો તેને મૂસા પાસે લાવ્યા. તેની માતાનું નામ શલોમીથ હતું. તેની સમક્ષ રજૂ કરવામાં આવ્યો. તે દાનના કુળના દિબ્રીની પુત્રી હતી. ");
INSERT INTO guj2017_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","યહોવાહથી તેમની ઇચ્છા જણાવવામાં ન આવે ત્યાં સુધી તેઓએ તેને ચોકીમાં રાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“જે માણસે યહોવાહને શાપ આપ્યો છે તેને છાવણીથી બહાર લઈ જા. જેઓએ તેને બોલતા સાંભળ્યો હોય તે સર્વએ પોતાના હાથ તેના માથા પર મૂકવા. પછી બધા લોકો પથ્થરો મારીને તેને મારી નાખે. ");
INSERT INTO guj2017_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ત્યારબાદ તું ઇઝરાયલીઓને કહે કે, ‘જે કોઈ માણસ યહોવાહને શાપ આપે તેનું પાપ તેને માથે. ");
INSERT INTO guj2017_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","જે કોઈ યહોવાહના નામનું દુર્ભાષણ કરે તે નિશ્ચે માર્યો જાય. અને આખી જમાત તેને નિશ્ચે પથ્થરે મારે. પછી ભલે તે ઇઝરાયલનાં વતની હોય કે પરદેશી હોય. જો કોઈ યહોવાહના નામનું દુર્ભાષણ કરે તો તે નિશ્ચે માર્યો જાય. ");
INSERT INTO guj2017_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","અને જે કોઈ વ્યક્તિ બીજાની હત્યા કરે તો તેને મૃત્યુદંડ આપવો. ");
INSERT INTO guj2017_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","જે કોઈ બીજાના પશુને મારી નાખે તેણે તેનો બદલો ભરી આપવો, જીવના બદલે જીવ. ");
INSERT INTO guj2017_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","જો કોઈ વ્યક્તિ તેના પડોશીને ઈજા પહોંચાડે તો તેણે જે કર્યુ હોય તેવું જ તેને કરવું: ");
INSERT INTO guj2017_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ભાંગવાને બદલે ભાંગવું, આંખને બદલે આંખ, દાંત બદલે દાંત. જેવી ઈજા તેણે કોઈ વ્યક્તિને કરી હોય તેવી જ ઈજા તેને કરવી. ");
INSERT INTO guj2017_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","જે કોઈ વ્યક્તિ કોઈ પશુને મારી નાખે તો તેણે બદલો ભરી આપવો. પણ જો કોઈ માણસને મારી નાખે તો તેને મૃત્યુદંડ આપવો. ");
INSERT INTO guj2017_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","જેમ વતનીઓને માટે તેમ જ પરદેશીને માટે એક જ પ્રકારનો કાયદો તમારે લાગુ કરવો. કેમ કે હું યહોવાહ તમારો ઈશ્વર છું.’ ");
INSERT INTO guj2017_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","અને મૂસાએ ઇઝરાયલીઓને આ પ્રમાણે કહ્યું. પછી તેઓ યહોવાહને શાપ આપનાર માણસને છાવણી બહાર લાવ્યા. અને જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તે પ્રમાણે તે લોકોએ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","સિનાઈ પર્વત પર યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“તું ઇઝરાયલી લોકોને આ કહે કે, ‘જે દેશ હું તમને આપવાનો છું, તેમાં તમે પ્રવેશ કરો ત્યારે તે દેશ યહોવાહ માટે વિશ્રામવાર પાળે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","છ વર્ષ સુધી તમારે તમારા ખેતરોમાં વાવણી કરવી, છ વરસ સુધી તમારે દ્રાક્ષવાડીઓમાં કાપકૂપ કરવી અને ઊપજનો સંગ્રહ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","પરંતુ સાતમે વર્ષે દેશને માટે પવિત્ર વિશ્રામનો સાબ્બાથ, એટલે યહોવાહનો વિશ્રામવાર થાય. તારે તારા ખેતરમાં વાવણી કરવી નહિ અને તારી દ્રાક્ષવાડીમાં કાપકૂપ કરવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","જમીન પર જે પોતાની જાતે ઊગી નીકળ્યું હોય તે તમારે કાપવું નહિ અથવા કાપકૂપ વગરની દ્રાક્ષની વાડીઓમાં જે દ્રાક્ષ બેસે તે તમારે લેવી નહિ. એ વર્ષ દેશને માટે પવિત્ર વિશ્રામનું વર્ષ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","એ વિશ્રામના વર્ષમાં ખેડ્યા વગરની જમીનમાં આપોઆપ જે કંઈ ઊપજ થશે તે તમારો, તમારા દાસ, દાસીઓનો, તમારા મજૂરોનો અને તમારી મધ્યે વસતા પરદેશીઓનો તે ખોરાક થશે; ");
INSERT INTO guj2017_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","અને જમીનમાં જે કંઈ ઊપજ થશે તે તમારાં જાનવરોનો અને દેશના વન્ય જાનવરોનો પણ તે ખોરાક થશે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","તમારે પોતાના માટે સાત વર્ષનાં સાત વિશ્રામ ગણવાં, એટલે કે સાત વાર સાત વર્ષ, એટલે ઓગણપચાસ વર્ષ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","પછી સાતમા માસના દશમે દિવસે એટલે કે પ્રાયશ્ચિતને દિવસે તમારે આખા દેશમાં મોટા સાદે ઘેટાંનું રણશિંગડું વગડાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","અને પચાસમાં વર્ષને પવિત્ર જાહેર કરી દેશના બધા વતનીઓ માટે છુટકારાનો ઢંઢેરો પિટાવવો. તમારા માટે તે રણશિંગડાનું એટલે જ્યુબિલીનું વર્ષ છે. અને તમારે દરેક જણે પોતપોતાના વતનમાં અને કુટુંબમાં પાછા આવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","એ પચાસમાંનું વર્ષ તમારા માટે ખાસ જ્યુબિલીનો વર્ષ થાય. એ વર્ષે તમારે કાંઈ વાવવું નહિ, અને પોતાની જાતે જે ઊગ્યું હોય તે ખાવું. તેમ જ કાપકૂપ કર્યા વિનાની દ્રાક્ષની વાડીમાંથી દ્રાક્ષ વીણી લેવી. ");
INSERT INTO guj2017_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","કારણ, એ તો જ્યુબિલી છે, તેને તમારે પવિત્ર ગણવી. એ વર્ષે ખેતરોમાં આપમેળે ઊગી નીકળેલો પાક તમારે ખાવો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","જ્યુબિલીના વર્ષે પ્રત્યેક વ્યક્તિએ પોતપોતાના વતનમાં પાછા જવું. ");
INSERT INTO guj2017_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","જો તમે તમારા પડોશીને જમીન વેચો કે ખરીદો તો તમારે એકબીજાને છેતરવા નહિ કે ખોટું કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","જ્યુબિલી પછી વીતી ગયેલા વર્ષો પ્રમાણે તમારે તમારા પડોશી પાસેથી ખરીદી કરવી અને પાકના વર્ષોની ગણતરી પ્રમાણે તે તમને વેચાતું આપે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","જો વર્ષો વધારે બાકી હોય તો કિંમત વધારે ઠરાવવી અને ઓછા વર્ષ બાકી હોય તો કિંમત ઓછી ઠરાવવી, કેમ કે જે વેચાય છે તે જે પાક મળશે તેના ધોરણે તે આપે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","તમારે એકબીજાને છેતરવા નહિ કે ખોટું કરવું નહિ; પણ તેને બદલે તમારે તમારા ઈશ્વરનો ભય રાખવો. કેમ કે હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","મારા વિધિઓ, મારા નિયમોનું પાલન કરશો અને તેનો અમલ કરશો તો તમે દેશમાં સુરક્ષિત રહેશો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ભૂમિ મબલખ પાક આપશે અને તમે ધરાતાં સુધી ખાશો તેમ જ તમે સુરક્ષિત રહેશો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","તમે કહેશો કે, “જો સાતમા વર્ષે અમે વાવીએ નહિ અથવા ઊપજનો સંગ્રહ કરીએ નહિ તે વર્ષે અમે શું ખાઈએ?” ");
INSERT INTO guj2017_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","સાંભળો, છઠ્ઠા વર્ષે હું તમને ત્રણ વર્ષ ચાલે તેટલાં મબલખ પાકથી આશીર્વાદિત કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","તમે આઠમે વર્ષે વાવશો ત્યારે પણ તમે આગળના વર્ષના પાકમાંથી ખાતા હશો, નવમે વર્ષે તમે નવો પાક ઘરમાં લાવશો ત્યાં સુધી તમે છઠ્ઠા વર્ષના સંગ્રહ કરેલા પાકમાંથી ખાશો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","જમીન સદાને માટે નવા માલિકને વેચાય નહિ. કેમ કે જમીન મારી છે. તમે માત્ર પરદેશીઓ અને યાત્રીઓ તરીકે મારી જમીન પર રહો છો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ખરીદ વેચાણમાં એક શરત એવી હોવી જ જોઈએ કે જમીનને વેચનાર માણસ ગમે ત્યારે તેને પાછી ખરીદી શકે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","જો તમારા ઇઝરાયલી ભાઈઓ ગરીબ થઈ જાય અને તેને કારણે જો તે તેની જમીનનો થોડો ભાગ વેચે, તો તેનો નજીકનો સંબંધી આવીને તેના ભાઈઓએ જે વેચી કાઢ્યું હોય તેને પાછી ખરીદી શકે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","તેની જમીન છોડાવવાને જો કોઈ નજીકનો સંબંધી ના હોય પણ તે સમૃદ્ધિ પામ્યો હોય અને તેને છોડાવવાની તેની પાસે સક્ષમતા હોય, ");
INSERT INTO guj2017_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","તો તેણે વેચાણ પછી વીતેલાં વર્ષો હિસાબમાં ગણવા અને જેને તેણે તે જમીન વેચી હોય તેને ભરપાઈ કરવું. અને તે જમીન તેને તે પાછી આપે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","પરંતુ જો તે જમીન પાછી લેવા સક્ષમ ન હોય તો જ્યુબિલીના વર્ષ સુધી જે માણસે તેને ખરીદી હોય તેની પાસે તે રહે. જ્યુબિલીના વર્ષે જે માણસે જમીન વેચેલી તેને એટલે તેના મૂળ માલિકને પાછી આપવામાં આવે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","જો કોઈ માણસ નગરમાંનું તેનું ઘર વેચે, તો વેચાણ પછી પૂરા એક વર્ષ સુધી તેને ફરીથી ખરીદી લેવાનો હક્ક રહે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","જો પૂરા એક વર્ષ દરમિયાન તે પાછું ખરીદી લેવામાં ના આવે તો તે ઘરની કાયમની માલિકી નવા માલિકની અને તેના વંશજોની થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","પણ જ્યુબિલી વર્ષમાં તે મૂળ માલિકને પાછું ન મળે, કોટ વગરનાં ગામડાનાં મકાનો જમીન જેવાં ગણાય, તે પાછાં ખરીદી લેવાનો હક્ક કાયમ રહે અને જુબિલી વર્ષમાં તો તે ઘરો મૂળ માલિકને પાછું મળવું જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","તેમાં એક અપવાદ છે, લેવીના મકાનો કોટવાળાં નગરોમાં હોય તો પણ તેને ગમે ત્યારે છોડાવી શકાય. ");
INSERT INTO guj2017_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","જો કોઈ લેવી એવા શહેરમાં આવેલું પોતાનું મકાન પાછું ન ખરીદી લે, તો તે જ્યુબિલીના વર્ષમાં તેને પાછું મળી જાય; કારણ, લેવીઓનાં શહેરમાંનાં મકાન એ તેમની ઇઝરાયલમાંની સંપત્તિ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","પરંતુ લેવી પોતાના નગરોની આસપાસ આવેલી જમીન વેચી શકે નહિ, કારણ કે તે તેઓની કાયમી મિલકત છે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","તમારા દેશનો કોઈ ભાઈ જો ગરીબ થઈ જાય અને પોતાનું ભરણપોષણ કરી શકે નહિ, તો તેને મદદ કરવી. તે પરદેશી અથવા પ્રવાસી તરીકે તમારી સાથે રહે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","તમારે તેની પાસેથી નફો કે વ્યાજ ન લેવું. પણ ઈશ્વરનો ભય રાખવો એ માટે કે તમારો ભાઈ તમારી સાથે રહે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","તમારે તમારા પૈસા તેને વ્યાજે ન આપવા. તેમ જ નફા સારુ તમારું અન્ન તેને ન આપવું. ");
INSERT INTO guj2017_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","તમને કનાનનો દેશ આપવા માટે અને તમારો ઈશ્વર થવા માટે તમને મિસરમાંથી બહાર લાવનાર હું તમારો ઈશ્વર યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","તમારા દેશનો જો કોઈ ભાઈ ગરીબાઈમાં આવી પડે અને પોતે તમને વેચાઈ જાય તો તમારે તેની પાસે ચાકર તરીકે કામ કરાવવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","તેની સાથે નોકરીએ રાખેલ ચાકર જેવો વ્યવહાર કરવો. અને તે તમારી સાથે પ્રવાસી તરીકે રહે. તે જ્યુબિલીના વર્ષ સુધી તમારી ચાકરી કરશે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","પછી તે અને તેની સાથે તેના બાળકો પણ છૂટીને પોતાના ઘર અને પોતાના પિતાના વતનમાં તે પાછો જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","કેમ કે તેઓ મારા સેવકો છે જેઓને હું મિસરમાંથી બહાર કાઢી લાવ્યો હતો. તેઓને ગુલામની જેમ વેચવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","તમારે નિર્દયતાથી તેઓ પર માલિકીપણું ન કરવું. પણ ઈશ્વરનો ભય રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","અને જે દાસ તથા દાસી તમે રાખો તે આસપાસની દેશજાતિઓમાંથી તમારે રાખવા. ");
INSERT INTO guj2017_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","વળી તમારી વચ્ચે રહેતા પરદેશીઓના સંતાનોને તથા તમારી સાથે રહેતા તેઓના કુટુંબો તેઓમાંથી તમારે ખરીદવા. અને તેઓ તમારી સંપત્તિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","તમે તે લોકોને તમારા વંશજોને વારસામાં આપી શકો છો, તેમ જ તમે તેમનો કાયમ માટે ચાકર તરીકે ઉપયોગ કરી શકો છો, પણ તમારા ઇઝરાયલી ભાઈઓ પાસે ગુલામોની જેમ મજૂરી કરાવવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","જયારે કોઈ પરદેશી કે તમારી સાથે રહેતો પ્રવાસી ધનવાન થઈ જાય અને તમારો ઇઝરાયલી ભાઈ ગરીબ થયો હોય અને તે પોતાની જાતને તે માણસને વેચી દે, ");
INSERT INTO guj2017_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","તો તમારા ઇઝરાયલી ભાઈના વેચાયા પછી તેને પાછો ખરીદી લેવાય. તેના જ કુટુંબનો એક તેને ખરીદી લે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","તેના કાકા કે ભત્રીજા કે અન્ય કોઈ નજીકનો સંબંધી તેને પાછો ખરીદી લઈ શકે છે અથવા જો તે સમૃદ્ધ થયો હોય તો તે પોતે પોતાની જાતને છોડાવી શકે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","તેણે પોતાને ખરીદેલી વ્યક્તિ સાથે ગણતરી કરવી; તે વેચાયો હોય તે વર્ષથી માંડીને તે જ્યુબિલીના વર્ષ સુધી ગણે; અને તે વર્ષોની સંખ્યા પ્રમાણે તેના વેચાણનું મૂલ્ય થાય. ચાકરના દિવસો પ્રમાણે તે તેની સાથે રહે. ");
INSERT INTO guj2017_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","જો જ્યુબિલીને ઘણા વર્ષો બાકી હોય તો જેટલા પૈસાથી તે ખરીદાયો હોય તેમાંથી તે વ્યક્તિએ કિંમતનો ભાગ પાછો આપવો. અને એ વર્ષોની ગણતરી પર આધારિત હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ઘણાં વર્ષો વીતી ગયાં હોય અને જ્યુબિલી વર્ષને થોડાં જ વર્ષ બાકી હોય, તો પોતાની જાતને વેચી જે નાણાં પ્રાપ્ત કર્યા હોય તેનો થોડો જ ભાગ તેણે પાછો આપવો. ");
INSERT INTO guj2017_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","વર્ષ દર વર્ષ તેની સાથે નોકરીએ રાખેલા ચાકરની જેમ વર્તન કરવું. અને તમારે તેના માલિકને તેની પાસે નિર્દયતાથી કામ લેવા દેવું જોઈએ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","જો જ્યુબિલી વર્ષના વચગાળાનાં વરસો દરમિયાન તેને પાછો ખરીદી લેવામાં ન આવ્યો હોય, તો તેને અને તેનાં બાળકોને જ્યુબિલીના વર્ષમાં છૂટાં કરી દેવાં, ");
INSERT INTO guj2017_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","કેમ કે, ઇઝરાયલીઓ મારા સેવકો છે; તેઓ મારા સેવકો છે જેઓને હું મિસર દેશમાંથી બહાર કાઢી લાવ્યો છું; હું યહોવાહ તમારો ઈશ્વર છું.’” ");
INSERT INTO guj2017_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“તમારે પોતાને માટે કોઈ મૂર્તિઓ બનાવવી નહિ, તેમ જ કોતરેલી પ્રતિમા, પથ્થરનો સ્તંભ ઊભા ન કરવા. અને પોતાને સારુ તમારા દેશમાં આકૃતિઓ કોતરી કાઢેલો કોઈ પથ્થર નમવા સારુ ઊભો કરશો નહિ, કેમ કે હું યહોવાહ તમારો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","તમારે મારા વિશ્રામવાર પાળવા અને મારા પવિત્રસ્થાનની પવિત્રતાને માન આપવું, હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","જો તમે મારા સર્વ નિયમો અને આજ્ઞાઓનું પાલન કરીને તેનો અમલ કરશો, ");
INSERT INTO guj2017_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","તો હું તમારા માટે નિયમિત ઋતુ પ્રમાણે વરસાદ મોકલીશ અને જમીન તમને પોતાની ઊપજ આપશે અને વૃક્ષો ફળ આપશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","તમારે ત્યાં પુષ્કળ પાક ઊતરશે, વાવણીનો સમય આવે ત્યાં સુધી દ્રાક્ષ થયા કરશે અને લણવાનું કામ વાવણીના સમય સુધી ચાલશે, તમે ધરાતાં સુધી જમશો અને દેશમાં સુરક્ષિત રહેશો. ");
INSERT INTO guj2017_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","હું તમને દેશમાં શાંતિ આપીશ અને તમે રાત્રે નિર્ભય બનીને નિરાંતે સુઈ શકશો, હું દેશમાંથી હિંસક પશુઓને દૂર કરીશ અને તલવાર તમારા દેશમાં ચાલશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","તમે તમારા દુશ્મનોને હાંકી કાઢશો અને તેઓ તમારી આગળ તલવારથી પડશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","તમારામાંના પાંચ તે એકસોને નસાડી મૂકશે અને તમારામાંના એકસો તે દસહજારને નસાડશે. તમારા સર્વ શત્રુઓ તમારી આગળ તલવારથી પડશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","હું તમારા તરફ કૃપાદ્રષ્ટિ રાખીશ, તમને સફળ કરીશ અને તમને વધારીશ. તમારી સાથે હું મારો કરાર સ્થાપિત કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","તમે લાંબા સમયથી સંગ્રહ કરી રાખેલું અનાજ ખાશો. નવો પાક તૈયાર થશે ત્યારે તેનો સંગ્રહ કરવા જૂનો પાક બહાર કાઢી નાખશો. ");
INSERT INTO guj2017_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","હું તમારી મધ્યે મારો મંડપ ઊભો કરાવીશ. અને હું તમારાથી કંટાળી જઈશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","હું તમારી મધ્યે ચાલીશ. હું તમારો ઈશ્વર થઈશ અને તમે મારા લોક થશો. ");
INSERT INTO guj2017_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","તમને મિસર દેશમાંથી બહાર લાવનાર હું તમારો ઈશ્વર યહોવાહ છું. તમારી ચાકરીની ઝૂંસરી તોડી નાખીને મેં તમને ઉન્નત મસ્તકે ચાલતા કર્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","પરંતુ જો તમે મારું કહ્યું સાંભળશો નહિ અને મારી આ સર્વ આજ્ઞાઓનું ઉલ્લંઘન કરશો, ");
INSERT INTO guj2017_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","તથા મારા વિધિઓને નકારવાનો નિર્ણય કરશો, મારા નિયમોની ઉપેક્ષા કરશો અને મારી પ્રત્યેક આજ્ઞાનું પાલન ન કરીને મારા કરારને તોડશો. ");
INSERT INTO guj2017_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","તો હું તમને આ પ્રમાણે સજા કરીશ, હું તમારા પર અત્યંત ત્રાસ વર્તાવીશ. હું તમારા પર એવા રોગો અને તાવ મોકલીશ કે જે તમને અંધ બનાવી દેશે અને તમારા હૃદય ઝૂર્યા કરશે. તમે તમારા બી વૃથા વાવશો. કારણ કે તે તમારો શત્રુ ખાશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","હું મારું મુખ તમારી વિરુદ્ધ કરીશ અને તમારા શત્રુઓના હાથે હું તમારો પરાજય કરાવીશ. જેઓ તમારો દ્રેષ કરે છે તેઓ તમારા પર રાજ કરશે. અને કોઈ તમારી પાછળ નહિ પડયું હોય છતાં તમે નાસતા ફરશો. ");
INSERT INTO guj2017_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","અને તેમ છતાં જો તમે મારું નહિ સાંભળો તો હું તમને તમારા પાપો બદલ સાત ગણી વધુ સજા કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","હું તમારા સામર્થ્યનો ગર્વ તોડીશ. હું તમારા પર આકાશને લોખંડના જેવું અને ભૂમિને પિત્તળના જેવી કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","તમારી સામર્થ્ય વ્યર્થ જશે. કેમ કે તમારી જમીનમાં કોઈ ફસલ થશે નહિ અને તમારાં વૃક્ષોને ફળ પણ આવશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","અને જો તમે મારી વિરુદ્ધ ચાલશો તથા મારું સાંભળશો નહિ તો હું તમારાં પાપોને કારણે સાતગણી વધુ આફતો ઉતારીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","પછી હું તમારી વિરુદ્ધ જંગલી જાનવરો છોડી મૂકીશ, જે તમારાં બાળકોને ફાડી ખાશે અને તમારાં પશુઓનો નાશ કરશે, પરિણામે તમારી સંખ્યા ઘટી જતા તમારા રસ્તાઓ ઉજ્જડ થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","આમ છતાં પણ જો તમે મારી શિક્ષા ગ્રહણ નહિ કરો અને મારી વિરુદ્ધ ચાલશો, ");
INSERT INTO guj2017_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","તો હું પણ તમારી વિરુદ્ધ ચાલીશ. હું પોતે તમને તમારાં પાપો માટે સાતગણી વધુ આકરી સજા કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","મારા કરાર ભંગનો બદલો લેવા હું તમારા પર તલવાર લાવીશ. તમે તમારા નગરોમાં એકઠાં થશો ત્યારે હું ત્યાં તમારી મધ્યે મરકી મોકલીશ; અને તમે શત્રુના સામર્થ્યથી હારી જશો. ");
INSERT INTO guj2017_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","જ્યારે હું તારા અનાજના પુરવઠાનો નાશ કરીશ ત્યારે દશ કુટુંબો માટે રોટલી શેકવા માટે ફક્ત એક ભઠ્ઠી પૂરતી થઈ પડશે; તેઓ તમને માપી તોલીને રોટલી વહેંચશે, અને તમે ખાશો પણ ધરાશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","જો તમે મારું નહિ સાંભળો અને સતત મારી વિરુદ્ધ ચાલશો, ");
INSERT INTO guj2017_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","તો પછી હું ક્રોધે ભરાઈને તમારી વિરુદ્ધ ચાલીશ. અને હું તમારાં પાપોને લીધે તમને સાતગણી શિક્ષા કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","તમે તમારા પુત્રનું તેમ જ તમારી પુત્રીઓનું માંસ ખાશો. ");
INSERT INTO guj2017_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","અને હું તમારા ઉચ્ચસ્થાનો તોડી નાખીશ તેમ જ તમારી વેદીઓને કાપી નાખીશ અને તમારી મૂર્તિઓના ભંગાર પર હું તમારા મૃતદેહ નાખીશ. હું તમને તિરસ્કૃત કરી નાખીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","હું તમારા નગરોને વેરાન ખંડેર બનાવી દઈશ. તમારા પવિત્ર સ્થાનોનો વિનાશ કરીશ અને તમારા સુવાસિત અર્પણોનો અસ્વીકાર કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","હું તમારા દેશને એવો ઉજ્જડ કરી નાખીશ કે તમારા દુશ્મનો જે તેમાં વસશે તેઓ પણ તમારી દુર્દશા જોઈને વિસ્મિત બની જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","હું તમને અનેક દેશોમાં વેરવિખેર કરી નાખીશ, હું તલવાર લઈને તમારી પાછળ પડીશ અને તમારો દેશ ઉજ્જડ તથા વેરાન થઈ જશે. તેમ જ તમારા શહેરો ખંડેર થઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","અને જયારે તમે શત્રુઓના દેશમાં રહેતા હશો તે વર્ષોમાં જમીન ઉજ્જડ પડી રહેશે અને તે તેનો વિશ્રામ ભોગવશે અને તે દેશ તેના વિશ્રામ વર્ષોનો આનંદ માણશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","જ્યારે તમે ત્યાં વસતા હતા ત્યારે દરેક સાતમે વર્ષે તમે આપ્યો નહોતો તે વિશ્રામ હવે તે પ્રાપ્ત કરશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","જે લોકો તમારામાંથી બચી જઈને શત્રુઓના દેશમાં દેશવટો ભોગવી રહ્યા હશે તેમને હું એવા ભયભીત કરીશ કે એક પાંદડુ પડવાનો અવાજ થતાં તેઓ જાણે મોત પાછળ પડયું હોય તેમ ભાગવા માંડશે અને કોઈ પાછળ પડયું ના હોવા છતાં તેઓ ઢળી પડશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","વળી કોઈ પાછળ પડયું ના હોવા છતાં જાણે તલવાર પાછળ આવતી હોય તેમ તેઓ એકબીજા પર પડાપડી કરશે. અને શત્રુઓનો સામનો કરવાની શક્તિ પણ તેઓમાં રહેશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","વિદેશી પ્રજાઓ વચ્ચે તમારો અંત આવશે અને તમારા શત્રુઓની ભૂમિ તમને ખાઈ જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","જેઓ શત્રુઓના દેશમાં બચી જશે તેઓ પોતાના અને પોતાના પિતૃઓનાં પાપોને કારણે ઝૂરી ઝૂરીને ક્ષય પામતા જશે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","મારી વિરુદ્ધ કરેલા પાપો તેઓએ કર્યા તેમાં તેઓનો અન્યાય અને તેઓના પિતૃઓના અન્યાય જો તેઓ કબૂલ કરશે અને એ પણ કબૂલ કરશે કે તેઓ મારી વિરુદ્ધ ચાલ્યા છે; ");
INSERT INTO guj2017_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","તેથી હું પણ તેઓની વિરુદ્ધ થયો છું અને તેઓને શત્રુઓના દેશમાં સોંપી દીધા. જો તેઓનું બેસુન્નત હૃદય નમ્ર થયું હશે ને જો તેઓ પોતાના પાપોની સજા કબૂલ કરશે તો, ");
INSERT INTO guj2017_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","હું યાકૂબ સાથેનો, ઇસહાક સાથેનો અને ઇબ્રાહિમ સાથેનો મારા કરારનું સ્મરણ કરીશ અને આ દેશનું પણ સ્મરણ કરીશ. ");
INSERT INTO guj2017_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","તેઓને દેશ છોડાવો પડશે; અને ભૂમિ જયાં સુધી ઉજ્જડ પડી રહેશે તેટલો સમય તે પોતાના વિશ્રામના વર્ષો માણશે, તેઓ પોતાના પાપોની શિક્ષા ભોગવશે કેમ કે તેઓએ મારા વિધિઓનો નકાર કર્યો છે અને મારા નિયમોથી કંટાળ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","તેમ છતાં, તેઓ તેઓના શત્રુઓના દેશમાં હશે ત્યારે પણ હું તેમનો સંપૂર્ણ નાશ નહિ કરું. તેમનો પૂરેપૂરો ત્યાગ પણ નહિ કરું અને મારો જે કરાર તેઓની સાથે છે તેને હું નહિ તોડું, કારણ કે હું યહોવાહ તેઓનો ઈશ્વર છું. ");
INSERT INTO guj2017_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","પણ તેઓના પિતૃઓને કે જેઓને વિદેશીઓની નજર આગળથી મિસર દેશમાંથી હું કાઢી લાવ્યો એ માટે કે હું યહોવાહ તેઓનો ઈશ્વર થાઉં. તેઓની આગળ કરેલા મારા કરારને હું તેઓને લીધે સ્મરણ કરીશ. હું યહોવાહ છું.” ");
INSERT INTO guj2017_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","જે નિયમો, વિધિઓ અને આજ્ઞાઓ પોતાની તથા ઇઝરાયલના લોકોની વચ્ચે યહોવાહે સિનાઈ પર્વત પર મૂસા મારફતે આપ્યા તે આ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","યહોવાહે મૂસાની સાથે વાત કરીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ઇઝરાયલના લોકોને કહે કે, ‘જો કોઈ માણસ યહોવાહની આગળ ખાસ માનતા લે તો તારા નક્કી કરેલા મૂલ્ય પ્રમાણે તે લોકો યહોવાહને સારુ માન્ય થશે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","તારું નક્કી કરેલું મૂલ્ય આ પ્રમાણે થાય; વીસથી તે સાઠ વર્ષ સુધીની ઉંમરના નરને માટે તારું નક્કી કરેલું મૂલ્ય, પવિત્રસ્થાનના શેકેલ પ્રમાણે પચાસ શેકેલ ચાંદી થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","તે જ ઉંમરની નારી માટે તેનું મૂલ્ય ત્રીસ શેકેલ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","પાંચથી વીસ વર્ષની ઉંમરના નરની કિંમત વીસ શેકેલ અને નારીની કિંમત દસ શેકેલ ઠરાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","એક મહિનાથી પાંચ વર્ષ સુધીના નરની કિંમત પાંચ શેકેલ ચાંદી અને નારીની કિંમત ત્રણ શેકેલ ચાંદી ઠરાવવું. ");
INSERT INTO guj2017_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","સાઠ વર્ષ અને તેની ઉપરની ઉંમરના નરની કિંમત પંદર શેકેલ અને નારીની કિંમત દસ શેકેલ ઠરાવવી. ");
INSERT INTO guj2017_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","પણ જો કોઈ વ્યક્તિ માનતા લે અને આ કિંમત ચૂકવી શકે તેમ ના હોય, તો તેણે તે વ્યક્તિને યાજક સમક્ષ રજૂ કરવી અને યાજકે તેની કિંમત માનતા લેનાર વ્યક્તિ ચૂકવી શકે તેટલી નક્કી કરવી. ");
INSERT INTO guj2017_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","જો કોઈની ઇચ્છા યહોવાહને પશુનું અર્પણ કરવાની હોય અને જો યહોવાહ તેને માન્ય કરે તો પછી એ પશુ સંપૂર્ણપણે તેનું જ રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","એ વ્યક્તિએ તેમાં ફેરબદલ કરવી નહિ. સારાને બદલે નરસું તથા નરસાને બદલે સારું બદલવું નહિ. તે પશુની બીજા પશુ સાથે અદલાબદલી કરવી નહિ. છતાં જો અદલાબદલી કરી હોય તો બન્ને પશુઓ પવિત્ર બની જાય અને તે યહોવાહના ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","પરંતુ માનતા લઈ અર્પણ કરવાનું પશુ જો અશુદ્ધ હશે તો યહોવાહ તેને માન્ય નહિ કરે. પછી તેણે તે પશુ યાજક પાસે લઈને જવું. ");
INSERT INTO guj2017_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","બજારની કિંમત પ્રમાણે યાજક તેની કિંમત નક્કી કરે, પછી પશુ સારું હોય કે ખરાબ યાજકે ઠરાવેલ કિંમત માન્ય રાખવી. ");
INSERT INTO guj2017_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","અને જો તે વ્યક્તિ તેને છોડાવવા ઇચ્છતો હોય તો તેણે તેની કિંમત કરતાં પાંચમો ભાગ વધુ ચૂકવવો. ");
INSERT INTO guj2017_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","જો કોઈ વ્યક્તિ પોતાનું ઘર યહોવાહને સારુ પવિત્ર થવાને માટે અર્પણ કરે, ત્યારે યાજક તેની જે કિંમત નક્કી કરે તે કાયમ રહે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","પણ જો અર્પણ કરનાર ઘરનો માલિક પોતાનું ઘર છોડાવવા ઇચ્છે તો તેણે કિંમત ઉપરાંત વધુ વીસ ટકા આપવા, જેથી મકાન પાછું તેની માલિકીનું થઈ જાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","જો કોઈ વ્યક્તિ પોતાની માલિકીની જમીનનો અમુક ભાગ યહોવાહને અર્પણ કરે તો તેની કિંમત તેને રોપવા માટે જરૂરી બીજની રકમ સાથે રાખવામાં આવશે, જેમ કે વીસ મણ જવની જરૂર પડે તો તેનું મૂલ્ય પચાસ શેકેલ ચાંદી થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","જો કોઈ માણસ જ્યુબિલી વર્ષમાં પોતાનું ખેતર સ્વેચ્છાએ અર્પણ કરે તો તારા ઠરાવ્યા પ્રમાણે તેની કિંમત થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","પણ જો તે જ્યુબિલી વર્ષ પછી અર્પણ કરે તો યાજકે પછીના જ્યુબિલી વર્ષના જેટલા વર્ષ બાકી હોય તેના પ્રમાણમાં રોકડ કિંમત નક્કી કરવી અને તે આકડાં મુજબ કિંમત ઠરાવવી. ");
INSERT INTO guj2017_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","પરંતુ જો અર્પણ કરનાર ખેતર છોડાવવા માંગતો હોય તો તેણે ઠરાવેલી કિંમત કરતાં વીસ ટકા વધુ આપવા એટલે તે ખેતરની માલિકી ફરીથી તેની થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","પરંતુ જો તે જમીન નહિ છોડાવતાં બીજા કોઈને વેચી દે તો તેને તે કદી પાછું મળે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","પણ તેના બદલે જ્યારે જ્યુબિલી વર્ષમાં તે ખેતર છૂટે ત્યારે યહોવાહને સારુ અર્પિત ખેતર તરીકે તે યાજકોનું થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","જો કોઈ વ્યક્તિ પોતે ખરીદેલું ખેતર યહોવાહને અર્પણ કરે અને તે તેના કુટુંબની મિલકતનો ભાગ નથી, ");
INSERT INTO guj2017_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","તો પછી યાજકે બીજા જ્યુબિલી વર્ષને જેટલા વર્ષ બાકી હોય તેને આધારે તેની કિંમત ઠરાવવી અને તે વ્યક્તિએ નક્કી કરેલી કિંમત યહોવાહને તે જ દિવસે એક પવિત્ર વસ્તુ તરીકે અર્પણ કરવી. ");
INSERT INTO guj2017_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","જ્યુબિલી વર્ષે એ ખેતર તેના મૂળ માલિક, જેની પાસેથી તે ખરીદયું હોય એટલે જેના વતનનું તે હતું તેને પાછું મળે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","જે કિંમત તું ઠરાવે તે બધું પવિત્રસ્થાનના શેકેલ પ્રમાણે ઠરાવવું. વીસ ગેરાહનો એક શેકેલ થાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","કોઈ પણ વ્યક્તિએ બળદ અથવા ઘેટાનાં પ્રથમજનિતને ઐચ્છિકાર્પણ તરીકે યહોવાહને ચઢાવવું નહિ, કારણ, એ તો યહોવાહનું જ છે; પછી ભલે તે કોઈ પણ બળદ કે ઘેટું હોય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","જો અશુદ્ધ પશુના પ્રથમજનિતને અર્પણ તરીકે લાવવામાં આવે, તો યાજક તેની કિંમત ઠરાવે તે ઉપરાંત વીસ ટકા વધુ તે માલિક આપે. જો તેનો માલિક તેને છોડાવવા માંગતો ન હોય તો યાજક નિર્ધારિત કરેલી કિંમતે તે પશુને બીજા કોઈને વેચી શકે છે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","પરંતુ યહોવાહને કરેલું કોઈ પણ અર્પણ પછી તે માણસ હોય, પશુ હોય અથવા વારસામાં મળેલું ખેતર હોય, તો તેને વેચી અથવા છોડાવી શકાય નહિ. કારણ તે યહોવાહને સારુ પરમપવિત્ર અર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","જેનું અર્પણ માણસોમાંથી થયેલું હોય તેને પાછો ખરીદી ન શકાય. તેને નિશ્ચે મારી નાખવો. ");
INSERT INTO guj2017_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","જમીનની ઊપજનો ઠરાવેલો દશમો ભાગ પછી તે ખેતરના અનાજનો હોય કે વૃક્ષનાં ફળોનો હોય તે યહોવાહનો ગણાય, તે યહોવાહને સારુ પવિત્ર છે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","જો કોઈ વ્યક્તિ આ અનાજ કે ફળનો દશમો ભાગ પાછો ખરીદવા ઇચ્છે તો તેની કિંમતમાં વીસ ટકા ઉમેરીને ચૂકવે. ");
INSERT INTO guj2017_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","જાનવરો તથા ઘેટાંબકરાંનો દશાંશ એટલે જે કોઈ લાકડી નીચે આવી જાય છે તેનો દશાંશ યહોવાહને સારુ પવિત્ર ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","પસંદ કરેલુ પશુ સારું છે કે ખરાબ તેની તપાસ તેણે ન કરવી. તેને એ પશુ બીજા પશુ સાથે અદલાબદલી ન કરવી. અને તેને જો બીજા પશુથી બદલવા માંગે, તો બન્ને પશુઓ યહોવાહના થાય. તે પશુને પાછું ખરીદી શકાય નહિ.’” ");
INSERT INTO guj2017_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ઇઝરાયલી લોકો માટે જે આજ્ઞાઓ મૂસાને યહોવાહે સિનાઈ પર્વત પર આપી હતી તે આ છે.");
INSERT INTO guj2017_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","સિનાઈના અરણ્યમાં મુલાકાતમંડપમાં યહોવાહે મૂસાની સાથે વાત કરી. ઇઝરાયલીઓ મિસર દેશમાંથી રવાના થયા ત્યાર પછી બીજા વર્ષના બીજા મહિનાના પ્રથમ દિવસે આ બન્યું. યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ઇઝરાયલપુત્રોના સમગ્ર કુળ પ્રમાણે તથા તેમના પિતાઓનાં કુટુંબ મુજબ તથા તેઓનાં નામ મુજબ દરેક પુરુષની ગણતરી કર. ");
INSERT INTO guj2017_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","જેઓ વીસ વર્ષ અને તેનાથી મોટી ઉંમરના હોય અને ઇઝરાયલીપુત્રોમાંના જેટલા લડાઈમાં જવાને માટે લાયક હોય તેમની ગણતરી તેમનાં સૈન્ય મુજબ તું તથા હારુન કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","અને દરેક કુળમાંનો એક પુરુષ જે તેના કુળનો મુખ્ય હોય, તે કુળના આગેવાન તરીકે તમારી સાથે રહે. તેઓએ દરેકે પોતાના કુળના પુરુષોને લડાઈમાં આગેવાની આપવી. ");
INSERT INTO guj2017_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","તમારી સાથે લડાઈ કરનારા આગેવાનોનાં નામ નીચે મુજબ છે; રુબેનના કુળમાંથી શદેઉરનો દીકરો અલીસૂર. ");
INSERT INTO guj2017_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","શિમયોનના કુળમાંથી સૂરીશાદ્દાયનો દીકરો શલુમિયેલ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","યહૂદાના કુળમાંથી આમ્મીનાદાબનો દીકરો નાહશોન. ");
INSERT INTO guj2017_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ઇસ્સાખારના કુળમાંથી સુઆરનો દીકરો નથાનએલ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ઝબુલોનના કુળમાંથી હેલોનનો દીકરો અલિયાબ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","યૂસફના દીકરાઓમાં એફ્રાઇમના કુળમાંથી આમ્મીહૂદનો દીકરો અલિશામા. અને મનાશ્શાના કુળમાંથી પદાહસૂરનો દીકરો ગમાલ્યેલ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","બિન્યામીનના કુળમાંથી ગિદોનીનો દીકરો અબીદાન. ");
INSERT INTO guj2017_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","દાનનાં કુળમાંથી આમ્મીશાદ્દાયનો દીકરો અહીએઝેર. ");
INSERT INTO guj2017_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","આશેરના કુળમાંથી ઓક્રાનનો દીકરો પાગિયેલ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ગાદના કુળમાંથી દુએલનો દીકરો એલિયાસાફ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","નફતાલીના કુળમાંથી એનાનનો દીકરો અહીરા.” ");
INSERT INTO guj2017_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","જે લોકોને પસંદ કરાયા તેઓ એ પુરુષો હતા. તેઓ તેમના પૂર્વજોના કુટુંબના અધિપતિઓ હતા. તેઓ ઇઝરાયલ કુળના આગેવાનો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","જે પુરુષોનાં નામ અહીં આપેલાં છે, તેઓને મૂસાએ અને હારુને લીધા. ");
INSERT INTO guj2017_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","અને બીજા મહિનાના પ્રથમ દિવસે તેમણે સમગ્ર ઇઝરાયલના પુરુષોને એકત્ર કરી અને તેઓએ તેઓનાં કુટુંબો પ્રમાણે અને તેઓના પિતૃઓનાં કુળ અનુસાર વીસ વર્ષ કે તેથી વધારે વર્ષની ઉંમરના સર્વ પુરુષોનાં નામની વંશાવળીની યાદી કરી સંભળાવી. ");
INSERT INTO guj2017_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તે મુજબ મૂસાએ સિનાઈના અરણ્યમાં તેઓની ગણતરી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","અને ઇઝરાયલના જયેષ્ઠ પુત્ર રુબેનના વંશમાં, તેઓનાં કુટુંબો તથા તેઓના પિતાનાં ઘર મુજબ તેઓના નામની સંખ્યા પ્રમાણે માથાદીઠ વીસ તથા તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લશ્કરમાં જોડાવા શક્તિમાન હતા, ");
INSERT INTO guj2017_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","તેઓની ગણતરી રુબેનના કુળમાં છેંતાળીસ હજાર પાંચસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","શિમયોનના વંશમાં તેઓનાં કુટુંબો તથા તેઓના પિતાનાં ઘર પ્રમાણે, તેઓની ગણતરી થઈ. અને વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જોડાવા શક્તિમાન હતા, તેઓના નામની સંખ્યા મુજબ માથાદીઠ ગણતરી થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","તેઓની ગણતરી શિમયોનના કુળમાં ઓગણસાઠ હજાર ત્રણસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ગાદના વંશમાં તેઓના કુટુંબો તથા તેઓના પિતાના ઘર મુજબ, વીસ તથા તેથી વધારે વર્ષની ઉંમરના પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓના નામની સંખ્યા મુજબ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","તેઓની ગણતરી, ગાદના કુળમાં, પિસ્તાળીસ હજાર છસો પચાસ પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","યહૂદાના વંશમાં તથા તેઓના પિતાનાં ઘર મુજબ, વીસ તથા તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓના નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","તેઓની ગણતરી યહૂદાના કુળમાં ચુંમોતેર હજાર છસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ઇસ્સાખારનાં વંશમાં તેઓના કુટુંબો તથા તેઓના પિતાનાં ઘર મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓના નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","તેઓની ગણતરી ઇસ્સાખારના કુળમાં ચોપન હજાર ચારસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ઝબુલોનના વંશમાં તેઓનાં કુટુંબો તથા તેઓના પિતાનાં ઘર મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓનાં નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","તેઓની ગણતરી ઝબુલોનના કુળમાં સતાવન હજાર ચારસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","યૂસફના દીકરાઓના એટલે એફ્રાઇમના વંશમાં, તેઓના કુટુંબો તથા તેઓનાં પિતાનાં ઘર મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા. તેઓનાં નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","તેઓની ગણતરી એફ્રાઇમના કુળમાં ચાળીસ હજાર પાંચસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","મનાશ્શાનાં વંશમાં તેઓના કુટુંબો તથા તેઓના પિતાનાં ઘર મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓના નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","તેઓની ગણતરી મનાશ્શાના કુળમાં બત્રીસ હજાર બસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","બિન્યામીનના વંશમાં તેઓનાં કુટુંબો તથા તેઓના પિતાના ઘર મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓનાં નામની સંખ્યા મુજબ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","તેઓની ગણતરી બિન્યામીનના કુળમાં પાંત્રીસ હજાર ચારસો પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","દાનના વંશમાં, તેઓનાં કુટુંબો તથા તેઓના પિતાના ઘરની સંખ્યા મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓના નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","દાનના કુળની ગણતરી બાસઠ હજાર સાતસોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","આશેરના વંશમાં, તેઓના કુટુંબો તથા તેઓનાં પિતાના ઘર મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓના નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","તેઓની ગણતરી આશેરના કુળમાં, એક્તાળીસ હજાર પાંચસોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","નફતાલીનાં વંશમાં, તેઓનાં કુટુંબો તથા તેઓના પિતાના ઘર મુજબ, વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા, તેઓનાં નામની સંખ્યા મુજબ ");
INSERT INTO guj2017_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","તેઓની ગણતરી, નફતાલીના કુળમાં, ત્રેપન હજાર ચારસોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","જેઓની ગણતરી મૂસા, હારુન તથા ઇઝરાયલીઓના અધિપતિ બાર પુરુષોએ કરી તેઓ એ છે. તેઓ ઇઝરાયલના બાર કુળના અધિપતિ હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","તેથી ઇઝરાયલીઓમાંના જે સર્વની ગણતરી તેઓનાં પિતાના ઘર મુજબ થઈ એટલે વીસ કે તેથી વધારે વર્ષની ઉંમરના જેટલા પુરુષો લડાઈમાં જવાને શક્તિમાન હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","તેઓની ગણતરી છ લાખ ત્રણ હજાર પાંચસો પચાસની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","પણ તેઓ મધ્યે લેવીઓની તેઓના પિતાનાં કુળ મુજબ ગણતરી કરવામાં આવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","કેમ કે યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","‘તારે લેવીના કુળની ગણતરી કરવી નહિ અને ઇઝરાયલીઓમાં તેઓની કુલ સંખ્યા તારે નક્કી કરવી નહિ.’” ");
INSERT INTO guj2017_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","તેના બદલામાં તું લેવીઓને કરારમંડપ પર તથા તેના બધા સામાન પર તથા તેને લગતી સઘળી બાબતો પર ઠરાવ; તેઓ મંડપને તથા તેના સર્વ સરસામાનને ઊંચકી લે; અને તેઓ તેની સંભાળ રાખે અને મંડપની ચારે બાજુ છાવણી કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","જ્યારે મંડપને બીજી જગ્યાએ લઈ જવાનો સમય થાય, ત્યારે લેવીઓએ તેને પાડવાનો અને ફરીથી ઊભો કરવાનો થાય, ત્યારે લેવીઓ તેને ઊભો કરે; અને એ કુળ સિવાયનો કોઈ અજાણ્યા પુરુષ નજીક આવે તો તે માર્યો જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","અને ઇઝરાયલપુત્રો, દરેક પુરુષ પોતપોતાની છાવણી પાસે અને દરેક પુરુષ પોતપોતાની ધજા પાસે પોતાનાં સૈન્ય પ્રમાણે પોતપોતાનો તંબુ ઊભો કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","જો કે, લેવીઓએ પવિત્રમંડપની આસપાસ જ પોતાની છાવણી નાખવી કે જેથી ઇઝરાયલના લોકો પર કંઈ કોપ ન આવે; અને લેવીઓ સાક્ષ્યોના મંડપની સંભાળ રાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ઇઝરાયલના લોકોએ એ પ્રમાણે કર્યું; યહોવાહે મૂસાની મારફતે જે સર્વ આજ્ઞા આપી હતી, તે મુજબ તેઓએ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","યહોવાહ ફરીથી મૂસા તથા હારુનને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ઇઝરાયલપુત્રોમાંનો દરેક પુરુષ પોતાના સૈન્યના જૂથનાં નિશાન સાથે પોતાની અલગ ધજાની પાસે છાવણી કરે. મુલાકાતમંડપ સામે બાજુ તેઓ છાવણી કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","યહૂદાની છાવણીની ધજાવાળા પોતાનાં સૈન્યો મુજબ પૂર્વ તરફ છાવણી કરે, અને આમ્મીનાદાબનો દીકરો નાહશોન યહૂદાના દીકરાઓનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","યહૂદાના સૈન્યમાં ચુંમોતેર હજાર છસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","તેના પછી ઇસ્સાખારનું કુળ છાવણી કરે; સુઆરનો દીકરો નથાનએલ ઇસ્સાખારના દીકરાઓનો અધિપતિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","તેના સૈન્યમાં એટલે તેમાંના જેઓની ગણતરી થઈ છે તેઓ ચોપન હજાર ચારસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ઝબુલોનનું કુળ ઇસ્સાખારની બાજુમાં છાવણી કરે. હેલોનનો દીકરો અલિયાબ તે ઝબુલોનના દીકરાઓનો અધિપતિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","તેના સૈન્યમાં તેઓમાંના જેઓની ગણતરી થઈ છે તેઓ સતાવન હજાર પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","યહૂદાની છાવણીમાં જે સર્વની ગણતરી થઈ તેઓ, પોતાના સૈન્યો મુજબ એક લાખ છયાસી હજાર ચારસો પુરુષો હતા. તેઓ છાવણીમાંથી પ્રથમ ચાલી નીકળે. ");
INSERT INTO guj2017_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","રુબેનની છાવણીની ધજા પોતાનાં સૈન્યો મુજબ દક્ષિણની બાજુએ રહે. અને શદેઉરનો દીકરો અલીસૂર તે રુબેનના સૈન્યની આગેવાની કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","રુબેનના સૈન્યમાં છેંતાળીસ હજાર પાંચસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","તેની પાસે શિમયોનનું કુળ છાવણી કરે અને સૂરીશાદ્દાયનો દીકરો શલુમિયેલ તે શિમયોનના સૈન્યનો અધિપતિ થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","શિમયોનના સૈન્યમાં ઓગણસાઠ હજાર ત્રણસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","તે પછી ગાદનું કુળ. રેઉએલનો દીકરો એલિયાસાફ તે ગાદના સૈન્યનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ગાદના સૈન્યમાં પિસ્તાળીસ હજાર છસો પચાસ પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","રુબેનની છાવણી પાસે બધા સૈન્ય મળીને કુલ એક લાખ એકાવન હજાર ચારસો પચાસ પુરુષો છાવણી કરે. તેઓ છાવણીમાંથી બીજે ક્રમે કૂચ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","એ પછી, છાવણીઓની વચ્ચેની લેવીઓની છાવણી સાથે મુલાકાતમંડપ બહાર આવે. જેમ તેઓ છાવણીમાં રહે છે તેમ તેઓ પોતપોતાની જગ્યાએ પોતાની ધજા પાસે રહીને બહાર ચાલે. ");
INSERT INTO guj2017_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","એફ્રાઇમની છાવણીની ધજા પોતાનાં સૈન્ય મુજબ પશ્ચિમ બાજુએ રહે. અને આમ્મીહૂદનો દીકરો અલિશામા તે એફ્રાઇમના દીકરાઓનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","એફ્રાઇમના સૈન્યમાં ચાળીસ હજાર પાંચસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","તેની પાસે મનાશ્શાનું કુળ રહે. અને પદાહસૂરનો પુત્ર ગમાલ્યેલ તે મનાશ્શાના દીકરાઓનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","મનાશ્શાના સૈન્યમાં બત્રીસ હજાર બસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","તે પછી બિન્યામીનનું કુળ; અને ગિદિયોનનો પુત્ર અબીદાન તે બિન્યામીનના દીકરાઓનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","મનાશ્શાના સૈન્યમાં પાંત્રીસ હજાર ચારસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","એફ્રાઇમની છાવણીમાં જે બધાની ગણતરી થઈ તેઓ, પોતાનાં સૈન્યો મુજબ, એક લાખ આઠ હજાર એકસો હતા. તેઓ ત્રીજા ક્રમે કૂચ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","દાનની છાવણીની ધજા પોતાનાં સૈન્ય મુજબ ઉત્તર બાજુએ રહે. અને આમ્મીશાદ્દાયનો દીકરો અહીએઝેર તે દાનના દીકરાઓનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","દાનના સૈન્યમાં બાસઠ હજાર સાતસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","તેની પાસે આશેરનું કુળ છાવણી કરે. અને ઓક્રાનનો દીકરો પાગિયેલ તેનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","આશેરના સૈન્યમાં એકતાળીસ હજાર પાંચસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","તે પછી નફતાલીનું કુળ. અને એનાનનો દીકરો અહીરા તે નફતાલીના દીકરાઓનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","નફતાલીના સૈન્યમાં ત્રેપન હજાર ચારસો પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","દાનની છાવણીમાં જે સર્વની ગણતરી થઈ તેઓ એક લાખ સતાવન હજાર છસો હતા. તેઓ પોતાની ધજા સાથે પાછળ ચાલી નીકળે. ");
INSERT INTO guj2017_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","મૂસા અને હારુને પોતાનાં પૂર્વજોનાં કુળો મુજબ ગણતરી કરી તેઓમાં ઇઝરાયલપુત્રોના સૈન્યમાં છ લાખ ત્રણ હજાર પાંચસો પચાસ પુરુષો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તે મુજબ મૂસા અને હારુને ઇઝરાયલપુત્રોમાંના લેવીઓની ગણતરી કરી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","યહોવાહે મૂસાને જે સર્વ આજ્ઞાઓ આપી હતી તે મુજબ ઇઝરાયલના લોકોએ કર્યું. તેઓએ પોતપોતાની ધજાઓ પાસે છાવણી કરી. અને તે જ પ્રમાણે તેઓ પ્રત્યેક પોતપોતાના કુટુંબ સાથે પોતપોતાનાં ઘર પ્રમાણે કૂચ આરંભી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","સિનાઈ પર્વત પર યહોવાહ મૂસા સાથે બોલ્યા ત્યારે હારુન અને મૂસાની વંશાવળી આ પ્રમાણે હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","હારુનના દીકરાઓનાં નામ આ મુજબ હતાં; જ્યેષ્ઠ દીકરાનું નામ નાદાબ, તથા અબીહૂ, એલાઝાર તથા ઈથામાર. ");
INSERT INTO guj2017_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","હારુનના દીકરાઓ જેઓને યાજક તરીકે અભિષિક્ત કરવામાં આવ્યા અને તેઓને યાજકની પદવીમાં સેવા કરવાને જુદા કરવામાં આવ્યા તેઓનાં નામ એ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","પરંતુ નાદાબ અને અબીહૂ યહોવાહની આગળ સિનાઈના અરણ્યમાં પારકો અગ્નિ ચઢાવવાથી યહોવાહની આગળ માર્યા ગયા. તેથી તેઓ સિનાઈના રણમાં જ મૃત્યુ પામ્યા. તેઓ નિ:સંતાન હતા. અને એલાઝાર અને ઈથામાર પોતાના પિતા હારુનના જીવનકાળ દરમ્યાન યાજકપદમાં સેવાઓ બજાવતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","યહોવાહ મૂસા સાથે બોલ્યા. તેમણે કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","લેવીના કુળને પાસે લાવ અને તેઓને યાજક હારુનની આગળ ઊભા કર કે, તેઓ તેની સેવા કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","તેઓએ તેની અને મુલાકાતમંડપની આખી જમાતની સંભાળ રાખે અને મંડપને લગતી ફરજો બજાવવાની છે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","અને તેઓ મુલાકાતમંડપની, સરસામાનની અને ઇઝરાયલપુત્રોની સંભાળ રાખતાં મંડપને લગતી ફરજો બજાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","અને તું હારુનના તથા તેના દીકરાઓના હવાલામાં લેવીઓને સોંપી દે કારણ કે, ઇઝરાયલના લોકો વતી તેઓ તેને સેવા માટે અપાયેલા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","અને તારે હારુનને અને તેના દીકરાઓને યાજકની ફરજો બજાવવા નિયુક્ત કરવા. જો કોઈ પરદેશી એ ફરજ બજાવવા જાય તો તે માર્યો જાય.” ");
INSERT INTO guj2017_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","પછી યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","ઇઝરાયલપુત્રોના સર્વ પ્રથમજનિત એટલે ગર્ભ ઊઘાડનારને બદલે, તેઓમાંથી મેં લેવીઓનો સ્વીકાર કર્યો છે. અને લેવીઓ મારા થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","કેમ કે, સર્વ પ્રથમજનિત મારા જ છે; જ્યારે મેં મિસરના બધા પ્રથમજનિતને મારી નાખ્યા હતા તે દિવસે મેં ઇઝરાયલપુત્રોના સર્વ પ્રથમજનિત પુરુષો અને જાનવરોને મારે સારુ પવિત્ર કર્યા, તેઓ મારા જ થશે. હું યહોવાહ છું.” ");
INSERT INTO guj2017_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","સિનાઈના અરણ્યમાં યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","લેવીના દીકરાઓની, તેઓના પિતાનાં કુટુંબો પ્રમાણે ગણતરી કર. એક મહિનો અને તેથી વધારે ઉંમરના સર્વ પુરુષોની ગણતરી કર.” ");
INSERT INTO guj2017_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","એટલે યહોવાહે મૂસાને આજ્ઞા આપી હતી તે મુજબ મૂસાએ તેઓની ગણતરી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","લેવીના દીકરાઓનાં નામ આ મુજબ છે; ગેર્શોન, કહાથ, અને મરારી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ગેર્શોનના દીકરાઓના નામ તેઓના કુળ મુજબ, લિબ્ની તથા શિમઈ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","કહાથના દીકરા, તેમના કુટુંબો મુજબ; આમ્રામ તથા યિસ્હાર, હેબ્રોન તથા ઉઝિયેલ. ");
INSERT INTO guj2017_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","મરારીના દીકરા તેઓના કુટુંબો મુજબ, માહલી તથા મુશી છે. લેવીઓનાં કુટુંબો, તેઓનાં પિતાનાં ઘર મુજબ એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ગેર્શોનથી લિબ્નીઓનું કુટુંબ અને શિમઈઓનું કુટુંબ થયા. એ ગેર્શોનીઓના કુટુંબો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","તેઓમાંના જેઓની ગણતરી થઈ એટલે તેઓમાંના એક મહિનાના અને તેથી વધારે ઉંમરના સઘળા પુરુષોની ગણતરી થઈ, તેઓની સંખ્યા સાત હજાર પાંચસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","મંડપની પાછળ પશ્ચિમ દિશામાં ગેર્શોનીઓનાં કુટુંબો છાવણી કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","અને લાએલનો દીકરો એલિયાસાફ તે ગેર્શોનીઓના પિતાનાં ઘરનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","અને ગેર્શોનનું કુટુંબ મુલાકાતમંડપના પડદા એની અંદરનું આવરણ, બહારનું આવરણ, મુલાકાતમંડપના દ્વારના પડદાની સંભાળ રાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","તેઓ આંગણાના પડદા અને મંડપની પાસે અને વેદીની આસપાસના આંગણાના દ્વારનાં પડદાઓની સંભાળ રાખે. તેના બધા કામ માટે તેની દોરીઓ એ બધાની સંભાળ ગેર્શોનના દીકરાઓ રાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","અને કહાથથી આમ્રામીઓનું કુટુંબ, ઈસહારીઓનું કુટુંબ, હેબ્રોનીઓનું કુટુંબ અને ઉઝિયેલીઓનું કુટુંબ થયાં; કહાથીઓનાં કુટુંબો એ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","એક મહિનાના અને તેથી વધારે ઉંમરના પુરુષોની સંખ્યા આઠ હજાર છસો પુરુષોની હતી અને તેઓ પવિત્રસ્થાનની સંભાળ રાખનારા હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","કહાથના દીકરાઓનાં કુટુંબો મંડપની પાસે દક્ષિણ બાજુએ છાવણી કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ઉઝિયેલનો દીકરો અલિસાફાન તે કહાથીઓનાં કુટુંબોના પિતાના ઘરનો આગેવાન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","તે લોકોએ પવિત્ર કોશની, મેજની, દીપવૃક્ષ અને વેદીઓની, પવિત્રસ્થાનની સેવા કરવાની સામગ્રી તથા ગર્ભગૃહ આગળના પડદાની તથા એ સર્વ કામકાજની સંભાળ રાખવી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","અને હારુન યાજકનો દીકરો એલાઝાર લેવીઓના અધિપતિઓનો આગેવાન થાય. પવિત્રસ્થાનની સંભાળ રાખનારાઓની તે દેખરેખ રાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","મરારીથી માહલીઓનું કુટુંબ તથા મુશીઓનું કુટુંબો થયાં; મરારીનાં કુટુંબો એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","અને તેઓમાંના એક મહિના અને તેથી વધારે ઉંમરના પુરુષોની ગણતરી થઈ તેઓની સંખ્યા છ હજાર બસો પુરુષોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","અને અબિહાઈલનો દીકરો સૂરીએલ તે મરારીનાં કુટુંબોના પિતાના ઘરનો આગેવાન હતો. તેઓ ઉત્તર બાજુએ મંડપની પાસે છાવણી કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","અને મંડપનાં પાટિયાં, તેની ભૂંગળો, સ્તંભો, કૂંભીઓ તથા તેનાં સર્વ ઓજારો તથા તેને લગતાં સર્વ કામ ");
INSERT INTO guj2017_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","તદુપરાંત આંગણાની આસપાસના સ્તંભો, કૂંભીઓ, ખીલીઓ અને દોરીઓને લગતાં સર્વ કામની સંભાળ મરારીના દીકરાઓ રાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","મૂસા, હારુન અને તેના દીકરા મંડપની સામે પૂર્વ દિશામાં, મુલાકાતમંડપની સામે પૂર્વ બાજુએ છાવણી કરે અને તેઓ પવિત્રસ્થાનની સંભાળ રાખે, એટલે ઇઝરાયલીઓ માટે તેની સંભાળ રાખે. અને જો કોઈ પરદેશી પાસે આવે તો તે માર્યો જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","લેવીઓમાંના જે સર્વની ગણતરી થઈ, જેઓને મૂસાએ અને હારુને યહોવાહની આજ્ઞા અનુસાર ગણ્યા તેઓ, એટલે એક મહિનાના અને તેની ઉપરની ઉંમરના લેવી પુરુષો પોતાના કુટુંબ મુજબ બાવીસ હજાર હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","યહોવાહે મૂસાને કહ્યું, “એક મહિનાથી ઉપરની ઉંમરના બધા પ્રથમજનિત ઇઝરાયલી પુરુષોની ગણતરી કર અને તેમનાં નામોની સંખ્યા ગણ. ");
INSERT INTO guj2017_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","અને ઇઝરાયલના સર્વ પ્રથમજનિત પુરુષોને બદલે તું મારે માટે લેવીઓને લે. હું યહોવાહ છું, અને ઇઝરાયલીઓના જાનવરો મધ્યે સર્વ પ્રથમજનિતને બદલામાં લેવીઓનાં જાનવરો લે.” ");
INSERT INTO guj2017_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","અને જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તે મુજબ તેણે સર્વ ઇઝરાયલીઓના પ્રથમજનિતની ગણતરી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","અને સર્વ પ્રથમજનિત પુરુષોની ગણતરી કરી, એક મહિનાથી ઉપરના નામોની સંખ્યા પ્રમાણે ગણતાં બાવીસ હજાર બસો તોંતેરની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ત્યાર પછી, યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","ઇઝરાયલ પ્રજામાં સર્વ પ્રથમજનિતના બદલામાં લેવીઓને લે. તેઓનાં જાનવરોને બદલે લેવીઓનાં જાનવરો લે. અને લેવીઓ મારા થશે, હું યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","અને ઇઝરાયલમાં લેવીઓ ઉપરાંત, જે બસો તોંતેર પ્રથમજનિતને ખંડી લેવાના છે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","તે દરેકને વાસ્તે, માથાદીઠ પાંચ શેકેલ લે. પવિત્રસ્થાનના શેકેલ એટલે વીસ ગેરાહના શેકેલ મુજબ તું લે. ");
INSERT INTO guj2017_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","અને તે ઉપરાંત નાની સંખ્યાની ખંડણીનાં જે નાણાં આવે તે તું હારુન તથા તેના દીકરાઓને આપ. ");
INSERT INTO guj2017_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","જેઓ લેવીઓને બદલે ખરીદી લેવાયા હતા, તેઓ ઉપરાંત મુક્તિ મૂલ્યનાં ઓછા નાણાં મૂસાએ તેઓની પાસેથી લીધાં; ");
INSERT INTO guj2017_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ઇઝરાયલના પ્રથમજનિત પાસેથી મૂસાએ તે નાણાં લીધાં; એટલે પવિત્રસ્થાનના શેકેલ મુજબ એક હજાર ત્રણસો પાંસઠ શેકેલ. ");
INSERT INTO guj2017_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","અને મૂસાએ યહોવાહના કહ્યા મુજબ તથા યહોવાહે તેને આજ્ઞા કરી હતી તે મુજબ ખંડણીનાં નાણાં હારુનને અને તેના દીકરાઓને આપ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","યહોવાહે મૂસા અને હારુનને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","લેવીના દીકરાઓમાંથી કહાથના દીકરાઓની ગણતરી તેઓના કુટુંબો મુજબ તથા તેઓના પિતાઓના ઘર મુજબ કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ત્રીસથી પચાસ વર્ષની ઉંમરના બધા પુરુષો મુલાકાતમંડપનું કામ કરવા માટે સેવકપદમાં દાખલ થાય છે. તે સર્વની ગણતરી કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","મુલાકાતમંડપમાં પરમપવિત્ર વસ્તુઓના સંબંધમાં કહાથના દીકરાઓનું કામ આ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","જ્યારે છાવણીનો મુકામ ઉપાડવાનો સમય આવે ત્યારે હારુન અને તેના દીકરાઓએ અંદર જઈને પવિત્ર કરારકોશ આગળનો પડદો ઉતારી લઈને તેનાથી સાક્ષ્યકોશને ઢાંકી દેવો. ");
INSERT INTO guj2017_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","તે પર તેઓ સમુદ્ર ગાયના ચામડાનું આવરણ કરે અને તેને નીલ રંગનાં વસ્ત્રોથી ઢાંકે અને પવિત્રકોશને ઉપાડવાના દાંડા તેની કડીઓમાં નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","પછી તેઓએ અર્પેલી રોટલીની મેજ પર નીલ રંગનું વસ્ત્ર પાથરી દેવું, અને તેના પર થાળીઓ, ચમચા, તર્પણને માટે વાટકા મૂકવા; નિત્યની રોટલી તેના પર રહે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","તેના પર કિરમજી રંગનું વસ્ત્ર પાથરવું. અને સીલના ચામડાના આવરણથી તેને ઢાંકી દઈને તેને ઊચકવા માટેના દાંડા તેમાં નાખવા. ");
INSERT INTO guj2017_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","અને તેઓએ નીલ રંગનું વસ્ત્ર લઈને તેના વડે દીપવૃક્ષ, દીવાઓ, ચીપિયા, તાસકો અને દીવામાં વપરાતા તેલપાત્રોને ઢાંકે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","તે પછી આ સર્વ સામગ્રી સીલનાં ચામડાંનાં આવરણમાં નાખીને પાટિયા પર મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","પછી તેઓએ સોનાની વેદી નીલ રંગના વસ્ત્રોથી ઢાંકવી અને સીલના ચામડાના આવરણથી તેને ઢાંકે દઈને તેને ઊચકવાના દાંડાં તેમાં નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","પછી તેઓ સેવાની સર્વ સામગ્રી કે જે વડે તેઓ પવિત્રસ્થાનમાં સેવા કરે છે તે લે અને નીલ રંગનાં વસ્ત્રોમાં તે મૂકે. અને સીલનાં ચામડાંનું આવરણ કરીને ભૂંગળ તે પર મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","અને તેઓએ વેદી પરથી રાખ કાઢી નાખવી અને તેના પર જાંબુડિયા રંગનું વસ્ત્ર ઢાંકવું. ");
INSERT INTO guj2017_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","અને તેના પર તેઓ તેને માટે વપરાતી સર્વ સામગ્રી એટલે સગડીઓ, ત્રિપાંખિયાં તથા પાવડા, તપેલીઓ એટલે વેદીનાં સર્વ પાત્રો મૂકે; અને તેના પર તેઓ સીલ ચામડાનું આવરણ મૂકે. અને તેના ઉપાડવાના દાંડા તેમાં નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","હારુન અને તેના દીકરાઓ જ્યારે છાવણી ઉપાડવાની હોય તે સમયે પવિત્રસ્થાનને અને પવિત્રસ્થાનની સાધનસામગ્રીને ઢાંકે અને તે પછી કહાથના દીકરાઓ તે ઊંચકવા માટે આવે; પરંતુ તેઓએ કોઈ પણ પવિત્ર વસ્તુઓને સ્પર્શ કરવો નહિ, રખેને તેઓ મૃત્યુ પામે. મુલાકાતમંડપના સંબંધમાં કહાથના દીકરાઓને ઊંચકવાનું તે એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","અને હારુન યાજકના દીકરા એલાઝારનુ કામ આ છે; એટલે રોશનીને માટે તેલ, સુગંધી દ્રવ્ય નિત્યનું ખાદ્યાર્પણ તથા અભિષેક માટેનું તેલ તથા પવિત્રમંડપ અને તેમાંની સર્વ વસ્તુઓની સંભાળ તેઓએ રાખવાની છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","યહોવાહે મૂસા તથા હારુનને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“લેવીઓમાંથી કહાથના કુટુંબોના કુળને કાઢી નાખવાં નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","પણ તેઓ પરમપવિત્ર વસ્તુઓની પાસે જઈ મૃત્યુ ન પામે પણ જીવતા રહે, તે માટે તમારે આ મુજબ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","તેઓ પવિત્ર વસ્તુઓને જોવાને માટે બિલકુલ અંદર ન જાય, કેવળ હારુન અને તેના દીકરાઓ અંદર પ્રવેશ કરે હારુન તેના દીકરા કહાથીઓને પોતપોતાની જવાબદારી ઠરાવી આપે.” ");
INSERT INTO guj2017_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","યહોવાહે ફરી મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","ગેર્શોનના દીકરાના પિતૃઓના ઘર મુજબ તેઓનાં કુટુંબો મુજબ કુલ સંખ્યાની ગણતરી કર. ");
INSERT INTO guj2017_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","મુલાકાતમંડપમાં સેવા કરવાના કામમાં હાજર હોય તેવા ત્રીસથી પચાસ વર્ષની ઉંમરના જે પુરુષો હોય તે સર્વની ગણતરી કરવી. ");
INSERT INTO guj2017_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","સેવા કરવામાં તથા વસ્તુઓ ઊંચકવામાં ગેર્શોનીઓના કુટુંબોનું કામ એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","તેઓ મંડપના પડદા તથા મુલાકાતમંડપનું આચ્છાદાન તથા તેની ઉપર સીલ ચામડાનું આચ્છાદન તથા મુલાકાતમંડપના પ્રવેશદ્વારનો પડદો ");
INSERT INTO guj2017_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","તથા આંગણાના પડદા, મંડપની પાસેના તથા વેદીની આસપાસના આંગણાના દરવાજાના બારણાનો પડદો, તેઓની દોરીઓ, તેના કામને લગતાં સર્વ ઓજારો તથા જે કંઈ તેઓથી બને તે તેઓ ઊંચકી લે અને તેના સંબંધમાં તેઓ સેવા કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ગેર્શોનીઓના દીકરાઓનું ભાર ઊંચકવાનું તથા સર્વ સેવાનું સઘળું કામ હારુન તથા તેના દીકરાઓની આજ્ઞા મુજબ થાય. અને તમે તેઓને ભાર ઊંચકવાનું તથા સેવાનું કામ ઠરાવી આપો. ");
INSERT INTO guj2017_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","મુલાકાતમંડપમાં ગેર્શોનના દીકરાઓના કુટુંબોની સેવા આ છે. અને હારુન યાજકના દીકરા ઈથામારે તેઓના કામ પર દેખરેખ રાખવાની છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","અને મરારીના દીકરાઓની તેઓનાં પિતાઓના ઘર મુજબ તેઓનાં કુટુંબો મુજબ ગણતરી કરવાની છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ત્રીસ વર્ષથી પચાસ વર્ષ સુધીની ઉંમરના જે સઘળા અંદર જઈને મુલાકાતમંડપમાં કામ કરવાને સેવામાં હાજર રહે છે તેઓની ગણતરી કર. ");
INSERT INTO guj2017_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","અને મુલાકાતમંડપમાં તેઓની સર્વ સેવાના સંબંધમાં તેઓને સોંપેલું ભાર ઊંચકવાનું કામ એ છે. એટલે મંડપનાં પાટિયાં તથા તેના સ્થંભો તથા તેની કૂંભીઓ, ");
INSERT INTO guj2017_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","અને આંગણાની ચારે બાજુના સ્તંભો તેની કૂંભીઓ તથા તેઓની ખીલીઓ તથા તેઓની દોરીઓ અને તેઓના ઓજારો સુદ્ધાં તથા તેની સાધનસામગ્રી અને તેઓને સોંપેલા ભારના ઓજારોના નામ દઈને તેઓને ગણીને સોંપો. ");
INSERT INTO guj2017_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","મરારીના દીકરાઓનાં કુટુંબોનું કામ એટલે તેઓની સઘળી સેવા મુજબ મુલાકાતમંડપમાં હારુન યાજકના પુત્ર ઈથામારે દેખરેખ રાખવાની ફરજ બજાવવાની છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","અને મૂસા તથા હારુને અને જમાતના અન્ય આગેવાનોએ કહાથના દીકરાઓની ગણતરી તેઓનાં કુટુંબો મુજબ તથા તેઓના પિતાઓનાં ઘર મુજબ કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","એટલે ત્રીસ વર્ષથી પચાસ વર્ષ સુધીની ઉંમરના જે દરેક મુલાકાતમંડપમાં કામ કરવાને સેવામાં દાખલ થયા ");
INSERT INTO guj2017_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","તેઓની ગણતરી તેઓનાં કુટુંબો મુજબ બે હજાર સાતસો પચાસ પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","કહાથીઓના કુટુંબોમાંના જેઓની ગણતરી થઈ એટલે કે જે સર્વ મુલાકાતમંડપમાં સેવા કરતા હતા તથા મૂસાની મારફતે અપાયેલી યહોવાહની આજ્ઞા અનુસાર જેઓની ગણતરી મૂસા અને હારુને કરી તેઓ એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","એ જ રીતે ગેર્શોનના દીકરાઓની ગણતરી તેઓના કુટુંબો મુજબ તથા તેઓનાં પિતાઓનાં કુટુંબો મુજબ કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","એટલે ત્રીસ વર્ષથી પચાસ વર્ષની ઉંમરના જે દરેક મુલાકાતમંડપની સેવાના કામમાં દાખલ થયા હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","તેઓની ગણતરી તેઓનાં કુટુંબ મુજબ તેઓના પિતાઓના ઘર મુજબ બે હજાર છસો ત્રીસ થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ગેર્શોનના દીકરાઓનાં કુટુંબોમાં જેઓની ગણતરી થઈ એટલે કે સર્વ મુલાકાતમંડપમાં સેવા કરતા હતા તથા જેઓની ગણતરી યહોવાહે આપેલી આજ્ઞા મુજબ મૂસા અને હારુને કરી તેઓ એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","મરારીના દીકરાઓનાં કુટુંબોમાંના જેઓની ગણતરી તેઓના પિતાઓનાં ઘર મુજબ થઈ, ");
INSERT INTO guj2017_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","એટલે ત્રીસ વર્ષથી પચાસ વર્ષની ઉંમરના જે દરેક મુલાકાતમંડપમાં સેવા કરવાના કામમાં દાખલ થયા હતા, ");
INSERT INTO guj2017_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","તેઓની ગણતરી તેઓના કુટુંબ મુજબ ત્રણ હજાર બસોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","મરારીના દીકરાઓનાં કુટુંબોમાંના જેઓની ગણતરી થઈ એટલે જેઓની ગણતરી મૂસાની હસ્તક અપાયેલી યહોવાહની આજ્ઞા મુજબ મૂસાએ અને હારુને કરી તેઓ એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","લેવીઓમાં જે સર્વની ગણતરી મૂસાએ તથા હારુને તથા ઇઝરાયલના આગેવાનોએ તેઓના કુટુંબો મુજબ, તેઓનાં પિતૃઓનાં ઘર મુજબ કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","એટલે કે ત્રીસ વર્ષથી પચાસ વર્ષ સુધીની ઉંમરના જે દરેક મુલાકાતમંડપની સેવાના કામમાં તથા વસ્તુઓ ઊંચકવાનું કામ કરવા માટે દાખલ થયા હતા ");
INSERT INTO guj2017_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","તેઓની ગણતરી આઠ હજાર પાંચસો એંસી પુરુષોની થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ તેઓની ગણતરી કરી. તેઓમાંના દરેકની ગણતરી તેઓનાં કામ મુજબ તથા તેઓના ઊંચકવાના બોજા મુજબ મૂસાની મારફતે યહોવાહની આજ્ઞા મુજબ કરવામાં આવી. ");
INSERT INTO guj2017_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","ઇઝરાયલી લોકોને આજ્ઞા કર કે, તેઓ દરેક કુષ્ઠ રોગીને તથા દરેક સ્રાવવાળાને તથા જેઓ શબના સ્પર્શથી અશુદ્ધ થયા હોય તેઓને છાવણીમાંથી બહાર કાઢી મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","સ્ત્રી હોય કે પુરુષ બન્નેને બહાર કાઢી મૂકવાં અને તેઓને છાવણીની બહાર રાખવાં; એ સારુ કે તેઓની છાવણી કે જેની મધ્યે હું વસું છું તેને તેઓ અશુદ્ધ કરે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","અને ઇઝરાયલીઓએ એમ કર્યું, તેઓને છાવણીની બહાર કાઢ્યાં. જેમ યહોવાહે મૂસાને કહ્યું હતું તેમ ઇઝરાયલી લોકોએ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ફરી યહોવાહ મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","ઇઝરાયલપુત્રોને કહે કે, માણસો જે પાપ કરે છે તેમાંનું કોઈપણ પાપ કરીને જો કોઈ સ્ત્રી કે પુરુષ યહોવાહની વિરુદ્ધ અપરાધ કરે તો તે વ્યક્તિ દોષિત બને છે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","તેણે પોતે કરેલાં પાપની કબૂલાત કરવી અને પોતાના ગુનાનો પૂરો બદલો ભરી આપવો. ઉપરાંત તેમાં તે પંચમાશ ઉમેરીને જેના સંબંધમાં તેણે ગુનો કર્યો હોય તેને તે આપે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","પણ ગુનાને માટે જેને બદલો આપવાનો હોય એવું તેનું નજીકનું કોઈ સગું ના હોય, તો તે રકમ યહોવાહને આપવી અને યાજકને ચૂકવવી. વળી જે પ્રાયશ્ચિતનો ઘેટો કે જેથી તેને સારુ પ્રાયશ્ચિત કરવામાં આવશે તે પણ યાજકને મળે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","અને ઇઝરાયલી લોકોની સર્વ પવિત્ર વસ્તુઓનાં દરેક ઉચ્છાલીયાર્પણ કે જે તે યાજકની પાસે લાવે તે તેનું ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","અને દરેક અર્પણની અર્પિત વસ્તુઓ તેની થાય; જે કોઈ પુરુષ જે કંઈ ભેટ આપે છે તે યાજકની થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ફરી યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","ઇઝરાયલ પ્રજા સાથે વાત કરીને કહે કે, જો કોઈ પરણિત સ્ત્રી પોતાના પતિ વિરુદ્ધ પાપ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","એટલે કોઈ અન્ય પુરુષ તેની સાથે વ્યભિચાર કરે અને તેના પતિની આંખોથી તે ગુપ્ત તથા છાનું રહે અને તે સ્ત્રી અશુદ્ધ થાય અને તેની વિરુદ્ધ કોઈ સાક્ષી આપનાર ના હોય, તેમ જ તે કૃત્ય કરતી વેળાએ તે પકડાઇના હોય, ");
INSERT INTO guj2017_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","અને છતાં તેના પતિને તેના પર ઈર્ષ્યા થાય અને તે અશુદ્ધ થઈ હોય અથવા તેના પતિના મનમાં વહેમ જાગ્યો હોય પણ તે અશુદ્ધ થઈ ના હોય. ");
INSERT INTO guj2017_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","તો એ બાબતમાં તે પુરુષ પોતાની પત્નીને યાજક પાસે લાવે. તે તેને માટે પોતાનું અર્પણ લાવે, એટલે એક દશાંશ એફાહ જવનો મેંદો તેની પર તે કંઈ તેલ રેડે નહિ કે લોબાન પણ ન મૂકે. કારણ કે એ ઈર્ષ્યાનું ખાદ્યાર્પણ છે. એટલે કે અન્યાય યાદ કરાવવા માટેનું સ્મરણદાયક ખાદ્યાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","યાજકે તે સ્ત્રીને યહોવાહ સમક્ષ રજૂ કરવી. ");
INSERT INTO guj2017_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","પછી યાજકે માટીના પાત્રમાં પવિત્ર પાણી લેવું અને યાજકે મંડપની ભૂમિ પરની ધૂળ લઈને તેમાં નાખવી. ");
INSERT INTO guj2017_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","પછી યાજક તે સ્ત્રીને યહોવાહ સમક્ષ રજૂ કરે અને તેના વાળ છોડી નંખાવે અને તેના હાથમાં સ્મરણદાયક ખાદ્યાર્પણ એટલે સંશયનું ખાદ્યાપર્ણ આપે. અને યાજકે કડવું શાપકારક પાણી પોતાનાં હાથમાં લે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ત્યારબાદ યાજક તે સ્ત્રી પાસે પ્રતિજ્ઞા લેવડાવે અને તે સ્ત્રીને કહે કે, “જો કોઈ પુરુષ સાથે તેં વ્યભિચાર કર્યો હોય નહિ અને જો તું તારું પતિવ્રત ભંગ કરીને અશુદ્ધ થઈ હોય નહિ તો આ શાપના કડવા પાણીની સત્તાથી તું મુક્ત થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","પણ જો તું તારું પતિવ્રત ભંગ કરીને અશુદ્ધ થઈ હોય અને તે તારા પતિ સિવાય બીજા કોઈ પુરુષ સાથે વ્યભિચાર કર્યો હોય તો, ");
INSERT INTO guj2017_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ત્યારે યાજક તે સ્ત્રીને શાપયુક્ત પ્રતિજ્ઞા લેવડાવે. અને યાજક સ્ત્રીને કહે કે, “યહોવાહ તને તારા લોકમાં શાપરૂપ તથા સોગનરૂપ કરે. જો યહોવાહ તારી જાંઘો સડાવે અને તારું પેટ સુજાવે ત્યારે આમ થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","આ શાપકારક પાણી તારા આંતરડામાં પ્રવેશીને તને સુજાવી દે અને તારી જાંઘને સડાવી નાખે. પછી તે સ્ત્રી જવાબ આપે કે “જો હું દોષિત હોઉં તો હા, એમ જ થાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","અને યાજક એક પુસ્તકમાં એ લખી લે અને એ શબ્દો કડવા પાણીમાં ધોઈ નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ત્યારબાદ યાજક તે સ્ત્રીને શાપકારક પાણી પીવડાવે. જેથી શાપકારક પાણી તે સ્ત્રીના અંગમાં પ્રવેશ કરી અને કડવું થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","અને યાજક તે સ્ત્રીના હાથમાંથી સંશયનું ખાદ્યાર્પણ લે અને યહોવાહની સમક્ષ તે ખાદ્યાર્પણને ઘરાવીને વેદી પાસે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","એ પછી યાજકે તે ખાદ્યાર્પણમાંથી યાદગીરી તરીકે એક મુઠી ભરી વેદીમાં દહન કરવું. અને પછી તે સ્ત્રીને પાણી પાઈ દેવું. ");
INSERT INTO guj2017_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","અને તેને પાણી પાયા પછી એમ થશે કે જો તે સ્ત્રીએ વ્યભિચાર કર્યો હશે તો, અને પોતાના પતિનો અપરાધ કર્યો હશે તો તે શાપકારક પાણી તેનાં પેટમાં પ્રવેશી કડવું થશે અને તેનું પેટ સૂજી જશે. અને તેની જાંઘ સડીને ખરી પડશે. અને તે સ્ત્રી પોતાનાં લોકમાં શાપિત થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","પણ જો તે સ્ત્રી અશુદ્ધ થઈ નહિ હોય પણ તે શુદ્ધ હશે તો તે મુક્ત થશે અને તેને પેટે સંતાન થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","જ્યારે કોઈ સ્ત્રી પોતાનું પતિવ્રત ચૂકી જઈને અશુદ્ધ થાય ત્યારે ઈર્ષ્યા માટેનો નિયમ એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","અથવા પુરુષના મનમાં ઈર્ષ્યા ઉત્પન્ન થયો હોય અને તે પુરુષને પોતાની સ્ત્રી પર વહેમ આવ્યો હોય ત્યારે તે પુરુષ યહોવાહ સમક્ષ તે સ્ત્રીને લાવવી અને યાજક તેના પર આ સર્વ નિયમ અમલમાં મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","પછી તે પુરુષ અન્યાયથી મુક્ત થશે અને તે સ્ત્રી પોતે જ તેના દોષ માટે જવાબદાર છે.’” ");
INSERT INTO guj2017_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ઇઝરાયલના લોકોને એમ કહે કે, જ્યારે કોઈ સ્ત્રી કે પુરુષ યહોવાહની સેવામાં અલગ થવાની ખાસ પ્રતિજ્ઞા લે એટલે નાઝીરવ્રત લે ");
INSERT INTO guj2017_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ત્યારે તેણે દ્રાક્ષારસનો અને દારૂનો ત્યાગ કરવો તદુપરાંત તેણે દ્રાક્ષારસનો અથવા દારૂનો સરકો પીવો નહિ તેમ જ દ્રાક્ષાનું શરબત પણ પીવું નહિ અને લીલી કે સૂકી દ્રાક્ષ ખાવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","જ્યાં સુધી તેનું વ્રત ચાલુ હોય ત્યાં સુધી તેણે દ્રાક્ષવેલામાંથી નીપજેલી કોઈ પણ વસ્તુ દ્રાક્ષનાં બી કે છોતરાં પણ ખાવા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","વળી એ સમય દરમ્યાન તેના માથા પર અસ્ત્રો ન ફરે. અને જ્યાં સુધી વ્રત પૂર્ણ ન થાય ત્યાં સુધી તેણે યહોવાહની સેવામાં વૈરાગ લીધો હોય તે પૂરો થયા સુધી તે શુદ્ધ રહે, તેણે પોતાના માથાનાં વાળ વધારવા. ");
INSERT INTO guj2017_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","યહોવાહની સેવામાં તે નાઝીરી થાય ત્યાં સુધી તે સર્વ દિવસો સુધી તેણે મૃતદેહ પાસે જવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","પોતાનાં માતાપિતા કે ભાઈ બહેનના મરણ પર તેણે પોતાની જાતને અશુદ્ધ કરવી નહિ, કારણ તેના ઈશ્વરનું વૈરાગીવ્રત તેને શિર છે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","તેના વૈરાગીવ્રતના બધા સમય દરમ્યાન તે યહોવાહને માટે શુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","પરંતુ જો કોઈ વ્યક્તિનું અચાનક તેની પડખે જ અવસાન થાય અને તેથી તે વૈરાગીનું માથું અશુદ્ધ બને, તો તે પોતાના શુદ્ધિકરણના દિવસે એટલે સાતમે દિવસે તેણે પોતાના અશુદ્ધ થયેલા માથાના વાળ કપાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","અને આઠમા દિવસે તેણે મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યાજક પાસે બે હોલા અથવા કબૂતરનાં બે બચ્ચાં લાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","અને યાજક એમાંનું એક પાપાર્થાર્પણ તરીકે અને બીજું દહનીયાર્પણ તરીકે ચઢાવે અને મરેલાનાં કારણે પોતાનાં પાપને લીધે તેને માટે પ્રાયશ્ચિત કરે અને તે જ દિવસે તે વ્યક્તિ પોતાના માથાનું શુદ્ધિકરણ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","અને તે યહોવાહની સેવાને માટે પોતાના વૈરાગના દિવસો સમર્પણ કરે. અને દોષાર્થાર્પણરૂપે તેણે એક વર્ષનું નર હલવાન લાવવું. અને આગલા દિવસો ગણવા નહિ, કેમ કે તેનું વૈરાગીવ્રત ભંગ થયું હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","અને જ્યારે નાઝીરી વ્રતના દિવસો પૂર્ણ થાય ત્યારે તેને માટે આ નિયમ છે. તેને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લઈ જવો. ");
INSERT INTO guj2017_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","તેણે યહોવાહને પોતાનું અર્પણ ચઢાવવું, એટલે ખોડ વિનાના એક વર્ષના નર ઘેટાંનું દહનીયાર્પણ, ખોડખાંપણ વગરની એક વર્ષની ઘેટીનું પાપાર્થાર્પણ અને ખોડ વિનાના નર ઘેટાંનું શાંત્યર્પણ કરવું, ");
INSERT INTO guj2017_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","તથા બેખમીર રોટલીની એક ટોપલી, તેલ લગાડેલા બેખમીરી ખાખરા અને તેઓનું ખાદ્યાર્પણ તથા પેયાર્પણ તે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","યાજક આ બધું યહોવાહની આગળ રજૂ કરે. અને તેનું પાપાર્થાર્પણ તથા દહનીયાર્પણ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","પછી તે યહોવાહ સમક્ષ શાંત્યર્પણોના યજ્ઞ તરીકે બેખમીર રોટલીની ટોપલી સહિત, ઘેટાંને તે ચઢાવે. અને યાજક તેનું ખાદ્યાર્પણ અને તેનું પેયાર્પણ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","અને નાઝીરીએ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ વાળ કપાવી નાખવા અને પોતાના વૈરાગી માથાનાં વાળ લઈને શાંત્યર્પણની નીચેના અગ્નિમાં મૂકી દેવા. ");
INSERT INTO guj2017_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","પછી યાજક તે ઘેટાંનો બાફેલો છાતીનો ભાગ બાફેલું બાવડું તથા ટોપલીમાંથી એક બેખમીર રોટલી અને એક બેખમીર ખાખરો લે અને નાઝીરી પોતાનું માથું મૂંડાવે ત્યારબાદ તે ચીજો તેના હાથમાં મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ત્યારબાદ યાજક અર્પણ તરીકે એ વસ્તુઓ યહોવાહની સમક્ષ અર્પણ કરે. આ પવિત્ર ખોરાક યાજકો માટે નક્કી કરેલ છે, તદઉપરાંત, છાતીનો ભાગ અને જાંધ પણ યાજકના ગણાય, હવે તે નાઝીરીએ દ્રાક્ષારસ પીવાની છૂટ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","વ્રત રાખનાર નાઝીરીનો અને વૈરાગીવ્રતને લીધે યહોવાહ પ્રત્યે જે અર્પણ ચઢાવવું તેનો તથા તે સિવાય બીજું કંઈ તેને મળી શકે તેનો નિયમ આ છે. જે પ્રતિજ્ઞા તેણે લીધી હોય ત્યારે તે મુજબ તે તેના વૈરાગવ્રતના નિયમને અનુસરીને વર્તે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","પછી યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","હારુન અને તેના દીકરાઓને એમ કહે કે, ‘તમે આ મુજબ ઇઝરાયલી લોકોને આશીર્વાદ આપો તમે તેઓને એમ કહો કે. ");
INSERT INTO guj2017_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","યહોવાહ તને આશીર્વાદ આપો અને તારું રક્ષણ કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","યહોવાહ પોતાના મુખનો પ્રકાશ તારા પર પાડો અને તારા પર કૃપા કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","યહોવાહ પોતાનું મુખ તારા પર ઉઠાવો અને તને શાંતિ આપો.’” ");
INSERT INTO guj2017_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","એમ તેઓ ઇઝરાયલી લોકોને મારું નામ આપે. અને હું તેઓને આશીર્વાદ આપીશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","જે દિવસે મૂસાએ મુલાકાતમંડપ ઊભો કરવાનું કાર્ય સંપૂર્ણ કર્યુ, તે દિવસે તેણે મંડપનો તેમ જ તેમાંની બધી સાધનસામગ્રી વેદી તથા તેનાં બધાં સાધનોનું અભિષેક અને શુધ્ધીકરણ કર્યું. તથા તે પાત્રોને પવિત્ર કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","તે દિવસે એમ થયું કે, ઇઝરાયલનાં અધિપતિઓએ એટલે તેઓના પિતાના ઘરના ઉપરીઓએ અર્પણ કર્યું. તેઓ કુળોના અધિપતિઓ અને જેઓની ગણતરી થઈ હતી તેઓના ઉપરીઓ હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","તેઓ યહોવાહની સમક્ષ પોતાનું અર્પણ લાવ્યા એટલે બે બળદ જોડેલા છત્રવાળાં છ ગાડાં તથા બાર બળદ. બબ્બે અધિપતિઓ માટે એકેક ગાડું અને દરેકને માટે એકેક બળદ. આ બધું તેઓએ મુલાકાતમંડપની સમક્ષ રજૂ કર્યુ. ");
INSERT INTO guj2017_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","પછી યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“તેઓ પાસેથી તું તે લે કે, તેઓ મુલાકાતમંડપની સેવા કરવાના કામમાં આવે. અને તેઓને તું લેવીઓને આપ એટલે દરેકને તું તેઓની સેવા મુજબ આપ.” ");
INSERT INTO guj2017_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","તેથી મૂસાએ તે ગાડાં અને બળદો લઈને લેવીઓને આપ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","બે ગાડાં અને ચાર બળદો તેણે ગેર્શોનના દીકરાઓને તેઓની સેવા મુજબ આપ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","અને તેણે ચાર ગાડાં તથા આઠ બળદ મરારીના દીકરાઓને તેઓની સેવાઓ મુજબ હારુન યાજકના દીકરા ઈથામારની આગેવાની હેઠળ આપ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","પરંતુ કહાથના દીકરાઓને તેણે કંઈ જ આપ્યું નહિ, કારણ કે તેમનું કામ પવિત્રસ્થાનના સંબંધમાં હતું અને તેને તેઓ પોતાના ખભા ઉપર ઊંચકી લેતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","વેદીનો અભિષેક થયો તે દિવસે વેદીની પ્રતિષ્ઠા કરવાને આગેવાનોએ અર્પણ કર્યું તેઓએ વેદી આગળ પોતાનું અર્પણ ચઢાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","યહોવાહે મૂસાને કહ્યું, સર્વ અધિપતિઓ પોતપોતાના દિવસે વેદીની પ્રતિષ્ઠા કરવા સારુ અર્પણ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","અને પહેલે દિવસે પોતાનું અર્પણ ચઢાવનાર તે યહૂદાના કુળનો આમ્મીનાદાબનો દીકરો નાહશોન હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","અને તેનું અર્પણ ચાંદીની એક કથરોટ હતું, જેનું વજન એકસો ત્રીસ શેકેલ હતું. પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ ચાંદીનો એક પ્યાલો હતો; બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","તેણે દશ શેકેલ સોનાનું ધૂપથી ભરેલું એક ધૂપપાત્ર પણ આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","તથા દહનીયાર્પણ માટે એક વાછરડો એક ઘેટો, પહેલા વર્ષનું એક હલવાન. ");
INSERT INTO guj2017_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","તેણે પાપાર્થાર્પણ માટે બકરામાંથી એક નર આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","અને શાંત્યર્પણોના યજ્ઞને માટે બે બળદ, પાંચ ઘેટા, પાંચ બકરા અને એક વર્ષનાં પાંચ હલવાન હતાં; આમ્મીનાદાબના દીકરા નાહશોનનું અર્પણ એ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","બીજે દિવસે સુઆરનો દીકરા નથાનએલ એટલે ઇસ્સાખારના અધિપતિએ અર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","અને તેણે આ અર્પણ ચઢાવ્યું. એટલે ચાંદીની એક કથરોટ જેનું વજન એકસો વીસ શેકેલ હતું તથા પવિત્ર સ્થાનના શેકેલ મુજબ સિતેર શેકેલ ચાંદીનો એક પ્યાલો. આ બન્ને પાત્રોમાં ખાધાર્પણ તરીકે તેલથી મોહેલો મેંદાથી ભરેલો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","દશ શેકેલ ધૂપથી ભરેલું સોનાનું ધૂપપાત્ર તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","તથા તેણે દહનીયાર્પણ માટે એક વર્ષનું વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","તેણે પાપાર્થાર્પણ માટે બકરામાંથી એક નર આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","અને તેણે શાંત્યર્પણોના યજ્ઞ માટે બે બળદ, પાંચ ઘેટા, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન આપ્યાં. સુઆરના દીકરા નથાનએલનું અર્પણ એ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ત્રીજે દિવસે હેલોનનો દીકરો અલિયાબ, ઝબુલોનના દીકરાનો આગેવાન હતો તેણે તેનું અર્પણ આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","તેનું અર્પણ આ હતું; ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ હતું અને પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ એક ચાંદીનો પ્યાલો હતો. બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","વળી તેણે દશ શેકેલ સોનાનું એક ધૂપપાત્ર ધૂપથી ભરેલું આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","તેણે દહનીયાર્પણ માટે એક વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન આપ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","પાપાર્થાર્પણ માટે બકરામાંથી એક નર તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","તેણે શાંત્યર્પણોને માટે બે બળદ, પાંચ ઘેટા, પાંચ બકરા અને પહેલા વર્ષનાં પાંચ હલવાન આપ્યાં. તે હેલોનના દીકરા અલિયાબનું અર્પણ એ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ચોથે દિવસે શદેઉરનો દીકરો અલીસૂર રુબેનના દીકરાઓનો આગેવાન તેનું અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","અને તેનું અર્પણ આ હતું એટલે ચાંદીની એક કથરોટ જેનું વજન એકસો ત્રીસ શેકેલ હતું અને પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ ચાંદીનો એક પ્યાલો હતો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","વળી તેણે દશ શેકેલ સોનાનું ધૂપથી ભરેલું એક ધૂપપાત્ર અર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","દહનીયાર્પણ માટે એક વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","પાપાર્થાર્પણ માટે બકરામાંથી એક નર તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","તેણે શાંત્યર્પણોના યજ્ઞને માટે બે બળદ, પાંચ ઘેટા, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન આપ્યાં. એ શદેઉરના દીકરા અલીસૂરનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","પાંચમે દિવસે સૂરીશાદ્દાયનો દીકરો શલુમિયેલ, શિમયોનના દીકરાઓનો આગેવાન તેનું અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","અને તેનું અર્પણ આ હતું; ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ હતું. અને પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ રૂપાનો એક પ્યાલો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","દશ શેકેલ સોનાનું એક ધૂપપાત્ર ધૂપથી ભરેલું હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","દહનીયાર્પણ માટે એક વર્ષનું વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાનનું અર્પણ તેણે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","પાપાર્થાર્પણ માટે બકરામાંથી એક નર આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","અને શાંત્યર્પણોનો યજ્ઞના માટે બે બળદ, પાંચ ઘેટા, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન એ સૂરીશાદ્દાયના દીકરા શલુમિયેલનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","છઠ્ઠે દિવસે દુએલના દીકરા એલિયાસાફ ગાદના દીકરાનો અધિપતિ અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","અને તેનું અર્પણ આ હતું; ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ હતું, પવિત્રસ્થાનના સિત્તેર શેકેલ ચાંદીનો એક પ્યાલો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","દશ શેકેલ સોનાનું ધૂપથી ભરેલું એક ધૂપપાત્ર હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","દહનીયાર્પણ માટે એક વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","પાપાર્થાર્પણ માટે બકરાંમાંથી એક નર તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","અને શાંત્યર્પણોના યજ્ઞ માટે બે ગોધાં, પાંચ ઘેટાં, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન એ દુએલના દીકરા એલિયાસાફનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","સાતમે દિવસે આમ્મીહૂદનો દીકરો અલિશામા એફ્રાઇમના દીકરાઓનો આગેવાન તે તેનું અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","અને તેનું અર્પણ આ હતું એટલે કે ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ વજન હતું અને પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ ચાંદીનો એક પ્યાલો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","દશ શેકેલ સોનાનું એક ધૂપપાત્ર ધૂપથી ભરેલું હતું તે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","દહનીયાર્પણને માટે એક વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","પાપાર્થાર્પણને માટે બકરામાંથી એક નર તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","અને શાંત્યર્પણોના યજ્ઞને માટે બે ગોધાં, પાંચ ઘેટાં, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન એ આમ્મીહૂદના દીકરા અલિશામાનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","આઠમા દિવસે પદાહસૂરનો દીકરો ગમાલ્યેલ, મનાશ્શાના દીકરાઓનો આગેવાન તેનું અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","અને તેનું અર્પણ આ હતું એટલે ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ હતું અને પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ રૂપાનો એક પ્યાલો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","દશ શેકેલ સોનાનું ધૂપથી ભરેલું એક ધૂપપાત્ર તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","દહનીયાર્પણને માટે એક વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાનનું તેણે અર્પણ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","પાપાર્થાર્પણ માટે બકરાંમાંથી એક નર તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","અને શાંત્યર્પણોને માટે બે ગોધાં, પાંચ ઘેટાં, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન પદાહસૂરના દીકરા ગમાલ્યેલનું અર્પણ એ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","નવમા દિવસે ગિદિયોનીનો દીકરો અબીદાન, બિન્યામીનના દીકરાઓનો આગેવાન તે પણ અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","અને તેનું અર્પણ આ હતું એટલે ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ હતું. અને પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ ચાંદીનો એક પ્યાલો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","દશ શેકેલ સોનાનું ધૂપથી ભરેલું એક ધૂપપાત્ર તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","દહનીયાર્પણને માટે એક વર્ષનું વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન એ તેણે આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","પાપાર્થાર્પણ માટે બકરાંમાંથી એક નર એ તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","અને શાંત્યર્પણોને માટે બે ગોધાં, પાંચ ઘેટાં, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન એ ગીદિયોનીના દીકરા અબીદાનનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","દસમે દિવસે આમ્મીશાદ્દાયનો દીકરો અહીએઝેર, દાનના દીકરાઓનો આગેવાન તે તેનું અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","અને તેનું અર્પણ આ હતું એટલે ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ હતું અને પવિત્રસ્થાનના શેકેલ મુજબ એક ચાંદીનો પ્યાલો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","દશ શેકેલ સોનાનું ધૂપથી ભરેલું એક ધૂપપાત્ર હતું તે તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","દહનીયાર્પણના માટે એક વાછરડું, એક ઘેટો, પહેલા વર્ષના એક હલવાનનું અર્પણ આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","પાપાર્થાર્પણને માટે બકરાંમાંથી એક નર તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","અને શાંત્યર્પણોને માટે બે ગોધાં, પાંચ ઘેટાં, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન એ આમ્મીશાદ્દાય દીકરા અહીએઝેરનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","અગિયારમે દિવસે ઓક્રાનના દીકરા પાગિયેલ આશેરના દીકરાઓનો આગેવાન તે અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","અને તેનું અર્પણ આ હતું એટલે ચાંદીની એક કથરોટ, જેનું વજન એકસોને ત્રીસ શેકેલ હતું અને પવિત્રસ્થાનના શેકેલ મુજબ સિત્તેર શેકેલ એક ચાંદીનો પ્યાલો આ બન્ને પાત્રો ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","દશ શેકેલ સોનાનું એક ધૂપપાત્ર ધૂપથી ભરેલું તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","દહનીયાર્પણને માટે એક વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","પાપાર્થાર્પણને માટે બકરાંમાંથી એક નર તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","અને શાંત્યર્પણોના યજ્ઞને માટે બે ગોધાં, પાંચ ઘેટાં, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન એ ઓક્રાનના દીકરા પાગિયેલનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","બારમે દિવસે એનાનના દીકરો અહીરા નફતાલીના દીકરાનો આગેવાન તેનું અર્પણ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","અને તેનું અર્પણ આ હતું એટલે ચાંદીની એક કથરોટ જેનું વજન એકસોને ત્રીસ શેકેલ હતું.અને પવિત્રસ્થાનના શેકેલ મુજબ આ બન્ને પાત્રોમાં ખાધાર્પણ તરીકે તેલમિશ્રિત મેંદાથી ભરેલાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","દશ શેકેલ સોનાનું ધૂપથી ભરેલું એક ધૂપપાત્ર તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","તથા દહનીયાર્પણને માટે એક વર્ષનું વાછરડું, એક ઘેટો, પહેલા વર્ષનું એક હલવાન તે તેણે આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","પાપાર્થાર્પણને માટે એક બકરાંમાંથી એક નર તેણે આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","અને શાંત્યર્પણોના યજ્ઞને માટે બે ગોધાં, પાંચ ઘેટાં, પાંચ બકરા અને એક વર્ષના પાંચ હલવાન એ એનાનના દીકરા અહીરાનું અર્પણ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","જે દિવસે વેદીનો અભિષેક થયો તે પ્રસંગે ઇઝરાયલના આગેવાનોએ તેનું પ્રતિષ્ઠાપન કર્યું. તે આ હતું. એટલે ચાંદીની બાર કથરોટ, ચાંદીના બાર પ્યાલા તથા સોનાનાં બાર ધૂપપાત્રો, ");
INSERT INTO guj2017_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ચાંદીની પ્રત્યેક કથરોટનું વજન એકસોને વીસ શેકેલ હતું. અને દરેક ધૂપપાત્રનું વજન સિત્તેર શેકેલ હતું. ચાંદીનાં બધાં પાત્રોનું કુલ વજન પવિત્રસ્થાનના શેકેલ મુજબ બે હજારને ચારસો શેકેલ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","સોનાનાં ધૂપપાત્રો ધૂપથી ભરેલાં, તે પ્રત્યેકનું વજન પવિત્રસ્થાનના શેકેલ મુજબ દશ શેકેલ હતું. એ ધૂપપાત્રોનું સઘળું સોનું એકસોને વીસ શેકેલ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","દહનીયાર્પણ માટે કુલ બાર ગોધાં, બાર ઘેટાં અને એક વર્ષના બાર હલવાન, તેઓનાં ખાદ્યાર્પણ સુદ્ધાં અને પાપાર્થાર્પણ માટે બાર નર બકરાં પણ આપ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","તથા શાંત્યર્પણોના યજ્ઞને માટે કુલ ચોવીસ બળદો, સાઠ ઘેટાં, સાઠ બકરા અને એક વર્ષનાં સાઠ હલવાન હતા, વેદીનો અભિષેક કરી તેના એ પ્રતિષ્ઠાપન કરવામાં આવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","જ્યારે મુલાકાતમંડપમાં મૂસા યહોવાહની સાથે બોલવા ગયો ત્યારે ઈશ્વરની વાણી તેની સાથે વાત કરતી તેણે સાંભળી. બે કરુબો મધ્યેથી કરારકોશ પરના દયાસન ઉપરથી ઈશ્વર તેની સાથે બોલતા હતા. યહોવાહ તેની સાથે બોલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“તું હારુનને કહે કે જ્યારે તું દીવા સળગાવે ત્યારે દીવા દીપવૃક્ષની આગળ તેનો પ્રકાશ પાડે.’” ");
INSERT INTO guj2017_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","હારુને તે પ્રમાણે કર્યુ. જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તે મુજબ તેણે દીપવૃક્ષની આગળ દીવા સળગાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","દીપવૃક્ષ આ મુજબ બનાવવામાં આવ્યુ હતું; એટલે દીપવૃક્ષનું કામ ઘડેલા સોનાનું હતું. તેના પાયાથી તેનાં ફૂલો સુધી તે ઘડતર કામનું હતું. જે નમૂનો યહોવાહે મૂસાને બતાવ્યો હતો. તે પ્રમાણે તેણે દીપવૃક્ષ બનાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","પછી, યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ઇઝરાયલ લોકોમાંથી લેવીઓને અલગ કરીને તેઓને શુદ્ધ કર. ");
INSERT INTO guj2017_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","તેઓને શુદ્ધ કરવા તું આ મુજબ કર; તેઓના પર શુધ્ધિકરણના પાણીનો છંટકાવ કરવો. ત્યારબાદ તેઓ આખું શરીર મૂંડાવે અને પોતાના વસ્ત્ર ધોઈ નાખે તથા પોતાને સ્વચ્છ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ત્યારબાદ તેઓ એક વાછરડો તથા તેનું ખાદ્યાર્પણ એટલે તેલમિશ્રિત મેંદો લે. અને એક બીજો વાછરડો પાપાર્થાર્પણ માટે લે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","પછી બધા લેવીઓને મુલાકાતમંડપ આગળ રજૂ કર; અને ઇઝરાયલ લોકોની આખી જમાતને તું ભેગી કર. ");
INSERT INTO guj2017_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","અને તું લેવીઓને યહોવાહની સમક્ષ લાવે ત્યારે ઇઝરાયલી લોકો પોતાના હાથ લેવીઓ પર મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","પછી લેવીઓને તું યહોવાહ સમક્ષ રજૂ કર. અને લેવીઓ પર ઇઝરાયલપુત્રો પોતાના હાથ મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","અને લેવીઓ પોતાના હાથ વાછરડાઓનાં માથાં પર મૂકે અને લેવીઓના પ્રાયશ્ચિત અર્થે એક બળદ પાપાર્થાર્પણ તરીકે અને બીજો દહનીયાર્પણ તરીકે યહોવાહને તું ચઢાવ. ");
INSERT INTO guj2017_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","પછી હારુનની સામે તથા તેના દીકરાઓ સમક્ષ તું લેવીઓને ઊભા કર અને યહોવાહને સ્તુતિના અર્પણ તરીકે ચઢાવ. ");
INSERT INTO guj2017_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","આ રીતે તું ઇઝરાયલપ્રજામાંથી લેવીઓને અલગ કર, જેથી લેવીઓ મારા પોતાના થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","અને ત્યારપછી, લેવીઓ મુલાકાતમંડપની સેવાને લગતું કામ કરવા અંદર જાય. અને તારે લેવીઓને શુદ્ધ કરીને સ્તુત્યાર્પણ તરીકે મને અર્પણ કરવા. ");
INSERT INTO guj2017_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","આ મુજબ કર, કેમ કે ઇઝરાયલપ્રજામાંથી તેઓ મને સંપૂર્ણ અપાયેલા છે. ઇઝરાયલમાંથી સર્વ પ્રથમજનિતો એટલે ગર્ભ ઊઘાડનારનાં બદલે મેં લેવીઓને મારા પોતાને માટે લીધા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","કેમ કે ઇઝરાયલમાંથી પ્રથમજનિત માણસ તથા પશુ મારાં છે. જે દિવસે મેં મિસરના સર્વ પ્રથમજનિતનો નાશ કર્યો ત્યારે તે સર્વને મેં મારા માટે અલગ કર્યાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","અને ઇઝરાયલના સર્વ પ્રથમજનિતને બદલે મેં લેવીઓને લીધાં છે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ઇઝરાયલ લોકોમાંથી લેવીઓને મુલાકાતમંડપની સેવા કરવાં માટે તથા ઇઝરાયલ લોકોને પ્રાયશ્ચિત કરવા માટે મેં હારુનના તથા તેના દીકરાઓના હાથમાં સોંપ્યા છે. જેથી ઇઝરાયલ લોકો પવિત્રસ્થાનની પાસે આવે ત્યારે તેઓ મધ્યે કોઈ મરકી ન થાય.” ");
INSERT INTO guj2017_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","પછી મૂસા તથા હારુને તથા ઇઝરાયલ લોકોના સમગ્ર સભાએ આ મુજબ લેવીઓને કહ્યું; લેવીઓ વિષે જે સર્વ આજ્ઞા યહોવાહે મૂસાને આપી હતી તે મુજબ ઇઝરાયલના સમગ્ર સમાજે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","લેવીઓએ પોતાને પાપથી શુદ્ધ કર્યા અને તેઓએ પોતાનાં વસ્ત્રો ધોયાં. અને હારુને તે સૌને અર્પણ તરીકે યહોવાહની આગળ રજૂ કર્યા. અને હારુને તેઓને શુદ્ધ કરવા માટે તેઓને સારુ પ્રાયશ્ચિત કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ત્યારબાદ લેવીઓ મુલાકાતમંડપમાં હારુન અને તેના દીકરાઓના હાથ નીચે સેવા કરવા ગયા. જેમ યહોવાહે લેવીઓ અંગે જે આજ્ઞાઓ મૂસાને જણાવી હતી તેમ તેઓએ તેઓને કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ફરીથી, યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“લેવીઓની ફરજ આ છે. પચ્ચીસ વર્ષ કે તેથી વધુ ઉંમરના લેવીઓ મુલાકાતમંડપની અંદર જઈ સેવા શરૂ કરી શકે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","પચાસ વર્ષની ઉંમરે તેઓ સેવામાંથી નિવૃત્ત થાય અને સેવા કરવાનું બંધ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","તેઓ મુલાકાતમંડપમાં કામ કરતા પોતાના ભાઈઓની સાથે સેવા કરે, પણ મુલાકાતમંડપની અંદર સેવા ન કરે, લેવીઓને સોંપેલી સેવા માટે આ વ્યવસ્થા વિષે તું તેઓને માહિતી આપ.” ");
INSERT INTO guj2017_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","મિસર દેશમાંથી આવ્યા પછી બીજા વર્ષના પ્રથમ મહિનામાં સિનાઈના અરણ્યમાં યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ઇઝરાયલીઓ વર્ષના ઠરાવેલા સમયે પાસ્ખાપર્વ પાળે. ");
INSERT INTO guj2017_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","આ મહિનાને ચૌદમે દિવસે સાંજે નિયત સમયે પાસ્ખાપર્વ પાળો. એને લગતા બધા નિયમો અને વિધિઓ મુજબ તેનું પાલન કરો.” ");
INSERT INTO guj2017_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","તેથી, ઇઝરાયલીઓને મૂસાએ કહ્યું કે તમારે પાસ્ખાપર્વ પાળવું. ");
INSERT INTO guj2017_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","અને પ્રથમ મહિનાના ચૌદમા દિવસે સાંજે સિનાઈના અરણ્યમાં તેઓએ પાસ્ખાપર્વ પાળ્યું. જે સર્વ આજ્ઞાઓ યહોવાહે મૂસાને આપી હતી તે મુજબ ઇઝરાયલીઓએ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","કેટલાક માણસો મૃતદેહના સ્પર્શથી અશુદ્ધ થયા હતા તેથી તેઓ તે દિવસે પાસ્ખાપર્વ પાળી ન શક્યા અને તેઓ તે દિવસે મૂસા અને હારુનની પાસે આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","તેઓએ મૂસાને કહ્યું કે, “અમે મૃતદેહના સ્પર્શથી અશુદ્ધ થયેલા છીએ. ઇઝરાયલીઓ તેને માટે નિયત સમયે યહોવાહને અર્પણ કરે છે. તો અમને શા માટે એવું કરવાની મનાઈ કરવામાં આવે છે?” ");
INSERT INTO guj2017_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","મૂસાએ તેઓને કહ્યું કે, “યહોવાહ તમારા વિષે શી આજ્ઞા આપે છે તે હું સાંભળું ત્યાં સુધી ઊભા રહો.” ");
INSERT INTO guj2017_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","યહોવાહે મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ઇઝરાયલપ્રજાને આ પ્રમાણે કહે કે, જો તમારામાંનો અથવા તમારા સંતાનોમાંનો કોઈ શબના સ્પર્શને કારણે અશુદ્ધ થયો હોય અથવા દૂર મુસાફરી કરતો હોય, તો પણ તે યહોવાહનું પાસ્ખાપર્વ પાળે.’” ");
INSERT INTO guj2017_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","બીજા મહિનાના ચૌદમા દિવસે સાંજે તેઓ તે પર્વ પાળે અને બેખમીર રોટલી તથા કડવી ભાજી સાથે તે ખાય. ");
INSERT INTO guj2017_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","એમાંનું કશું તેઓ સવાર સુધી રહેવા દે નહિ, તેમ જ તેનું એકેય હાડકું ભાંગે નહિ. પાસ્ખાપર્વના સર્વ નિયમોનું પાલન તેઓ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","પણ જો કોઈ માણસ શુદ્ધ હોવા છતાં અને મુસાફરીમાં હોવા ન છતાં પાસ્ખાપર્વ પાળવાનું ચૂકે તે પોતાનાં લોકોથી અલગ કરાય. કેમ કે, તેણે નિયત સમયે યહોવાહને અર્પણ કર્યું નહિ, તેથી તે માણસનું પાપ તેને માથે. ");
INSERT INTO guj2017_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","અને જો કોઈ પરદેશી તમારામાં રહેતો હોય અને તે યહોવાહને માટે પાસ્ખાપર્વ પાળવા ઇચ્છતો હોય તો તે પાસ્ખાના બધા નિયમો અને વિધિઓ પ્રમાણે તે પાળે. દેશના વતની તથા પરદેશી સૌને માટે સરખો જ નિયમ છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","મંડપ ઊભો કરવામાં આવ્યો તે જ દિવસે મેઘે મંડપ પર એટલે સાક્ષ્યમંડપ પર આચ્છાદન કર્યું. અને સાંજથી સવાર સુધી મંડપ ઉપર તેનો દેખાવ અગ્નિની જેમ ઝળહળતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","આ પ્રમાણે હંમેશા થતું મેઘ તેના પર આચ્છાદન કરતો અને રાત્રે તેનો દેખાવ અગ્નિની જ્વાળા જેવો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","અને જ્યારે મંડપ ઉપરથી મેઘ હઠી જતો ત્યારે ઇઝરાયલપ્રજા ચાલતી અને જે જગ્યાએ મેઘ થોભે ત્યાં તેઓ છાવણી કરતા. ");
INSERT INTO guj2017_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","યહોવાહની આજ્ઞા મુજબ ઇઝરાયલીઓ મુસાફરી કરતા અને તેઓની આજ્ઞા મુજબ તેઓ છાવણી કરતા. જયાં સુધી મંડપ ઉપર મેઘ થોભતો ત્યાં સુધી તેઓ છાવણીમાં રહેતા. ");
INSERT INTO guj2017_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","અને જ્યારે મેઘ લાંબા સમય સુધી મંડપ પર રહેતો ત્યારે ઇઝરાયલ લોકો યહોવાહે સોંપેલી સેવા કરતા અને આગળ ચાલતા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","પરંતુ કેટલીક વખત મેઘ થોડા દિવસ માટે મુલાકાતમંડપ પર રહેતો ત્યારે યહોવાહની આજ્ઞા મુજબ તેઓ છાવણીમાં રહેતા. ");
INSERT INTO guj2017_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","કેટલીક વખત મેઘ સાંજથી સવાર સુધી રહેતો અને જ્યારે સવારે મેઘ ઊપડી જતો ત્યારે તેઓ ચાલતા એટલે કે દિવસે કે રાત્રે મેઘ ઊપડતો ત્યારે તેઓ આગળ વધતા. ");
INSERT INTO guj2017_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","જ્યાં સુધી મેઘ પવિત્રમંડપ પર થોભી રહે ત્યાં સુધી એટલે કે બે દિવસ કે એક મહિનો કે એક વર્ષ માટે હોય, તોપણ ઇઝરાયલ લોકો છાવણીમાં રહેતા અને આગળ ચાલતાં નહિ. પણ જ્યારે તે ઊપડતો ત્યારે તેઓ ચાલતા. ");
INSERT INTO guj2017_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","યહોવાહની આજ્ઞા અનુસાર તેઓ છાવણી કરતા અને તેમની જ આજ્ઞા મુજબ તેઓ ચાલતા મૂસા દ્વારા તેઓને અપાયેલી આજ્ઞા મુજબ તેઓ યહોવાહને સોંપેલી સેવા કરતા. ");
INSERT INTO guj2017_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","યહોવાહ મૂસાને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“તું પોતાને માટે ચાંદીનાં બે રણશિંગડાં બનાવ અને તે ઘડતર કામના બનાવ. અને તું પ્રજાને બોલાવવાના તથા છાવણીમાંથી ચાલી નીકળવાના કામમાં લે. ");
INSERT INTO guj2017_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","જે સમયે બન્ને રણશિંગડા વગાડવામાં આવે, ત્યારે સમગ્ર સમાજે મુલાકાતમંડપના પ્રવેશદ્વાર આગળ તમારી સમક્ષ એકત્ર થવું. ");
INSERT INTO guj2017_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","પરંતુ જો યાજક એક જ રણશિંગડું વગાડે તો આગેવાનો, ઇઝરાયલકુળના મુખ્ય પુરુષો તારી સમક્ષ એકઠા થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","જ્યારે તમે ભયસૂચક રણશિંગડું વગાડો ત્યારે પૂર્વ દિશામાં નાખેલી છાવણીઓએ કૂચ કરવી. ");
INSERT INTO guj2017_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","બીજી વખતે રણશિંગડાં મોટા અવાજે વાગે, ત્યારે દક્ષિણ દિશામાંની છાવણીએ કૂચ કરવી. આમ મુકામ ઉઠાવવાના સંકેત તરીકે રણશિંગડું મોટા અવાજે વગાડવું. ");
INSERT INTO guj2017_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","પણ ઇઝરાયલ સમાજને સભા માટે એકત્ર થવા જણાવવું હોય તો રણશિંગડું એકધારું વગાડવું. ");
INSERT INTO guj2017_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","હારુનના વંશજોએ એટલે કે યાજકોએ જ રણશિંગડાં વગાડવાનાં છે. આ કાયમી કાનૂનનો અમલ તમારે પેઢી દરપેઢી કરવાનો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","અને જ્યારે તમે પોતાનાં દેશમાં તમારા પર જુલમ કરનારા દુશ્મનો સાથે યુદ્ધ કરવા જાઓ ત્યારે ભયસૂચક રણશિંગડાં વગાડો. યહોવાહ રણશિંગડાંનો અવાજ સાંભળશે, તમને યાદ કરશે અને તમને તમારા દુશ્મનોથી બચાવશે. ");
INSERT INTO guj2017_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","વળી, તમારા ઉત્સવો વખતે, તમારા ઠરાવેલ પર્વોએ અને તમારા મહિનાઓના આરંભમાં તમે તમારા દહનીયાર્પણો તેમ જ શાંત્યર્પણો પર રણશિંગડું વગાડો. અને તેઓ તમારા ઈશ્વરની હજૂરમાં તમારે માટે સ્મરણાર્થે થશે. હું યહોવાહ તમારો ઈશ્વર છું.” ");
INSERT INTO guj2017_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","અને બીજા વર્ષના બીજા મહિનાના વીસમા દિવસે સાક્ષ્યોના મંડપ ઉપરથી મેઘ ઊપડ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","અને ઇઝરાયલપ્રજાએ સિનાઈના અરણ્યમાંથી પોતાની મુસાફરી શરૂ કરી અને મેઘ પારાનના અરણ્યમાં થોભ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","મૂસાને યહોવાહ તરફથી અપાયેલી આજ્ઞા મુજબ તેઓએ પોતાની પ્રથમ યાત્રા શરૂ કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","અને યહૂદાપુત્રોની પહેલી છાવણીની ધજા પોતાનાં સૈન્ય મુજબ ચાલી નીકળી. અને તેના સૈન્યોનો આગેવાન આમ્મીનાદાબનો દીકરો નાહશોન હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ઇસ્સાખારના દીકરાઓના કુળના સૈન્યનો આગેવાન સુઆરનો દીકરો નથાનએલ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","અને ઝબુલોનના દીકરાઓના કુળનો સૈન્યનો ઉપરી હેલોનનો દીકરો અલિયાબ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ત્યાર પછી મંડપ ઉપાડવામાં આવ્યો એટલે ગેર્શોનના દીકરા તથા મરારીના દીકરાઓ મંડપ ઊંચકીને ચાલી નીકળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","તે પછી, રુબેનની છાવણીની ધજા પોતાનાં સૈન્ય મુજબ ચાલી નીકળી. અને તેના સૈન્યનો ઊપરી શદેઉરનો દીકરો અલીસૂર હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","અને શિમયોનનો દીકરાના કુળના સૈન્યનો ઉપરી સૂરીશાદ્દાયનો દીકરો શલુમિયેલ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","અને ગાદના દીકરાઓના કુળના સૈન્યનો ઉપરી દુએલનો દીકરો એલિયાસાફ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","અને કહાથીઓ પવિત્રસ્થાનમાંની સાધનસામગ્રી ઊંચકીને ચાલ્યા. તેઓ જઈ પહોંચે તે અગાઉ બીજાઓએ મંડપને ઊભો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","પછી એફ્રાઇમના દીકરાઓની છાવણીની ધજા પોતાનાં સૈન્ય મુજબ ચાલી નીકળી અને તેના સૈન્ય પર આમ્મીહૂદનો દીકરો અલિશામા હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","અને મનાશ્શાના દીકરાઓના કુળના સૈન્યનો ઉપરી પદાહસૂરનો દીકરો ગમાલ્યેલ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","અને બિન્યામીનના દીકરાના કુળના સૈન્યનો ઉપરી ગિદિયોનીનો દીકરો અબીદાન હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","પછી દાનના દીકરાઓની છાવણીની ધજા તેમનાં સૈન્ય મુજબ ચાલી નીકળી. બધી છાવણીઓના સૈન્યમાં તે સૌથી પાછળ હતી. અને તેનાં સૈન્યનો ઉપરી આમ્મીશાદ્દાયનો દીકરો અહીએઝેર હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","અને આશેરના દીકરાઓના કુળના સૈન્યનો ઉપરી ઓક્રાનનો દીકરા પાગિયેલ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","અને નફતાલીના દીકરાઓના કુળના સૈન્યનો ઉપરી એનાનનો દીકરો અહીરા હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ઇઝરાયલપ્રજાના સૈન્યોની કૂચનો ક્રમ આ મુજબ હતો. અને તેઓએ કૂચ આરંભી. ");
INSERT INTO guj2017_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","અને મૂસાના સસરા મિદ્યાની રેઉએલના દીકરા હોબાબ સાથે મૂસાએ વાત કરી. દુએલ એ મૂસાની પત્નીનો પિતા હતો. મૂસાએ હોબાબને કહ્યું કે, “જે જગ્યા વિષે યહોવાહે અમને કહ્યું છે ત્યાં જવા માટે આપણે મુસાફરી કરીએ છીએ. યહોવાહે કહ્યું છે કે, ‘હું તમને તે આપીશ.’ અમારી સાથે ચાલો અને અમે તમારું ભલું કરીશું. કેમ કે યહોવાહે ઇઝરાયલનું ભલું કરવાનું વચન આપ્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","પણ હોબાબે મૂસાને ઉત્તર આપ્યો કે, “હું તમારી સાથે નહિ આવું. હું તો મારા પોતાના દેશમાં મારાં સગાઓ પાસે જઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","મૂસાએ જવાબ આપ્યો કે, “કૃપા કરી અમને છોડીને ન જઈશ. કેમ કે અરણ્યમાં અમારે કેવી રીતે છાવણી કરવી તે તું જાણે છે અને તું અમારે માટે આંખોની ગરજ સારે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","અને જો તું અમારી સાથે આવશે તો એમ થશે કે, યહોવાહ અમારું જે કંઈ ભલું કરશે તેમ અમે તમારું ભલું કરીશું.” ");
INSERT INTO guj2017_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","અને તેઓએ યહોવાહના પર્વતથી નીકળી ત્રણ દિવસ યાત્રા કરી. તે ત્રણે દિવસ દરમ્યાન યહોવાહનો કરારકોશ તેમને માટે વિશ્રામસ્થાનની જગ્યા શોધવા તેઓની આગળ ચાલ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","અને દિવસે તેઓ છાવણીમાંથી ચાલી નીકળતા. ત્યારે યહોવાહનો મેઘસ્તંભ તેઓના ઉપર રહેતો. ");
INSERT INTO guj2017_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","અને જ્યારે કરારકોશ ચાલી નીકળતો ત્યારે એમ થતું કે, મૂસા કહેતો, “હે યહોવાહ, તમે ઊઠો અને તમારા શત્રુઓને વેરવિખેર કરી નાખો, અને તમારો તિરસ્કાર કરનારને દૂર કરો.” ");
INSERT INTO guj2017_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","અને જ્યારે કરારકોશ થોભતો ત્યારે મૂસા કહેતો કે, હે યહોવાહ, ઇઝરાયલના કરોડો પાસે તમે પાછા આવો.” ");
INSERT INTO guj2017_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","અને ઇઝરાયલીઓ યહોવાહના સાંભળતાં મુશ્કેલી વિષે ફરિયાદ કરી. યહોવાહ તે સાંભળીને તેઓના પર ગુસ્સે થયા. અને તેમનો અગ્નિ તેઓ મધ્યે પ્રગટ્યો; અને તેમણે છાવણીના સૌથી દૂરના છેડા સુધીના ભાગને બાળીને ભસ્મ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","લોકોએ મૂસાને પોકાર કર્યો, તેથી તેણે લોકો માટે યહોવાહને પ્રાર્થના કરી અને અગ્નિ હોલવાઈ ગયો. ");
INSERT INTO guj2017_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","અને તે જગ્યાનું નામ તાબેરાહ પાડવામાં આવ્યું. કેમ કે, તેઓ મધ્યે યહોવાહનો અગ્નિ પ્રગટ્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","અને તેઓની સાથે મિશ્રિત થયેલા કેટલાક પરદેશીઓ અયોગ્ય વાસના કરવા લાગ્યા. અને ઇઝરાયલ લોકો ફરિયાદ કરી રડીને કહ્યું કે, “અમને ખાવાને માંસ કોણ આપશે? ");
INSERT INTO guj2017_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","જે માછલી મિસરમાં અમે મફતમાં ખાતા હતા તે હવે અમને યાદ આવે છે; વળી કાકડી, તડબૂચ, પ્યાજ અને લસણ પણ. ");
INSERT INTO guj2017_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","હાલ તો અમે નબળા પડી ગયા છીએ. ફક્ત આ માન્ના સિવાય બીજું કંઈ જ અમારી નજરે પડતું નથી.” ");
INSERT INTO guj2017_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","માન્ના તો ધાણાના દાણા જેટલું હતું. તે ગુંદર જેવા ચીકણા પદાર્થ જેવું દેખાતું હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","લોકો છાવણીમાં ફરીને માન્ના વીણીને એકત્ર કરી લાવતા અને ઘંટીમાં દળી અથવા ખાંડણિયામાં ખાંડીને તથા તવામાં શેકીને તેની પૂરીઓ બનાવતા; અને તેનો સ્વાદ જૈતૂનના તેલ જેવો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","અને રાત્રે છાવણીમાં ઝાકળ પડતું ત્યારે તેની સાથે માન્ના પણ પડતું. ");
INSERT INTO guj2017_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","અને મૂસાએ સર્વ લોકોને પોતપોતાના કુટુંબોમાં એટલે દરેક માણસને પોતાના તંબુના બારણા આગળ રડતાં સાંભળ્યા. અને યહોવાહ બહુ ગુસ્સે થયા મૂસાની નજરમાં ખોટું લાગ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","મૂસાએ યહોવાહને કહ્યું, “તમે તમારા સેવકને શા માટે દુઃખી કર્યો? અને હું તમારી દૃષ્ટિમાં કેમ કૃપા ન પામ્યો કે તમે એ સર્વ લોકોનો બોજ મારા પર નાખો છો.? ");
INSERT INTO guj2017_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","શું આ સર્વ લોકો મારાં સંતાનો છે? શું મેં તેઓને જન્મ આપ્યો છે કે તમે મને કહો છો કે કોઈ પાળક પિતા પોતાની ગોદમાં ધાવણા બાળકને છાતીએ વળગાડી રાખે છે, તેમ જે દેશ વિષે મેં તેઓના પિતૃઓ આગળ સોગન ખાધા તેમાં તેઓને ઊંચકીને લઈ જા? ");
INSERT INTO guj2017_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","આ સર્વ લોકોને આપવા માટે મને માંસ કયાંથી મળી શકે? કેમ કે તેઓ રડી રડીને મને કહે છે કે, “અમને માંસ આપો કે અમે ખાઈએ. ");
INSERT INTO guj2017_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","હું એકલો આ સર્વ લોકોનો બોજ સહન કરી શકતો નથી, કેમ કે તે બોજ મારા ગજા બહારનો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","જો તમે મારી સાથે આ રીતે વર્તો, ત્યારે તો, જો હું તમારી દૃષ્ટિમાં કૃપા પામ્યો હોઉં તો મને મારી નાખો કે મને મારું હિનતા જોવી ન પડે.” ");
INSERT INTO guj2017_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","પછી યહોવાહે મૂસાને કહ્યું, “ઇઝરાયલના વડીલોમાંના સિત્તેર પુરુષો કે જેઓને તું લોકોના વડીલો તથા ઉપરીઓ તરીકે ઓળખાવે છે. તેઓને મારી સમક્ષ એકત્ર કર. અને મુલાકાતમંડપની પાસે તેઓને લાવ. તેઓને ત્યાં તારી સાથે ઊભા રાખ. ");
INSERT INTO guj2017_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","હું નીચે ઊતરીને ત્યાં આવીશ અને તારી સાથે વાત કરીશ, મેં તને જે આત્મા આપ્યો છે તેમાંનો લઈને હું એ લોકો પર મૂકીશ. તેથી તેઓ પણ તારી સાથે લોકોનો ભાર ઊચકશે, તેથી તારે એકલાએ બોજ ઊંચકવો પડશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","તું લોકોને કહે કે,; તમે કાલને સારુ પોતાને શુદ્ધ કરો યહોવાહની મુલાકાત માટે તૈયાર થાઓ. તમને માંસ મળશે, કેમ કે, તમે રડીને યહોવાહના કાનોમાં કહ્યું કે, “અમને ખાવાને માંસ કોણ આપશે? કેમ કે, મિસરમાં જ અમારા માટે સારું હતું.” એ માટે યહોવાહ તમને માંસ આપશે અને તમે ખાશો. ");
INSERT INTO guj2017_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","એક દિવસ કે બે દિવસ નહિ, પાંચ, દશ કે વીસ દિવસ સુધીય નહિ, ");
INSERT INTO guj2017_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","પરંતુ એક આખા મહિના સુધી તમે તે ખાશો એટલે સુધી કે તે તમારાં નસકોરામાંથી પાછું નીકળશે. અને તેથી તમે કંટાળી જશો. કેમ કે યહોવાહ જે તમારી મધ્યે છે તેનો તમે ઇનકાર કર્યો છે અને તેમની આગળ રડીને કહ્યું છે કે “અમે મિસરમાંથી કેમ બહાર આવ્યા?” ");
INSERT INTO guj2017_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","પછી મૂસાએ કહ્યું, જે લોકોની સાથે હું છું તેઓ છ લાખ પાયદળ છે અને તમે કહ્યું છે કે, હું તેઓને એટલું બધું માંસ આપીશ કે, તેઓ એક આખા મહિના સુધી તે ખાશે.’ ");
INSERT INTO guj2017_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","શું તેઓને પૂરતું થાય તે માટે ઘેટાંબકરાં તથા ઢોરઢાંકના ટોળાં કાપવામાં આવશે? કે તેઓને પૂરતું થાય તે માટે સમુદ્રનાં બધાં માછલાં એકત્ર કરવામાં આવશે?” ");
INSERT INTO guj2017_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","યહોવાહે મૂસાને કહ્યું કે, “શું મારો હાથ એટલો ટૂંકો પડ્યો છે? મારું વચન તારા પ્રત્યે પૂરું થશે કે નહિ એ તું હવે જોઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","પછી મૂસાએ બહાર આવીને યહોવાહનાં વચન લોકોને કહી સંભળાવ્યાં. અને લોકોના વડીલોમાંના સિત્તેર માણસોને તેણે એકત્ર કર્યા. અને તેઓને તંબુની આજુબાજુ ઊભા રાખ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","યહોવાહ મેઘમાંથી ઊતરી આવ્યા અને મૂસા સાથે બોલ્યા પછી મૂસાને જે આત્મા આપ્યો હતો તેમાંનો લઈ અને તે સિત્તેર વડીલો પર મૂક્યો. અને એમ થયું કે આત્મા તેઓ પર રહ્યો. ત્યાં સુધી તેઓએ પ્રબોધ કર્યો. પણ ત્યાર પછી તેઓએ એમ કર્યુ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","પરંતુ છાવણીમાં બે પુરુષો રહી ગયા હતાં. એકનું નામ એલ્દાદ તથા બીજાનું મેદાદ હતું. અને તેઓના પર આત્મા રહ્યો. તેઓનાં નામ યાદીમાં લખાયેલાં હતાં, પણ બહાર નીકળીને તંબુ પાસે ગયા ન હતા અને છાવણીમાં તેઓ પ્રબોધ કરવા લાગ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","અને એક યુવાને દોડી જઈને મૂસાને કહ્યું કે, “એલ્દાદ અને મેદાદ છાવણીમાં પ્રબોધ કરે છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","નૂનનો પુત્ર યહોશુઆ, જે મૂસાની સેવામાં હતો તેઓમાંના પસંદ કરાયેલા એકે, મૂસાને કહ્યું કે, “મારા માલિક મૂસા, તેમને મના કર.” ");
INSERT INTO guj2017_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","અને મૂસાએ તેને કહ્યું કે “શું મારી ખાતર તને તેમના પર અદેખાઈ આવે છે? હું ઇચ્છું છું કે યહોવાહના સર્વ લોકો પ્રબોધકો થાય કે યહોવાહ તેઓના ઉપર પોતાનો આત્મા મૂકે!” ");
INSERT INTO guj2017_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","પછી મૂસા તથા ઇઝરાયલના સિત્તેર આગેવાનો છાવણીમાં પાછા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","પછી તરત યહોવાહ પાસેથી પવન આવ્યો અને તે સમુદ્ર તરફથી લાવરીઓને ઘસડી લાવ્યો. અને છાવણીની પાસે આ બાજુએ એક દિવસની મુસાફરી સુધી તથા બીજી બાજુએ એક દિવસની મુસાફરી સુધી તેઓને છાવણીની આસપાસ નાખી. અને તેઓ જમીનથી આશરે બત્રીસ હાથ ઊંચે તેઓ ઊડતી હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","તેથી લોકોએ તે આખો દિવસ અને આખી રાત અને બીજો આખો દિવસ ઊભા રહી લાવરીઓને ભેગી કરી. ઓછામાં ઓછી લાવરીઓ એકઠી કરનારે દસ હોમેર જેટલી એકઠી કરી. અને તેઓએ તેને છાવણીની આસપાસ સર્વ ઠેકાણે તે પાથરી દીધી. ");
INSERT INTO guj2017_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","પણ માંસ હજી તેઓના મોમાં જ હતું. અને તે ચવાયું પણ નહોતું એટલામાં તો તેઓના ઉપર યહોવાહનો કોપ સળગી ઊઠયો. અને લોકોને યહોવાહે મોટી મરકીથી માર્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","તેથી તેઓએ એ જગ્યાનું નામ ‘કિબ્રોથ હાત્તાવાહ’ પાડ્યું કેમ કે જેઓએ અયોગ્ય વાસના કરી હતી તેઓને તેઓએ ત્યાં દફનાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","અને લોકો કિબ્રોથ હાત્તાવાહથી નીકળીને હસેરોથ ગયા અને તેઓ હસેરોથમાં રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","અને મૂસાએ એક કૂશી સ્ત્રી સાથે લગ્ન કર્યા હતાં. તેને લીધે મરિયમ અને હારુન મૂસાની વિરુદ્ધ બોલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","તેઓએ કહ્યું, “શું યહોવાહ ફક્ત મૂસા મારફતે જ બોલ્યા છે? શું તેઓ આપણી મારફતે બોલ્યા નથી? “હવે યહોવાહે તેઓએ જે કહ્યું તે સાંભળ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","મૂસા ખૂબ નમ્ર હતો, પૃથ્વી પર નમ્ર તેના જેવો બીજો કોઈ ન હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","યહોવાહે મૂસા, હારુન અને મરિયમને એકાએક કહ્યું; “તમે ત્રણે મુલાકાતમંડપની પાસે બહાર આવો.” અને તેઓ ત્રણે બહાર આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","પછી યહોવાહ મેઘસ્તંભમાં ઊતર્યા. અને તેઓ તંબુના પ્રવેશદ્વાર આગળ ઊભા રહ્યા. તેમણે હારુનને અને મરિયમને બોલાવ્યાં. અને તેઓ બન્ને આગળ આવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","યહોવાહે કહ્યું, “હવે મારા શબ્દો સાંભળો. જ્યારે તમારી સાથે મારો પ્રબોધક હોય, તો હું પોતે સંદર્શનમાં તેને પ્રગટ થઈશ. અને સ્વપ્નમાં હું તેની સાથે બોલીશ. ");
INSERT INTO guj2017_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","મારો સેવક મૂસા એવો નથી તે મારા આખા ઘરમાં વિશ્વાસુ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","હું મૂસા સાથે તો મુખોપમુખ બોલીશ, મર્મો વડે નહિ. તે મારું સ્વરૂપ જોશે. તો તમે મારા સેવક મૂસાની વિરુદ્ધ બોલતા કેમ બીધા નહિ?” ");
INSERT INTO guj2017_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","પછી યહોવાહનો કોપ તેઓના પર સળગી ઊઠ્યો અને તે તેમની પાસેથી ચાલ્યા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","અને તંબુ પરથી મેઘ હઠી ગયો મરિયમ કુષ્ટરોગથી બરફ જેવી શ્વેત થઈ ગઈ. જ્યારે હારુને પાછા વળી મરિયમ તરફ જોયું, તો જુઓ તે કુષ્ઠરોગી થઈ ગયેલી હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","હારુને મૂસાને કહ્યું કે, “ઓ મારા માલિક, કૃપા કરીને અમારા પર આ દોષ ન મૂક. કેમ કે અમે મૂર્ખાઈ કરી અને પાપ કર્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","પોતાની માતા જન્મ આપે તે વખતે જેનું અડધું શરીર ખવાઈ ગયું હોય એવી મૃત્યુ પામેલા જેવી તે ન થાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","તેથી, મૂસાએ યહોવાહને વિનંતી કરી. તેણે કહ્યું કે, ઓ ઈશ્વર, હું તમને વિનંતી કરું છું કે તેને સાજી કરો.” ");
INSERT INTO guj2017_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","યહોવાહે મૂસાને કહ્યું કે, “જો તેનો પિતા તેના મુખ પર થૂંકયો હોત, તો સાત દિવસ તે લાજત. તેથી સાત દિવસ તે છાવણીની બહાર રખાય. અને પછી તે પાછી આવે.” ");
INSERT INTO guj2017_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","આથી મરિયમને સાત દિવસ સુધી છાવણીની બહાર રાખવામાં આવી અને મરિયમને પાછી અંદર લાવવામાં આવી ત્યાં સુધી લોકોએ આગળ મુસાફરી કરી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","પછી લોકો હસેરોથથી નીકળીને પારાનના અરણ્યમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","પછી યહોવાહ મૂસા સાથે બોલ્યા. તેમણે કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“કનાન દેશ, જે હું ઇઝરાયલી લોકોને આપવાનો છું તેની જાસૂસી કરવા માટે તું થોડા માણસોને મોકલ. તેઓના પિતાના સર્વ કુળમાંથી એક એક પુરુષને મોકલ. તે દરેક તેઓ મધ્યે આગેવાન હોય.” ");
INSERT INTO guj2017_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","અને યહોવાહની આજ્ઞા અનુસાર પારાનના અરણ્યમાંથી મૂસાએ તેઓને મોકલ્યા. એ સર્વ પુરુષો ઇઝરાયલી લોકોના આગેવાનો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","તેઓનાં નામ આ પ્રમાણે છે; રુબેનના કુળમાંથી, ઝાક્કૂરનો દીકરો શામ્મૂઆ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","શિમયોનના કુળમાંથી હોરીનો દીકરો શાફાટ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","યહૂદાના કુળમાંથી, યફૂન્નેનો દીકરો કાલેબ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ઇસ્સાખારના કુળમાંથી, યૂસફનો દીકરો ઈગાલ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","એફ્રાઇમના કુળમાંથી, નૂનનો દીકરો હોશિયા. ");
INSERT INTO guj2017_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","બિન્યામીનના કુળમાંથી, રાફુનો દીકરો પાલ્ટી. ");
INSERT INTO guj2017_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ઝબુલોનના કુળમાંથી, સોદીનો દીકરો ગાદીયેલ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","યૂસફના કુળમાંથી એટલે મનાશ્શા કુળમાંથી, સુસીનો દીકરો ગાદી. ");
INSERT INTO guj2017_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","દાન કુળમાંથી, ગમાલીનો દીકરો આમ્મીએલ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","આશેરના કુળમાંથી, મિખાએલનો દીકરો સથુર. ");
INSERT INTO guj2017_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","નફતાલીના કુળમાંથી, વોફસીનો દીકરો નાહબી. ");
INSERT INTO guj2017_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ગાદના કુળમાંથી, માખીરનો દીકરો ગુએલ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","જે પુરુષોને મૂસાએ દેશની જાસૂસી કરવા મોકલ્યા તેઓનાં નામ એ હતાં. મૂસાએ નૂનના દીકરા હોશિયાનું નામ બદલીને યહોશુઆ રાખ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","મૂસાએ તેઓને કનાન દેશની જાસૂસી કરવા મોકલ્યા અને તેઓને કહ્યું કે, “તમે નેગેબની દક્ષિણમાં થઈને ઉચ્ચ પ્રદેશમાં જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","તે દેશ કેવો છે તે જુઓ ત્યાં રહેનારા લોક બળવાન છે કે અબળ, થોડા છે કે ઘણાં? ");
INSERT INTO guj2017_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","જે દેશમાં તેઓ રહે છે તે કેવો છે સારો છે કે ખરાબ? તેઓ કેવા નગરોમાં રહે છે? શું તેઓ છાવણીઓ કે કિલ્લાઓમાં રહે છે? ");
INSERT INTO guj2017_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ત્યાંની જમીન ફળદ્રુપ છે કે ઉજ્જડ? વળી ત્યાં વૃક્ષો છે કે નહિ? તે જુઓ, નિર્ભય થઈને જાઓ અને તે દેશનું ફળ લેતા આવજો.” હવે તે સમય પ્રથમ દ્રાક્ષો પાકવાનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","તેથી તેઓ ઊંચાણમાં ગયા અને જઈને સીનના અરણ્યથી રહોબ સુધી એટલે હમાથની ઘાટી સુધી દેશની જાસૂસી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","તેઓ નેગેબમાંથી પસાર થયા અને હેબ્રોન પહોંચ્યા. ત્યાં અનાકપુત્રો અહીમાન, શેશાઈ અને તાલ્માય હતા. હેબ્રોન તો મિસરમાંના સોઆનથી સાત વર્ષ અગાઉ બંધાયું હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","જ્યારે તેઓ એશ્કોલના નીચાણમાં પહોચ્યા. ત્યાં તેઓએ દ્રાક્ષવેલાની ઝૂમખા કાપી લીધી. બે માણસોની વચ્ચમાં દાંડા ઉપર લટકાવીને તેને ઊંચકી લીધી. પછી કેટલાંક દાડમ અને અંજીર પણ તેઓ લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","જે દ્રાક્ષનું ઝૂમખું ઇઝરાયલીઓએ ત્યાંથી કાપ્યું તેના પરથી એ જગ્યાનું નામ એશ્કોલ પડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","તે દેશની જાસૂસી કરીને તે લોકો ચાળીસ દિવસ પછી પાછા આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","તેઓ ત્યાંથી મૂસા તથા હારુનની પાસે તથા ઇઝરાયલપુત્રોની આખી જમાત પાસે પારાનના અરણ્યમાં કાદેશમાં આવ્યા. અને તેઓને તથા આખી જમાતને તેઓએ જાણ કરી. અને તે દેશનાં ફળ તેઓને બતાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","તેઓએ મૂસાને કહ્યું, “તેં અમને જે દેશમાં મોકલ્યા ત્યાં અમે ગયા, તે ખરેખર દૂધ તથા મધથી રેલછેલવાળો દેશ છે. અને આ તેનું ફળ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","તોપણ તે દેશનાં લોકો શક્તિશાળી છે તેઓનાં નગરો વિશાળ અને કિલ્લેબંધીવાળા છે. વળી અમે ત્યાં અનાકપુત્રોને પણ જોયા. ");
INSERT INTO guj2017_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","અમાલેકીઓ નેગેબમાં રહે છે. અને પહાડી પ્રદેશોમાં હિત્તીઓ, યબૂસીઓ અને અમોરીઓ રહે છે. અને કનાનીઓ સમુદ્ર પાસે અને યર્દનને કાંઠે રહે છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","પછી કાલેબે મૂસાની પાસે ઊભા રહેલા લોકોને શાંત પાડ્યા અને કહ્યું, ચાલો, આપણે હુમલો કરી તે દેશનો કબજો લઈએ, કેમ કે આપણે તેને જીતી શકવા માટે સમર્થ છીએ.” ");
INSERT INTO guj2017_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","પણ જે માણસો તેઓની સાથે ગયા હતા તેઓએ કહ્યું કે, “આપણે એ લોકો ઉપર હુમલો કરી શકતા નથી. કેમ કે તેઓ આપણા કરતાં વધુ બળવાન છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","અને જે દેશની જાસૂસી તેઓએ કરી હતી, તે વિષે ઇઝરાયલ લોકોની પાસે તેઓ માઠો સંદેશો લાવ્યા.અને એમ કહ્યું કે, “જે દેશમાં અમે જાસૂસી કરવા માટે ફરી વળ્યા છીએ તે તેના વસનારાને ખાઈ જનાર દેશ છે ત્યાં અમે જોયેલા બધા માણસો બળવાન છે. ");
INSERT INTO guj2017_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ત્યાં અમે મહાકાય એટલે અનાકના વંશજોને પણ જોયા, તેઓની સામે અમે પોતાની દૃષ્ટિમાં તીડોના જેવા હતા. અને તેઓની નજરમાં અમે પણ એવા જ હતા.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","અને સમગ્ર સમાજે મોટે સાદે પોક મૂકી અને તે આખી રાત લોક રડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","અને સર્વ ઇઝરાયલીઓએ મૂસા અને હારુનની વિરુદ્ધ કચકચ કરી. સમગ્ર સમુદાયે તેઓને કહ્યું “આ અરણ્ય કરતાં તો અમે મિસરમાં જ મૃત્યુ પામ્યા હોત તો કેવું સારું થાત.! ");
INSERT INTO guj2017_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","તલવારથી મરવાને યહોવાહ અમને આ દેશમાં શા માટે લાવ્યા છે? અમારી સ્ત્રીઓ તથા બાળકોને તેઓ પકડી લેશે. આના કરતાં તો મિસર પાછા જવું એ અમારે માટે વધારે સારું ન હોય?!” ");
INSERT INTO guj2017_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","અને તેઓએ એકબીજાને કહ્યું કે, “ચાલો, આપણે કોઈને આગેવાન તરીકે પસંદ કરીએ અને પાછા મિસર જઈએ.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ત્યારે મૂસા તથા હારુન ઇઝરાયલ લોકોના ભેગા મળેલા સમગ્ર સમુદાય આગળ ઊંધા પડયા. ");
INSERT INTO guj2017_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","અને નૂનનો દીકરો યહોશુઆ તથા યફૂન્નેનો દીકરો કાલેબ જેઓ દેશની જાસૂસી કરનારાઓમાંનાં હતા. તેઓએ પોતાનાં વસ્ત્ર ફાડ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","અને તેઓએ ઇઝરાયલપુત્રોના સમગ્ર સમુદાયને કહ્યું કે, “અમે જે દેશની જાસૂસી કરવા ગયા હતા તે ખૂબ ઉતમ દેશ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","જો યહોવાહ આપણા પર પ્રસન્ન હશે, તો તે આપણને તે દેશમાં લઈ જશે અને તે આપણને આપશે. તે તો દૂધ તથા મધથી રેલછેલવાળો દેશ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","પણ યહોવાહની વિરુદ્ધ તમે દંગો ન કરશો, તેમ જ દેશના લોકોથી તમે ડરશો નહિ, કેમ કે તેઓને આપણે ખોરાકની પેઠે ખાઈ જઈશું. તેઓનો આશ્રય તેઓની પાસેથી જતો રહ્યો છે, કેમ કે યહોવાહ આપણી સાથે છે તેઓથી ડરશો નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","પણ સમગ્ર સમાજે કહ્યું કે, તેઓને પથ્થરે મારો. અને મુલાકાતમંડપમાં સર્વ ઇઝરાયલપુત્રોને યહોવાહનું ગૌરવ દેખાયું. ");
INSERT INTO guj2017_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","અને યહોવાહે મૂસાને કહ્યું કે, “આ લોકો કયાં સુધી મને ધિક્કારશે? તેઓ મધ્યે જે સર્વ ચિહ્નો મેં કર્યા છે તે છતાં પણ તેઓ કયા સુધી મારા પર વિશ્વાસ રાખશે નહિ? ");
INSERT INTO guj2017_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","હું મરકી ફેલાવીને તેમનો નાશ કરીશ અને તેઓને વતન વિનાના કરી નાખીશ. અને તેઓના કરતાં એક મોટી તથા બળવાન દેશજાતિ તારાથી ઉત્પન્ન કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","પણ મૂસાએ યહોવાહને કહ્યું કે, જો તમે આમ કરશો, તો મિસરીઓ તે વાત સાંભળશે. કેમ કે, તમે તમારા પરાક્રમથી તેઓ મધ્યેથી આ લોકોને બહાર લાવ્યા છો. ");
INSERT INTO guj2017_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","તેઓ આ દેશના રહેવાસીઓને કહેશે કે, તેઓએ સાભળ્યું છે કે, તમે યહોવાહ આ લોક મધ્યે છો. કેમ કે યહોવાહ તેઓને મુખ સમક્ષ દેખાય છે. અને તમારો મેઘ તમારા લોકની ઉપર થોભે છે. અને દિવસે મેઘસ્થંભમાં અને રાત્રે અગ્નિસ્થંભમાં તેઓની આગળ તમે ચાલો છો. ");
INSERT INTO guj2017_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","હવે જો તમે આ લોકોને એક માણસની જેમ મારી નાખશો તો જે દેશજાતિઓએ તમારી કીર્તિ સાંભળી છે તેઓ કહેશે કે, ");
INSERT INTO guj2017_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘યહોવાહે આ લોકોને જે દેશ આપવાના સોગન ખાધા હતા તેમાં તે તેઓને લાવી શક્યા નહિ, એટલે તેમણે તેઓને અરણ્યમાં મારી નાખ્યા.’” ");
INSERT INTO guj2017_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","માટે હવે હું તમને વિનંતી કરું છું કે, તમારું સામર્થ્ય બતાવો. જેમ તમે કહ્યું છે કે, ");
INSERT INTO guj2017_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","યહોવાહ ક્રોધ કરવામાં ધીમા તથા પુષ્કળ દયાળુ છો. અને અન્યાય તથા અપરાધોની ક્ષમા આપનાર છે. તથા કોઈ પણ પ્રકારે દોષિતને નિર્દોષ નહિ ઠરાવનાર અને પિતાઓના અન્યાયનો બદલો ત્રીજી તથા ચોથી પેઢીનાં બાળકો પાસેથી લેનાર છે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","હું તમને વિનંતી કરું છું કે, તમારી દયાના માહાત્મય પ્રમાણે અને જેમ તમે મિસરથી માંડીને આજ પર્યંત તેઓને પાપની માફી આપી છે, તે પ્રમાણે તેઓને ક્ષમા કરો.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","યહોવાહે કહ્યું કે, “તારા કહેવા મુજબ મેં તેઓને ક્ષમા કરી છે, ");
INSERT INTO guj2017_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","પણ નિશ્ચે હું જીવતો છું. અને આખી પૃથ્વી યહોવાહના ગૌરવથી ભરપૂર થશે, ");
INSERT INTO guj2017_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","જે સર્વ લોકોએ મારું ગૌરવ અને મિસરમાં તથા અરણ્યમાં મારા ચમત્કારો જોયા છતાં દસ વખત મારું પારખું કર્યું છે અને મારી વાણી સાંભળી નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","મેં તેઓના પિતૃઓને જે દેશ આપવાનું વચન આપ્યું હતું તે તેઓ નહિ જ જોશે. તેમ જ મને તુચ્છકારનાર કોઈ પણ તે દેશને જોવા પામશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","સિવાય મારો સેવક કાલેબ કેમ કે તેને જુદો આત્મા હતો. અને તે મારા માર્ગમાં સંપૂર્ણપણે ચાલ્યો છે. તે માટે જે દેશમાં એ ગયો છે તે દેશમાં હું તેને લઈ જઈશ અને તેના સંતાન તેનું વતન પ્રાપ્ત કરશે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","હાલ અમાલેકીઓ અને કનાનીઓ મેદાનમાં વસે છે. તેથી કાલે તમે પાછા ફરો અને સૂફ સમુદ્રને રસ્તે પાછા અરણ્યમાં જાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","યહોવાહ મૂસા અને હારુનની સાથે બોલ્યા. તેમણે કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“આ દુષ્ટ લોકો જે મારી વિરુદ્ધ કચકચ કરે છે તેઓનું હું ક્યાં સુધી સહન કરું? ઇઝરાયલી લોકોની કચકચ જે તેઓ મારી વિરુદ્ધ કરે છે તે સર્વ મેં સાંભળી છે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","યહોવાહ કહે છે કે, તેઓને કહે કે, ‘હું જીવિત છું,’ જેમ તમે મારા કાનોમાં બોલ્યા તેમ હું નક્કી કરીશ; ");
INSERT INTO guj2017_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","અને તમારા મૃતદેહ આ અરણ્યમાં પડશે. જેઓએ મારા વિરુદ્ધ કચકચ કરી છે અને તમારામાંના જેઓની ગણતરી થઈ છે એટલે વીસ વર્ષની ઉંમરના અને તેથી વધારે ઉપરના તેઓની સંખ્યામાંના તમારા લોકો. ");
INSERT INTO guj2017_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","મેં તમને જે દેશમાં વસાવવાનું વચન આપ્યું હતું તેમાં જવા નહિ જ પામશે. ફક્ત યફૂન્નેનો દીકરો કાલેબ અને નૂનનો દીકરો યહોશુઆ જ તેમાં પ્રવેશ કરશે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","પણ તમારાં સંતાનો જેઓના વિષે તમે કહ્યું કે, તેઓ લૂંટરૂપ થઈ જશે. તેઓને હું અંદર લાવીશ. જે દેશનો તમે અસ્વીકાર કર્યો છે. તેનો તેઓ અનુભવ કરશે! ");
INSERT INTO guj2017_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","પણ તમારા મૃતદેહો તો આ અરણ્યમાં પડશે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","અને ચાળીશ વર્ષ સુધી તમારા સંતાનો અરણ્યમાં ભટકશે. અને તમારા ગુનાઓનું ફળ ભોગવશે જ્યાં સુધી કે અરણ્યમાં તમારા મૃતદેહો નાશ પામે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","જેટલા દિવસમાં તમે તે દેશની જાસૂસી કરી એટલે ચાળીસ દિવસ તેઓની સંખ્યા મુજબ એક એક દિવસને બદલે એક એક વર્ષ લેખે એટલે ચાળીસ વર્ષ સુધી તમે તમારાં વ્યભિચારનું ફળ ભોગવશો. ");
INSERT INTO guj2017_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","હું યહોવાહ બોલ્યો છું કે, નિશ્ચે આ દુષ્ટ પ્રજા જે મારી આગળ એકઠી થઈ છે તેઓને હું આ પ્રમાણે કરીશ. આ અરણ્યમાં તેઓનો અંત થશે અને અહીં તેઓ મૃત્યુ પામશે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","અને જે માણસોને મૂસાએ દેશની જાસૂસી કરવા માટે મોકલ્યા હતા. તેમાંના જેઓ પાછા આવ્યા અને દેશ વિષે ખરાબ સંદેશો લાવીને આખી પ્રજાની પાસે તેની વિરુદ્ધ કચકચ કરાવી. ");
INSERT INTO guj2017_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","જે લોકો દેશ વિષે ખરાબ સંદેશો લાવ્યા તેઓ યહોવાહની આગળ મરકીથી માર્યા ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","પણ જેઓ દેશની જાસૂસી કરવા ગયા હતા તેઓમાંનો નૂનનો દીકરો યહોશુઆ તથા યફૂન્નેનો દીકરો કાલેબ જીવતા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","જ્યારે મૂસાએ આ સર્વ વાતો ઇઝરાયલી લોકોને કહી અને ત્યારે તેઓએ બહુ શોક કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","અને તેઓ વહેલી સવારે ઊઠયા અને પર્વતના શિખર પર જઈને કહ્યું કે, “જુઓ, આપણે અહીં છીએ. અને જે જગ્યા વિષે યહોવાહે વચન આપ્યું હતું ત્યાં આપણે જઈએ, કેમ કે આપણે પાપ કર્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","પણ મૂસાએ કહ્યું, તમે યહોવાહની આજ્ઞાનું ઉલ્લંઘન કેમ કરો છો? તમે સફળ થશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","આગળ જશો નહિ, કેમ કે યહોવાહ તમારી મધ્યે નથી રખેને તમારા શત્રુઓ તમને હરાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","પણ અમાલેકીઓ અને કનાનીઓ ત્યાં તમારી આગળ છે અને તમે તલવારથી મરશો કેમ કે તમે યહોવાહને અનુસરવાથી પાછા ફર્યા છો. તેથી તેઓ તમારી સાથે નહિ રહે.” ");
INSERT INTO guj2017_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","હવે તેઓ પર્વતના શિખર પર ચઢી ગયા. પરંતુ યહોવાહનો કરારકોશ અને મૂસા છાવણીમાંથી બહાર ન ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","પછી અમાલેકીઓ અને કનાનીઓ જેઓ તે પર્વતોમાં રહેતા હતા તેઓ નીચે ઊતરી આવ્યા. અને તેઓએ ઇઝરાયલીઓ પર હુમલો કર્યો અને તેઓને હોર્મા સુધી નસાડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","પછી યહોવાહ મૂસા સાથે બોલ્યા. તેમણે કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","ઇઝરાયલી લોકોને કહે કે, તમારા વસવાટ માટેનો જે દેશ યહોવાહ તમને આપે છે તેમાં જયારે તમે પ્રવેશો ત્યારે, ");
INSERT INTO guj2017_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","અને જ્યારે તમે અર્પણ માટે ઐચ્છિકાર્પણ તરીકે તમારા નક્કી કરેલા પર્વોમાં યહોવાહને સારુ સુવાસને અર્થે ઘેટાંબકરાંનો કે અન્ય જાનવરોના હોમયજ્ઞ તથા દહનીયાર્પણ અથવા યજ્ઞ ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ત્યારે પોતાનું અર્પણ કરતી વખતે અર્પણ ચઢાવનારે એની સાથે પા હિન ચોથા ભાગના તેલથી મોહેલા એક દશાંશ એફાહ મેંદાનું ખાદ્યાર્પણ યહોવાહને અર્પણ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","અને દરેક હલવાનને સારુ દહનીયાર્પણ સાથે કે યજ્ઞ સાથે પા હિન દ્રાક્ષારસનું પેયાર્પણ તું તૈયાર કર. ");
INSERT INTO guj2017_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","જો તું ઘેટાંનું અર્પણ ચઢાવે તો, એક તૃતીયાંશ હિન તેલથી મોહેલા બે દશાંશ એફાહ મેંદાનું ખાદ્યાપર્ણ તૈયાર કર. ");
INSERT INTO guj2017_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","અને એક તૃતીયાંશ હિન દ્રાક્ષારસનું સુવાસિત પેયાર્પણ યહોવાહને ચઢાવ. ");
INSERT INTO guj2017_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","અને જ્યારે તું દહનીયાર્પણ કે પ્રતિજ્ઞા પૂર્ણ કરવાના યજ્ઞને માટે અથવા યહોવાહને માટે શાંત્યર્પણોને સારુ બળદ તૈયાર કરે, ");
INSERT INTO guj2017_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ત્યારે તે બળદ સાથે અડધા હિન તેલથી મોહેલા ત્રણ દશાંશ એફાહ મેંદાનું ખાદ્યાર્પણ ચઢાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","અને યહોવાહને માટે સુવાસિત પેયાર્પણ તરીકે અર્ધો હિન દ્રાક્ષારસ હોમયજ્ઞ તરીકે ચઢાવ. ");
INSERT INTO guj2017_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","પ્રત્યેક બળદ વિષે, કે પ્રત્યેક ઘેટા વિષે કે પ્રત્યેક નર હલવાન વિષે, કે પ્રત્યેક બકરીના બચ્ચા વિષે આ પ્રમાણે કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","પ્રત્યેક બલિદાન જે તું તૈયાર કરી અને અર્પણ કરે તેના સંબંધમાં અહીં દર્શાવ્યાં મુજબ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","યહોવાહ પ્રત્યે સુવાસિત હોમયજ્ઞ ચઢાવવામાં જે સર્વ ઇઝરાયલના વતનીઓ છે, તેઓએ તે કાર્યો આ રીતે કરવા. ");
INSERT INTO guj2017_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","અને જો કોઈ પરદેશી તમારી સાથે રહેતો હોય, અથવા તમારા લોકની પેઢીનું જે કોઈ તમારી વચ્ચે રહેતું હોય અને જો તે યહોવાહને સારુ સુવાસિત હોમયજ્ઞ ચઢાવવા ઇચ્છે તો તે જેમ તમે કરો છો તે મુજબ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","આ નિયમ તમારે માટે તથા તમારી સાથે રહેતા વિદેશીઓ માટે સમાન છે અને તે નિયમ સદાને માટે તમારા લોકના વંશજોને સારુ હોય. જેમ તમે છો તેમ યહોવાહ સમક્ષ વિદેશી પણ હોય. ");
INSERT INTO guj2017_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","તમારે સારુ તથા તમારી સાથે રહેતા વિદેશી માટે એક જ નિયમ તથા એક જ કાનૂન હોય.’” ");
INSERT INTO guj2017_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","પછી યહોવાહ મૂસા સાથે બોલ્યા. તેમણે કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ઇઝરાયલપુત્રોને એમ કહે કે, જે દેશમાં હું તમને લઈ જાઉં છું ત્યાં તમે આવો પછી, ");
INSERT INTO guj2017_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","જ્યારે તમે એ દેશનું અનાજ ખાઓ ત્યારે તમારે યહોવાહને અર્પણ ચઢાવવું. ");
INSERT INTO guj2017_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ઉચ્છાલીયાર્પણને માટે પ્રથમ બાંધેલા લોટની પૂરી ચઢાવવી. જેમ ખળીનું ઉચ્છાલીયાર્પણ કરો છો તેમ તમારે તેને ઉપર ઉઠાવવી. ");
INSERT INTO guj2017_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","તમે બાંધેલા લોટમાંથી પ્રથમ ભાગ તમારે યહોવાહ માટે ઉચ્છાલીયાર્પણ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","જ્યારે તમે અજાણતામાં આવી સરતચૂક કરો અને મારા હસ્તક મૂસાને કહેલી આજ્ઞાઓનું પાલન ન કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","એટલે જે સર્વ આજ્ઞાઓ યહોવાહે મૂસા મારફતે તમને આપી છે તે યહોવાહે જે દિવસે આજ્ઞા આપી ત્યારથી માંડીને પેઢી દરપેઢી પાલન નહિ કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","અને જો આખા સમાજે અજાણતામાં ભૂલ કરી હોય, તો આખી પ્રજા યહોવાહને સુવાસને અર્થે દહનીયાર્પણ તરીકે એક વાછરડો અને તેની સાથે ખાદ્યાર્પણ તથા પેયાર્પણ શુધ્ધા વિધિ મુજબ ચઢાવે. આ સાથે પાપાર્થાર્પણ તરીકે એક બકરાનું પણ અર્પણ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","યાજક સમગ્ર ઇઝરાયલ સમાજ માટે પ્રાયશ્ચિત કરે અને તેઓને માફ કરવામાં આવશે. કેમ કે એ સરતચૂક હતી અને તેઓ પોતાનું અર્પણ એટલે તેમને માટે હોમયજ્ઞ તથા પોતાની ભૂલને લીધે પાપાર્થાર્પણ લાવ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","તેથી સમગ્ર ઇઝરાયલ સમાજને અને તેમની સાથે વસતા વિદેશીઓને પણ માફ કરવામાં આવશે, કારણ કે સઘળા લોકથી અજાણતામાં એ પાપ થયું હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","જો કોઈ વ્યક્તિ અજાણતામાં પાપ કરે, તો તેણે એક વર્ષની બકરી પાપાર્થાર્પણ તરીકે ચઢાવવી. ");
INSERT INTO guj2017_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","અને અજાણતામાં પાપ કરનારને યાજક યહોવાહ સમક્ષ પ્રાયશ્ચિત કરે તો તે વ્યક્તિને તેની ભૂલ માફ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","અજાણતામાં પાપ કરનાર પ્રત્યેક માટે, એટલે કે ઇઝરાયલના વતની માટે અને તેઓ મધ્યે વસનાર વિદેશી માટે આ એક જ નિયમ રાખવો. ");
INSERT INTO guj2017_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","પણ જો કોઈ વ્યક્તિ પછી તે ઇઝરાયલનાં વતની હોય કે વિદેશી હોય પણ જાણી જોઈને ઇરાદાપૂર્વક તે પાપ કરે તો તે મારું અપમાન કરે છે. તે માણસ પોતાના લોકોમાંથી અલગ કરાય. ");
INSERT INTO guj2017_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","તેણે મારું વચન ગણકાર્યું નથી અને મારી આજ્ઞા તોડી છે. તેથી એ માણસનો સંપૂર્ણ બહિષ્કાર કરવો. તેનો અન્યાય તેના માથે.’” ");
INSERT INTO guj2017_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","જ્યારે ઇઝરાયલી લોકો અરણ્યમાં હતા, ત્યારે તેઓએ એક માણસને વિશ્રામવારે લાકડાં વીણતા જોયો. ");
INSERT INTO guj2017_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","જેઓએ તેને જોયો તેઓ તેને મૂસા, હારુન અને સમગ્ર સમાજ પાસે લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","તેઓએ તેને બંદીખાનામાં રાખ્યો કેમ કે તેઓને શું કરવું તે હજી નક્કી થયું નહોતું. ");
INSERT INTO guj2017_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","પછી યહોવાહે મૂસાને કહ્યું, “તે માણસ નક્કી માર્યો જાય. સમગ્ર સમાજ એને છાવણી બહાર લાવી પથ્થરે મારે.” ");
INSERT INTO guj2017_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","તેથી યહોવાહે મૂસાને આજ્ઞા કરી હતી તે મુજબ સમગ્ર સમાજ તેને છાવણીની બહાર લઈ ગયા અને પથ્થરે માર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","વળી, યહોવાહ મૂસા સાથે બોલ્યા. તેમણે કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ઇઝરાયલ લોકોને તું કહે અને આજ્ઞા કર કે, વંશપરંપરા પોતાના વસ્ત્રને કિનારીઓ લગાડે દરેક કિનારીઓની કોર પર ભૂરા રંગની પટ્ટીઓ કિનારી લગાડે. ");
INSERT INTO guj2017_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","તે જોઈને તમને યહોવાહની સર્વ આજ્ઞાઓનું સ્મરણ થશે અને તમે એનું પાલન કરશો તથા તમારું અંતઃકરણ તથા તમારી પોતાની આંખો કે, જે ગણિકાઓની પાછળ ભટકી જવાની તમને ટેવ પડી છે તેઓની પાછળ ખેંચાશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","જેથી તમે મારી સર્વ આજ્ઞાઓ પાળવાનું યાદ રાખો અને તમારા ઈશ્વરની આગળ પવિત્ર બનો. ");
INSERT INTO guj2017_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","હું યહોવાહ તમારો ઈશ્વર છું. કે જે તમને મિસર દેશમાંથી તમારો ઈશ્વર થવાને બહાર લાવ્યો છે. હું યહોવાહ તમારો ઈશ્વર છું.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","લેવીના દીકરા કહાથના દીકરા યિસ્હારનો દીકરો કોરા, અલિયાબના દીકરા દાથાન તથા અબિરામ તથા પેલેથનો દીકરો ઓન, એ રુબેનના વંશજોએ કેટલાક માણસોને ભેગા કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","અને તેઓ ઇઝરાયલ લોકોમાંના કેટલાક એટલે પ્રજાના બસો પચાસ આગેવાનો કે જેઓ સભા માટે નિમંત્રાયેલા નામાંકિત માણસો હતા તેઓને લઈને મૂસાની સામે ઊભા થયા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","મૂસા તથા હારુનની વિરુદ્ધ તેઓએ સભા બોલાવીને તેઓને કહ્યું, “તમે હવે હદ પાર કરો છો. આખી જમાત પવિત્ર છે, તેઓમાંનો દરેક યહોવાહ માટે મુકરર કરાયેલો છે અને યહોવાહ તેઓની મધ્યે છે. તમે પોતાને યહોવાહની જમાત કરતાં ઊંચા શા માટે કરો છો?” ");
INSERT INTO guj2017_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","જ્યારે મૂસાએ આ સાંભળ્યું ત્યારે તે ઊંધો પડી ગયો. ");
INSERT INTO guj2017_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","તે કોરા તથા તેની આખી ટોળી સાથે બોલ્યો, તેણે કહ્યું, “સવારે યહોવાહ બતાવશે કે કોણ તેઓના છે અને કોણ યહોવાહ માટે મુકરર કરાયેલા છે. જેને તેઓ પસંદ કરશે તેને ઈશ્વર પોતાની પાસે બોલાવશે. યહોવાહ તેને પોતાની પાસે બોલાવશે. ");
INSERT INTO guj2017_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","કોરા તથા તારી આખી ટોળી આ પ્રમાણે કરો. ધૂપપાત્ર લો ");
INSERT INTO guj2017_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","આવતીકાલે અગ્નિ તથા ધૂપ લઈ યહોવાહની આગળ મૂકો. યહોવાહ જેને પસંદ કરશે, જે મુકરર થયેલ છે તે વ્યક્તિ પવિત્ર બનશે. હે લેવીના વંશજ તમે ઘણાં દૂર જતા રહ્યા છો.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ફરીથી, મૂસાએ કોરાને કહ્યું, “ઓ લેવીના વંશજો, હવે સાંભળો: ");
INSERT INTO guj2017_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ઇઝરાયલના ઈશ્વરે તમને પોતાની નજીક લાવવા માટે, તેમના મંડપની સેવા કરવા માટે અને તેમના લોકની સામે ઊભા રહીને તેમની સેવા કરવા માટે ઇઝરાયલ પ્રજામાંથી અલગ કર્યા છે શું એ તમને ઓછું લાગે છે? ");
INSERT INTO guj2017_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","તેઓ તને તથા તારી સાથેના સર્વ ભાઈઓ એટલે લેવીના દીકરાઓને નજીક લાવ્યા છે, તમે હજી પણ યાજકપદ માગો છો? ");
INSERT INTO guj2017_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","તેથી તું અને તારી આખી ટોળી યહોવાહની વિરુદ્ધ એકત્ર થયાં છો. તો તમે શા માટે હારુન વિષે ફરિયાદ કરે છો, કોણ યહોવાહની આજ્ઞા પાળે છે?” ");
INSERT INTO guj2017_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","પછી મૂસાએ અલિયાબના દીકરા દાથાનને અને અબિરામને બોલાવ્યા, પણ તેઓએ કહ્યું કે, “અમે ત્યાં નહિ આવીએ. ");
INSERT INTO guj2017_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","તમે અમને દૂધ તથા મધથી રેલછેલવાળો દેશમાંથી આ અરણ્યમાં મરવા માટે લઈ આવ્યા એટલું ઓછું છે કે તમે અમારા પર પાછા સત્તા ચલાવવા માગો છો? ");
INSERT INTO guj2017_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","તદુપરાંત, તમે અમને દૂધ તથા મધથી રેલછેલવાળો દેશમાં નથી લાવ્યા અને તમે અમને ખેતરો કે દ્રાક્ષવાડીઓનો વારસો નથી આપ્યો. શું તમે અમને ખાલી વચન આપીને મૂર્ખ બનાવશો? અમે તમારી પાસે નહિ આવીએ.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","મૂસાને ઘણો ક્રોધ ચઢ્યો અને તેણે યહોવાહને કહ્યું, “તેઓના અર્પણનો સ્વીકાર કરશો નહિ. મેં તે લોકો પાસેથી એક ગધેડું પણ લીધું નથી અને તેઓમાંના કોઈનું કંઈ નુકસાન પણ કર્યુ નથી.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","એટલે મૂસાએ કોરાને કહ્યું, “તું અને તારા સર્વ સાથીઓ એટલે તું, તેઓ અને હારુન આવતીકાલે યહોવાહની આગળ જજો. ");
INSERT INTO guj2017_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","તમારામાંનો પ્રત્યેક માણસ પોતાનું ધૂપપાત્ર લે તેમાં ધૂપ નાખે. પછી પ્રત્યેક માણસ પોતાનું ધૂપપાત્ર એટલે બસો પચાસ ધૂપપાત્રો યહોવાહ સમક્ષ લાવે. તું અને હારુન પોતપોતાનાં ધૂપપાત્ર લાવો.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","તેથી તે પ્રત્યેક માણસે પોતાનું ધૂપપાત્ર લીધું, તેમાં અગ્નિ મૂક્યો તથા ધૂપ નાખ્યું અને મૂસા તથા હારુનની સાથે મુલાકાતમંડપના પ્રવેશદ્વાર આગળ આવીને ઊભા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","કોરાએ આખી જમાતને મૂસા તથા હારુન વિરુદ્ધ મુલાકાતમંડપના દ્વાર પાસે એકઠી કરી અને આખી જમાતને યહોવાહનું ગૌરવ દેખાયું. ");
INSERT INTO guj2017_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","પછી યહોવાહ મૂસા તથા હારુન સાથે બોલ્યા; ");
INSERT INTO guj2017_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“આ જમાત મધ્યેથી પોતાને અલગ કરો કે હું તેઓનો તરત જ નાશ કરું.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","મૂસાએ તથા હારુને સાષ્ટાંગ પ્રણામ કર્યા અને કહ્યું, “ઈશ્વર, સર્વ માનવજાતના આત્માઓના ઈશ્વર, જો એક માણસ પાપ કરે તો શું તમે આખી જમાત પ્રત્યે કોપાયમાન થશો?” ");
INSERT INTO guj2017_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","યહોવાહે મૂસાને ઉત્તર આપ્યો. તેમણે કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“જમાત સાથે વાત કર. કહે કે, કોરા, દાથાન તથા અબિરામના તંબુઓથી દૂર જાઓ.’” ");
INSERT INTO guj2017_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","પછી મૂસા ઊઠીને દાથાન તથા અબિરામની પાસે ગયો; ઇઝરાયલના વડીલો તેની પાછળ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","મૂસાએ જમાત સાથે વાત કરીને કહ્યું કે, “હવે આ દુષ્ટ માણસોના તંબુઓ પાસેથી દૂર જાઓ અને એમની કોઈ વસ્તુને અડકશો નહિ. રખેને તેઓનાં બધાં પાપોને કારણે તમારો નાશ થાય.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","તેથી જમાત કોરા, દાથાન તથા અબિરામના તંબુઓની દરેક બાજુએથી ચાલ્યા ગયા. દાથાન તથા અબિરામ પોતાની પત્નીઓ, દીકરાઓ તથા નાનાં બાળકો સાથે બહાર નીકળીને તંબુઓના પ્રવેશદ્વાર આગળ આવીને ઊભા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","પછી મૂસાએ કહ્યું, “આ દ્વારા તમને જાણશો કે યહોવાહે આ સર્વ કામ કરવા મને મોકલ્યો છે, કેમ કે એ કામો મેં મારી પોતાની જાતે કર્યાં નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","જો આ લોકો બીજા બધા માણસોની જેમ કુદરતી રીતે મૃત્યુ પામે તો માનવું કે યહોવાહે મને મોકલ્યો નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","પણ જો યહોવાહ કરે અને પૃથ્વી પોતાનું મુખ ઉઘાડીને તેઓને તથા તેઓની બધી જ વસ્તુઓને સ્વાહા કરી જાય અને તેઓ જીવતેજીવત મૃત્યુલોકમાં ગરક થઈ જાય તો તમારે જાણવું કે, એ માણસોએ યહોવાહને ધિક્કાર્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","મૂસાએ આ સર્વ વાતો બોલવાનું પૂરું કર્યું કે તરત જ તે લોકોના પગ નીચેની ધરતી ફાટી. ");
INSERT INTO guj2017_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","પૃથ્વી પોતાનું મુખ ઉઘાડીને તેઓને તથા તેમનાં કુટુંબો અને કોરાના સર્વ માણસોને તથા તેઓની સર્વ માલમિલકતને સ્વાહા કરી ગઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","તેઓ અને તેઓનાં ઘરનાં સર્વ જીવતાં જ મૃત્યુલોકમાં પહોંચી ગયાં. પૃથ્વીએ તેઓને ઢાંકી દીધાં અને આ રીતે તેઓ સમુદાયમાંથી નાશ પામ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","તેમની ચીસો સાંભળીને આસપાસ ઊભેલા બધા ઇઝરાયલીઓ નાસવા માંડયા. તેઓએ કહ્યું, “રખેને આપણને પણ ધરતી ગળી જાય!” ");
INSERT INTO guj2017_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","પછી યહોવાહ પાસેથી અગ્નિ ધસી આવ્યો અને ધૂપ ચઢાવવા આવેલા અઢીસો માણસોને ભસ્મ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","પછી યહોવાહ મૂસા સાથે બોલ્યા તેમણે કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“હારુન યાજકના દીકરા એલાઝાર સાથે વાત કર અને કહે કે, અગ્નિમાંથી ધૂપદાનીઓ લઈ લે, કેમ કે તે ધૂપ પવિત્ર છે, મારા માટે મુકરર થયેલ છે. તે કોલસા અને રાખ વિખેરી નાખ. ");
INSERT INTO guj2017_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","જેઓએ પાપ કરીને પોતાનો જીવ ગુમાવ્યો છે તે ધૂપપાત્ર લઈ લે. તેમને ટીપીને વેદીને ઢાંકવા માટે પતરાં બનાવવાં. તે પુરુષોએ તેઓનું અર્પણ મને કર્યું, તેથી તેઓ પવિત્ર છે, મારા માટે મુકરર કરેલ છે. તેઓ ઇઝરાયલી લોકોને માટે ચિહ્નરૂપ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","તેઓએ જે પિત્તળનાં ધૂપપાત્રનું અર્પણ કર્યું હતું તે યાજક એલાઝારે લીધાં. મૂસા દ્વારા યહોવાહ જેમ બોલ્યા હતા તે મુજબ તેણે તેઓને ટીપીને વેદીને ઢાંકવા માટે આવરણ બનાવડાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","તે ઇઝરાયલીપુત્રોને માટે સ્મરણમાં રહે કે, જેથી કોઈ વ્યક્તિ એટલે હારુનના વંશજમાંની કોઈ પણ વ્યક્તિએ યહોવાહ સમક્ષ ધૂપ ચઢાવવાને આવવું નહિ. આ રીતે, તેના હાલ કોરા અને તેના સાથીઓ જેવા ન થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","પરંતુ બીજે દિવસે આખી ઇઝરાયલી જમાતે મૂસા અને હારુનની વિરુદ્ધ ફરિયાદ કરી. તેઓએ કહ્યું કે, “તમે યહોવાહના લોકોને મારી નાખ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","જ્યારે મૂસા અને હારુનની વિરુદ્ધ સમગ્ર સમાજ એકઠો થયો ત્યારે એમ થયું કે, તેઓએ મુલાકાતમંડપ તરફ જોયું તો એકાએક વાદળે તેના પર આચ્છાદન કર્યું. યહોવાહનું ગૌરવ દેખાયું. ");
INSERT INTO guj2017_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","અને મૂસા તથા હારુન મુલાકાતમંડપ આગળ જઈને ઊભા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","પછી યહોવાહ મૂસા સાથે બોલ્યા. તેમણે કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“આ જમાત આગળથી દૂર જાઓ જેથી હું તેઓનો તરત જ નાશ કરું.” એટલે મૂસા અને હારુન જમીન પર ઊંધા પડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","મૂસાએ હારુનને કહ્યું, “ધૂપદાની લે, વેદીમાંથી અગ્નિ લે અને તેમાં નાખ, તેમાં ધૂપ નાખ, તરત જ તે જમાત પાસે લઈ જા અને તેમના પાપનું પ્રાયશ્ચિત કર, કેમ કે યહોવાહનો કોપ આવ્યો છે. મરકી શરૂ થઈ છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","આથી મૂસાના કહ્યા પ્રમાણે હારુને કર્યું. તે જમાતની વચ્ચે દોડી ગયો. લોકોમાં મરકી ફેલાવાનું શરુ થયું, તેથી તેણે ધૂપ નાખી લોકોને સારુ પ્રાયશ્ચિત કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","હારુન મરેલા તથા જીવતાઓની વચ્ચે ઊભો રહ્યો; આ પ્રમાણે મરકી બંધ થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","કોરાની બાબતમાં જેઓ મૃત્યુ પામ્યાં હતાં તેઓ ઉપરાંત મરકીથી મર્યા તેઓની સંખ્યા ચૌદ હજાર સાતસો હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","હારુન મુલાકાતમંડપના પ્રવેશ દ્વાર આગળ મૂસા પાસે પાછો આવ્યો અને મરકી બંધ થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","યહોવાહ મૂસા સાથે બોલ્યા. તેમણે કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“તું ઇઝરાયલી લોકોને કહે કે તેઓની પાસેથી એટલે તેઓના પૂર્વજોના કુળદીઠ એક તે મુજબ લાકડીઓ લેવી એટલે તેઓના સર્વ આગેવાનો પાસેથી તેઓના પિતાઓનાં ઘર મુજબ બાર લાકડી લે અને દરેક માણસનું નામ તેની લાકડી પર લખ. ");
INSERT INTO guj2017_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","લેવીની લાકડી પર તું હારુનનું નામ લખ; કેમ કે તેઓના પૂર્વજોના કુળના દરેક આગેવાનને માટે એકેક લાકડી હોય. ");
INSERT INTO guj2017_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","કરારની સામેના મુલાકાતમંડપમાં કે જ્યાં હું તને મળું છું ત્યાં તારે આ લાકડીઓ મૂકવી. ");
INSERT INTO guj2017_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","અને એવું થશે કે જે માણસને હું પસંદ કરીશ તેની લાકડીને અંકુર ફૂટી નીકળશે. આ રીતે હું ઇઝરાયલી લોકો જે તારી વિરુદ્ધ બોલે છે તેઓની ફરિયાદોને બંધ કરીશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","તેથી મૂસાએ બધા ઇઝરાયલી લોકોને કહ્યું. બધા કુળના આગેવાનોએ પોતાની લાકડી તેને આપી, દરેક આગેવાન પાસેથી એક લાકડી, તેમનાં પિતૃઓના કુળો પ્રમાણે એકેક લાકડી, એમ કુલ બાર લાકડી. હારુનની લાકડી પણ તેઓની લાકડીઓ વચ્ચે હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","પછી મૂસાએ લાકડીઓ મુલાકાતમંડપની અંદરના સાક્ષ્યમંડપમાં યહોવાહની સમક્ષ મૂકી. ");
INSERT INTO guj2017_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","બીજે દિવસે મૂસા સાક્ષ્યમંડપમાં ગયો ત્યારે જુઓ, હારુનની લાકડી જે લેવીના કુળને માટે હતી તે ફૂટી નીકળી હતી. તેને અંકુર ફૂટ્યા હતા, ફૂલો ખીલ્યાં હતા અને પાકી બદામો પણ લાગી હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","મૂસા યહોવાહની સમક્ષતામાંથી બધી લાકડીઓ ઇઝરાયલી પાસે બહાર લાવ્યો. દરેક માણસે પોતાની લાકડી શોધી અને લઈ લીધી. ");
INSERT INTO guj2017_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","યહોવાહે મૂસાને કહ્યું, “હારુનની લાકડી સાક્ષ્યમંડપની સમક્ષ મૂક. બળવો કરનારા લોકો વિરુદ્ધ ચિહ્ન તરીકે મૂક, જેથી મારી વિરુદ્ધ તેમની આ ફરિયાદોનો અંત આવે અને તેમને મરવું પડે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","યહોવાહે જેમ આજ્ઞા આપી હતી તે પ્રમાણે મૂસાએ કર્યુ. ");
INSERT INTO guj2017_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ઇઝરાયલી લોકોએ મૂસાને કહ્યું, “આપણે અહીં મરી જઈશું. અમે બધા નાશ પામીએ છીએ! ");
INSERT INTO guj2017_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","જે કોઈ ઉપર જાય છે, એટલે યહોવાહના મંડપ પાસે જાય છે, તે માર્યો જાય છે. તો શું અમે બધા નાશ પામીએ?” ");
INSERT INTO guj2017_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","યહોવાહે હારુનને કહ્યું, “પવિત્રસ્થાન વિરુદ્ધ કરેલાં બધા પાપો માટે તું, તારા દીકરાઓ અને તારા પિતૃઓના કુટુંબો જવાબદાર છે. પણ તું અને તારી સાથે તારા દીકરાઓ યાજકપદની વિરુદ્ધ કરેલાં પાપો માટે જવાબદાર છે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","લેવી કુળના તારા ભાઈઓને, એટલે તારા પિતૃઓના કુળને, તારી પાસે લાવ કે જયારે તું અને તારા દીકરાઓ સાક્ષ્યમંડપની આગળ સેવા કરો ત્યારે તેઓ તમને મદદ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","તેઓ તારી તથા આખા મંડપની સેવા કરે. પણ, તેઓએ પવિત્રસ્થાનનાં પાત્રો કે વેદીની નજીક આવવું નહિ. કે તેઓ તથા તું માર્યા જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","તેઓ તમારી સાથે જોડાઈને મુલાકાતમંડપની સેવા કરશે, મંડપ સાથે જોડાયેલાં બધાં કાર્યો કરશે. પરદેશી તમારી પાસે આવે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","અને તમે પવિત્રસ્થાન અને વેદીની સેવા કરો કે જેથી ઇઝરાયલ લોકો પર ફરી મારો કોપ આવે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","જુઓ, મેં પોતે ઇઝરાયલના વંશજો મધ્યેથી તારા લેવી ભાઈઓને પસંદ કર્યા છે. મુલાકાતમંડપ સાથે જોડાયેલાં કાર્યો કરવા માટે તેઓ મને ભેટ તરીકે આપવામાં આવ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","પરંતુ તું અને તારા દીકરાઓ વેદીને અને પડદાની અંદર પરમપવિત્રસ્થાનને લગતી યાજક તરીકેની બધી જ ફરજો બજાવો અને સેવા કરો. ભેટ તરીકે હું તમને યાજકપદ આપું છું. કોઈ પરદેશી પાસે આવે તે માર્યો જાય.” ");
INSERT INTO guj2017_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","વળી યહોવાહે હારુનને કહ્યું, “જુઓ, મેં ઉચ્છાલીયાર્પણોની સેવા તને આપી છે, એટલે ઇઝરાયલી લોકો જે બધા પવિત્ર અર્પણો મને આપે છે. તેં મેં તમને તથા તમારા દીકરાઓને સદાના હક તરીકે આપ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","અગ્નિમાં હોમવામાં આવેલા અર્પણનાં ભાગો સિવાય આ બધાં અતિ પવિત્ર અર્પણો તારાં ગણાશે. એટલે બધાં ખાદ્યાર્પણો, બધાં પાપાર્થાર્પણો અને બધાં દોષાર્થાર્પણો આ બધાં પવિત્ર અર્પણો જે મારે માટે રાખ્યાં છે અને મારા માટે લાવે તે તારાં અને તારા માટે પવિત્ર ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","તે પરમપવિત્ર વસ્તુઓ તરીકે તારે અર્પણો ખાવાં. તમારામાંના દરેક પુરુષોએ પણ તેમાંથી ખાવું; તે તારે માટે પવિત્ર ગણવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","આ બધાં અર્પણો તારાં છે: ઇઝરાયલના લોકો જે ઉચ્છાલીયાર્પણો ચઢાવે તે અને તેમની ભેટો સહિત, મેં તને, તારા દીકરાઓને તથા તારી દીકરીઓને સદાના હક તરીકે આપ્યાં છે. દરેક તારા ઘરમાં જે શુદ્ધ હોય તે આ અર્પણોમાંથી ખાય. ");
INSERT INTO guj2017_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","બધાં ઉત્તમ તેલ, બધો ઉત્તમ દ્રાક્ષારસ તથા અનાજ, જે પ્રથમફળ લોકોએ મને આપ્યું તે, આ બધી વસ્તુઓ મેં તને આપી છે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","પોતાની ભૂમિની પ્રથમ પેદાશ તરીકે જે કંઈ મારી પાસે લાવે તે બધું તારું થશે. તારા કુટુંબમાં જે કોઈ શુદ્ધ હોય તે તેમાંથી ખાય. ");
INSERT INTO guj2017_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ઇઝરાયલની સમર્પિત પ્રત્યેક વસ્તુ તારી થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","લોકો જે યહોવાહને અર્પણ કરે. માણસ તેમ જ પશુમાંથી પ્રથમજનિત પણ તારા થાય. પણ તારે પ્રત્યેક પ્રથમજનિત બાળકને તથા અશુદ્ધ પશુના પ્રથમ બચ્ચાંને ખરીદીને તારે તેમને મુકત કરવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","તેઓમાંના જેઓને છોડાવી લેવાના હોય તેઓને એક મહિનાની ઉંમરથી તું તારા ઠરાવેલા મૂલ્યથી એટલે પવિત્રસ્થાનોના શેકેલ પ્રમાણે પાંચ શેકેલના નાણાંથી, જે વીસ ગેરહ જેટલું છે છોડાવી લે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","પણ ગાયના પ્રથમજનિતને, ઘેટાંના પ્રથમજનિતને તથા બકરાના પ્રથમજનિતને તું ન ખરીદ. તેઓ પવિત્ર છે, મારા માટે અલગ કરેલા છે. તારે તેઓનું રક્ત વેદી પર છાંટવું અને મારા માટે સુવાસિત હોમયજ્ઞ તરીકે ચરબીનું અર્પણ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","તેઓનું માંસ તારું થાય. છાતીની જેમ અને જમણી જાંઘની જેમ તેઓનું માંસ તારું ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ઇઝરાયલી લોકો જે પવિત્ર વસ્તુઓ મારી આગળ અર્પણ કરે છે તેઓનાં સર્વ ઉચ્છાલીયાર્પણો તને તથા તારા દીકરા અને દીકરીઓને સદા હક તરીકે આપ્યાં છે. તે સદાને માટે તારી અને તારા વંશજોની સાથે મેં કરેલો મીઠાનો કરાર છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","યહોવાહે હારુનને કહ્યું, “તેઓના દેશમાં તારે કંઈ વારસો ન હોય, કે લોકોની સંપત્તિ મધ્યે તારે કંઈ ભાગ ન હોય. ઇઝરાયલી લોકો મધ્યે તારો હિસ્સો અને તારો વારસો હું છું. ");
INSERT INTO guj2017_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","લેવીના વંશજો, જે મુલાકાતમંડપની સેવા કરે છે તેના બદલામાં, જુઓ, મેં તેઓને ઇઝરાયલમાં બધા દશાંશનો દશમો વારસો આપ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","હવે પછી ઇઝરાયલના લોકો મુલાકાતમંડપ પાસે આવે નહિ, રખેને આ પાપ માટે તેઓ જવાબદાર ગણાય અને માર્યા જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","મુલાકાતમંડપની સેવા લેવીઓ જ કરે. તેને લગતા દરેક પાપને લીધે તે જવાબદાર ગણાય. તમારી પેઢી દરપેઢી આ સદાને માટે વિધિ થાય. અને ઇઝરાયલી લોકો મધ્યે તેઓને કોઈ વારસો ન મળે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ઇઝરાયલ લોકોનો દશમો ભાગ યહોવાહને અર્પણ કરવો. તે મેં લેવીઓને વારસા તરીકે આપ્યો છે. તેથી મેં તેઓને કહ્યું, તેઓને ઇઝરાયલી મધ્યે કંઈ વારસો નહિ મળે.’” ");
INSERT INTO guj2017_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“તું લેવીઓ સાથે વાત કરીને તેમને કહે કે, ‘યહોવાહે વારસા તરીકે આપેલો દશમો ભાગ જયારે તમે ઇઝરાયલી લોકો પાસેથી પ્રાપ્ત કરો, ત્યારે તમારે યહોવાહને દશમો ભાગ એટલે દશાંશનો દશમો ભાગ ઉચ્છાલીયાર્પણ તરીકે અર્પણ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","તમારું ઉચ્છાલીયાર્પણ, ખળીના અનાજનો દસમો ભાગ તથા દ્રાક્ષકુંડની પેદાશનો દસમો ભાગ તમારા લાભમાં ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ઇઝરાયલી લોકો તરફથી તમને મળેલા દસમા ભાગમાંથી તમારે યહોવાહને ઉચ્છાલીયાર્પણ કરવાં. તેમાંથી તમે હારુન યાજકને ઉચ્છાલીયાર્પણ આપો. ");
INSERT INTO guj2017_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","જે સર્વ ભેટો તું પ્રાપ્ત કરે તેમાંથી, તારે દરેક ઉચ્છાલીયાર્પણ યહોવાહને અર્પણ કરવાં. જે પવિત્ર અને ઉત્તમ વસ્તુઓ તને આપવામાં આવી છે તેમાંથી તારે અર્પણ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","માટે તું તેઓને કહે, ‘તેમાંથી તેના ઉત્તમ ભાગનું જ્યારે તમે ઉચ્છાલીયાર્પણ કરો, ત્યારે તે ખળીની ઊપજ તથા દ્રાક્ષકુંડની ઊપજના અર્પણ જેટલું લેવીઓના લાભમાં ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","તું તથા તારાં કુટુંબો બચેલી તારી ભેટો ગમે તે જગ્યાએ ખાઓ, કારણ કે મુલાકાતમંડપમાં કરેલી સેવાનો તે બદલો ગણાશે. ");
INSERT INTO guj2017_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","જે ઉત્તમ ભાગ તમે પ્રાપ્ત કર્યો તે તમે યહોવાહને ઉચ્છાલીયાર્પણ તરીકે ચઢાવો, તે ખાવાથી તથા પીવાથી તેનો દોષ તમને નહિ લાગે. પણ તમારે ઇઝરાયલ લોકોનાં પવિત્ર અર્પણોને અશુદ્ધ કરવાં નહિ, રખેને તમે માર્યા જાઓ.’” ");
INSERT INTO guj2017_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","યહોવાહે મૂસા તથા હારુન સાથે વાત કરી તેમણે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“જે કાનૂન તથા નિયમ હું લોકોને ફરમાવું છે તે આ છે: ઇઝરાયલના લોકોને આ કાનૂનો જણાવો: ઇઝરાયલના લોકોને કહો કે, તેઓ ખોડખાંપણ વગરની અને જેના પર કદી ઝૂંસરી લાદવામાં આવી ન હોય તેવી લાલ વાછરડી તારી પાસે લાવે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","લાલ વાછરડી એલાઝાર યાજકને આપ. તે તેને છાવણી બહાર લાવે અને કોઈ તેની સામે તે વાછરડીને મારી નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","એલાઝાર યાજક તેમાંથી થોડું રક્ત પોતાની આંગળી પર લે અને મુલાકાતમંડપની આગળની તરફ સાત વખત તેનો છંટકાવ કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","બીજો યાજક તેની નજર સમક્ષ તે વાછરડીનું દહન કરે. તે વ્યક્તિ વાછરડીના ચામડાનું, માંસનું, લોહીનું તેના છાણ સહિત દહન કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ત્યારબાદ યાજક દેવદાર વૃક્ષનું લાકડું, ઝુફો અને કિરમજી રંગની દોરી આ બધું લઈને વાછરડીના દહન મધ્યે નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ત્યારબાદ તે પોતાનાં વસ્ત્રો ધોઈ નાખે અને પાણીમાં સ્નાન કરે. પછી છાવણીમાં આવે, સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","જેણે વાછરડીનું દહન કર્યું હોય તે પોતાનાં વસ્ત્રો ધોઈ નાખે અને પાણીમાં સ્નાન કરે. તે પણ સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","જે શુદ્ધ હોય તેવી વ્યક્તિ વાછરડીની રાખ ભેગી કરે, છાવણીની બહાર સ્વચ્છ જગ્યાએ તેની ઢગલી કરે. ઇઝરાયલ લોકોના સમુદાય માટે આ રાખને રાખી મૂકવી. પાપથી શુદ્ધ થવા માટે આ રાખનું તેઓ પાણીમાં મિશ્રણ કરે, તે પાપાર્થાપર્ણ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","જે કોઈએ વાછરડીની રાખ ભેગી કરી હોય તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં. તે સાંજ સુધી અશુદ્ધ ગણાય. ઇઝરાયલના લોકો માટે અને તેઓની સાથે રહેતા પરદેશીઓ માટે તે હંમેશનો નિયમ થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","જે કોઈ મૃતદેહનો સ્પર્શ કરે તે સાત દિવસ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","પછી તે વ્યક્તિ ત્રીજે દિવસે અને સાતમે દિવસે પોતાને શુદ્ધ કરે. પછી તે શુદ્ધ ગણાય. પણ જો તે ત્રીજે દિવસે અને સાતમે દિવસે પોતાને શુદ્ધ ન કરે, તો તે સાતમા દિવસે પણ શુદ્ધ ન ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","જે કોઈ મૃત્યુ પામેલા વ્યક્તિનો એટલે કે, મૃત્યુ પામેલા માણસનાં શરીરનો સ્પર્શ કરે અને પોતાને શુદ્ધ ન કરે, તો તે યહોવાહના મુલાકાતમંડપને અશુદ્ધ કરે છે. તેને ઇઝરાયલમાંથી વંચિત કરાય કેમ કે તેના પર શુદ્ધિજળ છાંટવામાં આવ્યું નહોતું. તે અશુદ્ધ ગણાય; તેના પર હજી પોતાનું અશુદ્ધપણું છે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","જ્યારે કોઈ માણસ તંબુમાં મૃત્યુ પામે ત્યારે તેના માટે આ નિયમ છે. પ્રત્યેક વ્યક્તિ જે તંબુમાં જાય અને પ્રત્યેક વ્યક્તિ જે તંબુમાં હોય તે સાત દિવસ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","દરેક ખુલ્લું પાત્ર, જેના પર ઢાંકણ ન હોય તે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","જો કોઈ વ્યક્તિ તંબુની બહાર તલવારથી મારી નંખાયેલાનો, મૃતદેહનો, માણસનાં હાડકાંનો, કે કબરનો સ્પર્શ કરે તો તે વ્યક્તિ સાત દિવસ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","અશુદ્ધ વ્યક્તિ માટે આ પ્રમાણે કર. પાપાર્થાર્પણના દહનની રાખ લઈને તેનું વાસણમાં ઝરાના પાણી સાથે મિશ્રણ કર. ");
INSERT INTO guj2017_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","જે કોઈ શુદ્ધ હોય તેણે ઝુફો લઈને પાણીમાં બોળીને મંડપ ઉપર તથા તેમાંના બધાં પાત્રો ઉપર તથા ત્યાં જે બધા માણસો હતા તેઓ પર છાંટવું, જે વ્યક્તિએ હાડકાને, મૃત્યુ પામેલા વ્યક્તિને, મારી નાખવામાં આવેલા વ્યક્તિને કે કબરને સ્પર્શ કર્યો હોય તેની ઉપર પણ છાટવું. ");
INSERT INTO guj2017_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","શુદ્ધ માણસે અશુદ્ધ માણસ પર ત્રીજે દિવસે તથા સાતમે દિવસે પાણી છાંટવું. સાતમે દિવસે અશુદ્ધ માણસે પોતાને શુદ્ધ કરવો. તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં અને પાણીમાં સ્નાન કરવું, એટલે સાંજે તે શુદ્ધ થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","પણ જે કોઈ અશુદ્ધ હોવા છતાં પોતાને શુદ્ધ થવાનો ઇનકાર કર્યો હોય તો તે વ્યક્તિને સમુદાયમાંથી બહિષ્કૃત કરવો, કેમ કે, તેણે યહોવાહના પવિત્ર સ્થાનને અશુદ્ધ કર્યું છે. તેના પર શુદ્ધિનું પાણી છાંટવામાં આવ્યું નથી, તેથી તે અશુદ્ધ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","આ તમારે માટે સદાનો નિયમ છે. પાણીનો છંટકાવ કરનાર વ્યક્તિ પોતાનાં વસ્ત્ર ધોઈ નાખે. વળી જે કોઈ શુદ્ધિના પાણીનો સ્પર્શ કરે તે પણ સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2017_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","અશુદ્ધ વ્યક્તિ કશાનો સ્પર્શ કરે તે સાંજ સુધી અશુદ્ધ ગણાય. તે વસ્તુને સ્પર્શ કરનાર વ્યક્તિ પણ સાંજ સુધી અશુદ્ધ ગણાય.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","પહેલા મહિનામાં ઇઝરાયલ લોકોની આખી જમાત સીનના અરણ્યમાં આવી; તેઓ કાદેશમાં રહ્યા. ત્યાં મરિયમ મરણ પામી અને તેને ત્યાં દફનાવવામાં આવી. ");
INSERT INTO guj2017_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ત્યાં લોકો માટે પીવાનું પાણી નહોતું, તેથી તેઓ મૂસાની અને હારુનની વિરુદ્ધ એકત્ર થયા. ");
INSERT INTO guj2017_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","લોકો મૂસા વિરુદ્ધ ફરિયાદ કરીને કહેવા લાગ્યા, “જ્યારે અમારા ભાઈઓ યહોવાહની સામે મરણ પામ્યા ત્યારે અમે પણ મરી ગયા હોત તો કેવું સારું! ");
INSERT INTO guj2017_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","તમે યહોવાહના લોકોને આ અરણ્યમાં કેમ લાવ્યા છો, અમે તથા અમારાં જાનવરો મરી જઈએ? ");
INSERT INTO guj2017_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","આ ભયાનક જગ્યામાં લાવવાને તું અમને મિસરમાંથી કેમ બહાર લાવ્યો છે? અહીંતો દાણા, અંજીરો, દ્રાક્ષા કે દાડમો નથી. અને પીવા માટે પાણી પણ નથી.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","મૂસા તથા હારુન સભા આગળથી નીકળી ગયા. તેઓ મુલાકાતમંડપના દ્વાર પાસે ગયા અને ઉંધા પડ્યા. ત્યાં તેઓની સમક્ષ યહોવાહનું ગૌરવ પ્રગટ થયું. ");
INSERT INTO guj2017_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","યહોવાહે મૂસા સાથે વાત કરીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“લાકડી લે અને તું તથા તારો ભાઈ હારુન સમુદાયને એકત્ર કરો. તેઓની આંખો સમક્ષ ખડકને કહે કે તે પોતાનું પાણી આપે. તું ખડકમાંથી તેઓને સારુ પાણી વહેતું કર, તે તું જમાતને તથા જાનવરને પીવા માટે આપ.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","જેમ યહોવાહે મૂસાને આજ્ઞા કરી હતી તેમ મૂસાએ યહોવાહ આગળથી લાકડી લીધી. ");
INSERT INTO guj2017_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","પછી મૂસાએ અને હારુને જમાતને ખડક આગળ ભેગી કરી. મૂસાએ તેઓને કહ્યું, “હવે, હે બળવાખોરો સાંભળો, શું અમે તમારે સારુ આ ખડકમાંથી પાણી બહાર કાઢીએ?” ");
INSERT INTO guj2017_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","પછી મૂસાએ પોતાનો હાથ ઊંચો કરીને પોતાની લાકડી ખડકને બે વાર મારી, પુષ્કળ પાણી બહાર વહી આવ્યું. આખી જમાતે પાણી પીધું અને તેઓનાં જાનવરોએ પણ પીધું. ");
INSERT INTO guj2017_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","પછી યહોવાહે મૂસાને અને હારુનને કહ્યું, કેમ કે તમે મારા પર ભરોસો ન કર્યો, કે ઇઝરાયલ લોકોની દ્રષ્ટિમાં મને પવિત્ર મનાવ્યો નહિ, માટે જે દેશ મેં આ સભાને આપ્યો છે તેમાં તમે તેઓને પહોંચાડશો નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","આ જગ્યાનું નામ મરીબાહનું પાણી એવું પાડવામાં આવ્યું, કેમ કે ત્યાં ઇઝરાયલના લોકોએ યહોવાહ સાથે ઝઘડો કર્યો હતો, તેઓ મધ્યે તેમણે પોતાને પવિત્ર મનાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","મૂસાએ કાદેશથી અદોમના રાજા પાસે સંદેશાવાહકો મોકલ્યા: તારો ભાઈ ઇઝરાયલ એવું કહે છે: “જે સર્વ મુસીબતો અમારા પર આવી તે તું જાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","અમારા પિતૃઓ મિસરમાં ગયા અને મિસરમાં લાંબો સમય રહ્યા, મિસરીઓએ અમને તથા અમારા પિતૃઓને દુ:ખ આપ્યું તે પણ તું જાણે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","જ્યારે અમે યહોવાહને પોકાર કર્યો, ત્યારે યહોવાહે અમારો અવાજ સાંભળ્યો અને દૂતને મોકલીને અમને મિસરમાંથી બહાર લાવ્યા. જો, અમે તારા દેશની સરહદના કાદેશ શહેરમાં છીએ. ");
INSERT INTO guj2017_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","મહેરબાની કરીને અમને તારા દેશમાં થઈને જવા દે. અમે ખેતરમાં કે દ્રાક્ષવાડીમાં થઈને નહિ જઈએ, કે અમે તારા કૂવાઓનું પાણી નહિ પીએ. અમે રાજમાર્ગે થઈને જઈશું. તારી સરહદ પસાર કરતા સુધી અમે ડાબે કે જમણે હાથે નહિ ફરીએ.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","પણ અદોમના રાજાએ તેને જવાબ આપ્યો, “તું અહીંથી જઈશ નહિ. જો તું એવું કરીશ, તો હું તારા પર હુમલો કરવા તલવાર લઈને આવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ત્યારે ઇઝરાયલના લોકોએ તેને કહ્યું, “અમે રાજમાર્ગે થઈને જઈશું. જો અમે કે અમારાં જાનવરો તારા કૂવાનું પીએ, તો અમે તેનું મૂલ્ય આપીશું. બીજું કશું નહિ તો અમને પગે ચાલીને પેલી બાજુ જવા દે.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","પણ અદોમ રાજાએ જવાબ આપ્યો, “તમે પાર જવા નહિ પામશે.” પછી અદોમ રાજા ઘણાં સૈનિકો તથા મજબૂત હાથ સાથે ઇઝરાયલ સામે આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","અદોમ રાજાએ ઇઝરાયલને પોતાની સરહદમાં થઈને જવા દેવાનો ઇનકાર કર્યો. એ કારણથી, ઇઝરાયલ લોકો અદોમના દેશમાંથી બીજી તરફ વળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","તેથી લોકોએ કાદેશથી મુસાફરી કરી અને ઇઝરાયલ લોકોની આખી જમાત હોર પર્વત આગળ આવી. ");
INSERT INTO guj2017_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","હોર પર્વતમાં અદોમની સરહદ પાસે યહોવાહ મૂસા તથા હારુન સાથે બોલ્યા. તેમણે કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“હારુન તેના પૂર્વજો સાથે ભળી જશે, કેમ કે જે દેશ મેં ઇઝરાયલ લોકોને આપ્યો છે તેમાં તે પ્રવેશ કરશે નહિ. કેમ કે તમે બન્નેએ મરીબાહનાં પાણી પાસે મારા વચન વિરુદ્ધ બળવો કર્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","તું હારુન અને તેના દીકરા એલાઝારને લઈને તેઓને હોર પર્વત પર લાવ. ");
INSERT INTO guj2017_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","હારુનના યાજકપણાનાં વસ્ત્રો ઉતારી લઈને તેને તેના દીકરા એલાઝારને પહેરાવ. હારુન ત્યાં મરી જશે અને પોતાના પૂર્વજોની સાથે ભળી જશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","યહોવાહે જેમ આજ્ઞા આપી હતી તેમ મૂસાએ કર્યું. આખી જમાતના દેખતાં તેઓ હોર પર્વત પર ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","મૂસાએ હારુનનાં યાજકપદનાં વસ્ત્રો ઉતારીને તેના દીકરા એલાઝારને પહેરાવ્યાં. ત્યાં પર્વતનાં શિખર પર હારુન મરી ગયો. પછી મૂસા અને એલાઝાર નીચે આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","જ્યારે આખી જમાતે જોયું કે હારુન મરણ પામ્યો છે, ત્યારે આખી જમાતે હારુન માટે ત્રીસ દિવસ સુધી વિલાપ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","જ્યારે નેગેબમાં રહેતા કનાનીઓના રાજા અરાદે સાંભળ્યું કે ઇઝરાયલ અથારીમને માર્ગેથી મુસાફરી કરી રહ્યા છે, ત્યારે તેણે ઇઝરાયલ સામે લડાઈ કરીને તેમાંના કેટલાકને કેદ કરી લીધા. ");
INSERT INTO guj2017_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","તેથી ઇઝરાયલે યહોવાહને વચન આપીને કહ્યું કે, “જો તમે અમને આ લોકો ઉપર વિજય આપશો, તો અમે તેઓનાં નગરોનો સંપૂર્ણ નાશ કરી નાખીશું.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","યહોવાહે ઇઝરાયલીઓની વિનંતી સાંભળીને તેઓને કનાનીઓ ઉપર વિજય અપાવ્યો. તેઓએ તેઓનો અને તેઓના નગરોનો સંપૂર્ણપણે નાશ કર્યો. અને તે જગ્યાનું નામ હોર્માહ પડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","તેઓ હોર પર્વત તરફથી રાતા સમુદ્રને રસ્તે થઈને અદોમ દેશની ફરતે આગળ ગયા. રસ્તામાં લોકોનાં હૃદય ઘણાં નાહિંમત થઈ ગયાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","લોકો ઈશ્વર અને મૂસાની વિરુદ્ધ બોલવા લાગ્યા, “શા માટે અરણ્યમાં મરી જવાને તમે અમને મિસરમાંથી બહાર કાઢી લાવ્યા? અહીં રોટલી નથી, પાણી નથી, આ કંગાળ ભોજનથી તો અમે કંટાળી ગયા છીએ.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ત્યારે યહોવાહે લોકોની વચ્ચે ઝેરી સાપો મોકલ્યા. એ સાપો લોકોને કરડ્યા; ઘણાં લોકો મરી ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","તેથી લોકોએ મૂસા પાસે આવીને કહ્યું, “અમે પાપ કર્યું છે કેમ કે અમે તારી અને યહોવાહની વિરુદ્ધ બોલ્યા છીએ. યહોવાહને પ્રાર્થના કર કે તેઓ અમારી મધ્યેથી સાપો દૂર કરે.” તેથી મૂસાએ લોકો માટે પ્રાર્થના કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","યહોવાહે મૂસાને કહ્યું, “એક સાપ બનાવ અને તેને સ્તંભ પર મૂક. એટલે એમ થશે કે જે કોઈ ડંખાયેલું હોય તે, તેને જોઈને બચી જાય.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","તેથી મૂસાએ પિત્તળનો સાપ બનાવીને સ્તંભ પર મૂક્યો. જ્યારે કોઈ વ્યક્તિને સાપ કરડ્યો હોય અને જો તે પિત્તળના સાપ તરફ જુએ, તો તે બચી જશે. ");
INSERT INTO guj2017_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ઇઝરાયલ લોકોએ આગળ મુસાફરી કરીને ઓબોથમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","તેઓએ ઓબોથથી મુસાફરી કરીને ઈયે-અબારીમમાં છાવણી કરી તે અરણ્યમાં મોઆબની પૂર્વ તરફ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","અને ત્યાંથી મુસાફરી કરીને તેઓએ ઝેરેદની ખીણ આગળ છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ત્યાંથી તેઓએ મુસાફરી કરીને આર્નોન નદીની બીજી બાજુએ છાવણી કરી, જે અમોરીઓની સરહદ સુધી વિસ્તરેલા અરણ્યમાં છે, આર્નોન મોઆબીઓ અને અમોરીઓ વચ્ચેની સરહદ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","માટે યહોવાહના યુદ્ધોની યાદીમાં કહેલું છે, “સૂફામાં વાહેબ, તથા આર્નોનની ખીણો, ");
INSERT INTO guj2017_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","આર નગરની તરફ ઢળતો, તથા મોઆબની સરહદ તરફ નીચે જતો ખીણોનો ઢોળાવ.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ત્યાંથી તેઓ મુસાફરી કરીને બએર એટલે જે કૂવા સંબંધી યહોવાહે મૂસાને કહ્યું હતું કે, “તું લોકોને મારા માટે એકત્ર કર હું તેઓને પાણી આપીશ ત્યાં આવ્યા.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ત્યારે ઇઝરાયલે આ ગીત ગાયું: “હે કૂવા, તારાં ઝરણ ફોડ. તેને વિષે ગાઓ. ");
INSERT INTO guj2017_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","જે કૂવો અમારા અધિપતિઓએ ખોદ્યો, જે કૂવો નિયમસ્થાપકની આજ્ઞાથી લોકના આગેવાનોએ પોતાની લાકડીઓથી ખોદ્યો છે.” પછી અરણ્યથી તેઓએ મત્તાનાહ સુધી મુસાફરી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","મત્તાનાહથી તેઓ મુસાફરી કરીને નાહલીએલ ગયા અને નાહલીએલથી બામોથ, ");
INSERT INTO guj2017_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","બામોથથી મોઆબીઓના દેશમાંની ખીણમાં પિસ્ગાહ પર્વતની તળેટીમાં અરણ્યમાં આવેલી ખીણ તરફ ગયા. ");
INSERT INTO guj2017_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","પછી ઇઝરાયલે સંદેશાવાહકોને મોકલીને અમોરીઓના રાજા સીહોનને કહેવડાવ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","કૃપા કરીને અમને તારા દેશમાં થઈને જવા દે. અમે વળીને તારા ખેતરો કે દ્રાક્ષવાડીઓમાં થઈને નહિ જઈએ. અમે તારા કૂવાઓમાંથી પાણી નહિ પીએ. અમે તારી સરહદ પસાર કરીએ ત્યાં સુધી રાજમાર્ગે થઈને ચાલીશું.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","પણ રાજા સીહોને ઇઝરાયલને પોતાની સરહદમાં થઈને જવા દીધા નહિ. સીહોન રાજાએ પોતાના સૈન્યને એકત્ર કર્યું અને રણમાં ઇઝરાયલીઓ ઉપર હુમલો કર્યો. તે યાહાસ પહોંચી ગયો. ત્યાં તેઓએ ઇઝરાયલ સાથે યુદ્ધ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","પણ ઇઝરાયલે સીહોનના સૈન્યનો તલવારની ધારથી સંહાર કર્યો અને આર્નોનથી યાબ્બોક નદી સુધી, આમ્મોન લોકોની સરહદ સુધીનો પ્રદેશ કબજે કરી લીધો. આમ્મોન લોકોની સરહદ કિલ્લાબંધ હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ઇઝરાયલે હેશ્બોન અને તેની આસપાસનાં ગામો સહિત અમોરીઓનાં બધાં નગરો જીતી લીધાં અને તેમાં તેમણે રહેવાનું શરૂ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","હેશ્બોન અમોરીઓના રાજા સીહોનનું નગર હતું, સીહોને અગાઉના મોઆબના રાજા સામે યુદ્ધ કરીને આર્નોન નદી સુધીનો તેનો બધો પ્રદેશ લઈ લીધો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","માટે કહેવતો કહેનારા કહે છે, “તમે હેશ્બોનમાં આવો, સીહોનનું નગર ફરીથી બંધાય અને સ્થપાય. ");
INSERT INTO guj2017_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","હેશ્બોનમાંથી અગ્નિ, એટલે સીહોનના નગરમાંથી પ્રજ્વલિત અગ્નિ નીકળ્યો તેણે મોઆબના આરને, આર્નોન પર્વતના માલિકોને, ભસ્મ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","હે મોઆબ, તને અફસોસ! કમોશના લોકો, તમારો નાશ થયો છે. તેણે પોતાના દીકરાઓને નાસી ગયેલા અને પોતાની દીકરીઓએ કેદીઓ તરીકે, અમોરીઓના રાજા સીહોનને સોંપી દીધા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","પણ અમે સીહોનને જીતી લીધો છે. દીબોન સુધી હેશ્બોનનો વિનાશ થઈ ગયો છે. મેદબા પાસેના નોફાહ સુધી, અમે તેઓને હરાવ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","આ રીતે ઇઝરાયલ અમોરીઓના દેશમાં વસ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","મૂસાએ યાઝેર પર જાસૂસી કરવા માટે માણસો મોકલ્યા. તેઓએ તેમનાં ગામો લઈ લીધાં અને ત્યાં જે અમોરીઓ હતા તેઓને હાંકી કાઢ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","પછી તેઓએ પાછા વળીને બાશાનના રસ્તેથી ગયા. બાશાનનો રાજા ઓગ અને તેનું આખું સૈન્ય તેઓની સાથે યુદ્ધ કરવા એડ્રેઇ આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","યહોવાહે મૂસાને કહ્યું, “તેનાથી બીતો નહિ, કેમ કે મેં તને તેના પર, તેના આખા સૈન્ય પર અને તેના દેશ પર વિજય આપ્યો છે. હેશ્બોનમાં રહેતા અમોરીઓના રાજા સીહોનની સાથે જેવું તેં કર્યું તેવું જ તેની સાથે કરજે.” ");
INSERT INTO guj2017_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","માટે તેઓએ તેને, તેના દીકરાઓને અને તેના આખા સૈન્યને એટલે સુધી માર્યા કે તે લોકોમાંનું કોઈ પણ જીવતું બચ્યું નહિ. તેઓએ તેનો દેશ કબજે કરી લીધો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ઇઝરાયલી લોકોએ મુસાફરી કરીને મોઆબના મેદાનમાં યર્દન નદીની બીજી બાજુએ યરીખોની પાસે છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ઇઝરાયલે અમોરીઓને જે કર્યું હતું તે મોઆબના રાજા સિપ્પોરના દીકરા બાલાકે જોયું. ");
INSERT INTO guj2017_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","તે લોકોને જોઈને મોઆબ ડરી ગયો કેમ કે તેઓ ઘણાં હતા, ઇઝરાયલ લોકોના કારણથી મોઆબ ત્રાસ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","મોઆબ રાજાએ મિદ્યાનના આગેવાનોને કહ્યું, “જેમ કોઈ બળદ ખેતરમાંનું ઘાસ ખાય છે, તેમ આ સમુદાય આપણને ખાઈ જશે.” તે સમયે સિપ્પોરનો દીકરો બાલાક મોઆબનો રાજા હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","તેણે બેઓરના દીકરા બલામને બોલાવવા સારુ પથોર કે જે નદી પર છે, ત્યાં એટલે તેના લોકોના દેશમાં સંદેશાવાહકો મોકલીને કહેવડાવ્યું કે, “જુઓ, મિસરમાંથી એક દેશજાતિ આવી છે. તેઓએ પૃથ્વીની સપાટીને ઢાંકી દીધી છે અને તેઓએ મારી પાસે જ પડાવ નાખ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","કૃપા કરીને આવ અને મારા માટે આ રાષ્ટ્રને શાપ આપ, કેમ કે તેઓ મારા કરતાં વધારે બળવાન છે. કદાચ હું આ લોકોને હુમલો કરીને એવી રીતે મારું કે તેઓને દેશમાંથી હાંકી કાઢી શકું. હું જાણું છું કે જેને તું આશીર્વાદ આપે છે તે આશીર્વાદિત થાય છે અને જેને તું શાપ આપે છે તે શાપિત થાય છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","મોઆબના વડીલોએ તથા મિદ્યાનના વડીલોએ જાદુમંતરની દક્ષિણા લઈને બલામ પાસે આવીને તેને બાલાકનો સંદેશો કહી સંભળાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","બલામે તેઓને કહ્યું, “આજ રાત અહીં રહો. યહોવાહ મને જે જણાવશે તે હું તમને કહીશ.” તેથી મોઆબના આગેવાનો બલામ સાથે રાત રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ઈશ્વરે બલામ પાસે આવીને પૂછ્યું, “તારી સાથે આ માણસો આવ્યા તે કોણ છે?” ");
INSERT INTO guj2017_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","બલામે ઈશ્વરને જવાબ આપ્યો, “મોઆબના રાજા સિપ્પોરના દીકરા બાલાકે તેઓને મારી પાસે મોકલ્યા છે. તેણે કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘જુઓ, જે પ્રજા મિસરમાંથી નીકળી આવી છે તેણે પૃથ્વીની સપાટીને ઢાંકી દીધી છે. હવે આવીને મારા માટે તેઓને શાપ આપ. કદાચ હું તેઓ સાથે યુદ્ધ કરીને તેઓને કાઢી મૂકું.’” ");
INSERT INTO guj2017_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ઈશ્વરે બલામને કહ્યું, “તારે તે માણસો સાથે જવું નહિ. તારે ઇઝરાયલ લોકોને શાપ આપવો નહિ કેમ કે તેઓ આશીર્વાદિત છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","તેથી બલામે સવારે વહેલા ઊઠીને બાલાકના વડીલોને કહ્યું, “તમારા દેશમાં પાછા જાઓ કેમ કે, ઈશ્વર મને તમારી સાથે આવવાની મના કરે છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","તેથી મોઆબના વડીલો ત્યાંથી નીકળીને બાલાક પાસે પાછા ગયા. તેઓએ કહ્યું, “બલામે અમારી સાથે આવવાની ના પાડી છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","બાલાકે ફરીથી વધારે અને પહેલા સમૂહ કરતાં વધારે માનવંત વડીલોને મોકલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","તેઓએ બલામ પાસે આવીને તેને કહ્યું, “સિપ્પોરના દીકરા બાલાકે આ મુજબ કહ્યું, ‘કૃપા કરીને તને મારી પાસે આવવાથી કોઈ રોકો નહિ, ");
INSERT INTO guj2017_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","કેમ કે હું તને મોટો બદલો આપીશ અને તારો ભારે આદર કરીશ, તું મને જે કહીશ તે હું કરીશ. માટે કૃપા કરી આવ અને મારે સારુ આ લોકોને શાપ આપ.’” ");
INSERT INTO guj2017_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","બલામે બાલાકના માણસોને જવાબ આપ્યો, “જો બાલાક મહેલ ભરીને સોનું ચાંદી મને આપે તોપણ હું નાની કે મોટી કોઈ પણ બાબતમાં મારા યહોવાહ, મારા ઈશ્વરની આજ્ઞા વિરુદ્ધ કંઈ કરી શકું તેમ નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","માટે હવે, કૃપા કરીને આજ રાત અહીં રોકાઈ જાઓ, કે જેથી યહોવાહે મને અગાઉ જે કહ્યું તે કરતાં બીજું શું કહે તે હું જાણી શકું.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","રાત્રે ઈશ્વરે બલામ પાસે આવીને કહ્યું, “જો આ લોકો તને બોલાવવા આવ્યા હોય, તો તું ઊઠીને તેમની સાથે જા. પણ હું તને જે કરવાનું કહું તેટલું જ તું કર.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","બલામ સવારે ઊઠીને પોતાની ગધેડી ઉપર જીન બાંધીને મોઆબના વડીલો સાથે ગયો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","પણ તે ગયો, તેથી ઈશ્વરને ક્રોધ ચઢ્યો હતો. જ્યારે બલામ ગધેડી પર સવાર થઈને જતો હતો ત્યારે તેની સામે થવા માટે રસ્તામાં યહોવાહનો દૂત ઊભો રહ્યો, બલામના બે સેવકો પણ તેની સાથે હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ગધેડીએ યહોવાહના દૂતને રસ્તામાં પોતાની તલવાર ખેંચીને ઊભેલો જોયો. તેથી ગધેડી પોતાનો રસ્તો બદલીને ખેતરમાં વળી ગઈ. બલામ ગધેડીને મારીને ફરી પછી રસ્તા પર લઈ આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","પછી યહોવાહનો દૂત દ્રાક્ષવાડીઓની વચ્ચે રસ્તામાં ઊભો રહ્યો, તેની જમણી બાજુ અને બીજી બાજુ દીવાલ હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ગધેડીએ યહોવાહના દૂતને ફરીથી જોયો. તે દીવાલ સામે ચાલી ગઈ અને બલામનો પગ દીવાલની સાથે પછડાયો. બલામે તેને ફરી મારી. ");
INSERT INTO guj2017_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","યહોવાહનો દૂત આગળ ગયો, બીજી સાંકડી જગ્યા જ્યાં ગધેડીને ડાબે કે જમણે ફરવાનો કોઈ રસ્તો ન હતો ત્યાં ઊભો રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ગધેડી યહોવાહના દૂતને જોઈને બલામ સાથે નીચે બેસી પડી. બલામને ગુસ્સો આવ્યો અને તેણે ગધેડીને લાકડીથી મારી. ");
INSERT INTO guj2017_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","પછી યહોવાહે ગધેડીનું મુખ ખોલ્યું કે તે વાત કરી શકે. તેણે બલામને કહ્યું, “મેં તને શું કર્યું છે કે તેં મને ત્રણ વખત મારી?” ");
INSERT INTO guj2017_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","બલામે ગધેડીને જવાબ આપ્યો, “તે એટલા માટે, કેમ કે તેં મારી સાથે મૂર્ખતાભર્યું કામ કર્યું છે. જો મારા હાથમાં તલવાર હોત તો સારું. જો હોત તો, હમણાં જ હું તને મારી નાખત.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ગધેડીએ બલામને પૂછ્યું, “શું હું તારી ગધેડી નથી? જેના પર તેં તારા પૂરા જીવનથી આજ સુધી સવારી કરી છે. તારી આગળ આવું કરવાની મને ક્યારેય આદત હતી?” બલામે કહ્યું, “ના.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","પછી યહોવાહે બલામની આંખો ખોલી, તેણે યહોવાહના દૂતને પોતાની તલવાર હાથમાં લઈને રસ્તાની વચ્ચે ઊભેલો જોયો. બલામે માથું નમાવીને તેને સાષ્ટાંગ દંડ્વત પ્રણામ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","યહોવાહના દૂતે તેને કહ્યું, “તેં આ ગધેડીને ત્રણ વખત શા માટે મારી છે? જો, હું તારી આગળ શત્રુ તરીકે ઊભો રહ્યો કેમ કે મારી આગળ તારા કામો દુષ્ટ હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ગધેડીએ મને જોયો એટલે તે ત્રણ વાર મારાથી દૂર ખસી ગઈ. જો તે ખસી ગઈ ના હોત તો મેં તને મારી નાખ્યો હોત અને ગધેડીનો જીવ બચાવ્યો હોત.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","બલામે યહોવાહના દૂતને કહ્યું, “મેં પાપ કર્યું છે. હું જાણતો ન હતો કે તું માર્ગમાં મારી સામે ઊભો છે. તો હવે, જો આ સફરથી તું નારાજ થયો છે, તો જ્યાંથી હું આવ્યો છું ત્યાં હું પાછો જઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","પણ યહોવાહના દૂતે બલામને કહ્યું, “આ માણસોની સાથે જા. પણ જે વાત હું તને કહું તે જ તારે કહેવી.” તેથી બલામ બાલાકના વડીલો સાથે ગયો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","બાલાક રાજાએ જયારે સાંભળ્યું કે બલામ આવ્યો છે, ત્યારે તે તેને મળવા માટે મોઆબનું નગર જે આર્નોનની સરહદ પર આવેલું છે ત્યાં ગયો. ");
INSERT INTO guj2017_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","બાલાકે બલામને કહ્યું, “મેં તને બોલાવવા માણસો નહોતા મોકલ્યા? શા માટે તું મારી પાસે આવ્યો નહિ? શું હું તારો આદર કરવા સમર્થ ન હતો.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ત્યારે બલામે બાલાકને જવાબ આપ્યો, “જો, હું તારી પાસે આવ્યો છું. શું મને કંઈ બોલવાનો અધિકાર છે? જે વચનો ઈશ્વરે મારા મુખમાં મૂક્યાં છે ફક્ત તે જ હું બોલીશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","બલામ બાલાક સાથે ગયો અને તેઓ કિર્યાથ-હુસોથ આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","પછી બાલાકે બળદો તથા ઘેટાંનો યજ્ઞ કર્યો અને તેણે બલામ તથા તેની સાથેના વડીલોને તેમાંથી થોડું માંસ આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","અને સવારે, બાલાક બલામને બઆલના ઉચ્ચસ્થાનોમાં લઈ ગયો. ત્યાંથી બલામ ઇઝરાયલીઓની છાવણીનો એક ભાગ જોઈ શકતો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","બલામે બાલાકને કહ્યું, “અહીં મારે માટે સાત વેદીઓ બાંધ અને સાત બળદ તથા સાત ઘેટાં તૈયાર કર.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","જેમ બલામે વિનંતી કરી હતી તેમ બાલાકે કર્યું. બાલાક તથા બલામે દરેક વેદી પર એક બળદ તથા એક ઘેટાંનું બલિદાન ચઢાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","બલામે બાલાકને કહ્યું, “તું “તારા દહનીયાર્પણ પાસે ઊભો રહે અને હું જાઉ છું. કદાચ યહોવાહ મને મળવા આવશે. તેઓ જે કંઈ મને કહેશે તે હું તને કહીશ.” પછી તે એક ઉજ્જડ ટેકરી પર ગયો. ");
INSERT INTO guj2017_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ઈશ્વર તેને મળ્યા અને બલામે યહોવાહને કહ્યું, “મેં સાત વેદીઓ બાંધી છે અને દરેક પર એક બળદ અને એક ઘેટાંનું બલિદાન ચઢાવ્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","પછી યહોવાહે બલામના મુખમાં વચન મૂક્યું અને કહ્યું, “તું બાલાક પાસે પાછો જા અને તેને કહે.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","બલામ બાલાક પાસે પાછો ગયો. જુઓ તે તથા મોઆબના બધા વડીલો તેના દહનીયાર્પણની પાસે ઊભા હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","બલામે ભવિષ્યવાણી બોલીને કહ્યું, “મોઆબનો રાજા પૂર્વના પર્વતોમાંથી એટલે અરામથી બાલાક મને લાવ્યો છે. ‘તેણે કહ્યું, આવ, મારે માટે યાકૂબને શાપ દે.’ ‘આવ, ઇઝરાયલને તુચ્છકાર.’ ");
INSERT INTO guj2017_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","જેને ઈશ્વર શાપ આપતા નથી તેને હું કેવી રીતે શાપ આપું? યહોવાહ જેને તુચ્છકારતા નથી તેને હું કેવી રીતે તુચ્છકારું? ");
INSERT INTO guj2017_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","કેમ કે ખડકોના શિખર પરથી હું તેને જોઈ શકું છું; ટેકરીઓ પરથી હું તેને જોઉં છું. જુઓ, ત્યાં એકલા રહેનારા લોકો છે અને પોતાની જાતને સાધારણ પ્રજા ગણતા નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","યાકૂબની ધૂળને કોણ ગણી શકે અથવા ઇઝરાયલના ચતુર્થાંશની કોણ ગણતરી કરી શકે? મારું મૃત્યુ ન્યાયી વ્યક્તિના જેવું થાઓ, અને મારા જીવનનો અંત પણ તેના જેવો થાઓ!” ");
INSERT INTO guj2017_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","બાલાકે બલામને કહ્યું, “આ તેં મારી સાથે શું કર્યું છે? મેં તને મારા દુશ્મનોને શાપ આપવા બોલાવ્યો, પણ જો, તેં તેઓને આશીર્વાદ આપ્યો.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","બલામે જવાબ આપીને કહ્યું, “યહોવાહ મારા મુખમાં જે વચન મૂકે તે બોલવાને મારે સંભાળ ન રાખવી?” ");
INSERT INTO guj2017_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ત્યાર પછી બાલાકે તેને કહ્યું, “કૃપા કરી મારી સાથે બીજી જગ્યાએ આવ કે જ્યાં તું તેઓને જોઈ શકે. તું ફક્ત તેઓના નજીકના ભાગને જોઈ શકશે, તેઓ બધાને તું નહિ દેખે. ત્યાંથી તું તેઓને મારા માટે શાપ દે.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","તે બલામને પિસ્ગાહ પર્વતની શિખરે આવેલા સોફીમના ખેતરમાં લઈ ગયો, ત્યાં તેણે સાત વેદીઓ બાંધી. દરેક વેદી ઉપર એક બળદ અને એક ઘેટાંનું બલિદાન ચઢાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","બલામે બાલાકને કહ્યું, “અહીં તારા દહનીયાર્પણ પાસે ઊભો રહે, હું યહોવાહને મળવા ત્યાં ઉપર જાઉ છું.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","યહોવાહ બલામને મળવા આવ્યા અને તેના મુખમાં વચન મૂક્યું. તેમણે કહ્યું, “બાલાક પાસે પાછો જા અને મારું વચન તેને આપ.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","બલામ તેની પાસે પાછો આવ્યો, તો જુઓ, તે તથા મોઆબના વડીલો તેની સાથે તેના દહનીયાર્પણ પાસે ઊભા હતા. ત્યારે બાલાકે તેને પૂછ્યું, “યહોવાહે તને શું કહ્યું છે?” ");
INSERT INTO guj2017_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","બલામે તેની ભવિષ્યવાણીની શરૂઆત કરી. તેને કહ્યું, “બાલાક ઊઠ, અને સાંભળ. હે સિપ્પોરના દીકરા, મને સાંભળ. ");
INSERT INTO guj2017_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ઈશ્વર મનુષ્ય નથી કે તે જૂઠું બોલે, અથવા માણસ નથી કે તે પોતાનું મન બદલે. તે પોતાનું વચન પૂરું નહિ કરે? પોતાનું બોલવું પૂરું નહિ કરે? ");
INSERT INTO guj2017_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","જુઓ, આશીર્વાદ આપવાની આજ્ઞા મને મળી છે. ઈશ્વરે તેઓને આશીર્વાદ આપ્યો છે તે હું ફેરવી શકતો નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","તેઓએ યાકૂબમાં કઈ જ ખોટું જોયું નથી. કે ઇઝરાયલમાં મુશ્કેલી જોઈ નથી. યહોવાહ તેઓના ઈશ્વર તેઓની સાથે છે, અને તેઓની વચ્ચે રાજાનો જયજયકાર છે. ");
INSERT INTO guj2017_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ઈશ્વર તેઓને મિસરમાંથી બહાર લાવ્યા છે, અને જંગલી બળદ જેવી તાકાત આપે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","યાકૂબ વિરુદ્ધ કોઈ મંત્રતંત્ર નહિ ચાલે, ઇઝરાયલ પર કંઈ પણ મંત્રવિદ્યા ચાલશે નહિ. ઇઝરાયલ તથા યાકૂબ વિષે કહેવાશે કે, ‘જુઓ ઈશ્વરે કેવું કર્યું છે!’ ");
INSERT INTO guj2017_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","જુઓ, લોકો સિંહણની જેમ ઊઠે છે, જેમ સિંહ બહાર નીકળીને હુમલો કરે છે. તે મારેલો શિકાર ખાય અને તેનું રક્ત પીવે નહિ ત્યાં સુધી તે સૂઈ જશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","પછી બાલાકે બલામને કહ્યું, “તેઓને શાપ ન દે તેમ જ આશીર્વાદ પણ ન આપ.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","પણ બલામે બાલાકને જવાબ આપીને કહ્યું, “શું મેં તને કહ્યું ન હતું કે યહોવાહ મને જે કહેશે તે જ હું કહીશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","બાલાકે બલામને જવાબ આપ્યો, “હવે આવ, હું તને બીજી જગ્યાએ લઈ જાઉં. કદાચ ઈશ્વર પ્રસન્ન થાય અને ત્યાંથી તું તેઓને મારે સારુ શાપ આપે.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","બાલાક બલામને પેઓર પર્વતના શિખર પર લઈ ગયો, જ્યાંથી અરણ્ય જોઈ શકાતું હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","બલામે બાલાકને કહ્યું, “અહીં મારે સારુ સાત વેદી બાંધી આપ અને સાત બળદ તથા સાત ઘેટાં તૈયાર કર.” ");
INSERT INTO guj2017_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","જેમ બલામે કહ્યું તેમ બાલાકે કર્યું, તેણે દરેક વેદી પર એક બળદ તથા એક ઘેટાંનું બલિદાન ચઢાવ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","બલામે જોયું કે ઇઝરાયલને આશીર્વાદ આપવો તે યહોવાહને પસંદ પડ્યું છે, તેથી તે મંત્રવિદ્યા કરવા ગયો નહિ, પણ, તેણે અરણ્યની તરફ જોયું. ");
INSERT INTO guj2017_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","તેણે દ્રષ્ટિ કરીને જોયું તો ઇઝરાયલીઓએ પોતાના કુળ પ્રમાણે છાવણી નાખી હતી અને ઈશ્વરનો આત્મા તેના પર આવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","તેણે ભવિષ્યવાણી કરીને કહ્યું, “બેઓરનો દીકરો બલામ કહે છે, જે માણસની આંખો વિશાળ રીતે ખુલ્લી હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","તે બોલે છે અને ઈશ્વરના શબ્દો સાંભળે છે. જે પોતાની ખુલ્લી આંખે ઊંધો પડીને સર્વસમર્થનું દર્શન પામે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","હે યાકૂબ, તારા તંબુઓ, હે ઇઝરાયલ તારા મંડપ કેવા સુંદર છે! ");
INSERT INTO guj2017_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ખીણોની માફફ તેઓ પથરાયેલા છે, નદીકિનારે બગીચા જેવા, યહોવાહે રોપેલા અગરના છોડ જેવા, પાણી પાસેના દેવદાર વૃક્ષ જેવા. ");
INSERT INTO guj2017_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","તેની ડોલમાંથી પાણી વહેશે, ઘણાં પાણીઓમાં તેનું બીજ છે. તેઓનો રાજા અગાગ કરતાં મોટો થશે, તેઓનું રાજ્ય પ્રતાપી રાજ્ય બનશે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ઈશ્વર તેઓને મિસરમાંથી કાઢી લાવે છે. તેનામાં જંગલી બળદના જેવી તાકાત છે. તે પોતાની વિરુદ્ધ થનાર પ્રજાઓને ખાઈ જશે. તે તેઓનાં હાડકાં ભાંગીને ટુકડા કરશે. તે પોતાના તીરોથી તેઓને વીંધી નાખશે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","તે સિંહ તથા સિંહણની માફક નીચે નમીને ઊંઘે છે. તેને ઉઠાડવાની હિંમત કોણ કરે? તને જે આશીર્વાદ આપે તે આશીર્વાદિત થાઓ; તને જે શાપ આપે તે શાપિત થાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","બાલાકને બલામ પર ખૂબ ગુસ્સો આવ્યો અને ગુસ્સામાં તેણે પોતાના હાથ મસળ્યા. બાલાકે બલામને કહ્યું, “મારા દુશ્મનોને શાપ આપવા માટે મેં તને બોલાવ્યો છે, પણ જો, તેં ત્રણ વાર તેઓને આશીર્વાદ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","તો અત્યારે મને છોડીને ઘરે જા. મેં કહ્યું હું તને મોટો બદલો આપીશ, પણ યહોવાહે તને તે બદલો પ્રાપ્ત કરવાથી વંચિત રાખ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","બલામે બાલાકને જવાબ આપ્યો, “જે સંદેશાવાહકો તેં મારી પાસે મોકલ્યા હતા તેઓને પણ શું એવું નહોતું કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘જો બાલાક મને તેના મહેલનું સોનુંચાંદી આપે, તો પણ હું યહોવાહની આજ્ઞાની વિરુદ્ધ જઈને મારી મરજી પ્રમાણે સારું કે ખરાબ કંઈ જ કરી શકતો નથી. હું તો યહોવાહ જે કહે છે તે જ કરીશ.’ ");
INSERT INTO guj2017_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","તો હવે, જો હું મારા લોકો પાસે જાઉ છું. પણ તે અગાઉ તને ચેતવણી આપું છું કે આ લોકો ભવિષ્યમાં તારા લોકો સાથે શું કરશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","બલામે ભવિષ્યવાણી કરતાં કહ્યું, “બેઓરના દીકરા બલામ, જેની આંખો ખુલ્લી હતી તે કહે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","જે ઈશ્વરની વાણી સાંભળે છે, જેને પરાત્પર ઈશ્વર પાસેથી ડહાપણ પ્રાપ્ત થયું છે, જે ખુલ્લી આંખો રાખીને સર્વસમર્થ ઈશ્વરનું દર્શન પામે છે, તે કહે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","હું તેને જોઉં છું, પણ તે અત્યારે નહિ. હું તેને જોઉં છું, પણ પાસે નહિ. યાકૂબના વંશમાંથી એક તારો ઊગશે, ઇઝરાયલમાંથી રાજદંડ ઊભો થશે. તે મોઆબના આગેવાનોનો નાશ કરી નાખશે. અને શેથના બધા વંશજોનો તે નાશ કરશે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","અદોમ ઇઝરાયલનું વતન પ્રાપ્ત કરશે. અને સેઈર પણ તેનું વતન પ્રાપ્ત કરશે, તે બન્ને ઇઝરાયલના શત્રુઓ હતા, જેના પર ઇઝરાયલ વિજેતા થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","યાકૂબમાંથી એક રાજા નીકળશે જે આધિપત્ય ધારણ કરશે, તે નગરમાંથી બાકી રહેલા લોકોનો વિનાશ કરશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","પછી બલામે અમાલેકીઓ તરફ જોઈને ભવિષ્યવાણી કરીને કહ્યું, “અમાલેકી પહેલું મોટું રાજ્ય હતું, પણ તેનો છેલ્લો અંત વિનાશ હશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","અને બલામે કેનીઓ તરફ જોઈને ભવિષ્યવાણી કરીને કહ્યું, “તું જે જગ્યાએ રહે છે તે મજબૂત છે, અને તારા માળા ખડકોમાં બાંધેલા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","તોપણ કાઈન વેરાન કરાયો છે જ્યારે આશ્શૂર તને કેદ કરીને દૂર લઈ જશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","બલામે છેલ્લી ભવિષ્યવાણી કરતાં કહ્યું, “અરે! ઈશ્વર આ પ્રમાણે કરશે ત્યારે કોણ જીવતું બચશે? ");
INSERT INTO guj2017_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","કિત્તીમના કિનારા પરથી વહાણો આવશે; તેઓ આશ્શૂર પર હુમલો કરશે અને એબેરને કચડી નાખશે, પણ તેઓનો, અંતે વિનાશ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","પછી બલામ ઊઠીને ચાલ્યો ગયો. તે પોતાને ઘરે પાછો ફર્યો અને બાલાક પણ પોતાના રસ્તે ગયો. ");
INSERT INTO guj2017_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ઇઝરાયલ શિટ્ટીમમાં રહેતા હતા ત્યારે પુરુષોએ મોઆબની સ્ત્રીઓ સાથે સૂવાનું શરૂ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","કેમ કે મોઆબીઓ તે લોકોને પોતાના દેવોને બલિદાન અર્પણ કરવા આમંત્રણ આપતા હતા. તેથી લોકોએ ખાધું અને મોઆબીઓના દેવોની પૂજા કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ઇઝરાયલના માણસો બઆલ-પેઓરની પૂજામાં સામેલ થયા, એટલે યહોવાહ ઇઝરાયલ પર કોપાયમાન થયા. ");
INSERT INTO guj2017_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","યહોવાહે મૂસાને કહ્યું કે, “લોકોના બધા વડીલોને લઈને તેઓને મારી નાખ. અને દિવસે ખુલ્લી રીતે લોકોની સમક્ષ તેઓને મારી આગળ લટકાવ, જેથી ઇઝરાયલ પરથી મારો ગુસ્સો દૂર થાય.” ");
INSERT INTO guj2017_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","તેથી મૂસાએ ઇઝરાયલના વડીલોને કહ્યું, “તમારામાંનો દરેક પોતાના લોકોમાંથી જેણે બઆલ-પેઓરની પૂજા કરી હોય તેને મારી નાખે.” ");
INSERT INTO guj2017_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ઇઝરાયલનો એક માણસ આવ્યો અને એક મિદ્યાની સ્ત્રીને તેના કુટુંબના સભ્યો વચ્ચે લઈ ગયો. મૂસાની નજર સમક્ષ અને ઇઝરાયલ લોકોનો આખો સમુદાય, જયારે મુલાકાતમંડપના પ્રવેશદ્વાર આગળ રડતો હતો તે સમયે આવું બન્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","જયારે હારુન યાજકના દીકરા એલાઝારનો દીકરો ફીનહાસ તે જોઈને સમુદાયમાંથી ઊભો થયો અને પોતાના હાથમાં ભાલો લીધો. ");
INSERT INTO guj2017_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","તે ઇઝરાયલી માણસની પાછળ તંબુમાં ગયો અને ભાલાનો ઘા કરીને તે ઇઝરાયલી માણસને અને સ્ત્રીના પેટને વીંધી નાખ્યાં. જે મરકી ઈશ્વરે ઇઝરાયલી લોકો પર મોકલી હતી તે બંધ થઈ. ");
INSERT INTO guj2017_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","જેઓ મરકીથી મરણ પામ્યા હતો તેઓ સંખ્યામાં ચોવીસ હજાર હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“હારુન યાજકના દીકરા એલાઝારના દીકરા ફીનહાસે ઇઝરાયલ લોકો પરથી મારા રોષને શાંત કર્યો છે કેમ કે તે મારી પ્રત્યે ઝનૂની હતો. તેથી મારા ગુસ્સામાં મેં ઇઝરાયલી લોકોનો નાશ ન કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","તેથી કહે કે, ‘યહોવાહ કહે છે કે, જુઓ, હું ફીનહાસને મારો શાંતિનો કરાર આપું છું. ");
INSERT INTO guj2017_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","તેના માટે તથા તેના પછી તેના વંશજોને માટે તે સદાના યાજકપદનો કરાર થશે, કેમ કે મારા માટે, એટલે પોતાના ઈશ્વર માટે આવેશી થયો છે. તેણે ઇઝરાયલના લોકો માટે પ્રાયશ્ચિત કર્યું હતું.” ");
INSERT INTO guj2017_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","જે ઇઝરાયલી માણસને મિદ્યાની સ્ત્રીની સાથે મારી નાખવામાં આવ્યો હતો તેનું નામ ઝિમ્રી હતું, તે શિમયોનીઓ મધ્યે પિતૃઓના કુટુંબનો આગેવાન સાલૂનો દીકરો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","જે મિદ્યાની સ્ત્રીને મારી નાખવામાં આવી હતી તેનું નામ કીઝબી હતું, તે સૂરની દીકરી હતી, જે મિદ્યાનમાં કુટુંબનો અને કુળનો આગેવાન હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","પછી યહોવાહે મૂસા સાથે વાત કરીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“મિદ્યાનીઓ સાથે દુશ્મનો જેવો વર્તાવ કર અને તેઓ પર હુમલો કર, ");
INSERT INTO guj2017_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","કેમ કે તેઓ કપટથી તમારી સાથે દુશ્મનો જેવા વ્યવહાર કરે છે. તેઓ પેઓરની બાબતમાં અને તેઓની બહેન એટલે મિદ્યાનના આગેવાનની દીકરી કીઝબી કે જેને પેઓરની બાબતમાં મરકીના દિવસે મારી નાખવામાં આવી હતી તેની બાબતમાં તમને ફસાવ્યા હતા.” ");
INSERT INTO guj2017_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","મરકી બંધ થયા પછી યહોવાહે મૂસાને તથા હારુન યાજકના પુત્ર એલાઝારને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ઇઝરાયલી લોકોની આખી જમાતમાં જેઓ વીસ વર્ષના કે તેથી વધારે ઉંમરના હોય, એટલે કે જેઓ ઇઝરાયલ માટે યુદ્ધમાં જવાને સમર્થ હોય તેઓની તથા તેઓના પિતૃઓના કુટુંબોની ગણતરી કર.” ");
INSERT INTO guj2017_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","યર્દન નદીને કિનારે યરીખોના, મોઆબના મેદાનમાં મૂસા તથા એલાઝાર યાજકે તેઓની સાથે વાત કરી કે, ");
INSERT INTO guj2017_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","વીસ વર્ષ તથા તેથી વધારે ઉંમરના લોકોની ગણતરી કરો, જેમ યહોવાહે મૂસાને તથા ઇઝરાયલ લોકોને મિસરમાંથી બહાર આવ્યા હતા ત્યારે તેઓને આજ્ઞા આપી હતી તેમ.” ");
INSERT INTO guj2017_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ઇઝરાયલનો જયેષ્ઠ દીકરો રુબેન હતો. તેના દીકરા હનોખથી હનોખીઓનું કુટુંબ. પાલ્લૂથી પાલ્લૂનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","હેસ્રોનથી હેસ્રોનીઓનું કુટુંબ. કાર્મીથી કાર્મીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","રુબેનના વંશજોનાં આટલાં કુળો હતાં, તેઓની સંખ્યા તેંતાલીસહજાર સાતસોત્રીસની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","પાલ્લૂનો દીકરો અલિયાબ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","અલિયાબના દીકરા: નમુએલ, દાથાન તથા અબિરામ હતા. દાથાન તથા અબિરામ જેઓ કોરાહને અનુસરતા હતા જ્યારે તેઓએ મૂસા તથા હારુનની સામે બંડ પોકારીને યહોવાહ સામે બળવો કર્યો તે એ જ હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","જયારે તેઓ મૃત્યુ પામ્યા ત્યારે પૃથ્વી પોતાનું મુખ ખોલીને તેઓને કોરાહ સહિત ગળી ગઈ. તે જ સમયે અગ્નિએ બસો પચાસ માણસોનો નાશ કરી નાખ્યો જેઓ ચિહ્નરૂપ થઈ પડ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","તેમ છતાં કોરાહના વંશજો મૃત્યુ પામ્યા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","શિમયોનના વંશજોનાં કુટુંબો નીચે પ્રમાણે છે: નમુએલથી નમુએલીઓનું કુટુંબ. યામીનથી યામીનીઓનું કુટુંબ. યાખીનથી યાખીનીઓનું કુટુંબ, ");
INSERT INTO guj2017_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ઝેરાહથી ઝેરાહીઓનું કુટુંબ. શાઉલથી શાઉલીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","આ શિમયોનના વંશજોનાં કુટુંબો હતાં, જેઓ સંખ્યામાં બાવીસહજાર બસો માણસો હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ગાદના વંશજોનાં કુટુંબો આ હતાં એટલે. સફોનથી સફોનીઓનું કુટુંબ. હાગ્ગીથી હાગ્ગીઓનું કુટુંબ. શૂનીથી શૂનીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ઓઝનીથી ઓઝનીઓનું કુટુંબ. એરીથી એરીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","અરોદથી અરોદીઓનું કુટુંબ. આરએલીથી આરએલીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","આ ગાદના વંશજોના કુટુંબો હતા જેઓની સંખ્યા ચાલીસહજાર પાંચસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","એર તથા ઓનાન યહૂદાના દીકરા હતા, પણ આ માણસો કનાન દેશમાં મૃત્યુ પામ્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","યહૂદાના બીજા વંશજોનાં કુટુંબો આ હતાં એટલે: શેલાથી શેલાનીઓનું કુટુંબ. પેરેસથી પેરેસીઓનું કુટુંબ. ઝેરાહથી ઝેરાહીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","પેરેસના વંશજો આ હતા એટલે: હેસ્રોનથી હેસ્રોનીઓનું કુટુંબ. હામૂલથી હામૂલીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","આ યહૂદાના વંશજોનાં કુટુંબો હતા, જેઓની સંખ્યા છોતેરહજાર પાંચસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ઇસ્સાખારના વંશજોના કુટુંબો આ હતાં એટલે: તોલાથી તોલાઈઓનું કુટુંબ. પુવાહથી પૂનીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","યાશૂબથી યાશૂબીઓનું કુટુંબ. શિમ્રોનથી શિમ્રોનીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","આ ઇસ્સાખારના વંશજોના કુટુંબો હતા, જેઓની સંખ્યા ચોસઠહજાર ત્રણસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ઝબુલોનના વંશજોનાં કુટુંબો આ હતાં એટલે: સેરેદથી સેરેદીઓનું કુટુંબ. એલોનથી એલોનીઓનું કુટુંબ. યાહલેલથી યાહલેલીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","આ ઝબુલોનીઓના વંશજોનાં કુટુંબો હતાં. જેઓની સંખ્યા સાઠહજાર પાંચસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","યૂસફના વંશજો મનાશ્શા અને એફ્રાઇમ હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","મનાશ્શાના વંશજો આ હતા: માખીરથી માખીરીઓનું કુટુંબ માખીર ગિલ્યાદનો પિતા હતો, ગિલ્યાદથી ગિલ્યાદીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ગિલ્યાદનાં કુટુંબો આ હતાં: ઈએઝેરથી ઈએઝેરીઓનું કુટુંબ. હેલેકથી હેલેકીઓનું કુટુંબ, અને ");
INSERT INTO guj2017_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","આસ્રીએલથી આસ્રીએલીઓનું કુટુંબ. અને શખેમથી શખેમીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","શમીદાથી શમીદાઈઓનું કુટુંબ. હેફેરથી હેફેરીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","હેફેરના દીકરા સલોફહાદને દીકરા નહોતા, પણ ફક્ત દીકરીઓ જ હતી. તેની દીકરીઓનાં નામ માહલાહ, નૂહ, હોગ્લાહ, મિલ્કાહ તથા તિર્સા હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","આ મનાશ્શાનાં કુટુંબો હતાં, જેઓની સંખ્યા બાવનહજાર સાતસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","એફ્રાઇમના વંશજોનાં કુટુંબો આ હતાં. શૂથેલાહથી શૂથેલાહીઓનું કુટુંબ. બેખેરથી બેખેરીઓનું કુટુંબ. તાહાનથી તાહાનીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","શૂથેલાહના વંશજો, એરાનથી એરાનીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","આ એફ્રાઇમના વંશજોનાં કુટુંબો હતાં. જેઓની સંખ્યા બત્રીસહજાર પાંચસો માણસોની હતી. યૂસફના વંશજો તેઓના કુટુંબોની ગણતરી પ્રમાણે આ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","બિન્યામીનના વંશજોનાં કુટુંબો આ હતાં: બેલાથી બેલાઈઓનું કુટુંબ. આશ્બેલથી આશ્બેલીઓનું કુટુંબ. અહીરામથી અહીરામીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","શૂફામથી શૂફામીઓનું કુટુંબ. હૂફામથી હૂફામીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","બેલાના દીકરાઓ આર્દ તથા નામાન હતા. આર્દથી આર્દીઓનું કુટુંબ, નામાનથી નામાનીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","આ બિન્યામીનના વંશજોનાં કુટુંબો હતાં. જેઓની સંખ્યા પિસ્તાળીસહજાર છસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","દાનના કુટુંબોના વંશજો, શૂહામથી શૂહામીઓનું કુટુંબ. આ દાનના વંશજોનું કુટુંબ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","શૂહામીઓના બધાં કુટુંબોની સંખ્યા ચોસઠહજાર ચારસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","આશેરના વંશજોનાં કુટુંબો આ હતાં. યિમ્નાથી યિમ્નીઓનું કુટુંબ. યિશ્વીથી યિશ્વીઓનું કુટુંબ, બરિયાથી બરિયાઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","બરિયાના વંશજોનાં કુટુંબો આ હતાં. હેબેરથી હેબેરીઓનું કુટુંબ. માલ્કીએલથી માલ્કીએલીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","આશેરની દીકરીનું નામ સેરાહ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","આ આશેરના વંશજોનાં કુટુંબો હતાં, જેઓની સંખ્યા તેપનહજાર ચારસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","નફતાલીના વંશજોનાં કુટુંબો આ હતાં: યાહસએલથી યાહસએલીઓનું કુટુંબ, ગૂનીથી ગૂનીઓનું કુટુંબ, ");
INSERT INTO guj2017_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","યેસેરથી યેસેરીઓનું કુટુંબ, શિલ્લેમથી શિલ્લેમીઓનું કુટુંબ. ");
INSERT INTO guj2017_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","નફતાલીના વંશજોનાં કુટુંબો આ હતાં. જેઓની સંખ્યા પિસ્તાળીસહજાર ચારસો માણસોની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ઇઝરાયલ લોકો મધ્યેના માણસોની કુલ ગણતરી છ લાખ એક હજાર સાતસો ત્રીસની હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“તેઓનાં નામોની સંખ્યા પ્રમાણે માણસોને આ દેશનો વારસો વહેંચી આપવો. ");
INSERT INTO guj2017_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","મોટા કુટુંબને વધારે વારસો આપવો, નાના કુટુંબને થોડો વારસો આપવો. દરેક કુટુંબના માણસોની ગણતરી પ્રમાણે તેમને વારસો આપવો. ");
INSERT INTO guj2017_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ચિઠ્ઠી નાખીને દેશની વહેંચણી કરવી. દરેકને તેમના પિતૃઓનાં કુળો પ્રમાણે વારસો મળે. ");
INSERT INTO guj2017_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","વધારે તથા થોડા કુટુંબોની વચ્ચે ચિઠ્ઠીઓ નાખીને વારસાની વહેંચણી કરવી.” ");
INSERT INTO guj2017_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","લેવીઓનાં કુટુંબો: તેઓનાં કુટુંબો પ્રમાણે ગણતરી થઈ તે આ હતી: ગેર્શોનથી ગેર્શોનીઓનું કુટુંબ. કહાથથી કહાથીઓનું કુટુંબ. મરારીથી મરારીઓનું કુટુંબ, ");
INSERT INTO guj2017_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","લેવીઓનાં કુટુંબો નીચે મુજબ છે: લિબ્નીઓનું કુટુંબ. હેબ્રોનીઓનું કુટુંબ. માહલીઓનું કુટુંબ. મુશીઓનું કુટુંબ. તથા કોરાહીઓનું કુટુંબ. કહાથ આમ્રામનો પૂર્વજ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","આમ્રામની પત્નીનું નામ યોખેબેદ હતું, તે લેવીની દીકરી હતી, જે મિસરમાં લેવીને ઘરે જન્મી હતી. તેનાથી હારુન, મૂસા તથા તેમની બહેન મરિયમ જન્મ્યા હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","હારુનની પત્નીએ નાદાબ તથા અબીહૂ, એલાઝાર તથા ઈથામારને જન્મ આપ્યો. આમ્રામ તેનો પતિ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","નાદાબ તથા અબીહૂ યહોવાહ સમક્ષ અમાન્ય અગ્નિ ચઢાવતા મૃત્યુ પામ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","તેઓ મધ્યેના જેઓની ગણતરી થઈ તેઓ એટલે એક મહિનો તથા તેનાથી વધારે ઉંમરના પુરુષોની સંખ્યા તેવીસ હજારની હતી. પણ તેઓની ગણતરી ઇઝરાયલ લોકો વચ્ચે થઈ ન હતી, કેમ કે તેઓને ઇઝરાયલ લોકો મધ્યે વારસો મળ્યો ન હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","મૂસા તથા એલાઝાર યાજકથી જેઓની ગણતરી થઈ તેઓ આ હતા. તેઓએ યર્દનને કિનારે યરીખો સામે મોઆબના મેદાનમાં ઇઝરાયલ લોકોની ગણતરી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","મૂસાએ તથા હારુન યાજકે સિનાઈ અરણ્યમાં ઇઝરાયલના વંશજોની ગણતરી કરી ત્યારે જેઓની ગણતરી થઈ હતી તેઓમાંનો એક પણ માણસ ત્યાં ન હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","કેમ કે, યહોવાહે કહ્યું હતું કે આ બધા લોકો અરણ્યમાં મૃત્યુ પામશે. ફક્ત યફૂન્નેનો દીકરો કાલેબ તથા નૂનનો દીકરો યહોશુઆ સિવાય તેઓમાંનો એક પણ માણસ બચશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","યૂસફના દીકરા મનાશ્શાના કુટુંબોમાંથી મનાશ્શાના દીકરા માખીરના દીકરા ગિલ્યાદના દીકરા હેફેરના દીકરા સલોફહાદની દીકરીઓ મૂસા પાસે આવી. તેની દીકરીઓના નામ આ પ્રમાણે હતા: માહલાહ, નૂહ, હોગ્લાહ, મિલ્કાહ તથા તિર્સા. ");
INSERT INTO guj2017_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","તેઓએ મૂસાની, એલાઝાર યાજકની, વડીલોની તથા આખી જમાતની આગળ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ ઊભી રહીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“અમારો પિતા અરણ્યમાં મૃત્યુ પામ્યો. યહોવાહ વિરુદ્ધ ઊઠનાર કોરાહની ટોળીમાં તે ન હતા. તે તેના પોતાના પાપમાં મૃત્યુ પામ્યા; તેને કોઈ દીકરા ન હતા. ");
INSERT INTO guj2017_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","અમારા પિતાને દીકરો ન હોવાથી અમારા પિતાનું નામ કુટુંબમાંથી શા માટે દૂર કરાય? અમારા પિતાના ભાઈઓ મધ્યે અમને વારસો આપવામાં આવે.” ");
INSERT INTO guj2017_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","માટે મૂસા આ બાબત યહોવાહ સમક્ષ લાવ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","અને યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“સલોફહાદની દીકરીઓ સાચું બોલે છે. તું નિશ્ચે તે લોકોને તેમના પિતાના ભાઈઓની સાથે વારસાનો દેશ આપ; તેઓના પિતાનો વારસો તેઓને આપ. ");
INSERT INTO guj2017_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ઇઝરાયલ લોકોને સાથે વાત કરીને કહે, ‘જો કોઈ માણસ મૃત્યુ પામે અને તેને દીકરો ન હોય, તો તેની દીકરીને તેનો વારસો આપ. ");
INSERT INTO guj2017_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","જો તેને દીકરી ના હોય, તો તું તેનો વારસો તેના ભાઈઓને આપ. ");
INSERT INTO guj2017_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","જો તેને ભાઈઓ ના હોય, તો તેનો તેના પિતાના ભાઈઓને આપ. ");
INSERT INTO guj2017_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","અને જો તેને કાકાઓ ન હોય, તો તેનો વારસો તેના નજીકના સગાને આપ, તે તેનો માલિક બને. યહોવાહે મૂસાને આજ્ઞા કરી હતી તે પ્રમાણે આ કાયદો ઇઝરાયલી લોકો માટે કાનૂન થાય.’” ");
INSERT INTO guj2017_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","યહોવાહે મૂસાને કહ્યું, “તું અબારીમના પર્વત પર જા અને જે દેશ મેં ઇઝરાયલી લોકોને આપેલો છે તે જો. ");
INSERT INTO guj2017_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","તે જોયા પછી તું પણ તારા ભાઈ હારુનની જેમ તારા લોકો સાથે ભળી જશે. ");
INSERT INTO guj2017_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","કેમ કે સીનના અરણ્યમાં આખી જમાતની દ્રષ્ટિમાં ખડકમાંથી વહેતા પાણી પાસે કાદેશમાં મરીબાહનાં પાણી મને પવિત્ર માનવા વિષે તેં મારી આજ્ઞાની વિરુદ્ધ બળવો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","પછી મૂસાએ યહોવાહની સાથે વાત કરીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“યહોવાહ, સર્વ માનવજાતના આત્માઓના ઈશ્વર, તે લોકો પર એક માણસને નિયુક્ત કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","કોઈ માણસ તેઓની આગળ બહાર જાય અને અંદર આવે, જે તેઓને બહાર ચલાવે અને અંદર લાવે, જેથી તમારા લોકો પાળક વગરનાં ઘેટાં જેવા ન રહે.” ");
INSERT INTO guj2017_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","યહોવાહે મૂસાને કહ્યું, “નૂનનો દીકરો યહોશુઆ, જેનામાં મારો આત્મા રહે છે, તેના પર તારો હાથ મૂક. ");
INSERT INTO guj2017_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","તું તેને એલાઝાર યાજક તથા આખી જમાત સમક્ષ ઊભો કર, તેઓના દેખતાં તેને તારો ઉત્તરાધિકારી નિયુક્ત કર. ");
INSERT INTO guj2017_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","તારો કેટલોક અધિકાર તેના પર મૂક, જેથી ઇઝરાયલી લોકોની આખી જમાત તેની આજ્ઞા પાળે. ");
INSERT INTO guj2017_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","એલાઝાર યાજક પાસે તે ઊભો રહે, ઉરીમના નિર્ણય વડે યહોવાહની સમક્ષ તેને માટે પૂછે. તેના કહેવાથી તેઓ, એટલે તે તથા ઇઝરાયલી લોકોની આખી જમાત બહાર જાય અને અંદર આવે. ");
INSERT INTO guj2017_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ તેણે કર્યું. તેણે યહોશુઆને લઈને એલાઝાર યાજક તથા સમગ્ર જમાતની સમક્ષ રજૂ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","યહોવાહે જેમ કરવાનું કહ્યું હતું તેમ મૂસાએ તેનો હાથ તેના પર મૂકીને સોંપણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","યહોવાહે મૂસા સાથે વાત કરતાં કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ઇઝરાયલ લોકોને આજ્ઞા કરીને તેઓને કહે, ‘તમારે નિશ્ચિત સમયે મારે સારુ બલિદાન ચઢાવવું, મારે સારુ સુવાસિત હોમયજ્ઞને સારુ મારું અન્ન તમે સંભાળીને તેમને યોગ્ય સમયે મને ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","તારે તેઓને કહેવું, “આ હોમયજ્ઞ જે તમારે યહોવાહને ચઢાવવો. પ્રતિદિન તમારે એક વર્ષના ખોડખાંપણ વગરના નર હલવાનોનું દહનીયાર્પણ કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","એક હલવાન તમારે સવારે ચઢાવવું અને બીજું હલવાન સાંજે ચઢાવવું. ");
INSERT INTO guj2017_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ખાદ્યાર્પણને સારુ એક દશાંશ એફાહ મેંદો, પા હિન કૂટીને કાઢેલો તેલથી મોહેલો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","તે રોજનું દહનીયાર્પણ છે જે યહોવાહની આજ્ઞા પ્રમાણે સુવાસને સારુ યહોવાહના હોમયજ્ઞ તરીકે સિનાઈ પર્વતમાં ઠરાવાયો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","પેયાર્પણ એક હલવાનને સારુ પા હિન દ્રાક્ષારસનું હોય. તમે યહોવાહને માટે પવિત્રસ્થાનમાં મધનું પેયાર્પણ રેડો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","બીજુ હલવાન તમે સાંજે ચઢાવો, સવારના ખાદ્યાર્પણની માફક અને સાંજના પેયાર્પણની માફક તમે તે ચઢાવો. આ સુવાસિત હોમયજ્ઞ યહોવાહને માટે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“વિશ્રામવારને દિવસે તમારે ખોડખાંપણ વગરના એક વર્ષની ઉંમરના બે હલવાન ચઢાવવા, ખાદ્યાર્પણ તરીકે બે દશાંશ એફાહ મેંદાનો લોટ તેલમાં મોહેલો અને તેનું પેયાર્પણ ચઢાવવું. ");
INSERT INTO guj2017_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","દરેક વિશ્રામવારનું દહનીયાપર્ણ અને રોજનું દહનીયાર્પણ અને પેયાર્પણ ઉપરાંત એ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","દરેક મહિનાના પ્રથમ દિવસે તમે યહોવાહને દહનીયાર્પણ ચઢાવો. તમે ખોડખાંપણ વગરના બે વાછરડો, એક ઘેટો અને એક વર્ષની ઉંમરના સાત નર હલવાન ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","પ્રત્યેક બળદને સારુ ત્રણ દશાંશ એફાહ તેલથી મોહેલો મેંદાનો લોટ ખાદ્યાર્પણ તરીકે અને એક ઘેટાંને સારુ બે દશાંશ એફાહ મેદાનો લોટ તેલથી મોહેલો ખાદ્યાર્પણ તરીકે ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","અને પ્રત્યેક હલવાન માટે તેલમાં મોહેલો એક દશાંશ એફાહ ખાદ્યાર્પણ તરીકે ચઢાવો. આ દહનીયાર્પણ યહોવાહને સારુ સુવાસિત હોમયજ્ઞ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","તેઓનાં પેયાર્પણ દરેક વાછરડા સાથે અડધો હિન, ઘેટાંની સાથે તૃતીયાંશ હિન અને હલવાન સાથે પા હિન દ્રાક્ષારસ હોય. વર્ષના પ્રત્યેક મહિનામાંના પ્રથમ દિવસનું આ દહનીયાર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","એક બકરો પાપાર્થાર્પણ તરીકે તમારે યહોવાહને ચઢાવવો. રોજના દહનીયાર્પણ અને તે સાથેના પેયાર્પણ ઉપરાંતનું આ અર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","પહેલા મહિનાને ચૌદમા દિવસે યહોવાહનું પાસ્ખાપર્વ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","આ મહિનાને પંદરમે દિવસે પર્વ રાખવું. સાત દિવસ સુધી બેખમીરી રોટલી ખાવી. ");
INSERT INTO guj2017_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","પ્રથમ દિવસે યહોવાહની સમક્ષ પવિત્ર સભા રાખવી. તે દિવસે રોજનું કામ કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","પણ તમારે યહોવાહને દહનીયાર્પણ એટલે હોમયજ્ઞ ચઢાવવું. તમે બે વાછરડા, એક ઘેટાં અને એક વર્ષની ઉંમરના ખોડખાંપણ વગરના સાત હલવાનો ચઢાવ. ");
INSERT INTO guj2017_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","બળદની સાથે ત્રણ દશાંશ એફાહ તેલથી મોહેલો મેંદાનો લોટ અને ઘેટાંની સાથે બે દશાંશ એફાહ ખાદ્યાર્પણ તરીકે ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","સાત હલવાનોમાંના દરેક હલવાન સાથે એક દશાંશ એફાહ મેંદાનો લોટ તેલથી મોહેલો તમારે ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","તમારા પોતાના માટે પ્રાયશ્ચિત કરવા સારુ પાપાર્થાર્પણ તરીકે તમે એક બકરાનું અર્પણ કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","સવારનું દહનીયાર્પણ કે જે નિયમિત દહનીયાર્પણ છે તે ઉપરાંત આ અર્પણો ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","સાત દિવસ સુધી દરરોજ યહોવાહને માટે સુવાસિત હોમયજ્ઞનું અન્ન તમે ચઢાવો. રોજના દહનીયાર્પણ તથા પેયાર્પણ તરીકે તે ચઢાવવામાં આવે. ");
INSERT INTO guj2017_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","સાતમા દિવસે યહોવાહના આદરમાં પવિત્રસભા કરવી અને તે દિવસે રોજનું કામ કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","પ્રથમ ફળના દિવસે, એટલે જયારે અઠવાડિયાનાં પર્વમાં તમે યહોવાહને નવું ખાદ્યાર્પણ ચઢાવો, ત્યારે પ્રથમ દિવસે, તમારે યહોવાહના આદરમાં પવિત્રસભા રાખવી, તે દિવસે તમારે રોજનું કામ કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","તમે યહોવાહને સુવાસને સારુ દહનીયાર્પણ ચઢાવો. એટલે તમારે બે વાછરડા, એક ઘેટાં તથા એક વર્ષના સાત નર હલવાનો ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","તેઓનું ખાદ્યાર્પણ તેલથી મોહેલા મેંદાના ત્રણ દશાંશ એફાહ દરેક બળદને સારુ, બે દશાંશ ઘેટાંને સારુ ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","તેલથી મોહેલો એક દશાંશ એફાહ મેંદો સાત હલવાનોમાંના દરેકને ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","તમારા પોતાના પ્રાયશ્ચિતને માટે એક બકરો અર્પણ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","રોજના દહનીયાર્પણ, ખાદ્યાર્પણ તથા પેયાર્પણ ઉપરાંત તમારે બલિદાન માટે ખામી વગરના પશુઓ ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","સાતમાં મહિનાના પ્રથમ દિવસે તમારે યહોવાહના આદરમાં પવિત્રસભા રાખવી. રોજનું નિયત કામ કરવું નહિ. તે દિવસ તમારે માટે રણશિંગડાં વગાડવાનો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","તે દિવસે તમે સુવાસને સારુ યહોવાહને દહનીયાર્પણ ચઢાવો. તમે ખામી વગરનો વાછરડો, એક ઘેટો, એક વર્ષની ઉંમરનાં સાત હલવાન ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","તેઓનું ખાદ્યાર્પણ તેલથી મોહેલા મેંદાનું, વાછરડાની સાથે ત્રણ દશાંશ એફાહ અને ઘેટાંની સાથે બે દશાંશ એફાહ ચઢાવ. ");
INSERT INTO guj2017_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","સાત હલવાનોમાંના દરેક હલવાનને સારુ એક એફાહ. ");
INSERT INTO guj2017_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","પોતાના માટે પ્રાયશ્ચિત કરવા પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","દરેક મહિનાને પહેલું દહનીયાર્પણ, તેનું ખાદ્યાર્પણ, રોજનું ખાદ્યાર્પણ તથા તેનાં પેયાર્પણો ચઢાવવાં. જ્યારે તું આ અર્પણો ચઢાવે ત્યારે યહોવાહને સારુ સુવાસિત હોમયજ્ઞ ચઢાવવાના વિધિ તું પાળજે. ");
INSERT INTO guj2017_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","સાતમા મહિનાને દસમે દિવસે યહોવાહના આદરમાં પવિત્રસભા રાખવી. તે દિવસે તમારે પોતાને નમ્ર કરવું અને કોઈ કામ ન કરવું. ");
INSERT INTO guj2017_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","તમારે યહોવાહને સુવાસિત દહનીયાર્પણ ચઢાવવો. તમે ખામી વગરનો એક વાછરડો, એક ઘેટો તથા એક વર્ષની ઉંમરના સાત નર હલવાનો ચઢાવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","તમારે વાછરડા સાથે ત્રણ દશાંશ એફાહ તેલથી મોહેલો મેંદો અને ઘેટા સાથે બે દશાંશ એફાહ મેંદો ચઢાવવો, ");
INSERT INTO guj2017_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","એક દશાંશ એફાહ સાત હલવાનોમાંના દરેક હલવાન માટે. ");
INSERT INTO guj2017_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","વળી પાપાર્થાર્પણ માટે તમારે એક બકરાનું બલિદાન આપવું. પ્રાયશ્ચિતના દિવસનું પાપાર્થાર્પણ વર્ષમાં એક વખત તે પ્રાયશ્ચિતના દિવસે અર્પણ કરવામાં આવતું અને પ્રતિદિન થતાં દહનીયાર્પણ, ખાદ્યાર્પણો અને પેયાર્પણો ઉપરાંતનું આ અર્પણ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","સાતમા મહિનાના પંદરમે દિવસે તમારે યહોવાહના આદરમાં પવિત્રસભા રાખવી. રોજનું નિયત કામ કરવું નહિ, સાત દિવસ સુધી યહોવાહને માટે પર્વ પાળો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","તે દિવસે તમે યહોવાહને માટે દહનીયાર્પણ, યહોવાહને સારુ સુવાસિત હોમયજ્ઞ ચઢાવો. તમારે ખામી વગરના તેર વાછરડા, બે ઘેટાં અને એક વર્ષની ઉંમરના ચૌદ નર હલવાન ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","તેર બળદોમાંનાં દરેક બળદની સાથે તેઓનું ખાદ્યાર્પણ ત્રણ દશાંશ એફાહ તેલથી મોહેલા મેંદાનું ચઢાવવું, બે દશાંશ બે ઘેટામાંના દરેક ઘેટાંની સાથે, ");
INSERT INTO guj2017_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","એક દશાંશ એફાહ ચૌદ હલવાનોમાંના દરેક હલવાન સાથે. ");
INSERT INTO guj2017_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","નિયમિત થતાં દહનીયાર્પણો, ખાદ્યાર્પણો તથા પેયાર્પણ ઉપરાંત પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","સભાના બીજે દિવસે તમારે બાર વાછરડા, બે ઘેટાં તથા એક વર્ષની ઉંમરના ખોડખાંપણ વગરના ચૌદ નર હલવાનો ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","તેઓનું ખાદ્યાર્પણ તથા તેઓનાં પેયાર્પણો બળદોને સારુ, ઘેટાઓને સારુ, હલવાનોને સારુ, તેઓની ગણતરી પ્રમાણે તથા વિધિ મુજબ ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","તદુપરાંત પ્રતિદિન થતાં દહનીયાર્પણ, તેઓનાં ખાદ્યાર્પણ તથા તેઓનાં પેયાર્પણ ઉપરાંત પાપાર્થાર્પણને માટે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","સભાના ત્રીજા દિવસે અગિયાર બળદો, બે ઘેટા તથા એક વર્ષની ઉંમરના ખામી વગરના ચૌદ હલવાનો ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","તથા તેની સાથે તેઓની ગણતરી પ્રમાણે તથા વિધિ પ્રમાણે તેઓનાં ખાદ્યાર્પણ તથા પેયાર્પણ બળદોને સારુ, ઘેટાઓને સારુ, હલવાનોને સારુ ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","પ્રતિદિન થતાં દહનીયાર્પણો, ખાદ્યાર્પણો અને પેયાર્પણ ઉપરાંત પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","સભાના ચોથા દિવસે દસ બળદો, બે ઘેટા તથા એક વર્ષની ઉંમરના ખામી વગરના ચૌદ નર હલવાનો ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","તેઓની ગણતરી તથા વિધિ પ્રમાણે તેઓના ખાદ્યાર્પણ તથા તેઓનાં પેયાર્પણ બળદોને સારુ, ઘેટાઓને સારુ તથા હલવાનોને સારુ ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","પ્રતિદિન થતાં દહનીયાર્પણ, ખાદ્યાર્પણ તથા પેયાર્પણો ઉપરાંત પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","સભાના પાંચમા દિવસે નવ વાછરડા, બે ઘેટા અને એક વર્ષની ઉંમરના ખામી વગરના ચૌદ હલવાન ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","તેઓની ગણતરી તથા વિધિ પ્રમાણે તેઓનું ખાદ્યાર્પણ તથા તેઓનાં પેયાર્પણો બળદોને સારુ, ઘેટાઓને સારુ તથા હલવાનોને સારુ ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","પ્રતિદિન થતાં દહનીયાર્પણ, તેઓનાં ખાદ્યાર્પણ તથા તેઓનાં પેયાર્પણો ઉપરાંત પાપાર્થાર્પણ માટે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","સભાના છઠ્ઠા દિવસે આઠ વાછરડા, બે ઘેટા તથા એક વર્ષની ઉંમરના ખામી વગરના ચૌદ હલવાન ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","તેઓની ગણતરી તથા વિધિ પ્રમાણે તેઓનાં ખાદ્યાર્પણ તથા પેયાર્પણો બળદોને સારુ, ઘેટાઓને સારુ તથા હલવાનોને સારુ ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","પ્રતિદિન થતાં દહનીયાર્પણ, તેઓનાં ખાદ્યાર્પણ તથા તેઓના પેયાર્પણો ઉપરાંત પાપાર્થાર્પણને માટે એક બકરો ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","સભાના સાતમા દિવસે સાત વાછરડા, બે ઘેટા અને એક વર્ષની ઉંમરના ખામી વગરના ચૌદ હલવાન ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","તેઓની ગણતરી તથા વિધિ પ્રમાણે ખાદ્યાર્પણ તથા પેયાર્પણો બળદોને સારુ, ઘેટાઓને સારુ તથા હલવાનોને સારુ ચઢાવવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","પ્રતિદિન થતાં દહનીયાર્પણ, ખાદ્યાર્પણ અને પેયાર્પણો ઉપરાંત પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","આઠમા દિવસે તમારે બીજી પવિત્ર સભા રાખવી. તમારે બીજું કામ કરવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","તમારે યહોવાહને સુવાસિત હોમયજ્ઞ એટલે દહનીયાર્પણ ચઢાવવું. તારે એક બળદ, એક ઘેટો અને એક વર્ષની ઉંમરના ખામી વગરના સાત હલવાન ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","તેઓની ગણતરી તથા વિધિ પ્રમાણે તેઓના ખાદ્યાર્પણ તથા તેઓના પેયાર્પણો બળદોને સારુ, ઘેટાઓને સારુ તથા હલવાનોને સારુ ચઢાવવા. ");
INSERT INTO guj2017_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","પ્રતિદિન થતાં દહનીયાર્પણ, ખાદ્યાર્પણ તથા પેયાર્પણો ઉપરાંત તમારે પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. ");
INSERT INTO guj2017_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","તમારાં આ દહનીયાર્પણો, ખાદ્યાર્પણો, પેયાર્પણો તથા શાંત્યર્પણો, તમારી પ્રતિજ્ઞાઓ તથા ઐચ્છિકાર્પણો તમારા ઠરાવેલા ઉત્સવોમાં યહોવાહને ચઢાવવાં.” ");
INSERT INTO guj2017_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","યહોવાહે મૂસાને જે આજ્ઞા આપી હતી તે પ્રમાણે સર્વ બાબતો તેણે ઇઝરાયલી લોકોને કહી સંભળાવી. ");
INSERT INTO guj2017_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","મૂસાએ ઇઝરાયલી લોકોના કુળના આગેવાનોને કહ્યું, “યહોવાહે આજ્ઞા આપી તે આ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","જયારે કોઈ વ્યક્તિ યહોવાહ માટે, પોતાને માટે સમ ખાઈને વચન લે, તો તે પોતાનું વચન તોડે નહિ. તે તેના મુખ દ્વારા જે બોલ્યો હોય તે સર્વ કરવા માટે તેણે પોતાનું વચન પાળવું. ");
INSERT INTO guj2017_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","જો કોઈ કુંવારી સ્ત્રી યહોવાહને નામે સંકલ્પ કરે, પોતાના પિતાના ઘરે રહીને, વચનથી પોતાને આધીન કરે, ");
INSERT INTO guj2017_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","જે વચનો અને સંકલ્પો દ્વારા તેણે પોતાની આધીનતા દર્શાવી હોય તે વિષે જ્યારે તેના પિતાના સાંભળવામાં આવ્યું હોય, છતાં તેના પિતાએ કંઈ કહ્યું ન હોય, તો તેનો સંકલ્પ કાયમ રહે. જે વચનથી તેણે પોતાને આધીન કરેલી છે તે કાયમ રહે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","પણ તેના પિતા તે વિષે સાંભળીને તે દિવસે જો તેને મનાઈ કરે, તો જે સંકલ્પો તથા વચનો જે વડે તેણે પોતાની આધીનતા દર્શાવેલી છે તે કાયમ રહે. તેના પિતાએ તેને ના પાડી હોવાથી યહોવાહ તેને મુક્ત કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","જ્યારે તેણે સંકલ્પો કર્યા હોય અથવા પોતાના હોઠોથી અવિચારી રીતે બોલીને પોતાને આધીન કરી હોય અને જો તે લગ્ન કરે, ");
INSERT INTO guj2017_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","અને જો તેનો પતિ તે વિષે સાંભળીને તે દિવસે તેને મના ન કરે, તો તેના સંકલ્પો કાયમ રહે. જે વચન વડે તેણે પોતાને આધીન કરેલી હોય તે કાયમ રહે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","પણ તેનો પતિ તે વિષે સાંભળીને જો તે દિવસે તેને મના કરે, તો જે સંકલ્પ તેણે કર્યા છે, પોતાના હોઠોની અવિચારી વાતોથી તેણે પોતાની આધીનતા દર્શાવી છે, તે રદ કરે. તેથી યહોવાહ તેને મુક્ત કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","પણ વિધવા અથવા છૂટાછેડા પામેલી સ્ત્રી માટે, દરેક સંપર્કથી તેણે પોતાની આધીનતા દર્શાવી તે પ્રતિજ્ઞા તેને માટે કાયમ રહે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","જો તે સ્ત્રીએ તેના પતિના ઘરમાં સંકલ્પ કર્યો હોય કે, સમથી પોતાને આધીન કરી હોય, ");
INSERT INTO guj2017_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","તેનો પતિ તે વિષે સાંભળીને તેને કશું કહે નહિ અને જો તે તેનો સંકલ્પ નાબૂદ કરે નહિ, તો તેના બધા સંકલ્પો કાયમ રહે. દરેક વચન જે વડે તેણે પોતાને આધીન કરી હોય તે કાયમ રહે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","પણ તેનો પતિ સાંભળે તે દિવસે જો તે નાબૂદ કરે, તો જે સંકલ્પો તથા વચનો તેના વિષે તેના મુખમાંથી નીકળ્યા છે તે કાયમ રહે નહિ. તેના પતિએ તેને નાબૂદ કર્યા છે. યહોવાહ તેને મુક્ત કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","દરેક સંકલ્પ તથા આત્મકષ્ટ કરવા માટેના તેના બંધનકારક સમને તેનો પતિ માન્ય કે અમાન્ય કરી શકે છે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","પરંતુ જો તે તેને દિનપ્રતિદિન કંઈ જ ન કહે, તો જે સંકલ્પો તથા વચનો જે વડે તેણે પોતાને આધીન કરી હોય તે કાયમ રહે. તેણે તે કાયમ રાખ્યા છે કેમ કે તેણે તે સમયે તેને કંઈ જ કહ્યું નહિ કે તેણે તે વિષે સાંભળ્યું છે. ");
INSERT INTO guj2017_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","પણ જો તેનો પતિ તે વિષે સાંભળીને લાંબા સમય સુધી તેની પત્નીના સંકલ્પ રદ ન કરે, તો તે સ્ત્રીનાં પાપ માટે તે જવાબદાર થશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","પતિ તથા પત્ની વચ્ચે, તેમ જ પિતા તથા તેના નાનપણમાં તેના ઘરમાં રહેતી તેની દીકરી વચ્ચે યહોવાહે મૂસાને જે કાનૂનો જણાવ્યા તે આ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ઇઝરાયલી લોકોનો બદલો તું મિદ્યાનીઓ પાસેથી લે. તેવું કર્યા પછી તું તારા લોકો સાથે ભળી જઈશ.” ");
INSERT INTO guj2017_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","તેથી મૂસાએ લોકોને કહ્યું, “તમારામાંથી કેટલાક માણસો શસ્ત્રસજજ થઈને યહોવાહ તરફથી મિદ્યાનીઓ પાસેથી બદલો લેવા મિદ્યાનીઓ ઉપર હુમલો કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ઇઝરાયલના પ્રત્યેક કુળમાંથી એક હજાર સૈનિકોને યુદ્ધમાં મોકલવા.” ");
INSERT INTO guj2017_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ઇઝરાયલના હજારો પુરુષોમાંથી પ્રત્યેક કુળમાંથી એક હજાર પુરુષ મુજબ મૂસાએ બાર હજાર પુરુષોને શસ્ત્રસજજ કરીને યુદ્ધને માટે મોકલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","પછી મૂસાએ દરેક કુળમાંથી હજાર પુરુષોને યુદ્ધમાં મોકલ્યા, એલાઝાર યાજકના દીકરા ફીનહાસને પવિત્રસ્થાનનાં પાત્રો તથા યુદ્ધનાદ કરવાના રણશિંગડાં લઈને યુદ્ધમાં મોકલ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","યહોવાહે જેમ મૂસાને આજ્ઞા આપી હતી તેમ તેઓએ મિદ્યાનીઓ વિરુદ્ધ લડાઈ કરી. તેઓએ તમામ માણસોને મારી નાખ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","યુદ્ધમાં માર્યા ગયેલા ઉપરાંત તેઓએ મિદ્યાનીઓના રાજા અવી, રેકેમ, સૂર, હૂર તથા રેબા એ પાંચ મિદ્યાની રાજાઓને મારી નાખ્યા. વળી તેઓએ બેઓરના દીકરા બલામને પણ તલવારથી મારી નાખ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ઇઝરાયલના સૈન્યએ મિદ્યાની સ્ત્રીઓને તથા તેઓનાં બાળકોને કેદ કરી લીધાં, તેઓનાં ઘેટાંબકરાં સહિત તમામ જાનવરોને તથા તેઓના બધા સરસામાનને લૂંટી લીધાં. આ બધું તેઓએ લૂંટ તરીકે આંચકી લીધું. ");
INSERT INTO guj2017_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","જ્યાં તેઓ રહેતા હતા તે બધાં નગરોને તથા તેઓની બધી છાવણીઓને તેઓએ બાળી નાખ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","તેઓએ કેદીઓ એટલે માણસ તથા પશુઓ બન્નેની લૂંટફાટ લીધી. ");
INSERT INTO guj2017_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","તેઓ કેદીઓને તથા લૂંટ કરેલી વસ્તુઓને મૂસા, એલાઝાર યાજક તથા ઇઝરાયલ લોકોની જમાત પાસે લાવ્યા. આ બધું તેઓ મોઆબના મેદાનમાં યરીખોની સામે યર્દન નદીને કિનારે આવેલી છાવણીમાં લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","મૂસા, એલાઝાર યાજક તથા જમાતના આગેવાનો તેઓને મળવા માટે છાવણી બહાર આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","પણ મૂસા સૈન્યના અધિકારી, સહસ્રાધિપતિ તથા શતાધિપતિ જેઓ યુદ્ધમાંથી આવ્યા હતા તેઓ પર ગુસ્સે હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","મૂસાએ તેઓને કહ્યું, “શું તમે બધી સ્ત્રીઓને જીવતી રહેવા દીધી છે? ");
INSERT INTO guj2017_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","જુઓ, આ સ્ત્રીઓએ બલામની સલાહથી ઇઝરાયલી લોકો પાસે, પેઓરની બાબતમાં યહોવાહની વિરુદ્ધ પાપ કર્યું, તેથી યહોવાહની જમાત મધ્યે મરકી ચાલી. ");
INSERT INTO guj2017_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","તો હવે, બાળકો મધ્યેથી દરેક પુરુષને મારી નાખો, દરેક સ્ત્રી જે પુરુષ સાથે સૂઈ ગઈ હોય તેને મારી નાખો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","પણ તમારા માટે દરેક જુવાન કન્યાઓ લો જે ક્યારેય કોઈ માણસ સાથે સૂઈ ગઈ ના હોય. ");
INSERT INTO guj2017_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","તમે સાત દિવસ સુધી છાવણીની બહાર એટલે ઇઝરાયલની છાવણીની બહાર રહો. તમારામાંના જે કોઈએ કોઈને મારી નાખ્યો હોય કે કોઈએ મરણ પામેલાનો સ્પર્શ કર્યો હોય, ત્રીજા દિવસે તથા સાતમા દિવસે તું તથા તારા કેદીઓ પોતાને શુદ્ધ કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","તમારાં બધાં વસ્ત્ર, ચામડાની તથા બકરાના વાળથી બનેલી દરેક વસ્તુ તથા લાકડાની બનાવેલી દરેક વસ્તુથી પોતાને શુદ્ધ કરો.” ");
INSERT INTO guj2017_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","જે સૈનિકો યુદ્ધમાં ગયા હતા તેઓને એલાઝાર યાજકે કહ્યું, “યહોવાહે મૂસાને જે નિયમ આપ્યો તે આ છે: ");
INSERT INTO guj2017_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","સોનું, ચાંદી, કાંસું, લોખંડ, કલાઈ અને સીસું, ");
INSERT INTO guj2017_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","જે દરેક વસ્તુ અગ્નિનો સામનો કરી શકે, તે તમે અગ્નિમાં નાખો અને તે શુદ્ધ થશે. શુદ્ધિના પાણી વડે તે વસ્તુઓ શુદ્ધ કરવામાં આવે. જે કંઈ અગ્નિમાં ટકી ન શકે તેને તમે પાણીથી શુદ્ધ કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","અને સાતમા દિવસે તમે તમારા વસ્ત્રો ધોઈ નાખો, ત્યાર પછી તમે શુદ્ધ થશો. ત્યાર પછી તમે ઇઝરાયલની છાવણીમાં પાછા આવો.” ");
INSERT INTO guj2017_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“તું, એલાઝાર યાજક, જમાતના પિતૃઓના કુળના આગેવાનો મળીને, જે માણસો તથા પશુઓ કે જેઓની લૂંટ કરવામાં આવી તેઓની ગણતરી કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","લૂંટના બે ભાગ પાડો. તેને જે સૈનિકો યુદ્ધમાં ગયા હતા તેઓ તથા બાકીની આખી જમાત વચ્ચે વહેંચો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","જે સૈનિકો યુદ્ધમાં ગયા હતા તેઓ પાસેથી કર લઈને મને આપો. દરેક પાંચસો પશુઓમાંથી એક પશુ, એટલે માણસોમાંથી તથા જાનવરોમાંથી, ગધેડામાંથી, ઘેટાં કે બકરામાંથી લેવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","તેઓના અડધામાંથી તે લો અને મારા માટે ઉચ્છાલીયાર્પણ તરીકે એલાઝાર યાજકને તે આપો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ઇઝરાયલી લોકોના અડધામાંથી, દર પચાસ વ્યક્તિમાંથી, ગધેડાંમાંથી, ઘેટા તથા બકરામાંથી તથા અન્ય જાનવરોમાંથી લેવાં. જે લેવીઓ યહોવાહના મંડપની સંભાળ લે છે તેઓને આપો.” ");
INSERT INTO guj2017_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","તેથી યહોવાહે આજ્ઞા કરી હતી તે પ્રમાણે મૂસાએ તથા યાજક એલાઝારે કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","સૈનિકોએ જે લૂંટ લીધી હતી તેની યાદી: છ લાખ પંચોતેર હજાર ઘેટાં, ");
INSERT INTO guj2017_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","બોતેર હજાર બળદો, ");
INSERT INTO guj2017_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","એકસઠ હજાર ગધેડાં, ");
INSERT INTO guj2017_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","બત્રીસ હજાર સ્ત્રીઓ જે ક્યારેય કોઈ માણસ સાથે સૂઈ ગઈ ન હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","યુદ્ધમાં ગયેલા સૈનિકોને લૂંટમાંથી જે અડધો ભાગ મળ્યો તે ત્રણ લાખ સાડત્રીસ હજાર ઘેટાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ઘેટાંમાંથી યહોવાહનો ભાગ છસો પંચોતેર હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","છત્રીસ હજાર બસો બળદમાંથી યહોવાહનો કર બોતેર હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ત્રીસ હજારને પાંચસો ગધેડાં; જેમાંથી યહોવાહનો ભાગ એકસઠ હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","જે માણસો સોળ હજાર હતા જેમાંથી યહોવાહનો કર બત્રીસ માણસોનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","યહોવાહે મૂસાને આજ્ઞા આપી હતી તે પ્રમાણે મૂસાએ એ કર એટલે યહોવાહનું ઉચ્છાલીયાર્પણ એલાઝાર યાજકને આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ઇઝરાયલી લોકોનો જે અડધો ભાગ મૂસાએ યુદ્ધમાં ગયેલા સૈનિકો પાસેથી લીધો હતો તે, ");
INSERT INTO guj2017_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","જમાતનો અડધા ભાગમાં ત્રણ લાખ સાડત્રીસ હજાર પાંચસો ઘેટાં, ");
INSERT INTO guj2017_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","છત્રીસ હજાર બળદો, ");
INSERT INTO guj2017_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ત્રીસ હજાર પાંચસો ગધેડાં, ");
INSERT INTO guj2017_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","સોળ હજાર માણસો હતાં. ");
INSERT INTO guj2017_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","જેમ યહોવાહે મૂસાને આજ્ઞા આપી હતી તેમ મૂસાએ ઇઝરાયલી લોકોના અડધા ભાગમાંથી દરેક પચાસ માણસમાંથી તથા પશુઓમાંથી એક લઈને યહોવાહના મંડપની સંભાળ રાખનાર લેવીઓને તે આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","પછી સૈન્યના સેનાપતિઓ, સહસ્રાધિપતિઓ તથા શતાધિપતિઓ મૂસા પાસે આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","તેઓએ મૂસાને કહ્યું, “જે સૈનિકો અમારા હાથ નીચે છે તેઓની તારા દાસોએ ગણતરી કરી છે, એક પણ માણસ ઓછો થયો નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","અમારા માટે યહોવાહની આગળ પ્રાયશ્ચિત કરવાને સારુ દરેક માણસને જે મળ્યું તે અમે યહોવાહને સારુ અર્પણ કરવાને લાવ્યા છીએ, એટલે સોનાનાં ઘરેણાં, સાંકળા, બંગડીઓ, વીંટીઓ, બુટીઓ તથા હારો લાવ્યા છીએ.” ");
INSERT INTO guj2017_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","મૂસાએ તથા યાજક એલાઝાર યાજકે તેઓની પાસેથી સોનું તથા હાથે ઘડેલાં સર્વ પાત્રો લીધાં. ");
INSERT INTO guj2017_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ઉચ્છાલીયાર્પણનું સોનું સહસ્રાધિપતિઓ તથા શતાધિપતિઓ પાસેથી યહોવાહને ચઢાવ્યું તેનું વજન સોળ હજાર સાતસો પચાસ શેકેલ હતું. ");
INSERT INTO guj2017_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","દરેક સૈનિકે પોતપોતાને માટે લૂંટ લઈ લીધી હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","મૂસા તથા એલાઝાર યાજક સહસ્રાધિપતિ તથા શતાધિપતિઓ પાસેથી સોનું લઈને યહોવાહ માટે ઇઝરાયલ લોકોના સ્મરણાર્થે મુલાકાતમંડપમાં લાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","હવે રુબેનના તથા ગાદના વંશજો પાસે મોટી સંખ્યામાં જાનવરો હતાં. જયારે તેઓએ જોયું કે યાઝેરનો તથા ગિલ્યાદનો દેશ જાનવરો માટે અનુકૂળ જગ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","તેથી રુબેન તથા ગાદના વંશજોએ મૂસા, એલાઝાર યાજક તથા સમાજના આગેવાનો પાસે આવીને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“અટારોથ, દીબોન, યાઝેર, નિમ્રાહ, હેશ્બોન, એલઆલેહ, સબામ, નબો તથા બેઓન. ");
INSERT INTO guj2017_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","એટલે ઇઝરાયલી લોકોની આગળ જે દેશ પર યહોવાહે હુમલો કર્યો તે દેશ જાનવરોના માટે ખૂબ અનુકૂળ છે. તારા દાસો પાસે પુષ્કળ પશુસંપત્તિ છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","તેઓએ કહ્યું, “જો અમે તારી દ્રષ્ટિમાં કૃપા પામ્યા હોય, તો અમને એટલે તારા દાસોને આ દેશ વતન તરીકે આપ. યર્દન પાર અમને લઈ ન જા.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","મૂસાએ ગાદ તથા રુબેનના વંશજોને કહ્યું, “શું તમારા ભાઈઓ યુદ્ધમાં જાય છે ત્યારે તમે અહીં બેસી રહેશો? ");
INSERT INTO guj2017_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ઇઝરાયલી લોકોને જે દેશ યહોવાહે આપ્યો છે તેમાં જવા માટે તેઓનાં હૃદય તમે કેમ નિરાશ કરો છો? ");
INSERT INTO guj2017_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","જ્યારે મેં તમારા પિતૃઓને કાદેશ બાર્નેઆથી દેશની જાસૂસી કરવા મોકલ્યા, ત્યારે તેઓએ એમ જ કર્યુ, ");
INSERT INTO guj2017_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","જ્યારે તેઓએ એશ્કોલ ખીણમાં જઈને તે દેશ જોયો ત્યારે તેઓએ ઇઝરાયલી લોકોનાં હૃદય નિરાશ કરી નાખ્યાં કે જેથી તેઓ જે દેશ યહોવાહે તેઓને આપ્યો છે તેમાં પ્રવેશ કરે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","આથી તે દિવસે યહોવાહ કોપાયમાન થયા. તેમણે સમ ખાઈને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘વીસ વર્ષના કે તેથી વધારે ઉંમરના જે માણસો મિસર દેશમાંથી બહાર આવ્યા તેઓમાંનો કોઈ પણ જે દેશ વિષે મેં ઇબ્રાહિમ, ઇસહાક તથા યાકૂબ આગળ સમ ખાધા તેને જોવા પામશે નહિ. કેમ કે તેઓ મારી પાછળ પૂરા મનથી ચાલ્યા નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","કનિઝી યફૂન્નેનો દીકરો કાલેબ તથા નૂનનો દીકરો યહોશુઆ. ફક્ત કાલેબ તથા યહોશુઆ પૂરા મનથી મારી પાછળ ચાલ્યા હતા.’” ");
INSERT INTO guj2017_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","તેથી ઇઝરાયલ ઉપર યહોવાહ કોપાયમાન થયા. તેમણે તેમને ચાલીસ વર્ષ સુધી, જે પેઢીએ યહોવાહની દ્રષ્ટિમાં ખોટું કર્યું હતું તે બધાનો નાશ થાય ત્યાં સુધી તેઓને અરણ્યમાં ચારે બાજુ ભટકાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","જુઓ, તમે પાપી લોકો જેવા, તમારા પિતાઓની જગ્યાએ ઊભા થઈને, ઇઝરાયલ પ્રત્યે યહોવાહનો ગુસ્સો હજી પણ વધુ સળગાવ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","જો તમે તેની પાછળથી ફરી જશો, તો તેઓ ફરીથી ઇઝરાયલને અરણ્યમાં ભટકતા મૂકી દેશે અને તમારાથી આ બધા લોકોનો નાશ થશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","તેથી તેઓએ મૂસાની પાસે આવીને કહ્યું, “અહીં અમને અમારાં ઘેટાંબકરાં માટે વાડા અને અમારા કુટુંબો માટે નગરો બાંધવા દે. ");
INSERT INTO guj2017_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ત્યાર બાદ અમે જાતે શસ્ત્રસજજ થઈને ઇઝરાયલી લોકોની આગળ રહી તેઓને તેઓની જગ્યાએ પહોંચાડતા સુધી લડીશું. પણ અમારા કુટુંબો આ દેશના રહેવાસીઓને લીધે કિલ્લેબંધીવાળા નગરોમાં રહેશે. ");
INSERT INTO guj2017_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ઇઝરાયલી લોકોમાંનો દરેક પોતાનો વારસો ન પામે ત્યાં સુધી અમે પોતાના ઘરે પાછા ફરીશું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","અમે યર્દન નદીને પેલે પારના દેશમાં તેઓની સાથે વારસો નહિ લઈએ, કેમ કે, યર્દન નદીને પૂર્વ કિનારે અમને વારસો મળી ચૂક્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","મૂસાએ તેઓને કહ્યું, “જો તમે જે કહ્યું છે તે પ્રમાણે કરશો અને સજ્જ થઈને યહોવાહની આગળ તમે યુદ્ધ માટે જશો. ");
INSERT INTO guj2017_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","જ્યાં સુધી યહોવાહ પોતાના શત્રુઓને પોતાની આગળથી કાઢી મૂકે ત્યાં સુધી તમે શસ્ત્રસજ્જિત માણસો યહોવાહની આગળથી યર્દન પાર જશો. ");
INSERT INTO guj2017_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","તે દેશ યહોવાહના તાબામાં થાય. ત્યારપછી તમે પાછા આવજો. તમે યહોવાહ તથા ઇઝરાયલ પ્રત્યે નિર્દોષ ઠરશો. યહોવાહની આગળ આ દેશ તમારું વતન થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","પરંતુ જો તમે તે નહિ કર્યું હોય તો તમે યહોવાહની વિરુદ્ધનું પાપ કર્યું ગણાશે. નિશ્ચે તમારું પાપ તમને પકડી પાડશે. ");
INSERT INTO guj2017_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","તમારાં કુટુંબો માટે નગરો તથા તમારાં જાનવરો માટે વાડા બાંધો; પછી તમે જે કહ્યું છે તેમ કરો.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ગાદ તથા રુબેનના વંશજોએ મૂસાને કહ્યું, “અમારા માલિકની આજ્ઞા પ્રમાણે અમે તારા દાસો કરીશું. ");
INSERT INTO guj2017_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","અમારાં બાળકો, અમારી સ્ત્રીઓ, અમારાં ઘેટાબકરાં સહિત અમારાં તમામ જાનવરો સહિત અહીં ગિલ્યાદના નગરોમાં રહીશું. ");
INSERT INTO guj2017_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","પણ યુદ્ધને માટે સજ્જ થયેલો તારા બધા દાસો મારા માલિકના કહેવા પ્રમાણે યર્દન પાર યહોવાહની સમક્ષ લડાઈ કરવાને જઈશું.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","તેથી મૂસાએ એલાઝાર યાજક, નૂનનો દીકરો યહોશુઆ તથા ઇઝરાયલના કુળના કુટુંબોના આગેવાનોને સૂચના આપીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","મૂસાએ તેઓને કહ્યું, “જો ગાદના તથા રુબેનના વંશજો યુદ્ધને સારુ હથિયાર સજીને દરેક માણસ યહોવાહની આગળ તમારી સાથે લડાઈ કરવાને યર્દનને પેલે પાર જાય, જો તે દેશ તમારા તાબામાં આવી જાય તો તમે તેઓને ગિલ્યાદનો દેશ વતન તરીકે આપજો. ");
INSERT INTO guj2017_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","પણ જો તેઓ શસ્ત્રસજ્જ થઈને તમારી સાથે યર્દનને પાર ન જાય તો તેઓને કનાન દેશમાં તમારી મધ્યે વતન મળશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ગાદના તથા રુબેનના વંશજોએ જવાબ આપીને કહ્યું, “જેમ યહોવાહે તારા દાસોને કહ્યું છે તે પ્રમાણે અમે કરીશું. ");
INSERT INTO guj2017_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","અમે શસ્ત્રસજ્જ થઈને યહોવાહની આગળ યર્દન પાર કરીને કનાનના દેશમાં જઈશું, પણ યર્દન નદીના પૂર્વ કાંઠે અમારા વારસાની જમીન રહેશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","આથી મૂસાએ ગાદના તથા રુબેનના વંશજોને તથા યૂસફના દીકરા મનાશ્શાના અર્ધકુળને અમોરીઓના રાજા સીહોનનું રાજ્ય તથા બાશાનના રાજા ઓગનું રાજ્ય આપ્યું. તેણે તેઓને તે દેશ, તેની સરહદો સાથે તેના બધા નગરો તથા તે દેશની આજુબાજુનાં બધાં નગરો આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ગાદના વંશજોએ દીબોન, અટારોથ, અરોએર, ");
INSERT INTO guj2017_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","આટ્રોથ-શોફાન, યાઝેર, યોગ્બહાહ, ");
INSERT INTO guj2017_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","બેથ-નિમ્રાહ તથા બેથ-હારાન એ કિલ્લાવાળા નગરો બાંધ્યા તથા ઘેટાંને માટે વાડા બાંધ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","રુબેનના વંશજોએ હેશ્બોન, એલઆલેહ, કિર્યાથાઈમ, ");
INSERT INTO guj2017_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","નબો, બઆલ-મેઓન પછી તેઓના નામ બદલીને તથા સિબ્માહ બાંધ્યાં. જે નગરો તેઓએ બાંધ્યાં તેઓને તેઓએ બીજાં નામ આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","મનાશ્શાના દીકરા માખીરના વંશજોએ ગિલ્યાદ જઈને તેને જીતી લીધું અને તેમાં રહેતા અમોરીઓને કાઢી મૂક્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","મૂસાએ મનાશ્શાના દીકરા માખીરને ગિલ્યાદ આપ્યું અને તેના લોકો ત્યાં રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","મનાશ્શાના દીકરા યાઈરે ત્યાં જઈને તેનાં નગરો કબજે કરી લીધાં અને તેઓને હાવ્વોથ-યાઈર એવું નામ આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","નોબાહે કનાથ જઈને તેનાં ગામો કબજે કરી લીધાં. અને તેના પોતાના નામ પરથી તેનું નામ નોબાહ પાડ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","મૂસા અને હારુનની આગેવાની હેઠળ ઇઝરાયલી લોકો પોતાનાં સૈન્ય જૂથો સહિત મિસર દેશમાંથી બહાર આવ્યા પછી તે લોકોએ જે જે ઠેકાણે મુસાફરી કરી તે આ છે: ");
INSERT INTO guj2017_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","જ્યાંથી તેઓ રવાના થયા અને જ્યાં ગયા તે સ્થળોનાં નામ મૂસાએ યહોવાહની આજ્ઞા અનુસાર નોંધી લીધાં હતાં. તેઓની મજલો પ્રમાણે તેઓની કૂચ આ છે. ");
INSERT INTO guj2017_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","તેઓ પહેલા મહિને, એટલે પહેલા મહિનાના પંદરમા દિવસે રામસેસથી રવાના થયા. પાસ્ખાપર્વ પછીની સવારે ઇઝરાયલી લોકો મિસરવાસીઓના દેખતાં જાહેરમાં નીકળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","જ્યારે મિસરવાસીઓ પોતાના પ્રથમજનિતો જેઓને યહોવાહે તેઓની મધ્યેથી મારી નાખ્યા તેઓને દફ્નાવતા હતા તે સમયે એવું બન્યું. યહોવાહે બતાવ્યું કે તેમના દેવો કરતા તે વધુ સામર્થ્ય છે. ");
INSERT INTO guj2017_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ઇઝરાયલીઓએ રામસેસથી નીકળીને સુક્કોથમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","તેઓએ સુક્કોથથી નીકળીને અરણ્ય કિનારે આવેલા એથામમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","તેઓ એથામથી નીકળીને પાછા ફરીને બઆલ-સફોનની પાસે આવેલ પી-હાહીરોથ આવ્યા, ત્યાં તેઓએ મિગ્દોલની સામે છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","પછી પી-હાહીરોથથી નીકળીને સમુદ્ર મધ્યે થઈને તેઓ અરણ્યમાં ગયા. તેઓએ એથામના અરણ્યમાં ત્રણ દિવસ મુસાફરી કરીને મારાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","તેઓ મારાહથી આગળ વધીને એલીમ આવ્યા. એલીમમાં પાણીના બાર ઝરા અને ખજૂરીનાં સિત્તેર વૃક્ષો હતાં. ત્યાં તેઓએ છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","તેઓએ એલીમથી નીકળીને લાલ સમુદ્ર પાસે છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","તેઓએ લાલ સમુદ્રથી નીકળીને સીનના અરણ્યમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","તેઓએ સીનના અરણ્યમાંથી નીકળીને દોફકાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","દોફકાહથી નીકળીને આલૂશમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","તેઓએ આલૂશથી નીકળીને રફીદીમમાં છાવણી કરી. ત્યાં લોકોને માટે પીવાનું પાણી નહોતું. ");
INSERT INTO guj2017_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","તેઓએ રફીદીમથી નીકળીને સિનાઈના અરણ્યમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","તેઓએ સિનાઈના અરણ્યમાંથી નીકળીને કિબ્રોથ હાત્તાવાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","તેઓએ કિબ્રોથ હાત્તાવાહથી નીકળીને હસેરોથમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","તેઓએ હસેરોથથી નીકળીને રિથ્માહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","રિથ્માહથી નીકળીને તેઓએ રિમ્મોનપેરેસમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","રિમ્મોનપેરેસથી નીકળીને તેઓએ લિબ્નાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","લિબ્નાહથી નીકળીને તેઓએ રિસ્સાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","રિસ્સાહથી નીકળીને તેઓએ કહેલાથાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","કહેલાથાહથી નીકળીને તેઓએ શેફેર પર્વત આગળ છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","શેફેર પર્વતથી નીકળીને તેઓએ હરાદાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","હરાદાહથી નીકળીને તેમણે માકેહેલોથમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","માકેહેલોથથી નીકળી તેઓએ તાહાથમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","તાહાથથી નીકળીને તેઓએ તેરાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","તેરાહથી નીકળીને તેઓએ મિથ્કાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","મિથ્કાહમાંથી નીકળીને તેઓએ હાશ્મોનાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","હાશ્મોનાહથી નીકળીને તેઓએ મોસેરોથમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","મોસેરોથથી નીકળીને તેઓએ બનીયાઅકાનમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","બનીયાઅકાનથી નીકળીને તેઓએ હોર-હાગિદગાદમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","હોર-હાગિદગાદથી નીકળીને તેઓએ યોટબાથાહમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","યોટબાથાહથી નીકળીને તેઓએ આબ્રોનામાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","આબ્રોનાથી નીકળીને તેઓએ એસ્યોન-ગેબેરમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","એસ્યોન-ગેબેરથી નીકળીને તેઓએ કાદેશમાં એટલે કે સીનના અરણ્યમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","કાદેશથી નીકળીને તેઓએ અદોમની સરહદે આવેલા હોર પર્વત આગળ છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","યહોવાહની આજ્ઞા પ્રમાણે હારુન યાજક હોર પર્વત ઉપર ગયો અને ઇઝરાયલી લોકોના મિસર દેશમાંથી બહાર આવ્યા પછી ચાળીસમાં વર્ષે, એટલે પાંચમા મહિનાના પ્રથમ દિવસે તે ત્યાં મૃત્યુ પામ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","હારુન હોર પર્વત પર મરણ પામ્યો ત્યારે તે એકસો તેવીસ વર્ષનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","કનાની દેશના નેગેબમાં રહેતા અરાદના કનાની રાજાએ ઇઝરાયલી લોકોના આવવા વિષે સાંભળ્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","તેઓએ હોર પર્વતથી નીકળીને સાલ્મોનામાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","સાલ્મોનાથી નીકળીને તેઓએ પૂનોનમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","પૂનોનથી નીકળીને તેઓએ ઓબોથમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ઓબોથથી નીકળીને તેઓએ મોઆબીઓની સરહદમાં આવેલા ઈયે-અબારીમમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ઈયે-અબારીમથી નીકળીને તેઓએ દીબોનગાદમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","દીબોનગાદથી નીકળીને તેઓએ આલ્મોન દિબ્લાથાઈમમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","આલ્મોન દિબ્લાથાઈમમાંથી નીકળીને તેઓએ નબોની સામે આવેલા અબારીમના પર્વતો આગળ છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","અબારીમના પર્વતોથી નીકળીને તેઓએ યરીખોની સામે યર્દન નદીના કિનારે આવેલા મોઆબના મેદાનોમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","તેઓએ યર્દનને કિનારે, બેથ-યશીમોથથી આબેલ-શિટ્ટીમ સુધી મોઆબના મેદાનમાં છાવણી કરી. ");
INSERT INTO guj2017_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","મોઆબના મેદાનોમાં યર્દનને કિનારે યરીખોની પાસે યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“તું ઇઝરાયલી લોકોને કહે કે, ‘જયારે તમે યર્દન પાર કરીને કનાન દેશમાં જાઓ, ");
INSERT INTO guj2017_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ત્યારે તમારે દેશના બધા રહેવાસીને તમારી આગળથી કાઢી મૂકવા. તમારે તેઓની બધી કોતરેલી મૂર્તિઓનો નાશ કરવો. તેઓની બધી ગાળેલી મૂર્તિઓનો તથા તેમના ઉચ્ચસ્થાનોનો તમારે નાશ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","તમારે તે દેશનો કબજો લેવો અને તેમાં વસવાટ કરવો, કેમ કે, તે દેશ મેં તમને વતનને સારુ આપ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","તમારે ચિઠ્ઠી નાખીને તે દેશ તમારા કુળ પ્રમાણે વહેંચી લેવો. વધારે સંખ્યા ધરાવતા કુળને વધારે વિસ્તાર ધરાવતા દેશનો ભાગ અને ઓછી સંખ્યા ધરાવતા કુળને ઓછો વિસ્તાર ધરાવતા દેશનો ભાગ વહેંચી આપવો. દરેક કુળના નામની ચિઠ્ઠી જ્યાં પડે તે પ્રદેશ તેને મળે. તમારા પિતૃઓના કુળો પ્રમાણે દેશનો વારસો તમને મળે. ");
INSERT INTO guj2017_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","પણ જો તમે તે દેશના રહેવાસીઓને તમારી આગળથી હાંકી નહિ કાઢો, તો તેઓમાંના જેઓને તમે રહેવા દેશો તેઓ તમારી આંખમાં કણીરૂપ અને તમારા પડખામાં કાંટારૂપ થઈ પડશે. જે દેશમાં તમે વસો છો ત્યાં તેઓ તમારા જીવનો પર દુઃખ લાવશે. ");
INSERT INTO guj2017_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","અને એવું થશે કે મેં તે લોકોની જે દશા કરવાનું ધાર્યું હતું તે હું તમારી સાથે કરીશ.’” ");
INSERT INTO guj2017_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","ઇઝરાયલી લોકોને આજ્ઞા કરીને કહે, જ્યારે તમે કનાનના દેશમાં પ્રવેશ કરશો, ત્યારે કનાન દેશ અને તેની સરહદો તમારી થશે, ");
INSERT INTO guj2017_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","તમારો દક્ષિણ ભાગ સીનના અરણ્યથી અદોમની સરહદ સુધી વિસ્તરશે. તમારી દક્ષિણ સરહદ ખારા સમુદ્રના પૂર્વના છેડાથી શરૂ થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","તમારી સરહદ વળીને આક્રાબ્બીમના ઢોળાવ તરફ સીનના અરણ્ય સુધી જાય. ત્યાંથી તે દક્ષિણમાં કાદેશ બાર્નેઆ સુધી અને આગળ હસારઆદ્દાર સુધી અને આગળ આસ્મોન સુધી જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ત્યાંથી તે સરહદ આસ્મોનથી વળીને મિસરનાં ઝરણાં અને સમુદ્ર સુધી જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","મોટો સમુદ્ર તથા તેનો કિનારો તે તમારી પશ્ચિમ સરહદ હશે. ");
INSERT INTO guj2017_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","તમારી ઉત્તરની સરહદ ભૂમધ્ય સમુદ્રથી શરૂ થઈ હોર પર્વત સુધી તેની સીમારેખા દોરવી, ");
INSERT INTO guj2017_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ત્યાંથી હોર પર્વતથી લબો હમાથ સુધી અને આગળ સદાદ સુધી જશે. ");
INSERT INTO guj2017_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ત્યાંથી તે સરહદ ઝિફ્રોન સુધી અને તેનો છેડો હસાર-એનાન સુધી પહોંચે. આ તમારી ઉત્તરની સરહદ થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","તમારી પૂર્વની સરહદ હસાર-એનાનથી શરૂ થઈ શફામ સુધી આંકવી. ");
INSERT INTO guj2017_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","તે સરહદ શફામથી નીચે વળીને આયિનની પૂર્વે આવેલ રિબ્લાહ સુધી જશે. તે સરહદ ત્યાંથી કિન્નેરેથ સમુદ્ર સુધી પૂર્વ કિનારે પહોંચશે. ");
INSERT INTO guj2017_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ત્યાંથી તે સરહદ ઊતરીને યર્દન કિનારે જાય અને આગળ વધી ખારા સમુદ્ર સુધી આવે. આ દેશ તેની ચારે દિશાની સરહદો પ્રમાણે તમારો થશે.’” ");
INSERT INTO guj2017_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","મૂસાએ ઇઝરાયલી લોકોને આજ્ઞા કરીને કહ્યું “આ દેશ તમારે ચિઠ્ઠી નાખીને વહેંચી લેવો, યહોવાહે આ દેશ નવ કુળોને તથા અડધા કુળને આપવાની આજ્ઞા આપી છે. ");
INSERT INTO guj2017_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","રુબેનના વંશજોને તેઓના પિતૃઓના કુળ પ્રમાણે, ગાદના વંશજોના કુળને તથા મનાશ્શાના અર્ધકુળને તેઓનો વારસો વહેંચી આપવામાં આવ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","આ બે કુળોને તથા અડધા કુળને તેઓના દેશનો ભાગ યરીખોની આગળ યર્દન નદીની પૂર્વ તરફ એટલે સૂર્યની ઉગમણી દિશા તરફ મળ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“જે માણસો તારા વારસા માટે આ દેશને વહેંચશે તેઓનાં નામ આ છે: એલાઝાર યાજક તથા નૂનનો દીકરો યહોશુઆ. ");
INSERT INTO guj2017_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","તેઓના કુળ માટે દેશની વહેંચણી કરવા તારે દરેક કુળમાંથી એક આગેવાન પસંદ કરવો. ");
INSERT INTO guj2017_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","તે માણસોનાં નામ આ પ્રમાણે છે: યહૂદાના કુળમાંથી યફૂન્નેનો દીકરો કાલેબ. ");
INSERT INTO guj2017_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","શિમયોનના વંશજોના કુળમાંથી આમ્મીહૂદનો દીકરો શમુએલ. ");
INSERT INTO guj2017_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","બિન્યામીનના કુળમાંથી કિસ્લોનનો દીકરો અલીદાદ. ");
INSERT INTO guj2017_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","દાનના વંશજોના કુળનો આગેવાન, યોગ્લીનો દીકરો બુક્કી. ");
INSERT INTO guj2017_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","યૂસફના વંશજોમાંથી, મનાશ્શાના વંશજોના કુળનો આગેવાન, એફોદનો દીકરો હાન્નીએલ. ");
INSERT INTO guj2017_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","એફ્રાઇમના વંશજોના કુળનો આગેવાન, શિફટાનનો દીકરો કમુએલ. ");
INSERT INTO guj2017_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ઝબુલોનના વંશજોના કુળનો આગેવાન, પાનાખનો દીકરો અલીસાફાન. ");
INSERT INTO guj2017_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ઇસ્સાખારના વંશજોના કુળનો આગેવાન, અઝઝાનનો દીકરો પાલ્ટીએલ. ");
INSERT INTO guj2017_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","આશેરના વંશજોના કુળનો આગેવાન, શલોમીનો દીકરો અહિહુદ, ");
INSERT INTO guj2017_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","નફતાલીના વંશજોના કુળનો આગેવાન, આમ્મીહૂદનો દીકરો પદાહએલ.” ");
INSERT INTO guj2017_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","યહોવાહે આ માણસોને કનાન દેશના વારસાનો ભાગ ઇઝરાયલના દરેક કુળને વહેંચવાની આજ્ઞા આપી હતી. ");
INSERT INTO guj2017_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","મોઆબના મેદાનમાં યર્દનને કિનારે યરીખો પાસે યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“તું ઇઝરાયલ લોકોને આજ્ઞા કર કે, તેઓના દેશનો કેટલોક ભાગ લેવીઓને આપે. તેઓ તેમને કેટલાંક નગરો અને આસપાસની ગૌચર જમીન આપે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","આ નગરો લેવીઓને રહેવા માટે મળે. ગૌચરની જમીન તો તેમનાં અન્ય જાનવરો, ઉપરાંત ઘેટાંબકરાં માટે હશે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","તમે લેવીઓને જે નગરો આપો તેની ગૌચરની જમીન નગરના કોટની ચારે બાજુએ એક હજાર હાથ હોય. ");
INSERT INTO guj2017_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","તમારે નગરની બહાર બે હજાર હાથ પૂર્વ તરફ, બે હજાર હાથ દક્ષિણ તરફ, બે હજાર હાથ પશ્ચિમ તરફ અને બે હજાર હાથ ઉત્તર તરફ માપવું. તેઓનાં નગરોનાં ગૌચર આ પ્રમાણે હોય. તે નગર મધ્યમાં રહે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","જે છ નગરો તમે લેવીઓને આપો તે આશ્રયનગરો તરીકે હોય. જેણે હત્યા કરી હોય તે ત્યાં નાસી જઈ શકે માટે તારે તેઓને આપવાં. ઉપરાંત બીજાં બેતાળીસ નગરો પણ આપવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","આમ, કુલ અડતાળીસ નગરો અને તેની આસપાસની ગૌચરની જમીન લેવીઓને આપવી. ");
INSERT INTO guj2017_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ઇઝરાયલી લોકોનાં મોટા કુળો કે, જે કુળોની પાસે વધારે જમીન છે તે વધારે નગરો આપે. નાનાં કુળો થોડા નગરો આપે. દરેક કુળને જે ભાગ પ્રાપ્ત થયો છે તે પ્રમાણે લેવીઓને આપે.” ");
INSERT INTO guj2017_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","પછી યહોવાહે મૂસાને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“તું ઇઝરાયલી લોકોને કહે, ‘જયારે તમે યર્દન પાર કરીને કનાન દેશમાં પ્રવેશ કરો. ");
INSERT INTO guj2017_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ત્યારે તમારે અમુક નગરોને તમારા માટે આશ્રયના નગરો તરીકે પસંદ કરવાં, જેમાં જે માણસે કોઈને અજાણતાં મારી નાખ્યો હોય તે આશ્રય લઈ શકે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","આ નગરો તમારા માટે બદલો લેનારના હાથમાંથી રક્ષણાર્થે થાય, મનુષ્યઘાતકને ઇનસાફને સારુ જમાતની આગળ ખડો કરવામાં ન આવે ત્યાં સુધી તે દોષી ન ઠરે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","તેથી તમારે આશ્રયનાં નગરો તરીકે છ નગરો પસંદ કરવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ત્રણ નગરો યર્દન નદીની પાર આપવાં અને ત્રણ નગરો કનાન દેશમાં આપવાં. ");
INSERT INTO guj2017_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","આ છ નગરો ઇઝરાયલી લોકો માટે, પરદેશીઓ માટે તથા તમારી મધ્યે રહેતા લોકો માટે આશ્રયનગરો ગણાશે. જેણે અજાણતા કોઈને મારી નાખ્યો હોય તે ત્યાં નાસી જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","પણ જો તે કોઈને લોખંડના સાધનથી એવી રીતે મારે કે તે મરી જાય, તો તે ખૂની ગણાશે, તે ખૂનીને દેહાંતદંડની સજા આપવામાં આવે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","જેથી મોત નીપજવાનો સંભવ હોય, એવો પથ્થર લઈને તે તેને મારે કે, જેથી જો પેલાનું મોત નીપજે, તો તે ખૂની છે, તે ખૂનીને દેહાતદંડની સજા થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","જો દોષી માણસ તેના શિકારને મારી નાખવા માટે લાકડાંના હથિયારથી મારે, જો તે શિકાર મરી જાય, તો તે ખૂની ગણાય. તે ખૂનીને દેહાંતદંડની સજા થશે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","લોહીનો બદલો લેનાર, પોતે જ ખૂનીને મારી નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","તેથી જો તેણે તેને દ્વેષથી ધક્કો માર્યો હોય અથવા છુપાઇને તેના પર કંઈ ફેંક્યું હોય અને જો તે વ્યક્તિ મરી જાય, ");
INSERT INTO guj2017_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","અથવા દ્વેષથી તેને તેના હાથથી મારીને નીચે ફેંકી દે અને જો તે વ્યક્તિ મરી જાય, તો જેણે તેને માર્યો છે તેને દેહાંતદંડની સજા મળે. લોહીનો બદલો લેનાર માણસ જ્યારે તે ખૂનીને મળે ત્યારે તે તેને મારી નાખે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","પણ જો કોઈ માણસ દુશ્મનાવટ વગર તેની પર પ્રહાર કરે અથવા તેને રાહ જોયા વગર તેને મારી નાખવાના ઇરાદાથી તેના ઉપર કોઈ હથિયાર ફેંકે, ");
INSERT INTO guj2017_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","અથવા કોઈ માણસનું મોત થાય એવો પથ્થર તેને ન દેખતાં તેણે તેના પર ફેંક્યો હોય, તેથી તેનું મોત નીપજ્યું હોય, પણ તે તેનો દુશ્મન ન હોય, તેમ જ તેનું નુકશાન કરવાનો તેનો ઇરાદો ન હોય. પણ કદાચ તે મરી જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","તો જમાત મારનાર તથા લોહીનું વેર લેનાર બન્ને વચ્ચે કાનૂનો પ્રમાણે ન્યાય કરે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","જમાત મારનારને લોહીનો બદલો લેનારના હાથથી રક્ષણ કરે, જમાત તેને જે આશ્રયનગરમાં તે નાસી ગયો હોય ત્યાં પાછો લાવે. પવિત્ર તેલથી જે યાજકનો અભિષિક્ત થયો હોય તેનું મૃત્યુ થાય ત્યાં સુધી તે ત્યાં રહે. ");
INSERT INTO guj2017_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","પણ જે આશ્રયનગરમાં દોષી માણસ નાસી ગયો હોય, તેની સરહદની બહાર તે સમયે તે જાય, ");
INSERT INTO guj2017_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","લોહીનો બદલો લેનાર તેને આશ્રયનગરની સરહદ બહાર મળે, જો તે તેને મારી નાખે, તો લોહીનો બદલો લેનારને માથે ખૂનનો દોષ ગણાય નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","કેમ કે મુખ્ય યાજકનું મૃત્યુ થાય ત્યાં સુધી દોષી માણસે આશ્રયનગરમાં જ રહેવું. મુખ્ય યાજકના મૃત્યુ પછી તે વ્યક્તિ પોતાના વતનના દેશમાં પાછો જાય. ");
INSERT INTO guj2017_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","આ કાનૂનો તમારી વંશપરંપરા તમારાં સર્વ રહેઠાણોમાં તમારો ઇનસાફ કરવાનો કાયદો થાય. ");
INSERT INTO guj2017_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","જે કોઈ વ્યક્તિનું ખૂન કરે, ખૂની સાક્ષીઓને આધારે દેહાંતદંડ ભોગવે. ફક્ત એક જ સાક્ષીનો પુરાવો દેહાંતદંડ આપવા માટે પૂરતો ગણાય નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","જે મનુષ્યઘાતકને ખૂનનો દોષ લાગ્યો હોય, તે ખૂનીનો જીવ તમારે કંઈ પણ મૂલ્ય આપીને લેવો નહિ. તેને મૃત્યુની સજા થવી જ જોઈએ. ");
INSERT INTO guj2017_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","મુખ્ય યાજકનું મરણ થાય ત્યાં સુધી આશ્રયનગરમાં રક્ષણ લેનાર મનુષ્યઘાતક પાસેથી કોઈ પણ પ્રકારની રકમ લઈને તેને ઘરે પાછા ફરવા માટેની રજા આપી શકાય નહિ. ");
INSERT INTO guj2017_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","એ પ્રમાણે તમે જે દેશમાં રહો છો તેને ભ્રષ્ટ ન કરશો, કેમ કે રક્ત એ તો દેશને ભ્રષ્ટ કરે છે. કેમ કે દેશમાં વહેવડાવેલા લોહીનું પ્રાયશ્ચિત તે રક્ત વહેવડારના રક્ત સિવાય થઈ શકતું નથી. ");
INSERT INTO guj2017_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","તમે જે દેશમાં રહો છો તેને તમે અશુદ્ધ ન કરો, કેમ કે હું તેમાં રહું છું. હું યહોવાહ, ઇઝરાયલી લોકો મધ્યે રહું છું.’” ");
INSERT INTO guj2017_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","યૂસફના વંશજોના-કુટુંબોમાંના મનાશ્શાના દીકરા માખીરના દીકરા ગિલ્યાદના કુટુંબના પિતૃઓનાં ઘરના વડીલોએ પાસે આવીને મૂસાની આગળ; તથા ઇઝરાયલી લોકોના પિતૃઓના વડીલો એટલે અધિપતિઓની આગળ જઈને નમ્ર અરજ કરીને કહ્યું, ");
INSERT INTO guj2017_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","તેઓએ કહ્યું, “યહોવાહે મારા માલિકને આજ્ઞા કરી છે કે, ચિઠ્ઠી નાખીને ઇઝરાયલી લોકોને દેશનો ભાગ વહેંચી આપવો. યહોવાહ તરફથી તમને આજ્ઞા મળી છે કે અમારા ભાઈ સલોફહાદનો ભાગ તેની દીકરીઓને આપવો. ");
INSERT INTO guj2017_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","પરંતુ જો તેની દીકરીઓ ઇઝરાયલી લોકોમાંના કોઈ બીજા કુળના પુરુષો સાથે લગ્ન કરે, તો તેઓના દેશનો ભાગ અમારા પિતૃઓના ભાગમાંથી નાબૂદ કરવામાં આવશે. તો જે કુળની તેઓ થાય તેને તે ભાગ જોડી દેવામાં આવે. એમ કરવાથી અમારા વારસાના હિસ્સામાંથી તે નાબૂદ કરવામાં આવશે. ");
INSERT INTO guj2017_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","જ્યારે ઇઝરાયલીઓનું જ્યુબિલી પર્વ આવશે, ત્યારે તેઓનો ભાગ તેઓ જે કુળની થઈ હશે તે કુળને તેના ભાગ સાથે જોડી દેવામાં આવશે. આ પ્રમાણે, તેઓનો ભાગ અમારા પિતૃઓના ભાગમાંથી લઈ લેવામાં આવશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","મૂસાએ ઇઝરાયલી લોકોને યહોવાહના વચન પ્રમાણે આજ્ઞા આપી. તેણે કહ્યું, “યૂસફના વંશજોના કુળનું કહેવું વાજબી છે. ");
INSERT INTO guj2017_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","સલોફહાદની દીકરીઓ વિષે યહોવાહ એવી આજ્ઞા કરે છે કે, ‘તેઓ જેને ઉત્તમ સમજે તેની સાથે લગ્ન કરવા દે, પણ ફક્ત તેઓ પોતાના જ પિતૃઓના કુળમાં લગ્ન કરે.’” ");
INSERT INTO guj2017_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ઇઝરાયલી લોકોનો ભાગ એક કુળમાંથી બીજા કુળમાં બદલી શકાશે નહિ. દરેક ઇઝરાયલી લોકો પોતાના પિતૃઓના કુળના ભાગને વળગી રહશે. ");
INSERT INTO guj2017_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ઇઝરાયલી લોકોની મધ્યે વારસો પામેલી દરેક સ્ત્રી પોતાના પિતૃઓના કુટુંબમાંના કોઈની સાથે લગ્ન કરે. એટલા માટે કે ઇઝરાયલી લોકોમાંના દરેકને પોતાના પિતૃઓનો વારસો મળે. ");
INSERT INTO guj2017_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","જેથી વારસાનો કોઈ પણ ભાગ એક કુળમાંથી બીજા કુળમાં જશે નહિ. ઇઝરાયલી લોકોના કુળમાંનો દરેક માણસ પોતાના વારસાને વળગી રહશે.” ");
INSERT INTO guj2017_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","યહોવાહે મૂસાને આજ્ઞા આપી હતી તે પ્રમાણે સલોફહાદની દીકરીઓએ કર્યું. ");
INSERT INTO guj2017_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","માહલાહ, તિર્સા, હોગ્લાહ, મિલ્કાહ તથા નૂહે એટલે સલોફહાદની દીકરીઓએ, મનાશ્શાના દીકરાઓ સાથે લગ્ન કર્યાં. ");
INSERT INTO guj2017_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","તેઓએ યૂસફના દીકરા મનાશ્શાના કુટુંબમાં લગ્ન કર્યાં, તેઓનો વારસો તેઓના પિતૃઓના કુટુંબના કુળમાં કાયમ જળવાઈ રહ્યો. ");
INSERT INTO guj2017_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","જે આજ્ઞાઓ તથા કાનૂનો યર્દન નદીને કિનારે મોઆબના મેદાનોમાં યરીખો સામે યહોવાહે મૂસાને ઇઝરાયલી લોકો માટે આપ્યા તે એ છે.");
INSERT INTO guj2017_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","યર્દન પાર અરણ્યમાં, સૂફ સમુદ્રની સામેના અરાબાની ખીણ પ્રદેશમાં, પારાન, તોફેલ, લાબાન, હસેરોથ તથા દી-ઝાહાબ તેઓની નગરો આવેલાં હતા ત્યાં જે વચનો મૂસાએ ઇઝરાયલપુત્રોને કહી સંભળાવ્યાં તે નીચે મુજબ છે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","સેઈર પર્વતને માર્ગે હોરેબથી કાદેશ બાર્નેઆ સુધીનું અંતર અગિયાર દિવસની મજલ જેટલું છે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","મિસર દેશ છોડ્યાના ચાળીસમા વર્ષના અગિયારમા મહિનાને પ્રથમ દિવસે એમ થયું કે, જે સર્વ આજ્ઞાઓ યહોવાહે મૂસાને આપી હતી, તે તેણે ઇઝરાયલી લોકોને કહી સંભળાવી. ");
INSERT INTO guj2017_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","એટલે અમોરીઓનો રાજા સીહોન જે હેશ્બોનમાં રહેતો હતો અને બાશાનનો રાજા ઓગ જે આશ્તારોથમાં એડ્રેઇ પાસે રહેતો હતો, તેઓનો ઈશ્વરે નાશ કર્યો ત્યાર પછી. ");
INSERT INTO guj2017_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","યર્દન પાર મોઆબ દેશમાં મૂસાએ આ નિયમ પ્રગટ કરવાની શરૂઆત કરીને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","આપણા ઈશ્વર યહોવાહે હોરેબ પર આપણને કહ્યું હતું કે, તમને આ પર્વત પર ઘણો જ વખત વીતી ગયો છે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","તો હવે તમે પાછા ફરો, અને કૂચ કરીને અમોરીઓના પહાડી પ્રદેશમાં તથા તેની નજીકની સર્વ જગ્યાઓમાં એટલે અરાબા, પહાડીપ્રદેશમાં, નીચલાપ્રદેશમાં, નેગેબમાં તથા સમુદ્રકાંઠે, કનાનીઓના દેશમાં તથા લબાનોનમાં એટલે મોટી નદી ફ્રાત નદી સુધી જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","જુઓ, તમારી આગળ આ જે દેશ હું દર્શાવું છું; તેમાં પ્રવેશ કરો. એ દેશ વિષે યહોવાહે તમારા પૂર્વજો એટલે ઇબ્રાહિમ, ઇસહાક અને યાકૂબ આગળ પ્રતિજ્ઞા લીધી હતી કે હું તમને તથા તમારા વંશજોને તે દેશ આપીશ તેનું વતન પ્રાપ્ત કરો.’” ");
INSERT INTO guj2017_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“તે સમયે મેં તમને એવું કહ્યું હતું કે, હું પોતે એકલો તમારો બધાનો બોજો ઉપાડવાને શક્તિમાન નથી. ");
INSERT INTO guj2017_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","તમારા યહોવાહે તમારો વિસ્તાર વધાર્યો છે, અને જુઓ, આજે તમારી સંખ્યા આકાશના તારાઓ જેટલી છે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","તમારા પૂર્વજોના ઈશ્વર યહોવાહે તમને આપેલા વચન પ્રમાણે તમે છો તેના કરતાં તમને હજારગણા વધારો અને આશીર્વાદ આપો. ");
INSERT INTO guj2017_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","પણ હું એકલો જાતે તમારી જવાબદારી, તમારી સમસ્યા તથા તમારા ઝઘડાનું નિરાકરણ શી રીતે કરી શકું? ");
INSERT INTO guj2017_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","માટે તમે પોતપોતાના કુળોમાંથી જ્ઞાની, બુદ્ધિમાન અને અનુભવી માણસોને પસંદ કરો. હું તેઓને તમારા અધિકારીઓ ઠરાવીશ.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","પછી તમે મને ઉત્તર આપ્યો હતો અને કહ્યું હતું કે, જે વાત તેં કહી છે તે પ્રમાણે કરવું તે સારું છે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","“તેથી તમારાં કુળોમાંના આગેવાનો જેઓ બુદ્ધિમાન અને અનુભવી પુરુષો હતા તેઓને લઈને મેં તમારા અધિકારીઓ ઠરાવ્યા. એટલે તમારાં કુળો પ્રમાણે હજાર-હજારના આગેવાનો તથા સો-સોના આગેવાનો, પચાસ-પચાસના આગેવાનો દસ-દસના આગેવાનો તથા અમલદારો ઠરાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","અને તે સમયે મેં તમારા ન્યાયીધીશોને એવી આજ્ઞા કરી હતી કે, તમારા ભાઈઓ વચ્ચેની તકરાર તમારે સાંભળવી. અને ભાઈ ભાઈની વચ્ચે તથા ભાઈ અને તેની સાથેના પરદેશી વચ્ચે તમારે નિષ્પક્ષ ન્યાય કરવો. ");
INSERT INTO guj2017_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ન્યાય કરતી વખતે તમારે આંખની શરમ રાખવી નહિ; નાના તથા મોટા સૌનું સરખી રીતે સાંભળવું. માણસનું મોં જોઈને તમારે બીવું નહિ, કેમ કે ન્યાય કરવો એ ઈશ્વરનું કામ છે. જો કોઈ મુકદમો તમને અઘરો લાગે તો તે તમારે મારી પાસે લાવવો એટલે તે હું સંભાળીશ. ");
INSERT INTO guj2017_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","અને તમારે શું કરવું તે સર્વ વિષે મેં તમને તે સમયે આજ્ઞા આપી હતી. ");
INSERT INTO guj2017_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","અને આપણે હોરેબ પર્વત છોડીને જે વિશાળ અને ભયંકર અરણ્ય તમે જોયું તે અરણ્ય, ઈશ્વર આપણા યહોવાહે આપેલી આજ્ઞા પ્રમાણે અમોરીઓના પર્વતીય પ્રદેશને રસ્તે ચાલતાં આપણે ઓળગ્યું. અને આપણે કાદેશ બાર્નેઆ આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ત્યારે મેં તમને કહ્યું કે, “અમોરીઓનો જે પહાડી પ્રદેશ ઈશ્વર આપણા યહોવાહે આપણને આપવાનું વચન આપ્યું હતું, તેમાં તમે આવી પહોંચ્યા છો. ");
INSERT INTO guj2017_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","જુઓ, ઈશ્વર તમારા યહોવાહે તે દેશ તમારી આગળ મૂક્યો છે; ઈશ્વર તમારા પિતૃઓના યહોવાહે તમને કહ્યું તે પ્રમાણે આગળ વધીને તેનો કબજો લો. બીશો નહિ અને ગભરાશો નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","અને તમે સર્વએ મારી પાસે આવીને કહ્યું કે, “આપણે માણસો મોકલીએ, એ માટે કે તેઓ આપણે વાસ્તે દેશની બાતમી કાઢે અને આપણે કયે રસ્તે આગળ જવું અને કયાં નગરો આપણા રસ્તામાં આવશે તે વિષે તેઓ પાછા આવીને આપણને ખબર આપે.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","અને એ સૂચના મને સારી લાગી; તેથી મેં દરેક કુળમાંથી એકેક માણસ એટલે તમારામાંથી બાર માણસો પસંદ કર્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","અને તેઓ પાછા ફરીને પર્વત પર ચઢ્યા અને એશ્કોલની ખીણમાં જઈને તેની જાસૂસી કરી. ");
INSERT INTO guj2017_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","અને તેઓ તે દેશનાં ફળ પોતાની સાથે લઈને આપણી પાસે આવ્યા. અને તેઓ એવી ખબર લાવ્યા કે, જે ભૂમિ આપણા ઈશ્વર યહોવાહ આપણને આપવાના છે તે ભૂમિ સારી છે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“પણ તમે ત્યાં જવા નહિ ચાહતા ઈશ્વર તમારા યહોવાહની આજ્ઞાનો અનાદર કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","અને તમે લોકોએ તમારા તંબુમાં બબડાટ કરીને કહ્યું કે, ‘યહોવાહ આપણને ધિક્કારે છે, તેથી જ તેમણે આપણને મિસરમાંથી બહાર લાવીને અમોરીઓના હાથમાં સોંપી દીધા છે જેથી તેઓ આપણા સૌનો નાશ કરે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","હવે આગળ અમે કયાં જઈએ? “તે લોકો આપણા કરતાં કદમાં મોટા અને શક્તિશાળી છે; તેઓનાં નગરો મોટાં અને તેના કોટ ગગન જેટલા ઊંચા છે; અને વળી ત્યાં અનાકપુત્રો પણ અમારા જોવામાં આવ્યા છે. એવું કહીને અમારા ભાઈઓએ અમને ભયભીત કરી નાખ્યા છે.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ત્યારે મેં તમને કહ્યું કે, “ડરો નહિ અને તેઓથી બી ન જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","તમારા ઈશ્વર યહોવાહ તમારી આગળ જશે અને તમે મિસરમાં હતા ત્યારે તમારા માટે જે પરાક્રમી કૃત્યો કર્યા હતા તેમ તે તમારા માટે લડશે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","અરણ્યમાં પણ તમે જોયું તેમ જ આ જગ્યાએ આવ્યા ત્યાં સુધી જે માર્ગે તમે ગયા ત્યાં જેમ પિતા પોતાના દીકરાને ઊંચકી લે તેમ ઈશ્વર તમારા યહોવાહે તમને ઊંચકી લીધા છે.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","આ બધી બાબતોમાં પણ તમે તમારા ઈશ્વર ફક્ત યહોવાહ પર વિશ્વાસ કર્યો નહિ, ");
INSERT INTO guj2017_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","રસ્તે તમારા માટે તંબુ બાંધવાની જગ્યા શોધવા, કયા માર્ગે તમારે જવું તે બતાવવાને યહોવાહ રાત્રે અગ્નિરૂપે અને દિવસે મેઘરૂપે તમારી આગળ ચાલતા હતા. ");
INSERT INTO guj2017_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","યહોવાહ તમારો અવાજ સાંભળીને કોપાયમાન થયા; તેમણે સમ ખાઈને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“જે સારો દેશ તમારા પૂર્વજોને આપવાને મેં સમ ખાધા હતા, તે આ ખરાબ પેઢીના માણસોમાંથી એક પણ જોશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ફક્ત યફૂન્નેનો દીકરો કાલેબ તે દેશ જોશે. જે ભૂમિમાં તે ફર્યો છે તે હું તેને તથા તેના સંતાનોને આપીશ, કેમ કે તે સંપૂર્ણપણે યહોવાહને અનુસર્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","વળી તમારા લીધે યહોવાહે મારા પર પણ ગુસ્સે થઈને કહ્યું કે, “તું પણ તેમાં પ્રવેશ કરશે નહિ; ");
INSERT INTO guj2017_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","નૂનનો દીકરો યહોશુઆ જે તારી આગળ તારા ચાકર તરીકે ઊભો છે તે તેમાં પ્રવેશ કરશે; તું તેને હિંમત આપ, કેમ કે તે ઇઝરાયલને તેનો વારસો અપાવશે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","વળી તમારાં બાળકો જેના વિષે તમે કહ્યું કે, તેઓ ભક્ષ થઈ જશે, જેઓને આજે સારા અને ખરાબની સમજ નથી તેઓ તેમાં પ્રવેશ કરશે. તેઓને હું તે આપીશ અને તેઓ તેનું વતન પામશે. ");
INSERT INTO guj2017_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","પણ તમે પાછા ફરો અને અરણ્યમાં લાલ સમુદ્રના માર્ગે થઈને ચાલો.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ત્યારે તમે મને જવાબ આપ્યો કે, “અમે યહોવાહની વિરુદ્ધ પાપ કર્યું છે, અમે ઉપર ચઢીને આપણા ઈશ્વર યહોવાહે આપણને આપેલી બધી આજ્ઞા પ્રમાણે યુદ્ધ કરીશું.” તમારામાંનો દરેક માણસ પોતપોતાનાં યુદ્ધશસ્ત્ર ધારણ કરીને પર્વતીય પ્રદેશ ઉપર હુમલો કરવા જવાને તૈયાર થઈ ગયો હતો. ");
INSERT INTO guj2017_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","યહોવાહે મને કહ્યું, “તેઓને કહે કે, ‘હુમલો કરશો નહિ, તેમ યુદ્ધ પણ કરશો નહિ, રખેને તમે તમારા શત્રુઓથી પરાજિત થાઓ, કેમ કે હું તમારી સાથે નથી.” ");
INSERT INTO guj2017_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","એમ મેં તમને કહ્યું, પણ તમે સાંભળ્યું નહિ. તમે યહોવાહની આજ્ઞાની વિરુદ્ધ બળવો કર્યો; તમે આવેશમાં આવીને પર્વતીય પ્રદેશ ઉપર હુમલો કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","પહાડી પ્રદેશમાં રહેતા અમોરીઓ તમારી વિરુદ્ધ બહાર નીકળી આવ્યા અને મધમાખીઓની જેમ તમારી પાછળ લાગ્યા, સેઈરમાં છેક હોર્મા સુધી તમને મારીને હાર આપી. ");
INSERT INTO guj2017_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","તમે પાછા ફરીને યહોવાહની આગળ રડ્યા; પણ યહોવાહે તમારો અવાજ સાંભળ્યો નહિ, તમારી દરકાર કરી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","આથી ઘણાં દિવસો તમે કાદેશમાં રહ્યા, એટલે કે બધા દિવસો તમે ત્યાં રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","પછી યહોવાહે મૂસા સાથે આ પ્રમાણે વાત કર્યું. યહોવાહે મને કહ્યું હતું તે મુજબ અમે પાછા ફરીને લાલ સમુદ્રને માર્ગે અરણ્યમાં ચાલ્યા. ઘણાં દિવસો સુધી અમે સેઈર પર્વતની આસપાસ ફરતા રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","પછી યહોવાહે મને કહ્યું, કે, ");
INSERT INTO guj2017_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“આ પર્વતની આસપાસ તમે લાંબો સમય ફર્યા છો, હવે ઉત્તર તરફ પાછા વળો. ");
INSERT INTO guj2017_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","લોકોને આજ્ઞા કરીને કહે, તમે સેઈરમાં રહેનારા તમારા ભાઈઓ, એટલે કે એસાવના વંશજોની હદમાં થઈને પસાર થવાના છો. તેઓ તમારાથી ડરી જશે. માટે તમે કાળજી રાખજો. ");
INSERT INTO guj2017_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","તેઓની સાથે યુદ્ધ કરશો નહિ, કેમ કે તેઓના દેશમાંથી હું તમને કંઈપણ આપીશ નહિ, પગ મૂકવા જેટલું પણ આપીશ નહિ. કેમ કે મેં સેઈર પર્વત એસાવને વતન તરીકે આપ્યો છે. ");
INSERT INTO guj2017_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","નાણાં આપીને તેઓની પાસેથી ખોરાક ખરીદો, જેથી તમે ખાઈ શકો; પાણી પણ નાણાં આપીને ખરીદો, જેથી તમે પી શકો. ");
INSERT INTO guj2017_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","કેમ કે ઈશ્વર તમારા યહોવાહે તમારા હાથનાં બધાં જ કાર્યોમાં તમને આશીર્વાદ આપ્યો છે, આ મોટા અરણ્યમાં તમારું ચાલવું તેમણે જાણ્યું છે. કેમ કે આ ચાળીસ વર્ષ ઈશ્વર તમારા યહોવાહ તમારી સાથે રહ્યા, તમને કશાની ખોટ પડી નથી.’” ");
INSERT INTO guj2017_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","જેથી અમે આપણા સેઈરવાસી ભાઈઓ એટલે કે એસાવના વંશજોના દેશમાંથી પસાર થયા, અરાબાના માર્ગે થઈને એલાથ તથા એસ્યોન-ગેબેરથી ગયા. અને અમે પાછા વળીને મોઆબના અરણ્યના માર્ગે ચાલ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","યહોવાહે મને કહ્યું કે, “મોઆબને સતાવશો નહિ, તેમની સાથે યુદ્ધમાં લડશો નહિ. કેમ કે, તેઓના દેશમાંથી હું તમને વતન આપીશ નહિ, કેમ કે, આર તો મેં લોતના વંશજોને વતન તરીકે આપ્યું છે.” ");
INSERT INTO guj2017_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","અગાઉ એમીઓ ત્યાં રહેતા હતા. તેઓની વસ્તી ઘણી હતી અને તેઓ અનાકીઓ જેવા ઊંચા તથા કદાવર હતા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","અનાકીઓની જેમ તેઓ પણ રફાઇમીઓ ગણાય છે; પણ મોઆબીઓ તેઓને એમીઓ કહે છે. ");
INSERT INTO guj2017_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","અગાઉ હોરીઓ પણ સેઈરમાં રહેતા હતા, પણ એસાવપુત્રો તેઓની જગ્યાએ આવ્યા. તેઓ પોતાની આગળથી તેઓનો નાશ કરીને તેઓની જગ્યાએ વસ્યા. જેમ ઇઝરાયલે જે દેશ યહોવાહે તેઓને વતનને માટે આપ્યો તેને કર્યું હતું તેમ જ. ");
INSERT INTO guj2017_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“હવે ઊઠો અને ઝેરેદનું નાળું ઊતરો.” તેથી આપણે ઝેરેદનું નાળું ઊતર્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","આપણે કાદેશ બાર્નેઆથી નીકળીને ઝેરેદનું નાળું ઊતર્યા ત્યાં સુધીમાં આડત્રીસ વર્ષ પસાર થયા. તે સમયે લડવૈયા માણસોની આખી પેઢી, યહોવાહે તેઓને પ્રતિજ્ઞાપૂર્વક કહ્યું હતું તે પ્રમાણે નાશ પામી હતી. ");
INSERT INTO guj2017_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","વળી તેઓ બધા નાશ પામે ત્યાં સુધી છાવણી મધ્યેથી તેઓનો નાશ કરવા સારુ યહોવાહનો હાથ તેઓની વિરુદ્ધ હતો. ");
INSERT INTO guj2017_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","હવે લોકોમાંથી સર્વ લડવૈયાઓ નાશ પામ્યા તથા મરી ગયા ત્યાર પછી, ");
INSERT INTO guj2017_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","યહોવાહે મને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","તું આજે આર એટલે કે મોઆબની સરહદ પાર કરવાનો છે; ");
INSERT INTO guj2017_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","અને જયારે તું આમ્મોનપુત્રોની નજીક આવે ત્યારે તેઓને સતાવીશ નહિ કે તેઓની સાથે લડીશ પણ નહિ; કારણ કે, હું તમને આમ્મોનપુત્રોના દેશમાંથી વતન આપવાનો નથી. કેમ કે મેં તે પ્રદેશ વતન તરીકે લોતપુત્રોને આપ્યો છે.” ");
INSERT INTO guj2017_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","તે પણ રફાઈઓનો દેશ ગણાય છે; અગાઉ રફાઈઓ તેમાં રહેતા હતા. જો કે આમ્મોનીઓ તેઓને ઝામઝુમીઓ એવું નામ આપે છે. ");
INSERT INTO guj2017_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","તે લોક પણ અનાકીઓની જેમ બળવાન તથા કદાવર હતા. તેઓની સંખ્યા ઘણી હતી; પરંતુ યહોવાહે આમ્મોનીઓ આગળથી તેઓનો નાશ કર્યો અને તેઓ તેઓના વતનમાં દાખલ થઈને તેઓની જગ્યાએ વસ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","જેમ હોરીઓનો નાશ કરીને યહોવાહે સેઈરવાસી એસાવપુત્રો માટે કર્યું હતું તેમ જ; અને તેઓએ તેઓનું વતન લઈ લીધું. અને તેઓની જગ્યાએ તેઓ આજ સુધી વસ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","અને આવ્વીઓ જેઓ ગાઝા સુધીના ગામોમાં રહેતા હતા, તેઓનો કાફતોરીઓએ કાફતોરીમમાંથી ધસી આવીને નાશ કર્યો અને તેઓની જગ્યાએ રહ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“હવે તમે ઊઠો, આગળ ચાલો અને આર્નોનની ખીણ ઓળંગો; જુઓ, મેં હેશ્બોનના રાજા અમોરી સીહોનને તેમ જ તેના દેશને તમારા હાથમાં સોંપી દીધો છે. તેનું વતન જીતવાનું શરૂ કરો અને તેની સાથે યુદ્ધ કરો. ");
INSERT INTO guj2017_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","હું આજથી આકાશ નીચેની સર્વ પ્રજાઓ પર તમારો ડર તથા ધાક એવો બેસાડીશ કે તેઓ તમારી ખ્યાતી સાંભળી ધ્રૂજશે અને તીવ્ર વેદનાથી દુઃખી થશે.” ");
INSERT INTO guj2017_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","અને કદેમોથના અરણ્યમાંથી મેં હેશ્બોનના રાજા સીહોન પાસે સંદેશવાહકો મોકલ્યા કે, તેઓ શાંતિનો સંદેશો લઈને કહે કે, ");
INSERT INTO guj2017_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“અમને તારા દેશમાં થઈને જવા દે; અમે રસ્તે જ ચાલીશું; ડાબે કે જમણે હાથે વળીશું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ખાવાને માટે અન્ન અમને પૈસા લઈને વેચાતું આપજે જેથી અમે ખાઈએ; પીવાને પાણી પણ તું મને પૈસા લઈને આપજે જેથી હું પીવું; ફક્ત તારા દેશમાંથી થઈને અમને પગે ચાલીને જવા દે; ");
INSERT INTO guj2017_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","જ્યાં સુધી અમે યર્દન નદી ઓળંગીને અમારા ઈશ્વર યહોવાહ અમને જે દેશ આપવાના છે ત્યાં પહોંચીએ ત્યાં સુધી જેમ સેઈરમાં વસતા એસાવપુત્રો તથા આરમાં વસતા મોઆબીઓ મારી સાથે વર્ત્યા તેમ તું અમારી સાથે વર્તજે.” ");
INSERT INTO guj2017_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","પરંતુ હેશ્બોનના રાજા સીહોને આપણને પોતાના દેશમાં થઈને જવા દેવાની ના પાડી; કેમ કે ઈશ્વર તમારા યહોવાહ તેનું મન કઠણ અને હૃદય હઠીલું કર્યું હતું કે તે તેને તારા હાથમાં સોંપે, જેમ આજે છે તેમ. ");
INSERT INTO guj2017_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","અને યહોવાહે મને કહ્યું, ‘જો મેં સીહોનને તથા તેના દેશને તને સ્વાધીન કરવાનો આરંભ કર્યો છે. વતન પ્રાપ્ત કરવાનું શરૂ કર કે જેથી તું તે દેશનો વારસો પામે.” ");
INSERT INTO guj2017_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“ત્યારે સીહોન તથા તેના સર્વ લોક યાહાસ આગળ આપણી સામે લડાઈ કરવાને બહાર નીકળી આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","પરંતુ આપણા ઈશ્વર યહોવાહે તેને આપણને સ્વાધીન કરી દીધો. અને આપણે તેને તથા તેના પુત્રોને તથા તેના સર્વ લોકોને હરાવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","આપણે તેનાં સર્વ નગરો જીતી લીધા. અને વસ્તીવાળાં સર્વ નગરોનો, તેઓની સ્ત્રીઓ તથા બાળકો શુદ્ધા તેઓનો પૂરો નાશ કર્યો. કોઈને પણ જીવતા રહેવા દીધા નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ફક્ત જે નગરો આપણે જીતી લીધાં હતાં તેમની લૂંટ સાથે આપણે પોતાને સારુ જાનવરો લીધા. ");
INSERT INTO guj2017_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","આર્નોનની ખીણની સરહદ પર આવેલા અરોએર તથા ખીણની અંદરના નગરથી માંડીને ગિલ્યાદ સુધી એક પણ નગર એવું મજબૂત નહોતું કે આપણાથી જિતાય નહિ. ઈશ્વર આપણા યહોવાહે આપણા સર્વ શત્રુઓ પર વિજય આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ફક્ત આમ્મોનપુત્રોના દેશની નજીક તથા યાબ્બોક નદીના કાંઠા પરનો આખો પ્રદેશ, પર્વતીય પ્રદેશના નગરો તથા જે જગ્યા વિષે આપણા ઈશ્વર યહોવાહે આપણને મના કરી હતી ત્યાં આપણે ગયા જ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ત્યારબાદ આપણે પાછા વળીને બાશાનના માર્ગે આગળ વધ્યા. બાશાનનો રાજા ઓગ પોતે તથા તેના સર્વ લોક એડ્રેઇ આગળ આપણી સામે યુદ્ધ કરવા માટે નીકળી આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","યહોવાહે મને કહ્યું, “તેનાથી તું બીશ નહિ; કારણ કે, મેં તેને તેના સર્વ લોકને અને તેના દેશને તારા હાથમાં સોંપ્યા છે. અને અમોરીનો રાજા સીહોન જે હેશ્બોનમાં રહેતો હતો તેને તેં જેવું કર્યું તેવુ જ તેને પણ કર.” ");
INSERT INTO guj2017_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","તેથી ઈશ્વર આપણા યહોવાહે બાશાનના રાજા ઓગ અને તેના સર્વ લોકને આપણા હાથમાં સોંપી દીધા. આપણે તેઓને પરાજિત કર્યા. તેઓમાંનું કોઈ પણ જીવતું રહ્યું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","તે સમયે આપણે તેઓનાં સર્વ નગરો જીતી લીધા. એટલે તેઓની પાસેથી જીતી લીધું ના હોય એવું એક પણ નગર ન હતું. સાઠ નગરો તથા આર્ગોબનો આખો પ્રદેશ એટલે કે બાશાનમાં ઓગનું રાજ્ય આપણે જીતી લીધું. ");
INSERT INTO guj2017_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","આ બધાં નગરોના રક્ષણ માટે ઊંચા કોટ, દરવાજા તથા ભૂંગળો હતાં. તે ઉપરાંત, કોટ વગરનાં બીજા અનેક ગામો હતાં. ");
INSERT INTO guj2017_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","અને આપણે હેશ્બોનના રાજા સીહોનને કર્યુ હતું તેમ તેઓનો પૂરો નાશ કર્યો. વસ્તીવાળાં સર્વ નગરો, તેઓની સ્ત્રીઓ અને બાળકોનો સંપૂર્ણ નાશ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","પરંતુ સર્વ જાનવરો તથા નગરોની લૂંટ આપણે પોતાને માટે લીધી. ");
INSERT INTO guj2017_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","તે સમયે આપણે યર્દન પાર અમોરીઓના બન્ને રાજાઓના હાથમાંથી આર્નોનની ખીણથી હેર્મોન પર્વત સુધીનો દેશ કબજે કરી લીધો. ");
INSERT INTO guj2017_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","સિદોનીઓ હેર્મોન પર્વતને સીર્યોન કહે છે અને અમોરીઓ તેને સનીર કહે છે; ");
INSERT INTO guj2017_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","સપાટ પ્રદેશનાં બધાં નગરો, આખું ગિલ્યાદ, આખું બાશાન તથા બાશાનમાં ઓગના રાજ્યનાં સાલખા અને એડ્રેઇ નગરો આપણે જીતી લીધાં. ");
INSERT INTO guj2017_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","કેમ કે રફાઈઓમાંનાં બચેલામાંથી બાશાનનો રાજા ઓગ એકલો જ બાકી રહ્યો હતો; જુઓ, તેનો પલંગ લોખંડનો હતો. શું તે રાબ્બામાં નથી કે જ્યાં આમ્મોનપુત્રો રહે છે? માણસનાં હાથના માપ પ્રમાણે તેની લંબાઈ નવ હાથ અને પહોળાઈ ચાર હાથ હતી. ");
INSERT INTO guj2017_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","અને તે સમયે જે દેશને અમે કબજે કર્યો હતો, તે આર્નોનની ખીણના અરોએરથી ગિલ્યાદના પર્વતીય પ્રદેશનો અડધો ભાગ તથા તેનાં નગરો મેં રુબેનીઓને અને ગાદીઓને આપ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ગિલ્યાદનો બાકીનો ભાગ તથા ઓગનું રાજ્ય એટલે આખું બાશાન મેં મનાશ્શાના અર્ધકુળને આપ્યું. આર્ગોબનો આખો પ્રદેશ, આખું બાશાન આપ્યું. તે રફાઈઓનો દેશ કહેવાય છે. ");
INSERT INTO guj2017_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","મનાશ્શાના વંશજ યાઈરે ગશૂરીઓ અને માખાથીઓની સરહદ સુધીનો આખો આર્ગોબનો પ્રદેશ જીતી લીધો. તેણે પોતાના નામ ઉપરથી બાશાનને, હાવ્વોથ યાઈર એ નામ આપ્યું, તે આજ સુધી ચાલે છે. ");
INSERT INTO guj2017_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","મેં માખીરને ગિલ્યાદ આપ્યું. ");
INSERT INTO guj2017_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","રુબેનીઓને અને ગાદીઓને મેં ગિલ્યાદથી માંડીને આર્નોનની ખીણ સુધીનો પ્રદેશ જે પ્રદેશની સરહદ તે ખીણની વચ્ચે આવેલી હતી તે, યાબ્બોક નદી જે આમ્મોનપુત્રોની સરહદ છે ત્યાં સુધીનો પ્રદેશ આપ્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","અરાબામાં પશ્ચિમે યર્દન નદી તથા તેની સીમા પણ, કિન્નેરેથથી અરાબાના સમુદ્ર એટલે કે ખારા સમુદ્રની પૂર્વમાં પિસ્ગાહ પર્વતના ઢોળાવ તળે આવેલી છે, ત્યાં સુધીનો પ્રદેશ. ");
INSERT INTO guj2017_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","તે સમયે મેં તમને આજ્ઞા આપીને કહ્યું હતું કે, “ઈશ્વર તમારા યહોવાહે આ દેશ તમને વતન કરી લેવા માટે આપ્યો છે. તમે તથા બધા યોદ્ધાઓ હથિયાર સજીને તમારા ભાઈઓની એટલે ઇઝરાયલના લોકોની આગળ પેલી બાજુ જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","પણ તમારી પત્નીઓ, તમારાં બાળકો તથા તમારાં જાનવર હું જાણું છું કે તમારી પાસે ઘણાં જાનવર છે, જે નગરો મેં તમને આપ્યાં છે તેમાં તેઓ રહે, ");
INSERT INTO guj2017_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","જ્યાં સુધી કે જેમ તમને તેમ તમારા ભાઈઓને યહોવાહે જે દેશ ઈશ્વર તમારા યહોવાહ તેઓને યર્દનને પેલી બાજુ આપવાના છે તેનું વતન તેઓ પણ પામે ત્યાં સુધી આરામ આપ્યો. ત્યાર પછી તમે બધા પોતપોતાનાં વતન તમને આપ્યાં છે તેમાં પાછા આવો.” ");
INSERT INTO guj2017_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","મેં યહોશુઆને આજ્ઞા આપીને કહ્યું કે, “યહોવાહે આ બે રાજાઓને જે બધું કર્યું, તે તારી આંખોએ તેં જોયું છે, તે જ પ્રમાણે જે સર્વ રાજ્યોમાં તું જશે તેઓને યહોવાહ એવું કરશે. ");
INSERT INTO guj2017_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","તમે તેઓથી બીશો નહિ, કેમ કે, ઈશ્વર તમારા યહોવાહ એકલા જ તમારા માટે લડશે.” ");
INSERT INTO guj2017_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","તે સમયે મેં યહોવાહને આગ્રહપૂર્વક વિનંતી કરીને કહ્યું કે, ");
INSERT INTO guj2017_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“હે પ્રભુ યહોવાહ, તમે તમારા દાસોને તમારી મહાનતા તથા તમારો બળવાન હાથ બતાવ્યો છે; કેમ કે આકાશમાં કે પૃથ્વી પર એવા કયા દેવ છે કે જે તમારા જેવાં કામો તથા તમારા જેવા ચમત્કારો કરી શકે? ");
INSERT INTO guj2017_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","કૃપા કરીને મને પેલી બાજુ જવા દો, યર્દનની પેલી બાજુનો સારો દેશ, સારો પર્વતીય પ્રદેશ તથા લબાનોન પણ મને જોવા દો.” ");
INSERT INTO guj2017_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","પરંતુ તમારે કારણે યહોવાહ મારા પર ગુસ્સે થયા હતા તેમણે મારી અરજ સાંભળી નહિ. અને મને કહ્યું, “તારા માટે આટલું જ બસ છે, આ બાબત વિષે કદી મારી આગળ બોલીશ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","પિસ્ગાહ પર્વતના શિખર પર ચઢ, તારી આંખો ઊંચી કરીને પશ્ચિમબાજુ, ઉત્તરબાજુ, દક્ષિણબાજુ તથા પૂર્વબાજુ જો તારી આંખોથી જોઈ લે, તું આ યર્દનની પાર જવા પામવાનો નથી. ");
INSERT INTO guj2017_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","યહોશુઆને આદેશ આપ; તેને હિંમત તથા બળ આપ, કેમ કે, તે આ લોકોને પેલી પાર લઈ જશે અને જે દેશ તું જોવાનો છે તેનો વારસો તે તેઓને અપાવશે.” ");
INSERT INTO guj2017_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","એ પ્રમાણે આપણે બેથ-પેઓરની સામેની ખીણમાં મુકામ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","હવે, હે ઇઝરાયલ, જે કાયદાઓ અને નિયમો હું તમને શીખવું છું તે ધ્યાનથી સાંભળો અને તેનું પાલન કરો; એ માટે કે તમે જીવતા રહો અને તમારા પિતૃઓના ઈશ્વર યહોવાહ જે દેશ તમને આપે છે, તેમાં પ્રવેશ કરો અને તેને કબજે કરો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","હું તમને જે આજ્ઞા આપું છું તેમાં તમારે કંઈ વધારો કે ઘટાડો કરવો નહિ. એ માટે કે ઈશ્વર તમારા યહોવાહની જે આજ્ઞાઓ હું તમને ફરમાવું તે તમે પાળો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","બઆલપેઓરના લીધે યહોવાહે જે કંઈ કર્યું તે તમારી નજરે તમે જોયું છે; કેમ કે જે બધા માણસો બઆલ-પેઓરને અનુસરતા હતા, તેઓના ઈશ્વર તમારા યહોવાહે તમારી મધ્યેથી નાશ કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","પણ તમે જેઓ ઈશ્વર તમારા યહોવાહને આધીન રહ્યા તેઓ આજે જીવતા રહ્યા છે. ");
INSERT INTO guj2017_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","જુઓ, જેમ ઈશ્વર મારા યહોવાહે મને આજ્ઞા આપી તે પ્રમાણે મેં તમને કાનૂનો અને નિયમો શીખવ્યા છે, કે જેથી જે દેશનું વતન પ્રાપ્ત કરવા માટે તમે તેમાં પ્રવેશ કરો છો તેમાં તમે એ પ્રમાણે કરો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","માટે તે પાળીને તેને અમલમાં લાવો; તેથી લોકોની દ્રષ્ટિમાં તમે જ્ઞાની તથા સમજદાર ગણાશો, જેઓ સર્વ આ કાનૂનો વિષે સાંભળશે તેઓ કહેશે કે, “ખરેખર, આ મહાન દેશજાતિ જ્ઞાની અને સમજદાર છે.” ");
INSERT INTO guj2017_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","કેમ કે એવી કઈ મોટી દેશજાતિ છે કે જેની સાથે કોઈ ઈશ્વર નજીક છે, જેમ ઈશ્વર આપણા યહોવાહને જયારે આપણે પોકારીએ છીએ ત્યારે તે આપણી સાથે સંબંધ રાખે છે. ");
INSERT INTO guj2017_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","બીજી કઈ એવી મહાન જાતિ છે કે તેઓની પાસે આ બધા નિયમો જેને આજે હું તમારી આગળ પ્રગટ કરું છું તેના જેવા ન્યાયી નિયમો તથા કાનૂનો છે? ");
INSERT INTO guj2017_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","ફક્ત પોતાના વિષે સાવધ રહો અને ધ્યાનથી તમારા આત્માની કાળજી રાખો, કે જેથી તમારી આંખે જે જોયું છે તે તું ભૂલી જાઓ નહિ અને તમારા જીવનના સર્વ દિવસો પર્યંત તમારા હૃદયમાંથી તે દૂર થાય નહિ. પણ, તમારા સંતાનને અને તમારા સંતાનના સંતાનને શીખવો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","તમે હોરેબમાં તમારા ઈશ્વર યહોવાહ સમક્ષ ઊભા રહ્યા હતા તે દિવસે યહોવાહે મને કહ્યું કે, “લોકોને મારી સમક્ષ ભેગા કર. હું તેઓને મારાં વચનો કહી સંભળાવીશ અને જે સર્વ દિવસો સુધી તેઓ પૃથ્વી પર જીવે ત્યાં સુધી મારો ડર રાખતા શીખે અને પોતાનાં સંતાનોને પણ તે શીખવે.” ");
INSERT INTO guj2017_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","તેથી તમે આવીને પર્વતની તળેટી નજીક ઊભા રહ્યા અને પર્વત અગ્નિથી બળતો હતો અને જ્વાળાઓ આકાશ સુધી પહોંચતી હતી. ત્યારે વાદળ તથા ઘોર અંધકાર સર્વત્ર વ્યાપી ગયાં હતાં. ");
INSERT INTO guj2017_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","તે વખતે યહોવાહ અગ્નિ મધ્યેથી તમારી સાથે બોલ્યા; તમે તેમના શબ્દોનો અવાજ સાંભળ્યો, પણ તમે કોઈ આકાર જોયો નહિ, તમે ફક્ત અવાજ સાંભળ્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","તેમણે તમને પોતાનો કરાર જાહેર કર્યો એટલે કે દસ નિયમોનું પાલન કરવાની આજ્ઞા ઈશ્વરે તમને આપી. અને એ નિયમો બે શિલાપાટીઓ પર લખ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","તે સમયે યહોવાહે તમને કાયદાઓ તથા કાનૂનો શીખવવાનું મને ફરમાવ્યું, એ સારું કે પેલી પાર જે દેશમાં તમે વતન પ્રાપ્ત કરવા જાઓ છો તેમાં તમે તે પાળો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“માટે પોતાના વિષે સાવધ રહેજો, જે દિવસે તમે હોરેબમાં યહોવાહને અગ્નિ મધ્યેથી તમારી સાથે બોલતા સાંભળ્યા તે દિવસે તમે કોઈ આકાર જોયો ન હતો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","માટે સાવધ રહો કે રખેને તમે ભ્રષ્ટ થઈને કોઈ પ્રકારના આકારની નર કે નારીની પ્રતિમા બનાવો, ");
INSERT INTO guj2017_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","પૃથ્વી પર ચાલનારા કોઈ પશુની કે આકાશમાં ઊડતા પક્ષીની પ્રતિમા, ");
INSERT INTO guj2017_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","અથવા પૃથ્વી તળેના પાણીમાંની કોઈ માછલીની પ્રતિમા બનાવીને તમે ભ્રષ્ટ થશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","સાવધ રહો રખેને જયારે તમે આકાશ તરફ નજર કરો ત્યારે સૂર્ય, ચંદ્ર, તારા એટલે આખું ગગનમંડળ જેઓને ઈશ્વર તમારા યહોવાહે આકાશ નીચેના સર્વ લોકોને વહેંચી આપ્યાં છે. તેઓને જોઈને તમે આકર્ષાઈને તેમની સેવાપૂજા કરો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","પરંતુ યહોવાહ તમને મિસરમાં ધગધગતા લોખંડ ઓગળવાનું ભઠ્ઠીમાંથી બહાર કાઢી લાવ્યા છે. જેથી જેમ આજે છો તેમ તમે તેમના વારસાના લોક બની રહો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","વળી તમારે કારણે યહોવાહ મારા પર શબ્દો વડે કોપાયમાન થયા; અને તેમણે એવા સમ ખાધા કે, “તું યર્દનની પેલે પાર જવા પામશે નહિ. અને ઈશ્વર જે ઉતમ દેશનો વારસો તમને આપે છે તેમાં તું પ્રવેશ પામશે નહિ.” ");
INSERT INTO guj2017_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","હું તો નક્કી આ દેશમાં જ મરવાનો છું, હું યર્દન નદી ઓળંગી શકવાનો નથી. પણ તમે પેલી પાર જશો. અને એ ઉતમ દેશનું વતન પ્રાપ્ત કરશો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","તમે હવે સાંભળો, જે કરાર ઈશ્વર તમારા યહોવાહે તમારી સાથે કર્યો છે તે તમે ભૂલશો નહિ. કોઈ પણ વસ્તુના આકારની કોતરેલી મૂર્તિ જે વિષે યહોવાહ તમારા ઈશ્વરે મના કરી છે તે બનાવશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","કેમ કે ઈશ્વર તમારા યહોવાહ ભસ્મકારક અગ્નિરૂપ તથા ઈર્ષ્યાળુ ઈશ્વર છે. ");
INSERT INTO guj2017_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","તમને સંતાનો અને સંતાનોનાં પણ સંતાનો પણ પ્રાપ્ત થાય અને તમે બધા તે દેશમાં સ્થાયી થયા પછી તમે જો ભ્રષ્ટ થઈને કોઈ પણ વસ્તુના આકારની કોતરેલી મૂર્તિ બનાવશો અને જે ઈશ્વર તારા યહોવાહની નજરમાં અજૂગતું છે તે કરીને તેમને કોપાયમાન કરશો; ");
INSERT INTO guj2017_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","તો હું આજે આકાશ તથા પૃથ્વીને સાક્ષી રાખીને તમને કહું છું કે, યર્દન ઊતરીને જે દેશનું વતન પ્રાપ્ત કરવા તમે જાઓ છો, તેમાંથી જલ્દી તમારો પૂરો નાશ થઈ જશે. તેમાં તમે દીર્ઘાયુષ્ય પામશો નહિ, તેમાંથી તમારો પૂરો નાશ થશે. ");
INSERT INTO guj2017_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","યહોવાહ તમને દેશજાતિઓ મધ્યે વિખેરી નાખશે અને તમને જે દેશજાતિ મધ્યે લઈ જશે તેમની વચ્ચે તમારામાંના બહુ થોડા જ બચવા પામશે. ");
INSERT INTO guj2017_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","અને તમે ત્યાં રહીને માણસનાં હાથનાં ઘડેલાં લાકડાનાં તથા પથ્થરનાં દેવદેવીઓની બનાવેલી મૂર્તિઓ કે જે જોઈ ન શકે કે સાંભળી ન શકે, ખાઈ ન શકે કે સૂંઘી ન શકે, એવા દેવદેવીઓની પૂજા કરશો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","પણ જો તમે ત્યાંથી ઈશ્વર તમારા યહોવાહને શોધશો, જો તમે તમારા પૂરા અંત:કરણથી તથા તમારા પૂરા હૃદયથી તેમની પ્રતિક્ષા કરશો તો તેઓ તમને મળશે. ");
INSERT INTO guj2017_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","જયારે તમે સંકટમાં અને આ સર્વ આફત તમારા પર આવી પડી હોય ત્યારે છેવટે તમે ઈશ્વર તમારા યહોવાહ તરફ પાછો ફરીને તેમનું કહેવું સાંભળશો; તો ");
INSERT INTO guj2017_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","તમારા ઈશ્વર યહોવાહ દયાળુ ઈશ્વર છે; તે તમારો ત્યાગ કરશે નહિ અને તમારો નાશ પણ કરશે નહિ તેમ જ જે કરાર તમારા પિતૃઓની સાથે સમ ખાઈને તેમણે કર્યો છે તેને તે ભૂલી જશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","કેમ કે ઈશ્વરે પૃથ્વી પર માણસનું સર્જન કર્યું ત્યારથી માંડીને તમારી અગાઉનો જે સમય વીતી ગયો છે તેને તથા પૃથ્વીના એક છેડાથી બીજા છેડા સુધી પૂછો કે, પહેલાં કદી આ પ્રમાણેની અદ્દભુત ઘટના બનેલી જોઈ છે કે સાંભળી છે? ");
INSERT INTO guj2017_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","જેમ તમે ઈશ્વરની વાણી અગ્નિ મધ્યે બોલતી સાંભળી તેવી વાણી સાંભળીને કોઈ લોકો કદી જીવતા રહ્યા છે શું? ");
INSERT INTO guj2017_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","અથવા જે સર્વ તમારા ઈશ્વર યહોવાહે મિસરમાં તમારા માટે તમારી નજર સમક્ષ કર્યું તેવું કરીને એટલે પરીક્ષણો, ચિહનો, ચમત્કારો, યુદ્ધ, પરાક્રમી હાથ તથા લંબાવેલા ભુજ તથા મોટાં ત્રાસદાયક કૃત્યો વડે બીજી દેશજાતિઓમાંથી પોતાને માટે દેશજાતિ પ્રાપ્ત કરવાનો શું કોઈ ઈશ્વરે યત્ન કર્યો છે? ");
INSERT INTO guj2017_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","આ બધું તેમણે એટલા માટે કર્યુ કે તમે જાણો કે ઈશ્વર યહોવાહ છે. તેમના વગર બીજા કોઈ ઈશ્વર નથી. ");
INSERT INTO guj2017_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","તેઓ તમને બોધ આપે એ માટે યહોવાહે આકાશમાંથી પોતાની વાણી તમને સંભળાવી. અને તમને પૃથ્વી પર મોટી આગ બતાવી અને તેં તેમના શબ્દો અગ્નિમાંથી સાંભળ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","અને તમારા પિતૃઓ પર તેમને પ્રેમ હતો માટે ઈશ્વરે તેઓની પાછળ તેઓના વંશજોને પસંદ કર્યા હતા. એટલે એ જાતે જ તમને પોતાના સામર્થ્યથી મિસરમાંથી બહાર લઈ આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","એ માટે કે તેઓ તમારા કરતાં મોટી અને સમર્થ દેશજાતિઓને નસાડી મૂકે. અને તેઓના દેશમાં પ્રવેશ કરાવી અને તેઓને વારસો આપે, જેમ આજે છે તેમ. ");
INSERT INTO guj2017_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","એ માટે આજે તમે જાણો અને અંત:કરણમાં રાખો કે આકાશમાં અને પૃથ્વી ઉપર ઈશ્વર તે જ યહોવાહ છે અને તેમના વગર બીજા કોઈ ઈશ્વર નથી. ");
INSERT INTO guj2017_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","તેમના કાનૂનો તથા તેમની આજ્ઞાઓ જેનો આજે હું તમને આદેશ આપું છું તે તમારે પાળવા, કે જેથી તમારું અને તમારા પછી તમારા સંતાનનું ભલું થાય અને ઈશ્વર તમારા યહોવાહ જે દેશ તમને સદાને માટે આપે છે તેમાં તારું આયુષ્ય લાંબુ થાય. ");
INSERT INTO guj2017_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","પછી મૂસાએ યર્દન નદીની પૂર્વ દિશાએ ત્રણ નગરો અલગ કર્યાં, ");
INSERT INTO guj2017_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","એ માટે, જો તેણે અગાઉ કોઈ દુશ્મનાવટ વગર અજાણતાં કોઈ વ્યક્તિને મારી નાખી હોય, તો તે ત્યાંથી નાસી જાય. આ નગરોમાંથી એક નગરમાં નાસી જઈને તે બચી જાય. ");
INSERT INTO guj2017_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","તે નગરો આ હતાં: રુબેનીઓ માટે અરણ્યના સપાટ પ્રદેશમાંનું બેસેર; ગાદીઓ માટે ગિલ્યાદમાંનું રામોથ અને મનાશ્શીઓ માટે બાશાનમાંનું ગોલાન. ");
INSERT INTO guj2017_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ઇઝરાયલી લોકો આગળ મૂસાએ જે નિયમ મૂક્યો તે એ છે; ");
INSERT INTO guj2017_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ઇઝરાયલી લોકો મિસરમાંથી રવાના થયા ત્યારે જે કરારો, નિયમો, કાનૂનો તથા હુકમો મૂસા બોલ્યો તે એ છે, ");
INSERT INTO guj2017_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","અમોરીઓનો રાજા સીહોન, જે હેશ્બોનમાં રહેતો હતો, જેને મૂસા અને ઇઝરાયલી લોકોએ મિસરમાંથી તેઓ બહાર નીકળ્યા ત્યારે તેને હરાવ્યો હતો, તેના દેશમાં યર્દનની પૂર્વ તરફ, બેથ-પેઓરની સામેની ખીણમાં મૂસાએ આ વચનો કહી સંભળાવ્યાં. ");
INSERT INTO guj2017_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","તેઓએ તેના દેશનો તેમ જ બાશાનના રાજા ઓગના દેશનો, યર્દનની પૂર્વ તરફ આવેલા અમોરીના બે રાજાઓના દેશનો કબજો લીધો હતો. ");
INSERT INTO guj2017_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","આ પ્રદેશ આર્નોનની ખીણના કિનારે આવેલા અરોએરથી તે સિયોન પર્વત જે હેર્મોન પર્વત સુધી, ");
INSERT INTO guj2017_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","અને યર્દનની પેલી બાજુ પૂર્વ તરફ, યર્દન નદીની ખીણના બધા મેદાનો, તે છેક પિસ્ગાહ પર્વતના ઢોળાવ નીચે આવેલા અરાબાના સમુદ્ર સુધીનો હતો. ");
INSERT INTO guj2017_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","મૂસાએ બધા ઇઝરાયલીઓને બોલાવીને તેઓને કહ્યું, “હે ઇઝરાયલ, જે કાનૂનો તથા નિયમો હું તમને આજે કહી સંભળાવું છું તે સાંભળો, કે તમે તે શીખો અને તેને પાળો. ");
INSERT INTO guj2017_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","યહોવાહ આપણા ઈશ્વરે હોરેબમાં આપણી સાથે કરાર કર્યો હતો. ");
INSERT INTO guj2017_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","યહોવાહે આપણા પિતૃઓ સાથે આ કરાર કર્યો નહિ પણ આપણી સાથે, એટલે કે આપણે બધા આજે અહીં હયાત છીએ તેઓની સાથે કર્યો. ");
INSERT INTO guj2017_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","યહોવાહ પર્વત પર તમારી સાથે અગ્નિજ્વાળામાંથી પ્રત્યક્ષ બોલ્યા હતા, ");
INSERT INTO guj2017_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","તે સમયે યહોવાહનું વચન તમને સંભળાવવા હું તમારી અને યહોવાહની મધ્યે ઊભો રહ્યો હતો, કેમ કે, તમને અગ્નિથી ભય લાગતો હતો અને તમે પર્વત પર ગયા ન હતા. યહોવાહે કહ્યું. ");
INSERT INTO guj2017_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘ગુલામીના ઘરમાંથી એટલે મિસર દેશમાંથી જ્યાં તમે ગુલામ તરીકે રહેતા હતા ત્યાંથી તમને બહાર કાઢી લાવનાર હું ઈશ્વર તારો યહોવાહ છું. ");
INSERT INTO guj2017_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","મારી સમક્ષ તારે કોઈ પણ અન્ય દેવો હોવા જોઈએ નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","તું પોતાના માટે કોતરેલી મૂર્તિની પ્રતિમા ન બનાવ, ઉપર આકાશમાંની કે નીચે પૃથ્વીમાંની કે પૃથ્વી નીચેના પાણીમાંની કોઈ પણ વસ્તુની પ્રતિમા ન બનાવ. ");
INSERT INTO guj2017_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","તું તેઓની આગળ નમીશ નહિ કે તેઓની પૂજા કરીશ નહિ. કેમ કે, હું યહોવાહ, તમારો ઈશ્વર, ઈર્ષ્યાળુ ઈશ્વર છું. જેઓ મારો તિરસ્કાર કરે છે, તેઓની ત્રીજી ચોથી પેઢી સુધી પિતૃઓના અન્યાયની શિક્ષા સંતાનો પર લાવનાર, ");
INSERT INTO guj2017_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","અને જે લોકો મારા પર પ્રેમ રાખે છે અને મારી આજ્ઞાઓ પાળે છે, તેઓની હજારો પેઢી સુધી મારા કરાર અનુસાર તેઓના પર દયા દર્શાવનાર છું. ");
INSERT INTO guj2017_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","તું યહોવાહ તારા ઈશ્વરનું નામ વ્યર્થ ન લે, કેમ કે, જે કોઈ યહોવાહનું નામ વ્યર્થ લે છે તેને તેઓ નિર્દોષ ગણશે નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","યહોવાહ તારા ઈશ્વરે આજ્ઞા આપી તે મુજબ વિશ્રામવારના દિવસને પવિત્ર પાળવાને તું ધ્યાન રાખ. ");
INSERT INTO guj2017_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","છ દિવસ તું પરિશ્રમ કર અને તારું બધું કામ કર; ");
INSERT INTO guj2017_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","પણ સાતમો દિવસ યહોવાહ તારા ઈશ્વરનો વિશ્રામવાર છે. તેમાં તારે કોઈ પણ કામ કરવું નહિ, તું, તારો દીકરો કે તારી દીકરી, તારા દાસ કે તારી દાસી, તારો બળદ કે તારું ગધેડું કે તારું કોઈ અન્ય જાનવર, તારા દરવાજામાં વસતા કોઈ પણ પરદેશી આ દિવસે કશું કામ ન કરે. જેથી તારા દાસ કે દાસીઓને પણ તારી જેમ આરામ મળે. ");
INSERT INTO guj2017_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","યાદ રાખ કે મિસર દેશમાં તું દાસ હતો, ઈશ્વર તારા યહોવાહ તેમના પરાક્રમી હાથ વડે તથા અદ્દભુત શક્તિ વડે તને મિસરમાંથી બહાર કાઢી લાવ્યા. તે માટે ઈશ્વર તારા યહોવાહે તને વિશ્રામવાર પાળવાની આજ્ઞા આપી છે તે તારે પાળવી. ");
INSERT INTO guj2017_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","ઈશ્વર તારા યહોવાહે તને જેમ આજ્ઞા આપી છે, તેમ તારા માતા અને પિતાનો આદર કર, કે જેથી ઈશ્વર તારા યહોવાહે તને જે દેશ આપ્યો છે તેમાં તારું આયુષ્ય લાંબુ થાય અને તારું ભલું થાય. ");
INSERT INTO guj2017_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","તું હત્યા ન કર. ");
INSERT INTO guj2017_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","તું વ્યભિચાર ન કર. ");
INSERT INTO guj2017_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","તું ચોરી ન કર. ");
INSERT INTO guj2017_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","તું તારા પડોશી વિરુદ્ધ જૂઠી સાક્ષી ન પૂર. ");
INSERT INTO guj2017_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","‘તું તારા પડોશીની પત્ની પર લોભ ન રાખ, તેમ જ તેના ઘર કે ખેતર, દાસ કે દાસી, પશુ, ગધેડું કે અન્ય જાનવર તારા પડોશીનું જે કંઈ હોય તે પર લોભ ન રાખ.’” ");
INSERT INTO guj2017_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","આ વચનો યહોવાહ પર્વત ઉપર અગ્નિજ્વાળા, વાદળ તથા ઘોર અંધકારની મધ્યેથી મોટા સાદે તમારી આખી સભા આગળ બોલ્યા; તેમાં તેમણે કંઈ પણ વધારો કર્યો નહિ. અને ઈશ્વરે મને તે આજ્ઞાઓ બે શિલાપાટીઓ ઉપર લખીને આપી. ");
INSERT INTO guj2017_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","પર્વત જયારે અગ્નિથી ભડભડ બળતો હતો, ત્યારે અંધકારમાંથી નીકળતી વાણી તમે સાંભળી. પછી એમ થયું કે, તમારાં કુળોના સર્વ આગેવાનો અને વડીલો મારી પાસે આવ્યા. ");
INSERT INTO guj2017_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","તમે કહ્યું કે, જો ઈશ્વર આપણા યહોવાહે આપણને પોતાનું ગૌરવ તથા માહાત્મ્ય બતાવ્યું છે. અને અગ્નિ મધ્યેથી તેમની વાણી આપણે સાંભળી છે; આજે આપણે જોયું છે કે ઈશ્વર મનુષ્ય સાથે બોલે છે તેમ છતાં મનુષ્ય જીવતો રહે છે. ");
INSERT INTO guj2017_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","તો હવે અમે શા માટે માર્યા જઈએ? કેમ કે આ મહાભયંકર અગ્નિ તો અમને ભસ્મ કરી નાખશે; જો અમે વધારે વાર અમારા ઈશ્વર યહોવાહની વાણી સાંભળીશું તો અમે માર્યા જઈશું. ");
INSERT INTO guj2017_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","પૃથ્વી પર એવો કયો માણસ છે કે જેણે જીવતા ઈશ્વરની વાણી અગ્નિ મધ્યેથી આપણી જેમ બોલતી સાંભળી હોય અને જીવતો રહ્યો હોય? ");
INSERT INTO guj2017_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","તું પાસે જઈને ઈશ્વર આપણા યહોવાહ જે કહે તે સાંભળ; અને ઈશ્વર આપણા યહોવાહ જે તને કહે તે અમને જણાવજે; અને અમે તે સાંભળીને તેનો અમલ કરીશું.’” ");
INSERT INTO guj2017_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","જયારે તમે મારી સાથે વાત કરતા હતા ત્યારે યહોવાહે તમારો અવાજ સાંભળ્યો; અને યહોવાહે મને કહ્યું કે, ‘આ લોકોએ તને જે કહ્યું છે તે મેં સાંભળ્યું છે. જે સર્વ તેઓ બોલ્યા છે તે તેઓનું કહેવું ઠીક છે. ");
INSERT INTO guj2017_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","જો આ લોકોનું હૃદય એવું હોય કે તેઓ મારો ડર રાખે અને મારી સર્વ આજ્ઞાઓ સદા પાળે તો કેવું સારું! તેથી તે લોકો અને તેઓનાં સંતાનો સદા સુખી રહે. ");
INSERT INTO guj2017_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","જા, તેઓને કહે કે, “તમે તમારા તંબુઓમાં પાછા જાઓ.” ");
INSERT INTO guj2017_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","પણ તું અહીં મારી પાસે ઊભો રહે, એટલે હું તને મારી સર્વ આજ્ઞાઓ, કાયદાઓ અને નિયમો કહીશ; અને પછી તું તે લોકોને શીખવજે, એ સારુ કે જે દેશ હું તેઓને વતન કરી લેવા સારુ આપવાનો છું તેમાં તેઓ તે પાળે. ");
INSERT INTO guj2017_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","માટે ઈશ્વર તમારા યહોવાહે તમને જે આજ્ઞાઓ આપી છે તેનું કાળજી રાખીને તેનું પાલન કરવું અને તમારે તેમાંથી ડાબે કે જમણે હાથે વળવું નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","જે માર્ગ ઈશ્વર તમારા યહોવાહે બતાવ્યો છે તેમાં જ તમારે ચાલવું. એ સારુ કે તમે જીવતા રહો અને તમારું ભલું થાય. અને જે દેશનું વતન તમે પ્રાપ્ત કરવાના છો તેમાં તમારું આયુષ્ય લાંબું થાય. ");
INSERT INTO guj2017_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","હવે જે આજ્ઞાઓ, કાયદાઓ અને નિયમો ઈશ્વર તમારા યહોવાહે તમને શીખવવા માટે મને કહ્યું છે એ સારુ કે જે દેશનું વતન પામવા માટે તમે યર્દન ઊતરીને પ્રવેશ કરો છો, તેમાં તમે તે પાળો. તે આ છે: ");
INSERT INTO guj2017_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","તેથી તું તથા તારો દીકરો તથા તારા દીકરાનો દીકરો તારા આખા જીવનભર યહોવાહ તારા ઈશ્વરનો ડર રાખીને તેમના સર્વ નિયમો અને આજ્ઞાઓ જે હું તમને કહું છું તે પાળો; જેથી તમારું આયુષ્ય લાંબું થાય. ");
INSERT INTO guj2017_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","માટે હે ઇઝરાયલ સાંભળ અને કાળજીપૂર્વક એનું પાલન કર; એ માટે કે, જેમ યહોવાહ તારા પિતૃઓના ઈશ્વરે આપેલા વચન પ્રમાણે દૂધ તથા મધથી રેલછેલવાળો દેશમાં તારું ભલું થાય અને તમે ખૂબ વૃદ્ધિ પામો. ");
INSERT INTO guj2017_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","હે ઇઝરાયલ સાંભળ: યહોવાહ આપણા ઈશ્વર તે એકલા જ યહોવાહ છે. ");
INSERT INTO guj2017_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","અને યહોવાહ તારા ઈશ્વર પર તું તારા પૂર્ણ મનથી તથા પૂર્ણ જીવથી તથા પૂર્ણ બળથી પ્રેમ રાખ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","આ વચનો જે હું તમને ફરમાવું છું તેને તારા અંત:કરણમાં રાખ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","અને ખંતથી તું તારા સંતાનોને તે શીખવ અને જયારે તું ઘરમાં બેઠો હોય કે રસ્તે ચાલતો હોય, જયારે તું સૂઈ જાય કે ઊઠે તેના વિષે વાત કર. ");
INSERT INTO guj2017_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","તું તેમને નિશાની તરીકે તારે હાથે બાંધ અને તારી આંખોમાં તેમને કપાળભૂષણ તરીકે રાખ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","અને તું તેમને તારા ઘરની બારસાખ ઉપર તથા દરવાજા ઉપર તે લખ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","અને એમ થશે કે જયારે યહોવાહ તારા ઈશ્વરે જે દેશ તારા પિતૃઓની સમક્ષ એટલે ઇબ્રાહિમ, ઇસહાક અને યાકૂબની સમક્ષ સમ ખાધા હતા તે દેશમાં તમને લઈ જશે એટલે જે મોટાં અને ઉત્તમ નગરો તમે બાંધ્યાં નથી. ");
INSERT INTO guj2017_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","અને સર્વ પ્રકારની સારી વસ્તુઓથી ભરેલાં ઘર જે તમે ભર્યાં નથી, ખોદી કાઢેલા કૂવા જે તમે ખોઘ્યા નથી તથા દ્રાક્ષવાડીઓ અને જૈતૂનવૃક્ષો જે તમે વાવ્યાં નથી તેમાં લાવે અને તે તમે ખાઈને તૃપ્ત થાઓ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ત્યારે સાવધાન રહેજો, રખેને મિસર એટલે કે ગુલામીના ઘરમાંથી તમને કાઢી લાવનાર યહોવાહ તમારા ઈશ્વરને તમે ભૂલી જાઓ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","યહોવાહ તમારા ઈશ્વરનો ડર રાખો; અને તેમની જ સેવા કરો અને તેમના જ નામના સમ ખાઓ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","તમારી આસપાસના અન્ય દેવદેવીઓની સેવા તમારે કરવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","કારણ કે, તમારી મધ્યે રહેનાર યહોવાહ તમારા ઈશ્વર ઈર્ષ્યાળુ ઈશ્વર છે. રખેને યહોવાહ તમારા ઈશ્વરનો કોપ તમારા પર સળગી ઊઠે અને પૃથ્વીના પટ પરથી તમારો સંહાર કરે. ");
INSERT INTO guj2017_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","જેમ તમે માસ્સામાં તેમની કસોટી કરી, તેમ યહોવાહ તમારા ઈશ્વરની કસોટી કરશો નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","તમારા ઈશ્વર યહોવાહના કાનૂનો, નિયમો અને તેમની આજ્ઞાઓ જે તેમણે ફરમાવ્યાં છે તેનું ખંતથી પાલન કરો. ");
INSERT INTO guj2017_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","અને યહોવાહની નજરમાં જે યોગ્ય અને સારું છે તે તું કર, એ માટે કે તારું ભલું થાય. અને જે ઉત્તમ દેશ તારા પિતૃઓને આપવાના યહોવાહે સમ ખાધા છે તેમાં પ્રવેશ કરીને તું તેનું વતન પામે અને ");
INSERT INTO guj2017_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","જેમ યહોવાહે કહ્યું તેમ તે તારી આગળથી તારા બધા દુશ્મનોને નસાડી મૂકે. ");
INSERT INTO guj2017_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","ભવિષ્યકાળમાં જયારે તારો દીકરો તને પૂછે કે; “યહોવાહ આપણા ઈશ્વરે તમને જે કરારો, નિયમો અને કાનૂનો ફરમાવ્યા છે તેનો અર્થ શો છે?” ");
INSERT INTO guj2017_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ત્યારે તું તારા દીકરાને કહેજે કે, “અમે મિસરમાં ફારુનના ગુલામ હતા; ત્યારે યહોવાહ તેમના મહાન પરાક્રમી હાથ વડે અમને મિસરમાંથી બહાર લાવ્યા, ");
INSERT INTO guj2017_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","અને તેમણે અમારા દેખતાં મિસર પર, ફારુન પર તથા તેના આખા ઘર પર મોટાં અને દુઃખ ભર્યાં ચિહ્નો તથા ચમત્કારો બતાવ્યા; ");
INSERT INTO guj2017_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","તેઓ અમને ત્યાંથી બહાર કાઢી લાવ્યા, કે જેથી આપણા પિતૃઓને જે દેશ આપવાનું વચન આપ્યું હતું તે આપવા માટે તેઓ આપણને તેમાં લઈ જઈ શકે. ");
INSERT INTO guj2017_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","આપણા ભલાને માટે હંમેશા આ બધા નિયમો પાળવાની તથા ઈશ્વરનો ભય રાખવાની તેમણે આપણને આજ્ઞા આપી કે, જેથી તેઓ આપણને જીવતા રાખે, જેમ આજે જીવતા છીએ તેમ. ");
INSERT INTO guj2017_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","યહોવાહ આપણા ઈશ્વરે આપણને જે આજ્ઞાઓ આપી છે, તે પ્રમાણે જો આપણે બધી આજ્ઞાઓ કાળજીથી પાળીએ તો તે આપણા હિતમાં ન્યાયીપણાને અર્થે ગણાશે.” ");
INSERT INTO guj2017_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","જે દેશનું વતન પામવા માટે તું જાય છે ત્યાં યહોવાહ તારા ઈશ્વર તને લઈ જશે, તારી આગળથી અનેક પ્રજાઓને કાઢી મૂકશે, એટલે હિત્તીઓ, ગિર્ગાશીઓ, અમોરીઓ, કનાનીઓ, પરિઝીઓ, હિવ્વીઓ તથા યબૂસીઓ, જે તારા કરતાં મોટી તથા જોરાવર સાત પ્રજાઓ છે; તેઓને ત્યાંથી નસાડી મૂકશે. ");
INSERT INTO guj2017_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","જયારે યહોવાહ તારા ઈશ્વર તને યુદ્ધમાં તેઓની સામે વિજય અપાવે, ત્યારે તું તેઓ પર હુમલો કર અને તેઓનો તદ્દન નાશ કર. તારે તેઓની સાથે કંઈ કરાર કરવો નહિ કે દયા દર્શાવવી નહિ. ");
INSERT INTO guj2017_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","તારે તેઓની સાથે લગ્ન વ્યવહાર રાખવો નહિ; તેમ જ તારે તારી દીકરીઓનાં લગ્